﻿USE sofia;
DROP TABLE IF EXISTS sofia.kfcp_vpl;
CREATE TABLE kfcp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kfcp_vpl WRITE;
INSERT INTO kfcp_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ଇକା ଆଜିନାତ୍‍ ଜିସୁ କ୍ରିସ୍ତଦି ଡକ୍ରାଦାଦ୍‍ସିରି ଦର୍‌କା ଦାଡ଼ି; ୱାନ୍‌ ଦାଉଦଦି କୁଟୁମ୍‌ ମାର୍ହାନ୍‌, ଦାଉଦ ଅବ୍ରାହାମଦି କୁଟୁମ୍‌ ମାର୍ହାନ୍‌ ");
INSERT INTO kfcp_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ଅବ୍ରାହାମ ଇସ୍‍ହାକ୍‍ତି ବୁବାସି । ଇସ୍‌ହାକ୍‌ ଜାକୁବଦି ବୁବାସି । ଜାକୁବ, ଜିହୁଦା ନି ୱାନି ତଡ଼ାନ୍‌କା ବୁବାସି । ");
INSERT INTO kfcp_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ଜିହୁଦା, ପେରସ ନି ସେରହତି ବୁବାସି । ତାମର ୱାରି ଆଇସି । ପେରସ ହେବ୍ରଣତି ବୁବାସି । ହେବ୍ରଣ ଅରାମତି ବୁବାସି । ");
INSERT INTO kfcp_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ଅରାମ ଅମିନାଦବତି ବୁବାସି । ଅମିନାଦବ ନହସନତି ବୁବାସି । ନହସନ ସଲମନତି ବୁବାସି । ");
INSERT INTO kfcp_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ସଲମନ ବୟଜତି ବୁବାସି । ବୟଜକା ଆଇସି ଦରୁ ରାହବ୍, ବୟଜ ଅବେଦତି ବୁବାସି, ରୁତ ଅବେଦକା ଆଇସି ମାର୍ହାତ୍‌, ଅବେଦ ଜେସିଦି ବୁବାସି । ");
INSERT INTO kfcp_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ଜେସି ରାଜା ଦାଉଦତି ବୁବାସି । ଦାଉଦ ସଲମନ୍‍ତି ବୁବାସି, ସଲମନକା ଆଇସି ଆଗ୍‌ଡ଼ି ଉରିୟଦି ଆଡ଼ି ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ସଲମନ୍‍ ରିୟବିୟାମତି ବୁବାସି । ରିୟବିୟାମ ଅବିୟଦି ବୁବାସି । ଅବିୟ ଆସାଦି ବୁବାସି । ");
INSERT INTO kfcp_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ଆସା ଜିହସାପଟତି ବୁବାସି । ଜିହସାପଟ ଜରାମତି ବୁବାସି । ଜରାମ ଉଜିୟଦି ବୁବାସି । ");
INSERT INTO kfcp_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ଉଜିୟ ଜତାମତି ବୁବାସି । ଜୋତମ ଆହାସତି ବୁବାସି । ଆହାସ ହିଜକିୟଦି ବୁବାସି । ");
INSERT INTO kfcp_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ହିଜକିୟ ମନସିଦି ବୁବାସି । ମନସି ଅମନତି ବୁବାସି । ଅମନ ଜସିୟଦି ବୁବାସି । ");
INSERT INTO kfcp_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ଜସିୟ, ଜିକନିୟ ମାରି ୱାନି ତଡ଼ାନ୍‌କା ବୁବାସି । ଇକା ଇସ୍ରାଏଲ୍‌ ଲୋକାଙ୍ଗ୍‌ ଗତିମୁରୁଲି କିଜି ବାବିଲନ୍‍ତୁ ଅନିୱାଲେରି ମାଟା । ");
INSERT INTO kfcp_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ୱାରିଙ୍ଗ୍‌ ବାବିଲନ୍‍ତୁ ଅତି ୱେନ୍‌କା । ଜିକନିୟଦି ମାରିସି ସଲ୍‌ଟିୟେଲ ଜନମ୍‍ଆତାନ୍‍ । ସଲ୍‌ଟିୟେଲ ଜିରୁବ୍‍ବାବେଲତିଙ୍ଗ୍‌ ଜନମ୍‌ କିତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ଜିରୁବ୍‍ବାବେଲ ଅବିହୁଦକା ବୁବାସି । ଅବିହୁଦ ଏଲିୟାକିମ୍‍କା ବୁବାସି । ଏଲିୟାକିମ୍‍ ଅଜ୍‍ଜୁରକା ବୁବାସି । ");
INSERT INTO kfcp_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ଅଜ୍‍ଜୁର ସାଦକକା ବୁବାସି । ସାଦକ ଆକିମ୍‍ତି ବୁବାସି । ଆକିମ୍‍ ଏଲିହୁଦକା ବୁବାସି । ");
INSERT INTO kfcp_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ଏଲିହୁଦ ଏଲାଜାରକା ବୁବାସି । ଏଲାଜାର ମତାନକା ବୁବାସି । ମତାନ ଜାକୁବରି ବୁବାସି । ");
INSERT INTO kfcp_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ଜାକୁବ ଜସେପ୍‌କା ବୁବାସି । ଜୋସେପ୍‌ ମରିୟମ୍‌ତି କନ୍‍ଲି । ମରିୟମତି ପଟାଦାନ୍‍ ଜିସୁ ଜନମ୍‍ଆତାନ୍‍ । ଜିସୁ ମସିହ ଦର୍‌ତାନ୍‌ ବା ୱେଙ୍ଗିଁନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ଇୟାୱାଜା ଅବ୍ରାହାମତି ମାଣାନ୍‌ ଦାଉଦଦି ସାନ୍ଦି ଆତାର୍‌ ପୁରା ସଉଦ କୁଟୁମ୍‌ । ଦାଉଦ ମାଣାନ୍‌ ଗତିମୁରୁଲି ୱାଜା ବାବିଲନ୍‍ତୁ ଇନି ସାନ୍ଦି ସଉଦ କୁଟୁମ୍‌, ମାରି ଗତିମୁରୁଲି ୱାଜା ବାବିଲନ୍‍ତୁ ଇତି ୱେନ୍‍କାରାନ୍‍ କ୍ରିସ୍ତଦି ଜନମ୍‌ ସାନ୍ଦି ଆତାର୍‌ ସଉଦ କୁଟୁମ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ଇକା ଆଜିନାତ୍‍ ଜିସୁ କ୍ରିସ୍ତଦି ଜନମ୍‌ତି ମାଟା ଜିସୁ କ୍ରିସ୍ତଦି ଆଇସି ମାର୍ହାତ୍‌ ମରିୟମ୍‌ । ଜିସୁକ୍ରିସ୍ତଦି ଜନମ୍‌ ଇୟାୱାଜା ଆତାମାର୍ହାତ୍‍ । ମରିୟମ୍‍ତିଙ୍ଗ୍‍ ଜୋସେପ୍‌ତି ୱାଲେ ପେଡ଼ିଆଦେଙ୍ଗ୍‍ ଲସ୍‌ତା ମାର୍ହାର୍‌ । ମାତର୍‌ ପେଡ଼ିଆନି ଆଗ୍‌ଡ଼ି ୱେଙ୍ଗିଁତାତ୍‌ ଜେ ମରିୟମ୍‌ ପବିତ୍ର ଆତ୍ମାଦାନ୍‌ ଗାର୍ବୁଦୁତେବାତାମାନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ଜୋସେପ୍‌ ୱିଜୁୱାଲେ ଦାର୍ମୁଦି ପାଣିକିନିକାନ୍‍ ମାର୍‌ର୍ହାନ୍‍ । ମାରି ମରିୟମତିଙ୍ଗ୍‌ ଲୋକା ଆଗ୍‌ଡ଼ି ନିଦା କିଦେଙ୍ଗ୍‌ ୱାନ୍‌ ବଦା କିଏଜିମାର୍ହାନ୍‍ । ୱାନ୍‌ ଲସାତିତାନେଙ୍ଗ୍‍ ରୁକ୍‍ତେଙ୍ଗ୍‍ ନେସ୍‌ଇୱାଜା ଉପାୟ୍‌କିତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ୱାନ୍‌ ଇକା ଅଡ଼୍‍ବିନିୱାଲେ ଅରେନ୍‍ ପ୍ରବୁଦି ଦୁତ୍‍ ୱାନିଙ୍ଗ୍‌ ଲବେରୁ ତରାଇଆଜି ଇର୍ହାତ୍‌, “ଏ ଦାଉଦ କୁଟୁମ୍‌ତି ଜୋସେପ୍‌, ମରିୟମ୍‌ତିଙ୍ଗ୍‍ ନିଜେଦି ଆଡ଼ି ୱାଜା ଇଡ୍‌ଦେଙ୍ଗ୍‌ ତିଲାମା, ଇରିଙ୍ଗ୍‌ ପବିତ୍ର ଆତ୍ମାଦାନ୍‌ ୱାଦ୍‌ ପଟାଦୁ ଆତାମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ତାନିଙ୍ଗ୍‌ ଅରେନ୍‍ କଡ଼ ଜନମ୍‌ ଆନାନ୍‌ । ମିର୍‌ ୱାନି ଦରୁ ଜିସୁ ଇଡ୍‍ନିଦେର୍‍ । ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ୱାନି ଲୋକାଙ୍ଗ୍‌ ୱାରି ପାପ୍‌ତାନ୍‌ ରକିୟା କିନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ବବିସତ୍‍ବକ୍ତାଦି ମାଣାନ୍‌ ପ୍ରବୁ ଆମାକା ଇର୍ହାମାର୍ହାନ୍‌, ଆକା ସତ୍‍ଆଦେଙ୍ଗ୍‍ ଇକା ଗଟାତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ଆୟା ବବିସତ୍‍ ମାଟା ଆଜିନାତ୍‍, “ଅରେତ୍‌ ରିପା ଗାର୍ବୁଦୁ ତେବାଜି କଡ଼ଦିଙ୍ଗ୍‌ ଜନମ୍‍ସିନାତ୍‍ । ମାରି ଲୋକୁ ଆୟା କଡ଼ଦିଙ୍ଗ୍‌ ଇମାନୁଏଲ ଦର୍‌ତାନ୍‌ ୱେଙ୍ଗ୍‌ଁନାନ୍‌ । ଇମାନୁଏଲଦି ଅର୍ତ ମାପୁରୁ ମା ୱାଲେ ମାନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ଜୋସେପ୍‌ ସୁସ୍‍କାଣ୍‍କାଣ୍‍ ନିଙ୍ଗିଁଜି ପ୍ରବୁଦି ଦୁତ୍‍ ୱାନିଙ୍ଗ୍‌ ଏଣ୍ତେସ୍‌ ଆଦେସ୍‌ ସିତାତ୍‌, ଆୟାୱାଜା କିତାନ୍‌ । ୱାନ୍‌ ମରିୟମ୍‍ତିଙ୍ଗ୍‍ ପେଡ଼ିଆନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ମାତର୍‌ ମରିୟମ୍‌ କଡ଼ଦିଙ୍ଗ୍‌ ଜନମ୍‌ କିଇ ସାନ୍ଦି ୱାନ୍‌ ତାନି ୱାଲେ ଡର୍‍ଏତାମାର୍ହାନ୍‍ । ମାରି ଜୋସେପ୍‌ ଆୟା କଡ଼ଦି ଦରୁ ଜିସୁ ଇଟ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ହେରୋଦ୍‍ ରାଜା ସାସନ୍‍ ସମୟତୁ ଜିହୁଦା ରାଜିଦି ବେତଲିହିମ୍‍ ଗାଡ଼୍‌ତୁ ଜିସୁ ଜନମ୍‍ଆତାନ୍‍ । ତେନି ସାଣେକ୍‌ ସମୟ୍ ୱେନ୍‌କା ପୁର୍ବ ଦେସ୍‌ତି ଏସଲୋକ୍‌ ସୁକେଙ୍ଗ୍‍ ସୁଡ଼୍‌ଜି ୱେର୍‍ନିକାର୍‍ ଜିରୁସାଲମ୍‌ତୁ ୱାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ମାରି ୱାର୍‌ ୱେନ୍‌ବାତାର୍‌, “ଏମେ କଡ଼ ଜିହୁଦିର୍‌ ରାଜା ଆଦେଙ୍ଗ୍‌ ଜନମ୍‍ ଆତାମାନାନ୍‌, ୱାନ୍‌ ଏମେ ? ପୁର୍ବ ଦେସ୍‌ତୁ ୱାନି ସୁକା ସୁଡ଼୍‌ଜି ୱାନିଙ୍ଗ୍‌ ମାଡ଼ିସ୍‍କିଦେଙ୍ଗ୍‍ ମାପ୍‌ ୱାତାମାନାପ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ୱାରି ଇୟା ମାଟା ୱେନ୍‌ଞ୍ଜି ରାଜା ହେରୋଦ ମାରି ଜିରୁସାଲାମ୍‍ତି ୱିଜେରେ ଲୋକୁ ନାଣ୍ତ କାବାଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ହେରୋଦ ୱିଜେରେ ପେରି ଜାଜକର୍‌ ମାରି ଦାର୍ମୁଗୁରୁରିଙ୍ଗ୍‍ କୁକ୍‌ସି ୱାରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ମସିହ ଆମାକାନ୍‍କି କ୍ରିସ୍ତ ଆମାନ୍‍ ଜନମ୍‌ ଆନାନ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ୱାର୍‌ ଇର୍ହାର୍‌, ଜିହୁଦା ରାଜିଦି ବେତଲିହିମ୍‍ତୁ । ଇୟା ବିସୟ୍‌ତାନ୍‌ ଅରେନ୍‍ ବାବବାଦି ରାସ୍‌ତାମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","ଜିହୁଦା ରାଜିଦି ବେତଲିହିମ୍‍, ଜିହୁଦାଦି ପେରି ଗାଡ଼ାକା ଲୋଇ ନିନ୍‌ ଇସ୍ରିକିନ୍ଦା ସିଲେ, ନିବାଣ୍‍କୁ ଅରେନ୍‍ ନେତା ୱାନାନ୍‌, ଇରିଙ୍ଗ୍‌ ନା ଇସ୍ରାଏଲ୍‌ ଲୋକାଙ୍ଗ୍‌ ସାଲାକିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ଇକା ୱେନ୍‌ଞ୍ଜି ହେରୋଦ ପୁର୍ବଦେସ୍‍ତାନ୍‍ ୱାତି ମାର୍‍ଇୱାରିଙ୍ଗ୍‍ ଉଣ୍ତ୍ରି ମାର୍‍କ୍‍ସି ୱାର୍‍ଗିନିସାନି କୁଟୁମ୍‍ତୁ କୁକିସ୍‍ କିଜି ଟିକ୍‌ ଆମା ସମୟ୍‍ତୁ ସୁକା ସତାମାର୍ହାନ୍‍, ୱାରି ମାଣ୍‌କୁ ୱେନ୍‌ବାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ୱେନ୍‌କା ୱାରିଙ୍ଗ୍‌ ବେତଲିହିମ୍‍ ଗାଡ଼୍‍କୁ ପୋକ୍‌ସି ଇର୍ହାନ୍‌, “ସାନ୍‍ଡ୍ରୁ, ଆୟା କଡ଼ଦିଙ୍ଗ୍‌ ନେଗେନ୍‍କିଜି ପୟ୍‌ଦୁ ମାରି ୱାନିଙ୍ଗ୍‌ ପୟ୍‌ତିଙ୍ଗ୍‌ ନାଙ୍ଗିଁ ୱେର୍‍ତୁ, ନାନ୍ ବା ସଲ୍‌ସି ୱାନିଙ୍ଗ୍‌ ମାଡ଼ିସ୍‍କିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ସୁକେଙ୍ଗ୍‍ ସୁଣିକାର୍‍ ରାଜାଦି ମାଟା ୱେନ୍‌ଜି ଆୟା ବାଡି ଡ଼ିସ୍‌ସି ମାରିଡ଼େସି ୱାରି ସନି ସାରିଦୁ ସନିୱାଲେ, ୱେଡ଼ା ସନି ତରିଟି ବାଦଡ଼୍‍ତୁ ସୁଡ଼ୁତିମାର୍‍ଇ ଆୟା ସୁକା ମାରିଡ଼େସି ତରାତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ସୁକାଦିଙ୍ଗ୍‍ ସୁଡ଼୍‌ଜି ୱାରି ଏସା ୱେଡ଼ିକା ଏସା ୱେଡ଼ିକା ଆଜି ନିଙ୍ଗିଁତାର୍‍ ୱାର୍‌ ୱାରି ଆଗ୍‌ଡ଼ି ଆଗ୍‌ଡ଼ି ବୁଲାଜି ସୁକା କଡ଼ ମାର୍‍ଇ ଇଲୁ ମୁସ୍‌କୁ ତେବାତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ୱାର୍‌ ଆୟା ଇଲୁ ଲୋଇ ଡ଼ୁଗିତାର୍‍ ମାରି କଡ଼ଦିଙ୍ଗ୍‌ ଆଇସି ମରିୟମ୍‌ତି ୱାଲେ ସୁଡ଼୍‌ଜି ମେଣ୍ତେଙ୍ଗ୍‍ଗଟ୍‍କିଜି ୱାନିଙ୍ଗ୍‌ ମାଡ଼ିସ୍‍କିତାର୍‍ ମାରି ଅର୍‌ସେ ତାତିମାର୍‍ଇ ବାଙ୍ଗାଁରାମ୍‍, କୁନ୍ଦୁରୁ ନି ବାସ୍‌ନା ନିୟୁ ସପ୍‍ସି ୱାନିଙ୍ଗ୍‌ ଦାନ୍‍ ସିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ଇୟା ୱେନ୍‌କା ୱାର୍‌ ଆଇ ଉଣ୍ତ୍ରି ସାରି ସିଜି ନିଜେଦି ଦେସ୍‌ତୁ ସର୍ହାର୍‍ । ଇରିଙ୍ଗ୍‌ ହେରୋଦଦି ଲାକ୍‌ତୁ ଡ଼େସି ସଲ୍‍ଇ ଉଣ୍ତିଙ୍ଗ୍‌ ମାପୁରୁ ୱାରିଙ୍ଗ୍‌ ଲବେରୁ ଆଦେସ୍‌ ସିତାମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ସୁକେଙ୍ଗ୍‍ସୁଣିକାର୍‍ ସର୍‌ଇ ୱେନ୍‌କା ମାପୁରୁଦି ଦୁତ୍‍ ଜୋସେପତିଙ୍ଗ୍‍ ଲବେରୁ ତରାଇଆଜି ଇର୍ହାତ୍‌, “ହେରୋଦ କଡ଼ଦିଙ୍ଗ୍‌ କାତ୍‍ତେଙ୍ଗ୍‍ ପୟ୍‌ନାନ୍‌ । ଆଦେଙ୍ଗ୍‌ ନିଙ୍ଗିଁଆ, କଡ଼ଦିଙ୍ଗ୍‌ ନି ୱାନି ଆଇସିଙ୍ଗ୍‍ ଅସି ମିସର୍‍ ଦେସ୍‌ତୁ ଉରୁକ୍‍ତୁ । ଆୟା ବାଡି ନାନ୍ ଡ଼ିସ୍‍ତେଙ୍ଗ୍‍ଁ ଇନ୍‌ଇ ସାନ୍ଦି ଆବେ ତେବାଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ଜୋସେପ୍‌ ନିଙ୍ଗିଁଜି କଡ଼ ନି ୱାନି ଆଇସିଙ୍ଗ୍‍ ଅସି ଆୟାନାଡ଼ା ମିସର୍‍ତୁ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ସତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ହେରୋଦଦି ସାନି ସାନ୍ଦି ଆବେ ୱାର୍‌ ତେବାତାର୍‌ । ଇୟାୱିଜୁ ଗଟାନି ମାଣ୍‌କୁ ବାବବାଦିଦି ମାଣାନ୍‌ ପ୍ରବୁଦି ମାଟା ସତ୍‌ ଆତାତ୍‌ । ୱାନ୍‌ ଇର୍‌ଆ ମାର୍ହାନ୍‍, “ନା ମାରିନ୍‍ତିଙ୍ଗ୍‍ ନାନ୍ ମିସର୍‍ ଦେସ୍‍ତାନ୍‍ କୁକ୍‌ତା ତାତା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ପୁର୍ବ ଦେସ୍‍ତାନ୍‍ ୱାତିମାନି ସୁକେଙ୍ଗ୍‍ସୁଣିକାର୍‍ ୱାନିଙ୍ଗ୍‌ ବାଣ୍ତିସ୍‍କିଜି ସର୍ହାମାନାର୍‍ ନେସ୍‌ସି, ହେରୋଦ ରିସାଆତାନ୍‍ ମାରି ବେତଲିହିମ୍‍ ନି ତାନି ଲାକ୍‌ତୁରି ରାଜିଆଙ୍ଗାଁ ମାନି ଦୁଇ ବାର୍ସୁ ନି ତାନେଙ୍ଗ୍‌ ଉଣା ବାର୍‍ସେକ୍‍ତି ୱିଜେରେ କଡ଼ରିଙ୍ଗ୍‌ କାତ୍‍ତେଙ୍ଗ୍‍ ଇଜି ଆଦେସ୍‌ ସିତାନ୍‌ । ସୁକା ସତିମାର୍‍ଇ ୱେଡ଼ା ବିସୟ୍‌ତାନ୍‌ ସୁକେଙ୍ଗ୍‍ସୁଣିୱାରିମାଣ୍‍କୁ ୱାନ୍‌ ଆମାକା ୱେର୍‍ହାମାର୍ହାନ୍‍, ଆୟା ଇସାବ୍‌ତାନ୍‌ ୱାନ୍‌ କଡ଼ରି ବାର୍ସୁଦି ଜଗ୍‌ ତିଆର୍‌ କିତାମାର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ନାସ୍ତିୱାଲେ ଜିରିମିୟ ବାବବାଦି ମାଣାନ୍‌ ରାସ୍‍ତିମାର୍‍ଇ ଇୟା ବାକ୍ୟ ସତ୍‌ ଆତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“ରାମା ଗାଡ଼୍‌ତୁ ଆଉଲି ୱାଜିନାତ୍‍, ତାନି ଦୁକ୍‍ତୁ ଆଡ଼୍‍ବାନି ବଲ୍ । ରାହେଲ୍ ତାନି କଡ଼ରି ଉଣ୍ତିଙ୍ଗ୍‌ ଆଡ୍‌ବାଜିନାତ୍‌; ତାନେଙ୍ଗ୍‌ ଏଣ୍ତେସ୍‌ ନାନି ବାସାଦାନ୍ ସୁକ୍‌ ସିଦେଙ୍ଗ୍‍ ଆଏଜିନାତ୍‍, ଇରିଙ୍ଗ୍‌ ୱାର୍‌ ୱିଜେରେ ସାତାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ହେରୋଦଦି ସାତି ୱେନ୍‌କା ପ୍ରବୁଦି ଦୁତ୍‍ ମିସର୍‍ତୁ ଜୋସେପତିଙ୍ଗ୍‍ ଲବେରୁ ତରାଇଆଜି ଇର୍ହାତ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“ନିଙ୍ଗିଁଆ, କଡ଼ଦିଙ୍ଗ୍‌ ନି ୱାନି ଆଇସିଙ୍ଗ୍‍ ଆସ୍‌ସି ଇସ୍ରାଏଲ୍‌ ଦେସ୍‌ତୁ ଡ଼େସି ସାଙ୍ଗ୍‍ଆ । ଇରିଙ୍ଗ୍‌ ଏର୍‌ ୱାନି ଜିବନ୍‌ ଅତେଙ୍ଗ୍‍ ବଦାକିଜିମାର୍ହାର୍‍, ୱାର୍‌ ସାତାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ଆବେଟ୍‌ ଜୋସେପ୍‌ ନିଙ୍ଗିଁଜି କଡ଼ ନି ମରିୟମ୍‍ତିଙ୍ଗ୍‍ ଆସ୍‌ସି ଇସ୍ରାଏଲ୍‌ ଦେସ୍‌ତୁ ଡ଼େସି ସର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ମାତର୍‌ ହେରୋଦଦି ୱେନ୍‌କା ୱାନି ମାରିସି ଆର୍କିଲାୟ, ଜିହୁଦାଦି ରାଜା ଆତାମାନାନ୍‌ ୱେନ୍‌ଞ୍ଜି ୱାନ୍‌ ଗାଲିଲି ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ତିଲାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ମାତର୍‌ ଲବେରୁ ମାଟା ୱେନ୍‌ଞ୍ଜି ୱାନ୍‌ ଗାଲିଲି ରାଜିଦୁ ସର୍ହାନ୍‍, ମାରି ନାଜରିତ ଦର୍‌ତି ଗାଡ଼୍‌ତୁ ଇଲୁ କିଜି ତେବାତାନ୍‌ । ଆବେଟ୍‌ ବାବବାଦିରି ମାଣାନ୍‌ ରାସାତି ଉଣ୍ତ୍ରିବାକ୍ୟ ସତ୍‌ ଆତାତ୍‌ । “ୱାନ୍‌ ନାଜରିୟତିୟ ଇଜି ୱେଙ୍ଗ୍‍ଁନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ଆୟା କାଡ଼ାଦୁ ଡୁବନ୍‌ ସିନି ଜୋହନ ଜିହୁଦା ଦେସ୍‌ତି ବାଲିବୁମିଦୁ ୱାଜି ପ୍ରଚାର୍‌ କିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ୱାନ୍‌ ଇର୍ହାନ୍‌, “ପାପ୍‌ତାନ୍‌ ମନ୍‍ତିଙ୍ଗ୍‍ ଡ଼େପ୍‍ତୁ, ଇରିଙ୍ଗ୍‌ ମାପୁରୁଦି ରାଜି ଇଗା ୱାଜିନାତ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ବାବବାଦି ଜିସାୟ ଏମେୱାନି ବିସୟ୍‌ତାନ୍‌ ଇର୍ହାମାର୍‌ର୍ହାନ୍‌, ଯୋହନ ନେ ଆୟା ଲୋକୁ । “ବାଲି ବୁମିଦୁ ଏନ୍‌ ଅରେନ୍‍ ଆଉଲି ଆଜି ଇଜିନାନ୍‌, ପ୍ରବୁଦି ଉଣ୍ତିଙ୍ଗ୍‌ ସାରି ରସ୍‍ଆ; ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ଉଣ୍ତ୍ରି ସାଡ଼ୁକୁ ରାସ୍ତା ତିଆର୍‌ କିଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ଯୋହନତି ଆଙ୍ଗିଁଙ୍ଗ୍‌ ଉଟ୍‌ ବୁର୍‍ବୁସାଦାନ୍‍ ତିଆର୍‌ ଆତାମାର୍ହାତ୍‍ । ୱାନ୍‌ ୱାନି ଜୁକିଦୁ ଉଣ୍ତ୍ରି ତଲ୍‍ତି ନାସ୍‍ ତରାଜିମାର୍ହାନ୍‍ । ମାଡ଼ିମାଉ ନି ଗରନ୍‌ ପୁକି ୱାନି କାଦି ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ଜିରୁସାଲାମ୍‍ ଗାଡ଼୍‌ତାନ୍‍, ୱିଜୁ ଜିହୁଦା ରାଜିଦାନ୍‍ ମାରି ଜର୍ଦନ ଗାଡା ଲାକ୍‌ତୁରି ୱିଜୁ ନାର୍‍କାଣ୍‍ ଲୋକୁ ୱାନି ଲାକ୍‌ତୁ ୱାଜିମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ୱାର୍‌ ନିଜେ ନିଜେଦି ପାପ୍‌ ୱେର୍‌ସି ଯୋହନତି ମାଣାନ୍‌ ଜର୍ଦନ ଗାଡାଦୁ ଡୁବନ୍‌ ଅସିମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ଏସ୍ତିୱାଲେ ଯୋହନ ସୁଡ଼ୁତାନ୍‌ ନାଣ୍ତ ପାରୁସିର୍‌ ନି ସାଦୁକିର୍ ଡୁବନ୍‌ ଅତେଙ୍ଗ୍‌ ୱାଜିନାର୍‍; ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଏ ବିସ୍‌ମାନି ସାରାସ୍‍ତି କୁଟୁମ୍‌ ମାପୁରୁ ମିଙ୍ଗିଁ ଏମେ ଦଣ୍ଡ୍‌ ସିଦେଙ୍ଗ୍‍ସଲ୍‍ସିନାନ୍‍, ଆବେଣାନ୍‍ ରକିୟା ପଇଦେଙ୍ଗ୍‍ ଆଟ୍‍ନିଦେର୍‍ଇଜି ଏନ୍‌ ମିଙ୍ଗିଁ ଇର୍ହାନ୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ଜଦି ସତ୍‌ତାନ୍‌ ପାପ୍‌ ପାଣିଦାନ୍‌ ମନ୍‍ ଡ଼େପ୍‍ତି ମାନିଦେର୍‌, ଇକା ମି ନେଗି ପାଣିଦାନ୍‌ ତର୍‌ତୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ଅବ୍ରାହାମ ମା ବୁବା, ମୋନ୍‌ତୁ ମୋନ୍‌ତୁ ବା ଇୟାୱାଜା ଇନ୍‌ମାଟ୍‌ । ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା ଜେ ମାପୁରୁ ଇୟା କାଲ୍‍କାଙ୍ଗ୍‍ ଅସି ଅବ୍ରାହାମତି କୁଟୁମ୍‌ ତିଆର୍‌କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ମାରାକା ମଦଲ୍‍କୁ କାତ୍‍ତେଙ୍ଗ୍‍ ଇଜି ପାଡ଼ିସି ତିଆର୍‍କିତା ଇଟ୍‌ତାମାନାର୍‌ । ଏମେ ମାରାତୁ ନେଗି ପଲ୍‌ ରେଏତ୍‌, ଆକା କାତାଜି ସିସୁଦୁପକାନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","ମିର୍‌ ପାପ୍‌ତାନ୍‌ ମନ୍‍ତିଙ୍ଗ୍‍ ଡ଼େପ୍‍ତିମାନିଦେର୍‍, ଇକା ୱେର୍‌ତେଙ୍ଗ୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଏର୍‌ତୁ ଡୁବନ୍‌ ସିଜିନା । ମାତର୍‌ ନା ୱେନ୍‌କା ଏନ୍‌ ୱାଜିନାନ୍‍, ୱାନ୍‌ ମିଙ୍ଗିଁ ପବିତ୍ରଆତ୍ମା ନି ସିସୁଦୁ ଡୁବନ୍‌ ସିନାନ୍‍ । ୱାନ୍‌ ନାବାଣାନ୍‍ ପେରିକାନ୍‌ ୱାନି ଜୁତେଙ୍ଗ୍‌ ପିଣ୍ତ୍‍ଦେଙ୍ଗ୍‍ ବା ନାନ୍ ଜଗ୍‌ ସିଲେ । ");
INSERT INTO kfcp_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ପାସିଦାନ୍‍ ପଟୁ ୱିଜୁ ଟୁଟ୍‍ତେଙ୍ଗ୍‍ ଇଜି ୱାନି କିୟୁଦୁ ସେରିଇ ମାନାତ୍‌ । ୱାନ୍‌ ପାସି ୱିଜୁ ୱାନି କଲ୍‍କିଆଙ୍ଗ୍‍ଁ ଇଡ୍‌ନାନ୍‌ ମାରି କୁଲିଙ୍ଗ୍‌ ପଟୁ ୱିଜୁ ଏସାଙ୍ଗ୍‍ ନାମ୍‍ଇ ସିସୁଦୁ ଆଡ଼ାକ୍‌ନା ପକ୍‍ନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ନାସ୍ତିୱାଲେ ଜିସୁ ଗାଲିଲିଦାନ୍‌ ୱାଜି ଡୁବନ୍‌ ଅତେଙ୍ଗ୍‌ ଜର୍ଦନ ଗାଡାଦୁ ଯୋହନତି ଲାକ୍‌ତୁ ଇଗା ୱାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ମାତର୍‌ ଯୋହନ ଜିସୁଙ୍ଗୁଁ ମାନାକିଜି ଇର୍ହାନ୍‌, “ନାନ୍ ଗାଦେ ନି ମାଣ୍‌କୁ ଡୁବନ୍‌ ଅନିମାଟା ନିନ୍‌ ଆରିଙ୍ଗ୍‍ବା ନା ଲାକ୍‌ତୁ ୱାତିମାନି ?” ");
INSERT INTO kfcp_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ମାତର୍‌ ଜିସୁ ଇର୍ହାନ୍‌, “ଇଲେଇ ନା ମାଟାଦୁ ରାଜିଆଆ । ଇରିଙ୍ଗ୍‌ ଇୟାମାଣ୍‍କୁ ମାଡୁ ମାପୁରୁଦି ବଦାଦି ପାଣି କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ନିକା ।” ଆବେଟ୍‌ ଯୋହନ ୱାନିଙ୍ଗ୍‌ ଡୁବନ୍‌ ସିଦେଙ୍ଗ୍‍ ରାଜିଆତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ଜିସୁ ଡୁବନ୍‌ ଅସି ଏର୍‍ତାନ୍‍ ନିଙ୍ଗିଁଜି ୱାତି ଦାପ୍ରେ ୱାନ୍‌ ସୁଡ଼ୁତାନ୍‌ ମୁସ୍‌କୁପୁର୍‌ ରେଆତାମାନାତ୍‍ ମାରି ପବିତ୍ର ଆତ୍ମା ପାର୍‍ୱାଦି ୱାଜା ରେତାଜି ୱାଜି ୱାନି ମୁସ୍‌କୁ ବାସ୍‌ତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ତାନିୱେନ୍‍କା ମୁସ୍‌କୁପୁର୍‌ତାନ୍‌ ବଲ୍ ୱାତାତ୍‍, “ଇକାନ୍‌ ନା ଲାଡ୍‍ତି ମାରିନ୍‌, ୱାନିମାନୁ ନାନ୍ ୱେଡ଼ିକା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ଇୟା ୱେନ୍‌କା ପବିତ୍ରଆତ୍ମା ଜିସୁଙ୍ଗୁଁ ସିମ୍ରା ବାଡିଦୁ ଅତାତ୍‍ । ଆବେ ୱାନ୍‌ ସୟତାନ୍‍ତି ମାଣାନ୍‌ ପରିକା କିଆୟ୍‍ଆତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ସାଲିସ୍‍ ଦିନ୍‌ ନି ସାଲିସ୍‍ ନାଡ଼ା ଉପାସ୍‌ ତେବାତି ୱେନ୍‌କା ଜିସୁ ବାଙ୍ଗାଁ ସାତାନ୍ । ");
INSERT INTO kfcp_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ନାସ୍ତିୱାଲେ ସୟତାନ୍ ୱାନି ଲାକ୍‌ତୁ ୱାଜି ଇର୍ହାତ୍‌, “ନିନ୍‌ ଜଦି ମାପୁରୁଦି ମାରିନ୍‌, ଇୟା କାଲ୍‍କାଙ୍ଗ୍‍ ରୁଟିଙ୍ଗ୍‌ ଆଦେଙ୍ଗ୍‌ ଆଦେସ୍‌ ସିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ମାତର୍‌ ଜିସୁ ଇର୍ହାନ୍‌, “ଦାର୍ମୁସାସ୍ତ୍ରଦୁ ରାସାତାମାନାତ୍‌, ଲୋକୁ ଆବ୍‍କା ରୁଟିଦାନ୍‌ ଜିଏନ୍‍ । ମାତର୍‌ ମାପୁରୁଦି ୱେୟୁଦାନ୍‌ ସନି ୱିଜୁ ବାକ୍ୟ ୱାନି ଜିବନ୍‌ତି ଉଣ୍ତିଙ୍ଗ୍‌ ଦର୍‌କାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ଇୟା ୱେନ୍‌କା ସୟତାନ୍ ଜିସୁଙ୍ଗୁଁ ପବିତ୍ର ଗାଡ଼୍‌ ଜିରୁସାଲାମ୍‍ତୁ ଅତାତ୍‍ । ଆବେ ୱାନିଙ୍ଗ୍‌ ମନ୍ଦିରତି ସାତ୍ ମୁସ୍‌କୁରି ଟିପୁଦୁ ନିଲ୍‌ପିସ୍‌କିଜି ୱାନିଙ୍ଗ୍‌ ୱେର୍‌ତାତ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ନିନ୍‌ ଜଦି ମାପୁରୁଦି ମାରିସି, ଇବେଣ୍‌କୁ ଆଡ୍‍ଗି ଗାତ୍‍ଆ । ଦାର୍ମୁସାସ୍ତ୍ରଦୁ ରାସାତାମାନାତ୍‌, ମାପୁରୁ ନି ସାକା ଅତେଙ୍ଗ୍‌ ମୁସ୍‌କୁପୁର୍‌ତି ଦୁତ୍‌କାଙ୍ଗ୍‌ ଆଦେସ୍‌ ସିନାନ୍‍ । ୱାକ୍‍ ନିଙ୍ଗିଁ କିକାଣ୍‌କୁ ପେର୍‍ଜିଆସ୍‍ନେ । ଆବେଟ୍‌ ନି ପାଦାମ୍‍ଆଙ୍ଗ୍‍ଁ କାଲ୍‍କାଣି ସିନାଆଟ୍‍ଏତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ଜିସୁ ଇର୍ହାନ୍‌, “ଦାର୍ମୁସାସ୍ତ୍ରଦୁ ରାସାତାମାନାତ୍‌, ନିନ୍‌ ପ୍ରବୁ ନିଜେଦି ମାପୁରୁଙ୍ଗ୍‌ ପରିକା କିମା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ୱେନ୍‌କା ସୟତାନ୍ ୱାନିଙ୍ଗ୍‌ ଉନ୍‍ଣ୍ତ୍ରି ନିର୍‍ଇ ଗରନ୍‍ତି ଟିପୁଦୁ ଅତାତ୍‍ ମାରି ୱାନିଙ୍ଗ୍‌ ସାରାଦୁନିଆଦି ୱିଜୁ ରାଜିଦି ଦନ୍‌ ସମ୍ପତ୍ତି ତର୍‌ସି ଇର୍ହାତ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“ଜଦି ନିନ୍‌ ମେଣ୍ତେଙ୍ଗ୍‍ ଗଟ୍‌କିଜି ନାଙ୍ଗିଁ ମାଡ଼ିସ୍‌କିନି, ଇୟାୱିଜୁ ନିଙ୍ଗିଁ ନାନ୍ ସିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ଜିସୁ ଇର୍ହାନ୍‌, “ଆକ ଆଆ ସୟତାନ୍ ! ଦାର୍ମୁସାସ୍ତ୍ରଦୁ ରାସାତାମାନାତ୍‌, କେବଲ୍‌ ନି ପ୍ରବୁ ମାପୁରୁଙ୍ଗ୍‍ଁ ମାଡ଼ିସ୍‌ କିଆ ମାରି ୱାନି ସେବା କିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ନାସ୍ତିୱାଲେ ସୟତାନ୍ ଜିସୁଙ୍ଗୁଁ ଡ଼ିସ୍‌ତା ସର୍ହାତ୍‌, ମୁସ୍‌କୁପୁର୍‌ତି ଦୁତ୍‌କୁ ୱାଜି ଜିସୁଦି ସେବାକିତେ । ");
INSERT INTO kfcp_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ଯୋହନତିଙ୍ଗ୍‌ ଜଇଲ୍‌ତୁ ଇଟ୍‌ତାମାନାର୍‌ ଇଜି ୱେନ୍‌ଞ୍ଜି ଜିସୁ ଗାଲିଲି ରାଜିଦୁ ସର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ମାତର୍‌ ନାଜରିତଦୁ ତେବାଏଣ୍ତା ସବୁଲୁନ ନି ନପ୍‍ତାଲି ରାଜିଦୁ ମାନି ଗାଲିଲି ଗାଡା ପାଡ଼ିଦୁ ମାନି କପର୍‍ନାହୁମ୍‍ତୁ ବାସାତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ଇୟାମାଣାନ୍‍ ଜିସାୟ ବାବବାଦିଦି ମାଟା ସତ୍‌ ଆତାତ୍‌, ୱାନ୍‌ ଇର୍ହାମାର୍‌ର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“ସବୁଲୁନ ଦେସ୍‌ ମାରି ନପ୍‍ତାଲି ଦେସ୍‌, ସାମ୍‌ଦୁର୍‌ ଲାକ୍‌ତୁରି, ନି ଜର୍ଦନ ଗାଡା ଆୟା ପାଡ଼ିଦି, ଅଣଜିହୁଦିରି ଗାଲିଲି ! ");
INSERT INTO kfcp_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ସିକାଟିଦି ନିଡ଼୍‍ଗାଦୁ ବାସାକିଜିମାନି ଲୋକୁ ଉନ୍‍ଣ୍ତ୍ରି ପେରି ଜାୟ୍‌ ସୁଣାର୍‍ ସାନି ସିକାଟିଦି ରାଜିଦୁ ମାନି ଲୋକା ମୁସ୍‌କୁ ଆୟା ଜାୟ୍‌ ତରାଇଆନାତ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ଆୟା ସମୟତାନ୍‍ ଜିସୁ ପ୍ରଚାର୍‌କିଜି ଇର୍ହାନ୍‌, “ପାପ୍‌ତାନ୍‌ ମନ୍‍ତିଙ୍ଗ୍‍ ଡ଼େପ୍‍ତୁ, ଇରିଙ୍ଗ୍‌ ମାପୁରୁଦି ରାଜି ଇଗା ୱାଜିନାତ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ଜିସୁ ଗାଲିଲିଦି ସାମ୍‌ଦୁର୍‌ ପାଡ଼ି ସିଜି ବୁଲାଜିମାନିୱାଲେ ସିମୋନ୍‌ ପିତର ମାରି ଆନ୍ଦ୍ରିୟ ଦର୍‌ତି ରିଏର୍‌ ମିନ୍‌କୁ ଆସ୍‍ନିୱାରିଙ୍ଗ୍‍ ବେଟ୍‌ବୁଡ଼ାତାନ୍‌ ! ଇୟା ରିଏର୍‌ ତଡ଼ାନ୍‌କୁ ଜାଡ଼ି ପକ୍‍ସି ଗାଡାଦୁ ମିନ୍‌କୁ ଆସ୍‍ସିମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ଜିସୁ ୱାରିଙ୍ଗ୍‌ କୁକ୍‌ସି ଇର୍ହାନ୍‌, “ନା ୱାଲେ ରାଦୁ । ନାନ୍ ମିଙ୍ଗିଁ ଲୋକାଙ୍ଗ୍‌ ମାପୁରୁ ଲାକ୍‌ତୁ ତାନିକା ଅଜାକିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ୱାର୍‌ ଆୟାଦାପ୍ରେ ୱାରି ଜାଡ଼ି ଡ଼ିସ୍‌ସି ଜିସୁୱାଲେ ୱାଲେ ସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ଜିସୁ ଅଡ଼ପ୍‍ ଆଗ୍‌ଡ଼ି ସଲ୍‌ସି ରିଏର୍‌ ତଡ଼ାନ୍‍ ଜାକୁବ ମାରି ଯୋହନ ଦର୍‌ତି ଜେବଦଦି ରିଏର୍‌ ମାରିସିରିଙ୍ଗ୍‌ ବେଟ୍‌ବୁଡ଼ାତାନ୍‌ । ଇୟା ତଡ଼୍‍ ରିଏର୍‌ ମାରି ୱାରି ବୁବାସି ଡଙ୍ଗାଁଦୁ ବାସ୍‌ସି ୱାରି ଜାଡ଼ି ମଦାକିଜିମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ବା କୁକ୍‍ତାନ୍‍ ମାରି ୱାର୍‌ ଦାପେ ଦାପେ ଡଙ୍ଗାଁ ନି ବୁବାସିଙ୍ଗ୍‍ ଡ଼ିସ୍‌ସି ଜିସୁୱାଲେ ୱାଲେ ସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ଜିସୁ ୱିଜୁ ଗାଲିଲି ରାଜି ସୁଡ଼୍‌ଜି ୱିସ୍‍ସି ପାର୍‍ତନାକିନି ଇଲ୍‌କାଙ୍ଗ୍‌ ସିକିୟା ସିଦେଙ୍ଗ୍‍ଆସ୍‍ତାନ୍‍ । ମାପୁରୁଦି ରାଜିଦି ସୁସମାଚାର୍‌ ପ୍ରଚାର୍‌ କିତାନ୍‌ ମାରି ରକମ୍‌ ରକମ୍‌ତି ରଗ୍‌ ନି କାସ୍ଟୁଦୁକା ଆତି ଲୋକାଙ୍ଗ୍‌ ନେଗେନ୍‌କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ୱାନି ବିସୟ୍‌ତାନ୍‌ ସିରିଆ ଦେସ୍‌ ୱିଜୁ ତରିନ୍‌ ୱେଙ୍ଗିଁତା ସର୍ହାତ୍‍ ମାରି ଲୋକୁ ଦୁବାକାସ୍ତିୱାରିଙ୍ଗ୍‍, ମୁର୍ଚା ରୋଗ୍‌ ଆସ୍‍ତିକାର୍‍ ମାରି ପକିୟାଗାତ୍‍ ରଗ୍‌ ୱିଜୁ ରକମ୍‌ତି ରଗ୍‍ତୁ ମାନି ଲୋକାଙ୍ଗ୍‌ ମାରି ୱିସାମ୍‍ତୁ ମାନି ୱିଜୁ ଲୋକାଙ୍ଗ୍‌ ୱାନି ଲାକ୍‌ତୁ ତାତାର୍‌, ମାରି ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ନେଗେନ୍‌କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ମାରି ଗାଲିଲି, ଦେକାପଲି ରାଜି, ଜିରୁସାଲାମ୍‍, ଜିହୁଦା ଦେସ୍‍ ମାରି ଜର୍ଦନ ଗାଡା ଆୟା ପାଡ଼ିଦାନ୍‍ ନାଣ୍ତ ଲୋକୁ ୱାଜି ୱାନି ୱାଲେ ସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ଜିସୁ ଲୋକୁ ଗହଲି ସୁଡ଼୍‌ଜି ଉନ୍‍ଣ୍ତ୍ରି ଗରନ୍‌ ମୁସ୍‌କୁ ସର୍ହା ବାସ୍‌ତାନ୍‌ । ସିସୁର୍‍ ୱାନି ସାରିବେଡ଼୍‍ତି ଉଣ୍ତାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ଲୋକାଙ୍ଗ୍‌ ଜିସୁ ସିକିୟା ସିଜି ଇର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","ମାପୁରୁମାନୁ ଏମାକାର୍‌ ଆସା ଇଡ୍‌ନି, ଲୋକୁ ଦନ୍ୟ, ଇରିଙ୍ଗ୍‌ ମାପୁରୁଦି ରାଜି ୱାରିଦି । ");
INSERT INTO kfcp_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ଆଡ଼୍‍ବାଜି ମାନି ଲୋକୁ ଦନ୍ୟ, ଇରିଙ୍ଗ୍‌ ମାପୁରୁ ୱାରିଙ୍ଗ୍‌ ୱେଡ଼ିକା ସିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ଦାର୍ମୁ ଲୋକୁ ଦନ୍ୟ, ଇରିଙ୍ଗ୍‌ ୱାର୍‌ ମାପୁରୁଦି ପାର୍‌ମାଣ୍‌ କିତିମାନି ବିସୟ୍‌ ଲାବ୍‍କିନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ମାପୁରୁଦି ବଦାଦାନ୍ ପାଣି କିଦେଙ୍ଗ୍‌ ଏମେୱାରି ନାଣ୍ତ ଆସା, ୱାର୍‌ ଦନ୍ୟ, ଇରିଙ୍ଗ୍‌ ମାପୁରୁ ୱାରିଙ୍ଗ୍‌ ୱେଡ଼ିକାକିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ଏମେକାର୍‌ ଆଇୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ଦୟା ତର୍‍ନାର୍‍ ୱାର୍‌ ଦନ୍ୟ, ଇରିଙ୍ଗ୍‌ ମାପୁରୁ ୱାରିଙ୍ଗ୍‌ ଦୟା କିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ଏମେୱାରି ଜିବନ୍‌ ନେଗିକା ୱାର୍‌ ଦନ୍ୟ, ଇରିଙ୍ଗ୍‌ ୱାର୍‌ ମାପୁରୁଦି ଦର୍ସନ୍‍ ପଇନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ଏମେକାର୍‌ ସାନ୍ତି କିଦେଙ୍ଗ୍‌ ଇଜି ପାଣିକିନାର୍‍ ୱାର୍‌ ଦନ୍ୟ, ଇରିଙ୍ଗ୍‌ ୱାର୍‌ ମାପୁରୁଦି କଡ଼ର୍‌ ଇଜି ୱେଙ୍ଗ୍‌ଁନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ଏମେକାର୍‌ ମାପୁରୁଦି ବଦାଦାନ୍ ପାଣିକିଜି କାସ୍ଟୁ ପଇନାର୍‌, ୱାର୍‌ ଦନ୍ୟ, ଇରିଙ୍ଗ୍‌ ମୁସ୍‌କୁପୁର୍‌ ୱାରିଦି । ");
INSERT INTO kfcp_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","ନାୱାଲେ ବୁଲାନିକାର୍‌ ଆତିମାନିଙ୍ଗ୍‌ ଲୋକୁ ଜଦି ମିଙ୍ଗିଁ ଅପମାନ୍‍ସିନାର୍‍, କାସ୍ଟୁ ସିନାର୍‍ ମାରି ମି ବିରଦ୍‌ତାନ୍‌ ତାଗ୍‌ଇ ବାଣ୍ତିସ୍‍ତି ମାଟେଙ୍ଗ୍‌ ଇନାର୍‌, ଆରିଙ୍ଗ୍‌ ମିର୍‌ ଦନ୍ୟ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ନାଣ୍ତ ୱେଡ଼ିକାଆଦୁ, ଇରିଙ୍ଗ୍‌ ମୁସ୍‌କୁପୁର୍‌ତୁ ମି ପୁରସ୍‌କାର୍‌ ନାଣ୍ତ; ଆୟାୱାଜାତ ୱାର୍‌ ମି ପୁର୍ବେଦି ଡକ୍ରାଦାଦାର୍‌ରି ବାବବାଦିରିଙ୍ଗ୍ କାସ୍ଟୁକିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","ମିର୍‌ ୱିଜୁ ଲୋକା ଦୁନିଆଦି ସର୍‍ତି ୱାଜା । ମାତର୍‌ ସର୍‍ ଜଦି ସର୍‍ଦିସାୱି ଆରାକିନାତ୍‍, ଆରିଙ୍ଗ୍‌ ତାନିଙ୍ଗ୍‌ ମାରି ସର୍‍ଆଡ଼୍‍ନିୱାଜା କିଦେଙ୍ଗ୍‌ ଆଏତ୍‍ । ନାସ୍ତିୱାଲେ ଆକା ପୁରା ତାଗ୍‍ଇକାଆଜି ଆତ୍‌ରେ ପକାଇଆନାତ୍‍ । ଲୋକୁ ତାନିଙ୍ଗ୍‌ ମାଟ୍‍ସିସନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","ମିର୍‌ ସାରା ଦୁନିଆଦି ଜାୟ୍‌ ୱାଜା । ଏମେ ଗାଡ଼୍‍କି ଗରନ୍‌ ମୁସ୍‌କୁ ତିଆର୍‌ ଆନାମାନାତ୍‍, ଆକା ଏସାଙ୍ଗ୍‍ ମାର୍‍ଗିଜି ତେବାଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ଦିୱା କାସିସ୍‍କିଜି ଏନ୍‌ ଅଡି ଆଡ୍‍ଗି ପିଡ଼ିକ୍‍ସି ଇଡ୍‌ଏନ୍‌ । ତାନିଙ୍ଗ୍‌ ଦିୱା ଇଡ୍‌ନି ମୁସ୍‌କୁ ବାଡିଦୁ ଇଡ୍‌ନାନ୍‌ ମାରି ଆକା ଇଲୁଦୁ ମାନି ୱିଜେରିଙ୍ଗ୍‍ ଜାୟ୍‌ ସିନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ଆୟାୱାଜା ମି ଜାୟ୍‌ ଲାକ୍‌ତୁ ତରାଇଆପିତ୍‍ । ଆରିଙ୍ଗ୍‌ ମି ସତ୍‍ପାଣି ସୁଡ଼୍‌ଜି ୱାର୍‌ ମି ମୁସ୍‌କୁପୁର୍‌ତି ବୁବା ମାପୁରୁଦି ଦନ୍ୟବାଦ୍‌ କିନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ଅଡ଼୍‍ବିମାଟ୍‍ ଜେ ନାନ୍ ମସା ସିତି ନିୟମ୍‌ ମାରି ବାବବାଦିରି ସିକିୟା ୱିଜୁ ଗୁସାକିଦେଙ୍ଗ୍‍ ୱାତାମାନା । ଆୟାୱିଜୁ ଗୁସାକିଦେଙ୍ଗ୍‍ ସିଲେ, ମାତର୍‌ ସତ୍‌ତାନ୍‌ ସତ୍‌ କିଦେଙ୍ଗ୍‌ ୱାତାମାନା । ");
INSERT INTO kfcp_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ମନ୍‌ତୁ ଇଡ୍‌ଦୁ, ବାଦଡ଼ ନି ଦୁନିଆ ତିର୍‍ଆଜି ତେବାନି ସାନ୍ଦି ନିୟମ୍‌ତି ଉନ୍‍ଣ୍ତ୍ରି ଇସ୍ରି ଠିକା ବା ନାମ୍‍ଏତ୍‍ । ୱିଜୁ ବିସୟ୍‌ତି ପୁରା ଆଇ ସାନ୍ଦି ଇକା ଗଟାଏତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ଆଦେଙ୍ଗ୍‌ ଏନ୍‌ଆପିନ୍‌ ନିୟମ୍‌ତି ୱିଜୁମାଣ୍‌କୁ ଇସ୍ରି ମାଟାଦିଙ୍ଗ୍‌ ଅମାନ୍ୟ କିନାନ୍ ମାରି ଆୟାୱାଜା କିଦେଙ୍ଗ୍‌ ଆଇୱାରିଙ୍ଗ୍‌ ସିକିୟା ସିନାନ୍‍, ୱାନ୍‌ ମୁସ୍‌କୁପୁର୍‌ତି ରାଜିଦୁ ୱିଜେରିମାଣ୍‌କୁ ଇସ୍ରିକାନ୍‌ ଇଜି ୱେଙ୍ଗ୍‌ଁନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ଦାର୍ମୁଗୁରୁ ମାରି ପାରୁସିର୍‌ ମାଣ୍‌କୁ ନାଣ୍ତ ବିସ୍‌ବାସ୍‌ତାନ୍‌ ମାପୁରୁଦି ବଦାଦି ପାଣି କିତିଙ୍ଗ୍‌ ମାତର୍‌ ମିର୍‌ ମୁସ୍‌କୁପୁର୍‌ତୁ ଡ଼ୁଗୁଦେଙ୍ଗ୍‍ ଆଟ୍‌ନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","ମିର୍‌ ୱେର୍‌ଇମାନିଦେର୍‌; ପୁର୍ବେକାଡ଼ାଦାନ୍‍ ଲୋକାଙ୍ଗ୍‌ ଇର୍ହାମାନାର୍‌, ଲୋକାଙ୍ଗ୍‌ ସାୟାମାର୍‌ଗା ଡାକ୍‌ମାଟ୍‌ । ଏନ୍‌ ଆକା କିନାନ୍‌, ୱାନ୍‌ ବିସାର୍‍ଆନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ମାତର୍‌ ନାନ୍ ଇଜିନା, ଏନ୍‍ ଏମେ ତଡ଼ାନ୍‌ ମୁସ୍‌କୁ ରିସାଆନାନ୍‍, ୱାନ୍‌ ବା ବିସାର୍‍ଆନାନ୍‍ । ଏନ୍‌ ତଡ଼ାନ୍‌ତିଙ୍ଗ୍‌ ବାୟା ଇଜି କାଡ଼୍‍ନାନ୍‍, ୱାନ୍‌ ନାଣ୍ତ କୁଟୁମ୍‌ ଆଗ୍‌ଡ଼ି ଦଣ୍ଡ୍‌ ପଇନାନ୍‌ । ମାରି ଏନ୍‌ ତଡ଼ାନ୍‌ତିଙ୍ଗ୍‌ ପାଣିସିଇ ମୁର୍କୁ ଇଜି ଇନାନ୍‌, ୱାନ୍‌ ନରକ ସିସୁଦୁ ପକାନି ଦଣ୍ଡ୍‌ ମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ଆଦେଙ୍ଗ୍‌ ମାପୁରୁଦି ଉଦେସ୍‍ତାନ୍‍ ବେଦି ମୁସ୍‌କୁ ପୁଜାସିଦେଙ୍ଗ୍‍ ସନିୱାଲେ ଜଦି ମି ଏତ୍‌ ୱାନାତ୍‌ ଜେ ମି ଉଣ୍ତିଙ୍ଗ୍‌ ଆମା ତଡ଼ାନ୍‌ତି ମନ୍‌ତୁ ଏସ ଅସାନ୍ତିମାନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ବେଦି ଆଗ୍‌ଡ଼ି ଆୟା ପୁଜା ସିନିକା ଡ଼ିସ୍‌ସି ସିଜି ବେଗି ବେଗି ସାନ୍‍ଡ୍ରୁ, ତଡ଼ାନ୍‌ତି ୱାଲେ ଡ଼େସି ମିସାତି ୱେନ୍‌କା ଡ଼େସି ୱାଜି ମାପୁରୁଦିଙ୍ଗ୍‌ ଆକା ପୁଜା ସିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","ଜଦି ଏନ୍‌ ମି ବିରଦ୍‌ତାନ୍‌ ରାସ୍‌ସି କର୍ଟଦୁ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଜାସେକିନାନ୍‍, କର୍ଟଦୁ ସନି ଆଗ୍‌ଡ଼ି ୱେଡ଼ା ମାନ୍‌ବୁ ମାନ୍‌ବୁ ୱାନି ୱାଲେ ନିଜେ ନିଜେମାନୁ ମିସାଦୁ । ଆଏତିଙ୍ଗ୍‍ କର୍ଟଦୁ ସରିଙ୍ଗ୍, ୱାନ୍‌ ମିଙ୍ଗିଁ ବିସାର୍‍କିନିୱାନି କିୟୁଦୁ ଆସ୍‍ପିସ୍‍କିନାନ୍‍ ମାରି ଆତିଙ୍ଗ୍‌ ନ୍ୟାୟ୍‌ କିନିକାନ୍‍ ମିଙ୍ଗିଁ ଜଇଲ୍‌ତୁ ଅତେଙ୍ଗ୍‍ ଇଜି ପଲିସ୍‍କା କିୟୁଦୁ ସର୍‍ପେ କିନାସିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ମି ମୁସ୍‌କୁ କିଆଇଆତିମାନି ୱାଡି ଡାବୁଙ୍ଗୁଁ ବା ଡ଼େସିସିଇ ସାନ୍ଦି ମିର୍‌ ଆବେଟ୍‌କୁ ସହସ ୱାଦେଙ୍ଗ୍‌ ଆଟ୍‍ଇଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","ଦାରିପାଣି କିମାଟ୍‌, ଇୟା ଆଜ୍ଞା ମିର୍‌ ପୁର୍ବେକାଡ଼ାଦାନ୍‍ ୱେର୍‌ଇମାନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ମାତର୍‌ ଇଲେଇ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ଜଦି ଏନ୍‌ ଆଇୱାନି ଆଇମାଦିଙ୍ଗ୍‍ ତାଗ୍‌ଇ କାଣ୍‌ଗାଦାନ୍‌ ସୁଣାନ୍‍, ୱାନ୍‌ ତାନି ୱାଲେ ମୋନ୍‌ତୁ ମୋନ୍‌ତୁ ଦାରିପାଣିକିତାମାନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ଜଦି ମି ଉଣେରି କାଣ୍‍ଗାଦି ଉଣ୍ତିଙ୍ଗ୍‌ ମିର୍‌ ପାପ୍‌ କିନିମାନିଦେର୍‍, ଆୟା କାଣ୍‍ଗାଦିଙ୍ଗ୍‍ ଉନ୍ଦ୍‍ଜ ପୋକ୍‌ତୁ । ମି ୱିଜୁ ମେନ୍ଧଲ୍‍ ନରକଦୁ ଆର୍‌ନି ବାଦ୍‌ଲୁ, ମେନ୍ଦଲ୍‌ତି ଉଣ୍ତ୍ରି ବାଗ୍ ନାସ୍ଟୁଆନିକା ନେଗେତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ଜଦି ମି ଡେବିରି କିୟୁ ମିଙ୍ଗିଁ ପାପ୍‍ତି ପାଣି କିବିସ୍‍କିଜିମାନାତ୍‍, ଆୟା କିୟୁଦିଙ୍ଗ୍‍ କୟଜ ପୋକ୍‌ତୁ । ମି ୱିଜୁ ମେନ୍ଧଲ୍‍ ନରକଦୁ ଆର୍‌ନି ବାଦ୍‌ଲୁ ଉଣ୍ତ୍ରି ବାଗ୍ ନାସ୍ଟୁଆନିକା ମି ଉଣ୍ତିଙ୍ଗ୍‌ ନେଗେତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ଜଦି ଏନ୍‌ ନିଜେଦି ଆଡ଼ିଙ୍ଗ୍‍ ଡ଼ିସ୍‍ତେଙ୍ଗ୍‍ଁ ବଦାକିନାନ୍‌, ୱାନ୍‌ ତାନିଙ୍ଗ୍‌ ରାସାତି ଇସାବ୍‌ତାନ୍‌ ଉଣ୍ତ୍ରି ଆଇମା ଡ଼ିସ୍‌ନି ଆକୁ ସିପିନ୍‍ ଇୟା ସିକିୟା ମିର୍‌ ଆଗ୍‍ଡ଼ିରାନ୍‍ ପୟ୍‌ତିମାନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ମାତର୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ଦାରିପାଣି କିନିକା ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ଆଇ ଇନି ପାଣିଦିଙ୍ଗ୍‌ ବାଦ୍‌ଲୁ ଅରେନ୍‍ ୱାନି ଆଡ଼ିସିଙ୍ଗ୍‍ ଡ଼ିସ୍‌ନି ଆକୁ ସିତିଙ୍ଗ୍‌, ୱାନ୍‌ ତାନିଙ୍ଗ୍‌ ଦାରିପାଣି କିନି ନିନ୍ଦାଦୁ ଦସ୍‌ କିଜିନାନ୍‍ ମାରି ଏମେ ମେମାରି ଆୟା ଆଇମାଦିଙ୍ଗ୍‍ ପେଡ଼ି ଆନାନ୍‌, ୱାନ୍‌ ବା ଦାରିପାଣି କିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","ପୁର୍ବେ କାଡ଼ାଦାନ୍‍ ଇୟା ସିକିୟା ୱେନ୍‌ଞ୍ଜି ୱାଜିନିଦେର୍‍, ପାର୍‌ମାଣ୍‌ ରୁକ୍‍ମାଟ୍‍ । ମାପୁରୁ ଆଗ୍‌ଡ଼ି ଏମେ ପାର୍‌ମାଣ୍‌ କିତିମାନିଦେର୍‌, ତାନିଙ୍ଗ୍‌ ପୁରାକିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ମାତର୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ପାର୍‌ମାଣ୍‌ କିନିୱାଲେ, ପାର୍‌ମାଣ୍‌ କିମାଟ୍‌ । ମୁସ୍‌କୁପୁର୍‌ତି ଦର୍‌ତାନ୍‌ କିମାଟ୍‌, ଇରିଙ୍ଗ୍‌ ଆକା ମାପୁରୁଦି ବାସ୍‌ନି ଗଦି । ");
INSERT INTO kfcp_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ଦୁନିଆଦି ଦର୍‌ତାନ୍‌ ପାର୍‌ମାଣ୍‌ କିମାଟ୍‌, ଇରିଙ୍ଗ୍‌ ଆକା ମାପୁରୁଦି କାଲ୍‌କୁ ଇଡ୍‌ନି ବାଡି । ଜିରୁସାଲାମ୍‍ ଗାଡ଼୍‌ ଦର୍‌ତାନ୍‌ ବା ପାର୍‌ମାଣ୍‌ କିମାଟ୍‌, ଇରିଙ୍ଗ୍‌ ଆକା ଆଜିନାତ୍‍ ରାଜାରିରାଜାଦି ଗାଡ଼୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ମି ତାଲାଦି ଆନାଦୁରିଆ କିମାଟ୍‌, ଇରିଙ୍ଗ୍‌ ଉନ୍‍ଣ୍ତ୍ରି କୁକୁଟି କାଡ଼ା ନି ଅଡ଼ିନିକା କିନି ସାକ୍ତି ମିଙ୍ଗିଁ ସିଲେତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ମିର୍‌ ପାର୍‌ମାଣ୍‌ ନିୟମ୍‌ କିଏଣ୍‍ଗା କେବଲ୍‌ “ହଁ” ମାଟା “ହଁ” ଆପିତ୍‌, “ସିଲେ” ମାଟା “ସିଲେଣ୍‌” ଆପିତ୍‌ । ତେନିମାଣାନ୍‍ ନାଣ୍ତ ମାଟା ଇଜି ପାର୍‌ମାଣ୍‌ କିନିକା ସୟତାନ୍‍ତି ପେରିସ୍‍କିନି ମାଣାନ୍‌ ୱାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“କାଣ୍‌ଗା ବାଦ୍‌ଲୁ କାଣ୍‌ଗା,” ପାଲୁ ବାଦ୍‌ଲୁ ପାଲୁ । ଇୟା ବାଦ୍‌ଲୁ ଅନିମାଟା ମିର୍‌ ୱେର୍‌ଇମାନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ମାତର୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ଏନ୍‌ ମି ଅନିସ୍ଟ କିତିଙ୍ଗ୍‌ ୱାନି ବାଦ୍‌ଲୁ ଅମାଟ୍‌ । ଜଦି ମି ଉଣେରି ବୁଗୁଲିଦୁ ଏନ୍‌ ସାପୁଡ଼ୁ ଡାକ୍‌ତାନ୍‌, ମାରି ଉନ୍‍ଣ୍ତ୍ରି ସାପୁଡ଼ୁ ଡାକ୍‌ତେଙ୍ଗ୍‍ଁ ମି ଡେବିରି ବୁଗୁଲି ବା ତର୍‌ସୋ ସିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ଜଦି ଏନ୍‌ ମି ଆଙ୍ଗିଁ ଅତେଙ୍ଗ୍‍ ଇଜି ମି ବିରଦ୍‌ତାନ୍‌ ମାଟା ଇଜି ମିଙ୍ଗିଁ ବିସାର୍‌ ବାଡିଦୁ ଅନାନ୍‍, ୱାନିଙ୍ଗ୍‌ ମି ସୁଟେର୍‍ ବା ଦାନ୍‌ ସିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ଜଦି ଏମେ ସୈନ୍ୟ ମିଙ୍ଗିଁ ୱାନି ବଜୁ ପିଣ୍ତ୍‍ଜ ୱାନି ୱାଲେ ଉଣ୍ତ୍ରି କିଲୋମିଟର ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଇଜି ଜାସେକିନାନ୍‍, ମିର୍‌ ଇନିକା ଅଡ଼୍‍ବିଏଣ୍ତା ୱାନି ୱାଲେ ରୁଣ୍ତି କିଲୋମିଟର ସାନ୍‍ଡ୍ରୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ଜଦି ଏନ୍‌ ମିଙ୍ଗିଁ ଇନି ଜିନିସ୍‌ ଲୋସ୍‍ନାନ୍‍, ମାନା କିଏନ୍‍ଣ୍ତା ୱାନିଙ୍ଗ୍‌ ସିଦୁ । ଏନ୍‌ ଇନିକା ଉଦାର୍‌ ଲୋସ୍‍ତିଙ୍ଗ୍‍, ୱାନିଙ୍ଗ୍‌ ଆକା ସିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“ଜିବନ୍‍ନୋଦୁ ମି ସଙ୍ଗ୍‍ଁରିଙ୍ଗ୍‍, କାଡ଼୍‍ଦୁ ମି ସାତ୍ରୁରିଙ୍ଗ୍ ଇୟା ସିକିୟା ଆଗ୍‍ଡ଼ିରାନ୍‍ ୱେର୍‌ଇମାନିଦେର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ମାତର୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ଜିବନ୍‍ନୋଦୁ ମି ସାତ୍ରୁରିଙ୍ଗ୍ । ଏମେକାର୍‌ ମିଙ୍ଗିଁ ତାଡ଼ନାକିନାର୍‍, ୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ପାର୍‌ତନା କିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ଇୟାୱାଜା କିତିଙ୍ଗ୍‌ ମୁସ୍‌କୁପୁର୍‌ତି ବୁବା ମାପୁରୁଦି କଡ଼ର୍‌ ଇଜି ୱେଙ୍ଗିଁନିଦେର୍‍ । ଇରିଙ୍ଗ୍‌ ମାପୁରୁ ନେଗିୱାରି ନି ତାଗ୍‍ଇୱାରି ଲୋକାମୁସ୍‍କୁ ୱାନି ୱେଡ଼ା ଜାୟ୍‌ ସିନାନ୍‍, ମାରି ସତ୍‍ପାଣି ନି ତାଗ୍‌ଇପାଣି କିନି ୱିଜେରିଙ୍ଗ୍‍ ପିର୍‍ରୁ ସିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","କେବଲ୍‌ ମିଙ୍ଗିଁ ଜିବନ୍‍ନୋଜି ମାନି ଲୋକାଙ୍ଗ୍‌ ଜିବନ୍‍ନତିଙ୍ଗ୍‍, ମାପୁରୁ ଏନ୍ଦା ମିଙ୍ଗିଁ ପୁରସ୍‌କାର୍‌ ସିନାନ୍‍ ? ସିସ୍‍ଟୁ ଲୋସ୍‌ନିକାର୍‌ ବା ଆକା କିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ଜଦି କେବଲ୍‌ ମି ତଡ଼ାନ୍‌କାଙ୍ଗ୍‌ ୱାର୍‍ଗିନିଦେର୍‍, ଆରିଙ୍ଗ୍‌ ମିର୍‌ ନେ ଉପ୍‍କାପାଣି କିଜିନିଦେର୍‌ ? ଅବିସ୍‍ବାସ୍‍ରି ବା ଆକା କିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ମି ମୁସ୍‌କୁପୁର୍‌ତି ବୁବା ଏଣ୍ତେସ୍‌ ପବିତ୍ର, ମିର୍‌ ଆୟାୱାଜା ପବିତ୍ର ଆନିକାମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“ଲୋକାଙ୍ଗ୍‌ ତର୍‍ତେଙ୍ଗ୍‍ଇଜି ପୁଲାପୁଲିଦାନ୍‍ ନେଗିପାଣି କିମାଟ୍‌ । ଆକାକିତିଙ୍ଗ୍‍ ମୁସ୍‌କୁପୁର୍‌ତି ବୁବା ମାଣ୍‌କୁ ମିର୍‌ ପୁରସ୍‌କାର୍‌ ପୟ୍‌ଇଦେର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“ଅରେନ୍‍ କାକୁର୍ତି ଲୋକ୍‌ତିଙ୍ଗ୍‌ ଇନି ଦାନ୍‌ ସନିୱାଲେ ପୁଲାପୁଲି ଲୋକ୍‌ତି ୱାଜା ମୋରି ଉକୁସି ତର୍‍ଆଇଆମାଟ୍‍ । ୱାର୍‌ ପାର୍‍ତନାକିନି ଇଲ୍‌କାଙ୍ଗ୍‌ ନି ସାକ୍‌ଡ଼ି ମଜାୟ୍‍ ନିଜେଦି ଦାନ୍‍ଦାର୍ମୁଦି ପାଣି କିନାର୍‌ । ଲୋକାମାଣ୍‌କୁ ଦନ୍ୟବାଦ୍‌ ପୟ୍‌ଦେଙ୍ଗ୍‌ ୱାର୍‌ ଇକା କିନାର୍‌ । ନାନ୍ ସତେନେ ଇଜିନା ଜେ ୱାର୍‌ ଇୟାମାଣାନ୍‍ ୱାରି ପୟ୍‌ନିକା ପୁରାଦାନ୍‌ ପୟ୍‍ତାୱିସ୍‍ତାମାନାର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ମାତର୍‌ ମିର୍‌ ଅରେନ୍‍ କାକୁର୍ତି ଲୋକ୍‌ତିଙ୍ଗ୍‌ ସାକାକିନିୱାଲେ, ଇୟାୱାଜା କିଦୁ, ଏଣ୍ତେସ୍‌ ମି ଲାକ୍‌ତୁରି ସଙ୍ଗ୍‍ ବା ଇୟା ମାଟା ନେସ୍‍ତେଙ୍ଗ୍‍ ଆଟ୍‍ଏନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ଇୟାୱାଜା ମି ଇୟା ଦାନ୍‌ ମାର୍‍କ୍‍ସି ଆତିମାରିଙ୍ଗ୍‍ ବା ମି ୱିଜୁ ସୁଣି ବୁବା ମାର୍‍ଗିଜି ଆକା ସୁଡ଼୍‌ଜି ମିଙ୍ଗିଁ ପୁରସ୍‌କାର୍‌ ସିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“ପାର୍‌ତନା କିନିୱାଲେ ପୁଲାପୁଲି ଦାର୍ମୁ ଲୋକା ୱାଜା ଆମାଟ୍‌ । ୱିଜେରେ ଏଣ୍ତେସ୍‌ ସୁଡ଼୍‍ଦେଙ୍ଗ୍‍ ଆଟ୍‍ନାର୍‍, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ପାର୍‍ତନାକିନି ଇଲ୍‌କାଙ୍ଗ୍‌ ମାରି ରାସ୍ତା ଡେଣେଆଙ୍ଗ୍‍ ନିଲ୍‍ଜି ୱାର୍‌ ପାର୍‌ତନା କିଦେଙ୍ଗ୍‌ ବଦାକିନାର୍‍ । ନାନ୍ ମିଙ୍ଗିଁ ସତେନେ ଇଜିନା ଜେ ୱାର୍‌ ନିଜେ ନିଜେଦି କିତିମାନିପାଣିଦି ପୁରସ୍‌କାର୍‌ ପୟ୍‍ତାୱିସ୍‍ତାମାନାର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ମାତର୍‌ ଏସ୍ତିୱାଲେ ମିର୍‌ ପାର୍‌ତନା କିନିଦେର୍‍, ନିଜେଦି ବାକ୍‍ରା ଲୋଇ ସାନ୍‍ଡ୍ରୁ, ସେର୍‍ଲା କେର୍‍ତୁ ମାରି ମି ତରାଇଆଇ ବୁବେଙ୍ଗ୍‌ ପାର୍‌ତନା କିଦୁ । ମିର୍‌ ମାର୍‍କ୍‍ସି ଆମାକା କିନିଦେର୍‍, ୱିଜୁସୁଣି ମୁସ୍‌କୁପୁର୍‌ତି ବୁବା ଆକା ସୁଡ଼୍‌ଜି ମିଙ୍ଗିଁ ପୁରସ୍‌କାର୍‌ ସିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“ମି ପାର୍‍ତନାଦୁ ଅବିସ୍‍ବାସ୍‍ରି ୱାଜା ନାଣ୍ତ ଅର୍ତସିଲି ମାଟେଙ୍ଗ୍‌ କିମାଟ୍‌ । ୱାର୍‌ ଅଡ଼୍‍ବିନାର୍‍, ୱାରି ପାର୍‌ତନା ନିର୍‍ଇକା ଆତିଙ୍ଗ୍‌ ମାପୁରୁ ୱେନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ୱାରି ୱାଜା ଆମାଟ୍‌ । ମିର୍‌ ଲୋସ୍‍ନି ଆଗ୍‌ଡ଼ି ମି ଆମାକା ଦର୍‌କାର୍‌, ମି ମୁସ୍‌କୁପୁର୍‌ତି ବୁବା ଆକା ୱିଜୁ ନେସ୍‌ନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ଆଦେଙ୍ଗ୍‌ ଇୟାୱାଜା ପାର୍‌ତନା କିନିକା ମି ନେଗେତ୍‌ । ମା ମୁସ୍‌କୁପୁର୍‌ତି ବୁବା, ନି ପବିତ୍ର ଦରୁ ପେରିକାଆପିତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ନି ରାଜି ରାପିତ୍‍ । ନି ବଦା ମୁସ୍‌କୁପୁର୍‌ତୁ ଏଣ୍ତେସ୍‌, ଇୟା ଦୁନିଆଦୁ ବା ଆୟାୱାଜା ପୁରାଆପିତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ନେର୍‌ ମାଙ୍ଗିଁ ଦର୍‍କାର୍‍ମାନି କାଦି ସିଦା । ");
INSERT INTO kfcp_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ମା ବିରଦ୍‌ତାନ୍‌ ଦୋସ୍‍ କିତିମାନି ଲୋକାଙ୍ଗ୍‌ ମାପ୍‌ ଏଣ୍ତେସ୍‌ କେମାକିନାପ୍‍, ଆୟାୱାଜା ମା ଦସ୍‌ ୱିଜୁ କେମା କିଆ । ");
INSERT INTO kfcp_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ମାଙ୍ଗିଁ ଆଟ୍‌ୱା ପରିକାଦୁ ଆର୍‌ଦେଙ୍ଗ୍‌ ସିମା । ତାଗ୍‌ଇ ମାଣାନ୍‌ ମାଙ୍ଗିଁ ରକିୟାକିୟା । ଇରିଙ୍ଗ୍‌ ସାସନକିନିକା, ପେରିସାକ୍ତି, ଗୌରବ୍‍ ଜୁଗ୍‌ ଜୁଗ୍‌ ନିଦିଆପିତ୍‍, ଆମେନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","ମି ବିରଦ୍‌ତାନ୍‌ ଦସ୍‌ କିତିମାନି ଆଇୱାରିଙ୍ଗ୍‌ ଜଦି ମିର୍‌ କେମାକିନିଦେର୍‍, ମି ମୁସ୍‌କୁପୁର୍‌ତି ବୁବା ବା ମିଙ୍ଗିଁ କେମାକିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ମାତର୍‌ ମିର୍‌ ଜଦି ଆଇୱାରିଙ୍ଗ୍‌ କେମାକିଇଦେର୍‌, ମି ମୁସ୍‌କୁପୁର୍‌ତି ବୁବା ବା ମିର୍‌ କିତିମାନି ଦସ୍‍ୱିଜୁ କେମାକିଏନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","ଉପାସ୍‌ କିନିୱାଲେ ପୁଲାପୁଲି ଦାର୍ମୁଦି ଲୋକା ୱାଜା ମକମ୍‌ ରେପ୍‍ମାଟ୍‍ । ୱାର୍‌ ଉପାସ୍‍କିଜିନାର୍‍ଇଜି ଆଇୱାରିଙ୍ଗ୍‌ ତର୍‌ତେଙ୍ଗ୍‍ଁ ଇଜି ନିଜେଦି ମକମ୍‍ତିଙ୍ଗ୍‍ ଜାତୁନ୍‍କିଏନ୍‍ଣ୍ତା ଇଡ୍‍ନାର୍‍ । ଇକା ସତେନେ ଜେ ଆୟାୱାଜା କିନି ମାଣାନ୍‌ ୱାର୍‌ ନିଜେଦି ୱିଜୁ ପୟ୍‌ନିକା ପୟ୍‍ତାୱିସ୍‍ତାମାନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ମାତର୍‌ ମିର୍‌ ଉପାସ୍‌ କିନିୱାଲେ ମକମ୍‌ ଉର୍‍ପାଜି, ତାଲାଦୁ ନିୟୁ ଉସାଜି ତେବାଦୁ, ");
INSERT INTO kfcp_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ଏଣ୍ତେସ୍‌ ଉପାସ୍‌କିଜିନିଦେର୍‍ ଇଜି ଆଇକାର୍‌ ନେସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‍ଏର୍‍, ମାତର୍‌ ମି ତରାଇଆଇ ବୁବାନେ ୱିଜୁ ମାଟା ନେସ୍‌ନାନ୍‌ । ମିର୍‌ ମାର୍‍ଗ୍‍ଜି ଆମାକା କିଜିନିଦେର୍‌, ଆକା ସୁଡ଼୍‌ଜି, ୱାନ୍‌ ମିଙ୍ଗିଁ ପୁରସ୍‌କାର୍‌ ସିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","ଇୟା ଦୁନିଆଦୁ ନିଜେଦି ଉଣ୍ତିଙ୍ଗ୍‌ ଦନ୍‌ ଉଣ୍ତା କିମାଟ୍‌ । ଏମେମାନୁ ସେଦା ନି କିଟିଙ୍ଗ୍‍ ତିନେ, ମାରି ଡଙ୍ଗାଁର୍‌ଉଁ ରୁକ୍‍ସି ଡଙ୍ଗାଁକିନା ଅନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ମାତର୍‌ ଇୟାୱାଜା ମୁସ୍‌କୁପୁର୍‌ତୁ ମି ଉଣ୍ତିଙ୍ଗ୍‌ ଦନ୍‌ ଉଣ୍ତା କିଦୁ । ଏମେମାନୁ ପିଡ଼୍‍କୁ ନି କିଟିଙ୍ଗ୍‍ ତିନ୍‍ଉ ମାରି ଡଙ୍ଗାଁର୍‌ଉଁ ଡଙ୍ଗାଁକିଏର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ଇରିଙ୍ଗ୍‌ ଏମେମାନୁ ମି ଦନ୍‌, ଆବେ ମି ମନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","କାଣ୍‌ଗା ମେନ୍ଦଲ୍‌ତି ଦିୱା ୱାଜା । କାଣ୍‌ଗା ନେଗିକାମାର୍‍ରିଙ୍ଗ୍‍, ମେନ୍ଧଲ୍‍ ଜାୟ୍‍ତୁ ପୁରାଆଜି ନିଙ୍ଗ୍‍ଁନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ମାତର୍‌ ମି କାଣ୍‌ଗା ଜଦି ତାଗ୍‌ଇକା ମାନାତ୍‌, ମେନ୍ଧଲ୍‍ ସିକାଟି ଆନାତ୍‌ । ମି ଜିବନ୍‌ତି ଜାୟ୍‌ ଜଦି ସିକାଟି ଆନାତ୍‌, ଆୟା ସିକାଟି ଏସା ବୟ୍‍ଙ୍କାର୍‍ ସିକାଟି ଆଏତ୍‍ ନୋ ! ");
INSERT INTO kfcp_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","ଅରେନ୍‍ ଲୋକୁ ରିଏରି ମାଲିକ୍‌କା ସାକର୍‌ ଆଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏନ୍‍ । ୱାନ୍‌ ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ କାଡ଼୍‍ନାନ୍‍ ମାରି ଆଇୱାନିଙ୍ଗ୍‍ ଜିବନ୍‍ନୋନାନ୍‍, ମାରି ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ମାନାନାନ୍‍ ମାରି ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ମାନାଏନ୍‌ । ମିର୍‌ ମାପୁରୁ ନି ଡାବୁକାସୁଦି ସାକର୍‌ ଆଦେଙ୍ଗ୍‌ ଆଟ୍‍ଇଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ଜିବନ୍‍ତି ଜିନି ଉଣ୍ତିଙ୍ଗ୍‌ ଦର୍‍କାର୍‍ମାନି କାଦି ମାରି ଏର୍‌ ମାରି ଆରାନି ଉଣ୍ତିଙ୍ଗ୍‌ ଦର୍‍କାର୍‍ମାନି ଆଙ୍ଗିଁପାସିୟା ଉଣ୍ତିଙ୍ଗ୍‌ ବେମ୍‍ରି ଆମାଟ୍‌ । କାଦିଦି ମାଣ୍‌କୁ ଜିବନ୍‌ ଇନିକା ନାଣ୍ତ ଦାରା ସିଲେ ? ଆଙ୍ଗିଁପାସିୟା ମାଣ୍‌କୁ ମେନ୍ଧଲ୍‍ ଇନିକା ନାଣ୍ତ ଦାରା ସିଲେ ? ");
INSERT INTO kfcp_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ପଟିଆଙ୍ଗ୍‍ଁ ସୁଡ଼୍‍ଦୁ । ୱାକ୍‍ ୱିତୁ ୱିତ୍‍ଉ । ପାସି ଉଣ୍ତା କିଜି କଲ୍‍କିଦୁ ଉଣ୍ତାକିଉ । ଆରିଙ୍ଗ୍‍ବା ମି ମୁସ୍‌କୁପୁର୍‌ତି ବୁବା ୱାନିକାଙ୍ଗ୍‌ ତିନ୍‌ଡ୍ରେଙ୍ଗ୍‌ କାଦି ସିନାନ୍‍ । ମିର୍‌ ଇନିକା ପଟିଙ୍ଗାଁ ମାଣ୍‌କୁ ନାଣ୍ତ ଦାରା ସିଲେ ? ");
INSERT INTO kfcp_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ମି ଲୋଇ ଏନ୍‌ ସିନ୍ତା କିଜି କିଜି ନିଜେଦି ଜିନି ବାର୍ସୁ ପିରିସ୍‍ କିଦେଙ୍ଗ୍‍ ଆଟ୍‍ନାନ୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“ଆଙ୍ଗିଁପାସିୟା ଉଣ୍ତିଙ୍ଗ୍‌ ଏନ୍ଦା ଦାନ୍ଦା ଆଜିନିଦେର୍‍ ? ସୁଡ଼୍‍ଦୁ, ବନ୍‍ତି ପୁଙ୍ଗୁଁକାଙ୍ଗ୍‍ ଏଣ୍ତେସ୍‌ ପିର୍‍ନେ । ୱାକ୍‍ ପାଣିକିଉ କି ନିଜେଦି ଉଣ୍ତିଙ୍ଗ୍‌ ଆଙ୍ଗିଁଙ୍ଗ୍‌ ରସ୍‍ଉ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ମାତର୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ରାଜା ସଲମନ୍‍ ୱାନି ୱିଜୁ ଦନ୍‍ ମାରିଙ୍ଗ୍‌ ବା, ଇୟା ପୁଙ୍ଗୁଁକା ୱାଜା ସୁନ୍ଦର୍‌ ଆଙ୍ଗିଁ ଏସାଙ୍ଗ୍‍ ଆରାଏନ୍‍ମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ମାତର୍‌ ନେର୍‌ ଆମା ଲାଟା କିଡ଼ିଇଦୁ ମାନାତ୍‌, ୱିଗେରିଙ୍ଗ୍‌ ତେବାଏତ୍‍ କୟାୟ୍‍ଆଜି ସିସୁଗୁଟାଦୁ ପୋକ୍‌ନାର୍‌ । ମାତର୍‌ ଆୟାୱିଜୁ ବା ମାପୁରୁ ଏସା ସୁନ୍ଦର୍‌ ଆଙ୍ଗିଁଆଣ୍‍ ରସ୍‍ତାମାନାନ୍‍ । ମିଙ୍ଗିଁ ଆଙ୍ଗିଁପାସିୟା ସିଦେଙ୍ଗ୍‍ ଇଜି ୱାନ୍‌ ଇନିକା ନାଣ୍ତ ସୁଡ଼ୁଏନ୍‌ ? ମି ବିସ୍‌ବାସ୍‌ ସତେ ଏସା ଉଣା ! ");
INSERT INTO kfcp_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“ଆରିଙ୍ଗ୍‌, ନା କାଦି ଏମେଣ୍‌କୁ ୱାନାତ୍‌, ମାରି ନା ଉଣିକା ? ମାରି ଆଙ୍ଗିଁ ? ଇୟା ବିସୟ୍‌ତାନ୍‌ ସିନ୍ତା କିମାଟ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ଏମେକାର୍‌ ମାପୁରୁଙ୍ଗ୍‍ଁ ନେସ୍‌ଇମାନି ଅଣଜିହୁଦି ଲୋକୁ ଇୟାୱିଜୁ ବିସୟ୍‌ ପୟ୍‌ଜି ଅନାର୍‍ । ମାରି ଇୟାୱିଜୁ ବିସୟ୍‌ ଜେ ମି ଦର୍‌କାର୍‌ମାନାତ୍‌, ଆକା ମି ମୁସ୍‌କୁପୁର୍‌ତି ବୁବା ନେସ୍‌ନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ମାରି ମାପୁରୁଦି ରାଜି ବିସୟ୍‌ ମାରି ମାପୁରୁ ମି ମାଣ୍‌କୁ ଇନିକା ବଦାକିନାନ୍‌, ଇୟା ମାଟା ମି ମନ୍‌ତୁ ଆଗ୍‌ଡ଼ି ବାଡି ସିଦୁ । ଆରିଙ୍ଗ୍‌ ୱାନ୍‌ ମିଙ୍ଗିଁ ଆଇ ୱିଜୁ ବିସୟ୍‌ ଉଣ୍ତାକିନାସିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ମାରି ୱିଗେରି ଉଣ୍ତିଙ୍ଗ୍‌ ସିନ୍ତା କିମାଟ୍‌ । ୱିଗେରି ସିନ୍ତା ୱିଗେ କିନିଦେର୍‍ । ୱିଗେରି ବିସୟ୍‌ତାନ୍‌ ସିନ୍ତା କିଜି ନେର୍‍ଇ ଦାନ୍ଦାଦିଙ୍ଗ୍‍ ପିରିସ୍‍ କିମାଟ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“ଆଇୱାରି ଦସ୍‌ ପୟ୍‍ଜିବୁଲାମାଟ୍‍ । ଆରିଙ୍ଗ୍‌ ମାପୁରୁ ବା ମି ଦସ୍‌ ଆସ୍‍ଏନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ଆଇୱାରି ଦସ୍‌ ବିସୟ୍‌ତାନ୍‌ ମିର୍‌ ଏଣ୍ତେସ୍‌ ବିସାର୍‌ କିଜିମାନିଦେର୍‍, ମାପୁରୁ ଆୟାୱାଜା ମି ବିସାର୍‌ କିନାନ୍‌ । ମିର୍‌ ଆଇୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ଏମେ ନିୟମ୍‌ କିନିଦେର୍‍, ଆୟା ନିୟମ୍‌ ମାପୁରୁ ମି ଉଣ୍ତିଙ୍ଗ୍‌ ବା କିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ମି କାଣ୍‍ଗାଦୁ କାଣ୍ତିପିଲା ମାନିୱାଲେ ଏନ୍ଧା ମି ତଡ଼ାନ୍‌ତି କାଣ୍‌ଗାଦୁ ମାନି ଇସ୍ରିକାସ୍ରାଦି ଉଣ୍ତିଙ୍ଗ୍‌ ମିର୍‌ ଏନ୍ଦା ମନ୍‍ସିଜିନିଦେର୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ନିଜେଦି କାଣ୍‍ଗାଦୁ କାଣ୍ତିପିଲା ମାନ୍‌ବୁ ମାନ୍‌ବୁ ମିର୍‌ ଆମା ସାହାସ୍‍ତାନ୍‍ ମି ତଡ଼ାନ୍‌ତି କାଣ୍‌ଗାଦାନ୍‌ ଇସ୍ରିକାସ୍ରା କାଣ୍ତିଦିଙ୍ଗ୍‍ କୁତ୍‌ନା ପୋକ୍‌ନାପ୍‌ ଇଜି ଇଜିନିଦେର୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ଏ ପୁଲାପୁଲି କିନିକିନ୍ଦେର୍‍ ! ମି କାଣ୍‌ଗାଦାନ୍‌ କାଣ୍ତିପିଲାଦିଙ୍ଗ୍‍ ଆଗ୍‌ଡ଼ି ସପ୍‍ସ ପକ୍‍ତୁ । ଆରିଙ୍ଗ୍‌ ମି ତଡ଼ାନ୍‌ତି କାଣ୍‍ଗାଦୁ ମାନି ଇସ୍ରିକାସ୍ରା କାଣ୍ତିଦିଙ୍ଗ୍‍ ମିର୍‌ ଉସାସ୍‍ତାନ୍‍ ସୁଡ଼୍‌ଜି କୁତ୍‍ତେଙ୍ଗ୍‍ ଆଟ୍‌ନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","ନୁକୁଡ଼ିଆଙ୍ଗ୍‍ଁ ପବିତ୍ର କାଦି ସିମାଟ୍‍ । ଇରିଙ୍ଗ୍‌ ୱାକ୍‍ ମାର୍‍ଜି ମିଙ୍ଗିଁ କାଟ୍‍ନେପକ୍‍ନେ । ପାନ୍‍ଣ୍ତ୍ରିଙ୍ଗାଁ ଆଗ୍‌ଡ଼ି ୱେଣ୍ତି ପକ୍‍ମାଟ୍‍ । ତାନି ଦାରା ବୁଜାଏଣ୍ତା ତାନିଙ୍ଗ୍‌ ୱାକ୍‍ କେବଲ୍‌ ପାଦାମ୍‍ତୁ ମାଟ୍‍ନାପକ୍‍ନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","ଲୋସ୍‍ତୁ, ଆରିଙ୍ଗ୍‌ ମିଙ୍ଗିଁ ସିଆଇଆନାତ୍‍; ପୟ୍‌ଦୁ ମିର୍‌ ପୟ୍‌ନିଦେର୍‌; ସେର୍‌ଲାଦୁ କତ୍‍ତୁ, ଆବେଟ୍‌କୁ ମି ଉଣ୍ତିଙ୍ଗ୍‌ ସେର୍‍ଲା ରେନାସିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ଏନ୍‌ ଲୋସ୍‍ନାନ୍‍, ୱାନିଙ୍ଗ୍‌ ସିଆଇଆନାତ୍‍; ଏନ୍‌ ପୟ୍‌ନାନ୍‌, ୱାନ୍‌ ପୟ୍‌ନାନ୍‌; ଏନ୍‌ ସେର୍‍ଲାଦୁ କତ୍‍ନାନ୍‍, ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ସେର୍‍ଲା ରେଆଇଆନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ମି ଲୋଇ ଇୟାୱାଜା ଏମେ ବୁବା ମାନାନ୍‌, ଏନ୍‌ ନିଜେଦି କଡ଼ ରୁଟି ଲୋସ୍‍ତିଙ୍ଗ୍‍ ୱାନିଙ୍ଗ୍‌ କାଲୁ ସିନାନ୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ମାରି ୱାନ୍‌ ମିନି ଲୋସ୍‍ତିଙ୍ଗ୍‍ ୱାନିଙ୍ଗ୍‌ ଇନିକା ସାରାସ୍‍ ସିନାନ୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ମିର୍‌ ତାଗ୍‌ଇ ଲୋକୁ ଆତିଙ୍ଗ୍‌ବା ଏସ୍ତିୱାଲେ ନିଜେଦି ନିଜେଦି କଡ଼ରିଙ୍ଗ୍‌ ନେଗି ନେଗି ଜିନିସ୍‌ ସିଦେଙ୍ଗ୍‍ ନେସ୍‌ନିଦେର୍‌, ଆରିଙ୍ଗ୍‌ ମି ମୁସ୍‌କୁପୁର୍‌ତି ବୁବା ୱାନି ମାନୁ ଲୋସ୍‍ନି ଲୋକାଙ୍ଗ୍‌ ଏସ ନାଣ୍ତ ନେଗି ନେଗି ଜିନିସ୍‌ ସିଏନ୍‍ନ ! ");
INSERT INTO kfcp_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","ମି ଉଣ୍ତିଙ୍ଗ୍‌ ଆଇକାର୍‌ ଆମାକା କିପିର୍‍ ଇଜି ମିର୍‌ ବଦା କିନିଦେର୍‌, ମିର୍‌ ଆଇୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ଆୟାୱାଜା କିଦୁ । ଇରିଙ୍ଗ୍‌ ମସା ସିତିମାନି ନିୟମ୍‌ ନି ବାବବାଦିରି ଦାର୍ମୁସାସ୍ତ୍ରଦି ସିକିୟା ଆଜିନାତ୍‍, ତେନି ସତ୍‌ ମାଟା । ");
INSERT INTO kfcp_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","ସିପଡ଼ି ସେର୍‍ଲା ସିଜି ସାନ୍‍ଡ୍ରୁ । ଇରିଙ୍ଗ୍‌ ସାନି ସାରିଦୁ ଅନି ନରକଦି ସାରି ଅସାର୍ ନି ପେରିକା । ନାଣ୍ତ ଲୋକୁ ଆୟା ସାରି ସିଜି ସନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ମାତର୍‌ ଏସାଙ୍ଗ୍‍ ୱିଜ୍‌ଇ ଜିବନ୍‌ତୁ ସନି ରାସ୍ତା ଆଟ୍‌ୱା ମାରି ତାନି ସେର୍‍ଲା ସିପଡ଼ି ମାରି ବେସିଉଣା ଲୋକୁ ଇୟା ସାରି ପୟ୍‌ଜି ପୟ୍‌ନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","ବଣ୍ତ ବାବବାଦିରି ମାଣ୍‌କୁ ସାବ୍‍ଦାନ୍‍ ! ୱାର୍‌ ଆତ୍‌ରେ ମେଣ୍ତାଦିରୁପ୍‌ ୱାଜା ତରାନାର୍‍, ମାତର୍‌ ୱାର୍‌ ମନ୍‌ତୁ ଉଣ୍ତ୍ରି ଉଣ୍ତ୍ରି ବେନ୍‍ଡ୍ର ୱାଜା । ");
INSERT INTO kfcp_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ୱାରି ପାଣିସୁଣିଦାନ୍‍ ମିର୍‌ ୱାରିଙ୍ଗ୍‌ ସିନିସ୍‍କିନିଦେର୍‍ । ସାମ୍‌ ଦୁପାଦୁ ଅଙ୍ଗୁର୍‍ ଆସ୍‌ଏତ୍‌ ମାରି କଡ଼ି ମାରାତୁ ତଗା ପଲ୍‌ ଆସ୍‌ଏତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ନେଗି ମାରାତୁ ନେଗି ପଲ୍‌ ଆସ୍‌ନାତ୍‌ । ତାଗ୍‌ଇ ମାରାତୁ ତାଗ୍‌ଇ ପଲ୍‌ ଆସ୍‌ନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ନେଗି ମାରାତୁ ତାଗ୍‌ଇ ପଲ୍‌ ଆସ୍‌ଏତ୍‌ ବା ତାଗ୍‌ଇ ମାରାତୁ ନେଗି ପଲ୍‌ ଆସ୍‌ଏତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ନେଗି ପଲ୍‌ ଆସ୍‌ଏତିଙ୍ଗ୍‌ ମାରାନ୍‌ କାତାଇଆଜି ସିସୁଦୁ ପକାୟ୍‍ ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ଆୟାୱାଜା ବଣ୍ତ ବାବବାଦିରି ପାଣିସାଣିଦାନ୍‍ ୱାରିଙ୍ଗ୍‌ ମିର୍‌ ସିନିସ୍‌କିଦେଙ୍ଗ୍‌ ଆଟ୍‌ନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ଏମେକାର୍‌ ନାଙ୍ଗିଁ ପ୍ରବୁ, ପ୍ରବୁ, ଇଜି କୁକ୍‍ନାର୍‍, ୱାରି ମାଣ୍‌କୁ ୱିଜେରେ ମୁସ୍‌କୁପୁର୍‌ତୁ ଡ଼ୁଗୁଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏର୍‍ । ଏମେକାର୍‌ ନା ମୁସ୍‌କୁପୁର୍‌ତି ବୁବାଦି ବଦାଦାନ୍ ପାଣି କିନାର୍‌, କେବଲ୍‌ ୱାର୍‌ ମୁସ୍‌କୁପୁର୍‌ତୁ ଡ଼ୁଗୁଦେଙ୍ଗ୍‍ ଆଟ୍‍ନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ମାପୁରୁଦି ବିସାର୍‌ ଦିନ୍‌ ଇଗା ୱାତିଙ୍ଗ୍‍ ୱିଜେରେ ନାଙ୍ଗିଁ ଇନାର୍‌, ପ୍ରବୁ, ପ୍ରବୁ, ନି ଦର୍‌ତାନ୍‌ ମାପ୍‌ ଇନିକା ବାବବାଦିର୍ ମାପୁରୁଦି ନେଗିକାବୁର୍‌ ୱେର୍‍ଏପ୍‍ମାର୍ହାପ୍‍, ପ୍ରବୁ, ନି ଦର୍‌ତାନ୍‌ ଦୁବେଙ୍ଗ୍‍ ଡ଼ିସିସ୍‍ତାମାର୍ହାପ୍‍ ମାରି ନାଣ୍ତ କାବାଆନି ପାଣି କିତାମାର୍ହାପ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ନାସ୍ତିୱାଲେ ୱାରିଙ୍ଗ୍‌ ନାନ୍ ଇନା, ମିଙ୍ଗିଁ ନାନ୍ ଏସାଙ୍ଗ୍‍ ନେସେଏ । ଏ ତାଗ୍‌ଇ ପାଣିକିନି ୱିଜେରେ ନା ଲାକ୍‌ତୁରାନ୍‌ ଆକ ଆଦୁ ! ");
INSERT INTO kfcp_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“ଏନ୍‌ ନା ମାଟା ୱେନ୍‌ଞ୍ଜି ମାନାନାନ୍‍, ୱାନ୍‌ ପିଡ଼ିପି ମୁସ୍‌କୁ ଇଲୁ ତର୍‌ତିମାନି ବୁଦିମାନି ଲୋକୁ ୱାଜା । ");
INSERT INTO kfcp_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ନାଣ୍ତ ପିରୁ ୱାତାତ୍‍, ଗାଡାଦି ଏର୍‌ ପୁରୁଣ୍‍ ଆଜିସର୍ହାତ୍‍ ମାରି ଆୟା ଇଲୁ ମୁସ୍‌କୁ ନାଣ୍ତ ଡାକ୍‌ତାତ୍‌ ଗାଲି ୱାତାତ୍‍, ମାତର୍‌ ଆୟା ଇଲୁଦି ମୁଲ୍‌କୁନାଦି ୱିର୍‍ଜ୍ଏତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“ମାତର୍‌ ଏମେକାର୍‌ ନା ମାଟା ୱେନ୍‌ଞ୍ଜି ମାନାଏନ୍‌, ୱାର୍‌ ବାଲିବୁମି ମୁସ୍‌କୁ ଇଲୁ ରସ୍‍ତିମାନି ମୁର୍କୁ ୱାଜା । ");
INSERT INTO kfcp_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ନାଣ୍ତ ପିରୁ ୱାତାତ୍‍, ଗାଡା ଏରୁ ପାଡ଼ି ସତେ । ନାଣ୍ତ ଗାଲି ୱାତାତ୍‍ ମାରି ଇଲୁ ୱିର୍‌ଜିତାତ୍‌ । ଆକା ଏସା ବୟ୍‍ଙ୍କାର୍‍ ସତେ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ଜିସୁ ଇୟାୱିଜୁ ମାଟା ଇର୍‍ଇୱିସ୍‌ତି ୱେନ୍‌କା, ଲୋକ୍‌ ୱିଜେରେ ୱାନି ସିକିୟାଦିଙ୍ଗ୍‍ କାବାଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ଜିସୁ ଆଇ ଦାର୍ମୁଗୁରୁରି ୱାଜା ସିକିୟା ସିଏନ୍‍ଣ୍ତା ଅଦିକାର୍‌ ପୟ୍‍ତିମାନି ଲୋକ୍‌ତି ୱାଜା ସିକିୟା ସିଜିମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ଜିସୁ ଗରନ୍‌ ମୁସ୍‌କୁରାନ୍‌ ରେତାତି ୱେନ୍‌କା ନାଣ୍ତ ଲୋକୁ ୱାନି ୱେନ୍‌କା ବୁଲାଦେଙ୍ଗ୍‍ ଆସ୍‍ତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ନାସ୍ତିୱାଲେ ଅରେନ୍‍ କୁସ୍ଟରୋଗ୍‌ତି ଲୋକ୍‌ ୱାନି ଲାକ୍‌ତୁ ୱାଜି ମାଡ଼ିସ୍‌ କିଜି ଇର୍ହାନ୍‌, “ଏ ପ୍ରବୁ, ନିନ୍‌ ଜଦି ବଦା କିନି, ନାଙ୍ଗିଁ ନେଗେଣ୍ତ୍‌ କିଦେଙ୍ଗ୍‌ ଆଟ୍‌ନି ।” ");
INSERT INTO kfcp_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ଜିସୁ କିୟୁ ପେର୍‌ଜି ୱାନିଙ୍ଗ୍‌ ମୁଟ୍‌ସି ଇର୍ହାନ୍‌, “ନାନ୍ ବଦା କିଜିନା, ନେଗେଣ୍ତ୍‌ ଆଆ ।” ଦାପେ ଦାପେ ଆୟା ଲୋକ୍‌ତି କୁସ୍ଟରୋଗ୍‌ ନେଗେନ୍‍ଆତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ୱେନ୍‍ଆ, ଜାଗାର୍‌ତା, ନିନ୍‌ ଏଣ୍ତେସ୍‌ ନେଗେନ୍‍ଆତି, ଏଙ୍ଗ୍‌ବା ଇନିକା ଇନ୍‍ମା; ମାତର୍‌ ସିଦା ଜାଜକରି ମାନୁ ସଲ୍‌ସି ନିଜେଦିଙ୍ଗ୍‍ ତରାଇଆଆ ମାରି ମୋସା ନେଗେନ୍‌ ଆତିମାନି ଇଜି ୱିଜେରିଙ୍ଗ୍‍ ସାକି ସିଦେଙ୍ଗ୍‍ ଇଜି ମୋସାଦି ଆଦେସ୍‌ ସିତିମାନି ପୁଜା ସିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ଜିସୁ କପର୍‍ନାହୁମ୍‍ ଗାଡ଼୍‌ତୁ ଡ଼ୁଗିତି ଦାପ୍ରେ ଅରେନ୍‍ ରମିୟ ନେତା ୱାନିଙ୍ଗ୍‌ ବେଟ୍‍ବୁଡ଼ାଜି ମାଡ଼ିସ୍‍କିଜି ଇର୍ହାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“ପ୍ରବୁ, ନା ଅରେନ୍‍ ପାଣିକିନିକାନ୍‌ ନବ୍‍ତି ଉଣ୍ତିଙ୍ଗ୍‌ ଡରିତାମାନାନ୍‍ । ୱାନ୍‌ ବୁଲାସାଲାଦେଙ୍ଗ୍‍ ଆଟ୍‌ଏଜିନାନ୍‌, ନାଣ୍ତ ବାଦାଜି ଇଲୁଦୁ ଡରିତାମାନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ଜିସୁ ଇର୍ହାନ୍‌, “ନାନ୍ ୱାଜି ୱାନିଙ୍ଗ୍‌ ନେଗେନ୍‍କିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ନେତା ଇର୍ହାନ୍‌, “ସିଲେ ପ୍ରବୁ” ନିନ୍‌ ଜେ ନା ଇଣ୍ତ୍ର ପାଦାମ୍‌ ଇଡ୍‌ନି ନାନ୍‌ ଇୟାୱାଜା ଜୋଗ୍‍ ସିଲେ । ନିନ୍‌ କେବଲ୍‌ ଉନ୍‌ଡ୍ରି ପଦ୍‍ମାଟାଦି ଆଦେସ୍‌ ଇନ୍‌ଆଁ, ନା ପାଣିକିନିକାନ୍‌ ନେଗେନ୍‍ ଆନାସନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","“ନା ପେରିୱାନି ଆଡ୍‍ଗିମାନ୍‍ଞ୍ଜି ନାନ୍ ପାଣି କିତିଙ୍ଗ୍‌ବା ନା ଆଡ୍‍ଗି ନାଣ୍ତ ସନ୍ୟ ଦଲ ମାନାର୍‌ । ୱାରି ଲୋଇ ଅରେନ୍‍ ୱାନିଙ୍ଗ୍‌ ଜଦି ନାନ୍ ସାଙ୍ଗ୍‍ଆ ଇଜି ଆଦେସ୍‌ ସିତିଙ୍ଗ୍‌, ୱାନ୍‌ ସନାନ୍‌ । ଆଇୱାନିଙ୍ଗ୍‍ ରାଆ, ଇଜି ଇରିଙ୍ଗ୍‌, ୱାନ୍‌ ୱାନାନ୍‌ । ନା ସାକର୍‌ତିଙ୍ଗ୍‌ ଇକା କିଆ, ଇଜି ଇନି ଦାପ୍ରେ ୱାନ୍‌ ଆକା କିନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ଜିସୁ ଇକା ୱେନ୍‌ଞ୍ଜି କାବାଆତାନ୍ ମାରି ୱାନି ୱେନ୍‌କା ୱାଜିମାରି ଲୋକାଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‍ଇଜିନା, ଇସ୍ରାଏଲ୍‌ତୁ ବା ଏମେ ଲୋକାମାନୁ ଇୟା ଲୋକ୍‌ତି ୱାଜା ବିସ୍‌ବାସ୍‌ ନାନ୍‍ ତଏ । ");
INSERT INTO kfcp_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ନାନ୍ ସତ୍‌ ଇଜିନା, ୱେଡ଼ାସନି ତରିଟି ଦେସ୍‍ତାନ୍‍ ମାରି ୱେଡ଼ାଆର୍‌ନି ତରିଟି ଦେସ୍‍ତାନ୍‍ ନାଣ୍ତ ଲୋକୁ ୱାଜି ଅବ୍ରାହାମ, ଇସ୍‌ହାକ୍‌ ମାରି ଜାକୁବଦି ୱାଲେ ମୁସ୍‌କୁପୁର୍‌ତି ରାଜିଦୁ ଅର୍‌ସେ ବଜିଦୁ ଉଣ୍ତେଙ୍ଗ୍‌ ବାସ୍‍ନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ମାତର୍‌ ଏମେକାର୍‌ ଇୟା ମାପୁରୁଦି ରାଜିଦୁ ମାନି ମାଟା, ୱାରିଙ୍ଗ୍‌ ଆତ୍‌ରେ ସିକାଟିଦୁ ପକ୍‍ନାର୍‍ । ଆବେ ୱାର୍‌ ଆଡ଼୍‍ବାଜି ପାଲ୍‍କୁ କାତ୍ରେ କିନାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ଜିସୁ ନେତେଙ୍ଗ୍‍ ଇର୍ହାନ୍‌, “ଇନ୍‌ଡ୍ର ସାଙ୍ଗ୍‍ଆ । ନିନ୍‌ ଆମାକା ବିସ୍‌ବାସ୍‌ କିଜିନି, ଆକାନେ ଗଟାନାତ୍‌ ।” ଟିକ୍‌ ଆୟା ସମୟତୁ ନେତାଦି ପାଣିକିନିକାନ୍‌ ନେଗେନ୍‌ଆତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ତାନେ ୱେନ୍‌କା ଜିସୁ ପିତରକା ଇନ୍‌ଡ୍ର ସଲ୍‌ସି ସୁଡ଼ୁତାନ୍‌, ପିତରତି ମିମ୍‍ସି ନବ୍‍ଆଜି କାଟେଲ୍‍ତୁ ଡରିତାମାନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ଜିସୁ ତାନି କିୟୁଦିଙ୍ଗ୍‍ ମୁଟ୍‍ତି ଦାପ୍ରେ ତାନିଙ୍ଗ୍‌ ନବ୍‌ ଡ଼ିସ୍‌ତାତ୍‌ ମାରି ୱାଦ୍‌ ନିଙ୍ଗ୍‍ଜି ୱାରିଙ୍ଗ୍‌ ସେବା କିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ମିଲ୍‌ମିଲିକା ଆତାତ୍‌ଆକା ଲୋକୁ ନାଣ୍ତ ଦୁବେଙ୍ଗ୍‌ ଆସ୍‍ତି ଲୋକାଙ୍ଗ୍‌ ଜିସୁ ଲାକ୍‌ତୁ ତାତାର୍‌ । ଉଣ୍ତ୍ରି ପଦ୍‌ ମାତର୍‌ ମାଟାଦାନ୍‌ ୱାନ୍‌ ତାଗ୍‌ଇ ଆତ୍ମେଆଙ୍ଗ୍‍ଁ ପେରିତାନ୍‍ ମାରି ରଗ୍‌ ଲୋକାଙ୍ଗ୍‌ ନେଗେଣ୍ତ୍‌ କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ଇୟାୱାଜା ୱାନ୍‌ ବାବବାଦି ଜିସାୟଦି ବବିସତ୍‍ବାଣି ସତ୍‌ କିତାନ୍‌ । ଜିସାୟ ଇର୍ହାମାର୍ହାନ୍‌, “ୱାନ୍‌ ମା ଦୁକୁକାସ୍ଟୁ ୱିଜୁ ଅତାନ୍‍ ମାରି ମା ରଗ୍‌ ନେଗେନ୍‌କିତାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ୱାନି ସାରିବେଡ଼୍‍ତି ଲୋକୁ ୱିଜେରେ ଉଣ୍ତାନିକା ସୁଡ଼୍‌ଜି, ଜିସୁ ୱାନି ସିସୁରିଙ୍ଗ୍‌ ଗାଡାଦି ଆୟା ପାଡ଼ି ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଇର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ଅରେନ୍‍ ଦାର୍ମୁଗୁରୁ ୱାଜି ଜିସୁଙ୍ଗୁଁ ଇର୍ହାନ୍‌, “ଗୁରୁ, ନିନ୍‌ ଏମେ ବାଡିଦୁ ସନି, ଆବେ ସନ୍‍ଡ୍ରେଙ୍ଗ୍‍ ଇଜି ନାନ୍ ତିଆର୍‍ଆତାମାନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଗଲୁଦିଙ୍ଗ୍‍ ତେବାଦେଙ୍ଗ୍‍ ସାରାଆ ମାନାତ୍‌, ବାଦଡ଼୍‍ତି ପଟିଦିଙ୍ଗ୍‍ ତେବାଦେଙ୍ଗ୍‍ ଜାଲୁ ମାନାତ୍‌ । ମାତର୍‌ ଗୁର୍‍ଦେଙ୍ଗ୍‍ ନି ରମ୍‍ଦେଙ୍ଗ୍‍ ଇଜି ମନୁସ୍ୟପୁତ୍ରଦିଙ୍ଗ୍ ବାଡି ସିଲେତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ଜିସୁଦି ମାରି ଅରେନ୍‌ ସିସୁ ଇର୍ହାନ୍‌, “ପ୍ରବୁ, ଆଗ୍‌ଡ଼ି ଡ଼େସି ସଲ୍‌ସି ନା ବୁବେଙ୍ଗ୍‌ ମୁସ୍‍ତେଙ୍ଗ୍‍ ଇଜି ନାଙ୍ଗିଁ ସାରି ସିଦା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନା ୱେନ୍‌କା ୱେନ୍‌କା ରାଆ, ସାତି ୱାରିଙ୍ଗ୍‌ ନିଜେ ନିଜେଦି ସାତି ଲୋକାଙ୍ଗ୍‌ ମୁସ୍‍ତେଙ୍ଗ୍‍ ଇଜି ଡ଼ିସ୍‍ତୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ଅର୍‍ଲେନ୍‍ ଜିସୁ ଡଙ୍ଗାଁଦୁ ଏକ୍‍ତି ୱେନ୍‌କା ୱାନି ସିସୁର୍‍ ୱାନି ୱେନ୍‌କା ୱେନ୍‌କା ସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ଦାପ୍ରେ ଗାଡାଦୁ ଉଣ୍ତ୍ରି ପେରି ଗାଲିପିର୍‍ରୁ ନିଙ୍ଗିଁତାତ୍‍ ମାରି ଡଙ୍ଗାଁ ଉଲ୍‍କାଏର୍‍ତୁ ମୁଡ଼ୁଗ୍‍ଦେଙ୍ଗ୍‍ ଆସ୍‌ତାତ୍‌ । ମାତର୍‌ ନାସ୍ତିୱାଲେ ଜିସୁ ସୁଜିତାମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ସିସୁର୍‍ ଜିସୁଙ୍ଗୁଁ ନିକ୍‍ସି ଇର୍ହାର୍‌, “ଏ ପ୍ରବୁ, ମାଙ୍ଗିଁ ରକିୟାକିଆ । ଆଏତିଙ୍ଗ୍‍ ମାପ୍‌ ମୁଡ଼ୁଗିନା ସାନାପ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଏନ୍ଦା ମିର୍‌ ନିସ ତିଲାଜିନିଦେର୍‌ ?” ମିର୍‌ ଇନିକା ନିସ ଅଡ଼ପ୍‍ ବିସ୍‍ବାସିର୍‍ ? “ତାନିୱେନ୍‍କା ୱାନ୍‌ ନିଙ୍ଗ୍‍ଜି ଗାଲି ନି ଉଲକାଏର୍‍ତିଙ୍ଗ୍‍ ତିର୍‍ ଆଦେଙ୍ଗ୍‍ ଇଜି ଆଦେସ୍‌ ସିତାନ୍‌ ।” ଦାପେ ଦାପେ ୱିଜୁ ତିର୍‌ ଆତାସର୍ହାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ଆବେଟ୍‌ ୱିଜେରେ କାବା ଆତାର୍‌ । ୱାର୍‌ ନିଜେ ନିଜେମାନୁ ୱାର୍‍ଗି ସତାର୍‍, “ଇକାନ୍‌ ଏଣ୍ତେସ୍‌ ନାନି ଲୋକୁ ? ଗାଲି ନି ଉଲ୍‍କା ବା ୱାନି ଆଦେସ୍‌ ମାନାଜିନେ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ୱେନ୍‌କା ଜିସୁ ଗାଡା ଆୟା ପାଡ଼ିଦି ଗାଦରିୟରି ରାଜିଦୁ ଇତି ଦାପ୍ରେ ରିଏର୍‌ ଲୋକାଙ୍ଗ୍‌ ବେଟ୍‌ବୁଡ଼ାତାନ୍‌ । ୱାର୍‌ ଆବେ ମାନି ଦୁକିଗୁଟାଦୁ ତେବାଜିମାର୍ହାର୍‍ । ୱାର୍‌ ଦୁବେଙ୍ଗ୍‍ କାସ୍ତିକାର୍‍ ମାରି ନିସ ତିୟେଲ୍‍ଜେ ଆୟା ସାରିସିଜି ସନିୱାନିକା କିଦେଙ୍ଗ୍‌ ଏନ୍‌ ସାସ୍‌ କିଏଜିମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ସୁଡ଼୍‍ତି ଦାପ୍ରେ ଆଉଲି ଆଜି ଇର୍ହାନ୍‌, “ଏ ମାପୁରୁଦି ମାରିସି ! ମାବାଣ୍‍କୁ ନିନ୍‌ ଇନିକା ବଦାକିନି ? ମା ବେଡ଼ା ଆଏନ୍‍ଣ୍ତା ମାଙ୍ଗିଁ ଇନିକା ଦଣ୍ଡ୍‌ ସିଦେଙ୍ଗ୍‍ ୱାତିମାନି ?” ");
INSERT INTO kfcp_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ଆବେଣ୍‌କୁ ଏସ ଆକଉଣ୍ତ୍ରି ପେରି ପାନ୍‍ଣ୍ତ୍ରିଙ୍ଗ୍‍ ମାନ୍ଦା ସାରାଜିମାର୍‌ଏ । ");
INSERT INTO kfcp_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ଆୟା ଲୋକାମାନୁ ମାନି ତାଗ୍‌ଇ ଆତ୍‍ମେଙ୍ଗ୍‍ ଜିସୁଙ୍ଗୁଁ ମାଡ଼ିସ୍‍ କିଜି ଇର୍‌ଏ, “ମାଙ୍ଗିଁ ଜଦି ପେର୍‍ଦେଙ୍ଗ୍‍ ବଦାକିଜିନି, ଆୟା ପାନ୍‍ଡ୍ରି ମାନ୍ଦା ଲୋଇ ମାଙ୍ଗିଁ ପକ୍‍ଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ଜିସୁ ଇର୍ହାନ୍‌, “ସାନ୍‍ଡ୍ରୁ” ଦୁବେଙ୍ଗ୍‍ ଦାପେ ଦାପେ ଲୋକାଙ୍ଗ୍‌ ଡ଼ିସ୍‌ସି ପାନ୍‍ଡ୍ରି ମାନ୍ଦା ଲୋଇ ଡ଼ୁଗିତେ । ପାନ୍‍ଡ୍ରି ମାନ୍ଦା ଉରୁକ୍‍ସି ସର୍ହେ ମାରି ଗରନ୍‌ ଟିପୁଦାନ୍‍ ଉରୁକ୍‌ସି ସଲ୍‌ସି ସାମ୍‌ଦୁର୍‌ତୁ ଆର୍‌ଜି ମୁଡ଼ୁଗିତେ ସାତେ । ");
INSERT INTO kfcp_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ପାନ୍‍ଡ୍ରିଆଙ୍ଗ୍‍ ସାଆରା କିନି ଲୋକୁ ଲାକ୍‌ତୁରି ଗାଡ଼୍‌କାଙ୍ଗ୍‌ ନି ନାର୍‍କାଙ୍ଗ୍‍ଁ ସଲ୍‌ସି ଦୁବେଙ୍ଗ୍‍ ଆସ୍‍ତି ଲୋକାଙ୍ଗ୍‌ ଇନିକା ଗଟାତାମାର୍ହାତ୍‍ ମାରି ଆଇ ୱିଜୁ ମାଟା ଆବେ ୱେର୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ଆଦେଙ୍ଗ୍‌ ଆୟା ଗାଡ଼୍‌ତି ୱିଜେରେ ଜିସୁଙ୍ଗୁଁ ବେଟ୍‍ବୁଡ଼ାଦେଙ୍ଗ୍‍ ସହସି ୱାତାର୍‌ ମାରି ୱାନିଙ୍ଗ୍‌ ସୁଡ଼୍‍ତି ୱେନ୍‌କା ଆୟା ରାଜିଦାନ୍‍ ଡ଼ିସ୍‌ସି ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଜିସୁଙ୍ଗୁଁ ମାଡ଼ିସ୍‍କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ଜିସୁ ଡଙ୍ଗାଁଦୁ ବାସ୍‌ସି ଗାଡାଦି ଆୟାପାଡ଼ି ମାନି ୱାନି ଗାଡ଼୍‌ତୁ ଡ଼େସିସର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ଆବେ ଅରେନ୍‍ ଲୋକ୍‌ ପକିୟାଗାତି ରୋଗ୍‌ ଲୋକ୍‌ତିଙ୍ଗ୍‌ ଲୋକୁ ୱାନି ଲାକ୍‌ତୁ ତାତାର୍‌ । ରଗ୍‍ତିକାନ୍‍ ୱାନି ଖାଟେଲ୍‍ତୁ ଡରିତାମାର୍ହାନ୍‍ । ୱାରି ନିସ ବିସ୍‌ବାସ୍‌ ସୁଡ଼୍‌ଜି ଜିସୁ ପକିୟାଗାତି ରୋଗ୍‌ ଲୋକ୍‌ତିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଏ ମାରିନ୍‌, ସାହାସ୍‍ ଆସ୍‍ଆ । ନି ପାପ୍‌ୱିଜୁ କେମା ଆତାମାନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ଏସ ସାସ୍ତ୍ରିର୍‍ ଇୟା ମାଟା ୱେନ୍‌ଞ୍ଜି ୱାରି ୱାରି ଲୋଇ ୱାର୍‍ଗିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାର୍‌, “ଇୟା ଲୋକୁ ମାପୁରୁଙ୍ଗ୍‌ ନିନ୍ଦା କିଜିନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ୱାରି ମୋନ୍‌ତୁ ମାଟା ନେସ୍‌ସି ଜିସୁ ଇର୍ହାନ୍‌, ମିର୍‌ ଏନ୍ଦା ନିଜେ ନିଜେଦି ମନ୍‌ତୁ ଇୟାୱାଜା ତାଗ୍‌ଇ ମାଟା ଅଡ଼୍‍ବିଜିନିଦେର୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ଇନିକା ଉସାସ୍‌ ? ନି ପାପ୍‌ୱିଜୁ କେମା ଆତାତ୍‌ ଇଜି ଇନିକା, ମାରି, ନିଙ୍ଗିଁଆ, ବୁଲାଆ ଇଜି ଇନିକା ? ");
INSERT INTO kfcp_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ମାତର୍‌ ପାପ୍‌କେମା କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ବା ଦୁନିଆଦୁ ମନୁସ୍ୟପୁତ୍ରଦି ଅଦିକାର୍‍ ମାନାତ୍‍, “ଇୟା ମାଟା ମି ଆଗ୍‌ଡ଼ି ପାର୍‍ମାଣ୍‍କିନା ।” ତାନିୱେନ୍‍କା ଜିସୁ ପକିୟାରଗିଙ୍ଗ୍‍ ଇର୍ହାନ୍‌, “ନିଙ୍ଗିଁଆ, ନିଜେଦି ଟାଟି ଆସ୍‌ସି ମି ଇଣ୍ତ୍ରସାଙ୍ଗ୍‍ଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ରଗ୍‌ ଲୋକୁ ନିଙ୍ଗ୍‍ଜି ଇନ୍‌ଡ୍ର ସର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ଲୋକୁ ଇକା ସୁଡ଼୍‌ଜି ତିଲାତାର୍‍ । ମାତର୍‌ ଲୋକ୍‌ତିଙ୍ଗ୍‌ ଇୟାୱାଜା ଅଦିକାର୍‌ ସିତାମାନାନ୍‍ଆକା ୱାର୍‌ ମାପୁରୁଦି ଦନ୍ୟବାଦ୍‍ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ଜିସୁ ଆବେଟ୍‌କୁ ବୁଲାଜିସନିୱାଲେ ମାତିଉ ଦର୍‌ତି ଅରେନ୍‍ ସିସ୍‍ଟୁ ଲୋସ୍‍ନିୱାନିଙ୍ଗ୍‍ ନିଜେଦି ପାଣିକିନି ବାଡିଦୁ ବାସ୍‍ନିମାନିକା ସୁଡ଼ୁତାନ୍‍ ମାରି ୱାନିଙ୍ଗ୍‌ କୁକ୍‌ସି ଇର୍ହାନ୍‌, “ନା ୱେନ୍‌କା ୱେନ୍‌କା ରାଆ ।” ମାତିଉ ନିଙ୍ଗ୍‍ଜି ୱାନି ୱେନ୍‌କା ସର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ଜିସୁ ମାତିଉରି ଇଲ୍‌ତୁ ଉଣିୱାଲେ ନାଣ୍ତ ସିସ୍‍ଟୁ ଲୋସ୍‌ନିକାର୍‌ ମାରି ପାପି ଲୋକୁ ୱାନି ୱାଲେ ମାରି ୱାନି ସିସୁରି ୱାଲେ ଉଣ୍ତେଙ୍ଗ୍‌ ବାସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ଏସଲୋକ୍‌ ପାରୁସିର୍‌ ଆକା ସୁଡ଼୍‌ଜି ଜିସୁଦି ସିସୁରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, “ମି ଗୁରୁ ସିସ୍‍ଟୁ ଲସ୍‍ନିୱାରିୱାଲେ ନି ପାପିଲୋକା ୱାଲେ ଏନ୍ଦା ଅର୍‌ସେ ବାସ୍‌ସି ଉଣୁଜିନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ଜିସୁ ୱାରି ମାଟା ୱେନ୍‌ଞ୍ଜି ଇର୍ହାନ୍‌, “ନେଗି ଲୋକା ଉଣ୍ତିଙ୍ଗ୍‌ ଡାକ୍‌ତର୍‌ତି ଲୋଡ଼ା ସିଲେତ୍‌ । କେବଲ୍‌ ରଗ୍‌ ଲୋକୁ ଡାକ୍‌ତର୍‌ତି ଲୋଡ଼ାକିନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ସାସ୍ତ୍ରଦୁ ରାସାତାମାନାତ୍‌, ନାନ୍ ବଦାକିନା ଦୟା, ପୁଜାସିନିକା ସିଲେ ଇୟା ମାଟାଦି ଅର୍ତ ଇନିକା, ସଲ୍‍ସ ବୁଜାଦେଙ୍ଗ୍‌ ବଦାକିଦୁ । ନାନ୍ ଦାର୍ମୁ ଲୋକାଙ୍ଗ୍‌ କୁକ୍‍ତେଙ୍ଗ୍‍ ରେଏ; ମାତର୍‌ ପାପି ଲୋକାଙ୍ଗ୍‌ କୁକ୍‍ତେଙ୍ଗ୍‍ ଇଜି ୱାତାମାନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ତେନିୱେନ୍‍କା ଡୁବନ୍‌ ସିନି ଯୋହନତି ସିସୁର୍‍ ଜିସୁ ଲାକ୍‌ତୁ ୱାଜି ୱେନ୍‌ବାତାର୍‌, “ମାପ୍‌ ନି ପାରୁସିର୍‌ ନିସ ଦେବେଙ୍ଗ୍‌ ଉପାସ୍‌କିଜିନାପ୍‍, ନି ସିସୁର୍‍ ଏନ୍ଦା ଏସାଙ୍ଗ୍‍ ବା ଉପାସ୍‍କିଏଜିନାର୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ଜିସୁ ଇର୍ହାନ୍‌, ପେଡ଼ିଦୁ ମୁରୁଲି ମାନିସାନ୍ଦି କୁଡ଼ାଙ୍ଗାଁ ଇନିକା ଦୁକ୍‍କିନାର୍‍ ? ଏସାଙ୍ଗ୍‍ ସିଲେ । ମାତର୍‌ ଦିନ୍‌ ୱାନାତ୍‌, ଏସ୍ତିୱାଲେ ମୁରୁଲି ସନାନ୍‌; ନାସ୍ତିୱାଲେ ୱାର୍‌ ଉପାସ୍‌ କିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“ଏନ୍‌ ପାଡ଼ିଇ ୱାତିଦୁ ପୁନି କନାଦି ଜାଲି ଗୁତ୍‍ଏନ୍‍ । ଇରିଙ୍ଗ୍‌ ପୁନି କନାଦି ଜାଲି ରେଲାଇଆଜି କିଜିତି ବାଡିଦିଙ୍ଗ୍‍ ନାଣ୍ତ କିଜିସ୍‍କିନାତ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“ଏନ୍‌ ପାଡ଼ିଇ ତଲ୍‍ ମଣିଦୁ ପୁନି ଅଙ୍ଗୁର୍‍ରସ୍‍ ବର୍ତିକିଜି ଇଡ୍‌ଏନ୍‌ । ଇରିଙ୍ଗ୍‌ ଆବେଟ୍‌କୁ ମଣି ପାଡ୍‍ଜିସଲ୍‍ସି ସେଏଣ୍ତ୍‍ଆନାତ୍‍ ମାରି ଅଙ୍ଗୁର୍‍ରସ୍‍ ସହସି ଆଡ୍‍ଗିୱାଙ୍ଗ୍‍ଁନେ । ଅଙ୍ଗୁର୍‍ ରସ୍‌ତିଙ୍ଗ୍‌ ପୁନି ତଲ୍‍ ମଣିଦୁ ଇଟ୍‌ତିଙ୍ଗ୍‌, ରୁଣ୍ତି ଅଙ୍ଗୁର୍‍ରସ୍‍ ନି ତଲ୍‍ମଣି ନେଗେଣ୍ତ୍‍ତେବାନେ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ଜିସୁ ଇୟାୱିଜୁ ସିକିୟା ସିନିୱାଲେ ଅରେନ୍‍ ଜିହୁଦି ପେରି ପାଣିକିନିକାନ୍‌ ୱାନି ଲାକ୍‌ତୁ ୱାଜି ମେଣ୍ତେଙ୍ଗ୍‍ ଗଟ୍‌କିଜି ଇର୍ହାନ୍‌, “ଇୟାଦାପ୍ରେ ନା ଗାଡ଼ି ସାତାମାନାତ୍‍ । ମାତର୍‌ ନିନ୍‌ ୱାଜ ତାନି ମୁସ୍‌କୁ କିୟୁ ଇଟ୍‌ତିଙ୍ଗ୍‌, ୱାଦ୍‌ ସତେନେ ଜିନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ଦାପେ ଦାପେ ଜିସୁ ନିଙ୍ଗିଁତାନ୍‍ ମାରି ୱାନ୍‌ ନି ୱାନି ସିସୁର୍‍ ଆୟା ପାଣିକିନିୱାନି ୱେନ୍‌କା ୱେନ୍‌କା ସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ୱେନ୍‌କା ଅରେତ୍‌ ଆଇମାଲୋକ୍‍ ୱାନି ୱେନ୍‌କା ତରିଟାନ୍‍ ୱାଜି ୱାନି ୱାତି ଜାଲିଦିଙ୍ଗ୍‌ ମୁଟ୍‍ତାତ୍‍ । ୱାଦ୍‌ ବାର ବାର୍‍ସେକ୍‍ ସାନ୍ଦି ସୁତୁକ୍‍ ଆନି ରୋଗ୍‌ ଦଣ୍ତ୍‌ବଗାଜି ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ୱାଦ୍‌ ମୋନ୍‌ତୁ ମୋନ୍‌ତୁ ଅଡ଼୍‍ବିତାତ୍‍, “କେବଲ୍‌ ୱାନି ୱାତିଦିଙ୍ଗ୍‌ ମୁଟ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‌ତିଙ୍ଗ୍‌, ନାନ୍ ନେଗେନ୍‍ ଆନାସନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ଜିସୁ ମାର୍‍ଜି ବେସ୍‍ସି ତାନିଙ୍ଗ୍‌ ସୁଡ଼ୁତାନ୍‌ ମାରି ଇର୍ହାନ୍‌, “ଆଇଲି, ସାହାସ୍‍ ଆସ୍‌ଆ । ନି ବିସ୍‌ବାସ୍‌ ନିଙ୍ଗିଁ ନେଗେନ୍‌ କିତାମାନାତ୍‌ ।” ଆୟା ଦାପ୍ରେ ଆୟା ଆଇମା ନେଗେନ୍‍ ଆତାସର୍ହାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ତାନି ୱେନ୍‍କା ଜିସୁ ଆୟା ଜିହୁଦିରି ପେରି ପାଣିକିନିୱାନି ଇଲ୍‌ତୁ ଇତାନ୍‌ । ଆବେଟ୍‌ ମୁସ୍‍ନିୱାଲେ ପିରଡ଼ି ଉକୁତେଙ୍ଗ୍‍ ଇଜି କୁକ୍‍ତିମାର୍‍ଇ ଲୋକ୍ ନି ଆଇ ଲୋକୁ ଆଉଲିଆଜିମାନିକା ସୁଡ଼୍‌ଜି, ");
INSERT INTO kfcp_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ଜିସୁ ଇର୍ହାନ୍‌, “ୱିଜେରେ ଇବେଟ୍‌କୁ ସହସ ସାନ୍‍ଡ୍ରୁ ! ଆଇଲି ସାଏତ୍‌ । କେବଲ୍‌ ୱାଦ୍‌ ସୁସ୍‍ତାମାନାତ୍‍ !” ୱାନି ମାଟା ୱେନ୍‌ଜି ୱିଜେରେ ବାସେ କିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ମାତର୍‌ ୱାର୍‌ ସତି ସର୍‍ରି ୱେନ୍‌କା ଜିସୁ ଆଇଲିଦି ବାକ୍‍ରାଦୁ ସଲ୍‌ସି ତାନି କିୟୁ ଆସ୍‌ସି ନିକ୍‍ତାନ୍‍ ମାରି ୱାଦ୍‌ ନିଙ୍ଗିଁତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ଇୟା ଗଟ୍‌ନାଦି କାବୁର୍‌ ଆୟା ରାଜି ୱିଜୁ ତରିନ୍‌ ୱେଙ୍ଗିଁତା ସର୍ହାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ଜିସୁ ଆବେଟ୍‌କୁ ସନିୱାଲେ ରିଏର୍‌ କାଣାର୍‌ ୱାନି ୱାଲେସର୍ହାର୍‍ । ୱାର୍‌ ଆଉଲିଇଜି ଇର୍ହାର୍‌, “ଏ ଦାଉଦତି ମାରିନ୍‌, ମାଙ୍ଗିଁ ଦୟା କିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ଜିସୁ ଉଣ୍ତ୍ରି ଇନ୍‌ଡ୍ର ଡ଼ୁଗିତାନ୍‍ । ମାରି ୱାନ୍‌ ବା ସଲ୍‌ସି ଆୟା ଇନ୍‌ଡ୍ର ଡ଼ୁଗିତାର୍‍ । ଆବେ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ନାନ୍ ମିଙ୍ଗିଁ ନେଗେନ୍‌ କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାଇଜି ବିସ୍‌ବାସ୍‌ କିଜିନିଦେର୍‍ନୋ ?” ୱାର୍‌ ଇର୍ହାର୍‌, “ହୁଁ ପ୍ରବୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ନାସ୍ତିୱାଲେ ଜିସୁ ୱାରି କାଣ୍‌କାଙ୍ଗ୍‌ ମୁଟ୍‍ସି ଇର୍ହାନ୍‌, “ମି ବିସ୍‌ବାସ୍‌ ଇସାବ୍‌ତାନ୍‌ ଆକା ଆପିତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ଆୟାଦାପ୍ରେ ୱାର୍‌ କାଣୁକୁ ସୁଡ଼୍‍ଦେଙ୍ଗ୍‍ ଆଟ୍‌ତାର୍‌ । ଜିସୁ ୱାରିଙ୍ଗ୍‌ ନାଣ୍ତ ଆଟ୍‌ୱା ଆଦେସ୍‌ ସିଜି ଇର୍ହାନ୍‌, “ଜାଗାର୍‌ତା ! ଏନ୍‌ ଏଣ୍ତେସ୍‌ ଇୟା ମାଟା ନେସ୍‌ଏନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ମାତର୍‌ ୱାର୍‌ ଆବେଟ୍‌କୁ ସହସି ସଲ୍‌ସି ଜିସୁଦି ଇୟା ମାଟା ୱିଜୁ ରାଜି ତରିନ୍‌ ୱେର୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ୱାର୍‌ ସନିୱାଲେ ଏସ ଲୋକୁ ଅରେନ୍‍ ଗୁଲେଙ୍ଗ୍‍ ଜିସୁ ଲାକ୍‌ତୁ ତାତାର୍‌ । ୱାନିଙ୍ଗ୍‌ ଦୁବା ଆସ୍‍ତାମାର୍ହାତ୍‍ ଆକା ୱାନ୍‌ ଗୁଲା ଆତାସର୍ହାମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ଜିସୁ ୱାନି ମେନ୍ଦଲ୍‌ତାନ୍‌ ଦୁବାଦିଙ୍ଗ୍‌ ସପ୍‌ତି ଦାପ୍ରେ ୱାନ୍‌ ମାଟା ୱାର୍‍ଗିଦେଙ୍ଗ୍‍ ଆସ୍‍ତାନ୍‍ । ୱିଜେରେ କାବାଆଜି ଇର୍ହାର୍‌, “ଇସ୍ରାଏଲ୍‌ ଦେସ୍‌ତୁ ମାପ୍‌ ଇୟାୱାଜା ପାଣି ଏସାଙ୍ଗ୍‍ ସୁଡ଼ୁଏପ୍‍ମାର୍ହାପ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ମାତର୍‌ ପାରୁସିର୍‌ ଇର୍ହାର୍‌, “ଇୟା ଲୋକୁ ଦୁବେଙ୍ଗାଁ ପେରିକାତ୍‍ ବାଲ୍‍ଜିବୁଲ୍‍ ସାକ୍ତିଦାନ୍‌ ଦୁବେଙ୍ଗ୍‍ଁ ଡ଼ିସିସ୍‍ନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ଜିସୁ ବୁଲାଜି ବୁଲାଜି ନାଣ୍ତ ଗାଡ଼୍‌କାଙ୍ଗ୍‌ ନି ନାର୍‍କାଙ୍ଗ୍‍ଁ ସର୍ହାନ୍‍ । ୱିଜୁ ବାଡିଆଙ୍ଗ୍‍ ୱାନ୍‌ ପାର୍‍ତନାକିନି ଇଲ୍‌କାଙ୍ଗ୍‌ ସିକିୟା ସିତାନ୍‌, ମାପୁରୁଦି ରାଜିଦି ନେଗିକାବୁର୍‌ ପ୍ରଚାର୍‌ କିତାନ୍‌ ମାରି ନବ୍‍ଆତିୱାରିଙ୍ଗ୍‍ ନି ରଗ୍‌ ଲୋକାଙ୍ଗ୍‌ ନେଗେନ୍‌କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ଲୋକାଙ୍ଗ୍‌ ସୁଡ଼୍‌ଜି ୱାନ୍‌ ୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ଦୁଃକ୍‌‍ କିତାନ୍‌, ଇରିଙ୍ଗ୍‌ ଗାଉଡ଼ୁ ସିଲି ମେଣ୍ତେଙ୍ଗାଁ ମାନ୍ଦା ୱାଜା ୱାର୍‌ ସାକାସିଲିକା ନି ସିନ୍ତା ଆଜିମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ଆଦେଙ୍ଗ୍‌ ୱାନ୍‌ ସିସୁରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ପାସିନାଣ୍ତ ଆତାମାନାତ୍‌, ମାତର୍‌ ତାନିଙ୍ଗ୍‌ ଉଣ୍ତାକିଦେଙ୍ଗ୍‌ ଇଜି ନାଣ୍ତଲୋକ୍‍ କୁଲିକିନିକାର୍‍ ସିଲେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ନାଣ୍ତଲୋକ୍‍ କୁଲିକିନିୱାରିଙ୍ଗ୍‍ ପକ୍‍ସି ପାସିଉଣ୍ତାକିଜି ଅତେଙ୍ଗ୍‌ ଇଜି ପାସି ମାଲିକ୍‍ତିମାନୁ ପାର୍‌ତନା କିଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ଜିସୁ ୱାନି ବାରଲୋକ୍ ସିସୁରିଙ୍ଗ୍‌ କୁକ୍‌ସି ଦୁବେଙ୍ଗ୍‍ ଡ଼ିସିସ୍‍କିଦେଙ୍ଗ୍ ଇଜି ମାରି ୱିଜୁ ରକମ୍‌ତି ରଗ୍‌ କାସ୍ଟୁ ନେଗେନ୍‌ କିଦେଙ୍ଗ୍‍ ଇଜି ଅଦିକାର୍‌ ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ଆୟା ବାର ଲୋକ୍ ପ୍ରେରିତ ସିସୁରି ଦର୍‌ ଆତାତ୍‌ ସିମୋନ ପିତର୍‌ ଦର୍‌ତାନ୍‌ ବା ୱେଙ୍ଗ୍‌ଁନାତ୍‌ ମାରି ୱାନି ତଡ଼ାନ୍‌ ଆନ୍ଦ୍ରିୟ; ଜେବଦଦି ରିଏର୍‌ ମାରିସିର୍‌ ଜାକୁବ ନି ଯୋହନ; ");
INSERT INTO kfcp_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ପିଲିପ୍‌, ବାର୍ତଲମି, ଥୋମା, ମାରି ସିସ୍‍ଟୁ ଲୋସ୍‍ନି ମାତିଉ, ଆଲପିଦି ମାରିସି ଜାକୁବ, ଥଦ୍ଦୀୟ; ");
INSERT INTO kfcp_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","କିଣାନିୟ ସିମୋନ ଏନ୍‌ କି ଇସ୍ରାଏଲ୍‌ ଦେସ୍‍ତିଙ୍ଗ୍‍ ରକିୟା କିଦେଙ୍ଗ୍‌ ବଦା କିଜିମାର୍ହାନ୍‍ ମାରି ଜିସୁଙ୍ଗୁଁ ସାତ୍ରୁରି କିୟୁଦୁ ସର୍ପେ କିତିସିତି ଇସ୍କାରିୟୋତିୟ ଜିହୁଦା । ");
INSERT INTO kfcp_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ଜିସୁ ଇୟା ବାରଲୋକ୍‌ ସିସୁରିଙ୍ଗ୍‌ ପକ୍‍ନିୱାଲେ ଆଦେସ୍‌ ସିଜିଇର୍ହାନ୍‍, “ମିର୍‌ ଅଣଜିହୁଦିରି ରାଜିଦୁ ସଲ୍‍ମାଟ୍‍ । ମାରି ଆମା ସମିରୋଣ ଗାଡ଼୍‌ତୁ ବା ସଲ୍‍ମାଟ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ମାତର୍‌ ମୁର୍‍ତିମାନି ମେଣ୍ତେଙ୍ଗାଁ ୱାଜା ଇସ୍ରାଏଲ୍‌ତି ଲୋକା ଲାକ୍‌ତୁ ସାନ୍‍ଡ୍ରୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ୱାରିମାନୁ ପ୍ରଚାର୍‌ କିଜି ଇନ୍‍ଡ୍ରୁ, ମୁସ୍‌କୁପୁର୍‌ ଇଗା ୱାତାତ୍‍ ! ");
INSERT INTO kfcp_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ରଗ୍‍ତୁ ମାନି ଲୋକାଙ୍ଗ୍‌ ନେଗେନ୍‍କିଦୁ, ସାତି ଲୋକାଙ୍ଗ୍‌ ଡ଼େସି ନିକ୍‍ତୁ, କୁସ୍ଟରୋଗ୍‌ତି ଲୋକାଙ୍ଗ୍‌ ନେଗେନ୍‍କିଦୁ, ଦୁବେଙ୍ଗ୍‍ ଡ଼ିସିସ୍‍ କିଦୁ । ଆମାକା ଆର୍‍ଏ ପୟ୍‌ତିମାନିଦେର୍‌, ଆକା ଆଇୱାରିଙ୍ଗ୍‌ ଆର୍‍ଏ ସିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ଅର୍‌ସେ ବାଙ୍ଗାଁରାମ୍‍ ନି ୱେଣ୍ତି ବା ଡାବୁଙ୍ଗୁଁ ଇଡ୍‌ନି ମଣି ଅମାଟ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ମାରି ଡ଼ଆନି ମଣି ଆସ୍‌ସି ବୁଲାମାଟ୍‍ । ନାଣ୍ତ ଆଙ୍ଗିଁଙ୍ଗ୍‌, ଜୁତେଙ୍ଗ୍‌ ମାରି ବାଡିଗା ବା ଅମାଟ୍‌ । ପାଣିକିନିକାର୍‌ ନିଜେଦି କୁଲି ଡାବୁଙ୍ଗ୍‌ଁ ପୟ୍‌ଦେଙ୍ଗ୍‌ ଜଗ୍‌ ମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“ଉନ୍‌ଡ୍ରି ଗାଡ଼୍‌ ବା ନାର୍‍ତୁ ଇତି ୱେନ୍‌କା ଆବେ ଏନ୍‌ ମି ସେବାକିନାନ୍‍, ଆୟା ମାଟା ମିର୍‌ ପୟ୍‌ଦୁ, ଆଇମାନୁ ସନି ସାନ୍ଦି ତାମେ ଇଲ୍‌ତୁ ମାନ୍‌ଡ଼୍ରୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ଉନ୍‌ଡ୍ରି ଇନ୍‌ଡ୍ର ଡ଼ୁଗୁନି ୱାଲେ ଆବେମାନି ଲୋକାଙ୍ଗ୍‌ ମାଡ଼ିସ୍‍କିଜି ଇନ୍‍ଡ୍ରୁ, ମି ସାନ୍ତି ଆପିତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ଇଲ୍‌ତି ଲୋକୁ ଜଦି ମିଙ୍ଗିଁ ସେବାକିନାର୍‍, ୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ମାଡ଼ିସ୍‌ କିତିକା ସାନ୍ତି ଆନାତ୍‌ । ମାତର୍‌ ଜଦି ୱାର୍‌ ମିଙ୍ଗିଁ ସେବା କିଏର୍‌, ମି ମାଡ଼ିସ୍‍କିନିକା ଡ଼େପ୍‍ସ ଅତୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ଜଦି ଏମେ ଇନ୍‌ଡ୍ର ମାରି ଗାଡ଼୍‌ତୁ ମିଙ୍ଗିଁ ଲୋକୁ ମାନାଏର୍‌, ଆତିଙ୍ଗ୍‌ ୱାରିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ଇଜି ସିନାଦି ୱାଜା ପାଦାମ୍‍ତି ଦୁଡ଼ି ସାଡ଼୍‍ସି ସିଜି ଆୟା ବାଡି ଡ଼ିସ୍‌ସୋ ସିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ବିସାର୍‍ ଦିନ୍‍ତୁ ୱେରି ମାଣ୍‌କୁ ସଦମ୍‍ ଗମୋରାଦି ଲୋକା ଉଣ୍ତିଙ୍ଗ୍‌ ମାପୁରୁ ନାଣ୍ତ ଦୟା ତର୍‍ନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“ୱେନ୍‌ଡ୍ରୁ ! ନୋରେସ୍‍କା ଲାକ୍‌ତୁ ମେଣ୍ତେଙ୍ଗାଁ ୱାଜା ନାନ୍ ମିଙ୍ଗିଁ ପୋକ୍‍ସିନା, ମାରି ସାରାସ୍‌ତି ୱାଜା ଜାଗାର୍‌ତା ମାରି ପାର୍‍ୱାଦି ୱାଜା ସାନ୍ତି ଆଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ଜାଗାର୍‌ତା ମାନ୍‌ଡ଼୍ରୁ, ଇରିଙ୍ଗ୍‌ ଲୋକୁ ମିଙ୍ଗିଁ ତର୍‌ସି ବିସାର୍‌ କିନି ସଭାଦୁ ଅନାର୍‍ର ସର୍ପେ କିନାର୍‌ । ପାର୍‍ତନାକିନି ଇଲ୍‌କାଙ୍ଗ୍‌ ୱାର୍‌ ମିଙ୍ଗିଁ କର୍‍ଡା ଡାକ୍‌ନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ନା ଉଣ୍ତିଙ୍ଗ୍‌ ମିର୍‌ ରାଜା ନି ସାସନ୍‍କିନିୱାରି ଆଗ୍‌ଡ଼ି ତାଆୟ୍‌ଆଜି ବିସାର୍‍ଆନିଦେର୍‍ । ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାରିଙ୍ଗ୍‌ ନି ଅଣଜିହୁଦି ଲୋକାଙ୍ଗ୍‌ ନେଗିକାବୁର୍‌ ସାକି ସିଦେଙ୍ଗ୍‍ ଇଜି ସାରି ପୟ୍‌ନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ମି ବିସାର୍‌ ଆନିୱାଲେ ଇନିକା ଇନିଦେର୍‌, ମାରି ଏଣ୍ତେସ୍‌ ଇନିଦେର୍‌, ଆୟା ବିସୟ୍‌ତାନ୍‌ ସିନ୍ତା କିମାଟ୍‌ । ଟିକ୍‌ ଆୟା ସମୟ୍‍ତୁ ଆକା ମିଙ୍ଗିଁ ୱେର୍‍ଆଇଆଜି ସିଆନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ଇରିଙ୍ଗ୍‌ ମିଙ୍ଗିଁ ନିଜେ ଇନିକା ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆଏତ୍‍ । ମି ବୁବା ମାପୁରୁଦି ପବିତ୍ର ଆତ୍ମା ମି ୱେୟୁ ସିଜି ମାଟା ଇନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“ଆୟା ସମୟତୁ ଲୋକୁ ତଡ଼ାନ୍‍ ତଡ଼ାନ୍‍ତିଙ୍ଗ୍‍ ମାରି ବୁବା ମାରିନ୍‍ତିଙ୍ଗ୍‍ ସାପିସ୍‍ତେଙ୍ଗ୍‍ ଇଜି ସର୍‍ପେ କିଜି ସିନାର୍‍ । ବୁବାସି ବା ନିଜେଦି କଡ଼କକ୍ରାରିଙ୍ଗ୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ଆୟାୱାଜା କିନାନ୍‌ । କଡ଼କକ୍‌ରା ବୁବାସି ଆଇସି ବିରୁଦ୍‍ତାନ୍‍ ନିଙ୍ଗ୍‍ନାରୋ ୱାରିଙ୍ଗ୍‌ ସାୟାମାର୍‌ଗା ଡାକ୍‌ନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ନା ଉଣ୍ତିଙ୍ଗ୍‌ ୱିଜେରେ ମିଙ୍ଗିଁ କାଡ଼୍‍ନାର୍‍; ମାତର୍‌ ଏନ୍‌ ସାରାସାରି ସାନ୍ଦି ବିସ୍‌ବାସ୍‌ତୁ ତିର୍‍ଆଜିତେବାନାନ୍‍, ୱାନ୍‌ ରକିୟା ପୟ୍‍ନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ଉନ୍‌ଡ୍ରି ଗାଡ଼୍‌ତୁ ମିର୍‌ କାସ୍ଟୁ ପୟ୍‌ତିଙ୍ଗ୍‌ ଆଇ ଗାଡ଼୍‌ତୁ ଉର୍‍କ୍‍ତୁ । ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ତାନ୍‌ ଇଜିନା, ମିର୍‌ ଇସ୍ରାଏଲ୍‌ତି ୱିଜୁ ଗାଡ଼୍‌କାଙ୍ଗ୍‌ ପାଣି ସେସ୍‍କିନି ଆଗ୍‌ଡ଼ି ମନୁସ୍ୟପୁତ୍ର ଡ଼େସି ୱାନାମାନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“ଏମେ ସିସୁ ୱାନି ଗୁରୁମାଣାନ୍‍ ସିସୁ ପେରିକାନ୍‌ ଆଏନ୍‍, ମାଲିକ୍‍ତି ମାଣାନ୍‌ ସାକର୍‌ ପେରିକାନ୍‌ ସିଲେ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ସିସୁ ଗୁରୁ ୱାଜା ମାରି ସାକର୍‌ ମାଲିକ୍‍ତି ୱାଜା ଆଦେଙ୍ଗ୍‌ ଆଟ୍‌ତିଙ୍ଗ୍‌ ନାସଦୁନେ ୱେଡ଼ିକା ଆନିକାମାନାତ୍‌ । ଉନ୍‌ଡ୍ରି ଇଲ୍‍ତି ମେମାରିଙ୍ଗ୍‍ ଜଦି ଲୋକୁ ବାଲ୍‍ଜିବୁଲ୍‍ ଇଜି କୁକ୍‍ନାର୍‍, ଇଲ୍‍ତି ଆଇୱାରିଙ୍ଗ୍‌ ମାରି ଏସ ତାଗ୍‌ଇ ଦର୍‌ ସିଏର୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ଲୋକାଙ୍ଗ୍‌ ତିଲାମାଟ୍‌ । ଆମାକା ଇଲେଇ ପିଡ଼ିଗାଇ ଆତାମାନାତ୍‍, ଆକା ତରାଇଆନାତ୍‍ ମାରି ୱିଜୁ ମାର୍‍ଗିତି ମାଟା ୱେଙ୍ଗ୍‌ଁନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ନାନ୍ ମିଙ୍ଗିଁ ଆମାକା ସିକାଟି ସମୟ୍‍ତୁ ଇଜିନା, ଆକା ତାଲାୱେଡ଼ାଦି ସମୟତୁ ୱେକ୍‍ତୁ ମାରି ଆମାକା ମାର୍‍ଗିଜି ୱେର୍‌ଇମାନିଦେର୍‌, ଆକା ଇଲୁ ସାତ୍ ମୁସ୍‌କୁରାନ୍‌ ପ୍ରଚାର୍‌ କିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ଏମେକାର୍‌ କେବଲ୍‌ ମି ମେନ୍ଦଲ୍‌ତିଙ୍ଗ୍‌ ନାସ୍ଟୁକିନାନ୍‍, ମାତର୍‌ ମି ଆତ୍ମାଦିଙ୍ଗ୍‌ ଇନି କେତି କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏନ୍‍, ୱାରିଙ୍ଗ୍‌ ତିଲାମାଟ୍‌ । ମାତର୍‌ ଏମେ ମାପୁରୁ ମି ମେନ୍ଧଲ୍‍ ନି ଆତ୍ମା ରୁଣ୍ତିୱାନିକାଙ୍ଗ୍‍ ନରକଦୁ ଦଂସ କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାନ୍‍, ୱାନିଙ୍ଗ୍‌ ତିଲାଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ଡାବୁଙ୍ଗୁଁ ସିଜି ରୁଣ୍ତି ସାଡ଼ାପୋଟିଙ୍ଗ୍‌ କଣ୍ତେଙ୍ଗ୍‌ ଆଟ୍‌ନିଦେର୍‌, ମାତର୍‌ ମି ବୁବାଦି ସାରି ପୁଟ୍‍ଏତିଙ୍ଗ୍‍ ଉନ୍‌ଡ୍ରି ସାଡ଼ା ପଟି ଆଡ୍‍ଗି ଆର୍‍ଏତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ମାରି ମି ତାଲାଦି କୁକୁଟି ବା ୱିଜୁ ଲେକିସ୍‌ କିଆୟ୍‍ଆତାମାନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ତିଲାମାଟ୍‌, ନାଣ୍ତ ସାଡ଼ାପୋଟିଙ୍ଗାଁ ମାଣ୍‌କୁ ମି ଦାରା ନାଣ୍ତ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“ଏନ୍‌ଆପିନ୍‌ ଲୋକା ଆଗିଡ଼ି ନାଙ୍ଗିଁ ମାନାନାର୍‌, ନାନ୍ ବା ମୁସ୍‌କୁପୁର୍‌ତି ବୁବା ଆଗ୍‌ଡ଼ି ୱାରିଙ୍ଗ୍‌ ନାଦି ଇଜି ନାନ୍ ମାନାନା । ");
INSERT INTO kfcp_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ମାତର୍‌ ଏନ୍‌ ଆତ୍‌ରେ ନାଙ୍ଗିଁ ମାନାଏନ୍‌, ୱାନିଙ୍ଗ୍‌ ନାନ୍ ବା ନା ମୁସ୍‌କୁପୁର୍‌ତି ବୁବା ଆଗ୍‌ଡ଼ି ମାନାଏ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“ନାନ୍ ଦୁନିଆଦୁ ସାନ୍ତି ସିଦେଙ୍ଗ୍‍ ୱାତାମାନା ଇଜି ଅଡ଼୍‍ବିମାଟ୍‍ । ସିଲେ, ନାନ୍ ସାନ୍ତି ତାତେଙ୍ଗ୍‌ ରେଏ, ମାତର୍‌ କୁଡ଼ାମ୍‍ ଆସ୍‌ସି ୱାତାମାନା । ");
INSERT INTO kfcp_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ଇରିଙ୍ଗ୍‌ ନାନ୍ ମାରିସି ବିରଦ୍‌ତାନ୍‌ ବୁବାସି, ବୁବାସି ବିରଦ୍‌ତାନ୍‌ ମାରିସି ମାରି ଗାଡ଼୍‌ସି ବିରୁଦ୍‍ତାନ୍‍ ଆଇସି, ଆଇସି ବିରଦ୍‌ତାନ୍‌ ଗାଡ଼୍‌ସି, ମାରି ମିମ୍‍ସି ୱାଲେ କଡ଼େସିଦି ବିରୁଦ୍‌ ଗଟେକିଦେଙ୍ଗ୍‍ ୱାତାମାନା । ");
INSERT INTO kfcp_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ନିଜେଦି ଇଲ୍‍ତି ଲୋକୁ ନିଜେଦି ସାତ୍ରୁଆନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“ଏନ୍‌ ବୁବାସି ନି ଆଇସିଙ୍ଗ୍‍ ନା ମାଣ୍‌କୁ ନାଣ୍ତ ଜିବନ୍‍ନୋନାନ୍‍, ୱାନ୍‌ ନା ସିସୁ ଆଦେଙ୍ଗ୍‌ ଜଗ୍‌ ସିଲେନ୍‌, ମାରି ଏନ୍‌ କଡ଼ଦିଙ୍ଗ୍‌ ନି ଆଇଲିଦିଙ୍ଗ୍‍ ନା ମାଣ୍‌କୁ ନାଣ୍ତ ଜିବନ୍‍ନୋନାନ୍‍, ୱାନ୍‌ ନା ସିସୁ ଆଦେଙ୍ଗ୍‌ ଜଗ୍‌ ସିଲେନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ଏନ୍‌ ନା ଉଣ୍ତିଙ୍ଗ୍‌ ଦୁକ୍‍ ନି ସାନିକା ବଦା କିଜିନା ୱେନ୍‌କା ରେଏନ୍‌, ୱାନ୍‌ ନା ସିସୁ ଆଦେଙ୍ଗ୍‌ ଜଗ୍‌ ସିଲେନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ଏନ୍‌ ନିଜେଦି ଜିବନ୍‌ତିଙ୍ଗ୍‌ ରକିୟା କିଦେଙ୍ଗ୍‌ ବଦାକିନାନ୍‌, ୱାନ୍‌ ଆକା ଆରାକିନାନ୍‌, ମାତର୍‌ ଏନ୍‌ ନା ଉଣ୍ତିଙ୍ଗ୍‌ ନିଜେଦି ଜିବନ୍‌ ସିନାନ୍‍, ୱାନ୍‌ ସତେଦାନ୍‍ ଆକା ରକିୟା କିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“ଏନ୍‌ ମିଙ୍ଗିଁ ମାନାନାନ୍‍, ୱାନ୍‌ ନାଙ୍ଗିଁ ମାନାନାନ୍‍, ମାରି ନାଙ୍ଗିଁ ଏନ୍‌ ମାନାନାନ୍‍, ୱାନ୍‌ ନାନ୍‌ ପକ୍‍ତିୱାନିଙ୍ଗ୍‍ ମାନାନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ଏନ୍‌ ବାବବାଦିରିଙ୍ଗ୍ ମାପୁରୁଦି କାବୁର୍‌ ସିନିକାନ୍‍ ଇଜି ମାନାନାନ୍‍, ୱାନ୍‌ ଆୟା ବାବବାଦିରି ପୁରସ୍‌କାର୍‌ ପୟ୍‌ନାନ୍‌ । ମାରି ଏନ୍‌ ଦାର୍ମୁ ଲୋକାଙ୍ଗ୍‌ ଦାର୍ମୁଦିକାନ୍‌ ଇଜି ମାନାନାନ୍‍, ୱାନ୍‌ ଦାର୍ମୁ ଲୋକ୍‌ତି ପୁରସ୍‌କାର୍‌ ପୟ୍‌ନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ମାରି ଏନ୍‌ ଇୟା ଇସ୍ରି ଲୋକ୍ ମାଣ୍‌କୁ ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ନା ସିସୁ ଇଜି କେବଲ୍‌ ଗିନା ଏର୍‌ ଉଣ୍ତେଙ୍ଗ୍‌ ସିନାନ୍‍, ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାନ୍‌ ନା ସିସୁ, ସତେନେ ପୁରସ୍‌କାର୍‌ ପୟ୍‌ନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ଜିସୁ ୱାନି ବାରଲୋକ୍ ସିସୁରିଙ୍ଗ୍‌ ଇୟାୱିଜୁ ମାଟା ସିତି ୱେନ୍‌କା ଆୟା ବାଡି ଡ଼ିସ୍‌ସି ଲାକ୍‌ତୁରି ଗାଡ଼୍‌କାଙ୍ଗ୍‌ ସଲ୍‌ସି ପ୍ରଚାର୍‌ କିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ନାସ୍ତିୱାଲେ ଡୁବନ୍‌ ସିନି ଯୋହନ ଜଇଲ୍‍ତୁ ମାର୍ହାନ୍‍ । କ୍ରିସ୍ତ ଏମେ ୱିଜୁ ପାଣି କିଜିମାର୍ହାନ୍‍, ତାନି କାବୁର୍‌ ପୟ୍‌ଜି ୱାନ୍‌ ନିଜେଦି ସିସୁରିଙ୍ଗ୍‌ କ୍ରିସ୍ତଦି ଲାକ୍‌ତୁ ପକ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ୱାର୍‌ ସଲ୍‌ସି ଜିସୁଙ୍ଗୁଁ ୱେନ୍‌ବାତାର୍‌, “ଏମେ ଲୋକୁ ୱାନାନ୍‍ଇଜି ଯୋହନ ଇର୍ହାମାର୍ହାନ୍‌, ନିନ୍‌ ଇନିକା ଆକାନ୍‍ ନେ, ମାପ୍‌ ଆଇୱାନିଙ୍ଗ୍‍ କାପ୍‌କିଜି ତେବାନାପ୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମିର୍‌ ଡ଼େସି ସଲ୍‌ସି ଆମାକା ୱିଜୁ ୱେନ୍‌ଜିନିଦେର୍‌ ମାରି ସୁଡ଼୍‍ଜିନିଦେର୍‍, ଆୟାକାୱିଜୁ ଯୋହନତିଙ୍ଗ୍‍ ୱେର୍‌ତୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","କାଣାର୍‌ ସୁଡ଼୍‍ଦେଙ୍ଗ୍‍ ଆଟ୍‌ସିନାର୍‌, ସଟାର୍‍ ବୁଲାଜିନାର୍‌, କୁସ୍ଟରୋଗ୍‌ତି ଲୋକୁ ନେଗେନ୍‍ଆଜିନାର୍‍, ବଇରା ଲୋକ୍‌ ୱେନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆଟ୍‌ସିନାର୍‌, ସାତି ଲୋକୁ ଡ଼େସି ନିଙ୍ଗିଁଜିନାର୍‍ ମାରି କାକୁର୍ତି ଲୋକାମାନୁ ବା ନେଗି କାବୁର୍‌ ପ୍ରଚାର୍‌ କିଆଇଆଜିନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ନା ବିସୟ୍‌ତାନ୍‌ ଏମେୱାରି ଇନିକା ନାମ୍‍ଇକା ସିଲେତ୍‌, ୱାନ୍‌ ଦନ୍ୟ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ଯୋହନତି ସିସୁର୍‍ ଡ଼େସିସର୍‍ରିୱାଲେ ଜିସୁ ଲୋକାଙ୍ଗ୍‌ ଯୋହନତି ବିସୟ୍‌ତାନ୍‌ ଇର୍ହାନ୍‌, ମିର୍‌ ଯୋହନତିଙ୍ଗ୍‌ ସୁଡ଼ୁଦେଙ୍ଗ୍‍ଇଜି ଏସ୍ତିୱାଲେ ବାଲିବୁମିଦୁ ସର୍‍ରିମାର୍‍ଇଦେର୍, “ଇନିକା ସୁଡ଼୍‍ଦେଙ୍ଗ୍‍ ଆସା କିତିମାର୍ହିଦେର୍‍ ? ଇନିକା ଗାଲିଦାନ୍‍ ଦୁଙ୍ଗ୍‍ଁଜିମାନି ଉଣ୍ତ୍ରି ଦେର୍‍ ନାଡ଼ା ? ");
INSERT INTO kfcp_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ମିର୍‌ ଇନିକା ସୁଡ଼୍‍ଦେଙ୍ଗ୍‍ ସତିସର୍‍ଇ ମାର୍‍ଇଦେର୍‍ ? ପାତଲ୍‌ ଆଙ୍ଗିଁ ଆରାତିମାନି ଅରେନ୍‍ ଲୋକ୍‌ତିଙ୍ଗ୍‌ ? ସୁଡ଼୍‌ଦୁ, ଆମାକାର୍‌ ଆୟାୱାଜା ପାତଲ୍‌ ଆଙ୍ଗିଁ ଆରାତି ଲୋକୁ ରାଜାଦି ମେଡ଼୍‍ତୁ ତେବାନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ନାଙ୍ଗିଁ ଇନ୍‍ଡ୍ରୁ, ଇନିକା ସୁଡ଼୍‍ଦେଙ୍ଗ୍‍ ସର୍ହିମାର୍ହିଦେର୍‍ ? ଇନିକା ଅରେନ୍‍ ବାବବାଦିଙ୍ଗ୍‍ନୋ ? ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ମାତର୍‌ ବାବବାଦି ମାଣ୍‌କୁ ଅରେନ୍‍ ନାଣ୍ତପେରି ଲୋକ୍‌ତିଙ୍ଗ୍‌ ସୁଡ଼ୁତିମାନିଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ଇରିଙ୍ଗ୍‌ ଇୟା ଯୋହନତି ବିସୟ୍‌ତାନ୍‌ ସାସ୍ତ୍ରଦୁ ରାସାତାମାନାତ୍‌, ମାପୁରୁ ଇର୍ହାନ୍‌, ମି ଉଣ୍ତିଙ୍ଗ୍‌ ସାରି ରସ୍‍ତେଙ୍ଗ୍‍ ନାନ୍ ଆଗ୍‌ଡ଼ି ନା ଦୁତ୍‍ତିଙ୍ଗ୍‍ ପକ୍‍ନା । ");
INSERT INTO kfcp_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ପୁର୍ବେଦାନ୍‍ ନେର୍‌ ସାନ୍ଦି ଇୟା ଦୁନିଆଦୁ ଏସ ଲୋକୁ ଜନମ୍‍ଆତାମାନାର୍‍, ଆୟା ୱିଜେରି ମାଣ୍‌କୁ ଡୁବନ୍‌ ସିନି ଯୋହନ ପେରିକାନ୍‌ । ମାତର୍‌ ମୁସ୍‌କୁପୁର୍‌ତି ରାଜିଦୁ ଏନ୍‌ ୱିଜେରି ମାଣ୍‌କୁ ଇସ୍ରିକାନ୍‌, ୱାନ୍‌ ଯୋହନତି ମାଣାନ୍‌ ପେରିକାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ଡୁବନ୍‌ ସିନି ଯୋହନ ୱାନି ସୁସମାଚାର୍‍ ପ୍ରଚାର୍‌ କିନି ଦିନ୍‍ତାନ୍‍ ନେର୍‌ ସାନ୍ଦି ମୁସ୍‌କୁପୁର୍‌ତି ରାଜିଦୁ ମୁସ୍‌କୁ ନାଣ୍ତ ରେଲ୍‍ନିଅନିକା ସାଲାଜିନାତ୍‍ । ରେନିଅନିକାର୍‍ ବପୁଦାନ୍‍ ଅଦିକାର୍‌ କିଦେଙ୍ଗ୍‌ ସେସ୍ଟା କିଜିନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ଯୋହନ ୱାନିସାନ୍ଦି ମସାଦି ନିୟମ୍‌ ନି ବାବବାଦିରି ମାଟାଦାନ୍‌ ଆୟା ରାଜି ବିସୟ୍‌ତାନ୍‌ ଇନାଜିମାର୍ହାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ଜଦି ୱାରି ମାଟା ମିର୍‌ ବିସ୍‌ବାସ୍‌ କିନିଦେର୍‍, ଆରିଙ୍ଗ୍‌ ଯୋହନ ଆଜିନାନ୍‍ ଏଲିୟ୍‌, ଆମାକାନ୍‍ ଆଗ୍‌ଡ଼ି ୱାନିକାମାର୍ହାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ଏମେୱାନିଙ୍ଗ୍‌ ଗିତଣିମାନାତ୍‌, ୱାନ୍‌ ୱେନିନ୍‌ ! ");
INSERT INTO kfcp_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“ଇୟା ଆଜିକାଲ୍‍ତି ଲୋକାଙ୍ଗ୍‌ ଏମେତାନିୱାଲେ ତୁସ୍‍ନା ? ୱାର୍‌ ସାତା ନାଡ଼୍‍ମି ବାସ୍‌ସି କାର୍‍ଜିଜିମାନି କଡ଼ରି ୱାଜା । ଉନ୍‌ଡ୍ରି ଦଲତୀ କଡ଼ର୍‌ ଆଇ ଦଲ୍‍ତିଙ୍ଗ୍‍ ଇନାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ମାପ୍‌ ପେଡ଼ିଦି ବାଜା ଏସ୍‍ତାପ୍‍, ମାତର୍‌ ମିର୍‌ ଗାତ୍‍ଇତିଦେର୍‍ । ମାପ୍‌ ଦୁକ୍‍ତି ପାଟା ପାରିତାପ୍‍, ମାତର୍‌ ମିର୍‌ ଆଡ଼ାବାଇତିଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ଯୋହନ ୱାଜି ଉପାସ୍‌ କିଜିମାର୍ହାନ୍‍, ମାରି ଅଙ୍ଗୁର୍‍ରସ୍‍ ଉଣୁଏଜିମାର୍ହାନ୍‍ । ୱିଜେରେ ଇର୍ହାର୍‌, ୱାନ୍‌ ଦୁବାକାସ୍ତିକାନ୍‍ ! ");
INSERT INTO kfcp_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ଏସ୍ତିୱାଲେ ମନୁଷ୍ୟପୁତ୍ର ୱାଜି ଉଣାନ୍‌ ତିନାନ୍‍, ୱିଜେରେ ଇର୍ହାର୍‌, ଇୟା ଲୋକ୍‌ତିଙ୍ଗ୍‌ ସୁଡ଼୍‍ଦୁ ! ୱାନ୍‌ ଅରେନ୍‍ ପେଟୁ ନି ମଦୁଆ, ସିସ୍‍ଟୁ ଲୋସ୍‍ନି ଲୋକା ମାରି ପାପି ଲୋକା ସଙ୍ଗ୍‍ । ମାତର୍‌ ମାପୁରୁ ବୁଦି ନିଜେଦି ପାଣିଦାନ୍‌ ସତ୍‍ଇଜି ପାର୍‍ମାଣ୍‍ଆତାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ଏମେ ଗାଡ଼୍‌କାଙ୍ଗ୍‌ ଜିସୁ ୱାନି ନାଣ୍ତ କାବାଆନି ପାଣି କିତାମାର୍ହାନ୍, ଆୟା ରାଜିତି ଲୋକୁ ୱାରି ପାପ୍‍ତି ଉଣ୍ତିଙ୍ଗ୍‌ ମନ୍‍ତିଙ୍ଗ୍‍ ଡ଼େପ୍‍ଇକା ସୁଡ଼୍‌ଜି, ଜିସୁ ଆୟା ଗାଡ଼୍‌କାଙ୍ଗ୍‌ ବାସେକିଦେଙ୍ଗ୍‍ଆସ୍‍ତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","ଏ କୋରାଜିନ୍‌, ଏସା ନାଣ୍ତ ନିନ୍ଦାଦି ଦୁକ୍‍ ପୟ୍‌ନିଦେର୍‌ ! ବେତ୍‍ସାଇଦା, ନି ଦସ୍‍ବା ଆୟାୱାଜା ! ନିବାନ୍‍ ଏମେ କାବାଆନି ପାଣିୱିଜୁ କିଆଇଆତାମାନାତ୍‍, ଆୟାୱିଜୁ ଜଦି ସୋର ନି ସିଦନ୍‍ତୁ କିଆଇଆତାତ୍‍ମାନ୍ଦି, ଆବେଣି ଲୋକୁ ମେନ୍ଦଲ୍‌ତୁ ନିରୁ ଉସାଜି ବାସ୍‌ତେଙ୍ଗ୍‌ ଆରାଜି ମନ୍‍ତିଙ୍ଗ୍‍ ଡ଼େପ୍‍ତାର୍‍ ମାନ୍ଦି । ");
INSERT INTO kfcp_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ନାନ୍ ସତେ ଇଜିନା, ମାପୁରୁ ବିସାର୍‍କିନି ଦିନ୍‍ତୁ ମି ବାଦ୍‌ଲୁ ସୋର ନି ସିଦନ୍‍ତି ଲୋକାଙ୍ଗ୍‌ ନାଣ୍ତ ଦୟା ତର୍‍ନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ମାରି କପର୍‍ନାହୁମ୍‍ତୁ ବାସାନିକିନ୍ଦା ! ନିନ୍‌ ଇନିକା ନିଜେ ମୁସ୍‌କୁପୁର୍‌ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ବଦାକିଜିନି ? ନିନ୍‌ ନର୍କଦୁ ପକାଇଆନି । ନି ବାନୁ ଏମେ କାବାଆନି ପାଣି କିଆଇଆତାମାନାତ୍‍, ଆକା ଜଦି ସଦମ୍‍ତୁ କିଆଇଆତାତ୍‍ମାନ୍ଦି, ଆୟା ଗାଡ଼୍‌ ନେର୍‌ ସାନ୍ଦି ତେବାଦେଙ୍ଗ୍‍ ଆଟ୍‍ତାତ୍‍ମାନ୍ଦି । ");
INSERT INTO kfcp_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା “ମାପୁରୁ ବିସାର୍‍ ଦିନ୍‍ତୁ ମି ମାଣ୍‌କୁ ସଦମ୍‍ତୁମାନି ଲୋକା ଉଣ୍ତିଙ୍ଗ୍‌ ନାଣ୍ତ ଦୟା ତର୍‍ନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ଆୟା ସମୟ୍‍ତୁ ଜିସୁ ପାର୍‍ତନାକିଜି ଇର୍ହାନ୍‌, “ଏ ବୁବା, ମୁସ୍‌କୁପୁର୍‌ ମାରି ଦୁନିଆଦି ପ୍ରବୁ, ଇୟାୱିଜୁ ମାଟା ନିନ୍‌ ବୁଦିମାନି ମାରି ପଡ଼ାତି ଲୋକାମାଣ୍‌କୁ ମାର୍‍କ୍‍ସି ଇଡ୍‌ଜି ପଡ଼ାଇ ଲୋକାମାନୁ ୱେକ୍‍ତିମାନି ଆକା ନାନ୍ ନିଙ୍ଗିଁ ଦନ୍ୟବାଦ୍‌ ସିଜିନା । ");
INSERT INTO kfcp_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ହୁଁ ବୁବା, ନି ବଦାଦାନ୍ ଇୟାୱିଜୁ ଗଟାଜି ସଲ୍‍ସିନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“ନା ବୁବା ନାଙ୍ଗିଁ ୱିଜୁ ବିସୟ୍‌ ସିତାମାନ୍‍, ବୁବେଙ୍ଗ୍‌ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ମାରିସିଙ୍ଗ୍‌ ମାରି ଏନ୍‌ ନେସ୍‌ଏର୍‌, ମାରି ମାରିସିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ମାରି ଏନ୍‌ ନେସ୍‌ଏର୍‌ । ମାରିସି ଏମେୱାରି ଲାକ୍‌ତୁ ବୁବେଙ୍ଗ୍‌ ୱେଙ୍ଗିଁସ୍‍କିନାନ୍‍, କେବଲ୍‌ ଆକାର୍‍ନେ ବୁବେଙ୍ଗ୍‌ ନେସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‍ନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“ଏ ୱାନ୍ଦିତି ୱିଜେରେ ନି ବଜ୍‍ତୁ ମାନି ଲୋକୁ ୱିଜେରେ, ନା ଲାକ୍‌ତୁ ରାଦୁ, ନାନ୍ ମିଙ୍ଗିଁ ରମିସ୍‍କିନା । ");
INSERT INTO kfcp_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ନା ପୁନ୍ଦି ନିଜେଦି ମୁସ୍‌କୁ ପିଣ୍ତ୍‍ଦୁ, ମାରି ନାବାଣ୍‍କୁ ଅଜାଦୁ, ଇରିଙ୍ଗ୍‌ ନାନ୍ ନିଜେ ସାଦୁ ନି ଜିବନ୍‌ତୁ କାର୍ମୁ ସୁଣିକିନ୍ଦାଆକା । ଆବେଟ୍‌ ମିର୍‌ ରମ୍‍ନିଦେର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ନାନ୍ ମି ମୁସ୍‌କୁ ଏମେ ପୁନ୍ଦି ଲାଦେକିନା, ଆକା ପିଣ୍ଡ୍‌ଦେଙ୍ଗ୍‌ କାସ୍ଟୁସିଲେ । ମାରି ମିଙ୍ଗିଁ ଏମେ ବଜ୍‌ ସିନା, ଆକାବା ନାଣ୍ତ ଉସାସ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ତେନି ଏସ ଦିନ୍‌ ୱେନ୍‌କା ଉଣ୍ତ୍ରି ରମ୍‍ନିଦିନ୍‍ତୁ ଜିସୁ ପାସି କିଡ଼ିଇ ସିଜି ସଲ୍‍ସିମାର୍ହାନ୍‍ । ୱାନି ସିସୁର୍‌ ବାଙ୍ଗାଁଆତାର୍‍ଆକା ୱାର୍‌ ସେରେନ୍‍କୁ ତେଉସି ତିନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ପାରୁସିର୍‌ ଇକା ସୁଡ଼ୁଜି ଜିସୁଙ୍ଗୁଁ ଇର୍ହାର୍‌, “ସୁଡ଼ୁଦୁ, ରମ୍‌ନିଦିନ୍‍ତୁ ମି ସିସୁର୍‍ ଏଣ୍ତେସ୍‌ ନିୟମ୍‌ ସିଲି ପାଣି କିଜିନାର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଅର୍‍ଲେନ୍‍ ଦାଉଦ ନି ୱାନି ତଡ଼୍‍କୁ ବାଙ୍ଗାଁ ଆନିୱାଲେ ୱାନ୍‌ ଇନିକା କିତାମାର୍‌ଆନ୍‌, ଆକା ମିର୍‌ ପଡ଼ାଇଦେର୍‌ ନୋ ? ");
INSERT INTO kfcp_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ୱାନ୍‌ ମାପୁରୁଦି ଇଲ୍‌ତୁ ସଲ୍‌ସି ମାପୁରୁ ଉଦେସ୍‍ତାନ୍‍ ପୁଜାସିତିମାର୍ହି ରୁଟି ୱାନ୍‌ ନି ୱାନି ତଡ଼୍‍କୁ ତିର୍ହାର୍‍ । ନିୟମ୍‌ ଇସାବ୍‌ତାନ୍‌ ଜାଜକଦିଙ୍ଗ୍‍ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ଆୟା ରୁଟି ତିନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଇଜି ଆଇ ଏଙ୍ଗ୍‌ବା ଅଦିକାର୍‌ ସିଲେତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ମିର୍‌ ଇନିକା ପଡ଼ାଇଦେର୍‌ ନୋ ? ମସାଦି ନିୟମ୍‌ ଇସାବ୍‌ତାନ୍‌ ଜାଜକର୍‌ ରମ୍‌ନି ଦିନ୍‍ତୁ ମନ୍ଦିର୍‌ ଲୋଇ ଜାଜକତି ପାଣିକିନି ମାଣାନ୍‌ ରମ୍‌ନି ଦିନ୍‍ତି ନିୟମ୍‌ ଅମାନ୍ୟ କିଜିମାରିଙ୍ଗ୍‌ବା ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାର୍‌ ଦସି ଆଏଜିମାର୍ହାର୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ମନ୍ଦିର୍‌ ମାଣାନ୍‌ ପେରି ବିସୟ୍‌ ଇବେମାନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ସାସ୍ତ୍ର ଇନାତ୍‍, ନାନ୍ ବଦାକିନା ଦୟା, ପୁଜାସିନିକା ସିଲେ; ଇୟା ମାଟାଦି ଅର୍ତ ଜଦି ସତ୍‌ତାନ୍‌ ବୁଜାତିଦେର୍‍ମାନ୍ଦି, ଇୟା ଦସ୍‌ କିଇ ଲୋକାଙ୍ଗ୍‌ ମିର୍‌ ଦସିକିଇତିଦେର୍‍ମାନ୍ଦି । ");
INSERT INTO kfcp_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ଇରିଙ୍ଗ୍‌ ମନୁସ୍ୟପୁତ୍ର ରମ୍‌ନିଦିନ୍‍ତି ପ୍ରବୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ଜିସୁ ଆୟା ବାଡିଦାନ୍‍ ଡ଼ିସ୍‌ସି ପାର୍‍ତନାକିନି ଇଲ୍‌ତୁ ଡ଼ୁଗିତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ୱାନି ଉନ୍‌ଡ୍ରି କିୟୁ ୱାର୍‍ତିସର୍‍ରି ଅରେନ୍‍ ଲୋକୁ ଆବେ ମାର୍ହାନ୍‍ । ଜିସୁଦି ଦସ୍‌ ଆସ୍‌ତେଙ୍ଗ୍‌ ଏସ ଲୋକୁ ଆବେ କାପ୍‍କିଜି ମାର୍ହାର୍‍ । ଆୟା ଉଣ୍ତିଙ୍ଗ୍‌ ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ୱେନ୍‌ବାତାର୍‌, “ରମ୍‌ନି ଦିନ୍‍ତୁ ନେଗେନ୍‍ କିନିକା ମା ନିୟମ୍‌ ବିରୁଦ୍‌ ସିଲେନୋ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ଜିସୁ ଇର୍ହାନ୍‌, “ଜଦି ମି ଲୋଇରାନ୍‌ ଏ ୱାନି ମେଣ୍ତା ରମ୍‌ନିନାଣ୍ତିଙ୍ଗ୍‌ ଉନ୍‌ଡ୍ରି ପେରି ଗୁଟାଦୁ ଆର୍‍ନାତ୍‍, ମିର୍‌ ତାନିଙ୍ଗ୍‌ ନିକ୍‍ସି ତେଇଦେର୍‍ନୋ ? ");
INSERT INTO kfcp_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ଅରେନ୍‍ ଲୋକ୍‌ତି ଦାରା ଉନ୍‌ଡ୍ରି ମେଣ୍ତାଦି ବାଦ୍‌ଲୁ ନାଣ୍ତ । ମାରି ରମ୍‌ନି ନାଣ୍ଡିଙ୍ଗ୍ ଆଇୱାନିଙ୍ଗ୍‍ ସାକାକିନିକା ମା ନିୟମ୍‌ ଇସାବ୍‌ତାନ୍‌ ନେଗି ପାଣି ।” ");
INSERT INTO kfcp_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ଇକା ଇଜି ୱାନ୍‌ କିୟୁ ୱାର୍‍ତିମାର୍‍ରି ଲୋକ୍‌ତିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନି କିୟୁ ପେର୍‌ଆ ।” ୱାନ୍‌ ୱାନି କିୟୁ ପେର୍‍ତି ଦାପ୍ରେ ଆୟା କିୟୁ ଆଇ କିୟୁ ୱାଜା ନେଗେନ୍‍ ଆତାସର୍ହାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ଇୟା ୱେନ୍‌କା ପାରୁସିର୍‌ ଆୟା ବାଡିଦାନ୍‍ ସହସି ସଲ୍‌ସି ଜିସୁଙ୍ଗୁଁ ଡାକ୍‍ତେଙ୍ଗ୍‍ ଇଜି ଉପାୟ୍‍କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ୱାନି ବିରଦ୍‌ତାନ୍‌ ଆତିମାନି ଉପାୟ୍‍ତି ମାଟା ୱେନ୍‌ଜି ଜିସୁ ଆୟା ରାଜି ଡ଼ିସ୍‌ସି ଆଇତରିନ୍‍ ସର୍ହାନ୍‍ । ନାଣ୍ତ ଲୋକୁ ୱାନି ୱେନ୍‌କା ୱେନ୍‌କା ସର୍ହାର୍‍ । ମାରି ୱାନ୍‌ ୱିଜୁ ରଗ୍‌ ଲୋକାଙ୍ଗ୍‌ ନେଗେନ୍‌ କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ମାତର୍‌ ୱାନି ବିସୟ୍‌ତାନ୍‌ ଆଇୱାରିଙ୍ଗ୍‌ ଇନିକା ଇନ୍‌ଇ ଉଣ୍ତିଙ୍ଗ୍‌ ଆଦେସ୍‌ ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ଇୟାବାଣାନ୍‍ ବାବବାଦି ଜିସାୟଦି ମାଣାନ୍‌ ମାପୁରୁ ଏମେ ମାଟା ଇର୍ହାମାର୍ହାନ୍‌, ଆକା ସତ୍‌ ଆଦେଙ୍ଗ୍‌ ଇକା ଇର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“ଇକାନ୍‌ ନା ଦାସ୍‌, ଏମେୱାନିଙ୍ଗ୍‌ ନାନ୍ ବାସେକିତାମାନା, ୱାନିଙ୍ଗ୍‌ ନାନ୍ ଲାଡ୍‍କିନା, ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ୱେଡ଼ିକା । ନା ଆତ୍ମା ୱାନି ମୁସ୍‌କୁ ରେତାନାତ୍‍; ୱିଜୁ ଅଣଜିହୁଦି ଲୋକାମାନୁ ୱାନ୍‌ ନା ବିସାର୍‌କିନି ବିସୟ୍‌ ୱେର୍‌ନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ୱାନ୍‌ ଜାଟିଜଗଡ଼ା କିଏନ୍‌ କି ଆଉଲି ଆଏନ୍‍, ରାସ୍ତା ମଜାୟ୍‍ ନିଲ୍‍ଜି ନାଣ୍ତ ଆଉଲି ଆଜି ମାଟା ଇନ୍‌ଏନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ୱାନ୍‌ ୱାଙ୍ଗିଁତି ନାଡ଼ାଦିଙ୍ଗ୍‍ ରୁକ୍‍ଏନ୍‍, ମାରି କାସ୍‍ନିସାଲିତାଦିଙ୍ଗ୍ ନାପ୍‍ଏନ୍‍ । ୱାନ୍‌ ସାକିସିଲିୱାରିଙ୍ଗ୍‍ ନି ସିଲିସାତିକାର୍‍ ନ୍ୟାୟ୍‌ ବିସାର୍‌ ପୟ୍‍ନିସାନ୍ଦି ୱାନ୍‌ ୱାନି କିନିମାଣାନ୍‍ ସୁପ୍‍ ଆଏନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ୱାନି ମୁସ୍‌କୁ ଦେସ୍‌ତି ୱିଜୁ ଅଣଜିହୁଦି ଲୋକୁ ଆସା ଇଡ୍‍ନାର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ତାନି ୱେନ୍‌କା ଅର୍‍ଲେନ୍‍ ଲୋକୁ ଅରେନ୍‍ କାଣା ନି ଗୁଲେଙ୍ଗ୍‍ ତାସିୱାତାର୍‍ । ୱାନ୍‌ ଦୁବା କାସ୍ତାମାର୍‌ର୍ହାତ୍‌ ଆକା ମାଟା ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆଟ୍‍ଏଜି ମାର୍‌ର୍ହାନ୍‌ । ଜିସୁ ୱାନିଙ୍ଗ୍‌ ନେଗେନ୍‌କିତାନ୍‌ । ୱାନ୍‌ ସୁଡ଼ୁଦେଙ୍ଗ୍‍ଆଟ୍‍ତାନ୍‍ । ମାରି ମାଟା ଇନ୍‍ଡ୍ରେଙ୍ଗ୍‍ ଆଟ୍‍ତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ଜିସୁଦି ଇୟା ପାଣିଦୁ ୱିଜୁ ଲୋକୁ କାବାଆଜି ଇର୍ହାର୍‌, “ଇକାନ୍‌ ଇନିକା ଆୟା ଦାଉଦ ମାରିନ୍‌ ଆଏନ୍‍ ନୋ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ପାରୁସିର୍‌ ଇକା ୱେନ୍‌ଜି ଇର୍ହାର୍‌, “ୱାନ୍‌ ଦୁବେଙ୍ଗାଁ ପେରିକାନ୍‌ ବାଲ୍‍ଜିବୁଲ୍‍ ସାକ୍ତି ପୟ୍‌ଜି ଦୁବେଙ୍ଗ୍‍ ଡ଼ିସିସ୍‍କିଜିନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ୱାର୍‌ ଇନିକା ଏତ୍‌ କିଜିନାର୍‍ ଜିସୁ ନେସ୍‍ତେଙ୍ଗ୍‍ଆଟ୍‍ସି ଇର୍ହାନ୍‌, ଉନ୍‌ଡ୍ରି ଦେସ୍‌ତି ଲୋକୁ ୱେର୍‌ଏ ୱେର୍‌ଏ ଦଲ୍‌ ବାଗ୍‍ଆଜି ନିଜେ ନିଜେଦି ଲୋଇ ଜୁଦ୍‍ କିତିଙ୍ଗ୍‌, “ଆୟା ଦେସ୍‌ ନାଣ୍ତ୍‍ ଦିନ୍‌ ତେବାଏତ୍‍ । ଏମେ ଗାଡ଼୍‌ ବା ଇଲୁ ଲୋଇ ଆଇ ଆଇ ଦଲ୍‍ଆଜି ଜାଟିଜଗଡ଼ା କିତିଙ୍ଗ୍‌, ୱାର୍‌ ବେଗି ନାସ୍ଟୁଆନାସନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ଆରିଙ୍ଗ୍‌, ସୟତାନ୍ ରାଜିଦୁ ଜଦି ଉନ୍‌ଡ୍ରି ଦଲ୍‌ ଆଇ ଦଲ୍‌ ବିରଦ୍‌ତାନ୍‌ ଜୁଦ୍‌କିନାତ୍‍, ନେସ୍‍ତେଙ୍ଗ୍‍ ଆନାତ୍‍ଜେ ଆକା କଣ୍ତ୍‌ କଣ୍ତ୍‍ଆଜି ଦଂସ ଆନାସନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ମିର୍‌ ଇଜିନିଦେର୍‌, ନାନ୍ ଜଦି ବାଲ୍‍ଜିବୁଲ୍‍ତି ସାକ୍ତିଦାନ୍ ତାଗ୍‌ଇ ଦୁବେଆଙ୍ଗ୍‍ଁ ପେର୍‍ଜିନା । ଆରିଙ୍ଗ୍‌ ୱାନିକାଙ୍ଗ୍‌ ପେର୍‍ଦେଙ୍ଗ୍‍ ଇଜି ମି ସିସୁରିଙ୍ଗ୍‌ ଏନ୍‌ ସାକ୍ତି ସିଜିନାନ୍‌ ? ମି ସିସୁରି ଇୟା ପାଣିଦାନ୍‌ ମି ଦସ୍‍କିନିକା ମିସ୍‌ ଇଜି ପାର୍‍ମାଣ୍‍ଆଜିନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ଦୁବେଙ୍ଗ୍‍ ଡ଼ିସିସ୍‍କିନି ସାକ୍ତି ନାନ୍ ବାଆଲ୍‍ଜିବୁଲ୍‍ତି ମାଣାନ୍‌ ପୟ୍‍ଏ । ମାପୁରୁଦି ଆତ୍ମାଦାନ୍‌ ଆକା ନାନ୍ ପୟ୍‌ତାମାନା । ଇୟାମାଣ୍‍କୁ ମାରି ଉନ୍‌ଡ୍ରି ବିସୟ୍‌ ପାର୍‍ମାଣ୍‍ଆଜିନାତ୍‍ ମାପୁରୁଦି ରାଜି ମି ଲାକ୍‌ତୁ ୱାତାତ୍‌ନି । ");
INSERT INTO kfcp_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“ଅରେନ୍‍ ବପୁମାନି ଲୋକ୍‌ତିଙ୍ଗ୍‌ ଆଗ୍‌ଡ଼ି ତର୍‍ଏତିଙ୍ଗ୍‍, ଏନ୍‌ ୱାନି ଇଲୁତୁ ଡ଼ୁଗୁଜି ୱାନି ଦନ୍‌ ରେଲ୍‍ଜ ଅତେଙ୍ଗ୍‍ ଆଟ୍‌ଏନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“ଏନ୍‌ ନା ତରିନ୍‌ ସିଲେନ୍‌, ୱାନ୍‌ ସତ୍‍ନେ ନା ବିରୁଦ୍‍ତାନ୍‍ ମାନାନାର୍ । ଏନ୍‌ ନା ୱାଲେ ମିସାଜି ଉଣ୍ତାକିଏଜିନାନ୍‍, ୱାନ୍‌ ଇନ୍‍ଙ୍ଗାଁ ଆନିଙ୍ଗାଁ କିନା ପୋକ୍‌ନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ଲୋକୁ ଏମେ ପାପ୍‌ କିପିନ୍‌ ବା ନିନ୍ଧା ମାଟା ଇନିନ୍‍, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ କେମାସିଆଇ ଆଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାତ୍‍ । ମାତର୍‌ ଜଦି ଏନ୍‌ ପବିତ୍ରଆତ୍ମାଦି ବିରଦ୍‌ତାନ୍‌ ନିନ୍ଦା ମାଟା ଇନାନ୍‌, ୱାନି କେମାଆଏତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ଏମେକାନ୍‍ ମନୁସ୍ୟପୁତ୍ରଦି ବିରଦ୍‌ତାନ୍‌ ଇନିକା ଇରିଙ୍ଗ୍‌, ୱାନ୍‌ କେମା ପୟ୍‌ନାନ୍‌ । ମାତର୍‌ ଏନ୍‌ ପବିତ୍ରଆତ୍ମାଦି ବିରଦ୍‌ତାନ୍‌ ନିନ୍ଧା ମାଟା ଇନାନ୍‌, ୱାନ୍‌ ଇଲେଇ ମାରି ୱାନିଦିନ୍‍ତୁ ଏସାଙ୍ଗ୍‍ବା କେମାପୟ୍‍ଏନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“ନେଗି ପଲ୍‌ ଆସ୍‌ତେଙ୍ଗ୍‌ ଇଜି ମାରାନ୍‌ ମଟା ଆନିଦରକାର୍‍ । ତାଗ୍‌ଇ ମାରାତୁ ତାଗ୍‌ଇ ପଲ୍‌ ଆସ୍‌ନାତ୍‌ । ମାରାନ୍‌ ଏଣ୍ତେସ୍‌ନାନିକା, ପଲ୍‍ତାନ୍‍ ନେସ୍‍ତେଙ୍ଗ୍‍ଆନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ମିର୍‌ ସାରାସ୍‍ତି ୱାଜା ତାଗ୍‌ଇ ଲୋକୁ, ମିର୍‌ ନେଗି ମାଟା ଏଣ୍ତେସ୍‌ ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆଟ୍‌ନିଦେର୍‌ ? ଅରେନ୍‍ୱାନି ମନ୍‍ ଲୋଇ ଆମାକା ଅଡ଼୍‍ବିଜିମାନାନ୍, ଆକା ୱେୟୁଦାନ୍‌ ସପ୍‍ନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ଅରେନ୍‍ ନେଗି ଲୋକୁ ନେଗି ସାମାନ୍‍ତୁ ବର୍ତିଆତିମାନି ୱାନି ଜିବନ୍‌ତାନ୍‌ ନେଗି ମାଟା ସପ୍‍ସି ତାନାନ୍‍ । ଅରେନ୍‍ ତାଗ୍‌ଇ ଗୁଣୁତି ଲୋକୁ ତାଗ୍‌ଇ ସାମାନ୍‍ତୁ ବର୍ତିଆତିମାନି ୱାନି ଜିବନ୍‌ତାନ୍‌ ତାଗ୍‌ଇ ମାଟା ସପ୍‍ସି ତାନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“ମିର୍‌ ଇର୍ହିମାନି ୱିଜୁ ଉପ୍‍କା ମାଟେଙ୍ଗାଁ ଉଣ୍ତିଙ୍ଗ୍‌ ବିସାର୍‌ ଦିନ୍‍ତୁ ମିଙ୍ଗିଁ ଇସାବ୍‌ ସିଦେଙ୍ଗ୍‍ଆନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ମି ମାଟାଦାନ୍‌ ମିର୍‌ ବିସାର୍‍ଆଜି ନିର୍ଦସ୍‍ ନୋ ଦସି ଇଜି ଆସାଇଆନିଦେର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ଅର୍‍ଲେନ୍‍ ଏସ ପାରୁସିର୍‌ ନି ଦାର୍ମୁ ଗୁରୁର୍‍ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାର୍‌, “ଗୁରୁ, ନି ଉଣ୍ତ୍ରି କାବାଆନି ପାଣି ସୁଡ଼୍‍ଦେଙ୍ଗ୍‍ ବଦା କିଜିନାପ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଇୟା ଜଗ୍‍ତି ଲୋକୁ ଏସା ଦୁସ୍ଟ ନି ମାପୁରୁଙ୍ଗ୍‌ଁ ମାନାଇକାର୍‍ ।” ମିର୍‌ ନାଙ୍ଗିଁ ଉଣ୍ତ୍ରି କାବାଆନି ପାଣି ତର୍‌ତେଙ୍ଗ୍‍ଁ ଇଜିନିଦେର୍‌ ? କେବଲ୍‌ ବାବବାଦି ଜୁନସ୍‍ତି ଜିବନ୍‌ତୁ ଗଟେଆତିମାନି କାବାଆନି ପାଣି ନେ ମିଙ୍ଗିଁ ତର୍‌ସି ସିଆଇଆନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ଜୁନସ୍‍ ଏଣ୍ତେସ୍‌ ମିନି ପଟାଦୁ ମୁଣ୍ତ୍ରି ଦିନ୍ ମୁଣ୍ତ୍ରି ନାଡ଼ା ତେବାତାମାର୍ହାନ୍‍, ଆୟାୱାଜା ମନୁସ୍ୟପୁତ୍ର ବୁମି ଲୋଇ ମୁଣ୍ତ୍ରି ଦିନ୍ ମୁଣ୍ତ୍ରି ନାଡ଼ା ତେବାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ଆମା ନାଣ୍ତିଙ୍ଗ୍‌ ମାପୁରୁ ବିସାର୍‌କିନାନ୍‌ ନିନିବିତି ଲୋକୁ ମି ବିରଦ୍‌ତାନ୍‌ ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଇଜି ନିନାର୍‍, ଇରିଙ୍ଗ୍‌ ଜୁନସ୍‍ତି ପ୍ରଚାର୍‌ ୱେନ୍‌ଜି ୱାର୍‌ ପାପ୍‌ ସାରିଦାନ୍‍ ଡ଼େସିୱାତାର୍‍ । ମାରି ସୁଡ଼୍‍ଦୁ, ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ଜୁନସ୍‍ତି ମାଣ୍‌କୁ ପେରିକାନ୍‌ ଅରେନ୍‍ ଇବେନୁ ମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ମାପୁରୁଦି ବିସାର୍‌ ଦିନ୍‍ତୁ ସିବାଦି ରାଣି ମି ଦସ୍‌ ତର୍‌ତେଙ୍ଗ୍‍ଁ ଇଜି ନିନାତ୍‍, ଇରିଙ୍ଗ୍‌ ସଲମନ୍‍ତି ବୁଦିଦି ମାଟା ୱେନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଇଜି ଦୁନିଆଦି ଆକ ଦେସ୍‍ତାନ୍‍ ୱାଦ୍‌ ୱାତା ମାର୍ହାତ୍‌; ମାତର୍‌ ନାନ୍ ସତେନେ ଇଜିନା, ସଲମନତି ମାଣ୍‌କୁ ଇବେ ପେରିକାନ୍‌ ଅରେନ୍‍ ଇବେ ମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“ଉଣ୍ତ୍ରି ତାଗ୍‍ଇଦୁବା ଅରେନ୍‍ ଲୋକୁ ମାଣାନ୍‌ ସତିସର୍‌ଇ ୱେନ୍‌କା ୱାର୍‌ତି ବାଡି ସୁଡ଼୍‌ଜି ମାରି ଉନ୍‌ଡ୍ରି ରମ୍‌ନି ବାଡି ପୟ୍‌ନାତ୍‌ । ଜଦି ଆୟା ନାନି ବାଡି ତାନେଙ୍ଗ୍‌ ପୁଟ୍‌ଏତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ନାସ୍ତିୱାଲେ ୱାଦ୍‌ ଇନାତ୍‍, ନାନ୍ ଏମେ ଇନ୍‍ଡ୍ରଣାନ୍‍ ସତା ୱାତାମାର୍‍ଆ, ନା ଆୟା ଇନ୍‌ଡ୍ର ମାରିଡ଼େସି ସନା, ୱାଦ୍‌ ଡ଼େସି ସଲ୍‌ସି ସୁଣାତ୍‍, ଆୟା ଇଲୁ ମାରି ସିପାଇଆଜି ମେଲା ତେବାତାମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ନାସ୍ତିୱାଲେ ୱାଦ୍‌ ସଲ୍‌ସି ତାନେମାଣାନ୍‍ ନାଣ୍ତ ତାଗ୍‌ଇ ମାରି ସାତ୍‍ଗୋଟା ଆତ୍‍ମେଙ୍ଗ୍‍ ଅର୍‌ସେ ଆସ୍‍ନା ୱାନାତ୍‌ । ମାରି ୱାକ୍‍ ୱାଜି ଆୟା ଇଲୁ ଲୋଇ ସଲ୍‌ସି ବାସାନେ । ନାସ୍ତିୱାଲେ ଲୋକ୍‌ତି ଅବସ୍ତା ଆଗ୍‍ଡ଼ିରି ବାଦ୍‌ଲୁ ନାଣ୍ତ ତାଗ୍‌ଇକା ଆନାତ୍‌ । ଇଲେଇ ଜିବନ୍‌ମାନି ତାଗ୍‌ଇ ଲୋକା ଉଣ୍ତିଙ୍ଗ୍‌ ଆୟାୱାଜା ଗଟାନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ଜିସୁ ଲୋକା ୱାଲେ ୱାର୍‍ଗିଜିସାନିୱାଲେ ୱାନି ଆଇସି ନି ତଡ଼ାନ୍‌କୁ ଆୟା ବାଡିଦୁ ୱାଜି ୱାନିଙ୍ଗ୍‌ ଇନିକା ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଇଜି ଆତ୍‌ରେ କାପ୍‌କିଜି ୱାନିଙ୍ଗ୍‌ କୁକିସ୍‍କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ଅରେନ୍‍ ଲୋକୁ ୱାଜି ଜିସୁଙ୍ଗୁଁ ଇର୍ହାନ୍‌, “ସୁଡ଼ୁଆ, ମି ୟାୟା ନି ତଡ଼ାନ୍‌କୁ ନି ଉଣ୍ତିଙ୍ଗ୍‌ ଆତ୍‌ରେ କାପ୍‍କିଜିନାର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ଜିସୁ ଇର୍ହାନ୍‌, “ଏଦ୍‌ ନା ୟାୟା ? ମାରି ଏର୍‌ ନା ତଡ଼ାନ୍‌କୁ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ସିସୁରି ତରିନ୍‌ କିୟୁ ଜୁଟ୍‍ସି ଇର୍ହାନ୍‌, “ସୁଡ଼୍‍ଦୁ, ଇୟାକାର୍‌ ଆଜିନାର୍‌ ନା ୟାୟା ନି ତଡ଼ାନ୍‌କୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ଏନ୍‌ ନା ମୁସ୍‌କୁପୁର୍‌ତି ବୁବାଦି ବଦାଦିଙ୍ଗ୍‍ ମାନାନାନ୍‍, ୱାନ୍‌ ନା ତଡ଼ାନ୍‌, ନା ତାଙ୍ଗିଁ ମାରି ନା ୟାୟା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ଆୟାନାଣ୍ତିଙ୍ଗ୍‌ ଜିସୁ ଇଲ୍‌ତାନ୍‌ ସହସି ଗାଡା ପାଡ଼ି ସର୍ହାନ୍‍ । ଆବେ ୱାନ୍‌ ସିକିୟା ସିଦେଙ୍ଗ୍‍ ବାସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ୱାନି ସାରିବେଡ଼୍‍ତି ନାଣ୍ତ ଲୋକୁ ଉଣ୍ତାତା ମାର୍ହାର୍‌ ଜେ ୱାନ୍‌ ଉନ୍‌ଡ୍ରି ଡଙ୍ଗାଁଦୁ ସଲ୍‌ସି ବାସ୍‌ତାନ୍‌ । ଲୋକୁ ୱିଜେରେ ସାମ୍‌ଦୁର୍‌ ପାଡ଼ି ତେବାତାର୍‍ ମାରି ୱାନି ମାଟା ୱେର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ୱାନ୍‌ କାତାଦାନ୍‍ ୱାରିଙ୍ଗ୍‌ ନାଣ୍ତ ମାଟେଙ୍ଗ୍‌ ସିକିୟା ସିତାନ୍‌ । ୱାନ୍‌ ଇର୍ହାନ୍‌, “ଅର୍‍ଲେନ୍‍ ଅରେନ୍‍ ଲୋକୁ ୱିତୁ ୱିତ୍‌ତେଙ୍ଗ୍‌ ସତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ୱାନ୍‌ କିଡ଼ିଇଦୁ ୱିତୁ ୱିତ୍‍ନିୱାଲେ ଏସ ୱିତୁ ସାରି ପାଡ଼୍‌କାଦୁ ଆର୍‌ତେ ଆକା ପଟିଙ୍ଗ୍‌ ୱାଜି ଆୟାୱିଜୁ ୱିତୁ ତିର୍‍ଏ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ମାରି ଏସ ୱିତୁ ଉଣା ସିକାଲାମାନି ପିଡ଼ିପି ବୁମିଦୁ ଆର୍‌ତାତ୍‌ । ମାରି ନାଣ୍ତ ସିକାଲା ସିଲେତାତ୍‌ ଆକା ୱିତୁ ଦାପ୍ରେ ନେରିତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ମାତର୍‌ ତାନି ୱେଲା ଆଡ୍‍ଗି ସଲ୍‍ଏତ୍‍ ମାର୍ହାତ୍‍ଆକା ୱେଡ଼ା ତେର୍‍ୱେଲ୍‍ତାନ୍‍ ୱେତାତ୍‍ ମାରି ସାତା ସର୍ହାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ଏସ ୱିତୁ ସାମ୍‍କା ଦୁପା ଲୋଇ ଆର୍‌ତାତ୍‌ । ଇୟା ସାମ୍‌ ମାରାକ୍‍ ୱିଜୁ ପିର୍‌ଜି ପାଡ଼ାୱିଜୁଦିଙ୍ଗ୍‍ ତିଗିତେ ପକ୍‍ତେ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ମାତର୍‌ ମାରି ଏସ ୱିତୁ ନେଗି ବୁମିଦୁ ଆର୍‍ଜି ମାରାକ୍‍ଆଜି ପଲ୍‌ ଆସ୍‌ତାତ୍‌ । ଏସ ସହେ ଗୁଣୁ, ଏସ ସାଟେ ଗୁଣୁ, ମାରି ଏସ ତିରିସ୍‌ ଗୁଣୁ ପଲ୍‌ ଆସ୍‌ତାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ଜିସୁ କାତା ୱିସ୍‍ସି ଇର୍ହାନ୍‌, “ଆମାୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଗିତଣିଙ୍ଗ୍‍ମାନେ, ୱାନ୍‌ ୱେନିନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ୱେନ୍‌କା ସିସୁର୍‍ ଜିସୁଦି ଲାକ୍‌ତୁ ୱାଜି ୱେନ୍‌ବାତାର୍‌, “ଲୋକାଙ୍ଗ୍‌ ସିକିୟା ସିନିୱାଲେ ନିନ୍‌ ଏନ୍ଦା କାତାଦାନ୍‍ ୱେର୍‌ସିନି ?” ");
INSERT INTO kfcp_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ଜିସୁ ଇର୍ହାନ୍‌, ମୁସ୍‌କୁପୁର୍‌ତି ମାର୍‍ଗିତିମାନି ବିସୟ୍‌ ନେସ୍‌ତେଙ୍ଗ୍‌ ଇଜି ମିଙ୍ଗିଁ ବୁଦି ସିଆଇ ଆତାମାନାତ୍‌, ମାତର୍‌ ୱାରିଙ୍ଗ୍‌ ସିଆଇ ଆଏତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ଆମାୱାନିଙ୍ଗ୍‌ ମାନାତ୍‌, ୱାନିଙ୍ଗ୍‌ ନାଣ୍ତ ସିଆଇ ଆନାତ୍‌ ମାରି ଆବେଟ୍‌ ୱାନ୍‌ ନାଣ୍ତ ଲାବ୍‍ କିନାନ୍‌ । ମାତର୍‌ ଆମାୱାନିଙ୍ଗ୍‌ ସିଲେତ୍‌, ୱାନିଦି ଆମାକା ମାନାତ୍‌, ଆକାବା କୁତ୍‍ସି ଅଆୟ୍‌ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ୱାରିଙ୍ଗ୍‌ ନାନ୍ କାତାଦାନ୍‍ ସିକିୟା ସିଜିନା, ଇରିଙ୍ଗ୍‌ ୱାର୍‌ ସୁଡ଼୍‍ବୁ ସୁଡ଼୍‍ବୁ ସୁଡ଼୍‍ଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏର୍‍ ମାରି ୱେନ୍‌ବୁ ୱେନ୍‌ବୁ ବୁଜାଏର୍ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ବାବବାଦି ଜିସାୟ୍‍ଦି ବବିସତ୍‍ ମାଟା ୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ସତ୍‌ ଆଜିନାତ୍‍ । ଇୟା ଲୋକୁ ୱେନ୍‌ଜି ୱେନ୍‌ଜି ଇନିକା ବୁଜାଏର୍‍ । ସୁଡ଼୍‌ଜି ସୁଡ଼୍‌ଜି ଇନିକା ସୁଡ଼୍‍ଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ଇରିଙ୍ଗ୍‌ ୱାରି ମୋନ୍‌ ପିଲା ବୁଦି, ୱାର୍‌ ଗିତଣିଙ୍ଗ୍‍ଁ କେର୍‍ପାତାମାନାର୍‍ ମାରି କାଣୁକୁ ମୁକ୍‍ତାମାନାର୍‍ । ଆକା ଆଏତିମାରିଙ୍ଗ୍‍ ୱାର୍‌ କାଣ୍‍କାଣୁକୁ ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ଆଟ୍‍ତାର୍‍ମାନ୍ଦି ମାରି ୱାର୍‌ ଗିତଣିଦାନ୍‍ ୱେନ୍‍ଡ୍ରେଙ୍ଗ୍‍ ଆଟ୍‍ତାର୍‍ମାନ୍ଦି ମାରି ବୁଜାଜିୱାଜି ନା ଲାକ୍‌ତୁ ଡ଼େସିୱାତାର୍‍ମାନ୍ଦି ମାରି ୱାରିଙ୍ଗ୍‌ ନାନ୍ ନେଗେନ୍‍କିତାମାନ୍ଦି । ");
INSERT INTO kfcp_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“ମିର୍‌ ଏସା ବାଗ୍ୟଦି ଲୋକୁ ! ମିର୍‌ ସୁଡ଼୍‍ଦେଙ୍ଗ୍‍ ଆଟ୍‍ସିନିଦେର୍‍ ମାରି ୱେନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆଟ୍‍ସିନିଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ଇୟା ମାଟା ନାନ୍‌ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ଏସ ବାବବାଦିର୍ ନି ଏସ ମାପୁରୁଦି ଲୋକୁ, ମିର୍‌ ଆମାକା ସୁଡ଼୍‍ଜିନିଦେର୍‍; ଆକା ସୁଡ଼୍‍ଦେଙ୍ଗ୍‍ ଇଜି ମାରି ୱେନ୍‌ଜିନିଦେର୍‌; ଆୟାୱିଜୁ ୱାର୍‌ ୱେନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ବଦାକିତାର୍‌, ମାତର୍‌ ୱେନ୍‍ଏତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“ଆରିଙ୍ଗ୍‌ ୱେନ୍‌ଡ୍ରୁ, ୱିତୁ ୱିତ୍‍ନିକାନ୍‍ କାତାଦି ଅର୍ତ ଇଜିନାନ୍‌ । ବୁଜାଦେଙ୍ଗ୍‌ ତେରେପେତେ ଆଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ଏର୍‌ ମୁସ୍‌କୁପୁର୍‌ତି ନେଗି କାବୁର୍‌ ୱେନାର୍‌, ମାତର୍‌ ବୁଜାଏର୍‍ । ୱାନ୍‌ ୱିତାତିମାନି ସାରି ଲାକ୍‌ତୁରି ବୁମିଦି ୱାଜା । ସୟତାନ୍‍ ୱାନି ଜିବନ୍‌ତୁ ୱିତାତିମାନି ଆୟା ବାକ୍ୟ ଡ଼ିବିସ୍‍କିନାଅନାତ୍‍ । ସାରି ଲାକ୍‌ତୁ ଆର୍‍ତିମାନି ୱିତୁଦି ଅର୍ତ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ଏମେକାର୍‌ ବାକ୍ୟ ୱେର୍‍ଇଦାପ୍ରେ ୱେଡ଼ିକାଦାନ୍‌ ଆସ୍‍ନାନ୍‍, ୱାର୍‌ ପିଡ଼ିପି ବୁମିଦୁ ଆର୍‍ତିମାନି ୱିତୁଦି ସାମାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ୱାରି ମନ୍‍ତି ଲୋଇ ଇକା ସଲ୍‍ଏତ୍‍ ଆକା ୱାର୍‌ ତାନିଙ୍ଗ୍‌ ନାଣ୍ତ ସମୟ୍ ଆସ୍‌ସି ଇଡ୍‌ଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏର୍‍ । ଇୟା ମାଟା ଉଣ୍ତିଙ୍ଗ୍‌ ଏସ୍ତିୱାଲେ କାସ୍ଟୁ ନି କାସ୍ଟୁ ୱାନାତ୍‌, ୱାର୍‌ ଦାପ୍ରେ ତାନିଙ୍ଗ୍‌ ଡ଼ିସ୍‍ନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ଏନ୍‌ ବାକ୍ୟ ୱେନାନ୍‌, ମାରି, ଦୁନିଆଦି ସିନ୍ତା ମାରି ଦନ୍‌ତି ଆସା ୱାନିଙ୍ଗ୍‌ ତିଗ୍‍ନା ପକ୍‍ନାତ୍‍, ମାରି ୱାର୍‌ ପସଲ୍‍ ଆସ୍‍ଏର୍‍, ଆୟା ଲୋକ୍‌ ସାମ୍‌କା ଦୁପାଦୁ ୱିତାତିମାନି ବୁମିଦି ୱାଜା । ");
INSERT INTO kfcp_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ମାତର୍‌ ଏନ୍‌ ବାକ୍ୟ ୱେନ୍‌ଜି ବୁଜାନାନ୍‍, ଆୟାକାର୍‍ ୱିତାତିମାନି ନେଗି ବୁମିଦି ୱାଜା । ୱାର୍‌ ନାଣ୍ତ ପସଲ୍‍ ଆସ୍‌ନାର୍‌, ଏନ୍‌ ସହେ ଗୁଣୁ, ଏନ୍‌ ସାଟେ ଗୁଣୁ ଏନ୍‌ ତିରିସ୍‌ ଗୁଣୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ଜିସୁ ମାରିଉଣ୍ତ୍ରି କାତା ଇଜି ଇର୍ହାନ୍‌ । ମୁସ୍‌କୁପୁର୍‌ ଇୟାୱାଜା ଅରେନ୍‍ ଲୋକୁ ୱାନି କିଡ଼ିଇଦୁ ନେଗି ଗଦ୍‍ମୁ ୱିତୁ ୱିତ୍‍ତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ଅର୍‍ଲେନ୍‍ ନାଡ଼ା ୱାର୍‌ ୱିଜେରେ ଡରିତିମାର୍‍ଇୱାଲେ ଅରେନ୍‍ ସାତ୍ରୁ ୱାଜି ଆୟା ଗଦ୍‍ମୁ ଲୋଇ ଏସ ଗଲୁତକା ଲାଟା ୱିତୁ ୱିତ୍‍ତାସର୍ହାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ଏସ୍ତିୱାଲେ ମାରାକ୍‍ ୱିଜୁ ପିର୍‌ଜି ସେରେନ୍‍ ସତାତ୍‌, ନାଡ଼୍‍ମି ନାଡ଼୍‍ମି ଗଲୁତକା ଲାଟା ତରିତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ଆୟା ଲୋକ୍‌ତି ସାକର୍‌କୁ ୱାଜି ଇର୍ହାର୍‌, ଆଜ୍ଞା, ନିନ୍‍ତୋ କିଡ଼ିଇଦୁ ନେଗି ୱିତୁ ୱିତ୍‍ତିମାର୍‍ହି, ଗଲୁତକାଲାଟେଙ୍ଗ୍‌ ଏମେଣ୍‌କୁ ୱାତେ ? ");
INSERT INTO kfcp_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ଅରେନ୍‍ ସାତ୍ରୁ ଇକା କିତାମାନାନ୍‌ । ମାରି, ସାକର୍‌କୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, ଆରିଙ୍ଗ୍‌ ମାପ୍‌ ସଲ୍‌ସି ଆକେଙ୍ଗ୍‍ ରେଲ୍‌ଜି ଉଣ୍ତ୍ରେମାନୁ କିନାପ୍‍, ଇକା ଇନିକା ନିନ୍‌ ବଦାକିନି ? ");
INSERT INTO kfcp_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ମାତର୍‌ ୱାନ୍‌ ଇର୍ହାନ୍‌, “ସିଲେ, ଏସ୍ତିୱାଲେ ମିର୍‌ ଗଲୁତକା ଲାଟା ଉଣ୍ତା କିବୁ କିବୁ ଆୟାୱିଜୁଦି ୱାଲେ ଗଦ୍‍ମୁ ରେନି ପକ୍‍ନିଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ପାସି କୟ୍‍ଇ ସାନ୍ଦି ରୁଣ୍ତିୱାନିକାଙ୍ଗ୍‍ଁ ଅର୍‌ସେ ପିର୍‌ଦେଙ୍ଗ୍‌ ଡ଼ିସ୍‌ସୋ ସିଦୁ, ମାରି ପାସି କୟ୍‍ନିୱାଲେ ନାନ୍ କୟ୍‌ନି ୱାରିଙ୍ଗ୍‌ ଇନା, ଆଡ଼େକ୍‍ତେଙ୍ଗ୍‍ ଇଜି ଆଗ୍‌ଡ଼ି ଗଲୁତକା ଲାଟା ଉନ୍‌ଡ୍ରେମାନୁ କିଜି କାଟେଙ୍ଗ୍‍ ତର୍‌ଆ, ମାତର୍‌ ଗଦ୍‍ମୁ ନା କଲ୍‍କିଦୁ ଉଣ୍ତା କିଜିଇଡିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ମାରିଉନ୍‍ଡ୍ରି କାତା ୱେର୍‌ସି ଇର୍ହାନ୍‌, “ମୁସ୍‌କୁପୁର୍‌ ଇୟାୱାଜା ଉନ୍‌ଡ୍ରି ସାର୍‍ସୁ ପାଡ଼ୁଦି ୱାଜା, ଆମାକା ଅସି ଅରେନ୍‍ ଲୋକୁ ନିଜେଦି କିଡ଼ିଇଦୁ ୱିତ୍‍ତାନ୍‍ ");
INSERT INTO kfcp_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ଆକା ତୋ ୱିଜୁ ୱିତୁ ପାଡ଼୍‌କା ମାଣାନ୍‌ ଇସ୍ରିକାତ୍‍, ମାତର୍‌ ଆକା ପିରିତିଙ୍ଗ୍‍ ୱିଜୁ କୁସାଦି ମାଣ୍‌କୁ ପେରିକା ଆଜି ଇୟାୱାଜା ମାରାନ୍‌ ଆନାତ୍‌ ଜେ, ବାଦଡ଼୍‌ତି ପଟିଙ୍ଗ୍‌ ୱାଜି ତାନି କମେଆଙ୍ଗ୍‍ଁ ଜାଲୁ ତର୍‌ସି ବାସାନେ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ମାରିଉନ୍‍ଡ୍ରି କାତା ୱେର୍‌ସି ଇର୍ହାନ୍‌, “ମୁସ୍‌କୁପୁର୍‌ ଇୟାୱାଜା । ଅରେତ୍‌ ଆଇମା କାଣ୍ତେକ୍‍ କମିର୍‌ ଅସି ଆଡା ଅଟା ଗୁଣ୍ତାଦୁ ମିସାକିଜି ପିଡ଼ିକ୍‍ସି ଇଟ୍‍ତାତ୍‍ । ଟିକ୍‌ ସମୟ୍‍ତୁ ୱିଜୁ ଦୁର୍‍ ଗୁଣ୍ତା ଆବେ ମିସାଜି ଉଦ୍‍ଜି ନିଙ୍ଗିଁତାତ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ଜିସୁ ଇୟାୱିଜୁ ମାଟା କାତାଦାନ୍‍ ଲୋକାଙ୍ଗ୍‌ ୱେର୍‍ସିମାର୍ହାନ୍‍, ମାରି କାତା ୱେର୍‍ଏଣ୍ତା ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଇନିକା ଇନ୍‍ଏଜିମାର୍ହାନ୍‍, ");
INSERT INTO kfcp_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ଏଣ୍ତେସ୍‌ ବାବବାଦି ମାଣାନ୍‌ ରାସାତି ଇୟା ବାକ୍ୟ ସତ୍‌ ଆନାତ୍‌, “ନାନ୍ କାତାଦାନ୍‍ ୱାରି ୱାଲେ ମାଟା ୱାର୍‍ଗିନା । ଦୁନିଆ ତିଆର୍‌ଆତି ଆଗ୍‍ଡ଼ିରି ନେସ୍‍ଇମାନି ୱିଜୁ ମାଟା ଇୟାୱାଜା ନାନ୍ ୱାରିଙ୍ଗ୍‌ ବୁଜାକିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ଲୋକା ଗଲିଦାନ୍‍ ସହସି ୱାଜି ଜିସୁ ଏସ୍ତିୱାଲେ ଇଲୁ ଲୋଇ ସର୍ହାନ୍‍, ୱାନି ସିସୁର୍‍ ୱାଜି ୱେନ୍‌ବାତାର୍‌, “କିଡ଼ିଇଦି ଗଲୁତକାଲାଟାଦି କାତାଦି ଅର୍ତ ମାଙ୍ଗିଁ ବୁଜାକିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ଜିସୁ ଇର୍ହାନ୍‌, ଏମେ ଲୋକୁ ନେଗି ୱିତୁ ୱିତ୍‍ତାନ୍‍, ୱାନ୍‌ ମନୁସ୍ୟପୁତ୍ର । ");
INSERT INTO kfcp_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ଇୟା ଦୁନିଆ ଆଜିନାତ୍‍ କିଡ଼ିଇ । ଏମେକାର୍‌ ମୁସ୍‌କୁପୁର୍‌ତି ଅଦିକାରି, ୱାର୍‌ ନେଗି ୱିତୁ । ଗଲୁତକାଲାଟେଙ୍ଗ୍‌ ସୟତାନ୍‍ତି ୱାଲେ ବୁଲାନିକାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ଏମେ ସାତ୍ରୁ ଗଲୁତକା ଲାଟା ୱିତ୍‍ତାନ୍‍, ୱାନ୍‌ ସୟତାନ୍ । ପାସି ଉଣ୍ତାକିନି ସମୟ୍ ଆଜିନାତ୍‍ ୱିଜ୍‍ନି ଜୁଗ୍‌ । ପାସି କୟ୍‍ନିକାର୍‍ ଆଜିନାର୍‌ ମୁସ୍‌କୁପୁର୍‌ତି ଦୁତ୍‌କୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ଗଲୁତକା ଲାଟେଙ୍ଗ୍‌ ଏଣ୍ତେସ୍‌ ଉଡ୍ରେମାନୁ କିଜି ଆଡ଼୍‍କାଇଆତେ, ଜୁଗ୍‌ ୱିଜ୍‍ନିୱାଲେ ଆୟାୱାଜା ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ମନୁସ୍ୟପୁତ୍ର ୱାନି ରାଜିଦାନ୍‍ ୱିଜୁ ତାଗ୍‌ଇ ପାଣିକିନିୱାରିଙ୍ଗ୍‌ ନି ଏମେକାର୍‌ ଆଇୱାରିଙ୍ଗ୍‌ ପାପ୍‌ କିବିସ୍‍ କିଦେଙ୍ଗ୍‌ ଉତ୍‍ନାର୍‍, ୱାରିଙ୍ଗ୍‌ ଉଣ୍ତାକିଦେଙ୍ଗ୍‌ ଇଜି ମୁସ୍‌କୁପୁର୍‌ତି ଦୁତ୍‌କାଙ୍ଗ୍‌ ପକ୍‍ନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ୱାର୍‌ ଇୟା ୱିଜେରିଙ୍ଗ୍‌ କାସ୍‍ନି ସିସୁଦୁ ପକ୍‍ନେ । ଆବେ ଇୟା ଲୋକୁ ଆଡ଼୍‍ବାନାର୍‍ ମାରି ପାଲ୍‍କୁ କାତ୍ରେ କିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ନାସ୍ତିୱାଲେ ମାପୁରୁଦି ଲୋକୁ ମୁସ୍‌କୁପୁର୍‌ତି ବୁବାମାନୁ ୱେଡ଼ାଦି ୱାଜା ଜାୟ୍‌ ଆନାର୍‌ । ଏମେୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଗିତଣିଙ୍ଗ୍‍ମାନେ, ୱାନ୍‌ ୱେନିନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","ମୁସ୍‌କୁପୁର୍‌ କିଡ଼ିଇଦୁ ମାର୍‍ଗିତିମାନି ଦନ୍‌ତି ୱାଜା । ଅରେନ୍‍ ଲୋକୁ ଆକା ସୁଡ଼୍‌ଜି ମାର୍‍କ୍‍ସି ଇଟ୍‌ତାନ୍‌ ମାରି ୱେଡ଼ିକାଦାନ୍‌ ସଲ୍‌ସି ନିଜେଦି ୱିଜୁ ପର୍‌ଜି ଆୟା କିଡ଼ିଇଦିଙ୍ଗ୍‍ କଟାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","ମାରି, ମୁସ୍‌କୁପୁର୍‌ ଇୟାୱାଜା । ଅରେନ୍‍ ବେପାରି ନାଣ୍ତଦାରାଦି ମୁକ୍ତା ପୟ୍‍ଜିମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ଉଣ୍ତ୍ରି ନାଣ୍ତଦାରାଦି ମୁକ୍ତା ପୟ୍‌ଜି ୱାନ୍‌ ୱାନି ୱିଜୁ ଦନ୍‌ ପର୍‌ଜି ତାନିଙ୍ଗ୍‌ କଟାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","ମାରି, ମୁସ୍‌କୁପୁର୍‌ ଉଣ୍ତ୍ରି ମିନ୍‌କୁ ଆସ୍‌ନି ଜାଡ଼ିଦି ୱାଜା । ମିନ୍‌କୁ ଆସ୍‍ନିକାର୍‍ ଗାଡାଦୁ ଜାଡ଼ି ପକ୍‍ସି ରକମ୍‌ ରକମ୍‌ ଜାତିଦି ମିନ୍‌କୁ ଆସ୍‌ନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ଜାଡ଼ି ପୁରୁନ୍ଆତିଙ୍ଗ୍‍ ଲୋକୁ ଗାଡା ପାଡ଼ି ରେଲ୍‌ଜି ତାତାର, ମାରି ବାସ୍‌ସି ନେଗି ନେଗି ମିନ୍‌କୁ ଆସ୍‍କିଜି ସାଟ୍‌ନାଦୁ ଇଡ୍‍ନାର୍‍ ମାରି ତାଗ୍‌ଇ ମିନ୍‌କୁ ପକ୍‍ନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ଜୁଗ୍‌ ୱିଜ୍‍ନି ୱାଲେ ଇୟାୱାଜା ଆନାତ୍‌ । ଦୁତ୍‌କୁ ସହସିୱାଜି ଦାର୍ମୁଦିଲୋକା ମାଣ୍‌କୁ ତାଗ୍‌ଇ ଲୋକାଙ୍ଗ୍‌ ୱେର୍‍ଏକିନେ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ମାରି ୱାରିଙ୍ଗ୍‌ ସିସୁ କାସ୍‍ନିମାନୁ ପକ୍‍ନାର୍‍; ଆବେ ଆଡ଼୍‍ବାନାର୍‍ ମାରି ପାଲ୍‍କୁ କାତ୍‌ରେକିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ଜିସୁ ସିସୁରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ଇୟାୱିଜୁ ବିସୟ୍‌ ବୁଜାଦେଙ୍ଗ୍‌ ଆଟ୍‍ସିନିଦେର୍‍ ?” ୱାର୍‌ ଇର୍ହାର୍‌, “ହୁଁ ପ୍ରବୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଏମେ ଇଲୁଦି ମାଲିକ୍‌ ନିଜେଦି ଗୁଦାମ୍‍ତାନ୍‍ ପୁନିକା ନି ପାଡ଼ିଇ ଜିନିସ୍‌ ସପ୍‍ନାନ୍‍, ଦାର୍ମୁଗୁରୁ ଏନ୍‌ ମୁସ୍‌କୁପୁର୍‌ତୁ ସିସୁଆତାମାନାନ୍‍ ୱାନ୍‌ ଇୟାୱାଜା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ଜିସୁ ଇୟାୱିଜୁ କାତା ୱିସ୍‌ତି ୱେନ୍‌କା ଆୟା ବାଡିଦାନ୍‍ ସର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ମାରି, ଜିସୁ ନିଜେଦି ବୁବାସି ଗାଡ଼୍‌ତୁ ୱାଜି ଲୋକାଙ୍ଗ୍‌ ୱାରି ପାର୍‍ତନା କିନି ଇଲୁଦୁ ଇୟାୱାଜା ସିକିୟା ସିତାନ୍‌ ଜେ, ୱାର୍‌ କାବାଆଜି ଇର୍ହାର୍‌, “ଇୟାୱାଜା ବୁଦି ମାରି ସାକ୍ତିଦି ପାଣି ଏମେଣ୍‌କୁ ପୟ୍‌ତାନ୍‌ ?” ୱାର୍‌ ୱେନ୍‌ବାତାର୍‌, “ଇୟା କାବାଆନିପାଣିଦି ବିସୟ୍‌ତାନ୍‌ ଇନିକା ?” ");
INSERT INTO kfcp_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ଇକାନ୍‌ ଇନିକା ଆୟା ବାଡ଼େଇତି ମାରିନ୍‌ ଆଏନ୍‍ ? ମରିୟମ୍‌ ଇନିକା ତାମେ ଆଇସି ଆଏତ୍‍ ? ଜାକୁବ, ଜସେପ୍‍, ସିମୋନ୍‌ ନି ଜିହୁଦା ଇନିକା ୱାନି ତଡ଼ାନ୍‌କୁ ଆଏର୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ୱାନି ତାଙ୍ଗିଁକ୍‍ ଇନିକା ଇବେ ବାସାଉ ? ଇୟାୱିଜୁ ବୁଦି ନି ସାକ୍ତି ୱାନ୍‌ ପୟ୍‌ତାନ୍‌ ଏମେଣ୍‌କୁ ? ");
INSERT INTO kfcp_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ଇକା ଇଜି ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ମାନାଏତାର୍‍ । ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଅରେନ୍‍ ବାବବାଦି ନିଜେଦି ଇଲୁ ନି ନାର୍‍ତିଙ୍ଗ୍‍ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ଆଇ ୱିଜୁମାନୁ ସନ୍‍ମାନ୍‍ ପୟ୍‌ନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ବିସ୍‍ବାସ୍‍ କିଏତାର୍‍ଆକା ୱାନ୍‌ ଆବେ ୱାନି କାବାଆନି ପାଣି ମାରି ନାଣ୍ତ କିଏତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ଆୟା ସମୟ୍‍ତୁ ଗାଲିଲିଦି ସାସନ୍‌କିନି ସାମନ୍ତରାଜା ହେରୋଦ ଜିସୁଦି ବିସୟ୍‌ତାନ୍‌ ୱେର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ୱାନ୍‌ ୱାନି ପାଣିକିନିୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଇକାନ୍‌ ସତେନେ ଡୁବନ୍‌ସିନି ଯୋହନ ଡ଼େସି ଜିବନ୍‌ ପୟ୍‌ଜି ୱାତାମାନାନ୍‍ । ଆୟା ଉଣ୍ତିଙ୍ଗ୍‌ ୱାନି କାବାଆନି ପାଣିକିଦେଙ୍ଗ୍‌ ସାକ୍ତି ମାନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ତେନି ଆଗ୍‌ଡ଼ି ହେରୋଦ ଯୋହନତିଙ୍ଗ୍‌ ତର୍‍ସିସ୍‍କିଦେଙ୍ଗ୍‍ ଆଦେସ୍‌ ସିତାମାର୍ହାନ୍‍, ମାରି ୱାନିଙ୍ଗ୍‌ ସିକିଣିଦାନ୍‍ ତର୍‌ସି ଜଇଲ୍‌ତୁ ଇଡିସ୍‍କିତାମାର୍ହାନ୍‍ । ୱାନି ତଡ଼ାନ୍‌ ପିଲିପ୍‍ତି ଆଡ଼୍‌ସି ହେରଦିଆଦି ଉଣ୍ତିଙ୍ଗ୍‌ ୱାନ୍‌ ଇକା କିତାମାର୍ହାନ୍ । ");
INSERT INTO kfcp_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ଡୁବନ୍‌ସିନି ଯୋହନ ହେରଦତିଙ୍ଗ୍‍ ଇଜିମାର୍‍ଆନ୍‍, “ହେରଦିଏଙ୍ଗ୍‍ଁ ପେଡ଼ି କିନିକା ନି ଟିକ୍‌ ସିଲେତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ହେରଦ ଯୋହନତିଙ୍ଗ୍‌ ସାୟାମାର୍‌ଗା ଡାକ୍‌ତେଙ୍ଗ୍‌ ବଦାକିଜିମାର୍ହାନ୍‍, ମାତର୍‌ ଜିହୁଦି ଲୋକାଙ୍ଗ୍‌ ୱାନ୍‌ ତିଲାଜିମାର୍ହାନ୍‍ । ଇରିଙ୍ଗ୍‌ ୱାର୍‌ ଯୋହନତିଙ୍ଗ୍‌ ଅରେନ୍‍ ବାବବାଦି ଇଜି ମାନାଜିମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ହେରୋଦ୍‍ତି ଜନମ୍‍ଦିନ୍ ନାଣ୍ଡିଙ୍ଗ୍ ହେରଦିଆଦି ଗାଡ଼୍‌ସି କୁଡ଼ାଙ୍ଗାଁ ଆଗ୍‌ଡ଼ି ଗାତ୍‍ସି ହେରଦତିଙ୍ଗ୍‍ ୱେଡ଼ିକା କିବିସ୍‍କିତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ଆବେଟ୍‌ ୱାନ୍‌ ତାନିଙ୍ଗ୍‌ ପାର୍‍ମାଣ୍‍କିଜି ଇର୍ହାନ୍‌, “ନାନ୍ ପାର୍‌ମାଣ୍‌ କିଜି ଇଜିନା, ନିନ୍‌ ଆମାକା ଲସ୍‌ନି, ନାନ୍ ନିଙ୍ଗିଁ ଆକା ସିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ତାନି ଆଇସିଦି ମାଟା ଆସ୍‌ସି ଆଇଲି ଇର୍ହାତ୍‌, “ଡୁବନ୍‌ସିନି ଯୋହନତି ତାଲା ଇବେ, ଇୟାଦାପ୍ରେ ଉଣ୍ତ୍ରି ସାଡ଼୍‍ୱାଦୁ ଇଡ୍‌ଜି ନାଙ୍ଗିଁ ସିଦା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ଇକା ୱେନ୍‌ଜି ରାଜା ନାଣ୍ତ ଦୁଃଖ କିତାନ୍‌ । ମାତର୍‌ କୁଡ଼ାଙ୍ଗାଁ ଆଗ୍‌ଡ଼ି ପାର୍‌ମାଣ୍‌ କିତାମାର୍ହାନ୍‍ଆକା ଆଇଲିଦି ଆସାଦିଙ୍ଗ୍‍ ପୁରା କିଦେଙ୍ଗ୍‌ ଆଦେସ୍‌ ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ଆବେଟ୍‌ ଜଇଲ୍‌ତୁ ଯୋହନତି ତାଲାଦିଙ୍ଗ୍‍ ଲୋକାଙ୍ଗ୍‌ ପକ୍‍ସି କଇସ୍‍କିତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ମାରି ଉଣ୍ତ୍ରି ସାଡ଼୍‍ୱାଦୁ ୱାନି ତାଲା ଇଡ୍‌ଜି ଆୟା ଆଇଲିଦିଙ୍ଗ୍‍ ସିତାର୍‍ । ୱାଦ୍‌ ତାନିଙ୍ଗ୍‌ ଅସି ତାନି ଆଇସିଙ୍ଗ୍‍ ସିତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ତାନିୱେନ୍‍କା ଯୋହନତି ସିସୁର୍‍ ୱାଜି ମୁସ୍‍ତେଙ୍ଗ୍‍ ଇଜି ୱାନି ସାତି ମାଡ଼ାଦିଙ୍ଗ୍‍ ଅତାର୍‌ । ୱାର୍‌ ସଲ୍‌ସି ଜିସୁଙ୍ଗୁଁ ଇୟା ଦୁକ୍‍ତି କାବୁର୍‌ ୱେର୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ଯୋହନତି କାବୁର୍‌ ୱେର୍‍ଇଦାପ୍ରେ ଜିସୁ ଡଙ୍ଗାଁଦୁ ଏକ୍‌ସି ଉଣ୍ତ୍ରି ସିମ୍ରା ବାଡିଦୁ ସର୍ହାନ୍‍ । ଜିସୁ ଆବେ ସଲ୍‌ସି ମାନିକା ନେସ୍‌ସି ଲାକ୍‌ତୁରି ଗାଡ଼ାକାଣ୍‍କୁ ନାଣ୍ତ ଲୋକୁ ବୁଲାଜି ବୁଲାଜି ଜିସୁୱାଲେ ସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ମାରି, ଜିସୁ ଡଙ୍ଗାଁଦାନ୍‍ ସତାନ୍‍ନୋ ନାଣ୍ତ ଲୋକାଙ୍ଗ୍‌ ସୁଡ଼ୁଜି ୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ଦୁଃକ୍‌ କିତାନ୍‌, ୱାନି ଜିବନ୍‌ ଦୟାଦୁ ଆଡ଼୍‍ବାତାସର୍ହାତ୍‍ । ନାଣ୍ତ ରଗ୍‌ ଲୋକାଙ୍ଗ୍‌ ୱାନ୍‌ ନେଗେନ୍‌କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ଆୟା ନାଣ୍ଡିଙ୍ଗ୍ ମିଲ୍‌ମିଲିକା ସିସୁର୍‍ ୱାଜି ଇର୍ହାର୍‌, “ନାଣ୍ତ ୱେଡ଼ା ଆତାତ୍‌ନି, ମାରି ଇୟା ବାଡି ସିମ୍ରା, ଲୋକାଙ୍ଗ୍‌ ପକ୍‍ଆ । ୱାର୍‌ ନାର୍‍କାଙ୍ଗ୍‍ଁ ସଲ୍‌ସି ନିଜେଦି ଉଣ୍ତିଙ୍ଗ୍‌ କାଦି କଡ଼ିରି ।” ");
INSERT INTO kfcp_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ୱାର୍‌ ଇବେଟ୍‌କୁ ସନି ଦର୍‌କାର୍‌ ସିଲେ । ମିର୍‌ ୱାରିଙ୍ଗ୍‌ ଇନିକା ଉଣ୍ତେଙ୍ଗ୍‌ ସିଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ସିସୁର୍‍ ଇର୍ହାର୍‌, “ଇବେ ମା ଲାକ୍‌ତୁ କେବଲ୍‌ ପାସ୍‌ଗୋଟା ରୁଟିଙ୍ଗ୍‌ ମାରି ରୁଣ୍ତି ମିନ୍‌କୁ ମାନେ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ଜିସୁ ଇର୍ହାନ୍‌, “ଆକେଙ୍ଗ୍‍ ଇବେ ନା ଲାକ୍‌ତୁ ତାଗାଟ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ଲୋକାଙ୍ଗ୍‌ ଲାଟା ମୁସ୍‌କୁ ବାସ୍‌ତେଙ୍ଗ୍‌ ଇଜି ଜିସୁ ଆୟା ପାସ୍‌ଗୋଟା ରୁଟିଙ୍ଗ୍‌ ମାରି ରୁଣ୍ତି ମିନ୍‌କୁ ଅତାନ୍‌ ମାରି ସ୍ୱର୍ଗ ତରିନ୍‌ ସୁଡ଼୍‌ଜି ମାପୁରୁଙ୍ଗ୍‍ଁ ଦନ୍ୟବାଦ୍‌ ସିତାନ୍‌ । ମାରି ୱାନ୍‌ ରୁଟିଆଙ୍ଗ୍‍ଁ ରୁକ୍‍ସି ରୁକ୍‍ସି ସିସୁରି କିୟୁଦୁ ସିତାନ୍‌ । ସିସୁର୍‍ ଆୟାୱିଜୁ ଅସି ଲୋକା ଲୋଇ ବାଟାକିତାସିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ୱିଜେରେ ତିର୍‌ଆରୋ ପଟାପାଜିତାର୍‍ । ତାନିୱେନ୍‍କା ସିସୁର୍‍ ଆମା ମକା ରୁଟିଙ୍ଗ୍‌ ଏଜିତେ, ଆକେଙ୍ଗ୍‍ ଉଣ୍ତା କିଜି ବାରଗୋଟା ଡାଡ଼ିଆଙ୍ଗ୍‍ଁ ବର୍ତି କିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ଆଇମେକ୍‍ ନି କଡ଼ରିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ସି ୫,୦୦୦ ହାଜାର୍‌ ମେମାର୍‍ଙ୍ଗୁଁ ଇୟା କାଦି ଉଟାମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ଇୟା ୱେନ୍‌କା ଜିସୁ ସିସୁରିଙ୍ଗ୍‌ ଡଙ୍ଗାଁଦୁ ଏକ୍‌ସି ୱାନି ଆଗ୍‌ଡ଼ି ଗାଡା ଆୟା ପାଡ଼ି ସନ୍‍ଡ୍ରେଙ୍ଗ୍‍ ଇଜି ଇର୍ହାନ୍‌, ମାରି ୱାନ୍‌ ୱେନ୍‌କା ତେବାଜି ଲୋକାଙ୍ଗ୍‌ ପକ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ଜିସୁ ଲୋକାଙ୍ଗ୍‌ ପୋକ୍‍ତି ୱେନ୍‌କା ୱାନ୍‌ ପାର୍‌ତନା କିଦେଙ୍ଗ୍‍ ଇଜି ଗରନ୍‌ ମୁସ୍‌କୁ ସର୍ହାନ୍‍, ମାରି ମିଲ୍‌ମିଲ୍‌କା ଆତି ୱେନ୍‌କା ୱାନ୍‌ ଆବେ ଅରେନ୍‍ ତେବାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ମାତର୍‌ ଡଙ୍ଗାଁ ନାସ୍ତିୱାଲେ ଗାଡା ପାଡ଼ିଦାନ୍‍ ନାଣ୍ତ ଆକ ମାର୍ହାତ୍‌ ମାରି ନାଣ୍ତ ଗାଲି ଆଜିମାର୍ହାତ୍‍ଆକା ଉଲ୍‍କା ଦକାଦାନ୍‍ ଦୁଙ୍ଗ୍‍ଁଜିମାର୍ହାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ସାଲ୍‍ଦି କର୍‌ରୁ କେଡ଼େପି ଜିସୁ ସାମ୍‌ଦୁର୍‌ ମୁସ୍‌କୁ ବୁଲାଜି ସିସୁରି ଲାକ୍‌ତୁ ୱାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ମାରି ସିସୁର୍‌ ୱାନିଙ୍ଗ୍‌ ସାମ୍‌ଦୁର୍‌ ମୁସ୍‌କୁ ବୁଲାନିକା ସୁଡ଼ୁତାରୋ ତିଲାଜି ଇର୍ହାର୍‌, “ଇକା ତୋ ଦୁବା !” ମାରି, ୱାର୍‌ ତିଲାଜି ଆଉଲି ଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ଜିସୁ ଆୟାଦାପ୍ରେ ୱାରି ୱାଲେ ୱାର୍‌ଗିଜି ଇର୍ହାନ୍‌, “ସାସ୍‌ ଆସ୍‌ତୁ, ଇକାନ୍‌ ତୋ ନାନ୍, ତିଲାମାଟ୍‌ !” ");
INSERT INTO kfcp_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ଇକା ୱେନ୍‌ଜି ପିତର୍‌ ଇର୍ହାନ୍‌, “ପ୍ରବୁ, ଜଦି ସତ୍‌ତାନ୍‌ ନିନ୍‍ଆନିମାନି, ଏରୁ ମୁସ୍‌କୁ ବୁଲାଜି ନି ଲାକ୍‌ତୁ ୱାଦେଙ୍ଗ୍ ଇଜି ନାଙ୍ଗିଁ ଆଦେସ୍‌ ସିଦା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ଜିସୁ ଇର୍ହାନ୍‌, “ରାଆ ।” ପିତର୍‌ ଡଙ୍ଗାଁଦାନ୍‍ ରେତାଜି ଜିସୁଦି ତରିନ୍‌ ଏରୁ ମୁସ୍‌କୁ ବୁଲାଦେଙ୍ଗ୍‍ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ମାତର୍‌ ଗାଲି ନାଣ୍ତ ଆନିକା ସୁଡ଼୍‌ଜି ତିଲାତାନ୍‍ ମାରି ଏରୁତୁ ମୁଡ଼ୁଗିଜି ସନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଆସ୍‍ତାନ୍‍ । ଆବେଟ୍‌ ୱାନ୍‌ ଆଉଲି ଆଜି କୁକ୍‍ତାନ୍‍, “ପ୍ରବୁ, ନାଙ୍ଗିଁ ରକିୟାକିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ଜିସୁ ଆୟାଦାପ୍ରେ କିୟୁ ସପ୍‍ସି ୱାନିଙ୍ଗ୍‌ ଆସ୍‌ସି ଇର୍ହାନ୍‌, “ଏ ଅଡ଼ପ୍‍ ବିସ୍‍ବାସି ! ଏନ୍ଦା ନିନ୍‌ ଆନ୍‍ମାନ୍‍କିତି ?” ");
INSERT INTO kfcp_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ୱାର୍‌ ରିଏର୍‌ ଡଙ୍ଗାଁଦୁ ଏକ୍‍ତାର୍‍ ମାରି ଆୟାଦାପ୍ରେ ଗାଲି ତିର୍‌ ଆତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ଆବେଟ୍‌ ଡଙ୍ଗାଁଦୁମାନି ସିସୁର୍‍ କାବାଆଜି ଜିସୁଙ୍ଗୁଁ ମାଡ଼ିସ୍‍କିଜି ଇର୍ହାର୍‌, “ନିନ୍‌ ସତେନେ ମାପୁରୁଦି ମାରିସି ।” ");
INSERT INTO kfcp_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ୱାର୍‌ ନାସି ଗିନେସରତ ଗାଡ଼୍‌ତୁ ୱାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ଆବେଣି ଲୋକୁ ଜିସୁଙ୍ଗୁଁ ସିନିସ୍‌କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ସି ଲାକ୍‌ତୁରି ନାର୍‍କାଙ୍ଗ୍‍ଁ ମାନି ରଗ୍‌ ଲୋକାଙ୍ଗ୍‌ ଜିସୁ ଲାକ୍‌ତୁ ତାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ରଗ୍‌ଲୋକାଙ୍ଗ୍‍ ଆବ୍‍କା ନି ୱାତି ଜାଲି ମୁଟ୍‌ତେଙ୍ଗ୍‌ ସାରି ସିଦା ଇଜି ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ମାଡ଼ିସ୍‍କିତାର୍‍ । ଏମେକାର୍‌ ମୁଟ୍‍ତାର୍‍, ୱାର୍‌ ନେଗେନ୍‍ ଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ଅର୍‍ଲେନ୍‍ ଏସ ଲୋକୁ ପାରୁସିର୍‌ ମାରି ସାସ୍ତ୍ରିର୍‌ ଜିରୁସାଲମ୍‌ତାନ୍‌ ୱାଜି ଜିସୁଙ୍ଗୁଁ ୱେନ୍‌ବାତାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“ମା ପୁର୍ବେଦିଡକ୍‌ରାଦାଦାର୍‌ ଆମାୱିଜୁ ନିତିନିୟମ୍ ସିତା ସର୍‌ଆମାନାର୍‌, ନି ସିସୁର୍‍ ଏନ୍ଧା ଆୟାୱିଜୁ ମାନାଏଜିନାର୍‌ ? ଉଣି ଆଗ୍‍ଡ଼ିନେ ମା ନିତିନିୟମ୍ ନେଗେନ୍‍କିଜି କିକୁ ନର୍‌ବାଏଣ୍ତା ଏନ୍ଦା ଉଣୁଜିନାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ମିର୍‌ ଏନ୍ଧା ମାପୁରୁଦି ମାଟା ମାନାଏଜି ନିଜେଦି ନିତିନିୟମ୍ ଇସାବ୍‌ତାନ୍‌ ପାଣି କିଜିନିଦେର୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ମାପୁରୁ ତୋ ୱେର୍‌ତାମାନାନ୍‌, ବୁବା ୟାୟାଏଙ୍ଗ୍‍ ମାନାଦୁ, ଏନ୍‌ ନିଜେଦି ବୁବା ନି ୟାୟାଙ୍ଗ୍‌ ଆନାଦୁରିଆ ସିନାନ୍‌, ୱାନ୍‌ ସାନି ଦଣ୍ଡ୍‌ ପୟ୍‌ନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ମାତର୍‌ ମିର୍‌ ଇଜିନିଦେର୍‌, ଆମା ଲୋକୁ ବୁବା ନି ୟାୟାଙ୍ଗ୍‌ ଇନାନ୍‌, ନା ମାଣ୍‌କୁ ଆମାକା ମି ଉଣ୍ତିଙ୍ଗ୍‌ ଆତାମାନାତ୍‌, ଆକା ପ୍ରବୁଦି ଉଦେସ୍‍ତାନ୍‍ ପୁଜା ସିଆତାମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ୱାନ୍‌ ମାରି ନିଜେଦି ବୁବା ନି ୟାୟାରିଙ୍ଗ୍‌ ସମ୍ମାନ୍‌ କିଏନ୍‌ । ଇୟାୱାଜା ଇସାବ୍‌ତାନ୍‌ କିଜି ୱାଜି ମିର୍‌ ମାପୁରୁଦି ମାଟା ମାନାଏଜି ନିଜେଦି ସିକିୟା ଇସାବ୍‌ତାନ୍‌ ବୁଲାଜିନି । ");
INSERT INTO kfcp_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ଏ ସାଲାକିଦି ଦାର୍ମୁ ଦଲ୍‌, ଜିସାଇୟ ମି ବିସୟ୍‌ତାନ୍‌ ଜତାର୍ତ ୱାଜା ଇୟା ବାବବାଣି ୱେର୍‌ତାମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","ମାପୁରୁ ଇଜିନାନ୍‌, ଇୟା ଲୋକୁ କେବଲ୍‌ ମାଟାଦାନ୍‌ ନାଙ୍ଗିଁ ସମ୍ମାନ୍‌ କିନାର୍‌, ମାତର୍‌ ୱାରି ଜିବନ୍‌ ନା ମାଣାନ୍‌ ନାଣ୍ତ ଆକ । ");
INSERT INTO kfcp_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ନାଙ୍ଗିଁ ୱାର୍‌ ଆମା ଆରାଦନା କିନାର୍‌, ଆକା ପାଣିସିଇକା, ଇରିଙ୍ଗ୍‌ ୱାର୍‌ ଲୋକୁ ତିଆର୍‌ କିତି ନିୟମ୍‌କୁ ନା ମାଟା ଇଜି ୱେର୍‌ସିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ତାନେୱେନ୍‌କା ଜିସୁ ଲୋକାଙ୍ଗ୍‌ ଲାକ୍‌ତୁ କୁକ୍‌ସି ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ୱେନ୍‌ଡ୍ରୁ ମାରି ବୁଜାଦୁ; ");
INSERT INTO kfcp_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ଲୋକା ୱେୟୁ ସିଜି ଆମାକା ଲୋଇ ଡ଼ୁଗୁନାତ୍‌, ଆକା ୱାନିଙ୍ଗ୍‌ ଅପବିତ୍ର କିଏତ୍‌; ମାତର୍‌ ୱେୟୁଦାନ୍‌ ଆମାକା ସନାତ୍‌, ଆକା ୱାନିଙ୍ଗ୍‌ ଅପବିତ୍ର କିନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ନାସ୍ତିୱାଲେ ସିସୁର୍‍ ଜିସୁଦି ଲାକ୍‌ତୁ ୱାଜି ଇର୍ହାର୍‌, “ନି ମାଟା ୱେନ୍‌ଞ୍ଜି ପାରୁସିର୍‌ ରିସା ଆତାମାନାର୍‌, ଇକା ଇନିକା ନିନ୍‌ ନେସେଇ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ଜିସୁ ଇର୍ହାନ୍‌, “ଏମେ ମାରାକ୍‌ ୱିଜୁ ନା ମୁସ୍‌କୁପୁର୍‌ତି ବୁବା ଉର୍‍ଏନ୍‌, ଆୟାୱିଜୁ ମାଗ୍‌ନେ ସନେ । ");
INSERT INTO kfcp_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ୱାରିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ସୋ ସିଦୁ, ୱାର୍‌ କାଣାର୍‌, ଆଇ କାଣାରି ସାରିତର୍‌ନିକାର୍‍; ମାରି, ଅରେନ୍‍ କାଣା ମାରି ଅରେନ୍‍ କାଣାଦିଙ୍ଗ୍‌ ସାରି ତର୍‌ନା ସିନାନ୍‌, ଆର୍‌ତିଙ୍ଗ୍‌ ରିଏର୍‌ବା ଗୁଟାଦୁ ଆର୍‌ନାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ଆବେଟ୍‌ ପିତର୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଇୟା କାତା ମାଙ୍ଗିଁ ନେସ୍‌ନିୱାଜା ବୁଜାକିଜ ସିଦା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମିର୍‌ ବା ଇନିକା ଇୟାସାନ୍ଦି ବୁଜାଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏଜିନିଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ନିସବା ବୁଜାଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏଜିନିଦେର୍‍ ? ଆମାକା ଇନିକା ୱେୟୁଦୁ ଡ଼ୁଗୁନାତ୍‌, ଆକା ପଟା ଲୋଇ ସନାତ୍‌ ମାରି ମେନ୍ଦଲ୍‌ତାନ୍‌ ସନା ସନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ମାତର୍‌ ଆମାୱିଜୁ ବିସୟ୍‌କୁ ୱାନି ୱେୟୁଦାନ୍‌ ଆତେରେ ୱାନାତ୍‌, ଆକା ୱାନି ଜିବନ୍‌ତାନ୍‌ ସନାତ୍‌, ଆକାନେ ଲୋକତିଙ୍ଗ୍‌ ଅପବିତ୍ର କିନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ଇରିଙ୍ଗ୍‌ ୱାନି ଜିବନ୍‌ତାନ୍‌ ତାଗ୍‌ଇସିନ୍ତା, ସାୟାମାର୍‌ଗାଡାକ୍‌ନିକା, ଦାରିପାଣି, ତାଗ୍‌ଇପାଣି, ଡଙ୍ଗାଁ, ମିସ୍‌ମାଟା ୱେର୍‌ନିକା ମାରି ନିନ୍ଦାକିନିକା ନାଣ୍ତ ରକମ୍‌ତି ନିୟମ୍‌ ସିଲି ପାଣି କିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ଇୟାୱିଜୁ ବିସୟ୍‌ ଲୋକତିଙ୍ଗ୍‌ ଅପବିତ୍ର କିନାତ୍‌ । ମାତର୍‌ ନିତିନିୟ୍‍ତାନ୍‍ କିୟୁ ନର୍‌ବାଏଣ୍‌ଗା ଉଣିକା ଆକା ଲୋକ୍‌ତିଙ୍ଗ୍‌ ଅପବିତ୍ର କିଏତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ଜିସୁ ଆୟା ବାଡି ଡ଼ିସ୍‌ତାନ୍‌ନୋ ସୋର ନି ସିଦନ୍‍ ରାଜିଦି ଗାଡ଼୍‌କାଙ୍ଗ୍‌ ସୋର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ଆବେନୁ ତେବାଜି ମାନି ଅରେତ୍‌ କିଣାନିୟା ଆଇମା ଜିସୁଦି ଲାକ୍‌ତୁ ୱାଜି ଇର୍ହାତ୍‌, “ଏ ପ୍ରବୁ, ଦାଉଦତି ମାରିନ୍‌, ନାଙ୍ଗିଁ ଦୟା କିଆ । ନା ଗାଡ଼ିଙ୍ଗ୍‌ ଦୁବା ଆସ୍‌ତାମାନାତ୍‌ ମାରି ୱାଦ୍‌ ନାଣ୍ତ କାସ୍ଟୁ ବଗାଜିନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ମାତର୍‌ ଜିସୁ ତାନେଙ୍ଗ୍‌ ପଦେକ୍‌ ମାଟାବା ଇନ୍‌ଏତାନ୍‌ । ମାରି ୱାନି ସିସୁର୍‍ ୱାଜି ୱାନିଙ୍ଗ୍‌ ମାଡ଼ିସ୍‌କିଜି ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, “ତାନେଙ୍ଗ୍‌ ବେଗି ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଇନିଆ, ସୁଡୁଆ ୱାଦ୍‌ ଏଣ୍ତେସ୍‌ ଆଉଲି ଆଜି ମା ୱେନ୍‌କା ୱେନ୍‌କା ୱାଜିନାତ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ଜିସୁ ଇର୍ହାନ୍‌, “ନାନ୍ ଇସ୍ରାଏଲ୍‌ କୁଟୁମ୍‌ତି ମୁରିତିମାନି ମେଣ୍ତେଆଙ୍ଗାଁ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ମାରି ଏ ଲାକ୍‌ତୁ ରେଏ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ଆଇମା ୱାଜି ଜିସୁଦି କାଲ୍‌କା ଆଡ୍‍ଗି ମେଣ୍ତେଙ୍ଗ୍‍ ଗଟ୍‌କିଜି ଇର୍ହାତ୍‌, “ଏ ପ୍ରବୁ, ନାଙ୍ଗିଁ ଦୟା କିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ଜିସୁ ଇର୍ହାନ୍‌ । “ଇରିଙ୍ଗ୍‌ କଡ଼ରି ବାଟା ଖାଦି ଅସି ନୁକୁଡ଼ିଆଙ୍ଗାଁ ମାନୁ ପୋକ୍‍ନିକା ନେଗେତ୍‌ ସିଲେ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ଆଇମା ଇର୍ହାତ୍‌, “ଆକା ସତ୍‌ ପ୍ରବୁ, ମାତର୍‌ ନୁକୁଡ଼ିଙ୍ଗ୍‌ ବା ଟେବୁଲ୍‌ ଆଡ୍‍ଗି ଆର୍‌ନି ମାଲିକ୍‌କା ସକ୍‌ଡ଼ି ଉନ୍‌ଣ୍ତେ ପଇନେ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ଜିସୁ ତାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନିନୁ ଅରେତ୍‌ ଡାଟ୍‌ତି ବିସ୍‌ବାସ୍‌ତି । ନି ବଦା ପୁରା ଆନାତ୍‌ ।” ଆୟା ଦ୍ରାପେନେ ତାନି ଗାଡ଼୍‌ସି ନେଗେନ୍‌ ଆତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ଜିସୁ ଆବେଟ୍‌ତାନ୍‌ ଡ଼ିସ୍‌ତାନ୍‌ନୋ ଗାଲିଲି ଗାଡା ଲାକ୍‌ତୁ ୱାତାନ୍‌, ମାରି ଗରନ୍‌ ମୁସ୍‌କୁ ସୋର୍ହାନ୍‌ନୋ ଆବେନ୍‌ ବାସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ନାଣ୍ତ ଲୋକୁ ୱାଜି ୱାନି ଲାକ୍‌ତୁ ଉଣ୍ତାତାର୍‌ । ୱାର୍‌ ଚଟା, ଗୁଲା, କାଣା, ବୁଲାଦେଙ୍ଗ୍‌ ଆଟ୍‍ଇକାର୍‍ ମାରି ନାଣ୍ତ ନବ୍‌ଆତି ଲୋକାଙ୍ଗ୍‌ ତାସି ଜିସୁଦି ପାଦାମ୍‌ ଆଡ୍‍ଗି ଇଟ୍‌ତାର୍‌ ମାରି ଜିସୁ ଆୟା ୱିଜେରିଙ୍ଗ୍‌ ନେଗେନ୍‌ କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ଗୁଲାର୍‌ ଜେ ୱାର୍‌ଗିଜିନାର୍‌, କିକୁକାଲ୍‌କୁୱାର୍‌ତିକାର୍‌ବା ନେଗେନ୍‌ ଆତାର୍‌, ଚଟାର୍‌ ବୁଲାଜିନାର୍‌ ମାରି କାଣାର୍‌ ସୁଡ଼୍‌ଦେଙ୍ଗ୍‌ ଆଟ୍‌ସିନାର୍‌, ଇକା ସୁଡ଼ୁଜି ଲୋକୁୱିଜେର୍‌ କାବା ଆତାର୍‌, ମାରି ଇସ୍ରାଏଲ୍‌ତି ମାପୁରୁଙ୍ଗୁଁ ଦନ୍ୟବାଦ୍‌ କିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ଜିସୁ ନିଜେଦି ସିସୁରିଙ୍ଗ୍‌ ଲାକ୍‌ତୁ କୁକ୍‌ସି ଇର୍ହାନ୍‌, “ଇୟା ଲୋକା ଉଣ୍ତିଙ୍ଗ୍‌ ନା ଜିବନ୍‌ ଆଡ୍‌ବାଜିନାତ୍‌, ଇରିଙ୍ଗ୍‌ ଇୟାକାର୍‌ ମୁନେନ୍‌ ଆତାତ୍‌ନି ନା ୱାଲେ ମାନାର୍‌ ମାରି ଇୟାୱାରି ମାନୁ ଇନିକା ଉନ୍‌ଣ୍ତେଙ୍ଗ୍‌ ସିଲେତ୍‌ । ୱାର୍‌ ଉଣୁଏଣ୍‌ଗା ଇବେଟ୍‌କୁ ସୋଲିର୍‌, ଇୟା ମାଟା ନାନ୍ ଅଡ଼୍‌ବିଏ; ଇରିଙ୍ଗ୍‌ ଡ଼େସିସୋନିୱାଲେ ସାରିଦୁ ୱାର୍‌ ୱାନ୍ଦ୍‍ନା ସନାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ସିସୁର୍‍ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, “ଇୟା ସିମ୍ରା ବାଡିଦୁ ନିସ ଲୋକାଙ୍ଗ୍‌ ଉଟ୍‍ପିସ୍‍କିଦେଙ୍ଗ୍‍ ଇଜି ମାଡ୍‌ ଏମେଟ୍‌କୁ ନାଣ୍ତ କାଦି ପଇନିକା ?” ");
INSERT INTO kfcp_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ମି ଲାକ୍‌ତୁ ଏସଗୋଟା ରୁଟିଙ୍ଗ୍‌ ମାନେ ?” ୱାର୍‌ ଇର୍ହାର୍‌, “ସାତ୍‍ଗୋଟା ରୁଟିଙ୍ଗ୍‌ ମାରି ଏସ ଇସ୍ରି ମିନ୍‌କୁ ମାନେ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ଜିସୁ ଲୋକାଙ୍ଗ୍‌ ବୁମି ମୁସ୍‌କୁ ବାସ୍‌ତେଙ୍ଗ୍‌ ଆଦେସ୍‌ ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ତାନେୱେନ୍‌କା ୱାନ୍‌ ଆୟା ସାତଗଟା ରୁଟି ମାରି ମିନ୍‌କୁ ଅସି ମାପୁରୁଙ୍ଗୁଁ ଦନ୍ୟବାଦ୍‌ ସିତାନ୍‌ ମାରି ଆୟାୱାନିକାଙ୍ଗ୍‌ ମକେଙ୍ଗ୍‌ ମକେଙ୍ଗ୍‌ କିଜି ରୁକ୍‍ସି ସିସୁରିଙ୍ଗ୍‌ ସିତାନ୍‌ । ସିସୁର୍‍ ଆକା ଲୋକାଙ୍ଗ୍‌ ବାଟାକିତାସିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ମାରି, ୱିଜେରେ ତିନ୍‌ଞ୍ଜି ପଟା ପାଜିତାର୍‌ ମାରି ଡ଼ିକ୍‌ତି ମକାରୁଟିଙ୍ଗ୍‌ ଏସ ଏଜିତେ, ଆକା ସିସୁର୍‍ ସାତଗଟା ଡାଡ଼ିଆଙ୍ଗାଁ ବର୍ତି କିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ଉଟି ଲୋକୁ, ଆଇମେକାଙ୍ଗ୍‌ ନି କଡ଼ରିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ସି ନାଲ୍‌ଗି ହାଜାର୍‌ ମେମାରୁଙ୍ଗୁଁ ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ତାନେୱେନ୍‌କା ଜିସୁ ୱିଜୁ ଲୋକାଙ୍ଗ୍‌ ପୋକ୍‌ତାନ୍‌ନୋ ଡଙ୍ଗାଁଦୁ ଏକ୍‌ତାନ୍‌ନୋ ମଗଦାନ୍‌ ରାଜିଦୁ ୱାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ଅର୍‍ଲେନ୍‍ ଏସଲୋକ୍‌ ପାରୁସିର୍‌ ନି ସାଦୁକିର୍ ଜିସୁଙ୍ଗୁଁ ଦସ୍‌ ଆସ୍‌ତେଙ୍ଗ୍‌ ଇଜି ୱାନି ଲାକ୍‌ତୁ ୱାତାର୍‌ । ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, ମାପୁରୁ ୱାନିଙ୍ଗ୍‌ ଆସ୍‌କିତାମାନାନ୍‌ ଇଜି ପାର୍‌ମାଣ୍‌ ସିନି ଉଣ୍ତିଙ୍ଗ୍‌ ୱାନ୍‌ ଉନ୍‌ଡ୍ରି କାବାଆନି ପାଣି କିଜ ତର୍‌ଆ । ");
INSERT INTO kfcp_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ମାତର୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମିଲିମିଲିକା ବେଡ଼ାଦୁ ବାଦ୍‌ଡ଼ ନେତେର୍‌ ତରିତିଙ୍ଗ୍‌ ନେଗି ପାଗ୍‌ ଆନାତ୍‌ ଇଜି ମିର୍‌ ଇଜିନିଦେର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ମାରି ସାଲିଦିବେଡ଼ାଦୁ ବାଦ୍‌ଡ଼ ଲାଲ୍‌ ନି ସିକାଟି ତରିତିଙ୍ଗ୍‌ ପିରୁ ଆନିକା ନେସ୍‌ନିଦେର୍‌ । ମିର୍‌ ବାଦ୍‌ଡ଼ତିଙ୍ଗ୍‌ ସୁଡ଼୍‌ଜି ପାଗ୍‌ତି ମାଟା ଆଗ୍‌ଡ଼ି ନେସ୍‌ନିଦେର୍‌ । ମାତର୍‌ ଇଲେଇତି ସମୟ୍‌ତି ସିନେଙ୍ଗ୍‌ୱିଜୁ ମିର୍‌ ନେସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‍ଇଦେର୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ତାଗ୍‌ଇ ନି ଏମେକାର୍‌ ମାପୁରୁଙ୍ଗ୍‍ଁ ବିସ୍‌ବାସ୍‌ କିଏର୍‌ ୱାର୍‌ ସିନା ସୁଡ଼ୁନାର୍‌, ମାତର୍‌ ଜୁନସ୍‍ତି ସିନା ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ଆଇ ଆମାକାବା ସିନା ୱାରିଙ୍ଗ୍‌ ସିଆୟ୍‌ଆଏତ୍‌ ।” ମାରି, ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ତାନ୍‌ନୋ ସୋର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ସିସୁର୍‍ ଗାଡା ଆୟାପାଡ଼୍‌କା ଇତାରୋ ସୁଡ଼ୁତାର୍‌ଜେ, ୱାର୍‌ ରୁଟିଙ୍ଗ୍‌ ତାତେଙ୍ଗ୍‌ ବାଣାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଜାଗାର୍‌ତା ଆଦୁ, ପାରୁସି ନି ସାଦୁକିରି କମିର୍‌ଦାନ୍‌ ଜାଗାର୍‍ତାଆଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ୱାର୍‌ ଇୟା ବିସୟତୁ ୱାରିୱାରି ଲୋଇ ୱାର୍‌ଗିଜି ସାତାର୍‌, “ମାଡ୍‌ ରୁଟିଙ୍ଗ୍‌ ତେଇକା ଇଜି ୱାନ୍‌ ଇକା ଇଜିନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ୱାର୍‌ ଇନିକା ଇଜିମାର୍ହାର୍‌ ନେସ୍‌ତାନ୍‌ନୋ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମି ଲାକ୍‌ତୁ ରୁଟିଙ୍ଗ୍‌ ସିଲୁ ଇଜି ଏନ୍ଦା ୱାର୍‌ଗିଜି ସାଜିନିଦେର୍‌ ? ମି ବିସ୍‌ବାସ୍‌ ଏସ ଉଣା । ");
INSERT INTO kfcp_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ମିର୍‌ ଇନିକା ଇୟାସାନ୍ଧିବା ବୁଜାଦେଙ୍ଗ୍‌ ଆଟ୍‍ଇଜିନିଦେର୍‍ ? ୫,୦୦୦ ହାଜାର୍‌ ଲୋକାମାନୁ ନାନ୍ ପାସ୍‌ଗୋଟା ରୁଟିଙ୍ଗ୍‌ ବାଟାକିତିମାନି ମାଟା ଇନିକା ମିଙ୍ଗିଁ ଏତ୍‌ ସିଲେତ୍‍ ? ନାସ୍ତିୱାଲେ ଏସଗୋଟା ଡାଡ଼ିଆଙ୍ଗାଁ ବର୍ତିକିତିମାର୍‌ଇଦେର୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ମାରି ଆୟା ୪,୦୦୦ ହାଜାର୍‌ ଲୋକାଙ୍ଗ୍‌ ସାତଗଟା ରୁଟିଙ୍ଗ୍‌ ମାଟା ଏତ୍‌ ସିଲେତ୍‌ ? ନାସ୍ତିୱାଲେ ମିର୍‌ ଏସଗୋଟା ଡାଡ଼ିଆଙ୍ଗାଁ ବର୍ତିକିତିମାର୍‌ଇଦେର୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ନାନ୍ ଜେ ରୁଟିଙ୍ଗ୍‌ ବିସୟ୍‌ତାନ୍‌ ଇନ୍‌ଏନ୍‌ ମାର୍‌ଆ, ଇକା ଏଣ୍ତେସ୍‌ ବୁଜାଦେଙ୍ଗ୍‌ ଆଟ୍‍ଇଜିନିଦେର୍‍ ? ନାନ୍ ଇଜିନା, ପାରୁସି ନି ସାଦୁକିରି କମିର୍‌ଦାନ୍‌ ଜାଗାର୍‌ତାମାନ୍‌ଡ୍ରୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ନାସ୍ତିୱାଲେ ସିସୁର୍‍ ବୁଜାଦେଙ୍ଗ୍‌ ଆଟ୍‌ତାର୍‌ ଜେ ଜିସୁ ରୁଟିଦି କମିର୍‌ ମାଟା ଇନ୍‌ଏନ୍‌ମାର୍ହାନ୍‌, ମାତର୍‌ ପାରୁସି ନି ସାଦୁକିରି ସିକିୟା ଉଣ୍ତିଙ୍ଗ୍‌ ଜାଗାର୍‌ତା କିତାମାର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ୱେନ୍‌କା ଜିସୁ କାଇସରିୟା ପିଲିପି ଗାଡ଼୍‌ ଲାକ୍‌ତୁରି ରାଜିଦୁ ୱାଜି ନିଜେଦି ସିସୁରିଙ୍ଗ୍‌ ୱେନ୍‍ବାତାନ୍‌, “ମନୁସ୍ୟପୁତ୍ର ଏନ୍‌ ଇଜି ଇୟା ବିସୟ୍‌ତାନ୍‌ ଲୋକୁ ଇନିକା ଇଜିନାର୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ୱାର୍‌ ଇର୍ହାର୍‌, “ଏନ୍‌ ଏନ୍‌ ଇଜିନାର୍‌, ୱାନ୍‌ ଡୁବନ୍‌ସିନି ଯୋହନ, ଏନ୍‌ ଏନ୍‌ ଇଜିନାର୍‌ ‘ଏଲିୟ୍‌,’ ମାରି ଆଇକାର୍‌ ଇଜିନାର୍‌, ଜିରିମିୟ ସିଲିତିଙ୍ଗ୍‌ ବାବବାଦିରି ମାଣାନ୍‌ ଅରେନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ଜିସୁ ୱେନ୍‌ବାତାନ୍‌, “ନାନ୍ ଏନ୍‌ ଇୟା ବିସୟ୍‌ତାନ୍‌ ମିର୍‌ ଇନିକା ଇଜିନିଦେର୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ସିମୋନ ପିତର୍‌ ଇର୍ହାନ୍‌, “ନିନୁ କ୍ରିସ୍ତ ଅର୍ତାତ୍‍ ମସିହ, ଜିବନ୍‌ମାନି ମାପୁରୁଦି ମାରିନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ଜିସୁ ଇର୍ହାନ୍‌, “ଏ ଜୁନସ୍‍ତି ମାରିନ୍‌ ସିମୋନ, ନିନ୍‌ ଦନ୍ୟ !” ଇୟା ସତ୍‌ ନିନୁ ଆମା ଲୋକାମାଣାନ୍‌ ପୟ୍‌ଇ । ନା ମୁସ୍‌କୁପୁରୁତି ବୁବା ନିଜେ ଇକା ନିମାନୁ ୱେର୍‌ତାମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ବା ନିଙ୍ଗିଁ ଇଜିନା, ନିନୁ ପିତର ଅର୍ତାତ୍‍ ପିଡ଼ିପି । ମାତର୍‌ ଇୟା ମୁଲ୍‌ ପିଡ଼ିପି ମୁସ୍‌କୁ ନାନ୍ ନା ମଣ୍ତଲି ତିଆର୍‌କିନା । ଇୟାୱାଜାକି ସାନିୱାଜା ଇନି ଦଂସକିନି ସାକ୍ତି ତାନିଙ୍ଗ୍‌ ନାସ୍ଟୁ କିଦେଙ୍ଗ୍‌ ଆଟ୍‌ଏତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ନାନ୍ ନିଙ୍ଗିଁ ମୁସ୍‌କୁପୁର୍‌ତି କୁସିକାଣ୍ତି ସିନା, ମାରି ନିନ୍‌ ଦୁନିଆଦୁ ଆମାକା ବନ୍ଦକିନି, ମୁସ୍‌କୁପୁରୁତୁ ଆକା ବନ୍ଦତେବାନାତ୍‌, ମାରି ନିନ୍‌ ଦୁନିଆଦୁ ଆମାକା ଇନିକା ଡ଼ିସ୍‌ନିସିନି, ମୁସ୍‌କୁପୁରୁତୁ ଆକା ଡ଼ିସ୍‌ନି । ");
INSERT INTO kfcp_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ଜିସୁଙ୍ଗୁଁ ଜେ ମସିହ ଇଜି ଇକା ଏଙ୍ଗ୍‌ ଇନ୍‌ଇ ଉଣ୍ତିଙ୍ଗ୍‌ ୱାନ୍‌ ସିସୁରିଙ୍ଗ୍‌ ମାଟା ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ଆୟା ସମୟ୍‌ତାନ୍‌ ଜିସୁ ନିଜେଦି ସିସୁରିଙ୍ଗ୍‌ ନେସ୍‌ନିୱାଜା ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌, “ନାନ୍ ପୁରା ଜିରୁସାଲମ୍‌ତୁ ସନ୍‌ଡ୍ରେଙ୍ଗ୍ ଆନାତ୍‌ ମାରି ଦାର୍ମୁଜାଜକ, ଦାର୍ମୁଗୁରୁ ମାରି ନେତାର୍‌ରି, କିୟୁଦାନ୍‌ ନାଣ୍ତ ଦୁଃକ୍‌କାସ୍ଟୁବଗାଜି ସାଦେଙ୍ଗ୍‌ପଡ଼ାନାତ୍‌, ମାତର୍‌ ମୁନେଟି ୱେନ୍‌କା ମାରିଡ଼େସିଜିବନ୍‌ ଆଜିନିଙ୍ଗିଁନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ପିତର୍‌ ଜିସୁଙ୍ଗୁଁ ଉନ୍‌ଡ୍ରି ବାଡିଦୁ ଅତାନ୍‌ନୋ ବୁଦିୱେର୍‍ସି ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌, “ମାପୁରୁ କିମାକିନ୍‌, ପ୍ରବୁ, ନି ଉଣ୍ତିଙ୍ଗ୍‌ ଇୟାୱିଜୁ ଏସ୍‌କାଙ୍ଗ୍‌ବା ଗଟାମାକିତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ଜିସୁ ମାର୍‌ଜିବେସ୍‌ସି ପିତରତିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନା ଆଗ୍‍ଡ଼ିରାନ୍‍ ଆକ ସାଙ୍ଗ୍ଆ ସୟତାନ୍, ନିନୁ ନା ଉଣ୍ତିଙ୍ଗ୍‌ ଉନ୍‌ଡ୍ରିବାଦା, ଇରିଙ୍ଗ୍‌ ନିନୁ ମାପୁରୁଦି ବିସୟ୍‌ ଅଡ଼୍‍ବିଏଣ୍ତା ଲୋକା ବିସୟ୍‌ ଅଡ଼୍‌ବିଜିନି ।” ");
INSERT INTO kfcp_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ତାନେୱେନ୍‌କା ଜିସୁ ସିସୁରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଏନ୍‌ଆପିନ୍‌ ନାୱାଲେ ୱାଦେଙ୍ଗ୍‌ ବଦାକିନାନ୍‌, ଆର୍‌ତିଙ୍ଗ୍‌ ୱାନ୍‌ ନିଜେଦିଙ୍ଗ୍‌ ମାନାମାକିନି, ମାରି ନିଜେଦି କ୍ରୁସ ପିଣ୍ତିଜି ନା ୱେନ୍‌କା ୱେନ୍‌କା ବୁଲାଦେଙ୍ଗ୍‌ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ଇରିଙ୍ଗ୍‌ ଏନ୍‌ଆପିନ୍‌ ନିଜେଦି ଜିବନ୍‌ତିଙ୍ଗ୍‌ ରକିୟା କିଦେଙ୍ଗ୍‌ ବଦାକିନାନ୍‌, ୱାନ୍‌ ଆକା ଆରାକିନାନ୍‌, ମାତର୍‌ ଏନ୍‌ ନା ଉଣ୍ତିଙ୍ଗ୍‌ ନିଜେଦି ଜିବନ୍‌ତିଙ୍ଗ୍‌ ଆରାକିନାନ୍‌, ୱାନ୍‌ ଆକା ପଇନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ଜଦି ଅରେନ୍‌ ଲୋକୁ‌ ସାରାଦୁନିଆଦିଙ୍ଗ୍‌ ଜିଣାଜି, ମାତର୍‌ ନିଜେଦି ଜିବନ୍‌ତିଙ୍ଗ୍‌ ଆରାକିନାନ୍‌, ୱାନିଙ୍ଗ୍‌ ଇନି ଲାବ୍‌ଆନାତ୍‌ ? ଲୋକୁ ୱାନି ଜିବନ୍‍ତିଙ୍ଗ୍ ଡ଼େସି ପ‍ଇଦେଙ୍ଗ୍‌, ଇନିକା ସିଦେଙ୍ଗ୍‍ ଆଟ୍‍ନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ମନୁସ୍ୟପୁତ୍ର ବୁବା ମାପୁରୁଦି ମାଣାନ୍‌ ଗୌରବ୍‍ ନି ମୁସ୍‌କୁପୁର୍‌ତି ଦୁତ୍‌କାୱାଲେ ମାରିଡ଼େସି ୱାନାନ୍‌ । ନାସ୍ତିୱାଲେ ୱାନ୍‌ ୱିଜୁ ଲୋକାଙ୍ଗ୍‌ ୱାନି କିତିମାନି ପାଣି ଇସାବ୍‌ତାନ୍‌ ପଲ୍‌ସିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ମନୁସ୍ୟପୁତ୍ର ରାଜା ଆଜି ୱାନିସାନ୍ଦି ଇବେନୁ ନିର୍‌ଇ ତେବାତିମାନି ଏସୋଲୋକ୍‍ ଏଣ୍ତେସ୍‌ କିଜିବା ସାନିକା ୱେଡ୍‌ଏର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ସଅ ଦିନ୍‌ ୱେନ୍‌କା ଜିସୁ ପିତର୍‌ ମାରି ଜାକୁବ, ଯୋହନ ତଡ଼ରିଏରିଙ୍ଗ୍‌ ଅସି ଉନ୍‌ଡ୍ରି ପେରି ଗରନ୍‌ ମୁସ୍‌କୁ ସର୍ହାର୍‌ । ଆବେନୁ ଆଇକାନ୍‍ ଏନ୍‌ ସିଲେତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ସିସୁର୍‍ ସୁଡ଼୍‍ବୁ ସୁଡ଼୍‍ବୁ ଜିସୁଦି ଉନ୍‌ଡ୍ରି ମୁର୍ତି ବାଦେଲେଆଜି ଜାୟ୍‌ଆତାତ୍‌ । ୱାନି ମକମ୍‌ ୱେଡ଼ାୱାଜା ଜାୟ୍‌ଆତାତ୍‌ ମାରି ୱାନି ଆଙ୍ଗିଁ ଜାୟ୍‌ ୱାଜା ଅଡ଼ିନିକା ତରିତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ମୋଶା ନି ଏଲିୟ୍‌ ଜିସୁଦି ୱାଲେ ୱାର୍‌ଗିସାନିକା ସିସୁର୍‍ ସୁଡ଼ୁତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ଆବେନୁ ପିତର ଜିସୁଙ୍ଗୁଁ ଇର୍ହାନ୍‌, ଏ ପ୍ରବୁ, ଏସ ୱେଡ଼ିକାଦି ମାଟା, ମାଡ୍‌ ଇବେନୁ ମାନିକା । ନିନ୍‌ ଜଦି ବଦାକିନି, ଇବେନୁ ନାନ୍ ମୁନ୍‌ଡ୍ରି ଗୁଡ଼େଙ୍ଗ୍‌ ତିଆର୍‌କିନା । ନି ଉଣ୍ତିଙ୍ଗ୍‌ ଉନ୍‌ଡ୍ରି, ମୋସାଦି ଉଣ୍ତିଙ୍ଗ୍‌ ଉନ୍‌ଡ୍ରି ମାରି ଏଲିୟ୍‌ଦି ଉଣ୍ତିଙ୍ଗ୍‌ ଉନ୍‌ଡ୍ରି । ");
INSERT INTO kfcp_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ପିତର୍‌ ଇୟା ମାଟା ଇନିୱାଲେ ଖାଣ୍ତେକ୍‍ ବାଦଡ଼୍‍ ଇମ୍‌ଜି ୱାତା ଦୋ ୱାରିଙ୍ଗ୍‌ ବାଦଡ଼୍‍ତି ନିଡ଼୍‍ଗା ପିଡ଼ିକ୍‍ତାତ୍‍ ମାରି ଆବେଟ୍‌ତାନ୍‌ ଉନ୍‌ଡ୍ରି ବଲ୍ ୱାତାତ୍‍, “ଇୟାକାନ୍‌ ନା ଲାଡ୍‍ତି ମାରିନ୍‌, ୱେନିମାନୁ ନାନ୍ ନାଣ୍ତ ୱେଡ଼ିକା । ୱେନି ବାକ୍ୟ ୱେନ୍‌ଡ୍ରୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ସିସୁର୍‍ ଆୟା ବଲ୍ ୱେର୍‌ରାନୋ ନିସ ତିଲାତାର୍‌ ଜେ ୱାର୍‌ ବୁମିଦୁ ମକମ୍‌ପାଡ଼୍‌କିସି ମେଡ଼େତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ଜିସୁ ୱାରି ଲାକ୍‌ତୁ ୱାଜି ୱାରିଙ୍ଗ୍‌ ମୁଟ୍‌ତାନ୍‌ନୋ ଇର୍ହାନ୍‌, “ନିଙ୍ଗିଁଦୁ ତିଲାମାଟ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ମାରି, ୱାର୍‌ ମୁସ୍‌କୁ ବେସ୍‍ସି କେବଲ୍‌ ଜିସୁଙ୍ଗୁଁ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ମାରି ଏଙ୍ଗ୍‌ବା ସୁଡ଼ୁଏତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ୱାର୍‌ ଗରନ୍‌ତାନ୍‌ ରେତାଜି ୱାନିୱାଲେ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଆଦେସ୍‌ ସିଜି ଇର୍ହାନ୍‌, “ମନୁସ୍ୟପୁତ୍ର ସାତିମାଣାନ୍‌ ମାରିଡ଼େସିଜିବନ୍‌ ଆଇସାନ୍ଦି ଇୟା ମିର୍‌ ସୁଡ଼୍‍ତିମାଟା ଏଙ୍ଗ୍‌ବା ଇନ୍‌ମାଟ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ସିସୁର୍‍ ଜିସୁଙ୍ଗୁଁ ୱେନ୍‌ବାତାର୍‌, ଏଲିୟ୍‌ ଆଗ୍‌ଡ଼ି ୱାନାନ୍‌ ଇଜି ମା ସାସ୍ତ୍ରିର୍‍ ଏନ୍ଦା ଇର୍ହାମାନାର୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ଜିସୁ ଇର୍ହାନ୍‌, ହୁଁ, ଏଲିୟ୍‌ ଆଗ୍‌ଡ଼ି ୱାଜି ୱିଜୁ ବିସୟ୍‌ ମାରିଡ଼େସି ତିଆର୍‌କିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ମାତର୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, “ଏଲିୟ୍‌ ୱାତାୱିସ୍‌ତାନ୍‌ନି ମାରି ୱାନିଙ୍ଗ୍‌ ସିନିସ୍‌କିଏଣ୍‌ଗା ଲୋକୁ ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ଆମାକା ବଦା, ଆୟାକା କିତାମାନାର୍‍ । ମନୁସ୍ୟପୁତ୍ରଦି ଉଣ୍ତିଙ୍ଗ୍‌ ବା ୱାର୍‌ ଆୟାୱାଜା ତାଗ୍‌ଇପାଣି କିନାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ନାସ୍ତିୱାଲେ ସିସୁର୍‍ ବୁଜାଦେଙ୍ଗ୍‌ ଆଟ୍‌ତାର୍‌ ଜେ, ଜିସୁ ଡୁବନ୍‌ସିନି ଯୋହନତି ବିସୟ୍‌ତାନ୍‌ ୱେର୍‌ସିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ଜିସୁ ନି ୱାନି ସିସୁର୍‍ ଲୋକା ଗଲି ଲୋଇ ଡ଼େସି ୱାତି ୱେନ୍‌କା ଅରେନ୍‍ ଲୋକୁ ଜିସୁ ଲାକ୍‌ତୁ ୱାଜି ମେଣ୍ତେଙ୍ଗ୍‌ ଗଟ୍‌କିଜି ଇର୍ହାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ଏ ପ୍ରବୁ, ନା ମାରିନ୍‌ତିଙ୍ଗ୍‌ ଦୟା କିଆ, ମୁର୍ଛାରୋଗ୍‌ତୁ ନାଣ୍ତ କାସ୍ଟୁ ପୟଜିନାନ୍‍ ମାରି ୱାନ୍‌ ଏସ ଦେବେଙ୍ଗ୍‌ ସିସୁଦୁ ନି ଏର୍‌ତୁ ଆର୍‌ନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ନାନ୍ ନି ସିସୁରି ଲାକ୍‌ତୁ ୱାନିଙ୍ଗ୍‌ ତାତାମାର୍‌ଆ, ମାତର୍‌ ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ନେଗେନ୍‌ କିଦେଙ୍ଗ୍‌ ଆଟ୍‌ଏତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ଜିସୁ ଇର୍ହାନ୍‌, “ଏ ଅବିସ୍‍ବାସ୍‍ ନି ବାୟାର୍ ମିର୍‌ ! ମି ୱାଲେ ନାନ୍ ମାରିଏସ ଦିନ୍‌ ତେବାନା ? ମାରି ଏସ ଦିନ୍‌ ମି ବ୍ୟବହାର୍‌ ସାସ୍‌କିନା ? ଆୟା କଡ଼ଦିଙ୍ଗ୍‌ ନା ଲାକ୍‌ତୁ ତାଗାଟ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","କଡ଼ ଲୋଇମାନି ଦୁବାଦିଙ୍ଗ୍‌ ଜିସୁ ଆଦ୍‌ରିସ୍‌ କିତାନ୍‌ । ଦୁବା ୱାନିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ସି ସତାସର୍ହାତ୍‌ ମାରି ଆୟା ଦାର୍ପେନେ କଡ଼ ନେଗେନ୍‌ଆତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ତାନେୱେନ୍‌କା ସିସୁର୍‍ ଜିସୁଙ୍ଗୁଁ ଅରେନ୍‌ୱାନିଙ୍ଗ୍‌ନେ ୱାଜି ୱେନ୍‌ବାତାର୍‌, “ମାପ୍‌ ଏନ୍ଦା ଆୟା ଦୁବାଦିଙ୍ଗ୍‌ ପେର୍‍ଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏତାପ୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ଜିସୁ ଇର୍ହାନ୍‌, “ମି ବିସ୍‌ବାସ୍‌ ପୁରା ଉଣା । ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ଜଦି ଉନ୍‌ଡ୍ରି ସାର୍‍ସୁ ପାଡ଼ୁ ୱାଜା ମି ବିସ୍‌ବାସ୍‌ ମାନାତ୍‌, ଇୟା ଗରନ୍‌ତିଙ୍ଗ୍‌ ଇବେଟ୍‌ତାନ୍‌ ଆବେନୁ ଗୁସାଜସାଙ୍ଗାଆ ଇଜି ଇରିଙ୍ଗ୍‌, ଆକା ଗୁସାନାତ୍‌ । ବିସ୍‌ବାସ୍‌ତି ଡାଟ୍‌ତାନ୍‌ ମିର୍‌ ୱିଜୁ କିଦେଙ୍ଗ୍‌ ଆଟ୍‌ନିଦେର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ମାତର୍‌ ପାର୍‌ତନା ନି ଉପବାସ୍‌ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ଆଇକା ଇନି ଉପାୟ୍‌ତାନ୍‌ ଇୟାୱାଜା ଦୁବା ସୋହସ ସଲ୍‌ଏତେ । ");
INSERT INTO kfcp_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ସିସୁର୍‍ ୱିଜେରେ ଗାଲିଲିଦୁ ଉନ୍‌ଡ୍ରେମାନୁ ଆତି ୱେନ୍‌କା ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମନୁସ୍ୟପୁତ୍ର ଲୋକା କିୟୁଦୁ ସର୍ପେ ଆଦେଙ୍ଗ୍‌ ସଲ୍‌ସିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଡାକ୍‌ନାର୍‌, ମାତର୍‌ ମୁନେଟି ୱେନ୍‌କା ୱାନ୍‌ ମାରିଡ଼େସିଜିବନ୍‌ ଆନାନ୍‌ ।” ଆବେଟ୍‌କୁ ସିସୁର୍‍ ନାଣ୍ତ ଦୁକ୍‍ ଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ତାନେୱେନ୍‌କା ଜିସୁ ନି ୱାନି ସିସୁର୍‍ କପର୍‍ନାହୁମ୍‍ତୁ ୱାତାର୍‌, ମନ୍ଦିର୍‌ତି ସିସୁଟୁଲୋସ୍‌ନିକାର୍‌ ପିତରତି ଲାକ୍‌ତୁ ୱାଜି ୱେନ୍‌ବାତାର୍‌, “ମି ଗୁରୁ ଇନିକା ମନ୍ଦିର୍‌ତି ସିସୁଟୁ ସିଏନ୍‌ ନୋ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ପିତର୍‌ ଇର୍ହାନ୍‌, “ହୁଁ, ସିନାନ୍‌ ।” ପିତର୍‌ ଇନ୍‌ଡ୍ର ୱାତି ୱେନ୍‌କା ଜିସୁ ଆଗ୍‌ଡ଼ି ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ସିମୋନ, ନିନ୍‌ ଇନିକା ଅଡ଼୍‍ବିଜିନି ? ଇୟା ଦୁନିଆଦି ରାଜାରିଙ୍ଗ୍‌ ଏନ୍‌ ସିସୁଟୁଡାବୁଙ୍ଗ୍‌ ସିନାନ୍‌ ୱାରି ଦେସ୍‌ତି ପ୍ରଜାରି ମାଣ୍‌କୁ ନୋ ଆଇଦେସ୍‌ତିୱାରି ମାଣ୍‌କୁ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ପିତର୍‌ ଇର୍ହାନ୍‌, “ଆଇଦେସ୍‌ତିୱାରି ମାଣ୍‌କୁ ।” ଜିସୁ ଇର୍ହାନ୍‌, “ଆର୍‌ତିଙ୍ଗ୍‌ ଦେସ୍‌ତି ପ୍ରଜାର୍‌ ସିସୁଟୁତର୍‌ନି ବଜୁତାନ୍‍ ଉସାସ୍‌ଆନାର୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ମାତର୍‌ ମାପ୍‌ ଇଲେଇ ୱାରିଙ୍ଗ୍‌ ଅପ୍‍ମାନ୍‍ କିଦେଙ୍ଗ୍‌ ଅଡ଼୍‌ବିଏପ୍‌ । ମିର୍‌ ଗାଡାଦୁ ସୋଲ୍‌ସ ବଣସି ପୋକ୍‌ତୁ । ଆଗ୍‌ଡ଼ି ଆମା ମିନି ୱାନାତ୍‌, ତାନି ୱେୟୁଦାନ୍‌ ଉନ୍‌ଡ୍ରି ୱେନ୍‌ଣ୍ତିଦି ଅଦ୍‌ଲି ପଇନିଦେର୍‌ । ଆକା ଅସ ନା ଉଣ୍ତିଙ୍ଗ୍‌ ନି ମି ଉଣ୍ତିଙ୍ଗ୍‌ ମନ୍ଦିର୍‌ତି ସିସୁଟୁଡାବୁଙ୍ଗ୍‌ ସିଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ନାସ୍ତିୱାଲେ ସିସୁର୍‍ ଜିସୁଦି ଲାକ୍‌ତୁ ୱାତା ୱେନ୍‌ବାତାର୍‌, “ମୁସ୍‌କୁପୁର୍‌ତି ରାଜିଦୁ ୱିଜେରିମାଣାନ୍‌ ଏନ୍‌ ପେରିକାନ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ଜିସୁ ଅରେନ୍‍ ଇସ୍ରି କଡ଼ଦିଙ୍ଗ୍‌ ୱାରି ଆଗ୍‌ଡ଼ି ନିଲପ୍‌ତାନ୍‌ନୋ ଇର୍ହାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ମିର୍‌ ଇସ୍ରିକଡ଼ୱାଜା ବାଦ୍‍ଲିଆଏତିଙ୍ଗ୍‌ ଏସାଙ୍ଗ୍‍ବା ମୁସ୍‌କୁପୁର୍‌ତି ରାଜିଦୁ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଆଟ୍‍ଇଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ମାରି, ଏନ୍‌ ଇୟା ଇସ୍ରି କଡ଼ଦି ୱାଜା ନିଜେଦିଙ୍ଗ୍‌ ନମ୍ର ଆନାନ୍‌, ୱାନ୍‌ ମୁସ୍‌କୁପୁର୍‌ତି ରାଜିଦୁ ୱିଜେରିଙ୍ଗ୍‌ ପେରିକାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ମାରି, ଏନ୍‌ଆପିନ୍‌ ନା ଦର୍‌ତାନ୍‌ ଇୟାୱାଜା ଅରେନ୍‍ ଇସ୍ରି କଡ଼ଦିଙ୍ଗ୍‌ ମାନାନାର୍‌, ୱାନ୍‌ ନାଙ୍ଗିଁ ବା ମାନାନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","ମାତର୍‌ ଏନ୍‌ଆପିନ୍‌ ନାମାନୁ ବିସ୍‍ବାସ୍‍ କିଜିମାନି ଇୟା ଇସ୍ରିକଡ଼ରି ମାଣ୍‌କୁ ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ଏର୍‌ପେନାନ୍‌, ୱାନି କକ୍‌ଲାଦୁ ଉନ୍‌ଡ୍ରି ପେରି ଜାତାକାଲୁ ତର୍‌ସୋ ୱାନିଙ୍ଗ୍‌ ସାମ୍‌ଦୁର୍‌ତି ନାଣ୍ତଗୁମିମାନି ଏର୍‌ତୁ ପୋକ୍‌ତିଙ୍ଗ୍‌ ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ନେଗେନ୍‌ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ଲୋକାଦି ବିସ୍‌ବାସ୍‌ତୁ ଏର୍‌ପେନି ଉଣ୍ତିଙ୍ଗ୍‌ ଗାଦି ମାଟେଙ୍ଗ୍‌ମାନେ । ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ଇୟା ଦୁନିଆଦି ଅବସ୍ତା ନିସ ତିଲାନିକା । ୱିଜୁୱାଲେ ଇୟାୱାଜା ଆର୍‍ପ୍‍ନିକା ୱାନାତ୍‌, ମାତର୍‌ ଏନ୍‌ ଏର୍‌ପିନିକା ଗଟାକିନାନ୍‌, ୱାନି ଦସ୍‌ ଏସା ପେରିକାଆନାତ୍‍ ! ");
INSERT INTO kfcp_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","ଜଦି ମି କିୟୁ ନି ପାଦାମ୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ମିର୍‌ ବିସ୍‍ବାସ୍‍ ଆରାକିନିଦେର୍‌, ଆର୍‌ତିଙ୍ଗ୍‌ ଆକା କୟ୍‌ଜ ପୋକ୍‌ତୁ । ରୁଣ୍ତି କିକୁ ନି ରୁଣ୍ତି ପାଦାମ୍‌କୁ ମାନ୍‌ଞ୍ଜି ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜିଇ ସିସୁଦୁ ପୋକାନି ବାଦୁଲୁ ଉନ୍‌ଡ୍ରି କିୟୁ ନି ଉନ୍‌ଡ୍ରେ ପାଦାମ୍‌ ସିଲେଣ୍‌ଗା ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜିଇ ଜିବନ୍‌ତୁ ଡ଼ୁଗୁନିକା ମି ଉଣ୍ତିଙ୍ଗ୍‌ ନେଗେତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ମାରି, ମି କାଣ୍‌ଗା ଉଣ୍ତିଙ୍ଗ୍‌ ଜଦି ମି ବିସ୍‍ବାସ୍‍ ନାଷ୍ଟୁ ଆଜିନାତ୍‍, ତାନିଙ୍ଗ୍‌ ଉଦୁଜ ପୋକ୍‌ତୁ । ରୁଣ୍ତି କାଣୁକୁ ମାନ୍‌ଞ୍ଜି ସିସୁକାସ୍‌ନି ନରକଦୁ ପୋକାନି ବାଦୁଲୁ ଉନ୍‌ଡ୍ରି କାଣ୍‌ଗା ଅସି ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜ୍‌ଇ ଜିବନ୍‌ତୁ ଡ଼ୁଗୁନିକା ମି ଉଣ୍ତିଙ୍ଗ୍‌ ନେଗେତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","ଇୟା ଇସ୍ରିକଡ଼ରି ମାଣ୍‌କୁ ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ବା ନିସାର୍‍ କିମାଟ୍‌ । ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ଇୟାୱାରିଙ୍ଗ୍‌ ଜାତୁନ୍‌କିଜିମାନି ମୁସ୍‌କୁପୁର୍‌ତି ଦୁତ୍‌କୁ ୱିଜୁଦିନ୍‌ ନା ବୁବା ମାପୁରୁଦି ଲାକ୍‌ତୁମାନେ । ");
INSERT INTO kfcp_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","ଇରିଙ୍ଗ୍‌ ସାରିବାଣାତିମାନି ଲୋକାଙ୍ଗ୍‌ ରକ୍‌ୟା କିଦେଙ୍ଗ୍‌ ମନୁସ୍ୟପୁତ୍ର ୱାତାମାନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ମିର୍‌ ଇନିକା ଅଡ଼୍‍ବିଜିନିଦେର୍‍, ଜଦି ଅରେନ୍‍ ଲୋକାୱି ୧୦୦ ଗୋଟା ମେଣ୍ତେଙ୍ଗ୍‌ମାନେ ମାରି ଆବେଣୁକୁ ଉନ୍‌ଡ୍ରି ମୁରୁନାତ୍‌, ଆର୍‌ତିଙ୍ଗ୍‌ ୱାନ୍‌ ଇନିକା କିନାନ୍‌ ? ନବେ ନଅଗୋଟା ମେଣ୍ତେଙ୍ଗାଁ ଗରନ୍‌ ଲାକ୍‌ତୁ ସାରାଦେଙ୍ଗ୍‌ ଡ଼ିସ୍‌ନାସିନାନ୍‌ନୋ ଆୟା ମୁରିତିମାନି ମେଣ୍ତାଦିଙ୍ଗ୍‌ ପୟ୍‌ଦେଙ୍ଗ୍‌ସୋନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ଏସ୍ତିୱାଲେ ୱାନ୍‌ ମେଣ୍ତାଦିଙ୍ଗ୍‌ ପୟ୍‌ନାନ୍‌, ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ମୁରୁଇତିମାନି ନବେ ନଅଗୋଟା ମେଣ୍ତେଙ୍ଗାଁ ଉଣ୍ତିଙ୍ଗ୍‌ ୱାନି ଏସ ୱେଡ଼ିକା, ଇୟା ଉନ୍‌ଡ୍ରେ ମେଣ୍ତାଦି ଉଣ୍ତିଙ୍ଗ୍‌ ୱାନିକାମାଣାନ୍‌ ନାଣ୍ତ ୱେଡ଼ିକାଆନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ଟିକ୍‌ ଆୟାୱାଜା, ଇୟା ଇସ୍ରିକଡ଼୍‍ରି ମାଣ୍‌କୁ ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ବା ସାରିବାଣାପିନ୍‌, ଇକା ମି ମୁସ୍‌କୁପୁରୁତି ବୁବା ମାପୁରୁଦି ବଦା ସିଲେତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ଅରେନ୍‍ ତଡ଼ାନ୍‌ ଜଦି ମି ବିରଦ୍‌ତାନ୍‌ ଇନି ଦସ୍‌ କିନାନ୍‌, ୱାନି ଲାକ୍‌ତୁ ସୋଲ୍‌ସ ୱାନି ଦସ୍‌ ୱାନିଙ୍ଗ୍‌ ତର୍‌ସସିଦୁ । ମାତର୍‌ ମିର୍‌ ରିଇଦେର୍‌ ଅରେନ୍‌ନେ ମାନିୱାଲେ ଇକା ନେସ୍‌ଇୱାଜା କିଦୁ । ଜଦି ୱାନ୍‌ ମି ମାଟା ୱେନାନ୍‌, ନି ତଡ଼ାନ୍‌ତିଙ୍ଗ୍‌ ନିନ୍‌ ଡ଼େସି ପଇନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ଜଦି ୱାନ୍‌ ୱେନ୍‌ଏନ୍‌, ଅରେନ୍‍ ସିଲ୍‍ତିଙ୍ଗ୍‍ ରିଏରିଙ୍ଗ୍‌ ଆସ୍‌ସୋ ୱାନି ଲାକ୍‌ତୁସାନ୍‌ଡ୍ରୁ । ମା ସାସ୍ତ୍ରଦି ଇସାବ୍‌ତାନ୍‌, “ରିଏର୍‌ ସିଲ୍‍ତିଙ୍ଗ୍‍ ମୁଏରିଙ୍ଗ୍‍ଁ ସାକିଦି ଆଗ୍‌ଡ଼ି ମି ୱିଜୁ ଦାବି ସତ୍‌ ଇଜି ପାରାମାଣ୍‌ ଆପିତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ଜଦି ୱାନ୍‌ ମି ମାଟା ମାନାଏନ୍‌, ଆର୍‌ତିଙ୍ଗ୍‌ ଇୟା ବିସୟ୍‌ତାନ୍‌ ପାର୍‌ତନା ମଣ୍ତଲିଦିଙ୍ଗ୍‌ ୱେର୍‍ତୁ, ସାରାସାରିୱେନ୍‌କା, ଜଦି ୱାନ୍‌ ମଣ୍ତଲି ମାଟା ବା ମାନାଏନ୍‌, ଆର୍‌ତିଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ ଅରେନ୍‍ ସିସ୍‍ଟୁ ଡାବୁଙ୍ଗ୍‌ ଲୋସ୍‌ନିକାନ୍‌ ସିଲ୍‍ତିଙ୍ଗ୍‍ ଅରେନ୍‍ ଅବିସ୍‍ବାସ୍‍ସି ଇଜି ଅଡ଼୍‌ବିଜ ୱାନିୱାଲେ ମିସାବିଡ଼ାଆମାଟ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ମିର୍‌ ଇୟା ଦୁନିଆଦୁ ଆମାକା ବନ୍ଦ୍‌କିନିଦେର୍‌, ମୁସ୍‌କୁପୁର୍‌ତୁ ବା ଆକା ବନ୍ଦ୍‌ତେବାନାତ୍‌ ମାରି ଆମାୱାନିଙ୍ଗ୍‌ ମିର୍‌ ଦୁନିଆଦୁ ସାରିସିନିଦେର୍‌, ମୁସ୍‌କୁପୁର୍‌ତୁ ବା ଆକା ସାରିସିଆୟ୍‌ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“ମାରି ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ଦୁନିଆଦୁ ଏସ୍ତିୱାଲେ ମି ଲୋଇରାନ୍‌ ରିଇଦେର୍‌ ଜେ ଏଣ୍ତେସ୍‌ ନାନି ବିସୟ୍‌ତାନ୍‌ ଉନ୍‌ଡ୍ରେମନ୍‌ଆଜି ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ପାର୍‌ତନାକିନିଦେର୍‌, ନା ମୁସ୍‌କୁପୁର୍‌ତି ବୁବା ମି ଆୟା ବଦାପୁରାକିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ଇରିଙ୍ଗ୍‌ ଏମେ ବାଡିଦୁ ରିଏର୍‌ ଲୋକ୍ ସିଲ୍‍ତିଙ୍ଗ୍‍ ମୁଏର୍‌ ଲୋକ୍ ନା ଦର୍‌ତାନ୍‌ ଉନ୍‌ଡ୍ରେମାନୁ ଉଣ୍ତାନାର୍‌, ଆୟା ବାଡିଦୁ ନାନ୍ ୱାରିମାନୁ ମାନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ଅର୍‍ଲେନ୍‍ ପିତର୍‌ ୱାତାନ୍‌ନୋ ଜିସୁଙ୍ଗୁଁ ୱେନ୍‌ବାତାନ୍‌, “ପ୍ରବୁ, ଅରେନ୍‍ ତଡ଼ାନ୍‌ ନା ବିରଦ୍‌ତାନ୍‌ ବାର୍‌ବାର୍‌ ଦସ୍‌ କିଜିମାର୍ହାନ୍‌, ୱାନିଙ୍ଗ୍‌ ନାନ୍ ଏସ ଦେବେଙ୍ଗ୍‌ କେମାକିନା ? ଇନିକା ସାତ୍‌ଦେବେଙ୍ଗ୍‌ ସାନ୍ଦି ?” ");
INSERT INTO kfcp_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ଜିସୁ ଇର୍ହାନ୍‌, “ସିଲେ ସାତ୍‌ଦେବେଙ୍ଗ୍‌ ସିଲେ ।” ମାତର୍‌ ସାତ୍‌ଦେବେଙ୍ଗ୍‌ ସତୁରି ଗୁଣୁ ସାନ୍ଦି । ");
INSERT INTO kfcp_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ଇରିଙ୍ଗ୍‌ ମୁସ୍‌କୁପୁର୍‌ ଇୟାୱାଜା । ଅର୍‍ଲେନ୍‍ ଅରେନ୍‍ ରାଜା ପାଣିକିନିୱାରି ଇସାବ୍‌ଆକୁ ସୁଡ଼ୁଦେଙ୍ଗ୍‌ ଇଜି ବଦାକିତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ୱାନ୍‌ ଇୟା ଇସାବ୍‌ ଆରାମ୍‌ କିତିୱାଲେ ଲକେ ଡାବୁଙ୍ଗୁଁ ଅତି ଅରେନ୍‍ ପାଣିକିନିୱାନିଙ୍ଗ୍‌ ରାଜାଦି ଲାକ୍‌ତୁ ତାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ରୁଣୁ ତେୱ୍‌ନି ଉଣ୍ତିଙ୍ଗ୍‌ ଇୟା ଲୋକ୍‌ତିମାନୁ ଇନିକା ସିଲେତିଙ୍ଗ୍‍ ୱାନି ମାଲିକ୍‍ ୱାନିଙ୍ଗ୍‌ ମାରି ୱାନି ଆଡ଼୍‌ସିଙ୍ଗ୍‌, କଡ଼କକ୍‌ରା ମାରି ୱିଜୁ ସମ୍ପତ୍ତି ପୋର୍‌ଜ ରୁଣ୍‌ଡାବୁଙ୍ଗ୍‌ ଅତେଙ୍ଗ୍‌ ଆଦେସ୍‌ ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ସାକର୍‌ ରାଜାଦି କାଲ୍‌କା ଆଡ୍‍ଗି ପାଡ଼ିଗିଜି ମାଡ଼ିସ୍‍କିଜି ଇର୍ହାନ୍‌, “ଆଜ୍ଞା ମାରି ଅଡ଼ପ୍‍ ସାସ୍‌ ଆସ୍‌ଆ ନାନ୍ ନି ୱିଜୁ ରୁଣ୍‌ଡାବୁଙ୍ଗ୍‌ ତେୱେନାସିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ମାଲିକ୍‍ଦି ମନ୍‌ତୁ ଦୟା ଆତାତ୍‌, ଆବେଟ୍‌ ରୁଣ୍‌ଡାବୁଙ୍ଗ୍‌ତାନ୍‌ କେମାସିଜି ୱାନ୍‌ ସାକର୍‌ତିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ତାସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","ଇୟା ଲୋକୁ ବୁଲାଜି ସନିୱାଲେ ୱାନିମାଣାନ୍‌ ଉଣା ଏସ ଡାବୁଙ୍ଗୁଁ ରୁଣୁ ଅତିମାନି ୱାନି ଅରେନ୍‍ ଅର୍‍ସେପାଣିକିନି ସାକର୍‌ତିଙ୍ଗ୍‌ ବେଟ୍‌ବୁଡ଼ାତାନ୍‌ । ୱାନ୍‌ ୱାନି କକ୍‌ଲାଦିଙ୍ଗ୍‌ ଆସ୍‌ସି, ୱାନି କକ୍‌ଲାଦିଙ୍ଗ୍‌ ପିଡ଼ିସି ଇର୍ହାନ୍‌, ନା ମାଣାନ୍‌ ଉଦାର୍‌ ଅତିମାନି ଡାବୁଙ୍ଗୁଁ ଡ଼େସି ସିଦା । ");
INSERT INTO kfcp_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ୱାନିୱାଲେ ଅର୍‌ସେ ପାଣିକିକାନ୍‍ ୱାନି କାଲ୍‌କା ଆଡ୍‍ଗି ପାଡ଼ିଗିଜି ମାଡ଼ିସ୍‍କିଜି ଇର୍ହାନ୍‌, ସାସ୍‌ ଆସ୍‌ଆ, ନି ୱିଜୁ ଡାବୁଙ୍ଗୁଁ ତେୱେନାସିନା । ");
INSERT INTO kfcp_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ମାତର୍‌ ପାର୍‍ତୁମ୍‍ତି ଲୋକୁ ୱାନି ଗୁଆରି ୱେନ୍‌ଏତାନ୍‌, ମାରି ରୁଣ୍‌ଡାବୁଙ୍ଗ୍‌ ତେୱେଇ ସାନ୍ଦି ୱାନିଙ୍ଗ୍‌ ଜଇଲ୍‌ତୁ ଇଡିସ୍‌କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ଇୟା ଗଟ୍‌ନା ସୁଡ଼ୁଜି ଆଇ ଅର୍‌ସେପାଣିକିନିକାର୍‌ ନାଣ୍ତ ଦୁକ୍‍ଆତାର୍‌ । ୱାର୍‌ ରାଜାଦି ଲାକ୍‌ତୁ ସର୍ହାର୍‌ନୋ ଆମାକା ଗଟାତା ମାର୍ହାତ୍‌, ୱିଜୁ ୱେର୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ରାଜା ପାର୍‍ତୁମ୍‍ତି ପାଣିକିନିୱାନିଙ୍ଗ୍‌ କୁକିସ୍‌କିତାନ୍‌ନୋ ଇର୍ହାନ୍‌, ଏ ଜଗ୍‌ସିଲି ପାଣିକିନିକିନ୍ଦା, ନିନ୍‌ ଗୁଆରି କିତିଆକା ନାନ୍ ନି ୱିଜୁ ରୁଣ୍‌ଡାବୁଙ୍ଗ୍‌ ଡ଼ିସ୍‌ତାସିତା । ");
INSERT INTO kfcp_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ନାନ୍ ଏଣ୍ତେସ୍‌ ନି ଉଣ୍ତିଙ୍ଗ୍‌ ଦୟା ତର୍‌ତା, ନି ଅର୍‍ସେପାଣି କିନିୱାନିଙ୍ଗ୍‌ ବା ଆୟାୱାଜା ଦୟା କିନିକା ନି ଟିକ୍‌ ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“ରାଜା ନାଣ୍ତ ରିସାଆତାନ୍‍ ମାରି ୱିଜୁ ରୁଣ୍‌ଡାବୁଙ୍ଗ୍‌ ଡ଼େସିସିଇ ସାନ୍ଦି ଦଣ୍ତ୍‌ବଗାନି ଉଣ୍ତିଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ ଜଇଲ୍‌ତୁ ପୋକ୍‌ତାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ଜିସୁ ୱିଜୁ ମାଟା ୱିସ୍‌ତାନ୍‌ନୋ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମି ବିରଦ୍‌ତାନ୍‌ ଦସ୍‌ କିତିମାନି ତଡ଼ାନ୍‍ତିଙ୍ଗ୍‌ ଜିବନ୍‌ନୋନିୱାଜା ଜଦି କେମାକିଇଦେର୍‌, ଆର୍‌ତିଙ୍ଗ୍‌ ନା ମୁସ୍‌କୁପୁର୍‌ତି ବୁବା ବା ମି ଉଣ୍ତିଙ୍ଗ୍‌ ଇୟାୱାଜା ବ୍ୟବହାର୍‌ କିନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ଜିସୁ ଇୟାୱିଜୁ ମାଟା ୱେର୍‌ତି ୱିସ୍‌ତି ୱେନ୍‌କା ଗାଲିଲି ଡ଼ିସ୍‌ସି ଜର୍ଦନ ଗାଡାଦି ଆୟାପାଡ଼୍‌କା ମାନି ଜିହୁଦା ରାଜିଦୁ ସୋର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ମାରି, ନାଣ୍ତ ଲୋକୁ ୱାନି ୱେନ୍‌କା ୱେନ୍‌କା ସୋର୍ହାର୍‌ ମାରି ୱାନ୍‌ ଗାଦି ରଗ୍‌ଲୋକାଙ୍ଗ୍‌ ନେଗେନ୍‌କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ଏସଲୋକ୍‌ ପାରୁସିର୍‌ ୱାନି ଲାକ୍‌ତୁ ୱାତାରୋ ୱାନିଙ୍ଗ୍‌ ଗୁଟାଦୁ ଆର୍‌ପ୍‌ତେଙ୍ଗ୍‌ ସେସ୍ଟାକିତାର୍‌ । ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, “ମସାଦି ନିୟମ୍‌ ଇସାବ୍‌ତାନ୍‌ ଅରେନ୍‍ ଇନି ବିସୟ୍‌ତାନ୍‌ ନିଜେଦି ଆଡ଼୍‌ସିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ନିଆକୁ ସିଦେଙ୍ଗ୍‍ ଆଟ୍‍ନାନ୍‍ ନୋ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ଜିସୁ ଇର୍ହାନ୍‌, ମିର୍‌ ଇନିକା ସାସ୍ତ୍ରଦୁ ପଡ଼ାଇଦେର୍‌ ନୋ, ତିଆର୍‌କିତିମାଲିକ୍‌ ଆଗ୍‍ଡ଼ିରାନ୍‍ନେ ୱାରିଙ୍ଗ୍‌ ମେମାରି ନି ଆଇମା କିଜି ତିଆର୍‌ କିତାନ୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ନାସ୍ତିୱାଲେ ମାପୁରୁ ଇର୍ହାମାର୍ହାନ୍‌, “ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ଅରେନ୍‌ ମେମାର୍‌ଏନ୍‌ ନିଜେଦି ବୁବାୟାୟେଙ୍ଗ୍‌ ଡ଼ିସ୍‌ସି ନିଜେଦି ଆଡ଼୍‌ସି ୱାଲେ ତେବାନାନ୍‌ ମାରି ଆୟା ରିଏର୍‌ ଅରେନ୍‌ଆନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ୱାର୍‌ ମାରି ରିଏର୍‌ ଆଏର୍‌, ମାତର୍‌ ଅରେନ୍‌ନେ । ଆମାୱାରିଙ୍ଗ୍‌ ମାପୁରୁ ମିସାକିତାମାନାନ୍‌, ଆକା ଲୋକୁ ୱାରିଙ୍ଗ୍‌ ୱେରେଏ କିମାକିର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ପାରୁସିର୍‌ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, “ଆର୍‌ତିଙ୍ଗ୍‌ ଆଇମାଦିଙ୍ଗ୍‍ ଡ଼ିସ୍‌ନି ଆକୁ ସିଜି ଡ଼ିସ୍‌ନି ଉଣ୍ତିଙ୍ଗ୍‌ ମୋସା ଏନ୍ଦା ନିୟମ୍‌ କିତାମାନାନ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମି ଜିବନ୍‍ତି ଆଟୁୱାଦିଙ୍ଗ୍‍ ସୁଡ଼୍‌ଜି ମୋସା ମିଙ୍ଗିଁ ଇୟାୱାଜା କିତାମାର୍ହାନ୍‌ । ମାତର୍‌ ତିଆର୍‌ଆତି ଆଗ୍‌ଡ଼ି ଇୟାୱାଜା ନିୟମ୍‌ ସିଲେତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ମାତର୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ଏନ୍‌ଆପିନ୍‌ ନିଜେଦି ଆଡ଼୍‌ସିଙ୍ଗ୍‌ ଦାରିପାଣି ଦସ୍‌ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ଆଇ ଇନି ବିସୟ୍‌ତାନ୍‌ ଡ଼ିସ୍‌ନାନ୍‌ ନୋ ଆଇ ଆଇମାଦିଙ୍ଗ୍‍ ପେଡ଼ିଆନାନ୍‌, ୱାନ୍‌ ନିଜେ ଦାରିପାଣି କିନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ସିସୁର୍‍ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ଆଡ଼୍‌ସି ୱାଲେ କନ୍‌ଲିଦି ଜଦି ଇୟାୱାଜା ବିସୟ୍‌ମାନି ମାଟା, ଆର୍‌ତିଙ୍ଗ୍‌ ପେଡ଼ିଆଇକା ନେଗେତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ଜିସୁ ଇର୍ହାନ୍‌, “ଇୟା ସିକିୟା ୱିଜେରି ଉଣ୍ତିଙ୍ଗ୍‌ ସିଲେ । ମାପୁରୁଦି ମାଣାନ୍‌ ଏମେୱାରିଙ୍ଗ୍‌ ଇକା ସିଆୟ୍‌ଆତାମାନାତ୍‌, କେବଲ୍‌ ୱାର୍‌ ଇକା ମାନାଦେଙ୍ଗ୍‌ ଆଟ୍‌ନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ଇନିଇନି ବିସୟ୍‌ତାନ୍‌ ଲୋକୁ ପେଡ଼ିଆଏଣ୍‌ଗା ତେବାନାସୋନାର୍‌ । ଏସଲୋକ୍‌ ଜନମ୍‌ତାନ୍‌ ପେଡ଼ିଆନି ଉଣ୍ତିଙ୍ଗ୍‌ ଜଗ୍‌ସିଲେର୍‌, ଏସ ଲୋକାଙ୍ଗ୍‌ ଲୋକୁ ଆୟାୱାଜା କିତାମାନାର୍‌, ମାରି ଏସଲୋକ୍‌ ମୁସ୍‌କୁପୁର୍‌ତି ଉଣ୍ତିଙ୍ଗ୍‌ ପାଣିକିଦେଙ୍ଗ୍‌ ପେଡ଼ିଆଏଣ୍‌ଗା ତେବାନାର୍‌ । ଏମେକାର୍‌ ଇୟା ସିକିୟାଦି ଅର୍ତ ବୁଜାଦେଙ୍ଗ୍‌ ଆଟ୍‌ସିନାର୍‌, ୱାର୍‌ ଆକା ମାନାପିର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ନାସ୍ତିୱାଲେ ଇସ୍ରିକଡ଼ରି ମୁସ୍‌କୁ କିୟୁ ଇଡ୍‌ଜି ପାର୍‌ତନା କିଦେଙ୍ଗ୍‌ ଇଜି ଏସଲୋକ୍‌ ୱାରିଙ୍ଗ୍‌ ଜିସୁଦି ଲାକ୍‌ତୁ ତାତାର୍‌ । ଆୟା ଲୋକାଙ୍ଗ୍‌ ସିସୁର୍‍ ଆଦ୍‌ରିସ୍‌ କିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ମାତର୍‌ ଜିସୁ ଇର୍ହାନ୍‌, “ଇସ୍ରି କଡ଼ରିଙ୍ଗ୍‌ ନା ଲାକ୍‌ତୁ ୱାଦେଙ୍ଗ୍‌ ସିଦୁ । ୱାରିଙ୍ଗ୍‌ ବାଦାକିମାଟ୍‌, ଇରିଙ୍ଗ୍‌ ମୁସ୍‌କୁପୁର୍‌ତି ଅଦିକାରି ଏମେକାର୍‌ ୱେରିୱାଜା ଆୟା ଲୋକ୍‌ତି ଅଦିକାରି ।” ");
INSERT INTO kfcp_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ମାରି, ୱାରି ମୁସ୍‌କୁ କିୟୁ ଇଡ୍‌ଜି ଆସିର୍ବାଦ୍‌ କିତି ୱେନ୍‌କା ୱାନ୍‌ ଆବେଟ୍‌ତାନ୍‌ ସୋର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ଅର୍‍ଲେନ୍‍ ଅରେନ୍‍ ମୁରୁଲି ଜିସୁଦି ଲାକ୍‌ତୁ ୱାତାନ୍‌ନୋ ୱେନ୍‌ବାତାନ୍‌, “ଏ ଗୁରୁ, ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜିଇ ଜିବନ୍‌ ପୟ୍‌ନି ଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ଇନି ନେଗି ପାଣି କିଦେଙ୍ଗ୍‌ ଆନାତ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନେଗି ପାଣି ବିସୟ୍‌ତାନ୍‌ ନାଙ୍ଗିଁ ଏନ୍ଦା ୱେନ୍‌ବାଜିନି ? ମାପୁରୁ ନେ କେବଲ୍‌ ନେଗିକାନ୍‍ । ମାପୁରୁଦି ମାଟେଙ୍ଗ୍‌ ମାନାତିଙ୍ଗ୍‌, ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜିଇ ଜିବନ୍‌ ପୟ୍‌ଦେଙ୍ଗ୍‌ ଆଟ୍‌ନି ।” ");
INSERT INTO kfcp_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ୱାନ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ଆମାୱିଜୁ ମାଟେଙ୍ଗ୍‌ ?” ଜିସୁ ଇର୍ହାନ୍‌, “ଲୋକାଙ୍ଗ୍‌ ସାୟାମାର୍‌ଗା ଡାକ୍‌ମାଟ୍‌, ଦାରିପାଣି କିମାଟ୍‌, ଡଙ୍ଗାଁ କିମାଟ୍‌, ଏ ବିରଦ୍‌ତାନ୍‌ ମିସ୍‌ମାଟା ସାକିସିମାଟ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ବୁବାୟାୟ୍‌ଙ୍ଗେ ମାନାଦୁ, ମାରି ଲାକ୍‌ତୁରି ଲୋକାଙ୍ଗ୍‌ ନିଜେଦିଙ୍ଗ୍‍ ଜିବନ୍‌ନୋତିୱାଜା ଜିବନ୍‍ନୋଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ମୁରୁଲି ଇର୍ହାନ୍‌, “ଇୟାୱିଜୁ ମାଟେଙ୍ଗ୍‌ ମାନାତାମାନା, ନାନ୍ ମାରି ଇନିକା ନାଙ୍ଗିଁ ଉଣାମାନାତ୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଜଦି ନିନୁ ନେଗିକାନ୍‍ ଆଦେଙ୍ଗ୍‌ ବଦାକିଜିନି, ସାଙ୍ଗ୍‌ଆଁ, ନି ୱିଜୁ ସମ୍ପତ୍ତି ପର୍‌ଜ ଆୟା ଡାବୁଙ୍ଗୁଁ ସିଲିସାତିୱାରିଙ୍ଗ୍‌ ଦାନ୍‌ ସିଆ । ଆର୍‌ତିଙ୍ଗ୍‌ ନିନ୍‌ ମୁସ୍‌କୁପୁର୍‌ତୁ ଦନ୍‌ ପଇନି । ଇୟାୱିଜୁ କିଜୱିସ୍‌ସୋ ନା ୱେନ୍‌କା ୱେନ୍‌କା ରାଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ମୁରୁଲି ଇୟା ମାଟା ୱେନ୍‌ଞ୍ଜି ଦୁଃକ୍‍ ଆଜି ସୋର୍ହାନ୍‌, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ପେରି ମାଜନ୍‌ଲୋକ୍‌ ମାର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ଜିସୁ ନିଜେଦି ସିସୁରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ମାଜନ୍‌ ଲୋକୁ ବଡ଼େ କସ୍ଟଦାନ୍‌ ମୁସ୍‌କୁପୁର୍‌ତୁ ସନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ମାରିଡ଼େସି ନାନ୍ ମିଙ୍ଗିଁ ୱେର୍‌ସିନା, ମାପୁରୁଦି ରାଜିଦୁ ମାଜନ୍‌ ଲୋକ୍‌ତି ସନି ବାଦୁଲୁ ସୁଜିଦି ବର୍‌ ସିଜି ଉଟ୍‌ ଡ଼ୁଗୁନିକା ଉସାସ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ସିସୁର୍‍ ଇକା ୱେନ୍‌ଞ୍ଜି କାବାଆତାରୋ ୱେନ୍‌ବାତାର୍‌, “ଆର୍‌ତିଙ୍ଗ୍‌ ଏନ୍‌ ରକିୟା ପଇଦେଙ୍ଗ୍‍ ଆଟ୍‍ନାନ୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ଜିସୁ ସିସୁରିଙ୍ଗ୍‌ ସାଡ଼୍‌କୁ ସାଡ଼୍‌କୁ ସୁଡ଼୍‍ଜି ଇର୍ହାନ୍‌, “ଇକା ଲୋକାଦି ଉଣ୍ତିଙ୍ଗ୍‌ ଆଟ୍‌ୱା ଆଦେଙ୍ଗ୍‌ ଆଟ୍‌ନାତ୍‌, ମାତର୍‌ ମାପୁରୁଦିଙ୍ଗ୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ଆନାତ୍‌, ଇରିଙ୍ଗ୍‌ ମାପୁରୁ ୱିଜୁ କିଦେଙ୍ଗ୍‍ ଆଟ୍‍ନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ଇକା ୱେର୍‌ଆନ୍‌ନୋ ପିତର୍‌ ଇର୍ହାନ୍‌, “ସୁଡ଼ୁଦୁ, ମାପ୍‌ ୱିଜୁ ଡ଼ିସ୍‌ସି ନି ୱେନ୍‍କା ୱାତା ମାନାପ୍‌ । ମାଡ୍‌ ଇନିକା ପଇନିକା ?” ");
INSERT INTO kfcp_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ପୁନି ଜଗ୍‌ତି ଏସ୍ତିୱାଲେ ମନୁସ୍ୟପୁତ୍ର ନିଜେଦି ଗୌରବ୍‌ମୟ୍‌ ରାଜାଗାଦିଦୁ ବାସ୍‌ନାନ୍‌, ନାସ୍ତିୱାଲେ ନା ଇୟା ବାରଲୋକ୍ ସିସୁର୍‍ ବା ବାରଗୋଟା ରାଜାଗାଦିଦୁ ବାସ୍‌ନାରୋ ଇସ୍ରାଏଲ୍‌ତି ବାରଗୋଟା କୁଟୁମ୍‌ତି ମୁସ୍‌କୁ ସାସନ୍‍ କିନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ମାରି ଏମେକାର୍‌ ନା ଉଣ୍ତିଙ୍ଗ୍‌ ନିଜେଦି ଇଲୁ, ତଡ଼ାନ୍‌ତିଙ୍ଗ୍‌ ନି ତାଙ୍ଗିଁ, ବୁବା ନି ୟାୟେଙ୍ଗ୍‌, କଡ଼କକ୍ରାରିଙ୍ଗ୍‌ ମାରି ବୁମିବାଡ଼ା ଡ଼ିସ୍‌ତାମାନାନ୍‌, ୱାର୍‌ ତାନି ସଏ ଗୁଣୁ ପୟ୍‌ନାର୍‌; ମାରି ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜ୍‍ଇ ଜିବନ୍‌ ବା ପୟ୍‌ନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ମାତର୍‌ ଆଗ୍‌ଡ଼ି ମାନି ଏସ ଲୋକୁ ୱେନ୍‌କା ଆନାର୍‌ ମାରି ୱେନ୍‌କା ମାନି ଏସ ଲୋକୁ ଆଗ୍‌ଡ଼ି ଆନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","ମୁସ୍‌କୁପୁର୍‌ ଇୟାୱାଜା । ଅରେନ୍‍ ଲୋକୁ ଅର୍‍ଲେନ୍‍ ଉଟ୍‌ଲା ନାଡ଼ାକାଦେ ୱାନି ଅଙ୍ଗୁର୍‌ କିଡ଼ିଇଦୁ ପାଣି କିଦେଙ୍ଗ୍‍ ଇଜି ବୁତିଲୋକାଙ୍ଗ୍‌ ପୟ୍‌ଦେଙ୍ଗ୍‌ ସୋତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ଆମାୱାରିଙ୍ଗ୍‌ ପୟ୍‌ତାନ୍‌, ୱିଜେରିଙ୍ଗ୍‌ ଅର୍‌ଲେଟିଙ୍ଗ୍‌ ଉନ୍‌ଡ୍ରି ଲାକା ୱେଣ୍ଡିଅଦ୍‌ଲି ବୁତି ଡାବୁଙ୍ଗ୍‌ ସିଦେଙ୍ଗ୍‍ ତେୱେତାନ୍‌ନୋ ୱାରିଙ୍ଗ୍‌ ନିଜେଦି କିଡ଼ିଇଦୁ ପୋକ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ତାନେୱେନ୍‌କା ନାଣ୍ତିଙ୍ଗ୍‌ ନଅଟା ବେଡ଼ାଦୁ ସାତାଦୁ ସର୍‌ର୍ହାନ୍‌ନୋ ସୁଡ଼ୁତାନ୍‌, ମାନ୍ଦାଲୋକ୍‌ ସିମ୍ରା ଆଜି ନିର୍‌ଆମାନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ୱାରିଙ୍ଗ୍‌ ୱାନ୍‌ ଇର୍ହାନ୍‌, ମିର୍‌ ବା ନା ଅଙ୍ଗୁର୍‌ କିଡ଼ିଇଦୁ ସୋଲ୍‌ସ ପାଣି କିଦୁ, ମିଙ୍ଗିଁ ସାମାନ୍‍ ବୁତି ସିନା । ");
INSERT INTO kfcp_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ୱାର୍‌ ସୋର୍ହାର୍‌ନୋ ପାଣି କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ । ୱେଡ଼େ ବାର୍‌ଟା ମାରି ତିନ୍‌ଟା ବେଡ଼ାଦୁ ଟିକ୍‌ ଆୟାୱାଜା ମାରି ଏସ ପାଣିକିନିୱାରିଙ୍ଗ୍‌ ତାତାନ୍‌ନୋ ପାଣିଦୁ ଲାଗିସ୍‌କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ମାରି ମିଲ୍‌ମିଲିକା ପାସ୍‌ଟା ବେଡ଼ାଦୁ ମାରି ଉନ୍‌ଡ୍ରି ଦେବା ସାତାଦୁ ସର୍ହାନ୍‌ନୋ ସୁଡ଼ୁତାନ୍‌, ମାରି ଏସ ଲୋକୁ ନିର୍‌ଆମାନାର୍‌, ୱାରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, ୱେଡ଼୍‌ୱେଡ଼ାର୍‌ ପାଣିକିଏଣ୍‌ଗା ଏନ୍ଦା ଇବେନୁ ସମୟ୍ ନାସ୍ଟୁକିଜିନିଦେର୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ୱାର୍‌ ଇର୍ହାର୍‌, ଏନ୍‌ ମାଙ୍ଗିଁ ପାଣିଦୁ ଲାଗିସ୍‌କିଏର୍‌ । ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ଆର୍‌ତିଙ୍ଗ୍‌ ମିର୍‌ ୱିଜୁ ନା ଅଙ୍ଗୁର୍‌ କିଡ଼ିଇଦୁ ସୋଲ୍‌ସ ପାଣିକିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","ଆୟାନାଣ୍ତିଙ୍ଗ୍‌ ମିଲ୍‌ମିଲିକା ବେଡ଼ାଦୁ କିଡ଼ିଇଦି ମାଲିକ୍‍ ଗୁମାସ୍ତାଦିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ପାଣିକିତିୱାରିଙ୍ଗ୍‌ କୁକ୍‌ଆ । ଆମାକାର୍‌ ୱିଜେରିମାଣାନ୍‌ ୱେନ୍‌କା ପାଣି ଆରାମ୍‌କିତାମାନାର୍‌, ଆଗ୍‌ଡ଼ି ୱାରି ବୁତି ସିଆ । ଆମାକାର୍‌ ୱିଜେରି ଆଗ୍‌ଡ଼ି ପାଣିଦୁ ୱାତାମାନାର୍‌ ୱାରି ବୁତିଡାବୁଙ୍ଗ୍‌ ସାରାସାରିୱେନ୍‌କା ସିଆ । ");
INSERT INTO kfcp_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ମିଲ୍‌ମିଲିକା ପାସ୍‌ଟାଦୁ ଆମାକାର୍‌ ପାଣିଦୁ ୱାତା ମାର୍ହାର୍‌, ୱାର୍‌ ୱିଜେରେ ଉନ୍‌ଡ୍ରି ୱେଣ୍ଡିଅଦ୍‌ଲି ଡାବୁଙ୍ଗ୍‌ ପୟ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ଆମାକାର୍‌ ଆଗ୍‌ଡ଼ି ପାଣି ଆରାମ୍‌ କିତାମାର୍ହାର୍‌, ୱାର୍‌ ନାଣ୍ତ ପୟ୍‌ନିକା ଇଜି ଅଡ଼୍‌ବିତାର୍‌, ମାତର୍‌ ୱାନ୍‌ ବା ଉନ୍‌ଡ୍ରେ ଉନ୍‌ଡ୍ରେ ୱେଣ୍ଡିଅଦ୍‌ଲି ଡାବୁଙ୍ଗ୍‌ ପୟ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ୱାର୍‌ ନିସ ଅସି ମାଲିକ୍‌ ବିରଦ୍‌ତାନ୍‌ ୱେଡ଼ିକାଆଏଣ୍‌ଗା ୱେର୍‌ସି ଇର୍ହାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ମିଲ୍‌ମିଲିକା ପାସ୍‌ଟାଦୁ ପାଣି ଆରାମ୍‌ କିତିମାନିକାର୍‌ ଉନ୍‌ଡ୍ରେ ଗନ୍‌ଟାନେ ପାଣି କିତାମାନାର୍‌ । ମାପ୍‌ ଇୟା ନିସ ତେର୍‌ୱେଲ୍‌ତିଙ୍ଗ୍‌ ୱେଡ଼ାର୍‌ କଟେଆତାପ୍‌, ମାରି ବୁତିଡାବୁଙ୍ଗ୍‌ ସିତିୱାଲେ ୱାରିଙ୍ଗ୍‌ ମା ୱାଲେ ସାମାନ୍‍ କିଜିସିତି । ");
INSERT INTO kfcp_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ମାଲିକ୍‌ ୱାରି ଲୋଇରାନ୍‌ ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ଇର୍ହାନ୍‌, ବନ୍ଧୁ; ନାନ୍ ନିଙ୍ଗିଁ ଟକେକିଏ । ଅର୍‌ଲେଟି ବୁତି ଡାବୁଙ୍ଗ୍‌ ଉନ୍‌ଡ୍ରେ ୱେଣ୍ତି ଅଦ୍‌ଲି ଅସି ପାଣି କିଦେଙ୍ଗ୍‌ ମିର୍‌ ୱିଜିଦେର୍‌ ରାଜିଆତିମାରିଇଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ମି ଆୟା ବୁତିଡାବୁଙ୍ଗ୍‌ ଅସି ଇନ୍‌ଡ୍ର ସାନ୍‌ଡ୍ରୁ, ମିଙ୍ଗିଁ ଏସ ସିତାମାନା, ଉନ୍‌ଡ୍ରେ ଗନ୍‌ଟା ପାଣି କିତିମାନି ଲୋକ୍‌ତିଙ୍ଗ୍‌ ବା ନାସନେ ସିଦେଙ୍ଗ୍‍ ନା ବଦା । ");
INSERT INTO kfcp_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ନା ନିଜେଦି ଦନ୍‌ତିଙ୍ଗ୍‌ ଏଣ୍ତେସ୍‌ ବଦା ଆୟାୱାଜା କାର୍‌ସୁକିଦେଙ୍ଗ୍‌ ଇନିକା ନା ଅଦିକାର୍‌ ସିଲେତ୍‌ ? ସିଲେ ନାନ୍ ଦାନ୍‍ସିନିକାନ୍‍ ଆତିଙ୍ଗ୍‌ ମିର୍‌ ନାଙ୍ଗିଁ ଆକାର୍‍ଆଜିନିଦେର୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ଇୟା କାତାଦି ମାଟା ୱିସ୍‌ତାନ୍‌ନୋ ଜିସୁ ଇର୍ହାନ୍‌, “ୱେନ୍‌କା ମାନି ଲୋକୁ ଆଗ୍‌ଡ଼ି ଆନାର୍‌ ମାରି ଆଗ୍‌ଡ଼ି ମାନି ଲୋକୁ ୱେନ୍‌କା ଆନାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ଜିସୁ ଜିରୁସାଲମ୍‌ତୁ ସନି ସାରିଦୁ ବାର୍‌ଲୋକ୍‌ ସିସୁରିଙ୍ଗ୍‌ ଉନ୍‌ଡ୍ରି ଲାକ୍‌ତୁ କୁକ୍‌ତାଅତାନ୍‌ନୋ ଅରେନ୍‌ନେ ଇର୍ହାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“ୱେନ୍‌ଡ୍ରୁ, ମାଡ୍‌ ଜିରୁସାଲମ୍‌ତୁ ସୋଲ୍‌ସିନିକା, ଆବେନୁ ମନୁସ୍ୟପୁତ୍ର ପେରି ଜାଜକ ମାରି ଦାର୍ମୁଗୁରୁରି କିୟୁଦୁ ସର୍‌ପେଆନାନ୍‌ । ମାରି ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ସାନିଦଣ୍ତ୍‌ ସିନାର୍‍ ");
INSERT INTO kfcp_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ମାରି ୱାର୍‌ ଅଣଜିହୁଦିରି କିୟୁଦୁ ସର୍‌ପେ କିଜି ସିନାର୍‍ । ଆଇଜାତିଦିକାର୍‌ ୱାନିଙ୍ଗ୍‌ ସେମାର୍‌ କିନାର୍‌, କର୍‌ଡା ମାଡ୍‌ ଡାକ୍‌ନାର୍‌ ମାରି କ୍ରୁସକାଟ୍‌ତୁ ଏକିସ୍‌କିନାର୍‌, ମାତର୍‌ ମୁନେଟି ୱେନ୍‌କା ୱାନ୍ ମାରିଡ଼େସି ଜିବନ୍‌ଆଜି ନିଙ୍ଗିଁନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ଇୟା ସମୟ୍‍ତୁ ଜେବଦିଦି ଆଡ଼୍‌ସି ତାନି ରିଏରି ମାରିସିରି ୱାଲେ ଜିସୁଦି ଲାକ୍‌ତୁ ୱାଜି, ଜିସୁଙ୍ଗୁଁ ମାଡ଼ିସ୍‍କିଜି ୱାନିମାଣାନ୍‌ ଇନିକା କିଦେଙ୍ଗ୍‌ ଲସ୍‌ତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ଜିସୁ ତାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ନିନ୍‌ ଇନିକା ବଦାକିଜିନି ?” ୱାଦ୍‌ ଇର୍ହାତ୍‌, “ନିନ୍‌ ଏସ୍ତିୱାଲେ ରାଜା ଆନି, ନା ଇୟା ରିଏର୍‌ ମାରିସିରିଙ୍ଗ୍‌ ନି ଉଣେରି କିୟୁ ତରିନ୍‍ ମାରି ଅରେନ୍‍ ଲୋକ୍‌ତିଙ୍ଗ୍‌ ନି ଡେବ୍‍ରିକିୟୁ ତରିନ୍‍ ବାସ୍ତେଙ୍ଗ୍‍ ମାଟା ସିଦା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ଜିସୁ ଜେବଦିରି ରିଏର୍‌ ମାରିସିରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମିର୍‌ ଇନିକା ଲସ୍‌ସିନିଦେର୍‌, ଆୟାକା ମିର୍‌ ନେସ୍‌ତେଙ୍ଗ୍‌ କି ବୁଝାଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏଜିନିଦେର୍‍ । ନାନ୍ ଏମେ ଦୁଃକ୍‌ବୋଗ୍‌ତି ଉଣିଡୁବାଇତାନ୍‌ ଉନ୍‌ଣ୍ତେଙ୍ଗ୍‌ ସୋଲ୍‌ସିନା, ମିର୍‌ ଇନିକା ଆବେଟ୍‌ତାନ୍‌ ଉନ୍‌ଣ୍ତେଙ୍ଗ୍‌ ଆଟ୍‌ନିଦେର୍‌ ?” ୱାର୍‌ ଇର୍ହାର୍‌, “ହୁଁ ଆଟ୍‍ନାପ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମିର୍‌ ନା ଆୟା ଡୁବାଇତୁ ଉଣିଦେର୍‌ ସତ୍‌, ମାତର୍‌ ନା ଉଣେରି ମାରି ଡେବିରି ତରିନ୍‌ ବାସ୍‌ତେଙ୍ଗ୍‌ଇଜି ଏଙ୍ଗ୍‌ ଆସ୍‌କିଦେଙ୍ଗ୍‌ ଅଦିକାର୍‌ ନାଙ୍ଗିଁ ସିଲେତ୍‌ । ଆମାୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ନା ବୁବା ଆୟା ବାଡି ତିଆର୍‌ କିତାମାନାନ୍‌, ଆକା କେବଲ୍‌ ୱାରିଦି ।” ");
INSERT INTO kfcp_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ଏସ୍ତିୱାଲେ ଆଇ ଦାସ୍‌ଲୋକ୍‌ ସିସୁର୍‍ ଇୟା ମାଟା ୱେର୍‌ଆର୍‌, ଆୟା ତଡ଼ରିଏରି ମୁସ୍‌କୁ ଗିଦ୍‌ରି ଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ଜିସୁ ସିସୁରିଙ୍ଗ୍‌ ଉନ୍‌ଡ୍ରେମାନୁ କିଜି ଇର୍ହାନ୍‌, “ମିର୍‌ ନେସ୍‌ନିଦେର୍‌, ଇୟା ଦୁନିଆଦି ଅଣଜିହୁଦି ରାଜାର୍‌ ଆଇୱାରି ମୁସ୍‌କୁ ଅଦିକାର୍‌ କିତାର୍‍ମାନ୍ଦି ମାରି ପେରି ପେରି ନେତାର୍‌ ବା ଆଇୱାରି ମୁସ୍‌କୁ ସାସନକିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ମି ଲୋଇ ଆୟାୱାଜା ସିଲେତ୍‍, ମାତର୍‌ ମି ଲୋଇରାନ୍‌ ଅରେନ୍‍ ପେରିକାନ୍‌ ଆଦେଙ୍ଗ୍‌ ବଦାକିନାନ୍‌, ୱାନ୍‌ ଆଇୱାରି ସେବାକିନିକାନ୍‍ ଆପିନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ମାରି ମି ଲୋଇରାନ୍‌ ଏନ୍‌ ପେରିକାନ୍‌ ଆଦେଙ୍ଗ୍‌ ବଦାକିନାନ୍‌, ୱାନ୍‌ ଆଇୱାରି ଗତିମୁରୁଲି ୱାଜା ୱାରି ସେବା କିପିନ୍‍, ");
INSERT INTO kfcp_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ଏଣ୍ତେସ୍‌ ମନୁଷ୍ୟପୁତ୍ର ଯେ ନାନ୍ ସେବା ପ‍ଇଦେଙ୍ଗ୍‌ ରେଏ, ମାତର୍‌ ସେବା କିଜି ଆଇୱାରିଦି ଡ଼ିସିସ୍‍କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ନିଜେଦି ଜିବନ୍‌ ସିଦେଙ୍ଗ୍‍ ଇଜି ୱାତାମାନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ଅର୍‍ଲେନ୍‍ ଜିସୁ ସିସୁରି ୱାଲେ ଜିରିହୋ ଗାଡ଼୍‌ ଡ଼ିସ୍‌ସି ସନିୱାଲେ ନାଣ୍ତଲୋକୁ ୱାନି ୱେନ୍‌କା ୱେନ୍‌କା ବୁଲାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ରାସ୍ତା ପାଡ଼ି ବାସ୍‌ତିମାନି ରିଏର୍‌ କାଣାର୍‌, ଜିସୁ ଆୟା ସାରି ୱାଜିନାନ୍‍ ଇଜି ୱେନ୍‌ଞ୍ଜି ନାଣ୍ତ ଆଉଲି ଆଜି କୁକ୍‌ତାର୍‌, “ଏ ପ୍ରବୁ, ଦାଉଦତି ମାରିନ୍‌ ! ମାଙ୍ଗିଁ ଦୟା କିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ଲୋକ୍‌ ୱିଜେରେ ୱାରିଙ୍ଗ୍‌ ଆଦ୍‌ରିସ୍‌କିଜି ଆଲେଜ ମାନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଇର୍ହାର୍‌, ମାତର୍‌ ୱାର୍‌ ମାରି ନାଣ୍ତ ଆଉଲି ଆଜି ଇର୍ହାର୍‌, “ଏ ପ୍ରବୁ, ଦାଉଦତି ମାରିନ୍‌ ! ମାଙ୍ଗିଁ ଦୟା କିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ଆବେନୁ ଜିସୁ ନିର୍‌ଆନ୍‌ନୋ ୱାରିଙ୍ଗ୍‌ କୁକ୍‌ତାନ୍‌ନୋ ୱେନ୍‌ବାତାନ୍‌, “ନାନ୍ ମିଙ୍ଗିଁ ଇନିକା କିନା ଇଜି ମିର୍‌ ବଦା କିଜିନିଦେର୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ୱାର୍‌ ଇର୍ହାର୍‌, “ପ୍ରବୁ ମାଙ୍ଗିଁ ସୁଡ଼ୁନି ସାକ୍ତି ସିଦା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ମାରି, ଜିସୁ ଦୟାଦାନ୍‌ ଦାନ୍ଦାଆଜି ୱାରି କାଣ୍‌କାଙ୍ଗ୍‌ ମୁଟ୍‌ତାନ୍‌, ମାରି ଆୟାଦାପ୍ରେ ୱାର୍‌ ସୁଡ଼ୁଦେଙ୍ଗ୍‌ ଆଟ୍‌ତାର୍‌ ମାରି ୱାନି ୱେନ୍‌କା ୱେନ୍‌କା ବୁଲାଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ଜିସୁ ନି ୱାନି ସିସୁର୍‍ ଜିରୁସାଲମ୍‌ତି ଲାକ୍‌ତୁରି ଜିତ୍ ଗରନ୍‌ ମୁସ୍‌କୁ ମାନି ବେତ୍‍ପାଗି ନାଟ ଇତାର୍‌ । ନାସ୍ତିୱାଲେ ଜିସୁ ରିଏର୍‌ ସିସୁରିଙ୍ଗ୍‌ ଇୟା ମାଟା ୱେର୍‌ସି ପୋକ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“ମି ଆଗ୍‍ଡ଼ିରି ଆୟା ନାଟ ସାନ୍‌ଡ୍ରୁ, ଆବେ ଇତି ଦାପ୍ରେନେ ତରାତିମାନି ଉନ୍‌ଡ୍ରି ଗଦଦିଙ୍ଗ୍‌ ମାରି ତାନେୱାଲେ ଉନ୍‌ଡ୍ରି ଗଦପିଲାଦିଙ୍ଗ୍‌ ସୁଣିଦେର୍‌; ୱାନିକାଙ୍ଗ୍‌ କୁତ୍‌ସ ନା ଲାକ୍‌ତୁ ଆସ୍‌ସୋ ରାଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ମାରି ଏନ୍‌ ମିଙ୍ଗିଁ ଇନିକା ୱେନ୍‌ବାତିଙ୍ଗ୍‌, ଆର୍‌ତିଙ୍ଗ୍‌ ଇନିଦେର୍‌, ୱେନିକାମାନୁ ପ୍ରବୁଙ୍ଗ୍‌ ଦର୍‌କାର୍‌ ମାନାତ୍‌ । ଆୟାଦାପ୍ରେନେ ୱାନ୍‌ ୱାନିକାଙ୍ଗ୍‌ ଡ଼ିସ୍‌ନାସିନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ବାବବାଦିରି ମାଣାନ୍‌ ରାସ୍‍ତିମାନି ଇୟା ବାକ୍ୟ ଏଣ୍ତେସ୍‌ ପୁରା ଆନାତ୍‌, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ଇକା ଗଟାତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“ସିୟୋନତି ଗାଡ଼୍‌ତିଙ୍ଗ୍‌ ଇନ୍‌ଆଁ, ସୁଡ଼୍‍ଦୁ, ନି ରାଜା ମି ଲାକ୍‌ତୁ ୱାଜିନାନ୍‍; ୱାନ୍‌ ସାନ୍ତି ମାରି ଗଦପିଲା ନି ଗଦଦି ମୁସ୍‌କୁ ବାସ୍‌ତାନ୍‌ନୋ ୱାଜିନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ସିସୁର୍‍ ସୋର୍ହାର୍‌ନୋ ଜିସୁ ୱେର୍‌ତି ଇସାବ୍‌ତାନ୍‌ ପାଣି କିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ଗଦ ନି ଗଦପିଲାଦିଙ୍ଗ୍‌ ତାତାରୋ ୱାନିକା ମୁସ୍‌କୁ ନିଜେନିଜେଦି ୱାତିଙ୍ଗ୍‌ ପିଡ଼ିକ୍‌ତାର୍‌, ମାରି ଜିସୁ ଆୟା ଗଦ ମୁସ୍‌କୁ ବାସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ମାରି, ଲୋକାୱିଜେରି ମାଣାନ୍‌ ଏସଲୋକ୍‌ ଜିସୁ ସୋଲ୍‌ସିମାନି ରାସ୍ତା ମୁସ୍‌କୁ ନିଜେ ନିଜେଦି ୱାତିଙ୍ଗ୍‌ ପାର୍‌ତାସିତାର୍‌ ମାରି ଏସଲୋକ୍‌ ମାରାତାନ୍‌ କାଜିରି କମେଙ୍ଗ୍‌ କାତ୍‌ସି ତାସି ରାସ୍ତାଦୁ ପାର୍‌ତେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ଜିସୁଦି ଆଗ୍‌ଡ଼ି ନି ୱେନ୍‌କା ସୋଲ୍‌ସିମାନି ଲୋକୁ ୱିଜେରେ ନାଣ୍ତ ଆଉଲି ଆଜି ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, ହୋଶାନା, “ଦାଉଦତି ମାରିନ୍‌, ପ୍ରବୁଦି ଦର୍‌ତାନ୍‌ ଏନ୍‌ ୱାଜିନାନ୍‍, ମାପୁରୁ ୱାନିଙ୍ଗ୍‌ ଆସିର୍ବାଦ୍‌ କିପିନ୍‌ । ମାପୁରୁଙ୍ଗ୍‌ ପ୍ରସଂସା ଆପିତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ମାରି, ଏସ୍ତିୱାଲେ ଜିସୁ ଜିରୁସାଲାମ୍‍ତୁ ଇତାନ୍‌, ଗାଡ଼୍‌ୱିଜୁ ଇକାନ୍‌ ଏନ୍‌ ଇଜି ପୁରା ବେମ୍‍ର୍‍ ଆତାର୍‌ । ଲୋକୁ ୱେନ୍‌ବାତାର୍‌, “ଆୟାକାନ୍‌ ଏନ୍‌ ?” ଆଇକାର୍‌ ଇର୍ହାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","“ୱାନ୍‌ ଆଜିନାନ୍‍, ଗାଲିଲି ରାଜିଦି ନାଜରିତଦି ବାବବାଦି ଜିସୁ ।” ଲୋକୁ ୱେର୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ଜିସୁ ମନ୍ଦିର୍‌ ଲୋଇ ଡ଼ୁଗିତାନ୍‌ନୋ ଆୟା ବାଡିଦୁ କଡ଼ଜି ପର୍‌ଜି କିଜିମାନି ୱିଜୁ ଲୋକାଙ୍ଗ୍‌ ଆତେରେ ସୋପ୍‌ତାନ୍‌ । ମାରି ଅଦ୍‌ଲିଙ୍ଗ୍‌ ମାର୍‍ନିୱାରି ପାସ୍‌ରା ମାରି ପାଉରା ପର୍‌ନିୱାରି ପାସ୍‌ରା ମାର୍ତା ପୋକ୍‌ତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ମାରି ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଦର୍ମୁସାସ୍ତ୍ରଦୁ ରାସାତାମାନାତ୍‌, ନା ମନ୍ଦିର୍‌ ପାର୍‌ତନା ଇଲୁ ଇଜି ୱେଙ୍ଗିଁନାତ୍‌, ମାତର୍‌ ମିର୍‌ ତାନିଙ୍ଗ୍‌ ଡଙ୍ଗାଁରି ଇଲୁ କିତିମାନିଦେର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ଜିସୁ ମନ୍ଦିର୍‌ତୁ ମାନିୱାଲେ କାଣାର୍‌ ନି କିକୁକାଲ୍‌କୁ ୱାର୍‌ତିକାର୍‌ ୱାନି ଲାକ୍‌ତୁ ୱାତାର୍‌ ମାରି ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ନେଗେନ୍‌କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ପେରି ଜାଜକ ମାରି ଦାର୍ମୁଗୁରୁର୍‌ ୱାନି କାବାଆନି ପାଣି ୱିଜୁ ମାରି ମନ୍ଦିର୍‌ ଲୋଇ “ଦାଉଦ ମାରିନ୍‌ ମାପୁରୁଦି ପ୍ରସଂସା ଆପିତ୍‌” ଇଜି ନାଣ୍ତ ଆଉଲିଆଜିମାନି କଡ଼ରିଙ୍ଗ୍‌ ସୁଡ଼ୁଜି ରିସା ଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ୱେନ୍‌ବାତାର୍‌, “ଇୟାକାର୍‌ ଇନିକା ଆଜିନାର୍‌, ମିର୍‌ ୱେନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆଟ୍‌ସିନିଦେର୍‌ ?” ଜିସୁ ଇର୍ହାନ୍‌, “ପୁରା ୱେନ୍‌ଞ୍ଜିନା । ଦର୍ମସାସ୍ତ୍ରଦୁ ଇୟା ମାଟା ଇନିକା ପଡ଼ାଇଦେର୍‌, ମିର୍‌ କଡ଼ରିଙ୍ଗ୍‌ ନି ଇସ୍ରି କଡ଼ର୍‌ ଟିକ୍‌ ଇସାବ୍‌ତାନ୍‌ ପ୍ରସଂସା କିଦେଙ୍ଗ୍‌ ସିକିୟା ସିତିମାନିଦେର୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ଇକା ଇନ୍‌ଞ୍ଜି ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ତାନ୍‌ନୋ ଜିରୁସାଲମ୍‌ତାନ୍‌ ବେତନିୟାଦୁ ସୋର୍ହାନ୍‌, ଆବେନୁ ୱାନ୍‌ ନାଡ଼ା ତେବାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ମାର୍‌ନାଣ୍ଡିଙ୍ଗ୍‌ ସାଲ୍‌ଦିନେ ଜିସୁ ଜିରୁସାଲମ୍‌ତୁ ଡ଼େସିସନିୱାଲେ ବାଙ୍ଗାଁ ସାତାନ୍ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ରାସ୍ତା ପାଡ଼ି ଉନ୍‌ଡ୍ରି ତଗା ମାରାନ୍‌ ମାର୍ହାତ୍‌ । ଜିସୁ ତାନେ ଲାକ୍‌ତୁ ସୋର୍ହାନ୍‌ନୋ ଆବେନୁ ଆକୁ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ମାରି ଇନିକାବା ତଏତାନ୍‌ । ୱାନ୍‌ ମାରାନ୍‌ତିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନିନ୍‌ ମାରି ଏସ୍‌କାଙ୍ଗ୍‌ବା ପଲ୍‌ ଆସ୍‌ଇ ।” ଆୟାଦାପ୍ରେ ତଗା ମାରାନ୍‌ ୱାର୍‌ତାସୋର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ସିସୁର୍‍ ଆକା ସୁଡ଼ୁଜି କାବାଆତାରୋ ୱେନ୍‌ବାତାର୍‌, “ତଗା ମାରାନ୍‌ ନିସାଦାପ୍ରେ ୱାର୍‌ତାସୋର୍ହାତ୍‌ ଏଣ୍ତେସ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ଜିସୁ ଇର୍ହାନ୍‌, “ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ମନ୍‌ତୁ ଅଡ଼ପ୍‍ବା ଅଡ଼୍‌ବିଏଣ୍‌ଗା ମିର୍‌ ଜଦି ପୁରାଦାନ୍‌ ବିସ୍‌ବାସ୍‌ କିନିଦେର୍‌, ନାନ୍ ଇୟା ତଗା ମାରାନ୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ଆମାକା କିତାମାନା, ମିର୍‌ ବା ଆକା କିଦେଙ୍ଗ୍‌ ଆଟ୍‌ନିଦେର୍‌ । କେବଲ୍‌ ନାସ ସିଲେ, ଏମେ ଲୋକୁ ଇୟା ଗରନ୍‍ତିଙ୍ଗ୍‍ ନିନ୍‌ ନିଙ୍ଗ୍‍ଜି ସାମ୍‌ଦୁର୍‌ତୁ ସଲ୍‍ସି ଆର୍‌ଆ ଇଜି ଇନାନ୍‌, ଆକାବା ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ବିସ୍‌ବାସ୍‌କିଜ ପାର୍‌ତାନାଦୁ ଆମାକା ଲସ୍‌ନିଦେର୍‌, ଆୟାୱିଜୁ ମିର୍‌ ପଇନିଦେର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ଜିସୁ ମନ୍ଦିର୍‌ତୁ ଡ଼େସିୱାଜି ଆବେନୁ ସିକିୟା ସିନିୱାଲେ ପେରି ଜାଜକର୍‌ ନି ଜିହୁଦି ନେତାର୍‌ ୱାନି ଲାକ୍‌ତୁ ୱାଜି ୱେନ୍‌ବାତାର୍‌, “ନିନ୍‌ ଆମା ଅଦିକାର୍‌ତାନ୍‌ ଇୟାୱିଜୁ ପାଣି କିଜିନି ? ମାରି, ଇୟା ନିଙ୍ଗିଁ ଏନ୍‌ ଇୟା ଅଦିକାର୍‌ ସିତାନ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନାନ୍ ବା ମିଙ୍ଗିଁ ଉନ୍‌ଡ୍ରି ମାଟା ୱେନ୍‌ବାନା, ଆୟା ଉତର୍‌ ସିଦେଙ୍ଗ୍‍ ଆଟ୍‌ତିଙ୍ଗ୍‌, ନାନ୍ ଆମା ଅଦିକାର୍‌ତାନ୍‌ ଇୟାୱିଜୁ ପାଣି କିଜିନା, ଆକା ନାନ୍ ବା ମିଙ୍ଗିଁ ୱେର୍‌ନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ଡୁବନ୍‌ ସିନି ଅଦିକାର୍‌ ଯୋହନ ଏମାଣାନ୍‌ ପୟ୍‌ତାମାର୍ହାନ୍‌ ? ମାପୁରୁମାଣାନ୍‌ ନୋ ଲୋକାମାଣାନ୍‌ ? ୱାର୍‌ ୱାରି ୱାରି ଲୋଇ ୱାର୍‍ଗିସାଜି ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, “ଇୟା ବିସୟ୍‌ତାନ୍‌ ଇନିକା ୱେର୍‌ନିକା ? ଜଦି ଇନିକା ମାପୁରୁମାଣାନ୍‌, ଆର୍‌ତିଙ୍ଗ୍‌ ଯୋହନତିଙ୍ଗ୍‌ ଏନ୍ଦା ବିସ୍‌ବାସ୍‌ କିଏଜିନିଦେର୍‌ ଇଜି ୱାନ୍‌ ମାଙ୍ଗିଁ ୱେନ୍‌ବାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ମାତର୍‌ ଲୋକାମାଣାନ୍‌ ଇଜି ଇନିକା, ଆର୍‌ତିଙ୍ଗ୍‌ ୱିଜୁଲୋକାଙ୍ଗ୍‌ ମାଡ୍‌ ତିଲାଜିନିକା, ଇରିଙ୍ଗ୍‌ ଯୋହନ ଅରେନ୍‍ ବାବବାଦି ଇଜି ୱିଜେରେ ଲୋକୁ ବିସ୍‌ବାସ୍‌କିଜିନାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ଆବେଟ୍‌ ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାର୍‌, “ମାପ୍‌ ନେସ୍‌ଏପ୍‌ ।” ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ନାନ୍ ଆମା ଅଦିକାର୍‌ତାନ୍‌ ଇୟାୱିଜୁ କିଜିନା, ଆକା ନାନ୍ ବା ମିଙ୍ଗିଁ ଇନ୍‌ଏ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“ଇଲେଇ ଇୟା ବିସୟ୍‌ତାନ୍‌ ମିର୍‌ ଇନିକା ଅଡ଼ବିଜିନିଦେର୍‌ । ଅରେନ୍‍ ଲୋକାଦି ରିଏର୍‌ କଡ଼ର୍‌ ମାର୍ହାର୍‌ । ଅର୍‍ଲେନ୍‍ ୱାନ୍‌ ପେରି ମାରିନ୍‌ତିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ‘ମାରିନ୍‌, ନେର୍‌ ମା ଅଙ୍ଗୁର୍‌ କିଡ଼ିଇଦୁ ସୋଲ୍‌ସ ପାଣିକିଆ ।’ ");
INSERT INTO kfcp_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ୱାନ୍‌ ଇର୍ହାନ୍‌, ନା ବଦା ସିଲେତ୍‌, ମାତର୍‌ ୱେନ୍‌କା ମନ୍‍ତିଙ୍ଗ୍‍ ଡ଼େପ୍‍ସି ପାଣି କିଦେଙ୍ଗ୍‌ ସୋର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ବୁବାସି ଇସ୍ରି ମାରିସିଙ୍ଗ୍‌ ବା ଆୟା ପାଣି କିଦେଙ୍ଗ୍‌ ଇର୍ହାନ୍‌ । ‘ହୁଁ, ଆଜ୍ଞା,’ ସୋଲ୍‌ସିନା ଇଜି ଇସ୍ରି ମାରିନ୍‌ ଇର୍ହାନ୍‌ । ମାତର୍‌ ୱାନ୍‌ ପାଣିଦୁ ମୁଡ଼ୁକେ ସୋଲ୍‌ଏତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ଇୟା ରିଏର୍‌ କଡ଼ରି ମାଣାନ୍‌ ଏନ୍‌ ତାମେ ବୁବାସିଦି ମାଟା ମାନାତାମାର୍ହାନ୍‌ ?” ୱାର୍‌ ଇର୍ହାର୍‌, “ପେରି ମାରିନ୍‌ ।” ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ସିସ୍‍ଟୁ ଲୋସ୍‌ନିକାର୍‌ ନି ଦାରିପାଣିକିନିକାର୍ ମିମାଣ୍‌କୁ ଆଗ୍‌ଡ଼ି ମାପୁରୁଦି ରାଜିଦୁ ସୋନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ଡୁବନ୍‌ ସିନି ଯୋହନ ମି ଲାକ୍‌ତୁ ୱାଜି ଟିକ୍‌ ସାରି ତର୍‌ତାସିତା ମାର୍ହାନ୍‌, ମାତର୍‌ ମିର୍‌ ୱାନିଙ୍ଗ୍‌ ବିସ୍‌ବାସ୍‌ କିଇତିଦେର୍‌ । ମାତର୍‌ ସିସ୍‍ଟୁ ଲୋସ୍‌ନିକାର୍‌ ନି ଦାରିପାଣିକିନିକାର୍ ୱାନି ମାଟାଦାନ୍‌ ବିସ୍‌ବାସ୍‌କିତାର୍‌, ଇକା ସୁଡ଼ୁଜି ବା ମିର୍‌ ମୋନ୍‌ ଡ଼େପ୍‍ସି ୱାନିଙ୍ଗ୍‌ ବିସ୍‌ବାସ୍‌ କିଇତିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ଜିସୁ ଇର୍ହାନ୍‌, “ମାରି ଉନ୍‌ଡ୍ରି କାତା ୱେନ୍‌ଡ୍ରୁ ।” ଅରେନ୍‍ ବୁମିମାଲିକ୍‌ ମାର୍ହାନ୍‌, ୱାନ୍‌ ଉନ୍‌ଡ୍ରି ଅଙ୍ଗୁର୍‍ କିଡ଼ିଇ କିତାନ୍‌ନୋ ସାରିବେଡ଼୍‍ତି କୋଅଟି ସୋସ୍‌ତାନ୍‌ ମାରି ଆୟା ଲୋଇ ଦାକ୍ଷ୍ରାକୁଣ୍ତ୍ କାରିତାନ୍‌ନୋ କାପ୍‍କିନି ସାମ୍‍ଣ୍ତା ତିଆର୍‌କିତାନ୍‌, ମାରି ବାଗ୍‍ତୁ ପାଣିକିନିୱାରିଙ୍ଗ୍‌ ଆୟା ଡଡି ବାଗ୍‌ତାନ୍‌ ସିତାନ୍‌ନୋ ଆଇଦେସ୍‌ତୁ ସୋର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ଅଙ୍ଗୁର୍‌କଡ଼ି କୟ୍‍ନିୱାଲେ ୱାନ୍‌ ବାଗ୍‌ତୁପାଣିକିନି ୱାରି ଲାକ୍‌ତୁ ନିଜେଦି ବାଗ୍ ଲସ୍‌ତେଙ୍ଗ୍‌ ଇଜି ନିଜେଦି ଗତିମୁରୁଲିଙ୍ଗ୍‌ ପୋକ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ମାତର୍‌ ବାଗ୍‍ତୁ ପାଣିକିନିକାର୍‌ ଆୟା ଗତିମୁରୁଲିଙ୍ଗ୍‌ ଆସ୍‌ତାରୋ ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ଡାକ୍‌ତାର୍‌, ଆଇ ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ସାୟାମାର୍‌ଗାଡାକ୍‌ତାର୍‌, ମାରି ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ କାଲ୍‌କୁ ପୋକ୍‌ସି ଡାକ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ମାରି କିଡ଼ିଇ ମାଲିକ୍‌ ନାଣ୍ତ ଲୋକାଙ୍ଗ୍‌ ଆଇ ପାଣିକିନି ଗତିମୁରୁଲିଙ୍ଗ୍‌ ପୋକ୍‌ତାନ୍‌ ମାରିଡ଼େସି ପୋକ୍‌ତାନ୍‌ । ୱାରିଉଣ୍ତିଙ୍ଗ୍‌ ବା ବାଗ୍‍ତୁ ପାଣିକିନିକାର୍‌ ଆୟାୱାଜା କିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ସାରାସାରିୱେନ୍‌କା କିଡ଼ିଇ ମାଲିକ୍‌ ନିଜେଦି ମାରିନ୍‌ତିଙ୍ଗ୍‌ ବାଗ୍‌ତୁପାଣିକିନି ୱାରି ଲାକ୍‌ତୁ ପୋକ୍‌ତାନ୍‌, ୱାନ୍‌ ଅଡ଼ବିତାନ୍‌, ୱାର୍‌ ୱାନି ମାରିନ୍‌ତିଙ୍ଗ୍‌ ମାନାନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","ମାତର୍‌ ବାଗ୍‍ତୁ ପାଣିକିନିକାର୍‌ ମାଲିକ୍‌ତି ମାରିନ୍‌ତିଙ୍ଗ୍‌ ସୁଡ଼ୁତାରୋ ୱାରି ୱାରି ଲୋଇ ୱାର୍‍ଗିତାର୍‍, ଇୟାକାନ୍‌ ସୁଡ଼ୁଦୁ, ମାଲିକ୍‌ଦି ମାରିନ୍‌ । ରାଦୁ, ୱେନିଙ୍ଗ୍‌ ବା ସାୟାମାର୍‌ଗା ଡାକ୍‍ନାଟ୍‍, ଆର୍‌ତିଙ୍ଗ୍‌ ସମ୍ପତ୍ତି ମାଦିଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ଆବେଟ୍‌ ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଆସ୍‌ସି କିଡ଼ିଇଦାନ୍‌ ପେରିତାରୋ ଆତେରେ ସାୟାମାର୍‌ଗା ଡାକ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ଜିସୁ ୱେନ୍‌ବାତାନ୍‌, “ଇଲେଇ, ଏସ୍ତିୱାଲେ କିଡ଼ିଇଦି ମାଲିକ୍‍ ୱାନାନ୍‌, ୱାନ୍‌ ବାଗ୍‍ତାନ୍‍ ପାଣିକିନିୱାରିଙ୍ଗ୍‌ ଇନିକା କିନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ୱାର୍‌ ଇର୍ହାର୍‌, “ଆୟା ତାଗ୍‌ଇୱାରିଙ୍ଗ୍‌ ୱାନ୍‌ ପୁରା ଡାକ୍‌ନାନ୍‌ ମାରି ଆମା ବାଗ୍‍ତାନ୍‍ପାଣିକିନିକାର୍‌ ସାମାନ୍‍ ବେଡ଼ାଦୁ ୱାନି ବାଗ୍ ପଲ୍‌ ସିନାର୍‍, କିଡ଼ିଇ ୱାରି କିୟୁଦୁ ଡ଼ିସ୍‌ନାସିନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ଇୟା ଦାର୍ମୁସାସ୍ତ୍ର ମାଟା ଇନିକା ମିର୍‌ ପଡ଼ାଇଦେର୍‌, ଆମା କାଲୁଦିଙ୍ଗ୍‌ ଇଲୁକୁ ତିଆର୍‌କିନିକାର୍‌ ପାଣିସିଏତ୍‌ଇଜି ଡ଼ିସ୍‌ତାସିତାମାର୍ହାର୍‌, ଆକାନେ ପେରିକା କନାଦି କାଲୁ ଆତାତ୍‌ । ପ୍ରବୁ ନିଜେ ଇକା ଇର୍‌ଆମାନାନ୍‌ । ପ୍ରବୁଦି ପାଣି ୱିଜୁ ଏସା କାବାନିକା ? ");
INSERT INTO kfcp_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","ଜିସୁ ମାରି ଇର୍ହାନ୍‌, ଆଦେଙ୍ଗ୍‌ ମିଙ୍ଗିଁ ଇଜିନା, ମାପୁରୁଦି ରାଜି ମିମାଣ୍‌କୁ ଅଆୟ୍‌ଆନାତ୍‌ ମାରି ଆମା ଲୋକୁ ମାପୁରୁଦି ବଦାଦାନ୍ ପାଣିକିନାର୍‍, ୱାରିଙ୍ଗ୍‌ ଆକା ସିଆଇଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ମାରି ଏନ୍‌ ଇୟା କାଲୁ ମୁସ୍‌କୁ ଆର୍‍ନାନ୍‍, ୱାନ୍‌ ମକା ମକା ଆନାନ୍‌, ମାରି ଇୟା କାଲୁ ଆମାୱାନି ମୁସ୍‌କୁ ଆର୍‍ନାତ୍‍, ୱାନିଙ୍ଗ୍‌ ଆକା ଗୁଣ୍ତ୍‍ଗୁଣ୍ତା କିନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ପେରି ଜାଜକର୍‌ ନି ପାରୁସିର୍‌ ଇୟା କାତାଦି ମାଟା ୱେନ୍‌ଞ୍ଜି ଜିସୁ ୱାରିଙ୍ଗ୍‌ ସୁଡ଼ୁଜି ଇଜିନାନ୍‍ଇଜି ବୁଜାଦେଙ୍ଗ୍‌ ଆଟ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ମାରି, ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଆସ୍‌ତେଙ୍ଗ୍‌ ସେସ୍ଟାକିତାର୍‌, ମାତର୍‌ ଲୋକା ଗଲି ତିଏଲ୍‍ତିଙ୍ଗ୍‌ ୱାର୍‌ ଆକା କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏତାର୍‍, ଇରିଙ୍ଗ୍‌ ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ଅରେନ୍‍ ବାବବାଦି ଇଜି ଅଡ଼ବିଜି ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ଜିସୁ ମାରିଡ଼େସି କାତାଦାନ୍‌ ଲୋକାଙ୍ଗ୍‌ ୱେର୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","ମାପୁରୁଦିରାଜି ଇୟାୱାଜା । ଅର୍‍ଲେନ୍‍ ଅରେନ୍‍ ରାଜା ନିଜେଦି ମାରିନ୍‌ତିଙ୍ଗ୍‌ ପେଡ଼ି ବୋଜି ତିଆର୍‌କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","କୁକ୍‌ତିମାରିଇ ଲୋକାଙ୍ଗ୍‌ ବୋଜିଦୁ କୁକ୍‍ସ ତାତେଙ୍ଗ୍‌ ଇଜି ୱାନ୍‌ ସାକର୍‌କାଙ୍ଗ୍‌ ପୋକ୍‌ତାନ୍‌ । ମାତର୍‌ ଆୟା ଲୋକୁ ୱାଦେଙ୍ଗ୍‌ ବଦା କିଏତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ରାଜା ମାରିଡ଼େସି ଆଇ ସାକର୍‌ଙ୍ଗାଁ ମାଣ୍‌କୁ ଇୟା କାବୁର୍‌ ୱେର୍‌ସି ପୋକ୍‌ତାନ୍‌, ପେଡ଼ି ବୋଜି ତିଆର୍‌ଆତାତ୍‌ନି, ବାଲ୍‌ସିତି ବାଲ୍‌ସିତି କଡି ମାରି ଗାଡ଼ାଲ୍‌ କୟ୍‌ତାରୋ ୱିଜୁ ତିଆର୍‌ଆତାମାନାତ୍‌, ବୋଜିଦୁ ବେଗି ରାଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ମାତର୍‌ ୱାର୍‌ ଇୟା ମାଟାଦିଙ୍ଗ୍‌ ଆସ୍‌ଏଣ୍‌ଗା ନିଜେନିଜେଦି ପାଣି କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ ଅରେନ୍‍ ୱାନି କିଡ଼ିଇଦୁ ସୋର୍ହାନ୍‌, ମାରି ଅରେନ୍‍ ନିଜେଦି ଦୁକାନ୍‌ତୁ ସର୍ହାନ୍‌ ");
INSERT INTO kfcp_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ମାରି ଏସ ଲୋକୁ ରାଜାଦି ସାକର୍‌କାଙ୍ଗ୍‌ ଆସ୍‌ତାରୋ ଡାକ୍‌ସି ଡାକ୍‌ସି ସାୟାମାର୍‌ଗାଡାକ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ରାଜା ନାଣ୍ତ ରିସା ଆଜି ସନ୍ୟରିଙ୍ଗ୍‌ ପୋକ୍‌ତାନ୍‌, ୱାର୍‌ ଆୟା ସାୟାମାର୍‌ଗାଡାକ୍‌ତି ୱାରିଙ୍ଗ୍‌ ସାୟାମାର୍‌ଗାଡାକ୍‌ତାରୋ ୱାରି ଗାଡ଼୍‌ତିଙ୍ଗ୍‌ ଆଡ୍‌କାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ତାନେ ୱେନ୍‌କା ରାଜା ସାକର୍‌କାଙ୍ଗ୍‌ କୁକ୍‌ତାନ୍‌ନୋ ଇର୍ହାନ୍‌, ନା ପେଡ଼ି ବୋଜି ତିଆର୍‌ ଆତାମାନାତ୍‌, ମାତର୍‌ ନାନ୍ କୁକ୍‌ତିମାରିଇ ଲୋକୁ ଜଗ୍‌ସିଲେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ଇଲେଇ ପେରି ପେରି ସାକ୍ଡ଼ିଆଙ୍ଗ୍ ସୋଲ୍‌ସ ଏସ ଲୋକାଙ୍ଗ୍‌ ପଇନିଦେର୍‌, ୱିଜେରିଙ୍ଗ୍‌ ମା ବୋଜିଦୁ କୁକ୍‌ସତାଗାଟ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ଆବେଟ୍‌ ସାକର୍‌କୁ ସାକ୍‌ଡ଼ିଦିଙ୍ଗ୍‌ ସାକ୍‌ଡ଼ି ବୁଲାଜି ନେଗିକାନ୍‌ଆପିନ୍‌ ମାରି ତାଗ୍‌ଇକାନ୍‌ଆପିନ୍‌; ଏସ ଲୋକାଙ୍ଗ୍‌ ପୋୟ୍‌ତାର୍‌, ୱିଜୁ ଲୋକାଙ୍ଗ୍‌ କୁକ୍‌ତା ତାତାର୍‌ ମାରି ପେଡ଼ି ଇଲୁଦୁ ବର୍ତିଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“ରାଜା କୁଡ଼ାଆଙ୍ଗାଁ ସୁଡ଼ୁଦେଙ୍ଗ୍‌ ୱାତାନ୍‌ । ୱାନ୍‌ ସୁଡ଼ୁତାନ୍‌, ୱାରି ଲୋଇରାନ୍‌ ଅରେନ୍‍ ପେଡ଼ି ଆଙ୍ଗିଁ ଆରାଏନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ରାଜା ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, ବନ୍ଦୁ, ପେଡ଼ି ଆଙ୍ଗିଁ ଆରାଏଣ୍ତା ଏଣ୍ତେସ୍‌ ଇୟା ବାଡିଦୁ ୱାତି ? ଆୟାକାନ୍‌ ଆଲେତାନୋ ତେବାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ରାଜା ସେବାକିନିକାଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ୱାନି କିକୁ ପାଦାମ୍‌କୁ ତର୍‌ସୋ ଆତେରେ ସିକାଟିଦୁ ପୋକ୍‌ତୁ । ଆବେନୁ ୱାନ୍‌ ଆଡ଼ାବାଜି ୱାନି ପାଲୁକୁ କାତ୍ରେକିନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","କାତା ୱେର୍‌ତେଙ୍ଗ୍‌ ୱିସ୍‌ତାନ୍‌ନୋ ଜିସୁ ଇର୍ହାନ୍‌, “ନାଣ୍ତ ଲୋକୁ କୁକାୟ୍‍ଆତାମାନାର୍, ମାତର୍‌ ଉଣା ଲୋକୁ ବାସେଆତାମାନାର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ଏସଲୋକ୍‌ ପାରୁସିର୍‌ ସଲ୍‌ସି ଜିସୁଙ୍ଗୁଁ ପ୍ରସ୍ନ ୱେନ୍‌ବାଜି ୱାନିଙ୍ଗ୍‌ ଗୁଟାଦୁ ଆରେପ୍‌ତେଙ୍ଗ୍‌ ଇଜି ଉପାୟ୍‌ ପୟ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ୱାର୍‌ ନିଜେଦି ଏସଲୋକ୍‌ ସିସୁରିଙ୍ଗ୍‌ ମାରି ହେରୋଦ ଦଲତୀ ଏସ ଲୋକାଙ୍ଗ୍‌ ଜିସୁଦି ଲାକ୍‌ତୁ ପୋକ୍‌ତାର୍‌ । ୱାର୍‌ ୱାଜି ଜିସୁଙ୍ଗୁଁ ଇର୍ହାର୍‌, “ଏ ଗୁରୁ, ମାପ୍‌ ନେସ୍‌ନାପ୍‌, ନିନ୍‌ ସତ୍‌ ଇନି ମାରି ନିନ୍‌ ମାପୁରୁଦି ସତ୍‌ ବିସୟ୍‌ତାନ୍‌ ସିକିୟା ସିନି । ମାରି ଆଇକାର୍‌ ଇନିକା ଅଡ଼୍‍ବିନାର୍‍ ଆୟା ବିସୟ୍‌ତାନ୍‌ ବେମ୍‍ରିଆଇ, ଇରିଙ୍ଗ୍‌ ନିନ୍‌ ଏମେୱାରି ମାଟାଦିଙ୍ଗ୍‌ ମନ୍‍ସିଇ । ");
INSERT INTO kfcp_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ଆର୍‌ତିଙ୍ଗ୍‌ ମାଙ୍ଗିଁ ଇନିଆ, ଇୟା ବିସୟ୍‌ତାନ୍‌ ନି ମାଟାଇନିକା ? କାଇସର୍‍ ରାଜେଙ୍ଗ୍‌ ସିସୁଟୁ ସିନିକା ନିୟମ୍‌ତି ଇସାବ୍‌ତାନ୍‌ ଟିକ୍‌ ନୋ ବୁଲ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ମାତର୍‌ ଜିସୁ ୱାରି ତାଗ୍‌ଇ ଉପାୟ୍‌ ନେସ୍‌ସି ଇର୍ହାନ୍‌, “ଏ କପଟିର୍‌, ନାଙ୍ଗିଁ ଗୁଟାଦୁ ଆରେପ୍‌ତେଙ୍ଗ୍‌ ଏନ୍ଦା ସେସ୍ଟାକିଜିନିଦେର୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ଆମା ଅଦଲିଦାନ୍‌ ସିସୁଟୁ ତର୍‌ସିନିଦେର୍‌, ଆବେନୁ ଉନ୍‌ଡ୍ରି ତାସ ନାଙ୍ଗିଁ ତର୍‌ତୁ !” ୱାର୍‌ ଉନ୍‌ଡ୍ରି ଅଦ୍‌ଲି ଡାବୁଙ୍ଗ୍‌ ତାତାରୋ ୱାନିଙ୍ଗ୍‌ ସିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ଇୟା ଅଦ୍‌ଲି ମୁସ୍‌କୁ ଏ ବମା ମାରି ଦର୍‌ ମାନାତ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ୱାର୍‌ ଇର୍ହାର୍‌, କାଇସର୍‍ଦି, “ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ଆର୍‌ତିଙ୍ଗ୍‌ ଆମାକା କାଇସର୍‍ଦି, ଆକା କାଇସର୍‍ ରାଜେଙ୍ଗ୍‌ ସିଦୁ ମାରି ଆମାକା ମାପୁରୁଦି, ଆକା ମାପୁରୁଙ୍ଗ୍‌ ସିଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ୱାର୍‌ ଇକା ୱେନ୍‌ଞ୍ଜି କାବାଜି ୱାନିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ସି ସୋର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ଆୟାନାଣ୍ତିଙ୍ଗ୍‌ ସାଦୁକି ଦଲତୀ ଏସ ଲୋକୁ ଜିସୁଦି ଲାକ୍‌ତୁ ୱାତାର୍‌ । ସାଦୁକିର୍ ବିସ୍‌ବାସ୍‌କିଜି ମାର୍ହାର୍‌ ଜେ, ମାରିଡ଼େସିନିଙ୍ଗିଁନିକା ସିଲେତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ୱେନ୍‌ବାତାର୍‌, “ଏ ଗୁରୁ, ମୋସା ଇର୍ହାମାନାନ୍‌, ଜଦି ଅରେନ୍‍ ଲୋକୁ କଡ଼କକ୍‌ରା ଆଏଣ୍ତା ସାନାସନାନ୍‌, ଆର୍‌ତିଙ୍ଗ୍‌ ୱାନି ତଡ଼ାନ୍‌ ୱାନି ଆଡ଼୍‌ସିଙ୍ଗ୍‌ ପେଡ଼ି ଆନାନ୍‌ ମାରି ୱାରି କଡ଼ର୍‌ ଆୟା ସାତି ଲୋକ୍‌ତି କଡ଼ର୍‌ ଇଜି ସିନାଆନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ୱେନ୍‌ଡ୍ରୁ, ମା ଲୋଇ ସାତ୍‌ଲୋକ୍‌ ତଡ଼ାନ୍‌କୁ ମାର୍ହାର୍‌ । ପେରି ତଡ଼ାନ୍‌ କଡ଼କକ୍‌ରା ଆଏଣ୍ତା ସାତା ସର୍ହାନ୍‍ ଆକା ୱାନି ୱେନ୍‌କାରି ତଡ଼ାନ୍‌ ତଡ଼ାନ୍‌ତି ଆଡ଼୍‌ସିଙ୍ଗ୍‌ ପେଡ଼ିଆତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ମାତର୍‌ ଇୟାୱାନି ୱେନ୍‌କାରିକାନ୍‌, ମଜାୟ୍‍ଏନ୍‌ ମାରି ସାରାସାରି ସାତ୍‌ଲୋକ୍‌ ସାନ୍ଦି ଆୟାୱାଜା ଗଟାତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ସାରାସାରିୱେନ୍‌କା ଆୟା ଆଇମା ସାତା ସୋର୍‌ର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ଆମା ନାଣ୍ତିଙ୍ଗ୍‌ ସାତି ଲୋକୁ ମାରିଡ଼େସିନିଙ୍ଗିଁନାର୍‌, ଇୟା ଆଇମା ଏ ଆଇମା ଇଜି ସିନାଆନାତ୍‌ ? ୱିଜେର୍‌ତ ତାନିଙ୍ଗ୍‌ ପେଡ଼ି ଆତାମାର୍ହାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମିର୍‌ ଏସ ବାୟାର୍ ! ଦାର୍ମୁସାସ୍ତ୍ର ନି ମାପୁରୁଦି ସାକ୍ତି ନେସ୍‌ଇଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ମାରିଡ଼େସିନିଙ୍ଗିଁନି ୱେନ୍‌କା ସାତି ଲୋକୁ ୱିଜେରେ ମୁସ୍‌କୁପୁର୍‌ତି ଦୁତ୍‍କା ୱାଜା ତେବାନାର୍‌ । ୱାର୍‌ ପେଡ଼ିଆଏର୍‌ କି ପେଡ଼ି କିଏର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ସାତି ଲୋକୁ ମାରିଡ଼େସିନିଙ୍ଗିଁନି ବିସୟ୍‌ତାନ୍‌ ମାପୁରୁ ଆମାକା ୱେର୍‌ତାମାନାନ୍‌, ମିର୍‌ ଇନିକା ସାସ୍ତ୍ରଦୁ ଏସ୍‌କାଙ୍ଗ୍‌ ପଡ଼ାଇଦେର୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","ମାପୁରୁ ଇର୍‌ଆମାନାନ୍‌, ମାପ୍‌ ଅବ୍ରାହାମ, ଇସ୍‌ହାକ୍‌ ମାରି ଜାକୁବଦି ମାପୁରୁ ।” “ୱାନ୍‌ ଜିବନ୍‌ମାନିୱାରି ମାପୁରୁ ସାତିୱାରି ମାପୁରୁ ଆଏନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ଲୋକୁ ଜିସୁଦି ସିକିୟା ୱେନ୍‌ଞ୍ଜି କାବାଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ଏସ୍ତିୱାଲେ ପାରୁସିର୍‌ ୱେର୍‌ଆର୍‌ ଜେ ଜିସୁ ସାଦୁକିରିଙ୍ଗ୍‌ ଚୁପ୍‌କିବିସ୍‌ତାମାନାନ୍‌, ୱାର୍‌ ଉନ୍‌ଡ୍ରେମାନୁ ଆଜି ଜିସୁଦି ଲାକ୍‌ତୁ ୱାତାର୍‌ ");
INSERT INTO kfcp_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ମାରି ୱାରି ମାଣ୍‌କୁ ଅରେନ୍‍ ଦାର୍ମୁଗୁରୁ ଜିସୁଙ୍ଗୁଁ ଗୁଟାଦୁ ଆରେପ୍‌ତେଙ୍ଗ୍‌ ଇଜି ଉନ୍‌ଡ୍ରି ମାଟା ୱେନ୍‌ବାତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","ୱାନ୍‌ ୱେନ୍‌ବାତାନ୍‌ “ଗୁରୁ, ମୋସାଦି ନିୟମ୍‌ତୁ ଆମା ଆଜ୍ଞା ୱିଜେରିମାଣ୍‌କୁ ପେରିକା ?” ");
INSERT INTO kfcp_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ମି ପ୍ରବୁ ମାପୁରୁଙ୍ଗ୍‌ ପୁରାୱିଜୁ ଜିବନ୍‌, ପୁରାୱିଜୁ ମେନ୍ଧଲ୍‌ ମାରି ପୁରାୱିଜୁ ମନ୍ ସିଜି ଜିବନ୍‌ ନଆ । ");
INSERT INTO kfcp_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ଇକା ଆଜିନାତ୍‍ ୱିଜେରିମାଣାନ୍‌ ପେରିକା ମାରି ପେରିମାଟା । ");
INSERT INTO kfcp_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","“ମାରି ଉନ୍‌ଡ୍ରି ପେରି ଆଜ୍ଞା ଆଜିନାତ୍‍, ମି ଲାକ୍‌ତୁରି ଲୋକାଙ୍ଗ୍‌ ନିଜେଦିଙ୍ଗ୍‍ ଜିବନ୍‌ନୋତିୱାଜା ନୋଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ଇୟା ରୁଣ୍ତି ମାଟେଙ୍ଗ୍‌ ମୁସ୍‌କୁ ମୋସାଦି ୱିଜୁ ନିୟମ୍‌ ମାରି ବାବବାଦିରି ସିକିୟା ଆସାଇଡ୍‍ନାତ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ଏସ୍ତିୱାଲେ ପାରୁସିର୍‌ ଉଣ୍ତାତା ମାର୍ହାର୍‌, ଜିସୁ ୱାରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“କ୍ରିସ୍ତ ଅର୍ତ ମସିହଦି ବିସୟ୍‌ତାନ୍‌ ମିର୍‌ ଇନିକା ଅଡ଼୍‍ବିଜିନିଦେର୍‍ ? ୱାନ୍‌ ଏ କୁଟୁମ୍‌ ?” ୱାର୍‌ ଇର୍ହାର୍‌, “ୱାନ୍‌ ଦାଉଦଦି କୁଟୁମ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ଜିସୁ ୱେନ୍‌ବାତାନ୍‌, ଆର୍‌ତିଙ୍ଗ୍‌ ଦାଉଦ ମସିହଙ୍ଗ୍‌ “ନା ପ୍ରବୁ” ଇଜି ଏନ୍ଦା ଇର୍ହାମାନାନ୍‌ ? ଇରିଙ୍ଗ୍‌ ଆତ୍ମା ୱେର୍‍ନିମାଣାନ୍‍ ୱାନ୍‌ ରାସ୍‌ତାମାନାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","ପ୍ରବୁ ନା ପ୍ରବୁଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ମାପ୍‌ ମି ସାତ୍ରୁରିଙ୍ଗ୍ ମି କାଲ୍‌କା ଆଡ୍‍ଗି କିଇ ସାନ୍ଦି ମିର୍‌ ମା ଉଣି ତରିନ୍‌ ବାସ୍‌ତୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ଜଦି ଦାଉଦ ମସିହଙ୍ଗ୍‌ ନା ପ୍ରବୁ, ଇଜି ମାନାତା ମାନାନ୍‌, ଆର୍‌ତିଙ୍ଗ୍‌ କ୍ରିସ୍ତ ଅର୍ତ ମସିହ ଏଣ୍ତେସ୍‌ ଦାଉଦତି ମାରିନ୍‌ ଆଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାନ୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ଜିସୁଙ୍ଗୁଁ ଏନ୍‌ ଇୟାତାନି ଉତର୍‌ ସିଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏତାର୍‍ । ଆୟା ନାଣ୍ତିରାନ୍‌ ଏନ୍‌ ୱାନିଙ୍ଗ୍‌ ମାରି ପ୍ରସ୍ନ ୱେନ୍‍ବାଦେଙ୍ଗ୍‍ ସାସ୍‌ କିଏତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ଜିସୁ ସିସୁରିଙ୍ଗ୍‌ ମାରି ୱିଜୁଲୋକାଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","ଦାର୍ମୁଗୁରୁ ମାରି ପାରୁସିର୍‌ ମୋସାଦି ନିୟମ୍‌ତିଙ୍ଗ୍‌ ସିକିୟା ସିଦେଙ୍ଗ୍‍ ଅଦିକାର୍‌ ପୟ୍‍ତିମାନି ୱେର୍‌ନିକାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ଆଦେଙ୍ଗ୍‌ ୱାର୍‌ ଆମାକା କିଦେଙ୍ଗ୍‌ ୱେର୍‌ସିନାର୍‌, ଆକା କିଦୁ । ମାତର୍‌ ୱାରି ପାଣି ଇସାବ୍‌ତାନ୍‌ ପାଣି କିମାଟ୍‌ । ଇରିଙ୍ଗ୍‌ ୱାର୍‌ ନିଜେ ୱେର୍‌ସିମାନି ସିକିୟା ଇସାବ୍‌ତାନ୍‌ ପାଣି କିଏର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ୱାରି ସିକିୟାୱିଜୁ ଲୋକା ମୁଟାମ୍‌ ମୁସ୍‌କୁ ନାଣ୍ତ ବଜୁ ୱାଜା ତିଗ୍‌ନାସିନାର୍‌, ମାତର୍‌ ଆୟାୱିଜୁ ବଜୁ ପିଣ୍ତିଦେଙ୍ଗ୍‌ଇଜି ନିଜେଦି ଡ଼ାସ୍‌କାଦାନ୍‌ ବା ଅଡ଼ପ୍‍ବା ସାକା କିଏର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ୱାର୍‌ ଲୋକାଙ୍ଗ୍‌ ତର୍‌ତେଙ୍ଗ୍‍ଁ ଇଜି ୱିଜୁ ପାଣି କିନାର୍‌ । ସୁଡ଼ୁଦୁ, ୱାର୍‌ ସାସ୍ତ୍ର ପଦ୍‌ ରାସାତିମାନି ଏସି ଏସି ମାଟେଙ୍ଗ୍‌ ମୁଜୁଦୁ ନି ରେକାଦୁ ତରାତାମାନାର୍‌ । ମାରି ସୁଡ଼ୁଦୁ, ୱାର୍‌ ଆରାନିମାନି ପେରି ପେରି ୱାତିଦି ଜାଲିଙ୍ଗ୍‌ ୱିଜୁ ଏସ ନିରିକା । ");
INSERT INTO kfcp_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ୱାର୍‌ ବଜିଙ୍ଗାଁ ନେଗି ବାଡି ମାରି ପାର୍‍ତନାକିନି ଇଲ୍‌କାଙ୍ଗ୍‌ ପେରି ବାଡି ଅଦିକାର୍‌ କିଦେଙ୍ଗ୍‌ ନେଗେନ୍‌ଅଡ଼୍‌ବିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ମାରି ସାତାସାଉକାଦୁ ମାଡ଼ିସ୍‍କିନିକା ପୟ୍‌ଦେଙ୍ଗ୍‌ ମାରି ଲୋକା ମାଣାନ୍‌ ଏ ଗୁରୁ, ଇଜି ମାନାଦେଙ୍ଗ୍‌ ନେଗେନ୍‌ଅଡ଼୍‌ବିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ମାତର୍‌ ମିଙ୍ଗିଁ ଏନ୍‌ ଗୁରୁ ଇଜି କୁକ୍‌ନିକା ଟିକ୍‌ ସିଲେ । ଇରିଙ୍ଗ୍‌ ମିର୍‌ ୱିଜିଦେର୍‌ ନିଜେନିଜେଦି ତଡ଼ାନ୍‌କୁ ମାରି ମି ଗୁରୁ କେବଲ୍‌ ଅରେନ୍‌ନେ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ମାରି ଦୁନିଆଦୁ ମିର୍‌ ଏଙ୍ଗ୍‌ବା ବୁବା ଇଜି ମାନାନିକା ଟିକ୍‌ ସିଲେ, ଇରିଙ୍ଗ୍‌ ମି ବୁବା ଅରେନ୍‌ନେ, ୱାନ୍‌ ମୁସ୍‌କୁପୁର୍‌ତୁ ମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ମିଙ୍ଗିଁ ମାଲିକ୍‌, ଇଜି ଏନ୍‌ବା କୁକ୍‌ମାକିନ୍‌, ଇରିଙ୍ଗ୍‌ ମି ଅରେନ୍‌ମାତର୍‌ ମାଲିକ୍‌ ଆଜିନାନ୍‍ ମସିହ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ମି ଲୋଇରାନ୍‌ ଏନ୍‌ ୱିଜେରିମାଣାନ୍‌ ପେରିକାନ୍‌, ୱାନ୍‌ ମି ସେବା କିପିନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ଏନ୍‌ ନିଜେଦିଙ୍ଗ୍‌ ମୁସ୍‌କୁ ପେରାନାନ୍‌, ୱାନିଙ୍ଗ୍‌ ଆଡ୍‍ଗି କିନାର୍‌ ମାରି ଏନ୍‌ ନିଜେଦିଙ୍ଗ୍‌ ଆଡ୍‍ଗି କିଆନାନ୍‌, ୱାନିଙ୍ଗ୍‌ ମୁସ୍‌କୁ ପେରିସିକିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ଏ ଦାର୍ମୁଗୁରୁ ନି ପାରୁସିର୍‌ ମି ୱେନ୍‌କାରି ଦସ୍‌ ଏସା ବୟ୍‌ଙ୍କାର୍‌ ! ଏ ସାଲାକି ଦାର୍ମୁଦଲ୍‌, ମୁସ୍‌କୁପୁର୍‌ରାଜିଦି ଡ଼ୁଗୁନି ସେର୍‌ଲା କେର୍‌ତିମାନିଦେର୍‌ । ମିର୍‌ ନିଜେ ଆବେ ଡ଼ୁଗୁଇଜିନିଦେର୍‌ ମାରି ଆମାକାର୍‌ ଡ଼ୁଗୁଦେଙ୍ଗ୍‌ ବଦାକିଜିନାର୍‌, ୱାରିଙ୍ଗ୍‌ ସାରି ଡ଼ିସ୍‌ଇଜିନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ଏ କପଟି ଦାର୍ମୁଗୁରୁ ନି ପାରୁସିର୍‌, ମି ଦସ୍‌ ଏସା ତାଗ୍‌ଇକାଆନାତ୍‌ । ଇରିଙ୍ଗ୍‌ ମିର୍‌ ସାଲାକିଦାନ୍‍ ନିର୍‌ଇ ପାର୍‌ତାନା କିନି ଦାପେ ଦାପେ ରାଣ୍ତି ଆଇମେକା ଇଲୁକୁ ୱିଜୁ ଡ଼ିବିସ୍‌ସୋ ଅନିଦେର୍‌; ଆଦେଙ୍ଗ୍‌ ମିର୍‌ ନାଣ୍ତ ଦଣ୍ଡ୍‌ ପଇନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","ଏ କପଟି ଦାର୍ମୁଗୁରୁ ନି ପାରୁସିର୍‌, ମି ଦସ୍‌ ଏସା ତାଗ୍‌ଇକାଆନାତ୍‌ । ମିର୍‌ ସାମୁଦୁର୍‌ ନାସି ଆଇ ଦେସ୍‌କାଙ୍ଗ୍‌ ସୋଲ୍‌ସି ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ମି ଦାର୍ମୁଦୁ ମିସାକିଦେଙ୍ଗ୍‌ ଇଜି ପୟ୍‌ଜିବୁଲାଜିନିଦେର୍‌ । ମାତର୍‌ ଆୟାୱାଜା ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ପୟ୍‌ତିଙ୍ଗ୍‌, ୱାନିଙ୍ଗ୍‌ ନରକଦୁ ଦଣ୍ଡ୍‌ ପୟ୍‌ଦେଙ୍ଗ୍‌ ମିମାଣାନ୍‌ ଦୁଇଗୁଣୁ ନାଣ୍ତ ସାକା କିଜିନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","ଏ କାଣା ସାରିବୁଲାନିକାର୍‌, ମି ଦସ୍‌ ଏସ ତିଲାନିକା । ମିର୍‌ ସିକିୟା ସିଜିମାନିଦେର୍‌, ଏନ୍‌ ମନ୍ଦିର୍‌ ଦର୍‌ତାନ୍‌ ପାରାମାଣ୍‌ କିତିଙ୍ଗ୍‌, ଆକା ୱାନ୍‌ କିଦେଙ୍ଗ୍‌ କୁସାମାତ୍‌ ସିଲେ; ମାତର୍‌ ମନ୍ଦିର୍‌ତୁ ମାନି ବାଙ୍ଗାଁରାମ୍‍ ଦର୍‌ତାନ୍‌ ଏନ୍‌ ପାରାମାଣ୍‌ କିତିଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ ଆକା କିଦେଙ୍ଗ୍‌ ପଡ଼ାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ଏ କାଣା ବୁଦି ସିଲିକିଦେରା, ବାଙ୍ଗାଁରାମ୍‍ ପେରିକା ନୋ ବାଙ୍ଗାଁରାମ୍‍ତିଙ୍ଗ୍‌ ପବିତ୍ର କିଜିମାନି ମନ୍ଦିର୍‌ ପେରିକା ? ");
INSERT INTO kfcp_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ମିର୍‌ ବା ସିକିୟା ସିଜିମାନିଦେର୍‌, ଅରେନ୍‍ ଲୋକୁ ବେଦି ଦର୍‌ତାନ୍‌ ପାରାମାଣ୍‌ କିତିଙ୍ଗ୍‌, ୱାନ୍‌ ଆକା କିଦେଙ୍ଗ୍‌ କୁସାମାତ୍‌ ସିଲେ । ମାତର୍‌ ବେଦି ମୁସ୍‌କୁ ଇଡିନିମାନି ପୁଜାସିନି ଦର୍‌ତାନ୍‌ ପାରାମାଣ୍‌ କିତିଙ୍ଗ୍‌, ଆକା ନିୟମ୍‌ସିଲେତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ମିର୍‌ ଏସା କାଣାର୍‌, ଆମାକା ପେରି ପୁଜାସିନିକା ନୋ ପୁଜାସିନିତାନିଙ୍ଗ୍‌ ପବିତ୍ର କିଜିମାନି ବେଦି ? ");
INSERT INTO kfcp_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ମାରି ଏନ୍‌ ବେଦି ଦର୍‌ତାନ୍‌ ପାରାମାଣ୍‌ କିତିଙ୍ଗ୍‌, ୱାନ୍‌ ବେଦି ମାରି ଆୟା ମୁସ୍‌କୁ ମାନି ୱିଜୁ ପୁଜାସିନି ସାମାନ୍‌କା ଦର୍‌ତାନ୍‌ ପାରାମାଣ୍‌ କିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ଏନ୍‌ ମନ୍ଦିର୍‌ ଦର୍‌ତାନ୍‌ ପାରାମାଣ୍‌ କିତିଙ୍ଗ୍‌ ୱାନ୍‌ ମନ୍ଦିର୍‌ ମାରି ଆବେନୁ ବାସାଜିମାନି ମାପୁରୁ ଦର୍‌ତାନ୍‌ ପାରାମାଣ୍‌ କିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ମାରି, ଏନ୍‌ ମୁସ୍‌କୁପୁର୍‌ତି ଦର୍‌ତାନ୍‌ ପାରାମାଣ୍‌ କିତିଙ୍ଗ୍‌, ମାପୁରୁଦି ରାଜାଗାଦି ମାରି ତାନିମୁସ୍‌କୁ ବାସ୍‌ତିମାନି ମାପୁରୁ ଦର୍‌ତାନ୍‌ ପାରାମାଣ୍‌ କିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ଏ କପଟି ଦାର୍ମୁଗୁରୁ ନି ପାରୁସିର୍‌, ମି ଅବସ୍ତା ବେସି ତାଗ୍‌ଇକାଆନାତ୍‌ ! ମିର୍‌ ମାପୁରୁଦି ଉଦେସ୍‌ଦାନ୍‌ ପୋଦିନା, ପାନ ମଊରି ମାରି ଜିରାଦି ବା ଦସ୍‍ବାଗ୍‍ତାନ୍‍ ଉଣ୍ତ୍ରି ବାଗ୍ ମାପୁରୁଙ୍ଗ୍‍ଁ ଦାନ୍‌ ସିନିଦେର୍‍; ମାତର୍‌ ନ୍ୟାୟ୍‌ ବିସାର୍‌, ଦୟା, ବିସ୍‌ବାସ୍‌ ଇୟାୱିଜୁ ନିୟମ୍‌ତି ପେରି ପେରି ବିସୟ୍‌କୁ ୱେଡ଼ା କିଜିନିଦେର୍‌ । ନିୟମ୍‌ତି ଇୟା ବିସୟ୍‌କୁ ଆଗ୍‌ଡ଼ି ଅବ୍ୟାସ୍‌ କିନିକା ମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ଏ କାଣା ସାରିଦୁବୁଲାନିକାର୍‌, ମିର୍‌ ଇନିକା ଉଣିୱାଲେ ଆନାତ୍‌ ଆବେ ୱିଜା ଆର୍‍ନାମାନାତ୍‍ ଇଜି ତାନିଙ୍ଗ୍‌ ଜଲପ୍‌ନିଦେର୍‍, ମାତର୍‌ ଉଟ୍‌ତିଙ୍ଗ୍‌ ଡ଼ିଙ୍ଗିଁନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ଏ କପଟି ଦାର୍ମୁଗୁରୁ ମାରି ପାରୁସିର୍‌, ଏସା ବୟଙ୍କାର୍‍ ମି ସାରାସାରି ବୁଲାନିକା । ମିର୍‌ ଡୁବାଇ ନି ସାଡ଼ାୱାଦି ଆତେରେ ତରିନ୍‌ ନେଗେନ୍‍ ନୋର୍‌ଜିମାନିଦେର୍‌, ମାତର୍‌ ଆୟାୱାନିକା ଲୋଇ ଗିଦ୍‌ରି ନି ଆକାର୍‍ ବର୍ତି ଆତାମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","“ଏ କପଟି ଦାର୍ମୁଗୁରୁ ମାରି ପାରୁସିର୍‌, ଆଗ୍‌ଡ଼ି ଡୁବାଇତି ଲୋଇରିକା ନେଗେନ୍‌ ନର୍‌ଦୁ, ଏଣ୍ତେସ୍‌ ଆବେଣି ଆତ୍‌ରେଦିକା ବା ନେଗେନ୍‍ ନୋର୍‌ଆୟ୍‌ଆନାତ୍‌ ! ");
INSERT INTO kfcp_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“ଏ କପଟି ଦାର୍ମୁଗୁରୁ ନି ପାରୁସିର୍‌ ! ମିର୍‌ ଏସା ନାଣ୍ତ ଦସ୍‌ ବଗାନିଦେର୍‌ । ମିର୍‌ ୱିଜୁ ଆତେରେ ତରିନ୍‌ ସୁନ୍‌ତିରିପାତିମାନି ମୁସ୍‌ତିବାଡିଦି ୱାଜା । ଆକା ଆତେରେ ସୁନ୍ଦର୍‌ ତର୍‌ନାତ୍‌, ମାତର୍‌ ଲୋଇ ପେଡେକ୍‌ ନି ସାବ୍‌ତି ମାଡ଼ାଦାନ୍‌ ବର୍ତି । ");
INSERT INTO kfcp_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ଆୟାୱାଜା ମିର୍‌ ବା ଆତେରେ ଲୋକା ଆଗ୍‌ଡ଼ି ନେଗେନ୍‌ ତର୍‌ନିଦେର୍‌, ମାତର୍‌ ମି ଲୋଇରିକା ସାଲାକି ନି ପାପ୍‌ତୁ ବର୍ତି । ");
INSERT INTO kfcp_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“ଏ କପଟି ଦାର୍ମୁଗୁରୁ ନି ପାରୁସିର୍‌ ! ମି ଉଣ୍ତିଙ୍ଗ୍‌ ଇକା ଏସା ବୟ୍‌ଙ୍କାର୍‌ । ବାବବାଦିରି ଉଣ୍ତିଙ୍ଗ୍‌ ମିର୍‌ ସୁନ୍ଦର୍‌ତି ମୁସ୍‌ନିବାଡି ତିଆର୍‌କିଜିନିଦେର୍‌ ମାରି ଦାର୍ମୁଲୋକାରି ଏତ୍‌କିନି ମୁଣ୍ତା ୱିଜୁ ରସ୍‍ସିନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ମାରି ମିର୍‌ ଇଜିନିଦେର୍‌, ଜଦି ମି ପୁର୍ବେଦିଡକ୍‌ରାଦାଦାରି ବେଡ଼ାଦୁ ମିର୍‌ ତେବାତିଙ୍ଗ୍‌ମାନ୍ଦି, ଆର୍‌ତିଙ୍ଗ୍‌ ୱାରି ୱାଜା କିଇତିଦେର୍‌ମାନ୍ଦି ମାରି ବାବବାଦିରିଙ୍ଗ୍ ଡାକ୍‌ଇତିଦେର୍‌ମାନ୍ଦି । ");
INSERT INTO kfcp_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ଇୟା ମାଟା ୱେର୍‌ନି ମାଣ୍‌କୁ ସତ୍‌ ଇଜି ମାନାଜିନିଦେର୍‌ ଜେ ମିର୍‌ ବାବବାଦିରିଙ୍ଗ୍ ସାୟାମାର୍‌ଗା ଡାକ୍‌ତିୱାରି କୁଟୁମ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ଆର୍‌ତିଙ୍ଗ୍‌ ମିର୍‌ ଆଗ୍‌ଡ଼ି ସାଦୁ, ମି ପୁର୍ବେଦିଡକ୍‌ରାଦାଦାରି ଆରାମ୍‌ କିତି ପାଣିଦିଙ୍ଗ୍‌ ପୁରା କିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ଏ ସାରାସ୍‍କୁ ! ଏ ବିସ୍‌ମାନି ସାରାସ୍‍ତି କଡ଼ର୍‌ ! ମିର୍‌ ନରକ ଦଣ୍ତ୍‌ତାନ୍‌ ରକ୍ଷାପୟ୍‌ନାପ୍‌ ଇଜି ଆସାକିଜିନିଦେର୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ଆଦେଙ୍ଗ୍‌ ନାନ୍ ୱେର୍‌ସିନା; ନାନ୍ ମି ଲାକ୍‌ତୁ ବାବବାଦିର୍, ଗୁରୁର୍‍ ମାରି ବୁଦିମାନିୱାରିଙ୍ଗ୍‌ ପୋକ୍‌ତାନା; ୱାରି ଲୋଇରାନ୍‌ ଏଙ୍ଗ୍‌ ଏଙ୍ଗ୍‌ ସାୟାମାର୍‌ଗା ଡାକ୍‌ନିଦେର୍‌, ଏସ ଲୋକାଙ୍ଗ୍‌ କ୍ରୁସଦୁ ସାୟାମାର୍‌ଗା ଡାକ୍‌ନିଦେର୍‌ ମାରି ଆଇୱାରିଙ୍ଗ୍‌ ପାର୍‍ତନାକିନି ଇଲ୍‌କାଙ୍ଗ୍‌ କର୍‌ଡା ଡାକ୍‌ସି ଉନ୍‌ଡ୍ରି ଗାଡ଼୍‌ତାନ୍‍ ମାରି ଉନ୍‌ଡ୍ରି ଗାଡ଼୍‌ତୁ ପେର୍‌ନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ଆମା ଦାର୍ମୁ ହେବଲ୍‌ତି ସାତି ମାଣାନ୍‌ ଆମା ବେରିକିୟଦି ମାରିସି ଜିକରିୟଙ୍ଗ୍‌ ମିର୍‌ ମନ୍ଦିର୍‌ତି ପବିତ୍ର ବାଡିଦୁ ନି ପୁଜାସିନି ବେଦି ନାଡ଼୍‌ମି ସାୟାମାର୍‌ଗା ଡାକ୍‌ତିଦେର୍‌, ୱାନି ସାତି ସାନ୍ଦି ଦୁନିଆଦୁ ଏସଲୋକ୍‌ ୱିଜୁ ଦାର୍ମୁଦି ଲୋକାଙ୍ଗ୍‌ ସାୟାମାର୍‌ଗା ଡାକ୍‌ତିମାନିଦେର୍‌ । ଆୟା ଦୋସ୍‌ସିଲି ଲୋକା ସାତିମାନି ଦଣ୍ଡ୍‌ ମି ମୁସ୍‌କୁ ୱାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ୱେର୍‌ସିନା, ଇୟାୱିଜୁ ଲୋକାଙ୍ଗ୍‌ ସାୟାମାର୍‌ଗା ଡାକ୍‌ତି ଉଣ୍ତିଙ୍ଗ୍‌ ଇୟା ଜଗ୍‌ତି ଲୋକୁ ଦଣ୍ଡ୍‌ ବଗାନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“ଏ ଜିରୁସାଲାମ୍‍, ଏ ଜିରୁସାଲାମ୍‍ ! ମିର୍‌ ବାବବାଦିରିଙ୍ଗ୍ ସାୟାମାର୍‌ଗାଡାକ୍‌ସିନିଦେର୍‌ ମାରି ମାପୁରୁ ପୋକ୍‌ତାତି କାବୁର୍‌ ଅନିତାନି ୱାରିଙ୍ଗ୍‌ କାଲ୍‌କୁ ପୋକ୍‌ସି ଡାକ୍‌ସିନିଦେର୍‌ । କରୁ ତାନି ରେକା ଆଡ୍‍ଗି ପିଲେକାଙ୍ଗ୍‌ ଆସ୍‌ସି ଇଡ୍‌ନି ୱାଜା, ମି ଲୋକାଙ୍ଗ୍‌ ନା ରେକା ଆଡ୍‍ଗି ପିଡ଼୍‍କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ଏସ ଦେବେଙ୍ଗ୍‌ ବଦାକିତା । ମାତର୍‌ ମିର୍‌ ନାଙ୍ଗିଁ ଆକା କିଦେଙ୍ଗ୍‌ ସିଇତିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ଆଦେଙ୍ଗ୍‌ ମି ମନ୍ଦିର୍‌ ୱିର୍‍ଜାଜି ମାରି ୱାରିକା ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ନାନ୍ ମିଙ୍ଗିଁ ୱେର୍‌ସିନା, ‘ପ୍ରବୁଦି ଦର୍‌ତାନ୍‌ ଏନ୍‌ ୱାଜିନାନ୍‍, ୱାନ୍‌ ଦନ୍ୟ,’ ମିର୍‌ ଇୟା ମାଟା ଇନ୍‌ଇ ସାନ୍ଦି ଇଲେଇରାନ୍‌ ନାଙ୍ଗିଁ ମାରି ସୁଡ଼ୁଦେଙ୍ଗ୍‌ ଆଟ୍‍ଇଦେର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ଜିସୁ ମନ୍ଦିର୍‌ତାନ୍‌ ସସି ସନିୱାଲେ ସିସୁର୍‍ ମନ୍ଦିର୍‌ତି ମେଡ଼େଇଲୁକୁ ୱିଜୁ ତର୍‌ନି ଉଣ୍ତିଙ୍ଗ୍‌ ୱାନି ଲାକ୍‌ତୁ ୱାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ଜିସୁ ଇର୍ହାନ୍‌, “ଇଲେଇ ଗିଦେ ଇୟାୱିଜୁ ସୁଡ଼ୁଜିନିଦେର୍‌ । ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ଇୟା ମନ୍ଦିର୍‌ତି ଉନ୍‌ଡ୍ରି କାଲୁ ଆଇ କାଲୁ ମୁସ୍‌କୁ ତେବାଉ, ୱିଜୁ ବୁମିଦୁମିସାନେ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ଜିସୁ ଜିତ ଗରନ୍‌ ମୁସ୍‌କୁ ବାସ୍‌ତି ମାରିଇୱାଲେ ସିସୁର୍‍ ୱାନି ଲାକ୍‌ତୁ ନେସ୍‌ଇୱାଜା ୱାଜି ୱେନ୍‌ବାତାର୍‌, “ଇୟାୱିଜୁ ଏସ୍‌କାଙ୍ଗ୍‌ ଗଟାନାତ୍‌, ଆକା ମାଙ୍ଗିଁ ଇନିଆ । ଇନିକା ଗଟାତିଙ୍ଗ୍‌ ମାପ୍‌ ନେସ୍‌ନାପ୍‌ ଜେ ନିନ୍‌ ୱାନି ବେଡ଼ା ଆତାତ୍‌ନି ମାରି ଇୟା ଜୁଗ୍‌ସେସ୍‌ ଆନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ଜାଗାର୍‌ତା ମାନ୍‌ଡ୍ରୁ । ଏନ୍‌ ଏଣ୍ତେସ୍‌ ମିଙ୍ଗିଁ ବାୟା କିଏନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ଗାଦିଲୋକ୍‌ ନା ଦର୍‌ ଆସ୍‌ସି ୱାଜି ଇନାର୍‌, ନାନ୍ ନେ କ୍ରିସ୍ତ ଅର୍ତ ମସିହ । ଇକା ଇନ୍‌ଞ୍ଜି ୱାର୍‌ ଗାଦିଲୋକାଙ୍ଗ୍‌ ବାୟାକିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ମିର୍‌ ଲାକ୍‌ତୁ ସାଲାତିମାନି ଜୁଦ୍‍ତି ଆଉଲି ୱେନିଦେର୍‌ ମାରି ଆକ ସାଲାତିମାନି ଜୁଦ୍‍ତି କାବୁର୍‌ ୱେନିଦେର୍‌ । ମାତର୍‌ ତିଲାମାଟ୍‌ । ଇୟାୱିଜୁ ପୁରା ଗଟାନାତ୍‌, ମାତର୍‌ ଇୟାତାନି ଅର୍ତ ଆଏତ୍‍ ଜେ ଜୁଗ୍‌ ସେସ୍‌ଆନି ଦିନ୍‌ ଲାକ୍‌ତୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ଦେସ୍‌ ଦେସ୍‌ତି ଲୋଇ ଜୁଦ୍‍ ସାଲାନାତ୍‌, ଉନ୍‌ଡ୍ରି ରାଜି ଆଇ ରାଜି ମୁସ୍‌କୁ ଡାକ୍‌ନାତ୍‌ । ୱିଜୁ ତରିନ୍‌ ଉନ୍‌ଣ୍ତେ ତିନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ପୁଟ୍‌ଏତ୍‌ ମାରି ବୁମିକମ୍ପ ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ମାତର୍‌ ଇୟାୱିଜୁ ଜନମ୍‌କିନି କାସ୍ଟୁଦି ଆରାମ୍‌ ମାତର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","ମିର୍‌ ଆସାୟ୍‌ଆଜି ଦୁଃକ୍‌କାସ୍ଟୁ କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ସର୍‌ପେ କିନାର୍‌ ମାରି ମିଙ୍ଗିଁ ସାୟାମାର୍‌ଗା ଡାକ୍‌ନାର୍‌, ନାବାନ୍‍ ବିସ୍‌ବାସ୍‌ କିତିମାନି ଉଣ୍ତିଙ୍ଗ୍‌ ମିର୍‌ ୱିଜେରି ଲୋକାଦି ମାଣାନ୍‌ କାଡ଼ାଇଆନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ନାସ୍ତିୱାଲେ ଗାଦିଲୋକ୍‌ ୱାରି ବିସ୍‌ବାସ୍‌ ଆରାକିନାର୍‌, ନିଜେନିଜେଦିଙ୍ଗ୍‌ କାଡ଼ାଜିସାଜି ନିଜେନିଜେଦି ଉଣ୍ତିଙ୍ଗ୍‌ ଆସିସ୍‌କିଆୟ୍‌ଆନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ନାସ୍ତିୱାଲେ ଗାଦିଲୋକ୍‌ ବଣ୍ତ ବାବବାଦିଦିର୍‌ ୱାଜି ଲୋକାଙ୍ଗ୍‌ ବାୟାକିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ମାରି ଅଦାର୍ମୁ ନାଣ୍ତ ଆତାତ୍‌ଆକା ଏସାଲୋକା ମାପୁରୁଙ୍ଗ୍‍ଁ ଜିବନ୍‍ନୋନିକା ସିତିଡ଼ିଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ମାତର୍‌ ଏନ୍‌ ସାରାସାରି ୱେନ୍‌କା ସାନ୍ଦି ସାସ୍‌ଆସ୍‌ସି ତେବାନାନ୍‌, ୱାନ୍‌ ରକିୟା ପଇନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ମାପୁରୁଦି ରାଜିଦି ବିସୟ୍‌ତାନ୍‌ ନେଗିକାବୁର୍‌ ୱିଜୁ ଲୋକାଦି ଲାକ୍‌ତୁ ସାକି ସିଦେଙ୍ଗ୍‍ ଇୟା କାବୁର୍‌ ସାରାଦୁନିଆଦି ୱିଜୁ ତରିନ୍‌ ପ୍ରଚାର୍‌ ଆନାତ୍‌ । ତାନେୱେନ୍‌କା ଜୁଗ୍‌ସେସ୍‌ ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","ମିର୍‌ ଏସ୍ତିୱାଲେ ବାବବାଦି ଦାନିୟେଲ୍‌ ମାଣାନ୍‌ ୱେର୍‍ଇଆତି ନାସ୍ଟୁକିନି କାଡ଼୍‍ନି ତାନେଙ୍ଗ୍‌ ମନ୍ଦିର୍‌ ପବିତ୍ର ବାଡିଦୁ ନିନିମାନିକା ସୁଣିଦେର୍‌ । ଇୟାତାନି ଅର୍ତ ଇନିକା, ପଡ଼ାଜ ବୁଜାଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ନାସ୍ତିୱାଲେ ଆମାଲୋକ୍‍ ୱିଜେରେ ଜିହୁଦା ଗାଡ଼୍‌ତୁ ମାନାର୍‌, ୱାର୍‌ ଗରନ୍‌ ମୁସ୍‌କୁ ଉରୁକ୍‍ସି ସଲିର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ଆମାକାର୍‌ ସାତ୍ ମୁସ୍‌କୁ ମାନାର୍‌, ୱାର୍‌ ଇଲୁ ଲୋଇ ସାମାନ୍‌ପତର୍‌ ଅତେଙ୍ଗ୍‌ ଇଜି ଆଡ୍‍ଗି ୱାଜି ୱେଡ଼ା ନାସ୍ଟୁ କିମାକିନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ଆମାକାର୍‌ କିଡ଼ିଇଦୁ ସୋଲ୍‌ସି ମାନାର୍‌, ନିଜେଦି ସାଦର୍‌ ତାତେଙ୍ଗ୍‌ ଇଜି ଡ଼େସି ସଲ୍‌ମାକିନ୍ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ନାସ୍ତିୱାଲେ ପଟାଦୁମାନି ଆଇମାଲୋକ୍‍ ମାରି ଇସ୍ରି କଡ଼ରିଙ୍ଗ୍‌ ଆସ୍‌ସି ପାଲ୍‍ ଉଟ୍‍ପିସ୍‍କିନି ଆଇସିକା ଅବସ୍ତା ଏସ ତାଗ୍‌ଇକା ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ମାପୁରୁଙ୍ଗ୍‌ ପାରାତାନା କିଜିମାନ୍‌ଡ୍ରୁ, ପିନିକାଡ଼ାଦୁ ସିଲିତିଙ୍ଗ୍‌ ରମ୍‌ନିନାଣ୍ତିଆଙ୍ଗାଁ ମିଙ୍ଗିଁ ଏଣ୍ତେସ୍‌ ଉରୁକ୍‌ସି ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ପଡ଼ାଏତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ନାସ୍ତିୱାଲେ ଇୟାୱାଜା ନାଣ୍ତକାସ୍ଟୁ ଗଟ୍‌ନା ଜେ, ଦୁନିଆଦି ତିଆର୍‌ଆତିମାଣାନ୍‌ ନେର୍‌ ସାନ୍ଦି ଗଟାଏତ୍‍, ମାରି ଏସ୍‌କାଙ୍ଗ୍‌ବା ଗଟାଏତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ମାତର୍‌ ଇୟା ଦୁଃକ୍‌ତି ବେଡ଼ାଦିଙ୍ଗ୍‌ ମାପୁରୁ ଉଣା କିତାମାନାନ୍‌, ଆକା ଆଇତିମାରିଙ୍ଗ୍‌, ମାରି ଏନ୍‌ ଜିଜ ମାନ୍‌ଏତାନ୍‌ମାନ୍ଦି । ମାତର୍‌ ୱାନି ଆସ୍‌କିତିମାନି ଲୋକାଙ୍ଗ୍‌ ରକିୟା କିଦେଙ୍ଗ୍‌ ଇଜି ମାପୁରୁ ଆୟା ସମୟ୍‌ତିଙ୍ଗ୍‌ ଉଣା କିତାମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","ନାସ୍ତିୱାଲେ ଜଦି ଏନ୍‌ ମିଙ୍ଗିଁ ଇନ୍‌ନାନ୍‌, ଇବେନୁ କ୍ରିସ୍ତ ମାନାନ୍‌ ସିଲିତିଙ୍ଗ୍‌ ଆବେନ୍‌ ୱାନ୍‌ ମାନାନ୍‌; ଆକା ବିସ୍‌ବାସ୍‌ କିମାଟ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ଇରିଙ୍ଗ୍‌ ଆପ୍‌ଣାଦିଙ୍ଗ୍‌ କ୍ରିସ୍ତ ସିଲିତିଙ୍ଗ୍‌ ବାବବାଦି ଇନାୟ୍‌ଆଜିମାନି ବଣ୍ତବାବବାଦିର୍‍ ନାସ୍ତିୱାଲେ ତର୍‌ଆୟାଆନାର୍‌ । ୱାର୍‌ କାବାଆନିକା ମାରି ତିଲାନିପାଣି ତର୍‌ସି ମାପୁରୁଦି ଆସ୍‌କିତିମାନି ଲୋକାଙ୍ଗ୍‌ ବାୟାକିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ୱେନ୍‌ଡ୍ରୁ ! ଆୟା ସମୟ୍ ୱାନି ଆଗ୍‍ଡ଼ିନେ ନାନ୍ ମିଙ୍ଗିଁ ଇୟାୱିଜୁ ମାଟା ୱେର୍‌ତା ସିଜିନା । ");
INSERT INTO kfcp_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","ମାରି, ସୁଡ଼ୁଦୁ, ୱାନ୍‌ ବାଲିରାଜିଦୁ ମାନାନ୍‌, ଲୋକୁ ଜଦି ମିଙ୍ଗିଁ ଇୟା ମାଟା ଇନାର୍‌, ଆବେନୁ ସୋଲ୍‌ମାଟ୍‌ । ମାରି ସୁଡ଼ୁଦୁ, ଇବେନୁ ୱାନ୍‌ ବାକ୍‍ରା ଲୋଇ ମାର୍‌ଗିତାମାନାନ୍‌, ଜଦି ଇକା ଇନାର୍‌, ୱାରିଙ୍ଗ୍‌ ବିସ୍‌ବାସ୍‌ କିମାଟ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ମିର୍‌ସିନିକା ଏଣ୍ତେସ୍‌ ୱେଡ଼ାସନି ତରିଟାନ୍‍ ନି ୱେଡ଼ାଆର୍‌ନିତର୍‌ନି ସାନ୍ଦି ବାଦଡ଼୍‍ତିଙ୍ଗ୍‍ ଜାୟ୍‌ କିନାତ୍‌, ଆୟାୱାଜା ମନୁସ୍ୟପୁତ୍ରଦି ୱାନିକା ଗଟାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“ଏମେମାନୁ ସାତିମାଡ଼ା ମାନାତ୍‌, ଆୟାବାନୁ ଡେଗେଙ୍ଗ୍‌ ଉନ୍‌ଡ୍ରେମାନୁ ଉଣ୍ତାନେ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“ଆୟା ଦୁଃକ୍‌କାସ୍ଟୁଦି ବେଡ଼ା ୱିଜିନି ବେଡ଼ାଦୁ ୱେଡ଼ା ସିକାଟି ଆନାତ୍‌ ମାରି ଲେଜୁ ମାରି ଜାୟ୍‌ ସିଏନ୍‌, ମାରି ସୁକେଙ୍ଗ୍‌ୱିଜୁ ବାଦଡ଼ତାନ୍‌ ଆର୍‌ନେ ମାରି ବାଦଡ଼ତି ସାକ୍ତିୱିଜୁ ଇନିଙ୍ଗାଁଆନିଆ ଆନେ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ତାନେୱେନ୍‌କା ମନୁସ୍ୟପୁତ୍ରଦି ସିନେଙ୍ଗ୍‌ ବାଦଡ଼ତୁ ତର୍‌ନେ ମାରି ମନୁସ୍ୟପୁତ୍ର ମେଗେମାଳାଦାନ୍‌ ପେରି ସାକ୍ତିଦାନ୍‍ ମାରି ଗୌରବ୍‌ଦାନ୍‌ ୱାଜିମାନିକା ସୁଡ଼ୁଜି ଦୁନିଆଦି ୱିଜୁ ବାସାଦି ଲୋକୁ ଆଡ଼ାବାନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ବାଜାମରି ଆନାତ୍‌ ମାରି ପୃତିବିଦି ଉନ୍‌ଡ୍ରି କନାଦାନ୍‌ ଆଇ କନା ସାନ୍ଦି ସାରିବେଡ଼ିତିଦାନ୍‌ ୱାନି ଆସ୍‌କିତିମାନି ଲୋକାଙ୍ଗ୍‌ ଉଣ୍ତା କିଜ ତାନି ଉଣ୍ତିଙ୍ଗ୍‌ ମନୁସ୍ୟପୁତ୍ର ୱାନି ଦୁତ୍‌କାଙ୍ଗ୍‌ ପୋକ୍‌ନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“ତଗା ମାରାନ୍‌ତାନ୍‌ କାତା ଅଜାଦୁ, ଏସ୍ତିୱାଲେ ତାନି କମେଆଙ୍ଗ୍‌ଁ ଆକୁ ପାସ୍‍ରିକା ମାରି କଡ଼୍‍କିକା ଆଜି ପୁନି ଆକୁ କାୟାନାତ୍‌, ନାସ୍ତିୱାଲେ ଜେଟାପ୍‌ ଲେଞ୍ଜୁ ଲାକ୍‌ତୁ ୱାତାନି ଇଜି ମିର୍‌ ନେସ୍‌ସିନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ଆୟାୱାଜା ମିର୍‌ ବା ଇୟାୱିଜୁ ଗଟ୍‌ନେଙ୍ଗ୍‌ ସୁଡ଼ୁତିଙ୍ଗ୍‌, ମନୁସ୍ୟପୁତ୍ର ସେର୍‍ଲା ଲାକ୍‌ତୁ ଇତାନ୍‌ ଇକା ଇଜି ମିର୍‌ ନେସ୍‌ତୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ମାନ୍‌ତୁଇଡିଦୁ, ଇଲେଇ ଜିବନ୍‌ମାନି ଲୋକା ମାଣାନ୍‌ ୱିଜେରେ ସାନି ଆଗ୍‍ଡ଼ି ଇୟାୱିଜୁ ବିସୟ୍‌ ଗଟାଏତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ବାଦଡ଼ ନି ପୃତିବି ମାରାଗ୍‌ନାତ୍‌; ମାତର୍‌ ନା ବାକ୍ୟ ଏସ୍‌କାଙ୍ଗ୍‌ ମାର୍‌ଗେଏତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“ମାତର୍‌ ଆୟା ଦିନ୍‌ ବା, ଆୟା ବେଡ଼ା ଏସ୍‌କାଙ୍ଗ୍‌ ୱାନାତ୍‌, ଏନ୍‌ ୱେର୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‍ଏନ୍‍ । ନିଜେ ମାପୁରୁଦି ମାରିନ୍‌ ନି ଦୁତ୍‌କୁ ବା ଆୟାମାଟା ନେସେଉ, କେବଲ୍‌ ବୁବା ମାପୁରୁ ନେସ୍‌ନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ନୋହଦି ବେଡ଼ାଦୁ ଏଣ୍ତେସ୍‌ ଗଟାତା ମାର୍ହାତ୍‌, ମନୁସ୍ୟପୁତ୍ରଦି ୱାନି ବେଡ଼ାଦୁ ଆୟାୱାଜା ଗଟାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ଗାଲିପିରୁଦି ଆଗ୍‍ଡ଼ିରି ବେଡ଼ାଦୁ ନୋହଦି ଜାହାଜ୍‌ତୁ ଡ଼ୁଗୁନି ଦିନ୍‌ ସାନ୍ଦି ଲୋକୁ ଉଣିତିନିକା ମାରି ମେମାରି ନି ଆଇମା ପେଡ଼ିଆନି ୱିଜୁପାଣିଦୁ ଦାନ୍ଦା ଆତାମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ଗାଲିପିରୁଦୁ ୱାର୍‌ ଦେଲ୍‌ଜିସନି ସାନ୍ଦି ଇନିକା ଗଟାଜିନାତ୍‌ ନେସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‌ଏଜି ମାର୍ହାର୍‌ । ମନୁସ୍ୟପୁତ୍ର ୱାଜିନି ଦିନ୍‌ତୁ ବା ଟିକ୍‌ ଆୟାୱାଜା ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ଆୟା ସମୟ୍‍ତୁ କିଡ଼ିଇଦୁ ପାଣି କିଜିମାନି ରିଏରି ମେମାରିରି ମାଣ୍‌କୁ ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ଅଆୟ୍‌ଆନାତ୍‌ ମାରି ଆଇ ଅରେନ୍‌ ୱାନିଙ୍ଗ୍‍ ଡ଼ିସ୍‌ନାସିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ରୁଣ୍ତି ଆଇମେକ୍‍ ଜାତାଦୁ ନୁର୍‌ଜିମାନେ, ଅରେତ୍‍ତାନିଙ୍ଗ୍‍ ଅଆୟ୍‌ଆନାତ୍‌ ମାରି ଆଇତାନିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ନାସିନାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ମାରି, ଜାଗାର୍‌ତା ମାନ୍‌ଡ୍ରୁ, ଇରିଙ୍ଗ୍‌ ମି ପ୍ରବୁ ଆମା ନାଣ୍ତିଙ୍ଗ୍‌ ୱାନାନ୍‌, ଆକା ମିର୍‌ ନେସ୍‌ଇଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ମାତର୍‌ ଇକା ନେସ୍‌ସୋ ମାନ୍‌ଡ୍ରୁ, ଏସିୱାଲେ ଡଙ୍ଗାଁର୍‌ଏନ୍‌ ଡ଼ୁଗୁନାନ୍‌ ନେସ୍‌ତିମାରିଙ୍ଗ୍‌, ଇଲୁମାଲିକ୍‌ ଜାଗାର୍‌ତାଦାନ୍‌ ମାନ୍‌ଞ୍ଜି ଡଙ୍ଗାଁର୍‌ଏନ୍‌ତିଙ୍ଗ୍‌ ଇନ୍‌ଡ୍ର ଡ଼ୁଗିସିତେଙ୍ଗ୍‌ ସିଏନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ମିର୍‌ ବା ୱିଜୁଦିନ୍‌ ଜାଗାର୍‌ତା ଆଜମାନ୍‌ଡ୍ରୁ, ଇରିଙ୍ଗ୍‌ ଆମା ବେଡ଼ାଦୁ ମିର୍‌ ୱାନିଙ୍ଗ୍‌ କାପ୍‌କିଇ ମାନିଦେର୍‌ ଆୟା ବେଡ଼ାଦୁ ମନୁସ୍ୟପୁତ୍ର ୱାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“ଏନ୍‌ ଆର୍‌ତିଙ୍ଗ୍‌ ବିସ୍‌ବାସ୍‌ ନି ବୁଦିଦି ସାକର୍‌ ? ଆମାୱାରି ମୁସ୍‌କୁ ମାଲିକ୍‌ ଆଇ ସାକର୍‌କାଙ୍ଗ୍‌ ଟିକ୍‌ ବେଡ଼ାଦୁ କାଦି ସିନି ବଜୁ ସିନାମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ମାଲିକ୍‌ ଆଇଦେସ୍‌ତାନ୍‌ ଡ଼େସିୱାନିୱାଲେ ଆୟା ସାକର୍‌ ଜଦି ବିସ୍‌ବାସ୍‌ତାନ୍‌ ୱାନି ପାଣି ଟିକ୍‌ କିଜିମାନାନ୍‌, ସୁଡ଼୍‌ଜି ୱାନ୍‌ ଏସ ୱେଡ଼ିକା ଆନାନ୍‌, ୱାନ୍‌ ଦନ୍ୟ ! ");
INSERT INTO kfcp_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ମାଲିକ୍‌ ନିଜେଦି ୱିଜୁ ସମ୍ପତିଦି ଦାଇତ୍‌, ସିନି ଉଣ୍ତିଙ୍ଗ୍‌ ଆୟାୱାଜା ସାକର୍‌ତିଙ୍ଗ୍‌ ଆସ୍‌ କିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ମାତର୍‌ ଆୟା ତାଗ୍‌ଇ ସାକର୍‌ ଜଦି ଅବିସ୍‍ବାସ୍‍ କିଜି ମାଲିକ୍‌ ୱାନିକା ୱେଡ଼ା ଆନାତ୍‌ ଇଜି ଅଡ଼୍‌ବିନାନ୍‌ ମାରି ");
INSERT INTO kfcp_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ତଡ଼୍‍ ସାକର୍‌କାଙ୍ଗ୍‌ ଡାକ୍‌ତେଙ୍ଗ୍‌ଆସ୍‌ସି, ମାରି ମଦୁଆରି ୱାଲେ ଉନ୍‌ଣ୍ତେଙ୍ଗ୍‌ ତିନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ବାସ୍‌ନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ସାକର୍‌ କାପ୍‌କିଇୱାଲେ ବେଡ଼ାଦୁ ଦାପ୍ରେ ଅର୍‍ଲେନ୍‍ ଏସ୍ତିୱାଲେ ମାଲିକ୍‌ ଡ଼େସି ୱାନାନ୍‌, ଆୟା ନାଣ୍ଡିଙ୍ଗ୍ ମାରି ୱେଡ଼ା ସାକର୍‌ ନେସ୍‌ଏନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ମାଲିକ୍‌ ୱାନିଙ୍ଗ୍‌ କୟ୍‍ଜି ମକା ମକା କିଜି କପଟିରିୱାଲେ ୱାନି ବାଗ୍ ଟିକ୍‌ କିନାନ୍‌, ଆବେନ୍‌ ଆଡ଼୍‍ବାନିକା ନି ପାଲୁକୁ କାତ୍ରେକିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“ଆୟା ବେଡ଼ାଦୁ ମୁସ୍‌କୁପୁର୍‌ତିରାଜି ୱାନିକା ଇୟାୱାଜା ଆନାତ୍‌ । ଦାସ୍‌ଲୋକ୍‌ ରିପାଆଇଲିକ୍‌ ୱିଜେକେ ଉନ୍‌ଡ୍ରି ଉନ୍‌ଡ୍ରି ଦିୱେଙ୍ଗ୍‌ ନିୟୁ ଅସି କାନ୍ୟାମୁରୁଲିଙ୍ଗ୍‌ ମିସାଦେଙ୍ଗ୍‍ ସତେ ସର୍‌ଏମାର୍‌ଏ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ୱାନିକା ମାଣାନ୍‌ ପାସ୍‌ଲୋକ୍‌ ବୁଦିସିଲିକେଙ୍ଗ୍‌ ମାରି ପାସ୍‌ଲୋକ୍‌ ବୁଦିମାନିକେଙ୍ଗ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ବୁଦିସିଲିକେଙ୍ଗ୍‌ ଦିୱେଙ୍ଗ୍‌ ଅତେ ମାତର୍‌ ଅର୍‌ସେ ନାଣ୍ତ ନିୟୁ ଅଉମାରେଏ ");
INSERT INTO kfcp_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ମାତର୍‌ ବୁଦିମାନିକେଙ୍ଗ୍‌ ନିଜେନିଜେଦି ଦିୱାଦି ୱାଲେ କାୟାଦୁ ନିୟୁ ବା ଅତେ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","କାନ୍ୟାମୁରୁଲି ୱାନିକା ୱେଡ଼ା ଆତାତ୍‌ଆକା ରିପାଆଇଲିକ୍‌ କର୍‌ଅଜି କର୍‌ଅଜି ସୁସ୍‌ତେ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“ମାଜାର୍‌ନାଡ଼ା ଆଉଲି ୱେନ୍‌ୟାଆତାତ୍‌, ଇଦି ସୁଡ଼୍‍ଦୁ କାନ୍ୟାମୁରୁଲି ୱାତାତ୍‌ନି, ରାଦୁ ୱାନିଙ୍ଗ୍‌ ଅର୍‌ସେ ତାନାଟ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ନାସ୍ତିୱାଲେ ରିପାଆଇଲିକ୍‌ ନିଙ୍ଗିଁତେନୋ ନିଜେ ନିଜେଦି ଦିୱେଙ୍ଗ୍‌ ରସ୍‌ତେ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ନାସ୍ତିୱାଲେ ବୁଦିସିଲିକେଙ୍ଗ୍‌ ବୁଦିମାନିୱାନିକା ଇର୍‌ଏ, ମାଙ୍ଗିଁ କାଣ୍ତେକ୍‍ ନିୟୁ ସିଦାଟ୍‌ । ମା ଦିୱେଙ୍ଗ୍‌ୱିଜୁ ନାମ୍‌ଜିସୋଲ୍‌ସିନେ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ବୁଦିମାନିକେଙ୍ଗ୍‌ ଇର୍‌ଏ, ‘ସିଲେ, ସିଲେ, ସିଲେ,’ ମି ଉଣ୍ତିଙ୍ଗ୍‌ ନି ମା ଉଣ୍ତିଙ୍ଗ୍‌ ନିୟୁ ଇଏତ୍‌ । ମିର୍‌ ଦୁକାନ୍‌ତୁ ସୋଲ୍‌ସ ନିଜେନିଜେଦି ଉଣ୍ତିଙ୍ଗ୍‌ ଏସ ନିୟୁ କଡ଼ଜ ତାଗାଟ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ଆଦେଙ୍ଗ୍‌ ବୁଦିସିଲିକେଙ୍ଗ୍‌ ନିୟୁ କଣ୍ତେଙ୍ଗ୍‌ ସୋତେ । ୱାକ୍‍ ସୋର୍‌ଇ ୱେନ୍‌କା କାନ୍ୟାମୁରୁଲି ୱାତା ଇତାନ୍‌ । ତିଆର୍‌ମାର୍‍ଇ ପାସ୍‌ଲୋକ୍‌ ଆଇଲିକ୍‌ ୱାନି ୱାଲେ ପେଡ଼ି ବଜିଦୁ ସୋର୍‌ଇ ୱେନ୍‌କା ସେର୍‍ଲାଦିଙ୍ଗ୍‌ କେର୍‌ତାଡ଼ିସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“ତାନେୱେନ୍‌କା ଆଇ ରିପାଆଇଲିକ୍‌ ବା ଆବେନୁ ୱାତେନୋ । ଏ ପ୍ରବୁ, ଏ ପ୍ରବୁ, ସେର୍‌ଲା ରେଆ; ମାପ୍‌ ଲୋଇ ୱାନାପ୍‌ ଇଜି ୱାକ୍‍ ଆଉଲି ଆତେ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","କାନ୍ୟାମୁରୁଲି ଇର୍ହାନ୍‌, ସିଲେ ମୁଡ଼ୁକେ ସିଲେ, ମିର୍‌ ଏର୍‌, ନାନ୍ ନେସେଏ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ଇୟା ମାଟାଦିଙ୍ଗ୍‌ ୱିସ୍‌ତାନ୍‌ନୋ ଜିସୁ ଇର୍ହାନ୍‌, ଜାଗାର୍‌ତା ଆଜି ମାନ୍‌ଡ୍ରୁ । ମିର୍‌ ଆୟା ଦିନ୍‌ ନି ଆୟା ୱେଡ଼ା ନେସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‍ଇଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","ଆୟା ସମୟ୍‍ତୁ ମୁସ୍‌କୁପୁର୍‌ ଇୟାୱାଜା । ଅରେନ୍‍ ଲୋକୁ ନିଜେଦି ସାକର୍‌କାଙ୍ଗ୍‌ କୁକ୍‌ସି ନିଜେଦି ସମ୍ପତ୍ତି ୱାନି କିୟୁଦୁ ଡ଼ିସ୍‌ତା ସିତାନ୍‌ନୋ ଆଇଦେସ୍‌ତୁ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ସୋତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ୱାରି ସାକ୍ତିଦାନ୍ ୱାରିଙ୍ଗ୍‌ ଏସ ଏସ ୱେଣ୍ତିଟାକେଙ୍ଗ୍‌ ଉଣ୍ତାକିଦେଙ୍ଗ୍‌ ଅରେନ୍‌ୱାନିଙ୍ଗ୍‌ ସିତାନ୍‌ ୫,୦୦୦ ଆଜାର୍‌ ୱେଣ୍ତିଦି ଅଦ୍‌ଲିଙ୍ଗ୍‌, ମାରି ଅରେନ୍‌ୱାନିଙ୍ଗ୍‌ ୨,୦୦୦ ଆଜାର୍‌ ନି ମାରି ଅରେନ୍‌ୱାନିଙ୍ଗ୍‌ ୧,୦୦୦ ଆଜାର୍‌ ମାତର୍‌ । ମାରି ୱାନ୍‌ ଆଇଦେସ୍‌ତୁ ସର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","୫,୦୦୦ ଆଜାର୍‌ ଅଦ୍‌ଲି ପଇତିମାନି ସାକର୍‌ ଆୟା ଡାବୁଙ୍ଗାଁ ବେପାର୍‌ କିଜି ମାରି ୫,୦୦୦ ଆଜାର୍‌ ଲାବ୍‍ କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ଆୟାୱାଜା ୨,୦୦୦ ଆଜାର୍‌ ଅଦ୍‌ଲି ପଇତିମାନି ସାକର୍‌ ମାରି ୨,୦୦୦ ଆଜାର୍‌ ଲାବ୍‍ କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ମାତର୍‌ ଏନ୍‌ ୧,୦୦୦ ହାଜାର୍‌ ଅଦ୍‌ଲି ପଇତାମାର୍ହାନ୍‌, ୱାନ୍‌ ଉନ୍‌ଡ୍ରି ଗୁଟା କାରିତାନ୍‌ନୋ ମାଲିକ୍‌ତି ଆୟା ଡାବୁଙ୍ଗୁଁ ଆଡ଼ାକ୍‍ସି ଇଟ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","ନାଣ୍ତ ଦିନ୍‌ ୱେନ୍‌କା ମାଲିକ୍‌ ୱାତାନ୍‌ନୋ ମାରି ସାକର୍‌କା ୱାଲେ ଇସାବ୍‌ କିତାବ୍‌ କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","୫,୦୦୦ ଆଜାର୍‌ ଅଦ୍‌ଲି ଅତିମାନି ସାକର୍‌ ମାଲିକ୍‌ତିଙ୍ଗ୍‌ ମାରି ୫,୦୦୦ ଆଜାର୍‌ ସିଜି ଇର୍ହାନ୍‌, ଆଜ୍ଞା, ନିନ୍‌ ନାଙ୍ଗିଁ ୫,୦୦୦ ଆଜାର୍‌ ଅଦ୍‌ଲି ସିତିମାର୍‍ଇ, ଇକା ସୁଡୁଆ, ନାନ୍ ମାରି ୫,୦୦୦ ଆଜାର୍‌ ଲାବ୍‍ ପୟ୍‌ତାମାନା । ");
INSERT INTO kfcp_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ମାଲିକ୍‌ ୱେଡ଼ିକା ଆତାନ୍‌ନୋ ଇର୍ହାନ୍‌, ନେଗିକା କିତିମାନି, ନିନ୍‌ ନା ନେଗିକିନ୍ଦା ମାରି ବିସ୍‌ବାସ୍‌ତି ସାକର୍‌ । ନିନୁ ବିସ୍‌ବାସ୍‌ତାନ୍‌ ଉଣା ଦନ୍‌ତି ଇନିଙ୍ଗାଁଆନିଆ କିଦେଙ୍ଗ୍‌ଆଟ୍‌ତିମାନିଙ୍ଗ୍‌ ନି କିୟୁଦୁ ଗାଦି ଦନ୍‌ ଡ଼ିସ୍‌ନାସିନା । ରାଆ, ନା ୱାଲେ ୱେଡ଼ିକାକିଆ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","୨,୦୦୦ ଆଜାର୍‌ ଅଦ୍‌ଲି ଅତିମାନି ସାକର୍‌ ୱାତା ଇର୍ହାନ୍‌, ଆଜ୍ଞା, ନିନ୍‌ ନାଙ୍ଗିଁ ୨,୦୦୦ ଆଜାର୍‌ ସିତିମାର୍‍ଇ, ନାନ୍ ମାରି ୨,୦୦୦ ଆଜାର୍‌ ଲାବ୍‍ କିତାମାନା । ");
INSERT INTO kfcp_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ମାଲିକ୍‌ ଇର୍ହାନ୍‌, ନେକ୍‌କା କିତିମାନି । ନିନ୍‌ ବା ନା ନେଗି ନି ବିସ୍‌ବାସ୍‌ ସାକର୍‌ । ଉଣା ଦନ୍‌ତାନ୍‌ ବିସ୍‌ବାସ୍‌ ତର୍‌ତିମାନି, ଗାଦି ଦନ୍‌ ନାନ୍ ନିଙ୍ଗିଁ ନାଣ୍ତ କିନାସିନା । ରାଆ, ନା ୱେଡ଼ିକାଦୁ ମିସାଆ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“ସାରାସାରିୱେନ୍‌କା ଏକ୍‌ ଆଜାର୍‌ ୱେଣ୍ତିଅଦ୍‍ଲି ଅତିମାରିଇ ସାକର୍‌ ଇର୍ହାନ୍‌, ଆଜ୍ଞା, ନିନ୍‌ ଅରେନ୍‍ ଆଟ୍‌ୱା ଲୋକୁ, ଇକା ନାନ୍ ନେସ୍‍ତାମାର୍ହା । ୱିତ୍‌ଇମାନି କିଡ଼ିଇଦୁ ନିନ୍‌ ପାସି କୟ୍‌ନି । ୱିତୁ ୱିତ୍‌ଏଣ୍‌ଗା ପାସି ଉଣ୍ତାକିନି ।” ");
INSERT INTO kfcp_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ତିଲାତାନୋ ନି ଡାବୁଙ୍ଗୁଁ ଅତାନୋ ବୁମିଦୁ ମୁସ୍‌ତାମାର୍‌ଆ । ସୁଡୁଆ, ନିୱି ଆୟା ଡାବୁଙ୍ଗୁଁ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ମାଲିକ୍‌ ଇର୍ହାନ୍‌, ଏ ଦୁସ୍ଟ ମାରି ଗାଡ଼ିଆ ସାକର୍‌ ! ନିନ୍‌ ଗିଦେ ନେସ୍‌ତିମାରିଇ, ନାନ୍ ଏମେମାନୁ ୱିତ୍‌ଏମାନା, ଆବେନୁ ପାସି କୟ୍‌ନା ? ");
INSERT INTO kfcp_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ଆର୍‌ତିଙ୍ଗ୍‌ ନା ଡାବୁଙ୍ଗୁଁ ଅସି ନିନୁ ପୁଜିକିନି ଉଣ୍ତିଙ୍ଗ୍‌ ବେଙ୍କ୍‍ତୁ ଉଣ୍ତାକିତିସିତିମାନ୍ଦି । ଆର୍‌ତିଙ୍ଗ୍‌ ତାନିଙ୍ଗ୍‌ ନାନ୍ ପିଲାଦି ୱାଲେ ଡ଼େସି ପୟ୍‌ତାମାନ୍ଦି । ");
INSERT INTO kfcp_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ଇକା ୱେର୍‌ସି ମାଲିକ୍‌ ଆଦେସ୍‌ ସିତାନ୍‌, ଇୟା ସାକର୍‌ କିୟୁଦାନ୍‌ ଇୟା ଡାବୁଙ୍ଗୁଁ କୁତ୍‌ସଅସ ଆମାୱାନି କିୟୁଦୁ ୧୦,୦୦୦ ଆଜାର୍‌ ମାନେ, ୱାନିଙ୍ଗ୍‌ ସିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ଇରିଙ୍ଗ୍‌ ଆମାୱାନିଙ୍ଗ୍‌ ମାନେ, ୱାନିଙ୍ଗ୍‌ ନାଣ୍ତ ସିଆୟ୍‌ଆନାତ୍‌ ମାରି ୱାନ୍‌ ନାଣ୍ତ ଲାବ୍‍ କିନାନ୍‌ । ମାତର୍‌ ଆମାୱାନିଙ୍ଗ୍‌ ସିଲୁ, ୱାନି ଲାକ୍‌ତୁ ଆମାକା ମାନାତ୍‌, ଆକାବା କୁତ୍‌ନା ଅଆୟାଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ଇୟା ଜଗ୍‌ସିଲି ସାକର୍‌ତିଙ୍ଗ୍‌ ଆତ୍‌ରେ ସିକାଟିଦୁ ପକ୍‍ତୁ, ଆବେନୁ ୱାନ୍‌ ଆଡ଼୍‍ବାଜି ପାଲୁକୁ କାତ୍ରେକିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“ଏସ୍ତିୱାଲେ ମନୁସ୍ୟପୁତ୍ର ରାଜାଦି ୱାଜା ୱାନି ମୁସ୍‌କୁପୁର୍‌ତି ଦୁତ୍‌କାୱାଲେ ୱାନାନ୍‌, ୱାନ୍‌ ଗୌରବ୍‌ଜାୟ୍‌ ରାଜାଗାଦିଦୁ ବାସ୍‌ନାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ମାରି ଦୁନିଆଦି ୱିଜୁ ବାସାଦି ଲୋକୁ ୱାନି ଆଗ୍‌ଡ଼ି ଉନ୍‌ଡ୍ରେମାନୁ ଆନାର୍‌ । ନାସ୍ତିୱାଲେ ମେଣ୍ତେଙ୍ଗ୍‌ଗଉଡ଼ୁ ଏଣ୍ତେସ୍‌ ଗର୍‌ଏଙ୍ଗାଁ ନି ମେଣ୍ତେଆଙ୍ଗ୍‌ ୱେରେଏ କିନାନ୍‌, ମନୁସ୍ୟପୁତ୍ର ଆୟାୱାଜା ଲୋକାଙ୍ଗ୍‌ ଦୁଇ ବାଗ୍ କିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ଦାର୍ମୁଦି ଲୋକାଙ୍ଗ୍‌ ୱାନ୍‌ ଉଣି ତରିନ୍‌ ନି ଆଇ ଲୋକାଙ୍ଗ୍‌ ଡେବିରି ତରିନ୍‌ ଇଡ୍‌ନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ନାସ୍ତିୱାଲେ ରାଜା ୱାନି ଉଣି ତରିନ୍‌ମାନି ଲୋକାଙ୍ଗ୍‌ ଇନ୍‌ନାନ୍‌, ରାଦୁ, ମିଙ୍ଗିଁ ନା ବୁବା ଆର୍ସିବାଦ୍‌ କିତାମାନାନ୍‌ । ମି ଉଣ୍ତିଙ୍ଗ୍‌ ଦୁନିଆଦି ତିଆର୍‌ଆତି ଆଗ୍‍ଡ଼ିରାନ୍‍ ଆମା ରାଜି ତିଆର୍‌ ଆତାମାନାତ୍‌, ରାଦୁ, ଆବେନୁ ଡ଼ୁଗୁଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ନାନ୍ ବାଙ୍ଗାଁଦୁମାର୍‌ଆ, ମିର୍‌ ନାଙ୍ଗିଁ ଉନ୍‌ଣ୍ତେ ସିତିଦେର୍‌; ନାନ୍ ଏର୍‌କିସାଜିମାର୍‌ଆ, ମିର୍‌ ନାଙ୍ଗିଁ ଏରୁ ଉନ୍‌ଣ୍ତେ ସିତିଦେର୍‌ । ନାନ୍ ଅରେନ୍‌ନେମାର୍‌ଆ, ମିର୍‌ ନାଙ୍ଗିଁ ମି ଇନ୍‌ଡ୍ର ବାଡି ସିତିଦେର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ନାନ୍ ଡୁମ୍‌ଡାମାର୍‌ଆ, ନାଙ୍ଗିଁ ଆଙ୍ଗିଁ ଆରିସ୍‌କିତିଦେର୍‌; ନାନ୍ ନବ୍‌ଆତାମାର୍‌ଆ, ନାଙ୍ଗିଁ ଜାତୁନ୍‍ କିତିଦେର୍‌, ନାନ୍ ଜଇଲ୍‌ତୁମାର୍‌ଆ, ନାଙ୍ଗିଁ ସୁଡ଼ୁଦେଙ୍ଗ୍‌ୱାତିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ଦାର୍ମୁଦିଲୋକୁ ୱାନିଙ୍ଗ୍‌ ଇନାର୍‌, ପ୍ରବୁ ! ଏସ୍‌କାଙ୍ଗ୍‌ ନିଙ୍ଗିଁ ବାଙ୍ଗାଁଆତିକା ସୁଡ଼ୁଜି କାଦି ଉନ୍‌ଣ୍ତେଙ୍ଗ୍‌ ସିତାମାନାପ୍‌ ? ଏସ୍‌କାଙ୍ଗ୍‌ ନିଙ୍ଗିଁ ଏର୍‌କିସାନିକା ସୁଡ଼ୁଜି ଏରୁ ଉନ୍‌ଣ୍ତେଙ୍ଗ୍‌ ସିତାମାନାପ୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ମାରି, ଏସାଙ୍ଗ୍‍ ଅରେନ୍‌ନେ ସୁଡ଼ୁଜି ଇଲ୍‌ତୁ ତେବାଦେଙ୍ଗ୍‍ ବାଡି ସିତାମାନାପ୍‌ ? ମାରି ଡୁମ୍‌ଡାଆତିକା ସୁଡ଼ୁଜି ଆଙ୍ଗିଁ ଆରିସ୍‌ କିତାମାନାପ୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ଏସ୍‌କାଙ୍ଗ୍‌ ନିଙ୍ଗିଁ ନବ୍‌ଆତିକା ନି ଜଇଲ୍‌ତୁମାନିକା ସୁଡ଼ୁଜି ନି ଲାକ୍‌ତୁ ୱାତାପ୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ରାଜା ଇନାନ୍‌, ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ଇୟା ନା ତଡ଼ାନ୍‌କା ଲୋଇରାନ୍‌ ୱିଜେରିଙ୍ଗ୍‍ ଇସ୍ରିୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ମିର୍‌ ଆମାକା ୱିଜୁ କିତିଦେର୍‌, ଆକା ନା ଉଣ୍ତିଙ୍ଗ୍‌ କିତିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","ତାନେୱେନ୍‌କା ରାଜା ଡେବିରି ତରିନ୍‌ମାନି ଲୋକାଙ୍ଗ୍‌ ଇନ୍‌ନାନ୍‌, ଏ ମାପୁରୁଦି ଆନାଦୁରିଆ ପୟ୍‌ତି ଲୋକୁ ! ନା ଆଗ୍‍ଡ଼ିରାନ୍‍ ଆକ ସାନ୍‌ଡ୍ରୁ । ସୟତାନ୍ ନି ତାନି ଦୁତ୍‌କା ଉଣ୍ତିଙ୍ଗ୍‌ ଆମା ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜ୍‍ଇ କାସ୍‌ସିମାନି ସିସୁ ତିଆର୍‌ ଆତାମାନାତ୍‌ ଆବେନୁ ସାନ୍‌ଡ୍ରୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ନାନ୍ ବାଙ୍ଗାଁଆତାମାର୍‌ଆ, ମିର୍‌ ନାଙ୍ଗିଁ ଉନ୍‌ଣ୍ତେଙ୍ଗ୍‌ ସିଇତିଦେର୍‌; ନାନ୍ ଏର୍‌କିସାତାମାର୍‌ଆ, ନାଙ୍ଗିଁ ଏରୁ ଉନ୍‌ଣ୍ତେଙ୍ଗ୍‌ ସିଇତିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ନାନ୍ ଅରେନ୍‌ନେମାର୍‌ଆ, ନାଙ୍ଗିଁ ମି ଇନ୍‌ଡ୍ର ବାଡି ସିଇତିଦେର; ନାନ୍ ଡୁମ୍‌ଡାମାର୍‌ଆ, ନାଙ୍ଗିଁ ଆଙ୍ଗିଁ ଆରିସ୍‌ କିଇତିଦେର୍‌; ନବ୍‌ ନି ଜଇଲ୍‌ତୁ ମାରିଇୱାଲେ ନାଙ୍ଗିଁ ଜାତୁନ୍‍ କିଇତିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","ନାସ୍ତିୱାଲେ ୱାର୍‌ ଉତର୍‌ ସିନାର୍‍, “ପ୍ରବୁ, ଏସ୍‌କାଙ୍ଗ୍‌ ମାପ୍‌ ନିଙ୍ଗିଁ ବାଙ୍ଗାଁ, ଏର୍‌କି, ଅରେନ୍‌ନେ, ଡୁମ୍‌ଡା, ନବ୍‌ ନି ଜଇଲ୍‌ତୁ ମାନିକା ସୁଡ଼ୁଜି ନିଙ୍ଗିଁ ସେବା କିଏତାପ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ରାଜା ଉତର୍‌ ସିନାନ୍‌, ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ଇୟା ଇସ୍ରି ଲୋକାରି ଲୋଇରାନ୍‌ ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ସାକା କିଦେଙ୍ଗ୍‌ ମନାକିତିଦେର୍‌, ମିର୍‌ ନାଙ୍ଗିଁ ସାକା କିଦେଙ୍ଗ୍‌ ମନାକିତିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ଇୟାକାର୍‌ ୱିଜୁଦିନ୍‌ତି ଉଣ୍ତିଙ୍ଗ୍‌ କାସ୍ଟୁବଗାନାର୍‌, ମାତର୍‌ ଦାର୍ମୁଦିକାର୍‌ ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜିଇ ଜିବନ୍‌ ପୟ୍‌ନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ଇୟାୱିଜୁ ସିକିୟା ସିତି ୱିସ୍‌ତି ୱେନ୍‌କା ଜିସୁ ସିସୁରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“ମିର୍‌ ନେସ୍‌ନିଦେର୍‌, ନିସ୍ତାର୍‌ ପଣ୍ତୟ୍‌ ଆଦେଙ୍ଗ୍‌ ମାରି ରିନେନ୍‌ ମାନାତ୍‌ । ନାସ୍ତିୱାଲେ ମନୁସ୍ୟପୁତ୍ର କ୍ରୁସଦୁ ସାନି ଉଣ୍ତିଙ୍ଗ୍‌ ସପ୍ରେଆନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ଆୟା ସମୟ୍‍ତୁ ପେରି ଜାଜକର୍‌ ମାରି ଆଇ ଜିହୁଦି ନେତାର୍‌ ୱିଜେରିଙ୍ଗ୍‌ପେରି ଜାଜକ କୟାପାଦି ଇଲୁ ଦୁଆର୍‌ତୁ ଉନ୍‌ଡ୍ରେମାନୁ ଉଣ୍ତାତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ଜିସୁଙ୍ଗୁଁ ସାଲାକିଦାନ୍‍ ଆସ୍‌ସି ଡାକ୍‌ତେଙ୍ଗ୍‍ଁ ଇଜି ଉପାୟ୍‌ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ମାତର୍‌ ୱାର୍‌ ଇର୍ହାର୍‌, “ଇୟା ପାଣି ମାପ୍‌ ପଣ୍ତୟ୍‌ ବେଡ଼ାଦୁ କିନିକା ନେଗେତ୍‌ସିଲେ । ନାସ୍ତିୱାଲେ ଲୋକୁ ଜାଟିଜଗଡ଼ାକିନାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ଅର୍‍ଲେନ୍‍ ଜିସୁ ବେତନିୟାଦୁ ଆଗ୍‍ଡ଼ିରାନ୍‍ କୁସ୍ଟରୋଗ୍‌ ବଗାତିମାର୍‍ଇ ସିମୋନ୍‍କା ଇଲୁଦୁ ମାର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ସିମୋନକା ଇଲୁଦୁ ଜିସୁ ଉନ୍‌ଣ୍ତେଙ୍ଗ୍‌ ବାସ୍‌ତି ମାରିଇୱାଲେ ଅରେତ୍‌ ଆଇମା ଉନ୍‌ଡ୍ରି ସାଟିଦୁ ନାଣ୍ତଦାରାଦି ବାସ୍‌ନା ନିୟୁ ବର୍ତି କିଜି ତାସି ୱାନି ତାଲା ମୁସ୍‌କୁ ୱାକ୍‌ତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ସିସୁର୍‍ ଇକା ସୁଡ଼ୁଜି ରିସା ଆତାର୍‌ । ୱାର୍‌ ତାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ନିସ ନାସ୍ଟୁକିତି ଏନ୍ଦା ?” ");
INSERT INTO kfcp_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“ଇୟା ବାସ୍‌ନା ନିୟୁ ନାଣ୍ତ ଡାବୁଙ୍ଗାଁ ପର୍‌ଦେଙ୍ଗ୍‌ ଆତାତ୍‌ମାନ୍ଦି ମାରି ଆୟା ଡାବୁଙ୍ଗୁଁ କାକୁର୍ତି ଲୋକାଙ୍ଗ୍‌ ସିଦେଙ୍ଗ୍‍ ଆତାତ୍‌ ମାନ୍ଦି ।” ");
INSERT INTO kfcp_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ୱାର୍‌ ଇନିକା ୱେର୍‌ସିନାର୍‌, ଜିସୁ ନେସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‍ତାନ୍‍ନୋ ଇର୍ହାନ୍‌, “ଆୟା ଆଇମାଦିଙ୍ଗ୍‍ ଏନ୍ଦା ବାଦାକିଜିନିଦେର୍‌ ? ନା ଉଣ୍ତିଙ୍ଗ୍‌ ୱାଦ୍‌ ଉନ୍‌ଡ୍ରି ନେଗି ନି ସୁନ୍ଦର୍‌ ପାଣି କିତାମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","କାକୁର୍ତି ଲୋକାଙ୍ଗ୍‌ ମିୱାଲେ ୱିଜୁଦିନ୍‌ ପଇନିଦେର୍‌, ମାତର୍‌ ନାଙ୍ଗିଁ ୱିଜୁଦିନ୍‌ ପୟ୍‌ଇଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ୱାଦ୍‌ ନା ମେନ୍ଦଲ୍‌ତୁ ଇୟା ବାସ୍‌ନା ନିୟୁ ୱାକ୍‌ସି ସିଜି ନା ମୁସ୍‍ନି ଉଣ୍ତିଙ୍ଗ୍‌ ତିଆର୍‌ କିତି ୱାଜା କିତାମାନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ୱେର୍‌ସିନା, ସାରା ଦୁନିଆଦି ଆମା ବାଡିଦୁ ଇୟା ନେଗିକାବୁର୍‌ ୱେର୍‌ନାର୍‌, ଇୟା ଆଇମା ଆମାକା କିତାମାନାତ୍‌, ତାନିଙ୍ଗ୍‌ ଏତ୍‌କିଜି ଆକାବା ପ୍ରଚାର୍‌ କିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ନାସ୍ତିୱାଲେ ବାରଲୋକ୍‌ ସିସୁରି ଲୋଇରାନ୍‌ ଇସ୍କାରିୟୋତିୟ ଯିହୁଦା ଦର୍‌ତି ଅରେନ୍‍ ସିସୁ ପେରି ଜାଜକରି ଲାକ୍‌ତୁ ସୋର୍‌ର୍ହାନ୍‌ନୋ ୱେନ୍‌ବାତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“ଜିସୁଙ୍ଗୁଁ ଆସିସ୍‌କିତି ସିତିଙ୍ଗ୍‌ ନାଙ୍ଗିଁ ଇନିକା ସିନିଦେର୍‌ ?” ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ତିରିସ୍‌ଗୋଟା ୱେଣ୍ତିଅଦ୍‌ଲିଙ୍ଗ୍‌ ଲେକିସ୍‌ତାସିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ଆୟାନାଣ୍ତିରାନ୍‌ ଜିସୁଙ୍ଗୁଁ ୱାରି କିୟୁଦୁ ଆସିସ୍‌କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ଜିହୁଦା ସାରି ପୟ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","“କମିର୍‌ସିଲି ରୁଟି” ପଣ୍ତୟ୍‌ତି ଆଗ୍‍ଡ଼ିରି ନାଣ୍ତିଙ୍ଗ୍‌ ସିସୁର୍‍ ଜିସୁଦି ଲାକ୍‌ତୁ ୱାତାରୋ ୱେନ୍‌ବାତାର୍‌, “ମାପ୍‌ ଏମେମାନୁ ନି ଉଣ୍ତିଙ୍ଗ୍‌ ନିସ୍ତାର୍‌ ପଣ୍ତୟ୍‌ତି ବଜି ତିଆର୍‌କିନାପ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ଜିସୁ ୱେର୍‌ତାନ୍‌, “ଗାଡ଼୍‌ତୁ ସୋଲ୍‌ସ ଆୟା ପେରି ଲୋକ୍‌ତିଙ୍ଗ୍‌ ଇନିଦେର୍‌, ‘ଗୁରୁ ଇଜିନାନ୍‌,’ ନା ଦିନ୍‌ ଲାକ୍‌ତୁ ଆଜି ୱାଜିନାତ୍‍ । ୱାନି ସିସୁରି ୱାଲେ ମି ଇନ୍‌ଡ୍ର ୱାନ୍‌ ନିସ୍ତାର୍‌ ପଣ୍ତୟ୍‌ କିନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ଜିସୁ ୱେର୍‌ତି ଇସାବ୍‌ତାନ୍‌ ସିସୁର୍‍ ନିସ୍ତାର୍‌ ପଣ୍ତୟ୍‌ତି ବଜି ତିଆର୍‌ କିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ୱେନ୍‌କା ମିଲ୍‌ମିଲିକା ଆତାତ୍‌ଆକା ଜିସୁ ନି ବାରଲୋକ୍‌ ସିସୁର୍‍ ଉନ୍‌ଣ୍ତେଙ୍ଗ୍‌ ବାସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ଉଣୁଜିମାରିଇୱାଲେ ଜିସୁ ଇର୍ହାନ୍‌, “ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ମି ଲୋଇରାନ୍‌ ଅରେନ୍‍ ନାଙ୍ଗିଁ ସାତ୍ରୁରି କିୟୁଦୁ ସର୍‌ପେ କିନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ସିସୁର୍‍ ନାଣ୍ତ ଦୁଃକ୍‌ ଆଜି ଅରେନ୍‍ ୱେନ୍‌କା ମାରି ଅରେନ୍‍ ଜିସୁଙ୍ଗୁଁ ୱେନ୍‌ବାତାର୍‌, “ପ୍ରବୁ, ନାନ୍ ଆକାନ୍‍ ନୋ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ଜିସୁ ଇର୍ହାନ୍‌, “ଏନ୍‌ ନା ୱାଲେ ଡୁବାଇତୁ ରୁଟି ମୁଡ଼ୁକୁନାନ୍‌, ୱାନ୍‌ ନାଙ୍ଗିଁ ସାତ୍ରୁରି କିୟୁଦୁ ସର୍‌ପେକିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ସାସ୍ତ୍ରଦୁ ରାସାତିମାନି ୱାଜା ମନୁସ୍ୟପୁତ୍ର ସାନିଦଣ୍ତବଗାନାନ୍‌, ମାତର୍‌ ମନୁସ୍ୟପୁତ୍ରଙ୍ଗ୍‌ ଏନ୍‌ ଆସିସ୍‌ କିନାସିନାନ୍‌, ୱାନି ଦଣ୍ଡ୍‌ ଏସ ବୟ୍‌ଙ୍କାର୍‌ ! ଏସ୍‌କାଙ୍ଗ୍‌ ଜନମ୍‌ ଆଇତିମାରିଙ୍ଗ୍‌ ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ନେଗେନ୍‌ ଆତାତ୍‌ମାନ୍ଦି ।” ");
INSERT INTO kfcp_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ଆମା ଜିହୁଦା ୱାନିଙ୍ଗ୍‌ ସାତ୍ରୁରି କିୟୁଦୁ ସର୍‌ପେକିତାନ୍‌, ୱାନ୍‌ ଇର୍ହାନ୍‌, ଗୁରୁ, ୱାନ୍‌ ଇନିକା ନାନ୍ ? ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନିନ୍‌ ଆକା ଇଜିନି ।” ");
INSERT INTO kfcp_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ୱାର୍‌ ଉଣି ବେଡ଼ାଦୁ ଜିସୁ ଉନ୍‌ଡ୍ରି ରୁଟି ତାତାନ୍‌ନୋ ମାପୁରୁଙ୍ଗ୍‌ ଦନ୍ୟବାଦ୍‌ ସିତାନ୍‌ ମାରି ଆକା ରୁକୁସି ସିସୁରିଙ୍ଗ୍‌ ସିଜି ଇର୍ହାନ୍‌, ଅସି ତିନ୍‍ଣ୍ତ୍ରୁ; “ଇକା ନା ମେନ୍ଧଲ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ତାନେୱେନ୍‌କା ୱାନ୍‌ ଉଣି ଡୁବାଇ ଅତାନ୍‌ନୋ ମାପୁରୁଙ୍ଗ୍‌ ଦନ୍ୟବାଦ୍‌ ସିତାନ୍‌ ମାରି ଆକା ସିସୁରିଙ୍ଗ୍‌ ସିଜି ଇର୍ହାନ୍‌, ମିର୍‌ ୱିଜିଦେର୍‌ ଇବେଟ୍‌ତାନ୍‌ ଉଣ୍ତୁ । ୱାନ୍‌ ଇର୍ହାନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ଇକା ନା ନେତେର୍‌ । ଲୋକା ପାପ୍‌ କେମା ଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ନା ଆମା ନେତେର୍‌ ୱାକ୍‌ସ ସିଦେଙ୍ଗ୍‍ ସଲ୍‌ସିନା, ଆମାକା ମାପୁରୁଦି ପୁନି ନିୟମ୍‌ତିଙ୍ଗ୍‌ ସିଲ୍‌ଡାକ୍‌ନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ନାନ୍ ମିଙ୍ଗିଁ ୱେର୍‌ସିନା, “ଆମା ନାଣ୍ତିଙ୍ଗ୍‌ ନା ବୁବାଦି ରାଜିଦୁ ମି ୱାଲେ ପୁନି ଅଙ୍ଗୁର୍‍ରସ୍‍ ଉଣୁଇ ସାନ୍ଦି ନାନ୍ ମାରି ଏସ୍‌କାଙ୍ଗ୍‌ ଅଙ୍ଗୁର୍‍ରସ୍‍ ଉଣୁଏ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ୱାର୍‌ ଦନ୍ୟବାଦ୍‍ତି ପାଟା ପାରିତି ୱେନ୍‌କା ଜିତ ଗରନ୍‌ ମୁସ୍‌କୁ ସତାସର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ନାସ୍ତିୱାଲେ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନେର୍‌ ନାଡ଼ା ମିର୍‌ ୱିଜିଦେର୍‌ ନାଙ୍ଗିଁ ଡ଼ିସ୍‌ନି ଉର୍‍କ୍‍ନିଦେର୍‌ । ସାସ୍ତ୍ରଦୁ ରାସାତାମାନାତ୍‌, ନାନ୍ ମେଣ୍ତେଙ୍ଗ୍‌ ସାରାକିନିୱାନିଙ୍ଗ୍‌ ସାୟାମାରାଗ୍‌ ଡାକ୍‌ତିଙ୍ଗ୍‌ ମାରି ମେଣ୍ଡେଙ୍ଗ୍‌ ଇନିଙ୍ଗାଁ ଆନିଙ୍ଗାଁ ଆନେସନେ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ମାତର୍‌ ନାନ୍ ମାରିଡ଼େସିନିଙ୍ଗିଁତି ୱେନ୍‌କା ମି ଆଗ୍‍ଡ଼ିନେ ଗାଲିଲି ରାଜିଦୁ ସନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ପିତର୍‌ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାନ୍‌, “ଆଇକାର୍‌ ୱିଜେରେ ନିଙ୍ଗିଁ ଡ଼ିସ୍‌ତି ସରିଙ୍ଗ୍ ବା ନାନ୍ ମୁଡ଼ୁକେ ସୋଲଏ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ଜିସୁ ପିତରତିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ନାନ୍ ନିଙ୍ଗିଁ ସତ୍‍ ଇଜିନା, ନେର୍‌ ନାଡ଼ା କରୁ କେଡ଼େନି ଆଗ୍‍ଡ଼ିନେ ନିନୁ ନାଙ୍ଗିଁ ନେସେଏ ଇଜି ମୁନ୍‌ଡ୍ରି ଦେବେଙ୍ଗ୍‌ ଇନି । ");
INSERT INTO kfcp_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ପିତର୍‌ ଇର୍ହାନ୍‌, “ନି ୱାଲେ ସାଦେଙ୍ଗ୍‌ ପଡ଼ାତିଙ୍ଗ୍‌ ବା ନାନ୍ ଏସ୍‌କାଙ୍ଗ୍‌ ନିଙ୍ଗିଁ ନେସ୍‍ଏ ଇଜି ଇନ୍‌ଏ ।” ଆଇ ସିସୁର୍‍ ୱିଜେରେ ବା ଆୟାୱାଜା ଇର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ତାନେୱେନ୍‌କା ଜିସୁ ନିଜେଦି ସିସୁରି ୱାଲେ ଗେତ୍‌ସିମାନି ଇନି ଉନ୍‌ଡ୍ରି ଡଡିଦୁ ସର୍ହାର୍‌ନୋ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନାନ୍ ଆବେନୁ ସନାନୋ ପାର୍‌ତନା କିଜିମାନି ସାନ୍ଦି ମିର୍‌ ଇବେନୁ ବାସ୍‌ସୋ ମାନ୍‌ଡ୍ରୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ୱାନ୍‌ ପିତର୍‌ ମାରି ଜେବଦିରି ରିଏର୍‌ ମାରିସିରିଙ୍ଗ୍‌ ୱାନି ୱାଲେ ଅତାନ୍‍ । ନାସ୍ତିୱାଲେ ଜିସୁ ନାଣ୍ତ ଦୁଃକ୍‌ ମାରି ଦାନ୍ଦା ଆଜି, ");
INSERT INTO kfcp_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଦୁଃକ୍‌ତାନ୍‌ ନା ଜିବନ୍‌ ସାନିୱାଜା ଆଜିନାତ୍‌, ଇବେନୁ ମିର୍‌ ନା ୱାଲେ କାପ୍‌କିଜ ମାନ୍‌ଡ୍ରୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ଜିସୁ କାଣ୍ତେକ୍‍ ଆକ ସର୍ହାନ୍‌ନୋ ବୁମିଦୁ ମକମ୍‌ ପାଡ଼ାକ୍‌ତାନ୍‌ନୋ ପାରାତାନା କିଜି କିଜି ଇର୍ହାନ୍‌, “ଏ ନା ବୁବା, ଜଦି ଆଦେଙ୍ଗ୍‌ଆଟ୍‌ନାତ୍‌, ଆର୍‌ତିଙ୍ଗ୍‌ ଇୟା ଦୁଃକ୍‌ବୋଗ୍‌ତି ଉଣି ଡୁବାଇ ନା ମାଣାନ୍‌ ଆକ ଅଆ, ମାତର୍‌ ନା ବଦା ସିଲେ । ନି ବଦା ପୁରା ଆପିତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ତାନେୱେନ୍‌କା ୱାନ୍‌ ମୁଏର୍‌ ସିସୁରି ଲାକ୍‌ତୁ ଡ଼େସି ୱାତାନ୍‌ନୋ ସୁଡ଼ୁତାନ୍‌, ୱାର୍‌ ସୁସ୍‌ତା ମାନାର୍‌ । ଜିସୁ ପିତରତିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମିର୍‌ ଇନିକା ନା ୱାଲେ ଗନ୍‌ଟା ବା କାପ୍‌କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ଇଜିନିଦେର୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ପରିକାଦୁ ଏଣ୍ତେସ୍‌ ପଡ଼ାଇଦେର୍‌, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ କାପ୍‌କିଜ ପାରାତାନା କିଦୁ । ଇରିଙ୍ଗ୍‌ ମି ଆତ୍ମା ବଦାକିନାତ୍‍, ମାତର୍‌ ମେନ୍ଧଲ୍‍ ଲିଡ଼ଲାଡ଼ା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ଜିସୁ ମାରିଡ଼େସି ସର୍ହାନ୍‌ନୋ ପାର୍‌ତନା କିଜି ଇର୍ହାନ୍‌, “ଏ ନା ବୁବା, ଜଦି ଇୟା ଦୁଃକ୍‌ବୋଗ୍‌ତି ଉଣି ଡୁବାଇ ନା ମାଣାନ୍‌ କୁତ୍‌ସଅତେଙ୍ଗ୍‌ ଆଟ୍‍ଏର୍‍ ଆମାସାନ୍ଦି ନାନ୍ ତାନିଙ୍ଗ୍‌ ଉନ୍‌ଣ୍ତେଙ୍ଗ୍‌ ପଡ଼ାନାତ୍‌, ଆର୍‌ତିଙ୍ଗ୍‌ ନି ବଦା ପୁରା ଆପିତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ୱାନ୍‌ ୱାଜି ମାରିଡ଼େସି ସିସୁରିଙ୍ଗ୍‌ ସୁସ୍‌ତି ମାରିକା ସୁଡ଼ୁତାନ୍‌ । ୱାରି କାଣୁକୁ ରେସ ମାନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆଟ୍‌ଏଜି ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ସି କାଣ୍ତେକ୍‍ ଆକ ସୋଲ୍‌ସି ମୁନ୍‌ଡ୍ରି ଦେବେଙ୍ଗ୍‌ ବା ଆୟାୱାଜା ପାରାତାନା କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ତାନେୱେନ୍‌କା ୱାନ୍‌ ସିସୁରି ଲାକ୍‌ତୁ ୱାଜି ଇର୍ହାନ୍‌, “ମିର୍‌ ଇୟାସାନ୍ଦି ଡରିତିଦେର୍‌ନୋ ରମ୍‌ଜିନିଦେର୍‌ ? ସୁଡ଼ୁଦୁ, ମନୁସ୍ୟପୁତ୍ର ପାପି ଲୋକା କିୟୁଦୁ ସର୍‌ପେଆନି ସାକ୍ତିଦି ବେଡ଼ା ୱାତାନି । ");
INSERT INTO kfcp_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ନିଙ୍ଗ୍‍ଦୁ, ମାଡ୍‌ ସନାଟ୍‌; ସୁଡ଼ୁଦୁ, ଏନ୍‌ ନାଙ୍ଗିଁ ଶାତ୍ରୁରି କିୟୁଦୁ ସେରେପ୍‌ନା ସିନାନ୍‌, ୱାନ୍‌ ଲାକ୍‌ତୁ ୱାତାନ୍‍ନି ।” ");
INSERT INTO kfcp_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ଜିସୁ ଇୟା ମାଟା ୱେର୍‌ସିମାନି ବେଡ଼ାଦୁ, ୱାରି ବାରଲୋକ୍ ସିସୁରି ଲୋଇରାନ୍‌ ଜିହୁଦା ଦର୍‌ତି ସିସୁ ୱାତା ଇତାନ୍‌ । ୱାନି ୱାଲେ କାଣ୍ତା ନି ଡୁଡୁଙ୍ଗ୍‌କଣେଙ୍ଗ୍‌ ଆସ୍‌ସି ଗାଦି ଲୋକୁ ଆବେନୁ ଉଣ୍ତାତାର୍‌ । ୱାରିଙ୍ଗ୍‌ ପେରି ଜାଜକର୍‌ ନି ଦାର୍ମୁ ନେତାର୍‌ ପୋକ୍‌ତାମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ସାତ୍ରୁରି କିୟୁଦୁ ଆସ୍‌ସିସ୍‌ କିନିସିନି ଜିହୁଦା ୱାରିଙ୍ଗ୍‌ ଉନ୍‌ଡ୍ରି ସିନା ସିନି ଉଣ୍ତିଙ୍ଗ୍‌ ଟିକ୍‌ କିତାମାର୍ହାନ୍‌, ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆ ମାର୍ହାନ୍‌, “ନାନ୍ ଆମାୱାନିଙ୍ଗ୍‌ ନଣ୍ତ୍‌ନା, ୱାନ୍‌ ଆୟାକାନ୍‌, ୱାନିଙ୍ଗ୍‌ ଆସ୍‌ତୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ଜିହୁଦା ଆୟାଦାପ୍ରେ ଜିସୁଦି ଲାକ୍‌ତୁ ୱାତାନ୍‌ନୋ, ଏ ଗୁରୁ, ମାଡ଼ିସ୍‍କିନିକା, ଇକା ଇନ୍‌ଞ୍ଜି ୱାନିଙ୍ଗ୍‌ ନଣ୍ତିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ସଙ୍ଗ୍‍, ନି ପାଣି ବେଗି ୱିସ୍‌ଆ ।” ତାନେୱେନ୍‌କା ୱାର୍‌ ଲାକ୍‌ତୁ ୱାଜି ଜିସୁଙ୍ଗୁଁ ଆସ୍‌ତାରୋ ତର୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ଜିସୁଦି ତରିଟି ଅରେନ୍‍ ଲୋକୁ ନିଜେଦି କାଣ୍ତା ସପ୍‌ତାନ୍‌ନୋ ୱିଜେରିଙ୍ଗ୍‌ପେରି ଜାଜକଦି ସାକର୍‌ତିଙ୍ଗ୍‌ କାତ୍‌ତାନ୍‌ । ଆୟା ଲୋକ୍‌ତି ଗିତଣି ତେୱିତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନି କାଣ୍ତାଦିଙ୍ଗ୍‌ ତାନି ବାଡିଦୁ ଇଡିଆ । ଆମାକାର୍‌ କାଣ୍ତା ସୋପ୍‌ନାର୍‌ କାଣ୍ତାଦାନ୍‍ ସାନାର୍‍, ୱାର୍‌ କାଣ୍ତାଦାନ୍‌ନେ ସାନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ନିନୁ ଇନିକା ନେସ୍‌ଇ, ନାନ୍ ନା ବୁବେଙ୍ଗ୍‌ ସାକା ଲସ୍‌ତିଙ୍ଗ୍‌, ୱାନ୍‌ ନା ଉଣ୍ତିଙ୍ଗ୍‌ ଆୟାଦାପ୍ରେନେ ବାରଗୋଟା ସନ୍‌ୟ୍ୟଦଲ୍‌ତି ବାଦୁଲୁ ନାଣ୍ତ ମୁସ୍‌କୁପୁର୍‌ତି ଦୁତ୍‌କାଙ୍ଗ୍‌ ପୋକ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‍ନାନ୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ମାତର୍‌ ଇୟାୱିଜୁ ଗଟାନାତ୍‌ ଇଜି ଦାର୍ମୁସାସ୍ତ୍ରଦୁ ଆମାକା ରାସ୍‌ତାମାନାତ୍‌, ଆକା ପୁରା ଆନାତ୍‌ ଏଣ୍ତେସ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ଜିସୁ ତାନେୱେନ୍‌କା ଉଣ୍ତାତିମାରିଇ ଆୟା ଲୋକାଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନାନ୍ ଇନିକା ଅରେନ୍‍ ଉରୁକ୍‌ସିମାନି ଡଙ୍ଗାଁର୍‌ଏନ୍‌ ୱାଜା କାଣ୍ତା ନି ଡୁଡୁଙ୍ଗ୍‌ ଆସ୍‌ସି ନାଙ୍ଗିଁ ଆସ୍‌ତେଙ୍ଗ୍‌ ୱାତିମାନିଦେର୍‌ ? ନାନ୍ ୱିଜୁଦିନ୍‌ ମନ୍ଦିର୍‌ତୁ ବାସ୍‌ସି ସିକିୟା ସିଜିମାର୍‌ଆ, ନାସ୍ତିୱାଲେ ମିର୍‌ ନାଙ୍ଗିଁ ଆସ୍‍ଇତିଦେର୍‍ ! ");
INSERT INTO kfcp_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ମାତର୍‌ ବାବବାଦିର୍ ସାସ୍ତ୍ରଦୁ ଆମା ଆମାକା ରାସାତାମାନାର୍‌, ଆୟାୱିଜୁ ପୁରାଆନିଉଣ୍ତିଙ୍ଗ୍‌ ଇକା ଗଟାତାମାନାତ୍‌ ।” ନାସ୍ତିୱାଲେ ସିସୁର୍‍ ୱିଜେରେ ଜିସୁଙ୍ଗୁଁ ଡ଼ିସ୍‌ସି ଉର୍‌କୁସି ସର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ଆମାକାର୍‌ ଜିସୁଙ୍ଗୁଁ ଆସ୍‌ତାମାର୍ହାର୍‌, ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ୱିଜେରିଙ୍ଗ୍‌ପେରି ଜାଜକ କୟାପାରି ଇନ୍‌ଡ୍ର ଅତାର୍‍ । ଆୟା ବାଡିଦୁ ଦାର୍ମୁଗୁରୁ ନି ଦାର୍ମୁ ନେତାର୍‌ ଉନ୍‌ଡ୍ରେମାନୁ ଆତାମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ପିତର୍‌ କାଣ୍ତେକ୍‌ ଆକ ମାନ୍‌ଞ୍ଜି ଜିସୁଦି ୱେନ୍‌କା ସୋଲ୍‌ସିମାର୍ହାନ୍‌ ମାରି ୱାନ୍‌ ୱିଜେରିଙ୍ଗ୍‌ପେରି ଜାଜକ କୟାପାରି ଇଲୁଦି ଦୁଆର୍‌ ସାନ୍ଦି ସର୍ହାନ୍‌ । ଇୟାୱିଜୁ ଗଟ୍‌ନାଦି ଅବସ୍ତା ଇନିକା ଆନାତ୍‌, ଆକା ସୁଡ଼ୁନି ଉଣ୍ତିଙ୍ଗ୍‌ ପିତର୍‌ ଲୋଇ ସୋର୍ହାନ୍‌ନୋ ମନ୍ଦିର୍‌ କାପ୍‍କିନିୱାରି ୱାଲେ ବାସ୍‌ତାନ୍‌ ! ");
INSERT INTO kfcp_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ପେରି ଜାଜକର୍‌ ନି ଜିହୁଦିର୍‌ ପେରିମିଟିଙ୍ଗ୍‌ତି ୱିଜେରେ ଜିସୁଙ୍ଗୁଁ ସାନିଦଣ୍ତ ସିନିଉଣ୍ତିଙ୍ଗ୍ ୱାନି ବିରଦ୍‌ତାନ୍‌ ମିସ୍‌ସାକି ପୟ୍‌ଦେଙ୍ଗ୍‌ ତେରେପେତେଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ମାତର୍‌ ଗାଦି ଲୋକୁ ଜିସୁଦି ବିରଦ୍‌ତାନ୍‌ ମିସ୍‌ ମାଟା ଇର୍ହାର୍‌ । ମାତର୍‌ ଆୟାୱାଜା ଇନି ପାରାମାଣ୍‌ ପୟ୍‌ଏତାର୍‌ । ସାରାସାରିୱେନ୍‌କା ରିଏର୍‌ ନିଙ୍ଗିଁତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ୱାର୍‌ ଇର୍ହାର୍‌, “ଇୟାକାନ୍‌ ଇର୍‌ଆ ମାର୍ହାନ୍‌, ନାନ୍ ମାପୁରୁଦି ମନ୍ଦିର୍‌ତିଙ୍ଗ୍‌ ରୁକୁନାନୋ ମୁନେଟି ୱେନ୍‌କା ତାନିଙ୍ଗ୍‌ ମାରିଡ଼େସି ତିଆର୍‌ କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ୱିଜେରିଙ୍ଗ୍‌ପେରି ଜାଜକ ନିଲ୍‌ତାନ୍‌ନୋ ଜିସୁଙ୍ଗୁଁ ୱେନ୍‌ବାତାନ୍‌, “ନିନ୍‌ ଏନ୍ଦା ଇନିକା ଇନ୍‍ଇଜିନି ? ଇୟା ମାଟାଦିଙ୍ଗ୍‌ ରୁକୁତେଙ୍ଗ୍‌ ନିନୁ ଇନିକା ୱେର୍‌ନିକା ମାନାତ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ମାତର୍‌ ଜିସୁ ଆଲେତାତେବାତାନ୍‌ । ୱିଜେରିଙ୍ଗ୍‌ପେରି ଜାଜକ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଜିବନ୍‌ମାନି ମାପୁରୁଦି ଦର୍‌ତାନ୍‌ ନାନ୍ ନିଙ୍ଗିଁ ପାର୍‌ମାଣ୍‌ ସିଜି ୱେନ୍‌ବାଜିନା, ସତ୍‌ତାନ୍‌ ଇନ୍‌ଆଁ, ନିନ୍‌ ଇନିକା ମାପୁରୁଦି ମାରିନ୍‌ କ୍ରିସ୍ତ ଅର୍ତ ମସିହ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନିନ୍‌ ଟିକ୍‌ ୱେର୍‌ତିମାନି । ମାତର୍‌ ନାନ୍ ମିଙ୍ଗିଁ ୱିଜେରିଙ୍ଗ୍‌ ଇଜିନା, ମନୁସ୍ୟପୁତ୍ର ୱିଜୁ ସାକ୍ତିମାନିୱାରି ଉଣି ତରିନ୍‌ ବାସ୍‌ତିମାନିକା ସୁଣି, ମାରି ୱାନିଙ୍ଗ୍‌ ମୁସ୍‌କୁପୁର୍‌ତାନ୍‌ ମେଗେମାଲାଦି ୱାଲେ ରେତାଜି ୱାନିକା ନିନ୍‌ ସୁଡ଼୍‌ନି ।” ");
INSERT INTO kfcp_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ଇକା ୱେର୍‌ଆନ୍‌ନୋ ୱିଜେରିଙ୍ଗ୍‌ ପେରି ଜାଜକ ନିଜେଦି ଆଙ୍ଗିଁଦିଙ୍ଗ୍‌ କିସ୍‌ସି ପୋକ୍‌ସି ଇର୍ହାନ୍‌, “ଇକାନ୍‌ ମାପୁରୁଙ୍ଗ୍‌ ନିନ୍ଦାକିତାନ୍‌ । ମାରି ଆଇ ସାକି ଦର୍‌କାର୍‌ ସିଲେ । ଇୟାଦାପ୍ରେନେ ଇୟାୱାନି ମାପୁରୁଙ୍ଗ୍‌ ନିନ୍ଦା ତୋ ମିର୍‌ ୱେର୍‌ଇଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ଇୟା ବିସୟ୍‌ତାନ୍‌ ମି ବଦା ଇନିକା ?” ୱାର୍‌ ଇର୍ହାର୍‌, “ୱାନ୍‌ ଦସି, ୱାନ୍‌ ସାନିଦଣ୍ତ୍‌ତି ଜଗ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ତାନେୱେନ୍‌କା ୱାର୍‌ ଜିସୁଦି ମକମ୍‌ତୁ ପୁସ୍‌କାଡ଼ାମ୍‌ପୁସ୍‌ସି ୱାନିଙ୍ଗ୍‌ ଡାକ୍‌ତାର୍‌; ମାରି ଏନ୍‌ ଏନ୍‌ ୱାନିଙ୍ଗ୍‌ ସାପାଡ଼ା ଡାକ୍‌ସି ଇର୍ହାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“ଇକାନ୍‌ କ୍ରିସ୍ତ ! ନିନ୍‌ ପରା ବାବବାଦି, ମାଙ୍ଗିଁ ୱେର୍‌ଆ ତୋ, ଏନ୍‌ ନିଙ୍ଗିଁ ଡାକ୍‌ତାନ୍‌ !” ");
INSERT INTO kfcp_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ୱିଜେରିଙ୍ଗ୍‌ପେରି ଜାଜକରି ଆତ୍‍ରେରି ଦୁଆର୍‌ତୁ ପିତର୍‌ ବାସ୍‌ତି ମାରିଇୱାଲେ ଅରେତ୍‌ ସାକର୍‌ ଆଇମା ଲାକ୍‌ତୁ ୱାଜି ଇର୍ହାତ୍‌, “ନିନ୍‌ ବା ଗାଲିଲିଦି ଜିସୁଦି ୱାଲେମାରିଇ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ମାତର୍‌ ପିତର୍‌ ୱିଜେରି ଆଗ୍‌ଡ଼ି ଇୟା ମାଟା ନେସ୍‍ଏଜି ଇର୍ହାନ୍‌, “ନିନ୍‌ ଇନିକା ଇଜିନି, ନାନ୍ ନେସ୍‌ଏଜିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ଇକା ଇନ୍‌ଞ୍ଜି ୱାନ୍‌ ଆୟା ଦୁଆର୍‌ତି କେର୍‌ପି ଲାକ୍‌ତୁ ସୋର୍ହାନ୍‌ । ମାରି ଅରେତ୍‌ ସାକର୍‌ ଆଇମା ୱାନିଙ୍ଗ୍‌ ସୁଡ଼ୁଜି ଆବେନୁ ମାନି ଲୋକାଙ୍ଗ୍‌ ଇର୍ହାତ୍‌, “ଇୟାକାନ୍‌ ନାଜରିୟତିୟ ଜିସୁଦି ୱାଲେ ମାର୍ହାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ପିତର୍‌ ମାରିଡ଼େସି ନେସ୍‍ଏଜି ଇର୍ହାନ୍‌, “ପାର୍‌ମାଣ୍‌ କିଜି ୱେର୍‌ସିନା, ଆୟା ଲୋକ୍‌ତିଙ୍ଗ୍‌ ନାନ୍ ନେସେଏ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ଏସ ସମୟ୍ ୱେନ୍‌କା ଆବେନୁ ନିର୍‌ଇମାରିଇ ଲୋକୁ ପିତରତି ଲାକ୍‌ତୁ ୱାଜି ଇର୍ହାର୍‌, “ନିନୁ ସତେନେ ୱାରି ଲୋଇରାନ୍‌ ଅରେନ୍‍ । ନି ୱାର୍‌ଗିନିମାଣୁକୁ ଇକା ଜାଣାପଡ଼ାଜିନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ପିତର୍‌ ଇର୍ହାନ୍‌, “ପାର୍‌ମାଣ୍‌ କିଜି ୱେର୍‌ସିନା, ନା ମାଟା ସତ୍‍ନେ । ଆକା ଆଏତିଙ୍ଗ୍‍ ମାପୁରୁ ନାଙ୍ଗିଁ ଦଣ୍ଡ୍‌ ସିପିନ୍‌ । ଆୟା ଲୋକ୍‌ତିଙ୍ଗ୍‌ ନାନ୍ ନେସେଏ ।” ଆୟାଦାପ୍ରେନେ କର୍‌ରୁ କେଡ଼ିତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ମାରି ଜିସୁ ଇନିକା ଇର୍‌ଆ ମାର୍ହାନ୍‌, “ପିତର୍‌ ମନ୍‌ତୁ ଏତ୍‌କିତାନ୍‌ କର୍‌ରୁ କେଡ଼େନି ଆଗ୍‍ଡ଼ିନେ ନାଙ୍ଗିଁ ନେସେଏ ଇଜି ନିନୁ ମୁନ୍‌ଡ୍ରି ଦେବେଙ୍ଗ୍‌ ଇନି ।” ୱାନ୍‌ ଆତେରେ ସର୍ହାନ୍‌ନୋ ନାଣ୍ତବର୍‌କୁକ୍‌ସି ଆଡ଼୍‍ବାତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ମାର୍‌ନାଣ୍ଡିଙ୍ଗ୍‌ ସାଲ୍‌ଦିନେ ଜିସୁଙ୍ଗୁଁ ଡାକ୍‌ତେଙ୍ଗ୍‍ଁ ୱିଜେରେ ପେରି ଜାଜକର୍‌ ମାରି ଦାର୍ମୁ ନେତାର୍‌ ରାଜି ଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ସିକିଣିଦାନ୍‌ତର୍‌ସି ରୋମିୟ ସାସନ୍‌ତି ପେରିନେତା ପିଲାତ୍‌ଦି ଲାକ୍‌ତୁ ଅତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ଏସ୍ତିୱାଲେ ସାତ୍ରୁରି କିୟୁଦୁ ସର୍‌ପେକିତିସିତି ଜିହୁଦା ୱେର୍‌ଆନ୍‌ ଜେ, ଜିସୁଙ୍ଗୁଁ ସାନିଦଣ୍ତ୍‌ ଆତାମାନାନ୍‌, ୱାନ୍‌ ଏତ୍‌କିତାନ୍‌ ମାରି ପେରି ଜାଜକ ମାରି ଦାର୍ମୁ ନେତାରିଙ୍ଗ୍‌ ଆୟା ତିରିସ୍‌ଗୋଟା ୱେଣ୍ତିଅଦ୍‌ଲିଙ୍ଗ୍‌ ଡ଼େସି ସିତାନ୍‌ନୋ ଇର୍ହାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“ଅରେନ୍‍ ଦସ୍‌କିଇ ଲୋକ୍‌ତି ଉଣ୍ତିଙ୍ଗ୍‌ ମି କିୟୁଦୁଆସ୍‌ସି କିତାସିତାନୋ ନାନ୍ ପାପ୍‌ କିତାମାନା ।” ଜିହୁଦି ନେତାର୍‌ ଇର୍ହାର୍‌, “ଆବେନୁ ମାଦି ଇନିକା ମାନାତ୍‌ ? ଆକା ନି ନିଜେଦି ମାଟା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ଜିହୁଦା ଅଦ୍‌ଲିଆଙ୍ଗାଁ ମନ୍ଦିର୍‌ ଲୋଇ ପୋକ୍‌ତାସିତା ସୋର୍ହାନ୍‌ । ୱେନ୍‌କା ୱାନ୍‌ କକ୍‌ଲାଦୁ ଉରି ଆସାତାନ୍‌ନୋ ସାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ପେରି ଜାଜକର୍‌ ଆୟା ୱେଣ୍ତିଅଦ୍‌ଲିଆଙ୍ଗାଁ ଉଣ୍ତା କିଜି ଇର୍ହାନ୍‌, “ଇକା ନେତେର୍‌ତି ଦାରା ଡାବୁଙ୍ଗୁଁ । ଇକା ମନ୍ଦିର୍‌ତି ପେଡ଼ାଦୁ ଇଡ୍‌ନି ନିୟମ୍‌ତି ବିରଦ୍‌ ପାଣି ।” ");
INSERT INTO kfcp_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ଆୟା ଡାବୁଆଙ୍ଗାଁ ଏଣ୍ତେସ୍‌ ସାଲା କିନାର୍‌, ଇୟା ବିସୟ୍‌ତାନ୍‌ ଉନ୍‌ଡ୍ରି ରାଜି ଆଜି କୁମାର୍‍ ବୁମି ଦର୍‌ତି କାଣ୍ତେକ୍‍ ବୁମି କଟାର୍‌ । ଇକା ଆଇଦେସ୍‌ତିୱାରି ମୁସ୍‌ନି ବାଡି ୱାଜା ଆତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ନେର୍‌ ସାନ୍ଦି ଆୟା ବୁମିଦିଙ୍ଗ୍‌ “ନେତେର୍‌ ବୁମି” ଇଜି ଆଜିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ଇୟାୱାଜା ଜିରିମିୟ ବାବବାଦି ୱେର୍‌ତିମାନି, “ବାବବାଣି ପୁରା ଆତାତ୍‌ ଆକାବା ତିରିସ୍‌ ଟାକେଣାନ୍‌ ପର୍‌ନି ଉଣ୍ତିଙ୍ଗ୍‌ ଇସ୍ରାଏଲ୍‌ତି କଡ଼ର୍‌ ରାଜି ଆତା ମାର୍ହାର୍‌, ଆକା ଅତାର୍‍, ");
INSERT INTO kfcp_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ଆୟା ତିରିସ୍‌ ଗୋଟା ୱେଣ୍ତିଅଦ୍‌ଲିଙ୍ଗ୍‌ ୱାର୍‌ ତାସି, ମାରି ୱାର୍‌ କୁମାର୍‍ କିଡ଼ିଇ କଟାର୍‌ ଇକା କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ନାଙ୍ଗିଁ ପ୍ରବୁ ଆଦେସ୍‌ ସିତାମାର୍ହାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ଜିସୁଙ୍ଗୁଁ ଆଗ୍‌ଡ଼ି ସୁଡ଼ୁଜି ରୋମିୟ ଅଦିକାରି ପିଲାତ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ନିନ୍‌ ଇନିକା ଜିହୁଦିରି ରାଜା ?” ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନିନୁ ଆକା ଇଜିନି ।” ");
INSERT INTO kfcp_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ମାତର୍‌ ପେରି ଜାଜକର୍‌ ମାରି ଦାର୍ମୁ ନେତାରି ୱାନି ବିରଦ୍‌ତାନ୍‌ ଏମେ ଦସ୍‍ମାଟା ତାତାମାର୍ହାର୍‍, ଆବେଣି ପଦେକ୍‍ବା ମାଟା ଇନ୍‌ଏତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ଆଦେଙ୍ଗ୍‌ ପିଲାତ୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନି ବିରଦ୍‌ତାନ୍‌ ୱାରି ଦସ୍‍ମାଟା ୱିଜୁ ନିନୁ ଇନିକା ୱେନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆଟ୍‌ଇଜିନି ?” ");
INSERT INTO kfcp_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ମାତର୍‌ ଜିସୁ ଉତରଦାନ୍‌ ପଦେକ୍‌ ବା ଇନ୍‌ଇତିଙ୍ଗ୍‌ ପିଲାତ୍‌ ନାଣ୍ତ କାବାତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ନିସ୍ତାର୍‌ ପଣ୍ତୟ୍‌ତି ବେଡ଼ାଦୁ ୱିଜୁଲୋକା ବଦାଦାନ୍ ରୋମିୟ ଅଦିକାରି ଜେ ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ଜଇଲ୍‌ତାନ୍‌ ଡ଼ିସ୍‌ନିସିନି ନିତିନିୟମ୍ ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ନାସ୍ତିୱାଲେ ବାରବ୍‌ବା ଜିସୁ ଦର୍‌ତି ଅରେନ୍‍ ୱେଙ୍ଗିଁତିକାନ୍‌ ଜଇଲ୍‌ତୁ ମାର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ଉଣ୍ତାତିମାରିଇ ୱିଜୁ ଲୋକାଙ୍ଗ୍‌ ପିଲାତ୍‌ ୱେନ୍‌ବାତାନ୍‌, ନାନ୍ ଏଙ୍ଗ୍‌ ଡ଼ିସ୍‌ନା ସିନା ଇଜି ମି ବଦା ? “ବାରବ୍‌ବାଦିଙ୍ଗ୍‌ ନୋ ଜିସୁ ଆମାୱାନିଙ୍ଗ୍‌ କ୍ରିସ୍ତ ଇଜି ଇନାର୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ପିଲାତ୍‌ ନେଗେନ୍‌ତାନ୍‌ ନେସେତା ମାର୍ହାନ୍‌ ଜେ ଜିହୁଦି ନେତାର୍‌ ଗିଦ୍‌ରିଆଜି ଜିସୁଙ୍ଗୁଁ ୱାନି କିୟୁଦୁ ସର୍‌ପେ କିତାମାନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ପିଲାତ୍‌ ବିଚାର୍‍କିନି ବାଡିଦୁ ବାସ୍‌ତିମାରିଇ ୱାଲେ ୱାନି ଆଡ଼୍‌ସି ଉନ୍‌ଡ୍ରି କାବୁର୍‌ ପୋକ୍‌ତାତ୍‌ “ଆୟା ଦସ୍‌କିଇ ଲୋକ୍‌ତିଙ୍ଗ୍‌ ଇନିକା କିମାଟ୍‌ । ଇଏନ୍‌ ମିଲି ଉନ୍‌ଡ୍ରି ଲବେରୁ ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ନାଣ୍ତ ଦୁଃକ୍‌ ଏତ୍‌କିତାମାନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ପେରି ଜାଜକର୍‌ ମାରି ଦାର୍ମୁ ନେତାର୍‌ ବାରବ୍‌ବାଦିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ସି କିଜସିଜି, ଜିସୁଙ୍ଗୁଁ ସାନିଦଣ୍ତ ସିନି ଉଣ୍ତିଙ୍ଗ୍‌ ପିଲାତ୍‌ ଲାକ୍‌ତୁ ଦାବି କିଦେଙ୍ଗ୍‌ ଲୋକାଙ୍ଗ୍‌ ଏଗ୍ରିସ୍‌କିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ପିଲାତ୍‌ ମାରି ଲୋକାଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ଇୟା ରିଏରି ମାଣ୍‌କୁ ନାନ୍ ଏଙ୍ଗ୍‌ ଡ଼ିସ୍‌ନାସିନା ଇଜି ମି ବଦା ?” ୱାର୍‌ ଇର୍ହାର୍‌, “ବାରବ୍‌ବାଦିଙ୍ଗ୍‌ !” ");
INSERT INTO kfcp_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ପିଲାତ୍‌ ୱାରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ଆର୍‌ତିଙ୍ଗ୍‌ କ୍ରିସ୍ତ ଦର୍‌ତାନ୍‌ ୱେଙ୍ଗିଁତି ଜିସୁଙ୍ଗୁଁ ଇନିକା କିନା ?” “ୱାନିଙ୍ଗ୍‌ କ୍ରୁସଦୁ ଏକିସ୍‌କିଦୁ” ଇଜି ୱାର୍‌ ୱିଜେରେ ଆଉଲି ଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ପିଲାତ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ମାତର୍‌ ୱାନ୍‌ ଇନି ଦସ୍‌ କିତାମାନାନ୍‌ ?” ୱାର୍‌ ମାରି ନାଣ୍ତ ଆଉଲି ଆଜି ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, “ୱାନିଙ୍ଗ୍‌ କ୍ରୁସଦୁ ଏକିସ୍‌କିଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ପିଲାତ୍‌ ଏସ୍ତିୱାଲେ ସୁଡ଼ୁତାନ୍‌ ଜେ ୱାରିଙ୍ଗ୍‌ ମାରି ୱେର୍‌ସ ଇନି ଲାବ୍‍ ସିଲେ, ମାରି ଜାଟିଜଗଡ଼ା ଆଜିନାର୍‌, ନାସ୍ତିୱାଲେ ୱାନ୍‌ ଉବୁଡ଼ି ଏରୁ ତାତାନ୍‌ନୋ ଲୋକା ଆଗ୍‍ଡ଼ିନେ କିୟୁ ନର୍‌ବାତାନ୍‌ନୋ ଇର୍ହାନ୍‌, “ଇୟା ଲୋକ୍‌ତି ସାନି ଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ଦସ୍‌ ସିଲେ । ଇକା ମି ପାଣି ।” ");
INSERT INTO kfcp_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ୱିଜୁ ଲୋକୁ ଇର୍ହାର୍‌, “ଜିସୁଦି ସାନି ଦସ୍‌ ମାଙ୍ଗିଁ ନି ମା କଡ଼ରି ମୁସ୍‌କୁ ରାପିତ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ସାରାସାରିୱେନ୍‌କା ପିଲାତ୍‌ ବାରବ୍‌ବାଦିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ସି ସିଜି ଜିସୁଙ୍ଗୁଁ କର୍‌ଡାଦାନ୍‌ ଡାକ୍‌ତେଙ୍ଗ୍‍ଁ ଆଦେସ୍‌ ସିତାନ୍‌, ତାନେୱେନ୍‌କା କ୍ରୁସ୍‌ଦୁ ଏକିସ୍‌ତେଙ୍ଗ୍‌ ଇଜି ସନ୍ୟରି କିୟୁଦୁ ସର୍‌ପେ କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ପିଲାତ୍‌ତି ସନ୍ୟର୍‌ ଜିସୁଙ୍ଗୁଁ ରୋମିୟ ସାସକଦି ମେଡ଼୍‍ଇଲୁଦୁ ଅତାର୍‍ ମାରି ୱିଜେରେ ସନ୍ୟର୍‌ ୱାନିଙ୍ଗ୍‌ କେର୍‌ପିସି ନିର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ୱାର୍‌ ୱାନି ଆଙ୍ଗିଁ କୁତ୍‌ତାଅତାର ୱାନିଙ୍ଗ୍‌ ଉନ୍‌ଡ୍ରି ଲାଲ୍ ରଙ୍ଗ୍‌ତି ଆଙ୍ଗିଁ ଆରିସ୍‌କିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ସାମ୍‌ ମାରାତି କମାଦାନ୍‍ ଉନ୍‌ଡ୍ରି ଟପି ତିଆର୍‌ କିଜି ୱାନି ତାଲା ମୁସ୍‌କୁ ଆରିସ୍‌କିତାର୍‌ ମାରି ୱାନି ଉଣିକିୟୁଦୁ ଉନ୍‌ଡ୍ରି ନାଡ଼ା ଆସ୍‍ପିସ୍‌କିତାର୍‌ । ତାନେୱେନ୍‌କା ୱାନି ଆଗ୍‌ଡ଼ି ମେଣ୍ଡେଙ୍ଗ୍‌ ଗଟ୍‌କିଜି, “ଏ ଜିହୁଦିରି ରାଜା, ମାଡ଼ିସ୍‍କିନିକା, ଇକା ଇନ୍‌ଞ୍ଜି ୱାନିଙ୍ଗ୍‌ ସେମାର୍‌ କିତାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ୱାର୍‌ ୱାନି ମୁସ୍‌କୁ ପୁସ୍‌ତାର୍‌, ଆୟା ନାଡ଼ା ଅସି ୱାନି ତାଲାଦୁ ଡାକ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ମାରି, ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ସେମାର୍‌ କିତିୱେନ୍‌କା ଆୟା ରାଜାରି ଆଙ୍ଗିଁ କୁତ୍‌ସିଅସି ୱାନି ନିଜେଦି ଆଙ୍ଗିଁ ଆରିସ୍‌କିତାର୍‌ ମାରି ୱାନିଙ୍ଗ୍‌ କ୍ରୁସ୍‌କାଟ୍‌ତୁ ଏକିସ୍‌କିଦେଙ୍ଗ୍‌ ଅତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ୱାର୍‌ ଗାଡ଼୍‌ତାନ୍‍ ସନିୱାଲେ ସାରିଦୁ କୁରିଣି ଗାଡ଼୍‍ଦି ସିମୋନ ଦର୍‌ତି ଅରେନ୍‍ ଲୋକ୍‌ତିଙ୍ଗ୍‌ ବେଟ୍‌ଆତାର୍‌ ମାରି ସନ୍ୟର୍‌ ୱାନିଙ୍ଗ୍‌ ଜିସୁଦି କ୍ରୁସକାଟ୍‌ ପିଣ୍ଡ୍‌ଦେଙ୍ଗ୍‌ ଇଜି ଜାସାପେଲାକିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ୱାର୍‌ ଗଲ୍‌ଗଥା ଦର୍‌ତି ଉନ୍‌ଡ୍ରି ବାଡିଦୁ ଇତାର୍‌ । “ଗଲ୍‌ଗଥାଦି ଅର୍ତ କାପାଲ୍‌ ନାନି ବାଡି ।” ");
INSERT INTO kfcp_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ଆବେନୁ ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ କେଇନିକା ମିସାତି ଅଙ୍ଗୁର୍‍ରସ୍‍ ଉନ୍‌ଣ୍ତେଙ୍ଗ୍‌ ସିତାର୍‍ । ଜିସୁ ତାନେଙ୍ଗ୍‌ କାଣ୍ତେକ୍‌ ୱେଡ଼୍‍ଜି ମାରି ଉଣୁଏତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ କ୍ରୁସ୍‌କାଟ୍‌ତୁ ଏକିସ୍‌କିଜି ମାରି ୱାନି ଆଙ୍ଗିଁୱିଜୁ କୁଡ଼ୁକୁଡ଼ିଦାନ୍‌ ନିଜେନିଜେଦି ଲୋଇ ବାଗ୍ କିଜି ଅତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ତାନେୱେନ୍‌କା ୱାର୍‌ ଆବେନୁ ବାସ୍‌ସି କ୍ରୁସ୍‌କାଟ୍‌ତୁ ଏକିସ୍‌କିତି ଜିସୁଙ୍ଗୁଁ କାପ୍‌କିଜି ତେବାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ୱାନି ବିରଦ୍‌ତାନ୍‌ ଆତିମାନି ମାଟା ଉନ୍‌ଡ୍ରି ରାସାତିମାନି ପାଟା ୱାନି ତାଲାଦି କ୍ରୁସ ମୁସ୍‌କୁ ଡ଼ତା ଡ଼ିସ୍‌ତାମାର୍ହାର୍ “ଇୟାକାନ୍‌ ଜିସୁ, ଜିହୁଦିରି ରାଜା ।” ");
INSERT INTO kfcp_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ତାନେୱେନ୍‌କା ୱାର୍‌ ରିଏର୍‌ ଡଙ୍ଗାଁରିଙ୍ଗ୍‌ ଆବେନୁ କ୍ରୁସ୍‌କାଟ୍‌ତୁ ଏକିସ୍‌କିତାର୍‌, ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ଉଣି ତରିନ୍‌ ମାରି ଆଇୱାନିଙ୍ଗ୍‍ ୱାନି ଡେବିରି ତରିନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ଆୟା ସାରିଦାନ୍‌ ସୋଲ୍‌ସିମାନି ଲୋକୁ ତାଲା ଦୁକ୍‌ସି ଜିସୁଙ୍ଗୁଁ ନିନ୍ଦା କିଜି ଇର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“ନିନୁ ମନ୍ଦିର୍‌ତିଙ୍ଗ୍‌ ରୁକୁନିନୋ ମୁନେଟି ୱେନ୍‌କା ମାରି ତାନିଙ୍ଗ୍‌ ତିଆର୍‌କିଜିମାରିଇ । ନିନୁ ଜଦି ମାପୁରୁଦି ମାରିନ୍‌, ନିଜେଦିଙ୍ଗ୍‌ ରକିୟା କିଆ । କ୍ରୁସ୍‌କାଟ୍‌ତାନ୍‌ ରେତାଜ ରାଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ପେରି ଜାଜକର୍‌, ଦାର୍ମୁଗୁରୁ ମାରି ଦାର୍ମୁ ନେତାର୍‌ ବା ଜିସୁଙ୍ଗୁଁ ସେମାର୍‌କିଜି ଇର୍ହାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“ୱାନ୍‌ ଆଇୱାରିଙ୍ଗ୍‌ ରକିୟାକିଜିମାର୍ହାନ୍‌, ମାତର୍‌ ନିଜେଦିଙ୍ଗ୍‌ ରକିୟା କିଦେଙ୍ଗ୍‌ ଆଟ୍‌ଏଜିନାନ୍‌ । ୱାନ୍‌ ପରା ଇସ୍ରାଏଲ୍‌ତି ରାଜା, ୱାନ୍‌ ଇୟାଦାପ୍ରେ କ୍ରୁସ୍‌ଦାନ୍‌ ରେତାଜରାପିନ୍‌, ମାପ୍‌ ୱାନିମାନୁ ବିସ୍‌ବାସ୍‌କିନାପ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ୱାନ୍‌ ନିଜେଦିଙ୍ଗ୍‌ ମାପୁରୁଦି ମାରିନ୍‌ ଇନ୍‌ଞ୍ଜି ମାପୁରୁଦି ମୁସ୍‌କୁ ଆସାଇଟ୍‌ତାମାନାନ୍‌ । ଆର୍‌ତିଙ୍ଗ୍‌ ସୁଡ଼ୁନାଟ୍‌, ମାପୁରୁ ଇଲେଇ ୱାନିଙ୍ଗ୍‌ ଜିପିସ୍‌ କିଦେଙ୍ଗ୍‌ ବଦାକିଜିନାନ୍‌ ନୋ ସିଲେ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ୱାନି ୱାଲେ କ୍ରୁସ୍‌କାଟ୍‌ତୁ ଡାକାଇଆତିମାନି ଡଙ୍ଗାଁର୍‌ଉଁ ବା ୱାନିଙ୍ଗ୍‌ ଆୟାୱାଜା ସେମାର୍‌ କିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ଆୟା ନାଣ୍ତିଙ୍ଗ୍‌ ବାର ଗନ୍‌ଟା ସମୟ୍‌ତୁ ପୃତିବି ୱିଜୁ ସିକାଟି ଆତାତ୍‌ ମାରି ଆକା ମୁନ୍‌ଡ୍ରି ଗଟ୍‌ନା ସାନ୍ଦି ତେବାତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ୱେଡ଼ାରେସିମାର୍‌ଇ ତିନ୍‌ଟାବେଡ଼ାଦୁ ଜିସୁ ନାଣ୍ତଆଉଲିଆଜି ଇର୍ହାନ୍‌, “ଏଲି, ଏଲି, ଲାମା ସବକ୍‌ତାନି ?” ଅର୍ତାତ୍‍, “ଏ ନା ମାପୁରୁ, ଏ ନା ମାପୁରୁ, ନିନୁ ନାଙ୍ଗିଁ ଏନ୍ଦା ଡ଼ିସ୍‌ତି ?” ");
INSERT INTO kfcp_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ଲାକ୍‌ତୁ ନିର୍‌ଇମାରିଇ ଏସଲୋକ୍‌ ଇକା ୱେନ୍‌ଞ୍ଜି ଇର୍ହାର୍‌, “ୱାନ୍‌ ଏଲିୟଙ୍ଗ୍‌ କୁକ୍‌ସିନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ଅରେନ୍‍ ଲୋକୁ ଉରୁକ୍‌ସି ସୋଲ୍‌ସି କେଇନିକା ମିସାତି ଅଙ୍ଗୁର୍‌ରସତୁ ଉନ୍‌ଡ୍ରି ଲୁବ୍‌ଲୁବାପାଗା ମୁଡୁକ୍‌ସି ତାନିଙ୍ଗ୍‌ ନାଡ଼ାଦି ଟିପୁଦୁ ତର୍‌ସି ଜିସୁଙ୍ଗୁଁ ଉଣ୍ତେଙ୍ଗ୍‌ ପେର୍‌ତା ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ମାତର୍‌ ଆଇକାର୍‌ ଇର୍ହାର୍‌, “କାପ୍‌କିଦୁ, ସୁଡ଼ୁନାଟ୍‌, ୱାନିଙ୍ଗ୍‌ ରକିୟା କିଦେଙ୍ଗ୍‌ ଏଲିୟ ୱାଜିନାନ୍‍ ନୋ ସିଲେ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ଜିସୁ ମାରିଉନ୍‌ଡ୍ରି ଦେବେଙ୍ଗ୍‌ ପେରିୱେୟୁଦାନ୍‌ ଆଉଲି ଆଜି ସାରାସାରି ୱାନି ଜିବନ୍‌ ଡ଼ିସ୍‍ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ଆୟା ବେଡ଼ାଦୁ ମନ୍ଦିର୍‌ତୁ ଦୁଙ୍ଗୁଁଜିମାନି ପାର୍‌ଦା ମୁସ୍‌କୁରାନ୍‌ ଆଡ୍‍ଗି ସାନ୍ଦି ରୁଣ୍ତି ମକେଙ୍ଗ୍‌ ଆଜି କିଜିତାତ୍‌ । ବୁମିକମ୍ପ ଆତାତ୍‌, ପିଡ଼ିପିଙ୍ଗ୍‌ୱିଜୁ ପାଡିତେସର୍‌ଏ ");
INSERT INTO kfcp_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ମାରି ଏସ ମୁସ୍‌ତିଗୁଟେଙ୍ଗ୍‌ ରେଆୟ୍‌ଆତେ, ମାରି ଗାଦି ମାପୁରୁଦି ସାତି ଲୋକୁ ମେନ୍ଧଲ୍‍ତାନ୍‌ ମାରିଡ଼େସିଜିବନ୍‌ ଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ଇୟାକାର୍‌ ମୁସ୍‌ତିଗୁଟେଣ୍‌କୁ ନିଙ୍ଗିଁଜି ୱାତାର୍‌ ମାରି ଜିସୁଦି ମାରିଡ଼େସିନିଙ୍ଗିଁନି ୱେନ୍‌କା ଇୟାୱାରିଙ୍ଗ୍‌ ପବିତ୍ର ଗାଡ଼୍‌ ଜିରୁସାଲମ୍‌ତୁ ସନିକା ଗାଦିଲୋକ୍‌ ସୁଡ଼ୁତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ଜିସୁଙ୍ଗୁଁ କାପ୍‌କିଦେଙ୍ଗ୍‌ ତେବାତିମାନି ସେନାପତି ମାରି ସନ୍ୟର୍‌ ବୁମିକମ୍ପ ନି ଆଇଆଇ ଗଟ୍‌ନେଙ୍ଗ୍‌ ସୁଡ଼ୁଜି ତିଲାତା ସର୍‌ର୍ହାର୍‌, ୱାର୍‌ ଇର୍ହାର୍‌, “ସତ୍‍ନେ, ଇୟାକାନ୍‌ ମାପୁରୁଦି ମାରିନ୍‌ ମାର୍ହାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ଗାଲିଲିଦାନ୍‌ ଜିସୁଦି ୱେନ୍‌କାୱାଜି, ୱାନିଙ୍ଗ୍‌ ସେବା କିତିମାନି ଗାଦି ଆଇମେକ୍‍ ଆକରାନ୍‍ ମାନ୍‌ଞ୍ଜି ୱିଜୁ ସୁଡ଼ୁଜି ମାରେଏ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ଇୟାୱାନିକା ମାଣ୍‌କୁ ମାର୍‌ଏ ମଗ୍‌ଦଲିନି ମରିୟମ୍‌, ଜାକୁବ ନି ଜୋସେପ୍‌କା ଆଇସି ମରିୟମ୍‌ ମାରି ଜେବଦିଦି ଆଡ଼୍‌ସି । ");
INSERT INTO kfcp_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ମିଲିମିଲିକା ବେଡ଼ାଦୁ ହାରାମାତିୟା ଗାଡ଼୍‌ତି ଜୋସେପ୍‌ ଦର୍‌ତି ଅରେନ୍‍ ମାଜନ୍‌ ଲୋକୁ ୱାତା ଇତାନ୍‌ । ୱାନ୍‌ ଜିସୁଦି ଅରେନ୍‍ ସିସୁ ମାର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ୱାନ୍‌ ପିଲାତ୍‌ତିଙ୍ଗ୍‌ ତରାଆୟ୍‌ଆତାନ୍‌ନୋ ଜିସୁଦି ମେନ୍ଦଲ୍‌ତିଙ୍ଗ୍‌ ଅତେଙ୍ଗ୍‌ ଇଜି ଅନୁମତି ଲସ୍‌ତାନ୍‌ । ଆର୍‌ତିଙ୍ଗ୍‌ ପିଲାତ୍‌ ଜିସୁଦି ମେନ୍ଦଲ୍‌ତିଙ୍ଗ୍‌ ଅତେଙ୍ଗ୍‌ ଆଦେସ୍‌ ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ଜୋସେପ୍‌ ଜିସୁଦି ମେନ୍ଦଲ୍‌ତିଙ୍ଗ୍‌ ଅତାନ୍‌ନୋ ଉନ୍‌ଡ୍ରି ନେଗି ୱାତିଦୁ ତେରେପ୍‌ତାନ୍‌ ମାରି ");
INSERT INTO kfcp_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ୱାନି ନିଜେଦି ଉଣ୍ତିଙ୍ଗ୍‌ କାଲୁଦୁ କାରିତି ମାରିଇ ଉନ୍‌ଡ୍ରି ପୁନି ମୁସ୍‌ନିବାଡିଦୁ ୱାନିଙ୍ଗ୍‌ ଇଟ୍‌ତାନ୍‌ ମାରି ଗୁଟାଦିମକମ୍‌ତୁ ଉନ୍‌ଡ୍ରି ପେରି କାଲୁ କେରେପ୍‌ତା ସର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ ନି ଆଇ ମରିୟମ୍‌ ଆୟାବାନୁ ଗୁଟାଦିଙ୍ଗ୍‌ ମକମ୍‌କିଜି ବାସ୍‌ତେ ମାର୍‌ଏ । ");
INSERT INTO kfcp_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ଆୟା ମାର୍‌ନାଣ୍ଡିଙ୍ଗ୍‌ ଅର୍ତାତ୍‍ ରମ୍‌ନିନାଣ୍ତିଙ୍ଗ୍‌ ପେରି ଜାଜକର୍‌ ନି ପାରୁସିର୍‌ ପିଲାତ୍‌ତିଙ୍ଗ୍‌ ବେଟ୍‌ଆତାର୍‌ନୋ ଇର୍ହାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“ଆଜ୍ଞା, ମାଙ୍ଗିଁ ମନ୍‌ତୁମାନାତ୍‌, ଆୟା ମିଚ୍‌ୱେର୍‌ନିକାନ୍‌ ଜିବନ୍‌ମାର୍‌ଇ ୱାଲେ ଇର୍‌ଆ ମାର୍ହାନ୍‌, ‘ମୁନେଟି ୱେନ୍‌କା ନାନ୍ ନିଙ୍ଗିଁନା ।’ ");
INSERT INTO kfcp_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ଆଦେଙ୍ଗ୍‌ ମୁନେନ୍‌ ସାନ୍ଦି ଆୟା ମୁସ୍‌ତିଗୁଟାଦିଙ୍ଗ୍‌ କାପ୍‌କିଜ ମାନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ କାପ୍‌କିନିୱାରିଙ୍ଗ୍‌ ଆଦେସ୍‌ ସିପିନ୍‌, ଆର୍‌ତିଙ୍ଗ୍‌ ୱାନି ସିସୁର୍‍ ୱାନି ମେନ୍ଦଲ୍‌ତିଙ୍ଗ୍‌ ଡଙ୍ଗାଁକିଜ ଅସ, ୱାନ୍‌ ଜିବନ୍‌ଆଜି ନିଙ୍ଗିଁତାମାନାନ୍‌ ଇଜି ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆଟ୍‍ଏର୍‍ । ୱାରି ଇୟା ମିସ୍‌ ମାଟା ୱିଜୁମାଣ୍‌କୁ ନାଣ୍ତ ତାଗ୍‌ଇକା ଆନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ପିଲାତ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଦଲ୍‌ କାପ୍‌କିନିୱାରିଙ୍ଗ୍‌ ଅତୁ ମାରି ଆୟା ମୁସ୍‌ତିଗୁଟାଦିଙ୍ଗ୍‌ ବେଗି ସୁରକ୍ଷା କିଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ୱାର୍‌ ସର୍ହାର୍‌ନୋ ଗୁଟାଦିଙ୍ଗ୍‌ ସୁରକ୍ଷା କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ତିଆର୍‌କିତାର୍‌ । ଆୟା ମକମ୍‍ତିଙ୍ଗ୍ କେରେପ୍‌ସି ଇଟ୍‍ତିମାନି କାଲୁ ମୁସ୍‌କୁ ଟାଆପ୍‌ ବାସାକିଜି କାପ୍‌କିନି ଉଣ୍ତିଙ୍ଗ୍‌ କାପ୍‌କିନିୱାରିଙ୍ଗ୍‌ ଇଟ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ରମ୍‍ନିଦିନ୍‍ ୱିଜିତି ୱେନ୍‌କା ଆଦିୱାର୍‍ ସାଲ୍‍ଦି ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ ମାରି ଆଇ ମରିୟମ୍‌ ଦୁକିଦୁ ସୁଡ଼୍‍ଦେଙ୍ଗ୍‍ ସର୍ହେ । ");
INSERT INTO kfcp_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ନାସ୍ତିୱାଲେ ଆୟାଦାପ୍ରେନେ ଉଣ୍ତ୍ରି ପେରି ବୁମି ତିରିଗ୍‌ନାତ୍‌ ଆତାତ୍‌ । ପ୍ରବୁଦି ଅରେତ୍‌ ଦୁତ୍‍ ମୁସ୍‌କୁରାନ୍‌ ରେତାଜି ୱାଜି ଦୁକିଦି ମକମି ମାର୍‍ଇ କାଲୁଦିଙ୍ଗ୍‌ ଗୁସା କିଜି ତାନି ମୁସ୍‌କୁ ବାସ୍‌ତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ତାନି ରୁପ୍‌ ଜାୟ୍‍ତି ୱାଜା ମାରି ତାନି ଆଙ୍ଗିଁ ଆଣ୍ତ୍ରାଗା ୱାଜା ଅଡ଼ିନିକା ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ୱାନିଙ୍ଗ୍‌ ସୁଡ଼୍‌ଜି କାପ୍‌କିନିକାର୍‌ ତିଲାଜି ତିର୍‍ଗିତାର୍‍ ମାରି ସାତି ମାଡ଼ାଦି ୱାଜା ଆତା ସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ଦୁତ୍‍ ଆୟା ଆଇମେକାଙ୍ଗ୍‍ଁ ଇର୍ହାତ୍‌, “ତିଲାମାଟ୍‌ ।” ନାନ୍ ନେସ୍‌ନା, ମିର୍‌ କ୍ରୁସଦୁ ଡାକାଇଆତି ଜିସୁଙ୍ଗୁଁ ସୁଡ଼୍‍ଦେଙ୍ଗ୍‍ ୱାତିମାନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ୱାନ୍‌ ଇବେ ସିଲେନ୍‌, ୱାନ୍‌ ଏଣ୍ତେସ୍‌ ଇର୍ହାମାର୍ହାନ୍‌, ଆୟାୱାଜା ନିଙ୍ଗିଁତାମାନାନ୍‌ । ରାଦୁ, ୱାନି ସାତିମାଡ଼ା ଏମେମାନୁ ଇଟ୍‌ତାମାର୍ହାନ୍‍, ଆୟା ବାଡି ସୁଡ଼୍‍ଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ଦାପ୍ରେ ସଲ୍‌ସି ୱାନି ସିସୁରିଙ୍ଗ୍‌ ଇନ୍‍ଡ୍ରୁ, ୱାନ୍‌ ସାତିମାଣାନ୍‌ ଡ଼େସି ନିଙ୍ଗିଁତାମାନାନ୍‌ ମାରି ମି ଆଗ୍‌ଡ଼ି ଆଗ୍‌ଡ଼ି ୱାନ୍‌ ଗାଲିଲିଦୁ ସଲ୍‌ସିନାନ୍‌ । ଆବେ ମିର୍‌ ୱାନିଙ୍ଗ୍‌ ସୁଣିଦେର୍‍ । ନାନ୍ ଆମାକା ଇର୍‌ଆ, ମୋନ୍‌ତୁ ଇଡ୍‌ଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ଇବେଟ୍‍ ୱାକ୍‍ ତିଲାଜି ନି ନାଣ୍ତ ୱେଡ଼ିକାଦାନ୍‌ ଦୁକିଦାନ୍‍ ଦାପ୍ରେ ଡ଼େସି ସଲ୍‌ସି ୱାନି ସିସୁରିଙ୍ଗ୍‌ କାବୁର୍‌ ସିଦେଙ୍ଗ୍‍ଇଜି ଉର୍‍କୁତେ । ");
INSERT INTO kfcp_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ଦାପ୍ରେ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ବେଟ୍‍ବୁଡ଼ାଜି ଇର୍ହାନ୍‌, “ମି ସାନ୍ତିଆପିତ୍‍ ।” ୱାର୍‌ ୱାନି ଲାକ୍‌ତୁ ସଲ୍‌ସି ୱାନି ପାଦାମ୍‌କୁ ଆସ୍‌ସି ମାଡ଼ିସ୍‍କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ତିଲାମାଟ୍‌ ।” ମିର୍‌ “ସଲ୍‌ସି ନା ତଡ଼ାନ୍‍କାଙ୍ଗ୍‍ ୱେର୍‌ଆ, ୱାର୍‌ ଗାଲିଲିଦୁ ସଲିର୍‌, ଆବେ ୱାର୍‌ ନାଙ୍ଗିଁ ସୁଣାର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ଆଇମେକ୍‍ ଆବେଟ୍‌କୁ ବୁଲାଜି ସୋଲ୍‌ସିମାନିୱାଲେ ମୁସ୍‌ତିଗୁଟାଦିଙ୍ଗ୍‌ କାପ୍‌କିଜି ତେବାଜିମାର୍‌ଇ ଏସଲୋକ୍‌ କାପ୍‌କିନିକାର୍‌ ଗାଡ଼୍‌ତୁ ଡ଼େସିସୋର୍ହାନ୍‌ନୋ ପେରି ଜାଜକରିଙ୍ଗ୍‌ ଇୟାୱିଜୁ ଗଟ୍‌ନା ୱେର୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ପେରି ଜାଜକର୍‌ ଦାର୍ମୁ ନେତାରି ୱାଲେ ୱାର୍‌ଗିଜି ସାତାର୍‌, ଆୟା ସନ୍ୟରିଙ୍ଗ୍‌ ଗାଦି ଡାବୁଙ୍ଗୁଁ ଲାଞ୍ଚ୍‌ ସିଜି ୱାରିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“ମିର୍‌ ୱେର୍‍ତୁ ଜେ ନାଡ଼ା ମିର୍‌ ସୁସ୍‌ତିମାରିଇବେଡ଼ାଦୁ ୱାନି ସିସୁର୍‍ ୱାଜି ମାଡ଼ାଦିଙ୍ଗ୍‍ ଡଙ୍ଗାଁକିତାଅତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ମାରି, ଜଦି ସାସନ୍‍କିନିକାନ୍‍ ଇୟା ମାଟା ୱେନ୍‌ନାନ୍‌ ମାପ୍‌ ୱାନିଙ୍ଗ୍‌ ବୁଜାକିନାସିନାପ୍‌ଜେ ମିର୍‌ ଦସ୍‌କିଇଦେର୍‌ । ଇୟା ବିସୟ୍‌ତାନ୍‌ ମିର୍‌ ଦାନ୍ଦାଆମାଟ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ସନ୍ୟର୍‌ ଡାବୁଙ୍ଗୁଁ ଅସି ୱାରିଙ୍ଗ୍‌ ୱେର୍‌ତିମାନି ଇସାବ୍‌ତାନ୍‌ ପାଣି କିତାର୍‌ । ୱାର୍‌ ନାସ୍ତିୱାଲେ ଆମାକା ଇର୍ହାର୍‌, ଜିହୁଦିର୍‌ ନେର୍‌ ସାନ୍ଦି ଆୟା ମାଟା ୱେର୍‌ସିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ଜିସୁ ୱେର୍‌ତିମାନି ଅନୁସାର୍‌ଦାନ୍‌ ଏଗାର୍‌ ଲୋକୁ ସିସୁର୍‍ ଗାଲିଲିଦୁ ସୋଲ୍‌ସି, ଜିସୁ ଆମା ଗରନ୍‌ ବିସୟ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆ ମାର୍ହାନ୍‌, ଆୟା ଗରନ୍‌ତୁ ସର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ମାରି, ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ସୁଡ଼ୁଜି ମାଡ଼ିସ୍‌କିତାର୍‌, ମାତର୍‌ ଏନ୍‌ ଏନ୍‌ ନାମ୍‌ଏତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ଜିସୁ ୱାରି ଲାକ୍‌ତୁ ୱାଜି ଇର୍ହାନ୍‌, “ମୁସ୍‌କୁପୁର୍‌ ନି ଆଡ୍‍ଗିପୁର୍‍ ୱିଜୁ ଅଦିକାର୍‌ ନାଙ୍ଗିଁ ସିଆୟ୍‌ଆତାମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ମିର୍‌ ୱିଜୁ ବାସାଦି ଲୋକା ଲାକ୍‌ତୁ ସୋଲ୍‌ସି ୱାରିଙ୍ଗ୍‌ ନା ସିସୁ କିଦୁ । ମାରି ବୁବା, ମାରିନ୍‌ ମାରି ପବିତ୍ର ଆତ୍ମାଦି ଦର୍‌ତାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଡୁବନ୍‌ ସିଦୁ, ");
INSERT INTO kfcp_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ମାରି ନାନ୍ ଆମା ୱିଜୁ ଆଦେସ୍‌ ସିତାମାନା, ଆୟାୱିଜୁ କିଦେଙ୍ଗ୍‌ ୱାରିଙ୍ଗ୍‌ ସିକିୟା ସିଦୁ । ମାରି ମନେଇଡ଼୍‌ଦୁ, ଜୁଗ୍‌ସେସ୍‌ ଆନିସାନ୍ଦି ୱିଜୁୱାଲେ ନାନ୍ ମି ୱାଲେମାନା ।”");
INSERT INTO kfcp_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ଇକା ଆଜିନାତ୍‍ ମାପୁରୁ ମାରିସି ଜିସୁ କ୍ରିସ୍ତଦି ନେଗି କାବୁର୍‌ ଆରାମ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ଜିସାୟ ବାବବାଦିଦି ବଇଦୁ ଏଣ୍ତେସ୍‌ ରାସାତାମାନାତ୍‌, “ସୁଡ଼ୁଦୁ, ମାପୁରୁ ଇର୍ହାନ୍‌,” ମାପ୍‌ ମା ଦୁତ୍‌ତିଙ୍ଗ୍ ମି ଆଗ୍‌ଡ଼ି ପୋକ୍‌ନାପ୍‌, ୱାନ୍‌ ମି ସାରି ରସ୍‍ନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ମରୁବୁମିଦୁ ପେରିୱେୟୁଦାନ୍‌ ଆଉଲିଆଜିମାନି ଅରେନ୍‍ ୱାନି ବଲ୍, ପ୍ରବୁଦି ସାରି ରସ୍‍ଆ, ୱାନି ସାରି ସାଡ଼ୁକୁ କିଆ । ");
INSERT INTO kfcp_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ଆବେଟ୍‌କୁ ଏର୍‌ତୁ ଡୁବନ୍‌ ସିନି ଜୋହନ ବାଲିଭୁମିଦୁ ସର୍ହାନ୍‍ନୋ ୱେର୍‍ତାନ୍‌, ମାରି ଡୁବନ୍‌ ସିତାନ୍‌ । ୱାଣ୍ଡ୍‌ରୁ ପ୍ରଚାର୍‌ କିଜି ଲୋକାଙ୍ଗ୍‌ ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌, “ପାପ୍‌ତାନ୍‌ ମନ୍‍ତିଙ୍ଗ୍‍ ଡ଼େପ୍‍ତୁ, ମାରି ଡୁବନ୍‌ ଅତୁ ଆବେଟ୍‌ ମାପୁରୁ ମି ପାପ୍‌କେମା କିନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ଆବେଟ୍‌ ଯିହୁଦା ରାଜି ମାରି ଜିରୁସାଲାମ୍‍ତି ୱିଜୁ ଲୋକୁ ସତାରୋ ଯୋହନତି ଲାକ୍‌ତୁ ୱାଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ ମାରି ନିଜେ ନିଜେଦି ପାପ୍‌ ମାନାଜି ୱାନି ମାଣ୍‌କୁ ଜର୍ଦନ ଗାଡାଦୁ ଡୁବନ୍‌ ଅତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ଜୋହନ ଉଟ୍‌ ବୁର୍‍ବୁସାଦାନ୍‍ ତିଆର୍‌ ଆତି ଆଙ୍ଗିଁ ଆରାଜି ମାର୍‍ଆନ୍‍ ମାରି ୱାନି ଜୁକିଦି ସାରିବେଡ୍‍ତି ତଲ୍‍ତି ନାସ୍‍ ତରାଜିମାର୍ହାନ୍‍, ମାରି ମାଡ଼ିମାଉ ନି ଗରନ୍‌ ପୁକି ତିନ୍‍ଜିମାର୍‍ଆନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ୱାଣ୍ତ୍ରୁ ଆଉଲି ଆଜି ଇଣ୍ତ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌, “ଏନ୍‍କି ନା ମାଣ୍‌କୁ ନାଣ୍ତ ବପୁମାନାନ୍‍, ଆକାନ୍‍ ନା ୱେନ୍‌କା ୱାଜିନାନ୍‍; ନାନୁ ପାଡ଼୍‍ଜ ଜୁତେଙ୍ଗ୍‌ତି ଗାଟି ବା କୁତ୍‍ତେଙ୍ଗ୍‍ ଜଗ୍‌ ସିଲେ । ");
INSERT INTO kfcp_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ନାନୁ ମିଙ୍ଗିଁ ଏର୍‌ତୁ ଡୁବନ୍‌ ସିଜିନା, ମାତର୍‌ ୱାନ୍‌ ମିଙ୍ଗିଁ ପବିତ୍ର ଆତ୍ମାଦୁ ଡୁବନ୍‌ ସିନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ନାସ୍ତିୱାଲେ ଜିସୁ ଗାଲିଲି ରାଜିଦି ନାଜରିତ ଦର୍‌ତି ନାଟାଣ୍‍କୁ ୱାଜି ଜର୍ଦନ ଗାଡାଦୁ ଜୋହନମାନୁ ୱାନ୍‌ ଡୁବନ୍‌ ଅତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ଜିସୁ ଏର୍‍ତାନ୍‍ ସହସି ୱାନିୱାଲେ ବାଦଡ଼୍‍ ରେଆତି ମାନିୱାଜା ମାରି ପବିତ୍ର ଆତ୍ମା ପାର୍‍ୱାଦି ୱାଜା ୱାଜି ୱାନି ମୁସ୍‌କୁ ରେତାନିକା ୱାନ୍‌ ସୁଡ଼ୁତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ନାସ୍ତିୱାଲେ ବାଦଡ଼୍‍ତାନ୍‍ ଉଣ୍ତ୍ରି ବଲ୍ ୱେଙ୍ଗିଁତାତ୍‍, “ନିନୁ ମା ଲାଡ୍‍ତି ମାରିନ୍‌, ନିବାନ୍‍ ମାପୁ ନାଣ୍ତ ୱେଡ଼ିକା ।” ");
INSERT INTO kfcp_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ଆୟାଦାପ୍ରେ ପବିତ୍ର ଆତ୍ମା ଜିସୁଙ୍ଗୁଁ ଉଣ୍ତ୍ରି ସିମ୍ରା ବାଡିଦୁ ଅତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ଜିସୁ ସିମ୍ରା ବାଡିଦୁ ସାଲିସ୍‍ ଦିନ୍‌ ତେବାଜି; ସୟତାନ୍‍ତି ମାଣାନ୍‌ ପରିକା କିଆୟ୍‍ଆତାନ୍‍; ଜିସୁ ବନ୍‍ତି ଜାତୁଙ୍ଗାୱାଲେ ମାର୍‌ଆନ୍‌, ମାତର୍‌ ମୁସ୍‌କୁପୁର୍‌ତି ଦୁତ୍‌କୁ ୱାଜି ୱାନି ସେବାକିଜିମାରେଏ । ");
INSERT INTO kfcp_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ଯୋହନ ଜଇଲ୍‌ତୁ ସର୍‍ହି ୱେନ୍‌କା ଜିସୁ ଗାଲିଲି ରାଜିଦୁ ୱାତାନ୍‌ ନୋ ମାପୁରୁଦି ନେଗି କାବୁର୍‌ ପ୍ରଚାର୍‌ କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ଜିସୁ ୱେର୍‌ତେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌, “ଦିନ୍‌ ଲାକ୍‌ତୁ ୱାତାତ୍‌ନି, ମାପୁରୁଦି ରାଜି ଇଗା ୱାଜିନାତ୍ ! ପାପ୍‌ତାନ୍‌ ମନ୍‍ତିଙ୍ଗ୍‍ ଡ଼େପ୍‍ତୁ ମାରି ମାପୁରୁଦି ନେଗିକାବୁର୍‌ତୁ ବିସ୍‌ବାସ୍‌ କିଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ଜିସୁ ଗାଲିଲିଦି ସାମ୍‌ଦୁର୍‌ ପାଡ଼ି ସିଜି ସନିୱାଲେ ସିମୋନ୍‌ ପିତର ମାରି ଆନ୍ଦ୍ରିୟ ତଡ଼୍‍ ରିଏରିଙ୍ଗ୍‍ ସାମ୍‌ଦୁର୍‌ତୁ ମିନ୍‌କୁ ଜାଡ଼ି ପକ୍‍ନିକା ସୁଡ଼ୁତାନ୍‌, ଇରିଙ୍ଗ୍‌ ୱାର୍‌ ମିନ୍‌କୁ ଆସ୍‍ନିକାର୍‍ ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ନା ୱାଲେ ରାଦୁ, ନାନ୍ ମିଙ୍ଗିଁ ଲୋକାଙ୍ଗ୍‌ ମାପୁରୁ ଲାକ୍‌ତୁ ତାନିକା ଅଜାକିନା । ");
INSERT INTO kfcp_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ଆବେଟ୍‌ ୱାର୍‌ ଆୟାଦାପ୍ରେ ଜାଡ଼ି ଡ଼ିସ୍‍ତାରୋ ଜିସୁୱାଲେ ୱାଲେ ସର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ମାରି, ଜିସୁ ଅଡ଼ପ୍‍ ଆଗ୍‌ଡ଼ି ସର୍‍ଆନ୍‍ନୋ ଜେବଦିଦି ରିଏର୍‌ ମାରିସିର୍‌ ଜାକୁବ ନି ୱାନି ତଡ଼ାନ୍‌ ଜୋହନତିଙ୍ଗ୍‍ ୱାରି ଡଙ୍ଗାଁଦୁ ଜାଡ଼ି ମଦାକିନିକା ସୁଡ଼ୁତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ସୁଡ଼ୁଜି ଦାପ୍ରେ ୱାନି ଲାକ୍‌ତୁ କୁକ୍‍ତାନ୍‍, ୱାର୍‌ ୱାରି ବୁବାସି ଜେବଦିଙ୍ଗ୍‍ ବୁତିକିନି ଲୋକାୱାଲେ ଡଙ୍ଗାଁଦୁ ଡ଼ିସ୍‍ତାରୋ ଜିସୁୱାଲେ ୱାଲେ ସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ଜିସୁ ମାରି ସିସୁର୍‌ କପର୍‍ନାହୁମ୍‍ ଇନି ଗାଡ଼୍‌ତୁ ସର୍‌ଆର୍‌, ଆୟାଦାପ୍ରେ ଜିସୁ ରୋମ୍‍ନି ନାଣ୍ଡିଙ୍ଗ୍ ଜିହୁଦିରି ପାର୍‌ତନା କିନି ଇଲୁ ଲୋଇ ସର୍‍ଆନ୍‍ନୋ ସିକିୟା ସିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ୱାନି ସିକିୟା ୱେନ୍‍ଜି ଲୋକ୍‌ଡର୍‌ କାବାଆତାର୍‌; ଇରିଙ୍ଗ୍‌ ଜିସୁ ସାସ୍ତ୍ରୀରି ୱାଜା ସିକିୟା ସିଏନ୍‍ଣ୍ତା ଅରେନ୍‍ ଅଦିକାର୍ ପଇତି ଲୋକ୍‌ତି ୱାଜା ସିକିୟା ସିଜି ମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ନାସ୍ତିୱାଲେ ଅରେନ୍‍ ଦୁବା କାସ୍ତି ଲୋକୁ ପାର୍‌ତନା କିନି ଇଲୁ ଲୋଇ ମାରାନ୍‌ ନୋ ଆଉଲି ଆଜି ଇର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“ଏ ନାଜରିତିୟ ଜିସୁ, ନିୱାଲେ ମା ଇନି ପାଣି ମାନାତ୍‌ ? ନିନ୍‌ନେ ମାଙ୍ଗିଁ ୱିସ୍‍ତେଙ୍ଗ୍‍ ୱାତି ? ନିନୁ ଏନ୍‌ ଆକା ନାନ୍ ନେସ୍‌ନା, ନିନୁ ମାପୁରୁତି ମାଣ୍‌କୁ ୱାତିମାନି ପବିତ୍ର ଲୋକୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ଜିସୁ ତାନିଙ୍ଗ୍‌ ଆଦ୍‌ରିସ୍‌ କିଜି ଇର୍ହାନ୍‌, “ଆଲ୍‌ଜ ମାନ୍‌ଆ, ଇୟା ୱେନିମାଣ୍‌କୁ ସସି ସାଙ୍ଗ୍‌ଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ତାନେ ୱେନ୍‌କା ଆୟା ତାଗ୍‍ଇଆତ୍ମା ୱାନିଙ୍ଗ୍‌ ଦୁକ୍‍ତା ପକ୍‍ତା ଦୋ ନାଣ୍ତ ପେରି ୱେୟୁଦାନ୍‍ ଆଉଲି ଆଜି ୱାନି ମାଣ୍‌କୁ ସତା ସର୍‌ଆତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ଆବେ ମାର୍‍ଇ ଲୋକ୍‌ଡର୍‌ କାବାଆତା ସର୍‌ଆର୍‌ନୋ ୱାରି ୱାରି ଲୋଇ ୱାର୍‍ଗିଜି ସାତାର୍‌, “ଇକା ଇନିକା ? ଇକା ତୋ ଉଣ୍ତ୍ରି ଅଦିକାର୍ ମାନି ପୁନି ସିକିୟା, ୱାନ୍‌ ତାଗ୍‌ଇ ଆତ୍ମେଆଙ୍ଗ୍‌ ବା ଆଦେସ୍‌ ସିନାନ୍‍, ମାରି ତାଗ୍‌ଇ ଆତ୍‍ମେଙ୍ଗ୍‍ ୱାନି ଆଦେସ୍‌ ମାନାନେ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ଆୟାୱେନ୍‌କା ଜିସୁଦି ବିସୟତୁ ମାଟା ଦାପେ ଦାପେ ଗାଲିଲି ରାଜିଦୁ ୱିଜୁ ତରିନ୍‌ ୱେଙ୍ଗିଁତାସର୍‍ଆତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ତାନେ ୱେନ୍‌କା ଜିସୁ ମାରି ସିସୁର୍‌ ପାର୍‌ତନା କିନି ଇଲୁଦାନ୍‌ ସତାରୋ ଯାକୁବ ନି ଜୋହନ ୱାଲେ ଆୟାଦାପ୍ରେ ସିମୋନ୍‌ ମାରି ଆନ୍ଦ୍ରିୟରି ଇଲ୍‌ତୁ ସର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ସିମୋନ୍‌କା ମିମ୍‍ସି ନବ୍‍ତି ଉଣ୍ତିଙ୍ଗ୍‌ ନିଙ୍ଗ୍‍ଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏଜି ମାର୍‌ଆତ୍‌, ମାରି ସିସୁର୍‌ ଆୟାଦାପ୍ରେ ତାନେ ମାଟା ଜିସୁଙ୍ଗୁଁ ୱେର୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ଆବେଟ୍‌ ଜିସୁ ଲାକ୍‌ତୁ ସର୍‍ଆନ୍‍ନୋ ତାନି କିୟୁ ଆସ୍‍ତାନ୍‍ନୋ ତାନେଙ୍ଗ୍‌ ନିକ୍‍ତାନ୍‍, ଆବେଟ୍‌ ତାନିଙ୍ଗ୍‌ ନବ୍‌ ଡ଼ିସ୍‍ତାତ୍‍, ମାରି ୱାଦ୍‌ ନେଗେଣ୍ତ୍‍ ଆତାଦୋ ଜିସୁ ମାରି ସିସୁରି ଉଣ୍ତିଙ୍ଗ୍‌ ଖାଦି ସେବା ତିଆର୍‌ କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ୱେଡାସର୍ହି ୱେନ୍‌କା ଲୋକ୍‌ଡର୍‌ ଜିସୁ ଲାକ୍‌ତୁ ୱିଜୁ ରକମ୍‌ତି ରୋଗ୍‌ ମାରି ଦୁବା କାସ୍ତି ଲୋକାଙ୍ଗ୍‌ ତାତେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ଆୟା ଗାଡ଼୍‌ତି ଲୋକୁ ୱିଜେରେ ୱାଜି ଆୟା ଇଲୁ ସେର୍‍ଲା ଲାକ୍‌ତୁ ଉଣ୍ତାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ଜିସୁ ନାନା ରକମ୍‌ତି ରୋଗ୍‍ ଲୋକାଙ୍ଗ୍‍ ନେଗେଣ୍ତ୍‌ କିତାନ୍‌ ମାରି ଏସ ଦୁବା କାସ୍ତି ଲୋକାଙ୍ଗ୍‌ ଡ଼ିସିସ୍‍ କିତାନ୍‌, ମାରି ୱାନ୍‌ଡ୍ରୁ ଦୁବେଆଙ୍ଗ୍‍ ୱାର୍‍ଗିଦେଙ୍ଗ୍‍ ସିଏତାନ୍‌, ଇରିଙ୍ଗ୍‌ ଦୁବେଙ୍ଗ୍‍ ଡର୍‍ ଜିସୁଙ୍ଗୁଁ ନେସ୍‌ସି ମାର୍‍ହେ । ");
INSERT INTO kfcp_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ମାର୍‌ନାଣ୍ଡିଙ୍ଗ୍‌ ୱେଡ଼ା ସନି ଆଗ୍‌ଡ଼ି ସାଲ୍‌ଦି ସିକାଟି ମାନ୍‌ବୁ ମାନ୍‌ବୁନେ ଜିସୁ ନିଂଇତା ସତା ସର୍‌ଆନ୍‌ ମାରି ଉଣ୍ତ୍ରି ସିମ୍ରା ବାଡିଦୁ ସର୍‍ଆନ୍‍ନୋ ଆବେ ପାର୍‌ତନା କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ସିମୋନ୍‌ ମାରି ୱାନି ତଡ଼୍‍ ଲୋକୁ ଜିସୁଙ୍ଗୁଁ ପ‍ଇଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ଏସ୍ତିୱାଲେ ଜିସୁଙ୍ଗୁଁ ୱାର୍‌ ସୁଡ଼ୁତାର୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ୱିଜେରେ ନିଂଇ ପଇଜି ଅସିନାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ମାତର୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ରାଦୁ, ମାଡୁ ଇୟା ଲାକ୍‌ତୁ ମାନି ନାର୍‍କାଙ୍ଗ୍‍ଁ ସନାଟ୍‌ । ନାନ୍ ଆବେବା ପ୍ରଚାର୍‌ କିନା, ଇରିଙ୍ଗ୍‌ ଆୟା ଉଣ୍ତିଙ୍ଗ୍‌ ନାନୁ ସତା ୱାତାମାନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ଆୟାୱେନ୍‌କା ଜିସୁ ଗାଲିଲି ରାଜିଦି ୱିଜୁ ନାର୍‍କାଙ୍ଗ୍‍ଁ ବୁଲାଜି ବୁଲାଜି ୱାରି ୱିଜୁ ପାର୍‍ତନାକିନି ଇଲ୍‌କାଙ୍ଗ୍‌ ପ୍ରଚାର୍‌ କିତାନ୍‌ ମାରି ଦୁବେଙ୍ଗ୍‍ ଆସ୍‍ତି ଲୋକାଙ୍ଗ୍‌ ଡ଼ିସ୍‍ପିସ୍‍ତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ଜିସୁଦି ଲାକ୍‌ତୁ ଅରେନ୍‍ କୁସ୍ଟରୋଗ୍‌ ଆତି ମାରିକାନ୍‌ ୱାତାନ୍‌ ନୋ ୱାନି ଆଗ୍‌ଡ଼ି ମେଣ୍ତେଙ୍ଗ୍‍ ଗଟ୍‍ କିତାନ୍‍ନୋ ଇର୍‌ଆନ୍‌, “ନିନ୍‌ ଜଦି ବଦା କିନି, ନାଙ୍ଗିଁ ନେଗେଣ୍ତ୍‌ କିଦେଙ୍ଗ୍‌ ଆଟ୍‌ନି ।” ");
INSERT INTO kfcp_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ଜିସୁ ଦୟା ତର୍‍ତାନ୍‍ନୋ କିୟୁ ପେର୍‌ଜି ୱାନିଙ୍ଗ୍‌ ମୁଟ୍‌ସି ଇର୍ହାନ୍‌, ନାନ୍ ବଦା କିଜିନା, “ନିନ୍‌ ନେଗେଣ୍ତ୍‌ ଆଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ଆୟାଦାପ୍ରେନେ କୁସ୍ଟରୋଗ୍‌ ୱାନି ମାଣାନ୍‌ ଡ଼ିସ୍‍ତା ସର୍‌ଆତ୍‌ ମାରି ୱାଣ୍ତ୍ରୁ ନେଗେଣ୍ତ୍‌ ଆତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ଇୟା ୱେନ୍‌କା ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଆଟ୍‍ୱାଦାନ୍‍ ଆଦେସ୍‌ ସିଜି ଆୟାଦାପ୍ରେ ପୋକ୍‌ସି ଇର୍‌ଆନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“ଜାଗାର୍‌ତା, ଏଙ୍ଗ୍‌ବା ଇନିକା ଇନ୍‍ମା, ମାତର୍‌ ସାଙ୍ଗ୍‍ଆ, ଜାଜକରିମାନୁ ନିଜେଦିଙ୍ଗ୍‍ ତର୍‌ଆ; ନିନ୍‌ ଜେ ନେଗେଣ୍ତ୍‌ କିଆଇଆତିମାନି ଇକା ଲୋକାମାନୁ ସାକି ସିଦେଙ୍ଗ୍‍ ଇଜି ମୋସାଦି ସିତିମାନି ନିୟମ୍‍ତାନ୍‍ ପୁଜା ସିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ମାତର୍‌ ଆକାନ୍‍ ସତା ସର୍‌ଆନ୍‌ ନୋ ଇୟା ମାଟା ୱିଜୁ ତରିନ୍‌ ଇଜି ବୁଲାତାନ୍‌ ଜେ, ଜିସୁ ମାରି ପ୍ରଚାର୍‌ କିଦେଙ୍ଗ୍‌ ତରାଜି ଏମେ ନାର୍‍ତୁବା ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଆଟ୍‍ଏତାନ୍‍, ମାତର୍‌ ଜିସୁ ଆତ୍‌ରେ ସିମ୍ରା ବାଡିଦୁ ମାନ୍‌ଜି ମାର୍‌ଆନ୍‌; ମାରି ୱିଜୁ ତରିଣ୍‍ତି ଲୋକୁ ଜିସୁ ଲାକ୍‌ତୁ ୱାଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ଏସୋ ଦିନ୍‌ ସରିଇ ୱେନ୍‌କା ଜିସୁ କପର୍‍ନାହୁମ୍‍ ନାର୍‍ତୁ, ଏମେ ଇଣ୍ତ୍ରତେବାଜି ମାରାଆନ୍‍ ଆୟା ଇଣ୍ତ୍ରମାରିଡ଼େସି ୱାତାନ୍‌ । ଜିସୁ ଆୟା ଇଲ୍‌ତୁ ମାନାନ୍‌ ଇଜି ଲୋକାମାନୁ କାବୁର୍‌ ସର୍‌ଆତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ଆବେ ନିସା ଲୋକୁ ଉଣ୍ତାତାର୍‌ ଜେ, ସେର୍‍ଲା ଲାକ୍‍ତୁବା ଅଡ଼ପ୍‍ ବାଡି ସିଲେତାତ୍‍, ମାରି ଜିସୁ ୱାରିମାନୁ ବାକ୍ୟ ୱେର୍‌ତେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ଇୟାୱାଲେ ଲୋକୁ ଅରେନ୍‍ ପକିୟାଗାତି ରୋଗ୍‌ ଲୋକ୍‌ତିଙ୍ଗ୍‌ ନାଲ୍‍ଏରିଙ୍ଗ୍‍ ପିଣ୍ତିସ୍‍ କିବିସ୍‍ କିତାରୋ ଜିସୁ ଲାକ୍‌ତୁ ଆସ୍‌ତା ୱାତାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ମାତର୍‌ ନାଣ୍ତ ଲୋକୁ ମାର୍‍ଆର୍‍ଆକା ଜିସୁ ଲାକ୍‌ତୁ ତାତ୍‍ତେଙ୍ଗ୍‍ ଆଟ୍‍ଏତାର୍‍, ଆଦେଙ୍ଗ୍‌ ଜିସୁ ଏମେ ବାଡିଦୁ ମାର୍‌ଆନ୍‌, ଆୟା ବାଡ଼ିଦି ରେକାମ୍‌ କୁତ୍‍ତା ପକ୍‌ତାର୍‌, ମାରି ଆକା ରୁକ୍‍ତାରୋ, ଆମା କାଟେଲ୍‍ତୁ କିକୁକାଲ୍‌କୁ ୱାର୍‌ତି ରୋଗ୍‌ ଲୋକୁ ଡରିତା ମାର୍‌ଆନ୍‌, ଆୟା ମିସ୍‍ତେ ଜିସୁ ଆଗ୍‌ଡ଼ି ରେପ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ଆୟା ଲୋକାଦି ବିସ୍‌ବାସ୍‌ ସୁଡ଼୍‌ଜି ଜିସୁ କିକୁକାଲ୍‌କୁ ୱାର୍‌ତି ରୋଗିଦିଙ୍ଗ୍‍ ଇର୍‌ଆନ୍‌, “ଏ ମାରିନ୍‌, ନି ପାପ୍‌ୱିଜୁ କେମା ଆତାମାନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ମାତର୍‌ ସାସ୍ତ୍ରିର୍‍ ମାଣ୍‌କୁ ଏସଲୋକ୍‌ ଆୟା ବାଡିଦୁ ବାସ୍‍ତାରୋ ୱାରିୱାରି ମନ୍ ଲୋଇ ଇକା ଅଡ଼ବିଜି ମାର୍‌ଆର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“ଇକାନ୍‌ ଏନ୍ଦା ଇୟାୱାଜା ଇଜିନାନ୍‌ ? ୱାନ୍‌ ମାପୁରୁଙ୍ଗ୍‌ ନିଦା କିଜିନାନ୍‌ ! ମାପୁରୁଙ୍ଗ୍‌ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ମାରି ଏନ୍‌ ପାପ୍‌କେମା କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାନ୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ୱାର୍‌ ୱାରି ମୋନ୍‌ତୁ ଇୟାୱାଜା ୱାର୍‍ଗ୍‍ଜିସାଜିନାର୍‍, ଇଜି ଜିସୁ ଜିବନ୍‌ତୁ ଆୟାଦାପ୍ରେନେ ନେସ୍‌ତାନ୍‌ନୋ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ମିର୍‌ ନିଜେ ନିଜେଦି ମନ୍‌ତୁ ଏନ୍ଦା ଇୟାୱିଜୁ ମାଟା ୱାର୍‍ଗ୍‍ଜି ସାଜିନିଦେର୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ଇୟା କିକୁକାଲ୍‌କୁ ୱାର୍‌ତି ରୋଗିଦିଙ୍ଗ୍‍ “ନି ପାପ୍‌କେମା ଆତାତ୍‌, ଇଜି ଇନିକା ଉସାସ୍‌,” ନୋ “ନିଙ୍ଗିଁଆ, ଟାଟି ଆସ୍‌ସି, ସାଙ୍ଗ୍‍ଆ ଇଜି ଇନିକା ଉସାସ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ମାତର୍‌ ସାରାଦୁନିଆଦୁ ପାପ୍‌କେମା କିଦେଙ୍ଗ୍‌ ମନୁସ୍ୟପୁତ୍ରଦିଙ୍ଗ୍‌ ଜେ ଅଦିକାର୍‌ ମାନାତ୍‌, ଇକା ନାନ୍ କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ନା । ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ଜିସୁ ଆୟା କିକୁକାଲ୍‌କୁ ୱାର୍‌ତି ରୋଗ୍‌ ଲୋକ୍‌ଦିଙ୍ଗ୍‍ ଇର୍‌ଆନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“ନାନ୍ ନିଇଂ ଇଜିନା, ନିଙ୍ଗ୍‍ଆ, ନି ଟାଟି ଆସ୍‌ସି, ମି ଇଣ୍ତ୍ରସାଙ୍ଗ୍‍ଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ଆବେଟ୍‌ ୱାନ୍‌ ନିଂଇତାନ୍‍, ଆୟାଦାପ୍ରେ କାଟେଲ୍‍ ଆସ୍‌ସି, ୱିଜେରି ଆଗ୍‌ଡ଼ି ସତା ସର୍‌ଆନ୍‌; ଆବେନ୍‌ ୱିଜେରେ କାବାଆତାରୋ ମାପୁରୁଙ୍ଗୁଁ ଦନ୍ୟବାଦ୍‌ କିଜି କିଜି ଇର୍ହାର୍‌, “ମାପ୍‌ ଇୟାୱାଜା ପାଣି ଏସାଙ୍ଗ୍‍ବା ସୁଡ଼ୁଏପ୍‍ ମାର୍ହାପ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ଜିସୁ ମାରିଡ଼େସି ଗାଲିଲି ସାମ୍‌ଦୁର୍‌ ପାଡ଼ି ସର୍‌ଆନ୍‌, ମାରି ନାଣ୍ଡଲୋକ୍‍ ୱାନି ଲାକ୍‌ତୁ ୱାତାର୍‌ ଆକା, ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଶିକ୍ଷା ସିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ମାରି, ଜିସୁ ସଲ୍‍ପୁ ସଲ୍‍ପୁ ଆଲ୍‍ଫିତି ମାରିନ୍‌ ଲେବିଙ୍ଗ୍‍ ନିଜେଦି ସିସ୍‍ଟୁ ଲସ୍‌ନି ବାଡିଦୁ ବାସ୍‍ତି ମାର୍‌ଇକା ସୁଡ଼ୁତାନ୍‌ । ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନା ୱେନ୍‌କା ରାଆ ।” ଆବେଟ୍‌ ୱାନ୍‌ ନିଂଇତାନ୍‍ନୋ ଜିସୁ ୱେନ୍‌କା ସର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ଇୟା ୱେନ୍‌କା ଜିସୁ ଲେବି ଇଲ୍‌ତୁ ଉଣ୍ତେଙ୍ଗ୍‌ ବାସ୍‍ନିୱାଲେ ଏସୋ ସିସ୍‍ଟୁ ଲସ୍‌ନି ଲୋକୁ ମାରି ପାପି ଲୋକ୍‌ଡର୍‌ ଜିସୁ ମାରି ୱାନି ସିସୁରିୱାଲେ ଉଣ୍ତେଙ୍ଗ୍‌ ବାସ୍‌ତାର୍‌; ଇରିଙ୍ଗ୍‌ ୱାର୍‌ ନାଣ୍ତ ଲୋକୁ ମାର୍‌ଆର୍‌, ମାରି ୱାର୍‌ ଜିସୁୱାଲେ ବୁଲାଜିମାର୍‍ଆର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ଜିସୁ ପାପିଲୋକା ୱାଲେ ମାରି ସିସ୍‍ଟୁ ଲସ୍‌ନି ଲୋକାୱାଲେ ଉଣୁଜି ମାର୍‍ଆନ୍‍, ଇକା ସୁଡ଼ୁତାର୍‌ ପାରୁସି ଦଳତି ଶାସ୍ତ୍ରୀର୍‍ ୱାନି ସିସୁରିଙ୍ଗ୍‌ ଇଣ୍ତ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, “ଇକା ଇନିକା ? ୱାନ୍‌ ସିସ୍‍ଟୁ ଲସ୍‌ନି ଲୋକାୱାଲେ ମାରି ପାପିଲୋକା ୱାଲେ ଅର୍‌ସେ ଉଣାନ୍‌ !” ");
INSERT INTO kfcp_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ଆୟା ମାଟା ୱେନ୍‌ଜି ଜିସୁ ଇର୍‌ଆନ୍‌, “ନେଗି ଲୋକାଦି ଉଣ୍ତିଙ୍ଗ୍‌ ଡାକ୍‌ତର୍‌ତି ଦର୍‌କାର୍‌ ସିଲେତ୍‌, ମାତର୍‌ ନବ୍ ଲୋକା ଉଣ୍ତିଙ୍ଗ୍‌ ଡାକ୍‌ତର୍‌ତି ଦର୍‌କାର୍‌ ମାନାତ୍‌; ନାନ୍ ଦାର୍ମୁ ଲୋକାଙ୍ଗ୍‌ କୁକ୍‍ତେଙ୍ଗ୍‍ ରେଏ, ମାତର୍‌ ପାପି ଲୋକାଙ୍ଗ୍‌ କୁକ୍‍ତେଙ୍ଗ୍‍ ଇଜି ୱାତାମାନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ଡୁବନ୍‌ ସିନି ଯୋହନତି ସିସୁର୍‍ ମାରି ପାରୁସିର୍‌ ଉପାସ୍‌ କିଜିମାର୍‍ଆର୍‍ । ଆବେଟ୍‌ ଏସ ଲୋକୁ ୱାତାରୋ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାର୍‌, “ଡୁବନ୍‌ ସିନି ଯୋହନତି ସିସୁର୍‍ ମାରି ପାରୁସିର୍‌ ସିସୁର୍‍ ଉପାସ୍‌ କିନାର୍‌, ମାତର୍‌ ମି ସିସୁର୍‍ ଉପାସ୍‌ ଏନ୍ଦା କିଏର୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “କାନ୍ୟାମୁରୁଲିରି ୱାଲେ ମୁରୁଲୀ ମାନିୱାଲେ ୱାର୍‌ ଉପାସ୍‌ କିନାର୍‌ ନୋ ? ମୁରୁଲି ଆମାସାନ୍ଦି ୱାରିୱାଲେ ମାନାନ୍‌, ଆୟା ସାନ୍ଦି ୱାର୍‌ ଉପାସ୍‌ କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ମାତର୍‌ ଦିନ୍‌ ୱାନାତ୍‌, ଏସ୍ତିୱାଲେ ୱାରିମାଣାନ୍‌ ମୁରୁଲିଙ୍ଗ୍‍ ଅନାର୍‍, ମାରି ଆୟାୱାଲେ ଆୟାନାଣ୍ତିଙ୍ଗ୍‌ ୱାର୍‌ ଉପାସ୍‌ କିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“ଏନ୍‌ ପୁନି ୱାତିଦି ଇସ୍ରି ଅଟିଦିଙ୍ଗ୍‍ ଅସି ପାଡ଼ିଇ ୱାତିଦୁ ଗୁତ୍‍ଏନ୍‍; ଇରିଙ୍ଗ୍‌ ଗୁତ୍‍ତିଙ୍ଗ୍‍ ଆୟା ପୁନି ୱାତିଦି ଅଟି ପାଡ଼ିଇ ୱାତିଦିଙ୍ଗ୍‌ ନାଣ୍ତ କିଜିସ୍‌କିନାତ୍‌ ମାରି ନାଣ୍ତ ପେରିକା କିଜ୍‍ନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ମାରି, ଏନ୍‌ ପୁନି ଅଙ୍ଗୁର୍‍ ରସ୍‌ତିଙ୍ଗ୍‌ ପାଡ଼ିଇ ତଲ୍‍ ମଣିଦୁ ଇଡ୍‌ଏନ୍‌; ଜଦି ଇଟ୍‌ତିଙ୍ଗ୍‌ ଆକା ତଲ୍‍ ମଣିଦିଙ୍ଗ୍‍ ପାଡିସ୍‌ କିନାତ୍‍, ଆବେଟ୍‌ ଅଙ୍ଗୁର୍‍ରସ୍‍ ନି ତଲ୍‍ମଣି ରୁଣ୍ତିବା ସେଏଣ୍ତ୍‍ ଆନେ । ମାତର୍‌ ପୁନି ଅଙ୍ଗୁର୍‍ ରସ୍‌ତିଙ୍ଗ୍‌ ପୁନି ତଲ୍‍ ମଣିଦୁ ଇଡ୍‌ନିକା ମାନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ଅର୍‍ଲେନ୍‍ ରମ୍‍ନିଦିନ୍‍ତୁ ଜିସୁ ପାସି କିଡ଼ିଇ ନାଡ଼୍‍ମି ସିଜି ସଲ୍‌ସି ମାର୍‌ଆନ୍‌, ମାରି ୱାନି ସିସୁର୍‍ ୱାନିୱାଲେ ସଲ୍‍ପୁ ସଲ୍‍ପୁ ପାସି ସେରେନ୍‍କୁ ତେଉତେଙ୍ଗ୍‍ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ଆବେଟ୍‌ ପାରୁସିର୍‌ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାର୍‌, “ସୁଡୁଆ, ରମ୍‌ନିଦିନ୍‍ତୁ ଆମାକାକି କିଦେଙ୍ଗ୍‌ ନିୟମ୍‌ ସିଲେତ୍‌, ମି ସିସୁର୍‌ ଇନିଦାନିଙ୍ଗ୍‌ ଆକା କିଜିନାର୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ଏସ୍ତିୱାଲେ ଦାଉଦଦିଙ୍ଗ୍‍ ଖାଦି ସିଲେତାତ୍‍ ଆୟାୱାଲେ ୱାନ୍‌ ମାରି ୱାନି ତଡ଼୍‍ତି ଲୋକୁ ବାଙ୍ଗାଁ ଆତାର୍‌, ନାସ୍‍ତିୱାଲେ ୱାନ୍‌ ଇନିକା କିତାମାର୍‌ଆନ୍‌, ମିର୍‌ ଆକା ଏସାଙ୍ଗ୍‍ ବା ପଡ଼ାଇଦେର୍‍ ନୋ ? ");
INSERT INTO kfcp_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ଅବିୟାଥର ୱିଜେରିଙ୍ଗ୍‍ ପେରି ଜାଜକରି ଦିନ୍‍ତୁ ଦାଉଦ ଏଣ୍ତେସ୍‍ କିଜି ମାପୁରୁତି ଇଲ୍‌ତୁ ଡ଼ୁଗିତାନ୍‍ନୋ, ଆମା ପୁଜାସିତି ରୁଟି ଯାଜକରିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ଏନ୍‍ବା ତିଣ୍ତ୍ରେଙ୍ଗ୍‍ ନିୟମ୍‌ ସିଲେତ୍‌, ଆକା ତିରାଆ ମାର୍‌ଆନ୍‌, ମାରି ୱାନି ତଡ଼୍‍ ଲୋକାଙ୍ଗ୍‌ ବା ସିତା ମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ଜିସୁ ପାରୁସିରିଙ୍ଗ୍‍ ଇର୍‌ଆନ୍‌, ରମ୍‍ନିଦିନ୍‍ ଲୋକା ସାହାଜ୍ୟ ଉଣ୍ତିଙ୍ଗ୍‌ ତିଆର୍‌ ଆତାମାନାତ୍‌, ମାତର୍‌ ଲୋକ୍‌ତିଙ୍ଗ୍‌ ବଜୁ ଉଣ୍ତିଙ୍ଗ୍‌ ରମ୍‍ନିଦିନ୍‍ ଆଏତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ଆଦେଙ୍ଗ୍‌ ମନୁସ୍ୟପୁତ୍ର ଜେ ନାନ୍, ରମ୍‌ନିଦିନ୍‍ତି ପ୍ରବୁ ଆନା । ");
INSERT INTO kfcp_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ଜିସୁ ମାରିଡ଼େସି ପାର୍‌ତନା କିନି ଇଲୁଦୁ ସର୍‌ଆନ୍‌ । ଆବେ ଅରେନ୍‍ ଲୋକୁ ମାର୍‌ଆନ୍‌, ୱାନି ଉଣି କିୟୁ ୱାର୍‌ତା ମାର୍‌ଆତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ମାରି, ଜିସୁ ରମ୍‌ନି ଦିନ୍‍ତୁ ଆୟା ଲୋକ୍‌ତିଙ୍ଗ୍‌ ନେଗେଣ୍ତ୍‌ କିନାନ୍‍ନୋ ସିଲେ, ଇକା ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ଇଜି ୱାର୍‌ ୱାନି ମୁସ୍‌କୁ କାଣୁକୁ ସୁଡ଼ୁଜିମାର୍‌ଆର୍‌, ଏଣ୍ତେସ୍‌କି ୱାର୍‌ ୱାନି ବିରୁଦ୍‍ତାନ୍‍ ଦୋସ୍‌ କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ଆମା ୱାନିଦି କିୟୁ ୱାର୍‌ତା ସୋର୍‌ଆ ମାର୍‌ଆତ୍‌, ୱାନିଙ୍ଗ୍‌ ଜିସୁ ଇର୍‌ଆନ୍‌, “ରାଆ, ନାଣ୍‍ମି ନିଲ୍‍ଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ମାରି, ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ରମ୍‌ନି ନାଣ୍ଡିଙ୍ଗ୍ ଇନି ପାଣି କିନିକା ନିୟମ୍‌ ମାନାତ୍‌ ? ନେଗେଣ୍ତ୍‍ କିଦେଙ୍ଗ୍‌ ନୋ ସେଏଣ୍ତ୍‍ କିଦେଙ୍ଗ୍‌ ? ଅରେନ୍‍ ଲୋକ୍‌ତି ଜିବନ୍‌ ରକିୟା କିନିକା ନୋ ସାପିସ୍‌ନିକା ?” ମାତର୍‌ ଲୋକ୍‌ଡର୍‌ ଆଲେତା ସରଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ଆବେଟ୍‌ ଜିସୁ ଲୋକା ଜିବନ୍‌ ଆଟ୍‍ୱାଆକା ଦୁଃକ୍‌ ଆଜି ରିସାଦାନ୍‌ ସାରିବେଡ଼୍‍ତି ୱାରିଙ୍ଗ୍‌ ସୁଡ଼ୁଜି କିୟୁ ୱାର୍‌ତି ମାର୍‍ଇ ଲୋକ୍‌ତିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନି କିୟୁ ପେର୍‌ଆ ।” ୱାନ୍‌ ୱାନି କିୟୁ ପେର୍‍ତାନ୍‍, ମାରି ୱାନି କିୟୁ ନେଗେଣ୍ତ୍‍ ଆତାସର୍‍ଆତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ଇକା ସୁଡ଼ୁତାର୍‌ ନୋ ପାରୁସିର୍‌ ପାର୍‌ତନା ଇଲ୍‌ତାନ୍‌ ସହସି ସରଆର୍‌ ନୋ ଜିସୁଙ୍ଗୁଁ ସାୟା ମାର୍‍ଗା ଡାକ୍‌ତେଙ୍ଗ୍‍ଁ ଇଜି ୱାନି ବିରୁଦ୍‌ତାନ୍‌ ଆୟାଦାପ୍ରେ ହେରୋଦ ରାଜା ଦଲ୍‌ତି ନେତାରିୱାଲେ ୱାର୍‌ଗିଜି ସାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ଜିସୁ ୱାନି ସିସୁରିୱାଲେ ମିସାତାନ୍‌ ନୋ ଗାଲିଲି ସାମ୍‌ଦୁର୍‌ ପାଡ଼ି ସର୍‌ଆନ୍‌ । ମାରି ଗାଲିଲି ଗାଡ଼୍‌ତାନ୍‍ ନାଣ୍ତ ଲୋକୁ ସତା ରୋ ୱାନି ୱାଲେ ବୁଲାତାର୍‌; ମାରି ଜିହୁଦା, ");
INSERT INTO kfcp_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ଜିରୁସାଲାମ୍‍, ଇଦୋମ୍, ଜର୍ଦନ ଗାଡ଼୍‌ତି ଆୟା ପାଡ୍‍କା ମାନିକାର୍‌, ମାରି ସୋର ନି ସିଦନ୍‍ତି ସାରିବେଡ଼୍‍ତିଦାନ୍‍ ଲୋକୁ ୱିଜେରେ ୱାନି ପାଣିଦିମାଟା ୱେର୍‌ଆର୍‌ରୋ ୱାନି ଲାକ୍‌ତୁ ୱାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ଆବେ ନାଣ୍ତ ଲୋକ୍‌ ଉଣ୍ତାତାର୍‍ଆକା, ଲୋକୁ ୱିଜେରେ ୱାନି ଲାକ୍‌ତୁ ୱାଜ ମାଟ୍‍ସି ସାଏର୍‌, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାନ୍‌ ୱାନି ସିସୁରିଙ୍ଗ୍‌ ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ଉଣ୍ତ୍ରି ଇସ୍ରି ଡଙ୍ଗାଁ ଲାକ୍‌ତୁ ଇଡ୍‌ଦେଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ଇରିଙ୍ଗ୍‌ ଜିସୁ ଏସ ରୋଗ୍‍ତୁ ମାର୍‍ଇ ଲୋକାଙ୍ଗ୍‌ ନେଗେଣ୍ତ୍‌ କିତାନ୍‍ଆକା, ମାରି ରୋଗ୍‍ତୁ ମାନି ୱିଜେରେ ୱାନିଙ୍ଗ୍‌ ମୁଟ୍‌ତେଙ୍ଗ୍‌ ଇଜି ୱାନି ମୁସ୍‌କୁ ମାଟ୍‍ସି ସାଜି ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ମାରି, ତାଗ୍‍ଇଆତ୍ମା ଆସ୍‌ତିମାର୍‌ଇ ଲୋକୁ ଜିସୁଙ୍ଗୁଁ ସୁଡ଼ୁଜିମାର୍‍ଆର୍‍, ୱାର୍‌ ଜିସୁ ଆଗ୍‌ଡ଼ି ଆର୍‍ଜି ଆଉଲି ଆଜି ଇନ୍‍ଜିମାର୍‍ଆର୍‍, “ନିନୁନେ ମାପୁରୁଦି ମାରିସି ।” ");
INSERT INTO kfcp_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ଆବେଟ୍‌ ୱାନ୍‌ ଏନ୍‌ ଆକା ଏଙ୍ଗ୍‌ବା ଇନ୍‌ଇ ଉଣ୍ତିଙ୍ଗ୍‌ ୱାନ୍‌ ତାଗ୍‌ଇ ଆତ୍ମେଆଙ୍ଗ୍‌ ଆଟ୍‍ୱାଦାନ୍‍ ଆଦେସ୍‌ ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ଆୟାୱେନ୍‌କା ଜିସୁ ଗରନ୍‌ ମୁସ୍‌କୁ ସର୍‍ଆନ୍‍ନୋ, ୱାଣ୍ତ୍ରୁ ଏମେ ଲୋକ୍‌ତିଙ୍ଗ୍‌ ବଦା କିତାନ୍‌ ଆୟା ଲୋକ୍‌ତିଙ୍ଗ୍‌ ୱାନି ଲାକ୍‌ତୁ କୁକ୍‍ତାନ୍‍ ମାରି ୱାର୍‌ ୱାନିବାନୁ ୱାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ଜିସୁ ବାର ଲୋକ୍‍ ସିସୁରିଙ୍ଗ୍‌ ବାସ୍‌କିତାନ୍‌, ଏଣ୍ତେସ୍‌ ୱାରୁ ୱାନିୱାଲେ ତେବାନାର୍‌, ମାରି “ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ନେଗିକାବୁରୁ ପ୍ରଚାର୍‌ କିଦେଙ୍ଗ୍‌ ପୋକ୍‌ତାନ୍‌,” ");
INSERT INTO kfcp_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ମାରି ୱାର୍‌ ଦୁବେଆଙ୍ଗ୍‍ ପେର୍‍ଦେଙ୍ଗ୍‍ ଅଦିକାର୍‍ ପ‍ଇତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ଜିସୁ ଇୟା ବାର ଲୋକାଙ୍ଗ୍‌ ବାସ୍‌କିତାନ୍‌ ସିମୋନ୍‌, ଜିସୁ ଆମାୱାନିଙ୍ଗ୍‌ କି ମାରି ଉଣ୍ତ୍ରି ଦର୍‌ ପିତର୍‌ ଇଜି ସିତାନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ଜେବଦୀଦି ରିଏର୍‌ ମାରିସିର୍‌ ଯାକୁବ ମାରି ୱାନି ତଡ଼ାନ୍‍ ଯୋହନ, ଆମାୱାରିଙ୍ଗ୍‍ ୱାନ୍‌ ବିନେରିଗୋସ୍, ବା ମିର୍‍ସି ଆଉଲି ଆନି ବାଦଡ଼୍‍ତି ମାରିସିର୍‌ ଇଜି ଦର୍‌ ସିତାନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ଆନ୍ଦ୍ରିୟ, ପିଲିପ୍‌, ବାର୍ତଲମି, ମାତିଉ, ଥୋମା, ଆଲପିଦି ମାରିସି ଯାକୁବ, ଥଦ୍ଦୀୟ, କିଣାନିୟ ସିମୋନ, ଏନ୍‌ ଇସ୍ରାଏଲ୍‍ତିଙ୍ଗ୍‍ ଡ଼ିସିସ୍‍ କିଦେଙ୍ଗ୍‌ ବଦାକିଜି ମାର୍‍ଇ ଯିହୁଦି ଲୋକାମାଣ୍‌କୁ ଅରେନ୍‍ ମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ମାରି ଇସ୍କାରିୟୋତିୟ ଜିହୁଦା, ଆମାକାନ୍‍ କି ୱେନ୍‌କା ଜିସୁଙ୍ଗୁଁ ସାତ୍ରୁରି କିୟୁଦୁ ଆସ୍‍ପିସ୍‍ କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ଇୟା ୱେନ୍‌କା ଜିସୁ ଏସିୱାଲେ ଇନ୍‍ଡ୍ର ଡ଼େସି ୱାତାନ୍‌, ଆବେ ନିସା ଲୋକୁ ଉଣ୍ତାତା ମାର୍‌ଆର୍‌ ଯେ, ଜିସୁ ମାରି ୱାନି ସିସୁର୍‌ ଖାଦି ଉଣ୍ତେଙ୍ଗ୍‌ ବା ଆଟ୍‍ଏତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ଏସ୍ତିୱାଲେ ଜିସୁରି ଇନ୍‍ଡ୍ରଣି ଲୋକୁ ଇକା ୱେର୍‌ଆର୍‌ ଆୟାୱାଲେ ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ଡ଼େସି କୁକ୍‍ସ ଅତେଙ୍ଗ୍‌ ସରଆର୍‌, ଇରିଙ୍ଗ୍‌ “ୱାନି ତାଲା ପାଣି ସିଏଜିନାତ୍‍ ଇଜି ଲୋକୁ ୱାର୍‍ଜିସାନିକା ୱେର୍‌ଆର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ମାରି, ଜିରୁସାଲାମ୍‍ତାନ୍‌ ୱାତି ଏସୋ ସାସ୍ତ୍ରିର୍‌ ଇର୍ହାର୍‌, “ୱେନିଙ୍ଗ୍‌ ଦୁବେଆଣି ପେରିକାତ୍‍ ବାଲ୍‍ଜିବୁଲ୍‍ ବୁଡ଼୍‍ତା ମାନାତ୍‌, ତାନେ ସାକ୍ତିଦାନ୍‌ ଦୁବେଙ୍ଗ୍‍ ଡ଼ିସିସ୍‍ନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଲାକ୍‌ତୁ କୁକ୍‍ତାନ୍‍ ମାରି ଉଣ୍ତ୍ରି କାତା ୱେର୍‌ସି ବୁଜା କିତାନ୍‌, “ସୟତାନ୍‍ ଏଣ୍ତେସ୍‌ ଶୟତାନ୍‍ତିଙ୍ଗ୍‍ ପେର୍‍ଦେଙ୍ଗ୍‍ ଆଟ୍‍ନାତ୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ନିଜେଦି ଦେସ୍‌ ଜଦି ନିଜେ ନିଜେରି ଦଳ ଲୋଇ ଜୁଦ୍‍ କିନାର୍‌, ଆୟା ରାଜି ତିର୍‌ ତେବାଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ମାରି, ଉଣ୍ତ୍ରିଇଲ୍‍ତି ଲୋକୁ ଜଦି ବାଗ୍‌ ବାଗ୍‌ ଆଜି ନିଜେ ନିଜେରି ଲୋଇରି ବିରୁଦ୍‍ତାନ୍‍ ନିଂଇତିଙ୍ଗ୍‍, ଆୟା ଇଲୁ ତିର୍‌ ତେବାଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ଆୟାୱାଜା, ଜଦି ଶୟତାନ୍‍ତି ରାଜି ବାଗ୍‌ ବାଗ୍‌ ଆଜି ନିଜେଦି ବିରୁଦ୍‍ତାନ୍‍ ନିଂଇତାତ୍‍ନି, ଆୟାକା ତିର୍‌ ତେବାଏତ୍‍, ମାତର୍‌ ତାନି ସାନିକା ୱାତାତ୍‌ନି । ");
INSERT INTO kfcp_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“ମାତର୍‌ ଅରେନ୍‍ ବପୁମାନି ଲୋକ୍‌ତି ଇନ୍‍ଡ୍ର ଏନ୍‍ବା ଡ଼ୁଗୁଜି ଆଗ୍‌ଡ଼ି ୱାନିଙ୍ଗ୍‌ ତର୍‍ଏତିଙ୍ଗ୍‍, ୱାନି ସାମାନ୍‌ପତ୍ର ଡଂଆ କିଜ ଅତେଙ୍ଗ୍‌ ଆଟ୍‍ଏନ୍‍; ୱାନିଙ୍ଗ୍‌ ଆଗ୍‌ଡ଼ି ତର୍‍ତିଙ୍ଗ୍‍ ଗାଦେ ୱାନ୍‌ ୱାନି ଇଲୁ ଲୋଇ ଡଂଆ କିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ଲୋକ୍‌ତି ୱିଜୁ ପାପ୍‍ ମାରି ୱାର୍‌ ଏସା ନିନ୍ଦାମାଟା ଇନ୍‌ଜି ମାପୁରୁଙ୍ଗୁଁ ନିନ୍ଦା କିନାର୍‌, ଆୟାୱିଜୁ କେମା ଆନାତ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ମାତର୍‌ ଏନ୍‌ ପବିତ୍ରଆତ୍ମାଦି ବିରଦ୍‌ତାନ୍‌ ନିନ୍ଦା ମାଟା ଇନାନ୍‌, ୱାନିଙ୍ଗ୍‌ ମାପୁରୁ ଏସାଙ୍ଗ୍‍ ବା କେମା କିଏନ୍‍, ଆୟା ଲୋକୁ ୱିଜୁଦିନ୍‌ତି ଉଣ୍ତିଙ୍ଗ୍‌ ଶାସ୍ତି ପଇନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“ଜିସୁଙ୍ଗୁଁ ତାଗ୍‍ଇଆତ୍ମା ଆସ୍ତା ମାନାତ୍‌” ଇଜି ଏସୋ ସାସ୍ତ୍ରିର୍‍ ଇର୍ହାର୍‌ ଆକା, ଜିସୁ ଇୟା ମାଟା ଇନ୍‌ଜି ୱାରିଙ୍ଗ୍‌ ବୁଝା କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ନାସ୍ତିୱାଲେ ଜିସୁଦି ୟାୟା ନି ତଡ଼ାନ୍‍କୁ ୱାତାରୋ ଆତ୍‌ରେ ନିର୍ହା ରୋ ଜିସୁଙ୍ଗୁଁ କୁକ୍‍ତେଙ୍ଗ୍‍ କାବୁର୍‌ ପୋକ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ଆବେଟ୍‌ ୱାନି ସାରିବେଡ଼୍‍ତି ବାସ୍‍ତି ମାର୍‍ଇ ଲୋକୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ସୁଡ଼ୁଆ, ମି ୟାୟା ନି ତଡ଼ାନ୍‌କୁ ମାରି ତାଙ୍ଗିଁକ୍‍ ଆତ୍‌ରେ ତେବାତେ ନୋ ନିଙ୍ଗିଁ ପଇଜିନେ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ମାତର୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନା ୟାୟା ନି ତଡ଼ାନ୍‍କୁ ଏର୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ଜିସୁ ୱାନି ସାରିବେଡ଼୍‍ତି ବାସ୍‍ତି ମାର୍‍ଇ ଲୋକାଙ୍ଗ୍‌ ସୁଡ଼ୁଜି ଇର୍‌ଆନ୍‌, “ସୁଡ଼ୁଦୁ, ଇକାର୍‌ ଆଜିନାର୍‌ ନା ୟାୟା ନି ନା ତଡ଼ାନ‍କୁ । ");
INSERT INTO kfcp_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ଏନ୍‌ଆପିନ୍‌ ମାପୁରୁଦି ମାଟା ମାନାନାନ୍‍, ୱାନ୍‌ ନା ତଡ଼ାନ୍‍, ତାଙ୍ଗିଁ ମାରି ୟାୟା ।” ");
INSERT INTO kfcp_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ଜିସୁ ଗାଲିଲି ସାମ୍‌ଦୁର୍‌ ପାଡ଼ି ମାରିଡ଼େସି ଶିକ୍ଷା ସିଦେଙ୍ଗ୍‍ ଆରାମ୍‍ କିତାନ୍, ୱାନି ଲାକ୍‌ତୁ ନାଣ୍ତ ଲୋକୁ ଉଣ୍ତାତାର୍‍ ଆକା, ୱାନ୍‌ ସାମ୍‌ଦୁର୍‌ତୁ ମାର୍‍ଇ ଉନ୍‌ଡ୍ରି ଡଙ୍ଗାଁଦୁ ସଲ୍‌ସି ବାସ୍‌ତାନ୍‌ ମାରି ଲୋକୁ ୱିଜେରେ ସାମ୍‌ଦୁର୍‌ ପାଡ଼ି ତେବାତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ଜିସୁ କାତାଦାଣ୍ତ୍‍ ଏସୋ ସିକିୟା ସିନିୱାଲେନେ ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“ୱେଣ୍ତ୍ରୁ, ଅରେନ୍‍ ୱିତୁ ୱିତ୍‍ନିକାନ୍‍ ୱିତ୍‌ତେଙ୍ଗ୍‌ ସତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ୱାନ୍‌ କିଡ଼ିଇଦୁ ୱିତୁ ୱିତ୍‍ନିୱାଲେ ଏସ ୱିତୁ ସାରି ପାଡ଼୍‌କାଦୁ ଆର୍‌ତେ ଆକା ପଟିଙ୍ଗ୍‌ ୱାଜି ଆୟାୱିଜୁ ୱିତୁ ତିର୍‍ଏ । ");
INSERT INTO kfcp_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ମାରି ଏସ ୱିତୁ ଉଣା ସିକାଲାମାନି ପିଡ଼ିପି ବୁମିଦୁ ଆର୍‌ତାତ୍‌ । ମାରି ନାଣ୍ତ ସିକାଲା ସିଲେତାତ୍‌ ଆକା ୱିତୁ ଦାପ୍ରେ ନେରିତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ମାତର୍‌ ୱେଡ଼ା ସତାତ୍‌ ଆକା ଗାଜା ୱେତା ସର୍‌ଆତ୍‌ ମାରି ୱେଲା ଲୋଇ ସାର୍‍ଏତା ମାର୍‌ଆତ୍‌ ଆକା ୱାର୍‍ତା ସର୍‍ଆତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ମାରି ଏସୋ ୱିତୁ ସାମ୍‌କା ଦୁପା ଲୋଇ ଆର୍‌ତାତ୍‌, ମାରି ସାମ୍‍ମାରାକ୍‍ ପିରିତେନୋ ତାମେ ମୁସ୍‌କୁ ତିଗାତେ ମାରି ଆୟା ମାରାତୁ ଉଣ୍ତ୍ରିବା ପାଡ଼ୁ ଆସ୍‍ଏତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ମାତର୍‌ ଏସୋ ୱିତୁ ନେଗି ବୁମିଦୁ ଆର୍‌ତାତ୍‌, ଆୟା ବାଡିଦୁ ଗାଜା ଆଜି ପିରିତାଦୋ ତିରିସ୍‌ ଗୁଣୁ, ସାଟେ ଗୁଣୁ ମାରି ସୟେ ଗୁଣୁ ସାନ୍ଦି ପାଡ଼ୁ ଆସ୍‌ତାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ଆବେ ଜିସୁ ଇର୍‌ଆନ୍‌, “ଆମାୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଗିତଣିଙ୍ଗ୍‍ମାନେ, ୱାନ୍‌ ୱେନିନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ଜିସୁ ଅରେନ୍‍ନେ ମାନିୱାଲେ ବାର ଲୋକୁ ଶିଶୁର୍‌ ମାରି ୱାରିୱାଲେ ମାନିଲୋକ ଜିସୁମାନୁ ୱାଜି ୱେନ୍‌ବାତାର୍‌ “ନିନୁ ଏନ୍ଧା କାତାଦାନ୍‍ ମାଟା ୱେର୍‌ସିନି ?” ");
INSERT INTO kfcp_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ଆବେଟ୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ମାପୁରୁଦି ରାଜିଦି ମାର୍‍ଗିତି ମାଟା ବୁଜାଦେଙ୍ଗ୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ମିଙ୍ଗିଁ ବପୁ ପୁଟ୍‍ତାମାନାତ୍‍, ମାତର୍‌ ଆୟା ଆତ୍ରେଣି ଲୋକାଙ୍ଗ୍‌ ଇୟାୱିଜୁ ବିସୟ କାତାଦାନ୍‍ ୱେର୍‌ତେଙ୍ଗ୍‌ ଆଜିନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ଆୟା ଉଣ୍ତିଙ୍ଗ୍‌ ୱାର୍‌ ୱେନ୍‌ଜି ୱେନ୍‌ଜି ନେସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‍ଏର୍‍, ମାରି ୱେନ୍‌ବୁ ୱେନ୍‌ବୁ ବୁଜାଏର୍‍, ଜଦି ନେସ୍‌ନାର୍‌ ମାରି ବୁଜାନାର୍ ମାରି ମାପୁରୁତି ଲାକ୍‌ତୁ ଡ଼େସିୱାନାର୍‍ ମାରି ୱାରିଙ୍ଗ୍‌ କେମା କିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ଜିସୁ ମାରି ସିସୁରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଇୟା କାତା ମିର୍‍ବା ବୁଝାଦେଙ୍ଗ୍‍ ଆଟ୍‍ଇଜିନିଦେର୍‍ ? ଆଇ ୱିଜୁ କାତା ଏଣ୍ତେସ୍‌ ବୁଝାନିଦେର୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ୱିତ୍‍ନିକାନ୍‍ ୱିତୁ ଅର୍ତାତ୍‍ ମାପୁରୁତି ବାକ୍ୟ ୱିତ୍‍ନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ଆମାକାର୍‌ ମାପୁରୁଦି ବାକ୍ୟ ୱେନାର୍‌, ମାତର୍‌ ୱେର୍‍ହି ଦାପ୍ରେନେ ଶୟତାନ୍‍ ୱାନାତ୍‌ ନୋ ୱାରିମାନୁ ୱିତାତିମାନି ବାକ୍ୟଦିଙ୍ଗ୍ ଡଂଆ କିନା ଅନାତ୍‍, ୱାରୁ ସାର୍‍ଦୁ ବାକ୍ୟ ୱିତାତି ବୁମିଦି ୱାଜା । ");
INSERT INTO kfcp_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ଆୟାୱାଜା, ଏର୍‌କି ବାକ୍ୟ ୱେର୍‍ଇଦାପ୍ରେ ୱେଡ଼ିକାଦାନ୍‌ ଆକା ୱାରି ମନ୍ ଲୋଇ ଇଡ୍‍ନାର୍‍, ");
INSERT INTO kfcp_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ମାତର୍‌ ୱାରିମାନୁ ୱେଲା ସାଗ୍‍ଏତ୍‍ଆକା ସାଣେକ୍‍ନେ ତିର୍‍ ତେବାନାର୍‌, ୱେନ୍‌କା ବାକ୍ୟ ଉଣ୍ତିଙ୍ଗ୍‌ ଦୁଃକ୍‌‍ ମାରି ନିଦା ମାଟା ୱାତିଙ୍ଗ୍‍ ଆୟାଦାପ୍ରେ ବିସ୍‍ବାସ୍‍ ଡ଼ିସ୍‍ନାର୍‍, ୱାରୁ ପିଡ଼ିପି ବୁମିଦୁ ଆର୍‍ତିମାନି ୱିତ୍‍ତି ୱିତୁଦି ୱାଜା । ");
INSERT INTO kfcp_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ମାରି ଆମାକାର୍‍କି ବାକ୍ୟ ୱେନ୍‍ନାର୍‍, ମାତର୍‌ ଦୁନିଆଦି ସିନ୍ତା, ଡାବୁଙ୍ଗୁଁ ଟାକେଙ୍ଗ୍‍ଣି ମାୟା ମାରି ଆଇ ୱିଜୁ ବିସୟତୁ ଆସା ମନ୍‌ତୁ ଡ଼ୁଗ୍‍ନାଦ ବାକ୍ୟଦିଙ୍ଗ୍‍ ତିଗାନାତ୍‍ ମାରି ଆକା ପାଡ଼ୁ ସିଲିକା ଆନାତ୍‌ । ୱାର୍‍ ସାମ୍‌ ମାରାକା ଲୋଇ ଆର୍‌ତି ୱିଜୁ ୱାଜା । ");
INSERT INTO kfcp_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ମାତର୍‍ ଦୁନିଆଦି ସିନ୍ତା, ଦନ୍‍ଲବ୍‍ ମାରି ଆଇ ଆସା ୱାରି ମନ୍‌ତିଙ୍ଗ୍‍ ତିର୍‌ଜିମାନିଙ୍ଗ୍‌ ଆୟା ମାଟା ୱାରିମାନୁ ପିର୍‌ଏତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ମାରି, ଆମାକାର୍‌ କି ବାକ୍ୟ ୱେନାରୋ ଆକା ମନ୍ ଲୋଇ ଇଡ୍‍ନାର୍‍, ୱାର୍‌ ଏନ୍‌ ତିରିସ୍‌ ଗୁଣୁ, ସାଟେ ଗୁଣୁ ମାରି ସହେ ଗୁଣୁ ପାଡ଼ୁ ଆସ୍‌ନାର୍‌ ଆୟା ଲୋକୁ ନେଗି ବୁମିଦୁ ୱିତ୍‍ତି ୱିତୁତି ୱାଜା ।” ");
INSERT INTO kfcp_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ଜିସୁ, ମାରିଡ଼େସି ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଏନ୍‌ ଏସ୍‌କାଙ୍ଗ୍‌ ଇନିକା ଦିୱା କାସିସ୍‍କିଜି ଅଡି ଆଡ୍‍ଗି କି ଖାଟେଲ୍‍ ଆଡ୍‍ଗି ଇଡ୍‌ନାନ୍‌ ? ଆକା ଲୋକୁ ଦିୱା କାସିସ୍‍କିଜି ଦିଆ ଇଡ୍‌ନି ବାଡିଦୁ ଇଡ୍‌ଏର୍‌ ନୋ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ଇରିଙ୍ଗ୍‌ ତର୍‍ଇ ଇସାବ୍‌ତାନ୍‌ ଏମେକାବା ମାର୍‍ଗ୍‍ଏତ୍‍; ଆମାକା ମାର୍‍ଗିତା ମାନାତ୍‌, ଆକା ତର୍‍ଦେଙ୍ଗ୍‍ ଇଜିନେ ମାର୍‍ଗିତା ମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ଜଦି “ଆମାୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଗିତଣିଙ୍ଗ୍‍ମାନେ, ୱାନ୍‌ ୱେନିନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଇନିକା ୱେନ୍‌ଜିନିଦେର୍‌, ଆୟା ଉଣ୍ତିଙ୍ଗ୍‌ ଜାଗାର୍‌ତା । ମିର୍‌ ଏଣ୍ତେସ୍‌ କିଜି ଆଇ ଲୋକ୍‌ତିଙ୍ଗ୍‌ ଲେକିସ୍‌ କିଜି ସିନିଦେର୍‍, ଆୟାୱାଜା ପ୍ରବୁ ମିଙ୍ଗିଁ ନାଣ୍ତ ଲେକିସ୍‌ କିଜି ସିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ଏମେ ଲୋକ୍‍ତିନ୍ଧି ମାନାତ୍‌, ୱାନିଙ୍ଗ୍‌ ପୁଟ୍‍ନାତ୍‍; ମାରି ଆମାୱାନିନ୍ଧି ସିଲେତ୍‌, ୱାନିବାନୁ ଆମାକା ମାନାତ୍‌, ଆକାବା ମାପୁରୁ ୱାନିମାଣ୍‌କୁ ଅନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ଜିସୁ ମାରିଡ଼େସି ଇର୍‌ଆନ୍‌, “ମାପୁରୁତି ରାଜି ଇୟାୱାଜା । ଅରେନ୍‍ ଲୋକୁ ନିଜେଦି ବୁମିଦୁ ୱିତୁ ୱିତ୍‍ନାନ୍‍; ");
INSERT INTO kfcp_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ୱାଣ୍ତ୍‍ରୁ ନାଡ଼ା ସୁଜ୍‍ନାନ୍‍ ମାରି ୱେଡ଼େ ନିଂନାନ୍‍, ମାରି ଆୟା ୱିତୁ ଏଣ୍ତେସ୍‌ ଗାଜା ଆତାଦୋ ପିର୍‍ତାତ୍‍, ଆକା ୱାନ୍‌ ନେସ୍‌ଏପ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ବୁମି ନିଜେ ପାଡ଼ୁ ତାପିସ୍‍କିନାତ୍‍, ଆଗ୍‌ଡ଼ି ଆକୁ, ୱେନ୍‌କା ସେରେନ୍‍, ତାନି ୱେନ୍‌କା ସେରେନ୍‍ତୁ ବର୍ତି ପାଡ଼୍‍କୁ । ");
INSERT INTO kfcp_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ଆବେଟ୍‌ ସେରେନ୍‍ ପାଣ୍ତିତି ଦାପ୍ରେ ୱାନ୍‌ ଡେରେଙ୍ଗ୍‍ କୁଲିଙ୍ଗ୍‍ ଆତେ ଇଜି କଏର୍‌ଙ୍ଗୁଁ ଆସ୍‍ନା ସନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","“ଜିସୁ ମାରି ଇର୍‌ଆନ୍‌, ମାଡୁ ମାପୁରୁଦି ରାଜିଦିଙ୍ଗ୍‍ ଆମାତାନିୱାଲେ ତୁସ୍‍ନାଟ୍‍ ?” ବା ଇକା ଏମେ କାତା ୱେର୍‌ସି ଆକା ବୁଝାକିନାଟ୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ମାପୁରୁଦି ରାଜି ଆକା ଉଣ୍ତ୍ରି ସାର୍‍ସୁ ପାଡ଼ୁଦି ୱାଜା; ବୁମିଦୁ ୱିତ୍‍ତିୱାଲେ ଆକା ଦୁନିଆଦି ୱିତୁ ପାଡ୍‍କାଣ୍‍ ଇସ୍ରିକାତ୍‍, ");
INSERT INTO kfcp_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ମାତର୍‌ ୱିତ୍‍ତି ୱେନ୍‌କା ଆକା ପିର୍‌ଜି ନିଂଇନାଦ ୱିଜୁ କୁସେଙ୍ଗାଁ ମାଣ୍‌କୁ ପେରିକାତ୍‍ ଆନାତ୍‌, ମାରି ତାନି କମେଙ୍ଗ୍‍ ଇୟାୱାଜା ପେରିକେଙ୍ଗ୍‌ ଆନେ ଯେ, ବାଦଡ଼୍‍ତି ପଟିଙ୍ଗ୍‌ ମାରାତି ସିତ୍‍ଡ଼ିଦୁ ତେବାଦେଙ୍ଗ୍‍ ଆଟ୍‌ନେ । ");
INSERT INTO kfcp_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ଜିସୁ ଇୟାୱାଜା ନାଣ୍ତ କାତାଦାନ୍‍ ଲୋକା ବୁଜାନି ଶକ୍ତି ଇସାବ୍‌ତାନ୍‌ ୱାରିମାନୁ ବାକ୍ୟ ୱେର୍‌ସି ମାର୍‌ଆନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ଜିସୁ କାତା ଇନ୍‍ଏଣ୍ତା ଇନିକାବା ଲୋକାଙ୍ଗ୍‌ ଇନ୍‍ଏଜି ମାର୍‌ଆନ୍‌ । ମାତର୍‌ ଜିସୁ ଆଇ ଲୋକୁ ସିଲିୱାଲେ ୱାନି ସିସୁରିଙ୍ଗ୍‌ ୱିଜୁମାଟା ବୁଝାକିଜି ମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ଆୟା ନାଣ୍ଡିଙ୍ଗ୍ ମିଲିମିଲିକା ଜିସୁ ସିସୁରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ରାଦୁ, ସାମ୍‌ଦୁର୍‌ତୁ ଆୟା ପାଡ଼ି ସନାଟ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ଆବେଟ୍‌ ୱାନି ସିସୁର୍‍ ଲୋକାଙ୍ଗ୍‌ ଡ଼ିସ୍‍ତାରୋ, ଜିସୁ ଆଗ୍‌ଡ଼ି ଆମା ଡଙ୍ଗାଁଦୁ ବାସ୍ତା ମାର୍‌ଆନ୍‌ ଆବେ ୱାର୍‌ ଏକ୍‍ତାର୍‍ ମାରି ଜିସୁଙ୍ଗୁଁ ଅର୍‌ସେ ଅତାର୍‍, ମାରି ଆବେ ଆଇ ଡଙ୍ଗ୍‍ଗେଙ୍ଗ୍‍ ବା ମାର୍‍ହେ । ");
INSERT INTO kfcp_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ଆୟାୱେନ୍‌କା ସାମ୍‌ଦୁର୍‌ତୁ ଉଣ୍ତ୍ରି ଗାଲିପିରୁ ୱାତାତ୍‍, ମାରି ଉଲ୍‍କା ଏର୍‌ ଆଟ୍‍ତେଆକା ଡଙ୍ଗାଁଦୁ ଏରୁ ପୁରୁନ୍‌ ଆଦେଙ୍ଗ୍‌ ଆରାମ୍‍ଆତେ । ");
INSERT INTO kfcp_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ଜିସୁ ଜାହାଜ୍‌ଦି ଲୋଇ ଉନ୍‌ଡ୍ରି ବାକ୍‌ରାଦି ୱେନ୍‌କା ତରନ୍‌ ସର୍‍ଆନ୍‍ନୋ ତାଲା ଟାଟ୍‍ନି ପିଡା ତାଲାଆଡ୍‍ଗି ଇଟ୍‍ଟାନ୍‍ନୋ ଶୁଜ୍‍ଜିମାର୍‍ଆନ୍‍; ସିସୁର୍‌ ଜିସୁଙ୍ଗୁଁ ନିକ୍‍ସି ଇର୍ହାର୍‌, “ଏ ଗୁରୁ, ମାପ୍‌ ସାତାପ୍‌, ନିନ୍‌ ଇନିକା ଅଡ଼୍‍ବିଇ ନୋ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ଆବେଟ୍‌ ଜିସୁ ନିଂଇତାନ୍‍ନୋ ଗାଲିଦିଙ୍ଗ୍‍ ଆଦ୍‌ରିସ୍‌ କିଜି ଉଲକାଏର୍‍ତିଙ୍ଗ୍‍ ଇର୍‌ଆନ୍‌, “ତିର୍‌ ଆଆ” ତେବାଆ । ଆବେଟ୍‌ ଗାଲି ଉଣାଆତାତ୍‍ ମାରି ୱିଜୁ ତିର୍‍ଆତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ଆୟାୱେନ୍‌କା ଜିସୁ ସିସୁରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ମିର୍‌ ଇନ୍‍ଦାନିଙ୍ଗ୍‍ ନିସା ତିଲାଜିନିଦେର୍‍ ? ଇକା ଇନିକା ! ଇୟାସାନ୍ଦି ମି ବିସ୍‌ବାସ୍‌ ସିଲେତ୍‌ ନୋ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ଆବେଟ୍‌କୁ ସିସୁର୍‌ ନାଣ୍ତ ତିଲାତାରୋ ୱାରି ୱାରି ଲୋଇ ୱାର୍‌ଗିଜି ସାତାର୍‌, “ଇୟା ଲୋକ୍‍ ଏନ୍‍ ଜେ, ଗାଲି ନି ଏରୁ ବା ୱାନି ମାଟା ମାନାନେ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ୱେନ୍‌କା ଜିସୁ ମାରି ୱାନି ସିସୁର୍‍ ଗାଲିଲି ସାମ୍‌ଦୁର୍‌ ଆୟାପାଡ଼ିଦି ଗରାସିୟରି ସାନ୍ଧିଦୁ ସର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ଜିସୁ ଡଙ୍ଗାଁଦାନ୍‍ ରେତି ଦାପ୍ରେ ଅରେନ୍‍ ଦୁବା ଆତ୍ମା କାସ୍ତି ଲୋକୁ ଦୁକି ଲୋଇରାନ୍‌ ସତାନ୍‍ନୋ ଜିସୁଙ୍ଗୁଁ ବେଟ୍‍ଆତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ୱାଣ୍ତ୍ରୁ ଦୁକିଦୁ ତେବାଜି ମାର୍‌ଆନ୍‌, ୱାନିଙ୍ଗ୍‌ ଏନ୍‍ବା ସିକ୍‍ଣିଦାନ୍‍ ତର୍‌ତେଙ୍ଗ୍‍ଁ ଆଟ୍‍ଏଜିମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ୱାନ୍‌ ଏସାଦେବେଙ୍ଗ୍‍ ମେଟିଙ୍ଗ୍‍ ନି ଶିକ୍‍ଣିଦାନ୍‍ ତର୍‍ରାଇ ଆତାମାର୍‍ଆନ୍‍, ମାତର୍‌ ୱାନ୍‌ ସିକ୍‍ଣି ତେଉଜି ପକ୍‍ସି ମାର୍‌ଆନ୍‌ ମାରି ମେଟିଙ୍ଗ୍‍ କଣ୍ତ୍‌ କଣ୍ତ୍‌ କିଜି ରୁକ୍‍ସି ମାର୍‌ଆନ୍‌ ମାରି ୱାନିଙ୍ଗ୍‌ ତର୍‍ସୋ ଇଡ୍‌ଦେଙ୍ଗ୍‌ ଏ ବପୁବା ସିଲେତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ୱାଣ୍ତ୍ରୁ ୱେଡ଼େ ନାଡ଼ା ୱିଜୁ ୱାଲେ ଦୁକିଗୁଟା ମାରି ଗରନ୍‌କାଙ୍ଗ୍‍ ତେବାଜି ଆଉଲି ଆଜିମାର୍ହାନ୍‍, ମାରି କାଲ୍‍କାଣ୍‍ ନିଜେଦି ମେନ୍ଧଲ୍‍ତିଙ୍ଗ୍‍ ଚିତ୍ରା କାବ୍ରା କିଜି କତାଜି ମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ୱାନ୍‌ ଆକରାନ୍‍ ଜିସୁଙ୍ଗୁଁ ସୁଡ଼ୁତାନ୍‌ନୋ ଉରୁକ୍‍ସି ୱାଜି ୱାନି ଆଗ୍‌ଡ଼ି ଆର୍‍ତାନ୍‍, ");
INSERT INTO kfcp_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ମାରି ନାଣ୍ତ ଆଉଲି ଆଜି ଇର୍‌ଆନ୍‌, ଏ ୱିଜେରିଙ୍ଗ୍‍ ମୁସ୍‌କୁ ମାନି ମାପୁରୁଦି ମାରିସି ଜିସୁ, ନି ୱାଲେ ନା ଇନିକା ମାନାତ୍‌ ? ନିଙ୍ଗିଁ ମାପୁରୁଦି ଦର୍‌ତାନ୍‌ ମାଡ଼ିସ୍‌ କିଜିନା, ନାଙ୍ଗିଁ କାସ୍ଟୁ ସିମା । ");
INSERT INTO kfcp_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ଇରିଙ୍ଗ୍‌ ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆ ମାର୍‌ଆନ୍‌, “ଏରେ ତାଗ୍‍ଇଆତ୍ମା, ଇୟା ଲୋକ୍‌ତିମାଣ୍‍କୁ ସହସ ସାଙ୍ଗ୍‍ଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ମାରି, ଜିସୁ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, ନି ଦର୍‌ ଇନିକା ? ୱାନ୍‌ ଜିସୁଙ୍ଗୁଁ ଇର୍‌ଆନ୍‌, ନା ଦର୍‌ ବାହିନି, ଇରିଙ୍ଗ୍‌ ମାପୁ ନାଣ୍ତ । ");
INSERT INTO kfcp_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ମାରି, ଜିସୁ ଏଣ୍ତେସ୍‌ ୱାନିକାଙ୍ଗ୍‌ ଆୟା ସାନ୍ଦିଦାନ୍‍ ଆତ୍‌ରେ ପୋକ୍‍ଏନ୍‍, ଆୟା ଉଣ୍ତିଙ୍ଗ୍‌ ଆୟା ଦୁବା ଆସ୍‍ତିକାନ୍‍ ୱାନିଙ୍ଗ୍‌ ନାଣ୍ତ ମାଡ଼ିସ୍‍କିତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ଆୟା ଲାକ୍‌ତୁରି ଗରନ୍‌ ଆଡ୍‍ଗି ଉଣ୍ତ୍ରି ପେରି ପାନ୍‍ଣ୍ତ୍ରିଙ୍ଗ୍‍ ମାନ୍ଦା ସାରାଜିମାର୍‌ଏ । ");
INSERT INTO kfcp_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ମାରି, ତାଗ୍‌ଇ ଆତ୍‍ମେଙ୍ଗ୍‍ ଜିସୁଙ୍ଗୁଁ ମାଡ଼ିସ୍‍ କିଜି ଇର୍‌ଏ, “ଆୟା ପାନ୍‍ଡ୍ରିଙ୍ଗ୍‍ଆ ଲୋଇ ଡ଼ୁଗୁଦେଙ୍ଗ୍‍ ଇଜି ମାଙ୍ଗିଁ ୱାନିକା ମାନୁ ପୋକ୍‌ଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ଜିସୁ ୱାନିକାଙ୍ଗ୍‌ ଆଦେସ୍‌ ସିତାନ୍‌ ଆକା, ତାଗ୍‌ଇ ଆତ୍‍ମେଙ୍ଗ୍‍ ସତେନୋ ପାନ୍‍ଡ୍ରିଙ୍ଗାଁ ଲୋଇ ଡ଼ୁଗିତେ; ଆୟା ପାନ୍‍ଡ୍ରି ମାନ୍ଧା ଉରୁକ୍‍ସି ସର୍‍ହେନୋ ଟିପୁଦାନ୍‍ ଉରୁକ୍‌ସି ସଲ୍‌ସି ସାମ୍‌ଦୁର୍‌ତୁ ଆର୍‌ଜି ମୁଡ଼ୁଗିତେ ସାତେ । ପାନ୍‍ଡ୍ରିଙ୍ଗ୍‍ ଇସାବ୍‌ ଦୁଇ ହଜାର୍‍ ମାର୍‍ହେ । ");
INSERT INTO kfcp_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ପାନ୍‍ଡ୍ରିଆଙ୍ଗ୍‍ ସାଆରା କିନି ଲୋକୁ ଉରୁକ୍‍ସି ସର୍‍ଆର୍‍ରୋ ଗାଡ଼୍‌କାଙ୍ଗ୍‌ ନି ନାର୍‍କାଙ୍ଗ୍‍ଁ ଆୟା ମାଟା ୱେର୍‌ତାର୍‌; ଆବେଟ୍‌ ଲୋକୁ ଇନିକା ଆତାମାନାତ୍‌ ଇଜି ସୁଡ଼ୁଗା ୱାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ମାରି, ଲୋକୁ ଜିସୁ ଲାକ୍‌ତୁ ୱାତାରୋ ଆୟା ଆମାୱାନିଙ୍ଗ୍‌ କି ବାହିନି ଦୁବା ଆସ୍‌ତା ମାର୍‌ଆତ୍‌, ୱାନିଙ୍ଗ୍‌ ନେଗି ୱାତି ପିଡ଼୍‍ଗ୍‍ଜୋ ନେଗି ମୋନ୍‍ତାନ୍‍ ବାସ୍‍ତି ମାର୍‌ଇକା ସୁଡ଼ୁତାରୋ ତିଲାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ଆମାକାର୍‌ ସୁଡ଼ୁତା ମାର୍‌ଆର୍‌, ୱାର୍‌ ଆୟା ଦୁବାକାସ୍ତି ୱାନିଙ୍ଗ୍‌ ଇନିକା ଆତାମାର୍‌ଆତ୍‌, ଆକା ନି ପାନ୍‍ଡ୍ରିଙ୍ଗାଁ ବିସୟତାନ୍ ୱାରିମାନୁ ୱେର୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ଆବେଟ୍‌ ୱାର୍‌ ୱାରି ରାଜିଦାନ୍‍ ଡ଼ିସ୍‌ସି ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଜିସୁଙ୍ଗୁଁ ମାଡ଼ିସ୍‍କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ୱେନ୍‌କା ଜିସୁ ଡଙ୍ଗାଁଦୁ ଏକ୍‍ନିୱାଲେ, ଆମାୱାନିଙ୍ଗ୍‌ ଆଗ୍‌ଡ଼ି ଦୁବା କାସ୍ତା ମାର୍‌ଆତ୍‌, ୱାନ୍‌ ଜିସୁୱାଲେ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଇଜି ରିଜା ମୁଜା ଇର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ମାତର୍‌ ଜିସୁ ୱାନିୱାଲେ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ସାରି ସିଏଣ୍ତା ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ମି ଇନ୍‌ଡ୍ର, ମାରି ମି ନିଜେଦି ଲୋକାମାନୁ ସାଙ୍ଗ୍‍ଆ, ପ୍ରବୁ ନି ଉଣ୍ତିଙ୍ଗ୍‌ ଆମା ଆମା କାର୍ମୁ କିତାମାନାନ୍‍ ମାରି ନି ଉଣ୍ତିଙ୍ଗ୍‌ ଏମେ ଦୟା ତର୍‍ତା ମାନାନ୍‌, ଆୟାୱିଜୁ ୱିଜେରିଙ୍ଗ୍‍ ଇନ୍‌ଆଁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ଆବେଟ୍‌ ୱାଣ୍ତ୍ରୁ ସର୍‌ଆନ୍‌, ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଆମା ଆମା ପାଣି କିତାମାର୍ହାନ୍‌, ଦଶ୍‌ଗୋଟା ଗାଡ଼୍‌କୁ ଦେକାପଲି ଇଜିମାନି ଦଶ୍‌ଗୋଟା ଗାଡ଼୍‌କାଙ୍ଗ୍‌ ରାଜିଦୁ ପ୍ରଚାର୍‌ କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌; ଆବେଟ୍‌ ୱିଜେରେ କାବାଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ଜିସୁ ଡଙ୍ଗାଁଦୁ ନାତାନ୍‍ନୋ ମାରିଡ଼େସି ସାମ୍‌ଦୁର୍‌ ଆୟାପାଡ଼ି ସର୍‌ଆନ୍‌ । ୱାନ୍‌ ସାମ୍‌ଦୁର୍‌ ପାଡ଼ିମାନିୱାଲେ ନାଣ୍ତ ଲୋକୁ ୱାନି ଲାକ୍‌ତୁ ଉଣ୍ତାତାର୍‌; ମାରି ଜିସୁ ସାମ୍‌ଦୁର୍‌ ପାଡ଼ି ତେବାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ନାସ୍ତିୱାଲେ ପାର୍‌ତନା ଇଲୁଦି ପେରିକାନ୍‌ ଜାଇରସ୍‍ ଦର୍‌ତି ଅରେନ୍‍ ଲୋକୁ ୱାଜି ଜିସୁଙ୍ଗୁଁ ସୁଡ଼ୁତାନ୍‌ନୋ ୱାନି ଆଗ୍‌ଡ଼ି ପାଡ଼୍‍ଗ୍‍ଜି ମାଡ଼ିସ୍‍କିତାନ୍‍, ");
INSERT INTO kfcp_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ମାରି ଜିସୁଙ୍ଗୁଁ ନାଣ୍ତ ମାଡ଼ିସ୍‌ କିଜି ଇର୍‌ଆନ୍‌, “ନା ଗାଡ଼ି ସାତାମାନାତ୍‌; ନା ଗାଡ଼ି ଏଣ୍ତେସ୍‌ ନେଗେନ୍‍ ଆନାତ୍‍ନୋ ଜିନାତ୍‌, ଆୟା ଉଣ୍ତିଙ୍ଗ୍‌ ନିନୁ ୱାଜ ତାନି ମୁସ୍‌କୁ ନି କିୟୁ ଇଡିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ଆବେଟ୍‌ ଜିସୁ ୱାନିୱାଲେ ସର୍‌ଆନ୍‌, ମାରି ଲୋକୁ ୱିଜେରେ ୱାନି ୱାଲେୱାଲେ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, ୱାର୍‌ ୱାନି ମୁସ୍‌କୁ ମାଟ୍‍ସି ସାଜି ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ନାସ୍ତିୱାଲେ ବାର ବାର୍‍ସେକ୍‍ ସାନ୍ଦି ସୁତୁକ୍‍ ଆନି ରୋଗ୍‌ ଆସ୍‍ତି ଆଇମା ମାରାଆତ୍‍, ");
INSERT INTO kfcp_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ଆମାକାତ୍‍ କି ନାଣ୍ତ ଦୁକ୍‍ ବଗାଜି ଡାକ୍‌ତର୍‌କା ମାଣ୍‌କୁ ସେବା କିଆଇଆଜି ତାନେ ୱିଜୁ ଡାବୁଙ୍ଗୁଁ ୱିସ୍‌ତା ମାର୍‌ଆତ୍‌, ମାତର୍‌ ଏମେକାବା ନେଗେଣ୍ତ୍‍ ଆଏଣ୍ତା ନାଣ୍ତନେ ରୋଗ୍‌ ଆଜିମାର୍ହାତ୍‍, ");
INSERT INTO kfcp_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ୱାଦୁ ଜିସୁ ବିସୟତାନ୍ ୱେର୍‍ଆଦୋ ନାଣ୍ତ ଲୋକୁ ଲୋଇରାନ୍‌ ୱେନ୍‌କା ସାରି ୱାତାଦୋ ୱାନି ୱାତି ଜାଲିଦିଙ୍ଗ୍‌ ମୁଟ୍‍ତାତ୍‍, ଇରିଙ୍ଗ୍‌ ୱାଦ୍‌ ଇଜିମାର୍‍ଆତ୍‍, ");
INSERT INTO kfcp_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“ନାନୁ ଜିସୁ ୱାତି ମୁଟ୍‍ତିଙ୍ଗ୍‍ ନେଗେନ୍‍ ଆନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ଆୟା ଆଇମା ୱାନି ୱାତି ମୁଟ୍‍ତି ଦାପ୍ରେ ତାନି ସୁତୁକ୍‍ ଆନି ରୋଗ୍‌ ଡ଼ିସ୍‍ତାତ୍‍, ମାରି ଆୟା ଆଇମା ନାନ୍ ନେଗେନ୍‍ ଆତା ଇଜି, ମେନ୍ଦଲ୍‌ତୁ ନେସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‍ତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ଆୟାୱେନ୍‌କା ଜିସୁ ୱାନି ଲୋଇରାନ୍‌ ସାକ୍ତି ସହସି ସନିକା ନେସ୍‌ତାନ୍‌ନୋ ଲୋକୁ ଗହଳି ତରିଣ୍ତ୍‍ ମାର୍‍ତାନ୍‍ନୋ ୱେନ୍‌ବାତାନ୍‌, ଏନ୍‌ ନା ୱାତି ମୁଟ୍‌ତାନ୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ୱାନି ସିସୁର୍‍ ଇର୍ହାର୍‌, “ନିନ୍‍ତୋ ସୁଡ୍‍ଜିନି, ଲୋକ୍‌ଡର୍‌ ନି ସାରିବେଡ୍‍ତି ମାଟ୍‍ସି ସାଜିନାର୍‍, ମାରି ନିନ୍‌ ଇଜିନି, ଏନ୍‌ ନାଂଇ ମୁଟ୍‌ତାନ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ମାତର୍‌ ଏନ୍‌ ନାଂଇ ମୁଟ୍‌ତାନ୍‌, ନେସ୍‌ତେଙ୍ଗ୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ୱାନ୍‌ ସାରିବେଡ଼୍‍ତି ସୁଡ଼ୁଦେଙ୍ଗ୍‍ଆସ୍‌ତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ୱିଜୁ ତାନେଙ୍ଗ୍‌ ଇନିକା ଆତାତ୍‌ଆକା ନେସ୍‍ତାଦୋ ଆୟା ଆଇମା ତିଲାଜି ତିର‍ଗ୍‍ଜି ତିର୍‍ଗ୍‍ଜି ୱାତାଦୋ ଜିସୁ କାଲ୍‌କା ଆଡ୍‍ଗି ମେଣ୍ତେଙ୍ଗ୍‍ ଗଟ୍‌କିଜି ୱିଜୁ ସତ୍‌ ମାଟା ୱେର୍‌ତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ଜିସୁ ତାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ଗାଡ଼ି, ନି ବିସ୍‌ବାସ୍‌ ନିଙ୍ଗିଁ ନେଗେନ୍‌ କିତାମାନାତ୍‌; ସାନ୍ତିଦାନ୍‍ ସାଙ୍ଗ୍‍ଆ ମାରି ନି ରୋଗ୍‌ତାନ୍‌ ନେଗେନ୍‍ ଆଜ ମାନ୍‌ଆ । ");
INSERT INTO kfcp_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ଜିସୁ ଇୟା ମାଟା ଇନିୱାଲେ, ପାର୍‌ତନା ଇଲ୍‌ତୁ ଅଦିକାର୍ ମାନି ଜାଇରସ୍‍ତି ଇନ୍‍ଡ୍ରଣାନ୍‍ ଏସୋଲୋକ୍‍ ୱାତା ରୋ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ନି ଗାଡ଼ି ସାତାସରାତ୍‍ଲେ, ଗୁରୁଙ୍ଗ୍‍ ଏନ୍ଧା ମାରି କାସ୍ଟୁ ସିଜିନିଦେର୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ଜିସୁ ଆୟାମାଟା ୱେର୍‍ଆନ୍‍ନୋ ୱେନ୍‍ଇ ୱାଜା ଆତାନ୍‍ନୋ ପାର୍‌ତନା ଇଲୁତୁ ଅଦିକାର୍ ମାନି ଯାଇରସ‍ତିଙ୍ଗ୍‍ ଇର୍‌ଆନ୍‌, “ତିଲାମା, ବିସ୍‌ବାସ୍‌ କିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ତାନେ ୱେନ୍‌କା ଜିସୁ ଯାଇରସତି ଇଲ୍‌ତୁ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଇଜି ଯାକୁବ, ୱାନି ତଡ଼ାନ୍‌ ଯୋହନ ମାରି ପିତର୍‍ତିଙ୍ଗ୍‍ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ମାରି ଏଙ୍ଗ୍‌ବା ୱାନିୱାଲେ ଇଲୁ ଲୋଇ ଅଏତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ୱାର୍‌ ଯାଇରସ୍‍ତି ଇଲ୍‌ତୁ ୱାତାର୍‌ ରୋ, ୱାନ୍‌ ଆଉଲି ଆନିକା ମାରି ଲୋକୁ ନାଣ୍ଡ ବର୍‍କୁକ୍‍ସି ଆଡ଼୍‍ବାନିକା ମାରି ଦୁଃକ୍‌ତାନ୍‌ ଆଡ଼୍‍ବାନିକା ସୁଡ଼ୁତାନ୍‍, ");
INSERT INTO kfcp_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ଜିସୁ ଇଲୁ ଲୋଇ ସର୍‌ଆନ୍‌ ନୋ ଲୋକାଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଏନ୍ଧା ଆଉଲି ମାରି ଆଡ଼୍‍ବାଜିନିଦେର୍‍ ? ଗାଡ଼ି ସାଏତ୍‌, ମାତର୍‌ ୱାଦୁ ସୁସ୍‍ତାମାନାତ୍‍ । ଆବେଟ୍‌ ୱାର୍‌ ୱିଜେରେ ଜିସୁଙ୍ଗୁଁ ସେମାର୍‌ କିତାର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ଜିସୁ ୱିଜୁ ଲୋକାଙ୍ଗ୍‌ ଆତ୍‌ରେ ପୋକ୍‌ତାନ୍‌ ନୋ ଆଇଲିଦି ବୁବାସି ନି ଆଇସିଙ୍ଗ୍‍ ମାରି ୱାନି ମୁଏର୍‌ ଶିଶୁର୍‍ରିଙ୍ଗ୍‍ ୱାନିୱାଲେ ଆସ୍‍ତାନ୍‍ନୋ ଆଇଲି ଆମା ବାଡିଦୁ ଡରିତା ମାର୍‌ଆତ୍‌, ଆବେ ସର୍‍ଆର୍‍ରୋ ଡ଼ୁଗିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ଜିସୁ ଆଇଲିଦି କିୟୁ ଆସ୍‌ସି ଇର୍‌ଆନ୍‌, “ଟାଲିଥାକୁମ୍‌,” ଇରିଙ୍ଗ୍‌ “ଏ ଆଇଲି, ନାନ୍ ନିଂଇ ଇଜିନା ନିଙ୍ଗିଁଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ଆୟାଦାପ୍ରେ ଆଇଲି ନିଂଇତାଦୋ ବୁଲାଦେଙ୍ଗ୍‌ ଆସ୍‌ତାତ୍‌; ନାସ୍ତିୱାଲେ ଆଇଲିଦିଙ୍ଗ୍‍ ବାର ବାର୍ସେକ୍‌ ଆତାମାର୍‌ଆତ୍‌ । ଆବେଟ୍‌ ଇୟା ମାଟା ୱେର୍‌ଆର୍‌ ୱିଜେରେ ନାଣ୍ତ କାବାତାସର୍‍ଆର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ମାରି, ଇୟା ମାଟା ଏଣ୍ତେସ୍‌ ଏନ୍‍ବା ନେସ୍‌ଏର୍‌, ଆୟା ଉଣ୍ତିଙ୍ଗ୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଆଟ୍‍ୱାଦାନ୍‍ ମାଟା ୱେର୍‌ତାନ୍‌, ମାରି ଆଇଲିଦିଙ୍ଗ୍‍ ଇନ୍‍କାବା ଉଟ୍‍ପିସ୍‍କିଦେଙ୍ଗ୍‍ ଇଜି ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ଜିସୁ ଆୟାବାଡି ଡ଼ିସ୍‌ସି ସିସୁରିୱାଲେ ନିଜେ ଏମେ ବାଡ଼ିଦୁ ପିରିତା ମାର୍‌ଆନ୍‌ ଆୟା ବାଡ଼ିଦୁ ୱାତାର୍‌ ମାରି ୱାନି ଶିଶୁର୍‌ ୱାନି ୱାଲେ ୱାଲେ ସର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ରମ୍‍ନିଦିନ୍‍ ଇଗା ୱାତାତ୍‍ ଆକା, ଜିସୁ ପାର୍‌ତନା କିନି ଇଲୁଦୁ ସର୍‍ଆନ୍‍ନୋ ଶିକ୍ଷା ସିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାନ୍‌; ମାରି, ଆବେ ମାର୍‍ହି ୱିଜେରେ ୱାନି ମାଟା ୱେର୍‍ଆର୍‍ରୋ କାବାଆଜି ଇର୍ହାର୍‌, “ଇୟା ଲୋକୁ ଇୟାୱିଜୁ ଶିକ୍ଷା ଆମାଣ୍‍କୁ ପ‍ଇତାନ୍‌ ? ଇୟା ୱାନିଙ୍ଗ୍‌ ଆମାଣ୍‍କୁ ବୁଦି ପୁଟ୍‍ତାମାନାତ୍‍ ? ମାରି ଏମେ ସାକ୍ତିଦି ପାଣି ୱେନି କିୟୁଦାନ୍‌ ଆଜିନାତ୍‍, ଇୟାୱିଜୁ ଇନିକା ? ");
INSERT INTO kfcp_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ଇକାନ୍‌ ଆଜିନାନ୍‍ ଆୟା ବଡ଼େଇ ଆଏନ୍‌ । ୱେନି ଆଇସି ଦର୍‌ ମରିୟମ୍‌, ଯାକୁବ, ଯୋସି, ଯିହୁଦା ମାରି ସିମୋନ୍‌ ୱେନି ତଡ଼ାନ୍‌କୁ । ୱେନି ତାଙ୍ଗିଁକ୍‍ ମା ୱାଲେ ମାନେ ।” ଇୟାୱାଜା ଇଜି ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ମାନାଏତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ବାବବାଦିର୍‌ ନିଜେଦି ରାଜିଦୁ, ନିଜେଦି ଇଲ୍‌ତୁ ମାରି ନିଜେଦି ଲୋକାଙ୍ଗ୍‌ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ଆଇ ଲୋକାମାନୁ ସମ୍ମାନ୍‍ ପଇନାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ଆୟା ବାଡିଦୁ ଜିସୁ ଏସୋ ରୋଗିଲୋକାଙ୍ଗ୍‍ ମୁସ୍‌କୁ କିୟୁ ଇଡ୍‌ଜି ନେଗେଣ୍ତ୍‌ କିନିକା ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ମାରି ଇନି ନାଣ୍ତ କାବାଦି ପାଣି କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ମାରି, ଜିସୁ ୱାରି ଅବିସ୍‍ବାସ୍‌ ସୁଡ଼୍‌ଜି କାବାଆତା ସରଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ୱେନ୍‌କା ଜିସୁ ସାରିବେଡ଼୍‍ତି ନାର୍‍କାଙ୍ଗ୍‍ଁ ନାର୍‍କାଙ୍ଗ୍‍ଁ ବୁଲାଜି ଶିକ୍ଷା ସିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାନ୍‌ । ଆୟାୱାଲେ ଜିସୁ ବାରଲୋକ୍‌ ସିସୁରିଙ୍ଗ୍‌ ଲାକ୍‌ତୁ କୁକ୍‍ତାନ୍‍ନୋ ୱାରିଙ୍ଗ୍‌ ରିଏର୍‌ ରିଏର୍‌ କିଜି ପୋକ୍‌ତେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ ମାରି ୱାରିଙ୍ଗ୍‌ ତାଗ୍‌ଇ ଆତ୍‌ମେଙ୍ଗ୍‌ଆଙ୍ଗ୍‌ ପେର୍‍ଦେଙ୍ଗ୍‍ ଅଦିକାର୍‍ ସିତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ମିର୍‌ ସନିୱାଲେ ଉଣ୍ତ୍ରି ବାଡିଗା ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ରୁଟି, ବା ମଣି ବା ଡାବୁଙ୍ଗୁଁ ଇଡ୍‌ନି ମଣି ଅମାଟ୍‌ ଇଜି ଆଦେସ୍‌ ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ୱାରିଙ୍ଗ୍‌ ଜୁତେଙ୍ଗ୍‍ ବା ଯୋଡ଼୍‍କୁ ଆରାଦେଙ୍ଗ୍‍ ଇର୍‌ଆନ୍‌, ମାତର୍‌ ଆରାତିମାନି ଆଙ୍ଗିଁ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ଆଇକା ଅମାଟ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ମାରି, ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଆମା ଇନ୍‌ଡ୍ରଣି ଲୋକୁ ମିଙ୍ଗିଁ ମାନାନାର୍‌, ଆୟା ବାଡି ଡ଼ିସ୍‌ନି ସନି ସାନ୍ଦି ଆବେ ତେବାଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ଜଦି ମିର୍‌ ଏମେ ନାର୍‍ତୁ ସନିଦେର୍‍ ଆୟା ବାଡ଼ିଦି ଲୋକୁ ମିଙ୍ଗିଁ ମାନାଏର୍‍, ବା ମି ମାଟା ୱେନ୍‌ଏର୍‌, ଆୟା ବାଡି ଡ଼ିସ୍‍ନିୱାଲେ ୱାରିମାନୁ ସାକି ସିଦେଙ୍ଗ୍‍ ମି ପାଦାମ୍‍କାଣି ଦୁଡ଼ି ସାଡ଼୍‍ତୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ଇୟା ୱେନ୍‌କା ସିସୁର୍‌ ନାର୍‍କାଙ୍ଗ୍‍ଁ ସଲ୍‌ସି ପାପ୍‍ସାରି ଡ଼ିସ୍‌ସି ମନତିଙ୍ଗ୍‌ ଡ଼େପ୍‍ସି ରାଦୁ ଇଜି, ଆକା ଲୋକାମାନୁ ପ୍ରଚାର୍‌କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ୱାର୍‌ ନାଣ୍ତ ଦୁବା କାସ୍ତି ଲୋକାଙ୍ଗ୍‌ ଦୁବେଙ୍ଗ୍‍ ଡ଼ିସିସ୍‍ କିତାର୍‍ ମାରି ନାଣ୍ତ ରୋଗ୍‌ ଲୋକାଙ୍ଗ୍‌ ନିୟୁ ଉସ୍‍ସି ନେଗେଣ୍ତ୍‍କିତାର୍ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ଜିସୁ ଦର୍‌ ୱିଜୁ ତରିନ୍‌ ୱେଙ୍ଗିଁତାତ୍‍ଆକା ୱାନି ବିସୟତାନ୍ ହେରୋଦ ରାଜା ୱେର୍‌ଆନ୍‌, ମାରି ଲୋକୁ ଇଜିମାର୍‌ଆର୍‌, “ଡୁବନ୍‌ସିନି ଯୋହନ ସାତିଲୋକାମାଣାନ୍‌କୁ ନିଙ୍ଗିଁତାମାନାନ୍‌, ଆୟା ଉଣ୍ତିଙ୍ଗ୍‌ ଇୟାୱିଜୁ ସାକ୍ତି ୱେନିମାନୁ ପାଣିକିଜିନାତ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ମାତର୍‌ ଆଇ ଲୋକ୍‌ଡର୍‌ ଇଜିମାର୍‌ଆର୍‌, “ୱାଣ୍ତ୍‍ରୁ ଏଲିୟ୍‌,” ମାରି ଏସୋ ଲୋକୁ ଇଜିମାର୍‌ଆର୍‌, “ପୁର୍ବେଦି ବାବବାଦିରି ୱାଜା ୱାଣ୍ତ୍‍ରୁ ବା ଅରେନ୍‍ ବାବବାଦି ।” ");
INSERT INTO kfcp_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ମାତର୍‌ ହେରୋଦ ଇକା ୱେର୍‌ଆ ଇର୍‌ଆନ୍‌, “ନାନ୍ ଆମା ଯୋହନତି ତାଲା କଇତା ମାର୍ହା, ଆୟା ଯୋହନ ମାରିଡ଼େସି ନିଙ୍ଗିଁତାମାନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ହେରୋଦ, ଯୋହନତିଙ୍ଗ୍‍ ତର୍‌ସି ଜଇଲ୍‌ତୁ ଇଡ୍‌ଦେଙ୍ଗ୍‌ ଆଦେସ୍‌ ସିତାମାର୍‍ଆନ୍‍, ଇରିଙ୍ଗ୍‌ ହେରୋଦ ୱାନି ତଡ଼ାନ୍‍ ପିଲିପ୍‍ତି ଆଡ଼୍‌ସି ହେରୋଦିଆଦିଙ୍ଗ୍‍ ପେଡ଼ି ଆତା ମାର୍‌ଆନ୍‌ ଆକା ଇକା କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ଇରିଙ୍ଗ୍‌ ଯୋହନ ହେରୋଦତିଙ୍ଗ୍‍ ଇଜିମାର୍‌ଆନ୍‌, “ନିଜେଦି ତଡ଼ାନ୍‍ତି ଆଡ଼ିଦିଙ୍ଗ୍‍ ଇଡ୍‌ନିକା ନିୟମ୍‌ ସିଲେତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ହେରୋଦିଆ ଯୋହନତିଙ୍ଗ୍‍ ଶାତ୍ରୁୱାଜା ସୁଡ଼୍‌ଜି ରିସା ଆତାଦୋ ସାୟାମାର୍‌ଗା ଡାକ୍‌ତେଙ୍ଗ୍‌ ବଦା କିଜିମାର୍‌ଆତ୍‌, ମାତର୍‌ ଆଟ୍‍ଏଜି ମାର୍‌ଆତ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ଇରିଙ୍ଗ୍‌ ହେରୋଦ ଯୋହନତିଙ୍ଗ୍‍ ଅରେନ୍‍ ଦାର୍ମୁ ମାରି ପବିତ୍ର ଲୋକ୍‌ ଇଜି ନେସ୍‌ସି ତିଲାଜି ମାର୍‌ଆନ୍‌, ମାରି ଯୋହନତିଙ୍ଗ୍‍ ରକ୍ଷା କିଦେଙ୍ଗ୍‌ ବଦାକିଜି ମାର୍‌ଆର୍‌, ମାରି ହେରୋଦ ଯୋହନତି ମାଟା ୱେନ୍‌ଜି ନାଣ୍ଡ ତରବର ଆଜିମାର୍ହାନ୍‍ ଆତିଙ୍ଗ୍‌ବା ୱେଡ଼ିକାଦାନ୍‌ ଆୟା ମାଟା ୱେନ୍‍ଜି ମାର୍‍ଆନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ସାରାସାରି ଏସ ଦିନ୍‌ ୱେନ୍‌କା ହେରୋଦିଆଦିଙ୍ଗ୍‍ ଉଣ୍ତ୍ରି ସାରି ତରିତାତ୍‌ । ହେରୋଦ ୱାନି ଜନମ୍‌ ଦିନ୍‍ତୁ ୱିଜୁ ପେରି ପେରି ଲୋକାଙ୍ଗ୍‌, ସେନାପତିରିଙ୍ଗ୍‍ ମାରି ଗାଲିଲିଦି ୱିଜୁ ପେରି ଲୋକାଙ୍ଗ୍‌ ଉଣ୍ତେଙ୍ଗ୍‌ ନାଡ଼ା ସମୟତୁ ଉଣ୍ତ୍ରି ବୋଜି ତିଆର୍‌ କିତାନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ମାରି, ହେରୋଦିଆଦି ଗାଡ଼୍‌ସି ଲୋଇ ୱାତାତ୍‌ଦ ଗାତ୍‍ସି ହେରୋଦ ମାରି ବୋଜିଦୁ ବାସ୍‍ତି ମାର୍‍ହି କୁଡ଼ାଆଙ୍ଗ୍‍ ମୋନ୍‌ତିଙ୍ଗ୍‌ ୱେଡ଼ିକା କିବିସ୍‍କିତାତ୍‍ । ଆବେଟ୍‌ ହେରୋଦ ରାଜା ଗାଡ଼୍‍ସିଙ୍ଗ୍‍ ୱେନ୍‌ବାତାନ୍‌, “ନିନ୍‌ ଇନିକା ବଦାକିଜିନି, ଲସ୍‌ଆ, ନାନ୍ ଆକା ନିଂଇ ସିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","“ନାନ୍ ପାର୍‌ମାଣ୍‌ କିଜି ଇଜିନା, ନିନ୍‌ ଆମାକା ଲସ୍‌ନି, ଆକା ରାଜିଦି ଆଧା ବାଗ୍‌ ବା ସିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ଆବେଟ୍‌ ଗାଡ଼୍‌ସି ଆତ୍‌ରେ ସର୍ହାଦୋ ତାନି ଆଇସିଙ୍ଗ୍‍ ୱେନ୍‌ବାତାତ୍‌, ନାନୁ ଇନିକା ଲସ୍‍ନା ? ତାମେ ଆଇସି ଦାପେ ଦାପେ, ତାନେଙ୍ଗ୍‌ ଇର୍ହାତ୍‌, “ନିନୁ ଡୁବନ୍‌ ସିନି ଯୋହନତି ତାଲା ଲସ୍‌ଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ଆୟାଦାପ୍ରେ ଗାଡ଼୍‌ସି ରାଜାମାନୁ ଉରୁକ୍‌ସି ୱାଜି ଇର୍ହାତ୍‌, “ନା ବଦା ଯେ, ନିନ୍‌ ଡୁବନ୍‌ସିନି ଯୋହନତି ତାଲା ଇୟାଦାପ୍ରେ ନାଂଇ ଉଣ୍ତ୍ରି ସାଡ଼୍‍ୱାଦୁ ସିଦା ।” ");
INSERT INTO kfcp_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ଇକା ମାଟା ୱେନ୍‌ଜି ହେରୋଦ ରାଜା ନାଣ୍ତ ଦୁଃଖ କିତାନ୍‌ ମାତର୍‌ କୁଡ଼ାଆଙ୍ଗାଁ ଆଗ୍‌ଡ଼ି ପାର୍‌ମାଣ୍‌ କିତାମାର୍ହାନ୍‌ଆକା ସିଲେ ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆଟ୍‍ଏତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ଆବେଟ୍‌ ରାଜା ଦାପ୍ରେ ଅରେନ୍‍ ସନ୍ୟଙ୍ଗ୍‍ ପୋକ୍‌ତାନ୍‌ ନୋ ଯୋହନତି ତାଲା ତାତେଙ୍ଗ୍‌ ଆଦେସ୍‌ ସିତାନ୍‌ । ୱାଣ୍ତ୍ରୁ ସର୍‌ଆନ୍‌ ନୋ ଜଇଲି ଲୋଇ ଯୋହନତି ତାଲା କଇତାନ୍‍, ");
INSERT INTO kfcp_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ଯୋହନତି ତାଲା ଉଣ୍ତ୍ରି ସାଡ଼୍‍ୱାଦୁ ତାତାନ୍‍ ନୋ ଆଇଲିଦିଙ୍ଗ୍‍ ସିତାନ୍‌, ଆୟାକା ଆଇଲି ଆସ୍‍ତାଦୋ ତାମେ ଆଇସିଙ୍ଗ୍‍ ସିତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ଯୋହନତି ସିସୁର୍‍ ଆୟା କାବୁର୍‌ ୱେର୍‌ଆର୍‌ରୋ ୱାତାର୍‌ ମାରି ୱାନି ସାତି ମାଡ଼ା ଆସ୍‌ତା ଅତାରୋ ଦୁକି ଗୁଟାଦୁ ମୁସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ୱେନ୍‌କା ସିସୁର୍‍ ଜିସୁ ଲାକ୍‌ତୁ ଉଣ୍ତାତାର୍‌, ୱାରୁ ଏମେ ଏମେକା କିତାମାର୍‍ଆର୍‍ ମାରି ଏମେ ଏମେକା ଶିକ୍ଷା ସିତାମାର୍‍ଆର୍‍, ଆୟାୱିଜୁ ୱାନିଙ୍ଗ୍‌ ୱେର୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ଆବେଟ୍‌ ୱାନ୍‌ ୱାନି ସିସୁରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ସାଦୁ ମାଡୁ ଏର୍‍ନାଡ ଉଣ୍ତ୍ରି ସିମ୍ରା ବାଡିଦୁ ସନାଟ୍‌ । ଆବେ ଏସୋ ସମୟ ରୋମ୍‍ନାଟ୍‍ ।” ଇରିଙ୍ଗ୍‌ ନାଣ୍ତ ଲୋକୁ ୱିଜେରେ ସନିକା ୱାନିକା ଆଜିମାର୍ହାର୍‍ ଆକା ୱାରିଙ୍ଗ୍‌ ଉଣ୍ତେଙ୍ଗ୍‌ ବା ସମୟ ସିଲେତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ଆୟାୱେନ୍‌କା ଜିସୁ ମାରି ୱାନି ଶିଶୁର୍‌ ଡଙ୍ଗାଁଦୁ ଏକ୍‍ତାର୍‍ନୋ ଉଣ୍ତ୍ରି ସିମ୍ରା ବାଡିଦୁ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ସତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ମାତର୍‌ ୱାର୍‌ ସନିୱାଲେ ଏସୋ ଲୋକୁ ୱାରିଙ୍ଗ୍‌ ସୁଡ଼୍‌ଜି ମାରି ସିନିସ୍‍ କିତାର୍‍, ମାରି ଲୋକୁ ୱିଜେରେ ୱିଜୁ ଗାଡ୍‌କାଣାକୁ ପାଦାମ୍‌କାଣ୍‌କୁ ଆବେ ଅର୍‌ସେ ଉରୁକ୍‍ସି ସରଆର୍‌ ରୋ ୱାରି ଆଗିଡ଼ି ଇଗା ସରଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ଜିସୁ ଡଙ୍ଗାଁଦାନ୍‍ ସତାନ୍‍ନୋ ନାଣ୍ତ ଲୋକାଙ୍ଗ୍‌ ସୁଡ଼୍‌ଜି ୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ଦୁଃକ୍‌‍ କିତାନ୍‌, ଇରିଙ୍ଗ୍‌ ୱାର୍‌ ଗାଉଡ଼ୁ ସିଲି ମେଣ୍ତେଙ୍ଗାଁ ମାନ୍ଦା ୱାଜା ୱାର୍‌ ସାକାସିଲିକା ନି ସିନ୍ତା ଆଜିମାର୍ହାର୍‍; ମାରି, ୱାଣ୍ତ୍ରୁ ୱାରିଙ୍ଗ୍‌ ନାଣ୍ତ ସିକିୟା ସିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ନାଣ୍ତ ୱେଡ଼ା ଆତାତ୍‌ଆକା ୱାନି ସିସୁର୍‍ ୱାନି ଲାକ୍‌ତୁ ୱାତା ଇର୍ହାର୍‌, “ଇୟାବାଡିତୋ ସିମ୍ରା, ମାରି ନାଣ୍ତ ୱେଡ଼ା ଆତାତ୍‌ନି; ");
INSERT INTO kfcp_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ଲୋକୁ ଏଣ୍ତେସ୍‌କି ସାରିବେଡ଼୍‍ତି ନାର୍‍କାଙ୍ଗ୍‍ଁ ସନାର୍‌ ନିଜେ ନିଜେଦି ଉଣ୍ତିଙ୍ଗ୍‌ ଏସୋ ଉଣି ଖାଦି କଣାର୍‍, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାରିଙ୍ଗ୍‌ ପୋକ୍‌ଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ମାତର୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମିର୍‌ ୱାରିଙ୍ଗ୍‌ ଉଣ୍ତେଙ୍ଗ୍‌ ସିଦୁ,” ସିସୁର୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ମାପ୍‌ ଇନିକା ଆଟ୍‍ଗୋଟା ଲେଜ୍‍ତି କୁଲି ଡାବୁଦାନ୍‍ ରୁଟି କଣାପ୍‍ ୱେରିଙ୍ଗ୍‌ ସିନାପ୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ମି ଲାକ୍‌ତୁ ଏସୋ ଗୋଟା ରୁଟିଙ୍ଗ୍‌ ମାନେ ? ସଲ୍‍ସ ସୁଡ଼୍‍ଦୁ ।” ସିସୁର୍‌ ସର୍‌ଆ ୱେର୍‌ଆ ୱାତା ରୋ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ପାସ୍‌ଗୋଟା ରୁଟିଙ୍ଗ୍‌ ମାରି ରୁଣ୍ତି ମିନ୍‌କୁ ମାନେ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ୱିଜେରେ ଏଣ୍ତେସ୍‌କି ଧାଡ଼ି ଧାଡ଼ି ଆଜି କଡ଼୍‍କି ଲାଟା ମାନି ବାଡିଦୁ ବାସ୍‍ନାର୍‍, ଆୟା ଉଣ୍ତିଙ୍ଗ୍‌ ଜିସୁ ବାସିସ୍‌ କିଦେଙ୍ଗ୍‌ ୱାରିଙ୍ଗ୍‌ ଆଦେସ୍‌ ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ଆବେଟ୍‌ ୱିଜେରେ ଶହେ ଶହେ ଲୋକୁ ମାରି ପଚାସ୍‍ ପଚାସ୍‍ ଲୋକୁ ଧାଡ଼ି ଆଜି ବାସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ଆୟାୱେନ୍‌କା ଜିସୁ ଆୟା ପାସ୍‌ଗୋଟା ରୁଟିଙ୍ଗ୍‌ ମାରି ରୁଣ୍ତି ମିନ୍‌କୁ ଅସି ସ୍ୱର୍ଗ ମୁସ୍‌କୁ ସୁଡ଼୍‌ଜି ମାପୁରୁଦିଙ୍ଗ୍‌ ଦନ୍ୟବାଦ୍‌ ସିତାନ୍‌ ମାରି ରୁଟିଙ୍ଗ୍‌ ରୁକ୍‍ସି ଲୋକାଙ୍ଗ୍‌ ବାଟାକିଜି ସିଦେଙ୍ଗ୍‍ ସିସୁରିଙ୍ଗ୍‌ ସିତାନ୍‌ । ଆୟା ରୁଣ୍ତି ମିନ୍‍କାଙ୍ଗ୍‍ ବା ବାଟାକିଜି ସିଦେଙ୍ଗ୍‍ ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ୱିଜୁ ଲୋକୁ ୱିଜେରେ ତିର୍‌ଆରୋ ପଟାପାଜିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ଇୟା ୱେନ୍‌କା ସିସୁର୍‌ ଏଜିତି ରୁଟିଙ୍ଗ୍‌ ମାରି ମିନ୍‌କୁ ମୋକେଙ୍ଗ୍‍ ପେର୍ଜି ବାରଗୋଟା ଡାଡ଼ିଦୁ ବର୍ତି କିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ଏମେ ଲୋକ୍‌ଡର୍‌ ଇୟା ରୁଟିଙ୍ଗ୍‌ ତିର୍ହା ମାର୍‍ଆର୍‍, ୱାରି ଲୋଇ ଆବ୍‍କା ମେମାର୍‍ଙ୍ଗୁଁ ଲୋକୁନେ ୫,୦୦୦ ହାଜାର୍‌ ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ଆୟାଦାପ୍ରେ ଜିସୁ ୱାନି ସିସୁରିଙ୍ଗ୍‌ ଡଙ୍ଗାଁଦୁ ବାସିସ୍‌ତାନ୍‌ ନୋ ସାମ୍‌ଦୁର୍‌ତୁ ଆୟା ପାଡ଼ିଦି ବେତ୍‍ସାଇଦାଦୁ ୱାନି ଆଗ୍‍ଡ଼ିନେ ସଣ୍ଡ୍ରେଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ଆବେଟ୍‌ ଲୋକାଙ୍ଗ୍‌ ଜିସୁ ପୋକ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ଜିସୁ ଲୋକାଙ୍ଗ୍‌ ପୋକ୍‍ତି ୱେନ୍‌କା ୱାନ୍‌ ପାର୍‌ତନା କିଦେଙ୍ଗ୍‌ ଇଜି ଗରନ୍‌ ମୁସ୍‌କୁ ସର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ମିଲିମିଲିକା ଆଜି ୱାନିୱାଲେ ଡଙ୍ଗାଁ ସାମ୍‌ଦୁର୍‌ ନାଡ଼୍‍ମି ମାର୍‌ଆତ୍‌ ମାରି ୱାନ୍‌ ପାଡ଼ି ଅରେନ୍‍ ମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ଜିସୁ ସୁଡ଼ୁତାନ୍‌ ଯେ ସିସୁରି ଡଙ୍ଗାଁଦି ସାଟ୍‍ୱା ଡାକ୍‌ତେଙ୍ଗ୍‍ଁ ଇଜି ନାଣ୍ତ ବାଦାଜି ମାର୍‌ଆର୍‌ । ଇରିଙ୍ଗ୍‌ ନାସ୍ତିୱାଲେ ଗାଲି ୱାରି ଆଗ୍‌ଡ଼ି ସାରି ୱାଜି ମାର୍‌ଆତ୍‌ । ସାଲ୍‍ଦି ଆନିୱାଲେ ଜିସୁ ଏର୍‌ ମୁସ୍‌କୁ ବୁଲାଜି ବୁଲାଜି ଶିଶୁରି ଲାକ୍‌ତୁ ୱାତାନ୍‌, ୱାଣ୍ତ୍ରୁ ସିସୁରି ଲାକ୍‌ତୁରାନ୍‌ ଆଜି ଆଗ୍‌ଡ଼ି ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ବଦା କିଜି ମାର୍ହାନ୍‍ ");
INSERT INTO kfcp_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ମାତର୍‌ ସିସୁର୍‌ ୱାନିଙ୍ଗ୍‌ ସାମ୍‌ଦୁର୍‌ ମୁସ୍‌କୁ ବୁଲାନିକା ସୁଡ଼ୁତାରୋ, “ଦୁବା ଇଜି” ଅଡ୍‍ବିତାରୋ ନାଣ୍ତ ଆଉଲି ଆତାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ଇରିଙ୍ଗ୍‌ ୱିଜେରେ ଜିସୁଙ୍ଗୁଁ ସୁଡ଼ୁତାର୍‌ ତିଲାତା ସର୍‍ହାମାର୍‍ଆର୍‍ । ମାତର୍‌ ଜିସୁ ଆୟାଦାପ୍ରେ ୱାରିୱାଲେ ୱାର୍‌ଗିଜି ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ସାସ୍‌ ଆସ୍‌ତୁ, ତିଲାମାଟ୍‌, “ନାନ୍ ତୋ ଜିସୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ଜିସୁ ୱାରି ଲାକ୍‌ତୁ ସର୍‍ଆନ୍‍ନୋ ଡଙ୍ଗାଁଦୁ ଏକ୍‍ତାନ୍‍, ଆବେଟ୍‌ ଗାଲି ତିର୍‌ ଆତାତ୍‌ । ସିସୁର୍‌ ମନ୍ ଲୋଇ ନାଣ୍ତ କାବାଆତା ସରଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ଇରିଙ୍ଗ୍‌ ୱାର୍‌ ପାସ୍‌ ହଜାର୍‍ ଲୋକାଙ୍ଗ୍‌ ରୁଟିଙ୍ଗ୍‌ ଉଠ୍‌ପିସ୍‌କିତି ବିସୟଦି ଅର୍ତ ବୁଝାଏତା ମାର୍‌ଆର୍‌, ଇରିଙ୍ଗ୍‌ ୱାରି ବୁଦ୍ଧି ଗୁପାତା ମାର୍‌ଆତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ଜିସୁ ମାରି ୱାନି ସିସୁର୍‌ ସାମ୍‌ଦୁର୍‌ ନାସି ଗିନେସରତି ସାନ୍ଧିଦୁ ୱାତାର୍‍ନୋ ସାମ୍‌ଦୁର୍‌ ପାଡ଼ି ଡଙ୍ଗାଁ ତର୍‍ତାର୍ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ୱାର୍‌ ଡଙ୍ଗାଁଦାଣ୍ତ୍‍ ରେତି ୱାତିଦାପ୍ରେ ଲୋକୁ ଜିସୁଙ୍ଗୁଁ ସୁଡ଼୍‌ଜି ସିନିସ୍‍ତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ଆବେଟ୍‌ ଆୟା ସାରିବେଡ୍‍ତି ନାର୍‌କାଙ୍ଗ୍‌ ଉର୍‌କୁସି ସର୍‌ଆର୍‌ । ଜିସୁ ଆମା ଆମା ବାଡ଼ିଦୁ ମାର୍‌ଆନ୍‌ ମାରି ଲୋକୁ ୱିଜେରେ ରୋଗ୍‌ ଲୋକାଙ୍ଗ୍‌ କାଟେଲ୍‍ତୁ ପିଣ୍ତ୍‍ଜି ଜିସୁମାନୁ ତାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ଜିସୁ ଏମେ ଏମେ ନାର୍‍, ଗାଡ଼୍‌ ମାରି ଲୋଇରି ନାର୍‌କାଙ୍ଗ୍‌ ସର୍‍ହାନ୍‍, ଲୋକ୍‌ ୱିଜେରେ ୱିଜୁ ବାଡ଼ିଦି ରୋଗିଲୋକାଙ୍ଗ୍‍ ସାତାଦୁ ତାତାରୋ ଉଣ୍ତାକିତାର୍‍, ମାରି ରୋଗିଲୋକ୍‍ ଏଣ୍ତେସ୍‌କି ୱାନି ୱାତି ଜାଲି ଅଡ଼ପ୍‍ ମୁଟ୍‍ନାର୍‍, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ଜିସୁଙ୍ଗୁଁ ମାଡ଼ିସ୍‌ କିତାର୍‍; ମାରି ଏସୋ ଲୋକ୍‌ଡର୍‌ ଜିସୁଦି ୱାତି ଜାଲି ମୁଟ୍‍ତାର୍‍ ଆୟା ଲୋକ୍‌ଡର୍‌ ନେଗେନ୍‍ ଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ୱେନ୍‌କା ପାରୁସିର୍‌ ମାରି ଜିରୁସାଲାମ୍‍ତାନ୍‌ ୱାତି ମାର୍‍ଇ ଏସୋ ସାସ୍ତ୍ରିର୍‌ ଜିସୁ ସାରିବେଡ୍‍ତି ଉଣ୍ତାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ୱାର୍‌ ସୁଡ଼ୁତାର୍‌ ଯେ, ୱାନି ଏସୋ ସିସୁର୍‍ ଜିହୁଦିରି ଇସାବ୍‌ତାନ୍‌ କିୟୁ ନର୍‍ବାଏଣ୍ତା ଉଣୁଜି ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ପାରୁସିର୍‌ ମାରି ୱିଜେରେ ଯିହୁଦୀଲୋକ୍‍ ୱାରି ପୁର୍ବେଦି ନେତାରି ରୀତିନୀତି ମାନାଜି ନେଗେଣ୍ତ୍‍ କିୟୁ ନର୍‍ବାଏତିଙ୍ଗ୍‍ ୱାର୍‌ ଉଣୁଏର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ସାତାଦୁ ସର୍‍ହି ୱାତି ୱେନ୍‌କା ନିଜେ ନିଜେଦି ମୁସ୍‌କୁ ଏର୍‌ ଲଜାଏତିଙ୍ଗ୍‍ ଉଣୁଏର୍‌; ମାରି ଗିନା, ମୁତା ମାରି କସ୍‍ ନକି ଏର୍‌ତୁ ମୁଡ଼ୁକିିସି ନର୍‍ବାନିକା, ଖାଟେଲ୍‍ତୁ ଏରୁ ସିଲିକ୍‌ନିକା ୱିଜୁ ଆଇ ରୀତିନୀତି ମାନାଦେଙ୍ଗ୍‌ ଇଜି ୱାର୍‌ ଆଦେସ୍‌ ପଇତା ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ପାରୁସିର୍‌ ମାରି ସାସ୍ତ୍ରିର୍‌ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାର୍‌, “ନି ସିସୁର୍‍ ପୁର୍ବେଦି ନେତାରି ରୀତିନୀତି ଦାଣ୍ତ୍‍ ସାଲାଏଣ୍ତା କିକୁ ନର୍‍ବାଏଣ୍ତା ଏନ୍ଦା ଉଣୁଜିନାର୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ଏ ସାଲାକିଦି, ଜିସାଇୟ ବାବବାଦି ମି ବିସୟତୁ ଟିକ୍‍ତାନ୍‍ ମାଟା ୱେର୍‍ତା ମାନାନ୍‌, ଏଣ୍ତେସ୍‌ ରାସାତାମାନାତ୍‌, ମାପୁରୁ ଇନାନ୍‌, ଇୟା ଜାତିଦି ଲୋକ୍‌ଡର୍‌ ମାଙ୍ଗିଁ ତାମେ ମକମିନେ ମାନାନାର୍‌, ମାତର୍‌ ୱାରି ଜିବନ୍‌ ମାବାଣ୍‍କୁ ଆକ ତେବାନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ୱାର୍‌ ଲୋକୁ ତିଆର୍‌ କିତିମାନି ରୀତିନୀତି ଦିଙ୍ଗ୍‍ ମାପୁରୁଦି ଆଦେସ୍‌ ଇଜି ଶିକ୍ଷା ସିନାର୍‍ ଆର୍‍ଏନେ ମା ସେବା କିଜିନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“ମିର୍‌ ମାପୁରୁଦି ଆଦେସ୍‌ ଡ଼ିସ୍‌ସି ଲୋକୁ ତିଆର୍‍କିତି ନିୟମ୍‌ତିଙ୍ଗ୍‌ ଆସ୍‍ସିନିଦେର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ମାରି ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ମିର୍‌ ମି ସାଲାକିଦାନ୍‍ ମାପୁରୁଦି ମାଟାଦିଙ୍ଗ୍‌ ମାନାଇଜିନିଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ଇରିଙ୍ଗ୍‌ ମୋସା ନିୟମ୍‌ ସିତାମାନାନ୍‌, ମି ବୁବା ୟାୟାଏଙ୍ଗ୍‍ ମାନାଦୁ, ମାରି ଏନ୍‌ ନିଜେଦି ବୁବା ନି ୟାୟାଙ୍ଗ୍‌ ଆନାଦୁରିଆ ସିନାନ୍‌, ୱାଣ୍ତ୍ରୁ ଏଣ୍ତେସ୍‌ କିଜିବା ସାନି ଦଣ୍ଡ୍‌ ପଇନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ମାତର୍‌ ମି ଇନ୍‌ଡ୍ର, ଜଦି ଅରେନ୍‍ ଲୋକ୍‌ତିମାନୁ ୱାନି ବୁବା ୟାୟାଏଙ୍ଗ୍‍ ସାହାଜ୍ୟ କିଦେଙ୍ଗ୍‌ ମାନାତ୍‌, ମାତର୍‌ ଆୟା ଲୋକୁ ଇଜିନାନ୍‌, କାର୍ବାନ୍‍ ମାପୁରୁତିଙ୍ଗ୍‍ ପୁଜା ସିତାମାନା । ");
INSERT INTO kfcp_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ଆଦେଙ୍ଗ୍‌ ମିର୍‌ ୱାନିଙ୍ଗ୍‌ ୱାନି ବୁବା ୟାୟାଦିଙ୍ଗ୍‍ ସାହାଜ୍ୟ କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ସିଇଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ଇୟାୱାଜା ମିର୍‌ ପୁର୍ବେଦି ଲୋକ୍‌ତି ରୀତିନୀତି ଉଣ୍ତିଙ୍ଗ୍‌ ମାପୁରୁଦି ବାକ୍ୟଦିଙ୍ଗ୍‍ ଲାତ୍‍ ଡାକ୍‍ସିନିଦେର୍‍ ମାରି ଆୟାୱାଜା ନାଣ୍ତ ସେଇ ପାଣିବା କିଜିିନିଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ଅର୍‌ଲେନ୍‌ ଜିସୁ ଲୋକାଙ୍ଗ୍‌ ଲାକ୍‌ତୁ କୁକ୍‌ସି ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମିର୍‌ ୱିଜେରେ ନା ମାଟା ୱେନ୍‌ଡ୍ରୁ ମାରି ବୁଝାଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ଲୋକ୍‌ତି ମେନ୍ଧଲ୍‍ ଆତ୍‌ରେ ଇୟାୱାଜା ଇନି ବିସୟ ସିଲେତ୍‌, ଆମାକା କି ୱାନି ଲୋଇ ଡ଼ୁଗୁଜି ୱାନିଙ୍ଗ୍‌ ଅପବିତ୍ର କିନାତ୍‌, ମାତର୍‌ ଏମେ ଏମେକା ଲୋକ୍‌ତି ଲୋଇରାନ୍‌ ସନାତ୍‌, ଆୟାୱିଜୁ ୱାନିଙ୍ଗ୍‌ ଅପବିତ୍ର କିନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ଜଦି ଆମାୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଗିତଣିଙ୍ଗ୍‍ମାନେ ୱାଣ୍ତ୍ରୁ ୱେନିନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ଜିସୁ ଲୋକାଙ୍ଗ୍‌ ଡ଼ିସ୍‌ସି ଇନ୍‌ଡ୍ର ୱାତି ୱେନ୍‌କା ୱାନି ସିସୁର୍‍ ଇୟା କାତାଦି ଅର୍ତ ବୁଝାକିଜି ସିଦା ଇଜି ଇର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ଆବେଟ୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମିର୍‍ବା ଇନିକା ୱାରିୱାଜା ବୁଜାଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏଜିନିଦେର୍‍ ? ଏମେକା କି ଆତ୍‍ରେରାନ୍‍ ଲୋକା ଲୋଇ ଡ଼ୁଗ୍‍ନାତ୍‍, ଆକା ୱାନିଙ୍ଗ୍‌ ସେଏଣ୍ଡ୍‌ କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ଇରିଙ୍ଗ୍‌ ଆକା ୱାନି ଜିବନ୍‌ତୁ ଡ଼ୁଗ୍‍ଏତ୍‍, ମାତର୍‌ ପଟା ଲୋଇ ଡ଼ୁଗୁଜି ଆତ୍‌ରେ ସନା ସନାତ୍‌ ।” ମାରି ଇବେଣୁକୁ ୱିଜୁ ଖାଦି ନରାନା ସନାତ୍‌, ଇକା ଜିସୁ ଇର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ଜିସୁ ଇର୍ହାନ୍‌, “ଆମାକା ଲୋକ୍‍ମାଣ୍‍କୁ ସନାତ୍‌, ଆକାନେ ୱାନିଙ୍ଗ୍‌ ଅପବିତ୍ର କିନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ଇରିଙ୍ଗ୍‌ ଲୋଇରାନ୍‌, ଲୋକ୍‌ତି ଜିବନ୍‍ତାନ୍‍, ତାଗ୍‌ଇଚିନ୍ତା ସନାତ୍‌, ଦାରିପାଣି, ଡଂଆ, ଲୋକ୍‌ତିଙ୍ଗ୍‌ ସାୟାମାର୍‌ଗାଡାକ୍‌ନିକା, ");
INSERT INTO kfcp_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ଆଇୱାନି ଆଇମାଦିମାନୁ ସନିକା, ଲୋଭ୍‍, କାରାପ୍‌, ମିଛ୍‍ ମାଟା, ଗାଡ଼୍‍ୟା, ସୁଡ଼୍‌ଜି ଆକାର୍‍ ଆନିକା, ସୁଡ଼୍‌ଜି ଲାଲ୍‍ଇଆନିକା, ନିଦା, ଗାର୍ବୁ କିନିକା, ମୁର୍ଖୁଆନିକା; ");
INSERT INTO kfcp_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ଇୟା ତାଗ୍‌ଇ ପାଣିୱିଜୁ ଲୋଇରାନ୍‌ ସହସି ଲୋକ୍‌ତିଙ୍ଗ୍‌ ଅପବିତ୍ର କିନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ଆୟାୱେନ୍‌କା ଜିସୁ ଆୟା ବାଡି ଡ଼ିସ୍‍ସି ସୋର ଗାଡ଼୍‌ତି ରାଜିଦୁ ସର୍‌ଆନ୍‌, ଉଣ୍ତ୍ରି ଇନ୍‌ଡ୍ର ଡ଼ୁଗିତାନ୍‍ନୋ, ଏର୍‍ବା ଏଣ୍ତେସ୍‌ ଆକା ନେସ୍‌ଏର୍‌, ଇକା ବଦା କିଜିମାର୍‍ଆନ୍‍, ମାତର୍‌ ୱାଣ୍ତ୍ରୁ ଆବେ ମାର୍ଗିଜୋ ମାନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଆଟ୍‍ଏତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ଆୟାଦାପ୍ରେ ଅରେତ୍‌ ଆଇମା ଜିସୁ ୱାତି ମାର୍‍ଇ କାବୁର୍‌ ୱେର୍‍ଆଦୋ ୱାତାତ୍‍, ଇରିଙ୍ଗ୍‌ ତାନି ଗାଡ଼୍‍ସିଙ୍ଗ୍‍ ତାଗ୍‍ଇଆତ୍ମା ଆସ୍‌ତା ମାର୍‌ଆତ୍‌ । ଆଦେଙ୍ଗ୍‌ ଆୟା ଆଇମା ୱାନି ପାଦାମ୍‌କାଙ୍ଗ୍‌ ମାଡ଼ିସ୍‌ କିଜି ଗୁରିତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ଆୟା ସୁର ଦେଶ୍‍ତି ସୁରଫେନିକିୟା ଜାତିଦି ଅରେତ୍‌ ଗ୍ରୀକ୍‍ ଆଇମା ମାର୍‌ଆତ୍‌ । ତାନି ଆଇଲି ମାଣାନ୍‌ ଦୁବା ଡ଼ିସ୍‍ସିସ୍‍ କିଦେଙ୍ଗ୍‌ ଇଜି ଜିସୁଙ୍ଗୁଁ ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ଆବେଟ୍‌ ଜିସୁ ତାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନିଜେଦି କଡ଼ରିଙ୍ଗ୍‌ ଆଗ୍‌ଡ଼ି ଖାଦି ପଟାବର୍ତି ଉଟ୍‍ପିସ୍‍ତେଙ୍ଗ୍‍ ଆନାତ୍‌, ଇରିଙ୍ଗ୍‌ କଡ଼ରି ବାଟା ଖାଦି ଅସି ନୁକୁଡ଼ିଆଙ୍ଗାଁ ମାନୁ ପୋକ୍‍ନିକା ନେଗେତ୍‌ ସିଲେ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ଜିସୁଙ୍ଗୁଁ ଆୟା ଆଇମା ଇର୍ହାତ୍‌, “ହୁଁ, ପ୍ରବୁ, ନୁକୁଡ଼ିଙ୍ଗ୍‍ବା ଟେବୁଲ୍‍ ଆଡ୍‍ଗି ମାନ୍‌ଜି କଡ଼ର୍‌ ଉଟି ୱିସ୍‌ତି ସକ୍‌ଡ଼ି ଆର୍ତିକା ଉଣେ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ଜିସୁ ଆୟା ଆଇମାଦିଙ୍ଗ୍‍ ଇର୍‌ଆନ୍‌, “ନିନୁ ଇୟା ମାଟା ଇର୍‍ଇ ଉଣ୍ତିଙ୍ଗ୍‌ ସାଙ୍ଗ୍‍ଆ, ନି ଗାଡ଼ିଦି ମାଣାନ୍‌ ଦୁବା ସତା ସର୍‌ଆତ୍‌ ନି ।” ");
INSERT INTO kfcp_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ଆୟା ଆଇମା ଇନ୍‌ଡ୍ର ଡ଼େସି ସଲ୍‌ସି ସୁଡ଼ୁତାତ୍‍ ଯେ ତାନି ଆଇଲି ଟାଟିଦୁ ଡରିତା ମାନାତ୍‌ ମାରି ସତେନେ ଦୁବା ଆଇଲି ମାଣ୍‌କୁ ଡ଼ିସ୍‍ତା ସର୍‌ଆତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ଆୟାୱେନ୍‌କା ଜିସୁ ସୋର୍‍ ସାନ୍ଧିଦାଣ୍ତ୍ ଡ଼ିସ୍‌ସି ସିଦନ୍‍ ମାରି ଦେକାପଲି ସାନ୍ଧି ସିଜି ଗାଲିଲି ସାମ୍‌ଦୁର୍‌ ପାଡ଼ି ୱାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ଏସୋ ଲୋକୁ ଗୁଲା ମାରି ବଇରା ଲୋକ୍‌ତିଙ୍ଗ୍‌ ଜିସୁ ଲାକ୍‌ତୁ ତାତାର୍‌ । ମାରି ୱାନି ମୁସ୍‌କୁ କିୟୁ ଇଡ୍‌ଦେଙ୍ଗ୍‌ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ଜିସୁ ଆୟା ଲୋକ୍‌ତିଙ୍ଗ୍‌ ଲୋକା ଗଲିଦାନ୍‍ ଅଡ଼ପ୍‍ ଆକ ଅତାନ୍‍ନୋ ୱାନି ରୁଣ୍ତି ଗିତଣିଆଙ୍ଗ୍‍ ୱାନି ଡ଼ାସ୍‍କେଙ୍ଗ୍‍ ମୁଟ୍‌ତାନ୍‌ ମାରି ପୁସ୍‍ସି ୱାନି ୱେତଲ୍‍ତିଙ୍ଗ୍‍ ମୁଟ୍‌ତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ଆୟାୱେନ୍‌କା ୱାନ୍‌ ସ୍ୱର୍ଗ ମୁସ୍‌କୁ ସୁଡ଼୍‍ଜି ପୁଣ୍ତା ଡ଼ିସ୍‌ସି ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଇପ୍‍ପଥଃ,” ଇରିଙ୍ଗ୍‌ ଗୁଲାଦି “ୱେୟୁ ୱାର୍‍ଗିଦେଙ୍ଗ୍‍ ରାଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ଆୟା ଦାପ୍ରେ ୱାନ୍‌ ଗିତଣିଙ୍ଗ୍‍ ୱେନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆଟ୍‍ତାନ୍‍ ମାରି ୱାନି ୱେତଲ୍‍ କୁଦିତାତ୍‍ ଆବେଟ୍‌ ୱାନ୍‌ ନେଗେନ୍‌ କିଜି ୱାର୍‍ଗିଦେଙ୍ଗ୍‍ ଆଟ୍‍ତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ଇୟା ନେଗେଣ୍ତ୍‍ କିତି ମାଟା ଏଙ୍ଗ୍‌ବା ଇନ୍‌ମାଟ୍‌ ଇଜି ଆଟ୍‍ୱାଦାନ୍‍ ଜିସୁ ଲୋକାଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ମାତର୍‌ ଜିସୁ ଏସା ମାନା କିତିଙ୍ଗ୍‌ବା, ଲୋକ୍‌ଡର୍‌ ନାସାନେ ୱେର୍‌ସି ବୁଲାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ମାରି, ୱିଜେରେ ଲୋକୁ ନାଣ୍ତ କାବାଆଜି ଇର୍ହାର୍‌, “ୱାଣ୍ତ୍ରୁ ୱିଜୁ ପାଣି ନେଗ୍ରେଣ୍ତା କିତାମାନାନ୍‍; ୱାଣ୍ତ୍ରୁ ୱେନ୍ଇ ଲୋକାଙ୍ଗ୍‌ ୱେନି ବପୁ ମାରି ୱାର୍‌ଗିଇ ଲୋକାଙ୍ଗ୍‌ ୱାର୍‍ଗିନି ବପୁ ବା ସିନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ଆୟାୱାଲେ ଅର୍‍ଲେନ୍‍ ମାରିଡ଼େସି ନାଣ୍ତ ଲୋକୁ ଜିସୁମାନୁ ଉଣ୍ତାତାର୍‌, ନାସ୍ତିୱାଲେ ୱାରିମାନୁ ଉଣିତିନିକା ସିଲେତାତ୍‍ ଆକା ଜିସୁ ୱାନି ସିସୁରିଙ୍ଗ୍‌ ଲାକ୍‌ତୁ କୁକ୍‍ତାନ୍‍ନୋ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“ଇୟା ଲୋକା ଉଣ୍ତିଙ୍ଗ୍‌ ନା ଜିବନ୍‌ ଦୟା ଆଜିନାତ୍‍, ଇରିଙ୍ଗ୍‌ ଇକାର୍‌ ମୁନେନ୍‌ ଆତାତ୍‌ନି ନାୱାଲେ ମାନାର୍‌ ମାରି ୱେରିମାନୁ ଉଣ୍ତେଙ୍ଗ୍‌ ଇନିକା ବା ସିଲେତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ଜଦି ନାନୁ ୱାରିଙ୍ଗ୍‌ ତାମେ ଇଲ୍‌କାଙ୍ଗ୍‌ ଉଟ୍‍ପିସ୍‍କିଏଣ୍ତା ପୋକ୍‌ନା, ନାସ୍ତିୱାଲେ ୱାର୍‌ ସାର୍‍ଦୁ ସନାରୋ ମେଡ଼୍‍ନାର୍‍; ଇରିଙ୍ଗ୍‌ ୱାରିମାଣାନ୍‌ ଏସୋ ଲୋକୁ ନାଣ୍ତ ଆକଣାନ୍‍ ୱାତାମାନାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ସିସୁର୍‍ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାର୍‌, “ଇୟା ସିମ୍ରା ବାଡିଦୁ ଏନ୍‌ ଆମାବାଣ୍‍କୁ ରୁଟି ତାସ ୱେରିଙ୍ଗ୍‌ ପଟାବର୍ତି ଉଟ୍‍ପିସ୍‍କିଦେଙ୍ଗ୍‍ ଆଟ୍‍ନାନ୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ୱେନ୍‍ବାତାନ୍‌, ମି ଲାକ୍‌ତୁ ଏସଗୋଟା ରୁଟିଙ୍ଗ୍‌ ମାନେ ? ୱାର୍‌ ଇର୍ହାର୍‌, “ସାତ୍‍ଗୋଟା ରୁଟିଙ୍ଗ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ଜିସୁ ଲୋକାଙ୍ଗ୍‌ ବୁମି ମୁସ୍‌କୁ ବାସ୍‌ତେଙ୍ଗ୍‌ ଆଦେସ୍‌ ସିତାନ୍‌; ମାରି, ୱାଣ୍ତ୍ରୁ ଆୟା ସାତଗୋଟା ରୁଟିଙ୍ଗ୍‌ ଅତାନ୍‌ନୋ ମାପୁରୁଦିଙ୍ଗ୍‌ ଧନ୍ୟବାଦ ସିଜି ରୁଟିଙ୍ଗ୍‌ ମକା ମକା କିଜି ରୁକ୍‍ସି ବାଟା କିଜି ସିଦେଙ୍ଗ୍‍ ୱାନି ସିସୁରିଙ୍ଗ୍‌ ସିତାନ୍‌ ମାରି ୱାର୍‌ ଲୋକାଙ୍ଗ୍‌ ଆୟା ରୁଟିଙ୍ଗ୍‌ ବାଟାକିଜି ସିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ମାରି ୱାରିମାନୁ ଏସୋ ଇସ୍ରି ମିନ୍‌କୁବା ମାର୍‍ହେ; ଜିସୁ ଆୟା ମିନ୍‍କାଙ୍ଗ୍‌ ମାପୁରୁଦିଙ୍ଗ୍‍ ଦନ୍ୟବାଦ୍‌ ସିଜି ବାଟା କିଜି ଲୋକାଙ୍ଗ୍‌ ସିଦେଙ୍ଗ୍‍ ଇର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ୱିଜେରେ ତିନ୍‌ଞ୍ଜି ପଟା ପାଜିତାର୍‌ ମାରି ସାତ୍‍ଗୋଟା ଡାଡ଼ିଦୁ ଏଜିତି ରୁଟି ମକେଙ୍ଗ୍‌ ଡାଡ଼ିଦୁ ବର୍ତି କିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ଇୟା ଉଟି ଲୋକୁ ନାଲ୍‌ଗି ହାଜାର୍‌ ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ଆୟାୱେନ୍‌କା ଜିସୁ ଲୋକାଙ୍ଗ୍‌ ପୋକ୍‌ତାନ୍‌ ମାରି ଆୟାଦାପ୍ରେ ୱାନି ସିସୁରିୱାଲେ ଡଙ୍ଗାଁଦୁ ଏକ୍‌ତାନ୍‌ନୋ ଦଲ୍‍ମନୁଥା ରାଜିଦୁ ୱାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ପାରୁସିର୍‌ ୱାତା ରୋ ଜିସୁୱାଲେ ମାଟାଦିଙ୍ଗ୍‌ ମାଟା ଆଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ । ମାରି ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଉରିଦୁ ଆର୍‍ତେଙ୍ଗ୍‍ ବଦାକିଜି, ୱାନ୍‌ ଯେ ମାପୁରୁ ମାଣ୍‌କୁ ୱାତାମାନାନ୍‍ ଆକା ତର୍‌ତେଙ୍ଗ୍‍ଁ ବାଦଡ଼୍‍ତାନ୍‍ ଉଣ୍ତ୍ରି କାବାଆନି ପାଣି ତର୍‌ତେଙ୍ଗ୍‍ଁ ଇର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ଜିସୁ ଜିବନ୍‌ତୁ ଦୁକ୍‍ଆଜି ନାଣ୍ତ ପୁଣ୍ତା ଡ଼ିସ୍‌ସି ଇର୍‌ଆନ୍‌, “ଇନ୍‍ଦାନିଙ୍ଗ୍‍ ଇୟା ଜୁଗ୍‍ତି ଲୋକ୍‌ଡର୍‌ ସିନା ପଇଜିନାର୍‍ ? ନାନୁ ମିଙ୍ଗିଁ ସତ୍‌ ୱେର୍‌ସିନା, ଇୟା ଜୁଗ୍‌ତି ଲୋକ୍‌ତିଙ୍ଗ୍‌ ଆମା ସିନା ବା ପୁଟ୍‌ଏତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ସି ମାରିଡ଼େସି ଡଙ୍ଗାଁଦୁ ଏକ୍‍ତାନ୍‍ନୋ ସାମ୍‌ଦୁର୍‌ ଆୟାପାଡ଼ି ସର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ଆୟାୱାଲେ ସିସୁର୍‌ ରୁଟି ଅତେଙ୍ଗ୍‌ ବାଣାତା ସରଆର୍‌; ଡଙ୍ଗାଁଦୁ ୱାରିମାନୁ କେବଲ୍ ଉନ୍‍ଡ୍ରେନେ ରୁଟି ମାର୍‌ଆତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ଜିସୁ ଶିଶୁରିଙ୍ଗ୍‌ ଆଟ୍‌ୱା ମାଟା ଇର୍‌ଆନ୍‌, “ଜାଗାର୍‌ତା ଆଦୁ,” ପାରୁସିର୍‌ ମାରି ହେରୋଦ୍‍କା ମିଚ୍‍ ମାଟାଦାନ୍‌ ଜାଗାର୍‌ତା ମାନ୍‌ଡ଼୍ରୁ, ଆମାକା ଖମୀର୍‍ତି ୱାଜା ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ସିସୁର୍‌ ଇୟା ବିସୟତୁ ୱାରିୱାରି ଲୋଇ ୱାର୍‌ଗିଜି ସାତାର୍‌, “ମାବାନ୍‍ ରୁଟି ସିଲେତ୍‍ଆକା ୱାନ୍‌ ଇୟାୱାଜା ଇଜିନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ଜିସୁ ଆକା ନେସ୍‌ତାନ୍‌ନୋ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ମି ଲାକ୍‌ତୁ ରୁଟିଙ୍ଗ୍‌ ସିଲୁ ଇଜି ଏନ୍ଦା ୱାର୍‌ଗିଜି ସାଜିନିଦେର୍‌ ? ମିର୍‌ ଇୟାସାନ୍ଦି ନେସ୍‌ଇଦେର୍‌ ନୋ ? କି ବୁଝାଇଦେର୍‍ ନୋ ? ମି ଜିବନ୍‌ ନିସାନେ ଆଟ୍‌ୱା ଆତାମାନାତ୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","କାଣୁକୁ ମାନ୍‌ବୁ ମାନ୍‌ବୁ ମିର୍‌ ସୁଡ଼୍‍ଇଜିନିଦେର୍‍ ? ମାରି, ଗିତଣିଙ୍ଗ୍‍ ମାନ୍‌ବୁ ମାନ୍‌ବୁ ୱେନ୍ଇଜିନିଦେର୍‍ ? ମିର୍‌ ଇନିକା ଅଡ଼୍‍ବିଦେଙ୍ଗ୍‍ ଆଟ୍‍ଇଜିନିଦେର୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ପାସ୍‌ଗୋଟା ରୁଟିଙ୍ଗ୍‌ ରୁକ୍‍ସି ଏଣ୍ତେସ୍‌ ୫,୦୦୦ ହାଜାର୍‌ ଲୋକାଙ୍ଗ୍‌ ତିର୍‍ପିସ୍‍କିତା ମାର୍‍ହା, ଆୟାନାଣ୍ତିଙ୍ଗ୍‌ ଏଜିତି ରୁଟି ମକେଙ୍ଗ୍‌ ୱିଜୁ ପେର୍‌ଜି ଏସୋ ଗୋଟା ଡାଡ଼ିଦୁ ବର୍ତି କିତିମାର୍‍ଇଦେର୍‍, ଆକା ମିଙ୍ଗିଁ ଏତ୍‌ ସିଲେତ୍‌ ? ସିସୁର୍‌ ୱାନିଙ୍ଗ୍‌ ୱେର୍‌ତାର୍‌, “ବାରଗଟା ଡାଡ଼ିଙ୍ଗ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","ଜିସୁ ମାରି ୱେନ୍‌ବାତାନ୍‌, “ଏସିୱାଲେ ୪,୦୦୦ ହାଜାର୍‌ ଲୋକା ଉଣ୍ତିଙ୍ଗ୍‌ ସାତ୍‍ଗୋଟା ରୁଟିଙ୍ଗ୍‌ ରୁକ୍‍ସି ସିତାମାର୍‍ହା,” ଏଜିତି ରୁଟି ମୁକେଙ୍ଗ୍‍ ପେର୍‌ଜି ଏସୋ ଗୋଟା ଡାଡ଼ିଦୁ ବର୍ତି କିତିମାର୍‍ଇଦେର୍‍ ? ସିସୁର୍‌ ଇର୍ହାର୍‌, “ସାତ୍‍ଗୋଟା ଡାଡ଼ିଙ୍ଗ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ମିର୍‌ ଇଲେଇବା ବୁଜାଦେଙ୍ଗ୍‌ ଆଟ୍‍ଇଜିନିଦେର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ୱେନ୍‌କା ୱାର୍‌ ବେତ୍‍ସାଇଦା ନାର୍‍ତୁ ୱାତାର୍‌ । ଆବେ ଏସୋ ଲୋକୁ ଅରେନ୍‍ କାଣା ଲୋକ୍‌ତିଙ୍ଗ୍‌ ଜିସୁ ଲାକ୍‌ତୁ ତାତାର୍‌ ନୋ ୱାନିଙ୍ଗ୍‌ ମୁଟ୍‌ସୋ ନେଗେଣ୍ତ୍‍ କିଦେଙ୍ଗ୍‌ ଇର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ଜିସୁ କାଣାଦି କିୟୁ ଆସ୍‌ତାନ୍‌ନୋ ନାର୍‍ତାଣ୍ତ୍‍ ଆକ ଅତାନ୍‍, ଆବେ କାଣାଦି କାଣ୍‍ଗାଦୁ ପୁସ୍‍କାଣାଙ୍ଗ୍‌ ଉସ୍‍ତାନ୍‍ ନୋ ୱାନି ମୁସ୍‌କୁ କିୟୁ ଇଡ୍‌ଜି ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ନିନ୍‌ ଇନିକା ସୁଡ୍‍ଜିନି ନୋ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ଆୟା ଲୋକୁ ମୁସ୍‌କୁ ବେସ୍‍ସି ଇର୍‌ଆନ୍‌, “ହୁଁ ନାନ୍ ଲୋକାଙ୍ଗ୍‌ ସୁଡଦେଙ୍ଗ୍‌ ଆଟ୍‍ସିନା, ଇରିଙ୍ଗ୍‌ ନାନ୍ ଲୋକାଙ୍ଗ୍‌ ବୁଲାନି ମାରାକ୍‍ ୱାଜା ସାରିବେଡ଼୍‍ତି ସୁଡ଼୍‍ଜିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ମାରିଡ଼େସି ଜିସୁ ୱାନି କାଣୁକୁ ମୁସ୍‌କୁ କିୟୁ ଇଟ୍‌ତାନ୍‌; ଆବେଟ୍‌ ୱାଣ୍ତ୍‍ରୁ ନେଗ୍ରେଣ୍ତା ସୁଡ଼୍‍ଦେଙ୍ଗ୍‍ ଆଟ୍‍ତାନ୍‍ ମାରି ନେଗେଣ୍ତ୍‍ ଆତାନ୍‍ନୋ ୱିଜୁ ସୁଡ଼୍‍ଦେଙ୍ଗ୍‍ ଆଟ୍‍ତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ତାମେ ଇନ୍‌ଡ୍ର ପୋକ୍‌ସି ଇର୍‌ଆନ୍‌, “ଇୟା ନାର୍‍ତୁ ସଲ୍‍ମା, ମାତର୍‌ ମି ଇନ୍‌ଡ୍ର ସାଙ୍ଗ୍‍ଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ଇୟା ୱେନ୍‌କା ଜିସୁ ମାରି ୱାନି ସିସୁର୍‍ କାଇସରିୟା ପିଲିପି ରାଜିିଦି ଲାକ୍‌ତୁ ମାନି ନାର୍‍କାଙ୍ଗ୍‍ଁ ସନିୱାଲେ ସନିସାର୍‍ଦୁ ଜିସୁ ୱାନି ଶିଶୁରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ନାନ୍ ଏନ୍‌ ଇଜି ଲୋକ୍‌ଡର୍‌ ଇନିକା ଇଜିନାର୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ଆବେଟ୍‌ ସିସୁର୍‌ ଇର୍ହାର୍‌, “ଏସୋ ଲୋକୁ ଇଜିନାର୍‍ ଡୁବନ୍‌ସିନି ଯୋହନ, ମାରି ଏସୋ ଲୋକୁ ଇଜିନାର୍‍ ନିନ୍‌ ଏଲିୟ୍‌, ମାରି ଏର୍‌ ଏର୍‌ ଇଜିନାର୍‍, ନିନ୍‌ ବାବବାଦିରି ଲୋଇ ଅରେନ୍‍ ବାବବାଦି ।” ");
INSERT INTO kfcp_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ନାନ୍ ଏନ୍‌ ଇଜି ମିର୍‌ ଇନିକା ଇଜିନିଦେର୍‌ ?” ପିତର୍‌ ୱେର୍‌ତାନ୍‌, “ନିନ୍‌ ଆଜିନି ମାପୁରୁତି ପୋକ୍‍ତିମାନି ରକ୍ଷା କିନି କ୍ରିସ୍ତ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଆଟ୍‌ୱା ମାଟା ୱେର୍‌ତାନ୍‌, “ନାନ୍ ଏନ୍‌ ନା ବିସୟ ଏଙ୍ଗ୍‌ବା ଇନ୍‌ମାଟ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ମାରି ଜିସୁ ସିସୁରିଙ୍ଗ୍‌ ବୁଜାକିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାନ୍‌, “ନାନ୍ ମନୁଷ୍ୟପୁତ୍ର ନାଣ୍ତ କାସ୍ଟୁ ପଇନା ମାରି ପେରି ନେତାର୍‌, ପେରି ଯାଜକର ମାରି ସାସ୍ତ୍ରୀରି ମାଣାନ୍‌ ଦଣ୍ଡ୍‌ ପଇଜି ସାଦେଙ୍ଗ୍‌ ଆନାତ୍‌, ମାତର୍‌ ମୁନେଟି ୱେନ୍‌କା ମାରିଡ଼େସି ଜିବନ୍‌ଆଜି ନିଙ୍ଗ୍‍ନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ଜିସୁ ଇୟାୱିଜୁ ମାଟା ନେଗେନେକିଜି ସିସୁରିଙ୍ଗ୍‌ ବୁଜାକିତାନ୍‍ । ଆବେଟ୍‌ ପିତର୍‌ ଜିସୁଙ୍ଗୁଁ ଆଇ ବାଡିଦୁ କୁକ୍‌ସି ଅତାନ୍‌ନୋ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ପ୍ରବୁ ଇୟାୱାଜା ମାଟା ଇନ୍‍ମା ।” ");
INSERT INTO kfcp_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ମାତର୍‌ ଜିସୁ ୱାନି ସିସୁରିଙ୍ଗ୍‌ ସୁଡ଼୍‌ଜି ପିତର୍‍ତିଙ୍ଗ୍‍ ଇର୍‌ଆନ୍‌, “ନା ଲାକ୍‌ତୁରାନ୍‌ ଆକ ଆଆ, ସୟତାନ୍‍, ଇରିଙ୍ଗ୍‌ ନିନ୍‌ ମାପୁରୁତି ବିସୟ ଅଡ଼୍‍ବିଏଣ୍ତା ଲୋକା ବିସୟ ଅଡ଼୍‌ବିଜିନି ।” ");
INSERT INTO kfcp_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ଆୟାୱେନ୍‌କା ଜିସୁ ୱାନି ସିସୁରିଙ୍ଗ୍‌ ମାରି ଉଣ୍ତାତିମାର୍‍ଇ ଲୋକାଙ୍ଗ୍‌ ଲାକ୍‌ତୁ କୁକ୍‌ସି ଇର୍‌ଆନ୍‌, “ଏନ୍‍ବା ନାୱାଲେ ୱାଦେଙ୍ଗ୍‌ ବଦା କିନାନ୍‌,” ୱାଣ୍ତ୍ରୁ ନିଜେ ନାନ୍ ଇନିକା ସିଲେ ଇଜି ଅଡ଼୍‍ବିପିନ୍‍, ୱାଣ୍ତ୍ରୁ ନା ଉଣ୍ତିଙ୍ଗ୍‌ ଦୁକ୍‍ ମାରି ସାନିକା ବଦା କିଜି ୱାଲେ ୱାଲେ ରାପିନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ଏନ୍‍ବା ନିଜେଦି ଜିବନ୍‌ତିଙ୍ଗ୍‌ ରକିୟା କିଦେଙ୍ଗ୍‌ ବଦା କିନାନ୍‌, ୱାଣ୍ତ୍ରୁ ୱାନି ଜିବନ୍‌ ଆରା କିନାନ୍‌; ମାତର୍‌ ଏନ୍‌ ନା ଉଣ୍ତିଙ୍ଗ୍‌ ମାରି ଇୟା ସୁସମାଚାର୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ନିଜେଦି ଜିବନ୍‌ ସିନାନ୍‍, ୱାଣ୍ତ୍ରୁ ୱାନି ଜିବନ୍‌ ରକିୟା କିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ମାରି, ଜଦି ଅରେନ୍‌ ଲୋକୁ‌ ସାରାଦୁନିଆଦିଙ୍ଗ୍‌ ଜିଣାଜି ୱାନି ଜିବନ୍‌ ଆରା କିନାନ୍‌, ଲୋକୁ ୱାନି ଇନିକା ଲାଭ୍‍ ଆନାତ୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ମାରି, ଲୋକୁ ୱାନି ଜିବନ୍‍ତିଙ୍ଗ୍ ଡ଼େସି ପ‍ଇଦେଙ୍ଗ୍‌, ଇନିକା ସିଦେଙ୍ଗ୍‍ ଆଟ୍‍ନାନ୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ଜଦି ଏନ୍‍ବା ନା ଉଣ୍ତିଙ୍ଗ୍‌ ନା ସୁସମାଚାର୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ଇୟା ଦୁନିଆଦି ଦାରିପାଣିକିନି ଲୋକାମାଣାନ୍‌ ମାରି ପାପି ଲୋକ୍‌ତି ଲାକ୍‌ତୁ ନା ବାକ୍ୟ ବିସୟତାନ୍ ସେମାର୍‌ ଆନାନ୍‌, ମନୁଷ୍ୟପୁତ୍ର ଏସ୍ତିୱାଲେ ପବିତ୍ର ଦୁତ୍‍କାୱାଲେ ୱାନି ବୁବାସିଦି ମହିମାଦାନ୍‌ ମାରିଡ଼େସି ୱାନାନ୍‌, ଆୟାୱାଲେ ୱାନ୍‍ବା ଆୟା ବିସୟତାନ୍ ସେମାର୍‌ କିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ମାରିଡ଼େସି ଜିସୁ ୱାରିଙ୍ଗ୍‌ ୱେର୍‌ତାନ୍‌, “ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ମାପୁରୁଦି ରାଜିଦୁ ସାକ୍ତିଦାନ୍‍ ମାନିବାଡି ସୁଡ଼୍‌ଇ ସାନ୍ଧି ଇବେନୁ ନିନି ମାନି ଲୋକା ମାଣ୍‌କୁ ଏସୋ ଲୋକୁ ଏଣ୍ତେସ୍‌ କିଜିବା ସାନିକା ୱେଡ଼୍ଏର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ଛଦିନ୍‍ ୱେନ୍‌କା ଜିସୁ କେବଲ୍‌ ପିତର୍‌, ଜାକୁବ ନି ଯୋହନତିଙ୍ଗ୍‍ ଅର୍‌ସେ ଆସ୍‌ସି ମିସାଜି ୱାରିଙ୍ଗ୍‌ ଉଣ୍ତ୍ରି ପେରି ଗରନ୍‍ତୁ ଅତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ମାରି ଜିସୁ ୱାରିଙ୍ଗ୍‌ ସୁଡ଼ୁବୁ ସୁଡ଼ୁବୁ ୱାନି ମୁର୍‍ତି ବାଦଲାତାତ୍‌, ୱାନି ଆଙ୍ଗିଁ ଇୟାୱାଜା ଜାୟ୍‌ ନି ପୁରା ଅଡ଼ିନିକା ଆତାତ୍‌ ଯେ, ଦୁନିଆତି ଏମେ ନର୍‍ବାନି ଲୋକ୍‍ବା ଇୟାୱାଜା ଅଡ଼ିନିକା କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ମାରି, ମୋଶା ନି ଏଲିୟ୍‌ ଜିସୁୱାଲେ ୱାର୍‌ଗିଜି ମାର୍‍ରିକା ୱାରିଙ୍ଗ୍‌ ତରାତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ଆବେନୁ ପିତର ଜିସୁଙ୍ଗୁଁ ଇର୍ହାନ୍‌, “ଏ ଗୁରୁ, ମାପ୍‌ ଜେ ଇୟା ବାଡିଦୁ ଏସୋ ନେଗେନ୍‌ତାନ୍‍ ମାନାପ୍‍, ମାପୁ ମୁଣ୍ତ୍ରି ଗୁଡ଼େଏଙ୍ଗ୍‍ ତିଆର୍‌ କିନାପ୍‍, ନି ଉଣ୍ତିଙ୍ଗ୍‌ ଉନ୍‌ଡ୍ରି, ମୋସାଦି ଉଣ୍ତିଙ୍ଗ୍‌ ଉନ୍‌ଡ୍ରି ମାରି ଏଲିୟ୍‌ଦି ଉଣ୍ତିଙ୍ଗ୍‌ ଉନ୍‌ଡ୍ରି ।” ");
INSERT INTO kfcp_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ପିତର ଇନି ଉତର୍‌ ସିଦେଙ୍ଗ୍‍ ଇଜି ନେସ୍‌ଏନ୍‌ ମାରାନ୍‌, ଆବେଟ୍‌ ସିସୁର୍‌ ନାଣ୍ତ ତିଲାତା ସର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ମାରି, ଖାଣ୍ତେକ୍‍ ବାଦଡ଼୍‍ ଇମ୍‌ଜି ୱାତା ଦୋ ୱାରିଙ୍ଗ୍‌ ବାଦଡ଼୍‍ତି ନିଡ଼୍‍ଗା ପିଡ଼ିକ୍‍ତାତ୍‍; ମାରି ଆୟା ବାଦଡ଼ତାନ୍‍ ଉଣ୍ତ୍ରି ବଲ୍ ୱାତାତ୍‍, “ଏ ନା ଲାଡ୍‍ତି ମାରିନ୍‌, ୱାନି ବାକ୍ୟ ୱେନ୍‌ଡ୍ରୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ମାରି, ଉଲୁସ୍ତେ ସିସୁର୍‌ ସାରିବେଡ଼୍‍ତି ସୁଡ଼ୁତାର୍‌ ୱାରି ତଡ଼୍‍କାୱାଲେ ଲୋକା ଲୋଇରାନ୍‌ କେବଲ୍‌ ଜିସୁଙ୍ଗୁଁ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ମାରି ଏଙ୍ଗ୍‌ବା ସୁଡ଼ୁଏତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ୱାର୍‌ ଗରନ୍‌ତାନ୍‌ ରେତାଜି ୱାନିୱାଲେ ଜିସୁ ସିସୁରିଙ୍ଗ୍‌ ଆଟ୍‌ୱା ମାଟା ସିଜି ୱେର୍‌ତାନ୍‌, “ମିର୍‌ ଆମାକା ଆମାକା ସୁଡ଼୍‍ତିଦେର୍‍, ଆୟାୱିଜୁ ସାତି ଲୋକାମାଣ୍‌କୁ ନାନ୍ ଯେ ମନୁଷ୍ୟପୁତ୍ରଦି ମାରିଡ଼େସି ଜିବନ୍‌ ଆନି ସାନ୍ଦି ଆୟାମାଟା ଏଙ୍ଗ୍‌ବା ଇନ୍‌ମାଟ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ଆବେଟ୍‌ ୱାର୍‌ ଆୟା ମାଟା ଆସ୍‌ତାରୋ ସାଜ ମାରିଡ଼େସି ଜିବନ୍‌ଆଜି ନିଂଇକା ଇନିକା, ଆୟା ବିସୟତାନ୍ ୱାରି ୱାରି ଲଅ ୱାର୍‍ଗିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ମାରି, ସିସୁର୍‌ ଜିସୁଙ୍ଗୁଁ ୱେନ୍‌ବାତାର୍‌, “ଏଲିୟ୍‌ ଆଗ୍‌ଡ଼ି ୱାନିକା ମାନାତ୍‌ ଇଜି, ଶାସ୍ତ୍ରୀର୍‍ ଏନ୍ଦା ଇନାର୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ଆବେନୁ ଜିସୁ ସିସୁରିଙ୍ଗ୍‌ ୱେର୍‌ତାନ୍‌, ଏଲିୟ୍‌ ଆଗ୍‌ଡ଼ି ୱାନାନ୍‍ନୋ ୱିଜୁ ବିସୟ ମାରିଡ଼େସି ତିଆର୍‌ କିନିକା ସତେନେ । ମାତର୍‌ ନାନ୍ ଯେ ମନୁସ୍ୟପୁତ୍ର ନାଣ୍ତ ଦୁଃକ୍‌‍ ବୋଗାଜି ନିନ୍ଧା ପଇନା ମାରି ସେମାର୍‌ ପୟନା, ଇୟାକା ଏଣ୍ତେସ୍‌ ୱାନି ବିସୟତାନ୍ ରାସ୍‌ତିକା ମାନାତ୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ମାତର୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, “ଏଲିୟ୍‌ ୱାତାତ୍‌ନି, ମାରି ୱାନି ବିସୟତୁ ଏଣ୍ତେସ୍‌ ରାସାତା ମାନାତ୍‌, ଆୟାୱାଜା ୱାରୁ ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ଆମାକା ବଦା ଆୟାକା କିତାମାନାର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ୱେନ୍‌କା ୱାର୍‌ ଆଇ ସିସୁରି ଲାକ୍‌ତୁ ୱାତା ରୋ ସୁଡ଼ୁତାର୍‌, ୱାରି ସାରିବେଡ଼୍‍ତି ନାଣ୍ତ ଲୋକୁ ଉଣ୍ତାତାର୍‌, ମାରି ଶାସ୍ତ୍ରୀର୍‍ ୱାରିୱାଲେ ମାଟାଦିଙ୍ଗ୍‍ମାଟା ଆନିକା ସୁଡ଼ୁତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ଲୋକ୍‌ଡର୍‌ ଜିସୁଙ୍ଗୁଁ ଉଲୁସ୍ତେ ସୁଡ଼୍‍ତି ଦାପ୍ରେ ବେମ୍ରି ଆତା ସର୍‌ଆର୍‌ ମାରି ଉରୁକ୍‍ସି ୱାଜି ଜିସୁଙ୍ଗୁଁ ମାଡ଼ିସ୍‍କିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ଜିସୁ ୱାନି ସିସୁରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ମିର୍‌ ଶାସ୍ତ୍ରୀରି ୱାଲେ ଇନିକା ମାଟାଦିଙ୍ଗ୍‍ମାଟା ଆଜି ସାଜି ମାର୍‌ଇଦେର୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ଲୋକାମାଣ୍‌କୁ ଅରେନ୍‍ ଜିସୁଙ୍ଗୁଁ ଉତର୍‌ ସିତାନ୍‌, “ଏ ଗୁରୁ, ନାନ୍ ନା ମାରିନ୍‍ତିଙ୍ଗ୍‍ ନି ଲାକ୍‌ତୁ ତାତାମାର୍‍ହା; ୱାନିଙ୍ଗ୍‌ ଉଣ୍ତ୍ରି ଗୁଲାଦୁବା ଆସ୍ତାମାନାତ୍‍; ");
INSERT INTO kfcp_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ଆମା ବାଡିଦୁ ଆପିତ୍‌ ଦୁବା ୱାନିଙ୍ଗ୍‌ ଆସ୍‍ନାତ୍‍, ୱାନିଙ୍ଗ୍‌ ଆଡ୍‍ଗି ଆର୍‍ପ୍‍ନାତ୍‍, ୱାନି ମକ୍‍ମତାନ୍‍ ପେପଲ୍‍ ସନାତ୍‌ ମାରି ୱାଣ୍ତ୍ରୁ ପାଲ୍‍କୁ କାତ୍ରେକିନାନ୍‍, ମାରି ୱାଡ୍ରୁ ୱାର୍‍ସି ସଲ୍‌ସିନାନ୍‌; ଆୟା ଦୁବା ପେର୍‍ଦେଙ୍ଗ୍‍ ଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ନି ସିସୁରିଙ୍ଗ୍‌ ୱେର୍‍ତା, ମାତର୍‌ ନି ସିସୁର୍‍ ଦୁବା ପେର୍‍ଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏତାର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଏ ଅବିସ୍‍ବାସ୍‍ତି କୁଟୁମ୍‌ ! ଏସୋଦିନ୍‍ ନାନ୍ ମି ୱାଲେ ମାନା ? ଏସୋଦିନ୍‍ ନାନ୍ ମି ପାଣି କିଜିମାନା ? ମାରିନ୍‍ତିଙ୍ଗ୍‍ ନା ଲାକ୍‌ତୁ ଆସ୍‌ସି ରାଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ଆବେଟ୍‌ ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଜିସୁ ଲାକ୍‌ତୁ ତାତାର୍‌ । ମାରି, ଜିସୁଙ୍ଗୁଁ ସୁଡ଼ୁତିଦାପ୍ରେ ଦୁବା ଆୟା କଡ଼ଦିଙ୍ଗ୍‍ ବୟ୍‌ଙ୍କାର୍‍ତାନ୍‍ ତିର୍‍ପିସି ଆସ୍‌ତାତ୍‌ ମାରି କଡ଼ ବୁମିଦୁ ଆର୍‍ଜି ୱେୟୁତାନ୍‍ ପେପଲ୍‍ ସପ୍‍ସି ଗୁର୍‍ଦେଙ୍ଗ୍‍ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ନାସ୍ତିୱାଲେ ଜିସୁ କଡ଼ଦି ବୁବାସିଙ୍ଗ୍‍ ୱେନ୍‌ବାତାନ୍‌, ଏସୋ ଦିନ୍‌ ଆତାତ୍‌ ଇୟାକା ଇୟାୱାଜା ଆତାମାନାତ୍‌ ? ୱାଣ୍ତ୍ରୁ ୱେର୍‌ତାନ୍‌, “ଇସ୍ରିରି ୱାଲେରାନ୍‍ନେ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“ଦୁବା ୱାନିଙ୍ଗ୍‌ ଡ଼େଇଦେଙ୍ଗ୍‍ ଏସଦେବା ସିସୁ ନି ଏର୍‌ତୁ ପୋକ୍‍ତାମାର୍‍ଆତ୍‍; ମାତର୍‌ ନିନ୍‌ ଜଦି କିଦେଙ୍ଗ୍‌ ଆଟ୍‌ନି, ଆତିଙ୍ଗ୍‌ ମା ଉଣ୍ତିଙ୍ଗ୍‌ ଦୟା କିଜି ମାଙ୍ଗିଁ ସାହାଜ୍ୟ କିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ଆବେଟ୍‌ ଜିସୁ ୱାନିଙ୍ଗ୍‌ ୱେର୍‌ତାନ୍‌, “ଇନିକା ଇର୍‍ଇ ? ଜଦି କିଦେଙ୍ଗ୍‌ ଆଟ୍‌ନି ! ଏନ୍‌ ବିସ୍‍ବାସ୍‍ କିନାନ୍‌ ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ୱିଜୁ ଆନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ଆୟାଦାପ୍ରେ କଡ଼ଦି ବୁବାସି ନାଣ୍ତ ଆଉଲି ଆଜି ଇର୍‌ଆନ୍‌, “ନାନ୍ ବିସ୍‍ବାସ୍‍ କିଜିନା, ନା ବିସ୍‍ବାସ୍‍ ନାଣ୍ତ କିଦେଙ୍ଗ୍‌ ନାଂଇ ସାହାଜ୍ୟ କିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ତାନେୱେନ୍‍କା ଲୋକ୍‌ଡର୍‌ ଅର୍‌ସେ ଉରୁକ୍‍ସି ୱାଜିନାର୍‍ ଇକା ସୁଡ଼ୁତାନ୍‌ନୋ ଜିସୁ ଆୟା ଦୁବାଦିଙ୍ଗ୍‌ ଆଦ୍‌ରିସି ଇର୍‌ଆନ୍‌, “ଏ ଗୁଲା ନି ବଇରା ଆତ୍ମା,” ନାନ୍ ନିଂଇ ଆଦେସ୍‌ ସିଜିନା, “ଇୟା କଡ଼ଦି ମାଣ୍‌କୁ ସହସି ସାଙ୍ଗ୍‍, ମାରି ଏସାଙ୍ଗ୍‍ବା ୱାନି ଲୋଇ ଡ଼ୁଗ୍‍ମା ।” ");
INSERT INTO kfcp_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ଆବେଟ୍‌ ଆୟା ଦୁବା ଆଉଲି ଆଜି କଡ଼ଦିଙ୍ଗ୍‌ ଆଡ୍‍ଗି ପେର୍‌ଜି ପୋକ୍‌ସି ୱାନି ମେନ୍ଧଲ୍‍ ଲୋଇରାନ୍‌ ସତା ସର୍‌ଆତ୍‌, ମାରି ଆୟା କଡ଼ ସାତିୱାଜା ଆତାନ୍‌, ଇୟାୱାଜାକି ଏସୋ ଲୋକ୍‌ଡର୍‌ ଇର୍ହାର୍‌, “ୱାଣ୍ତ୍‍ରୁ ସାତାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ମାତର୍‌ ଜିସୁ ୱାନି କିୟୁ ଆସ୍‌ତାନ୍‌ନୋ କଡ଼ଦିଙ୍ଗ୍‌ ନିକ୍‍ତାନ୍‍, ମାରି ୱାଣ୍ତ୍ରୁ ନିଙ୍ଗ୍‍ତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ମାରି, ଜିସୁ ଇଲୁ ଲୋଇ ୱାତାନ୍‌, ୱାନି ସିସୁରି ଜିସୁଙ୍ଗୁଁ ଏନ୍‌ ନେସେଇ ୱାଜା ୱେନ୍‌ବାତାର୍‌, “ମାପ୍‌ ଇନ୍‍ଦାନିଙ୍ଗ୍‍ ଆୟା ଦୁବାଦିଙ୍ଗ୍‌ ପେର୍‍ଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏତାପ୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ଜିସୁ ସିସୁରିଙ୍ଗ୍‌ ୱେର୍‌ତାନ୍‌, “ଇୟାୱାଜା ଦୁବା ଆବ୍‍କା ପାର୍‌ତାନା ଶକ୍ତିଦାଣ୍ତ୍‍ ପେର୍‍ଦେଙ୍ଗ୍‍ ଆଟ୍‍ତେଙ୍ଗ୍‍ ଆନାତ୍‌, ମାରି ଆଇ ଉପାୟ ସାରି ସିଲେତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ଜିସୁ ନି ୱାନି ସିସୁର୍‍ ଆୟା ବାଡି ଡ଼ିସ୍‌ସି ଗାଲିଲି ରାଜି ସାନ୍ଧିସିଜି ସରଆର୍‌ । ମାରି ଏମେ ବାଡିଦୁ ମାନାନ୍‌ ଏନ୍‍ବା ନେସ୍‍ମାପିର୍‍ ଇଜି ୱାଣ୍ତ୍ରୁ ବଦାକିଜିମାର୍‍ଆନ୍‍, ");
INSERT INTO kfcp_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ମାତର୍‌ ୱାନ୍‌ ୱାନି ସିସୁରିଙ୍ଗ୍‌ ଇୟା ମାଟା ସିଜି ଶିକ୍ଷା ସିତାନ୍‌ । ମାରି ୱାନ୍‌ ଇର୍‌ଆନ୍‌, “ନାନ୍ ଯେ ମନୁସ୍ୟପୁତ୍ର ଲୋକା କିୟୁଦୁ ସର୍ପେ ଆଦେଙ୍ଗ୍‌ ସଲ୍‌ସିନାନ୍‌, ମାରି ୱାରୁ ନାଂଇ ଡାକ୍‌ନାର୍‌, ମାରି ନାନୁ ସାନା ମାତର୍‌ ନାନୁ ମୁନେଟି ୱେନ୍‌କା ମାରିଡ଼େସି ଜିବନ୍‌ଆଜି ନିଙ୍ଗ୍‍ନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ମାତର୍‌ ସିସୁର୍‍ ଆୟା ମାଟା ବୁଝାଏତାର୍‍ ମାରି ୱାନିଙ୍ଗ୍‌ ୱେନ୍‍ବାଦେଙ୍ଗ୍‍ ତିଲାଜି ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ୱେନ୍‌କା ଜିସୁ ନି ୱାନି ସିସୁର୍‍ କପର୍‍ନାହୁମ୍‍ ନାର୍‍ତୁ ୱାତାର୍‌ । ୱାନ୍‌ ଇନ୍‌ଡ୍ର ଇତାନ୍‌ନୋ ସିସୁରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ମିର୍‌ ସାର୍‍ଦୁ ୱାନିୱାଲେ ଇନି ବିସୟତାନ୍ ୱାରଗିଜିସାଜି ମାର୍‌ଇଦେର୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ମାତର୍‌ ସିସୁର୍‌ ଆଲେତା ମାର୍‍ଆର୍‍, ଇରିଙ୍ଗ୍‌ ୱାରି ଲୋଇ ଏନ୍‌ ପେରିକାନ୍‌, ଇୟା ବିସୟତୁ ୱାର୍‌ ସାରିଦୁ ଲୋଇ ଲୋଇ ୱାର୍‌ଗିଜି ସାଜି ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ଆବେନ୍‌ ଜିସୁ ବାସ୍‌ତାନ୍‌ନୋ ବାର ଲୋକୁ ସିସୁରିଙ୍ଗ୍‌ କୁକ୍‍ତାନ୍‍ ମାରି ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଜଦି ଏନ୍‌ ପେରିକାନ୍‌ ଆଦେଙ୍ଗ୍‌ ବଦା କିନାନ୍‌, ୱାଣ୍ତ୍ରୁ ୱିଜେରେ ମାଣ୍‌କୁ ନିଜେଦିଙ୍ଗ୍‍ ନିସ୍‍ରିକା ଆପିନ୍‌ ମାରି ୱିଜେରି ସେବାକିନିକାନ୍‍ ଆପିନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ମାରି, ଜିସୁ ଉଣ୍ତ୍ରି ଇସ୍ରି କଡ଼ଦିଙ୍ଗ୍‌ ତାତାନ୍‍ନୋ ୱିଜେରି ଆଗ୍‌ଡ଼ି ନିଲ୍‍ପ୍‍ତାନ୍‍ ମାରି ୱାନିଙ୍ଗ୍‌ ଗାତୁ ବାସା କିଜି ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“ଏନ୍‍ବା ନା ଦର୍‍ତୁ ଇୟାୱାଜା ଇସ୍ରି କଡ଼ରିଙ୍ଗ୍‌ ମାଣ୍‌କୁ ଅରେନ୍‍ ୱାନିଙ୍ଗ୍‌ ମାନାନାର୍‌, ୱାଣ୍ତ୍ରୁ ନାଂଇ ମାନାନାର୍‌; ମାରି, ଏନ୍‍ବା ନାଂଇ ମାନାନାର୍‌, ୱାଣ୍ତ୍ରୁ ନାଂଇ ଲାଡ୍‌ କିଏନ୍‌, ମାତର୍‌ ନା ପୋକ୍‌ତିମାନି ମାଲିକ୍‌ତିଙ୍ଗ୍‌ ମାନାନାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ଯୋହନ ଜିସୁଙ୍ଗୁଁ ଇର୍‌ଆନ୍‌, “ଏ ଗୁରୁ, ମା ଦଲ୍‍ତୁ ସିଲି ଲୋକ୍‌ତିଙ୍ଗ୍‌ ନି ଦର୍‌ତାନ୍‌ ଦୁବା ପେର୍‍ନିକା ସୁଡ଼ୁତାପ୍‌, ମାରି ୱାଣ୍ତ୍ରୁ ମା ଦଲ୍‍ତୁ ସିଲେନ୍‌ ଇଜି ମାପ୍‌ ୱାନିଙ୍ଗ୍‌ ମନା କିତାପ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ମାତର୍‌ ଜିସୁ ଇର୍‌ଆନ୍‌, “ୱାନିଙ୍ଗ୍‌ ମନା କିମାଟ୍‌,” ମାତର୍‌ ନା ଦର୍‌ତି ସାକ୍ତିଦାନ୍‍ ପାଣି କିନାନ୍‌ ୱାଣ୍ତ୍ରୁ ଦାପେ ଦାପେ ନା ବିରଦ୍‌ତାନ୍‌ ଇନିକା ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆଟ୍‍ଏନ୍‍, ଇୟାୱାଜା ଲୋକୁ ଏନ୍‍ ସିଲେନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ମାତର୍‌ ଏନ୍‌ ମା ବିରୁଦ୍‌ ମାଟା ଇନ୍‌ଏନ୍‌, ୱାଣ୍ତ୍ରୁ ମା ନିଜେତି ଲୋକୁ । ");
INSERT INTO kfcp_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ମିର୍‌ କ୍ରିସ୍ତଦି ଲୋକୁ ଆତିମାନି ଉଣ୍ତିଙ୍ଗ୍‌, ଏନ୍‍ବା ନା ଉଣ୍ତିଙ୍ଗ୍‌ ଗିଲାସ୍‍ ଏର୍‌ ଉଣ୍ତେଙ୍ଗ୍‌ ସିନାନ୍‍, ୱାନ୍‌ ଏଣ୍ତେସ୍‌ କିଜିବା ନିଜେଦି ପୁରସ୍‌କାର୍‌ ପଇନିକା ଆରାଏନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","ଜିସୁ ମାରି ଇର୍‌ଆନ୍‌, ଏମେ ଲୋକୁ ନା ଲାକ୍‌ତୁ ବିସ୍‍ବାସ୍‍ କିଜିମାନି ଇସ୍ରି ଲୋକ୍‌ତି ମାଣ୍‌କୁ ଅରେନ୍‍ ୱାନିଦି ବିସ୍‌ବାସ୍‌ତୁ ବାଧା ସିନିକାନ୍‍ଆନାନ୍‍, ୱାନି କକ୍‍ଲାଦୁ ଉଣ୍ତ୍ରି ପେରି ଗୁଡ଼ୁବେଲି କାଲୁ ତର୍‌ସି ୱାନିଙ୍ଗ୍‌ ସାମ୍‌ଦୁର୍‌ତୁ ପୋକ୍‌ତିଙ୍ଗ୍‌ ନେଗେଣ୍ତ୍‍ ଆତାତ୍‌ମାନ୍ଧି । ");
INSERT INTO kfcp_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ମାରି, ଜଦି ମି ଉଣ୍ତ୍ରି କିୟୁ ମିଙ୍ଗିଁ ପାପ୍‍ତି ପାଣି କିବିସ୍‍କିଜିମାନାତ୍‍, ଆଦେଙ୍ଗ୍‌ ଆୟା କିୟୁଦିଙ୍ଗ୍‍ କୟଜ ପୋକ୍‌ତୁ; ଇରିଙ୍ଗ୍‌ ରୁଣ୍ତି କିକୁ ଅସ ନରକଦୁ, ୱିଜୁଦିନ୍‌ ସିସୁକାସ୍‍ସି ମାନି ନର୍କଦୁ ସନି ବାଦ୍‌ଲୁ ଗୁଲା ଆଜି ଜିବନ୍‌ ଆସ୍‌ସି ମୁସ୍‍କୁପୁରତୁ ସନିକା ମି ଉଣ୍ତିଙ୍ଗ୍‌ ନେଗେତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ଇରିଙ୍ଗ୍‌ ନର୍କଦୁ ୱାରିଙ୍ଗ୍‌ ଏମେ ପିଡ଼୍‍କୁ ତିନେ ଆକେଙ୍ଗ୍‍ ଏସାଙ୍ଗ୍‍ବା ସାଉ, ମାରି ଆୟା ସିସୁ ଏସ୍‍ସାଙ୍ଗ୍‍ବା ନାମ୍‍ଏତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ମାରି, ମି ପାଦାମ୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ମି ବିସ୍‍ବାସ୍‍ ନାଷ୍ଟୁ ଆନାତ୍‌, ଆଦେଙ୍ଗ୍‌ ଆୟା ପାଦାମ୍‌କାଙ୍ଗ୍‌ କୟଜ ପୋକ୍‌ତୁ, ରୁଣ୍ତି ପାଦାମ୍‌କାଙ୍ଗ୍‌ ଅର୍‌ସେ ନରକଦୁ ସନି ବାଦ୍‌ଲୁ ସଟା ଆଜି ଜିବନ୍‌ ଅସି ମୁସ୍‌କୁପୁର୍‌ତୁ ସନିକା ନେଗେତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ଇରିଙ୍ଗ୍‌ ନର୍କଦୁ ୱାରିଙ୍ଗ୍‌ ଏମେ ପିଡ଼୍‍କୁ ତିନେ ଆକେଙ୍ଗ୍‍ ଏସାଙ୍ଗ୍‍ବା ସାଉ, ମାରି ଆୟା ସିସୁ ଏସ୍‌କାଙ୍ଗ୍‌ବା ନାମ୍‍ଏତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ମାରି, ମି କାଣ୍‌ଗା ଉଣ୍ତିଙ୍ଗ୍‌ ଜଦି ମି ବିସ୍‍ବାସ୍‍ ନାସ୍ଟୁ ଆଜିନାତ୍‍, ଆଦେଙ୍ଗ୍‌ ଆୟା କାଣ୍‍ଗାଦିଙ୍ଗ୍‍ ଉନ୍ଦ୍‍ଜ ପୋକ୍‌ତୁ; ରୁଣ୍ତି କାଣୁକୁ ଅସ ନରକଦୁ ପୋକ୍‌ନି ବାଦ୍‌ଲୁ ଉଣ୍ତ୍ରି କାଣ୍‌ଗା ମାନ୍‌ଜି ମାପୁରୁଦି ପୁର୍‌ତୁ ସନିକା ମିଙ୍ଗିଁ ନେଗେତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ଇରିଙ୍ଗ୍‌ ନର୍କଦୁ ୱାରିଙ୍ଗ୍‌ ଏମେ ପିଡ଼୍‍କୁ ତିନେ ଏସାଙ୍ଗ୍‍ବା ସାଉ । ମାରି, ଆୟା ସିସୁ ଏସ୍‌କାଙ୍ଗ୍‌ବା ନାମ୍‍ଏତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","ପୁଜାସିନି ସର୍‌ତାନ୍‌ ନର୍‌ନି ୱାଜା ୱିଜେରେ ସିସୁଦାନ୍‌ ନରାଇ ଆନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","ସରୁ ଉଣ୍ତ୍ରି ନେଗ୍ରି ଜିନିସ୍‌, ମାତର୍‌ ସର୍‍ ଜଦି କାର୍‍ୟା ଆନିକା ଗୁଣୁ ଆରାକିନାତ୍‍, ତାନେଙ୍ଗ୍‌ ମାରିଡ଼େସି ଏଣ୍ତେସ୍‌ କାରିୟା କିଦେଙ୍ଗ୍‌ ଆଟ୍‌ନିଦେର୍‌ ? “ଆଦେଙ୍ଗ୍‌ ମିର୍‌ ସର୍‍ ୱାଜା ନେଗି ଗୁଣୁ ଆସ୍‌ତୁ ମାରି ୱିଜେରି ୱାଲେ ସାନ୍ତିଦାଣ୍ତ୍‍ ମାନ୍‌ଡ଼୍ରୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ଜିସୁ ଆୟା ବାଡିଦାଣ୍ତ୍‍ ସର୍‌ଆନ୍‌ ନୋ ଜିହୁଦା ଇତିରାଜିଦୁ ସର୍‌ଆନ୍‌ ମାରି ଜର୍ଦନ ଗାଡା ନାଆଜି ୱାତାନ୍‌; ମାରି ନାଣ୍ତ ଲୋକୁ ମାରିଡ଼େସି ଜିସୁ ଲାକ୍‌ତୁ ଉଣ୍ତାତାର୍‍, ଜିସୁ ଆଗ୍‍ଡ଼ିରି ୱାଜାନେ ୱାରିଙ୍ଗ୍‌ ସିକିୟା ସିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ଏସୋ ଲୋକୁ ପାରୁସିର୍‌ ଜିସୁ ଲାକ୍‌ତୁ ୱାଜି ୱାନିଙ୍ଗ୍‌ ପରିକା କିଜି ୱେନ୍‌ବାତାର୍‌, “ନିଜେଦି ଆଡ଼ିଦିଙ୍ଗ୍‍ ଡ଼ିସ୍‍ତେଙ୍ଗ୍‍ଁ ଇନିକା ମେମାରି ତରଟାନ୍‍ ମା ନିୟମ୍‌ ମାନାତ୍‌ ନୋ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଉତର୍‌ ସିତାନ୍‌, “ମୋସା ମିଙ୍ଗିଁ ଇନି ମାଟା ୱେର୍‍ତା ମାନାନ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ୱାର୍‌ ୱେର୍‌ତାର୍‌, “ଡ଼ିସ୍‌ନି ଆକୁ ରାସ୍‌ସି ଆଇମାଦିଙ୍ଗ୍‍ ଡ଼ିସ୍‍ତେଙ୍ଗ୍‍ଁ ମୋସା, ୱେର୍‍ତା ମାନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମି ଜିବନ୍‍ତି ଆଟୁୱାଦିଙ୍ଗ୍‍ ସୁଡ଼୍‌ଜି ମୋସା ମିଙ୍ଗିଁ ଇୟାୱାଜା ବିଦି ରାସ୍ତା ଇଟ୍‌ଟା ମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ମାତର୍‌ ଏଣ୍ତେସ୍‌ ସାସ୍ତ୍ର ଇନାତ୍‍, ଆୟାୱାଜା ତିଆର୍‌ ଆନି ଆଗ୍‍ଡ଼ିରାନ୍‍ ମାପୁରୁ ୱାରିଙ୍ଗ୍‌ ମେମାରି ନି ଆଇମା କିଜି ତିଆର୍‌ କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ଆଦେଙ୍ଗ୍‌ ଅରେନ୍‍ ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ମେମାର୍‌ଏନ୍‌ ନିଜେଦି ବୁବାୟାୟେଙ୍ଗ୍‌ ଡ଼ିସ୍‌ସି ନିଜେଦି ଆଡ଼୍‌ସି ୱାଲେ ତେବାନାନ୍‌ ମାରି ଆୟା ରିଏର୍‌ ଅରେନ୍‌ଆନାର୍‍, ");
INSERT INTO kfcp_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ୱାର୍‌ ରିଏର୍‌ ଉଣ୍ତ୍ରେନେ ଆନାର୍‌ । ମାରି ୱାର୍‌ ରିଏର୍‌ ଆଏର୍‌, ମାତର୍‌ ଉଣ୍ତ୍ରେନେ ଆନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ମାପୁରୁ ଆମାକା ମିସାକିତା ମାନାନ୍‌, ଆକା ଲୋକୁ ୱାରିଙ୍ଗ୍‌ ୱେର୍‌ଏ କିମାକିର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ୱେନ୍‌କା ସିସୁର୍‍ ଇନ୍‌ଡ୍ର ଡ଼େସି ୱାତି ୱେନ୍‌କା ଜିସୁଙ୍ଗୁଁ ଇୟା ବିସୟତୁ ମାରିଡ଼େସି ୱେନ୍‌ବାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ଆବେନ୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଏନ୍‌ଆପିନ୍‌ ନିଜେଦି ଆଡ଼ିଦିଙ୍ଗ୍‍ ଡ଼ିସ୍‍ନାନ୍‍ ନୋ ମାରି ଉନ୍‍ଣ୍ତ୍ରିତାନିଙ୍ଗ୍‍ ପେଡ଼ି ଆନାନ୍‌, ଆୟା ମେମାରି ଆଡ଼ିସ୍‍ ବିରଦ୍‌ତାନ୍‌ ଦାରିପାଣି କିନାନ୍‍; ");
INSERT INTO kfcp_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ମାରି, ଜଦି ଏମେ ଆଇମା ନିଜେତି କନ୍‍ଲିଙ୍ଗ୍‍ ଡ଼ିସ୍‍ସି ମାରି ଅରେନ୍‌ ମେମାର୍‌ଏନ୍‌ତିଙ୍ଗ୍‍ ପେଡ଼ି ଆନାତ୍‌, ଆୟା ଆଇମା ବା ଦାରି ପାପ୍‌ତୁ ଦସ୍‌ ଆନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ଜିସୁ ଏଣ୍ତେସ୍‌ ଇସ୍ରି କଡ଼ରିଙ୍ଗ୍‌ କିୟୁ ଇଡ୍‌ଜି ଆର୍ସିବାଦ୍‌ କିନି ଉଣ୍ତିଙ୍ଗ୍‌, ଲୋକୁ ଇସ୍ରି କଡ଼ରିଙ୍ଗ୍‌ ଜିସୁ ଲାକ୍‌ତୁ ତାତାର୍; ମାତର୍‌ ସିସୁର୍‍ ଆୟା ଲୋକାଙ୍ଗ୍‌ ଆଦ୍‌ରିସ୍‌ତେଙ୍ଗ୍‍ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ସିସୁର୍‍ ଲୋକାଙ୍ଗ୍‌ ଲାଗାନିକା ସୁଡ଼୍‍ଜି, ଜିସୁ ସିସୁରି ମୁସ୍‌କୁ ରିସା ଆତାନ୍‌ନୋ ଇର୍ହାନ୍‌, “ଇସ୍ରି କଡ଼ରିଙ୍ଗ୍‌ ନା ଲାକ୍‌ତୁ ୱାଦେଙ୍ଗ୍‌ ସିଦୁ, ୱାରିଙ୍ଗ୍‌ ମାନା କିମାଟ୍‌; ଏନ୍ଧା ଇରିଙ୍ଗ୍‌ ମାପୁରୁତି ରାଜି ଇୟାୱାଜା ଇସ୍ରି କଡ଼ରିଦି । ");
INSERT INTO kfcp_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ଏନ୍‌ ଜଦି ଇସ୍ରିକଡ଼ୱାଜା ମାପୁରୁଦି ରାଜିଦିଙ୍ଗ୍‍ ଆସ୍‍ଏନ୍‍, ୱାଣ୍ତ୍ରୁ ଏଣ୍ତେସ୍‌ କିଜିବା ଆବେନ୍‌ ଡ଼ୁଗୁଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ଇୟା ୱେନ୍‌କା ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଗାତୁ ଆସ୍‌ତାନ୍‌ନୋ କଡ଼ରି ମୁସ୍‌କୁ କିୟୁ ଇଡ୍‌ଜି କଡ଼ରିଙ୍ଗ୍‌ ଆର୍ସିବାଦ୍‌ କିତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ଜିସୁ ମାରିଡ଼େସି ସନିୱାଲେ ଅରେନ୍‍ ଲୋକୁ ଉରୁକ୍‍ସି ୱାଜି ଜିସୁଦି ଆଗ୍‌ଡ଼ି ମେଣ୍ତେଙ୍ଗ୍‌ ଗଟ୍‍କିଜି ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ଏ ସତ୍‍ ଗୁରୁ, ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜିଇ ଜିବନ୍‌ ପୟ୍‌ନି ଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ଇନିକା କିଦେଙ୍ଗ୍‌ ଆନାତ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ଆବେନୁ ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନାଙ୍ଗିଁ ନେଗିକାନ୍‍ ଇଜି ଇନିଦାନିଙ୍ଗ୍‌ ଇଜିନି ?” ମାରି ମାପୁରୁଙ୍ଗୁଁ ଡ଼ିସ୍‍ତିଙ୍ଗ୍, “ମାରି ଆଇକାନ୍‍ ଏନ୍‌ବା ସତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ନିନ୍‌ ସାସ୍ତ୍ରଦି ନିୟମ୍‌କୁ ୱିଜୁ ନେସ୍ତିମାନି, ଲୋକାଙ୍ଗ୍‌ ସାୟାମାର୍‌ଗା ଡାକ୍‌ମାଟ୍‌, ଦାରିପାଣି କିମାଟ୍‌, ଡଙ୍ଗାଁ କିମାଟ୍‌, ଏ ବିରଦ୍‌ତାନ୍‌ ମିସ୍‌ ମାଟା ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆଏତ୍‍, ଲୋକାଙ୍ଗ୍‌ ଆସା କିମାଟ୍‌, ନିଜେଦି ବୁବା ୟାୟାଏଙ୍ଗ୍‍ ମାନାଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ଆୟା ମାଜନ୍‌ ଲୋକୁ ଇର୍‌ଆନ୍‌, “ଏ ଗୁରୁ, ଇୟାୱିଜୁ ନାନ୍ ମୁରୁଲିୱାଲେରାନ୍‍ ଇୟାୱିଜୁ ନିୟମ୍‌ ମାନାଜି ୱାଜିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ଜିସୁ ୱାନି ତରିଣ୍ତ୍‍ ସୁଡ଼୍‌ଜି ୱାନିଙ୍ଗ୍‌ ଲାଡ୍‍କିଜି ଇର୍‌ଆନ୍‌, “ନି ଉଣ୍ତ୍ରିବିସୟ ଉଣାମାନାତ୍‌, ସାଙ୍ଗ୍‍ ନି ୱିଜୁ ଦନ୍‌ ସମ୍ପତ୍ତି ପର୍‍ସୋ କାକୁର୍ତି ଲୋକାଙ୍ଗ୍‌ ଡାବୁଙ୍ଗୁଁ ବାଟାକିଜି ସିଆ, ଆବେଟ୍‌ ନିନ୍‌ ମୁସ୍‌କୁପୁର୍‌ତି ଦନ୍‍ ପଇନି; ମାରି, ୱାଜି ନା ୱେନ୍‌କା ବୁଲାଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ଜିସୁଦି ଇୟା ମାଟା ୱେର୍‌ଆନ୍‌ ନୋ ଆୟା ଲୋକ୍‌ତି ମକମ୍‌ ୱାର୍‌ତା ସର୍‌ଆତ୍‌ ମାରି ୱାନ୍‌ ଦୁଃକ୍‍ ଆଜି ଇନ୍‌ଡ୍ର ସର୍‌ଆନ୍‌, ଇରିଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ ନାଣ୍ତ ଦନ୍‍ ସମ୍ପତ୍ତି ମାର୍‌ଆତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ଜିସୁ ସାରିବେଡ଼୍‍ତି ସୁଡ଼ୁତାନ୍‌ ନୋ ନିଜେଦି ସିସୁରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଏମେ ଲୋକାଙ୍ଗ୍‌ ନାଣ୍ତ ଦନ୍‍ ମାନାତ୍‌, ୱାରୁ ବେସି କାସ୍ଟୁଦାନ୍‍ ମାପୁରୁତି ରାଜିଦୁ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଆଟ୍‍ନାର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ଜିସୁଦି ମାଟା ୱେନ୍‌ଜି ସିସୁର୍‍ କାବାଆତା ସର୍‌ଆର୍‌ । ମାତର୍‌ ଜିସୁ ମାରିଡ଼େସି ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଏ ନା କଡ଼ର୍‌, ମାପୁରୁଦି ରାଜିଦୁ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ସତେନେ କାସ୍ଟୁ ! ");
INSERT INTO kfcp_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ଉଣ୍ତ୍ରି ସୁଜିଦି ବର୍‌ ସିଜି ଉଟ୍‌ ଡ଼ୁଗୁନିକା ଉସାସ୍‌, ମାତର୍‌ ଅରେନ୍‍ ମାଜନ୍‌ ଲୋକୁ ମାପୁରୁଦି ରାଜିଦୁ ସନିକା କାସ୍ଟୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ଇୟା ମାଟା ୱେନ୍‌ଜି ସିସୁର୍‍ ନାଣ୍ତ କାବା ଆତାର୍‌ ନୋ ୱାରିୱାରି ଲୋଇ ୱାର୍‌ଗିଜି ସାତାର୍‌, “ଆର୍‌ତିଙ୍ଗ୍‌ ଏନ୍‌ ରକିୟା ପଇଦେଙ୍ଗ୍‍ ଆଟ୍‍ନାନ୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ଜିସୁ ସିସୁରିଙ୍ଗ୍‌ ସାଡ଼୍‌କୁ ସାଡ଼୍‌କୁ ସୁଡ଼୍‍ଜି ଇର୍ହାନ୍‌, “ଇକା ଲୋକାଦି ଉଣ୍ତିଙ୍ଗ୍‌ ଆଟ୍‌ୱା, ମାତର୍‌ ମାପୁରୁଦିଙ୍ଗ୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ଉସାସ୍‌, ଇରିଙ୍ଗ୍‌ ମାପୁରୁ ୱିଜୁ କିଦେଙ୍ଗ୍‍ ଆଟ୍‍ନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ଇୟା ମାଟା ୱେନ୍‌ଜି ପିତର୍‌ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାନ୍‌, “ସୁଡ଼୍‌ଆ, ମାପ୍‌ ୱିଜୁ ଡ଼ିସ୍‍ସି ନି ୱେନ୍‍କା ୱାତା ମାନାପ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ଜିସୁ ଇର୍ହାନ୍‌, “ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା,” ଏମେ ଲୋକୁ ନା ୱେନ୍‌କା ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ “ମାରି ନା ସୁସମାଚାର୍‌ ୱେର୍‍ନି ଉଣ୍ତିଙ୍ଗ୍‌ ଏନ୍‍ବା ଇଲୁ, ତଡ଼ାନ୍‌ତିଙ୍ଗ୍‌ ନି ତାଙ୍ଗିଁ, ବୁବା ନି ୟାୟେଙ୍ଗ୍‌, କଡ଼କକ୍ରାରିଙ୍ଗ୍‌ ମାରି ବୁମିବାଡ଼ା ଡ଼ିସ୍‌ତାମାନାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ମାରି ଇଲେଇ ଇୟା ଜଗ୍‌ତୁ ଦାପେ ଦାପେନେ ଶହେ ଗୁଣୁତାନ୍‍ ଇଲୁ, ତଡ଼ାନ୍‍, ତାଙ୍ଗିଁ, ୟାୟା, ମାରିନ୍‌, ଗାଡ଼ି, ମାରି ଭୁମିବାଡ଼ିଦି ୱାଲେ କାସ୍ଟୁ ବା ପଇନାନ୍‍ । ମାରି ୱାନି ଦିନ୍‌ତୁ ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜ୍‍ଇ ଜିବନ୍‌ ପଇନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ମାତର୍‌ ଇଲେଇ ଏମେ ଲୋକ୍‌ଡର୍‌ ଆଗ୍‌ଡ଼ି ମାନାର୍‌, ୱାର୍‌ ୱେନ୍‌କା ଆନାର୍‌, ମାରି ୱେନ୍‌କା ମାନି ଲୋକ୍‌ଡର୍‌ ଆଗ୍‌ଡ଼ି ଆନାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ଇୟା ୱେନ୍‌କା ୱାର୍‌ ଜିରୁସାଲାମ୍‍ତୁ ସନିୱାଲେ ସାରିଦୁ ମାରାଆନ୍‍ ମାରି ଜିସୁ ସିସୁରି ଆଗ୍‌ଡ଼ି ଆଗ୍‌ଡ଼ି ସଲ୍‍ସି ମାର୍‌ଆନ୍‌, ମାରି ଶିଶୁର୍‌ କାବାଆତା ସର୍‍ଆର୍‍, ମାରି ୱାନି ୱେନ୍‌କା ବୁଲାଜି ମାର୍‍ଇ ଲୋକ୍‌ଡର୍‌ ତିଲାତାସର୍‍ଆର୍‍ । ଜିସୁ ମାରିଡ଼େସି ବାର ଲୋକାଙ୍ଗ୍‌ କୁକ୍‍ସି, ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ଇନିକା ଇନିକା ୱିଜୁ ଗଟେଆଦେଙ୍ଗ୍‍ ସଲ୍‍ସିନାତ୍‍, ଆୟା ବିସୟତାନ୍ ୱିଜୁ ସିସୁରିଙ୍ଗ୍‌ ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ଜିସୁ ଇର୍ହାନ୍‌, “ୱେନ୍‌ଡ୍ରୁ, ମାପ୍‌ ଜିରୁସାଲମ୍‌ତୁ ସଲ୍‍ସିନାପ୍‍; ଆବେ ମନୁଷ୍ୟପୁତ୍ର ଜେ ନାନ୍ ପେରି ପେରି ଜାଜକ ମାରି ସାସ୍ତ୍ରିରି କିୟୁଦୁ ସେର୍‍ପାନା, ମାରି ୱାରୁ ନାଂଇ ସାନି ଦଣ୍ଡ୍‌ ସିନି ଉଣ୍ତିଙ୍ଗ୍‌ ଆଇ ଅଣଜିହୁଦି ଲୋକ୍‌ତି କିୟୁଦୁ ସର୍ପେ କିଜି ସିନାର୍‍, ନାଂଇ ବିଚାର୍‍ କିଜି ଡାକ୍‌ନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ମନୁଷ୍ୟପୁତ୍ରଦିଙ୍ଗ୍‍ ଜେ ନାନ୍ ୱାର୍‌ ନାଂଇ ସେମାର୍‌ କିନାର୍‍, ନା ମୁସ୍‌କୁ ପୁସ୍‍ନାର୍‍, ନାଂଇ କୋର୍‌ଡାଦାଣ୍ତ୍‍ ଡାକ୍‌ନାର୍‌ ମାରି ନାଂଇ ସାପିସ୍‌ କିନାର୍‍, ମାରି ମୁନେଟି ୱେନ୍‌କା ୱାନ୍‌ ମାରିଡ଼େସି ଜିବନ୍‌ଆଜି ନିଙ୍ଗିଁନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ଜେବଦଦି ମାରିସିର୍‌ ଯାକୁବ ନି ଯୋହନ ଜିସୁ ଲାକ୍‌ତୁ ୱାତା ରୋ ଇର୍ହାର୍‌, “ଏ ଗୁରୁ,” ମା ଉଣ୍ତିଙ୍ଗ୍‌ ଇନିକା ବା କିଆ, “ମାପ୍‌ ନିବାନୁ ଇନିକା ଲସ୍‍ନାପ୍‍, ଆୟାକା ମା ଉଣ୍ତିଙ୍ଗ୍‌ କିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ନାନ୍, ମି ଉଣ୍ତିଙ୍ଗ୍‌ ଇନିକା କିନା ଇଜି ମିର୍‌ ଇନିକା ବଦା କିଜିନିଦେର୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ୱାରୁ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାର୍‌, “ମାପୁରୁତି ରାଜିଦୁ ଏସିୱାଲେ ନିନ୍‌ ମହିମାଦି ରାଜାଗଦିଦୁ ବାସ୍‌ନି ମା ମାଣ୍‌କୁ ଅରେନ୍‍ ଲୋକ୍‌ତିଙ୍ଗ୍‌ ନି ଉଣେରି କିୟୁ ତରିନ୍‍ ମାରି ଅରେନ୍‍ ଲୋକ୍‌ତିଙ୍ଗ୍‌ ନି ଡେବ୍‍ରିକିୟୁ ତରିନ୍‍ ବାସ୍ତେଙ୍ଗ୍‍, ମାଙ୍ଗିଁ ଇୟା ବର୍‌ ସିଦା ।” ");
INSERT INTO kfcp_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ମାତର୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ମିର୍‌ ଇନିକା ଲସ୍‌ସିନିଦେର୍‌, ଆୟାକା ମିର୍‌ ନେସ୍‌ତେଙ୍ଗ୍‌ କି ବୁଝାଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏଜିନିଦେର୍‍ । ନାନ୍ ଏମେ ଦୁଃକୁ ବୋଗାଜି ଉଣ୍ତେଙ୍ଗ୍‌ ସନା, ଆୟା ଦୁଃକୁତିଙ୍ଗ୍‌ ବୋଗାଜି ଉଣ୍ତେଙ୍ଗ୍‌ ଆଟ୍‌ନିଦେର୍‌ ନୋ ? ନାନ୍ ଏମେ ସାନି ଡୁବନ୍‌ତୁ ଡୁବନ୍‌ ଅନା ମିର୍‌ ଇନିକା ଆୟା ଡୁବନ୍‌ତୁ ଅତେଙ୍ଗ୍‌ ଆଟ୍‌ନିଦେର୍‌ ନୋ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାର୍‌, “ହୁଁ ମାପ୍‌ କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାପ୍‍ ।” ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ନାନ୍ ଏମେ ଦୁଃକୁ ବୋଗାନା, “ମିର୍‌ ଆବେନୁ ଭୋଗାନିଦେର୍‍, ମାରି ନାନ୍ ଏମେ ସାନି ଡୁବନ୍‌ତୁ ଡୁବନ୍‌ ଅସିନା, ମିର୍‌ ନା ୱାଜା ଆବେନୁ ଡୁବନ୍‌ ଅତେଙ୍ଗ୍‌ ଆଟ୍‌ନିଦେର୍‌; ");
INSERT INTO kfcp_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ମାତର୍‌ ନା ଉଣେରି କିୟୁ ତରିଣ୍ତ୍‍ ନି ଡେବିରି କିୟୁ ତରିଣ୍ତ୍‍ ବାସିସ୍‍ କିଦେଙ୍ଗ୍‌ ନା ଅଦିକାର୍ ବିସୟ୍‌ ସିଲେତ୍‌; ମାତର୍‌ ଏମେ ଲୋକ୍‌ତି ଉଣ୍ତିଙ୍ଗ୍‌ ମା ବୁବା ଆୟା ବାଡି ତିଆର୍‌ କିତା ଇଟ୍‌ତାମାନାନ୍‌, ଆୟା ବାଡିଦୁ ୱାର୍‌ ବାସ୍‍ନାର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ଇୟା ମାଟା ୱେର୍‌ଆର୍‌ ନୋ ଆଇ ଦାସ୍‌ଲୋକ୍‌ ସିସୁର୍‌ ଜାକୁବ ନି ଯୋହନତି ମୁସ୍‌କୁ ରିସା ଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଲାକ୍‌ତୁ କୁକ୍‍ତାନ୍‍ନୋ ଇର୍‌ଆନ୍‌, “ଏମେ ଲୋକୁ ଅଣଜିହୁଦି ମାଣ୍‌କୁ ଶାସନ କିନି ଲୋକାୱାଜା ୱେଙ୍ଗ୍‌ଁନାର୍‌, ୱାର୍‌ ୱାରି ମୁସ୍‌କୁ ଶାସନ୍‍ କିଜିନାର୍‍ ମାରି ୱାରି ରାଜାର୍‌ ୱାରି ମୁସ୍‌କୁ ଶାସନ୍‍ କିଜିନାର୍‍, ମିର୍‌ ଇୟାକା ନେସ୍‌ତିମାନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ମାତର୍‌ ମି ମାନୁ ଆୟାୱାଜା ସିଲେତ୍‌; ମାତର୍‌ ମି ମାଣ୍‌କୁ ଏନ୍‌ ଜଦି ପେରିକାନ୍‌ ଆଦେଙ୍ଗ୍‌ ବଦା କିନାନ୍‍, ୱାଣ୍ତ୍‌ରୁ ମି ସେବାକିନିକାନ୍‍ ଆପିନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ମାରି ମି ମାଣ୍‌କୁ ଏନ୍‌ଆପିନ୍‌ ପେରିକାନ୍‌ ଆଦେଙ୍ଗ୍‌ ବଦାକିନାନ୍‌, ୱାଣ୍ତ୍‍ରୁ ୱିଜେରି ଗତିମୁରୁଲି ଆପିନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ଇରିଙ୍ଗ୍‌ ମନୁସ୍ୟପୁତ୍ର ଜେ ନାନ୍ ସେବା ପ‍ଇଦେଙ୍ଗ୍‌ ରେଏ, ମାତର୍‌ ସେବା କିଦେଙ୍ଗ୍‌ ୱାତାମାନା ମାରି ୱିଜୁ ଲୋକାଙ୍ଗ୍‌ ରକିୟା କିିଜି ନିଜେଦି ଜିବନ୍‌ ସିଦେଙ୍ଗ୍‍ ଇଜି ୱାତାମାନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ଜିସୁ ମାରି ୱାନି ସିସୁର୍‍ ଜିରିହୋ ଗାଡ଼୍‌ତୁ ୱାତାର୍‌, ମାରି ୱାର୍‌ ନାଣ୍ତଲୋକୁ ୱାଲେ ସଲ୍‍ସି ମାର୍‌ଆର୍‌, ଯିରିହୋତି ଆୟା ଗାଡ଼୍‌ ଡ଼ିସ୍‍ସି ସନିୱାଲେ, ଟିମାୟଦି ମାରିନ୍‌ ବାର୍ଟୀମୟ ଦରତିକାନ୍‍ ଅରେନ୍‍ କାଣା ଭିକାରି ସାରି ଲାକ୍‌ତୁ ବାସ୍ତା ମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ୱାନ୍‌ ଜେ ନାଜରିତିୟ ଜିସୁ, ଆୟା ସାରିଦୁ ସଲ୍‌ସିନାନ୍‌ ଇଜି ୱେନ୍‌ଜି ଆୟା କାଣା ବିକାରି ନାଣ୍ତ୍‍ ଆଉଲି ଆଜି ଇର୍‌ଆନ୍‌, “ଏ ଦାଉଦତି ମାରିନ୍‌ ଜିସୁ, ନାଙ୍ଗିଁ ଦୟା କିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ଆବେନୁ ଏସଲୋକ୍‌ ୱାନିଙ୍ଗ୍‌ ଆଲେଜ ମାନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଇଜି ଆଦିରିସ୍‌ତେଙ୍ଗ୍‍ ଆସ୍‌ତାର୍‌, ମାତର୍‌ ୱାଣ୍ତ୍ରୁ ମାରି ନାଣ୍ତଦାଣ୍ତ୍‍ ଆଉଲି ଆଜି ଇର୍‌ଆନ୍‌, “ଏ ଦାଉଦତି ମାରିନ୍‌, ନାଙ୍ଗିଁ ଅଡ଼ପ୍‍ ଦୟା କିଆ !” ");
INSERT INTO kfcp_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ଆବେନୁ ଜିସୁ ତେବାତାନ୍‍ ନୋ ଇର୍‌ଆନ୍‌, “ୱାନିଙ୍ଗ୍‌ କୁକ୍‍ତୁ ।” ୱାର୍‌ ଆୟା କାଣା ଭିକାରିତିଙ୍ଗ୍‍ କୁକ୍‍ସି ଇର୍‌ଆନ୍‌, “ସାସ୍‌ ଆସ୍‌ଆ, ନିଂଆ, ଜିସୁ ନିଂଇ କୁକ୍‍ସିନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ଆବେଟ୍‌ ୱାଣ୍ତ୍ରୁ ନିଜେଦି ସାଦର୍‌ ପୋକ୍‌ତାନ୍‌ ନୋ ନିଂଇଜି ଜିସୁ ଲାକ୍‌ତୁ ୱାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ନାନ୍ ନି ଉଣ୍ତିଙ୍ଗ୍‌ ଇନିକା କିନା ଇଜି ନିନୁ ବଦା କିଜିନି ?” ଆୟା କାଣା ଲୋକୁ ଜିସୁଙ୍ଗୁଁ ଇର୍‌ଆନ୍‌, “ଏ ଗୁରୁ, ନାନ୍ ଏଣ୍ତେସ୍‌ ସୁଡ଼ୁଦେଙ୍ଗ୍‌ ଆଟ୍‍ନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ସାଙ୍ଗ୍‍ଆ, ନି ବିସ୍‌ବାସ୍‌ ନିଙ୍ଗିଁ ନେଗେନ୍‍ କିତାମାନାତ୍‌ ।” ଆୟା ଦାପ୍ରେନେ କାଣା ୱାନି ସୁଡ଼ୁନି ସାକ୍ତି ପ‍ଇତାନ୍‌ ନୋ ସାରିଦୁ ଜିସୁ ୱେନ୍‌କା ୱେନ୍‌କା ବୁଲାଦେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ଏସିୱାଲେ ଜିସୁ ମାରି ୱାନି ସିସୁର୍‍ ଜିରୁସାଲମ୍‍ତି ଲାକ୍‌ତୁ ମାନି ଜୀତ ଗରନ୍‍ତି ଲାକ୍‌ତୁରି ବେତ୍‍ପାଗି ନି ବେତନିୟା ଇନି ନାର୍‍ତୁ ଇତାର୍‌, ନାସ୍ତିୱାଲେ ଜିସୁ ୱାନି ସିସୁରି ଲୋଇ ରିଏରିଙ୍ଗ୍‍ ଇୟା ମାଟା ୱେର୍‌ସି ପୋକ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“ମି ଆଗ୍‌ଡ଼ି ମାନି ଆୟା ନାଟ ସାନ୍‌ଡ୍ରୁ; ଆବେ ଇତି ଦାପ୍ରେ, ଆମା ମୁସ୍‌କୁ ଏନ୍‍ବା ବାସ୍‍ଇ ମାନି ଉଣ୍ତ୍ରି ଗଦପିଲାଦିଙ୍ଗ୍‍ ତର୍‍ନି ମାନିକା ସୁଡ଼୍‍ନିଦେର୍‍, ଆୟା ଗଦପିଲାଦିଙ୍ଗ୍‍ କୁତ୍‍ସ ନା ଲାକ୍‌ତୁ ତାଗାଟ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ମାରି, ଏନ୍‌ ଜଦି ମିଙ୍ଗିଁ ଏନ୍ଦା କୁତ୍‍ସି ଅସିନିଦେର୍‍ ଇଜି ୱେନ୍‍ବାନାନ୍‌, ଇନିଦେର୍‌, ପ୍ରବୁଙ୍ଗ୍‌ ଦର୍‌କାର୍‌ ମାନାତ୍‌, ମାରି ୱାନ୍‌ ଆୟା ଗଦପିଲାଦିଙ୍ଗ୍‍ ମାରିଡ଼େସି ୱେଡ଼ା କିଏନ୍‍ଣ୍ତା ବେନୁ ପୋକ୍‌ନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ସିସୁର୍‍ ଆୟା ନାର୍‍ତୁ ସରାରୋ ଉଣ୍ତ୍ରି ଇଲୁ ସେର୍‍ଲା ଲାକ୍‌ତୁ ଆତ୍‌ରେ ଦୁୱାର୍‍ତୁ ଉଣ୍ତ୍ରି ଗଦପିଲାଦିଙ୍ଗ୍‍ ତର୍‍ତି ମାର୍‌ଇକା ସୁଡ଼ୁତାରୋ ଗଦଦିଙ୍ଗ୍‌ କୁତ୍‍ତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ଆବେନ୍‌ ଆୟା ଲାକ୍‌ତୁ ନିରିଇ ମାନି ଲୋକା ମାଣ୍‌କୁ ଏସ ଲୋକୁ ୱାରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, “ଗଦପିଲାଦିଙ୍ଗ୍‍ ଇନିକା କିଜିନିଦେର୍‍, ଗଦପିଲାଦିଙ୍ଗ୍‍ ଇନ୍‍ଦାନିଙ୍ଗ୍‍ କୁତ୍‍ସିନିଦେର୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ଜିସୁ ଇନିକା ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଇର୍‌ଆମାର୍‌ଆନ୍‌, ସିସୁର୍‌ ଆୟାୱାଜା ୱାରିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, ତାନେ ୱେନ୍‌କା ଲୋକୁ ୱାନିକାଙ୍ଗ୍‌ ଡ଼ିସ୍‍ସି ସିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ସିସୁର୍‍ ଆୟା ଗଦପିଲାଦିଙ୍ଗ୍‍ ଜିସୁ ଲାକ୍‌ତୁ ତାତାର୍‌ ରୋ ମାରି ଗଦଦି ମୁଟାମ୍‌ ମୁସ୍‌କୁ ନିଜେ ନିଜେଦି ୱାତିଙ୍ଗ୍‍ ପାର୍‍ସି ସିତାର୍‍, ମାରି ଜିସୁ ଆୟା ଗଦ ମୁସ୍‌କୁ ବାସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ମାରି ଏସଲୋକ୍‌ ଜିସୁଙ୍ଗୁଁ ମାନାଜି ଇଜି ନିଜେ ନିଜେଦି ୱାତିଙ୍ଗ୍‍ ରାସ୍ତାଦୁ ପାର୍‍ସି ସିତାର୍‍ ମାରି ଏସୋଲୋକ୍‍ ମାରାତି ରଡେଙ୍ଗ୍‍ ୱିଜୁ କାତ୍‍ସି ତାତାର୍‌ ନୋ ରାସ୍ତାଦୁ ପାର୍‍ତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ମାରି, ଜିସୁଦି ଆଗ୍‌ଡ଼ି ନି ୱେନ୍‌କା ବୁଲାଜି ସଲ୍‍ସି ମାନି ଲୋକ୍‌ଡର୍‌ ନାଣ୍ତ ଆଉଲି ଆଜି ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, “ହୋଶାନା ପ୍ରବୁଦି ଦର୍‌ତାନ୍‌ ଏନ୍‌ ୱାଜିନାନ୍‍, ମାପୁରୁ ୱାନିଙ୍ଗ୍‌ ଆର୍ସିବାଦ୍‌ କିପିନ୍‍ ! ");
INSERT INTO kfcp_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ମା ପୁର୍ବେଦି ବୁବା ଦାଉଦତି ଆମା ରାଜି ୱାଜିନାତ୍‍, ଆୟାତାନେଙ୍ଗ୍‍ ଧନ୍ୟ, ଆୟା ମୁସ୍‌କୁପୁର୍‌ତୁ ମାନି ନେଗି ବୁବାଦି ଧନ୍ୟ । ନାଣ୍ତ ଲୋକାମାନୁ ହୋଶାନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ଜିସୁ ଜିରୁସାଲାମ୍‍ତୁ ଇତାନ୍‌ ମାରି ମନ୍ଦିର୍‌ ଲୋଇ ଡ଼ୁଗିତାନ୍‍ ମାରି ସାରିବେଡ଼୍‍ତି ୱିଜୁ ଜିନିସ୍‌ତିଙ୍ଗ୍‌ ସୁଡ଼ୁତାନ୍‌ ନାସ୍ତିୱାଲେ ମିଲ୍‌ମିଲିକା ଆଜି ୱାଜି ମାର୍‌ଆତ୍‌ ଆକା ବାର୍‍ ଲୋକୁ ସିସୁରିୱାଲେ ବେତନିୟା ଇନି ନାର୍‍ତୁ ସର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ଆୟା ମାର୍‍ନାଣ୍ଡିଙ୍ଗ୍ ଜିସୁ ମାରି ସିସୁର୍‍ ବେତନିୟା ନାର୍‍ତାଣ୍ତ୍‍ ଜିରୁସାଲମ୍‌ତାନ୍‌ ୱାନିୱାଲେ ଜିସୁଙ୍ଗୁଁ ନାଣ୍ତ ବାଙ୍ଗାଁ କାଟ୍‍ତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ମାରି, ଜିସୁ ଆକଣ୍‍କୁ ଉଣ୍ତ୍ରି ଆକୁମାନି ତଗା ମାରାନ୍‍ତିଙ୍ଗ୍‍ ସୁଡ଼ୁତାନ୍‌, ତଗା ମାରାନ୍‌ତୁ ଫଳ୍‍ ମାନାତ୍‍ନୋ ସିଲେତ୍‌, ଆୟା ଆସାଦାନ୍‍ ଜିସୁ ତଗା ମାରାନ୍‌ ଲାକ୍‌ତୁ ସର୍‌ଆନ୍‌ । ମାତର୍‌ ଲାକ୍‌ତୁ ୱାତାନ୍‌ ନୋ ଆୟା ତଗା ମାରାନ୍‌ତୁ ଆକୁ ଡ଼ିସ୍‌ସି ମାରି ଇନି ଫଳ୍‍ ବା ପଏତାନ୍‍, ଇରିଙ୍ଗ୍‌ ଆୟା ବେଡ଼ାଦୁ ତଗା ପଲ୍‌ ଆସ୍‌ନି ଦିନ୍‌ ରେଏତା ମାର୍‌ଆତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ଜିସୁ ଆୟା ତଗା ମାରାନ୍‍ତିଙ୍ଗ୍‍ ସୁଡ଼୍‌ଜି ଇର୍‌ଆନ୍‌, “ନି ଲାକ୍‌ତୁରାନ୍‌ ଏମେ ଲୋକୁ ଏସ୍‌କାଙ୍ଗ୍‌ବା ପଲ୍‌ ତିନ୍‍ମାକିର୍‍ ।” ଜିସୁଦି ଇୟା ମାଟା ସିସୁର୍‍ ୱେର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ତାନେ ୱେନ୍‌କା ୱାର୍‌ ଜିରୁସାଲମ୍‍ତୁ ୱାତାର୍‌, ମାରି ଜିସୁ ମନ୍ଦିର୍‌ ଲୋଇ ସର୍‌ଆର୍‌ନୋ ଆବେ ପୁଜା ସିନି ଗରିଆ ମେଣ୍ତେଙ୍ଗ୍‍ ପର୍‌ଜି ମାନି ଲୋକାଙ୍ଗ୍‌ ଆତ୍‌ରେ ସପ୍‌ତା ପୋକ୍‌ତାନ୍‌ । ମାରି ଟାକା ପର୍‌ନି ଲୋକାଦି ଟେବୁଲ୍‍ ନି ପାଉରା ପର୍‌ନି ଲୋକାଦି ପାସ୍‌ରା ଡର୍‍ ପେର୍‌ଜି ପକ୍‌ତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ମାରି ମନ୍ଦିର୍‌ ଲୋଇରି ଦୁଆର୍‍ ସିଜି ଇନି ଜିନିସ୍‌ ଅତେଙ୍ଗ୍‌ ସାରି ଏଙ୍ଗ୍‌ବା ସିଏତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ଆୟାୱେନ୍‌କା ଜିସୁ ଶିକ୍ଷା ସିଜି ସିଜି ଇର୍‌ଆନ୍‌, “ଦାର୍ମୁସାସ୍ତ୍ରଦୁ ଇକା ରାସାତାମାନାତ୍‌, ନା ମନ୍ଦିର୍‌ ଦୁନିଆଦି ୱିଜୁ ଜାତିଦି ଲୋକ୍‌ତି ଉଣ୍ତିଙ୍ଗ୍‌ ପାର୍‌ତାନା ଇଲୁ ଇଜି ୱେଙ୍ଗ୍‌ଁନାତ୍‌ ? ମାତର୍‌ ମିର୍‌ ତୋ ଆକା ଡଙ୍ଗାଁରି ଇଲୁୱାଜା କିତିମାନିଦେର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ପେରି ପେରି ଜାଜକର୍‌ ମାରି ସାସ୍ତ୍ରିର୍‍ ଇୟା ମାଟା ୱେର୍‍ଆର୍‍ରୋ ଜିସୁଙ୍ଗୁଁ ଏଣ୍ତେସ୍‌ ସାପିସ୍‌ କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାର୍‍, ଆୟା ଉଣ୍ତିଙ୍ଗ୍‌ ସାରି ପ‍ଇଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌; ମାତର୍‌ ଆବେ ମାର୍‍ଇ ଲୋକଡର୍‍ ୱାନି ସିକିୟାଦିଙ୍ଗ୍‍ କାବା ଆତାର୍‌ ନୋ ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ତିଲାଜି ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ଆୟା ନାଣ୍ଡିଙ୍ଗ୍ ମିଲିମିଲିକା ଜିସୁ ମାରି ୱାନି ସିସୁର୍‌ ଆୟା ଗାଡ଼୍‌ ଡ଼ିସ୍‌ସି ସଲ୍‍ସିମାର୍‍ଆର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ମାରି ଅର୍‍ଲେନ୍‍ ସାଲ୍‍ଦି ଆୟା ସାରି ସିଜି ସନିୱାଲେ ୱାର୍‌ ଜିସୁ ଏମେ ତଗା ମାରାନ୍‌ତିଙ୍ଗ୍‍ ଆନାଦୁରିଆ ସିତାମାର୍ହାନ୍‍ ଆୟା ମାରାନ୍‌ ମଦଲ୍‍ତାନ୍‍ ୱାର୍‍ସି ସରିକା ସୁଡ଼ୁତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ନାସ୍ତିୱାଲେ ପିତର୍‌ ଆଗ୍‍ଡ଼ିରି ମାଟା ଏତ୍‌କିଜି ଜିସୁଙ୍ଗୁଁ ଇର୍‌ଆନ୍‌, “ଏ ଗୁରୁ, ସୁଡ଼୍‌ଆ, ନିନ୍‌ ଏମେ ତଗା ମାରାନ୍‍ତିଙ୍ଗ୍‍ ଆନାଦୁରିଆ ସିତି ମାର୍‍ଇ, ଆୟା ତଗା ମାରାନ୍‌ ୱାର୍‍ସି ସର୍‌ଆ ମାନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ଜିସୁ ଶିଶୁରିଙ୍ଗ୍‌ ୱେର୍‌ତାନ୍‌, “ମାପୁରୁଦି ମାନୁ ବିଶ୍ୱାସ୍‍ କିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ଜେ ଏମେ ଲୋକୁ ଇୟା ଗରନ୍‍ତିଙ୍ଗ୍‍ ନିନ୍‌ ନିଙ୍ଗ୍‍ଜି ସାମ୍‌ଦୁର୍‌ତୁ ସଲ୍‍ସି ଆର୍‌ଆ ଇଜି ଇନାନ୍‌, ମାରି ୱାନି ନିଜେଦି ମନ୍ ଲୋଇ ଅଡ଼୍‌ବିଏଣ୍‌ଗା, ଏମେକା ଇର୍‌ଆ ମାନା, ଆକା ଆନାତ୍‌ ଇଜି ବିସ୍‍ବାସ୍‍ କିନାନ୍‍, ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ଆକା ସତ୍‌ ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ଆଦେଙ୍ଗ୍‌, ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ମିର୍‌ ଏମେ ଏମେକା ପାର୍‌ତନା କିଜି ଲସ୍‌ନିଦେର୍‌, ଆକା ୱିଜୁ ପଇନାପ୍‍ ଇଜି ବିସ୍‍ବାସ୍‍ କିଦୁ, ଆୟାୱିଜୁ ପଇନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ମାରି, ମିର୍‌ ଏମେ ସମୟତୁ ପାର୍‌ତନା କିଦେଙ୍ଗ୍‌ ନିଙ୍ଗ୍‍ନିଦେର୍‍, ଜଦି ଏ ବିରୁଦ୍‍ତାନ୍‍ ମିଙ୍ଗିଁ ଇନି ମାଟା ମାନାତ୍‌, ୱାନିଙ୍ଗ୍‌ କେମା କିଦୁ, ଆଦେଙ୍ଗ୍‌ ମି ମୁସ୍‌କୁପୁର୍‌ତି ବୁବା ବା ମିଙ୍ଗିଁ ୱିଜୁ ପାପ୍‌କେମା କିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ମାତର୍‌ ମିର୍‌ ଜଦି ଆଇ ଲୋକାଙ୍ଗ୍‌ କେମା କିଇଦେର୍‍, ଆଦେଙ୍ଗ୍‌ ମି ମୁସ୍‌କୁପୁର୍‌ତି ବୁବା ବା ମିଙ୍ଗିଁ ପାପ୍‌ ୱିଜୁ କେମା କିଏନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ମାରିଡ଼େସି ଜିସୁ ମାରି ୱାନି ଶିଶୁର୍‌ ଜିରୁସାଲମ୍‍ତୁ ୱାତାର୍; ଜିସୁ ମନ୍ଦିର୍‌ ଲୋଇ ବୁଲାନି ୱାଲେ ପେରି ଯାଜକ, ସାସ୍ତ୍ରିର୍‍ ମାରି ନେତାର୍‌ ୱାନି ଲାକ୍‌ତୁ ୱାଜି ୱେନ୍‌ବାତାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“ନିନ୍‌ ଏମେ ଅଦିକାର୍‍ତାନ୍‍ ଇୟାୱିଜୁ କିଜିନି ? ମାରି ଇୟାୱିଜୁ ପାଣି କିଦେଙ୍ଗ୍‌ ନିଂଇ ଏନ୍‌ ଇୟା ଅଦିକାର୍ ସିତା ମାନାନ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ମାତର୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନାନ୍ ମିଙ୍ଗିଁ ଉଣ୍ତ୍ରି ମାଟା ୱେନ୍‌ବାନା, ନା ମାଟାଦି ଉତର୍‌ ସିଦାଟ୍‍, ଆଦେଙ୍ଗ୍‌ ନାନ୍ ଏମେ ଅଦିକାର୍‍ତାନ୍‍ ଇୟାୱିଜୁ କିଜିନା, ଆକା ମିଙ୍ଗିଁ ଇନା । ");
INSERT INTO kfcp_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ଜୋହନତି ଡୁବନ୍‌ ମୁସ୍‌କୁପୁରୁତାନ୍‌ ନା ଲୋକା ମାଣ୍‌କୁ ଆତାତ୍‌ ? ନାଂଇ ୱେର୍‍ତୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ଆବେନୁ ୱାର୍‌ ୱାରି ୱାରି ଲୋଇ ୱାର୍‍ଗିସାଜି ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, ଜଦି ମୁସ୍‌କୁପୁର୍‌ତାନ୍‌ ଇଜି ଇନିକା, ଆବେଟ୍‌ ୱାଣ୍ତ୍ରୁ ଇନାନ୍‌, ମିର୍‌ ଇନ୍‍ଦାନିଙ୍ଗ୍‍ ଜୋହନତିଙ୍ଗ୍‍ ବିସ୍‍ବାସ୍‍ କିଇତିଦେର୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ଜଦି ଯୋହନତି ଡୁବନ୍‌ ଲୋକାମାଣ୍‌କୁ ଆତାମାନାନ୍‌ ଇଜି ଇଡ୍ରେଙ୍ଗ୍‍ ମାପ୍‌ ଲୋକାଙ୍ଗ୍‌ ତିଲାଜି ମାର୍ହାପ୍‍ ? ଇରିଙ୍ଗ୍‌ ୱିଜୁ ଲୋକୁ ମାନାଜି ମାର୍‌ଆର୍‌ ଯେ ଯୋହନ ଅରେନ୍‍ ବାବବାଦି ଇଜି । ");
INSERT INTO kfcp_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ଉତର୍‌ ସିତାର୍‍, “ମାପ୍‌ ନେସ୍‌ଏପ୍‌ ।” ଆୟାୱେନ୍‌କା ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନାନ୍ ଏମେ ଅଦିକାର୍‍ତାଣ୍ତ୍‍ ଇୟାୱିଜୁ ପାଣି କିଜିନା, ଆକା ନାନ୍ ବା ମିଙ୍ଗିଁ ୱେର୍‌ଏ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ଇୟା ୱେନ୍‌କା ଜିସୁ ୱାରିଙ୍ଗ୍‌ କାତାଦାନ୍‌ ଇର୍‌ଆନ୍‌, ଅରେନ୍‍ ଲୋକ୍‌ ଉଣ୍ତ୍ରି ଅଙ୍ଗୁର୍‍ କିଡ଼ିଇ ଆରାମ୍‌ କିଜି ଆୟା କିଡ଼ିଇଦି ସାରିବେଡ଼୍‍ତି କୋଅଟି ତିଆର୍‌ କିତାନ୍‌, ମାରି ଅଙ୍ଗୁର୍‍ରସ୍‍ ଇଡ୍‌ଦେଙ୍ଗ୍‌ ଗୁଟା କାରିତାନ୍‍ ମାରି କାପ୍‍କିନି ଗୁଡ଼ା ତିଆର୍ କିତାନ୍‌, ଆୟାୱେନ୍‌କା ୱାନ୍‌ ବାଗ୍‍ତୁ ପାଣିକିନିୱାରିଙ୍ଗ୍‌ ଆୟା ଡଡି ବାଗ୍‌ତାନ୍‌ ସିତାନ୍‌ନୋ ଆଇଦେସ୍‌ତୁ ସୋର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ତାନେ ୱେନ୍‌କା ବାଗ୍‌ତୁପାଣିକିନି ୱାରି ମାଣ୍‌କୁ ଅଙ୍ଗୁର୍‍ କିଡ଼ିଇଦାନ୍‍ ଫଳ୍‍ ନିଜେତି ବାଗ୍‌ ଲୋସ୍‍ନି ତାନି ଉଣ୍ତିଙ୍ଗ୍‌ ୱାନ୍‌ ଅରେନ୍‍ ଗତିମୁରୁଲିଙ୍ଗ୍‌ ନାସ୍ତିୱାଲେ ପାଣିକିନିୱାରି ଲାକ୍‌ତୁ ପକ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ମାତର୍‌ ୱାର୍‌ ଆୟା ଗତିମୁରୁଲିଙ୍ଗ୍‌ ଆସ୍‌ତାରୋ ଡାକ୍‍ତାର୍‍ନୋ ୱାର୍‌ଇ କିୟୁଦୁ ପକ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ଆୟାୱେନ୍‌କା ସାଉକାର୍‍ ମାରି ଅର୍‍ସୁ ମାରି ଅରେନ୍‍ ପାଣିକିନି ଗତିମୁରୁଲିଙ୍ଗ୍‌ ପୋକ୍‌ତାନ୍‌; ୱାର୍‌ ଆୟାୱାନିଙ୍ଗ୍‌ ବା ୱାନି ତାଲା ପାଟ୍‍ତାର୍‍ ମାରି ୱାନିଙ୍ଗ୍‌ ନିସାର୍‍ କିତାର୍ । ");
INSERT INTO kfcp_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ଇୟା ୱେନ୍‌କା ମାରି ଅରେନ୍‍ ୱାନିଙ୍ଗ୍‌ ପକ୍‌ତାନ୍‌, ୱାର୍‌ ଆୟାୱାନିଙ୍ଗ୍‌ ବା ସାୟାମାର୍‌ଗା ଡାକ୍‍ତାର୍‍ । ସାଉକାର୍‍ ମାରିଡ଼େସି ମାରି ଏସ ଲୋକାଙ୍ଗ୍‌ ପକ୍‌ତାନ୍‌; ୱାରି ଲୋଇ ଏସୋ ଲୋକାଙ୍ଗ୍‌ ଡାକ୍‍ତାର୍‍ ମାରି ଏସ ଲୋକାଙ୍ଗ୍‌ ସାୟାମାର୍‌ଗା କାତ୍‍ତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ସାଉକାର୍‍ତି ଲାକ୍‌ତୁ ଅରେନ୍‍ନେ ବାକି ମାନାନ୍‌, ୱାଣ୍ତ୍ରୁ ୱାନି ନିଜେଦି ଲାଡ୍‍ତି ମାରିନ୍‌ । ନା ମାରିନ୍‍ତିଙ୍ଗ୍‍ ୱାର୍‌ ଏଣ୍ତେସ୍‌ବା ମାନାନାର୍‌, ଇୟାୱାଜା ଅଡ଼୍‍ବିଜି ସାରାସାରି ୱେନ୍‌କା ଆୟାୱାରି ଲାକ୍‌ତୁ ନିଜେଦି ମାରିନ୍‍ତିଙ୍ଗ୍‍ ପୋକ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ମାତର୍‌ ଆୟା ବାଗ୍‍ତୁ ପାଣିକିନି ଲୋକୁ ୱାରି ୱାରି ଲୋଇ ୱାର୍‍ଗିତାର୍‍, ଇକାନ୍‌ ସାଉକାର୍‍ତି ମାରିନ୍‌, ରାଦୁ, ୱାନିଙ୍ଗ୍‌ ସାୟାମାର୍‌ଗା ଡାକ୍‍ନାଟ୍‍; ଆବେଟ୍‌ ସାଉକାର୍‍ତି ଦନ୍‍ ୱିଜୁ ମା କିୟୁଦୁ ୱାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ଆବେଟ୍‌ ୱାର୍‌ ସାଉକାର୍‍ତି ମାରିନ୍‍ତିଙ୍ଗ୍‍ ଆସ୍ତାର୍‍ନୋ ସାୟାମାର୍‌ଗା ଡାକ୍‌ତାର୍‌ ମାରି ମାଡ଼ାଦିଙ୍ଗ୍‍ ଅଙ୍ଗୁର୍‍ କିଡ଼ିଇ ଡ଼ିସ୍‌ସି ଆଇ ବାଡିଦୁ ପେର୍‌ତା ପକ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","ଜିସୁ ୱେନ୍‌ବାତାନ୍‌, “ଇୟା ୱେନ୍‌କା ଆୟା ଅଙ୍ଗୁର୍‍ କିଡ଼ିଇଦି ସାଉକାର୍‍ ଇନିକା କିନାନ୍‌ ?” ଆୟା ସାଉକାର୍‍ ୱାଜି ଏଣ୍ତେସ୍‌ବା ଆୟାୱାରିଙ୍ଗ୍‌ ସାୟାମାର୍‌ଗା ଡାକ୍‍ନାନ୍‍ ମାରି ଆୟା ଅଙ୍ଗୁର୍‍ କିଡ଼ିଇଦିଙ୍ଗ୍‍ ଆଇ ଲୋକାଙ୍ଗ୍‌ ବାଗ୍‍ତୁ ପାଣିକିନି ଉଣ୍ତିଙ୍ଗ୍‌ ସିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ମିର୍‌ ଦାର୍ମୁସାସ୍ତ୍ରଦୁ ଇୟା ମାଟା ବା ପଡ଼ାଇଦେର୍‌, ଇଲୁ ତର୍‍ନି ମିସ୍ତ୍ରିର୍‍ ଏମେ କାଲୁଦିଙ୍ଗ୍‌ ଦର୍‌କାର୍‌ ଆଏତ୍‍ ଇର୍ହାର୍‌, ଆକାନେ କନାଦି ମୁଲ୍‌ କାଲୁ ଆତାତ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ପ୍ରବୁ ମାଣ୍‌କୁ ଇକା ଆତାତ୍‌, ମାରି ଆକା ମା ଉଣ୍ତିଙ୍ଗ୍‌ ଏସା କାବାଦି ମାଟା ! ");
INSERT INTO kfcp_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ଆବେନ୍‌ ଜିହୁଦି ନେତାର୍‌ ୱାନିଙ୍ଗ୍‌ ଆସ୍‌ତେଙ୍ଗ୍‌ ଇଜି ବଦାକିତାର୍‌, ମାତର୍‌ ୱାର୍‌ ଲୋକାଙ୍ଗ୍‌ ତିଲାତାର୍‌; ମାତର୍‌ ଜିସୁ ଇୟା ମାଟା ୱାରିଙ୍ଗ୍‌ ସୁଡ଼୍‌ଜି ଇନ୍‍ଜିନାନ୍‍ ଇଜି ୱାର୍‌ ନେସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‌ତାର୍‌, ମାରି ୱାର୍‌ ତିଲାଜି ଜିସୁଙ୍ଗୁଁ ଡ଼ିସ୍‌ସି ସରଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ୱେନ୍‌କା ଏସ ପାରୁସିର୍‌ ମାରି ହେରୋଦ ରାଜା ଦଲ‍ତି ମାଣ୍‌କୁ ଏସ ଲୋକାଙ୍ଗ୍‌ ଜିସୁଦି ମାଟାଦି ଭୁଲ୍‍ତିଙ୍ଗ୍‍ ଆସ୍‌ସି ଗୁଟାଦୁ ପକ୍‍ତେଙ୍ଗ୍‍ ଇଜି ୱାର୍‌ ପକ୍‍ତା ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ୱାର୍‌ ୱାତା ରୋ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାର୍‌, “ଏ ଗୁରୁ, ମାପ୍‌ ନେସ୍‌ନାପ୍‌, ନିନ୍‌ ସତ୍‌ ମାରି ଏମେ ଲୋକାଙ୍ଗ୍‌ ବା ତିଲାଇ; ଇରିଙ୍ଗ୍‌ ନିନ୍‌ ଏମେ ଲୋକାଙ୍ଗ୍‌ ବା ମକମ୍‌ ସୁଡ଼ୁଏଣ୍‌ଗା କିନି, ମାତର୍‌ ସତ୍‌ତାନ୍‌ ମାପୁରୁତି ସାରିଦି ବିସୟ ଶିକ୍ଷା ସିନି । ମାଙ୍ଗିଁ ୱେର୍‌ଆ କାଇସର୍‍ ରାଜାଏଙ୍ଗ୍‍ ସିସୁଟୁ ସିଦେଙ୍ଗ୍‍ ନିୟମ୍‍ନୋ ସିଲେତ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ମାଡୁ ସିନା ଡୋ ସିଲେ ? ମାତର୍‌ ଜିସୁ ୱାରି ସାଲାକି ନେସ୍‌ତାନ୍‌ନୋ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଏନ୍ଦା ନାଂଇ ଉରିଦୁ ପକ୍‍ତେଙ୍ଗ୍‍ ବଦାକିଜିନିଦେର୍‌ ? ଉଣ୍ତ୍ରି ଟାକା ଅଦ୍‌ଲି ଡାବୁଙ୍ଗ୍‌ ନା ଲାକ୍‌ତୁ ତାଗାଟ୍‌, ନାନ୍ ଆକା ସୁଣା ।” ");
INSERT INTO kfcp_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ଆବେଟ୍‌ ୱାର୍‌ ଉଣ୍ତ୍ରି ଟାକା ଅଦ୍‌ଲି ତାତାର୍‌ । ଜିସୁ ୱାରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ଇୟା ଟାକା ମୁସ୍‌କୁ ଏ ଦର୍‌ ମାନାତ୍‌ ମାରି ଏ ବମା ମାନାତ୍‌ ?” ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାର୍‌, “କାଇସର୍‍ ରାଜାଦି ।” ");
INSERT INTO kfcp_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “କାଇସର୍‍ ରାଜାଦି ଆମାକା, ଆକା କାଇସର୍‍ ରାଜାଦିଙ୍ଗ୍‍ ସିଦୁ, ମାରି, ମାପୁରୁଦି ଏମେକା, ଆୟାକା ମାପୁରୁଦିଙ୍ଗ୍‌ ସିଦୁ ।” ନାସ୍ତିୱାଲେ ୱାର୍‌ ଜିସୁ ମାଟାଦାନ୍‌ ନାଣ୍ଡ କାବାଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ତାନି ୱେନ୍‌କା ସାତି ସର୍‌ଇ ଲୋକୁ ମାରିଡ଼େସି ଜିବନ୍‌ଆଜି ନିଙ୍ଗ୍‍ନାର୍‍ ଇଜି ବିସ୍‍ବାସ୍‍ କିଇ ସାଦୁକିର୍‍ ୱାନି ଲାକ୍‌ତୁ ୱାଜି ଇୟା ମାଟା ଆସ୍‌ସି ୱେନ୍‍ବାଦେଙ୍ଗ୍‍ ଆସ୍‌ତାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“ଏ ଗୁରୁ, ମୋସା ମା ଉଣ୍ତିଙ୍ଗ୍‌ ଇୟା ନିୟମ୍‌ ୱାଟା ମାନାନ୍‌ ଯେ, ଜଦି ଏମେ ଲୋକା ତଡ଼ାନ୍‍ ସାନାନ୍‌, ମାରି ୱାନି ଆଡ଼ିସ୍‍ ଜିବନ୍‌ ମାନାତ୍‌, ମାରି ଆୟା ରାଣ୍ତି ଆଇମା ମାନୁ କଡ଼କକ୍‌ରା ସିଲେର୍‌, ଆଦେଙ୍ଗ୍‌ ଆୟା ୱାନି ତଡ଼ାନ୍‍ ୱାନି ଆଡ଼ିସ୍‍ ଇଡ୍‌ନାନ୍‌ ମାରି ୱାନିଙ୍ଗ୍‌ ଏମେ କଡ଼କକ୍‌ରା ଜନମ୍‌ ଆନାର୍‌, ନିଜେଦି ତଡ଼ାନ୍‍ ଉଣ୍ତିଙ୍ଗ୍‌ କୁଟୁମ୍‌ କିଦେଙ୍ଗ୍‌ ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ସୁଡ଼୍‍ଦୁ, ସାତ୍‌ଲୋକ୍‌ ତଡ଼ାନ୍‌କୁ ମାର୍ହାର୍‌; ୱିଜେରିଙ୍ଗ୍‍ ପେରି ତଡ଼ାନ୍‍ ପେଡ଼ି ଆତାନ୍‍ନୋ କଡ଼କକ୍‍ରା ଜନମ୍‌ ଆଏଣ୍ତା ସାତା ସର୍ହାନ୍‍; ");
INSERT INTO kfcp_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ୱେନ୍‌କା ୱାନି ୱେନ୍‌କାରି ତଡ଼ାନ୍‍ ତାନିଙ୍ଗ୍‌ ପେଡ଼ି ଆତାନ୍‍ନୋ କଡ଼କକ୍‍ରା ଜନମ୍‌ ଆଏଣ୍ତା ସାତା ସର୍‌ଆନ୍‌ । ଆୟାୱାଜା ମାରି ଅରେନ୍‍ବା ପେଡ଼ି ଆତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ମାରି ଆୟାୱାଜା ସାତ୍ ଲୋକୁ ତଡ଼ାନ୍‍କୁ ୱିଜେରେ ତାନିଙ୍ଗ୍‌ ପେଡ଼ି ଆଜି କଡ଼କକ୍‍ରା ଜନମ୍‌ ଆଏଣ୍ତା ସାତାସର୍‍ଆର୍‍; ୱିଜେରି ସାରା ସାରି ଆୟା ଆଇମା ବା ସାତା ସୋର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ମାରିଡ଼େସି ଜିବନ୍‌ ଆନି ଦିନ୍‍ତୁ ଏସିୱାଲେ ସାତିସରି ଲୋକ୍‍ୱିଜୁ ମାରି ଅର୍‍ସୁ ଜିବନ୍‌ଆଜି ନିଙ୍ଗ୍‍ନାର୍‍, ନାସ୍ତିୱାଲେ ଆୟା ଆଇମା ଏମେ ଲୋକ୍‌ତି ଆଡ଼ିସ୍‍ ଆନାତ୍‌ ? ସାତ୍ ଲୋକୁ ତଡ଼ାନ୍‍କୁ ୱିଜେରେତୋ ଆୟା ଆଇମାଦିଙ୍ଗ୍‍ ପେଡ଼ି ଆତାମାର୍ହାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମିର୍‌ ମାପୁରୁଦି ଦାର୍ମୁସାସ୍ତ୍ର, ମାରି ମାପୁରୁଦି ସାକ୍ତି ନେସ୍‌ଏଣ୍ତା ଭୁଲ୍‍ କିତିମାନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ଆଦେଙ୍ଗ୍‌ ସାତି ଲୋକାମାଣ୍‌କୁ ଡ଼େସିଜିବନ୍‌ଆଜି ନିଙ୍ଗ୍‍ତି ୱେନ୍‌କା ଲୋକୁ ପେଡ଼ି ଆଏର୍‌ କି ପେଡ଼ି ବା କିବିସ୍‍ କିଏର୍‌, ମାତର୍‌ ୱାର୍‌ ୱିଜେରେ ମୁସ୍‌କୁପୁର୍‌ତି ଦୁତ୍‍କା ୱାଜା ତେବାନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ମାତର୍‌ ସାତିକାର୍‍ ଜେ ମାରିଡ଼େସିଜିବନ୍‌ ଆଜି ନିଙ୍ଗ୍‍ନାର୍‍, ମିର୍‌ ଆୟା ବିସୟତୁ ମୋଶାଦି ବଇଦୁ ଦୁପା କାସ୍‍ନି ବିସୟ ପଡ଼ାଇଦେର୍‌ ନୋ ? ମାପୁରୁ ୱାନିଙ୍ଗ୍‌ ଏଣ୍ତେସ୍‌ ଇର୍‌ଆନ୍‌, ମାପ୍‌ ଅବ୍ରାହାମତି ମାପୁରୁ, ଇସ୍‍ହାକ୍‍ତି ମାପୁରୁ ମାରି ଜାକୁବଦି ମାପୁରୁ । ");
INSERT INTO kfcp_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ୱାଣ୍ତ୍ରୁ ସାତିଲୋକ୍‍ତି ମାପୁରୁ ଆଏନ୍‍, ମାତର୍‌ ଜିବନ୍‍ମାନି ଲୋକା ମାପୁରୁ । ମିର୍‌ ବେସି ବାମା ଆଜିନିଦେର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ନାସ୍ତିୱାଲେ ସାସ୍ତ୍ରିରି ମାଣ୍‌କୁ ଅରେନ୍‍ ଲାକ୍‌ତୁ ୱାତାନ୍‌ ନୋ ୱାରି ୱିଜୁ ମାଟା ୱେନ୍‌ଜି ମାର୍‌ଆନ୍‌ ମାରି ସାଦ୍ଦୁକୀରିଙ୍ଗ୍‍ ଜିସୁ ଟିକ୍‍ ଉତର୍‌ ସିତାମାନାନ୍‌, ଇକା ନେସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‍ତାନ୍‍ନୋ ୱାଣ୍ତ୍ରୁ ଜିସୁଙ୍ଗୁଁ ୱେନ୍‌ବାତାନ୍‌, “ୱିଜୁ ଆଦେସ୍‌ ଲୋଇରାନ୍‌ ଆମାକା ପେରି ଆଦେସ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ଜିସୁ ଇର୍‌ଆନ୍‌, “ପେରି ଆଦେସ୍‌ ଇକା, ଏ ଇସ୍ରାଏଲ୍‌, ୱେଣ୍ତ୍ରୁ; ପ୍ରବୁ ମା ମାପୁରୁ ଅରେନ୍‍ନେ ପ୍ରବୁ ମାନାନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ମାରି, ମିର୍‌ ମି ପୁରା ମେନ୍ଧଲ୍‍, ପୁରା ଜିବନ୍‌, ପୁରା ମନ୍‍ ମାରି ପୁରା ବପୁ ସିଜି ପ୍ରବୁ ମି ମାପୁରୁଙ୍ଗୁଁ ଲାଡ୍‍କିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ମାରି ଉଣ୍ତ୍ରି ପେରି ଆଦେସ୍‌ ଆଜିନାତ୍‍, ମିର୍‌ ଲାକ୍‌ତୁରି ଲୋକାଙ୍ଗ୍‌ ନିଜେଦିଙ୍ଗ୍‍ ଜିବନ୍‌ନୋତିୱାଜା ଜିବନ୍‍ନୋଦୁ । ଇୟା ରୁଣ୍ତି ଆଦେସ୍‌ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ଆଇ ମାରି ପେରି ଆଦେସ୍‌ ଇନିକା ସିଲେତ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ଆବେଟ୍‌ ଆୟା ସାସ୍ତ୍ରି ଜିସୁଙ୍ଗୁଁ ଇର୍‌ଆନ୍‌, “ଏ ଗୁରୁ, ଆକା ସତ୍‌, ୱାଣ୍ତ୍ରୁ ନେ ଅରେନ୍‍ ମାରି ୱାନିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ଏନ୍‍ବା ସିଲେନ୍‌, ଇକା ନିନ୍‌ ସତ୍‌ ୱେର୍ତିମାନି । ");
INSERT INTO kfcp_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ମାରି, ଅରେନ୍‍ ଲୋକ୍‌ତିଙ୍ଗ୍‌ ପୁରା ମେନ୍ଧଲ୍‍, ପୁରା ବୁଦି ମାରି ପୁରା ବପୁ ସିଜି ମାପୁରୁଦିଙ୍ଗ୍‌ ଲାଡ୍‍ କିନିକା ମାରି ଲାକ୍‌ତୁରି ଲୋକାଙ୍ଗ୍‌ ଲାଡ୍‌ କିନିକା ଇୟାୱିଜୁ ଦୁପ୍‍ଣି ଆଡ଼ିକ୍‍ନିକା ନି ପୁଜା ସିନି ମାଣ୍‌କୁ ନାଣ୍ତ ପେରିକା ।” ");
INSERT INTO kfcp_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ସାସ୍ତ୍ରି ବୁଦିଦାନ୍‍ ଇର୍‌ଆମାନାନ୍‌ ଇଜି ନେସ୍‌ସି ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନିନ୍‌ ମାପୁରୁଦି ରାଜିଦାନ୍‍ ଆକ ସିଲି ।” ଆବେଟ୍‌କୁ ଜିସୁଙ୍ଗୁଁ ଏନ୍‍ବା ଇନି ପ୍ରସ୍ନ ୱେନ୍‍ବାଦେଙ୍ଗ୍‍ ସାସ୍‌ କିଏତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ମାତର୍‌ ଜିସୁ ମନ୍ଦିର୍‌ତୁ ସିକିୟା ସିନିୱାଲେ ୱେନ୍‌ବାତାନ୍‌, କ୍ରିସ୍ତ ଜେ ଦାଉଦତି ମାରିନ୍‌ ଇଜି, ସାସ୍ତ୍ରିର୍‍ ଏଣ୍ତେସ୍‌ ଇଜିନାର୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ଦାଉଦ ନିଜେ ପବିତ୍ର ଆତ୍ମାଦି ବପୁ ପଇଜି ଇର୍‌ଆମାର୍‌ଆନ୍‌, ପ୍ରବୁ ନା ପ୍ରବୁଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ମାପ୍‌ ଆମାସାନ୍ଦି ନି ୱିଜୁ ସାତ୍ରୁରିଙ୍ଗ୍‌ ନି ପାଦାମ୍‌କାଙ୍ଗ୍‌ ଆଡ୍‍ଗି ଇଡ୍‍ଏପ୍‍, ଆୟା ସାନ୍ଦି ମା ଉଣେରି କିୟୁ ତରିଣ୍ତ୍‍ ବାସ୍‌ସ ମାନ୍‌ଆ । ");
INSERT INTO kfcp_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ଦାଉଦ ନିଜେ କ୍ରିସ୍ତଙ୍ଗ୍‍ ପ୍ରବୁ ଇଜି ଇନାନ୍‌, ମାପୁରୁଦି ବାସ୍‍ସିକିତି ରକିୟା କିନି କ୍ରିସ୍ତ ଏଣ୍ତେସ୍‌ ୱାନି ମାରିନ୍‌ ଆନାନ୍‌ ? ୱିଜେରେ ଲୋକ୍‌ ୱେଡ଼ିକାଦାନ୍‌ ୱାନି ମାଟା ୱେନ୍‍ଜିମାର୍‍ଆର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ମାରିଡ଼େସି, ୱାନ୍‌ ୱାନି ସିକିୟାଦାନ୍‌ ଇର୍‌ଆନ୍‌, “ସାସ୍ତ୍ରିରି ମାଣ୍‌କୁ ଜାଗାର୍‌ତା ! ୱାରୁ ନିର୍‍ଇ ଆଙ୍ଗିଁ ଆରାଜି ବୁଲାଦେଙ୍ଗ୍‌, ମାରି ସାତାସାଉକାଦୁ ମାଡ଼ିସ୍‌ କିପିର୍‍ ଇଜି ବଦାକିନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ପାର୍‌ତନା କିନି ଇଲୁଦୁ ପେରି ଗଦିଦି ବାଡି ମାରି ବୋଜିଦୁ ପେରି ବାଡି ପ‍ଇଦେଙ୍ଗ୍‌ ୱାର୍‌ ବଦାକିନାର୍‍; ");
INSERT INTO kfcp_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ୱାର୍‌ ରାଣ୍ତି ଆଇମେକା ଇଲ୍‌କାଙ୍ଗ୍‌ ୱିଜୁ ନାସ୍ଟୁ କିନାର୍‌ ମାରି ବାଣ୍ତିସ୍‍କିଜି ନିର୍‍ଇ ପାର୍‌ତନା କିନାର୍‌; ୱାର୍‌ ନାଣ୍ତ ଦଣ୍ତ୍‌ ପଇନାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ଅର୍‍ଲେନ୍‍ ଜିସୁ ମନ୍ଦିର୍‌ତୁ ଦାନ୍‌ ସିନି ପେଡ଼ା ଲାକ୍‌ତୁ ବାସ୍‌ତାନ୍‌ନୋ ଲୋକୁ ୱିଜେରେ ଏଣ୍ତେସ୍‌ ପେଡ଼ାଦୁ ଦାନ୍‌ ସିଜିନାର୍‍, ଆକା ସୁଡ଼୍‍ଜିମାର୍‍ଆନ୍‍, ନାସ୍ତିୱାଲେ ଆବେ ମାର୍‍ଇ ମାଜନ୍‌ ଲୋକୁ ନାଣ୍ତ ଡାବୁଙ୍ଗୁଁ ପକ୍‌ତାର୍‌; ");
INSERT INTO kfcp_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ମାରି, ଅରେତ୍‌ କାକୁର୍ତି ରାଣ୍ତି ଆଇମା ୱାତା ଦୋ ରୁଣ୍ତି ଟାକାଦି ଅଦ୍‌ଲିଙ୍ଗ୍‌ ଉଣ୍ତ୍ରିଟାକାଦି ଅଦିଲିଦାନ୍‍ ବା ଉଣା ଆକା ଆବେ ନିର୍‍ତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ଆବେନୁ ଜିସୁ ୱାନି ସିସୁରିଙ୍ଗ୍‌ କୁକ୍‍ତାନ୍‍ନୋ ଇର୍‌ଆନ୍‌, “ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ଇୟା ପେଡ଼ା ଲୋଇ ଡାବୁଙ୍ଗୁଁ ସିତିମାନି ଲୋକା ଭିତ୍ରେ ଇୟା କାକୁର୍ତି ରାଣ୍ତି ଆଇମା ନାଣ୍ତ ସିତାମାନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ଇରିଙ୍ଗ୍‌ ୱିଜେରେ ମାଜନ୍‌ ଲୋକୁ ତାମେ ଡାବୁଙ୍ଗୁଁ ବିତ୍ରେ ଅଡ଼ପ୍‍ ଅଡ଼ପ୍‍ ସିତାର୍‍, ମାତର୍‌ ଇୟା ରାଣ୍ତି ଆଇମା ତାନି ଜିବନ୍‌ ଜିନି ଉଣ୍ତିଙ୍ଗ୍‌ ଏସ ତାନି ମାନୁ ମାର୍‌ଆତ୍‌, ଆକା ୱିଜୁ ସିତାମାନାତ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ଅର୍‍ଲେନ୍‍ ଜିସୁ ମନ୍ଦିର୍‌ତାନ୍‌ ସହସି ସନିୱାଲେ ୱାନି ସିସୁରି ମାଣ୍‌କୁ ଅରେନ୍‍ ସିସୁ ଜିସୁଙ୍ଗୁଁ ଇର୍‌ଆନ୍‌, “ଏ ଗୁରୁ, ସୁଡ଼ୁଆ, ମନ୍ଦିର୍‌ତି ଇଲୁ ମାରି ମନ୍ଦିର୍‌ତି ପେରି ପେରି କାଲ୍‌କୁ ଏସା ନେଗେନ୍‌ ତର୍‍ଜିନେ !” ");
INSERT INTO kfcp_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନିନ୍‌ ଇନିକା ଇୟାୱିଜୁ ପେରି ମେଡ଼୍‍ ଇଲୁ ସୁଡ଼ୁଜିନି ? ଉଣ୍ତ୍ରି କାଲୁ ଆଇ କାଲୁ ମୁସ୍‌କୁ ତେବାଏତ୍‍, ଆକା ୱିଜୁ ଆର୍‍ଜି ବୁମିଦୁ ମିସାନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ତାନେ ୱେନ୍‌କା ଜିସୁ ମନ୍ଦିର୍‌ ଆଗ୍‍ଡ଼ିରି ଜିତ ଗରନ୍‌ ମୁସ୍‌କୁ ବାସ୍‍ତା ମାର୍‌ଆନ୍‌ ଆବେ ପିତର, ଜାକୁବ, ଜୋହନ ମାରି ଆନ୍ଦ୍ରିୟ ଜିସୁଙ୍ଗୁଁ ଏନ୍‍ବା ନେସ୍‌ଇୱାଜା ୱେନ୍‌ବାତାର୍‌, ଇୟାୱିଜୁ ଏସାଙ୍ଗ୍‍ ଗଟାନାତ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“ମାରି ଇୟାୱିଜୁ ଏମେ ସମୟ୍‌ତୁ ଇଗା ୱାନିୱାଜା ଆନାତ୍‌,” ଆୟାୱାଲେରି ସିନା ଇନିକା, “ଆକା ମାଙ୍ଗିଁ ଇନ୍‌ଆଁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ଆବେନୁ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ଜାଗାର୍‌ତା, ଏନ୍‌ ଏଣ୍ତେସ୍‌ ମିଙ୍ଗିଁ ବାମ୍‍ରେ କିଏନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ନାଣ୍ତଲୋକ୍‍ ନା ଦର୍‌ତାନ୍‌ ୱାଜି ମାପ୍‌ କ୍ରିସ୍ତ ଇଜି ଇନାର୍‌, ଲୋକାଙ୍ଗ୍‌ ୱାର୍‌ ନାଣ୍ତ ବାମ୍‍ରେ କିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ମାତର୍‌ ମିର୍‌ ଏସିୱାଲେ ଜୁଦ୍‌ ଆନି ବିସୟ୍‌ ୱେନିଦେର୍‍ ମାରି ଜୁଦ୍‌ ଆନି ଲୋକା ଆଉଲି ୱେନିଦେର୍‍, ଆୟାୱାଲେ ମିର୍‌ ତିଲାମାଟ୍‌, ଇୟାୱିଜୁ ପୁରା ଗଟାନାତ୍‌, ମାତର୍‌ ଇୟାତାନି ଅର୍ତ ଆଏତ୍‍ ଜେ ଜୁଗ୍‌ ସେସ୍‌ଆନି ଦିନ୍‌ ଲାକ୍‌ତୁ । ");
INSERT INTO kfcp_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ଇରିଙ୍ଗ୍‌ ଜାତି ଲୋଇ ଜାତି ଜୁଦ୍‍ ଆନାତ୍‌ ମାରି ଉଣ୍ତ୍ରି ରାଜି ମାରି ଉଣ୍ତ୍ରି ରାଜି ବିରଦ୍‌ତୁ ଜୁଦ୍‍ କିନାର୍‌, ମାରି ଏସ ବାଡିଦୁ ଦିରେ ଦିରେ ବୁମିକମ୍ପ ଆନାତ୍‌ ମାରି ୱିଜୁ ଲୋକାଙ୍ଗ୍‌ ଉଣ୍ତେଙ୍ଗ୍‌ ପୁଟ୍‌ଏତ୍‌; ଇୟାୱିଜୁ ଜନମ୍‌ କିନି କାସ୍ଟୁଦି ଆରାମ୍‌ ମାତର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","ମାତର୍‌ ମିର୍‌ ନିଜେ ନିଜେଦି ବିସୟତାନ୍ ଜାଗାର୍‌ତା ମାନ୍‌ଡ଼୍ରୁ; ଲୋକୁ ମିଙ୍ଗିଁ ତର୍‌ସି ବିସାର୍‌ କିନି ବାଡିଦୁ ଅନାର୍‍ର ସର୍ପେ କିନାର୍‌, ମିର୍‌ ପାର୍‌ତନା କିନି ଇଲୁଦୁ ମାଡ୍‌ ତିନିଦେର୍‍ । ମାରି ମିର୍‌ ନା ସିସୁ ଆତିମାନିଙ୍ଗ୍‌ ପେରି ନେତା ନି ରାଜାରି ଆଗ୍‌ଡ଼ି ୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ସାକି ସିଦେଙ୍ଗ୍‍ ଇଜି ନିଲ୍‌ପିସ୍‌ କିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ମାରି, ଇୟାକା ଗଟାନି ଆଗ୍‌ଡ଼ି ୱିଜୁ ଲୋକା ଲାକ୍‌ତୁ ସୁସମାଚାର୍‌ ପ୍ରଚାର୍‌ ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ଏସ୍ତିୱାଲେ ଲୋକୁ ମିଙ୍ଗିଁ ଆସ୍‍ନା ଅନାରୋ ସର୍ପେ କିନାର୍‌, ନାସ୍ତିୱାଲେ ମିର୍‌ ଇନିକା ଇନିଦେର୍‌, ଆୟା ବିସୟ୍‌ତାନ୍ ଆଗିଡ଼ିରାନ୍‌ ସିନ୍ତା କିମାଟ୍‌, ମାତର୍‌ ଆୟା ସମୟତୁ ମିଙ୍ଗିଁ ଇନିକା ପୁଟ୍‍ନାତ୍‍, ଆକା ଇଡ୍ରୁ; ଇରିଙ୍ଗ୍‌ ମିର୍‌ ଇନି ଲୋକୁ ଆଇଦେର୍‍, ମାତର୍‌ ପବିତ୍ର ଆତ୍ମା ମା ଉଣ୍ତିଙ୍ଗ୍‌ ମାଟା ଇନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ଆୟା ସମୟତୁ ଲୋକୁ ତଡ଼ାନ୍‍ ତଡ଼ାନ୍‍ତିଙ୍ଗ୍‍ ମାରି ବୁବା ମାରିନ୍‍ତିଙ୍ଗ୍‍ ସାପିସ୍‍ତେଙ୍ଗ୍‍ ଇଜି ସର୍‍ପେ କିଜି ସିନାର୍‍; ମାରି, କଡ଼କକ୍‌ରା ବୁବାସି ଆଇସି ବିରୁଦ୍‍ତାନ୍‍ ନିଙ୍ଗ୍‍ନା ରୋ ୱାରିଙ୍ଗ୍‌ ସାୟାମାର୍‌ଗା ଡାକ୍‌ନାର୍‌; ");
INSERT INTO kfcp_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ମାରି, ମିର୍‌ ନା ୱେନ୍‌କା ୱାନି ଲୋକୁ ଆତିମାନିଙ୍ଗ୍‌ ମିଙ୍ଗିଁ ୱିଜେରେ କାଡ଼୍‍ନାର୍‍; ମାତର୍‌ ଆମାକାନ୍‍ ସାରାସାରି ୱେନ୍‌କା ସାନ୍ଦି ସାସ୍‌ଆସ୍‌ସି ତେବାନାନ୍‌, ୱାନ୍‌ ରକିୟା ପଇନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","ମାତର୍‌ ମିର୍‌ ଏସିୱାଲେ ଆୟା ନାସ୍ଟୁକିନି କାଡ଼୍‌ନି ଜିନିସ୍‌ତିଙ୍ଗ୍‌, ଏମେ ବାଡିଦୁ ମାନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ନିୟମ୍‌ ସିଲେତ୍‍, ଆୟା ବାଡିଦୁ ମାନିକା ସୁଡ଼ୁନିଦେର୍‍ ଏମେ ଲୋକ୍‌ଡର୍‌ ପଡ଼ାଦେଙ୍ଗ୍‌ ନେସ୍‌ନାର୍‌ ୱାର୍‌ ବୁଝାପିର୍‍, “ନାସ୍ତିୱାଲେ ଆମାଲୋକ୍‍ ୱିଜେରେ ଜିହୁଦା ଗାଡ଼୍‌ତୁ ମାନାର୍‌, ୱାର୍‌ ଗରନ୍‌ ମୁସ୍‌କୁ ଉରୁକ୍‍ସି ସଲିର୍‍; ");
INSERT INTO kfcp_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ଏନ୍‌ ସାତ୍ ମୁସ୍‌କୁ ଏକ୍‍ନା ମାନାନ୍‌, ୱାଣ୍ତ୍ରୁ ରେସୋ ୱାନି ଇଲ୍‌ତୁ ଇନି ସାସାପାତି ଅତେଙ୍ଗ୍‌ ଇଜି ରାମାକିନ୍‍ ବା ଇଲୁ ଲୋଇ ଡ଼ୁଗ୍‍ମାକିନ୍‍; ");
INSERT INTO kfcp_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ମାରି, ଏନ୍‌ କିଡ଼ିଇଦୁ ତେବାନାନ୍‌, ୱାଣ୍ତ୍ରୁ ୱାନି ସାଦର୍‌ ତାତେଙ୍ଗ୍‌ ଇଜି ଡ଼େସି ସଲ୍‍ମାକିନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ଆୟାୱାଲେ ପଟାଦୁମାନି ଆଇମାଲୋକ୍‍ ମାରି ଇସ୍ରି କଡ଼ରିଙ୍ଗ୍‌ ଆସ୍‌ସି ପାଲ୍‍ ଉଟ୍‍ପିସ୍‍କିନି ଆଇସିକା ଅବସ୍ତା ଏସ ତାଗ୍‌ଇକା ଆନାତ୍‌, ‍ ୱାକ୍‍ ନାଣ୍ତ ଦୁଃକ୍‌‍ ବୋଗାନେ ! ");
INSERT INTO kfcp_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ମାତର୍‌ ଇକା ଏଣ୍ତେସ୍‌ ପିନିକାଡ଼ାଦୁ ଗଟାଏତ୍‍, ଆୟା ଉଣ୍ତିଙ୍ଗ୍‌ ମାପୁରୁଦି ମାନୁ ପାର୍‌ତନା କିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ଇରିଙ୍ଗ୍‌ ଆୟାୱାଲେ ଇୟାୱାଜା ଦୁଃକ୍‌ ଗଟାନାତ୍‍ ଜେ, ମାପୁରୁ ଦୁନିଆଦିଙ୍ଗ୍‍ ତିଆରି କିତି ୱାଲେରାନ୍‌ ନେର୍‌ ସାନ୍ଦି ଇୟାୱାଜା ଗଟାଏତ୍‍, ମାରି ଏସାଙ୍ଗ୍‍ବା ଗଟେ ଆଏତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ମାରି, ଜଦି ପ୍ରବୁ ଆୟା ସମୟ ଏସ୍‌କାଙ୍ଗ୍‌ ଉଣା କିତାନ୍‌ ମାନ୍ଧି, ଇରିଙ୍ଗ୍‌ ଆମା ଲୋକ୍‌ଡର୍‌ ରକିୟା ପ‍ଇଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏତାର୍‍ମାନ୍ଦି; ମାତର୍‌ ମାପୁରୁ ଆମା ଲୋକାଙ୍ଗ୍‌ ଆସ୍‌କିତା ମାର୍‌ଆନ୍‍, ଆୟା ବାସ୍‍କିତି ଲୋକା ଉଣ୍ତିଙ୍ଗ୍‌ ଇଜି ଆୟା ସମୟତିଙ୍ଗ୍‍ ଉଣା କିତାମାନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“ନାସ୍ତିୱାଲେ ଜଦି ଏନ୍‌ ଇନାନ୍‌, ସୁଡ଼ୁଦୁ, କ୍ରିସ୍ତ ଇବେ ମାନାନ୍‌, ମାରି ସୁଡ଼ୁଦୁ, କ୍ରିସ୍ତ ଆବେ ମାନାନ୍‌,” ଏନ୍‌ ଜଦି ମିଙ୍ଗିଁ ଇୟାୱାଜା ଇନାନ୍‌, ଆଦେଙ୍ଗ୍‌ ଆକା ବିସ୍‌ବାସ୍‌ କିମାଟ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","କ୍ରିସ୍ତର୍‍ ନି ବଣ୍ତ ବାବବାଦିର୍‍ ସନାର୍‌ ଇୟାୱାଜା ସିନା ମାରି କାବାଆନି ପାଣି ତର୍‍ନାର୍‍ ଜେ, ଜଦି ଆତିଙ୍ଗ୍‌, ମାପୁରୁ ଆସ୍‌କିତି ଲୋକାଙ୍ଗ୍‌ ବା ବାମ୍‍ରେ କିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ମାତର୍‌ ମିର୍‌ ଜାଗାର୍‌ତା ମାଣ୍ତ୍ରୁ; ଇୟାୱିଜୁ ଆନି ଆଗ୍‍ଡ଼ିନେ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା । ");
INSERT INTO kfcp_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","ମାତର୍‌ ଆୟା ସମୟତୁ ଆୟା ଦୁଃକ୍‌ ୱେନ୍‌କା ୱେଡ଼ା ସିକାଟି ଆନାତ୍‌ ମାରି ଲେଜୁ ଜାୟ୍‌ ସିଏତ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ମାରି ସୁକେଙ୍ଗ୍‍ ବାଦଡ଼୍‍ତାନ୍‍ ଆର୍‌ନେ ମାରି ବାଦଡ଼୍‍ତୁ ମାନି ୱିଜୁ ସାକ୍ତିଦିକେଙ୍ଗ୍‍ ଦୁଙ୍ଗ୍‌ନେ ସନେ । ");
INSERT INTO kfcp_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ନାସ୍ତିୱାଲେ ଲୋକୁ ୱିଜୁ ମନୁସ୍ୟପୁତ୍ରଦିଙ୍ଗ୍‌ ଜେ ନାନ୍ ପେରି ସାକ୍ତିଦାନ୍‍ ମାରି ମହିମାଦାନ୍‌ ବାଦଡ଼୍‍ତାନ୍‍ ୱାନିକା ସୁଡ଼ୁନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ଆୟା ସମୟତୁ ନାନ୍ ଆସ୍‌କିତି ଲୋକାଙ୍ଗ୍‌ ପୃତିବିଦି ଇତି କନାଦାନ୍‍ ବାଦଡ଼୍‍ତି ଇତି କନା ସାନ୍ଦି ସାରିବେଡ଼େତି ଲୋକାଙ୍ଗ୍‌ ଉନ୍‌ଡ୍ରେମାନୁ ଉଣ୍ତାକିଦେଙ୍ଗ୍‌ ଦୁତ୍‌କାଙ୍ଗ୍‌ ପୋକ୍‌ନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“ତଗା ମାରାନ୍‌ତାନ୍‌ କାତା ଅଜାଦୁ; ଏସିୱାଲେ ତଗା ମାରାତି କମେଙ୍ଗ୍‌ଡ଼ି ଆକୁ ରାଲାଜି ସଲ୍‌ସି ମାରି ପୁନି ଆକୁ ସହସି‍ୱାନେ, ଆୟାୱାଲେ ଜେଟାପ୍‌ ଲେଞ୍ଜୁ ଇଗା ୱାତାତ୍‍ ଇଜି ମିର୍‌ ନେସ୍‌ସୋ ମାନ୍‌ଡ୍ରୁ; ");
INSERT INTO kfcp_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ଆୟାୱାଜା ମିର୍‌ ବା ଇୟାୱିଜୁ ଗଟାନିକା ସୁଡ଼ୁଜି ନାନ୍ ୱାନି ଦିନ୍‌ ସେର୍‍ଲା ଲାକ୍‌ତୁ ଇଗା ୱାତାତ୍‌ନି ଇଜି, ଇକା ନେସ୍‌ତୁ । ");
INSERT INTO kfcp_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ଇୟାୱିଜୁ ଗଟେ ଆଇ ସାନ୍ଦି ଇଲେଇ ଜିନିମାନି ଲୋକୁ ଏଣ୍ତେସ୍‌ କିଜିବା ସାଏର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ବାଦଡ଼୍‍ ନି ଦୁନିଆ ନାସ୍ଟୁ ଆନାତ୍‌, ମାତର୍‌ ନା ବାକ୍ୟୱିଜୁ ଏସାଙ୍ଗ୍‍ ନାସ୍ଟୁ ଆଏତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“ମାତର୍‌ ଆୟା ଦିନ୍‌ ବା ଆୟା ଦଣ୍ଡ୍‌ ବିସୟ ଏନ୍‌ବା ନେସ୍‌ଏନ୍‌, ମୁସ୍‌କୁପୁର୍‌ତି ଦୁତ୍‌କୁ ନେସେଉ ମାରି ନାନ୍ ମନୁସ୍ୟପୁତ୍ର ବା ନେସେଏ, ଅରେନ୍‍ ନା ବୁବା ନେସ୍‌ନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ମିର୍‌ ଜାଗାର୍‌ତା ଆଜି ମାନ୍‌ଡ୍ରୁ, କାପ୍‍କିଜ ମାନ୍‌ଡ୍ରୁ; ଇରିଙ୍ଗ୍‌ ଆୟା ଦିନ୍‌ ଏସାଙ୍ଗ୍‍ ଆନାତ୍‌, ଆକା ମିର୍‌ ନେସ୍‌ଇଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ଆକା ଇୟାୱାଜା, ଅରେନ୍‍ ଲୋକୁ ନିଜେଦି ଇଲୁ ଡ଼ିସ୍‌ସୋ ଆଇ ଦେଶ୍‍ ତେବାଜିନାନ୍‍, ମାରି ୱାଣ୍ତ୍ରୁ ୱାନି ଗତିମୁରୁଲିରିଙ୍ଗ୍‍ ୱିଜୁ ଅଦିକାର୍‍ ସିଜି ପାଣି କିଦେଙ୍ଗ୍‌ ଇଜି ଇନାମାନାନ୍‍ ମାରି ଇଲୁ କାପ୍‍କିନି ଲୋକ୍‌ତିଙ୍ଗ୍‌ ବା ଜାଗାର୍‍ତାଦାନ୍‍ କାପ୍‍କିଜ ମାନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଆଦେସ୍‌ ସିତାମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ମାରି, ଏସିୱାଲେ ଇଲୁଦି ମାଲିକ୍‌ ଦାପ୍ରେ ୱାନାନ୍‍ନୋ ମିଙ୍ଗିଁ ସୁଜ୍‍ନିକା ସୁଣାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ଆୟା ଉଣ୍ତିଙ୍ଗ୍‌ ଜାଗାର୍‌ତା ମାନ୍‌ଡ୍ରୁ, ଇରିଙ୍ଗ୍‌ ୱାଣ୍ତ୍‍ରୁ ମିଲିମିଲିକା ନୋ ମାଜେର୍‍ନାଡ଼ା ନୋ କରୁକେଡ଼୍‍ନିୱାଲେ ନୋ ସାଲ୍‍ଦି, ଏସ୍ତିୱାଲେ ୱାଣ୍ତ୍ରୁ ୱାନାନ୍‌, ଆକା ମିର୍‌ ନେସ୍‌ଇଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ନାନ୍ ଆମାକା ମିଙ୍ଗିଁ ଇଜିନା, ଆକା ୱିଜେରିଙ୍ଗ୍‍ ଇଜିନା, ଜାଗାର୍‌ତା ମାନ୍‌ଡ୍ରୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ନିସ୍ତାର୍‍ ପଣ୍ତ୍‌ୟ ମାରି କମିର୍‍ସିଲି ରୁଟି ପଣ୍ତ୍‌ୟ ଉଣି ରିନେଟି ଆଗ୍‌ଡ଼ି । ଆୟାୱାଲେ ପେରି ଜାଜକର୍‌ ମାରି ସାସ୍ତ୍ରିର୍‍ ଜିସୁଙ୍ଗୁଁ ଏନ୍‍ବା ସୁଡ଼ୁଏନ୍‍ଣ୍ତା ଆସ୍‍ସ ଅସ ସାୟାମାର୍‌ଗା ଡାକ୍‌ତେଙ୍ଗ୍‍ଁ ଇଜି ଉପାୟ କିଜିମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ଇରିଙ୍ଗ୍‌ ୱାର୍‌ ଇର୍ହାର୍‌, “ପଣ୍ତ୍‌ୟ ସମୟ୍‌ତୁ ଇୟା ପାଣି କିଦେଙ୍ଗ୍‌ ଆଏତ୍‍,” ଇରିଙ୍ଗ୍‌ ଆନାତ୍‌ ନାସ୍ତିୱାଲେ ଲୋକୁ ଜାଟିଜଗ୍‍ଡ଼ା କିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ଜିସୁ ବେତନିୟାଦୁ କୁସ୍ଟରୋଗ୍‌ ସିମୋନ୍‍କା ଇଲ୍‌ତୁ ଉଣ୍ତେଙ୍ଗ୍‌ ବାସ୍‍ତି ମାରିଇୱାଲେ ଅରେତ୍‌ ଆଇମା ଉଣ୍ତ୍ରି ସାଟିଦୁ ନାଣ୍ତଦାରାଦି ନେଗି ଉଣ୍ତ୍ରି ମାରାତାନ୍‌ ତିଆର୍‌ଆତି ମାର୍‍ଇ ବାସ୍‌ନା ନିୟୁ ତାତା ଦୋ ଆୟା ସାଟିଦି ଡାବ୍‍ଣା ରୁକ୍‍ସି ନିୟୁ ଜିସୁଦି ତାଲାଦୁ ୱାକ୍‍ତେଙ୍ଗ୍‍ ଆସ୍‌ତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ଆବେ ମାର୍‍ଇ ଏସ ଲୋକୁ ଆୟା ଆଇମା ନିୟୁ ୱାକ୍‍ତିକା ସୁଡ଼୍‌ଜି ରିସା ଆତାର୍‌ ମାରି ୱାରି ୱାରି ଲଅ ୱାର୍‌ଗିଜିସାତାର୍‌, “ଇୟା ଆଇମା ବାସ୍‌ନା ନିୟୁ ଇୟାୱାଜା ନାସ୍ଟୁ କିନିକା ମାର୍‌ଆତ୍‌ ନୋ ? ");
INSERT INTO kfcp_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ଆୟା ନିୟୁ ତୋ ପର୍‍ତିଙ୍ଗ୍‍ ଅର୍‍ଲେନ୍‍ ଅରେନ୍‍ କୁଲି କିତି ଡାବୁଙ୍ଗୁଁ ନାସ ପୁଟ୍‍ତେ ମାନ୍ଧି ମାରି କାକୁର୍ତି ଲୋକାଙ୍ଗ୍‌ ସିଦେଙ୍ଗ୍‍ ଆତାତ୍‌ ମାନ୍ଦି !” ୱାର୍‌ ଆୟା ଆଇମାଦିଙ୍ଗ୍‍ କାଡ଼୍‍ଦେଙ୍ଗ୍‍ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ମାତର୍‌ ଜିସୁ ଇର୍‌ଆନ୍‌, “ଆୟା ଆଇମାଦିଙ୍ଗ୍‍ ଡ଼ିସ୍‍ତୁ ! ଇନ୍‍ଦାନିଙ୍ଗ୍‍ ତାନିଙ୍ଗ୍‌ କାସ୍ଟୁ ସିଜିନିଦେର୍‌ ? ୱାଦ୍‍ତୋ ନା ଉଣ୍ତିଙ୍ଗ୍‌ ନେଗି ପାଣି କିତାମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","କାକୁର୍ତି ଲୋକ୍‍ତୋ ୱିଜୁୱାଲେ ମି ଲାକ୍‌ତୁ ମାନାର୍‌, ମାରି ୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ମିର୍‌ ଏସ୍ତିୱାଲେ ବଦାକିନିଦେର୍‍, ନାସ୍‍ସ୍ତିୱାଲେ ୱାରିଙ୍ଗ୍‌ ସାହାଜ୍ୟ କିଦେଙ୍ଗ୍‌ ଆଟ୍‌ନିଦେର୍‌; ମାତର୍‌ ନାନ୍ ୱିଜୁୱାଲେ ମି ଲାକ୍‌ତୁ ତେବାଏ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ତାନି ମାଣାନ୍‌ ଆମାକା ଆନାତ୍‌, ଆକା ୱାଦ୍‌ କିତାମାନାତ୍‌; ନାନ୍ ସାନି ଆଗ୍‍ଡ଼ିନେ ୱାଦ୍‌ ନା ମେନ୍ଦଲ୍‌ତୁ ନିୟୁ ୱାକ୍‍ସି ମୁସ୍‍ନି ନାଣ୍ତିଦି ଉଣ୍ତିଙ୍ଗ୍‌ ତିଆର୍‌ କିତାମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ସାରା ଦୁନିଆଦୁ ନା ନେଗିକାବୁର୍‌ ଏମେ ବାଡିଦୁ ପ୍ରଚାର୍‌ ଆନାତ୍‌, ଇୟା ଆଇମା ଇନି ପାଣି କିତାମାନାତ୍‌, ତାନିଙ୍ଗ୍‌ ଏତ୍‌କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ଇୟାୱିଜୁ ମାଟା ବା ୱେଙ୍ଗ୍‌ଁନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ଆବେଟ୍‌ ବାରଲୋକ୍‌ ସିସୁରି ଲୋଇରାନ୍‌ ଇସ୍କାରିୟୋତିୟ ଜିହୁଦା ଦର୍‌ତି ଅରେନ୍‍ ସିସୁ ଜିସୁଙ୍ଗୁଁ ଆସ୍‍ପିସ୍‍ତେଙ୍ଗ୍‍ ଇଜି ପେରି ଜାଜକରି ଲାକ୍‌ତୁ ସର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ଆୟା ପେରି ଜାଜକର୍‌ ଇସ୍କାରିୟତିୟ ଜିହୁଦାଦି ମାଟା ୱେନ୍‌ଜି ୱେଡ଼ିକା ଆତାର୍‌ ମାରି ଆୟା ପାଣିକିନି ଉଣ୍ତିଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ ଏସ ଡାବୁଙ୍ଗୁଁ ସିଦେଙ୍ଗ୍‍ ପାର୍‍ମାଣ୍‍କିତାର୍‍ । ଆୟାୱାଲେରାନ୍‍ ଜିହୁଦା ଜିସୁଙ୍ଗୁଁ ପେରିଜାଜକରି କିୟୁଦୁ ଆସ୍‍ପିସ୍‍ନି ଉଣ୍ତିଙ୍ଗ୍‌ ସାରି ପ‍ଇଦେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ୱେନ୍‌କା କମିର୍‌ସିଲି ରୁଟି ଉଣି ପଣ୍ତୟ୍‍ତି ଆଗ୍‍ଡ଼ିରି ନାଣ୍ଡିଙ୍ଗ୍, ଆମା ନାଣ୍ଡିଙ୍ଗ୍ ନିସ୍ତାର୍‍ ପଣ୍ତ୍‌ୟତି ବୋଜି ଉଣ୍ତିଙ୍ଗ୍‌ ମେଣ୍ତାପିଲା କଇନାର୍‍, ଆୟା ନାଣ୍ଡିଙ୍ଗ୍ ୱାନି ସିସୁର୍‍ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, “ମାପ୍‌ ନି ଉଣ୍ତିଙ୍ଗ୍‌ ସନାପ୍‌ ନୋ ଏମେ ବାଡିଦୁ ନିସ୍ତାର୍‍ ପଣ୍ତ୍‌ୟତି ବୋଜି ତିଆର୍‌ କିନାପ୍‍ ଇଜି ନିନ୍‌ ବଦା କିଜିନି ?” ");
INSERT INTO kfcp_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ଜିସୁ ୱାନି ସିସୁରି ଲୋଇ ରିଏରିଙ୍ଗ୍‍ ଇୟା ମାଟା ଇର୍‌ଆ ପକ୍‌ତାନ୍‌, ମିର୍‌ ଗାଡ଼୍‌ତୁ ସାନ୍‍ଡ୍ରୁ, ଆବେ ଅରେନ୍‍ ଲୋକୁ ଏରୁ ସାଟି ଆସ୍‍ସ ସନିକା ସୁଣିଦେର୍‍; ମାରି ମିର୍‌ ୱାନି ୱେନ୍‌କା ୱେନ୍‌କା ସାନ୍‍ଡ୍ରୁ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ୱାନ୍‌ ଆମା ଇନ୍‌ଡ୍ର ସଲ୍‌ସି ଡ଼ୁଗ୍‍ନାନ୍‍, ଆୟା ଇନ୍‌ଡ୍ର ମାଲିକ୍‌ତିଙ୍ଗ୍‌ ଇନ୍‍ଡ୍ରୁ, ଗୁରୁ ୱେନ୍‌ବାଜିନାନ୍‌, ନାନ୍ ନା ସିସୁରିୱାଲେ ଆମା ଇନ୍‌ଡ୍ର ନିସ୍ତାର୍‍ ପଣ୍ତ୍‌ୟତି ବୋଜି କିନା, ଆୟା ନା ବାକ୍ରା ଆମାକା ? ");
INSERT INTO kfcp_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ଆବେଟ୍‌ ୱାନ୍‌ ମିଙ୍ଗିଁ ନେଗ୍ରେଣ୍ତା ତିଆର୍ ଆତିମାନି ଉଣ୍ତ୍ରି ମୁସ୍‌କୁରି ପେରି ବାକ୍‍ରା ତର୍‍ନାନ୍‍; ଆୟା ବାଡିଦୁ ମାଡ୍‌ ପଣ୍ତ୍‌ୟ ଉଣ୍ତେଙ୍ଗ୍‌ ବୋଜି ତିଆର୍‌ କିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ଆବେଟ୍‌ ସିସୁର୍‍ ସର୍ହାରୋ ନାର୍‍ତୁ ଡ଼ୁଗିତାର୍‍, ମାରି ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଏଣ୍ତେସ୍‌ ଇର୍‌ଆମାର୍‌ଆନ୍‌, ଆୟାୱାଜା ୱାର୍‌ ନିସ୍ତାର୍‍ ପଣ୍ତ୍‌ୟତି ବୋଜି ତିଆର୍‌ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ମିଲ୍‌ମିଲିକା ଆତାତ୍‌ଆକା ଜିସୁ ବାର୍‌ଲୋକ୍‌ ସିସୁରି ୱାଲେ ଆୟା ଇଲ୍‌ତୁ ୱାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ୱାର୍‌ ବାସ୍‍ସୋ ଉଣିୱାଲେ ଜିସୁ ଇର୍‌ଆନ୍‌, “ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ମି ଲୋଅ ଅରେନ୍‍, ନାଙ୍ଗିଁ ଏନ୍‍କି ନାୱାଲେ ଉଣୁଜିନାନ୍‍, ୱାନ୍‌ ନାଙ୍ଗିଁ ସାତ୍ରୁରି କିୟୁଦୁ ସର୍‌ପେ କିନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ଆବେଟ୍‌ ସିସୁର୍‌ ଦୁଃକ୍‌ କିଜି ଅରେନ୍‍ ଅରେନ୍‍ ଆଜି ଜିସୁଙ୍ଗୁଁ ୱେନ୍‍ବାଦେଙ୍ଗ୍‍ ଆସ୍‌ତାର୍‌, “ଆକାନ୍‍ ଇନିକା ନାନ୍ ନୋ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ବାର୍‍ଲୋକା ଲୋଇ ଅରେନ୍‍, ଏନ୍‍କି ନାୱାଲେ କୁଡ଼ୁକାଦୁ କିୟୁ ମୁଡ଼ୁକ୍‍ସିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ନାନ୍ ସତ୍‌ ଇଜିନା, “ମନୁସ୍ୟପୁତ୍ର ଜେ ନାନ୍ ନା ବିସୟତାନ୍ ସାସ୍ତ୍ରଦୁ ଏଣ୍ତେସ୍‌ ରାସାତାମାନାତ୍‌, ଆୟାୱାଜା ନାନ୍ ସାଦେଙ୍ଗ୍‌ ସଲ୍‍ସିନା ଆକା ସତେନେ, ମାତର୍‌ ମନୁଷ୍ୟପୁତ୍ର ଜେ ନାନ୍ ଆମା ଲୋକ୍‍ତିମାଣାନ୍‍ ସାତ୍ରୁରି କିୟୁଦୁ ସର୍‍ପେ ଆଗାସଲ୍‌ସିନା, ୱାଣ୍ତ୍ରୁ ଜନମ୍‌ ଆଏତି ମାର୍‍ରିଙ୍ଗ୍‍ ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ନେଗେଣ୍ତ୍‍ ଆତାତ୍‌ ମାନ୍ଦି ।” ");
INSERT INTO kfcp_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ମାରି ୱାର୍‌ ଉଣିୱାଲେ ଜିସୁ ଉଣ୍ତ୍ରି ରୁଟି ଆସ୍‌ତାନ୍‌ନୋ ମାପୁରୁଙ୍ଗ୍‌ ଦନ୍ୟବାଦ୍‌ ସିତାନ୍‌ ମାରି ରୁଟି ରୁକ୍‍ସି ସିସୁରିଙ୍ଗ୍‌ ସିଜି ଇର୍ହାନ୍‌, “ଇକା ତିନ୍‍ଡ୍ରୁ, ଇକା ନା ମେନ୍ଧଲ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ଆୟାୱେନ୍‌କା ଅଙ୍ଗୁର୍‍ରସ୍‍ ଅସି ମାପୁରୁଦି ମାନୁ ଦନ୍ୟବାଦ୍‌ ସିଜି ସିସୁରିଙ୍ଗ୍‌ ସିତାନ୍‌ ମାରି ୱିଜେରେ ଅଙ୍ଗୁର୍‍ରସ୍‍ ଉଟାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ମାରି, ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଇକା ନା ନେତେର୍‌, ନାନ୍ ନା ଏମେ ନେତେର୍‌ ୱାକ୍‍ସି ସିଦେଙ୍ଗ୍‍ ସଲ୍‍ସିନା, ଆକା ମାପୁରୁଦି ୱାଲେ କିତି ପୁନି ନିୟମ୍‌ । ଆକା ଲୋକା ଉଣ୍ତିଙ୍ଗ୍‌ ନାଣ୍ତ ଦାରା । ");
INSERT INTO kfcp_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ଆମା ନାଣ୍ଡିଙ୍ଗ୍ ନାନ୍ ମାପୁରୁଦି ରାଜିଦୁ ପୁନି ଅଙ୍ଗୁର୍‍ ପଲ୍‌ତି ରସ୍‌ ଉଣି ସାନ୍ଦି, ନାନ୍ ମାରି ଏସାଙ୍ଗ୍‍ ବା ଉଣୁଏ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ଇୟା ୱେନ୍‌କା ଜିସୁ ମାରି ୱାନି ସିସୁର୍‌ ଉଣ୍ତ୍ରି ଦନ୍ୟବାଦ୍‍ତି ପାଟା ପାରିତି ୱେନ୍‌କା ଜିତ ଗରନ୍‌ ମୁସ୍‌କୁ ସତାସର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ନାସ୍ତିୱାଲେ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମିର୍‌ ୱିଜିଦେର୍‌ ନାଙ୍ଗିଁ ଡ଼ିସ୍‌ନି ଉର୍‍କ୍‍ନିଦେର୍‌ । ସାସ୍ତ୍ରଦୁ ରାସାତାମାନାତ୍‌, “ମାପ୍‌ ମେଣ୍ତେଙ୍ଗ୍‌ ସାରାକିନିୱାନିଙ୍ଗ୍‌ ସାୟାମାରାଗ୍‌ ଡାକ୍‌ତିଙ୍ଗ୍‌ ମାରି ମେଣ୍ଡେଙ୍ଗ୍‌ ଇନିଙ୍ଗାଁ ଆନିଙ୍ଗାଁ ଆନେସନେ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ମାତର୍‌ ନାନ୍ ସାଜି ମାରିଡ଼େସିନିଙ୍ଗିଁତି ୱେନ୍‌କା ମି ଆଗ୍‍ଡ଼ିନେ ଗାଲିଲି ରାଜିଦୁ ସନା । ");
INSERT INTO kfcp_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ମାତର୍‌ ପିତର୍‌ ଜିସୁଙ୍ଗୁଁ ଇର୍‌ଆନ୍‌, “ୱିଜେରେ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ବା ନାନ୍ ନିଂଇ ମାତର୍‌ ଡ଼ିସ୍‍ଏ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ଜିସୁ ପିତରତିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନାନ୍ ନିଂଇ ସତ୍‌ ଇଜିନା, ନେର୍‍ଇ ନାଡ଼ା କର୍‌ରୁ ରିଜା କେଡ଼ିନି ଆଗ୍‌ଡ଼ି ନିନ୍‌ ନାଂଇ ମୁଜା ନାନ୍ ନେସେଏ ଇଜି ଲୋକାମାନୁ ଇନି ।” ");
INSERT INTO kfcp_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ମାତର୍‌ ପିତର ନାଣ୍ତ ଆଟ୍‍ୱାଦାନ୍‍ ଇର୍‌ଆନ୍‌, “ନି ୱାଲେ ସାଦେଙ୍ଗ୍‌ ପଡ଼ାତିଙ୍ଗ୍‌ ବା ନାନ୍ ଏସ୍‌କାଙ୍ଗ୍‌ ନିଙ୍ଗିଁ ନେସ୍‍ଏ ଇଜି ଇନ୍‌ଏ । ମାରି ଆଇ ସିସୁର୍‍ବା ଆୟାୱାଜା ଇର୍ହାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ଆୟାୱେନ୍‌କା ୱାର୍‌ ଗେତ୍‌ସିମାନି ଦର୍‌ତି ଉଣ୍ତ୍ରି ବାଡିଦୁ ୱାତାର୍‌, ମାରି ଜିସୁ ୱାନି ସିସୁରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନାନ୍ ପାର୍‌ତନା କିନେଣ୍‍ଗା ମିର୍‌ ଇବେନୁ ବାସ୍‌ସୋ ମାନ୍‌ଡ୍ରୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ମାରି, ୱାନ୍‌ ପିତର, ଯାକୁବ ମାରି ଜୋହନତିଙ୍ଗ୍‍ ଅର୍‌ସେ ଅତାନ୍‌ନୋ ନାଣ୍ତ ସିମ୍ରା ମାରି ଦୁଃକ୍‌‍ କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ଆବେଟ୍‌ ୱାନ୍‌ ସିସୁରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନା ଜିବନ୍‌ ସାନିୱାଜା ଆଜି ନାଣ୍ତ ଆଡ୍‌ବାଜିନାତ୍‌; ମିର୍‌ ଇବେ ବାସ୍‌ସ କାପ୍‍କିଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ମାରି, ୱାଣ୍ତ୍ରୁ ଅଡ଼ପ୍‍ ଆକ ଆଗ୍‌ଡ଼ି ସଲ୍‌ସି ବୁମିଦୁ ମେଣ୍ତେଙ୍ଗ୍‍ ଗଟ୍‍ କିତାନ୍‌ନୋ, ପାର୍‌ତନା କିଜି ଇର୍‌ଆନ୍‌, ନି ବଦା ଜଦି ଆନାତ୍‌, ଇୟା ଦୁଃକ୍‌ ନାମାଣ୍‍କୁ ଆକ କିଆ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ମାରି, ଜିସୁ ଇର୍‌ଆନ୍‌, “ଅବ୍ବା, ବୁବା,” ୱିଜୁ ନିଂଇ ଉସାସ୍‌, ଇୟା ଦୁଃକ୍‌ ନାବାଣ୍‍କୁ ଆକ କିଆ; “ନା ବଦା ସିଲେ, ମାତର୍‌ ନି ବଦା ।” ");
INSERT INTO kfcp_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ଆବେଟ୍‌ ୱାଣ୍ତ୍ରୁ ଡ଼େସିୱାଜି ୱାରିଙ୍ଗ୍‌ ସୁଜ୍‍ନିକା ସୁଡ଼ୁତାନ୍‌ ମାରି ପିତର୍‍ତିଙ୍ଗ୍‍ ଇର୍‌ଆନ୍‌, “ସିମୋନ୍‌, ମିର୍‌ ଇନିକା ସୁସ୍‍ତିଦେର୍‍ ? ନା ୱାଲେ ଉଣ୍ତ୍ରିଗନ୍‌ଟାବା କାପ୍‌କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ଇତିଦେର୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ପରିକାଦୁ ଏଣ୍ତେସ୍‌ ଆର୍‌ଇଦେର୍‌, “ଆୟା ଉଣ୍ତିଙ୍ଗ୍‌ ଜାଗାର୍‍ତାଦାନ୍‍ ପାର୍‌ତନା କିଦୁ; ଜିବନ୍‌ ବଦା କିନାତ୍‍ ସତ୍‌, ମାତର୍‌ ମେନ୍ଧଲ୍‍ ଲୋଡ଼ଲାଡ଼ା ।” ");
INSERT INTO kfcp_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ୱାନ୍‌ ମାରିଡ଼େସି ସଲ୍‌ସି ଆଗ୍‌ଡ଼ି ଏଣ୍ତେସ୍‌ ପାର୍‌ତନା କିତାମାର୍‍ଆନ୍‍ ଆୟାୱାଜା ମାରି ପାର୍‌ତନା କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ମାରିଡ଼େସି, ୱାନ୍‌ ୱାଜି ସିସୁରିଙ୍ଗ୍‌ ସୁଜୁନିକା ସୁଡ଼ୁତାନ୍‌, ଇରିଙ୍ଗ୍‌ ୱାରି କାଣୁକୁ ସୁଡ଼୍‍ଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏଜି ମାର୍ହାର୍‌, ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଇନିକା ଇନାର୍‌, ଆକା ନେସ୍‌ଏର୍‌ ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ୱାନ୍‌ ମୁଜା ୱାଜି ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ସାଣେକ୍‌ ସୁଜ୍‍ଜି ରମ୍‍ଦୁ; ନାଣ୍ତ ଆତାତ୍‌ନି ! ଆୟା ସମୟ ଇଗା ୱାତାତ୍‌ନି ! ସୁଡ଼୍‍ଦୁ, ମନୁସ୍ୟପୁତ୍ର ଜେ ନାନ୍ ପାପି ଲୋକା କିୟୁଦୁ ସେର୍‍ପାନା । ");
INSERT INTO kfcp_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ନିଙ୍ଗ୍‍ଦୁ, ମାଡ୍‌ ସନାଟ୍‌; ସୁଡ଼ୁଦୁ, ଏନ୍‌ ନାଙ୍ଗିଁ ସାତ୍ରୁରି କିୟୁଦୁ ସେରେପ୍‌ନା ସିନାନ୍‌, ୱାନ୍‌ ଲାକ୍‌ତୁ ୱାତାନ୍‍ନି ।” ");
INSERT INTO kfcp_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ମାରି ଆୟାଦାପ୍ରେ, ୱାନ୍‌ ମାଟା ଇନିୱାଲେ, ବାରଲୋକ୍ ସିସୁରି ଲୋଇରାନ୍‌ ଜିହୁଦା ଦର୍‍ତିକାନ୍‍ ମାରି ଏସ ପେରି ଯାଜକର୍‌, ସାସ୍ତ୍ରିର୍‍ ମାରି ପେରି ନେତାରି ମାଣ୍‌କୁ ଲୋକୁ କାଣ୍ତା ମାରି ବାଡିଗା ଆସ୍‌ସି ୱାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ଜିସୁଙ୍ଗୁଁ ସାତ୍ରୁରି କିଦୁ ସେର୍‍ପେନିକାନ୍ ୱାରିଙ୍ଗ୍‌ ଇୟା ସିନା ସିଜି ଇର୍‌ଆନ୍‌, “ନାନ୍ ଆମାୱାନିଙ୍ଗ୍‌ ନଣ୍ତ୍‌ନା, ଆକାନ୍‍ ଜିସୁ; ୱାନିଙ୍ଗ୍‌ ଜାଗାର୍‍ତାଦାନ୍‍ ତର୍‍ନି ଅନିଦେର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ଜିହୁଦା ୱାଜି ଇତି ଦାପ୍ରେ ଜିସୁଦି ଲାକ୍‌ତୁ ସର୍‌ଆନ୍‌ ନୋ, “ଏ ଗୁରୁ !” ଇଜି ଇର୍‌ଆନ୍‌ ନୋ ଜିସୁଙ୍ଗୁଁ ନାଣ୍ତ ନଣ୍ତିତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ଆବେଟ୍‌ ୱାର୍‌ ୱାତାର୍‌ ରୋ ଜିସୁଙ୍ଗୁଁ ଆସ୍ତାରୋ ତର୍‍ତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ମାତର୍‌ ଲାକ୍‌ତୁ ନିର୍‍ହି ମାର୍‍ଇ ଲୋକା ଲୋଇ ଅରେନ୍‍ କାଣ୍ତା ସପ୍‌ତାନ୍‌ନୋ ମାରି ପେରି ଜାଜକ୍‍ତି ଗତିମୁରୁଲିଙ୍ଗ୍‌ ଆସ୍‍ତାନ୍‍ନୋ ୱାନି ଗିତଣି କୟତା ପକ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନାଂଇ ଆସ୍‌ତେଙ୍ଗ୍‌ ଅରେନ୍‍ ଡଙ୍ଗାଁର୍‍ଏଙ୍ଗ୍‍ ଆସ୍‌ତେଙ୍ଗ୍‌ ୱାନିୱାଜା ମିର୍‌ କାଣ୍ତା ମାରି ଡୁଡୁ ଆସ୍‌ତି ୱାତିମାନିଦେର୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ନାନ୍ ତୋ ୱିଜୁୱାଲେ ମିୱାଲେ ମନ୍ଦିର୍‌ତୁ ମାନ୍‌ଜି ସିକିୟା ସିଜି ମାର୍‍ଆ, ମାତର୍‌ ମିର୍‌ ନାଂଇ ଆସ୍‍ଇତିଦେର୍‍; ମାତର୍‌ ଦାର୍ମୁସାସ୍ତ୍ରଦି ମାଟା ଏଣ୍ତେସ୍‌ ସତ୍‌ ଆନାତ୍‌, ଆୟା ଉଣ୍ତିଙ୍ଗ୍‌ ଇୟାୱିଜୁ ଗଟାଜିନାତ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ଇୟା ୱେନ୍‌କା ୱାନି ସିସୁର୍‌ ୱିଜେରେ ୱାନିଙ୍ଗ୍‌ ଡ଼ିସ୍‍ସି ଉରୁକ୍‍ତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ମାତର୍‌ ଅରେନ୍‍ ମୁରୁଲି କଡ଼ ୱାନି ଡୁମ୍‍ଡା ମେନ୍ଦଲ୍‌ତୁ ଇସ୍ରି ସାଦର୍‌ ପିଡ଼୍‍ଗିତାନ୍‍ନୋ ଜିସୁୱାଲେ ୱାଲେ ସଲ୍‌ସି ମାର୍‌ଆନ୍‌; ଆୟା ଲୋକୁ ମୁରୁଲିଙ୍ଗ୍‌ ଆସ୍‌ତେଙ୍ଗ୍‌ ବଦାକିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ମାତର୍‌ କଡ଼ ଆୟା ଇସ୍ରି ସାଦର୍‌ ଡ଼ିସ୍‍ତାନ୍‍ନୋ ଡୁମ୍‍ଡା ଆତା ଉରୁକ୍‍ତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ୱେନ୍‌କା ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ୱିଜେରିଙ୍ଗ୍‍ ପେରିଜାଜକତି ଲାକ୍‌ତୁ ଅତାର୍‍, ମାରି ପେରି ଜାଜକର୍‌, ପେରି ପେରି ନେତାର୍‍ ମାରି ସାସ୍ତ୍ରିର୍‍ ୱିଜେରେ ୱାତା ଉଣ୍ତାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ପିତର ଅଡ଼ପ୍‍ ଆକ ତେବାତାନ୍‌ ନୋ ୱାନି ୱାଲେ ୱାଲେ ୱିଜେରିଙ୍ଗ୍‍ ପେରି ଜାଜକ୍‍ତି ଦୁଆର୍‌ ଲୋଅ ସର୍‌ଆନ୍‌ ମାରି ଆବେ ଇଲୁ କାପ୍‍କିନି ଲୋକାୱାଲେ ସିସୁ କାଇଜିମାର୍‍ଆନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ଆୟାୱେନ୍‌କା ପେରି ଯାଜକର୍‌ ମାରି ଯିହୁଦି ସଭାତି ଲୋକୁ ୱିଜେରେ ଜିସୁଙ୍ଗୁଁ ଡାକ୍‌ତେଙ୍ଗ୍‍ଁ ଇଜି ୱାନି ବିରୁଦାନ୍‍ ସାକି ପ‍ଇଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, ମାତର୍‌ ପଇଏତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ମାରି ଏସ ଲୋକୁ ଜିସୁ ବିରୁଦ୍‌ତାନ୍‍ ମିଚ୍‍ ସାକି ଇର୍ହାର୍‌ ମାତର୍‌ ୱାରି ମାଟା ମିସାଏତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ମାରି ୱେନ୍‌କା ଏସ ଲୋକୁ ନିର୍‍ରା ରୋ ୱାନି ବିରୁଦ୍‍ତାନ୍‍ ଇୟା ମିସ୍‌ ସାକି ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌; ");
INSERT INTO kfcp_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“ମାପ୍‌ ୱେନ୍‍ ଇୟା ମାଟା ଇନିକା ୱେର୍‍ଆମାନାପ୍‍, ନାନ୍ ଲୋକୁ କିୟୁଦୁ ତିଆର୍‍କିତି ଇୟା ମନ୍ଦିର୍‌ତିଙ୍ଗ୍‌ ରୁକ୍‍ସି ମୁନେଟାନ୍‍ ମାରି ଉଣ୍ତ୍ରିଲୋକା କିକାଣ୍‍ ତିଆର୍ ଆଇ ମନ୍ଦିର୍‌ ତିଆର୍‌ କିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ମାତର୍‌ ଇବେବା ୱାରି ସାକି ମିସାଏତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ଆବେଟ୍‌ ୱିଜେରିଙ୍ଗ୍‍ ପେରି ଜାଜକ୍‍ ଜିସୁଙ୍ଗୁଁ ନାଡ଼୍‍ମି ନିଲ୍‍ପ୍‍ତାନ୍‍ନୋ ୱେନ୍‌ବାତାନ୍‌, “ନି ବିରୁଦ୍‍ତାନ୍‍ ଇୟାକାର୍‌ ଏମେ ମାଟା ଇଜିନାର୍‍, ଆକା ସତ୍‍ନୋ, ନିନ୍‌ ଇନିକା ବା ଇନ୍‍ଇଜିନି ?” ");
INSERT INTO kfcp_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ମାତର୍‌ ଜିସୁ ଇନିକା ଇନ୍‍ଏଣ୍ତା ଆଲେତାମାର୍‍ଆନ୍‍, ୱିଜେରିଙ୍ଗ୍‍ ପେରି ଯାଜକ୍‍ ମାରିଡ଼େସି ୱେନ୍‌ବାତାନ୍‌, “ନିନ୍‌ ଇନିକା ପ୍ରସଂସା ପଇଜିମାନି ମାପୁରୁଦି ମାରିନ୍‌ କ୍ରିସ୍ତ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ଜିସୁ ଇର୍‌ଆନ୍‌, “ହୁଁ ନାନ୍, ମିର୍‍ ମନୁସ୍ୟପୁତ୍ରଦିଙ୍ଗ୍‍ ପେରି ସାକ୍ତିଦି ମାପୁରୁଦି ଉଣି କିୟୁ ତର୍‌ନି ବାସ୍‍ନିକା ମାରି ବାଦଡ଼୍‍ତି ରତଦାନ୍‍ ୱାନିକା ମିର୍‌ ସୁଣିଦେର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ଆବେଟ୍‌ ୱିଜେରିଙ୍ଗ୍‌ ପେରି ଜାଜକ ନିଜେଦି ଆଙ୍ଗିଁଦିଙ୍ଗ୍‌ କିସ୍‌ସି ପୋକ୍‌ସି ଇର୍ହାନ୍‌, “ସାକି ମାରି ଇନି ମାଙ୍ଗିଁ ଦରକାର୍‍ଲୁ ? ");
INSERT INTO kfcp_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ମିର୍‌ ତୋ ୱାନ୍‌ ମାପୁରୁଙ୍ଗୁଁ ନିନ୍ଦାକିନିକା ୱେର୍‌ଇଦେର୍‌; ଇଲେଇ ମିର୍‌ ଇନି ବିସାର୍‌ କିନିଦେର୍‌ ?” ଆବେଟ୍‌ ୱାର୍‌ ୱିଜେରେ ଇର୍ହାର୍‌ ଜିସୁ ସାନିକା ଜଗ୍‌ ମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ମାରି, ଏର୍‌ ଏର୍‌ ଜିସୁ ମୁସ୍‌କୁ ପୁସ୍‍କାଣାମ୍‍ ପୁସ୍‍ତେଙ୍ଗ୍‍ ଆସ୍‌ତାର୍‌ ମାରି ୱାନି ମକମ୍‍ତିଙ୍ଗ୍‍ ପାଗା କେରେପ୍‌ସି ୱାନିଙ୍ଗ୍‌ ଲାତ୍‍ ଅଦ୍‍ଗିଜି ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, “ନିନୁନେ ବାବବାଦି !” ମାଙ୍ଗିଁ ୱେର୍‌ଆ । କାପ୍‍କିନିକାର୍‍ ୱିଜେରେ ସାପୁଡ଼ୁ ଡାକ୍‍ବୁ ଡାକ୍‍ବୁ ଜିସୁଙ୍ଗୁଁ ଆସ୍‌ତା ଅତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ଆୟାୱାଲେ ପିତର ଆଡ୍‍ଗି ଦୁଆର୍‌ତୁ ତେବାନିୱାଲେ ୱିଜେରିଙ୍ଗ୍‍ ପେରି ଯାଜକତି ଲାକ୍‌ତୁ ପାଣି କିନି ଅରେତ୍‌ ଆଇମା ୱାଜି ପିତର୍‍ତିଙ୍ଗ୍‍ ସିସୁ କାୟନିକା ସୁଡ଼ୁତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ଆୟା ଆଇମା ପିତରତିଙ୍ଗ୍‌ ନେଗେନ୍‌ କିଜି ସୁଡ଼୍‌ଜି ଇର୍ହାତ୍‌, “ନିନ୍‍ବା ନାଜରିତିୟ ଜିସୁୱାଲେ ମାର୍‍ଇ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ମାତର୍‌ ପିତର ମାନା କିଜି ଇର୍‌ଆନ୍‌, “ନାନ୍ ୱାନିଙ୍ଗ୍‌ ନେସେଏ, ମାରି ନିନ୍‌ ଇନିକା ଇଜିନି, ନାନ୍ ବୁଝାଏଜିନା ।” ଆବେଟ୍‌ ୱାନ୍‌ ଦୁଆର୍‍ ଆତ୍‌ରେ ସତା ସର୍‌ଆନ୍‌ । ଆୟାଦାପ୍ରେ କରୁ ରିଜା କେଡ଼ିତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ଆୟା ପାଣି କିନି ଆଇମା ପିତରତିଙ୍ଗ୍‌ ସୁଡ଼ୁଜି ଲାକ୍‌ତୁ ନିର୍‍ଇ ମାର୍‍ଇ ଲୋକାଙ୍ଗ୍‌ ମାରିଡ଼େସି ଇର୍ହାତ୍‌, “ଇକାନ୍‌ ୱାରିମାଣ୍‍କୁ ଅରେନ୍‍ !” ");
INSERT INTO kfcp_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ମାତର୍‌ ପିତର ମାରିଡ଼େସି ମାନାକିଜି ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ମାରି ଏସ ସମୟ ସରି ୱେନ୍‌କା ଆବେ ନିର୍‍ଇ ମାର୍‍ଇ ଲୋକ୍‌ଡର୍‌ ପିତରତିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ନିନ୍‌ ସତେନେ ୱାରି ମାଣାନ୍‌ ଅରେନ୍‍, ଇରିଙ୍ଗ୍‌ ନିନ୍‍ବାତୋ ଗାଲିଲିଦି ଲୋକୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ମାତର୍‌ ପିତର ନିଜେଦିଙ୍ଗ୍‍ ଆନାଦୁରିଆ କିଜି ମାରି ପାର୍‌ମାଣ୍‌ କିଜି ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌, “ମିର୍‌ ଏମେ ଲୋକ୍‌ତି ମାଟା ଇଜିନିଦେର୍‌, ନାନ୍ ୱାନିଙ୍ଗ୍‌ ମୁଲ୍‍କେ ନେସେଏ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ଆବେଟ୍‌, “କରୁ ରିଜା କେଡ଼ିତିଙ୍ଗ୍‍ ଆଗ୍‌ଡ଼ି ମୁଜା ନିନ୍‌ ନାଂଇ ନେସେଏ ଇଜି ଇନି,” ଜିସୁ ଇର୍‍ଇମାର୍‍ଇ ମାଟା ପିତରତି ମୋନ୍‌ତୁ ଏତ୍‌ ୱାତାତ୍‍, ମାରି ପିତର ଆୟାମାଟା ଅଡ଼୍‍ବିତାନ୍‍ନୋ ଦୁଃକ୍‌‍ତାନ୍‍ ଆଡ଼୍‍ବାଦେଙ୍ଗ୍‍ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ସାଲ୍‍ଦି ଆତି ଦାପ୍ରେ ୱିଜେରେ ପେରି ନେତାର୍‌, ସାସ୍ତ୍ରିରିୱାଲେ ପେରି ଜାଜକର୍‌ ୱିଜେରେ ଉଣ୍ତାତାରୋ ୱାର୍‌ଗିଜି ସାଜି ଜିସୁଙ୍ଗୁଁ ତର୍‍ତା ଅତାରୋ ପିଲାତ୍‌ କିୟୁଦୁ ସର୍‍ପେ କିତା ସିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ପିଲାତ୍‌ ଜିସୁଙ୍ଗୁଁ ୱେନ୍‌ବାତାନ୍‌, “ନିନ୍‌ ଇନିକା ଜିହୁଦି ଲୋକା ରାଜା ?” ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନିନ୍‍ତୋ ଆୟାମାଟା ଇଜିନି ।” ");
INSERT INTO kfcp_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ମାରି, ପେରି ଜାଜକର୍‌ ଜିସୁ ବିରୁଦ୍‍ତାନ୍‍ ନାଣ୍ତ ମାଟା ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ଆବେଟ୍‌ ପିଲାତ୍‌ ମାରିଡ଼େସି ଜିସୁଙ୍ଗୁଁ ୱେନ୍‌ବାତାନ୍‌, “ନିନୁ ଇନିକା ବା ଇନ୍‍ଇଜିନି ? ସୁଡ଼ୁଆ, ଇୟାକାର୍‌ ନି ବିରୁଦ୍‍ତାନ୍‍ ଏସୋ ମାଟା ଇଜିନାର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ମାତର୍‌ ଜିସୁ ଉଣ୍ତ୍ରି ପଦ୍‍ବା ମାଟା ଇନ୍‌ଏତାନ୍‌, ଆବେଟ୍‌ ପିଲାତ୍‌ କାବାଆତାସର୍‍ଆନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ମାତର୍‌ ୱିଜୁ ବାର୍ସେକ୍‍ ନିସ୍ତାର୍ ପଣ୍ତୟ୍‌ ସମୟତୁ ଲୋକୁ ଆମା ଜଇଲ୍‌ତୁ ମାନି ୱାନିଙ୍ଗ୍‌ ଲୋସ୍‍ସି ମାର୍‌ଆର୍‌, ୱାନିଙ୍ଗ୍‌ ପିଲାତ୍‌ ୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ଡ଼ିସିସ୍‍ ସିଜିମାର୍‍ଆନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ଏମେ ଜାଟି ଜଗଡ଼ାକିନିକାର୍‍ ସରକାର୍‍ ବିରଦ୍‌ତାନ୍‌ ଜାଟି ଜଗଡ଼ା କିତାରୋ ଲୋକାଙ୍ଗ୍‌ କାତ୍‍ତା ମାର୍‌ଆର୍‌, ୱାରିୱାଲେ ବାରବ୍‌ବା ଦର୍‌ତି ଅରେନ୍‍ ଲୋକୁ ଜଇଲ୍‌ତୁ ମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ନାସ୍ତିୱାଲେ ଉଣ୍ତାତିମାର୍‍ଇ ଲୋକ୍‌ଡର୍‌ ପିଲାତ୍‌ ଲାକ୍‌ତୁ ୱାଜି ୱାନି ରୀତିନୀତି ଦାଣ୍ତ୍‍ ଅରେନ୍‍ ଜଇଲ୍‍ତୁମାନି ୱାନିଙ୍ଗ୍‌ ଡ଼ିସିସ୍‍ କିଦେଙ୍ଗ୍‌ ଦାବି କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ଆବେଟ୍‌ ପିଲାତ୍‌ ୱାରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ମିର୍‌ ଇନିକା ବଦା କିଜିନିଦେର୍‌ ? ନାନ୍ ଇନିକା ମି ଉଣ୍ତିଙ୍ଗ୍‌ ଜିହୁଦିରି ରାଜେଙ୍ଗ୍‍ ଡ଼ିସ୍‌ନା ସିନା ନୋ ?” ");
INSERT INTO kfcp_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ଇରିଙ୍ଗ୍‌ ପିଲାତ୍‌ ନେସ୍‌ତାନ୍‌ ଜେ, ପେରି ଜାଜକର୍‌ ଜିସୁଙ୍ଗୁଁ ଗିଦ୍ରିଦାନ୍‍ ୱାନିମାନୁ ସେରେପ୍‍ତା ମାନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ମାତର୍‌ ପିଲାତ୍‌ ଏଣ୍ତେସ୍‍କି ୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ଜିସୁଙ୍ଗୁଁ ଡ଼ିସ୍‍ଏଣ୍ତା ବାରବ୍‌ବାଦିଙ୍ଗ୍‌ ଡ଼ିସ୍‍ନାନ୍‍, ଆୟା ଉଣ୍ତିଙ୍ଗ୍‌ ପେରି ଜାଜକର୍‌ ୱିଜୁ ଲୋକାଙ୍ଗ୍‌ ସୁର୍ରି ୱାର୍‍ଗିସ୍‍ କିବିସ୍‍କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ମାତର୍‌ ପିଲାତ୍‌ ଲୋକାଙ୍ଗ୍‌ ମାରିଡ଼େସି ୱେନ୍‌ବାତାନ୍‌, “ଆମାୱାନିଙ୍ଗ୍‌ ମିର୍‌ ଯିହୁଦି ଲୋକ୍‌ତି ରାଜା ଇଜିନିଦେର୍‌, ୱାନିଙ୍ଗ୍‌ ନାନ୍ ଇନିକା କିନା ?” ");
INSERT INTO kfcp_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ଲୋକ୍‌ଡର୍‌ ଆଉଲି ଆଜି ଇର୍ହାର୍‌, “ୱାନିଙ୍ଗ୍‌ କ୍ରୁସଦୁ ଏକିସ୍‍କିଦୁ !” ");
INSERT INTO kfcp_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ଆବେଟ୍‌ ପିଲାତ୍‌ ୱାରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ଏନ୍ଦା, ୱାଣ୍ତ୍ରୁ ଇନି ଦୋଷ୍‌ କିତାମାନାନ୍‌ ?” ମାତର୍‌ ଆୟା ଲୋକ୍‌ଡର୍‌ ମାରି ନାଣ୍ତନେ ଆଉଲି ଆଜି ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, “ୱାନିଙ୍ଗ୍‌ କ୍ରୁସଦୁ ଏକିସ୍‌କିଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ପିଲାତ୍‌ ଲୋକା ୱେଡ଼ିକା କିବିସ୍‍ କିଦେଙ୍ଗ୍‌ ବଦାକିତାନ୍‌ନୋ, ୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ବାରବ୍‌ବାବେଙ୍ଗ୍‍ ଜଇଲ୍‍ତାନ୍‍ ମୁକୁଡ଼ା କିବିସ୍‍ କିତାନ୍‌, ମାରି ଜିସୁଙ୍ଗୁଁ କୋର୍‍ଡା ଡାକିସ୍‍କିଜି କ୍ରୁସକାଟ୍‌ତୁ ଏକିସ୍‍କିଦେଙ୍ଗ୍‍ ସେର୍ପେକିତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ଆବେଟ୍‌ ସେନାର୍‍ ଜିସୁଙ୍ଗୁଁ ପିଲାତ୍‌ ଉଣ୍ତ୍ରି ମେଡ଼୍‍ଇଲୁଦି ଦୁଆର୍‌ତୁ ଅତାରୋ ୱିଜୁ ସେନା ଦଳତିଙ୍ଗ୍‍ କୁକ୍‌ତା ଉଣ୍ତାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ସେନାର୍‍ ଜିସୁଙ୍ଗୁଁ ସେମାର୍‍ କିଦେଙ୍ଗ୍‌ ଆକ୍‍ ରଙ୍ଗ୍‍ତି ଆଙ୍ଗିଁ ଆରିସ୍‌କିତାର୍‌ ମାରି ସାମ୍‍କା ଟୋପି କିତାରୋ ୱାନି ତାଲାଦୁ ଆରିସ୍‌କିତାର୍‌; ");
INSERT INTO kfcp_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ଆୟାୱେନ୍‌କା ସେନାର୍‍ ଜିସୁଙ୍ଗୁଁ ଏ ଜିହୁଦିରି ରାଜା, ଇଜି ମାଡ଼ିସ୍‌ କିତାର୍‍, “ମାରି ୱାନିଙ୍ଗ୍‌ ୱିଜୁଦିନ୍‌ ଜିଜି ମାନ୍‌ଆ ଇଜି ଇର୍ହାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ମାରି, ସେନାର୍‍ ଉଣ୍ତ୍ରି ବାଡିଗାଦାନ୍‍ ୱାନି ତାଲାଦୁ ଡାକ୍‍ତାର୍‍ ମାରି ୱାନି ମୁସ୍‌କୁ ପୁସ୍‌ତାର୍‌, ଆବେଟ୍‌ ୱାର୍‌ ସେମାର୍‌ କିଜି ମେଣ୍ତେଙ୍ଗ୍‌ ଗଟ୍‌କିଜି ୱାନିଙ୍ଗ୍‌ ମାଡ଼ିସ୍‌ କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ସେମାର୍‍ କିତିୱେନ୍‌କା ଆୟା ଆକ୍‍ ରଙ୍ଗ୍‍ତି ଆଙ୍ଗିଁ କୁତ୍‍ତା ରୋ ୱାନି ନିଜେଦି ଆଙ୍ଗିଁ ଆରିସ୍‌କିତାର୍‌ । ମାରି, ଇୟା ୱେନ୍‌କା ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ କ୍ରୁସଦୁ ଏକିସ୍‍ କିଦେଙ୍ଗ୍‌ ଇଜି ଆତ୍‌ରେ ସପ୍‌ତା ଅତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ଆୟାୱାଲେ ଅରେନ୍‍ କୁରିଣିୟଦୁ ବାସାନି ସିମୋନ ନାର୍‍ଦାଣ୍ତ‍ ୱାଜି ଆୟା ସାରି ସିଜି ସଲ୍‌ସି ମାର୍‌ଆନ୍‌ । ୱାଣ୍ତ୍ରୁ ଆଲେକ୍‍ଜାଣ୍ତର୍‍ ମାରି ରୁପରି ବୁବାସି ମାର୍‌ଆନ୍‌ । ସେନାର୍‍ ୱାନିଙ୍ଗ୍‌ ଜିସୁଦି କ୍ରୁସକାଟ୍‌ ପିଣ୍ଡ୍‌ଦେଙ୍ଗ୍‌ ଜାସେ କିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ମାରି, ସେନାର୍‍ ଜିସୁଙ୍ଗୁଁ ଗଲ୍‌ଗଥା ଗରନ୍‍ତୁ, ଅର୍ତାତ୍‍ “ତାଲାଦି କାପାଲ୍‌ ନାନି ଦର୍‌ତି ବାଡିଦୁ ଅତାର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ମାରି, ସେନାର୍‍ ଜିସୁଙ୍ଗୁଁ କାପୁଆନି ମାୟାମ୍‍ ମିସାତି ଅଙ୍ଗୁର୍‍ରସ୍‍ ଉଣ୍ତେଙ୍ଗ୍‌ ଜାସେକିତାର୍‍, ମାତର୍‌ ଆକା ୱାନ୍‌ ଉଣୁଏତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ୱେନ୍‌କା ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ କ୍ରୁସକାଟ୍‌ତୁ ଏକିସ୍‍କିତାର୍‍, ମାରି ଏନ୍‌ ଇନିକା ପଇନାର୍‌, ଆୟା ୱାନି ଆଙ୍ଗିଁଦିଙ୍ଗ୍‍ ବୋଟ୍‍ କିତାର୍‍ ନିଜେଦି ମାଣ୍‌କୁ ବାଗ୍‌ କିଜି ଅତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ସାଲ୍‍ଦି ନଅଟାଦୁ ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ କ୍ରୁସଦୁ ଏକିସ୍‍କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ଜିସୁଦି ବିରଦ୍‍ତୁ ଉଣ୍ତ୍ରି ମାଟା କ୍ରୁସକାଟ୍‌ତି ମୁସୁକୁ ରାସ୍‌ତା ମାରାଆତ୍‌, “ଇକାନ୍‌ ଜିହୁଦିର୍‌ ରାଜା ।” ");
INSERT INTO kfcp_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ୱାର୍‌ ଆୟା ନାଣ୍ଡିଙ୍ଗ୍ ରିଏର୍‌ ଡଙ୍ଗାଁରିଙ୍ଗ୍‌ ବା ଜିସୁୱାଲେ କ୍ରୁସକାଟ୍‌ଦୁ ଏକିସ୍‍ କିତାମାର୍‍ଆର୍‍, ଅରେନ୍‍ ୱାନିଙ୍ଗ୍‌ ଜିସୁଦି ଡେବିରି କିୟୁ ତରିଣ୍ତ୍‍ ମାରି ଅରେନ୍‍ ୱାନିଙ୍ଗ୍‌ ଜିସୁଦି ଉଣି କିୟୁ ତରିଣ୍ତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ଆବେଟ୍‌ ଦାର୍ମୁସାସ୍ତ୍ରଦି ଇୟା ବାକ୍ୟ ସତ୍‍ଆତାତ୍‍, “ୱାଣ୍ତ୍ରୁ ଡଙ୍ଗାଁରିୱାଲେ ଡଙ୍ଗାଁର୍‍ଏନ୍‍ ଇଜି ଲେକିସ୍‍ଆତାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ଆୟା ସାରି ସିଜି ସନି ଲୋକ୍‌ଡର୍‌ ୱାରି ତାଲେକ୍‍ ଦୁକ୍‍ସି ଜିସୁଙ୍ଗୁଁ ନିନ୍ଦା କିଜି ଇର୍ହାର୍‌, “ବାଃ ! ଏରେ ମନ୍ଦିର୍‌ ରୁକ୍‌ନି କିନ୍ଦା ମାରି ମୁନେଟାନ୍‍ ମାରିଡ଼େସି ତିଆର୍‌ କିନିକିନ୍ଦା; ");
INSERT INTO kfcp_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ଇଲେଇ କ୍ରୁସଦାନ୍‌ ରେସ ନିଜେଦିଙ୍ଗ୍‍ ରକିୟା କିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ପେରି ଜାଜକର୍‍ବା ଆୟାୱାଜା ସାସ୍ତ୍ରିରିୱାଲେ ୱାରି ୱାରି ଲଅ ଜିସୁଙ୍ଗୁଁ ବାସେ କିଜି ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, “ୱାଣ୍ତ୍‍ରୁ ଆଇ ଲୋକାଙ୍ଗ୍‌ ରକିୟା କିତାନ୍‌, ନିଜେଦିଙ୍ଗ୍‍ ରକିୟା କିଦେଙ୍ଗ୍‌ ଆଟ୍‌ଏଜିନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ନିନ୍‌ ଜଦି ସତ୍‌ତାନ୍‌ ଇସ୍ରାଏଲ୍‌ତି ରାଜା କ୍ରିସ୍ତ ଇୟାଦାପ୍ରେ କ୍ରୁସଦାନ୍‌ ରେସ ରାଆ, ଆକା ସୁଡ଼ୁଜି ମାପ୍‍ ନିବାନ୍‍ ବିସ୍‍ବାସ୍‍ କିନାପ୍‍ । ଆମା ରିଏର୍‌ ଡଙ୍ଗାଁର୍‍ ୱାନିୱାଲେ କ୍ରୁସଦୁ ଏକ୍‌ତାମାର୍‍ଆର୍‍, ଆକାର୍‍ ବା ଆୟାୱାଜା ମାଟା ଇଜି ବାସେ କିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ଆୟା ନାଣ୍ଡିଙ୍ଗ୍ ବାର ଗନ୍‌ଟା ସମୟ୍‌ତୁ ପୃତିବି ୱିଜୁ ସିକାଟି ଆଜି ମୁଣ୍ତ୍ରି ଗନ୍‌ଟା ସାନ୍ଦି ତେବାତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ମୁଣ୍ତ୍ରିଗନ୍‌ଟା ସମୟ୍‌ତୁ ଜିସୁ ନାଣ୍ତ ଆଉଲି ଆଜି କୁକ୍‌ସି ଇର୍‌ଆନ୍‌, “ଏଲି, ଏଲି, ଲାମା ସାବକ୍‍ଥାନୀ ?” ଅର୍ତାତ୍‍, “ଏ ନା ମାପୁରୁ, ଏ ନା ମାପୁରୁ, ନିନୁ ନାଙ୍ଗିଁ ଏନ୍ଦା ଡ଼ିସ୍‍ତି ?” ");
INSERT INTO kfcp_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ଜିସୁ ମାଟା ଇନିକା ୱେନ୍‌ଜି ଆୟା ଲାକ୍‌ତୁ ନିର୍‍ଇ ମାର୍‍ଇ ଏସ ଲୋକା ମାଣ୍‌କୁ ଏନ୍‌ ଏନ୍‌ ଇର୍ହାର୍‌, “ସୁଡ଼ୁଦୁ, ୱାଣ୍ତ୍‍ରୁ ଏଲିୟଙ୍ଗ୍‍ କୁକ୍‍ସିନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ମାରି, ଅରେନ୍‍ ଉରୁକ୍‍ସି ସଲ୍‌ସି ଉଣ୍ତ୍ରି ତୁଲାଦୁ ସଇନି ରସ୍‌ ବର୍ତି କିଜି ଆକା ଉଣ୍ତ୍ରି ବାଡିଗାଦୁ ତର୍‌ସି ଜିସୁଙ୍ଗୁଁ ଉଣ୍ତେଙ୍ଗ୍‌ ସିଜି ଇର୍‌ଆନ୍‌, “ମାଣ୍ତ୍ରୁ, ଏଲିୟ୍‌ ୱେନିଙ୍ଗ୍‌ କ୍ରୁସଦାନ୍‌ ରେପ୍‌ତେଙ୍ଗ୍‌ ୱାଜିନାନ୍‍ନୋ ରେଏନ୍‌, ସୁଣାଟ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ମାତର୍‌ ଜିସୁ ନାଣ୍ତ ଆଉଲି ଆଜି ୱାନି ଜିବନ୍‌ ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ମାରି, ମନ୍ଦିର୍‌ତୁ ପବିତ୍ର ବାଡିଦିଙ୍ଗ୍‍ ଏର୍‍ପିସିମାନି ଦୁଙ୍ଗ୍‍ନି ପାର୍‌ଦା ମୁସ୍‌କୁରାନ୍‌ ଆଡ୍‍ଗି ସାନ୍ଦି କିଜ୍‍ଜି ରୁଣ୍ତି ମକେଙ୍ଗ୍‌ ଆତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ସତସେନାପତି କ୍ରୁସଦି ଆଗ୍‌ଡ଼ି ନିର୍‍ଆନ୍‍ ନୋ ଜିସୁ ଏଣ୍ତେସ୍‌ ସାତାନ୍‍ ଆକା ସୁଡ଼ୁଜି ଇର୍‌ଆନ୍‌, “ସତେନେ, ଇକାନ୍‌ ମାପୁରୁଦି ମାରିନ୍‌ ମାର୍‌ଆନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ଏସ ଆଇମେକ୍‍ ଆକଣାନ୍‍ ସୁଡ଼ୁଜି ମାର୍‍ହେ; ୱାନିକା ଲୋଇ ମଗ୍‌ଦଲିନି ମରିୟମ୍‌, ଇସ୍ରି ଜାକୁବ ମାରି ଜୋସିଦି ଆଇସି ମରିୟମ୍‌, ମାରି ଶଲୋମୀ ମାର୍‍ହେ; ");
INSERT INTO kfcp_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ଜିସୁ ଗାଲିଲିଦୁ ମାନିୱାଲେ ୱାକ୍‍ ୱାନିୱାଲେ ତେବାଜି ୱାନି ସେବା କିଜି ମାର୍‍ହେ; ୱାନିୱାଲେ ଜିରୁସାଲମ୍‍ତୁ ୱାତି ମାର୍‍ହି ଆଇ ଏସ ଆଇମା ଆଇଲିକ୍‍ବା ଇୟାୱିଜୁ ସୁଡ଼ୁଜିମାର୍‍ହେ । ");
INSERT INTO kfcp_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ଆୟା ନାଣ୍ଡିଙ୍ଗ୍ ମିଲ୍‌ମିଲ୍‍କା ଆଜି ୱାଜି ମାର୍‌ଆତ୍‌, ମାରି ଇକା ରମ୍‌ନିନାଣ୍ତିଙ୍ଗ୍‌ ଆଗ୍‌ଡ଼ି ଦିନ୍‌ ମାର୍‌ଆତ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ହାରାମାତିୟାଦି ଜୋସେପ୍‌ ଦର୍‌ତି ଅରେନ୍‍ ଜିହୁଦି ପେରି ଦଲ୍‌ତି ୱେଙ୍ଗିଁତି ନେତା ମାର୍‌ଆନ୍‌, ୱାଣ୍ତ୍ରୁ ନିଜେ ବା ମାପୁରୁଦି ରାଜିଦିଙ୍ଗ୍‍ କାପ୍‌କିଜି ମାର୍‌ଆନ୍‌, ୱାଣ୍ତ୍ରୁ ସାହାସ୍‍ତାନ୍‍ ପିଲାତ୍‌ମାନୁ ସର୍‌ଆନ୍‌ ନୋ ଜିସୁଦି ସାତି ମେନ୍ଧଲ୍‍ ଲସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ମାତର୍‌ ଜିସୁ ସାତାସର୍‍ଆନ୍‍ ନି, ଇକା ୱେନ୍‌ଜି ପିଲାତ୍‌ କାବା ଆତାନ୍‌, ମାରି ସତସେନାପତିଙ୍ଗ୍‍ ଲାକ୍‌ତୁ କୁକିସ୍‍ସି ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, ଇନିକା ଜିସୁ ସାଜ ନାଣ୍ତ ୱେଡ଼ା ଆତାତ୍‌ନି ନୋ ? ");
INSERT INTO kfcp_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ଆୟାୱିଜୁ ପିଲାତ୍‌ ସତସେନାପତି ମାଣ୍‌କୁ ୱେର୍‍ଆନ୍‍ନୋ ଆୟା ଜିସୁଦି ସାତି ମାଡ଼ାଦିଙ୍ଗ୍‍ ଜୋସେପତିଙ୍ଗ୍‍ ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ଜୋସେପ କାଣ୍ତେକ୍‌ ଇସ୍ରି ୱାତି କଟାନ୍‍ ନୋ ଜିସୁଦି ମାଡ଼ାଦିଙ୍ଗ୍‍ କ୍ରୁସଦାନ୍‌ ରେପ୍‍ସି ତାସି ଆବେନୁ ମାଡ଼ାଦିଙ୍ଗ୍‍ ତେର୍‍ପ୍‍ତାନ୍‍ ମାରି ଗରନ୍‍ତି କାଲୁଦୁ କାର୍‍ତି ମାର୍‍ଇ ଉଣ୍ତ୍ରି ଗୁଟାଦୁ ୱାନିଙ୍ଗ୍‌ ଇଟ୍‍ଟାନ୍‍ନୋ ଗୁଟାଦି ସେର୍‌ଲାଦୁ ଉଣ୍ତ୍ରି ପେରି କାଲୁ କେର୍‍ପ୍‍ତା ଡ଼ିସ୍‍ତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ଜିସୁଙ୍ଗୁଁ ଏମେ ବାଡିଦୁ ଇଟ୍‌ତାର୍‌, ଆକା ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ ମାରି ଜୋସିଦି ଆଇସି ମରୀୟମ ସୁଡ଼ୁତେ । ");
INSERT INTO kfcp_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ରମ୍‌ନି ନାଣ୍ଡିଙ୍ଗ୍ ଜିଣାତାତ୍‍ଆକା ମଗ୍‌ଦଲିନି ମରିୟମ, ଜାକୁବରି ଆଇସି ମରିୟମ୍‌ ମାରି ଶଲୋମୀ ରକମ୍‌ ରକମ୍‌ତି ବାସ୍‌ନା ନିୟୁ କଟେ, ଏଣ୍ତେସ୍‌କି ୱାକ୍‍ ସଲ୍‌ସି ୱାନି ସାତି ମାଡ଼ାଦିଙ୍ଗ୍‍ ଉସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‌ନେ । ");
INSERT INTO kfcp_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ମାରି, ଆଦିୱାର୍‍ତୁ ନାଡ଼ାକାଦେ ୱାକୁ ଗୁଟାଦୁ ସର୍‍ହେ, ଆୟାୱାଲେ ୱେଡ଼ା ସତାମାର୍‍ଆତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ସାର୍ଦୁ ୱାକୁ ୱାର୍‍ଗିସାଜି ମାର୍‍ହେ, “ଏନ୍‌ ମା ଉଣ୍ତିଙ୍ଗ୍‌ ଗୁଟାଦି ସାରିଦୁ କେର୍‍ପ୍‍ତି ମାନି କାଲୁ କୁତ୍‌ନା ସିନାନ୍‍ ?” ଇରିଙ୍ଗ୍‌ ଆକା ନାଣ୍ତ ପେରିକା ମାର୍‌ଆତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ଆୟାୱାଲେ ୱାକ୍‍ ସୁଡ଼୍‌ତେ, ଆୟା ଗୁଟାଦୁ କେର୍‍ପ୍‍ତି ମାର୍‍ହି କାଲୁଦିଙ୍ଗ୍‌ କୁତ୍‍ତା ମାନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ୱାକ୍‍ ଗୁଟା ଲୋଇ ଡ଼ୁଗିତେନୋ ଅଡ଼ିନିଆଙ୍ଗିଁ ଆରାତି ଅରେନ୍‍ ମୁରୁଲିଙ୍ଗ୍‌ ଉଣେରି ପାଡ଼ାକା ବାସ୍‍ତି ମାରିକା ସୁଡ଼ୁତେନୋ ନାଣ୍ଡ ତିଲାତେ ସର୍‍ହେ । ");
INSERT INTO kfcp_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ଆବେଟ୍‌ ୱାଣ୍ତ୍ରୁ ୱାନିକାଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ତିଲାମାଟ୍‌,” ମିର୍‌ କ୍ରୁସଦୁ ସାତି ମାର୍‍ହି ନାଜରିତିୟ ଜିସୁଙ୍ଗୁଁ ପ‍ଇଜିନିଦେର୍‌; ୱାଣ୍ତ୍ରୁ ନିଙ୍ଗିଁତାମାନାନ୍‌, ୱାନ୍‌ ଇବେ ସିଲେନ୍‌; ସୁଡ଼ୁଦୁ, ଇୟା ବାଡିଦୁ ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ଇଟ୍‌ଟା ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ମାତର୍‌ ମିର୍‌ ସଲ୍‌ସି ୱାନି ସିସୁରିଙ୍ଗ୍‌ ମାରି ପିତର୍‍ତିଙ୍ଗ୍‍ ଇୟା କାବୁର୍‍ ୱେର୍‌ତୁ, ୱାନ୍‌ ମି ଆଗ୍‌ଡ଼ି ଗାଲିଲିଦୁ ସଲ୍‌ସିନାନ୍‌; ୱାନ୍‌ ମିଙ୍ଗିଁ ଏଣ୍ତେସ୍‌ ଇର୍‌ଆ ମାର୍‌ଆନ୍‌, ଆୟାୱାଜାନେ ମିର୍‌ ୱାନିଙ୍ଗ୍‌ ଆବେ ସୁଣିଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ଆବେଟ୍‌ ଆଇମେକ୍‍ ସତେନୋ ଗୁଟାଦାନ୍‍ ଉରୁକ୍‍ସି ସର୍‍ହେ, ଇରିଙ୍ଗ୍‌ ୱାକୁ ତିଲାଜି ତିର୍‍ଗ୍‍ଜି ମାର୍‍ହେ ମାରି କାବାଆତେ ସର୍‍ହେ ମାର୍‍ହେ, ମାରି ଏଙ୍ଗ୍‌ ଇନିକା ଇନ୍‍ଉତେ, ଏଣ୍ତେସ୍‌ ୱାକ୍‍ ତିଲାତେ ମାର୍‍ହେ । ");
INSERT INTO kfcp_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ଆଦିୱାର୍‍ତି ନାଣ୍ତିଙ୍ଗ୍ ନାଡ଼ାକାଦେ ଜିସୁ ସାତି ମାଣାନ୍‌ ମାରିଡ଼େସି ନିଙ୍ଗିଁଜି, ଆମାତାନି ମାଣାନ୍‌ ସାତ୍‍ଗୋଟା ଦୁବେଙ୍ଗ୍‍ ପେରିତା ମାର୍‌ଆନ୍‌, ଆୟା ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ତିଙ୍ଗ୍‍ ୱିଜେରିଙ୍ଗ୍‌ ଆଗ୍‌ଡ଼ି ତରାତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ୱାଦ୍‌ ସର୍ହାଦୋ, ଏମେକେଙ୍ଗ୍‍ ତାନି ସଙ୍ଗ୍‍ ଆତେ ମାର୍‍ହେ, ସିସୁରିଙ୍ଗ୍‌ କାବୁର୍‌ ସିତାତ୍‌; ୱାର୍‌ ୱିଜେରେ ଦୁଃକ୍‌ କିଜି ମାରି ଆଡ଼୍‍ବାଜି ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ଜିସୁ ସାତି ମାଣାନ୍‌ ଜିତାମାନାନ୍‍ ମାରି ତାନିଙ୍ଗ୍‍ ତରାତା ମାନାନ୍‌, ଆୟା ମାଟା ୱେନ୍‌ଜି ସିସୁର୍‍ ବିସ୍‍ବାସ୍‍ କିଏତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ଇୟାୱିଜୁ ଗଟାତି ୱେନ୍‌କା ୱାରି ଲୋଇ ରିଏର୍‌ ଉଣ୍ତ୍ରି ନାର୍‍ତୁ ସନିୱାଲେ ଜିସୁ ସାର୍ଦୁ ଆଇ ମୁର୍ତି ଆଜି ୱାରିଙ୍ଗ୍‌ ତରାୟ୍‍ଆତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ମାରି ୱାର୍‌ ସର୍‍ଆର୍‍ରୋ ଆଇ ସିସୁରିଙ୍ଗ୍‌ ଇୟା ମାଟା ଇର୍ହାର୍‌, ମାତର୍‌ ୱାରି ମାଟାଦିଙ୍ଗ୍‌ ବା ୱାର୍‌ ମାନାଏତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ସାରାସାରି ୱେନ୍‌କା ଏଗାର୍‍ ଲୋକୁ ସିସୁର୍‌ ଉଣ୍ତେଙ୍ଗ୍‌ ବାସ୍‍ତି ମାର୍‍ଇ ୱାଲେ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ତରାୟ୍‍ଆତାନ୍‍, ୱାର୍‍ ୱେର୍‌ତି ମାଟାଦିଙ୍ଗ୍‌ ୱାର୍‌ ବିସ୍‍ବାସ୍‍ କିଏତାର୍‍ ମାରି ୱାର୍‌ ତାମେ ଜିବନ୍‌ ଆଟୁୱା କିତାର୍‍, ଆୟା ଉଣ୍ତିଙ୍ଗ୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଲାଗାତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ମାରି, ଜିସୁ ସିସୁରି ଲାକ୍‌ତୁ ୱାଜି ଇର୍ହାନ୍‌, “ମିର୍‌ ସାରା ଦୁନିଆଦୁ ସଲ୍‌ସି ୱିଜୁ ଲୋକ୍‍ଜାତିଦୁ ସୁସମାଚାର୍‌ ପ୍ରଚାର୍‌ କିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ଏନ୍‌ ବିସ୍‍ବାସ୍‍ କିଜ ଡୁବନ୍‌ ଅନାନ୍‍, ୱାଣ୍ତ୍ରୁ ରକିୟା ପଇନାନ୍‍; ମାତର୍‌ ଏନ୍‌ ଅବିସ୍‍ବାସ୍‍ କିନାନ୍‍, ୱାନିଙ୍ଗ୍‌ ମାପୁରୁ ଦଣ୍ଡ୍‌ ସିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ମାରି, ବିସ୍‍ବାସ୍‍ସି ଲୋକା ଇୟାୱିଜୁ ସିନେଙ୍ଗ୍‍ ଆନେ, ୱାର୍‌ ନା ଦର୍‌ତାନ୍‌ ଦୁବେଙ୍ଗ୍‍ ପେର୍‍ନାର୍‍, ପୁନି ପୁନି ବାସାଦୁ ମାଟା ଇନାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","କିକାଙ୍ଗ୍‍ ସାରାସ୍‌କୁ ଆସ୍‌ନାର୍‌, ମାରି ଇନି ୱିସାମ୍‍ତି ମାୟାମ୍‍ ଉଟିଙ୍ଗ୍‍ ବା ୱାରି ଇନିକା ନାସ୍ଟୁ ଆଏତ୍‍; ୱାର୍‌ ନବ୍‍ଆତି ଲୋକା ମୁସ୍‌କୁ କିୟୁ ଇଟ୍‌ତିଙ୍ଗ୍‌ ୱାର୍‌ ନେଗେନ୍‍ଆନାର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ସିସୁରିଙ୍ଗ୍‌ ଇୟାୱିଜୁ ମାଟା ଇର୍‍ଇ ୱେନ୍‌କା ପ୍ରବୁ ଜିସୁ ମୁସ୍‌କୁପୁର୍‌ ସର୍‍ଆନ୍‍ନୋ ମାପୁରୁଦି ଉଣି କିୟୁ ତରିଣ୍ତ୍‍ ବାସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ମାତର୍‌ ସିସୁର୍‌ ଆୟା ବାଡିଦାଣ୍ତ୍‌ ଡ଼େସିୱାଜି ସାରା ଦୁନିଆଦୁ ଜିସୁଦି ସୁସମାଚାର୍‌ ପ୍ରଚାର୍‌ କିତାର୍‌, ମାରି ପ୍ରବୁ ୱାରିୱାଲେ ଅର୍‌ସେ ମାନ୍‌ଜି ଆୟା ସିନେଣ୍‍କୁ ଆୟା ବାକ୍ୟ ସତ୍‍ଇଜି ୱେଙ୍ଗିଁସ୍‌ଏତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ଏ ତିୟପିଲ, ଏମେକାର୍‌ ମା ଲୋଇ କିତିମାନି ଗଟେନେଙ୍ଗ୍‍ତି ନାଣ୍ତ ମାଟେଙ୍ଗ୍‌ ସତ୍‌ତାନ୍‌ ରାସ୍‌ତେଙ୍ଗ୍‌ ବଦାକିତାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ଆୟା ନିଜେଦି କାଣ୍‌ଗାଦାନ୍‌ ସୁଡ଼ୁତିମାନିକା ମାରି ବାକ୍ୟ ପ୍ରଚାର୍‌ କିଜିମାନି ଲୋକୁ ମାଙ୍ଗିଁ ୱେର୍‍ନି ଇସାବ୍‌ତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ଆରାମ୍‌ତାନ୍‌ ୱିଜୁ ବିସୟ୍‌ ଇସ୍ରିମିସ୍ରିକା ଉଣ୍ତା କିଜି ଦାଡ଼ିଦି ୱାଜା ମି ଉଣ୍ତିଙ୍ଗ୍‌ ରାସ୍‌ତେଙ୍ଗ୍‌ ନାନ୍ ବା ଟିକ୍‌ ଇଜି ଅଡ଼୍‍ବିତା, ");
INSERT INTO kfcp_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ଏଣ୍ତେସ୍‌ ନିନ୍‌ ଏମେ ୱିଜୁ ବିସୟ୍‌ ସିକିୟା ପଇତିମାନି, ଆୟାୱିଜୁ ବିସୟ୍‌ତାନ୍‌ ପୁରା ତାନି ବୁଦି ନେସ୍‌ନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ଜିହୁଦା ରାଜିଦି ରାଜା ହେରୋଦଦି ସମୟତୁ ଅବିୟ ଜାଜକତି ଦଳ୍‍ତୁ ଜିକରିୟ ଦର୍‌ତି ଅରେନ୍‍ ଜାଜକ ମାର୍ହାନ୍‌; ୱାନି ଆଡ଼୍‌ସି ହାରୋଣ କୁଟୁମ୍‍ତିକାତ୍‍ ମାର୍ହାତ୍‌, ତାନେ ଦର୍‌ ଏଲିସାବେତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ଜିକରିୟ ମାରି ଏଲିସାବେତ୍‍ ପ୍ରବୁଦି ୱିଜୁ ମାଟା ମାରି ନିୟମ୍‍ତାନ୍‍ ଇନି ଦୋସ୍‍ କିଏଣ୍ତ୍‍ଗା ମାପୁରୁମାନୁ ଦାର୍ମୁଦିକାର୍‍ ମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ମାତର୍‌ ୱାରିଙ୍ଗ୍‌ ଅରେନ୍‍ବା କଡ଼ ସିଲେତାନ୍‌, ଇରିଙ୍ଗ୍‌ ଏଲିସାବେତ୍‍ ବାଞ୍ଜି ମାର୍ହାତ୍‌, ମାରି ୱାର୍‌ ନାଣ୍ତ ଡକ୍ରା ଡକ୍ରି ଆତାମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ୱାନ୍‌ ନିଜେଦି ଦଲ୍‌ତି ପାଲିଦାନ୍‍ ମନ୍ଦିର୍‌ତୁ ମାପୁରୁଦି ପାଣି କିନିୱାଲେ, ");
INSERT INTO kfcp_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ଜାଜକତି ପାଣିଦି ନିୟମ୍‍ତାନ୍‍ କୁଡ଼ୁକୁଡ଼ି ପକ୍‌ତାର୍‌ ଆକା ୱାନି ପାଲି ୱାତାତ୍‍ ପ୍ରବୁଦି ମନ୍ଦିର୍‌ତୁ ଡ଼ୁଗୁଜି ଦୁପ୍‍ଣି ଆଡ଼େକ୍‍ତେଙ୍ଗ୍‍, ");
INSERT INTO kfcp_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ମାରି ଦୁପୁଣି ଆଡ଼ିକ୍‍ନିୱାଲେ ୱିଜୁ ଲୋକୁ ଆତ୍‌ରେ ପାର୍‌ତନା କିଜିମାର୍‍ଆର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ଆୟାୱାଲେ ପ୍ରବୁଦି ଅରେନ୍‍ ଦୁତ୍‍ ଦୁପୁଣି ଆଡ଼ିକ୍‍ନି ବାଡ଼ିଦି ଉଣେର୍‌ ତରିନ୍‌ ନିଲ୍‍ସି ଜିକରିୟଙ୍ଗ୍‍ ତରାୟ୍ ଆତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ଜିକରିୟ ଦୁତ୍‍ତିଙ୍ଗ୍‍ ସୁଡ଼ୁଜି ତିର୍‍ଗିତାନ୍‍ ମାରି ତିଲାତା ସର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ମାତର୍‌ ଦୁତ୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାତ୍‌, “ଜିକରିୟ, ତିଲାମା, ମାତର୍‌ ନିନ୍‌ ଲସ୍‍ତିକା ୱେର୍‌ଆ ମାନାନ୍‌, ମାରି ନି ଆଡ଼୍‌ସି ଏଲିସାବେତ୍‍ ମି ଉଣ୍ତିଙ୍ଗ୍‌ ଅରେନ୍‍ କଡ଼ ଜନମ୍‍ କିନାତ୍‌, ମିର୍‌ ୱାନି ଦର୍‌ ଜୋହନ ସିନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ମିର୍‌ ନାଣ୍ତ ୱେଡ଼ିକା ଆନିଦେର୍‌, ମାରି ୱାନି ଜନମ୍‌ ଆତି ଉଣ୍ତିଙ୍ଗ୍‌ ନାଣ୍ତ ଲୋକୁ ୱେଡ଼ିକା କିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ୱାନ୍‌ ପ୍ରବୁଦି ଲାକ୍‌ତୁ ପେରିକାନ୍‌ ଆନାନ୍‌; ୱାନ୍‌ ଅଙ୍ଗୁର୍‍ରସ୍‍ ମାରି କାଡ଼ୁ ଏସ୍‌କାଙ୍ଗ୍‌ବା ଉଣୁଏନ୍‌, ମାରି ୟାୟା ପଟା ଲୋଇରାନ୍‌ନେ ପବିତ୍ରଆତ୍ମାଦୁ ପୁରା ତେବାନାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ମାରି ୱାନ୍‌ ଇସ୍ରାଏଲ୍‌ତି କଡ଼ରି ମାଣ୍‌କୁ ୱିଜୁଲୋକାଙ୍ଗ୍‌ ପ୍ରବୁ ୱାରି ମାପୁରୁମାନୁ ଡ଼େସି ତାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ବୁବାରି ଜିବନ୍‌ କଡ଼ରି ଉଣ୍ତିଙ୍ଗ୍‌ ମାରି ମାନାଇୱାରିଙ୍ଗ୍‍ ଦାର୍ମୁଲୋକ୍‍ତି ବୁଦିଦୁ ସାଲାକିବିସ୍‍ କିଜି ଡ଼େପ୍‍ସିତାତେଙ୍ଗ୍‍ ମାରି ପ୍ରବୁଦି ଉଣ୍ତିଙ୍ଗ୍‌ ନେଗେନ୍‍ତିଆର୍‍କିତି ଉନ୍‍ଣ୍ତ୍ରି ଲୋକ୍‍ଦଲ୍‍ତିଙ୍ଗ୍‍ ତିଆର୍‌ କିଦେଙ୍ଗ୍‌ ୱାନ୍‌ ଏଲିୟଦି ଆତ୍ମା ମାରି ସାକ୍ତିଦାନ୍ ୱାନି ଆଗ୍‌ଡ଼ି ବୁଲାନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ଆବେଟ୍‌ ଜିକରିୟ ଦୁତ୍‍ତିଙ୍ଗ୍‍ ଇର୍‌ଆନ୍‌, “ନାନ୍ ଏଣ୍ତେସ୍‌ ଇକା ନେସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‍ନା ? ଇରିଙ୍ଗ୍‌ ନାନ୍ ତୋ ଡକ୍ରା, ମାରି ନା ଆଡ଼ିଙ୍ଗ୍‍ ନାଣ୍ତ ବାର୍ସେକ୍‍ ଆତାତ୍‌ନି ।” ");
INSERT INTO kfcp_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ଦୁତ୍‍ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନାନ୍ ଗାବ୍ରିଏଲ,” ନାନ୍ ମାପୁରୁ ଲାକ୍‌ତୁ ନିଲ୍‍ସିମାନି ଦୁତ୍‍, ମାରି ନିଙ୍ଗିଁ ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ମାରି ଇୟା ନେଗି କାବୁର୍‌ ୱେର୍‌ତେଙ୍ଗ୍‌ ନାନ୍ ମାପୁରୁ ମାଣ୍‌କୁ ୱାତାମାନା । ");
INSERT INTO kfcp_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","“ସୁଡ଼ୁଆ, ଇୟାୱିଜୁ ଗଟାଇ ଦିନ୍‌ ସାନ୍ଦି ନିନ୍‌ ଗୁଲା ଆଜି ୱାର୍‍ଗିଦେଙ୍ଗ୍‍ ଆଟ୍‍ଇ, ଇରିଙ୍ଗ୍‌ ନା ଏମେ ୱିଜୁ ବାକ୍ୟ ଟିକ୍‌ ସମୟତୁ ସତ୍‌ ଆନାତ୍‌, ଆୟାୱିଜୁ ନିନ୍‌ ବିସ୍‌ବାସ୍‌ କିଇତି ।” ");
INSERT INTO kfcp_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ଇୟାୱାଲେ ଲୋକୁ ଜିକରିୟଙ୍ଗ୍‍ କାପ୍‌କିଜି ମାର୍‌ଆର୍‌, ମାରି ମନ୍ଦିର୍‌ତୁ ୱାନି ୱେଡ଼ା କିନିକା ସୁଡ଼ୁଜି ୱାର୍‌ କାବାଆଜି ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ମାତର୍‌ ୱାନ୍‌ ସହସି ୱାଜି ୱାରିଙ୍ଗ୍‌ ୱାର୍‍ଗିଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏତାନ୍‍; ଆବେଟ୍‌ ୱାନ୍‌ ମନ୍ଦିର୍‌ତୁ ଦର୍ସନ ପଇତାମାନାନ୍‍ ଇଜି ୱାର୍‌ ବୁଜାତାର୍‍, ମାରି ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଜୁଟ୍‍ସି ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ ମାରି ଗୁଲା ଆତା ତେବାତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ୱେନ୍‌କା ୱାନି ସେବା ପାଲିଦି ଦିନ୍‍ୱିଜୁ ୱିଜିତାତ୍‌, ମାରି ୱାନ୍‌ ୱାନି ଇନ୍‌ଡ୍ର ସର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ତାନେ ୱେନ୍‌କା ୱାନି ଆଡ଼୍‌ସି ଏଲିସାବେତ୍‍ ପଟାଦୁ ଆତାତ୍‌, ମାରି ୱାଦ୍‌ ପାସ୍‌ଗୋଟା ଲେଜ୍‌କୁ ସାନ୍ଦି ଏଙ୍ଗ୍‌ବା ଇନ୍‍ଏଣ୍‍ଗା ମାର୍‌ଆତ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ଆବେଟ୍‌ ୱାଦ୍‌ ଇର୍ହାତ୍‌, “ଲୋକା ମାଣ୍‌କୁ ନା ଅପ୍‍ମାନ୍‍ ଆକ କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ପ୍ରବୁ ନାଙ୍ଗିଁ ସୁଡ଼ୁଜି ନା ଉଣ୍ତିଙ୍ଗ୍‌ ଇୟାୱାଜା କିତାମାନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ଏଲିସାବେତ୍‍ ସଗୋଟା ଲେଜ୍‌କୁ ୱେନ୍‌କା ଗାବ୍ରିଏଲ ଦୁତ୍‌ ମାପୁରୁ ମାଣ୍‌କୁ ଗାଲିଲିଦି ନାଜରିତ ଦର୍‌ତି ଗାଡ଼୍‌ତୁ ଅରେତ୍‌ ରିପା ଆଇଲି ଲାକ୍‌ତୁ ୱାତାନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ଦାଉଦତି କୁଟୁମ୍‌ତି ଜୋସେପ ଦର୍‌ତି ଅରେନ୍‍ ମେମାରି ୱାଲେ ତାନିଙ୍ଗ୍‌ ପେଡ଼ି କିଦେଙ୍ଗ୍‌ ଲସ୍‌ତା ମାର୍‌ଆର୍‌; ଆୟା ଆଇଲିଦି ଦରୁ ମରିୟମ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ମୁସ୍‌କୁପୁର୍‌ତି ଦୁତ୍‌ ଇନ୍‌ଣ୍ତ୍ର ଡ଼ୁଗିତାଦୋ ତାନେ ଲାକ୍‌ତୁ ୱାଜି ଇର୍ହାତ୍‌, “ମାଡ଼ିସ୍‍ନା, ଏ ଆଇଲି, ନିନୁ ନେଗେନ୍‌ ମାନାଆ, ପ୍ରବୁ ନି ୱାଲେ ମାନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ମାତର୍‌ ଦୁତ୍‍ତି ମାଟା ମରିୟମ୍‌ ୱେନ୍‌ଞ୍ଜି ନାଣ୍ତ କାବାଜି ଇକା ଏଣ୍ତେସ୍‌ମାରି ମାଟା ଇଜି ମନ୍‌ତୁ ଅଡ଼ବିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ଆବେଟ୍‌ ଦୁତ୍‌ ତାନେଙ୍ଗ୍‌ ଇର୍ହାତ୍‌, “ଏ ମରିୟମ୍‌, ତିଲାମା, ମାତର୍‌ ନିନୁ ମାପୁରୁମାନୁ ଦୟା ପଇତିମାନି । ");
INSERT INTO kfcp_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ମାରି ସୁଡ଼ୁଆ, ନିନୁ ପଟାଦୁ ଆନିନୋ ଅରେନ୍‍ କଡ଼ ଜନମ୍‌ ସିନି ମାରି ୱାନି ଦର୍‌ ଜିସୁ ସିନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ୱାନ୍‌ ପେରିକାନ୍‌ ଆନାନ୍‌ ମାରି ମାପ୍‌ରୁ ମାରିନ୍‌ ଇଜି ୱେଙ୍ଗ୍‌ଁନାନ୍‌; ମାରି ପ୍ରବୁ ମାପ୍‌ରୁ ୱାନିଙ୍ଗ୍‌ ୱାନି ଡକ୍ରାଦାଦା ଦାଉଦଦି ୱାଜା ରାଜା କିନାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ୱାନ୍‌ ଜାକୁବରି କୁଟୁମ୍‌ତି ମୁସ୍‌କୁ ଜୁଗ୍‍ ଜୁଗ୍‍ ସାନ୍ଧି ସାସନ୍‍ କିନ୍‌ନାନ୍‌, ମାରି ଜିସୁଦି ରାଜି ଏସ୍‌କାଙ୍ଗ୍‌ବା ୱିଜେଏତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ମାତର୍‌ ମରିୟମ୍‌ ଦୁତ୍‌ତିଙ୍ଗ୍‌ ଇର୍ହାତ୍‌, “ଇକା ଏଣ୍ତେସ୍‌ ଆନାତ୍‌ ?” ନାନ୍ ତୋ ମେମାରିଙ୍ଗ୍‍ ନେସେଏ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ଦୁତ୍‌ ତାନେଙ୍ଗ୍‌ ଇର୍ହାତ୍‌, “ପବିତ୍ର ଆତ୍ମା ନି ମୁସ୍‌କୁ ୱାନାତ୍‌ ମାରି ପେରି ମାପୁରୁଦି ସାକ୍ତି ନିଂଇ ଆସ୍‌ନାତ୍‌, ଏନ୍‌ ଜନମ୍‌ ଆନାନ୍‌, ୱାନ୍‌ ପବିତ୍ର ମାରି ମାପ୍‌ରୁଦି ମାର୍‌ସି ଇଜି ୱେଙ୍ଗ୍‌ଁନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ମାରି ସୁଡ଼ୁଦୁ, ମି ଲୋକ୍‍ବାକ୍‍ ଏଲିସାବେତ୍‍ ବା ଡକ୍ରି ଆତି ୱାଲେନେ ଉଣ୍ତ୍ରି କଡ଼ଦିଙ୍ଗ୍‌ ପଟାଦୁ ଆସ୍‌ତା ମାନାତ୍‌ । ଏଦ୍‌ ବାଞ୍ଜି ଇଜି ୱେଙ୍ଗିଁତା ମାର୍‌ଆତ୍‌, ତାନେଙ୍ଗ୍‌ ଇଲେଇ ସଗୋଟା ଲେଜ୍‌କୁ ଆଜିନାତ୍‍; ");
INSERT INTO kfcp_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ମାତର୍‌ ମାପୁରୁଦିମାଣ୍‌କୁ ସୋନି ୱିଜୁ ବାକ୍ୟ ସତ୍‌ ଆନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ଆବେନୁ ମରିୟମ୍‌ ଇର୍ହାତ୍‌, “ସୁଡ଼ୁଦୁ, ନାନୁ ପ୍ରବୁଦି ସେବାକିନିକିନ୍ଧା; ନି ବାକ୍ୟଦି ୱାଜା ନା ଉଣ୍ତିଙ୍ଗ୍‌ ଗଟାପିତ୍‌ ।” ତାନେ ୱେନ୍‌କା ଦୁତ୍‌ ତାନେ ଲାକ୍‌ତୁରାନ୍‌ ସର୍‌ଆତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ଆୟା ସମୟତୁ ମରିୟମ୍‌ ନିଙ୍ଗିଁଜି ଗରନ୍‌ ରାଜି ତରିଟି ଜିହୁଦା ଦେଶ୍‌ତି ଉଣ୍ତ୍ରି ଗାଡ଼୍‌ତୁ ବେଗି ସର୍‌ଆତ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ମାରି ଜିକରିୟରି ଇଲୁ ଲୋଇ ଡ଼ୁଗିତାଦୋ ଏଲିସାବେତ୍‍ତିଙ୍ଗ୍‌ ମାଡ଼ିସ୍‌ କିତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ମାରି, ଏଲିସାବେତ୍‍ ମରିୟମ୍‌ତି ମାଡ଼ିସ୍‌ନିକା ୱେର୍‍ଇଦାପ୍ରେ ଇସ୍ରି କଡ଼ ତାନି ପଟାଦୁ ଗାତିସ୍‌ ନିଙ୍ଗିଁତାନ୍‌, ଏଲିସାବେତ ପବିତ୍ର ଆତ୍ମାଦୁ ପୁରା ତେବାଜି ");
INSERT INTO kfcp_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ନାଣ୍ତ ଆଉଲି ଆଜି ଇର୍ହାତ୍‌, “ଆଇମେକା ମାଣ୍‌କୁ ନିନୁ ଦନ୍ୟ, ମାରି ଦନ୍ୟ ନି ପଟାଦି ପଲ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ମାରି, ନା ପ୍ରବୁଦି ୟାୟା ଜେ ନା ଲାକ୍‌ତୁ ୱାନାତ୍‌, ନା ଇୟା ନେଗିକା ଏମେଣ୍‌କୁ ଆତାତ୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ମାତର୍‌ ସୁଡ଼ୁଦୁ, ନି ମାଟାଦି ବଲୁ ନା ଗିତଣିଦୁ ଇତି ଦାପ୍ରେ ଇସ୍ରି କଡ଼ ନା ପଟାଦୁ ୱେଡ଼ିକାଦାନ୍‌ ଗାତିସି ନିଙ୍ଗିଁତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ଏନ୍‌ ବିସ୍‌ବାସ୍‌ କିତାନ୍‍, ୱାନ୍‌ ଦନ୍ୟ, ଇରିଙ୍ଗ୍‌ ପ୍ରବୁମାଣ୍‌କୁ ୱାନିଙ୍ଗ୍‌ ଆମା ଆମାକା ୱେର୍‌ତାମାନାର୍‌, ଆୟାୱିଜୁ ପୁରା ଆନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ଆବେଟ୍‌ ମରିୟମ୍‌ ଇର୍ହାତ୍‌, “ନା ଜିବନ୍‌ ପ୍ରବୁଙ୍ଗ୍‌ ପ୍ରସଂସା କିଜିନାତ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ମାରି ନା ଆତ୍ମା ନା ରକିୟା କିନି ମାପ୍‌ରୁମାନୁ ୱେଡ଼ିକା କିଜିନାତ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ନିଜେଦି ଦାସିଦି କାକୁର୍ତିଦିଙ୍ଗ୍‍ ସୁଡ଼ୁତାମାନାନ୍‌ । ମାରି ସୁଡୁଆ, ଇଲେରାନ୍‍ ଜୁଗ୍‍ ଜୁଗ୍‍ ସାନ୍ଦି ୱିଜେରେ ନାଙ୍ଗିଁ ଦନ୍ୟ ଇଜି ଇନାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ମାତର୍‌ ସାକ୍ତିମାନି ମାପୁରୁ, ୱାନ୍‌ ନା ଉଣ୍ତିଙ୍ଗ୍‌ ପେରି ପାଣି କିତାମାନାନ୍‌; ୱାନି ଦରୁ ପବିତ୍ର । ");
INSERT INTO kfcp_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ମାରି ଏର୍‌ ୱାନିଙ୍ଗ୍‌ ମାନାନାର୍‌ ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଜୁଗ୍‍ ଜୁଗ୍‍ ସାନ୍ଦି ଦୟା କିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ୱାନ୍‌ ୱାନି କିୟୁଦି ସାକ୍ତି ତର୍‌ତାମାନାନ୍‌, ଆକାର୍‌ଆନିୱାରିଙ୍ଗ୍‌ ୱାରି ମନ୍‍ତୁ ଅଡ଼୍‌ବିତିମାର୍‌ଇ ମାଟାଦିଙ୍ଗ୍‌ ଇନିଙ୍ଗାଁ ଆନିଙ୍ଗାଁ କିତାମାନାନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ୱାନ୍‌ ରାଜାରିଙ୍ଗ୍‌ ବାସ୍‌ନି ବାଡିଦାନ୍‌ ଆଡ୍‍ଗି ରେପ୍‌ତାମାନାନ୍‌, ସିଲିସାତିୱାରିଙ୍ଗ୍‌ ମୁସ୍‌କୁ ନିକ୍‍ତାମାନାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ୱାନ୍‌ ବାଙ୍ଗାଁଆତିୱାରିଙ୍ଗ୍‌ ନେଗି ନେଗି ବିସୟ୍‌ ସିଜି ପାଜିସ୍‍ କିତାମାନାନ୍‌, ମାରି ମାଜନ୍‌ ଲୋକାଙ୍ଗ୍‌ ୱାର୍‌ଇ କିୟୁଦାନ୍‌ ପୋକ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ମା ପୁର୍ବେଦିଡକ୍ରାଦାଦାରି ଉଣ୍ତିଙ୍ଗ୍‌ ରାସ୍‍ତିମାନି ୱାରି ବାକ୍ୟଦାନ୍‌ ଆୟା ଅବ୍ରାହାମ ମାରି ଇସ୍ରାଏଲ୍‌ତି କଡ଼କକ୍ରାରି ଉଣ୍ତିଙ୍ଗ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ଜୁଗ୍‌ ଜୁଗ୍‌ ସାନ୍ଦି ଦୟା ଏତ୍‌କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ନିଜେଦି ଦାସ୍‌ ଅବ୍ରାହାମ ନି ଇସ୍ରାଏଲତିଙ୍ଗ୍‌ ନେଗିକା କିତାମାନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ମରିୟମ୍‌ ପୁରା ମୁଣ୍ତ୍ରି ଲେଜ୍‌କୁ ଏଲିସାବେତ୍‍ ୱାଲେ ମାନ୍‌ଞ୍ଜି ନିଜେଦି ଇନ୍‌ଣ୍ତ୍ର ଡ଼େସି ସର୍‌ଆତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ୱେନ୍‌କା ଏଲିସାବେତ୍‍ତି ଜନମ୍‌କିନି ଦିନ୍‌ ଇଗା ୱାତାତ୍‍, ୱାଦ୍‌ ଅରେନ୍‍ କଡ଼ ଜନମ୍‌ କିତାତ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ମାରି ପ୍ରବୁ ଜେ ତାନି ଉଣ୍ତିଙ୍ଗ୍‌ ନାଣ୍ତ ଦୟା କିତାମାନାନ୍, ଇକା ୱେନ୍‌ଞ୍ଜି ତାନି ଲାକ୍‌ତୁରି ଲୋକୁ ମାରି ନିଜେଦି ଲୋକୁ ତାନି ୱାଲେ ୱେଡ଼ିକା କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","କଡ଼ଦି ଜନମ୍‌ ଆତି ଆଟ୍‍ଦିନ୍‍ତୁ ୱାର୍‌ କଡ଼ଦିଙ୍ଗ୍‌ ସୁନ୍ନତ କିଦେଙ୍ଗ୍‌ ତାତାର୍‌ ମାରି ୱାରି ବୁବାସି ଦର୍‌ ଇସାବ୍‌ତାନ୍‌ ୱାନି ଦର୍‌ ଜିକରିୟ ସିଦେଙ୍ଗ୍‍ ବଦା କିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ମାତର୍‌ ୱାନି ଆଇସି ଇର୍ହାତ୍‌, “ସିଲେ, ୱାନି ଦର୍‌ ଯୋହନ ଆନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ୱାର୍‌ ଏଲିସାବେତ୍‍ତିଙ୍ଗ୍‌ ୱେର୍‌ତାର୍‌, “ମି ଲୋକାମାନୁ ତୋ ଇୟା ଦର୍‌ ଏଙ୍ଗ୍‌ବା ସିଲେତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ଆବେଟ୍‌ ୱାନିଙ୍ଗ୍‌ ଏମେ ଦର୍‌ ସିନାଟ୍‌ ଇଜି ୱାନି ବୁବାସି ବଦା କିଜିନାନ୍‌, ଆକା ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ସିନା ସିଜି ୱେନ୍‌ବାଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ଆବେନୁ ୱାନ୍‌ ଉଣ୍ତ୍ରି ରାସ୍‌ନି ପାଟା ଲସ୍‌ସି ଇକା ରାସ୍‌ତାନ୍‌, “ୱାନି ଦର୍‌ ଜୋହନ ।” ଆବେଟ୍‌ ୱିଜେରେ କାବାଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ମାରି, ଆୟାଦାପ୍ରେ ଜିକରିୟଦି ୱେୟୁ ରେଆତାତ୍‌ ମାରି ୱାନ୍‌ ମାରିଡ଼େସି ମାଟା ୱାର୍‌ଗିଜି ମାପ୍‌ରୁଦିଙ୍ଗ୍‌ ଦନ୍ୟବାଦ୍‌ କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ଆବେନୁ ୱାରି ଲାକ୍‌ତୁରି ଲୋକୁ ୱିଜେରେ ତିଲାତାର୍‌, ମାରି ଇୟାୱିଜୁ ମାଟା ଜିହୁଦା ଦେସ୍‌ତି ଗରନ୍‌ ରାଜିଦି ୱିଜୁ ତରିଣ୍ତ୍‌ ଲୋକୁ ଇନ୍‌ଞ୍ଜି ସାତାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ମାରି ୱେନି ଲୋକ୍‌ଡର୍‌ ଆୟାୱିଜୁ ନିଜେ ନିଜେଦି ମନ୍‍ତୁ ଇଡ୍‌ଜି ଇର୍ହାର୍‌, “ଇୟା ଇସ୍ରି କଡ଼ ଆତିଙ୍ଗ୍‌ ଇନିକା ଆନାନ୍‌ ?” ଇରିଙ୍ଗ୍‌ ଇକା ସତ୍‌ ମାର୍‌ଆତ୍‌ ଜେ ପ୍ରବୁଦି କିୟୁ ୱାନି ମୁସ୍‌କୁ ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ମାରି, ଜୋହନଦି ବୁବା ଜିକରିୟ ପବିତ୍ର ଆତ୍ମାଦୁ ପୁରା ତେବାଜି ଇୟା ବାବବାଣି ଇର୍ହାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“ଦନ୍ୟ ପ୍ରବୁ, ଇସ୍ରାଏଲ୍‌ତି ମାପ୍‌ରୁ, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ କାର୍ମୁ ସୁଡ଼ୁଜି ନିଜେଦି ଲୋକା ଉଣ୍ତିଙ୍ଗ୍‌ ରକିୟା କିତାମାନାନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ୱାନ୍‌ ନିଜେଦି ଦାସ୍‌ ଦାଉଦଦି କୁଟୁମ୍‌ତି ଅରେନ୍‍ ସାକ୍ତିମାନି ରକିୟା କିନିୱାନିଙ୍ଗ୍‍ ମାଙ୍ଗିଁ ସିତାମାନାନ୍‌ ");
INSERT INTO kfcp_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ପୁର୍ବେ କାଡ଼ାଦାନ୍‌ ନିଜେଦି ପବିତ୍ର ବାବବାଦିରି ୱେୟୁଦାନ୍‌ ଏଣ୍ତେସ୍‌ ଇର୍ହା ମାର୍‌ଆର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ଆୟାୱାଜା ମା ସାତ୍ରୁରିମାଣ୍‌କୁ ମାରି ମାଙ୍ଗିଁ ୱିଜୁ କାଡ଼୍‍ନିୱାରି କିକାଣ୍‌କୁ ରକିୟା କିତାମାନାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ଏଣ୍ତେସ୍‌ ୱାନ୍‌ ମା ପୁର୍ବେଦିଡକ୍ରାଦାଦାରି ଉଣ୍ତିଙ୍ଗ୍‌ ଦୟା ତର୍‌ନାନ୍‌ ମାରି ୱାରି ୱାଲେ କିତିମାନି ନିଜେଦି ଆୟା ନିୟମ୍‌ ଏତ୍‍କିନାର୍ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ଆମାକା ୱାନ୍‌ ମା ବୁବା ଅବ୍ରାହାମତି ଲାକ୍‌ତୁ ପାର୍‌ମାଣ୍‌ କିତାମାର୍ହାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ମାରି ମାପ୍‌ ମା ସାତ୍ରୁରିକିୟୁଦାନ୍‌ ରକିୟା ପୟ୍‍ତାମାନାପ୍‍, ");
INSERT INTO kfcp_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ଏଣ୍ତେସ୍‌ ମାପ୍‌ ଜିନି ସାନ୍ଧି ତିଲାଏଣ୍‌ଗା, ପବିତ୍ରଦାନ୍‌ ମାରି ଦାର୍ମୁଦାନ୍‌ ୱାନି ସେବା କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାପ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“ଏ ମାରିନ୍‌, ନିନ୍‌ ୱିଜେରିଙ୍ଗ୍‌ ପେରି ମାପୁରୁଦି ଅରେନ୍‍ ବାବବାଦି ଇଜି ୱେଙ୍ଗ୍‌ନି । ନିନ୍‌ ପ୍ରବୁଦି ଅରେନ୍‍ ଦୁତ୍‌ ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ୱାନି ସାରି ତିଆର୍‌ କିନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ପାପ୍‌କେମା ପଇନି ମାଣାନ୍‌ ୱାର୍‌ ଜେ ରକିୟା ପୟନାର୍‌, ୱାନି ଲୋକାଙ୍ଗ୍‌ ଇୟା ମାଟା ଇଣ୍ତ୍ରେଙ୍ଗ୍‌ ସନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ମାରି ମା ମାପୁରୁ କାର୍ମୁସୁଣିକାନ୍‌ ମାରି କଡ଼୍‌କିଜିବନ୍‌ ୱାନ୍‌ ମା ଉଣ୍ତିଙ୍ଗ୍‌ ରକିୟାଦି ୱେଡ଼ା ସପ୍‌ନାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ଏମେକାର୍‌ ସାନିୱାଜା ସିକାଟିଦି ସିତିଡ଼ିଦୁ ବାସାନାର୍‌, ସାନ୍ତି ସାରିଦୁ ୱାରିଙ୍ଗ୍‌ ତର୍‌ସି ଅନିଉଣ୍ତିଙ୍ଗ୍‌ ୱାନ୍‌ ୱିଜେରି ମୁସ୍‌କୁ ଜାୟ୍‌ ସିନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ମାରି, କଡ଼ ପିର୍‌ଜି ଆତ୍ମାଦୁ ବପୁ ଆଦେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ ମାରି ଇସ୍ରାଏଲ୍‌ ଲୋକା ଲାକ୍‌ତୁ ତରାଇ ସାନ୍ଧି ସୁନ୍‌ସାନ୍‌ ବାଡ଼ିଦୁ ତେବାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ଆୟାୱାଲେ ରୋମିୟ ଦେସ୍‍ତି ପେରିରାଜା ଅଗସ୍ଟ କାଇସର୍‍ ମାଣ୍‌କୁ ଦେସ୍‍ତି ୱିଜୁ ଲୋକା ଦର୍‌କୁ ରାସାନି ଉଣ୍ତିଙ୍ଗ୍‌ ମାଟା ୱେର୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ସିରିଆଦି ସାସନ୍‌କିନି କୁରିଣିୟଦି ସମୟତୁ ପାର୍‍ତୁମ୍‍ତୁ ଇୟା ଲୋକୁ ଲେକିସ୍‌କିନିକା ଆତାମାର୍‌ଆତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ଆୟା ଉଣ୍ତିଙ୍ଗ୍‌ ୱିଜେରେ ଦର୍‌ ରାସ୍‌ନି ଉଣ୍ତିଙ୍ଗ୍‌ ନିଜେ ନିଜେଦି ଗାଡ଼୍‌କାଙ୍ଗ୍‌ ସର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ମାରି, ଜୋସେପ ବା ଦର୍‌ ରାସ୍‌ନି ଉଣ୍ତିଙ୍ଗ୍‌ ମରିୟମତି ୱାଲେ ଗାଲିଲିଦି ନାଜରିତ ଗାଡ଼୍‌ତାନ୍‍ ଜିହୁଦା ଦେସ୍‍ତି ବେତଲିହିମ୍‍ ଦର୍‌ଦି ଦାଉଦତି ଗାଡ଼୍‌ତୁ ସର୍‌ଆର୍‌, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ଦାଉଦତି କୁଟ୍‌ମୁ ମାରି କୁଦାଦି ଲୋକୁ ମାର୍‌ଆର୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ଜୋସେପ ପେଡ଼ି ଆଦେଙ୍ଗ୍‌ ଲସ୍‌ସାୟ୍‌ଆତି ମରିୟମତି ୱାଲେ ଦର୍‍ ରାସ୍‌ତେଙ୍ଗ୍‍ ସର୍ହାନ୍‌ । ମାରି ମରିୟମ୍‌ ପଟାଦୁ ମାର୍‌ଆତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ଜୋସେପ ମାରି ମରିୟମ୍‌ ବେତଲିହିମତୁ ମାର୍‌ଇ ୱାଲେ ମରିୟମତି ଜନମ୍‌କିନି ବେଡ଼ା ଇଗା ୱାତାତ୍‍, ");
INSERT INTO kfcp_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ୱାଦ୍‌ ନିଜେ ପର୍‌ତୁମ୍‌ କଡ଼ଦିଙ୍ଗ୍‌ ଜନମ୍‌ କିତାତ୍‌ କଡ଼ଦିଙ୍ଗ୍‌ ୱାତିଦୁ ତେର୍‌ପ୍‌ସି ଡ଼ାକ୍‍ ଏର୍‌ଉଣି ଟଙ୍ଗାଁଦୁ ତେର୍‌ପ୍‍ତାତ୍‍, ଇରିଙ୍ଗ୍‌ ତେବାନି ଇନ୍‌ଡ୍ର ୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ବାଡି ସିଲେତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ଆୟା ରାଜିଦି ଏସ ଗୋଡ଼ୁଙ୍ଗୁଁ ଆତ୍‌ରେ ମାନ୍‌ଞ୍ଜି ନାଡ଼ା ୱାରି ମେଣ୍ତେଙ୍ଗ୍‌ କାପ୍‌କିଜିମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ପ୍ରବୁଦି ଉଣ୍ତ୍ରି ଦୁତ୍‌ ୱାରି ଲାକ୍‌ତୁ ୱାତାତ୍‍, ମାରି ପ୍ରବୁଦି ଗୌରବ୍‍ତି ଜାୟ୍‌ ୱାରି ସାର୍‌ବେଡ଼୍‌ତି ତରିତାତ୍‌, ମାରି ୱାର୍‌ ନାଣ୍ତ ତିଲାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ଆବେଟ୍‌ ଦୁତ୍‌ ୱାରିଙ୍ଗ୍‌ ୱେର୍‌ତାତ୍‌, “ତିଲାମାଟ୍‌, ସୁଡ଼ୁଦୁ, ନାନ୍ ୱିଜୁ ଲୋକା ନାଣ୍ତ ୱେଡ଼ିକାଦି ନେଗି କାବୁର୍‌ ମିଙ୍ଗିଁ ୱେର୍‌ସିନା, ");
INSERT INTO kfcp_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ଇରିଙ୍ଗ୍‌ ନେର୍‌ ଦାଉଦତି ଗାଡ଼୍‌ତୁ ମି ଉଣ୍ତିଙ୍ଗ୍‌ ରକିୟାକିନିକାନ୍‌ ଜନମ୍‌ ଆତାମାନାନ୍‌, ୱାନ୍‌ କ୍ରିସ୍ତ ପ୍ରବୁ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ମାରି, ମି ଉଣ୍ତିଙ୍ଗ୍‌ ଇକା ସିନାଦି ୱାଜା ଆନାତ୍‌, ମିର୍‌ ଅରେନ୍‍ କଡ଼ଦିଙ୍ଗ୍‌ ୱାତିଦାନ୍‌ ତେରେପ୍‌ସି ସାଡ଼ାଦି ଟଙ୍ଗାଁଦୁ ଡର୍‌ନିମାନିକା ସୁଣିଦେର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ମାରି, ଆୟାଦାପ୍ରେ ଆୟା ଦୁତ୍‌ତି ୱାଲେ ମୁସ୍‌କୁପୁର୍‌ତାନ୍‌ ଉଣ୍ତ୍ରି ଦୁତ୍‍କା ଦଲ୍‌ ଇଗାୱାତେନୋ ମାପୁରୁଦିଙ୍ଗ୍‌ ପ୍ରସଂସା କିବୁ କିବୁ ଇରେଏ, ");
INSERT INTO kfcp_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“ମୁସ୍‌କୁପୁର୍‌ତୁ ମାପୁରୁଦିଙ୍ଗ୍‌ ମହିମା ଆପିତ୍‌, ମାରି ଇୟାୱିଜୁ ଦୁନିଆଦି ଏମେ ଲୋକା ମୁସ୍‌କୁ ମାପ୍‌ରୁ ୱେଡ଼ିକା ମାନାନ୍‌ ଆୟା ଲୋକାମାନୁ ସାନ୍ତି ରାପ୍‌ତି ।” ");
INSERT INTO kfcp_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ଦୁତ୍‌କୁ ୱାରିମାଣାନ୍‌ ମୁସ୍‌କୁପୁର୍‌ତୁ ସର୍‌ଇ ୱେନ୍‌କା ମେଣ୍ଡେଙ୍ଗ୍‌ ସାରାକିନିକାର୍‌ ନିଜେ ନିଜେଦି ମାନୁ ୱାର୍‍ଗିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାର୍‌, “ରାଦୁ, ମାଡ୍‌ ବେତଲିହିମ୍‍ ସାନ୍ଧି ସନାଟ୍‌ ମାରି ପ୍ରବୁ ମାଙ୍ଗିଁ ଇୟା ଏମେ ଗଟନା ବିସୟ୍‌ ୱେର୍‌ତାନ୍‌, ଆକା ସୁଡ଼ୁନାଟ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ଆବେଟ୍‌ ୱାର୍‌ ଦାପ୍ରେ ସଲ୍‌ସି ପଇଜି ଅସି ମରିୟମ୍‌ ମାରି ଜୋସେପତିଙ୍ଗ୍‌ ପ‍ଇତାର୍‌, ମାରି ସାଡ଼ାଦି ଟଙ୍ଗାଁଦୁ କଡ଼ଦିଙ୍ଗ୍‌ ଡରିତିମାର୍‌ଇକା ସୁଡ଼ୁତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ସୁଡ଼ୁଜି ଆୟା କଡ଼ଦି ବିସୟ୍‌ତାନ୍‌ ଦୁତ୍‍ ଏମେ ମାଟା ଇର୍ହାମାର୍‌ଆତ୍‌, ଆକା ୱାରିଙ୍ଗ୍‌ ୱେର୍‌ତାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ମାରି ଏମେ ଲୋକୁ ମେଣ୍ତେଙ୍ଗ୍‌ସାରାକିନିୱାରି ମାଣାନ୍‌ ଆୟାୱିଜୁ ମାଟା ୱେର୍‌ଆର୍‌, ୱାର୍‌ ୱିଜେରେ କାବା ଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ମାତର୍‌ ମରିୟମ୍‌ ଇୟାୱିଜୁ ମାଟା ମନ୍‍ତୁ ଇଡ୍‌ଜି ନାଣ୍ତ ଏତ୍‍କିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ମାରି, ମେଣ୍ତେଙ୍ଗ୍‌ସାରା କିନିୱାରିଙ୍ଗ୍‌ ଦୁତ୍‍ ଏଣ୍ତେସ୍‌ ଇର୍ହାମାର୍ହାତ୍‌, ଆୟାୱାଜା ୱାର୍‌ ଏମେ ଏମେକା ୱେର୍‌ଆର୍‌ ମାରି ସୁଡ଼ୁତାର୍‌, ଆୟାୱିଜୁ ଉଣ୍ତିଙ୍ଗ୍‌ ମାପ୍‌ରୁଦି ଗୌରବ୍‍ ମାରି ଦନ୍ ଦନ୍ୟବାଦ୍‌ କିବୁ କିବୁ ଡ଼େସିୱାତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ଆଟ୍‍ଦିନ୍‍ ୱେନ୍‌କା ସୁନ୍ନତ କିଦେଙ୍ଗ୍‌ ଜିସୁଙ୍ଗୁଁ ମନ୍ଦିର୍‌ତୁ ଅତାର୍‍, ୱାନି ଦର୍‌ ଜିସୁ ଇଟ୍‌ତାର୍‌, ଇୟା ଦର୍‌ ୱାଦ୍‌ ଗାର୍ବୁଦୁ ତେବାଇ ଆଗ୍‍ଡ଼ିରାନ୍‍ନେ ମୁସ୍‌କୁପୁର୍‌ତି ଦୁତ୍‌ ଇୟା ଦର୍‌ ସିତାମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ୱେନ୍‌କା ଏସ୍ତିୱାଲେ ମୋସାଦି ନିୟମତାନ୍‌ ତାନି ଶୁଚି ଆନି ସମୟ ପୁରା ଆତାତ୍‌, ନାସ୍ତିୱାଲେ ୱାର୍‌ କଡ଼ଦିଙ୍ଗ୍‍ ମାପୁରୁମାନୁ ସିଦେଙ୍ଗ୍‍ ଜିରୁସାଲାମ୍‍ ମନ୍ଦିରତୁ ଅତାର୍‍ ");
INSERT INTO kfcp_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ନାସ୍ତିୱାଲେ ୱିଜେରେ ପାର୍‍ତୁମ୍ ଜନମ୍‌ ଆତି କଡ଼ର୍‌ ପ୍ରବୁଦି ନିୟମତାନ୍‌ ପବିତ୍ର ଇଜି ୱେଙ୍ଗ୍‌ଁନାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ପ୍ରବୁଦି ନିୟମତାନ୍‌ ରାସ୍‍ତିମାନି ଇୟା ମାଟାଦାନ୍‌ ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ପ୍ରବୁଦି ନିୟମତାନ୍‌ ସର୍ପେକିନି ଉଣ୍ତିଙ୍ଗ୍‌ ମାରି ପ୍ରବୁଦି ନିୟମ୍‌ତି ସାସ୍ତ୍ରଦାନ୍‌ ରାସ୍‍ତିମାନି ନିୟମତାନ୍‌ ରୁଣ୍ତି ପାରୁୱାପିଲେକାଙ୍ଗ୍‌ ପୁଜା କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ ଜିରୁସାଲମତୁ ଅତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ମାରି ସୁଡ଼ୁଦୁ, ଜିରୁସାଲମତୁ ସିମିୟୋନ ଦର୍‌ତି ଅରେନ୍‍ ଦାର୍ମୁ ମାରି ସାଦୁ ଲୋକୁ ମାର୍‌ଆନ୍‌; ୱାନ୍‌ ଇସ୍ରାଏଲ୍‌ତି ରକିୟାକିନିୱାନିଙ୍ଗ୍‍ ସୁଡ଼୍‍ଦେଙ୍ଗ୍‍ କାପ୍‌କିଜି ମାର୍‌ଆନ୍‌, ମାରି ପବିତ୍ର ଆତ୍ମା ୱାନିୱାଲେ ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ପ୍ରବୁ କ୍ରିସ୍ତଙ୍ଗ୍‍ ସୁଡ଼ିଇତିଙ୍ଗ୍‌ ୱାନ୍‌ ଜେ ସାଏନ୍‌, ପବିତ୍ର ଆତ୍ମା ୱାନିଙ୍ଗ୍‌ ଇୟା ମାଟା ୱେର୍‌ତା ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ୱାନ୍‌ ପବିତ୍ର ଆତ୍ମା ୱେର୍‌ତି ଇସାବ୍‌ତାନ୍‌ ମନ୍ଦିରତୁ ୱାତାନ୍‌, ମାରି କଡ଼ ଜିସୁଦି ବୁବାୟାୟା ଏସ୍ତିୱାଲେ ୱାନି ବିସୟ୍‌ତାନ୍‌ ଜିହୁଦିରି ନିୟମ୍‌ ଇସାବ୍‌ତାନ୍‌ ପାଣି କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ ମନ୍ଦିର୍‌ ଲୋଇ ତାତାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ନାସ୍ତିୱାଲେ ସିମିୟୋନ କଡ଼ଦିଙ୍ଗ୍‌ ଗାତୁ ଆସ୍‌ସି ମାପୁରୁଦିଙ୍ଗ୍‌ ଦନ୍ୟବାଦ୍‌ କିଜି ଇର୍ହାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“ଏ ପ୍ରବୁ, ଇଲେଇ ନିନୁ ନିଜେଦି ବାକ୍ୟଦାନ୍‌ ନିଜେଦି ଗତିମୁରୁଲିଙ୍ଗ୍‌ ସାନ୍ତିଦାନ୍‌ ସଣ୍ଡ୍ରେଙ୍ଗ୍‌ ସିଜିନି; ");
INSERT INTO kfcp_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ଇରିଙ୍ଗ୍‌ ନା କାଣୁକୁ ନି ରକିୟା ସୁଡ଼ୁତା ମାନାତ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ଆମାକା ନିନୁ ୱିଜେରି ଲୋକା ଆଗ୍‌ଡ଼ି ତିଆର୍‌ କିତିମାନି । ");
INSERT INTO kfcp_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ମାରି ଅଣଜିହୁଦି ଲୋକା ଉଣ୍ତିଙ୍ଗ୍‌ ସତ୍‌ ସାରି ତର୍‌ନି ଜାୟ୍‌ ଆନାନ୍‌, ମାରି ମି ଲୋକା ଇସ୍ରାଏଲ୍‌ତି ଗୌରବ୍‍ ୱାଜା କିତିମାନି ।” ");
INSERT INTO kfcp_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ଇସ୍ରି କଡ଼ଦି ବିସୟ୍‌ତାନ୍‌ ୱେର୍‍ତିମାନି ୱିଜୁ ମାଟା ୱେନ୍‌ଜି ୱାନି ବୁବାସିଆଇସି କାବାଆତା ସର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ମାରି, ସିମିୟୋନ ୱାରିଙ୍ଗ୍‌ ଆସିର୍ବାଦ୍‌ କିଜି ୱାନି ଆଇସି ମରିୟମ୍‌ତିଙ୍ଗ୍‌ ୱେର୍‌ତାନ୍‌, “ଇୟା କଡ଼ ଇସ୍ରାଏଲ୍‌ତି ଲୋଇ ନାଣ୍ଡ୍ ଲୋକା ନାସ୍ଟୁ ମାରି ନାଣ୍ତ ଲୋକା ରକିୟା ଉଣ୍ତିଙ୍ଗ୍‌ ମାପୁରୁ ମାଣାନ୍‌ ବାସେଆତା ମାନାନ୍‌ । ୱାନ୍‌ ମାପୁରୁମାଣାନ୍‌ ସିନାଦି ୱାଜା ଆନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ଏସୋ ଲୋକୁ ୱାନିଙ୍ଗ୍‌ ବିରଦ୍‌ କିଜି ନିଜେଦି ଜିବନ୍‍ତୁ ଆଡ଼ାକ୍‍ନିମାନି ମାଟେଙ୍ଗ୍‌ ୱିଜୁ ୱେର୍‌ନାନ୍‌ । ଦୁକ୍‍ ନାନି ଉଣ୍ତ୍ରି ଦାରାଦି କୁଡ଼ାମ୍‍ ମି ନିଜେଦି ଜିବନ୍‍ତିଙ୍ଗ୍‍ ଗୁତ୍‍ନାତ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ମାରି, ୱାଦ୍‌ ଆସେର୍‌ କୁଟୁମ୍‌ତି ପିନୁୟେଲଦି ଗାଡ଼୍‌ସି । ହାନା ଦର୍‍ତି ଅରେତ୍‌ ଅସେ ନାଲ୍‍ଗି ବାର୍ସେକ୍‍ତି ଡକ୍ରି ମାର୍‌ଆତ୍‌, ୱାଦ୍‌ ଅରେତ୍‌ ବାବବାଦିନି ମାର୍‌ଆତ୍‌ । ପେଡ଼ି ଆତାଦ ସାତ୍‌ବାର୍ସୁ କନ୍‍ଲି ୱାଲେ ମାର୍‍ଇ ୱେନ୍‌କା ରାଣ୍ତି ଆତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ୱାଦ୍‌ ମନ୍ଦିର୍‌ତିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ସି ସଲ୍‍ଏଜି ମାର୍‌ଆତ୍‌, ଉପାସ୍‌ କିଜି ମାରି ୱେଡ଼େନାଡ଼ା ମାପୁରୁମାନୁ ପାର୍‍ତନା କିଜିମାର୍‌ଆତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","କଡ଼ ଜିସୁ ମନ୍ଦିର୍‌ତୁ ସିଆଇ ଆନିୱାଲେ ହାନା ଆବେନ୍‌ ଇଜି ମାପ୍‌ରୁଙ୍ଗ୍‌ ଦନ୍ୟବାଦ୍‌ ସିତାତ୍‌ ମାରି ମାପୁରୁ ଜିରୁସାଲମ୍‍ତିଙ୍ଗ୍‌ ରକିୟା କିନାନ୍‍ ଇଜି ଏମେକାର୍‌ ବିସ୍‌ବାସ୍‌ କିଜି କାପ୍‌କିଜି ମାର୍‌ଆର୍‌ ଆୟା ୱିଜେରିଙ୍ଗ୍‌ କଡ଼ଦି ବିସୟ୍‌ତାନ୍‌ ୱେର୍‌ତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ୱେନ୍‌କା ଜୋସେପ୍‍ ମାରି ମରିୟମ୍‌ ପ୍ରବୁଦି ନିୟମତାନ୍‌ ୱିଜୁ ପାଣି ୱିସ୍‌ତାର୍‌ ଗାଲିଲିଦୁ, ୱାର୍‌ ନିଜେଦି ଗାଡ଼୍‍ତି ନାଜରିତଦୁ ଡ଼େସି ସର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ମାରି, କଡ଼ ଦିରେ ଦିରେ ପିର୍‌ଦେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ ମାରି ବୁଦିଦାନ୍‌ବା ପିର୍‌ଜି ସାକ୍ତି ଆତାନ୍‌, ମାରି ମାପ୍‌ରୁଦି ଆସିର୍ବାଦ୍‌ ୱାନି ମୁସ୍‌କୁ ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ଜିସୁଦି ବୁବାୟାୟା ୱିଜୁ ବାର୍‌ର୍ସେକ୍‌ ନିସ୍ତାର୍‌ ପଣ୍ତୟ୍‌ ସମୟତୁ ଜିରୁସାଲମ୍‍ତୁ ସଲ୍‌ସି ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ଜିସୁଙ୍ଗୁଁ ବାର ବାର୍ସେକ୍‍ ଆତିୱାଲେ ୱାର୍‌ ୱାରି ରିତିଦାନ୍‌ ଜିରୁସାଲାମ୍‍ତୁ ପଣ୍ତୟ୍‍କିଦେଙ୍ଗ୍‍ ସର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ମାରି ପଣ୍ତୟ୍‌ତି ଦିନ୍‌ ୱିସ୍‌ତାର୍‌ରୋ ଏସ୍ତିୱାଲେ ୱାର୍‌ ଡ଼େସିସଲ୍‍ସିମାର୍‍ଆର୍‍, ନାସ୍ତିୱାଲେ କଡ଼ ଜିସୁ ଜିରୁସାଲମ୍‍ତୁ ତେବାତାନ୍‌, ମାରି ୱାନି ବୁବାୟାୟା ଆକା ନେସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‍ଏତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ମାତର୍‌ ଜିସୁ ସଙ୍ଗ୍‍ ଲୋକାୱାଲେ ଅର୍‌ସେ ମାନାନ୍‌ ଇଜି ଅଡ଼୍‌ବିତାର୍‌ ୱାର୍‌ ଅର୍‌ନେଟି ସାରି ସର୍‌ଆର୍‌, ମାରି ଇଣ୍ତ୍ରଣି ଲୋକାମାନୁ ମାରି ନେସ୍‌ତି ଲୋକାମାନୁ ଜିସୁଙ୍ଗୁଁ ପଇଜି ଅତାର୍‍, ");
INSERT INTO kfcp_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ମାରି ଜିସୁଙ୍ଗୁଁ ପଏତାର୍‌ନୋ ପଇଜି ପଇଜି ଜିରୁସାଲମତୁ ମାରିଡ଼େସି ସର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ମୁନେଟି ୱେନ୍‌କା ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ମନ୍ଦିରତୁ ପ‍ଇତାର୍‌; ୱାନ୍‌ ଦାର୍ମୁଗୁରୁରି ୱାଲେ ବାସ୍‌ତାନ୍‌ନୋ ୱାରି ମାଟା ୱେନ୍‌ଜି ମାର୍‌ଆନ୍‌ ମାରି ୱାରିଙ୍ଗ୍‌ ପ୍ରସ୍ନ ୱେନ୍‌ବାଜି ମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ମାରି ଏସଲୋକ୍‌ ୱାନି ମାଟା ୱେନ୍‌ଜି ମାର୍‌ଆର୍‌, ୱିଜେରେ ୱାନି ବୁଦିଦିଙ୍ଗ୍‌ ମାରି ମାଟାଦିଙ୍ଗ୍‌ କାବାଆଜି ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ଜୋସେପ ମାରି ମରିୟମ୍‌ ଜିସୁଙ୍ଗୁଁ ସୁଡ଼ୁଜି କାବା ଆତାର୍‌, ମାରି ୱାନି ଆଇସି ୱାନିଙ୍ଗ୍‌ ଇର୍ହାତ୍‌, “ଏ କଡ଼, ମା ଉଣ୍ତିଙ୍ଗ୍‌ ଏନ୍ଧା ଇୟାୱାଜା କିତି ? ସୁଡ଼ୁଆ, ମି ବୁବା ମାରି ନାନ୍ ନାଣ୍ଡ୍ ସିନ୍ତା କିଜି ନିଙ୍ଗିଁ ପଇଜିନାପ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ଆବେନ୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଏନ୍ଧା ମିର୍‌ ନାଙ୍ଗିଁ ପଇଜି ମାର୍ହିଦେର୍‌ ? ନା ବୁବାଦି ଇଣ୍ତ୍ର ମାଣ୍ତ୍ରେଙ୍ଗ୍‌ ଯେ ନାଙ୍ଗିଁ ଅଦିକାର୍‌ ମାନାତ୍‌, ଇକା ଇନିକା ମିର୍‌ ନେସ୍‌ଇ ମାର୍ହିଦେର୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ମାତର୍‌ ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଏମେ ମାଟା ୱେର୍‌ତାନ୍‌, ଆକା ୱାର୍‌ ବୁଜାଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ୱେନ୍‌କା ଜିସୁ ୱାରିୱାଲେ ଡ଼େସି ନାଜରିତଦୁ ୱାତାନ୍‌ ମାରି ୱାନ୍‌ ୱାରି ୱିଜୁ ମାଟା ମାନାତାନ୍‌; ମାରି, ୱାନି ଆଇସି ଇୟାୱିଜୁ ମାଟା ନିଜେଦି ମାନ୍‌ ଲୋଇ ଇଡ୍‌ଜି ସିନ୍ତା କିତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ମାରି, ଜିସୁ ବୁଦିଦୁ ମାରି ମେନ୍ଦଲ୍‌ତୁ, ମାରି ମାପୁରୁମାନୁ ମାରି ଲୋକା ଦୟାଦାନ୍‌ ପିର୍‌ଦେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ତିବିରିୟା କାଇସର୍‍ଦି ସାସନ୍‍କିଜି ମାର୍‌ଇ ୱାଲେରି ପନ୍ଦର ବାର୍ସେକ୍‍ତି ମାଟା, ଏସ୍ତିୱାଲେ ସାସନ୍‌କିନି ପନ୍ତିୟ ପିଲାତ୍‌ ଜିହୁଦା ଦେସ୍‌ତୁ ପେରିରାଜା ମାର୍‌ଆନ୍‌ ମାରି ହେରୋଦ ଗାଲିଲିଦି ପେରିରାଜା, ମାରି ୱାନି ତଡ଼ାନ୍‌ ପିଲିପ୍‍ପ ଇତୁରିୟା ମାରି ତ୍ରାକନିଦି ଦେସ୍‌ତୁ ପେରିରାଜା ମାର୍‌ଆର୍‌, ମାରି ଲୁସାନିୟା ଅବିଲିନି ଦେସ୍‌ତୁ ପେରିରାଜା ମାର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ମାରି ହାନାନ ମାରି କୟାପା ୱିଜେରିଙ୍ଗ୍‌ପେରି ଜାଜକର୍‌ ମାର୍ହାର୍‌, ନାସ୍ତିୱାଲେ ମାପ୍‌ରୁଦି ବାକ୍ୟ ସୁନ୍‌ସାନ୍‌ ବାଡିଦୁ ଜିକରିୟଦି ମାରିସି ଜୋହନ ଲାକ୍‌ତୁ ଇଗା ୱାତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ଆବେଟ୍‌ ଡୁବନ୍‌ ସିନି ଜୋହନ ଜର୍ଦନ ଗାଡାଦି ଲାକ୍‌ତୁରି ୱିଜୁ ରାଜିତରିଣ୍ତ୍‌ ସଲ୍‌ସି, “ପାପ୍‌ତାନ୍‌ ମନ୍‍ତିଙ୍ଗ୍‍ ଡ଼େପ୍‍ସି ଡୁବନ୍‌ଅତୁ ଇଜି ୱେର୍‌ତେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌,” ");
INSERT INTO kfcp_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ଏଣ୍ତେସ୍‌ ଜିସାଇୟ ବାବବାଦିଦି ସାସ୍ତ୍ରଦୁ ରସ୍‌ତାମାନ୍‌ତା, “ସିମ୍ରାବାଡିଦୁ ନାଣ୍ଡ୍ ଆଉଲିଆଜିମାନି ଅରେନ୍‍ୱାନି ବଲ୍, ପ୍ରବୁଦି ସାରି ତିଆର୍‌ କିଦୁ, ୱାନି ସାରି ସାଡ଼ୁକୁ କିଦୁ; ");
INSERT INTO kfcp_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ୱିଜୁ ରିଆଙ୍ଗାଁଦି ଗରନ୍‌ତି ଗୁଟାଦି ବାଡିଦୁ ବର୍ତି କିଆନାତ୍‌, ମାରି ୱିଜୁ ପେରି ଗରକ୍‌ ମାରି ଇସ୍ରି ଗରକ୍‌ ସାର୍‌ଦିନେ, ବାକୁଲି ସାରିୱିଜୁ ସାଡ଼ୁକୁ ଆନାତ୍‌, ମାରି ଗୁଟାଟେମୁଦି ବୁମି ସାର୍‌ଦିଜି ସାରିଦି ୱାଜା ଆନାତ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ମାରି, ୱିଜୁ ଲୋକୁ ମାପୁରୁଦି ରକିୟା ସୁଡ଼ୁନାଟ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ମାରି, ୱାନିମାନୁ ଡୁବନ୍‌ ଅତେଙ୍ଗ୍‌ ଇଜି ସସି ୱାଜିମାନି ୱିଜୁଲୋକାଙ୍ଗ୍‌ ସୁଡ଼ୁଜି ଇର୍‌ଆନ୍‌, “ଏ ବିସ୍‌ମାନି ସାରାସ୍‍ତି କୁଟୁମ୍‌, ମାପୁରୁଦି ୱାଜିମାନି ରିସାଦାନ୍‌ ଉର୍‌କୁତେଙ୍ଗ୍‌ ଇଜି ଏନ୍‌ ମିଙ୍ଗିଁ ୱେର୍‌ତାନ୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ମିର୍‌ ପୁରା ଜିବନ୍‌ତିଙ୍ଗ୍‌ ସତ୍‌ତାନ୍‌ ପାପ୍‌ ପାଣିଦାନ୍‌ ମନ୍‍ ଡ଼େପ୍‍ତି ମାନିଦେର୍‌, ଇକା ମି ନେଗି ପାଣିଦାନ୍‌ ତର୍‌ତୁ; ମାରି, ଅବ୍ରାହାମ ମା ବୁବା, ମୋନ୍‌ତୁ ମୋନ୍‌ତୁ ବା ଇୟାୱାଜା ଇନ୍‌ମାଟ୍‌; ଇରିଙ୍ଗ୍‌ ନାନ୍ ତୋ ମିଙ୍ଗିଁ ଇଜିନା, ମାପୁରୁ ଇୟା କାଲ୍‌କାଣ୍‌କୁ ବା ଅବ୍ରାହାମତି କୁଟୁମ୍‌ ତିଆର୍‌କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ମାରି, ମାରାକା ମଦଲ୍‍କୁ କାତ୍‍ତେଙ୍ଗ୍‍ ଇଜି ପାଡ଼ିସି ତିଆର୍‍କିତା ଇଟ୍‌ତାମାନାର୍‌; ମାରି, ଏମେ ମାରାନ୍‌ ନେଗି ପଲ୍‌ ଆସ୍‌ଏତ୍‌, ଆୟାୱିଜୁ ମାରାକାଙ୍ଗ୍‌ କାତ୍‌ନାର୍‌ ରୋ ସିସୁଦୁ ପୋକ୍‌ନାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ଆବେଟ୍‌ ଲୋକ୍‌ ୱିଜେରେ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, “ଆରିଙ୍ଗ୍‌ ମାପ୍‌ ଇନିକା କିନାପ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ଜୋହନ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଆମାୱାନିଙ୍ଗ୍‍ ରୁଣ୍ତି ଆଙ୍ଗିଁଙ୍ଗ୍‍ ମାନେ, ୱାନ୍‍ ଆମାୱାନିଙ୍ଗ୍‍ ଇନିକା ସିଲେତ୍‍, ୱାନିଙ୍ଗ୍‍ ଉଣ୍ତ୍ରି ସିପିନ୍‍ ମାରି ଆମାୱାନିଙ୍ଗ୍‍ କାଦି ମାନାତ୍‍, ୱାନ୍‍ ଆଇୱାନିଙ୍ଗ୍‍ ଆବେ ମିସାକିପିନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ମାରି ଏସ ସିସ୍‍ଟୁ ଲୋସ୍‌ନିକାର୍‌ ବା ଡୁବନ୍‌ ଅତେଙ୍ଗ୍‌ ଇଜି ୱାତିକାର୍‌ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, “ଏ ଗୁରୁ, ମାପ୍‌ ଇନିକା କିନାପ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ମାରି ଜୋହନ ୱାରିଙ୍ଗ୍‌ ୱେର୍‌ତାନ୍‌, “ମି ଉଣ୍ତିଙ୍ଗ୍‌ ଏସୋ ଲୋସ୍‍ନି ନିୟମ୍‌ ମାନାତ୍‌ ନାସ ଲୋସ୍‍ତୁ, ତାନି ବାଦୁଲ୍‌ ନାଣ୍ଡ୍ ଲସ୍‌ମାଟ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ସନ୍ୟର୍‌ ବା ଜୋହନତିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, “ମାରି ମାପ୍‌ ଇନିକା କିନାପ୍‌ ?” ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ୱେର୍‌ତାନ୍‌, “ସାକ୍ତିଦାନ୍ ନି ସାଲାକିଦାନ୍‍ ଏ ଦନ୍‌ ରେଲ୍‍ଜ ଅମାଟ୍‌, ମାରି ମି ଦରମା ଡାବୁଙ୍ଗୁଁ ଏସ ପ‍ଇଜିନିଦେର୍‌ ନାସଦାନ୍‌ ୱେଡ଼ିକା ମାଣ୍ତ୍ରୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ୱିଜୁ ଲୋକୁ କାପ୍‌କିଜି ମାର୍‌ଆର୍‌ଆକା, ଜୋହନ ଏମୋ କ୍ରିସ୍ତ ଆନାନ୍‌, ଇକା ଜୋହନତି ବିସୟ୍‌ତାନ୍‌ ୱିଜେରେ ନିଜେ ନିଜେଦି ମୋନ୍‌ତୁ ଅଡ଼୍‍ବିଜି ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ଜୋହନ ୱିଜେରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନାନ୍ ତୋ ମିଙ୍ଗିଁ ଏର୍‌ତୁ ଡୁବନ୍‌ ସିଜିନା, ମାତର୍‌ ନା ମାଣ୍‌ନା ଏନ୍‌ ପେରିକାନ୍‌, ୱାନ୍‌ ୱାଜିନାନ୍‍, ୱାନି ଜୁତେଙ୍ଗ୍‌ତି ଗାଟି କୁତ୍‌ତେଙ୍ଗ୍‌ ବା ନାନ୍ ଜଗ୍‌ ସିଲେ; ୱାନ୍‌ ମିଙ୍ଗିଁ ପବିତ୍ର ଆତ୍ମାଦୁ ମାରି ସିସୁଦୁ ଡୁବନ୍‌ ସିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ୱାନି କିୟୁଦୁ ସେରିଇ ମାନାତ୍‌, ଆବେଟ୍‌ ୱାନ୍‌ କାଡ଼ାତୁମାନି କୁଲିଙ୍ଗ୍‌ ଟୁଟ୍‍ନାନ୍‍ ମାରି ନିଜେଦି କଲ୍‍କିଦୁ ଉଣ୍ତାକିନାନ୍‍ ମାରି କୁଲିଙ୍ଗ୍‌ ପଟୁ ଏସ୍‌କାଙ୍ଗ୍‌ ନାମ୍‌ଇ ସିସୁଦୁ ଆଡ଼ାକ୍‌ନା ପୋକ୍‌ନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ଜୋହନ ଇୟାୱାଜା ନାଣ୍ଡ୍ ମାଟା ୱେର୍‌ସି, ମାରି ରକମ୍‌ ରକମ୍‌ତି ୱେଡ଼ିକାଦି ବାକ୍ୟ ଇଜି ଲୋକା ଲାକ୍‌ତୁ ନେଗିକାବୁର୍‌ ୱେର୍‌ତାନ୍‌ ମାରି ମନ୍ ଡ଼େପ୍‍ତେଙ୍ଗ୍‍ ଲୋକାଙ୍ଗ୍‌ ବୁଜାକିତାନ୍‍; ");
INSERT INTO kfcp_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ମାତର୍‌ ଜୋହନ ରାଜା ହେରୋଦତିଙ୍ଗ୍‍ ଆଟ୍‍ୱାଦାନ୍‍ ଇଜିମାର୍‌ଆନ୍‌ ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ୱାନି ତଡ଼ାନ୍‌ତି ଆଡ଼୍‌ସିଙ୍ଗ୍‌ ହେରୋଦିଆଦିଙ୍ଗ୍‍ ପେଡ଼ି ଆତାମାର୍‍ଆନ୍‍ ମାରି ନାଣ୍ତ ତାଗିଇ ପାଣି କିତାମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ଆୟାୱାଜା ହେରୋଦ ଜୋହନତିଙ୍ଗ୍‌ ଜଇଲ୍‌ତୁ ଇଟ୍‍ଟାନ୍‍ନୋ ନିଜେଦି ୱିଜୁ ତାଗିଇ ପାଣିଦି ୱାଲେ ଇକାବା ମିସାକିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ୱିଜୁ ଲୋକୁ ଡୁବନ୍‌ ଅତି ୱେନ୍‌କା ଜିସୁ ବା ଡୁବନ୍‌ ଅତାନ୍‍ । ମାରି ୱାନ୍‌ ପାର୍‌ତନା କିନିୱାଲେ ବାଦଡ଼୍ ରେଆତାତ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ମାରି ପବିତ୍ର ଆତ୍ମା ପାର୍‍ୱାଦି ୱାଜା ୱାନି ମେନ୍ଦଲ୍‍ ମୁସ୍‌କୁ ୱାଜି ବାସ୍‌ତାତ୍‌; ମାରି, ବାଦଡ଼୍‍ତାନ୍ ଇୟା ବଲ୍ ୱାତାତ୍‍, “ନିନୁ ନା ଲାଡ୍‍ତି ମାରିନ୍‌, ନିବାନୁ ନାନ୍ ନାଣ୍ତ ୱେଡ଼ିକା ।” ");
INSERT INTO kfcp_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ଜିସୁ ପାଣି ଆରାମ୍‌ କିତି ସମୟତୁ ୱାନିଙ୍ଗ୍‌ ପୁରା ତିରିସ୍‌ ବାର୍ସେକ୍‍ ଆତାମାର୍‌ଆତ୍‌; ଲୋକୁ ଅଡ଼୍‍ବିନି ଇସାବ୍‌ତାନ୍‌ ଜିସୁ ଜୋସେପତି ମାରିନ୍‌, ଜୋସେପ ଏଲିତି ମାରିନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ଏଲି ମତ୍‌ତାତତି ମାରିନ୍‌; ମତ୍‌ତାତ ଲେବିତି ମାରିନ୍‌, ଲେବି ମଲ୍‌କିତି ମାରିନ୍‌, ମଲ୍‌କି ଜନୟତି ମାରିନ୍‌, ଜନୟ ଜୋସେପ୍‌ତି ମାରିନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ଜୋସେପ ମତିତ୍ୟାତି ମାରିନ୍‌, ମତିତ୍ୟା ଆମୋସତି ମାରିନ୍‌, ଆମୋସ ନାହୁମତି ମାରିନ୍‌, ନାହୁମ ହେଲ୍‍ସିତି ମାରିନ୍‌, ହେଲ୍‍ସି ନଗୟତି ମାରିନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ନାଗାୟି ମହତତି ମାରିନ୍‌, ମହତ ମତିତ୍ୟାତି ମାରିନ୍‌, ମତିତ୍ୟା ସିମିୟତି ମାରିନ୍‌, ସିମୟି ଜୋସେକତି ମାରିନ୍‌, ଜୋସେକ ଜୋଦାତି ମାରିନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ଜୋଦା ଜୋହନତି ମାରିନ୍‌, ଜୋହନ ରେସାଦି ମାରିନ୍‌, ରେସା ଜିରୁବ୍‍ବାବେଲତି ମାରିନ୍‌, ଜିରୁବ୍‌ବାବେଲ ସଲ୍‌ଟିୟେଲତି ମାରିନ୍‌, ସଲ୍‌ଟିୟେଲ ନେରିଦି ମାରିନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ନେରି ମଲ୍‌କିଦି ମାରିନ୍‌, ମଲ୍‌କି ଅଦିଦି ମାରିନ୍‌, ଅଦି କୋସାମତି ମାରିନ୍‌, କୋସାମ ଏଲମ୍‍ଦାନତି ମାରିନ୍‌, ଏଲମ୍‍ଦାନ ଏରଦି ମାରିନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ଏର୍‌ ଜିହୋସୁୟଦି ମାରିନ୍‌, ଜିହୋସୁୟ ଏଲିୟେଜରତି ମାରିନ୍‌, ଏଲିୟେଜର ଜୋରିମତି ମାରିନ୍‌, ଜୋରିମ ମତ୍‌ତାତଦି ମାରିନ୍‌, ମତ୍‌ତାତ ଲେବିତି ମାରିନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ଲେବି ସିମିୟୋନତି ମାରିନ୍‌, ସିମିୟୋନ ଜିହୁଦାଦି ମାରିନ୍‌, ଜିହୁଦା ଜୋସେପ୍‌ତି ମାରିନ୍‌, ଜୋସେପ୍‌ ଜୋନାମତି ମାରିନ୍‌, ଜୋନାମ ଏଲିୟାକିମତି ମାରିନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ଏଲିୟାକିମ ମଲାହତି ମାରିନ୍‌, ମଲାହ ମନାଦି ମାରିନ୍‌, ମନା ମତତାତି ମାରିନ୍‌, ମତତା ନାତନତି ମାରିନ୍‌, ନାତନ୍‌ ଦାଉଦଦି ମାରିନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ଦାଉଦ ଜେସିଦି ମାରିନ୍‌, ଜସିୟ ଅବେଦତି ମାରିନ୍‌, ଅବେଦ ବୟଜତି ମାରିନ୍‌, ବୟଜ ସେଲହଦି ମାରିନ୍‌, ସେଲହ ନହସନଦି ମାରିନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ନହସନ ଅମିନାଦବତି ମାରିନ୍‌, ଅମିନାଦବ ଅଦମିନଦି ମାରିନ୍‌, ଅଦମିନ ଅର୍ଣ୍ଣିଦି ମାରିନ୍‌, ଅର୍ଣ୍ଣି ହେସ୍ରଣତି ମାରିନ୍‌, ହେସ୍ରଣ ପେରସତି ମାରିନ୍‌, ପେରସ ଜିହୁଦାତି ମାରିନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ଜିହୁଦା ଜାକୁବଦି ମାରିନ୍‌, ଜାକୁବ ଇସ୍‍ହାକ୍‍ତି ମାରିନ୍‌, ଇସ୍‌ହାକ୍‌ ଅବ୍ରାହାମତି ମାରିନ୍‌, ଅବ୍ରାହାମ ତେରହଦି ମାରିନ୍‌, ତେରହ ନାହରଦି ମାରିନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ନାହର ସରୁଗଦି ମାରିନ୍‌, ସରୁଗ ରଗୁଦି ମାରିନ୍‌, ରଗୁ ପେଲଗତି ମାରିନ୍‌, ପେଲଗ ଏବରତି ମାରିନ୍‌, ଏବର ସେଲହତି ମାରିନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ସେଲହ କେନାନତି ମାରିନ୍‌, କିନାନ୍ ଅରପକେଦତି ମାରିନ୍‌, ଅରପକେଦ ସେମଦି ମାରିନ୍‌, ସେମ ନହତି ମାରିନ୍‌, ନୋହ ଲେମକତି ମାରିନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ଲେମକ ମିତୁସେଲହତି ମାରିନ୍‌, ମିତୁସେଲହ ହନୋକଦି ମାରିନ୍‌, ହନକ ଜେରଦତି ମାରିନ୍‌, ଜେରଦ ମହଲଲେଲତି ମାରିନ୍‌, ମହଲଲେଲ କେନାନତି ମାରିନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","କିନାନ୍ ଏନସତି ମାରିନ୍‌, ଏନସ ସେତତି ମାରିନ୍‌, ସେତ ଆଦମ୍‌ତି ମାରିନ୍‌, ଆଦମ୍‍ ମାପୁରୁଦି ମାରିନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ଜିସୁ ପବିତ୍ର ଆତ୍ମାଦୁ ପୁରା ମାନ୍‌ଜି ଜର୍ଦନ୍‍ ଗାଡ଼୍‌ତାନ୍‍ ଡ଼େସି ୱାତାନ୍‌ ମାରି ପବିତ୍ର ଆତ୍ମା ୱେର୍‌ତି ଇସାବ୍‌ତାନ୍‌ ସିମ୍ରା ବାଡିଦୁ ସର୍‌ଆନ୍‌ ମାରି ସାଲିସ୍‍ ଦିନ୍‌ ସାନ୍ଧି ସୟତାନ୍ ୱାନିଙ୍ଗ୍‌ ପରିକା କିଜିମାର୍‍ଆତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ଆବେନ୍‍ ୱାନ୍‍ ସୟତାନ୍‍ ମାଣାନ୍‍ ସାଲିସ୍‍ ଦିନ୍‍ ସାନ୍ଦି ପରିକା କିଆୟ୍‍ ଆତାନ୍‌ । ଆୟାୱିଜୁ ଦିନ୍‌ତୁ ୱାନ୍‌ ଇନିକା ବା ଉଣୁଏଣ୍‌ଗା ତିନ୍‌ଏଣ୍‌ଗା ମାର୍‌ଆନ୍‌, ମାରି ଆୟାୱିଜୁ ନାଣ୍ଡିଙ୍ଗ୍ ୱିଜିତି ୱେନ୍‌କା, ଜିସୁ ନାଣ୍ତ ବାଙ୍ଗାଁ ସାତାନ୍ । ");
INSERT INTO kfcp_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ଆବେଟ୍‌ ସୟତାନ୍ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାତ୍‌, “ନିନ୍‌ ଜଦି ମାପୁରୁଦି ମାରିନ୍‌, ତୋ ଇୟା କାଲୁଦିଙ୍ଗ୍‌ ରୁଟି ଆଦେଙ୍ଗ୍‌ ଆଦେସ୍‌ ସିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ଜିସୁ ତାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଦାର୍ମୁସାସ୍ତ୍ରଦୁ ରାସାତାମାନାତ୍‌, ଲୋକୁ ଆବ୍‍କା ରୁଟିଦାନ୍‌ ଜିଏନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ମାରି, ସୟତାନ୍ ୱାନିଙ୍ଗ୍‌ ଉନ୍‍ଣ୍ତ୍ରି ନିର୍‍ଇ ଗରନ୍‍ତି ଟିପୁଦୁ ଅତାଦୋ ସାଣେକ୍‌ତିଙ୍ଗ୍‌ ସାରାଦୁନିଆଦି ୱିଜୁ ରାଜିଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ ତର୍‌ତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ମାରି, ସୟତାନ୍ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାତ୍‌, “ନାନ୍ ନିଙ୍ଗିଁ ଆୟାୱିଜୁଦି ଅଦିକାର୍‌ ସିନା ମାରି ଦନ୍‍ ସିନା, ଇରିଙ୍ଗ୍‌ ଇୟାୱିଜୁ ନାଙ୍ଗିଁ ଆକା ସର୍ପେଆତା ମାନାତ୍‌, ମାରି ନାନ୍ ଏଙ୍ଗ୍‌ ବଦା କିନା, ୱାନିଙ୍ଗ୍‌ ଆକା ସିନା । ");
INSERT INTO kfcp_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ମାରି, ନିନ୍‌ ମେଣ୍ତେଙ୍ଗ୍‍ ଗଟ୍‌କିଜି ନାଙ୍ଗିଁ ମାଡ଼ିସ୍‌କିନି, ଆଦେଙ୍ଗ୍‌ ଇୟାୱିଜୁ ନିଦି ଆନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ଜିସୁ ଇର୍ହାନ୍‌, “ଦାର୍ମୁସାସ୍ତ୍ରଦୁ ରାସାତାମାନାତ୍‌, କେବଲ୍‌ ନି ପ୍ରବୁ ମାପୁରୁଙ୍ଗ୍‍ଁ ମାଡ଼ିସ୍‌ କିଆ ମାରି ୱାନି ସେବା କିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ମାରି, ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ଜିରୁସାଲମତୁ ଅତାଦୋ ମନ୍ଦିରତି ସାତ୍ ମୁସ୍‌କୁରି ଟିପୁଦୁ ନିଲ୍‌ପିସ୍‌କିଜି ୱାନିଙ୍ଗ୍‌ ୱେର୍‌ତାତ୍‌, “ନିନ୍‌ ଜଦି ମାପୁରୁଦି ମାରିନ୍‌, ଆତିଙ୍ଗ୍‌ ଇବେଣ୍‌କୁ ଆଡ୍‍ଗି ଗାତ୍‌ଆ । ");
INSERT INTO kfcp_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ଇରିଙ୍ଗ୍‌ ଦାର୍ମୁସାସ୍ତ୍ରଦୁ ରାସାତାମାନାତ୍‌, ନିଙ୍ଗିଁ ଜିପିସ୍‌ କିଦେଙ୍ଗ୍‌ ମାପୁରୁ ନି ସାକା ଅତେଙ୍ଗ୍‌ ମୁସ୍‌କୁପୁର୍‌ତି ଦୁତ୍‌କାଙ୍ଗ୍‌ ଆଦେସ୍‌ ସିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ମାରିବା ରାସାତା ମାନାତ୍‌, ଏସ୍ତିୱାଲେ ନି ପାଦାମ୍‌ କାଲୁଦୁ ଆଟ୍‍ନାତ୍‍, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାକ୍‍ ନିଙ୍ଗିଁ କିକାଣ୍‌କୁ ପେର୍‍ଜିଆସ୍‍ନେ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ମାରି, ଜିସୁ ତାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଦାର୍ମୁସାସ୍ତ୍ରଦୁ ରାସାତାମାନାତ୍‌, ନିନ୍‌ ପ୍ରବୁ ନିଜେଦି ମାପୁରୁଙ୍ଗ୍‌ ପରିକା କିମା ।” ");
INSERT INTO kfcp_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ଜିସୁଙ୍ଗୁଁ ସୟତାନ୍ ୱିଜୁଜାତିଦି ପରିକା ୱିସ୍‌ତି ୱେନ୍‌କା ଏସ ବେଡ଼ା ସାନ୍ଧି ୱାନିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ତା ସର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ତାନେ ୱେନ୍‌କା ଜିସୁ ପବିତ୍ର ଆତ୍ମାଦି ସାକ୍ତିଦାନ୍ ଗାଲିଲିଦୁ ଡ଼େସିସର୍ହାନ୍‌, ମାରି ଗାଲିଲି ସାରିବେଡ଼ିତିଦି ୱିଜୁ ରାଜିଦୁ ୱାନି ବିସୟ୍‌ତାନ୍‌ କାବୁର୍‌ ୱେଙ୍ଗିଁତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ମାରି, ଜିସୁ ୱାରି ପାର୍‍ତନାକିନି ଇଲ୍‌କାଙ୍ଗ୍‌ ସିକିୟା ସିଜି ୱିଜେରି ମାଣାନ୍‌ ଦନ୍ୟବାଦ୍‌ ପ‍ଇଦେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ଜିସୁ ଏମେ ନାଜରିତ ଗାଡ଼୍‌ତୁ ପିରିତା ମାର୍ହାନ୍‌, ଆୟା ବାଡ଼ିଦୁ ଆୟା ଦାପ୍ରେ ସର୍‌ଆନ୍‌ ମାରି ନିଜେଦି ରିତିଦାନ୍‌ ରମ୍‌ନିନାଣ୍ତିଙ୍ଗ୍‌ ପାର୍‌ତନା କିନି ଇଲୁଦୁ ଡ଼ୁଗିତାନ୍‌, ମାରି ସାସ୍ତ୍ର ପଡ଼ାଦେଙ୍ଗ୍‌ ନିର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ନାସ୍ତିୱାଲେ ଜିସାଇୟ ବାବବାଦିରି ବଇ ୱାନିଙ୍ଗ୍‌ ସିତାର୍‍, ମାରି ୱାନ୍‌ ଆକା କୁତ୍‌ତାନ୍‌, ଏମେ ଜାଗାଦୁ ଇୟା ବାକ୍ୟ ରାସ୍‌ତା ମାର୍‌ଆତ୍‌, ଆକା ପ‍ଇତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","ପ୍ରବୁଦି ଆତ୍ମା ନା ମାନୁ ମାନାତ୍‌, “ଇରିଙ୍ଗ୍‌ କାକୁର୍ତି ଲୋକା ଲାକ୍‌ତୁ ନେଗିକାବୁର୍‌ ୱେର୍‍ନି ଉଣ୍ତିଙ୍ଗ୍‌ ମାପୁରୁ ନାଙ୍ଗିଁ ଆସ୍‌କିତାମାନାନ୍‌, ଜଇଲ୍‌ତୁ ମାନିକାର୍‌ ମୁକ୍‌ଡ଼ାନାର୍‌ ମାରି କାଣାରି ଲାକ୍‌ତୁ ସୁଡ଼ୁନି ବିସୟତିଙ୍ଗ୍‌ ୱେର୍‌ତେଙ୍ଗ୍‌, ମାରି ଦୁଃକୁକାସ୍ଟୁ ପଇତି ଲୋକାଙ୍ଗ୍‌ ମୁକ୍‌ଡା କିଦେଙ୍ଗ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ମାରି ପ୍ରବୁ ୱାନି ଲୋକାଙ୍ଗ୍‌ ରକିୟା କିନି ସମୟ ଜେ ଇଗା ୱାତାମାନାତ୍‌ ଇକା ୱେର୍‌ତେଙ୍ଗ୍‌ ୱାନ୍‌ ନାଙ୍ଗିଁ ପୋକ୍‌ତାମାନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ୱେନ୍‌କା ୱାନ୍‌ ବଇ ବନ୍ଦ କିଜ ସେବାକିନିୱାନିଙ୍ଗ୍‌ ଡେପ୍‌ସିସିତାନ୍‌ ନୋ ବାସ୍‌ତାନ୍‌, ମାରି ପାର୍‌ତନା କିନି ଇଲୁଦି ୱିଜେରେ ୱାନିଙ୍ଗ୍‌ ସୁଡ଼୍‌ଜି ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ମାରି, ଜିସୁ ୱାରିଙ୍ଗ୍‌ ୱେର୍‌ତାନ୍‌, “ନାନ୍ ବଇଦି ଏମେ ବିସୟ୍‌ ଇଲେଇ ପଡ଼ାତା, ଆମାକା ମିର୍‌ ୱେରିଦେର୍‍ ଦାର୍ମୁସାସ୍ତ୍ରଦି ଇୟା ବାକ୍ୟ ଇଲେଇ ନେକ୍‌କା ଆତାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ମାରି, ୱିଜେରେ ୱାନି ବିସୟ୍‌ତାନ୍‌ ସାକି ସିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାର୍‌ ମାରି ୱାନି ୱେୟୁଦାନ୍‌ ଏମେ ନେଗି ମାଟା ସୋସି ମାର୍‌ଆତ୍‌ ଆବେନୁ ୱିଜେରେ କାବାତା ସର୍ହାର୍‌, ମାରି, ୱାର୍‌ ଇଣ୍ତ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, “ଇକାନ୍‌ ଇନିକା ଜୋସେପ୍‌ତି ମାରିନ୍‌ ଆଏନ୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ଆବେଟ୍‌ ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ୱେର୍‌ତାନ୍‌, “ମିର୍‌ ସତେନେ ନାଙ୍ଗିଁ ଇୟା ପାଡ଼ିଇ ବିସୟତି ବାକ୍ୟ ଇନିଦେର୍‌, ଏ ଡାକ୍‌ଟର୍‌, ଆଗିଡ଼ି ନିଜେଦିଙ୍ଗ୍‌ ନେଗେନ୍‌ କିଆୟ୍‌ଆଆ, ମାରି ବା ଇନିଦେର୍‌ କପର୍‍ନାହୁମ୍‍ତୁ ଏମେ ଏମେକା ଗଟାତାମାନାତ୍‌ ଇଜି ମାପ୍‌ ୱେର୍‍ଆମାନାପ୍‍, ଆୟାୱିଜୁ ଇୟା ବାଡିଦୁ ନିଜେଦି ବୁବାୟାୟାଦି ଗାଡ଼୍‌ତୁ ବା କିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ମାରି ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ଆମା ବାବବାଦିଦିଙ୍ଗ୍‌ ନିଜେଦି ବୁବାୟାୟାଦି ଗାଡ଼୍‌ତୁ ମାନାଏର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ମାତର୍‌ ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, “ଏଲିୟଦି ସମୟଦୁ ଇସ୍ରାଏଲତୁ ଏସ୍ତିୱାଲେ ମୁଣ୍ତ୍ରି ବାର୍ସେକ୍‌ ସୋଗୋଟା ଲେଜ୍‌କୁ ସାନ୍ଧି ବାଦଡ଼୍‍ତାନ୍‌ ପିରୁ ଆଏତାତ୍‌ଆକା ୱିଜୁ ଦେସ୍‌ତୁ କାଦି ଉଣ୍ତେଙ୍ଗ୍‌ ପୁଟ୍‌ଏତାତ୍‌, ନାସ୍ତିୱାଲେ ଇସ୍ରାଏଲତୁ ନାଣ୍ତ ରାଣ୍ତି ଆଇମେକ୍‍ ମାର୍‌ଏ; ");
INSERT INTO kfcp_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ମାତର୍‌ ମାପୁରୁ ଏଲିୟଙ୍ଗ୍‍ ଆୟାୱାନିକା ଲାକ୍‌ତୁ ପୋକ୍‌ଏଣ୍‌ଗା କେବଲ୍ ସିଦନ୍‌ ଦେସ୍‌ତି ସାରିପତ୍‍ତୁମାନି ଅରେତ୍‌ ରାଣ୍ତି ଆଇମାଦି ଲାକ୍‌ତୁ ପୋକ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ମାରି, ବାବବାଦି ଇଲିସାୟତି ସମୟତୁ ଇସ୍ରାଏଲତୁ ନାଣ୍ତ କୁସ୍ଟରୋଗ୍‌ ଲୋକୁ; ମାରି ୱାରି ମାଣ୍‌କୁ ଏନ୍‌ ନେଗେନ୍‍ ଆଏର୍‌, କେବଲ୍ ସୁରିଆ ଦେସ୍‍ତି ନାମାନ ନେଗେନ୍‌ ଆତା ମାର୍‌ଆନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ପାର୍‌ତନା ଇଲୁଦୁ ଇୟାୱିଜୁ ମାଟା ୱେନ୍‌ବୁ ୱେନ୍‌ବୁ ୱିଜେରେ ଲୋକୁ ରିସାଆତାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ମାରି ୱାର୍‌ ନିଙ୍ଗିଁଜି ୱାନିଙ୍ଗ୍‌ ଆୟା ଗାଡ଼୍‌ତାନ୍‍ ସୋପ୍‌ତାର୍‌ ମାରି ୱାରି ଗାଡ଼୍‌ ଏମେ ଗୋରନ୍‌ ମୁସ୍‌କୁ ତିଆର୍‌ ଆତାମାର୍‌ଆତ୍‌, ୱାର୍‌ ଗର୍‌ନତି ଟିପୁଦାନ୍‍ ଆଡ୍‍ଗି ପେଲେକିଦେଙ୍ଗ୍‍ ୱାନିଙ୍ଗ୍‌ ଆବେନୁ ଅତାର୍‍; ");
INSERT INTO kfcp_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ମାତର୍‌ ୱାନ୍‌ ୱାରି ନାଣ୍‌ମିରାନ୍‌ ସତା ସୋର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ଜିସୁ କପର୍‍ନାହୁମ୍‍ ଇନି ଗାଲିଲିଦି ଉଣ୍ତ୍ରି ଗାଡ଼୍‌ତୁ ୱାତାନ୍‌, ମାରି ରମ୍‌ନିନାଣ୍ତିଙ୍ଗ୍‌ ଲୋକାଙ୍ଗ୍‌ ସିକିୟା ସିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ମାରି ୱାର୍‌ ୱାନି ସିକିୟାଦୁ କାବାଆତାର୍‌, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ବାକ୍ୟ ଅଦିକାର୍‌ତି ୱାଲେ ମାଟା ଇଜିମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ଅର୍‍ଲେନ୍‍ ପାର୍‌ତନା ଇଲୁଦୁ ଅରେନ୍‍ ଦୁବାଆସ୍‌ତିମାର୍‌ଇ ଲୋକୁ ମାର୍‌ଆନ୍‌, ୱାନ୍‌ ପେରି ୱେୟୁଦାନ୍‌ ଆଉଲିଆତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","ଏ, ନାଜରିତିୟଦି ଜିସୁ, “ମା ୱାଲେ ନି ଇନିକା ମାନ୍‌ତା ? ନିନୁ ନୋ ମାଙ୍ଗିଁ ସାପିସ୍‌ କିଦେଙ୍ଗ୍‌ ୱାତିମାନି ? ନିନୁ ଏନ୍‌, ଆକା ନାନ୍ ନେସ୍‌ନା; ନିନୁ ମାପୁରୁଦି ଆୟା ପବିତ୍ର ଲୋକୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ଜିସୁ ତାନିଙ୍ଗ୍‌ ଆଦ୍‌ରିସ୍‌ କିଜି ଇର୍ହାନ୍‌, “ଆଲ୍‌ଜ ମାନ୍‌ଆ, ୱେନିମାଣ୍‌କୁ ସହସି ସାଙ୍ଗ୍ଆ ।” ଆବେଟ୍‌ ଆୟା ଦୁବା ୱାନିଙ୍ଗ୍‌ ୱିଜେରି ଆଗିଡ଼ି ଆରାପ୍‌ତାଦୋ ୱାନିଙ୍ଗ୍‌ ଇନିକା କିଏଣ୍‌ଗା ୱାନିମାଣ୍‌କୁ ସତା ସର୍‌ଆତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ଆବେଟ୍‌କୁ ୱିଜେରେ କାବାତାରୋ ନିଜେ ନିଜେଦିମାନୁ ଇନିଞ୍ଜି ସାତାର୍‌, “ଇକା ଇନି ମାଟା ? ୱାନ୍‌ ଅଦିକାର୍‌ ମାରି ସାକ୍ତିଦାନ୍ ଆଦେସ୍‌ ସିନାନ୍‍ ତାଗ୍‍ଇ ଦୁବେଙ୍ଗ୍‍ ମାରି ୱାକ୍‍ ସଅନେ ସନେ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ଆବେଟ୍‌ ଜିସୁ ବିସୟ୍‌ତାନ୍‌ ଇୟା କାବୁର୍‌ ୱିଜୁତରିଟି ରାଜିଦୁ ୱେଙ୍ଗିଁତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ୱେନ୍‌କା ଜିସୁ ପାର୍‌ତନା ଇଲୁଦାନ୍‌ ନିଙ୍ଗିଁଜି ସିମୋନ୍‌କା ଇଣ୍ତ୍ର ସୋର୍‌ଆନ୍‌ । ସିମୋନକା ମିମିସିଙ୍ଗ୍‌ ନାଣ୍ତ ନବ୍‌ ଆତାମାରାତ୍‌, ମାରି ୱାର୍‌ ତାନି ବିସୟ୍‌ତାନ୍‌ ୱାନିଙ୍ଗ୍‌ ୱେର୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ଆବେଟ୍‌ ୱାନ୍‌ ତାନି ଲାକ୍‌ତୁ ନିର୍‌ଆନ୍‌ନୋ ନବ୍‌ତିଙ୍ଗ୍‌ ଆଦ୍‌ରିସ୍‌ତାନ୍‍, ମାରି ତାନିଙ୍ଗ୍‌ ନବ୍‌ ଡ଼ିସ୍‌ତାତ୍‌, ମାରି ୱାଦ୍‌ ଆୟାଦାର୍ପେ ନିଙ୍ଗିଁଜି ୱାରି ସେବା କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ୱେଡ଼ା ସନିୱାଲେ, ଏମେୱାରି ଲାକ୍‌ତୁ ଆଇ ଆଇ ରୋଗ୍‌ ଆସ୍‌ତିମାର୍‌ଇ ଲୋକୁ ମାର୍‌ଆର୍‌, ଆୟାୱିଜେରେ ୱାରିଙ୍ଗ୍‌ ୱାନି ଲାକ୍‌ତୁ ତାତାର୍‌ ମାରି ୱାନ୍‌ ୱିଜେରି ମୁସ୍‌କୁ କିୟୁ ଇଡ୍‌ଜି ୱାରିଙ୍ଗ୍‌ ନେଗେଣ୍ତ୍‌ କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ମାରି, ଦୁବେଙ୍ଗ୍‌ ବା ଆଉଲି ଆଜି ଆଜି ନିନୁ ମାପୁରୁଦି ମାରିସି ଇଜି ଇନ୍‌ଞ୍ଜି ନାଣ୍ତ ଲୋକା ମାଣ୍‌କୁ ସୋତେ ସର୍‌ଏ । ମାରି, ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଆଦ୍‌ରିସ୍‌ କିଜି ୱାର୍‍ଗିଦେଙ୍ଗ୍‍ ସିଏତାନ୍‌, “ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ଜେ କ୍ରିସ୍ତ, ଇକା ୱାକ୍‍ ନେସ୍‌ତେ ମାର୍‍ହେ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ସାଲ୍‍ଦି ଆତାତ୍‌ଆକା, ଜିସୁ ଗାଡ଼୍‌ତାନ୍‍ ସୋଅସି ଉଣ୍ତ୍ରି ସୁନ୍‌ସାନ୍‌ ବାଡିଦୁ ସୋର୍‌ଆନ୍‌; ମାରି, ଲୋକୁ ୱିଜେରେ ୱାନିଙ୍ଗ୍‌ ପୟ୍‌ଜି ପୟ୍‌ଜି ୱାନି ଲାକ୍‌ତୁ ୱାତାର୍‌, ମାରି ୱାନ୍‌ ଏଣ୍ତେସ୍‌ ୱାରି ଲାକ୍‌ତୁରାନ୍‌ ସୋଲ୍‌ଏନ୍‌, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ ତେବାକିଦେଙ୍ଗ୍‌ ବଦାକିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ମାତର୍‌ ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଆଇ ଆଇ ଗାଡ଼୍‌କାଙ୍ଗ୍‌ ବା ନାଙ୍ଗିଁ ମାପୁରୁଦି ରାଜିଦି ନେଗିକାବୁର୍‌ ୱେର୍‌ତେଙ୍ଗ୍‌ ଆନାତ୍‌, ଇରିଙ୍ଗ୍‌ ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ମାପୁରୁ ନାଙ୍ଗିଁ ପୋକ୍‌ତା ମାନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ମାରି, ୱାନ୍‌ ଜିହୁଦା ଦେସ୍‍ତି ପାର୍‍ତନାକିନି ଇଲ୍‌କାଙ୍ଗ୍‌ ପ୍ରଚାର୍‌ କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ଅର୍‍ଲେନ୍‍ ଜିସୁ ଗିନେସରତ ଗାଡା ପାଡ଼ି ନିର୍‌ଆ ମାର୍ହାନ୍‌, ମାରି ଲୋକୁ ମାପୁରୁଦି ବାକ୍ୟ ୱେନ୍‍ଣ୍ତ୍ରେଙ୍ଗ୍‍ ୱାନି ମୁସ୍‌କୁ ମାଟ୍‍ସିସାଜି ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ମାରି, ଜିସୁ ଗାଡାପାଡ଼ି ରୁଣ୍ତି ଡଙ୍ଗେଆଙ୍ଗ୍‌ ମାନିକା ସୁଡ଼ୁତାନ୍‌; ମିନୁକୁଆସ୍‌ନିକାର୍‌ ଆବେଟ୍‌କୁ ରେସିୱାଜି ଜାଡ଼ି ନର୍‌ଜି ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ଆୟା ଡଙ୍ଗେଆଙ୍ଗ୍‌ ମାଣ୍‌କୁ ଏମେମାନୁ ସିମୋନ୍‌ତିଦି ମାର୍ହାତ୍‌, ଆବେନୁ ଜିସୁ ଏକ୍‌ସି ଆଡ୍‍ଗିରାନ୍‌ କାଣ୍ତେକ୍‌ ଆକ ସନି ଉଣ୍ତିଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ ୱେର୍‌ତାନ୍‌; ମାରି, ୱାନ୍‌ ଡଙ୍ଗାଁଦୁ ବାସ୍‌ସି ଲୋକାଙ୍ଗ୍‌ ସିକିୟା ସିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ଜିସୁ ମାଟା ଇଣ୍ତ୍ରେଙ୍ଗ୍‌ ୱିସ୍‍ସି ସିମୋନ୍‌ତିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନିର୍‌ଇଗୁମିଦୁ ସୋଲ୍‌ସ ମିନ୍‌କୁ ଆସ୍‌ନି ଉଣ୍ତିଙ୍ଗ୍‌ ମି ଜାଡ଼ି ପୋକ୍‌ତୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ସିମୋନ୍‌ ଇର୍‌ଆନ୍‌, “ଏ ଗୁରୁ, ମାପ୍‌ ନାଡାୱିଗ୍‍ଜି ୱାନ୍ଦ୍‍ଜି ଏସୋବା ଆସ୍‌ଏତାପ୍‌; ମାତର୍‌ ନି ମାଟାଦାନ୍‌ ନାନ୍ ଜାଡ଼ି ପୋକ୍‌ନା ।” ");
INSERT INTO kfcp_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ମାରି, ୱାର୍‌ ଜାଡ଼ି ପୋକ୍‌ସି ନାଣ୍ତ ମିନ୍‌କୁ ଆସ୍‌ତାର୍‌, ମାରି ୱାରି ଜାଡ଼ି ତେଉଦେଙ୍ଗ୍‌ ଆସ୍‌ତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ଆବେନୁ ୱାରି ଏମେ ସାଙ୍ଗର୍‌ ଆଇ ଡଙ୍ଗାଁଦୁ ମାର୍‌ଆର୍‌, ୱାର୍‌ ଏଣ୍ତେସ୍‌ ୱାଜି ସାହାଜ୍ୟ କିନାର୍‌, ଆୟା ଉଣ୍ତିଙ୍ଗ୍‌ ୱାର୍‌ ୱାରିଙ୍ଗ୍‌ କୁକ୍‌ତାର୍‌ । ଆବେଟ୍‌ ୱାର୍‌ ୱାଜି ରୁଣ୍ତି ଡଙ୍ଗେଆଙ୍ଗାଁ ଇୟାୱାଜା ମିନ୍‌କୁ ଆସ୍‌ସି ବର୍ତି କିତାର୍‌ ଜେ, ରୁଣ୍ତି ଡଙ୍ଗେଆଙ୍ଗ୍‌ ମୁଡ଼ୁଗିତି ୱାଜା ଆତେ । ");
INSERT INTO kfcp_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ମାତର୍‌ ସିମୋନ ପିତର୍‌ ଇକା ସୁଡ଼ୁଜି ଜିସୁଦି କାଲ୍‌କା ଆଡ୍‍ଗି ପାଡ଼୍‌ଗିଜି ଇର୍ହାର୍‌, “ଏ ପ୍ରବୁ, ନା ଲାକ୍‌ତୁରାନ୍‌ ନିନ୍‌ ସାଙ୍ଗ୍‌ଆ, ଇରିଙ୍ଗ୍‌ ନାନ୍ ଅରେନ୍‍ ପାପି ଲୋକୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ଇରିଙ୍ଗ୍‌ ୱାର୍‌ ଆୟା ଦାପ୍ରେ ନିସା ମିନ୍‌କୁ ଆସ୍‌ତାମାର୍ହାର୍‌ ଜେ, ଆକା ସୁଡ଼ୁଜି ୱାନ୍‌ ମାରି ୱାରି ତଡ଼୍‍କୁ ୱିଜେରେ କାବାତା ସର୍ହାର୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ମାରି, ଜେବଦିରି ରିଏର୍‌ ମାର୍‌ସିର୍‌ ଜାକୁବ ମାରି ଜୋହନ, ଏର୍‌ ସିମୋନ୍‌ତି ୱାଲେ ମାର୍ହାର୍‌, ୱାନ୍‌ ବା ଆୟାୱାଜା କାବାତା ସୋର୍‌ଆର୍‌ । ମାରି, ଜିସୁ ସିମୋନତିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ତିଲାମା, ନେର୍‍ହାନ୍‌ ନିନ୍‌ ମିନ୍‌କୁ ଆସ୍‌ନି ବାଦ୍‌ଲୁ ଲୋକାଙ୍ଗ୍‌ ମାପୁରୁ ଲାକ୍‌ତୁ ତାନି ।” ");
INSERT INTO kfcp_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ତାନେ ୱେନ୍‌କା ୱାର୍‌ ଡଙ୍ଗେଆଙ୍ଗ୍‌ ପାଡ଼ିତାସି ୱିଜୁ ଡ଼ିସ୍‍ସି ଜିସୁୱାଲେ ୱାଲେ ସର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ଅର୍‍ସୁ ଜିସୁ ଉଣ୍ତ୍ରି ଗାଡ଼୍‌ତୁ ମାନିୱାଲେ, ସୁଡ଼ୁଦୁ, ଅରେନ୍‍ କୁସ୍ଟରୋଗ୍‌ ଲୋକୁ ଆୟା ବାଡିଦୁ ମାର୍‌ର୍ହାନ୍‌, ୱାନ୍‌ ଜିସୁଙ୍ଗୁଁ ସୁଡ଼ୁଜି ମୋକମ୍‌ ପାଡ଼୍‍କ୍‍ସି ଜିସୁଙ୍ଗୁଁ ମାଡ଼ିସ୍‌ କିଜି ଇର୍ହାନ୍‌, “ଏ ପ୍ରବୁ, ନିନ୍‌ ଜଦି ବଦା କିନି, ଆତିଙ୍ଗ୍‌ ନାଙ୍ଗିଁ ନେଗେଣ୍ତ୍‌ କିଦେଙ୍ଗ୍‌ ଆଟ୍‌ନି ।” ");
INSERT INTO kfcp_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ଆବେନୁ ଜିସୁ କିୟୁ ପେର୍‌ଜି ୱାନିଙ୍ଗ୍‌ ମୁଟ୍‌ସି ଇର୍ହାନ୍‌, “ନାନ୍ ବଦା କିଜିନା, ନେଗେଣ୍ତ୍‌ ଆଆ ।” ଆୟାଦାପ୍ରେ କୁସ୍ଟରୋଗ୍‌ ୱାନିମାଣୁକୁ ଆକ ଆତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ମାରି, ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଆଦେସ୍‌ ସିଜି ଇର୍ହାନ୍‌, “ଏଙ୍ଗ୍‌ବା ଇନିକା ଇନ୍‍ମା, ମାତର୍‌ ସିଦା ସୋଲ୍‌ସ ଜାଜକଦି ଲାକ୍‌ତୁ ସାଙ୍ଗ୍‍ଆ ମାରି ୱାନ୍‌ ନିଙ୍ଗିଁ ପରିକା କିଜି ସୁଡ଼ିନ୍‍, ତାନିୱେନ୍‍କା ନିନ୍‌ ନେଗେନ୍‌ ଆତିମାନି ଇଜି ଆଇୱାରି ଲାକ୍‌ତୁ ସାକି ସିଦେଙ୍ଗ୍‍ ଇଜି ମୋସାଦି ସିତିମାନି ନିୟମ୍‍ତାନ୍‍ ପୁଜା ସିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ମାତର୍‌ ୱାନି ବିସୟତି ମାଟା ମାରି ନାଣ୍ତ ୱେଙ୍ଗିଁତାତ୍‌, ମାରି ନାଣ୍ତ ଲୋକୁ ୱେନି ଉଣ୍ତିଙ୍ଗ୍‌ ମାରି ନିଜେ ନିଜେଦି ରୋଗ୍‌ତାନ୍‌ ନେଗେନ୍‌ ଆନି ଉଣ୍ତିଙ୍ଗ୍‌ ଉଣ୍ତ୍ରେମାନୁ ଆଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ମାତର୍‌ ଜିସୁ ସୁନ୍‌ସାନ୍‌ ବାଡିଦୁ ମାନ୍‌ଞ୍ଜି ପାର୍‌ତନା କିଜିମାର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ଅର୍‍ଲେନ୍‍ ଜିସୁ ସିକିୟା ସିଜି ମାର୍ହାନ୍‌, ମାରି ଗାଲିଲିଦି ୱିଜୁ ନାର୍‌କୁ, ମାରି ଜିହୁଦା ଦେସ୍‍ ମାରି ଜିରୁସାଲମତାନ୍‌ ୱାତି ମାର୍ହି ପାରୁସି ମାରି ଜିହୁଦି ଦାର୍ମୁଗୁରୁରି ଲାକ୍‌ତୁ ବାସ୍‌ତା ମାର୍ହାର୍‌, ମାରି, ୱାନ୍‌ ଏଣ୍ତେସ୍‌ ରୋଗିରିଙ୍ଗ୍‍ ନେଗେନ୍‌ କିନାନ୍‌, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ପ୍ରବୁଦି ସାକ୍ତି ୱାତା ମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ମାରି ସୁଡ଼ୁଦୁ, ଏସ ଲୋକୁ ଅରେନ୍‍ ପକିୟାଗାତି ରୋଗ୍‌ ଲୋକ୍‌ତିଙ୍ଗ୍‌ କାଟେଲ୍‍ତୁ ପିଣ୍ତିଜି ତାତାର୍ ୱାନିଙ୍ଗ୍‌ ଲୋଇ ଅତେଙ୍ଗ୍‌ ଇଜି ମାରି ଜିସୁ ଆଗ୍‌ଡ଼ି ଇଡ୍‌ଦେଙ୍ଗ୍‌ ଇଜି ବଦା କିଜିମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ମାତର୍‌ ନାଣ୍ତ ଲୋକୁ ଗୋଲି ଉଣ୍ତିଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ ଲୋଇ ଅତେଙ୍ଗ୍‌ ଇଜି ସାରି ପଇଏତାର୍‌ଆକା ୱାର୍‌ ଇଲୁ ମୁସ୍‌କୁ ଏକ୍‌ତାର୍‌ରୋ ରେକାମ୍‌ତି ଟାଇଲି କୁତ୍‌ତାର୍‌ରୋ ବର୍‌ କିତାର୍‌ ଆୟା ବର୍‌ଦି ସାରିସିଜି କାଟେଲ୍‌ତି ୱାଲେ ୱାନିଙ୍ଗ୍‌ ନେଗିନାଣ୍‌ମି ବାଡିଦୁ ଜିସୁଦି ଆଗିଡ଼ି ରେପ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ୱାନ୍‌ ୱାରି ବିସ୍‌ବାସ୍‌ ସୁଡ଼ୁଜି ଇର୍ହାନ୍‌, “ଏ ମାରିନ୍‌, ନି ପାପ୍‌ୱିଜୁ କେମା ଆତାମାନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ଆବେଟ୍‌ ସାସ୍ତ୍ରିର୍‍ ମାରି ପାରୁସିର୍‌ ନିଜେ ନିଜେଦିମାନୁ ୱାର୍‌ଗିଜିସାଜି ଇର୍ହାର୍‌, “ଇକାନ୍‌ ଜେ ମାପୁରୁଙ୍ଗୁଁ ନିଦା କିଜିନାନ୍‌, ଇକାନ୍‌ ଏନ୍‌ ? କେବଲ୍‌ ମାପୁରୁଙ୍ଗ୍‌ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ମାରି ଏନ୍‌ ପାପ୍‌କେମା କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାନ୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ମାତର୍‌ ଜିସୁ ୱାରି ୱାର୍‌ଗିଜିସାନିକା ନେସ୍‌ସି ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ମିର୍‌ ନିଜେ ନିଜେଦି ମନ୍‍ତୁ ଇନିକା ୱାର୍‌ଗିଜି ସାଜିନିଦେର୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","ଇନିକା ଉସାସ୍‌ ? ନି ପାପ୍‌ୱିଜୁ କେମା ଆତାତ୍‌ ଇଜି ଇନିକା, ମାରି, ନିଙ୍ଗିଁଆ, ବୁଲାଆ ଇଜି ଇନିକା ? ");
INSERT INTO kfcp_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ମାତର୍‌ ସାରାଦୁନିଆଦୁ ପାପ୍‌କେମା କିଦେଙ୍ଗ୍‌ ମନୁସ୍ୟପୁତ୍ରଦିଙ୍ଗ୍‌ ଜେ ଅଦିକାର୍‌ ମାନାତ୍‌, ଇକା ଏଣ୍ତେସ୍‌ ମିର୍‌ ନେସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‌ନିଦେର୍‌ ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ଆୟା ପକିୟାଗାତି ରୋଗିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନାନ୍ ନିଙ୍ଗିଁ ଇଜିନା, ନିଙ୍ଗିଁଆ, ନିଜେଦି ଟାଟି ଆସ୍‌ସି ମି ଇଣ୍ତ୍ରସାଙ୍ଗ୍‍ଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ଆବେଟ୍‌ତାନ୍‌ ୱାନ୍‌ ଆୟାଦାପ୍ରେ ୱାରି ଆଗିଡ଼ିରାନ୍‌, ନିଙ୍ଗ୍‌ଜି, ଏମେ କାଟେଲ୍‍ ମୁସ୍‌କୁ ୱାନ୍‌ ଡରିତା ମାର୍ହାନ୍‌, ଆୟା କାଟେଲ୍‌ ଆସ୍‌ଇ ମାପୁରୁଙ୍ଗ୍‌ ଦନ୍ୟବାଦ୍‌ ପ୍ରସଂସା କିଜି କିଜି ନିଜେଦି ଇଣ୍ତ୍ର ସୋର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ଆବେଟ୍‌ ୱିଜେରେ କାବାତାରୋ ମାପୁରୁଙ୍ଗ୍‌ ଦନ୍ୟବାଦ୍‌ ପ୍ରସଂସା କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ ମାରି ନାଣ୍ତ ତିଲାତାରୋ ଇର୍ହାର୍‌, “ନେରୁ ମାପ୍‌ କାବାଆନି ଗଟ୍‌ଣା ସୁଡ଼ୁତାପ୍‌ !” ");
INSERT INTO kfcp_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ତାନେୱେନ୍‌କା ଜିସୁ ସୋତା ସର୍ହାନ୍‌ନୋ ଲେବି ଦର୍‌ତି ଅରେନ୍‍ ୱାନିଙ୍ଗ୍‌ ସିସ୍‍ଟୁ ଲସ୍‌ନି ବାଡିଦୁ ବାସ୍‌ତି ମାରିକା ସୁଡ଼ୁଜି ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନା ୱେନ୍‌କା ରାଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ଆବେଟ୍‌ ଲେବି ୱିଜୁ ଡ଼ିସ୍‌ତାନ୍‌ନୋ ନିଙ୍ଗିଁଜି ୱାନି ୱେନ୍‌କା ସଣ୍ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ମାରି, ଲେବି ନିଜେଦି ଇନ୍‌ଡ୍ର ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ଉଣ୍ତ୍ରି ପେରି ବଜି କିତାନ୍‌, ମାରି ନାଣ୍ତଲୋକୁ ସିସ୍‍ଟୁ ଲସ୍‌ନିକାର୍‌ ମାରି ଆଇ ଆଇ ଲୋକୁ ୱାରି ୱାଲେ ଉଣ୍ତେଙ୍ଗ୍‌ ବାସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ଆବେଟ୍‌ ପାରୁସିର୍‌ ମାରି ୱାରି ଦଲ୍‌ତି ସାସ୍ତ୍ରିର୍‍ ଜିସୁଦି ସିସୁରି ବିରଦ୍‌ତାନ୍‌ ବାସେ କିଜି ଇଣ୍ତ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, “ମିର୍‌ ଏନ୍ଧା ସିସ୍‍ଟୁ ଲସ୍‌ନିକାର୍‌ ମାରି ପାପିଲୋକା ୱାଲେ ଉଣୁଞ୍ଜିତିଞ୍ଜିନିଦେର୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ୱେର୍‌ତାନ୍‌, “ନେଗି ଲୋକାଙ୍ଗ୍‌ ଡାକ୍‌ତର୍‌ମାନୁ ଦର୍‌କାର୍‌ ସିଲେ, ମାତର୍‌ ରୋଗ୍‍ତି ଲୋକାଙ୍ଗ୍‌ ଡାକ୍‌ତର୍‌ତି ମାନୁ ଦର୍‌କାର୍‌ ମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ନାନ୍ ଦାର୍ମୁ ଲୋକାଙ୍ଗ୍‌ କୁକ୍‌ନି ଉଣ୍ତିଙ୍ଗ୍‌ ରେଏ, ମାତର୍‌ ମୋନ୍‌ତିଙ୍ଗ୍‌ ଡ଼େପ୍‍ନି ଉଣ୍ତିଙ୍ଗ୍‌ ପାପି ଲୋକାଙ୍ଗ୍‌ କୁକ୍‌ତେଙ୍ଗ୍‌ ଇଜି ୱାତାମାନା ।” ");
INSERT INTO kfcp_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ଏସୋଲୋକ୍‍ ଜିସୁଙ୍ଗୁଁ ୱେନ୍‍ବାତାର୍‌, “ଡୁବନ୍‌ ସିନି ଜୋହନତି ସିସୁର୍‍ ମାରି ଅର୍‍ସୁ ମାରି ଉପାସ୍‌ ମାରି ପାର୍‍ତନା କିନାର୍‌, ପାରୁସିର୍‌ ସିସୁର୍‍ ବା ଆୟାୱାଜା କିନାର୍‌, ମାତର୍‌ ନି ସିସୁର୍‍ ଉଣାର୍‍ତିନାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ଆବେଟ୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “କାନ୍ୟାମୁରୁଲିରି ୱାଲେ ମୁରୁଲି ମାନିୱାଲେ ମିର୍‌ ଇନିକା ୱାରିଙ୍ଗ୍‌ ଉପାସ୍‌ ତେବାକିଦେଙ୍ଗ୍‌ ଆଟ୍‌ନିଦେର୍‌ ? ମୁଡ଼ୁକେ ସିଲେ । ");
INSERT INTO kfcp_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ମାତର୍‌ ସମୟ ୱାନାତ୍‌, ମାରି, ଏସ୍ତିୱାଲେ ୱାରିମାଣାନ୍‌ ମୁରୁଲିଙ୍ଗ୍‌ ୱେର୍‌ଏ କିନାର୍‌, ନାସ୍ତିୱାଲେ ଆୟାୱାଲେ ୱାର୍‌ ଉପାସ୍‌ କିନାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ମାରି, ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଉଣ୍ତ୍ରି କାତାବା ଇର୍‌ଆନ୍‌, “ଏନ୍‌ ପୁନି ୱାତିଦି ଇସ୍ରି ଅଟିଦିଙ୍ଗ୍‍ ଅସି ପାଡ଼ିଇ ୱାତିଦୁ ଗୁତ୍‌ଏନ୍‌; ଗୁତ୍‌ତିଙ୍ଗ୍‌ ଆୟା ପୁନି ୱାତିଦି ଅଟି ପାଡ଼ିଇ ୱାତିଦିଙ୍ଗ୍‌ କିଜିସ୍‌କିନାତ୍‌, ମାରି ପୁନି ୱାତିଦି ଅଟି ବା ପାଡ଼ିଇ ୱାତିଦି ୱାଲେ ମିସାଏତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ମାରି, ଏନ୍‌ ପୁନି ଅଙ୍ଗୁର୍‍ ରସ୍‌ତିଙ୍ଗ୍‌ ପାଡ଼ିଇ ସାଟିଦୁ ଇଡ୍‍ଏନ୍‍; ଜଦି ଇଟ୍‌ତିଙ୍ଗ୍‌ ପୁନି ଅଙ୍ଗୁର୍‍ରସ୍‍ ସାଟିଦିଙ୍ଗ୍‌ ପାଡିସ୍‌ କିଜି ପଗ୍‌ନାସୋନାତ୍‌, ମାରି ସାଟିବା ନାସ୍ଟୁ ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ମାତର୍‌ ପୁନି ଅଙ୍ଗୁର୍‍ ରସ୍‌ତିଙ୍ଗ୍‌ ପୁନି ସାଟିଦୁ ଇଡ୍‌ନିକା ମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ମାରି, ଏନ୍‌ ପାଡ଼ିଇ ଅଙ୍ଗୁର୍‍ ରସ୍‌ତିଙ୍ଗ୍‌ ଉଣାନ୍‌ନୋ ପୁନି ଅଙ୍ଗୁର୍‍ ରସ୍‌ତିଙ୍ଗ୍‌ ଉଣ୍ତେଙ୍ଗ୍‌ ବଦା କିଏନ୍‌, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ଇନାନ୍‌, ପାଡ଼ିଇ ଅଙ୍ଗୁର୍‍ ରସ୍‌ନେ ନେଗିକା ।” ");
INSERT INTO kfcp_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ଅର୍‍ଲେନ୍‍ ରମ୍‍ନିଦିନ୍‍ତୁ ଜିସୁ ପାସି କିଡ଼ିଇ ସିଜି ସନି ୱାଲେ ୱାନି ସିସୁର୍‍ ସେରେନ୍‍କୁ ତେଉଜି ତେଉଜି କିୟୁଦୁ ରାସ୍‌ଇ ତିନ୍‌ଜି ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ମାତର୍‌ ପାରୁସିର୍ ମାଣ୍‌କୁ ଏସ ଲୋକୁ ଇର୍ହାର୍‌, “ରମ୍‌ନିଦିନ୍‍ତୁ ଏମେକା କିଦେଙ୍ଗ୍‌ ନିୟମ୍‌ ସିଲେତ୍‌, ଆକା ମିର୍‌ ଏନ୍ଧା କିଜିନିଦେର୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଦାଉଦ ମାରି ୱାନି ସାଙ୍ଗର୍‌ ବାଙ୍ଗାଁ ଆତିୱାଲେ ୱାନ୍‌ ଇନିକା କିତାମାର୍‌ଆନ୍‌, ଆକାବା ଇନିକା ମିର୍‌ ପଡ଼ାଇଦେର୍‍ ନୋ ? ");
INSERT INTO kfcp_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ଦାଉଦ ଏଣ୍ତେସ୍‌ ମାପୁରୁଦି ଇଲୁତୁ ଡ଼ୁଗିତାନ୍‌ନୋ, ଆମା ପୁଜାସିନି ରୁଟି ଜାଜକରିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ମାରି ଏନ୍‌ବା ତିଣ୍ତ୍ରେଙ୍ଗ୍‌ ନିୟମ୍‌ ସିଲେତ୍‌, ଆକା ଅତାନ୍‌ନୋ ତିରାଆ ମାର୍‌ଆନ୍‌, ମାରି ୱାନି ତଡ଼୍‌ ଲୋକାଙ୍ଗ୍‌ ବା ସିତା ମାର୍‌ଆନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ମାରି, ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ମନୁସ୍ୟପୁତ୍ର ରମ୍‌ନିଦିନ୍‍ତି ପ୍ରବୁ ଆନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ଜିସୁ ମାରି ଅର୍‍ଲେନ୍‍ ରମ୍‌ନିନାଣ୍ତିଙ୍ଗ୍‌ ପାର୍‌ତନା ଇଲୁତୁ ଡ଼ୁଗିତାନ୍‌ନୋ ସିକିୟା ସିଜି ମାର୍‌ଆନ୍‌, ଆବେଟ୍‌ ଅରେନ୍‍ ଲୋକୁ ମାର୍‌ଆନ୍‌, ୱାନି ଉଣି କିୟୁ ୱାର୍‌ତା ମାର୍‌ଆତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ମାରି, ୱାନ୍‌ ଏଣ୍ତେସ୍‌ ରମ୍‌ନିନାଣ୍ତିଙ୍ଗ୍‌ ନେଗେଣ୍ତ୍‌ କିନାନ୍‌ନୋ ସିଲେ, ଇକା ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ଇଜି ସାସ୍ତ୍ରିରି ମାରି ପାରୁସିର୍‌ ୱାନିଙ୍ଗ୍‌ ସୁଡ଼ୁଜି ମାର୍‌ଆର୍‌, ଏଣ୍ତେସ୍‌କି ୱାର୍‌ ୱାନି ବିରୁଦ୍‍ତାନ୍‍ ଦୋସ୍‌ କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ମାତର୍‌ ୱାନ୍‌ ୱାରି ମନ୍‌ତୁ ଅଡ଼୍‍ବିନିକା ନେସ୍‌ତାନ୍‌ନୋ, ଏମେ ଲୋକ୍‌ତି କିୟୁ ୱାର୍‌ତା ସୋର୍‌ଆ ମାର୍‌ଆତ୍‌, ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନିଙ୍ଗିଁଆ, ନାଣ୍‌ମି ନିଲ୍‌ଆ ।” ମାରି, ୱାନ୍‌ ନିଙ୍ଗ୍‌ଜି ନିର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ଆବେଟ୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନାନ୍ ମିଙ୍ଗିଁ ୱେନ୍‌ବାଜିନା, ରମ୍‌ନି ନାଣ୍ତିଙ୍ଗ୍‌ ଇନିକା କିଦେଙ୍ଗ୍‌ ନିୟମ୍‌ ସିଲେତ୍‌ ? ନେଗେନ୍‌ କିଦେଙ୍ଗ୍‌ ନୋ ସେଏଣ୍ତ୍‍ କିଦେଙ୍ଗ୍‌ ? ଜିବନ୍‌ ରକିୟା କିନିକା ନୋ ସାପିସ୍‌ନିକା ?” ");
INSERT INTO kfcp_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ମାରି, ଜିସୁ ସାରିବେଡ଼୍‍ତି ୱିଜେରିଙ୍ଗ୍‌ ସୁଡ଼୍‌ଜି ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନି କିୟୁ ପେର୍‌ଆ ।” ଆବେଟ୍‌ ୱାନ୍‌ ୱାନି କିୟୁ ପେର୍‍ତାନ୍‍, ମାରି ୱାନି କିୟୁ ନେଗେନ୍‌ ଆତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ମାତର୍‌ ୱାର୍‌ ନାଣ୍ତ ରିସା ଆତାର୍‌, ମାରି ଜିସୁଦି ବିରଦ୍‌ତାନ୍‌ ଇନିକା କିଦେଙ୍ଗ୍ ଆଟ୍‍ନାର୍‍, ଆୟା ବିସୟ୍‌ତାନ୍ ନିଜେ ନିଜେଦିମାନୁ ୱାର୍‌ଗିଜି ସାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ଆୟାୱାଲେ ଜିସୁ ଅର୍‍ଲେନ୍‍ ପାର୍‌ତନା କିଦେଙ୍ଗ୍‌ ଇଜି ଗରନ୍‌ତୁ ସର୍‌ଆନ୍‌ । ଆବେ ମାପୁରୁଦିମାନୁ ପାର୍‌ତନା କିବୁ କିବୁ ନାଡ଼ାୱିଗ୍‌ଜି ତେବାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ମାର୍‌ନାଣ୍ଡିଙ୍ଗ୍‌ ସାଲ୍‍ଦି ଆତାତ୍‌, ଜିସୁ ନିଜେଦି ସିସୁରିଙ୍ଗ୍‌ ଲାକ୍‌ତୁ କୁକ୍‌ସି ୱାରି ମାଣାନ୍‌ ବାରଲୋକାଙ୍ଗ୍‌ ଆସ୍‌କିତାନ୍‍, ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ପ୍ରେରିତ ଦର୍‌ ସିତାନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ୱାର୍‌ ଆତାର୍‌, ସିମୋନ, ଆମାୱାନିଙ୍ଗ୍‌ ୱାନ୍‌ ପିତର୍‌ ଇଜି ଦର୍‌ ସିତାନ୍‌, ମାରି ୱାନି ତଡ଼ାନ୍‌ ଆନ୍ଦ୍ରିୟ, ଜାକୁବ ମାରି ଜୋହନ, ପିଲିପ୍‌ ମାରି ବାର୍ତଲମି, ");
INSERT INTO kfcp_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ମାତିଉ ମାରି ତୋମା, ଆଲପିତି ମାରିସ୍‌ ଜାକୁବ ମାରି ସିମୋନ, ଆମାୱାନିଙ୍ଗ୍‌ ୱେଡ଼ିକାକିନିକାନ୍‌ ଇଜି ଇନାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ଜାକୁବଦି ମାର୍‌ନି ଜିହୁଦା ମାରି ଇସ୍କାରିୟୋତିୟ ଜିହୁଦା, ଏନ୍‌ ଜିସୁଙ୍ଗୁଁ ସାତ୍ରୁରି କିୟୁଦୁ ସପ୍ରେକିତା ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ମାରି, ଜିସୁ ସିସୁରି ୱାଲେ ଗରନ୍‌ତାନ୍‍ ରେସି ୱାତାନ୍‌ । ମାରି ସାର୍‍ଦିତି ବୁମିଦୁ ନିଜେଦି ନାଣ୍ତ ଲୋକୁ ସିସୁରି ୱାଲେ ନିର୍‍ଆନ୍‍ । ମାରି ୱିଜୁ ଜିହୁଦା ଦେସ୍‍, ଜିରୁସାଲାମ୍‍, ମାରି ସାମ୍‌ଦୁର୍‌ତିପାଡ଼ିଦି ସୋର୍‍ ନି ସିଦନ୍‍ ଗାଡ଼୍‍ତି ନାଣ୍ତ ଲୋକୁ ୱାନି ଲାକ୍‌ତୁ ୱାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ୱାର୍‌ ୱାନି ବାକ୍ୟ ୱେନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ମାରି ନିଜେ ନିଜେଦି ରୋଗ୍‌ତାନ୍‌ ନେଗେନ୍‌ ଆଦେଙ୍ଗ୍‌ ୱାତା ମାର୍‌ଆର୍‌, ମାରି ଏର୍‌ ତାଗିଇଦୁବେଙ୍ଗ୍‌ ମାଣ୍‌କୁ କାସ୍ଟୁ ପଇଜି ମାର୍‌ଆର୍‌, ୱାରିଙ୍ଗ୍‌ ୱାନ୍‌ ନେଗେନ୍‌ କିତାନ୍‍; ");
INSERT INTO kfcp_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ମାରି ଲୋକୁ ୱିଜେରେ ୱାନିଙ୍ଗ୍‌ ମୁଟ୍‌ତେଙ୍ଗ୍‌ ଇଜି ବଦାକିଜି ମାର୍‌ଆର୍‌, ମାତର୍‌ ୱାନିମାଣାନ୍‌ ସାକ୍ତି ସୋସି ଲୋକାଙ୍ଗ୍‌ ନେଗେଣ୍ତ୍‌ କିଜିମାର୍‌ଆତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ଆୟାୱାଲେ ଜିସୁ ନିଜେଦି ସିସୁରି ତରିଣ୍ତ୍‌ ସୁଡ଼ୁଜି ଇର୍‌ଆନ୍‌, କାକୁର୍ତିଲୋକୁ ଜେ ମିର୍‌, ମିର୍‌ ଦନ୍ୟ, ଇରିଙ୍ଗ୍‌ ମାପୁରୁଦି ରାଜି ମିଦି । ");
INSERT INTO kfcp_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ଇଲେଇ ବାଙ୍ଗାଁଦୁ ମାନିଦେର୍‌ ଜେ ମିର୍‌, ମିର୍‌ ଦନ୍ୟ, ଇରିଙ୍ଗ୍‌ ମିର୍‌ ପଟା ପାଜ୍‌ନିଦେର୍‌, ଇଲେଇ ଆଡ଼୍‍ବାଜିନିଦେର୍‍ ଜେ ମିର୍‌, ମିର୍‌ ଦନ୍ୟ, ଇରିଙ୍ଗ୍‌ ମିର୍‌ ସିକ୍‍ନିଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ଲୋକୁ ଏସ୍‌କାଙ୍ଗ୍‌ ମନୁସ୍ୟପୁତ୍ର ଉଣ୍ତିଙ୍ଗ୍‌ ମିଙ୍ଗିଁ କାଡ଼୍‍ନାର୍‌ ମାରି ୱେର୍‌ଏ କିନାର୍‌, ମାରି ନିନ୍ଦା କିନାର୍‌, ମାରି ମି ଦର୍‌ତିଙ୍ଗ୍‌ ତାଗିଇକା ଇଜି ମାନାଏର୍‌, ଆରିଙ୍ଗ୍‌ ମିର୍‌ ଦନ୍ୟ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ଆୟା ନାଣ୍ତିଙ୍ଗ୍‌ ୱେଡ଼ିକା କିଜି ଗାତ୍‌ତୁ, ମାତର୍‌ ସୁଡ଼ୁଦୁ, ମି ଉଣ୍ତିଙ୍ଗ୍‌ ମୁସ୍‌କୁପୁର୍‌ତୁ ମି ପୁରସ୍‌କାର୍‌ ନାଣ୍ତ ମାନାତ୍‌, ମାରି, ଆୟାୱାଜା ତୋ ୱାରି ପୁର୍ବେଦି ଡକ୍ରାଦାଦାର୍‌ରି ବାବବାଦିରି ଉଣ୍ତିଙ୍ଗ୍‌ କିଜିମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","ମାତର୍‌ ଚି, ଦଣ୍ଡ୍‌ ପଇନି ମାଜନ୍‌ ଲୋକୁ ଜେ ମିର୍‌, ଇରିଙ୍ଗ୍‌ ମିର୍‌ ନିଜେ ନିଜେଦି ସୁକ୍‌ ପ‍ଇଜିନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ଚି, ଦଣ୍ଡ୍‌ ପଇନି ଲୋକୁ ଇଲେଇ ପଟାପାଜ୍‍ଜିନିଦେର୍‍ ଜେ ମିର୍‌, ଇରିଙ୍ଗ୍‌ ମିର୍‌ ବାଙ୍ଗାଁ ଆନିଦେର୍‌, ଚି, ଦଣ୍ଡ୍‌ ପଇନି ଲୋକୁ ଇଲେଇ ସିକ୍‌ସିନିଦେର୍‌ ଯେ ମିର୍‌, ଇରିଙ୍ଗ୍‌ ମିର୍‌ ଏତ୍‍କିଜିଆଡ୍‌ବାନିଦେର୍‍ ମାରି ଆଡ଼୍‌ବାନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ଏସ୍ତିୱାଲେ ଲୋକୁ ୱିଜେରେ ମିଙ୍ଗିଁ ୱେଙ୍ଗିଁସ୍‍ କିନାର୍‌, ନାସ୍ତିୱାଲେ ଚି, ମିର୍‌ ଦଣ୍ଡ୍‌ ପଇନି ଲୋକୁ; ଆୟାୱାଜା ତୋ ୱାରି ପୁର୍ବେଦି ଡକ୍ରାଦାଦାର୍‍ ବଣ୍ତ ବାବବାଦିରିଙ୍ଗ୍ ବା ନେଗିକାର୍‍ ଇଜିମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","ମାତର୍‌ ୱେନ୍‌ଞ୍ଜିନିଦେର୍‌ ଜେ ମିର୍‌, ମିଙ୍ଗିଁ ନାନ୍ ଇଜିନା, ମି ସାତ୍ରୁରିଙ୍ଗ୍ ଜିବନ୍‍ନୋଦୁ; ଏର୍‌ ମିଙ୍ଗିଁ କାଡ଼୍‌ନାର୍‌, ୱାରିଙ୍ଗ୍‌ ଆର୍ସିବାଦ୍‌ କିଦୁ; ");
INSERT INTO kfcp_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ଏର୍‌ ମିଙ୍ଗିଁ ଆନାଦୁରିଆ କିନାର୍‌, ୱାରିଙ୍ଗ୍‌ ଆର୍ସିବାଦ୍‌ କିଦୁ; ଏର୍‌ ମିଙ୍ଗିଁ ନିନ୍ଦା କିନାର୍‌, ୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ପାର୍‌ତନା କିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ଏନ୍‌ ମିଙ୍ଗିଁ ଉଣ୍ତ୍ରି ବୁଗୁଲିଦୁ ଚାପ୍‌ଡ଼ା ଡାକ୍‌ନାନ୍‍, ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ଆଇ ବୁଗୁଲି ବା ତର୍‌ସୋ ସିଦୁ; ମାରି, ଏନ୍‌ ମି ସାଦର୍‌ ଅନାନ୍‍, ୱାନିଙ୍ଗ୍‌ ମି ଆଙ୍ଗିଁ ବା ଅତେଙ୍ଗ୍‌ ମାନା କିମାଟ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ଏନ୍‌ଆପିନ୍‌ ମିଙ୍ଗିଁ ଇନି ଜିନିସ୍‌ ଲୋସ୍‍ନାନ୍‍, ୱାନିଙ୍ଗ୍‌ ସିଦୁ; ମାରି, ଏନ୍‌ ମି ଦନ୍‌ ଅନାନ୍‍, ୱାନିମାଣ୍‌ନା ଆକା ମାରିଡ଼େସି ଲସ୍‌ମାଟ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ଲୋକୁ ମି ଉଣ୍ତିଙ୍ଗ୍‌ ଏଣ୍ତେସ୍‌ବା ମାନାପିର୍‌ ଇଜି ବଦା କିନିଦେର୍‌, ମିର୍‌ ୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ଆୟାୱାଜା କିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ମାରି, ଏର୍‌ ମିଙ୍ଗିଁ ଜିବନ୍‌ନୋନାର୍‌, ମିର୍‌ ଜଦି ୱାରିଙ୍ଗ୍‌ନେ ଜିବନ୍‌ନୋତିଙ୍ଗ୍‌ ମିର୍‌ ଇନିକା ଦୟା ପଇନିଦେର୍‌ ? ଇରିଙ୍ଗ୍‌ ପାପି ଲୋକ୍‌ ବା ନିଜେ ନିଜେଦି ଲାଡ଼୍‌କିନିୱାରିଙ୍ଗ୍‌ ଲାଡ୍‌ କିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ମାରି, ଏର୍‌ ମିଙ୍ଗିଁ ଆର୍ସିବାଦ୍‌ କିନାର୍‌, ଜଦି ମିର୍‌ କେବଲ୍‌ ୱାରିଙ୍ଗ୍‌ନେ ନେଗେନ୍‌ କିନିଦେର୍‌, ଆରିଙ୍ଗ୍‌ ମିର୍‌ ଇନିକା ଦୟା ପଇନିଦେର୍‌ ? ଇରିଙ୍ଗ୍‌ ପାପି ଲୋକ୍‌ ବା ଆୟାୱାଜା କିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ମାରି, ଏମେୱାରିମାଣ୍‌କୁ ମି ପଇନି ଆସା ତେବାତାନ୍‌, ୱାରିଙ୍ଗ୍‌ନେ ରୁଣୁ ସିତିଙ୍ଗ୍‌ ମିର୍‌ ଇନିକା ଦୟା ପଇନିଦେର୍‌ ? ପାପିଲୋକ୍‌ ଆକା ସାମାନ୍‌ତାନ୍‌ନେ ଡ଼େସି ପଇନି ଉଣ୍ତିଙ୍ଗ୍‌ ପାପି ଲୋକାଙ୍ଗ୍‌ ରୁଣୁ ସିନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ମାତର୍‌ ମି ସାତ୍ରୁରିଙ୍ଗ୍‌ ଜିବନ୍‌ନଦୁ ମାରି ୱାରିଙ୍ଗ୍‌ ଆର୍ସିବାଦ୍‌ କିଦୁ, ମାରିଡ଼େସି ପ‍ଇଦେଙ୍ଗ୍‌ ଆସ୍‌ଏଣ୍ତା ରୁଣୁ ସିଦୁ; ଆଦେଙ୍ଗ୍‌ ମି ପୁରସ୍କାର୍‍ ନାଣ୍ଡ୍ ଆନାତ୍‌ ମାରି ମିର୍‌ ପେରି ମାପୁରୁଦି ମାରିନ୍‌ ଆନିଦେର୍‌, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ସାଲାକି ନି ତାଗିଇୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ବା ଦୟା କିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ମି ବୁବା ଏଣ୍ତେସ୍‌ କାର୍ମୁଦିକାନ୍‍, ମିର୍‌ ଆୟାୱାଜା କାର୍ମୁଦିକାର୍‍ ଆଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“ମାରି, ବିସାର୍‌ କିମାଟ୍‌, ଆଦେଙ୍ଗ୍‌ ମିର୍‌ ବିଚାର୍‌କିଆୟ୍‌ ଆଇଦେର୍‍; ଏମେ ଲୋକ୍‌ତିଙ୍ଗ୍‌ ବା ଦସ୍‍ କିମାଟ୍‌, ଆତିଙ୍ଗ୍‌ ମିର୍‌ ଦସି କିଆୟ୍‌ଆଇଦେର୍‌ । ଆଇୱାନିଙ୍ଗ୍‍ କେମା କିଦୁ, ଆଦେଙ୍ଗ୍‌ ମିଙ୍ଗିଁ ବା କେମା କିନାନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ଆଇୱାନିଙ୍ଗ୍‍ ଦାନ୍‌ ସିଦୁ, ଆଦେଙ୍ଗ୍‌ ମିଙ୍ଗିଁ ଦାନ୍‌ ସିନାର୍‍; ମାପୁରୁ ଅଡିଦୁ ପୁରା କିଜି ତାନିଙ୍ଗ୍‌ ତିଗ୍‌ଜି ଦୁକ୍‌ସି ବର୍ତି କିଜି ମି ଅଟିଦୁ ସିନାର୍‍; ଇରିଙ୍ଗ୍‌ ଏମେ ଅଡିଦାନ୍‌ ଇସାବ୍‌ କିଜ ଇସାବ୍‌ କିଦୁ, ଆୟା ଅଡିଦାନ୍‌ ମିଙ୍ଗିଁ ମାରି ଇସାବ୍‌ କିନାସିନାର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଉଣ୍ତ୍ରି ମାଟା ବା ୱେର୍‌ତାନ୍‌, ଅରେନ୍‍ କାଣା ଇନିକା ମାରି ଅରେନ୍‍ କାଣାଦିଙ୍ଗ୍‌ ସାରି ତର୍‌ତେଙ୍ଗ୍‍ଁ ଆଟ୍‍ନାନ୍‍ ? ଜଦି ୱାନ୍‌ ଆୟାୱାଜା କିନାନ୍‍, ଆରିଙ୍ଗ୍‌, ୱାର୍‌ ଇନିକା ରିଏର୍‌ବା ଗୁଟାଦୁ ଆର୍‌ଏର୍‌ ନୋ ? ");
INSERT INTO kfcp_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ଗୁରୁମାଣାନ୍‍ ସିସୁ ପେରିକାନ୍‌ ଆଏନ୍‍; ଇରିଙ୍ଗ୍‌ ୱିଜେରେ ସିସୁ ସିକିୟା ଅଜାତି ୱେନ୍‌କା ନିଜେଦି ଗୁରୁଦି ସାମାନ୍‍ ଆନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","ମାରି, ଏନ୍ଧା ମି ତଡ଼ାନ୍‌ତି କାଣ୍‌ଗାଦୁ ମାନି ଇସ୍ରିକାସ୍ରାଦିଙ୍ଗ୍‌ ସୁଡ଼ୁଜିନିଦେର୍‍, ମାତର୍‌ ମି ନିଜେଦି କାଣ୍‌ଗାଦୁ ଏମେ ପେରି କାସ୍‌ରା ମାନାତ୍‌, ଆକା ଅଡ଼୍‍ବିଜି ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏଜିନିଦେର୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ନିନୁ ନିଜେଦି କାଣ୍‌ଗାଦୁ ମାନି ଇସ୍ରିକାସ୍ରା ସୁଡ଼ୁଏଣ୍‌ଗା ଏଣ୍ତେସ୍‌ ନିଜେଦି ତଡ଼ାନ୍‌ତିଙ୍ଗ୍‌ ଇଣ୍ତ୍ରେଙ୍ଗ୍‌ ଆଟ୍‌ନି, ତଡ଼ାନ୍‌, ରାଆ, ନି କାଣ୍‌ଗାଦୁ ମାନି ଇସ୍ରିକାସ୍ରା କୁତ୍‌ନା ସିନା ?ଏ ପୁଲାପୁଲି କିନିକିନ୍ଦେର୍‍, ଆଗିଡ଼ି ନିଜେଦି କାଣ୍‌ଗାଦାନ୍‌ ପେରି କାସ୍‌ରା କୁତ୍‌ସ ପୋକ୍‌ଆ, ତାନିୱେନ୍‌କା ନିଜେଦି ତଡ଼ାନ୍‌ତି କାଣ୍‌ଗାଦୁ ମାନି ଇସ୍ରିକାସ୍ରା କୁତ୍‌ନି ଉଣ୍ତିଙ୍ଗ୍‌ ନେଗ୍ରେଣ୍ତା ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ଆଟ୍‌ନି । ");
INSERT INTO kfcp_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","ମାତର୍‌ ଇୟାୱାଜା ମାରାନ୍‌ ସିଲେତ୍‍, ଆମାକାକି ତାଗିଇ ମାରାନ୍‌ ନେଗି ପଲ୍‌ ଆସ୍‌ଏତ୍‌, ବା ନେଗି ମାରାନ୍‌ ତାଗିଇ ପଲ୍‌ ଆସ୍‌ଏତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ଇରିଙ୍ଗ୍‌ ୱିଜୁ ମାରାକା ନିଜେଦି ପଲ୍‌ଦାନ୍‌ ଚିନିସ୍‌ନାର୍‌; ସାମ୍‌ମାରାନ୍‌ତାନ୍‌ ତୋ ଲୋକୁ ତଗା କୟ୍‌ଏର୍‌, ମାରି ସାମ୍‌ ଦୁପାଦାନ୍‌ ଅଙ୍ଗୁର୍‍କୋଡ଼ି କୟ୍‌ଏର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ଅରେନ୍‍ ନେଗି ଲୋକ୍‌ଦି ମୋନ୍‌ ଲୋଇ ନେଗି ବିସୟ୍‌ ଉଣ୍ତାତିମାନିକା, ଆଦେଙ୍ଗ୍‌ ୱାନି ମୋନ୍‌ ଲୋଇରାନ୍‌ ନେଗି ବିସୟ ସୋନାତ୍‌ । ମାତର୍‌ ଅରେନ୍‍ ତାଗିଇ ଲୋକ୍‌ଦି ମୋନ୍‌ ଲୋଇ ତାଗିଇ ବିସୟ୍‌ ଉଣ୍ତାତିମାନିକା, ଆଦେଙ୍ଗ୍‌ ୱାନି ମୋନ୍‌ ଲୋଇରାନ୍‌ ତାଗିଇ ବିସୟ ସୋନାତ୍‌, ଅରେନ୍‍ ଲୋକ୍‌ଦି ମୋନ୍‌ ଲୋଇ ଆମାକା ତେବାତାନ୍‌, ୱାନ୍‌ ଆକା ଇନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“ମାରି, ମିର୍‌ ଏନ୍ଧା ନାଙ୍ଗିଁ ପ୍ରବୁ, ପ୍ରବୁ ଇଜି କୁକ୍‌ସିନିଦେର୍‌, ମାତର୍‌ ନା ମାଟା ମାନାଇଜିନିଦେର୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ଏନ୍‌ଆପିନ୍‌ ନା ଲାକ୍‌ତୁ ୱାଜି ନା ମାଟା ୱେନ୍‌ଞ୍ଜି ଆୟାୱିଜୁ ମାନାନାର୍‌, ୱାନ୍‌ ଏୱାଜା ଆନାନ୍‌, ଆକା ନାନ୍ ମିଙ୍ଗିଁ ୱେର୍‌ନା । ");
INSERT INTO kfcp_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ୱାନ୍‌ ଇୟାୱାଜା ଅରେନ୍‍ ଇଲୁ ତିଆର୍‌କିନି ଲୋକୁ ୱାଜା, ୱାନ୍‌ ନାଣ୍ତ ଗୁଟା କିଜି କାର୍‌ନାନ୍‌ନୋ ମୁଲ୍‍କାଲୁ ମୁସ୍‌କୁ ବାସାକିନାନ୍‌; ମାରି, ପିରୁ ୱାଜି, ଏରୁ ଆୟା ଇଲୁଦିଙ୍ଗ୍‌ ଦେଲେପ୍‍ସୋ ଅତେଙ୍ଗ୍‌ ନାଣ୍ତ୍‌ଦାନ୍‌ ଡୁକାତାତ୍‌, ମାତର୍‌ ଆକା ଦୁକ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‍ଏତାତ୍‌, ଇରିଙ୍ଗ୍‌ ଇଲୁ ଡାଟ୍‌ତାନ୍‌ ତିଆର୍‌ ଆତାମାର୍‌ଆତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ମାତର୍‌ ଏନ୍‌ ମାଟା ୱେନ୍‌ଞ୍ଜି ମାନାଏନ୍‌, ୱାନ୍‌ ମୁଲ୍‍କାଲୁ ବାସାକିଏଣ୍ତା ସିକ୍‌ଲା ମୁସ୍‌କୁ ଇଲୁ ତିଆର୍‌କିନି ଲୋକୁ ୱାଜା; ଏରୁ ଆୟା ଇଲୁଦିଙ୍ଗ୍‌ ନାଣ୍ତ୍‌ଦାନ୍‌ ଡୁକାତିଙ୍ଗ୍‌, ଆୟାଦାପ୍ରେ ଇଲୁ ୱିର୍‌ଜିତାତ୍‌ ମାରି ତାନି ୱିର୍‍ଜିତିକା ବୟ୍‌ଙ୍କାର୍‌ ଆତାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ଜିସୁ ଲୋକାଙ୍ଗ୍‌ ନିଜେଦି ୱିଜୁ ମାଟା ୱେର୍‌ତି ୱିସ୍‌ତି ୱେନ୍‌କା କପର୍‍ନାହୁମ୍‍ତୁ ସୋର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ଆୟା ୱେଡ଼ାଦୁ ଅରେନ୍‍ ରମିୟ ନେତାଦି ଗତିମୁରୁଲି ନବ୍‌ ଆଜି ସାନି ୱାଜା ଆତାମାର୍ହାନ୍‍, ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ନାଣ୍ତ ଜିବନ୍‍ନୋଜି ମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ୱାନ୍‌ ଜିସୁଦି ମାଟା ୱେନ୍‍ଞ୍ଜ, ୱାନ୍‌ ୱାଜି ୱାରି ଗତିମୁରୁଲି ଜିବନ୍‌ ରକିୟା କିଦେଙ୍ଗ୍, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାରି ଲାକ୍‌ତୁ ଜିହୁଦିର୍‌ ଏସ ପେରି ନେତାରିଙ୍ଗ୍‌ ପକ୍‍ସି ୱାନିଙ୍ଗ୍‌ ୱାଦେଙ୍ଗ୍‌ ଇର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ୱାର୍‌ ଜିସୁ ଲାକ୍‌ତୁ ସଲ୍‌ସି ୱାନିଙ୍ଗ୍‌ ନାଣ୍ତ ମାଡ଼ିସ୍‌ କିଜି ଇଣ୍ତ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, ନିନୁ ଜେ ୱାରି ଲାକ୍‌ତୁ ଇୟାକା କିନି, ୱାନ୍‌ ଆବେଟ୍‌ ଜଗ୍‌ ଆନାନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ମାତର୍‌ ୱାନ୍‌ ମା ଜାତିଦିଙ୍ଗ୍‍ ନାଣ୍ତ ଜିବନ୍‌ନୋନାନ୍‌ ମାରି ନିଜେ ମା ଉଣ୍ତିଙ୍ଗ୍‌ ପାର୍‌ତନା ଇଲୁ ତିଆର୍‍କିତା ସିତାମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ଆବେଟ୍‌ ଜିସୁ ୱାରି ୱାଲେ ସର୍‌ଆନ୍‌ । ୱାନ୍‌ ଇଡ୍ରଣାନ୍ ଅଡ଼ପ୍‍ ଆକ ଇତାନ୍‍ନୋ, ସତସେନାପତି ସଙ୍ଗ୍‌ରିଙ୍ଗ୍‌ ପକ୍‍ସି ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ପ୍ରବୁ, କାସ୍ଟୁ କିମା, ମାତର୍‌ ନିନ୍‌ ଜେ ନା ଇଣ୍ତ୍ର ପାଦାମ୍‌ ଇଡ୍‌ଦେଙ୍ଗ୍‌ ନାନ୍‌ ଇୟାୱାଜା ଜୋଗ୍‍ ସିଲେ; ");
INSERT INTO kfcp_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ମାରି ନାନ୍ ନି ଲାକ୍‌ତୁ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ନିଜେଦିଙ୍ଗ୍ ଜୋଗ୍‍ ଅଡ଼୍‍ବିଏତା; ମାତର୍‌ ଉନ୍‌ଡ୍ରି ପଦ୍‍ମାଟାଦି ଆଦେସ୍‌ ଇନ୍‌ଆଁ, ନା ପାଣିକିନିକାନ୍‌ ନେଗେନ୍‍ ଆନାସନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ମାତର୍‌ ନାନ୍ ଅରେନ୍‍ୱାନି ଆଡ୍‍ଗିମାନି ମାର୍‍ରିଙ୍ଗ୍‍ ବା ନା ଅଦିକାର୍‍ତାନ୍‍ ସନ୍ୟ ଦଲ୍‌ ମାନାର୍‌; ମାରି, ଅରେନ୍‍ ୱାନିଙ୍ଗ୍‌ ଜଦି ନାନ୍ ସାଙ୍ଗ୍‍ଆ ଇଜି ଆଦେସ୍‌ ସିତିଙ୍ଗ୍‌, ୱାନ୍‌ ସନାନ୍‌; ଆଇୱାନିଙ୍ଗ୍‍ ରାଆ, ଇଜି ଇରିଙ୍ଗ୍‌, ୱାନ୍‌ ୱାନାନ୍‌; ମାରି, ନା ସାକର୍‌ତିଙ୍ଗ୍‌ ଇକା କିଆ, ଇରିଙ୍ଗାଁ ୱାନ୍‌ ଆକା କିନାନ୍ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ଜିସୁ ଇୟାୱିଜୁ ମାଟା ୱେନ୍‌ଜି ୱାରି ବିସୟତାନ୍ କାବା ଆତାନ୍‌, ମାରି ମାର୍‍ଜି ୱାନି ୱେନ୍‌କା ୱାଜିମାରି ଲୋକାଙ୍ଗ୍‌ ଇର୍ହାନ୍‌; “ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‍ଇଜିନା, ଇସ୍ରାଏଲ୍‌ତୁ ବା ନିସା ପେରି ବିସ୍‌ବାସ୍‌ ପାଏ ଆଏତ୍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ମାରି, ପୋକ୍‍ତି ମାର୍‍ଇ ଲୋକୁ ଇନ୍‌ଡ୍ର ଡ଼େସି ୱାଜି ଗତିମୁରୁଲିଙ୍ଗ୍‍ ନେଗେନ୍‌ ଆତିକା ସୁଡ଼ୁତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ଆବେଟ୍‌କୁ ଜିସୁ ନାଇନ୍‍ ଦର୍‌ତି ଗାଡ଼୍‌ତୁ ସର୍‌ଆନ୍‌, ମାରି ୱାନି ସିସୁର୍‍ ମାରି ନାଣ୍ତ ଲୋକୁ ୱାନିୱାଲେ ସଲ୍‌ସି ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ୱାନ୍‌ ଗାଡ଼୍‌ ଲାକ୍‌ତୁ ଇତାନ୍‌, ସୁଡ଼ୁଦୁ, ଲୋକୁ ଅରେନ୍‍ ସାତି ଲୋକ୍‌ତିଙ୍ଗ୍‌ ଡାଣ୍ତିଆଦୁ ପିଣ୍ତଜୋ ତାସିମାର୍‍ଆର୍‍, ୱାନ୍‌ ନିଜେ ଆଇସିଦି ଅରେନ୍‍ନେ ମାରିସି, ମାରି ଆୟା ଆଇମା ରାଣ୍ତି; ମାରି, ଗାଡ଼୍‌ତି ନାଣ୍ତ ଲୋକୁ ତାନି ୱାଲେ ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ତାନିଙ୍ଗ୍‌ ସୁଡ଼ୁଜୋ ପ୍ରବୁ ତାନି ମୁସ୍‌କୁ ଦୟାକିଜି ତାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଆଡ଼୍‍ବାମା ।” ");
INSERT INTO kfcp_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ମାରି, ୱାନ୍‌ ଲାକ୍‌ତୁ ସଲ୍‌ସି ଡାଣ୍ତିଆଦୁ ମୁଟ୍‌ତାନ୍‌, ମାରି ପିଣ୍ତିତି ମାର୍ହିକାର୍‍ ନିର୍‍ଆର୍‍, ୱାନ୍‌ ୱେର୍‌ତାନ୍‌, ଏ ମୁରୁଲି ନାନ୍ ଇଜିନା, ନିଙ୍ଗିଁଆ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ଆବେଣାନ୍‍ ସାତିଲୋକ୍‌ ନିଙ୍ଗିଁଜି ବାସ୍‌ତାନ୍‌, ମାରି ୱାର୍‍ଗିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାନ୍‌, ମାରି ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ୱାନି ଆଇସି କିଦୁ ଆପିସ୍‍କିତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ଆବେନୁ ୱିଜେରେ ତିଲାତାର୍‌, ମାରି ମାପୁରୁଦି ଦନ୍ୟବାଦ୍‌ କିଜି କିଜି ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‍ତାର, ମା ଲୋଇରାନ୍‌ ଅରେନ୍‍ ପେରି ବାବବାଦି ସତାମାନାନ୍‍ ମାରି ମାପୁରୁ ନିଜେଦି ଲୋକାଙ୍ଗ୍‌ ରକିୟା କିଦେଙ୍ଗ୍‌ ୱାତାମାନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ମାରି, ଜିସୁ ବିସୟତି ଇୟା ମାଟା ୱିଜୁ ଜିହୁଦା ଦେସ୍‌ ମାରି ୱିଜୁ ତରିନ୍‌ ୱେଙ୍ଗିଁତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ୱେନ୍‌କା ଡୁବନ୍‌ସିନି ଜୋହନତି ସିସୁର୍‍ ଇୟା ବିସୟ୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ଆବେନ୍‌ ଜୋହନ ନିଜେଦି ସିସୁରି ଲୋଇ ରିଏରିଙ୍ଗ୍‍ ଲାକ୍‌ତୁ କୁକ୍‍ସୋ ମାଲିକ୍‌ ଲାକ୍‌ତୁ ଇକା ଇଜି ପୋକ୍‌ତାନ୍‌, ଆମାକାନ୍‍ ୱାଦେଙ୍ଗ୍‌ ଆତା ମାର୍‌ଆର୍‌, ଆୟା ଲୋକୁ ନିନ୍‌ନେ ନୋ, ନା ମାପ୍‌ ଆଇୱାନିଙ୍ଗ୍‍ କାପ୍‍କିନାପ୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ଆୟା ଲୋକୁ ଜିସୁ ଲାକ୍‌ତୁ ସଲ୍‌ସି ଇର୍ହାର୍‌, “ଡୁବନ୍‌ସିନି ଜୋହନ ମାଙ୍ଗିଁ ନି ଲାକ୍‌ତୁ ଇୟାକା ଇଜି ପୋକ୍‌ତାମାନାନ୍‌, ଆମାକାନ୍‍ ୱାନିକା ଆତାମାରାତ୍‍, ଆୟା ଲୋକୁ ନୋ ନିନ୍‌, ନା ମାପ୍‌ ଆଇ ଲୋକ୍‌ତିଙ୍ଗ୍‌ କାପ୍‍କିନାପ୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ଆୟା ୱେଡ଼ାଦୁ ୱାନ୍‌ ଏସୋ ରୋଗ୍‌, ବାଦା ମାରି ତାଗ୍‌ଇ ଆତ୍ମା ମାଣ୍‌କୁ ନେଗେଣ୍ତ୍‍ କିତାନ୍‌, ମାରି ଏସୋ କାଣାରିଙ୍ଗ୍‌ କାଣୁକୁ ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ସାକ୍ତି ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମିର୍‌ ମିର୍‌ ଡ଼େସି ସଲ୍‌ସି ଆମାକା ୱିଜୁ ୱେନ୍‌ଜିନିଦେର୍‌ ମାରି ସୁଡ଼ୁଜିନିଦେର୍‍, ଆୟାକାୱିଜୁ ଜୋହନତିଙ୍ଗ୍‍ ୱେର୍‌ତୁ; କାଣା ଲୋକୁ ସୁଡ଼ୁଜିନାର୍‍, ମାରି ସଟା ଲୋକୁ ବୁଲାଜିନାର୍‌, କୁସ୍ଟରୋଗ୍‌ ଲୋକୁ ନେଗେଣ୍ତ୍‌ ଆଜିନାର୍‌, ବଇରା ଲୋକ୍‌ ୱେନ୍‍ଜିନାର୍‍, ସାତି ଲୋକୁ ନିଙ୍ଗିଁଜିନାର୍‍, କାକୁର୍ତି ଲୋକାମାନୁ ବା ନେଗି କାବୁର୍‌ ପ୍ରଚାର୍‌ କିଆଇଆଜିନାତ୍‍; ");
INSERT INTO kfcp_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ମାରି, ଆମାକାନ୍‍ ନାଙ୍ଗିଁ ନାମ୍‍ଏନ୍‍, ୱାନ୍‌ ଦନ୍ୟ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ଜୋହନତି ସିସୁର୍‍ ସର୍‌ଇ ୱେନ୍‌କା ୱାନ୍‌ ଜୋହନତି ବିସୟ୍‌ତାନ୍‌ ଲୋକାଙ୍ଗ୍‌ ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌, ମିର୍‌ ଇନିକା ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ସିମ୍ରା ବାଡିଦୁ ସତିସର୍‌ଇ ମାର୍‌ଇଦେର୍‌ ? ଇନିକା ଗାଲିଦାନ୍‍ ଦୁଙ୍ଗ୍‍ଁଜିମାନି ଉଣ୍ତ୍ରି ଦେର୍‍ ନାଡ଼ା ? ");
INSERT INTO kfcp_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ଆୟାକା ଆଏତିଙ୍ଗାଁ ମିର୍‌ ଇନିକା ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ସତିସର୍‍ଇ ମାର୍‍ଇଦେର୍‍ ? ଇନିକା ଦାରାଦି ଆଙ୍ଗିଁ ଆରାତିମାନି ଅରେନ୍‍ ଲୋକ୍‌ତିଙ୍ଗ୍‌ ? ସୁଡ଼ୁଦୁ, ଆମାକାର୍‌ ଦାରାଦି ଆଙ୍ଗିଁ ଆରାନାର୍‍ ମାରି ସୁକ୍‌ତାନ୍‌ ଜିନାର୍‌, ୱାର୍‌ ରାଜାଦି ମେଡ଼୍‍ତୁ ତେବାନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ନାଙ୍ଗିଁ ଇନ୍‌ଆଁ, ଆୟାକା ଆଏତିଙ୍ଗାଁ ଇନିକା ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ସହସୋ ସର୍‍ଇମାର୍‍ଇଦେର୍‍ ? ଇନିକା ଅରେନ୍‍ ବାବବାଦିଙ୍ଗ୍‍ନୋ ? ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ବାବବାଦି ମାଣାନ୍‌ ନାଣ୍ତ ପେରିୱାନିଙ୍ଗ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ଜୋହନତି ବିସୟ୍‌ତାନ୍‌ ସାସ୍ତ୍ରଦୁ ରାସାତାମାନାତ୍‌, ମାପୁରୁ ଇର୍ହାନ୍‌, ମାପ୍‌ ନିଜେ ଦୁତ୍‍ତିଙ୍ଗ୍‍ ମି ଆଗ୍‌ଡ଼ି ପୋକ୍‍ତାମାନାପ୍‍, ୱାନ୍‌ ମି ଆଗ୍‌ଡ଼ି ମି ସାରି ତିଆର୍‌ କିନାନ୍‌, ଇୟାକାନ୍‌ ଆୟା ଜୋହନ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, “ଆଇମାମାନୁ ଜନମ୍‌ଆତି ଲୋଇରାନ୍‌ ଜୋହନ ମାଣାନ୍‌ ଆମାକାନ୍‍ ପେରିକାନ୍‌ ସିଲେନ୍‌; ଆତିଙ୍ଗ୍‌ବା ମାପୁରୁଦି ରାଜିଦୁ ଆମାକାନ୍‍ ଇସ୍ରିକାନ୍‌, ୱାନ୍‌ ଜୋହନତି ମାଣାନ୍‌ ପେରିକାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ଆମାକାର୍‌ ଇୟାୱିଜୁ ମାଟା ୱେନ୍‌ଜି ମାର୍‌ଆର୍‌, ୱାର୍‌, ବିସେସ୍‌କିଜି ସିସ୍‍ଟୁ ଲୋସ୍‌ନିକାର୍‌, ମାପୁରୁଦି ଟିକ୍‌ ଦାବିୱିଜୁ ପୁରାକିଜି ଜୋହନତି ମାଣ୍‌କୁ ଡୁବନ୍‌ ଅତାମାର୍‍ଆର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ମାତର୍‌ ପାରୁସିର୍‌ ନି ଦାର୍ମୁଗୁରୁର୍‌ ୱାରି ଜିବନ୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ମାପୁରୁଦି ଉଦେସ୍‌ତିଙ୍ଗ୍‌ ମାନାଏଣ୍‍ଗା ଜୋହନ ମାଣ୍‌କୁ ଡୁବନ୍‌ ଅଏତା ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ଜିସୁ ମାରି ଇର୍‌ଆନ୍‌, ଆରିଙ୍ଗ୍‌ ନାନ୍ “ଇୟା ଆଜିକାଲ୍‍ତି ଲୋକାଙ୍ଗ୍‌ ଏମେତାନିୱାଲେ ତୁସ୍‍ନା, ମାରି ୱାର୍‌ ଏୱାଜା ?” ");
INSERT INTO kfcp_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ଏମେ କଡ଼ର୍‌ ସାତା ସାଉକାଦୁ ବାସ୍‌ସି ନିଜେନିଜେ କୁକ୍‌ସି ଇନାର୍‌, ମାପ୍‌ ମି ଲାକ୍‌ତୁ ପିରଡ଼ି ଉକୁତାପ୍‍, ମିର୍‌ ଗାତ୍‍ଏତିଦେର୍‍, ମାପ୍‌ ଦୁକ୍‍ତି ପାଟା ପାରିତାପ୍‍, ମିର୍‌ ଆଡ଼ାବାଇତିଦେର୍‍, ୱାର୍‌ ୱାରି ୱାଜା । ");
INSERT INTO kfcp_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ଇରିଙ୍ଗ୍‌ ଡୁବନ୍‌ସିନି ଜୋହନ ୱାଜି ରୁଟି ତିନ୍‍ଏତାନ୍‍ ମାରି ଅଙ୍ଗୁର୍‍ରସ୍‍ ଉଣୁଏତାନ୍‍, ମାରି ମିର୍‌ ଇର୍‍ଇଦେର୍‍, ୱାନ୍‌ ଦୁବାକାସ୍ତିକାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ମନୁସ୍ୟପୁତ୍ର ୱାଜି ଉଣାନ୍‌ ତିନାନ୍‍, ମାରି ମିର୍‌ ଇଜିନିଦେର୍‌, ସୁଡ଼ୁଦୁ, ୱାନ୍‌ ଅରେନ୍‍ ପେଟୁ ନି ମଦୁଆ, ସିସ୍‍ଟୁ ଲୋସ୍‍ନିୱାରି ମାରି ପାପି ଲୋକା ତଡ଼୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ମାତର୍‌ ଏମେକାର୍‌ ମାପୁରୁଦି ବୁଦିଦିଙ୍ଗ୍‌ ମାନାନାର୍‌, ୱାରି ଜିବନ୍‌ତୁ ତାନି ସତ୍‌ ବିସୟ୍‌ ପାର୍‍ମାଣ୍‍ଆତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ମାରି, ପାରୁସିର୍‌ ମାଣାନ୍‌ ଅରେନ୍‍ ଜିସୁଙ୍ଗୁଁ ୱାନିୱାଲେ ଉଣ୍ତେଙ୍ଗ୍‌ କୁକ୍‍ତାନ୍‍ । ଆବେନ୍‌ ୱାନ୍‌ ପାରୁସିର୍‌ ଇନ୍‌ଡ୍ର ଡ଼ୁଗୁଜି ଉଣ୍ତେଙ୍ଗ୍‌ ବାସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ମାରି ସୁଡ଼ୁଦୁ, ଆୟା ଗାଡ଼୍‌ତୁ ଅରେତ୍‌ ପାପି ଆଇମା ମାର୍‌ଆତ୍‌; ଜିସୁ ଆୟା ପାରୁସିର୍‌ ଇନ୍‌ଡ୍ର ଉଣ୍ତେଙ୍ଗ୍‌ ବାସ୍‍ତା ମାର୍‌ଆନ୍‌, ଇୟାକା ନେସ୍‌ସି ୱାଦ୍‌ ଉଣ୍ତ୍ରି ସାଟିଦୁ ବାସ୍‌ନା ନିୟୁ ତାତାତ୍‍ଦୋ, ");
INSERT INTO kfcp_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ୱେନ୍‌କା ତର୍‍ନ୍‍ ୱାନି ପାଦାମ୍‌ ଲାକ୍‌ତୁ ନିଲ୍‍ଜି ଆଡ଼୍‍ବାଜି ଆଡ଼୍‍ବାଜି କାଣେର୍‍ ଏର୍‍ତାନ୍‍ ୱାନି ପାଦାମ୍‌ ନୋର୍‍ଜି ନିଜେ ତାଲାଦି କୁକୁଟିଦାନ୍‍ ତେଲ୍‍ଦେଙ୍ଗ୍‍ ଆସ୍‌ତାତ୍‌, ମାରି ୱାନି ପାଦାମ୍‍ତିଙ୍ଗ୍‍ ନୋଣ୍ତ୍‍ନିୱାଲେ ଆୟା ବାସ୍‌ନା ନିୟୁ ଉସ୍‌ତେଙ୍ଗ୍‌ ଆସ୍‌ତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ଆକା ସୁଡ଼ୁଜି, ଆମା ପାରୁସି ଜିସୁଙ୍ଗୁଁ କୁକ୍‌ତା ମାର୍‌ଆନ୍‌, ୱାନ୍‌ ମୋନ୍‌ତୁ ମୋନ୍‌ତୁ ଇର୍‌ଆନ୍‌, “ଇକାନ୍‌ ଜଦି ବାବବାଦି ଆନିମାନିକାଇରିଙ୍ଗ୍‌, ଆରିଙ୍ଗ୍‌ ୱେନିଙ୍ଗ୍‌ ଜେ ମୁଟ୍‌ସିନାତ୍‌, ୱାଦ୍‌ ଏଦ୍‌ ମାରି ଏଣ୍ତେସ୍‍ମାରି ଆଇମା, ୱାଦ୍‌ ଜେ ପାପି ଲୋକ୍‍ ଇକା ନେସ୍‌ତାନ୍‌ ମାନ୍ଦି ।” ");
INSERT INTO kfcp_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ସିମୋନ୍‍, ନିଙ୍ଗିଁ ଉଣ୍ତ୍ରି ମାଟା ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ମାନାତ୍‌ । ୱାନ୍‌ ଇର୍‌ଆନ୍‌, “ଗୁରୁ ଇନ୍‌ଆଁ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ଅରେନ୍‍ ପେରି ମାଜନ୍‌ ଲୋକୁ ଲାକ୍‌ତୁରାନ୍‌ ରିଏର୍‌ ଲୋକୁ ରୁଣୁ ଅତାମାର୍‍ଆର୍‍; ଅରେନ୍‍ ପାସ୍‍ସୋ ଡାବୁଙ୍ଗ୍‌ ମାରି ଅରେନ୍‍ ପସାସ୍‌ ଡିନାରି ରୁଣୁ ତାତାମାର୍‍ଆର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ଡ଼େସି ରୁଣୁ ସିଦେଙ୍ଗ୍‍ ୱାରିଙ୍ଗ୍‌ ଇନିକା ସିଲେତିଙ୍ଗ୍‍ ୱାନ୍‌ ରିଏରି ରୁଣୁ ଡ଼ିସ୍‍ତାସିତାନ୍‍ । ଏନ୍‌ ୱାରି ବାଣାନ୍‍ ଏନ୍‌ ୱାନିଙ୍ଗ୍‌ ନାଣ୍ତ ଜିବନ୍‍ନୋନାନ୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ସିମୋନ୍‍ ଇର୍‌ଆନ୍‌, “ନାନ୍ ଅଡ଼୍‌ବିଜିନା,” ୱାନ୍‌ ଆମାୱାନିନ୍ଦି ନାଣ୍ତ ରୁଣୁ ଡ଼ିସ୍‍ତାନ୍‍, ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନିନ୍‌ ଟିକ୍‍ ୱେର୍‌ତି ।” ");
INSERT INTO kfcp_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ମାରି, ୱାନ୍‌ ଆୟା ଆଇମାଦି ଉଣ୍ତିଙ୍ଗ୍‌ ମୋକମ୍‌ ଡ଼େପ୍‍ସି ସିମୋନ୍‍ତିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଇୟା ଆଇମାଦିଙ୍ଗ୍‍ ସୁଡ଼ୁଜିନି ? ନାନ୍ ମି ଇନ୍‌ଡ୍ର ୱାତା ନିନୁ ନା ପାଦାମ୍‍ତି ଉଣ୍ତିଙ୍ଗ୍‌ ଏର୍‌ ସିଏତି, ମାତର୍‌ ଇୟାକାତ୍‍ କାଣେର୍‍ ଏର୍‍ତାନ୍‍ ନା ପାଦାମ୍‍ତିଙ୍ଗ୍‍ ନୋର୍‍ଜି ନିଜେ କୁକୁଟିଦାନ୍‍ ତେଲିତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ନିନ୍‌ ନାଙ୍ଗିଁ ନଣ୍ତ୍‍ଜି କୁକ୍‍ସୋ ଅଇତି, ମାତର୍‌ ନାନ୍ ଲୋଇ ୱାତିୱାଲେରାନ୍‍ ଇୟାକାତ୍‍ ନା ପାଦାମ୍‌ ନଣ୍ତ୍‍ଦେଙ୍ଗ୍‍ ଡ଼ିସ୍‍ଏତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ନିନ୍‌ ନା ତାଲାଦୁ ନିୟୁ ଉସ୍‍ଏତି, ମାତର୍‌ ଇୟାକାତ୍‍ ନା ପାଦାମ୍‍ତୁ ବାସ୍‌ନା ନିୟୁ ଉସ୍‍ତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ନିଙ୍ଗିଁ ଇଜିନା, ତେନି ୱିଜୁ ପାପ୍‌ କେମା ଆତାମାନାତ୍‌, ଇରିଙ୍ଗ୍‌ ୱାଦ୍‌ ନାଣ୍ତ ଜିବନ୍‌ ନତାତ୍‍; ମାତର୍‌ ଏଙ୍ଗ୍‌ ଅଲପ୍‍ କେମା ସିଆଇ ଆନାତ୍‌, ୱାନ୍‌ ଅଲପ୍‍ ଜିବନ୍‍ନୋନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ମାରି, ଜିସୁ ଆୟା ଆଇମାଦିଙ୍ଗ୍‍ ଇର୍‌ଆନ୍‌, “ନି ପାପ୍‌ ୱିଜୁ କେମା ଆତାମାନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ଆବେନୁ ୱାନିୱାଲେ ଉଣ୍ତେଙ୍ଗ୍‌ ବାସ୍‍ତି ମାର୍‍ଇ ଲୋକୁ ମୋନ୍‌ତୁ ମୋନ୍‌ତୁ ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, ପାପ୍‌ ବା କେମା କିଜିନାନ୍‍ ଜେ ଇକାନ୍‍ ଏନ୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ମାତର୍‌ ଜିସୁ ଆୟା ଆଇମାଦିଙ୍ଗ୍‍ ଇର୍‌ଆନ୍‌, “ନି ବିସ୍‌ବାସ୍‌ ନିଙ୍ଗିଁ ରକିୟା କିତାମାନାତ୍‌, ସାନ୍ତିଦାନ୍‌ ସାଙ୍ଗ୍‍ଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ଇୟା ୱେନ୍‌କା ଜିସୁ ଗାଡ଼୍‌ ଗାଡ଼୍‍କାଙ୍ଗ୍‌ ମାରି ନାର୍‌ ନାର୍‌କାଙ୍ଗ୍‌ ୱେର୍‌ସି ମାପୁରୁଦି ରାଜିଦି ନେଗିକାବୁର୍‌ ପ୍ରଚାର୍‌ କିଜି ବୁଲାଦେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌, ମାରି ବାରଲୋକ୍ ସିସୁର୍‍ ୱାନି ୱାଲେ ମାର୍ହାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ମାରି ଏମେ ଆଇମେକ୍‍ ମାଣାନ୍‌ ତାଗ୍‌ଇ ଆତ୍ମା ମାରି ରୋଗ୍‌ଦାନ ନେଗେଣ୍ତ୍‌ ଆତେ ମାର୍‌ଏ, ୱାକ୍‍ ବା ୱାନିୱାଲେ ମାର୍‍ଏ, ମରିୟମ୍‌ ଆମାତାନିଙ୍ଗ୍‌ ମଗ୍‌ଦଲିନି ଇଜିମାର୍‌ଆର୍‌, ଏମେତାନି ମାଣୁକୁ ସାତଗୋଟା ଦୁବେଙ୍ଗ୍ ସପ୍‌ତା ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ହେରୋଦଦି ଗୁମୁସ୍ତା କୁଜାଦି ଆଡ଼ି ଜୋହାନା, ସୋସନା, ମାରି ନାଣ୍ତ ଆଇମେକ୍‍ ୱାନିୱାଲେ ମାନ୍‌ଜି ନିଜେ ନିଜେଦି ସମ୍ପତ୍ତି ସିଇଜି ଜିସୁ ନି ୱାନି ସିସୁରି ସେବା କିଜିମାର୍‌ଏ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ନାଣ୍ତ ଲୋକ୍‌ ଉଣ୍ତ୍ରେ ମାନୁ ଆଜିମାରି ଗାଡ଼୍‌ ଗାଡ଼୍‍କାଣ୍‌କୁ ଲୋକ୍‌ ୱାନି ଲାକ୍‌ତୁ ୱାତାର୍‌, ଜିସୁ ଇୟା କାତା ଇର୍ହାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","ଅରେନ୍‍ ୱିତୁ ୱିତିନିକାନ୍ ନିଜେଦି ୱିତୁ ୱିତ୍‌ତେଙ୍ଗ୍‌ ସତାନ୍‌ । ୱାନ୍‌ ୱିତ୍‍ବୁ ୱିତ୍‍ବୁ ଏସଡ଼ ସାର୍‌ଦୁ ଆର୍‍ତେ ମାରି ପାଦାମ୍‌ ଆଡ୍‍ଗି ମାଟ୍‌ତାର୍‌, ମାରି ବାଦଡ଼୍‍ତି ପଟିଙ୍ଗ୍‌ ଆୟାୱିଜୁ ତିର୍‌ଏ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ମାରି ଏସ ୱିତୁ ଉଣା ସିକ୍‌ଲାମାନି ପିଡ଼ିପି ବୁମିଦୁ ଆର୍‌ତାତ୍‌, ମାରି ଗାଜାଆଜି ସିକ୍‌ଲା ଅଲ୍‌ ସିଲେତାତ୍‌ଆକା ୱାର୍‍ତାସରାତ୍ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ମାରି ଏସ ୱିତୁ ସାମ୍‍କା ଦୁପା ଲୋଇ ବା ଆର୍‌ତାତ୍‌, ମାରି ସାମ୍‌ମାରାକ୍‌ ତାନି ୱାଲେ ପିରିଜି ଆୟାୱିଜୁଦିଙ୍ଗ୍ ତିଗିତାତ୍ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ଆୟା ଏସ ୱିତୁ ନେଗି ବୁମିଦୁ ଆର୍‌ତାତ୍‌, ମାରି ପିର୍‌ଜି ସୟେ ଗୁଣୁ ପଲ୍‌ ଆସ୍‌ତାତ୍‌ । ୱାନ୍‌ ଇକା ଇନ୍‍ବୁ ଇନ୍‍ବୁ ନାଣ୍ତ ଆଉଲି ଆଜି ଇର୍‌ଆନ୍‌, “ଆମାୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଗିତଣିଙ୍ଗ୍‍ମାନେ, ୱାନ୍‌ ୱେନିନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ଜିସୁଦି ସିସୁର୍‍ ଇୟା କାତାଦି ଅର୍ତ ଇନିକା ଇଜି ୱେନ୍‌ବାଦେଙ୍ଗ୍ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ଆବେଟ୍‌ ୱାନ୍‌ ଇର୍ହାନ୍‌, ମାପୁରୁଦି ରାଜିଦି ୱିଜୁ ବିସୟ୍‌ ନେସ୍‌ତେଙ୍ଗ୍‌ ମିଙ୍ଗିଁ ବୁଦି ସିଆତାମାନାତ୍, ମାତର୍‌ ଆଇୱାରିଙ୍ଗ୍‌ କାତାଦାନ୍ ଇଣ୍ତ୍ରେଙ୍ଗ୍‌ ଆନାତ୍‌, ଏଣ୍ତେସ୍‌ ୱାର୍‌ ସୁଡ଼ୁବୁ ସୁଡ଼ୁବୁ ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏର୍‍ ମାରି ୱେନ୍‌ବୁ ୱେନ୍‌ବୁ ବୁଜାଏର୍ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","କାତାଦି ଅର୍ତ ଇକା । ୱିତୁ ମାପୁରୁଦି ବାକ୍ୟ, ");
INSERT INTO kfcp_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ମାରି ସାରି ଲାକ୍‌ତୁରି ୱିତୁ ଇୟାୱାଜା ଲୋକାଙ୍ଗ୍‌ ବୁଜାକିନାତ୍‌, ଏମେକାର୍‌ ବାକ୍ୟ ୱେନାର୍‌, ଆୟାୱେନ୍‌କା ସୟତାନ୍ ୱାଜି, ଏଣ୍ତେସ୍‌ ୱାର୍‌ ବିସ୍‌ବାସ୍‌ କିଜ ରକିୟା ପୟ୍‌ଏର୍‌, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାରି ଜିବନ୍‌ତାନ୍ ବାକ୍ୟ ଡଙ୍ଗାଁ କିନା ଅନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ମାରି, ଏମେକାର୍‌ ବାକ୍ୟ ୱେନ୍‌ଜି ୱେଡ଼ିକାଦାନ୍‌ ମାନାନାର୍‌, ୱାର୍‌ ପିଡ଼ିପି ବୁମିଦୁ ଆର୍‍ତିମାନି ୱିତୁଦି ସାମାନ୍‍ । ଆୟା ସିକିୟା ୱାରିମାନୁ ନାଣ୍ତନେସ୍‌ନି ନେସ୍‌ଇ ମାନିଙ୍ଗ୍‌, ମାତର୍‌ ୱାର୍‌ ଲେୱା ସାଗ୍‍ଏତାତ୍‍ଆକା ୱାର୍‌ ଅଡ଼ପ୍‍ ସମୟ ବିସ୍‌ବାସ୍‌ କିନାର୍ ମାରି ପରିକା ୱେଡ଼ାଦୁ ଆର୍‍ନା ସନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ମାରି, ସାମ୍‌ ମାରାକ୍‍ ଲୋଇ ଆର୍‌ତି ୱିତୁ ଇୟାୱାଜା ଲୋକାଙ୍ଗ୍‌ ବୁଜାକିନାତ୍‌, ଏମେକାର୍‌ ବାକ୍ୟ ୱେନାର୍‌, ମାତର୍‌ ଦୁନିଆଦି ସିନ୍ତା ମାରି ଦନ ନି ସୁକ୍‌ ପୟଜି ଜିବୁ ଜିବୁ ତିଗାନା ସନାର୍‌ । ନେଗି ପଲ୍‌ ପାଣ୍ତିସ୍‌ କିଏର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ମାରି, ନେଗି ବୁମିଦୁ ଆର୍‌ତି ୱିତୁ ଇୟାୱାଜା ଲୋକାଙ୍ଗ୍‌ ବୁଜାକିନାତ୍‌, ଆମାକାର୍‌ ନେଗେଣାନ୍‍ ମାରି ନେଗି ଜିବନ୍‌ତୁ ବାକ୍ୟ ୱେନ୍‌ଜି ଆୟାକା ଆସ୍‌ସି ଇଡ୍‍ନାର୍‍ ମାରି ଡାଟାମ୍‍ତାନ୍‍ ପଲ୍‌ ଆସ୍‌ନାତ୍ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","ଆମାକାର୍‌ ଦିୱା କାସିସ୍‍ କିଜ ସାଟିଦାନ୍‍ ପିଡ଼ିକ୍‍ସ ଇଡେଏନ୍, ମାରି କାଟେଲ୍‍ ଆଡ୍‌ଗି ଇଡେଏନ୍, ମାରି ଦିୱା ଇଡ୍‌ନି ବାଡ଼ି ମୁସ୍‌କୁ ଇଡିନାନ୍, ଏଣ୍ତେସ୍‌ ଡ଼ୁଗିନି ଲୋକୁ ସୁଡ଼ୁଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","ମାତର୍‌ ଆମାକା ନେସିଇକା, ଇୟାୱାଜା ନେସିଇ ବିସୟ ଇନିକା ସିଲେତ୍‌, ମାରି ଆମାକା ୱେଙ୍ଗାଁଜି ତରାଇଆଏତ୍‍, ଇୟାୱାଜା ନେସେଇ ବିସୟ୍‌ ଇନିକା ସିଲେତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“ମାରି, ଏଣ୍ତେସ୍‌ ୱେନ୍‌ଜିନିଦେର୍‌, ଆୟା ବିସୟତାନ୍ ଜାଗାର୍‌ତା; ଇରିଙ୍ଗ୍‌ ଆମାୱାନିଦି ମାନାତ୍‌, ୱାନିଙ୍ଗ୍‌ ସିଆଇ ଆନାତ୍‌, ମାରି ଆମାୱାନିଙ୍ଗ୍‌ ସିଲେତ୍‌, ୱାନ୍‌ ଆମାକା ନିଜେଦି ମାନାତ୍‌ ଇଜି ମନେକିନାର, ଆୟାକା ବା ୱାନିବାଣାନ୍ ଅଆନାତ୍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ଜିସୁଦି ୟାୟା ନି ତଡ଼ାନ୍‌କୁ ୱାନିଲାକ୍‍ତୁ ୱାତାର୍, ମାତର୍‌ ଲୋକାଗୋଲିଦି ଉଣ୍ତିଙ୍ଗ୍‌ ୱାନି ୱାଲେ ବେଟ୍‌ ଆଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏଜି ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ଆବେଟ୍‌ ୱାନିଙ୍ଗ୍‌ ଏନ୍‌ ଅରେନ୍‍ ଇୟା କାବୁର୍‌ ସିତାନ୍‌, ମି ୟାୟା ନି ତଡ଼ାନ୍‌କୁ ନି ୱାଲେ ବେଟ୍‌ ଆଦେଙ୍ଗ୍‌ ବଦା କିଜି ଆତ୍‌ରେ ନିଲ୍‍ତାମାନାର୍ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ମାତର୍‌ ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଆମାକାର୍‌ ମାପୁରୁଦି ବାକ୍ୟ ୱେନାର ମାରି ମାନାନାର୍‌, ୱାର୍‌ ନା ୟାୟା ନି ତଡ଼ାନ୍‌କୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ଆୟା ୱେଡ଼ାଦୁ ଅର୍‍ନେଣ୍ତେ ଜିସୁ ମାରି ୱାନି ସିସୁର୍‍ ଉଣ୍ତ୍ରି ଡଙ୍ଗାଁଦୁ ଏକ୍‌ତାର୍‌, ମାରି ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ରାଦୁ, ସାମ୍‍ଦୁରୁତି ଆୟା ପାଡ଼ି ସନାଟ୍‌ ।” ଆବେଟ୍‌ ୱାର୍‌ ଏର୍‍ଜାଜ୍‌ କୁତାରଡ଼ିସିତାର୍ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ମାତର୍‌ ୱାର୍‌ ଏର୍‌ଜାଜ୍‌ତୁ ସନି ୱେଡ଼ାଦୁ ୱାନ୍‌ ଡରିତାମାର୍ହାନ୍‌ । ଆୟା ୱେଡ଼ାଦୁ ସାମ୍‍ଦୁରୁତୁ ଗାଲି ଆତାତ୍‌, ମାରି ୱାରି ଡଙ୍ଗାଁଦୁ ଏରୁ ପୁରୁନ୍‌ ଆଦେଙ୍ଗ୍‌ ଆରାମ୍‍ଆତେ ମାରି ୱାର୍‌ ବାଦାଦୁ ପଡ଼େଆତାର୍ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ଆବେନୁ ସିସୁର୍‍ ଲାକ୍‌ତୁ ୱାଜି ଜିସୁଙ୍ଗୁଁ ନିକ୍‌ସି ଇର୍ହାର୍‌, “ଏ ଗୁରୁ, ଏ ଗୁରୁ ମାପ୍‌ ସାତାପ୍‌ ।” ଇବେନୁ ୱାନ୍‌ ନିଙ୍ଗିଁଜି ଗାଲି ମାରି ନାଣ୍ତ ସାମ୍‌ଦୁରୁତି ଏରୁଦିଙ୍ଗ୍‌ ଆଦ୍‌ରିସ୍‌ତାନ୍‍, ମାରି ଆୟାୱିଜୁ ତିର୍‌ ଆଜି ସାନ୍ତି ଆତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ମାରି, ଜିସୁ ସିସୁରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ମି ବିସ୍‌ବାସ୍‌ ଏମେଦି ?” ମାତର୍‌ ୱାର୍‌ ତିଲାଜି ମାରି ଚମ୍‍କେ ଆଜି ନିଜେ ନିଜେଦି ମାନୁ ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, “ଇକାନ୍‌ ଆତିଙ୍ଗ୍‌ ଏନ୍‌ ଜେ ? ଗାଲି ନି ଏରୁଦିଙ୍ଗ୍‌ ବା ଆଦେସ୍‌ ସିଜିନାନ୍‌, ଗାଲି ନି ଏରୁଡର୍‍ ୱାନି ମାଟା ମାନ୍‌ଜିନେ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ୱେନ୍‌କା ଜିସୁ ନି ୱାନି ସିସୁର୍‍ ଗାଲିଲିଦି ଆଗିଡ଼ିରି ଆୟାପାଡ଼ିଦି ଗରାସିୟରି ରାଜିଦୁ ଇତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ୱାନ୍‌ ଏରୁଜାହାଜ୍‍ତାନ୍‍ ସହସି ପାଡ଼ିଦୁ ରେତାନ୍‍, ଆୟା ଗାଡ଼୍‌ତି ଅରେନ୍‍ ଦୁବାଆସ୍‍ତି ଲୋକୁ ୱାନିଙ୍ଗ୍‌ ବେଟ୍‍ଆତାନ୍‍; ୱାନ୍‌ ନାଣ୍ତ ଦିନ୍‌ ସାନ୍ଦି ଆଙ୍ଗିଁ ଆରାଏଣ୍ତା ମାରି ଇନ୍‌ଡ୍ର ମାନ୍‍ଏଣ୍ତା ଦୁକିଦୁ ମାନ୍‌ଜି ମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ୱାନ୍‌ ଜିସୁଙ୍ଗୁଁ ସୁଡ଼ୁଜି ଆଉଲି ଆଜି ୱାନି ପାଦାମ୍‌ ଆଡ୍‍ଗି ଆର୍‍ଜି ପେରି ୱେୟୁଦାନ୍‌ ଇର୍ହାନ୍‌, “ଏ ପେରି ମାପୁରୁଦି ମାରିନ୍‌ ଜିସୁ, ନି ୱାଲେ ନାଙ୍ଗିଁ ଇନିକା ମାନାତ୍‌ ? ନାନ୍ ନିଙ୍ଗିଁ ମାଡ଼ିସ୍‌କିଜିନା, ନାଙ୍ଗିଁ କାସ୍ଟୁ ସିମା ।” ");
INSERT INTO kfcp_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ତାଗ୍‌ଇ ଆତ୍ମାଦିଙ୍ଗ୍‌ ଆୟା ଲୋକାମାଣ୍‌କୁ ସହସ ସନି ଉଣ୍ତିଙ୍ଗ୍‌ ଆଦେସ୍‌ ସିତା ମାର୍ହାନ୍‌ । ଆୟା ଦୁବା ନାଣ୍ତ ଦେବେଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ ଆସ୍‌ତାମାର୍ହାତ୍‌, ମାରି ଲୋକୁ ୱାନିଙ୍ଗ୍‌ ସିକ୍‍ଣିଦାନ୍‍ ତର୍‌ସି ଇଡ୍‍ଜିମାର୍ହାର୍‍, ମାତର୍‌ ୱାନ୍‌ ତର୍‍ତିକାୱିଜୁ ତେଉଜି ପୋକ୍‌ସି ମାର୍‌ଆତ୍‌ ଦୁବା ୱାନିଙ୍ଗ୍‌ ସୁନ୍‍ସାନ୍‍ବାଡିଦୁ ଅସିମାର୍ହାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ନି ଦର୍‌ ଇନିକା ?” ୱାନ୍‌ ଇର୍ହାନ୍‌, “ନା ଦର୍‌ ବାହିନି; ଇରିଙ୍ଗ୍‌ ନାଣ୍ତ ଦୁବେଙ୍ଗ୍‍ ୱାନିଙ୍ଗ୍‌ କାସ୍‍ତେ ମାର୍‍ଏ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ମାରି, ୱାନ୍‌ ଏଣ୍ତେସ୍‌ ୱାରିଙ୍ଗ୍‌ ପାତାଲ୍‍ତୁ ସନି ଉଣ୍ତିଙ୍ଗ୍‌ ଆଦେସ୍‌ ସିମାକିନ୍‍, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ମାଡ଼ିସ୍‌ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ଆବେନୁ ଗର୍‍ନ୍‍ ଲାକ୍‌ତୁ ଉଣ୍ତ୍ରି ପେରି ପାନ୍‍ଣ୍ତ୍ରିଙ୍ଗ୍‍ ମାନ୍ଦା ସାରାଜିମାର୍‌ଏ, ମାରି ୱାନ୍‌ ଏଣ୍ତେସ୍‌ ତାଗ୍‌ଇ ଆତ୍‌ମେଙ୍ଗ୍‌ ଆୟା ପାଣ୍ତ୍ରିଙ୍ଗାଁ ଲୋଇ ଡ଼ୁଗ୍‌ଦେଙ୍ଗ୍‍ ଉଣ୍ତିଙ୍ଗ୍‌ ସାରି ସିତାନ୍‌, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ମାଡ଼ିସ୍‌ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ୱାନ୍‌ ୱାନିକାଙ୍ଗ୍‌ ସାରି ସିତାନ୍‍ଆକା, ଦୁବେଙ୍ଗ୍‍ ଆୟା ଲୋକ୍‍ତିବାଣାନ୍‍ ସହସି ପାନ୍‍ଡ୍ରିଙ୍ଗାଁ ଲୋଇ ଡ଼ୁଗିତେ; ଆବେନୁ ଆୟା ପାନ୍‍ଡ୍ରିଙ୍ଗ୍‍ ୱିଜୁ ଗରନ୍‌ ଟିପୁଦାନ୍‍ ଉରୁକ୍‍ସି ସଲ୍‌ସି ସାମ୍‌ଦୁର୍‌ତୁ ଆର୍‌ଜି ମୁଡ଼ୁଗିତେ ସାତେ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ମିଜି ମାର୍‍ଇ ଲୋକୁ ଆୟା ଗଟ୍‍ନା ସୁଡ଼ୁଜି ଉରୁକ୍‍ସି ସଲ୍‌ସି ଗାଡ଼୍‌କାଙ୍ଗ୍‌ ନି ନାର୍‍କାଙ୍ଗ୍‍ଁ ଆକା ୱେର୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ଆବେନୁ ଲୋକୁ ଗଟ୍‍ନା ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ସହସି ୱାତାର୍‌; ମାରି, ୱାର୍‌ ଜିସୁ ଲାକ୍‌ତୁ ୱାଜି, ଏମେ ଲୋକାମାଣାନ୍‌ ଦୁବେଙ୍ଗ୍‍ ସତେମାର୍‌ଏ, ୱାନିଙ୍ଗ୍‌ ନେଗି ୱାତି ପିଡ଼ିଗ୍‍ଜୋ ନେଗି ମୋନ୍‍ତାନ୍‍ ଜିସୁଦି ପାଦାମ୍‌ ଆଡ୍‍ଗି ବାସ୍‍ତିମାର୍‍ଇକା ସୁଡ଼ୁଜି ତିଲାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ମାରି, ଆମାକାର୍‌ ଇୟା ଗଟ୍‍ନା ସୁଡ଼ୁତାମାର୍‍ଆର୍‍, ୱାର୍‌ ଆୟା ଦୁବା କାସ୍‍ତି ଲୋକୁ ଏଣ୍ତେସ୍‌ ନେଗେନ୍‍ ଆତାନ୍‌, ଆକା ୱାରିଙ୍ଗ୍‌ ୱେର୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ଆବେନ୍‌ ଗରାସିୟରି ରାଜିଦି ୱିଜୁ ତରିଟି ଲୋକା ମାଣାନ୍‌ ଡ଼ିସ୍‌ସି ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଜିସୁଙ୍ଗୁଁ ମାଡ଼ିସ୍‍କିତାର୍‍, ଇରିଙ୍ଗ୍‌ ୱାର୍‌ ନାଣ୍ତ ତିଲାତାମାର୍‍ଆର୍‍; ମାରି, ୱାନ୍‌ ଉଣ୍ତ୍ରି ଏରୁଜାହାଜ୍‍ତୁ ଏକ୍‌ସି ଡ଼େସିୱାତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ମାତର୍‌ ଏମେ ଲୋକାମାଣାନ୍‌ ଦୁବେଙ୍ଗ୍‍ ସତେସର୍‍ଏ ମାର୍‍ହେ, ୱାନ୍‌ ଜିସୁୱାଲେ ମାନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ମାଡ଼ିସ୍‌ କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ମାତର୍‌ ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ସାଙ୍ଗ୍‍ଆ ଇଜି ଇର୍‌ଆନ୍‌, “ମି ଇନ୍‌ଡ୍ର ଡ଼େସି ସାଙ୍ଗ୍‍ଆ, ମାରି ମାପୁରୁ ନିଙ୍ଗିଁ ଇନି ଇନି କାର୍ମୁ କିତାମାନାନ୍‌, ଆକା ୱିଜୁୱେର୍‍ଆ ।” ଆବେଣାନ୍‍ ୱାନ୍‌ ସଲ୍‌ସି, ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇନି ଇନି କାର୍ମୁ କିତାମାର୍‍ଆନ୍‍ ଆୟାୱିଜୁ ଗାଡ଼୍‌ତୁ ୱେର୍‌ତେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ଏସ୍ତିୱାଲେ ଜିସୁ ଆୟାପାଡ଼ି ୱାତାନ୍‌, ନାଣ୍ତଲୋକ୍‍ ୱାନିଙ୍ଗ୍‌ ୱେଡ଼ିକାଦାନ୍‌ ମାନାତାର୍‍, ମାତର୍‌ ୱିଜେରେ ୱାନିଙ୍ଗ୍‌ କାପ୍‍କିଜିମାର୍‍ଆର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ମାରି, ସୁଡ଼ୁଦୁ, ଜାଇରସ୍‍ ଦର୍‌ତି ଅରେନ୍‍ ଲୋକୁ ୱାତାନ୍‌; ୱାନ୍‌ ପାର୍‌ତନା ଇଲୁଦି ପେରିକାନ୍‌ ମାର୍‌ଆନ୍‌ । ୱାନ୍‌ ଜିସୁଦି ପାଦାମ୍‍ଆଗ୍‍ଡ଼ି ନିଜେଦି ଇନ୍‌ଡ୍ର ୱାଦେଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ ମାଡ଼ିସ୍‌ତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ମାତର୍‌ ୱାନି ବାର ବାରସ୍‌ତି ଅରେତ୍‍ନେ ନା ଗାଡ଼ି ମାର୍‌ଆତ୍‌, ମାରି ୱାଦ୍‌ ସାତାମାର୍‍ଆତ୍‍ । ମାତର୍‌ ୱାନ୍‌ ସଲସିମାର୍‍ଇ ୱେଡ଼ାଦୁ ଲୋକୁ ୱାନି ୱାନି ମୁସ୍‌କୁ ମାଟ୍‍ସି ସାଜି ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ନାସ୍ତିୱାଲେ ବାର ବାର୍‍ସୁ ସାନ୍ଦି ସୁତୁକ୍‍ ରୋଗଦି ଅରେତ୍‌ ଆଇମା ମାର୍‌ଆତ୍‌, ଏଦ୍‍କି ନିଜେଦି ୱିଜୁ ଡାବୁଙ୍ଗୁଁ ୱିସ୍‍ସି ଏବାଣାକୁବା ନେଗେଣ୍ତ୍‍ ଆଦେଙ୍ଗ୍ ଆଟ୍‍ଏଜି ମାର୍‌ଆତ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ୱାଦ୍‌ ୱେନ୍‍କାରି ପାଡ଼୍‍କାଦାନ୍‍ ୱାଜି ୱାନି ୱାତି ଜାଲିଦୁ ମୁଟ୍‍ତାତ୍‍, ମାରି, ଆୟାଦାପ୍ରେ ତାନି ସୁତୁକ୍‍ ଆନି ରଗ୍‌ ନେଗେନ୍‌ ଆତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ଆବେନୁ ଜିସୁ ଇର୍ହାନ୍‌, “ଏନ୍‌ ନାଙ୍ଗି ମୁଟ୍‌ତାନ୍‌ ?” ମାତର୍‌ ୱିଜେରେ ସିଲେ ଇଜି ଇର୍ହାର୍‌, ପିତର ଇର୍ହାନ୍‌, “ଏ ଗୁରୁ, ଲୋକୁ ମାଣ୍ତାସୁଣ୍ତା ଆଜି ନି ମୁସ୍‌କୁ ମାଟ୍‍ସି ସାଜିନାର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ମାତର୍‌ ଜିସୁ ଇର୍ହାନ୍‌, “ଏନ୍‌ ଅରେନ୍‍ ନାଙ୍ଗି ମୁଟ୍‌ତାନ୍‌, ମାତର୍‌ ନା ବାଣାନ୍‍ ସାକ୍ତି ସତାତ୍‌ ଇଜି ନାନ୍ ନେସ୍‌ତା ।” ");
INSERT INTO kfcp_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ଏସ୍ତିୱାଲେ ଆଇମାଲୋକ୍‍ ସୁଡ଼ୁତାତ୍‍ ଜେ, ୱାଦ୍‌ ମାରାଗ୍‍ଜି ମାନ୍‌ଣ୍ଡ୍ରେଙ୍ଗ୍‌ ଆଟେଏତାତ୍‍, ନାସ୍ତିୱାଲେ ୱାଦ୍‌ ତିର୍‍ଗ୍‍ଜି ତିର୍‍ଗିଜି ୱାଜି ୱାନି ପାଦାମ୍‌ ଆଡ୍‍ଗି ଆର୍‍ଜି, ଇନିଦାନିଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ ମୁଟ୍‍ତାତ୍‍, ମାରି ଏଣ୍ତେସ୍‌ ଦାପ୍ରେ ନେଗେଣ୍ତ୍‍ ଆତାତ୍‌, ଆୟାୱିଜୁ ଲୋକା ଆଗ୍‌ଡ଼ି ଇର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ଆବେଟ୍‌ ୱାନ୍‌ ତାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଗାଡ଼ି, ନି ବିସ୍‌ବାସ୍‌ ନିଙ୍ଗିଁ ନେଗେନ୍‍ କିତାମାନାତ୍‌, ସାନ୍ତିଦାନ୍‌ ସାଙ୍ଗ୍‍ଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ଜିସୁ ଆୟା ମାଟା ଇନିୱାଲେ ପାର୍‌ତନା ଇନ୍‍ଡ୍ରଣି ପେରିଲୋକା ଇନ୍‍ଡ୍ରଣାନ୍‍ ଅରେନ୍‍ ୱାଜି ଇର୍‌ଆନ୍‌, “ମି ଗାଡ଼ି ସାତାତ୍‍ନି, ଗୁରୁଙ୍ଗ୍‍ ମାରି କାସ୍ଟୁ ସିମା ।” ");
INSERT INTO kfcp_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ମାତର୍‌ ଜିସୁ ଆୟାକା ୱେନ୍‌ଜି ଜାଇରସ୍‍ତିଙ୍ଗ୍‍ ଡ଼େସି ଇର୍‌ଆନ୍‌, “ତିଲାମାଟ୍‌, ବିସ୍‌ବାସ୍‌ କିଦୁ, ମାରି ୱାଦ୍‌ ନେଗେନ୍‍ ଆନାତ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ମାରି, ଇନ୍‌ଡ୍ର ୱାଜି ପିତର, ଜୋହନ ମାରି ଜାକୁବ, ମାରି ଗାଡ଼ିସ୍‌ଦି ୟାୟା ବୁବା ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ମାରି ଏୟେଙ୍ଗ୍‍ ନିଜେୱାଲେ ଲୋଇ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ସିଏତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ମାତର୍‌ ୱିଜେରେ ତାନି ଉଣ୍ତିଙ୍ଗ୍‌ ଆଡ଼୍‍ବାଜି ଆଡ଼୍‍ବାଜି ବକାଦୁ କତାଜି ମାର୍‌ଆର୍‌ । ଆବେନୁ ୱାନ୍‌ ଇର୍‌ଆନ୍‌, “ଆଡ଼୍‌ବାମାଟ୍‌; ୱାଦ୍‌ ସାଏତ୍‌, ମାତର୍‌ ସୁସ୍‍ତାମାନାତ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ମାତର୍‌ ୱାଦ୍‌ ସାତାମାନାତ୍‍ ଇଜି ନେସ୍‍ତିବାଣାନ୍‍ ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ସେମାର୍‌ କିଜିମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ମାତର୍‌ ୱାନ୍‌ ଆଇଲିଦି କିୟୁ ଆସ୍‌ସି କୁକ୍‌ସି ଇର୍‌ଆନ୍‌, “ଏ ଆଇଲି, ନିଙ୍ଗିଁଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ଆବେଟ୍‌ ତାନି ଜିବନ୍‌ ଡ଼େସି ୱାତାତ୍‍, ମାରି ୱାଦ୍‌ ଆୟାଦାପ୍ରେ ନିଙ୍ଗିଁତାତ୍‍, ଜିସୁ ତାନିଙ୍ଗ୍‌ ଇନିକାବା ଉଣ୍ତେଙ୍ଗ୍‌ ସିଦେଙ୍ଗ୍‍ ଇର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ଇବେଟ୍‍ ତାନି ୟାୟା ବୁବା କାବା ଆତାର୍‌; ମାତର୍‌ ଆୟା ଗଟ୍‌ନାଦି ମାଟାଦିଙ୍ଗ୍‌ ଏଙ୍ଗ୍‌ବା ଇନ୍‌ମାଟ୍‌ ଇଜି ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ଆୟାୱାଲେ ଜିସୁ ବାର ଲୋକୁ ସିସୁରିଙ୍ଗ୍‌ କୁକ୍‌ସି ଉନ୍‌ଡ୍ରେମାନୁ ଉଣ୍ତା କିଜି ୱାରିଙ୍ଗ୍‌ ୱିଜୁ ଦୁବେଙ୍ଗାଁ ଡ଼ିସ୍‍ତେଙ୍ଗ୍‍ଁ, ମାରି ରୋଗ୍‍ତିଙ୍ଗ୍‍ ନେଗେଣ୍ତ୍‌ କିଦେଙ୍ଗ୍‌ ସାକ୍ତି ମାରି ଅଦିକାର୍‍ ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ମାରି, ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ମାପୁରୁଦି ରାଜିଦି ନେଗିକାବୁର୍‌ ୱେର୍‌ତେଙ୍ଗ୍‌ ମାରି ରୋଗ୍‍ତୁମାନି ଲୋକାଙ୍ଗ୍‌ ନେଗେଣ୍ତ୍‍ କିଦେଙ୍ଗ୍‌ ପୋକ୍‌ତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ମାରି ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ମିର୍‌ ସନିୱାଲେ ବାଡିଗା ନୋ ମଣି ନୋ ରୁଟି ନୋ ଡାବୁଙ୍ଗୁଁ ଇନିକା ବା ଅମାଟ୍‌, ବା ରୁଣ୍ତି ଆଙ୍ଗିଁଙ୍ଗ୍‌ ଅର୍‌ସେ ଅମାଟ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ମାରି, ମିଙ୍ଗିଁ ଆମା ଇନ୍‌ଡ୍ରଣିକାର୍‌ କୁକ୍‍ନାର୍‍, ଆୟା ବାଡିଦାନ୍‍ ଡ଼େସି ରେଇ ସାନ୍ଦି ଆବେ ତେବାଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ମାରି, ଏସୋ ଲୋକୁ ମିଙ୍ଗିଁ ମାନାଏର୍‌, ଆୟା ଗାଡ଼୍‌ତାନ୍‍ ୱାନିୱାଲେ ଲୋକ୍‌ତି ବିରୁଦ୍‍ତାନ୍‍ ସାକି ସିଦେଙ୍ଗ୍‍ ଇଜି ମି ପାଦାମ୍‍କାଣି ଦୁଡ଼ି ସାଡ଼୍‍ଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ଆବେଟ୍‌ ସିସୁର୍‍ ସଲ୍‌ସି ୱିଜୁ ତରିନ୍‌ ନେଗିକାବୁର୍‌ ୱେର୍‌ତାର୍‌ ମାରି ରୋଗ୍‌ତାନ୍‌ ନେଗେଣ୍ତ୍‌ କିଜି କିଜି ନାର୍‍କାଙ୍ଗ୍‍ଁ ନାର୍‍କାଙ୍ଗ୍‍ଁ ସରଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ଆୟାୱାଲେ ଗାଲିଲିଦି ସାସନ୍‌କିନି ସାମନ୍ତରାଜା ହେରୋଦ ଇୟାୱିଜୁ ମାଟା ୱେନ୍‌ଜି ବାୟାଆତା ସର୍‌ଆନ୍‌, ଇରିଙ୍ଗ୍‌ ଡୁବନ୍‌ସିନି ଯୋହନ ମାରିଡ଼େସିଜିବନ୍‌ ଆତାମାନାନ୍‌ ଇଜି ଏର୍‌ ଏର୍‌ ଇଜିମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ମାରି, ଏର୍‌ ଏର୍‌ ଏଲିୟ୍‌ ତରାଇଆତାମାନାନ୍‍ ଇଜିମାର୍‌ଆର୍‌ ମାରି ଆଇକାର୍‌ ପୁର୍ବେଦି ବାବବାଦିର୍ ଲୋଇ ଅରେନ୍‍ ସାତିମାଣାନ୍‌ ଡ଼େସି ନିଙ୍ଗିଁତାମାନାନ୍‍ ଇଜି ଇଜିମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ମାତର୍‌ ହେରୋଦ ରାଜା ଇର୍‌ଆନ୍‌, “ଡୁବନ୍‌ସିନି ଜୋହନତି ତାଲା ତୋ ନାନ୍ କଇସ୍‍ତାମାନା, ମାତର୍‌ ଆମାୱାନି ବିସୟ୍‌ତାନ୍‌ ନାନ୍ ଇୟାୱାଜା ମାଟା ୱେନ୍‍ଜିନା, ଇକାନ୍‌ ଏନ୍‌ ?” ମାରି, ହେରୋଦ ଜିସୁଙ୍ଗୁଁ ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ବଦା କିଜିମାର୍‍ଆନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ୱେନ୍‌କା ସିସୁର୍‍ ଡ଼େସିୱାଜି, ଆମାକା ଆମାକା କିତାମାର୍‍ଆର୍‍, ଆୟାୱିଜୁ ଜିସୁଙ୍ଗୁଁ ୱେର୍‌ତାର୍‌ । ମାରି, ୱାନ୍‌ ଆଇମାନୁ ମାନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ୱାରିଙ୍ଗ୍‌ ୱାନିୱାଲେ ଅସି ବେତ୍‍ସାଇଦା ଦର୍‌ତି ଗାଡ଼୍‌ତୁ ସରଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ମାତର୍‌ ଲୋକ୍‌ ୱିଜେରେ ଆକା ନେସ୍‍ତାରୋ ୱାନିୱାଲେ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌; ମାରି, ଜିସୁ ଜିବନ୍‌ ନଜି ୱାରିଙ୍ଗ୍‌ ମାପୁରୁଦି ରାଜିଦି ବିସୟ୍‌ତାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌, ମାରି ଆମାୱାରିଙ୍ଗ୍‍ ରୋଗ୍‌ତାନ୍‌ ନେଗେଣ୍ତ୍‍ ଆନିକା ମାର୍‌ଆତ୍‌, ୱାରିଙ୍ଗ୍‌ ନେଗେଣ୍ତ୍‍ କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ନାସ୍ତିୱାଲେ ୱେଡ଼ା ଆଜି ୱାଜିମାର୍‍ଆର୍‍; ଆବେଟ୍‌ ବାର୍‍ ଲୋକୁ ସିସୁର୍‍ ଜିସୁ ଲାକ୍‌ତୁ ୱାଜି ଇର୍ହାର୍‌, “ଲୋକୁ ଏଣ୍ତେସ୍‌ ସାରିବେଡ଼୍‍ତି ନାର୍‍କାଙ୍ଗ୍‍ଁ ମାରି ଇସ୍ରିନାର୍‍କାଙ୍ଗ୍‍ ତେବାନାର୍‌ ମାରି କାଦି ଉଣ୍ତେଙ୍ଗ୍‌ ପୋଇଦେଙ୍ଗ୍‍ ଆଟ୍‍ନାର୍‍, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାରିଙ୍ଗ୍‌ ପୋକ୍‌ଆ, ଇରିଙ୍ଗ୍‌ ମାଡ୍‌ ଇବେ ସିମ୍ରା ବାଡିଦୁ ମାନିକା ।” ");
INSERT INTO kfcp_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ମାତର୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମିର୍‌ ୱାରିଙ୍ଗ୍‌ ଉଟ୍‍ପିସ୍‍କିଦୁ ।” ୱାର୍‌ ଇର୍ହାର୍‌, “ମା ଲାକ୍‌ତୁ ପାସ୍‌ଗୋଟା ରୁଟିଙ୍ଗ୍‌ ମାରି ରୁଣ୍ତି ମିନ୍‍କାଣ୍‍ ନାଣ୍ତ ସିଲୁ; ଆରିଙ୍ଗ୍‌ ମାପ୍‌ ଇନିକା ସନାପ୍‌ ଇୟାୱିଜୁ ଲୋକା ଉଣ୍ତିଙ୍ଗ୍‌ କାଦି କଣାପ୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ଇରିଙ୍ଗ୍‌ ୱାର୍‌ ୫,୦୦୦ ହାଜାର୍‌ ମେମାରୁଙ୍ଗୁଁ ମାର୍‌ଆର୍‌ । ମାରି, ଜିସୁ ୱାନି ସିସୁରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ପଚାସ୍‍ ପଚାସ୍‍ କିଜି ୱାରିଙ୍ଗ୍‌ ଦଲ୍‌ ଦଲ୍‌ କିଜି ବାସିସ୍‍ କିଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ଆବେଟ୍‌ ୱାର୍‌ ଆୟାୱାଜା ୱିଜେରିଙ୍ଗ୍‍ ବାସିସ୍‍ କିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ମାରି, ଜିସୁ ଆୟା ପାସ୍‌ଗୋଟା ରୁଟିଙ୍ଗ୍‌ ମାରି ରୁଣ୍ତି ମିନ୍‌କୁ ଅସି ମୁସ୍‌କୁ ତରିନ୍‌ ସୁଡ଼ୁଜି ଆୟାୱିଜୁ ଆସିର୍ବାଦ୍‌ କିତାନ୍‌, ମାରି ରୁକ୍‍ସି ଲୋକାଙ୍ଗ୍‌ ବାଟା କିଜି ସିଦେଙ୍ଗ୍‍ ଇଜି ସିସୁରିଙ୍ଗ୍‌ ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ଆବେଟ୍‌ ୱିଜେରେ ତିର୍‌ଆରୋ ପଟାପାଜିତାର୍‍, ମାରି ୱାର୍‌ ୱାରି ଲାକ୍‌ତୁ ଏଜିତି ମାର୍‍ଇ ବାରଗୋଟା ଡାଡ଼ିଙ୍ଗ୍‍ ଉଣ୍ତାକିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ଅର୍‍ଲେନ୍‍ ଜିସୁ ଅରେନ୍‌ ପାର୍‌ତନା କିନିୱାଲେ ସିସୁର୍‍ ୱାନିୱାଲେ ମାର୍‌ଆର୍‌, ମାରି ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ନାନ୍ ଏନ୍‌ ଇଜି ଲୋକୁ ୱିଜେରେ ଇନିକା ଇନାର୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ଆବେଟ୍‌ ୱାର୍‌ ଇର୍ହାର୍‌, “ଡୁବନ୍‌ସିନି ଜୋହନ, ମାତର୍‌ ଏର୍‌ ଏର୍‌ ଇନାର୍‌, ଏଲିୟ୍‌, ମାରି ଏର୍‌ ଏର୍‌ ଇନାର୍‌, ପୁର୍ବେଦି ବାବବାଦିରି ଲୋଇ ଅରେନ୍‍ ଜିବନ୍‌ଆଜି ନିଙ୍ଗିଁତାମାନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ୱେନ୍‍ବାନ୍‍, “ମାତର୍‌ ନାନ୍ ଏନ୍‌ ଇଜି ମିର୍‌ ଇନିକା ଇଜିନିଦେର୍‌ ?” ପିତର ଇର୍‌ଆନ୍‌, “ନିନ୍‌ ମାପୁରୁଦି କ୍ରିସ୍ତ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ଆବେଟ୍‌ ଜିସୁ ଇକା ଏଙ୍ଗ୍‌ବା ଇନ୍‌ମାଟ୍‌ ଇଜି ୱାରିଙ୍ଗ୍‌ ଆଟ୍‌ୱାଦାନ୍‍ ୱେର୍‌ତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","“ମନୁସ୍ୟପୁତ୍ରଦିଙ୍ଗ୍‍ ନାଣ୍ତ ଦୁକ୍‍ ପୋଇଦେଙ୍ଗ୍‍ ଆନାତ୍‌ ମାରି ନେତାର୍‍, ପେରିଜାଜକ୍‍କୁ ମାରି ସାସ୍ତ୍ରିର୍‍ ସେମାର୍‌ କିଜି ଡାକ୍‌ନାର୍‌, ମାରି ମୁନେଟାନ୍‍ ମାରିଡ଼େସିଜିବନ୍‌ ଆଜି ନିଙ୍ଗିଁନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ନାସ୍ତିୱାଲେ ଜିସୁ ୱିଜେରିଙ୍ଗ୍‍ ଇର୍‌ଆନ୍‌, ଏନ୍‌ ଜଦି ନା ୱାଲେ ୱାଦେଙ୍ଗ୍‌ ବଦାକିନାନ୍‌, ଆରିଙ୍ଗ୍‌ ୱାନ୍‌ ନିଜେଦି ଡ଼ିସିନ୍‍, ମାରି ଦିନାମି ନିଜେଦି ଦୁକ୍‍ କସ୍ଟଦିଙ୍ଗ୍‍ ପିନ୍‍ଣ୍ତ୍‍ଜି ନା ୱେନ୍‌କା ରାପିନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ଇରିଙ୍ଗ୍‌ ଏନ୍‌ ନିଜେଦି ଜିବନ୍‌ତିଙ୍ଗ୍‌ ରକିୟା କିଦେଙ୍ଗ୍‌ ବଦାକିନାନ୍‌, ୱାନ୍‌ ଆକା ଆରାକିନାନ୍‌, ମାତର୍‌ ଏନ୍‌ ନା ଉଣ୍ତିଙ୍ଗ୍‌ ୱାନି ଜିବନ୍‌ ଆରାକିନାନ୍‌, ୱାନ୍‌ ଆକା ରକିୟା କିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ମାରି, ଅରେନ୍‌ ଲୋକୁ‌ ସାରାଦୁନିଆଦିଙ୍ଗ୍‌ ଜିଣାଜି ନିଜେଦିଙ୍ଗ୍‍ ସାପିସ୍‍କିନାନ୍‍ ବା ଆରାନାନ୍‌, ଆରିଙ୍ଗ୍‌ ୱାନି ଇନି ଲାବ୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ଆଦେଙ୍ଗ୍‌ ଏନ୍‌ ନାଙ୍ଗିଁ ମାରି ନା ବାକ୍ୟ ବିସୟ୍‌ତାନ୍‌ ସେମାର୍‍ ଆନାନ୍‌, ମନୁସ୍ୟପୁତ୍ର ଏସ୍ତିୱାଲେ ବୁବାୱାଲେ, ମାରି ମୁସ୍‌କୁପୁର୍‌ତି ପବିତ୍ର ଦୁତ୍‍କାୱାଲେ ମହିମାଦାନ୍‌ ୱାନାନ୍‌, ନାସ୍ତିୱାଲେ ୱାନ୍‌ ୱାରି ବିସୟ୍‌ତାନ୍‌ ସେମାର୍‍ କିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ମାତର୍‌ ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, “ମାପୁରୁଦି ରାଜି ସୁଡ଼ିଇ ସାନ୍ଦି ଇବେ ନିର୍‍ଇ ମାନି ଲୋକା ଲୋଇ ଏସୋ ଲୋକୁ ଏଣ୍ତେସ୍‌ବା ସାଏର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ଇୟାୱିଜୁ ଗଟାନି ପୁରା ଆଟ୍‍ଦିନ୍‍ ୱେନ୍‌କା ଜିସୁ ପିତର, ଜୋହନ ମାରି ଜାକୁବଙ୍ଗ୍‍ ୱାନିୱାଲେ ଅସି ପାର୍‌ତନା କିଦେଙ୍ଗ୍‌ ଇଜି ଗରନ୍‌ତୁ କୁକ୍‍ତାଅତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ମାରି, ୱାନ୍‌ ପାର୍‌ତନା କିନିୱାଲେ ୱାନି ମୋକମ୍‍ତି ମୁର୍‍ତି ବାଦ୍‍ଲେ ଆତାତ୍‌ ମାରି ୱାନି ଆଙ୍ଗିଁ ଅଡ଼ିନିକା ମାରି ନାଣ୍ତ ଜାୟ୍‌ ଆତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ମାରି ସୁଡ଼ୁଦୁ, ଆୟାଦାପ୍ରେ ମୋସା ନି ଏଲିୟ୍‌, ଇୟା ରିଏର୍‌ ଲୋକୁ ୱାନିୱାଲେ ୱାର୍‌ଗିଜିସାଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ୱାରି ମୁସ୍‌କୁପୁର୍‌ତି ଗୌରବ୍‍ତାନ୍‍ ତରାଜିମାର୍‍ଆର୍‍, ୱାର୍‌ ଜିସୁୱାଲେ ଜିରୁସାଲାମ୍‍ତୁ ଗଟାଦେଙ୍ଗ୍‍ ମାନି ୱାନି ସାନି ବିସୟ୍‌ତାନ୍‌ ୱାର୍‌ଗିଜି ସାଜି ମାର୍‍ଆର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ନାସ୍ତିୱାଲେ ପିତର୍‌ ମାରି ୱାନି ତଡ଼୍‍କୁ ସୁଜ୍‍ଜିମାର୍‍ଆର୍‍; ମାତର୍‌ ୱାର୍‌ ଏସ୍ତିୱାଲେ ନିଙ୍ଗିଁତାର୍‍ ୱାନି ମହିମା ମାରି ୱାନିୱାଲେ ନିର୍‍ଇ ମାର୍‍ଇ ଆୟା ରିଏର୍‌ ଲୋକାଙ୍ଗ୍‌ ସୁଡ଼ୁତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ମାରି, ମୋସା ନି ଏଲିୟ୍‌ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ସନିୱାଲେ ପିତର ଜିସୁଙ୍ଗୁଁ ଇର୍ହାନ୍‌, “ଏ ଗୁରୁ, ମାଡ୍‌ ଜେ ଇବେ ମାନିକା, ଇକା ନେଗେଣ୍ତ୍‍ ଆତାତ୍‌; ମାପ୍‌ ମୁଡ୍ରି ଗୁଡ଼େଙ୍ଗ୍‍ ତିଆର୍‌ କିନାପ୍‍, ନି ଉଣ୍ତିଙ୍ଗ୍‌ ଉନ୍‌ଡ୍ରି, ମୋସାଦି ଉଣ୍ତିଙ୍ଗ୍‌ ଉନ୍‌ଡ୍ରି ମାରି ଏଲିୟ୍‌ଦି ଉଣ୍ତିଙ୍ଗ୍‌ ଉନ୍‌ଡ୍ରି । ମାତର୍‌ ୱାନ୍‌ ଇନିକା ଇଜିନାନ୍‌, ଆକା ନେସ୍‌ଏତାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ପିତର ଇକା ଇନ୍‍ବୁ ଇନ୍‍ବୁ କାଣ୍ତେକ୍‍ ବାଦଡ଼୍‍ ଇମ୍‌ଜି ୱାତା ଦୋ ୱାରିଙ୍ଗ୍‌ ବାଦଡ଼୍‍ତି ନିଡ଼୍‍ଗା ପିଡ଼ିକ୍‍ତାତ୍‍, ମାରି ୱାରିଙ୍ଗ୍‌ ବାଦଡ଼୍‍ କେର୍‍ପ୍‍ନିୱାଲେ ପିତର, ଜୋହନ ମାରି ଜାକୁବ ତିଲାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ମାରି, ଆୟା ବାଦଡ଼୍‍ତାନ୍‍ ଉଣ୍ତ୍ରି ବଲ୍ ୱାତାତ୍‍, “ଇକାନ୍‌ ନା ମାରିନ୍‌, ନାନ୍ ୱେନିଙ୍ଗ୍‌ ବାସେକିତାମାନା, ୱେନି ମାଟା ୱେନ୍‍ଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ମାରି, ଆୟା ବଲ୍ ୱାତି ୱେନ୍‌କା ଜିସୁ ଅରେନ୍‍ନେ ତରାଆତାନ୍‍ । ମାରି, ୱାର୍‌ ଆଲେତା ମାର୍ହାର୍‌, ମାରି ଆମାକା ଆମାକା ସୁଡ଼ୁତାମାର୍‍ଆର୍‍, ଆୟା ମାଟାଦି ବିସୟ୍‌ ଏଙ୍ଗ୍‌ବା ଇନ୍‍ଏତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ମାର୍‍ନାଣ୍ଡିଙ୍ଗ୍ ଜିସୁ ନି ୱାନି ମୁଏର୍‌ ସିସୁର୍‍ ଗରନ୍‌ତାନ୍‍ ରେତାୱାତାର୍‍, ମାରି ନାଣ୍ତଲୋକ୍‍ ୱାଜି ଜିସୁଙ୍ଗୁଁ ମିସତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ମାରି ସୁଡ଼ୁଦୁ, ଲୋକା ଲୋଇ ଅରେନ୍‍ ନାଣ୍ତ ଆଉଲି ଆଜି ଇର୍‌ଆନ୍‌, “ଏ ଗୁରୁ, ନାନ୍ ନିଙ୍ଗିଁ ମାଡ଼ିସ୍‌ କିଜିନା, ନା କଡ଼ଦିଙ୍ଗ୍‌ ଦୟା କିଆ, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ନା ଅରେନେ ମାରିନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ସୁଡ଼ୁଆ, ୱାନିଙ୍ଗ୍‌ ଉଣ୍ତ୍ରି ଦୁବା ଆସ୍‌ନାତ୍‌, ମାରି ୱାନ୍‌ ଦାପ୍ରେନେ ଆଉଲି ଆଜି ନିଙ୍ଗିଁନାନ୍‍, ମାରି ଦୁବା ୱାନିଙ୍ଗ୍‌ ଇୟାୱାଜା ତିର୍‍ପ୍‍ନାପୋକ୍‍ନାତ୍‍ ଜେ, ୱାନି ୱେୟୁଦାନ୍‌ ପେପଲ୍‍ ସନାତ୍‌, ମାରି ୱାଦ୍‌ ୱାନିଙ୍ଗ୍‌ ସିତାରାକାବ୍‍ରା କିଜି କାସ୍ଟୁଦାନ୍‍ ସନାସନାତ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ୱାନିଙ୍ଗ୍‌ ଦୁବା ଡ଼ିସିସ୍‍ତେଙ୍ଗ୍‍ ଇଜି ନାନ୍ ନି ସିସୁରିଙ୍ଗ୍‌ ମାଡ଼ିସ୍‍କିତା, ମାତର୍‌ ୱାର୍‌ ଆଟ୍‍ଏତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଆରେ ଅଡ଼ପ୍‍ ବିସ୍‍ବାସିର୍‍ ମାରି ତାଗ୍‍ଇସାରିଦୁ ସନି କୁଟୁମ୍‌, ଏସୋଦିନ୍‍ ନାନ୍‌ ମି ୱାଲେ ତେବାଜି ମି ବ୍ୟବହାର୍‌ କିନା ? ନି ମାରିନ୍‌ତିଙ୍ଗ୍‍ ଇବେ ତାଗା ।” ");
INSERT INTO kfcp_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ୱାନ୍‌ ୱାବୁ ୱାବୁ ଦୁବା ୱାନିଙ୍ଗ୍‌ ଆଡ୍‍ଗି ଆର୍‍ପ୍‍ସି ପୋକ୍‌ସି ବୟ୍‌ଙ୍କାର୍‍ତାନ୍‍ ତିର୍‍ପ୍‍ତା ପୋକ୍‌ତାତ୍‌, ମାତର୍‌ ଜିସୁ ଆୟା ତାଗିଇ ଆତ୍ମାଦିଙ୍ଗ୍‌ ଆଦ୍‌ରିସ୍‌ତାନ୍‍ ମାରି କଡ଼ଦିଙ୍ଗ୍‌ ନେଗେନ୍‌ କିଜି ୱାନିଙ୍ଗ୍‌ ତାମେ ବୁବାସି କିଦୁ ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ଆବେଟ୍‌ ୱିଜେରେ ମାପୁରୁଦି ପେରିସାକ୍ତି ଉଣ୍ତିଙ୍ଗ୍‌ କାବାଆତାର୍‌ । ମାତର୍‌ ୱାନି କିତି ୱିଜୁ ପାଣିଦି ଉଣ୍ତିଙ୍ଗ୍‌ ୱିଜେରେ କାବା ଆନିୱାଲେ ଜିସୁ ୱାନି ସିସୁରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“ଇୟାୱିଜୁ ମାଟା ମି ଗିତଣିଆଙ୍ଗ୍‍ଁ ୱେନ୍‌ଡ୍ରୁ; ଇରିଙ୍ଗ୍‌ ମନୁସ୍ୟପୁତ୍ର ଲୋକା କିୟୁଦୁ ସର୍‍ପେ ଆଦେଙ୍ଗ୍‌ ସଲ୍‌ସିନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ମାତର୍‌ ସିସୁର୍‍ ଆୟାମାଟା ବୁଜାଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏତାର୍‍, ମାରି ଆୟାକା ୱାରି ମାଣାନ୍‌ ମାର୍‍ଗିତା ମାର୍‌ଆତ୍‌, ଏଣ୍ତେସ୍‌ ଆକା ୱାର୍‌ ବୁଜାଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏତିଙ୍ଗ୍‍ ବା, ମାରି ୱାର୍‌ ଆୟା ମାଟାଦି ବିସୟ୍‌ତାନ୍‌ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‍ବାଦେଙ୍ଗ୍‍ ତିଲାଜି ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ୱାରି ମାଣାନ୍‌ ଏନ୍‌ ପେରିକାନ୍‌, ଆୟା ବିସୟ୍‌ତାନ୍‌ ୱାରି ଲୋଇ ୱାର୍‌ଗିଜି ସାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ମାତର୍‌ ଜିସୁ ୱାରି ମୋନ୍‌ତୁ ୱାର୍‌ଗିଜିସାନିକା ନେସ୍‌ତାନ୍‌ନୋ ଅରେନ୍‍ ଇସ୍ରି କଡ଼ଦିଙ୍ଗ୍‌ ତାତାନ୍‍ ନୋ ନିଜେଦି ଲାକ୍‌ତୁ ନିଲ୍‍ପିସ୍‍ କିତାନ୍‍ନୋ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“ଏନ୍‌ଆପିନ୍‌ ନା ଦର୍‌ତାନ୍‌ ଇୟା ଇସ୍ରି କଡ଼ଦିଙ୍ଗ୍‌ ମାନାନାନ୍‍, ୱାନ୍‌ ନାଙ୍ଗିଁ ମାନାନାନ୍‍, ମାରି ଏନ୍‌ଆପିନ୍‌ ନାଙ୍ଗିଁ ମାନାନାନ୍‍, ୱାନ୍‌ ନା ପୋକ୍‌ତିମାନି ମାଲିକ୍‌ତିଙ୍ଗ୍‌ ମାନାନାନ୍‍; ଇରିଙ୍ଗ୍‌ ମି ୱିଜେରି ମାଣ୍‌କୁ ଏନ୍‌ ଇସ୍ରିକାନ୍‌, ୱାନ୍‌ ପେରିକାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ଆବେଟ୍‌ ଜୋହନ ଇର୍‌ଆନ୍‌, “ଏ ଗୁରୁ, ମାପ୍‌ ଅରେନ୍‍ ୱାନିଙ୍ଗ୍‌ ନି ଦର୍‌ତାନ୍‌ ଦୁବା ଡ଼ିସିସ୍‍କିନିକା ସୁଡ଼ୁତାପ୍‍, ମାରି ୱାନ୍‌ ମା ଦଲ୍‍ତିକାନ୍‍ ଆଏନ୍‍ଆକା ୱାନିଙ୍ଗ୍‌ ତେବା କିତାପ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ମାତର୍‌ ଜିସୁ ଜୋହନତିଙ୍ଗ୍‍ ଇର୍‌ଆନ୍‌, “ୱାନିଙ୍ଗ୍‌ ମନା କିମାଟ୍‌, ଇରିଙ୍ଗ୍‌ ଏନ୍‌ ମି ତରିନ୍‌ ଆଏନ୍‍, ୱାନ୍‌ ମି ତରିନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ୱେନ୍‌କା ଏସ୍ତିୱାଲେ ଜିସୁଦି ଆଡ୍‍ଗିପୁର୍‍ ଡ଼ିସ୍‌ସି ମୁସ୍‌କୁପୁର୍‌ ସନି ୱେଡ଼ା ଆଜି ୱାଜି ମାର୍‌ଆତ୍‌, ନାସ୍ତିୱାଲେ ଜିସୁ ଜିରୁସାଲାମ୍‍ତୁ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ବଦାକିତାନ୍‍, ");
INSERT INTO kfcp_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ୱାନ୍‌ ୱାନି ଆଗ୍‌ଡ଼ି କାବୁର୍‌ ଅନିୱାରିଙ୍ଗ୍‍ ପୋକ୍‌ତାନ୍‌ । ୱାର୍‌ ସଲ୍‌ସି ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ତିଆର୍‌ କିଦେଙ୍ଗ୍‌ ସମିରୋଣୟରିଦି ଉଣ୍ତ୍ରି ନାର୍‍ତୁ ସର୍‌ଆ ଡ଼ୁଗିତାର୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ମାତର୍‌ ୱାନ୍‌ ଜିରୁସାଲାମ୍‍ତୁ ସନି ଉଣ୍ତିଙ୍ଗ୍‌ ବଦା କିତାମାନାନ୍‍ ଇଜି ନେସ୍‌ସି ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ମାନାଏତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ଇକା ସୁଡ଼ୁଜି ଜାକୁବ ନି ଜୋହନ, ଇୟା ରିଏର୍‌ ସିସୁର୍‍ ଇର୍ହାର୍‌, “ପ୍ରବୁ, ଏଲିୟ୍‌ ବା ଏଣ୍ତେସ୍‌ କିତାମାର୍‍ଆନ୍‍, ଆୟାୱାଜା ବାଦଡ଼୍‍ତାନ୍‍ ସିସୁ ଆର୍‍ଜି ୱାରିଙ୍ଗ୍‌ ସାପିସ୍‌ କିପିତ୍‍, ଇକା ମାପ୍‌ ଇନାପ୍‍ ଇଜି ଇନିକା ନି ବଦା ନୋ ?” ");
INSERT INTO kfcp_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ମାତର୍‌ ୱାନ୍‌ ମାର୍‍ଜି ବେସ୍‍ସି ୱାରିଙ୍ଗ୍‌ ଲାଗାତାନ୍‍ ମାରି ଇର୍‌ଆନ୍‌, ମିର୍‌ ଏଣ୍ତେସ୍‌ ନାନି ଆତ୍ମାଦି ଲୋକୁ, ଇକା ନେସ୍‌ଏଜିନା । ମନୁସ୍ୟପୁତ୍ର ଲୋକାଦି ଜିବନ୍‌ ସାପିସ୍‌ କିଦେଙ୍ଗ୍ ରେଏଣ୍ତ୍‍ ମାତର୍‌ ରକିୟା କିଦେଙ୍ଗ୍‌ ୱାତାମାନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ତାନିୱେନ୍‍କା ୱାର୍‌ ମାରି ଉଣ୍ତ୍ରି ନାଟ ସରଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ୱାର୍‌ ସାରିଦୁ ସନିୱାଲେ ଅରେନ୍‍ ଲୋକୁ ଜିସୁଙ୍ଗୁଁ ଇର୍‌ଆନ୍‌, “ନିନ୍‌ ଏମେ ବାଡିଦୁ ସନି, ନାନ୍ ନି ୱେନ୍‌କା ୱେନ୍‌କା ୱାନା ।” ");
INSERT INTO kfcp_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଗଲୁଦିଙ୍ଗ୍‍ ତେବାଦେଙ୍ଗ୍‍ ସାରାଆ ମାନାତ୍‌, ବାଦଡ଼୍‍ତି ପଟିଦିଙ୍ଗ୍‍ ତେବାଦେଙ୍ଗ୍‍ ଜାଲୁ ମାନାତ୍‌, ମାତର୍‌ ମନୁସ୍ୟପୁତ୍ରଦିଙ୍ଗ୍ ତାଲା ଇଡ୍‌ଦେଙ୍ଗ୍‌ ବାଡି ସିଲେତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ମାରି, ୱାନ୍‌ ମାରି ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ଇର୍‌ଆନ୍‌, “ନା ୱେନ୍‌କା ରାଆ ।” ମାତର୍‌ ୱାନ୍‌ ଇର୍‌ଆନ୍‌, “ଆଗ୍‌ଡ଼ି ସଲ୍‍ସୋ ନା ବୁବେଙ୍ଗ୍‌ ମୁସ୍‍ତେଙ୍ଗ୍‍ ଇଜି ନାଙ୍ଗିଁ ସାରି ସିଦା ।” ");
INSERT INTO kfcp_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ମାତର୍‌ ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ସାତି ୱାରିଙ୍ଗ୍‌ ନିଜେ ନିଜେଦି ସାତି ଲୋକାଙ୍ଗ୍‌ ମୁସ୍‍ତେଙ୍ଗ୍‍ ଇଜି ଡ଼ିସ୍‍ତୁ, ଇରିଙ୍ଗ୍‌ ମିର୍‌ ସଲ୍‍ସୋ ମାପୁରୁଦି ରାଜି ପ୍ରଚାର୍‌ କିଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ମାରି ଅରେନ୍‍ ବା ଇର୍‌ଆନ୍‌, “ପ୍ରବୁ, ନାନ୍ ନି ୱେନ୍‌କା ୱାନା, ମାତର୍‌ ଆଗ୍‌ଡ଼ି ନା ଇଲ୍‌ତୁ ମାନି ଲୋକାମାଣ୍‌କୁ ନି ୱାଲେ ୱାନି ବିସୟ୍‌ ମାଡ଼ିସ୍‍କିଦେଙ୍ଗ୍‍ ନାଙ୍ଗିଁ ସାରି ସିଦା ।” ");
INSERT INTO kfcp_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ମାତର୍‌ ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଏନ୍‌ ନାଙ୍ଗେଲ୍‍ ମେଡ଼ିଦୁ କିୟୁ ଆସ୍‌ସି ୱେନ୍‌କା ବେସ୍‍ନାନ୍‍, ୱାନ୍‌ ମାପୁରୁଦି ରାଜିଦୁ ଜୋଗ୍‍ ସିଲେନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ଇୟା ୱେନ୍‌କା ପ୍ରବୁ ମାରି ସତୁରୁ ରୁଣ୍ତି ଲୋକାଙ୍ଗ୍‌ ବାସ୍‍ସିକିତାନ୍‍ ମାରି ନିଜେ ଏମେ ଏମେ ଗାଡ଼୍‌କାଙ୍ଗ୍‌ ମାରି ବାଡିଦୁ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ବଦାକିତାମାର୍ହାନ୍‍, ଆୟା ଆୟା ବାଡିଦୁ ରିଏର୍‌ ରିଏର୍‌ କିଜି ୱାରିଙ୍ଗ୍‌ ୱାନି ଆଗ୍‌ଡ଼ି ପୋକ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ମାରି, ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ପାସି ନାଣ୍ତ, ମାତର୍‌ ପାଣିକିନିକାର୍‌ ଉଣା; ନିଜେଦି ପାସିକିଡ଼ିଇଦୁ ପାଣିକିନିୱାରିଙ୍ଗ୍‌ ପୋକ୍‌ନି ଉଣ୍ତିଙ୍ଗ୍‌ ପାସିକିଡ଼ିଇଦି ମାଲିକ୍‌ତି ଲାକ୍‌ତୁ ୱେର୍‍ତୁ । ");
INSERT INTO kfcp_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ମିର୍‌ ସାନ୍‍ଡ୍ରୁ; ସୁଡ଼ୁଦୁ, ନୋରେସ୍‍କା ଲାକ୍‌ତୁ ମେଣ୍ତାପିଲେକା ୱାଜା ନାନ୍ ମିଙ୍ଗିଁ ପୋକ୍‍ସିନା । ");
INSERT INTO kfcp_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ଡାବୁଙ୍ଗୁଁ ଆସ୍‌ନି ମଣି, ମଣି ମାରି ଜୁତେଙ୍ଗ୍‌ ଅମାଟ୍‌, ମାରି ସାରିଦୁ ଏଙ୍ଗ୍‌ବା ମାଡ଼ିସ୍‌ କିମାଟ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ମାରି, ଏମେ ଇଲ୍‌ତୁ ମିର୍‌ ଡ଼ୁଗ୍‍ନିଦେର୍‍, ଆଗ୍‌ଡ଼ି ଇନ୍‍ଡ୍ରୁ, ଇୟା ଇଲ୍‍ତି ଉଣ୍ତିଙ୍ଗ୍‌ ସାନ୍ତି ଆପିତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ମାରି, ଆୟାବାଡିଦୁ ଜଦି ଅରେନ୍‍ ସାନ୍ତିଦି ଲୋକୁ ତେବାନାନ୍‌, ଆତିଙ୍ଗ୍‌ ମି ସାନ୍ତି ୱାନି ମୁସ୍‌କୁ ବାସାନାତ୍‍; ମାତର୍‌ ଜଦି ସିଲେତ୍‍, ଆଦେଙ୍ଗ୍‌ ଆକା ମି ଲାକ୍‌ତୁ ଡ଼େସିୱାନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ୱାରିମାନୁ ଆମାକା ମାନାତ୍‌, ଆକା ଉଣୁଜିତିନ୍‌ଜି ଆୟା ଇନ୍‌ଡ୍ର ମାନ୍‌ଡ଼୍ରୁ, ଇରିଙ୍ଗ୍‌ ପାଣିକିନିକାର୍‌ ନିଜେଦି କୁଲିଦି ଡାବୁଙ୍ଗୁଁ ପୋଇଦେଙ୍ଗ୍‍ ଜୋଗ୍‍ ମାନାତ୍‌ । ଇଲ୍‌କାଙ୍ଗ୍‌ ଇଲ୍‌କାଙ୍ଗ୍‌ ସଲ୍‍ମାଟ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ମାରି, ଏମେ ଗାଡ଼୍‌ତୁ ମିର୍‌ ଡ଼ୁଗ୍‍ନିଦେର୍‍ ମାରି ଲୋକୁ ମିଙ୍ଗିଁ ମାନାର୍‌, ଆବେ ମିଙ୍ଗିଁ ଆମାକା ଉଣ୍ତେଙ୍ଗ୍‌ ସିନାର୍‍, ଆକା ଉଣ୍ତୁ । ");
INSERT INTO kfcp_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ଆୟାବାଡିଦୁ ମାନି ରୋଗ୍‌ ଲୋକାଙ୍ଗ୍‌ ନେଗେଣ୍ତ୍‍ କିଦୁ, ମାରି ୱାରିଙ୍ଗ୍‌ ଇନ୍‍ଡ୍ରୁ, ମାପୁରୁଦି ରାଜି ମି ଲାକ୍‌ତୁ ଇଗା ୱାତାତ୍‌ନି । ");
INSERT INTO kfcp_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ମାତର୍‌ ଏମେ ଗାଡ଼୍‌ତୁ ମିର୍‌ ଡ଼ୁଗ୍‍ନିଦେର୍‍ ମାରି ଲୋକୁ ମିଙ୍ଗିଁ ମାନାଏର୍‌, ଆୟା ଦୁଆର୍‍ଆଙ୍ଗାଁ ସଲ୍‌ସି ଇନ୍‍ଡ୍ରୁ, ");
INSERT INTO kfcp_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","ମି ଗାଡ଼୍‌ତି ଏମେ ଦୁଡ଼ି ମା ପାଦାମ୍‌କାଙ୍ଗ୍‌ କାସ୍‍ତାମାନାତ୍‍, ଆକାବା ମି ଉଣ୍ତିଙ୍ଗ୍‌ ସାଡ଼୍‍ସି ସିଜିନାପ୍‌; ମାତର୍‌ ମାପୁରୁଦି ରାଜି ଯେ ଇଗା ୱାତାତ୍‍, ଇକା ନେସ୍‌ସୋ ମାନ୍‌ଡ଼୍ରୁ । ");
INSERT INTO kfcp_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ଆୟାନାଣ୍ତିଙ୍ଗ୍‍ରି ଆୟା ଗାଡ଼୍‌ତି ଦଣ୍ଡ୍‌ ବାଦ୍‌ଲୁ ସଦମ୍‍ତି ଦଣ୍ଡ୍‌ ଆଟ୍‍ତେଙ୍ଗ୍‍ ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ଏ କୋରାଜିନ୍‌ ନି ଦସ୍‌ ଏସା ବୟଙ୍କର୍‍ ଆନାତ୍‌ ଏ ବେତ୍‍ସାଇଦାଦୁ ବା ନି ଦସ୍‌ ଏସା ବୟଙ୍କାର୍‍ ଆନାତ୍‌, ଇରିଙ୍ଗ୍‌ ମିବାନୁ ଏମେ ଏମେଦି ସାକ୍ତିଦି ପାଣି କିତାମାନା, ଆୟାୱିଜୁ ଜଦି ସୋର ନି ସିଦନ୍‍ତୁ କିଆଇଆତାତ୍‍ମାନ୍ଦି, ଆରିଙ୍ଗ୍‌ ୱାର୍‌ ଏସୋ ଆଗ୍‍ଡ଼ିରାନ୍‍ ବାସ୍‌ତେଙ୍ଗ୍‌ ଆରାଜି ନିର୍‍ତୁ ବାସ୍‌ସି ମନ୍‍ତିଙ୍ଗ୍‍ ଡ଼େପ୍‍ତାର୍‍ ମାନ୍ଦି । ");
INSERT INTO kfcp_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ବିସାର୍‌ କିନି ନାଣ୍ଡିଙ୍ଗ୍ ମି ଦସ୍‌ ବାଦ୍‌ଲୁ ସୋର ନି ସିଦନ୍‍ତି ଦସ୍‌ ଆଟ୍‍ତେଙ୍ଗ୍‍ ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ମାରି, ଏ କପର୍‍ନାହୁମ୍‍, ନିନ୍‌ ଇନିକା ମୁସ୍‌କୁପୁର୍‍ ସାନ୍ଦି ପିର୍‌ଦେଙ୍ଗ୍‌ ଆଟ୍‌ନି ? ନର୍କ ସାନ୍ଦି ଇଗା ସନି । ");
INSERT INTO kfcp_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ଜିସୁ ୱାନି ସିସୁରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଏନ୍‌ ମି ମାଟା ୱେନାନ୍‌, ୱାନ୍‌ ନା ମାଟା ୱେନାନ୍‌, ମାରି ଏନ୍‌ ମିଙ୍ଗିଁ ମାନାଏନ୍‌, ୱାନ୍‌ ନାଙ୍ଗିଁ ମାନାଏନ୍‌, ୱାନ୍‌ ନା ପୋକ୍‌ତିମାନି ମାଲିକ୍‌ତିଙ୍ଗ୍‌ ମାନାଏନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ଆୟାୱେନ୍‌କା ଆୟା ସତୁରି ରୁଣ୍ତି ସିସୁର୍‍ ୱେଡ଼ିକାଦାନ୍‌ ଡ଼େସିୱାଜି ଇର୍ହାର୍‌, “ପ୍ରବୁ, ଦୁବେଆଙ୍ଗ୍‌ଁ ବା ନି ଦର୍‌ତାନ୍‌ ମା ମାଟା ମାନାତେ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ମାତର୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ମିର୍‍ସ୍‍ନିୱାଜା ମୁସ୍‌କୁପୁର୍‌ତାନ୍‌ ସୟତାନ୍ ଆର୍‍ନିକା ନାନ୍ ସୁଡ଼ୁତା । ");
INSERT INTO kfcp_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ସୁଡ଼ୁଦୁ, ନାନ୍ ମିଙ୍ଗିଁ ସାରାସ୍‍ ନି ସର୍‍କୁପି ମୁସ୍‌କୁ ବୁଲାଦେଙ୍ଗ୍‌ ଅଦିକାର୍‌ ସିତାମାନା, ମାରି ସାତ୍ରୁଦି ୱିଜୁ ସାକ୍ତି ମୁସ୍‌କୁ ବା ଅଦିକାର୍‌ ସିତାମାନା, ମାରି ଇନିକା ଏଣ୍ତେସ୍‌ କିଜି ମି ପାଣିଦିଙ୍ଗ୍‌ ସେଏଣ୍ଡ୍‌ କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ତାଗ୍‍ଇଆତ୍ମମେଙ୍ଗ୍‌ ଜେ ମି ମାଟା ମାନାନେ, ଆବେ ୱେଡ଼ିକା ଆମାଟ୍‌, ମାତର୍‌ ମି ଦର୍‌ ଯେ ମୁସ୍‌କୁପୁର୍‌ ରାସାତାମାନାତ୍‌, ଆୟା ଉଣ୍ତିଙ୍ଗ୍‌ ୱେଡ଼ିକା ଆଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ଆୟାୱେନ୍‌କା ଜିସୁ ପବିତ୍ର ଆତ୍ମାଦିମାଣାନ୍‍ ୱେଡ଼ିକାଦାନ୍‌ ପୁରାଆଜି ଇର୍‌ଆନ୍‌, “ଏ ବୁବା, ମୁସ୍‌କୁପୁର୍‌ ମାରି ଦୁନିଆଦି ପ୍ରବୁ, ନିନ୍‌ ବୁଦିମାନି ଲୋକାମାଣ୍‌କୁ ଇୟାୱିଜୁ ବିସୟ୍‌ ମାର୍‍କ୍‍ସି ଇଡ୍‌ଜି ଇସ୍ରି କଡ଼ରିମାନୁ ୱେକ୍‌ତି, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ନି ଦନ୍ୟବାଦ୍‌ କିଜିନା; ହୁଁ ବୁବା, ଇରିଙ୍ଗ୍‌ ଇକା ନି ନାଣ୍ତ ବଦା । ");
INSERT INTO kfcp_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“ନା ବୁବାଦି ପାଣି ୱିଜୁ ନା କିୟୁଦୁ ସିତାମାନାନ୍‌; ମାରି, ମାରିନ୍‌ ଏନ୍‌, ଇକା ବୁବେଙ୍ଗ୍‌ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ଏନ୍‌ ନେସଏନ୍‍, ମାରି ବୁବା ଏନ୍‌, ଇକା ମାରିନ୍‍ତିଙ୍ଗ୍‍ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ଏନ୍‌ ନେସ୍‌ଏପ୍‌, ମାରି ମାରିନ୍‌ ଆମାୱାନି ଲାକ୍‌ତୁ ୱାନିଙ୍ଗ୍‌ ତର୍‌ତେଙ୍ଗ୍‍ଁ ବଦାକିନାନ୍‌, ୱାନ୍‌ ନେସ୍‌ନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ମାରି, ଜିସୁ ସିସୁରି ତରିନ୍‌ ମାର୍‍ଜି ବେସ୍‍ସି ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ମିର୍‌ ଇୟାୱିଜୁ ବିସୟ୍‌ ସୁଡ଼ୁତିମାନିଦେର୍‍ ଆକା ମିର୍‌ ଦନ୍ୟ । ");
INSERT INTO kfcp_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ମିର୍‌ ଆମାକା ଆମାକା ସୁଡ଼ୁଜିନିଦେର୍‍, ଆୟାୱିଜୁ ଏସୋ ବାବବାଦିର୍ ମାରି ରାଜାର୍‌ ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ବଦାକିତାର୍‌, ମାତର୍‌ ସୁଡ଼ୁଏତାର୍‍; ମାରି, ମିର୍‌ ଆମାକା ଆମାକା ୱେନ୍‌ଜିନିଦେର୍‌, ଆୟାୱିଜୁ ୱାର୍‌ ୱେନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ବଦାକିତାର୍‌, ମାତର୍‌ ୱେନ୍‍ଏତାର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ମାରି, ସୁଡ଼ୁଦୁ, ଅରେନ୍‍ ଦାର୍ମୁଗୁରୁ ନିଙ୍ଗ୍‍ଜି ଜିସୁଙ୍ଗୁଁ ପରିକା କିଜି ୱେନ୍‌ବାତାନ୍‌, “ଏ ଗୁରୁ, ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜିଇ ଜିବନ୍‌ତି ଅଦିକାରି ଆଦେଙ୍ଗ୍‌ ନାନ୍ ଇନିକା କିନା ?” ");
INSERT INTO kfcp_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ଆବେଟ୍‌ ଜିସୁ ଇର୍‌ଆନ୍‌, “ସାସ୍ତ୍ରଦୁ ଇନିକା ରାସାଏତ୍‌ ? ନିନ୍‌ ଏଣ୍ତେସ୍‌ ପଡ଼ାଜିନି ?” ");
INSERT INTO kfcp_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନିନ୍‌ ନି ୱିଜୁ ଜିବନ୍‌, ୱିଜୁ ଜିବନ୍‌, ୱିଜୁ ସାକ୍ତି, ମାରି ୱିଜୁ ମନ୍‍ ସିଜି ପ୍ରବୁ ନି ମାପୁରୁଙ୍ଗୁଁ ଜିବନ୍‌ ନଆ; ମାରି, ମି ଲାକ୍‌ତୁରି ଲୋକାଙ୍ଗ୍‌ ନିଜେଦିଙ୍ଗ୍‍ ଜିବନ୍‌ନୋତି ୱାଜା ଜିବନ୍‍ନୋଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ଆବେଟ୍‌ ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନିନ୍‌ ସତ୍‌ ଇର୍ହିମାନି; ଇକା କିଆ, ଆତିଙ୍ଗ୍‌ ନିନ୍‌ ଜିବନ୍‌ ପୋଇନି ।” ");
INSERT INTO kfcp_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ମାତର୍‌ ଦାର୍ମୁ ସାସ୍ତ୍ରି ନିଜେଦିଙ୍ଗ୍‍ ଦାର୍ମୁ ଲୋକୁ ଇଜି ତର୍‌ତେଙ୍ଗ୍‍ଁ ବଦାକିଜି ଜିସୁଙ୍ଗୁଁ ୱେନ୍‌ବାତାନ୍‌, “ଆରିଙ୍ଗ୍‌ ନା ଲାକ୍‌ତୁମାନିକାନ୍‌ ଏନ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ଜିସୁ ଆୟା ମାଟା ଅସି ଇର୍ହାନ୍‌, “ଅରେନ୍‍ ଲୋକୁ ଜିରୁସାଲାମ୍‍ତାନ୍‍ ଜିରିହୋଦି ଗାଡ଼୍‌ତୁ ସଲ୍‍ପୁ ସଲ୍‍ପୁ ଡଙ୍ଗାଁରି କିଦୁ ସେର୍‍ତାନ୍‍ । ୱାର୍‌ ୱାନି ୱାତିଗନ୍ଦା ଡ଼ିବିସ୍‍ତାଅତାରୋ ମାରି ଡାକ୍‍ତାରୋ ୱାନିଙ୍ଗ୍‌ ଅଡ଼ପ୍‌ଜିବନ୍‌ମାନ୍‌ବୁ ଡାକ୍‌ତାର ଡ଼ିସ୍‍ତା ସରଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ଆୟାୱାଲେ ଅରେନ୍‍ ଜାଜକ ଆୟା ସାରି ସିଜି ସଲ୍‌ସି ମାର୍‌ଆନ୍‌, ମାରି ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ସୁଡ଼ୁଜି ସାରିଦି ଆଇ ପାଡ଼୍‌କା ସିଜି ସର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ଆୟାୱାଜା ଅରେନ୍‍ ଲେବି ବା ଆୟା ବାଡିଦୁ ୱାଜି ୱାନିଙ୍ଗ୍‌ ସୁଡ଼ୁଜି ସାରିଦି ଆଇ ପାଡ଼୍‌କା ସିଜି ସର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ମାତର୍‌ ଅରେନ୍‍ ସମିରୋଣିୟ ଲୋକୁ ୱାନି ଲାକ୍‌ତୁ ୱାତାନ୍‌ନୋ ୱାନିଙ୍ଗ୍‌ ସୁଡ଼ୁଜି ନାଣ୍ତ ଦୁଃକ୍‌‍ କିତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ମାରି ୱାନି ଲାକ୍‌ତୁ ସଲ୍‌ସି ୱାନି ଗାଉକାଙ୍ଗ୍‍ୱିଜୁ ନିୟୁ ଉସ୍‍ତାନ୍‍ ମାରି ଅଙ୍ଗୁର୍‍ରସ୍‍ ୱାକ୍‍ସି ଆୟାୱିଜୁ ଗାଉତୁ ତର୍‍ତାନ୍‍, ମାରି ୱାନିଙ୍ଗ୍‌ ୱାନି ଗଦ ମୁସ୍‌କୁ ବାସିସ୍‍କିଜି ୱାନିଙ୍ଗ୍‌ ଲୋକୁ ରମ୍‌ନି ଉଣ୍ତ୍ରି ଇଲ୍‌ତୁ ଅତାନ୍‌ନୋ ୱାନି ସେବା କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ମାରିନାଣ୍ତିଙ୍ଗ୍‍ ୱାନ୍‌ ରୁଣ୍ତି ଡିନାରି ସପ୍‍ସି ଲୋକୁ ରମ୍‌ନି ଇଲ୍‍ତି ମାଲିକ୍‌ତିଙ୍ଗ୍‌ ସିଜି ଇର୍‌ଆନ୍‌, ୱେନି ସେବା କିଆ, ମାରି ଜଦି ନାଣ୍ତ ଡାବୁଙ୍ଗୁଁ କାର୍‌ସୁ ଆନେ, ଆକା ନାନ୍ ଡ଼େସିୱାନି ୱାଲେ ନିଙ୍ଗିଁ ସିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ଇୟା ମୁଏରି ଲୋଇ ଏନ୍‌ ଡଙ୍ଗାଁରି କିଦୁସେରିତି ମାର୍‍ଇ ଲୋକ୍‌ତି ପାଡ଼ିରି ଲୋକୁ ଇଜି ଅଡ଼୍‍ବିଜିନିଦେର୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ଦାର୍ମୁ ସାସ୍ତ୍ରି ଇର୍‌ଆନ୍‌, “ଏନ୍‌ ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ କାର୍ମୁ ତର୍‍ତାନାନ୍‌ ୱାନ୍‌,” ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ସାଙ୍ଗ୍ଆ, ନିନ୍‌ ବା ଆୟାୱାଜା କିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ଜିସୁ ନି ୱାନି ସିସୁର୍‍ ସନିୱାଲେ ଉଣ୍ତ୍ରି ନାର୍‍ତୁ ଡ଼ୁଗିତାର୍‍, ମାରି ମାର୍ତା ଦର୍‌ତି ଅରେତ୍‌ ଆଇମା ତାନି ଇନ୍‌ଡ୍ର ଜିସୁଙ୍ଗୁଁ କୁକ୍‍ତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ମରିୟମ୍‌ ଦର୍‌ତି ତାନି ଅରେତ୍‌ ତାଙ୍ଗିଁ ମାର୍‌ଆତ୍‌, ୱାଦ୍‌ ପ୍ରବୁଦି କାଲ୍‍କା ଆଡ୍‍ଗି ବାସ୍‌ସି ୱାନି ବାକ୍ୟ ୱେନ୍‌ଜି ମାର୍‌ଆତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ମାତର୍‌ ମାର୍ତା ରାନ୍ଦାବାଡ଼ା କିଦେଙ୍ଗ୍‌ ବେସି ତେରେପେତେ ଆଜି ମାର୍‌ଆତ୍‌; ଆଦେଙ୍ଗ୍‌ ୱାଦ୍‌ ଜିସୁ ଲାକ୍‌ତୁ ୱାଜି ଇର୍ହାତ୍‌, “ଏ ପ୍ରବୁ, ନା ତାଙ୍ଗିଁ ଜେ ନା ଅରେତ୍‍ତାନି ମୁସ୍‍କୁନେ ରାନ୍ଦାବାଡ଼ା କିନି ବଜୁ ଡ଼ିସ୍‍ତାମାନାତ୍‍, ତାନେ ତରିନ୍‌ ଇନିକା ନି ମନ୍‍ ସିଲେତ୍‌ ? ୱାଦ୍‌ ନାଙ୍ଗିଁ ସେବା କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ତାନିଙ୍ଗ୍‌ ଇନ୍‌ଆଁ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ମାତର୍‌ ପ୍ରବୁ ତାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ମାର୍ତା, ମାର୍ତା, ନିନ୍‌ ନାଣ୍ତ ବିସୟ୍‌ତାନ୍‌ ସିନ୍ତା ମାରି ତେରେପେତେ ଆଜିନି,” ");
INSERT INTO kfcp_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ମାତର୍‌ ଉଣ୍ତ୍ରି ଜିନିସ୍‌ ନାଣ୍ତଦର୍‍କାର୍‍; ମରିୟମ୍‌ ତାନେ ଉଣ୍ତିଙ୍ଗ୍‌ ନେଗି ବିସୟ୍‌ ଆସ୍‌ କିତାମାନାତ୍‌, ମାରି ଆକା ତାନେମାଣାନ୍‍ ଡ଼ିବିସୋ ଅତେଙ୍ଗ୍‌ ଆଟ୍‍ଏନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ଅର୍‍ଲେନ୍‍ ଜିସୁ ଉଣ୍ତ୍ରି ବାଡିଦୁ ପାର୍‌ତନା କିଜିମାର୍ହାନ୍‍; ୱାନ୍‌ ପାର୍‌ତନା କିତି ୱିସ୍‍ତିୱେନ୍‍କା, ୱାନି ସିସୁରି ଲୋଇ ଅରେନ୍‍ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ଏ ପ୍ରବୁ, ଡୁବନ୍‌ସିନି ଜୋହନ ଏଣ୍ତେସ୍‌ ୱାନି ସିସୁରିଙ୍ଗ୍‌ ପାର୍‌ତନା କିଦେଙ୍ଗ୍‌ ଅଜାକିତାନ୍‍, ନିନ୍‌ ବା ଆୟାୱାଜା ମାଙ୍ଗିଁ ପାର୍‌ତନା କିଦେଙ୍ଗ୍‌ ଅଜାକିଆ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ଆବେଟ୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ଏସ୍ତିୱାଲେ ମିର୍‌ ପାର୍‌ତନା କିନିଦେର୍‍, ନାସ୍ତିୱାଲେ ଇନ୍‍ଡ୍ରୁ, ବୁବା, ନି ପବିତ୍ର ଦରୁ ପେରିକାଆପିତ୍‍ । ନି ରାଜି ରାପିତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ମାଙ୍ଗିଁ ୱିଜୁଦିନ୍‌ ଦର୍‌କାର୍‌ ମାନି କାଦି ସିଦା । ");
INSERT INTO kfcp_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ମା ପାପ୍‌ ୱିଜୁ କେମା କିଆ, ଇରିଙ୍ଗ୍‌ ମାପ୍‌ ବା ମା ବିରଦ୍‌ତାନ୍‌ ପାପ୍‌ କିତିୱାରିଙ୍ଗ୍‍ କେମା କିନାପ୍‍ । ମାଙ୍ଗିଁ ଆଟ୍‌ୱା ପରିକାଦୁ ଆର୍‌ଦେଙ୍ଗ୍‌ ସିମା । ");
INSERT INTO kfcp_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ମାରି, ଜିସୁ ୱାନି ସିସୁରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ମି ଆମାୱାନି ଇୟାୱାଜା ତଡ଼୍‍ ମାନାନ୍‌ ନୋ, ଆମାୱାନି ଲାକ୍‌ତୁ ମାଜେର୍‍ନାଡ଼ା ୱାନ୍‌ ସଲ୍‌ସି ଇନାନ୍‌, ଏ ତଡ଼୍‍, ନାଙ୍ଗିଁ ମୁଣ୍ତ୍ରି ରୁଟିଙ୍ଗ୍‌ ଉଦାର୍‌ ସିଦା । ");
INSERT INTO kfcp_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ନା ଅରେନ୍‍ ଆଇ ନାଟି ତଡ଼୍‍ ନାବାନୁ ୱାତାମାନାନ୍‍, ୱାନିଙ୍ଗ୍‌ ଉଟ୍‍ପିସ୍‍ତେଙ୍ଗ୍‍ ନାବାନୁ ଇନିକା ସିଲେତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ମାରି ୱାନ୍‌ ଲୋଇରାନ୍‌ ଇୟାୱାଜା ଇନାନ୍‌, ନାଙ୍ଗିଁ କାସ୍ଟୁ ସିମା, ସେର୍‍ଲା କେର୍‍ତାନି, ମାରି ନା କଡ଼ର୍‌ ନାୱାଲେ ସୁଜ୍‍ଜିନାର୍‍; ନାନ୍ ନିଙ୍ଗିଁଜି ନିଙ୍ଗିଁ ସିଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ୱାନ୍‌ ଆତିଙ୍ଗ୍‌ବା ୱାନି ତଡ଼୍‍ ଆନାନ୍‌ ଆକା ନିଙ୍ଗ୍‍ଜ ସିଏନ୍‌, ମାତର୍‌ ୱାନ୍‌ ସେମାର୍‍ଆଏଣ୍ତା ରିଜା ମୁଜା ଲୋସ୍‍ତାନ୍‍ଆକା ୱାନ୍‌ ନିଙ୍ଗ୍‍ଜି, ୱାନିଙ୍ଗ୍‌ ଏସା ଦର୍‌କାର୍‌, ୱାନିଙ୍ଗ୍‌ ନାସୋ ସିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ନାନ୍ ବା ମିଙ୍ଗିଁ ଇଜିନା, ଲୋସ୍‍ତୁ, ଆରିଙ୍ଗ୍‌ ମିଙ୍ଗିଁ ସିଆଇଆନାତ୍‍; ପୋୟଦୁ, ଆବେଟ୍‌କୁ ମିର୍‌ ପୋୟନିଦେର୍‍; ସେର୍‌ଲାଦୁ କତ୍‍ତୁ, ଆବେଟ୍‌କୁ ମି ଉଣ୍ତିଙ୍ଗ୍‌ ସେର୍‍ଲା ରେନାସିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ଇରିଙ୍ଗ୍‌ ଏନ୍‌ ଲୋସ୍‍ନାନ୍‍, ୱାନିଙ୍ଗ୍‌ ପୁଟ୍‍ନାତ୍‍, ଏନ୍‌ ପୋୟନାନ୍‍, ୱାନ୍‌ ପୋୟ୍‍ଦେଙ୍ଗ୍‍ ଆଟ୍‍ନାନ୍‍; ମାରି, ଏନ୍‌ ସେର୍‍ଲାଦୁ କତ୍‍ନାନ୍‍, ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ସେର୍‍ଲା ରେନାସିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ମାରି, ମି ଲୋଇ ଇୟାୱାଜା ବୁବା ଏନ୍‌ ମାନାନ୍‌ ? ଆମାୱାନିଙ୍ଗ୍‍ ୱାନି ମାରିସି ମିନି ଲୋସ୍‍ତିଙ୍ଗ୍‍ ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ମିନି ବାଦ୍‌ଲୁ ସାରାସ୍‍ ସିନାନ୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ମାରି କରୁ ଗୁଡୁ ଲୋସ୍‍ତିଙ୍ଗ୍‍ ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ସର୍‍କୁପି ସିନାନ୍‍ ନୋ ? ");
INSERT INTO kfcp_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ମିର୍‌ ତାଗ୍‌ଇ ଲୋକୁ ଆତିଙ୍ଗ୍‌ବା ଏସାଙ୍ଗ୍‍ ନିଜେ ନିଜେରି କଡ଼ରିଙ୍ଗ୍‌ ନେଗି ନେଗି ଜିନିସ୍‌ ସିଦେଙ୍ଗ୍‍ ନେସ୍‌ନିଦେର୍‌, ଆରିଙ୍ଗ୍‌ ଏମେ ବୁବା ମୁସ୍‌କୁପୁର୍‌ତାନ୍‌ ସିନାନ୍‍, ୱାନ୍‌ ୱାନିମାନୁ ଲୋସ୍‍ନି ଲୋକାଙ୍ଗ୍‌ ଏସୋ ନାଣ୍ତୱାଜା ପବିତ୍ରଆତ୍ମା ସିନାନ୍‍ ! ");
INSERT INTO kfcp_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ଅର୍‍ଲେନ୍‍ ଜିସୁ ୱାର୍‍ଗିଦେଙ୍ଗ୍‍ ଆଟ୍‍ଇ ଅରେନ୍‍ ଲୋକ୍‍ମାଣାନ୍ ଦୁବା ପେର୍‍ଜିମାର୍‍ଆନ୍‍, ଦୁବା ସତି ସର୍‌ଇ ୱେନ୍‌କା ଗୁଲା ଲୋକୁ ୱାର୍‍ଗିଦେଙ୍ଗ୍‍ ଆଟ୍‍ତାନ୍‍; ଆବେଟ୍‌ ଲୋକୁ ୱିଜେରେ କାବା ଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ମାତର୍‌ ୱାରି ଲୋଇ ଏର୍‌ ଏର୍‌ ଇର୍ହାର୍‌, ଜିସୁ ଦୁବେଙ୍ଗାଁ ପେରିକାନ୍‌ ବାଲ୍‍ଜିବୁଲ୍‍ ସାକ୍ତିଦାନ୍‌ ଦୁବେଙ୍ଗ୍‍ଁ ଡ଼ିସିସ୍‍ନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ଆଇକାର୍‌ ୱାନିଙ୍ଗ୍‌ ଉରିଦୁ ଆର୍‌ପ୍‌ତେଙ୍ଗ୍‌ ବଦା କିଜିମାର୍‍ଆର୍‍ । ଆଦେଙ୍ଗ୍‌ ମାପୁରୁ ଜେ ୱାନିୱାଲେ ମାନାନ୍‌ ଇୟା ସିନାଦି ୱାଜା ୱାନିଙ୍ଗ୍‌ ବାଦଡ଼୍‍ତାନ୍‍ ଉଣ୍ତ୍ରି କାବାଆନି ପାଣି ତର୍‌ତେଙ୍ଗ୍‍ଁ ଇର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ମାତର୍‌ ଜିସୁ ୱାରି ମନ୍‍ତି ମାଟା ନେସ୍‌ସି ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ଏମେ ଦେସ୍‌ ବାଗ୍ ଆଜି ନିଜେ ବିରଦ୍‌ତାନ୍‌ ନିଙ୍ଗିଁନାତ୍‍, ଆକା ନାସ୍ଟୁ ଆନା ସନାତ୍‌, ମାରି ଉଣ୍ତ୍ରି ଇଲୁ ରୁଣ୍ତି ବାଗ୍ ଆତିଙ୍ଗ୍‌ ନାସ୍ଟୁ ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ମାରି, ସୟତାନ୍ ବା ଜଦି ବାଗ୍ ଆଜି ନିଜେ ବିରଦ୍‌ତାନ୍‌ ନିଙ୍ଗିଁତାନି, ଆତିଙ୍ଗ୍‌ ତାନି ରାଜି ଏଣ୍ତେସ୍‌ ତିର୍‍ଆଜି ତେବାନାତ୍‍ ? ନାନ୍ ବାଲ୍‍ଜିବୁଲ୍‍ତି ସାକାଦାନ୍‌ ଦୁବେଆଙ୍ଗ୍‍ଁ ଡ଼ିସିସ୍‍ନା ଇଜି ମିର୍‌ ତୋ ଇଜିନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ମାତର୍‌ ନାନ୍ ଜଦି ବାଲ୍‍ଜିବୁଲ୍‍ତି ସାକ୍ତିଦାନ୍ ତାଗ୍‌ଇ ଦୁବେଆଙ୍ଗ୍‍ଁ ପେର୍‍ଜିନା, ଆରିଙ୍ଗ୍‌ ମି କଡ଼ର୍‌ ଏମେ ସାକାଦାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଡ଼ିସିସ୍‍ନାର୍‍ ? ଆଦେଙ୍ଗ୍‌ ୱାର୍‌ ମି ମୁସ୍‌କୁ ବିସାର୍‍ କିନିକାର୍‍ ଆନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ସିଲେ, ମାତର୍‌ ମାପୁରୁଦି ସାକ୍ତିଦାନ୍ ନାନ୍ ଦୁବେଙ୍ଗ୍‌ ଡ଼ିସିସ୍‍କିନା ମାରି ଇକା ପାର୍‍ମାଣ୍‍ ଆଜିନାତ୍‍ ଜେ ମାପୁରୁଦି ରାଜି ମି ଲାକ୍‌ତୁ ଇଗା ୱାତାତ୍‌ନି । ");
INSERT INTO kfcp_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ଅରେନ୍‍ ବପୁମାନି ଲୋକୁ ଆମାସାନ୍ଦି ଜୁଦ୍‍ କିନି ସାସାପାତି ଆସ୍‌ସି ତିଆର୍‌ ଆଜି ନିଜେଦି ରାଜି ରକିୟା କିନାନ୍‌, ଆୟା ସାନ୍ଦି ୱାନି ୱିଜୁ ସମ୍ପତି ନେଗେନ୍‌ ତେବାନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ମାତର୍‌ ଏସ୍ତିୱାଲେ ୱାନିମାଣାନ୍‌ ନାଣ୍ତ ବପୁଦି ଲୋକୁ ୱାନିଙ୍ଗ୍‌ ଡାକ୍‍ସି ଜିଣାନାନ୍‍, ନାସ୍ତିୱାଲେ ଏମେ ଜୁଦ୍‍କିନି ସାସାପାତିଦୁ ୱାନି ଆସା ମାର୍‌ଆତ୍‌, ଆୟାୱିଜୁ ୱାନ୍‌ ରେନା ଅନାନ୍‍, ମାରି ୱାନି ଡଙ୍ଗାଁକିତି ଜିନିସ୍‌ ବାଟାକିନା ଅନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ଏନ୍‌ ନା ତରିନ୍‌ ସିଲେନ୍‌, ୱାନ୍‌ ନା ସାତ୍ରୁ; ମାରି, ଏନ୍‌ ନା ୱାଲେ ଉଣ୍ତା କିଏନ୍‍, ୱାନ୍‌ ଇନ୍‍ଙ୍ଗାଁ ଆନିଙ୍ଗାଁ କିନା ପୋକ୍‌ନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“ଏସ୍ତିୱାଲେ ଉଣ୍ତ୍ରି ତାଗ୍‍ଇଦୁବା ଅରେନ୍‍ ଲୋକୁ ମାଣାନ୍‌ ସତିସର୍‌ଇ ୱେନ୍‌କା ଏରୁସିଲି ବାଡିଙ୍ଗ୍‍ ୱିଜୁ ବୁଲାଜି ରମ୍‍ଦେଙ୍ଗ୍‍ ପୟ୍‌ନାତ୍‌, ମାରି ୱାଦ୍‌ ରମ୍‍ଦେଙ୍ଗ୍‍ ବାଡି ପୋୟଏତିଙ୍ଗ୍‍ ଇନାତ୍‍, ନାନ୍ ଏମେ ଇନ୍‍ଡ୍ରଣାନ୍‍ ସତା ୱାତାମାର୍‍ଆ, ନା ଆୟା ଇନ୍‌ଡ୍ର ମାରିଡ଼େସି ସନା । ");
INSERT INTO kfcp_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ମାରି, ୱାଦ୍‌ ୱାଜି ଆୟା ଇଲୁ ନେଗ୍ରେଣ୍ତା ସିପାତିକା ମାରି ୱିଜୁ ରସ୍‍ତିକା ସୁଣାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ନାସ୍ତିୱାଲେ ୱାଦ୍‌ ସଲ୍‌ସି ତାନେମାଣାନ୍‍ ନାଣ୍ତ ତାଗ୍‌ଇ ମାରି ସାତ୍‍ଗୋଟା ଆତ୍‍ମେଙ୍ଗ୍‍ ଅର୍‌ସେ ଆସ୍‍ନା ୱାନାତ୍‌, ମାରି ୱାକ୍‍ ଆବେ ଡ଼ୁଗ୍‍ନେ ନୋ ଆବେ ବାସାନେ, ମାରି ଆୟା ଲୋକ୍‌ତି ପାର୍‍ତୁମ୍‍ତି ଦସ୍‌ ବାଦ୍‌ଲୁ ୱେନ୍‌କାରି ଦସ୍‌ ନାଣ୍ତ ତାଗ୍‌ଇକା ଆନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ଜିସୁ ଇୟା ମାଟା ଇନିୱାଲେ ଲୋକା ଲୋଇରାନ୍‌ ଅରେତ୍‌ ଆଇମା ନାଣ୍ତ ଆଉଲି ଆଜି ଇର୍ହାତ୍‌, “ଦନ୍ୟ ମି ୟାୟା, ଏଦ୍‌ ନିଙ୍ଗିଁ ଜନମ୍‌ ସିତାମାନାତ୍‍ ମାରି ଆୟା ପାଲ୍‍, ଆମାଟ୍‍କୁ ନିନୁ ଉଟିମାନି ।” ");
INSERT INTO kfcp_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ଜିସୁ ଇର୍‌ଆନ୍‌, “ସିଲେ, ଏମେକାର୍‌ ମାପୁରୁଦି ବାକ୍ୟ ୱେନାର୍‌, ମାରି ମାନାନାର୍‌, ୱାର୍‌ ଦନ୍ୟ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ଲୋକ୍‌ ୱିଜେରେ ମାନ୍ଦା ମାନ୍ଦା ଆଜି ଜିସୁ ଲାକ୍‌ତୁ ଉଣ୍ତାଜି ମାର୍‍ଇ ୱାଲେ ୱାନ୍‌ ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌, ଇୟା ଦିନ୍‍ତି ମେମାରିଏନ୍‍ ତାଗ୍‍ଇକାର୍‍; ଇକାର୍‌ ସିନା ପୋଇନାର୍‍, ମାତର୍‌ ଜୁନସ୍‍ତି ସିନା ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ଆଇ ଆମା ସିନା ୱାରିଙ୍ଗ୍‌ ସିଏର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ମାତର୍‌ ଜୁନସ୍‍ ଏଣ୍ତେସ୍‌ ନିନିବିଦିୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ସିନାଦିୱାଜା ଆତାନ୍‌, ମନୁସ୍ୟପୁତ୍ର ବା ଆୟାୱାଜା ଇୟା ଜୁଗ୍‌ତି ଲୋକା ଉଣ୍ତିଙ୍ଗ୍‌ ଆନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ସିବା ଦେସ୍‌ତି ରାଣି ବିଚାର୍‍ତୁ ଇୟା ଦିନ୍‍ତୁ ମେମାର୍‍ଙ୍ଗାଁ ୱାଲେ ନିଙ୍ଗିଁଜି ଇୟାୱାରିଙ୍ଗ୍‌ ଦୋସ୍‌ ଆସିସ୍‍ କିନାତ୍‍, ମାତର୍‌ ସଲମନ୍‍ତି ବୁଦିଦି ମାଟା ୱେନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଇଜି ଦୁନିଆଦି ଆକ ଦେସ୍‍ତାନ୍‍ ୱାଦ୍‌ ୱାତାମାର୍‍ଆତ୍‍, ମାରି ସୁଡ଼ୁଦୁ, ସଲମନ୍‍ତି ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ପେରି ବିସୟ୍‌ ଇୟା ବାଡିଦୁ ମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ନିନିବିଦି ଲୋକୁ ବିଚାର୍‍ତୁ ଇୟା ଦିନ୍‍ତି ମେମାର୍‍ଙ୍ଗାଁ ୱାଲେ ନିଙ୍ଗିଁଜି ଇୟାୱାରିଙ୍ଗ୍‌ ଦସ୍‌ କିନାର୍‌, ମାତର୍‌ ୱାର୍‌ ଜୁନସ୍‍ତି ପ୍ରଚାର୍‌ତାନ୍‍ ମନ୍‍ ଡ଼େପ୍‍ତା ମାର୍‌ଆର୍‌, ମାରି ସୁଡ଼ୁଦୁ, ଜୁନସ୍‍ତି ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ପେରି ବିସୟ୍‌ ଇବେନୁ ମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“ଏନ୍‌ ଦିୱା କାସିସ୍‍ କିଜ ଆଡ଼ିକ୍‍ସି ବାକ୍‌ରାଦୁ ଇଡ୍‌ଏନ୍‌ ମାରି ଅଡି ଆଡ୍‍ଗି ଇଡ୍‌ଏର୍‌, ମାତର୍‌ ଦିୱା ଇଡ୍‌ନି ବାଡିଦୁ ଇଡ୍‍ନାର୍‍, ଏଣ୍ତେସ୍‌ ଲୋଇ ଡ଼ୁଗୁନି ଲୋକୁ ଜାୟ୍‌ ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ଆଟ୍‍ନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ମି କାଣ୍‌ଗା ମେନ୍ଦଲ୍‌ତି ଦିୱା । ଏସ୍ତିୱାଲେ ମି କାଣ୍‌ଗା ନେଗିକା ତେବାନାତ୍‍, ନାସ୍ତିୱାଲେ ମି ୱିଜୁ ମେନ୍ଧଲ୍‍ ବା ଜାୟ୍‍ୱାଜା ଆନାତ୍‌; ମାତର୍‌ ଏସ୍ତିୱାଲେ କାଣ୍‌ଗା ତାଗ୍‌ଇକା ମାନାତ୍‌, ନାସ୍ତିୱାଲେ ମି ମେନ୍ଧଲ୍‍ ବା ସିକାଟିୱାଜା ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ମାରି ଜାଗାର୍‌ତା, ଏଣ୍ତେସ୍‌ ମି ଜିବନ୍‌ତି ଜାୟ୍‌ ସିକାଟି ଆଏତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ଜଦି ମି ୱିଜୁ ମେନ୍ଧଲ୍‍ ଜାୟ୍‌ ଆନାତ୍‌ ମାରି ଆବେଣି ଇନି ବାଡିଦୁ ସିକାଟି ତେବାଏତ୍‍, ଆତିଙ୍ଗ୍‌ ଦିୱା ଏଣ୍ତେସ୍‌ ଜାୟ୍‍ତୁ ମିଙ୍ଗିଁ ଜାୟ୍‌ ସିନାତ୍‌, ଆୟାୱାଜା ମି ୱିଜୁ ମେନ୍ଧଲ୍‍ ଜାୟ୍‌ ଆନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ଜିସୁ ମାଟା ଇନ୍‍ଜିମାର୍‍ଇ ୱାଲେ ଅରେନ୍‍ ପାରୁସି ୱାନିଙ୍ଗ୍‌ ୱାନି ଇନ୍‌ଡ୍ର ଉଣ୍ତେଙ୍ଗ୍‌ କୁକ୍‍ତାନ୍‍, ମାରି ୱାନ୍‌ ଇନ୍‌ଡ୍ର ଡ଼ୁଗିତାନ୍‍ ନୋ ଉଣ୍ତେଙ୍ଗ୍‌ ବାସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ମାତର୍‌ ଉଣି ଆଗ୍‌ଡ଼ି ୱାନ୍‌ ଜେ ଆଗ୍‌ଡ଼ି ଏର୍‌ ନର୍‍ବାଏନ୍‍ ମାର୍‌ଆନ୍‌, ଇକା ସୁଡ଼ୁଜି ଆୟା ପାରୁସି କାବା ଆତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ଆବେଟ୍‌ ପ୍ରବୁ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ମିର୍‌ ପାରୁସିର୍‌ ଗାଦେ ଡୁବାଇ ନି ସାଡ଼୍‍ୱାଦି ଆତ୍‌ରେ ନର୍‍ନିଦେର୍‍, ମାତର୍‌ ମି ଲୋଇ ଡଙ୍ଗାଁକିନିପାଣି ନି ତାଗ୍‌ଇପାଣି ପୁରାମାନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ଏ ବୁଦିସିଲିକିଦେର୍‍, ଏନ୍‌ ଆତ୍‌ରେ ତିଆର୍‌ କିତାନ୍‌, ୱାନ୍‌ ଇନିକା ଲୋଇ ବା ତିଆର୍‌ କିଏତାନ୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ମି ଲବ୍ରାଦାନ୍‍ ଆମାକା ଉଣ୍ତାକିତିମାନିଦେର୍‍ ଆକା କାକୁର୍ତି ଲୋକାଙ୍ଗ୍‌ ଦାନ୍‌ ସିଦୁ ଆରିଙ୍ଗ୍‌ ମିର୍‌ ପୁରା ନର୍‌ଆନିଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","ମାତର୍‌ ଚି, ଦଣ୍ଡ୍‌ ପୋଇନି ପାରୁସିର୍‌, ଇରିଙ୍ଗ୍‌ ମିର୍‌ ପୋଦିନା, ଆରୁଦ ମାରି ୱିଜୁଜାତିଦି କୁସାପୁଲା ଦସ୍‍ବାଗ୍‍ତାନ୍‍ ଉଣ୍ତ୍ରି ବାଗ୍ ମାପୁରୁଙ୍ଗୁଁ ଦାନ୍‌ ସିନିଦେର୍‍, ମାରି ଆଇ ଲୋକାଙ୍ଗ୍‌ ନ୍ୟାୟ୍‌ ବିସାର୍‌ତୁ ଦୟା ତର୍‌ତେଙ୍ଗ୍‍ଁ ମାରି ମାପୁରୁଙ୍ଗୁଁ ଜିବନ୍‍ନୋଦେଙ୍ଗ୍‍ ବାଣାନିଦେର୍‍; ମାତର୍‌ ଇୟାୱିଜୁ କିନିକା ମାରି ଆଇକା ୱିଜୁ ବାଣାଇକା ମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“ଚି, ପାରୁସିର୍‌ ମିର୍‌ ଦଣ୍ଡ୍‌ ପୟ୍‌ନିଦେର୍‌, ଇରିଙ୍ଗ୍‌ ମିର୍‌ ପାର୍‍ତନାକିନି ଇଲ୍‌କାଙ୍ଗ୍‌ ପେରି ବାଡି ମାରି ସାତାସାଉକାଦୁ ମାଡ଼ିସ୍‍କିନିକା ପୋୟ୍‍ଦେଙ୍ଗ୍‍ ଅଡ଼୍‍ବିନିଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ଚି, ମିର୍‌ ଦଣ୍ଡ୍‌ ପୟ୍‌ନିଦେର୍‌, ଇରିଙ୍ଗ୍‌ ମିର୍‌ ତର୍‍ଇ ମୁସ୍‌ତି ବାଡ଼ିଦି ୱାଜା; ତାନି ମୁସ୍‌କୁ ନେସ୍‌ଏଣ୍ତା ବୁଲାସାଲାନିକାର୍‍ ଲୋକୁ ଆକା ମୁସ୍‌ତି ବାଡି ଇଜି ନେସ୍‌ଏର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ଆବେନୁ ସାସ୍ତ୍ରିରି ମାଣାନ୍‌ ଅରେନ୍‍ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଏ ଗୁରୁ, ଇକା ଇନ୍‌ଜି ନିନୁ ମାଙ୍ଗିଁ ବା ଅପମାନ୍‍ କିଜିନି ।” ");
INSERT INTO kfcp_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ୱାନ୍‌ ଇର୍ହାନ୍‌, “ଚି, ସାସ୍ତ୍ରିର୍‍ ଯେ ମିର୍‌ ମିର୍‌ ବା ଦଣ୍ଡ୍‌ ପୋଇନିଦେର୍‍, ଇରିଙ୍ଗ୍‌ ମିର୍‌ ଲୋକାଙ୍ଗ୍‌ ନିୟମ୍‍କୁ ମାନାଦେଙ୍ଗ୍‌ ଇଜିନିଦେର୍‌ ମାତର୍‌ ନିଜେ ମିର୍‌ ଏସାଙ୍ଗ୍‍ବା ଇବେଣି ଉନ୍‌ଡ୍ରି ନିୟମ୍‌ ବା ମାନାଦେଙ୍ଗ୍‌ ସାହାଜ୍ୟକିଇଜିନିଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ଚି, ମିର୍‌ ଦଣ୍ଡ୍‌ ପୟ୍‌ନିଦେର୍‌, ଇରିଙ୍ଗ୍‌ ମିର୍‌ ବାବବାଦିରି ମୁସ୍‌ନି ଗୁଟା ତିଆର୍‌ କିଜିମାନିଦେର୍‍, ଆମାୱାରିଙ୍ଗ୍‍ ମି ପୁର୍ବେଦିଡକ୍‌ରାଦାଦାର୍‌ ୱାରିଙ୍ଗ୍‌ ସାୟାମାର୍‌ଗା ଡାକ୍‌ତା ମାର୍‍ଆର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ମାରି, ମି ପୁର୍ବେଦିଡକ୍‌ରାଦାଦାରି ପାଣିଦି ବିସୟ୍‌ତାନ୍‌ ମିର୍‌ ସାକି ଆନିଦେର୍‌ ମାରି ଆକା ରାଜି ଆଜିନିଦେର୍‍; ଇରିଙ୍ଗ୍‌ ୱାର୍‌ ଗାଦେ ବାବବାଦିରିଙ୍ଗ୍ ସାୟାମାର୍‌ଗା ଡାକ୍‌ତା ମାର୍‍ଆର୍‍, ମାତର୍‌ ମିର୍‌ ୱାରିଦି ମୁସ୍‌ନିବାଡି ତିଆର୍‌ କିଜିନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ଆଦେଙ୍ଗ୍‌ ମାପୁରୁ ବା ନିଜେଦି ବୁଦିଦାନ୍‍ ଇର୍‌ଆ ମାନାନ୍‌, ମାପ୍‌ ୱାରି ଲାକ୍‌ତୁ ବାବବାଦି ନି ପ୍ରେରିତ ସିସୁରିଙ୍ଗ୍‌ ପୋକ୍‌ନା; ୱାରି ଲୋଇରାନ୍‌ ଏଙ୍ଗ୍‌ ଏଙ୍ଗ୍‌ ୱାର୍‌ ସାୟାମାର୍‌ଗା ଡାକ୍‌ନାର୍‌ ମାରି ଏଙ୍ଗ୍‌ ଏଙ୍ଗ୍‌ କାସ୍ଟୁ ସିନାର୍‍, ");
INSERT INTO kfcp_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ଇୟା ଜଗ୍‍ତି ଲୋକୁ ଦୁନିଆଦି ତିଆର୍‌ଆତି ଆଗ୍‍ଡ଼ିରାନ୍‍ ୱିଜେରେ ବାବବାଦିରି ସାୟାମାର୍‌ଗା ଡାକ୍‌ତିମାନି ଉଣ୍ତିଙ୍ଗ୍‌ ଦଣ୍ଡ୍‌ ପୟ୍‌ନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ହେବଲ୍‌ତି ଡାକ୍‍ତିମାଣୁକୁ ଆରାମ୍‌ କିଜି ଜିକରିୟଦି ସାନ୍ଦି, ଆମାୱାନିଙ୍ଗ୍‌ ପୁଜାକିନି ବେଦି ମାରି ପବିତ୍ର ବାଡିଦୁ ସାୟାମାର୍‌ଗାଡାକ୍‍ତା ମାର୍‌ଆର୍‌, ହୁଁ, ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ଇୟା ଜଗ୍‍ତି ଲୋକୁ ଆୟା ୱିଜେରି ଉଣ୍ତିଙ୍ଗ୍‌ ଦଣ୍ଡ୍‌ ବଗାନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“ଚି, ଦଣ୍ଡ୍‌ ପୟ୍‌ନି ସାସ୍ତ୍ରିର୍‍, ଇରିଙ୍ଗ୍‌ ମିର୍‌ ବୁଦିଦି କୁସିକାଣ୍ତି ନିଜେ ଇଟ୍‍ତିଦେର୍‍; ମିର୍‌ ନିଜେନିଜେ ଡ଼ୁଗ୍‍ଇତିଦେର୍‍ ମାରି ଡ଼ୁଗୁଦେଙ୍ଗ୍‍ ବଦାକିତି ଲୋକାଙ୍ଗ୍‌ ସାରି ସିଇତିଦେର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ମାରି, ଜିସୁ ଆବେଟ୍‌କୁ ସତିସର୍‌ଇ ୱେନ୍‌କା ସାସ୍ତ୍ରିର୍‍ ନି ପାରୁସିର୍‌ ନାଣ୍ତ ରିସା ଆଜି, ");
INSERT INTO kfcp_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ୱାନି ୱେୟୁଦାନ୍‌ ଇନି ତାଗ୍‌ଇ ମାଟା ଆସ୍‌ସି ଉଣ୍ତିଙ୍ଗ୍‌ ଉରିଦୁ ଆର୍‍ପ୍‍ତେଙ୍ଗ୍‍ ୱାନିଙ୍ଗ୍‌ ନାଣ୍ତ ବିସୟ୍‌ତାନ୍‌ ମାଟା ୱେନ୍‍ବାଦେଙ୍ଗ୍‍ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ଆବେନୁ ଅଜାର୍‌ଅଜାର୍‌ ଲୋକୁ ଉଣ୍ତାତାର୍‌ ନୋ ନିଜେ ନିଜେଦି ମୁସ୍‌କୁ ମାଟ୍‌ସିସାଜିମାର୍ହାର୍‌; ନାସ୍ତିୱାଲେ ଜିସୁ ଆଗିଡ଼ି ନିଜେଦି ସିସୁରିଙ୍ଗ୍‌ ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌, ପାରୁସିର୍‌ କମିର୍‌ ୱାଜା ଟକ୍‍ତି ବିସୟ୍‌ତାନ୍‌ ଜାଗାର୍‌ତା ମାନ୍‌ଡ଼୍ରୁ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ମାତର୍‌ ଆମାକା ମାର୍‍ଗିତା ମାନାତ୍‌, ଆକା ତରାନାତ୍‍ । ମାରି ୱିଜୁ ବିସୟ୍‌ ତରାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ମିର୍‌ ଆମାକା ସିକାଟିଦୁ ଇର୍‌ଇମାନିଦେର୍‌, ଆୟାୱିଜୁ ଜାୟ୍‌ତୁ ୱେନିଦେର୍‌, ମାରି ଆମାକା ନେସ୍‌ଇ ୱାଜା ବାକ୍‍ରା ଲୋଇ ମାରାକ୍‌ସି ଇର୍‌ଇମାନିଦେର୍‌, ଆକା ଇଲୁଦି ସାତ୍ ମୁସ୍‌କୁ ପ୍ରଚାର୍‌ କିଆୟ୍‌ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ମାତର୍‌ ନା ତଡ଼୍‍କୁ ଜେ ମିର୍‌, ମିଙ୍ଗିଁ ନାନ୍ ଇଜିନା, ଏମାକାର୍‌ ମେନ୍ଦଲ୍‌ତିଙ୍ଗ୍‌ କାତ୍‌ନାର୍‌, ମାତର୍‌ ତାନେୱେନ୍‌କା ମାରି ଇନିକା କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏର୍‍, ୱାରିଙ୍ଗ୍‌ ତିଲାମାଟ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ମାତର୍‌ ଏଙ୍ଗ୍‌ ତିଲାନିଦେର୍‌, ଆକା ନାନ୍ ମିଙ୍ଗିଁ ୱେର୍‌ନା; ସାୟାମାର୍‌ଗାଡାକ୍‌ତି ୱେନ୍‌କା ନରକଦୁ ପୋକ୍‌ନି ଉଣ୍ତିଙ୍ଗ୍‌ ଆମା ମାପୁରୁଦି ଅଦିକାର୍‌ ମାନାତ୍‌, ୱାନିଙ୍ଗ୍‌ ତିଲାଦୁ; ହୁଁ, ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ୱାନିଙ୍ଗ୍‌ ତିଲାଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ପାସ୍‌ଗୋଟା ସାଡ଼ାପୋଟିଙ୍ଗ୍‌ ଇନିକା ଉଣା ଡାବୁଆଙ୍ଗ୍‍ଁ ପୋର୍‌ଏର୍‌ ନୋ ? ମାରି, ୱାନିକା ମାଣ୍‌କୁ ଉଣ୍ତ୍ରିତାନିଙ୍ଗ୍‌ ବା ମାପୁରୁ ବାଣାଏନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ମାତର୍‌ ମି ତାଲାଦି କୁକୁଟି ବା ୱିଜୁ ଲେକିସ୍‌ କିଆୟ୍‍ଆତାମାନାତ୍‍ । ତିଲାମାଟ୍‌; ମିର୍‌ ନାଣ୍ତ ସାଡ଼ାପୋଟିଙ୍ଗାଁ ମାଣାନ୍‌ ନାଣ୍ତ ! ");
INSERT INTO kfcp_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","ମାରି, ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ଏନ୍‌ ଲୋକା ଆଗିଡ଼ି ନାଙ୍ଗିଁ ମାନାନାର୍‌, ମନୁଷ୍ୟପୁତ୍ର ବା ମାପୁରୁଦି ମୁସ୍‌କୁପୁର୍‌ତି ଦୁତ୍‍କା ଆଗ୍‌ଡ଼ି ୱାନିଙ୍ଗ୍‌ ମାନାନାର୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ମାତର୍‌ ଏନ୍‌ ଲୋକା ଆଗିଡ଼ି ନାଙ୍ଗିଁ ମାନାଏନ୍‌, ୱାନ୍‌ ମାପୁରୁଦି ଦୁତ୍‌କା ଆଗିଡ଼ି ମାନାକିବିସ୍‌ କିଏର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","ମାରି, ଏନ୍‌ବା ମନୁଷ୍ୟପୁତ୍ରଦି ବିରଦ୍‌ତାନ୍‌ ମାଟା ଇନ୍‌ନାନ୍‌, ୱାନିଙ୍ଗ୍‌ କେମା ପୁଟ୍‌ନାତ୍‌; ମାତର୍‌ ଏନ୍‌ ପବିତ୍ରଆତ୍ମାଦି ବିରଦ୍‌ତାନ୍‌ ନିନ୍ଦା ମାଟା ଇନ୍‌ନାନ୍‌, ୱାନିଙ୍ଗ୍‌ କେମା ପୁଟ୍‌ଏତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“ମାରି, ଏସ୍ତିୱାଲେ ୱାର୍‌ ମିଙ୍ଗିଁ ପାର୍‌ତନା ଇଲୁଦୁ, ସାସନ୍‌କିନିୱାରିମାନୁ ମାରି ଅଦିକାର୍‍ ପୋଇତି ଲୋକା ଲାକ୍‌ତୁ ଅନାର୍‍, ନାସ୍ତିୱାଲେ ମିର୍‌ ମି ତରିଟାନ୍‌ ଏଣ୍ତେସ୍‌ମାରି ଇନି ମାଟା ଇଣ୍ତ୍ରେଙ୍ଗ୍‌ ଆନାତ୍‌ ମାରି ଇନିକା ଇନା, ଆୟା ବିସୟ୍‌ତାନ୍‌ ଚିନ୍ତା କିମାଟ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ଇରିଙ୍ଗ୍‌ ଇନିକା ଇଣ୍ତ୍ରେଙ୍ଗ୍‌ ଆନାତ୍‌, ଆକା ପବିତ୍ର ଆତ୍ମା ଆୟାୱାଲେ ମିଙ୍ଗିଁ ଅଜା କିନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ଲୋକା ଲୋଇରାନ୍‌ ଅରେନ୍‍ ଜିସୁଙ୍ଗୁଁ ଇର୍‌ଆନ୍‌, “ଏ ଗୁରୁ, ନା ତଡ଼ାନ୍‌ତିଙ୍ଗ୍‌ ନା ୱାଲେ ବୁବାଦି ଦନ୍‌ ସମ୍ପତ୍ତି ବାଟା କିଜ ସିଦେଙ୍ଗ୍‍ ଇନ୍‌ଆଁ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ମାତର୍‌ ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ଏ ତଡ଼୍‍, ଏନ୍‌ ନାଙ୍ଗିଁ ମି ଦନ୍‍ ସମ୍ପତି ମୁସ୍‌କୁ ବିସାର୍‌ କିନିକାନ୍‌ ମାରି ବାଟା କିଜି ସିଦେଙ୍ଗ୍‍ ନିଲପ୍‍ତାନ୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ମାରି, ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ଜାଗ୍‌ରାତା, ୱିଜୁଜାତିଦି ଆସାଦାନ୍‍ ନିଜେ ନିଜେଦିଙ୍ଗ୍‌ ଆକ ଇଡ୍‌ଦୁ, ଇରିଙ୍ଗ୍‌ ଅରେନ୍‍ ଲୋକ୍‌ତି ଜିବନ୍‌ ୱାନି ଦନ୍‌ ସମ୍ପତ୍ତି ମୁସ୍‌କୁ ଆସାଏନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ମାରି ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଇୟା କାତା ଇର୍‌ଆନ୍‌, ଅରେନ୍‍ ମାଜନ୍‌ ଲୋକ୍‌ତି କିଡ଼ିଇଦୁ ନାଣ୍ତ ପାସି ଆତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ଆବେଟ୍‌ ୱାନ୍‌ ମନ୍‌ତୁ ମନ୍‌ତୁ ଅଡ଼୍‍ବିଜି ଇର୍‌ଆନ୍‌, ଇନିକା କିନା ? ଇରିଙ୍ଗ୍‌ ନା ପାସି ଉଣ୍ତା କିଜି ଇଡ୍‌ଦେଙ୍ଗ୍‌ ବାଡି ସିଲେତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ମାରି, ୱାନ୍‌ ଇର୍‌ଆନ୍‌, ଇକା କିନା; ନାନ୍ ଆଗିଡ଼ି ଇଡ୍‍ନି କଲ୍‍କି ରୁକ୍‍ସି ପେରି ପେରି କଲ୍‍କିଙ୍ଗ୍‍ଁ କିଜି ତିଆର୍‌ କିନା ମାରି ଆୟାୱିଜୁ ମାନୁ ନା ପାସି ଉଣ୍ତା କିଜି ଇଡିନା, ");
INSERT INTO kfcp_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ମାରି ନାନ୍ ନା ଜିବନ୍‌ତିଙ୍ଗ୍‌ ଇନା, ରେ ଜିବନ୍‌, ଏସ ବାର୍ସେକ୍‌ତି ଉଣ୍ତିଙ୍ଗ୍‌ ନି ଉଣିତିନିକା ନାଣ୍ତ ପାସି ଉଣ୍ତାତାମାନାତ୍‌, ରମ୍‌ଆ, ଉଣୁଆ, ୱେଡ଼ିକା କିଆ; ");
INSERT INTO kfcp_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ମାତର୍‌ ମାପୁରୁ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ଏ ବୁଦି ସିଲିକିନ୍ଦା, ନେର୍‌ ନାଡ଼ା ନି ଜିବନ୍‌ ନିବାଣାକୁ ଅନା; ଆବେଟ୍‌କୁ ନିନ୍‌ ଆମାକା ଆମାକା ନିଜେଦିଙ୍ଗ୍‍ ଉଣ୍ତା କିତିମାନି, ଆୟାୱିଜୁ ଏନ୍ଧି ଆନାତ୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ଏନ୍‌ ନିଜେଦି ଉଣ୍ତିଙ୍ଗ୍‌ ଦନ୍‌ ଉଣ୍ତା କିନାନ୍‍, “ମାତର୍‌ ମାପୁରୁଦି ଆଗ୍‌ଡ଼ି ମାଜନ୍‌ ଆଏନ୍‍, ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ଇୟାୱାଜା ଗଟେଆନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ଜିସୁ ନିଜେଦି ସିସୁରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ଇଜିନା, ଇନିକା ଉଣା, ଇୟାୱାଜା ଇଜି ମି ଜିବନ୍‌ତି ଉଣ୍ତିଙ୍ଗ୍‌, ମାରି ଇନିକା ଆରାନା, ଇୟାୱାଜା ଇଜି ମି ମେନ୍ଦଲ୍‌ତି ଉଣ୍ତିଙ୍ଗ୍‌ ବା ସିନ୍ତା କିମାଟ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ଇରିଙ୍ଗ୍‌ ଉଣି ବାଦୁଲୁ ଜିବନ୍‌ ମାରି ଆଙ୍ଗିଁ ଆରାନି ବାଦୁଲୁ ମେନ୍ଧଲ୍‍ ପେରିକା । ");
INSERT INTO kfcp_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","କାକିଆଙ୍ଗ୍‌ଁ ବିସୟ୍‌ ଅଡ଼୍‌ବିଜ ସୁଡ଼ୁଦୁ, ୱାକ୍‍ ୱିତୁ ୱିତ୍‌ଉ କି କୟ୍‌ଉ, ମାରି ତାମେ ଇଲୁ କି ପାସି ଇଡ୍‌ନି କଲ୍‍କି ସିଲେତ୍‌, ମାରି ମାପୁରୁ ୱାନିକାଙ୍ଗ୍‌ କାଦି ସିନାନ୍‌; ମିର୍‌ ପଟିଙ୍ଗାଁ ବାଦୁଲୁ ଏସ ନାଣ୍ତ ପେରିକିଦେର୍‌ ! ");
INSERT INTO kfcp_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ମାରି, ମି ଲୋଇ ଏନ୍‌ ସିନ୍ତା କିଜି କିଜି ନିଜେଦି ବାର୍ସେକ୍‌ ଉଣ୍ତ୍ରି ମୁରା ପିରିସ୍‍କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାନ୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ମିର୍‌ ଜଦି ୱିଜୁମାଣାନା ଇସ୍ରି ବିସୟତିଙ୍ଗ୍‌ ବା କିଦେଙ୍ଗ୍‌ ସାକ୍ତି ସିଲେତ୍‌, ଆରିଙ୍ଗ୍‌ ଆଇ ୱିଜୁ ବିସୟତି ଉଣ୍ତିଙ୍ଗ୍‌ ଏନ୍ଧା ସିନ୍ତା କିଜିନିଦେର୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ପୁଙ୍ଗୁଁକାଙ୍ଗ୍‍ ଅଡ଼୍‌ବିଜ ସୁଡ଼ୁଦୁ, ୱାକ୍‍ ଏଣ୍ତେସ୍‌ ନୁଲ୍ କୟ୍‌ଉ କି ୱାତି ଗୁତ୍‌ଉ; ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ରାଜା ସଲମନ୍‍ ବା ଆୟା ଦନ୍‌ତି ପୁଙ୍ଗୁଁକା ଲୋଇରାନ୍‌ ଏମେ ଉଣ୍ତ୍ରି ପୁଙ୍ଗୁଁତି ୱାଜା ବା ସୁନ୍ଦର୍‌ ଆଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏନ୍‍ ମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ମାତର୍‌ ନେର୍‌ ଆମା ଲାଟା କିଡ଼ିଇଦୁ ମାନାତ୍‌, ମାରି ୱିଗେରିଙ୍ଗ୍‌ ସିସୁଗୁଟାଦୁ ପୋକ୍‌ନାର୍‌, ତାନେଙ୍ଗ୍‌ ଜଦି ମାପୁରୁ ଇୟାୱାଜା ରୁପ୍‌ ସିନାନ୍‌, ଆରିଙ୍ଗ୍‌, ଏ ଉଣା ବିସ୍‍ବାସ୍‍ସିର୍‍, ୱାନ୍‌ ମିଙ୍ଗିଁ ଏସ ନାଣ୍ତ ସିଏନ୍‌ ! ");
INSERT INTO kfcp_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ମାରି ଇନିକା ତିନା ମାରି ଇନିକା ଉଣା, ଆକା ମିର୍‌ ପୋଇଜି ବୁଲାମାଟ୍‌ ମାରି ସିନ୍ତା କିମାଟ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ଇରିଙ୍ଗ୍‌ ଦୁନିଆଦି ଅଣଜିହୁଦି ଲୋକୁ ଇୟାୱିଜୁ ବିସୟ୍‌ ପୋଇଜି ବୁଲାନାର୍‌; ମାତର୍‌ ଇୟାୱିଜୁ ବିସୟ୍‌ ଜେ ମିଙ୍ଗିଁ ଦର୍‌କାର୍‌ ମାନାତ୍‌, ଆକା ମି ବୁବା ନେସ୍‌ନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ମିର୍‌ ମାପୁରୁଦି ରାଜି ବିସୟ୍‌ ପୋୟଦୁ, ମାରି ଇୟାୱିଜୁ ବିସୟ୍‌ ବା ମିଙ୍ଗିଁ ପୁଟ୍‌ନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ଏ ଇସ୍ରି ମାନ୍ଦା, ତିଲାମାଟ୍‌, ଇରିଙ୍ଗ୍‌ ମିଙ୍ଗିଁ ଆୟା ରାଜି ସିଦେଙ୍ଗ୍‍ ଇଜି ମି ମୁସ୍‌କୁପୁର୍‌ତି ବୁବା ବଦା କିଜିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ମିଙ୍ଗିଁ ଆମାକା ମାନାତ୍‌, ଆକା ପୋର୍‌ଜି କାକୁର୍ତି ଲୋକାଙ୍ଗ୍‌ ସିଦୁ; ଆମାକା ସେଏଣ୍ଡ୍‌ ଆଏତ୍‍, ଇୟାୱାଜା ମଣି ନିଜେ ନିଜେଦି ଉଣ୍ତିଙ୍ଗ୍‌ ତିଆର୍‌ କିଦୁ; ଏମେମାନୁ ଡଙ୍ଗାଁର୍‌ଏନ୍‌ ଲାକ୍‌ତୁ ରେଏନ୍‌ ମାରି ପିଡ଼ୁକୁ ତିନ୍‌ଉ, ଇୟାୱାଜା ମୁସ୍‌କୁପୁର୍‌ତୁ ନାଷ୍ଟୁ ଆଇ ଦନ୍‌ ଉଣ୍ତା କିଦୁ, ");
INSERT INTO kfcp_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ଇରିଙ୍ଗ୍‌ ଏମେମାନୁ ମି ଦନ୍‌, ଆବେବା ମି ମୋନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","ପାଣିକିନି ଉଣ୍ତିଙ୍ଗ୍‌ ୱିଜୁଦିନ୍‌ ତିଆର୍‌ ଆଜି ମାନ୍‌ଡ଼୍ରୁ ମାରି ମି ଦିୱେଙ୍ଗ୍‌ କାସିସ୍‌ କିଜ ଇଡ୍‌ଦୁ; ");
INSERT INTO kfcp_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ମାରି ମାଲିକ୍‌ ପେଡ଼ି ଇଣ୍ତ୍ରରାନ୍‌ ଡ଼େସିୱାଜି ସେର୍‌ଲାଦୁ କତ୍‌ନି ଦାପେ ଏମେ ଲୋକୁ ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ଆୟା ଦାପ୍ରେ ସେର୍‍ଲା ରେତେଙ୍ଗ୍‌ କାପ୍‌କିଜି ତେବାନାନ୍‌, ମିର୍‌ ୱାରି ୱାଜା ଆଜି ମାନ୍‌ଡ଼୍ରୁ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ମାଲିକ୍‌ ୱାଜି ଆମା ଗତିମୁରୁଲିରିଙ୍ଗ୍‌ ଜାଗ୍‌ରାତା ମାନିକା ସୁଣାନ୍‌, ୱାର୍‌ ଦନ୍ୟ; ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ମାଲିକ୍‌ ବା ୱାରି ସେବାକିଦେଙ୍ଗ୍‍ ନିଜେଦିଙ୍ଗ୍‌ ତିଆର୍‌ କିନାନ୍‌, ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ବାସ୍‌ତେଙ୍ଗ୍‌ ଇଜି ଇନାନ୍‌ ମାରି ନିଜେ କାଦି ବାଟାକିଜି ସିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ମାରି, ୱାନ୍‌ ଜଦି ମାଜେର୍‌ ନାଡ଼ା ନୋ କର୍‍ରୁ କେଡ଼ିପି ବା ୱାଜି ୱାରିଙ୍ଗ୍‌ ଆୟାୱାଜା ସୁଣାନ୍‌, ଆତିଙ୍ଗ୍‌ ଆୟା ସାକର୍‍କୁ ଦନ୍ୟ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ମାତର୍‌ ଇକା ନେସ୍‌ସୋ ମାନ୍‌ଡ୍ରୁ, ଏସିୱାଲେ ଡଙ୍ଗାଁର୍‌ଏନ୍‌ ୱାନାନ୍‌, ଇକା ଇଲୁଦି ମାଲିକ୍‌ ଏସ୍‌କାଙ୍ଗ୍‌ ନେସ୍‌ନାନ୍‌, ଆତିଙ୍ଗ୍‌ ୱାନ୍‌ ନିଜେଦି ଇଲ୍‌ତୁ ଡଙ୍ଗାଁ କିଦେଙ୍ଗ୍‌ ସିଏତାନ୍‌ମାନ୍ଧି । ");
INSERT INTO kfcp_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ମିର୍‌ ବା ୱିଜୁଦିନ୍‌ ଜାଗାର୍‌ତା ଆଜମାନ୍‌ଡ୍ରୁ, ଇରିଙ୍ଗ୍‌ ଏସ୍ତିୱାଲେ ମିର୍‌ ଅଡ଼୍‌ବିଇମାନିଦେର୍‌, ଆୟାୱାଲେ ମନୁସ୍ୟପୁତ୍ର ୱାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ଆବେଟ୍‌ ପିତର୍‌ ଇର୍‌ଆନ୍‌, “ଏ ପ୍ରବୁ, ନିନ୍‌ନେ ମାଙ୍ଗିଁ ନୋ ୱିଜେରିଙ୍ଗ୍‌ ଇୟା କାତା ଇଜିନି ?” ");
INSERT INTO kfcp_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ପ୍ରବୁ ଇର୍‌ଆନ୍‌, “ବିସ୍‌ବାସ୍‌ ମାରି ବୁଦିଦି ସାକର୍‌ ଏନ୍‌ ? ଆମାୱାନିଙ୍ଗ୍‌ ମାଲିକ୍‌ ଇଲୁ ସାଲାକିଦେଙ୍ଗ୍‌ ଇଡ୍‌ନାନ୍‌, ୱାନ୍‌ ଆଇ ସାକର୍‌କାଙ୍ଗ୍‌ ୱାରି କାଦି ସାମାନ୍‍ ବେଡ଼ାଦୁ ସିଦେଙ୍ଗ୍‍ ଇଜି ଅରେନ୍‍ ସାକର୍‌ତିଙ୍ଗ୍‌ ଇର୍‌ଆମାର୍‌ଆନ୍‌, ଆମାୱାନିଙ୍ଗ୍‌ ଇୟା ପାଣି କିଦେଙ୍ଗ୍‌ ଇଜି ମାଲିକ୍‌ ବିସ୍‌ବାସ୍‌ କିନାନ୍‌, ଆୟା ପାଣିକିନିକାନ୍‌ ଏନ୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ପ୍ରବୁ ଡ଼େସିୱାଜି ନିଜେଦି ଆମା ଗତିମୁରୁଲିଙ୍ଗ୍‌ ଆୟାୱାଜା କିନିକା ସୁଣାନ୍‌, ୱାନ୍‌ ଦନ୍ୟ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ନିଜେଦି ଦନ୍‍ ମୁସ୍‌କୁ ପାଣିୱିଜୁ କିଦେଙ୍ଗ୍‌ ସିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ମାତର୍‌ ଜଦି ଆୟା ସାକର୍‌ ନା ମାଲିକ୍‌ ୱାନିକା ୱେଡ଼ାଆନାତ୍‌ ଇଜି ଅଡ଼୍‍ବିଜି ମନ୍‍ତୁ ଇଜି ସାକର୍‌କାଙ୍ଗ୍‌ ଡାକ୍‌ତେଙ୍ଗ୍‍ଁ ଇଜି ମାରି ଉଣୁଜିତିନ୍‌ଜି ସୋସ୍‍ତେଙ୍ଗ୍‌ ଆରାମ୍‌ କିନାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ଆତିଙ୍ଗ୍‌ ଏମେ ନାଣ୍ତିଙ୍ଗ୍‌ ଗତିମୁରୁଲି ୱାନିଙ୍ଗ୍‍ କାପ୍‌କିଜି ମାନ୍‌ଇୱାଲେ ମାରି ଏମେ ୱେଡ଼ା ୱାନ୍‌ ନେସ୍‌ଏନ୍‌ମାନାନ୍‌, ଆୟା ନାଣ୍ତିଙ୍ଗ୍‌ ମାରି ନାସ୍ତିୱାଲେ ୱାନି ମାଲିକ୍‌ ୱାନାନ୍‌, ମାରି ମାଲିକ୍‌ ୱାନିଙ୍ଗ୍‌ ନାଣ୍ତ ଦଣ୍ଡ୍‌ ସିନାନ୍‍ । ୱାନ୍‍ ଅବିସ୍‍ବାସ୍‍ତି ଦାସ୍‌କା ଦଣ୍ତ୍‍ ପୟ୍‌ନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","ମାରି ଆମା ଗତିମୁରୁଲି ନିଜେଦି ମାଲିକ୍‌ତି ବଦା ନେସେଇ ଜାଗ୍‌ରାତା ତେବାଏନ୍‌ ମାରି ୱାନି ବଦାଦାନ୍ ପାଣିକିଏନ୍‌ ମାନାନ୍‌, ୱାନ୍‌ ମାଡ୍‌ ମୁସ୍‌କୁ ମାଡ୍‌ ପୋଇନାନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ମାତର୍‌ ଏନ୍‌ ନେସ୍‌ଏଣ୍ତା ଦଣ୍ତ୍‍ତି ପାଣିକିନା ମାନାନ୍‌ ୱାନ୍‌ ଉଣା ଦଣ୍ଡ୍‌ ପୋଇନାନ୍‌ । ଆମାୱାନିଙ୍ଗ୍‌ ନାଣ୍ତ ସିତାମାନାନ୍‌, ୱାନି ମାନୁ ନାଣ୍ତ ଲସ୍‌ନାନ୍‌; ମାରି, ଆମାୱାନି ଲାକ୍‌ତୁ ନାଣ୍ତ ସିତାମାନାର୍‌ ୱାନି ମାଣ୍‌କୁ ନାଣ୍ତ ଲୋସ୍‌ନାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“ନାନ୍ ଦୁନିଆଦୁ ସିସୁ କାସିସ୍‌କିଦେଙ୍ଗ୍‌ ୱାତାମାନା, ମାରି ଆକା ଜଦି କାସ୍‌ତାତ୍‌ନି, ଆତିଙ୍ଗ୍‌ ନାଙ୍ଗିଁ ମାରି ଇନିକା ବଦା ? ");
INSERT INTO kfcp_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ମାତର୍‌ ନାଙ୍ଗିଁ ଉଣ୍ତ୍ରି ଡୁବନ୍‌ତୁ ଡୁବନ୍‌ ଆଦେଙ୍ଗ୍‌ ଆନାତ୍‌, ମାରି ଆକା ୱିଜିଇ ସାନ୍ଧି ନାନ୍ ଏଣ୍ତେସ୍‌ କାସ୍ଟୁ ଆଜିନା । ");
INSERT INTO kfcp_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ନାନ୍ ଦୁନିଆଦୁ ସାନ୍ତି ସିଦେଙ୍ଗ୍‍ ୱାତାମାନା ଇଜି ଇନିକା ମିର୍‌ ଅଡ଼୍‍ବିଜିନିଦେର୍‍ ? ସିଲେ, ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ମାତର୍‌ ବାଗ୍ ବାଗ୍ କିଦେଙ୍ଗ୍‌ ୱାତାମାନା । ");
INSERT INTO kfcp_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ଇରିଙ୍ଗ୍‌ ଆଗ୍‍ଡ଼ିରାନ୍‍ ଉଣ୍ତ୍ରି ଇନ୍‌ଡ୍ର ପାସ୍‌ ଲୋକୁ ମାର୍‌ଆର୍‌ ମାରି ରିଏରି ବିରଦ୍‌ତାନ୍‌ ମୁଏର୍‌ ମାରି ମୁଏରି ବିରଦ୍‌ତାନ୍‌ ରିଏର୍‌ ୱେର୍‍ହେ ଆନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ମାରିସି ବିରଦ୍‌ତାନ୍‌ ବୁବାସି, ବୁବାସି ବିରଦ୍‌ତାନ୍‌ ମାରିସି, ଗାଡ଼୍‌ସି ବିରୁଦ୍‍ତାନ୍‍ ଆଇସି, ଆଇସି ବିରଦ୍‌ତାନ୍‌ ଗାଡ଼୍‌ସି, କଡ଼େସି ବିରୁଦ୍‍ତାନ୍‍ ମିମ୍‍ସି ମାରି ମିମ୍‍ସି ବିରଦ୍‌ତାନ୍‌ କଡ଼େସି ୱେର୍‍ଏ ଆନେ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ମାରି, ଜିସୁ ଲୋକାଙ୍ଗ୍‌ ବା ଇର୍ହାନ୍‌, “ୱେଡ଼ାଆର୍‌ନି ତରିନ୍‍ ବାଦଡ଼୍‍ ନିଙ୍ଗିଁକା ସୁଡ଼ୁତିଙ୍ଗ୍‌ ଆୟାଦାପ୍ରେ ମିର୍‌ ଇନିଦେର୍‌, ପିରୁ ୱାଜିନାତ୍‍, ମାରି ଆୟାୱାଜା ଗଟାନାତ୍‍; ");
INSERT INTO kfcp_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ମାରି, ଉଣେରି ତରିଟାନ୍‍ ଗାଲି ୱାତିଙ୍ଗ୍‍ ମିର୍‌ ଇନିଦେର୍‌, ନାଣ୍ତ ତେର୍‍ୱେଲ୍‍ ଆନାତ୍‌, ମାରି ଆୟାୱାଜା ଗଟାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ଏ ସୁରିୱାର୍‍ଗିନିକିଦେର୍‍, ମିର୍‌ ଦୁନିଆ ମାରି ବାଦଡ଼୍‍ତି ସିନା ନେସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‍ସିନିଦେର୍‍, ମାତର୍‌ ଇୟା ଦିନ୍‍ତି ସିନେଙ୍ଗ୍‍ ୱିଜୁ ଏଣ୍ତେସ୍‌ ନେସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‍ଇଜିନିଦେର୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","ମାରି, ନିଜେନିଜେ ଏନ୍ଦା ଆମାକା ନେଗିକା ବିସାର୍‌ କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ଇଜିନିଦେର୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ଜଦି ମିର୍‌ ମି ବିରଦ୍‌ ଲୋକ୍‍ତିୱାଲେ ନ୍ୟାୟ୍‌ କିନିବାଡିଦୁ ସଲ୍‍ସିନିଦେର୍‍, ଆରିଙ୍ଗ୍‌ ସାରିଦୁ ୱାନିୱାଲେ ବୁଜାଜିସାଦେଙ୍ଗ୍‍ ସେସ୍ଟା କିଦୁ । ଆକା ଆଏତିଙ୍ଗ୍‍ ୱାନ୍‌ ନିଙ୍ଗିଁ ବିସାର୍‌ କିନି ଲୋକା ଆଗ୍‌ଡ଼ି ରେନା ଅନାନ୍‍, ନ୍ୟାୟ୍‌ କିନିକାନ୍‍ ମିଙ୍ଗିଁ ପେରିଲୋକାକିଦୁ ସର୍‍ପେ କିନାସିନାନ୍‌, ମାରି ପେରିକାର୍‌ ମିଙ୍ଗିଁ ଜଇଲ୍‍ତୁ ତର୍‍ନା ଇଡ୍‍ନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ଆମାସାନ୍ଦି ମିର୍‌ ୱିଜୁ ରୁଣୁ ଡାବୁଙ୍ଗୁଁ ଡ଼େସିସିଇ ମାନିଦେର୍‌, ଆୟା ସାନ୍ଦି ମିର୍‌ ଆବେଟ୍‌କୁ ସହସ ୱାଦେଙ୍ଗ୍‌ ଆଟ୍‍ଇଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ନାସ୍ତିୱାଲେ ଆବେ ମାର୍‍ଇ ଏସୋ ଲୋକୁ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାର୍‌ଜେ, ଗାଲିଲିଦିକାର୍‍ ମାପୁରୁମାନୁ ପୁଜାସିନି ୱାଲେ ପିଲାତ୍‌ ୱାରିଙ୍ଗ୍‌ ଡାକ୍‍ତା ମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ଆବେଟ୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମିର୍‌ ଇନିକା ଅଡ଼୍‍ବିଜିନିଦେର୍‍ ଜେ ଇୟା ଲୋକୁ ଗାଲିଲିଦି ୱିଜେରିଙ୍ଗ୍‍ ନାଣ୍ତ ପାପି ମାର୍ହାର୍‍ ଇଜି ୱାରିଙ୍ଗ୍‌ ମିର୍‌ ଅଡ଼୍‍ବିଜିନିଦେର୍‍ ନୋ ? ");
INSERT INTO kfcp_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ସିଲେ, ମାତର୍‌ ପାପ୍‌ତାନ୍‌ ମନ୍‍ତିଙ୍ଗ୍‍ ଡ଼େପ୍‍ଇତିଙ୍ଗ୍‍ ମିର୍‌ ୱିଜେରେ ଆୟାୱାଜା ନାସ୍ଟୁ ଆନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ବା ସିଲୋହଦୁ ଆୟା ଆମା ଅଟ୍ର ଲୋକା ମୁସ୍‌କୁ କାପ୍‍କିନି ଇଲୁ ଆର୍‍ଜି ୱାରି ଜିବନ୍‌ ସର୍‌ଆତ୍‌, ୱାରି ବିସୟ୍‌ତାନ୍‌ ମିର୍‌ ଇନିକା ଅଡ଼୍‍ବିଜିନିଦେର୍‍ ? ୱାର୍‌ ୱିଜେରେ ଜିରୁସାଲାମ୍‍ତିଲୋକା ବାଦ୍‌ଲୁ ନାଣ୍ତ ଦୋସ୍‍କିତିକାର୍‍ ଇଜି ନୋ ମିର୍‌ ଅଡ଼୍‍ବିଜିନିଦେର୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ସିଲେ, ମାତର୍‌ ପାପ୍‌ତାନ୍‌ ମନ୍‍ତିଙ୍ଗ୍‍ ଡ଼େପ୍‍ଏତିଙ୍ଗ୍‍ ମିର୍‌ ୱିଜେରେ ଆୟାୱାଜା ନାସ୍ଟୁ ଆନିଦେର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ମାରି, ଜିସୁ ଇୟା କାତା ୱେର୍‌ତାନ୍‌, “ଅରେନ୍‍ୱାନି ଅଙ୍ଗୁର୍‍ କିଡ଼ିଇ ଉଣ୍ତ୍ରି ତଗା ମାରାନ୍‌ ଉର୍‍ତା ମାର୍ହାର୍‍ । ମାଲିକ୍‌ ୱାଜି ପଲ୍‌ ପ‍ଇତାନ୍‌, ମାତର୍‌ ପୟ୍‍ଏତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ଆବେଟ୍‌ ୱାନ୍‌ ଅଙ୍ଗୁର୍‍ କିଡ଼ିଇ କାପ୍‍କିନିୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ସୁଡ଼ୁଆ, ଇୟା ମୁଣ୍ତ୍ରି ବାର୍‍ସେକ୍‍ ଆତାତ୍‌ ନାନ୍ ୱାଜି ଇୟା ତଗା ମାରାନ୍‌ତୁ ପଲ୍‌ ପୟ୍‍ଜିନା, ମାତର୍‌ ପୟ୍‌ଏଜିନା; ତେନିଙ୍ଗ୍‍ କାତ୍‍ସୋ ପୋକ୍‌ଆ, ଇକା ଇନ୍‍ଦାନିଙ୍ଗ୍‍ ବୁମିଦିଙ୍ଗ୍‌ ବା ତାଗ୍‌ଇକା କିଜିନାତ୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ମାତର୍‌ କାପ୍‍କିନିକାନ୍‍ ମାଲିକ୍‌ତିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ପ୍ରବୁ, ତେନିଙ୍ଗ୍‍ ଇୟା ଉଣ୍ତ୍ରି ବାର୍ସେକ୍‍ ବା ଡ଼ିସ୍‍ସୋସିଆ, ନାନ୍ ଇଲେ ତେନି ସାରିବେଡ଼୍‍ତି କାର୍‍ଜି ଗାତାମ୍‍ ସିନା, ");
INSERT INTO kfcp_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ୱାନି ବାର୍‍ସେକ୍‍ ପଲ୍‌ ଆସ୍‌ତିଙ୍ଗ୍‌ ତୋ ନେଗି ମାଟା, ଆଏତିଙ୍ଗ୍‍ ତାନିଙ୍ଗ୍‌ କାତ୍‍ସପୋକ୍‍ଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ଅର୍‍ଲେନ୍‍ ଜିସୁ ରମ୍‌ନିନାଣ୍ତିଙ୍ଗ୍‌ ଉଣ୍ତ୍ରି ପାର୍‌ତନା ଇଲୁଦୁ ସିକିୟା ସିଜିମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ମାରି ସୁଡ଼ୁଦୁ, ଅଟ୍ର ବାର୍ସେକ୍‍ ଆତାତ୍‌ ଉନ୍‍ଣ୍ତ୍ରି ତାଗ୍‍ଇଆତ୍ମା ଆସ୍‌ସି ଅରେତ୍‌ ଆଇମାଦିଙ୍ଗ୍‍ ସାକିସିଲିୱାଜା କିତାମାର୍‍ଆତ୍‍, ୱାଦ୍‌ କୁବ୍‍ଡ଼ି ଆଜି ଏଣ୍ତେସ୍‌ବା ନିଜେଦିଙ୍ଗ୍‍ ସିଦା କିଜି ବୁଲାଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏଜିମାର୍ହାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ଜିସୁ ତାନିଙ୍ଗ୍‌ ସୁଡ଼ୁଜି ଲାକ୍‌ତୁ କୁକ୍‌ସି ଇର୍‌ଆନ୍‌, ଏ ଆଇମା, ନି ରୋଗ୍‍ଜିବନ୍‍ତାନ୍‌ ନେଗେଣ୍ତ୍‍ ଆତି । ");
INSERT INTO kfcp_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ମାରି, ୱାନ୍‌ ତାନି ମୁସ୍‌କୁ କିୟୁ ଇଟ୍‌ତାନ୍‌, ଆବେଟ୍‌ ୱାଦ୍‌ ଆୟାଦାପ୍ରେ ସାଡ଼୍‌କୁ ଆଜି ମାପୁରୁଦି ଦନ୍ୟବାଦ୍‌ କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ମାତର୍‌ ଜିସୁ ରମ୍‌ନିନାଣ୍ତିଙ୍ଗ୍‌ ନେଗେଣ୍ତ୍‌ କିତାନ୍‍ଆକା ପାର୍‌ତନା ଇଲୁଦି ପେରିକାନ୍‌ ରିସା ଆଜି ଲୋକାଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ପାଣି କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ସଅଦିନ୍‍ ମାନାତ୍‌, ଆଦେଙ୍ଗ୍‌ ଆୟାୱିଜୁ ଦିନ୍‌ ୱାଜି ନେଗେଣ୍ତ୍‍ ଆଦୁ, ରମ୍‌ନିନାଣ୍ତିଙ୍ଗ୍‌ ରାମାଟ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ମାତର୍‌ ପ୍ରବୁ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ରେ କପଟିର୍‍, ମିର୍‌ ୱିଜେରେ ଇନିକା ରମ୍‌ନିନାଣ୍ତିଙ୍ଗ୍‌ ନିଜେ ନିଜେଦି ଡ଼ାନ୍‍ ମାରି ଗଦ ସାଡ଼ାଦାନ୍‍ କୁତ୍‌ସିଅସି ଏରୁ ଉଟ୍‍ପିସ୍‍ କିଇଦେର୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ମାରି ସୁଡ଼ୁଦୁ ଅଟ୍ର ବାର୍‍ସେକ୍‍ ଆତାତ୍‌ ସୟତାନ୍ ମାଣ୍‌କୁ ତରାଜି ଅବ୍ରାହାମତି ଗାଡ଼୍‌ସି ଇୟା ଆଇମାଲୋକ୍‍ ଇନିକା ରମ୍‌ନିନାଣ୍ତିଙ୍ଗ୍‌ ନିଜେଦି ରୋଗ୍‍ତି ଗାଟିଦାନ୍‍ କୁଦାଦେଙ୍ଗ୍‍ ଦର୍‌କାର୍‌ ସିଲେତାତ୍‍ ନୋ ?” ");
INSERT INTO kfcp_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ମାରି, ୱାନ୍‌ ଇୟା ମାଟା ୱିଜୁ ଇର୍ହାନ୍‍ଆକା, ୱାନି ବିରୁଦ୍‍ତିକାର୍‌ ୱିଜେରେ ସେମାର୍‌ ଆତାର୍‌, ମାତର୍‌ ଲୋକୁ ୱିଜେରେ ୱାନି କିତି ୱିଜୁ ପେରି ପାଣି ଉଣ୍ତିଙ୍ଗ୍‌ ୱେଡ଼ିକା କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ଆବେଟ୍‌ ଜିସୁ ଇର୍ହାନ୍‌, “ମାପୁରୁଦି ରାଜି ଆମାତାନି ୱାଜା ? ମାରି, ଆମାତାନିୱାଲେ ନାନ୍ ତାନିଙ୍ଗ୍‌ ତୁସ୍‍ନା ? ");
INSERT INTO kfcp_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ଆକା ଇୟାୱାଜା ଉଣ୍ତ୍ରି ସାର୍‍ସୁ ପାଡ଼ୁ ୱାଜା, ଆମାକା ଅସି ଅରେନ୍‍ ଲୋକୁ ନିଜେଦି ଡଡିଦୁ ୱିତ୍‍ତାନ୍‍, ମାରି ଆକା ପିର୍‌ଜି ମାରାନ୍‌ ଆତାତ୍‌, ବାଦଡ଼୍‌ତି ପଟିଙ୍ଗ୍‌ ୱାଜି ତାନି କମେଆଙ୍ଗ୍‍ଁ ଜାଲୁ ତର୍‌ସି ବାସାନେ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ଜିସୁ ମାରି ୱେର୍‌ତାନ୍‌, “ନା‍ନ୍‌ ଆମାତାନି ୱାଲେ ମାପୁରୁଦି ରାଜିଦିଙ୍ଗ୍‍ ତୁସ୍‍ନା ? ");
INSERT INTO kfcp_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ଆକା କମିର୍‍ତି ୱାଜା, ଅରେତ୍‌ ଆଇମା କମିର୍‌ ଅସି ଆଡା ଅଟାଗୁଣ୍ତାଦି ଲୋଇ ମିସାକିଜି ପିଡ଼ିକ୍‍ସି ଇଟ୍‍ତାତ୍‍, ମାରି ସାରାସାରି କମିର୍‌ ୱିଜୁ ଗୁଣ୍ତାଦିଙ୍ଗ୍‍ ଉଦିସ୍‍କିତାତ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ଇୟା ୱେନ୍‌କା ଜିସୁ ଗାଡ଼୍‌କାଙ୍ଗ୍‌ ଗାଡ଼୍‌କାଙ୍ଗ୍‌ ମାରି ନାର୍‍କାଙ୍ଗ୍‍ଁ ନାର୍‍କାଙ୍ଗ୍‍ଁ ବୁଲାଜି ସିକିୟା ସିବୁ ସିବୁ ଜିରୁସାଲାମ୍‍ ତରିନ୍‌ ସଲ୍‌ସି ମାର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ମାରି, ଅରେନ୍‍ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ପ୍ରବୁ, ରକିୟା ପଇନି ଲୋକାଦି ସଂକିୟା ଇନିକା ଉଣା ?” ଆବେଟ୍‌ ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","ସିପଡ଼ି ସେର୍‍ଲା ସିଜି ଡ଼ୁଗୁଦେଙ୍ଗ୍‍ ତେରେପେତେ ଆଦୁ, ଇରିଙ୍ଗ୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ୱିଜେରେ ଡ଼ୁଗୁଦେଙ୍ଗ୍‍ ଇଜି ବଦା କିନାର୍‌, ମାତର୍‌ ଆଟ୍‍ଏର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ଇଲୁଦି ମାଲିକ୍‌ ନିଙ୍ଗ୍‍ଜି ସେର୍‍ଲା କେର୍‍ତି ୱେନ୍‌କା ଏସ୍ତିୱାଲେ ମିର୍‌ ଆତ୍‌ରେ ନିନି ତେବାନିଦେର୍‍ ମାରି ଏ ପ୍ରବୁ, ମା ଉଣ୍ତିଙ୍ଗ୍‌ ସେର୍‍ଲା ରେଆ, ଇକା ଇଜି ସେର୍‍ଲା ଡାକ୍‌ତେଙ୍ଗ୍‍ଁ ଆସ୍‌ନିଦେର୍‌, ନାସ୍ତିୱାଲେ ୱାନ୍‌ ମିଙ୍ଗିଁ ଇନାନ୍‌, ମିର୍‌ ଏମେ ବାଡ଼ିଦି ଲୋକୁ, ଆକା ନାନ୍ ନେସେଏ । ");
INSERT INTO kfcp_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ଆୟାୱାଲେ ମିର୍‌ ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ନିଦେର୍‌, ମାପ୍‌ ମି ଆଗ୍‌ଡ଼ି ଉଟାପ୍ ତିର୍‍ଆପ୍‍, ମାରି ନିନ୍‌ ମା ଦୁଆର୍‍କାଙ୍ଗ୍‍ ସିକିୟା ସିତି; ");
INSERT INTO kfcp_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ମାରି, ୱାନ୍‌ ମିଙ୍ଗିଁ ଇନାନ୍‌, ମିର୍‌ ଏମେ ବାଡ଼ିଦି ଲୋକୁ, ଆକା ନାନ୍ ନେସେଏ; ଏ ତାଗ୍‍ଇ ପାଣିକିନି ୱିଜେରେ ନା ଲାକ୍‌ତୁରାନ୍‌ ଆକ ଆଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ଏସ୍ତିୱାଲେ ମିର୍‌ ଅବ୍ରାହାମ, ଇସ୍‌ହାକ୍‌, ଜାକୁବ, ମାରି ୱିଜେରେ ବାବବାଦିରିଙ୍ଗ୍ ମାପୁରୁଦି ରାଜିଦୁ ମାନିକା ମାରି ନିଜେ ନିଜେଦିଙ୍ଗ୍‍ ଆତ୍‌ରେ ପୋକ୍‌ନିକା ସୁଡ଼୍‍ନିଦେର୍‍, ନାସ୍ତିୱାଲେ ଆବେ ଆଡ଼୍‌ବାନିଦେର୍‌ ମାରି ପାଲ୍‍କୁ କାତ୍ରେ କିନିଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ମାରି, ୱେଡ଼ାସନି ତରିଟାନ୍‍ ମାରି ୱେଡ଼ାଆର୍‌ନି ତରିଟାନ୍‍, ଡେବିରି ତରିଟାନ୍‍ ମାରି ଉଣେରି ତରିଟାନ୍‍ ଲୋକୁ ୱାଜି ମାପୁରୁଦି ରାଜିଦୁ ଉଣ୍ତେଙ୍ଗ୍‌ ବାସ୍‍ନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ମାରି ସୁଡ଼ୁଦୁ, ଏର୍‌ ଇଲେଇ ୱେନ୍‍କା ମାନାର୍‍ ୱାର୍‌ ଆଗ୍‌ଡ଼ି ଆନାର୍‌ ମାରି ଆଗ୍‌ଡ଼ି ମାନି ଏସୋ ଲୋକୁ ୱେନ୍‌କା ଆନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ନାସ୍ତିୱାଲେ ଏସୋ ପାରୁସିର୍‌ ଜିସୁ ଲାକ୍‌ତୁ ୱାଜି ଇର୍ହାର୍‌, “ଇୟା ବାଡି ଡ଼ିସ୍‌ସି ସହସୋ ସାଙ୍ଗ୍‍ଆ, ଇରିଙ୍ଗ୍‌ ହେରୋଦ ନିଙ୍ଗିଁ କାତ୍‍ତେଙ୍ଗ୍‍ ବଦା କିଜିନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ଆବେଟ୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ମିର୍‌ ସଲ୍‍ସୋ ଆୟା ଗଲୁଦିଙ୍ଗ୍‍ ଇନ୍‍ଡ୍ରୁ, ସୁଡ଼ୁଦୁ, ନାନ୍ ନେର୍‌ ମାରି ୱିଗେରିଙ୍ଗ୍‌ ଲୋକାମାଣ୍‌କୁ ଦୁବେଙ୍ଗ୍‍ ପେର୍‍ଜିନା ମାରି ଲୋକାଙ୍ଗ୍‌ ନେଗେନ୍‌ କିଜିନା, ମିଏରିଙ୍ଗ୍‍ ନା ପାଣି ୱିଜ୍‌ନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ମାତର୍‌ ନାନ୍ ଇୟାୱିଜୁ ପାଣି ନେର୍‌, ୱିଗେରିଙ୍ଗ୍‌ ମାରି ମିଏରିଙ୍ଗ୍‍ ନାଙ୍ଗିଁ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଆନାତ୍‌, ଇରିଙ୍ଗ୍‌ ଜିରୁସାଲାମ୍‍ତି ଆତ୍‌ରେ ବାବବାଦିର୍ ସାନିକା ଟିକ୍‌ ସିଲେ । ");
INSERT INTO kfcp_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“ଏ ଜିରୁସାଲାମ୍‍, ଏ ଜିରୁସାଲାମ୍‍, ନିନ୍‌ ବାବବାଦିରିଙ୍ଗ୍ କାତ୍‍ତିମାନି । ଏମେ ଲୋକାଙ୍ଗ୍‌ ମାପୁରୁ ନି ଲାକ୍‌ତୁ ପୋକ୍‍ତାମାର୍‍ଆନ୍‍, ନିନ୍‌ ୱାନିଙ୍ଗ୍‌ କାଲ୍‍କାଣ୍‍ ଡାକ୍‍ତିମାନି । ନାନ୍ ଏସୋ ଦେବେଙ୍ଗ୍‌ ମି ଲୋକାଙ୍ଗ୍‌ ସାକା କିଦେଙ୍ଗ୍‌ ବଦା କିଜିନା । ଉଣ୍ତ୍ରି ତାଡ଼ି କର୍‍ରୁ ତାନି ରେକା ଆଡ୍‍ଗି କରୁ ପିଲେକାଙ୍ଗ୍‌ ଅର୍‌ସେ ଉଣ୍ତାକିନିୱାଜା ନାନ୍ ମି ଲୋକାଙ୍ଗ୍‌ ଉଣ୍ତା କିଦେଙ୍ଗ୍‌ ବଦାକିତାମାର୍‍ଆ । ମାତର୍‌ ଆକା କିଦେଙ୍ଗ୍‌ ବଦା କିଇତି । ");
INSERT INTO kfcp_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ସୁଡ଼ୁଦୁ, ମି ମନ୍ଦିର୍‌ତିଙ୍ଗ୍‌ ଲୋକୁ ଡ଼ିସ୍‍ତାମାନାର୍‍; ମାରି, ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ପ୍ରବୁଦି ଦର୍‌ତାନ୍‌ ଆମାକାନ୍‍ ୱାଜିନାନ୍‍, ୱାନ୍‌ ଦନ୍ୟ, ମିର୍‌ ଆମା ନାଣ୍ଡିଙ୍ଗ୍ ଇୟା ମାଟା ଇନିଦେର୍‌, ଆୟା ଦିନ୍‌ ୱାନି ସାନ୍ଦି ନାଙ୍ଗିଁ ମାରି ସୁଡ଼ୁଦେଙ୍ଗ୍‌ ଆଟ୍‍ଇଦେର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ଅର୍‍ଲେନ୍‍ ଜିସୁ ରମ୍‌ନିନାଣ୍ତିଙ୍ଗ୍‌ ଉଣ୍ତେଙ୍ଗ୍‌ ପାରୁସିର୍‌ ଅରେନ୍‍ ପେରିୱାନ୍‍ଦି ଇଲ୍‌ତୁ ସର୍‌ଆନ୍‌, ମାରି ଲୋକୁ ୱାନିଙ୍ଗ୍‌ ସୁଡ଼ୁଜି ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ମାରି ସୁଡ଼ୁଦୁ, ୱାନି ଆଗ୍‌ଡ଼ି ଅରେନ୍‍ କିକୁ ନି କାଲ୍‌କୁ ୱାସ୍‍ସି ରୋଗ୍‌ ଆସ୍‌ତିମାର୍‌ଇ ଲୋକୁ ମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ଆବେଟ୍‌ ଜିସୁ ବାଇବଲ୍‍ତି ସାସ୍ତ୍ରିରିଙ୍ଗ୍‍ ମାରି ପାରୁସିରିଙ୍ଗ୍‍ ଇର୍‌ଆନ୍‌, “ରମ୍‌ନିନାଣ୍ତିଙ୍ଗ୍‌ ରୋଗ୍‌ତାନ୍‌ ନେଗେଣ୍ତ୍‌ କିନି ନିୟମ୍‌ ନୋ ସିଲେ ? ମାତର୍‌ ୱାର୍‌ ଆଲେତା ମାର୍‌ଆର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ମାରି, ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ଆସ୍‌ସି ନେଗେଣ୍ତ୍‍ କିତାନ୍‌ ମାରି ୱାନିଙ୍ଗ୍‌ ୱାନି ଇନ୍‌ଡ୍ର ପୋକ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ମାରି, ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ମି ଲୋଇ ଏନ୍‌ ନିଜେଦି ମାରିନ୍‌ ବା ଡ଼ାନ୍‍ କୁଇଁଦୁ ଆର୍‌ତିଙ୍ଗ୍‌ ଇନିକା ୱାନିଙ୍ଗ୍‌ ରମ୍‌ନିନାଣ୍ତିଙ୍ଗ୍‌ ଆୟାଦାପ୍ରେ ନିକ୍‍ଏନ୍‍ ନୋ ?” ");
INSERT INTO kfcp_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ମାରି, ୱାର୍‌ ଇୟାୱିଜୁ ମାଟାଦି ଇନି ଉତର୍‌ ସିଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ମାରି, ଜିସୁ ସୁଡ଼ୁତାନ୍‌ ଜେ ଏସୋ କୁଡ଼ାଙ୍ଗ୍‌ ବାସ୍‌ତେଙ୍ଗ୍‌ ଇଜି ପେରି ପେରି ବାଡିଙ୍ଗ୍‍ ପୋୟଜି ମାର୍‌ଆର୍‌ । ଆଦେଙ୍ଗ୍‌ ଜିସୁ ଇୟା କାତା ୱେର୍‌ତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","ଏସ୍ତିୱାଲେ ମିଙ୍ଗିଁ ଅରେନ୍‍ ପେଡ଼ି ବଜିଦୁ ଉଣ୍ତେଙ୍ଗ୍‌ କୁକ୍‍ନାନ୍‍, ନାସ୍ତିୱାଲେ ପେରିବାଡିଦୁ ବାସ୍‍ମାଟ୍‍, ଆନାତ୍‌ ୱାନ୍‌ ମିବାଣ୍‍କାଣ୍‍ ପେରି ପେରି ଲୋକାଙ୍ଗ୍‌ କୁକ୍‍ନା ମାନାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ମାରି ଏନ୍‌ ମିଙ୍ଗିଁ ନି ଆଇୱାନିଙ୍ଗ୍‍ କୁକ୍‍ନା ମାନାନ୍‌, ୱାନ୍‌ ୱାନା ମିଙ୍ଗିଁ ୱେର୍‌ନାର୍‌, ୱେନିଙ୍ଗ୍‌ ବାଡି ସିଆ; ମାରି, ନାସ୍ତିୱାଲେ ମିର୍‌ ସେମାର୍‍ଆଜି ଆଡ୍‍ଗିରି ବାଡିଦୁ ବାସ୍‍ନିଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ମାତର୍‌ ଏସ୍ତିୱାଲେ ଅରେନ୍‍ ମିଙ୍ଗିଁ କୁକ୍‍ନାନ୍‍, ନାସ୍ତିୱାଲେ ମିର୍‌ ସଲ୍‌ସି ଆଡ୍‍ଗିରି ବାଡିଦୁ ବାସ୍‍ତୁ, ଏଣ୍ତେସ୍‌ ମିଙ୍ଗିଁ କୁକ୍‍ତିକାନ୍‍ ୱାଜି ମିଙ୍ଗିଁ ଇନାନ୍‌, ଏ ତଡ଼ାନ୍‌, ମୁସ୍‌କୁରି ବାଡିଦୁ ରାଆ; ନାସ୍ତିୱାଲେ ମିୱାଲେ ବାସ୍‍ସିମାନି ୱିଜେରି ଲୋକାୱାଲେ ଆଗ୍‌ଡ଼ି ମିର୍‌ ସମ୍ମାନ୍‍ ପୟନିଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ଇରିଙ୍ଗ୍‌ ଏନ୍‌ ନିଜେଦିଙ୍ଗ୍‍ ପେରିକାନ୍‌ ତର୍‍ନାନ୍‍, ୱାନିଙ୍ଗ୍‌ ଆଡ୍‍ଗି କିନାନ୍‌, ମାରି ଏନ୍‌ ନିଜେଦିଙ୍ଗ୍‍ ଇସ୍ରିକାନ୍‌ କିନାନ୍‌, ୱାନିଙ୍ଗ୍‌ ପେରିକାନ୍‌ କିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ମାରି, ୱାନ୍‌ କୁକ୍‍ତି ମାର୍‍ଇ ଲୋକାଙ୍ଗ୍‌ ବା ଇର୍‌ଆନ୍‌, “ୱେଡ଼େ ବା ନାଡ଼ା ବୋଜି ସିତିଙ୍ଗ୍‌ ମି ତଡ଼୍‍ କି ଦାଦା କି ନିଜେଦି ଲୋକାଙ୍ଗ୍‌ କି ମାଜନ୍‍ତି ମି ଲାକ୍‌ତୁରି ଲୋକାଙ୍ଗ୍‌ କୁକ୍‍ମାଟ୍‍, ଏସ୍ତିୱାଲେ ୱାନ୍‌ ବା ମିଙ୍ଗିଁ ଡ଼େସି କୁକ୍‍ନାର୍‍ ମାରି ଡ଼େପ୍‍ନାସିନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ମାତର୍‌ ବୋଜି କିତିଙ୍ଗ୍‌ କାକୁର୍ତି ଲୋକାଙ୍ଗ୍‌, ଇରାଜିବୁଲାନିୱାରିଙ୍ଗ୍‍, ସଟାରିଙ୍ଗ୍‍ ମାରି କାଣା ଲୋକାଙ୍ଗ୍‌ କୁକ୍‍ତୁ; ");
INSERT INTO kfcp_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ଆତିଙ୍ଗ୍‌ ମିର୍‌ ଦନ୍ୟ ଆନିଦେର୍‌, ଇରିଙ୍ଗ୍‌ ମିଙ୍ଗିଁ ଡ଼େସି ସିଦେଙ୍ଗ୍‍ ଇଜି ତାମେମାନୁ ଇନିକା ସିଲେତ୍‍; ମାରି, ଦାର୍ମୁ ଲୋକୁ ମାରିଡ଼େସି ନିଙ୍ଗ୍‍ନିୱାଲେ ମିଙ୍ଗିଁ ପୁରସ୍କାର୍‍ ପୁଟ୍‍ନାତ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ଆକା ୱେନ୍‌ଜି ଜିସୁୱାଲେ ଉଣ୍ତେଙ୍ଗ୍‌ ବାସ୍‍ତି ମାର୍‍ରି ଲୋକା ଲୋଇ ଅରେନ୍‍ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଆମା ଲୋକୁ ମାପୁରୁଦି ରାଜିଦୁ ଉଣ୍ତେଙ୍ଗ୍‌ ବାସ୍‍ନାନ୍‍, ୱାନ୍‌ ଦନ୍ୟ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ମାତର୍‌ ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ଅରେନ୍‍ ଲୋକୁ ଉଣ୍ତ୍ରି ପେରି ବୋଜି ସିଦେଙ୍ଗ୍‍ ବଦାକିଜି ନାଣ୍ତ ଲୋକାଙ୍ଗ୍‌ କୁକିସ୍‍ତାନ୍‍; ");
INSERT INTO kfcp_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ମାରି, ବୋଜି ଉଣି ସମୟ ଇଗା ୱାତାତ୍‍ଆକା, କୁକ୍‍ତି ମାର୍‍ଇ ଲୋକାମାନୁ ୱାନି ପାଣିକିନି ୱାନି ପୋକ୍‌ସି କୁକ୍‍ସୋ ତାତେଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ଇରିଙ୍ଗ୍‌ ବୋଜିୱିଜୁ ୱାର୍ତା ୱିସ୍‍ତାମାର୍‍ଆର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ମାତର୍‌ ୱିଜେରେ ଅର୍‌ସେ ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ । ପାର୍‌ତୁମ୍‌ ଅରେନ୍‍ ଇର୍‌ଆନ୍‌, ନାନ୍ କାଣ୍ତେକ୍‍ ବୁମି କଟାମାନା, ଆକା ନାଙ୍ଗିଁ ସୁଡ଼ୁନିକା ମାନାତ୍‌; ନାନ୍ ମାଡ଼ିସ୍‌ କିଜିନା, ନିନ୍‌ ନାଙ୍ଗିଁ ଡ଼ିସ୍‍ସିତିମାନି ଇଜି ଅଡ଼୍‌ବିଜିନା । ");
INSERT INTO kfcp_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ମାରି ଅରେନ୍‍ ଇର୍‌ଆନ୍‌, ନାନ୍ ପାସ୍‌ଗୋଟା ସେର୍‍କୁ ଡ଼ାକ୍‍ କୋଟାମାନା, ମାରି ନାନ୍ ୱାନିକାଙ୍ଗ୍‌ ମିତେଙ୍ଗ୍‌ ସଲ୍‍ସିନା; ମାଡ଼ିସ୍‌ କିଜିନା, ନିନ୍‌ ନାଙ୍ଗିଁ ଡ଼ିସ୍‍ସିତିମାନି ଇଜି ଅଡ଼୍‌ବିଜିନା । ");
INSERT INTO kfcp_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ମାରି ଆଇକାନ୍‍ ଇର୍‌ଆନ୍‌, ନାନ୍ ପୁନା ପେଡ଼ି ଆତାମାନା, ଆଦେଙ୍ଗ୍‌ ୱାଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏ । ");
INSERT INTO kfcp_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","ମାରି, ଆୟା ଗତିମୁରୁଲି ୱାଜି ୱାନି ମାଲିକ୍‌ତିଙ୍ଗ୍‌ ଆୟାୱିଜୁ ଇର୍‌ଆନ୍‌, ଆବେଟ୍‌ ଆୟା ଇଲୁଦି ମାଲିକ୍‌ ରିସା ଆତାନୋ ୱାନି ଗତିମୁରୁଲିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ବେଗି ଗାଡ଼ାକା ଦୁଆର୍‍କାଙ୍ଗ୍‍ ମାରି ସାକ୍‌ଡ଼ି ସାକ୍‌ଡ଼ି ସଲ୍‌ସି କାକୁର୍ତି ଲୋକାଙ୍ଗ୍‌, ଇରାଜିବୁଲାନିୱାରିଙ୍ଗ୍‍, କାଣାରିଙ୍ଗ୍‌ ମାରି ସଟାରିଙ୍ଗ୍‍ ଇବେ କୁକ୍‍ସୋ ତାଗା । ");
INSERT INTO kfcp_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ୱେନ୍‌କା ଆୟା ଗତିମୁରୁଲି ଇର୍‌ଆନ୍‌, ଏ ମାଲିକ୍‌, ନି ବଦାଦାନ୍ କିତାମାନା, ମାତର୍‌ ମାରି ବାଡି ମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ଆବେଟ୍‌ ମାଲିକ୍‌ ଆୟା ସାକର୍‌ତିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ପେରି ଦୁଆର୍‍କାଙ୍ଗ୍‍ ମାରି କନା ମୁଲାଦୁ ସଲ୍‌ସି, ନା ଇଲ୍‌ତୁ ଲୋକୁ ଏଣ୍ତେସ୍‌ ବର୍ତି ଆନାର୍‌, ଆୟା ଉଣ୍ତିଙ୍ଗ୍‌ ଲୋକୁ ୱାଦେଙ୍ଗ୍‌ ଇନ୍‍ଡ୍ରୁ । ");
INSERT INTO kfcp_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ଏଣ୍ତେସ୍‌ ମିଙ୍ଗିଁ ନାନ୍ ଇଜିନା, ଆୟା କୁକ୍‍ତିମାର୍‍ଇ ଲୋକା ଲୋଇ ଏର୍‍ବା ନାନ୍ ବୋଜି କିତିମାନୁ ଉଣ୍ତେଙ୍ଗ୍‌ ଆଟ୍‍ଏର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ଅର୍‍ଲେନ୍‍ ନାଣ୍ତ ଲୋକୁ ଜିସୁୱାଲେ ସଲ୍‍ସିମାର୍‍ଆର୍‍, ମାରି ୱାନ୍‌ ୱେନ୍‌କା ମାର୍‌ଜିବେସ୍‌ସି ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","ଜଦି ଅରେନ୍‍ ଲୋକୁ ନା ଲାକ୍‌ତୁ ୱାଜି, ମାତର୍‌ ୱାନ୍‌ ଜଦି ନାଙ୍ଗିଁ ଡ଼ିସ୍‌ସି ନିଜେଦି ବୁବା ୟାୟାଏଙ୍ଗ୍‍, ଆଡ଼ିସିଙ୍ଗ୍‍, କଡ଼ରିଙ୍ଗ୍‌, ତାଙ୍ଗିଁ ତଡ଼ାନ୍‍କାଙ୍ଗ୍‍ ମାରି ଏଣ୍ତେସ୍‌ ନିଜେଦି ଜିବନ୍‌ତିଙ୍ଗ୍‌ ବା ନାଣ୍ତ ଜିବନ୍‍ନୋନାନ୍‍, ୱାନ୍‌ ନା ସିସୁ ଆଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ଏନ୍‌ ଜଦି ନିଜେଦି କ୍ରୁସ ପିଣ୍ତ୍‍ଜି ନା ୱେନ୍‌କା ରେଏନ୍‌, ୱାନ୍‌ ନା ସିସୁ ଆଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ଇରିଙ୍ଗ୍‌ ମି ଲୋଇ ଏନ୍‌ କାପ୍‍କିନି ଇଲୁ ତିଆର୍‌ କିଦେଙ୍ଗ୍‌ ବଦାକିଜି ଆକା ୱିସ୍‍ତେଙ୍ଗ୍‍ ଇଜି ୱାନିମାନୁ ଡାବୁଙ୍ଗୁଁ ମାନେ ନୋ ସିଲୁ, ଇକା ପାର୍‌ତୁମ୍‌ ବାସ୍‌ସ ଏସୋ ଡାବୁଙ୍ଗୁଁ ତାକ୍‍ନେ ଲେକିସ୍‌ କିଏନ୍‌ ନୋ ? ");
INSERT INTO kfcp_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ଆନାତ୍‌ ୱାନ୍‌ କୁନାଦି ପୋକ୍‌ସି ୱିସ୍‍ତେଙ୍ଗ୍‍ ଜଦି ଆଟ୍‍ଏନ୍‍, ଲୋକୁ ଆକା ସୁଣାର୍‍, ୱିଜେରେ ୱାନିଙ୍ଗ୍‌ ସେମାର୍‍ କିଜି ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ନାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ଇୟାକାନ୍‌ ତିଆର୍‌ କିଦେଙ୍ଗ୍‌ ଆରାମ୍‍ କିଜି ମାତର୍‌ ୱିସ୍‍ତେଙ୍ଗ୍‍ ଆଟ୍‍ଏତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","ମାରି ଏମେ ରାଜା ଆଇ ଅରେନ୍‍ ରାଜାୱାଲେ ଜୁଦ୍‍ କିଦେଙ୍ଗ୍‌ ସନିୱାଲେ, ଦାସ୍‌ ହାଜାର୍‌ ସନ୍ୟରିଙ୍ଗ୍‍ ଆସ୍‌ସି, ୱାନି ବିରଦ୍‌ତାନ୍‌ ୱାଜିମାନି କଡ଼େ ହାଜାର୍‌ ସନ୍ୟରିଙ୍ଗ୍‍ ଅସି ଜୁଦ୍‍ କିଦେଙ୍ଗ୍‌ ୱାଜିମାନି ରାଜାୱାଲେ ଜୁଦ୍‍ କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାନ୍‍ ନୋ ଆଟ୍‍ଏନ୍‍, ଆକା ଆଗ୍‍ଡ଼ିନେ ଅଡ଼୍‍ବିଏନ୍‍ ନୋ ? ");
INSERT INTO kfcp_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ଜଦି ଆଟ୍‍ଏନ୍‍, ଆଇ ରାଜା ଆକ ମାନ୍‌ବୁନେ ୱାନ୍‌ ୱାନି ଲୋକାଙ୍ଗ୍‌ ପୋକ୍‌ସି ଆୟା ରାଜାୱାଲେ ସାନ୍ତି କିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ଆୟାୱାଜା ମି ଲୋଇ ଏନ୍‌ ଜଦି ନିଜେଦି ୱିଜୁ ଡ଼ିସ୍‍ଏନ୍‍, ୱାନ୍‌ ନା ସିସୁ ଆଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","ସର୍‍ ତୋ ନେଗିକା; ମାତର୍‌ ସର୍‍ ଜଦି ତାନି କାରିୟା ଆନିକା ସିଲେତ୍‍ଆନାତ୍‍, ଆରିଙ୍ଗ୍‌ ଆକା ଆମାନ୍‍ ବା କାରିୟା କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ତେନିଙ୍ଗ୍‍ ମିର୍‌ ଇୟାୱାଜା ବୁମିଦି ଉଣ୍ତିଙ୍ଗ୍‌ ବା ଗାତାମ୍‍ କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ଇଦେର୍‍ । ଲୋକୁ ଆକା ଆତ୍‌ରେ ପୋକ୍‌ନାର୍‌ । ଆମାୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଗିତଣିଙ୍ଗ୍‍ମାନେ, ୱାନ୍‌ ୱେନିନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ଅର୍‍ଲେନ୍‍, ସିସ୍‍ଟୁ ଲୋସ୍‌ନିକାର୍‌ ନି ପାପି ଲୋକୁ ୱିଜେରେ ଜିସୁଦି ବାକ୍ୟ ୱେନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ୱାନି ଲାକ୍‌ତୁ ୱାଜି ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ଆବେଟ୍‌ ପାରୁସିର୍‌ ନି ସାସ୍ତ୍ରିର୍‍ ୱିଜେରେ ବାସେ କିଜି କିଜି ଇର୍ହାର୍‌, ଇକାନ୍‌ ପାପି ଲୋକାଙ୍ଗ୍‌ ୱାନିଲାକ୍‍ତୁ କୁକ୍‍ନାନ୍‍ ମାରି ୱାରିୱାଲେ ଉଣାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ଆବେଟ୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇୟା କାତା ଇର୍‌ଆନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“ମି ମାଣ୍‌କୁ ଇୟାୱାଜା ଏମେ ଲୋକୁ ମାନାନ୍‌ ଜେ, ୱାନିଦି ଜଦି ୧୦୦ ଗୋଟା ମେଣ୍ତେଙ୍ଗ୍‌ମାନେ, ମାରି ତାମେ ଲୋଇ ଉଣ୍ତ୍ରି ମୁର୍‍ନାତ୍‍, ମାରି ୱାନ୍‌ ନବେ ନୋଗୋଟା ମେଣ୍ତେଙ୍ଗ୍‍ ଗରନ୍‌ତୁ ଡ଼ିସ୍‌ସି ଆୟା ମୁରୁତିମାନି ମେଣ୍ତା ପୋୟଇ ସାନ୍ଦି ତାନିଙ୍ଗ୍‌ ପୟ୍‌ଏନ୍‌ ନୋ ? ");
INSERT INTO kfcp_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ମାରି, ୱାନ୍‌ ମେଣ୍ତାଦିଙ୍ଗ୍‌ ପ‍ଇତିଙ୍ଗ୍‌ ୱାନ୍‌ ତାନିଙ୍ଗ୍‌ ୱେଡ଼ିକାଦାନ୍‌ ଗୁଜାମ୍‍ତୁ ପିଣ୍ତିଜି ଇନ୍‌ଡ୍ର ତାନାନ୍‍, ");
INSERT INTO kfcp_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ମାରି, ନିଜେଦି ଲୋକାଙ୍ଗ୍‌ ମାରି ପାଡ଼୍‍କାଦି ଲୋକାଙ୍ଗ୍‌ କୁକ୍‌ସି ଉଣ୍ତ୍ରେମାନୁ କିଜି ୱାରିଙ୍ଗ୍‌ ୱେର୍‌ନାନ୍‌, ନା ୱାଲେ ୱେଡ଼ିକା କିଦୁ, ଇରିଙ୍ଗ୍‌ ନା ମୁରୁତିମାର୍‍ଇ ମେଣ୍ତା ପୁଟ୍‍ତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ନାନ୍ ମିଙ୍ଗିଁ ୱେର୍‌ସିନା, ଆୟାୱାଜାନେ ଏମେଲୋକାଦି ମନତିଙ୍ଗ୍‌ ଡ଼େପ୍‍ତେଙ୍ଗ୍‍ ଦର୍‌କାର୍‍ ସିଲେ, ଇୟାୱାଜା ନବେ ନୋଗୋଟା ଦାର୍ମୁ ଲୋକା ବାଦ୍‌ଲୁ, ଜେ ମନତିଙ୍ଗ୍‌ ଡ଼େପ୍‍ନାନ୍‍, ଇୟାୱାଜା ଅରେନ୍‍ ପାପି ଲୋକ୍‍ ଉଣ୍ତିଙ୍ଗ୍‌ ମୁସ୍‌କୁପୁର୍‌ତୁ ନାଣ୍ତ ୱେଡ଼ିକା ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“ଇୟାୱାଜା ଏମେ ଆଇମା ଲୋକୁ ମାନାତ୍‌ ଜେ, ତାନିଦି ଜଦି ଦଶଗୋଟା ୱେଣ୍ତି ଅଦ୍‌ଲିଙ୍ଗ୍‍ମାନେ, ମାରି ଆବେଟ୍‍ ଉଣ୍ତ୍ରି ମୁରୁନାତ୍‌, ମାରି ୱାଦ୍‌ ଦିୱା କାସ୍‍ସିସ୍‍ କିଜ ଇଲୁଦୁ ସିପାଜି ଆକା ପୟ୍‌ଇ ସାନ୍ଧି ନେଗେନ୍‌ତାନ୍‌ ପୟ୍‍ଏତ୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ମାରି, ଆକା ପ‍ଇତିଙ୍ଗ୍‌ ୱାନ୍‌ ନିଜେଦି ଲୋକାଙ୍ଗ୍‌ ମାରି ପାଡ଼୍‍କାଦି ଲୋକାଙ୍ଗ୍‌ କୁକ୍‌ସି ଉଣ୍ତ୍ରେମାନୁ କିଜି ୱାରିଙ୍ଗ୍‌ ୱେର୍‌ନାନ୍‌, ନା ୱାଲେ ୱେଡ଼ିକା କିଦୁ, ଏମେ ୱେଣ୍ତି ଅଦ୍‌ଲି ମୁରୁତିମାର୍‌ଇକା, ଆକା ପୁଟ୍‍ତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ନାନ୍ ମିଙ୍ଗିଁ ୱେର୍‌ସିନା, ଇୟାୱାଜାନେ ଏନ୍‌ ମନତିଙ୍ଗ୍‌ ଡ଼େପ୍‍ତିଙ୍ଗ୍‍, ଇୟାୱାଜା ଅରେନ୍‍ ପାପି ଉଣ୍ତିଙ୍ଗ୍‌ ମାପୁରୁଦି ଦୁତ୍‌କୁ ୱେଡ଼ିକାକିନେ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ଜିସୁ ମାରି ଇର୍ହାନ୍‌, ଅରେନ୍‍ ଲୋକୁଦିଙ୍ଗ୍‍ ରିଏର୍‌ କଡ଼ର୍‌ ମାର୍‌ଆର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ୱାରି ମାଣ୍‌କୁ ଇସ୍ରିରି ମାରିନ୍‌ ବୁବେଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ବୁବା, ସମ୍ପତିଦି ଏମେ ବାଗ୍ ନା ବାଗତୁ ପୋଡ଼ାଜିନାତ୍‌, ଆକା ନାଙ୍ଗିଁ ସିଦାଟ୍‍ । ଆବେଟ୍‌ ୱାନ୍‌ ନିଜେଦି ୱିଜୁ ୱାରିଙ୍ଗ୍‌ ବାଟା କିଜି ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ଅଡ଼ପ୍‍ ଦିନ୍‌ ୱେନ୍‌କା ଇସ୍ରିରି କଡ଼ ୱିଜୁ ଉଣ୍ତ୍ରିମାନୁ କିଜି ଆକ ଦେଶ୍‍ତୁ ସର୍ହାନ୍‍, ମାରି ଆବେଣ୍‌କୁ ମୁର୍କୁ ଆଜି ନିଜେଦି ସମ୍ପତ୍ତି ଇପ୍‍ତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ମାତର୍‌ ୱିଜୁ ୱିସ୍‌ତି ୱେନ୍‌କା ଆୟା ଦେସ୍‌ତୁ ପେରି ଦୁର୍ବିକିୟ ଆତାତ୍‌ଆକା ୱାନିଙ୍ଗ୍‌ ସିଲିୱାଜା ଆଦେଙ୍ଗ୍‌ ଆସ୍‌ତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ଆବେଟ୍‌ ୱାନ୍‌ ସଲ୍‌ସି ଆୟା ଦେଶ୍‍ଦି ଅରେନ୍‍ ଲୋକ୍‍ମାନୁ ଗତି ତେବାତାନ୍‌, ମାରି ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ପାଣ୍ତ୍ରିଙ୍ଗ୍‌ ସାରାକିଦେଙ୍ଗ୍‍ ଇଜି ନିଜେଦି କିଡ଼ିଇଦୁ ପୋକ୍‌ତାର୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ମାରି, ପାଣ୍ତ୍ରିଙ୍ଗ୍‌ ଏମେ କାଦି ତିନ୍‍ଜିମାର୍‍ଏ, ଆବେଟ୍‌ ୱାନ୍‌ ନିଜେଦି ପଟାପାଜିସ୍‍ କିଦେଙ୍ଗ୍‌ ବଦା କିଜିମାର୍ହାନ୍‌, ମାତର୍‌ ଏନ୍‌ବା ୱାନିଙ୍ଗ୍‌ ଇନିକାବା ସିଏଜି ମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ମାତର୍‌ ୱାନ୍‌ ଚେତ୍‍ନା ଆଜି ଇର୍ହାନ୍‌, ନା ବୁବାଦି ଏସ କୁଲିକିନିୱାର୍‌ଇଦି ଉଣିକା ତେବାଜିନାତ୍‍, ମାତର୍‌ ନାନ୍ ଇବେନ୍‌ ବାଙ୍ଗାଁଦାନ୍‍ ସାଜିନା । ");
INSERT INTO kfcp_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ନାନ୍ ନିଙ୍ଗ୍‍ଜି ନା ବୁବାଦି ଲାକ୍‌ତୁ ସନା ମାରି ୱାନିଙ୍ଗ୍‌ ୱେର୍‌ନା, ବୁବା, ମାପୁରୁଦି ବିରଦ୍‌ତାନ୍‌ ମାରି ନି ବିରଦ୍‌ତାନ୍‌ ନାନ୍ ପାପ୍‌ କିତାମାନା; ");
INSERT INTO kfcp_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ମି କଡ଼ ଇଜି କୁକ୍‍ନିକା ନାନ୍ ମାରି ଦୋର୍‌ ସିଲେ; ନାଙ୍ଗିଁ ମିବାନୁ ଅରେନ୍‍ କୁଲିକିନି ଲୋକା ୱାଜା ଇଡିଆ । ");
INSERT INTO kfcp_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ଆବେନ୍‌ ୱାନ୍‌ ନିଙ୍ଗ୍‍ଜି ନିଜେଦି ବୁବାଦି ଲାକ୍‌ତୁ ସର୍ହାନ୍‌ । ମାତର୍‌ ୱାନ୍‌ ଆକ ମାନ୍‌ଜି ମାନ୍‌ଜି ୱାନି ବୁବା ୱାନିଙ୍ଗ୍‌ ସୁଡ଼ୁଜି ଲାଡ଼୍‌ଦାନ୍‌ ତେର୍‌ପେତ୍‌ ଆତାନ୍‌ ମାରି ଉରୁକ୍‍ସି ସଲ୍‌ସି ୱାନିଙ୍ଗ୍‌ ପମିତାଆସ୍ତାନ୍‍ ନୋ ଲାଡ଼୍‌ଦାନ୍‌ ନଣ୍ତିତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ମାରିସି ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ବୁବା ମାପୁରୁଦି ବିରଦ୍‌ତାନ୍‌ ମାରି ନି ବିରଦ୍‌ତାନ୍‌ ନାନ୍ ପାପ୍‌ କିତାମାନା, ମି ମାରିନ୍ ଇଜି କୁକ୍‍ତେଙ୍ଗ୍‍ ନାନ୍ ମାରି ଜଗ୍‌ ସିଲେ । ");
INSERT INTO kfcp_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ମାତର୍‌ ବୁବା ନିଜେଦି ସାକର୍‌କାଙ୍ଗ୍‌ ୱେର୍‌ତାନ୍‌, ୱିଜୁମାଣ୍‌କୁ ନେଗି ୱାତି ବେଗି ଆସୋଅରାଦୁ ୱେନିଙ୍ଗ୍‌ ଆର୍‌ସିକିଦୁ, ୱେନି କିୟୁଦୁ ୱେତରି ମାରି ପାଦାମ୍‌କାଙ୍ଗ୍‌ ଜୁତେଙ୍ଗ୍‌ ସିଦୁ, ");
INSERT INTO kfcp_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ମାରି ବାଲ୍‍ସ୍ତି ଜାତୁ ତାସ ଡାକ୍‌ତୁ; ରାଦୁ, ମାଡୁ ବୋଜି କିଜି ୱେଡ଼ିକା କିନାଟ୍‍, ");
INSERT INTO kfcp_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ମାତର୍‌ ନା ଇୟା ମାରିନ୍‌ ସାତା ମାର୍ହାନ୍‌, ମାରିଡ଼େସି ଜିତାନ୍‍; ମୁରିତାମାର୍ହାନ୍‌, ମାରି ପ‍ଇତାନ୍‌ । ଆବେଟ୍‍ ୱାରିଙ୍ଗ୍‌ ୱେଡ଼ିକା କିଦେଙ୍ଗ୍‌ ଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ନାସ୍ତିୱାଲେ ୱାରି ପେରି ମାରିନ୍‌ ଜମିଦୁ ମାର୍ହାନ୍‌ । ୱାନ୍‌ ଏସ୍ତିୱାଲେ ୱାଜି ଇଲୁଦି ଲାକ୍‌ତୁ ୱାତାନ୍‌, ନାସ୍ତିୱାଲେ ବାଜା ମାରି ଗାତ୍‍ନିକା ଆଉଲି ୱେରାନ୍‍, ");
INSERT INTO kfcp_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ସାକର୍‌କାଙ୍ଗ୍‌ ମାଣ୍‌କୁ ଅରେନ୍‍ ଲାକ୍‌ତୁ କୁକ୍‍ତାନ୍‍ ଆୟାୱିଜୁ ଇନିକା ଇଜି ୱେନ୍‍ବାଦେଙ୍ଗ୍‍ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ୱେର୍‌ତାନ୍‌, ମି ତଡ଼ାନ୍‌ ୱାତାମାନାନ୍‍, ମାରି ମି ବୁବା ୱାନିଙ୍ଗ୍‌ ନେଗି ମେନ୍ଦଲ୍‌ତାନ୍‌ ପଇତାନ୍‌ଆକା ବାଲ୍‍ସ୍ତି ଜାତୁ ଡାକ୍‍ତାମାନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ଆବେଟ୍‌ ୱାନ୍‌ ରିସାଆଜି ଲୋଇ ସଣ୍ଡ୍ରେଙ୍ଗ୍‌ ଇଜି ବଦାକିଏତାନ୍‍; ମାତର୍‌ ୱାରି ବୁବା ଆତ୍‌ରେ ୱାଜି ୱାନିଙ୍ଗ୍‌ ନାଣ୍ତ ବୁଜାକିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ମାତର୍‌ ୱାନ୍‌ ବୁବାସିଙ୍ଗ୍‍ ଇର୍‌ଆନ୍‌, ସୁଡୁଆ, ନିସବାର୍ସେକ୍‍ ଆତାତ୍‌ ନାନ୍ ମି ସାକର୍‌ତି ୱାଜା ପାଣିକିଜି ୱାଜିନା, ମାରି ଏସ୍‌କାଙ୍ଗ୍‍ବା ମି ମାଟା ଅମାନ୍ୟ କିଏ, ମାରି ନା ସାଙ୍ଗ୍‍ରି ୱାଲେ ୱେଡ଼ିକା କିଦେଙ୍ଗ୍‌ ନିନ୍‌ ନାଙ୍ଗିଁ ଏସାକାଙ୍ଗ୍‍ବା ଗରିୟାପିଲା ବା ସିଇ; ");
INSERT INTO kfcp_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ମାତର୍‌ ମି ଇୟା ଏମେ ମାରିସି ତାଗ୍‌ଇୱାରି ୱାଲେ ମି ଦନ୍‌ ୱିଜୁ ଉଣୁଜି ୱିସ୍‌ତା ମାନାନ୍‌, ଏସ୍ତିୱାଲେ ୱାନ୍‌ ୱାତାନ୍‌, ନାସ୍ତିୱାଲେ ନିନ୍‌ ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ବାଲ୍‍ସ୍ତି ଜାତୁ ଡାକ୍‌ତାମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ଆବେଟ୍‌ ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ୱେର୍‌ତାନ୍‌, ମାରିନ୍‌, ନିନ୍‍ତୋ ୱିଜୁଦିନ୍‌ ନା ୱାଲେ ମାନି, ମାରି ଆମାକା ୱିଜୁ ନାଦି, ଆୟାୱିଜୁ ନିଦି; ");
INSERT INTO kfcp_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ମାତର୍‌ ଇୟା ଜେ ନି ତଡ଼ାନ୍‌ ସାତାମାର୍‍ଆନ୍‍, ମାରିଡ଼େସି ଜିତାନ୍‍, ମୁରିତାମାର୍ହାନ୍‍, ମାରି ପୁଟ୍‍ତାନ୍‍, ଆୟା ଉଣ୍ତିଙ୍ଗ୍‌ ୱେଡ଼ିକା କିଦେଙ୍ଗ୍‌ ଦର୍‍କାର୍‍ମାର୍ହାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ଜିସୁ ସିସୁରିଙ୍ଗ୍‌ ବା ଇର୍ହାନ୍‌, ଅରେନ୍‍ ମାଜନ୍‌ ଲୋକୁ ମାର୍ହାନ୍‌, ୱାରି ମାନୁ ଅରେନ୍‍ ଗୋତିମୁରୁଲି ମାର୍ହାନ୍‌, ମାରି ୱାନ୍‌ ୱାରି ସମ୍ପତ୍ତି ବୁଡ଼ା କିଜିନାନ୍‍ ଇଜି ଆୟା ବିସୟ୍‌ତାନ୍‌ ୱେନ୍‌ଜି ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ କୁକ୍‍ତାନ୍‍ନୋ ଇର୍ହାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ନାନ୍ ନି ବିସୟ୍‌ତାନ୍‌ ଇକା ଇନି ମାଟା ୱେନ୍‍ଜିନା ? ନି ପାଣିଦି ଇସାବ୍‌ ସିଦା, ମାତର୍‌ ନିନ୍‌ ମାରି ଗୋତିମୁରୁଲି ଆଜି ମାଣ୍ତ୍ରେଙ୍ଗ୍‌ ଆଟ୍‍ଇ । ");
INSERT INTO kfcp_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ଆବେନ୍‌ ଆୟା ଗୋତିମୁରୁଲି ମୋନ୍‌ତୁ ମୋନ୍‌ତୁ ଇର୍ହାନ୍‌, ଇନିକା କିନା ? ନା ମାଲିକ୍‌ ତୋ ନାମାଣ୍‌କୁ ଗୋତିମୁରୁଲିଦି ନା ସାକିରି ଅସି ସୋଲ୍‌ସିନାନ୍‌ । ସିକ୍‌ଲା କାର୍‍ଦେଙ୍ଗ୍‍ ନା ସାକ୍ତି ସିଲେତ୍‌, ଭିକିୟା ଲସ୍‌ତେଙ୍ଗ୍‌ ନାଙ୍ଗିଁ ସେମାର୍‌ ୱାଜିନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ନାନ୍ ଗୋତିମୁରୁଲିଦାନ୍‍ ଡ଼ିସ୍‌ତି ୱେନ୍‌କା ଲୋକୁ ଏଣ୍ତେସ୍‌ ନାଙ୍ଗିଁ ନିଜେ ନିଜେଦି ଇଲ୍‌କାଙ୍ଗ୍‌ କୁକ୍‍ନାର୍‍, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ଇନିକା କିନା, ଆକା ନେସ୍‍ତାନି । ");
INSERT INTO kfcp_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ମାରି, ୱାନ୍‌ ନିଜେଦି ମାଲିକ୍‌ଦି ୱିଜେରିଙ୍ଗ୍‌ ରୁଣୁ ଅତିମାନି ଲୋକାଙ୍ଗ୍‌ ଲାକ୍‌ତୁ କୁକ୍‍ସି ଆଗ୍‍ଡ଼ିରି ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ଇର୍ହାନ୍‌, ନି ମୁସ୍‌କୁ ନା ପ୍ରବୁଦି ମାନୁ ଏସ ଟାକା ସିଦେଙ୍ଗ୍‍ ମାନାତ୍‌ ? ୱାନ୍‌ ଇର୍ହାନ୍‌, ସଏ ଡାବା ନିୟୁ । ");
INSERT INTO kfcp_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ନି ଇସାବ୍‌ କିନି ଆକୁ ବେଗିତାସ୍‍ ବାସ୍‌ସ ପସାସ୍‌ ଡାବା ନିୟୁ ଇଜି ରାସ୍‌ଆଁ । ");
INSERT INTO kfcp_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ତାନେ ୱେନ୍‌କା ୱାନ୍‌ ମାରି ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ଇର୍ହାନ୍‌, ନି ମୁସ୍‌କୁ ଏସ ଡାବୁଙ୍ଗୁଁ ସିଦେଙ୍ଗ୍‍ ମାନାତ୍‌ ? ୱାନ୍‌ ଇର୍ହାନ୍‌, ସଏ ବାସ୍ତା ଗଦ୍‍ମୁ । ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ନି ଇସାବ୍‌ କିନି ଆକୁ ବେଗିତାସ ଅସେ ବାସ୍ତା ଇଜି ରାସ୍‌ଆଁ । ");
INSERT INTO kfcp_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","ଆୟା ଅବିସ୍‌ବାସ୍‌କିତି ଗୋତିମୁରୁଲି ବୁଦିଦି ୱାଲେ ପାଣି କିତିମାନିଙ୍ଗ୍‍ ୱାନି ମାଲିକ୍‌ ୱାନିଙ୍ଗ୍‌ ପ୍ରସଂସା କିତାନ୍‍; ଇୟା ଦୁନିଆ କଡ଼ର୍‍ ୱାରି ପାଣି କିଦେଙ୍ଗ୍‌ ଜାୟ୍‌ତି କଡ଼ରି ବାଦୁଲୁ ନାଣ୍ତ ବୁଦି । ");
INSERT INTO kfcp_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ନାନ୍ ବା ମିଙ୍ଗିଁ ଇଜିନା, “ଦୁନିଆଦି ଦନ୍‍ତୁ ନିଜେ ନିଜେଦି ଉଣ୍ତିଙ୍ଗ୍‌ ସଙ୍ଗ୍‍ ପଇଦୁ, ଏଣ୍ତେସ୍‌ ଆକା ୱିଜ୍‍ତିଙ୍ଗ୍‍ ମିଙ୍ଗିଁ ୱିଜୁଦିନ୍‌ତି ଡର୍‌ନିବାଡିଦୁ କୁକ୍‌ନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ଏନ୍‌ ଉଣା ବିସୟ୍‌ତାନ୍‌ ବିସ୍‌ବାସ୍‌ କିନାନ୍‌, ୱାନ୍‌ ନାଣ୍ତ ବିସୟତୁ ବା ବିସ୍‌ବାସ୍‌ ମାନାନ୍‌, ମାରି ଏନ୍‌ ଉଣା ବିସୟ୍‌ତାନ୍‌ ଅବିସ୍‍ବାସ୍‍ ୱାନ୍‌ ନାଣ୍ତ ବିସୟତୁ ବା ଅବିସ୍‍ବାସ୍‍ କିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ମାରି, ମିର୍‌ ଜଦି ଦୁନିଆଦି ଦନ୍‍ତୁ ବିସ୍‌ବାସ୍‌ କିଇଦେର୍‌, ଆଦେଙ୍ଗ୍‌ ଏନ୍‌ ମିଙ୍ଗିଁ ବିସ୍‌ବାସ୍‌ କିଜି ସତ୍‌ ଦନ୍‍ ମି କିୟୁଦୁ ସପ୍ରେ କିନାନ୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ମାରି, ଜଦି ମିର୍‌ ଆଇୱାନି ଦନ୍‍ ବିସୟତାନ୍ ବିସ୍‌ବାସ୍‌ କିଇଦେର୍‌, ମାରି ଏନ୍‌ ମିଙ୍ଗିଁ ମି ନିଜେଦି ବିସୟ ସିନାନ୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“ଅରେନ୍‍ ସାକର୍‌ ରିଏରି ମାଲିକ୍‌କା ସାକର୍‌ ଆଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏନ୍‍; ମାତର୍‌ ୱାନ୍‌ ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ କାଡ଼୍‍ନାନ୍‍ ମାରି ଆଇୱାନିଙ୍ଗ୍‍ ଜିବନ୍‌ନୋନା, ମାରି ଅରେନ୍‍ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ଲାକ୍‌ତୁ କିନାନ୍‍ ମାରି ଆଇୱାନିଙ୍ଗ୍‍ ଡ଼ିସ୍‍ନାନ୍‍ । ମିର୍‌ ମାପୁରୁ ମାରି ଦନ ରିଏରି ସାକର୍‌ ଆଦେଙ୍ଗ୍‌ ଆଟ୍‍ଇଦେର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ଇୟାୱିଜୁ ମାଟା ୱେନ୍‌ଜି ଦନ୍‍ଆସାନି ପାରୁସିର୍‌ ଜିସୁଙ୍ଗୁଁ ନିଦା କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ଆବେନ୍‌ ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ଏର୍‌ ନିଜେ ନିଜେଦିଙ୍ଗ୍‌ ଲୋକାରି ଆଗ୍‌ଡ଼ି ଦାର୍ମୁ ଇଜି ତର୍‍ନାର୍‍, ମିର୍‌ ଆୟାୱାଜାଦି ଲୋକୁ, ମାତର୍‌ ମାପୁରୁ ମି ଜିବନ୍‍ତିଙ୍ଗ୍‌ ନେସ୍‌ନା; ମାତର୍‌ ଏମେକା ଲୋକାରି ମାନୁ ପେରିକା, ଆୟାକା ମାପୁରୁଦି ଆଗ୍‌ଡ଼ି କାଡ଼୍‌ନିକା । ");
INSERT INTO kfcp_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","ମୋସାଦି ନିୟମ୍‍ତାନ୍‍ ମାରି ବାବବାଦିର୍ ଦାର୍ମୁସାସ୍ତ୍ର ଡୁବନ୍‌ସିନି ଜୋହନତି ସାନ୍ଧି ୱେଙ୍ଗିଁତା ମାର୍ହାତ୍‌; ଆୟା ୱାଲେରାନ୍‌ ମାପୁରୁଦି ରାଜିଦୁ ସୁସମାଚାର୍‍ ପ୍ରଚାର୍‌ କିଜିନାର୍‌, ମାରି ୱିଜେରେ ଲୋକୁ ଡାଟ୍‌ତାନ୍‌ ଆବେନୁ ସଲ୍‌ସିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ମାତର୍‌ ନିୟମ୍‍ତି ଉଣ୍ତ୍ରି ଇସ୍ରି ଠିକା ମାର୍‍ଗିନି ବାଦ୍‌ଲୁ ବାଦଡ଼ ନି ଦୁନିଆ ମାର୍‍ଗିନିକା ଉସାସ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ଏନ୍‌ଆପିନ୍‌ ନିଜେଦି ଆଡ଼୍‌ସିଙ୍ଗ୍‌ ଡ଼ିସ୍‍ନାନ୍‍ ନୋ ଆଇତାନିଙ୍ଗ୍‌ ପେଡ଼ି ଆନାନ୍‌, ୱାନ୍‌ ଦାରିପାଣି କିନାନ୍‍; ମାରି, ଏନ୍‌ କୋନ୍‌ଲି ମାଣ୍‌କୁ ଡ଼ିସ୍‍ତି ଆଇମାଦିଙ୍ଗ୍‍ ପେଡ଼ିଆନାନ୍‌, ୱାନ୍‌ ବା ଦାରିପାଣି କିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ଅରେନ୍‍ ଦନି ଲୋକୁ ମାର୍ହାନ୍‌, ୱାନ୍‌ ନାଣ୍ତ ଦାରାଦି ଆଙ୍ଗିଁ ଆରାଜି ୱିଜୁଦିନ୍‌ ନାଣ୍ତ ୱେଡ଼ିକାଦାନ୍‌ ଉଣୁଜିତିନ୍‌ଜି ମାର୍ହାନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ମାତର୍‌ ୱାନି ଦୁଆର୍‍ ଲାକ୍‌ତୁ ଲାଜାର୍‌ ଇଜି ଅରେନ୍‍ ବିକାରି ବାସ୍‍ତା ମାର୍ହାନ୍‌, ୱାନି ମେନ୍ଦଲ୍‍ୱିଜୁ ଗାଉକୁ ବର୍ତି ଆତେମାରେଏ; ");
INSERT INTO kfcp_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ୱାନ୍‌ ଆୟା ଦନି ଲୋକୁଦି ଟେବୁଲ୍‍ତାନ୍‍ ଆର୍‌ନି ସକ୍‍ଡ଼ିଦାନ୍‍ ଏସ ଉଣୁଜି ପଟାପାଜିସ୍‌ କିଦେଙ୍ଗ୍ ଆସା କିଜିମାର୍ହାନ୍‍; ମାରି, ନୁକୁଡ଼ିଙ୍ଗ୍‍ ୱାଜି ୱାନି ଗାଉକୁ ୱିଜୁ ନାକ୍‍ସି ମାର୍‌ଏ । ");
INSERT INTO kfcp_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ତାନେ ୱେନ୍‌କା ଆୟା ବିକାରି ସାତାନ୍‍ ମାରି ଦୁତ୍‍କା ମାଣ୍‌କୁ ଅବ୍ରାହାମତି ଗାତୁ ଅତେ; ୱେନ୍‌କା ଆୟା ଦନି ଲୋକୁ ବା ସାତାନ୍‍ ମାରି ମୁସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ମାରି, ୱାନ୍‌ ନର୍କଦି କାସ୍ଟୁଦୁ କଲ୍‌ବଲ୍‌ ଆଜି ମୁସ୍‌କୁ ସୁଡ଼ୁଜି ଆକ୍‌ରାନ୍‌ ଅବ୍ରାହାମ ମାରି ୱାନି ଗାତୁଦୁ ଲାଜାର୍‌ତିଙ୍ଗ୍‌ ସୁଡ଼ୁତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ଆବେଟ୍‌ ୱାନ୍‌ କୁକ୍‍ସି ଇର୍ହାନ୍‌, ଏ ବୁବା ଅବ୍ରାହାମ, ନାଙ୍ଗିଁ ଦୟା କିଜ ଲାଜାର୍‌ତିଙ୍ଗ୍‌ ପୋକ୍‍ତାଆ, ଏଣ୍ତେସ୍‌ ୱାନ୍‌ ଏର୍‍ତୁ ନିଜେଦି ଡ଼ାସ୍‍କା ମୁଡ଼ୁକ୍‌ସ ନା ୱେତ୍‌ଲତିଙ୍ଗ୍‌ ସିତ୍‌ଡ଼ି କିଦେଙ୍ଗ୍‌, ମାତର୍‌ ନାନ୍ ଇୟା ସିସୁଦୁ କଲ୍‌ବଲ୍‌ ଆଜିନା । ");
INSERT INTO kfcp_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","ମାତର୍‌ ଅବ୍ରାହାମ ଇର୍ହାନ୍‌, ମାରିନ୍‌, ନିନ୍‌ ଜେ ଜିବନ୍‌ମାର୍‌ଇ ୱାଲେ ନିଜେଦି ନେଗି ବିସୟୱିଜୁ ପଇତି, ମାରି ଲାଜାର୍‌ ଆୟାୱାଜା ତାଗ୍‌ଇ ବିସୟୱିଜୁ ପ‍ଇତାନ୍‌, ଇକା ଅଡ଼୍‍ବିଆ; ମାତର୍‌ ଇଲେ ୱାନ୍‌ ଇୟା ବାଡ଼ିଦୁ ୱେଡ଼ିକା ପଇଜିନାନ୍‍, ମାରି ନିନୁ କଲ୍‌ବଲ୍‌ ଆଜିନି । ");
INSERT INTO kfcp_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ଆକା ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ନିଦି ମାନ୍ଦି ମାଣ୍‌କୁ ନାଣ୍ତ ଗାଡ଼୍‍ଦି ମାନାତ୍‌, ଏଣ୍ତେସ୍‌ ଏମେ ଲୋକୁ ଇୟା ବାଡିଦାନ୍‍ ମି ଲାକ୍‌ତୁ ସଣ୍ଡ୍ରେଙ୍ଗ୍‌ ଇଜି ବଦା କିନାର୍‌, ୱାର୍‌ ସଣ୍ଡ୍ରେଙ୍ଗ୍‌ ଆଟ୍‍ଏର୍‍, ମାରି ଆୟାବାଡିଦାନ୍‍ ଏନ୍‌ବା ମା ଲାକ୍‌ତୁ ନାସ ୱାଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ଆବେନ୍‌ ମାଜନ୍‌ଲୋକ୍‌ ଇର୍ହାନ୍‌, ଏ ବୁବା, ଆତିଙ୍ଗ୍‌ ନାନ୍ ନିଙ୍ଗିଁ ମାଡ଼ିସ୍‌ କିଜିନା, ୱାନିଙ୍ଗ୍‌ ନା ବୁବାଦି ଇଲ୍‍ଦୁ ପୋକ୍‌ଆ, ");
INSERT INTO kfcp_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ମାତର୍‌ ନା ପାସ୍‌ଲୋକ୍‌ ତଡ଼ାନ୍‍କୁ ମାନାର୍‌; ୱାର୍‍ବା ଏଣ୍ତେସ୍‌ ଇୟା କାସ୍ଟୁଦି ବାଡିଦୁ ରାମାକିର୍‍, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାନ୍‌ ୱାରି ଲାକ୍‌ତୁ ସାକି ସିନି । ");
INSERT INTO kfcp_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","ମାତର୍‌ ଅବ୍ରାହାମ ଇର୍ହାନ୍‌, ୱାରି ଲାକ୍‌ତୁ ମୋସା ମାରି ବାବବାଦିରି ଦାର୍ମୁସାସ୍ତ୍ର ମାନାତ୍‌, ୱାର୍‌ ୱାରି ମାଟା ୱେନ୍‌ରି । ");
INSERT INTO kfcp_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ଆବେନ୍‌ ୱାନ୍‌ ଇର୍ହାନ୍‌, ଏ ବୁବା ଅବ୍ରାହାମ, ଆକା ନାଣ୍ତ ଆଏତ୍‍; ମାତର୍‌ ଜଦି ସାତିମାନିଲୋକା ଲାକ୍‌ତୁରାନ୍‌ ଅରେନ୍‍ ୱାରି ଲାକ୍‌ତୁ ସନାର୍‌, ଆତିଙ୍ଗ୍‌ ୱାର୍‌ ମନ୍‍ତିଙ୍ଗ୍‍ ଡ଼େପ୍‍ନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ମାତର୍‌ ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ଜଦି ୱାର୍‌ ମୋସା ନି ବାବବାଦିରି ମାଟା ୱେନ୍‌ଏର୍‌, ଆତିଙ୍ଗ୍‌ ସାତିମାନି ଲୋକାମାଣ୍‌କୁ ଅରେନ୍‍ ମାରିଡ଼େସି ଜିବନ୍‌ଆଜିନିଙ୍ଗିଁଜି ସରିଙ୍ଗ୍ ବା ୱାର୍‌ ନେଗିମାଟା ୱେର୍‌ତିଙ୍ଗ୍‌ ୱେନ୍‌ଏର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ଜିସୁ ୱାନି ସିସୁରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ଏମେ ୱିଜୁ ପରିକାଦାନ୍‌ ଲୋକୁ ପାପ୍‌ତୁ ଆର୍‌ନାନ୍‌, ଆୟାୱିଜୁ ଏଣ୍ତେସ୍‌ବା ୱାନାତ୍‌, ମାତର୍‌ ଜେ ଇୟା ୱିଜୁଦି ବଜ୍‌ ଆନାନ୍‌, ୱାନି ଦସ୍‌ ଏସା ବୟକାର୍‌ ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ଇୟା ଇସ୍ରି ଲୋକାମାଣ୍‌କୁ ଅରେନ୍‍ୱାନି ଲୋକ୍‌ତି ପାପ୍‍ ଆନାନ୍‌ ୱାନି କକ୍‍ଲାଦୁ ଉଣ୍ତ୍ରି ଜାତାକାଲୁ ଡ଼ସି ୱାନିଙ୍ଗ୍‌ ସାମ୍‌ଦୁର୍‌ତୁ ପକ୍‍ତିଙ୍ଗ୍‍ ମାର୍‍ରିଙ୍ଗ୍‍ ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ନେଗେଣ୍ତ୍‍ ଆତାତ୍‍ମାନ୍ଦି । ");
INSERT INTO kfcp_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ଆରିଙ୍ଗ୍‌, ମିର୍‌ ନିଜେ ନିଜେଦି ବିସୟ୍‌ତାନ୍‌ ଜାଗାର୍‌ତା ଆଜି ମାନ୍‌ଡ଼୍ରୁ । ଜଦି ମି ତଡ଼ାନ୍‌ ପାପ୍‌ କିନାନ୍‌, ଆରିଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ ୱେର୍‍ତୁ; ମାରି, ୱାନ୍‌ ଜଦି ମନ୍‍ ଡ଼େପ୍‍ନାନ୍‍, ଆରିଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ କେମା ସିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ମାରି, ଜଦି ୱାନ୍‌ ଅର୍‌ନେଟିଙ୍ଗ୍‍ ସାତ୍ ଦେବେଙ୍ଗ୍‌ ମି ବିରଦ୍‌ତାନ୍‌ ପାପ୍‌ କିନାନ୍‌ ମାରି ସାତ୍ ଦେବେଙ୍ଗ୍‌ ମି ଲାକ୍‌ତୁ ଡ଼େସିୱାଜି ନାନ୍ ମନ୍‍ ଡ଼େପ୍‍ସିନା ଇଜି ଇନାନ୍‌, ଆରିଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ ଏଣ୍ତେସ୍‌ବା କେମା ସିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ଆବେଟ୍‌କୁ ପ୍ରେରିତ ସିସୁର୍‍ ପ୍ରବୁଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ମା ବିସ୍‌ବାସ୍‌ ନାଣ୍ତ୍‍ ପିରିସ୍‍ କିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ପ୍ରବୁ ଇର୍‌ଆନ୍‌, ଜଦି ଉଣ୍ତ୍ରି ସାର୍‍ସୁ ପାଡ଼ୁ ୱାଜା ମି ବିସ୍‌ବାସ୍‌ ତେବାନାତ୍‍, ଆତିଙ୍ଗ୍‌ ଇୟା ତୁତ୍‍କଡ଼ି ମାର୍‍ତିଙ୍ଗ୍‍ ନିନ୍‌ ମଦଲ୍‍ତାନ୍‍ ରେଲାଜି ସାମ୍‌ଦୁର୍‌ତୁ ଉରାଆ ଇଜି ଇରିଙ୍ଗ୍‌ ଆକା ମି ମାଟା ମାନାନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ମାତର୍‌ ମି ମାଣ୍‌କୁ ଇୟାୱାଜା ଲୋକୁ ଏନ୍‌ ମାନାନ୍‌, ଆମାୱାନି ଗତିମୁରୁଲି ଡ଼ୁଜି ୱାନାନ୍‌ ମାରି ଡ଼ାକ୍‍କଡିଙ୍ଗ୍‍ ସାରାକିଜି କିଡ଼ିଇଦାନ୍‍ ୱାତିଙ୍ଗ୍‍ ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ଇନାନ୍‌, ଇୟାଦାପ୍ରେ ୱାଜି ଉଣ୍ତେଙ୍ଗ୍‌ ବାସ୍‍ଆ ? ");
INSERT INTO kfcp_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ୱାନ୍‌ ଇନିକା ୱାନିଙ୍ଗ୍‌ ଇନ୍‌ଏନ୍‌, ନାନ୍ ଉଣ୍ତେଙ୍ଗ୍‌ ରସ୍‍ଆ, ମାରି ନାନ୍ ତିନିଉଣିକା ୱିସ୍‌ଇ ସାନ୍ଦି ଜୁକ୍‍ଦୁ ତରାଜି ନା ସେବା କିଆ, ତାନି ୱେନ୍‌କା ନିନ୍‌ ତିନିଉଣି ? ");
INSERT INTO kfcp_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ଗତିମୁରୁଲି ୱାନି ମାଟାଦାନ୍‌ ପାଣି କିତିଙ୍ଗ୍‌ ୱାନ୍‌ ଇନିକା ୱାନିଙ୍ଗ୍‌ ଦନ୍ୟବାଦ୍‌ ସିନାନ୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ଆୟାୱାଜାନେ ମିର୍‌ ବା ମାଟାଦାନ୍‌ ୱିଜୁ ପାଣିକିତି ୱେନ୍‌କା ଇନ୍‍ଣ୍ତ୍ରୁ, ମାପ୍‌ ଇନି ପାଣି କିଇ ଗତିମୁରୁଲିଙ୍ଗ୍‍, ଏମେକା କିଦେଙ୍ଗ୍‌ ଆନାତ୍‌, ଆକାନେ କିତାମାନାପ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ଜିସୁ ଜିରୁସାଲମ୍‌ତୁ ସନିୱାଲେ ସମିରୋଣ୍‍ ମାରି ଗାଲିଲି ବା ସିଜି ସଲ୍‍ସିମାର୍‍ଆର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ମାରି, ୱାନ୍‌ ଉଣ୍ତ୍ରି ନାର୍‍ତୁ ଡ଼ୁଗିତାନ୍‍, ଦାସ୍‍ଲୋକ୍‍ କୁସ୍ଟରୋଗ୍‌ତି ଲୋକୁ ୱାନିଙ୍ଗ୍‌ ମିସାତାର୍‍; ");
INSERT INTO kfcp_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ୱାର୍‌ ଆକ ନିଲ୍‍ଜି ନାଣ୍ତ ଆଉଲି ଆଜି ଇର୍ହାର୍‌, “ଏ ଜିସୁ, ଗୁରୁ, ମାଙ୍ଗିଁ ଦୟା କିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ମାରି, ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ସୁଡ଼ୁଜି ଇର୍ହାନ୍‌, “ମିର୍‌ ସଲ୍‌ସି ନିଜେ ନିଜେଦିଙ୍ଗ୍‍ ଜାଜକରିଙ୍ଗ୍‍ ତର୍‌ତୁ ।” ମାରି, ୱାର୍‌ ସଲ୍‍ପୁ ସଲ୍‍ପୁ ନେଗେଣ୍ତ୍‌ ଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ମାତର୍‌ ୱାରି ମାଣ୍‌କୁ ଅରେନ୍‍ ନିଜେଦି ନେଗେଣ୍ତ୍‍ ଆତିକା ସୁଡ଼ୁଜି ନାଣ୍ତ ଆଉଲି ଆଜି ମାପୁରୁଦି ଦନ୍ୟବାଦ୍‌ କିଜି କିଜି ଡେସି ୱାତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ମାରି ଜିସୁଦି ପାଦାମ୍‌କା ଆଡ୍‍ଗି ଆର୍‍ଜି ୱାନିଙ୍ଗ୍‌ ଦନ୍ୟବାଦ୍‌ ସିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାନ୍‌; ୱାନ୍‌ ଅରେନ୍‍ ସମିରୋଣିୟ ଲୋକୁ । ");
INSERT INTO kfcp_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ଆବେଟ୍‌ ଜିସୁ ଇର୍ହାନ୍‌, “ଦାସ୍‍ଲୋକ୍‍ ଇନିକା ନେଗେଣ୍ତ୍‌ ଆଏତାର୍‍ ? ଆରିଙ୍ଗ୍‌ ମାରି ଲୋକୁ ଏମେ ? ");
INSERT INTO kfcp_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ଗୌରବ୍‍ ମାପୁରୁଦି ଦନ୍ୟବାଦ୍‌ ସିଦେଙ୍ଗ୍‍ ଇଜି ଇୟା ଆଇଜାତିଦି ଲୋକ୍‌ତିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ଇନିକା ମାରି ଏର୍‍ବା ଡ଼େସି ରେଏର୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ମାରି, ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନିଙ୍ଗିଁଜ ସାଙ୍ଗ୍‍ଆ, ନି ବିସ୍‌ବାସ୍‌ ନିଙ୍ଗିଁ ନେଗେନ୍‍ କିତାମାନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ମାପୁରୁଦି ରାଜି ଏସ୍‌କାଙ୍ଗ୍‌ ୱାଜିନାତ୍‍, ଇୟା ବିସୟ୍‌ତାନ୍‌ ପାରୁସିର୍‌ ଜିସୁଙ୍ଗୁଁ ୱେନ୍‌ବାତିଙ୍ଗ୍‌ ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମାପୁରୁଦି ରାଜି ତରାଜି ରେଏତ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ମାରି ସୁଡ଼ୁଦୁ, ମାପୁରୁଦି ରାଜି ଇବେନ୍‌ ବା ଆବେନ୍‌ ଇଜି ଲୋକୁ ଇନ୍‌ଏର୍‌; ମାତର୍‌ ସୁଡ଼ୁଦୁ, ମାପୁରୁଦି ରାଜି ମି ଲୋଇ ମାନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ମାତର୍‌ ଜିସୁ ସିସୁରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଇୟାୱାଜା ଦିନ୍‌ ୱାନାତ୍‌, ଏସ୍ତିୱାଲେ ମିର୍‌ ମନୁସ୍ୟପୁତ୍ରଦି ଦିନାମ୍‍ତି ମାଣ୍‌କୁ ଉଣ୍ତ୍ରି ନାଣ୍ତିଙ୍ଗ୍‌ ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ବଦା କିନିଦେର୍‍, ମାତର୍‌ ସୁଡ଼୍‍ଦେଙ୍ଗ୍‍ ଆଟ୍‍ଇଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ସୁଡ଼ୁଦୁ, ଆବେନୁ, ସୁଡ଼ୁଦୁ, ଇବେନ୍‌, ଇଜି ଲୋକୁ ମିଙ୍ଗିଁ ଇନ୍‌ନାର୍‌; ମାତର୍‌ ମିର୍‌ ଆବେ ସଲ୍‍ମାଟ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ମାତର୍‌ ମିର୍‌ସିନିକା ଏଣ୍ତେସ୍‌ ବାଦଡ଼୍‍ତି ଉଣ୍ତ୍ରିଲାକ୍‍ତୁରାନ୍‍ ମାରି ଉଣ୍ତ୍ରି ସାନ୍ଦି ଜାଇସିନାତ୍‍, ମନୁସ୍ୟପୁତ୍ର ନିଜେଦି ଦିନ୍‌ତୁ ଆୟାୱାଜା ତରାୟ୍‍ ଆନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ମାତର୍‌ ଆଗ୍‌ଡ଼ି ୱାନିଙ୍ଗ୍‌ ପୁରା ନାଣ୍ତ ଦୁଃକ୍‌କାସ୍ଟୁ କିଦେଙ୍ଗ୍‌ ଆନାତ୍‌ ମାରି ଇୟା ଇଲେତି ମେମାରିର୍‌ ମାଣ୍‌କୁ ଡ଼ିସାଇ ଆଦେଙ୍ଗ୍‌ ପଡ଼ାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ମାରି, ନୋହଦି ବେଡ଼ାଦୁ ଏଣ୍ତେସ୍‌ ଗଟାତା ମାର୍ହାତ୍‌, ମନୁସ୍ୟପୁତ୍ରଦି ୱାନି ବେଡ଼ାଦୁ ବା ଆୟାୱାଜା ଗଟାନାତ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ଏର୍‌ଜାହାଜ୍‌ତୁ ନୋହଦି ଡ଼ୁଗୁନି ଦିନ୍‌ ସାନ୍ଦି ଲୋକୁ ଉଣିତିନିକା ମାରି ମେମାରି ନି ଆଇମା ପେଡ଼ିଆନି ୱିଜୁପାଣିଦୁ ଦାନ୍ଦା ଆତାମାର୍ହାତ୍‌, ମାରି ନାଣ୍ତ ଗାଲିପିରୁ ୱାଜି ୱିଜେରିଙ୍ଗ୍‌ ଏର୍‍ତୁ ମୁଡ଼ୁକ୍‍ତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ଲୋଟଦି ସମୟତୁ ବା ଆୟାୱାଜା ଗଟାତା ମାର୍ହାତ୍‌, ଲୋକୁ ଉଣିକାତିନିକା, କଣିକାପର୍‌ନିକା, ମାରାକୁଉରୁନିକା ମାରି ଇଲୁ ତିଆର୍‌ କିଦେଙ୍ଗ୍‌ ଦାନ୍ଧା ଆତା ମାର୍ହାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ମାତର୍‌ ଲୋଟ ସଦମ୍‍ଦାନ୍‌ ସତିସର୍‌ଇ ନାଣ୍ତିଙ୍ଗ୍‌ ବାଦଡ଼୍‍ତାନ୍ ସିସୁ ମାରି ଗନ୍ଧକ୍‌ ପିରୁ ୱାଜା ୱାଜି ୱିଜେରିଙ୍ଗ୍‌ ସାପିସ୍‌ କିତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ମନୁସ୍ୟପୁତ୍ର ତରାୟ୍‍ଆନି ନାଣ୍ତିଙ୍ଗ୍‌ ଆୟାୱାଜା ଗଟାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“ଆୟାନାଣ୍ତିଙ୍ଗ୍‌ ଏନ୍‌ ସାତ୍ ମୁସ୍‌କୁ ତେବାନାନ୍‌, ୱାନ୍‌ ଇଲୁ ଲୋଇ ମାନି ନିଜେଦି ସାଶାପାତି ଅତେଙ୍ଗ୍‌ ଇଜି ରେସି ରାମାକିନ୍‍; ଆୟାୱାଜା ଏନ୍‌ କିଡ଼ିଇଦୁ ତେବାନାନ୍‌, ୱାନ୍‌ ଡ଼େସି ସଲ୍‍ମାକିନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ଲୋଟଦି ଆଡ଼୍‌ସି ମାଟା ଅଡ଼୍‍ବିଆ । ");
INSERT INTO kfcp_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ଏନ୍‍କି ନିଜେଦି ଜିବନ୍‌ତିଙ୍ଗ୍‌ ଜିଣା କିଦେଙ୍ଗ୍‌ ବଦା କିନାନ୍‌, ୱାନ୍‌ ଆକା ଆରାକିନାନ୍‍, ମାରି ଏନ୍‍କି ନିଜେଦି ଜିବନ୍‌ତିଙ୍ଗ୍‌ ଆରାକିନାନ୍‍, ୱାନ୍‌ ଆକା ଜିପିସ୍‍ନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ନାନ୍ ମିଙ୍ଗିଁ ୱେର୍‌ସିନା, ଆୟା ନାଡ଼ା ରିଏର୍‌ ଉଣ୍ତ୍ରେ କାଟେଲ୍‍ତୁ ଡର୍‍ନା ମାନାର୍‌, ଅରେନ୍‍ ୱାନିଙ୍ଗ୍‍ ଅନାନ୍‍ ମାରି ଆଇ ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ଡ଼ିସ୍‍ନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ରୁଣ୍ତିଲୋକ୍‍ ଆଇମେକ୍‍ ଅର୍‌ସେ ଜାତାଦୁ ନୁର୍‍ଜିମାନେ, ଅରେତ୍‍ତାନିଙ୍ଗ୍‍ ଅନାନ୍‍ ମାରି ଆଇ ଅରେତ୍‍ତାନିଙ୍ଗ୍‍ ଡ଼ିସ୍‍ନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ରୁଣ୍ତିଲୋକ୍‍ କିଡ଼ିଇଦୁ ତେବାନେ, ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ଅନାନ୍‍ ମାରି ଆଇ ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ଡ଼ିସ୍‍ନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ଆବେଟ୍‌ ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ଏ ପ୍ରବୁ, ଏମେ ଇୟାୱିଜୁ ଗଟାନାତ୍‌ ?” ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଏମେମାନୁ ସାତି ମାଡ଼ା ମାନାତ୍‌, ଆୟାବାନୁ ଡେଗେଙ୍ଗ୍‌ ଉନ୍‌ଡ୍ରେମାନୁ ଉଣ୍ତାନେ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ୱାଦ୍‍ଏଣ୍‍ଗା ୱିଜୁଦିନ୍‌ ପାର୍‌ତନା କିନିକା ଜେ ପାଣି, ଇୟା ବିସୟ୍‌ତାନ୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ କାତାଦାନ୍‍ ୱେର୍‌ତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","ଉଣ୍ତ୍ରି ଗାଡ଼୍‌ତୁ ଅରେନ୍‍ ବିସାର୍‌ କିନିକାନ୍‍ ମାର୍‌ଆନ୍‌, ୱାନ୍‌ ମାପୁରୁଙ୍ଗୁଁ ତିଲାଏଜି ମାର୍‌ଆନ୍‌ କି ଲୋକାଙ୍ଗ୍‌ ମାନାଏଜି ମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ଆୟା ଗାଡ଼୍‌ତୁ ଅରେତ୍‌ ରାଣ୍ତି ମାର୍‌ଆତ୍‌, ୱାଦ୍‌ ରିଜାମୁଜା ୱାନି ଲାକ୍‌ତୁ ସଲ୍‌ସି ୱେର୍‌ସି ମାର୍‌ଆତ୍‌, ଲୋକୁ ନା ଉଣ୍ତିଙ୍ଗ୍‌ ଅନ୍ୟାୟ୍‍ କିଜିନାର୍‍ ନିନ୍‌ ନାଙ୍ଗିଁ ବିସାର୍‌ କିଆ । ");
INSERT INTO kfcp_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ମାରି, ୱାନ୍‌ ଏସ ସମୟ ଆତାତ୍‌ ରାଜିଆଏଜି ମାର୍‌ଆନ୍‌; ମାତର୍‌ ୱେନ୍‌କା ୱାନ୍‌ ମୋନ୍‌ତୁ ମୋନ୍‌ତୁ ଅଡ଼୍‍ବିତାନ୍‍, ଜଦିବା ନାନ୍ ମାପୁରୁଦିଙ୍ଗ୍‌ ତିଲାଏ ମାରି ଲୋକାଙ୍ଗ୍‌ ମାନାଏ, ");
INSERT INTO kfcp_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ମାତର୍‌ ଇୟା ରାଣ୍ତି ନାଙ୍ଗିଁ ଜେଲ୍‌ ସିଜିମାର୍‍ଆତ୍‍ଆକା ନାନ୍ ତାନେ ଉଣ୍ତିଙ୍ଗ୍‌ କିତିମାନି ଅନ୍ୟାୟ୍‍ ପାଣିଦି ଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ତାନେଙ୍ଗ୍‌ ସାକାକିନା, ଆଏତିଙ୍ଗ୍‍ ୱାଦ୍‌ ଦିନ୍‍କେ ୱାଜି ନାଙ୍ଗିଁ ବିଜାର୍‌ କିଜିମାନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ଆବେଟ୍‌ ପ୍ରବୁ ୱେର୍‌ତାନ୍‌, “ଇୟା ଅଦାର୍ମୁଦି ବିସାର୍‌କିନିକାନ୍‌ ଇନିକା ୱେର୍‌ସିନାନ୍‌, ଆକା ୱେଣ୍ତ୍ରୁ । ");
INSERT INTO kfcp_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ମାରି ମାପୁରୁଦି ଏମେ ସେବାକିନି ଲୋକୁ ୱେଡ଼େନାଡ଼ା ୱାନିଙ୍ଗ୍‌ କୁକ୍‍ସିମାନାର୍‍, ୱାନ୍‌ ନୋ ୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ କିତିମାନି ତାଗ୍‌ଇ ପାଣିଦି ଉଣ୍ତିଙ୍ଗ୍‌ ୱାରିଙ୍ଗ୍‌ ସାକା କିଏନ୍‍ ନୋ, ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ସାହାଜ୍ୟ କିଦେଙ୍ଗ୍‌ ୱେଡ଼ା କିନାନ୍‌ନୋ ? ");
INSERT INTO kfcp_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ନାନ୍ ମିଙ୍ଗିଁ ୱେର୍‌ସିନା, ୱାନ୍‌ ବେଗି ୱାରିଙ୍ଗ୍‌ କିତିମାନିମାନି ତାଗ୍‌ଇ ପାଣିଦି ଉଣ୍ତିଙ୍ଗ୍‌ ୱାରିଙ୍ଗ୍‌ ବିସାର୍‌କିନାନ୍‌ । ମାତର୍‌ ମନୁସ୍ୟପୁତ୍ର ୱାଜି ଦୁନିଆଦୁ ଇନିକା ବିସ୍‌ବାସ୍‌ ସୁଣାନ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ନିଜେ ନିଜେଦି ଦାର୍ମୁ ବୁଦି ମାନାତ୍‌ ଇଜି ଆଇ ୱିଜେରିଙ୍ଗ୍‍ ସେମାର୍‌ କିଜିମାନି ଏସ ନିଜେଦି ମୁସ୍‌କୁ ଆସା ଇଡ୍‌ନି ଲୋକାଙ୍ଗ୍‌ ଜିସୁ ଇୟା କାତାଦାନ୍‍ ଇର୍ହାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ରିଏର୍‌ ଲୋକୁ ପାର୍‌ତନା କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ମନ୍ଦିର୍‌ତୁ ସରଆର୍‌, ଅରେନ୍‍ ପାରୁସି ମାରି ଆଇକାନ୍‍ ସିସ୍‍ଟୁ ଲସ୍‌ନିକାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ପାରୁସି ଅରେନ୍‍ ନିରାଆନ୍‍ନୋ ନିଜେଦିମାନୁ ଇୟାୱାଜା ପାର୍‌ତନା କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌, ଏ ମାପୁରୁ, ନାନ୍ ନିଙ୍ଗିଁ ଦନ୍ୟବାଦ୍‌ ସିଜିନା ଜେ, ନାନ୍ ଆଇ ୱିଜେରି ଲୋକା ୱାଜା କାତ୍‍ନିକାନ୍‍, ଅଦାର୍ମୁ, ଦାରିପାଣି ବା ଇୟା ସିସ୍‍ଟୁଲସ୍‍ନିୱାନି ୱାଜାବା ଆଏ; ");
INSERT INTO kfcp_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ନାନ୍ ୱାରାମ୍‍ତୁ ରିନେଣ୍ତ୍‍ ଉପାସ୍‌ କିଜିନା ମାରି ନାନ୍ ଉଣ୍ତାକିନିକା ଦାସ୍‌ବାଗ୍‌ତାନ୍‌ ଉନ୍‌ଡ୍ରି ବାଗ୍ ସିଜିନା । ");
INSERT INTO kfcp_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","ମାତର୍‌ ସିସ୍‍ଟୁ ଲସ୍‌ନିକାନ୍‌ ଆକ ନିଲ୍‍ସି ମୁସ୍‌କୁ ତରିନ୍‌ ସୁଡଦେଙ୍ଗ୍‌ ବା ସାସ୍‍କିଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏତାନ୍‍, ମାତର୍‌ ନିଜେଦି ବକାଦୁ ଡାକାଜି ଇର୍ହାନ୍‌, ଏ ମାପୁରୁ, ନାନ୍ ପାପି, ନାଙ୍ଗିଁ ଦୟା କିଆ । ");
INSERT INTO kfcp_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନାନ୍‌, “ଆୟା ପାରୁସି ଆଏନ୍‍, ମାତର୍‌ ଇୟା ସିସୁଟୁଲସ୍‌ନିକାନ୍‌ ଦାର୍ମୁ ଲୋକୁ ଆଜି ନିଜେଦି ଇଲ୍‌ତୁ ସର୍‌ଆନ୍‌; ମାତର୍‌ ଏମେକାନ୍‍ ନିଜେଦିଙ୍ଗ୍‍ ପେରିକାନ୍‌ ଇଜି ତର୍‍ଆନ୍‍, ୱାନିଙ୍ଗ୍‌ ଇସ୍ରିକାନ୍‌ କିନାର୍‍, ମାତର୍‌ ଏନ୍‌ ନିଜେଦିଙ୍ଗ୍‍ ଇସ୍ରିକାନ୍‍ କିନାନ୍‌, ୱାନିଙ୍ଗ୍‌ ପେରିକାନ୍‌ କିନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ଜିସୁ ଏଣ୍ତେସ୍‌ ଇସ୍ରିକଡ଼ରି ମୁସ୍‌କୁ କିୟୁ ଇଡ୍‌ଜି ମୁଟ୍‍ନାନ୍‍, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ଲୋକୁ ୱାରିଙ୍ଗ୍‌ ବା ଜିସୁଦି ଲାକ୍‌ତୁ ତାତେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌; ମାତର୍‌ ସିସୁର୍‍ ଆକା ସୁଡ଼ୁଜି ୱାରିଙ୍ଗ୍‌ ଆଦ୍‌ରିସ୍‌ତେଙ୍ଗ୍‍ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ମାତର୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ନିଜେଦି ଲାକ୍‌ତୁ କୁକ୍‌ତା ଇର୍ହାନ୍‌, ଇସ୍ରି କଡ଼ରିଙ୍ଗ୍‌ ନା ଲାକ୍‌ତୁ ୱାଦେଙ୍ଗ୍‌ ସିଦୁ, ମାରି ୱାରିଙ୍ଗ୍‌ ମାନା କିମାଟ୍‌; ଇରିଙ୍ଗ୍‌ ମାପୁରୁଦି ରାଜି ଇୟାୱାଜା କଡ଼ରିଦି । ");
INSERT INTO kfcp_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, “ଏନ୍‌ ଇସ୍ରିକଡ଼ୱାଜା ମାପୁରୁଦି ରାଜି ଆସ୍‍ଏନ୍‍, ୱାନ୍‌ ଏଣ୍ତେସ୍‍କିଜିବା ମୁସ୍‍କୁପୁର୍‌ ସଣ୍ଡ୍ରେଙ୍ଗ୍‌ ଆଟ୍‍ଏନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ଅରେନ୍‍ ଜିହୁଦିର୍‌ ପେରିକାନ୍‌ ଜିସୁଙ୍ଗୁଁ ୱେନ୍‌ବାତାନ୍‌, “ଏ ସତ୍‍ ଗୁରୁ, ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜିଇ ଜିବନ୍‌ ପୟ୍‌ନି ଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ଇନିକା କିନା ?” ");
INSERT INTO kfcp_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ଆବେଟ୍‌ ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନାଙ୍ଗିଁ ନେଗିକାନ୍‍ ଇଜି ଇନିଦାନିଙ୍ଗ୍‌ ଇଜିନି ? ମାରି ମାପୁରୁଙ୍ଗୁଁ ଡ଼ିସ୍‍ତିଙ୍ଗ୍, ମାରି ଆଇକାନ୍‍ ଏନ୍‌ବା ସତ୍‌ ସିଲେନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ପ୍ରବୁଦି ନିୟମକୁ ୱିଜୁ ତୋ ନିନ୍‌ ନେସ୍‍ତିମାନି, ଦାରିପାଣି କିମାଟ୍‌, ଲୋକାଙ୍ଗ୍‌ ସାୟାମାର୍‌ଗା ଡାକ୍‌ମାଟ୍‌, ଡଙ୍ଗାଁ ପାଣି କିମା, ମିସ୍‌ସାକି ୱେର୍‍ମା, ନିଜେଦି ବୁବା ୟାୟାଏଙ୍ଗ୍‍ ମାନାଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ୱାନ୍‌ ୱେର୍‌ତାନ୍‌, ଇୟାୱିଜୁ ନାନ୍ ମୁରୁଲିୱାଲେରାନ୍‍ ମାନାଜି ୱାଜିନା । ");
INSERT INTO kfcp_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ଜିସୁ ଇୟାକା ୱେନ୍‌ଜି ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ନି ଉଣ୍ତ୍ରିବିସୟ ଉଣାମାନାତ୍‌; ନିନ୍‌ ନିଜେଦି ୱିଜୁ ସମ୍ପତ୍ତି ପର୍‌ଜି କାକୁର୍ତି ଲୋକାଙ୍ଗ୍‌ ବାଟାକିଜି ସିଆ, ମାରି ନିନୁ ମୁସ୍‌କୁପୁର୍‌ତୁ ଦନ୍‌ ପୟ୍‌ନି; ମାରି, ୱାଜି ନା ୱେନ୍‌କା ରାଆ । ");
INSERT INTO kfcp_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ମାତର୍‌ ୱାନ୍‌ ଇୟାୱିଜୁ ମାଟା ୱେନ୍‌ଜି ନାଣ୍ତ୍‍ ଦୁଃକ୍‍ ଆତାନ୍‌, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ପେରିମାଜନ୍‍ ମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ଆବେଟ୍‌ ୱାନି ଦୁଃକ୍‌ ଆନିକା ସୁଡ଼୍‌ଜି ଜିସୁ ନିଜେଦି ସିସୁରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ଏମେ ଲୋକ୍‌ତିଙ୍ଗ୍‌ ଦନ୍‍ ମାନାତ୍‌, ୱାର୍‌ ଏସ କାସ୍ଟୁଦାନ୍‍ ମାପୁରୁଦି ରାଜିଦୁ ସନାର୍‌ ! ");
INSERT INTO kfcp_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ଇରିଙ୍ଗ୍‌ ମାପୁରୁଦି ରାଜିଦୁ ମାଜନ୍‌ ଲୋକୁ ସନି ବାଦୁଲୁ ସୁଜିଦି ବର୍‌ ସିଜି ଉଟ୍‌ ଡ଼ୁଗୁନିକା ଉସାସ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ଏମେ ଲୋକୁ ଇୟା ମାଟା ୱେର୍‌ଆର୍‌, ୱାର୍‌ ଇର୍ହାର୍‌, ଆର୍‌ତିଙ୍ଗ୍‌ ଏନ୍‌ ରକିୟା ପଇଦେଙ୍ଗ୍‍ ଆଟ୍‍ନାନ୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ମାତର୍‌ ଜିସୁ ଇର୍ହାନ୍‌, “ଆମା ପାଣି ଲୋକାମାଣାନ୍‌ ଆଏତ୍‍, ଆୟା ପାଣି ମାପୁରୁ କିନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ଆବେଟ୍‌ ପିତର୍‌ ଇର୍ହାନ୍‌, “ସୁଡୁଆ, ମାପୁ ନିଜେ ନିଜେଦି ୱିଜୁ ଡ଼ିସ୍‌ସି ନି ୱେନ୍‍କା ୱାତା ମାନାପ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ୱେର୍‌ସିନା, ଏମେ ଲୋକୁ ମାପୁରୁଦି ରାଜିଦି ଉଣ୍ତିଙ୍ଗ୍‌ ଇଲୁ କି ନିଜେଦି ଆଡ଼ି କି ତଡ଼ାନ୍‌ କି ବୁବାୟାୟା କି କଡ଼କକ୍‍ରା ଡ଼ିସ୍‍ତି ମାନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ଇୟା ଦୁନିଆଦୁ ନାଣ୍ତ୍‍ଗୁଣ୍‍ ମାରି ୱେନ୍‌କାରି କାଡ଼ାଦୁ ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜ୍‍ଇ ଜିବନ୍‌ ପୟ୍‌ନାନ୍‌, ଇୟାୱାଜା ଲୋକୁ ଏର୍‌ ସିଲେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ୱେନ୍‌କା ଜିସୁ ବାର୍‍ଲୋକ୍ ୱେର୍‌ଏ କିଜି ୱାରିଙ୍ଗ୍‌ ୱେର୍‌ତାନ୍‌, “ୱେନ୍‌ଡ୍ରୁ, ମାପ୍‌ ଜିରୁସାଲମ୍‌ତୁ ସଲ୍‍ସିନାପ୍‍, ମାରି ମନୁସ୍ୟପୁତ୍ରଦି ବିସୟ୍‌ତାନ୍‌ ବାବବାଦିରି ଆମାୱିଜୁ ରାସ୍‌ତାମାନାର୍‌, ଆୟାୱିଜୁ ପୁରା ଆନାତ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ଅଣଜିହୁଦି କିୟୁଦୁ ସର୍‍ପେ ଆନାନ୍‌, ମାରି ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ସେମାର୍‍ କିନାର୍‌, ୱାନିଙ୍ଗ୍‌ ଅପ୍‍ମାନ୍‍ କିନାର୍‌ ୱାନି ମୁସ୍‌କୁ ପୁସ୍‍କାଡ଼ାଙ୍ଗ୍‍ ପୁସ୍‍ନାର୍‍, ");
INSERT INTO kfcp_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ୱାନିଙ୍ଗ୍‌ କର୍‌ଡା ଡ଼େଇଜି ସାୟାମାର୍‌ଗାଡାକ୍‌ନାର୍‌, ମାରି ମୁନେଟି ୱେନ୍‌କା ୱାନ୍‌ ମାରିଡ଼େସି ଜିବନ୍‌ଆଜି ନିଙ୍ଗିଁନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ମାତର୍‌ ୱାର୍‌ ଇୟାୱିଜୁ ବିସୟ୍‌ ଇନିକାବା ନେସ୍‌ଏତାର୍‌; ଇୟା ବାକ୍ୟ ୱାରିମାନ୍‍କୁ ମାର୍‍ଗିତା ତେବାତାତ୍‌, ମାରି ଇନିକା ଇନିକା ଇଜିମାର୍‌ଆର୍‌, ଆୟାୱିଜୁ ୱାର୍‌ ନେସ୍‍ଏଜି ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ଜିସୁ ଜିରିହୋଦି ଲାକ୍‌ତୁ ଆଜିମାରି ୱାଲେ ଅରେନ୍‍ କାଣା ସାରି ପାଡ଼ି ବାସ୍‌ତାନ୍‌ ବିକ୍‍ୟା ଲସ୍‌ସି ମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ୱାନ୍‌ ଲୋକୁ ବୁଲାନି ସେଉଡ଼ୁ ୱେନ୍‌ଜି ମାଟା ଇନିକା ଇଜି ୱେନ୍‍ବାଦେଙ୍ଗ୍‍ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, ନାଜରିୟତିୟ ଜିସୁ ଇୟା ସାରି ସିଜି ସଲ୍‌ସିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ଆବେଟ୍‌ ୱାନ୍‌ ନାଣ୍ତ୍‍ ଆଉଲି ଆଜି ଇର୍‌ଆନ୍‌, “ଏ ଜିସୁ, ଦାଉଦ୍‌ତି ମାରିନ୍‍, ନାଙ୍ଗିଁ ଦୟା କିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ମାତର୍‌ ଆଗିଡ଼ି ସଲ୍‍ସିମାରି ଲୋକୁ ୱାନିଙ୍ଗ୍‌ ଆଲେଜ ମାନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଇଜି ଆଦିରିସ୍‌ତେଙ୍ଗ୍‍ ଆସ୍‌ତାର୍‌, ମାତର୍‌ ୱାନ୍‌ ମାରି ନାଣ୍ତ ଆଉଲି ଆଜି ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌, “ଏ ଦାଉଦତି ମାରିନ୍‍, ନାଙ୍ଗିଁ ଦୟା କିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ଆବେଟ୍‌ ଜିସୁ ନିଲ୍‍ଜି ୱାନିଙ୍ଗ୍‌ ନିଜେଦି ଲାକ୍‌ତୁ ତାତେଙ୍ଗ୍‌ ଇଜି ଆଦେସ୍‌ ସିତାନ୍‌; ମାରି, ୱାନ୍‌ ଲାକ୍‌ତୁ ୱାତାନ୍‍ଆକା, ଜିସୁ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“ନାନ୍ ନି ଉଣ୍ତିଙ୍ଗ୍‌ ଇନିକା କିନା ଇଜି ନିନ୍‌ ବଦା କିଜିନି ?” ୱାନ୍‌ ଇର୍‌ଆନ୍‌, “ଏ ପ୍ରବୁ, ନାନ୍ ଏଣ୍ତେସ୍‌ମାରି ସୁଡ଼ୁଦେଙ୍ଗ୍‌ ଆଟ୍‍ନା ।” ");
INSERT INTO kfcp_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଆରିଙ୍ଗ୍‌ ସୁଡ଼ୁଆ; ନି ବିସ୍‌ବାସ୍‌ ନିଙ୍ଗିଁ ନେଗେନ୍‍ କିତାମାନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ଆୟାଦାପ୍ରେ ୱାନ୍‌ ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ଆଟ୍‍ତାନ୍‍ନୋ ମାପୁରୁଙ୍ଗୁଁ ଦନ୍ୟବାଦ୍‌ କିଜି କିଜି ୱାନି ୱାଲେୱାଲେ ବୁଲାଦେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ ମାରି ଲୋକୁ ୱିଜେରେ ଆକା ସୁଡ଼ୁଜି ମାପୁରୁଦି ପ୍ରସଂସା କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ୱେନ୍‌କା ଜିସୁ ଜିରିହୋ ଗାଡ଼୍‌ତୁ ଡ଼ୁଗୁଜି ନାଡ଼୍‍ମିସିଜି ସଲ୍‍ସିମାର୍‍ଆନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ମାରି ସୁଡ଼ୁଦୁ, ଜକିୟ ଦର୍‌ତି ଅରେନ୍‍ ଲୋକୁ ମାର୍‌ଆନ୍‌, ମାରି ୱାନ୍‌ ଅରେନ୍‍ ପେରି ସିସ୍‍ଟୁଲସ୍‍ନିକାନ୍‍ ମାରି ମାଜନ୍‌ ମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ଜିସୁ ଏନ୍‌, ଆକା ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ୱାନ୍‌ ବଦା କିଜିମାର୍‍ଆନ୍‍, ମାତର୍‌ ଲୋକା ଗଲିଦି ଉଣ୍ତିଙ୍ଗ୍‌ ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏଜି ମାର୍‌ଆନ୍‌, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ବୁଟ୍‍କା ମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ଆଦେଙ୍ଗ୍‌ ୱାନ୍‌ ଲୋକା ଆଗ୍‌ଡ଼ି ଉରୁକ୍‍ସି ସଲ୍‌ସି ଜିସୁଙ୍ଗୁଁ ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ଇଜି ଉଣ୍ତ୍ରି ତଗାମାରାନ୍‌ତୁ ଏକ୍‍ତାନ୍‍, ଇରିଙ୍ଗ୍‌ ଆୟା ସାରି ସିଜି ଜିସୁ ସନିକା ମାର୍‌ଆତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ଜିସୁ ଆୟା ବାଡିଦୁ ୱାଜି ମୁସ୍‌କୁ ବେସ୍‍ସି ଜକିୟଙ୍ଗ୍‍ ଇର୍‌ଆନ୍‌, “ଜକିୟ, ବେଗି ରେସିରାଆ, ଇରିଙ୍ଗ୍‌ ନେର୍‌ ନାଙ୍ଗିଁ ମି ଇନ୍‌ଡ୍ର ଏଣ୍ତେସ୍‌ବା ତେବାଦେଙ୍ଗ୍‍ ଆନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ଆବେଟ୍‌ ଜକିୟ ଦାପ୍ରେ ରେସିୱାଜି ୱେଡ଼ିକାଦାନ୍‌ ଜିସୁଙ୍ଗୁଁ ୱାନି ଇଣ୍ତ୍ର କୁକ୍‍ତାଅତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ଆକା ସୁଡ଼ୁଜି ୱିଜେରେ କାଡ଼୍‍ଜି ଇନ୍‍ଣ୍ତ୍ରେଙ୍ଗ୍‍ ଆସ୍‌ତାର୍‌, “ୱାନ୍‌ ଅରେନ୍‍ ପାପି ଲୋକ୍‌ତି ଇଣ୍ତ୍ର ତେବାଦେଙ୍ଗ୍‍ ସର୍‍ଆନ୍‍ନି ।” ");
INSERT INTO kfcp_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ମାତର୍‌ ଜକିୟ ନିର୍‍ଆନ୍‍ନୋ ପ୍ରବୁଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଏ ପ୍ରବୁ, ସୁଡ଼ୁଆ, ନା ଦନ୍‌ ଆଦାବାଗ୍‍ କାକୁର୍ତି ଲୋକାଙ୍ଗ୍‌ ସିଜିନା, ମାରି ଜଦି ଅନ୍ୟାୟତାନ୍‍ ଏମାଣୁକୁ ଇନିକା ଅନାମାନା, ଆତିଙ୍ଗ୍‌ ସାରି ଗୁଣ୍‍ତାନ୍‍ ଡ଼େସିସିଜିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ଆବେଟ୍‌ ଜିସୁ ୱାନି ବିସୟ୍‌ତାନ୍‌ ଇର୍‌ଆନ୍‌, “ନେର୍‌ ଇୟା ଇଣ୍ତ୍ର ରକିୟା ପଇନିକା ଇଗା ୱାତାମାନାତ୍‌, ଇରିଙ୍ଗ୍‌ ଇକାନ୍‌ ବା ଅବ୍ରାହାମତି ଅରେନ୍‍ ମାରିସି । ");
INSERT INTO kfcp_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ଇରିଙ୍ଗ୍‌ ଆମାକା ମୁରିତାମାନାତ୍‍, ଆକା ପୟଜ ରକିୟା କିଦେଙ୍ଗ୍‌ ମନୁସ୍ୟପୁତ୍ର ୱାତାମାନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ଲୋକୁ ଇୟା ମାଟା ୱିଜୁ ୱେନିୱାଲେ ଜିସୁ ମାରି ଉଣ୍ତ୍ରି କାତା ୱେର୍‌ତାନ୍‌, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ଜିରୁସାଲାମ୍‍ ଲାକ୍‌ତୁ ଇତା ମାର୍‌ଆନ୍‌ ମାରି ମାପୁରୁଦି ରାଜି ଦାପ୍ରେନେ ୱାନାତ୍‌ ଇଜି ୱାର୍‌ ଅଡ଼୍‍ବିଜି ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ଆବେଟ୍‌ ୱାନ୍‌ ଇର୍‌ଆନ୍‌, ଅରେନ୍‍ ପେରି ଲୋକୁ ରାଜା ଆଦେଙ୍ଗ୍‌ ଉଣ୍ତ୍ରି ଆକ ରାଜିଦୁ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ତିଆର୍‌ ଆଜି ମାର୍‌ଆନ୍‌, ୱେନ୍‌କା ୱାନ୍‌ ଡ଼େସିୱାଜି ନିଜେଦି ଲୋକା ମୁସ୍‌କୁ ସାସନ୍‍ କିଦେଙ୍ଗ୍‌ ଅଡ଼୍‍ବିଜି ମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ୱାନ୍‌ ନିଜେଦି ଦସ୍‍ଲୋକ୍ ସାକର୍‌କାଙ୍ଗ୍‌ କୁକ୍‌ସି ୱାରିଙ୍ଗ୍‌ ୱିଜେରିଙ୍ଗ୍‍ ଉଣ୍ତ୍ରି ଉଣ୍ତ୍ରି ବାଙ୍ଗାଁରାମ୍‍ ଅଦ୍‌ଲି ସିଜି ଇର୍‌ଆନ୍‌, ନାନ୍ ୱାନି ସାନ୍ଦି ବେପାର୍‌ କିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ମାତର୍‌ ୱାନି ଦେସ୍‌ତି ଲୋକୁ ୱାନିଙ୍ଗ୍‌ କାଡ଼୍‍ଜି ମାର୍‌ଆର୍‌, ମାରି ୱାର୍‌ ୱାନି ୱେନ୍‌କା ଅରେନ୍‍ ୱାନିଙ୍ଗ୍‌ କାବୁର୍‌ ପୋକ୍‌ସି ଇର୍ହାର୍‌, ଇକାନ୍‌ ଜେ ମା ମୁସ୍‌କୁ ସାସନ୍‍ କିନାନ୍‌, ଇକା ମା ବଦା ସିଲେତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","ୱେନ୍‌କା ୱାନ୍‌ ରାଜା ଆଜି ଡ଼େସିୱାତାନ୍‍, ମାରି ଆମା ସାକର୍‌କାଙ୍ଗ୍‌ ଡାବୁଙ୍ଗୁଁ ସିତାମାର୍‍ଆନ୍‍, ୱାରି ଲୋଇ ବେପାର୍‌ କିଜି ଏନ୍‌ ଏସୋ ଲାବ୍‍ ପୟତା ମାନାନ୍‌, ଆକା ନେସ୍‌ତେଙ୍ଗ୍‌ ଇଜି ୱାରିଙ୍ଗ୍‌ ୱାନି ଲାକ୍‌ତୁ କୁକ୍‍ସୋ ତାତେଙ୍ଗ୍‌ ଆଦେସ୍‌ ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ଆବେଟ୍‌ ପାର୍‍ତୁମ୍‍ତିକାନ୍‍ ୱାଜି ଇର୍‌ଆନ୍‌, ପ୍ରବୁ, ନି ଉଣ୍ତ୍ରି ବାଙ୍ଗାଁରାମ୍‍ ଡାବୁଦୁ ନାନ୍ ମାରି ଦଶଗୋଟା ବାଙ୍ଗାଁରାମ୍‍ ଡାବୁଙ୍ଗୁଁ ଲାବ୍‍ କିତାମାନା । ");
INSERT INTO kfcp_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ନିନ୍‌ ବେସି ନେଗି ସାକର୍‌, ନିନ୍‌ ଉଣା ବିସୟତୁ ବିସ୍‌ବାସ୍‌ତାନ୍‍ ପାଣି କିତିମାନି ଆକା ନିନ୍‌ ଦସ୍‍ଗୋଟା ଗାଡ଼ାକା ମୁସ୍‍କା ଅଦିକାର୍‍ ପୟଦେଙ୍ଗ୍‍ ସିଜିନା । ");
INSERT INTO kfcp_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ମାରି, ଅରେନ୍‍ ୱାଜି ଇର୍‌ଆନ୍‌, ପ୍ରବୁ, ନି ଉଣ୍ତ୍ରି ବାଙ୍ଗାଁରାମ୍‍ ଡାବୁଦାନ୍‍ ନାନ୍ ପାସ୍‌ଗୋଟା ବାଙ୍ଗାଁରାମ୍‍ ଡାବୁଙ୍ଗୁଁ ଲାବ୍‍ କିତାମାନା । ");
INSERT INTO kfcp_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ବା ଇର୍‌ଆନ୍‌, ନିନ୍‌ ବା ପାସ୍‌ଗୋଟା ଗାଡ଼ାକା ମୁସ୍‌କୁ ଅଦିକାର୍‍ ପୟଦେଙ୍ଗ୍‍ ସିଜିନା । ");
INSERT INTO kfcp_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ମାରି ଅରେନ୍‍ ୱାଜି ଇର୍‌ଆନ୍‌, ପ୍ରବୁ, ସୁଡ଼ୁଆ, ଇୟା ନି ବାଙ୍ଗାଁରାମ୍‍ ଡାବୁଙ୍ଗୁଁ, ନାନ୍ ଇୟା ପାଗାଦୁ ତର୍‍ତା ଇଟ୍‌ଟା ମାର୍‍ଆ; ");
INSERT INTO kfcp_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ଇରିଙ୍ଗ୍‌ ନାନ୍ ନିଙ୍ଗିଁ ତିଲାତା, ଇରିଙ୍ଗ୍‌ ନିନ୍‌ ଅରେନ୍‍ ଆଟ୍‍ୱାଦି ଲୋକୁ, ଆମାକା ଇଡ୍‍ଇମାନି, ଆକା ପେର୍‍ନିଅନି, ମାରି ଆମାକା ୱିତ୍‍ଇ, ଆକା କୟନି । ");
INSERT INTO kfcp_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ରେ ତାଗ୍‌ଇ ସାକର୍‌, ନି ମୋକମ୍‍ତି ମାଟାଦି ନି ବିସାର୍‌ କିନା । ନାନ୍ ଅରେନ୍‍ ଆଟ୍‍ୱାଦି ଲୋକୁ, ଆମାକା ଇଡ୍‍ଏମାନା, ଆକା ପେର୍‍ନାଅନା, ମାରି ଆମାକା ୱିତ୍‌ଏମାନା, ଆକା କୟନା, ଇକା ଇନିକା ନେସ୍‍ତିମାର୍‍ଇ ? ");
INSERT INTO kfcp_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ଜଦି, ଇୟା ମାଟା ସତ୍‌, ବ୍ୟାଙ୍କ୍‍ତୁ ଏନ୍ଦା ନା ବାଙ୍ଗାଁରାମ୍‍ ଡାବୁଙ୍ଗୁଁ ଇଡ୍‍ଇତି ? ଆତିଙ୍ଗ୍‌ ନାନ୍ ୱାଜି ବ୍ୟାଙ୍କ୍‍ତାନ୍‍ ଉପ୍‍ରି ପଇତାମାନ୍ଦି । ");
INSERT INTO kfcp_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ମାରି, ଆୟା ଲାକ୍‌ତୁ ନିର୍‍ଇ ମାର୍‍ଇ ଲୋକାଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ୱେନି ମାଣାନ୍‌ ଇୟା ବାଙ୍ଗାଁରାମ୍‍ ଡାବୁଙ୍ଗୁଁ ଅସି, ଆମାୱାନିମାନୁ ଦଶଗୋଟା ବାଙ୍ଗାଁରାମ୍‍ ଡାବୁଙ୍ଗୁଁ ମାନେ, ୱାନିଙ୍ଗ୍‌ ସିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ଆବେଟ୍‌ ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, ପ୍ରବୁ, ୱାନିଙ୍ଗ୍‌ ତୋ ଦାସ୍‍ଗୋଟା ବାଙ୍ଗାଁରାମ୍‍ ଡାବୁଙ୍ଗୁଁମାନେ । ");
INSERT INTO kfcp_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ନାନ୍ ମିଙ୍ଗିଁ ୱେର୍‌ସିନା, ଏମେଲୋକାଦି ମାନାତ୍‌, ୱାନିଙ୍ଗ୍‌ ସିନାର୍‍, ମାତର୍‌ ଆମାୱାନିଙ୍ଗ୍‌ ସିଲେତ୍‌, ୱାନି ଲାକ୍‌ତୁରାନ୍‌ ଆମାକା ଉଣାମାନାତ୍‌, ଆକାବା ୱାନି ମାଣ୍‌କୁ ଅନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ମାତର୍‌ ନା ଇୟା ଆମା ସାତ୍ରୁର୍‍ ନାନ୍ ୱାରି ମୁସ୍‌କୁ ସାସନ୍‍ କିନା ଇଜି ବଦା କିଏଜିମାର୍‍ଆର୍‍, ୱାରିଙ୍ଗ୍‌ ଇବେ ତାସିନା ଆଗ୍‌ଡ଼ି କାତ୍‍ତୁ । ");
INSERT INTO kfcp_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ଜିସୁ ଇୟା ମାଟା ୱେର୍‌ତି ୱିସ୍‌ତି ୱେନ୍‌କା ସିସୁରି ଆଗ୍‌ଡ଼ି ଆଗ୍‌ଡ଼ି ଜିରୁସାଲାମ୍‍ ତରିନ୍‌ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ମାରି, ଏସ୍ତିୱାଲେ ଜିସୁ ଜୀତ ଗରନ୍‍ ଲାକ୍‌ତୁରି ବେତ୍‍ପାଗି ନି ବେତନିୟା ଲାକ୍‌ତୁ ଇତାନ୍‌, ନାସ୍‍ତିୱାଲେ ୱାନ୍‌ ୱାନି ସିସୁରି ଲୋଇ ରିଏରିଙ୍ଗ୍‍ ଇୟା ମାଟା ୱେର୍‌ସି ପୋକ୍‌ତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ମି ଆଗ୍‍ଡ଼ିରି ଆୟା ଆୟା ନାଟ ସାନ୍‌ଡ୍ରୁ; ଆବେ ଇତି ଦାପ୍ରେ, ଆମାତାନି ମୁସ୍‌କୁ ଏସାଙ୍ଗ୍‍ ଏନ୍‌ ବାସ୍‍ଏନ୍‍, ଇୟାୱାଜା ଉଣ୍ତ୍ରି ଗଦପିଲାଦିଙ୍ଗ୍‌ ତର୍‍ନି ମାନିକା ସୁଡ଼ୁନିଦେର୍‍; ତାନେଙ୍ଗ୍‌ କୁତ୍‍ସ ତାଗାଟ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ମାରି, ଏନ୍‌ ଜଦି ମିଙ୍ଗିଁ ଏନ୍ଦା କୁତ୍‍ସି ଅସିନିଦେର୍‍ ଇଜି ୱେନ୍‍ବାନାନ୍‌, ମିର୍‌ ଇୟାୱାଜା ଇନିଦେର୍‌, ଇରିଙ୍ଗ୍‌ ତେନେମାନୁ ପ୍ରବୁଙ୍ଗୁଁ ଦର୍‌କାର୍‌ ମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ଆବେଟ୍‌ ଆୟା ରିଏର୍‌ ସିସୁର୍‍ ନାର୍‍ତୁ ସରଆର୍‌, ମାରି ପ୍ରବୁ ୱାରିଙ୍ଗ୍‌ ଏଣ୍ତେସ୍‌ ଇର୍‌ଆ ମାର୍‌ଆନ୍‌, ଆୟାୱାଜାନେ ସୁଡ଼ୁତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ମାରି, ୱାର୍‌ ଗଦପିଲାଦିଙ୍ଗ୍‍ କୁତ୍‍ନିୱାଲେ ଗଦପିଲାଦି ମାଲିକ୍‍କୁ ୱାରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, ଏନ୍ଦା ଗଦପିଲାଦିଙ୍ଗ୍‍ କୁତ୍‍ସିନିଦେର୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ୱାର୍‌ ଇର୍ହାର୍‌, ତେନେମାନୁ ପ୍ରବୁଙ୍ଗ୍‌ ଦର୍‌କାର୍‌ ମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ମାରି, ୱାର୍‌ ଗଦପିଲାଦିଙ୍ଗ୍‍ ଜିସୁ ଲାକ୍‌ତୁ ଆୟା ଗଦ ମୁସ୍‌କୁ ନିଜେ ନିଜେଦି ୱାତିଙ୍ଗ୍‍ ପାର୍‍ସି ଜିସୁଙ୍ଗୁଁ ବାସ୍‍ସିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ମାରି, ୱାନ୍‌ ସନିୱାଲେ ଲୋକୁ ରାସ୍ତାଦୁ ନିଜେ ନିଜେଦି ୱାତିଙ୍ଗ୍‍ ପାର୍‍ସି ସିଦେଙ୍ଗ୍‍ ଆସ୍‌ତେ । ");
INSERT INTO kfcp_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ମାରି, ୱାନ୍‌ ଏସ୍ତିୱାଲେ ଜୀତ ଗରନ୍‌ତି ଗାଡ଼୍‍ଗାଡ଼ା ବାଡି ଲାକ୍‌ତୁ ଇତାନ୍‌, ନାସ୍ତିୱାଲେ ୱିଜେରେ ସିସୁର୍‍ ସୁଡ଼୍‍ତି ମାର୍‍ଇ ୱିଜୁ ସାକ୍ତିଦି ପାଣି ଉଣ୍ତିଙ୍ଗ୍‌ ୱେଡ଼ିକାଦାନ୍‌ ନାଣ୍ତ ଆଉଲି ଆଜି ମାପୁରୁଦି ଦନ୍ୟବାଦ୍‌ କିଜି କିଜି ଇର୍ହାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ପ୍ରବୁ ଦର୍‌ତାନ୍‌ ଆମା ରାଜା ୱାଜିନାନ୍‍, ୱାନ୍‌ ଦନ୍ୟ । ମୁସ୍‌କୁପୁର୍‌ତୁ ସାନ୍ତି ମାରି ଗୌରବ୍‍ ମାପୁରୁଦି ଦନ୍ୟବାଦ୍‌ ଆପିତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ଆବେଟ୍‌କୁ ଲୋକା ଲୋଇ ଏସୋ ପାରୁସିର୍‌ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାର୍‌, “ଏ ଗୁରୁ, ନି ସିସୁରିଙ୍ଗ୍‌ ଆଲ୍‌ଜ ମାନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଇନ୍‌ଆଁ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ଜିସୁ ଇର୍‌ଆନ୍‌, “ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ଇକାର୍‌ ଆଲେତି ମାର୍‍ରିଙ୍ଗ୍‍, କାଲ୍‌କୁ ଆଉଲି ଆନେ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ମାରି, ଏସ୍ତିୱାଲେ ଜିସୁ ଜିରୁସାଲାମ୍ ଲାକ୍‌ତୁ ୱାତାନ୍‌, ନାସ୍ତିୱାଲେ ଗାଡ଼୍‌ତିଙ୍ଗ୍‌ ସୁଡ଼ୁଜି ତାନେ ଉଣ୍ତିଙ୍ଗ୍‌ ଆଡ଼୍‍ବାଜି ଇର୍‌ଆନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“ନିନ୍‌, ହୁଁ, ନିନ୍‌ ଜଦି ନେର୍‌ ସାନ୍ତି ପୟ୍‌ନି ବିସୟ୍‌ତିଙ୍ଗ୍‌ ନେସ୍‌ତି ମାନ୍ଦି ! ମାତର୍‌ ଇଲେଇ ଆୟାୱିଜୁ ନିବାଣ୍‍କୁ ମାର୍‍ଗିତା ମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ଆଦେଙ୍ଗ୍‌ ନି ମୁସ୍‌କୁ ମାନି କାର୍ମୁଦି ସମୟ ନିନ୍‌ ନେସ୍‌ଇତି ଆକା, ସମୟ ୱାଜିନାତ୍‍ ଏସ୍ତିୱାଲେ ମି ସାତ୍ରୁର୍‍ ନି ସାରିବେଡ଼୍‍ତି ଗାଟୁ ତର୍‌ସି ନିଙ୍ଗିଁ କେର୍‍ପ୍‍ସି ବାଦା କିନାର୍‌, ମାରି ମି ୱିଜୁ ସେର୍‍ଲେଙ୍ଗ୍‌ କେର୍‍ନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ମାରି ନିଙ୍ଗିଁ ନିବାନୁ ମାନି ୱିଜୁ ଲୋକାଙ୍ଗ୍‌ ଗୁଣ୍ତା କିନାର୍‌, ମାରି ନିବାନୁ ଉଣ୍ତ୍ରି କାଲୁଦିଙ୍ଗ୍‌ ଆଇ ଉଣ୍ତ୍ରି କାଲୁ ମୁସ୍‌କୁ, ତେବାଏତ୍‍, ଇରିଙ୍ଗ୍‌ ନିଙ୍ଗିଁ ଏସ୍ତିୱାଲେ ମାପୁରୁ ରକିୟା କିଦେଙ୍ଗ୍‌ ୱାତାନ୍‌, ନିନ୍‌ ୱାନିଙ୍ଗ୍‌ ସିନିସ୍‍ କିଇତିଦେର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ମାରି, ଜିସୁ ମନ୍ଦିର୍‌ତୁ ଡ଼ୁଗିତାନ୍‍ ନୋ ପର୍‌ନି ଲୋକାଙ୍ଗ୍‌ ଇକା ଇଜି ସପ୍‍ତେଙ୍ଗ୍‍ ଆସ୍‌ତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“ଦର୍ମୁସାସ୍ତ୍ରଦୁ ରାସାତାମାନାତ୍‌, ମାପୁରୁ ଇର୍‌ଆନ୍‌, ମା ଇଲୁ ପାର୍‍ତନାଦି ଇଲୁ ଆନାତ୍‌, ମାତର୍‌ ମିର୍‌ ତାନେଙ୍ଗ୍‌ ଡଙ୍ଗାଁର୍‍ଙ୍ଗାଁ ଇଲୁ କିତିମାନିଦେର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ମାରି, ଜିସୁ ୱିଜୁଦିନ୍‌ ମନ୍ଦିର୍‌ତୁ ସିକ୍‍ଆ ସିଜିମାର୍‍ଆନ୍‍, ମାତର୍‌ ପେରି ଜାଜକର୍‌, ସାସ୍ତ୍ରିର୍‍ ମାରି ଲୋକାଣି ପେରିକାର୍‌ ୱାନିଙ୍ଗ୍‌ ସାପିସ୍‍କିଦେଙ୍ଗ୍‍ ବଦାକିଜିମାର୍‍ଆର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ମାତର୍‌ ଲୋକ୍‌ ୱିଜେରେ ୱେଡ଼ିକାଦାନ୍‌ ୱାନି ସିକିୟା ୱେନ୍‍ଜିମାର୍‍ଆର୍‍, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାର୍‌ ଇନିକା କିଦେଙ୍ଗ୍‌ ଆନାତ୍‌ ଆକା ଅଡ଼୍‍ବିଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏଜି ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ଜିସୁ ଅର୍‍ଲେନ୍‍ ମନ୍ଦିର୍‌ ଲୋଇ ମାନ୍‌ଜି ଲୋକାଙ୍ଗ୍‌ ସିକିୟା ସିଜିମାର୍‍ଆନ୍‍ ମାରି ନେଗିକାବୁର୍‌ ୱେର୍‌ସି ମାର୍‌ଆନ୍‌, ନାସ୍ତିୱାଲେ ପେରି ଜାଜକର୍‌ ନି ସାସ୍ତ୍ରିର୍‍ ଜିହୁଦିର୍‌ ପେରି ଲୋକାୱାଲେ ୱାଜି ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ନିନ୍‌ ଏମେ ଅଦିକାର୍‍ତାନ୍‍ ଇୟାୱିଜୁ କିଜିନି, ବା ଏନ୍‌ ନିଙ୍ଗିଁ ଇୟା ଅଦିକାର୍‌ ସିତାନ୍‌, ୱାନ୍‌ ଏନ୍‌, ମାଙ୍ଗିଁ ଇନ୍‌ଆଁ । ");
INSERT INTO kfcp_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ମାତର୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ୱେର୍‌ତାନ୍‌, “ନାନ୍ ବା ମିଙ୍ଗିଁ ଉଣ୍ତ୍ରି ମାଟା ୱେନ୍‌ବାନା, ନାଙ୍ଗିଁ ଇନ୍‍ଣ୍ତ୍ରୁ, ");
INSERT INTO kfcp_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ଡୁବନ୍‌ସିନି ଯୋହନତି ବାପ୍ତିସ୍ମ ସିନି ଅଦିକାର୍‌ ମାପୁରୁ ମାଣ୍‌କୁ ନୋ ଲୋକା ମାଣ୍‌କୁ ଆତାମାର୍‍ଆତ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ଆବେଟ୍‌ ୱାର୍‌ ୱାରି ୱାରି ଲୋଇ ୱାର୍‌ଗିଜି ସାତାର୍‌, ଜଦି ମାପୁରୁ ମାଣ୍‌କୁ ଇଜି ଇନିକା, ଆବେଟ୍‌ ୱାନ୍‌ ଇନାନ୍‌, ମିର୍‌ ଏନ୍ଦା ୱାନିଙ୍ଗ୍‌ ବିସ୍‌ବାସ୍‌ କିଇତିଦେର୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ଜଦି ଲୋକା ମାଣ୍‌କୁ ଇଜି ଇନିକା, ଆବେଟ୍‌ ଲୋକୱିଜେରେ ମାଙ୍ଗିଁ କାଲ୍‍କାଣ୍‍ ଡାକ୍‍ନା ପୋକ୍‌ନାର୍‌, ଇରିଙ୍ଗ୍‌ ଯୋହନ ଜେ ଅରେନ୍‍ ବାବବାଦି, ଇକା ୱାର୍‌ ଆଟ୍‍ୱାଦାନ୍‍ ମାନାତାମାନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ଆଦେଙ୍ଗ୍‌ ଇକା ଆମାଣ୍‍କୁ ଆତାତ୍‌, “ଇକା ନେସ୍‌ଏପ୍‌ ଇଜି ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ୱେର୍‌ତାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନାନ୍ ଏମେ ଅଦିକାର୍‍ତାନ୍‍ ଇୟାୱିଜୁ କିଜିନା, ଆକାବା ନାନ୍ ମିଙ୍ଗିଁ ୱେର୍‌ତେଙ୍ଗ୍‌ କେଏ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ଇୟା ୱେନ୍‌କା ଜିସୁ ଲୋକାଙ୍ଗ୍‌ ଇୟା କାତା ୱେର୍‌ତେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । “ଅରେନ୍‍ ଲୋକୁ ଉଣ୍ତ୍ରି ଅଙ୍ଗୁର୍‍ କିଡ଼ିଇ କିଜି ଆକା ପାଣିକିନିୱାରିଙ୍ଗ୍‌ ବାଗ୍‍ତୁ ପାଣି କିଦେଙ୍ଗ୍‌ ସିଜି ନାଣ୍ତ ଦିନ୍‍ତି ଉଣ୍ତିଙ୍ଗ୍‌ ଆଇ ଦେସ୍‌ତୁ ସର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ମାରି, ପାଣିକିନିକାର୍‌ ଏଣ୍ତେସ୍‌ ୱାନିଙ୍ଗ୍‌ ଅଙ୍ଗୁର୍‍ କିଡ଼ିଇଦି ପଳ୍‍ତି ବାଗ୍ ସିନାର୍‍, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାନ୍‌ ଅରେନ୍‍ ପାଣି କିନି ମୁରୁଲିଙ୍ଗ୍‌ ଟିକ୍‌ ସମୟତୁ ୱାରି ଲାକ୍‌ତୁ ପୋକ୍‌ତାନ୍‌, ମାତର୍‌ ଆୟା ପାଣିକିନିକାର୍‌ ୱାନିଙ୍ଗ୍‌ ମାଡ୍‌ ଡାକ୍‍ତାର୍‍ରୋ ୱାର୍‌ଇ କିୟୁଦାନ୍‌ ଡ଼େସିପେରିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ୱାନ୍‌ ମାରି ଅରେନ୍‍ ପାଣିକିନି ଗତିମୁରୁଲିଙ୍ଗ୍‌ ପୋକ୍‌ତାନ୍‌; ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ବା ଡାକ୍‍ତାର୍‍ ମାରି ଅପ୍‍ମାନ୍‍ କିଜି ୱାର୍‌ଇ କିୟୁଦାନ୍‌ ଡ଼େସିପେରିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ୱେନ୍‌କା ୱାନ୍‌ ମାରି ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ବା ପୋକ୍‌ତାନ୍‌; ମାତର୍‌ ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ବା କାଣ୍ତିଆ କାବରା କିଜି ଆତ୍‌ରେ ପେର୍‍ତାପୋକ୍‍ତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ଆବେଟ୍‌ ଅଙ୍ଗୁର୍‍ କିଡ଼ିଇଦି ମାଲିକ୍‌ ଇର୍‌ଆନ୍‌, ନାନ୍ ଇନିକା କିନା ? ନା ଲାଡ୍‍ତି ମାରିନ୍‍ତିଙ୍ଗ୍‍ ପୋକ୍‌ନା, ଆନାତ୍‌ସୁଗି ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ମାନାନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ମାତର୍‌ ପାଣିକିନିକାର୍‌ ମାଲିକ୍‌ତି ମାରିସିଙ୍ଗ୍‌ ସୁଡ଼ୁଜି ୱାରି ଲୋଇ ୱାର୍‍ଗିସାଜି ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, ଇକାନ୍‌ ତୋ ୱାନି ମାରିସି, ୱେନିଙ୍ଗ୍‌ ସାୟାମାର୍‌ଗା ଡାକ୍‍ନାଟ୍‍, ଏଣ୍ତେସ୍‍କି ଇୟାୱିଜୁ ଦନ୍‌ ମାଦି ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ମାରି, ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଅଙ୍ଗୁର୍‍ କିଡ଼ିଇ ଆତ୍‌ରେ ଅସି ସାୟାମାର୍‌ଗା ଡାକ୍‌ତାର୍‌ । ଇଲେଇ, ଅଙ୍ଗୁର୍‍ କିଡ଼ିଇଦି ମାଲିକ୍‌ ୱାରିଙ୍ଗ୍‌ ଇନିକା କିନାନ୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ମାଲିକ୍‌ ୱାଜି ଇୟା ପାଣିକିନିୱାରିଙ୍ଗ୍‌ ସାବିସ୍‍ କିନାନ୍‌ ମାରି ଆଇ ଲୋକାଙ୍ଗ୍‌ ଅଙ୍ଗୁର୍‍ କିଡ଼ିଇ ବାଗ୍‍ତୁ ପାଣି କିଦେଙ୍ଗ୍‌ ସିନାନ୍‍ । ଇକା ୱେନ୍‌ଜି ୱାର୍‌ ଇର୍ହାର୍‌, ଆୟାୱାଜା ଆମାକିତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ମାତର୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ସୁଡ଼ୁଜି ଇର୍‌ଆନ୍‌, ଆରିଙ୍ଗ୍‌ ଇୟା ଆମା ବାକ୍ୟ ରାସାତାମାନାତ୍‌, ତାନେ ଅର୍ତ ଇନିକା, ଇଲୁ ତିଆର୍‌ କିନିକାର୍‍ ଆମା କାଲୁଦିଙ୍ଗ୍‌ ସିଲେ ଇର୍ହାର୍‌, ଆକା କନାଦି ମୁଲ୍‌କାଲୁ ଆତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ଆମାକାନ୍‍ ଆୟା କାଲୁ ମୁସ୍‌କୁ ଆର୍‌ନାନ୍‌, ୱାନ୍‌ ମକା ମକା ଆନାନ୍‌, ମାରି ଆୟା କାଲୁ ଆମାୱାନି ମୁସ୍‌କୁ ଆର୍‍ନାତ୍‍, ୱାନିଙ୍ଗ୍‌ ଆକା ଗୁଣ୍ତ୍‍ଗୁଣ୍ତା କିନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ଆବେଟ୍‌ ସାସ୍ତ୍ରିର୍‍ ମାରି ପେରି ଜାଜକର୍‌ ଆୟା ଦାପ୍ରେ ଜିସୁଙ୍ଗୁଁ ଆସ୍‌ତେଙ୍ଗ୍‌ ସେସ୍ଟା କିତାର୍‍, ମାତର୍‌ ୱାର୍‌ ଲୋକାଙ୍ଗ୍‌ ତିଲାତାର୍‌, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ଇୟା କାତା ୱାରିଙ୍ଗ୍‌ ସୁଡ଼ୁଜି ଇର୍ହାନ୍‌ ଇଜି ୱାର୍‌ ବୁଜାତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ଆବେଟ୍‌ ଦାର୍ମୁସାସ୍ତ୍ରିର୍‍ ମାରି ପେରି ଜାଜକର୍‌ ଜିସୁଙ୍ଗୁଁ ଜାଡ଼ିଦୁ ଆର୍‌ପ୍‌ତେଙ୍ଗ୍‌ ଇଜି ନେଗି ସମୟତିଙ୍ଗ୍‍ କାପ୍‌କିଜି ମାର୍ହାର୍‍ । ୱାର୍‌ ଜିସୁ ଲାକ୍‌ତୁ ଏସୋ ସାଲାକିଦି ୱାରିଙ୍ଗ୍‌ ଲାଞ୍ଚ୍‍ସିଜି ପୋକ୍‌ତାର୍‌ । ୱାର୍‌ ଇୟା ଲୋକାଙ୍ଗ୍‌ ନେଗି ଲୋକୁ ୱାଜା ସାଲାକି କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ଇର୍‌ଆ ମାର୍ହାର୍‍ । ୱାର୍‌ ଜିସୁ ୱେର୍‍ସିମାନି ମାଟାଦୁ ଇନି ତାଗ୍‌ଇ ବିସ୍‌ୟ ପୟ୍‌ଜ ସପ୍‍ତେଙ୍ଗ୍‍ ବଦା କିଜିମାର୍ହାର୍‍ । ଇରିଙ୍ଗ୍‌ ଜଦି ୱାର୍‌ ଜିସୁମାନୁ ଇନି ତାଗ୍‌ଇ ବିସ୍‌ୟ ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ଆଟ୍‍ନାର୍‍, ଆବେଟ୍‌ ୱାର୍‌ ଜିସୁଦି ମୁସ୍‌କୁ ଅଦିକାର୍‌ ମାନି ସାସନ୍‌ କିନି ଲୋକା କିୟୁଦୁ ଜିସୁଙ୍ଗୁଁ ଆସ୍‍ପିସ୍‍ନା ସିନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, “ଏ ଗୁରୁ, ମାପ୍‌ ନେସ୍‌ନାପ୍‌, ନିନ୍‌ ଟିକ୍‍ ମାଟା ୱେର୍‍ନି, ମାରି ସିକିୟା ସିନି, ମାରି ଏଙ୍ଗ୍‌ବା ମକମ୍‌ ସୁଡ଼ୁଜି ପାଣି କିଇ, ମାତର୍‌ ସତ୍‌ତାନ୍‌ ଲୋକା ଜିବନ୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ମାପୁରୁଦି ବଦା ବିସୟ୍‌ତାନ୍‌ ସିକିୟା ସିନି । ");
INSERT INTO kfcp_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ମାଙ୍ଗିଁ ଇନ୍‌ଆଁ, ରାଜା କାଇସର୍‍ତିଙ୍ଗ୍‍ ସିସ୍‍ଟୁ ସିନିକା ମା ନିୟମ୍‌ ନୋ ସିଲେ ?” ");
INSERT INTO kfcp_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ମାତର୍‌ ଜିସୁ ୱାରି ସାଲାକି ନେସ୍‌ସି ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ନାଙ୍ଗିଁ ଉଣ୍ତ୍ରି ଅଦ୍‌ଲି ତର୍‌ତୁ । ");
INSERT INTO kfcp_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ଉଣ୍ତ୍ରି ୱେଣ୍ତି ଟାକା ଡାବୁଙ୍ଗୁଁ ତର୍‍ତୁ । ତେନି ମୁସ୍‍କୁ ଏ ବମା ନି ଦର୍‌ ମାନାତ୍‌ ? ୱାର୍‌ ଇର୍ହାର୍‌, ରାଜା କାଇସର୍‍ତିନ୍‍ନ୍ଦି । ");
INSERT INTO kfcp_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ଆବେଟ୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଆରିଙ୍ଗ୍‌ ରାଜା କାଇସର୍‍ତି ଆମାକା, ଆକା ରାଜା କାଇସର୍‍ତିଙ୍ଗ୍‍ ସିଦୁ; ମାରି, ମାପୁରୁଦି ଆମାକା, ଆକା ମାପୁରୁଙ୍ଗୁଁ ସିଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ଆବେଟ୍‌ ୱାର୍‌ ଲୋକା ଆଗ୍‌ଡ଼ି ଜିସୁ ମାଟାଦି ତାଗ୍‌ଇ ବିସୟ ଆସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‍ଏତାର୍‍, ମାରି ୱାର୍‌ ୱାନ୍‌ ୱେର୍‌ତି ମାଟାଦି ଉଣ୍ତିଙ୍ଗ୍‌ କାବାଆଜି ଆଲେତା ମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ଇୟା ୱେନ୍‌କା ସାତିଲୋକ୍‌ ମାରିଡ଼େସିଜିବନ୍‌ଆଜି ନିଙ୍ଗିଁନିକା ବିସ୍‌ବାସ୍‌ କିଇକାର୍‍ ଏସୋ ସାଦୁକିର୍ ଜିସୁ ଲାକ୍‌ତୁ ୱାତା ୱେନ୍‌ବାତାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“ଏ ଗୁରୁ, ମୋସା ମା ଉଣ୍ତିଙ୍ଗ୍‌ ରାସ୍‌ତାମାନାନ୍‌ ଜେ, ଜଦି ଏମେ ଲୋକ୍‌ତି ଦାଦ୍‍ସି ଆଡ଼୍‌ସି ମାନାପ୍ ମାନାପ୍ କଡ଼କକ୍‌ରା ଆଏଣ୍ତା ସାନାନ୍‌, ଆତିଙ୍ଗ୍‌ ୱାନି ତଡ଼ାନ୍‌ ୱାନି ଆଡ଼୍‌ସିଙ୍ଗ୍‌ ପେଡ଼ିଆଜ ନିଜେଦି ଦାଦ୍‍ସି ଉଣ୍ତିଙ୍ଗ୍‌ କୁଟୁମ୍‌ କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ଅର୍‍ଲେନ୍‍ ସାତ୍‌ଲୋକ୍‌ ତଡ଼ାନ୍‌କୁ ମାର୍ହାର୍‌; ପେରିଦାଦ୍‍ସି ଅରେତ୍‌ ଆଇମାଦିଙ୍ଗ୍‍ ପେଡ଼ି ଆତାନ୍‌ ମାରି କଡ଼କକ୍‍ରା ଆଏଣ୍ତା ସାତା ସର୍ହାନ୍‍; ");
INSERT INTO kfcp_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ୱେନ୍‌କା ୱାନି କଗ୍‍ରି ତଡ଼ାନ୍‌ ପେଡ଼ିଆଜି କଡ଼କକ୍‍ରା ଆଏଣ୍ତା ସାତା ସର୍ହାନ୍‍ ମାରି ଅରେନ୍‍ ତଡ଼ାନ୍‌ ତାନେଙ୍ଗ୍‌ ପେଡ଼ି ଆତାନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ଆୟାୱାଜା ସାତ୍ ତଡ଼ାନ୍‌କୁ ୱିଜେରେ କଡ଼କକ୍‍ରା ଆଏଣ୍ତା ସାତାସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ସାରାସାରିୱେନ୍‌କା ଆୟା ଆଇମା ବା ସାତା ସର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ଆରିଙ୍ଗ୍‌, ମାରିଡ଼େସିଜିବନ୍‌ଆଜି ୱାର୍‌ ନିଙ୍ଗିଁନିୱାଲେ ଆୟାୱାରି ଲୋଇ ୱାଦ୍‌ ଏ ଆଡ଼୍‌ସି ଆନାତ୍‌ ? ସାତ୍‌ଲୋକ୍‌ ତୋ ତାନିଙ୍ଗ୍‌ ପେଡ଼ି ଆତାମାର୍ହାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଇୟା ଦୁନିଆଦି କଡ଼କକ୍‍ରା ପେଡ଼ି ଆନାର୍‌ ମାରି ପେଡ଼ି ସିନାର୍‍, ");
INSERT INTO kfcp_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ମାତର୍‌ ଏମେ ମେମାରି ନି ଆଇମେକ୍‍ ସାତି ଲୋକାମାଣ୍‌କୁ ମାରିଡ଼େସି ନିଙ୍ଗିଁନି ଉଣ୍ତିଙ୍ଗ୍‌ ମାରି ୱାନି ଦୁନିଆଦୁ ଜିଦେଙ୍ଗ୍‌ ଜଗ୍‌ ଆନାର୍‌ ୱାର୍‌ ପେଡ଼ି ଆଏର୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ମାରି, ୱାର୍‌ ସାଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏର୍‍, ଇରିଙ୍ଗ୍‌ ୱିଜେରେ ମୁସ୍‌କୁପୁର୍‌ତି ଦୁତ୍‍କା ୱାଜା ତେବାନାର୍‌ ମାରି ମାରିଡ଼େସି ଜିବନ୍‌ଆଜିନିଙ୍ଗିଁତିଙ୍ଗ୍‌ କଡ଼ର୍‌ ଆକାର୍‌ଆକା ମାପୁରୁଦି କଡ଼ର୍‌ ଆନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ମୋସା ନେଗ୍ରେଣ୍ତା ତର୍‍ତାମାନ୍‍ ଜେ ଲୋକୁ ସାତିମାଣ୍‌କୁ ମାରିଡ଼େସିଜିବନ୍‌ ଆଜି ଜିନାର୍‍ । ମୋସା ଏସ୍ତିୱାଲେ କାସ୍‍ନି ଦୁପାଦି ବିସୟ୍‌ତାନ୍‌ ରାସ୍‌ତାନ୍‌, ୱାନ୍‌ ଇର୍‌ଆନ୍‌ ଜେ, ପ୍ରବୁ ଆଜିନାନ୍‍ ଅବ୍ରାହାମତି ମାପୁରୁ, ଇସ୍‍ହାକ୍‍ତି ମାପୁରୁ ମାରି ଜାକୁବଦି ମାପୁରୁ । ");
INSERT INTO kfcp_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ୱାନ୍‌ ତୋ ସାତିଲୋକ୍‍ତି ମାପୁରୁ ଆଏନ୍‍, ମାତର୍‌ ଜିବନ୍‌ମାନି ଲୋକା ମାପୁରୁ; ଇରିଙ୍ଗ୍‌ ୱିଜେରେ ୱାନି ଆଗ୍‌ଡ଼ି ଜିନିକାର୍‍ ଆନାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ଆବେଟ୍‌ ସାସ୍ତ୍ରିରି ଲୋଇ ଏସୋ ଲୋକୁ ଇର୍ହାର୍‌, “ଏ ଗୁରୁ, ନିନ୍‌ ସତ୍‌ ୱେର୍‌ତି ।” ");
INSERT INTO kfcp_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ଇରିଙ୍ଗ୍‌ ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଇନି ପ୍ରସ୍ନ ୱେନ୍‍ବାଦେଙ୍ଗ୍‍ ମାରି ସାସ୍‌ କିଏତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ମାତର୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, କ୍ରିସ୍ତ ଜେ ଦାଉଦତି ମାରିନ୍‌, ଇକା ଲୋକୁ ଏଣ୍ତେସ୍‌ ଇନାର୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ଇରିଙ୍ଗ୍‌ ନିଜେ ଦାଉଦ ଗିତସଂହିତାଦୁ ଇନାନ୍‌, ପ୍ରବୁ ନା ପ୍ରବୁଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ମାପ୍‌ ଆମାସାନ୍ଦି ନି ସାତ୍ରୁରିଙ୍ଗ୍ ନି କାଲ୍‌କା ଆଡ୍‍ଗି କିଏପ୍‍, ଆୟା ସାନ୍ଦି ମା ଉଣେରି ତରିନ୍‌ ବାସ୍‌ସ ମାନ୍‌ଆ । ");
INSERT INTO kfcp_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ମାରି, ଦାଉଦ ୱାନିଙ୍ଗ୍‌ ପ୍ରବୁ ଇଜି ଇନାନ୍‌; ଆରିଙ୍ଗ୍‌, ୱାନ୍‌ ଏଣ୍ତେସ୍‌ ୱାନି ମାରିନ୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ୱେନ୍‌କା ଜିସୁ ୱିଜୁ ଲୋକା ଆଗ୍‌ଡ଼ି ସିସୁରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“ସାସ୍ତ୍ରିରିମାଣ୍‍କୁ ଜାଗାର୍‌ତା ! ୱାର୍‌ ନିର୍‍ଇ ଆଙ୍ଗିଁ ଆରାନାର୍‍ । ମାରି ସାତାସାଉକାଦୁ ଲୋକୁ ମାଡ଼ିସ୍‌ କିପିର୍‍ ଇଜି ଅଡ଼୍‍ବିନାର୍‍, ପାର୍‍ତନାକିନି ଇଲ୍‌କାଙ୍ଗ୍‌ ପେରି ବାଡି ମାରି ବୋଜି ଉଣିମାନୁ ପେରି ବାଡି ପୟଦେଙ୍ଗ୍‍ ବଦାକିନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ୱାର୍‌ ରାଣ୍ତି ଆଇମେକା ଇଲୁଦି ୱିଜୁ ବିସୟ୍‌ ରେନାଅନାର୍‍ ମାରି ନିଜେଦିଙ୍ଗ୍‍ ନେଗିକାନ୍‍ ତର୍‌ତେଙ୍ଗ୍‍ଁ ନିର୍‍ଇ ପାର୍‌ତନା କିନାର୍‌; ୱାର୍‌ ନାଣ୍ତ ଦଣ୍ତ୍‌ ପୟ୍‌ନାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ଇୟା ୱେନ୍‌କା ଜିସୁ ସାରିବେଡ଼୍‍ତି ସୁଡ଼୍‌ଜି ଏସୋ ମାଜନ୍‌ ଲୋକୁ ମନ୍ଦିର୍‌ତି ଡାବୁଙ୍ଗୁଁ ସିନି ପେଡ଼ାଦୁ ମାପୁରୁଦି ଉଣ୍ତିଙ୍ଗ୍‌ ଦାନ୍‍ ସିନିକା ସୁଡ଼ୁତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ମାରି, ୱାନ୍‌ ଅରେତ୍‌ କାକୁର୍ତି ରାଣ୍ତି ଆଇମା ଆୟା ପେଡ଼ାଦୁ ରୁନ୍‍ ଟାକେଙ୍ଗ୍‍ଁ ସିନିକା ସୁଡ଼୍‌ଜି ୱେର୍‌ତାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ଇୟା କାକୁର୍ତି ରାଣ୍ତି ଆଇମା ୱିଜେରିଙ୍ଗ୍‌ ନାଣ୍ତ ସିତାମାନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ଇରିଙ୍ଗ୍‌ ଇକାର୍‌ ୱିଜେରେ ପେଡ଼ାଦୁ ନିଜେ ନିଜେଦି ଆମାକା ୱାରିଙ୍ଗ୍‌ ଦର୍‍କାର୍‍ ସିଲେତ୍‌ ଆୟା ଡାବୁଙ୍ଗୁଁ ଦାନ୍‍ ସିତାମାନାର୍‌, ମାତର୍‌ ଇକାତ୍‍ ନିଜେ ଜିଦେଙ୍ଗ୍‌ ଆମାକା ୱିଜୁ ତାନେମାନୁ ମାର୍‌ଆତ୍‌, ଆକା ୱିଜୁ ସିତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ମାରି, ଏସୋ ସିସୁର୍‍ ମନ୍ଦିର୍‌ ବିସୟ୍‌ତାନ୍‍ ୱାର୍‍ଗି ସାଜିମାର୍‍ଆର୍ । ୱାର୍‌ ଇଜିମାର୍‌ଆର୍‌, ଇକା ଉଣ୍ତ୍ରିନେଗି ମନ୍ଦିର୍‌ । ଇକା ନେଗି କାଲ୍‍କାଣ୍‍ ତିଆର୍‌ ଆତାମାନାତ୍‌ । ସୁଡ଼ୁଦୁ ମାପୁରୁଙ୍ଗୁଁ ସିତିମାନି ନେଗି ନେଗି ବିସୟ୍‌ ସିତାମାନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","ଜିସୁ ଇର୍‌ଆନ୍‌, “ମିର୍‌ ଆମାୱିଜୁ ଇବେ ସୁଡ଼ୁଜିନିଦେର୍‍, ଦିନ୍‍ୱାନାତ୍‍, ଏସ୍ତିୱାଲେ ଉଣ୍ତ୍ରି କାଲୁ ମାରି ଉନ୍‌ଡ୍ରି କାଲୁ ମୁସ୍‌କୁ ତେବାଏତ୍‍ ୱିଜୁ କାଲ୍‍କୁ ଗୁଣ୍ତ୍‍ ଗୁଣ୍ତା ଆନେ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ଆବେଟ୍‌ ସିସୁର୍‍ ଜିସୁଙ୍ଗୁଁ ୱେନ୍‌ବାତାର୍‌, “ଏ ଗୁରୁ, ଆରିଙ୍ଗ୍‌ ଇୟାୱିଜୁ ଏସାଙ୍ଗ୍‍ ଗଟାନାତ୍‌ ? ମାରି, ଏମେ ଦିନ୍‍ତୁ ଇୟାୱିଜୁ ଗଟ୍‍ନା ଇଗାୱାନାତ୍‌, ଆୟାଦିନ୍‍ତି ସିନା ଇନିକା ?” ");
INSERT INTO kfcp_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ଆବେଟ୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଜାଗାର୍‌ତା, ମିର୍‌ ଏଣ୍ତେସ୍ ବାୟା ଆମାଟ୍‌; ଇରିଙ୍ଗ୍‌ ଏସୋ ଲୋକୁ ନା ଦର୍‌ତାନ୍‌ ୱାଜି, ନାନ୍ ଜିସୁ ମାରି ଦିନ୍‌ ଇଗା ୱାତାତ୍‍ ଇଜି ଇନାର୍‌; ୱାରି ୱେନ୍‌କା ସଲ୍‍ମାଟ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ମାତର୍‌ ମିର୍‌ ଏସ୍ତିୱାଲେ ଜୁଦ୍‍ ମାରି ଲୋକୁ ଡାକ୍‍ସିସାନି ଆଉଲି ୱେନିଦେର୍‍, ନାସ୍ତିୱାଲେ ତିଲାମାଟ୍‌; ଇରିଙ୍ଗ୍‌ ଇୟାୱିଜୁ ସତେନେ ଆଗ୍‌ଡ଼ି ଗଟାନାତ୍‍, ମାତର୍‌ ଆୟାଦାପ୍ରେ ଜୁଗ୍‍ ସେସ୍‌ ଆଏଦେ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ଆବେଟ୍‌ ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଜାତି ବିରଦ୍‌ତାନ୍‌ ଜାତି ଲୋକା ଲୋଇ ଜୁଦ୍‍ କିନାର୍‍ ମାରି ଦେସ୍‌ ବିରଦ୍‌ତାନ୍‌ ଦେସ୍‍ ଲୋଇ ଜୁଦ୍‍ କିନାର୍, ");
INSERT INTO kfcp_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ମାରି ନାଣ୍ତ ବୁମିକମ୍ପ ଆନାତ୍‌ ମାରି ବାଡି ବାଡିଆଙ୍ଗାଁ ମର୍‌ଡି ଆନାତ୍‌ ମାରି ଲୋକାଙ୍ଗ୍‌ ଉଣିକା ପୁଟ୍‌ଏତ୍‌, ମାରି ବାଦଡ଼୍‍ତୁ ବୟ୍‌ଙ୍କାର୍‌ ତର୍‌ନାତ୍‌ ମାରି ପେରି ପେରି ସିନେଙ୍ଗ୍‍ ତରାନେ । ");
INSERT INTO kfcp_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ମାତର୍‌ ଇୟାୱିଜୁ ଗଟାନି ଆଗ୍‌ଡ଼ି ଲୋକୁ ମିଙ୍ଗିଁ ଆସ୍‌ନାର୍‌ ମାରି ପାର୍‌ତନା ଇଲୁଦୁ ମାରି ଜଇଲ୍‍ତୁ ମିଙ୍ଗିଁ ପୋକ୍‌ସି କାସ୍ଟୁ ସିନାର୍‍, ମାରି ନା ଦରତି ଉଣ୍ତିଙ୍ଗ୍‌ ମିଙ୍ଗିଁ ରାଜା ନି ସାସନ୍‌କିନି ଲୋକା ଆଗ୍‌ଡ଼ି ଅନାର୍‍; ");
INSERT INTO kfcp_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ମାତର୍‌ ଇକା ମିଙ୍ଗିଁ ନା ବିସୟ୍‌ତାନ୍‌ ଲୋକାଙ୍ଗ୍‌ ନେଗିକାବୁର୍‌ ସାକି ସିଦେଙ୍ଗ୍‍ ଇଜି ସାରି ପୟ୍‌ନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ମାରି ନିଜେଦି ତରିଟାନ୍‍ ଇନିକା ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆନାତ୍‌, ଆୟା ବିସୟ୍‌ତାନ୍‌ ଆଗ୍‍ଡ଼ିରାନ୍‍ ସିନ୍ତା କିଇ ନିଜେ ନିଜେଦି ମୋନ୍‌ତୁ ତିର୍‌ କିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ଇରିଙ୍ଗ୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଇୟାୱାଜା ମାଟା ନି ବୁଦି ସିନା ଜେ, ମି ୱିଜୁ ସାତ୍ରୁ ଲୋକୁ ଆବେ ଆଙ୍ଗ୍‌ଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ମାତର୍‌ ମିଙ୍ଗିଁ ମି ବୁବାୟାୟା, ତଡ଼ାନ୍‌, ନିଜେଦି ଲୋକୁ ମାରି ସାମ୍‍ନ୍ଦିବନ୍ଦୁର୍‌ ସାତ୍ରୁରି କିୟୁଦୁ ସର୍‍ପେ କିନାସିନାର୍‍, ମାରି ମି ଲୋଇ ଲୋକୁ ଏଙ୍ଗ୍‍ ଏଙ୍ଗ୍‍ କାତ୍‍ନାର୍‍, ");
INSERT INTO kfcp_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ମାରି ନାବାନ୍‍ ମିର୍‌ ବିସ୍‌ବାସ୍‌ କିତିମାନି ଉଣ୍ତିଙ୍ଗ୍‌ ଲୋକୁ କାଡ଼୍‍ନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ମାତର୍‌ ମି ତାଲାଦି କୁକୁଟି ବା ନାସ୍ଟୁ ଆଏତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ମିର୍‌ ସାସ୍‍ତାନ୍‍ ତେବାତିଙ୍ଗ୍‍ ନିଜେ ନିଜେଦିଙ୍ଗ୍‍ ରକିୟା କିଦେଙ୍ଗ୍‌ ଆଟ୍‌ନିଦେର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","ମାତର୍‌ ମିର୍‌ ଏସ୍ତିୱାଲେ ଜିରୁସାଲାମ୍‍ତିଙ୍ଗ୍‍ ସନ୍ୟର୍‌ ସାରିବେଡ଼୍‍ତି କାପ୍‍କିନିମାନିକା ସୁଣିଦେର୍‍, ଆୟାୱାଲେ ଆକା ୱିର୍‍ଜି ସନି ଦିନ୍‌ ଜେ ଇଗା ୱାତାତ୍‍, ଇକା ମିର୍‌ ନେସ୍‌ତୁ । ");
INSERT INTO kfcp_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ନାସ୍ତିୱାଲେ ଆମାଲୋକ୍‍ ୱିଜେରେ ଜିହୁଦା ଗାଡ଼୍‌ତୁ ମାନାର୍‌, ୱାର୍‌ ଗରନ୍‌ ମୁସ୍‌କୁ ଉରୁକ୍‍ସି ସଲିର୍‍; ମାରି, ଏର୍‌ ଗାଡ଼୍‌କାଙ୍ଗ୍‌ ତେବାନାର୍‌, ଏଣ୍ତେସ୍‌ବା ୱାର୍‌ ଗାଡ଼୍‌ ଡ଼ିସ୍‌ସି ସଲିର୍‌; ମାରି, ଏର୍‌ ଇସ୍ରିନାର୍‍କାଙ୍ଗ୍‍ ତେବାନାର୍‌, ଏଣ୍ତେସ୍‌ବା ୱାର୍‌ ଗାଡ଼୍‌ତୁ ଡ଼ୁଗ୍‍ମାକିର୍‍; ");
INSERT INTO kfcp_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ଇରିଙ୍ଗ୍‌ ରାସାତିମାନି ବିସୟୱିଜୁ ପୁରା ଆନି ଉଣ୍ତିଙ୍ଗ୍‌ ଆକା ୱିଜୁ ଦଣ୍ତତି ଦିନ୍‌ ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ଆୟା ସମୟତୁ ପଟାଦୁମାନି ଆଇମାଲୋକ୍‍ ମାରି ଇସ୍ରି କଡ଼ରିଙ୍ଗ୍‌ ଆସ୍‌ସି ପାଲ୍‍ ଉଟ୍‍ପିସ୍‍କିଜିମାନି ଆଇସିକା ଅବସ୍ତା ଏସ ତାଗ୍‌ଇକା ଆନାତ୍‌, ୱାକ୍‍ ନାଣ୍ତ ଦୁଃକ୍‌ ପୟ୍‍ନେ ! ଇରିଙ୍ଗ୍‌ ଦେସ୍‍ତୁ ନାଣ୍ତ ଦୁଃକ୍‌କାସ୍ଟୁ ୱାନାତ୍‌ ମାରି ମାପୁରୁଦି ଦଣ୍ଡ୍‌ ଇୟା ଜାତି ମୁସ୍‌କୁ ୱାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ମାରି ୱାର୍‌ କୁଡ଼ାମ୍‍କାଣ୍‍ ସାନାର୍‍ ମାରି ତର୍‍ଆୟ୍‌ ଆଜି ଆଇଜାତିଦି ଲୋଇ ପୋକ୍‌ନାର୍‌, ମାରି ଅଣଜିହୁଦି ଲୋକା ଦିନ୍‌ ୱିଜ୍‌ଇ ସାନ୍ଦି ଜିରୁସାଲାମ୍‍ ୱାରି କାଲ୍‌କୁ ଆଡ୍‍ଗି ତେବାନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“ମାରି ୱେଡ଼ା, ଲେଞ୍ଜୁ ନି ସୁକେଙ୍ଗାଁଙ୍ଗ୍‍ ସିନେଙ୍ଗ୍‍ ତରାନେ, ମାରି ଦୁନିଆଦୁ ଜାତିଦି ଲୋକା ଲୋଇ ବାଦା ୱାନାତ୍‌; ସାମ୍‌ଦୁରୁ ମାରି ଏରୁଗାତିସ୍‌ୱାନି ଆଉଲିଦିଙ୍ଗ୍‌ ୱାର୍‌ ବାୟାବେମ୍‍ରି ଆନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ମାରି ଦୁନିଆଦି ମୁସ୍‌କୁ ୱାଜିମାନି ଗଟନା ୱିଜୁଦିଙ୍ଗ୍‌ କାପ୍‍କିଜି ଲୋକୁ ୱିଜେରେ ମୁର୍ସା ଆନାର୍‌, ଇରିଙ୍ଗ୍‌ ବାଦଡ଼୍‍ତି ସାକ୍ତିୱିଜୁ ଦୁଙ୍ଗ୍‍ନେ ସନେ । ");
INSERT INTO kfcp_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ନାସ୍ତିୱାଲେ ଲୋକୁ ମନୁସ୍ୟପୁତ୍ରଦିଙ୍ଗ୍‍ ନାଣ୍ତ ସାକ୍ତିଦାନ୍‍ ମାରି ନାଣ୍ତ ମହିମାଦି ୱାଲେ ବାଦଡ଼୍‍ତାନ୍‍ ୱାନିକା ସୁଣାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ମାତର୍‌ ଇୟାୱିଜୁ ଗଟେନେଙ୍ଗ୍‍ ଆରାମ୍ଆତିଙ୍ଗ୍‍ ମିର୍‌ ମୁସ୍‌କୁ ସୁଡ଼ୁଦୁ ମାରି ତାଲା ପେର୍‍ଦୁ, ଏଣ୍ତେସ୍‍କି ମି ରକିୟା ପଇନିକା ଲାକ୍‌ତୁ ଇଗା ୱାତାତ୍‌ନି ।” ");
INSERT INTO kfcp_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ମାରି, ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଉଣ୍ତ୍ରି କାତା ଇର୍‌ଆନ୍‌, “ତଗା ମାରାନ୍‌, ମାରି ଆଇ ୱିଜୁ ମାରାକା ବିସୟ୍‌ତାନ୍‌ ଅଡ଼୍‍ବିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ଏସ୍ତିୱାଲେ ଆୟା ମାରାକା ଆକ୍‍ ପୁନାକାୟ୍‍ନେ, ନାସ୍ତିୱାଲେ ମିର୍‌ ଆକା ସୁଡ଼ୁଜି ଜେଟାପ୍‌ ଲେଞ୍ଜୁ ଇଗା ୱାତାତ୍‌ନି ଇଜି ନିଜେନିଜେ ନେସ୍‌ନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ଆୟାୱାଜା ମିର୍‌ ବା ଇୟାୱିଜୁ ଗଟନା ସୁଡ଼ୁତିଙ୍ଗ୍‌ ମାପୁରୁଦି ରାଜି ଜେ ଇଗା ୱାତାତ୍‍, ଇକା ନେସ୍‌ତୁ । ");
INSERT INTO kfcp_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ଇଜିନା, ଇୟାୱିଜୁ ଗଟେଆଇ ସାନ୍ଦି ଇୟା ଦିନ୍‌ତି ଲୋକୁ ଏଣ୍ତେସ୍‌ ୱିଜ୍‌ଏର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ବାଦଡ଼୍‍ ନି ଦୁନିଆ ୱିଜ୍‌ନାତ୍‌, ମାତର୍‌ ନା ବାକ୍ୟୱିଜୁ ଏସାଙ୍ଗ୍‍ ବା ୱିଜ୍‍ଏତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“ମାତର୍‌ ମିର୍‌ ନିଜେ ନିଜେଦି ବିସୟ୍‌ତାନ୍‌ ଜାଗାର୍‌ତା ମାଡ୍ରୁ, ଏସ୍ତିୱାଲେ ମି ଜିବନ୍‌ ନାଣ୍ତ ୱେଡ଼ିକାଦୁ ପୁରା ତେବାନାତ୍‍ ମାରି କାଡ଼ୁଉଣ୍‍ଜିସସ୍‌ତେଙ୍ଗ୍‍, ମାରି ଜିନି ବିସୟ୍‌ତାନ୍‌ ସିନ୍ତାଦାନ୍‌ ଦୁଃକ୍‌ ୱାନାତ୍‌, ମାରି ଆୟାନାଣ୍ତିଙ୍ଗ୍‌ ଦାପ୍ରେ ମି ମୁସ୍‌କୁ ୱାନା ଆର୍‍ନାତ୍‍; ");
INSERT INTO kfcp_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ଇରିଙ୍ଗ୍‌ ଆକା ଜାଡ଼ିଦି ୱାଜା ୱିଜୁ ଦେସ୍‍ଦୁନିଆଦି ୱିଜୁ ଲୋକା ମୁସ୍‌କୁ ୱାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ମାତର୍‌ ମିର୍‌ ଏଣ୍ତେସ୍‌କି ଇୟାୱିଜୁ ୱାଜିନିଆଗ୍‍ଡ଼ି ଗଟ୍‌ନାଦାନ୍‌ ରକିୟା ପୟ୍‌ଦେଙ୍ଗ୍‍ ମାରି ମନୁସ୍ୟପୁତ୍ରଦି ଲାକ୍‌ତୁ ନିନ୍‍ଡ୍ରେଙ୍ଗ୍‍ ଡାଟ୍‍ ଆଦୁ, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ଦିନାମି ପାର୍‌ତନା କିଜି ଜାଗାର୍‌ତା ମାଡ୍ରୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ଜିସୁ ୱିଜୁଦିନ୍‌ ମନ୍ଦିର୍‌ତୁ ସିକିୟା ସିଜିମାର୍ହାନ୍‍, ମାରି ୱିଜୁ ନାଡ଼ା ସହସି ସଲ୍‍ସି ଜିତ ଗରନ୍‌ତୁ ତେବାଜି ମାର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ମାରି, ୱିଜେରେ ଲୋକୁ ମନ୍ଦିର୍‌ତୁ ୱାନି ସିକିୟା ୱେନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଇଜି ସାଲ୍‍ଦି ୱାନି ଲାକ୍‌ତୁ ୱାଜି ମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ନିସ୍ତାର୍‌ ପଣ୍ତ୍‌ୟ ଇନି କମିର୍‌ସିଲି ରୁଟିଦି ପଣ୍ତ୍‌ୟ ଲାକ୍‌ତୁ ଆଜି ୱାଜିମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ମାରି, ପେରି ଜାଜକର୍‌ ନି ସାସ୍ତ୍ରିର୍‍, ଏଣ୍ତେସ୍‌ ଜିସୁଙ୍ଗୁଁ ଏନ୍‌ ନେସ୍‌ଏଣ୍‌ଗା ସାୟାମାର୍‌ଗା ଡାକ୍‌ତେଙ୍ଗ୍‍ଁ ଆଟ୍‍ନାର୍‍, ଆବେଣି ଉପାୟ୍‌ ପଇଜି ମାର୍ହାର୍‌, ମାତର୍‌ ୱାର୍‌ ଲୋକାଙ୍ଗ୍‌ ତିଲାଜି ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ନାସ୍ତିୱାଲେ ବାରଲୋକ୍‌ ସିସୁରି ଲୋଇରାନ୍‌ ଇସ୍କାରିୟୋତିୟ ଦର୍‌ତି ଅରେନ୍‍ ଜିହୁଦାମାନୁ ସୟତାନ୍ ଡ଼ୁଗିତାତ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ମାରି, ଜିହୁଦା ସୋର୍‌ଆନ୍‌ନୋ, ଇନି ଉପାୟ୍‌ତାନ୍‌ ୱାନିଙ୍ଗ୍‌ ପେରି ଜାଜକ ନି ସେନାପତିରି କିୟୁଦୁ ସପ୍ରେ କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାନ୍‍, ଆକା ୱାରି ୱାଲେ ୱାର୍‌ଗିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ଆବେଟ୍‌ ୱାର୍‌ ୱେଡ଼ିକା ଆଜିମାରି ୱାନିଙ୍ଗ୍‌ ଡାବୁଙ୍ଗୁଁ ସିଦେଙ୍ଗ୍‍ ଇଜି ପାର୍‌ମାଣ୍‌ କିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ମାରି, ଜିହୁଦା ରାଜି ଆତାନ୍‌ନୋ ଲୋକ୍‌ ୱିଜେରେ ଅରେନ୍‍ବା ସିଲିୱାଲେ ୱାନିଙ୍ଗ୍‌ ୱାରି କିୟୁଦୁ ସପ୍ରେ କିଜି ସିନି ଉଣ୍ତିଙ୍ଗ୍‌ ସାରି ପ‍ଇଦେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ୱେନ୍‌କା ଏମେ ନାଣ୍ତିଙ୍ଗ୍‌ ନିସ୍ତାର୍‌ ପଣ୍ତୟ୍‌ତି ମେଣ୍ତାପିଲେକାଙ୍ଗ୍‌ କାତ୍‌ତେଙ୍ଗ୍‌ ଆନାତ୍‌, ଆୟା କମିର୍‌ସିଲି ରୁଟି ପଣ୍ତ୍‌ୟ ନାଣ୍ତିଙ୍ଗ୍‌ ୱାତାତ୍‍; ");
INSERT INTO kfcp_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ମାରି, ଜିସୁ ପିତର୍‌ ନି ଜୋହନତିଙ୍ଗ୍‌ ଇକା ଇନ୍‌ଞ୍ଜି ପୋକ୍‌ତାନ୍‌, “ମାଡ୍‌ ଏଣ୍ତେସ୍‌ ଉଣ୍ତେଙ୍ଗ୍‌ ଆଟ୍‍ନିକା, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ମିର୍‌ ସୋଲ୍‌ସ ମା ଉଣ୍ତିଙ୍ଗ୍‌ ନିସ୍ତାର୍‌ ପଣ୍ତ୍‌ୟତି ବୋଜି ତିଆର୍‌ କିଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ଆବେଟ୍‌ ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ୱେନ୍‌ବାତାର୍‌, “ମାପ୍‌ ଇକା ଏମେ ବାଡିଦୁ ତିଆର୍‌ କିନାପ୍‍ ଇଜି ନିନ୍‌ ବଦା କିଜିନି ?” ");
INSERT INTO kfcp_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ସୁଡ଼ୁଦୁ, ମିର୍‌ ଗାଡ଼୍‌ତୁ ଡ଼ୁଗିତିଙ୍ଗାଁ, ଏରୁସାଟିଦୁ ଅସିମାନିକାତ୍‌ ଅରେତ୍‌ ଲୋକୁ ମିଙ୍ଗିଁ ବେଟ୍‌ଆନାତ୍‌; ୱାଦ୍‌ ଏମେ ଇଣ୍ତ୍ର ସନ୍‌ନାତ୍‌, ତାନି ୱେନ୍‌କା ୱେନ୍‌କା ଆୟା ଇଣ୍ତ୍ର ସୋଲ୍‌ସ ଇଲୁଦି ପେରିୱାନିଙ୍ଗ୍‌ ଇନିଦେର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ଗୁରୁ ନିଙ୍ଗିଁ ୱେନ୍‌ବାଜିନାନ୍‌, ନାନ୍ ନା ସିସୁରି ୱାଲେ ଏମେମାନୁ ନିସ୍ତାର୍‌ ପଣ୍ତ୍‌ୟତି ବୋଜି କିନାପ୍‌, ଆୟା କୁଡ଼ାଆଙ୍ଗ୍‍ଁ ତେବାନି ବାକାର୍‌ ଆମାକା ? ");
INSERT INTO kfcp_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ଆବେଟ୍‌ ୱାନ୍‌ ମିଙ୍ଗିଁ ନେଗେନ୍‌ ସଜେ କିତିମାନି ଉଣ୍ତ୍ରି ମୁସ୍‌କୁରି ମୋହଲାଦି ପେରି ବାକ୍‍ରା ତର୍‌ନାସିନାନ୍‌; ଆୟାବାଡିଦୁ ବୋଜି ତିଆର୍‌ କିଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ମାରି, ପିତର୍‌ ନି ଜୋହନ ସର୍‌ଆର୍‌ନୋ, ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଏଣ୍ତେସ୍‌ ଇର୍‌ଆ ମାର୍‌ଆନ୍‌, ଆୟାୱାଜା ସୁଡ଼ୁଜି ନିସ୍ତାର୍‌ ପଣ୍ତ୍‌ୟତି ବୋଜି ତିଆର୍‌ କିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ମାରି, ୱାର୍‌ ନିସ୍ତାର୍‌ ପଣ୍ତ୍‌ୟତି ବୋଜି ଉଣି ସମୟ ଆତାତ୍‌, ଜିସୁ ନି ୱାନି ୱାଲେ ପ୍ରେରିତ ସିସୁର୍‍ ଉଣ୍ତେଙ୍ଗ୍‌ ବାସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ନାନ୍ ନା ଦୁକ୍‍ବଗାନି ଆଗିଡ଼ିନେ ନାନ୍ ମି ୱାଲେ ଅର୍‌ସେ ଇୟା ନିସ୍ତାର୍‌ ପଣ୍ତ୍‌ୟତି ବଜି ଉଣ୍ତେଙ୍ଗ୍‌ ଅରେନେ ବଦା କିତାମାର୍‌ଆ; ");
INSERT INTO kfcp_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ମାତର୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ମାପୁରୁଦି ରାଜିଦୁ ଇୟା ଅର୍ତ ପୁରା ଆଇ ସାନ୍ଧି ନାନ୍ ମାରି ଏସ୍‌କାଙ୍ଗ୍‌ବା ନିସ୍ତାର୍‌ ପଣ୍ତ୍‌ୟତି ବଜି ମାରି ଉଣୁଏ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ମାରି, ଜିସୁ ଉଣ୍ତ୍ରି କୁଡ଼ୁକାଦୁ ଅଙ୍ଗୁର୍‍ରସ୍‍ ଅତାନ୍‌ନୋ ମାପୁରୁଙ୍ଗୁଁ ଦନ୍ୟବାଦ୍‌ ସିଜି ଇର୍‌ଆନ୍‌, “ଇୟା କୁଡ଼ୁକା ଅସି, ଇବେନ୍‌ ମାନି ଅଙ୍ଗୁର୍‍ରସ୍‌ତିଙ୍ଗ୍‌ ନିଜେ ନିଜେଦି ମାନୁ ବାଟା କିଦୁ, ");
INSERT INTO kfcp_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ମାତର୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ମାପୁରୁଦି ରାଜି ରେଇ ସାନ୍ଦି ଇକା ନାନୁ ମାରି ଇୟା ଅଙ୍ଗୁର୍‍ରସ୍‍ ଉଣୁଏ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ମାରି, ୱାନ୍‌ ରୁଟି ଅତାନ୍‌ନୋ ମାପୁରୁଙ୍ଗୁଁ ଦନ୍ୟବାଦ୍‌ ସିତାନ୍‌ ମାରି ରୁଟି ରୁକ୍‍ସି ସିଜି ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମି ଉଣ୍ତିଙ୍ଗ୍‌ ସିଆତିମାନି ଇକା ନା ମେନ୍ଧଲ୍‍; ନାଙ୍ଗିଁ ଏତ୍‌କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ଇକା କିଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ଉଟି ୱିସ୍‌ତି ୱେନ୍‌କା ଆୟାୱାଜା ୱାନ୍‌ ଅଙ୍ଗୁର୍‍ ରସ୍‌ତି ଉଣି ଡୁବାଇ ଆସ୍‌ତାନ୍‌ନୋ ଇର୍ହାନ୍‌, ଇୟା ଅଙ୍ଗୁର୍‍ରସ୍‍ ମି ଉଣ୍ତିଙ୍ଗ୍‌ ସିଆତିମାନି ନା ନେତେର୍‌ତି ପୁନି ନିୟମ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","ମାତର୍‌ ସୁଡ଼ୁଦୁ, “ଏନ୍‌ ନାଙ୍ଗିଁ ସାତ୍ରୁରିକିୟୁଦୁ ସର୍‍ପେ କିଜିନାନ୍‌, ୱାନି କିୟୁ ନା ୱାଲେ ଟେବୁଲ୍‌ ମୁସ୍‌କୁ ମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ମାତର୍‌ ମାପୁରୁ ଏଣ୍ତେସ୍‌ ଆତାମାନାତ୍‌ କିତାମାନାନ୍‌, ମନୁସ୍ୟପୁତ୍ର ଜେ ନାନ୍ ଆୟାୱାଜା ସାନି ଦଣ୍ଡ୍‌ ପଇନା ସତ୍‌, ମାରି ଏମେ ଲୋକୁ ମାଣ୍‌କୁ ୱାନ୍‌ ସାତ୍ରୁରିକିୟୁଦୁ ସର୍ପେ ଆଜିନାନ୍‍, ଚି, ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ଇକା ନାଣ୍ତ୍ କାରାବ୍‍ ଆନାତ୍‌ !” ");
INSERT INTO kfcp_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ତାନେ ୱେନ୍‌କା ମା ଲୋଇରାନ୍‌ ଏନ୍‌ ଇକା କିଦେଙ୍ଗ୍‌ ସଲ୍‌ସିନାନ୍‌, ଆୟା ବିସୟ୍‌ତାନ୍‌ ସିସୁର୍‍ ନିଜେ ନିଜେଦିମାନୁ ୱେନ୍‌ବାଜି ସାଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ମାରି, ସିସୁରି ଲୋଇ ଏନ୍‌ ପେରିକାନ୍‌ ଇଜି ୱେଙ୍ଗ୍‌ଁନାନ୍‌, ଆୟା ବିସୟ୍‌ତାନ୍‌ ୱାରିୱାରି ଲୋଇ ୱାରିଗିଜି ସାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ଆବେଟ୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ଅଣଜିହୁଦି ରାଜାର୍‌ ୱାରି ମୁସ୍‌କୁ ସାସନ୍‍ କିନାର୍‌, ମାରି ଏର୍‌ ୱାରି ମୁସ୍‌କୁ ସାସନ୍‍ କିନିକା ମାନାତ୍‌, ୱାର୍‌ ଦେସ୍‍ତି ସାଙ୍ଗ୍‍ ଇଜି ୱେଙ୍ଗ୍‌ଁନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ମାତର୍‌ ମିର୍‌ ଆୟାୱାଜା ଆମାଟ୍‌, ଇରିଙ୍ଗ୍‌ ମି ମାଣ୍‌କୁ ଏନ୍‌ ପେରିକାନ୍‌, ୱାନ୍‌ ୱିଜେରି ମାଣ୍‌କୁ ଇସ୍ରିକାନ୍‌ ୱାଜା ଆପିନ୍‌, ମାରି ଏନ୍‌ ନେତା ମାନାନ୍‌, ୱାନ୍‌ ସେବାକିନି ୱାନି ୱାଜା ଆପିନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ମାତର୍‌ ୱିଜେରି ମାଣାନ୍‌ ପେରି ଲୋକୁ ଏନ୍‌ ? ଏନ୍‌ ଉଣ୍ତେଙ୍ଗ୍‌ ବାସ୍‌ତିମାନିକାର୍‌ ନୋ ୱାନିଙ୍ଗ୍‌ ୱେର୍‌ସିମାନି ଲୋକୁ ? ମିର୍‌ ଅଡ଼୍‍ବିନିଦେର୍‍ ଜେ ଉଣ୍ତେଙ୍ଗ୍‌ ବାସ୍‌ତିମାନି ଲୋକୁ, ୱାନ୍‌ ଇନିକା ପେରିକାନ୍‌ ଆଏନ୍‍ ? ଇରିଙ୍ଗ୍‌ ନାନ୍ ମି ଲୋଇରାନ୍‌ ଅରେନେ ସେବାକିନିୱାନି ୱାଜା ମାନା । ");
INSERT INTO kfcp_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","ମାତର୍‌ ମିର୍‌ ନା ୱିଜୁ ପରିକାଦୁ ନା ୱାଲେ ମାନ୍‌ଞ୍ଜିୱାଜିନିଦେର୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ନା ବୁବା ଏଣ୍ତେସ୍‌ ନା ଉଣ୍ତିଙ୍ଗ୍‌ ରାଜି ତିଆର୍‌ କିତାନ୍‌, ନାନ୍ ବା ଆୟାୱାଜା ମି ଉଣ୍ତିଙ୍ଗ୍‌ ତିଆର୍‌ କିଜିନା, ");
INSERT INTO kfcp_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ଏଣ୍ତେସ୍‌ ମିର୍‌ ନା ରାଜିଦୁ ନା ଟେବୁଲ୍‌ ମୁସ୍‌କୁ ଉଣିତିନିଦେର୍‌, ମାରି ମିର୍‌ ରାଜାବାସ୍‌ନିଗୋଦିଦି ମୁସ୍‌କୁ ବାସ୍‌ନିଦେର୍‌ନୋ ଇସ୍ରାଏଲ୍‌ତି ବାରଗୋଟା କୁଟୁମ୍‌ତି ମୁସ୍‌କୁ ସାସନ୍‍ କିନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“ସିମୋନ, ସିମୋନ, ସୁଡ଼ୁଆ, ପାଣିକିନିକାନ୍‌ ଗଦ୍‍ମୁଦାନ୍‍ ସପାଦିଙ୍ଗ୍‍ ୱେର୍‌ଏ କିଦେଙ୍ଗ୍‌ ଇଜି ସୋଲିଦୁ ଜଲ୍‍ପ୍‍ନି ୱାଜା ନେଗି ଲୋକାମାଣ୍‌କୁ ତାଗ୍‍ଇ ଲୋକାଙ୍ଗ୍‌ ୱେର୍‌ଏ କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ସୟତାନ୍ ମିଙ୍ଗିଁ ପରିକା କିଦେଙ୍ଗ୍‌ ସାରିପୋଇତା ମାନାତ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ମାତର୍‌ ମି ବିସ୍‌ବାସ୍‌ ଏଣ୍ତେସ୍‌ ମାର୍‌ଗେଏତ୍‌, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ମି ଉଣ୍ତିଙ୍ଗ୍‌ ପାର୍‌ତନା କିତାମାନା; ମାରି, ନିନ୍‌ ଡ଼େସି ୱାତି ୱେନ୍‌କା ନିଜେଦି ତଡ଼ାନ୍‌କାଙ୍ଗ୍‌ ସାକ୍ତି କିଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ମାତର୍‌ ପିତର୍‌ ଜିସୁଙ୍ଗୁଁ ୱେର୍‌ତାନ୍‌, “ଏ ପ୍ରବୁ, ନାନ୍ ନି ୱାଲେ ଜଇଲ୍‌ତୁ ସଣ୍ଡ୍ରେଙ୍ଗ୍‌ ମାରି ସାନିଦଣ୍ତ୍‌ ପ‍ଇଦେଙ୍ଗ୍‌ ବା ତିଆର୍‌ ଆତାମାନା ।” ");
INSERT INTO kfcp_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ମାତର୍‌ ଜିସୁ ୱେର୍‌ତାନ୍‌, “ଏ ପିତର୍‌, ନାନ୍ ନିଙ୍ଗିଁ ଇଜିନା, ନେର୍‌ ନାଡ଼ା କରୁ କେଡ଼ିଇ ଆଗ୍‍ଡ଼ିନେ ନିନ୍‌ ନାଙ୍ଗିଁ ମୁଜା ନେସେଏ ଇଜି ଇନି ।” ");
INSERT INTO kfcp_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ତାନେ ୱେନ୍‌କା ଜିସୁ ସିସୁରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ଏସ୍ତିୱାଲେ ନାନ୍ ମିଙ୍ଗିଁ ଡାବୁଙ୍ଗୁଁ ମଣି, ମଣି ମାରି ଜୁତେଙ୍ଗ୍‌ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ପୋକ୍‌ତା ମାର୍‌ଆ, ନାସ୍ତିୱାଲେ ମିଙ୍ଗିଁ ଇନିକା ଉଣା ମାର୍‌ଆତ୍‌ ? ୱାର୍‌ ଇର୍ହାର୍‌, ଇନିକା ସିଲେ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ଆବେଟ୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ମାତର୍‌ ଇଲେ, ଆମାୱାନିଦି ଡାବୁଙ୍ଗୁଁ ଇଡ୍‌ନି ମଣି ମାନାତ୍‌, ୱାନ୍‌ ଆକା ଅପିନ୍‌, ଆୟାୱାଜା ମଣି ବା ଅପିନ୍‌, ମାରି ଆମାୱାନିଙ୍ଗ୍‌ କୁଡ଼ାମ୍‍ ସିଲେତ୍‌, ୱାନ୍‌ ନିଜେଦି ସାଦର୍‌ ଉଣ୍ତ୍ରି ପୋର୍‌ଜ କାଣ୍ତା କଡ଼ିନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ମାତର୍‌ ନାନ୍ ମିଙ୍ଗିଁ ୱେର୍‌ସିନା, ୱାନ୍‌ ପାପିଲୋକା ୱାଲେ ମିସାତାନ୍‌, ଇୟା ଏମେ ବାକ୍ୟ ରାସ୍‌ତା ମାନାତ୍‌, ଆକା ନା ମାନୁ ପୁରା ଆନିକା ମାନାତ୍‌; ଆଦେଙ୍ଗ୍‌ ନା ବିସୟତି ମାଟା ପୁରା ଆଜିନାତ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ଆବେଟ୍‌ ୱାର୍‌ ଇର୍ହାର୍‌, “ପ୍ରବୁ, ସୁଡ଼ୁଆ, ଇବେନୁ ରୁଣ୍ତି କାଣ୍ତେଙ୍ଗ୍‌ ମାନେ ।” ମାରି, ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ରୁଣ୍ତି କାଣ୍ତେଙ୍ଗ୍‌ ନାଣ୍ଡ୍ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ଜିସୁ ଗାଡ଼୍‌ତାନ୍‍ ସୋତା ସୋର୍‌ଆନ୍‌ନୋ ନିଜେଦି ଦିନ୍‍କେରିୱାଜା ଜିତ ଗରନ୍‌ ମୁସ୍‌କୁ ସୋର୍‌ଆନ୍‌, ମାରି ସିସୁର୍‍ ବା ୱାନି ୱାଲେ ୱାଲେ ସୋର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ଆୟା ବାଡିଦୁ ଇତାର୍‌ରୋ ଜିସୁ ସିସୁରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ପରିକାଦୁ ଏଣ୍ତେସ୍‌ ଆର୍‌ଇଦେର୍‌, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ପାର୍‌ତନା କିଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ମାରି, ୱାନ୍‌ ୱାରିମାଣ୍‌କୁ କାଣ୍ତେକ୍‍ ଆକ ସୋର୍‌ଆନ୍‌ନୋ ମେଣ୍ତେଙ୍ଗ୍‌ ଗୋଟ୍‌ କିଜି ପାର୍‌ତନା କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ଏ ବୁବା, ଜଦି ନି ବଦା ମାନାତ୍‌, ଆୟା ଦୁଃକ୍‍ ନି କାସ୍ଟୁଦି ସାଟି ଆକ କିଆ; ଆରିଙ୍ଗ୍‌ ନା ବଦା ସିଲେ, ମାତର୍‌ ନି ବଦା ସତ୍‌ ଆପିତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ମାରି, ମୁସ୍‌କୁପୁର୍‌ତାନ୍‌ ଅରେନ୍‍ ଦୁତ୍‍ ଦର୍ସନ୍‍ ସିଜି ୱାନିଙ୍ଗ୍‌ ସାକ୍ତି ସିତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ମାରି, ଜିସୁ ନାଣ୍ତ ଦୁଃକ୍‍ ଆଜି ଉଣ୍ତ୍ରି ମନ୍‍ତାନ୍‍ ପାର୍‌ତନା କିଦେଙ୍ଗ୍‌ ଅତାନ୍ ମାରି ୱାନି ରୁନୁ ନେତେର୍‌ ଟିପା ୱାଜା ବୁମିଦୁ ୱାଙ୍ଗିଁତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ମାରି, ୱାନ୍‌ ପାର୍‍ତନା କିନିମାଣାନ୍‍ ନିଙ୍ଗିଁଜି ସିସୁରି ଲାକ୍‌ତୁ ୱାଜି ୱାରିଙ୍ଗ୍‌ ଦୁଃକ୍‍ ଉଣ୍ତିଙ୍ଗ୍‌ ସୁଜ୍‍ନିକା ସୁଡ଼ୁତାନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ମାରି, ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଏନ୍ଦା ସୁଜ୍‍ଜିନିଦେର୍‌ ? ପରିକାଦୁ ଏଣ୍ତେସ୍‌ ଆର୍‌ଇଦେର୍‌, ଆୟା ଉଣ୍ତିଙ୍ଗ୍‌ ନିଙ୍ଗ୍‍ଜ ପାର୍‌ତନା କିଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ଜିସୁ ୱାର୍‍ଗିନିୱାଲେ, ସୁଡ଼ୁଦୁ, ଲୋକୁ ୱିଜେରେ ୱାଜି ଉଣ୍ତାତାର୍‌, ମାରି ବାରଲୋକ୍ ସିସୁରି ଲୋଇରାନ୍‌ ଜିହୁଦା ଦର୍‌ତି ଅରେନ୍‍ ୱାରି ଆଗ୍‌ଡ଼ି ଆଗ୍‌ଡ଼ି ୱାଜି ଜିସୁଙ୍ଗୁଁ ନଣ୍ତ୍‍ଦେଙ୍ଗ୍‍ ଇଜି ୱାନି ଲାକ୍‌ତୁ ସର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ମାତର୍‌ ଜିସୁ ଜିହୁଦେଙ୍ଗ୍‍ ଇର୍‌ଆନ୍‌, “ଏ ଜିହୁଦା, ମନୁସ୍ୟପୁତ୍ରଦିଙ୍ଗ୍‍ ନଣ୍ତ୍‍ଜି ନୋ ସାତ୍ରୁରି କିୟୁଦୁ ସର୍‌ପେ କିଜି ସିଜିନି ?” ");
INSERT INTO kfcp_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ଇବେଟ୍‍ ଇନିକା ଆନାତ୍‌, ଆକା ସୁଡ଼୍‌ଜି ୱାନି ତଡ଼୍‍କୁ ଇର୍ହାର୍‌, “ପ୍ରବୁ, ମାପ୍‌ ଇନିକା କାଣ୍ତାଦାନ୍‍ କାତ୍‍ନାପ୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ମାରି, ୱାରି ଲୋଇ ଅରେନ୍‍ ୱିଜେରିଙ୍ଗ୍‌ପେରି ଜାଜକ୍‍ତିମାନୁ ପାଣିକିନି ଗତିମୁରୁଲିଦି ଉଣେରି ଗିତଣି କୟାତା ପୋକ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ମାତର୍‌ ଜିସୁ ଇର୍‌ଆନ୍‌, “ନିସନେ ଆନାତ୍‍ଲେ; ମାରି, ୱାନ୍‌ ୱାନି ଗିତଣି ମୁଟ୍‍ସି ୱାନିଙ୍ଗ୍‌ ନେଗେଣ୍ତ୍‍ କିତାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ମାରି, ଜିସୁ ୱାନି ବିରଦ୍‌ତାନ୍‌ ୱାତି ମାର୍‍ଇ ପେରି ଜାଜକ, ମନ୍ଦିର୍‌ତି ପେରି ପେରିକାର୍‌ ମାରି ପେରି ଡକ୍ରାରିଙ୍ଗ୍‍ ଇର୍‌ଆନ୍‌, “ଡଙ୍ଗାଁର୍‍ଏନ୍‍ ବିରଦ୍‌ତାନ୍‌ ସନିୱାନିୱାଜା କାଣ୍ତା ନି ଡୁଡୁ ଆସ୍‌ସି ମିର୍‌ ଇନିକା ସତିୱାତିଦେର୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ନାନ୍ ଦିନାମି ମିୱାଲେ ମନ୍ଦିର୍‌ତୁ ମାନିୱାଲେ ମିର୍‌ ନା ବିରଦ୍‌ତାନ୍‌ କିୟୁ ପେର୍‍ଇତିଦେର୍‍, ମାତର୍‌ ଇକା ମି ସମୟ ମାରି ସିକାଟିଦି ସାସନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ୱେନ୍‌କା ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ଆସ୍‌ସି ଅସି ୱିଜେରିଙ୍ଗ୍‌ପେରି ଜାଜକରି ଇଲ୍‌ତୁ ତାତାର୍‌; ମାତର୍‌ ପିତର୍‌ ଆକ ତେବାଜି ୱେନ୍‌କା ୱେନ୍‌କା ସର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ମାରି, ୱାର୍‌ ଦୁଆର୍‌ତି ନାଡ଼୍‍ମି ସିସୁ କାସିସ୍‍କିଜି ଉଣ୍ତ୍ରେମାନୁ ବାସ୍‌ତାର୍‌, ପିତର୍‌ ୱାରିମାନୁ ବାସ୍‍ତା ମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ଅରେତ୍‌ ପାଣି କିନି ଆଇମା ପିତର୍‍ତିଙ୍ଗ୍‍ ସିସୁ ଲାକ୍‌ତୁ ବାସ୍‍ତିମାର୍‍ଇକା ସୁଡ଼ୁଜି ଇର୍ହାତ୍‌, “ଇକାନ୍‌ ବା ଜିସୁୱାଲେ ମାର୍‌ଆନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ମାତର୍‌ ପିତର୍‌ ଇୟା ମାଟାଦିଙ୍ଗ୍‌ ସିଲେଇଜି ଇର୍‌ଆନ୍‌, “ଏ ଆଇମା, ନାନ୍ ୱାନିଙ୍ଗ୍‌ ନେସେଏ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ଏସୋ ସମୟ ୱେନ୍‌କା ମାରି ଅରେନ୍‍ ୱାନିଙ୍ଗ୍‌ ସୁଡ଼ୁଜି ଇର୍‌ଆନ୍‌, “ନିନ୍‌ ବା ଜିସୁୱାଲେ ମାର୍‍ଇ ଲୋକା ଲୋଇ ଅରେନ୍‍ ।” ମାତର୍‌ ପିତର୍‌ ଇର୍‌ଆନ୍‌, “ସିଲେ, ତଡ଼ାନ୍‍, ନାନ୍ ନେସେଏ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ମାରି ଗଣ୍ଟା ୱେନ୍‌କା ମାରି ଅରେନ୍‍ ପୁରା ନେସ୍‌ସି ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌, “ଇକାନ୍‌ ବା ସତେନେ ୱାନିୱାଲେ ମାର୍‌ଆନ୍‌, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ତୋ ଗାଲିଲିଦି ଲୋକୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ମାତର୍‌ ପିତର୍‌ ଇର୍‌ଆନ୍‌, “ତଡ଼ାନ୍‍, ନିନ୍‌ ଆମାକା ଇଜିନି, ନାନ୍ ଆକା ନେସେଏ ।” ଆୟାଦାପ୍ରେ ୱାନ୍‌ ମାଟା ଇନ୍‍ବୁ ଇନ୍‍ବୁ କରୁ କେଡ଼ିତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ମାରି ପ୍ରବୁ ଡ଼େସି ମାର୍‍ଜି ପିତର୍‍ତିଙ୍ଗ୍‍ ସୁଡ଼ୁତାନ୍‌; “ଆବେଟ୍‌ ନେର୍‌ କର୍‌ରୁ କେଡ଼ିନି ଆଗ୍‍ଡ଼ିନେ ନିନ୍‌ ନାଙ୍ଗିଁ ମୁଜା ନେସେଏ ଇଜି ଇନି, ଇୟା ଆମା ମାଟା ପ୍ରବୁ ପିତର୍‍ତିଙ୍ଗ୍‍ ଇର୍‌ଆମାର୍‌ଆନ୍‌,” ");
INSERT INTO kfcp_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ଆକା ପିତର୍‌ ୱାନି ମୋନ୍‌ତୁ ଏତ୍‌କିତାନ୍‌, ମାରି ୱାନ୍‌ ଆତ୍‌ରେ ସଲ୍‌ସି ନାଣ୍ତ ଦୁଃକ୍‌ତାନ୍‍ ଆଡ଼୍‍ବାତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ମାରି, ଏମେ ଲୋକ୍‌ ଜିସୁଙ୍ଗୁଁ ଆସ୍‌ତା ଇଟ୍‍ତାମାର୍‍ଆର୍‍, ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଡାକ୍‍ସି ଡାକ୍‍ସି ସେମାର୍‍ କିତାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ମାରି ୱାନି ମୋକମି ପାଗା କେର୍‍ପ୍‍ସି ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, ନିନ୍‌ ପରା ବାବବାଦି ! ଇନ୍‌ଆଁ ତୋ, ଏନ୍‌ ନିଙ୍ଗିଁ ଡାକ୍‍ତାର୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ମାରି, ୱାର୍‌ ନାଣ୍ତ ମାଟେଙ୍ଗ୍‌ ୱାନି ବିରଦ୍‌ତାନ୍‌ ଇଜି ୱାନିଙ୍ଗ୍‌ ନିନ୍ଦା କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ସାଲ୍‍ଦି ଆତିଦାପ୍ରେ ଲୋକା ପେରିଡକ୍‍ରାର୍‍, ମାରି ପେରି ଜାଜକର୍‌ ମାରି ସାସ୍ତ୍ରିର୍‍ ଉଣ୍ତାଜି ତାମେ ପେରି ଲୋକାମିଟିଙ୍ଗ୍‍ତୁ ଜିସୁଙ୍ଗୁଁ ଅସି ଇର୍ହାର୍‌, “ନିନ୍‌ ଜଦି କ୍ରିସ୍ତ, ଆରିଙ୍ଗ୍‌ ମାଙ୍ଗିଁ ଇନ୍‌ଆଁ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ୱାର୍‍ ଇର୍ହାର୍‌, “ମାଙ୍ଗିଁ ଇନ୍‍ଆଁ, ନିନୁ ଇନିକା ମସିହ ?” ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନାନ୍ ଜଦି ମିଙ୍ଗିଁ ଇନା, ମିର୍‌ ତୋ ବିସ୍‌ବାସ୍‌ କିଇଦେର୍‍; ");
INSERT INTO kfcp_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ମାରି, ନାନ୍ ଜଦି ପ୍ରସ୍ନ ୱେନ୍‍ବାନା, ମିର୍‌ ୱେର୍‌ଇଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ମାତର୍‌ ଇଲେଇରାନ୍‌ ମନୁସ୍ୟପୁତ୍ର ପେରି ସାକ୍ତିଦି ମାପୁରୁଦି ରାଜାଗାଦିଦି ଉଣେରି ତରିନ୍‌ ବାସ୍‍ନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ଆବେଟ୍‌ ୱିଜେରେ ୱେନ୍‌ବାତାର୍‌, “ଆରିଙ୍ଗ୍‌ ନିନ୍‌ ଇନିକା ମାପୁରୁଦି ମାରିନ୍‌ ?” ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନାନ୍ ଆକାନେ ଇଜି ମିର୍‌ ଇଜିନିଦେର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ଆବେଟ୍‌ ୱାର୍‌ ଇର୍ହାର୍‌, “ଆରିଙ୍ଗ୍‌ ମାଙ୍ଗିଁ ସାକି ମାରି ଏନ୍ଦା ଦରକାର୍‍ ? ମାଡ୍‌ ତୋ ନିଜେନିଜେ ୱାନି ନିଜେଦି ୱେୟୁଦାନ୍‌ ୱେରିକା ।” ");
INSERT INTO kfcp_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ୱେନ୍‌କା କୁଟୁମ୍‍ତି ୱିଜେରେ ଲୋକୁ ନିଙ୍ଗିଁତାରୋ ପିଲାତ୍‌ ରାଜାମାନୁ ଜିସୁଙ୍ଗୁଁ ଅତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ମାରି, ୱାର୍‌ ୱାନି ବିରଦ୍‌ତାନ୍‌ ଦୋସ୍‍ କିଜି ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, “ମାପ୍‌ ସୁଡ଼ୁତାପ୍‌, ଇକାନ୍‌ ମା ଲୋକାଙ୍ଗ୍‍ ରାଜାଦି ବିରଦ୍‌ କିବିସ୍‍କିଜିନାନ୍‍ ମାରି କାଇସର୍‍ ରାଜେଙ୍ଗ୍‍ ସିସ୍‍ଟୁ ସିଦେଙ୍ଗ୍‍ ତେବା କିଜିନାନ୍‍ ମାରି ନିଜେଦିଙ୍ଗ୍‍ କ୍ରିସ୍ତ ରାଜା ଇଜିନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ଆବେଟ୍‌ ପିଲାତ୍‌ରାଜା ୱାନିଙ୍ଗ୍‌ ୱେନ୍‍ବାତାନ୍‌, “ନିନ୍‌ ନୋ ଜିହୁଦି ଲୋକ୍‌ତି ରାଜା ?” ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ନିନ୍‌ ଇଜିନି । ");
INSERT INTO kfcp_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ଆବେଟ୍‌ ପିଲାତ୍‌ ରାଜା ପେରି ଜାଜକରିଙ୍ଗ୍‍ ମାରି ଲୋକାଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନାନ୍ ଇୟାୱାନିମାନୁ ଇନି ଦୋସ୍‍ ପୟ୍‌ଏଜିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ମାତର୍‌ ୱାର୍‌ ମାରି ନାଣ୍ତଦାନ୍‌ ନାଣ୍ତ ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, “ଇକାନ୍‌ ୱିଜୁ ଜିହୁଦା ଦେସ୍‍ତୁ ସିକିୟା ସିଜି ଗାଲିଲିଦାନ୍‍ ଆରାମ୍‌ କିଜି ଇବେବା ଲୋକାଙ୍ଗ୍‌ ବାୟା କିଜିନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ମାତର୍‌ ପିଲାତ୍‌ ରାଜା ଇକା ୱେନ୍‌ଜି ୱେନ୍‌ବାତାନ୍‌, “ଇୟା ଲୋକୁ ଇନିକା ଅରେନ୍‍ ଗାଲିଲିଦିକାନ୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ମାରି, ୱାନ୍‌ ଜେ ହେରୋଦ୍‍ ରାଜାଦି ଅଦିକାର୍‌ତାନ୍‌ ମାନାନ୍‌, ଇକା ନେସ୍‌ସି ୱାନ୍‌ ଜିସୁଙ୍ଗୁଁ ହେରୋଦ୍ ଲାକ୍‌ତୁ ପୋକ୍‌ତାନ୍‌, ୱାନ୍‌ ବା ଆୟାୱାଲେ ଜିରୁସାଲାମ୍‍ତୁ ମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ହେରୋଦ ରାଜା ଜିସୁଙ୍ଗୁଁ ସୁଡ଼ୁଜି ନାଣ୍ତ ୱେଡ଼ିକା ଆତାନ୍‌, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ଜିସୁଦି ବିସୟ୍‌ତାନ୍‌ ୱେର୍‍ଆମାର୍‍ଆନ୍‍ ଆକା ୱାନିଙ୍ଗ୍‌ ଏସୋ କାଡ଼ାଦାନ୍‍ ସୁଡ଼୍‍ଦେଙ୍ଗ୍‍ ବଦାକିଜିମାର୍‍ଆନ୍‍, ମାରି ଜିସୁ ମାଣାନ୍‌ ଉଣ୍ତ୍ରି କାବାଆନି ପାଣି ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ଆସାକିଜିମାର୍‍ଆନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ଆଦେଙ୍ଗ୍‌ ହେରୋଦ ରାଜା ଜିସୁଙ୍ଗୁଁ ଏସୋ ମାଟେଙ୍ଗ୍‌ ୱେନ୍‍ବାଦେଙ୍ଗ୍‍ ଆସ୍‌ତାନ୍‌, ମାତର୍‌ ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ଉଣ୍ତ୍ରି ମାଟା ବା ଇନ୍‌ଏତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ମାରି, ପେରି ଜାଜକର୍‌ ମାରି ସାସ୍ତ୍ରିର୍‍ ନିର୍‌ଆରୋ ୱାନି ବିରଦ୍‌ତାନ୍‌ ଦୋସ୍‍ କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ମାରି, ହେରୋଦ ନିଜେଦି ସୈନ୍ୟରି ୱାଲେ ୱାନିଙ୍ଗ୍‌ ସେମାର୍‌ କିଜି ସେମାର୍‌ କିନି ରାଜାରି ଆଙ୍ଗିଁ ଆରିସ୍‌ କିତାର୍‌ରୋ ପିଲାତ୍‌ଦି ଲାକ୍‌ତୁ ମାରିଡ଼େସି ପୋକ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ଆୟା ନାଣ୍ତିଙ୍ଗ୍‌ ହେରୋଦ ମାରି ପିଲାତ୍‌ ମିସାବିଡ଼ାଜି ସଙ୍ଗ୍‍ ଆତାର୍‌; ଆଗିଡ଼ି ୱାର୍‌ ନିଜେ ନିଜେଦି ମାନୁ ସାତ୍ରୁରୁ ମାର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ତାନେୱେନ୍‌କା ପିଲାତ୍‌ ପେରି ଜାଜକରିଙ୍ଗ୍‌, ପେରି ୱାରିଙ୍ଗ୍‌ ମାରି ୱିଜୁ ଲୋକାଙ୍ଗ୍‌ ଉଣ୍ତ୍ରେ ମାନୁ କୁକ୍‌ସି ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“ଇୟା ଲୋକାଙ୍ଗ୍‌ ସେଇପାଣି କିବିସ୍‍କିଜିନାନ୍‍ ଇଜି ମିର୍‌ ୱେନିଙ୍ଗ୍‌ ମା ଲାକ୍‌ତୁ ତାତିମାନିଦେର୍‌; ମାରି ସୁଡ଼ୁଦୁ, ମାପ୍‌ ମି ଆଗିଡ଼ିନେ ୱେନିଙ୍ଗ୍‌ ୱେନ୍‍ବାତାମାନା, ୱାନି ବିରଦ୍‌ତାନ୍‌ ମିର୍‌ ଆମାକାୱିଜୁ ଇଜିନିଦେର୍‌, ଆୟାୱାଜା ଇନି ସେଇପାଣି ୱେନିମାନୁ ପୟ୍‍ଏ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ହେରୋଦ ବା ୱାନି ସେଇପାଣି ପୟ୍‍ଏ, ମାତର୍‌ ହେରୋଦ ଜିସୁଙ୍ଗୁଁ ମା ଲାକ୍‌ତୁ ମାରି ପୋକ୍‌ତାତାନ୍‌; ମାରି ସୁଡ଼ୁଦୁ, ଇୟା ଲୋକ୍‌ ସାନିଦଣ୍ତ୍‌ ଜଗ୍‌ ଇନି ପାଣିବା କିଏନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ମାରି ମାପ୍‌ ୱେନିଙ୍ଗ୍‌ ସାସ୍ତି ସିତିୱେନ୍‌କାନେ ଡ଼ିସ୍‌ନାପ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ପଣ୍ତ୍‌ୟତି ସମୟତୁ ୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ ଅରେନ୍‍ ଜଇଲ୍‌ତୁ ମାନି ୱାନିଙ୍ଗ୍‌ ଡ଼ିସିସ୍‍ କିଦେଙ୍ଗ୍‌ ଆଜିମାର୍ହାତ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ମାତର୍‌ ୱାର୍‌ ୱିଜେରେ ଅର୍‌ସେ ଆଉଲି ଆଜି ଇର୍ହାର୍‌, “ୱେନିଙ୍ଗ୍‌ ସାୟାମାରାଗ୍‌ ଡାକ୍‌ତୁ, ମା ଉଣ୍ତିଙ୍ଗ୍‌ ବାରବ୍ବାଦିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ତୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ଇୟା ବାରବ୍ବା ଗାଡ଼୍‌ତୁ ଗଟାତିମାନି ଜୁଦ୍‍ ଆରାମ୍‌ କିତିମାନି ଉଣ୍ତିଙ୍ଗ୍‌ ମାରି ଏସ ଲୋକାଙ୍ଗ୍‌ ସାୟାମାର୍‌ଗା ଡାକ୍‌ତିମାନି ଉଣ୍ତିଙ୍ଗ୍‌ ଜଇଲ୍‌ତୁ ତେବାତା ମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ମାତର୍‌ ପିଲାତ୍‌ ଜିସୁଙ୍ଗୁଁ ଡ଼ିସ୍‌ସି କିଦେଙ୍ଗ୍‌ ବଦାକିତାନ୍‌ନୋ ୱାରିଙ୍ଗ୍‌ ମାରିଡ଼େସି ବୁଜାକିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ଇରିଙ୍ଗ୍‌ ୱାର୍‌ ନାଣ୍ଡ୍ ଆଉଲି ଆଜି ଇଣ୍ତ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, “ୱାନିଙ୍ଗ୍‌ କ୍ରୁସକାଟ୍‌ତୁ ଏକିସ୍‌କିଦୁ, କ୍ରୁସକାଟ୍‌ତୁ ଏକିସ୍‌କିଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ମାରି, ପିଲାତ୍‌ ୱାରିଙ୍ଗ୍‌ ମୁଣ୍ତ୍ରି ଦେବେଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଏନ୍ଧା, ୱାନ୍‌ ଇନିକା ଦସ୍‌ କିତାମାନାନ୍‌ ? ମାପ୍‌ ୱାନିମାନୁ ସାନିଦଣ୍ତ୍‌ତି ଇନି ଦସ୍‍ବା ପୟ୍‍ଏପ୍‍; ମାରି, ମାଡ୍‌ ୱାନିଙ୍ଗ୍‌ ସାସ୍ତି ସିନାଡ ଡ଼ିସ୍‌ନାଟ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ମାତର୍‌ ୱାନ୍‌ କ୍ରୁସକାଟ୍‌ତୁ ଏକିସ୍‌କିଦୁ ଇଜି ଦାବି କିଜି ୱାର୍‌ ପେରି ୱେୟୁଦାନ୍‌ ଜିଦ୍‌ କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, ମାରି ୱାରି ଆଉଲିଦାନ୍‌ ପୁରା ଆତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ମାରି, ୱାରି ଦାବି କିତି ଇସାବ୍‌ତାନ୍‌ ଆପିତ୍‌ ଇଜି ପିଲାତ୍‌ ଆଦେସ୍‌ ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ମାତର୍‌ ଜୁଦ୍‍ ମାରି ଲୋକାଙ୍ଗ୍‌ ସାୟାମାର୍‌ଗା ଡାକ୍‌ତି ଉଣ୍ତିଙ୍ଗ୍‌ ଜଇଲ୍‌ତୁ ଇଟ୍‌ତିମାନି ଏମେ ଲୋକ୍‌ତି ଉଣ୍ତିଙ୍ଗ୍‌ ୱାର୍‌ ଦାବି କିତାମାଆର୍‌, ଆୟା ବାରବ୍ବାବେଙ୍ଗ୍‌ ପିଲାତ୍‌ ଡ଼ିସ୍‌ତାନ୍‌, ମାରି ପିଲାତ୍‌ ଜିସୁଙ୍ଗୁଁ ସାୟାମାର୍‌ଗା ଡାକ୍‌ତେଙ୍ଗ୍‍ଁ ଇଜି ଲୋକା ବଦାଦାନ୍ କିୟୁଦୁ ସର୍‍ପେ କିତା ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ସନ୍ୟର୍‌ ଜିସୁଙ୍ଗୁଁ ଆସ୍‌ତାରୋ ସନିୱାଲେ ଇସ୍ରି ନାର୍‌ତାନ୍‌ ଗାଡ଼୍‌ତୁ ୱାଜିମାନି ସିମୋନ ଦର୍‌ତି ଅରେନ୍‍ କୁରିଣି ଗାଡ଼୍‌ତି ଲୋକ୍‌ତିଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ରୋ ଜିସୁଦି ୱେନ୍‌କା ୱେନ୍‌କା କ୍ରୁସକାଟ୍‌ ପିଡିଦେଙ୍ଗ୍‌ ଇଜି ସିମୋନତି ମେପିଦୁ ଆକା ଇଟ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ମାରି, ଲୋକାଙ୍ଗ୍‌ ମାରି ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ଦୁଃକ୍‌ କିଜି ବକାଦୁ କତାଜି ଆଡ଼୍‍ବାଜି ମାନି ଆଇମେକ୍‍ ନାଣ୍ତ ଲୋକୁ ଜିସୁ ୱେନ୍‌କା ୱେନ୍‌କା ସୋଲ୍‌ସିମାର୍‌ଏ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ମାତର୍‌ ଜିସୁ ଆଇମେକା ତରିଣ୍ତ୍‌ ମାର୍‌ଜିବେସତାନ୍‌ନୋ ଇର୍‌ଆନ୍‌, “ଏ ଜିରୁସାଲମତି ଆଇମେକ୍‍, ନା ଉଣ୍ତିଙ୍ଗ୍‌ ଆଡ଼୍‌ବାମାଟ୍‌, ମାରି ମିର୍‌ ନିଜେ ନିଜେଦି ଉଣ୍ତିଙ୍ଗ୍‌ ମାରି ନିଜେ ନିଜେଦି କଡ଼ରିଙ୍ଗ୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ଆଡ଼୍‌ବାଦୁ; ");
INSERT INTO kfcp_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ମାତର୍‌ ସୁଡ଼ୁଦୁ, ଏମେ ଆଇମେକ୍‍ ବାଞ୍ଜି, ମାରି ଏମେ ଆଇମେକ୍‍ ଏସ୍‌କାଙ୍ଗ୍‌ବା ପୋଟାଦୁ ଆଉ ମାରି ପାଲ୍‍ ଉଟ୍‌ଉ, ୱାନିକାଙ୍ଗ୍‌ ଲୋକୁ ଏସ୍ତିୱାଲେ ଦନ୍ୟ ଦନ୍ୟ ଇଜି ଇନାର୍‌, ଇୟାୱାଜା ସମୟ ୱାଜିନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ନାସ୍ତିୱାଲେ ଲୋକୁ ଗରକାଙ୍ଗ୍‌ ଇଣ୍ତ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ନାର୍‌, ମା ମୁସ୍‌କୁ ଆର୍‌ଆ, ମାରି ଇସ୍ରିଗରକାଙ୍ଗ୍‌ ଇଣ୍ତ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ନାର୍‌, ମାଙ୍ଗିଁ ପିଡ଼ିକ୍‌ଆ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ମାତର୍‌ ଲୋକୁ ଜଦି ଜିବନ୍‌ମାନି ମାରାନ୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ଇକା କିନାର୍‌, ଆଦେଙ୍ଗ୍‌ ୱାର୍‌ତି ମାରାନ୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ଇନିକା ଗଟେଆଏତ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ମାରି, ଜିସୁଦି ୱାଲେ ସାନିଦଣ୍ତ୍‌ ସିଦେଙ୍ଗ୍‍ ଇଜି ମାରି ରିଏର୍‌ ଡଙ୍ଗାଁରିଙ୍ଗ୍‌ ବା ୱାନି ୱାଲେ ଅସିମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ମାରି, ୱାର୍‌ କାପାଲ୍‌ ନାନି ଦର୍‌ତି ବାଡିଦୁ ଇତାର୍‌ରୋ ଆବେନୁ ସୈନ୍ୟର୍‌ ଜିସୁଙ୍ଗୁଁ କ୍ରୁସକାଟ୍‌ତୁ ଏକିସ୍‌କିତାର୍‌, ମାରି ଡଙ୍ଗାଁରିଙ୍ଗ୍‌ ରିଏରି ମାଣ୍‌କୁ ଅରେନ୍‍ ୱାନିଙ୍ଗ୍‌ ଉଣିକିୟୁ ତରିନ୍‌ ମାରି ଆଇୱାନିଙ୍ଗ୍‍ ଡେବିରି କିୟୁ ତରିନ୍‌ କ୍ରୁସକାଟ୍‌ତୁ ଏକିସ୍‌କିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ନାସ୍ତିୱାଲେ ଜିସୁ ଇର୍ହାନ୍‌, “ଏ ବୁବା, ୱେରିଙ୍ଗ୍‌ କେମା କିଆ, ଇରିଙ୍ଗ୍‌ ଇକାର୍‌ ଇନିକା କିଜିନାର୍‌, ଆକା ୱାର୍‌ ନେସ୍‌ଏର୍‌ ।” ମାରି, ୱାର୍‌ ୱାନି ଆଙ୍ଗିଁୱିଜୁ ବାଗ୍ କିନି ଉଣ୍ତିଙ୍ଗ୍‌ କୁଡ଼ୁକୁଡି କିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ମାରି, ଲୋକୁ ନିର୍‌ଆର୍‌ରୋ ଜିସୁଙ୍ଗୁଁ ସୁଡ଼୍‌ଜି ମାର୍ହାର୍‌ । ମାରି, ଜିହୁଦି ନେତାର୍‌ ବା ୱାନିଙ୍ଗ୍‌ ସେମାର୍‌ କିଜି ଇଣ୍ତ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, ୱାନ୍‌ ଆଇୱାରିଙ୍ଗ୍‌ ରକିୟା କିତାନ୍‌, ୱାନ୍‌ ଜଦି ମାପୁରୁଙ୍ଗୁଁ ବାସେକିତି କ୍ରିସ୍ତ, ସିଲିତିଙ୍ଗ୍‌ ନିଜେଦିଙ୍ଗ୍‌ ରକିୟା କିପିନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ମାରି, ସୈନ୍ୟର୍‌ ବା ଜିସୁ ଲାକ୍‌ତୁ ୱାଜି ସୋଇନିରସ ଜାସେ କିଜି ୱାନିଙ୍ଗ୍‌ ସେମାର୍‌ କିଜି ଇର୍ହାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ନିନ୍‌ ଜଦି ଜିହୁଦିର୍‌ ରାଜା, “ଆଦେଙ୍ଗ୍‌ ନିଜେଦିଙ୍ଗ୍‌ ରକିୟା କିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ମାରି, ୱାନି ମୁସ୍‌କୁ ଇୟାୱାଜା ରାସ୍‌ତିକା ବା ମାର୍ହାତ୍‌, “ଇକାନ୍‌ ଜିହୁଦିର୍‌ ରାଜା ।” ");
INSERT INTO kfcp_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ମାରି, କ୍ରୁସକାଟ୍‌ତୁ ଏକିସ୍‌କିତିମାନି ଡଙ୍ଗାଁରି ମାଣ୍‌କୁ ଅରେନ୍‍ ଜିସୁଙ୍ଗୁଁ ନିଦା କିଜି ଇଣ୍ତ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌, “ନିନ୍‌ ଇନିକା କ୍ରିସ୍ତ ଆଇନୋ ? ନିଜେଦିଙ୍ଗ୍‌ ନି ମାଙ୍ଗିଁ ରକିୟା କିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ମାତର୍‌ ମାରି ଅରେନ୍‌ ୱାନିଙ୍ଗ୍‌ ଆଦ୍‌ରିସ୍‌ କିଜି ଇର୍ହାନ୍‌, “ନିନ୍‌ ସାମାନ୍‍ ଦଣ୍ତ୍‌ ତୋ ପଇଜିନି, ନିନ୍‌ ମାପୁରୁଙ୍ଗୁଁ ଇନିକା ତିଲାଇଜିନି ନୋ ? ");
INSERT INTO kfcp_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ମାରି, ମାଡ୍‌ ଗିଦେ ନିୟ୍ୟାଇସାବତାନ୍‌ ଦଣ୍ଡ୍‌ ବୋଗାଜିନିକା, ଇରିଙ୍ଗ୍‌ ମାଡ୍‌ ନିଜେ ନିଜେଦି କାର୍ମୁଦି ଦସ୍‍ ପଲ୍‌ ପୋଇଜିନିକା, ମାତର୍‌ ଇୟା ଲୋକୁ ଇନି ଦୋସ୍‍ବା କିଏନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ତାନେୱେନ୍‌କା ଆୟା ଡଙ୍ଗାଁରେଏନ୍‌ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାନ୍‌, “ଏ ଜିସୁ ନିନ୍‌ ନିଜେଦି ରାଜିଦୁ ସୋର୍‌ରିଙ୍ଗ୍‌ ନାଙ୍ଗିଁ ଏତ୍‌ କିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ଆବେଟ୍‌ ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନାନ୍ ନିଙ୍ଗିଁ ସତ୍‌ ୱେର୍‌ସିନା, ନେରୁ ନିନ୍‌ ନା ୱାଲେ ମୁସ୍‌କୁପୁର୍‌ ସନି ।” ");
INSERT INTO kfcp_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ନାସ୍ତିୱାଲେ ପୁରା ବାର୍‌ ଗଣ୍ଟା ସମୟ ଆତାମାର୍ହାତ୍‌, ମାରି, ୱେଡ଼ାଦି ଜାୟ୍‌ ସିଲେଣ୍ତ ଆତାତ୍‌ଆକା ମୁନ୍‌ଡ୍ରି ଗଣ୍ଟା ସାନ୍ଧି ପୃତିବି ୱିଜୁ ସିକାଟି ଆତାସୋର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ମାରି ମନ୍ଦିର୍‌ତି ପବିତ୍ର ବାଡିଦିଙ୍ଗ୍‌ ଏର୍‌ପିସିମାନି ଦୁଙ୍ଗୁନି ପାର୍‌ଦା ମୁସ୍‌କୁରାନ୍‌ ଆଡ୍‍ଗି ସାନ୍ଦି କିଜ୍‍ଜି ରୁଣ୍ତି ମୋକେଙ୍ଗ୍‍ ଆତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ମାରି, ଜିସୁ ନାଣ୍ତ ଆଉଲି ଆଜି ଡ଼େସି ଇର୍ହାନ୍‌, “ଏ ବୁବା, ନି କିୟୁଦୁ ନାନ୍ ନିଜେଦି ଆତ୍ମା ସପ୍ରେ କିଜିନା ।” ଇକା ଇନ୍‌ଞ୍ଜି ୱାନ୍‌ ସାତା ସୋର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ସତସେନାପତି ଇୟା ଗଟ୍‌ନା ସୁଡ଼ୁଜି ମାପୁରୁଙ୍ଗୁଁ ଦନ୍ୟବାଦ୍‌ କିଜି ଇର୍ହାନ୍‌, “ପୁରା ଇୟା ଲୋକୁ ଦାର୍ମୁ ମାର୍ହାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ମାରି, ଏମେ ଲୋକୁୱିଜେର୍‌ ଇୟା ଗଟ୍‌ନା ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ଉଣ୍ତ୍ରେମାନୁ ଆତାମାର୍ହାର୍‌, ୱାର୍‌ ୱିଜେରେ ଆୟାୱିଜୁ ଗଟ୍‌ନା ସୁଡ଼ୁଜି ନାଣ୍ତ ଦୁଃକ୍‌ କିଜି ନିଜେଦି ବକାଦୁ କତାଜି ଆଡ଼୍‍ବାଜି ଡେସି ସୋର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ମାତର୍‌ ୱାନିଙ୍ଗ୍‌ ନେସ୍‌ତିକାର୍‌ ୱିଜେରେ ମାରି ଗାଲିଲିଦାନ୍‍ ଅର୍‌ସେ ୱାନି ୱେନ୍‌କା ୱେନ୍‌କା ୱାତିମାର୍‌ଇ ଆଇମେକ୍‍ ଆକରାନ୍‍ ନିରେଏନୋ ଇୟାୱିଜୁ ସୁଡ଼ୁଜିମାରେଏ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ମାରି ସୁଡ଼ୁଦୁ, ଜିହୁଦିରି ହାରାମାତିୟା ଗାଡ଼୍‌ତି ଜୋସେପ୍‌ ଦର୍‌ତିକାନ୍‌ ଅରେନ୍‍ ଲୋକୁ ପେରିଦଲ୍‌ତି ନେତା ମାର୍ହାନ୍‌, ୱାନ୍‌ ଅରେନ୍‍ ନେଗିକାନ୍‌ ମାରି ଦାର୍ମୁଦି ଲୋକୁ, ");
INSERT INTO kfcp_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ମାରି ଜିହୁଦିରି ମାଟାଦିଙ୍ଗ୍‌ ନି ପାଣିଦିଙ୍ଗ୍‌ ମାନାଏତା ମାର୍ହାନ୍‌, ମାରି ହାରାମାତିୟା ନିଜେ ବା ମାପୁରୁଦି ରାଜିଦିଙ୍ଗ୍‌ କାପ୍‌କିଜି ମାର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ୱାଣ୍ତ୍ରୁ ପିଲାତ୍‌ଦି ଲାକ୍‌ତୁ ସୋର୍ହାନ୍‌ ନୋ ଜିସୁଦି ସାତି ମାଡ଼ା ଲସ୍‌ତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ମାରି ସାତିମାଡ଼ାଦିଙ୍ଗ୍‌ ରେପ୍‌ସିତାସି କାଣ୍ତେକ୍‌ ୱାତିଦାନ୍‌ ତେରେପ୍‌ତାନ୍‌ ନୋ, ଆବେନୁ ଏନ୍‌ ଏସ୍‌କାଙ୍ଗ୍‌ ଇଡ୍‌ଏର୍‌ ମାର୍ହାର୍‌, ଗରନ୍‌ତୁ କାରିତିମାର୍‌ଇ ଇୟାୱାଜା ଉଣ୍ତ୍ରି ଗୁଟାଦୁ ୱାନିଙ୍ଗ୍‌ ଇଟ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ଆୟା ନାଣ୍ତିଙ୍ଗ୍‌ ତିଆର୍‌ଆନି ଦିନ୍‌ ମାର୍ହାତ୍‌, ମାରି ରମ୍‌ନିଦିନ୍‌ ଲାକ୍‌ତୁ ଆଜି ୱାଜି ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ମାରି, ଗାଲିଲିଦାନ୍‍ ୱାନି ୱାଲେ ୱାତିମାର୍‌ଇ ଆଇମେକ୍‍ ୱେନ୍‌କା ୱେନ୍‌କା ସୋର୍‌ଏ ନୋ ମୁସ୍‌ତିକା ମାରି ୱାନି ମାଡ଼ାଦିଙ୍ଗ୍‍ ଏଣ୍ତେସ୍‌ ଇଟ୍‌ତାର୍‌, ଆକା ସୁଡ଼ୁତେ, ");
INSERT INTO kfcp_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ମାରି ୱାକ୍‍ ଡେସିସୋର୍‌ଏନୋ ବାସ୍‌ନାଜିନିସ୍‍କୁ ମାରି ନିୟୁ ତିଆର୍‌ କିତେ । ୱାକ୍‍ ରମ୍‌ନିନାଣ୍ତିଙ୍ଗ୍‌ ରମିତେ, ଇରିଙ୍ଗ୍‌ ଇକା ନିୟ୍‍ମତୁ ମାର୍‌ଆତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ମାତର୍‌ ୱାରାଦି ଆଗିଡ଼ିରି ନାଣ୍ତିଙ୍ଗ୍‌ ଉଟ୍‌ଲା ନାଡ଼ାକାଦେ ୱାକ୍‍ ୱାନିକା ତିଆର୍‌କିତି ବାସ୍‌ନାଦିଜିନିସ୍‍କୁ ନି ନିୟୁ ଆସ୍‌ତେନୋ ମୁସ୍‌ତି ଲାକ୍‌ତୁ ସୋର୍‌ଏ । ");
INSERT INTO kfcp_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ମାରି, ୱାକ୍‍ ମୁସ୍‌ତିମାଣ୍‌କୁ କାଲୁ ପେଲେକିତି ମାର୍‌ଇକା ସୁଡ଼ୁତେ, ");
INSERT INTO kfcp_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ମାତର୍‌ ଲୋଇ ସୋରେଏନୋ ପ୍ରବୁ ଜିସୁଦି ମାଡ଼ା ପୟ୍‌ଉତେ । ");
INSERT INTO kfcp_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ମାରି, ୱାକ୍‍ ଆୟା ବିସୟତାନ୍ ବାୟାବେମ୍ରି ୱାଜା ଆତେ, ଇୟାୱାଜା ସମୟତୁ ସୁଡ଼ୁଦୁ, ଜାୟ୍‌ତି ୱାତି ଆରାତିକେଙ୍ଗ୍‌ ରିଏର୍‌ ମୁସ୍‌କୁପୁର୍‌ତି ଦୁତ୍‌କୁ ୱାନିକା ଲାକ୍‌ତୁ ୱାତେ; ");
INSERT INTO kfcp_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ଆବେଟ୍‌ ୱାକ୍‍ ତିଲାତେ ନୋ ତାଲା ଆଡ୍‍ଗି ପାଡ଼୍‍ତେ ମାର୍‌ଏ, ଦୁତ୍‌କୁ ୱାନିକାଙ୍ଗ୍‌ ଇର୍‌ଏ, “ସାତିୱାରି ମାଣାନ୍‌ ମିର୍‌ ଏନ୍ଧା ଜିତିୱାନିଙ୍ଗ୍‌ ପୋଇଜିନିଦେର୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ୱାନ୍‌ ଇବେନୁ ସିଲେନ୍‌, ମାତର୍‌ ନିଙ୍ଗିଁତାମାନାନ୍‌ ? ୱାନ୍‌ ଗାଲିଲିଦୁ ମାର୍‍ଇୱାଲେ ମିଙ୍ଗିଁ ଇନିକା ଇର୍‌ଆମାର୍‌ଆନ୍‌ ଆକା ଏତ୍‍ କିଦୁ, ");
INSERT INTO kfcp_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ମନୁସ୍ୟପୁତ୍ରଦିଙ୍ଗ୍‌ ଜେ ପାପି ଲୋକା କିୟୁଦୁ ସର୍ପେ ଆଜି କ୍ରୁସକାଟ୍‍ତୁ ସାଦେଙ୍ଗ୍‌ ଆନାତ୍‌ ମାରି ମୁଣ୍ତ୍ରି ଦିନ୍‌ତିନାଣ୍ତିଙ୍ଗ୍‌ ସାତିମାଣ୍‌ନା ଡେସିଜିବନ୍‌ ଆଜି ନିଙ୍ଗିଁତା ମାନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ଆବେଟ୍‌ ୱାର୍‌ ୱାନି ବାକ୍ୟ ଏତ୍‌ କିତାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ମାରି ମୁସ୍‌ତିମାଣ୍‌ନା ଡେସିସୋର୍‌ଏନୋ ଏଗାର୍‌ ଲୋକାଙ୍ଗ୍‌ ନି ଆଇ ୱିଜେରିଙ୍ଗ୍‌ ଇୟାୱିଜୁ ମାଟା ୱେର୍‌ତେ । ");
INSERT INTO kfcp_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ଇୟାକେଙ୍ଗ୍‌ ମଗ୍‌ଦଲିନି ମରିୟମ୍‌, ଜୋହାନା, ଜାକୁବରି ଆଇସି ମରିୟମ୍‌ ମାରି ୱେନିକା ୱାଲେ ମାନି ଆଇ ଆଇମେକ୍‍, ଇୟାକେଙ୍ଗ୍‌ ସିସୁରିଙ୍ଗ୍‌ ଇୟାୱିଜୁ ବିସୟ୍‌ ୱେର୍‌ତେ । ");
INSERT INTO kfcp_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ମାତର୍‌ ଇୟାୱିଜୁ ମାଟା ୱାରି ଲାକ୍‌ତୁ ବାୟାଦିମାଟା ୱାଜା ଆତାତ୍‌, ମାରି ୱାର୍‌ ୱାନିକାଙ୍ଗ୍‌ ବିସ୍‍ବାସ୍‍ କିଏତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ମାତର୍‌ ପିତର୍‌ ନିଙ୍ଗିଁତାନ୍‌ନୋ ମୁସ୍‌ତି ଲାକ୍‌ତୁ ଉରୁକ୍‌ସିସର୍ହାନ୍‌, ମାରି ପାଡ଼ିଗିଜି ବେସ୍‌ତାନ୍‌ନୋ ୱାର୍‌ଇ ୱାତିଙ୍ଗ୍‌ୱିଜୁ ସୁଡ଼ୁତାନ୍‌, ମାରି ୱାନ୍‌ ଆୟା ଗଟ୍‌ନା ବିସୟ୍‌ତାନ୍‌ ତିଲାତାନ୍‌ନୋ ନିଜେଦି ଇଣ୍ତ୍ର ସୋର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ମାରି ସୁଡ଼ୁଦୁ, ଆୟାନାଣ୍ତିଙ୍ଗ୍‌ ୱାରି ମାଣ୍‌ନା ରିଏର୍‌ ଲୋକୁ ଜିରୁସାଲମତାନ୍‌ ପୁରା ଏଗାର୍‌ କିଲମିଟ୍‌ରଦାନ୍‌ ଆକ ଇମ୍ମାୟୁଦି ନାଟ ସୋଲ୍‌ସିମାର୍‌ଆର୍‍ ");
INSERT INTO kfcp_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ମାରି ଇୟାୱିଜୁ ଗଟ୍‌ନା ବିସୟ୍‌ତାନ୍‌ ନିଜେ ନିଜେଦି ମାନୁ ୱାର୍‌ଗିଜିସାଜି ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ୱାର୍‌ ୱାର୍‌ଗିଜିସାନିକା ମାରି ଲୋଇ ଲୋଇ ୱାର୍‌ଗିଜିସାନିୱାଲେ ଜିସୁ ୱାନ୍‌ଣ୍ତ୍ରେ ୱାରି ଲାକ୍‌ତୁ ୱାଜି ୱାରି ୱାଲେ ଦାପେ ଦାପେନେ ବୁଲାଦେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ମାତର୍‌ ୱାରି କାଣୁକୁ ଇୟାୱାଜା ନାମିତେ ମାର୍‌ଏ, ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଚିନିସ୍‌ କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ମିର୍‌ ବୁଲାଜି ବୁଲାଜି ଏମେ ୱିଜୁ ବିସୟ୍‌ ନିଜେ ନିଜେଦି ମାନୁ ୱାର୍‌ଗିଜି ସାଜିନିଦେର୍‌, ଆୟାୱିଜୁ ଇନିକା ? ଆବେଟ୍‌ ୱାର୍‌ ଦୁଃକ୍‌ତୁ ମୋକ୍‌ମତାନ୍‌ ନିର୍‌ଆର୍‌ରୋ ତେବାତାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ମାରି, ୱାରି ମାଣ୍‌ନା କୟାପା ଦର୍‌ତିକାନ୍‌ ଅରେନ୍‍ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଜିରୁସାଲମତି ଲୋକାରି ମାଣ୍‌କୁ ନିନ୍‌ ଇନିକା ଅରିନ୍ଦେ ଆୟାବାଡିଦି ଇୟା ଏସ ଦିନ୍‌ତି ଗଟ୍‌ନା ନେସେଇ ?” ");
INSERT INTO kfcp_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ଇନି ଇନି ୱାଜାଦି ଗଟ୍‌ନା ?” ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ନାଜରିତିୟ ଜିସୁଦି ବିସୟ୍‌; ୱାନ୍‌ ମାପୁରୁ ମାରି ୱିଜୁ ଲୋକାଦି ଆଗିଡ଼ି ପାଣିଦୁ ମାରି ବାକ୍ୟଦୁ ଅରେନ୍‍ ବପୁଦି ବାବବାଦି ମାର୍ହାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ମାରି ମା ପେରି ଜାଜକର୍‌ ମାରି ପେରିକାର୍‌ ଏଣ୍ତେସ୍‌ ୱାନିଙ୍ଗ୍‌ ସାନି ଦଣ୍ତ୍‌ ବଗାଦେଙ୍ଗ୍‌ ସପ୍ରେ କିଜି ୱାନିଙ୍ଗ୍‌ କ୍ରୁସକାଟ୍‍ତୁ ସାପିସ୍‌ କିତାର୍‌, ଇୟାୱିଜୁ ବିସୟ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ମାତର୍‌ ଏନ୍‌ ଇସ୍ରାଏଲତିଙ୍ଗ୍‌ ଡ଼ିସିସ୍‌ କିନାନ୍‌, ୱାନ୍‌ ଜେ ଇୟା ଲୋକୁ, ଆକା ମାପୁ ଆସା କିତା ମାର୍‌ଆପ୍‌; ଇରିଙ୍ଗ୍‌ ଇକା ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ଇୟାୱିଜୁ ଗଟାତି ନେର୍‌ଆନ୍‌ ମୁନେନ୍‌ ଆତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ମାରି ବା, ମା ମାଣ୍‌କୁ ଏସ ଆଇମେକ୍‍ ମାଙ୍ଗିଁ କାବା କିତେମାନେ; ୱାକ୍‍ ଉଟ୍‌ଲା ନାଡ଼ାକାଦେ ମୁସ୍‌ତି ଲାକ୍‌ତୁ ସୋରେଏମାରେଏ, ");
INSERT INTO kfcp_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ମାରି ୱାନି ସାତି ମାଡ଼ା ପୋଇଉତେନୋ ୱାଜି ଇରେଏ, ୱାକ୍‍ ଦୁତ୍‌କା ସୁଡ଼ୁତେ ମାରେଏ ମାରି ଆୟା ଦୁତ୍‌କୁ ଇରେଏ ଜେ, ୱାନ୍‌ ଜିବନ୍‌ ମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ମାରି, ମା ସଙ୍ଗ୍‌ତି ଲୋକା ମାଣ୍‌କୁ ଏର୍‌ ଏର୍‌ ମୁସ୍‌ତି ଲାକ୍‌ତୁ ସୋଲ୍‌ସି, ଆଇମେକ୍‍ ଏଣ୍ତେସ୍‌ ୱେର୍‌ତେମାରେଏ, ଆୟାୱାଜା ସୁଡ଼ୁତାର୍‌, ମାତର୍‌ ୱାନିଙ୍ଗ୍‌ ସୁଡ଼ୁଏତାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ଆବେଟ୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଏ କାବାଦିକାର୍‌, ବାବବାଦିରି ମାଣ୍‌କୁ ୱେର୍‌ତିମାର୍‌ଇ ୱିଜୁ ବାକ୍ୟଦିଙ୍ଗ୍ ବିସ୍‌ବାସ୍‌ କିଦେଙ୍ଗ୍‌ ଦିରେ ବୁଜାନିଲୋକ୍‍, ");
INSERT INTO kfcp_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ଇୟାୱିଜୁ ଦୁଃକ୍‌ କାସ୍ଟୁ ବୋଗାଜି ନିଜେଦି ମହିମାଦାନ୍‌ ସୋନିକା ଇନିକା କ୍ରିସ୍ତଦିଙ୍ଗ୍‌ ଦର୍‌କାର୍‌ ସିଲେତାତ୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ମାରି, ମୋସା ମାରି ୱିଜେରି ବାବବାଦିରିମାଣୁକୁ ଆରାମ୍‌ କିଜି ୱିଜୁ ଦାର୍ମୁସାସ୍ତ୍ରଦୁ ନିଜେଦି ବିସୟ୍‌ତି ମାଟା ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ବୁଜାକିତାସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ମାରି, ୱାର୍‌ ଏମେ ନାଟ ସୋଲ୍‌ସି ମାର୍‌ଆର୍‌, ଆବେଣି ନାର୍‌ ଲାକ୍‌ତୁ ଇତାର୍‌, ୱାନ୍‌ ମାରି ଆଗିଡ଼ି ସନିୱାଜା ଆତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ମାତର୍‌ ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ତେବାକିଜି ଇର୍ହାର୍‌, “ମା ୱାଲେ ମାନ୍‌ଆ, ମାତର୍‌ ୱେଡ଼ା ଆଜି ୱାଜିନାତ୍ ମାରି ୱେଡ଼ା ସୋଲ୍‌ସିନାତ୍‌ ।” ଆବେଟ୍‌ ୱାନ୍‌ ୱାରି ୱାଲେ ମାନ୍‌ଣ୍ତ୍ରେଙ୍ଗ୍‌ ଇଲୁ ଲୋଇ ସୋର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ମାରି, ୱାରି ୱାଲେ ଉଣିମାନୁ ବାସ୍‌ତି ୱେନ୍‌କା ଜିସୁ ରୁଟି ଅତାନ୍‌ନୋ ମାପୁରୁଙ୍ଗୁଁ ଆସିର୍ବାଦ୍‌ କିତାନ୍‌, ମାରି ଆୟା ରୁଟିଦିଙ୍ଗ୍‌ ରୁକ୍‍ସି ୱାରିଙ୍ଗ୍‌ ସିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ଆବେନୁ ୱାରି କାଣୁକୁ ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ଆଟ୍‌ତାର୍‌ ମାରି ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ସିନିସ୍‌କିଦେଙ୍ଗ୍‌ ଆଟ୍‌ତାର୍‌; ମାରି, ୱାନ୍‌ ୱାରି ଆଗିଡ଼ିରାନ୍‌ ସାଣେକ୍‌ତିଙ୍ଗ୍‌ ଏମେନୋ ଆତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ଆବେଟ୍‌ ୱାର୍‌ ନିଜେ ନିଜେଦିମାନୁ ୱାର୍‌ଗିଜି ସାତାର୍‌, “ଏସ୍ତିୱାଲେ ସାରିଦୁ ୱାନ୍‌ ମା ୱାଲେ ୱାର୍‌ଗିଜିସାଜି ମାର୍‌ଆନ୍‌ ମାରି ମାଙ୍ଗିଁ ଦାର୍ମୁସାସ୍ତ୍ର ବୁଜାକିଜି ମାର୍‌ଆନ୍‌, ନାସ୍ତିୱାଲେ ଇନିକା ମା ଜିବନ୍‌ ସିସୁ କାସ୍‌ନି ୱାଜା ଆଏଜି ମାର୍‌ଆତ୍‌ ନୋ ?” ");
INSERT INTO kfcp_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ତାନେୱେନ୍‌କା ୱାର୍‌ ଆୟା ଦାପ୍ରେ ନିଙ୍ଗିଁତାର୍‌ ନୋ ଜିରୁସାଲମ୍‍ତୁ ଡ଼େସିସୋଲ୍‌ସି ଉଣ୍ତ୍ରେମାନୁ ଆତିମାନିକା ଏଗାର୍‌ ସିସୁରିଙ୍ଗ୍‌ ମାରି ୱାରି ସଙ୍ଗ୍‌ତିୱାରିଙ୍ଗ୍‌ ସୁଡ଼ୁତାର୍‌; ");
INSERT INTO kfcp_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ସିସୁର୍‍ ଇଜି, “ପ୍ରବୁ ସତ୍‍ନେ ନିଙ୍ଗିଁତାମାନାନ୍‌ ମାରି ସିମୋନ୍‌ତିଙ୍ଗ୍‌ ତରାତାମାନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ତାନେୱେନ୍‌କା ଇୟା ରିଏର୍‌ ଲୋକୁ ସାରିଦୁ ଆମାକା ୱିଜୁ ଗଟାତା ମାର୍‌ଆତ୍‌, ଆୟାୱିଜୁ ୱାରି ଆଗିଡ଼ି ୱେର୍‌ତାର୍‌, ୱାନ୍‌ ରୁଟି ରୁକ୍‌ନି ବେଡ଼ାଦୁ ୱାର୍‌ ଏଣ୍ତେସ୍‌ ୱାନିଙ୍ଗ୍‌ ସିନେକିଦେଙ୍ଗ୍‌ ଆଟ୍‌ତାର୍‌, ୱାର୍‌ ଆୟାୱିଜୁ ବିସୟ୍‌ ଇର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ମାତର୍‌ ସିସୁର୍‍ ଆୟାୱିଜୁ ମାଟା ଇଜିମାର୍‌ଇ ବେଡ଼ାଦୁ ପ୍ରବୁ ଜିସୁ ନିଜେନେ ୱାରିମାନୁ ୱାତାନ୍‌, ମାରି ଇର୍‌ଆନ୍‌, “ମି ସାନ୍ତି ଆପିତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ମାତର୍‌ ସିସୁର୍‍ କାବାଜି ମାରି ତିଲାଜି ଉଣ୍ତ୍ରି ଦୁବା ସୁଡ଼ୁଜିନାପ୍‌ ଇଜି ଅଡ଼୍‌ବିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ଆବେଟ୍‌ ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଇନ୍‌ନ୍ଧାନିଙ୍ଗ୍‌ ତିଲାଜିନିଦେର୍‌ ? ମାରି ମି ମୋନ୍‌ତୁ ଏନ୍ଧା ନାମ୍‍ଏଣ୍‍ଗା ଲୋଇ ଲୋଇ ୱାର୍‌ଗିଜିନିଦେର୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ଇକାନ୍‌ ଜେ ନିଜେ ନାନ୍, ନା କିୟୁ ମାରି ପାଦାମ୍‌କୁ ସୁଡ଼ୁଦୁ, ନାଙ୍ଗିଁ ମୁଟ୍‌ସୋ ସୁଡ଼ୁଦୁ, ମାତର୍‌ ନାନ୍ ଏଣ୍ତେସ୍‌ ଜିବନ୍‌ମାନି ମେନ୍ଧଲ୍‍ ମାନିକା ସୁଡ଼ୁଜିନିଦେର୍‍, ଦୁବା ଆୟାୱାଜା ସିଲେ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ମାରି, ଜିସୁ ଇକା ଇନ୍‌ଞ୍ଜି ୱାରିଙ୍ଗ୍‌ ନିଜେଦି କିୟୁ ମାରି ପାଦାମ୍‌କୁ ତର୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ଆଦେଙ୍ଗ୍‌ ୱାର୍‌ ବିସ୍‍ବାସ୍‍ କିଏତାର୍‍, ଆତିଙ୍ଗ୍‌ବା କାବାଆଜି ୱେଡ଼ିକା ଆତାର୍‌ ଆରିଙ୍ଗ୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, ଇବେନୁ ମି ଲାକ୍‌ତୁ ଇନିକା ଉଣିକା ମାନାତ୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ଆବେଟ୍‌ ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ କାଣ୍ତେକ୍‌ ୱାର୍‌ତି ମିନ୍‌କୁ ସିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ମାରି, ୱାନ୍‌ ଆୟା ମିନ୍‌କୁ ଅତାନ୍‌ନୋ ୱାରି ଆଗିଡ଼ି ତିର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ମୋସାଦି ନିୟମ୍‌ତୁ ମାରି ବାବବାଦିରି ମାରି ଗୀତସଂହିତା ଦାର୍ମୁସାସ୍ତ୍ରଦୁ ନା ବିସୟ୍‌ତାନ୍‌ ଆମାକା ଆମାକା ରାସାତାମାନାତ୍‌, ଆୟାୱିଜୁ ପୁରା ଆଦେଙ୍ଗ୍‌ ଦର୍‌କାର୍‌, ନାନ୍ ମି ୱାଲେ ମାର୍‌ଇ ୱାଲେ ମିଙ୍ଗିଁ ଇୟାୱିଜୁ ମାଟା ଇର୍ହାମାର୍ହା ।” ");
INSERT INTO kfcp_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ନାସ୍ତିୱାଲେ ୱାର୍‌ ଏଣ୍ତେସ୍‌ ଦାର୍ମୁସାସ୍ତ୍ରଦି ବିସୟ୍‌ ବୁଜାଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାର୍‍, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାନ୍‌ ୱାରି ବୁଦିଦି ସେର୍‍ଲା ରେତାନ୍‍; ");
INSERT INTO kfcp_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ମାରି, ଜିସୁ ସିସୁରି ଲାକ୍‌ତୁ ୱାଜି ଇର୍ହାନ୍‌, “ଇୟାୱାଜା ରାସାତାମାନାତ୍‌, କ୍ରିସ୍ତ ଦୁଃକ୍‌ ପୟ୍‌ନାନ୍‌ ମାରି ମୁନେଟାନ୍‍ ସାତି ଲୋକାମାଣାନ୍‌ ଡ଼େସି ନିଙ୍ଗିଁନାନ୍‍, ");
INSERT INTO kfcp_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ମାରି ଜିରୁସାଲମ୍‍ତାନ୍‍ ଆରାମ୍‌ କିଜି ୱିଜୁ ଜାତି ଲାକ୍‌ତୁ ୱାନି ଦର୍‌ତାନ୍‌ ପାପ୍‌କେମା ଉଣ୍ତିଙ୍ଗ୍‌ ମନ୍‍ତିଙ୍ଗ୍‍ ଡ଼େପ୍‍ନି ବିସୟ୍‌ତାନ୍‌ ଲୋକୁ ୱିକ୍‍ନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ମିର୍‌ ଇୟାୱିଜୁ ବିସୟତି ସାକି ଆନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ମାରି ସୁଡ଼ୁଦୁ, ନା ବୁବା ଆମାକା ପାର୍‌ମାଣ୍‌ କିତାମାନାନ୍‍, ଆକା ନାନ୍ ମି ଲାକ୍‌ତୁ ପକ୍‍ନା, ମାତର୍‌ ମୁସ୍‌କୁରାନ୍‌ ସାକ୍ତି ପୁଟ୍‍ଇ ସାନ୍ଦି ମିର୍‌ ଇୟା ଗାଡ଼୍‍ତୁ ମାନ୍‌ଡ୍ରୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ତାନିୱେନ୍‍କା ଜିସୁ ୱାରିଙ୍ଗ୍‌ ବେତନିୟାଦୁ ସନି ସାରି ସାନ୍ଦି ଅତାନ୍‍ ମାରି ନିଜେଦି କିୟୁ ପେର୍‌ଜି ୱାରିଙ୍ଗ୍‌ ଆସିର୍ବାଦ୍‌ କିତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ମାରି, ୱାରିଙ୍ଗ୍‌ ଆସିର୍ବାଦ୍‌ କିବୁ କିବୁ ୱାନ୍‌ ୱାରିମାଣାନ୍‌ ୱେର୍‌ଏ ଆଜି ମୁସ୍‌କୁପୁର୍‌ତୁ ସର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ମାରି, ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ମାଡ଼ିସ୍‌ କିଜି ନାଣ୍ତ ୱେଡ଼ିକାଦାନ୍‌ ଜିରୁସାଲାମ୍‍ତୁ ଡ଼େସିୱାତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ମାରି ୱାର୍‌ ୱିଜୁଦିନ୍‌ ମନ୍ଦିର୍‌ତୁ ମାନ୍‌ଜି ମାପୁରୁଦି ଦନ୍ୟବାଦ୍‌ କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ ।");
INSERT INTO kfcp_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ଆଗ୍‌ଡ଼ି ବାକ୍ୟ ମାର୍‌ଆତ୍‌, ବାକ୍ୟ ମାପୁରୁୱାଲେ ମାର୍‌ଆତ୍‌, ଆୟା ବାକ୍ୟ ମାପୁରୁ ମାର୍‌ଆତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ବାକ୍ୟ ଆଗ୍‌ଡ଼ି ମାପୁରୁୱାଲେ ମାର୍‌ଆତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ୱାନି ମାଣାନ୍‌ ମାପୁରୁ ୱିଜୁ ତିଆର୍‌ କିତାତ୍‍; ମାରି ଆମାୱିଜୁ ତିଆର୍‌ ଆତାମାନାତ୍‌, ଆୟା ଲୋଇରାନ୍‌ ଉଣ୍ତ୍ରେବା ୱାନିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ତିଆର୍‌ ଆଏତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ୱାନିମାନୁ ଜିବନ୍‌ ମାର୍‌ଆତ୍‌ ମାରି ଆୟା ଜିବନ୍‌ ଲୋକା ଜାୟ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ଆୟା ଜାୟ୍‌ ସିକାଟିଦୁ ଜାୟ୍‍ଆଜି ୱାଜିନାତ୍‍, ମାରି ସିକାଟି ଆକା ମାନାଏଜିନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ମାପୁରୁ ୱାନି କାବୁର୍‌ ସିନିୱାନିଙ୍ଗ୍‍ ପୋକ୍‌ତାନ୍‌; ୱାନି ଦର୍‌ ଜୋହନ । ");
INSERT INTO kfcp_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ୱାନ୍‌ ଏଣ୍ତେସ୍‌ ଜାୟ୍‌ ବିସୟ୍‌ତାନ୍‌ ସାକି ସିନାନ୍‍, ମାରି ଆକା ୱେନ୍‌ଞ୍ଜି ୱିଜେରେ ବିସ୍‌ବାସ୍‌ କିନାର୍‌, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାନ୍‌ ୱାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ଜୋହନ ନିଜେ ଆୟା ଜାୟ୍‌ ସିଲେତାନ୍‌, ମାତର୍‌ ଜାୟ୍‌ ବିସୟ୍‌ତାନ୍‌ ସାକି ସିଦେଙ୍ଗ୍‍ ଇଜି ୱାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ଏମେ ସତ୍‌ ଜାୟ୍‌ ଦୁନିଆଦି ୱାଜି ୱିଜୁ ଲୋକାଙ୍ଗ୍‌ ଜାୟ୍‌ ସିନାତ୍‌, ଆକାଦେ ସତ୍‌ତି ଜାୟ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ବାକ୍ୟ ଦୁନିଆଦୁ ମାର୍‌ଆତ୍‌ ମାରି ଦୁନିଆ ୱାନି ମାଣାନ୍‌ ତିଆର୍‌ ଆତାତ୍‌, ଆରିଙ୍ଗ୍‍ବା ଦୁନିଆ ୱାନିଙ୍ଗ୍‌ ସିନିସ୍‍ କିଏତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ୱାନ୍‌ ନିଜେଦି ରାଜିଦୁ ୱାତାନ୍‌, ଆରିଙ୍ଗ୍‍ବା ୱାନି ନିଜେଦି ଲୋକୁ ୱାନିଙ୍ଗ୍‌ ମାନାଏତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ମାତର୍‌ ଏସୋ ଲୋକୁ ୱାନିଙ୍ଗ୍‌ ମାନାତାର୍‍, ଅର୍ତାତ୍‍ ଏମେକାର୍‌ ୱାନି ଦର୍‌ତାନ୍‌ ବିସ୍‌ବାସ୍‌ କିତାର୍‍, ଆୟା ୱିଜେରିଙ୍ଗ୍‌ ୱାନ୍‌ ମାପୁରୁଦି କଡ଼ର୍‌ ଆଦେଙ୍ଗ୍‌ ଅଦିକାର୍‌ ସିତାନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ୱାର୍‌ ମାପୁରୁଦି ମାରିସିର୍‌ ନିଜେଦି ବଦାଦାନ୍ କି, ମେନ୍ଦଲ୍‌ତି ନେତେର୍‌ତାନ୍ କି ଲୋକା ବଦାଦାନ୍ ଜନମ୍‌ ଆଏର୍‌, ମାତର୍‌ ମାପୁରୁ ନିଜେ ୱାରି ବୁବା । ");
INSERT INTO kfcp_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ମାରି, ଆୟା ବାକ୍ୟ ନର୍‍ ମେନ୍ଧଲ୍‍ ଆସ୍‌ସି ମା ୱାଲେ ଜିତାନ୍‍ । ୱାନ୍‌ ଦୟା ନି ସତ୍‍ତୁ ପୁରା ଆଜିମାର୍ହାନ୍‍ । ମାରି ମାପୁରୁଦି ଅରେନ୍‍ନେ ମାରିସିୱାଜା ୱାନ୍‌ ଏମେ କାବାଆନି ମହିମାକି ପୋଇତାମାର୍‍ହାନ୍‍, ଆକା ମାପ୍‌ ସୁଡ଼ୁତାପ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ଜୋହନ ୱାନି ବିସୟ୍‌ତାନ୍‌ ସାକି ସିଜି ନାଣ୍ତ ଆଉଲି ଆଜି ଇର୍‌ଆନ୍‌, “ଏନ୍‌ ନା ୱେନ୍‌କା ୱାଜିନାନ୍‍, ୱାନ୍‌ ନାଙ୍ଗିଁ ପେରିକାନ୍‌, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ନା ଜନମ୍‌ ଆନି ଆଗ୍‌ଡ଼ି ମାର୍‌ଆନ୍‌, ଏମେୱାନି ବିସୟ୍‌ତାନ୍‌ ନାନ୍ ଇକା ଇର୍ହାମାର୍ହା, ୱାନ୍‌ ଇକାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ଆଦେଙ୍ଗ୍‌ ୱାନି ଦୟାଦି ପୁରାଦାନ୍‌ ମାଡ୍‌ ୱିଜେରେ ଆସିର୍ବାଦ୍‌ ପୋଇତିମାନିକା, ହୁଁ, ଆସିର୍ବାଦ୍‌ ମୁସ୍‌କୁ ଆସିର୍ବାଦ୍‌ ପୋଇତିମାନିକା । ");
INSERT INTO kfcp_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ଇରିଙ୍ଗ୍‌ ନିୟମ୍‌ ମାପୁରୁ ମୋସା ମାଣାନ୍‌ ସିତାନ୍‌, ମାତର୍‌ ଦୟା ନି ସତ୍‌ ଜିସୁ କ୍ରିସ୍ତ ମାଣାନ୍‌ ୱାତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ଏନ୍‌ ଏସାଙ୍ଗ୍‍ ମାପୁରୁଙ୍ଗ୍‍ଁ ସୁଡ଼ୁଏନ୍‌, ବୁବାସି ଗାତୁଦୁ ମାନି ଅରେନ୍‍ନେ ୱାନି ଲାଡ୍‌ ମାରିସି, ୱାନିଙ୍ଗ୍‌ ନେସିସ୍‍ କିତାମାନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ଜିରୁସାଲାମ୍‍ତି ଜିହୁଦି ପେରିକାର୍‌ ଏସ ଲୋକ୍‌ ଦାର୍ମୁଜାଜକରିଙ୍ଗ୍‍ ମାରି ଲେବିୟରିଙ୍ଗ୍‍ ଜୋହନତି ଲାକ୍‌ତୁ, “ନିନ୍‌ ଏନ୍‌ ?” ଇଜି ୱେନ୍‍ବାଦେଙ୍ଗ୍‍ ପୋକ୍‌ତାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ୱାନ୍‌ ମାନାଏଜି ସତ୍‌ତାନ୍‌ ୱେର୍‌ତାନ୍‌, “ନାନ୍ କ୍ରିସ୍ତ ଆଏ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ଆବେଟ୍‌ ୱାର୍‌ ଜୋହନ୍‍ତିଙ୍ଗ୍‍ ୱେନ୍‍ବାତାର୍‌, ଆରିଙ୍ଗ୍‌, “ନିନ୍‌ ଇନିକା ଏଲିୟ୍‌ ?” ୱାନ୍‌ ଇର୍‌ଆନ୍‌, “ନାନ୍ ଆଏ ।” ନିନ୍‌ ଇନିକା ଆୟା ବାବବାଦି ? ୱାନ୍‌ ଇର୍ହାନ୍‌, “ସିଲେ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ଆବେଟ୍‌ ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ମାଙ୍ଗିଁ ପୋକ୍‍ତିମାନି ୱାରିଙ୍ଗ୍‌ ଏଣ୍ତେସ୍‌ ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆଟ୍‍ନାପ୍‍, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ନିନ୍‌ ଏନ୍‌ ? ନିନ୍‌ ନିଜେଦି ବିସୟ୍‌ତାନ୍‌ ଇନିକା ଇଜିନି ?” ");
INSERT INTO kfcp_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ଜିସାୟ ବାବବାଦି ଏଣ୍ତେସ୍‌ ୱେର୍‍ତାମାର୍‍ଆନ୍‍, ଆୟାୱାଜା ଜୋହନ ଇର୍ହାନ୍‌ । “ନାନ୍ ଆୟା ସିମ୍ରାବାଡିଦୁ ଆଉଲିଆଜିମାନି ଅରେନ୍‍ୱାନି ବଲ୍, ପ୍ରବୁଦି ସାରି ସାଡ଼ୁକୁ କିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ମାରି, ପାରୁସିର୍‌ ପୋକ୍‍ତିମାନି କାବୁର୍‌ ଅନିକାର୍‍ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“ନିନ୍‌ ଜଦି କ୍ରିସ୍ତ ମାରି ଏଲିୟ୍‌ ମାରି ଆୟା ବାବବାଦି ଆଇ, ଆରିଙ୍ଗ୍‌ ଏନ୍ଦା ଡୁବନ୍‌ ସିଜିନି ?” ");
INSERT INTO kfcp_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ଜୋହନ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନାନ୍ ଏର୍‌ତୁ ଡୁବନ୍‌ ସିଜିନା; ଆମାୱାନିଙ୍ଗ୍‌ ମିର୍‌ ନେସ୍‌ଇଦେର୍‌, ୱାନ୍‌ ମିବାନ୍‍ ମାନାନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ୱାନ୍‌ ନା ୱେନ୍‌କା ୱାଜିନାନ୍‍, ୱାନି ଜୁତେଙ୍ଗ୍‌ତି ଗାଟି କୁତ୍‌ତେଙ୍ଗ୍‌ ବା ନାନ୍ ଜଗ୍‌ ସିଲେ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ଜର୍ଦନ ଗାଡାଦି ଆୟାପାଡ଼ିରି ଆମା ବେତନିଆଦୁ ଜୋହନ ଡୁବନ୍‌ ସିଜିମାର୍‍ଆନ୍‍, ଆୟା ବାଡିଦୁ ଇୟାୱିଜୁ ଗଟାତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ମାର୍‌ନାଣ୍ଡିଙ୍ଗ୍‌ ଜୋହନ ଜିସୁଙ୍ଗୁଁ ୱାନି ଲାକ୍‌ତୁ ୱାନିକା ସୁଡ଼ୁଜି ଇର୍‌ଆନ୍‌, ଇକା ସୁଡ଼ୁଦୁ, ମାପୁରୁଦି ମେଣ୍ତାପିଲା, ଏନ୍‌ ଦୁନିଆଦି ପାପ୍‌ ପିଣ୍ତ୍‍ନା ଅନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ନା ୱେନ୍‌କା ଏନ୍‌ ୱାଜିନାନ୍‍, ୱାନ୍‌ ନାମାଣାନ୍‍ ପେରିକାନ୍‌, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ନା ଜନମ୍‌ ଆଗ୍‍ଡ଼ି ମାର୍‍ଆନ୍‍, ଆମାୱାନି ବିସୟ୍‌ତାନ୍‌ ନାନ୍ ଇକା ଇର୍‌ଆମାର୍ହା, ୱାନ୍‌ ଆକାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ନାନ୍ ବା ୱାନିଙ୍ଗ୍‌ ସିନିସ୍‍ କିଏ ମାର୍ହା, ମାତର୍‌ ୱାନ୍‌ ଏଣ୍ତେସ୍‌ ଇସ୍ରାଏଲ୍‌ ଲୋକାମାନୁ ନେସାଇ ଆନାନ୍‌, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ଏର୍‌ତୁ ଡୁବନ୍‌ ସିଦେଙ୍ଗ୍‍ ୱାତାମାନା । ");
INSERT INTO kfcp_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ମାରି ଜୋହନ ସାକି ସିଜି ଇର୍ହାନ୍‌, “ନାନ୍ ପବିତ୍ର ଆତ୍ମା ପାର୍‍ୱାଦି ୱାଜା ବାଦଡ଼୍‍ତାନ୍‍ ରେତାଜି ୱାଦ୍‌ ୱାନି ମୁସ୍‌କୁ ବାସ୍‍ନିକା ସୁଡ଼ୁତା । ");
INSERT INTO kfcp_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ନାନ୍ ବା ୱାନିଙ୍ଗ୍‌ ସିନିସ୍‍ କିଏ ମାର୍ହା, ମାତର୍‌ ଏନ୍‌ ନାଙ୍ଗିଁ ଏର୍‌ତୁ ଡୁବନ୍‌ ସିଦେଙ୍ଗ୍‍ ପୋକ୍‌ତାନ୍‌, ୱାନ୍‌ ନାଙ୍ଗିଁ ଇର୍‌ଆନ୍‌, ଆମାୱାନି ମୁସ୍‌କୁ ଆତ୍ମା ବାସ୍‍ନିକା ସୁଡ଼ୁନି, ଏନ୍‌ ପବିତ୍ରଆତ୍ମାଦୁ ଡୁବନ୍‌ ସିନାନ୍‍, ଆକାନ୍‍ ଆୟା ଲୋକୁ । ");
INSERT INTO kfcp_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ମାରି, ନାନ୍ ଆକା ସୁଡ଼ୁତାମାନା ମାରି ୱାନ୍‌ ମାପୁରୁଦି ମାରିସି ଇଜି ସାକି ସିତାମାନା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ମାର୍‌ନାଣ୍ଡିଙ୍ଗ୍‌ ମାରିଡ଼େସି ଜୋହନ ନି ୱାନି ସିସୁରି ଲୋଇ ରିଏରି ୱାଲେ ନିର୍‍ଆମାର୍‍ଆର୍‍; ");
INSERT INTO kfcp_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ମାରି, ୱାନ୍‌ ଜିସୁଙ୍ଗୁଁ ଆୟା ସାରି ସିଜି ସନିକା ସୁଡ଼ୁଜି ୱାନିଙ୍ଗ୍‌ କାଣ୍‌ଗା କିଜି ଇର୍ହାନ୍‌, ଇକାନ୍‌ ସୁଡ଼ୁଦୁ, ମାପୁରୁଦି ମେଣ୍ତା ପିଲା । ");
INSERT INTO kfcp_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ଆୟା ରିଏର୍‌ ସିସୁର୍‍ ୱାନି ମାଟା ୱେନ୍‌ଜି ଜିସୁୱାଲେ ୱାଲେ ସରଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ଜିସୁ ମାର୍‍ଜି ୱେସ୍‍ସି ୱାରିଙ୍ଗ୍‌ ୱେନ୍‌କା ୱେନ୍‌କା ୱାଜିମାନିକା ସୁଡ଼ୁଜି ୱେନ୍‌ବାତାନ୍‌, “ମିର୍‌ ଇନିକା ପୋୟ୍‍ଜିନିଦେର୍‍ ?” ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ରାବ୍‍ବି” ଅନୁବାଦ୍‍ କିତିଙ୍ଗ୍‌ ତେନି ଅର୍ତ “ଗୁରୁ,” ନିନ୍‌ ଏମେ ତେବାନି ? ");
INSERT INTO kfcp_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ରାଦୁ, ସୁଣିଦେର୍‍ । ଆବେଟ୍‌ ୱାର୍‌ ସଲ୍‌ସି ୱାନି ବାସାନିକା ସୁଡ଼ୁତାର୍‌, ମାରି ଆୟା ନାଣ୍ଡିଙ୍ଗ୍ ୱାନିୱାଲେ ତେବାତାର୍‌; ନାସ୍ତିୱାଲେ ମିଲ୍‌ମିଲିକା ସାର୍‍ଟା ୱେଡ଼ା ଆତାମାର୍‍ଆତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ଏମେ ରିଏର୍‌ ଜୋହନତି ମାଟା ୱେନ୍‌ଜି ଜିସୁଦି ୱାଲେ ୱାଲେ ସର୍‍ଆମାର୍‍ଆର୍‍, ୱାରି ଲୋଇ ଅରେନ୍‍ ସିମୋନ୍‌ ପିତର୍‌ତି ତଡ଼ାନ୍‌ ଆନ୍ଦ୍ରିୟ ମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ୱାନ୍‌ ପାର୍‌ତୁମ୍‌ ୱାନି ତଡ଼ାନ୍‌ ସିମୋନ୍‌ତିଙ୍ଗ୍‍ ପୋୟ୍‍ଜି ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ମାପ୍‌ “ମସିହଦି” ସୁଡ଼ୁତାମାନାପ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ଜିସୁ ଲାକ୍‌ତୁ ତାତାନ୍‍ । ଜିସୁ ପିତର୍‌ ତରିନ୍‌ ସୁଡ଼ୁଜି ଇର୍‌ଆନ୍‌, “ନିନ୍‌ ସିମୋନ୍‌ ଜୋହନତି ମାରିସି । ନିନ୍‌ କେପା ଦର୍‌ତାନ୍‌ ୱେଙ୍ଗ୍‍ଁନି ଅନୁବାଦ କିତିଙ୍ଗ୍‌ ତେନି ଅର୍ତ କାଲୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ମାର୍‌ନାଣ୍ଡିଙ୍ଗ୍‌ ଜିସୁ ଗାଲିଲିଦୁ ସହସ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ବଦା କିତାନ୍‌, ମାରି ୱାନ୍‌ ପିଲିପ୍‌ତିଙ୍ଗ୍‌ ସୁଡ଼ୁତାନ୍‌ନୋ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନା ୱାଲେ ରାଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ପିଲିପ୍‌ ବେତ୍‍ସାଇଦାଦି ଲୋକୁ ମାର୍‌ଆନ୍‌, ଆକା ଆନ୍ଦ୍ରିୟ ନି ପିତର୍‌ତି ଗାଡ଼୍‌ ମାର୍‌ଆତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ପିଲିପ୍‌ ନିତନିଏଲ୍‍ତିଙ୍ଗ୍‍ ପୋୟ୍‍ଜି ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ଆମାୱାନି ବିସୟ୍‌ତାନ୍‌ ମୋସା ନିୟମ୍‌ ବଇଦୁ ରାସ୍‌ତାମାନାନ୍‌, ମାରି ବାବବାଦିର୍ ବା ରାସ୍‌ତାମାନାର୍‌, “ମାପ୍‌ ୱାନିଙ୍ଗ୍‌ ପୋୟ୍‍ତାମାନାପ୍‍; ୱାନ୍‌ ଜୋସେପ୍‌ତି ମାରିସି ନାଜରିତିୟଦି ଜିସୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ନିତନିଏଲ୍‍ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ନାଜରିତଦାନ୍‍ ନୋ ଇନି ନେଗି ବିସୟ୍‌ ସନା ୱାନାତ୍‌ ନୋ ?” ପିଲିପ୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ୱାଜ ସୁଡ଼ୁଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ଜିସୁ ନିତନିଏଲ୍‍ତିଙ୍ଗ୍‍ ୱାନି ଲାକ୍‌ତୁ ୱାନିକା ସୁଡ଼ୁଜି ୱାନି ବିସୟ୍‌ତାନ୍‌ ଇର୍‌ଆନ୍‌, “ଇଦି ସୁଡ଼ୁଦୁ, ସତେନେ ଇକାନ୍‌ ଅରେନ୍‍ ଇସ୍ରାଏଲ୍‌ତି ଲୋକୁ, ୱେନିମାନୁ ଇନି ତାଗ୍‌ଇକା ସିଲେତ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ନିତନିଏଲ୍‍ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ନାଙ୍ଗିଁ ନିନ୍‌ ଏଣ୍ତେସ୍‌ ସିନିସ୍‍କିତି ?” ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ପିଲିପ୍‌ ନିଙ୍ଗିଁ କୁକ୍‍ନି ଆଗ୍‌ଡ଼ି ନିନ୍‌ ଏସ୍ତିୱାଲେ ତଗା ମାରାନ୍‌ ଆଡ୍‍ଗି ମାର୍ହି, ନାସ୍ତିୱାଲେ ନାନ୍ ନିଙ୍ଗିଁ ସୁଡ଼ୁତାମାର୍ହା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ନିତନିଏଲ୍‍ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଏ ଗୁରୁ, ନିନ୍‌ ମାପୁରୁଦି ମାରିସି, ନିନ୍‌ ଇସ୍ରାଏଲ୍‌ତି ରାଜା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନାନ୍ ନିଙ୍ଗିଁ ତଗା ମାରାନ୍‌ ଆଡ୍‍ଗି ସୁଡ଼ୁତାମାର୍‍ହା ଇଜି ଇର୍ହାଆକା ନୋ ନିନ୍‌ ବିସ୍‌ବାସ୍‌ କିଜିନି ? ନିନ୍‌ ତେନେ ମାଣାନ୍‌ ପେରି ପେରି ବିସୟ୍‌ ସୁଣି ।” ");
INSERT INTO kfcp_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ମାରି, ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ସତ୍‌ ସତ୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ମିର୍‌ ମୁସ୍‌କୁପୁର୍‌ ରେଆତିକା ମାରି ମାପୁରୁଦି ଦୁତ୍‌କୁ ମନୁସ୍ୟପୁତ୍ରଦି ମୁସ୍‌କୁ ଏକ୍‍ନିକା ନି ରେତାନିକା ସୁଣିଦେର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ରିନେଟି ୱେନ୍‌କା ଗାଲିଲିଦି କାନା ଗାଡ଼୍‌ତୁ ଉଣ୍ତ୍ରି ପେଡ଼ି ଆଜିମାର୍ହାତ୍‍, ମାରି ଜିସୁରି ଆଇସି ଆବେ ମାର୍‌ଆତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ଜିସୁ ନି ୱାନି ସିସୁରିଙ୍ଗ୍‌ ବା ଆୟା ପେଡ଼ିଦୁ କୁକ୍‍ତାମାର୍‍ଆର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ଏସ୍ତିୱାଲେ ଅଙ୍ଗୁର୍‍ରସ୍‍ ୱିଜିତେଆକା ଜିସୁରି ଆଇସି ୱାନିଙ୍ଗ୍‌ ଇର୍ହାତ୍‌, “ୱାରି ଅଙ୍ଗୁର୍‍ରସ୍‍ ସିଲୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ଆବେଟ୍‌ ଜିସୁ ତାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନାଙ୍ଗିଁ ଇନିକା କିଦେଙ୍ଗ୍‌ ଆନାତ୍‌ ନିନ୍‌ ୱେର୍‍ମା, ନା ୱେଡ଼ା ଇୟାସାନ୍ଦି ଇଗା ରେଏଦେ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ଜିସୁଦି ଆଇସି ସେବାକିନିୱାରିଙ୍ଗ୍‌ ଇର୍ହାତ୍‌, “ୱାନ୍‌ ମିଙ୍ଗିଁ ଆମାକା ଇନାନ୍‌, ଆକା କିଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ମାରି, ଆବେ ଜିହୁଦିର୍‌ ନର୍‍ବାନି ନିୟମ୍‍ତାନ୍‍ ସଗୋଟା କାଲ୍‍କାଣ୍‍କୁ ତିଆର୍‌ଆତି ପେରି ପେରି ଏର୍‍ କୁଣ୍ତ୍‍କୁ ମାର୍‍ଏ, ୱିଜୁ କୁଣ୍ତ୍‍କାଙ୍ଗ୍‍ଁ ପୁରା ସହେ ଲିଟର ଏର୍‌ ଆସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‍ନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ଜିସୁ ସାକର୍‌କାଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, କୁଣ୍ତ୍‍କାଙ୍ଗ୍‍ଁ ଏର୍‌ ପୁରା କିଦୁ । ଆବେଟ୍‌ ୱାର୍‌ ଆୟାୱିଜୁ ମୁସ୍‌କୁ ସାନ୍ଦି ପୁରା କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ମାରି, ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ଇଲେଇ ଆନ୍ଦ୍‍ଜି ଅସି ବୋଜିଦି ନେତା ଲାକ୍‌ତୁ ଅତୁ । ଆବେଟ୍‌ ୱାର୍‌ ଅତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ବୋଜିଦି ନେତା ଅଙ୍ଗୁର୍‍ରସ୍‍ ଆତିମାର୍‍ଇ ଆୟା ଏର୍‍ତିଙ୍ଗ୍‍ ୱେଡ଼୍‍ଜି ଆକା ଆମାଣ୍‍କୁ ୱାତାତ୍‍, ଇକା ନେସ୍‌ଏପ୍‌ ମାର୍‌ଆନ୍‌ ମାତର୍‌ ଏମେ ସେବାକିନିକାର୍‍ ଏର୍‌ ଆନ୍ଦ୍‌ତା ମାର୍‌ଆର୍‌, ୱାର୍‌ ନେସ୍‍ତାମାର୍‍ଆର୍‍, ଆଦେଙ୍ଗ୍‌ ୱାନ୍‌ ପେଡ଼ିମୁରୁଲିଙ୍ଗ୍‍ କୁକ୍‌ସି ଇର୍‌ଆନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“ୱିଜେରେ ପାର୍‌ତୁମ୍‌ ନେଗି ଅଙ୍ଗୁର୍‍ରସ୍‍ ସିନାର୍‍, ମାରି ଲୋକୁ ସସ୍‍ତି ୱେନ୍‌କା ତାଗ୍‍ଇକେଙ୍ଗ୍‍ ସିନାର୍‍; ନିନ୍‌ ଇୟାସାନ୍ଦି ନେଗି ଅଙ୍ଗୁର୍‍ରସ୍‍ ଇଟ୍‌ତିମାନି ।” ");
INSERT INTO kfcp_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ଜିସୁ ଇୟାୱାଜା ଗାଲିଲିଦି କାନା ଗାଡ଼୍‌ତୁ ୱାନି ପାର୍‌ତୁମ୍‌ କାବାଆନି ପାଣି ଆରାମ୍‌ କିଜି ନିଜେଦି ମହିମା ତର୍‍ତାନ୍‍, ମାରି ୱାନି ସିସୁର୍‍ ୱାନିବାନୁ ବିସ୍‌ବାସ୍‌ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ଇୟା ୱେନ୍‌କା ଜିସୁ ୱାନି ଆଇସି, ତଡ଼ାନ୍‌କୁ ମାରି ସିସୁରିୱାଲେ କପର୍‍ନାହୁମ୍‍ତୁ ସରଆର୍‌; ମାରି, ୱାର୍‌ ଆବେ ନାଣ୍ତ ଦିନ୍‌ ତେବାଏତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ନାସ୍ତିୱାଲେ ଜିହୁଦିର୍‌ ନିସ୍ତାର୍‌ ପଣ୍ତୟ୍‌ ଲାକ୍‌ତୁ ଇଗାୱାତା ମାର୍‌ଆତ୍‌, ମାରି ଜିସୁ ଜିରୁସାଲାମ୍‍ତୁ ସର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ମାରି, ଜିସୁ ମନ୍ଦିର୍‌ତୁ ଡ଼ାକ୍‍, ମେଣ୍ଡେଙ୍ଗ୍‌ ମାରି ପାର୍‌ୱେଙ୍ଗ୍‌ ପୋର୍‍ନିୱାରିଙ୍ଗ୍‍ ମାରି ଡାବୁଙ୍ଗୁଁ ପର୍‍ନିୱାରିଙ୍ଗ୍‍ ବାସ୍‍ତିମାରିକା ସୁଡ଼ୁତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ଆବେଟ୍‌ ୱାନ୍‌ ନାସ୍‍ତାନ୍‍ ଉଣ୍ତ୍ରି କରଡ଼ା ତିଆର୍‌ କିଜି ମେଣ୍ଡେଙ୍ଗ୍‌ ନି ଡ଼ାକାୱାଲେ ୱିଜେରିଙ୍ଗ୍‍ ମନ୍ଦିର୍‌ତାନ୍‌ ସପ୍‌ତା ସିତାନ୍‌ । ମାରି, ଡାବୁଙ୍ଗୁଁ ପର୍‌ନିୱାରି ଡାବୁଙ୍ଗୁଁ ଆଡ୍‍ଗି ୱିତ୍‍ସିପକ୍‍ସି ୱାରି ଟେବୁଲ୍‍ଙ୍ଗୁଁ ମାର୍‍ତାପକ୍‍ତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ମାରି, ୱାନ୍‌ ପାର୍‌ୱେଙ୍ଗ୍‌ ପର୍‍ନିୱାରିଙ୍ଗ୍‍ ଇର୍‌ଆନ୍‌, ଇକେଙ୍ଗ୍‍ ୱିଜୁ ଇବେଟ୍‌କୁ ଅତୁ, ନା ବୁବାଦି ଇଲ୍‍ତିଙ୍ଗ୍‍ କଣି ପର୍‌ନି ଇଲୁ କିମାଟ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ଇକା ସୁଡ଼୍‌ଜି ୱାନି ସିସୁର୍‍ ସାସ୍ତ୍ରଦୁ ରାସାତାମାନାତ୍‌ ଇଜି ଏତ୍‍କିତାର୍‍, ମାପୁରୁ “ନି ଇଲୁଦିଙ୍ଗ୍‍ ନା ଦ୍ୟାନ୍‍, ନା ଲୋଇ ସିସୁ କାସ୍‍ନି ୱାଜା ଆଜିନାତ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ଆବେଟ୍‌ ଜିହୁଦିର୍‌ ପେରିକାର୍‌ ଡ଼େସିୱାଜି ଜିସୁଦି ଲାକ୍‌ତୁ ଡ଼େସିୱାଜି ଇୟା ପ୍ରସ୍ନ ୱେନ୍‌ବାତାର୍‌, “ନିନ୍‌ ଜେ ଇୟାୱିଜୁ ପାଣି କିଦେଙ୍ଗ୍‌ ଇଜି ଅଦିକାର୍‌ ପୋୟ୍‍ତିମାନି ଇଜି ମାପ୍‌ ଏଣ୍ତେସ୍‌ ନେସ୍‌ନାପ୍‌ ? ମାଙ୍ଗିଁ ଏମେ ସିନା ଦାନ୍‌ ତର୍‍ସିନି ?” ");
INSERT INTO kfcp_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମିର୍‌ ଇୟା ମନ୍ଦିର୍‌ତିଙ୍ଗ୍‌ ରୁକ୍‍ତୁ, ମାରି ମୁନେନ୍‌ ଲୋଇ ନାନ୍ ଆକା ପେର୍‍ନା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ଆବେଟ୍‌ ଜିହୁଦିର୍‌ ଇର୍ହାର୍‌, “ଇୟା ମନ୍ଦିର୍‌ ତିଆର୍‌ କିଦେଙ୍ଗ୍‌ ଇଜି ସାଲିସ୍‍ ସୋ ବାର୍‍ସେକ୍‍ ଆସ୍‍ତା ମାର୍‍ଆତ୍‍; ମାରି ନିନ୍‌ ଇନିକା ତାନିଙ୍ଗ୍‌ ମୁନେଟାନ୍‍ ପେର୍‍ନି ?” ");
INSERT INTO kfcp_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ମାତର୍‌ ଜିସୁ ନିଜେଦି ମେନ୍ଦଲ୍‌ରୁପ୍‍ତି ମନ୍ଦିର୍‌ ସୁଡ଼ୁଜି ମନ୍ଦିର ବିସୟ୍‌ତାନ୍‌ ଇଜିମାର୍‍ଆନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ଆବେଟ୍‌ ୱାନ୍‌ ସାତିମାଣ୍‌କୁ ନିଙ୍ଗିଁତି ୱେନ୍‌କା ୱାନି ସିସୁର୍‍ ୱାନ୍‌ ଇକା ଇର୍ହାମାର୍ହାନ୍‌ ଇଜି ଏତ୍‍କିତାର୍‍; ମାରି, ୱାର୍‌ ଦାର୍ମୁସାସ୍ତ୍ର ନି ଜିସୁ ଇର୍‍ଇମାର୍‍ଇ ମାଟା ବିସ୍‌ବାସ୍‌ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ନିସ୍ତାର୍‍ ପଣ୍ତୟ୍‌ ଆନିୱାଲେ ଜିସୁ ଜିରୁସାଲମ୍‌ତୁ ମାନିୱାଲେ ନାଣ୍ତ ଲୋକୁ ୱାନ୍‌ କିତି କାବାଆନି ପାଣିଙ୍ଗ୍‍ୱିଜୁ ସୁଡ଼ୁଜି ୱାନି ଦର୍‌ତାନ୍‌ ବିସ୍‌ବାସ୍‌ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ମାତର୍‌ ଜିସୁ ୱାରି ମୁସ୍‌କୁ ବିସ୍‌ବାସ୍‌ କିଏଣ୍‍ଗା ୱାରି ମାଣ୍‌କୁ ନିଜେଦିଙ୍ଗ୍‍ ୱେରେହେ ଇଟ୍‌ତାନ୍‌, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ୱିଜେରିଙ୍ଗ୍‍ ନେସ୍‌ସି ମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ମାରି, ଏନ୍‌ ଜେ ଲୋକା ବିସୟ୍‌ତାନ୍‌ ସାକି ସିନାନ୍‍, ଇକା ୱାନି ଦର୍‌କାର୍‌ ସିଲେତାତ୍‍, ଇରିଙ୍ଗ୍‌ ଲୋକା ଜିବନ୍‌ତୁ ଇନିକା ମାନାତ୍‌, ଆକା ୱାନ୍‌ ନିଜେ ନେସ୍‌ସି ମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ପାରୁସିର୍ ଲୋଇ ନିକଦିମ ଦର୍‍ତି ଅରେନ୍‍ ଲୋକୁ ମାର୍‌ଆନ୍‌, ୱାନ୍‌ ଜିହୁଦିରି ଅରେନ୍‍ ନେତା ମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ୱାନ୍‌ ନାଡ଼ା ସମୟତୁ ଜିସୁଦି ଲାକ୍‌ତୁ ୱାଜି ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ଏ ଗୁରୁ, ନିନ୍‌ ଜେ ମାପୁରୁ ମାଣ୍‌କୁ ୱାତିମାନି, ଇକା ମାପ୍‌ ନେସ୍‌ନାପ୍‌, ଇରିଙ୍ଗ୍‌ ନିନ୍‌ ଇୟା ଏମେ ୱିଜୁ କାବାଆନି ପାଣି କିଜିନି, ମାପୁରୁ ନିୱାଲେ ସିଲେତିଙ୍ଗ୍‍ ଆୟାୱିଜୁ ଏନ୍‌ କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ସତ୍‌ ସତ୍‌ ନାନ୍ ନିଙ୍ଗିଁ ଇଜିନା, ମାରିଡ଼େସି ଜନମ୍‍ ଆଏତିଙ୍ଗ୍‍ ଏନ୍‌ ମାପୁରୁଦି ରାଜି ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ନିକଦିମ ଜିସୁଙ୍ଗୁଁ ୱେନ୍‌ବାତାନ୍‌, “ଡକ୍ରା ଆତିଙ୍ଗ୍‌ ଲୋକୁ ଏଣ୍ତେସ୍‌ କିଜି ଜନମ୍‍ ଆଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାନ୍‍ ? ୱାନ୍‌ ଇନିକା ରିଜା ନିଜେଦି ଆଇସି ପଟାଦୁ ଡ଼ୁଗୁଜି ଜନମ୍‍ ଆନାନ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ଜିସୁ ଇର୍‌ଆନ୍‌, ସତ୍‌ ସତ୍‌ ନାନ୍ ନିଙ୍ଗିଁ ଇଜିନା, “ଏର୍‌ ନି ଆତ୍ମାଦାନ୍‌ ଜନମ୍‌ ଆଏତିଙ୍ଗ୍‍ ଏନ୍‌ ମାପୁରୁଦି ରାଜିଦୁ ଡ଼ୁଗୁଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ମେନ୍ଦଲ୍‌ତାନ୍‌ ଆମାକା ଜନମ୍‍, ଆକା ମେନ୍ଦଲ୍‍ତିକା; ମାରି, ଆତ୍ମାଦାନ୍‌ ଆମାକା ଜନମ୍‍, ଆକା ଆତ୍ମାଦିକା । ");
INSERT INTO kfcp_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ନିଙ୍ଗିଁ ଜେ ମାରିଡ଼େସି ଜନମ୍‌ ଆଦେଙ୍ଗ୍‌ ଆନାତ୍‌ ଇଜି ନାନ୍ ଜେ ନିଙ୍ଗିଁ ଇର୍‌ଆ, ଆବେନ୍‌ କାବା ଆମା । ");
INSERT INTO kfcp_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ଗାଲି ଆମା ତରିନ୍‍ ବଦାକିନାତ୍‍, ଆୟା ତରିନ୍‍ ସନାତ୍‌, ମାରି ମିର୍‌ ତାନି ବଲ୍ ୱେନିଦେର୍‍, ମାତର୍‌ ଆକା ଆମାଟ୍‍କୁ ୱାନାତ୍‌ ମାରି ଏମେ ସନାଟ୍‌, ଆକା ନେସ୍‌ଇଦେର୍‌; ଆତ୍ମାଦାନ୍‌ ଜନମ୍‌ ଆତି ୱିଜେରି ଲୋକୁ ଆୟାୱାଜା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ନିକଦିମ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାନ୍‌, “ଇୟାୱିଜୁ ଏଣ୍ତେସ୍‌ ଆଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାତ୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନିନ୍‌ ଇସ୍ରାଏଲ୍‌ତି ଅରେନ୍‍ ଗୁରୁ ଆଜି ବା ଇନିକା ଇୟାୱିଜୁ ବୁଜାଇଜିନି ? ");
INSERT INTO kfcp_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ନାନ୍ ନିଙ୍ଗିଁ ସତ୍‌ ସତ୍‌ ଇଜିନା, ମାପ୍‌ ଆମାକା ନେସ୍‌ନାପ୍‌, ଆକା ଇନାପ୍‍, ମାରି ଆମାକା ସୁଡ଼ୁତାମାନାପ୍‍, ଆୟା ବିସୟ୍‌ତାନ୍‌ ସାକି ସିନାପ୍‍, ମାରି ମିର୍‌ ମା ସାକି ମାନାଇଜିନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ନାନ୍ ମିଙ୍ଗିଁ ଦୁନିଆଦି ବିସୟ୍‌ ୱେର୍‌ତିଙ୍ଗ୍‌ ଜଦି ମିର୍‌ ବିସ୍‌ବାସ୍‌ କିଇଦେର୍‍, ଆରିଙ୍ଗ୍‌ ମିଙ୍ଗିଁ ମୁସ୍‌କୁପୁର୍‌ତି ବିସୟ୍‌ ୱେର୍‌ତିଙ୍ଗ୍‌ ଏଣ୍ତେସ୍‌ ବିସ୍‌ବାସ୍‌ କିନିଦେର୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ଏମେ ମନୁସ୍ୟପୁତ୍ର ମୁସ୍‌କୁପୁର୍‌ତାନ୍‌ ରେତାତାନ୍‍, ୱାନିଙ୍ଗ୍‌ ଡ଼ିସ୍‍ତିଙ୍ଗ୍‍ ମାରି ଏନ୍‍ବା ମୁସ୍‌କୁପୁର୍‌ତୁ ସଲ୍‍ଏର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","ମାରି, ମୋସା ଏଣ୍ତେସ୍‌ ସୁନ୍‌ସାନ୍‌ବାଡିଦୁ ସାରାସ୍‌ତିଙ୍ଗ୍‌ ମୁଣ୍ତାଦୁ ମୁସ୍‌କୁ ପେର୍‌ତାମାର୍ହାର୍‌, ମନୁସ୍ୟପୁତ୍ର ବା ଆୟାୱାଜା ମୁସ୍‌କୁ ପେରାନାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ଏଣ୍ତେସ୍‌ ଏନ୍‌ଆପିନ୍‌ ୱାନିମାନୁ ବିସ୍‌ବାସ୍‌ କିନାନ୍‌, ୱାନ୍‌ ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜ୍‍ଇ ଜିବନ୍‌ ପଇନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ଇରିଙ୍ଗ୍‌ ମାପୁରୁ ଇୟା ଜଗତ୍‌ତିଙ୍ଗ୍‌ ନିସା ଜିବନ୍‌ ନତାନ୍‌ ଜେ, ୱାନ୍‌ ନିଜେଦି ଅରେନ୍‌ ମାରିନ୍‌ତିଙ୍ଗ୍‌ ସିତାନ୍‌, ଏଣ୍ତେସ୍‌ ଏନ୍‌ଆପିନ୍‌ ୱାନିମାନୁ ବିସ୍‌ବାସ୍‌ କିନାନ୍‌, ୱାନ୍‌ ନାସ୍ଟୁ ଆଏଣ୍ତା ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜ୍‍ଇ ଜିବନ୍‌ ପଇନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ମାପୁରୁ ୱାନି ମାରିନ୍‍ତିଙ୍ଗ୍‍ ଦୁନିଆଦୁ ବିସାର୍‌ କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ପକ୍‍ଏନ୍‍, ମାତର୍‌ ଦୁନିଆ ଏଣ୍ତେସ୍‌ ୱାନି ମାଣାନ୍‌ ରକିୟା ଆନାତ୍‌, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ପୋକ୍‌ତାମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ଏନ୍‌ ମାରିନ୍‍ମାନୁ ବିସ୍‌ବାସ୍‌ କିନାନ୍‌, ୱାନ୍‌ ବିସାର୍‌ କିଆୟ୍‌ଆଏନ୍‌; ଏନ୍‌ ବିସ୍‌ବାସ୍‌ କିଏନ୍‌, ୱାନ୍‌ ବିସାର୍‌ ଆତା ୱିଜିତାନ୍‌ନି, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ମାପୁରୁଦି ଅରେନ୍‌ ମାରିନ୍‌ତି ଦର୍‌ତାନ୍‌ ବିସ୍‌ବାସ୍‌ କିଏନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ମାରି, ଆୟା ବିସାର୍‌ ଇୟା, ଜଗତ୍‌ତଦୁ ଜାୟ୍‌ ତରିତା ମାନାତ୍‌, ମାରି ଲୋକୁ ଜାୟ୍‌ତି ବାଦୁଲୁ ସିକାଟିଦିଙ୍ଗ୍‌ ବଦା କିତାର୍‌, ଇରିଙ୍ଗ୍‌ ୱାରି ପାଣିୱିଜୁ ତାଗିଇକା । ");
INSERT INTO kfcp_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ଇରିଙ୍ଗ୍‌ ଏନ୍‌ ତାଗିଇପାଣି କିନାନ୍‌, ୱାନ୍‌ ଜାୟ୍‌ତିଙ୍ଗ୍‌ କାଡ଼୍‌ନାନ୍‌, ମାରି ଆତିଙ୍ଗ୍‌ ୱାନି ପାଣିଦି ଦୋସ୍‌ ତରାନାତ୍‌, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାନ୍‌ ଜାୟ୍‌ ଲାକ୍‌ତୁ ରେଏନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ମାତର୍‌ ଏନ୍‌ ନେଗିପାଣି କିନାନ୍‍, ଏଣ୍ତେସ୍‌ ୱାନ୍‌ କିତିମାନି ପାଣିୱିଜୁ ମାପୁରୁଦି ବଦାଦାନ୍ କିତାନ୍‍ ଇଜି ତରାନାତ୍‍, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାନ୍‌ ଜାୟ୍‌ ଲାକ୍‌ତୁ ୱାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ତାନେୱେନ୍‌କା ଜିସୁ ମାରି ୱାନି ସିସୁର୍‍ ଜିହୁଦା ଦେସ୍‌ତୁ ସର୍ହାର୍‌, ମାରି ୱାନ୍‌ ଆୟାବାଡିଦୁ ୱାରି ୱାଲେ ମାନ୍‌ଜି ଡୁବନ୍‌ ସିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ଜୋହନ୍‍ ବା ସାଲମ ଲାକ୍‌ତୁରି ଏନୋନଦୁ ଡୁବନ୍‌ ସିଜିମାର୍ହାନ୍‌, ଇରିଙ୍ଗ୍‌ ଆୟା ବାଡିଦୁ ନାଣ୍ତ ଏରୁ ମାରେଏ, ମାରି ଲୋକୁ ୱାଜି ଡୁବନ୍‌ ଅସିମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ଜୋହନ୍‍ ଆୟା ସାନ୍ଦି ଜଇଲ୍‌ତୁ ତେବାଏତା ମାର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ଆୟାମାନୁ ନେଗେନ୍‌ଆନିପାଣିଦି ବିସୟ୍‌ତାନ୍‌ ଜୋହନ୍‌ତି ଏସ ସିସୁରି ତରିଟାନ୍‌ ଅରେନ୍‍ ଜିହୁଦି ୱାଲେ ଆସ୍‌ସିସାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ମାରି, ୱାର୍‌ ଜୋହନ୍‌ତି ଲାକ୍‌ତୁ ସଲ୍‌ସି ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, ଏ ଗୁରୁ, ଏନ୍‌ ଜର୍ଦନ ଗାଡାଦି ଆୟା ପାଡ଼୍‌କା ନି ୱାଲେ ମାର୍ହାନ୍‌, ଆମାୱାନି ବିସୟ୍‌ତାନ୍‌ ନିନ୍‌ ସାକ୍ୟ ସିତିମାନି, ସୁଡ଼ୁଆ, ୱାନ୍‌ ଡୁବନ୍‌ ସିଜିନାନ୍‌ ମାରି ୱିଜେରେ ୱାନି ଲାକ୍‌ତୁ ସଲ୍‌ସିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ଜୋହନ୍‍ ଇର୍ହାନ୍‌, ମାପୁରୁ ସିଏତିଙ୍ଗ୍‌ ଲୋକୁ ଇନିକା ପ‍ଇଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","ନାନ୍ ଜେ କ୍ରିସ୍ତ ଆଏ, ମାତର୍‌ ୱାନି ଆଗ୍‌ଡ଼ି ୱାତା ମାନା, ଇକା ନାନ୍ ଇର୍‌ଆମାର୍ହା ଇଜି ମିର୍‌ ନିଜେନିଜେ ନା ସାକି । ");
INSERT INTO kfcp_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ଏନ୍‌ ଆଇଲି ତାନାନ୍‌, ୱାନ୍‌ କାନ୍ୟାମୁରୁଲି, ମାତର୍‌ କାନ୍ୟାମୁରୁଲିଦି ଏମେ ସଙ୍ଗ୍‍ ଲାକ୍‌ତୁ ନିନାନ୍‌ନୋ ୱାନି ମାଟା ୱେନାନ୍‌, ୱାନ୍‌ କାନ୍ୟାମୁରୁଲିଦି ବଲୁ ଉଣ୍ତିଙ୍ଗ୍‌ ନାଣ୍ତ ୱେଡ଼ିକାଆନାନ୍‌ । ମାରି, ଇୟାୱାଜା ନା ଇୟା ୱେଡ଼ିକା ପୁରା ଆତାମାନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ୱାନିଙ୍ଗ୍‌ ଏଣ୍ତେସ୍‌ବା ପିର୍‌ଦେଙ୍ଗ୍‌ ପଡ଼ାନାତ୍‌, ମାତର୍‌ ନାଙ୍ଗିଁ ଉଣା ଆଦେଙ୍ଗ୍‌ ମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ଏନ୍‌ ମୁସ୍‌କୁରାନ୍‌ ୱାନାନ୍‌, ୱାନ୍‌ ୱିଜେରିମାଣ୍‌କୁ ପେରିକାନ୍‌, ଏନ୍‌ ଦୁନିଆଦାନ୍‍ ୱାନାନ୍‌, ୱାନ୍‌ ଦୁନିଆଦିକାନ୍‍, ମାରି ୱାନ୍‌ ଦୁନିଆଦି ମାଟା ଇନାନ୍‌; ଏନ୍‌ ମୁସ୍‌କୁପୁରୁତାନ୍‌ ୱାନାନ୍‌, ୱାନ୍‌ ୱିଜେରିମାଣ୍‌କୁ ପେରିକାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ୱାନ୍‌ ଆମାକା ସୁଡ଼ୁତାମାନାନ୍‌ ମାରି ୱେରାମାନାନ୍‌, ଆୟା ବିସୟ୍‌ତାନ୍‌ ୱାନ୍‌ ସାକିୟ ସିନାନ୍‌, ମାତର୍‌ ୱାନି ସାକିୟ ଏନ୍‌ ମାନାଏନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ଏନ୍‌ ୱାନି ସାକିୟ ମାନାତା ମାନାନ୍‌, ମାପୁରୁ ଜେ ସତ୍‌, ଇକା ୱାନ୍‌ ପାରାମାଣ୍‌ କିତାମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ଇରିଙ୍ଗ୍‌ ମାପୁରୁ ଆମାୱାନିଙ୍ଗ୍‌ ପୋକ୍‌ତାତା ମାନାନ୍‌, ୱାନ୍‌ ମାପୁରୁଦି ବାକ୍ୟ ଇନାନ୍‌, ଇରିଙ୍ଗ୍‌ ମାପୁରୁ ୱାନିଙ୍ଗ୍‌ ପୁରାଦାନ୍‌ ୱାନି ଆତ୍ମା ସିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ବୁବା ମାରିନ୍‌ତିଙ୍ଗ୍‌ ଜିବନ୍‌ନୋନାନ୍‌, ମାରି ୱିଜୁ ବିସୟ୍‌ ୱାନି କିୟୁଦୁ ସର୍ପେ କିତାମାନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ଏନ୍‌ ମାରିନ୍‌ତିଙ୍ଗ୍‌ ବିସ୍‌ବାସ୍‌ କିନାନ୍‌, ୱାନ୍‌ ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜ୍‍ଇ ଜିବନ୍‌ ପଇନାନ୍‌, ମାତର୍‌ ଏନ୍‌ ମାରିନ୍‌ତିଙ୍ଗ୍‌ ଅମାନ୍ୟ କିନାନ୍, ୱାନ୍‌ ଜିବନ୍‌ ସୁଡ଼ୁଏନ୍‌, ମାରି ଆୟା ଲୋକୁ ମୁସ୍‌କୁ ମାପୁରୁଦି ରିସା ତେବାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ଜିସୁ ଜେ ଜୋହନତି ବାଦ୍‌ଲୁ ନାଣ୍ତ ସିସୁର୍‍ କିଜିନାନ୍‌ ମାରି ୱାରିଙ୍ଗ୍‌ ଡୁବନ୍‌ ସିଜିନାନ୍‌ ଇଜି ପାରୁସିର୍‌ ୱେର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ଜଦିବା ଜିସୁ ନିଜେନେ ଡୁବନ୍‌ ସିଏଜିମାର୍ହାନ୍‌, ୱାନି ସିସୁର୍‍ ସିଜିମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ଇକା ପାରୁସିର୍‌ ୱେର୍‌ସିନାର୍‌ ଇଜି ଏସ୍ତିୱାଲେ ଜିସୁ ୱେର୍‌ଆନ୍‌, ନାସ୍ତିୱାଲେ ୱାନ୍‌ ଜିହୁଦା ଦେସ୍‌ ଡ଼ିସ୍‌ସିତାନ୍‌ନୋ ମାରିଡ଼େସି ଗାଲିଲିଦୁ ସର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ସମିରୋଣ ନାଡ଼୍‍ମି ସାରି ସିଜି ୱାନିଙ୍ଗ୍‌ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ପଡ଼ାତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ଆଦେଙ୍ଗ୍‌ ୱାନ୍‌ ସଲ୍‌ସି ଜାକୁବ ନିଜେଦି ମାରିନ୍‌ ଜୋସେପ୍‌ତିଙ୍ଗ୍‌ ଆମା ବୁମିକାଣ୍ତେକ୍‌ ଦାନ୍‌ ସିତାମାର୍ହାନ୍‌, ଆବେଣି ଲାକ୍‌ତୁରି ସମିରୋଣଦି ସୁକାର ଦର୍‌ତି ଉଣ୍ତ୍ରି ନାର୍‍ତୁ ଇତାନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ଆୟା ବାଡିଦୁ ଜାକୁବଦି କୁଇକାଲ୍‌ ମାର୍ହାତ୍‌ । ମାରି, ଜିସୁ ବୁଲାଜି ବୁଲାଜି ୱାଦିତାନୋ ଆୟା କୁଇକାଲ୍‌ ଲାକ୍‌ତୁ ବାସ୍‌ତାନ୍‌ । ନାସ୍ତିୱାଲେ ମାଦ୍‍ଲାମ୍‍ୱେଡ଼ା ଆତାମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ଅରେତ୍‌ ସମିରୋଣିୟା ଆଇମା ଏରୁ ଅତେଙ୍ଗ୍‌ ୱାତାତ୍‍, ଜିସୁ ତାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ନାଙ୍ଗିଁ ଏରୁ ଉଣ୍ତେଙ୍ଗ୍‌ ସିଦା । ");
INSERT INTO kfcp_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ନାସ୍ତିୱାଲେ ୱାନି ସିସୁର୍‍ ଉଣ୍ତେଙ୍ଗ୍‌ କାଦି କଣ୍ତେଙ୍ଗ୍‌ ଗାଡ଼୍‌ତୁ ସର୍‍ହାମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ଆବେଟ୍‌ ସମିରୋଣିୟା ଆଇମା ଜିସୁଙ୍ଗୁଁ ଇର୍ହାତ୍‌, ନିନ୍‌ ଅରେନ୍‍ ଜିହୁଦି ମାରି ନାନ୍ ସମିରୋଣିୟା ଏଣ୍ତେସ୍‌ ନା କିୟୁଦାନ୍‌ ଏର୍‌ ଉଣ୍ତେଙ୍ଗ୍‌ ଲସ୍‌ସିନି ? ଇରିଙ୍ଗ୍‌ ସମିରୋଣିୟରି ୱାଲେ ଜିହୁଦିର୍‌ ମିସାଜିସାଏର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ଜିସୁ ତାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ମାପୁରୁ ଇନିକା ସିଦେଙ୍ଗ୍‍ ଆଟ୍‍ନାନ୍‍, ନିନ୍‌ ଜଦି ନେସ୍‍ତିମାନ୍ଦି ମାରି ଏନ୍‌ ନି କିୟୁଦାନ୍‌ ଏର୍‌ ଉଣ୍ତେଙ୍ଗ୍‌ ବଦାକିଜିନାନ୍‌ ଆରିଙ୍ଗ୍‌ ଜଦି ନିନ୍‌ ୱାନିଙ୍ଗ୍‌ ଲସ୍‌ତିମାନ୍ଦି, ମାରି ୱାନ୍‌ ନିଙ୍ଗିଁ ଜିବନ୍‌ତି ଏରୁ ସିତାନ୍‌ମାନ୍ଦି । ");
INSERT INTO kfcp_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ଆୟା ଆଇମା ୱାନିଙ୍ଗ୍‌ ଇର୍ହାତ୍‌, ଆଜ୍ଞା, ଏରୁ ଆନ୍‌ନି ଉଣ୍ତିଙ୍ଗ୍‌ ନି ଲାକ୍‌ତୁ ଇନି ଗିନା ବା ସିଲେତ୍‍, ମାରି କୁଇକାଲ୍‌ ତୋ ନାଣ୍ତ ଆଡ୍‍ଗି; ଆଦେଙ୍ଗ୍‌ ନିନ୍‌ ଏମେମାଣ୍‌କୁ ଆୟା ଜିବନ୍‌ତି ଏରୁ ପଇତିମାନି ? ");
INSERT INTO kfcp_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ମା ଏମେ ପୁର୍ବେଦି ଡକ୍ରାଦାଦା ଜାକୁବ୍‌ ମାଙ୍ଗିଁ ଇୟା କୁଇକାଲ୍‌ ସିତାମାର୍ହାନ୍‌, ମାରି ନିଜେ, ମାରି ୱାନି କଡ଼ର୍‌ ମାରି ଜାତୁଙ୍ଗ୍‌ମାନ୍ଦା ଇବେଣ୍‌କୁ ଉଟେ ମାର୍‌ଏ, ୱାନିମାଣ୍‌କୁ ଇନିକା ନିନ୍‌ ପେରିକିନ୍ଦା ? ");
INSERT INTO kfcp_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ଜିସୁ ତାନେଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ଏନ୍‌ଆପିନ୍‌ ଇୟା ଏରୁ ଉଣାନ୍‌, ୱାନ୍‌ ମାରିଡ଼େସି ଏର୍‍କିଆନାନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ମାତର୍‌ ନାନ୍ ଏମେ ଏରୁ ସିନା, ଆକା ଏନ୍‌ଆପିନ୍‌ ଉଣାନ୍‌, ୱାନ୍‌ ଏସ୍‌କାଙ୍ଗ୍‌ବା ଏର୍‌କିସାଏନ୍‌, ମାରି ନାନ୍ ସିଜିମାନି ଏର୍‌ ୱାନି ଜିବନ୍‌ତୁ ଉଣ୍ତ୍ରି ଜିବନ୍‌ ସିନି ୱାଙ୍ଗ୍‍ଁନି ୱାଜା ଆନାତ୍‌ । ଆବେଟ୍‌କୁ ଉଟିଙ୍ଗ୍‍ ୱାନ୍‌ ଏସ୍‍କାଙ୍ଗ୍‍ୱିଜ୍‍ଇ ଜିବନ୍‌ ପୋଇନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ଆଇମା ୱାନିଙ୍ଗ୍‌ ଇର୍ହାତ୍‌, ଆଜ୍ଞା, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ନାଙ୍ଗିଁ ଆୟା ଏର୍‌ ସିଦା, ନାଙ୍ଗିଁ ଏଣ୍ତେସ୍‌ ଏର୍‌କି କାଟ୍‌ଏତ୍‌, ମାରି ଏରୁ ଆନ୍‌ନି ଉଣ୍ତିଙ୍ଗ୍‌ ନିସା ଆକ ସାରି ଇବେନୁ ୱାଦେଙ୍ଗ୍‌ ପଡ଼ାଏତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ଜିସୁ ତାନେଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ସାଙ୍ଗ୍ଆ, ନି କୋନ୍‌ଲିଙ୍ଗ୍‌ କୁକ୍‌ସ ଇବେନୁ ତାଗା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ଆଇମା ୱାନିଙ୍ଗ୍‌ ଇର୍ହାତ୍‌, ନା କୋନ୍‌ଲି ସିଲେନ୍‌ । ଜିସୁ ତାନେଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ନା କୋନ୍‌ଲି ସିଲେନ୍‌ ଇଜି, ସତ୍‌ ୱେର୍‌ତି; ");
INSERT INTO kfcp_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ଇରିଙ୍ଗ୍‌ ନି କୋନ୍‌ଲିର୍‌ ପାସ୍‌ଲୋକ୍‌ ମାର୍ହାର୍‌, ମାରି ଇଲେଇ ନିନ୍‌ ଆମାୱାନିୱାଲେ ମାନି, ମାରି ନି ଲାକ୍‌ତୁ ଏନ୍‌ ମାନାନ୍‌, ଇକା ସତ୍‌ ୱେର୍‌ତିମାନି । ");
INSERT INTO kfcp_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ଆଇମା ୱାନିଙ୍ଗ୍‌ ଇର୍ହାତ୍‌, ଆଜ୍ଞା, ନିନ୍‌ ଜେ ଅରେନ୍‍ ବାବବାଦି, ଇକା ନାନୁ ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ଆଟ୍‍ସିନା । ");
INSERT INTO kfcp_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ମା ପୁର୍ବେଦିଡକ୍‌ରାଦାଦାର୍‌ ଇୟା ଗରନ୍‌ତୁ ଉପାସନା କିତାର୍‌, ମାରି, ମିର୍‌ ଜିହୁଦିର୍‌ ଇଜିନିଦେର୍‌, ଏମେ ବାଡିଦୁ ଉପାସନା କିନି ନିୟମ୍‌, ଆକା ଜିରୁସାଲାମ୍‌ ମନ୍ଦିର । ");
INSERT INTO kfcp_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ଜିସୁ ତାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ଏ ଆଇମା, ନା ମାଟା ବିସ୍‌ବାସ୍‌ କିଆ, ଇୟାୱାଜା ସମୟ ୱାଜିନାତ୍‍, ଏମେ ସମୟତୁ ମିର୍‌ ଇୟା ଗରନ୍‌ତୁ ମାରି ଜିରୁସାଲାମ୍‌ତୁ ବୁବାଦି ଉପାସନା କିଇଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ମିର୍‌ ସମିରୋଣିୟର୍‍ ଆମାୱାନିଙ୍ଗ୍‌ ସତ୍‌ତାନ୍‌ ନେସ୍‌ଇଦେର୍‌, ଆକା ଉପାସନା କିଜିମାନିଦେର୍‍; ମାତର୍‌ ମାପ୍‌ ଜିହୁଦିର୍‌ ଆମାୱାନିଙ୍ଗ୍‌ ନେସ୍‌ନାପ୍‌, ୱାନି ଉପାସନା କିଜିମାନାପ୍‍, ଇରିଙ୍ଗ୍‌ ରକିୟା ଜିହୁଦିର୍‌ ମାଣ୍‌କୁ ୱାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ମାତର୍‌ ଏମେ ସମୟତୁ ସତ୍‌ ଉପାସନା କିନିକାର୍‍ ଆତ୍ମାଦୁ ନି ସତ୍‌ତାନ୍‌ ବୁବାଦି ଉପାସନା କିନାର୍‌, ଆୟାୱାଜା ସମୟ୍ ୱାଜିନାତ୍‍; ମାରି, ଇଲେଇବା ଇଗା ୱାତାତ୍‍; ଇରିଙ୍ଗ୍‌ ବୁବା ଇୟାୱାଜା ଉପାସନା କିନିୱାରିଙ୍ଗ୍‍ ବଦାକିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ମାପୁରୁ ଆତ୍ମା, ମାରି କେବଲ୍‌ ଆତ୍ମାଦି ସାକ୍ତି ନି ସତ୍‌ତାନ୍‌ ୱାନି ଉପାସନା କିନିକାର୍‍ ୱାନି ଉପାସନା କିଦେଙ୍ଗ୍ ଆଟ୍‍ନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ଆଇମା ଜିସୁଙ୍ଗୁଁ ଇର୍ହାତ୍‌, “ମସିହ, ଆମାୱାନିଙ୍ଗ୍‌ କ୍ରିସ୍ତ ଇନାର୍‌, ୱାନ୍‌ ୱାଜିନାନ୍‍ ଇଜି ନାନ୍ ନେସ୍‌ନା; ଏସ୍ତିୱାଲେ ୱାନ୍‌ ୱାନାନ୍‌, ୱାନ୍‌ ମାଙ୍ଗିଁ ୱିଜୁ ବିସୟ୍‌ ୱେର୍‌ନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ଜିସୁ ତାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନି ୱାଲେ ୱାର୍‍ଗିଜିନା ଜେ ନାନ୍, ନାନ୍ ଆୟାକାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ନାସ୍ତିୱାଲେ ଜିସୁଦି ସିସୁର୍‍ ୱାଜି ୱାନ୍‌ ଅରେତ୍‌ ଆଇମାଦି ୱାଲେ ୱାର୍‌ଗିସାନିକା ସୁଡ଼ୁଜି କାବା ଆତାର୍‌, “ଆତିବା ନିନ୍‌ ଇନିକା ବଦାକିନି, ମାରି ଏନ୍ଦା ତାନି ୱାଲେ ୱାର୍‍ଗିଜିନାନ୍‍, ଇକା ଏନ୍‌ ଜିସୁଙ୍ଗୁଁ ୱେନ୍‍ବାଦେଙ୍ଗ୍‍ ସାସ୍‌ କିଏତାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ଆବେଟ୍‌ ଆୟା ଆଇମା ନିଜେଦି ଏର୍‌ ସାଟି ଇଡ୍‌ଜି ଗାଡ଼୍‌ତୁ ସଲ୍‌ସି ଲୋକାଙ୍ଗ୍‌ ଇର୍ହାତ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“ରାଦୁ, ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ସୁଣିଦେର୍‍, ନାନ୍ ଆମା ଆମାକା କିତାମାନା, ଆୟାୱିଜୁ ୱାନ୍‌ ନାଙ୍ଗିଁ ଇର୍‌ଆନ୍‌, ୱାନ୍‌ ଏମୋ କ୍ରିସ୍ତ ଆନାନ୍‌ ସୁଜି ?” ");
INSERT INTO kfcp_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ଆବେଟ୍‌ ଲୋକୁ ଗାଡ଼୍‌ତାନ୍‍ ସହସି ୱାନି ଲାକ୍‌ତୁ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ଆୟାଦାପ୍ରେ ସିସୁର୍‍ ଜିସୁଙ୍ଗୁଁ ମାଡ଼ିସ୍‌ କିତାର୍‌, “ଏ ଗୁରୁ, କାଣ୍ତେକ୍‍ ଉଣୁଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ମାତର୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଉଣ୍ତେଙ୍ଗ୍‌ ଇଜି ଏମେ କାଦି ନାବାନ୍‍ ମାନାତ୍‌, ଆୟା ବିସୟ୍‌ତାନ୍‌ ମିର୍‌ ଇନିକା ନେସ୍‌ଇଦେର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ଆବେଟ୍‌ ସିସୁର୍‍ ତାମେଲୋଇ ୱାର୍‍ଗିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାର୍‌, “ଏନ୍‌ ୱାନିଙ୍ଗ୍‌ କାଦି ତାତା ସିତା ମାନାନ୍‌ ସୁଗି ?” ");
INSERT INTO kfcp_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନାଙ୍ଗିଁ ପକ୍‍ତିମାନିୱାନିଦି ବଦା ପୁରା କିଦେଙ୍ଗ୍‌ ମାରି ୱାନି ସିତିମାନି ପାଣିୱିଜୁ ୱିସ୍‍ତେଙ୍ଗ୍‍ ଇକାନେ ନା କାଦି । ");
INSERT INTO kfcp_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ମିର୍‌ ଇଜିମାନିଦେର୍‍, ପାସି କୟ୍‍ଦେଙ୍ଗ୍‍ ମାରି ନାଲ୍‍ଗି ଲେଜ୍‌କୁ ମାନେ, ମାତର୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ପାସି କିଡ଼ିଇ ଆଙ୍ଗ୍‍ଁ ନେଗେନ୍‌ କିଜି ସୁଡ଼ୁଦୁ; ଆୟାୱିଜୁ କୟ୍‍ଦେଙ୍ଗ୍‍ ଇଜି ପାଣ୍ତିତେନି । ");
INSERT INTO kfcp_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ଇଲେଇବା କୟ୍‍ନିକାନ୍‍ ମୁଲ୍‌ ପୟ୍‍ଜିନାନ୍‍ ମାରି ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜ୍‍ଇ ଜିବନ୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ପଲ୍‌ ଉଣ୍ତା କିଜିନା, ଏଣ୍ତେସ୍‌ ୱିତ୍‍ନିକାନ୍‍ ମାରି କୟ୍‍ନିକାନ୍‍ ରିଏର୍‌ ମିସାଜି ୱେଡ଼ିକା କିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ଇରିଙ୍ଗ୍‌ ଅରେନ୍‍ ୱିତ୍‍ନାନ୍‍ ମାରି ଆଇକାନ୍‍ କୟ୍‍ନାନ୍‍, ଇୟା ମାଟା ସତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ମିର୍‌ ଆମା ଉଣ୍ତିଙ୍ଗ୍‌ ପାଣି କିଇଦେର୍‍, ଆକା କୟ୍‍ଦେଙ୍ଗ୍‍ ଇଜି ନାନ୍ ମିଙ୍ଗିଁ ପକ୍‍ତା; ଆଇକାର୍‌ ପାଣିକିତାମାନାର୍‍, ମାରି ମିର୍‌ ୱାରି ପାଣିକିତି ପଲ୍‌ ପୟ୍‌ଜିନିଦେର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ନାନ୍ ଆମା ଆମାକା କିତାମାନା, ଆୟାୱିଜୁ ୱାନ୍‌ ନାଙ୍ଗିଁ ଇର୍‌ଆନ୍‌ ଇଜି ଏମେ ଆଇମା ସାକି ସିତାମାର୍‍ଆତ୍‍, ତାନି ମାଟା ଉଣ୍ତିଙ୍ଗ୍‌ ଆୟା ଗାଡ଼୍‌ତି ସମିରୋଣଦି ଲୋକା ଲୋଇ ନାଣ୍ତ ଲୋକୁ ଜିସୁମାନୁ ବିସ୍‌ବାସ୍‌ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ମାରି ସମିରୋଣୟଦି ଲୋକୁ ୱାନି ଲାକ୍‌ତୁ ୱାଜି ୱାରି ୱାଲେ ତେବାଦେଙ୍ଗ୍‍ ଇଜି ୱାନିଙ୍ଗ୍‌ ମାଡ଼ିସ୍‌ କିତାର୍‍, ମାରି ୱାନ୍‌ ରିନେନ୍‍ ଆୟା ବାଡିଦୁ ତେବାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ମାରି ଜିସୁଦି ବାକ୍ୟ ୱେନ୍‌ଞ୍ଜି ମାରି ନାଣ୍ତ ଲୋକୁ ବିସ୍‌ବାସ୍‌ କିତାର୍‍, ");
INSERT INTO kfcp_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ମାରି, ୱାର୍‌ ଆୟା ଆଇମାଦିଙ୍ଗ୍‍ ଇର୍ହାର୍‌, “ଇଲେଇ ନି ମାଟାଦି ଉଣ୍ତିଙ୍ଗ୍‌ ମାପ୍‌ ବିସ୍‌ବାସ୍‌ କିଏପ୍‍, ଇରିଙ୍ଗ୍‌ ମାପ୍‌ ନିଜେନିଜେ ୱେର୍‍ଆମାନାପ୍‍, ମାରି ଇକାନ୍‌ ଜେ ସତେନେ ଦୁନିଆଦି ରକିୟା କିନିକାନ୍‍, ଇକା ମାପ୍‌ ନେସ୍‌ତାମାନାପ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ରିନେନ୍‍ ୱେନ୍‌କା ଜିସୁ ଆବେଟ୍‌ତାନ୍‌ ସହସି ଗାଲିଲିଦୁ ସର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ଇରିଙ୍ଗ୍‌ ବାବବାଦି ନିଜେଦି ଦେସ୍‌ତୁ ସମ୍ମାନ୍‍ ପୟ୍‌ଏର୍‌ ଇଜି ଜିସୁ ନିଜେ ସାକି ସିତାମାର୍‍ଆନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ମାରି, ୱାନ୍‌ ଗାଲିଲିଦୁ ଇଗା ୱାତାନ୍‌, ନିସ୍ତାର ପଣ୍ତୟ୍‌ତିୱାଲେ ୱାନ୍‌ ଜିରୁସାଲାମ୍‍ତୁ ଇନି ଇନିକା କିତାମାର୍‍ଆନ୍‍, ଆୟାୱିଜୁ ସୁଡ଼ୁତାମାର୍‍ଆର୍‍ଆକା ଗାଲିଲିଦିକାର୍‍ ୱାନିଙ୍ଗ୍‌ ମାନାତାର୍‍, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ବା ପଣ୍ତୟ୍‌ତୁ ସର୍‍ଆମାର୍‍ଆନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ଆବେଟ୍‌ ଗାଲିଲିଦି ଆମା କାନା ଗାଡ଼୍‌ତୁ ୱାନ୍‌ ଏର୍‍ତିଙ୍ଗ୍‍ ଅଙ୍ଗୁର୍‍ରସ୍‍ କିତାମାର୍‍ଆନ୍‍, ଆୟା ବାଡିଦୁ ଜିସୁ ମାରିଡ଼େସି ସର୍ହାନ୍‌ । ମାରି ଆବେନ୍‌ ଅରେନ୍‍ ରାଜାଦି ପାଣିକିନିକାନ୍‌ ମାର୍ହାନ୍‌, ୱାନି ମାରିସି କପର୍‍ନାହୁମ୍‍ତୁ ନବ୍‌ ଆତାମାର୍‍ଆନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ଜିସୁ ଜିହୁଦା ଦେସ୍‍ତାନ୍‍ ଗାଲିଲିଦୁ ସତାୱାତାମାନାନ୍‍, ଇକା ୱେନ୍‌ଜି ୱାନ୍‌ ୱାନି ଲାକ୍‌ତୁ ସଲ୍‌ସି ୱାନ୍‌ ଏଣ୍ତେସ୍‌ ୱାଜି ୱାନି ମାରିସିଙ୍ଗ୍‌ ନେଗେଣ୍ତ୍‍ କିନାନ୍‌, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ ମାଡ଼ିସ୍‌ତେଙ୍ଗ୍‍ ଆସ୍‌ତାନ୍‌, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ସାନିୱାଜା ଆତାମାର୍‍ଆନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ଆବେଟ୍‌ ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ସିନା ନି କାବାଆନିପାଣିଙ୍ଗ୍‍ଁ ସୁଡ଼ୁଏତିଙ୍ଗ୍‍ ମିର୍‌ ଏଣ୍ତେସ୍‌ବା ବିସ୍‌ବାସ୍‌ କିଇଦେର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ରାଜାଦି ପାଣିକିନିକାନ୍‌ ଜିସୁଙ୍ଗୁଁ ଇର୍‌ଆନ୍‌, “ଏ ଗୁରୁ,” ନା କଡ଼ ସାନି ଆଗ୍‍ଡ଼ିନେ ରାଆ । ");
INSERT INTO kfcp_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ସାଙ୍ଗ୍‍ଆ, ନି କଡ଼ ଜିତାନ୍‍ନି । ଆୟା ଲୋକୁ ଜିସୁ ୱେର୍‍ତିମାନି ମାଟାଦିଙ୍ଗ୍‌ ବିସ୍‌ବାସ୍‌ କିଜି ସର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ମାରି, ୱାନ୍‌ ସଲ୍‍ପୁ ସଲ୍‍ପୁ ତାନି ଗତିମୁରୁଲିରି ୱାନିଙ୍ଗ୍‌ ବେଟ୍‍ବୁଡ଼ାଜି ୱାନି କଡ଼ ଜିତାନ୍‍ନି ଇଜି ଇର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ଆଦେଙ୍ଗ୍‌ ଏସ୍ତିୱାଲେ ୱାନି କଡ଼ଦିଙ୍ଗ୍‌ ନବ୍‌ ଡ଼ିସ୍‍ତାତ୍‍, ଆକା ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌ । ଆବେଟ୍‌ ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ଇଏନ୍‌ ଗନ୍‍ଣ୍ଟେ ୱେଡ଼ାଦୁ ୱାନିଙ୍ଗ୍‌ ନବ୍‌ ଡ଼ିସ୍‍ତାତ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ଆବେଟ୍‌ ୱାନି ବୁବାସି ବୁଜାତାନ୍‍ ଜେ, ଜିସୁ ଏସ୍ତିୱାଲେ ନି କଡ଼ ଜିତାନ୍‍ନି ଇଜି ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆମାର୍‌ଆନ୍‌, ଟିକ୍‌ ନାସ୍ତିୱାଲେ ଇୟା ଗଟାନା ଗଟାତାତ୍‍ । ମାରି, ୱାନ୍‌ ନିଜେ ନି ୱାନି ୱିଜୁ ଇଲୁଦିକାର୍‍ ଜିସୁଙ୍ଗୁଁ ବିସ୍‌ବାସ୍‌ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ଜିହୁଦାଦାନ୍‍ ମାରିଡ଼େସି ଗାଲିଲିଦୁ ୱାତି ୱେନ୍‌କା ଇକା ଜିସୁଦି ମାରିଅର୍ସୁ କାବାଆନି ପାଣି । ");
INSERT INTO kfcp_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ଇୟା ୱେନ୍‌କା ଜିହୁଦିର୍‌ ଉଣ୍ତ୍ରି ପଣ୍ତୟ୍‌ ୱାତାତ୍‍, ମାରି ଜିସୁ ଜିରୁସାଲମ୍‌ତୁ ସର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ଜିରୁସାଲାମ୍‌ତି ମେଣ୍ତାସେର୍‌ଲା ଲାକ୍‌ତୁ ଉଣ୍ତ୍ରି ସେରୁ ମାର୍ହାତ୍‌; ଏବ୍ରି ବାସାଦାନ୍‍ ତାନିଙ୍ଗ୍‌ ବେତେସ୍‍ଦା ଇଜି ଇନାର୍‌, ତାନି ପାସ୍‌ଗୋଟା ଗୁଡିକାଲ୍‌କୁ ମାନେ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ଆୟା ଗୁଡିକାଲ୍‍କାଙ୍ଗ୍‍ ମୁସ୍‌କୁ ନାଣ୍ତ ନବ୍‍ଆତିକାର୍‍, କାଣାର୍‌, ସଟାର୍‍ ମାରି କିକୁକାଲ୍‍କୁ ୱାର୍‍ତିକାର୍‍ ମାନ୍‌ଜିମାର୍ହାର୍‌ । ୱାର୍‌ ଏର୍‍ଦୁଙ୍ଗ୍‍ଁନିକା କାପ୍‌କିଜି ମାନ୍‌ଜିମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ଇରିଙ୍ଗ୍‌ ଏସୋ ଏସୋ ସମୟତୁ ପ୍ରବୁଦି ଅରେତ୍‌ ଦୁତ୍‍ ଇସ୍ରିଗାଡା ରେତାଜି ଏର୍‍ତିଙ୍ଗ୍‍ ଦୁକ୍‍ସିମାର୍ହାତ୍‌, ମାରି ଏର୍‌ ଦୁଙ୍ଗ୍‍ଁତି ୱେନ୍‌କା ଏନ୍‌ ଆଗ୍‌ଡ଼ି ଆବେ ଡ଼ୁଗୁଜି ମାର୍‌ଆନ୍‌, ୱାନ୍‌ ଏମେ ରୋଗ୍‍ତୁ ଆସ୍‍ତିମାରିଙ୍ଗ୍‌ ବା ନେଗେନ୍‌ ଆଜିମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ଆବେ ତିରିସ୍‍ଆଟ୍‍ ବାର୍‍ସେକ୍‍ ସାନ୍ଦି ରୋଗ୍‍ଆସ୍‍ତି ଅରେନ୍‍ ଲୋକୁ ମାର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଆବେମାନିକା ସୁଡ଼ୁଜି ନାଣ୍ତ ବାର୍‍ସେକ୍‍ତି ରୋଗି ଲୋକୁ ଇଜି ନେସ୍‌ସି ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ନିନ୍‌ ଇନିକା ନେଗେନ୍‌ ଆଦେଙ୍ଗ୍‌ ବଦା କିଜିନି ?” ");
INSERT INTO kfcp_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ରୋଗ୍‌ ଲୋକୁ ଜିସୁଙ୍ଗୁଁ ଇର୍‌ଆନ୍‌, “ଆଜ୍ଞା, ଏର୍‌ ଦୁଙ୍ଗିଁନିୱାଲେ ନାଙ୍ଗିଁ ସେରୁ ଲୋଇ ଅତେଙ୍ଗ୍‌ ଇଜିନା ଏନ୍‌ ସିଲେନ୍‌; ମାରି, ନାନ୍ ସଲ୍‍ପୁ ସଲ୍‍ପୁ ଆଇକାନ୍‍ ନା ଆଗ୍‌ଡ଼ି ଡ଼ୁଗ୍‍ଜିନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନିଙ୍ଗ୍‍ଆ, ନି ଟାଟି ଆସ୍‌ସି, ମି ଇଣ୍ତ୍ରସାଙ୍ଗ୍‍ଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ଆୟାଦାପ୍ରେ ଆୟା ଲୋକୁ ନେଗେଣ୍ତ୍‍ ଆତାନ୍‌ ମାରି ନିଜେଦି କାଟେଲ୍‍ ଆସ୍‌ସି ବୁଲାଦେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ଆୟାଦିନ୍‍ ରମ୍‍ନିଦିନ୍‍ ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ଜିହୁଦିର୍‌ ନେଗେଣ୍ତ୍‌ ଆତି ଲୋକ୍‌ତିଙ୍ଗ୍‌ ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, ନେର୍‌ ରମ୍‍ନିଦିନ୍‍, କାଟେଲ୍‍ ପିଣ୍ତ୍‍ଜି ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ନି ନିୟମ୍‌ ସିଲେତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ମାତର୍‌, ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ଏନ୍‌ ନାଙ୍ଗିଁ ନେଗେଣ୍ତ୍‍ କିତାନ୍‌, ୱାନ୍‌ ନାଙ୍ଗିଁ ଇର୍‌ଆନ୍‌, ନି କାଟେଲ୍‍ ଆସ୍‍ସୋ ବୁଲାଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‍ବାତାର୍‌, “ନି କାଟେଲ୍‍ ଆସ୍‍ସୋ ବୁଲାଆ ଇଜି ଏନ୍‌ ନିଙ୍ଗିଁ ଇର୍‌ଆନ୍‌, ଆୟା ଲୋକୁ ଏନ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ମାତର୍‌ ଜିସୁ ଏନ୍‌, ଆକା ଆୟା ନେଗେଣ୍ତ୍‍ ଆତିମାର୍‍ଇ ଲୋକୁ ନେସ୍‌ଏପ୍‌ ମାର୍‌ଆନ୍‌, ଇରିଙ୍ଗ୍‌ ଆୟା ବାଡିଦୁ ଲୋକୁ ଗଲି ମାର୍ହାର୍‌ଆକା ଜିସୁ ୱେର୍‌ଏ ଏର୍‌ଜି ସର୍‍ହାମାର୍‍ଆନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ତାନିୱେନ୍‍କା ଜିସୁ ମନ୍ଦିର୍‌ତୁ ୱାନିଙ୍ଗ୍‌ ତରାଜି ୱାନିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ସୁଡ଼ୁଆ, ନିନ୍‌ ନେଗେଣ୍ତ୍‍ ଆତିମାନି, ମାରି ପାପ୍‌ କିମା, ସିଲ୍‍ତିଙ୍ଗ୍‍ ନି ଉଣ୍ତିଙ୍ଗ୍‌ ମାରି ନାଣ୍ତ କାସ୍ଟୁ ୱାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ଆୟା ଲୋକୁ ସୋଲ୍‌ସି, ଏନ୍‌ ୱାନିଙ୍ଗ୍‌ ନେଗେଣ୍ତ୍‍ କିତାମାର୍‍ଆନ୍‍, ୱାନ୍‌ ଜିସୁ ଇଜି ଜିହୁଦିର୍‌ ପେରିୱାରିଙ୍ଗ୍‍ ଇର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ଆବେଟ୍‌ ଜିସୁ ରମ୍‍ନିଦିନ୍‍ତୁ ଇକା କିତାମାର୍ହାନ୍‌ଆକା ଜିହୁଦିର୍‌ ୱାନିଙ୍ଗ୍‌ ନିଦା କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ମାତର୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନା ବୁବା ୱିଜୁୱାଲେ ପାଣି କିଜିନାନ୍‍, ମାରି ନାନ୍ ବା କିଜିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ଜିହୁଦିର୍‌ ପେରିକାର୍‌ ୱାନିଙ୍ଗ୍‌ କାତ୍‍ତେଙ୍ଗ୍‍ ଇଜି ମାରି ନାଣ୍ତ ବଦା କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ଜେ ରମ୍‍ନିଦିନ୍‍ତି ନିୟମ୍‌ ମାନାଏଜିମାର୍ହାନ୍‍, କେବଲ୍‌ ଆକାନେ ସିଲେ, ମାତର୍‌ ମାପୁରୁଙ୍ଗୁଁ ନିଜେଦି ବୁବା ଇଜି ଇନ୍‌ଞ୍ଜି ୱାନ୍‌ ନିଜେଦିଙ୍ଗ୍‍ ମାପୁରୁୱାଲେ ସାମାନ୍‍ କିଜିମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ଆବେଟ୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, ସତ୍‌ ସତ୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ମାରିସି ନିଜେ ଇନିକା କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏନ୍‍, ୱାନି ବୁବା ଆମାକା କିନାନ୍‌, ମାରିସି ବା ଆକା ସୁଡ଼ୁଜି ଆୟାୱିଜୁ କିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ଇରିଙ୍ଗ୍‌ ବୁବା ମାରିସିଙ୍ଗ୍‌ ଲାଡ୍‌ କିନାନ୍‌, ମାରି ନିଜେ ଆମାକା କିନାନ୍‌, ଆୟାୱିଜୁ ୱାନିଙ୍ଗ୍‌ ତର୍‍ନାନ୍‍, ମାରି ୱେନିମାଣାନ୍‍ ମାରି ପେରି ପାଣିଙ୍ଗ୍‍ୱିଜୁ କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ତର୍‍ନାନ୍‍, ମାରି ମିର୍‌ ୱିଜେରେ କାବା ଆନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ମାରି ବୁବା ଏଣ୍ତେସ୍‌ ସାତିୱାରିଙ୍ଗ୍‍ ନିକ୍‍ସି ଜିବନ୍‌ ସିନାନ୍‍, ଆୟାୱାଜା ମାରିସି ବା ଆମାୱାନିଙ୍ଗ୍‌ ବଦାକିନାନ୍‌, ୱାନିଙ୍ଗ୍‌ ଜିବନ୍‌ସିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ମାରି, ବୁବା ନିଜେ ଏଙ୍ଗ୍‌ ବିସାର୍‌ କିଏନ୍‍, ମାତର୍‌ ନିଜେ ମାରିସିଙ୍ଗ୍‌ ୱିଜୁ ବିସାର୍‌ କିନି ଅଦିକାର୍‌ ସିତାମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ଏଣ୍ତେସ୍‌ ବୁବେଙ୍ଗ୍‌ ମାନାନାର୍‌, ମାରିସିଙ୍ଗ୍‌ ବା ଆୟାୱାଜା ୱିଜେରେ ମାନାନାର୍‌ । ମାତର୍‌ ଏନ୍‌ ମାରିସିଙ୍ଗ୍‌ ମାନାଏନ୍‌, ୱାନିଙ୍ଗ୍‌ ପୋକ୍‍ତିମାନି ବୁବେଙ୍ଗ୍‌ ବା ୱାନ୍‌ ମାନାଏନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","ସତ୍‌ ସତ୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ଏନ୍‌ ନା ବାକ୍ୟ ୱେନ୍‌ଜି ନା ପୋକ୍‍ତାତିୱାନିଙ୍ଗ୍‍ ବିସ୍‌ବାସ୍‌ କିନାନ୍, ୱାନ୍‌ ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜ୍‍ଇ ଜିବନ୍‌ ପୟ୍‌ତାମାନାନ୍‌, ମାରି ୱାନ୍‌ ବିସାର୍‌ ଆଏଣ୍ତା ମାତର୍‌ ୱାନ୍‌ ସାନିତାନେଙ୍ଗ୍‍ ଜିଣାଜି ଜିବନ୍‌ତୁ ଡ଼ୁଗିତାମାନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ସତ୍‌ ସତ୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ଇୟାୱାଜା ସମୟ ୱାଜିନାତ୍‍, ମାରି ଇଲେଇବା ଇଗା ୱାତାତ୍‍, ଏମେୱାଲେ ସାତିକାର୍‍ ମାପୁରୁଦି ମାରିସିଦି ବଲ୍ ୱେନାର୍‌, ମାରି ଏମେକାର୍‌ ୱେନାର୍‌, ୱାର୍‌ ଜିବନ୍‌ ଆନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ଇରିଙ୍ଗ୍‌ ବୁବା ଏଣ୍ତେସ୍‌ ଜିବନ୍‌ତି ମୁଲ୍‌, ମାରିସିଙ୍ଗ୍‌ ବା ଆୟାୱାଜା ୱାନ୍‌ ଜିବନ୍‌ତି ମୁଲ୍‌ କିତାମାନାନ୍‍; ");
INSERT INTO kfcp_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ମାରି, ୱାନ୍‌ ମନୁସ୍ୟପୁତ୍ର ଆକା ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ବିସାର୍‌ କିଦେଙ୍ଗ୍‌ ଅଦିକାର୍‌ ସିତାମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ଆବେ କାବା ଆମାଟ୍‌, ଇରିଙ୍ଗ୍‌ ଇୟାୱାଜା ସମୟ ୱାଜିନାତ୍‍, ଏସ୍ତିୱାଲେ ସାତିକାର୍‍ ୱିଜେରେ ୱାନି ବଲ୍ ୱେନାର୍‌ ");
INSERT INTO kfcp_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ମାରି ଦୁକିଦାନ୍‍ ମାରିଡ଼େସି ନିଙ୍ଗିଁଜି ୱାନାର୍‌, ଏମେକାର୍‌ ନେଗି ପାଣି କିତାମାନାର୍‍, ୱାର୍‌ ଜିବନ୍‌ ପୟ୍‌ଜି ନିଙ୍ଗିଁନାର୍‍ ମାରି ଜିନାର୍‍ ମାରି ଏମେକାର୍‌ ତାଗ୍‌ଇପାଣି କିତାମାନାର୍‍, ୱାର୍‌ ନିଙ୍ଗିଁଜି ଦଣ୍ତ୍‌ ପୟ୍‌ନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","ନାନ୍ ନା ନିଜେଦି ସାକ୍ତିଦାନ୍ ଇନିକା କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏ; କେବଲ୍‌ ମାପୁରୁଦି ଆଦେସ୍‍ତାନ୍‍ ବିସାର୍‌ କିନା, ମାରି ନା ବିସାର୍‌ ଟିକ୍‌, ଇରିଙ୍ଗ୍‌ ନାନ୍ ନିଜେଦି ବଦା ସାଲାକିଦେଙ୍ଗ୍‍ ବଦା କିଏନ୍‍ଣ୍ତା ନାଙ୍ଗିଁ ପୋକ୍‍ତାତିୱାନିନ୍ଦି ବଦା ସାଲାକିଦେଙ୍ଗ୍‍ ବଦାକିନା । ");
INSERT INTO kfcp_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","ଜଦି ନାନ୍ ନା ନିଜେଦି ବିସୟ୍‌ତାନ୍‌ ନିଜେ ସାକି ସିନା, ଆରିଙ୍ଗ୍‌ ନା ସାକି ସତ୍‌ତି ପାର୍‌ମାଣ୍‌ ଆଏତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ନା ତରିନ୍‌ ଏନ୍‌ ସାକି ସିନାନ୍‍, ୱାନ୍‌ ମାରି ଅରେନ୍‍; ମାରି ନା ବିସୟ୍‌ତାନ୍‌ ୱାନି ସାକି ଜେ ସତ୍‌, ଆକା ନାନ୍ ନେସ୍‌ନା । ");
INSERT INTO kfcp_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","ମିର୍‌ ଜୋହନତି ଲାକ୍‌ତୁ କାବୁର୍‌ ଅନିୱାରିଙ୍ଗ୍‍ ପୋକ୍‍ତିମାନିଦେର୍‍ ମାରି ୱାନ୍‌ ସତ୍‌ ତରିଟାନ୍‍ ସାକି ସିତାମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ମାତର୍‌ ନାନ୍ ଲୋକାମାଣ୍‌କୁ ସାକିୟ ଅଏ, ମାତର୍‌ ମିର୍‌ ଏଣ୍ତେସ୍‌ ରକିୟା ପୟ୍‌ନିଦେର୍‌, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ଇୟାୱିଜୁ ଇଜିନା । ");
INSERT INTO kfcp_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ଜୋହନ୍‍ କାସ୍‍ସି ମାରି ଜାୟ୍‍ଆନି ଦିୱାୱାଜା ମାର୍ହାନ୍‌, ମାରି ମିର୍‌ ସାଣେକ୍‌ତି ୱାନି ଜାୟ୍‍ତୁ ୱେଡ଼ିକା କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ବଦା କିତିଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ମାତର୍‌ ଜୋହନତି ସାକି ବାଦ୍‌ଲୁ ନା ନାଣ୍ତଅଦିକାର୍‍ତି ସାକି ମାନାତ୍‌, ଇରିଙ୍ଗ୍‌ ବୁବା ନାଙ୍ଗିଁ ଏମେ ଏମେ ପାଣି ୱିସ୍‍ତେଙ୍ଗ୍‍ ସିତାମାନାନ୍‌, ଆୟାୱିଜୁ ପାଣି ନାନ୍ କିଜିନା, ବୁବା ନାଙ୍ଗିଁ ପକ୍‍ତାମାନାନ୍‍ ଇଜି ଆୟାୱିଜୁ ନା ବିସୟ୍‌ତାନ୍‌ ସାକି ସିଜିନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ମାରି, ଏମେ ବୁବା ନାଙ୍ଗିଁ ପକ୍‌ତାନ୍‌, ୱାନ୍‌ ନା ବିସୟ୍‌ତାନ୍‌ ସାକି ସିତାମାନାନ୍‌ । ମିର୍‌ ଏସାଙ୍ଗ୍‍ ବା ୱାନି ବଲ୍ ୱେନ୍‍ଇଦେର୍‍ କି ୱାନି ମକମ୍‌ ସୁଡ଼ୁଇଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ମାରି ୱାନି ବାକ୍ୟ ଉଣ୍ତିଙ୍ଗ୍‌ ମି ଜିବନ୍‌ତୁ ବାଡି ସିଇଦେର୍‍, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ଆମାୱାନିଙ୍ଗ୍‌ ପକ୍‌ତାନ୍‌, ୱାନିଙ୍ଗ୍‌ ମିର୍‌ ବିସ୍‌ବାସ୍‌ କିଇଜିନିଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ମିର୍‌ ଦାର୍ମୁସାସ୍ତ୍ର ପୟ୍‌ଜିନିଦେର୍‌, ଇରିଙ୍ଗ୍‌ ଆବେଟ୍‌ ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜ୍‍ଇ ଜିବନ୍‌ ପୟ୍‍ନାପ୍‍ ଇଜି ଅଡ଼୍‍ବିଜିନିଦେର୍‍, ମାରି, ଆୟା ଦାର୍ମୁସାସ୍ତ୍ର ନା ବିସୟ୍‌ତାନ୍‌ ସାକି ସିଜିନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ମାତର୍‌ ମିର୍‌ ଜିବନ୍‌ ପୟ୍‌ଦେଙ୍ଗ୍‌ ଇଜିନା ଲାକ୍‌ତୁ ୱାଦେଙ୍ଗ୍‌ ବଦା କିଇଜିନିଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","ନାନ୍ ଲୋକାମାଣ୍‌କୁ ଗୌରବ୍‍ ପୟ୍‌ଦେଙ୍ଗ୍‌ ବଦାକିଏ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ମାତର୍‌ ନାନ୍ ମିଙ୍ଗିଁ ନେସ୍‌ନା, ମିର୍‌ ଏଣ୍ତେସ୍‌ ନାନି ଲୋକୁ ମି ଜିବନ୍‌ତୁ ମାପୁରୁଦି ଉଣ୍ତିଙ୍ଗ୍‌ ଜିବନ୍‍ନୋନିକା ସିଲେତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ନାନ୍ ନା ବୁବାଦି ଦର୍‌ତାନ୍‌ ୱାତାମାନା, ମାରି ମିର୍‌ ନାଙ୍ଗିଁ ଆସ୍‍ଇଜିନିଦେର୍‍; ଆଇକାନ୍‍ ଜଦି ନିଜେ ଦର୍‌ତାନ୍‌ ୱାନାନ୍‌, ଆରିଙ୍ଗ୍‌ ମିର୍‌ ୱାନିଙ୍ଗ୍‌ ମାନାନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ମିର୍‌ ଏଣ୍ତେସ୍‌ ନାଙ୍ଗିଁ ବିସ୍‌ବାସ୍‌ କିଦେଙ୍ଗ୍‌ ଆଟ୍‌ନିଦେର୍‌ ? ମିର୍‌ ତୋ ନିଜେନିଜେମାଣ୍‍କୁ ଗୌରବ୍‍ ପୟ୍‌ଜିନିଦେର୍‌, ମାରି ଅରେନ୍‌ ମାପୁରୁମାଣ୍‌କୁ ଏମେ ଗୌରବ୍‌, ଆକା ପୟ୍‌ଦେଙ୍ଗ୍‌ ବଦା କିଇଜିନିଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ନାନ୍ ଜେ ବୁବାଦି ଆଗ୍‌ଡ଼ି ମି ବିରଦ୍‌ତାନ୍‌ ଦୋସ୍‍ କିନା, ଇକା ଅଡ଼୍‍ବିମାଟ୍‍; ଏମେ ମୋସାମାନୁ ମିର୍‌ ଆସା ଇଟ୍‍ତିମାନିଦେର୍‍, ୱାନ୍‌ ମି ବିରଦ୍‌ତାନ୍‌ ଦୋସ୍‍ କିଜିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ଇରିଙ୍ଗ୍‌ ମିର୍‌ ଜଦି ସତ୍‌ତାନ୍‌ ମୋସାଦିଙ୍ଗ୍‍ ବିସ୍‌ବାସ୍‌ କିତିଙ୍ଗ୍‌ମାନ୍ଦି, ଆରିଙ୍ଗ୍‌ ନାଙ୍ଗିଁ ବିସ୍‌ବାସ୍‌ କିତିଦେର୍‍ମାନ୍ଦି, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ନା ବିସୟ୍‌ତାନ୍‌ ରାସ୍‌ତାମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ମାତର୍‌ ମିର୍‌ ଜଦି ମୋସା ରାସ୍‍ତିମାନି ବାକ୍ୟ ବିସ୍‌ବାସ୍‌ କିଇଜିନିଦେର୍‍, ଆରିଙ୍ଗ୍‌ ଏଣ୍ତେସ୍‌ ନା ବାକ୍ୟ ବିସ୍‌ବାସ୍‌ କିନିଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ତାନେୱେନ୍‌କା ଜିସୁ ଗାଲିଲି ବା ତିବିରିୟା ଗାଡା ଆୟାପାଡ଼୍‌କା ସର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ମାରି, ୱାନ୍‌ ରୋଗ୍‌ଆତିଲୋକା ଉଣ୍ତିଙ୍ଗ୍‌ ଏମେ ଏମେ କାବାଆନି ପାଣି କିଜିମାର୍ହାର୍‌, ଆୟାୱିଜୁ ସୁଡ଼ୁଜି ନାଣ୍ତ ଲୋକୁ ୱାନି ୱେନ୍‌କା ୱେନ୍‌କା ସନ୍‌ଡ୍ରେ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ଆବେଟ୍‌ ଜିସୁ ଗରନ୍‌ ମୁସ୍‌କୁ ସଲ୍‌ସି ନିଜେଦି ସିସୁରି ୱାଲେ ଆବେନୁ ବାସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ନାସ୍ତିୱାଲେ ଜିହୁଦିର୍‌ ନିସ୍ତାର୍‌ ପଣ୍ତୟ୍‌ ଲାକ୍‌ତୁୱାଜି ୱାଜିମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ମାରି, ଜିସୁ ନାଣ୍ତ ଲୋକାଙ୍ଗ୍‌ ନିଜେଦି ଲାକ୍‌ତୁ ୱାନିକା ସୁଡ଼ୁଜି ପିଲିପ୍‌ତିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଇୟାୱେରିଙ୍ଗ୍‌ ଉଣ୍ତେଙ୍ଗ୍‌ ଇଜି ମାଡ୍‌ ଏମେଣ୍‌କୁ ନାଣ୍ତ ରୁଟି କଣାଟ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ମାତର୍‌ ୱାନ୍‌ ପିଲିପ୍‌ତିଙ୍ଗ୍‍ ପରିକା କିନି ଇସାବ୍‌ତାନ୍‌ ଇକା ଇର୍ହାନ୍‌, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ଇନିକା କିଦେଙ୍ଗ୍‌ ସଲ୍‌ସିନାନ୍‌, ଆକା ୱାନ୍‌ ନିଜେ ନେସ୍‌ତାମାର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ପିଲିପ୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ୱିଜେରେ ଲୋକୁ କାଣ୍ତେକ୍‌ ପୟ୍‌ଦେଙ୍ଗ୍‌ ୱେରି ଉଣ୍ତିଙ୍ଗ୍‌ ଦୁଇସଦାନ୍‍ ନାଣ୍ତ ୱେଣ୍ତିଅଦୁଲି ଡାବୁଙ୍ଗୁଁ ଦାରାଦି ରୁଟି କଣ୍ତେଙ୍ଗ୍‌ ଆନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ସିମୋନ୍‌ ପିତର୍‌ତି ତଡ଼ାନ୍‌ ଆନ୍ଦ୍ରିୟ ଦର୍‌ତି ୱାନି ସିସୁରି ମାଣ୍‌କୁ ଅରେନ୍‍ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","ଇବେନୁ ଅରେନ୍‍ କଡ଼ ମାନାନ୍‌, ୱାନି ମାନୁ ଗଦ୍‍ମୁଦି ପାସ୍‌ଗୋଟା ରୁଟିଙ୍ଗ୍‌ ମାରି ରୁଣ୍ତି ମିନ୍‌କୁ ମାନେ, ମାତର୍‌ ନିସା ଲୋକା ଉଣ୍ତିଙ୍ଗ୍‌ ଆକା ନାଣ୍ତ ଆଏତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ଜିସୁ ସିସୁରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଲୋକାଙ୍ଗ୍‌ ବାସାକିଦୁ ।” ଆୟା ବାଡିଦୁ ନାଣ୍ତ ଲାଟା ମାର୍ହାତ୍‌ । ଆୟା ଲାଟା ମୁସ୍‌କୁ ୱିଜେରେ ବାସ୍‌ତାର୍‌, ଆବେନ୍‌ ଇସାବ୍‌ତାନ୍‌ ପୁରା ୫,୦୦୦ ହାଜାର୍‌ ମେମାରୁଙ୍ଗୁଁ ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ଆବେଟ୍‌ ଜିସୁ ଆୟା ରୁଟି ଆସ୍‌ତାନ୍‌ନୋ ମାପୁରୁଙ୍ଗୁଁ ଦନ୍ୟବାଦ୍‌ ସିଜି ବାସ୍‌ତିମାର୍‌ଇ ଲୋକାଙ୍ଗ୍‌ ଆକା ବାଟାକିତାସିତାନ୍‌, ଆୟାୱାଜା ମିନ୍‌କୁ ବା ବାଟାକିତାସିତାନ୍‌, ୱାର୍‌ ଏସ ଲସ୍‌ତିଙ୍ଗ୍‌, ନାସ ସିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ମାରି, ୱାର୍‌ ପଟାପାଜିତି ୱେନ୍‌କା, ଜିସୁ ନିଜେଦି ସିସୁରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଏଣ୍ତେସ୍‌ ଇନିକା ନାସ୍ଟୁ ଆଏତ୍‍, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ଏଜିତିମାନି ରୁକ୍‌ତି ମକେଙ୍ଗ୍‌ ଉନ୍‌ଡ୍ରେମାନୁ କିଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ଆବେଟ୍‌ ୱାର୍‌ ଆୟାୱିଜୁ ଉନ୍‌ଡ୍ରେମାନୁ କିତାର୍‌, ମାରି ଲୋକୁ ଉଟି ୱେନ୍‌କା ଗଦ୍‍ମୁଦି ଆୟା ପାସ୍‌ଗୋଟା ରୁଟିଣିକୁ ଏମେ ରୁକ୍‌ତି ମକେଙ୍ଗ୍‌ ରୁଟିଙ୍ଗ୍‌ ଏଜିତେମାର୍‌ଏ, ଆବେଟ୍‌ ୱାର୍‌ ବାରଗୋଟା ଡାଡ଼ିଆଙ୍ଗାଁ ବର୍‌ତି କିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ଆବେଟ୍‌ ଜିସୁ କିତିମାନି କାବାଦି ପାଣି ସୁଡ଼ୁଜି ଆବେମାନି ଲୋକୁ ଇର୍ହାର୍‌, ଦୁନିଆଦୁ ଏମେ ବାବବାଦି ୱାନିକା ମାର୍ହାତ୍‌, ଇକାନ୍‌ ପୁରା ୱାନ୍‌ନେ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ମାରି, ଲୋକୁ ୱାଜି ରାଜା କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ଜେ ୱାନିଙ୍ଗ୍‌ ଡାଟ୍‌ତାନ୍‌ ଆସ୍‌ତେଙ୍ଗ୍‌ ବଦା କିଜିନାର୍‌, ଜିସୁ ଇକା ନେସ୍‌ସି ୱାନ୍‌ ମାରିଡ଼େସି ଆୟା ବାଡି ଡ଼ିସ୍‌ସି ଅରେନ୍‌ନେ ଗରନ୍‌ତୁ ସତାସର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ଆୟାନାଣ୍ତିଙ୍ଗ୍‌ ମିଲ୍‌ମିଲିକା ଆତାତ୍‌ ଜିସୁଦି ସିସୁର୍‍ ଗାଡା ପାଡ଼ି ସର୍ହାର୍‌ ");
INSERT INTO kfcp_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ମାରି ଡଙ୍ଗାଁଦୁ ଏକ୍‌ତାର୍‌ରୋ ଗାଡାଦି ଆୟାପାଡ଼ି କପର୍‍ନାହୁମ୍‍ ତରିନ୍‌ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ । ସିକାଟି ଆଜି ୱାଜି ମାର୍ହାତ୍‌, ମାରି ଜିସୁ ଆୟାସାନ୍ଧି ୱାରି ଲାକ୍‌ତୁ ରେଏନ୍‌ ମାର୍ହାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ମାରି ନାଣ୍ତ ଗାଲି ଆଜିମାରିଙ୍ଗ୍‍ ଏର୍‌ତୁ ଉଲ୍‍କା ନିଙ୍ଗ୍‌ଜିମାର୍‌ଏ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ଆୟାଦାପ୍ରେ ସିସୁର୍‍ ପୁରା ପାସ୍‌ ନୋ ସଅ କିଲୋମିଟର୍‌ ସାଟ୍‍ୱା ଡାକ୍‌ସି ସର୍‌ଇ ୱେନ୍‌କା ଜିସୁଙ୍ଗୁଁ ଏର୍‌ ମୁସ୍‌କୁ ବୁଲାଜି ଡଙ୍ଗାଁ ଲାକ୍‌ତୁ ୱାନିକା ସୁଡ଼ୁଜି, ଆବେଟ୍‌ ୱାର୍‌ ତିଲାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ମାତର୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଇକାନ୍‌ତ ନାନୁ, ତିଲାମାଟ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ଆଦେଙ୍ଗ୍‌ ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ଡଙ୍ଗାଁଦୁ ଅତେଙ୍ଗ୍‌ ବଦା କିତାର୍‌, ମାରି ୱାର୍‌ ଏମେ ବାଡିଦୁ ସଲ୍‌ସିମାର୍ହାର୍‌, ଡଙ୍ଗାଁ ଆୟାଦାପ୍ରେ ଆୟା ବାଡିଦୁ ଇତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ଆୟା ବାଡିଦୁ କେବଲ୍‌ ଉନ୍‌ଡ୍ରି ଡଙ୍ଗାଁ ମାର୍‌ଆତ୍‌, ମାରି ଆବେଟ୍‌ ଜେ ଜିସୁ ନିଜେଦି ସିସୁରି ୱାଲେ ସଲ୍‌ଏନ୍‌ ମାର୍ହାନ୍‌, ମାତର୍‌ କେବଲ୍‌ ୱାନି ସିସୁର୍‍ ସର୍‌ଆମାର୍ହାର୍‌, ଇକା ଏମେ ଲୋକୁ ଆୟା ମାର୍‌ନାଣ୍ଡିଙ୍ଗ୍‌ ଗାଡାଦି ଆୟାପାଡ଼ି ନିର୍‌ଆ ମାର୍ହାର୍‌, ୱାର୍‌ ସୁଡ଼ୁତା ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ପ୍ରବୁ ଦନ୍ୟବାଦ୍‌ ସିତି ୱେନ୍‌କା ଲୋକୁ ଏମେ ବାଡିଦୁ ରୁଟି ତିର୍‌ଆମାର୍ହାର୍‌, ଆୟା ବାଡି ଲାକ୍‌ତୁ ତିବିରିୟାଦାନ୍‌ ମାରି ଏସ ଡଙ୍ଗେଙ୍ଗ୍‌ଁ ୱାଜି ଇତେ; ");
INSERT INTO kfcp_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ମାତର୍‌ ଜିସୁ ମାରି ୱାନି ସିସୁର୍‍ ଜେ ଆବେନୁ ସିଲେର୍‌, ଇକା ଏସ୍ତିୱାଲେ ଲୋକୁ ୱିଜେରେ ସୁଡ଼ୁତାର୍‌, ନାସ୍ତିୱାଲେ ୱାର୍‌ ୱିଜେରେ ଡଙ୍ଗେଆଙ୍ଗାଁ ଏକ୍‌ସି ଜିସୁଙ୍ଗୁଁ ପୟ୍‌ଜି ପୟ୍‌ଜି କପର୍‍ନାହୁମ୍‍ତୁ ୱାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ମାରି, ଲୋକୁ ଗାଡା ଆୟାପାଡ଼ି ଜିସୁଙ୍ଗୁଁ ସୁଡ଼ୁଜି ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, “ଏ ଗୁରୁ, ନିନ୍‌ ଏସ୍ତିୱାଲେ ଇବେନୁ ୱାତି ?” ");
INSERT INTO kfcp_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ସତ୍‌ ସତ୍‍ନେ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, କାବାଆନି ପାଣି ସୁଡ଼ୁତିଙ୍ଗ୍‌ନୋ ଜେ ମିର୍‌ ନାଙ୍ଗିଁ ପୟ୍‌ଜିନିଦେର୍‌, ଆକା ସିଲେ, ମାତର୍‌ ରୁଟି ତିନ୍‌ଜ ପାଜିତିଦେର୍‌ନୋ ନାଙ୍ଗିଁ ପୟ୍‌ଜିନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ଆମା କାଦି ସେଏଣ୍ତ୍‍ ଆନାତ୍‌ ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ପାଣି କିମାଟ୍‌ ମାରି ଆମାକା ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜ୍‍ଇ ଜିବନ୍‌ ସିନାତ୍‌, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ପାଣି କିଦୁ; ଆୟା କାଦି ମନୁସ୍ୟପୁତ୍ର ମିଙ୍ଗିଁ ସିନାନ୍‌, ଇରିଙ୍ଗ୍‌ ବୁବା ମାପୁରୁ ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ ଅଦିକାର୍‍ ସିତାମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ଆବେଟ୍‌ ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ମାପୁରୁ ଆମାକା ବଦାକିଜିନାନ୍‌ ଆକା ମାପ୍‌ କିଦେଙ୍ଗ୍‌ ମାଙ୍ଗିଁ ଇନିକା କିଦେଙ୍ଗ୍‌ ଆନାତ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମାପୁରୁ ଆମାୱାନିଙ୍ଗ୍‌ ପୋକ୍‌ତାମାନ୍‌ନାନ୍‌, ୱାନିମାନୁ ବିସ୍‌ବାସ୍‌ କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ମିର୍‌ ଆକା କିଦେଙ୍ଗ୍‌ ଆଟ୍‌ନିଦେର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ଆବେଟ୍‌ ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, “ଆରିଙ୍ଗ୍‌ ନିନ୍‌ ସିନାଦିୱାଜା ଇନିକା କିଜିନି ଜେ, ଆକା ସୁଡ଼ୁଜି ମାପ୍‌ ନିଙ୍ଗିଁ ବିସ୍‌ବାସ୍‌ କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାପ୍‍ ? ନିନ୍‌ ଇନିକା ପୁଜା କିଜିନି ? ");
INSERT INTO kfcp_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ମା ପୁର୍ବେଦିଡକ୍‌ରାଦାଦାର୍‌ ସୁନ୍‌ସାନ୍‌ବାଡିଦୁ ମାନ୍ନା ଉଣୁଜି ମାର୍ହାର୍‌, ଏଣ୍ତେସ୍‌ ଦର୍ମସାସ୍ତ୍ରଦୁ ରାସ୍‌ତାମାନ୍‌ତା, ଉଣ୍ତେଙ୍ଗ୍‌ ଇଜି ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ମୁସ୍‌କୁପୁର୍‌ତାନ୍‌ କାଦି ସିତାମାର୍ହାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ଆବେଟ୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ସତ୍‌ ସତ୍‍ନେ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା,” ଆମାକା ମିଙ୍ଗିଁ ମୋସା ସିତାମାର୍‍ହାନ୍‍ ଆକା ମୁସ୍‌କୁପୁର୍‌ତାନ୍‌ ୱାତିମାନି କାଦି ସିଲେ, ମାତର୍‌ ନା ବୁବା ମିଙ୍ଗିଁ ମୁସ୍‌କୁପୁର୍‌ତାନ୍‌ ସତ୍‌ତେନେ କାଦି ସିନାନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ଆମା କାଦି ମୁସ୍‌କୁପୁର୍‌ତାନ୍‌ ରେତାଜିୱାଜି ଦୁନିଆଦିଙ୍ଗ୍‍ ଜିବନ୍‌ ସିନାନ୍‍, ୱାନ୍‌ ଆଜିନାନ୍‍ ଆୟା ମାପୁରୁ ସିତିମାନି କାଦି । ");
INSERT INTO kfcp_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, ଆଜ୍ଞା, “ୱିଜୁଦିନ୍‌ ମାଙ୍ଗିଁ ଇୟା କାଦି ସିଦା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ଆବେଟ୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନାନ୍ ଆୟା ଜିବନ୍‌ ସିନି କାଦି, ଏନ୍‌ ନା ଲାକ୍‌ତୁ ୱାନ୍‌ନାନ୍‌, ୱାନ୍‌ ମୁଡ଼ୁକେ ବାଙ୍ଗାଁ ସାଏନ୍‌, ମାରି ଏନ୍‌ ନା ମାନୁ ବିସ୍‌ବାସ୍‌ କିନାନ୍‌, ୱାନ୍‌ ମୁଡ଼ୁକେ ଏର୍‌କିସାଏନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ମାତର୍‌ ମିର୍‌ ନାଙ୍ଗିଁ ସୁଡ଼ୁତିଙ୍ଗ୍‌ ବା ବିସ୍‌ବାସ୍‌ କିଇଜିନିଦେର୍‌, ଇକା ନାନ୍ ମିଙ୍ଗିଁ ୱେର୍‌ତାମାନା । ");
INSERT INTO kfcp_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ବୁବା ଜେ ୱିଜେରିଙ୍ଗ୍‌ ନାଙ୍ଗିଁ ଦାନ୍‌ କିନାନ୍‌, ୱାର୍‌ ନା ଲାକ୍‌ତୁ ୱାନାର୍‌; ମାରି, ଏନ୍‌ ନା ଲାକ୍‌ତୁ ୱାନାନ୍‌, ୱାନିଙ୍ଗ୍‌ ନାନ୍ ଇନି ୱାଜାବା ସୋପ୍‌ତେଙ୍ଗ୍‍ ଆଟ୍‍ଏ; ");
INSERT INTO kfcp_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ଇରିଙ୍ଗ୍‌ ନା ନିଜେଦି ବଦାଦାନ୍‌ଦିଙ୍ଗ୍‍ ପୁରା କିଦେଙ୍ଗ୍‌ ସିଲେ, ମାତର୍‌ ନା ପୋକ୍‍ତିୱାନି ବଦା ପୁରା କିଦେଙ୍ଗ୍‌ ନାନ୍ ମୁସ୍‌କୁପୁର୍‌ତାନ୍‌ ୱାତାମାନା । ");
INSERT INTO kfcp_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ମାରି, ନା ପୋକ୍‍ତିକାନ୍‍ ଜେ ୱିଜେରିଙ୍ଗ୍‌ ନାଙ୍ଗିଁ ସିତାମାନାନ୍‌, ନାନ୍ ୱାରି ମାଣୁକୁ ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ବା ଆରାକିଏ, ନାନ୍ ୱିଜିନି ନାଣ୍ତିଙ୍ଗ୍‌ ଆୟା ୱିଜେରିଙ୍ଗ୍‌ ମାରିଡ଼େସି ଜିବନ୍‌ କିନା, ଇକା ୱାନି ବଦା । ");
INSERT INTO kfcp_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ଇରିଙ୍ଗ୍‌ ଏନ୍‌ ମାରିସିଙ୍ଗ୍‌ ସୁଡ଼୍‌ଜି ୱାନିମାନୁ ବିସ୍‌ବାସ୍‌ କିନାନ୍‌, ୱାନ୍‌ ଏଣ୍ତେସ୍‌ ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜ୍‍ଇ ଜିବନ୍‌ ପୟ୍‌ନାନ୍‌, ଇକାନେ ନା ବୁବାଦି ବଦା; ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ୱିଜିନି ନାଣ୍ତିଙ୍ଗ୍‌ ଆୟା ୱିଜେରିଙ୍ଗ୍‌ ମାରିଡ଼େସି ଜିବନ୍‌ କିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ନାନ୍ ମୁସ୍‌କୁପୁର୍‌ତାନ୍‌ ରେତାତିମାନି କାଦି, ୱାନ୍‌ ଇକା ଇର୍ହାନ୍‌ଆକା ଜିହୁଦିର୍‌ ଜିସୁଦି ବିରଦ୍‌ତାନ୍‌ ନିଦା କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ମାରି ୱାର୍‌ ଇର୍ହାର୍‌ “ଇକାନ୍‌ ଇନିକା ଜୋସେପତି ମାରିନ୍‌ ଜିସୁ ଆଏନ୍‍ ? ମାରି ମାପ୍‌ ୱେନି ବୁବାୟାୟାଙ୍ଗ୍‌ ନେସ୍‌ନାପ୍‌ ଆରିଙ୍ଗ୍‌ ନାନ୍ ମୁସ୍‌କୁପୁର୍‌ତାନ୍‌ ରେତାତାମାନା ଇଜି ୱାନ୍‌ ଇଲେ ଏଣ୍ତେସ୍‌ ଇଜିନାନ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନିଜେ ନିଜେଦି ମାନୁ ନିଦା କିମାଟ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ନାଙ୍ଗିଁ ପୋକ୍‌ତାତିମାନି ବୁବା ଏମେୱାନିଙ୍ଗ୍‌ ଆସ୍‌ କିନାନ୍‌, କେବଲ୍‌ ୱାନ୍‌ ନା ଲାକ୍‌ତୁ ୱାଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାନ୍‍, ମାରି ନାନ୍ ୱିଜିନି ନାଣ୍ତିଙ୍ଗ୍‌ ଆୟା ୱିଜେରିଙ୍ଗ୍‌ ମାରିଡ଼େସି ଜିବନ୍‍କିଜି କିନା । ");
INSERT INTO kfcp_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ବାବବାଦିର୍ ଦାର୍ମୁସାସ୍ତ୍ରଦୁ ରାସ୍‌ତା ମାନାର୍‌, ୱିଜେରେ କେବଲ୍‌ ମାପୁରୁଦି ମାଣାନ୍‌ ସିକିୟା ପୟ୍‌ନାର୍‌ । ଏନ୍‌ଆପିନ୍‌ ବୁବାଦିମାଣ୍‌ନା ୱେନ୍‌ଜି ସିକିୟା ପୟ୍‌ନାନ୍‌, ୱାନ୍‌ ନା ଲାକ୍‌ତୁ ୱାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ତେନି ଅର୍ତ ଆଏତ୍‍ ଜେ, ୱାନ୍‌ ବୁବେଙ୍ଗ୍‌ ସୁଡ଼ୁତା ମାନ୍‌ନାନ୍‌, ଏନ୍‌ ମାପୁରୁଦିମାଣ୍‌ନା ୱାତାମାନ୍‌ନାନ୍‌, କେବଲ୍‌ ୱାନ୍‌ନେ ବୁବେଙ୍ଗ୍‌ ସୁଡ଼ୁତାମାନ୍‌ନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ସତେ ସତେନେ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ଏନ୍‌ ବିସ୍‌ବାସ୍‌ କିନାନ୍‌, ୱାନ୍‌ ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜ୍‍ଇ ଜିବନ୍‌ ପୟ୍‌ତାମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ନାନ୍ ଜିବନ୍‌ ସିନି କାଦି । ");
INSERT INTO kfcp_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ମି ପୁର୍ବେଦିଡକ୍‌ରାଦାଦାର୍‌ ସୁନ୍‌ସାନ୍‌ବାଡିଦୁ ମାନ୍ନା ଉଟାର୍‌ ଆରିଙ୍ଗ୍‍ବା ସାତାସର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ମାତର୍‌ ଏମେ କାଦି ମୁସ୍‌କୁପୁରୁତାନ୍‌ ୱାନାତ୍‌, ତାନିଙ୍ଗ୍‍ ଏନ୍‌ ଉଣାନ୍‌ ୱାନ୍‌ ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜ୍‌ଇ ଜିବନ୍‌ ପୋୟ୍‍ନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ନାନ୍ ମୁସ୍‌କୁପୁରୁତାନ୍‌ ୱାତିମାନି ଆୟା ଜିବନ୍‌ତି କାଦି, ଏନ୍‌ ଜଦି ଇୟା କାଦି ଉଣୁନାନ୍‌, ୱାନ୍‌ ଏସାଙ୍ଗ୍‌ୱିଜ୍‌ଇଦିନ୍‌ ସାନ୍ଧି ଜିବନ୍‌ ମାନାନ୍‌; ହୁଁ, ନାନ୍ ଏମେ କାଦି ସିନା, ଆକା ନା କାଣ୍ତା, ନାନ୍ ଆକା ଦୁନିଆଦିଙ୍ଗ୍‍ ଜିପିସ୍‍ନି ଉଣ୍ତିଙ୍ଗ୍‌ ସିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ଆବେଟ୍‌ ଜିହୁଦିର୍‌ ନିଜେନିଜେଦିମାନୁ ଗିଦ୍‌ରିଆଜି ଜାଟି କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, “ଇକାନ୍‌ ଏଣ୍ତେସ୍‌ ମାଙ୍ଗିଁ ନିଜେଦି କାଣ୍ତା ତିନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ସିଦେଙ୍ଗ୍‍ ଆଟ୍‍ନାନ୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ଆବେଟ୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ସତ୍‌ ସତ୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ମନୁସ୍ୟପୁତ୍ରଦି କାଣ୍ତା ତିନ୍‌ଏତିଙ୍ଗ୍‌ ମାରି ୱାନି ନେତେର୍‌ ଉଣୁଏତିଙ୍ଗ୍‌, ମିର୍‌ ଜିବନ୍‌ ପୋୟ୍‍ଦେଙ୍ଗ୍‍ ଆଟ୍‍ଇଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ଏନ୍‌ ନା କାଣ୍ତା ତିନ୍‌ନାନ୍‌ ମାରି ନା ନେତେର୍‌ ଉଣୁନାନ୍‌, ୱାନ୍‌ ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜ୍‍ଇ ଜିବନ୍‌ ପୟ୍‌ନାନ୍‌, ମାରି ନାନ୍ ୱିଜିନି ନାଣ୍ତିଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ ନିକ୍‌ନା । ");
INSERT INTO kfcp_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ଇରିଙ୍ଗ୍‌ ନା କାଣ୍ତା ସତେନେ କାଦି ମାରି ନା ନେତେର୍‌ ସତେନେ ଏରୁ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ଏନ୍‌ ନା କାଣ୍ତା ତିନ୍‌ନାନ୍‌ ମାରି ନା ନେତେର୍‌ ଉଣୁନାନ୍‌, ୱାନ୍‌ ନା ମାନୁ ତେବାନାନ୍‌ ମାରି ନାନ୍ ୱାନିମାନୁ ତେବାନା । ");
INSERT INTO kfcp_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ଜିବନ୍‌ମାନି ବୁବା ନାଙ୍ଗିଁ ପୋକ୍‌ତାମାନାନ୍‌ ମାରି ନାନ୍ ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ଜିବନ୍‌ ମାନା, ଆୟାୱାଜା ଏନ୍‌ ନାଙ୍ଗିଁ ଉଣୁନାନ୍‌, ୱାନ୍‌ ବା ନା ଉଣ୍ତିଙ୍ଗ୍‌ ଜିବନ୍‌ ତେବାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ଏମେ କାଦି ମୁସ୍‌କୁପୁରୁତାନ୍‌ ୱାତାମାନାତ୍‌, ଆୟାକା ଇକା; ପୁର୍ବେଦିଡକ୍‌ରାଦାଦାର୍‌ ଏଣ୍ତେସ୍‌ ଉଟାର୍‌ ସାତାସର୍ହାର୍‌, ଇକା ଆୟାୱାଜା ସିଲେ; ଏନ୍‌ ଇୟା କାଦି ଉଣୁନାନ୍‌, ୱାନ୍‌ ଏସାଙ୍ଗ୍‌ୱିଜ୍‌ଇଦିନ୍‌ ସାନ୍ଧି ଜିବନ୍‌ ତେବାନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ଜିସୁ କପର୍‍ନାହୁମ୍‍ତି ଉନ୍‌ଡ୍ରି ପାର୍‌ତନା ଇଲୁତୁ ସିକିୟା ସିନିୱାଲେ ଇୟାୱିଜୁ ମାଟା ୱେର୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ମାରି, ଜିସୁଦି ସିସୁରି ମାଣ୍‌କୁ ଏସଲୋକ୍‌ ଇକା ୱେନ୍‌ଜି ଇର୍ହାର୍‌, “ଇୟା ସିକିୟା ବୁଜାଦେଙ୍ଗ୍‌ ବଡ଼େ କାସ୍ଟୁ, ଏନ୍‌ ଇକା ୱେନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆଟ୍‍ନାନ୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ଇୟା ବିସୟ୍‌ତାନ୍‌ ଜିସୁଙ୍ଗୁଁ ଏନ୍‌ ଇନିକା ଇନ୍‍ଏତି ମାରିଙ୍ଗ୍‌ ବା ସିସୁର୍‍ ୱାରି ଲୋଇ ନିଦା କିଜିନାର୍‍ ଇଜି ନେସ୍‌ସି ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଇକା ଇନିକା ମିଙ୍ଗିଁ ବାଦା ଆଜିନାତ୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ମନୁସ୍ୟପୁତ୍ର ଆଗ୍‌ଡ଼ି ଏମେ ବାଡିଦୁ ମାର୍ହାନ୍‌, ଆୟା ବାଡିଦୁ ଏସ୍‌କାଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ ସନିକା ସୁଣିଦେର୍‌, ଆରିଙ୍ଗ୍‌ ମିର୍‌ ଇନିକା କିନିଦେର୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","କେବଲ୍‌ ମାପୁରୁଦି ଆତ୍ମା ଜିବନ୍‌ ସିନାତ୍‌; ଲୋକା ସାକ୍ତି ଇନି ପାଣିକିଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏତ୍‍; ମାପୁରୁଦି ଆୟା ଜିବନ୍‌ ସିନି ଆତ୍ମାଦିଙ୍ଗ୍‌ ମିର୍‌ ଏଣ୍ତେସ୍‌ ନେସ୍‌ନିଦେର୍‌, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ଇୟାୱିଜୁ ମାଟା ଇର୍‌ଆ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ଆତିଙ୍ଗ୍‌ବା ମି ମାଣ୍‌କୁ ଏନ୍‌ ଏନ୍‌ ବିସ୍‌ବାସ୍‌ କିଏଜିନାର୍‌ । ଇରିଙ୍ଗ୍‌ ଜିସୁଙ୍ଗୁଁ ଏର୍‌ ବିସ୍‌ବାସ୍‌ କିଏର୍‌ ମାରି ଏନ୍‌ ୱାନିଙ୍ଗ୍‌ ସାତ୍ରୁରି କିୟୁଦୁ ସର୍ପେ କିନ୍‌ନାନ୍‌, ଆକା ଜିସୁ ଆଗ୍‍ଡ଼ିରାନ୍‍ନେ ନେସ୍‌ତା ମାର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ମାରି ୱାନ୍‌ ଇର୍ହାନ୍‌, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଇର୍‌ଆମାନା, ବୁବାସିମାଣାନ୍‍ ପକ୍‍ଏତିଙ୍ଗ୍‌ ଏନ୍‌ ନା ଲାକ୍‌ତୁ ୱାଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ଆୟାୱାଲେରାନ୍‍ ଜିସୁଦି ସିସୁରି ମାଣ୍‌କୁ ଏସଲୋକ୍‌ ୱେର୍‌ଏ ଏର୍‌ଜି ସତାସର୍ହାର୍‌, ମାରି ୱାନି ୱାଲେ ମାରି ବୁଲାସାଲା କିଏତାର୍‌ନି । ");
INSERT INTO kfcp_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ଆବେଟ୍‌ ଜିସୁ ବାରଲୋକ୍ ସିସୁରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ମିର୍‌ ବା ଇନିକା ନାଙ୍ଗିଁ ଡ଼ିସ୍‌ସି ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ବଦା କିଜିନିଦେର୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ସିମୋନ ପିତର୍‌ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାନ୍‌, “ପ୍ରବୁ, ଏ ଲାକ୍‌ତୁ ସନାଟ୍‌ ? ନି ଲାକ୍‌ତୁ ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜିଇ ଜିବନ୍‌ତି ବାକ୍ୟ ମାନାତ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ମାରି, ନିନ୍‌ ଜେ ମାପୁରୁଦି ମାଣାନ୍‌ ୱାତିମାନି ଆୟା ପବିତ୍ର ଲୋକୁ, ଇକା ମାପ୍‌ ବିସ୍‌ବାସ୍‌ କିତାମାନାପ୍‌ ମାରି ନେସ୍‌ତାମାନାପ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନାନ୍ ଇନିକା ମି ବାରଲୋକାଙ୍ଗ୍‌ ଆସ୍‌କିଏ ନୋ ? ମାରି, ମି ମାଣ୍‌କୁ ଅରେନ୍‍ ସୟତାନ୍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ଜିସୁ ଇସ୍କାରିୟୋତିୟ ସିମୋନତି ମାରିନ୍‌ ଜିହୁଦାଦିଙ୍ଗ୍‌ ସୁଡ଼ୁଜି ଇକା ଇର୍ହାନ୍‌, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ବାରଲୋକ ସିସୁରି ମାଣ୍‌କୁ ଅରେନ୍‍, ମାରି ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ସାତ୍ରୁରି କିୟୁଦୁ ସର୍ପେ କିଦେଙ୍ଗ୍‌ ସଲ୍‌ସି ମାର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ତାନେୱେନ୍‌କା ଜିସୁ ଗାଲିଲିଦୁ ବୁଲାଦେଙ୍ଗ୍‌ ଆସ୍‌ତାନେ, ଇରିଙ୍ଗ୍‌ ଜିହୁଦିର୍‌ ୱାନିଙ୍ଗ୍‌ ସାୟାମାର୍‌ଗା ଡାକ୍‌ତେଙ୍ଗ୍‍ଁ ଇଜି ସେସ୍ଟା କିଜିମାରିଙ୍ଗ୍‌ ୱାନ୍‌ ଜିହୁଦା ଦେସ୍‌ତୁ ବୁଲାଦେଙ୍ଗ୍‌ ବଦା କିଏଜି ମାର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ଜିହୁଦିର୍‌ ଇଲୁଦୁବାସାନି ପଣ୍ତ୍‌ୟତି ଦିନ୍‌ ଇଗା ୱାତାତ୍‍, ");
INSERT INTO kfcp_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ୱାନି ତଡ଼ାନ୍‌କୁ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାର୍‌, ନିନ୍‌ ଆମା ଆମା ପାଣି କିଜିନି, ଆୟାୱିଜୁ ଏଣ୍ତେସ୍‌ ନି ସିସୁର୍‍ ବା ସୁଡ଼ୁନାଟ୍‌ ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ଇବେଣାନ୍‌ ସସିସୋଲ୍‌ସ ଜିହୁଦା ଦେସ୍‌ତୁ ସାନ୍‍ଡ୍ରୁ, ");
INSERT INTO kfcp_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ଇରିଙ୍ଗ୍‌ ଏନ୍‌ ତରାଦେଙ୍ଗ୍‍ ବଦାକିତିଙ୍ଗ୍‍ ମାର୍‍ଗିଜି ଇନିକା କିଏନ୍‌ । ମିର୍‌ ଜଦି ଇୟାୱିଜୁ କିଜିନିଦେର୍‌, ଆରିଙ୍ଗ୍‌ ନିଜେଦିଙ୍ଗ୍‍ ଦୁନିଆ ଆଗ୍‌ଡ଼ି ତର୍‌ଆ । ");
INSERT INTO kfcp_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ଇରିଙ୍ଗ୍‌ ୱାନି ତଡ଼ାନ୍‌କୁ ବା ୱାନିମାନୁ ବିସ୍‌ବାସ୍‌ କିଏଜିମାର୍‍ଆର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ଆବେଟ୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନା ସମୟ ଇୟାସାନ୍ଦି ଇଗା ରେଏଦେ, ମାତର୍‌ ମି ଉଣ୍ତିଙ୍ଗ୍‌ ସମୟ ୱିଜୁଦିନ୍‌ ମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ଦୁନିଆ ମିଙ୍ଗିଁ କାଡ଼୍‍ଏତ୍‍, ମାତର୍‌ ନାଙ୍ଗିଁ କାଡ଼୍‍ନାତ୍‍, ଇରିଙ୍ଗ୍‌ ୱାନି ପାଣି ଜେ ତାଗ୍‌ଇକା ଇଜି ନାନ୍ ଆୟା ବିସୟ୍‌ତାନ୍‌ ଇୟା ସାକି ସିଜିନା । ");
INSERT INTO kfcp_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ମିର୍‌ ଇୟା ପଣ୍ତ୍‍ୟତୁ ସାନ୍‍ଡ୍ରୁ, ନାନ୍ ଇଲେଇ ଇୟା ପଣ୍ତ୍‍ୟତୁ ସଲ୍‍ଏଜିନା, ଇରିଙ୍ଗ୍‌ ନା ସମୟ ଇୟାସାନ୍ଦି ରେଏଦେ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇୟାୱିଜୁ ମାଟା ଇଜି ଗାଲିଲିଦୁ ତେବାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ମାତର୍‌ ୱାନି ତଡ଼ାନ୍‌କୁ ପଣ୍ତ୍‍ୟତୁ ସର୍‍ରି ୱେନ୍‌କା ଜିସୁ ବା ସର୍ହାନ୍‍, ତରାଇଆଜି ସିଲେ, ମାତର୍‌ ମାର୍‍ଗିଜି ସର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ଆଦେଙ୍ଗ୍‌ ଜିହୁଦି ନେତାର୍‌ ପଣ୍ତ୍‍ୟତୁ ୱାନିଙ୍ଗ୍‌ ପୟ୍‍ବୁ ପୟ୍‍ବୁ ୱେନ୍‌ବାତାର୍‌, “ୱାନ୍‌ ଏମେ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ମାରି, ଜିସୁ ବିସୟ୍‌ତାନ୍‌ ଲୋକା ମାନୁ ପୁସୁରୁ ପାସୁରୁ ୱାର୍‍ଗିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାର୍‌; ଏନ୍‌ ଏନ୍‌ ଇର୍ହାର୍‌, “ୱାନ୍‌ ଅରେନ୍‍ ନେଗି ଲୋକୁ,” ମାରି ଏନ୍‌ ଏନ୍‌ ଇର୍ହାର୍‌, “ସିଲେ, ୱାନ୍‌ ଲୋକାଙ୍ଗ୍‌ ବାୟା କିଜିନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ମାତର୍‌ ଜିହୁଦି ନେତାର୍‌ ତିଲାଜି ୱାନି ବିସୟ୍‌ତାନ୍‌ ୱେକ୍‍ସି ଏନ୍‌ ଇନିକା ଇନ୍‍ଏଜି ମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ମାତର୍‌ ପଣ୍ତ୍‌ୟତି ଆଦା ସମୟ ୱିଜିତି ୱେନ୍‌କା, ଜିସୁ ମନ୍ଦିର୍‌ତୁ ସଲ୍‌ସି ସିକିୟା ସିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ଆବେଟ୍‌ ଜିହୁଦି ନେତାର୍‌ କାବାଆଜି ଇର୍ହାର୍‌, “ଇକାନ୍‌ ପାଟ୍‍ ପଡ଼ାଏଣ୍ତା ଏଣ୍ତେସ୍‌ ନେସ୍‌ତାନ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ଆବେଟ୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନା ସିକିୟା ନା ନିଜେଦିକା ଆଏତ୍‍, ମାତର୍‌ ନା ପକ୍‍ତିମାନି ମାପୁରୁଦି ମାଣାନ୍‌ ୱାତାମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ଏନ୍‌ ଜଦି ମାପୁରୁ ବଦା ମାନାଦେଙ୍ଗ୍‌ ଇଚ୍ଛା ଆନାନ୍‌, ଆରିଙ୍ଗ୍‌ ନା ସିକିୟା ମାପୁରୁ ମାଣ୍‌କୁ ୱାତାମାନାତ୍‍ନୋ, ନା ନିଜେଦି ସାକ୍ତିଦାନ୍ ନୋ ଇଜିନା, ଆକା ୱାନ୍‌ ନେସ୍‌ନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ଏନ୍‌ ନିଜେଦି ମାଣାନ୍‌ ଇନାନ୍‌, ୱାନ୍‌ ନିଜେଦି ଗୌରବ୍‍ ପଇନାନ୍‌, ମାତର୍‌ ଏନ୍‌ ନିଜେଦି ପକ୍‍ତିୱାନିଦି ଗୌରବ୍‍ କିଦେଙ୍ଗ୍‌ ବଦା କିନାନ୍‌, ୱାନ୍‌ ସତ୍‌ ଇନାନ୍‌, ମାରି ୱାନିମାନୁ ଇନି ମିସ୍‌ ସିଲେତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ମୋସା ଇନିକା ମିଙ୍ଗିଁ ନିୟମ୍‌ ସିଏନ୍‍ନୋ ? ଆତିଙ୍ଗ୍‌ବା ମି ମାଣ୍‌କୁ ଏନ୍‌ ନିୟମ୍‌ ମାନାଏଜିନାନ୍‍ । ମିର୍‌ ଏନ୍ଦା ନାଙ୍ଗିଁ ଡାକ୍‌ତେଙ୍ଗ୍‍ଁ ବଦା କିଜିନିଦେର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ଲୋକ୍‌ ୱିଜେରେ ଇର୍ହାର୍‌, “ନିଙ୍ଗିଁ ଦୁବା ଆସ୍‍ତାମାନାତ୍‍, ଏନ୍‌ ନିଙ୍ଗିଁ ଡାକ୍‌ତେଙ୍ଗ୍‍ଁ ବଦାକିଜିନାନ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍‌ଆନ୍‌, “ନାନ୍ ଉଣ୍ତ୍ରି କାବା ପାଣି କିତା, ମାରି ମିର୍‌ ୱିଜେରେ କାବା ଆତିମାନିଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ମୋସା ମିଙ୍ଗିଁ ସୁନ୍ନତ ନିୟମ୍‌ ସିତାମାନାନ୍‌, ଇକା ଜେ ମୋସା ମାଣାନ୍‌ ଆତାମାନାତ୍‌, ଆକା ସିଲେ ମାତର୍‌ ପୁର୍ବେଦିଦାଦାରି ମାଣ୍‌କୁ, ମାରି ମିର୍‌ ରମ୍‌ନି ନାଣ୍ଡିଙ୍ଗ୍ କଡ଼ରିଙ୍ଗ୍‌ ସିନାତ୍‌ କିଜିନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ମୋସାଦି ନିୟମ୍‌ ଅମାନ୍ୟ କିଇ ଉଣ୍ତିଙ୍ଗ୍‌ ଜଦି ରମ୍‌ନିନାଣ୍ତିଙ୍ଗ୍‌ କଡ଼ଦି ସୁନ୍ନତ କିନିଦେର୍‍, ଆରିଙ୍ଗ୍‌ ନାନ୍ ରମ୍‌ନିନାଣ୍ତିଙ୍ଗ୍‌ ଅରେନ୍‍ ଲୋକ୍‌ତିଙ୍ଗ୍‌ ୱିଜୁ ନେଗେଣ୍ତ୍‍ କିତାଆକା ମିର୍‌ ଏନ୍ଦା ନା ମୁସ୍‌କୁ ରିସା ଆଜିନିଦେର୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ସୁପ୍‍ ଆଦୁ, ଆତ୍‍ରେରି ବିସୟ୍‌ ସୁଡ଼୍‌ଜି ବିସାର୍‌ କିଏଣ୍ତା ନ୍ୟାୟ୍‌ ବିସାର୍‌ କିଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ଆବେଟ୍‌କୁ ଜିରୁସାଲାମ୍‍ତୁ ବାସା କିନି ଲୋକା ଲୋଇ ଏନ୍‌ ଏନ୍‌ ଇଡ୍ରେଙ୍ଗ୍‍ ଆସ୍‌ତାର୍‌, “ଜିହୁଦି ନେତାର୍‌ ଆମାୱାନିଙ୍ଗ୍‌ ଡାକ୍‌ତେଙ୍ଗ୍‍ଁ ବଦା କିଜିନାର୍‍, ଇକାନ୍‌ ଇନିକା ୱାନ୍‌ ଆଏନ୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ମାରି ସୁଡ଼ୁଦୁ, ୱାନ୍‌ ତରାଜି ମାଟା ଇଜିନାନ୍‌, ମାରି ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଇନିକା କିଏଜିନାର୍‍ । ଇକାନ୍‌ ଜେ ମସିହ ଇଜି ଇକା ଇନିକା ନେତାର୍‌ ସତେ ନେସ୍‍ତାୱିସ୍‍ତାର୍‍ନି ? ");
INSERT INTO kfcp_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ଆମାକା ଆପିତ୍‌, ୱେନି ୱାନିକା ମାପ୍‌ ନେସ୍‌ନାପ୍‌, ମାତର୍‌ ମସିହ ଏସ୍ତିୱାଲେ ୱାନାନ୍‌, ନାସ୍ତିୱାଲେ ୱାନି ୱାନିକା ଏନ୍‌ ନେସ୍‌ଏପ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ଆବେଟ୍‌ ଜିସୁ ମନ୍ଦିର୍‌ତୁ ସିକିୟା ସିବୁ ସିବୁ ନାଣ୍ତ ଆଉଲି ଆଜି ଇର୍ହାନ୍‌, ନାନ୍ ଏନ୍‌ ମାରି ଏମେଟ୍‍କୁ ୱାତାମାନା, ମିର୍‌ ଇନିକା ସତ୍‌ତାନ୍‌ ନେସ୍‌ନିଦେର୍‌ ? ନାନ୍ ନିଜେଦିମାଣାନ୍‍ ରେଏ, ମାତର୍‌ ନା ପକ୍‍ନିକାନ୍‍ ସତ୍‌, ୱାନିଙ୍ଗ୍‌ ମିର୍‌ ନେସ୍‌ଇଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ନାନ୍ ୱାନିଙ୍ଗ୍‌ ନେସ୍‌ନା, ଇରିଙ୍ଗ୍‌ ନାନ୍ ୱାନିମାଣ୍‌କୁ ୱାତାମାନା, ମାରି ୱାନ୍‌ ନାଙ୍ଗିଁ ପକ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ଆବେଟ୍‌ ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ଆସ୍‌ତେଙ୍ଗ୍‌ ବଦା କିତାର୍‍; ମାତର୍‌ ଏନ୍‌ ୱାନି ମୁସ୍‌କୁ କିୟୁ ମୁଟ୍‍ଏତାନ୍‍, ଇରିଙ୍ଗ୍‌ ୱାନି ସମୟ ଆୟା ସାନ୍ଦି ଇଗା ରେଏତ୍‍ମାର୍ହାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ମାତର୍‌ ଲୋକା ଲୋଇରାନ୍‌ ନାଣ୍ତ ଲୋକୁ ୱାନିମାନୁ ବିସ୍‌ବାସ୍‌ କିଜି ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, “ଇୟାୱିଜୁ କାବାଆନି ପାଣି କିଜିନାନ୍‍, ମସିହ ୱାଜି ୱେନିମାଣାନ୍‍ ଇନିକା ନାଣ୍ତ କିନ୍‌ନାନ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ପାରୁସିର୍‌ ଲୋକାଙ୍ଗ୍‌ ଜିସୁଦି ବିସୟ୍‌ତାନ୍‌ ପୁସୁରୁ ପାସୁରୁ ୱାର୍‌ଗିନିକା ୱେର୍‌ଆର୍‌ ମାରି ପେରି ଜାଜକର୍‌ ନି ପାରୁସିର୍‌ ୱାନିଙ୍ଗ୍‌ ଆସ୍‌ତେଙ୍ଗ୍‌ ଇଜି କାପ୍‍କିନିୱାରିଙ୍ଗ୍‍ ପୋକ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ଆବେଟ୍‌ ଜିସୁ ଇର୍ହାନ୍‌, “ନାନ୍ ମାରି ଅଡ଼ପ୍‍ ସମୟ ମି ୱାଲେ ତେବାଜି ନା ପକ୍‍ତିୱାନିମାନୁ ଡ଼େସି ସଲ୍‍ସିନା । ");
INSERT INTO kfcp_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ମିର୍‌ ନାଙ୍ଗିଁ ପଇନିଦେର୍‌, ମାତର୍‌ ପୟ୍‌ଇଦେର୍‌; ମାରି, ନାନ୍ ଏମେମାନୁ ମାନା, ମିର୍‌ ଆବେ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଆଟ୍‍ଇଦେର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ଆବେନୁ ଜିହୁଦି ନେତାର୍‌ ନିଜେ ନିଜେଦିମାନୁ ଇର୍ହାର୍‌, “ଇକାନ୍‌ ଏମେମାନୁ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଇଜି ସତାମାନ୍‌ନାନ୍‌ ଜେ, ମାଡ୍‌ ୱାନିଙ୍ଗ୍‌ ପୋୟଇକା ? ଇକାନ୍‌ ଇନିକା ଗ୍ରିକ୍‌ରି ଗାଡ଼୍‌କାଙ୍ଗ୍‌ ଲୋଇ ଇନିଙ୍ଗାଁ ଆନିଙ୍ଗାଁ ଜିହୁଦିର୍‌ ଲାକ୍‌ତୁ ସୋଲ୍‌ସି ଗ୍ରିକ୍‌ରିଙ୍ଗ୍‌ ସିକିୟା ସିଦେଙ୍ଗ୍‍ ସତାମାନ୍‌ନାନ୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ମିର୍‌ ନାଙ୍ଗିଁ ପଇନିଦେର୍‌, ମାତର୍‌ ପୟଇଦେର୍‌, ମାରି ନାନ୍ ଏମେମାନୁ ମାନା, ମିର୍‌ ଆବେନୁ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଆଟ୍‍ଇଦେର୍‍, ୱାନ୍‌ ଇୟା ଏମେ ମାଟା ଇର୍ହାନ୍‌, ତାନି ଅର୍ତ ଇନିକା ?” ");
INSERT INTO kfcp_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ପଣ୍ତୟ୍‌ତି ୱିଜିନି ନାଣ୍ତିଙ୍ଗ୍‌, ମାରି, ପଣ୍ତ୍‌ୟତି ନେଗି ନାଣ୍ତିଙ୍ଗ୍‌, ଜିସୁ ନିଙ୍ଗିଁତାନ୍‌ନୋ ନାଣ୍ତ ଆଉଲି ଆଜି ଇର୍ହାନ୍‌, “ଏନ୍‌ ଜଦି ଏର୍‌କି ସାନାନ୍‌, ଆଦେଙ୍ଗ୍‌ ୱାନ୍‌ ନା ଲାକ୍‌ତୁ ରାପିନ୍‍, ");
INSERT INTO kfcp_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ମାରି ଏନ୍‌ ନା ମାନୁ ବିସ୍‌ବାସ୍‌ କିନ୍‌ନାନ୍‌, ୱାନ୍‌ ଉଣିନ୍‍, ଦାର୍ମୁସାସ୍ତ୍ରଦୁ ରାସ୍‌ତାମାନାତ୍‌ ଏନ୍‌ ନାବାନୁ ବିସ୍‌ବାସ୍‌ କିନାନ୍‌ ୱାନି ଜିବନ୍‌ତାନ୍‌ ଜିବନ୍‌ସିନି ଏରୁ ପୋଗ୍‌ଜିସନେ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ଜିସୁ ପବିତ୍ର ଆତ୍ମାଦି ବିସୟ୍‌ତାନ୍‌ ୱେର୍‌ତାନ୍‌, ଏମେକାର୍‌ ଜିସୁମାନୁ ବିସ୍‌ବାସ୍‌ କିଜିମାର୍ହାର୍‌ ୱାର୍‌ ୱେନ୍‌କା ଇୟା ପବିତ୍ର ଆତ୍ମାଦିଙ୍ଗ୍‌ ପୟନାର୍‌ ଆୟାସାନ୍ଧି ଜିସୁ ଦନ୍ୟବାଦ୍‌ ପୟଏନ୍‌ ମାରିଙ୍ଗ୍‌ ୱାର୍‌ ପବିତ୍ରଆତ୍ମା ପୟ୍‌ଏନ୍‌ ମାର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ମାରି, ଲୋକା ଲୋଇରାନ୍‌ ଏନ୍‌ ଏନ୍‌ ଇୟା ମାଟା ୱେନ୍‌ଜି ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, “ଇକାନ୍‌ ସତେନେ ଆୟା ବାବବାଦି ।” ");
INSERT INTO kfcp_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ମାରି ଆଇକାର୍‌ ଇର୍ହାର୍‌, “ଇକାନ୍‌ନେ ମସିହ,” ମାତର୍‌ ଏନ୍‌ ଏନ୍‌ ଇର୍ହାର୍‌, “ଇନିକା ! ମସିହ ଗାଲିଲିଦାନ୍‌ ରେଏନ୍‌ ! ");
INSERT INTO kfcp_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ମସିହ ଜେ ଦାଉଦଦି କୁଟୁମ୍‌ତାନ୍‌ ମାରି ଦାଉଦ ଏମେମାନୁ ମାର୍ହାନ୍‌, ଆୟା ବେତଲିହିମ୍‍ ନାର୍‌ତାନ୍‌ ଜନମ୍‌ ଆନାନ୍‌, ଇକା ଇନିକା ଦାର୍ମୁସାସ୍ତ୍ରଦୁ ବାକ୍ୟ ଇନ୍‌ଏତ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ଆରିଙ୍ଗ୍‌ ଲୋକୁୱିଜେରି ଲୋଇ ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ୱେର୍‌ଏ ୱେର୍‌ଏ ଆତାର୍‌ ");
INSERT INTO kfcp_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ମାରି, ୱାରି ଲୋଇରାନ୍‌ ଏସ ୱାନ୍‌ ଜିସୁ ଦରା ପଡ଼ାପିନ୍‍ ଇଜି ବଦା କିଜିମାର୍ହାର୍‌, ମାତର୍‌ ଏନ୍‌ ୱାନି ମୁସ୍‌କୁ କିୟୁ ମୁଟ୍‌ଏତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ଆୟାଦାପ୍ରେ ମନ୍ଦିର୍‌ତି କାପ୍‍କିନିକାର୍‌ ପେରି ଜାଜକ ମାରି ପାରୁସିର୍‌ ଲାକ୍‌ତୁ ଡ଼େସି ୱାତାର୍‌, ମାରି ୱାର୍‌ ୱାରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, “ମିର୍‌ ଏନ୍ଧା ୱାନିଙ୍ଗ୍‌ ଆସୋସ ତେଇତିଦେର୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","କାପ୍‍କିନିକାର୍‌ ଇର୍ହାର୍‌, “ଇୟା ଲୋକୁ ଏଣ୍ତେସ୍‌ମାରି ମାଟେଙ୍ଗ୍‌ ଇନାନ୍‌, ଆମା ଲୋକୁ ଏସ୍‌କାଙ୍ଗ୍‌ ଆୟାନାନି ମାଟେଙ୍ଗ୍‌ ଇନ୍‌ଏର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ଆବେଟ୍‌ ପାରୁସିର୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ମିଙ୍ଗିଁ ବା ଇନିକା ୱାନ୍‌ ବାୟା କିତାନ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“ନେତାରି ଲୋଇରାନ୍‌ ମାରି ପାରୁସିର୍‌ ଲୋଇରାନ୍‌ ଇନିକା ଏନ୍‌ ୱାନିମାନୁ ବିସ୍‌ବାସ୍‌ କିତାମାନାର୍‌ ଇକା ମିର୍‌ ନେସ୍‌ତିମାନିଦେର୍‌ ନୋ ? ");
INSERT INTO kfcp_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ମାତର୍‌ ଇୟା ଲୋକୁ ମୋସାଦି ନିୟମ୍‌ ନେସ୍‌ଏର୍‌, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାର୍‌ ଅବିସାପ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ଆମା ନିକଦିମ ଇୟାଆଗ୍‌ଡ଼ି ୱାନି ଲାକ୍‌ତୁ ୱାତାମାର୍ହାନ୍‌ ମାରି ଏନ୍‌ ୱାରି ଲୋଇ ଅରେନ୍‌ନେ, ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","ଇରିଙ୍ଗ୍‌ ଅରେନ୍‍ ଲୋକାମାଣ୍‌କୁ ଆଗ୍‌ଡ଼ି ୱେନ୍‌ଏଣ୍‌ଗା ମାରି ୱାନି ବୁଲାସାଲାନି ବିସୟ୍‌ ନେସ୍‌ଏଣ୍‌ଗା ମା ସାସ୍ତ୍ର ଇନିକା ୱାନିଙ୍ଗ୍‌ ଦୋସ୍‌ କିନାତ୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ନିନ୍‌ ବା ଇନିକା ଅରେନ୍‍ ଗାଲିଲିୟ୍‌ଦି ଲୋକୁ ? ଗାଲିଲିଦାନ୍‌ ଏମେ ବାବବାଦି ସଏନ୍‌, ଇକା ନେଗେନ୍‌ କିଜି ଦାର୍ମୁସାସ୍ତ୍ର ପୟଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ତାନେ ୱେନ୍‌କା ଆୟା ବାଡି ଡ଼ିସ୍‌ସି ୱିଜେରେ ଜିହୁଦି ନେତାର୍‌ ନିଜେ ନିଜେଦି ଇଲ୍‌କାଙ୍ଗ୍‌ ସର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ମାତର୍‌ ଜିସୁ ଜିତ ଗରନ୍‌ତୁ ସର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ଆୟା ମାରାନାଣ୍ତିଙ୍ଗ୍‌ ସାଲ୍‌ଦିନେ ଜିସୁ ମାରିଡ଼େସି ମନ୍ଦିର୍‌ତୁ ୱାତାନ୍‌, ମାରି ୱିଜେରେ ଲୋକୁ ୱାନି ଲାକ୍‌ତୁ ଉଣ୍ତାତାର୍‌ଆକା, ୱାନ୍‌ ବାସ୍‌ତାନ୍‌ନୋ ୱାରିଙ୍ଗ୍‌ ସିକିୟା ସିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ମାରି, ସାସ୍ତ୍ରିର୍‍ ମାରି ପାରୁସିର୍‌ ଦାରିପାଣି କିତିମାନି ଅରେତ୍‌ ଆଇମାଦିଙ୍ଗ୍‍ ଆସ୍‌ତାତାତାର୍‌ ତାନିଙ୍ଗ୍‌ ୱିଜେରିନାଣ୍‌ମି ନିଲ୍‌ପ୍‌ତାରୋ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“ଏ ଗୁରୁ, ଇୟା ଆଇମା ଦାରିପାଣି କିନିୱାଲେ ଦରାପଡ଼ାତାମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ଇୟାୱାଜା ଆଇମେକାଙ୍ଗ୍‍ଁ କାଲ୍‌କାଣୁ ପୋକ୍‌ସି ଡାକ୍‌ତେଙ୍ଗ୍‍ଁ ମୋସା ମାଙ୍ଗିଁ ସାସ୍ତ୍ରଦୁ ଆଦେସ୍‌ ସିତାମାନାନ୍‌; ଆରିଙ୍ଗ୍‌ ନିନ୍‌ ଇନିକା ଇଜିନି ?” ");
INSERT INTO kfcp_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ୱାର୍‌ ଏଣ୍ତେସ୍‌ ୱାନି ବିରଦ୍‌ତାନ୍‌ ଦୋସ୍‌ ପୟ୍‌ଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାର୍‍, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ପରିକା କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ଇକା ଇର୍ହାର୍‌ । ମାତର୍‌ ଜିସୁ ପାଡ଼୍‌ଗିତାନ୍‌ନୋ ଡ଼ାସ୍‌କେଣ୍‌କୁ ବୁମିଦୁ ରାସ୍‌ତେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ମାତର୍‌ ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଡ଼େସି ଡ଼େସି ୱେନ୍‍ବାତାର୍‍ଆକା, ୱାନ୍‌ ତାଲା ପେର୍‌ଜି ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମି ଲୋଇ ଏନ୍‌ ପାପ୍‌ ସିଲିକାନ୍‍, ୱାନ୍‌ ଆଗିଡ଼ି ତାନିଙ୍ଗ୍‍ କାଲୁ ପକିନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ମାରିଡ଼େସି ଜିସୁ ପାଡ଼୍‌ଗିଜି ବୁମିଦୁ ରାସ୍‌ତେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ଆକା ୱେନ୍‌ଜି ୱାର୍‌ ପେରି ଲୋକାମାଣ୍‌କୁ ୱିଜେରେ ଅରେନ୍‍ ଅରେନ୍‍ ଆଜି ସହସି ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, ମାରି କେବଲ୍‌ ଜିସୁ ନି ମଜାୟ୍‍ ନାଡ଼୍‍ମି ଆୟା ଆଇମା ତେବାତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ମାରି, ଜିସୁ ତାଲା ପେର୍‌ଜି ତାନିଙ୍ଗ୍‍ ଇର୍ହାନ୍‌, “ଏ ଆଇମା, ୱାର୍‌ ଏମେ ? ଏନ୍‌ ନିଙ୍ଗିଁ ଦୋସ୍‍କିଦେଙ୍ଗ୍‍ ସିଲେନ୍‌ ନୋ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ଆଇମା ଇର୍ହାତ୍‌, “ଏନ୍‌ ସିଲେ, ପ୍ରବୁ ।” ଆବେଟ୍‌ ଜିସୁ ଇର୍ହାନ୍‌, “ନାନ୍ ବା ନିଙ୍ଗିଁ ଦୋସ୍‍ କିଏଜିନା; ସାଙ୍ଗ୍‍ଆ, ନେର୍‌ଆନ୍‌ ମାରି ପାପ୍‌ କିମା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ଜିସୁ ମାରିଡ଼େସି ପାରୁସିରିଙ୍ଗ୍‍ ଇର୍ହାନ୍‌, “ନାନ୍ ଦୁନିଆଦି ଜାୟ୍‌; ଏନ୍‌ ନା ୱେନ୍‌କା ୱାନାନ୍‌, ମାତର୍‌ ଜିବନ୍‍ତି ଜାୟ୍‌ ପଇନାନ୍‍ ୱାନ୍‌ ଏସାଙ୍ଗ୍‍ ବା ସିକାଟିଦୁ ବୁଲାଏନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ଆବେଟ୍‌ ପାରୁସିର୍‌ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାର୍‌, “ନିନ୍‌ ନିଜେ ନିଜେଦି ବିସୟ୍‌ତାନ୍‌ ସାକି ସିଜିନି, ନି ସାକି ସତ୍‌ ସିଲେ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ସିଲେ, “ନାନ୍ ନିଜେଦି ଉଣ୍ତିଙ୍ଗ୍‌ ସାକି ସିତିଙ୍ଗ୍‍ବା ନାନ୍ ଆମାକା ଇଜିନା, ଆକା ସତ୍‌, ଇରିଙ୍ଗ୍‌ ନାନ୍ ଏମେଣ୍‌କୁ ୱାତାମାନା ମାରି ଏମେମାନୁ ସଲ୍‍ସିନା, ଆକା ନାନ୍ ନେସ୍‌ନା, ମାତର୍‌ ମିର୍‌ ନାନ୍ ଏମେଣ୍‌କୁ ୱାତାମାନା ମାରି ଏମେମାନୁ ସନା, ଆକା ମିର୍‌ ନେସ୍‌ଇଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ମିର୍‌ ଲୋକା ୱାଜା ବିସାର୍‌ କିନିଦେର୍‍, ନାନ୍ ଏ ବିସାର୍‌ କିଏ । ");
INSERT INTO kfcp_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ମାତର୍‌ ନାନ୍ ଜଦି ବିସାର୍‌ କିନା, ଆରିଙ୍ଗ୍‍ବା ନା ବିସାର୍‌ ଟିକ୍‌; ଇରିଙ୍ଗ୍‌ ନାନ୍ ଅରେନେ ସିଲେ, ମାତର୍‌ ନା ପକ୍‍ତିମାନିବୁବା ନା ୱାଲେ ମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ମାରି, ରିଏରି ସାକି ସାମାନ୍‍ ଆତିଙ୍ଗ୍‌, ୱାର୍‌ ଆମାକା ଇଜିନାର୍‍ ଆକା ସତ୍‌, ଇକା ମି ନିୟମ୍‌ତୁ ବା ରାସାତାମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ନାନ୍ ନିଜେ ନିଜେଦି ସାକି, ମାରି ନା ପୋକ୍‍ତିମାନି ବୁବା ନା ବିସୟ୍‌ତାନ୍‌ ସାକି ସିଜିନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ଆବେଟ୍‌ ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, “ମି ବୁବା ଏମେ ?” ଜିସୁ ଇର୍ହାନ୍‌, “ମିର୍‌ ନାଙ୍ଗିଁ ନେସ୍‌ଇଦେର୍‌ ମାରି ନା ବୁବେଙ୍ଗ୍‌ ବା ନେସ୍‌ଇଦେର୍‌; ଜଦି ନାଙ୍ଗିଁ ନେସ୍‌ତିଙ୍ଗ୍‌, ଆରିଙ୍ଗ୍‌ ନା ବୁବେଙ୍ଗ୍‌ ବା ନେସ୍‌ତିଦେର୍‌ମାନ୍ଦି ।” ");
INSERT INTO kfcp_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ମନ୍ଦିର୍‌ତି ଦାନ୍‍ ଉଣ୍ତାକିନି ପେଡ଼େଙ୍ଗ୍‌ ଇଟ୍‍ତିମାର୍‍ଇ ବାକ୍‍ରାଦୁ ଜିସୁ ଇୟାୱିଜୁ ବିସୟ୍‌ ସିକିୟା ସିଜିମାର୍ହାନ୍‍, ମାତର୍‌ ଏନ୍‌ ୱାନିଙ୍ଗ୍‌ ତର୍‍ଏତାର୍‌, ଇରିଙ୍ଗ୍‌ ୱାନି ୱେଡ଼ା ଆୟାସାନ୍ଧି ରେଏତ୍‌ ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ଆବେଟ୍‌ ଜିସୁ ମାରିଡ଼େସି ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନାନ୍ ସୋଲ୍‌ସିନା, ମାରି ମିର୍‌ ନାଙ୍ଗିଁ ପୋୟ୍‌ନିଦେର୍‌ ମାତର୍‌ ମିର୍‌ ନିଜେ ନିଜେଦି ପାପ୍‌ତାନ୍‌ ସାନିଦେର୍‌, ନାନ୍ ଏମେମାନୁ ସୋଲ୍‌ସିନା, ମିର୍‌ ଆବେନୁ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଆଟ୍‍ଇଦେର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ଆବେଟ୍‌ ଜିହୁଦି ନେତାର୍‌ ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, ୱାନ୍‌ ଇଜିନାନ୍‌, ୱାନ୍‌ ଏମେମାନୁ ସଲ୍‍ସିନା, “ମାପ୍‌ ଆବେ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଆଟ୍‍ଏପ୍‍ । ୱାନ୍‌ ସାଦେଙ୍ଗ୍‌ ସଲ୍‌ସିନାନ୍‌ ନୋ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ଆବେଟ୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମିର୍‌, ଦୁନିଆଦାନ୍‍ ଜନମ୍‍ ଆତିମାନିଦେର୍‍, ମାତର୍‌ ନାନ୍ ମୁସ୍‌କୁରାନ୍‌ ୱାତାମାନା; ମିର୍‌ ଇୟା ଦୁନିଆଦାନ୍‍ ୱାତିମାନିଦେର୍‌, ନାନ୍ ଇୟା ଦୁନିଆଦାନ୍‌ ରେଏ । ");
INSERT INTO kfcp_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ଆରିଙ୍ଗ୍‌ ମିର୍‌ ଜେ ନିଜେ ନିଜେଦି ପାପ୍‌ତାନ୍‌ ସାନିଦେର୍‌, ନାନ୍ ମିଙ୍ଗିଁ ଇକା ୱେର୍‌ତା; ଇରିଙ୍ଗ୍‌ ନାନ୍ ଜେ ନିଜେ ଆୟା ଲୋକୁ, ଇକା ମିର୍‌ ବିସ୍‌ବାସ୍‌ କିଇତିଙ୍ଗ୍‌ ନିଜେ ନିଜେଦି ପାପ୍‌ତାନ୍‌ ସାନିଦେର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ଆବେଟ୍‌ ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, “ନିନ୍‌ ଏନ୍‌ ?” ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଆୟା ମାଟା ନାନ୍ ଆଗ୍‍ଡ଼ିରାନ୍‍ ଇଜି ୱାଜିନା । ");
INSERT INTO kfcp_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ମି ବିସୟ୍‌ତାନ୍‌ ମାଟା ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ମାରି ବିସାର୍‌ କିଦେଙ୍ଗ୍‌ ନାଙ୍ଗିଁ ଗାଦି ବିସୟ୍‌କୁ ମାନେ; ଆମାକାଆପିତ୍‌; ନା ପୋକ୍‌ତାତିମାନିକାନ୍‍ ସତ୍‌, ମାରି ନାନ୍ ୱାନିମାଣ୍‌କୁ ଆମା ଆମାକା ୱେର୍‌ଆମାନା, ଆୟାୱିଜୁ ଦୁନିଆଦିଙ୍ଗ୍‌ ୱେର୍‌ସିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ଜିସୁ ୱାନି ବୁବାଦି ବିସୟ୍‌ତାନ୍‌ ୱାରିଙ୍ଗ୍‌ ୱେର୍‌ସି ମାର୍ହାନ୍‌, ଇକା ୱାର୍‌ ବୁଜାଏତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ମାରି, ଜିସୁ ଇର୍ହାନ୍‌, “ଏସ୍ତିୱାଲେ ମିର୍‌ ମନୁସ୍ୟପୁତ୍ରଙ୍ଗ୍‌ ମୁସ୍‌କୁ ପେର୍‌ନିଦେର୍‌, ନାସ୍ତିୱାଲେ ନାନ୍ ଜେ ନିଜେ ଆୟା ଲୋକୁ; ମାରି ନାନ୍ ନିଜେଦି ଅଦିକାର୍‍ତାନ୍‍ ଇନିକା କିଏ ମାତର୍‌ ଆମାକା ନା ବୁବା ନାଙ୍ଗିଁ ଏଣ୍ତେସ୍‌ ସିକିୟା ସିତାନ୍‌, ଆୟାୱାଜା ଇୟାୱିଜୁ ମାଟା ଜେ ୱେର୍‌ସିନା, ଇକା ମିର୍‌ ବୁଜାନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ନା ପୋକ୍‌ତାତିମାନିକାନ୍‍ ନା ୱାଲେ ମାନାନ୍‌; ୱାନ୍‌ ନାଙ୍ଗିଁ ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ଡ଼ିସ୍‌ଏନ୍‌, ଇରିଙ୍ଗ୍‌ ନାନ୍ ୱିଜୁୱାଲେ ଆମାକା ୱାନି ୱେଡ଼ିକାଦି ପାଣି କିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ଜିସୁଦି ଇୟା ମାଟା ୱେନ୍‌ଞ୍ଜି ନାଣ୍ତ ଲୋକୁ ୱାନିଙ୍ଗ୍‌ ବିସ୍‌ବାସ୍‌ କିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ମାରି, ଜିସୁ ୱାନିଙ୍ଗ୍‌ ବିସ୍‌ବାସ୍‌ କିତିମାନି ଜିହୁଦିରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଜଦି ମିର୍‌ ନା ସିକିୟାଦୁ ମାନାନିଦେର୍‌ କିନିଦେର୍‍, ଆରିଙ୍ଗ୍‌ ମିର୍‌ ସତ୍‌ତାନ୍‍ ନା ସିସୁର୍‍, ");
INSERT INTO kfcp_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ମାରି ମିର୍‌ ସତ୍‌ ନେସ୍‌ନିଦେର୍‌ ମାରି ଆୟା ସତ୍‌ ମିଙ୍ଗିଁ ଡ଼ିସିସ୍‍ କିନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାର୍‌, “ମାପ୍‌ ଅବ୍ରାହାମତି କୁଟୁମ୍‌, ମାରି ଏସାଙ୍ଗ୍‍ ବା ଏମେୱାନି କଟିସାକର୍‍ ଆଏପ୍‍, ଆରିଙ୍ଗ୍‌ ମିର୍‌ ଡ଼ିସାଇ ଆନିଦେର୍‌ ଇଜି ଏଣ୍ତେସ୍‌ ଇଜିନିଦେର୍‌ ? ତେନି ଅର୍ତ ଇନିକା ?” ");
INSERT INTO kfcp_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ସତ୍‌ ସତ୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ଏନ୍‌ ପାପ୍‌ କିନାନ୍‍, ୱାନ୍‌ ପାପ୍‍ତି ସାକର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ସାକର୍‌ ୱିଜୁଦିନ୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ଇଲୁଦି ଅରେନ୍‍ ଆଜି ତେବାଏନ୍‍, ମାତର୍‌ ଇଲୁଦି ମାରିନ୍‌ ୱିଜୁଦିନ୍‌ ତେବାନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ମାରିନ୍‌ ଜଦି ମିଙ୍ଗିଁ ଡ଼ିସିସ୍‌ କିନାନ୍‌, ଆତିଙ୍ଗ୍‌ ମିର୍‌ ସତ୍‌ତାନ୍‌ ଡ଼ିସାଇ ଆନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ମିର୍‌ ଜେ ଅବ୍ରାହାମତି କୁଟୁମ୍‌, ଆକା ନାନ୍ ନେସ୍‌ନା; ମାତର୍‌ ନା ସିକିୟା ମି ଜିବନ୍‍ତୁ ବାଡି ମାନାଏଦେର୍‍ଆକା ମିର୍‌ ନାଙ୍ଗିଁ ଡାକ୍‍ତେଙ୍ଗ୍‍ ବଦା କିଜିନିଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ନା ବୁବାମାନୁ ଆମା ଆମାକା ନାନ୍ ସୁଡ଼ୁତାମାନା, ଆୟାୱିଜୁ ନାନ୍ ୱେର୍‌ନା; ମାତର୍‌ ମି ବୁବା ଇନି ଇସାବ୍‌ତାନ୍‌ ପାଣି କିଜିନିଦେର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ଜିହୁଦିର୍‍ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାର୍‌, “ଅବ୍ରାହାମ ମା ବୁବା ।” ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଜଦି ମିର୍‌ ଅବ୍ରାହାମତି ମାରିସିର୍‌ ଆତିଦେର୍‍ମାନ୍ଦି, ଆରିଙ୍ଗ୍‌ ଅବ୍ରାହାମ କିତିମାନି ପାଣି କିତିଦେର୍‍ମାନ୍ଦି; ");
INSERT INTO kfcp_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ମାପୁରୁମାଣ୍‌କୁ ୱେର୍‍ଇମାନି ସତ୍‌ ଡ଼ିସ୍‍ତିଙ୍ଗ୍‍ ମିଙ୍ଗିଁ ମାରି ଇନିକା ଇନ୍‌ଏ, ଆରିଙ୍ଗ୍‍ବା ମିର୍‌ ନାଙ୍ଗିଁ ଡାକ୍‍ତେଙ୍ଗ୍‍ ବଦା କିଜିନିଦେର୍‍; ଅବ୍ରାହାମ ଇୟାୱାଜା ପାଣି କିଏନ୍‌ ମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ମିର୍‌ ମି ବୁବାଦି ପାଣିୱିଜୁ କିଜିନିଦେର୍‍ । ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ମାପ୍‌ ଦାରିପାଣିଦାନ୍‍ ଜନମ୍‍ ଆଏପ୍‍, କେବଲ୍‌ ମାପୁରୁ ଅରେନ୍‍ନେ ମା ବୁବା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମାପୁରୁ ଜଦି ମି ବୁବା ଆତାନ୍‍ମାନ୍ଦି, ଆରିଙ୍ଗ୍‌ ମିର୍‌ ନାଙ୍ଗିଁ ଜିବନ୍‌ ନତିଦେର୍‍ମାନ୍ଦି; ଇରିଙ୍ଗ୍‌ ନାନ୍ ମାପୁରୁ ମାଣ୍‌କୁ ୱାଜି ଇଲେଇ ଇବେ ମାନା; ନାନ୍ ନିଜେଦି ଅଦିକାର୍‍ତାନ୍‍ ରେଏ, ମାତର୍‌ ୱାନ୍‌ ନାଙ୍ଗିଁ ପକ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ନାନ୍ ଆମାକା ଇଜିନା, ମିର୍‌ ଏନ୍ଦା ନା ମାଟା ବୁଜାଏଜିନିଦେର୍‍ ? ଇରିଙ୍ଗ୍‌ ମିର୍‌ ତୋ ନା ବାକ୍ୟ ୱେନ୍‌ଜି ମାନାଦେଙ୍ଗ୍‌ ଆଟ୍‍ଇଜିନିଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ମିର୍‌ ମି ବୁବା ସୟତାନ୍ ମାଣ୍‌କୁ ଜନମ୍‍ ଆତିମାନିଦେର୍‍, ମାରି ମି ବୁବାଦି ପାଣି କିଦେଙ୍ଗ୍‌ ମି ବଦା । ୱାଦ୍‌ ଆଗ୍‍ଡ଼ିରାନ୍‍ ଲୋକାଙ୍ଗ୍‌ କାତ୍‍ନିକାତ୍‍, ମାରି ୱାଦ୍‌ ସତ୍‍ତୁ ତେବାଏତ୍‍, ଇରିଙ୍ଗ୍‌ ତାନେମାନୁ ସତ୍‌ ସିଲେତ୍‌ । ଏସ୍ତିୱାଲେ ୱାଦ୍‌ ମିସ୍‌ ଇନାତ୍‍, ନାସ୍ତିୱାଲେ ୱାଦ୍‌ ନିଜେଦି ମାଣାନ୍‌ ଇନାତ୍‍; ଇରିଙ୍ଗ୍‌ ୱାଦ୍‌ ନିଜେ ମିସ୍‍ଇନିକାତ୍‍ ନି ମିସ୍‌ ୱେର୍‍ନି ଲୋକା ବୁବା । ");
INSERT INTO kfcp_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ମାତର୍‌ ନାନ୍ ସତ୍‌ ଇର୍ହାମାନାଆକା ମିର୍‌ ନାଙ୍ଗିଁ ବିସ୍‌ବାସ୍‌ କିଇଜିନିଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ନାବାନ୍‍ ପାପ୍‌ ମାନାତ୍‌ ଇଜି ମି ବାଣାନ୍‍ ଏନ୍‌ ପାର୍‍ମାନ୍‍ ସିଜିନାନ୍‌ ? ନାନ୍ ଏସ୍ତିୱାଲେ ସତ୍‌ ଇନା, ଆରିଙ୍ଗ୍‌ ମିର୍‌ ଏନ୍ଦା ବିସ୍‌ବାସ୍‌ କିଇଜିନିଦେର୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ଏନ୍‌ ମାପୁରୁ ମାଣାନ୍‌ ଜନମ୍‍ ଆତାମାନାନ୍‌, ୱାନ୍‌ ମାପୁରୁଦି ବାକ୍ୟ ୱେନାନ୍‌; ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ମିର୍‌ ନା ବାକ୍ୟ ୱେନ୍‍ଇଦେର୍‍, ଇରିଙ୍ଗ୍‌ ମିର୍‌ ମାପୁରୁଦି ମାଣାନ୍‌ ଜନମ୍‍ ଆଇଦେର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ଜିହୁଦି ନେତାର୍‌ ଜିସୁଙ୍ଗୁଁ ୱେନ୍‌ବାତାର୍‌, “ନିନ୍‌ ଜେ ଅରେନ୍‍ ସମିରୋଣିୟ ମାରି ନିଙ୍ଗିଁ ଜେ ଦୁବା ଆସ୍‍ତାମାନାତ୍‍, ଇକା ଇନିକା ମାପ୍‌ ଟିକ୍‌ ଇନ୍‍ଏପ୍‌ ମାର୍ହାପ୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ଜିସୁ ଇର୍ହାନ୍‌, “ନାଙ୍ଗିଁ ଦୁବା ଆସ୍‌ଏତ୍‌, ନାନ୍ ନା ବୁବେଙ୍ଗ୍‌ ମାନାଜିନା, ମାତର୍‌ ମିର୍‌ ନାଙ୍ଗିଁ ମାନାଇଜିନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ମାତର୍‌ ନାନ୍ ନିଜେଦି ଗୌରବ୍‍ ପୟ୍‍ଏ; ଏନ୍‌ ପଇନାନ୍‍ ମାରି ବିସାର୍‌ କିନାନ୍‍, ଇୟାୱାଜା ଅରେନ୍‍ ମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ସତ୍‌ ସତ୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ଜଦି ଏନ୍‌ ନା ସିକିୟା ମାନାନାନ୍‍, ଆତିଙ୍ଗ୍‌ ୱାନ୍‌ ଏସାଙ୍ଗ୍‌ ବା ସାଏନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ଜିହୁଦିର୍‍ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାର୍‌, “ଇଲେଇ ମାପ୍‌ ନେସ୍‍ତାପ୍‍ ଜେ ସତେନେ ନିଙ୍ଗିଁ ଦୁବା ଆସ୍‍ତାମାନାତ୍‍, ଅବ୍ରାହାମ ମାରି ବାବବାଦିର୍ ସାତା ମାନାର୍‌, ମାରି ନିନ୍‌ ଇଜିନି, ଜଦି ଏନ୍‌ ନା ସିକିୟା ମାନାନାନ୍‍, ଆତିଙ୍ଗ୍‌ ୱାନ୍‌ ଏସାଙ୍ଗ୍‌ ବା ସାଏନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ନିନ୍‌ ଇନିକା ମା ବୁବା ଅବ୍ରାହାମତି ମାଣାନ୍‌ ପେରିକିନ୍ଦା ? ଅବ୍ରାହାମ ତୋ ସାତା ମାନାନ୍‌, ବାବବାଦିର୍ ବା ସାତାମାନାର୍‍; ନିନ୍‌ ନିଜେଦିଙ୍ଗ୍‍ ଏନ୍‌ ଇଜି ଅଡ଼୍‍ବିଜିନି ?” ");
INSERT INTO kfcp_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ଜିସୁ ଇର୍ହାନ୍‌, “ନାନ୍ ଜଦି ନିଜେଦି ଦନ୍ୟବାଦ୍‌ କିଦେଙ୍ଗ୍‌ ବଦା କିତାମାନ୍ଦି, ଆରିଙ୍ଗ୍‌ ତେନି ଦାରା ତେବାଏତାତ୍‍ମାନ୍ଦି; ଏନ୍‌ ନାଙ୍ଗିଁ ଗୌରବ୍‍ କିନାନ୍‍, ୱାନ୍‌ ନା ବୁବା ଏମେୱାନିଙ୍ଗ୍‌ ମିର୍‌ ମି ମାପୁରୁ ଇଜି ଇଜିନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ମାରି, ମିର୍‌ ୱାନିଙ୍ଗ୍‌ ନେସ୍‌ଇଦେର୍‌, ମାତର୍‌ ନାନ୍ ୱାନିଙ୍ଗ୍‌ ନେସ୍‌ନା । ମାରି, ନାନ୍ ୱାନିଙ୍ଗ୍‌ ନେସେଏ ଇଜି ଜଦି ଇନା, ଆତିଙ୍ଗ୍‌ ନାନ୍ ବା ମି ୱାଜା ମିସ୍‍ବାଦି ଆନା, ମାତର୍‌ ନାନ୍ ନେସ୍‌ନା ମାରି ୱାନି ବାକ୍ୟ ମାନାନା । ");
INSERT INTO kfcp_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ମି ବୁବା ଅବ୍ରାହାମ ନା ଦିନ୍‌ ସୁଡ଼ୁନି ଆସାଦାନ୍‍ ୱେଡ଼ିକା କିନାନ୍‍, ମାରି ୱାନ୍‌ ଆକା ସୁଡ଼ୁଜି ୱେଡ଼ିକା କିତାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ଆବେଟ୍‌ ଜିହୁଦିର୍‌ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାର୍‌, “ନିଙ୍ଗିଁ ତୋ ଇୟାସାନ୍ଦି ପସାସ୍‌ ବାର୍‍ସେକ୍‍ ଆଏଦେ, ନିନ୍‌ ଇନିକା ଅବ୍ରାହାମ୍‍ତିଙ୍ଗ୍‌ ସୁଡ଼ୁତିମାନି ?” ");
INSERT INTO kfcp_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ସତ୍‌ ସତ୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ଅବ୍ରାହାମ ଜନମ୍‍ ଆନି ଆଗ୍‍ଡ଼ିରାନ୍‍ ନାନ୍ ମାନା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ଆବେଟ୍‌ ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ଡାକ୍‍ତେଙ୍ଗ୍‍ ଇଜି କାଲ୍‌କୁ ପେର୍‌ତାର୍‌, ମାତର୍‌ ଜିସୁ ମାର୍‍ଗିଜି ମନ୍ଦିର୍‌ତାନ୍‌ ସତାସର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ଜିସୁ ସନିୱାଲେ ଅରେନ୍‍ କାଣା ଆଜି ଜନମ୍‍ଆତି ୱାନିଙ୍ଗ୍‌ ସୁଡ଼ୁତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ମାରି, ୱାନି ସିସୁର୍‍ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‍ବାତାର୍‌, “ଏ ଗୁରୁ, ଏନ୍‌ ପାପ୍‌ କିତାମାନାନ୍‍ଆକା ଇକାନ୍‌ କାଣା ଆଜି ଜନମ୍‌ ଆତାନ୍‌ ? ନିଜେ ନୋ ୱେନି ଆଇସି ବୁବାସିର୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ଜିସୁ ଇର୍ହାନ୍‌, “ଇକାନ୍‌ କି ୱେନି ଆଇସି ବୁବାସି ପାପ୍‌ କିଏତାର୍‌, ମାତର୍‌ ମାପୁରୁଦି ସାକ୍ତି ଏଣ୍ତେସ୍‌ ୱେନିମାନୁ ତରାଇ ଆନାତ୍‌, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାନ୍‌ କାଣା ଆଜି ଜନମ୍‌ ଆତାନ୍‌, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ଇକା ଗଟାତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ଦିନ୍‌ ମାନାପ୍ ମାନାପ୍ ନା ପକ୍‍ତିମାନି ପାଣି କିନିକା ମା ନେଗେତ୍‌; ଇୟାୱାଜା ନାଡ଼ା ୱାଜିନାତ୍‍, ଆୟା ସାନ୍ଦି ନାନ୍ ଦୁନିଆଦି ଏମେ ସମୟତୁ ଏନ୍‌ ପାଣି କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ନାନ୍ ଦୁନିଆଦୁ ଆମା ସାନ୍ଦି ମାନା, ନାନ୍ ଦୁନିଆଦି ଜାୟ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ଇକା ଇର୍‍ଇ ୱେନ୍‌କା ଜିସୁ ସିକ୍‍ଲାଦୁ ପୁସ୍‍ସି ଆୟା ପୁସ୍‍କାଣାଙ୍ଗ୍‍ତାନ୍‍ ଲାଦି କିତାନ୍‌, ମାରି ୱାନି କାଣ୍‌କାଙ୍ଗ୍‌ ଲାଦି ଉସ୍‍ସି ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“ସାଙ୍ଗ୍‍ଆ, ସେରୁଦୁ ମକମ୍‌ ଉର୍‍ପାଜ ରାଆ ।” ସିଲୋହଦି ଅର୍ତ ସାଙ୍ଗ୍‍ଆ । ଆବେଟ୍‌ ୱାନ୍‌ ସଲ୍‌ସି ମକମ୍‌ ଉର୍‍ପାଜି ଡ଼େସିୱାନି ୱାଲେ କାଣୁକୁ ସୁଡ଼ୁନି ସାକ୍ତି ପ‍ଇତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ଆବେଟ୍‌ ୱାନି ପାଡ଼୍‍କାତିକେଙ୍ଗ୍‍, ମାରି ଏମେକାର୍‌ ୱାନିଙ୍ଗ୍‌ ଆଗ୍‌ଡ଼ି ଅରେନ୍‍ ବିକାରି ଇଜି ସୁଡ଼ୁତାମାର୍ହାର୍‍, ୱାର୍‌ ୱେନ୍‌ବାତାର୍‌, “ଏନ୍‌ ବାସ୍‌ସି ଭିକିୟା ଲସ୍‌ସି ମାର୍ହାନ୍‍, ଇକାନ୍‌ ଇନିକା ଆକାନ୍‍ ଆଏନ୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ଏନ୍‌ ଏନ୍‌ ଇର୍ହାର୍‌, “ଇକାନ୍‌ ୱାନ୍‌,” ମାରି ଏନ୍‌ ଏନ୍‌ ଇର୍ହାର୍‌, “ସିଲେ; ଇକାନ୍‌ ୱାନି ନାନିକାନ୍‍ ।” ମାତର୍‌ ୱାନ୍‌ ଇର୍ହାନ୍‌, “ନାନ୍ ଆୟା ଲୋକୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ଆବେଟ୍‌ ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ଆରିଙ୍ଗ୍‌ ନି କାଣୁକୁ ଏଣ୍ତେସ୍‌ ନେଗେନ୍‌ ଆତେ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ୱାନ୍‌ ଇର୍ହାନ୍‌, “ଆମାୱାନିଙ୍ଗ୍‌ ଜିସୁ ଇଜି ଇନାର୍‌, ଆୟାକାନ୍‌ ଲାଦି କିଜିନା କାଣ୍‌କାଙ୍ଗ୍‌ ଉସ୍‍ତାନ୍‍, ମାରି ନାଙ୍ଗିଁ ଇର୍ହାନ୍‌, ସିଲୋହଦୁ ସଲ୍‌ସି ମକମ୍‌ ଉର୍‍ପାଆ; ଆବେଟ୍‌ ନାନ୍ ସହସି ସଲ୍‌ସି ଉର୍‍ପାତା ମାରି କାଣୁକୁ ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ଆଟ୍‍ତା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, “ୱାନ୍‌ ଏମେ ?” ୱାନ୍‌ ଇର୍ହାନ୍‌, “ନାନ୍ ନେସେଏ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ଏନ୍‌ ଜନମ୍‍ତାନ୍‍ କାଣା ମାର୍ହାନ୍‍, ୱାର୍‌ ଆୟା ଲୋକ୍‌ତିଙ୍ଗ୍‌ ପାରୁସିର୍‌ ଲାକ୍‌ତୁ ତାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ଜିସୁ ଆମା ନାଣ୍ଡିଙ୍ଗ୍ ଲାଦି କିଜି ୱାନି କାଣ୍‌ଗା ନେଗେଣ୍ତ୍‍ କିତାମାର୍ହାନ୍‌, ଆୟାଦିନ୍‍ ରମ୍‍ନିଦିନ୍‍ ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ଆବେଟ୍‌ ୱାନ୍‌ ଏଣ୍ତେସ୍‌ କାଣୁକୁ ସୁଡ଼ୁତାନ୍‌, ଇକା ପାରୁସିର୍‌ ୱାନିଙ୍ଗ୍‌ ମାରିଉଣ୍ତ୍ରିଦେବା ୱେନ୍‍ବାଦେଙ୍ଗ୍‍ ଆସ୍‌ତାର୍‌ । ଆବେଟ୍‌ ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ୱାନ୍‌ ନା କାଣ୍‍ଗାଦୁ ଲାଦି ଉସ୍‍ତାସିତାନ୍‍, ନାନ୍ ସର୍ହାନୋ ମକମ୍‌ ଉର୍‍ପାତା ମାରି ଇଲେଇ ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ଆଟ୍‍ସିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ମାରି ପାରୁସିର୍‌ ଲୋଇ ଏନ୍‌ ଏନ୍‌ ଇର୍ହାର୍‌, “ଆୟା ଲୋକ୍‌ ମାପୁରୁ ମାଣାନ୍‌ ରେଏନ୍‌, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ରମ୍‍ନିଦିନ୍‍ ମାନାଏଜିନାନ୍‍ ।” ମାରି, ଏନ୍‌ ଏନ୍‌ ଇର୍ହାର୍‌, “ପାପି ଲୋକୁ ଏଣ୍ତେସ୍‌ ଇୟାୱାଜା କାବାଆନି ପାଣିୱିଜୁ କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାନ୍‍ ?” ଇୟାୱାଜା ୱାରି ଲୋଇ ଜାଟି ନିଙ୍ଗିଁତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ମାରି ପାରୁସିର୍‌ ମାରିଉଣ୍ତ୍ରିଦେବା ଆୟା କାଣା ଲୋକ୍‌ତିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, “ୱାନ୍‌ ଜେ ନିଙ୍ଗିଁ କାଣୁକୁ ସୁଡ଼ିସ୍‍ କିତାନ୍‌, ଆବେନୁ ନିନୁ ୱାନି ବିସୟ୍‌ତାନ୍‌ ଇନିକା ଇଜିନି ?” ୱାନ୍‌ ଇର୍ହାନ୍‌, “ୱାନ୍‌ ଅରେନ୍‍ ବାବବାଦି ।” ");
INSERT INTO kfcp_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ୱାନ୍‌ ଜେ ଜନମ୍‍ତାନ୍‍ କାଣା ମାର୍ହାନ୍‍ ମାରି ସୁଡ଼ୁତାମାନାନ୍‌, ଆୟା କାଣୁକୁ ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ଆଟ୍‍ତି ଲୋକ୍‌ତି ବୁବାସି ଆଇସିଙ୍ଗ୍‍ କୁକ୍‌ସି ୱେନ୍‍ବାଇ ସାନ୍ଦି ଜିହୁଦି ନେତାର୍‌ ୱାନି ବିସୟ୍‌ତାନ୍‌ ଇକା ବିସ୍‌ବାସ୍‌ କିଏତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ୱାର୍‌ ୱାନି ବୁବାସି ଆଇସିଙ୍ଗ୍‍ ୱେନ୍‍ବାତାର୍‌, ମି ଏମେ କଡ଼ କାଣା ଆଜି ଜନମ୍‌ ଆତାମାନାନ୍‌ ଇଜି ଇଜିମାରିଇଦେର୍‍, “ଇକାନ୍‌ ଇନିକା ମି ଆୟା କଡ଼ ? ଆରିଙ୍ଗ୍‌ ୱାନ୍‌ ଏଣ୍ତେସ୍‌ ଇଲେଇ ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ଆଟ୍‍ସିନାନ୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ଆବେଟ୍‌ ୱାନି ବୁବାସି ଆଇସି ଇର୍ହାର୍‌, “ଇକାନ୍‌ ଜେ ମା କଡ଼ ମାରି ଇକାନ୍‌ ଜେ କାଣା ଆଜି ଜନମ୍‌ ଆତାମାର୍ହାନ୍‍, ହୁଁ, ଇକା ମାପ୍‌ ନେସ୍‌ନାପ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ମାତର୍‌ ୱାନ୍‌ ଏଣ୍ତେସ୍‌ ଇଲେଇ ସୁଡ଼ୁଜିନାନ୍‍, ଆକା ନେସ୍‌ଏପ୍‌, ମାରି ଏନ୍‌ ୱାନି କାଣୁକୁ ସୁଡ଼ିସ୍‍କିତାନ୍‍, ଆକାବା ମାପ୍‌ ନେସ୍‌ଏପ୍‌; ୱାନିଙ୍ଗ୍‌ ୱେନ୍‍ବାଦୁ, ୱାନ୍‌ ତୋ ପିରିତାମାନାନ୍‍, ୱାନ୍‌ ୱାନି ମାଟା ନିଜେ ଇନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ୱାନି ବୁବାସି ଆଇସି ଜିହୁଦି ନେତାରିଙ୍ଗ୍‌ ତିଲାଜିମାର୍ହାର୍‍ଆକା ଇୟାୱିଜୁ ମାଟା ଇର୍ହାର୍‌, ଇରିଙ୍ଗ୍‌ ଜଦି ଏନ୍‌ ୱାନିଙ୍ଗ୍‌ ମସିହ ଇଜି ମାନାନାର୍‌, ଆରିଙ୍ଗ୍‌ ୱାନ୍‌ ପାର୍‌ତନା ଇଲ୍‌ତାନ୍‌ ସପାନାନ୍‍ ଇଜି ତାନି ଆଗ୍‌ଡ଼ି ଜିହୁଦିର୍‌ ଉଣ୍ତ୍ରେମାଟା ଆତାମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାନି ବୁବାସି ଆଇସି ଇର୍ହାର୍‌, “ୱାନ୍‌ ପିରିତାମାନାନ୍‍, ୱାନିଙ୍ଗ୍‌ ୱେନ୍‍ବାଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ଆବେଟ୍‌ ଜନମ୍‍ତାନ୍‍ କାଣା ମାରିଇ ଲୋକ୍‌ତିଙ୍ଗ୍‌ ୱାର୍‌ ମାରିଅର୍ସୁ କୁକ୍‌ସି ୱେନ୍‌ବାତାର୍‌, “ମାପୁରୁଙ୍ଗୁଁ ଗୌରବ୍‍ ସିଆ, ୱାନ୍‌ ଜେ ପାପି, ଇକା ମାପ୍‌ ନେସ୍‌ନାପ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ଆବେଟ୍‌ ୱାନ୍‌ ଇର୍ହାନ୍‌, “ୱାନ୍‌ ପାପି ନୋ ସିଲେ, ନାନ୍ ଆକା ନେସେଏ; ମାତର୍‌ ନାନ୍ ଉଣ୍ତ୍ରି ବିସୟ୍‌ ନେସ୍‌ନା, ନାନ୍ କାଣାମାର୍ହା, ଇଲେଇ ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ଆଟ୍‍ସିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ଆବେଟ୍‌ ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ୱାନ୍‌ ନିଙ୍ଗିଁ ଇନିକା କିତାନ୍‌ ? ୱାନ୍‌ ଏଣ୍ତେସ୍‍ କିଜିନି କାଣୁକୁ ସୁଡ଼ିସ୍‍ କିତାନ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ନାନ୍ ଇର୍ହାୱିସ୍‍ତାନି, “ମାରି ମିର୍‌ ୱେନ୍‍ଇତିଦେର୍‍; ଏନ୍ଦା ମାରି ଉଣ୍ତ୍ରି ଦେବା ୱେନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ବଦା କିଜିନିଦେର୍‌ ? ମିର୍‌ ବା ଇନିକା ୱାନି ସିସୁର୍‍ ଆଦେଙ୍ଗ୍‌ ବଦା କିଜିନିଦେର୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ଆବେଟ୍‌ ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଆନାଦୁରିୟା ଇଡ୍‌ଜି ଇର୍ହାର୍‌, “ନିନ୍‌ ୱାନି ସିସୁ, ମାତର୍‌ ମାପ୍‌ ମୋସାଦି ସିସୁର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ମାପ୍‌ ନେସ୍‌ନାପ୍‌ ଜେ, ମାପୁରୁ ମୋସାଦିଙ୍ଗ୍‍ ମାଟା ଇର୍ହାମାନାନ୍‌, ମାତର୍‌ ଇୟା ଲୋକୁ ଏମେଣ୍‌କୁ ୱାତାମାନାନ୍‍, ଆକାବା ମାପ୍‌ ନେସ୍‌ଏପ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ଆୟା ଲୋକୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ୱାନ୍‌ କାଣୁକୁ ସୁଡ଼ିସ୍‍କିତାନ୍‍, ମାରି ୱାନ୍‌ ଏମେଣ୍‌କୁ ୱାତାମାନାନ୍‍, ଆକା ମିର୍‌ ନେସ୍‌ଇଦେର୍‌, ଇକା ତୋ କାବା ମାଟା । ");
INSERT INTO kfcp_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ମାପୁରୁ ଜେ, ପାପି ଲୋକା ମାଟା ୱେନ୍‌ଏନ୍‌, ଇକା ମାପ୍‌ ନେସ୍‌ନାପ୍‌, ମାତର୍‌ ଜଦି ଏନ୍‌ ମାପୁରୁଙ୍ଗୁଁ ମାନାଜି ୱାନି ବଦାଦିଙ୍ଗ୍‍ ମାନାନାନ୍‍, ଆରିଙ୍ଗ୍‌ ୱାନ୍‌ ୱାନି ମାଟା ୱେନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ଦୁନିଆ ତିଆର୍‌ ଆତି ପୁର୍ବେରାନ୍‍ ଏନ୍‌ ଜନମ୍‍ତାନ୍‍ କାଣାଆତିୱାନିଙ୍ଗ୍‍ କାଣୁକୁ ସୁଡ଼ିନି ସାକ୍ତି ସିନି ମାଟା ଏସାଙ୍ଗ୍‍ ବା ୱେନ୍‍ଇ ମାରିଇକା । ");
INSERT INTO kfcp_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ଇୟା ଲୋକୁ ମାପୁରୁ ମାଣାନ୍‌ ରେଇତିମାରିଙ୍ଗ୍‍ ଏସାଙ୍ଗ୍‍ ଇୟା ପାଣି କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏତାନ୍‍ମାନ୍ଦି ।” ");
INSERT INTO kfcp_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ନିନ୍‍ତୋ ପୁରା ପାପ୍‌ତୁ ଜନମ୍‌ ଆଜି ପାପ୍‌ତୁ ପିରିତିମାନି, ମାରି ନିନ୍‌ ମାଙ୍ଗିଁ ସିକିୟା ସିଜିନି ?” ଆବେଟ୍‌ ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ପାର୍‌ତନା ଇଲ୍‌ତାନ୍‌ ସପ୍‍ତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ଜିହୁଦି ନେତାର୍‌ ଜେ ୱାନିଙ୍ଗ୍‌ ପାର୍‌ତନା ଇଲ୍‌ତାନ୍‌ ସପ୍‍ତାମାନାର୍‍, ଜିସୁ ଇକା ୱେନ୍‌ଞ୍ଜି ୱାନିଙ୍ଗ୍‌ ପଇଜି ଇର୍ହାନ୍‌, “ନିନ୍‌ ଇନିକା ମନୁସ୍ୟପୁତ୍ରମାନୁ ବିସ୍‌ବାସ୍‌ କିଜିନି ?” ");
INSERT INTO kfcp_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ୱାନ୍‌ ଇର୍ହାନ୍‌, “ଏ ଆଜ୍ଞା, ୱାନ୍‌ ଏନ୍‌ ଇନ୍‌ଆଁ, ଏଣ୍ତେସ୍‌ ନାନ୍ ୱାନିମାନୁ ବିସ୍‌ବାସ୍‌ କିନା ?” ");
INSERT INTO kfcp_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନିନ୍‌ ଏମେୱାନିଙ୍ଗ୍‌ ସୁଡ଼ୁତିମାନି, ମାରି ଏନ୍‌ ନି ୱାଲେ ମାଟା ଇଜିନାନ୍‌, ୱାନ୍‌ ଆକାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ଆବେଟ୍‌ ୱାନ୍‌ ଇର୍ହାନ୍‌, “ପ୍ରବୁ, ନାନ୍ ବିସ୍‌ବାସ୍‌ କିଜିନା,” ମାରି, ୱାନ୍‌ ଜିସୁଙ୍ଗୁଁ ମେଣ୍ତେଙ୍ଗ୍‍ ଗଟ୍‌କିଜି ମାଡ଼ିସ୍‌ କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ମାରି ଜିସୁ ଇର୍ହାନ୍‌, “ସୁଡ଼ୁଇ ଲୋକୁ ଏଣ୍ତେସ୍‌ ସୁଣାର୍‍ ମାରି ସୁଡ଼ୁଜିମାନି ଲୋକୁ ଏଣ୍ତେସ୍‌ କାଣା ଆନାର୍‌, ଇୟା ଲୋକା ବିସାର୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ଦୁନିଆଦୁ ୱାତାମାନା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ପାରୁସିର୍‌ ମାଣାନ୍‌ ଏମେକାର୍‌ ୱାନି ୱାଲେ ମାର୍ହାର୍‌, ୱାର୍‌ ଇକା ୱେନ୍‌ଞ୍ଜି ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ମାପ୍‌ ବା ଇନିକା କାଣାର୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ଜିସୁ ପାରୁସିରିଙ୍ଗ୍‍ ଇର୍ହାନ୍‌, “ଜଦି କାଣା ଆତିମାରିଙ୍ଗ୍‍ ମିର୍‌ ଦସ୍‍ ଆଇତିଦେର୍‍ମାନ୍ଦି । ମାତର୍‌ ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ଆଟ୍‍ସିନାପ୍‍ ଇଜି ଇର୍ହିମାନିଙ୍ଗ୍‍ ମିର୍‌ ନାଣ୍ତ ଦସ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ଜିସୁ ଇର୍ହାନ୍‌, ନାନ୍ ସତ୍‌ ସତ୍‌ ମିଙ୍ଗିଁ ଇଜିନା, ଏମେ ଲୋକୁ ସେର୍‍ଲା ସିଜି ମେଣ୍ତାସାଡ଼ାଦୁ ଡ଼ୁଗ୍‍ଏନ୍‍, ମାତର୍‌ ଆଇସାରିଦୁ ଏକ୍‌ସି ଡ଼ୁଗ୍‍ନାନ୍‍, ୱାନ୍‌ ଡଙ୍ଗାଁ ନି ଡାକୁ; ");
INSERT INTO kfcp_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ମାତର୍‌ ଏନ୍‌ ସେର୍‍ଲା ସିଜି ଡ଼ୁଗ୍‍ନାନ୍‍, ୱାନ୍‌ ମେଣ୍ତେଙ୍ଗାଁ ମାନ୍ଦାଦି ଗାଉଡ଼ୁଏନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ସେର୍‌ଲାଦୁ କାପ୍‍କିନିକାନ୍‍ ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ସେର୍‍ଲା ରେନା ସିନାନ୍‍, ୱାନ୍‌ ମେଣ୍ଡେଙ୍ଗ୍‌ ଦର୍‌ ଆସ୍‌ସି କୁକ୍‍ନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ୱାନ୍‌ ନିଜେଦି ମେଣ୍ଡେଙ୍ଗ୍‌ ୱିଜୁ ସପ୍‌ତି ୱେନ୍‌କା ୱାନିକା ଆଗ୍‌ଡ଼ି ଆଗ୍‌ଡ଼ି ଗାଉଡ଼ୁଏନ୍‍ ବୁଲାନାନ୍‌ ମାରି ମେଣ୍ତେଙ୍ଗ୍‌ୱିଜୁ ୱାନି ୱେନ୍‌କା ୱେନ୍‌କା ବୁଲାନେ, ଇରିଙ୍ଗ୍‌ ୱାକ୍‍ ୱାନି ବଲ୍ ନେସ୍‌ନେ; ");
INSERT INTO kfcp_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ମାତର୍‌ ମେଣ୍ଡେଙ୍ଗ୍‌ ନେସେଇ ଲୋକା ୱେନ୍‌କା ୱେନ୍‌କା ଏସ୍‌କାଙ୍ଗ୍‌ବା ବୁଲାଉ, ମାତର୍‌ ୱାନି ଲାକ୍‌ତୁରାନ୍‌ ଉରୁକ୍‌ସିସନେ, ଇରିଙ୍ଗ୍‌ ୱାକ୍‍ ନେସେଇ ଲୋକାଦି ବଲ୍ ନେସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‌ଉ । ");
INSERT INTO kfcp_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇୟା କାତା ୱେର୍‌ତାନ୍‌, ମାତର୍‌ ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଆମା ଆମାକା ୱେର୍‌ସି ମାର୍ହାନ୍‌, ଆୟାୱିଜୁ ଇନିକା ଇଜି ୱାର୍‌ ବୁଜାଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ଜିସୁ ମାରିଡ଼େସି ୱେର୍‌ତାନ୍‌, ସତ୍‌ ସତ୍‍ନେ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ନାନ୍ ଆଜିନା ମେଣ୍ତେଆଙ୍ଗ୍‌ ସେର୍‍ଲା । ");
INSERT INTO kfcp_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ଏମେକାର୍‌ ୱିଜେରେ ନା ଆଗ୍‌ଡ଼ି ୱାତାମାନାର୍‌, ୱାର୍‌ ୱିଜେରେ ଡଙ୍ଗାଁର୍‌ଉଁ ମାରି ଡଙ୍ଗାଁକିନିକାର୍‌, ମାତର୍‌ ମେଣ୍ଡେଙ୍ଗ୍‌ ୱିଜୁ ୱାରି ମାଟା ୱେନ୍‌ଉତେ । ");
INSERT INTO kfcp_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ନାନ୍ ସେର୍‍ଲା, ଏନ୍‌ ନା ସାରି ସିଜି ଡ଼ୁଗ୍‌ନାନ୍‌, ୱାନ୍‌ ରକିୟା ପୟ୍‌ନାନ୍‌ ମାରି ଲୋଇ ୱାଜି ମାରି ଆତେରେ ସଲ୍‌ସି ସାରାଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ଡଙ୍ଗାଁର୍‌ଏନ୍‌ ୱାନାନ୍‌ ଡଙ୍ଗାଁକିଦେଙ୍ଗ୍‌, କାତ୍‍ତେଙ୍ଗ୍‌ ମାରି ଦଂସ କିଦେଙ୍ଗ୍‌ । ନାନ୍ ୱାତାମାନା, ମିଙ୍ଗିଁ ଜିବନ୍‌ ସିଦେଙ୍ଗ୍‍, ମିର୍‌ ଏଣ୍ତେସ୍‌ ଜିବନ୍‌ତି ବିସୟ୍‌ତାନ୍‌ ୱେଡ଼ିକା ପୟ୍‌ଦେଙ୍ଗ୍‌ ଆଟ୍‌ନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","ନାନ୍ ନେଗେନ୍‌ ମେଣ୍ଡେଙ୍ଗ୍‌ ସାରାକିନିକିଦା; ନେଗେନ୍‌ ମେଣ୍ତେଙ୍ଗ୍‌ସାରାକିନିକାନ୍‌ ମେଣ୍ତେଆଙ୍ଗ୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ନିଜେଦି ଜିବନ୍‌ ସିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ଏନ୍‌ ବୁତିଅସି ମେଣ୍ତେଙ୍ଗ୍‌ମାନ୍ଦା କାପ୍‍କିନାନ୍‍, ୱାନ୍‌ ଗାଉଡ଼ୁଏନ୍‍ ଆଏନ୍‍, ବା ମାନ୍ଦାଦି ମାଲିକ୍‌ ଆଏନ୍‍, ୱାନ୍‌ ବେନ୍‍ଡ୍ର ୱାନିକା ସୁଡ଼ୁଜି ମେଣ୍ତେଆଙ୍ଗ୍‍ଁ ଡ଼ିସ୍‍ସି ସନାନ୍‌, ମାରି ବେନ୍‍ଡ୍ର ମେଣ୍ତାଦିଙ୍ଗ୍‌ ଆସ୍‍ନା ଅନାତ୍‍ ମାରି କାଣ୍ତିଆ କାବାରା କିନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ଇରିଙ୍ଗ୍‌ ଏନ୍‌ ବୁତିଅସି ମେଣ୍ତେଙ୍ଗ୍‍ କାପ୍‍କିନାନ୍‍, ୱାନ୍‌ ଉର୍‍କୁନାନ୍‍, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ବୁତିକିନିକାନ୍‍ ମାତର୍‌, ମେଣ୍ତେଆଙ୍ଗ୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ ଏତ୍‌ ସିଲେତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“ନାନ୍ ନେଗେନ୍‌ ମେଣ୍ତେଙ୍ଗ୍‌ସାରାକିନିକିଦା । ବୁବା ଏଣ୍ତେସ୍‌ ନାଙ୍ଗିଁ ନେସ୍‌ନାନ୍‌ ମାରି ନାନ୍ ବୁବେଙ୍ଗ୍‌ ନେସ୍‌ନା, ");
INSERT INTO kfcp_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ଆୟାୱାଜା ନାନ୍ ନା ନିଜେଦି ମେଣ୍ତେଆଙ୍ଗ୍‌ ନେସ୍‌ନା, ମାରି ନା ନିଜେଦି ମେଣ୍ଡେଙ୍ଗ୍‌ ନାଙ୍ଗିଁ ନେସ୍‌ନେ, ମାରି ମେଣ୍ତେଆଙ୍ଗ୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ନା ଜିବନ୍‌ ସିଦେଙ୍ଗ୍‍ ରାଜିମାନା । ");
INSERT INTO kfcp_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ଏମେ ମେଣ୍ଡେଙ୍ଗ୍‌ ଇୟା ମେଣ୍ତେଙ୍ଗ୍‌ସାଡ଼ାଦିକେଙ୍ଗ୍‌ ଆଉ, ନା ଇୟାୱାଜା ଆଇ ମେଣ୍ଡେଙ୍ଗ୍‌ ମାନେ, ୱାନିକାଙ୍ଗ୍‌ ବା ନାଙ୍ଗିଁ ତାତେଙ୍ଗ୍‌ ଆନାତ୍‌, ମାରି ୱାକ୍‍ ନା ବଲ୍ ୱେନେ; ଆବେଟ୍‌ ଉନ୍‌ଡ୍ରି ମାନ୍ଧାଦିଙ୍ଗ୍‌ ମାରି ଅରେନ୍‍ ଗୋଡ଼ୁ ଆନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“ନାନ୍ ନା ଜିବନ୍‌ ସିନିଉଣ୍ତିଙ୍ଗ୍ ବୁବା ନାଙ୍ଗିଁ ଜିବନ୍‌ନୋନାନ୍‌, ମାରି ନାନ୍ ନା ଆୟା ଜିବନ୍‌ ମାରିଡ଼େସି ପୟ୍‌ଦେଙ୍ଗ୍‌ ଆଟ୍‍ନା । ");
INSERT INTO kfcp_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ଏନ୍‌ ନାମାଣ୍‌କୁ ନା ଜିବନ୍‌ ଅତେଙ୍ଗ୍‌ ଆଟ୍‍ଏନ୍‍, ମାତର୍‌ ନା ବଦାଦାନ୍ ନା ଜିବନ୍‌ ଦାନ୍‌ କିନା । ନା ଜିବନ୍‌ ଦାନ୍‌ କିଦେଙ୍ଗ୍‌ ଅଦିକାର୍‌ ମାନାତ୍‌ ମାରି ନାନ୍ ମାରିଡ଼େସି ଜିବନ୍‌ ପୟ୍‌ଦେଙ୍ଗ୍‌ ବା ଅଦିକାର୍‌ ମାନାତ୍‌ । ଇକା କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ନା ବୁବାଦିମାଣ୍‌ନା ଇୟା ଆଦେସ୍‌ ପୟ୍‌ତାମାନା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ଇୟାୱିଜୁ ମାଟା ୱେର୍‌ଇ ୱେନ୍‌କା ଜିହୁଦି ଲୋକା ଲୋଇ ମାରିଡ଼େସି ଆଇ ମାଟା ଗଟାତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ୱାରି ଲୋଇରାନ୍‌ ଏସଲୋକ୍‌ ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, “ୱାନିଙ୍ଗ୍‌ ଦୁବା ଆସ୍‌ତାମାନାତ୍‌, ୱାନ୍‌ ବାୟା, ଏନ୍ଧା ୱାନି ମାଟା ୱେନ୍‌ଜିନିଦେର୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ଆଇକାର୍‌ ଇର୍ହାର୍‌, ଇୟାୱିଜୁ ମାଟା ତୋ ଦୁବା କାସ୍‌ତି ଅରେନ୍‍ ଲୋକୁ ଇୟାୱାଜା ମାଟା ଇନ୍‌ଏନ୍‌; ଦୁବା ଇନିକା କାଣା ଲୋକ୍‌ତି କାଣୁକୁ ତର୍‌ତେଙ୍ଗ୍‍ଁ ଆଟ୍‍ନାତ୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ନାସ୍ତିୱାଲେ ଜିରୁସାଲମ୍‌ତୁ ମନ୍ଦିର୍‌ ତିଆର୍‌ କିତି ପଣ୍ତ୍‌ୟ ଆଜିମାର୍ହାତ୍‍; ଆୟାୱାଲେ ପିନିକାଡ଼ା ମାର୍ହାତ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ମାରି ଜିସୁ ମନ୍ଦିର୍‌ତୁ ସଲମନ୍‍ତି ଗୁଡିକାଲ୍‌ତୁ ବୁଲାଜି ମାର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ଆବେଟ୍‌ ଜିହୁଦି ଲୋକୁ ଜିସୁଙ୍ଗୁଁ ସାରିବେଡ଼୍‍ତି ଉଣ୍ତାଜି ୱେନ୍‌ବାଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, ମାରି ଏସ ୱେଡ଼ାସାନ୍ଧି ମାଙ୍ଗିଁ ନାମ୍‌ଇ ୱାଜା ଇଡ୍‌ନି ? ଜଦି “ନିନୁ ମସିହ, ଆର୍‌ତିଙ୍ଗ୍‌ ମାଙ୍ଗିଁ ସତ୍‌ତାନ୍‌ ୱେର୍‌ଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ମାତର୍‌ ମିର୍‌ ବିସ୍‌ବାସ୍‌ କିଇଜିନିଦେର୍‌; ନା ବୁବାଦି ମାଣାନ୍‌ ଅଦିକାର୍‍ ନାନ୍ ପୟ୍‌ଜି ଆମା ଆମା ପାଣି କିଜିନା, ଆୟାୱିଜୁ ନା ବିସୟ୍‌ତାନ୍‌ ସାକ୍‌ୟ ସିଜିନା; ");
INSERT INTO kfcp_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ମାତର୍‌ ମିର୍‌ ବିସ୍‌ବାସ୍‌ କିଇଜିନିଦେର୍‌, ଇରିଙ୍ଗ୍‌ ମିର୍‌ ନା ମେଣ୍ଡେଙ୍ଗ୍‌ ଆଇଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ନା ମେଣ୍ଡେଙ୍ଗ୍‌ ୱିଜୁ ନା ବଲ୍ ୱେନେ ମାରି ନାନ୍ ୱାନିକାଙ୍ଗ୍‌ ନେସ୍‌ନା, ମାରି ୱାକ୍‍ ନା ୱେନ୍‌କା ୱେନ୍‌କା ବୁଲାନେ, ");
INSERT INTO kfcp_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ମାରି ନାନ୍ ୱାନିକାଙ୍ଗ୍‌ ଏସ୍‍କାଙ୍ଗ୍‍ୱିଜ୍‍ଇ ଜିବନ୍‌ ସିନା, ମାରି ୱାକ୍‍ ଏସ୍‌କାଙ୍ଗ୍‌ବା ସାଉ, ମାରି ୱାନିକାଙ୍ଗ୍‌ ନା କିୟୁଦାନ୍‌ ଏନ୍‌ ଡ଼ିବିସ୍‌କିଜ ଅତେଙ୍ଗ୍‌ ଆଟ୍‍ଏର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ନା ବୁବା ନାଙ୍ଗିଁ ଆମାକା ସିତାମାନାନ୍‌, ଆକା ୱିଜୁମାଣ୍‌କୁ ନାଣ୍ତଦାରା, ମାରି ୱାନିକାଙ୍ଗ୍‌ ବୁବାଦି କିୟୁଦାନ୍‌ ଏନ୍‌ ଆକା ଡ଼ିବିସ୍‍କିଜ ଅତେଙ୍ଗ୍‌ ଆଟ୍‍ଏନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ବୁବା ନି ନାନ୍ ଅରେନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ଇୟା ମାଟା ୱେନ୍‌ଞ୍ଜି ଜିହୁଦିଲୋକୁ ଜିସୁଙ୍ଗୁଁ ଡାକ୍‌ତେଙ୍ଗ୍‍ଁ ଇଜି ମାରି କାଲ୍‌କୁ ପେର୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ନାନ୍ ବୁବାଦିମାଣାନ୍‍ ଏସ ନେଗି ପାଣି ମିଙ୍ଗିଁ ତର୍‌ତାମାନା; ଆୟାୱିଜୁ ପାଣିଦି ଲୋଇରାନ୍‌ ଏମେ ନେଗି ପାଣିଦି ଉଣ୍ତିଙ୍ଗ୍‌ ନାଙ୍ଗିଁ ନେର୍‌ କାଲ୍‌କୁ ପୋକ୍‌ତାଜିନିଦେର୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ଜିହୁଦିଲୋକୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ନେଗି ପାଣିଦି ଉଣ୍ତିଙ୍ଗ୍‌ ମାପ୍‌ ନିଙ୍ଗିଁ କାଲ୍‌କୁ ପୋକ୍‌ତାଏଜିନାପ୍‌, ମାତର୍‌ ମାପୁରୁ ନିଦା ଉଣ୍ତିଙ୍ଗ୍‌, ମାରି ନିନ୍‌ ଲୋକୁ ଆଜି ନିଜେଦିଙ୍ଗ୍‌ ମାପୁରୁ ସାମାନ୍‍ କିଜିନି ।” ");
INSERT INTO kfcp_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମି ସାସ୍ତ୍ରଦୁ ଇକା ରାସାତାମାନାତ୍‌, ମାପୁରୁ ଇନାନ୍‌, ମିର୍‌ ମାପୁରୁଙ୍ଗୁଁ ? ");
INSERT INTO kfcp_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ଆମାୱାରି ଲାକ୍‌ତୁ ମାପୁରୁଦି ବାକ୍ୟ ଇଗା ୱାତାତ୍‍, ୱାରିଙ୍ଗ୍‌ ଜଦି ୱାନ୍‌ ମାପୁରୁ ଇଜି ଇର୍ହାନ୍‌ ମାରି ଦାର୍ମୁସାସ୍ତ୍ର ୱେର୍‌ଏ କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏର୍‍ ");
INSERT INTO kfcp_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ବୁବା ମାପୁରୁ ନାଙ୍ଗିଁ ପବିତ୍ର କିଜି ଆସ୍‍କିତାନ୍‌ନୋ ଇୟା ଦୁନିଆଦୁ ପୋକ୍‌ତାତାମାନାନ୍‌ । ଆରିଙ୍ଗ୍‌, ନାନ୍ ନିଜେଦିଙ୍ଗ୍‍ ମାପୁରୁଦି ମାରିନ୍‌ ଇନି ମାଣାନ୍‌ ମାପୁରୁଙ୍ଗ୍‌ ନିଦା କିଜିନା ଇଜି ଏଣ୍ତେସ୍‌ ଇଜିନିଦେର୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ଜଦି ନାନ୍ ବୁବାଦି ପାଣିୱିଜୁ କିଏ, ଆର୍‌ତିଙ୍ଗ୍‌ ନାଙ୍ଗିଁ ବିସ୍‌ବାସ୍‌ କିମାଟ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ମାତର୍‌ ଜଦି ନାନ୍ ୱାନି ବଦାଦାନ୍ ନାନ୍ ପାଣି କିନା, ଆରିଙ୍ଗ୍‌ ନାଙ୍ଗିଁ ବିସ୍‌ବାସ୍‌ କିଇତିଙ୍ଗ୍‌ବା, ନା ପାଣି ସୁଡ଼ୁଜି ବିସ୍‌ବାସ୍‌ କିଦୁ । ଆତିଙ୍ଗ୍‌ ମିର୍‌ ପୁରା ନେସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‌ନିଦେର୍‌, ମାରି ନା ବୁବା ନା ମାନୁ ମାନାନ୍‌ ମାରି ନାନ୍ ୱାନିମାନୁ ମାନା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ଆବେଟ୍‌ ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଆସ୍‌ତେଙ୍ଗ୍‌ ମାରିଡ଼େସି ସେସ୍ଟା କିତାର୍‌, ମାତର୍‌ ଜିସୁ ୱାରି କିୟୁଦୁ ଦାରାସିଏଣ୍ତା ସତାସର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ଆୟାୱେନ୍‌କା ଜିସୁ ମାରିଡ଼େସି ଜର୍ଦନ ଗାଡାଦି ଆୟାପାଡ଼ି ଇତାନ୍‌, ଜୋହନ ଏମେ ବାଡିଦୁ ପୁର୍ବେ ଡୁବନ୍‌ ସିଜିମାର୍ହାନ୍‌, ଆୟା ବାଡିଦୁ ୱାତାନୋ ଆବେନୁ ତେବାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ମାରି, ନାଣ୍ତଲୋକୁ ୱାନି ଲାକ୍‌ତୁ ୱାଜି ଇର୍ହାର୍‌, “ଜୋହନ ଗିଦେ କାବାଆନି ପାଣି କିଏତାନ୍‌, ମାତର୍‌ ଇୟା ଲୋକ୍‌ତି ବିସୟ୍‌ତାନ୍‌ ଜୋହନ ଆମାୱିଜୁ ମାଟା ଇର୍ହାନ୍‌, ଆୟାୱିଜୁ ସତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ମାରି, ଆବେନୁ ଗାଦି ଲୋକୁ ଜିସୁମାନୁ ବିସ୍‌ବାସ୍‌ କିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ବେତନିୟା ନାର୍‌ତି ଲାଜାର୍‌ ଦର୍‌ତିକାନ୍‌ ଅରେନ୍‍ ଲୋକୁ ନବ୍‌ ଆତାମାର୍ହାନ୍‌; ମରିୟମ୍‌ ମାରି ତାନି ତାଙ୍ଗିଁସି ମାର୍ତା ଆୟା ନାଟ ମାନ୍‌ଞ୍ଜି ମାର୍‌ଏ । ");
INSERT INTO kfcp_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ଇକାତ୍‍ ଆୟା ମରିୟମ୍‌, ଏମେକାତ୍‍ ପ୍ରବୁଦି ପାଦାମ୍‌କାଙ୍ଗ୍‌ ନିୟୁ ୱାକ୍‍ସି ନିଜେଦି କୁକୁଟିଦାନ୍‌ ୱାନି ପାଦାମ୍‌କୁ ତେଲିତାମାର୍ହାତ୍‍, ତାନି ତଡ଼ାସି ଲାଜାର୍‌ ନବ୍‌ ଆତାମାର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ଆଦେଙ୍ଗ୍‌ ଆୟା ତାଙ୍ଗିଁକ୍‍ ଜିସୁଦି ଲାକ୍‌ତୁ କାବୁର୍ ପକ୍‍ତେ, “ପ୍ରବୁ ସୁଡ଼ୁଆ, ଆମାୱାନିଙ୍ଗ୍‌ ନିନ୍‌ ଜିବନ୍‍ନୋନି, ନି ସଙ୍ଗ୍‍, ୱାନ୍‌ ନବ୍‌ ଆତାମାନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ମାତର୍‌ ଜିସୁ ଆକା ୱେନ୍‌ଜି ଇର୍ହାନ୍‌, “ଇୟା ନବ୍‌ ସାନି ଉଣ୍ତିଙ୍ଗ୍‌ ସିଲେ, ମାତର୍‌ ମାପୁରୁଦି ଦନ୍ୟବାଦ୍‌ତି ଉଣ୍ତିଙ୍ଗ୍‌, ଏଣ୍ତେସ୍‌ ଆୟାବାଣାନ୍‍ ମାପୁରୁଦି ମାରିନ୍‌ ବା ଦନ୍ୟବାଦ୍‌ ପଇନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ଜିସୁ ମାର୍ତା, ୱାନି ତାଙ୍ଗିଁ ମରିୟମ୍‌ ନି ଲାଜାର୍‌ତିଙ୍ଗ୍‌ ଜିବନ୍‌ ନଜି ମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ମାରି, ଲାଜାର୍‌ ନବ୍‌ ଆତାମାନାନ୍‌ ଇଜି ଏସ୍ତିୱାଲେ ୱାନ୍‌ ୱେର୍‌ଆନ୍‌, ନାସ୍ତିୱାଲେ ୱାନ୍‌ ଏମେ ବାଡିଦୁ ମାର୍ହାନ୍‍, ଆୟାବାଡିଦୁ ମାରି ରିନେନ୍‍ ତେବାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ତାନିୱେନ୍‍କା ୱାନ୍‌ ସିସୁରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ସାଦୁ, ମାଡ୍‌ ଜିହୁଦା ରାଜିଦୁ ଡ଼େସି ସନାଟ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ସିସୁର୍‍ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାର୍‌, “ଏ ଗୁରୁ, ଜିହୁଦିର୍ ଏସ ଦିନ୍‍ ଆଗ୍‌ଡ଼ି ନିଙ୍ଗିଁ କାଲ୍‍କାଣ୍‍ ଡାକ୍‌ତେଙ୍ଗ୍‍ଁ ବଦା କିଜିମାର୍ହାର୍‍, ମାରି ନିନ୍‌ ମାରିଡ଼େସି ଆବେ ସଲ୍‌ସିନି ?” ");
INSERT INTO kfcp_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ଜିସୁ ଇର୍ହାନ୍‌, “ୱେଡ଼େ ଇନିକା ବାର ଗନ୍‍ଟା ସିଲେତ୍‌ ? ଏନ୍‌ ୱେଡ଼େ ବୁଲାତିଙ୍ଗ୍‍ ତାକାଏନ୍‍, ଇରିଙ୍ଗ୍‌ ୱାର୍‌ ଇୟା ଦୁନିଆଦି ଜାୟ୍‌ ସୁଣାନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ମାତର୍‌ ନାଡ଼ା ବୁଲାତିଙ୍ଗ୍‍ ୱାନ୍‌ ତାକାନାନ୍‍, ଇରିଙ୍ଗ୍‌ ୱାରିମାନୁ ଜାୟ୍‌ ସିଲେତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ଜିସୁ ଇୟାୱିଜୁ ମାଟା ଇର୍‍ଇ ୱେନ୍‌କା ୱାରିଙ୍ଗ୍‌ ମାରି ଇର୍ହାନ୍‌, ମା ତଡ଼୍‍ ଲାଜାର୍‌ ସୁଜ୍‍ଜିନାନ୍‍, ମାତର୍‌ ୱାନିଙ୍ଗ୍‌ ସୁସ୍‍କାଣ୍‍କାଣ୍‍ ନିକ୍‍ତେଙ୍ଗ୍‍ ଇଜି ନାନ୍ ସଲ୍‍ସିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ଆବେଟ୍‌ ସିସୁର୍‍ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାର୍‌, “ପ୍ରବୁ, ଜଦି ଲାଜାର୍‌ ସୁସ୍‍ତାମାନାନ୍‍, ଆରିଙ୍ଗ୍‌ ୱାନ୍‌ ନେଗେନ୍‍ ଆନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ଜିସୁ ଲାଜାର୍‌ତି ସାନି ବିସୟ୍‌ତାନ୍‌ ଇର୍ହାନ୍‌, ମାତର୍‌ ୱାନ୍‌ ସୁସ୍‍କାଣ୍‍କାଙ୍ଗ୍‍ ସୁସ୍‌ତି ବିସୟ୍‌ତାନ୍‌ ଇର୍ହାନ୍‌ ଇଜି ସିସୁର୍‍ ଅଡ଼୍‍ବିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ମାରି, ଜିସୁ ନାସ୍ତିୱାଲେ ୱାରିଙ୍ଗ୍‌ ବୁଜାନିୱାଜା ଇର୍ହାନ୍‌, “ଲାଜାର୍‌ ସାତାମାନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ମାରି, ନାନ୍ ଜେ ଆୟାବାଡିଦୁ ସିଲେତା, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ମି ଉଣ୍ତିଙ୍ଗ୍‌ ୱେଡ଼ିକା ଆଜିନା, ଏଣ୍ତେସ୍‌ ମିର୍‌ ବିସ୍‌ବାସ୍‌ କିନିଦେର୍‍; ମାତର୍‌ ସାଦୁ, ମାଡ୍‌ ୱାନିଙ୍ଗ୍‌ ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ସନାଟ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ଆବେଟ୍‌ ତୋମା ଆମାୱାନିଙ୍ଗ୍‌ ଦିଦୁମ ଇଜି ଇନାର୍‌, ୱାନ୍‌ ୱାନି ତଡ଼୍‍ ସିସୁରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ସାଦୁ, ମାଡ୍‌ ବା ଗୁରୁୱାଲେ ସଲ୍‌ସି ୱାନିୱାଲେ ସାନାଟ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ଜିସୁ ବେତନିଆଦୁ ଇତାନ୍‍ନୋ ୱେର୍‌ଆନ୍‌ ଜେ, ଲାଜାର୍‌ ନାଲ୍‍ନେନ୍‍ ଆତାତ୍‌ ଦୁକି ଗୁଟାଦୁ ମୁସ୍‍ତାର୍‍ନି । ");
INSERT INTO kfcp_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ବେତନିୟା ଜିରୁସାଲାମ୍‌ ଲାକ୍‌ତୁ ମାର୍ହାତ୍‌, ମୁନ୍‌ଡ୍ରି କିଲମିଟର୍‍ତାନ୍‍ ଉଣା; ");
INSERT INTO kfcp_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ମାରି, ଜିହୁଦିର୍‌ ମାଣୁକୁ ନାଣ୍ତ ଲୋକୁ ମାର୍ତା ନି ମରିୟମ୍‌ତିଙ୍ଗ୍‍ ତାନି ତଡ଼ାନ୍‍ ସାତି ବିସୟ୍‌ତାନ୍‌ ସୁକୁ ସିଦେଙ୍ଗ୍‍ ଇଜି ତାମେ ଲାକ୍‌ତୁ ୱାତାମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ଆବେଟ୍‌ ଜିସୁ ୱାଜିନାନ୍‍ ଇଜି ଏସ୍ତିୱାଲେ ମାର୍ତା ୱେର୍‍ଆତ୍‍, ନାସ୍ତିୱାଲେ ୱାଦ୍‌ ଜିସୁଙ୍ଗୁଁ ବେଟ୍‍ବୁଡ଼ାଦେଙ୍ଗ୍‍ ସର୍ହାତ୍‍, ମାତର୍‌ ମରିୟମ୍‌ ଇନ୍‌ଡ୍ର ବାସ୍‍ତା ତେବାତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ମାର୍ତା ଜିସୁଙ୍ଗୁଁ ଇର୍ହାତ୍‌, “ପ୍ରବୁ, ଜଦି ନିନ୍‌ ଇବେ ମାର୍‍ଇମାନ୍ଦି, ଆତିଙ୍ଗ୍‌ ନା ତଡ଼ାନ୍‌ ସାଏତାନ୍‍ମାନ୍ଦି । ");
INSERT INTO kfcp_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ମାତର୍‌ ଇଲେଇବା ନାନ୍ ନେସ୍‌ନା, ନିନ୍‌ ମାପୁରୁଙ୍ଗୁଁ ଆମାକା ଲସ୍‌ନି, ମାପୁରୁ ଜେ ଆକା ନିଙ୍ଗିଁ ସିନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ଜିସୁ ତାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନି ତଡ଼ାନ୍‌ ଜିବନ୍‌ ପୟ୍‌ଜି ନିଙ୍ଗିଁନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ମାର୍ତା ଜିସୁଙ୍ଗୁଁ ଇର୍ହାତ୍‌, “ୱାନ୍‌ ଜେ ୱିଜ୍‍ନି ଦିନ୍‍ତୁ ମାରିଡ଼େସି ନିଙ୍ଗିଁନି ୱାଲେ ନିଙ୍ଗିଁନାନ୍‍, ଇକା ନାନ୍ ନେସ୍‌ନା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ଜିସୁ ତାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନାନ୍ ମାରିଜିନିକାନ୍‍ ମାରି ଜିବନ୍‌; ଏନ୍‌ ନାବାନ୍‍ ବିସ୍‌ବାସ୍‌ କିନାନ୍‌, ୱାନ୍‌ ଜଦିବା ସାନାନ୍‌, ମାତର୍‌ ୱାନ୍‌ ମାରିଡ଼େସି ଜିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ମାରି ଏନ୍‌ ଜିନାନ୍‍ ମାରି ନାବାନ୍‍ ବିସ୍‌ବାସ୍‌ କିନାନ୍‌, ୱାନ୍‌ ଏସାଙ୍ଗ୍‌ବା ସାଏନ୍‌; ଇକା ଇନିକା ବିସ୍‌ବାସ୍‌ କିଜିନି ?” ");
INSERT INTO kfcp_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ମାର୍ତା ଜିସୁଙ୍ଗୁଁ ଇର୍ହାତ୍‌, “ହୁଁ ପ୍ରବୁ, ଆମାୱାନିଦି ଦୁନିଆଦୁ ୱାନିକା ମାର୍ହାତ୍‍, ନିନ୍‌ ଜେ ମାପୁରୁଦି ମାରିନ୍‌ ଆୟା ମସିହ, ଇକା ନା ବିସ୍‌ବାସ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ଇକା ଇର୍‍ଇ ୱେନ୍‌କା ମାର୍ତା ସଲ୍‌ସି ତାନି ତାଙ୍ଗିଁ ମରିୟମ୍‌ତିଙ୍ଗ୍‍ ନେସ୍‌ଇୱାଜା କୁକ୍‌ସି ଇର୍ହାତ୍‌, “ଗୁରୁ ୱାତାନ୍‍ନି ମାରି ନିଙ୍ଗିଁ କୁକ୍‍ସିନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ମରିୟମ୍‌ ଇକା ୱେନ୍‌ଜି ବେଗି ନିଙ୍ଗିଁଜି ଜିସୁ ଲାକ୍‌ତୁ ସର୍ହାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ଜିସୁ ନାସ୍ତିୱାଲେ ନାର୍‍ ଲୋଇ ରେଏନ୍‌ ମାର୍ହାନ୍‍, ମାତର୍‌ ମାର୍ତା ୱାନିଙ୍ଗ୍‌ ଏମେ ବାଡିଦୁ ବେଟ୍‍ବୁଡ଼ାତା ମାର୍ହାତ୍‌, ଆୟା ସାନ୍ଦି ୱାନ୍‌ ଆୟା ବାଡିଦୁ ମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ମାରି, ଏମେ ଜିହୁଦିର୍‌ ୱାନିୱାଲେ ଇନ୍‌ଡ୍ର ମାନ୍‌ଜି ମରିୟମ୍‌ତିଙ୍ଗ୍‍ ସୁକୁ ସିଜିମାର୍ହାର୍‍, ୱାର୍‌ ମରିୟମ୍‍ତିଙ୍ଗ୍‍ ବେଗି ନିଙ୍ଗ୍‍ଜି ସହସି ସନିକା ସୁଡ଼ୁଜି, ୱାଦ୍‌ ଦୁକି ଲାକ୍‌ତୁ ଆଡ଼୍‍ବାଦେଙ୍ଗ୍‍ ଇଜି ସଲ୍‍ସିନାତ୍‍, ଇକା ଅଡ଼୍‍ବିଜି ତାନି ୱେନ୍‌କା ୱେନ୍‌କା ସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ଆବେଟ୍‌ ଜିସୁ ଏମେ ବାଡିଦୁ ମାର୍ହାନ୍‍, ମରିୟମ୍‌ ଆୟା ବାଡିଦୁ ଇଗା ସଲ୍‌ସି ୱାନିଙ୍ଗ୍‌ ସୁଡ଼ୁଜି ୱାନି କାଲ୍‍କା ଆଡ୍‍ଗି ମାଡ଼ିସ୍‌ କିଜି ଇର୍ହାତ୍‌, “ପ୍ରବୁ, ଜଦି ନିନ୍‌ ଇବେ ଇଗା ୱାତିମାନ୍ଦି, ଆତିଙ୍ଗ୍‌ ନା ତଡ଼ାନ୍‌ ସାଏତାନ୍‍ମାନ୍ଦି ।” ");
INSERT INTO kfcp_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ମାରି, ଜିସୁ ତାନିଙ୍ଗ୍‌ ମାରି ତାନି ୱାଲେ ୱାତିମାନି ଜିହୁଦିରିଙ୍ଗ୍‍ଁ ଆଡ଼୍‍ବାନିକା ସୁଡ଼ୁଜି ଆତ୍ମାତୁ ଆଡ଼୍‍ବାଜି, ମାରି ପାଣି ପୁରା କିଦେଙ୍ଗ୍‌ ଇଜି ନାଣ୍ତ ବଦାଦାନ୍ ୱେନ୍‌ବାତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ୱାନିଙ୍ଗ୍‌ ଏମେ ଇଟ୍‍ଟି ମାନିଦେର୍‌ ? ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ପ୍ରବୁ, ୱାଜି ସୁଡ଼ୁଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ଜିସୁ ଆଡ଼୍‍ବାତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ଆବେଟ୍‌ ଜିହୁଦିର୍ ଇର୍ହାର୍‌, ସୁଡ଼ୁଦୁ, ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ଏଣ୍ତେସ୍‌ ଜିବନ୍‌ନୋଜି ମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ମାତର୍‌ ୱାରି ଲୋଇ ଏନ୍‌ ଏନ୍‌ ଇର୍ହାର୍‌, “ଇୟା ଏମେକାନ୍‍ ଆୟା କାଣାଦି କାଣୁକୁ ସୁଡ଼ିସ୍‍ କିଏନ୍‌ ମାର୍ହାନ୍‍ ନୋ ? ୱାନ୍‌ ଇନିକା ଲାଜାର୍‌ତି ସାନିତାନେଙ୍ଗ୍‍ ବା ତେବାକିଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏତାନ୍‍ମାନ୍ଦି ?” ");
INSERT INTO kfcp_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ଆବେଟ୍‌ ଜିସୁ ମାରିଡ଼େସି ଆତ୍ମାଦୁ ଆଡ଼୍‍ବାଜି ଦୁକିଗୁଟା ଲାକ୍‌ତୁ ୱାତାନ୍‌; ଆକା ଉଣ୍ତ୍ରି ସାର୍‍ରା, ମାରି ତାନି ଦୁଆର୍‍ ଆଗ୍‌ଡ଼ି ଉଣ୍ତ୍ରି କାଲୁ ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ଜିସୁ ଆଦେସ୍‌ ସିତାନ୍‌, “ଇୟା କାଲୁ ଗୁସାକିଦୁ ।” ସାତି ଲୋକ୍‌ତି ତାଙ୍ଗିଁସି ମାର୍ତା ଜିସୁଙ୍ଗୁଁ ଇର୍ହାତ୍‌, “ପ୍ରବୁ, ୱାନ୍‌ କାପୁ ଆଜିମାନାନ୍‍, ଇରିଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ ମୁସ୍‌ତାର୍‌ ନାଲ୍‍ନେନ୍‍ ଆତାନ୍‍ନି ।” ");
INSERT INTO kfcp_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ଜିସୁ ତାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଜଦି ନିନ୍‌ ବିସ୍‌ବାସ୍‌ କିନି, ଆରିଙ୍ଗ୍‌ ମାପୁରୁଦି ମହିମା ସୁଣି, ଇକା ଇନିକା ନାନ୍ ନିଙ୍ଗିଁ ଇନ୍‍ଏତା ?” ");
INSERT INTO kfcp_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ଆବେଟ୍‌ ୱାର୍‌ କାଲୁ ଗୁସାକିତାର୍‍ । ମାରି, ଜିସୁ ମୁସ୍‌କୁ ସୁଡ଼ୁଜି ଇର୍ହାନ୍‌, “ବୁବା, ନିନ୍‌ ନା ପାର୍‌ତନା ୱେର୍‌ଇ ଇଜି ନାନ୍ ନିଙ୍ଗିଁ ଦନ୍ୟବାଦ୍‌ ସିଜିନା । ");
INSERT INTO kfcp_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ନିନ୍‌ ଜେ ୱିଜୁୱାଲେ ନା ପାର୍‌ତନା ୱେନ୍‍ଜମାନି, ଇକା ନାନ୍ ନେସ୍‌ତାମାନା; ମାତର୍‌ ଏମେ ଲୋକୁ ୱିଜେରେ ସାରିବେଡ଼୍‍ତି ନିର୍ହାମାନାର୍‍, ନିନ୍‌ ନାଙ୍ଗିଁ ପକ୍‍ତିମାନି ଇଜି ୱାର୍‌ ଏଣ୍ତେସ୍‌ ବିସ୍‌ବାସ୍‌ କିନାର୍‌, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ଇକା ଇର୍‌ଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ୱାନ୍‌ ଇକା ଇଜି ନାଣ୍ତ ଆଉଲି ଆଜି କୁକ୍‍ତାନ୍‍, “ଲାଜାର୍‌ ସହସ ରାଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ୱାନ୍‌ ସତାୱାତାନ୍‍; ୱାନି କିୟୁ ନି ପାଦାମ୍‌ ଦୁକିଦି ପାଗେଣାନ୍‍ ତର୍‍ତାମାର୍ହାର୍‍, ମାରି ୱାନି ମକମି ଉଣ୍ତ୍ରି ପାସିଆ କେର୍‍ପ୍‍ତା ମାର୍ହାର୍‌ । ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ୱେନି ଗାଟି କୁତ୍‍ସି ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ସାରି ସିଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ମାରି, ଜିହୁଦିର୍‌ ମାଣ୍‌କୁ ନାଣ୍ତ ଅର୍ତାତ୍‍ ଏମେକାର୍‌ ମରିୟମ୍‌ ଲାକ୍‌ତୁ ୱାତାମାର୍ହାର୍‍ ମାରି ଜିସୁଦି ପାଣି ସୁଡ଼ୁଜି, ୱାର୍‌ ୱାନିମାନୁ ବିସ୍‌ବାସ୍‌ କିତାର୍‍; ");
INSERT INTO kfcp_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ମାତର୍‌, ୱାରି ମାଣାନ୍‌ ଏନ୍‌ ଏନ୍‌ ପାରୁସିର୍‌ ଲାକ୍‌ତୁ ସଲ୍‌ସି, ଜିସୁ ଆମାକା ଆମାକା କିତାମାର୍ହାନ୍‌, ଆୟାୱିଜୁ ୱାରିଙ୍ଗ୍‌ ୱେର୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ଆବେଟ୍‌ ପେରି ଜାଜକର୍‌ ନି ପାରୁସିର୍‌ ପେରିମିଟିଙ୍ଗ୍‌ କିଜି ଇର୍ହାର୍‌, “ମାଡ୍‌ ଇନିକା କିନିକା ? ଇୟା ଲୋକୁ ତୋ ନାଣ୍ତ କାବାଆନି ପାଣି କିଜିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ଜଦି ମାଡ୍‌ ୱାନିଙ୍ଗ୍‌ ଇୟାୱାଜା ଡ଼ିସ୍‍ନାସିନାଟ୍‍, ଆରିଙ୍ଗ୍‌ ୱିଜେରେ ୱାନିମାନୁ ବିସ୍‌ବାସ୍‌ କିନାର୍‌, ମାରି ରମିୟଅଦିକାରି ଲୋକୁ ୱାଜି ମା ମନ୍ଦିର୍‌ ନି ଜାତିଦି ୱିଜେରିଙ୍ଗ୍‍ ନାସ୍ଟୁ କିନାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ମାତର୍‌ ୱାରିମାଣ୍‌କୁ ଆୟା ବାର୍‍ସେକ୍‍ତି ଉଣ୍ତିଙ୍ଗ୍‌ ଆସ୍‍କିଆଇଆତିମାନି ୱିଜେରିଙ୍ଗ୍‌ପେରି ଜାଜକ କୟାପା ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମିର୍‌ ଇନିକା କାବାର୍‍ !” ");
INSERT INTO kfcp_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ମିର୍‌ ଇନିକା ବୁଜାଦେଙ୍ଗ୍‌ ଆଟ୍‍ଇଜିନିଦେର୍‍, ୱିଜୁ ଜାତି ନାସ୍ଟୁ ଆନି ବାଦ୍‌ଲୁ ଅରେନ୍‍ ଲୋକୁ ସାନିକା ଟିକ୍‍ମାନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","କୟାପା ନିଜେଦି ମନ୍‍ତାନ୍‍ ଇକା ଇନ୍‌ଏନ୍‌ ମାର୍ହାନ୍‍, ମାତର୍‌ ୱାନ୍‌ ଆୟା ବାର୍‍ସେକ୍‍ତି ୱିଜେରିଙ୍ଗ୍‌ପେରି ଜାଜକ ମାର୍ହାନ୍‍ଆକା ଇୟା ବବିସତ୍‍ତି ମାଟା ୱାନି ୱେୟୁଦାନ୍‌ ସତାମାର୍ହାତ୍‍ । ଜିସୁ ୱେର୍‍ତା ମାର୍ହାନ୍‍ ଜେ ୱିଜୁ ଜିହୁଦି ଲୋକାଦି, ");
INSERT INTO kfcp_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ଇନ୍‍ଙ୍ଗାଁ ଆନିଙ୍ଗାଁ ଆତିମାନି ମାପୁରୁଦି ଲୋକାଙ୍ଗ୍‌ ଉଣ୍ତ୍ରେ କୁଟୁମ୍‍ତୁ ଉଣ୍ତାକିନି ଉଣ୍ତିଙ୍ଗ୍‌ ଜିସୁ ସାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ଆବେଟ୍‌ ଆୟା ନାଣ୍ତିରାନ୍‍ ଜିହୁଦି ନେତାର୍‌ ଜିସୁଙ୍ଗୁଁ ସାୟାମାର୍‍ଗାଡାକ୍‍ତେଙ୍ଗ୍‍ ଇଜି ଉପାୟ୍‌ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ମାରି, ଜିସୁ ଜିହୁଦିର୍‌ ମାନୁ ମାରି ତରାୟ୍‍ଆଜି ବୁଲାସାଲା କିଏତାନ୍‌, ମାତର୍‌ ୱାନ୍‌ ଆୟାବାଡିଦାନ୍‍ ସହସି ସଲ୍‌ସି ସୁନ୍‌ସାନ୍‌ ରାଜିଦି ଏପ୍ରୟିମ୍‍ ଦର୍‌ତି ଉଣ୍ତ୍ରି ଗାଡ଼୍‌ତୁ ସର୍ହାନ୍‍, ମାରି ୱାନ୍‌ ସିସୁରିୱାଲେ ଆବେ ତେବାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ଜିହୁଦିର୍‌ ନିସ୍ତାର ପଣ୍ତୟ୍‌ ଲାକ୍‌ତୁ ମାର୍ହାତ୍‌, ମାରି ରାଜିଦାନ୍‍ ନାଣ୍ତ ଲୋକୁ ନିଜେ ନିଜେଦିଙ୍ଗ୍‍ ନେଗେଣ୍ତ୍‍ କିଦେଙ୍ଗ୍‌ ଇଜି ନିସ୍ତାର୍‍ ପଣ୍ତୟ୍‌ ଆଗ୍‍ଡ଼ିରାନ୍‍ନେ ଜିରୁସାଲାମ୍‍ତୁ ସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ଆବେଟ୍‌ ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ପୟ୍‍ବୁ ପୟ୍‍ବୁ ମନ୍ଦିର୍‌ତୁ ନିର୍‍ଇ ମାର୍‍ଇୱାଲେ ୱାର୍‍ୱାର୍‍ ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, ମିର୍‌ ଇନିକା ଅଡ଼୍‍ବିଜିନିଦେର୍‍ ? ୱାନ୍‌ ପଣ୍ତୟ୍‌ତୁ ୱାନାନ୍‌ ନୋ ରେଏନ୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ପେରି ଜାଜକର୍‌ ନି ପାରୁସିର୍‌ ଆଦେସ୍‌ ସିତାମାର୍ହାର୍‍ ଜେ ଜଦି ଏନ୍‌ ଜିସୁ ଏମେମାନୁ ମାନାନ୍‌ ଇଜି ନେସ୍‍ନାମାନାନ୍‍, ଆରିଙ୍ଗ୍‌ ଇୟା କାବୁର୍‌ ଦାପ୍ରେ ନେତାରିଙ୍ଗ୍‌ ୱେର୍‌ନା ସିନାର୍‍ । ଆତିଙ୍ଗ୍‌ ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ଆସ୍‌ନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ଇୟା ୱେନ୍‌କା ଜିସୁ ନିସ୍ତାର୍‌ ପଣ୍ତୟ୍‌ତି ସଅ ଦିନ୍‌ ଆଗ୍‌ଡ଼ି ବେତନିୟାଦୁ ସର୍ହାନ୍‍; ଏମେ ଲାଜାର୍‌ତିଙ୍ଗ୍‌ ୱାନ୍‌ ସାତିମାଣ୍‌କୁ ନିକ୍‍ତା ମାର୍ହାନ୍‍, ଆବେନୁ ୱାନି ଇଲୁ ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ଆବେଟ୍‌ ୱାର୍‌ ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ଆୟା ବାଡିଦୁ ଉଣ୍ତ୍ରି ନାଡ଼ା ବଜି ତିଆର୍‌ କିତାର୍‍; ମାର୍ତା ସେବା କିଜିମାର୍ହାତ୍‍, ମାରି ଏମେକାର୍‌ ୱାନିୱାଲେ ବଜିଦୁ ବାସ୍‍ତାମାର୍ହାର୍‍, ଲାଜାର୍‌ ୱାରି ଲୋଇ ଅରେନ୍‍ ମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ନାସ୍ତିୱାଲେ ମରିୟମ୍‌ ଅଦାକାୟା ନାଣ୍ତ ନେଗି ଦାରାଦି ବାସ୍‌ନା ମାରାତାନ୍‌ ତିଆର୍‌ ଆତି ନିୟୁ ଅସି ଜିସୁଦି ପାଦାମ୍‍ତୁ ଆକା ୱାକ୍‍ସି ନିଜେଦି କୁକୁଟିଦାନ୍ ୱାନି ପାଦାମ୍‌କୁ ତେଲ୍‍ତାସିତାତ୍‍, ମାରି ନିୟୁଦି ବାସ୍‍ନାଦାନ୍‍ ଇଲୁ ଗାମ୍‍ରିସ୍‍ତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ମାତର୍‌ ଜିସୁଦି ସିସୁର୍‍ ଲୋଇ ଇସ୍କାରିୟୋତିୟ ଜିହୁଦା ଦର୍‌ତି ଏମେ ସିସୁ ୱାନିଙ୍ଗ୍‌ ସାତ୍ରୁରି କିୟୁଦୁ ସେର୍‍ପ୍‍ତେଙ୍ଗ୍‍ ସଲ୍‍ସିମାର୍ହାନ୍‍, ୱାନ୍‌ ଇର୍ହାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","ଇୟା ନିୟୁ ତିନିସ ୱେଣ୍ତି ଡାବୁଙ୍ଗାଁଙ୍ଗ୍‍ ପର୍‌ଜି ଏନ୍ଦା କାକୁର୍ତି ଲୋକାଙ୍ଗ୍‌ ସିଏତାର୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ୱାନ୍‌ ଜେ କାକୁର୍ତି ଲୋକାଙ୍ଗ୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ସିନ୍ତା କିଜିମାର୍ହାନ୍‍ ଇଜି ଇକା ଇର୍ହାନ୍‌, ଆକା ସିଲେ, ମାତର୍‌ ୱାନ୍‌ ଅରେନ୍‍ ଡଙ୍ଗାଁର୍‍ଏନ୍, ମାରି ୱାନି ଲାକ୍‌ତୁ ଡାବୁଙ୍ଗୁଁ ମଣି ମାର୍ହାତ୍‍ଆକା, ଆବେନ୍‌ ଆମା ଆମାକା ଇଡ୍‌ଜି ମାର୍ହାର୍‌, ଆକା ୱାନ୍‌ ଡଙ୍ଗାଁକିଜି ଅସିମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ମାତର୍‌ ଜିସୁ ଇର୍ହାନ୍‌, “ତେନିଙ୍ଗ୍‍ ଡ଼ିସ୍‌ସୋ ସିଦୁ, ତାନେଙ୍ଗ୍‌ ଆମାକା ମାନାତ୍‌, ନା ମାଡ଼ାଦିଙ୍ଗ୍‍ ମୁସ୍‍ନି ନାଣ୍ତିରି ଉଣ୍ତିଙ୍ଗ୍‌ ୱାଦ୍‌ ଇକା ଇଡ୍‌ଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","କାକୁର୍ତି ଲୋକ୍‌ ତୋ ୱିଜୁଦିନ୍‌ ମି ଲାକ୍‌ତୁ ମାନାର୍‌, ମାତର୍‌ ନାନ୍ ୱିଜୁଦିନ୍‌ ମି ଲାକ୍‌ତୁ ତେବାଏ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ନାସ୍ତିୱାଲେ ନାଣ୍ତ ଜିହୁଦି ଲୋକୁ ଜିସୁ ବେତନିଆଦୁ ମାନାନ୍‌ ଇଜି ନେସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‍ସି ଆବ୍‍କା ଜିସୁଦି ଉଣ୍ତିଙ୍ଗ୍‌ ସିଲେ, ମାତର୍‌ ଏମେ ଲାଜାର୍‌ତିଙ୍ଗ୍‌ ୱାନ୍‌ ସାତିମାଣାନ୍‌ ନିକ୍‍ତାମାର୍ହାନ୍‍, ୱାନିଙ୍ଗ୍‌ ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ବା ୱାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ମାତର୍‌ ଲାଜାର୍‌ତିଙ୍ଗ୍‌ ବା ଡାକ୍‌ତେଙ୍ଗ୍‍ଁ ଇଜି ପେରି ଜାଜକର୍‌ ଉପାୟ୍‌ କିତାର୍‍, ");
INSERT INTO kfcp_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ଇରିଙ୍ଗ୍‌ ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ଜିହୁଦିର୍‌ ଲୋଇ ନାଣ୍ତ ଲୋକୁ ୱାରିଙ୍ଗ୍‌ ଡ଼ିସ୍‍ସିମାର୍ହାର୍‍ ମାରି ଜିସୁମାନୁ ସଲ୍‌ସି ବିସ୍‌ବାସ୍‌ କିଜିମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ମାର୍‍ନାଣ୍ଡିଙ୍ଗ୍ ନିସ୍ତାର୍‍ ପଣ୍ତୟ୍‌ତୁ ୱାତିମାର୍‌ଇ ନାଣ୍ତ ଲୋକୁ ଜିସୁ ଜିରୁସାଲାମ୍‍ତୁ ୱାଜିନାନ୍‍ ଇଜି ୱେର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାର୍‌ କାଜିରି କମେଙ୍ଗ୍‌ ଆସ୍‌ସି ୱାନିଙ୍ଗ୍‌ ବେଟ୍‌ଆଦେଙ୍ଗ୍‍ ଇଜି ସତାସର୍ହାର୍‌ ମାରି ନାଣ୍ତ ଆଉଲି ଆଜି ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, ହୋଶାନା । ପ୍ରବୁଦି ଦର୍‌ତାନ୍‌ ଏନ୍‌ ୱାଜିନାନ୍‍, ୱାନ୍‌ ଦନ୍ୟ; ଦନ୍ୟ ଇସ୍ରାଏଲ୍‌ତି ରାଜା । ");
INSERT INTO kfcp_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ମାରି, ଜିସୁ ଉଣ୍ତ୍ରି ଗଦପିଲା ମୁସ୍‌କୁ ବାସ୍‍ତା ୱାତାନ୍‌, ଏଣ୍ତେସ୍‌ ଇକା ଦାର୍ମୁ ସାସ୍ତ୍ରଦୁ ରାସାତାମାନାତ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","ଏ ସିୟୋନ୍‍ତି ଆଇଲିକ୍‌, “ତିଲାମା; ସୁଡୁଆ, ନି ରାଜା ୱାଜିନାନ୍‍, ୱାନ୍‌ ଗଦପିଲା ମୁସ୍‌କୁ ବାସ୍‌ତାନ୍‌ନୋ ୱାଜିନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ୱାନି ସିସୁର୍‍ ପାର୍‌ତୁମ୍‍ତୁ ଇୟାୱିଜୁ ବିସୟ୍‌ ବୁଜାଏତାର୍‌, ମାତର୍‌ ଜିସୁ ଦନ୍ୟବାଦ୍‌ ପୟ୍‌ତି ୱେନ୍‌କା ଇୟାୱିଜୁ ଜେ ୱାନି ବିସୟ୍‌ତାନ୍‌ ଦାର୍ମୁସାସ୍ତ୍ରଦୁ ରାସାତାମାର୍ହାତ୍‍, ମାରି ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ୱାର୍‌ ଜେ ଇୟାୱିଜୁ କିତାମାର୍ହାର୍‍, ଆକା ୱାର୍‌ ଏତ୍‌ କିତାର୍ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ମାରି, ଜିସୁ ଲାଜାର୍‌ତିଙ୍ଗ୍‌ ଦୁକିଦାନ୍‍ କୁକ୍‌ସି ସାତିମାଣାନ୍‌ ନିକ୍‍ତିୱାଲେ ଆମା ଲୋକ୍‌ଡର୍‌ ୱାନିୱାଲେ ମାର୍ହାର୍‌, ୱାର୍‌ ଆୟା ଗଟନା ବିସୟ୍‌ତାନ୍‌ ସାକି ସିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ବା ଲୋକୁ ୱିଜେରେ ୱାନିଙ୍ଗ୍‌ ମିସାଦେଙ୍ଗ୍‍ ସର୍ହାମାର୍ହାର୍‍, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ଇୟା କାବାଆନି ପାଣି କିତାମାନାନ୍‍ ଇଜି ୱାର୍‌ ୱେର୍‍ଆମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ଆବେଟ୍‌ ପାରୁସିର୍‌ ତାମେ ତାମେମାନୁ ୱାର୍‌ଗିଜି ସାତାର୍‌, “ସୁଡ଼ୁଜିନିଦେର୍‍ ତୋ, ମାଡ୍‌ ଇନିକା କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ଇଜିନିକା; ସୁଡ଼ୁଦୁ, ଦୁନିଆୱିଜୁ ତାନି ୱେନ୍‌କା ସର୍ହାତ୍‍ନି ।” ");
INSERT INTO kfcp_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ପଣ୍ତୟ୍‌ ସମୟ୍‍ତୁ ଉପାସନା କିଦେଙ୍ଗ୍‌ ଇଜି ଜିରୁସାଲାମ୍‍ତୁ ୱାତି ମାର୍‍ଇ ଲୋକା ଲୋଇ ଏସୋ ଗ୍ରିକ୍‌ ଲୋକୁ ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ୱାର୍‌ ଗାଲିଲିଦି ବେତ୍‍ସାଇଦାଦୁ ତେବାନି ପିଲିପ୍‌ତି ଲାକ୍‌ତୁ ୱାଜି ୱାନିଙ୍ଗ୍‌ ମାଡ଼ିସ୍‌ କିଜି ଇର୍ହାର୍‌, “ଆଜ୍ଞା, ଜିସୁଙ୍ଗୁଁ ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ମା ବଦା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ପିଲିପ୍‌ ସଲ୍‌ସି ଆନ୍ଦ୍ରିୟତିଙ୍ଗ୍‍ ଇର୍ହାନ୍‌, ମାରି ଆନ୍ଦ୍ରିୟ ନି ପିଲିପ୍‌ ସଲସି ଜିସୁଙ୍ଗୁଁ ଇର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ମନୁସ୍ୟପୁତ୍ର ଦନ୍ୟବାଦ୍‌ ପୟ୍‌ଦେଙ୍ଗ୍‌ ଇଜି ସମୟ ଇଗା ୱାତାମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ସତ୍‌ ସତ୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ଗଦ୍‍ମୁପାଡ଼ୁ ଜଦି ସିକ୍‌ଲାଦୁ ଆର୍‍ଜି ସାଏତ୍‌, ଆରିଙ୍ଗ୍‌ ଆକା ଉଡ୍ରେନେ ତେବାନାତ୍‍, ମାତର୍‌ ଜଦି ସାନାତ୍‍, ନାଣ୍ତ ପାଡ଼ୁ ଆସ୍‍ନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ଏନ୍‌ ନିଜେଦି ଜିବନ୍‌ତିଙ୍ଗ୍‌ ନାଣ୍ତ ଜିବନ୍‍ନୋନାନ୍‍, ୱାନ୍‌ ଆକା ଆରାକିନାନ୍‌, ମାରି ଏନ୍‌ ନିଜେଦି ଜିବନ୍‌ତିଙ୍ଗ୍‌ ଇୟା ଦୁନିଆଦୁ କାଡ଼୍‍ନାନ୍‍, ୱାନ୍‌ ଆକା ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜ୍‍ଇ ଜିବନ୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ରକିୟା କିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ଏନ୍‌ ନା ସେବା କିଦେଙ୍ଗ୍‌ ବଦାକିନାନ୍‌, ଆରିଙ୍ଗ୍‌ ୱାନ୍‌ ନା ୱାଲେ ରାପିନ୍‍; ମାରି; ନାନ୍ ଏମେନ୍‍ ମାନା, ନା ସେବାକିନିକାନ୍‍ ବା ଆବେ ତେବାନାନ୍‌; ଏନ୍‌ ଏସାଙ୍ଗ୍‍ ନା ସେବା କିନାନ୍‌, ଆରିଙ୍ଗ୍‌ ନା ବୁବା ୱାନିଙ୍ଗ୍‌ ମାନାନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","ଇଲେଇ ନା ଜିବନ୍‌ ଦୁକ୍‍ଦୁକ୍‍ ଆଜିନାତ୍‍, ମାରି ନାନ୍ ଇନିକା କିନା ? ବୁବା, ନାଙ୍ଗିଁ ଇୟା ସମୟ୍‌ତାନ୍‌ ରକିୟା କିଆ ? ମାତର୍‌ ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ତୋ ନାନ୍ ୱାତାମାନା । ଏଣ୍ତେସ୍‌ ଦୁକ୍‍ବଗାନି ସମୟକୁ କାସ୍ଟୁ ଆଦେଙ୍ଗ୍‍ ପକାତାମାନା । ");
INSERT INTO kfcp_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","“ବୁବା, ନିନ୍‌ ଦର୍‌ ଦନ୍ୟବାଦ୍‌ କିଆ । ଆବେଟ୍‌ ବାଦଡ଼ତାନ୍‍ ଇୟା ବଲ୍ ୱାତାତ୍‍ ମାପ୍‌ ଆକା ମହିମାନିତ କିତାମାନାପ୍‍, ମାରିଡ଼େସି ମହିମାନିତ କିନାପ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ଆଦେଙ୍ଗ୍‌ ଲାକ୍‌ତୁ ନିର୍‍ଇ ମାର୍‍ଇ ଲୋକୁ ୱିଜେରେ ଇକା ୱେନ୍‌ଜି ବାଦଡ଼୍‍ ଡିଡ଼ିତାତ୍‍ ଇଜି ଇର୍ହାର୍‌; ଆଇକାର୍‌ ଇର୍ହାର୍‌, “ଅରେନ୍‍ ଦୁତ୍‍ ୱେନିଙ୍ଗ୍‌ ମାଟା ଇର୍ହାମାନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ନା ଉଣ୍ତିଙ୍ଗ୍‌ ଇୟା ବଲ୍ ଆଏତ୍‍, ମାତର୍‌ ମି ଉଣ୍ତିଙ୍ଗ୍‌ ଆତାମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ଇଲେଇ ଇୟା ଦୁନିଆଦୁ ବିସାର୍‌ ଇଗା ୱାତାତ୍‍; ଇଲେଇ ଇୟା ଦୁନିଆଦି ବିସାର୍‍ପତିଙ୍ଗ୍‌ ଆତ୍‌ରେ ପକାନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ମାରି, ନାନ୍ ଏସ୍ତିୱାଲେ ଦୁନିଆଦାନ୍‌ ମୁସ୍‌କୁ ପେରାଇଆନା, ନାସ୍ତିୱାଲେ ୱିଜେରିଙ୍ଗ୍‌ ଟାଣିସ୍‍ କିନା । ");
INSERT INTO kfcp_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ୱାନ୍‌ ଏଣ୍ତେସ୍‌ ସାଦେଙ୍ଗ୍‌ ସଲ୍‌ସିନାନ୍‌, ଆୟା ସିନା ସିଜି ଇକା ଇର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ଆବେଟ୍‌ ଲୋକୁ ୱିଜେରେ ଇର୍ହାର୍‌, “ମସିହ ୱିଜୁଦିନ୍‌ ତେବାନାନ୍‌ ଇଜି ନିୟମ୍‍ତାନ୍‍ ମାପ୍‌ ୱେର୍‍ଆମାନାପ୍‍, ଆରିଙ୍ଗ୍‌ ମନୁସ୍ୟପୁତ୍ର ମୁସ୍‌କୁ ପେରାନାନ୍‌ ଇଜି ମିର୍‌ ଏଣ୍ତେସ୍‌ ଇଜିନିଦେର୍‌ ? ଇୟା ମନୁସ୍ୟପୁତ୍ର ଏନ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ଆବେଟ୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମାରି ଅଡ଼ପ୍‍ ସମୟ ମାତର୍‌ ଜାୟ୍‌ ମିବାନୁ ମାନାତ୍‌ । ସିକାଟି ଏଣ୍ତେସ୍‌ ମି ଡ଼ିଙ୍ଗ୍‍ଏତ୍‍, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ମି ଲାକ୍‌ତୁ ଜାୟ୍‌ ମାନାପ୍ ମାନାପ୍ ବୁଲାସାଲା କିଦୁ; ଏନ୍‌ ସିକାଟିଦୁ ବୁଲାସାଲା କିନାନ୍‌, ୱାନ୍‌ ଏମେ ସଲ୍‌ସିନାନ୍‌, ଆକା ୱାନ୍‌ ନେସ୍‌ଏପ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ମିର୍‌ ଏଣ୍ତେସ୍‌ ଜାୟ୍‍ତି କଡ଼ର୍‌ ଆଦୁ, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ଜାୟ୍‌ ମି ଲାକ୍‌ତୁ ମାନାପ୍ ମାନାପ୍ ଜାୟ୍‍ତୁ ବିସ୍‌ବାସ୍‌ କିଦୁ । ଜିସୁ ଇୟାୱିଜୁ ମାଟା ଇନ୍‌ଜି ୱାରିମାଣାନ୍‌ ସଲ୍‌ସି ମାର୍‍ଗିଜି ତେବାତାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ଜଦିବା ଜିସୁ ତାମେ ଆଗ୍‌ଡ଼ି ନିସା କାବାଆନି ପାଣି କିତାମାର୍ହାନ୍‌, ଆବେବା ୱାର୍‌ ୱାନିବାନୁ ବିସ୍‌ବାସ୍‌ କିଏତାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ଏଣ୍ତେସ୍‌ ଜିସାଇୟ ବାବବାଦି ମାଣ୍‌କୁ ରାସାତି ବାକ୍ୟ ସତ୍‌ ଆନାତ୍‌ । “ଏ ପ୍ରବୁ, ଏନ୍‌ ମା ନେଗିକାବୁର୍‌ ମାଟା ବିସ୍‌ବାସ୍‌ କିତାମାନାନ୍‍ ? ମାରି ପ୍ରବୁଦି ସାକ୍ତି ଏମେୱାନି ଲାକ୍‌ତୁ ତର୍‍ତାନ୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାର୍‌ ବିସ୍‌ବାସ୍‌ କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏଜିମାର୍ହାର୍‍, ଇରିଙ୍ଗ୍‌ ଜିସାଇୟ ମାରି ଇର୍ହାମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“ମାପୁରୁ ୱାରି କାଣୁକୁ କାଣା କିତାମାନାନ୍‍, ମାରି ୱାରି ଜିବନ୍‌ତିଙ୍ଗ୍‌ ଆଟ୍‌ୱା କିତାମାନାନ୍‍, ଏଣ୍ତେସ୍‌ ୱାର୍‌ କାଣ୍‍କାଙ୍ଗ୍‍ଁ ସୁଡ଼ୁଏର୍‍ ମାରି ଜିବନ୍‌ତୁ ବୁଜାଏର୍‍, ମାରିଡ଼େସି ନାବାନୁ ରେଏର୍‍, ମାରି ମାପ୍‌ ୱାରିଙ୍ଗ୍‌ ନେଗେଣ୍ତ୍‍ କିଏପ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ଜିସାୟ ଇୟାୱିଜୁ ଇର୍ହାନ୍‌, “ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ଜିସୁଦି ମହିମା ସୁଡ଼ୁତାନ୍‌ ମାରି ୱାନି ବିସୟ୍‌ତାନ୍‌ ଇର୍ହାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ଆବେ ଜିହୁଦି ନେତାର୍‌ ଲୋଇ ବା ନାଣ୍ତଲୋକ୍‍ ଜିସୁମାନୁ ବିସ୍‌ବାସ୍‌ କିତାର୍‍, ମାତର୍‌ ଆନାତ୍‌ସୁଗି ଏସ୍ତିୱାଲେ ପାର୍‌ତନା ଇଲ୍‌ତାନ୍‌ ସପ୍‍ନାର୍‍, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ପାରୁସିରିଙ୍ଗ୍‍ ତିଲାଜି ଆକା ନାମ୍‍ଏଜି ମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ଇରିଙ୍ଗ୍‌ ୱାର୍‌ ଗୌରବ୍‍ ମାପୁରୁଦି ୱେଡ଼ିକାକିନି ବାଦଲୁ ଲୋକାଙ୍ଗ୍‌ ୱେଡ଼ିକା ବଦା କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ଜିସୁ ଆଉଲି ଆଜି ଇର୍ହାନ୍‌, “ଏନ୍‌ ନାବାନ୍‍ ବିସ୍‌ବାସ୍‌ କିନାନ୍‌, ୱାନ୍‌ କେବଲ୍‌ ନାବାନ୍‍ ବିସ୍‌ବାସ୍‌ କିଏନ୍‍, ମାତର୍‌ ନା ପକ୍‍ତିୱାନିମାନୁ ବିସ୍‌ବାସ୍‌ କିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ମାରି, ଏନ୍‌ ନାଙ୍ଗିଁ ସୁଡ଼ୁତାମାନାନ୍‌, ୱାନ୍‌ ନାଙ୍ଗିଁ ପକ୍‍ତିୱାନିଙ୍ଗ୍‍ ସୁଡ଼ୁତାମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ଦୁନିଆଦି ଜାୟ୍‍ଆଜି ୱାତାମାନା, ଏନ୍‌ ନାବାନ୍‍ ବିସ୍‌ବାସ୍‌ କିନାନ୍, ୱାନ୍‌ ଏଣ୍ତେସ୍‌ ସିକାଟିଦୁ ବାସାଏନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ଏନ୍‌ ଜଦି ନା ବାକ୍ୟ ୱେନ୍‌ଜି ମାନାଏନ୍‌, ଆରିଙ୍ଗ୍‌ ନାନ୍ ୱାନି ବିସାର୍‌ କିଏ; ଇରିଙ୍ଗ୍‌ ନାନ୍ ଦୁନିଆଦି ବିସାର୍‌ କିଦେଙ୍ଗ୍‍ ରେଏନ୍‍ଣ୍ତା ମାତର୍‌ ଦୁନିଆଦିଙ୍ଗ୍‍ ରକିୟା କିଦେଙ୍ଗ୍‌ ୱାତାମାନା । ");
INSERT INTO kfcp_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ଏନ୍‌ ନାଙ୍ଗିଁ ଡ଼ିସ୍‌ସି ନା ମାଟା ମାନାଏନ୍‌, ନା ୱେୟୁଦି ବାକ୍ୟ ୱାନି ବିସାର୍‍କିନିକାତ୍‍ ଆନାତ୍‌ । ଆୟା ବାକ୍ୟ ୱିଜ୍‍ନି ଦିନ୍‍ତୁ ୱାନି ବିସାର୍‌ କିନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ଇୟା ମାଟା ସତ୍‌, ଇରିଙ୍ଗ୍‌ ନାନ୍ ନା ନିଜେଦି ଅଦିକାର୍‍ତାନ୍‍ ଇନିକା ଇନ୍‌ଏ, ମାତର୍‌ ନାନ୍ ଇନିକା ଇନା ମାରି ଇନିକା ୱେକ୍‍ନା, ଆକା ନାଙ୍ଗିଁ ପକ୍‍ତିମାନି ବୁବା ନାଙ୍ଗିଁ ମାଟା ସିତାମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ମାରି ନାନ୍ ନେସ୍‌ନା, ୱାନି ଆଦେସ୍‌ ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜ୍‍ଇ ଜିବନ୍‌ ସିନାତ୍‌ । ନା ବୁବା ନାଙ୍ଗିଁ ଆମାକା ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆଦେସ୍‌ ସିତାମାନାନ୍‌, କେବଲ୍‌ ନାସ ନାନ୍ ଇଜିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ନିସ୍ତାର୍‌ ପଣ୍ତୟ୍‌ ଆନି ଆଗ୍‍ଡ଼ିରି ନାଣ୍ଡିଙ୍ଗ୍ ଜିସୁ ଇୟା ଦୁନିଆଦାନ୍‍ ବୁବା ଲାକ୍‌ତୁ ନିଜେ ସନି ସମୟ୍ ଇଗାୱାନିକା ନେସ୍‌ସି, ଦୁନିଆଦୁ ମାନି ନିଜେଦି ଏମେ ଲୋକାଙ୍ଗ୍‌ ୱାନ୍‌ ଜିବନ୍‌ ନଜି ୱାଜିମାର୍ହାନ୍‍, ୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ନାଣ୍ତ ଜିବନ୍‍ନୋନିକା ତର୍‍ତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ଜିସୁ ନି ୱାନି ସିସୁର୍‍ ଏସ୍ତିୱାଲେ ନାଡ଼ାଦି ବଜିଦୁ ବାସ୍‍ତାମାର୍ହାର୍‍ । ଏସ୍ତିୱାଲେ ସୟତାନ୍ ସିମୋନ ମାରିସି ଇସ୍କାରିୟୋତିୟ ଜିହୁଦାଦି ଜିବନ୍‌ତୁ ଜିସୁଙ୍ଗୁଁ ସାତ୍ରୁରି କିୟୁଦୁ ସର୍‍ପେ କିଦେଙ୍ଗ୍‌ ଇଜି ବଦା କିତାୱିସ୍‍ତା ମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ନାସ୍ତିୱାଲେ ବୁବା ଜେ ୱିଜୁ ଜିସୁଦି କିୟୁଦୁ ୱିଜୁ ସାକ୍ତି ସର୍‍ପେ କିତାମାନାନ୍‌ ମାରି ୱାନ୍‌ ଜେ ମାପୁରୁ ମାଣାନ୍‌ ୱାତାମାନାନ୍‍, ମାରି ମାପୁରୁମାନୁ ସଲ୍‌ସିନାନ୍‌, ଇକା ନେସ୍‍ତାମାର୍ହାନ । ");
INSERT INTO kfcp_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ଆବେଟ୍‌ ଜିସୁ ୱାନ୍‌ ଉଣି ମାଣାନ୍‌ ନିଙ୍ଗିଁତାନ୍‌ନୋ ନିଜେଦି ମୁସ୍‌କୁରି ଆଙ୍ଗିଁ କୁତ୍‍ସି ଉଣ୍ତ୍ରି ପାସିଆ ଅସି ନିଜେଦି ଜୁକିଦୁ ତରାତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ୱେନ୍‌କା ୱାନ୍‌ ନକିଦୁ ଏର୍‌ ୱାକ୍‍ତାନ୍‍, ମାରି ସିସୁରି ପାଦାମ୍‌କୁ ନର୍‍ଜିସିଜି ନିଜେଦି ଜୁକିଦୁ ତରାତିମାର୍‍ଇ ପାସିଆଦାନ୍‍ ତେଲ୍‍ଦେଙ୍ଗ୍‍ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ଜିସୁ ସିମୋନ୍‌ ପିତର୍‌ ଲାକ୍‌ତୁ ୱାତାନ୍‌; ଏନ୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ପ୍ରବୁ, ନିନ୍‌ ନା ପାଦାମ୍‌କୁ ନର୍‍ବିସ୍‍କିଜି ସିଜିନି ?” ");
INSERT INTO kfcp_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନାନ୍ ଏମେକା କିଜିନା, ଆକା ନିନ୍‌ ଇଲେ ନେସ୍‌ଏଜିନି, ମାତର୍‌ ୱେନ୍‌କା ନେସ୍‌ନି ।” ");
INSERT INTO kfcp_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ପିତର୍‌ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାନ୍‌, “ନିନ୍‌ ମୁଡ଼ୁକେ ଏସ୍‌କାଙ୍ଗ୍‌ବା ନା ପାଦାମ୍‌କୁ ନର୍‌ଜ ସିଇ ।” ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଜଦି ନାନ୍ ନି ପାଦାମ୍‌ ନର୍‌ଏ, ଆରିଙ୍ଗ୍‌ ନା ସିସୁ ଆଦେଙ୍ଗ୍‌ ଆଟ୍‍ଇ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ସିମୋନ ପିତର୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଏ ପ୍ରବୁ, ନିନ୍‌ କେବଲ୍‌ ନା ପାଦାମ୍‌କୁ ସିଲେ ନା କିୟୁ ନି ତାଲା ବା ନର୍‌ଜ ସିଦା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ଏନ୍‌ ଏରୁ ଇବାତାମାନାନ୍‌, ୱାନି ପାଦାମ୍‌କୁ ନର୍‌ଦେଙ୍ଗ୍‌ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ମାରି ଇନିକା ଦର୍‌କାର୍‌ ସିଲେ, ୱାନ୍‌ ସତ୍‍ନେ ନରାତାମାନ୍‌ନାନ୍‌; ମିର୍‌ ୱିଜେରେ ବା ନରାତିମାନିଦେର୍‌, କେବଲ୍‌ ଅରେନ୍‍ ସିଲେ । ");
INSERT INTO kfcp_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ମାତର୍‌ ଏନ୍‌ ୱାନିଙ୍ଗ୍‌ ସାତ୍ରୁରି କିୟୁଦୁ ସର୍‌ପେ କିନ୍‌ନାନ୍‌, ଜିସୁ ୱାନିଙ୍ଗ୍‌ ନେସ୍‌ତାମାର୍ହାନ୍‌, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାନ୍‌ ଇର୍ହାନ୍‌, କେବଲ୍‌ ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ଡ଼ିସ୍‍ତିଙ୍ଗ୍‍ ମିର୍‌ ୱିଜିଦେର୍‌ ନର୍‌ୟାଆତିମାନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ତାନେୱେନ୍‌କା ଜିସୁ ୱାରି ପାଦାମ୍‌କୁ ନର୍‌ଜି ନିଜେଦି ଆଙ୍ଗିଁ ଆରାଜି ମାରିଡ଼େସି ନିଜେଦି ବାଡିଦୁ ବାସ୍‌ତି ୱେନ୍‌କା ୱାରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, ନାନ୍ ମି ଉଣ୍ତିଙ୍ଗ୍‌ ଇନିକା କିତାମାନା, ଆକା ଇନିକା ମିର୍‌ ନେସ୍‌ତିମାନିଦେର୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ମିର୍‌ ନାଙ୍ଗିଁ ଗୁରୁ ନି ପ୍ରବୁ ଇଜି କୁକ୍‌ସିନିଦେର୍‌, ମାରି ଆକା ସତ୍‌ ଇଜିନିଦେର୍‌; ଇରିଙ୍ଗ୍‌ ନାନ୍ ତୋ ଆୟାକାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ମାରି, ପ୍ରବୁ ନି ଗୁରୁ ଜେ ନାନ୍ ମାପୁରୁ, ନାନ୍ ଜଦି ମି ପାଦାମ୍‌କୁ ନର୍‌ତାସିତାମାନା, ଆରିଙ୍ଗ୍‌ ମିର୍‌ ବା ନିଜେ ନିଜେଦି ପାଦାମ୍‌କୁ ନରାନିକା ମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ଇରିଙ୍ଗ୍‌ ମି ଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ଏଣ୍ତେସ୍‌ କିତାମାନା, ମିର୍‌ ବା ଆୟାୱାଜା କିଦୁ, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଉନ୍‌ଡ୍ରି ସାରି ତର୍‌ତାମାନା । ");
INSERT INTO kfcp_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ସତ୍‌ ସତ୍‍ନେ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ସାକର୍‌ ନିଜେଦି ମାଲିକ୍‌ମାଣ୍‌କୁ ପେରିକାନ୍‌ ଆଏନ୍‍, ମାରି କାବୁର୍‌ ଅନିକାନ୍‍ ପକ୍‍ତିମାନି ମାଲିକ୍‌ତି ମାଣାନ୍‌ ପେରିକାର୍‌ ସିଲେ । ");
INSERT INTO kfcp_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ଜଦି ମିର୍‌ ଇୟାୱିଜୁ ନେସ୍‌ତୁ, ଆରିଙ୍ଗ୍‌ ଆୟାୱାଜା କିତିଙ୍ଗ୍‌ ମିର୍‌ ଦନ୍ୟ । ");
INSERT INTO kfcp_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","ମି ୱିଜେରି ବିସୟ୍‌ତାନ୍‌ ନାନ୍ ଇୟା ମାଟା ଇନ୍‌ଏଜିନା । ନାନ୍ ଏମେୱାରିଙ୍ଗ୍‍ ଆସ୍‌କିତାମାନା, ୱାରିଙ୍ଗ୍‌ ନାନ୍ ନେସ୍‌ନା । ମାତର୍‌ ଦାର୍ମୁସାସ୍ତ୍ରଦି ଇୟା ମାଟା ସତେନେ ପୁରା ଆନାତ୍‌, ଏନ୍‌ ନା କାଦିଦୁ ପିରିତାନ୍‍, ୱାନ୍‌ ନାଙ୍ଗିଁ ଲାତ୍‍ ଡାକ୍‍ତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ଇଲେଇ ଇକା ଗଟାନି ଆଗ୍‍ଡ଼ିରାନ୍‍ନେ ନାନ୍ ମିଙ୍ଗିଁ ଇୟା ମାଟା ୱେର୍‌ସିନା, ଏସ୍ତିୱାଲେ ଇକା ଗଟାନାତ୍‌, ମିର୍‌ ବିସ୍‌ବାସ୍‌ କିନିଦେର୍‌ ଜେ, ନାନ୍ ଆମାକାନ୍‌ ନାନ୍ ଆକାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ସତ୍‌ ସତ୍‍ନେ ନାନ୍ ମିଙ୍ଗିଁ ୱେର୍‌ସିନା, ନାଙ୍ଗିଁ ପୋକ୍‌ତାତିମାନି ଲୋକ୍‌ତିଙ୍ଗ୍‌ ଏନ୍‌ ମାନାନାର୍‌, ୱାନ୍‌ ନାଙ୍ଗିଁ ମାନାନାର୍‌ ମାରି ଏନ୍‌ ନାଙ୍ଗିଁ ମାନାନାର୍‌, ୱାନ୍‌ ନା ପୋକ୍‌ତାତିମାନି ମାଲିକ୍‌ତିଙ୍ଗ୍‌ ବା ମାନାନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ଜିସୁ ଇୟାୱିଜୁ ମାଟା ଇର୍ହି ୱେନ୍‌କା ଆତ୍ମାଦୁ ଦୁଃକ୍‌କିତାନ୍‌ ମାରି ୱିଜେରି ଆଗ୍‌ଡ଼ି ସାକ୍‌ୟ ସିଜି ଇର୍ହାନ୍‌, “ସତ୍‌ ସତ୍‍ନେ ନାନ୍ ମିଙ୍ଗିଁ ଇଜିନା, ମି ମାଣ୍‌କୁ ଅରେନ୍‍ ନାଙ୍ଗିଁ ସାତ୍ରୁରି କିୟୁଦୁ ସର୍‌ପେ କିନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ଜିସୁ ଏ ବିସୟ୍‌ତାନ୍‌ ଇର୍ହାନ୍‌, ଆୟା ବିସୟ୍‌ତାନ୍‌ ବୁଜାଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏଜି ସିସୁର୍‍ ନିଜେ ନିଜେଦି ମାନୁ ବେସ୍‌ସିସାଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ଜିସୁଦି ସିସୁରି ଲୋଇରାନ୍‌ ଅରେନ୍‍ ଆମାୱାନିଙ୍ଗ୍‌ ଜିସୁ ଜିବନ୍‌ନୋଜି ମାର୍ହାନ୍‌, ୱାନ୍‌ ଜିସୁଦି ଲାକ୍‌ତୁ ବାସ୍‌ତା ମାର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ମାରି, ସିମୋନ ପିତର୍‌ ୱାନିଙ୍ଗ୍‌ ଜୁଟ୍‌ସି ଇର୍ହାନ୍‌, ୱାନ୍‌ ଏ ବିସୟ୍‌ତାନ୍‌ ୱେର୍‌ସିନାନ୍‌, ଆକା ୱେନ୍‍ବାଆ । ");
INSERT INTO kfcp_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ୱାନ୍‌ ଆୟାୱାଜା ବାସ୍‌ସି ମାନ୍‍ଞ୍ଜି ଜିସୁଦି ବକାଦୁ ଗେକାଜିବାସ୍‌ସି ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, ପ୍ରବୁ, ଆୟାକାନ୍‌ ଏନ୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ଆରିଙ୍ଗ୍‌ ଜିସୁ ଇର୍ହାନ୍‌, ଆମାୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ଇୟା ରୁଟି କାଣ୍ତେକ୍‌ ମୁଡ଼ୁକୁନା ମାରି ଆମାୱାନିଙ୍ଗ୍‌ ସିନା, ଆୟାକାନ୍‌ ୱାନ୍‌ । ଆବେନୁ ୱାନ୍‌ ଆୟା ରୁଟିକାଣ୍ତେକ୍‌ତିଙ୍ଗ୍‌ ମୁଡୁକ୍‌ସି ଆକା ଅସି ସିମୋନ ଇସ୍କାରିୟୋତିୟତି ମାରିସି ଜିହୁଦାଦିଙ୍ଗ୍‌ ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ଆୟା ରୁଟି କାଣ୍ତେକ୍‌ ପୟ୍‌ତି ୱେନ୍‌କା ସୟତାନ୍ ୱାନି ମାନୁ ଡ଼ୁଗିତାତ୍‌ । ଆବେଟ୍‌ ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ଆମାକା କିଦେଙ୍ଗ୍‌ ସଲ୍‌ସିନି, ଆକା ଦାପେର୍‌ କିଆ । ");
INSERT INTO kfcp_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ମାତର୍‌ ୱାନ୍‌ ଇନି ବିସୟ୍‌ତାନ୍‌ ୱାନିଙ୍ଗ୍‌ ଇୟା ମାଟା ଇର୍ହାମାର୍ହାନ୍‌, ଆକା ବଜିଦୁ ବାସ୍‌ତିମାର୍‌ଇକାର୍‍ ଏନ୍‌ ନେସ୍‌ଏତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ଇରିଙ୍ଗ୍‌ ଜିହୁଦା ଲାକ୍‌ତୁ ଡାବୁଙ୍ଗ୍‌ଆସ୍‌ନି ମଣି ମାର୍‍ହାତ୍‍ଆକା, ପଣ୍ତୟ୍‌ତି ଉଣ୍ତିଙ୍ଗ୍‌ ଇନି ଇନିକା ଦର୍‌କାର୍‌, ଆକା କଡ଼୍‍ଦେଙ୍ଗ୍‌ ମାରି ସିଲିସାତିୱାରିଙ୍ଗ୍‌ ଏସ ଦାନ୍‌ କିଦେଙ୍ଗ୍‌ ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌ ଇଜି ଏନ୍‌ ଏନ୍‌ ଅଡ଼୍‍ବିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ଜିହୁଦା ରୁଟି କାଣ୍ତେକ୍‌ ଲସ୍‌ତାନ୍‌ନୋ, ୱାନ୍‌ ଆୟାଦାର୍ପେ ସତାସର୍ହାନ୍‌, ନାସ୍ତିୱାଲେ ନାଡ଼ାଆତା ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ଜିହୁଦା ସତିସର୍‌ଇ ୱେନ୍‌କା ଜିସୁ ଇର୍ହାନ୍‌, “ଇଲେଇ ମନୁସ୍ୟପୁତ୍ରଦି ଦନ୍ୟବାଦ୍‌ ତରିତାତ୍‌ ମାରି ୱାନିମାଣାନ୍‌ ମାପୁରୁଦି ଗୌରବ୍‍ ବା ତରାତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ଜଦି ମାପୁରୁ ମନୁସ୍ୟପୁତ୍ର ମାଣାନ୍‌ ଗୌରବ୍‍ ଆନାନ୍‌, ମାପୁରୁ ନିଜେଦି ଦନ୍ୟବାଦଦୁ ମନୁସ୍ୟପୁତ୍ରଙ୍ଗ୍‌ ଦନ୍ୟବାଦ୍‌ କିନ୍‌ନାନ୍‌ । ଦାପ୍ରେନେ ୱାନ୍‌ ଇକା କିଦେଙ୍ଗ୍‌ ସଲ୍‌ସିନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ଜିସୁ ଇର୍ହାନ୍‌, ନା କଡ଼ର୍‌, ନାନ୍ ମାରି ସାଣେକ୍‌ତିଙ୍ଗ୍‌ ମି ୱାଲେ ମାନା । ମିର୍‌ ନାଙ୍ଗିଁ ପୟ୍‌ନିଦେର୍‌; ମାରି ନାନ୍ ଏମେ ବାଡିଦୁ ସଲ୍‌ସିନା, ମିର୍‌ ଆୟା ବାଡିଦୁ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଆଟ୍‍ଇଦେର୍‍, ଇକା ନାନ୍ ଏଣ୍ତେସ୍‌ ଜିହୁଦି ନେତାରିଙ୍ଗ୍‌ ଇର୍‌ଆମାର୍ହା, ଆୟାୱାଜା ଇଲେଇ ମିଙ୍ଗିଁ ବା ୱେର୍‌ସିନା । ");
INSERT INTO kfcp_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ମିର୍‌ ନିଜେନିଜେଦିଙ୍ଗ୍‍ ଜିବନ୍‌ନୋଜିସାଦୁ, ଇୟା ପୁନି ମାଟା ନାନ୍ ମିଙ୍ଗିଁ ସିଜିନା; ନାନ୍ ଏଣ୍ତେସ୍‌ ମିଙ୍ଗିଁ ଜିବନ୍‌ନୋତାମାନା, ମିର୍‌ ବା ଆୟାୱାଜା ନିଜେନିଜେଦିଙ୍ଗ୍‌ ଜିବନ୍‍ନୋନିକା ମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ଜଦି ମିର୍‌ ନିଜେନିଜେଦିଙ୍ଗ୍‍ ଉଣ୍ତିଙ୍ଗ୍‌ ଜିବନ୍‍ନୋନିଦେର୍‍, ଆରିଙ୍ଗ୍‌ ମିର୍‌ ଜେ ନା ସିସୁର୍‍, ଇକା ୱିଜେରେ ନେସ୍‌ନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ସିମୋନ ପିତର୍‌ ଜିସୁଙ୍ଗୁଁ ୱେନ୍‌ବାତାନ୍‌, “ପ୍ରବୁ, ନିନ୍‌ ଏମେମାନୁ ସଲ୍‌ସିନି ?” ଜିସୁ ଇର୍ହାନ୍‌, ନାନ୍ ଏମେମାନୁ ସଲ୍‌ସିନା, ନିନ୍‌ ଇଲେଇ ନା ୱେନ୍‌କା ୱେନ୍‌କା ଆବେନୁ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଆଟ୍‍ଇ, ମାତର୍‌ ୱେନ୍‌କା ସନି । ");
INSERT INTO kfcp_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ପିତର୍‌ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ପ୍ରବୁ, ନାନ୍ ଇଲେଇ ଏନ୍ଧା ନି ୱେନ୍‌କା ୱେନ୍‌କା ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଆଟ୍‍ଏ ? ନାନ୍ ନି ଉଣ୍ତିଙ୍ଗ୍‌ ନିଜେଦି ଜିବନ୍‌ ସିଦେଙ୍ଗ୍‍ ବା ରାଜି ।” ");
INSERT INTO kfcp_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ଜିସୁ ଇର୍ହାନ୍‌, “ନିନ୍‌ ଇନିକା ନା ଉଣ୍ତିଙ୍ଗ୍‌ ନିଜେଦି ଜିବନ୍‌ ସିନି ? ସତ୍‌ ସତ୍‍ନେ ନାନ୍ ମିଙ୍ଗିଁ ୱେର୍‌ସିନା, କରୁ କେଡ଼ିଇ ଆଗ୍‍ଡ଼ିନେ ନିନ୍‌ ନାଙ୍ଗିଁ ମୁଜା ନେସେଏ ଇଜି ଇନି ।” ");
INSERT INTO kfcp_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ଜିସୁ ଇର୍ହାନ୍‌, ମି ଜିବନ୍‌ ଦାନ୍ଦା ଆମାକିତ୍‌; ମିର୍‌ ମାପୁରୁମାନୁ ବିସ୍‌ବାସ୍‌ କିଦୁ, ନା ମାନୁ ବା ବିସ୍‌ବାସ୍‌ କିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ନା ବୁବାଦି ଇନ୍‌ଡ୍ର ନାଣ୍ତ ବାକ୍‍ରେଙ୍ଗ୍‍ ମାନେ; ଜଦି ସିଲିତିଙ୍ଗ୍‌, ଆରିଙ୍ଗ୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଇନ୍‍ଏତାମାନ୍ଧି, ନାନ୍ ମି ଉଣ୍ତିଙ୍ଗ୍‌ ବାଡି ତିଆର୍‌ କିଦେଙ୍ଗ୍‌ ସଲ୍‌ସିନା; ");
INSERT INTO kfcp_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ମାରି, ନାନ୍ ସନାନୋ ମି ଉଣ୍ତିଙ୍ଗ୍‌ ବାଡି ତିଆର୍‌ କିତିଙ୍ଗ୍‌ ମାରିଡ଼େସି ୱାନା, ମାରି ନାନ୍ ଏମେ ବାଡିଦୁ ତେବାନା, ମିର୍‌ ବା ଏଣ୍ତେସ୍‌ ଆୟା ବାଡିଦୁ ମାନିଦେର୍‌, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ମିଙ୍ଗିଁ ନିଜେଦି ଲାକ୍‌ତୁ ଅନା । ");
INSERT INTO kfcp_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ମାରି, ନାନ୍ ଏମେ ବାଡିଦୁ ସଲ୍‌ସିନା, ଆୟା ସାରି ମିର୍‌ ନେସ୍‌ନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ତୋମା ଜିସୁଙ୍ଗୁଁ ୱେନ୍‌ବାତାତ୍‌, “ପ୍ରବୁ, ନିନ୍‌ ଏମେ ବାଡିଦୁ ସଲ୍‌ସିନି, ଆକା ମାପ୍‌ ନେସ୍‌ଏଜିନାପ୍‌; ସାରି ବା ଏଣ୍ତେସ୍‌ ନେସ୍‌ନାପ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ନାନ୍ ସାରି, ସତ୍‌ ମାରି ଜିବନ୍‌; ନାଙ୍ଗିଁ ସିଜି ସଲ୍‌ଇତିଙ୍ଗ୍‌ ଏନ୍‌ ବୁବାଦି ଲାକ୍‌ତୁ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଆଟ୍‍ଏନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ଜଦି ମିର୍‌ ନାଙ୍ଗିଁ ନେସ୍‌ତିଦେର୍‌ମାନ୍ଧି, ଆରିଙ୍ଗ୍‌ ନା ବୁବେଙ୍ଗ୍‌ବା ନେସ୍‌ତିଦେର୍‌ମାନ୍ଧି; ଇଲେଇରାନ୍‌ ୱାନିଙ୍ଗ୍‌ ନେସ୍‌ତିମାନିଦେର୍‌ ମାରି ୱାନିଙ୍ଗ୍‌ ସଡ଼ୁତିମାନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ପିଲିପ୍‌ ଜିସୁଙ୍ଗୁଁ ଇର୍ହାନ୍‌, ପ୍ରବୁ, ମାଙ୍ଗିଁ ବୁବେଙ୍ଗ୍‌ ତର୍‌ରିସ୍‌କିଆ, ନାସ ମା ଉଣ୍ତିଙ୍ଗ୍‌ ନାଣ୍ତ । ");
INSERT INTO kfcp_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ପିଲିପ୍‌, ନିସସାନ୍ଧି ନାନ୍ ମି ୱାଲେ ମାନା, ମାରି ନିନ୍‌ ଇନିକା ନାଙ୍ଗିଁ ନେସ୍‌ଏଜିନି ? ଏନ୍‌ ନାଙ୍ଗିଁ ସୁଡ଼ୁତାମାନ୍‌ନାନ୍‌, ୱାନ୍‌ ବୁବେଙ୍ଗ୍‌ବା ସୁଡ଼ୁତାମାନ୍‌ନାନ୍‌; ମାଙ୍ଗିଁ ବୁବେଙ୍ଗ୍‌ ତରିସ୍‌କିଆ ଇଜି ନିନ୍‌ ଏଣ୍ତେସ୍‌ ୱେର୍‌ସିନିଦେର୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ନାନ୍ ଜେ ବୁବାମାନୁ ମାନା ମାରି ବୁବା ନାମାନୁ ମାନ୍‌ନାନ୍‌, ଇୟା ମାଟା ଇନିକା ବିସ୍‌ବାସ୍‌ କିଏଜିନିଦେର୍‌ ? ନାନ୍ ମିଙ୍ଗିଁ ଜେ ୱିଜୁ ବାକ୍ୟ ୱେର୍‌ନା, ଆୟାୱିଜୁ ନାନ୍ ନିଜେଦିମାଣ୍‌କୁ ଇନ୍‌ଏ, ମାତର୍‌ ବୁବା ନା ମାନୁ ମାନ୍‌ଜି ନିଜେଦି ପାଣି କିଜିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ନାନ୍ ଜେ ବୁବାମାନୁ ମାନା ମାରି ବୁବା ନା ମାନୁ ମାନ୍‌ନାନ୍‌, ନା ଇୟା ମାଟା ବିସ୍‌ବାସ୍‌ କିଦୁ, ମାରି ନାନ୍ ଏମେ ୱିଜୁ ପାଣି କିତାମାନା ଆୟାକା ସୁଡ଼ୁଜି ବିସ୍‌ବାସ୍‌ କିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ସତ୍‌ ସତ୍‌ ନାନ୍ ମିଙ୍ଗିଁ ୱେର୍‌ସିନା, ନା ମାନୁ ଏନ୍‌ ବିସ୍‌ବାସ୍‌ କିନ୍‌ନାନ୍‌, ନାନ୍ ଏମେ ଏମେ ପାଣି କିଜିନା, ୱାନ୍‌ ବା ଆୟାୱିଜୁ କିନ୍‌ନାନ୍‌, ମାରି ଆୟାମାଣାନ୍‍ ବା ନାଣ୍ତ ପେରି ପାଣି କିନାନ୍‌, ଇରିଙ୍ଗ୍‌ ନାନ୍ ବୁବାଦି ଲାକ୍‌ତୁ ସଲ୍‌ସିନା । ");
INSERT INTO kfcp_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ଏଣ୍ତେସ୍‌ ମାରିନ୍‌ତିମାଣାନ୍ ବୁବାଦି ଦନ୍ୟବାଦ୍‌ ତରାନାତ୍‍, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ମିର୍‌ ନା ଦର୍‌ତାନ୍‌ ଇନିକାବା ଲସ୍‌ତିଙ୍ଗ୍‌, ଆକା ନାନ୍ ସିନା । ");
INSERT INTO kfcp_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ଜଦି ମିର୍‌ ନା ଦର୍‌ତାନ୍‌ ଇନି ବିସୟ୍‌ ନାଙ୍ଗିଁ ଲସ୍‌ତିଙ୍ଗ୍‌, ଆକା ନାନ୍ କିନା । ");
INSERT INTO kfcp_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","ଜଦି ମିର୍‌ ନାଙ୍ଗିଁ ଜିବନ୍‌ନୋନିଦେର୍‌, ଆରିଙ୍ଗ୍‌ ନା ମାଟାୱିଜୁ ମାନାନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ମାରି, ନାନ୍ ବୁବେଙ୍ଗ୍‌ ମାଡ଼ିସ୍‌କିନା, ମାରି ମି ୱାଲେ ୱିଜୁଦିନ୍‌ତିଙ୍ଗ୍‌ ମାନି ଉଣ୍ତିଙ୍ଗ୍‌ ୱାନ୍‌ ମିଙ୍ଗିଁ ମାରି ଅରେନ୍‍ ସାହାଜ୍ୟକିନିୱାନିଙ୍ଗ୍‌ ସିନାନ୍‍ ");
INSERT INTO kfcp_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ମାରି ୱାଦ୍‌ ଆଜିନାତ୍‍ ସତ୍‌ତି ଆତ୍ମା । ଇୟା ଜଗତ୍‌ ୱାନିଙ୍ଗ୍‌ ମାନାଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏତ୍‍, ଇରିଙ୍ଗ୍‌ ଜଗତ୍‌ ୱାନିଙ୍ଗ୍‌ ସୁଡ଼ୁଏତ୍‌ କି ନେସେତ୍‌; ମାତର୍‌ ମିର୍‌ ୱାନିଙ୍ଗ୍‌ ନେସ୍‌ନିଦେର୍‌, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ୱାଲେ ତେବାନାନ୍‌, ମାରି ୱାନ୍‌ ମି ଜିବନ୍‍ତୁ ତେବାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","ନାନ୍ ସର୍‌ଇ ୱେନ୍‌କା, ନାନ୍ ମିଙ୍ଗିଁ ଟୁରା କଡ଼ କିଜ ଡ଼ିସ୍‌ସୋ ସଲ୍‌ଏ, ନାନ୍ ମି ଲାକ୍‌ତୁ ଡ଼େସିୱାନା । ");
INSERT INTO kfcp_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ଉଣା ୱେଡ଼ା ମାନାତ୍‌, ଜଗତ୍‌ ନାଙ୍ଗିଁ ମାରି ସୁଡ଼ୁଏତ୍‌; ମାତର୍‌ ମିର୍‌ ନାଙ୍ଗିଁ ସୁଡ଼ୁନିଦେର୍‌, ଇରିଙ୍ଗ୍‌ ନାନ୍ ଜିବନ୍‌ ମାନା, ମିର୍‌ ବା ଜିବନ୍‌ ତେବାନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ନାନ୍ ମା ବୁବାମାନୁ ମାରି ମିର୍‌ ନାମାନୁ ମାରି ନାନ୍ ମି ମାନୁ ମାନା, ଇକା ଆୟାନାଣ୍ତିଙ୍ଗ୍‌ ୱାତିଙ୍ଗ୍‍ ମିର୍‌ ନେସ୍‌ନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","ଏନ୍‌ ନା ମାଟାୱିଜୁ ମାନାଜି ସାଲାନାନ୍‌, ୱାନ୍‌ ନାଙ୍ଗିଁ ଜିବନ୍‌ନୋନାନ୍‌, ମାରି ଏନ୍‌ ନାଙ୍ଗିଁ ଜିବନ୍‌ନୋନାନ୍‌, ନା ବୁବା ୱାନିଙ୍ଗ୍‌ ଜିବନ୍‌ନୋନାନ୍‌, ମାରି ନାନ୍ ୱାନିଙ୍ଗ୍‌ ଜିବନ୍‌ନୋନା ମାରି ୱାନି ଲାକ୍‌ତୁ ନିଜେଦିଙ୍ଗ୍‌ ତରାୟାଆନା । ");
INSERT INTO kfcp_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ଜିହୁଦା, ଇକାନ୍‌ ଇସ୍କାରିୟୋତିୟ ଜିହୁଦା ଆଏନ୍‍ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ଏ ପ୍ରବୁ, ଇନିକା ଏଣ୍ତେସ୍‌ ଆନାତ୍‌ ? ନିଜେଦିଙ୍ଗ୍‍ ଦୁନିଆ ଲାକ୍‌ତୁ ତରାୟା ଆଏଣ୍‌ଗା ମା ଲାକ୍‌ତୁ ତର୍‍ତିମାନି ? ");
INSERT INTO kfcp_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ଜଦି ଏନ୍‌ ନାଙ୍ଗିଁ ଜିବନ୍‌ନୋନାନ୍‌, ଆରିଙ୍ଗ୍‌ ୱାନ୍‌ ନା ବାକ୍ୟ ମାନାନାର୍‌, ମାରି ନା ବୁବା ୱାନିଙ୍ଗ୍‌ ଜିବନ୍‌ନୋନାନ୍‌, ମାରି ବୁବା ନି ନାନ୍ ୱାନି ଲାକ୍‌ତୁ ୱାଜି ୱାନି ୱାଲେ ତେବାନାପ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ଏନ୍‌ ନାଙ୍ଗିଁ ଜିବନ୍‌ନୋଏନ୍‌, ୱାନ୍‌ ନା ବାକ୍ୟଦିଙ୍ଗ୍ ମାନାଏନ୍‌, ମାରି ଏମେ ବାକ୍ୟ ମିର୍‌ ୱେନ୍‌ଜିନିଦେର୍‌, ଆକା ନାଦି ଆଏତ୍‍, ମାତର୍‌ ନା ପୋକ୍‌ତାତିମାନି ମାଲିକ୍‌ତି ବୁବାଦି । ");
INSERT INTO kfcp_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ନାନ୍ ମି ୱାଲେ ମାନ୍‌ଜି ମାନ୍‌ଜି ମିଙ୍ଗିଁ ଇୟାୱିଜୁ ମାଟା ୱେର୍‌ତା । ");
INSERT INTO kfcp_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ଆୟା ସାହାଜ୍ୟକିନିକାନ୍‌ ମାରି ପବିତ୍ର ଆତ୍ମା ଆମାତାନିଙ୍ଗ୍‌ ବୁବା ନା ଦର୍‌ତାନ୍‌ ପୋକ୍‌ତାନାନ୍‌, ୱାନ୍‌ ମିଙ୍ଗିଁ ୱିଜୁ ବିସୟ୍‌ତିଙ୍ଗ୍‌ ସିକିୟା ସିନାନ୍‌, ମାରି ନାନ୍ ମିଙ୍ଗିଁ ଆମା ଆମାକା ୱେର୍‌ତାମାନା, ଆୟାୱିଜୁ ମିଙ୍ଗିଁ ଏତ୍‌କିବିସ୍‌ କିନ୍‌ନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ନାନ୍ ମିଙ୍ଗିଁ ସାନ୍ତି ଦାନ୍‌ କିତା ସଲ୍‌ସିନା, ନା ନିଜେଦି ସାନ୍ତି ଦାନ୍‌ ମିଙ୍ଗିଁ ସିଜିନା; ଜଗତ୍‌ ଏଣ୍ତେସ୍‌ ଦାନ୍‌ କିନାତ୍‌, ନାନ୍ ମିଙ୍ଗିଁ ଆୟାୱାଜା ଦାନ୍‌ କିଏ । ମି ଜିବନ୍‌ ଦାନ୍ଦା ନି ତିଲାମାକିତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ନାନ୍ ସଲ୍‌ସିନା ମାରି ମି ଲାକ୍‌ତୁ ଡ଼େସି ୱାନା, ନା ଇୟା ମାଟା ତୋ ୱେର୍‌ଇମାନିଦେର୍‌ । ଜଦି ମିର୍‌ ନାଙ୍ଗିଁ ଜିବନ୍‌ନୋଜିମାରିଙ୍ଗ୍‌, ଆରିଙ୍ଗ୍‌ ନାନ୍ ନା ବୁବାଦି ଲାକ୍‌ତୁ ସଲ୍‌ସିନାନ୍‌ ଇଜି ୱେଡ଼ିକା ଆତିଦେର୍‌ମାନ୍ଧି, ଇରିଙ୍ଗ୍‌ ନା ବୁବା ନାମାଣ୍‌କୁ ପେରିକାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ମାରି, ଆକା ଗଟାନି ବେଡ଼ାଦୁ ମିର୍‌ ଏଣ୍ତେସ୍‌ ବିସ୍‌ବାସ୍‌ କିନିଦେର୍‌, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ଆକା ଗଟାନି ଆଗ୍‍ଡ଼ିନେ ନାନ୍ ଇଲେଇ ମିଙ୍ଗିଁ ୱେର୍‌ତାମାନା । ");
INSERT INTO kfcp_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ନାନ୍ ମି ୱାଲେ ମାରି ନାଣ୍ତ ସମୟ୍ ୱାର୍‌ଗିଜିସାଦେଙ୍ଗ୍‌ କେଏନି, ଇରିଙ୍ଗ୍‌ ଦୁନିଆଦି ପେରିକାନ୍‌ ୱାଜିନାନ୍‍; ମାରି, ନା ମୁସ୍‌କୁ ୱାନି ସାକ୍ତି ଇନିକା ସିଲେତ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ମାତର୍‌ ବୁବା ନାଙ୍ଗିଁ ଏଣ୍ତେସ୍‌ ଆଦେସ୍‌ ସିତାମାନାନ୍‌, ଆୟା ଇସାବ୍‌ତାନ୍‌ ନାନ୍ ପାଣି କିନା । ଆତିଙ୍ଗ୍‌, ନାନ୍ ନା ବୁବେଙ୍ଗ୍‌ ଜିବନ୍‌ନୋନା ଇଜି ଦୁନିଆ ନେସ୍‌ନାତ୍‌ । ନିଙ୍ଗିଁଦୁ, ମାଡ୍‌ ଇୟା ବାଡିଦାନ୍‌ ସନାଟ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","ନାନ୍ ସତେନେ ଅଙ୍ଗୁର୍‍ ତିୱା, ମାରି ମା ବୁବା ପାଣିକିନିକାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ନା ମାନୁ ମାନି ଆମା କମାଦୁ ପଲ୍‌ ଆସ୍‌ଏତିଙ୍ଗ୍‌, ଆୟାକା କାତ୍‌ନା ପୋକ୍‌ନାନ୍‌; ମାରି ଆମା କମାଦୁ ପଲ୍‌ ଆସ୍‌ନାତ୍‌, ଆବେନ୍‌ ନାଣ୍ତ ଆସ୍‌ତେଙ୍ଗ୍‌ ଇଜି ୱାନ୍‌ ତାନେଙ୍ଗ୍‌ କୟ୍‍ଜି ସେବା କିନ୍‌ନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ନାନ୍ ମିଙ୍ଗିଁ ଏମେ ବାକ୍ୟ ୱେର୍‌ତାମାନା, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ମିର୍‌ ନର୍‌ୟାଆତି ୱିସ୍‌ତିମାନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ନା ମାନୁ ମାନ୍‌ଡ଼୍ରୁ, ଆବେଟ୍‌ ନାନ୍ ମିମାନୁ ତେବାନା । ଏଣ୍ତେସ୍‌ କମା ଅଙ୍ଗୁର୍‍ ତିୱାଦୁ ମାନ୍‌ଏତିଙ୍ଗ୍‌ ନିଜେଦାନ୍‌ ପଲ୍‌ ଆସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‍ଏତ୍‍, ଆୟାୱାଜା ମିର୍‌ ବା ନା ମାନୁ ମାନ୍‌ଏତିଙ୍ଗ୍‌ ପଲ୍‌ ଆସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‍ଇଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","ନାନ୍ ଅଙ୍ଗୁର୍‍ ତିୱା, ମିର୍‌ କମେଙ୍ଗ୍‌, ଏନ୍‌ ନାମାନୁ ମାନ୍‌ନାନ୍‌ ମାରି ନାନ୍ ଏମାନୁ ମାନା, ୱାନ୍‌ ନାଣ୍ତ ପଲ୍‌ ଆସ୍‌ନାତ୍‌; ଇରିଙ୍ଗ୍‌ ନାଙ୍ଗିଁ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ମିର୍‌ ଇନିକା କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ଇଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ଏନ୍‌ ଏସ୍‌କାଙ୍ଗ୍‌ ନାମାନୁ ମାନ୍‌ଏନ୍‌, ଆରିଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ କାତ୍‌ନିମାନି କମେଙ୍ଗ୍‌ ୱାଜା ଆତେରେ ପୋକ୍‌ନାର୍‌ ମାରି ୱାର୍‌ନା ସୋନାତ୍‌, ଇୟାୱାଜା କମେଆଙ୍ଗାଁ ଲୋକୁ ଉଣ୍ତା କିଜି ସିସୁଦୁ ପୋକ୍‌ନାର୍‌ ମାରି ଆୟା କମେଙ୍ଗ୍‌ ୱେନ୍‌ସନ୍‌ନେ । ");
INSERT INTO kfcp_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ଜଦି ମିର୍‌ ନାମାନୁ ମାନ୍‌ଡ଼୍ରୁ, ମାରି ନା ବାକ୍ୟ ମିମାନୁ ମାନାତ୍‌, ଆରିଙ୍ଗ୍‌ ଆମା ବିସୟ୍‌ ବଦା କିନିଦେର୍‌, ଆକା ଲସ୍‌ତୁ, ମାରି ମି ଉଣ୍ତିଙ୍ଗ୍‌ ଆକା ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ମିର୍‌ ନାଣ୍ତ ପଲ୍‌ ଆସ୍‌ତିଙ୍ଗ୍‌ ମା ବୁବା ଦନ୍ୟବାଦ୍‌ ପୟ୍‌ନାନ୍‌, ମାରି ମିର୍‌ ନା ସତ୍‌ତି ସିସୁର୍‍ ଆନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ବୁବା ଏଣ୍ତେସ୍‌ୱାଜା ନାଙ୍ଗିଁ ଜିବନ୍‌ନୋତାମାନାନ୍‌, ନାନ୍ ବା ଆୟାୱାଜା ମିଙ୍ଗିଁ ଜିବନ୍‍ନୋତାମାନାନ୍‍; ନା ଜିବନ୍‌ନୋନିମାଣାନ୍‍ ତିର୍‌ ଆଜି ମାନ୍‌ଡ଼୍ରୁ । ");
INSERT INTO kfcp_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ନାନ୍ ଏଣ୍ତେସ୍‌ ମା ବୁବାଦି ମାଟାଦିଙ୍ଗ୍‌ ମାନାଜି ୱାନି ଜିବନ୍‍ନୋନିମାଣାନ୍‍ ତିର୍‌ ଆତାମାନା, ଆୟାୱାଜା ମିର୍‌ ଏସ୍‌କାଙ୍ଗ୍‌ ନା ମାଟାଦିଙ୍ଗ୍‌ ମାନାନିଦେର୍‌, ଆରିଙ୍ଗ୍‌ ନା ଜିବନ୍‌ନୋନିମାଣାନ୍‍ ତିର୍‌ ଆନି ତେବାନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ନା ୱେଡ଼ିକା ଏଣ୍ତେସ୍‌ ମି ମାନୁ ତେବାତାନ୍‌, ମାରି ମି ୱେଡ଼ିକା ଏଣ୍ତେସ୍‌ ବର୍ତି ଆନାତ୍‌, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ଇୟାୱିଜୁ ମିଙ୍ଗିଁ ୱେର୍‌ତା । ");
INSERT INTO kfcp_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ନାନ୍ ଏଣ୍ତେସ୍‌ ମିଙ୍ଗିଁ ଜିବନ୍‌ନୋତା ମାନା, ମିର୍‌ ବା ଆୟାୱାଜା ନିଜେନିଜେଦିଙ୍ଗ୍‌ ଜିବନ୍‌ନଦୁ, ଇକା ନା ଆଦେସ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ନିଜେଦି ସଙ୍ଗ୍‌ତିଲୋକା ଉଣ୍ତିଙ୍ଗ୍‌ ନିଜେଦି ଜିବନ୍‌ ସିନି ବାଦୁଲୁ ଏନ୍‌ ମାରି ନାଣ୍ତ ପେରି ଜିବନ୍‌ନୋନିକା ସିଲେତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ନାନ୍ ମିଙ୍ଗିଁ ଆମା ମାଟା ସିତାମାନା, ଆୟାକା ଜଦି ମାନାନିଦେର୍‌, ଆରିଙ୍ଗ୍‌ ମିର୍‌ ନା ସଙ୍ଗ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ନାନ୍ ମିଙ୍ଗିଁ ମାରି ସାକର୍‌ ଇଜି ଇନ୍‌ଏ, ଇରିଙ୍ଗ୍‌ ମାଲିକ୍‌ ଇନିକା କିନ୍‌ନାନ୍‌, ସାକର୍‌ ଆକା ନେସ୍‌ଏପ୍‌, ମାତର୍‌ ନାନ୍ ମିଙ୍ଗିଁ ସଙ୍ଗ୍‍ ଇଜି ଇର୍ହାମାନା, ଇରିଙ୍ଗ୍‌ ନାନ୍ ମା ବୁବାଦିମାଣ୍‌ନା ଇନି ଇନିକା ୱେର୍‌ଆମାନା, ଆୟାୱିଜୁ ମିଙ୍ଗିଁ ୱେର୍‌ତାମାନା । ");
INSERT INTO kfcp_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ମିର୍‌ ନାଙ୍ଗିଁ ଆସ୍‌କିଇଦେର୍‌, ମାତର୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଆସ୍‌କିତାମାନା, ମାରି ମିର୍‌ ଏଣ୍ତେସ୍‌ ସୋଲ୍‌ସ ପଲ୍‌ ଆସିସ୍‌କିଦୁ ମାରି ମି ପଲ୍‌ ତିର୍‍ ତେବାତାନ୍‌, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ମିଙ୍ଗିଁ ଆସ୍‌କିତାମାନା । ଆବେଟ୍‌ ମିର୍‌ ନା ଦର୍‌ତାନ୍‌ ବୁବେଙ୍ଗ୍‌ ଆମାକା ଲସ୍‌ନିଦେର୍‌, ୱାନ୍‌ ଆକା ମିଙ୍ଗିଁ ସିନାନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ମିର୍‌ ଏଣ୍ତେସ୍‌ ନିଜେନିଜେଦିଙ୍ଗ୍‌ ଜିବନ୍‌ନଦୁ, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଇୟାୱିଜୁ ମାଟା ସିଜିନା । ");
INSERT INTO kfcp_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ଜଦି ଜଗତ୍‌ ମିଙ୍ଗିଁ କାଡ଼୍‌ନାତ୍‌, ଆରିଙ୍ଗ୍‌ ମିଙ୍ଗିଁ କାଡ଼ିନି ଆଗ୍‌ଡ଼ି ଆକା ଜେ ନାଙ୍ଗିଁ କାଡ଼ିତା ମାନାତ୍‌, ଇକା ନେସ୍‌ତୁ । ");
INSERT INTO kfcp_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ମିର୍‌ ଜଦି ଇୟା ଦୁନିଆଦିକାର୍‌ ଆତିଦେର୍‌ ମାନ୍ଦି, ଆରିଙ୍ଗ୍‌ ଦୁନିଆ ମିଙ୍ଗିଁ ନିଜେଦିକାର୍‌ ଅଡ଼୍‍ବିଜି ଲାଡ୍‌ କିତାତ୍‌ମାନ୍ଦି; ମାତର୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଆସ୍‌କିଜି ଦୁନିଆଦାନ୍‌ ୱେର୍‌ଏ କିତାମାନା । ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ଦୁନିଆ ମିଙ୍ଗିଁ କାଡ଼୍‌ନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ସାକର୍‌ ନିଜେଦି ମାଲିକ୍‌ମାଣୁକୁ ପେରିକାନ୍‌ ଆଏନ୍‍, ନାନ୍ ମିଙ୍ଗିଁ ଇୟା ଏମେ ବାକ୍ୟ ୱେର୍‌ତାମାନା, ଆକା ଏତ୍‌କିଦୁ । ଜଦି ୱାର୍‌ ନାଙ୍ଗିଁ ନିଦା କିତାମାନାର୍‌, ଆର୍‌ତିଙ୍ଗ୍‌ ମିଙ୍ଗିଁ ବା ନିଦା କିନାର୍‌; ଜଦି ୱାର୍‌ ନା ବାକ୍ୟ ମାନାତାମାନାର୍‌, ଆରିଙ୍ଗ୍‌ ମି ବାକ୍ୟ ବା ମାନାନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ମାତର୍‌ ୱାର୍‌ ନା ପୋକ୍‌ତିମାନି ମାଲିକ୍‌ତିଙ୍ଗ୍‌ ନେସ୍‌ଏତିମାନିଙ୍ଗ୍‌ ନା ଦର୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ମିଙ୍ଗିଁ ଇୟାୱିଜୁ କିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ଜଦି ନାନ୍ ୱାଜ ୱାରିଙ୍ଗ୍‌ ଇନ୍‍ଏତି ମାରିଙ୍ଗ୍‌, ଆରିଙ୍ଗ୍‌ ୱାରି ପାପ୍‌ ଆଏତାତ୍‌ମାନ୍ଦି; ମାତର୍‌ ଇଲେଇ ୱାରି ପାପ୍‌ ବିସୟ୍‌ତାନ୍‌ ୱାରି ଇନି ସାଲାକି କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ଏନ୍‌ ନାଙ୍ଗିଁ କାଡ଼୍‌ନାନ୍‌, ୱାନ୍‌ ମା ବୁବେଙ୍ଗ୍‌ ବା କାଡ଼୍‌ନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ଏମେ ପାଣିୱିଜୁ ମାରି ଏନ୍‌ କିଏନ୍‌, ନାନ୍ ଜଦି ଆୟାୱିଜୁ ୱାରି ମାନୁ କିଏତାମାନ୍ଦି, ଆରିଙ୍ଗ୍‌ ୱାରି ପାପ୍‌ ଆଏତାତ୍‌ମାନ୍ଦି; ମାତର୍‌ ଇଲେଇ ୱାର୍‌ ସୁଡ଼ୁତାମାନାର୍‌, ମାରି ନାଙ୍ଗିଁ ମାରି ମା ବୁବେଙ୍ଗ୍‌ ରିଏରିଙ୍ଗ୍‌ବା କାଡ଼ିତାମାନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ମାତର୍‌ ୱାର୍‌ ମାଟାସିଲିକାବା ନାଙ୍ଗିଁ କାଡ଼ିତାର୍‌, ୱାରି ଦାର୍ମୁସାସ୍ତ୍ରଦୁ ରାସ୍‍ତିମାନି ଇୟା ବାକ୍ୟ ଏଣ୍ତେସ୍‌ ପୁରା ଆନାତ୍‌, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ଇୟାୱାଜା ଗଟାଜିନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","ବୁବାଦି ଲାକ୍‌ତୁରାନ୍‌ ନାନ୍ ମି ଲାକ୍‌ତୁ ଆମା ସାହାଜ୍ୟକିନିୱାନିଙ୍ଗ୍‌ ପୋକ୍‌ତାନା, ୱାନ୍‌ ବୁବାଦିମାଣାନ୍‍ ୱାନାତ୍‌, ଆୟା ସତ୍‌ତି ଆତ୍ମା ୱାତିଙ୍ଗ୍‍ ନା ବିସୟ୍‌ତାନ୍‌ ସାକିୟ ସିନାତ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ମାରି, ମିର୍‌ ନା ବିସୟ୍‌ତାନ୍‌ ସାକି ୱେର୍‌ନିଦେର୍‌, ଇରିଙ୍ଗ୍‌ ମିର୍‌ ଆଗିଡ଼ିରାନ୍‌ନେ ନା ୱାଲେ ମାନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","ମିର୍‌ ଏଣ୍ତେସ୍‌ ନିଜେଦି ବିସ୍‌ବାସ୍‌ ଆରାକିମାଟ୍‍, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଇୟାୱିଜୁ ମାଟା ୱେର୍‌ସିନା । ");
INSERT INTO kfcp_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ମିଙ୍ଗିଁ ଲୋକୁ ୱାରି କୁଟୁମ୍‌ତାନ୍‌ ସପ୍‍ନାର୍‍ ମାରି ଇୟାୱାଜା ଦିନ୍‌ ୱାଜିନାତ୍‍, ଏସ୍ତିୱାଲେ ଏନ୍‌ ମିଙ୍ଗିଁ ଡାକ୍‍ନାନ୍‍, ୱାନ୍‌ ମାପୁରୁଦି ଇସାବ୍‌ତାନ୍‌ ଇଜି ଏତ୍‌ କିନ୍‌ନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ମାରି, ୱାର୍‌ ଇୟାୱିଜୁ କିନାର୍‌, ଇରିଙ୍ଗ୍‌ ୱାର୍‌ ବୁବେଙ୍ଗ୍‌ ମାରି ନାଙ୍ଗିଁ ନେସ୍‌ଏର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ମାତର୍‌ ଏସ୍ତିୱାଲେ ଇୟାୱିଜୁ ଗଟାନି ବେଡ଼ା ଇଗାୱାନାତ୍‌, ନାନ୍ ମିଙ୍ଗିଁ ୱେର୍‌ତାମାର୍‌ଆ, ଇକା ଏଣ୍ତେସ୍‌ ମିର୍‌ ଏତ୍‌କିଦୁ, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ଇୟାୱିଜୁ ମାଟା ମିଙ୍ଗିଁ ୱେର୍‌ତାମାନା । ନାନ୍ ମି ୱାଲେ ମାନିଙ୍ଗ୍‌ ଆରାମ୍‌ତାନ୍‌ ଇୟାୱିଜୁ ମାଟା ମିଙ୍ଗିଁ ୱେର୍‌ଏତା ମାର୍‌ଆ । ");
INSERT INTO kfcp_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ମାତର୍‌ ଇଲେଇ ନାନ୍ ନା ପୋକ୍‌ତାତିମାନି ମାଲିକ୍‌ତି ଲାକ୍‌ତୁ ସୋଲ୍‌ସିନା, ମାତର୍‌ ମି ଲୋଇରାନ୍‌ ନାଙ୍ଗିଁ ଏନ୍‌ ୱେନ୍‍ବାଇଜିନିଦେର୍‌, ନିନ୍‌ ଏମେ ବାଡିଦୁ ସୋଲ୍‌ସିନି । ");
INSERT INTO kfcp_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ମାରି ନାନ୍ ମିଙ୍ଗିଁ ଇୟାୱିଜୁ ମାଟା ୱେର୍‌ତିମାନିଙ୍ଗ୍‌ ମି ଜିବନ୍‌ ଦୁଃକ୍‌ତାନ୍‌ ପୁରା ଆତାମାନାତ୍‌ ");
INSERT INTO kfcp_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ମାତର୍‌ ନାନ୍ ମିଙ୍ଗିଁ ସତ୍‌ ୱେର୍‌ସିନା, ନାନ୍ ସନିକା ମି ଉଣ୍ତିଙ୍ଗ୍‌ ନେଗେତ୍‌, ଇରିଙ୍ଗ୍‌ ନାନ୍ ସଲ୍‌ଏତିଙ୍ଗ୍‌ ଆୟା ସାହାଜ୍ୟକିନିକାନ୍‌ ମି ଲାକ୍‌ତୁ ରେଏନ୍‌, ମାତର୍‌ ନାନ୍ ସରିଇୱେନ୍‌କା ୱାନିଙ୍ଗ୍‌ ମି ଲାକ୍‌ତୁ ପୋକ୍‌ତାନା । ");
INSERT INTO kfcp_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ୱାନ୍‌ ୱାଜି ପାପ୍‌, ଦାର୍ମୁ ମାରି ମାପୁରୁଦି ନ୍ୟାୟ୍‍ବିସାର୍‌କିନି ବିସୟ୍‌ତାନ୍‌ ଜଗତ୍‌ତିଙ୍ଗ୍‌ ପାରାମାଣ୍‌ ସିନାତ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ପାପ୍‌ ବିସୟ୍‌ତାନ୍‌ ୱାର୍‌ ବୁଲ୍‌ ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ତର୍‌ନା ସିନାନ୍‌ ଜେ, ନା ମାନୁ ବିସ୍‌ବାସ୍‌ କିଏର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ଦାର୍ମୁଦି ବିସୟ୍‌ତାନ୍‌ ୱାର୍‌ ବୁଲ୍‌ ଇରିଙ୍ଗ୍‌ ନାନ୍ ବୁବାଦି ଲାକ୍‌ତୁ ସୋଲ୍‌ସିନା ମାରି ମିର୍‌ ନାଙ୍ଗିଁ ମାରି ସୁଡ଼ୁଇଦେର୍‌; ");
INSERT INTO kfcp_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ବିସାର୍‌ ବିସୟ୍‌ତାନ୍‌ ୱାର୍‌ ବୁଲ୍‌ ଇରିଙ୍ଗ୍‌ ଇୟା ଜଗତ୍‌ତି ପେରିକାନ୍‌ ବିସାର୍‌ ଆତାମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","ନାନ୍ ମିଙ୍ଗିଁ ମାରି ଗାଦି ମାଟେଙ୍ଗ୍‌ ଇନିକା ମାନାତ୍‌, ମାତର୍‌ ମିର୍‌ ଇଲେଇ ଆୟାୱିଜୁ ମାନାଦେଙ୍ଗ୍‌ ଆଟ୍‍ଇଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ମାତର୍‌ ଏସ୍ତିୱାଲେ ସତ୍‌ତି ଆତ୍ମା ୱାତିଙ୍ଗ୍‍, ନାସ୍ତିୱାଲେ ୱାଦ୍‌ ୱିଜୁ ସତ୍‌ ବୁଜାଦେଙ୍ଗ୍‌ ସାକ୍ତି ସିନାତ୍‌ । ୱାଦ୍‌ ନିଜେଦି ଅଦିକାର୍‌ତାନ୍‌ ଇନିକା ଇନ୍‌ଏତ୍‌ । ମାପୁରୁଦି ମାଣାନ୍‌ ୱାଦ୍‌ ଆମାକା ୱେର୍‌ଆ ମାନାତ୍‌, କେବଲ୍ ନାସନେ ୱାଦ୍‌ ୱେର୍‌ନାତ୍‌ । ଆମା ୱିଜୁ ଗଟାଦେଙ୍ଗ୍‌ ସୋଲ୍‌ସିନାତ୍‌ ୱାଦ୍‌ ମିଙ୍ଗିଁ ୱେର୍‌ନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ୱାନ୍‌ ନାଙ୍ଗିଁ ଦନ୍ୟବାଦ୍‌ କିନ୍‌ନାନ୍‌, ଇରିଙ୍ଗ୍‌ ନାନ୍ ଆମାକା ଇନା ୱାନ୍‌ ନାମାଣ୍‌କୁ ୱିଜୁ ସତ୍‌ତି ବିସୟ୍‌କୁ ଅସି ମିଙ୍ଗିଁ ୱେର୍‌ନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ଆମା ଆମାକା ବୁବାଦି, ଆୟାୱିଜୁ ନାଦି; ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ଇର୍ହା, ପବିତ୍ର ଆତ୍ମା ନାମାଣ୍‌କୁ ୱିଜୁ ବିସୟ୍‌ ଅସି ମିଙ୍ଗିଁ ୱେର୍‌ନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“କାଣ୍ତେକ୍‍ ବେଡ଼ା ମାନାତ୍‌, ମିର୍‌ ନାଙ୍ଗିଁ ମାରି ସୁଡ଼ୁଦେଙ୍ଗ୍‌ ଆଟ୍‍ଇଦେର୍‍, ମାରିଡ଼େସି ସାଣେକ୍‌ ୱେନ୍‌କା ମିର୍‌ ନାଙ୍ଗିଁ ସୁଡ଼ୁନିଦେର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ଆବେଟ୍‌ ୱାନି ସିସୁରି ଲୋଇରାନ୍‌ ଏନ୍‌ ଏନ୍‌ ନିଜେନିଜେ ଇର୍ହାର୍‌, କାଣ୍ତେକ୍‌ ବେଡ଼ା ମାନାତ୍‌, ମିର୍‌ ନାଙ୍ଗିଁ ସୁଡ଼ୁଇଦେର୍‌, ମାରିଡ଼େସି ସାଣେକ୍‌ ୱେନ୍‌କା ମିର୍‌ ନାଙ୍ଗିଁ ସୁଡ଼ୁନିଦେର୍‌ ମାରି ନାନ୍ ବୁବାଦି ଲାକ୍‌ତୁ ସୋଲ୍‌ସିନା, ଇୟା ଏମେ ମାଟା ୱାନ୍‌ ମାଙ୍ଗିଁ ୱେର୍‌ସିନାନ୍‌, ଇକା ଇନିକା ? ");
INSERT INTO kfcp_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ୱାର୍‌ ଇର୍ହାର୍‌, “କାଣ୍ତେକ୍‌ ବେଡ଼ା ଇଜି ଇକାନ୍‌ ଇନିକା ଇଜିନି ?” ୱାନ୍‌ ଇନିକା ୱେର୍‌ସିନାନ୍‌, ମାପ୍‌ ବୁଜାଦେଙ୍ଗ୍‌ ଆଟ୍‌ଏଜିନାପ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ସିସୁର୍‍ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାଦେଙ୍ଗ୍‌ ବଦା କିଜିନାର୍‌ ଇଜି ନେସ୍‌ତାନ୍‌ନୋ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, କାଣ୍ତେକ୍‌ନେ ବେଡ଼ା ମାନାତ୍‌, ମିର୍‌ ନାଙ୍ଗିଁ ସୁଡ଼ୁଇଦେର୍‌, ମାରିଡ଼େସି ସାଣେକ୍‌ ମାର୍‌ଇ ୱେନ୍‌କା ମିର୍‌ ନାଙ୍ଗିଁ ସୁଡ଼ୁନିଦେର୍‌, ନାନ୍ ଏମେ ଇୟା ମାଟା ୱେର୍‌ତା, ଆୟା ବିସୟ୍‌ତାନ୍‌ ଅସି ମିର୍‌ ଇନିକା ନିଜେନିଜେଦିମାନୁ ୱାର୍‌ଗିଜି ସାଜିନିଦେର୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ସତ୍‌ ସତ୍‍ନେ ନାନ୍ ମିଙ୍ଗିଁ ୱେର୍‌ସିନା, ମିର୍‌ ଆଡ଼ାବାନିଦେର୍‌ ମାରି ଏତ୍‌କିଜି କିଜି ଆଡ଼୍‌ବାନିଦେର୍‌, ମାତର୍‌ ଜଗତ୍‌ ୱେଡ଼ିକା ଆନାତ୍‌; ମିର୍‌ ଦୁଃକ୍‌ଆନିଦେର୍‌, ମାତର୍‌ ମି ଦୁଃକ୍‌ ୱେଡ଼ିକାଦୁ ମିସାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ଜନମ୍‌କିନି ବେଡ଼ା ଇଗା ୱାତିଙ୍ଗ୍‍ ଆଇମା ଦୁଃକ୍‌ ପୟ୍‌ନାତ୍‌, ମାତର୍‌ ୱାନି କଡ଼ ଜନମ୍‌ ଆତି ୱେନ୍‌କା ଦୁନିଆଦୁ ଅରେନ୍‍ ଲୋକୁ ଜନମ୍‌ ଆତାନ୍‌, ଇୟା ୱେଡ଼ିକା ଉଣ୍ତିଙ୍ଗ୍‌ ମାରି କାସ୍ଟୁ ଏତ୍‌ କିଏତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ଆୟାୱାଜା ମିର୍‌ ଇଲେଇ ଦୁଃକ୍‌ ପୟ୍‌ଜିନିଦେର୍‌, ମାତର୍‌ ନାନ୍ ମାରିଡ଼େସି ମିଙ୍ଗିଁ ତରାୟାଆନା, ମାରି ମି ଜିବନ୍‌ ୱେଡ଼ିକା ଆନାତ୍‌ ମାରି ଏନ୍‌ ମିମାଣୁକୁ ମି ୱେଡ଼ିକା ଡଙ୍ଗାଁକିଜ ଅଏନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ଆୟାନାଣ୍ତିଙ୍ଗ୍‌ ୱାତିଙ୍ଗ୍‍, ନାମାଣାନ୍‌ ମିଙ୍ଗିଁ ମାରି ଇନିକା ଲସ୍‌ତେଙ୍ଗ୍‌ ପଡ଼ାଏତ୍‌ । ସତ୍‌ ଇଜିନା, ନା ଦର୍‌ତାନ୍‌ ବୁବା ମାପୁରୁଙ୍ଗୁଁ ଆମାକା ଲସ୍‌ନିଦେର୍‌, ୱାନ୍‌ ଆକା ସିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ଇୟାସାନ୍ଦି ମିର୍‌ ନା ଦର୍‌ତାନ୍‌ ଇନିକା ଲସ୍‌ଇଦେର୍‌; ଇଲେଇ ଲସ୍‌ତୁ, ମାରି ମି ୱେଡ଼ିକା ଏଣ୍ତେସ୍‌ ପୁରୁନ୍‌ ଆନାତ୍‌, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ମିର୍‌ ଆକା ପୟ୍‌ନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","ନାନ୍ ମିଙ୍ଗିଁ କାତାଦାନ୍‌ ଇୟାୱିଜୁ ମାଟା ୱେର୍‌ତାମାନା; ବେଡ଼ା ୱାଜିନାତ୍‍, ଏସ୍ତିୱାଲେ ନାନ୍ ମାରି କାତାଦାନ୍‌ ମିଙ୍ଗିଁ ୱେର୍‌ଏ, ମାତର୍‌ ବୁବାଦି ବିସୟ୍‌ ବୁଜାନିୱାଜା ମିଙ୍ଗିଁ ୱେର୍‌ନା । ");
INSERT INTO kfcp_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ଆୟାନାଣ୍ତିଙ୍ଗ୍‌ ମିର୍‌ ନା ଦର୍‌ତାନ୍‌ ୱାନିଙ୍ଗ୍‌ ଲସ୍‌ନିଦେର୍‌; ମାରି, ନାନ୍ ଜେ ମି ତରିଟାନ୍‌ ବୁବେଙ୍ଗ୍‌ ୱେର୍‌ନା, ଇକା ନାନ୍ ମିଙ୍ଗିଁ ଇନ୍‌ଏ; ");
INSERT INTO kfcp_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ଇରିଙ୍ଗ୍‌ ବୁବା ନିଜେ ମିଙ୍ଗିଁ ଜିବନ୍‌ନୋନାନ୍‌, ଆଦେଙ୍ଗ୍‌ ମିର୍‌ ନାଙ୍ଗିଁ ଜିବନ୍‌ନୋତିମାନିଦେର୍‌ ମାରି ନାନ୍ ଜେ ମାପୁରୁଦି ଲାକ୍‌ତୁରାନ୍‌ ୱାତାମାନା, ଆକା ମିର୍‌ ବିସ୍‌ବାସ୍‌ କିତିମାନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ନାନ୍ ବୁବାଦି ଲାକ୍‌ତୁରାନ୍‌ ଦୁନିଆଦୁ ୱାତାମାନା; ମାରିଡ଼େସି ନାନ୍ ଦୁନିଆ ଡ଼ିସ୍‌ସି ବୁବାଦି ଲାକ୍‌ତୁ ସୋଲ୍‌ସିନା । ");
INSERT INTO kfcp_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ଇୟା ମାଟା ୱେନ୍‌ଞ୍ଜି ସିସୁର୍‍ ଇର୍ହାର୍‌, ସୁଡ଼ୁଦୁ, ଇଲେଇ ନିନ୍‌ ବୁଜାନିୱାଜା ୱେର୍‌ସିନି ମାରି କାତାଦାନ୍‍ ମାଟା ମାରି ୱେର୍‌ଇ । ");
INSERT INTO kfcp_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ଇଲେଇ ମାପ୍‌ ନେସ୍‌ନାପ୍‌; ନିନ୍‌ ୱିଜୁ ବିସୟ୍‌ ନେସ୍‌ନି ମାରି ନିନ୍‌ ଏଙ୍ଗ୍‌ ଇନି ବିସୟ୍‌ ୱେନ୍‍ବାଦେଙ୍ଗ୍‌ ଦର୍‌କାର୍‌ ସିଲେତ୍‌ । ମାପୁରୁଦି ଲାକ୍‌ତୁରାନ୍‌ ନିନ୍‌ ୱାତିମାନି ଇଜି ମାପ୍‌ ଇୟାମାଣୁକୁ ବିସ୍‌ବାସ୍‌ କିଜିନାପ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ୱେର୍‌ତାନ୍‌, ମିର୍‌ ଇନିକା ଇଲେଇ ବିସ୍‌ବାସ୍‌ କିଜିନିଦେର୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ସୁଡ଼ୁଦୁ, ବେଡ଼ା ୱାଜିନାତ୍‍, ହୁଁ, ୱାତାତ୍‌ନି, ଏସ୍ତିୱାଲେ ମିର୍‌ ଇନିଙ୍ଗାଁ ଆନିଙ୍ଗାଁ ଆଜି ୱିଜେରେ ନିଜେ ନିଜେଦି ଇଲ୍‌କାଙ୍ଗ୍‌ ସନିଦେର୍‌, ମାରି ନାଙ୍ଗିଁ ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ଡ଼ିସ୍‌ନିସନିଦେର୍‌; ଆରିଙ୍ଗ୍‍ବା ନାନ୍ ଅରେନ୍‌ନେ ସିଲେ, ଇରିଙ୍ଗ୍‌ ବୁବା ନା ୱାଲେ ମାନ୍‌ନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ମିର୍‌ ଏଣ୍ତେସ୍‌ ନା ୱାଲେ ମାନ୍‌ଞ୍ଜି ସାନ୍ତି ପୟ୍‌ନିଦେର୍‌, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ମିଙ୍ଗିଁ ଇୟାୱିଜୁ ବିସୟ୍‌ ୱେର୍‌ତାମାନା । ଜଗତ୍‌ଦୁ ମି ଉଣ୍ତିଙ୍ଗ୍‌ କାସ୍ଟୁ ମାନାତ୍‌, ମାତର୍‌ ସାସ୍‌ ଆସ୍‌ତୁ, ନାନ୍ ଜଗତ୍‌ତିଙ୍ଗ୍‌ ଜିଣାକିତାମାନା । ");
INSERT INTO kfcp_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ଜିସୁ ଇୟାୱିଜୁ ମାଟା ଇନ୍‌ଜି ମୁସ୍‌କୁପୁର୍‌ତରିନ୍‌ ସୁଡ଼ୁଜି ଇର୍ହାନ୍‌, ବୁବା, ବେଡ଼ା ଇଗା ୱାତାତ୍‌ନି; ନି ମାରିନ୍‌ତିଙ୍ଗ୍‌ ଗୌରବ୍‍ କିଆ, ଏଣ୍ତେସ୍‌ ମାରିନ୍‌ ବା ନିଙ୍ଗିଁ ଦନ୍ୟବାଦ୍‌ କିନ୍‌ନାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ଏଣ୍ତେସ୍‌ୱାଜା ନିନ୍‌ ୱାନିଙ୍ଗ୍‌ ଆମା ଲୋକାଙ୍ଗ୍‌ ୱାନି କିୟୁଦୁ ସିତିମାନି, ୱାରିଙ୍ଗ୍‌ ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜ୍‌ଇ ଜିବନ୍‌ ସିନି ଉଣ୍ତିଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ ୱିଜୁ ଦୁନିଆଦି ମୁସ୍‌କୁ ଅଦିକାର୍‌ ସିତି । ");
INSERT INTO kfcp_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ମାରି, ନିନ୍‌ ଜେ ଅରେନ୍‌ମାତର୍‌ ସତ୍‌ତି ମାପୁରୁ, ନିଙ୍ଗିଁ ମାରି ଆମାୱାନିଙ୍ଗ୍‌ ନିନ୍‌ ପୋକ୍‌ତାତିମାନି, ଆୟା ଜିସୁ କ୍ରିସ୍ତଙ୍ଗ୍‌ ନେସ୍‌ନିକାନେ ଏସ୍‌କାଙ୍ଗ୍‌ୱିଜିଇ ଜିବନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ନିନ୍‌ ନାଙ୍ଗିଁ ଏମେ ପାଣି କିଦେଙ୍ଗ୍‌ ସିତିମାନି, ଆକା ନାନ୍ ୱିସ୍‌ତାନୋ ଦୁନିଆଦୁ ମିଙ୍ଗିଁ ଦନ୍ୟବାଦ୍‌ କିତାମାନା । ");
INSERT INTO kfcp_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ମାରି ଇଲେଇ, ଏ ବୁବା, ଦୁନିଆ ତିଆର୍‌ଆତି ପୁର୍ବେନେ ନି ୱାଲେ ନା ଏମେ ମହିମା ମାର୍ହାତ୍‌, ଇଲେଇ ନିନ୍‌ ମାନିମାନୁ ଆୟା ମହିମା ନାଙ୍ଗିଁ ସିଦା । ");
INSERT INTO kfcp_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","ନିନ୍‌ ନାଙ୍ଗିଁ ଦୁନିଆଦି ମାଣ୍‌କୁ ଆମା ଲୋକାଙ୍ଗ୍‌ ଦାନ୍‌ କିତିମାନି, ନାନ୍ ୱାରି ଲାକ୍‌ତୁ ନି ଦର୍‌ ୱେର୍‌ତାମାନା; ୱାର୍‌ ନି ଲୋକ୍‌ ମାରି ନିନ୍‌ ୱାରିଙ୍ଗ୍‌ ନାଙ୍ଗିଁ ଦାନ୍‌ କିତିମାନି, ୱାର୍‌ ନି ବାକ୍ୟ ମାନାତାମାନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ନିନ୍‌ ନାଙ୍ଗିଁ ଆମା ଆମାକା ଦାନ୍‌ କିତିମାନି, ଆୟାୱିଜୁ ଜେ ନିମାଣୁକୁ ୱାତାମାନାତ୍‌, ଇକା ୱାର୍‌ ଇଲେଇ ବୁଜାତାମାନାର୍‌; ");
INSERT INTO kfcp_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ଇରିଙ୍ଗ୍‌ ନିନ୍‌ ନାଙ୍ଗିଁ ଆମାୱିଜୁ ମାଟା ଦାନ୍‌ କିତିମାନି, ନାନ୍ ୱାରିଙ୍ଗ୍‌ ଆୟାୱିଜୁ ଦାନ୍‌ କିତାମାନା, ମାରି ୱାର୍‌ ମାନାତାମାନାର୍‌, ମାରି ନାନ୍ ଜେ ନି ଲାକ୍‌ତୁରାନ୍‌ ୱାତାମାନା, ଆକା ସତ୍‌ତାନ୍‌ ନେସ୍‌ତାମାନାର୍‌ ମାରି ନିନ୍‌ ନାଙ୍ଗିଁ ପୋକ୍‌ତାତିମାନି ଇଜି ବିସ୍‌ବାସ୍‌ କିତାମାନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","ନାନ୍ ୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ପାର୍‌ତନା କିଜିନା, ଜଗତ୍‌ଦି ଉଣ୍ତିଙ୍ଗ୍‌ ପାର୍‌ତନା କିଏ, ମାତର୍‌ ନିନ୍‌ ନାଙ୍ଗିଁ ଆମାୱାରିଙ୍ଗ୍‌ ସିତିମାନି, ୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ପାର୍‌ତନା କିଜିନା, ଇରିଙ୍ଗ୍‌ ୱାର୍‌ ନି ଲୋକ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ଆମା ଆମାକା ନାଦି, ଆୟାୱିଜୁ ନିଦି, ମାରି ଆମା ଆମାକା ନିଦି, ଆୟାୱିଜୁ ନାଦି, ମାରି, ନାନ୍ ୱାରିମାଣାନ୍‌ ଦନ୍ୟବାଦ୍‌ ଆତାମାନା । ");
INSERT INTO kfcp_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ନାନ୍ ମାରି ଇୟା ଜଗତ୍‌ଦୁ ମାନ୍‌ଏ, ମାତର୍‌ ଇୟାକାର୍‌ ଜଗତ୍‌ଦୁ ମାନ୍‌ଜିନାର୍‌; ମାରି, ନାନ୍ ନି ଲାକ୍‌ତୁ ସୋଲ୍‌ସିନା । ପବିତ୍ର ବୁବା, ନିନ୍‌ ସିତିମାନି ଦର୍‌ତି ସକ୍ତିଦାନ୍‌ ୱାରିଙ୍ଗ୍‌ ରକିୟା କିଆ, ଏଣ୍ତେସ୍‌ ନିନ୍‌ ମାରି ନାନ୍ ଅରେନ୍‌ନେ, ୱାର୍‌ ଆୟାୱାଜା ଉନ୍‌ଡ୍ରେମାନୁ ଆଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ୱାରି ୱାଲେ ମାନ୍‌ଜିମାର୍‌ଇ ୱାଲେ ନାନ୍ ୱାରିଙ୍ଗ୍‌ ନି ଦର୍‌ତି ସାକ୍ତିଦାନ୍ ରକ୍‌ୟା କିଜି ୱାଜିନା, ମାରି ନାନ୍ ୱାରିଙ୍ଗ୍‌ ନେଗ୍‌ନେତାନ୍‌ ରକିୟା କିତାମାନା ମାରି ଦାର୍ମୁସାସ୍ତ୍ରଦି ବାକ୍ୟ ଏଣ୍ତେସ୍‌ ପୁରା ଆନାତ୍‌, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ସାନି ମାରିନ୍‌ତିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ସି ୱାରି ମାଣ୍‌କୁ ଅରେନ୍‍ ଏନ୍‌ବା ନାସ୍ଟୁ ଆଏର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ମାତର୍‌ ନାନ୍ ଇଲେଇ ନି ଲାକ୍‌ତୁ ୱାଜିନା, ମାରି ୱାରି ଜିବନ୍‌ତୁ ନା ୱେଡ଼ିକା ଏଣ୍ତେସ୍‌ ପୁରା ଆନାତ୍‌, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ଦୁନିଆଦୁ ମାନ୍‌ଜି ନାନ୍ ଇୟାୱିଜୁ ୱେର୍‌ସିନା । ");
INSERT INTO kfcp_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ନାନ୍ ୱାରିଙ୍ଗ୍‌ ନି ବାକ୍ୟ ସିତାମାନା, ମାରି ଇୟା ଦୁନିଆ ୱାରିଙ୍ଗ୍‌ କାଡ଼ିତା ମାନାତ୍‌, ଇରିଙ୍ଗ୍‌ ନାନ୍ ଏଣ୍ତେସ୍‌ ଇୟା ଦୁନିଆଦାନ୍‌ ସିଲେ, ଆୟାୱାଜା ୱାନ୍‌ ବା ଇୟା ଦୁନିଆଦାନ୍‌ ସିଲେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ନିନ୍‌ ୱାରିଙ୍ଗ୍‌ ଦୁନିଆଦାନ୍‌ ଅନିଉଣ୍ତିଙ୍ଗ୍‌ ପାର୍‌ତନା କିଏ, ମାତର୍‌ ୱାରିଙ୍ଗ୍‌ ତାଗ୍‌ଇ ପାଣିଦାନ୍‌ ରକ୍‌ୟା କିଦୁ ଇଜି ପାର୍‌ତନା କିଜିନା । ");
INSERT INTO kfcp_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ନାନ୍ ଏଣ୍ତେସ୍‌ ଦୁନିଆଦିକିନ୍ଦା ସିଲେ, ୱାର୍‌ ଆୟାୱାଜା ଇୟା ଦୁନିଆଦିକାର୍‌ ଆଏର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ସତ୍‌ତାନ୍‌ ୱାରିଙ୍ଗ୍‌ ପବିତ୍ର କିଦୁ; ନି ବାକ୍ୟନେ ତୋ ସତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ନିନ୍‌ ନାଙ୍ଗିଁ ଏଣ୍ତେସ୍‌ ଦୁନିଆଦୁ ପୋକ୍‌ତାତିମାନି, ନାନ୍ ବା ୱାରିଙ୍ଗ୍‌ ଆୟାୱାଜା ଦୁନିଆଦୁ ପୋକ୍‌ତାତାମାନା । ");
INSERT INTO kfcp_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ମାରି, ୱାନ୍‌ ବା ଏଣ୍ତେସ୍‌ ସତ୍‌ତାନ୍‌ ପବିତ୍ର ଆନାର୍‌, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ନିଜେଦିଙ୍ଗ୍‌ ପବିତ୍ର କିଜିନା । ");
INSERT INTO kfcp_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","ନାନ୍ କେବଲ୍‌ ଇୟାୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ପାର୍‌ତନା କିଏଜିନା, ମାତର୍‌ ଇୟାୱାରି ବାକ୍ୟଦାନ୍‌ ଆମାକାର୍‌ ନା ମାନୁ ବିସ୍‌ବାସ୍‌ କିନାର୍‌, ୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ବା ପାର୍‌ତନା କିଜିନା, ");
INSERT INTO kfcp_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ୱିଜେରି ଉଣ୍ତିଙ୍ଗ୍‌ ପାର୍‍ତନା କିଜିନା, ଏଣ୍ତେସ୍‌ ୱାର୍‌ ୱିଜେରେ ଉନ୍‌ଡ୍ରେମାନୁ ଆନାର୍‌; ଏ ବୁବା, ନିନ୍‌ ଏଣ୍ତେସ୍‌ ନା ମାନୁ ମାନି ମାରି ନାନ୍ ନି ମାନୁ ମାନା, ୱାନ୍‌ ବା ଆୟାୱାଜା ମାମାନୁ ମାନିର୍‌, ଏଣ୍ତେସ୍‌ ନିନ୍‌ ନାଙ୍ଗିଁ ପୋକ୍‌ତାତିମାନି ଇଜି ଦୁନିଆ ବିସ୍‌ବାସ୍‌ କିନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ମାରି, ନିନ୍‌ ନାଙ୍ଗିଁ ଆମା ମହିମା ସିତିମାନି, ନାନ୍ ୱାରିଙ୍ଗ୍‌ ଆକା ସିତାମାନା, ଏଣ୍ତେସ୍‌ ନିନ୍‌ ମାରି ନାନ୍ ଅରେନ୍‌ନେ, ଆୟାୱାଜା ୱାନ୍‌ ବା ଉନ୍‌ଡ୍ରେମାନୁ ଆଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ନାନ୍ ୱାରିମାନୁ, ମାରି ନିନ୍‌ ନା ମାନୁ, ଏଣ୍ତେସ୍‌ ୱାର୍‌ ପୁରାଦାନ୍‌ ଉନ୍‌ଡ୍ରେମାନୁ ଆଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାର୍‍, ଆରିଙ୍ଗ୍‌ ଇୟା ଜଗତ୍‌ ନେସ୍‌ନାତ୍‌ ଜେ, ନିନ୍‌ ନାଙ୍ଗିଁ ପୋକ୍‌ତାତିମାନି, ମାରି ନାଙ୍ଗିଁ ଏଣ୍ତେସ୍‌ୱାଜା ଜିବନ୍‌ନୋତିମାନି, ୱାରିଙ୍ଗ୍‌ ବା ଆୟାୱାଜା ଜିବନ୍‌ନୋତି । ");
INSERT INTO kfcp_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“ଏ ବୁବା, ନିନ୍‌ ନାଙ୍ଗିଁ ଏମେ ଲୋକାଙ୍ଗ୍‌ ସିତିମାନି, ନାନ୍ ଏମେମାନୁ ମାନା, ୱାନ୍‌ ବା ଏଣ୍ତେସ୍‌ ଆବେନ୍‌ ନା ୱାଲେ ମାନାର୍‌ ମାରି ଦୁନିଆ ତିଆର୍‌ଆତି ଆଗ୍‍ଡ଼ିରାନ୍‍ନେ ନିନ୍‌ ନାଙ୍ଗିଁ ଜିବନ୍‌ ନୋତିମାନିଙ୍ଗ୍‌ ନାଙ୍ଗିଁ ଆମା ଗୌରବ୍‌ ସିତିମାନି, ନା ଆୟା ଗୌରବ୍‌ ୱାର୍‌ ଏଣ୍ତେସ୍‌ ସୁଡ଼ୁନାଟ୍‌, ଇକା ନା ବଦା । ");
INSERT INTO kfcp_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ଏ ଦାର୍ମୁଦି ବୁବା, ଜଗତ୍‌ ନିଙ୍ଗିଁ ନେସ୍‌ଏତ୍‌, ମାତର୍‌ ନାନ୍ ନିଙ୍ଗିଁ ନେସ୍‌ତାମାନା; ମାରି, ନିନ୍‌ ଜେ ନାଙ୍ଗିଁ ପୋକ୍‌ତାତିମାନି, ଇକା ଇୟାକାର୍‌ ନେସ୍‌ତାମାନାର୍‌; ");
INSERT INTO kfcp_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ମାରି, ନିନ୍‌ ନାଙ୍ଗିଁ ଆମା ଜିବନ୍‌ନୋତିମାନୁ ଜିବନ୍‌ନୋତିମାନି, ଆକା ଏଣ୍ତେସ୍‌ ୱାରି ମାନୁ ତେବାନାତ୍‍ ମାରି ନାନ୍ ୱାରିମାନୁ ତେବାନା, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ୱାରିଙ୍ଗ୍‌ ନି ଦର୍‌ ୱେର୍‌ତାମାନା ମାରି ୱେର୍‌ନା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ଜିସୁ ଇୟା ପାର୍‍ତନା ୱିସ୍‌ଇ ସିସୁରି ୱାଲେ କିଦ୍ରୋଣ୍‌ ଜଲାଦି ଆୟାପାଡ଼୍‌କା ସୋର୍ହାର୍‌ । ଆବେନୁ ଉନ୍‌ଡ୍ରି ଡଡି ମାର୍ହାତ୍‌, ମାରି ୱାନ୍‌ ନି ୱାନି ସିସୁର୍‍ ଆବେନୁ ଡ଼ୁଗିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ଆମା ଜିହୁଦା ଜିସୁଙ୍ଗୁଁ ସାତ୍ରୁରି କିୟୁଦୁ ସର୍‌ପେ କିତାନ୍‌, ୱାନ୍‌ ବା ଆୟାବାଡି ନେସ୍‌ତା ମାର୍ହାନ୍‌, ଇରିଙ୍ଗ୍‌ ଜିସୁ ନାଣ୍ତ ଦେବେଙ୍ଗ୍‌ ନିଜେଦି ସିସୁରି ୱାଲେ ଆୟାବାଡିଦୁ ସୋଲ୍‌ସିମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ମାରି, ଜିହୁଦା ସନ୍ୟରିଦଲ୍‌ ମାରି ପେରି ଜାଜକର୍‌ ମାରି ପାରୁସିରିମାଣୁକୁ ମନ୍ଦିର୍‌ କାପ୍‍କିନିୱାରିଙ୍ଗ୍‌ ଅସି ଦିୱା, ମସାଲ୍‌ ମାରି ସାଜୁମାଜୁ ଆସ୍‌ସି ଆବେନୁ ୱାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ଆବେଟ୍‌ ଜିସୁ, ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ଆମା ଆମାକା ଗଟାଦେଙ୍ଗ୍‌ ସୋଲ୍‌ସିନାତ୍‌, ଆୟାୱିଜୁ ନେସ୍‌ତାନ୍‌ନୋ ଆଗ୍‌ଡ଼ି ସୋଲ୍‌ସି ୱାରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ମିର୍‌ ଏଙ୍ଗ୍‌ ପୟ୍‌ଜିନିଦେର୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ନାଜରିୟତିୟ ଜିସୁଙ୍ଗୁଁ ।” ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନାନ୍ ଆୟା ଜିସୁ ।” ଆମା ଜିହୁଦା ୱାନିଙ୍ଗ୍‌ ସାତ୍ରୁରି କିୟୁଦୁ ସର୍‌ପେ କିତାନ୍‌, ୱାନ୍‌ ବା ୱାରି ୱାଲେ ନିର୍‌ଆମାର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ଜିସୁ ଏସ୍ତିୱାଲେ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନାନ୍ ଆୟାକାନ୍‌,” ନାସ୍ତିୱାଲେ ୱାର୍‌ ୱେନ୍‌କା ଗୁସାଜିସୋଲ୍‌ସି ବୁମିଦୁ ଆର୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ଆବେଟ୍‌ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ମାରି ଅର୍‍ସୁ ୱେନ୍‌ବାତାନ୍‌, “ମିର୍‌ ଏଙ୍ଗ୍‌ ପୟ୍‌ଜିନିଦେର୍‌ ?” ୱାର୍‌ ଇର୍ହାର୍‌, ନାଜରିୟତିୟ୍‌ ଜିସୁଙ୍ଗୁଁ । ");
INSERT INTO kfcp_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ଜିସୁ ଇର୍ହାନ୍‌, “ନାନ୍‌ନେ ଆୟାକାନ୍‌,” ଇକା ତୋ ନାନ୍ ମିଙ୍ଗିଁ ୱେର୍‌ତା । “ଜଦି ମିର୍‌ ନାଙ୍ଗିଁ ପୟ୍‌ଜିନିଦେର୍‌, ଆରିଙ୍ଗ୍‌ ଇୟାୱାରିଙ୍ଗ୍‌ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଡ଼ିସ୍‌ତୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ୱାନ୍‌ ଇକା ଇର୍ହାନ୍‌, ଏଣ୍ତେସ୍‌ ୱାନ୍‌ ଇର୍ହିମାର୍‌ଇ ଇୟା ବାକ୍ୟ ପୁରା ଆନାତ୍‌, ନିନ୍‌ ନାଙ୍ଗିଁ ଆମାୱାରିଙ୍ଗ୍‌ ସିତିମାନି, ୱାରି ମାଣ୍‌କୁ ନାନ୍ ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ବା ଆରାକିଏ । ");
INSERT INTO kfcp_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ସିମୋନ ପିତର୍‌ ଲାକ୍‌ତୁ ଉନ୍‌ଡ୍ରି କାଆଣ୍ତା ମାର୍ହାତ୍‌, ଆୟା କାଆଣ୍ତା ସୋପ୍‌ତାନ୍‌ନୋ ୱିଜେରିଙ୍ଗ୍‌ ପେରିଜାଜକରି ସାକର୍‌ତିଙ୍ଗ୍‌ କାତ୍‌ତାନ୍‌ ମାରି ଆୟା ସାକର୍‌ତି ଉଣେରି ଗିତ୍‌ଣି କୟ୍‌ତାପୋକ୍‌ତାନ୍‌; ଆୟା ସାକର୍‌ତି ଦର୍‌ ମାଲ୍‌କ । ");
INSERT INTO kfcp_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ଆବେଟ୍‌ ଜିସୁ ପିତରତିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନିନ୍‌ କାଣ୍ତାଦିଙ୍ଗ୍‌ ଇଡ଼୍‌ନିବାଡିଦୁ ଇଡିଆ; ବୁବା ନାଙ୍ଗିଁ ଏମେ ଡୁବାଇ ସିତାମାନ୍‌ନାନ୍‌, ନାନ୍ ଇନିକା ଆବେଣ୍‌କୁ ଉଣୁଏନୋ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ଇୟା ୱେନ୍‌କା ରମିୟ ସନ୍ୟରିଦଲ୍‌, ପେରି ସେନାପତିର୍‌, ମାରି ଜିହୁଦିରିଙ୍ଗ୍‌ କାପ୍‍କିନିକାର୍‌ ଜିସୁଙ୍ଗୁଁ ଆସ୍‌ସି ତର୍‌ତାର୍‌ ");
INSERT INTO kfcp_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ମାରି ୱାନିଙ୍ଗ୍‌ ଆଗ୍‌ଡ଼ି ହାନାନଦି ଲାକ୍‌ତୁ ଅତାର୍‍, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ଆୟା ବାର୍ସେକ୍‌ତି ୱିଜେରିଙ୍ଗ୍‌ ପେରିଜାଜକ୍‌ କୟାପାଦି ପତେଲ୍‌ସି ମାର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ଇୟା କୟାପା ଆଗ୍‌ଡ଼ି ଜିହୁଦି ନେତାର୍‌ ୱେର୍‌ତା ମାର୍ହାନ୍‌, ୱିଜୁ ଲୋକା ନେଗି ଉଣ୍ତିଙ୍ଗ୍‌ ଅରେନ୍‍ ସାନିକା ନେଗେତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ସିମୋନ ପିତର୍‌ ନି ମାରି ଅରେନ୍‍ ସିସୁ ଜିସୁଦି ୱାଲେ ୱାଲେ ସୋଲ୍‌ସିମାର୍ହାନ୍‌ । ଆୟା ସିସୁ ୱିଜେରିଙ୍ଗ୍‌ ପେରିଜାଜକ୍‌ଦିଙ୍ଗ୍‌ ନେସ୍‌ତିକାନ୍‌ ମାର୍ହାନ୍‌ ମାରି ଜିସୁଦି ୱାଲେ ୱିଜେରିଙ୍ଗ୍‌ ପେରିଜାଜକଦି ଦୁଆର୍‌ତୁ ଡ଼ୁଗିତାର୍‌; ");
INSERT INTO kfcp_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ମାତର୍‌ ପିତର୍‌ ଆତେରେ ଡେୱା ଲାକ୍‌ତୁ ନିର୍‌ଆ ମାର୍ହାନ୍‌ । ମାରି, ଆୟା ଏମେ ଆଇ ସିସୁ ୱିଜେରିଙ୍ଗ୍‌ ପେରିଜାଜକଦିଙ୍ଗ୍‌ ନେସ୍‌ତିକାନ୍‌ ମାର୍ହାନ୍‌, ୱାନ୍‌ ଆତେରେ ସୋର୍‌ର୍ହାନ୍‌ନୋ ଡେୱାଦୁ କାପ୍‍କିନିୱାନିଙ୍ଗ୍‌ ୱେର୍‌ସି ପିତରତିଙ୍ଗ୍‌ ଦୁଆର୍‍ ଲୋଇ ତାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ଆବେଟ୍‌ ଆୟା ଡେୱାଦୁ କାପ୍‍କିନି ସାକର୍‌ ପିତରତିଙ୍ଗ୍‌ ଇର୍ହାତ୍‌, “ନିନ୍‌ ବା ଇନିକା ଇୟା ଲୋକାଦି ସିସୁରି ଲୋଇରାନ୍‌ ଅରେନ୍‍ ଆଇନୋ ?” ପିତର୍‌ ଇର୍ହାନ୍‌, “ନାନ୍ ସିଲେ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ପିନିଦି ଉଣ୍ତିଙ୍ଗ୍‌ ସାକର୍‌ ନି କାପ୍‍କିନିକାର୍‌ ସିସୁ କାସ୍‌ସିକିଜି ଆବେନୁ ନିର୍‌ଆରୋ ସିସୁ କାୟାଜି ମାର୍ହାର୍‌; ପିତର୍‌ ବା ୱାରି ୱାଲେ ନିର୍‌ଆନୋ ସିସୁ କାୟାଜି ମାର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ଆୟାଦାପ୍ରେ ୱିଜେରିଙ୍ଗ୍‌ ପେରିଜାଜକ୍‌ ଜିସୁଙ୍ଗୁଁ ୱାନି ସିସୁରି ବିସୟ୍‌ତାନ୍‌ ମାରି ୱାନି ସିକିୟା ବିସୟ୍‌ତାନ୍‌ ୱେନ୍‍ବାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନାନ୍ ଦୁନିଆ ଲାକ୍‌ତୁ ନେସ୍‌ନିୱାଜା ମାଟା ଇର୍‌ଆମାନା; ଏମେମାନୁ ୱିଜେରେ ଜିହୁଦିର୍‌ ଉନ୍‌ଡ୍ରେମାନୁ ଆନାର୍‌, ଇୟାୱାଜା ପାର୍‍ତନାକିନି ଇଲ୍‌କାଙ୍ଗ୍‌ ମାରି ମନ୍ଦିର୍‌ତୁ ନାନ୍ ୱିଜୁଦିନ୍‌ ସିକିୟା ସିତାମାନା; ନାନ୍ ଇନି ବିସୟ୍‌ ଆଡ଼ାକ୍‌ସି ୱାଜା ଇନ୍‌ଏ । ");
INSERT INTO kfcp_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ନାଙ୍ଗିଁ ଏନ୍ଦା ୱେନ୍‌ବାଜିନି ? ନାନ୍ ୱାରିଙ୍ଗ୍‌ ଇନିକା ଇର୍ହାମାନା, ଏମେକାର୍‌ ୱେର୍‌ଆମାନାର୍‌, ୱାରିଙ୍ଗ୍‌ ୱେନ୍‍ବାଆ; ସୁଡ଼ୁଆ, ନାନ୍ ଆମା ଆମାକା ଇର୍‌ଆମାନା, ୱାର୍‌ ଆୟାୱିଜୁ ନେସ୍‌ନାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ଜିସୁ ଇୟା ମାଟା ଇନିୱାଲେ ଜିସୁଦି ଲାକ୍‌ତୁ ନିର୍‌ଇ ମାର୍‌ଇ କାପ୍‍କିନିକାନ୍‌ ଅରେନ୍‍ ଜିସୁଙ୍ଗୁଁ ସାପାଡ଼ା ଡାକ୍‌ସି ଇର୍ହାନ୍‌, “ନିନ୍‌ ୱିଜେରିଙ୍ଗ୍‌ ପେରି ଜାଜକଙ୍ଗ୍‌ ଏଣ୍ତେସ୍‌ ଉତର୍‌ ୱେର୍‌ସିନି ?” ");
INSERT INTO kfcp_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଜଦି ନାନ୍ ବୁଲ୍‌ ଇର୍‌ଆ, ଆର୍‌ତିଙ୍ଗ୍‌ ୱିଜେରି ଆଗ୍‌ଡ଼ି ବୁଲ୍‌ତି ସାକି ସିଦାଟ୍‌; ମାତର୍‌ ଜଦି ନେଗେନ୍‌ ଇର୍ହା, ଆର୍‌ତିଙ୍ଗ୍‌ ଏନ୍ଦା ନାଙ୍ଗିଁ ଡାକ୍‌ସିନି ?” ");
INSERT INTO kfcp_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ଆବେଟ୍‌ ହାନାନ ଜିସୁଙ୍ଗୁଁ ତରାତିମାନି ଡ଼ାସାନେ ୱିଜେରିଙ୍ଗ୍‌ ପେରିଜାଜକ୍‌ କୟାପାଦି ଲାକ୍‌ତୁ ପୋକ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ଆବେଟ୍‌ ସିମୋନ ପିତର୍‌ ନିର୍‌ଆରୋ ସିସୁ କାୟାଜି ମାର୍ହାର୍‌ । ଆବେଟ୍‌ ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, “ନିନ୍‌ ବା ଇନିକା ୱାନି ସିସୁରି ଲୋଇରାନ୍‌ ଅରେନ୍‍ ଆଇନୋ ?” ପିତର୍‌ ନେସେଏ ଇଜି ଇର୍ହାନ୍‌, “ନାନ୍ ସିଲେ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ୱିଜେରିଙ୍ଗ୍‌ ପେରିଜାଜକଦି ସାକର୍‌କା ଲୋଇରାନ୍‌ ଅରେନ୍‍, ଅର୍ତାତ୍‍ ପିତର୍‌ ଆମାୱାନି ଗିତଣି କୟ୍‌ତାପୋକ୍‌ତା ମାର୍ହାନ୍‌, ଆୟା ସାକର୍‌ତି ନିଜେଲୋକ୍‌ ଇର୍ହାନ୍‌, “ନାନ୍ ଇନିକା ନିଙ୍ଗିଁ ୱାନି ୱାଲେ ଡଡିଦୁ ସୁଡ଼ୁଏ ମାର୍ହା ନୋ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ଆବେଟ୍‌ ପିତର୍‌ ମାରିଡ଼େସି “ନେସେଏ” ଇଜି ଇର୍ହାନ୍‌, ମାରି, ଆୟାଦାପ୍ରେ କରୁ କେଡ଼ିତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ୱେନ୍‌କା ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ କୟାପାଦି ଇଲ୍‌ତାନ୍‌ ଅସି ରମିୟ ରାଜାଦି ମେଡ଼୍‍ଇଲୁତୁ ଅତାର୍‍; ନାସ୍ତିୱାଲେ କରୁ କେଡ଼େପି ଆତାମାର୍ହାତ୍‌; ମାରି, ଜିହୁଦି ନେତାର୍‌ ଏଣ୍ତେସ୍‌ ତାଗ୍‍ଇକା ଆଏଣ୍‌ଗା ନିସ୍ତାର୍‌ ପଣ୍ତୟ୍‌ତି ବୋଜି ଉନ୍‌ଣ୍ତେଙ୍ଗ୍‌ ଆଟ୍‍ନାର୍‍, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ନିଜେ ମେଡ଼େଇଲୁ ଲୋଇ ଡ଼ୁଗ୍‌ଏତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ମାରି, ରାଜା ପିଲାତ୍‌ ୱାରି ଲାକ୍‌ତୁ ସୋସି ୱାଜି ୱେନ୍‌ବାତାନ୍‌, “ଇୟା ଲୋକ୍‌ତି ବିରଦ୍‌ତାନ୍‌ ମି ମାଟା ଇନିକା ?” ");
INSERT INTO kfcp_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ଇୟାକାନ୍‌ ଜଦି ଦସ୍‌କିତିକାନ୍‌ ଆଏତାନ୍‌ ମାନ୍ଦି, ଆର୍‌ତିଙ୍ଗ୍‌ ମାପ୍‌ ୱାନିଙ୍ଗ୍‌ ନି କିୟୁଦି ସର୍‌ପେ କିଏତାପ୍‌ ମାନ୍ଦି ।” ");
INSERT INTO kfcp_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ଆବେଟ୍‌ ପିଲାତ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମିର୍‌ ୱେନିଙ୍ଗ୍‌ ଅସ ମି ନିୟମ୍‌ତାନ୍‌ ୱେନି ବିସାର୍‌ କିଦୁ ।” ଜିହୁଦିର୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ଏଙ୍ଗ୍‌ ସାନିଦଣ୍ତ୍‌ ସିନି ମା ଅଦିକାର୍‌ ସିଲେତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ଜିସୁ ଏଣ୍ତେସ୍‌ ନାନି ସାନିଦଣ୍ତ କିଦେଙ୍ଗ୍‌ ସୋଲ୍‌ସିନାନ୍‌, ଆବେଣି ସିନା ସିଜି ୱାନ୍‌ ଆମା ବାକ୍ୟ ଇର୍ହାମାର୍ହାନ୍‌ ଆକା ଏଣ୍ତେସ୍‌ ପୁରା ଆନାତ୍‌, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାର୍‌ ଇକା ଇର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ମାରି, ପିଲାତ୍‌ ମେଡ଼୍‍ଇଲୁ ଲୋଇ ଡ଼ୁଗିତାନ୍‌ନୋ ଜିସୁଙ୍ଗୁଁ କୁକ୍‌ତାନ୍‌ନୋ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ନିନ୍‌ ଇନିକା ଜିହୁଦିର୍‌ ରାଜା ?” ");
INSERT INTO kfcp_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନିନ୍‌ ଇନିକା ନିଜେଦାନ୍‍ ଇକା ଇଜିନି, ନୋ ଆଇକାର୍‌ ନା ବିସୟ୍‌ତାନ୍‌ ନିଙ୍ଗିଁ ଇକା ୱେର୍‌ତାମାନାର୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ପିଲାତ୍‌ ଇର୍ହାନ୍‌, “ନାନ୍ ଇନିକା ଅରେନ୍‍ ଜିହୁଦି ? ମି ନିଜେଦି ଲୋକୁ ମାରି ପେରି ଜାଜକର୍‌ ନିଙ୍ଗିଁନା କିୟୁଦୁ ସର୍‌ପେ କିତାମାନାର୍‌; ନିନ୍‌ ଇନିକା କିତିମାନି ?” ");
INSERT INTO kfcp_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ଜିସୁ ଇର୍ହାନ୍‌, “ନା ରାଜି ଇୟା ଦୁନିଆଦି ବିସୟ୍‌ ଆଏତ୍‍; ଜଦି ନା ରାଜି ଇୟା ଦୁନିଆଦି ବିସୟ୍‌ତାନ୍‌ ଆତାତ୍‌ମାନ୍ଦି, ଆର୍‌ତିଙ୍ଗ୍‌ ନାନ୍ ଏଣ୍ତେସ୍‌ ଜିହୁଦି ନେତାର୍‌ କିୟୁଦୁ ସର୍‌ପେ ଆଏତାମାନ୍ଦି, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ନାୱାଲେ ବୁଲାନିକାର୍‌ ଜୁଦ୍‍ କିତାର୍‌ମାନ୍ଦି, ମାତର୍‌ ନା ରାଜି ସତ୍‌ତାନ୍‌ନେ ଇୟା ଦୁନିଆ ବିସୟ୍‌ତାନ୍‌ ସିଲେ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ଆବେଟ୍‌ ପିଲାତ୍‌ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ଆର୍‌ତିଙ୍ଗ୍‌ ନିନ୍‌ ଇନିକା ଅରେନ୍‍ ରାଜା ନୋ ?” ଜିସୁ ଇର୍ହାନ୍‌, “ନିନ୍‍ତୋ ଇଜିନି, ନାନ୍ ଅରେନ୍‍ ରାଜା । ନାନ୍ ଏଣ୍ତେସ୍‌ ସତ୍‌ତି ତରିନ୍‌ ସାକି ସିନା, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ଜନମ୍‌ ଆତାମାନା ମାରି ଦୁନିଆଦୁ ୱାତାମାନା । ଏନ୍‌ ସତ୍‌ତି ମାରିନ୍‌, ୱାନ୍‌ ନା ମାଟା ୱେନ୍‌ନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ପିଲାତ୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ସତ୍‌ ଇନିକା ?” ଇକା ଇନ୍‌ଜି ୱାନ୍‌ ମାରି ଜିହୁଦିଲୋକା ଲାକ୍‌ତୁ ଆତ୍‌ରେ ସୋର୍‌ଆନ୍‌ନୋ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ନାନ୍ ଦଣ୍ତ୍‌ସିନି ଉଣ୍ତିଙ୍ଗ୍‌ ୱେନିମାନୁ ଇନି ଦୋସ୍‌ ପୟ୍‌ଏଜିନା । ");
INSERT INTO kfcp_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ମାତର୍‌ ନାନ୍ ଜେ ନିସ୍ତାର୍‌ ପଣ୍ତୟ୍‌ତିୱାଲେ ମି ଉଣ୍ତିଙ୍ଗ୍‌ ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ ଡ଼ିସ୍‌ସିକିନିକା, ଇକା ମି ରିତି ମାନାତ୍‌; ମାରି, ଜିହୁଦିର୍‌ ରାଜେଙ୍ଗ୍‌ ନାନ୍ ମି ଉଣ୍ତିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ନା ସିନାପ୍‌ ଇଜି ଇନିକା ମି ବଦା ? ");
INSERT INTO kfcp_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ଆବେଟ୍‌ ୱାର୍‌ ମାରିଡ଼େସି ଆଉଲି ଆଜି ଇର୍ହାର୍‌, ଇୟା ଲୋକତିଙ୍ଗ୍‌ “ସିଲେ, ମାତର୍‌ ବାରବ୍ବାଙ୍ଗ୍‌ ଡ଼ିସ୍‌ଆ ।” ଇୟା ବାରବ୍ବା ଅରେନ୍‍ ଡଙ୍ଗାଁର୍‌ଏନ୍‌ ମାର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ତାନେୱେନ୍‌କା ପିଲାତ୍‌ ଜିସୁଙ୍ଗୁଁ ଅସି କୋର୍‌ଡାଦାନ୍‌ ଡାକ୍‌ସି କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ମାରି, ସନ୍ୟର୍‌ ସାମ୍‌କାଣି ଟପି ତିଆର୍‌ କିତାର୍‌ରୋ ଜିସୁଦି ତାଲାଦୁ ଆରିସ୍‌କିତାର୍‌ ମାରି ୱାନିଙ୍ଗ୍‌ ନିଡ଼ିଦି ଆଙ୍ଗିଁ ଆରିସ୍‌କିତାର୍‌; ");
INSERT INTO kfcp_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ୱାର୍‌ ୱାନି ଲାକ୍‌ତୁ ୱାଜି ଇର୍ହାର୍‌, ଏ ଜିହୁଦିର୍‌ ରାଜା, ୱିଜୁଦିନ୍‌ତି ଉଣ୍ତିଙ୍ଗ୍‌ ରାଜା ଆଜି ମା ମୁସ୍‌କୁ ସାସନ୍‌ କିଆ; ମାରି ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ସାପ୍‌ଡ଼ା ଡାକ୍‌ତେଙ୍ଗ୍‍ଁ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ପିଲାତ୍‌ ମାରିଡ଼େସି ଆତେରେ ସର୍ହାନ୍‌ନୋ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ସୁଡ଼ୁଦୁ, ନାନ୍ ୱାନିମାନୁ ଇନି ଦସୋ ପୟ୍‌ଏଜିନା, ଇକା ଏଣ୍ତେସ୍‌ ମିର୍‌ ନେସ୍‌ନିଦେର୍‌, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ୱାନିଙ୍ଗ୍‌ ମି ଲାକ୍‌ତୁ ସୋପ୍‌ତା ତାସିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ଆବେଟ୍‌ ଜିସୁ ଆୟା ସାମ୍‍କାଣି ଟପି ମାରି ନିଡ଼ି କୋଲର୍‌ତି ଆଙ୍ଗିଁ ଆରାତାନ୍‌ନୋ ଆତେରେ ୱାତାନ୍‌ । ପିଲାତ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ସୁଡ଼ୁଦୁ, ଆୟା ଲୋକୁ !” ");
INSERT INTO kfcp_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ଆବେଟ୍‌ ପେରି ଜାଜକର୍‌ ମାରି ମନ୍ଦିର୍‌ କାପ୍‍କିନିକାର୍‌ ଜିସୁଙ୍ଗୁଁ ସୁଡ଼ୁଜି ଆଉଲି ଆଜି ଇର୍ହାର୍‌, କ୍ରୁସକାଟ୍‌ତୁ ଏକିସ୍‌କିଦୁ, କ୍ରୁସକାଟ୍‌ତୁ ଏକିସ୍‌କିଦୁ । ପିଲାତ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ମିର୍‌ ୱାନିଙ୍ଗ୍‌ ଅସି କ୍ରୁସକାଟ୍‌ତୁ ଏକିସ୍‌କିଦୁ, ଇରିଙ୍ଗ୍‌ ନାନ୍ ସାନିଦଣ୍ତ୍‌ ସିଦେଙ୍ଗ୍‍ ୱାନିମାନୁ ଇନି ଦସୋ ପୟ୍‌ଏଜିନା । ");
INSERT INTO kfcp_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ଜିହୁଦିଲୋକ୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ମାଦି ଉନ୍‌ଡ୍ରି ନିୟମ୍‌ ମାନାତ୍‌ ମାରି ଆୟା ନିୟମ୍‌ତି ଇସାବ୍‌ତାନ୍‌ ୱାନ୍‌ ସାନିଦଣ୍ତତି ଜଗ୍‌, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ନିଜେଦିଙ୍ଗ୍‌ ମାପୁରୁଦି ମାରିନ୍‌ ଇଜି ୱେର୍‌ସିନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ଆବେଟ୍‌ ପିଲାତ୍‌ ଇୟା ମାଟା ୱେନ୍‌ଜି ନାଣ୍ତ ତିଲାତାନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ମାରି, ୱାନ୍‌ ମାରିଡ଼େସି ମେଡ଼୍‍ଇଲୁ ଲୋଇ ଡ଼ୁଗିତାନ୍‌ନୋ ଜିସୁଙ୍ଗୁଁ ୱେନ୍‌ବାତାନ୍‌, “ନିନ୍‌ ଏମେମାଣ୍‌କୁ ୱାତିମାନି ?” ମାତର୍‌ ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇନିକା ଇନ୍‌ଏତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ଆବେଟ୍‌ ପିଲାତ୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନିନ୍‌ ଇନିକା ନା ୱାଲେ ୱାର୍‌ଗିଇ ? ନିଙ୍ଗିଁ ଡ଼ିସ୍‌ତେଙ୍ଗ୍‌ ନା ଅଦିକାର୍‌ ମାନାତ୍‌ ମାରି ନିଙ୍ଗିଁ କ୍ରୁସକାଟ୍‌ତୁ ଏକିସ୍‌ତେଙ୍ଗ୍‌ ନା ଅଦିକାର୍‌ ମାନାତ୍‌, ଇକା ଇନିକା ନିନ୍‌ ନେସ୍‌ଏଜିନି ?” ");
INSERT INTO kfcp_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ଜିସୁ ଇର୍ହାନ୍‌, “ଜଦି ମାପୁରୁଦିମାଣାନ୍‌ ନିଙ୍ଗିଁ ଅଦିକାର୍‌ ରେଏତିଙ୍ଗ୍‌ ମାନ୍ଦି, ଆର୍‌ତିଙ୍ଗ୍‌ ନା ବିରଦ୍‌ତାନ୍‌ ନିଦି ଇନି ଅଦିକାର୍‌ ସିଲେତାତ୍‍ ମାନ୍ଦି; ଏନ୍‌ ନାଙ୍ଗିଁ ନି କିୟୁଦୁ ସର୍‌ପେ କିତାମାନାନ୍‌, ୱାନି ପାପ୍‌ ନାଣ୍ତୋସାନିୱାଜା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ଆବେଟ୍‌ ପିଲାତ୍‌ ୱାନିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ତେଙ୍ଗ୍‌ ସେସ୍ଟା କିତାନ୍‌, ମାତର୍‌ ଜିହୁଦିଲୋକ୍‌ ଆଉଲି ଆଜି ଇର୍ହାର୍‌, “ଜଦି ନିନ୍‌ ଇୟା ଲୋକତିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ନି, ଆର୍‌ତିଙ୍ଗ୍‌ ନିନ୍‌ ସମ୍ରାଟ୍‌ତି ସଙ୍ଗ୍‍ ଆଇ; ଏନ୍‌ ନିଜେଦିଙ୍ଗ୍‌ ରାଜା ଇଜି ଇନାନ୍‌, ୱାନ୍‌ ସମ୍ରାଟ୍‌ତି ତରିନ୍‌ ମାଟା ଇନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ମାରି, ପିଲାତ୍‌ ଇୟାୱିଜୁ ମାଟା ୱେର୍‌ଆନ୍‌ନୋ ଜିସୁଙ୍ଗୁଁ ଆତେରେ ତାତ୍‌ତାନ୍‌ନୋ “ଗୁଡିକାଲୁ” ଦର୍‌ତି ବାଡିଦୁ ତାତାର୍‌, ଏବ୍ରି ବାସାଦାନ୍‌ ଇୟାତାନି ଦର୍‌ “ଗବ୍‌ବତା” ଇଜି ଇନାର୍‌, ଆୟା ବିଚାର୍‍କିନି ବାଡିଦୁ ବାସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ଆୟାନାଣ୍ତିଙ୍ଗ୍‌ ନିସ୍ତାର୍‌ ପଣ୍ତ୍‌ୟ ତିଆର୍‌ଆନି ଦିନ୍‌, ମାରି ନାସ୍ତିୱାଲେ ୱେଡ଼େ ଆତାମାର୍ହାତ୍‌ । ମାରି, ୱାନ୍‌ ଜିହୁଦିରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ସୁଡ଼ୁଦୁ ମି ରାଜା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ଆବେଟ୍‌ ୱାର୍‌ ଆଉଲି ଆତାର୍‌, “ୱାନିଙ୍ଗ୍‌ ଡାକ୍‌ତୁ, ଡାକ୍‌ତୁ, କ୍ରୁସକାଟ୍‌ତୁ ଏକିସ୍‌କିଦୁ ।” ପିଲାତ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନାନ୍ ଇନିକା ମି ରାଜେଙ୍ଗ୍‌ କ୍ରୁସକାଟ୍‌ତୁ ଏକିସ୍‌କିନା ?” ପେରି ଜାଜକର୍‌ ଇର୍ହାର୍‌, “କେବଲ୍ ସମ୍ରାଟ୍‌ତିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ତିଙ୍ଗ୍‌ ମାଙ୍ଗିଁ ମାରି ରାଜା ସିଲେନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ଆବେଟ୍‌ ପିଲାତ୍‌ ଏଣ୍ତେସ୍‌ କ୍ରୁସ୍‌କାଟ୍‌ତୁ ଏକାନାନ୍‌, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌, ପିଲାତ୍‌ ୱାନିଙ୍ଗ୍‌ ୱାରି ବଦାଦାନ୍ ସର୍‌ପେ କିତାନ୍‌, ତାନେୱେନ୍‌କା ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ଅତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ମାରି, ଜିସୁ ନିଜେ କ୍ରୁସ୍‌କାଟ୍‌ ପିଡିତାନ୍‌ନୋ “ତାଲାଦି କାପାଲ୍‌ ନାନି” ଦର୍‌ତି ବାଡିଦୁ ସୋର୍ହାନ୍‌, ଏବ୍ରି ବାସାଦାନ୍‌ ଆୟାବାଡିଦିଙ୍ଗ୍‌ “ଗଲ୍‌ଗଥା” ଇଜି ଇନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ଆବେନୁ ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ କ୍ରୁସ୍‌କାଟ୍‌ତୁ ଏକିସ୍‌କିତାର୍‌ ମାରି ୱାନି ୱାଲେ ମାରି ରିଏରିଙ୍ଗ୍‌ ଏକିସ୍‌କିତାର୍‌, ରିଆଙ୍ଗାଁ ରିଏରିଙ୍ଗ୍‌ ମାରି ନାଡ଼୍‌ମି ଜିସୁଙ୍ଗୁଁ । ");
INSERT INTO kfcp_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ମାରି, ପିଲାତ୍‌ ଉନ୍‌ଡ୍ରି ନଟିସ୍‌ ଆକୁ ରାସ୍‌ସି କ୍ରୁସ୍‌କାଟ୍‌ତି ମୁସ୍‌କୁ ଡ଼ତାର୍‌ । ଆବେନୁ ରାସ୍‌ତା ମାର୍ହାତ୍‌, “ନାଜରିୟତିୟ ଜିସୁ, ଜିହୁଦିର୍‌ ରାଜା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ଜିହୁଦିର୍‌ ଲୋଇରାନ୍‌ ଏସୋଲୋକ୍‌ ଇୟା ରାସ୍‌ତିମାନିକା ପଡ଼ାତାର୍‌, ଇରିଙ୍ଗ୍‌ ଏମେ ବାଡିଦୁ ଜିସୁଙ୍ଗୁଁ କ୍ରୁସ୍‌କାଟ୍‌ତୁ ଏକିସ୍‌କିତାମାର୍ହାର୍‌, ଆକା ଗାଡ଼୍‌ ଲାକ୍‌ତୁ ମାର୍ହାତ୍‌, ମାରି ଆୟା ରାସ୍‌ତିକା ଏବ୍ରି, ଲାଟିନ୍‌ ମାରି ଗ୍ରିକ୍‌ ବାସାଦାନ୍‌ ରାସ୍‌ତା ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ଜିହୁଦିରି ପେରି ଜାଜକର୍‌ ପିଲାତ୍‌ତିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ଜିହୁଦିରି ରାଜା” ଇଜି ରାସ୍‌ଏଣ୍‌ଗା ମାରି “ନାନ୍ ଜିହୁଦିରି ରାଜା ଇଜି ୱାନ୍‌ ଇର୍ହାନ୍‌, ଇକା ରାସ୍‌ଆଁ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ପିଲାତ୍‌ ଇର୍ହାନ୍‌, “ନାନ୍ ଆମାକା ରାସ୍‌ତାମାନା, ଆକା ବାଦେଲ୍‌କିଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ସନ୍ୟର୍‌ ଜିସୁଙ୍ଗୁଁ କ୍ରୁସ୍‌କାଟ୍‌ତୁ ଏକିସ୍‌କିତି ୱେନ୍‌କା ନାଲ୍‌ଏର୍‌ ସନ୍ୟର୍‌ ୱାନି ୱାତି ନାଲ୍‌ଗି ବାଗ୍‌କୁ କିଜି ୱିଜେରେ ଉଣ୍ତିଙ୍ଗ୍‌ ଉନ୍‌ଡ୍ରି ଉନ୍‌ଡ୍ରି ବାଗ୍, ମାରି ୱାର୍‌ ୱାନି ଆଙ୍ଗିଁ ବା ଅତାର୍‍ । ଆୟା ଆଙ୍ଗିଁ ସିଲାଇ କିଏଣ୍‌ଗା ମୁସ୍‌କୁରାନ୍‌ ଆଡ୍‍ଗି ସାନ୍ଦି ୱିଜୁ ଗୁତ୍‌ତା ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ଆଦେଙ୍ଗ୍‌ ସନ୍ୟର୍‌ ଲୋଇ ଲୋଇ ଇର୍ହାର୍‌, ତେନେଙ୍ଗ୍‌ କିସ୍‌ତେଙ୍ଗ୍‌ କେଏଟ୍‌, ମାତର୍‌ ଇକା ଏନ୍ଦି ଆନାତ୍‌, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ କୁଡ଼ୁକୁଡ଼ି କିନାଟ୍‌, ଏଣ୍ତେସ୍‌ ଦାର୍ମୁସାସ୍ତ୍ରଦୁ ଇୟା ବାକ୍ୟ ପୁରା ଆନାତ୍‌, ୱାର୍‌ ନିଜେ ନିଜେଦି ମାନୁ ନା ଆଙ୍ଗିଁଦିଙ୍ଗ୍‌ ବାଗ୍ କିତାର୍‌, ମାରି ନା ଆରାନି ଆଙ୍ଗିଁ ଉଣ୍ତିଙ୍ଗ୍‌ କୁଡ଼ୁକୁଡ଼ି କିତାର୍‌ । ଆଦେଙ୍ଗ୍‌ ସନ୍ୟର୍‌ ଇୟାୱିଜୁ କିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ମାତର୍‌ ଜିସୁଦି କ୍ରୁସ୍‌କାଟ୍‌ତି ଲାକ୍‌ତୁ ୱାନି ଆଇସି ମରିୟମ୍‌, ୱାନି ଆଇସିକା ତାଙ୍ଗିଁସି, କ୍ଳୋପାଦି ଆଡ଼୍‌ସି, ମରିୟମ୍‌ ମାରି ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ ନିର୍‌ଏ ମାର୍‌ଏ । ");
INSERT INTO kfcp_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ଜିସୁ ନିଜେଦି ଆଇସିଙ୍ଗ୍‍ ମାରି ଏମେ ସିସୁଙ୍ଗୁଁ ଜିବନ୍‌ନୋଜି ମାର୍ହାନ୍‌, ତାନିଙ୍ଗ୍‌ ଲାକ୍‌ତୁ ନିର୍‌ଇମାରିକା ସୁଡ଼ୁତାନ୍‌ନୋ ଆଇସିଙ୍ଗ୍‍ ଇର୍ହାନ୍‌, “ସୁଡ଼ୁଆ, ନି ମାରିନ୍‌ତିଙ୍ଗ୍‌ !” ");
INSERT INTO kfcp_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ତାନେୱେନ୍‌କା ଜିସୁ ଆୟା ସିସୁଙ୍ଗୁଁ ଇର୍ହାନ୍‌, “ସୁଡ଼ୁଆ, ମି ୟାୟା !” ମାରି ଆୟା ସମୟ୍‌ତାନ୍‌ ଆୟା ସିସୁ ତାନିଙ୍ଗ୍‌ ନିଜେଦି ଇଲୁତୁ ଅତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ତାନେୱେନ୍‌କା ଜିସୁ ଦାର୍ମୁସାସ୍ତ୍ରଦି ବାକ୍ୟ ଏଣ୍ତେସ୍‌ ପୁରା ଆନାତ୍‌, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱିଜୁ ବିସୟ୍‌ ଇଲେଇ ୱିଜିତାମାନାତ୍‌ ଇଜି ନେସ୍‌ସି ଇର୍ହାନ୍‌, “ନାଙ୍ଗିଁ ଏର୍‌କିକାଟ୍‌ସିନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ଆବେନୁ ସୟ୍‌ନିରସ୍‌ ପୁରାପୁରିମାନି ଉନ୍‌ଡ୍ରି ସାଟି ମାର୍ହାତ୍‌; ୱାର୍‌ ସୟ୍‌ନିରସ୍‌ ପୁରାମାନି ଉନ୍‌ଡ୍ରି ତୁଲାଦୁ କାଣ୍ତେକ୍‌ ବାଡିଗାଦିଟିପୁଦୁ ଲାଗିସ୍‌କିଜି ୱାନି ୱେୟୁ ଲାକ୍‌ତୁ ସିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ଆବେଟ୍‌ ଜିସୁ ଆୟା ସୟ୍‌ନିରସ୍‌ ଉଟାନ୍‌ନୋ ଇର୍ହାନ୍‌, “ୱିଜିତାତ୍‌” ମାରି ୱାନ୍‌ ତାଲା ଆଡ୍‍ଗି କିଜି ସାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ଆୟାନାଣ୍ତିଙ୍ଗ୍‌ ନେଗିଦିନ୍‌ ମାନିଙ୍ଗ୍‌, ମେନ୍ଦଲ୍‌ୱିଜୁ ଏଣ୍ତେସ୍‌ ରମ୍‌ନିନାଣ୍ତିଙ୍ଗ୍‌ କ୍ରୁସ୍‌କାଟ୍‌ ମୁସ୍‌କୁ ତେବାଏତ୍‌, ଇରିଙ୍ଗ୍‌ ଆୟା ରମ୍‌ନିନାଣ୍ତିଙ୍ଗ୍‌ ପବିତ୍ର ଦିନ୍‌ ମାର୍ହାତ୍‌, ଆରିଙ୍ଗ୍‌ ୱାରି କାଲ୍‌କୁ ରୁକିର୍‌ ମାରି ତାନେୱେନ୍‌କା ୱାରିଙ୍ଗ୍‌ କୁସ୍ରକାଟ୍‌ତାନ୍‌ ରେପ୍‌ତେଙ୍ଗ୍‌ ଇଜି ଜିହୁଦି ନେତାର୍‌ ପିଲାତ୍‌ତିଙ୍ଗ୍‌ ମାଡ଼ିସ୍‌କିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ତାନେୱେନ୍‌କା ସନ୍ୟର୍‌ ୱାଜି ଆଗ୍‌ଡ଼ି ଅରେନ୍‍ୱାନି କାଲ୍‌କୁ ମାରି ଜିସୁଦି ୱେଲେ ଆମା ଅରେନ୍‍ୱାନିଙ୍ଗ୍‍ କ୍ରୁସ୍‌କାଟ୍‌ତୁ ଏକିସ୍‌କିତାମାର୍ହାର୍‌, ୱାନି କାଲୁ ବା ରୁକ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ମାତର୍‌ ୱାର୍‌ ଜିସୁ ଲାକ୍‌ତୁ ୱାଜି ୱାନ୍‌ ସାତାନ୍‌ ଇଜି ସୁଡ଼ୁଜି ୱାନି କାଲୁ ରୁକ୍‌ଏତାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ମାଣ୍‌କୁ ଅରେନ୍‍ ଇଟାଦାନ୍‌ ୱାନି ପାଡ଼୍‌କାଦୁ ଗୁତ୍‌ତାନ୍‌, ମାରି ଆୟାଦାପ୍ରେ ନେତେର୍‌ ନି ଏରୁ ୱାଙ୍ଗ୍‍ଜି ୱାତେ । ");
INSERT INTO kfcp_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ଏନ୍‌ ସୁଡ଼ୁତା ମାନାନ୍‌, ୱାନ୍‌ ସାକିୟ ସିତାମାନାନ୍‌, ଏଣ୍ତେସ୍‌ ମିର୍‌ ବା ବିସ୍‌ବାସ୍‌ କିନିଦେର୍‌; ମାରି, ୱାନି ସାକ୍ୟ ସତ୍‌, ମାରି ୱାନ୍‌ ଜେ ସତ୍‌ ୱେର୍‌ସିନାନ୍‌, ଇକା ୱାନ୍‌ ନେସ୍‌ନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ଇରିଙ୍ଗ୍‌ ଦାର୍ମୁସାସ୍ତ୍ରଦି ଇୟା ବାକ୍ୟ ପୁରା ଆନି ଉଣ୍ତିଙ୍ଗ୍‌ ଇୟାୱିଜୁ ବିସୟ୍‌ ଗଟାତାତ୍‌, “ୱାନି ଉନ୍‌ଡ୍ରି ପେଡ଼େନ୍‌ ବା ରୁଙ୍ଗ୍‌ଏତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ଦାର୍ମୁସାସ୍ତ୍ରଦୁ ମାରି ଉନ୍‌ଡ୍ରି ବାକ୍ୟ ରାସ୍‌ତାମାନାତ୍‌, “ୱାର୍‌ ଆମାୱାନିଙ୍ଗ୍‌ ଇଟାଦାନ୍‌ ଗୁତ୍‌ତାର୍‌, ୱାନି ଲୋକୁ ସୁଡ଼ୁନାଟ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ଇୟାୱିଜୁ ଗଟ୍‌ନେଙ୍ଗ୍‌ ୱେନ୍‌କା, ଆମା ହାରାମାତିୟାଦି ଜୋସେପ୍‌ ଜିସୁଦି ଅରେନ୍‍ ସିସୁ ମାର୍ହାନ୍‌, ମାତର୍‌ ଜିହୁଦି ନେତାରିଙ୍ଗ୍‌ ତିଲାଜି ନେସେଇ ୱାଜା ମାର୍ହାନ୍‌, ଜୋସେପ ଜିସୁଦି ମେନ୍ଧଲ୍‍ ଅତେଙ୍ଗ୍‌ ଇଜି ପିଲାତ୍‌ତିଙ୍ଗ୍‌ ମାଡ଼ିସ୍‌ତାନ୍‌ । ଆବେଟ୍‌ ପିଲାତ୍‌ ଡ଼ିସ୍‌ତାସିତାନ୍‌ । ଆଦେଙ୍ଗ୍‌ ୱାନ୍‌ ୱାତାନ୍‌ନୋ ୱାନି ମେନ୍ଦଲ୍ ଅତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ଆମା ନିକଦିମ ଆଗ୍‌ଡ଼ି ନାଡ଼ା ୱାନି ଲାକ୍‌ତୁ ୱାତାମାର୍ହାନ୍‌, ୱାନ୍‌ ବା ପୁରା ତିରିସ୍‌ କେଜି ବାସ୍‌ନାଦୁମିସାତି ନିୟୁ ଆସ୍‌ସି ୱାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ୱାର୍‌ ଜିସୁଦି ମେନ୍ଦଲ୍‌ତିଙ୍ଗ୍‌ ଅତାରୋ ଜିହୁଦିର୍‌ ମୁସ୍‌ନି ରିତିଦାନ୍‌ ଆକା ବାସ୍‌ନାନିୟୁଦି ୱାଲେ କାଣ୍ତେକ୍‌ ପାସିଆଦୁ ତେରେପ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ଜିସୁଙ୍ଗୁଁ ଏମେ ବାଡିଦୁ କ୍ରୁସ୍‌କାଟ୍‌ତୁ ଏକିସ୍‌କିତାମାର୍ହାର୍‌, ଆୟାବାଡିଦୁ ଉନ୍‌ଡ୍ରି ଡଡି ମାର୍ହାତ୍‌, ମାରି ଆୟା ଡଡିଦୁ ଉନ୍‌ଡ୍ରି ପୁନି ମୁସ୍‌ନି ଗୁଟା ମାର୍ହାତ୍‌, ଆବେନୁ ଏନ୍‌ ଆଗ୍‍ଡ଼ିରାନ୍‍ ଏଙ୍ଗ୍‌ବା ମୁସ୍‌ଏର୍‌ ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ମାରି, ଜିହୁଦିରି ନେଗିଦିନ୍‌ତି ଉଣ୍ତିଙ୍ଗ୍‌ ଆୟା ବାଡିଦୁ ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ଇଟ୍‌ତାର୍‌, ଇରିଙ୍ଗ୍‌ ଆୟା ମୁସ୍‌ନିବାଡି ଲାକ୍‌ତୁ ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ୱାରାଦି ଆଗ୍‍ଡ଼ିରି ନାଣ୍ତିଙ୍ଗ୍‌ ଉଟ୍‌ଲା ନାଡ଼ାକାଦେ ସିକାଟି ମାନାପ୍ ମାନ୍‌ବୁନେ ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ ମୁସ୍‌ତିଗୁଟା ଲାକ୍‌ତୁ ୱାତାଦ ଆବେଣୁକୁ କାଲୁ ଗୁସାକିତିମାରିକା ସୁଡ଼ୁତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ଆଦେଙ୍ଗ୍‌ ମରିୟମ୍‌ ଉର୍‌କୁସି ସୋଲ୍‌ସି ସିମୋନ ପିତର୍‌ ମାରି ଜିସୁ ଆମାୱାନିଙ୍ଗ୍‌ ଜିବନ୍‌ନୋଜି ମାର୍ହାନ୍‌, ଆୟା ଆଇ ସିସୁରି ଲାକ୍‌ତୁ ୱାତାତ୍‍, ମାରି ୱାରିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ୱାର୍‌ ମୁସ୍‌ତିଗୁଟାଦାନ୍‌ ପ୍ରବୁଙ୍ଗ୍‌ ଅତାମାନାର୍‌, ମାରି ୱାନିଙ୍ଗ୍‌ ଏମେମାନୁ ଇଟ୍‌ତାମାନାର୍‌, ଆକା ମାପ୍‌ ନେସ୍‌ଏଜିନାପ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ଆବେଟ୍‌ ପିତର୍‌ ମାରି ଆୟା ଆଇ ସିସୁ ମୁସ୍‌ତିଗୁଟା ଲାକ୍‌ତୁ ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଇଜି ସୋତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ୱାର୍‌ ରିଏର୍‌ ଅର୍‌ସେ ଉର୍‌କୁତେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, ମାରି ଆୟା ଆଇ ସିସୁ ପିତରତିଙ୍ଗ୍‌ ୱେନ୍‌କା ଡ଼ିସ୍‌ସି ଆଗ୍‌ଡ଼ି ମୁସ୍‌ତିବାଡି ଲାକ୍‌ତୁ ଇତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ମାରି, ପାଡ଼୍‌ଗିତାନ୍‌ନୋ ଲୋଇ ବେସ୍‌ତାନ୍‌ ପାତଲ୍‌ତି ପାସିଏଙ୍ଗ୍‌ୱିଜୁ ଆର୍‌ତିମାରିକା ସୁଡ଼ୁତାନ୍‌, ଆତିଙ୍ଗ୍‌ବା ୱାନ୍‌ ଲୋଇ ଡ଼ୁଗୁଏତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ତାନେୱେନ୍‌କା ସିମୋନ ପିତର୍‌ ବା ୱାନି ୱେନ୍‌କା ୱେନ୍‌କା ୱାଜି ଇତାର୍‌ ମାରି ମୁସ୍‌ତିଗୁଟା ଲୋଇ ଡ଼ୁଗିତାନ୍‍ନୋ ସୁଡ଼ୁତାନ୍‌ ଜେ, ପାତଲ୍‌ତି ପାସ୍‌ଇଏଙ୍ଗ୍‌ୱିଜୁ ମାନେ, ");
INSERT INTO kfcp_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ମାରି ଜିସୁଦି ତାଲାଦୁ ଆମା ପାଗା ତର୍‌ତା ମାର୍ହାର୍‌, ଆୟା ପାତଲ୍‌ତି ୱାତିଙ୍ଗାଁ ୱାଲେ ମାନ୍‌ଏଣ୍‌ଗା ୱେର୍‌ଏ ଉନ୍‌ଡ୍ରି ବାଡିଦୁ ତେର୍‌ବିତା ମାନ୍‌ତା । ");
INSERT INTO kfcp_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ନାସ୍ତିୱାଲେ ଆମା ଆଇ ସିସୁ ଆଗ୍‌ଡ଼ି ମୁସ୍‌ତିବାଡି ଲାକ୍‌ତୁ ୱାତାମାର୍ହାନ୍‌, ୱାନ୍‌ ବା ଲୋଇ ଡ଼ୁଗିତାନ୍‌ନୋ ସୁଡ଼ୁତାନ୍‌ ମାରି ବିସ୍‌ବାସ୍‌ କିତାନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ଇରିଙ୍ଗ୍‌ ସାତିୱାରି ମାଣ୍‌କୁ ଜିସୁଙ୍ଗୁଁ ଜେ ନିଙ୍ଗିଁନିକା ମାନାତ୍‌, ଦାର୍ମୁସାସ୍ତ୍ରଦି ଇୟା ବାକ୍ୟ ୱାର୍‌ ଆୟା ସାନ୍ଦି ବୁଜାଏତା ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ୱେନ୍‌କା ସିସୁର୍‍ ମାରିଡ଼େସି ୱାରି ଇଲ୍‌ତୁ ସୋର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ମରିୟମ୍‌ ଆଡ଼୍‍ବାଜି ଆଡ଼୍‍ବାଜି ଆତେରେ ମୁସ୍‌ତିବାଡି ଲାକ୍‌ତୁ ନିର୍‌ଆ ତେବାତାତ୍‌; ମାରି, ଆଡ଼୍‍ବାଜି ଆଡ଼୍‍ବାଜି ୱାଦ୍‌ ପାଡ଼୍‌ଗିଜି ମୁସ୍‌ତିଗୁଟା ଲୋଇ ବେସ୍‌ତାତ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ମାରି ଜିସୁଦି ମେନ୍ଧଲ୍‍ ଏମେ ବାଡିଦୁ ଇଟ୍‌ତାମାର୍ହାର୍‌, ଆବେଣି ତାଲା ଲାକ୍‌ତୁ ଅରେନ୍‍ ମାରି ପାଦାମ୍‌କା ଲାକ୍‌ତୁ ମାରି ଅରେନ୍‍, ଇୟାୱାଜା ରିଏରିଙ୍ଗ୍‌ ଅଡିନିଆଙ୍ଗିଁ ଆରାତି ଦୁତ୍‌କାଙ୍ଗ୍‌ ବାସ୍‌ତିମାରିକା ସୁଡ଼ୁତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ୱାର୍‌ ମରିୟମତିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ଇୟା, ନିନୁ ଏନ୍ଦା ଆଡ଼୍‌ବାଜିନି ?” ୱାଦ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାତ୍‌, “ଏର୍‌ ନା ପ୍ରବୁଙ୍ଗୁଁ ମେନ୍ଧଲ୍‍ ଅତାମାନାର୍‌, ମାରି ୱାନିଙ୍ଗ୍‌ ଏମେ ବାଡିଦୁ ଇଟ୍‌ତାମାନାର୍‌, ଆକା ନାନ୍ ନେସ୍‌ଏଜିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ୱାଦ୍‌ ଇକା ଇନ୍‌ଜି ୱେନ୍‌କା ମାର୍‌ଜିବେସ୍‌ସି ଜିସୁଙ୍ଗୁଁ ନିର୍‌ଇମାରିକା ସୁଡ଼ୁତାତ୍‌, ମାତର୍‌ ୱାନ୍‌ ଜେ ଜିସୁ, ଆକା ନେସ୍‌ଏତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ଜିସୁ ତାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନିନୁ ଏନ୍ଦା ଆଡ଼୍‌ବାଜିନି ? ଏଙ୍ଗ୍‌ ପୟ୍‌ଜିନି ?” ୱାଦ୍‌ ୱାନିଙ୍ଗ୍‌ ଡଡିଦୁ ପାଣିକିନିକାନ୍‌ ଇଜି ଅଡ଼୍‍ବିଜି ଇର୍ହାତ୍‌, ଆଜ୍ଞା, “ନିନ୍‌ ଜଦି ୱାନିଙ୍ଗ୍‌ ଅତିମାନି, ଆର୍‌ତିଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ ଏମେ ବାଡିଦୁ ଇଟ୍‌ତିମାନି, ନାଙ୍ଗିଁ ଇନ୍‌ଆଁ, ମାରି ନାନ୍ ୱାନିଙ୍ଗ୍‌ ଅନା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ଜିସୁ ତାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମରିୟମ୍‌ ।” ୱାଦ୍‌ ମାର୍‌ଜିବେସ୍‌ସି ଏବ୍ରି ବାସାଦାନ୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାତ୍‌, “ରାବ୍‌ବୁନି,” ଅର୍ତାତ୍‍, “ଏ ଗୁରୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ଜିସୁ ତାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନାଙ୍ଗିଁ ଆସ୍‌ସୋ ଇଡିମା, ଇରିଙ୍ଗ୍‌ ନାନ୍ ଇୟାସାନ୍ଦି ବୁବାଦି ଲାକ୍‌ତୁ ସୋଲ୍‌ଏନେ; ମାତର୍‌ ନା ତଡ଼ାନ୍‌କା ମାନୁ ସୋଲ୍‌ସ ଇନ୍‌ଆଁ, ନାନ୍ ନା ବୁବା ମାରି ୱାରି ବୁବା, ନା ମାପୁରୁ ମାରି ୱାରି ମାପୁରୁ ଲାକ୍‌ତୁ ସୋଲ୍‌ସିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ ସଲ୍‌ସି, ନାନ୍ ପ୍ରବୁଙ୍ଗ୍‌ ସୁଡ଼ୁତାମାନା, ମାରି ୱାନ୍‌ ନାଙ୍ଗିଁ ଇୟାୱିଜୁ ୱେର୍‌ତାମାନାନ୍‌ ଇଜି ସିସୁରିଙ୍ଗ୍‌ କାବୁର୍‌ ସିତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ଆୟାନାଣ୍ତିଙ୍ଗ୍‌ ୱାରାଦି ଆଗ୍‍ଡ଼ିରି ନାଣ୍ତିଙ୍ଗ୍‌ ମିଲ୍‌ମିଲିକା ବେଡ଼ାଦୁ ଏସ୍ତିୱାଲେ ସିସୁର୍‍ ଏମେ ଇଲ୍‌ତୁ ମାର୍ହାର୍‌, ଆବେଣି ସେର୍‍ଲେଙ୍ଗ୍‌ୱିଜୁ ଜିହୁଦିରି ତିଏଲ୍‌ତିଙ୍ଗ୍‌ କେର୍‌ତା ମାର୍ହାର୍‌, ନାସ୍ତିୱାଲେ ଜିସୁ ୱାଜି ନେଗି ନାଡ଼୍‌ମି ନିର୍‌ଆନ୍‌ନୋ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମିଙ୍ଗିଁ ସାନ୍ତି ଆପିତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ମାରି, ଇକା ଇନ୍‌ଜି ଜିସୁ ୱାରିଙ୍ଗ୍‌ ନିଜେଦି କିକୁ ମାରି ପାଡ଼୍‌କା ତର୍‌ତାନ୍‌ । ଆବେଟ୍‌ ସିସୁର୍‍ ପ୍ରବୁଙ୍ଗ୍‌ ସୁଡ଼ୁଜି ୱେଡ଼ିକା ଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ମାରିଡ଼େସି ଇର୍ହାନ୍‌, “ମିଙ୍ଗିଁ ସାନ୍ତି ଆପିତ୍‌; ବୁବା ଏଣ୍ତେସ୍‌ୱାଜା ନାଙ୍ଗିଁ ପୋକ୍‌ତାତାମାନାନ୍‌, ନାନ୍ ବା ଆୟାୱାଜା ମିଙ୍ଗିଁ ପୋକ୍‌ତାତାମାନା ।” ");
INSERT INTO kfcp_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ୱାନ୍‌ ଇକା ଇନ୍‌ଜି ୱାରି ମୁସ୍‌କୁ ନେଜ୍‌ଦେଙ୍ଗ୍‌ ଡ଼ିସ୍‌ତାନ୍‌ନୋ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ପବିତ୍ରଆତ୍ମାଦିଙ୍ଗ୍‌ ମାନାଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ମିର୍‌ ଜଦି ଏ ପାପ୍‌ କେମା କିନିଦେର୍‌, ୱାନି ପାପ୍‌ କେମା ଆନାତ୍‌, ମାରି, ଜଦି ଏ ପାପ୍‌ କେମା କିଇଦେର୍‌, ୱାନି ପାପ୍‌ କେମା ଆଏତ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ମାତର୍‌ ଜିସୁ ଏସ୍ତିୱାଲେ ୱାତାମାର୍ହାନ୍‌, ନାସ୍ତିୱାଲେ ବାରଲୋକା ଲୋଇରାନ୍‌ ତୋମା ଦର୍‌ତି ଅରେନ୍‍, ଆମାୱାନିଙ୍ଗ୍‌ “ଦିଦୁମ” ଇନାର୍‌, ୱାନ୍‌ ୱାରି ୱାଲେ ସିଲେତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ମାରି, ଆଇ ସିସୁର୍‍ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ମାପ୍‌ ପ୍ରବୁଙ୍ଗ୍‌ ସୁଡ଼ୁତାମାନାପ୍‌ ।” ମାତର୍‌ ତୋମା ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ୱାନି କିୟୁଦୁ କୁଟିଙ୍ଗ୍‌ଣି ସିନେଙ୍ଗ୍‌ ସୁଡ଼ୁଇତିଙ୍ଗ୍‌ ମାରି ଆୟାୱିଜୁ ବାଡିଦୁ ନା ଡ଼ାସ୍‌କେଙ୍ଗ୍‌ ସିଇତିଙ୍ଗ୍‌ ମାରି ୱାନି ପାଡ଼୍‌କାଦୁ ନା କିୟୁ ଇଡ୍‌ଇତିଙ୍ଗ୍‌ ନାନ୍ ମୁଡ଼ୁକେ ବିସ୍‌ବାସ୍‌ କିଏ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ଆଟ୍‍ଦିନ୍‍ ୱେନ୍‌କା ୱାନି ସିସୁର୍‍ ମାରିଡ଼େସି ଲୋଇ ମାର୍ହାର୍‌ ମାରି ତୋମା ୱାରି ୱାଲେ ମାର୍ହାନ୍‌ । ସେର୍‍ଲେଙ୍ଗ୍‌ ୱିଜୁ କେର୍‌ତିମାର୍‌ଇ ବେଡ଼ାଦୁ ଜିସୁ ୱାଜି ନେଗି ନାଡ଼୍‌ମି ନିର୍‌ଆନ୍‌ନୋ ଇର୍ହାନ୍‌, “ମିଙ୍ଗିଁ ସାନ୍ତି ଆପିତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ୱେନ୍‌କା ୱାନ୍‌ ତୋମାଦିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଇବେନୁ ନି ଡ଼ାସ୍‌କେଙ୍ଗ୍‌ ମୁଟ୍‌ଆ ନା କିୟୁଦିଙ୍ଗ୍‌ ସୁଡ଼ୁଆ ମାରି ନା ପାଡ଼୍‌କାଦୁ ନି କିୟୁ ମୁଟ୍‌ଆ; ଅବିସ୍‍ବାସ୍‍ କିଏଣ୍‌ଗା ବିସ୍‌ବାସ୍‌ କିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ତୋମା ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନା ପ୍ରବୁ, ନା ମାପୁରୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନିନ୍‌ ଇନିକା ନାଙ୍ଗିଁ ସୁଡ଼ୁତିଙ୍ଗ୍‌ ବିସ୍‌ବାସ୍‌ କିତିମାନି ? ମାତର୍‌ ଏର୍‌ ସୁଡ଼ୁଏଣ୍‌ଗା ବିସ୍‌ବାସ୍‌ କିତାମାନାର୍‌, ୱାର୍‌ ଦନ୍ୟ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ଜିସୁ ସିସୁରି ଆଗ୍‌ଡ଼ି ଇୟାୱାଜା ଏସ ମାରି ଇନିଇନି ଜାତିଦି କାବାଆନି ପାଣି କିତାନ୍‌, ଆୟାୱିଜୁ ଇୟା ବଇଦୁ ରାସାଏତ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ମାତର୍‌ ମିର୍‌ ଏଣ୍ତେସ୍‌ ବିସ୍‌ବାସ୍‌ କିଦୁ ଜେ, ଜିସୁ ମାପୁରୁଦି ମାରିନ୍‌ ମସିହ, ମାରି ବିସ୍‌ବାସ୍‌ କିଜ ଏଣ୍ତେସ୍‌ ମିର୍‌ ୱାନି ଦର୍‌ତାନ୍‌ ଜିବନ୍‌ ପୟ୍‌ଦୁ, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ଇୟାୱିଜୁ ରସାତାମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ତାନେୱେନ୍‌କା ଜିସୁ ତିବିରିୟା ଗାଡା ପାଡ଼ି ସିସୁରିଙ୍ଗ୍‌ ମାରିଡ଼େସି ତର୍‌ୟାଆତାନ୍‌ । ୱାନ୍‌ ଇୟାୱାଜା ତର୍‌ୟାଆତାନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ସିମୋନ ପିତର୍‌, ତୋମା, ଏଙ୍ଗ୍‌ ଦିଦୁମ ଇନାର୍‌, ଗାଲିଲିଦି କାନାଦିକାନ୍‌ ନିତନିଏଲ୍‍, ଜେବଦିରି ମାରିସିର୍‌ ମାରି ୱାନି ସିସୁରି ମାଣ୍‌କୁ ମାରି ରିଏର୍‌ ଉନ୍‌ଡ୍ରେମାନୁ ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ସିମୋନ ପିତର୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନାନ୍ ମିନ୍‌କୁ ଆସ୍‌ତେଙ୍ଗ୍‌ ସୋଲ୍‌ସିନା ।” ଆଇ ସିସୁର୍‍ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ମାପ୍‌ ବା ନି ୱାଲେ ସନାପ୍‌ ।” ୱାର୍‌ ସୋସିସଲ୍‌ସି ଡଙ୍ଗାଁଦୁ ଏକ୍‌ତାର୍‌ ମାରି ଜାଡ଼ି ପକ୍‌ତାର୍‌ ମାତର୍‌ ଆୟା ନାଡ଼ା ଇନିକା ଆସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‍ଏତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ମାତର୍‌ ମାର୍‌ନାଣ୍ଡିଙ୍ଗ୍‌ ଉଟ୍‌ଲା ନାଡ଼ାକାଦେ ଜିସୁ ଏର୍‌ ପାଡ଼ି ନିର୍‌ଆଁମାର୍ହାନ୍‌; ମାତର୍‌ ୱାନ୍‌ ଜିସୁ ଇଜି ସିସୁର୍‍ ନେସ୍‌ଏତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “କଡ଼ର୍‌ ମି ଲାକ୍‌ତୁ ଇନିକା ଉଣିକା ମାନାତ୍‌ ?” ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ସିଲେ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଡଙ୍ଗାଁଦି ଉଣେରି ତରିନ୍‌ ଜାଡ଼ି ପୋକ୍‌ତୁ, ମାରି ମିର୍‌ ଏସ ଆସ୍‌ନିଦେର୍‌ ।” ଆବେଟ୍‌ ୱାର୍‌ ଜାଡ଼ି ପୋକ୍‌ତାର୍‌, ମାରି ଉଣା ମିନ୍‌କୁ ୱାତେ ଜେ, ୱାର୍‌ ଜାଡ଼ି ରେଲ୍‌ଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ଆବେଟ୍‌ ଜିସୁ ଆମା ସିସୁଙ୍ଗୁଁ ଜିବନ୍‌ନୋଜି ମାର୍ହାନ୍‌, ୱାନ୍‌ ପିତରତିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଇକାନ୍‌ ତୋ ପ୍ରବୁ ।” ସିମୋନ ପିତର୍‌ ଇକାନ୍‌ ତୋ ପ୍ରବୁ ଇଜି ୱେନ୍‌ଜି ଡୁମ୍‍ଡା ମେନ୍ଧଲ୍‍ ଆତିମାନିଙ୍ଗ୍‌ ନିଜେଦି ଆଙ୍ଗିଁ ଆରାଜି ଏର୍‌ତୁ ଗାତ୍‌ତାନ୍‍; ");
INSERT INTO kfcp_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ମାତର୍‌ ଆଇ ସିସୁର୍‍ ମିନ୍‌କୁ ବର୍ତି ଆତିମାନି ଜାଡ଼ିଦିଙ୍ଗ୍‌ ରେଲ୍‌ଜି ରେଲ୍‌ଜି ଇସ୍ରି ଡଙ୍ଗାଁଦୁ ୱାତାର୍‌, ଇରିଙ୍ଗ୍‌ ୱାର୍‌ ପାଡ଼ିରାନ୍‌ ନାଣ୍ତ ଆକ ସିଲେତାର୍‌, କେବଲ୍‌ ଦୁଇସ ମୁରା ଆକ ମାର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ୱାର୍‌ ପାଡ଼ି ରେତାର୍‌ରୋ ଆବେନୁ ଡିବ୍‌କାଣି ସିସୁ, ମାରି ତାନି ମୁସ୍‌କୁ ୱେକ୍‌ତି ମିନ୍‌କୁ ମାରି ରୁଟି ଇଟ୍‌ତିମାରିକା ସୁଡ଼ୁତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମିର୍‌ ଇଲେଇ ଏମେ ମିନ୍‌କୁ ଆସ୍‌ତିମାନିଦେର୍‌, ଆବେନୁ ଏସ ତାଗାଟ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ସିମୋନ ପିତର୍‌ ସୋଲ୍‌ସି ସଏ ପସାସ୍‌ତିନି ପେରି ପେରି ମିନ୍‌କୁ ବର୍ତି ଆତିମାନି ଜାଡ଼ିଦିଙ୍ଗ୍‌ ପାଡ଼ି ରେଲ୍‌ଜିତାତାନ୍‌; ମାରି ନିସା ମିନୁୱାତିଙ୍ଗ୍‌ବା ଜାଡ଼ି ତେଉଏତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ୱାଜ ଉନ୍‌ଡ୍ରୁ ।” ସିସୁରି ମାଣ୍‌କୁ ଏନ୍‌ ନିନୁ ଇଜି ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାଦେଙ୍ଗ୍‌ ସାହାସ୍‌ କିଏଜିମାର୍ହାର୍‌, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ଜେ ପ୍ରବୁ, ଇକା ୱାର୍‌ ନେସ୍‌ତାମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ଜିସୁ ୱାଜି ରୁଟି ଅସି ୱାରିଙ୍ଗ୍‌ ସିତାନ୍‌, ମାରି ଆୟାୱାଜା ମିନ୍‌କୁ ବା ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ସାତିୱାରି ମାଣ୍‌କୁ ଜିବନ୍‌ଆଜି ନିଙ୍ଗିଁତି ୱେନ୍‌କା ଜିସୁ ସିସୁରିଙ୍ଗ୍‌ ଇକା ମୁନ୍‌ଡ୍ରି ଦେବେଙ୍ଗ୍‌ ତର୍‌ୟାଆତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ୱାର୍‌ ଉଟି ୱେନ୍‌କା ଜିସୁ ସିମୋନ ପିତରତିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ଏ ଜୋହନତି ମାରିନ୍‌ ସିମୋନ, ନିନୁ ଇନିକା ନାଙ୍ଗିଁ ୱାରିମାଣ୍‌କୁ ନାଣ୍ତ ଜିବନ୍‌ନୋଜିନି ?” ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ହୁଁ, ପ୍ରବୁ,” ନାନ୍ ଜେ ନିଙ୍ଗିଁ ଜିବନ୍‌ନୋଜିନା, ଆକା ନିନ୍‌ ନେସ୍‌ନି । ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନା ମେଣ୍ତାପିଲେକାଙ୍ଗ୍‌ ସାରାକିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ଜିସୁ ମାରିଡ଼େସି ରୁଣ୍ତି ଦେବେଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ଏ ଜୋହନତି ମାରିନ୍‌ ସିମୋନ, ନିନ୍‌ ଇନିକା ନାଙ୍ଗିଁ ଜିବନ୍‌ନୋଜିନି ?” ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ହୁଁ, ପ୍ରବୁ,” ନାନ୍ ଜେ ନିଙ୍ଗିଁ ଜିବନ୍‌ନୋଜିନା, ଆକା ନିନ୍‌ ନେସ୍‌ନି । ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନା ମେଣ୍ତେଆଙ୍ଗ୍‌ ନେଗେନ୍‌କିଜି ସାରାକିଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ଜିସୁ ମୁନ୍‌ଡ୍ରି ଦେବେଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ଏ ଜୋହନତି ମାରିନ୍‌ ସିମୋନ, ନିନ୍‌ ଇନିକା ନାଙ୍ଗିଁ ଜିବନ୍‌ନୋଜିନି ?” ନିନ୍‌ ଇନିକା ନାଙ୍ଗିଁ ଜିବନ୍‌ନୋଜିନି, ଇକା ଇନ୍‌ଜି ୱାନ୍‌ ମୁନ୍‌ଡ୍ରି ଦେବେଙ୍ଗ୍‌ ପିତରତିଙ୍ଗ୍‌ ୱେନ୍‌ବାନିଙ୍ଗିଁ ୱାନ୍‌ ଦୁଃକ୍‌ ଆଜି ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ପ୍ରବୁ, ନିନ୍‌ ୱିଜୁ ବିସୟ୍‌ ନେସ୍‌ନି; ନାନ୍ ଜେ ନିଙ୍ଗିଁ ଜିବନ୍‌ନୋଜିନା, ଆକା ନିନ୍‌ ନେସ୍‌ନି ।” ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନା ମେଣ୍ତେଆଙ୍ଗ୍‌ ସାରାକିଆ । ");
INSERT INTO kfcp_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ସତ୍‌ ସତ୍‍ନେ ନାନ୍ ନିଙ୍ଗିଁ ୱେର୍‌ସିନା, ମୁରୁଲି ମାନିୱାଲେ ନିନ୍‌ ନିଜେଦି ଜୁକିଦୁ ଗାଟି ତରାଜ ଏମେ ତରିନ୍‌ ବଦା, ଆୟା ତରିନ୍‌ ବୁଲାଜିମାର୍‌ଇ, ମାତର୍‌ ଡକ୍ରା ଆତିଙ୍ଗ୍‌ ନିନ୍‌ ନିଜେଦି କିୟୁ ପେରିନି ମାରି ଆଇକାନ୍‍ ଅରେନ୍‍ ନି ଜୁକିଦୁ ଗାଟି ତର୍‌ନାନ୍‌ନୋ, ଏମେ ତରିନ୍‌ ନିଙ୍ଗିଁ ବଦା ସିଲେତ୍‍, ଆୟା ତରିନ୍‌ ନିଙ୍ଗିଁ ଅନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ପିତର୍‌ ଏଣ୍ତେସ୍‌ୱାଜା ସାନିଦଣ୍ତୋତି ମାଣ୍‌କୁ ମାପୁରୁଙ୍ଗୁଁ ଦନ୍ୟବାଦ୍‌ କିନାନ୍‌, ଆବେଣି ମାଟା ସିଜି ୱାନ୍‌ ଇକା ଇର୍ହାନ୍‌ । ତାନେୱେନ୍‌କା ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନା ୱେନ୍‌କା ରାଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ଜିସୁ ଏମେ ସିସୁଙ୍ଗୁଁ ଜିବନ୍‌ନୋଜି ମାର୍ହାନ୍‌ ମାରି ଏନ୍‌ବା ନାଡ଼ାରିବଜିଦି ବେଡ଼ାଦୁ ଜିସୁଦି ବକାପାଡ୍‌କାଦୁ ଗେକାତାନ୍‌ନୋ, “ପ୍ରବୁ, ନିଙ୍ଗିଁ ଏନ୍‌ ସାତ୍ରୁରି କିୟୁଦୁ ସର୍‌ପେ କିନାନ୍‌ ଇଜି ୱେନ୍‌ବାତା ମାର୍ହାନ୍‌, ଆୟା ସିସୁଙ୍ଗୁଁ ପିତର୍‌ ମାର୍‌ଜିବେସ୍‌ସି ୱେନ୍‌କା ୱାଜିମାରିକା ସୁଡ଼ୁତାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ପିତର୍‌ ୱାନିଙ୍ଗ୍‌ ସୁଡ଼ୁଜି ଜିସୁଙ୍ଗୁଁ ୱେନ୍‌ବାତାନ୍‌, “ପ୍ରବୁ, ଇୟାୱାନି ବିସୟ୍‌ତାନ୍‌ ଇନିକା ଇଜିନି ?” ");
INSERT INTO kfcp_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନାନ୍ ମାରିଡ଼େସିୱାନି ସାନ୍ଦି ୱାନ୍‌ ଜିଜ ମାନିନ୍‌ ଇଜି ଜଦି ନାନ୍ ବଦା କିନା, ଆର୍‌ତିଙ୍ଗ୍‌ ଆବେଟ୍‌ ନିଙ୍ଗିଁ ଇନିକା ମାନାତ୍‌ ? ନିନୁ ନା ୱାଲେ ରାଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ଆବେଟ୍‌ ଆୟା ସିସୁ ଜେ ସାଏନ୍‌, ତଡ଼ାନ୍‌କା ଲୋଇ ଇୟା ମାଟା ୱେଙ୍ଗିଁତାତ୍‌, ମାତର୍‌ ୱାନ୍‌ ସାଏନ୍‌ ଇଜି ଜିସୁ ୱାନିଙ୍ଗ୍‌ ଇନ୍‌ଏନ୍‌ ମାର୍ହାନ୍‌, ମାତର୍‌ ନାନ୍ ଡ଼େସିୱାନି ସାନ୍ଦି ୱାନ୍‌ ଜିଜ ମାନିନ୍‌ ଇଜି ଜଦି ନାନ୍ ବଦା କିନା, ଆର୍‌ତିଙ୍ଗ୍‌ ଆବେଟ୍‌ ମିଙ୍ଗିଁ ଇନିକା ମାନାତ୍‌ ଇଜି ୱେର୍‌ତାମାର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ଏନ୍‌ ଇୟାୱିଜୁ ବିସୟ୍‌ତି ସାକ୍ୟ ସିଜିନାନ୍‌ ମାରି ଇୟାୱିଜୁ ରାସ୍‌ତାମାନାନ୍‌, ୱାନ୍‌ ଆୟା ସିସୁ; ମାରି, ୱାନି ସାକୟ୍ ଜେ ସତ୍‌, ଆକା ମାପ୍‌ ନେସ୍‌ନାପ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ମାରି, ଜିସୁ ମାରି ନାଣ୍ତ ପାଣି ବା କିତାମାର୍ହାନ୍‌, ଆୟାୱିଜୁ ଜଦି ଉନ୍‌ଡ୍ରି ଉନ୍‌ଡ୍ରି କିଜି ରାସାତିଙ୍ଗ୍‌ ମାନ୍ଦି, ଆର୍‌ତିଙ୍ଗ୍‌ ନିସ ବଇଙ୍ଗ୍‌ ରାସାତେ ମାନ୍ଦି ଜେ, ନା ବିସାର୍‌ତୁ ସାରାଦୁନିଆଦୁ ଆୟାୱିଜୁ ବଇଙ୍ଗ୍‌ ଇଡ୍‌ନି ଉଣ୍ତିଙ୍ଗ୍‌ ବାଡି ଆଏତାତ୍‌ମାନ୍ଦି ।");
INSERT INTO kfcp_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ଏ ଲାଡ୍‍ତି ତିୟପିଲ, ନା ପାର୍‌ତୁମ୍‌ ବଇଦୁ ଜିସୁ ୱାନି ପାଣି ଆରାମ୍‌ କିନି ଦିନ୍‍ତାନ୍‍ ଆମାୱିଜୁ ପାଣି କିତାମାର୍ହାନ୍‌ ମାରି ସିକିୟା ସିତାମାର୍ହାନ୍‍, ଆୟାୱିଜୁ ବିସୟ୍‌ତାନ୍‌ ରାସ୍‍ତାମାର୍ହା । ");
INSERT INTO kfcp_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ମୁସ୍‌କୁପୁର୍‌ ସନି ଆଗ୍‍ଡ଼ିନେ ଆମାୱାରିଙ୍ଗ୍‌ ୱାନ୍‌ ନିଜେଦି ସିସୁ ୱାଜା ଆସ୍‌କିତା ମାର୍ହାନ୍‌, ୱାରିଙ୍ଗ୍‌ ୱାନ୍‌ ପବିତ୍ରାଆତ୍ମାଦି ସାକ୍ତିଦାନ୍ ସିକିୟା ସିତାମାର୍ହାନ୍‌ ");
INSERT INTO kfcp_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ନାସ୍ତିୱାଲେ ୱାନ୍‌ ଜିବନ୍‌ ମାର୍ହାନ୍‌, ଇକା ପାରାମାଣ୍‌ କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ମାରି ସିସୁର୍‍ ନାମ୍‌ଇକା ଆକ କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ୱାନ୍‌ ୱାରି ସାତି ୱେନ୍‌କା ସାଲିସ୍‌ ଦିନ୍‌ ସାନ୍ଦି ଗାଦି ଦେବେଙ୍ଗ୍‌ ୱାରିଙ୍ଗ୍‌ ତରାୟା ଆତାମାର୍ହାନ୍‍ । ୱାର୍‌ ଜିସୁଙ୍ଗୁଁ ସୁଡ଼ୁତାମାର୍ହାର୍‌ ମାରି ଜିସୁ ୱାରିଙ୍ଗ୍‌ ମାପୁରୁଦି ରାଜି ବିସୟ୍‌ତାନ୍‌ ଇର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ୱାର୍‌ ଉନ୍‌ଡ୍ରେମାନୁ ମାନିୱାଲେ ଉଣିତିନିମାନୁ ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇୟା ମାଟା ସିତାନ୍‌ ଜିରୁସାଲାମ୍‌ ଡ଼ିସ୍‌ସୋ ସଲ୍‌ମାଟ୍‌ । ମୁସ୍‌କୁପୁର୍‌ତି ବୁବା ମିଙ୍ଗିଁ ଆମାକା ସିନାନ୍‌ ଇଜି ପାର୍‌ମାଣ୍‌ କିତାମାନାନ୍‌ ମାରି ଆମା ଦାନ୍‌ ବିସୟ୍‌ତାନ୍‌ ନାନ୍ ମିଙ୍ଗିଁ ୱେର୍‌ତାମାର୍‌ଆ, ଆକା ପଇନି ସାନ୍ଦି କାପ୍‌କିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ଜୋହନ ଏର୍‌ତୁ ଡୁବନ୍‌ ସିତାନ୍‌, ମାତର୍‌ ଏସ ଉଣା ଦିନ୍‌ ୱେନ୍‌କା ମିର୍‌ ପବିତ୍ର ଆତ୍ମାଦୁ ଡୁବନ୍‌ ଆନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ଅର୍‍ଲେନ୍‍ ପ୍ରେରିତ ସିସୁର୍‍ ଉନ୍‌ଡ୍ରେମାନୁ ମାନିୱାଲେ ଜିସୁଙ୍ଗୁଁ ୱେନ୍‍ବାତାର୍‌, “ପ୍ରବୁ, ନିନ୍‌ ଇନିକା ଇଲେଇ ଇସ୍ରାଏଲରିଙ୍ଗ୍‌ ୱାରି ରାଜି ଡ଼େସି ସିନି ?” ");
INSERT INTO kfcp_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ଜିସୁ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ୱେଡ଼ା ନି ଇଲେଇତିଙ୍ଗ୍‌ ନା ବୁବା ୱାନି ଆଡ୍‍ଗି କିଜି ଇଟ୍‌ତାମାନାନ୍‌ । ଇୟାୱିଜୁ ଏସ୍‌କାଙ୍ଗ୍‌ ଗଟାନାତ୍‌, ମିର୍‌ ନେସ୍‌ତେଙ୍ଗ୍‌ ଦର୍‌କାର୍‌ ସିଲେ । ");
INSERT INTO kfcp_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ମାତର୍‌ ମି ମୁସ୍‌କୁ ପବିତ୍ରଆତ୍ମା ରେତାତିଙ୍ଗ୍‌, ମିର୍‌ ସାକ୍ତିଦାନ୍ ପୁରା ଆନିଦେର୍‌ ମାରି ଜିରୁସାଲାମ୍‌, ସାରାୱିଜୁ ଜିହୁଦା ମାରି ସମିରୋଣ ମାରି ଦୁନିଆଦି ସାରାସାରିଇତି ସାନ୍ଦି ନା ଉଣ୍ତିଙ୍ଗ୍‌ ମିର୍‌ ସାକି ଆନିଦେର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ଇକା ୱେର୍‌ତି ୱେନ୍‌କା ଜିସୁଙ୍ଗୁଁ ମୁସ୍‌କୁପୁର୍‌ତୁ ସନିକା ୱାର୍‌ ସୁଡ଼ୁତାର୍‌ ମାରି କାଣ୍ତେକ୍‌ ବାଦ୍‍ଡ଼ତାନ୍‌ ୱାନ୍‌ ୱାରି କାଣାଗ୍‌ଦି ଆଗ୍‌ଡ଼ିରାନ୍‌ ସାୟାମାୟା ଆତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ୱାନ୍‌ ମୁସ୍‌କୁ ସୋରି ୱେନ୍‌କା ବା ୱାର୍‌ ତିର୍‌ତାନ୍‌ ସୁଡ଼ୁଜି ବାଦ୍‌ଡ଼ତିଙ୍ଗ୍‌ ବେସ୍‌ସି ତେବାତାମାର୍ହାର୍‌ । ଅଡ଼ିନିଆଙ୍ଗିଁ ଆରାତିକାର୍‌ ରିଏର୍‌ ଲୋକୁ ଆୟାଦାପ୍ରେନେ ୱାରି ଲାକ୍‌ତୁ ୱାଜି, ");
INSERT INTO kfcp_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ନିର୍ହା ଇର୍ହାନ୍‌, “ଏ ଗାଲିଲିଦି ଲୋକୁ, ଏନ୍ଦା ଇବେନୁ ନିର୍‌ଦେର୍‌ନୋ ବାଦ୍‌ଡ଼ତିଙ୍ଗ୍‌ ବେସ୍‌ସିନିଦେର୍‌ ? ଏ ଜିସୁ ମି ଲାକ୍‌ତୁରାନ୍‌ ସୋଲ୍‌ସି ମୁସ୍‌କୁପୁର୍‌ତୁ ଅତାର୍‌ । ମାତର୍‌ ୱାନ୍‌ ଆମା ୱାଜା ମୁସ୍‌ପୁର୍‌ତୁ ସନିକା ମିର୍‌ ସୁଡ଼ୁତିଦେର୍‌, ଟିକ୍‌ ଆୟାୱାଜା ୱାନ୍‌ ମାରିଡ଼େସି ୱାନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ତାନେୱେନ୍‌କା ପ୍ରେରିତ ସିସୁର୍‍ ଜିତ ଗରନ୍‌ତାନ୍‌ ଜିରୁସାଲମ୍‌ତୁ ଡ଼େସି ସୋର୍ହାର୍‌ । ଜିତ ଗରନ୍‌ ଗାଡ଼୍‌ତାନ୍‍ ଉନ୍‌ଡ୍ରେ କିଲମିଟର୍‌ ଆକ ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ଗାଡ଼୍‌ତୁ ସୋଲ୍‌ସି ୱାର୍‌ ତେବାଜିମାର୍‌ଇ ମୁସ୍‌କୁରି ବାକ୍‌ରାଦୁ ଡ଼ୁଗିତାର୍‌ । ଆୟା ପ୍ରେରିତ ସିସୁର୍‍ ଆଜିନାର୍‌ ପିତର, ଜୋହନ, ଜାକୁବ, ଆନ୍ଦ୍ରିୟ, ପିଲିପ୍‌, ଥୋମା, ବାର୍ତଲମି, ମାତିଉ, ଆଲପିଦି ମାରିନ୍‌ ଜାକୁବ, ଦେସ୍‌ତିଙ୍ଗ୍‌ଜିବନ୍‌ନୋନି ସିମୋନ ମାରି ଜାକୁବଦି ମାରିନ୍‌ ଜିହୁଦା । ");
INSERT INTO kfcp_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ୱାର୍‌ ବେଡ଼ାବେଡ଼ାଦୁ ଉନ୍‌ଡ୍ରେ ଦଲ୍‌ ୱାଜା ପାର୍‌ତାନା କିଦେଙ୍ଗ୍‌ ଉନ୍‌ଡ୍ରେମାନୁ ଆଜିମାର୍ହାର୍‍ ମାରି ୱାରି ୱାଲେ ଜିସୁଦି ଆଇସି ମରିୟମ୍‌ ମାରି ଆଇ ଆଇମେକ୍‍ ମାରି ଜିସୁଦି ତଡ଼ାନ୍‌କୁ ବା ଉଣ୍ତାଜି ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ଏସ ଦିନ୍‌ ୱେନ୍‌କା ସଏକଡ଼େ ଲୋକୁ ବିସ୍‌ବାସ୍‌ତି ତଡ଼ାନ୍‌କା ଉନ୍‌ଡ୍ରି ପେରି ମିଟିଙ୍ଗ୍‌ତୁ ପିତର ନିଲ୍‌ତାନ୍‌ନୋ ଇର୍ହାନ୍‌ ");
INSERT INTO kfcp_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“ତଡ଼ାନ୍‌କୁ ନି ତାଙ୍ଗିଁକି, ଆମା ଜିହୁଦା ଜିସୁଙ୍ଗୁଁ ଆସ୍‌ତେଙ୍ଗ୍‌ ଇଜି ସାତ୍ରୁରିଙ୍ଗ୍ ସାରି ତର୍‌ସି ଅତାମାର୍ହାନ୍‌, ଆୟା ବିସୟ୍‌ତାନ୍‌ ଦାଉଦ ପବିତ୍ରଆତ୍ମାଦି ମାଣାନ୍‌ ସାଲାଜି ବବିସ୍ୟତ ମାଟା ୱେର୍‌ତା ମାର୍ହାନ୍‌ । ଦାର୍ମୁସାସ୍ତ୍ରଦୁ ରାସ୍‌ତି ଆୟା ମାଟା ପୁରା ଆଦେଙ୍ଗ୍‌ ସତ୍‌ ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ମାରିବା ଜିହୁଦା ମା ଦଲ୍‌ତୁ ମାର୍ହାନ୍‌ ମାରି ମା ଅରେନ୍‌ ଅର୍‌ସେ ସେବା ପାଣି କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ଆସ୍‌କିଆତା ମାର୍ହାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ୱାନି ତାଗ୍‌ଇ ପାଣି ଉଣ୍ତିଙ୍ଗ୍‌ ଜିହୁଦା ପୟ୍‌ତିମାନି ଡାବୁଣାଙ୍ଗ୍‌ ଉନ୍‌ଡ୍ରି ବୁମି କଡ଼ାୟା ଆତାମାର୍ହାତ୍‌ ମାରି ଆୟା ବୁମିଦୁ ମେଡ଼େତାନ୍‌ନୋ ୱାନ୍‌ ସାତାନ୍‌ । ୱାନି ପଟା ପାଡିଜି ସୋଲ୍‌ସି ୱାସ୍‌କିଙ୍ଗ୍‌ ସତେ ସର୍‌ଏ । ");
INSERT INTO kfcp_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ଜିରୁସାଲାମ୍‌ତି ଗାଡ଼୍‌ତୁ ମାନି ୱିଜୁ ଲୋକୁ ଇୟାୱିଜୁ ନେସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‌ସି ୱାରି ବାସାଦାନ୍‌ ଆୟା ବୁମିଦି ଦରୁ “ଆକେଲ ଦାମା” ଅର୍ତାତ୍‍ “ନେତେର୍‌ ତି କିଡ଼ିଇ” ଇଜି ଇଟ୍‌ତାମାନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","ଇୟା ବିସୟ୍‌ତାନ୍‌ ଗିତସଂହିତା ବଇଦୁ ରାସାତାମାନାତ୍‌ “ୱାନି ଇଲୁ ସିମ୍ରା ଆପିତ୍‌, ଆବେନୁ ଏନ୍‌ ତେବାମାକିର୍‌, ମାରି ବା ରାସାତାମାନାତ୍‌; ଆଇକାନ୍‍ ଅରେନ୍‌ ୱାନି ପାଣିଦୁ ରାପିନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“ମାରି ପ୍ରବୁ ଜିସୁଦି ଡ଼େସିନିଙ୍ଗିଁନି ବିସୟ୍‌ତାନ୍‌ ସାକି ଆଦେଙ୍ଗ୍‌ ଇଜି ମାରି ଅରେନ୍‌ ମା ୱାଲେ ମିସାନିକା ଦର୍‌କାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ଜିସୁ ଜୋହନତି ମାଣାନ୍‌ ଡୁବନ୍‌ ଅତି ସମୟ୍‍ତାନ୍ ମୁସ୍‌କୁ ସନି ସାନ୍ଧି ୱିଜୁ ୱାଲେ ପ୍ରବୁ ଜିସୁ ମା ୱାଲେ ବୁଲାସାଲା କିନିୱାଲେ, ଏମେ ଲୋକୁ ମା, ଦଲ୍‌ତୁ ମାର୍ହାର୍‌ ଅରେନ୍ ୱାନିଙ୍ଗ୍‌ ଆସ୍‍କିଦେଙ୍ଗ୍‌ ଆନାତ୍‌ ଏମେ ଲୋକୁ ମା ଦଲ୍‍ତୁ ମାର୍ହାର୍‌, ୱାରି ଲୋଇରାନ୍‌ ଅରେନ୍‌ୱାନିଙ୍ଗ୍‌ ମାରିଡ଼େସି ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ଆସ୍‌କିଦେଙ୍ଗ୍‍ ଆନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ୱାର୍‌ ରିଏରି ଦରୁ ୱେର୍‌ତାର୍‌ ଜୋସେପ୍‌ ଏନ୍‌ ବର୍ସବା ମାରି ଜୁସ୍ତସ୍‍ ଇଜି ବା ଇନାର୍‌ ମାରି ମତିୟ । ");
INSERT INTO kfcp_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ମାରି ପାର୍‌ତନା କିତାର୍‍, “ପ୍ରବୁ, ନିନ୍‌ ୱିଜୁ ସିନ୍ତା ନେସ୍‌ନି । ଇୟା ରିଏରି ଲୋଇ ଏଙ୍ଗ୍‍ଁ ବାସେକିତିମାନି, ");
INSERT INTO kfcp_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ଇୟା ବେକ୍ତି ଜିହୁଦା ନିଜେଦିବାଡିଦୁ ସନି ଉଣ୍ତିଙ୍ଗ୍‌ ଇୟା ଏମେ ସେବା ମାରି ପେରିତ ସିସୁ ପାଣି କିନାନ୍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ତାନିୱେନ୍‍କା ରିଏରି ଲୋଇ ଅରେନ୍‌ୱାନିଙ୍ଗ୍‌ ବାସ୍‍କିଦେଙ୍ଗ୍‍ କୁଡ଼ୁକୁଡ଼ି ପକ୍‌ତାର୍‌ । ମାରି ମତିୟଦି ଦର୍‌ତାନ୍‌ କୁଡ଼ୁକୁଡ଼ି ସତାତ୍‍; ଆବେଟ୍‌ ୱାନ୍‌ ଏଗାର୍‍ ଲୋକୁ ସିସୁରି ୱାଲେ ମିସାତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ପେଣ୍ଟିକଷ୍ଟ ପଣ୍ତତି ନାଣ୍ଡିଙ୍ଗ୍ କ୍ରିସ୍ଟାନ୍‍ ଲୋକୁ ୱିଜେରେ ଉଣ୍ତ୍ରେ ବାଡିଦୁ ଉଣ୍ତାତା ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ଆୟାଦାପ୍ରେନେ ନାଣ୍ତ ଗାଲି ୱାନି ଆଉଲି ୱାଜା ବାଦଡ଼୍‍ତାନ୍‍ ଉଣ୍ତ୍ରି ବାଦଡ଼ତାନ୍‌ ଆଉଲି ଆତାତ୍‌ ମାରି ଏମେ ଇଲ୍‌ତୁ ୱାର୍‌ ବାସ୍‍ତାମାର୍ହାର୍‍, ଆକା ଆୟା ଆଉଲିଦାନ୍‍ ପୁରା ଆତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ତାନିୱେନ୍‍କା ୱାର୍‌ ସୁଡ଼ୁତାର୍‌, ଏସୋ ସିସୁ ୱେତଲ୍‍ ସାର୍‍ଜି ଆବେ ମାର୍ହି ୱିଜେରିଙ୍ଗ୍‍ ମୁଟ୍‍ତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ୱାର୍‌ ୱିଜେରେ ପବିତ୍ର ଆତ୍ମାଦୁ ପୁରା ଆତାର୍‌ ମାରି ଆତ୍ମାଦାନ୍‌ ସାଲାଜି ଆଇ ଆଇ ବାସାଦାନ୍‍ ମାଟା ଇଣ୍ତ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ଦୁନିଆଦି ୱିଜୁ ଦେସ୍‍ତାନ୍‍ ୱାତିମାନି ଜିହୁଦି ଦାର୍ମୁ ଲୋକୁ ୱିଜେରେ ଜିରୁସାଲାମ୍‍ତୁ ଉଣ୍ତାତା ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","କୁଟୁମ୍‍ତୁ ଆଜିମାନି ଆଉଲି ୱେନ୍‌ଜି, ନାଣ୍ତ ଲୋକ୍‌ ଆବେ ଉଣ୍ତାତାର୍‌ । କ୍ରିସ୍ତ ବିସ୍‍ବାସ୍‍ସିର୍‍ ଆବେ ଉଣ୍ତାତିମାନି ୱିଜେରି ବାସାଦାନ୍‍ ମାଟା ଇଜିମାନିକା ୱେନ୍‌ଜି ୱାରି ମନ୍‌ତୁ କାବାନିକା ୱାତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ମାରି, ୱାର୍‌ କାବାଆଜି ମାରି ବେମ୍‍ରିଆଜି ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌, “ଇୟାୱାଜା ୱାର୍‍ଗିଜିମାନି ଇୟା ଲୋକୁ ଇନିକା ଗାଲିଲିୟତିକାର୍‍ ଆଏର୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ଆରିଙ୍ଗ୍‌ ମାଡ୍‌ ୱିଜୁ ଏଣ୍ତେସ୍‌ ୱାରିଙ୍ଗ୍‌ ମା ନିଜେଦି ଜନମ୍‌ତି ବାସାଦାନ୍‍ ୱାର୍‍ଗିଜିମାନିକା ୱେନ୍‍ଜିନାପ୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ମାଡ୍‌ ପାର୍ତିୟ, ମାଦିୟ ମାରି ଏଲାମିୟ, ମାରି ମେସପଟାମିଆ, ଜିହୁଦା ଦେସ୍‌ ମାରି କାପ୍‍ପାଦକିଆ, ପନ୍ତ ମାରି ଆସିଆ, ");
INSERT INTO kfcp_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ପ୍ରୁଗିଆ ମାରି ପାମ୍ଫିଲିଆ, ମିସର୍‍ ମାରି କୁରିଣି ଲାକ୍‌ତୁରି ଲିବିୟା ରାଜିଦୁମାନିକାର୍‍ । ମାବାଣ୍‍କୁ ଏସୋ ଲୋକୁ ରୋମ୍‍ତାନ୍‍ ୱାତିମାନି ଜିହୁଦିର୍‌ ");
INSERT INTO kfcp_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ମାରି ଜିହୁଦି ଦାର୍ମୁ ଆତିମାର୍‍ଇ ଲୋକୁ; ମାରି ଏସୋ କ୍ରିତି ନି ଆରବିୟ ଦେସ୍‌ତି ଲୋକୁ । ମାରିବା ମାପୁରୁ ଏମେ କାବାଆନି ବିସୟ୍‌ ୱିଜୁ କିତାମାନାନ୍‍, ଆୟା ବିସୟ୍‌ତାନ୍‌ ମାପ୍‌ ୱିଜେରେ ୱାରିମାଣ୍‌କୁ ମା ନିଜେ ନିଜେଦି ବାସାଦାନ୍‍ ୱେନ୍‍ଡ୍ରେଙ୍ଗ୍‍ ଆଟ୍‍ସିନାପ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","କାବାନି ବେମ୍‍ରିଆଜି ୱାର୍‌ ନିଜେ ନିଜେଦିମାନୁ ୱେନ୍‍ବାଦେଙ୍ଗ୍‍ ଆସ୍‌ତାର୍‌, “ତେନି ଅର୍ତ ଇନିକା ?” ");
INSERT INTO kfcp_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ମାତର୍‌ ଆଇକାର୍‌ ବିସ୍‍ବାସିରିଙ୍ଗ୍‍ ୱେକ୍‍ରିସ୍‍ କିଜି ଇର୍ହାର୍‌, “ଇୟା ଲୋକୁ ଅଙ୍ଗୁର୍‌ରସ୍‌ ଉଣୁଜି ସସ୍‍ତା ମାନାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ତାନିୱେନ୍‍କା ଆଇ ଏଗାର୍‍ ଲୋକୁ ପ୍ରେରିତ ସିସୁରି ୱାଲେ ପିତର୍‌ ନିଙ୍ଗ୍‍ଜି ନାଣ୍ତ ଆଉଲି ଆଜି ଇର୍ହାନ୍‌, ଏ ଜିହୁଦି ତଡ଼ାନ୍‌କୁ ତାଙ୍ଗିଁକ୍‌ ମାରି ଜିରୁସାଲାମ୍‍ତୁ ବାସାତିମାନି ମଣ୍ତଲି, ନା ମାଟା ନେଗେନ୍‌ତାନ୍‌ ୱେନ୍‌ଡ୍ରୁ, ନାନ୍ ଇୟା ବିସୟ୍‌ତାନ୍‌ ବୁଜାକିଜି ଇନା । ");
INSERT INTO kfcp_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ମିର୍‌ ଅଡ଼୍‌ବିଜିନିଦେର୍‌, ଇୟାକାର୍‌ ସହସ୍‍ତିକାର୍‍ । ସିଲେ, ଇୟାକାର୍‌ ସହସ୍‍ତିକାର୍‍ ଆଏର୍‌ । ଇରିଙ୍ଗ୍‌ ଇଲେଇ ୱେଡ଼ା ସାଲ୍‍ଦି ନୋ ଗଣ୍ଟା । ");
INSERT INTO kfcp_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ମାତର୍‌ ବାବବାଦି ଜୟେଲ୍‍ ଏମେ ଗଟାନା ବିସୟ୍‌ତାନ୍‌ ବବିସତ୍‍ବାଣି ଇର୍ହାମାର୍ହାନ୍, ଆକା ଆୟାୱାଜା ଉନ୍‌ଡ୍ରି ଗଟନା; ");
INSERT INTO kfcp_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ମାପୁରୁ ଇନାନ୍‌; ୱିଜ୍‍ନି ଦିନ୍‍କାଙ୍ଗ୍‍ଁ ଇକା ୱିଜୁ ଗଟାନାତ୍‌, ନାନ୍ ୱିଜେରି ମୁସ୍‌କୁ ନା ଆତ୍ମା ୱାକ୍‌ନା ସିନା । ମି କଡ଼ର୍‌ ନି ଆଇଲିକ୍‌ ବାବବାଦି କିନାର୍‌ । ମି ମୁରୁଲିର୍‍ ଦର୍ସନ ସୁଣାର୍‍, ମାରି ନେତାର୍‍ ଲବେର୍‍ ସୁଣାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ହୁଁ ନା ଦାସ୍‍କୁ ଅର୍‌ସେ ମେମାରି ନି ଆଇମେକା ମୁସ୍‌କୁ, ଆୟା ଦିନ୍‍ତୁ ନା ଆତ୍ମା ୱାକ୍‍ନା ସିନା, ମାରି ୱାର୍‌ ନା ବାକ୍ୟ ୱେର୍‌ନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ନାନ୍ ବାଦଡ଼୍‍ ମୁସ୍‌କୁ କାବାଆନି ପାଣି ମାରି ଆଡ୍‍ଗିରି ଦୁନିଆଦୁ କାବାଆନି ପାଣିତର୍‍ନା । ନେତେର୍‌, ସିସୁ ମାରି ନାଣ୍ତ ଗଇଦାନ୍‌ ଦୁନିଆ ବର୍ତି ଆନାତ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ପ୍ରବୁଦି ପେରି ଗୌରବ୍‍ ଦିନ୍‍ତି ୱାନି ଆଗ୍‌ଡ଼ି ୱେଡ଼ା ସିକାଟି ଆନାତ୍‌ ମାରି ଲେଞ୍ଜୁ ନେତେର୍‌ ୱାଜା ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ନାସ୍ତିୱାଲେ ଏନ୍‌ ପ୍ରବୁଦି ଦର୍‌ତାନ୍‌ ପାର୍‌ତନା କିନାନ୍‌, ୱାନ୍‌ ରକିୟା ପୟ୍‌ନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ଏ ଇସ୍ରାଏଲ୍‌ତି ଲୋକୁ, ଇୟାୱିଜୁ ମାଟା ୱେନ୍‌ଡ୍ରୁ ! ନାଣ୍ତ ସାକ୍ତିଦି ପାଣି ମାରି କାବାନି ସିନା ଦାନ୍‌ ନାଜରିୟତିୟ ଜିସୁ ଜେ ମାପୁରୁ ପକ୍‍ତିକାନ୍ ଇଜି ପାର୍‍ମାଣ୍‍ କିଆୟ୍‍ ଆତାମାନାନ୍‍ ମାରି ମାପୁରୁ ସାକ୍ତି ପୁରାକିତିକାନ୍‍, ଇକା ମି ଲାକ୍‌ତୁ ସତ୍‌ ଆତାମାନାତ୍‌ । ମି ଲୋଇ ଇୟା ଇୟାୱିଜୁ ଗଟନା ଗଟାତାତ୍‍, ଆଦେଙ୍ଗ୍‌ ଇୟା ବିସୟ୍‌ତାନ୍‌ ମିର୍‌ ନେଗେନ୍‍କିଜି ନେସ୍‌ତିମାନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ମାପୁରୁ ୱାନି ଉପାୟ୍‌ ଇସାବ୍‌ତାନ୍‌ ଜିସୁଙ୍ଗୁଁ ମି କିୟୁଦୁ ସର୍ପେ କିଦେଙ୍ଗ୍‌ ତିର୍‍ କିତାମାର୍ହାନ୍‌ । ମାରି ମିର୍‌ ୱାନିଙ୍ଗ୍‌ ପାପିଲୋକା ମାଣାନ୍‌ କ୍ରୁସଦୁ ଏକିସ୍‍କିଜି ଡାକ୍‍ତି ମାର୍‌ଇଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ମାତର୍‌ ମାପୁରୁ ୱାନିଙ୍ଗ୍‌ ସାନି ମାଣ୍‌କୁ ଡ଼ିସିସ୍‍କିଜି ମାରିଡ଼େସି ନିକ୍‍ତାନ୍‍, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ସାତି ମାନୁ ତରାୟ୍‍ଆଜି ତେବାନିକା ଅସମ୍ଭବ । ");
INSERT INTO kfcp_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ଦାଉଦ ୱାନି ବିସୟ୍‌ତାନ୍‌ ଇନାନ୍‌, “ୱିଜୁ ସମୟ୍‍ତୁ ନାନ୍ ପ୍ରବୁଙ୍ଗୁଁ ନା ଆଗ୍‌ଡ଼ି ସୁଡ଼ୁତାମାନା, ୱାନ୍‌ ନା ତରିନ୍‌ ତେବାତାମାନାନ୍‌ । ଏନ୍‌ ନାଙ୍ଗିଁ ତିଲିସ୍‌ କିଦେଙ୍ଗ୍‌ ଆଟ୍‌ଏନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ଆଦେଙ୍ଗ୍‌ ନା ଜିବନ୍‌ ୱେଡ଼ିକାଦୁ ପୁରାଆତାମାନା, ନା ୱେତଲ ୱେଡ଼ିକାଆଜି ନିଙ୍ଗିଁଜିନାତ୍‍ । ମାରିବା ନାନ୍ ସାନିକିନ୍ଦା, ନା ପୁରା ମେନ୍ଦଲ୍‌ ଆସାଦୁ ତିର୍‌ତେବାନା, ");
INSERT INTO kfcp_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ଇରିଙ୍ଗ୍‌ ନିନ୍‌ ନାଙ୍ଗିଁ ସାନି ଦୁନିଆଦୁ ଡ଼ିସ୍‍ଇ; ନିନ୍‌ ନି ବିସ୍‍ବାସ୍‍ତି ଦାସ୍‍ତିଙ୍ଗ୍‍ ଦୁକିଗୁଟା ଲୋଇ ସାବ୍‍ଦେଙ୍ଗ୍‍ ଇଜି ଡ଼ିସ୍‌ସୋ ସିଇ । ");
INSERT INTO kfcp_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ନିନ୍‌ ନାଙ୍ଗିଁ ଜିବନ୍‌ତି ସାରି ତର୍‍ତିମାନି ମାରି ନି ଲାକ୍‍ତୁତେବାନିକା ନାଙ୍ଗିଁ ୱେଡ଼ିକାଦୁ ପୁରାକିନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ଏ ନା ଇସ୍ରାଏଲତି ତଡ଼ାନ୍‌କୁ ନି ତାଙ୍ଗିଁକ୍‍, ବୁଜାନିୱାଜା ନାନ୍ ମିଙ୍ଗିଁ ମା ଡକ୍ରାଦାଦା ରାଜା ଦାଉଦତି ବିସୟ୍‌ତାନ୍‌ ଏସ ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଦର୍‌କାର୍‌ ମାନାତ୍‌ ଇଜି ଅଡ଼୍‌ବିଜିନା । ୱାନ୍‌ ସିତିଙ୍ଗ୍‌ ମୁସ୍‌ତାର୍‌, ମାରି ୱାନି ଦୁକିଗୁଟା ନେର୍‌ ସାନ୍ଦି ଇବେ ମା ଲୋଇ ମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ୱାନ୍‌ ଅରେନ୍‌ ବାବବାଦି ମାର୍ହାନ୍‍, ଆଦେଙ୍ଗ୍‌ ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ମାପୁରୁଦି ଜିଦ୍‌ ମାଟା ନେସ୍‍ତାମାର୍ହାନ୍‍ । ଦାଉଦତି କୁଟୁମ୍‌ତି ଲୋଇ ଅରେନ୍‌ ୱାନିଙ୍ଗ୍‌ ରାଜା କିନାନ୍‌ ଇଜି ମାପୁରୁ ପାର୍‌ମାଣ୍‌ କିତାମାର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ମାପୁରୁ ୱାନିଦିନ୍‍ତୁ ଇନିକା କିଦେଙ୍ଗ୍‌ ସଲ୍‌ସିନାନ୍‌, ଦାଉଦ ଆକା ନେସ୍‌ସି, କ୍ରିସ୍ତ ଅର୍ତାତ୍‍ ମସିହଦି ମାରିଡ଼େସି ନିଙ୍ଗିଁନି ବିସୟ୍‌ତାନ୍‌ ଇର୍ହାମାନାନ୍‌; ୱାନ୍‌ ସାନି ଦୁନିଆଦୁ ଡ଼ିସାୟ୍‍ ଆଏତାନ୍‍ । ୱାନି ମେନ୍ଧଲ୍‍ ଦୁକିଗୁଟା ଲୋଇ ସାବ୍‍ଏତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ମାପୁରୁ ଇୟା ଜିସୁଙ୍ଗୁଁ ସାତିମାଣାନ୍‌ ମାରିଡ଼େସି ନିକ୍‍ତାମାନାନ୍‍ । ମାପ୍‌ ୱିଜେରେ ତେନି ସାକି । ");
INSERT INTO kfcp_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ଜିସୁ ୱାନି ବୁବା ମାପୁରୁଦି ଉଣେରି ତରିନ୍‌ ପେରାୟ୍‍ ଆତାମାନାନ୍‌ ମାରି ବୁବାଦି ଜିଦ୍‌ ଇସାବ୍‌ତାନ୍‌ ୱାନିମାଣ୍‌କୁ ପବିତ୍ର ଆତ୍ମା ପୟ୍‌ତାମାନାନ୍‌ । ଇଲେଇ ମିର୍‌ ଆମାକା ସୁଡ଼ୁଜିନିଦେର୍‍ ମାରି ୱେନ୍‌ଜିନିଦେର୍‌, ଆକା ୱାନି ଦାନ୍‌ । ଆକା ୱାନ୍‌ ମା ମୁସ୍‌କୁ ୱାକ୍‍ତା ସିତାମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ଦାଉଦ ନିଜେ ମୁସ୍‌କୁପୁର୍‌ତୁ ସଲ୍‍ଏନ୍‍ ମାର୍ହାନ୍‍, ମାତର୍‌ ୱାନ୍‌ ଇର୍ହାନ୍‌, ପ୍ରବୁ ନା ପ୍ରବୁଙ୍ଗୁଁ ଇର୍ହାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ନାନ୍ ନି ସାତ୍ରୁରିଙ୍ଗ୍ ନି ପାଦାମ୍‌ ଆଡ୍‍ଗି କିଇ ସାନ୍ଦି । ନା ଉଣେରି ତରିନ୍‌ ବାସ୍‌ସ ମାନ୍‌ଆ । ");
INSERT INTO kfcp_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“ମାରି ଇସ୍ରାଏଲ୍‌ତି ଲୋକୁ ୱିଜେରେ ସତ୍‍ତାନ୍‍ ନେସିର୍‍ ଜେ, ଇୟା ଏମେ ଜିସୁଙ୍ଗୁଁ ମିର୍‌ କ୍ରୁସଦୁ ଏକିସ୍‍ କିତିଦେର୍‍, ମାପୁରୁ ୱାନିଙ୍ଗ୍‌ ନେ ପ୍ରବୁ ନି କ୍ରିସ୍ତ ଅର୍ତାତ୍‍ ମସିହ କିତାମାନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ଇୟାୱିଜୁ ମାଟା ୱେନ୍‌ଜି ୱାରି ଜିବନ୍‌ ନାଣ୍ତ କିଲିବିଲି ଆତାତ୍‌ ମାରି ପିତର୍‌ ନି ଆଇ ପ୍ରେରିତ ସିସୁରିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, “ତଡ଼ାନ୍‌କୁ ମାପ୍‌ ଇନିକା କିନାପ୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ପିତର ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମିର୍‌ ୱିଜେରେ ପାପ୍‌ତାନ୍‌ ଡ଼େସିୱାଜି ମି ପାପ୍‌ କେମା ଆନି ଉଣ୍ତିଙ୍ଗ୍‌ ଜିସୁ କ୍ରିସ୍ତଦି ଦର୍‌ତାନ୍‌ ଡୁବନ୍‌ ଅତୁ; ଆର୍‌ତିଙ୍ଗ୍‌ ମିର୍‌ ମାପୁରୁଦି ଦାନ୍‌ ପବିତ୍ର ଆତ୍ମା ପୟ୍‌ନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ଇରିଙ୍ଗ୍‌ ମାପୁରୁଦି ପାର୍‌ମାଣ୍‌ ମି ଉଣ୍ତିଙ୍ଗ୍‌, ମି କଡ଼ରି ଉଣ୍ତିଙ୍ଗ୍‌ ମାରି ପ୍ରବୁ, ମାପୁରୁଦି ମାଣାନ୍‌ କୁକାୟ୍‍ଆତି ଆକ ତେବାଜିମାନି ୱିଜେରି ଉଣ୍ତିଙ୍ଗ୍‌ ଟିକ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ପିତର ୱାରିଙ୍ଗ୍‍ ମାଡ଼ିସ୍‍କିଜି ମାରି ନାଣ୍ତ ମାଟେଣାନ୍‍ ୱାରିଙ୍ଗ୍‌ ସାକି ସିଜି ଇର୍ହାନ୍‌, “ଇୟା ତାଗ୍‌ଇ ଲୋକା ମୁସ୍‍କୁ ୱାନି ସାସ୍ତିଦାନ୍‍ ନିଜେ ନିଜେଦିଙ୍ଗ୍‍ ରକିୟା କିଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ୱାରି ଲୋଇ ନାଣ୍ତ ଲୋକୁ ୱାନି ମାଟାଦୁ ବିସ୍‌ବାସ୍‌ କିଜି ଡୁବନ୍‌ ଅତାର୍‌ । ଆୟା ନାଣ୍ତିଙ୍ଗ୍ ତିନି ହାଜାର୍‌ ଲୋକୁ ଦଲ୍‍ତୁ ମିସାତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ଆୟାନାଣ୍ତିରାନ୍‍ ସିସୁର୍‍ ୱାରିଙ୍ଗ୍‌ ସିକିୟା ସିତାର୍‍ । ମାରି ୱାର୍‌ ମିସାବିଡ଼୍‍ ଆତାର୍‌, ରୁଟି ରୁକ୍‌ତେଙ୍ଗ୍‍ ମାରି ପାର୍‌ତାନା କିଦେଙ୍ଗ୍‌ ମୋନ୍‌ସିଜି ତେବାତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ପ୍ରେରିତ ସିସୁର୍‍ ନାଣ୍ତ କାବାଆନି ସିନେଙ୍ଗ୍‍ ମାରି କାବାଆନି ବିସୟ୍‌ କିତାନ୍‌ । ମାରି ୱିଜେରେ ଆବେନୁ ତିଲାତା ସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ବିସ୍‍ବାସ୍‍ସିର୍‍ ଆପ୍‍ଣା ଆପ୍‍ଣାଦି ୱାଲେ ଉନ୍‍ଡ୍ରେମାନୁ ମିସାତାର୍‍ ମାରି ମିସାଜି ୱାରି ୱିଜୁ ଦନ୍‌ ସିଜିସାଜି ଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ୱାର୍‌ ଆପ୍‍ଣା ଆପ୍‍ଣାଦି ମାନି ଦନ୍‌ତିଙ୍ଗ୍‍ ପର୍‌ଜି, ଡାବୁଙ୍ଗୁଁ ୱିଜେରି ଦର୍‌କାର୍‌ ଇସାବ୍‌ତାନ୍‌ ନିଜେନିଜେ ଲୋଇ ବାଟା କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ୱାର୍‌ ୱିଜୁଦିନ୍‌ ପାର୍‍ତନାକିନି ମନ୍ଦିର୍‌ତୁ ଉନ୍‍ଡ୍ରେ ଦଲ୍‌ ୱାଜା ଉଣ୍ତାଜି ମାର୍ହାର୍‌ ମାରି ଇଲ୍‌କାଙ୍ଗ୍‌ ଇଲ୍‌କାଙ୍ଗ୍‌ ରୁଟି ରୁକ୍‍ସି ୱେଡ଼ିକା ମନ୍‍ତାନ୍‍ ମାରି ନେଗି ଜିବନ୍‌ତାନ୍‌ ଉଣିତିନିକା କିଜି, ");
INSERT INTO kfcp_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ମାପୁରୁଦି ଦନ୍ୟବାଦ୍‌ କିଜି ୱିଜେରେ ଲୋକା ୱାଲେ ନେଗି ୱେଡ଼ିକା କିତାର୍‍ । ମାରି ପ୍ରବୁ ରକିୟା ପୟ୍‌ନି ଲୋକାଙ୍ଗ୍‌ ୱିଜୁଦିନ୍‌ ୱାରି ଦଲ୍‍ତୁ ମିସା କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ଅର୍‍ଲେନ୍‍ ପିତର ନି ଜୋହନ ପାର୍‌ତାନା ସମୟ ୱେଡ଼ାରେନି ତିନ୍‍ଟାଦୁ ମନ୍ଦିର୍‌ତୁ ସଲ୍‍ସିମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ଆବେନ୍‌ “ସୁନ୍ଦର୍‌” ଦର୍‌ତି ଦୁଆର୍‍ ଲାକ୍‌ତୁ ଅରେନ୍‌ ଲୋକୁ ମାର୍ହାନ୍‍ । ୱାନ୍‌ ଜନମ୍‍ତାନ୍‍ ସଟା । ମନ୍ଦିର୍‌ତୁ ସଲ୍‍ସିମାନି ଲୋକାମାଣ୍‌କୁ ଭିକିୟା ଲସ୍‌ତେଙ୍ଗ୍‌ ଇଜି ସବୁଦିନ୍‍ ୱାନ୍‌ ଦୁଆର୍‍ ଲାକ୍‌ତୁ ପିଣ୍ତାୟ୍‍ଆଜି ସଲ୍‍ସିମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ପିତର ନି ଜୋହନତିଙ୍ଗ୍‌ ମନ୍ଦିର ଲୋଇ ସନିକା ସୁଡ଼ୁଜି ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଭିକିୟା ଲସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ପିତର ନି ଜୋହନ ୱାନିଙ୍ଗ୍‌ ସିଦା ବେସ୍‍ତାର୍‍ ମାରି ପିତର୍‌ ଇର୍ହାନ୍‌, “ମା ତରିନ୍‍ ସୁଡ଼୍‌ଆ !” ");
INSERT INTO kfcp_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ଆବେଟ୍‌ ୱାନ୍‌ ୱାରିମାଣ୍‌କୁ ଏସ ପୟ୍‌ନି ଆସାଦାନ୍‍ ୱାରି ତରିନ୍‌ ବେସ୍‍ତାନ୍ । ");
INSERT INTO kfcp_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ମାତର୍‌ ପିତର୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନା ଲାକ୍‌ତୁ ବାଙ୍ଗାଁରାମ୍‍ ମାରି ୱେଣ୍ତି ସିଲେତ୍‌, ମାତର୍‌ ଆମାକା ମାନାତ୍‌, ନାନ୍ ନିଙ୍ଗିଁ ସିଜିନା : ନାଜରିୟତିୟ ଜିସୁ କ୍ରିସ୍ତଦି ଦର୍‌ତାନ୍‌ ନାନ୍ ଆଦେସ୍‌ ସିଜିନା, ନିଙ୍ଗଁଜ ବୁଲାଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ଇକା ଇଜି ୱାନ୍‌ ୱାନି ଉଣେରି କିୟୁ ଆସ୍‌ସି ନିକ୍‍ତାନ୍‍ । ଆୟାଦାପ୍ରେ ଲୋକ୍‌ତି ପାଦାମ୍‌ ନି ସିରାଗାଟିଙ୍ଗ୍‍ ୱିଜୁ ବପୁ ଆତେ । ");
INSERT INTO kfcp_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ୱାନ୍‌ ତୁଲ୍‍ଜି ନିଙ୍ଗିଁଜି ନିର୍‍ଆନ୍‍ ମାରି ବୁଲାଦେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ତାନିୱେନ୍‍କା ୱାନ୍‌ ବୁଲାବୁ ବୁଲାବୁ, ତୁଲ୍‍ବୁ ତୁଲ୍‍ବୁ ମାରି ମାପୁରୁଦି ଦନ୍ୟବାଦ୍‌ କିବୁ କିବୁ ୱାରି ୱାଲେ ମନ୍ଦିର୍‌ତୁ ସର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ଆବେଣି ଲୋକୁ ୱାନିଙ୍ଗ୍‌ ବୁଲାନିକା ନି ମାପୁରୁଦି ପ୍ରସଂସା କିନିକା ସୁଡ଼ୁତାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ୱାନିଙ୍ଗ୍‌ ମନ୍ଦିର୍ ଦୁଆର୍‍ ଲାକ୍‌ତୁ ବାସ୍‍ତିମାର୍‍ଇ ଭିକାରି ଇଜି ସିନିସ୍‍କିତାର୍‍ ମାରି ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ଇନିକା ଗଟାତାମାର୍ହାତ୍‍, ୱିଜୁ ନେସ୍‌ସି ୱାର୍‌ କାବାନି ବେମ୍‍ରି ଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ଆୟାକାନ୍‍ ପିତର୍‌ ନି ଜୋହନତି ୱାଲେ ସଲମନ୍‍ତି ଗୁଡିକାଲ୍‌ତୁ ମାନିକା ସୁଡ଼୍‌ଜି ଲୋକୁ କାବାଆଜି ଲାକ୍‌ତୁ ଉରୁକ୍‍ତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ପିତର୍‌ ୱାରିଙ୍ଗ୍‌ ସୁଡ଼ୁଜି ଇର୍ହାନ୍‌, ଏ ଇସ୍ରାଏଲ୍‌ତି ଲୋକୁ, ମିର୍‌ ଏନ୍ଦା ଇବେନୁ କାବାଆଜି ମା ତରିନ୍‌ ଇୟାୱାଜା ବେସ୍‍ସି ମାନିଦେର୍‌ ? ମିର୍‌ ଇନିକା ଅଡ଼୍‌ବିଜିନିଦେର୍‌ ଜେ ମା ନିଜେ ସାକ୍ତିଦାନ୍ ନି ମା ଦାର୍ମୁ ଉଣ୍ତିଙ୍ଗ୍‌ ମାପ୍‌ ଇୟା ଲୋକ୍‌ତି ବୁଲାନି ସାକ୍ତି ସିତାମାନାପ୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ଅବ୍ରାହାମ, ଇସ୍‌ହାକ୍‌ ମାରି ଜାକୁବଦି ମାପୁରୁ, ମା ଡକ୍ରାଦାଦାରି ମାପୁରୁ, ୱାନି ଦାସ୍‌ ଜିସୁଙ୍ଗୁଁ ମାପୁରୁଦି ଦନ୍ୟବାଦ୍‌ ସିତାମାନାନ୍‌ । ମାତର୍‌ ମିର୍‌ ୱାନିଙ୍ଗ୍‌ ଅଦିକାରିରି କିୟୁଦୁ ସର୍ପେ କିତିଦେର୍‍ । ଇୟାୱାଜାକି ପିଲାତ୍‌ ରାଜା ୱାନିଙ୍ଗ୍‌ ଡ଼ିସିସ୍‍ କିଦେଙ୍ଗ୍‌ ତିର୍‌ କିତିମାରିଙ୍ଗ୍‍ ବା, ୱାନିଙ୍ଗ୍‌ ପିଲାତ୍‌ ରାଜା ଆଗ୍‌ଡ଼ି ଅମାନ୍ୟ କିତିଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ୱାନ୍‌ ଅରେନ୍‌ ପବିତ୍ର ମାରି ଦାର୍ମୁ ଲୋକୁ, ମାତର୍‌ ମିର୍‌ ୱାନିଙ୍ଗ୍‌ ଅମାନ୍ୟ କିତିଦେର୍‍ ମାରି ୱାନି ବାଦ୍‌ଲୁ ମିଙ୍ଗିଁ ଦୟା ତର୍‌ସି ଅରେନ୍‌ ନର୍‍କାତ୍‍ନିୱାନିଙ୍ଗ୍‍ ଡ଼ିସିସ୍‍ କିଦେଙ୍ଗ୍‌ ଇଜି ପିଲାତ୍‌ ରାଜେଙ୍ଗ୍‍ ଇର୍‍ଇଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ଏନ୍‌ ଜିବନ୍‌ତି ସାରି ତର୍‍ନିକାନ୍‍, ମିର୍‌ ୱାନିଙ୍ଗ୍‌ ଡାକ୍‍ତିଦେର୍‍; ମାତର୍‌ ମାପୁରୁ ୱାନିଙ୍ଗ୍‌ ସାତିମାଣାନ୍‌ ମାରିଡ଼େସି ନିକ୍‍ତାନ୍‍ । ମାପ୍‌ ତାନି ସାକି । ");
INSERT INTO kfcp_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ୱାନି ଦର୍‌ତି ସାକ୍ତି ନେ ଇୟା ସଟେଙ୍ଗ୍‍ ନେଗେନ୍‌ କିତାମାନାତ୍‌ । ଏମେ ଗଟନା ଇଲେଇ ମିର୍‌ ନିଜେ ସୁଡ଼୍‌ଜି ସତ୍‌ ଇଜି ନେସ୍‌ତିମାନିଦେର୍‌, ଆକା କେବଲ୍‌ ୱାନି ଦର୍‌ତାନ୍‌ ବିସ୍‌ବାସ୍‌ କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ଆତାମାନାତ୍‌ । ଜିସୁମାନୁ ବିସ୍‌ବାସ୍‌ କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ୱାନ୍‌ ଜେ ନେଗେନ୍‌ ଆତାମାନାନ୍‌, ଇକା ମିର୍‌ ସୁଡ଼ୁତିମାନିଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“ମାରି ଇଲେଇ, ଏ ଇସ୍ରାଏଲ୍‌ତି ତଡ଼ାନ୍‌କୁ ନି ତାଙ୍ଗିଁକ୍‍, ମିର୍‌ ମାରି ମି ନେତାର୍‌ ଜିସୁଦି ଉଣ୍ତିଙ୍ଗ୍‌ ଆମାକା କିତିଦେର୍‍, ଆକା ନେସ୍‌ଏଣ୍ତା କିତିମାନିଦେର୍‍, ଇକା ନାନ୍ ନେସ୍‌ନା । ");
INSERT INTO kfcp_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ନାଣ୍ତ ବାର୍ସେକ୍‍ ଆଗ୍‌ଡ଼ି ୱିଜେରେ ବାବବାଦି ୱେୟୁଦୁ ମାପୁରୁ ୱେର୍‍ତା ମାର୍ହାନ୍‍ ଜେ, କ୍ରିସ୍ତଙ୍ଗ୍‌ ଦୁକ୍‍ବଗାଦେଙ୍ଗ୍‍ ଆନାତ୍‌ । ଇୟାୱାଜା ଇଲେଇ ଆକା ସତ୍‌ ଆତାମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ମାରି ଅନୁତାପ୍‍ କିଜି ମାପୁରୁ ତରିନ୍‌ ଡ଼େସି ରାଦୁ । ଆରିଙ୍ଗ୍‌ ୱାନ୍‌ ମି ପାପ୍‌ କେମା କିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ମାରି ପ୍ରବୁଦି ମାଣାନ୍‌ ମିର୍‌ ଆତ୍ମିକ ସାକ୍ତି ପୟ୍‌ନିଦେର୍‌ । ମାପୁରୁ ମି ଉଣ୍ତିଙ୍ଗ୍‌ ଆଗ୍‌ଡ଼ିରାନ୍‌ ବାସେଆତିମାନି ମସିହ ଜିସୁଙ୍ଗୁଁ ପକ୍‍ନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ପୁର୍ବେକାଡ଼ାଦି ପବିତ୍ର ବାବବାଦି ମାଣ୍‌କୁ ମାପୁରୁ ୱେର୍‌ତି ଇସାବ୍‌ତାନ୍‌ ୱିଜୁ ବିସୟ୍‌ତି ପୁନିକା ଆନି ସାନ୍ଦି ୱାନ୍‌ ମୁସ୍‌କୁପୁର୍‌ତୁ ତେବାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ଇୟା ବିସୟ୍‌ତାନ୍‌ ମୋସା ଇର୍ହାମାର୍ହାନ୍‌, ମି ପ୍ରବୁ ମାପୁରୁ ମି ତଡ଼ାନ୍‌କା ମାଣୁକୁ ମି ଲାକ୍‌ତୁ ନା ନାନି ଅରେନ୍‌ ବାବବାଦିଙ୍ଗ୍‍ ପକ୍‍ନାନ୍‍ । ୱାନ୍‌ ମି ନିଜେ ଲୋକା ଲୋଇରାନ୍‌ ଅରେନ୍‌ ଆନାନ୍‍ । ୱାନ୍‌ ମିଙ୍ଗିଁ ଆମାକା ଇନାନ୍‌, ଆୟାୱିଜୁ ବିସୟ୍‌ ମିର୍‌ ମାନାନିକା ମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ଏନ୍‌ ଆୟା ବାବବାଦିଦି ବାକ୍ୟ ମାନାଏନ୍‌, ୱାନିଙ୍ଗ୍‌ ମାପୁରୁଦି ଲୋକାମାଣ୍‌କୁ ୱେର୍‌ଏ କିଜି ନାସ୍ଟୁ କିଆୟ୍‍ଆନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ଇଲେଇ ଆମାକା ଗଟାଜିନାତ୍‍, ଆୟା ବିସୟ୍‌ତାନ୍‌ ସାମୁଏଲ୍‍ତି ୱାଲେ ୱିଜେରେ ବାବବାଦିର୍ ମାଟା ପ୍ରଚାର୍‌ କିଜି ଇର୍ହାମାର୍ହାନ୍‌ ମାରି ୱାରି ୱେନ୍‌କାରି ବାବବାଦିର୍ ବା ଇୟା ବିସୟ୍‌ତାନ୍‌ ୱେର୍‍ତା ମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ବାବବାଦିରି ୱେୟୁଦୁ ମାପୁରୁ ଏମେ ୱିଜୁ ପ୍ରତିଜ୍ଞା କିତାମାନାନ୍‍, ଆକା ମି ଉଣ୍ତିଙ୍ଗ୍‌ ଟିକ୍‌, ମାରି ମାପୁରୁ ମି ପୁର୍ବେଦିଡକ୍‌ରାଦାଦାରି ୱାଲେ ଏମେ ନିୟମ୍‌ କିତାମାନାନ୍‍, ମିର୍‌ ଆବେଣି ବାଗ୍‍ତିକାର୍‍ । ମାପୁରୁ ଅବ୍ରାହାମ୍‍ତିଙ୍ଗ୍‌ ଇର୍ହାମାର୍ହାନ୍‌, ମି କୁଟୁମ୍‌ତି ମାଣାନ୍‌ ନାନ୍ ଦୁନିଆଦି ୱିଜୁ ବାସାଦି ଲୋକାଙ୍ଗ୍‌ ଆସିର୍ବାଦ୍‌ କିନାପ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ଆଦେଙ୍ଗ୍‌ ମାପୁରୁ ୱାନି ଦାସ୍‌ତିଙ୍ଗ୍‌ ବାସେକିତାନ୍‍ ମାରି ମି ୱିଜେରିଙ୍ଗ୍‍ ତାଗ୍‌ଇ ସାରିଦାନ୍‍ ଡ଼େସିୱାନି ଆସିର୍ବାଦ୍‌ ସିଦେଙ୍ଗ୍‍ ଇଜି ଆଗ୍‌ଡ଼ି ୱାନିଙ୍ଗ୍‌ ମି ଲାକ୍‌ତୁ ପକ୍‌ତାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ପିତର୍‌ ନି ଜୋହନ ଲୋକାଙ୍ଗ୍‌ ଇୟାୱାଜା ସିକିୟା ସିଜିମାନି ୱାଲେ ମନ୍ଦିର୍‌ତି ଏସ ଜାଜକର୍‌, ମନ୍ଦିର୍‌ତି କାପ୍‍କିନିୱାରି ପେରିକାନ୍‌ ମାରି ଏସ ସାଦୁକିର୍ ୱାଜି ଇତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ୱାର୍‌ ରିସା ଆତାମାର୍ହାର୍‍, ଇରିଙ୍ଗ୍‌ ଜିସୁ ସାତିମାଣାନ୍‌ ମାରିଡ଼େସି ନିଙ୍ଗିଁନି ଇଜି ରିଏର୍‌ ପ୍ରେରିତର୍‍ ଲୋକାଙ୍ଗ୍‌ ସିକିୟା ସିଜି, ଇବେଣାନ୍‍ ସାତିକାର୍‍ ମାରିଡ଼େସି ନିଙ୍ଗ୍‍ନାର୍‍ ଇଜି ପାର୍‍ମାଣ୍‍ କିଜିମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ମାରି ୱାର୍‌ ୱାରିଙ୍ଗ୍‌ ତର୍‍ତାର୍‍ ମାରି ଆୟାନାଣ୍ତିଙ୍ଗ୍‌ ନାଣ୍ତ ୱେଡ଼ା ଆତାମାର୍ହାତ୍‍ଆକା ମାରିନାଣ୍ତିଙ୍ଗ୍‍ ସାନ୍ଦି ୱାରିଙ୍ଗ୍‌ ଜଇଲ୍‌ତୁ ଇଟ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ମାତର୍‌ ୱାରି ସିକିୟା ୱେର୍‍ଇମାର୍ହି ନାଣ୍ତ ଲୋକୁ ଆବେନୁ ବିସ୍‌ବାସ୍‌ କିତାର୍‍ ମାରି ୱାରି ସଂଖ୍ୟା ପିର୍‌ଜି ପାସ୍‌ ହାଜାର୍‌ ଆତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ମାର୍‌ନାଣ୍ତିଙ୍ଗ୍‍ ଜିହୁଦି ନେତାର୍‌, ମନ୍ଦିର୍‌ତି ଆଇନେତାର୍‍ ମାରି ଦାର୍ମୁଗୁରୁର୍‌ ଜିରୁସାଲାମ୍‍ତୁ ଉଣ୍ତ୍ରେମାନୁ ଉଣ୍ତାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ଆବେନୁ ୱିଜେରିଙ୍ଗ୍‍ ପେରି ଜାଜକ ହାନାନା, କୟାପା, ଜୋହନ, ଆଲେକ୍‍ଜାଣ୍ତର୍‍ ମାରି ୱିଜେରିଙ୍ଗ୍‍ପେରି ଜାଜକରି ଇଲ୍‍ତି ଆଇ ଲୋକାଙ୍ଗ୍‍ ମିସାତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ସିସୁରିଙ୍ଗ୍‌ ୱାରି ଆଗ୍‌ଡ଼ି ତାପିସ୍‍ କିଜି ୱେନ୍‌ବାତାର୍‌, “ମିର୍‌ ଇୟାୱିଜୁ ଏଣ୍ତେସ୍‌ କିଜିନିଦେର୍‌ ? ଏ ସାକ୍ତିଦାନ୍ ବା ଏ ଦର୍‌ତାନ୍‌ ଇକା କିଜିନିଦେର୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ଆବେଟ୍‍ ପିତର ପବିତ୍ର ଆତ୍ମାଦୁ ପୁରା ଆଜି ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଏ ଲୋକା ନେତାର୍‌ ମାରି ପେରିକାର୍‌ : ");
INSERT INTO kfcp_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ଜଦି ନେର୍‌ ମାଙ୍ଗିଁ ଇୟା ସଟା ଉଣ୍ତିଙ୍ଗ୍‌ କିତିମାନି ନେଗି ପାଣି ବିସୟ୍‌ତାନ୍‌ ମିର୍‌ ୱେନ୍‍ବାଜିନିଦେର୍‌ ମାରି ୱାନ୍‌ ଏଣ୍ତେସ୍‌ ନେଗେନ୍‍ ଆତାନ୍‍ ଇଜି ନେସ୍‌ତେଙ୍ଗ୍‌ ବଦାକିଜିନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ଆବେଟ୍‌ ମିର୍‌ ମାରି ଇସ୍ରାଏଲ୍‌ତି ୱିଜେରେ ନେସ୍‍ନିକା ମାନାତ୍‌ ଜେ, ମି ଆଗ୍‌ଡ଼ି ନିର୍‍ଇ ମାନି ଇୟା ଲୋକୁ କେବଲ୍‌ ନାଜରିୟତିୟ ଜିସୁ କ୍ରିସ୍ତଦି ଦର୍‌ତି ସାକ୍ତିଦାନ୍ ପୁରା ନେଗେନ୍‌ ଆତାମାନାନ୍‌ । ଆୟା ଜିସୁଙ୍ଗୁଁ ମିର୍‌ କ୍ରୁସଦୁ ଏକିସ୍‍କିତି ମାରିଇଦେର୍‍ । ମାତର୍‌ ମାପୁରୁ ୱାନିଙ୍ଗ୍‌ ସାତିମାଣାନ୍‌ ମାରିଡ଼େସି ନିକ୍‍ତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ଜିସୁଦି ବିସୟ୍‌ତାନ୍‌ ନେ ଦାର୍ମୁସାସ୍ତ୍ରଦୁ ରାସାତାମାନାତ୍‌, “ଏମେ କାଲୁଦିଙ୍ଗ୍‌ ଇଲୁ ତିଆର୍‌ କିନିକାର୍‍ ଡ଼ିସ୍‌ତାର୍‍, ମାତର୍‌ ଆୟା କାଲୁ ନେ କନାଦି ମୁଲ୍‌ କାଲୁ ଆତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","କେବଲ୍‌ ୱାନି ମାଣାନ୍‌ ରକିୟା ପୟ୍‌ନିକା ଆନାତ୍‌ । ସାରା ଦୁନିଆଦୁ ମାନି ଆଇ ଇନି ଦର୍‌ ମାଣାନ୍‌ ଲୋକୁ ରକିୟା ପୟ୍‌ଦେଙ୍ଗ୍‌ ଆଟ୍‌ଏନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ପିତର ନି ଜୋହନ ପଡ଼ାଇକାର୍‍ ମାରି ସାମାନ୍‌ତି ଲୋକୁ ଇଜି ପେରି ମିଟିଙ୍ଗ୍‍ତି ଜିହୁଦି ନେତାର୍‌ ନେସ୍‍ତାମାର୍ହାର୍‍ । ଆଦେଙ୍ଗ୍‌ ୱାରି ସାସ୍‌ ସୁଡ଼ୁଜି ୱାର୍‌ କାବାଆତାର୍‌ । ମାରି ୱାର୍‌ ନେସ୍‍ତାମାର୍ହାର୍‍, ଆୟା ରିଏର୍‌ ଜିସୁଦି ୱାଲେ ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ମାତର୍‌ ୱାର୍‌ ବିରୁଦ୍‌ କିଜି ଇନିକା ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆଟ୍‌ଏତାର୍‌; ଇରିଙ୍ଗ୍‌ ୱାର୍‌ ନେଗେନ୍‌ ଆତିମାର୍‍ଇ ଲୋକ୍‌ତିଙ୍ଗ୍‌ ପିତର ନି ଜୋହନତି ୱାଲେ ନିର୍‍ଇ ମାରିଇକା ସୁଡ଼ୁତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ଆବେଟ୍‌ ୱାର୍‌ ସିସୁରିଙ୍ଗ୍‌ ମିଟିଙ୍ଗ୍‍ ଇଲ୍‌ତାନ୍‌ ସପ୍‍ସି ସିଜି ୱାରି ବିସୟ୍‌ତାନ୍‌ ନିଜେ ନିଜେମାନୁ ୱାର୍‍ଗିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ୱାର୍‌ ଇର୍ହାର୍‌, “ମାଡ୍‌ ୱେରି ଉଣ୍ତିଙ୍ଗ୍‌ ଇନିକା କିନାଟ୍‍ ?” ଇକାର୍‌ କିତିମାନି ଇୟା କାବାଆନି ପାଣି ବିସୟ୍‌ତାନ୍‌ ଜିରୁସାଲାମ୍‌ତି ୱିଜେରେ ନେସ୍‌ତା ମାନାର୍‌ । ତେନି ସତ୍‌ ମାଡ୍‌ ମାରି ସିଲେ ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆଟ୍‍ଇକା । ");
INSERT INTO kfcp_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ମାତର୍‌ ଇୟା ମାଟା ଏଣ୍ତେସ୍‌ ଲୋକା ଲୋଇ ନାଣ୍ତ ୱେଙ୍ଗ୍‍ଁଏତ୍‍, ଜିସୁଦି ଦର୍‌ତାନ୍‌ ମାରି ଏସାଙ୍ଗ୍‍ ଆମାୱାରି ଆଗ୍‌ଡ଼ି ଇନିକା ଇନ୍‌ଇ ଉଣ୍ତିଙ୍ଗ୍‌ ଇୟାୱାରିଙ୍ଗ୍‌ ମାପ୍‌ ଜାଗାର୍‌ତା କିନା ସିନାଟ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ଆବେଟ୍‌ ୱାର୍‌ ପିତର୍‌ ନି ଜୋହନତିଙ୍ଗ୍‌ ମାରିଡ଼େସି ଲୋଇ କୁକିସ୍‍ କିତାର୍‍ ମାରି ଏସାଙ୍ଗ୍‍ ବା ଜିସୁଦି ଦର୍‌ତାନ୍‌ ଇନି ମାଟା ଇନ୍‌ଇ ଉଣ୍ତିଙ୍ଗ୍‌ ମାରି ସିକିୟା ସିଇ ଉଣ୍ତିଙ୍ଗ୍‌ ଜାଗାର୍‌ତା କିତା ସିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ମାତର୍‌ ପିତର ନି ଜୋହନ ଇର୍ହାର୍‌, “ମିଙ୍ଗିଁ ମାନାନିକା, ଅବା ମାପୁରୁଦିଙ୍ଗ୍‌ ମାନାନିକା ଏମେ ବିସୟ୍‌ ମାପୁରୁଦି ଆଗ୍‌ଡ଼ି ଟିକ୍‌, ଆକା ମିର୍‌ ବିସାର୍‌ କିଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ଇରିଙ୍ଗ୍‌ ମାପ୍‌ ଆମାକା ସୁଡ଼ୁତାମାନାପ୍‍, ମାରି ୱେର୍‍ଆମାନାପ୍‍, ଆୟା ବିସୟ୍‌ ଇନ୍‍ଏଣ୍ତା ତେବାଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏପ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ମାତର୍‌ ଜିହୁଦିର୍‌ ପେରି ମିଟିଙ୍ଗ୍‍ତୁ ଲୋକୁ ୱାରିଙ୍ଗ୍‌ ମାରି ଡାଟ୍‍ତାନ୍‌ ଆଦ୍‌ରିସ୍‌କିଜି ଡ଼ିସ୍‍ତା ସିତାର୍‍ । ୱାରିଙ୍ଗ୍‌ ଦଣ୍ଡ୍‌ ସିନିକା ଆଏତ୍‌ ଇଜି ୱାର୍‌ ନେସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‌ତାର୍‌, ଇରିଙ୍ଗ୍‌ ଆୟାଗଟନା ଉଣ୍ତିଙ୍ଗ୍‌ ଲୋକୁ ୱିଜେରେ ମାପୁରୁଦି ଦନ୍ୟବାଦ୍‌ କିଜିମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ଏମେ ଲୋକୁ କାବା ଇସାବ୍‌ତାନ୍‌ ନେଗେନ୍‌ ଆତାମାର୍ହାନ୍‍, ୱାନି ବୟସ୍‌ ସାଲିସ୍‍ ବାର୍ସେକ୍‍ତାନ୍‍ ନାଣ୍ତ ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ପିତର ନି ଜୋହନ ମୁକ୍‍ଡ଼ାତି ଦାପେ ଦାପେ ୱାରି ଦଲ୍‍ତୁ ଡ଼େସି ସର୍ହାର୍‍ ମାରି ପେରି ଜାଜକର୍‌ ମାରି ନେତାର୍‍ ଆମାକା ଇର୍ହାମାର୍ହାର୍‍, ଆକା ୱାରିଙ୍ଗ୍‌ ୱେର୍‍ତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ବିସ୍‍ବାସିର୍‍ ୱିଜୁ ମାଟା ୱେର୍‍ଇ ୱେନ୍‌କା ୱିଜେରେ ଉଣ୍ତାଜି ମାପୁରୁଦି ଲାକ୍‌ତୁ ଇୟା ପାର୍‌ତନା କିତାର୍‍, “ଏ ପ୍ରବୁ ! ମୁସ୍‌କୁପୁର୍‌, ଦୁନିଆଦୁ, ସାମ୍‌ଦୁର୍‌ ମାରି ଆବେମାନି ୱିଜୁ ବିସୟ୍‌ତି ତିଆର୍‍କିତିକିନ୍ଦା ! ");
INSERT INTO kfcp_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ପବିତ୍ର ଆତ୍ମାଦି ମାଣାନ୍‌ ନିନ୍‌ ମା ଡକ୍ରାଦାଦା ମାରି ନି ଦାସ୍‌ ଦାଉଦତି ୱେୟୁଦାନ୍‌ ଇୟା ମାଟା ୱେର୍‍ତିମାର୍ହି, “ଅଣଜିହୁଦିର୍‍ ଏନ୍ଦା ରିସା ଆତାର୍‌; ଲୋକୁ ଏନ୍ଦା ଆର୍‍ତିତାନିଙ୍ଗ୍‌ ଉପାୟ୍‍କିତାର୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ପ୍ରବୁଦି ବିରଦ୍‌ତାନ୍‌ ମାରି ୱାନି କ୍ରିସ୍ତ ଅର୍ତାତ୍‍ ମସିହଦି ବିରଦ୍‌ତାନ୍‌ ଦୁନିଆଦି ରାଜାର୍‌ ନିଜେଦିଙ୍ଗ୍‍ ତିଆର୍‌ କିତାର୍‍ ମାରି ସାସନ୍‍ କିନି ନେତାର୍‌ ଉଣ୍ତାତାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ସତ୍‌ତାନ୍‌ ଇୟା ଗାଡ଼୍‌ତୁ ହେରୋଦ ନି ପନ୍ତିୟ ପିଲାତ୍‌ ରାଜା ଅଣଜିହୁଦି ମାରି ଇସ୍ରାଏଲ୍‌ତି ଲୋକା ୱାଲେ ମିସାଜି ମି ମାଣାନ୍‌ ବାସେଆତି କ୍ରିସ୍ତ ଅର୍ତାତ୍‍ ମସିହ, ମି ପବିତ୍ର ଦାସ୍‌ ଜିସୁଙ୍ଗୁଁ ବିରଦ୍‌ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ମି ସାକ୍ତି ମାରି ବଦା ଇସାବ୍‌ତାନ୍‌ ଆମାକା ୱିଜୁ ଗଟେଆନି ଉଣ୍ତିଙ୍ଗ୍‌ ମିର୍‌ ଆସା କିତିମାର୍‍ଇଦେର୍‍, ୱାର୍‌ ଉଣ୍ତାଜି ଆୟାୱିଜୁ କିନି ଉଣ୍ତିଙ୍ଗ୍‌ ଲାଗେ ପଡ଼େଆତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ପ୍ରବୁ, ଇଲେଇ ୱାର୍‌ ମାଙ୍ଗିଁ ଏମେ ଆଦ୍‍ରିସ୍‍ କିତାମାନାର୍‍, ନିନ୍‌ ଆୟା ବିସୟ୍‌ତାନ୍‌ ମନ୍‍ ସିଆ ମାରି ସାହାସ୍‍ତାନ୍‍ ନି ବାକ୍ୟ ପ୍ରଚାର୍‌ କିଦେଙ୍ଗ୍‌ ଇଜି, ନି ଇୟା ଦାସ୍‍ରିଙ୍ଗ୍‍ ସାକ୍ତି କିଆ । ");
INSERT INTO kfcp_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ମାରି ନେଗେନ୍‌ କିଦେଙ୍ଗ୍‌ ଇଜି ନି କିୟୁ ପେର୍‌ଆ ମାରି ନି ପବିତ୍ର ଦାସ୍‌ ଜିସୁଦି ଦର୍‌ତାନ୍‌ କାବାଆନିକା ମାରି କାବାଆନି ପାଣି କିଦେଙ୍ଗ୍‌ ମାଙ୍ଗିଁ ସାକ୍ତି ସିଦା ।” ");
INSERT INTO kfcp_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ୱାର୍‌ ପାର୍‌ତନା ୱିସ୍‌ତି ୱେନ୍‌କା ଏମେ ବାଡିଦୁ ଉଣ୍ତାତା ମାର୍ହାର୍‌, ଆକା ଦୁଙ୍ଗିଁତା ସର୍ହାତ୍‍ । ୱାର୍‌ ୱିଜେରେ ପବିତ୍ରଆତ୍ମାଦୁ ପୁରା ଆତାର୍‌ ମାରି ସାହାସ୍‍ତାନ୍‍ ମାପୁରୁଦି ବାକ୍ୟ ପ୍ରଚାର୍‌ କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ବିସ୍‍ବାସ୍‍ସି ଦଲ୍‌ ଉନ୍‌ଡ୍ରି ଜିବନ୍‌ ମାରି ଉନ୍‌ଡ୍ରି ମନ୍‍ ଆତାର୍‌ । ଏନ୍‌ ନିଜେଦି ଦନ୍‍ତିଙ୍ଗ୍‍ ନିଜେଦିକା ଇଜି ଦାବି କିଏଜିମାର୍ହାର୍‌, ମାତର୍‌ ୱିଜେରି ଦନ୍‍ତିଙ୍ଗ୍‍ ୱାର୍‌ ସାମାନ୍‍ତାନ୍‍ ବାଟାକିଜି ସିଜିସାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ନାଣ୍ତ ସାକ୍ତିଦାନ୍ ପ୍ରେରିତ୍‍ର ସିସୁର୍‍ ପ୍ରବୁ ଜିସୁଦି ମାରିଡ଼େସି ନିଙ୍ଗିଁନି ବିସୟ୍‌ତାନ୍‌ ସାକିୟ ସିତାର୍‍ ମାରି ମାପୁରୁ ୱାରି ମୁସ୍‌କୁ ନାଣ୍ତ ଆସିର୍ବାଦ୍‌ ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ୱାରି ଦଲ୍‍ତୁ ଆମା ଲୋକୁ କାକୁର୍ତି ସିଲେତାନ୍‌ । ଏମେୱାରି ବୁମି ମାରି ଇଲୁ ମାର୍ହାତ୍‌, ୱାର୍‌ ଆକା ପର୍‍ସି ପର୍‍ତି ଦନ୍‌ତି ଡାବୁଙ୍ଗୁଁ ତାସି, ");
INSERT INTO kfcp_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ୱାର୍‌ ସିସୁରି ପାଦାମ୍‌ ଆଡ୍‍ଗି ଇଡ୍‌ଜିମାର୍ହାର୍‌ । ମାରି ଆୟା ଡାବୁଙ୍ଗୁଁ ୱାରି ଲୋଇ ଲୋକା ଦର୍‌କାର୍‌ ଇସାବ୍‌ତାନ୍‌ ବାଟା କିଜିମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ସାଇପ୍ରସ୍‍ ଦର୍‍ତି ବାଡିଦୁ ଜନମ୍‌ ଆତିମାର୍‍ଇ ଲେବି କଟୁମ୍‍ତି ଜସେପ୍‍, ଆମାୱାନିଙ୍ଗ୍‌ ପ୍ରେରିତ ସିସୁର୍‍ ବର୍ଣ୍ଣବା ଇଜି ଦର୍‌ ଇଟ୍‍ତାମାର୍ହାର୍‍, ବର୍ଣ୍ଣବାଦି ଅର୍ତ “ଦୁଃକ୍‌ତୁ ୱେଡ଼ିକାସିନି ମାରିନ୍‌” ");
INSERT INTO kfcp_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ୱାନି ବୁମି ପର୍‍ସି ଆବେଣି ଡାବୁଙ୍ଗୁଁ ତାସି ପ୍ରେରିତ ସିସୁରିଙ୍ଗ୍‌ ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ହନନିୟ ଦର୍‌ତି ଅରେନ୍‌ ଲୋକୁ ମାରି ୱାନି ଆଡ଼୍‌ସି ସପିରା ତାମେ ଏସ ବୁମି ପର୍‍ତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ମାତର୍‌ ଆଡ଼୍‌ସି ମାଟା ଆସ୍‌ସି ହନନିୟ ପର୍‍ତି ଡାବୁଙ୍ଗୁଁ ଏସ ନିଜେଦି ଉଣ୍ତିଙ୍ଗ୍‌ ଇଡ୍‌ଜି, ଏଜିତିକା ପ୍ରେରିତ ସିସୁରିଙ୍ଗ୍‌ ସିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ପିତର୍‌ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ହନନିୟ, ନି ଜିବନ୍‌ ୱିଜୁ ଏନ୍ଦା ସୟତାନ୍‍ତି ଆଡ୍‍ଗି ଆଜି ବୁମି ପର୍‌ଜି ପୟ୍‍ତିମାନି ଡାବୁଙ୍ଗୁଁ ଏସ ନିଜେଦି ଉଣ୍ତିଙ୍ଗ୍‌ ଇଡ୍‌ଜି ପବିତ୍ର ଆତ୍ମାଦିଙ୍ଗ୍‌ ମିସ୍‌ ଇର୍ହି ? ");
INSERT INTO kfcp_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ଦନ୍‌ ପର୍‌ନି ଆଗ୍‌ଡ଼ି ଆକା ନି ଅଦିକାର୍‌ ମାର୍ହାତ୍‌, ପର୍‌ନି ୱେନ୍‌କା ବା ଡାବୁଙ୍ଗୁଁ ନିଦି ମାର୍ହାତ୍‌, ଆର୍‍ତିଙ୍ଗ୍‍ଁ ନିନ୍‌ ଏନ୍ଦା ଇୟାୱାଜା ପାଣି କିଦେଙ୍ଗ୍‌ ମୋନ୍‌ କିତି ? ନିନ୍‌ ଲୋକାଙ୍ଗ୍‌ ମିସ୍‌ ୱେର୍‌ଇତି, ମାତର୍‌ ମାପୁରୁଙ୍ଗ୍‍ଁ ମିସ୍‌ ୱେର୍‌ତି ।” ");
INSERT INTO kfcp_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ହନନିୟ ଇୟା ମାଟା ୱେନି ଦାପ୍ରେ ଆଡ୍‍ଗି ଆର୍‍ଜି ସାତାନ୍‍; ମାରି ଏମେକାର୍‌ ଇୟା ମାଟା ୱେର୍‌ଆର୍‌, ୱାର୍‌ ୱିଜେରେ ନାଣ୍ତ ତିଲାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ମାରି, ମୁରୁଲିର୍‍ ହନନିୟଦି ସାତି ମାଡ଼ାଦିଙ୍ଗ୍‍ ୱାତିଦୁ ତେରେପ୍‍ସି ଆତ୍‌ରେ ଅତାର୍‌ ମାରି ମୁସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ମାରି ମୁନ୍‌ଡ୍ରି ଗନ୍‌ଟା ୱେନ୍‌କା ହନନିୟଦି ଆଡ଼୍‌ସି ୱାଜି ଇତାତ୍‍ । ୱାଦ୍‌ ଇୟା ଗଟ୍‍ନା ବିସୟ୍‌ ନେସ୍‍ଏତ୍‍ ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ପିତର ତାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ନାଙ୍ଗିଁ ଇନ୍‌ଆଁ, ନିନ୍‌ ମାରି ନି କନ୍‍ଲି ଆମା ବୁମି ପର୍‍ତିଦେର୍‍, ଇକା ଇନିକା ତାନି ପୁରା ଡାବୁଙ୍ଗୁଁ ?” ୱାଦ୍‌ ଇର୍ହାତ୍‌, “ହୁଁ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ପିତର୍‌ ତାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ପ୍ରବୁଦି ଆତ୍ମାଦିଙ୍ଗ୍‍ ପରିକା କିଦେଙ୍ଗ୍‌ ଇଜି ନିନ୍‌ ମାରି କନ୍‍ଲି ଏନ୍ଦା ବାସେ କିତିଦେର୍‍ ? ଏମେକାର୍‌ ନି କନ୍‍ଲିଙ୍ଗ୍‍ ମୁସ୍‌ତାର୍‌, ୱାର୍‌ ଇଲେଇ ସେର୍‍ଲା ଲାକ୍‌ତୁ, ୱାର୍‌ ନିଙ୍ଗିଁ ବା ପିଣ୍ତ୍‍ନା ଅନାର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ୱେନି ଆୟାଦାପ୍ରେ ୱାଦ୍‌ ପିତର୍‌ତି କାଲ୍‍କା ଲାକ୍‌ତୁ ଆର୍‍ଜି ସାତାତ୍‍ । ମୁରୁଲିର୍‍ ଲୋଇ ୱାଜି ତାନି ସାତି ମାନିକା ସୁଡ଼୍‌ଜି ତାନିଙ୍ଗ୍‌ ପିଣ୍ତ୍‍ଜି ଅତାର୍‌ ମାରି ତାନି କନ୍‍ଲିସିଦି ଗୁଟା ଲାକ୍‌ତୁ ତାନିଙ୍ଗ୍‌ ମୁସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ମଣ୍ତଲିଦି ପେରିକାର୍‌ ମାରି ଏମେକାର୍‌ ଇୟା ମାଟା ୱେର୍‌ଆର୍‌, ୱିଜେରେ ନାଣ୍ତ ତିଲାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ପ୍ରେରିତ ସିସୁରି ମାଣାନ୍‌ ଲୋକା ଲୋଇ ନାଣ୍ତ କାବାଆନି ପାଣି ଆଜିମାର୍ହାର୍‍, ୱିଜେରେ ବିସ୍‍ବାସିର୍‍ ସଲମନ୍‍ତି ଗୁଡିକାଲ୍‌ତୁ ଉଣ୍ତାଜି ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ୱାରି ବିସୟ୍‌ତାନ୍‌ ଲୋକୁ ନେଗି ମାଟା ଇଜିମାର୍ହାର୍‍, ମାତର୍‌ ଦଲ୍‌ ଆତ୍‌ରେ ମାନି ଲୋକୁ ଏନ୍‌ ୱାରି ୱାଲେ ମିସାଦେଙ୍ଗ୍‍ ସାସ୍‌ କିଏଜିମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ମାତର୍‌ ପ୍ରବୁମାନୁ ବିସ୍‌ବାସ୍‌ କିଜିମାନି ନାଣ୍ତ ଆଇମେକ୍‍ ନି ମେମାରିର୍‍ ଦଲ୍‍ତୁ ଡ଼ୁଗିତାର୍‍ ମାରି ଆୟା ବିସ୍‍ବାସି ଦଲ୍‌ ଦିନ୍‍ତିଙ୍ଗ୍‍ ଦିନ୍‌ ପିର୍‌ଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ପ୍ରେରିତ ସିସୁରି ପାଣି ନାଣ୍ତ ନେଗେନ୍‌ ଆତାତ୍‌, ଇୟାୱାଜାକି ପିତର୍‌ ବୁଲାଜି ସନିୱାଲେ ୱାନି ନିଡ଼୍‍ଗା ଆର୍‍ଦେଙ୍ଗ୍‍ ଇଜି ଲୋକୁ ରୋଗିଲୋକାଙ୍ଗ୍‍ ପିଣ୍ତ୍‍ଜିତାସି ସାର୍‍ଦୁ କାଟେଲ୍‍ ନି ଟାଟିଦୁ ତେର୍‍ପ୍‍ସି ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ଜିରୁସାଲାମ୍‌ତି ଲାକ୍‌ତୁରି ଗାଡ଼ାକାଣ୍‍କୁ ଉନ୍‌ଡ୍ରି ପେରି ଲୋକୁ ମାନ୍ଦା ରଗ୍‌ ନି ଦୁବା ଆସ୍‌ତି ଲୋକାଙ୍ଗ୍‌ ତାସି ସିସୁରି ଲାକ୍‌ତୁ ତାସିମାର୍ହାର୍‍ ମାରି ୱାର୍‌ ୱିଜେରେ ନେଗେନ୍‌ ଆଜିମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ତାନିୱେନ୍‍କା ୱିଜେରିଙ୍ଗ୍‍ ପେରି ଜାଜକ ମାରି ୱାନି ପାଣିକିନିକାର୍‍ ନି ଲାକ୍‌ତୁରି ସାଦୁକି ଦଲତୀ ଲୋକୁ ପ୍ରେରିତ ସିସୁରି ମୁସ୍‌କୁ ନାଣ୍ତ ରିସା ଆଜି ୱାରି ବିରୁଦ୍‍ତାନ୍‍ ପାଣି କିଦେଙ୍ଗ୍‌ ବାସେ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ୱାର୍‌ ପ୍ରେରିତ ସିସୁରିଙ୍ଗ୍‌ ତର୍‌ସି ଇସ୍ରି ଜଇଲ୍‌ତୁ ଇଟ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ମାତର୍‌ ଆୟା ନାଡ଼ା ପ୍ରବୁଦି ଅରେନ୍‌ ଦୁତ୍‍ ଜଇଲ୍‍ତି ସେର୍‍ଲା ରେତା ସିତାନ୍‌ ମାରି ପ୍ରେରିତ ସିସୁରିଙ୍ଗ୍‌ ଡ଼ିସିସ୍‍କିଜି ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“ସାନ୍‍ଡ୍ରୁ, ମନ୍ଦିର୍‌ତୁ ନିଲ୍‍ସି ଲୋକାଙ୍ଗ୍‌ ଇୟା ପୁନି ଜିବନ୍‌ ବିସୟ୍‌ତାନ୍‌ ୱିଜୁ ମାଟା ୱେର୍‍ତୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ପ୍ରେରିତ ସିସୁର୍‍ ୱାନି ମାଟା ମାନାଜି ସାଲ୍‍ଦି ମନ୍ଦିର୍‌ତୁ ଡ଼ୁଗୁଜି ସିକିୟା ସିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାର୍‌ । ୱିଜେରିଙ୍ଗ୍‍ପେରି ଜାଜକ ନି ୱାନି ୱାନି ପାଣିକିନିକାର୍‍ ପେରିମିଟିଙ୍ଗ୍‍ତି ଇନ୍‌ଡ୍ର ପୁରା ବାସ୍‌ନି ଉଣ୍ତିଙ୍ଗ୍‌ ଇସ୍ରାଏଲ୍‌ତି ୱିଜେରେ ଲୋକୁ ଜିହୁଦି ନେତାରିଙ୍ଗ୍‌ କୁକିସ୍‍ କିଜି ତାତାର୍‌ ମାରି ତାନିୱେନ୍‍କା ପ୍ରେରିତ ସିସୁରିଙ୍ଗ୍‌ ଆୟା ମିଟିଙ୍ଗ୍‍ତୁ ତାତେଙ୍ଗ୍‌ ଇଜି ପାଣିକିନିୱାରିଙ୍ଗ୍‌ ଜଇଲ୍‍ତୁ ପୋକ୍‌ତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ମାତର୍‌ ପାଣିକିନିକାର୍‌ ଜଇଲ୍‌ତୁ ପ୍ରେରିତ ସିସୁରିଙ୍ଗ୍‌ ପୟ୍‍ଏତାରୋ ଡ଼େସି ୱାଜି ପେରି ମିଟିଙ୍ଗ୍‍ତୁ ୱେର୍‌ତାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“ମାପ୍‍ ଜଇଲ୍‍ତୁ ଇତା ସୁଡ଼ୁତାପ୍‌, ଜଇଲି ଆଟ୍‍ୱାଦାନ୍‍ କେର୍‍ପାତା ମାନାତ୍‌ ମାରି କାପ୍‌କିନିକାର୍‌ ସେର୍‍ଲା ଆଗ୍‌ଡ଼ି କାପ୍‍କିଜିନାର୍‍, ମାତର୍‌ ସେର୍‌ଲା ରେତି ୱେନ୍‌କା ଲୋଇ ମାପ୍‌ ଏଙ୍ଗ୍‌ ପୟ୍‍ଏତାପ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ଇୟା ମାଟା ୱେନ୍‌ଜି ପେରି ଜାଜକ ନି ମନ୍ଦିର୍‌ କାପ୍‍କିନିୱାରି ଦାୟିତ୍‍ତୁ ମାନି ପାଣିକିନିକାନ୍‍ କାବାଆତାନ୍ । ପ୍ରେରିତ ସିସୁରିଙ୍ଗ୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ଇନିକା ଗଟାତାମାନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ନାସ୍ତିୱାଲେ ଅରେନ୍‌ ଲୋକୁ ୱାଜି ଇର୍ହାନ୍‌, “ୱେନ୍‍ଣ୍ତ୍ରୁ ! ଏମେ ଲୋକାଙ୍ଗ୍‌ ମିର୍‌ ଜଇଲ୍‌ତୁ ଇଟ୍‍ତିମାର୍ହିଦେର୍‍, ୱାର୍‌ ମନ୍ଦିର୍‌ତୁ ଲୋକାଙ୍ଗ୍‌ ସିକିୟା ସିଜିନାର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ମନ୍ଦିର୍‌ତି ପାଣିକିନିକାର୍‌ କାପ୍‍କିନିୱାରି ୱାଲେ ସଲ୍‍ସି ପ୍ରେରିତ ସିସୁରିଙ୍ଗ୍‌ ମାରିଡ଼େସି ତାସି ୱାତାର୍‌ । ୱାର୍‌ ଏଣ୍ତେସ୍‌ କିଜିବା ବପୁ ତିଗ୍‍ଏତାର୍‍, ଇରିଙ୍ଗ୍‌ ୱାରି ତିଏଲ୍‍ ମାର୍ହାତ୍‌ ଜେ ଲୋକୁ ୱାରି ମୁସ୍‌କୁ କାଲ୍‌କୁ ଡାକ୍‌ନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ୱାର୍‌ ପ୍ରେରିତ ସିସୁରିଙ୍ଗ୍‌ ଲୋଇ ଅସି ପେରିମିଟିଙ୍ଗ୍‌ ଆଗ୍‌ଡ଼ି ନିଲ୍‍ପ୍‍ତାର୍‍ ମାରି ୱିଜେରିଙ୍ଗ୍‍ପେରି ଜାଜକ ୱାରିଙ୍ଗ୍‌ ମାଟା ୱେନ୍‍ବାତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“ଇୟା ଲୋକ୍‌ତି ଦର୍‌ତାନ୍‌ ଇନି ସିକିୟା ସିଇ ଉଣ୍ତିଙ୍ଗ୍‌ ମାପ୍‌ ଡାଟ୍‍ ଆଦେସ୍‌ ସିତାମାର୍ହାପ୍‍, ମାତର୍‌ ସୁଡ଼୍‍ଦୁ, ମିର୍‌ ଇନିକା କିତିମାନିଦେର୍‍ ! ଜିରୁସାଲାମ୍‌ତି ୱିଜୁତରିନ୍‍ ମିର୍‌ ଇୟା ସିକିୟା ପ୍ରଚାର୍‌ କିତିମାନିଦେର୍‍ ମାରି ୱାନି ନେତେର୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ମିର୍‌ ମାଙ୍ଗିଁ ଦସ୍‌ କିଦେଙ୍ଗ୍‌ ସେସ୍ଟା କିଜିନିଦେର୍‌ !” ");
INSERT INTO kfcp_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ପିତର୍‌ ନି ଆଇ ସିସୁର୍‍ ଇର୍ହାର୍‌, “ମାପ୍‌ ମାପୁରୁଙ୍ଗୁଁ ମାନାନିକା ନେଗେତ୍‌, ଲୋକାଙ୍ଗ୍‌ ସିଲେ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ମିର୍‌ ଜିସୁଙ୍ଗୁଁ କ୍ରୁସଦୁ କୁଟିଙ୍ଗ୍‍ ଡାକ୍‍ସିସାପିସ୍‍ତି ୱେନ୍‌କା, ମା ଡକ୍ରାଦାଦାରି ମାପୁରୁ, ଜିସୁଙ୍ଗୁଁ ସାତିମାଣାନ୍‌ ମାରିଡ଼େସି ନିକ୍‍ତାମାନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ଇସ୍ରାଏଲ୍‌ତି ଲୋକାଙ୍ଗ୍‌ ଏତ୍‌କିଜି ମନ୍‌ତିଙ୍ଗ୍‌ ଡ଼େପିସ୍‌ ପାପ୍‌ କେମା ପୟ୍‍ନି ସୁଜୋଗ ସିନି ଉଣ୍ତିଙ୍ଗ୍‌ ମାପୁରୁ ୱାନିଙ୍ଗ୍‌ ନେତା ନି ରକିୟାକର୍ତା ୱାଜା ନିକ୍‍ତାମାନାନ୍‍ ମାରି ୱାନି ଉଣେରି ତରିନ୍‌ ଇଟ୍‌ତାମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ମାପ୍‌ ଇୟାୱିଜୁ ବିସୟ୍‌ତି ସାକି । ମାରି ଏମେ ପବିତ୍ର ଆତ୍ମାଦିଙ୍ଗ୍‍ ମାପୁରୁ ୱାନି ମାନାନିୱାରିଙ୍ଗ୍‍ ଦାନ୍‌ ସିତାମାନାନ୍‌, ୱାନ୍‌ ବା ତେନିସାକି ।” ");
INSERT INTO kfcp_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ପେରିମିଟିଙ୍ଗ୍‍ତି ଲୋକୁ ଇୟା ମାଟା ୱେନ୍‌ଜି ନିସା ରିସା ଆତାର୍‌ ଜେ, ୱାର୍‌ ସିସୁରିଙ୍ଗ୍‌ ଡାକ୍‌ତେଙ୍ଗ୍‍ଁ ବଦା କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ମାତର୍‌ ୱାରି ଲୋଇ ଗମଲିଏଲ ଦର୍‌ତି ଅରେନ୍‌ ପେରି ପାରୁସି ଦାର୍ମୁଗୁରୁ ପେରିମିଟିଙ୍ଗ୍‍ତୁ ନିଲ୍‍ସି ପ୍ରେରିତ ସିସୁରିଙ୍ଗ୍‌ ଆତ୍‌ରେ ଅତେଙ୍ଗ୍‌ ଇଜି ଆଦେସ୍‌ ସିତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ପେରିମିଟିଙ୍ଗ୍‍ତି ଲୋକାଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଇସ୍ରାଏଲ୍‌ତି ଲୋକୁ, ଇୟା ଲୋକାଙ୍ଗ୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ଆମାକା କିଦେଙ୍ଗ୍‌ ସଲ୍‍ସିନିଦେର୍‍, ଅଡ଼ପ୍‌ ଜାଗାର୍‍ତାଦାନ୍‍ କିନିଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ମି ମନ୍‌ତୁ ତେବାତାତ୍‍, ଏସ ସମୟ ଆଗ୍‌ଡ଼ି ତିହୁଦା ନିଜେଦିଙ୍ଗ୍‍ ଅରେନ୍‌ ପେରିଲୋକ୍‍ ଇଜି ଇର୍ହାନ୍‌, ମାରି ପାକାପାକି ଚାରିସ ଲୋକୁ ୱାନି ୱାଲେ ମିସାତାମାର୍ହାର; ମାତର୍‌ ୱାନ୍‌ ସାତାନ୍‍, ୱାନି ୱାଲେ ବୁଲାନିକାର୍‍ ଇନିଙ୍ଗାଁ ଆନିଙ୍ଗାଁ ଆତାର୍‌ ମାରି ୱାନି ଦଲ୍‌ ମାର୍‍ଗିତା ସର୍ହାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ତାନିୱେନ୍‍କା ଲୋକୁ ଲେକିସ୍‍ନି ୱେଡ଼ାଦୁ ଗାଲିଲିଦୁ ଜିହୁଦା ଦର୍‌ତି ମାରି ଅରେନ୍‌ ୱାତାନ୍‌, ୱାନ୍‌ ବା ନାଣ୍ତ ଲୋକାଙ୍ଗ୍‌ ୱାନି ଦଲ୍‍ତୁ ମିସାକିତାନ୍‌ । ମାତର୍‌ ୱାନ୍‌ ବା ସାତାନ୍‍ ମାରି ୱାନି ୱାଲେ ବୁଲାନିକାର୍‍ ଇନିଙ୍ଗାଁ ଆନିଙ୍ଗାଁ ଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ଆବେଟ୍‌ ଇୟା ବିସୟ୍‌ତାନ୍‌ ଇୟା ଲୋକା ବିରଦ୍‌ତାନ୍‌ ଇନି ପାଣି କିଇ ଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ମାଟା ସିଜିନା । ୱାରି ବିସୟ୍‌ତାନ୍‌ ମନ୍‍ ସିମାଟ୍‍ । ୱାରି ଉପାୟ ନି ପାଣିଦି ସନିକା ଜଦି ଲୋକା ମାଣ୍‌କୁ ଆନାମାନାତ୍‍, ଆରିଙ୍ଗ୍‌ ତାନି ବିସୟ୍‌ ମାର୍‍ଗ୍‍ନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ମାତର୍‌ ଜଦି ଆକା ମାପୁରୁ ମାଣ୍‌କୁ ଆନାମାନାତ୍‍, ଆରିଙ୍ଗ୍‌ ୱାରିଙ୍ଗ୍‌ ଆରାକିନିକା ମି ଉସାସ୍‌ ସିଲେ । ଆନାତ୍‌ ତରାନାତ୍‍ ଜେ ମିର୍‌ ମାପୁରୁ ବିରଦ୍‌ତାନ୍‌ ଜୁଦ୍‍ କିତିମାନିଦେର୍‍ ।” ପେରିମିଟିଙ୍ଗ୍‌ ଲୋକୁ ଗମଲିଏଲ୍‍ତି ମାଟା ମାନାତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ୱାର୍‌ ପ୍ରେରିତ ସିସୁରିଙ୍ଗ୍‌ ଲୋଇ କୁକ୍‌ସି, ୱାରିଙ୍ଗ୍‌ କର୍‍ଡା ଡାକିସ୍‍କିତାର୍‍ ମାରି ଜିସୁଦି ଦର୍‌ତାନ୍‌ ଇନି ମାଟା ଇନ୍‌ଇ ଉଣ୍ତିଙ୍ଗ୍‌ ଆଦେସ୍‌ ସିଜି ଡ଼ିସ୍‍ତା ସିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ପ୍ରେରିତ ସିସୁର୍‍ ୱେଡ଼ିକାଦାନ୍‌ ପେରିମିଟିଙ୍ଗ୍‍ତାନ୍‍ ସତାସର୍‌ର୍ହାର୍‌, ଇରିଙ୍ଗ୍‌ ମାପୁରୁଦି ଆଗ୍‌ଡ଼ି ୱାର୍‌ ଜିସୁ ଉଣ୍ତିଙ୍ଗ୍‌ ଅପମାନ୍‍ ପୟ୍‌ଦେଙ୍ଗ୍‌ ଇଜି ଜଗ୍‌ ଅଡ଼ବିତା ମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ମାରି ୱାର୍‌ ଦିନାମି ମନ୍ଦିର୍‌ତୁ ମାରି ଲୋକା ଇଲ୍‍କାଙ୍ଗ୍‍ଁ ମସିହ ଜିସୁଦି ବିସୟ୍‌ତାନ୍‌ ନେଗିକାବୁର୍‌ ପ୍ରଚାର୍‌ କିତାର୍‍ ମାରି ସିକିୟା ସିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ଏସ ସମୟ ୱେନ୍‌କା ସିସୁରି ଦଲ୍‌ ପିର୍‍ନି ଦାପେ ଦାପେ ଏବ୍ରି ବାସାଦି ଜିହୁଦିର୍‍ ମାରି ଆବେ ମାନି ଜିହୁଦି ଲୋକା ଲୋଇ ଜାଟିଙ୍ଗ୍‍ଁ ଆତାର୍‌ । ଦିନାମିଦି କାଦି କି ଡାବୁଙ୍ଗୁଁ ବାଟାକିନିୱାଲେ ୱାରି ରାଣ୍ତିଆଇମେକାଙ୍ଗ୍‍ଁ ନେଗେନ୍‌ ସୁଡ଼ୁଏଜିନାର୍‍ ଇଜି ଗ୍ରିକ୍‍ବାସା ୱାର୍‍ଗିନି ଜିହୁଦିର୍‌ ଦାବି କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ଆବେଟ୍‌ ବାର୍‍ ଲୋକୁ ପ୍ରେରିତ ସିସୁର୍‍ ୱିଜୁ ବିସ୍‍ବାସି ଦଲ୍‍ତିଙ୍ଗ୍‍ ଉଣ୍ତା କିଜି ଇର୍ହାନ୍‌, “ଡାବୁଙ୍ଗୁଁ ସାଲାକିନି ଉଣ୍ତିଙ୍ଗ୍‌ ମାପୁରୁଦି ବାକ୍ୟ ପ୍ରଚାର୍‌ କିଦେଙ୍ଗ୍‌ ଗାଡ଼୍‍ୟା ଆନିକା ମା ଉଣ୍ତିଙ୍ଗ୍‌ ଟିକ୍‌ ସିଲେ । ");
INSERT INTO kfcp_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ଆଦେଙ୍ଗ୍‌ ଏ ତଡ଼ାନ୍‌କୁ ନି ତାଙ୍ଗିଁକି ମି ମାଣ୍‌କୁ ପବିତ୍ର ଆତ୍ମା ନି ବୁଦିଦୁ ପୁରା ଆତିମାନି ସାତ୍ ଲୋକାଙ୍ଗ୍‌ ଆସ୍‍କିଦୁ । ମାଡ୍‌ ୱାରିଙ୍ଗ୍‌ ଇୟା ବିସୟ୍‌ତୁ ଦାୟିତ୍‍ ସିନାଟ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ଆର୍‍ତିଙ୍ଗ୍‍ଁ ପାର୍‌ତାନା ନି ପ୍ରଚାର୍‌ ସେବା ପାଣିଦୁ ମାଡ୍‌ ପୁରା ସମୟ ସିଦେଙ୍ଗ୍‍ ଆଟ୍‍ନିକା ।” ");
INSERT INTO kfcp_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ଦଲ୍‌ତି ୱିଜେରେ ପ୍ରେରିତ ସିସୁରି ଇୟା ମାଟାଦୁ ୱେଡ଼ିକା ଆତାର୍‌ ମାରି ଇୟା ପାଣି ଉଣ୍ତିଙ୍ଗ୍‌ ବିସ୍‌ବାସ୍‌ ନି ପବିତ୍ର ଆତ୍ମାଦୁ ପୁରା ଆତିମାନି ସ୍ତିପାନ୍ ଦର୍‌ତି ଅରେନ୍‌ ଲୋକ୍‌ତିଙ୍ଗ୍‌, ମାରି ପିଲିପ୍‍ପ, ପ୍ରକର, ନିକାନୋର, ତିମୋନ, ପାର୍ମନା ମାରି ଆଗ୍‌ଡ଼ି ଜିହୁଦି ଦର୍ମଦୁ ବାଦ୍‍ଲେ ଆତିମାର୍‍ଇ ଆଣ୍ଟିୟୋକତି ଅଣଜିହୁଦି ନିକୋଲାୟତିଙ୍ଗ୍‍ ଆସ୍‌କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ପ୍ରେରିତ ସିସୁର୍‍ ଇୟା ସାତ୍ ଲୋକା ଉଣ୍ତିଙ୍ଗ୍‌ ପାର୍‌ତନା କିଜି ୱାରି ମୁସ୍‌କୁ କିକୁ ଇଟ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ଇୟାୱାଜା ମାପୁରୁଦି ବାକ୍ୟ ପ୍ରଚାର୍‌ କିତାର୍‍ । ଜିରୁସାଲାମ୍‍ତୁ ସିସୁରି ଦଲ୍‌ ନାଣ୍ତଦାନ୍‌ ନାଣ୍ତ ପିର୍‌ଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌; ନାଣ୍ତ ଜାଜକର୍‌ ବା କ୍ରିସ୍ତ ବିସ୍‌ବାସ୍‌ସିର୍‌ ଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ମାପୁରୁମାଣାନ୍‌ ନାଣ୍ତବାବେ ଆସିର୍ବାଦ୍‌ ପୟଜି ମାରି ସାକ୍ତିଦୁ ପୁରା ଆତିମାନି ସ୍ତିପାନ୍, ଲୋକା ଲୋଇ ନାଣ୍ତ ସିନା ନି କାବାଆନି ପାଣି କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ମାତର୍‌ କୁରିଣି ମାରି ଆଲେକ୍‍ଜାଣ୍ତ୍ରିଆ ତ୍ରିଆଦି ଦାସ୍‍ପାଣିଦାନ୍‍ ମୁକ୍‍ଡ଼ାତି ମାର୍‍ଇ ଜିହୁଦିରିଙ୍ଗ୍‍ଁ ଅସି ତିଆର୍‌ଆତି ପାର୍‌ତନା ଇଲୁଦୁ ମାନି ଏସଲୋକ୍‌ ସ୍ତିପାନତି ବିରୁଦ୍‍କିତାର୍‍ । ୱାର୍‌ ମାରି କିଲିକିୟା ନି ଆସିଆ ଦେସ୍‌ତି ଆଇ ଜିହୁଦିର୍‌ ସ୍ତିପାନତି ୱାଲେ ଜାଟି କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ମାତର୍‌ ପବିତ୍ର ଆତ୍ମା ସ୍ତିପାନତିଙ୍ଗ୍‍ ଇୟାୱାଜା ବୁଦି ସିତାତ୍‌ ଜେ, ଏନ୍‌ ୱାନି ବିରୁଦ୍‌ତାନ୍‌ ୱେର୍‌ତେଙ୍ଗ୍‍ ଆଟ୍‍ଏତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ଆର୍‍ତିଙ୍ଗ୍‍ଁ “ୱାନ୍‌ ମୋସାଦି ବିରଦ୍‌ତାନ୍‌ ମାରି ମାପୁରୁଦି ବିରଦ୍‌ତାନ୍‌ ମାଟା ଇଜିମାନିକା ମାପ୍‌ ୱେର୍‍ଆପ୍‍,” ଇୟା ମିସ୍‌ ସାକି ସିନି ଉଣ୍ତିଙ୍ଗ୍‌ ୱାର୍‌ ଏସ ଲୋକାଙ୍ଗ୍‌ ଲାଚ୍‌ ସିଜି ପୁସେ‌ରେକିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ଇୟାୱାଜା ୱାର୍‌ ଲୋକାଙ୍ଗ୍‌, ଦାର୍ମୁ ନେତାର୍‍ ମାରି ଗୁରୁରିଙ୍ଗ୍‍ ଉତ୍‍ତାର୍‍ ମାରି ସ୍ତିପାନତିଙ୍ଗ୍‍ ଆସ୍‌ସି ପେରିମିଟିଙ୍ଗ୍‍ତୁ ଅତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ତାନିୱେନ୍‍କା ୱାର୍‌ ୱାନି ବିରଦ୍‌ତାନ୍‌ ମିସ୍‌ ସାକି ସିଦେଙ୍ଗ୍‍ ଇଜି ଏସ ଲୋକାଙ୍ଗ୍‌ ଲୋଇ ତାତାର୍‌ । ୱାର୍‌ ଇର୍ହାର୍‌, “ଇୟା ଲୋକୁ ୱିଜୁଦିନ୍ ମା ପବିତ୍ର ମନ୍ଦିର୍‌ ନି ମୋସାଦି ନିୟମ୍‌ ବିରୁଦ୍ଧତାନ୍‌ ୱେର୍‌ସିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ନାଜରିୟତିୟ ଜିସୁ ମନ୍ଦିର୍‌ତିଙ୍ଗ୍‌ ରୁକ୍‍ନା ପକ୍‍ନାନ୍‍ ମାରି ମୋସାଦି ମାଣାନ୍‌ ମାପ୍‌ ପୟ୍‍ତିମାନି ୱିଜୁ ରିତିନିତି ବାଦ୍‍ଲେ କିନା ଇଜି ଇୟା ଲୋକୁ ଇଜିମାନିକା ମାପ୍‌ ୱେର୍‍ଆମାନାପ୍‍ !” ");
INSERT INTO kfcp_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ନାସ୍ତିୱାଲେ ଆବେନ୍‌ ବାସ୍ତିମାର୍‍ଇ ୱିଜେରେ ଅର୍‌ସେ ସ୍ତିପାନ୍‍ତି ତରିନ୍‌ ସୁଡ଼ୁତାର୍‌ ଜେ ୱାନି ମକମ୍‌ ମୁସ୍‌କୁପୁର୍‌ତି ଦୁତ୍‍ତି ମକମ୍‍ତି ୱାଜା ତର୍‍ଜିମାର୍ହାପ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ୱିଜେରିଙ୍ଗ୍‍ ପେରି ଜାଜକ ସ୍ତିପାନତିଙ୍ଗ୍‍ ୱେନ୍‌ବାତାନ୍‌, “ଇକା ଇନିକା ସତ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ସ୍ତିପାନ୍ ଇର୍ହାନ୍‌, ଏ ନା ତଡ଼ାନ୍‌କୁ ନି ବୁବାର୍‍, ୱେନ୍‌ଡ୍ରୁ ! ମା ଡକ୍ରାଦାଦା ଅବ୍ରାହାମ ହାରୋଣଦୁ ବାସାଦେଙ୍ଗ୍‍ ସନି ଆଗ୍‌ଡ଼ି ଗୌରବ୍‍ତି ମାପୁରୁ ମେସପଟାମିଆଦୁ ତରାୟ୍‌ଆଜି, ");
INSERT INTO kfcp_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ମି ଇଲୁତିଲୋକୁ ମାରି ଦେସ୍‌ ଡ଼ିସ୍‌ସି ନାନ୍ ଏମେ ଦେସ୍‌ ତର୍‍ନା, ଆବେ ସାଙ୍ଗ୍ଆ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ଆବେଟ୍‌ ୱାନ୍‌ ୱାନି କଲଦୀୟ ଦେସ୍‌ ଡ଼ିସ୍‌ସି ହାରୋଣତୁ ବାସାଦେଙ୍ଗ୍‍ ସର୍ହାନ୍‍ । ଅବ୍ରାହାମତି ବୁବାସି ସାତି ୱେନ୍‌କା ମିର୍‌ ଇଲେଇ ଆମା ଦେସ୍‌ତୁ ବାସାଜିନିଦେର୍‍, ମାପୁରୁ ୱାନିଙ୍ଗ୍‌ ଆୟା ଦେସ୍‌ତୁ ତାତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ମାପୁରୁ ନାସ୍ତିୱାଲେ ଅବ୍ରାହାମତି ଇୟା ଦେସ୍‌ତୁ ଇନି ଦନ୍‌, ଇୟାୱାଜା ଜେ କାଣ୍ତେକ୍‌ ମୁରା ବୁମି ବା ସିଏନ୍‌ ମାର୍ହାନ୍‍ । ମାତର୍‌ ମାପୁରୁ ପାର୍‌ମାଣ୍‌ କିତାମାର୍ହାନ୍‌, ଅବ୍ରାହାମ୍‍ତିଙ୍ଗ୍‌ ଇୟା ଦେସ୍‌ ସିନାନ୍‌ ମାରି ଇକା ୱାନି ନି ୱାନି କୁଟୁମ୍‌ତି ନିଜେତିକା ଆଜି ତେବାନାତ୍‍ । ମାପୁରୁ ଆୟା ପାର୍‌ମାଣ୍‌ କିନିୱାଲେ ଅବ୍ରାହାମ୍‍ତିଙ୍ଗ୍‌ କଡ଼କକ୍‍ରା ଆଏନ୍‌ ମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ନାସ୍ତିୱାଲେ ମାପୁରୁ ୱାନିଙ୍ଗ୍‌ ଇୟା ମାଟା ଇର୍ହାନ୍‌ ! ମି କୁଟୁମ୍‍ତିକାର୍‍ ଦାସ୍‍ତି ୱାଜା ଆଇ ଦେସ୍‌ତୁ ବାସାନାର୍‍ ମାରି ସାରିସ ବାର୍ସେକ୍‍ ସାନ୍ଦି କାଷ୍ଟୁ ପୟ୍‌ନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ମାତର୍‌ ମାପୁରୁ ଇର୍ହାନ୍‌, ୱାର୍‌ ଏମେୱାରି ସେବା କିନାର୍‌, ନାନ୍ ଆୟା ଲୋକା ବିସାର୍‌ କିନାପ୍‍, ୱେନ୍‌କା ମି କୁଟୁମ୍‍ତିକାର୍‍ ଆୟା ଦେସ୍‍ତାନ୍‍ ସନା ୱାନାର୍‌ ମାରି ଇୟା ବାଡିଦୁ ନା ପାର୍‌ତନା କିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ୱେନ୍‌କା ମାପୁରୁ ଅବ୍ରାହାମତି ୱାଲେ ପାର୍‌ମାଣ୍‌ ସିନା ୱାଜା ସୁନ୍ନତ୍‌ ନିୟମ୍‌ ତିଆର୍‌ କିତାନ୍‌ । ଆବେଟ୍‌ ୱାନି ମାରିସି ଇସ୍‍ହାକ୍‍ତି ଜନମ୍‌ତି ଉଣ୍ତ୍ରି ସାତା ୱେନ୍‌କା ଅବ୍ରାହାମ ୱାନି ସୁନ୍ନତ କିତାନ୍‌; ଇସ୍‌ହାକ୍‌ ୱାନି ମାରିସି ଜାକୁବଙ୍ଗ୍‍ ମାରି ଜାକୁବ ୱାନି ବାର ମାରିସିରିଙ୍ଗ୍‌ ଅର୍ତାତ୍‍ ମା ଜାତିଦି ୱେଙ୍ଗିଁତି ଡକ୍ରାଦାଦାରିଙ୍ଗ୍‍ ସୁନ୍ନତ୍‌ କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","ଜାକୁବଦି ମାରିସିର୍‌ ୱାରି ତଡ଼ାନ୍‌ ଜୋସେପ୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ରିସାଆଜି ୱାନିଙ୍ଗ୍‌ ମିସର୍‍ ଦେସ୍‌ତୁ କଟିସାକର୍‌ ୱାଜା ପର୍‍ତାର୍‍ । ମାତର୍‌ ମାପୁରୁ ଜସେପ୍‍ତି ୱାଲେ ମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ମାରି ୱିଜୁ ଦୁକୁ କାସ୍ଟୁଦି ୱାଲେ ୱାନିଙ୍ଗ୍‌ ସାଲା କିତାନ୍‌ । ଏସ୍ତିୱାଲେ ଜସେପ୍‍ ମିସର୍‍ତି ରାଜା ଫାରୋଦି ଆଗ୍‌ଡ଼ି ୱାତାନ୍‌, ମାପୁରୁ ୱାନିଙ୍ଗ୍‌ ଦୟା ନି ବୁଦି ସିତାନ୍‌ ମାରି ରାଜା ଜସେପ୍‍ତିଙ୍ଗ୍‍ ଦେସ୍‌ତି ସାସନ୍‍କିନିକାନ୍‍ ନି ରାଜା ମେଡ଼୍‍ତି ପେରିକାନ୍‌ ୱାଜା ଆସ୍‌କିତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ତାନିୱେନ୍‍କା ୱିଜୁ ମିସର୍‍ ମାରି କିଣାନ୍‍ତୁ ଉଣିକା ପୁଟ୍‍ଏତାତ୍‌ଆକା ଲୋକୁ ନାଣ୍ତ କାସ୍ଟୁ ପୟ୍‌ତାର୍‌ । ମା ଡକ୍ରାଦାଦାରି କାଦିଦି ଉଣା ଆତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ମିସର୍‍ ଦେସ୍‌ତୁ କାଦି ମାନାତ୍‌ ଇଜି ୱେନ୍‌ଜି ଜାକୁବ ୱାନି ମାରିସିରିଙ୍ଗ୍‌ ଅର୍ତାତ୍‍ ମା ଡକ୍ରାଦାଦାରିଙ୍ଗ୍‍ ଆବେ ପକ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ଆବେ ୱାର୍‌ ରିଜା ସନି ୱାଲେ ଜୋସେପ୍‌ ୱାନି ତଡ଼ାନ୍‌କୁ ମାନୁ ନିଜେଦି ପରିଚୟ୍‌ ୱେର୍‌ତାନ୍‌ ମାରି ଫାରୋ ରାଜା ଜସେପ୍‍ତି ଇଲୁ ବିସୟ୍‌ତାନ୍‌ ନେସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ତାନି ୱେନ୍‌କା ଜୋସେପ୍‌ ୱାନି ବୁବାସି ଜାକୁବ ନି ୱାନି ଇଲୁଦି ୱିଜେରେ ସତୁରି ପାସ୍‌ ଲୋକାଙ୍ଗ୍‌ ମିସର୍‍ ଦେସ୍‌ତୁ ୱାଦେଙ୍ଗ୍‌ ଇଜି କୁକ୍‍ତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ଜାକୁବ ମିସର୍‍ ଦେସ୍‌ତୁ ସର୍ହାନ୍‍, ଆବେ ୱାନ୍‌ ମାରି ୱାନି ମାରିସିରି ସାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ୱାରି ସାତି ମାଡ଼ା ସିକିମ୍‍ତୁ ଅତାର୍‌ ମାରି ଅବ୍ରାହାମ ହାମୋର ଲୋକା ମାଣ୍‌କୁ କଟିମାର୍ହି ବୁମିଦୁ ୱାରିଙ୍ଗ୍‌ ଅତାର୍‍ ମୁସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“ମାପୁରୁ ଅବ୍ରାହାମ୍‍ତିଙ୍ଗ୍‌ ଏମେ ପାର୍‌ମାଣ୍‌ କିତାମାର୍ହାନ୍‌, ଆକା ସତ୍‌ ଆଜି ମିସର୍‍ ଦେସ୍‌ତୁ ମା ଲୋକୁ ସଂକିୟା ନାଣ୍ତ ଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ୱେନ୍‌କା ଜୋସେପ୍‌ତି ବିସୟ୍‌ତାନ୍‌ ନେସେଇ ମାର୍ହି ଅରେନ୍‌ ରାଜା ମିସର୍‍ ଦେସ୍‌ତୁ ସାସନ୍‍ କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ୱାନ୍‌ ମା ଡକ୍ରାଦାଦାରିଙ୍ଗ୍‍ ନାଣ୍ତ କାସ୍ଟୁ ସିତାନ୍‌, ୱାରି ଜନମ୍‍ଆତି ଇସ୍ରି କଡ଼ରିଙ୍ଗ୍‌ କାତ୍‍ତେଙ୍ଗ୍‍ ଇଜି ୱାରିଙ୍ଗ୍‌ ଆତ୍‌ରେ ପକ୍‍ତେଙ୍ଗ୍‍ ଇଜି ଆଦେସ୍‌ କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ଇୟା ସମୟ୍‍ତୁ ମୋସା ଜନମ୍‌ ଆତାନ୍‌ । ୱାନ୍‌ ମାପୁରୁ ଆଗ୍‍ଡ଼ି ମାର୍ହାନ୍‍ ଅରେନ୍‌ ନେଗ୍ରି କଡ଼ ପିଲା । ଇନ୍‌ଡ୍ର ମୁଣ୍ତ୍ରି ଲେଜ୍‌କୁ ସାନ୍ଦି ୱାନ୍‌ ଜାତୁନ୍‍ ଅଆୟ୍‍ ଆତାନ୍‍, ");
INSERT INTO kfcp_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ମାରି ଏସ୍ତିୱାଲେ ୱାନିଙ୍ଗ୍‌ ଆତ୍‌ରେ ପୋକ୍‌ତାର୍‌, ଫାରୋ ରାଜାଦି ଗାଡ଼୍‌ସି ୱାନିଙ୍ଗ୍‌ ପୟ୍‌ଜି ନିଜେଦି କଡ଼ ୱାଜା ପସା କିତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ମୋସା ମିସର୍‍ ଦେସ୍‌ତି ୱିଜୁ ବୁଦିଦୁ ସିକିୟା ପୟ୍‌ତାନ୍‌, ୱାନି ମାଟା ମାରି ପାଣିଦୁ ଅରେନ୍‌ ପେରି ଲୋକୁ ୱାଜା ୱେଙ୍ଗିଁତାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“ମସାଦି ବାର୍ସୁ ଏସ୍ତିୱାଲେ ସାଲିସ୍‍ ବାର୍ସେକ୍‍ ଆତାତ୍‌, ୱାନ୍‌ ୱାନି ଇସ୍ରାଏଲ୍‌ତି ତଡ଼ାନ୍‌କୁ ଉଣ୍ତିଙ୍ଗ୍‌ ଏଣ୍ତେସ୍‌ ବ୍ୟବହାର୍‌ କିଆୟ୍‍ଆଜିନାତ୍‍, ଆକା ନେସ୍‌ତେଙ୍ଗ୍‌ ବଦା କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ୱାରି ଲୋଇ ଅରେନ୍‌ ୱାନିଙ୍ଗ୍‌, ଅରେନ୍‌ ମିସର୍‍ ଦେସ୍‍ତିକାନ୍‍ ଜାଟିକିନିକା ସୁଡ଼୍‌ଜି, ମସା ୱାନିଙ୍ଗ୍‌ ରକିୟା କିଦେଙ୍ଗ୍‌ ଇଜି ମିସର୍‍ତି ୱାନିଙ୍ଗ୍‍ ବାଦ୍‌ଲୁ ଅସି ଡାକ୍‍ସି ସାପିସ୍‌କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ୱାନ୍‌ ଅଡ଼୍‍ବିତା ମାର୍ହାନ୍‍, ୱାନି ନିଜେ ଲୋକୁ ନେସ୍‌ନାର୍‌ ଜେ, ତଡ଼ାନ୍‌କାଙ୍ଗ୍‌ ମୁକ୍‍ଡ଼ା କିଦେଙ୍ଗ୍‌ ଇଜି ମାପୁରୁ ୱାନିଙ୍ଗ୍‌ ବ୍ୟବ୍‌ହାର୍‍ କିଜିନାନ୍‍; ମାତର୍‌ ୱାର୍‌ ଆକା ବୁଜାଏତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ମାର୍‌ନାଣ୍ତିଙ୍ଗ୍‌ ରିଏର୍‌ ଇସ୍ରାଏଲ୍‌ ଦେସ୍‍ତିକାର୍‍ ଜାଟିକିନିକା ସୁଡ଼ୁତାନ୍‌ ମାରି ୱାରି ଲୋଇ ସାନ୍ତି କିଦେଙ୍ଗ୍‌ ସେସ୍ଟା କିତାନ୍‌ । ୱାନ୍‌ ଇର୍ହାନ୍‌, ୱେନ୍‍ଣ୍ତ୍ରୁ, ମିର୍‌ ରିଇଦେର୍‍ ତୋ ଇସ୍ରାଏଲ୍‌ ଦେସ୍‌ତି ତଡ଼ାନ୍‌କୁ । ଏନ୍ଦା ଇୟାୱାଜା ଜାଟି କିଜିନିଦେର୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ମାତର୍‌ ଏମେକାନ୍‍ ଆଇୱାନିଙ୍ଗ୍‍ ଜାଟି କିଜି ମାର୍ହାନ୍‍, ୱାନ୍‌ ମସେଙ୍ଗ୍‍ ପେଲେ କିଜି ୱେନ୍‌ବାତାନ୍‌, ମା ନେତାର୍‌ରି ମୁସ୍‌କୁ ନିଙ୍ଗିଁ ଏନ୍‌ ସାସନ୍‍କିନିକାନ୍‍ ନି ବିସାର୍‌ କିନିକାନ୍‍ କିତାମାନାନ୍‍ ? ");
INSERT INTO kfcp_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ଇଏନ୍‌ ଏଣ୍ତେସ୍‌ ମିସର୍‍ ଦେସ୍‌ତି ଲୋକ୍‌ତିଙ୍ଗ୍‌ ସାୟାମାର୍‌ଗାଡାକ୍‍ତି, ନାଙ୍ଗିଁ ଇନିକା ଆୟାୱାଜା ଡାକ୍‌ତେଙ୍ଗ୍‍ଁ ବଦା କିନି ? ");
INSERT INTO kfcp_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ମୋସା ଇକା ୱେନ୍‌ଜି ମିସର୍‍ ଦେସ୍‌ତାନ୍‍ ଉରକ୍‍ତାନ୍‍ ମାରି ମିଦିୟୋନଦୁ ବାସା କିତାନ୍‍ । ଆବେନ୍‌ ୱାନି ରିଏର୍‌ କଡ଼ର୍‌ ମାର୍ହାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“ସାଲିସ୍‍ ବାର୍ସେକ୍‍ ସର୍‌ଇ ୱେନ୍‌କା ସିନୟ ଗରନ୍‌ ଲାକ୍‌ତୁ ଉଣ୍ତ୍ରି କାସ୍‍ସିମାନି ଦୁପା ସିସୁ ଲୋଇ ମାପୁରୁଦି ଉନ୍‌ଡ୍ରି ଦୁତ୍‍ ମସେଙ୍ଗ୍‍ ତରାଇଆତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ମୋସା ଇକା ସୁଡ଼୍‌ଜି ନାଣ୍ତ କାବା ଆତାନ୍‌, ମାରି ଅଡ଼ପ୍‌ ନେଗେନ୍‌କିଜି ସୁଡ଼୍‍ଦେଙ୍ଗ୍‍ ଇଜି ଦୁପାଦି ଲାକ୍‌ତୁ ସର୍ହାନ୍‍ । ମାତର୍‌ ୱାନ୍‌ ପ୍ରବୁଦି ବଲ୍ ୱେର୍‍ଆନ୍‍, ");
INSERT INTO kfcp_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ନାନ୍ ମି ଡକ୍ରାଦାଦା ଅବ୍ରାହାମ, ଇସ୍‌ହାକ୍‌ ମାରି ଜାକୁବଦି ମାପୁରୁ । ମୋସା ତିଲାଜି ତିରଗ୍‍ଜି ବେସ୍‍ତେଙ୍ଗ୍‍ ସାସ୍‌ କିଏତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ପ୍ରବୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, ନି ଜୁତା କୁତ୍ଆ, ଇରିଙ୍ଗ୍‌ ନିନ୍‌ ଏମେମାନୁ ନିର୍ହିମାନି, ଆକା ପବିତ୍ର ବୁମି ।” ");
INSERT INTO kfcp_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ମିସର୍‍ ଦେସ୍‌ତୁ ନାନ୍ ନା ଲୋକାଙ୍ଗ୍‌ ନାଣ୍ତ ଦୁକୁକାସ୍ଟୁ ସୁଡ଼ୁତାମାନା । ନାନ୍ ୱାରି ଆଡ଼୍‍ବାନିକା ୱେର୍‍ଆମାନା ମାରି ୱାରିଙ୍ଗ୍‌ ଦାସ୍‍ପାଣିଦାନ୍‍ ରକିୟା କିଦେଙ୍ଗ୍‌ ରେତା ୱାତାମାନା । ଇଲେଇ ରାଦୁ, ନାନ୍ ମିଙ୍ଗିଁ ମିସର୍‍ ଦେସ୍‌ତୁ ପକ୍‍ନା । ");
INSERT INTO kfcp_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“ମୋସା ଇସ୍ରାଏଲ୍‌ ଲୋକା ମାଣାନ୍‌ ଡ଼ିସାୟ୍‍ଆତା ମାର୍ହାନ୍‍ । ପେରି ନେତାର୍‌ ୱେନ୍‌ବାତାର୍‌, ମା ମୁସ୍‌କୁ ନିଙ୍ଗିଁ ଏନ୍‌ ସାସନ୍‍କିନିକାନ୍‍ ନି ବିସାର୍‌କିନିକାନ୍‍ କିତାନ୍‌ ? ମାତର୍‌ ମାପୁରୁ ଆୟା ମୋସେଙ୍ଗ୍‍ କାସ୍‍ନି ଦୁପା ଲାକ୍‌ତୁ ତରାୟ୍‍ଆତି ମାର୍ହି ଦୁତ୍‍ତି ସାକାଦାନ୍‌ ଲୋକା ମୁସ୍‌କୁ ସାସନ୍‍ କିଦେଙ୍ଗ୍‌ ମାରି ୱାରିଙ୍ଗ୍‌ ମୁକୁଡ଼ା କିଦେଙ୍ଗ୍‌ ଇଜି ପକ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ୱାନ୍‌ ମିସର୍‍ ଦେସ୍‌ତୁ ମାରି ନେତ୍‍ରେ ସାମ୍‌ଦୁର୍‌ତୁ ନାଣ୍ତ କାବାଆନି ପାଣି କିଜି ଲୋକାଙ୍ଗ୍‌ ମିସର୍‍ ଦେସ୍‍ତାନ୍‍ ସପ୍‍ସି ତାତାନ୍‍, ସାଲିସ୍‍ ବାର୍ସେକ୍‍ ସାନ୍ଦି ବାଲି ବୁମିଦୁ ୱାରିଙ୍ଗ୍‌ ସାରି ତର୍‌ସି ଅତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ମୋସା ନିଜେ ଇସ୍ରାଏଲ୍‌ ଦେସ୍‌ତି ଲୋକାଙ୍ଗ୍‌ ଇର୍ହାମାର୍ହାନ୍‌, ମାପୁରୁ ନାଙ୍ଗିଁ ଏଣ୍ତେସ୍‌ ପକ୍‍ତାମାର୍ହାନ୍‍, ଆୟାୱାଜା ମି ଲାକ୍‌ତୁ ଅରେନ୍‌ ବାବବାଦିଙ୍ଗ୍‌ ପକ୍‍ନାନ୍‍ ୱାନ୍‌ ମି ନିଜେ ତଡ଼ାନ୍‌କା ଲୋଇରାନ୍‌ ଅରେନ୍‌ ଆନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ଆୟା ମୋସା ବାଲି ବୁମିଦୁ ଉଣ୍ତାତିମାର୍ହି ଇସ୍ରାଏଲ୍‌ତି ଲୋକାୱାଲେ ଅର୍‌ସେ ମାର୍ହାନ୍‍ । ୱାନ୍‌ ସିନୟ ଗରନ୍‌ତୁ ମା ଡକ୍ରାଦାଦାରି ୱାଲେ ମାରି ୱାରି ୱାଲେ ମାଟା ଇର୍ହିମାନି ମୁସ୍‌କୁପୁର୍‌ତି ଦୁତ୍‍ତି ୱାଲେ ମାର୍ହାନ୍‍ ମାରି ମା ଲାକ୍‌ତୁ ଇନ୍‍ଣ୍ତ୍ରେଙ୍ଗ୍‍ ଇଜି ୱାନ୍‌ ମାପୁରୁଦି ମାଣ୍‌କୁ ଜିବନ୍‌ତି ବାକ୍ୟ ଆସ୍‌ତାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","ମାତର୍‌ ମା ଡକ୍ରାଦାଦାର୍‍ ୱାନିଙ୍ଗ୍‌ ମାନାଏତାର୍‍; ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ପେଲେକିଜି ମିସର୍‍ ଦେସ୍‌ତୁ ଡ଼େସି ସନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ମନ୍‍ବଦାକିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାର୍‌ ହାରୋଣତିଙ୍ଗ୍‍ ଇର୍ହାର୍‌, ଇଲେଇ ମାଙ୍ଗିଁ ସାରି ତର୍‌ସି ଅତେଙ୍ଗ୍‌ ଇଜି ଏସ ଦିୟାମ୍‍କୁ ତିଆର୍‌ କିଜ ସିଦା । ମାଙ୍ଗିଁ ମିସର୍‍ ଦେସ୍‌ତାନ୍‍ ସପ୍‌ତି ତାତିମାନି ଆୟା ମୋସା ଜେ ଏମେ ସର୍ହାନ୍‍, ଆକା ମାପ୍‌ ନେସ୍‌ଏପ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ଆୟା ସମୟ୍‍ତୁ ଆବେ ୱାର୍‌ ଉଣ୍ତ୍ରି ଗାଡ଼ାଲ୍‍ତି ବମା ତିଆର୍‌ କିତାର୍‍ ମାରି ତାନି ଉଦେସ୍‍ତାନ୍‍ ପୁଜା କିଜି ବଲି ସିତାର୍‍ । ମାରି ନିଜେ ତିଆର୍‌ କିତିମାନି ଆୟା ମୁର୍ତିଦିଙ୍ଗ୍‍ ମାନାଦେଙ୍ଗ୍‌ ଇଜି ଉଣ୍ତ୍ରି ବଜି ତିଆର୍‌ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ଆବେଟ୍‌ ମାପୁରୁ ୱାରିମାଣାନ୍‌ ଏରିତାନ୍‍ ମାରି ୱାରିଙ୍ଗ୍‌ ବାଦଡ଼୍‍ତି ସୁକେଙ୍ଗାଁଙ୍ଗ୍‍ ସେବା କିଦେଙ୍ଗ୍‌ ଇଜି ଡ଼ିସ୍‌ତାସିତାନ୍‌ । ଇୟା ବିସୟ୍‌ତାନ୍‌ ବାବବାଦିରି ବଇଦୁ ରାସାତାମାନାତ୍‌ : “ଏ ଇସ୍ରାଏଲ୍‌ କୁଟୁମ୍‌ ! ବାଲିବୁମିଦୁ ସାଲିସ୍‍ ବାର୍ସେକ୍‍ ସାନ୍ଦି ମିର୍‌ ନା ଉଣ୍ତିଙ୍ଗ୍‌ ଜାତୁ ପୁଜା ସିଇତି ମାର୍ହିଦେର୍‌ନୋ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ମାତର୍‌ ମିର୍‌ ପାର୍‌ତନା କିଦେଙ୍ଗ୍‌ ଇଜି ଏମେ ବମା ୱିଜୁ ତିଆର୍‌ କିତିମାର୍ହିଦେର୍‍, ଆୟା ମାଲେକ୍‍ତି ଗୁଡ଼ା ମାରି ସୁକା ଦିୟାମ୍‍ ରମ୍ଫାତି ବମାଦିଙ୍ଗ୍‍ ପିଣ୍ତିତିଦେର୍‍ । ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ନାନ୍ ମିଙ୍ଗିଁ ବାବିଲନ୍‍ତି ଆୟାପାଡ଼ି ପକ୍‍ନାପ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","ବାଲିବୁମିଦୁ ମା ଡକ୍ରାଦାଦାରି ୱାଲେ ମାପୁରୁଦି ତେବାନିକା ଗୁଡ଼ା ମାର୍ହାତ୍‌ । ମାପୁରୁ ମୋସେଙ୍ଗ୍‍ ଏଣ୍ତେସ୍‌ ତିଆର୍‌ କିଦେଙ୍ଗ୍ ଇର୍ହାମାର୍ହାନ୍‌ ମାରି ମୋସାଦିଙ୍ଗ୍‍ ଏମେ ସାରି ତର୍‍ତାମାର୍ହାନ୍‍, ଇକା ଆୟାୱାଜା ତିଆର୍‌ ଆତାମାର୍ହାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ୱେନ୍‌କା ମା ଡକ୍ରାଦାଦାରି ଲୋକା ବୁବାସିରି ମାଣ୍‌କୁ ପୟ୍‍ତିମାର୍ହି ଆୟା ଗୁଡ଼ାଦିଙ୍ଗ୍‍ ଜିହୋସିୟଦି ୱାଲେ ପିଣ୍ତ୍‍ଜି ଅସି ସର୍ହାର୍‍ ମାରି ମାପୁରୁଦି ମାଣାନ୍‌ ପେରାୟ୍‍ ଆତିମାର୍‍ଇ ଆଇ ଦେସ୍‌ ଅଦିକାର୍‌ କିତାର୍‍ । ଦାଉଦ ରାଜାଦି ସମୟ ସାନ୍ଦି ଆବେ ତେବାତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ୱାନ୍‌ ମାପୁରୁଦିମାଣାନ୍‌ ଦୟା ପୟ୍‌ଜି ଜାକୁବଦି ମାପୁରୁଦି ଉଣ୍ତିଙ୍ଗ୍‌ ଉଣ୍ତ୍ରି ତେବାନି ମନ୍ଦିର୍‌ ତିଆର୍‌ କିଦେଙ୍ଗ୍‌ ୱାନି ସାରି ବଦାକିତାମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ମାତର୍‌ ୱେନ୍‌କା ଆୟା ତେବାନି ଇଲୁ ତିଆର୍‌ କିତାନ୍‌ ସଲମନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","ମାତର୍‌ ୱିଜେରିଙ୍ଗ୍‌ ପେରି ମାପୁରୁ ଲୋକାମାଣାନ୍‌ ତିଆର୍‌ ଆତି ଇଲ୍‌କାଙ୍ଗ୍‌ ବାସାଏନ୍‍ । ଇୟା ବିସୟ୍‌ତାନ୍‌ ବାବବାଦି ରାସ୍‌ତାମାନାନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“ପ୍ରବୁ ଇନାନ୍‌, ମୁସ୍‌କୁପୁର୍‌ ନା ବାସ୍‌ନି ଗାଦି ମାରି ଦୁନିଆ ନା ପାଦାମ୍‌ ଇଡ୍‌ନି ବାଡି ମିର୍‌ ନା ଉଣ୍ତିଙ୍ଗ୍‌ ଏଣ୍ତେସ୍‌ ନାନି ଇଲୁ ତିଆର୍‌ କିନିଦେର୍‍ ? ନା ରମ୍‌ନି ଉଣ୍ତିଙ୍ଗ୍‌ ବାଡି ଏମେ ? ");
INSERT INTO kfcp_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ଇୟାୱିଜୁ ବିସୟ୍‌ ଇନିକା ନାନ୍ ନିଜେ ତିଆର୍‌ କିଏ ନୋ ?” ");
INSERT INTO kfcp_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ସ୍ତିପାନ୍‍ ମାରି ଇର୍ହାନ୍‌, “ମିର୍‌ ଏସା ମାନାଇକାର୍‍ । ମି ଜିବନ୍‌ ଏସା ତାଗ୍‌ଇକା । ମାପୁରୁଦି ବାକ୍ୟ ଉଣ୍ତିଙ୍ଗ୍‌ ମିର୍‌ ଏସା ବଇରା ! ମିର୍‌ ଟିକ୍‌ ମି ପୁର୍ବେଦିଡକ୍ରାରି ୱାଜା : ମିର୍‌ ୱିଜୁୱାଲେ ପବିତ୍ର ଆତ୍ମାଦି ବିରୁଦ୍‌ କିଜିନିଦେର୍‌ ! ");
INSERT INTO kfcp_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ମି ପୁର୍ବେଦିଡକ୍ରାଦାଦାରି ମାଣାନ୍‌ ପେରାୟ୍‍ ଆଇ ମାନି ଏମେ ବାବବାଦି ମାନାନ୍‌ ନୋ ? ମାପୁରୁଦି ଏମେ କାବୁର୍‌ସିନିକାର୍‍ ବେସି ଆଗ୍‌ଡ଼ି ୱାରି ଦାର୍ମୁଦି ଦାସ୍‍ତି ୱାନି ବିସୟ୍‌ତାନ୍‌ ଇର୍ହାମାର୍ହାର୍‍, ମି ଡକ୍ରାଦାଦାର୍‍ ୱାରିଙ୍ଗ୍‌ ଡାକ୍‍ତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ଇଲେଇ ମିର୍‌ ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ବିସ୍‌ବାସ୍‌ତୁ ଆରାକିଜି ୱାନିଙ୍ଗ୍‌ ଡାକ୍‍ତିମାନିଦେର୍‍ । ମିର୍‌ ମୁସ୍‌କୁପୁର୍‌ତି ଦୁତ୍‍କା ମାଣାନ୍‌ ସିତିମାନି ମାପୁରୁଦି ନିୟମ୍‌ ୱିଜୁ ପୟ୍‌ତିମାନିଦେର୍‌ ମାତର୍‌ ଆକା ମାନାଇଦେର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ପେରିମିଟିଙ୍ଗ୍‍ତି ନେତାର୍‌ ସ୍ତିପାନ୍‍ତି ମାଟା ୱେନ୍‌ଜି ନାଣ୍ତ ରିସା ଆତାର୍‌, ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ରିସାଦାନ୍‍ ପାଲ୍‍କୁ କାତ୍ରେ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ମାତର୍‌ ସ୍ତିପାନ୍‍ ପବିତ୍ର ଆତ୍ମାଦୁ ପୁରାଆଜି ମୁସ୍‌କୁପୁର୍‌ ତରିନ୍‌ ସୁଡ଼ୁତାନ୍‌ ମାରି ମାପୁରୁଦି ଗୌରବ୍‍ ନି ଜିସୁଙ୍ଗୁଁ ମାପୁରୁଦି ଉଣେରି ତରିନ୍‌ ନିନି ମାନିକା ସୁଡ଼ୁତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ୱାନ୍‌ ଇର୍ହାନ୍‌, “ସୁଡ଼ୁଦୁ, ନାନ୍ ମୁସ୍‌କୁପୁର୍‌ ରେଆତିକା ମାରି ମନୁସ୍ୟପୁତ୍ରଙ୍ଗ୍‍ ମାପୁରୁଦି ଉଣେରି ତରିନ୍‌ ନିନି ମାନିକା ସୁଡ଼ୁଜିନା !” ");
INSERT INTO kfcp_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ଆଉଲି ଆଜି ପେରିମିଟିଙ୍ଗ୍‍ତି ନେତାର୍‌ ଇୟା ମାଟା ୱେନ୍‍ଇ ଉଣ୍ତିଙ୍ଗ୍‌ ଗିତଣିଦୁ କିକୁ କେରପ୍‍ତାର୍‍ । ୱେନ୍‌କା ୱାର୍‌ ଏକ୍‍ଜୁଟ୍‍ ଆଜି ୱାନି ତରିନ୍‌ ମାଟ୍‍ସି ୱାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ଗାଡ଼୍‌ ଆତ୍‌ରେ ୱାନିଙ୍ଗ୍‌ ରେଲ୍‌ଜି ଅସି, ୱାନି ମୁସ୍‌କୁ କାଲ୍‌କୁ ପକ୍‍ସି ଡାକ୍‍ତାର୍‍ । ମିସ୍‌ ସାକିସିନିକାର୍‍ ସାଉଲ୍‍ ଦର୍‌ତି ଅରେନ୍‌ ମୁରୁଲିଦି ଲାକ୍‌ତୁ ୱାରି ଆଙ୍ଗିଁପାସିୟା ୱିଜୁ ଡ଼ିସ୍‍ତା ସର୍ହାମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ୱାର୍‌ ସ୍ତିପାନ୍‍ତି ମୁସ୍‌କୁ କାଲ୍‌କୁ ଡାକ୍‍ନି ସମୟ୍‍ତୁ ୱାନ୍‌ ପ୍ରବୁଙ୍ଗ୍‌ ପାର୍‌ତନା କିଜି ଇର୍ହାନ୍‌, “ପ୍ରବୁ ଜିସୁ ନା ଆତ୍ମାଦିଙ୍ଗ୍‍ ମାନାଆ !” ");
INSERT INTO kfcp_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ୱାନ୍‌ ମେଣ୍ତେଙ୍ଗ୍‍ ଗଟ୍‌କିଜି ନାଣ୍ତ ଆଉଲିଦାନ୍‍ ଇର୍ହାନ୍‌, “ପ୍ରବୁ ! ଇୟାୱାରି ବିରଦ୍‌ତାନ୍‌ ଇୟା ପାପ୍‌ ଏତ୍‌ କିମା ।” ଇକା ଇଜି ୱାନ୍‌ ପୁଣ୍ତା ଡ଼ିସ୍‍ସି ସାତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ସ୍ତିପାନ୍‍ତି ସାନିଦଣ୍ତ୍‍ତିଙ୍ଗ୍‍ ସାଉଲ ଉନ୍‌ଡ୍ରେମୋନ୍‌ ଆତାନ୍‌ । ଆୟାନାଣ୍ତିରାନ୍‍ ଜିରୁସାଲାମ୍‌ତି ମଣ୍ତଲି ଉଣ୍ତିଙ୍ଗ୍‌ ନାଣ୍ତ କାସ୍ଟୁଦି ତାଡ଼ନା ଆରାମ୍‌ ଆତାତ୍‌ । ସିସୁରିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ସି ଆଇ ୱିଜେରେ ବିସ୍‍ବାସିର୍‍ ଜିହୁଦା ନି ସମିରୋଣ ରାଜିଦି ଇନିଙ୍ଗାଁ ଆନିଙ୍ଗାଁ ଆତାସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ଏସ ମାପୁରୁଦି ଦାର୍ମୁ ଲୋକୁ ନାଣ୍ତ ଆଉଲି ଆଜି ଆଡ଼୍‌ବାଜି ସ୍ତିପାନ୍‍ତି ସାତି ମାଡ଼ାଦିଙ୍ଗ୍‍ ମୁସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ମାତର୍‌ ସାଉଲ ମଣ୍ତଲିଦିଙ୍ଗ୍‍ ଦଂସ କିଦେଙ୍ଗ୍‌ ସେସ୍ଟା କିତାନ୍‌, ଇଲୁ ଇଲୁଦୁ ସଲ୍‍ସି କ୍ରିସ୍ତ ବିସ୍‍ବାସି ମେମାରି, ଆଇମା ୱିଜେରିଙ୍ଗ୍‍ ରେଲ୍‌ଜି ତାସି ଜଇଲ୍‌ତୁ ଇଟ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ଇନିଙ୍ଗାଁ ଆନିଙ୍ଗାଁ ୱିଦିତି ମାର୍‍ଇ ବିସ୍‍ବାସିର୍‍ ୱିଜୁ ତରିନ୍‌ ସଲ୍‍ସି ସୁସମାଚାର୍‌ ପ୍ରଚାର୍‌ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ସମିରୋଣଦି ପେରି ଗାଡ଼୍‍କାଙ୍ଗ୍‍ଁ ସଲ୍‍ସି ପିଲିପ୍‍ପ, ଆବେଣି ଲୋକାମାନୁ କ୍ରିସ୍ତ ନି ମାପୁରୁଦି ସୁସମାଚାର୍‌ ପ୍ରଚାର୍‌ କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ପିଲିପ୍‍ପଦି ମାଟା ୱେନ୍‌ଜି ମାରି ୱାନି କାବାଆନି ପାଣି ୱିଜୁ ସୁଡ଼୍‌ଜି ଲୋକୁ ୱାନି ତରିନ୍‌ ନାଣ୍ତ ନେଗେନ୍‌ ବେସ୍‍ତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ନାଣ୍ତ ଲୋକା ମାଣାନ୍‌ ତାଗ୍‌ଇ ଆତ୍‍ମେଙ୍ଗ୍‍ ଆଉଲି ଆଜି ସତେ ସର୍ହେ, ନାଣ୍ତ କୁସ୍ଟ ରୋଗି ମାରି ସଟାର୍‍ ନେଗେନ୍‌ ଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ଆୟା ଗାଡ଼୍‌ତୁ ଉନ୍‍ଣ୍ତ୍ରି ୱେଡ଼ିକା ଆଉଲି ୱେଙ୍ଗିଁତା ସର୍ହାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ସିମୋନ୍‌ ଦର୍‌ତି ଅରେନ୍‌ ଲୋକୁ ୱାନି ଗୁଣିଆ ବିଦ୍ୟା ଦାନ୍‌ ଆୟା ସମିରୋଣୟ ରାଜିଦି ଲୋକାଙ୍ଗ୍‌ କାବା କିଜି ଇଟ୍‌ତାମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ୱାନ୍‌ ନିଜେଦିଙ୍ଗ୍‍ ଅରେନ୍‌ ପେରିଲୋକ୍‍ ଇଜି ସମାଜ୍‍ତି ୱିଜୁଜାତିଦି ଲୋକା ଲୋଇ ପେରିପଦ୍‍ ପୟ୍‍ତାମାର୍ହାନ୍‍ । ୱାର୍‌ ଇଜିମାର୍ହାର୍‍, “ୱାନ୍‌ ପେରିସାକ୍ତି ଦର୍‌ତାନ୍‌ ୱେଙ୍ଗିଁତି ମାପୁରୁଦି ଉନ୍‍ଣ୍ତ୍ରି ସାକ୍ତି ।” ");
INSERT INTO kfcp_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ୱାନ୍‌ ଗୁଣିଆ ବିଦ୍ୟାଦାନ୍‍ ନାଣ୍ତ ଦିନ୍‌ ଆସ୍‌ସି ୱାନ୍‌ ସମିରୋଣ୍‍ତି ଲୋକାଙ୍ଗ୍‌ ୱାନି ୱାଲେ ବୁଲାଦେଙ୍ଗ୍‌ ଇଜି ଇଟ୍‍ଟାମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ମାତର୍‌ ପିଲିପ୍‍ପତି ମାଣ୍‌କୁ ମାପୁରୁଦି ରାଜି ମାରି ଜିସୁ କ୍ରିସ୍ତଦି ବିସୟ୍‌ତାନ୍‌ ସୁସମାଚାର୍‌ ୱେନ୍‌ଜି, ଆୟାବାନୁ ଲୋକା ବିସ୍‌ବାସ୍‌ ଆତାତ୍‌ ମାରି ଆୟା ରାଜିଦି ଆଇମା ମେମାରି ୱିଜେରେ ଡୁବନ୍‌ ଅତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ନିଜେ ସିମୋନ୍‌ ଆୟା ସୁସମାଚାର୍‍ତୁ ବିସ୍‌ବାସ୍‌ କିତାନ୍‌ । ପିଲିପ୍‍ପତି ମାଣ୍‌କୁ ଆତିମାର୍‍ଇ କାବାଆନି ପାଣି ନି ନେଗେନ୍‌ କିନି ପାଣି ୱିଜୁ ସୁଡ଼୍‌ଜି ୱାନ୍‌ ଡୁବନ୍‌ ଅସି ପିଲିପ୍‍ପତି ୱାଲେ ତେବାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ସମିରୋଣଦି ଲୋକୁ ମାପୁରୁଦି ବାକ୍ୟ ଆସ୍‍ତାମାନାର୍‍ ଇଜି ଜିରୁସାଲାମ୍‍ତୁ ମାନି ପ୍ରେରିତ ସିସୁର୍‍ ୱେନ୍‌ଜି, ପିତର ମାରି ଜୋହନତିଙ୍ଗ୍‌ ୱାରି ଲାକ୍‌ତୁ ପକ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ୱାର୍‌ ଆବେ ଇତି ୱେନ୍‌କା ସମିରୋଣଦି ବସ୍‍ବାସିର୍‍ ଏଣ୍ତେସ୍‌ ପବିତ୍ର ଆତ୍ମା ପୟ୍‌ନାର୍‌, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ପାର୍‌ତନା କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ଇରିଙ୍ଗ୍‌ ଆୟା ସାନ୍ଦି ୱାରି ଲୋଇ ଏମେୱାରି ମୁସ୍‌କୁ ପବିତ୍ର ଆତ୍ମା ରେତାଏତ୍‍ ମାର୍ହାତ୍‌ । ୱାର୍‌ କେବଲ୍‌ ପ୍ରବୁ ଜିସୁକ୍ରିସ୍ତଦି ଦର୍‌ତାନ୍‌ ଡୁବନ୍‌ ଅତାମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ପିତର ନି ଜୋହନ ୱାରି ମୁସ୍‌କୁ କିୟୁ ଇଟ୍‍ତି ଦାପ୍ରେ ୱାର୍‌ ପବିତ୍ର ଆତ୍ମା ପୟ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ସିମୋନ୍‌ ସୁଡ଼ୁତାନ୍‌ ଜେ, ପ୍ରେରିତ ସିସୁର୍‍ ବିସ୍‍ବାସିରି ମୁସ୍‌କୁ କିୟୁ ଇଟ୍‍ତାର୍‍ଆକା ୱାର୍‌ ପବିତ୍ର ଆତ୍ମା ପୟ୍‌ତାର୍‌ । ଆବେଟ୍‌ ୱାନ୍‌ ପିତର୍‌ ନି ଜୋହନତିଙ୍ଗ୍‌ ଡାବୁଙ୍ଗୁଁ ଜାସେ କିଜି ଇର୍ହାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“ନାନ୍ ଆଇୱାରି ମୁସ୍‌କୁ କିୟୁ ଇଟ୍‌ତିଙ୍ଗ୍‌, ୱାର୍‌ ଏଣ୍ତେସ୍‌ ପବିତ୍ର ଆତ୍ମା ପୟ୍‌ଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାର୍‍, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ନାଙ୍ଗିଁ ଇୟା ସାକ୍ତି ନି ଅଦିକାର୍‌ ସିଦା ।” ");
INSERT INTO kfcp_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ମାତର୍‌ ପିତର୍ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନି ୱାଲେ ନି ଡାବୁଙ୍ଗୁଁ ଦ୍ୱଂସ ଆପିତ୍‌, ଇରିଙ୍ଗ୍‌ ଡାବୁଦାନ୍‍ ନିନ୍‌ ମାପୁରୁଦି ଦାନ୍‌ କଣ୍ତେଙ୍ଗ୍‌ ଅଡ଼୍‍ବିତିମାନି ! ");
INSERT INTO kfcp_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ମା ପାଣିଦୁ ନି ଇନି ବାଗ୍ ସିଲେତ୍‌ । ଇରିଙ୍ଗ୍‌ ମାପୁରୁଦି ଆଗ୍‌ଡ଼ି ନି ଜିବନ୍‌ ନେଗିକା ସିଲେତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ଆଦେଙ୍ଗ୍‌ ନି ଇୟା ତାଗ୍‌ଇ ମାଟା ଉଣ୍ତିଙ୍ଗ୍‌ ମନ୍‍ ଡ଼େପ୍‍ଆ, ଇୟାୱାଜା ବିସୟ୍‌ ସିନ୍ତା କିତିମାନିଙ୍ଗ୍‍ ପ୍ରବୁ ଏଣ୍ତେସ୍‌ କେମା କିନାନ୍‌, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ପ୍ରବୁଙ୍ଗ୍‌ ପାର୍‌ତନା କିଆ । ");
INSERT INTO kfcp_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ଇରିଙ୍ଗ୍‌ ନାନ୍ ସୁଡ଼ୁଜିନା ଜେ ନି ଜିବନ୍‌ ରିସାଦୁ ପୁରା ଆତାମାନାତ୍‌, ନିନ୍‌ ପାପ୍‌ ଗାଟିଦୁ ତରାତିମାନି ।” ");
INSERT INTO kfcp_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ସିମୋନ୍‌ ଜୋହନ ନି ପିତର୍‌ତିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମିର୍‌ ଆମା ୱିଜୁ ଇର୍‍ଇଦେର୍‍, ଆକା ଏଣ୍ତେସ୍‌ ନା ଉଣ୍ତିଙ୍ଗ୍‌ ଗଟାଏତ୍‍, ଇୟାଉଣ୍ତିଙ୍ଗ୍‌ ଦୟାକିଜି ପ୍ରବୁଦି ଆଗ୍‌ଡ଼ି ପାର୍‌ତନା କିଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ସାକି ନି ପ୍ରବୁଦି ବାକ୍ୟ ୱେର୍‌ତି ୱେନ୍‌କା ପିତର୍‌ ନି ଜୋହନ ଜିରୁସାଲାମ୍‍ତୁ ଡ଼େସିସର୍ହାର୍‍ । ଡ଼େସି ସନି ସାରିଦୁ ୱାର୍‌ ସମିରୋଣଦି ଏସ ନାର୍‍କାଙ୍ଗ୍‍ଁ ସୁସମାଚାର୍‌ ପ୍ରଚାର୍‌ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ପ୍ରବୁଦି ଅରେନ୍‌ ଦୁତ୍‍ ପିଲିପତିଙ୍ଗ୍‍ ଇର୍ହାନ୍‌, “ତିଆର୍‌ ଆଆ, ଉଣେରି ତରିନ୍‌ ଜିରୁସାଲାମ୍‍ତାନ୍‍ ଗାଜା ତରିନ୍‌ ମାନି ପେରିଜାରିଦୁ ସାଙ୍ଗ୍‍ଆ ।” ଆଜିକାଲି ମାରି ଆୟା ରାସ୍ତା ବ୍ୟବ୍‌ହାର୍‌ ଆଏଜିନାତ୍‌ ");
INSERT INTO kfcp_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ଆବେଟ୍‌ ପିଲିପ ନିଙ୍ଗିଁତା ସର୍ହାନ୍‍ । ମାରି ସୁଡ଼ୁଦୁ, ଇତିଓପିଆ ଦେସ୍‍ତି କାଣ୍ତାକି ଦର୍‌ତି ରାଣିଦି ମାନୁ ପେରିପାଣିକିନି ପଦ୍‌ ପୟ୍‌ତି ଇତିଓପିଆଦି ପାଣିକିନିକାନ୍‌, ଏନ୍‌ ତାନି ୱିଜୁ ଦନ୍‍ସମ୍ଫତିଦି ସୁଣିକାନ୍‍ ମାର୍ହାନ୍‍, ୱାନ୍‌ ମାପୁରୁଙ୍ଗୁଁ ପାର୍‌ତନା କିଦେଙ୍ଗ୍‌ ଇଜି ଜିରୁସାଲାମ୍‍ତୁ ୱାତାମାର୍ହାନ୍‍; ");
INSERT INTO kfcp_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ୱାନ୍‌ ୱାନି ରତଦୁ ବାସ୍‌ସି ଇନ୍‌ଡ୍ର ଡ଼େସିସଲ୍‍ସିମାର୍ହାନ୍‍ । ୱାନ୍‌ ରତଦୁ ଡ଼େସିସନି ସମୟତୁ ଜିସାୟ ବାବବାଦିଦି ପୁସ୍ତକ ନାଣ୍ତ ଆଉଲି ଆଜି ପଡ଼ାଜି ମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ପବିତ୍ର ଆତ୍ମା ପିଲିପତିଙ୍ଗ୍‍ ଇର୍ହାତ୍‌, “ଆୟା ରତ ଲାକ୍‌ତୁ ସାଙ୍ଗ୍‍ଆ ମାରି ୱାନି ଲାକ୍‌ତୁ ତେବାଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ଆବେଟ୍‌ ପିଲିପ୍‍ପ ଉର୍‍ସି ସଲ୍‍ସି ୱାନ୍‌ ଜିସାୟ ବାବବାଦିଦି ବଇ ପଡ଼ାନିକା ୱେର୍‍ଆନ୍‍ । ୱାନ୍‌ ୱାନିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ନିନ୍‌ ଆମାକା ପଡ଼ାଜିନି, ଆକା ବୁଜାଦେଙ୍ଗ୍‌ ଆଟ୍‍ସିନିନୋ ?” ");
INSERT INTO kfcp_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ପାଣିକିନିକାନ୍‌ ଇର୍ହାନ୍‌, “ଅରେନ୍‌ ଏନ୍‌ ନାଙ୍ଗିଁ ଇକା ବୁଜା କିଜ ସିଏତିଙ୍ଗ୍‍, ନାନ୍ ଏଣ୍ତେସ୍‌ ବୁଜାଦେଙ୍ଗ୍‌ ଆଟ୍‍ନା ?” ୱାନି ୱାଲେ ରତଦୁ ବାସ୍‌ତେଙ୍ଗ୍‌ ଇଜି ୱାନ୍‌ ପିଲିପତିଙ୍ଗ୍‍ କୁକ୍‍ତାନ୍ । ");
INSERT INTO kfcp_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ୱାନ୍‌ ଦାର୍ମୁସାସ୍ତ୍ରଦି ଇୟା ବାଗ୍ ପଡ଼ାଜି ମାର୍ହାନ୍‍ : “କାତ୍‍ତେଙ୍ଗ୍‍ ଇଜି ଅଆୟ୍‍ଆଜିମାନି ମେଣ୍ତା ୱାଜା, ବୁର୍‍ବୁସେଙ୍ଗ୍‍ କୟ୍‍ନିୱାଲେ ଆଲେନିମାନି ମେଣ୍ତା ୱାଜା ୱାନ୍‌ ପଦ୍‌ ବା ମାଟା ଇନ୍‍ଏତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ୱାନ୍‌ ଅପ୍‍ମାନ୍‍ ଆତାନ୍‍ ମାରି ନ୍ୟାୟ୍‍ତାନ୍ ଜିଣାଏତାନ୍‍ । ୱାନି କୁଟୁମ୍‌ତି ବିସୟ୍‌ତାନ୍‌ ଏନ୍‌ ଇନିକା ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଆଟ୍‍ଏର୍‍, ଇରିଙ୍ଗ୍‌ ଦୁନିଆଦୁ ୱାନି ଜିବନ୍‌ତି ୱିଜ୍‍ନିକା ଗଟାତାମାନାତ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ପାଣିକିନିକାନ୍‌ ପିଲିପତିଙ୍ଗ୍‍ ୱେନ୍‌ବାତାନ୍‌, “ବାବବାଦି ଏ ବିସୟ୍‌ତାନ୍‌ ୱେର୍‍ସିନାନ୍‍, ନାଙ୍ଗିଁ ଇନ୍‌ଆଁ । ୱାନି ନିଜେଦି ବିସୟ୍‌ତାନ୍‌ ନୋ ଆଇ ଏ ବିସୟ୍‌ତାନ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ପିଲିପ ଦାର୍ମୁସାସ୍ତ୍ରଦି ଇୟା ବାଗ୍‍ତାନ୍‍ ଆରାମ୍‌ କିଜି ଜିସୁଦି ବିସୟ୍‌ତାନ୍‌ ରାସାତି ୱିଜୁ ନେଗିକାବୁର୍‌ ୱାନିଙ୍ଗ୍‌ ୱେର୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ୱାର୍‌ ପେରିଜାରିଦୁ ସଲ୍‍ପୁ ସଲ୍‍ପୁ ଉନ୍‍ଣ୍ତ୍ରି ଏରୁ ମାନି ଲାକ୍‍ତୁ ଇତାର୍‌ । ପାଣିକିନିକାନ୍‌ ଇର୍ହାନ୍‌, “ଇବେ ତୋ ଏରୁ ମାନେ, ନା ଡୁବନ୍‌ ଅତେଙ୍ଗ୍‌ ଇଜି ଇନିକା ବାଦା ମାନାତ୍‌ ନୋ ?” ");
INSERT INTO kfcp_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ପିଲିପ ଇର୍ହାନ୍‌, ନିନୁ ୱିଜୁ ମନ୍‍ତିୱାଲେ ଜଦି ବିସ୍‍ବାସ୍‍ କିନି, ଆତିଙ୍ଗ୍‍ଁ ଆନାତ୍‍, ଆବେଟ୍‍ ୱାନ୍‍ ଇର୍ହାନ୍‌, ଜିସୁ କ୍ରିସ୍ତ ଜେ ମାପୁରୁଦି ମାରିନ୍‍, ଇକା ନାନୁ ବିସ୍‍ବାସ୍‍ କିଜିନା । ");
INSERT INTO kfcp_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ମାରି ୱାନ୍‌ ରତଦିଙ୍ଗ୍‍ ନିଲପ୍‍ତେଙ୍ଗ୍ ଆଦେସ୍‌ ସିତାନ୍‌, ମାରି ପିଲିପ ନି ପାଣିକିନିକାନ୍‌ ରିଏର୍‌ ଏରୁ ଲୋଇ ସର୍ହାର୍‍, ମାରି ପିଲିପ ୱାନିଙ୍ଗ୍‌ ଡୁବନ୍‌ ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ୱାର୍‌ ଏରୁତାନ୍‍ ନିଙ୍ଗ୍‍ଜି ୱାତି ୱେନ୍‌କା, ପ୍ରବୁଦି ପବିତ୍ର ଆତ୍ମା ପିଲିପତିଙ୍ଗ୍‍ ଅତାତ୍‍ । ପାଣିକିନିକାନ୍‌ ମାରି ୱାନିଙ୍ଗ୍‌ ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏତାନ୍‍, ମାତର୍‌ ୱେଡ଼ିକାଦାନ୍‌ ପୁରା ଆଜି ୱାନି ସାରିଦୁ ସର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ଏସ ସମୟ ୱେନ୍‌କା ପିଲିପ ସୁଡ଼ୁତାନ୍‌ ଜେ ୱାନ୍‌ ଅସଦୋଦ୍‍ତୁ ଇତାନ୍‌ । ଆବେଟ୍‌କୁ ୱାନ୍‌ କାଇସରିୟାଦୁ ସର୍ହାନ୍‍ ମାରି ସାରିଦୁ ମାନି ଗାଡ଼୍‌କାଙ୍ଗ୍‌ ସୁସମାଚାର୍‌ ପ୍ରଚାର୍‍ କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ଇୟା ସମୟ୍‍ତୁ ସାଉଲ ପ୍ରବୁଦି ସିସୁରିଙ୍ଗ୍‌ କାତ୍‍ତେଙ୍ଗ୍‍ ଇଜି ଆଦ୍‌ରିସ୍‌ କିଜି ପେରି ଜାଜକଦି ଲାକ୍‌ତୁ ସର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ମାରି ଦାମାସ୍‍କସ୍‍ତି ପାର୍‍ତନାକିନି ଇଲ୍‌କାଙ୍ଗ୍‌ ପ୍ରବୁଦି ୱାଲେ ବୁଲାନିୱାରିଙ୍ଗ୍‍ ପୟ୍‌ତିଙ୍ଗ୍‌ ତର୍‌ସି ଜିରୁସାଲାମ୍‍ତୁ ଆସ୍‌ସି ତାତେଙ୍ଗ୍‌ ଇଜି ପେରି ଜାଜକରି ମାଣାନ୍‌ ସାରି ସିନି ଆକୁ ଲୋସ୍‍ତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ସାଉଲ ଦାମାସ୍‍କସ୍‍ ଗାଡ଼୍‌ ଲାକ୍‌ତୁ ଇଗା ସନି ସମୟ୍‍ତୁ ଦାପ୍ରେ ବାଦଡ଼୍‍ତାନ୍‍ ଉନ୍‍ଣ୍ତ୍ରି ଜାୟ୍‌ ୱାନି ସାରିବେଡ଼୍‍ତି କାସ୍‍ସି ନିଙ୍ଗିଁତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ୱାନ୍‌ ବୁମିଦୁ ଆର୍‍ତାନ୍‍ ମାରି ଉନ୍‍ଣ୍ତ୍ରି ବଲ୍ ୱେର୍‍ଆନ୍‍, “ସାଉଲ ! ସାଉଲ ! ନିନ୍‌ ଏନ୍ଦା ନାଙ୍ଗିଁ ତାଡ଼ନା କିଜିନି ?” ");
INSERT INTO kfcp_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ୱାନ୍‌ ଇର୍ହାନ୍‌, “ପ୍ରବୁ, ନିନ୍‌ ଏନ୍‌ ?” ମାରିଡ଼େସି ଆୟା ବଲ୍ ୱାତାତ୍‍, “ନିନ୍‌ ଏଙ୍ଗ୍‍ଁ କାସ୍ଟୁ କିଜିନି, ନାନ୍ ଆୟା ଜିସୁ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ନିଙ୍ଗ୍‍ଆ, ଗାଡ଼୍‌ତୁ ସାଙ୍ଗ୍ଆ, ଇନିକା କିଦେଙ୍ଗ୍‌ ଆନାତ୍‌, ଆବେ ନିଙ୍ଗିଁ ୱେର୍‌ନା ସିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ସାଉଲତି ୱାଲେ ଅର୍‌ସେ ସନିକାର୍‍ କାବାଆଜି ତେବାତା ସର୍ହାର୍‍; ୱାର୍‌ ଆୟା ବଲ୍ ୱେର୍‌ଆର୍‌, ମାତର୍‌ ଏଙ୍ଗ୍‌ ସୁଡ଼ୁଦେଙ୍ଗ୍‍ ଆଟ୍‌ଏତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ସାଉଲ ବୁମିଦାନ୍‌ ନିଙ୍ଗ୍‍ଜି କାଣୁକୁ ରେତାନ୍‍, ମାତର୍‌ ୱାନିଙ୍ଗ୍‌ ଇନିକା ତର୍‍ଏତାତ୍‍ । ଆବେଟ୍‌ ୱାର୍‌ ୱାନି କିୟୁ ଆସ୍‌ସି ଦାମାସ୍‍କସ୍‍ ସାନ୍ଦି ସାରି ତର୍‌ସି ଅତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ମୁନେନ୍‌ ସାନ୍ଦି ୱାନ୍‌ ସୁଡ଼ୁଦେଙ୍ଗ୍‌ ଆଟ୍‍ଏତାନ୍‍ ମାରି ଆୟା ସମୟ୍‍ତୁ ଉଣୁଏତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ଦାମାସ୍‍କସ୍‍ତୁ ହନନିୟ ଦର୍‌ତି ଅରେନ୍‌ ସିସୁ ମାର୍ହାନ୍‍ । ୱାନ୍‌ ଉନ୍‍ଣ୍ତ୍ରି ଦର୍ସନ୍‍ ପୟ୍‌ତାନ୍‌, ପ୍ରବୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ହନନିୟ !” ୱାନ୍‌ ଇର୍ହାନ୍‌, “ଏ ପ୍ରବୁ ଇନ୍‌ଆଁ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ପ୍ରବୁ ଇର୍ହାନ୍‌, “ତିଆର୍‌ ଆଆ । ସିଦା ଦର୍‌ତି ପେରିଜାରି ଆସ୍‌ସି ଜିହୁଦାଦି ଇଲୁଦୁ ସାଙ୍ଗ୍ଆ । ଆବେ ତାର୍ସସ୍‍ତାନ୍‍ ୱାତିମାନି ସାଉଲ ଦର୍‌ତି ଅରେନ୍‌ ଲୋକ୍‌ତିଙ୍ଗ୍‌ ପୟ୍‍ଆ । ୱାନ୍‌ ପାର୍‌ତନା କିଜିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ହନନିୟ ଦର୍‌ତି ଅରେନ୍‌ ଲୋକୁ ୱାଜି ୱାନି ମୁସ୍‌କୁ କିୟୁ ଇଟ୍‌ତିଙ୍ଗ୍‌, ୱାନ୍‌ କାଣୁକୁ ସୁଣାନ୍‌ ଇଜି ଦର୍ସନ୍‍ ପୟ୍‌ତାମାନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ହନନିୟ ଇର୍ହାନ୍‌, “ପ୍ରବୁ, ଇୟା ଲୋକୁ ଜିରୁସାଲାମ୍‍ତୁ ନି ବିସ୍‍ବାସି ଲୋକା ଉଣ୍ତିଙ୍ଗ୍‌ ଏମେ କାସ୍ଟୁଦି ପାଣି ୱିଜୁ କିତାମାନାନ୍‍, ଆୟା ବିସୟ୍‌ତାନ୍‌ ନାଣ୍ତ ଲୋକୁ ନାଙ୍ଗିଁ ୱେର୍‍ତାମାନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ମାରି ୱାନ୍‌ ପେରି ଜାଜକରି ମାଣ୍‌କୁ ଅଦିକାର୍‌ ଆକୁ ତାସି, ଦାମାସ୍‍କସ୍‍ତୁ ନି ପାର୍‌ତନା କିନିୱାରିଙ୍ଗ୍‍ ଆସ୍‌ସି ଅତେଙ୍ଗ୍‌ ଇଜି ୱାତାମାନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ପ୍ରବୁ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ସାଙ୍ଗ୍ଆ, ଅଣଜିହୁଦି ମାରି ରାଜା ମାରି ଇସ୍ରାଏଲ୍‌ତି ଲୋକା ଆଗ୍‌ଡ଼ି, ନା ଦର୍‌ ୱେର୍‌ତେଙ୍ଗ୍‌ ଇଜି ମାରି ନା ସେବା କିଦେଙ୍ଗ୍‌ ନାନ୍ ୱାନିଙ୍ଗ୍‌ ଆସ୍‍କିତାମାନା । ");
INSERT INTO kfcp_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ନା ଉଣ୍ତିଙ୍ଗ୍‌ ୱାନ୍‌ ଏମେ ଦୁକ୍‍ ପୟ୍‌ନାନ୍‌, ନାନ୍ ନିଜେ ୱାନିଙ୍ଗ୍‌ ୱେର୍‌ନା ।” ");
INSERT INTO kfcp_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ହନନିୟ ସର୍ହାନ୍‍, ସାଉଲ ମାନି ଇଲୁଦୁ ଡ଼ୁଗୁଜି ୱାନି ମୁସ୍‌କୁ କିୟୁ ଇଟ୍‌ତାନ୍‌ । ୱାନ୍‌ ଇର୍ହାନ୍‌, “ତଡ଼ାନ୍‌କୁ ସାଉଲ, ଇବେ ୱାନି ସାରିଦୁ ଏମେ ପ୍ରବୁ ଜିସୁ ନିଙ୍ଗିଁ ଦର୍ସନ୍‍ ସିତାନ୍‌, ୱାନ୍‌ ନାଙ୍ଗିଁ ପକ୍‍ତାମାନାନ୍‍, ଏଣ୍ତେସ୍‌ମାରି ଡ଼େସି ନିନ୍‌ କାଣୁକୁ ସୁଡ଼୍‍ଦେଙ୍ଗ୍‍ ଆଟ୍‌ନି ମାରି ପବିତ୍ର ଆତ୍ମାଦୁ ପୁରା ଆନି ।” ");
INSERT INTO kfcp_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ଆୟାଦାପ୍ରେ ସାଉଲତି କାଣ୍‍କାଣ୍‍କୁ ମିନିଦି ସପା ୱାଜା ଏସ ଆର୍‍ତେ ମାରି ୱାନ୍‌ ମାରିଅରର୍ସୁ ସୁଡ଼୍‍ଦେଙ୍ଗ୍‍ ଆଟ୍‍ତାନ୍‍ । ୱାନ୍‌ ନିଙ୍ଗ୍‍ଜି ଡୁବନ୍‌ ଅତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ମାରି ଉଣୁଜି ସାକ୍ତି ପୟ୍‌ତାନ୍‌ । ସାଉଲ ସିସୁରି ୱାଲେ ଦାମାସ୍‍କସ୍‍ତୁ ଏସ ଦିନ୍‌ ତେବାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ୱାନ୍‌ ସିଦା ପାର୍‍ତନାକିନି ଇଲ୍‌କାଙ୍ଗ୍‌ ସଲ୍‍ସି, ଜିସୁ ଜେ ମାପୁରୁଦି ମାରିସି, ଇୟା ମାଟା ପ୍ରଚାର୍‌ କିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ଏମେକାର୍‌ ୱାନି ମାଟା ୱେର୍‌ଆର୍‌, ୱାର୍‌ କାବାଆଜି ୱେନ୍‌ବାତାର୍‌, “ଜିରୁସାଲାମ୍‍ତୁ ଜିସୁ ଦର୍‌ତି ଲୋକ୍‌ତି ପାର୍‌ତନା କିନିୱାରିଙ୍ଗ୍‍ ଏମେ ଲୋକୁ କାତ୍‍ସି ମାର୍ହାନ୍‍, ଇକାନ୍‌ ଇନିକା ଆକାନ୍‍ ଆଏନ୍‌ ନୋ ? ୱାରିଙ୍ଗ୍‌ ପେରି ଜାଜକରି ଲାକ୍‌ତୁ ଆସ୍‌ସି ଅନି ଉଦେସ୍‍ତାନ୍‍ ୱାନ୍‌ ଇନିକା ଇବେ ରେଏନ୍‌ ମାର୍ହାନ୍‍ ନୋ ?” ");
INSERT INTO kfcp_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ମାତର୍‌ ସାଉଲ ପ୍ରଚାର୍‌ ନାଣ୍ତ ସାକ୍ତି ମାର୍ହାତ୍‌, ଜିସୁ ଜେ ମସିହ, ଇୟା ବିସୟ୍‌ତାନ୍‌ ୱାନି ପାର୍‌ମାଣ୍‌ ନିସା ଜିଦ୍‌ ମାର୍ହାତ୍‍ ଜେ ଦାମାସ୍‍କସ୍‍ତୁ ବାସାଜି ମାନି ଜିହୁଦିର୍‌ ୱାନି ଇନି ମାଟାଦି ଉତର ସିଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏର୍‍ ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ନାଣ୍ତ ଦିନ୍‌ ଆତି ୱେନ୍‌କା ଜିହୁଦିର୍‌ ଉଣ୍ତାଜି ସାଉଲତିଙ୍ଗ୍‍ ଡାକ୍‍ତେଙ୍ଗ୍‍ଁ ଇଜି ଉପାୟା କିତାର୍‍, ");
INSERT INTO kfcp_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ମାତର୍‌ ସାଉଲ ୱାରି ଉପାୟ ନେସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‍ତାନ୍‍ । ୱାନିଙ୍ଗ୍‌ କାତ୍‍ତେଙ୍ଗ୍‍ ଇଜି ୱେଡ଼େ ନାଡ଼ା ୱାର୍‌ ଗାଡ଼୍‌ତି ଦୁଆର୍‍ ୱିଜୁ କାପ୍‌କିଜି ତେବାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ମାତର୍‌ ଅର୍‍ଲେନ୍‍ ନାଡ଼ା ସାଉଲତି ସିସୁର୍‍ ୱାନିଙ୍ଗ୍‌ ଉନ୍‍ଣ୍ତ୍ରି ଦାଉଣିକାଦୁ ଇଡ୍‌ଜି ଗଡାଦି ଉନ୍‍ଣ୍ତ୍ରି ରେଆତି ସାରି ସିଜି ଆଡ୍‍ଗି ରେପ୍‍ତା ସିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ସାଉଲ ଜିରୁସାଲାମ୍‍ତୁ ସଲ୍‍ସି ସିସୁରି ୱାଲେ ମିସାଦେଙ୍ଗ୍‍ ସେସ୍ଟା କିତାନ୍‌ । ମାତର୍‌ ୱାନ୍‌ ସିସୁ ଇଜି ୱାର୍‌ ମୁଟେ ବିସ୍‌ବାସ୍‌ କିଏତାର୍‌ । ୱିଜେରେ ୱାନିଙ୍ଗ୍‌ ତିଲାଜି ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ମାତର୍‌ ବର୍ଣ୍ଣବା ୱାନିଙ୍ଗ୍‌ ପ୍ରେରିତ ସିସୁରି ଲାକ୍‌ତୁ ଅସି ଦାମାସ୍‍କସ୍‍ ସାରିଦୁ ସାଉଲ ଏଣ୍ତେସ୍‌ ପ୍ରବୁଦି ଦର୍ସନ୍‍ ପୟ୍‍ତାମାର୍ହାନ୍‍ ମାରି ପ୍ରବୁ ଏଣ୍ତେସ୍‌ ୱାନିଙ୍ଗ୍‌ ମାଟା ଇର୍ହାମାର୍ହାନ୍‌, ଇୟାୱିଜୁ ବିସୟ୍‌ ୱାରିଙ୍ଗ୍‌ ବୁଜାକିଜି ଇର୍ହାନ୍‌ । ଦାମାସ୍‍କସ୍‍ତୁ ଜିସୁଦି ଦର୍‌ତାନ୍‌ ସାଉଲ ଏଣ୍ତେସ୍‌ ତିଲାଏଣ୍ତା ପ୍ରଚାର୍‌ କିତାମାର୍ହାନ୍‌, ୱାରିଙ୍ଗ୍‌ ନେଗେନ୍‌ କିଜି ବୁଜାକିଜି ଇର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ଇୟା ୱେନ୍‌କା ସାଉଲ ପ୍ରେରିତ ସିସୁରି ୱାଲେ ତେବାତାନ୍‌ ମାରି ଜିରୁସାଲାମ୍‌ତି ସାରିବେଡ଼୍‍ତି ସଲ୍‍ସି ସାହାସ୍‍ତାନ୍‍ ପ୍ରବୁଦି ଦର୍‌ତାନ୍‌ ପ୍ରଚାର୍‌ କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ଇୟାୱିଜୁ ବିସୟ୍‌ତାନ୍‌ ୱାନ୍‌ ଗ୍ରିକ୍‍ ବାସାଦି ଜିହୁଦିର୍‌ ୱାଲେ ବା ଆସ୍‌ସିସାତାର୍‌, ମାତର୍‌ ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ଡାକ୍‍ତେଙ୍ଗ୍‍ଁ ସେସ୍ଟା କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ବିସ୍‍ବାସି ତଡ଼ାନ୍‌କୁ ଇୟା ମାଟା ନେସ୍‌ସି; ସାଉଲତିଙ୍ଗ୍‍ କାଇସରିଆଦୁ ଅତାର୍‌ ମାରି ଆବେଣାନ୍‍ ୱାନିଙ୍ଗ୍‌ ତାର୍ସସ୍‍ତୁ ପକ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ଜିହୁଦା, ଗାଲିଲି ମାରି ସମିରୋଣଦୁ ମାନି କ୍ରିସ୍ଟିୟାନ୍‍ ମଣ୍ତଲିଙ୍ଗାଁ ଉଣ୍ତିଙ୍ଗ୍‌ ଆୟା ସମୟ୍‍ତି ଦିନ୍‌ ସାନ୍ତି ମାର୍ହାତ୍‌, ମାରି ପବିତ୍ର ଆତ୍ମାଦି ସାକ୍ତିଦାନ୍ ୱାରି ଲୋକୁ ନାଣ୍ତ ଆତାର୍‌ ମାରି ୱାର୍‌ ଡାଟ୍‍ ଆତାର୍‌ । ବିସ୍‍ବାସିର୍‍ ପ୍ରବୁଦି ଉଣ୍ତିଙ୍ଗ୍‌ ମାନାଜି ଜିବନ୍‌ କାଟେ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ପିତର ନାଣ୍ତ ଜାଗେଆଙ୍ଗ୍‍ଁ ବୁଲାଜି ବୁଲାଜି ଅର୍‍ଲେନ୍‍ ଲୁଦାଦୁ ବାସାଜିମାନି ବିସ୍‍ବାସିରି ଲୋକାଙ୍ଗ୍‌ ମିସାଦେଙ୍ଗ୍‍ ୱାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ଆବେନୁ ଏନିୟ ଦର୍‌ତି ଅରେନ୍‌ ଲୋକ୍‌ତିଙ୍ଗ୍‌ ବେଟ୍‍ବୁଡ଼ାତାନ୍ । ୱାନ୍‌ କୁସ୍ଟ ରୋଗ୍‍ତୁ ଆସାଇ ଆଜି ଆଟ୍‍ଗୋଟା ବାର୍ସେକ୍‍ ଆସ୍‌ସି କାଟେଲ୍‍ତାନ୍‍ ନିଙ୍ଗ୍‍ଁଦେଙ୍ଗ୍‍ ଆଟ୍‌ଏଜି ମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ପିତର ୱାନିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ଏନିୟ, ଜିସୁ କ୍ରିସ୍ତ ନିଙ୍ଗିଁ ନେଗେନ୍‌ କିତାମାନାନ୍‍ । ନିଙ୍ଗ୍‍ଁଆ, ନି ଟାଟି ରସ୍‍ଆ ।” ଆୟାଦାପ୍ରେ ଏନିୟ ନିଙ୍ଗିଁତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ଇକା ସୁଡ଼୍‌ଜି ଲୁଦା ନି ସାରୋଣଦୁ ବାସାକିଜିମାନି ଲୋକୁ ୱିଜେରେ ପ୍ରବୁଦି ଲାକ୍‌ତୁ ଡ଼େସି ୱାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ଜପାଦୁ ଟବିତା ଦର୍‌ତି ଅରେତ୍‌ ବିସ୍‍ବାସିନି ଆଇମା ବାସାଜି ମାର୍ହାତ୍‌ । ତାନି ଗ୍ରିକ୍‌ ଦର୍‌ ଦର୍କାସ୍‍ ଅର୍ତାତ୍‍ “ବନ୍‍ ଗରିଆ” ମାର୍ହାତ୍‌ । ୱାଦ୍‌ ତାନି ୱିଜୁ ସମୟ୍ ନେଗି ପାଣିଦୁ ମାରି କାକୁର୍ତି ଲୋକାଙ୍ଗ୍‌ ସେବା କିନିମାନି ସମୟ ସିଜି ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ଆୟା ସମୟତୁ ନବ୍‌ ଆଜି ୱାଦ୍‌ ସାତା ସର୍ହାତ୍‍ । ତଡ଼୍‍କୁ ତାନି ମେନ୍ଦଲ୍‍ତିଙ୍ଗ୍ ଇବିସ୍‍ କିଜି ମୁସ୍‌କୁରି ମହଲାଦୁ ତେରେପ୍‍ତେ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ଜପା ଲୁଦାଦାନ୍‍ ଆକ ସିଲେତାତ୍‍ । ପିତର ଲୁଦାଦୁ ମାନାନ୍‌ ଇଜି ୱେନ୍‌ଜି, ଜପାଦୁ ମାନି ବିସ୍‍ବାସିର୍‍ ରିଏର୍‌ ଲୋକାଙ୍ଗ୍‌ ୱାନି ଲାକ୍‌ତୁ ଇନ୍‌ଞ୍ଜି ପୋକ୍‌ତାର୍‌, “ଦୟା କିଜି ବେଗି ମା ଲାକ୍‌ତୁ ରାଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ପିତର ତିଆର୍‌ ଆଜି ୱାରି ୱାଲେ ସର୍ହାନ୍‍ । ଆବେ ଇତି ଦାପ୍ରେ ଲୋକୁ ୱାନିଙ୍ଗ୍‌ ମୁସ୍‌କୁରି ମହଲାଦୁ ଅତାର୍‌ । ଆବେ ରାଣ୍ତିଆଇମେକ୍‍ ତାନିଙ୍ଗ୍‌ କେର୍‍ବିତେନ ଆଡ଼୍‌ବାଜି ଆଡ଼୍‌ବାଜି ଦର୍କାସ୍‍ ଜିଜିମାନି ୱାଲେ ଗୁତ୍‍ତି ମାର୍‍ଇ ଆଙ୍ଗିଁଙ୍ଗ୍‌ ମାରି ୱାତିଙ୍ଗ୍‍ୱିଜୁ ୱାନିଙ୍ଗ୍‌ ତର୍‍ତେ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ପିତର ୱିଜେରିଙ୍ଗ୍‍ ବାକ୍‍ରାଦାନ୍‍ ଆତ୍‌ରେ ସପ୍‍ତାନ୍‍ ମାରି ମେଣ୍ତେଙ୍ଗ୍‍ଁ ଗଟ୍‌କିଜି ପାର୍‌ତନା କିତାନ୍‌ । ତାନିୱେନ୍‍କା ୱାନ୍‌ ଦାର୍କାସ୍‍ତି ସାତି ମେନ୍ଧଲ୍‍ ତରିନ୍‌ ସୁଡ଼୍‌ଜି ଇର୍ହାନ୍‌, “ଟବିତା, ନିଙ୍ଗ୍‍ଁଆ !” ଦର୍କାସ୍‍ କାଣୁକୁ ରେତାତ୍‍ ମାରି ପିତରତିଙ୍ଗ୍ ସୁଡ଼୍‌ଜି ନିଙ୍ଗ୍‍ଜି ବାସ୍‌ତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ପିତର କିୟୁ ପେର୍‌ଜି ତାନିଙ୍ଗ୍‌ ଜିବନ୍‌ କିଜି ନିକ୍‍ତାନ୍‍ । ୱେନ୍‌କା ଉଣ୍ତାତି ମାର୍‍ଇ ୱିଜୁ ବିସ୍‍ବାସି ନି ରାଣ୍ତିଆଙ୍ଗ୍‍ଁ କୁକ୍‌ସି ଦର୍କାସ୍‍ତିଙ୍ଗ୍‍ ୱାରି କିୟୁଦୁ ସର୍ପେ କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ଇୟା କାବୁର୍‌ ଜପାଦି ୱିଜୁ ତରିନ୍‌ ୱେଙ୍ଗିଁତାତ୍‌ ମାରି ନାଣ୍ତ ଲୋକୁ ପ୍ରବୁଙ୍ଗ୍ଁ ବିସ୍‌ବାସ୍‌ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ପିତର ନାଣ୍ତ ଦିନ୍‌ ସାନ୍ଦି ଜପାଦୁ ସିମୋନ ଦର୍‌ତି ଅରେନ୍‌ ତଲ୍‍କୁପାଣିକିନି ଇଲ୍‌ତୁ ତେବାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","କାଇସରିଆଦୁ ବାସାନି କର୍ଣ୍ଣିଲିୟ “ଇଟାଲିଦି ବାହିନି” ଦର୍‌ତି ରମିୟ ସୈନ୍ୟରି ସେନାପତି ମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ୱାନ୍‌ ଅରେନ୍‌ ଦାର୍ମୁ ଲୋକୁ ମାର୍ହାନ୍‍ । ୱାନ୍‌ ମାରି ୱାନି ଇଲୁଦି ୱିଜେରେ ମାପୁରୁଙ୍ଗୁଁ ପାର୍‌ତନା କିଜିମାର୍ହାର୍‍ । ୱାନ୍‌ କାକୁର୍ତି ଜିହୁଦି ଲୋକାଦି ନେଗି ଉଣ୍ତିଙ୍ଗ୍‌ ନାଣ୍ତ ପାଣି କିଜି ମାର୍ହାନ୍‍ ମାରି ଦିନାମି ମାପୁରୁମାନୁ ପାର୍‌ତାନା କିଜିମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ଅର୍‍ଲେନ୍‍ ୱେଡ଼ାରେନି ତିନ୍‍ ଗଣ୍ଟା ସମୟ୍‍ତୁ ୱାନ୍‌ ଉନ୍‍ଣ୍ତ୍ରି ଦର୍ସନତୁ ନେଗେନ୍ ସୁଡ଼ୁତାନ୍‌ ଜେ ମାପୁରୁଦି ଦୁତ୍‍ ୱାଜି ୱାନିଙ୍ଗ୍‌ କୁକ୍‍ସିନାନ୍‍, “କର୍ଣ୍ଣିଲିୟ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ୱାନ୍‌ ତିଲାଜି ଦୁତ୍‍ତି ତରିନ୍‌ ସୁଡ଼୍‌ଜି ଇର୍ହାନ୍‌, “ଏ ପ୍ରବୁ ଇନିକା ?” ଦୁତ୍‍ ଇର୍ହାନ୍‌, “ମାପୁରୁ ନି ପାର୍‌ତାନା ନି ଦାନ୍‍ସିନିମାନୁ ୱେଡ଼ିକା ଆତାମାନାନ୍‌ ମାରି ତେନି ବାଦ୍‌ଲୁ ସିଦେଙ୍ଗ୍‍ ଇଜି ତିଆର୍‌ ମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ଇଲେଇ ସିମୋନ ପିତର ଦର୍‌ତି ଅରେନ୍‌ ଲୋକ୍‌ତିଙ୍ଗ୍‌ କୁକ୍‍ସ ତାତେଙ୍ଗ୍‌ ଇଜି ଜପାଦୁ ଲୋକାଙ୍ଗ୍‌ ପକ୍‍ଆ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ୱାନ୍‌ ସାମ୍‌ଦୁର୍‌ ପାଡ଼ି ବାସାଜିମାନି ସିମୋନ ଦର୍‌ତି ତଲ୍‍ପାଣିକିନିୱାନି ଇଲୁଦୁ ମାନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ଇକା ଇଜି ଦୁତ୍‍ ସର୍ହାନ୍‍ । କର୍ଣ୍ଣିଲିୟ ୱାନି ଇଲ୍‍ତି ରିଏର୍‌ ସାକର୍‌ ନି ସନ୍ୟ ପାଣିକିନିୱାରି ଲୋଇ ଅରେନ୍‌ ଦାର୍ମୁ ଲୋକାଙ୍ଗ୍‌ କୁକିସ୍‍ତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ୱିଜୁ ଗଟଣା ୱେର୍‌ସି ଜପାଦୁ ପକ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ମାରିନାଣ୍ତିଙ୍ଗ୍‍ ମାଦ୍‌ଲାମ୍‌ ୱେଡ଼ାଦୁ ୱାର୍‌ ଜପାଦି ଲାକ୍‌ତୁ ଆନିୱାଲେ, ପିତର ପାର୍‌ତନା କିଦେଙ୍ଗ୍‌ ଇଜି ସାତ୍ ମୁସ୍‌କୁ ସର୍ହାମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ୱାନ୍‌ ବାଙ୍ଗାଁ ସାଜି ଉଣ୍ତେଙ୍ଗ୍‌ ବଦା କିତାନ୍‌ ମାରି କାଦି ଆନି ସମୟ୍‍ତୁ ୱାନ୍‌ ଉଣ୍ତ୍ରି ଦର୍ସନ୍‍ ପୟ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ୱାନ୍‌ ସୁଡ଼ୁତାନ୍‌, ବାଦଡ଼୍‍ ରେଆତାମାନାତ୍‍ ମାରି ଉଣ୍ତ୍ରି ପେରି ସାଦର୍‌ ନାଲ୍‍ଗି କନାଦାନ୍‍ ଡ଼ଆଇ ଆଜି ଦୁନିଆଦି ମୁସ୍‌କୁ ଆର୍‍ଜି ୱାଜିନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ଆବେନୁ ଦୁନିଆଦି ବେସି ରକମ୍‌ତି ଜାତୁ, ଉଜ୍‍ନିକେଙ୍ଗ୍‌ ମାରି ବାଦଡ଼୍‌ତି ପଟିଙ୍ଗ୍‍ଁ ମାନେ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ମାରି ୱାନ୍‌ ଉଣ୍ତ୍ରି ବଲ୍ ୱେର୍‍ଆନ୍‍, “ପିତର ! ନିଙ୍ଗ୍‍ଁଆ, ଡାକ୍‌ସ ତିନ୍‍ଆ !” ");
INSERT INTO kfcp_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ମାତର୍‌ ପିତର ଇର୍ହାନ୍‌, “ସିଲେ ପ୍ରବୁ, ନାନ୍ ଆଟ୍‍ଏ ! ନାନ୍ ଏସାଙ୍ଗ୍‍ ଇନି ତାଗ୍‌ଇକା ନି ଅପବିତ୍ର ଜିନିସ୍‌ ତିନ୍‌ଏ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ମାରି ଉଣ୍ତ୍ରି ଦେବା ୱାନ୍‌ ୱେର୍‍ଆନ୍‍; “ମାପୁରୁ ଆମାକା ପବିତ୍ର କିତାମାନାନ୍‍, ନିନ୍‌ ତାନିଙ୍ଗ୍‌ ଅପବିତ୍ର ଅଡ଼୍‍ବିମା ।” ");
INSERT INTO kfcp_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ମୁଜା ଇୟାୱାଜା ଆନି ୱେନ୍‌କା, ସାଦର୍‍ତିଙ୍ଗ୍‍ ମୁସ୍‌କୁପୁର୍‌ତୁ ପେର୍‌ଜି ଅଆୟ୍‍ ଆତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ପିତର ୱାନି ଦର୍ସନ୍‍ତି ଅର୍ତ ମାଟା ଅଡ଼୍‍ବିଜି କାବା ଆତାନ୍‌ । ଇୟା ୱେଡ଼ାଦୁ, କର୍ଣ୍ଣିଲିୟ ଏମେୱାରିଙ୍ଗ୍‍ ପକ୍‍ତାମାର୍ହାନ୍‍, ୱାର୍‌ ସିମୋନତି ଇଲୁଦିଙ୍ଗ୍ଁ ପୟ୍‌ଜି ଗେଟ୍‍ ଲାକ୍‌ତୁ ନିର୍ହା ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ୱାର୍‌ ୱେନ୍‌ବାତାର୍‌, “ସିମୋନ ପିତର ଦର୍‍ତିକାନ୍‍ ଇବେ ଅରେନ୍‌ କୁଡ଼ାଏନ୍‍ ମାନାନ୍‌ ନୋ ?” ");
INSERT INTO kfcp_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ପିତର ଆୟା ସାନ୍ଦି ଦର୍ସନ୍‍ତି ଅର୍ତ ବୁଜାଦେଙ୍ଗ୍‌ ଇଜି ସେସ୍ଟା କିଜିମାର୍ହାନ୍‍, ଆୟା ସମୟ୍‍ତୁ ଆତ୍ମା ଇର୍ହାତ୍‌, “ସୁଡ଼୍‌ଆ, ଇବେ ମୁଏର୍‌ ଲୋକୁ ନିଙ୍ଗିଁ ପୟ୍‍ଜିନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ତିଆର୍‌ ଆଜି ଆଡ୍‍ଗି ସାଙ୍ଗ୍ଆ ମାରି ୱାରିୱାଲେ ସନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ଇଜି ଅଡ଼୍‌ବିଏଣ୍‌ଗା, ଇରିଙ୍ଗ୍‌ ନାନ୍ ୱାରିଙ୍ଗ୍‍ଁ ପକ୍‍ତାମାନା ।” ");
INSERT INTO kfcp_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ପିତର ଆଡ୍‍ଗି ସଲ୍‍ସି ଆୟା ଲୋକାଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମିର୍‌ ଏମେୱାନିଙ୍ଗ୍‌ ପୟ୍‌ଜିନିଦେର୍‌, ନାନ୍ ଆକାନ୍‍ । ମିର୍‌ ଏନ୍ଦା ୱାତିମାନିଦେର୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ୱାର୍‌ ଇର୍ହାର୍‌, “ସେନାପତି କର୍ଣ୍ଣିଲିୟା ମାଙ୍ଗିଁ ପକ୍‍ତାମାନାନ୍‍ । ୱାନ୍‌ ଅରେନ୍‌ ଦାର୍ମୁଦି ଲୋକୁ । ୱାନ୍‌ ମାପୁରୁଙ୍ଗ୍‍ଁ ଆରାଦନା କିନାନ୍‌ ମାରି ଜିହୁଦିର୍‌ ୱିଜେରେ ୱାନିଙ୍ଗ୍‌ ମାନାନାର୍‌ । ନିଙ୍ଗିଁ ୱାନି ଇନ୍‌ଡ୍ର କୁକ୍‌ସି ଅସିନି ସିକିୟା ୱେନ୍‍ଡ୍ରେଙ୍ଗ୍‍ ଇଜି ମାପୁରୁଦି ଅରେନ୍‌ ପବିତ୍ର ଦୁତ୍‍ ୱାନିଙ୍ଗ୍‌ ଆଦେସ୍‌ ସିତାମାନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ପିତର ୱାରିଙ୍ଗ୍‌ ଲୋଇ କୁକ୍‌ସି ଅସି ଆୟା ନାଡ଼ା ଆବେ ତେବାଦେଙ୍ଗ୍‍ ଇଜି ବାତିଙ୍ଗ୍‍ ମାଲିତାର୍‍ । ମାରିନାଣ୍ତିଙ୍ଗ୍‍ ୱାନ୍‌ ତିଆର୍‌ ଆଜି ୱାରିୱାଲେ ସର୍ହାନ୍‍ । ଜପାଦୁ ଏସ ବିସ୍‍ବାସି ତଡ଼ାନ୍‌କୁ ବା ୱାନିୱାଲେ ଅର୍‌ସେ ସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ମାରିନାଣ୍ତିଙ୍ଗ୍‍ ୱାର୍‌ ସିସେରିଆଦୁ ଇତାର୍‌ । ଆବେ କର୍ଣ୍ଣିଲିୟ ୱାନି ପାଡ଼୍‍କାଦି ସଙ୍ଗ୍‌ ନି ନିଜେଦି ଲୋକାୱାଲେ ପିତରତିଙ୍ଗ୍‌ କାପ୍‌କିଜି ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ପିତର ଲୋଇ ସନିୱାଲେ କର୍ଣ୍ଣିଲିୟ ୱାନିଙ୍ଗ୍‌ ତରାଜି ୱାନି ପାଦାମ୍‌ ଆଡ୍‍ଗି ଆର୍‍ଜି ମାଡ଼ିସ୍‌ କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ମାତର୍‌ ପିତର ୱାନିଙ୍ଗ୍‌ ନିକ୍‍ସି ଇର୍ହାନ୍‌, “ନିଙ୍ଗ୍‍ଁଆ, ନାନ୍ ନିଜେ ଅରେନ୍‌ ଲୋକୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ପିତର କର୍ଣ୍ଣିଲିୟ ୱାଲେ ୱାର୍‍ଗିବୁ ୱାର୍‍ଗିବୁ ଇଲୁ ଲୋଇ ଡ଼ୁଗିତାର୍‍ ମାରି ଆବେ ନାଣ୍ତ ଲୋକାଙ୍ଗ୍‌ ଉଣ୍ତାନି ମାନିକା ସୁଡ଼ୁତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ମିର୍‌ ନେଗେନ୍‌ କିଜି ନେସ୍‌ନିଦେର୍‌, ଅରେନ୍‌ ଜିହୁଦି ୱାନି ଦାର୍ମୁ ବିସ୍‌ବାସ୍‌ ଇସାବ୍‌ତାନ୍‌ ଅଣଜିହୁଦି ଲୋକା ୱାଲେ ମିସାବିଡ଼ା କିଦେଙ୍ଗ୍‌ ଆଟ୍‌ଏନ୍‌ । ମାତର୍‌ ମାପୁରୁ ନାଙ୍ଗିଁ ୱେର୍‌ତାମାନାନ୍‍, ଏଙ୍ଗ୍‍ଁ ତାଗ୍‌ଇକା ନି ଅପବିତ୍ର ଅଡ଼ବିନିକା ନେଗେତ୍‌ ସିଲେ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ଆଦେଙ୍ଗ୍‌ ମିର୍‌ ଏସ୍ତିୱାଲେ ନାଙ୍ଗିଁ କୁକିସ୍‍କିତି, ନାନ୍ ଇନିକା ଅଡ଼୍‍ବିଏଣ୍ତା ୱାତା । ନାନ୍ ନେସ୍‌ତେଙ୍ଗ୍‌ ବଦା କିନା, ନିନ୍‌ ଏନ୍ଦା ନାଙ୍ଗିଁ କୁକିସ୍‍କିତି ?” ");
INSERT INTO kfcp_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","କର୍ଣ୍ଣିଲିୟ ଇର୍ହାନ୍‌, “ମୁନ୍‌ଡ୍ରିଦିନ୍‌ ଆଗ୍‌ଡ଼ି ପୁରା ଇୟା ବେଡ଼ାଦୁ ୱେଡ଼ାରେନି ମୁନ୍‌ଡ୍ରି ଗଣ୍ଟା ସମୟତୁ ନାନ୍ ନା ଇଲୁଦୁ ପାର୍‌ତନା କିଜିମାର୍ହା । ଆୟାଦାପ୍ରେ ଅଡ଼ିନିଆଙ୍ଗିଁ ଆରାତି ଅରେନ୍‌ ଲୋକୁ ନା ଆଗ୍‌ଡ଼ି ନିଲ୍‍ସି ଇର୍ହାନ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","କର୍ଣ୍ଣିଲିୟ ! ମାପୁରୁ ନି ପାର୍‌ତାନା ୱେର୍ହାମାନାନ୍‍ ମାରି ନିନ୍‌ କାକୁର୍ତି ଲୋକାଙ୍ଗ୍‌ ସେବା କିନିକା ସୁଡ଼ୁତା ମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ସିମୋନ ପିତର ଦର୍‌ତି ଅରେନ୍‌ ଲୋକ୍‌ତିଙ୍ଗ୍‌ ତାତେଙ୍ଗ୍‌ ଇଜି ଜପାଦୁ ଲୋକାଙ୍ଗ୍‌ ପକ୍‍ଆ । ୱାନ୍‌ ସାମ୍‌ଦୁର୍‌ ପାଡ଼ି ତେବାତିମାନି ତଲ୍‍ପାଣି କିନି ସିମୋନ ଇଲୁଦୁ କୁଡ଼ାଏନ୍‍ ଆତାମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ଆଦେଙ୍ଗ୍‌ ବେଗି ବେଗି ନାନ୍ ନିଙ୍ଗିଁ କୁକିସ୍‍କିତା ମାରି ନିନ୍‌ ଦୟାକିଜି ୱାତିମାନି । ପ୍ରବୁ ନିଙ୍ଗିଁ ଆମାକା କିଦେଙ୍ଗ୍‌ ଇଜି ସିକିୟା ସିତାମାନାନ୍‌, ଆକା ୱେନ୍‍ଡ୍ରେଙ୍ଗ୍‍ ମାପ୍‌ ୱିଜେରେ ଇଲେଇ ମାପୁରୁଦି ଆଗ୍‌ଡ଼ି ଉଣ୍ତାତାମାନାପ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ପିତର ସିକିୟା ସିଦେଙ୍ଗ୍‍ ଆରାମ୍‌ କିଜି ଇର୍ହାନ୍‌, “ଇଲେଇ ନାନ୍ ବୁଜାଜିନା ଜେ ସତ୍‌ ତାନ୍‍ ମାପୁରୁ ୱିଜେରିଙ୍ଗ୍‍ ସାମାନ୍‍ତାନ୍‍ ସୁଣାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ଆମା ଇନି ଜାତିଦି ଆମା ଏମେ ଲୋକୁ ପ୍ରବୁଦି ପାର୍‌ତାନା କିତିଙ୍ଗ୍‍ଁ ମାରି ୱାନି ଆଗ୍‌ଡ଼ି ସତ୍‍ପାଣି କିତିଙ୍ଗ୍‍ଁ, ପ୍ରବୁ ୱାନିଙ୍ଗ୍‌ ଆସ୍‍ନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ମିର୍‌ ନେସ୍‌ତିମାନିଦେର୍‌ ଜେ ମାପୁରୁ ଇସ୍ରାଏଲ୍‌ ଲୋକା ମାନୁ ଏମେ ବାକ୍ୟ ପକ୍‍ତାମାର୍ହାନ୍‍, ଆକାନେ ଜିସୁଦି ମାଣାନ୍‌ ୱେରାୟ୍‍ଆତିମାନି ସାନ୍ତିଦି ବାକ୍ୟ, ଇୟା ଜିସୁ କ୍ରିସ୍ତ ୱିଜେରି ପ୍ରବୁ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ଜୋହନ ମନ୍‍ ଡ଼େପ୍‍ନି ମାରି ଡୁବନ୍‌ ସିନି କାବୁର୍‌ ୱେର୍‌ତି ୱେନ୍‌କା, ଗାଲିଲିଦାନ୍‌ ଆରାମ୍‌ କିଜି ୱିଜୁ ଇସ୍ରାଏଲ୍‌ ଦେସ୍‌ତୁ ଆମା ୱିଜୁ ଗଟନେଙ୍ଗ୍‍ଁ ଗଟାତାସର୍ହାତ୍‍, ଆକା ମିର୍‌ ନେସ୍‌ନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ମିର୍‌ ନାଜରିତଦି ଜିସୁଦି ବିସୟ୍‌ତାନ୍‌ ମାରି ମାପୁରୁ ଏଣ୍ତେସ୍‌ ୱାନି ମୁସ୍‌କୁ ପବିତ୍ର ଆତ୍ମା ନି ସାକ୍ତି ସିତାମାର୍ହାନ୍‍, ଆକା ନେସ୍‌ନିଦେର୍‌ । ୱାନ୍‌ ୱିଜୁ ତରିନ୍‌ ସଲ୍‍ସି କାବାଆନି ପାଣି କିତାନ୍‌ । ସୟତାନ୍‍ତି ଅଦିକାର୍‍ତାନ୍‍ ମାନି ଲୋକାଙ୍ଗ୍‍ଗଁ ନେଗେନ୍‌ କିତାନ୍‌, ଇରିଙ୍ଗ୍‌ ମାପୁରୁ ୱାନି ୱାଲେ ମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ଜିହୁଦିରି ଦେସ୍‌ତୁ ମାରି ଜିରୁସାଲାମ୍‍ତୁ ୱାନ୍‌ ଏମେ ୱିଜୁ ପାଣି କିତାନ୍‌, ମାପ୍‌ ଆୟାୱିଜୁଦି ସାକି । ତାନେୱେନ୍‌କା ୱାନିଙ୍ଗ୍‌ ୱାର୍‌ କ୍ରୁସଦୁ ଏକିସ୍‍କିଜି ଡାକ୍‍ତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ମାତର୍‌ ମାପୁରୁ ମୁନେନ୍‌ ଲୋଇ ୱାନିଙ୍ଗ୍‌ ସାତିମାଣାନ୍‌ ପୁନିଜିବନ୍‍ ସିଜି ନିକ୍‍ତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ୱାନ୍‌ ୱିଜେରି ଲାକ୍‌ତୁ ସିଲେ, ମାତର୍‌ ମାପୁରୁଦି ବାସେଆତିମାନି ସାକି, ଅର୍ତାତ୍‍ ମା ଲାକ୍‌ତୁ ତରାୟ୍‍ଆତାନ୍‍ । ମାପୁରୁ ୱାନିଙ୍ଗ୍‌ ସାତି ମାଣାନ୍‌ ନିକ୍‍ତି ୱେନ୍‌କା ମାପ୍‌ ୱାନି ୱାଲେ ଉଟାପ୍‍ ତିର୍‍ଆପ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ଲୋକାମାନୁ ନେଗି କାବୁର୍‌ ପ୍ରଚାର୍‌ କିଦେଙ୍ଗ୍‌ ଇଜି ନି ମାପୁରୁ ଜେ ୱାନିଙ୍ଗ୍‌ ଜିନିମାନି ନି ସାତିୱାରି ବିଚାର୍‌କିନି ୱାଜା ନିଲ୍‍ପତାମାନାନ୍‍, ଇୟା ମାଟାଦି ସାକି ସିଦେଙ୍ଗ୍‍ ଇଜି ୱାନ୍‌ ମାଙ୍ଗିଁ ଆଦେସ୍‌ ସିତାମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ୱିଜେରେ ବାବବାଦିର୍ ୱାନି ବିସୟ୍‌ତାନ୍‌ ଇୟା ସାକି ଇର୍ହାମାର୍ହାର୍‍, ଏନ୍‌ ୱାନିମାନୁ ବିସ୍‌ବାସ୍‌ କିନାନ୍‌, ୱାନି ଦର୍‌ତି ସାକ୍ତିଦୁ ୱାନି ପାପ୍‌ କେମା ଆନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ପିତର ସିକିୟା ସିନିୱାଲେ ଏମେକାର୍‌ ୱାନି ସିକିୟା ୱେନ୍‌ଜି ମାର୍ହାର୍‌, ଆୟା ୱିଜେରି ମୁସ୍‌କୁ ପବିତ୍ର ଆତ୍ମା ରେତାତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ଅଣଜିହୁଦିରି ମୁସ୍‌କୁ ବା ମାପୁରୁ ୱାନି ପବିତ୍ର ଆତ୍ମାଦାନ୍‌ ସିନିମାନିକା ସୁଡ଼୍‌ଜି ପିତରତି ୱାଲେ ୱାତିମାର୍‌ଇ ଜପାଦି ଜିହୁଦି ବିସ୍‌ବାସ୍‌ସିର୍‍ କାବାଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ଇରିଙ୍ଗ୍‌ ଜିହୁଦି ବିସ୍‍ବାସିର୍‍ ୱାରିଙ୍ଗ୍‌ ମାପୁରୁଦି ଦନ୍ୟବାଦ୍‌ କିଜିମାନିକା ନି ଆଇ ବାସାଦାନ୍‍ ୱାର୍‍ଗିଜିମାନିକା ୱେର୍‌ଆର୍‌ । ପିତର ଇର୍ହାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“ମା ୱାଜା ଇୟା ଲୋକୁ ବା ପବିତ୍ର ଆତ୍ମା ପୟ୍‍ତାମାନାର୍‍ । ଡୁବନ୍‌ ଅତେଙ୍ଗ୍‌ ଇଜି ଏନ୍‌ ଇନିକା ୱାରିଙ୍ଗ୍‌ ବାଦା ସିଦେଙ୍ଗ୍‍ ଆଟ୍‌ନାନ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ଆଦେଙ୍ଗ୍‌ ୱାନ୍‌ ୱାରିଙ୍ଗ୍‌ ଜିସୁ କ୍ରିସ୍ତଦି ଦର୍‌ତାନ୍‌ ଡୁବନ୍‌ ଅତେଙ୍ଗ୍‌ ଇଜି ଆଦେସ୍‌ ସିତାନ୍‌ । ତାନିୱେନ୍‌କା ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ମାରି ଏସ ଦିନ୍‌ ୱାରି ୱାଲେ ତେବାଦେଙ୍ଗ୍‍ ବାତିଙ୍ଗ୍‌ ମାଲିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ଅଣଜିହୁଦିର୍‍ ବା ମାପୁରୁଦି ବାକ୍ୟ ୱେର୍‌ଆମାନାର୍‌ ଇଜି ପ୍ରେରିତ ସିସୁର୍‍ ମାରି ଜିହୁଦା ରାଜିଦି ଆଇ ବିସ୍‍ବାସି ତଡ଼ାନ୍‌କୁ ୱେର୍‌ଆର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ପିତର ଏସ୍ତିୱାଲେ ଜିରୁସାଲାମ୍‍ତୁ ସର୍ହାନ୍‍, ଅଣଜିହୁଦିରିଙ୍ଗ୍‌ ସୁନ୍ନତ କିନି ତରିନ୍‌ ମାନି ଲୋକୁ ୱାନି ବିରୁଦ୍‌ତାନ୍‌ ଇର୍ହାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“ନିନ୍‌ ଅସୁନ୍ନତ ଅଣଜିହୁଦିରି ଇଲ୍‌କାଙ୍ଗ୍‌ କୁଡ଼ାଏନ୍‍ ଆତିଙ୍ଗ୍‌, ଇୟାୱାଜାକି ୱାରିୱାଲେ ଉଟି ।” ");
INSERT INTO kfcp_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ମାତର୍‌ ଆଗ୍‌ଡ଼ିରାନ୍‌ ଆମାକା ଆମାକା ଗଟାତାମାର୍ହାତ୍‍, ପିତର ୱାରିଙ୍ଗ୍‌ ୱାନି ପୁରା ମାଟା ସିଦେଙ୍ଗ୍‍ ସଲ୍‍ସି ଇର୍ହାନ୍‌ : ");
INSERT INTO kfcp_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“ନାନ୍ ଜପା ଗାଡ଼୍‌ତୁ ପାର୍‌ତନା କିଜିମାନିୱାଲେ ଉଣ୍ତ୍ରି ଦର୍ସନ୍‍ ପୟ୍‍ତା । ଉଣ୍ତ୍ରି ପେରି ସାଦର୍‍ତି ନାଲ୍‍ଗି କନାଦାନ୍‍ ଦୁଙ୍ଗ୍‍ଁଜି ବାଦଡ଼୍‍ତାନ୍‍ ଆଡ୍‍ଗି ଆର୍‍ଜିମାନିକା ନାନ୍ ସୁଡ଼ୁତା, ଆକା ନା ଲାକ୍‌ତୁ ତେବାତାସର୍ହାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ନାନ୍ ନେଗେନ୍‍କିଜି ଲୋଇ ସୁଡ଼୍‌ଜି ଆୟା ଲୋଇ ଇଲ୍‌ତୁ ପସାକିନି ଜାତୁଙ୍ଗ୍‍ଁ, ଦୁନିଆଦି ବନ୍‍ ଜାତୁଙ୍ଗ୍‍ଁ, ଉଜ୍‍ନିକେଙ୍ଗ୍‌ ମାରି ବାଦଡ଼୍‌ତି ବନ୍‍ ପଟିଙ୍ଗ୍‍ଁ ସୁଡ଼ୁତା । ");
INSERT INTO kfcp_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ତାନିୱେନ୍‍କା ନାନ୍ ଇୟା ବଲ୍ ୱେର୍‍ଆ, ପିତର ! ନିଙ୍ଗ୍‍ଁଆ, କୟ୍‍ଜି ତିନ୍‍ଆ । ");
INSERT INTO kfcp_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ମାତର୍‌ ନାନ୍ ଇର୍‌ଆ, ସିଲେ, ପ୍ରବୁ ! ନାନ୍ ଆଟ୍‍ଏ । ଇୟାସାନ୍ଦି ଇନି ଅପବିତ୍ର କାଦି ନା ୱେୟୁଦୁ ଅଏ । ");
INSERT INTO kfcp_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ମୁସ୍‌କୁପୁର୍‌ତାନ୍‌ ମାରିଡ଼େସି ଇୟା ବଲ୍ ୱାତାତ୍‌, ମାପୁରୁ ଆମାକା ପବିତ୍ର କିତାମାନାନ୍‍, ନିନ୍‌ ତାନିଙ୍ଗ୍‍ଁ ଅପବିତ୍ର ଅଡ଼୍‍ବିମା ।” ");
INSERT INTO kfcp_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ମୁଜା ଇୟାୱାଜା ଆତାତ୍‌, ସାରାସାରି ଆୟାୱିଜୁ ମୁସ୍‌କୁପୁର୍‌ତୁ ପେର୍‌ଜି ଅଆୟ୍‍ଆତେ । ");
INSERT INTO kfcp_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ଟିକ୍‌ ଆୟା ସମୟ୍‍ତୁ, ସିସେରିଆଦାନ୍‍ ନା ଲାକ୍‌ତୁ ପକାୟାଆତିମାର୍‍ରି ମୁଏର୍‌ ଲୋକୁ ନାନ୍ ଏମେ ଇଲୁଦୁ ତେବାଜିମାର୍ହା, ଆବେ ଇଗାୱାତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ୱେନ୍‌କା ଅଡ଼୍‌ବିଏଣ୍‌ଗା ୱାରି ୱାଲେ ସନ୍‍ଣ୍ତ୍ରେଙ୍ଗ୍‍ଁ ଇଜି ପବିତ୍ର ଆତ୍ମା ନାଙ୍ଗିଁ ଆଦେସ୍‌ ସିତାତ୍‌ । ଜପାଦି ଇୟା ସଅ ଲୋକୁ ବିସ୍‍ବାସି ତଡ଼ାନ୍‌କୁ ନା ୱାଲେ ସିସେରିଆଦୁ ସର୍ହାର୍‍ ମାରି ମାପ୍‌ ୱିଜେରେ କର୍ଣ୍ଣିଲିୟଦି ଇଲ୍‌ତୁ ଇତାପ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ୱାନି ଇଲ୍‌ତୁ ୱାନ୍‌ ଏଣ୍ତେସ୍‌ ମୁସ୍‌କୁପୁର୍‌ତି ଦୁତ୍‍ତି ଦର୍ସନ୍‍ ପୟ୍‍ତାମାର୍ହାନ୍‍, ଆୟା ବିସୟ୍‌ତାନ୍‌ ମାଙ୍ଗିଁ ୱେର୍‌ତାନ୍‍ । ମୁସ୍‌କୁପୁର୍‌ତି ଦୁତ୍‍ ୱାନିଙ୍ଗ୍‌ ଇର୍ହାମାର୍ହାତ୍‍, “ଜପାଦୁ ମାନି ସିମୋନ ପିତର ଦର୍‌ତି ଅରେନ୍‌ ଲୋକ୍‌ତିଙ୍ଗ୍‌ ତାତେଙ୍ଗ୍‌ ଇଜି ଲୋକାଙ୍ଗ୍‌ ପକ୍‍ତୁ । ");
INSERT INTO kfcp_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ୱାନ୍‌ ୱାଜି ମିଙ୍ଗିଁ ସିକିୟା ସିନାନ୍‍ ମାରି ଆବେଣ୍‍କୁ ନିନ୍‌ ମାରି ନି ଇଲୁତି ୱିଜେରେ ରକିୟା ପୟ୍‌ନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ମାରି ନାନ୍ ଏସ୍ତିୱାଲେ ସିକିୟା ସିଦେଙ୍ଗ୍‌ ଆରାମ୍‌ କିତା, ଆଗ୍‌ଡ଼ି ପବିତ୍ର ଆତ୍ମା ଏଣ୍ତେସ୍‌ ମା ମୁସ୍‌କୁ ରେତାତା ମାର୍ହାତ୍‌, ଆୟାୱାଜା ୱାରି ମୁସ୍‌କୁ ରେତାତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ତାନିୱେନ୍‍କା ନାନ୍ ପ୍ରବୁଦି ଇୟା ବାକ୍ୟ ଏତ୍‌ କିତା : ଜୋହନ ଏର୍‌ତୁ ଡୁବନ୍‌ ସିତାନ୍‌, ମାତର୍‌ ମିର୍‌ ପବିତ୍ର ଆତ୍ମାଦାନ୍‌ ଡୁବନ୍‌ ଆନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ଇକା ପୁରାସତ୍‍ ଜେ ମାପ୍‌ ପ୍ରବୁ ଜିସୁ କ୍ରିସ୍ତଦିମାନୁ ବିସ୍‌ବାସ୍‌ କିତି ଉଣ୍ତିଙ୍ଗ୍‌ ମାପୁରୁ ମାଙ୍ଗିଁ ଏମେ ଦାନ୍‌ ସିତା ମାର୍ହାନ୍‍, ଅଣଜିହୁଦିରିଙ୍ଗ୍‌ ବା ଆୟା ଦାନ୍‌ ସିତାମାନାନ୍‌; ନାନ୍ ଏନ୍‌ ଜେ ମାପୁରୁଦି ଇୟା ପାଣିଦିଙ୍ଗ୍‍ଁ ବିରୁଦ୍‌ କିନା !” ");
INSERT INTO kfcp_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ୱାର୍‌ ଇକା ୱେର୍‌ଇ ୱେନ୍‌କା ମାରି ଜାଟି କିଏନ୍‍ଣ୍ତା ମାପୁରୁଦି ଦନ୍ୟବାଦ୍‌ କିଜି ଇର୍ହାର୍‌, “ଆରିଙ୍ଗ୍‌ ମାପୁରୁ ଅଣଜିହୁଦିରିଙ୍ଗ୍‌ ବା ଏତ୍‌କିଦେଙ୍ଗ୍‍ଁ ମାରି ଜିଦେଙ୍ଗ୍‍ଁ ସୁଜୋଗ ସିତାମାନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ସ୍ତିପାନ୍‍ତି ସାତି ୱେନ୍‌କା ବିସ୍‍ବାସିର୍‍ ତାଡ଼ନା ପୟ୍‌ଜି ଇନିଙ୍ଗାଁ ଆନିଙ୍ଗାଁ ଆନିୱାଲେ ୱାରି ଲୋଇ ଏସଲୋକ୍‌ କେବଲ୍‌ ଜିହୁଦିର୍‌ ଲାକ୍‌ତୁ ବାକ୍ୟ ପ୍ରଚାର୍‌ କିଜି, ପିନିସିଆ, ସାଇପ୍ରସ୍‍ ମାରି ଆଣ୍ଟିୟକ ସାନ୍ଦି ସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ମାତର୍‌ ସାଇପ୍ରସ୍‍ ମାରି କୁରିଣିଦି ଆଇ ଏସ ବିସ୍‍ବାସିର୍‍ ଆଣ୍ଟିୟକଦୁ ସଲ୍‍ସି ଅଣଜିହୁଦିରି ଲାକ୍‌ତୁ ପ୍ରବୁ ଜିସୁଦି ନେଗି କାବୁର୍‌ ପ୍ରଚାର୍‌ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ମାପୁରୁଦି ସାକ୍ତି ୱାରି ୱାଲେ ମାର୍ହାତ୍‌ ମାରି ନାଣ୍ତ ଲୋକୁ ବିସ୍‌ବାସ୍‌ କିଜି ପ୍ରବୁଦି ତରିନ୍‌ ମନ୍‍ ଡ଼େପ୍‍ତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ଏସ୍ତିୱାଲେ ଇୟା କାବୁର୍‌ ଜିରୁସାଲାମ୍‍ତି ମଣ୍ତଲିଦୁ ଇତାତ୍‍, ୱାର୍‌ ବର୍ଣ୍ଣବାସ୍‍ତିଙ୍ଗ୍‍ ଆଣ୍ଟିୟକଦୁ ପକ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ୱାନ୍‌ ଆବେ ଇଜି ମାପୁରୁ ଆୟା ଲୋକାଙ୍ଗ୍‌ ଏଣ୍ତେସ୍‌ ଆସିର୍ବାଦ୍‌ କିତାମାନାନ୍‍, ଆକା ସୁଡ଼୍‌ଜି ୱେଡ଼ିକା ଆତାନ୍‍ ମାରି ଜିବନ୍‌ତୁ ପ୍ରବୁଦି ଉଣ୍ତିଙ୍ଗ୍‌ ବିସ୍‌ବାସ୍‌ ତେବାଜି ନେଗେନ୍‌ ଜିଦେଙ୍ଗ୍‍ଁ ୱାରିଙ୍ଗ୍‍ଁ ୱେର୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ବର୍ଣ୍ଣବାସ୍‍ ପବିତ୍ର ଆତ୍ମା ନି ବିସ୍‌ବାସ୍‌ତୁ ପୁରାଆତି ଅରେନ୍‌ ନେଗି ଲୋକୁ ମାର୍ହାନ୍‍ । ୱାନି ପ୍ରଚାର୍‌ତାନ୍‍ ନାଣ୍ତ ଲୋକୁ ପ୍ରବୁଦି ଲାକ୍‌ତୁ ୱାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ତାନିୱେନ୍‍କା ବର୍ଣ୍ଣବାସ୍‍ ସାଉଲତିଙ୍ଗ୍‍ ପୟ୍‌ଦେଙ୍ଗ୍‌ ଇଜି ତାର୍ସସ୍‍ତୁ ସର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ଆବେ ୱାନିଙ୍ଗ୍‍ଁ ପୟ୍‌ଜି ଆଣ୍ଟିୟକଦୁ ତାତାନ୍‍ । ମାରି ପୁରା ଉନ୍‍ଣ୍ତ୍ରି ବାର୍‍ସେକ୍‍ ସାନ୍ଦି ଇୟା ରିଏର୍‌ ଆୟାବାଣି ମଣ୍ତଲିଦି ବିସ୍‍ବାସିରି ୱାଲେ ମିସାଜି ନାଣ୍ତ ଲୋକାଙ୍ଗ୍‌ ସିକିୟା ସିତାର୍‍ । ଇୟା ଆଣ୍ଟିୟକଦି ବିସ୍‍ବାସିରିଙ୍ଗ୍‍ଁ ଲୋକୁ ଆଗ୍‌ଡ଼ି କ୍ରିସ୍ଟିୟାନ୍‍ ଇଜି ଇର୍ହାମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ଆୟା ବେଡ଼ାଦୁ ଜିରୁସାଲାମ୍‍ତାନ୍‍ ଏସ ବାବବାଦିର୍ ଆଣ୍ଟିୟକଦୁ ୱାତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ୱାରି ଲୋଇ ଆଗାବ ଦର୍‌ତି ଅରେନ୍‌ ଲୋକୁ ଆତ୍ମାଦି ସାକ୍ତିଦାନ୍ ପୁରାଆଜି ୱିଜୁ ଦୁନିଆଦୁ ଉନ୍‍ଣ୍ତ୍ରି ପେରି କାକୁର୍ତି ଆନାତ୍‌ ଇଜି ବବିସତ୍‍ ମାଟା ୱେର୍‌ତାନ୍‌ । ସମ୍ରାଟ କ୍ଳାଡିୟସ୍‍ତି ସମୟ୍‍ତୁ ଇକା ଗଟାତାମାର୍ହାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ସିସୁର୍‍ ଜିହୁଦାଦୁ ବାସାଜିମାନି ବିସ୍‍ବାସି ତଡ଼ାନ୍‌କା ଲାକ୍‌ତୁ ୱାରି ସିଦେଙ୍ଗ୍‍ ଆଟ୍‌ନି ସାନ୍ଦି ସାହାଜ୍ୟ ପକ୍‍ନାର୍‍ ଇଜି ତିର୍‍ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ୱାର୍‌ ଡାବୁଙ୍ଗୁଁ ଉଣ୍ତା କିଜି ବର୍ଣ୍ଣବାସ୍‍ ନି ସାଉଲତି କିଦୁ ମଣ୍ତଲିଦି ପେରି ନେତାର୍‍ରି ଲାକ୍‌ତୁ ଆକା ପୋକ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ଇୟା ସମୟତୁ ରାଜା ହେରୋଦ ମଣ୍ତଲିଦି ଏସ ଲୋକାଙ୍ଗ୍‌ କାସ୍ଟୁସିନିକା ଆରାମ୍‌ କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ୱାନ୍‌ ଜୋହନତି ତଡ଼ାନ୍‌ ଜାକୁବଙ୍ଗ୍‍ କାଣ୍ତାଦାନ୍‍ କାତିସ୍‍ତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ଜିହୁଦିର୍‌ ଇବେ ୱେଡ଼ିକା ସୁଡ଼୍‌ଜି ୱାନ୍‌ ପିତର୍‍ତିଙ୍ଗ୍‍ଁ ବା ତର୍‍ସିସ୍‍ କିତାନ୍‌ । ଇୟା ଗଟନା କମିରିମିସାକିଏନ୍‍ଣ୍ତା ରୁଟି ପଣ୍ତୟ୍‌ତି ସମୟ୍‍ତୁ ଗଟାତାମାର୍ହାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ପିତର ତରାୟ୍‍ଆଜି ଜଇଲ୍‌ତୁ ଇଡାୟ୍‍ ଆତାନ୍‍ ମାରି ନାଲ୍‍ଏର୍‍ ନାଲ୍‍ଏର୍‍ ଲୋକୁ ସନ୍ୟରିଙ୍ଗ୍‍ ଅସି କିଆୟ୍‍ଆତି ନାଲ୍‍ଗି ଦଲ୍‌ ସନ୍ୟର୍‍ ୱାନିଙ୍ଗ୍‌ କାପ୍‌କିଜି ତେବାତାର୍‌ । ନିସ୍ତାର୍‍ ପଣ୍ତୟ୍‌ ୱେନ୍‌କା ୱିଜେରେ ଲୋଇ ୱାନି ବିସାର୍‌ କିନିକା ହେରୋଦ୍‍ତି ବଦା ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ପିତର ଜଇଲ୍‌ତୁ ମାନିୱାଲେ ମଣ୍ତଲିଦି ଲୋକୁ ଉଣ୍ତ୍ରି ମନ୍‍ତାନ୍‍ ୱାନି ଉଣ୍ତିଙ୍ଗ୍‌ ମାପୁରୁଦି ଲାକ୍‌ତୁ ପାର୍‌ତାନା କିଜିମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ଆମା ନାଣ୍ଡିଙ୍ଗ୍ ହେରୋଦ ପିତର୍‍ତିଙ୍ଗ୍‍ ଲୋକା ଆଗ୍‌ଡ଼ି ତାନି ଉଣ୍ତିଙ୍ଗ୍‌ ଅଡ଼୍‍ବିତା ମାର୍ହାନ୍‍, ତାନି ଆଗ୍‌ଡ଼ିରି ନାଡ଼ା ପିତର ରିଏର୍‌ କାପ୍‍କିନିୱାରି ନାଡ଼୍‍ମି ଡରିତାମାର୍ହାନ୍‍ । ରୁଣ୍ତି ସିକ୍‍ଣି ଦାନ୍‍ ୱାନିଙ୍ଗ୍‌ ତର୍‍ତାମାର୍ହାର୍‍ ମାରି ଜଇଲ୍‍ତି ସେର୍‍ଲା ଲାକ୍‌ତୁ କାପ୍‍ନିକାର୍‍ କାପ୍‍କିତା ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ଆୟାଦାପ୍ରେନେ ପ୍ରବୁଦି ଅରେନ୍‌ ଦୁତ୍‍ ୱାଜି ନିର୍‍ଆତ୍‍ ମାରି ବାକ୍‍ରା ଜାୟ୍‌ ଆତାସର୍ହାତ୍‍ । ଦୁତ୍‍ ପିତର୍‌ତି ଗୁଜାମ୍‍ତିଙ୍ଗ୍‍ଁ ଦୁକ୍‍ଜି ୱାନିଙ୍ଗ୍‍ଁ ସୁସ୍‍କାଣ୍‍କାଣ୍‍କୁ ନିକ୍‍ସି ଇର୍ହାତ୍‌, “ବେଗି ନିଙ୍ଗ୍‍ଁଆ !” ବେଗି ବେଗି ପିତରତି କିୟୁଦୁ ତର୍‍ଆତିମାର୍ହି ସିକ୍‍ଣିଙ୍ଗ୍‍ ଆର୍‍ତେ ସର୍‌ଏ । ");
INSERT INTO kfcp_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ତାନିୱେନ୍‍କା ଦୁତ୍‍ ଇର୍ହାତ୍‌, “ଜୁକିଦି ଗାଟି ତର୍‌ଆ, ଜୁତେଙ୍ଗ୍‍ ଆରାଆ ।” ପିତର ଆକା କିତିୱେନ୍‌କା ଦୁତ୍‍ ଇର୍ହାତ୍‌, “ମେନ୍ଦଲ୍‌ତୁ ସାଦର୍‌ ପକ୍‍ସି ନା ୱେନ୍‌କା ରାଆ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ଦୁତ୍‍ ଆମାକା କିଜିମାର୍ହାତ୍‍, ଆକା ଉଣ୍ତ୍ରି ସତ୍‌ ଗଟନା ନୋ ସିଲେ, ପିତର ନେସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‍ଏତାନ୍‍ । ୱାନ୍‌ ଲବ୍‍ ସୁଡ଼୍‍ଜିନାନ୍‍ ଇଜି ଅଡ଼୍‍ବିତାନ୍‍ । ଆରିଙ୍ଗ୍‍ବା ପିତର ଜଇଲ୍‍ତାନ୍‍ ସହସି ଦୁତ୍‍ତି ୱାଲେ ସର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ୱାର୍‌ କାପ୍‍କିନିୱାରି ପାର୍‌ତୁମ୍‌ ନି ମାରି ଉନ୍‍ଣ୍ତ୍ରି ବାଡି ଜିଣାଜି ସାରାସାରି ଗାଡ଼୍‌ତୁ ଡ଼ୁଗୁନି ସାରିଦୁ ମାନି ଲୁୱା ସେର୍‍ଲା ଲାକ୍‌ତୁ ୱାତାର୍‌ । ୱାରି ଉଣ୍ତିଙ୍ଗ୍‌ ସେର୍‍ଲା ତାନି ମନ୍‍ତିଙ୍ଗ୍‍ ରେଏତାତ୍‍ ମାରି ୱାର୍‌ ସହସି ବୁଲାଜି ୱାତାର୍‌ । ୱାର୍‌ ପେରିଜାରିଦୁ ସଲ୍‍ପୁ ସଲ୍‍ପୁ ଆୟାଦାପ୍ରେନେ ମୁସ୍‌କୁପୁର୍‌ତି ଦୁତ୍‍ ପିତରତିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ସି ସର୍ହାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ତାନିୱେନ୍‍କା, ଆମାକା ଗଟାତାମାର୍ହାତ୍‍, ପିତର ଆକା ନେସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‍ସି ଇର୍ହାନ୍‌, “ଇକା ସତେନେ ସତ୍‌ ଇଜି ନାନ୍ ନେସ୍‍ତେଙ୍ଗ୍‍ଁ ଆଟ୍‍ସିନା । ହେରୋଦତି ସାକ୍ତିଦାନ୍ ମାରି ଜିହୁଦି ଲୋକୁ ଆମାକା ଗଟାନାତ୍‌ ଇଜି ଆସା କିତାମାର୍ହାର୍‍, ଆବେଟ୍‌କୁ ନାଙ୍ଗିଁ ରକିୟା କିଦେଙ୍ଗ୍‌ ଇଜି ପ୍ରବୁ ମୁସ୍‌କୁପୁର୍‌ତି ଦୁତ୍‍ତିଙ୍ଗ୍‍ ପକ୍‍ତାମାର୍ହାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ନିଜେଦି ଅବସ୍ଥାଦି ବିସୟ୍‌ତାନ୍‌ ଜାଗାର୍‌ତା ଆଜି ୱାନ୍‌ ଜୋହନତି ନି ମାର୍କରି ଆଇସି ମରିୟମତି ଇଲୁଦୁ ସର୍ହାନ୍‍ । ଆବେ ନାଣ୍ତ ଲୋକୁ ଉଣ୍ତାଜି ପାର୍‌ତନା କିଜିମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ପିତର ଆତ୍‌ରେ ସେର୍‌ଲାଦୁ କତ୍‍ତାନ୍‍, ରୋଦା ଦର୍‌ତି ଅରେତ୍‌ ଦାସି ସେର୍‍ଲା ରେତେଙ୍ଗ୍‍ଁ ୱାତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ପିତରତି ବଲ୍ ନେସ୍‍ତେଙ୍ଗ୍‍ଁ ଆଟ୍‍ସି ୱାଦ୍‌ ନିସା ୱେଡ଼ିକା ଆତାତ୍‍ଜେ ସେର୍‍ଲା ରେଏନ୍‍ଣ୍ତା ପିତର ଆତ୍‌ରେ ନିର୍‍ଆ ମାନାନ୍‌ ଇଜି ୱେର୍‌ତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ୱାର୍‌ ତାନିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, “ନିନ୍‌ ବାୟା ଆତିମାନି ।” ମାତର୍‌ “ଇକା ସତ୍‌” ଇଜି ୱାଦ୍‌ ଆଟ୍‍ୱାଦାନ୍‍ ଇର୍ହାତ୍‍ଆକା, ୱାର୍‌ ଅଡ଼୍‍ବିତାର୍‍, “ଆରିଙ୍ଗ୍‌ ଆନାମାନାତ୍‍, ଇକା ୱାନି ଦୁତ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ପିତର ଜାରିଦିଙ୍ଗ୍ ଜାରି ସେର୍‌ଲାଦୁ କତ୍‍ସି ମାର୍ହାନ୍‍ । ସାରାସାରି ୱାର୍‌ ସେର୍‍ଲା ରେସି ୱାନିଙ୍ଗ୍‌ ସୁଡ଼୍‌ଜି କାବାତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ୱାନ୍‌ କିୟୁଦାନ୍‌ ଜୁଟ୍‍ସି ଆଲ୍‍ଜ ମାନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ଇର୍ହାନ୍‌, ମାରି ପ୍ରବୁ ୱାନିଙ୍ଗ୍‌ ଏଣ୍ତେସ୍‌ ଜଇଲ୍‍ତାନ୍‍ ସପ୍‍ସି ତାତାନ୍‍, ଆୟା ବିସୟ୍‌ ୱାରି ଆଗ୍‌ଡ଼ି ୱେର୍‌ତାନ୍‌ । ତାନିୱେନ୍‍କା ଇୟାୱିଜୁ ମାଟା ଜାକୁବ ନି ଆଇ ୱିଜେରେ ବିସ୍‍ବାସିରି ତଡ଼ାନ୍‌କାଙ୍ଗ୍‌ ୱେର୍‍ତେଙ୍ଗ୍‍ଁ ଇଜି ଆଦେସ୍‌ ସିଜି ୱାନ୍‌ ଆବେଟ୍‌କୁ ଆଇତରିନ୍‍ ସର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ସାଲ୍‍ଦି ଆତି ୱେନ୍‌କା ପିତର ଏମେ ସର୍ହାନ୍‍ ଇଜି କାପ୍‍କିନିୱାରି ଲୋଇ ଗାବ୍‍ରା ଆତାସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ହେରୋଦ ୱାନିଙ୍ଗ୍‌ ପୟ୍‌ଦେଙ୍ଗ୍‌ ଆଦେସ୍‌ ସିତାନ୍‌, ମାତର୍‌ ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ପୟ୍‍ଏତାର୍‍ । ସାରାସାରି କାପ୍‍କିନିୱାରିଙ୍ଗ୍‍ ୱେନ୍‍ବାଜି ୱାରିଙ୍ଗ୍‌ ସାନିଦଣ୍ତ୍‍ ସିନି ଉଣ୍ତିଙ୍ଗ୍‌ ଆଦେସ୍‌ ସିତାନ୍‌ । ତାନିୱେନ୍‍କା ହେରୋଦ ଜିହୁଦା ଦେସ୍‍ତାନ୍‍ ସଲ୍‍ସି କାଇସରିଆଦୁ ତେବାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ଆୟା ସମୟ୍‍ତୁ ହେରୋଦ ସୋର ନି ସିଦୋନତି ଲୋକା ମୁସ୍‌କୁ ନାଣ୍ତ ରିସା ଆତାମାର୍ହାନ୍‍ । ଆଦେଙ୍ଗ୍‍ଁ ୱାରି ଲୋଇ ଉଣ୍ତ୍ରି ଦଲ୍‌ ୱାନିଙ୍ଗ୍‌ ତର୍‍ଆୟ୍‍ ଆଦେଙ୍ଗ୍‌ ଇଜି ସର୍ହାର୍‍ । ପାର୍‌ତୁମ୍‌ ୱାର୍‌ ରାଜା ମେଡ଼୍‍ତି ଦାୟିତୁ ମାନି ବ୍ଳାସ୍ତଙ୍ଗ୍‌ ବୁଜାକିଜି ୱାନି ସାହାଜ୍ୟ ପୟ୍‌ତାର୍‌ । ତାନିୱେନ୍‍କା ୱାର୍‌ ହେରୋଦତି ଲାକ୍‌ତୁ ସଲ୍‍ସି ସାନ୍ତି ଲସ୍‍ତାର୍‍, ଇରିଙ୍ଗ୍‌ ହେରୋଦତି ଦେସ୍‌ଦାନ୍‍ ୱାରି ଦେସ୍‌ତୁ କାଦି ୱିଜୁ ପକ୍‍ସି ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ବାସେ ଆତି ଦିନ୍‍ତୁ ହେରୋଦ ୱାନି ରାଜାଦି ଆଙ୍ଗିଁ ଆରାତାନ୍‍ ମାରି ବିଚାର୍‍ କିନି ରାଜାଗାଦିଦୁ ବାସ୍‌ସି ଲୋକାଙ୍ଗ୍‌ ଉନ୍‍ଣ୍ତ୍ରି ମାଟା ୱେର୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ୱାର୍‌ ଆଉଲି ଆତାର୍‌, “ଇକା ଇନି ଲୋକାଦି ଆଏତ୍‌, ମାତର୍‌ ଅରେନ୍‌ ମାପୁରୁଦି ବଲ୍ !” ");
INSERT INTO kfcp_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ଆୟାଦାପ୍ରେ ପ୍ରବୁଦି ଦୁତ୍‍ ହେରୋଦତିଙ୍ଗ୍‍ ଡାକ୍‌ତାନ୍‌, ଇରିଙ୍ଗ୍‌ ମାପୁରୁଙ୍ଗ୍‍ଁ ଏମେ ଗୌରବ୍‍ ସିନି ମାଟା, ୱାନ୍‌ ଆକା ୱାନିଙ୍ଗ୍‌ ସିଏନ୍‌ ମାର୍ହାନ୍‍ । ପିଡ଼୍‍କୁ ଆଜି ୱାନ୍‌ ସାତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ଇୟା ସମୟ୍ ଲୋଇ ମାପୁରୁଦି ବାକ୍ୟ ପିର୍‌ଜି ୱେଙ୍ଗିଁଦେଙ୍ଗ୍‌ ଆସ୍‌ତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ବର୍ଣ୍ଣବା ମାରି ସାଉଲ ଜିରୁସାଲାମ୍‍ତୁ ସେବା ପାଣି ୱିସ୍‍ସି ଜୋହନ ମାର୍କଙ୍ଗ୍‍ଁ ଅର୍‌ସେ ଅସି ଜିରୁସାଲାମ୍‍ତାନ୍‍ ଡ଼େସିସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ଆଣ୍ଟିୟକ ମଣ୍ତଲିଦୁ ଏସ ବାବବାଦି ନି ସିକିୟା ଗୁରୁର୍‍ ମାର୍ହାର୍‌ । ୱାରି ଲୋଇ ମାର୍ହାନ୍‍ ବର୍ଣ୍ଣବା, ସିମୋନ ଆମାକାନ୍‍କି ନିଗର ଦର୍‌ତାନ୍‌ ୱେଙ୍ଗିଁତା ମାର୍ହାନ୍‍, ଲୁସିଅସ୍‍ କୁରିଣିଦୁ ବାସାନିକାନ୍‍, ମହନେମ ୱାନ୍‌ ରାଜିୟ ପାଲ ହେରୋଦତି ଇଲ୍‌ତୁ ପିରିତାମାର୍ହାନ୍‍ ମାରି ସାଉଲ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ୱାର୍‌ ପ୍ରବୁଦି ସେବା ନି ଉପାସ୍‌ କିନିୱାଲେ, ପବିତ୍ରଆତ୍ମା ୱାରିଙ୍ଗ୍‌ ଇର୍ହାନ୍‌, “ନାନ୍ ଏମେ ପାଣି ଉଣ୍ତିଙ୍ଗ୍‌ ବର୍ଣ୍ଣବା ନି ସାଉଲତିଙ୍ଗ୍‍ଁ କୁକ୍‍ତାମାନା, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାରିଙ୍ଗ୍‍ଁ ନା ଉଣ୍ତିଙ୍ଗ୍‌ ୱେର୍‌ଏ କିଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ୱାର୍‌ ଉପାସ୍‌ ନି ପାର୍‌ତନା କିଜି ଆୟା ରିଏରି ମୁସ୍‌କୁ କିକୁ ଇଡ୍‌ଜି ୱାରିଙ୍ଗ୍‍ଁ ପ୍ରଚାରକିନି ପାଣିଦୁ ପୋକ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ପବିତ୍ର ଆତ୍ମାଦି ମାଣାନ୍‌ ପକାୟ୍‍ ଆଜି ବର୍ଣ୍ଣବା ନି ସାଉଲ ସେଲୁକିୟାଦୁ ସର୍ହାର୍‍ ମାରି ଆବେଟ୍‌କୁ ଜାହାଜ୍‍ତାନ୍‍ ସାଇପ୍ରସ୍‍ ସାରିବେଡ଼୍‍ତି ସାମ୍‌ଦୁର୍‌ ମାନି ନାଣ୍‍ମିରି ଇସ୍ରିବୁମି ବାଡିଦୁ ସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ସାଲାମି ଗାଡ଼୍‌ତୁ ଇଜି ଜିହୁଦିର୍‌ ପାର୍‍ତନାକିନି ଇଲ୍‌କାଙ୍ଗ୍‌ ମାପୁରୁଦି ବାକ୍ୟ ପ୍ରଚାର୍‌ କିତାର୍‍ । ଜୋହନ ମାର୍କ ୱାରିୱାଲେ ମାନ୍‌ଜି ସାହାଜ୍ୟ କିଜିମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ୱାର୍‌ ସାଇପ୍ରସ୍‍ ଇସ୍ରିବୁମି ବାଡି ଜିଣାଜି ପାଫଦୁ ସର୍ହାର୍‍ । ଆବେ ୱାର୍‌ ବାର-ଜିସୁ ଦର୍‌ତି ଅରେନ୍‌ ଜିହୁଦି ଗୁଣୁଏଙ୍ଗ୍‍ଁ ବେଟ୍‍ବୁଡ଼ାତାର୍‍ । ୱାନ୍‌ ନିଜେଦିଙ୍ଗ୍‍ଁ ବାବବାଦି ଇଜିମାର୍‍ଆନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ୱାନ୍‌ ଆୟା ଦ୍ୱିପଦି ସାସନ୍‌କିନି ସର୍ଗିୟସ୍‍ ପାଉଲ୍‍ତି ଅରେନ୍‌ ନେଗି ତଡ଼୍‍ ମାର୍ହାନ୍‍ । ସର୍ଗିୟସ୍‌ ଅରେନ୍‌ ବୁଦିମାନି ଲୋକୁ ମାର୍ହାନ୍‍ । ୱାନ୍‌ ମାପୁରୁଦି ବାକ୍ୟ ୱେନ୍‍ଡ୍ରେଙ୍ଗ୍‍ ବଦାକିଜି ବର୍ଣ୍ଣବା ନି ସାଉଲତିଙ୍ଗ୍‍ଁ କୁକିସ୍‍ତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ମାତର୍‌ ଗୁଣିଆ ଏଲିମାସ ଇକା ୱାନି ଗ୍ରିକ୍‌ ଦରୁ ୱାରିଙ୍ଗ୍‌ ବାଦା ସିତାନ୍‌, ଇରିଙ୍ଗ୍‍ଁ ୱାନ୍‌ ସାସନ୍‍କିନିୱାନିଙ୍ଗ୍‍ଁ କ୍ରିସ୍ତଦି ବିସ୍‌ବାସ୍‌ ଉଣ୍ତିଙ୍ଗ୍‍ଁ ୱେର୍‌ଏ କିଜି ଇଡ୍‍ଦେଙ୍ଗ୍‍ଁ ବଦା କିଜିମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ମାତର୍‌ ସାଉଲ ଆମାୱାନି ଆଇ ଦରୁ ପାଉଲ ପବିତ୍ର ଆତ୍ମାଦୁ ପୁରାଆଜି ଗୁଣିଆ ତରିନ୍‌ ସିଦା କାଣ୍‍କାଣୁକୁ ସୁଡ଼ୁଜି ଇର୍ହାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“ଏ ସୟତାନ୍‍ତି ମାରିସି ! ନିନ୍‌ ୱିଜୁ ନେଗି ବିସୟତି ସାତ୍ରୁ ! ନିନ୍‌ ୱିଜୁ ବିସୟତି ସାଲାକିଦୁ ପୁରାଆତିକିନ୍ଦା ମାରି ୱିଜୁଦିନ୍‌ ପ୍ରବୁଦି ସତ୍‍ତିଙ୍ଗ୍‍ ମିଚ୍‍ ଇଜି ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ଇଜି ସେସ୍ଟା କିଜିନି । ");
INSERT INTO kfcp_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ଇଲେଇ ନିନ୍‌ ପ୍ରବୁଦି କିୟୁଦୁ ଦଣ୍ଡ୍‌ ପୟ୍‌ନି । ନିନ୍‌ କାଣା ଆଜି ଏସ ସମୟ ସାନ୍ଦି ୱେଡ଼େରି ଜାୟ୍‌ ସୁଡ଼୍‍ଦେଙ୍ଗ୍‍ ଆଟ୍‍ଇ ।” ଆୟାଦାପ୍ରେ ଏଲିମାସଦି କାଣୁକୁ ନାଣ୍ତ ଦୁରିଦୁ କେର୍‍ବିନି ୱାଜା ଆନିକା ୱାନ୍‌ ଅଡ଼୍‍ବିତାନ୍‍ ମାରି ୱାନି କିୟୁ ଆସ୍‌ସି ସାରି ତର୍‌ସି ଅତେଙ୍ଗ୍‍ଁ ଇଜି ଅରେନ୍‌ୱାନିଙ୍ଗ୍‌ ପୟ୍‌ଦେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ଇୟା ଗଟ୍‌ନା ସୁଡ଼୍‌ଜି ସାସନକିନିୱାନି ବିସ୍‌ବାସ୍‌ ଆତାତ୍‌, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ପ୍ରବୁଦି ସିକିୟା ୱେନ୍‌ଜି କାବାଆତା ମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ପାଉଲ ନି ୱାନି ସାଙ୍ଗର୍‌ ପାଫଦାନ୍‍ ଗାଡାନାସି ପାମ୍ଫିଲିଆଦି ପର୍ଗା ଦର୍‌ତି ଉନ୍‍ଣ୍ତ୍ରି ଗାଡ଼୍‌ତୁ ଇତାର୍‌ । ଜୋହନ ମାର୍କ ୱାରିଙ୍ଗ୍‌ ଇୟାବାନୁ ଡ଼ିସ୍‌ସି ଜିରୁସାଲାମ୍‍ତୁ ଡ଼େସିସର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ୱାର୍‌ ପର୍ଗାଦାନ୍‍ ସଲ୍‍ସି ପିସିଦିଆଦି ଆଣ୍ଟିୟକଦୁ ଇତାର୍‌ ମାରି ରମ୍‍ନିଦିନ୍‍ ପାର୍‌ତନା ଇଲୁଦୁ ସଲ୍‍ସି ବାସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ମାରି ମସାଦି ନିୟମ୍‌ ମାରି ବାବବାଦିରି ମାଣାନ୍‌ ରାସ୍‌ତିକା ପଡ଼ାତି ୱେନ୍‌କା, ପାର୍‌ତନା ଇଲ୍‍ତି ପେରିକାର୍‌ ୱାରି ଲାକ୍‌ତୁ ଇୟା ମାଟା ଇଜି ପକ୍‌ତାର୍‌, “ତଡ଼ାନ୍‌କୁ, ଜଦି ଲୋକାଙ୍ଗ୍‌ ୱେଡ଼ିକାକିନି ୱାଜା ମି ଇନି ଉପଦେସ୍‍ ସିନିକା ମାନାତ୍‌, ଆର୍‍ତିଙ୍ଗ୍‍ଁ ଇନ୍‍ଡ୍ରୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ପାଉଲ ନିଲ୍‍ଜି ଲୋକାଙ୍ଗ୍‌ ଆଲେଜ ମାନ୍‌ଡ଼୍ରେଙ୍ଗ୍‌ ଇଜି କିୟୁ ଜୁଟ୍‍ସି ଇର୍ହାନ୍‌ : ଉଣ୍ତାତିମାନି ଇସ୍ରାଏଲ୍‌ତି ତଡ଼ାନ୍‌କୁ ନି ମାପୁରୁଙ୍ଗ୍‍ଁ ପାର୍‌ତାନା କିଜିମାନି ଅଣଜିହୁଦିର୍‍, ନା ମାଟା ୱେନ୍‌ଡ୍ରୁ ! ");
INSERT INTO kfcp_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ଇସ୍ରାଏଲ୍‌ ଲୋକା ମାପୁରୁ ମା ଡକାରାଦାଦାରିଙ୍ଗ୍‍ଁ ବାସେକିତାନ୍‍ ମାରି ମିସର୍‍ତୁ ୱାର୍‌ ଆଇ ଦେସ୍‌ତିକାର୍‍ ୱାଜା ବାସାଜି ମାର୍‍ହି ସମୟତୁ ଉନ୍‍ଣ୍ତ୍ରି ପେରି କୁଟୁମ୍‌ତୁ ମିସା କିତାର୍‌ । ମାପୁରୁ ୱାନି କାବାଆନି ସାକ୍ତିଦାନ୍ ୱାରିଙ୍ଗ୍‍ଁ ମିସରତାନ୍‍ ସପ୍‍ସି ତାତାନ୍‍, ");
INSERT INTO kfcp_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ମାରି ସାଲିସ୍‌ ବାର୍‍ସେକ୍‍ ସାନ୍ଦି ମରୁବୁମିଦୁ ୱାରି ତାଗ୍‌ଇ ତାନିଙ୍ଗ୍‌ ସାସ୍‌ କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ମାରି, ୱାନ୍‌ କିଣାନ୍‍ ଦେସ୍‌ତୁ ସାତଗୋଟା କୁଟୁମ୍‌ତିଙ୍ଗ୍‍ ଦଂସ କିଜି ବାସେକିତି ଲୋକାଙ୍ଗ୍‌ ଆୟା ଦେସ୍‌ ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ପୁରା ସାରିସ ପଚାସ୍‌ ବାର୍‍ସେକ୍‍ ଲୋଇ ଇୟାୱିଜୁ ଗଟନା ଗଟାତାମାର୍ହାତ୍‍ । ଇୟା ୱେନ୍‌କା ସାମୁଏଲ୍‍ ବାବବାଦିଦି ସମୟ ସାନ୍ଦି ମାପୁରୁ ୱାରି ମୁସ୍‌କୁ ବିସାର୍‌ କିନିୱାରିଙ୍ଗ୍‍ ଆସ୍‌କିତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ଏସ୍ତିୱାଲେ ୱାର୍‌ ଅରେନ୍‌ ରାଜାଦିଙ୍ଗ୍‌ ବଦା କିତାର୍‍, ମାପୁରୁ ୱାରି ମୁସ୍‌କୁ ସାଲିସ୍‍ ବାର୍‍ସେକ୍‍ ସାନ୍ଦି ସାସନ୍ କିନି ଉଣ୍ତିଙ୍ଗ୍‍ଁ ବିନ୍ୟାମିନ୍ କୁଟୁମ୍‌ତି କିଶତି ମାରିସି ସାଉଲତିଙ୍ଗ୍‍ଁ ଆସ୍‌କିତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ତାନିୱେନ୍‍କା ମାପୁରୁ ୱାନିଙ୍ଗ୍‌ ରାଜାଗାଦିଦାନ୍‍ ସପ୍‍ସି ଦାଉଦତିଙ୍ଗ୍‍ଁ ୱାରି ରାଜା କିତାନ୍‌ । ମାପୁରୁ ୱାନି ବିସୟ୍‌ତାନ୍‌ ସାକିୟ୍‌ ଇର୍ହାମାର୍ହାନ୍‌, ନାନ୍ ଏମେନାନି ଲୋକାଙ୍ଗଁ ଜିବନ୍‌ନନା, ଜେସିଦି ମାରିସି ଦାଉଦ ଆୟାନାନି ଅରେନ୍‌; ୱାନ୍‌ ନା ବଦାଦାନ୍ ୱିଜୁ ପାଣି କିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ଇୟା ଦାଉଦ କୁଟୁମ୍‌ତି ଜିସୁଙ୍ଗୁଁ ମାପୁରୁ ୱାନି ପାର୍‌ମାଣ୍‌ ଇସାବ୍‍ତାନ୍‍ ଇସ୍ରାଏଲ୍‌ ଜାତିଦି ରକିୟାକର୍ତ୍ତା କିତାମାନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ଜିସୁ ୱାନି ପାଣି ଆରାମ୍‌ କିନି ଆଗ୍‌ଡ଼ିରାନ୍‌ ଜୋହନ ଇସ୍ରାଏଲ୍‌ତି ୱିଜୁ ଲୋକା ଲାକ୍‌ତୁ ପ୍ରଚାର୍‌ କିଜି ଇର୍ହାନ୍‌, ୱାରିଙ୍ଗ୍‍ଁ ପାପ୍‌ତାନ୍‌ ମନ୍ ଡ଼େପ୍‍ସି ଡୁବନ୍‌ ଅନିକା ମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ମାରି ଜୋହନ ୱାନି ସେବା ପାଣି ସେସ୍‍ କିନି ଆଗ୍‌ଡ଼ି ଲୋକାଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, ନା ବିସୟ୍‌ତାନ୍‌ ମି ଅଡ଼୍‍ବିନିକା ଇନିକା ? ମିର୍‌ ଆମାୱାନିଙ୍ଗ୍‍ଁ କାପ୍‍କିଜିନିଦେର୍‌, ନାନ୍ ଆକାନ୍‍ ଆଏ । ମାତର୍‌ ୱେନ୍‌ଡ୍ରୁ ! ନା ୱେନ୍‌କା ଏନ୍‌ ୱାଜିନାନ୍‍, ନାନ୍ ୱାନି ପାଦାମ୍‍ତି ଜୁତେଙ୍ଗ୍‌ତି ଗାଟି କୁତ୍‌ତେଙ୍ଗ୍‌ ବା ନାନ୍ ଜଗ୍‌ ସିଲେ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“ଅବ୍ରାହାମ କୁଟୁମ୍‌ତି ଏ ଇସ୍ରାଏଲ୍‌ ତଡ଼ାନ୍‌କୁ ମାରି ମାପୁରୁଙ୍ଗ୍‍ଁ ପାର୍‌ତାନା କିଜିମାନି ଇବେମାନି ଅଣଜିହୁଦି ଲୋକୁ, ମାଙ୍ଗିଁ ନେ ଇୟା ପରିତ୍ରାଣଦି ମାଟା ସିଆୟ୍‍ ଆତାମାନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ମାତର୍‌ ୱାନ୍‌ ରକିୟାକର୍ତ୍ତା, ଜିରୁସାଲାମ୍‌ତୁ ତେବାଜି ମାନିକାର୍‌ ମାରି ୱାରି ନେତାର୍‌ ଆକା ନେସ୍‌ଏର୍‌ ମାର୍ହାର୍‌ । ୱାର୍‌ ୱିଜୁ ରମ୍‍ନିଦିନ୍‍ତୁ ପଡ଼ାଜି ମାନି ବାବବାଦିରି ମାଟାଦି ଅର୍ତ ବୁଜାଏଜି ମାର୍ହାର୍‌ । ଆରିଙ୍ଗ୍‍ଁବା ଜିସୁଙ୍ଗୁଁ ଦୋସ୍‌ କିଜି ୱାର୍‌ ବାବବାଦିରି ବାକ୍ୟଦିଙ୍ଗ୍‍ଁ ପୁରା କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ସାନିଦଣ୍ତତି ଇନି ନିନ୍ଦାଦି ମାଟା ପୟ୍‍ଏନ୍‍ଣ୍ତା ବା ୱାନିଙ୍ଗ୍‍ଁ ସାନିଦଣ୍ତ୍‍ ସିଦେଙ୍ଗ୍‌ ଇଜି ୱାର୍‌ ପିଲାତ୍‌ ରାଜେଙ୍ଗ୍‍ଁ ଇର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ୱାନି ବିସୟ୍‌ତାନ୍‌ ଦାର୍ମୁସାସ୍ତ୍ରଦୁ ଏମେ ୱିଜୁ ବିସୟ୍‌ ରାସାତାମାନାତ୍‌, ଆୟାଇସାବ୍‍ତାନ୍‍ ୱିଜୁ ପାଣିକିତି ୱେନ୍‌କା ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ କ୍ରୁସଦାନ୍ ରେପ୍‍ସି ତାସି ଉନ୍‌ଡ୍ରି ଦୁକିଗୁଟାଦୁ ଇଟ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ମାତର୍‌ ମାପୁରୁ ୱାନିଙ୍ଗ୍‍ଁ ସାତିମାଣାନ୍‌ ନିକ୍‍ତାନ୍‍, ");
INSERT INTO kfcp_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ନାଣ୍ତ ଦିନ୍‌ ସାନ୍ଦି ୱାନି ୱାଲେ ଗାଲିଲିଦାନ୍‌ ଜିରୁସାଲାମ୍‍ତୁ ସନି ୱାନିକା ଆଜିମାନି ଲୋକାଙ୍ଗ୍‌ ୱାନ୍‌ ତରାୟ୍‍ଆତାନ୍‍ । ଇଲେଇ ୱାର୍‌ ଇସ୍ରାଏଲ୍‌ ଲୋକା ଲାକ୍‌ତୁ ୱାନି ସାକି । ");
INSERT INTO kfcp_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ମାରି, ମାପୁରୁ ମା ଡକ୍ରାଦାଦାରିମାନୁ କିତି ପାର୍‌ମାଣ୍‌ ବିସୟ୍‌ତାନ୍‌ ମାପ୍‌ ମିଙ୍ଗିଁ ଇୟା ନେଗିକାବୁର ୱେର୍‍ସିନାପ୍‍, ");
INSERT INTO kfcp_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ମାପୁରୁ ଜିସୁଙ୍ଗୁଁ ନିକ୍‍ସି ୱାରି ମାରିସି ଜେ ମାଡ୍‌, ମା ଉଣ୍ତିଙ୍ଗ୍‍ଁ ଆୟା ପାର୍‌ମାଣ୍‌ ପୁରାକିତାମାନାନ୍‍, ଏଣ୍ତେସ୍‌ ଗିତ ସଂହିତାଦି ମାରିଉନ୍‌ଡ୍ରି ପାଟାଦୁ ଇୟା ମାଟାଦିଙ୍ଗ୍‌ ୱେର୍‌ସି ରାସାତାମାନାତ୍‌, “ନିନ୍‌ ନା ମାରିନ୍‌, ନେର୍‌ ନାନ୍ ମି ବୁବା ଆତାମାନା ।” ");
INSERT INTO kfcp_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ମାରି ଦୁକିଦୁ ସାବ୍‍ଦେଙ୍ଗ୍‍ଁ ଡ଼ିସ୍‍ଏନ୍‍ଣ୍ତା ୱାନିଙ୍ଗ୍‍ଁ ସାତିମାଣାନ୍‌ ନିକ୍‍ତେଙ୍ଗ୍‍ଁ ଇଜି ମାପୁରୁ ଇୟା ମାଟା ଇର୍ହାମାର୍ହାନ୍‌; ଦାଉଦତିଙ୍ଗ୍‍ଁ ସିତିମାନି ପାର୍‌ମାଣ୍‌ ଇସାବ୍‌ତାନ୍‌ ନାନ୍ ନିଙ୍ଗିଁ ପବିତ୍ର ନି ସତ୍‌ତି ଆସିର୍ବାଦ୍‌ ଦାନ ସିନା । ");
INSERT INTO kfcp_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ସାସ୍ତ୍ରଦୁ ମାରି ଉଣ୍ତ୍ରି ବାଡିଦୁ ରାସାତାମାନାତ୍‌, ନିନ୍‌ ନିଜେଦି ବିସ୍‍ବାସ୍‍ତାନ୍‌ ସେବାକିନିୱାନିଙ୍ଗ୍‌ ଦୁକିଦୁ ସାବ୍‍ଦେଙ୍ଗ୍‍ଁ ଡ଼ିସ୍‌ସୋ ସିଇ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","ଦାଉଦ ୱାନି ସାସନ୍ କିନିୱାଲେ ମାପୁରୁଦି ବଦା ପୁରାକିଜି ସାରାସାରି ସାତାନ୍‍ ମାରି ଡକ୍ରାଦାଦ୍‍ସିୱାଲେ ମୁସାୟ୍‍ଆତାନ୍‍ । ୱାନି ମେନ୍ଧଲ୍‍ ଦୁକିଦୁ ସାବିତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ମାତର୍‌ ମାପୁରୁ ଆମାୱାନିଙ୍ଗ୍‍ଁ ସାତିମାଣାନ୍‌ ନିକ୍‍ତାନ୍‍, ୱାନ୍‌ ସାବ୍‍ଏନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ମାରି, ଏ ତଡ଼ାନ୍‌କୁ, ମିର୍‌ ଇକା ନେସ୍‌ତୁ ଜେ, କେବଲ ମୋସାଦି ମାଣାନ୍‌ ମି ଲାକ୍‌ତୁ ପାପ୍‌ କେମାଦି ସୁସମାଚାର୍‌ ପ୍ରଚାର୍‌ ଆଜିନାତ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ମାରି, ମସାଦି ନିୟମ୍‍ତାନ୍‍ ଏମେ ୱିଜୁ ବିସୟ୍‌ତାନ୍‌ ମିର୍‌ ମୁକ୍‍ଡ଼ାଜି ଦାର୍ମୁ ଲୋକୁ ଆଦେଙ୍ଗ୍‌ ଆଟ୍‍ଇତିଦେର୍‍, ବିସ୍‍ବାସ୍‍କିନି ୱିଜେରେ ଲୋକୁ ଜିସୁଦି ମାଣାନ୍‌ ଆୟାୱିଜୁ ବିସୟ୍‌ତାନ୍‌ ମୁକ୍‍ଡ଼ାଜି ଦାର୍ମୁ ଲୋକୁ ଆଦେଙ୍ଗ୍‍ଁ ଆଟ୍‌ନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ଜାଗାର୍‌ତା, ବାବବାଦିର୍ ଆମାକା ଇର୍ହାମାନାର୍‌, ଆକା ଏଣ୍ତେସ୍‌ ମି ଉଣ୍ତିଙ୍ଗ୍‍ଁ ଗଟାଏତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","ଏ ମାନାଇଲୋକ୍‍ ! ମିର୍‌ କଲବଲ୍‌ ଆଜି ସାଦୁ ! ଇରିଙ୍ଗ୍‌ ନାନ୍ ନେର୍‌ ଏମେ ପାଣି କିଜିନା, ଏନ୍‌ ଆକା ବୁଜା କିଜି ସିତିଙ୍ଗ୍‌ ବା ମିର୍‌ ବିସ୍‌ବାସ୍‌ କିଇଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ପାଉଲ ନି ବର୍ଣ୍ଣବା ପାର୍‌ତନା ଇଲୁ ଡ଼ିସ୍‌ସି ସନିୱାଲେ, ମାରିଉନ୍‍ଣ୍ତ୍ରି ରମ୍‍ନିଦିନ୍‍ ଡ଼େସିୱାଜି ଇୟାୱିଜୁ ବିସୟ୍‌ତାନ୍‌ ମାରି ନାଣ୍ତ ବୁଜାକିଦେଙ୍ଗ୍‍ଁ ଇଜି ୱାରିଙ୍ଗ୍‍ଁ ଲୋକୁ କୁକ୍‍ତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ଲୋକୁ ମିଟିଙ୍ଗ୍‌ଁ ଡ଼ିସ୍‌ସି ସର୍ହି ୱେନ୍‍କା ନାଣ୍ତ ଜିହୁଦି ନି ଜିହୁଦି ଦର୍ମଦି ଲୋକୁ ଅଣଜିହୁଦିର୍‍ ପାଉଲ ନି ବର୍ଣ୍ଣବାଦି ୱାଲେ ସର୍ହାର୍‍, ସିସୁର୍‍ ୱାରିୱାଲେ ମିସାଜି ମାପୁରୁଦି ଦୟାଦାନ୍‍ ଜିବନ୍‌ କାଟେ କିଦେଙ୍ଗ୍‌ ୱାରିଙ୍ଗ୍ଁ ୱେଡ଼ିକା ସିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ୱେନ୍‌କାରି ରମ୍‌ନି ଦିନ୍‍ତୁ ଗାଡ଼୍‌ତି ୱିଜେରେ ପ୍ରବୁଦି ବାକ୍ୟ ୱେନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ଇଜି ଉଣ୍ତାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ଲୋକୁଗହଲି ସୁଡ଼୍‌ଜି ଜିହୁଦିର୍‌ ରିସାଆତାର୍‍ ମାରି ପାଉଲତି ମାଟାଦୁ ଜିଦ୍‌ କିଜି ୱାନିଙ୍ଗ୍‍ଁ ନିନ୍ଦା କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ମାତର୍‌ ପାଉଲ ନି ବର୍ଣ୍ଣବା ମାରି ନାଣ୍ତ ଆଟ୍‍ୱାଦାନ୍‍ ଇର୍ହାର୍‌, ମି ଲାକ୍‌ତୁ ପାର୍‌ତୁମ୍‌ ମାପୁରୁଦି ବାକ୍ୟ ପ୍ରଚାର୍‌ ଆନିକାମାର୍ହାତ୍‍ । ମାତର୍‌ ମିର୍‌ ଏସାଙ୍ଗ୍‌ୱିଜ୍‍ଇ ଜିବନ୍‌ ପୟ୍‍ଦେଙ୍ଗ୍‍ଁ ଇଜି ନିଜେଦିଙ୍ଗ୍‍ଁ ଜଗ୍‌ ସିଲିକା ଅଡ଼୍‍ବିଜି ତେନିଙ୍ଗ୍‍ଁ ବିସାର୍‌ କିତିମାନିଙ୍ଗ୍‍ଁ, ମାପ୍‌ ମିଙ୍ଗିଁ ଡ଼ିସ୍‌ସି ଅଣଜିହୁଦିରି ମାନୁ ସନାପ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ଇରିଙ୍ଗ୍‍ଁ ପ୍ରବୁ ମାଙ୍ଗିଁ ଇୟା ମାଟା ସିତାମାନାନ୍‌ : ନାନ୍ ମିଙ୍ଗିଁ ଅଣଜିହୁଦିରି ଉଣ୍ତିଙ୍ଗ୍‍ଁ ଜାୟ୍‌ ୱାଜା କିତାମାନା, ଏଣ୍ତେସ୍‌ ୱିଜୁ ଦୁନିଆ ରକିୟା ପୟ୍‌ନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ଅଣଜିହୁଦିର୍‍ ଇକା ୱେନ୍‌ଜି ୱେଡ଼ିକା ଆତାର୍‌ ମାରି ପ୍ରବୁଦି ମାଟା ଉଣ୍ତିଙ୍ଗ୍‍ଁ ଦନ୍ୟବାଦ୍‌ ସିତାର୍‍ । ଏମେକାର୍‌ ଏସାଙ୍ଗ୍‌ୱିଜ୍‍ଇ ଜିବନ୍‌ ଉଣ୍ତିଙ୍ଗ୍‍ଁ ବାସେଆତାମାର୍ହାର୍‍, ୱାର୍‌ ଆୟା ମାଟାଦୁ ବିସ୍‌ବାସ୍‌ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ଆୟା ରାଜିଦି ୱିଜୁ ବାଡିଦୁ ପ୍ରବୁଦି ବାକ୍ୟ ୱେଙ୍ଗିଁତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ମାତର୍‌ ଜିହୁଦିର୍‌ ଗାଡ଼୍‌ତି ପେରି ଲୋକାଙ୍ଗ୍‌ ୱେରିସ୍‍କିଜି ପାଉଲ ନି ବର୍ଣ୍ଣବାଦି ମୁସ୍‌କୁ କାସ୍ଟୁ ସିଦେଙ୍ଗ୍‍ ଆସ୍‌ତାର୍‌ ମାରି ଆୟା ରାଜିଦାନ୍‌ ୱାରିଙ୍ଗ୍‍ଁ ସପ୍‌ତା ପେରିତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ପ୍ରେରିତ ସିସୁର୍‍ ଆୟା ଲୋକା ବିରଦ୍‌ତାନ୍‌ ୱାରି ପାଦାମ୍‌ତି ଦୁଡ଼ି ସାଡ଼୍‍ସି ସିଜି ଇକନିୟାଦୁ ସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ଆଣ୍ଟିୟକଦି ବିସ୍‍ବାସିର୍‍ ପବିତ୍ର ଆତ୍ମା ନି ୱେଡ଼ିକାଦୁ ପୁରା ଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ଇକନିୟାଦୁ ଆୟା ଗଟନାଦି ବିସୟ୍‌ ମାରିଡ଼େସି ଆତାତ୍‌ : ପାଉଲ ନି ବର୍ଣ୍ଣବା ପାର୍‌ତନା ଇଲୁଦୁ ସଲ୍‍ସି ଇୟାୱାଜା ପ୍ରଚାର୍‌ କିତାନ୍‌ ଜେ ନାଣ୍ତ ଜିହୁଦି ଲୋକୁ ନି ଅଣଜିହୁଦିର୍‍ କ୍ରିସ୍ତଦିମାନୁ ବିସ୍‌ବାସ୍‌ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ମାତର୍‌ ଅବିସ୍‍ବାସି ଜିହୁଦିର୍‌ ଅଣଜିହୁଦିରିଙ୍ଗ୍‌ ବେମ୍‌ରି କିଜି ତଡ଼ାନ୍‌କା ବିରଦ୍‌ତାନ୍‌ ମନ୍‌ତିଙ୍ଗ୍‍ ଏଗ୍ରିସ୍‌କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ଆତିଙ୍ଗ୍‍ବା ପ୍ରେରିତ ସିସୁର୍‍ ପ୍ରବୁଦି ବିସୟ୍‌ତାନ୍‌ ଆଟ୍‍ୱାଦାନ୍‍ ପ୍ରଚାର୍‌ କିଜି ନାଣ୍ତ ଦିନ୍‌ ଆବେ ତେବାତାର୍‌ । ସାକ୍ତିଦି ପାଣି ନି କାବାଆନି ପାଣିୱିଜୁ କିନି ମାଣ୍‌କୁ ୱାର୍‌ ପାର୍‌ମାଣ୍‌ କିତାର୍‍ ଜେ, ମାପୁରୁଦି ଦୟା ବିସୟ୍‌ତାନ୍‌ ୱାରି ପ୍ରଚାର୍‌ ଆତି ମାଟା ସତ୍‍ତାନ୍‍ ସତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ଗାଡ଼୍‌ତି ଲୋକୁ ରୁଣ୍ତି ଦଲ୍‍ତୁ ବାଗ୍ ଆତାର୍‌ । ୱାରି ଲୋଇ ଏସ ଲୋକୁ ଜିହୁଦିରିଙ୍ଗ୍‍ଁ ନି ମାରି ଏସ ପ୍ରେରିତ ସିସୁରିଙ୍ଗ୍‌ ମାନେଆତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ତାନିୱେନ୍‍କା ଏସ ଅଣଜିହୁଦିଲୋକ୍‍ ନି ଜିହୁଦିଲୋକୁ ୱାରି ନେତାର୍‌ରି ୱାଲେ ଏକ୍‍ଜୁଟ୍‍ ଆଜି ପ୍ରେରିତ ସିସୁରି ଉଣ୍ତିଙ୍ଗ୍‍ଁ ତାଗ୍‌ଇ ବ୍ୟବହାର୍‌ କିନି ଉଣ୍ତିଙ୍ଗ୍‍ଁ ନି ୱାରିଙ୍ଗ୍‍ଁ କାଲ୍‍କାଣ୍‍ ଡାକ୍‍ସି ସାପିସ୍‌ କିଦେଙ୍ଗ୍‍ଁ ଇଜି ୱାର୍‌ଗିସାଜି ତିର୍‌ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ପ୍ରେରିତ ସିସୁର୍‍ ଇୟା ବିସୟ୍‌ତାନ୍‌ ନେସ୍‍ତେଙ୍ଗ୍‍ଁ ଆଟ୍‍ସି ଲୁକାନିଆଦି ଲୁସ୍ତ୍ରା ନି ଦର୍ବି ଗାଡ଼୍‌ତୁ ମାରି ଆୟା ସାରିବେଡ଼୍‍ତି ମାନି ରାଜିଦୁ ଉର୍‍କ୍‌ତାର୍‍, ");
INSERT INTO kfcp_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ମାରି ଆବେ ନେଗିକାବୁର୍‌ ପ୍ରଚାର୍‌ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ଲୁସ୍ତ୍ରାଦୁ ଅରେନ୍‌ ଜନମ୍‍ତାନ୍ ସଟାଲୋକ୍‌ ମାର୍ହାନ୍‍ । ୱାଦ୍‌ ଅଡ଼ପ୍‍ବା ବୁଲାଦେଙ୍ଗ୍‍ଁ ଆଟ୍‌ଏଜି ମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ଆବେ ବାସ୍‌ସି ୱାନ୍‌ ପାଉଲ୍‍ତି ସିକିୟା ୱେନ୍‌ଜି ମାର୍ହାନ୍‍ । ୱାନି ମନ୍‌ତୁ ବିସ୍‌ବାସ୍‌ ଆତାତ୍‌ ମାରି ୱାନ୍‌ ନେଗେନ୍‍ ଆନାନ୍‌ ଇଜି ପାଉଲ ନେସ୍‍ତେଙ୍ଗ୍‍ ଆଟ୍‍ତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ଆଦେଙ୍ଗ୍‍ଁ ୱାନି ତରିନ୍‌ ସିଦା ସୁଡ଼୍‌ଜି ପାଉଲ ନାଣ୍ତ ଆଉଲିଦାନ୍‍ ଇର୍ହାନ୍‌, “ପାଦାମ୍‍ତାନ୍‌ ସାହାସ୍‍ଆଜି ସିଦା ନିଲ୍‍ଆ !” ଆକାନ୍‍ ଗାତ୍‍ସି ସାରିବେଡ଼୍‍ତି ବୁଲାଦେଙ୍ଗ୍‍ଁ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ଉଣ୍ତାତିମାର୍ହି ଲୋକୁ ପାଉଲତି ଇୟା ପାଣି ସୁଡ଼୍‌ଜି ୱାରି ଲୁକାନିଆ ବାସାଦାନ୍‍ ଆଉଲି ଆଜି ଇନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ଆସ୍‌ତାର୍‌, “ଦିୟାମ୍‍କୁ ଲୋକୁ ବେସ୍‍ତାନ୍‍ ମାବାନୁ ୱାତାମାନାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ୱାର୍‌ ବର୍ଣ୍ଣବାଦିଙ୍ଗ୍‍ଁ ଜିଅସ୍‍ ମାରି ପାଉଲ ପେରିକାନ୍‌ ମାନିଙ୍ଗ୍‌ ୱାନିଙ୍ଗ୍‍ ହେରମିସ୍‍ ଇର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ଗାଡ଼୍‌ତି ଆତ୍‌ରେ ମାନି ଜିଅସ୍‍ ମନ୍ଦିର୍‌ତି ପୁଜାରି, ସେର୍‍ଲା ଲାକ୍‌ତୁ ଏସ ସଣ୍ତଙ୍ଗ୍‌ଁ ନି ପୁଙ୍ଗୁଁ ତାତାନ୍‍, ଇରିଙ୍ଗ୍‌ ୱାନ୍‌ ମାରି ଆବେ ଉଣ୍ତାତିମାର୍ହି ଲୋକୁ ପ୍ରେରିତ ସିସୁରି ଉଦେସ୍‍ତାନ୍‍ ପୁଜା ସିଦେଙ୍ଗ୍‌ ଇଜି ବଦାକିତା ମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ୱାର୍‍ ଏମେ ପାଣି କିଦେଙ୍ଗ୍‍ଁ ସଲ୍‍ସିମାର୍ହାର୍‍, ସିସୁର୍‍ ଅର୍ତାତ୍‍ ବର୍ଣ୍ଣବା ନି ପାଉଲ ଆକା ୱେର୍‍ଇଦାପ୍ରେ ନିଜେଦି ଆଙ୍ଗିଁଙ୍ଗ୍‌ କିସ୍‍ତା ପକ୍‌ତାର୍‌, ଲୋକା ଲୋଇ ଉର୍‍କିସି ସଲ୍‍ସି ଆଉଲି ଆଜି ଇର୍ହାର୍‌, ");
INSERT INTO kfcp_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“ମିର୍‌ ଏନ୍ଦା ଇକା କିଜିନିଦେର୍‌ ? ମାପ୍‌ ମି ୱାଜା ଲୋକୁ ମାତର୍‌ । ମି ଲାକ୍‌ତୁ ନେଗି କାବୁର୍‌ ପ୍ରଚାର୍‌ କିଦେଙ୍ଗ୍‍ଁ ଇଜି ମାରି ଇୟା ଅସାର୍ ବିସୟ୍‌ତାନ୍‌ ସୁପ୍‍ ଆଜି, ବାଦଡ଼୍‍, ଦୁନିଆ, ସାମ୍‌ଦୁର୍‌ ନି ଆବେମାନି ୱିଜୁ ବିସୟତି ତିଆର୍‍କିତି ଜିବନ୍‍ମାନି ମାପୁରୁଦି ତରିନ୍‌ ମିଙ୍ଗିଁ ଅତେଙ୍ଗ୍‍ଁ ଇଜି ମାପ୍‌ ଇବେ ୱାତାମାନାପ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ଆଗ୍‌ଡ଼ି ନିଜେଦିବଦାଦାନ୍‍ ନିଜେଦି ସାରିଦୁ ସନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ଇଜି ମାପୁରୁ ଲୋକାଙ୍ଗ୍‌ ଡ଼ିସ୍‍ତା ସିତାମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ମାତର୍‌ ୱାନି ୱିଜୁ ନେଗି ପାଣିଦାନ୍‌ ୱାନ୍‌ ୱିଜୁଦିନ୍‌ ୱାନି ୱିଜୁଦିନ୍‍ମାନି କାବୁର୍‌ ସିତାମାନାନ୍‌; ୱାନ୍‌ ବାଦଡ଼୍‍ତାନ୍‍ ପିର୍‍ରୁ ମାରି ଟିକ୍‌ ୱେଡ଼ାଦୁ ପାସି ସିନାନ୍‍, କାଦି ଜଗେକିନାନ୍‍ ମାରି ୱେଡ଼ିକାଦାନ୍‌ ମି ଜିବନ୍‌ ପୁରା କିନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ଇୟାୱିଜୁ ମାଟା ଇନ୍‌ଜି ପ୍ରେରିତ ସିସୁର୍‍ ଏଣ୍ତେସ୍‍କିଜିବା ପୁଜା ସିନିମାଣାଟ୍‍ ୱାରିଙ୍ଗ୍‍ଁ ତେବାକିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ପିସିଦିଆଦି ଆଣ୍ଟିୟକ ନି ଇକନିୟାଦାନ୍‍ ଏସ ଜିହୁଦି ଲୋକୁ ୱାତାମାର୍ହାର୍‍, ୱାର୍‌ ଲୋକାଙ୍ଗ୍‌ ଏଗ୍ରିସ୍‌କିଜି ପାଉଲତିଙ୍ଗ୍‍ଁ କାଲ୍‌କାଣୁକୁ ଡାକ୍‍ତାର୍‍ ମାରି ୱାନିଙ୍ଗ୍‍ଁ ସାତାନ୍‍ ଇଜି ଅଡ଼୍‍ବିଜି ଗାଡ଼୍‌ତି ଆତ୍‌ରେ ରେଲ୍‌ଜି ଅତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ମାତର୍‌ ସିସୁର୍‍ ୱାଜି ୱାନି ସାରିବେଡ଼୍‍ତି ଉଣ୍ତାଜି ନିର୍ହି ୱେନ୍‌କା ୱାନ୍‌ ନିଙ୍ଗିଁଜି ଗାଡ଼୍‌ତୁ ଡ଼େସିସର୍ହାନ୍‍ । ମାରିନାଣ୍ତିଙ୍ଗ୍‍ଁ ୱାନ୍‌ ନି ବର୍ଣ୍ଣବା ଦର୍ବିଦୁ ସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ପାଉଲ ନି ବର୍ଣ୍ଣବା ଦର୍ବିଦୁ ସୁସମାଚାର୍‌ ପ୍ରଚାର୍‌ କିଜି ନାଣ୍ତ ସିସୁରିଙ୍ଗ୍‌ ଲାବ୍‍ କିତାର୍‍ । ତାନିୱେନ୍‍କା ୱାର୍‌ ଲୁସ୍ତ୍ରା, ଇକନିୟା ନି ପିସିଦିଆଦି ଆଣ୍ଟିୟକଦୁ ଡ଼େସିସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ୱାର୍‌ ବିସ୍‍ବାସିରିଙ୍ଗ୍‍ଁ ନିଜେଦି ବିସ୍‌ବାସ୍‌ତୁ ଡାଟ୍‌ତାନ୍‌ ମାନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ଇଜି ମନ୍‌ତିଙ୍ଗ୍‍ ୱେଡ଼ିକା କିବିସ୍‍କିତାର୍‍ । ୱାର୍‌ ସିକିୟା ସିଜି ଇର୍ହାର୍‌, “ମାପୁରୁଦି ରାଜିଦୁ ଡ଼ୁଗ୍‍ଦେଙ୍ଗ୍‍ଁ ଇଜି ମାଙ୍ଗିଁ ନାଣ୍ତ କାସ୍ଟୁଦୁକୁ ବା ସିଜି ସନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ଆନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ୱିଜୁ ମଣ୍ତଲିଦୁ ୱାର୍‌ କିକୁ ଇଡ୍‌ଜି ମଣ୍ତଲିଦି ପେରି ନେତାର୍‍ରିଙ୍ଗ୍‌ ବାସେ କିତାର୍‍ ମାରି ଏମେ ପ୍ରବୁଦିମାନୁ ୱାର୍‌ ବିସ୍‌ବାସ୍‌ କିତାମାର୍ହାର୍‍, ପାର୍‌ତନା ନି ଉପବାସତି ୱାଲେ ୱାରିଙ୍ଗ୍‍ଁ ଆୟା ପ୍ରବୁଦି ଲାକ୍‌ତୁ ସର୍ପେ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ପିସିଦିଆ ରାଜି ସିଜି ୱାର୍‌ ପାମ୍ଫିଲିଆଦୁ ୱାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ଆବେ ପର୍ଗାଦୁ ପ୍ରଚାର୍‌ କିଜି ଆତ୍ତାଲିଆଦୁ ସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ଆବେଟ୍‌କୁ ୱାର୍‌ ଜାହାଜ୍‌ତାନ୍‌ ଆଣ୍ଟିୟକଦୁ ଡ଼େସି ୱାତାର୍‌ । ଇୟା ଆଣ୍ଟିୟକଦୁ ଇଲେଇ ଆତି ମାନି ପାଣି ଉଣ୍ତିଙ୍ଗ୍‍ଁ ମାପୁରୁଦି ଦୟା ଦାନ୍‌ ୱାର୍‌ ସର୍ପେ ଆତାମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ୱାର୍‌ ଆଣ୍ଟିୟକଦୁ ଇଜି ମଣ୍ତଲିଦି ଲୋକାଙ୍ଗ୍‌ ଉଣ୍ତାକିତାର୍‍ । ମାପୁରୁ ୱାରି ଉଣ୍ତିଙ୍ଗ୍‍ଁ ଆମା ୱିଜୁ କିତାମାର୍ହାନ୍‌ ମାରି ଅଣଜିହୁଦିରି ବିସ୍‌ବାସ୍‌ ଉଣ୍ତିଙ୍ଗ୍‍ଁ ଏଣ୍ତେସ୍‌ ସାରି ରେତା ସିତାମାର୍ହାନ୍‍, ଆୟାୱିଜୁ ୱାରିଙ୍ଗ୍‍ଁ ୱେର୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ଆବେ ବିସ୍‍ବାସିରି ୱାଲେ ୱାନ୍‌ ନାଣ୍ତ ଦିନ୍‌ ସାନ୍ଧି ତେବାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ଜିହୁଦାଦାନ୍‍ ଏସ ଲୋକୁ ଆଣ୍ଟିୟକଦୁ ୱାଜି, ମୋସାଦି ନିୟମ ଇସାବ୍‌ତାନ୍‌ ୱାର୍‌ ସୁନ୍ନତ ଆଏତିଙ୍ଗ୍‍ଁ ରକିୟା ପୟ୍‍ଦେଙ୍ଗ୍‍ଁ ଆଟ୍‍ଏର୍‍ ଇଜି ବିସ୍‍ବାସ୍‌ତି ତଡ଼ାନ୍‌କାଙ୍ଗ୍‌ ସିକିୟା ସିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ଇୟା ବିସୟ୍‌ତାନ୍‌ ୱାରି ୱାଲେ ପାଉଲ ନି ବର୍ଣ୍ଣବା ନାଣ୍ତ ଆସ୍‌ସିସାତାର୍‌ ଆକା, ଇକା ତିର୍‌ ଆତାତ୍‍ଜେ, ପାଉଲ, ବର୍ଣ୍ଣବା ମାରି ଆଣ୍ଟିୟକଦି ମାରି ଏସ ଲୋକୁ ଜିରୁସାଲାମ୍‍ତୁ ସଲ୍‍ସି ପ୍ରେରିତ ସିସୁର୍‍ ନି ମଣ୍ତଲିଦି ନେତାର୍‍ରି ୱାଲେ ଇୟା ବିସୟ୍‌ତାନ୍‌ ୱାର୍‌ଗିଜିସାନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ମଣ୍ତଲି ୱାରି ସନି ସୁବିଦା କିଜି ପକ୍‍ତାତ୍‍ ମାରି ୱାର୍‌ ପିନିସିଆ ନି ସମିରୋଣ ସିଜି ସନି ୱାଲେ ଅଣଜିହୁଦି ଲୋକୁ ଏଣ୍ତେସ୍‌ ମନ୍‍ ଡ଼େପ୍‍ସି ଦାର୍ମୁଲୋକୁ ଆତାମାନାର୍‌, ଆୟା ବିସୟ୍‌ ୱେର୍‌ତାର୍‍; ଇୟା କାବୁର୍‌ ୱେନ୍‌ଜି ବିସ୍‍ବାସ୍‌ତି ତଡ଼ାନ୍‌କୁ ନାଣ୍ତ ୱେଡ଼ିକା ଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ୱାର୍‌ ଜିରୁସାଲାମ୍‍ତୁ ଇତି ୱେନ୍‌କା ମଣ୍ତଲି, ପ୍ରେରିତ ସିସୁର୍‍ ମାରି ମଣ୍ତଲିଦି ନେତାର୍‍ ୱାରିଙ୍ଗ୍‍ଁ କୁକ୍‍ତାର୍‍ । ମାପୁରୁ ୱାରି ମାଣାନ୍‌ କିତିମାନି ପାଣି ବିସୟ୍‌ତାନ୍‌ ପାଉଲ ନି ବର୍ଣ୍ଣବା ୱାରିଙ୍ଗ୍‍ଁ ୱେର୍‌ତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ମାତର୍‌ ପାରୁସିର୍‌ ଇସାବ୍‌ତାନ୍‌ ଜିନି ଏସ ବିସ୍‍ବାସିର୍‍ ନିଲ୍‍ସି ଇର୍ହାର୍‌, “ଅଣଜିହୁଦି ଲୋକୁ ସୁନ୍ନତ ଆନିକା ମାନାତ୍‌ ମାରି ମୋସାଦି ନିୟମ୍‌ ମାନାଦେଙ୍ଗ୍‌ ଇଜି ୱାରିଙ୍ଗ୍‍ଁ ଇନିକା ନେଗେତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ଇୟା ବିସୟ୍‌ ୱାର୍‍ଗିଦେଙ୍ଗ୍‍ଁ ଇଜି ପ୍ରେରିତ ସିସୁର୍‍ ମାରି ମଣ୍ତଲିଦି ନେତାର୍‍ ଉଣ୍ତାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ନାଣ୍ତ ସମୟ ୱାର୍‍ଗିତି ୱେନ୍‌କା ପିତର ନିଲ୍‍ଜି ଇର୍ହାନ୍‌, “ତଡ଼ାନ୍‌କୁ ନି ତାଙ୍ଗିଁକ୍‌, ମିର୍‌ ନେସ୍‍ନିଦେର୍‍ ଜେ ନାଣ୍ତ ଆଗ୍‌ଡ଼ିରାନ୍‌ ମାପୁରୁ ଅଣଜିହୁଦି ଲୋକୁ ଲାକ୍‌ତୁ ସୁସମାଚାର୍‌ ପ୍ରଚାର୍‌ କିଜି ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାରି ବିସ୍‌ବାସ୍‌ କିବିସ୍‍ କିଦେଙ୍ଗ୍‍ଁ ଇଜି ମି ମାଣ୍‌କୁ ନାଙ୍ଗିଁ ବାସେ କିତାମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ମାରି ୱିଜେରି ମନ୍‍ତି ଚିନ୍ତା ନେସ୍‍ସିମାନି ମନ୍‍ତୁବାସାନି ମାପୁରୁ ମାଙ୍ଗିଁ ଏଣ୍ତେସ୍‌ ପବିତ୍ର ଆତ୍ମା ସିତା ମାନାନ୍‌, ଅଣଜିହୁଦି ଲୋକାଙ୍ଗ୍‌ ବା ଟିକ୍‌ ଆୟାୱାଜା ଦାନ୍‌ ସିଜି ୱାରିଙ୍ଗ୍‍ଁ ସାକି ମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ୱାରିଦି ନି ମା ଲୋଇ ୱାନ୍‌ ଇନିକା ଅଲଗା ଇଡ୍‌ଏନ୍‌ । ୱାରି ବିସ୍‌ବାସ୍‌ ଉଣ୍ତିଙ୍ଗ୍‍ଁ ୱାନ୍‌ ୱାରି ପାପ୍‌ କେମା କିତାମାନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ଆର୍‍ତିଙ୍ଗ୍‍ଁ ଏମେ ବଜୁ ପିଣ୍ତ୍‍ଦେଙ୍ଗ୍‍ଁ ଇଜି ମା ଡକ୍ରାଦାଦା ନି ମାପ୍‌ ସାସ୍‌ କିଦେଙ୍ଗ୍‍ଁ ଆଟ୍‍ଏତାପ୍‍, ମିର୍‌ ଇଲେଇ ବିସ୍‍ବାସିରି ମେପିଦୁ ଆକା ଲାଦେ କିଜି ଏନ୍ଦା ମାପୁରୁଙ୍ଗ୍‍ଁ ପରିକା କିଦେଙ୍ଗ୍‌ ବଦାକିଜିନିଦେର୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ସିଲେ, ଇକା ଟିକ୍‌ ସିଲେ । ୱାର୍‌ ଏମେ ବିସ୍‌ବାସ୍‌ କିଜି ରକିୟା ପୟ୍‍ତାମାନାର୍‍, ମାପ୍‌ ବା ଟିକ୍ ଆୟାୱାଜା ବିସ୍‌ବାସ୍‌ କିଜି ପ୍ରବୁ ଜିସୁଦି ଦୟା ଦାନ୍‌ ପରିତ୍ରାଣ ପୟ୍‍ତାମାନାପ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ପାଉଲ ନି ବର୍ଣ୍ଣବାଦି ମାଣାନ୍‌ ଅଣଜିହୁଦି ଲୋକା ଲୋଇ ମାପୁରୁ ଏମେ ୱିଜୁ ନାଣ୍ତ କାବାଆନି ପାଣି ନି କାବାଆନି ବିସୟ୍‌ କିତାମାର୍ହାନ୍, ୱାରିମାଣ୍‌କୁ ତାନେ ମାଟା ୱେନ୍‌ଜି ଦଲତି ୱିଜେରେ ଆଲେତା ତେବାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ୱାର୍‌ ଇର୍ହି ୱିସ୍‌ତି ୱେନ୍‌କା ଜାକୁବ ଇର୍ହାନ୍‌, “ଏ ତଡ଼ାନ୍‌କୁ ନି ତାଙ୍ଗିଁକି, ନା ମାଟା ୱେନ୍‌ଡ୍ରୁ ! ");
INSERT INTO kfcp_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ମାପୁରୁ ଏଣ୍ତେସ୍‌ ଦୟା କିଜି ଅଣଜିହୁଦି ଲୋକା ଲୋଇ ଏସ ଲୋକାଙ୍ଗ୍‌ ୱାରି ଉଣ୍ତିଙ୍ଗ୍‍ଁ ବାସେ କିତାମାନାନ୍‍, ସିମୋନ ଆୟା ମାଟା ବୁଜାକିଜି ୱେର୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ବାବବାଦିରି ବାକ୍ୟ ତେନିଙ୍ଗ୍‍ଁ ପୁରାଦାନ୍‌ ମାନାଜିନାତ୍‍ । ସାସ୍ତ୍ରଦୁ ରାସାତାମାନାତ୍‌; ");
INSERT INTO kfcp_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“ପ୍ରବୁ ଇନାନ୍‌, ତେନି ୱେନ୍‌କା ନାନ୍ ଡ଼େସି ୱାନା ମାରି ଦାଉଦତି ରାଜିଦି ମାରିଡ଼େସି ରକିୟା କିନା । ନାନ୍ ୱାନି ଦଂସଆତି ଗୁଡ଼ା ୱିଜୁ ମାରିଡ଼େସି ତିଆର୍‍ କିଜି ତାନିଙ୍ଗ୍‌ ମାରି ଉଣ୍ତ୍ରି ଦେବା ସାକ୍ତି କିନା । ");
INSERT INTO kfcp_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ୱିଜୁ ଲୋକୁ ନା ଲାକ୍‌ତୁ ୱାନାର୍‌, ଏମେ ଅଣଜିହୁଦି ଲୋକାଙ୍ଗ୍‍ଁ ନାନ୍ ନିଜେଦିକା କିଦେଙ୍ଗ୍‍ଁ ଇଜି କୁକ୍‍ତାମାନା, ୱାର୍‌ ୱିଜେରେ ନାନ୍ଦି ଇଜି ମାନାନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ପ୍ରବୁ ଇୟା ମାଟା ଇର୍ହାମାନାନ୍‌, ପୁର୍ବେକାଡ଼ାଦୁ ଇୟା ମାଟା ୱାନ୍‌ ୱେର୍‍ତା ମାର୍ହାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“ନା ବିଚାର୍‌ ଇକା,” ଜାକୁବ ମାରି ବା ଇର୍ହାନ୍‌, ଏମେ ଅଣଜିହୁଦି ଲୋକୁ ମାପୁରୁଦି ଲାକ୍‌ତୁ ୱାତାମାନାର୍‌, ମାଡ୍‌ ୱାରିଙ୍ଗ୍‍ଁ ମାରି ବାଦା କିଏଟ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ମାତର୍‌ ୱାର୍‌ ଏଣ୍ତେସ୍‌ ଦିୟାମ୍‍କାଙ୍ଗ୍‍ଁ ପୁଜାସିତିମାନି ଇନି ଅସୁଚି କାଦି ଉଣୁଏର୍‌, ଦାରିପାଣି କିନି ପାପ୍‌ତାନ୍‌ ତେବାନାର୍‌, କକ୍‍ଲା ସିପ୍‍ସି ଡାକ୍‍ତିମାନି ଜାତୁଦି ନେତେର୍‌ ନି କାଣ୍ତା ତିନ୍‍ଏର୍‍ ଇୟାୱିଜୁ ବିସୟ୍‌ତାନ୍‌ ସିକିୟା ସିଜି ୱାରି ଲାକ୍‌ତୁ ଉଣ୍ତ୍ରି ଆକୁ ରାସ୍‍ନାଟ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ଇରିଙ୍ଗ୍‍ଁ ନାଣ୍ତଦିନ୍‍ ଆସ୍‌ସି ୱିଜୁ ରମ୍‍ନିଦିନ୍‍ତୁ ପାର୍‍ତନାକିନି ଇଲ୍‌କାଙ୍ଗ୍‌ ମୋସାଦି ନିୟମ୍‌ ପଡ଼ା ଆଜିନାତ୍‌ ମାରି ୱିଜୁ ଗାଡ଼୍‍କାଙ୍ଗ୍‍ଁ ୱାନି ବାକ୍ୟ ପ୍ରଚାର୍‌ ଆଜିନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ୱେନ୍‌କା ପ୍ରେରିତ ସିସୁର୍‍ ନି ମଣ୍ତଲିଦି ନେତାର୍‍ ମାରି ମଣ୍ତଲିଦି ୱିଜେରେ, ଦଲତି ଏସ ଲୋକାଙ୍ଗ୍‌ ବାସେକିଜି ପାଉଲ ନି ବର୍ଣ୍ଣବାଦି ୱାଲେ ୱାରିଙ୍ଗ୍‍ଁ ଆଣ୍ଟିୟକଦୁ ପକ୍‍ତେଙ୍ଗ୍‍ଁ ଇଜି ତିର୍‌ କିତାର୍‍ । ବର୍ସବା ଦର୍‌ତି ଜିହୁଦା ନି ସିଲା ବିସ୍‍ବାସ୍‌ତି ତଡ଼ାନ୍‌କା ଲୋଇ ସନ୍‍ମାନ୍‍ ପୟ୍‍ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ବିସ୍‍ବାସିର୍‍ ରାସାତିମାନି ଆକୁଦିଙ୍ଗ୍‌ ଇୟା ରିଏରି କିୟୁଦୁ ପକ୍‌ତାର୍‌ । “ଆଣ୍ଟିୟକ, ସିରିଆ ମାରି କିଲିକିୟାଦି ଅଣଜିହୁଦିରି ମାଣ୍‌କୁ ୱାତିମାନି ତଡ଼ାନ୍‌କୁ ପ୍ରେରିତ ସିସୁର୍‍ ମାରି ମଣ୍ତଲିଦି ନେତାର୍‍ ମାଡ଼ିସ୍‌ କିଜିନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ମାପ୍‌ ୱେନ୍‍ଜିନାପ୍‍ ଜେ, ମା ଦଲ୍‍ତାନ୍‍ ଏସ ଲୋକୁ ମି ଲାକ୍‌ତୁ ସଲ୍‍ସି ଆମାକା ଇର୍ହାମାନାର୍‌, ଆବେଣ୍‍କୁ ୱାର୍‌ ମି ମନ୍‍ତିଙ୍ଗ୍‍ ଗାବ୍ରା ନି ତରବର୍‍ କିତାମାନାର୍‍ । ମାତର୍‌ ଇୟା ବିସୟ୍‌ତାନ୍‌ ମାପ୍‌ ୱାରିଙ୍ଗ୍‍ଁ ଇନି ସିକିୟା ସିଏପ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ଆଦେଙ୍ଗ୍‌ ମାପ୍‌ ୱିଜେପେ ଉନ୍‍ଣ୍ତ୍ରି ମାଟା ଆଜି ଏସ ଲୋକ କାବୁର୍‌ ସିନିୱାରିଙ୍ଗ୍‍ଁ ବାସେ କିଜି ମି ଲାକ୍‌ତୁ ପକ୍‍ତେଙ୍ଗ୍‍ଁ ଇଜି ଆସ୍‍କିତାମାନାପ୍‍ । ୱାର୍‌ ମା ଲାଡ୍‍ତି ତଡ଼ାନ୍‌ ବର୍ଣ୍ଣବା ନି ପାଉଲତି ୱାଲେ ସନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ଇୟା ତଡ଼୍‍କୁ ପ୍ରବୁ ଜିସୁ କ୍ରିସ୍ତଦି ସେବାଦୁ ନିଜେଦି ଜିବନ୍‍ତିଙ୍ଗ୍‍ଁ ସିତା ମାନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ମାପ୍‌ ଜିହୁଦା ନି ସିଲେଙ୍ଗ୍‍ଁ ମି ଲାକ୍‌ତୁ ପକ୍‍ସିନାପ୍‍ । ମାପ୍‌ ଆମାକା ରାସ୍‍ସିନାପ୍‍, ୱାର୍‌ ନିଜେ ଆକା ମିଙ୍ଗିଁ ଇନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ଏସ ଦରକାର୍‍ ମାନି ନିୟମ୍‌ ଡ଼ିସ୍‍ତିଙ୍ଗ୍‍ଁ ମି ମୁସ୍‌କୁ ମାରି ଇନି ବଜୁ ତିଗ୍‌ଇ ଉଣ୍ତିଙ୍ଗ୍‍ ମାପ୍‌ ପବିତ୍ର ଆତ୍ମାଦି ମାଣାନ୍‌ ସିକିୟା ପୟ୍‍ତାମାନାପ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ଆୟା ଏସ ନିୟମ ଆତାତ୍‌; ଦିୟାମ୍‍କା ଉଦେସ୍‍ତାନ୍‍ ପୁଜାସିତିମାନି ଇନି କାଦି ଉଣ୍‍ମାଟ୍‍, ନେତେର୍‌ ତିନ୍‍ମାଟ୍‍, କକ୍‍ଲାଦିଙ୍ଗ୍‌ ପିଡ଼୍‍ସି ଡାକ୍‍ତିମାନି ଇନି ଜାତୁଦି କାଣ୍ତା ତିନ୍‍ମାଟ୍‍ ମାରି ଦାରିପାଣିଦାନ୍‌ ବନ୍ଦ୍‍ ଆନାତ୍‌ । ଇୟାୱିଜୁ ପାଣି କିଇ ଉଣ୍ତିଙ୍ଗ୍‍ଁ ଜାଗାର୍‌ତା ମାରିଙ୍ଗ୍‍ଁ, ମି ନେଗିକା ଆନାତ୍‌ । ମା ମାଟା ଆସ୍‌ତୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ଆମା କାବୁର୍‌ ସିନିୱାରିଙ୍ଗ୍‍ଁ ପକ୍‍ତାମାର୍ହାର୍‍, ୱାର୍‌ ଆଣ୍ଟିୟକଦୁ ସଲ୍‍ସି ବିସ୍‍ବାସିରି ୱିଜୁ ଦଲ୍‍ତିଙ୍ଗ୍‍ଁ ଉଣ୍ତା କିଜି ଇୟା ସିଟି ସିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ଆବେଣି ବିସ୍‌ବାସିର୍‍ ସିଟିଦି ୱେଡ଼ିକାଦି କାବୁର୍‌ ପଡ଼ାଜି ୱେଡ଼ିକାଦୁ ପୁରା ଆତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ଜିହୁଦା ନି ସିଲା ନିଜେ ବାବବାଦି ମାର୍ହାର୍‌ ମାରି ୱାର୍‌ ଆଣ୍ଟିୟକଦି ବିସ୍‍ବାସିରିଙ୍ଗ୍‍ଁ ନାଣ୍ତ ବେଡ଼ା ସାନ୍ଦି ୱାର୍‍ଜି ତଡ଼ାନ୍‌କାରି ବିସ୍‍ବାସ୍‍ତିଙ୍ଗ୍‍ଁ ଡାଟ୍‍ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ଆବେ ଏସ ଦିନ୍‌ ତେବାତି ୱେନ୍‌କା ଏମେକାର୍‌ ୱାରିଙ୍ଗ୍‍ଁ ପକ୍‍ତାମାର୍ହାର୍‍, ୱାରି ଲାକ୍‌ତୁ ଡ଼େସିସନ୍‍ଡ୍ରେଙ୍ଗ୍‍ ଇଜି ବିସ୍‍ବାସ୍‌ତି ତଡ଼ାନ୍‌କୁ ୱାରିଙ୍ଗ୍‍ଁ ସାନ୍ତିଦାନ୍‍ ପକ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","ମାତର୍‌ ସିଲା ଆବେନୁ ମାନିକା ନେଗେନ୍‌ ଇଜି ଅଡ଼୍‌ବିତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ପାଉଲ ନି ବର୍ଣ୍ଣବା ଆଣ୍ଟିୟକଦୁ ଏସ ଦିନ୍‌ ତେବାଜି ନାଣ୍ତ ଲୋକା ୱାଲେ ମିସାବିଡ଼ା ଆଜି ପ୍ରବୁଦି ବାକ୍ୟ ପ୍ରଚାର୍‌ କିତାର୍‍ ମାରି ସିକିୟା ସିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ଏସ ଦିନ୍‌ ୱେନ୍‌କା ପାଉଲ ବର୍ଣ୍ଣବାଦିଙ୍ଗ୍‍ଁ ଇର୍ହାନ୍‌, “ସନାଟ୍‌, ମାଡ୍‌ ଡ଼େସିସନାଟ୍‌, ୱିଜୁ ଗାଡ଼୍‍କାଙ୍ଗ୍‍ଁ ଏମେ ତଡ଼ାନ୍‍କାଙ୍ଗ୍‍ ପ୍ରବୁଦି ବାକ୍ୟ ଏଣ୍ତେସ୍‌ ୱେନିସ୍‍ କିତିମାର୍ହିକା, ତଡ଼ାନ୍‌କାଙ୍ଗ୍‌ ମିସାନାଟ୍‍ ମାରି ୱାର୍‌ ଏଣ୍ତେସ୍‌ ମାନାର୍‌, ବୁଜାନାଟ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ବର୍ଣ୍ଣବା ୱାରି ୱାଲେ ଜୋହନ ଦର୍‌ତି ମାର୍କଙ୍ଗ୍‍ଁ ଅତେଙ୍ଗ୍‍ଁ ଇଜି ବଦାକିତା ମାର୍ହାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ମାତର୍‌ ପାଉଲ ୱାନିଙ୍ଗ୍‍ଁ ଅତେଙ୍ଗ୍‌ ଟିକ୍‌ ଅଡ଼୍‌ବିଏତାନ୍‍; ଇରିଙ୍ଗ୍‍ଁ ୱାନ୍‌ ଆଗ୍‌ଡ଼ି ପ୍ରଚାର୍‌ କିଦେଙ୍ଗ୍‌ ସନି ପାଣିଦୁ ୱିଜ୍‍ନି ସାନ୍ଦି ୱାରି ୱାଲେ ତେବାଏନ୍‍ଣ୍ତା ୱାରିଙ୍ଗ୍‍ଁ ପାମ୍ଫିଲିଆଦୁ ଡ଼ିସ୍‌ସି ସର୍ହାମାର୍ହାନ୍ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ଇୟା ବିସୟ୍‌ତାନ୍‌ ନାଣ୍ତ ଆସ୍‌ସିସାତାର୍‌ ମାରି ୱାର୍‌ ୱେର୍‌ଏ ଆତାର୍‌ । ବର୍ଣ୍ଣବା ମାର୍କଙ୍ଗ୍‍ଁ ଆସ୍‌ସି ସାଇପ୍ରସ୍‍ତୁ ଏରୁ ସାରିଦୁ ସର୍ହାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ମାତର୍‌ ପାଉଲ ସିଲେଙ୍ଗ୍‍ଁ ଆସ୍‌କିତାନ୍‍ ମାରି ବିସ୍‍ବାସ୍‌ତି ତଡ଼ାନ୍‌କା ମାଣାନ୍‌ ପ୍ରବୁଦି ଦୟାଦାନ୍‌ ସର୍ପେ ଆଜି ସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ୱାନ୍‌ ମଣ୍ତଲିଆଙ୍ଗ୍‍ଁ ସାକ୍ତିକିବିସ୍‍ କିଜି ସିରିଆ ନି ସିଲିସିଆ ବା ସିଜି ସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ପାଉଲ ଦର୍ବି ନି ଲୁସ୍ତ୍ରାଦୁ ସର୍ହାର୍‍ । ଆବେ ତିମତି ଦର୍‌ତି ଅରେନ୍‌ କ୍ରିସ୍ଟିୟାନ୍‍ ବାସାଜି ମାର୍ହାନ୍‍ । ୱାନ୍‌ ଅରେନ୍‌ କ୍ରିସ୍ତ ବିସ୍‍ବାସି ଜିହୁଦି ଆଇମାଦି ମାରିସି । ମାତର୍‌ ୱାନି ବୁବାସି ଅରେନ୍‌ ଗ୍ରିକ୍‌ ଲୋକୁ ମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ଲୁସ୍ତ୍ରା ନି ଇକନିୟାଦୁ ମାନି ତଡ଼ାନ୍‌କା ଲୋଇ ତିମତିଦିଙ୍ଗ୍‌ ନେଗି ଲୋକ୍‌ ଇଜି ନେସ୍‌ତା ମାର୍‌ର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ପାଉଲ ୱାନି ୱାଲେ ତିମତିଙ୍ଗ୍‍ଁ ଅତେଙ୍ଗ୍‍ଁ ଇଜି ବଦା କିତାନ୍‌, ଆଦେଙ୍ଗ୍‍ଁ ୱାନିଙ୍ଗ୍‍ଁ ସୁନ୍ନତ କିତାନ୍‌ । ଇକା କିନି ମାଟା ଆତାତ୍‌, ତିମତିଦି ବୁବାସି ଗ୍ରିକ୍‌ ଲୋକୁ ଇଜି ଆୟା ବାଡିଆଙ୍ଗ୍‍ଁ ବାସାତିମାନିକାର୍‍ ଜିହୁଦି ଲୋକୁ ନେସ୍‍ତାମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ନାଣ୍ତ ଗାଡ୍‌କୁ ନାଡ଼୍‍ମି ସିଜି ସନି ୱାଲେ ୱାର୍‌ ବିସ୍‍ବାସିରିଙ୍ଗ୍‍ଁ ଜିରୁସାଲାମ୍‌ତି ପ୍ରେରିତ ସିସୁର୍‍ ନି ପେରି ନେତାର୍‍ ୱାରି ମାଣାନ୍‌ କିଆୟ୍‍ଆତି ନିତି ନିୟମ ୱିଜୁ ବୁଜାକିଜି, ଆୟାୱିଜୁ ମାନାଦେଙ୍ଗ୍‌ ଇଜି ଇଜିମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ଆବେଟ୍‌କୁ ମଣ୍ତଲିଙ୍ଗ୍‍ଁ ୱିଜୁ ବିସ୍‌ବାସ୍‌ତୁ ମାରି ନାଣ୍ତ ସାକ୍ତି ଆତାତ୍‌ ମାରି ଦିନ୍‍ତିଙ୍ଗ୍‍ ଦିନ୍‌ ଲୋକୁ ନାଣ୍ତ ଆଦେଙ୍ଗ୍‍ଁ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ପବିତ୍ର ଆତ୍ମା ୱାରିଙ୍ଗ୍‍ଁ ଆସିଆ ଦେସ୍‌ତୁ ପ୍ରଚାର୍‌ କିଦେଙ୍ଗ୍‍ଁ ସାରି ପୟ୍‍ଏତାର୍‍ ଆକା ୱାର୍‌ ପ୍ରୁଗିଆ ମାରି ଗାଲାତିୟ ରାଜିଦୁ ସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ମିସିଆଦି ଲାକ୍‌ତୁ ଇଜି ବିତୁନିଆ ରାଜିଦୁ ସନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ସନିୱାଲେ ଜିସୁଦି ଆତ୍ମା ୱାରିଙ୍ଗ୍‍ଁ ସାରି ସିଏତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ଆଦେଙ୍ଗ୍‍ଁ ୱାର୍‌ ମିସିଆ ନାଡ଼୍‍ମି ସିଜି ସଲ୍‍ସି ତ୍ରୋୟାଦୁ ସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ଆୟା ନାଡ଼ା ପାଉଲ ଉନ୍‍ଣ୍ତ୍ରି ଦର୍ସନ୍‍ ପୟ୍‌ତାନ୍‌ ଜେ, ମାସିଦୋନିଆଦି ଅରେନ୍‌ ଲୋକୁ ମାଡ଼ିସ୍‌ କିଜି ଇଜିନାନ୍‌, “ମାସିଦୋନିଆଦୁ ୱାଜି ମାଙ୍ଗିଁ ସାକା କିଆ !” ");
INSERT INTO kfcp_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ପାଉଲ ଇୟା ଦର୍ସନ୍‌ ପୟ୍‍ତିଦାପ୍ରେ ମାସିଦନିଆଦୁ ସନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ଇଜି ମାପ୍‌ ତିଆର୍‌ ଆତାପ୍‍, ଇରିଙ୍ଗ୍‍ଁ ମାପ୍‌ ସତେ ନେସ୍‍ତାପ୍‍, ମାପୁରୁ ଆବେଣି ଲୋକା ଲୋଇ ସୁସମାଚାର୍‌ ପ୍ରଚାର୍‌ କିଦେଙ୍ଗ୍‍ଁ ଇଜି ମାଙ୍ଗିଁ କୁକ୍‌ତାମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ମାପ୍‌ ଜାହାଜ୍‍ତାନ୍‍ ତ୍ରୋୟା ଡ଼ିସ୍‌ସି ସାମତ୍ରାଦୁ ସର୍ହାପ୍‍ ମାରି ମାରିନାଣ୍ତିଙ୍ଗ୍‍ଁ ନିଆପଲିଦୁ ଇତାପ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ଆବେଟ୍‍ଟାନ୍‍ ମାପ୍‌ ମାସିଦନିଆ ଜିଲାଦି ପେରି ଗାଡ଼୍‌ ପିଲିପିଦୁ ସର୍ହାପ୍‍ । ଇୟା ଗାଡ଼୍‌ ଉନ୍‍ଣ୍ତ୍ରି ରୋମିୟରି ବସ୍ତି ମାର୍ହାତ୍‌ । ମାପ୍‌ ଆବେନୁ ନାଣ୍ତ ଦିନ୍‌ ତେବାତାପ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ରମ୍‌ନି ଦିନ୍‌ ଗାଡ଼୍‌ ଆତ୍‌ରେ ମାନି ଗାଡା ପାଡ଼ି ସର୍ହାପ୍‍ । ମାପ୍‌ ଅଡ଼୍‍ବିତାପ୍‍, ଆବେ ଜିହୁଦିଲୋକୁ ଉଣ୍ତାଜି ପାର୍‌ତାନା କିଦେଙ୍ଗ୍‍ଁ ଇଜି ଉନ୍‍ଣ୍ତ୍ରି ବାଡି ତେବାନାତ୍‍ । ମାପ୍‌ ବାସ୍‍ତାପ୍‍ ମାରି ଆବେ ଉନ୍‍ଣ୍ତାତି ମାର୍ହି ଆଇମା ଲୋକା ୱାଲେ ୱାର୍‍ଗିତାପ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ତାମେ ଲୋଇ ତୁୟତିରା ଗାଡ଼୍‌ତି ସେର୍‍ଗା ରଙ୍ଗ୍‍ ୱାତିଗଦା ପର୍‌ଜି ମାନି ଲୁଦିଆ ଦର୍‌ତି ଅରେତ୍‌ ଆଇମା ମାର୍ହାତ୍‌ । ୱାଦ୍‌ ମାପୁରୁଦି ଉପାସନା କିଜିମାର୍ହାତ୍‍ ମାରି ପାଉଲ ଆମାକା ଇଜିମାର୍‍ଆନ୍‍, ଆକା ମନ୍‍ ସିଜି ୱେନ୍‌ଜି ମାନାଦେଙ୍ଗ୍‍ଁ ଇଜି ପ୍ରବୁ ତାନିଙ୍ଗ୍‍ଁ ସୁଜୋଗ ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ୱାଦ୍‌ ନି ତାନି ଇଲ୍‍ତି ୱିଜେରେ ଡୁବନ୍‌ ଅତି ୱେନ୍‌କା ମାଙ୍ଗିଁ ମାଡ଼ିସ୍‌ କିଜି ଇର୍ହାତ୍‌, “ପ୍ରବୁମାନୁ ସତ୍‍ତାନ୍‍ ନା ବିସ୍‌ବାସ୍‌ ମାନାତ୍‌ ଇଜି ଜଦି ମିର୍‌ ଅଡ଼ବିଜିନିଦେର୍‌, ଆର୍‍ତିଙ୍ଗ୍‍ଁ ୱାଜି ନା ଇଲ୍‌ତୁ ତେବାଦୁ ।” ୱାଦ୍‌ ଇୟାୱାଜା ତାନି ଇଲ୍‌ତୁ ସନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ଇଜି ମାଙ୍ଗିଁ ୱେର୍‌ତାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ଅର୍‍ଲେନ୍‍ ମାପ୍‌ ପାର୍‌ତାନା ବାଡିଦୁ ସନିୱାଲେ ଅରେତ୍‌ ଦାସି ରିପାଦିଙ୍ଗ୍‍ଁ ବୁଡ଼ିତାପ୍‍ । ତାନି ଲୋଇ ମାନି ତାଗ୍‌ଇ ଆତ୍ମାଦି ସାକ୍ତିଦାନ୍ ୱାଦ୍‍ ବବିସତ୍‍ ମାଟା ଇନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ଆଟ୍‍ସି ମାର୍ହାତ୍‌ । ୱାଦ୍‌ ଲୋକା ବାଗ୍ୟ ଲେକିସ୍‌ କିଜି, ମାଲିକ୍‌କା ଉଣ୍ତିଙ୍ଗ୍‍ଁ ନାଣ୍ତ ଡାବୁଙ୍ଗୁଁ ଉଣ୍ତା କିଜିମାର୍ହାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ୱାଦ୍‌ ପାଉଲ ନି ମା ୱେନ୍‌କା ୱେନ୍‌କା ୱାଜି ଆଉଲି ଆଜି ଇର୍ହାତ୍‌, “ଇୟା ଲୋକୁ ୱିଜେରିଙ୍ଗ୍‍ଁ ପେରି ମାପୁରୁଦି ସେବାକିନିକାର୍‍ । ମିର୍‌ ଏଣ୍ତେସ୍‌ ପରିତ୍ରାଣ ପୟ୍‌ନିଦେର୍‌, ଇୟା ମାଟା ୱାର୍‌ ଇଜିନାର୍‍ !” ");
INSERT INTO kfcp_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ରିପା ଆଇଲି ବେସି ଦିନ୍‌ ଆସ୍‌ସି ଇୟାୱାଜା କିତାତ୍‍ । ସାରାସାରି ପାଉଲ ରିସା ଆଜି ୱେନ୍‌କା ମାର୍‍ଜି ତାଗ୍‌ଇ ଆତ୍ମାଦିଙ୍ଗ୍‍ଁ ଆଦ୍‌ରିସି ଇର୍ହାନ୍‌, “ଜିସୁ କ୍ରିସ୍ତଦି ଦର୍‌ତାନ୍‌ ଆଦେସ୍‌ ସିଜିନା, ତାନି ମାଣାନ୍‌ ସହସ ସାଙ୍ଗ୍ଆ !” ଆୟା ଦାପ୍ରେ ତାଗ୍‌ଇ ଆତ୍ମା ତାନି ମାଣାନ୍‌ ସତା ସର୍ହାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ଏସ୍ତିୱାଲେ ତାନି ମାଲିକ୍‍କୁ ନିଜେଦି ଡାବୁଙ୍ଗୁଁ ଉଣ୍ତାକିନିକା ଆରାତାପ୍‌ ଇଜି ନେସ୍‍ସି, ପାଉଲ ନି ସିଲେଙ୍ଗ୍‍ଁ ଆସ୍‌ସି ଗାଡ଼୍‌ତି ମଜାୟ୍‍ ନାଡ଼୍‍ମିବାଡିଦୁ ମାନି ରମିୟ ନେତାର୍‌ଦି ଲାକ୍‌ତୁ ରେଲ୍‌ଜି ତାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ମାରି, ୱାର୍‌ ୱାରିଙ୍ଗ୍‍ଁ ରମିୟ ସାସନ୍‍କିନିୱାରି ଲାକ୍‌ତୁ ତାସି ଇର୍ହାର୍‌, “ଇୟା ଲୋକୁ ଜିହୁଦିର୍‌, ଇୟାକାର୍‌ ମା ଗାଡ଼୍‌ତୁ ଜାଟିଜଗଡ଼ା କିଜିନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ୱାର୍‌ ମା ନିୟମ୍‌ ବିରୁଦ୍‍ତି ରିତିନିତି ଅଜାକିଜିନାର୍‍ । ମାଡ୍‌ ରମିୟ ଲୋକୁ, ଆଦେଙ୍ଗ୍‍ଁ ଇୟାୱିଜୁ ରିତିନିତି ଆସ୍‍ତେଙ୍ଗ୍‍ଁ ଆଟ୍‍ଏପ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ମାଲିକ୍‌କା ମାଟାଦୁ ଆସ୍‌ସି ଆବେ ମାନି ଲୋକୁ ପାଉଲ ନି ସିଲାଦି ବିରଦ୍‌ତାନ୍‌ ନିଙ୍ଗିଁତାର୍‍ । ପାଉଲ ନି ସିଲାଦି ଆଙ୍ଗିଁ କୁତ୍‍ସି ୱାରିଙ୍ଗ୍‍ଁ ବାଡିଗାଦାନ୍‍ ଡାକ୍‍ତେଙ୍ଗ୍‍ଁ ନେତା ଆଦେସ୍‌ ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ନାଣ୍ତ ମାଡ୍‌ ତିର୍‌ଇ ୱେନ୍‌କା ୱାର୍‌ ଜଇଲ୍‌ତୁ ସର୍ହାର୍‍ ମାରି ୱାରିଙ୍ଗ୍‍ଁ କୁସିକାଣ୍ତି ଆର୍‍ପ୍‍ସି କାପ୍‌କିଜି ଇଡ୍‍ଦେଙ୍ଗ୍‍ଁ ଇଜି କାପ୍‍କିନିୱାରିଙ୍ଗ୍‍ଁ ଆଦେସ୍‌ ସିଆୟ୍‍ ଆତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ଇୟା ଆଦେସ୍‌ ପୟ୍‌ଜି କାପ୍‍କିନିକାନ୍‍ ୱାରିଙ୍ଗ୍‌ ଉନ୍‍ଣ୍ତ୍ରି ଲୋଇରି ବାକ୍‍ରାଦୁ ଇଡ୍‌ଜି, ବଜ୍‍ତି ମାରାନ୍‌ ଗଣ୍ତିଦୁ ୱାରି କାଲ୍‍କାଙ୍ଗ୍‍ଁ ତର୍‍ତା ଇଟ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ମଜାୟ୍‍ ନାଡ଼ା ପାଉଲ ନି ସିଲା ପାର୍‌ତନା କିଜିମାର୍ହାର୍‌, ମାପୁରୁଦି ଉଦେସ୍‍ତାନ୍‍ ପାଟା ପାର୍‍ଜି ମାର୍ହାର୍‌ ମାରି ଜଇଲ୍‌ତୁ ମାନି ଆଇକାର୍‌ ଇକା ୱେନ୍‌ଜି ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ଆୟାଦାପ୍ରେନେ ନାଣ୍ତ ବୁମିକମ୍ଫ ଆତାତ୍‌ ମାରି ଜଇଲ୍‍ତି ମୁଲ୍‍କାଲ୍‍ତିଙ୍ଗ୍‍ଁ ଦୁକାତା ପକ୍‍ତାତ୍‍ । ବେଗି ବେଗି ୱିଜୁ ସେର୍‍ଲେଙ୍ଗ୍‌ ରେଆତେ ସର୍ହେ ମାରି ୱିଜୁ ଜଇଲ୍‌ତୁ ମାନିଲୋକା ସିକିଣିଙ୍ଗ୍‍ଁ ଆର୍‍ତେ ସର୍ହେ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ଜଇଲ୍‍ତିଙ୍ଗ୍‍ଁ କାପ୍‍କିନିକାନ୍‍ ସେତାଆଜି ନିଙ୍ଗିଁତାନ୍‍ ମାରି ଜଇଲ୍‍ତି ସେର୍‍ଲେଙ୍ଗ୍‌ ୱିଜୁ ରେଆତିକା ସୁଡ଼୍‌ଜି ଅଡ଼୍‍ବିତାନ୍‍ ଜେ ଜଇଲ୍‍ତୁମାନିକାର୍‍ ଉର୍‍କୁତାମାନାର୍‍; ଆଦେଙ୍ଗ୍‍ଁ ୱାନ୍‌ ୱାନି କୁଡ଼ାମ୍‍ ସପ୍‍ସି କାତାଦେଙ୍ଗ୍‍ଁ ଇଜି ବଦା କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ମାତର୍‌ ପାଉଲ ନାଣ୍ତ ଆଉଲିଦାନ୍‍ ଇର୍ହାନ୍‌, “ନିଜେଦିଙ୍ଗ୍‍ଁ ଇନି ନାଷ୍ଟୁ କିମା । ମାପ୍‌ ୱିଜେରେ ଇବେ ମାନାପ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ଜଇଲ୍‌ କାପ୍‍କିନିକାନ୍‍ ଦିୱା ତାପିସ୍‍କିତାନ୍‍ ମାରି ଲୋଇ ଉରୁକ୍‍ସି ୱାଜି ତିର୍‍ଗିଜି ତିର୍‍ଗିଜି ପାଉଲ ନି ସିଲାଦି କାଲ୍‍କା ଆଡ୍‍ଗି ଆର୍‍ତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ୱେନ୍‌କା ୱାରିଙ୍ଗ୍‍ଁ ଆତ୍‌ରେ ଅସି ୱେନ୍‌ବାତାନ୍‌, “ଆଜ୍ଞାର୍‍, ରକିୟା ପୟ୍‍ଦେଙ୍ଗ୍‍ଁ ଇଜି ନାଙ୍ଗିଁ ଇନିକା କିଦେଙ୍ଗ୍‍ଁ ଆନାତ୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ୱାର୍‌ ଇର୍ହାର୍‌, “ପ୍ରବୁ ଜିସୁମାନୁ ବିସ୍‌ବାସ୍‌ କିତିଙ୍ଗ୍‍ଁ, ନିନ୍‌ ମାରି ଇଲୁଦି ୱିଜୁ ଲୋକୁ ରକିୟା ପୟ୍‌ନିଦେର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ୱେନ୍‌କା ୱାର୍‌ ୱାନିଙ୍ଗ୍‍ଁ ନି ୱାନି ଇଲୁଦି ଆଇ ୱିଜେରିଙ୍ଗ୍‍ଁ ପ୍ରବୁଦି ବାକ୍ୟ ୱେର୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ନାଡ଼ାଦି ଆୟା ସମୟ୍‍ତୁ ଜଇଲ୍‍ତିଙ୍ଗ୍‍ଁ କାପ୍‍କିନିକାନ୍‍ ୱାରିଙ୍ଗ୍‍ଁ ଅସି ୱାରି ଗାଉକୁ ୱିଜୁ ନର୍‍ତା ସିତାନ୍‌, ମାରି ୱାନ୍‌ ନି ଇଲ୍‍ତି ୱିଜେରେ ଆୟାଦାପ୍ରେ ଡୁବନ୍‌ ଅତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ତାନିୱେନ୍‍କା ୱାନ୍‌ ପାଉଲ ନି ସିଲେଙ୍ଗ୍‍ଁ ନିଜେଦି ଇଲ୍‌ତୁ ଅସି ଉଣ୍ତେଙ୍ଗ୍‍ଁ ସିତାନ୍‌ । ମାପୁରୁମାନୁ ବିସ୍‌ବାସ୍‌ କିତାର୍‍ଆକା ୱାନ୍‌ ନି ୱାନି ଇଲ୍‍ତି ୱିଜେରି ଜିବନ୍‌ ୱେଡ଼ିକାଦୁ ପୁରା ଆତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ମାରିନାଣ୍ତିଙ୍ଗ୍‍ଁ ସାଲ୍‍ଦି ରମିୟ ଅଦିକାରିର୍‍ ଜାମାନ୍‌କାଙ୍ଗ୍‍ଁ ଇୟା ଆଦେସ୍‌ ସିଜି ପକ୍‌ତାନ୍, “ଆୟା ଲୋକାଙ୍ଗ୍‌ ଡ଼ିସ୍‌ସୋ ସିଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ଆବେଟ୍‌ ଜେଲ୍‌କାପ୍‍କିନିକାନ୍‍ ପାଉଲ୍‍ତିଙ୍ଗ୍‍ଁ ଇର୍ହାନ୍‌, “ଅଦିକାରିର୍‍ ନିଙ୍ଗିଁ ନି ସିଲେଙ୍ଗ୍‍ଁ ମୁକୁଡ଼ା କିଦେଙ୍ଗ୍‍ଁ ଇଜି ଆଦେସ୍‌ ପକ୍‍ତାମାନାନ୍‍ । ଇଲେଇ ମିର୍‌ ସାନ୍ତିଦାନ୍‌ ଇୟା ବାଡିଦାନ୍‍ ସନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ଆଟ୍‌ନିଦେର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ମାତର୍‌ ପାଉଲ ଜାମାନ୍‌କାଙ୍ଗ୍‍ଁ ଇର୍ହାନ୍‌, “ଇନି ନିନ୍ଦାଦୁ ଦସି ଆଏତିମାରିଙ୍ଗ୍‍ଁ ବା ୱାର୍‌ ଲୋକା ଆଗ୍‌ଡ଼ି ମାଙ୍ଗିଁ ଡାକ୍‍ତାର୍‍ । ମାପ୍‌ ରମିୟ ଲୋକୁ, ମାତର୍‌ ୱାର୍‌ ମାଙ୍ଗିଁ ଜଇଲ୍‌ତୁ ଇଟ୍‌ତାର୍‌ । ଇଲେଇ ୱାର୍‌ ମାଙ୍ଗିଁ ନେସ୍‌ଇୱାଜା ଡ଼ିସ୍‌ସୋ ସିଦେଙ୍ଗ୍‌ ବଦା କିଜିନାର୍‍ । ମାପ୍‌ ଇକା କିଦେଙ୍ଗ୍‍ଁ ସିଏପ୍‍ । ରମିୟ ଅଦିକାରିର୍‍ ନିଜେ ଇବେ ୱାଜି ମାଙ୍ଗିଁ ମୁକୁଡ଼ା କିପିର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ଜାମାନ୍‌କୁ ରମିୟ ଅଦିକାରିଙ୍ଗ୍‍ଁ ଇୟା ମାଟା ୱେର୍‌ତାର୍‌ । ପାଉଲ ନି ସିଲା ରମିୟ ଲୋକୁ ଇଜି ୱେନ୍‌ଜି ୱାର୍‌ ତିଲାତା ସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ୱେନ୍‌କା ସଲ୍‍ସି ୱାରି ଲାକ୍‌ତୁ କେମା ଲୋସ୍‍ତାର୍‍ ମାରି ୱାରିଙ୍ଗ୍‍ଁ ଜଇଲ୍‍ତାନ୍‍ ମୁକୁଡ଼ା କିଜି ଗାଡ଼୍‌ ଡ଼ିସ୍‌ସି ସନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ମାଡ଼ିସ୍‌ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ପାଉଲ ନି ସିଲା ଜଇଲି ଡ଼ିସ୍‌ସି ଲୁଦିଆଦି ଇଲ୍‌ତୁ ସର୍ହାର୍‍ । ଆବେ ୱାର୍‌ ବିସ୍‍ବାସ୍‌ତି ତଡ଼ାନ୍‌କାଙ୍ଗ୍‌ ବେଟ୍‍ ଆତାର୍‌ ମାରି ୱାରିଙ୍ଗ୍‍ଁ ୱେଡ଼ିକା ମାଟା କିବିସ୍‍ କିଜି ଆୟା ବାଡି ଡ଼ିସ୍‌ସି ସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ପାଉଲ ନି ସିଲା ଆମ୍ଫିପଲି ମାରି ଆପଲନିଆ ଗାଡ଼୍‌ ସିଜି ସଲ୍‍ସି ତେସଲନିକିୟାଦି ଇତାର୍‌ । ଆବେ ଉନ୍‍ଣ୍ତ୍ରି ଜିହୁଦିରି ପାର୍‌ତନା ଇଲୁ ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ପାଉଲ ୱାନି ରିତି ଇସାବ୍‌ତାନ୍‌ ପାର୍‌ତନା ଇଲ୍‌ତୁ ସର୍ହାନ୍‍ । ଆବେ ପାକାପାକି ମୁନ୍‍ଣ୍ତ୍ରି ରମ୍‌ନି ଦିନ୍‌ ସାନ୍ଧି ଦାର୍ମୁସାସ୍ତ୍ରଦି ବାକ୍ୟ ଅସି ୱାନ୍‌ ଲୋକାଙ୍ଗ୍‌ ୱେର୍‌ତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ଦାର୍ମୁସାସ୍ତ୍ର ୱେର୍‌ସି ମାରି ବୁଜାକିଜି ସତ୍‌ ତର୍‍ତାନ୍‍ ଜେ, ମସିହଦି ଦୁକୁ ବଗାନିକା ମାରି ସାତି ମାଣାନ୍‌ ନିଙ୍ଗିଁକା ଦର୍‌କାର୍‌ ମାର୍ହାତ୍‌ । ପାଉଲ ଇର୍ହାନ୍‌, “ଏମେ ଜିସୁଦି ବିସୟ୍‌ ନାନ୍ ୱେର୍‌ସିନା, ୱାନ୍‌ ଆୟା ମସିହ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ୱାରି ଲୋଇ ଏସ ଲୋକୁ ଇକା ବିସ୍‌ବାସ୍‌ କିଜି ପାଉଲ ନି ସିଲା ୱାଲେ ମିସାତାର୍‍; ଆୟାୱାଜା ନାଣ୍ତ ପେରି ଆଇମେକ୍‍ ମାରି ମାପୁରୁଦି ପାର୍‍ତନାକିନି ଗ୍ରିକ୍‌ ଲୋକା ଉନ୍‍ଣ୍ତ୍ରି ପେରି ଦଲ୍‌ ବା ୱାରି ୱାଲେ ମିସାତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","ମାତର୍‌ ଜିହୁଦି ଲୋକୁ ରିସା ଆତାର୍‌ ମାରି ଏସ ତାଗ୍‌ଇ ଗୁଣ୍‍ତି ଲୋକାଙ୍ଗ୍‌ ଉଣ୍ତା କିଜି ୱିଜୁ ଗାଡ଼୍‍କାଙ୍ଗ୍‍ଁ ମାଡ୍‌ଗୋଲ୍‌ କିବିସ୍‍ କିତାର୍‍ । ୱାର୍‌ ପାଉଲ ନି ସିଲେଙ୍ଗ୍‍ଁ ପୟ୍‌ଜି ଲୋକା ଲାକ୍‌ତୁ ତାନି ଉଣ୍ତିଙ୍ଗ୍‍ଁ ଜେସନ୍‍ ଦର୍‌ତି ଅରେନ୍‌ ଲୋକ୍‌ତି ଇଲୁଦିଙ୍ଗ୍‌ ୱିର୍‍ସିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ମାତର୍‌ ଆବେ ପାଉଲ ନି ସିଲେଙ୍ଗ୍‍ଁ ପୟ୍‍ଏଜି, ୱାର୍‌ ଜେସନ୍‍ ନି ଆଇ ଏସ ବିସ୍‍ବାସ୍‌ତି ତଡ଼ାନ୍‌କାଙ୍ଗ୍‌ ଗାଡ଼୍‌ତି ଅଦିକାରିରି ଲାକ୍‌ତୁ ରେଲ୍‌ଜି ତାସି ଆଉଲି ଆଜି ଇର୍ହାର୍‌, “ଇୟା ଲୋକୁ ସାରିବେଡ଼୍‍ତି ଜାଟି ଜଗଡ଼ା କିଜିନାର୍‍ ! ଇଲେଇ ୱାର୍‌ ମା ଗାଡ଼୍‌ତୁ ୱାତାମାନାର୍‌ ");
INSERT INTO kfcp_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ମାରି ଜେସନ୍‍ ୱାରିଙ୍ଗ୍‍ଁ ୱାନି ଇଲ୍‌ତୁ ଇଟ୍‌ତାମାନାନ୍‌ । ଜିସୁ ଦର୍‌ତି ମାରି ଅରେନ୍‌ ରାଜା ମାନାନ୍‌ ଇଜି ୱେର୍‌ସି ୱାର୍‌ ସମ୍ରାଟଦି ୱିଜୁ ନିୟମ୍‌ ଅମାନ୍ୟ କିଜିନାର୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ଇୟା ମାଟା ଇଜି ୱାର୍‌ ଲୋକାଙ୍ଗ୍‌ ନି ଅଦିକାରିରି ଲୋଇ ନାଣ୍ତ ରିସା ନି ଜାଟି ଜଗଡ଼ା କିଜିନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ଅଦିକାରିର୍‍ ଜେସନ୍‍ ନି ବିସ୍‍ବାସିରି ମାଣାନ୍‌ ଡାବୁଙ୍ଗୁଁ ଅସି ୱାରିଙ୍ଗ୍‍ଁ ମୁକୁଡ଼ା କିଜି ଡ଼ିସ୍‍ତା ସିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ନାଡ଼ା ଆତିୱେନ୍‍କା ବିସ୍‍ବାସ୍‌ତି ତଡ଼ାନ୍‌କୁ ପାଉଲ ନି ସିଲେଙ୍ଗ୍‍ଁ ବେରିଆଦୁ ପକ୍‌ତାର୍‌ । ୱାର୍‌ ଆବେଟାନ୍‍ ଇଜି ଜିହୁଦିରି ପାର୍‌ତନା ଇଲୁଦୁ ସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ତେସଲନିକିୟାଦି ଲୋକା ବାଦ୍‌ଲୁ ଆବେଣି ଲୋକୁ ନାଣ୍ତ ନେସ୍‌ତେଙ୍ଗ୍‌ ୱେଡ଼ିକା ମାର୍ହାର୍‍ । ୱାର୍‌ ନାଣ୍ତ ୱେଡ଼ିକାଦାନ୍‌ ସିସୁରି ବାକ୍ୟ ୱେର୍‌ଆର୍‌ ମାରି ପାଉଲଦି ମାଟାଦି ସତ୍‌ ମାଟା ନେସ୍‍ତେଙ୍ଗ୍‍ଁ ଇଜି ୱିଜୁଦିନ୍‌ ଦାର୍ମୁସାସ୍ତ୍ର ପଡ଼ାଜି ୱେନ୍‍ବାଜି ମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ୱାରି ଲୋଇ ନାଣ୍ତ ଲୋକୁ ବିସ୍‍ବାସ୍‍ କିତାର୍‍ । ନାଣ୍ତ ସନ୍‌ମାନ୍‍‍ତି ଗ୍ରୀକ୍‍ ଆଇମେକ୍‍ ମାରି ଗ୍ରିକ୍‌ ଲୋକୁ ବିସ୍‍ବାସିରି ୱାଲେ ମିସାତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ମାତର୍‌ ଏସ୍ତିୱାଲେ ତେସଲନିକିୟାଦି ଜିହୁଦି ଲୋକୁ ୱେର୍‌ଆର୍‌ ଜେ ବେରିଆଦୁ ବା ପାଉଲ ମାପୁରୁଦି ବାକ୍ୟ ପ୍ରଚାର୍‌ କିଜିନାନ୍‍, ୱାର୍‌ ଆବେ ୱାଜି ଜାଟି ଜଗଡ଼ା କିଦେଙ୍ଗ୍‍ଁ ଇଜି ଲୋକାଙ୍ଗ୍‌ ଏଗ୍ରିସ୍‍ତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ବେଗି ବେଗି ବିସ୍‍ବାସ୍‌ତି ତଡ଼ାନ୍‌କୁ ପାଉଲ୍‍ତିଙ୍ଗ୍‍ଁ ସାମ୍‌ଦୁର୍‌ ପାଡ଼ିସିଜି ପକ୍‌ତାର୍‌; ମାତର୍‌ ସିଲା ନି ତିମତି ରିଏର୍‌ ବେରିଆଦୁ ତେବାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ପାଉଲ୍‍ତିଙ୍ଗ୍‍ଁ ଅସି ମାର୍ହି ଲୋକୁ ୱାନି ୱାଲେ ଆତେନ୍‍ସ୍‍ ସାନ୍ଦି ସର୍ହାର୍‍ । ଆବେଟ୍‌ତାନ୍‌ ୱାର୍‌ ବେରିଆଦାନ୍‌ ଡ଼େସି ୱାଜି ସିଲା ନି ତିମତିଦିଙ୍ଗ୍‌ ଇର୍ହାର୍‌, ୱାର୍‌ ବେଗି ପାଉଲିତି ୱାଲେ ମିସାପିର୍‌ ଇଜି ପାଉଲ ଆଦେସ୍‌ ସିତାମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ଆତେନ୍‍ସ୍‍ ସିଲା ନି ତିମତିଙ୍ଗ୍‍ଁ କାପ୍‍କିନି ସମୟ୍‍ତୁ ଗାଡ଼୍‌ ଦିୟାମ୍‍କାଙ୍ଗ୍‌ ପୁରାଆତିମାନିକା ସୁଡ଼ୁଜି ପାଉଲ ନାଣ୍ତ ଦୁକ୍‌ ଆତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ଆଦେଙ୍ଗ୍‍ଁ ୱାନ୍‌ ପାର୍‌ତନା ଇଲୁଦୁ ଜିହୁଦି ଲୋକା ୱାଲେ ମାପୁରୁଦି ପାର୍‍ତନାକିନି ଅଣଜିହୁଦିରି ୱାଲେ ଇୟା ବିସୟ୍‌ତାନ୍‌ ସବୁଦିନ୍‍ ୱାର୍‍ଗିଦେଙ୍ଗ୍‍ଁ ଆସ୍‌ତାନ୍‌ । ଗାଡ଼୍‌ତି ଡେଣା ବାଡିଆଙ୍ଗ୍‍ଁ ସନିୱାନିକା ଆଜିମାନି ଲୋକା ୱାଲେ ଆୟା ବିସୟ୍‌ତାନ୍‌ ୱାର୍‍ଗିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ଏସ “ଏପିକ୍ୟୁରିଆନ୍‍ ନି ସ୍ଟୋଇକ୍‍” ସିକିୟା ଗୁରୁରି ୱାଲେ ୱାନି ଆସ୍‌ସିସାତାର୍‌ । ୱାରି ଲୋଇ ଏସଲୋକ୍‌ ଇର୍ହାର୍‌, “ଇୟା ବୁଦିସିଲିକାନ୍‌ ଇନିକା ଇନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ସଲ୍‌ସିନାନ୍‌ ?” ଆଇକାର୍‌ ଇର୍ହାର୍‌, “ଆଇଦେସ୍‍ତି ଦିୟାମ୍‍କା ବିସୟ୍‌ତାନ୍‌ ୱାନ୍‌ ସୁସମାଚାର୍‌ ପ୍ରଚାର୍‌ କିନିକା ୱାଜା ଆଜିନାତ୍‌ ।” ଜିସୁ ନି ୱାନି ମାରିଡ଼େସି ନିଙ୍ଗିଁନି ବିସୟ୍‌ତାନ୍‌ ପାଉଲ ପ୍ରଚାର୍‌ କିନିକା ୱେନ୍‌ଜି ୱାର୍‌ ଇକା ଇର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାର୍‌ ପାଉଲ୍‍ତିଙ୍ଗ୍‍ଁ ଆସ୍‌ତା ଅତାର୍‍ ମାରି ୱାନିଙ୍ଗ୍‌ ଏରିୟ ପାଗସ୍‍ ଦର୍‌ତି ଗାଡ଼୍‌ ମିଟିଙ୍ଗ୍‍ଁତୁ ତାସି ଇର୍ହାର୍‌, “ନିନ୍‌ ଏମେ ପୁନି ସିକିୟା ବିସୟ୍‌ତାନ୍‌ ୱେର୍‌ସିନି, ଆୟା ବିସୟ୍‌ତାନ୍‌ ମାପ୍‌ ନେସ୍‍ତେଙ୍ଗ୍‍ଁ ବଦା କିଜିନାପ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ନିନ୍‌ ୱେର୍‌ସି ମାନି ଏସ ମାଟା ମାଙ୍ଗିଁ କାବା ୱାଜିନାତ୍‍ । ମାପ୍‌ ତାନି ଅର୍ତ ନେସ୍‍ତେଙ୍ଗ୍‌ ବଦାକିନାପ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ଆତେନ୍‍ସ୍‍ତି ଲୋକୁ ମାରି ଆବେ ବାସାକିନି ଆଇଦେସ୍‍ତିକାର୍‍ ପୁନି ବିସୟ୍‌ ୱେନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ନି ଇନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ନାଣ୍ତ ଜିବନ୍‌ ନଜି ମାର୍ହାର୍‌ । ଇବେ ୱାର୍‌ ନାଣ୍ତ ସମୟ ସିଜି ମାର୍ହାର୍ । ");
INSERT INTO kfcp_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ପାଉଲ ଏରିୟ ପାଗସ୍‍ ଗାଡ଼୍‌ ମିଟିଙ୍ଗ୍‍ଁ ଆଗ୍‌ଡ଼ି ନିଲ୍‌ସି ଇର୍ହାନ୍‌, “ଆତେନ୍‍ସ୍‍ତି ବାସାନିଲୋକୁ, ମିର୍‌ ୱିଜେରେ ଦାର୍ମୁ ଲୋକୁ ଜଣା ପଡ଼ାଜିନାତ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ନାନ୍ ମି ଗାଡ଼୍‌ ବୁଲାଜି ସୁଡ଼୍‍ତି ୱାଲେ ମି ପୁଜାକିନି ବାଡିଦୁ ସୁଡ଼ୁତା । ଉନ୍‍ଣ୍ତ୍ରି ପୁଜା ସିନି ବେଦି ମୁସ୍‌କୁ ଉନ୍‍ଣ୍ତ୍ରି ନେସେଇ ମାପୁରୁଦି ଉଦେସ୍‍ତାନ୍‍, ରାସାତି ମାନିକା ବା ସୁଡ଼ୁତା । ମିର୍‌ ନେସ୍‍ଏନ୍‍ଣ୍ତା ଆମା ତାନିଙ୍ଗ୍‍ଁ ପୁଜା କିଜିନିଦେର୍‌, ଇଲେଇ ୱାନି ମାଟା ମି ଲାକ୍‌ତୁ ପ୍ରଚାର୍‌ କିଦେଙ୍ଗ୍‍ଁ ସଲ୍‍ସିନା । ");
INSERT INTO kfcp_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ମାପୁରୁ ଦୁନିଆ ନି ଆବେ ମାନି ୱିଜୁ ବିସୟ୍‌ ତିଆର୍‌ କିତାନ୍‌ । ୱାନ୍‌ ମୁସ୍‌କୁପୁର୍‌ ନି ଦୁନିଆଦି ପ୍ରବୁ । ଲୋକା କିକାଣ୍‍ ତିଆର୍‌ ଆତି ମନ୍ଦିର୍‍କାଙ୍ଗ୍‌ ୱାନ୍‌ ବାସାଏନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ମାଡ୍‌ ୱାନି ଉଣ୍ତିଙ୍ଗ୍‍ଁ ପାଣି କିଜି ୱାନିଙ୍ଗ୍‍ଁ ସିଦେଙ୍ଗ୍‌ ଆଟ୍‍ନିନାନି ଇନି ବିସୟ୍‌ ୱାନ୍‌ ବଦା କିଏନ୍‌; ଇରିଙ୍ଗ୍‍ଁ ୱାନ୍‌ ୱିଜେରିଙ୍ଗ୍‍ଁ ଜିବନ୍‌, ପୁନ୍‍ଣ୍ତା ମାରି ୱିଜୁ ଦର୍‌କାର୍‌ ବିସୟ୍‌ ସିତାମାନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ଅରେନ୍‌ ଲୋକ୍‌ତି ମାଣାନ୍‌ ୱାନ୍‌ ୱିଜୁ ଲୋକୁ ଜାତିଦିଙ୍ଗ୍‍ଁ ତିଆର୍‌ କିତାମାନାନ୍‍ ମାରି ୱାନି ଆଦେସ୍‍ତାନ୍‍ ୱାର୍‌ ଦୁନିଆଦି ନାଣ୍ତ ବାଡିଆଙ୍ଗ୍‍ଁ ବାସାନାର୍‍, ଏମେ ସମୟ୍‍ତୁ, ଏନ୍‌ ଏମେ ବାଡିଦୁ ବାସାନାନ୍‍, ଆଗ୍‌ଡ଼ିରାନ୍‌ ମାପୁରୁ ଆକା ତିଆର୍‌ କିତାମାନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ୱାନି ଉଦେସ୍‌ ମାର୍ହାତ୍‌, ୱିଜେରେ ଏଣ୍ତେସ୍‌ ୱାନିଦି ପୟ୍‌ଜି ୱାନିଙ୍ଗ୍‍ଁ ପୟ୍‌ନାର୍‌ । ମାତର୍‌ ସତ୍‍ତାନ୍‍ ମାପୁରୁ ଆମାୱାନିମାଣାନ୍‍ ଆକ ସିଲେନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ଇୟା ବିସୟ୍‌ତାନ୍‌ ଅରେନ୍‌ ଲୋକୁ ଇର୍ହାମାନାନ୍‌, “ୱାନିମାନୁନେ ମା ଜିବନ୍‌ତି ଜିନିକା, ବୁଲାନିକା ନି ତେବାନିକା ।” ମି ରାସ୍‌ନିୱାରି ଲୋଇ ଏସଲୋକ୍‌ ଇର୍ହାମାନାର୍‌, “ମାପ୍‌ ବା ୱାନି କଡ଼ର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ମାପ୍‌ ମାପୁରୁଦି କଡ଼ର୍‌ ଆତିମାନିଙ୍ଗ୍‌ ଲୋକା ମାଣାନ୍‌ ତିଆର୍‌ଆତି ବାଙ୍ଗାଁରାମ୍‍, ୱେନ୍‍ଣ୍ତି ମାରି କାଲ୍‍ତାନ୍‍ ତିଆର୍‌ଆତି ବମାଦି ରୁପ୍‍ତାନ୍‍ ମାପୁରୁଦି ୱାଜା ଏତ୍‌କିଦେଙ୍ଗ୍‌ ଆଟ୍‌ଏଟ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ଲୋକୁ ମାପୁରୁଙ୍ଗ୍‍ଁ ନେସ୍‍ଇୱାଲେ ୱାନ୍‌ ଆୟା ଦସ୍‌ ଆସ୍‍ଏନ୍‌ ମାର୍ହାନ୍‌, ମାତର୍‌ ଇଲେଇ ଆୟାୱିଜୁ ୱିଜେରିଙ୍ଗ୍‍ଁ ୱାରି ପାପ୍‌ ସାରିଦାନ୍‍ ଡ଼େସିୱାଦେଙ୍ଗ୍‍ଁ ଇଜି ଆଦେସ୍‌ ସିଜିନାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ୱାନ୍‌ ଉନ୍‍ଣ୍ତ୍ରି ଦିନ୍‌ ତିର୍‌ କିତାମାନାନ୍‌ । ଆୟା ଦିନ୍‌ ୱାନ୍‌ ୱାନି ବାସେଆତି ଲୋକ୍‌ତି ମାଣାନ୍‌ ୱିଜୁ ଦୁନିଆଦି ନ୍ୟାୟ୍‌ ବିସାର୍‌ କିନାନ୍‌ । ଆୟା ଲୋକ୍‌ତିଙ୍ଗ୍‌ ସାତିମାଣାନ୍‌ ନିକ୍‍ତି ମାଣାନ୍‌ ୱାନ୍‌ ଇୟା ମାଟାଦି ସତ୍‍ ୱିଜେରରିଙ୍ଗ୍‍ଁ ୱେର୍‍ତା ମାନାନ୍‌ ! ");
INSERT INTO kfcp_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ପାଉଲତିମାଣାନ୍‌ ସାତି ମାଣାନ୍‌ ମାରିଡ଼େସି ନିଙ୍ଗିଁନି ବିସୟ୍‌ ୱେନ୍‌ଜି ୱାରି ଲୋଇ ଏସ ଲୋକୁ ୱାନିଙ୍ଗ୍‍ଁ ସେମାର୍‌କିତାର୍‍, ମାତର୍‌ ଆଇକାର୍‌ ଇର୍ହାର୍‌, “ନିବାଣ୍‍କୁ ଇୟା ବିସୟ୍‌ତାନ୍‌ ମାପ୍‌ ମାରି ଉନ୍‍ଣ୍ତ୍ରି ଦେବା ୱେନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ବଦା କିଜିନାପ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ଆୟା ନାଣ୍ତିରି ମିଟିଙ୍ଗ୍‍ଁ ଡ଼ିସ୍‌ସି ପାଉଲ ସର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ଡାୟୋନିସିଅସ୍‍ ଦର୍‌ତି ମିଟିଙ୍ଗ୍‍ଁତି ଅରେନ୍‌ ଲୋକୁ, ଦାମାରି ଦର୍‌ତି ଅରେତ୍‌ ଆଇ ମାନି ମାରି ଏସ ଲୋକୁ ବିସ୍‌ବାସ୍‌ କିତେ ମାରି ୱାନି ୱାଲେ ମିସାତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ଇୟା ୱେନ୍‌କା ପାଉଲ ଆତେନ୍‍ସ୍‍ ଡ଼ିସ୍‌ସି କରନ୍ତିଦୁ ୱାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ମାରି ୱାନ୍‌ ଆକିଲା ଦର୍‌ତି ଜିହୁଦି ଲୋକ୍‍ତିଙ୍ଗ୍‍ଁ ବେଟ୍‌ଆତାନ୍‌, ପନ୍ତଦୁ ୱାନ୍‌ ଜନମ୍‌ ଆତାମାର୍ହାନ୍‍; ସମ୍ରାଟ କ୍ଳାଡିୟସ୍‍ ୱିଜେରେ ଜିହୁଦି ଲୋକାଙ୍ଗ୍‌ ରୋମ୍ ଡ଼ିସ୍‍ତେଙ୍ଗ୍‍ଁ ଇଜି ଆଦେସ୍‌ ସିତାମାର୍ହାନ୍‍ଆକା, ୱାନ୍‌ ଏସ ଦିନ୍‌ ଆଗ୍‌ଡ଼ି ୱାନି ଆଡ଼୍‌ସି ପ୍ରିସ୍କିଲାଦି ୱାଲେ ଇଟାଲିଦାନ୍‍ ୱାତାମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ପାଉଲ ୱାରିଙ୍ଗ୍‍ଁ ବେଟ୍‌ଆଦେଙ୍ଗ୍‍ଁ ସଲ୍‍ସି ୱାରି ୱାଲେ ବାସାତାନ୍‍, ଇରିଙ୍ଗ୍‍ଁ ୱାନ୍‌ ବା ୱାରିୱାଜା ଗୁଡ଼େଏଙ୍ଗ୍‍ଁ ତିଆର୍‌ କିଜି ଜିଜି ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ଜିହୁଦି ନି ଗ୍ରିକ୍‌ଲୋକା ମନ୍‌ତୁ ପ୍ରବୁଦି ଉଣ୍ତିଙ୍ଗ୍‍ଁ ବିସ୍‌ବାସ୍‌ କିବିସ୍‍ କିଦେଙ୍ଗ୍‍ଁ ଇଜି ୱିଜୁ ରମ୍‌ନି ଦିନ୍‍ତୁ ୱାନ୍‌ ପାର୍‌ତନା ଇଲୁଦୁ ୱାର୍‌ଗିଜି ମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ସିଲା ନି ତିମତି ମାସିଦନିଆଦାନ୍‍ ଡ଼େସି ୱାତି ୱେନ୍‌କା ପାଉଲ ଜିହୁଦି ଲୋକା ଲାକ୍‌ତୁ ଜିସୁଦି ସୁସମାଚାର୍‌ ପ୍ରଚାର୍‌ କିଦେଙ୍ଗ୍‍ଁ ପୁରା ସମୟ୍ ସିତାନ୍‌ ମାରି ଜିସୁଙ୍ଗୁଁ ମସିହ ଇଜି ସାକି ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ମାତର୍‌ ୱାର୍‌ ୱାନି ବିରୁଦ୍‌ତାନ୍‌ ନିନ୍ଦା କିଜି ଇର୍ହାର୍‌, ତାମେ ବାଦା ୱାଜା ୱାନ୍‌ ନିଜେଦି ଆଙ୍ଗିଁଦାନ୍‍ ଦୁଡ଼ି ସାଡ଼୍‍ସି ୱାରିଙ୍ଗ୍‍ଁ ଇର୍ହାନ୍‌, “ମି ନେତେର୍‌ ମି ତାଲା ମୁସ୍‌କୁ ୱାଙ୍ଗିଁତି, ଆରିଙ୍ଗ୍‌ ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ମିର୍‌ ନିଜେ ଦାଇ ଆନିଦେର୍‌ । ନାନ୍ ଇୟାଉଣ୍ତିଙ୍ଗ୍‍ଁ ଦାଇ ସିଲେ । ଆର୍‍ତିଙ୍ଗ୍‍ଁ ନାନ୍ ଅଣଜିହୁଦିରି ମାନୁ ସନା ।” ");
INSERT INTO kfcp_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ଆବେଟ୍‌ ୱାନ୍‌ ୱାରିଙ୍ଗ୍‍ଁ ଡ଼ିସ୍‌ସି ମାପୁରୁଦି ପାର୍‌ତନା କିଜିମାନି ତିତସ୍‍ ଜୁସ୍ତ ଦର୍‌ତି ଅରେନ୍‌ ଅଣଜିହୁଦିଦି ଇଲ୍‌ତୁ ତେବାଦେଙ୍ଗ୍‍ଁ ସର୍ହାନ୍‍ । ଜୁସ୍ତଦି ଇଲୁ ଜିହୁଦି ପାର୍‌ତନା ଇଲୁ ଲାକ୍‌ତୁ ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ଜିହୁଦି ପାର୍‌ତନା ଇଲ୍‍ତି ପେରିକାନ୍‌ କ୍ରିସ୍‍ପସ୍‍ ନି ୱାନି ଇଲ୍‌ତି ୱିଜେରେ ପ୍ରବୁମାନୁ ବିସ୍‍ବାସ୍‍‍ କିତାର୍‍ ମାରି କରନ୍ତିଦି ମାରି ନାଣ୍ତ ଲୋକୁ ପାଉଲଦି ସିକିୟା ୱେନ୍‌ଜି ବିସ୍‌ବାସ୍‌ କିତାର୍‍ ମାରି ଡୁବନ୍‌ ଅତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ଉନ୍‍ଣ୍ତ୍ରି ନାଡ଼ା ପାଉଲ ଉନ୍‍ଣ୍ତ୍ରି ଦର୍ସନ୍‍ ପୟ୍‌ତାନ୍‌, ଦର୍ସନ୍‍ତୁ ପ୍ରବୁ ୱାନିଙ୍ଗ୍‍ଁ ଇର୍ହାନ୍‌, “ତିଲାମା, ପ୍ରଚାର୍‌ କିଜିମାନ୍‌ଆ । ଆବେଟାନ୍‍ ସୁପ୍‌ଚାପ୍‌ ତେବାମା, ");
INSERT INTO kfcp_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ଇରିଙ୍ଗ୍‍ଁ ନାନ୍ ନି ୱାଲେ ଲାକ୍‌ତୁ ଲାକ୍‌ତୁ ମାନା । ଏନ୍‌ ନି କେତି କିଦେଙ୍ଗ୍‍ଁ ଆଟ୍‌ଏନ୍‌, ଇରିଙ୍ଗ୍‍ଁ ଇୟା ଗାଡ଼୍‌ତୁ ନା ନାଣ୍ତ ଲୋକୁ ମାନାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ଆଦେଙ୍ଗ୍‍ଁ ପାଉଲ ଆବେ ମାପୁରୁଦି ବାକ୍ୟ ବିସୟ୍‌ତାନ୍‌ ସିକିୟା ସିଜି ବାର୍‍ସେକ୍‍ ଆଦା ତେବାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ଗାଲିୟୋ ଆକାୟା ରୋମିୟ ସାସନ୍‍କିନିକାନ୍‍ ମାନି ୱେଡ଼ାଦୁ, ଜିହୁଦି ଲୋକୁ ଉଣ୍ତାଜି ପାଉଲତିଙ୍ଗ୍‍ଁ ଆସ୍‌ସି ବିଚାର୍‍ କିନିମାନୁ ଅତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ୱାର୍‌ ଇର୍ହାର୍‌, “ଇୟା ଲୋକୁ ମା ନିୟମ୍‌ ବିରୁଦ୍‍ତି ରିତିଦାନ୍‍ ମାପୁରୁଦି ପାର୍‌ତନା କିଦେଙ୍ଗ୍‍ଁ ଲୋକାଙ୍ଗ୍‌ କାର୍‌ପିସ୍‌ନାନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ପାଉଲ ଇନ୍‌ଡ୍ରେଙ୍ଗ୍‌ ସନିୱାଲେ, ଗାଲିୟୋ ଜିହୁଦିଲୋକାଙ୍ଗ୍‍ଁ ଇର୍ହାନ୍‌, “ଜଦି ଇବେ ଇନି ଦୋସ୍‍ବା ତାଗ୍‌ଇମାଟା ବିସୟ୍‌ ମାନାତ୍‌, ଆର୍‍ତିଙ୍ଗ୍‍ଁ ନି ଉଣ୍ତିଙ୍ଗ୍‍ଁ ତିର୍‌ ଆଜି ନି ମାଟା ୱେନିକା ନା ଉଣ୍ତିଙ୍ଗ୍‍ଁ ଟିକ୍‍ମାଟା ଆନାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ମାତର୍‌ ଇୟା ବାଦା ବିସୟ୍‌ କେବଲ୍‌ ନି ନିଜେଦି ନିତି ନିୟମ୍‌ ବଲ୍ ନି ଦରୁ ଜାଟିଦି ବିସୟ୍‌ ଆତିମାନିଙ୍ଗ୍‌ ନିଜେ ତେନି ବିଚାର୍‌ କିନିକା ନେଗେତ୍‌ । ନାନ୍ ଇୟାନାନି ବିସୟ୍‌, ବିସାର୍‌ କିଏ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ଇକା ଇଜି ୱାନ୍‌ ୱାରିଙ୍ଗ୍‍ଁ ବିଚାର୍‍ କିନି ବାଡିଦାନ୍‌ ସପ୍‍ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ୱାର୍‌ ପାର୍‌ତନା ଇଲ୍‌ତି ପେରିକାନ୍‌ ସୋସ୍ଥନାତିଙ୍ଗ୍‍ଁ ଆସ୍‌ସି ବିଚାର୍‍କିନି ଆଗ୍‌ଡ଼ି ମାଡ୍‌ ଡାକ୍‍ତାର୍‍ । ମାତର୍‌ ଗାଲିୟୋ ଆୟା ଉଣ୍ତିଙ୍ଗ୍‍ଁ ମନ୍‍ ସିଏତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ପାଉଲ କରିନ୍ତିଦୁ ବିସ୍‍ବାସ୍‌ତି ତଡ଼ାନ୍‌କା ୱାଲେ ନାଣ୍ତ ଦିନ୍‌ ତେବାତାନ୍‌ । ୱେନ୍‌କା ୱାରିଙ୍ଗ୍‍ଁ ଡ଼ିସ୍‌ସି ପ୍ରିସ୍କିଲା ନି ଆକିଲା ୱାଲେ ସିରିଆ ତରିନ୍‌ ଏରୁ ନାସି ସର୍ହାର୍‍ । କେଙ୍କ୍ରେୟାଦାନ୍‍ ଏରୁତୁ ନାତେଙ୍ଗ୍‌ ଆରାମ୍‌ କିନି ଆଗ୍‌ଡ଼ି ୱାନି ଉନ୍‍ଣ୍ତ୍ରି ନିୟମ୍‌ ଇସାବ୍‌ତାନ୍‌ ୱାନି ତାଲା ଟାଙ୍ଗୁଁରୁ ଆତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ୱାର୍‌ ଏପିସସ୍‍ତୁ ଇତି ୱେନ୍‌କା ପାଉଲ ପ୍ରିସ୍କିଲା ନି ଆକ୍ୱିଲେଙ୍ଗ୍‍ଁ ପୋକ୍‌ତାନ୍‌ । ୱାନ୍‌ ଆବେ ପାର୍‌ତନା ଇଲୁଦୁ ସଲ୍‍ସି ଜିହୁଦିଲୋକା ୱାଲେ ଦାର୍ମୁ ବିସୟ୍‍ତାନ୍‍ ୱାର୍‍ଗିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ଲୋକୁ ୱାନିଙ୍ଗ୍‍ଁ ମାରି ବେସି ଦିନ୍‌ ତେବାଦେଙ୍ଗ୍‍ଁ ଇର୍ହାର୍‌, ମାତର୍‌ ୱାନ୍‌ ରାଜି ଆଏତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ସନି ୱେଡ଼ାଦୁ ୱାନ୍‌ ୱାରିଙ୍ଗ୍‍ଁ ଇର୍ହାନ୍‌, “ଜଦି ମାପୁରୁଦି ବଦା ତେବାନାତ୍‍, ନାନ୍ ମି ଲାକ୍‌ତୁ ଡ଼େସି ୱାନା ।” ୱେନ୍‌କା ୱାନ୍‌ ଜାହାଜ୍‌ ଏକ୍‌ସି ଏପିସସ୍‍ ଡ଼ିସ୍‌ସି ୱାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ସିସେରିଆଦୁ ଇଜି ଆବେଟାନ୍‍ ୱାନ୍‌ ଜିରୁସାଲାମ୍‍ତୁ ସର୍ହାନ୍‍ ମାରି ମଣ୍ତଲିଦିଙ୍ଗ୍‍ଁ ମାଡ଼ିସ୍‌ କିଜି ଆବେଟାନ୍‍ ଆଣ୍ଟିୟକଦୁ ସର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ଆବେ ଏସ ଦିନ୍‌ ସାନ୍ଧି ମାର୍‌ର୍ହି ୱେନ୍‌କା ମାରି ୱାନ୍‌ ସଲ୍‍ସି ଗାଲାତିୟ ନି ପ୍ରୁଗିଆ ରାଜିଦୁ ମଜାୟ୍‍ ସିଜି ସର୍ହାନ୍‍ ମାରି ସାର୍‍ଦୁ ବିସ୍‍ବାସିରିଙ୍ଗ୍‍ଁ ୱାରି ବିସ୍‌ବାସ୍‌ତୁ ଡାଟ୍‍ ଆଦେଙ୍ଗ୍‍ଁ ଇଜି ୱେଡ଼ିକା କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ଆୟା ସମୟ୍‍ତୁ ଆଲେକ୍‍ଜାଣ୍ତ୍ରିଆ ଆଦୁ ଜନମ୍‌ ଆତିମାର୍‍ଇ ଆପୋଲୋ ଦର୍‌ତି ଅରେନ୍‌ ଜିହୁଦିଲୋକୁ ଏପିସସ୍‍ତୁ ୱାତାନ୍‌ । ୱାନ୍‌ ଅରେନ୍‌ ନେଗି ପ୍ରଚାରକ ନି ଦାର୍ମୁସାସ୍ତ୍ରଦୁ ୱାନି ନାଣ୍ତ ବୁଦି ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ୱାନ୍‌ ପ୍ରବୁଦି ସାରି ବିସୟ୍‌ତାନ୍‌ ସିକିୟା ପୟ୍‍ତାମାର୍ହାନ୍‍ ମାରି ଆତ୍ମାଦୁ ନାଣ୍ତ ୱେଡ଼ିକାଦାନ୍‌ ଜିସୁଦି ବିସୟ୍‌ତାନ୍‌ ସତ୍‌ ସିକିୟା ସିଜି ମାର୍ହାନ୍‍ । ମାତର୍‌ ଇୟା ବିସୟ୍‌ତାନ୍‌ ୱାନ୍‌ କେବଲ୍‌ ଜୋହନତି ଡୁବନ୍‌ ବିସୟ୍‌ ନେସ୍‍ତାମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ପାର୍‌ତନା ଇଲୁଦୁ ୱାନ୍‌ ତିଲାଏନ୍‍ଣ୍ତା ସିକିୟା ସିଦେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ୱାନି ସିକିୟା ୱେନ୍‌ଜି ପ୍ରିସ୍କିଲା ନି ଆକିଲା ୱାନିଙ୍ଗଁ ତାମେ ଇଲ୍‌ତୁ କୁକ୍‌ତା ଅତାର୍‌ ମାରି ଆବେ ୱାନିଙ୍ଗ୍‍ଁ ମାପୁରୁଦି ସାରି ବିସୟ୍‌ତାନ୍‌ ନେଗେନ୍‌ କିଜି ବୁଜାକିତାସିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ୱେନ୍‌କା ଆପଲୋ ଆକାୟା ରାଜିଦୁ ସନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ଇଜି ବଦା କିତାନ୍‍ଆକା, ଏପିସସ୍‍ତି ବିସ୍‌ବାସ୍‌ତି ତଡ଼ାନ୍‌କୁ ୱାନିଙ୍ଗ୍‍ଁ ସାହାଜ୍ୟ କିତାର୍‍ ମାରି ୱାନିଙ୍ଗ୍‍ଁ ୱେଡ଼ିକାଦାନ୍‌ ଆସ୍‍ତେଙ୍ଗ୍‍ଁ ଇଜି ମାଡ଼ିସ୍‌ କିଜି ଆକାୟାଦି ବିସ୍‍ବାସିରିଙ୍ଗ୍‍ଁ ସିଟି ରାସ୍‌ତାନ୍‌ । ୱାନ୍‌ ଆବେ ଇଜି ମାପୁରୁଦି ଦୟାଦାନ୍‍ ବିସ୍‍ବାସି ଆତିମାନି ଲୋକାଙ୍ଗ୍‌ ନାଣ୍ତ ସାହାଜ୍ୟ କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ଜିସୁ ଜେ ମସିହ, ୱାନି ସାକ୍ତିଦି ମାଟାଦିମାଟାଦାନ୍‌ ଦାର୍ମୁସାସ୍ତ୍ରଦାନ୍‍ ଇକା ସତ୍‌ ଇଜି ୱେର୍‍ନିୱାଲେ ୱାନ୍‌ ଜିହୁଦିଲୋକାଙ୍ଗ୍‍ଁ ଆରାକିତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ଆପୋଲୋ କରନ୍ତିଦୁ ମାନିୱାଲେ, ପାଉଲ ଲୋଇ ତରିନ୍‌ ମାନି ରାଜିଙ୍ଗାଁ ବୁଲାଜି ଏପିସସ୍‍ତୁ ଇତାନ୍‌ । ଆବେନୁ ଏସ ସିସୁରିଙ୍ଗ୍‌ ପୟ୍‌ତାନ୍‌, ");
INSERT INTO kfcp_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ୱାନ୍‌ ୱାରିଙ୍ଗ୍‍ଁ ୱେନ୍‌ବାତାନ୍‌, “ବିସ୍‌ବାସ୍‌ କିନି ସମୟ୍‍ତୁ ଇନିକା ମିର୍‌ ପବିତ୍ର ଆତ୍ମା ପୟ୍‍ତିମାର୍ହିଦେର୍‍ ?” ୱାର୍‌ ଇର୍ହାର୍‌ ସିଲେ, “ମାରି ପବିତ୍ର ଆତ୍ମା ଜେ ଏନ୍‌ ମାନାନ୍‌, ଆକାବା ମାପ୍‌ ୱେନ୍‍ଏପ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ପାଉଲ ୱେନ୍‌ବାତାନ୍‌, ଆର୍‍ତିଙ୍ଗ୍‍ଁ ମିର୍‌ ଏମେନାନି ଡୁବନ୍‌ ଆତିମାର୍‌ଇଦେର୍‍ ? ୱାର୍‌ ଇର୍ହାର୍‌, “ଜୋହନତି ଡୁବନ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ପାଉଲ ଇର୍ହାନ୍‌, “ଆମାକାର୍‌ ପାପ୍‌ତାନ୍‌ ମନ୍‍ଡ଼େପ୍‍ତା ମାର୍ହାର୍‌, ଜୋହନତି ଡୁବନ୍‌ ସିଜି ୱାନି ୱେନ୍‌କା ଏନ୍‌ ୱାନାନ୍‌, ଜିସୁଦିମାନୁ ବିସ୍‌ବାସ୍‌ କିଦେଙ୍ଗ୍‍ଁ ଆନାତ୍‌ ଇଜି ଲୋକାଙ୍ଗ୍‌ ଇଜିମାର୍‍ଆନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ୱାର୍‌ ଇକା ୱେନ୍‌ଜି ପ୍ରବୁ ଜିସୁଦି ଦର୍‌ତାନ୍‌ ଡୁବନ୍‌ ଅତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ମାରି ପାଉଲ ୱାରି ମୁସ୍‌କୁ କିୟୁ ଇଟ୍‌ତାନ୍‌, ଆବେଟ୍‌ ପବିତ୍ର ଆତ୍ମା ୱାରି ମୁସ୍‌କୁ ୱାତାତ୍‍, ମାରି ୱାର୍‌ ଆଇ ବାସାଦାନ୍‍ ୱାର୍‍ଗିତାର୍‍ ମାରି ବାକ୍ୟ ପ୍ରଚାର୍‌ କିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ୱାର୍‌ ୱିଜେରେ ବାର୍‍ ଲୋକୁ ମେମାରିର୍‍ ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ୱେନ୍‌କା ପାଉଲ ଜିହୁଦିରି ପାର୍‌ତନା ଇଲୁଦୁ ଡ଼ୁଗୁଜି ମୁନ୍‍ଣ୍ତ୍ରି ଲେଜ୍‌କୁ ସାନ୍ଦି ସାହାସ୍‍ତାନ୍‍ ମାପୁରୁଦି ରାଜି ବିସୟ୍‌ତାନ୍‌ ୱେର୍‌ସି ବିସ୍‌ବାସ୍‌ କିବିସ୍‍ କିଦେଙ୍ଗ୍‍ଁ ସେସ୍ଟା କିଦେଙ୍ଗ୍‍ଁ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ମାତର୍‌ ଏସ୍ତିୱାଲେ ଏସ ଲୋକୁ ଆଟ୍‌ୱା ନି ବିସ୍‌ବାସ୍‌ କିଏନ୍‍ଣ୍ତା ଲୋକା ଆଗ୍‌ଡ଼ି ଆୟା ସାରି ବିସୟ୍‌ତାନ୍‌ ନିନ୍ଦା କିଦେଙ୍ଗ୍‍ଁ ଆସ୍‌ତାର୍‌, ନାସ୍ତିୱାଲେ ୱାନ୍‌ ୱାରିଙ୍ଗ୍‍ଁ ଡ଼ିସ୍‌ସି ସିସୁରିଙ୍ଗ୍‌ ୱେର୍‌ଏ କିତାନ୍‌, ମାରି ଦିନାମି ଟିରାନସ୍‌ ଇଲୁଦୁ ୱାର୍‌ଗିଜିସାଦେଙ୍ଗ୍‌ ଆସ୍‌ତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ଇୟାୱାଜା ଦୁଇ ବାର୍ସୁ ସାନ୍ଦି ସାଲାତାତ୍‍; ଆବେଟ୍‌ ଆସିଆ ବାସାତିମାନି ଜିହୁଦି ଲୋକୁ ନି ଅଣଜିହୁଦି ଲୋକୁ ୱିଜେରେ ପ୍ରବୁଦି ବାକ୍ୟ ୱେର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ମାପୁରୁ ପାଉଲ୍‍ତି ମାଣାନ୍‌ ସାମାନ୍‌ତି କାବାଆନି ପାଣି ୱିଜୁ କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ଇୟାୱାଜା ଜେ ପାଉଲ ଆସ୍‌ସି ମାର୍ହି ରୁମାଲ୍‍ ନି ୱାତିଗନ୍ଦା ରଗିଲୋକାଙ୍ଗ୍‍ଁ ଲାକ୍‌ତୁ ଅତିଙ୍ଗ୍‍ଁ ୱାର୍‌ ନେଗେନ୍‌ ଆଜିମାର୍ହାର୍‍ ମାରି ୱାରି ମେନ୍ଦଲ୍‌ତାନ୍‌ ତାଗ୍‌ଇ ଦୁବେଙ୍ଗ୍‍ଁ ୱିଜୁ ସହସି ସଲ୍‍ସିମାର୍ହେ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ଏସ ବୁଲାନି ଜିହୁଦି ଦୁବେଙ୍ଗ୍‍ଁ ପେର୍‍ନିକାର୍‍ ବା ପ୍ରବୁ ଜିସୁ ଦର୍‌ ଆସ୍‌ସି ଦୁବେଙ୍ଗ୍‍ଁ ଡ଼ିସିସ୍‍ କିଦେଙ୍ଗ୍‍ଁ ସେସ୍ଟା କିତାର୍‍ । ୱାର୍‌ ଦୁବେଆଙ୍ଗ୍‍ଁ ଇଜିମାର୍ହାର୍‍, “ପାଉଲ ପ୍ରଚାର୍‌ କିଜିମାନି ଜିସୁଦି ଦର୍‌ତାନ୍‌ ନାନ୍ ନିଙ୍ଗିଁ ଆଦେସ୍‌ ସିଜିନା ।” ");
INSERT INTO kfcp_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ସ୍କେବା ଦର୍‌ତି ଅରେନ୍‌ ଜିହୁଦି ପେରି ଜାଜକତି ସାତ୍‌ଲୋକ୍‌ ମାରିସିର୍‌ ଇୟାୱାଜା କିଜିମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ମାତର୍‌ ଦୁବା ୱାନିଙ୍ଗ୍‍ଁ ଇର୍ହାତ୍‌, “ନାନ୍ ଜିସୁଙ୍ଗୁଁ ନେସ୍‌ନା ମାରି ପାଉଲ୍‍ତି ବିସୟ୍‌ତାନ୍‌ ନେସ୍‌ନା; ମାତର୍‌ ମିର୍‌ ୱିଜେରେ ଏର୍‌ ?” ");
INSERT INTO kfcp_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ଦୁବା ଆସ୍‌ତି ଲୋକୁ ୱାରିଙ୍ଗ୍‍ଁ ନାଣ୍ତଦାନ୍‌ ରେଲ୍‌ଜି ୱାନିତରିନ୍‍ ଇଟ୍‌ତାନ୍‌ । ୱାରି ଆଙ୍ଗିଁପାସିୟା କିସ୍‍ତାପକ୍‍ତାତ୍‍, ୱାର୍‌ କାଣ୍ତିଆକାବ୍‍ରା ଆଜି ୱାନି ଇଲ୍‌ତାନ୍‌ ଉର୍‍କୁତେ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ଏପିସସ୍‍ତୁ ବାସାନି ଜିହୁଦିଲୋକୁ ନି ଅଣଜିହୁଦିଲୋକ୍‍ ଇୟା ବିସୟ୍‌ତାନ୍‌ ୱେନ୍‌ଜି ତିଲାତାର୍‌ ମାରି ଆବେ ପ୍ରବୁ ଜିସୁଦି ଦର୍‌ ମାରି ନାଣ୍ତଦାନ୍‌ ମାନାନିକା ଆତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ବିସ୍‍ବାସ୍‍ରି ମାଣାନ୍‌ ନାଣ୍ତ ଲୋକୁ ନିଜେଦି ୱିଜୁ ତାଗ୍‌ଇ ପାଣି ୱିଜେରରି ଆଗ୍‌ଡ଼ି ୱେକ୍‍ତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ଗୁଣିଆ ବିଦ୍ୟା ଅଜାନି ନାଣ୍ତ ଲୋକୁ ୱାରି ବଇଙ୍ଗ୍‍ଁ ୱିଜୁ ତାସି ଲୋକା ଆଗ୍‌ଡ଼ି ଉଣ୍ତା କିଜି ଆଡ଼୍‍କ୍‍ତା ପକ୍‌ତାର୍‌ । ୱାରି ଆୟା ବଇଙ୍ଗାଁ ଦାରା ମାର୍ହାତ୍‌ ପଚାସ୍‍ ହଜାର୍‍ ୱେଡି ଡାବୁଙ୍ଗୁଁ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ଇୟାୱାଜା ପ୍ରବୁଦି ବାକ୍ୟ ନାଣ୍ତଦାନ୍‌ ୱେଙ୍ଗିତାସର୍ହାତ୍‌ ମାରି ନାଣ୍ତ ସାକ୍ତିସାଲି ଆତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ଇୟାୱିଜୁ ଗଟନା ୱେନ୍‌କା ପାଉଲ ମାସିଦନିଆ ନି ଆକାୟା ନାମ୍‍ଡ଼ିସିଜି ଜିରୁସାଲାମ୍‍ତୁ ସନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ଇଚ୍ଛା କିତାନ୍‌ । ୱାନ୍‌ ଇର୍ହାନ୍‌, “ଆବେ ସର୍ହି ୱେନ୍‌କା ନାନ୍ ଏଣ୍ତେସ୍‌ବା ରୋମ୍‍ତୁ ବା ସନା ।” ");
INSERT INTO kfcp_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ଆଦେଙ୍ଗ୍‌ ୱାନ୍‌ ୱାନି ସେବାକିନି ରିଏର୍‌ ତଡ଼୍‍ ତିମତି ନି ଏରାଷ୍ଟତିଙ୍ଗ୍‌ ମାସିଦନିଆଦୁ ପକ୍‌ତାନ୍‌, ମାତର୍‌ ନିଜେ ଆସିଆ ଦେସ୍‌ତୁ ମାରି ଏସ ସମୟ ତେବାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ଇୟା ଲୋଇ ପ୍ରବୁ ତର୍‌ତିମାନି ସାରି ବିସୟ୍‌ତାନ୍‌ ଅସି ଏପିସସ୍‍ତୁ ନାଣ୍ତ ଜାଟିଜଗଡ଼ା ଆତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ଦିମତ୍ରିୟ ଦର୍‌ତି ଅରେନ୍‌ ୱେନ୍‍ଣ୍ତି ତିଆର୍‍କିନିକାନ୍‍ ଆର୍ତ୍ତେମି ଦିୟାମ୍‍ ମନ୍ଦିର୍‌ତି ୱେନ୍‍ଣ୍ତି ବମା ରସ୍‍ସି ମାର୍ହାନ୍‍, ଇୟା ପର୍‍ନିମାଣାନ୍‍ ପାଣିକିନିକାର୍‌ ନାଣ୍ତ ଲାବ୍‍ ପୟ୍‍ଜିମାର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ୱାନ୍‌ ସାମାନ୍‌ ବେପାର୍‍କିନିୱାରିଙ୍ଗ୍‍ଁ ଉନ୍‍ଣ୍ତା କିଜି ଇର୍ହାର୍‌, “ଆଜ୍ଞାର୍‌, ଇୟା ବେପାର୍‌ ମାଙ୍ଗିଁ ମାଜନ୍‌ କିତାମାନାନ୍‍ ଇଜି ୱିଜେରେ ନେସ୍‌ନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ଇଲେଇ ଇୟା ପାଉଲ ଇନିକା କିନାନ୍‍; ଆକା ମିର୍‌ ନିଜେ ସୁଡ଼ୁଦେଙ୍ଗ୍‌ ଆଟ୍‍ସିନିଦେର୍‍ ମାରି ୱେନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ଆଟ୍‍ସିନିଦେର୍‍ । ୱାନ୍‌ ଇଜିନାନ୍‌, ଲୋକୁ କିୟୁଦାନ୍‌ ତିଆର୍‌ଆତି ଦିୟାମ୍‍କୁ ୱିଜୁ ମୁଡ଼ୁକେ ଦିୟାମ୍‍କୁ ଆଉ, ମାରି ୱାନ୍‌ ଇବେ ଏପିସସ୍‍ ନି ୱିଜୁ ଆସିଆ ଦେସ୍‌ତୁ ନାଣ୍ତ ଲୋକାଙ୍ଗ୍‌ ଇୟା ବିସୟ୍‌ତାନ୍‌ ବାମ୍‍ରେକିଜିନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ଆବେଟ୍‌ ମା ବେପାର୍‌ ନାସ୍ଟୁ ଆନି ମୁସ୍‌କୁ ମାନାତ୍‌ । କେବଲ୍‌ ଆକାନେ ସିଲେ, ଆମା ଦିୟାମ୍‍ ଆସିଆ ନି ୱିଜୁ ଦୁନିଆଦୁ ୱିଜେରି ମାଣାନ୍‌ ପୁଜା ପୟ୍‌ନାତ୍‌, ଆୟା ପେରି ଆର୍ତ୍ତେମି ଦିୟାମ୍‍ତି ମନ୍ଦିର୍‌ ୱେଙ୍ଗ୍‍ଁଜି ତେବାଏତ୍‍ ନି ମାରି ଆର୍ତ୍ତେମି ଦିୟାମ୍‍ତି ୱେଙ୍ଗିଁନିକା ନାସ୍ଟୁ ଆନାତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ଲୋକୁ ଇୟା ମାଟା ୱେନ୍‌ଜି ରିସା ଆତାର୍‌ ମାରି ଆଉଲି ଆଜି ଇର୍ହାର୍‌, “ଏପିସିୟଦି ଆର୍ତ୍ତେମି ପେରିଦିୟାମ୍‍ତି ଜିଣାନିକା ଆପିତ୍‌ !” ");
INSERT INTO kfcp_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ଇୟା ଜାଟିଜଗଡ଼ା ୱିଜୁ ଗାଡ଼୍‌ତୁ ୱେଙ୍ଗିଁତାସର୍ହାତ୍‍ । ରିସାଆତିମାର୍ହି ଲୋକୁ ପାଉଲ୍‍ତି ୱାଲେମାର୍ହି ମାସିଦୋନିଆଦି ଗାୟସ୍‍ ନି ଆରିସ୍ଟାର୍କସ୍‍ତିଙ୍ଗ୍‍ଁ ଆସ୍‌ସି ୱାରି ଜୁଜ୍‍କିନିବାଡିଦୁ ତର୍‍ତା ଅତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ପାଉଲ ନିଜେ ଲୋକା ଆଗ୍‌ଡ଼ି ନିନ୍‍ଡ୍ରେଙ୍ଗ୍‍ ବଦା କିତାନ୍‌, ମାତର୍‌ ବିସ୍‍ବାସିର୍‍ ୱାନିଙ୍ଗ୍‍ଁ ଇୟାକା କିଦେଙ୍ଗ୍‍ଁ ସିଏତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ଏସ ଲୋକ ଗାଡ଼୍‌ତି ନିଜେଦି ଅଦିକାରି ସଙ୍ଗ୍‌କୁ ପାଉଲ୍‍ତିଙ୍ଗ୍‍ଁ ଜୁଦ୍‌କିନିବାଡି ଲୋଇ ସଲ୍‍ଇ ଉଣ୍ତିଙ୍ଗ୍‍ଁ ମାଡ଼ିସ୍‌ କିଜି ଉନ୍‍ଣ୍ତ୍ରି ମାଟା ପକ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ଇୟା ସମୟ୍ ଲୋଇ ପୁରାମିଟିଙ୍ଗ୍‍ଁ ମାଡ୍‌ଗୋଲ୍‌ତୁ ପୁରା ଆତାତ୍‌ । ଲୋକୁ ଦଲ୍‌ ଦଲ୍‌ ଆଜି ନାଣ୍ତ ଆଉଲି ଆଜିମାର୍ହାର୍‍, ଇରିଙ୍ଗ୍‍ଁ ୱାରି ଲୋଇ ଏସ ଲୋକୁ ୱାରି ଉଣ୍ତାତି ମାର୍ହିକା ମାଟା ବା ନେସ୍‌ଏର୍‌ ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ଲୋକା ଲୋଇ ଏସ ଲୋକୁ ଇର୍ହାର୍‌ ଜେ, ଆଲେକ୍‍ଜାଣ୍ତର୍‍ ଇୟାଉଣ୍ତିଙ୍ଗ୍‍ଁ ଦସ୍‌, ଇରିଙ୍ଗ୍‌ ଜିହୁଦି ଲୋକୁ ୱାନିଙ୍ଗ୍‍ଁ ଆଗ୍‌ଡ଼ି ନିଲ୍‍ପ୍‍ତା ମାର୍ହାର୍‌ । ଆଲେକ୍‍ଜାଣ୍ତର୍‍ କିୟୁ ପେର୍‌ଜି ଲୋକାଙ୍ଗ୍‌ ଆଲ୍‍ଜ ମାନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ଇଜି ଜୁଟ୍‍ତାନ୍‍ ମାରି ବିସ୍‍ବାସ୍‌ରି ତରିନ୍‌ ବାସଣ ସିଜି ବୁଜାକିଦେଙ୍ଗ୍‍ଁ ସେସ୍ଟା କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ମାତର୍‌ ୱାନ୍‌ ଅରେନ୍‌ ଜିହୁଦି, ଇକା ନେସ୍‌ସି ୱାର୍‌ ୱିଜେରେ ଅର୍‌ସେ ଆଉଲି ଆତାର୍‌, “ଏପିସସ୍‍ତି ଆର୍ତ୍ତେମି ପେରିଦିୟାମ୍‍ତି ଜୟ୍‌ ଆପିତ୍‌ !” ଦୁଇ ଗଣ୍ଟା ଆସ୍‌ସି ଇୟାୱାଜା ଆଉଲି ଆଜିମାର୍‌ର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ସାରାସାରି ଗାଡ଼୍‌ତି ପେରିକାନ୍‌ ଲୋକାଙ୍ଗ୍‌ ଆଲେଜ ମାନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ଇଜି ଇର୍ହାନ୍‌, “ଏପିସିୟଦୁ ବାସାନି ତଡ଼ାନ୍‌କୁ ୱିଜେରେ ନେସ୍‍ନାର୍‍ ଜେ, ଏପିସସ୍‍ ଗାଡ଼୍‌ତି ପେରି ଦିୟାମ୍‍ ଆର୍ତ୍ତେମି ମନ୍ଦିର୍‌ ନି ବାଦଡ଼୍‍ତାନ୍‍ ଆର୍‍ତି ୱାତିମାନି ପବିତ୍ର ବମାଦି ରକ୍ଷା ଆଜି ୱାଜିନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ଇକା ଏନ୍‌ ସିଲେ ଇନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ଆଟ୍‌ଏନ୍‌ । ଆଦେଙ୍ଗ୍‌ ମିର୍‌ ୱିଜେରେ ଆଲେଜ ମାନ୍‌ଡ୍ରୁ । ଇନି ତାଗ୍‌ଇ ପାଣି କିମାଟ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ଇୟା ଲୋକୁ ମନ୍ଦିର୍‌ତାନ୍‌ ଇନିକା ଡଙ୍ଗାଁ କିଏର୍‌, ମାରି ମା ଦିୟାମ୍‍ତି ବିରଦ୍‌ତାନ୍‌ ଇନି ନିନ୍ଦା ମାଟା ଇନ୍‌ଏର୍‌ । ଆରିଙ୍ଗ୍‍ବା ମିର୍‌ ୱେରିଙ୍ଗ୍‍ଁ ଆସ୍‌ସି ତାତିମାନିଦେର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ଦିମତ୍ରିୟ ନି ୱାନି ପାଣିକିନିୱାରି ଏ ବିରଦ୍‌ତାନ୍‌ ଇନି ମାଟା ମାନାତ୍‌, ତାନି ବିସାର୍‌ କିଦେଙ୍ଗ୍‍ଁ ମା ପେରିକାର୍‌ ମାନାର୍‌ ମାରି ବିସାର୍‌ ଇଲ୍‍ତି ଟିକ୍‌ ଦିନ୍‌ ୱିଜୁ ମାନାତ୍‌ । ଆବେ ଆୟା ମାଟା ୱେର୍‌ତେଙ୍ଗ୍‌ ଆଦେଙ୍ଗ୍‌ ଆଟ୍‍ନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ଜଦି ତେନିମାଣାନ୍‍ ମାରି ନାଣ୍ତ ଇନିକା ବଦା କିତିଙ୍ଗ୍‍ଁ, ଆର୍‍ତିଙ୍ଗ୍‍ଁ ଲୋକାମାଣାନ୍‌ ନିୟମ୍‌ ଆତିମାନି ଉନ୍‍ଣ୍ତ୍ରି ମିଟିଙ୍ଗ୍‍ଁତୁ ତାନି ପୁରା ଅଆୟ୍‍ ଆଦେଙ୍ଗ୍‍ଁ ଆଟ୍‍ନାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ନେର୍‌ ଆମାକା ଗଟାତାମାନାତ୍‍, ଆବେ ମା ବିରଦ୍‌ତାନ୍‌ ଜାଟିଜଗଡ଼ା ଗଟେକିନି ମାଟାଦି ଆସା ମାନାତ୍‌, ମାଡ୍‌ ଇୟାୱିଜୁ ଜାଟିଦାନ୍‍ ଇନି ଟିକ୍‌ ମାଟା ୱେର୍‍ତେଙ୍ଗ୍‍ଁ ଆଟ୍‍ଏପ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ଇୟାୱିଜୁ ମାଟା ଇଜି ୱାନ୍‌ ଲୋକାଙ୍ଗ୍‌ ସାନ୍ତି କିଜି ମିଟିଙ୍ଗ୍‍ଁ ବନ୍ଦ କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ଜାଟିଜଗଡ଼ା ୱିଜିତି ୱେନ୍‌କା ପାଉଲ ବିସ୍‍ବାସିରିଙ୍ଗ୍‍ଁ ଉଣ୍ତା କିଜି ୱେଡ଼ିକାଦି ମାଟା ୱେନିସ୍‍କିତାନ୍‍ । ୱାରି ମାଣ୍‌କୁ ସଲ୍‍ସି ୱାନ୍‌ ମାସିଦନିଆଦୁ ସର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ୱାନ୍‌ ୱିଜୁ ରାଜି ସିଜି ସର୍ହାନ୍‍ ମାରି ନାଣ୍ତ ନେଗିମାଟା ୱେର୍‌ସି ଲୋକାଙ୍ଗ୍‌ ୱେଡ଼ିକା କିତାନ୍‌ । ତାନେୱେନ୍‌କା ୱାନ୍‌ ଗ୍ରିସ୍‌ ଦେସ୍‌ତୁ ଇତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ଆବେ ମୁନ୍‍ଡ୍ରି ଲେଜ୍‌କୁ ତେବାତାନ୍‍ । ୱାନ୍‌ ସିରିଆଦୁ ସନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ତିଆର୍‌ ଆନିୱାଲେ ଜିହୁଦିଲୋକୁ ୱାନି ବିରଦ୍‌ତାନ୍‌ ଉପାୟ କିଜିନାର୍‍ ଇଜି କାବୁର୍‌ ପୟ୍‌ଜି ମାସିଦନିଆ ସାରିତରିନ୍‍ ଡ଼େସି ସନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ଅଡ଼୍‍ବିତାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ବେରିଆଦୁ ବାସାନି ପୁରୁଦି ମାରିସି ସୋପାତ୍ର, ତେସଲନିକିଆଦି ଆରିସ୍ଟାର୍କସ୍‍ ନି ସେକୁନ୍ଦ, ଦର୍ବିଦି ଗାୟ, ଆସିଆ ଦେସ୍‌ତି ତୁକିକ ନି ତ୍ରପିମ, ମାରି ତିମତି ୱାନି ୱାଲେ ସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ୱାର୍‌ ଆଗ୍‌ଡ଼ିରାନ୍‌ ସଲ୍‍ସି ତ୍ରୋୟାଦୁ ମାଙ୍ଗିଁ କାପ୍‍କିତା ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","କମିର୍‌ସିଲି ରୁଟି ପଣ୍ତୟ୍‌ତି ୱେନ୍‌କା ମାପ୍‌ ପିଲିପି ଗାଡ଼୍‌ତାନ୍‍ ଏରୁ ନାସି ପାସ୍‌ ଦିନ୍‍ ୱେନ୍‌କା ତ୍ରୋୟାଦୁ ୱାରି ୱାଲେ ମିସାତାପ୍‍ ମାରି ଆବେ ଉନ୍‍ଣ୍ତ୍ରି ୱାରା ତେବାତାପ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ୱାରାଦି ଆଗ୍‌ଡ଼ିରି ନାଣ୍ତିଙ୍ଗ୍‌ ମାପ୍‌ ଅର୍‌ସେ ଉଣି ବଜୋଦୁ ଉଣ୍ତାତାପ୍‍ । ପାଉଲ ଲୋକାଙ୍ଗଁ ମାଜ୍‌ରାନାଡ଼ା ସାନ୍ଦି ମାଟା ୱେର୍‍ତାନ୍‍, ଇରିଙ୍ଗ୍‍ଁ ମାର୍‍ନାଣ୍ତିଙ୍ଗ୍‍ଁ ୱାନ୍‌ ଆୟା ବାଡି ଡ଼ିସ୍‍ତେଙ୍ଗ୍‍ଁ ସଲ୍‍ସିମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ଆମା ମୁସ୍‌କୁରି ମହଲାଦୁ ମାପ୍‌ ମିଟିଙ୍ଗ୍‍ଁ କିଜିମାର୍ହାପ୍‍, ଆବେ ନାଣ୍ତ ଦିୱେଙ୍ଗ୍‌ କାସ୍‍ସି ମାର୍ହେ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ଆବେ ଇଉଟିକସ୍‍ ଦର୍‌ତି ଅରେନ୍‌ ମୁରୁଲି ଜରକା ଲାକ୍‌ତୁ ବାସ୍‍ତାମାର୍ହାନ୍‍, ପାଉଲ ମାଟା ଇନି ସମୟ୍‍ତୁ ୱାନିଙ୍ଗ୍‍ଁ ସୁସ୍‍କାଣ୍‍କୁ ୱାଦେଙ୍ଗ୍‌ ଆସ୍‍ତେ । ୱାନ୍‌ ନାଣ୍ତ ସୁଜ୍‍ଜି ମୁନ୍‍ଣ୍ତ୍ରି ମହଲା ମୁସ୍‌କୁରାନ୍‌ ଆଡ୍‍ଗି ଆର୍‍ତାନ୍‍ । ୱାର୍‌ ୱାନିଙ୍ଗ୍‍ଁ ନିକିନିୱାଲେ ୱାନ୍‌ ସାତା ସର୍ହାମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ମାତର୍‌ ପାଉଲ ଆଡ୍‍ଗି ରେସି ୱାଜି ୱାନିଙ୍ଗ୍‍ଁ ପମ୍‌ଜି ଆସ୍‌ସି ଇର୍ହାନ୍‌, “ଦାନ୍ଦା ଆମାଟ୍‍ । ୱାନ୍‌ ଜିତାମାନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ତାନିୱେନ୍‍କା ୱାନ୍‌ ମୁସ୍‌କୁ ଡ଼େସି ସଲ୍‍ସି ରୁଟି ରୁକ୍‍ସି ତିର୍‍ଆନ୍‍ ମାରି ୱେଡ଼ା ସନି ସାନ୍ଦି ୱାରି ୱାଲେ ନାଣ୍ତ ୱାର୍‌ଗିଜି ଆବେଣାନ୍‍ ସର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ଲୋକୁ ମୁରୁଲି କଡ଼ଦିଙ୍ଗ୍‍ଁ ଜିତିମାନିକା ସୁଡ଼୍‌ଜି ୱାନି ଇଲ୍‌ତୁ ଅତାର୍‌ ମାରି ନାଣ୍ତ ୱେଡ଼ିକା ପୟ୍‌ତାର୍‌ ! ");
INSERT INTO kfcp_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ମାପ୍‌ ଆଗ୍‌ଡ଼ିରାନ୍‌ ଜାହାଜ୍‍ତୁ ଏକ୍‌ସି ଆସୋସ୍‍ତୁ ସର୍ହାପ୍‍ । ଆବେଣାନ୍‍ ମାପ୍‌ ପାଉଲ୍‍ତିଙ୍ଗ୍‍ଁ ଜାଜ୍‍ତୁ ଅତେଙ୍ଗ୍‍ଁ ମନ୍‍ କିତାମାର୍ହାପ୍‍, ଇରିଙ୍ଗ୍‍ଁ ୱାନ୍‌ ସାରିବୁଲାଜି ଆୟା ବାଡିଦୁ ଇନାନ୍‌ ଇଜି ଇର୍ହାମାର୍ହାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ୱାନ୍‌ ଏସ୍ତିୱାଲେ ମାଙ୍ଗିଁ ଆସୋସ୍‍ତୁ ବେଟ୍‌ଆତାନ୍‌, ମାପ୍‌ ୱାନିଙ୍ଗ୍‍ଁ ଜାହାଜ୍‍ତୁ ଅସି ମିତିଲିନିଦୁ ସର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ଆବେଣାନ୍‍ ମାରି ସଲ୍‍ସି ମାର୍‍ନାଣ୍ତିଙ୍ଗ୍‍ଁ କିଅସ୍‍ ଲାକ୍‌ତୁ ଇତାପ୍‍ । ମାରି ଉଣ୍ତ୍ରି ଦିନ୍‍ତି ୱେନ୍‌କା ମାପ୍‌ ସାମସ୍‍ତୁ ଇତାପ୍‌, ମାର୍‍ନାଣ୍ତିଙ୍ଗ୍‍ଁ ମିଲିଟସ୍‍ତୁ ଇତାପ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ଆସିଆ ରାଜିଦୁ ମାରି ନାଣ୍ତ ସମୟ୍ ତେବାଏନ୍‍ଣ୍ତା ଏପିସସ୍‍ ପାଡ଼ି ପାଡ଼ି ଜାହାଜ୍‌ ସାଲାକିଦେଙ୍ଗ୍‍ଁ ପାଉଲ ମନ୍‍ କିତାନ୍‌ । ଜଦି ଆତିଙ୍ଗ୍‍ଁ, ପେଣ୍ଟିକସ୍ଟ ନାଣ୍ତିଙ୍ଗ୍‍ଁ ଜିରୁସାଲାମ୍‍ତୁ ଇଦେଙ୍ଗ୍‍ଁ ଇଜି ୱାନ୍‌ ଦାନ୍ଦା ଆଜିମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ମିଲିଟସ୍‍ତାନ୍‌ କାବୁର୍‌ ପୋକ୍‌ସି ଏପିସିୟ ମଣ୍ତଲିଦି ପେରି ନେତାର୍‍ରିଙ୍ଗ୍‌ ୱାନି ୱାଲେ ମିସାଦେଙ୍ଗ୍‍ଁ ପାଉଲ କୁକିସ୍‍ କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ୱାର୍‌ ୱାଜି ଉଣ୍ତାତାର୍‌ଆକା ପାଉଲ ଇର୍ହାନ୍‌, “ଆସିଆ ରାଜିଦୁ ଇନି ପାର୍‍ତୁମ୍‍ ଦିନ୍‍ତାନ୍‍ ନାନୁ ଏଣ୍ତେସ୍‌ ମି ୱାଲେ ଏସ ସମୟ ତେବାତା ମାର୍ହା, ଆକା ମିର୍‌ ନେସ୍‌ନିଦେର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ଜିହୁଦି ଲୋକା ଉପାୟ୍‍ତି ଉଣ୍ତିଙ୍ଗ୍‍ଁ ନାଙ୍ଗିଁ ଏମେ ୱିଜୁ ଦୁକ୍‍କାସ୍ଟୁ ବଗାଦେଙ୍ଗ୍‍ଁ ପଡ଼ାତାତ୍‍, ତାନି ଲୋଇ ନାନୁ ପ୍ରବୁଦି ସେବାକିନି ୱାଜା ଆଡ଼୍‌ବାଜି ସାନ୍ତିଦାନ୍‌ ପାଣି କିତାମାନା । ");
INSERT INTO kfcp_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ମିର୍‌ ନେସ୍‌ନିଦେର୍‌ ଜେ, ନାନୁ ଲୋକାମାନୁ ପ୍ରଚାର୍‌ କିନିୱାଲେ ମାରି ମି ଇଲ୍‌କାଙ୍ଗ୍‌ ସିକିୟା ସିନିୱାଲେ ମି ନେଗେନ୍‌ ଆନି ୱାଜା ଇନି ବିସୟ୍‌ ୱେକ୍‍ତେଙ୍ଗ୍‍ ୱେନ୍‌କା ଗୁସାଏମାର୍ହା । ");
INSERT INTO kfcp_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ଜିହୁଦିଲୋକୁ ନି ଅଣଜିହୁଦି ଲୋକୁ ୱିଜେରିଙ୍ଗ୍‍ ନାନୁ ଆଟ୍‌ୱା ଜାଗାର୍‌ତା ସାକି ସିତାମାର୍ହା ଜେ, ୱାର୍‌ ପାପ୍‌ତାନ୍‌ ଡ଼େସି ଏତ୍‌କିଜି ମାପୁରୁ ତରିନ୍‌ ମନ୍‍ ସିନାର୍‍ ମାରି ପ୍ରବୁ ଜିସୁଦିମାନୁ ବିସ୍‌ବାସ୍‌ କିନାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ଇଲେଇ ପବିତ୍ର ଆତ୍ମାଦି ମାଟା ମାନାଜି ନାନୁ ଜିରୁସାଲାମ୍‍ତୁ ସଲ୍‍ସିନା, ନେସେଏ ଆବେନ୍‌ ନାନ୍‌ ଇନିକା ଆନାତ୍‌ନୋ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ପବିତ୍ର ଆତ୍ମା ନାଙ୍ଗିଁ ଜାଗାର୍‌ତା କିତା ସିତାମାନାତ୍‍ ଜେ ୱିଜୁ ଗାଡ଼୍‍କାଙ୍ଗ୍‍ଁ ନାନୁ ଜଇଲ୍‍ସଲ୍‍ସି କାସ୍ଟୁ ପୟ୍‍ନା । ");
INSERT INTO kfcp_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ମାତର୍‌ ନା ଉଣ୍ତିଙ୍ଗ୍‌ ନା ନିଜେ ଜିବନ୍‍ତିଙ୍ଗ୍‍ଁ ନାନୁ ଇସ୍ରିକା ଇଜି ଅଡ଼୍‍ବିନା । ମାପୁରୁଦି ଦୟା ବିସୟ୍‌ତାନ୍‌ ପ୍ରବୁ ଜିସୁ ଏମେ ମାଟା ୱେର୍‌ତେଙ୍ଗ୍‌ ଇଜି ନାଙ୍ଗିଁ ସେବା ଦାୟିତ ସିତାମାନାନ୍‌, ଆକା ପୁରା କିଦେଙ୍ଗ୍‌ ଇଜିନା ସୁସମାଚାର୍ ପ୍ରଚାର୍‌ ପାଣି ସାକି ପୁରା କିନା, ନିସନେ ନା ବଦା । ");
INSERT INTO kfcp_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“ମାପୁରୁଦି ରାଜି ବିସୟ୍‌ତାନ୍‌ ପ୍ରଚାର୍‌ କିଦେଙ୍ଗ୍‌ ଇଜି ନାନୁ ମି ୱିଜେରି ଲାକ୍‌ତୁ ସଲ୍‍ସିନା । ଇଲେଇ ସୁଡ଼ୁଦୁ, ନାନୁ ନେସ୍‌ନା ଜେ, ମି ମାଣାନ୍‌ ଏନ୍‌ ନାଙ୍ଗିଁ ମାରି ସୁଡ଼ୁଏନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ଆଦେଙ୍ଗ୍‌ ନେର୍‍ରି ଇୟା ସୁଜଗଦୁ ନାନୁ ଆଟ୍‍ୱାଦାନ୍‍ ମି ଲାକ୍‌ତୁ ୱେର୍‌ସିନା ଜେ, ଜଦି ମି ଲୋଇରାନ୍‌ ଏନ୍‌ ନାସ୍ଟୁ ଆନାନ୍‌, ଆୟାଉଣ୍ତିଙ୍ଗ୍‌ ନାନୁ ଦାଇ ସିଲେ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ଇରିଙ୍ଗ୍‌ ମାପୁରୁଦି ୱିଜୁ ଉଦେସ୍ ମି ଲାକ୍‌ତୁ ୱେର୍‌ତେଙ୍ଗ୍‌ ନାନୁ ୱେନ୍‌କା ଗୁସାଏ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ମାରି ମିର୍‌ ନେତା ୱାଜା ନିଜେଦି ବିସୟ୍‌ତାନ୍‌ ମାରି ପବିତ୍ର ଆତ୍ମା ମି ଜାତୁନ୍‍ ଅତେଙ୍ଗ୍‌ ଏମେ ବିସ୍‍ବାସି ମାନ୍ଦାଦିଙ୍ଗ୍‍ ଡ଼ିସ୍‍ତା ସିତାମାନାନ୍‌, ଆୟା ୱିଜେରି ବିସୟ୍‌ତାନ୍‌ ଜାତୁନ୍‍ ଆଆ । ମେଣ୍ତା ଗାଉଡ଼ୁ ୱାଜା ମାପୁରୁଦି ମଣ୍ତଲିଦି ଜାତୁନ୍‍ ଅଆ । ଆୟା ମଣ୍ତଲିଦିଙ୍ଗ୍‍ ୱାନ୍‌ ୱାନି ମାରିସିଦି ନେତେର୍‌ତି ମାଣାନ୍‌ ନିଜେଦିକା କିତାମାନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ନାନୁ ନେସ୍‌ନା, ନାନୁ ସର୍‍ରି ୱେନ୍‌କା ମି ଲୋଇ ବୟ୍‍ଙ୍କାର୍‍ ବେନ୍‍ଡ୍ରରକିଙ୍ଗ୍‍ ୱାନେ ମାରି ମାନ୍ଦାଦିଙ୍ଗ୍‍ କାଣ୍ତିଆକାବ୍‍ରା କିଏନ୍‍ଣ୍ତା ଡ଼ିସ୍‍ଉ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ସମୟ୍ ୱାନାତ୍‍, ଏସ୍ତିୱାଲେ ମି ନିଜେଦି ଦଲତୀ ଏସ ଲୋକୁ ବିସ୍‍ବାସିରିଙ୍ଗ୍‍ ମିଚ୍‌ ମାଟା ୱେର୍‌ସି ତାଗ୍‌ଇ ସାରିଦୁ ଅନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ନାସ୍ତିୱାଲେ ଜାଗାର୍‌ତା ମାନ୍‌ଡ଼୍ରୁ, ନାନୁ ଜେ ୱେଡ଼େ ନାଡ଼ା କାଣେରୁଙ୍ଗୁଁ ୱାକ୍‍ସି ମୁନ୍‍ଣ୍ତ୍ରି ବାର୍‍ସେକ୍‍ ସାନ୍ଦି ମି ୱିଜେରିଙ୍ଗ୍‍ ସିକିୟା ସିତାମାନା, ଇୟା ମାଟା ମନ୍‌ତୁ ଇଡ୍‌ଦୁ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“ଇଲେଇ ନାନୁ ମିଙ୍ଗିଁ ମାପୁରୁଦି କିୟୁଦୁ ମାରି ୱାନି ଦୟାଦୁ ପୁରାତି ବାକ୍ୟଦୁ ସର୍ପେ କିଜିନା, ଆୟା ବାକ୍ୟ ମିଙ୍ଗିଁ ବପୁ କିଦେଙ୍ଗ୍‌ ଇଜି ମାପୁରୁଦି ଲୋକା ଉଣ୍ତିଙ୍ଗ୍‌ ମାନି ୱିଜୁ ଆର୍ସିବାଦ୍‌ ମିଙ୍ଗିଁ ସିଦେଙ୍ଗ୍‍ ଇଜି ଆଟ୍‍ନା । ");
INSERT INTO kfcp_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ନାନୁ ଏ ୱେଣ୍ତି, ବାଙ୍ଗାଁରାମ୍‍ ମାରି ୱାତିଗନ୍ଦା ପୟ୍‌ଦେଙ୍ଗ୍‌ ଆସା ଇଡ୍‍ଏ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ମିର୍‌ ନେସ୍‌ନିଦେର୍‌, ନାନୁ ନା ଇୟା ରୁଣ୍ତି କିକାଣ୍‍କୁ ପାଣି କିଜି ନିଜେଦି ମାରି ନା ୱାଲେ ପାଣିକିନିୱାରି ୱିଜୁ ଦର୍‌କାର୍‌ ପୁରା କିତାମାନା । ");
INSERT INTO kfcp_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","ପୟ୍‌ନି ମାଣାନ୍‌ ଦାନ୍‌ କିନିମାନୁ ନାଣ୍ତ ୱେଡ଼ିକା ତେବାନାତ୍‍, ନିଜେ ପ୍ରବୁ ଜିସୁଦି ଇୟା ବାକ୍ୟଦିଙ୍ଗ୍‍ ଏତ୍‌କିଜି ଇୟାୱାଜା ନାଣ୍ତ କାସ୍ଟୁଦି ପାଣିଦାନ୍‌ ମାପ୍‌ ଆଟ୍‍ଇ ଲୋକାଙ୍ଗ୍‌ ସାକା କିନି ଦର୍‌କାର୍‌, ଇୟା ବିସୟ୍‌ତାନ୍‌ ନାନୁ ୱିଜୁଦିନ୍‌ ମିଙ୍ଗିଁ ସାରି ତର୍‍ତାମାନା ।” ");
INSERT INTO kfcp_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ଇୟାୱିଜୁ ମାଟା ୱେର୍‌ତି ୱେନ୍‌କା ପାଉଲ ୱାରି ୱାଲେ ମେଣ୍ତେଙ୍ଗ୍‍ ଗଟ୍‌କିଜି ପାର୍‌ତନା କିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ୱିଜେରେ ଆଡ଼୍‌ବାଜି ଆଡ଼୍‌ବାଜି ପାଉଲତିଙ୍ଗ୍‌ ପମ୍‍ଜି ନଣ୍ତ୍‍ଜି ପୋକ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ମାରି ସୁଡ଼୍‍ଦେଙ୍ଗ୍‍ ଆଟ୍‍ଏର୍‍ ଇଜି ୱାନ୍‌ ଇର୍ହାନ୍‍ଆକା ୱାର୍‌ ନାଣ୍ତ ଦୁକ୍‍ ଆତାମାର୍ହାର୍‍ । ୱାର୍‌ ୱାନିଙ୍ଗ୍‌ ପୋକ୍‌ତେଙ୍ଗ୍‌ ଇଜି ଜାହାଜ୍‌ ଲାକ୍‌ତୁ ସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ୱାରିଙ୍ଗ୍‌ ପୋକ୍‍ତି ୱେନ୍‌କା ମାପ୍‌ ଆବେଣାନ୍‍ ସର୍ହାପ୍‍ । ଏରୁସାରି ନାସି ମାପ୍‌ କୋସ୍‍ତୁ ଇତାପ୍‍ । ମାରିନାଣ୍ତିଙ୍ଗ୍‍ ରୋଡସ୍‍ ପାଡ଼ି ସିଜି ପାତାରାଦୁ ସର୍ହାପ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ଆବେଣାନ୍‍ ପିନିସିଆଦୁ ସଲ୍‌ସିମାନି ଉନ୍‍ଣ୍ତ୍ରି ଜାହାଜ୍‌ ଏକ୍‌ସି ସର୍ହାପ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ତାନିୱେନ୍‍କା ସାଇପ୍ରସ୍‍ ତର୍‍ଜିମାନି ଉନ୍‍ଣ୍ତ୍ରି ବାଡିଦୁ ଇତାପ୍‍ । ଆବେଣାନ୍‍ ତାନି ଡେବିରି ତରିନ୍‌ ସିଜି ମାପ୍‌ ସିରିଆଦୁ ସର୍ହାପ୍‍ । ମାପ୍‌ ସୋର ଗାଡ଼୍‌ତୁ ଜାହାଜ୍‍ତାନ୍‍ ରେତାପ୍‍, ଇରିଙ୍ଗ୍‌ ଇୟା ଜାହାଜ୍‍ତାନ୍‍ ସାମାନ୍‍ପତର୍‌ ରେପ୍‍ନିକା ମାର୍ହାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ଆବେ ମାପ୍‌ ଏସ ବିସ୍‍ବାସିରିଙ୍ଗ୍‍ ସୁଡ଼୍‌ଜି ୱାରି ୱାଲେ ଉନ୍‍ଣ୍ତ୍ରି ସାତା ତେବାତାପ୍‍ । ପବିତ୍ର ଆତ୍ମାଦି ଆଦେସ୍‌ ପୟ୍‌ଜି ୱାର୍‌ ପାଉଲ୍‍ତିଙ୍ଗ୍‍ ଜିରୁସାଲାମ୍‍ତୁ ସନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ତେବାକିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ମାତର୍‌ ୱାରି ୱାଲେ ଉନ୍‍ଣ୍ତ୍ରି ସାତା ତେବାତି ୱେନ୍‌କା ମାପ୍‌ ୱାରିଙ୍ଗ୍‌ ଡ଼ିସ୍‌ସି ନିଜେଦି ସାରିଦୁ ସର୍ହାପ୍‍ । ମାଙ୍ଗିଁ ଡ଼ିସ୍‌ତେଙ୍ଗ୍‌ ଇଜି ୱାର୍‌ ୱିଜେରେ ନିଜେଦି ଆଡ଼୍‍ସିକ୍‍ ମାରି କଡ଼ରି ୱାଲେ ଗାଡ଼୍‌ ଆତ୍‌ରେ ମାନି ସାମ୍‌ଦୁର୍‌ ପାଡ଼ି ସାନ୍ଦି ୱାତାର୍‌ । ଆବେ ମାପ୍‌ ୱିଜେରେ ମେଣ୍ତେଙ୍ଗ୍‍ ଗଟ୍‌କିଜି ପାର୍‌ତନା କିତାପ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ତାନିୱେନ୍‍କା ମାପ୍‌ ୱାରିଙ୍ଗ୍‍ଁ ପୋକ୍‌ସି, ଜାହାଜ୍‍ତୁ ଏକ୍‌ତାପ୍‍, ୱାର୍‌ ଇନ୍‌ଡ୍ର ଡ଼େସି ସର୍ହାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ମାପ୍‌ ସୋର ଗାଡ଼୍‌ତାନ୍‍ ଏରୁ ନାସି ୱିଜ୍‍ଜି ପତଲମାଇଦୁ ଇତାପ୍‍, ଆବେ ବିସ୍‍ବାସ୍‌ତି ତଡ଼ାନ୍‌କାଙ୍ଗ୍‌ ମାଡ଼ିସ୍‍କିଜି ୱାରିୱାଲେ ଉନ୍‍ଣ୍ତ୍ରି ଦିନ୍‌ ତେବାତାପ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ମାରିନାଣ୍ତିଙ୍ଗ୍‍ ମାପ୍‌ ଆୟା ବାଡି ଡ଼ିସ୍‌ସି କାଇସରିଆଦୁ ଇତାପ୍‍ । ଆବେ ମାପ୍‌ ପ୍ରଚାର୍‌କିନି ପିଲିପିତି ଇଲ୍‌ତୁ ତେବାତାପ୍‍, ଜିରୁସାଲାମ୍‍ତୁ ସେବକ ୱାଜା ବାସେଆତି ମାନି ସାତ୍ ଲୋକା ଲୋଇ ୱାନ୍‌ ଅରେନ୍‌ ମାର୍ହାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ୱାନି ନାଲ୍‍ଗି ପେଡ଼ିଆଇ ଆଇଲିକ୍‌ ମାପୁରୁଦି ବାକ୍ୟ ୱେର୍‌ସି ମାର୍ହେ । ");
INSERT INTO kfcp_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ମାପ୍‌ ଆବେ ନାଣ୍ତ ଦିନ୍‌ ତେବାତି ୱେନ୍‌କା, ଜିହୁଦା ଦେସ୍‌ତାନ୍‍ ଆଗାବ ଦର୍‌ତି ଅରେନ୍‌ ବାବବାଦି ଆବେ ୱାତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ୱାନ୍‌ ମା ଲାକ୍‌ତୁ ୱାଜି ପାଉଲ୍‍ତି ଜୁକିଦୁ ତରାନି ନାସୁ ଅତାନ୍‌, ଆବେଟ୍‌ ୱାନ୍‌ ନିଜେଦି କିୟୁ ମାରି କାଲୁ ତର୍‌ସି ଇର୍ହାନ୍‌, “ପବିତ୍ର ଆତ୍ମା ନାଙ୍ଗିଁ ଜାଣେକିଜିନାତ୍‌ ଜେ, ଇୟା ଜୁକି ତରାତି ଅଦିକାରିଙ୍ଗ୍‍ ଜିରୁସାଲାମ୍‍ତୁ ଜିହୁଦି ଲୋକୁ ଇୟାୱାଜା ତର୍‌ସି ୱାନିଙ୍ଗ୍‌ ଅଣଜିହୁଦି ଲୋକା କିୟୁଦୁ ସର୍ପେ କିନାର୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ଇକା ୱେନ୍‌ଜି ମାପ୍‌ ମାରି ଆୟା ବାଡିଦୁ ମାନି ଆଇକାର୍‌ ପାଉଲ୍‍ତିଙ୍ଗ୍‍ ଜିରୁସାଲାମ୍‍ତୁ ସଲ୍‌ଇ ଉଣ୍ତିଙ୍ଗ୍‌ ବାତିଙ୍ଗ୍‌ ମାଲିତାପ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ମାତର୍‌ ପାଉଲ ଇର୍ହାନ୍‌, “ମିର୍‌ ଇୟା ଇନିକା କିଜିନିଦେର୍‌, ଏନ୍ଦା ଇୟାୱାଜା ଆଡ଼୍‌ବାଜି ନା ଜିବନ୍‌ତିଙ୍ଗ୍‌ ରୁକ୍‍ସିନିଦେର୍‍ ? ଜିରୁସାଲାମ୍‍ତୁ କେବଲ୍‌ ତରାୟ୍‌ ଆଦେଙ୍ଗ୍‌ ସିଲେ, ମାତର୍‌ ପ୍ରବୁ ଜିସୁ ଉଣ୍ତିଙ୍ଗ୍‌ ସାଦେଙ୍ଗ୍‍ଁ ଇଜି ବା ନାନ୍‌ ତିଆର୍‌ ମାନା ।” ");
INSERT INTO kfcp_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ମାପ୍‌ ୱାନିଙ୍ଗ୍‌ ବୁଜା କିଦେଙ୍ଗ୍‌ ଆଟ୍‌ଏଜି ଆବେଟାନ୍‍ ସୁପ୍‍ଆଜି ଇର୍ହାପ୍‍, “ପ୍ରବୁଦି ବଦା ପୁରା ଆପିତ୍‌ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ଆବେ ଏସ ସମୟ ତେବାତି ୱେନ୍‌କା ମାପ୍‌ ମା ସାମାନ୍‍ ପତ୍ର ରସ୍‍ସି ଜିରୁସାଲାମ୍‌ ତରିନ୍‌ ସର୍ହାପ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","କାଇସରିଆଦି ଏସ ସିସୁର୍‍ ନି କୁପ୍ରଦି ମନାସୋନ ଦର୍‌ତି ଅରେନ୍‌ ବିସ୍‍ବାସି ବା ମା ୱାଲେ ୱାତାନ୍‌ । ମନାସୋନଦି ଇଲୁତୁ ମାପ୍‌ ତେବାନି ବ୍ୟବସ୍ଥା ଆତାମାର୍ହାତ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ଜିରୁସାଲାମ୍‍ତୁ ବିସ୍‍ବାସ୍‌ତି ତଡ଼ାନ୍‌କୁ ୱେଡ଼ିକାଦାନ୍‌ ମାଙ୍ଗିଁ କୁକ୍‍ତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ମାରିନାଣ୍ତିଙ୍ଗ୍‍ଁ ପାଉଲ ମା ୱାଲେ ଜାକୁବଙ୍ଗ୍‍ ସୁଡ଼୍‍ଦେଙ୍ଗ୍‍ ସର୍ହାନ୍‍; ମଣ୍ତଲି ୱିଜୁ ନେତାର୍‍ ଆବେ ଉଣ୍ତାତା ମାର୍ହାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ପାଉଲ ୱାରିଙ୍ଗ୍‌ ମାଡ଼ିସ୍‌କିଜି ୱାନି ସେବା ପାଣିଦାନ୍‌ ମାପୁରୁ ଅଣଜିହୁଦି ଲୋକା ଲୋଇ ଆମାକା ଆମାକା କିତାମାର୍ହାନ୍‌; ତାନି ଉନ୍‍ଣ୍ତ୍ରି ପୁରା ମାଟା ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ୱାନି ମାଟା ୱେର୍‌ଇ ୱେନ୍‌କା ୱାର୍‌ ୱିଜେରେ ମାପୁରୁଦି ଦନ୍ୟବାଦ୍‌ କିତାର୍‍ । ତାନି ୱେନ୍‌କା ୱାର୍‌ ଇର୍ହାର୍‌, “ତଡ଼ାନ୍‌ ପାଉଲ, ନିନ୍‌ ସୁଡ଼୍‍ଜିନି, ଏଣ୍ତେସ୍‌ ଇଲେଇ ହାଜାର୍‌ ହାଜାର୍‌ ଜିହୁଦି ଲୋକୁ ପ୍ରବୁ ଜିସୁମାନୁ ବିସ୍‌ବାସ୍‌ କିଜିନାର୍‍ ମାରି ୱାର୍‌ ନିୟମ୍‌ ଉଣ୍ତିଙ୍ଗ୍‌ ବା ବିସ୍‌ବାସ୍‌ତାନ୍‌ ତେବାତାମାନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ୱାର୍‌ କାବୁର୍‌ ପୟ୍‍ତାମାନାର୍‍ ଜେ, ନିନ୍‌ ଅଣଜିହୁଦି ଲୋକା ଦେସ୍‌ତୁ ବାସାଜି ମାନି ଜିହୁଦି ଲୋକାଙ୍ଗ୍‌ ମୋସାଦି ନିୟମ୍‌ ଡ଼ିସ୍‍ତେଙ୍ଗ୍‍ଁ, ୱାରି କଡ଼ରିଙ୍ଗ୍‌ ସୁନ୍ନତ କିଇ ଉଣ୍ତିଙ୍ଗ୍‌ ମାରି ଜିହୁଦି ରିତିନିତି ମାନାଇ ଉଣ୍ତିଙ୍ଗ୍‌ ସିକିୟା ସିଜିନି । ");
INSERT INTO kfcp_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ନିନ୍‌ ଇବେ ୱାତିମାନି ଇଜି ୱାର୍‌ ସତେନେ ୱେନାର୍‌ । ଆର୍‍ତିଙ୍ଗ୍‍ଁ ଇନିକା କିଦେଙ୍ଗ୍‌ ଆନାତ୍‌ ? ");
INSERT INTO kfcp_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ମାପ୍‌ ବଦାକିଜିନାପ୍‍, ନିନ୍‌ ଉନ୍‍ଣ୍ତ୍ରି ପାଣି କିଆ । ଇବେମାନି ନାଲ୍‍ଏର୍‌ ଲୋକୁ ଉନ୍‍ଣ୍ତ୍ରି ଅପାତାମାନାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ୱାରି ୱାଲେ ସାଙ୍ଗ୍ଆ । ନେଗେନ୍‌କିନି ବିଦି ମାନାନିମାନୁ ୱାରି ୱାଲେ ମିସାଜି ୱାରି କାର୍ସୁ କିଆ । ତାନିୱେନ୍‍କା ୱାର୍‌ ନିଜେ ନିଜେଦି ତାଲା ଟାଙ୍ଗୁଁରୁ କିନାର୍‌ । ଇବେଟ୍‍ତାନ୍‌ ଜଣା ପଡ଼ାନାତ୍‌ ଜେ, ନି ବିସୟ୍‌ତାନ୍‌ ୱେଙ୍ଗିଁତି ମାନି ଇନି ମାଟା ସତ୍‌ ସିଲେ, ମାତର୍‌ ନିନ୍‌ ମସାଦି ନିୟମ୍‌ ଇସାବ୍‌ତାନ୍‌ ଜିଜିନି । ");
INSERT INTO kfcp_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ମାତର୍‌ ଏମେ ଅଣଜିହୁଦି ଲୋକୁ ବିସ୍‌ବାସ୍‌ ଆତାମାନାର୍‌, ୱାରି ଲାକ୍‌ତୁ ମାପ୍‌ ଉନ୍‍ଣ୍ତ୍ରି ଆକୁ ରାସ୍‌ସି ସିକିୟା ସିତାମାନାପ୍‍ ଜେ, ମା ମାଟାଦି ଇସାବ୍‌ତାନ୍‌ ୱାର୍‌ ଦିୟାମ୍‍କା ଲାକ୍‌ତୁ ପୁଜାସିତିମାନି କାଦି ଉଣୁଏର୍‌, ନେତେର୍‌ ଉଣୁଏର୍‌, କକ୍‍ଲା ପିଡ଼ିସି ସାପିସ୍‍କିତିମାନି ପସୁଦି କାଣ୍ତା ତିନ୍‍ଏର୍‍ ମାରି ଦାରିପାଣିଦାନ୍‌ ଆକତେବାଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ମାରିନାଣ୍ତିଙ୍ଗ୍‍ଁ ପାଉଲ ୱାତିମାର୍‌ଇ ନାଲ୍‍ଏରି ୱାଲେ ନେଗେନ୍‌କିନି ବିଦି ମାନାତାର୍‍ । ୱେନ୍‌କା ୱାନ୍‌ ମନ୍ଦିର୍‍ତୁ ସଲ୍‍ସି ନେଗେନ୍‌କିନି ପାଣି ଏସାଙ୍ଗ୍‍ଁ ୱିଜ୍‌ନାତ୍‌ ମାରି ଆମା ୱେଡ଼ାଦୁ ପୁଜାସିନିକା ମାନାତ୍‌, ଆକା ୱେର୍‍ତା ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ନେଗେନ୍‌କିନି ପାଣିଦି ସାତ୍ ଦିନ୍‌ ୱିଜିତି ୱେନ୍‌କା ଆସିଆ ରାଜିଦି ଏସ ଜିହୁଦି ଲୋକୁ ମନ୍ଦିର୍‌ତୁ ପାଉଲ୍‍ତିଙ୍ଗ୍‍ ସୁଡ଼ୁତାର୍‌ । ୱାର୍‌ ଆବେ ଉଣ୍ତାତିମାର୍‍ଇ ଲୋକାଙ୍ଗ୍‌ ଏଗ୍ରିସ୍‍ କିଜି ପାଉଲ୍‍ତିଙ୍ଗ୍‍ଁ ଆସ୍‌ତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ୱାର୍‌ ଆଉଲି ଆଜି ଇର୍ହାର୍‌, “ଏ ଇସ୍ରାଏଲ୍‌ତି ଲୋକୁ, ମାଙ୍ଗିଁ ସାକା କିଦୁ ! ଇୟା ଲୋକୁ ସାରିବେଡ଼୍‍ତି ସଲ୍‍ସି ଇସ୍ରାଏଲ୍‌ତି ଲୋକା ବିରୁଦ୍‍ତାନ୍‍, ମସାଦି ନିୟମ୍‌ ନି ଇୟା ମନ୍ଦିର୍‌ ବିରଦ୍‌ତାନ୍‌ ସିକିୟା ସିଜିନାନ୍‌ । ମାରି ଇଲେଇ ୱାନ୍‌ ଏସ ଅଣଜିହୁଦି ଲୋକାଙ୍ଗ୍‌ ମନ୍ଦିର୍‌ ଲୋଇ ତାସି ଇୟା ପବିତ୍ର ବାଡିଦିଙ୍ଗ୍‍ଁ ତାଗ୍‌ଇକା କିଜିନାନ୍‍ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ୱାର୍‌ ଗାଡ଼୍‌ତୁ ଏପିସସ୍‍ତି ତ୍ରପିମଦିଙ୍ଗ୍‍ଁ ପାଉଲତି ୱାଲେ ସୁଡ଼ୁତିମାରିଙ୍ଗ୍‍ଁ ଅଡ଼୍‍ବିତାର୍‍ ଜେ, ପାଉଲ ୱାନିଙ୍ଗ୍‍ ମନ୍ଦିର୍‌ତୁ ଅତାମାନାନ୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ୱିଜୁ ଗାଡ଼୍‌ତୁ ଜାଟି ନିଙ୍ଗିଁତାତ୍‍ । ଲୋକୁ ପାଉଲ୍‍ତିଙ୍ଗ୍‍ଁ ମନ୍ଦିର୍‌ ଆତ୍‌ରେ ଇର୍‍ସି ତାତାର୍‌ । ମନ୍ଦିର୍‌ତି ସେର୍‍ଲେଙ୍ଗ୍‌ ୱିଜୁ କେର୍‍ତା ଡ଼ିସ୍‌ତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ରିସାଆତି ଲୋକୁ ୱିଜେରେ ପାଉଲ୍‍ତିଙ୍ଗ୍‍ଁ ଡାକ୍‍ତେଙ୍ଗ୍‍ଁ ଇଜି ଉପାୟ୍‌ କିତାର୍‍, ଏସ୍ତିୱାଲେ ୱିଜୁ ଜିରୁସାଲାମ୍‍ତୁ ଜାଟି ଜଗଡ଼ା ଆଜିନାତ୍‌ ଇଜି ରୋମିୟ ସନ୍ୟରି ନେତା କାବୁର୍‌ ୱେର୍‌ଆନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ନାସ୍ତିୱାଲେ ନେତା ଏସ ସେନାପତି ନି ସନ୍ୟରିଙ୍ଗ୍‍ଁ ଅସି ଜାଟି ଜଗଡ଼ା ଆନି ବାଡିଦୁ ଇତାନ୍‌ । ଲୋକୁ ସନ୍ୟରି ନେତେଙ୍ଗ୍‍ଁ ନି ସନ୍ୟରିଙ୍ଗ୍‍ଁ ସୁଡ଼୍‌ଜି ପାଉଲ୍‍ତିଙ୍ଗ୍‍ଁ ମାରି ମାଡ୍‌ ଡାକ୍‍ଏନ୍‍ଣ୍ତା ଡ଼ିସ୍‍ତାସିତାର୍‍ । ");
INSERT INTO kfcp_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ସନ୍ୟରି ନେତା ପାଉଲତିଙ୍ଗ୍‍ଁ ଆସ୍‌ସି ୱାନିଙ୍ଗ୍‍ଁ ରୁଣ୍ତି ସିକ୍‍ଣି ଦାନ୍‍ ତର୍‍ତେଙ୍ଗ୍‍ଁ ଇଜି ଆଦେସ୍‌ ସିତାନ୍‌ । ୱେନ୍‌କା ୱାନ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ଇୟା ଲୋକୁ ଏନ୍‌ ମାରି ୱାନ୍‌ ଇନିକା କିତାମାନାନ୍‍ ?” ");
INSERT INTO kfcp_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ଲୋକୁ ଗଲି ଲୋଇ ଏନ୍‌ ଏସ ରକମ୍‌ତି ମାଟା ଇଜି ଆଉଲି ଆତାର୍‌ । ଇୟାୱାଜା ଅସାନ୍ତି ଆତାତ୍‍ଜେ, ସନ୍ୟରି ନେତା ସତ୍‌ ମାଟା ଇନିକା, ଇନିକାବା ନେସ୍‌ତେଙ୍ଗ୍‌ ଆଟ୍‍ଏତାନ୍‍ । ଆବେଟ୍‌ ୱାନ୍‌ ପାଉଲତିଙ୍ଗ୍‍ଁ ସନ୍ୟର୍‌ତେବାନି ବାଡି ଲୋଇ ଅତେଙ୍ଗ୍‍ଁ ଇଜି ସନ୍ୟରିଙ୍ଗ୍‌ ଆଦେସ୍‌ ସିତାନ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ୱାର୍‌ ୱାନିଙ୍ଗ୍‍ଁ ଅସି ସନ୍ୟର୍‌ତେବାନି ବାଡିଦି ପାଉଚ୍‌କୁ ଲାକ୍‌ତୁ ଇନି ୱେଡ଼ାଦୁ ୱାନିଙ୍ଗ୍‍ଁ କେର୍‍ବାଜି ତେବାଜିମାନି ଲୋକୁ ନିସା ରିସା ଆତାର୍‌ ଜେ ସନ୍ୟର୍‍ ପାଉଲ୍‍ତିଙ୍ଗ୍‍ଁ ପିଣ୍ତ୍‍ତା ଅତାର୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ଲୋକୁ ୱିଜେରେ ୱାନି ୱେନ୍‌କା ୱେନ୍‌କା ୱାଜି ଆଉଲି ଆଜି ଇଜିମାର୍ହାର୍‍, “ୱାନିଙ୍ଗ୍‍ଁ ଡାକ୍‍ଦୁ ।” ");
INSERT INTO kfcp_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ସନ୍ୟର୍‍ ପାଉଲତିଙ୍ଗ୍‍ଁ ସନ୍ୟର ତେବାନି ବାଡି ଲୋଇ ଅନି ୱାଲେ ୱାନ୍‌ ସନ୍ୟରି ନେତେଙ୍ଗ୍‍ଁ ଇର୍ହାନ୍‌ : “ନାନୁ ନିଙ୍ଗିଁ ଏସ ମାଟା ଇନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ଆଟ୍‍ନାନ୍‌ ନୋ ?” ସନ୍ୟରି ନେତା ୱେନ୍‌ବାତାନ୍‌, “ନିନୁ ତୋ ଗ୍ରିକ୍‌ ୱାର୍‍ଗିଜିନି । ");
INSERT INTO kfcp_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ଆର୍‍ତିଙ୍ଗ୍‍ଁ ଏସ ଦିନ୍‌ ଆଗ୍‌ଡ଼ି ମିସର୍‍ ଏମେ ଲୋକୁ ଜୁଦ୍‍ କିଜି ଚାରି ହାଜାର୍‌ ଜୁଦ୍‍ ସାମାନ୍‍ ଆସ୍‌ତି କାଙ୍ଗାଁର୍‌ଆଙ୍ଗ୍‌ ଅସି ମରୁବୁମିଦୁ ଇତା ମାର୍ହାନ୍‍, ନିନୁ ତୋ ଆୟା ଲୋକୁ ସିଲେ ?” ");
INSERT INTO kfcp_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ପାଉଲ ଇର୍ହାନ୍‌, “ସିଲିସିଆଦି ତାର୍ସସ୍‍ତୁ ଜନମ୍‌ ଆତିମାନି ନାନୁ ଅରେନ୍‌ ଜିହୁଦି, ଉନ୍‌ଡ୍ରି ପେରି ଗାଡ଼୍‌ତି ଲୋକୁ । ଇୟା ଲୋକାଙ୍ଗ୍‌ ବୁଜାକିଜି ଇନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ଇଜି ଦୟା କିଜି ନାଙ୍ଗିଁ ସାରି ସିଦା । ");
INSERT INTO kfcp_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","“ସନ୍ୟରି ନେତା ୱାନିଙ୍ଗ୍‍ଁ ସାରି ସିତାନ୍‌ଆକା ପାଉଲ ପାଉଚ୍‌ ମୁସ୍‌କୁ ନିଲ୍‍ସି ଲୋକାଙ୍ଗ୍‌ ଆଲେଜ ମାନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ଇଜି କିୟୁ ପେର୍‌ଜି ଜୁଟ୍‌ସି ୱେର୍‌ତାନ୍‌ । ୱାର୍‌ ଆଲେତି ୱେନ୍‌କା ପାଉଲ ଏବ୍ରି ଭାସାଦାନ୍‍ ଇର୍ହାନ୍‌ : ");
INSERT INTO kfcp_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“ତଡ଼ାନ୍‌କୁ ମାରି ବୁବାର୍‍, ମି ଆଗ୍‌ଡ଼ି ନିଜେ ତରିଟାନ୍‍ ନାନୁ ଆମାକା ଇଜିନା, ଆକା ୱେନ୍‌ଡ୍ରୁ !” ");
INSERT INTO kfcp_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ୱାରି ୱାଲେ ୱାନ୍‌ ଏବ୍ରି ବାସାଦାନ୍‍ ମାଟା ୱାର୍‍ଗିଜିନିକା ୱେନ୍‌ଜି ୱାର୍‌ ମାରି ଆଲେତାର୍‍ ମାରି ପାଉଲ ଇନ୍‍ଡ୍ରେଙ୍ଗ୍‍ଁ ଆସ୍‌ତାନ୍‌ : ");
INSERT INTO kfcp_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","ନାନୁ ଅରେନ୍‌ ଜିହୁଦି, ସିଲିସିଆଦି ତାର୍ସସ୍‍ତୁ ନା ଜନମ୍‌, ମାତର୍‌ ନାନୁ ଜିରୁସାଲାମ୍‍ତୁ ପିରିତା ମାର୍ହା ମାରି ଗମଲିଏଲତି ଅରେନ୍‌ ସିସୁ ମାର୍ହା । ମା ଡକ୍ରାଦାଦାରି ନିୟମ୍‌ ନାନୁ ଟିକ୍‍ତାନ୍‍ ଅଜାତା ମାର୍ହା ମାରି ମି ୱାଜା ମାପୁରୁଦି ଉଣ୍ତିଙ୍ଗ୍‍ଁ ୱେଡ଼ିକା ମାର୍ହା । ");
INSERT INTO kfcp_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ନାନୁ ଇୟା ସାରିଦୁ ସନି ଲୋକା ମୁସ୍‌କୁ ଜାଟି କିଜି ୱାରିଙ୍ଗ୍‍ଁ ଜିବନ୍‌ତୁ ଡାକ୍‍ସି ମାର୍ହା । ମେମାରି ନି ଆଇମା ୱିଜେରିଙ୍ଗ୍‍ଁ ତର୍‌ସି ଜଇଲ୍‌ତୁ ଅସି ମାର୍ହା । ");
INSERT INTO kfcp_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ନା ଇୟା ମାଟା ସତ୍‌ ଜେ, ପେରି ଜାଜକ ନି ପେରି ଲୋକାମିଟିଙ୍ଗ୍‍ତି ସବାଦି ୱିଜେରେ ତେନି ସାକି । ଇୟା ଲୋକାଙ୍ଗ୍‌ ତର୍‌ସି ମାରି ସିକିଣିଦାନ୍‍ ତର୍‌ସି ଦଣ୍ଡ୍‌ ସିଦେଙ୍ଗ୍‌ ଇଜି ଜିରୁସାଲାମ୍‍ତୁ ତାତେଙ୍ଗ୍‍ଁ ଇଜି ନାନୁ ପେରି ଜାଜକତିମାଣାନ୍‌ ସିଟି ଅସି ଦାମାସ୍‍କସ୍‍ତୁ ମାନି ଜିହୁଦି ତଡ଼ାନ୍‌କା ଲାକ୍‌ତୁ ସର୍‌ଆ । ");
INSERT INTO kfcp_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“ନାନୁ ସଲ୍‍ସି ଏସ୍ତିୱାଲେ ଦାମାସ୍‍କସ୍‍ତି ଲାକ୍‌ତୁ ଆଜିମାର୍ହା, ମାଦ୍‌ଲାମ୍‌ ବେଡ଼ାଦୁ ବାଦଡ଼୍‍ତାନ୍‍ ଉନ୍‌ଡ୍ରି କାସ୍‍ନି ଜାୟ୍‌ ଆୟାଦାପ୍ରେନେ ନା ସାରିବେଡ଼୍‍ତି ତରାୟ୍‍ ଆତାତ୍‌ । ");
INSERT INTO kfcp_vpl VALUES ("AC22_7","074_22