﻿USE sofia;
DROP TABLE IF EXISTS sofia.kfc_vpl;
CREATE TABLE kfc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kfc_vpl WRITE;
INSERT INTO kfc_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","అబ్రహాం తెగాదికాతి దావీదు రాజు తెగదు పుట్తి యేసు క్రీస్తు తెగ యాక. ");
INSERT INTO kfc_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","అబ్రాహము మరిసి ఇస్సాకు, ఇస్సాకు మరిసి యాకోబు, యాకోబు మరిసిర్‌ యూదాని వన్ని దాద్సిర్‌, తంబేర్‌సీర్. ");
INSERT INTO kfc_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","యూదా మరిసిర్‌ పెరెసుని జెరహు, వరి యాయ పేరు తామారు. పెరెసు మరిసి ఎస్రోము, ఎస్రోము మరిసి అరాము, ");
INSERT INTO kfc_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","అరాము మరిసి అమ్మినాదాబు, అమ్మినాదాబు మరిసి నయస్సోను, నయస్సోను మరిసి సాల్‌మాను. ");
INSERT INTO kfc_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","సాల్‌మాను మరిసి బొయజు, బొయజు యాయ పేరు రాహబు, బోయజు మరిసి ఓబేదు, ఒబేదు యాయ పేరు రూతు. ఓబేదు మరిసి యెసయ. ");
INSERT INTO kfc_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","యెసయ మరిసి రాజు ఆతి దావీదు. దావీదు రాజు మరిసి సొలొమోను, సొలొమోను అయ్‌సి, ముఙాల ఊరియెఙ్‌ ఆల్సి ఆతి మహికాద్. ");
INSERT INTO kfc_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","సొలొమోను మరిసి రెహబాము. రెహబాము మరిసి అబీయా, అబీయా మరిసి ఆసా. ");
INSERT INTO kfc_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ఆసా మరిసి యెహొసపాతు. యెహొసపాతు మరిసి యెహోరాము, యెహోరాము మరిసి ఉజ్జియా. ");
INSERT INTO kfc_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ఉజ్జియా మరిసి యోతాము, యోతాము మరిసి ఆహజు, ఆహజు మరిసి హిజ్కియా. ");
INSERT INTO kfc_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","హిజ్కియా మరిసి మనసె, మనసె మరిసి ఆమోను, ఆమోను మరిసి యోసీయా. ");
INSERT INTO kfc_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","యోసీయా మరిసీర్‌ యెకొనియని వన్ని దాద్సిర్‌, తంబేర్‌సీర్. వరి కాలమ్‌దు బబులోను దేసెమ్‌ది రాజు యూదురిఙ్‌ వెట్టిపణి కినివరిలెకెండ్‌ అసి తొహ్త ఒత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","బబులోను దేసమ్‌దు సొహి వెనుక అబె యెకొనియెఙ్‌ మరిన్‌ పుట్తాన్. వన్ని పేరు సయల్తీయెలు, సయల్తీయెలు మరిసి జెరుబాబెలు. ");
INSERT INTO kfc_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","జెరుబాబెలు మరిసి అబీహూదు, అబీహూదు మరిసి ఎలియాకీము, ఎలియాకీము మరిసి అజోరు. ");
INSERT INTO kfc_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","అజోరు మరిసి సాదోకు, సాదోకు మరిసి ఆకీము, ఆకీము మరిసి ఎలీహూదు. ");
INSERT INTO kfc_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ఎలీహూదు మరిసి ఎలియాజరు, ఎలియాజరు మరిసి మత్తాను, మత్తాను మరిసి యాకోబు. ");
INSERT INTO kfc_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","యాకోబు మరిసి యోసేపు, వన్ని ఆల్సి ఆతి మరియ పొటాదు క్రీస్తు ఇజి కూకె ఆతి యేసు పుట్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","యా లెకెండ్‌ అబ్రాహము బాణిఙ్‌ అసి దావీదు రాజు దాక మొతం పద్‌నాల్గి తరమ్‌కు, దావీదు రాజు బాణిఙ్‌ అసి యూదురిఙ్‌ బబులోను దేసమ్‌దు వెట్టి పణి కిని వరిలెకెండ్‌ తొహ్సిఒతి కాలమ్‌దాక పద్‌నాల్గి తరమ్‌కు. యూదురు బబులోను దేసమ్‌దు సొహి బాణిఙ్‌ అసి యేసు క్రీస్తు దాక పద్‌నాల్గి తరమ్‌కు. ");
INSERT INTO kfc_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","యేసు క్రీస్తు యా లెకెండ్‌ పుట్తాన్. వన్ని అయ్‌సి ఆతి మరియెఙ్‌ యోసేపు వందిఙ్‌ వెన్‌బాత మహాద్‌. గాని వారు రిఎర్‌ ఉండ్రె బానె గూర్‌ఏండ ముందాల్నె అది దేవుణు ఆత్మ సత్తుదాన్‌ పాత డిఃస్తాద్. ");
INSERT INTO kfc_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","గాని దనిఙ్‌ పేరు కితికాన్‌ ఆతి యోసేపు దేవుణు రూలుఙ్‌ లొఙిజి మనికాన్‌ కక, విజేరిఙ్‌ ఎద్రు సిగు కిబిస్‌ఏండ, ఎయెర్‌బా నెస్‌ఏండ, దన్నిఙ్‌ డిఃసి సీదెఙ్‌ ఇజి ఒడ్ఃబితాన్. ");
INSERT INTO kfc_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","యోసేపు యా సఙతిఙ వందిఙ్‌ ఆలోసనం కిజి మహివలె దేవుణు దూత కలాదు వన్నిఙ్‌ తోరె ఆజి ఈహు వెహ్తాన, “దావీదు రాజు తెగ్గాతికాన్‌ ఆతి యోసేపు, నిఙి పేరుకితి మని మరియెఙ్‌ డగ్రుకిదెఙ్‌ అనుమానం ఆమ. ఎందనిఙ్‌ ఇహిఙ దేవుణు ఆత్మ సత్తుదాన్‌నె అది పాత డిఃస్త మనాద్. ");
INSERT INTO kfc_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","అది ఒరెన్‌ కొడొః ఇడ్‌నాద్‌లె. వన్ని లోకాఙ్‌ వరి పాపమ్‌కాణిఙ్‌ వాండ్రు రక్సిస్నాన్‌లె. అందెఙె వన్నిఙ్‌ యేసు ఇజి పేరు ఇడ్‌దెఙ్‌వలె”, ");
INSERT INTO kfc_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","“ఉండ్రి విడిః బోదెలి పాత డిఃసి ఒరెన్‌ మరిన్‌ ఇడ్నాద్‌లె. వాండ్రు ఇమ్మానుయెలు ఇజి కూకె ఆనాన్‌లె”, ఇమ్మానుయెలు ఇహిఙ దేవుణు మా వెట తోడుః మనాన్‌ ఇజి అర్దం. ముందాల దేవుణు ప్రవక్త వెట వర్గితి యా మాటెఙ్‌ నిజం పూర్తి ఆదెఙ్‌ యాకెఙ్‌ విజు యా లెకెండ్‌ జర్గితె. ");
INSERT INTO kfc_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","యోసేపు నిద్రదాన్‌ తెలిఆతిఙ్‌ దేవుణు దూత వన్నిఙ్‌ వెహ్తి వజనె మరియెఙ్‌ ఆల్సి లెకెండ్‌ వన్ని ఇండ్రొ కూక్త ఒతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","గాని మరియ మరిన్‌ ఇడ్నిదాక వాండ్రు దని డగ్రు సొన్‌ఏతాన్. మరిన్‌ పుట్తిఙ్‌ వాండ్రు వన్నిఙ్‌ యేసు ఇజి పేరు ఇట్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","హెరోదు రాజు ఏలుబడిః కిజి మహివలె యూదయ దేసమ్‌దుమని బెత్లెహెము ఇని నాటొ యేసు పుట్తాన్. వాండ్రు పుట్తి వెన్కా తూర్‌పు దరొటాన్‌ గ్నానురు యెరూసలేం ఇని పట్నమ్‌దు వాతార్‌ ");
INSERT INTO kfc_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","పట్నమ్‌దు వాతారె, “యూదురిఙ్‌ రాజు ఆదెఙ్‌ ఇజి పట్తి కొడొః ఎంబె మనాన్‌? వాండ్రు పుట్తిదన్నిఙ్‌ గుర్తు తొరిసిని సుక్క, మాపు తూర్పుదరోటు సుడ్‌తాప్. వన్నిఙ్‌ పొగ్‌డిఃజి మాడిఃస్తెఙ్‌ ఇజి వాత మనాప్‌”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","యా మాటెఙ్‌ విహరె హేరోదు రాజుని వన్నివెట యెరూసలేమ్‌దికార్‌ విజేరె నండో గాబ్ర ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","హేరోదు రాజు, పెరి పుజెరిఙ్‌ విజెరిఙ్‌ని యూదురి రూలుఙ్‌ నెస్పిస్ని వరిఙ్‌ విజేరిఙ్‌ కూక్‌పిస్తాండ్రె, “క్రీస్తు ఆతికాన్‌ ఎంబె పుట్నాన్‌?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","“యూదయ దేసమ్‌దుమని బేత్లెహేముదు”, ఇజి వారు వెహ్తార్‌, “ఎందనిఙ్‌ ఇహిఙ, యా లెకెండ్‌ దేవుణు ముఙాల ఒరెన్‌ ప్రవక్త వెట వర్గిత మహాన్.” ");
INSERT INTO kfc_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“యూదయ దేసమ్‌దు మని బేత్లెహెమా, నీను యూదయ నాహ్కఙ్‌ లొఇ ఇజిరికి ఆఇ. ఎందనిఙ్‌ ఇహిఙ, నీ లొఇహాన్‌ ఒరెన్‌ రాజు లెకెండ్‌ ఏలుబడిః కినికాన్‌ పుట్నాన్‌లె. వాండ్రు నా లోకుర్‌ ఆతి ఇస్రాయేలు లోకురిఙ్‌ గవుడుఎన్‌ లెకెండ్‌ మంజినాన్‌లె.” ");
INSERT INTO kfc_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","నస్తివలె హేరోదు రాజు, మరి ఎయెర్‌బా నెస్‌ఏండ గ్నానురుఙ్‌ కూక్‌పిస్తాండ్రె సుక్క తోరె ఆత్తి సరియాతి టయం వరిఙ్‌ వెన్‌బాజి నెస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","వరిఙ్‌ బేత్లెహేమ్‌దు పోక్తాండ్రె, “మీరు సొన్సి నెగ్రెండ అయా కొడొఃదిఙ్‌ రెబాజి సుడ్ఃజి వాండ్రు ఎంబె మనాన్‌ ఇజి నఙిబా కబ్రురు తగ్‌అ. అయావలె నానుబా సొన్సి వన్నిఙ్‌ పొగ్‌డిఃజి మాడిఃస్న”, ఇజి వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","వారు రాజు వెహ్తి మాట విహరె సోతార్. సొన్సి మహివలె, వారు తూర్‌పు దరోటు సుడ్ఃతిమహి సుక్క, వరి ముందాల నడిఃజి మహాద్. కొడొః మహి బాడ్డి ముస్కు అందితిఙ్‌ అయా సుక్క అబ్బె నిహాద్. ");
INSERT INTO kfc_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","సుక్క సుడ్ఃతిఙ్‌ వారు గొప్ప సర్ద ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ఇండ్రొ సొహారె అయ్‌సి ఆత్తి మరియ వెట మన్ని కొడొఃదిఙ్‌ సుడిఃతారె ముణుకుఙ్‌ ఊర్‌జి వన్నిఙ్‌ పొగ్‌డిఃజి మాడిఃస్తార్. నస్తివలె వారు ఒత్తిమహి పెటెఙ్‌ రేతారె బఙారం, సాంబ్రాణి, బోలాం ఇనికెఙ్‌ వన్నిఙ్‌ నొండిత సితార్. ");
INSERT INTO kfc_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","“హేరోదు రాజు డగ్రు మర్‌జి సొన్మాట్‌”, ఇజి దేవుణు దూత కలాదు వరిఙ్‌ వెహ్తి వజ, వారు మరి ఉండ్రి సరిదాన్‌ వరి దేసెం సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","గ్నానురు మర్‌జి సొహి వెనుక ఒరెన్‌ దేవుణు దూత యోసేపుఙ్‌ కలాదు తోరె ఆజి, “నీను నిఙ్‌అ, హేరోదు రాజు కొడొఃదిఙ్‌ సప్తెఙ్‌ సుడ్ఃజినాన్. అందెఙె వెటనె కొడొఃదిఙ్‌ని అయ్‌సిఙ్‌ అసి అయ్‌గుప్తు దేసమ్‌దు సొన్‌అ. మరి ఇనిక కిదెఙ్‌ ఇజి నాను నిఙి వెహ్నిదాక అబెనె మన్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","నస్తివలె వాండ్రు నిఙితండ్రె, కొడొఃదిఙ్‌ని అయ్‌సిఙ్‌ అస్తాండ్రె అయా పొదొయ్‌నె అయ్‌గుప్తు దేసమ్‌దు సొండ్రెఙ్‌ సోతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","హేరోదు సానిదాక అబెనె మహాన్‌. “అయ్‌గుప్తు దేసెమ్‌దాన్‌ నా మరిసిఙ్‌ నాను కూక్త”, ఇజి దేవుణు ముందాల ప్రవక్త వెట వర్గితి మాట యా లెకెండ్‌ పూర్తి ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","గ్నానురు వన్నిఙ్‌మోసం కితార్‌ ఇజి నెస్తాండ్రె హేరోదు రాజు నండొ కోపం ఆతాన్. వారు వెహ్తి టయమ్‌దిఙ్‌లెక కితాండ్రె బేత్లెహేమ్‌దుని, మరి డగ్రు మని ప్రాంతమ్‌కాఙ్‌ మన్నినాహ్‌కాఙ్‌ మన్ని రుండి పంటెఙ్‌ని దన్ని అడిఃగి వయ్‌సు మని కొడొఃరిఙ్‌ విజెరిఙ్‌ సప్తెఙ్‌ ఆడ్ర సితాన్. ");
INSERT INTO kfc_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","“రామా నారుదాన్‌ ఉండ్రి పెరి జాటు వెహద్. గుండె కొత్తె ఆజి అడఃబాజిని జాటునె. రాహేలు దన్ని కొడొఃర్‌ వందిఙ్‌ అడఃబజినాద్. కొడొఃర్‌ సాతిఙ్‌ అది ఓరిస్తెఙ్ అట్‌ఏతాద్.” యిరిమ్య ప్రవక్తవెట దేవుణు ముఙాల వర్గితిమహి యా మాట యాలెకెండ్‌ పూర్తి ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","హేరోదు సాతి వెనుక అయ్‌గుప్తు దేసమ్‌దు మహి యోసేపుఙ్‌ ఒరెన్‌ దేవుణు దూత కలాదు తోరె ఆతాండ్రె, ");
INSERT INTO kfc_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“నీను నిఙ్‌అ, కొడొఃదిఙ్‌ని అయ్‌సిఙ్‌ అసి ఇస్రాయేలు దేసమ్‌దు సొన్‌అ. ఎందనిఙ్‌ ఇహిఙ, కొడొఃదిఙ్‌ సప్తెఙ్‌ సుడ్ఃజి మహికార్‌ సాత సొహార్‌”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","అందెఙె యోసేపు నిఙితాండ్రె కొడొఃదిఙ్‌ని అయ్‌సిఙ్‌ అస్తాండ్రె ఇస్రాయేలు దేసమ్‌దు మర్‌జి సొండ్రెఙ్‌ సోతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","గాని హేరోదు సాతి వెనుక వన్ని మరిసి ఆతి అర్‌కెలాయు యూదయ దేసమ్‌దు ఏలుబడిః కిజినాన్‌ ఇజి నెస్తాండ్రె అబ్బె సొండ్రెఙ్‌ తియెలాతాన్. కలాదు వెహ్తి లెకెండ్‌ యూదయ దేసెం సొన్‌ఏండ గలీలయ ముటాదు సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","అబ్బె నజరేతు ఇని పట్నమ్‌దు సొహాండ్రె బత్కితాన్. “నజరేతుదికాన్‌ ఇజి వాండ్రు కూకె ఆనాన్‌లె”, ఇజి దేవుణు ప్రవక్తరు వెట క్రీస్తు వందిఙ్‌ వర్గితిమహి మాటెఙ్‌ యా లెకెండ్‌ పూర్తి ఆతె. ");
INSERT INTO kfc_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","2","అయ దినమ్‌కాఙ్‌ బాప్తిసం సీని యోహాను వాతండ్రె, “దేవుణు ఏలుబడిః కిని కాలం డగ్రు ఆత మనాద్. అందెఙె మీరు పాపమ్‌కు ఒప్పుకొడిఃజి డిఃసి సీదు”, ఇజి యూదయ బిడిఃఙ్‌ బూమి ప్రాంతమ్‌కాఙ్‌ సాటిసి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","“ప్రబు లోకుడగ్రు వాదెఙ్‌ సరి తయార్‌ కిదు, వన్ని వందిఙ్‌ సరి తినాఙ్‌ కిదు”, ఇజి బిడిఃఙ్‌ బూమిదాన్‌ ఒరెన్‌ డేల్సి వెహ్సిని కంటం వాజినాద్ ఇజి యెసయ ప్రవక్త వెట దేవుణు ముందాల వర్గితిక విని వందిఙె. ");
INSERT INTO kfc_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","యోహను ఒంటె బులుస్కాణిఙ్‌ తయార్‌ కితి సొకెఙ్‌ తొడిఃగితాండ్రె, నడుముదు తోలు బెల్టు తొహె ఆజి మహాన్‌. వాండ్రు మేపిలెక్‌ని అడిఃవి తేనె, తింజి బత్కిజి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","యెరుసలేమ్‌దికార్‌ని, యూదయ దేసెమ్‌దికార్‌ విజెరె, మరి యొర్దాను గడ్డ డగ్రు మని నాహ్కణికార్‌ విజెరె సోతారె యోహను వెహ్నికెఙ్‌ వెండ్రెఙ్‌ వన్నిడగ్రు వాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","వారు, కితి పాపమ్‌కు ఒపుకొడ్ఃజి యొర్దాను గడ్డదు వన్ని కియుదాన్‌ బాప్తిసం లాగె ఆజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","పరిసయ్‌రు, మరి సదుకయ్‌రు నండొండార్‌ యోహను బాప్తిసం సీజి మహిబాన్‌ వాతార్. వరిఙ్‌ సుడ్ఃజి వాండ్రు ఈహు వెహ్తాన్‌, “మీరు విసం మన్ని సరాస్‌ లెకెండ్‌ మన్నికిదెర్‌. దేవుణుబాణిఙ్‌ కోపం వాజినాద్‌ ఇజి నమ్మిజి మిరు వాతిదెరా? సిల్లెద్‌. వన్ని కోపమ్‌దాన్‌ తప్రె ఆదెఙ్‌ ఇజి మీరు వాతిదెరా? నిజమె అయలెకెండ్‌ ఇజి నాను ఒడిఃదెఙ్‌ సిల్లెద్‌. ");
INSERT INTO kfc_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","మీ పాపమ్‌కు ఒప్పుకొడిఃజి డిఃసి సీజి దనిఙ్‌ తగితి పణిఙ్‌కిజి తోరిస్తు. ");
INSERT INTO kfc_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","‘మాపు అబ్రాహము తెగ్గాతికాప్‌, అందెఙె మాపు సిక్సదాన్‌ తప్రె ఆనాప్లె’ ఇజి మీ మన్సుదు మీరు ఒడిఃబిమాట్. ఎందనిఙ్‌ ఇహిఙ, యా పణకాణిఙ్‌ అబహమ్రుఙ్‌ కొడొఃర్‌ పుటిస్తెఙ్‌ దేవుణు అట్నికాన్‌ ఇజి నాను మిఙి వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","దేవుణు మరెక మొదొల్‌ కత్సి విసీర్‌దెఙ్‌ కియుదు గొడెలి అస్తి వన్నిఙ్‌ పోలిత మనాన్. నెగ్గి పట్కు అస్‌ఇ మరెకాఙ్‌ విజు కత్సి సిసుద్‌ విసీర్నాన్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","మీరు పాపమ్‌కు ఒపుకొడ్ఃజి డిఃస్తి సితి వందిఙ్‌. నాను మిఙి ఏరుదాన్‌ బాప్తిసం సీజిన. నా వెనుక వానికాన్‌ నఙి మిస్తి అతికారం మనికాన్. వన్ని జోడ్కు పిండ్‌దెఙ్‌బా నాను తగ్నిక ఆఎ. వాండ్రు దేవుణు ఆత్మదాన్‌ని, సిసుదాన్‌ మిఙి బాప్తిసం సీనాన్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","వాండ్రు గాలి ఇడ్ని సేహి కీదు అస్తి వన్నిఙ్‌ పోలిత మనాన్. వాండ్రు వన్ని కలమ్‌దిఙ్‌ సుబారం కిజి గాలి ఇట్తి కూలిఙ్‌ కొటు ఇండ్రొ ఒసి వాక్నాన్‌లె. పొటుదిఙ్‌ నంబిఇ సిసుదు సుర్‌నాన్‌లె.” ");
INSERT INTO kfc_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","నస్తివలె యోహను కీదాన్‌ బాప్తిసం లాగె ఆదెఙ్, గలిలయదాన్‌ యేసు యొర్దాను గడ్డదు వాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","“నీ కియుదాన్‌ బాప్తిసం లాగె ఆదెఙ్, నఙి అవ్‌సరం గాని నీను బాప్తిసం లాగె ఆదెఙ్‌ నా డగ్రు వాతిదా?”, ఇజి యోహను వన్నిఙ్‌ అడ్డు కిదెఙ్‌ సుడ్‌తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","“ఏలు యా లెకెండ్‌ జర్‌గిపిద్. విజు యా లెకెండ్‌ దేవుణుదిఙ్‌ ఇస్టమాతివజ పూర్తి కినిక మఙి తగ్నె”, ఇజి యేసు వెహ్తాన్‌. నస్తివలె యోహను ఒప్పుకొటాన్. ");
INSERT INTO kfc_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","బాప్తిసం లాగె ఆతి వెటనె యేసు ఏరుదాన్‌ వెల్లి వాతాన్. అయావలెనె ఆగాసం రే ఆతాద్. దేవుణు ఆత్మ పావురపొటి లెకెండ్‌ యేసు ముస్కు డిగ్‌జి వానిక యోహను సుడ్ఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","“వీండ్రు నా ఇస్టమాతి మరిన్, విని ముస్కు నాను నండొ సర్‌ద ఆజిన”, ఇజి దేవుణు మంజిని బాడిఃదాన్‌ వెహ్సిని ఉండ్రి జాటు వాతాద్. ");
INSERT INTO kfc_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","వెనుక దేవుణు ఆత్మ యేసుఙ్‌ బిడిఃఙ్‌ బూమి ప్రాంతమ్‌దు నడ్ఃపిస్తాన్. అబె సయ్తాన్‌ యేసుఙ్‌ తపు కిబిస్తెఙ్‌ పరిస కిజి సుడ్ఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","నలపయి రోస్కు రెయు పొకల్‌ఉపాస్‌మహి వెనుక వన్నిఙ్‌బఙ కట్తాద్. ");
INSERT INTO kfc_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","సయ్తాన్‌ వన్ని డగ్రు వాతండ్రె, “నీను దేవుణు మరిసి ఇహిఙ, యా పణకుఙ తిండి ఆఅ ఇజి వెహ్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","నస్తివలె యేసు “లోకు బత్కిజినిక తిండిదానె ఆఎద్‌, గాని దేవుణు వెయుదాన్‌వాని విజు మాటెఙాణిఙ్‌బా బత్కిజినాన్‌ ఇజి దేవుణు మాటదు రాస్త మనాద్‌”, ఇజి వన్నిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","వెనుక సయ్‌తాను యేసుఙ్‌ దేవుణు పట్నం ఆతి యెరూసలేముదు కూక్త ఒతండ్రె, అబె మని దేవుణు గుడిః కొసాదు నిల్‌ప్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","అబె నిల్‌ప్తాండ్ర “నీను దేవుణు మరిసి ఇహిఙ, ఇబ్బెణిఙ్‌ అడిఃగి డాట్‌అ. ‘నీ వందిఙ్‌ వన్ని దూతరిఙ్‌ దేవుణు ఆడ్ర సీనాన్. నీ కాల్కు పణకుఙ తగ్‌లిఏండ వారు నిఙి వరి కికాణిఙ్‌ పెర్న అస్నార్‌’ ఇజి దేవుణు మాటదు రాస్త మనాద్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","యేసు వన్నిఙ్, “‘నీ ప్రబు ఆతి దేవుణుదిఙ్‌ పరిస కిదెఙ్‌ ఆఏద్‌’ ఇజిబా రాస్త మనాద్‌”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","మరి ఉండ్రి సుటు, సయ్‌తాను యేసుఙ్‌ నండొ ఎత్తు మని ఉండ్రి గొరోన్‌ ముస్కు ఎకిస్తాండ్రె యా లోకమ్‌దు మని విజు దేసెమ్‌కాఙ్, మరి వన్కాఙ్‌ ముస్కు ఏలుబడిః కినివరి అతికారమ్‌ని వరిఙ్‌ కలిగితి మనికెఙ్‌ విజు తోరిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","అక్కెఙ్‌ తోరిస్తాండ్రె, “నీను నా ఎద్రు ముణుకుఙ్‌ ఊర్‌జి నఙి పొగ్‌డిఃజి మాడిఃస్తిఙ యాకెఙ్‌ విజు నాను నిఙి సీన”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","యేసు వన్ని వెట, సయ్‌తానా, నా బాణిఙ్‌ సొన్‌అ, “నీ ప్రబు ఆతి దేవుణుదిఙ్‌ పొగ్‌డిఃజి మాడిఃసి, వన్నిఙె సేవ కిదెఙ్‌ ఇజి దేవుణు మాటదు రాస్త మనాద్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","అయావలె సయ్‌తాను వన్నిఙ్‌ డిఃసి సొహాన్‌. దేవుణు దూతార్‌ వాజి వన్నిఙ్‌ నెగెణ్‌ సుడ్ఃతార్. ");
INSERT INTO kfc_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","యోహను కయ్‌ది మహాన్‌ ఇజి విహండ్రె యేసు గలిలయదు మని నజరేతు ఇని పట్నమ్‌దు మర్‌జి వాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","వెనుక యేసు నజరేతు పట్నం డిఃసి జెబులూను, నప్తాలి ప్రాంతమ్‌కాఙ్‌ డగ్రు, గలిలయ సందారం పడఃకాదు మని కపెర్నహమ ఇని పట్నమ్‌దు వాతండ్రె బత్కితాన్. ");
INSERT INTO kfc_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","16","“జెబూలూను ప్రాంతమా, నప్తాలి ప్రాంతమా, యోర్దాన్‌ అతాహ పడక సమ్‌దరం డగ్రు మని యూదురు ఆఇకార్‌ బత్కిజిని గలిలయ ప్రాంతమా, సీకటిదు బత్‌కిజి మహికార్‌ గొప్ప జాయ్‌ సుడ్ఃతార్. సావు ఉండ్రి నీడ లెకెండ్‌ మని దేసమ్‌దు బత్‌కిజి మహి లోకుర్‌ ముస్కు జాయ్‌పుట్తాద్”. ఇజి దేవుణు ముఙాల యెసయ ప్రవక్త వెట వర్గితి మాట యా లెకెండ్‌ యేసు వాతిఙ్‌ పూర్తి ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","అయా వలెహాన్‌ అసి యేసు, “దేవుణు ఏలుబడిః కిని కాలం డగ్రు ఆత మనాద్. అందెఙె మీ పాపమ్‌కు ఒప్పుకొడిఃజి డిఃసి సీదు”, ఇజి సాటిస్తెఙ్‌ మొదోల్‌స్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","యేసు గలిలయ సమ్‌దరం ఒడుదాన్‌నడిసి మహివలె, పేతురు ఇజి కూకె ఆతిసీమోనుఙ్‌ని, మరి వన్ని తంబెర్‌సి ఆతి అంద్రెయెఙ్‌ సుడ్ఃతాన్. వారు జాలెరిఙు. వీరు రిఏర్‌ సమ్‌దరమ్‌దు వల పొక్సి మొయెఙ్‌అసి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","“నా వెట రదు. నా వెట వాదెఙ్‌ లోకురిఙ్‌ నెస్పిస్నివరి లెకెండ్‌ నాను మిఙి తయార్‌ కినాలె”, ఇజి యేసు వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","వారు వెటనె వరి వలేఙ్‌డిఃస్తారె వన్ని వెనుక సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","అబెణిఙ్‌ సొన్సి మహిఙ్‌యేసు జెబెదాయి మరిసి ఆతి యాకోబుఙ్‌ని, వన్ని తంబెర్‌సి ఆతి యోహనుఙ్‌ సుడ్ఃతాన్. వారు రిఎర్‌వరి బుబ్బ ఆతి జెబెదాయి వెట డోణిదు వలెఙ్‌ నెగెణ్‌కిజి మహివలె యేసు వరిఙ్‌ కూక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","వెటనె వారు వరి డోణిని వరి బుబ్బెఙ్‌డిఃస్తారె వన్ని వెనుక సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","యేసు గలిలయ దేసెం విజు బూలాజి యూదురు మీటిఙ్‌ కిజిని ఇల్కాఙ్‌ వరిఙ్‌ నేస్పిసి, దేవుణు ఏలుబడిః కిని కాలం వందిఙ్‌ సువార్త సాటిసి మహాన్‌. విజు రకమ్‌ది జబుది వరిఙ్‌ని బాదదాన్‌ఇఙ్‌ మహివరిఙ్‌ నెగెండ్‌ కితాన్. ");
INSERT INTO kfc_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","యేసు పేరు సిరియ దేసమ్‌దు విజు సారితాద్. రకరకమ్‌ది జబుదివరిఙ్‌లోకుర్‌వన్ని డగ్రు తతార్. నండో నొపిదాన్‌బాద ఆజి మహి వరిఙ్, దెయం అస్తి వరిఙ్, మూర్‌స జబు మహి వరిఙ్, కిక్కుకాల్కు సాతివరిఙ్‌వన్ని డగ్రు తతిఙ్‌వాండ్రు వరిఙ్‌ నెగెండ్‌ కిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","గలీలయ, దెకపొలి, యెరూసలేము, యూదయ, యొర్దాను అతాహి పడఃకదాన్‌ మంద లోకుర్‌ వాజి వన్ని వెట సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","యేసు మంద లోకురిఙ్‌ సుడ్ఃతాండ్రె ఉండ్రి గొరొత్‌ ఎక్తాన్. అబె బసిమహిఙ్, వన్ని సిసూర్‌ వన్ని డగ్రు వాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","అయావలె వాండ్రు వరిఙ్‌ యా లెకెండ్‌ వెహ్సి బోదిస్తెఙ్‌ మొదోల్‌స్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“దేవుణుదిఙ్‌ సెందితిలెకెండ్‌ బత్కిజి దన్నిలొఇ మాపు తకుదికాప్‌” ఇజి నెసి మఙి మరి మండ్రెఙ్‌ ఎయెర్‌బా ఇజి కోరిజినరొ, దేవుణు సీజిని దీవనమ్‌కు మంజినె. ఎందనిఙ్‌ ఇహిఙ, వారు దేవుణు కిని ఏలుబడిఃదు మంజినార్. ");
INSERT INTO kfc_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ఏలు దుకమ్‌దాన్‌ అడఃబాజి మన్నికార్‌ దేవుణు సీని దీవనమ్‌కు మంజినికార్‌ ఆనార్‌లె, ఎందనిఙ్‌ ఇహిఙ దేవుణు వరిఙ్‌ ఓదరిస్నాన్. ");
INSERT INTO kfc_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","నిపాతి గుణం మనికార్‌ దేవుణు సీని దీవనంకు మంజినికార్‌ ఆనార్లె ఎందనిఙ్‌ ఇహిఙ యా లోకం విజు వరి సొంతం ఆనాద్. ");
INSERT INTO kfc_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","దేవుణు వెహ్తి వజ నీతినిజాయ్తిదాన్‌ మండ్రెఙ్‌ ఇజి నండో ఆస మనికార్‌ దేవుణు సీని దీవనమ్‌కు మంజినికార్‌ ఆనార్‌లె, ఎందనిఙ్‌ ఇహిఙ వరి మన్సు నిండ్రు ఆనిలెకెండ్‌ వరి ఆసెఙ్‌ దేవుణు తీరిస్నాన్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","కనికారం తోరిస్నికార్‌ దేవుణు సీని దీవనమ్‌కు మంజినికార్‌ ఆనార్‌లె, ఎందనిఙ్‌ ఇహిఙ దేవుణు వరి ముస్కు కనికారం తోరిస్నాన్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","నెగ్గి మన్సు మనికార్‌ దేవుణు సీని దీవనమ్‌కు మంజినికార్‌ ఆనార్‌లె, ఎందనిఙ్‌ ఇహిఙ వారు దేవుణుదిఙ్‌ సూణార్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","లోకుర్‌ సమాదనమ్‌దాన్‌ మండ్రెఙ్‌ ఇజి పణి కినికార్‌ దేవుణు సీని దీవనమ్‌కు మంజినికార్‌ ఆనార్‌లె, ఎందనిఙ్‌ ఇహిఙ వారు దేవుణు కొడొఃర్‌ ఇజి కూకె ఆనార్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","దేవుణు వెహ్తి వజ నాయం వందిఙ్‌ మల్లెఙఙ్‌ ఓరిస్నికార్‌ దేవుణు సీని దీవనమ్‌కు మంజినికార్‌ ఆనార్‌లె, ఎందనిఙ్‌ ఇహిఙ వారు దేవుణు కిని ఏలుబడిఃదు మంజినార్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","నా ముస్కు నమకం ఇట్తి వందిఙ్‌ లోకుర్‌ మీ ముస్కు నిందెఙ్‌ మోప్సి మిఙి మల్లెఙ్‌ కిజి, మరి మీ ముస్కు అబద్దమాతి సెఇ మాటెఙ్‌ విజు వెహ్ని వెలె మీరు దేవుణు సీని దీవనమ్‌కు మంజినికార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","అయావలె నండొ సర్‌ద ఆజి మండ్రు. ఎందనిఙ్‌ ఇహిఙ పరలోకామ్‌దు మిఙి నండొ పలం దొహ్‌క్నాద్‌లె. మీ ముందాల బత్కిజి మహి దేవుణు ప్రవక్తరుఙ వెటబా వారు యాలెకెండ్‌ మల్లెఙ్‌ కితార్. ");
INSERT INTO kfc_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","మీరు యా లోకమ్‌దు సోరు ననికిదెర్. గాని, సోరుదిఙ్‌ రుసి సొహిఙ, ఎలాగ దనిఙ్‌ రుసి మర్‌జి తపిస్తెఙ్‌ ఆనాద్‌? అక వెల్లి విసీర్‌జి లోకుర్‌ మట్తెఙ్‌నె ఆఎండ మరి ఇని పణిదిఙ్‌బా రఇక. ");
INSERT INTO kfc_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","మీరు యా లోకమ్‌దు మనివరిఙ్‌ జాయ్‌ననికిదెర్. గొరొన్‌ ముస్కు మని పట్నం డాఙ్‌జి మండ్రెఙ్‌ అట్‌ఏద్. ");
INSERT INTO kfc_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ఎయెర్‌బా ఉండ్రి దీవ కసిసి తూముదాన్‌ ముసి ఇడ్‌ఎర్. గాని ఇండ్రొణివరిఙ్‌ విజేరిఙ్‌ జాయ్‌సినివజ దీవ కంతూదునె ఇడ్నార్. ");
INSERT INTO kfc_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","అయాలెకెండ్‌నె, మీ బత్కు విజేరిఙ్‌ జాయి సీనివజ మండ్రెఙ్. నస్తివలె మీరు కిని నెగ్గి పణిఙ సుడ్ఃజి లోకుర్‌ విజెరె దేవుణు మంజిని బాడిఃదు మని మీ బుబాతి దేవుణుదిఙ్‌ పొగి‌డిఃనార్. ");
INSERT INTO kfc_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","దేవుణు సితి రూలుఙ్‌ గాని, దేవుణు ప్రవక్తరు వెహ్తి మాటెఙ్‌ గాని డెయ్‌జి పొక్తెఙ్‌నాను వాత మన్న ఇజి మీరు ఒడ్‌బిమాట్. వనకాఙ్‌ డెయ్‌జిపొక్తెఙ్‌ ఇజి సిల్లెద్‌, గాని అయాలెకెండ్‌నె పూర్తి కిదెఙ్‌నె నాను వాత మన్న. ");
INSERT INTO kfc_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ఏలుహన్‌ అసి బూమి ఆగాసం సిల్లెండ ఆతిఙ్‌బా దేవుణు మాటదు మని ఉండ్రి ఇజిరి అక్సరం గాని, సున్న గాని, రాస్తి మని లెకెండ్‌ పూర్తి ఆఏండ సొన్‌ఉ ఇజి నాను మిఙి నిజం వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ఎయెన్‌బా దేవుణు మాటదు మని ఇజిరి ఆగ్నెఙ్‌ లోఇ ఉండ్రి దనిఙ్‌ లొఙిజి మన్‌ఏండ, అయాలెకెండ్‌ లొఙిఏండ మండ్రెఙ్‌ ఇజి లోకురిఙ్‌ నెస్పిస్తిఙ వన్నిఙ్, దేవుణు ఏలుబడిః కినివరి లోఇ లావ్‌ ఇజిరికాన్‌ లెకెండ్‌ వాండ్రు ఇడ్నాన్‌లె. గాని ఎయెర్‌బా దేవుణు మాటదు రాస్తిమని లెకెండ్‌ లోకురిఙ్‌ నెస్పిసి అయాలెకెండ్‌నె కిజి మహిఙ దేవుణు ఏలుబడిః కినివరి లొఇ వారు గొప్ప పెరికార్‌ ఆనాన్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","మీరు కిని పణిఙ్, పరిసయ్‌రుఙుని యూదురి రూలుఙ్‌ నెస్పిస్నికార్‌ కిని పణిఙ ముస్కు, దేవుణు ముందాల ఒదె సరి ఆతికెఙ్‌ ఇహిఙనె, మీరు దేవుణు కిని ఏలుబడిఃదు మంజినిదెర్‌లె ఇజి నాను మిఙి వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“లోకాఙ్‌ సప్తెఙ్‌ ఆఏద్‌” ఎయెన్‌బా ఒరెన్‌ వన్నిఙ్‌ సప్తిఙ, వన్నిఙ్‌ తప్‌ఏండ తీర్పు వానాద్‌లె ఇజి ముందాహన్‌ అసి వెహ్తి మని మాట మీరు వెహిమనిదెర్‌ గదె? ");
INSERT INTO kfc_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","గాని ఏలు నాను మిఙి వెహ్నిక ఇనిక ఇహిఙ ఎయెన్‌బా, మరి ఒరెన్ వన్ని ముస్కు కోపం ఆతిఙ వన్నిఙ్‌ తీర్పు వానాద్. ఎయెన్‌బా మరి ఒరెన్‌ వన్నిఙ్‌ “పణిదిఙ్‌ రెఇకి”, ఇజి వెహ్తిఙ వాండ్రు సన్‌హద్రి సఙం ఎద్రు దన్ని వందిఙ్‌ సమాదనం వెహ్తెఙ్‌వలె. ఎయెన్‌బా మరి‌ ఒరెన్‌ వన్నిఙ్‌ “బుద్ది సిలికి”, ఇజి వెహ్తిఙ, వాండ్రు ఎలాకాలం సిసు కసి మంజిని బాడిఃదు అర్న మంజినాన్. ");
INSERT INTO kfc_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","నీను దేవుణుదిఙ్‌ సంద సుర్ని మాలి పీటాదు సంద సిదెఙ్‌ సొనివెలె, మరి‌ ఒరెన్‌ వన్నిఙ్‌ నీ ముస్కు ఇనికాదొ కోపం మనాద్‌ ఇజి అబె నిఙి ఎతు వాతిఙ, సంద సీదెఙ్‌తతి వన్కాఙ్‌ అబె ఇడ్ఃజి వెటనె సంద సుర్ని మాలిపీట డిఃసి సొన్సి, ముందాల నీను వనివెట రాజినం ఆఅ. వెనుక మర్‌జి వాజి దేవుణుదిఙ్‌ సంద సుర్జి సిఅ. ");
INSERT INTO kfc_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","నిఙి కోర్టు కిదెఙ్‌అకు మని వన్ని వెట బేగి రాజినం ఆఅ. టయం మనివెలనె ఆక కిఅ. సిలిఙ వాండ్రు నిఙి తీర్పు కిని వరిఙ్‌ ఒపజెప్నాన్. తీర్పు కినికార్‌ నిఙి జెలిదు ఇడ్‌దెఙ్‌ అతికారిఙ్‌ ఒపజెప్నార్. వాండ్రు నిఙి జెలిదు ఇడ్నాన్. ");
INSERT INTO kfc_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ఉండ్రి పయ్సబా సిల్లెండ అపు మనిక విజు సీనిదాక నీను వెల్లి వాదెఙ్‌ అట్‌ఇ, ఇజి నాను నిఙి నిజం వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“రంకు బూలాదెఙ్‌ ఆఏద్‌” ఇజి వెహ్తి మనిక మీరు వెహి మనిదెర్‌ గదె. ");
INSERT INTO kfc_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","గాని నాను మిఙి వెహ్నిక ఇనిక ఇహిఙ ఎయెన్‌బా మన్సుదు సెఇ ఆసదాన్‌ ఉండ్రి అయ్‌లి కొడొఃదిఙ్‌ బేస్తిఙ వాండ్రు అయావలెనె దనివెట వన్ని మన్సుదు పాపం కితికాన్‌ ఆజినాన్. ");
INSERT INTO kfc_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","నీ ఉణెర్‌ కణక నిఙి తపు కిబిస్తిఙ దనిఙ్‌ లాగ్జి విసీర్‌అ. నీనె ఎల్ల కాలం సిసు మంజిని బాడిఃదు సొన్సి అర్‌ఎండ, మీ ఒడొఃల్‌దాన్‌ ఉండ్రి ముక సొహిఙ అక్కాదె నెగెద్. ");
INSERT INTO kfc_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","మరి నీ ఉణెర్‌ కియు నిఙి తపు కిబిస్తిఙ, దనిఙ్‌ కత్సి విసీర్‌అ. నీనె ఎలాకాలం సిసు మంజిని బాడిఃదు సొన్సి అర్‌ఎండ, నీ ఒడొఃల్‌దాన్‌ ఉండ్రి ముక సొనికదె నెగెద్. ");
INSERT INTO kfc_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ఎయెన్‌బా వన్ని ఆల్సిఙ్‌ డిఃసి సీదెఙ్‌ ఇహిఙ ఇబ్బెణిఙ్‌ అసి నీను నా ఆల్సి ఆఎద్‌‌ ఇజి దనిఙ్‌ ఉండ్రి విడిఃఆకు రాసి సీదెఙ్‌ ఇజి వెహ్తిక మీరు వెహి మనిదెర్‌గదె? ");
INSERT INTO kfc_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","గాని నాను మీ వెట వెహ్నిక ఇనిక ఇహిఙ, రంకు బూలాఇదనిఙ్‌ మాసి డిఃస్తి సితిఙ, వాండ్రు దనిఙ్‌రంకు బాలాదెఙ్‌కిబిస్నికాన్‌ ఆజినాన్. మరి ఎయెన్‌బా దనిఙ్‌పెండ్ఃలి కితిఙ వాండ్రు దనివెట రంకు బూలానికాన్‌ ఆజినాన్. ");
INSERT INTO kfc_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","మరి ఇనిక ఇహిఙ, “‘నీను కితి ఒట్టు పొక్తిక అయాలెకెండ్‌ కిఏండ తప్తెఙ్‌ ఆఎద్, దేవుణు ముందాల కితి ఒట్టుదిఙ్‌ అయావజనె కిదెఙ్‌’ ఇజి వెహ్తిక ముందాహన్‌ అసి మీరు వెహిమనిదెర్‌ గదె. ");
INSERT INTO kfc_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","నాను మీ వెట వెహ్నిక ఇనిక ఇహిఙ ఇనిదనిఙ్‌బా ప్రమాణం కిమాట్. ఆకాసం తోడుః ఇజి వెహ్‌మాట్, అక దేవుణు బసిని సింహాసనం. ");
INSERT INTO kfc_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","సిలిఙ బూమి తోడుః ఇజి వెహ్‌మాట్, అక దేవుణు వన్ని కాల్కు ఇడ్ని పీట. మరి యెరూసలేం తోడుః ఇజి వెహ్‌మాట్‌, రాజు ఆతి దేవుణుదిఙ్‌ సెందితి పట్నం. ");
INSERT INTO kfc_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","నీ బుర్ర తోడుః ఇజిబా వెహ్‌మ, ఎందనిఙ్‌ ఇహిఙ నీ బుర్రది కొపువెంటి ఉండ్రిబా తెలాఙ్‌ గాని కరిఙ్‌ గాని కిదెఙ్‌ నీను అట్‌ఇ. ");
INSERT INTO kfc_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","మీ మాటెఙ్‌ ‘ఒఒ ఇహిఙ ఒఒ’, ఇజి మండ్రెఙ్. ‘ఆఎద్‌ ఇహిఙ ఆఎద్’, ఇజినె మండ్రెఙ్. వనకాఙ్‌ మిస్తికెఙ్‌ సెఇ వన్నిబాణిఙ్‌ వానికెఙ్”. ");
INSERT INTO kfc_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“‘కణకాదిఙ్‌ బదులు కణక, పలుదిఙ్‌ బదులు పలు’ ఇజి దేవుణు మోసేఙ్‌ సిత్తి మన్ని రూలుదు వెహ్తి మహిక మీరు వెహిమనిదెర్‌ గదె? ");
INSERT INTO kfc_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","నాను మిఙి వెహ్సిన, సెఇ పణిఙ్‌ కిని వరిఙ్‌ అడ్డు కిమ. మరి నీను వన్ని ముస్కు కోపమాజి వాండ్రు నిఙి కిత్తిదన్నిఙ్‌ మర్‌జి కిదెఙ్‌ ఆఏద్‌. ఎయెన్‌బా ఉణెర్‌ లెపాదు డెఃయ్తిఙ, డేబ్ర లెపబా వన్నిఙ్‌ తోరిస్‌అ. ");
INSERT INTO kfc_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ఎయెన్‌బా నిఙి కోర్‌టు కిజి నీ సొక లాగ్‌దెఙ్‌ సుడ్ఃతిఙ, నీ కండువాబా వన్నిఙ్‌ సీజి మన్‌అ. ");
INSERT INTO kfc_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","మరి, ఒరెన్‌ రోమ సయ్‌నమ్‌దికాన్‌ వన్ని ఒస్తుఙ్‌ పిండిజి వన్ని వెట ‘ఉండ్రి మయిలు దూరం రఅ’ ఇజి నిఙి బలవంతం కితిఙ వన్నివెట రుండి మయిలుఙ్‌ దూరం ఇడ్డి సొన్‌అ. ");
INSERT INTO kfc_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","నిఙి లొస్నివన్నిఙ్‌ సిఅ, మరి నిఙి అపు లొస్నివరిబాణిఙ్‌ మొకొం మహ్‌మ”. ");
INSERT INTO kfc_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“‘నీ పడకాతి వన్నిఙ్‌‌ ప్రేమిస్‌అ, పగాతి వరిఙ్‌ ఇస్టం ఆఏండ మన్‌అ.ముస్కు కోపమ్‌దాన్‌ మన్‌అ’, ఇజి వెహ్తిమహిక మీరు వెహిమనిదెర్‌ గదె? ");
INSERT INTO kfc_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","గాని నాను మిఙి వెహ్నిక ఇనిక ఇహిఙ, మీ పగ్గతి వరిఙ్‌ ప్రేమిస్తు, మిఙి హిమ్‍స కిజిని వరి వందిఙ్‌ పార్దనం కిదు. ");
INSERT INTO kfc_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","అహిఙ మీరు పరలోకామ్‌దు మన్ని మీ బుబ్బాతి దేవుణుది నిజమాతి కొడొఃర్‌ ఇజి తోరె ఆనిదెర్‌లె. దేవుణు సెఇవరి ముస్కుబా నెగ్గివరి ముస్కుబా వన్ని పొదు జాయ్‌ సిబిసినాన్. నాయం మని వరి ముస్కుబా నాయం సిలివరి ముస్కుబా పిరు పోక్సినాన్. ");
INSERT INTO kfc_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","మిఙి ప్రేమిస్నివరిఙె మీరు ప్రేమిస్తిఙ దేవుణు మిఙి పలం సీనాన్‌ ఇజి మీరు ఒడిఃబిజినిదెరా? పను పెర్‌నికార్‌బా ఆహె కిజినార్‌ గదె? ");
INSERT INTO kfc_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","మీరు మీ కూల వరిఙె మీరు మాడిఃసినిదెర్‌ ఇహిఙ మీరు ఆఇకార్‌ కినిదనిఙ్‌ ఇంక మిస్తిక ఇనిక కిజినిదెర్‌? యూదురు‌ ఆఇకార్‌బా అయాలెకెండ్‌ కిజినార్‌ గదె? ");
INSERT INTO kfc_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","పరలోకామ్‌దు మన్ని మీ బుబాతి దేవుణు ఇని కల్తి సిలికాన్. అందెఙె మీరుబా అయాలెకెండ్‌నె మండ్రు.” ");
INSERT INTO kfc_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","మీరు కిని నెగ్గి పణిఙ్‌ లోకుర్‌ సుడ్ఃదెఙ్‌ ఇజి వరి ముందాల కిఏండ జాగర్త మండ్రు. ఎందనిఙ్‌ఇహిఙ ఆహె కితిఙ పరలోకామ్‌దు మని బుబ్బాతి దేవుణు బాణిఙ్‌ మిఙి ఇని పలంబా దొహ్క్‌ఏద్. ");
INSERT INTO kfc_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","అందెఙె అవ్‌సరం మని వరిఙ్‌ ఇనికబా సితిఙ, వేసం కినికార్‌ కిని లెకెండ్‌ అక విజేరిఙ్‌ తెలిని లెకెండ్‌ జోడుఃబాంక ఊక్‌పిసి డేల్సి వెహ్మాట్. విజెరి ముందాల మఙి గొప్ప పేరు వాదెఙ్‌ ఇని ఆసదాన్‌ వారు యూదురు మీటిఙ్‌ కిని ఇల్కాఙ్, మరి సర్‌దు ఆహె కిబిస్నార్‌. వరిఙ్‌ అయావలెనె పూర్తి పలం దొహ్‌క్త మనాద్‌ ఇజి నాను మిఙి నిజం వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","గాని నీను అవ్‌సరమ్‌దు మనివరిఙ్‌ సాయం కినివెలె, నీ ఉణెర్‌ కియు కినిక నీ డేబ్ర కియు నెస్తెఙ్‌ ఆఎద్. ");
INSERT INTO kfc_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","అహిఙ నీను సితిక ఎయెర్‌బా నెస్‌ఏండ మంజినాద్. అయావలె ఎయెర్‌బా నెస్‌ఎండ నీను కితిక సుడ్ఃజిని నీ బుబ్బాతి దేవుణు నిఙి పలం సీనాన్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","మీరు పార్దనం కినివెలె వేసం కిని వరి లెకెండ్‌ మన్‌మాట్. లోకుర్‌ విజేరె సూణి లెకెండ్‌ యూదురు మీటిఙ్‌ కిని ఇల్కాఙ్, మరి సర్దు నిల్సి పార్దనం కిదెఙ్‌ వరిఙ్‌ ఇస్టం. వరిఙ్‌ పూర్తి పలం దొహ్‌క్త మనాద్‌ ఇజి నాను మిఙి నిజం వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","గాని నీను పార్దనం కినివెలె. నీను గదిదు సొన్సి సేహ్ల కెహ్సి, ఎయెర్‌బా తొఇ నీ బుబ్బాతి దేవుణు వెట పార్దనం కిఅ. అహిఙ ఎయెర్‌బా నెస్‌ఎండ నీను కితిక సుడ్ఃజిని ఎయెరిఙ్‌బా తోరె ఆఇ నీ బుబాతి దేవుణు నిఙి పలం సీనాన్. ");
INSERT INTO kfc_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","మరి మీరు పార్దనం కినివెలె యూదురు ఆఇ వరి లెకెండ్‌ పణిదిఙ్‌ రెఇ మాటెఙ్‌ వెహ్మాట్. అయాలెకెండ్‌ లావ్‌వర్‌గితిఙానె దేవుణు వినాన్‌ ఇజి వారు ఒడ్ఃబిజినార్. ");
INSERT INTO kfc_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","మీరు వరిలెకెండ్‌ మండ్రెఙ్‌ ఆఏద్. ఎందనిఙ్‌ ఇహిఙ మిఙి అవ్‌సరం ఆతిక ఇనిక ఇజి మీరు లొస్ని ముందాల్నె మీ బుబ్బాతి దేవుణు నెసినాన్. ");
INSERT INTO kfc_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“అందెఙె మీరు యా లెకెండ్‌ పార్దనం కిదెఙ్. ‘పరలోకామ్‌దు మని మా బుబ్బాతి దేవుణు, లోకుర్‌ విజెరె నీ పేరు గొప్ప నెగ్గిక ఇజి గవ్‌రం సిపిర్. ");
INSERT INTO kfc_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","నీ ఏలుబడిః లోకుర్‌ విజెరి ముస్కు మనీద్‌. పరలోకామ్‌దు నిఙి ఇస్టమాతికెఙ్‌ జర్‌గిని లెకెండ్‌నె బూమి ముస్కుబా జర్గిపిద్. ");
INSERT INTO kfc_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","రోజురోజుదిఙ్‌‌ మఙి కావాలిస్తి తిండి అయ రోజు మఙి సీజి మన్‌అ. ");
INSERT INTO kfc_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","వేరెదికార్‌ మా వెట కితి తపుఙ్‌ మాపు వరిఙ్‌ సెమిస్తి లెకెండ్‌నె, మాపు కితి తపుఙ్‌ మఙిబా సెమిస్‌అ. ");
INSERT INTO kfc_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","పాపం కిబిస్ని సెఇ ఆసెఙ్‌ మా లొఇ రెఏండ, సయ్తాను బాణిఙ్‌ మఙి తప్రిస్‌అ’. ");
INSERT INTO kfc_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","లోకుర్‌ మిఙి కిని తపుఙ్‌ మీరు వరిఙ్‌ సెమిస్తిఙ, పరలోకామ్‌దు మన్ని మీ బుబ్బాతి దేవుణుబా మీరు కిని తపుఙ్‌ మిఙి సెమిస్నాన్. ");
INSERT INTO kfc_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","గాని, మీరు లోకుర్‌ మీ వెట కిని తపుఙ్‌ మీరు వరిఙ్‌ సెమిస్‌ఎండ మహిఙ, పరలోకామ్‌దు మన్ని మీ బుబ్బాతి దేవుణుబా మీరు కిని తపుఙ్‌ మిఙి సెమిస్‌ఏన్.” ");
INSERT INTO kfc_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“మీరు ఉపాస్‌కినివలె, వేసం కిని వరిలెకెండ్‌ మండ్రెఙ్‌ ఆఏద్. ‘మాప్‌ ఉపాస్‌ మంజినాప్‌’ ఇజి విజేరె నెస్తెఙ్‌ ఇజి వారు మొకొం నీర్సం కిజి మంజినార్. అయావలెనె వరిఙ్‌ పూర్తి పలం దొహ్‌క్త మనాద్‌ ఇజి నాను మిఙి నిజం వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","గాని మీరు ఉపాస్‌కినివెలె బురాదు నూనె రాసె ఆజి మొకొం ఊర్‌పాజి మండ్రు. అహిఙ మీరు ఉపాస్‌కనిక లోకుర్‌ ఎయెర్‌బా నెస్‌ఎర్. గాని ఎయెర్‌బా తొఇ మీ బుబ్బాతి దేవుణు ఒరేండ్రె నెస్నాన్. ఎయెర్‌బా నెస్‌ఎండ మీరు కినిక సుడ్ఃజిని మీ బుబాతి దేవుణు మిఙి పలం సీనాన్.” ");
INSERT INTO kfc_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","డొఙారి డుఃగ్‌జి ఒతెఙ్‌ అక్కు మని, మరి సెదని కరి తిండ్రెఙ్‌ అకుమని యా బూమి ముస్కు మీ వందిఙ్‌ సమ్‌సారం గణస్‌మాట్. ");
INSERT INTO kfc_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","గాని డొఙారిఙు డుఃగ్‌జి ఒతెఙ్‌ అట్‌ఇ, మరి సెద గాని కరి గాని పాడ్ః కిదెఙ్‌ అట్‌ఇ దేవుణు మంజిని బాడిఃదు మీ వందిఙ్‌ సమ్‌సారం గణస్తు. ");
INSERT INTO kfc_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ఎందనిఙ్‌ఇహిఙ నీ సమ్‌సారం ఎంబె మనాదొ అబెనె నీ మన్సుబా మంజినాద్. ");
INSERT INTO kfc_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","కణక ఒడొఃల్‌దిఙ్‌ దీవ లెకెండ్‌నె మనాద్. నీ కణక నెగ్గిక ఇహిఙ నీ ఒడొఃల్‌దిఙ్‌ విజు నెగ్గికెఙ్‌ తసి మంజినాద్. ");
INSERT INTO kfc_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","నీ సెఇ ఉదెసమ్‌దాన్‌ నీ కణుకెఙాణిఙ్‌ సుడిఃజి మహిఙ, నీ మన్సు ‌విజు సీకటి మంజినాద్. నీ ఓడొల్‌ విజుబా‌ సీకటి ఆజి మంజినాద్‌. నిఙి మనాద్‌ ఇజినీను ఒడ్ఃబిజిని జాయ్‌ సీకటి ఆతిఙ, అయ సీకటి ఎసోనో సీకటి. ");
INSERT INTO kfc_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","ఎయెన్‌బా రిఎర్‌ ‌ఎజుమానిరు వందిఙ్ ‌ఉండ్రె లెకెండ్‌ పణి కిదెఙ్‌ అట్‌ఎన్. ఒరెన్‌ వన్నిఙ్‌ ప్రేమిసి మరి ఒరెన్‌ ముస్కు ఇస్టం సిల్లెండ మంజినాన్. సిల్లిఙ ఒరెన్‌ వన్నిఙ్‌ లొఙిజి నమ్మకమాతి వనిలెకెండ్‌ మంజినాన్. మహివన్ని ముస్కు సెఇ మాటెఙ్‌ వర్గిజి మంజినాన్‌. అయలెకెండ్‌నె దేవుణుదిఙ్‌ని డబ్బుదిఙ్‌ ఉండ్రె లెకెండ్‌ ప్రేమిస్తెఙ్‌ మీరు అట్‌ఇదెర్. ");
INSERT INTO kfc_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","అందెఙె నాను మిఙి వెహ్నిక ఇనిక ఇహిఙ, ఇనిక తినాప్లె, ఇనిక ఉణాప్లె ఇజి మీ బత్కు వందిఙ్‌విసారం ఆమాట్. మరి మా ఒడొఃల్‌వందిఙ్‌ ఇనిక పొర్‌పానాప్లె ఇజి ఒడిఃబిమాట్. మీ పాణం తిండిదిఙ్‌మిస్తిక ఆఎదా? మీ ఒడొఃల్‌ సొక్క పాతెఙ మిస్తిక ఆఎదా? ");
INSERT INTO kfc_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ఆగాసమ్‌దు ఎగ్రిజిని పొటిఙ సుడ్ఃదు. అవి విత్‌ఉ, కొయ్‌ఉ, ఒసి కొటుదు వాక్‌ఉ గాని పరలోకామ్‌దు మని మీ బుబ్బాతి దేవుణు వనకాఙ్‌ పోస కిజినాన్. మీరు వన్కా మిస్తి విలువ మనికిదెర్‌ ఆఇదెరా? ");
INSERT INTO kfc_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","మీ లోఇ ఎయెన్‌బా విసారిస వన్ని బత్కుదిఙ్‌ ఉండ్రి గంట కుడుఃప్తెఙ్‌ అట్‌నాండ్రా? ");
INSERT INTO kfc_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","మరి ఎందనిఙ్‌ సొకెఙ వందిఙ్‌ మీరు విసారిసినిదెర్‌? మడిఃఙ మని పూఙు సుడ్ఃదు, అవి కస్టబాడ్‌ఉ, సొక కిదెఙ్‌ నూలుఙ్‌ తయార్‌ కిఉ. ");
INSERT INTO kfc_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","అహిఙ్‌బా విజు ఆస్తి కలిగితి మన్ని సొలొమోను రాజు యా ఉండ్రి పూఙు లకెండ్‌ సోకు మన్ని ఉండ్రి సొక్క తొడిఃగిఏతాన్‌, ఇజి నాను మిఙి వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","నేడ్రు మంజి విగెహిఙ్‌ సిసుద్‌ సురె ఆని మడిఃఙ మని యా గడిదిఙ్‌ దేవుణు యా లెకెండ్‌ సోకు సిత్తాన్. అహిఙ, ఇజిరి నమకం మనికిదెరా మరి ఒదె నగెండ్‌మిఙి సొకెఙ్‌ తొడిఃగిస్‌ఎతాండ్రా? ");
INSERT INTO kfc_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","అందెఙె మీరు, “ఇనిక తినాప్‌లె, మరి ఇనిక ఉణాప్‌లె, సిలిఙ ఇనిక పొర్పానాప్‌లె”, ఇజి ఒడిఃబిజి బాద ఆమాట్. ");
INSERT INTO kfc_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ఎందనిఙ్‌ ఇహిఙ దేవుణుదిఙ్‌ నెస్‌ఇకార్‌నె విన్‌క వందిఙ్‌ రెబాజినార్‌. యాకెఙ్‌ విజు మిఙి అవ్‌సరం ఇజి పరలోకామ్‌దు మని మీ బుబ్బాతి దేవుణు నెసినాన్. ");
INSERT INTO kfc_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","గాని విజు దనిఙ్‌ ఇంక దేవుణు ఏలుబడిః కిని వందిఙ్‌ని మరి వన్ని ఎద్రు మీరు నీతినిజయ్తిదాన్‌ మండ్రెఙ్‌ ఇజి ఆస ఆజి మండ్రు. నస్తివలె మిఙి కావాలిస్తికెఙ్‌ విజు మిఙి దొహ్‌క్నె. ");
INSERT INTO kfc_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","విగెహిఙ్‌ వందిఙ్‌ విసారిస్మాట్. విగెహిఙ్‌ జర్గిని వన్కా వందిఙ్‌ విగెహిఙ్‌ విసారిస్తు. ఎమేణి రోజుదిఙ్‌ తగితి కస్టం అయ రోజుదు మంజినె. ");
INSERT INTO kfc_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“మహి వరి ముస్కు తీర్పు కిమాట్. అహిఙ దేవుణు మిఙిబా తీర్పు కినాన్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","మీరు మహివరిఙ్‌ ఎలాగ తీర్పు కినిదెరొ అయలెకెండ్‌నె దేవుణు మిఙిబా తీర్పు వానాద్‌లె. మీరు ఇని కొల్తదానె దేవుణు మిఙిబా తీర్పు సీనాన్లె. ");
INSERT INTO kfc_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","నీ కణకాదు ఉండ్రి తూలం ననిక మహివలె, దనిఙ్‌ సుడ్‌ఏండ, నీను, నీ తంబెరి కణకాదు మని ఇజిరి కసరాదిఙ్‌ ఎందనిఙ్‌ బేసిని? ");
INSERT INTO kfc_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","‘నీ కణకాదు తూలం ననిక మనివెలె అక లాగ్‌ఎండ, నీ తంబెరి కణకాదు మని ఇజిరి కసరాదిఙ్‌ నాను లాగ్జి విసీర్న’ ఇజి నీను ఎలాగ వెహ్సిని? ");
INSERT INTO kfc_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","వేసం కినికిదెరా, ముందాల నీ కణకాదు మని తూలం ననిక లాగ్‌అ. అయావలె నీ తంబెరి కణకాదు మని ఇజిరి కసరాదిఙ్‌ నెగెండ్‌ సుడ్ఃజి లాగ్‌దెఙ్‌ అట్ని. ");
INSERT INTO kfc_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","దేవుణుదిఙ్‌ సెందితి సఙతిఙ్‌ అక్కెఙ్‌ ఇస్టం కిఇ వరిఙ్‌ నెస్పిస్తెఙ్‌ ఇజి సుడ్ఃమట్. అయలెకెండ్‌ కితిఙ, వారు తిండి సీని వరిఙ్‌ కట్ని సెఇ నుకుడిఙ్‌ లెకెండ్‌ వారు కొపం ఆజి మర్‌జి మీ ముస్కు వాజి అర్నార్. గొప్ప విలువ మనికెఙ్‌ పండ్రిఙ్‌ ముందాల ఇట్తిఙ అక్కెఙ్‌ వన్కాఙ్‌ కాల్కాణిఙ్‌ మట్ని లెకెండ్‌ వారుబా కినార్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","మీరు ఇనిక లొస్నిదెరొ అక మిఙి దేవును సీనాన్‌. ఇనిక మీరు రెబాజినిదెరొ అక దేవుణు మిఙి సీనాన్‌. కొతు మీ వందిఙ్‌ దేవుణు సెహ్లె రే ఆనాన్లె. ");
INSERT INTO kfc_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","లొస్నివరిఙ్‌ విజేరిఙ్‌ దొహ్‌క్నె, రెబానివన్నిఙ్‌ తోరె ఆజినాద్. కొత్త్సిని వన్నివందిఙ్‌ సేహ్ల రే ఆనాద్. ");
INSERT INTO kfc_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","మీ మరిన్‌ మిఙి తిండి లొస్తిఙ, మీరు ఎయిదెర్‌బా వన్నిఙ్‌ పణుకు సీనిదెరా? ");
INSERT INTO kfc_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","మరి వాండ్రు మొయ లొస్తిఙ, సరాస్‌సీనిదెరా? ");
INSERT INTO kfc_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","మీరు సెఇకిదెర్‌ ఆతిఙ్‌బా మీ కొడొఃరిఙ్‌ నెగ్గి ఇనామ్‌కునె సీదెఙ్‌ ఇజి నెస్నిదెర్. అహిఙ పరలోకామ్‌దు మని మీ బుబ్బాతి దేవుణు, వన్నిఙ్‌ లొస్నివరిఙ్‌ దినిఙ్‌ ఇంక మరి ఒదె నెగ్గి ఇనామ్‌కు సిఏండ్రా? ");
INSERT INTO kfc_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","అందెఙె విజు సఙతిఙ లోఇ, మహికార్‌ మిఙి ఇనిక కిదెఙ్‌ ఇజి మీరు కోరిజినిదెరొ అయలెకెండ్‌నె మీరు వరిఙ్‌ కిదు. దేవుణు మోసెఙ్‌ సితి రూలుఙ్‌ని దేవుణు ప్రవక్తరు వర్గితి మాటెఙ అర్దం యాకాదె.” ");
INSERT INTO kfc_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","ఇహ్కు సరి గవ్‌నిదాన్‌ సొండ్రు. ఎందనిఙ్‌ ఇహిఙ నాసనమ్‌దు సొని సరి ఒసార్‌దిక. అయ గవునిబా ఒసార్‌దిక. అయ సర్దు సొనికార్‌ నండొండార్‌ మనార్. ");
INSERT INTO kfc_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ఎలాకాలం మంజిని బత్కు సీని సరి ఇహ్కుదికాదె, దని గవునిబా ఇహ్కుదిక. అయ సరిదాన్‌ నడిఃనికార్‌ కొకొండారె. ");
INSERT INTO kfc_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","నెగ్గికాప్‌ ఇజి నాటిసినికార్‌ గాని తపు నెస్పిస్ని ప్రవక్తరు వందిఙ్‌ జాగర్‌త మండ్రు. వారు ప్రమాదమాతి మూర్‌కతం మని కార్‌నుకుడిఃఙ్ లెకెండ్‌ మనికార్. గాని వెల్లిహన్‌ గొర్రె లెకెండ్‌ ప్రమాదం సిలికార్‌ ఇజి తోరె ఆజినార్. ");
INSERT INTO kfc_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","వరి పణిఙాణిఙ్‌ మీరు వరిఙ్‌ నెస్నిదెర్‌లె. ఎయెర్‌బా సాప్కుతుపెఙాణిఙ్‌ ద్రాసపట్కు కొయ్‌ఏర్. సాప్కు మరెకాఙ్‌ బొడె పట్కు కొయ్‌ఏర్. ");
INSERT INTO kfc_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","అయలెకెండ్‌నె విజు నెగ్గి మరెకాఙ్, నెగ్గి పట్కునె అస్నె, మరి సెఇ మరాతు సెఇ పట్కునె అస్నె. ");
INSERT INTO kfc_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ఉండ్రి నెగ్గి మరాతు సెఇ పట్కు అస్‌ఉ, మరి సెఇ మరాతు నెగ్గి పట్కు అస్‌ఉ. ");
INSERT INTO kfc_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","నెగ్గి పట్కు అస్‌ఇ మరెక్‌ విజు కత్సి సిసుద్‌ విసీరె ఆనెలె. ");
INSERT INTO kfc_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","అయలెకెండ్‌నె వరి పణిఙాణిఙ్‌ మీరు వరిఙ్‌ నెస్నిదెర్. ");
INSERT INTO kfc_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ప్రబువా, ప్రబువా ఇజి నఙి కూక్నికార్‌ విజెరె దేవుణు ఏలుబడిఃదు మన్‌ఏర్, గాని పరలోకామ్‌దు మని నా బుబెఙ్‌ ఇస్టమాతి వజ కినికాండ్రె దేవుణు ఏలుబడిఃదు మంజినాన్. ");
INSERT INTO kfc_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","తీర్పు తీరిసిని దినమ్‌దు నండొండార్‌ నా డగ్రు వాజి, “ప్రబువా, ప్రబువా మాపు నీ పేరుదాన్‌ దేవుణు ప్రవక్తరు వజ వర్‌గిఎతాపా? నీ పేరుదాన్‌ దెయమ్‌కాఙ్‌ పెర్‌ఏతాపా? నీ పేరుదాన్‌ నండొ బమ్మాతి పణిఙ్‌ కిఎతాపా?”, ఇజి వెహ్నర్. ");
INSERT INTO kfc_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","అయావలె, “నాను మిఙి ఎసెఙ్‌బా నెస్‌ఎత. సెఇ పణిఙ్‌ కినికిదెరా, నా డగ్రుహన్‌ సొండ్రు ఇజి వరిఙ్‌ తినాఙ్‌ వెహ్న. ");
INSERT INTO kfc_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","అందెఙె, యా నా మాటెఙ్‌ వెంజి అయా వజ కినికాన్‌ ఎయెన్‌బా, సటు ముస్కు వన్ని ఇలు తొహ్తి బుది మనివన్నిఙ్‌ పోలిత మనాన్. ");
INSERT INTO kfc_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","పిరు వాతాద్. గడ్డెఙ్‌ నిండ్రిజి సొహె. గాలి వాజి అయ ఇలు ముస్కు డెఃతూద్‌ గాని అయ ఇలు పునాది సటు ముస్కు మనిఙ్‌ అర్‌ఎతాద్. ");
INSERT INTO kfc_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","గాని యా నా మాటెఙ్‌ వెంజి వన్కా లెకెండ్‌ కిఇకార్‌ ఎయెన్‌బా ఇస్క ముస్కు వన్ని ఇలు తొహ్తి బుద్ది సిలి వన్నిఙ్‌ పోలిత మనాన్. ");
INSERT INTO kfc_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","పిరు వాతాద్. గడ్డెఙ్‌ నిండ్రిజి సొహె. గాలి వాజి అయ ఇలు ముస్కు డెఃయ్‌తాద్. అయావలె అయ ఇలు నండొ జాటుదాన్‌ అడిఃగి అర్తాద్.” ");
INSERT INTO kfc_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","యేసు యా మాటెఙ్‌ వెహ్తి వీజితిఙ్‌ లోకుర్‌ విజెరె వన్ని బోదదిఙ్‌ బమ్మ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ఎందనిఙ్‌ ఇహిఙ వాండ్రు, యూదురి రూలుఙ్‌ నెస్పిస్ని వరి లెకెండ్‌ ఆఎండ, అతికారం మనివన్ని లెకెండ్‌నె వాండ్రు బోదిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","యేసు అయ గొరొన్‌డిఃగ్‌జి వాతివలె మంద లోకుర్‌ వన్ని వెనుక వాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","కుస్టు రోగం మనికాన్‌ ఒరెన్‌ వాతండ్రె వన్ని ముందాల ముణుకుఙ్‌ ఊర్‌జి, “ప్రబువా, నాను నెగెణ్‌ ఆదెఙ్‌ ఇజి నిఙి మన్సు మహిఙ, నఙి నెగెణ్‌ కిదెఙ్‌ అట్ని”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","అందెఙె వాండ్రు కియు సాప్సి వన్నిఙ్‌ముట్తాండ్రె, “నఙి మన్సు మనాద్, నీను నెగెణ్‌ ఆఅ”, ఇజి వెహ్తాన్‌. వెటనె వన్నిఙ్‌మహి పెరి జబు డిఃస్త సొహద్. ");
INSERT INTO kfc_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","నస్తివలె యేసు వన్నివెట, “యాక ఎయెరిఙ్‌బా ఇనికబా వెహ్‌మ. నీను తీనాఙ్‌ సొన్సి నీ ఒడొఃల్‌ పుజేరిఙ తోరిస్‌అ. నీను నెగెణ్‌ ఆతి దనిఙ్‌ వరిఙ్‌ రుజుప్‌ లెకెండ్‌ మోసె ముఙలె ఆడ్ర సితి వజ దేవుణుదిఙ్‌ సంత సిఅ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","యేసు కపెర్నహము ఇని పట్నమ్‌దు వాతివెలె సదాతిపతి ఒరెన్‌ వన్ని డగ్రు వాతండ్రె, “ప్రబువా, నా పణిమన్సి ఒరెన్‌ కికు కాల్కు సాని జబుదాన్‌ నండొ బాద ఆజి నా ఇండ్రొ గూర్త మనాన్”, ఇజి వెహ్సి బతిమాలితాన్. ");
INSERT INTO kfc_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","“నాను సొన్సి వన్నిఙ్‌ నెగెణ్‌కిన”, ఇజి యేసు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","నస్తివలె అయ సయ్‌నమ్‌ది అతికారి ఈహు వెహ్తాన్‌, “ప్రబువా, నీను నా ఇండ్రొ వాదెఙ్‌ నాను తగ్నిక ఆఎ. గాని నీను ఉండ్రి మాట వెహ్తిఙ ఆనాద్, నా పణిమన్సి నెగెణ్‌ ఆనాన్. ");
INSERT INTO kfc_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","నీను అయాలెకెండ్‌ కిదెఙ్‌ అట్నిఇజి నాను నెసిన. ఎందనిఙ్‌ ఇహిఙ నా ముస్కు అతికారం మన్నికార్‌ మనార్‌. నా అడిగి సయ్‌నమ్‌దికార్‌ మనార్‌. నాను ఒరెన్‌ వన్నిఙ్‌ ‘సొన్‌అ’ ఇహిఙ సొనాన్. మరి ఒరెన్‌ వన్నిఙ్‌ ‘రఅ’ ఇహిఙ వానాన్. నాను నా పణి మనిసిదిఙ్ ‘అయ పణి కిఅ’ ఇహిఙ వాండ్రు ఆక కినాన్.” ");
INSERT INTO kfc_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","యేసు యా మాట వెంజి బమ్మ ఆతాండ్రె వన్ని వెనుక వానివరిఙ్‌ సుడ్ఃజి, “విన్నిఙ్‌ మన్ని లెకెండ్‌ దేవుణు ముస్కు నిసొ పెరి నమకం మని ఎయెరిఙ్‌బా ఇస్రాయేలు లోకుర్‌ నడిఃమి, నాను సుడ్ఃదెఙ్‌ సిల్లె ఇజి నాను మిఙి నిజం వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","నాను మిఙి వెహ్నిక ఇనిక ఇహిఙ, దేవుణు కిని ఏలుబడిః వానివలె, తూర్‌పుదాన్‌ పడఃమరదాన్‌ నండొ లోకుర్‌ వాజి అనిగొగొర్‌ ఆతి అబ్రాహము, ఇస్సాకు, యాకోబు ఇని వరివెట పరలోకామ్‌దు విందుదు బస్నార్. ");
INSERT INTO kfc_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","గాని దేవుణు కిని ఏలుబడిఃదు తప్‌ఎండ మంజినాప్‌లె ఇజి ఒడ్ఃబిజిని వరిఙ్‌ వెల్లి సీకటిదు విసీర్‌నాన్. అబె లోకుర్‌ అడఃబాజి పల్కు కొహ్‌క్ని మంజినార్.” ");
INSERT INTO kfc_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","యేసు అయా సదాతిపతిఙ్‌, “సొన్‌అ, నీను నమ్మితి వజనె జర్గినాద్”, ఇజి వెహ్తాన్‌. అయ గడిఃయాదునె వన్ని పణిమనిసి నెగెండ్‌ ఆతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","వెనుక యేసు పేతురు ఇండ్రొ వాతాన్. వన్ని మీమ్‌సి నోబుదాన్‌ గూర్తిమనిక సుడ్ఃతాన్‍. ");
INSERT INTO kfc_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","వాండ్రు దని కియుదు ముట్తిఙ్‌ సరి దనిఙ్‌మహి నోబు డిఃస్త సొహద్. అది నిఙితాదె వన్నిఙ్‌ నెగెండ్‌ సుడ్ఃదెఙ్‌ మొదోల్‌స్తాద్. ");
INSERT INTO kfc_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","పొదు ఆతివలె, దెయమ్‌కు అస్తి వరిఙ్‌ నండొండారిఙ్, లోకుర్‌ వన్ని డగ్రు తతార్. వాండ్రు ఉండ్రి మాటదానె దెయమ్‌కాఙ్‌ పెర్తాన్, మరి జబుది వరిఙ్‌ విజేరిఙ్‌ నెగెణ్‌ కితాన్. ");
INSERT INTO kfc_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","“వాండ్రు మా నీర్‌సమ్‌కు లాగితాన్‌, మరి మా జబుఙ్‌ వాండ్రు పిండితాన్” ఇజి యెసయ ప్రవక్త వెట దేవుణు ముఙాల వర్గితి మాటెఙ్‌ పూర్తి ఆదెఙ్‌ యాక జర్గితాద్. ");
INSERT INTO kfc_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","యేసు వన్ని డగ్రు మని మంద లోకురిఙ్‌ సుడ్ఃజి సమ్‌దరం అతాహ పడక సొండ్రెఙ్‌ ఇజి వన్ని సిసూరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","నస్తివలె, యూదురి రూలుఙ్‌ నెస్పిస్నికాన్‌ ఒరెన్‌ వన్ని డగ్రు వాతండ్రె, “బోద కనికి, నీను ఎంబె సొహిఙ్‌బా నీ వెట నానుబా వాన”, ఇజి వన్నిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","నస్తివలె యేసు, “నకెఙ బొరోఙ్‌ మనె, ఆగాసమ్‌దు ఎగ్రిజిని పొటిఙ గూడుకు మనె, గాని లోకు మరిసి ఆతి నఙి బుర్ర డుట్సి మండ్రెఙ్‌బా బాడిః సిల్లెద్‌”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","సిసూర్‌ లొఇ ఒరెన్‌ వాతండ్రె, “ప్రబువా నాను ముందాల సొన్సి నా బుబ్బ సాతి పిన్‌గు పెర్‌జి పొక్సి వాన”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","నస్తివలె యేసు, “సాతికారె వరి సాతి వరిఙ్‌ పెర్‌జి పోక్సిర్‌, నీను నావెట రఅ”, ఇజి వన్నిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","యేసుని వన్ని సిసూర్‌ డోణి ఎక్తారె అబ్బెణిఙ్‌ సోత సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","వారు సొన్సి మహిఙ్‌ యేసు డోణిదు నిద్ర కిజి మహాన్‌. వెటనె అయ సమ్‌దరమ్‌దు గాలితూపాన్‌ రేఙితాద్. ఉల్కెఙ్‌వాజి అయ డోణి ముస్కు అర్తె. ");
INSERT INTO kfc_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","సిసూరు సొన్సి వన్నిఙ్‌ నిక్తారె, “ప్రబువా, సాన సొనాప్లె, మఙి రక్సిస్‌అ”, ఇజి వన్నిఙ్‌నిక్తార్. ");
INSERT INTO kfc_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","అయావలె యేసు వరిఙ్, “ఎందనిఙ్‌ మీరు నిసొ తకు నమకం మనికిదెర్‌ ఆజినిదెర్‌?”, ఇజి వెహ్తండ్రె నిఙ్‌జి గాలిదిఙ్‌ ఉల్కెఙ అలెజి మన్‌అ ఇహాన్‌. ఆకెఙ్‌ పూర్తి పలక్‌ ఆతె. ");
INSERT INTO kfc_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","వారు బమ్మ ఆతారె, “వీండ్రు ఎలాగ మర్తికాండ్రొ? గాలిని ఉల్కెఙ్‌బా వన్నిఙ్‌ లొఙిజిన”, ఇజి వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","యేసు సమ్‌దరం అతహి పడక మని గదరెను ఇని నారు అందితిఙ్, దెయం అస్తికార్‌ రిఎర్, యూదురు వరి సాతివరిఙ్‌ సమాది కిని సాలమ్‌కాణిఙ్‌ సోతారె వన్ని ఎద్రు వాతార్. వారు జంతు నని మూర్‌కతం మనికార్‌కక ఎయెర్‌బా అయ సరి సొన్‌ఏర్. ");
INSERT INTO kfc_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","“ఓ దేవుణు మరిసి, మా వెట మిఙి ఇని పణి? కాలం వాని ముఙాల మఙి బాద కిదెఙ్‌ ఇబ్బె వాతిదా?”, ఇజి డేడిఃస్తార్. ");
INSERT INTO kfc_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","వరి ఎద్రు కండెక్‌ దూరమ్‌దు పండ్రిఙ్‌ మంద మెయ్‌జి మహె. ");
INSERT INTO kfc_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","అయ దెయమ్‌కు వన్నిఙ్‌ “నీను మఙి ఉల్పిని లెకెండ్‌ ఇహిఙ, అయ పండ్రిఙ లొఇ మఙి పోక్‌అ”, ఇజి బతిమాల్‌తె. ");
INSERT INTO kfc_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","వాండ్రు వన్కాఙ్‌ “సొండ్రు” ఇజి వెహ్తిఙ్‌అయ దయమ్‌కు వరిఙ్‌ డిఃస్తెనె పండ్రిఙ లొఇ సొహె. అయ మంద పండ్రిఙ్‌ విజు గొరొన్‌ ముస్కుహాన్‌ ఉహ్‌క్సి సొహెనె సమ్‌దరమ్‌దు అర్తె సాతె. ");
INSERT INTO kfc_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","పండ్రిఙ్‌ మేప్నికార్‌ ఉహ్‌క్సి సొన్సి పట్నమ్‌దివరిఙ్‌ జర్గితికెఙ్‌ విజు వెహ్తార్‌. దెయం అస్తి మహివరిఙ్‌ జర్గితికబా వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","నస్తివలె అయ పట్నమ్‌దికార్‌ విజేరె సోసి యేసుఙ్‌ సుడ్ఃదెఙ్‌ వన్ని ఎద్రు వాతార్. వన్నిఙ్‌ సుడ్ఃతిఙ్, వరి నారు డిఃసి సొన్‌అ ఇజి వన్నిఙ్‌ బతిమాల్‌తార్. ");
INSERT INTO kfc_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","యేసు డోణి ఎక్తాండ్రె సెరు డాట్సి కపెర్నహము ఇని వన్ని సొంత పట్నమ్‌దు వాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","అయావలె సెగొండార్‌ కికు కాల్కు అర్సి మంసమ్‌దు గూర్‌జిమహి ఒరెన్‌ వన్నిఙ్‌ యేసు డగ్రు తతార్. దేవుణు ముస్కు వరి నమకం యేసు సుడ్ఃతాండ్రె, “మరిన్, దయ్‌రమ్‌దాన్‌ మన్‌అ, నీ పాపమ్‌కు సెమిస్త మన”, ఇజి కికు కాల్కు అర్తి వన్నిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","యూదురి రూలుఙ్‌ నెస్పిస్నికార్‌ సెగొండార్‌ “వీండ్రు దేవుణుదిఙ్‌ దూసిస్నాన్”, ఇజి వరి లొఇ వారె వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","యేసు వరి మన్సుదు మనికెఙ్‌ నెస్తాండ్రె ఈహు వెహ్తాన్‌ “మీరు ఎందనిఙ్‌ మీ మన్సుదు సెఇకెఙ్‌ ఒడ్ఃజినిదెర్‌?”. ");
INSERT INTO kfc_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","“నీ పాపమ్‌కు సెమిస్తమన ఇజి వెహ్‌నిక సులునా? నీను నిఙ్‌జి నడిఅ ఇజి వెహ్‌సినిక సులునా?”. ");
INSERT INTO kfc_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","“లోకు మరిసి ఆతి నఙి బూమి ముస్కు పాపమ్‌కు సెమిస్తెఙ్‌ అతికారం మనాద్‌ ఇజి మీరు నెస్తెఙ్‌ వెలె.” వెనుక కికు కాల్కు అర్తివన్ని వెట, “నిఙ్‌అ నీ మన్‌సం అసి ఇండ్రొ సొన్‌అ”, ఇజి యేసు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","వాండ్రు నిఙితండ్రె ఇండ్రొ సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","లోకుర్‌ విజేరె అక సుడ్ఃజి బమ్మ ఆతార్. లోకురిఙ్‌ యా లెకెండ్‌ అతికారం సితి దేవుణుదిఙ్‌ పొగిడిఃతార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","యేసు అబెణిఙ్‌ సొన్సి మహిఙ్, పన్ను పెర్‌నికాన్‌మత్తయి ఇనికాన్‌వన్ని బాడిఃదు బస్త మహాన్‌. యేసు వన్నిఙ్‌ సుడ్ఃజి, “నా వెట రఅ”, ఇజి వెహ్తిఙ్, వాండ్రు నిఙితాండ్ర యేసు వెట సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","వెనుక యేసు మత్తాయి ఇండ్రొ బోజనం కిదెఙ్‌ బస్తి మహిఙ్, నండొండార్‌ పన్ను పెర్నికార్‌ని పాపం కినికార్‌ ఇజి పరిసయెరు వహ్నికార్‌ వాతారె వన్ని వెటని వన్ని సిసూర్‌ వెట బోజనమ్‌దిఙ్‌ బస్తార్. ");
INSERT INTO kfc_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","పరిసయ్‌రు అక సుడ్ఃజి, “ఎందనిఙ్‌ మిఙి నేర్‌పిస్నికాన్‌ పన్ను పెర్‌నివరి వెట, పాపం కినివరి వెట బోజనం కిజినాన్”, ఇజి వన్ని సిసూర్‌ఙ వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","యేసు అయ మాట విహండ్రె, “జబు మనివరిఙె డాక్టర్‌ అవ్‌సరం, నెగెణ్‌ మని వరిఙ్‌ డాక్టర్‌ అవ్‌సరం సిల్లెద్‌”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","“మీరు మహి వరి ముస్కు కనికారం తోరిస్తెఙ్‌ ఇజినె నాను కోరిజిన గాని కత్ని‌ పూజెఙ నాను కోరిఏ, ఇజి దేవుణు వెహ్తి మాటది అర్దం ఇనికాదొ ఇజి మీరు సొన్సి నెస్తు. పాపం కిని వరిఙ్‌ కూక్‌క్తెఙె నాను వాత మన, నెగెణ్‌ మనికాప్‌ ఇజి ఒడ్ఃబిని వరిఙ్‌ ఆఎద్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","నస్తివలె యోహను సిసూరు వన్ని డగ్రు వాజి, “మాపుని పరిసయ్‌రు డిఃస్‌ఏండ ఉపాస్‌ మంజినాప్, గాని నీ సిసూర్‌ ఎందనిఙ్‌ ఉపాస్‌ మన్‌ఏర్‌?”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","దనిఙ్‌యేసు ఈహు వెహ్తాన్‌, “పెండ్లి దఙడాఃయెన్, పెండ్లి కూలెఙ వెట మని వెలె వారు దుకమ్‌దాన్‌ మంజినారా? పెండ్లి దఙడాఃయెన్‌ వరిబాణిఙ్‌ కూకె ఆతి వెనుక వారు ఉపాస్‌ మంజినార్.” ");
INSERT INTO kfc_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“ఎయెర్‌బా పడాయ్‌పాతదు కొత పాత ముక కుడుఃప్సి గుత్‌ఏర్. ఆహె కితిఙ కొత పాత ముక కేట ఆజి కిజినిక మరి లావ్‌ఆనాద్. ");
INSERT INTO kfc_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ఎయెర్‌బా పడాఃయి తోలు సన్సిదు కొత ద్రాక్స కల్లు వాక్‌ఏర్. ఆహె కితిఙ కొత ద్రాక్స కల్లు పులాఙ్‌ ఆనివెలె తోలు సంసి పెడెల్‌నాద్, ద్రాక్స కల్లు వెల్లి సోనాద్. మరి సంసి పాడానాద్. కొత ద్రాక్స కల్లు కొత తోలు సన్సిదునె వాక్తెఙ్. అయావలె రుండిబా పాడ్ః ఆఉ.” ");
INSERT INTO kfc_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","యేసు యా మాటెఙ్‌ వరి వెట వెహ్సి మహివలె, యూదురి మిటిఙ్‌ కిని ఇండ్రొణి ఒరెన్‌ అతికారి వాతండ్రె వన్ని ఎద్రు ముణుకుఙ్‌ ఊర్‌జి, “నా గాలు యెలె సాతాద్. నీను వాజి నీ కియు దని ముస్కు ఇడ్ఃఅ. అది బత్కినాద్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","యేసు నిఙితండ్రె వన్ని వెట సొహాన్‌. వన్ని సిసూర్‌బా సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","నస్తివలె పనెండు పంటెఙాణిఙ్‌ వెల్లి ఆని జబుదాన్‌ బాద ఆజిమహి ఉండ్రి బోదెలి, “యేసు తొడిఃగితిమని నీరి సొక్కదు ముట్తిఙ సరి నాను నెగెండ్‌ ఆన”, ఇజి దని మన్సుదు ఒడ్ఃబితాదె వన్ని వెనుక వాతాదె వన్ని పాత సెంగుదు ముట్తాద్. ");
INSERT INTO kfc_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","యేసు వెనుక మర్‌జి దనిఙ్‌ సుడ్ఃజి, “ఓ బయి దయ్‌రమ్‌దాన్‌ మన్‌అ. నీను నా ముస్కు ఇట్తి మని నమకమ్‌నె నిఙి నెగెణ్‌ కిత మనాద్”, ఇజి వెహ్తాన్‌. అయావలెనె అయ బోదెలి నెగెండ్‌ ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","24","నస్తివలె యేసు అతికారి ఇండ్రొ వాతిఙ్, పిరుడిః ఊక్నివరిఙ్‌ గగోల్‌ ఆని వరిఙ్‌ సుడ్ఃజి, “ఇబ్బెణిఙ్‌ సొండ్రు, యా ఇజిరి బయి నిద్ర కిజినాద్‌ గాని సాఏద్”, ఇజి వెహ్తాన్‌. వారు వన్నిఙ్‌ వెక్రిసి సిక్తార్. ");
INSERT INTO kfc_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","అబె నిండ్రితి మహి లోకురిఙ్‌ విజేరిఙ్‌ వెల్లి పోక్తి వెనుక, యేసు ఇండ్రొ డుఃగితాండ్రె అయ్‌లి కీదు అస్తిఙ్‌అది నిఙితాద్. ");
INSERT INTO kfc_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","యా కబ్రురు అయ ప్రాంతం విజు సారితాద్. ");
INSERT INTO kfc_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","యేసు అబెణిఙ్‌ సొన్సి మహివలె రిఎర్‌గుడ్డిఃవారు వన్ని వెనుక వాతారె, “ఓ దావీదు మరిసి, మా ముస్కు కనికారం తోరిస్‌ఆ”, ఇజి డేల్సి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","యేసు ఇండ్రొ డుఃగితి వెనుక వారు వన్ని డగ్రు వాతార్. వాండ్రు వరిఙ్‌ ఈహు వెన్‌బాతాన్. “‘యాక కిదెఙ్‌ నాను అట్న’, ఇజి మీరు నమిజినిదెరా?”, “ప్రబువా మాప్‌ నమ్మిజినాప్”, ఇజి వారు వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","30","నస్తివలె యేసు వరి కణకెఙ ముట్సి ఈహు వెహ్తాన్‌. “మిరు నమ్మితివజనె యాక మిఙి జర్గిపిద్”, ఇజి వెహ్తి వెటనె వరి కణుకు బేస్తార్. “ఎయెర్‌బా యాక నెస్తెఙ్‌ఆఎద్‌”, ఇజి యేసు వరిఙ్‌ గట్టిఙ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","గాని వారు సొహరె అయ ప్రాంతం విజు వన్ని వందిఙ్‌ సాట్తార్. ");
INSERT INTO kfc_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","యేసుని వన్ని సిసూర్‌అబెణిఙ్‌సొన్సి మహిఙ్‌ దెయం అస్తి ఒరెన్‌ గులవన్నిఙ్‌ వన్ని డగ్రుతతార్. ");
INSERT INTO kfc_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","యేసు దెయమ్‌దిఙ్‌ఉల్‌ప్తి వెటనె అయ గుల్ల వాండ్రు వర్‌గిదెఙ్‌ మొదోల్‌స్తాన్. అక సుడ్ఃజి లోకుర్‌ విజేరె బమ్మ ఆతారె, “ఎసెఙ్‌బా ఇస్రాయేలు దేసమ్‌దు యా లెకెండ్‌ ఇనికబా జర్‌గిఏతాద్”, ఇజి వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","గాని పరిసయ్‌రు ఈహు వెహ్తార్‌, “దెయమ్‌కాఙ్‌ నెయ్కి సాయమ్‌దానె వీండ్రు దెయమ్‌కాఙ్‌ పేర్‌జినాన్”. ");
INSERT INTO kfc_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","యేసు విజు పట్నమ్‌కాఙ్, విజు నాహ్కఙ్‌ బూలాజి యూదురు మీటిఙ్‌ కిని ఇల్కాఙ్‌ వరిఙ్‌ నేర్‌పిసి, దేవుణు ఏలుబడిః కిని వందిఙ్‌ సువార్త వెహ్సి విజు రకమ్‌ది జబుది వరిఙ్, బాదదాన్‌ మని వరిఙ్‌ నెగెండ్‌ కితాన్. ");
INSERT INTO kfc_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","యేసు మంద లోకాఙ్‌ సుడ్ఃజి, వన్ని పాణం నొతాద్. ఎందనిఙ్‌ ఇహిఙ వారు గవుడుఎన్‌ సిల్లెండ సద్రితి గొర్రెఙ్‌ లెకెండ్, ఇనిక కిదెఙ్‌ ఇజి నెస్‌ఇ వరి లెకెండ్‌ మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","38","నస్తివలె యేసు వన్నిసిసురిఙ్‌, “కొయ్‌దెఙ్‌ మన్ని పంటలెకెండ్‌ లోకుర్‌ నండొండార్‌ మన్నె. గాని కొయ్‌నికార్‌ తకునె. అందెఙె వన్ని పంట కొయ్‌ని వందిఙ్‌ పణికిని వరిఙ్‌ పోక్‌అ ఇజి కోత యజుమానిఙ్‌ బతిమాల్‌దు”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","యేసు వన్ని పనెండు మన్సి సిసూర్‌ఙ డగ్రు కూక్తాండ్రె దెయమ్‌కాఙ్‌ పేర్‌దెఙ్, మరి విజు రకమ్‌ది జబుది వరిఙ్‌ని బాదదాన్‌ మని వరిఙ్‌ నెగెండ్‌ కిదెఙ్‌ వరిఙ్‌ అతికారం సితాన్. ");
INSERT INTO kfc_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","అయ పనెండు మన్సి అపొస్తుడురి పేరుకు ఇకెఙ్. మొదోహికాన్‌సీమోను, (పేతురు ఇజి వాండ్రు కూకె ఆతాన్‌) వన్ని తంబెర్‌సి ఆతి అంద్రెయ, జెబదయి పొటాదికార్‌యాకోబుని యోహను, ");
INSERT INTO kfc_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","పిలిపుని బర్తొలొమాయి, తోమని పన్ను పెర్జి మహికాన్‌ మతాయి, అలపయి పొటాదికాన్‌ యాకోబు, తదాయి ");
INSERT INTO kfc_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","యూదయ దేసం వందిఙ్‌ ఉసారాఆజిని‌ సీమోను, యెసుఙ్‌ మోసెం కిజి ఒపజెప్నికాన్‌ ఆతి ఇస్కరియోతు యూద. ");
INSERT INTO kfc_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","యేసు అయ పనెండు మన్సి సిసూరిఙ్‌పోక్నివలె ఈహు వెహ్తాన్‌. “యూదురు ఆఇవరి నడిఃమి మీరు సొన్మాట్. సమరియదివరి పట్నమ్‌కాఙ్‌బా సొన్మాట్. ");
INSERT INTO kfc_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","గాని మీరు ఇస్రాయేలుది మురుతి గొర్రెఙ్లెకెండ్‌ మనివరి నడిఃమి సొండ్రు. ");
INSERT INTO kfc_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","మీరు సొన్సి, ‘దేవుణు ఏలుబడిః కినిక డగ్రు ఆత మనాద్‌’ ఇజి సాట్తు. ");
INSERT INTO kfc_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","జబుదివరిఙ్‌ నెగెండ్‌కిదు, సాతి వరిఙ్‌ నిక్తు, పెరి కస్టమ్‌ది వరిఙ్‌ నెగెణ్‌కిదు, దెయమ్‌కాఙ్‌ పేర్దు. యా పణిఙ్‌ కిదెఙ్‌ అతికారం సెడ్డిఃనె మిఙి దొహ్‌క్త మనాద్. అందెఙె మీరు ఎయెర్‌బాణిఙ్‌బా ఇనికబా లొస్‌ఎండ ఇకెఙ్‌సెడిఃనె కిదు. ");
INSERT INTO kfc_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","మీరు సొనివెలె బఙారం, రుపాయ్‌ గాని వెండి, రుపాయ్‌ గాని రాగి రుపాయ్‌ గాని మీ సన్సిదు ఒమాట్. ");
INSERT INTO kfc_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","పయ్‌నం కినివెలె సన్సి ఒమాట్. రుండి సొక్కెఙ్, జోడ్కు, డుడు ఇనికబా ఒమాట్. ఎందనిఙ్‌ ఇహిఙ పణికినికాన్‌ వన్నిఙ్‌ కావాస్తికెఙ్‌ దొహ్‌క్తెఙ్‌ తగ్నికాన్. ");
INSERT INTO kfc_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","మీరు ఎమేణి పట్నమ్‌దు సొహిఙ్‌బా అబె ఒరెన్‌ నెగ్గివన్నిఙ్‌ రెబాజి వన్ని ఇండ్రొనె అబెణిఙ్‌ సొని దాక మండ్రు. ");
INSERT INTO kfc_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","మీరు అయ ఇండ్రొ డుఃగితిఙ సరి, ‘మిఙి సమాదనం మనిద్‌’ ఇజి వెహ్తు. ");
INSERT INTO kfc_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","అయ ఇండ్రొణికార్‌ మిఙి డగ్రు కిఇతిఙ, నస్తివెలె మీరు వెహ్నిలెకెండ్‌ వరిఙ్‌ దీవనమ్‌కు మంజినె. వారు తగిఇకార్‌ ఇహిఙ అయాలెకెండ్‌ వరిఙ్‌ జర్గిఏద్‌. ");
INSERT INTO kfc_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","మీరు ఉండ్రి పట్నమ్‌దు గాని, ఉండ్రి ఇండ్రొ గాని అందితిఙ, వారు మిఙి డగ్రు కిఏండ మరి మీ మాటెఙ్‌ డగ్రు కిఏండ మహిఙ, వరి ముస్కు వారె దేవుణు బాణిఙ్‌ సిక్స అప్పె ఆజినార్‌ ఇనిదన్నిఙ్‌ గుర్తు లెకెండ్‌, మీరు అయ పట్నమ్‌నో ఇల్లునో డిఃసి సొనివెలె మీ పాదమ్‌కాణి దుల్లి దూల్‌ప్సి సొండ్రు. ");
INSERT INTO kfc_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","దేవుణు తీర్పు తీరిస్ని రోజుదు అయ పట్నమ్‌దు మని వరిఙ్ ఒద్దె లావ్‌ సిక్స సీనాన్లె ఇజి నాను మిఙి నిజం వెహ్సిన. సోదోమ గొమోర పట్నమ్‌కాఙ్‌ మహివరిఙ్‌ సొన్సి సిక్స మన్‌ఏద్‌. ");
INSERT INTO kfc_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","కార్‌నుకుడిఃఙ నడిఃమి గొర్రెఙ్లెకెండ్‌ నాను మిఙి లోకుర్‌ నడిఃమి పోక్సిన. అందెఙె మీరు సరాస్కు లెకెండ్‌బుది మనికిదెర్, పావుర పొటిఙ లెకెండ్‌ సెఇకెఙ్‌ ఇనికెఙ్‌ సిలికిదెర్‌ ఆజి మండ్రు. ");
INSERT INTO kfc_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","లోకుర్‌ వందిఙ్‌ జాగర్త మండ్రు. వారు మిఙి కోర్టుదు ఒపజెప్సి, మరి యూదురు మీటిఙ్‌ కిని ఇల్కాఙ్‌ మిఙి కొర్డెఙణిఙ్‌ డెఃయ్సినార్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","రాజురిఙ ముందాల, అదికారిఙ ముందాల నా ముస్కు నమకం ఇట్తి వందిఙ్‌ మఙి అసి తొహ్సి ఒనార్లె. వరి ముందాలని యూదురు ఆఇ వరి ముందాల నా వందిఙ్‌ మీరు వరిఙ్‌ సువార్త వెహ్నిదెర్లె. ");
INSERT INTO kfc_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","గాని వారు మిఙి తొహ్సి ఒనివెలె ఇనిక వెహ్తెఙ్, అక ఎలాగ వెహ్తెఙ్‌ ఇజి మీరు బెఙ ఆమాట్. అయావలెనె వర్గిదెఙ్‌ సరి ఆతి మాటెఙ్‌ మిఙి దొహ్‌క్నెలె. ");
INSERT INTO kfc_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ఎందనిఙ్‌ ఇహిఙ అయావలె వర్‌గినిక మీరు ఆఇదెర్. మీ బుబ్బ ఆతి దేవుణు ఆత్మ మీ లొఇహాన్‌‌ వర్‌గినాన్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","దాద్సి తంబేరిఙ్, తంబెరి దాద్సిఙ్, అపోసి మరిసిఙ్‌ సప్తెఙ్‌ ఒపజెప్నార్‌లె. కొడొఃర్‌ అయ్‌సి అప్పొసిర్‌ ముస్కు గొడబ ఆజి వరిఙ్‌ సపిస్నార్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","నా ముస్కు నమకం ఇట్తి వందిఙ్‌ విజేరె మీ ముస్కు పగదాన్‌ మంజినార్‌లె. గాని ఆకార్‌ దాక ఓరీస్ని వన్నిఙ్‌ దేవుణు రక్సిస్నాన్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ఉండ్రి నాటొ మిఙి హిమ్‍స కితిఙ, మరి ఉండ్రి పట్నమ్‌దు ఉహ్‌క్సి సొండ్రు. లోకు మరిసి వాని ముందాల సువార్త సాటసిని పణి పూర్తి వీజ్‌ఎండ ఆనాద్, ఇజి నాను మిఙి నిజం వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","సద్వినికాన్‌ నెస్పిస్నివన్ని ముస్కు పెరికాన్‌ ఆఏన్. పణిమన్సి యెజుమాని ముస్కు పెరికాన్‌ అఏన్. ");
INSERT INTO kfc_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","సద్వినికాన్‌ నెస్పిస్నివన్ని లెకెండ్‌ ఆతిఙ ఆనాద్. పణిమన్సి యెజుమాని లెకెండ్‌ ఆతిఙ ఆనాద్. ఇండ్రొణి యెజుమానిఙ్‌ వారు బయిల్‌జెబులు ఇజి కూక్సి మోసెం వెహ్తార్‌ ఇహిఙ ఇండ్రొణికార్‌ ఆతి మీ వందిఙ్‌ మరి ఎసోనొ సెఇ మాటెఙ్‌ వెహ్నర్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","అందెఙె వరిఙ్‌ మీరు తియెల్‌ ఆమాట్. డాప్తి మనికెఙ్‌ విజు తోరె ఆనెలె. నెస్‌ఏండ మూస్తి మనికెఙ్‌ విజు నెసె ఆనెలె. ");
INSERT INTO kfc_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","మీ వెట నాను సీకటిదు వెహ్తి మాటెఙ్‌, మీరు జాయ్‌దు వెహ్తు. మీ గిబిఙ వెహ్తి మాటెఙ్‌ విజేరె వినిలెకెండ్‌ మిద్దెఙ ముస్కుహన్‌ మీరు డటం వెహ్తు. ");
INSERT INTO kfc_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ఆత్మదిఙ్‌ సప్తెఙ్‌ అట్‌ఏండ ఒడొఃల్‌దిఙ్‌నె సప్తెఙ్‌ అట్ని వరిఙ్‌ మీరు తియెల్‌ ఆమాట్. గాని ఆత్మని ఒడొఃల్‌దిఙ్‌ సిసు మంజిని బాడిఃదు పోక్సి నాసనం కిదెఙ్‌ అతికారం మని దేవుణుదిఙ్‌నె తియెల్‌ ఆజి మండ్రు. ");
INSERT INTO kfc_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ఉండ్రి కాసుదిఙ్‌ రుండి ఇజ్రి పంట పొటిఙ్‌పొరె ఆజినెగదె. అహిఙ్‌బా నీ బుబ్బాతి దేవుణు నెస్‌ఏండ దన్ని లొఇ ఉండ్రిబా అడ్గి బూమిదు సాదెఙ్‌ ఇజి డిఃసి సీఏన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","నీ బుర్రది కొపు విజుబా లెక కిబె ఆత మనాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","అందెఙె మీరు తియెల్‌ ఆమాట్. మీరు యా ఇజిరి పంట పొటిఙ మిస్తి విలువ మనికిదెర్. ");
INSERT INTO kfc_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","లోకుర్‌ ముందాల నఙి ఒపుకొణి, విజెరిఙ్‌ నానుబా వరివందిఙ్‌ పరలోకామ్‌దు మని నా బుబాతి దేవుణు ఎద్రు ఒపు కొణా. ");
INSERT INTO kfc_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","గాని ఎయెన్‌బా లోకుర్‌ముందాల నఙి నెస్‌ఎ ఇజి వెహ్తిఙ, పరలోకామ్‌దు మని నా బుబ్బాతి దేవుణు ముందాల నానుబా వన్నిఙ్‌ నెస్‌ఎ ఇజి వెహ్నలె. ");
INSERT INTO kfc_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","బూమి ముస్కు సమాదనం తపిస్తెఙ్‌ నాను వాత మన ఇజి మీరు ఒడ్ఃబిమాట్. పగ తపిస్తెఙ్‌నె వాత, సమాదనం ఆఎద్‌. ");
INSERT INTO kfc_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ఎందనిఙ్‌ ఇహిఙ, మరిసిఙ్‌ వన్ని అప్పొసి ముస్కు, గాడ్సిఙ్‌ దని అయ్‌సి ముస్కు, కొడిఃయెసిఙ్‌ దని మీమ్‌సి ముస్కు పగ కిబిస్తెఙ్‌నె నాను వాత మన. ");
INSERT INTO kfc_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","నా ముస్కు నమకం ఇట్తి వందిఙ్‌ ఒరెన్‌ వన్ని ముస్కు వన్ని సొంత ఇండ్రొణికారె పగాతికార్‌ ఆనార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","బుబెఙ్‌బా యాయెఙ్‌బా నఙి మిస్తి ప్రేమిస్నికాన్‌ నఙి తగ్నికాన్‌ ఆఏన్. మరిసిఙ్‌బా గాల్సిఙ్‌బా నఙి మిస్తి ప్రెమిస్నికాన్‌ నఙి తగ్నికాన్‌ ఆఎన్. ");
INSERT INTO kfc_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","కస్టమ్‌కు ఓరిస్తెఙ్‌ మన్సు సిల్లికాన్‌, మరి నా వెట సాదెఙ్‌ ఇజిబా మన్సు సిల్లికాన్‌, ఎయెన్‌బా నఙి తగ్నికాన్‌ ఆఏన్. ");
INSERT INTO kfc_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","వన్ని పాణమ్‌దిఙ్‌ కాపాడ్ఃదెఙ్‌ ఇజి సుడిఃతిఙ వాండ్రు దన్నిఙ్‌ సొన్‌పిస్నాన్. నా వందిఙ్‌ వన్ని పాణం సొన్పిస్నికాన్‌ దనిఙ్‌ కాపాడ్నాన్. ");
INSERT INTO kfc_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","నిఙి డగ్రు కినికాన్‌ నఙినె డగ్రు కిజినాన్. నఙి డగ్రు కినికాన్‌ నఙి పోక్తివన్నిఙ్‌బా డగ్రు కిజినాన్. ");
INSERT INTO kfc_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ఒరెన్‌ దేవుణు ప్రవక్తెఙ్, వాండ్రు దేవుణు ప్రవక్త ఇజి నెసి ఎయెన్‌బా వన్నిఙ్‌డగ్రు కితిఙ, దేవుణు ప్రవక్తెఙ్‌ దొహ్‌క్ని లెకెండ్‌ వన్నిఙ్‌బా పలం దొహ్‌క్నాద్‌లె. ఒరెన్‌ నీతి నిజాయితి మని వన్నిఙ్‌ వాండ్రు నీతి నిజాయితిదికాన్‌ ఇజి నెసి ఎయెన్‌బా వన్నిఙ్‌ డగ్రు కితిఙ, నీతి నిజాయ్తిమని వన్నిఙ్‌ దొహ్‌క్ని లెకెండ్‌ వన్నిఙ్‌బా పలం దొహ్‌క్నాద్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","యా నా సిసూర్‌ లోఇ ఇజిరి ఒరెన్‌ వన్నిఙ్‌ వాండ్రు నా సిసూర్‌ ఇజి నెసి ఎయెర్‌బా ఉండ్రి గలస్‌ ఏరు సితిఙ, దనిఙ్‌ తగితి పలం తప్‌ఏండ వన్నిఙ్‌ దొహ్‌క్నాద్‌ ఇజి నాను మిఙి నిజం వెహ్సిన.” ");
INSERT INTO kfc_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","యేసు వన్ని పనెండు మన్సి సిసూర్‌ఙ ‌బోదిసి వీజితి వెనుక, అబెణిఙ్‌ సోసి గలిలయ దేసమ్‌దు మని పట్నమ్‌కాఙ్, నాహ్కఙ్‌ సువార్త సాట్తెఙ్, బోదిస్తెఙ్‌ సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","జెలిదు మని యోహను క్రీస్తు కిని పణిఙ వందిఙ్‌ వెంజి, “వానికి నీనెనా? సిలిఙ మరి ఒరెన్‌ వన్నిఙ్‌ మాపు ఎద్రు సుడ్ఃజి మండ్రెఙ్‌నా?”, ఇజి వెన్‌బాదెఙ్‌ వన్ని సిసూర్‌ఙ యేసు డగ్రు పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","5","యేసు వరిఙ్‌ ఈహు వెహ్తాన్, “గుడ్డిదికార్‌ సుడ్ఃజినార్, సొటాదికార్‌ నడిఃజినార్, పెరి జబు మనికార్‌ నెగెణ్‌ ఆజినార్, బొయ్‌రాదికార్‌ వెంజినార్, సాతికర్‌ నిఙె ఆజినార్, బీదాతి వరిఙ్‌ సువార్త వెహె ఆజినాద్, ఇజి యా లెకెండ్, మీరు సుడ్ఃజినికెఙ్, వెంజినికెఙ్‌ మర్‌జి సొన్సి, యోహనుఙ్‌ వెహ్తు. ");
INSERT INTO kfc_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","గాని నా ముస్కు మన్ని నమకం డిఃసి సెఇకాన్ దేవుణు సీని దీవెనమ్‌కు మంజినికాన్‌ ఆనాన్‌లె.” ");
INSERT INTO kfc_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","యోహను సిసూర్‌ మర్‌జి సొన్సిమహిఙ్‌ యేసు యోహను వందిఙ్‌ ఈహు వర్‌గిదెఙ్‌ మొదోల్‌స్తాన్. “ఇనిక సుడ్ఃదెఙ్‌ మీరు బిడిఃమ్‌ బూమి ప్రాతమ్‌దు సొహిమహిదెర్‌? గాలిదిఙ్‌ దూఙ్‌జిని గడిదిఙ్‌ పోలితి ఒరెన్‌ వన్నిఙ్‌ సుడ్ఃదెఙ్‌నా? ");
INSERT INTO kfc_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","సిల్లిఙ మరి ఇనిక సుడ్ఃదెఙ్‌ మీరు సొహి మహిదెర్‌? నెగ్గి సొక్కెఙ్‌ తొడ్ఃగితి మని ఒరెన్‌ వన్నిఙ్‌ సుడ్ఃదెఙ్‌నా? నూనాఙ్‌ మని నెగ్గి సొక్కెఙ్‌ తొడుఃగితి మంజినికార్‌ రాజురి ఇల్కాఙ్‌ మంజినార్‌ గదె? ");
INSERT INTO kfc_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","సిల్లిఙ మరి ఇనిక సుడ్ఃదెఙ్‌ మీరు సొహిమహిదెర్‌? ఒరెన్‌ దేవుణు ప్రవక్తెఙ్‌ సుడ్ఃదెఙ్‌నా? నిజమె, దేవుణు ప్రవక్తెఙ్‌ ఇంక పెరివన్నిఙ్‌నె ఇజి నాను మిఙి వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","‘నాను నా కాబ్రు తనివన్నిఙ్‌ నిఙి ఇంక ముఙాల పోక్న. వాండ్రు నీ ముఙాల నీ సరి నెగెండ్‌ కినాన్’ ఇజి వన్ని వందిఙె దేవుణు మాటదు రాస్త మనాద్. ");
INSERT INTO kfc_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","బోదెక పొటాదు పుట్తివరి లొఇ యోహను ఇంక మిస్తికాన్‌ ఎయెన్‌బా సిలెన్. గాని దేవుణు ఏలుబడిః కినిదని లొఇ ఇజిరికాన్‌ ఆతికాన్, యోహనుఙ్‌ ఇంక పెరికాన్‌ ఇజి నాను మిఙి నిజం వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","బాప్టిసం సీని యోహను కాలమ్‌దాన్‌ ఏలుదాక దేవుణు ఏలుబడిః కినిక బలవందమ్‌దాన్‌ ముఙాల వాజినాద్. మరి గొప్ప సత్తు మనికార్‌ దనిఙ్‌ అడ్డు కిదెఙ్‌ సుడ్ఃజినార్. ");
INSERT INTO kfc_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","మోసె సితి రూలుఙ్‌ని దేవుణు ప్రవక్తరు విజెరెబా దేవుణు ఏలుబడిః కినివందిఙె యోహను కాలమ్‌దాక వర్గిజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","నమిదెఙ్‌ మిఙి ఇస్టం మహిఙ, ఏలియ వానాన్లె ఇజి ముఙాల వెహ్తిక విని వందిఙ్‌నె. ");
INSERT INTO kfc_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","మి గిబ్బిఙ్‌ఙాణిఙ్‌ నెగెండ్‌ వెంజి అయా వజ నడిఃజి మండ్రు. ");
INSERT INTO kfc_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","‘యా తరమ్‌ది వరిఙ్‌ ఇనిదనిఙ్‌ సమానం వెహ్తెఙ్‌? వారు సతాదు బసి, మహివరిఙ్‌ డేల్సిని కొడొఃర్‌ లెకెండె మనార్.’ ‘మాపు మీ వందిఙ్‌ పిరుడిః ఉహ్‌క్తప్‌ గాని డాట్‌ఇతిదెర్‌, సాతి ఇండ్రొ పాటెఙ్‌ పార్తాప్‌ గాని మీరు గుండె కొతె ఆజి మీరు అడఃబ ఇతిదెర్’. ");
INSERT INTO kfc_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","యోహను వాతివెలె వాండ్రు తిండి వందిఙ్‌ లావ్‌ ఒడ్ఃబిఏండ రోజు ఉపాస్‌ కిజి మహన్‌. వాండ్రు అయాలెకెండ్‌ తిన్‌ఎండ, ఉణెఎండ మన్నిఙ్‌ వన్నిఙ్‌ దెయం అస్తాద్‌ ఇజి వారు వెహ్సినార్. ");
INSERT INTO kfc_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","లోకు మరిసి ఆతి నాను తింజి, ఉణిజి వాతాన్‌కాక ‘వీండ్రు తిండి కకూర్తికాన్‌’ మరి ఉణిజి సోస్నికాన్, పన్ను పెర్నివరిఙ్‌ని పాపం కిజిని వరిఙ్‌ కూలాయెన్‌ ఇజి వారు వెహ్సినార్. గాని దేవుణు బాణిఙ్‌ వాని గెణం మన్నికార్‌ వారు కిజిని నెగ్గి పణిఙాణిఙ్‌ అయ గెణం సరియాతిక ఇజి రుజుప్‌ కిజినాద్.” ");
INSERT INTO kfc_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","మరి యేసు ఎమేణి పట్నమ్‌కాఙ్‌ నండో బమ్మ ఆతి పణిఙ్‌ కితిఙ్‌బా వారు వరి మన్సు మారిస్‌ఎతారొ, అయ పట్నమ్‌కాఙ్‌ ముస్కు కోపం అజి వర్గితాన్. ");
INSERT INTO kfc_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","అబయా! కోరజీన పట్నమ్‌దు మనికిదెరా మిఙి అస్సొ గొప్ప కస్టమ్‌కు, వానెనొ, అబయా! బెత్‌సెయ్దపట్నమ్‌దు మన్నికిదెరా మిఙిబా ఎస్సొ గొప్ప కస్టమ్‌కు వానెనొ. ఎందనిఙ్‌ ఇహిఙ నాను మీ నడిఃమి కితి మహి బమ్మాతి పణిఙ్‌ తూరుని సీదోను పట్నమ్‌కాఙ్‌ కిని మంజినిక ఇహిఙ వారు ఎస్సొ ముఙాలె బస్త సొక్కెఙ్‌ తొడిఃగిజి ఒడొఃదు నీరు రాసె ఆజి ఉపాస్‌ కిజి వరి పాపమ్‌కు ఒపుకొడ్ఃజి డిఃసి సీజి మన్సు మారిసి అయాలెకెండ్‌ మినికార్‌ ఇజి తొరొస్తార్‌ మరి. ");
INSERT INTO kfc_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","అందెఙె నాను నిఙి వెహ్నిక ఇనిక ఇహిఙ తీర్పు తీరిస్ని రోజుదు తూరుని సీదోను పట్నమ్‌దివరిఙ్‌ మిస్తి సిక్స మిఙి వానాద్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ఓ కపెర్నహమా, “ఆగాసమ్‌దు మనికిదెరా, మిరు ఆగాసమ్‌దాక అందిజిని గొప్ప వారు ఇజి మీరు ఒడ్ఃబిజినిదెరా? గాని దేవుణు అయా లోకమ్‌దు విసీర్‌న్లె. మీ నడిఃమి కితి మహి బమ్మాతి పణిఙ్‌ నాణు సొదోము పట్నమ్‌దు కిని మంజినిక ఇహిఙ అయ సొదొము పట్నమ్‌దికార్‌ వరి అలవాటుఙ్‌ డిఃసి సీజి అయ పట్నమ్‌దిఙ్‌ దేవుణు సిక్స సిఏండ ఏలుదాక మహాద్‌ మరి. ");
INSERT INTO kfc_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","అందెఙె నాను నిఙి వెహ్సిన తీర్పు తీరిస్ని రోజుదు సొదోము పట్నమ్‌దు మహివరిఙ్‌ వాని దన్నిఙ్‌ మిస్తి సిక్స మీ లోకురి ముస్కు వానాద్‌లె.” ");
INSERT INTO kfc_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","వెనుక యేసు ఈహు వెహ్తాన్‌, “పరలోకామ్‌దిఙ్‌ని బూమిదిఙ్‌ ప్రబువాతి నా బుబ్బా, నాను నిఙి పొగ్‌డిఃజిన. ఎందనిఙ్‌ ఇహిఙ గెణం మన్ని వరిఙ్‌ని సదువు మన్ని వరిఙ్‌ యా సఙతిఙ్‌ తెలియ కిఏండ యా సదువు సిల్లి వరిఙ్‌ తెలియ కిత్తి. ");
INSERT INTO kfc_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","నిజమె బుబ్బ, ఈహు కినికాదె నిఙి ఇస్టం ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","బుబ్బ విజు సఙతిఙ్‌ నా కీదు ఒపజెప్త మనాన్. బుబ్బ ఆఏండ మరి ఎయెర్‌బా మరిసిఙ్‌ నెస్‌ఏర్. మరిసిని, మరిసి వన్నిఙ్‌ తెలివి కిదెఙ్‌ ఎర్లితికారె బుబ్బెఙ్‌ నెస్నార్. మరి ఎయెర్‌బా నెస్‌ఏర్‌. ");
INSERT INTO kfc_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","కస్టబాడ్ఃజి బరు పిండ్‌జి వందితి‌ విజిదెరె, మీరు నా డగ్రు రదు. నాను మిఙి రొంబిస్న. ");
INSERT INTO kfc_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","నాను సార్లిదికాన్. నాను మెతని మన్సు మనికాన్. నా వెట కూడ్ఃజి ఉండ్రె పూందు మీ మెడః ముస్కు పోకె అజి మాటు కూడ్ఃజి పణికినాట్‌, మీరు నా అడ్రెఙ్‌ లొఙిజి నా బాణిఙ్‌ నెస్తు. నస్తివలె మీ పాణమ్‌కాఙ్‌ నిమాలం కలగినాద్. ");
INSERT INTO kfc_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ఎందనిఙ్‌ ఇహిఙ నా కూడ్ఃజి నా పూందు అడిఃగి పణి కిత్తిఙ పణి సూలు మంజినాద్‌, బరుబా సుల్‌కానిక మంజినాద్.” ");
INSERT INTO kfc_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","అయావలె యూదురి విస్రాంతిదినమ్‌దు యేసు పంట గుడ్డెదాన్‌ సొన్సి మహివలె, వన్ని సిసూరిఙ్‌ బఙ కట్తిఙ్‌, వారు సెరెక్‌ తెప్సి నూల్సి తింజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","అయాక పరిసయ్‌రు సుడ్ఃతారె, “ఇదిలో, మోసె సిత్తి రులువజ విస్రాంతిదినమ్‌దు కిదెఙ్‌ ఆఇ పణి, నీ సిసూర్‌ కిజినార్”, ఇజి యేసుఙ్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","వాండ్రు వరివెట ఈహు వెహ్తాన్, “దావీదు రాజుని వన్నివెట మహివరిఙ్‌ బఙ కట్తిఙ్‌, వాండ్రు ఇనిక కిత్తాండ్రొ ఇజి మీరు దేవుణు మాటదు ఎసెఙ్‌బా సద్‌విఇతిదెరా? ");
INSERT INTO kfc_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","వాండ్రు ఇనిక కిత్తాన్‌ ఇహిఙ, గుడారమ్‌దు సొన్సి, దేవుణు ముఙాల ఇడ్తిమహి రొట్టెఙ్ లాగితాన్‌. వాండ్రుని వన్నివెట మహికార్‌ విజేరె తిహార్. అయాక పుజేరిఙునె తప్ప మరి ఎయెర్‌బా తిండ్రెఙ్‌ ఆఏద్‌ ఇజి మోసె సిత్తి రూలుదు వెహ్త మనాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","దేవుణు గుడిఃదు మన్ని పుజేరిఙు విస్రాంతిదినమ్‌దు పణి కిజినార్‌ గాని అక తపు ఆఎద్‌ ఇజి దేవుణు మాటదు రాస్తి మన్నిక మీరు ఎసెఙ్‌బా సద్‌విఇతిదెరా? ");
INSERT INTO kfc_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","దేవుణు గుడిఃదిఙ్‌ ఇంక మిస్తికాన్‌ ఇబ్బె మనాన్‌ ఇజి నాను మిఙి వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","‘మీరు మహివరి ముస్కు కనికారం తొరిస్తెఙ్‌ ఇజినె నాను కోరిజిన గాని కత్ని సీజిని పూజెఙ నాను కోర్‌ఏ’ ఇని మాటదిఙ్‌ అర్దం మీరు నెసిమంజినిక ఇహిఙ, ఇని తపుబా కిఇవరి ముస్కు తప్పు మాటెఙ్‌ వెహ్‌ఏతార్‌ ‌మరి. ");
INSERT INTO kfc_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ఎందానిఙ్‌ నాను యాలెకెండ్‌ వెహ్సినిక ఇహిఙ, లోకుమరిసి ఆతి నఙి విజు దన్నిఙ్‌ అతికారం మనాద్‌. విస్రాంతి దినమ్‌దు‌ లోకుర్‌ ఇనిక కిదెఙ్‌వలె ఇజి వెహ్తిఙ్‌బా నఙి మనాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","అబ్బెణిఙ్‌ సొన్సి మహివలె, వాండ్రు యూదురు మీటిఙ్‌ కిని ఉండ్రి ఇండ్రొ సొహాన్.” ");
INSERT INTO kfc_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","వహ్తి అర్తి ఉండ్రి కియు మన్నికాన్‌ ఒరెన్‌ అబ్బె మహాన్‌. యేసు ముస్కు తప్పు మొప్తెఙ్‌ ఇనికాదొ ఉండ్రి సఙతివందిఙ్ సుడిఃజి వారు వన్నిఙ్‌ ఈహు వెన్‌బాతార్, “విస్రాంతిదినమ్‌దు ఎయెరిఙ్‌బా నెగెండ్‌ కినిక దేవుణు రూలుదిఙ్‌ తగ్నాదా?”. ");
INSERT INTO kfc_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","యేసు వరిఙ్‌ ఈహు వెహ్తాన్‌, “మీ లొఇ ఎయెరిఙ్‌బా ఉండ్రి గొర్రె మహిఙ, విస్రాంతిదినమ్‌దు అక్క ఉండ్రి గాందదు అర్తిఙ, మీరు దనిఙ్‌వెల్లి లాగ్‌ఇదెరా? ");
INSERT INTO kfc_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","మెండగొర్రెదిఙ్‌ ముస్కు లోకు ఎస్సొనొ విలువ మన్నికాన్. అందెఙె విస్రాంతిదినమ్‌దు మేలు కినిక దేవుణు మోసెఙ్‌ సిత్తి రూలుదిఙ్‌ తగ్నాద్.” ");
INSERT INTO kfc_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","అయావలె వాండ్రు వహ్తి కియు అర్తి వన్నిఙ్‌ “నీ కియు సప్‌అ”, ఇజి వెహ్తాన్‌. వాండ్రు కియు సాప్తాన్. అయావలె అక నెగెండ్‌ మన్ని మరి ఉండ్రి కియు లెకెండ్‌ ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","గాని పరిసయ్‌రు వెల్లి సొహారె యేసుఙ్‌ ఎలాగ సప్తెఙ్‌ ఇజి వన్నిఙ్‌ పడిఃఎండ ఆలోసనం కిత్తార్. ");
INSERT INTO kfc_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","యేసు అయా సఙతి నెస్తాండ్రె అబెణిఙ్‌ సొహాన్‌. నండొండార్‌ వన్ని వెనుక సొహార్‌. వాండ్రు వరి జబ్బుది వరిఙ్‌ విజేరిఙ్‌ నెగెండ్‌ కిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","నా వందిఙ్‌ ఎయెరిఙ్‌బా వెహ్మాట్‌ ఇజి వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","యెసయ ప్రవక్త వెట దేవుణు ముఙాల వర్గితి యా మాటెఙ్‌ పూర్తి ఆదెఙ్‌ ఇజి యా లెకెండ్‌ జర్గితాద్. ");
INSERT INTO kfc_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“ఇదిలో, నాను ఏర్‌పాటు కితి నా పణి మన్సి వీండ్రె, నాను వన్నిఙ్‌ ప్రేమిసిన, వన్ని ముస్కు సర్ద ఆజిన. నాను వన్ని ముస్కు నా ఆత్మదిఙ్‌ పోక్న. వీండ్రు విజు జాతిది వరిఙ్‌ నాయం తీరిస్నాన్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","వీండ్రు జటిఙ్‌ ఆఏన్, డేల్‌స్‌ఏన్, విన్ని కంటం వీదిఙ ఎయెరిఙ్‌ విన్‌పిస్‌ఎన్. ");
INSERT INTO kfc_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","నలిగితి గడిఃదిఙ్‌ వాండ్రు తెప్సి విసీర్ఏన్‌, నమ్‌ని దీవదిఙ్‌ వాండ్రు నప్‌ఎన్. వాండ్రు నాయమ్‌దిఙ్‌ గెల్పిసినాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","లోకుర్‌ విజేరె వన్నిఙె ఆసదాన్‌ ఎద్రు సుడిఃజి మంజినార్‌. వాండ్రు విజు జాతిఙ వరిఙ్‌ నాయం తీరిస్నాన్.” ");
INSERT INTO kfc_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","అయావలె సెగొండార్, దెయం అస్తిమహిఙ్‌ వర్గిదెఙ్‌ అట్‌ఇ గుల్ల ఆతి ఒరెన్‌ వన్నిఙ్‌ యేసు డగ్రు తతార్. యేసు వన్నిఙ్‌ నెగెండ్‌ కితాన్. వాండ్రు సుడ్ఃదెఙ్, వర్గిదెఙ్‌ అట్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","లోకుర్‌ విజెరె బమ్మ ఆజి, “మాప్‌ ఎద్రుసుడిఃజి కాప్‌కిజి మంజిని దావీదు రాజు తెగ్గదికాన్‌ వీండ్రు ఆఏండ్రా?”, ఇజి వర్గిజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","పరిసయ్‌రు అయ మాట విహరె, “విజు దెయమ్‌కాఙ్‌ నెయ్కి ఆతి బయిల్‌జెబ్బులు సాయమ్‌దాన్‌ వీండ్రు దెయమ్‌కాఙ్‌ పెర్‌జినాన్”, ఇజి వెహ్తార్. ");
INSERT INTO kfc_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","యేసు వరి ఆలోసనమ్‌కు నెసి వరిఙ్‌ ఈహు వెహ్తాన్‌. “ఎమేణి దేసెమ్‌దికార్‌బ వ రిఙ్‌ వారె పగ ఆజి ఎర్‌లిజి మహిఙ అయ దేసెం పాడాఃనాద్. అయాలెకెండ్‌ ఎమేణి పట్నమ్‌దికార్‌ గాని ఇండ్రొణికార్‌ గాని, వరిఙ్‌ వారె, పగ ఆజి ఎర్‌లిజి మహిఙ నీ ఎమేణి పట్నం గాని ఇల్లు గాని ఏలుబా లావ్‌ రొస్కు నిల్సి మన్‌ఏద్. ");
INSERT INTO kfc_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","సయ్తాను అడిఃగి మన్నికార్‌ ఉండ్రి జటుదికార్‌, మరి ఉండ్రి జటుదివరివెట పగ ఆజి ఎర్లె ఆజి విదెం కిజి మహిఙ, వన్ని ఏలుబడిః ఎలాగ లావ్‌ రొస్కు నిల్సి మంజినాద్.” ");
INSERT INTO kfc_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","బయిల్‌జెబ్బులు సాయమ్‌దాన్ నాను దెయమ్‌కాఙ్‌ పేర్తిఙ, మీ లోకుర్‌ ఎలాగ దెయమ్‌కాఙ్‌ పేర్జినార్‌? అందెఙె నా వందిఙ్‌ మీరు వెహ్నికెఙ్‌ తపు ఇజి వారె రుజుప్‌ కిజినార్. ");
INSERT INTO kfc_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","గాని దేవుణు ఆత్మ సత్తుదాన్‌ ‌నాను దెయమ్‌కాఙ్‌ ‌పేర్జిన ఇహిఙ, నిజమె దేవుణు ఏలుబడిః కినిక మీ నడిఃమి వాత మనాద్. ");
INSERT INTO kfc_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","సుడ్ఃదు, ఒరెన్‌ సత్తుమని వన్నిఙ్‌ ముఙాల తొహ్‌ఏండ, వన్ని ఇండ్రొ డుఃగ్‌జి ఇండ్రొణి సామనమ్‌కు ఎయెరిఙ్‌బా ఒతెఙ్‌ అట్నార్‌? ముఙాల వన్నిఙ్‌ అసి తొహ్తిఙనె డొఙ కిదెఙ్‌ అట్నార్. ");
INSERT INTO kfc_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","నా వెట కూడ్జి మన్‌ఇకాన్‌ ఎయెన్‌బా నఙి పగాతికాన్ ఆనాన్‌. లోకురిఙ్‌ దేవుణు డగ్రు తత్తెఙ్‌ నా వెట కూడ్ఃజి మన్‌ఇకాన్‌ లోకాఙ్‌ సెద్రిస్నికాన్‌ ఆజినాన్. ");
INSERT INTO kfc_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","మరి నాను మిఙి వెహ్సినిక ఇనిక ఇహిఙ, లోకుర్‌ కిని విజు పాపమ్‌కాఙ్, దూసణదిఙ్‌ దేవుణు సెమిస్నాన్, గాని దేవుణు ఆత్మదిఙ్‌ దూసిసి వెహ్తిఙ ఆకెఙ్‌ ఎసెఙ్‌బా సెమిస్‌ఎన్. ");
INSERT INTO kfc_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","లోకు మరిసి ఆతి నఙి పడిఃఏండ ఇనికబా వర్గితిఙ దేవుణు వన్నిఙ్‌ సెమిస్నాన్. గాని దేవుణు ఆత్మదిఙ్‌ పడిఏండ వర్గిని వన్నిఙ్‌ యా లోకమ్‌దుబా, వాని లోకమ్‌దుబా దేవుణు సెమిస్‌ఏన్. ");
INSERT INTO kfc_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","మరాన్‌ నెగ్గిక ఇహిఙ దని పండుబా నెగ్గికదె. సిలిఙ, మరాన్‌ నెగ్గిక ఆఎండ మహిఙ దని పండుబా నెగ్గిక ఆఎద్‌. మరాతి పండుదానె మరాన్‌ ఎలాగ మర్తికాదొ ఇజి నెస్తెఙ్‌ ఆనాద్. ");
INSERT INTO kfc_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","విసం మన్నిసరాస్‌ నన్నికిదెరా, సెఇకిదెరాతి మీరు నెగ్గి మాటెఙ్‌ ఎలాగ వర్గిదెఙ్‌ అట్నిదెర్‌? మీ మన్సుదు మీరు ఒడిఃబిని దన్నిఙ్‌ తగితి లెకెండ్‌నె మీ వెయు ‌వర్గిజినాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","నెగ్గి మన్సు మన్ని వన్నిఙ్‌ కూలిఙ్‌ కొట్టుకిత్తి మన్నిలెకెండ్‌, వని మన్సుదు నెగ్గికెఙె మంజినె. అందెఙె వన్ని వెయుదాన్ నెగ్గి మాటెఙె వానె సెఇ మన్సు మనివన్నిఙ్‌ సెఇకెఙె మంజినె. అందెఙె వన్ని వెయుదాన్ సెఇ మాటెఙె వానె. ");
INSERT INTO kfc_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","గాని నాను మిఙి వెహ్సినిక ఇనిక ఇహిఙ, దేవుణు తీర్పు తీరిస్ని రొజుదు, లోకుర్‌ వర్గితి మహి విజు మాటెఙ వందిఙ్‌ లెక్క సీదెఙ్‌ వలె. ");
INSERT INTO kfc_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","అహిఙ మీ మాటెఙాణిఙె మీరు సిక్సదాన్‌ తప్రె ఆనిదెర్, సిల్లిఙ మీ మాటెఙాణిఙె మీరు మీ ముస్కు సిక్స తపె ఆనిదెర్. ");
INSERT INTO kfc_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","నస్తివలె సెగొండార్‌ పరిసయ్‌రుని యూదురి రూలుఙ్‌ నెస్పిస్నికార్‌ యేసు డగ్రు వాజి వన్నిఙ్‌, “బోదకినికి, నీను దెవుణుబాణిఙ్‌ వాతికాన్‌ ఇనిదన్నిఙ్‌ గుర్తు లెకెండ్‌ నీను తోరిసిని ఉండ్రి బమ్మాతి పణి సుడుఃదెఙ్‌ ఇజి కోరిజినాప్”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","వాండ్రు వరిఙ్‌ “యా తరమ్‌దికిదెర్‌ ఆతి మీరు సెఇకిదెర్‌. దేవుణుదిఙ్‌ నెస్‌ఇకిదెర్‌నె, గుర్తు లెకెండ్‌ ఉండ్రి బమ్మాతి పణి కిజి తోరిస్‌అ ఇజి వెహ్నిదెర్‌. గాని దేవుణు ప్రవక్త ఆతి ఓనెఙ్‌ జర్గితిక తప్ప మరి ఇని గుర్తుబా ఎయెరిఙ్‌బా తోర్‌ఎద్. ");
INSERT INTO kfc_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ఓన మూండ్రి రోస్కు పెరి మొయ పొటాదు ఎలాగ మహండ్రొ, అయలెకెండ్‌నె, లోకుమరిసి ఆతి నానుబా మూండ్రి రోస్కు బూమి లొఇ మంజినలె. ");
INSERT INTO kfc_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ఓన వెహ్తి మాటెఙ్‌ విహారె నినివెదికార్ వరి పాపమ్‌కు ఒప్పు కొడిఃజి డిఃస్త సితార్. అందెఙె తీర్పు తీరిసిని దినమ్‌దు వారు యా తరమ్‌ది వరి వెట నిల్సి విరిముస్కు తీర్పు తీరిస్నార్‌లె. ఇదిలో, ఓనెఙ్‌ మిస్తికాన్‌ ఒరెన్‌ ఇబ్బె మనాన్‌ ఇజి నాను వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ఆక్కరి దినమ్‌కాఙ్‌ తీర్పు తీరిసినివలె, దసిణ దేసెమ్‌ది రాణి ఉండ్రి సాసిలెకెండ్‌ బాన్‌ మంజినాద్లె. ఎందనిఙ్‌ ఇహిఙ సొలొమోను వర్గిని గెణంమన్ని మాటెఙ్‌ వెండ్రెఙ్‌ నండొ దూరం మన్ని దన్ని దేసెమ్‌దాన్‌‌ వాతాద్. ఇదిలో, సొలొమోనుఙ్‌ మిస్తికాన్‌ ఒరెన్‌ ఇబ్బె మనాన్. గాని యా తరమ్‌దికార్‌ వన్ని మాటెఙ్‌ గిబ్బిఙ్‌ ఒడ్ఃజి వెన్‌ఏర్‌, అందెఙె యా తరమ్‌ది వరిఙ్‌ తీర్పు మంజినాద్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","ఉండ్రి దెయం ఒరెన్‌ వన్నిఙ్‌ డిఃసి వెల్లి వాతి వెనుక, మండ్రెఙ్‌బాడ్డి వందిఙ్‌ రెబాజి బిడిఃమ్‌బూమిదు బూలాజినాద్. గాని ఎంబెబా దనిఙ్‌బాడ్డి దొహ్క్‌ఏతాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","నస్తివలె ‘నాను డిఃస్తి వాతి నా ఇండ్రొ మర్‌జి సొనాలె’, ఇజి దనిఙ్‌ అదినె వెహ్నద్. మర్‌జి వాతిఙ్‌ అది డిఃస్తి సిత్తికాన్‌, నెగెండ్‌ సిపాజి సుబరం కిజి ఎయెర్‌బా మన్‌ఇ ఇల్లు లెకెండ్‌ మన్నక సూణాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","నస్తివలె అది మర్‌జి సొన్సి, దన్నిఙ్‌ ఇంక సెఇకెఙ్‌ అతి మరి ఏడు దెయమ్‌కాఙ్‌ దన్నివెట కూక్న తనాద్. అవిక్‌ వని లొఇ సొన్సి అబెనె బస కినె. అయావలె వన్ని గతి ముందాహి దనిఙ్‌ ముస్కు కస్టం ఆనాద్. అయలెకెండ్‌నె యా తరమ్‌ది వరిఙ్‌ గతిబా మంజినాద్.” ");
INSERT INTO kfc_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","యేసు మంద లోకుర్‌ వెట వర్గిజి మహివలె, వన్ని అయ్‌సిని తంబెరిఙు వన్నివెట వర్గిదెఙ్‌ ఇజి వెల్లి నిహ మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","అయావలె ఒరెన్, “ఇదిలో నీ యాయని నీ తంబెరిఙు నీ వెట వర్గిదెఙ్‌ ఇజి వెల్లి నిహ మనార్”, ఇజి వన్నిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","అందెఙె వెహ్తివన్నిఙ్‌ సుడ్ఃజి, “ఎయెద్‌ నా యాయ? ఎయెరు నా తంబెరిఙు?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","వన్ని సిసూర్‌ఙ ‌కియు తోరిసి, “ఇదిలో నా యాయని నా తంబెరిఙు. ");
INSERT INTO kfc_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","పరలోకామ్‌దు మన్ని నా బుబ్బెఙ్‌ ఇస్టం ఆతివజ కినికాండ్రె నా తంబెరి, నా తఙి, నా యాయ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","అయ దినమ్‌దునె, యేసు ఇండ్రొణిఙ్‌ వెల్లి సొన్సి సమ్‌దరం పడఃకాదు బస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","మంద లోకుర్‌ వన్ని డగ్రు వాతిఙ్‌ వాండ్రు ఉండ్రి డోణిదు ఎక్త బస్తాన్. లోకుర్‌ విజెరె సమ్‌దరం పడఃకాదు నిహార్. ");
INSERT INTO kfc_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","అయావలె వాండ్రు వరిఙ్‌ సుడ్ఃజి నండొ సఙతిఙ్‌ కత వజ వరిఙ్‌ వెహ్తాన్‌ “ఒరెన్‌ రయ్తు వాండ్రు విత్కు విత్తెఙ్‌ సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","వాండ్రు విత్సి మహిఙ్‌ సెగం విత్కు సరి పడఃకాదు అర్తె. పొటిఙ్‌ వాజి వన్కాఙ్‌ తిహె. ");
INSERT INTO kfc_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","సెగం విత్కు సటు ముస్కు మని లావ్‌లోతు సిలి డుల్లిదు అర్తె. డుల్లి లోతు లావ్‌ సిల్లితిఙ్‌ అవి వెటనె నేర్తె. ");
INSERT INTO kfc_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","గాని డుల్లి తకు మహిఙ్‌ వెలెఙ్‌ లొఇ సొన్‌ఇతిఙ్, పొదు సోసి ఎండ తాక్తిఙ్‌ అవి సాతె. ");
INSERT INTO kfc_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","సెగం విత్కు సాప్కుతుపెఙ అర్తె. సాప్కు తపుఙ్‌ పెరిసి వన్కాఙ్‌ అణసు తిగితె. ");
INSERT INTO kfc_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","మరి సెగం విత్కు నెగ్గి బూమిదు అర్తె. అబ్బె విత్తి విత్తుదిఙ్‌ వంద వంతుఙ్, అరువయ్‌వంతుఙ్, ముపయ్‌వంతుఙ్‌ లెక్క పండితె. ");
INSERT INTO kfc_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","గిబ్బిఙ్‌ ఒడ్ః‍జి వెంజి అయాలెకెండ్‌ నడిఃజి మండ్రు. ");
INSERT INTO kfc_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","వన్ని సిసూర్‌ వాతారె, “ఎందనిఙ్‌ నీను కత వజ వరిఙ్‌ వెహ్సిని”, ఇజి వన్నిఙ్‌ వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","వాండ్రు వరిఙ్‌ ఈహు వెహ్తాన్‌. “దేవుణు ఏలుబడిః కిని వందిఙ్‌ డాఃఙితి మని సఙతిఙ్‌ దేవుణు మిఙి తెలివి కిత మనాన్‌, గాని విరిఙ్‌ తెలివి కిఏన్. ");
INSERT INTO kfc_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","దేవుణు ఏలుబడి కిని వందిఙ్‌ నెస్తి మని వన్నిఙె మరి తెలివి కినాన్. వన్నిఙ్‌ మరి నండొ నెస్పిస్నాన్. ఇనికబా అర్దం ఆఇ వన్నిబాణిఙ్‌ వాండ్రు నెస్తిమనికబా లాగె ఆనాద్. ");
INSERT INTO kfc_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ఎందనిఙ్‌ నాను కత వజ వరిఙ్‌ వెహ్సిన ఇహిఙ, వారు సుడ్ఃజినార్‌ గాని సుడ్ఃతిక వరిఙ్‌ తోర్‌ఏద్. వెంజినార్‌ గాని నెగెండ్‌ విన్‌ఏర్, అర్దంబా కిఏర్. ");
INSERT INTO kfc_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","15","మీరు ఎస్తివలెబా వెంజినిదెర్‌ గాని అర్దం కిదెఙ్‌ అట్‌ఇదెర్‌. ఎస్తివలెబా సుడ్ఃజినిదెర్‌ గాని ఇనిక ఇజి నెస్‌ఇదెర్. వారు వరి కణకాణిఙ్‌ సుడ్ఃజి, గిబిఙాణిఙ్‌ వెంజి మన్సుదాన్‌ అర్దం కిజి నా దరోట్‌ మహ్తిఙ, నాను వరిఙ్‌ నెగెణ్‌ కిత మరి. గాని అయ లెకెండ్‌ జర్‌గిఏండ వరి మన్సు కొడుఃవుదాన్‌ నిండ్రిత మనాద్. వరి గిబబిఙ్‌ మందఙ్‌ ఆతె. వారు వరి కణ్కు మూక్త మనార్. యా లెకెండ్‌ ఎసయ ప్రవక్తవెట దేవుణు ముఙాల వర్గితి మాట వరి ముస్కు పూర్తి ఆతె. ");
INSERT INTO kfc_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","మీ సుడ్ఃజినికెఙ్‌, వెంజినికెఙ్‌, మీరు అర్దం కిజినిదెర్‌. అందెఙె మీరు దేవుణు సీజిని దీవనమ్‌కు మన్నకిదెర్‌. ");
INSERT INTO kfc_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","నండొండార్‌ ప్రవక్తరుని నీతి నిజాయ్తి మన్నికార్‌ మీరు సుడ్ఃజిని వన్కాఙ్‌ సుడ్ఃదెఙ్‌ ఆస ఆతార్, గాని సుడ్ఃదెఙ్‌ అట్‌ఎతార్. మీరు వెంజిని వన్కాఙ్‌ విండ్రెఙ్‌ ఆస ఆతార్‌ గాని విండ్రెఙ్‌ అట్‌ఎతార్. ");
INSERT INTO kfc_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","విత్కు విత్తివన్ని కతదిఙ్‌ అర్దం మీరు జాగర్త వెండ్రు. ");
INSERT INTO kfc_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ఎయెన్‌బా దేవుణు ఏలుబడిః కిని వందిఙ్‌ వెహ్ని మాటెఙ్‌ వెంజి దనిఙ్‌ అర్దం అట్‌ఏండ మహిఙ, సయ్తాన్‌ వాజి వన్ని మన్సుదు వితి దనిఙ్‌ పెర్న ఒనాన్. యాకాదె మడిఃఙ నడిఃమిహాన్‌ సొని సర్దు అర్తి మన్నివిత్కు. ");
INSERT INTO kfc_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","సెగొండార్‌ సట్టు ముస్కు మని లోతు సిల్లి డుల్లి నన్నికార్. సెగం విత్కు అయా డుల్లిదు అర్తె, గాని వారు దేవుణు మాట వెంజి సర్‌దదాన్‌ దనిఙ్‌ వెటనె మన్సుదు ఇడ్నార్. ");
INSERT INTO kfc_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","వారు కండెక్‌ కాలం దేవుణుముస్కు నమకమ్‌దాన్‌ నిల్నార్‌. గాని కస్టమ్‌కు, స్రమెఙ్‌ వానివలె వెటనె దేవుణు ముస్కు మన్ని నమకం వారు డిఃసి సీజినార్. ");
INSERT INTO kfc_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","మరి ఒరెన్‌ విత్కు అర్తి మన్ని సాప్కుతుపెఙ్‌ నేర్ని బూమి నన్నికాన్. వాండ్రు దేవుణు మాట వెంజినాన్‌ గాని యా లోకమ్‌ది బత్కు వందిఙ్‌ విసారం ఆజి మరి డబ్బు వందిఙ్‌ సెఇ ఆస ఆజి, వనిఙ్‌ అణసు తిగ్‌జి మంజినె. వన్ని బత్కుదు పలం సిలి నన్నికాన్‌ ఆనాన్. ");
INSERT INTO kfc_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","మరి ఒరెన్‌ విత్కు అర్తి మన్ని నెగ్గి బూమిలెకెండ్‌ మనాన్‌. వాండ్రు దేవుణు మాట వెంజి దనిఙ్‌ అర్‌దం కిజినాన్. వాండ్రు, విత్తి విత్తుదిఙ్‌ వంద వంతుఙ్, అరువయ్‌ వంతుఙ్, ముపయ్‌ వంతుఙ్‌ పలం సీనాన్. ");
INSERT INTO kfc_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","యేసు మరి ఉండ్రి సఙతి కత వజ వరిఙ్‌ వెహ్తాన్‌. “దేవుణు ఏలుబడిః ఇహిఙ, వన్ని మడిఃఙ నెగ్గి విత్కు విత్తి వన్నిఙ్‌ పోలిత మనాద్. ");
INSERT INTO kfc_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","గాని విజేరె నిద్ర కిజి మహివలె, వన్ని పగాతికాన్‌ వాతాండ్రె, కూలిఙ నడిఃమి కారు విత్కు వితాండ్రె సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","కూలిఙ్‌ నేర్‌జి పిరితెనె, సెరెక్‌ పోక్తివలె, నెగ్గి కూలిఙ్‌లెకెండ్‌ మన్ని కారుబా తోరితాద్. ");
INSERT INTO kfc_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","వన్ని పణి మసిర్‌ మడిఃఙ యాజుమాని డగ్రు వాతారె, “ఓ బాబు, నీను నీ మడిఃఙ నెగ్గి విత్కునె వితిగదె? మరి ఎమేణి యా కారు మొక్కెఙ్‌ వాతె?”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“ఒరెన్‌ పగాతికాన్‌ యాక కితాన్‌”, ఇజి వాండ్రు వెహ్తాన్‌. అయ పణి మనిసిర్ మాపు సొన్సి వనకాఙ్‌ లాగ్‌జి కొటు కిదెఙ్‌ నిఙి ఇస్టమ్‌నా? ఇజి వెన్‌బతార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","అయావలె వాండ్రు, “ఏలు పోని, నెగ్గి కూలిఙ్‌లెకెండ్‌ మన్ని కారు మొక్కెఙ్‌ మీరు లాగ్నివలె వనకవెట ఒకవేల కూలిఙ్‌బా తెప్నిదెర్‌సు. ");
INSERT INTO kfc_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","కొయ్‌ని కాలం వానిదాక రుండిబా కూడ్ఃజి పిరిపీద్‌. కొయ్‌ని కాలమ్‌దు, నెగ్గి కూలిఙ్‌ లెకెండ్ మన్నికారు మొక్కెఙ ముఙాల కొయ్‌జి కటెఙ్‌ తొహ్సి సుర్‌దు, వెనుక కూలిఙ్‌ కొయ్‌జి తసి నా కొటుదు వాక్తు’, ఇజి కొయ్‌ని వరిఙ్‌ వెహ్న”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","యేసు మరి ఉండ్రి సఙతి కత వజ వరిఙ్‌ వెహ్తాన్‌. “దేవుణు ఏలుబడిః ఇహిఙ, సర్సు మొక్కెఙ్‌ విత్కుదిఙ్‌ పోలిత మనాద్. ఒరెన్, అక్క వన్ని మడిఃఙ విత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","అయాక విజు విత్కు లొఇ ఇజిరికాదె, గాని పిరితిఙ కుస మొక్కెఙ విజు వనకాఙ్‌లొఇ పెరిక ఆజి మరాన్‌ లెకెండ్‌ ఆనాద్. ఆగసమ్‌దు ఎగ్రిజిని పొటిఙ్‌ వాజి దన్ని కొమెఙ గూడు తొహ్సి బస్నె. ");
INSERT INTO kfc_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","యేసు మరి ఉండ్రి సఙతి కత వజ వరిఙ్‌ వెహ్తాన్‌. “దేవుణు ఏలుబడిః ఉండ్రి బోదెలి నండొ నెగ్గి దూరుదు కలప్తిమన్ని పులాఙ్‌ మన్ని కండెక్‌ దూరుదిఙ్‌ పోలిత మనాద్. అయాక కలప్తి మన్ని దూరుదిఙ్‌ విజు పులాఙ్‌ కినిదాక పణి కినాద్.” ");
INSERT INTO kfc_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","యేసు కత వజనె విజు మాటెఙ్‌ లోకురిఙ్‌ వెహ్తాన్‌. కత వజ ఆఏండ ఇనికబా వరిఙ్‌ వెహ్‌ఏతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","“నాను కత వజనె వెయ్‌దాన్‌ వెహ్న. లోకం పుట్తి బాణిఙ్‌ అసి డాఃఙితిమన్ని సఙతిఙ్‌ నాను తెలివి కిన”, ఇజి ప్రవక్త వెట దేవుణు ముఙాల వర్గితి మాటెఙ్‌ పూర్తి ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","నస్తివలె వాండ్రు లోకురిఙ్‌ డిఃసి ఇండ్రొ సొహాన్‌. వన్ని సిసూర్‌ వన్ని డగ్రు వాజి, “మడిఃఙ మన్నినెగ్గి కూలిఙ్‌లెకెండ్‌ మన్ని కారు మొక్కెఙ వందిఙ్‌ వెహ్తి కతదిఙ్‌ అర్దం మఙి వెహ్‌అ”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","అందెఙె వాండ్రు ఈహు వెహ్తాన్‌. “నెగ్గి విత్కు విత్తికాన్‌ లోకు మరిసి ఆతి నాను. ");
INSERT INTO kfc_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","మడిఃఙ యా లోకం. నెగ్గి విత్కు దేవుణు ముస్కు నమకం ఇడ్తి మన్ని దేవుణు కొడొఃర్‌ నెగ్గి కూలిఙ్‌లెకెండ్‌ మన్ని కారు మొక్కెఙ్‌, సయ్తాను కొడొఃర్. ");
INSERT INTO kfc_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","వనకాఙ్‌ విత్తికాన్‌ పగాతికాన్‌ అతి సయ్తాను. కోత్త కొయ్‌నిక యా లోకమ్‌దిఙ్‌ ఆక్కర్‌దినం. కొయ్‌నికార్‌ దేవుణు దూతార్. ");
INSERT INTO kfc_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","నెగ్గి కూలిఙ్‌ లెకెండ్‌ మన్ని కారుదిఙ్‌ లాగ్జి కొట్టుకిజి సుర్ని లెకెండ్‌నె యా లోకమ్‌ది ఆకర్‌దినమ్‌బా వానాద్. ");
INSERT INTO kfc_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","42","నెగ్గి కూలిఙ్‌ లెకెండ్‌ మన్ని కారుదిఙ్‌ లాగ్జి కొట్టు కిజి ససుద్‌ సుర్ని లెకెండ్, పాపం కిజిని వరిఙ్, మరి పాపం కిబిస్ని విజు దన్నిఙ్‌ నా ఏలుబడిఃదాన్‌ వెల్లి పోక్తెఙ్‌ ఇజి, లోకుమరిసి ఆతి నాను నా దూతారిఙ్‌ పోక్నాలె. వారు వరిఙ్‌ సిసుద్‌ విసీర్‌నాలె. అబ్బె వారు అడఃబాజి, పల్కు కొహ్సి మంజినార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","నీతి నిజాయ్తి మనికార్‌ వరి బుబ్బాతి దేవుణు కిని ఏలుబడిఃదు పొద్దు లెకెండ్‌ జాయ్‌ సీజి మంజినార్. మీరు గిబ్బిఙ్‌ ఒడ్ఃజి వెంజి అయావజ నడిఃజి మండ్రు. ");
INSERT INTO kfc_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“దేవుణు ఏలుబడిః కినిక, మడిఃఙదు డాప్తిమన్ని విలువాతి ఆస్తిదిఙ్‌ పోలిత మనాద్. ఒరెన్‌ ఆ విలువాతి ఆస్తిదిఙ్‌ సుడ్ఃతిఙ్, ఎయెర్‌బా నెస్‌ఏండ మరి డాప్సి, గొప్ప సర్‌దదాన్‌ సొన్సి వన్నిఙ్‌ మనికెఙ్‌ విజు పొర్సి అయ మడిఃఙ కొటాన్. ");
INSERT INTO kfc_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","మరి నాను మిఙి వెహ్సిన, దేవుణు ఏలుబడిః కినిక ఇహిఙ, ఒరెన్‌ ముజెలు సవుకారి రెబాజిని గొప్ప విలువ మన్ని ముజెలు లెకెండ్‌నె. ");
INSERT INTO kfc_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","వాండ్రు రెబాజినిలెకెండ్‌ మన్ని, ఉండ్రి విలువాతి ముజెలుదిఙ్ సుడ్ఃతాండ్రె, సొన్సి వన్నిఙ్‌ కల్గితి మనికెఙ్‌ విజు పొర్సి అయ ముజెలు కొటాన్. ");
INSERT INTO kfc_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","మరి నాణు మిఙి వెహ్సిన, దేవుణు ఏలుబడిః కినిక ఇహిఙ, సమ్‌దరమ్‌దు పొక్సిని రకరకమ్‌ది మొయెఙ్‌ అస్ని వలాదిఙ్‌ పోలిత మనాద్. ");
INSERT INTO kfc_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","అయ వల నిండ్రితిఙ్‌ మొయెఙ్‌ అస్నికార్, వల పడకాదు లాగ్జి బసి, నెగ్గి మొయెఙ గంపాదు ఇడ్నార్. సెఇ మొయెఙ విసీర్‌నార్. ");
INSERT INTO kfc_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","యా లెకెండ్‌నె యా తరమ్‌ది ఆక్కర్‌ దినంబా వానాద్. దేవుణు దూతార్‌ వాజి నీతి నిజాయ్తి మన్ని వరిబాణిఙ్, సెఇవరిఙ్‌ ఎర్‌లిస్నార్. ");
INSERT INTO kfc_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","వారు వరిఙ్‌ గొప్ప పెరి సిసు బాడ్డిదు అర్‌ప్నార్. అబె అడఃబాజి, పల్కు కొహ్‌క్సి మంజినార్.” ");
INSERT INTO kfc_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“యా విజు సఙతిఙ వందిఙ్‌ మిఙి అర్దం ఆతాదా?”, ఇజి యేసు వరిఙ్‌ వెన్‌బాతాన్. “ఒఒ”, ఇజి వారు మర్‌జి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","“దేవుణు ఏలుబడిః కిని వందిఙ్‌ నెస్తి మన్ని యూదురి రూలుఙ్‌ నెస్పిస్నికార్‌ విజేరె, వన్ని ఆస్తి ఇడ్తి మన్ని గదిదాన్‌ పడాయికెఙ్, కొత్తకెఙ్‌ ఉండ్రె లెకెండ్‌ వెల్లి తని ఇండ్రొణి ఎజుమానిఙ్‌ లెకెండ్‌ మనాన్”, ఇజి వాండ్రు వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","యేసు యా కతెఙ్ వెహ్తి వీజితి వెనుక, అబెణిఙ్‌ సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","వన్ని సొంత పట్నమ్‌దు వాతాండ్రె, వాండ్రు యూదురు మీటిఙ్‌ కిని ఇల్కాఙ్‌ లోకురిఙ్‌ నెస్పిసి మహాన్‌. “విన్నిఙ్‌ యా గెణం, యా బమ్మాతి పణిఙ్‌ కిని సత్తు ఎంబెణిఙ్‌ వాతాద్”, ఇజి వారు బమ్మ ఆజి వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","“వీండ్రు కంసెల్‌ వాండ్రు మరిసి ఆఎండ్రా? విన్ని అయ్‌సి పేరు మరియ గదె? యాకోబు, యోసేపు, సీమోను, యూద ఇనికార్‌ విన్ని తంబెరిసిర్‌ గదె? ");
INSERT INTO kfc_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","విన్ని తఙిసిక్‌ మా వెట మనెగదె? యాకెఙ్‌ విజు వినిఙ్‌ ఎంబెణిఙ్‌ వాతె? ");
INSERT INTO kfc_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","వారు వన్ని ముస్కు కోపం ఆజి మహార్‌. గాని యేసు వరిఙ్‌ “ఒరెన్‌ ప్రవక్త, వన్ని సొంత ఇండ్రొనె గవ్‌రవం సిల్లికాన్‌ ఆజినాన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","వన్ని ముస్కు వరిఙ్‌ నమకం సిల్లితిఙ్‌ వాండ్రు అబ్బె లావ్‌బమ్మాతి పణిఙ్‌ కిఏతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","2","నస్తివలె హేరొదురాజు యేసు వందిఙ్‌ మాటెఙ్ విహండ్రె, “వీండ్రు సాతి వరిబాణిఙ్‌ మర్‌జి నిఙితి బాప్తిసం సీని యోహను. అందెఙె యా బమ్మాతి పణికిని సత్తు వన్ని లొఇ మనాద్”, ఇజి వన్ని పణి మన్సిరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","వన్ని తంబెరిసి ఆతి పిలిపు ఆల్సి హేరోదియ వందిఙ్‌ హేరొదురాజు ఆడ్ర సిత్తిలెకెండ్‌ యోహనుఙ్‌ అసి గొలుసుదాన్‌ తొహ్సి జెలిదు ఇడ్త మహార్. ");
INSERT INTO kfc_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ఎందనిఙ్‌ ఇహిఙ, “దనిఙ్‌ నీ వందిఙ్‌ అల్సి లెకెండ్‌ ఇడె ఆతిక దేవుణు మోసెఙ్‌ సిత్తి రూలుదిఙ్‌ పడిఏద్”, ఇజి యోహాను వన్నిఙ్‌ వెహ్త మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","యోహనుఙ్‌ సప్తెఙ్‌ ఇజి హేరోదు రాజు ఒడిఃబితాన్‌, గాని లోకుర్‌ విజేరె వీండ్రు ఒరెన్‌ దేవుణు ప్రవక్త ఇజి వెహ్సి మహిఙ్‌ విన్నిఙ్‌ సప్తెఙ్‌ తియెలాత మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","హేరోదు రాజు పుట్తి రోజు వాతిఙ్, హేరోదియ గాల్సి వాజి వరి వందిఙ్‌ డాట్సి కర్‌జితాద్. హేరోదు రాజఙ్‌ గొప్ప సర్‌ద ఆతాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","అందెఙె అది ఇనిక లొస్తిఙ్‌బా సీన ఇజి వాండ్రు దనివెట ఉండ్రి ఒట్టు పొక్సి దన్నిఙ్‌ ఉండ్రి మాట సిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","అయ్‌సి దనిఙ్‌ సుత్రిస్తి లెకెండ్‌నె అది సొహదె, “బాప్టిసం సీని యోహను బుర్ర కత్సి ఉండ్రి పలెందు సిద”, ఇజి లొస్తాద్. ");
INSERT INTO kfc_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","రాజు గొప్ప బాద ఆతాన్. గాని వాండ్రు కితి ప్రమాణం వందిఙ్, వన్ని వెట విందుదిఙ్‌ బస్తిమిహి కూలెఙ్‌ వందిఙ్‌ అది లొస్తిక సీదెఙ్‌ ఇజి ఆడ్ర సితాన్. ");
INSERT INTO kfc_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","జెలిదు మహి యోహను బుర్ర కత్‌పిస్తన్. ");
INSERT INTO kfc_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","వన్ని బుర ఉండ్రి పలెమ్‌దు ఇడ్జి తపిసి దనిఙ్‌ సిబిస్తాన్‌. అది అయాక దని అయ్‌సి డగ్రు ఒత సితాద్. ");
INSERT INTO kfc_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","యోహను సిసూర్‌ వాజి వన్ని పినుగు పెర్జి ఒసి సమాది కితార్. నస్తివలె వారు యేసు డగ్రు వాతారె వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","జర్‌గితి సఙతిఙ్‌ విజు విహాండ్రె యేసు ఉండ్రి డోణి ఎక్సి ఎయెర్‌బా మన్‌ఇ ఉండ్రి బాడ్డిదు ఒరేండ్రె సొహాన్‌. వాండ్రు సొహి సఙతి వెంజి అయ పట్నమ్‌దికార్‌ నండొండార్‌ నడిఃసి వన్ని వెనుక సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","వాండ్రు అతాహ పడక జోరె అందితిఙ్, డోణిదాన్‌ డిగితాన్‌ అయా మంద లోకురిఙ్‌ సుడ్ఃతాండ్రె వరి ముస్కు కనికారం ఆతాన్. వరి జబ్బుదివరిఙ్‌ నెగెండ్‌ కిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","పొద్దు ఆతివెలె వన్ని సిసూర్‌ వన్ని డగ్రు వాజి, “అక్క ఎయెర్‌ మన్‌ఇ బాడ్డి, ఏలునె పొద్దు ఆతాద్. యా లోకుర్‌ నాహ్కఙ్‌ సొన్సి వారె వరిఙ్‌ బోజనమ్‌కు కొండెఙ్‌ వరిఙ్‌ పోక్‌అ”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","“వారు సొండ్రెఙ్‌ అక్కర్‌ సిల్లెద్‌. మీరె వరిఙ్‌ తిండ్రెఙ్‌ ఇనికబా సీదు”, ఇజి యేసు వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","“ఇదిలో, మా వెట అయ్‌దు రొటెఙ్‌ని రుండి మొయెఙ్‌నె మనె”, ఇజి వారు వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","“అయకెఙ్‌ నా డగ్రు తగాట్”, ఇజి యేసు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","వెనుక లోకాఙ్‌ పసి గడ్డి ముస్కు బస్తు ఇజి వెహ్తాండ్రె అయ్‌దు రొటెఙ్‌ని రుండి మొయెఙ్‌ కీదు అస్తాండ్రె ఆగాసం దరిఙ్‌ సుడ్ఃజి దేవుణుదిఙ్‌ వందనమ్‌కు వెహ్సి రొటెఙ్‌ రుక్సి సిసూరిఙ్‌ సితాన్. సిసూర్‌ అక లోకాఙ్‌ సీబాత సితార్. ");
INSERT INTO kfc_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","వారు విజేరె పొట పంజు తిహార్‌. వెనుక మిగిలిత్తి ముక్కెఙ్‌ పన్నెండు గంపెఙ్‌ సిసూర్‌ పెహ్తార్. ");
INSERT INTO kfc_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","బోదెక్‌ని కొడొఃర్‌ అఏండ తిహికార్‌ అయ్‌దువేలు మన్సి మొగకొడొఃర్‌ మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","లోకురిఙ్‌ పోక్తి వెటనె యేసు వన్ని సిసూర్‌ఙ ‌వెటనె ఉండ్రి డోణి ఎకిసి, వన్నిఙ్‌ ఇంక ముఙాల అతాహ పడక సొండ్రు ఇజి వరిఙ్‌ పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","వరిఙ్‌ పోక్తి వెనుక, వాండ్రు ఒరేండ్రె పార్దనం కిదెఙ్‌ ఉండ్రి గొరొత్‌ ఎక్తాన్. పొదు ఆతివెలె వాండ్రు ఒరేండ్రె అబ్బె మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","గాని డోణి ఒడ్డుదాన్‌ నండొ దూరం సొహాద్ గొప్ప గాలి కిజి మహిఙ్‌ ఉల్కెఙాణిఙ్‌ డోణి ఇతల్‌ అతాల్‌ దూఙ్‌జి మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","కోడిఃజామ్‌దు యేసు సందారమ్‌దు ఏరు ముస్కు నడిఃజి వరి డగ్రు సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","వాండ్రు సమ్‌దరమ్‌దు ఏరు ముస్కు నడిసినిక సిసూర్‌ సుడ్ఃతారె తియెల్ ‌అతార్. “అబయా యాక ఉండ్రి దూబ”, ఇజి వారు తియెల్‌ ఆజి డెల్‌స్తార్. ");
INSERT INTO kfc_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","వెటనె యేసు, “దయ్‌రమ్‌దాన్‌ మండ్రు, ఇక నానె, తియెల్‌ ఆమాట్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","పేతురు, “ప్రబువా, నీనె ఇహిఙ, నాను ఏరు ముస్కు నడిఃజి నీ డగ్రు వాదెఙ్‌ సెలవ సిద్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“రఅ”, ఇజి యేసు వెహ్తాన్‌. నస్తివలె పేతురు డోణి డిఃగ్‌జి యేసు దరోట్‌ ఏరు ముస్కు నడిఃత వాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","గాని గాలిదిఙ్‌ నిఙిత్తి ఉల్కెఙ సుడ్ఃజి తియెలాజి వాండ్రు ముడుఃగ్‌జి మహాన్‌. “ప్రబువా నఙి రసిస్‌అ”, ఇజి డేల్‌స్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","వెటనె యేసు వన్ని కియు సాప్సి వన్నిఙ్ అస్తాన్. “ఇజిరి నమకం మనికి, ఎందనిఙ్‌ నీను అనుమానం ఆతి?”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","వారు డోణి ఎక్తిఙ్‌ గాలి అలెతాద్. ");
INSERT INTO kfc_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","నస్తివలె డోణిదు మనికార్‌ వాజి, “నిజమె, నీను దేవుణు మరిసినె”, ఇజి వెహ్సి వన్నిఙ్‌ పొగ్‌డిఃజి మాడిఃస్తార్. ");
INSERT INTO kfc_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","వారు అతాహ పడక సొన్సి గెనెసెరెతు నాటొ అందితార్. ");
INSERT INTO kfc_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","అబ్బెణి లోకుర్‌ వన్నిఙ్‌ గుర్తు అస్తారె డగ్రు మని నాహ్కఙ్‌ కబ్రు పోక్తార్. లోకుర్‌ వరి కస్టమ్‌దు మన్ని వరిఙ్‌ విజేరిఙ్‌ వన్ని డగ్రు తత్తార్. ");
INSERT INTO kfc_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","జబ్బు మన్నికార్‌ వన్ని సొక్క సెంగుబా ముట్తెఙ్‌ బతిమాల్‌జి సెలవ లొస్తార్. ముట్తికార్‌ విజేరె నెగెండ్‌ అతార్. ");
INSERT INTO kfc_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","2","సెగొండార్‌ పరిసయ్‌రుని యూదురిఙ్‌ రూలుఙ్‌ నెస్పిస్నికార్‌ యెరూసలేమ్‌దాన్‌ వాతారె యేసుఙ్‌, “ఎందనిఙ్‌ నీ సిసూర్‌ బోజెనమ్‌దిఙ్‌ ముందాల కికు నొర్‌బాఏర్, పెద్దెల్‌ఙ అలవాటుఙ నెక్సి పోక్సినార్‌?”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","యేసు వరిఙ్‌ ఈహు మర్‌జి వెహ్తాన్, “మీరు ఎందనిఙ్‌ మీ అలవాటుఙ వందిఙ్‌ దేవుణు ఆడ్రెఙ నెక్సి పోక్సినిదెర్‌? ");
INSERT INTO kfc_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","మీ యాయ బుబ్బరిఙ్‌ గవ్‌రం సీదు, మరి ఎయెర్‌బా అయ్‌సి అప్పొసిరిఙ్‌ దూసిసి వెహ్తిఙ వన్నిఙ్‌ తప్తెఙ్‌వలె ఇజి దేవుణు రూలుదు వెహ్త మనాద్. ");
INSERT INTO kfc_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","గాని మీరు నెస్పిసిని దన్ని లొఇ తేడ మనాద్‌ మిరు నెస్పిసినిక ఇనిక ఇహిఙ ఎయెన్‌బా, “నాను మిఙి ఇనికబా ఉండ్రి సాయం లెకెండ్‌ కిన ఇజి ఇట్తి మనిక, దేవుణుదిఙ్‌ సంత సిత్త మన్న’ ఇజి అయ్‌సి అప్పొసిరిఙ్‌ వెహ్తిఙ, వాండ్రు మరి గవ్‌రమ్‌దాన్‌ నెగెండ్‌ సుడ్ఃదెఙ్‌ అక్కర్‌ సిల్లెద్‌. ఇజి అయాలెకెండ్‌ మీ అలవాటు వందిఙ్‌ మీరు దేవుణు మాటదిఙ్‌ సిలి లెకెండ్‌ కిజినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","9","వేసం కినికిదెరా, “యా లోకుర్‌ వరి బెద్‌వెఙాణిఙ్‌ నఙి పొగ్డిజినార్‌ గాని వరి మన్సు నా బాణిఙ్‌ దూరం మనాద్. వారు పణిదిఙ్‌రెఏండ నఙి పొగ్‌డిఃజినార్. వారు నెస్పిస్నికెఙ్‌ విజు లోకురి రూలుఙ్‌నె, ఇజి యెసయ ప్రవక్త వెట దేవుణు ముఙాల మీ వందిఙ్‌ వర్గితిక నిజమె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","యేసు అయ మంద లోకురిఙ్‌ డగ్రు కూక్తాండ్రె ఈహు వెహ్తాన్, “మీరు జాగర్త వెంజి నెగెండ్‌ అర్దం కిదు. ");
INSERT INTO kfc_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","వెయుదాన్‌ లొఇ సొనిక ఇనికబా ఎయెరిఙ్‌బా ఇనిక ఆఏద్. గాని లొఇహాన్‌‌ వెయుదాన్‌ వెల్లివాని మాటెఙ్‌నె ఒరెన్‌ వన్నిఙ్‌ సెఇక కినె.” ");
INSERT INTO kfc_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","నస్తివలె వన్ని సిసూర్‌ వాతారె, “యా మాటెఙ్‌వెంజి పరిసయ్‌రు నండొ కోపం ఆతిక నీను నెస్నిదా?”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","వాండ్రు సిసూరిఙ్‌, “పరలోకామ్‌దు మన్ని నా బుబ్బాతి దేవుణు ఉణుస్‌ఇ విజు మొకెఙ్‌ వేలెఙాణిఙ్‌ తెరె ఆనె వారబా అయ మొకెఙ్‌ లెకెండ్‌నె. ");
INSERT INTO kfc_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","వరిఙ్‌ డిఃసి సీదు. వారు గుడ్డిదివరిఙ్‌ సరి తోరిస్ని గుడ్డిదికార్. ఒరెన్‌ గుడ్డిదికాన్‌ మరి ఒరెన్‌ గుడ్డి వన్నిఙ్‌ సరి తోరిస్తిఙ వారు రిఎర్‌బా గాంతదు అర్‌నార్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","అందెఙె పేతురు, “యా కత వందిఙ్‌ మఙి అర్దం ఆనిలెకెండ్‌ వెహ్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","యేసు వరిఙ్, “ఏలుబా మీరు మహివరిలెకెండ్‌ మనిదెరా? ఏలుబా నిన్ని మాటెఙ్‌ అర్దం కిదెఙ్‌ మిఙి బుద్ది సిల్లెదా? ");
INSERT INTO kfc_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","వెయుదాన్‌లోఇ సొనిక, పొటాదు సొన్సి మరి అయాక మీరు బయ్‌లు బస్నివలె బూమిదు సొన్సినాద్, ఇక మీరు నెస్‌ఇదెరా? ");
INSERT INTO kfc_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","గాని వెయ్‌దాన్‌ వెల్లి వాని మాటెఙ్‌ మన్సుదాన్‌ వాజినె. ఆకెఙె లోకుదిఙ్‌ సెఇక కిజినె. ");
INSERT INTO kfc_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","సెఇ ఆలోసనమ్‌కు, సప్నికెఙ్, రంకు బూలానిక, కేలార్‌బూలానిక, డొఙ కినిక, అబద్దం వెహ్నికెఙ్, దేవుణుదిఙ్‌ దూసిస్నికెఙ్‌ యాకెఙ్‌ విజు మన్సుదానె వాజినె. ");
INSERT INTO kfc_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","యాకెఙె ఒరెన్‌ వన్నిఙ్‌ సెఇక కిజినె. కికు నొర్‌బాఏండ ఉటిఙ అక ఒరెన్‌ వన్నిఙ్‌ సెఇక కిఏ.” ");
INSERT INTO kfc_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","యేసు అబ్బెణిఙ్‌ నండొ దూరం సొన్సి ఉండ్రి గొరొన్‌ ఎక్సి డిగితాండ్రె తూరు, సీదోను ఇని పట్నమ్‌కాఙ్‌ సెందితి ప్రాంతమ్‌కాఙ్‌ సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","వాండ్రు అబ్బె అందితిఙ్‌ అబ్బెణిఙ్‌, కానాన దేసెమ్‌ది ఉండ్రి బోదెలి వాతాదె, “ప్రబువా, దావీదు మరిసి నఙి కనికారం తోరిస్‌అ. నా గాల్సిఙ్‌ దెయం అస్తిఙ్‌ గొప్ప బాద ఆజినాద్”, ఇజి డేల్సి వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","యేసు దనిఙ్‌ ఉండ్రి మాటబా వెహ్‌ఏతాన్. అందెఙె వన్ని సిసూర్‌ వాజి, “ఇది మా వెట గగోల్‌ ఆజి వాజినాద్, దనిఙ్‌ పోక్‌అ”, ఇజి బతిమాల్‌తార్. ");
INSERT INTO kfc_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","వాండ్రు వరిఙ్, “మురుతి మెండగొర్రెఙ్‌ లెకెండ్‌ దేవుణుబానిఙ్‌ దూరం ఆతి ఇస్రాయేలు లోకుర్‌ డగ్రు నాను పోకె ఆత మన్న”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","అది వన్ని ముఙాల వాజి ముణుకుఙ్‌ ఊర్‌జి, “ప్రబువా, నఙి సాయం కిఅ”, ఇజి వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","వాండ్రు దనిఙ్, “కొడొఃర్‌ తిండ్రెఙ్‌ మని రొటెఙ్‌ లాగ్జి నుకుడిఙ్‌ సీనిక నాయం ఆఎద్”, ఇజి వెహ్తాన్‌‌. ");
INSERT INTO kfc_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","అది, “నిజమె ప్రబువా, గాని ఎజమాని తింజిమహిఙ్‌ బల్లదాన్‌ అర్ని ముక్కెఙ్‌ నుకుడుఃఙ్‌ తింజినె గదె?”, ఇజి వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","నస్తివలె యేసు, “బయి, నా ముస్కు మని నీ నమకం గొప్ప పెరిక. నీను కోరితి లెకెండ్‌నె నిఙి ఆపిద్”, ఇజి దనిఙ్‌ వెహ్తాన్‌. అయ గడియాదునె దని గాల్సి నెగెండ్‌ ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","యేసు అబెణిఙ్‌ సొన్సి గలీలయ సమ్‌దారం పడకాదాన్‌ వాజి అబె ఉండ్రి గొరోత్‌ ఎక్తాండ్రె బస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","సొటావరిఙ్, గుడ్డివరిఙ్, గుల్లవరిఙ్, కికు కాల్కు అర్తివరిఙ్‌ మరి ఆఇ జబ్బుదివరిఙ్‌ నండోడారిఙ్‌ అసి మంద లోకుర్‌ వన్ని డగ్రు వాతారె వరిఙ్‌ వన్ని కాల్క అడ్గి ఇట్తార్. వాండ్రు వరిఙ్‌ నెగెండ్‌ కిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","గుల్లవరిఙ్‌ వర్‌గిదెఙ్‌ వాతాద్. కికు కాల్కు అర్తికార్ ‌నెగెమడ్‌ ఆతార్. సొటాదికార్‌ నడిఃతార్, గుడ్డిదికార్‌ సుడ్ఃదెఙ్‌ అట్తార్. యాకెఙ్‌ సుడ్ఃజి లోకుర్‌ విజెరె బమ్మ ఆతారె ఇస్రాయేలురి దేవుణుదిఙ్‌ పొగిడిఃతార్. ");
INSERT INTO kfc_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","యేసు వన్ని సిసూర్‌ఙ ‌కూక్తాండ్రె వరిఙ్, “యా లోకుర్‌ నావెట మంజి మూండ్రి దినమ్‌కు ఆతె. విరిఙ్‌ తిండ్రెఙ్‌బా ఇనికబా సిల్లెద్‌. నఙి వరి ముస్కు కనికారం ఆజిన. వరిఙ్‌ బఙదావ్‌ పోక్తెఙ్‌ మఙి మన్సు రెఏ. వారు కణ్కు త్రివిజి సర్దు అర్‌నార్‌సు”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","సిసూర్‌ వన్నిఙ్, “నిసొ మంద లోకురిఙ్‌ తీపిస్తెఙ్‌ బిడిఃమ్‌బూమి ప్రామతమ్‌దు ఇనిక దొహ్క్‌నె?”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","యేసు వరిఙ్, “మీ బాన్‌ఎసోడు రొటెఙ్‌ మన్నె?”, ఇజి వెన్‌బాతాన్. వారు, “ఏడు రొటెఙ్‌ని సెగం ఇజిరి మొయెఙ్‌ మనె”, ఇజి వన్నిఙ్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","లోకురిఙ్‌ బూమిదు బస్తు ఇజి యేసు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","వెనుక అయ ఏడు రొటెఙ్‌ని మొయఙ్‌ కీదు అస్తాండ్రె దేవుణుదిఙ్‌ వందనమ్‌కు వెహ్సి అయాకెఙ్‌ రుక్సి వన్ని సిసూర్‌ఙ ‌సితాన్. వారు లోకాఙ్‌ సీబాజి సితార్. ");
INSERT INTO kfc_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","లోకుర్‌ విజేరె పొట పంజు తిహి వెనుక మిగిలితి ముక్కెఙ్‌ ఏడు గంపెఙ్‌ నిండ్రు వన్ని సిసూర్‌ పెహ్తర్. ");
INSERT INTO kfc_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","బోదెక్‌ని కొడొఃర్‌ ఆఏండ తిహి మొగకొడొఃర్‌ నాల్గివెయిఙ్‌ మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","అయ మంద లోకురిఙ్‌ పోక్తి వెనుక యేసు డోణి ఎక్తాండ్రె మగదాన్‌ ఇని నాటొ సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","నస్తివలె పరిసయ్‌రుని సదుకయ్‌రు యేసుఙ్‌ డగ్రు పరిక్స కిదెఙ్, వన్ని మాటెఙాణిఙ్‌ వన్నిఙ్‌ ఆస్తెఙ్‌ ఇజి డగ్రు వాతార్‌. దేవుణునె వన్నిఙ్‌ పోక్తాన్‌ ఇనిదన్నిఙ్‌ రుజుప్‌ లెకెండ్‌ ఆగాసమ్‌దాన్‌ ఉండ్రి బమ్మాతి పణి కిఙి మఙి తోరిస్‌అ, ఇజి వెహ్తార్‌‌. ");
INSERT INTO kfc_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","వాండ్రు వరిఙ్, “పొద్దు ఆనివెలె ఆగసం ఎర్రఙ్‌ మహిఙ నేండ్రు నెగెణ్‌ మంజినాద్‌ ఇజి మీరు వెహ్సినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","మరి, పెందల ఆగసం ఎర్రఙ్‌ ఆజి మొసొప్‌ మహిఙ, నేండ్రు గాలి పిరు వానాద్, ఇజి మీరు వెహ్సినిదెర్. ఆగసం సుడ్ఃజి అయ రోజు ఎలాగ మంజినాద్‌ ఇజి వెహ్తెఙ్‌ మీరు నెస్నిదెర్‌, గాని జర్గినికెఙ్‌ సుడ్ఃజి కాలమ్‌దిఙ్‌ గుర్తు అస్తెఙ్‌ అట్‌ఇదెర్. ");
INSERT INTO kfc_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","యా తరమ్‌దికార్, సెఇకార్‌ ఆతికారె దేవుణు వందిఙ్‌ వరిఙ్‌ మన్సు సిల్లెద్‌ గుర్తు లెకెండ్‌ ఉండ్రి బమ్మాతి పణి వందిఙ్‌ వెన్‌బజినార్, గాని దేవుణు ప్రవక్త ఆతి ఓనెఙ్‌ జర్గితిక తప్ప మరి ఇనికబా ఉండ్రి గుర్తు మరి తోర్‌ఎద్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","వెనుక యేసు వరిఙ్‌ డిఃసి అబ్బెణిఙ్‌ సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","వారు డోణి ఎక్తారె సమ్‌దరం అతాహ పడక సొన్సి మహివలె, వన్ని సిసూర్‌ రొట్టెఙ్‌ ఒత్తెఙ్‌ పోస్త మహార్‌. నస్తివలె యేసు, “పరిసయ్‌రుది మరి సదుకయ్‌రుది పులాఙ్‌ కిని దూరువందిఙ్‌ మీరు గొప్ప జాగర్త మండ్రు”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","“మాప్‌ రొట్టెఙ్‌ తెఇతి వందిఙె యా మాట వెహ్తాన్‌”, ఇజి ఒరెన్‌ వెట ఒరెన్‌వర్గిజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","యేసు అక నెస్తాండ్రె, ఎందానిఙ్‌ మీరు నమకం తక్కు మనికిదెర్‌ ఆజినిదెర్‌! మీ బాన్‌ రొట్టెఙ్‌ సిల్లితిఙ్‌ మీరు ఎందనిఙ్‌ ఒరెన్‌ మరి ఒరెన్‌ వెట వర్‌గిజినిదెర్‌? ");
INSERT INTO kfc_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ఏలుబా మీరు అర్దం కిజి నెస్తెఙ్‌ అట్‌ఇదెరా? అయ్‌దు రొట్టెఙ్‌ మహివలె అయ్‌దు వెయిఙ్‌ లోకాఙ్‌ తీపిస్తిఙ్‌ మిగిలితికెఙ్‌ ఎసోడు గంపెఙ్‌ పెహ్తిదెరొ? ");
INSERT INTO kfc_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","మరి ఏడు రొట్టెఙ్‌ మహివలె నాల్గి వెయిఙ్‌ లోకాఙ్‌ తీపిస్తిఙ్‌ మిగిలితికెఙ్‌ ఎసోడు గంపెఙ్‌ పెహ్తిదెరొ? వినుకాఙ్‌బా మీరు ఎతు కిఇదెరా? ");
INSERT INTO kfc_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","నాను వర్గితిక రొట్టెఙ్‌ వందిఙ్‌ ఆఏద్‌ ఇజి ఎందనిఙ్‌ మీరు అర్దం కిజి నెస్‌ఇదెర్‌? గాని పరిసయ్‌రుని సదుకయ్‌రుది పులాని దూరు వందిఙ్‌ మీరు జాగర్త మండ్రు ఇజి నాను వెహ్త”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","నస్తివలె వాండ్రు జాగర్త మండ్రు ఇజి వెహ్తిక రొటె తయార్‌ కిని పులాని దురు వందిఙ్‌ ఆఏద్‌‌ గాని పరిసయెరుని సదుకయ్‌రుది పులాని దూరు నని బోద వందిఙ్‌ జాగర్త ఆజి మండ్రు ఇజి వెహ్తాన్‌, ఇజి వారు అర్దం కిజి నెస్తార్. ");
INSERT INTO kfc_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","యేసు పిలిపుది ఆతి కయసెరియ పట్నమ్‌దిఙ్‌ డగ్రు మన్ని నాహ్కఙ్‌ వాతిఙ్ “లోకు మరిసి ఆతి నా వందిఙ్, నాను ఎయెన్‌ ఇజి లోకుర్‌ వెహె ఆజినార్‌?”, ఇజి వన్ని సిసూర్‌ఙ వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","“సెగొండార్‌ బాప్తిసం సీని యోహాను ఇజినార్‍, సెగొండార్‌ ఏలియ ఇజినార్‍, మరి సెగొండార్‌ యిరిమ్య ఇజినార్‍, సిల్లె ప్రవక్తెఙ లొఇ ఒరెన్‌ ఇజి సెగొండార్‌ వెహె ఆజినార్”, ఇజి వారు వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","అందెఙె యేసు, “గాని నాను ఎయెన్‌ ఇజి మీరు వెహ్సినిదెర్‌?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","పేతురు ఆతి సీమోను, “నీను బత్కిజిని దేవుణు మరిసి ఆతి క్రీస్తు”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","యేసు, వన్నిఙ్, “యోన మరిసి ఆతి సీమోను, నీను దేవుణు సీజిని దీవనమ్‌కు మంజినికాన్‌. యాక నిఙి తెలియకిత్తిక లోకుర్‌ఎయెర్‌బా ఆఏర్‌ గాని పరలోకామ్‌దు మని నా బుబ్బాతి దేవుణునె. ");
INSERT INTO kfc_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","గాని నాను నిఙి వెహ్నిక ఇనిక ఇహిఙ నీను పేతురు, నీ పేరుదిఙ్‌ తర్దం సట్టు ఇజి నాను యా సుటు ముస్కు నా సఙమ్‌దిఙ్‌ తొహ్న. అయా లోకమ్‌ది సత్తుఙ్‌ దనిఙ్‌ గెలిస్తెఙ్‌ అట్‌ఏద్‌. ");
INSERT INTO kfc_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","దేవుణు ఏలుబడిః కిజిని పరలోకామ్‌దిఙ్‌ సెందితి ఆతికారం నాను నిఙి సీన, యా లోకమ్‌దు నీను ఇనిక తొహ్నిదొ, అయాక పరలోకామ్‌దుబా తొహె అనాద్. యా లోకమ్‌దు నీను ఇనిక కుత్నిదొ, అయాక పరలోకామ్‌దుబా కుతె ఆనాద్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","వెనుక యేసు, వాండ్రు క్రీస్తు ఆతికాన్‌ ఇజి ఎయెరిఙ్‌బా మీరు వెహ్తెఙ్‌ ‌ఆఎద్‌‌ ఇజి వన్ని సిసూరిఙ్‌ కసితం వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","అయ వెలెహన్‌ అసి యేసు, నాను యెరూసలేమ్‌దు సొండ్రెఙ్‌ వెలె, మరి అబె పెదెలుఙ, పెరి పుజెరిఙుని యూదురి రూలుఙ్‌ నెస్పిస్ని వరి కిదాన్‌ నండొ ఇమ్‌సెఙ్‌ ఓరిస్నాలె, లోకుర్‌ నఙి సప్నార్లె సాతి మూండ్రి రోజుదు దేవుణు నఙి మరి మర్‌జి నిక్నినాలె ఇజి నండొ సఙతిఙ్‌ వన్ని సిసూరు వెట వెహ్సి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","పేతురు యేసుఙ్‌ ఉండ్రి పడఃకాదు కూక్త ఒతండ్రె, “ప్రబువా, నిఙి యా లెకెండ్‌ జర్గిదెఙ్‌ ఆఎద్”, ఇజి గటిఙ వెహ్తెఙ్‌ మొదొల్‌స్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","అహిఙ, వాండ్రు పేతురు దరిఙ్‌ మర్‌జి బేసి, “ఓ సయ్‌తానా! నీను నఙి ఉండ్రి అడ్డు లెకెండ్‌ మని. నీ మన్సుదు మని సఙతిఙ్‌ దేవుణుబాణిఙ్‌ వాతిక ఆఎద్, లోకుర్‌ ఒడ్ఃబినికెఙె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","నస్తివలె యేసు వన్ని సిసూరిఙ్‌ సుడ్ఃజి, “ఎయెన్‌బా నా వెనుక వాదెఙ్‌ ఇహిఙ, వాండ్రు వన్ని సొంత ఆసెఙ్‌ విజు డిఃసి సీజి వన్నిఙ్ వాజిని కస్టంకు విజు ఓరిస్తెఙ్‌ తయారాజి పిండ్ఃజి నా వెట సాదెఙ్‌బా తయారాజినె నా వెనుక వాదెఙ్వలె. ");
INSERT INTO kfc_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ఎయెన్‌బా వన్ని పాణమ్‌దిఙ్‌ వాండ్రె కాపాడఃదెఙ్‌ ఇజి సుడ్ఃతిఙ వన్నిఙ్‌ ఎలాకాలం మంజిని బత్కు మన్‌ఏద్‌. నా వందిఙ్‌ ఎయెరిఙ్‌బా వన్ని పాణం నస్టం ఆతిఙ, వాండ్రు ఎలాకాలం మంజిని బత్కుదు సొనాన్లె. ");
INSERT INTO kfc_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ఎయెన్‌బా వాండ్రు కొరిజినిక్కెఙ్‌ దొహ్‌క్సి యా లోకమ్‌ది ఆస్తిని సర్ద విజు దొహ్‌క్సి వెనుక దేవుణువెట ఎలాకాలం మంజిని బత్కుదు సొన్‌ఏండ మహిఙ ఇని లబం మనాద్‌? దేవుణువెట ఎలాకాలం మంజిని బత్కుదిఙ్‌‌ బదులు మరి ఇనిక సీదెఙ్‌ అట్నాన్‌? ");
INSERT INTO kfc_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","లోకు మరిసి ఆతి నాను, నా బుబ్బాతి దేవుణు గొప్ప జాయ్‌దాన్, వన్ని విజు దూతరిఙ్‌ తోడుః అసి రాజు లెకెండ్‌ వానాలె. వెనుక ఒరెన్‌ వన్నిఙ్‌ వన్ని పణిదిఙ్‌ తగితి లెకెండ్‌ పలం సీనాలె. ");
INSERT INTO kfc_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","లోకుమరిసి ఆతి నాను రాజు లెకెండ్‌ ఏలుబడిః కినిక సూణిదాక, ఏలు నిహిమన్ని వరిలొఇ సెగొండార్‌ సాఏర్‌ ఇజి నాను మిఙి నిజం వెహ్సిన”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ఆరు రోస్కు వెనుక యేసు, పేతురుని యాకోబు, యాకోబు తంబెరిసి ఆతి యోహనుఙ్‌బా కూక్తాండ్రె వన్నివెట ఒతాన్. వారు నండొ ఎత్తుమని ఉండ్రి గొరోన్‌ ముస్కు ఎక్త సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","అబ్బె వరి ముందాల వన్ని రూపు మారితాద్. వన్ని మొకొం పొద్దు లెకెండ ఆతాద్. వన్ని సొకెఙ్‌ మెర్సిని జాయ్‌లెకెండ్‌ తెలాఙ్‌ ఆతె. ");
INSERT INTO kfc_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ఇదిలో, నస్తివలె అబ్బె మోసెని ఏలియ యేసు వెట వర్గిజి మంజినిక వరిఙ్‌ తోరె ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","నస్తివలె పేతురు, “ప్రబువా, మాటు ఇబ్బె మహిఙ నెగెద్. నిఙి ఇస్టం ఇహిఙ, ఇబ్బె నిఙి ఉండ్రి, మోసెఙ్‌ ఉండ్రి, ఏలియెఙ్‌ ఉండ్రి, ఆహె మూండ్రి గుడుఃసెఙ్‌ తొహ్న”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","వాండ్రు వర్గిజి మహివలె నండొ జాయ్‌మని ఉండ్రి మొసొప్‌ వరిఙ్‌ ప్‌డ్‌గ్‌తాద్. “ఇదిలోన్ వీండ్రు నఙి ఇస్టమాతి నా మరిన్. విన్ని ముస్కు నాను సర్ద ఆత మన్న. విన్ని మాటెఙ్‌ నెగెండ్‌ వెండ్రు”, ఇజి ఉండ్రి జాటు అయ మొసోపుదాన్‌ వాతాద్. ");
INSERT INTO kfc_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","సిసూర్‌ యా మాట విహరె నండొ తియెల్‌ ఆజి పడ్ఃగ్జి అర్తార్. ");
INSERT INTO kfc_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","యేసు వరి డగ్రు వాజి వరిఙ్‌ ముట్సి, “నిఙ్‌దు, తియెల్‌ ఆమాట్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","వారు కణ్కు పెర్జి బేస్తిఙ్‌ యేసుఙ్‌ తప్ప మరి ఎయెరిఙ్‌బా తొఏతార్. ");
INSERT INTO kfc_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","వారు గొరొన్‌ డిగ్‌జి వాజి మహివలె, “లోకు మరిసి ఆతి నాను, సాతి వరిబాణిఙ్‌ మర్‌జి నిఙ్‌నిదాక, మిఙి తోరె ఆతి యా సఙతిఙ్‌ వందిఙ్‌ ఎయెరిఙ్‌బా వెహ్మాట్”, ఇజి యేసు వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","నస్తివలె వన్ని సిసూర్, “ఏలియ ముఙాల వాదెఙ్‌ ఇజి ఎందనిఙ్‌ యూదురి రూలుఙ్‌ నెస్పిస్నికార్‌ వెహ్సినార్‌?”, ఇజి వన్నిఙ్‌ వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","అందెఙె వాండ్రు, ఏలియానె ముఙాల వాజి మండ్రెఙ్, యాక నిజమె. వాండ్రు వాజి విజు నెగెణ్‌ తయార్‌ కినాన్. ");
INSERT INTO kfc_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","అహిఙ ఏలియ ముఙాల వాత మహాన్‌, గాని వారు వన్నిఙ్‌ గుర్తు అస్తెఙ్‌అట్‌ఎండ వరిఙ్‌ ఇస్టమాతి లెకెండ్‌ వన్నిఙ్‌ పడిఃఎండ కితార్. లోకుమరిసి ఆతి నానుబా అయాలెకెండ్‌ వరి కిదాన్‌ స్రమెఙ్‌ ఓరిస్నాలె”, ఇజి వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","బాప్తిసం సీని యోహను వందిఙ్‌ వాండ్రు వరివెట వర్గిజినాన్‌ ఇజి వారు అర్దం కితార్. ");
INSERT INTO kfc_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","వారు మంద లోకుర్‌డగ్రు వాతివలె ఒరెన్‌ వన్ని డగ్రు వాజి వన్ని ముందాల ముణ్కు ఊర్‌జి, ");
INSERT INTO kfc_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“ప్రబువా నా మరిన్‌ ముస్కు నీ కనికారం తోరిస్‌అ వాండ్రు మూర్స పెహ్తిఙ్‌ నండొ బాద ఆజినాన్. వాండ్రు ఎసెఙ్‌ ఎసెఙ్‌ సిసుద్‌ సిలిఙ ఏరుదు అర్సి మంజినాన్. ");
INSERT INTO kfc_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","నాను నీ సిసూర్‌ డగ్రు వన్నిఙ్‌ తత్త గాని వారు వన్నిఙ్‌ నెగెండ్‌ కిదెఙ్‌ అట్‌ఎతార్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","అందెఙె యేసు, “యా తరమ్‌దికిదెర్‌ ఆతి మీరు మహికార్‌ మిఙి నెస్పిస్ని తప్ప సరిదాన్‌ నడిఃసి మన్నదెర్‌. మీరు నాముస్కు నమకం సిల్లికిదెర్‌. నాను ఎస్సొ కాలమ్‌కు దాక నాను మిఙి ఓరిసి మండ్రెఙ్‌ వలె వన్నిఙ్‌ నా డగ్రు తగాట్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","నస్తివలె యేసు అయ దెయమ్‌దిఙ్‌ ఉండ్రి ఆడ్ర సితిఙ్‌ అక్క వన్నిఙ్‌ డిఃస్తతాద్. అయ గడిఃయాదునె ఆ ఇజిరికాన్‌ నెగెండ్‌ ఆతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","దని వెనుక వన్ని సిసూర్‌వాండ్రు ఒరేండ్రె మహివలె యేసు డగ్రు వాతారె, “మాపు ఎందనిఙ్‌అయ దెయమ్‌దిఙ్‌ సొన్‌పిస్తెఙ్‌ అట్‌ఏతాప్‌?”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","ఉండ్రి సర్సుగిడ నస్తు నమకం మహిఙ యా గొరొన్‌దిఙ్‌ సుడ్ఃజి, “ఇబ్బెణిఙ్‌ అబ్బె సొన్‌అ’ ఇజి వెహ్తిఙ అది అబ్బె సొనాద్. మీరు కిదెఙ్‌ అట్‌ఇక ఇనికబా మన్‌ఏద్, ఇజి నాను మిఙి నిజం వెహ్సిన”, ఇజి వెహ్తాన్‌. మిఙి నస్సొ నమకం సిల్లెద్‌, అందెఙె మీరు కిదెఙ్‌ అట్‌ఇదెర్‌. ");
INSERT INTO kfc_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","వారు గలీలయ దేసమ్‌దు వాతివెలె యేసు, “లోకు మరిసి ఆతి నాను లోకుర్‌ కియుదు ఒపజెపె ఆనాలె. ");
INSERT INTO kfc_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","వారు నఙి సప్నార్, మరి మూండ్రి దినమ్‌దు నాను మర్‌జి నిఙెఆనాలె”, ఇజి వరిఙ్‌ వెహ్తిఙ్‌ వారు నండొ దుకం ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","యేసుని వన్ని సిసూర్‌ కపెర్నహముదు వాతివెలె, సెగం సెకల్‌ లెక్క పన్ను పెర్‌నికార్‌ పేతురు, డగ్రు వాతారె, “మిఙి బోద కినికాన్‌ దేవుణు గుడిఃది పన్ను సిఏండ్రా?”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“ఒఒ వాండ్రు సీనాన్”, ఇజి వాండ్రు వెహ్తాన్‌. పేతురు ఇండ్రొ వాతిఙ్, వాండ్రు వర్గిఏండ ముఙాల యేసు వర్గితాన్. “సీమోను, యా లోకమ్‌ది రాజుర్‌ ఎయెర్‌బాణిఙ్‌ సిస్తుని పన్నుఙ్‌ ఒసూలు కిజినార్‌ వరి సొంత దేసెమ్‌ది వరిబాణిఙ్‌నా, సిల్లిఙ అయదేసెమ్‌దు మన్ని ఆఇ దేసెమ్‌దివరి బాణిఙ్‌నా? నీను ఇనిక ఒడ్ఃబిజిని?”, ఇజి వన్నిఙ్‌ వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“వారు విద్దెం కిజి గెలిస్తి దేసెమ్‌దివరిబాణిఙ్ఙె”, ఇజి పేతురు వెహ్తాన్‌. యేసు వన్నిఙ్, “అహిఙ సొంత దేసెమ్‌దికార్‌ సిఏండ తప్రె ఆజినార్. ");
INSERT INTO kfc_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","మాటు వరిఙ్‌ అడ్డు మంజిని వరిఙ్‌లెకెండ్‌ మండ్రెఙ్‌ ఆఎద్‌. నీను సేరుదు సొన్సి గాలం పొక్సి ముందాల దొహ్క్‌ని మొయదిఙ్‌ అసి దని వేయు రెక్సి సుడ్ఃతిఙ, ఉండ్రి సెకెల్‌ కాసు దని వెయ్‌దు మంజినాద్. అయాక లాగ్జి నీ వందిఙ్‌ని నా వందిఙ్‌ పన్ను సిఅ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","నస్తివలె సిసూర్‌ యేసు డగ్రు వాజి, “దేవుణు కిని ఏలుబడిః కినివలె మాలొఇ ఎయెన్‌ అబ్బె పెరికాన్‌ మంజినాన్‌?”, ఇజి వన్నిఙ్‌ వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","వాండ్రు ఒరెన్‌ ఇజిరి కొడొఃదిఙ్‌ కూక్సి వరి నడిమి నిల్‌ప్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","మరి వాండ్రు ఈహు వెహ్తాన్, “మీరు ఇజిరి కొడొఃర్‌ లెకెండ మన్సు మరిసి, వరి లెకెండ్‌ ఆఎండ మహిఙ, మీరు ఎసెఙ్‌బా దేవుణు కిని ఏలుబడిఃదు సొండ్రెఙ్‌ అట్‌ఇదెర్, ఇజి నాను మిఙి నిజం వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","అందెఙె యా ఇజిరి కొడొః లెకెండ్‌ తగె ఆనికాన్‌ ఎయెండ్రొ, వాండ్రె దేవుణు కిని ఏలుబడిఃదు పెరికాన్‌ ఆనాన్. ");
INSERT INTO kfc_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","మరి ఎయెర్‌బా నా ముస్కు మన్ని నమ్మకమ్‌దు యా ఇజిరి కొడొఃర్‌ లెకెండ్‌ ఆతికాన్‌ ఇజి ఒడ్ఃబినాండ్రొ ననివన్నిఙ్‌ డగ్రు కినికాన్‌, నఙి డగ్రు కిజినాన్. ");
INSERT INTO kfc_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","గాని, నా ముస్కు నమకం ఇట్తి మని యా కొడొః నన్ని ఒరెన్‌ వన్నిఙ్, ఎయెర్‌బా పాపం కిబిస్తిఙ, వాండ్రు వన్ని మెడదు ఉండ్రి పెరి జత్తపణుకు తొహె ఆజి సమ్‌దరం అడ్గి ముడుఃగిజి సొనిక వన్నిఙ్‌ ఒద్దె నెగెద్. ");
INSERT INTO kfc_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ఎందానిఙ్‌ ఇహిఙ, లోకురిఙ్‌ పాపం కిబిస్ని సఙతిఙ వందిఙ్‌ యా లోకమ్‌ది వరిఙ్‌ స్రమెఙ్‌ తప్‌ఉ. యాకెఙ్‌ తప్‌ఎండ వాదెఙ్‌వెలె. గాని యాకెఙ్‌ ఎయెన్‌వెట వానెనొ వన్నిఙ్‌ వెహ్తెఙ్‌ అట్‌ఇ నని కస్టమ్‌కు మంజినె. ");
INSERT INTO kfc_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","నీ కియుబా, నీ కాల్కుబా నిఙి పాపం కిబిస్తిఙ, దనిఙ్‌కత్సి విసీర్‌అ. రుండి కికు కాల్కు మంజి ఎలాకాలం మంజిని సిసుబాడిఃదు అర్ని దనిఙ్‌ ఇంక, కికు కాల్కు సిల్లెండ ఆజి ఎలాకాలం దేవుణు వెట మంజిని బత్కుదు సొనిక నెగెద్. ");
INSERT INTO kfc_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","మరి నీ కణక నిఙి పాపం కిబిస్తిఙ దనిఙ్‌లాగ్‌జి విసీర్‌అ. రుండి కణ్కు మంజి ఎలాకాలం మంజిని సిసుబాడిఃదు అర్ని దనిఙ్‌ ఇంక, ఉండ్రె కణక మంజి ఎలాకాలం దేవుణు వెట మంజిని బత్కుదు సొనిక నెగెద్. ");
INSERT INTO kfc_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","యా ఇజిరి వరి లొఇ ఎయెరిఙ్‌బా మిరు ఇజిరి కణుక సుడ్ఃమాట్. ఎందానిఙ్‌ ఇహిఙ పరలోకామ్‌దు నా బుబ్బ డగ్రు మంజిని దూతార్‌ ఎస్తివలెబా వరిఙ్‌ సుడ్ఃజి మంజినార్. ");
INSERT INTO kfc_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","గొర్రెఙ్‌ లెకెండ్‌ మురుతి సొహి లోకురిఙ్‌ రెబాజి రక్సిస్తెఙ్‌ ఇజినె లోకుమరిసి ఆతి నాను ఇబ్బె వాత మన్న. ");
INSERT INTO kfc_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ఒరెన్‌ వన్నిఙ్‌ వంద గొర్రెఙ్‌ మంజి వన్కాఙ్‌ లొఇ ఉండ్రి మురుతిఙ, మహి తొంబయ్‌ తొమ్మిది గొర్రెఙ డిఃసి, మురుతి గొరెదిఙ్‌ రెబాజి సొన్‌ఎండ్రా? మీరు ఇనిక ఒడ్ఃబిజినిదెర్‌? ");
INSERT INTO kfc_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","దనిఙ్‌ దొహ్క్‌తిఙ, వన్ని మురుఎండ మని తొంబయ్‌ తొమ్మిది గొర్రెఙ ముస్కు యా మురుతి ఉండ్రి గొర్రె వందిఙ్‌ వాండ్రు గొప్ప సర్ద ఆనాన్, ఇజి నాను మిఙి నిజం వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","అయలెకెండ్‌నె యా ఇజిరి వరిలొఇ ఒరెన్‌బా పాడాఃజి సొండ్రెఙ్‌ దేవుణు మంజిని బాడిఃదు మని మీ బుబాతి దేవుణుదిఙ్‌ ఇస్టం సిల్లెద్‌. ");
INSERT INTO kfc_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","మరి నీ తంబెరిఙ లొఇ ఒరెన్‌ నిఙి తపు పణిఙ్‌ కతిఙ, మరి ఎయెర్‌బా నెస్‌ఏండ వాండ్రుని నీను మనివెలె వాండ్రు కితి తపు పణిఙ్‌ తోరిస్‌అ. వాండ్రు నీ మాట వెహిఙ నీను వన్నిఙ్‌ మర్‌జి నీ వెట కూడ్ఃజి మంజిని వన్నిలెకెండ్‌ కిత్తి. ");
INSERT INTO kfc_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","గాని వాండ్రు నీ మాట విన్‌ఏండ మహిఙ, ఒరెన్‌ వన్నిఙ్‌నొ, రిఏరిఙ్‌నొ నీ వెట తోడుః అసి వన్ని డగ్రు సొన్‌అ. అహిఙ దేవుణు మాటదు మని లెకెండ్ రిఎర్‌ ముఏర్‌ది సాసిరి మాటెఙవెట విజు సఙతిఙ్‌ నిజమాతికెఙ్‌ ఇజి రుజుప్‌ కిదెఙ్‌ వలె. ");
INSERT INTO kfc_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","వాండ్రు వరి మాటబా విన్‌ఏండ మహిఙ, అయ సఙతి దేవుణు సఙమ్‌దిఙ్‌ తెలియ కిఅ. సఙమ్‌ది వరి మాటబా వాండ్రు విన్‌ఏండ మహిఙ వన్నిఙ్‌ ఆఇ వన్ని ననికాన్, సిల్లిఙ పన్ను పెర్నికాన్‌ ఇజి సుడ్ఃఅ. ");
INSERT INTO kfc_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","యా బూమి ముస్కు మీరు ఇనిక తొహ్నిదెరో, అయాకెఙ్‌ దేవుణు మంజిని బాడ్డిదుబా తొహె ఆనెలె. మరి యా బూమి ముస్కు మీరు ఇనిక కుత్నిదెరో, ఆయాకెఙ్‌ పరలోకామ్దు దేవుణుబా అడ్డు కినాలె. మరి యా బూమి ముస్కు ఇనిదన్నిఙ్‌ సెలవ సీనిదెరో పరలోకామ్‌దాన్‌ దేవుణుబా దన్నిఙ్‌ సెలవ సీనాలె ఇజి నాను మిఙి నిజం వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","మరి ఎయెర్‌బా రిఎర్‌కూడ్ఃజి, ఉండ్రె మన్సు కల్గిజి ఇనికబా లొస్తిఙ్‌బా, పరలోకామ్‌దు మన్ని నా బుబ్బాతి దేవుణు, మీరు కోరిజిని లెకెండ్‌ మీ వందిఙ్‌ కినాన్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","అహిఙ ఎంబె రిఏర్‌నొ, ముఏర్‌నొ నా పేరుదాన్‌ కూడ్ఃజి వాజి మహిఙ, అబ్బె వరివెట నాను మంజినలె.” ");
INSERT INTO kfc_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","నస్తివలె పేతురు యేసు డగ్రు వాతండ్రె, “నా తబేరి ఒరెన్‌ నా వెట తపు కితిఙ నాను ఎసోడు సుట్కు వన్నిఙ్‌ సెమిస్తెఙ్‌? ఎడుః సుట్కు సెమిస్తెఙ్‌ ఆనాదా?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","యేసు వన్నిఙ్, “ఏడు సుట్కు ఆఎద్‌. డబయ్, సుట్కు ఏడు ఇజి నాను నిఙి వెహ్సిన”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ఎందానిఙ్‌ ఇహిఙ దేవుణు ఏలుబడిః కినిక ఇహిఙ, వన్ని పణిమన్సిర్‌వెట వారు వన్ని బాణిఙ్‌ లొస్తిమన్ని అపుదిఙ్‌ లెక్క సూణి ఒరెన్‌రాజుఙ్‌ పోలిత మనాద్. ");
INSERT INTO kfc_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","లెక్క సుడ్ఃదెఙ్‌ మొదోల్‌స్తి వలె, పది వెయుఙ్‌ తాలందుఙ్‌ అప్ప లొస్తిక మర్‌జి సీదెఙ్‌ మన్ని ఒరెన్‌ వన్నిఙ్, వన్ని డగ్రు తత్తార్. ");
INSERT INTO kfc_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","వన్నిఙ్‌ అప్ప తీరిస్తెఙ్‌ అట్‌ఇతిఙ్, వన్నిఙ్‌ని వన్ని ఆల్సిఙ్, కొడొఃరిఙ్, మరి వన్నిఙ్‌ కల్గితి మనికెఙ్‌ విజు పొర్సి అప్ప తీరిస్‌అ ఇజి యాజుమాని ఆడ్ర సిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","అయ పణిమణిసి వన్ని ఎద్రు ముణుకుఙ్‌ ఊర్‌జి మాడిఃస్తాండ్రె, “నఙి సెమిస్‌అ నఙి మరి కండెక్‌ సమయం సిదా నాను అప్ప విజు మర్‌జి సీన’ ఇజి బతిమాల్‌తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","అయ ఎజుమాని పణిమనిసి ముస్కు కనికారం ఆజి, నీ అప్ప విజు తెవితాద్‌ ఇజి వన్నిఙ్‌ సొండ్రెఙ్‌ సెలవ సిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","గాని అయ పణిమనిసి వెల్లి వాజి సొన్సి మహివలె, వన్నిఙ్‌ వంద దినారమ్‌కు అప్ప మని, వన్నివెట కూడ్ఃజి పణికిజిని ఒరెన్‌ వన్నిఙ్‌ సుడ్ఃతాన్. వన్నిఙ్‌అస్తాండ్రె గొతిక పడిఃసి, “నీను నఙి అప్ప మన్ని డబ్బు మర్‌జి సిదా’, ఇజి బలవంతం కిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","వన్నివెట కూడ్ఃజి పణికినికాన్‌ఆతి అయ పణిమనిసి వన్ని ఎద్రు ముణుకుఙ్‌ ఊర్‌జి, “నఙి సెమిస్‌అ, నిఙి మరి కండెక్‌ సమయం సిదా? నిఙి సీదెఙ్‌ మన్ని అప్ప విజు నాను మర్‌జి సీన’, ఇజి బతిమాల్‌తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","గాని వాండ్రు అక ఒపుకొడ్‌ఏండ, అప్పు విజు మర్‌జి సీనిదాక వన్నిఙ్‌జేలుదు ఇడిఃస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","వరివెట కూడ్ఃజి పణికినికార్‌ సెగొండార్, యా జర్‌గితిక విజు సుడ్ఃతారె నండో బాద ఆతార్. వారు సొన్సి జర్గితిక విజు ఎజుమానిఙ్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","33","నస్తివలె అయ ఎజుమాని వన్నిఙ్‌ కూక్‌పిస్తాండ్రె, “మూర్‌కం మని పణిమనిసి, నీను నఙి బతిమాల్‌తిఙ్‌ నాను కనికారం ఆజి నిఙి సెమిసి, నీ అప్ప విజు తెవితాద్‌ ఇజి నిఙి వెహ్తిలెకెండ్‌ నీ వెట కూడ్ఃజి పణి కిని వన్నిఙ్‌ నీనుబా సెమిసి వన్ని ముస్కు కనికారం తోరిస్తెఙ్‌ గదె?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","నస్తివలె అయ ఎజుమాని వన్ని ముస్కు కోపం ఆతాండ్రె వాండ్రు అప్ప విజు మర్‌జి సీనిదాక వన్నిఙ్‌ హిమ్‌స కినివరిఙ్‌ ఒపజెప్తాండ్రె జెలిదు ఇడిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","మీరు మీ మన్సుదాన్‌ మీ తంబెరిఙవెట సెమిస్‌ఏండ మహిఙ పరలోకామ్‌దు మన్ని నా బుబ్బాతి దేవుణుబా యా లెకెండ్‌నె మీ లొఇ ఒరెన్‌ వెట కినాన్. ");
INSERT INTO kfc_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","యా మాటెఙ్‌వెహ్తి వీజితి వెనుక యేసు గలిలయ డిఃసి, యోర్‌దాన్‌గడ్డ అతాహ పడక మని యూదయ నాహ్కఙ్‌ సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","మంద లోకుర్‌ వన్ని వెనుక సొహార్‌. వాండ్రు అబ్బె వరి జబ్బుది వరిఙ్‌ నెగెండ్‌ కిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","సెగొండార్‌ పరిసయ్‌రు, వన్ని మాటెఙాణిఙ్‌ వన్నిఙ్‌ తప్ప అస్తెఙ్‌ ఇజి వన్ని డగ్రు వాతారె, “ఇని తపుబా తొఏండ ఒరెన్‌ వన్ని ఆల్సిఙ్‌ డిఃసి సీనిక దేవుణు మోసెఙ్‌ సిత్తి రూలుఙ్‌ వజ నాయమ్‌నా?”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","వాండ్రు వరిఙ్, “ముఙాహాన్‌ దేవుణు లోకురిఙ్‌ తయార్‌ కితివలె వరిఙ్‌ మొగ్గ కొడొఃని బోదెలి లెకెండ్‌ తయార్‌ కితాన్. ");
INSERT INTO kfc_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","అందెఙె మొగ్గ కొడొః వన్ని అయ్‌సి అప్పొసిరిఙ్‌ డిఃసి వన్ని ఆల్సి వెట కూడ్ఃజినాన్‌. వారు రిఏర్‌ ఉండ్రె ఒడొఃల్‌ ఆనార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","అందెఙె అబ్బెణిఙ్‌ అసి వారు రిఏర్‌ ఆఏండ ఉండ్రె ఒడొఃల్‌ ఆన మంజినార్. అందెఙె దేవుణు జత కుడుఃప్తి వరిఙ్‌ లోకుర్‌ కేట కిదెఙ్‌ ఆఏద్‌ ఇజి దేవుణు మాటదు రాస్తి మన్నిక మీరు ఎసెఙ్‌బా సద్విఇతిదెరా?”, ఇజి వరిఙ్‌ వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","వారు వన్నిఙ్, అక్క అయాలెకెండ్‌ మహిఙ, ఒరెన్‌ వన్ని ఆల్సిఙ్‌ డిఃస్తెఙ్‌ ఇహిఙ, ఉండ్రి విడ్డిః ఆకు రాసి సీజి దనిఙ్‌ డిఃస్తెఙ్‌ ఆనాద్‌ ఇజి మోసె ఎందనిఙ్‌ ఆడ్ర సిత్తాన్‌?”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","యేసు వరిఙ్, “మిఙి నస్సొ కటినమతి మన్సు మహిఙ్, మోసె అయ లెకెండ్‌ సెలవ సిత్తాన్‌ గాని ముఙాహన్‌ అసి అయ లెకెండ్‌ జర్గిఏతాద్. ");
INSERT INTO kfc_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","రంకు బూలాతిఙానె తప్ప మరి ఇనిదని వందిఙ్‌బా ఒరెన్‌ వన్ని ఆల్సిఙ్‌ డిఃసి మరి ఉండ్రి దనిఙ్‌ ఇడె ఆతిఙ వాండ్రు దనివెట రంకు బూలానికాన్‌ ఆజినాన్‌ ఇజి నాను మిఙి వెహ్సిన”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","వన్ని సిసూర్‌ వన్నిఙ్, “ఆల్సి మాసిర్‌ నడిఃమి సఙతిఙ్‌ యాలెకెండ్‌ మనాద్‌ ఇహిఙ, పెండ్లి ఆఏండ మంజినికాదె నెగెద్”, ఇజి వన్నిఙ్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","యేసు వరిఙ్, “మీరు వెహ్తి మాట విజేరె అస్తెఙ్‌ అట్‌ఏర్, గాని దేవుణు ఎయెరిఙ్‌ అయ లెకెండ్‌ సితాండ్రొ వారె కిదెఙ్‌ అట్‌నార్. ");
INSERT INTO kfc_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","సెగొండార్‌ ఆండేరెఙ్‌ లెకండ్‌నె అయ్‌సి పొటాదాన్‌ పుట్‌నార్. సెగొండారిఙ్‌ లోకుర్‌ ఆండేరెఙ్‌ లెకెండ్‌ కిజినార్. మరి సెగొండార్‌ దేవుణు ఏలుబడిః వందిఙ్‌ పెండ్లి ఆఎండ వరిఙ్‌ వారె ఆండేరెఙ్‌ ఆజి మంజినార్. ");
INSERT INTO kfc_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","నస్తివలె యేసు కికు ఇడ్జి పార్దనం కదెఙ్‌ ఇజి సెగొండార్‌ ఇజిరి కొడొఃరిఙ్‌ వన్ని డగ్రు తత్తార్. వన్ని సిసూర్‌ కొడొఃరిఙ్‌ తత్తి వరిఙ్‌ జటిఙ్‌ ఆజి గోల కిత్తార్. ");
INSERT INTO kfc_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","గాని యేసు, “యా ఇజిరి కొడొఃరిఙ్‌ నా డగ్రు రపీర్‌, వరిఙ్‌ అడ్డు కిమాట్. దేవుణు ఏలుబడిః కినిక నినివరిదినె”, ఇజి వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","వరి ముస్కు కికు ఇడ్జి పార్దనం కితి వెనుక వాండ్రు అబ్బెణిఙ్‌ సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ఇదిలో, ఒరెన్‌యేసు డగ్రు వాతండ్రె, “ఓ బోదకినికి, దేవుణు వెట ఎలాకాలం మంజిని బత్కుదు నాను మండ్రెఙ్‌ ఇహిఙ నాను ఇని నెగ్గి పణిఙ్‌కిదెఙ్”, ఇజి వన్నిఙ్‌ వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","యేసు వన్నిఙ్, “నెగ్గి పణిఙ వందిఙ్‌ ఎందనిఙ్‌ నీను నఙి వెన్‌బాజిని? నెగ్గికాన్‌ దేవుణు ఒరెండ్రె మనాన్. దేవుణు ఎలాకాలం మంజిని బత్కుదు నీను మండ్రెఙ్‌ ఇహిఙ, దేవుణు సితి ఆడ్రెఙ్‌ లొఙిజి మన్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","వాండ్రు, “ఇని ఆడ్రెఙ్‌?”, ఇజి వన్నిఙ్‌ వెన్‌బాతిఙ్‌ యేసు వన్నిఙ్, “సప్తెఙ్‌ ఆఎద్, రంకు బూలాదెఙ్‌ ఆఎద్, డొఙ కిమా, అబద్దమ్‌దిఙ్‌ సాస్యం వెహ్మ. ");
INSERT INTO kfc_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","అయ్‌సి అప్పొసిరిఙ్‌ గవ్‌రమ్‌దాన్‌ నెగెణ్‌ సుడ్ఃఅ. మరి నీను నిఙి ప్రేమిసినిలెకెండ్‌ మహివరిఙ్‌ ప్రేమిస్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","అందెఙె అయ దఙడాయెన్, “యాకెఙ్‌ విజు నాను కిజినె మంజిన. మరి ఇనిక నఙి తకు మనాద్‌?”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","యేసు వన్నిఙ్, “నీను పూర్తి నెగ్గికి ఆదెఙ్‌ కోరితిఙ, నీను సొన్సి నిఙి కల్గితి మనికెఙ్‌ విజు పొర్సి, బీదాతివరిఙ్‌ సీబాజి సిఅ. ఆహె కితిఙ పరలోకామ్‌దు నిఙి ఆస్తి కల్గిజి మంజినాద్. వెనుక నావెట రఅ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","అయ దఙడాఃయెన్‌ నండొ ఆస్తి కల్గిజి మనికాన్‌ కాక అయ మాట విహండ్రె ఇజిరి మొకొం అతాండ్రె సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","నస్తివలె వన్ని సిసూర్‌ఙ ‌సుడ్ఃజి, యేసు”, ఆస్తి మన్నికాన్‌ దేవుణు కిని ఏలు బడిఃదు సొండ్రెఙ్‌ గొప్ప కస్టం ఇజి నాను మిఙి నిజం వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","మరి నాను మిఙి వెహ్నిక ఇనిక ఇహిఙ, ఆస్తి మనికాన్‌ దేవుణు ఏలుబడిఃదు సొని దనిఙ్‌ ఇంక, ఒంటె దొపానం బొరొదాన్‌ డుఃగ్‌నిక సులు ఆనాద్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","సిసూర్‌ యా మాట విహరె నండొ బమ్మ ఆతారె, “దేవుణు రక్సిస్తి లెకెండ్‌ ఎయెన్‌ మండ్రెఙ్‌ అట్‌నార్‌?”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","యేసు వరిఙ్‌ సుడ్ఃజి, “యాక లోకాఙ్‌ అట్‌ఇకాదె, గాని దేవుణు విజు కిదెఙ్‌ అట్నాన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","పేతురు వన్నిఙ్‌ సుడ్ఃజి, “ఇదిలో మాపు విజు డిఃస్తాపె నీ వెట వాజినాప్, మఙి ఇనిక దొహ్‌క్నాద్‌లు?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","యేసు వరిఙ్, “యా లోకం మరి కొత్తాక ఆనివెలె లోకు మరిసి ఆతి నాను గొప్ప జాయ్‌మని గొప్ప సింహాసనమ్‌దు బసి ఇస్రాయేలుది పన్నెండు తెగ్గాతివరిఙ్‌ తీర్‌పు తీరిస్నివెలె, నా వెనుక వాతి మీరుబా, నావెట పన్నెండు గొప్ప సింహానమ్‌కాఙ్‌ బసి వరిఙ్‌ తీర్‌పు కినిదెర్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","మరి ఎయెర్‌బా నా వందిఙ్‌ వరి ఇల్లుజొల్లు, అన్నతంబెరిఙబ, బీబి తఙిసికఙ్‌బా, అయ్‌సి అప్పొసిరిఙ్‌బా, బూమిపుట, కొడొఃకొక్రరిఙ్‌బా డిఃస్తి సితిఙ నినివరిఙ్‌ యాకెఙ్‌ వంద వందుఙ్‌ దొహ్‌క్నె. దన్నివెట ఎలాకాలం మంజినిబత్కుబా దొహ్‌క్నాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","గాని మొదొహికార్‌ ఇజి ఒడ్ఃబిని నండొండార్‌ కడెఃవెర్‌దికార్‌ ఆనార్. కడెఃవెర్‌దికార్ ఇజి ఒడ్ఃబిని నండొండార్‌ మొదొహికార్‌ ఆనార్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“దేవుణు ఏలుబడిః కినిక ఇహిఙ, వన్ని ద్రాసటోటాదు పణికిదెఙ్‌ పణికిని వరిఙ్‌ కూక్తెఙ్‌ పెందాల నిఙ్‌జి వెల్లి సొన్సి మహి ఉండ్రి టోట యెజమానిఙ్‌ పోలిత మనాద్. ");
INSERT INTO kfc_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ఉండ్రి రోజు పణిదిఙ్‌ ఉండ్రి దినారం కూలి సీన ఇజి ఒపుకొటాండ్రె, వన్ని ద్రాక్స టోటాదు పణి కిదెఙ్‌వరిఙ్‌ పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","వెనుక అంబెలి వేలాదు వాండ్రు వెల్లి సొహివలె సత్తాదు ఇని పణి సిల్లెండ నిహిమని సెగొండారిఙ్‌ సుడ్ఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","వాండ్రు వరిఙ్, “మీరుబా నా ద్రాక్సటొటాదు పణిదిఙ్‌ సొండ్రు, మిఙి సరియాని కూలి సీన”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","వారు సొహార్‌. మరి వాండ్రు పన్నెండు గంటెఙ, మూండ్రి గంటెఙబా ఆహె కితాన్. ");
INSERT INTO kfc_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","మరి అయ్‌దు గంటెఙ సొహిఙ్‌ మరి సెగొండార్‌కాలి నిహిమనివరిఙ్‌సుడ్ఃతాన్. వాండ్రు వరిఙ్, “యా దినం విజు ఎందనిఙ్‌ మీరు ఇబ్బె సెడ్డిఃనె నిహిమహిదెర్‌?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","వారు వన్నిఙ్, “ఎయెర్‌బా ఇని పణిదిఙ్‌బా మఙి కూక్‌ఏతార్, అందెఙె”, ఇజి వెహ్తార్‌. వాండ్రు వరిఙ్‌ “మీరుబా నా ద్రాస టోటాదు పణిదిఙ్‌ సొండ్రు”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","పొదు ఆతివెలె అయ ద్రాస టోట ఎజుమాని పణి సూణి వన్నిఙ్‌ కూక్తాండ్రె, “పణికినివరిఙ్‌కూక్సి, కడఃవేరి వాతివరిబాణిఙ్‌ మొదొల్సి ముందాల వాతికార్‌ దాక వరిఙ్‌ కూలి సిఅ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","పొద్దు డిగ్నివలె పణిదిఙ్‌ వాతివరిఙ్‌ ఒరెన్‌ ఒరెన్‌ వన్నిఙ్‌ ఉండ్రి దినారం కూలి దొహ్‌క్తాద్. ");
INSERT INTO kfc_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ముందాల వాతికార్‌ మఙి లావ్‌ దొహ్‌క్నె, ఇజి ఒడ్ఃబితార్‌ గాని వరిఙ్‌బా ప్రతి ఒరెన్‌ వన్నిఙ్‌ ఉండ్రి దినారమ్‌నె కూలి దొహ్‌క్తాద్. ");
INSERT INTO kfc_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","అయాక దొహ్‌క్తివెలె వారు టోట ఎజుమానిఙ్‌ ఎద్రు మొరొ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","వారు, “కడెఃవెరిదు వాతికార్‌ ఉండ్రి గంటనె పణి కిత్తార్‌ గాని వెలార్‌ కస్టబడ్ఃజి విజు పణి కితిమని మఙి ఎందనిఙ్‌ నీను వరిఙ్‌ సమానం కితి?”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","వాండ్రు వరి లొఇ ఒరెన్‌ వన్నిఙ్, “బయి, నాను మిఙి ఇని అనెయం కిఏత. ఉండ్రి దినారమ్‌దిఙ్‌ పణి కిన ఇజి మీరు ఒపుకొటిదెర్‌ గదె?. ");
INSERT INTO kfc_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","మీ కూలి అసి మీరు సొండ్రు. మిఙి సితి లెకెండ్‌ కడెఃవెరిదు వాతివన్నిఙ్‌బా సీదెఙ్‌ నఙి ఇస్టం ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","నా డబుదాన్‌ నఙి ఇస్టమాతి లెకెండ్‌ కిదెఙ్‌ నఙి అక్కు సిలెదా? నాను వరిఙ్‌ ఓదరిసి సితి వందిఙ్‌ నీను గోస ఆజినిదెర్‌?”, ఇజి వెన్‌బతాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","అయా లెకెండ్‌నె కడఃవెరిదికార్‌ ఇజి ఒడ్ఃబిజినికార్‌ మొదొహికార్‌ ఆనార్, ముందాహికార్‌ ఇజి ఒడ్ఃబినికార్‌ కడెఃవెరిదికార్‌ ఆనార్.” ");
INSERT INTO kfc_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","యేసు యెరూసలేమ్‌దు సొన్సి మహివలె, వాండ్రు వన్ని పన్నెండు మణిసిర్‌ సిసురిఙ్‌ ఉండ్రి పడఃకాదు కూక్త ఒతాండ్రె వరిఙ్‌ ఈహు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","ఇదిలో మాటు యెరూసలేమ్‌దు సొన్సినాట్. అబ్బె లోకుమరిసి ఆతి నాను పెరి పుజెరిఙ, యూదురి రూలుఙ్‌ నెస్పిస్ని వరిఙ్‌ ఒపజెపె ఆనాలె. వారు నఙి సావుదిఙ్‌ సిక్స సీనార్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","మరి వారు నఙి వెకస్రి, కొర్‌డేఙాణిఙ్‌ డెఃయ్‌జి, సిలువ పోక్తెఙ్‌ యూదురు ఆఇ వరిఙ్‌ ఒపజెప్నార్‌లె. మూండ్రి రోస్కాఙ్‌ నాను మర్‌జి నిక్నాన్‌లె.” ");
INSERT INTO kfc_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","నస్తివలె జెబెదెయి మరిసిర్‌ అయ్‌సి వరి వెట యేసు డగ్రు వాతాదె ముణుకుఙ్‌ ఊర్‌జి మాడిఃసి, “సాయం కిఅ”, ఇజి వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","“నీను ఇనిక కోరిజిని?”, ఇజి వాండ్రు వెహ్తాన్‌. అందెఙె అది, “నీను రాజు వజ ఏలుబడిః కినివెలె, యా నా రిఎర్‌మరిసీర్‌ ఒరెన్‌ నీ ఉణెర్‌ పడఃకాదుని ఒరెన్‌ నీ డేబ్ర పడఃకాదు బసి మండ్రెఙ్‌ ఇజి నాను కోరిజిన”, ఇజి వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","యేసు, “నీను ఇనిక వెన్‌బాజినాదొ ఇజి నిఙి తెలిఏద్”, ఇజి వెహ్తండ్రె వరిఙ్, “నాను ఉండెఙ్‌మని గినాదిక ఉండెఙ్‌మీరు అట్‌నిదెరా?”, ఇజి వెహ్తాన్‌. వారు, “మాప్‌ ఉండెఙ్‌ అట్నాప్”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","యేసు వరిఙ్, “తప్‌ఏండ నాను ఉణి గినాదిక మీరు ఉణిదెర్, గాని నా ఉణెర్‌ పడఃకాదుని డేబ్ర పడఃకాదు బసె కిబిస్నిక నా కీదు సిల్లెద్‌, నా బుబ్బ కియుదాన్‌ ఎయేరిఙ్‌ తయార్‌ కిత మనాండ్రొ వరిఙ్‌ అక్కెఙ్‌ దొహ్‌క్న”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","మహి పది మన్సిర్‌ సిసూర్‌ వరి అయ్‌సి యేసుఙ్‌ లొస్తి అయ మాట విహరె రిఎర్‌ ముస్కు కోపం ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","యేసు వరిఙ్‌ విజేరిఙ్‌ కూక్తాండ్రె వరిఙ్, “యూదురు ఆఇవరి రాజుర్‌ వరి లోకుర్‌ ముస్కు అతికారమ్‌దాన్‌ మంజినార్. వరి పెరి అదికారిఙు వరిఙ్‌ మని అతికారమ్‌దాన్‌ లోకురిఙ్‌ అణసు తిగిజినార్‌ ఇజి మీరు నెస్నిదెర్‌ గదె? ");
INSERT INTO kfc_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","గాని మీరు వారు లెకెండ్‌ మండ్రెఙ్‌ ఆఎద్‌. గాని మీ లొఇ ఎయెర్‌బా పెరికాన్‌ ఆదెఙ్‌ ఇహిఙ, వాండ్రు మిఙి పణిమన్సి ఆదెఙ్‌వెలె. ");
INSERT INTO kfc_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","మరి ఎయెన్‌బా విజేరె ముస్కు పెరికాన్‌ఆదెఙ్‌ ఇజి కోరిజినికాన్, వాండ్రు మిఙి విజేరిఙ్‌ వెటి పణికి వనిలెకెండ్‌ ఆజి మండ్రెఙ్. ");
INSERT INTO kfc_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ఎలాగ ఇహిఙ లోకు మరిసి ఆతి నాను, విజేరె నఙి పణి కిపీర్‌ఇజి నాను రెఏతా, గాని పణి కిదెఙె వాత మన్న. మరి నండొండారిఙ్‌ బత్‌కిస్తెఙ్, వరిఙ్‌ విడుఃదల కిదెఙ్‌ వరి వందిఙ్‌ నా పాణం సీదెఙె నాను వాత మన”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","యేసుని వన్ని సిసూర్‌యెరికో పట్నమ్‌దాన్‌సొన్సి మహిఙ్, నండొ లోకుర్‌ వన్ని వెనుక సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ఇదిలో సరిపడకాదు బస్తిమని రిఎర్‌ గుడ్డిదికార్, యేసు అయా సరిదాన్‌ సొన్సినాన్‌ ఇజి వెహరె, “ప్రబువా, దావీదు మరిసి, మా ముస్కు కనికారం తోరిస్‌అ”, ఇజి డేల్‌సి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","లోకుర్‌ వరిఙ్” పలక్‌ మండ్రు’ ఇజి గోల కిత్తార్. గాని వారు, “ప్రబువా, దావీదు మరిసి మా ముస్కు కనికారం ఆఅ”, ఇజి మరి ఒదె డేల్సి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","యేసు నిహండ్రె వరిఙ్‌ కూక్తాన్. “నాను మిఙి ఇనిక కిదెఙ్‌ ఇజి మీరు కోరిజినిదెర్‌?”, ఇజి వరిఙ్‌ వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","“ప్రబువా మా కణ్కు సూణి లెకెండ్‌కిఅ”, ఇజి వారు వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","యేసు వరి ముస్కు కనికారం ఆతాండ్రె వరి కణకాఙ్‌ ముట్తాన్. వెటనె వారు సుడ్ఃదెఙ్‌ అట్తారె వన్ని వెట సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","వారు యెరూసలేము అందిని ముంఙాల, ఒలివ మరెక్‌ మని గొరొన్‌ ముస్కు మని బెత్‌పాగె ఇని నాటొ వాతార్. వాతిఙ్‌ యేసు వన్ని సిసూర్‌ రిఏరిఙ్‌ కూక్తాండ్రె ఈహు వెహ్తాన్‌. “మీ ఎద్రు మని నాటొ సొండ్రు. అందితిఙ సరి, తొహ్తి మన్ని ఉండ్రి గాడ్ఃదెఙ్‌ని దనివెట మని గాడ్ఃదె పిలాదిఙ్‌బా మీరు సూణిదెర్. వనకాఙ్‌ కుత్సి నా డగ్రు పేర్‌జి తగాట్. ");
INSERT INTO kfc_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ఎయెన్‌బా మిఙి ఇనికబా వెన్‌బాతిఙ వన్కాఙ్‌ ప్రబుఙ్‌ కావాలి ఇజి వన్నిఙ్‌ వెహ్తు. వెటనె వాండ్రు వనకాఙ్‌ మీ వెట పోక్నార్.” ");
INSERT INTO kfc_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","5","“ఇదిలోన్‌ గాడ్ఃదె ముస్కు ఎక్సి, సార్‌లిదాన్‌ నీ రాజు వాజినాన్. గాడ్ఃదె పిల్ల ఆతి ఇజిరి గాడ్ఃదె ముస్కు ఎక్తాండ్రె, నీ డగ్రు వాజినాన్‌ ఇజి సీయోను గాల్సి ఆతి దనిఙ్‌ వెహ్తు”, ఇజి దేవుణు ప్రవక్తవెట దేవుణు ముఙాల వర్గితి మాటెఙ్‌ పూర్తి ఆదెఙ్‌ యాకెఙ్‌ జర్‌గితె. ");
INSERT INTO kfc_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","యేసు వరిఙ్‌ వెహ్తి వజనె సిసూర్‌ సొహరె కిత్తార్. ");
INSERT INTO kfc_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","వారు గాడ్ఃదెని దని పిలదిఙ్‌ తత్తార్. వన్కాఙ్‌ ముస్కు వరి సాల్‌వెఙ్‌ పహ్తిఙ్, యేసు దని ముస్కు బస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","నండొండార్‌ వరి సాల్వెఙ్‌ సరి అందు పహ్తర్. మరి నండొండార్‌ మరెకాణి కొమెఙ్‌ కత్సి సరి అందు పహ్తర్. ");
INSERT INTO kfc_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","మంద లోకుర్‌ వన్ని ముందాల సొన్సి మహికార్, వన్ని వెనుక వాజి మహికార్, “దావీదు మరిసిఙ్‌ ఓసన్న! ప్రబు సిత్తి ఆతికారమ్‌దాన్‌ వాజినికాన్‌ పొగ్‌డెః ఆనికాన్‌ పరలోకామ్‌దు దేవుణుదిఙ్‌ ఓసన”, ఇజి వారు డేల్సి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","యేసు యెరూసలేం పట్నమ్‌దు వాతిఙ్, లోకుర్‌ విజెరె “వాండ్రు ఎయెన్‌?”, ఇజి బమ్మ ఆతారె ఒరెన్‌ మరి ఒరెన్ వెట వర్గిజి మహార్. ");
INSERT INTO kfc_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","“వీండ్రు గలీలయదు మన్ని నజరేతు ఇని నాటోణి ప్రవక్త ఆతి యేసు”, ఇజి వన్ని వెట మహి అయ మంద లోకుర్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","యేసు దేవుణు గుడిః లొఇ సొహాండ్రె, అబ్బె గుడిః అర్‌ఙుదు మహి కొణి వరిఙ్‌ పొర్ని వరిఙ్‌ విజేరిఙ్‌ వెల్లి పోక్తాన్. డబ్బు మారిసిని వరి బల్లెఙ్‌ని పావుర పొటిఙ పొర్నివరి పీటెఙ్‌ మహ్త విసీర్‌తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","వాండ్రు వరిఙ్, “నా ఇలు పార్దనం కిని ఇలు ఇజి కూకె ఆనాద్‌లె, ఇజి దేవుణు మాటదు రాస్త మనాద్‌ గాని మీరు దనిఙ్‌ డొఙారిఙ సాలం లెకెండ్‌ కితి మనిదెర్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","గుడ్డిదికార్, సొటాదికార్‌ దేవుణు గుడిఃదు వన్ని డగ్రు వాతిఙ్‌ వాండ్రు వరిఙ్‌ నెగెండ్‌ కితాన్. ");
INSERT INTO kfc_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","గాని వాండ్రు కితి బమ్మాతి పణిఙ సుడ్ఃజి, దేవుణు గుడిః అరఙుదు మని కొడొఃర్, “దావీదు మరిసిఙ్‌ ఓసన్న”, ఇజి డేల్సినిక విహరె, పెరి పుజెరిఙుని, యూదురి రూలుఙ్‌ నెస్పిస్నికార్‌ నండొ కోపం ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","వారు వన్నిఙ్, “యా కొడొఃర్‌వెహ్సినిక ఇనిక ఇజి నీను వెంజినిదా?”, ఇజి వెన్‌బాతార్. యేసు వరిఙ్, “ఓ వెంజిన, కొడొఃర్‌ని ఇజిరి కొడొఃరి వెయుదాన్‌ నీను పొగ్‌డిఃజిని మాటెఙ్‌ తయార్‌ కితి మన్ని’ ఇజి దేవుణు మాటదు రాస్తి మనిక మీరు ఎసెఙ్‌బా సద్‌విఇతిదెరా?”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","వాండ్రు వరిఙ్‌డిఃసి పట్నమ్‌దాన్‌ వెల్లి సొహాండ్రె బెతానియ ఇని నాటొ సొన్సి అయ రయ్తు అబ్బె మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","పెందల వాండ్రు మర్‌జి పట్నమ్‌దు సొన్సి మహిఙ్‌ వన్నిఙ్‌ బఙ కట్తాద్. ");
INSERT INTO kfc_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","సరి పడఃకాదు మని ఉండ్రి బొడెమరాన్‌ సుడ్ఃజి, మరాన్‌ డగ్రు వాతండ్రె సుడ్ఃతిఙ్‌ ఆకుఙ్‌ తప్ప మరి ఇనికెఙ్‌ తోర్‌ఉతె. వాండ్రు దనిఙ్‌ సుడ్ఃజి, “మరి ఎసెఙ్‌బా నీను కాయెఙ్‌ అస్‌ఇలె”, ఇజి వెహ్తాన్‌. వెటనె బొడెమరాన్‌ వహ్త సొహాద్. ");
INSERT INTO kfc_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","సిసూర్‌ అక్క సుడ్ఃతారె బమ్మ ఆతార్, “నిస్సొ బేగి బొడెమరాన్‌ ఎలాగ వహ్త సొహాద్‌?”, ఇజి వారు వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","యేసు వరిఙ్, “నాను మిఙి నిజం వెహ్సిన, మిఙి నమకం మంజి, మీ లొఇ అనుమానం సిల్లెండ మహిఙ, యా బొడెమరాన్‌దిఙ్‌ కితికదె ఆఎండ, యా గొరొతిఙ్‌ సుడ్ఃజి”, నీను ఇబ్బెణిఙ్‌ పెరె ఆజి సమ్‌దారమ్‌దు సొన్సి అర్‌అ’ ఇజి వెహ్తిఙ అయవజనె జర్గినాద్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","మిఙి నమకం మహిఙ మీరు పార్దనం కిజి ఇనిక లొస్నిదెరొ, అయాక మిఙి దొహ్‌క్నాద్‌లె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","యేసు దేవుణు గుడిఃదు సొహాండ్రె గుడిః అర్‌ఙుదు బోదకిజి మహివలె, పెరి పుజెరిఙుని లోకుర్‌ పెద్దెల్‌ఙ వన్ని డగ్రు వాతారె, “ఇని అతికారమ్‌దాన్‌ నీను యా పణిఙ్‌ కిజిని? ఎయెర్‌ నిఙి యా అతికారం సిత మనార్‌?”, ఇజి వన్నిఙ్‌ వన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","యేసు వరిఙ్, “నానుబా మిఙి ఉండ్రి మాట వెన్‌బాన. అయాక మీరు నఙి వెహ్తిఙ ఇని అతికారమ్‌దాన్‌ నాను యా పణిఙ్‌ కిజిన ఇజి నానుబా మిఙి వెహ్న. ");
INSERT INTO kfc_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","బాప్తిసం సీని యోహనుఙ్, బాప్తిసం సీదెఙ్‌ మని అతికారం ఎంబెణిఙ్‌ వాతాద్‌ దేవుణుబాణిఙ్‌నా, సిల్లిఙ లోకుర్‌ బాణిఙ్‌నా?”, ఇజి యేసు వరిఙ్‌ వెన్‌బాతాన్. “దేవుణుబాణిఙ్‌ వాతాద్‌’ ఇజి మాటు వెహ్తిఙ, మరి ఎందానిఙ్‌ మీరు వన్నిఙ్‌ నమ్మిఇతిదెర్‌? ఇజి మఙి వెన్‌బానాన్. ");
INSERT INTO kfc_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","గాని, యోహను ఒరెన్‌ దేవుణు ప్రవక్త ఇజి లోకుర్‌ విజేరె నమిజినార్. అందెఙె లోకుర్‌ బాణిఙ్‌ వాతాద్‌’ ఇజి వెహ్తెఙ్‌ మఙి తియెల్‌నె, ఇజి వరి లొఇ వారె వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","అందెఙె వారు, “మఙి తెలిఏద్”, ఇజి యేసుఙ్‌ మర్‌జి వెహ్తార్‌. నస్తివలె వాండ్రు, “ఇని అతికారమ్‌దాన్‌ యా పణిఙ్‌ కిజిన ఇజి నానుబా మిఙి వెహ్‌ఎ”, ఇజి వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“దిన్నివందిఙ్‌ మీరు ఇనిక ఒడ్ఃబిజినిదెర్‌? ఒరెన్‌వన్నిఙ్‌ రిఎర్‌ మరిసీర్‌ మహార్‌. వాండ్రు పెరివన్ని డగ్రు సొహాండ్రె, “మరిన్, నేండ్రు నీను ద్రాక్స టోటాదు సొన్సి పణి కిఅ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","వాండ్రు, “నాను సొన్‌ఎ, ఇజి మర్‌జి వెహ్తాన్‌. గాని వెనుక మన్సు మారిస్తాండ్రె సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","నస్తివలె అప్పొసి, కొగ్రిమరిసి డగ్రు సొహాండ్రె అయా వజనె వెహ్తాన్‌. వాండ్రు, ఒబా, నాను సొన”, ఇజి వెహ్తాన్‌‌ గాని సొన్‌ఏతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“యా రిఎర్‌ మరిసీర్‌ లొఇ అప్పొసి వెహ్తి వజ కితికాన్‌ ఎయెన్‌?”, ఇజి యేసు వరిఙ్‌ వెన్‌బాతాన్. వారు, “పెరికాండ్రె”, ఇజి వెహ్తార్‌. యేసు వరిఙ్‌ “పన్ను పెర్‌నికార్‌ని సానిదికెఙ్‌ మిఙి ఇంక ముఙాల దేవుణు కిని ఏలుబడిఃదు సొనార్‌లె ఇజి నాను మిఙి నిజం వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ఎందనిఙ్‌ ఇహిఙ యోహను వాతాండ్రె, నీతి నిజాయ్తిదాన్‌ బత్కిదెఙ్‌ ఇజి మిఙి సరి తోరిస్తాన్‌ గాని మీరు వన్నిఙ్‌ నమిఇతిదెర్. పన్ను పెర్నికార్‌ని సానిదికెఙ్‌ వన్నిఙ్‌ నమ్మితార్. అయాకెఙ్‌ సుడ్ఃతిఙ్‌బా మీరు మన్సు మరిసి మీరు కితి తపుఙ్‌ ఒప్పకొడిఃజి డిఃసి సీజి వన్నిఙ్‌ నమిఇతిదెర్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“మరి ఉండ్రి కత విండ్రు. బూమి మనికాన్‌ ఒరెన్‌ ఉండ్రి ద్రాసటోట ఉణుస్తాన్. దని సుటులం కోట తొహ్తన్. ద్రాక్స పట్కు రసం లాగ్‌దెఙ్‌ ఉండ్రి గానుగు తయార్‌ కిబిస్తాన్. కాప్‌కిదెఙ్‌ ఉండ్రి ఎత్తుమని ఇలుబా తయార్‌ కితాన్. వెనుక అయ ద్రాక్స టోట సెగొండార్‌ రయ్‌తురిఙ్‌ పాలిదిఙ్‌ సితాండ్రె పయనం కిజి మరి ఉండ్రి దేసెం సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","పట్కు పండ్ని కాలమ్‌దు వన్ని వంతుఙ్‌ లొస్తెఙ్‌ ఇజి వన్ని పణి మన్సిరిఙ్‌ పాలి అస్తి మని వరి డగ్రు పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","పాలి అస్తిమనికార్‌ వన్ని పణి మన్సిరిఙ్‌ అస్తారె ఒరెన్‌ వన్నిఙ్‌ డెయ్‌తార్, ఒరెన్‌ వన్నిఙ్‌ సప్తార్, మరి ఒరెన్‌ వన్నిఙ్‌ పణకాణిఙ్‌ డెఃయ్‌తార్. ");
INSERT INTO kfc_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","మరి, వాండ్రు ముఙాల పోక్తివరిఙ్‌ ఇంక నండొండార్‌ పణిమన్సిరిఙ్‌ పోక్తాన్. వరిఙ్‌బా పాలి అస్తిమనికార్‌ అయావజనె కితార్. ");
INSERT INTO kfc_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“నా మరినిఙ్‌ పోక్తిఙ వన్నిఙ్ ‌వారు గవ్‌రం సీనార్‌లె”, ఇజి వెహ్తండ్రె కడెఃవెరిదు వన్ని మరిసిఙ్‌ వరి డగ్రు పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","39","గాని పాలి అస్తిమనికార్‌ మరిసిఙ్‌ సుడ్ఃతారె, “వీండ్రు యా తోటాదిఙ్‌ అకు మనికాన్, రదు, మాటు వినిఙ్‌సప్సి యా టోట మా సొంతదిక కినాట్‌”, ఇజి వన్నిఙ్‌ అసి ద్రాక్స తోటదిఙ్‌ వెల్లి విసీర్‌తారె వన్నిఙ్‌ సప్తార్. ");
INSERT INTO kfc_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","అందెఙె అయా ద్రాస టోట ఎజుమాని వానివలె అయ పాలి అస్తిమనివరిఙ్‌ ఇనిక కినాన్‌? ఇజి వెన్‌బతాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","“అయా సెఇవరిఙ్‌ నండొ కటినమతి సావుదాన్‌ సప్నాన్. మరి పట్కు పండ్ని కాలమ్‌దు వన్నిఙ్‌ సరియాతి వందుఙ్‌ సీని రెయ్తురిఙ్‌ ద్రాస టోట పాలిదిఙ్‌ సీనాన్”, ఇజి వారు వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","యేసు వరిఙ్, “‘ఇలు తొహ్నికార్‌ నెక్తి పోక్తి పణుకునె, మూలాదిఙ్‌ బుర్ర పణకు ఆత మనాద్. యాక దేవుణు కీదాన్‌ జర్గితిక. యాక మా కణకెఙ బమ్మాతిక’, ఇజి దేవుణు మాటదు రాస్తి మనిక మీరు ఎసెఙ్‌బా సద్‌విఇతిదెరా?”. ");
INSERT INTO kfc_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","అందెఙె దేవుణు ఏలుబడిః కినిక మీ నడిఃమిహన్‌ లాగ్జి దనిఙ్‌ తగితి పట్కు సీని వరిఙ్‌ సీనాన్”, ఇజి నాను మిఙి వెహ్సన. ");
INSERT INTO kfc_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ఎయెన్‌బా యా పణుకు ముస్కు అర్తిఙ వాండ్రు ముకెఙ్‌ ఆనాన్. యా పణుకు ఎయెన్‌ ముస్కు అర్‌నాదొ వాండ్రు గుండ ఆనాన్‌”, ఇజి యేసు కత వెహ్సి వీజితాన్. ");
INSERT INTO kfc_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","యేసు వెహ్తి కతెఙ్‌ విహరె పెరి పుజెరిఙుని పరిసయ్‌రు, వరి వందిఙె వాండ్రు వెహ్సి మనాన్‌ ఇజి అర్దం కితార్. ");
INSERT INTO kfc_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","వారు వన్నిఙ్‌ కయ్‌దు కిదెఙ్‌ ఉండ్రి ఉపాయ్‌ సుడ్ఃతార్‌ గాని లోకుర్‌ విజేరె వన్నిఙ్‌ ఒరెన్‌ ప్రవక్త ఇజి నమ్మితి వందిఙ్‌ లోకురిఙ్‌ తియెలాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","యేసు మరి కతవజ వరిఙ్‌ వెహ్తాన్‌ ");
INSERT INTO kfc_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“దేవుణు కిని ఏలుబడిః ఇహిఙ వన్ని మరిసి పెండ్లిదిఙ్‌ విందు తయార్‌ కితిమని ఒరెన్‌ రాజుఙ్‌ పోలిత మనాద్. ");
INSERT INTO kfc_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","పెండ్లి విందుదిఙ్‌ రదు ఇజి ముఙాల వెహ్తి మహివరిఙ్‌ కూక్సి తగాట్‌ ఇజి వాండ్రు వన్ని పణిమన్సిరిఙ్‌ వరి డగ్రు పోక్తాన్. గాని వాదెఙ్‌ ఒప్‌ఏతార్. ");
INSERT INTO kfc_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","నస్తివలె వాండ్రు మరి సెగొండార్‌ పణిమన్సిరిఙ్‌బా పోక్తాండ్రె, “పెండ్లి విందుదిఙ్‌ రదు”, ఇజి ముఙాల వెహ్తిమహివరిఙ్, “నాను కోడ్డిఙ్, బలస్తి పడెఙ్‌ ఒహ్‌పిసి విజు తయార్‌ కిత మన. పెండ్లి విందుదిఙ్‌ మీరు రదు ఇజి వరిఙ్‌ వెహ్తు”, ఇజి వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","వారు పణిమన్సిర్‌ వెహ్తి మాటదిఙ్‌ కండెక్‌బా లస్యం కిఏండ, ఒరెన్‌ వన్ని మడిఃఙ సొహాన్‌ మరి ఒరెన్‌ వన్ని బేరమ్‌దిఙ్‌ సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","మహికార్‌ వన్ని పణిమన్సిరిఙ్‌ అస్తారె మర్యాద లాగ్జి సప్తార్. ");
INSERT INTO kfc_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","అయ రాజు నండొ కోపం ఆతాండ్రె వన్ని సయ్‌నమ్‌దిఙ్‌ పోక్సి వన్ని పణిమన్సిరిఙ్‌ సప్తివరిఙ్‌ కతిస్తాండ్రె, వరి పట్నమ్‌దిఙ్‌ సిసుదాన్‌ ముటిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","వెనుక వాండ్రు పెండ్లి విందు తయార్‌ అత మనాద్‌, వన్ని పణి మన్సిరిఙ్, “గాని ముఙాల పెండ్లి విందుదిఙ్‌ కూకెఆతి మహికార్‌ విందుదిఙ్‌ వాదెఙ్‌ తగ్నికార్‌ ఆఏర్. ");
INSERT INTO kfc_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","మీరు రస్త సహ్‌కాఙ్‌ సొన్సి మిఙి తోరినివరిఙ్‌ విజేరిఙ్” విందుదిఙ్‌ రదు’ ఇజి కూక్తు”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","అయ పణిమన్సిర్‌ రస్త సహ్‌కాఙ్‌ సొహరె వరిఙ్‌ తోరితి నెగ్గివరిఙ్, సెఇవరిఙ్‌ కుడుఃప్సి, వరిఙ్‌ తత్తెఙ్‌ అట్నివరిఙ్‌ విజేరిఙ్‌ తత్తార్. పెండ్లి విందు సమ్‌డ నిండ్రితాద్. ");
INSERT INTO kfc_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","నస్తివలె పెండ్లి విందుదిఙ్‌ వాతివరిఙ్‌ సుడ్ఃదెఙ్‌ రాజు వాతాన్. పెండ్లిసొక్క తొడుగిఏండ పెండ్లి విందుదిఙ్‌ అబ్బె బస్తిమని ఒరెన్‌ వన్నిఙ్‌ సుడ్ఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","రాజు వన్నిఙ్, “ఓ, కూలాయెన్, పెండ్లిసొక్క తొడుగిఏండ నీను ఎలాగ లొఇ వాతి?”, ఇజివెన్‌బాతాన్. వాండ్రు వర్గిఏండ అలేత మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","నస్తివలె రాజు, “వినిఙ్‌ కిక్కుకాల్కు తొహ్సి వెల్లి దూరమ మన్ని సీకటి బాడిఃదు విసీర్‌దు. అబ్బె వాండ్రు ఎలాకాలం అడఃబాజి, పల్కు కొహ్‌క్నిక మంజినాన్‌”, ఇజి వన్ని పణి మన్సిరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“కూకె ఆతికార్‌ నండొండార్‌ గాని, ఎర్లె ఆతికార్‌ కొకొండారె.” ");
INSERT INTO kfc_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","నస్తివలె పరిసయ్‌రు వెల్లి సొన్సి వాండ్రువర్గిని‌ మాటదాన్‌ యేసుఙ్‌ తప్ప అస్తెఙ్‌ ఇజి కుట్ర ఆజి మహార్. ");
INSERT INTO kfc_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","వారు వరి సిసూరిఙ్‌, హేరోదియరు జటుదివరివెట యేసు డగ్రు పోక్తార్. వారు సొన్సి, “బోద కినికి, నీను, మన్సు కద్లిఏండ దేవుణు సరివందిఙ్‌ నిజమ్‌దాన్‌ బోదిసిని నెగ్గికి ఇజి మాపు నెస్నాప్. నీను లోకురి ఎలాగ మర్తికార్‌ ఇజి మొకొం సుడ్ఃజి వరిఙ్‌ సర్ద కిబిస్తెఙ్‌ ఇజి వర్గినికి ఆఇ. ");
INSERT INTO kfc_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","అహిఙ కయ్‌సరుఙ్‌ పను సీనిక నాయమా? నీను ఇనిక ఒడ్ఃబిజిని? మఙి వెహ్‌అ”, ఇజి వన్నిఙ్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","యేసు వరి సెఇ బుద్దిదిఙ్‌ నెస్తాండ్రె, “వేసం కినికిదేరా! ఎందనిఙ్‌ నాను వహ్ని మాటదాన్‌ నఙి అస్తెఙ్‌ సుడ్ఃజినిదెర్‌? ");
INSERT INTO kfc_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","పన్ను సీని ఉండ్రి కాసు నఙి తోరిస్తు”, వారు ఉండ్రి దినారం వన్ని డగ్రు తతార్. ");
INSERT INTO kfc_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","“దిని ముస్కు మని బొమ్మ ఎయెర్‌ది? రాస్తిమని రాంత ఎయెర్‌ది?”, ఇజి వాండ్రు వరిఙ్, వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","వారు, “కయిసురుది”, ఇజి వెహ్తార్‌. నస్తివలె వాండ్రు, “కయిసరుది కయ్‌సరుఙ్‌ సీదు, దేవుణుది దేవుణుదిఙ్‌సీదు”, ఇజి వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","యా మాట వెంజి బమ్మ ఆతారె వారు వన్నిఙ్‌ డిఃస్త సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","సాతికార్‌ మర్‌జి నిఙ్‌నిక సిల్లెద్‌ ఇజి సదుకయ్‌రు వెహ్సినార్‌. వారు అయా రోజుదునె వన్నిడగ్రు వాజి ఈహు వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“బోదకినికి, ఒరెన్‌ కొడొఃర్‌ సిల్లెండ సాతిఙ వన్ని తంబెరి సాతివన్ని ఆల్సిఙ్‌ పెండ్లి ఆజి సాతివన్ని వందిఙ్‌ కొడొఃర్‌ పుటిస్తెఙ్‌ వలె ఇజి మోసె రాస్తి సితి రూలుదు మనాద్. ");
INSERT INTO kfc_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","మా నడిఃమి ఏడు గురు తంబేర్‌ఙు మహార్‌. పెరికాన్‌పెండ్లి ఆతాండ్రె సాతాన్. వన్నిఙ్‌ కొడొఃర్‌ సిల్లెర్‌ కక వన్ని తంబెరి సాతివన్ని ఆల్సిఙ్‌ఇడెః ఆతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","నడిఃపి వాండ్రుని కొగ్రి నడిఃపి, అయా లెకెండ్‌నె వీస్‌కొడొఃదాక విజేరె దనిఙ్‌పెండ్లి ఆజి సాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","కడెఃవేరిదు అయా బోదెల్‌బా సాతాద్. ");
INSERT INTO kfc_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","అహిఙ సాతి వరిబాణిఙ్‌ మర్‌జి నిఙ్‌ని వెలె యా ఏడుగురు లొఇ ఎయెరిఙ్‌ అది ఆల్సి ఆనాద్‌లె? ఇనిక ఇహిఙ బత్కిజిమహివలె అది ఏడుగురుదిఙ్‌బా ఆల్సి ఆత మహాద్‌ గదె?”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","యేసు వరిఙ్, “దేవుణు మాట ఇజి, మీరు నెస్‌ఇదెర్‌ దేవుణు సత్తు ఎస్సొ ఇజి మీరు నెస్‌ఇదెర్‌ అందెఙె అర్దం కిఏండ మీరు నండొ తప్పమాటెఙ్‌ వెహ్సినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ఎందనిఙ్‌ ఇహిఙ, సాతి విరబాణిఙ్‌ మర్‌జి నిఙ్‌ని వెలె ఎయెర్‌బా పెండ్లి ఆఏర్, పెండ్లిదిఙ్‌ సిఏర్. వారు పరలోకామ్‌ది దేవుణుదూతెఙ్‌ లెకెండ్‌ మంజినార్. ");
INSERT INTO kfc_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","సాతికార్‌ మర్‌జి నిఙ్‌ని వందిఙ్‌ దేవుణు మిఙి వెహ్తి మనిక మీరు ఎసెఙ్‌బా సద్విఇతిదెరా? నాను అబ్రాహము దేవుణు, ఇస్సాకు దేవుణు, యాకోబురి దేవుణు ఇజి వాండ్రు సాతి వరి దేవుణు ఆఏన్, బత్కిజిని వరి దేవుణునె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","అయ మాట విహరె వన్ని బోద వందిఙ్‌ లోకుర్‌ బమ్మ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","యేసు సదుకయ్‌రు వెయ్‌కు మూక్తాన్‌ ఇజి విహరె పరిసయ్‌రు కూడ్ఃజి వాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","36","వరి లొఇ ఒరెన్‌ దేవుణు రూలుఙ్‌ నెగెండ్‌ నెస్తికాన్, “ఓ బోదకినికి దేవుణు సితి ఆడ్రెఙ లొఇ పెరి ఆడ్ర ఇనిక?”, ఇజి వన్నిఙ్‌ పరీక్స కిదెఙ్‌ వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","యేసు వన్నిఙ్, “నీ పూర్తి మన్సుదాన్, నీ పూర్తి ఆత్మదాన్, నీ పూర్తి పాణమ్‌దాన్‌ నీ ప్రబు ఆతి దేవుణుదిఙ్‌ ప్రేమిస్తెఙ్. ");
INSERT INTO kfc_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","యాకాదె గొప్ప ముక్కెలమతికని, మరి మొదోహి ఆడ్ర. ");
INSERT INTO kfc_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","రుండి ఆడ్ర ఇనిక ఇహిఙ, “నీను నిఙి ప్రేమిస్ని లెకెండ్‌ మహి వరిఙ్‌బా ప్రేమిస్‌అ. ");
INSERT INTO kfc_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","దేవుణు సితి రూలుఙ్‌ని ప్రవక్తరు వర్గితి మాటెఙ పునాది ఆతిక యా రుండి ఆడ్రెఙ్”, ఇజి వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","పరిసయెరు కూడిఃతి మనివెలె యేసు వరిఙ్‌ సుడ్ఃజి, క్రీస్తు వందిఙ్‌ మీరు ఇనిక ఒడ్ఃబిజినిదెర్‌? వాండ్రు ఎయెర్‌ది కుటుమ్‌దికాన్‌ ఆనాన్‌? ఇజి వెన్‌బాతాన్. “వాండ్రు దావీదు రాజు తెగ్గదికాండ్రె”, ఇజి వారు వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","అయాలెకెండ్‌ మహిఙ మీరు నిజం వెహ్సినిదెర్‌. “నాను నీ పగాతి వరిఙ్‌ నీ పాదమ్‌క అడిఃగి ఇడ్నిదాక నీను నా ఉణెర్‌ పడఃకాదు బసి మన్‌అ. ఇజి ప్రబు నా ప్రబు వెట వెహ్తాన్‌. యా లెకెండ్‌ దేవుణు ఆత్మదాన్‌ దావీదు వర్గితివలె వన్నిఙ్‌ ఎలాగ ప్రబు ఇజి కూక్సినాన్‌? ");
INSERT INTO kfc_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","దావీదు వన్నిఙ్‌ ప్రబు ఇజి కూక్తిఙ్, వాండ్రు ఎలాగ వన్ని మరిసి ఆనాన్‌?”, ఇజి వాండ్రు వరిఙ్‌ వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ఎయెర్‌బా మర్‌జి ఉండ్రి మాటబా వెహ్తెఙ్‌ అట్‌ఏతార్. అయా రోజుదాన్‌ వన్నిఙ్‌ ఇనికబా వెన్‌బాదెఙ్‌ ఎయెరిఙ్‌బా దయ్‌రం సాల్‌ఏతాద్. ");
INSERT INTO kfc_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","నస్తివలె యేసు లోకురిఙ్‌ని వన్ని సిసూర్‌ఙ ‌ఈహు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","యూదురి రూలుఙ్‌ నెస్పిస్నికార్‌ని పరిసెయ్‌రుఙ్, ముందాల మోసెఙ్‌ మహి లెకెండ్‌ అతికారమ్‌దాన్‌ దేవుణు సితి రూలుఙ్‌ నెస్పిస్తెఙ్‌ అక్కు మనికార్. ");
INSERT INTO kfc_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","అందెఙె వారు మిఙి వెహ్ని విజు వనకాఙ్‌ లొఙిజి అయాలెకెండ్‌ కిదెఙ్‌వెలె. గాని వరి పణిఙ సుడ్ఃజి, వరి లెకెండ్‌ కిమాట్. ఎందనిఙ్‌ ఇహిఙ వారు వెహ్నర్‌ గాని అయ లెకెండ్‌ కిఏర్. ");
INSERT INTO kfc_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","లోకుర్‌ గుజమ్‌దు పిండ్‌దెఙ్‌ అట్‌ఇ నని బరుఙ్‌ తొహ్సి ఇడ్ని లెకెండ్‌ మని పెరి పణిఙ్‌ కిదెఙ్‌ ఇజి బలవంతం కినార్‌ గాని ఉండ్రి డెఃస్కదాన్‌ కద్లిస్తెఙ్‌ అట్ని సుల్‌కాని బరు లెకండ్‌మన్ని ఇజిరి సాయమ్‌బా వారు కిఏర్. ");
INSERT INTO kfc_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","లోకుర్‌సూణి వందిఙె వారు విజు పణిఙ్‌ కిజినార్. దేవుణు మాటెఙ్‌రాస్తి ఇట్తి ఇజిరి పెట్టెదిఙ్‌ పెరిక‌ కిజినార్. మరి వరి సొకెఙాణి అన్సుఙ్‌ పెరికెఙ్‌ కిజినార్. ");
INSERT INTO kfc_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","విందుదు వారు ముకెలమాతి బాడిఃఙ్‌ కోరిజినార్. యూదురు మీటిఙ్‌ కిని ఇల్కాఙ్‌ బస్తెఙ్‌ ఇజి వారు ముకెలమాతి బాడిఃఙ్‌ కోరిజినార్. ");
INSERT INTO kfc_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","సతెఙ నడిఃమి వారు లోకుర్‌ వెట మాడిఃసె ఆదెఙ్, బోదకినికార్‌ ఇజి కూకె ఆదెఙ్‌ కోరిజినార్. ");
INSERT INTO kfc_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","గాని మీరు ఇహిఙ, ‘బోదకినికి’ ఇజి కూకె ఆమాట్. ఎందనిఙ్‌ ఇహిఙ దేవుణు ఒరేండ్రె మి బోదకినికాన్‌ మీరు విజిదెరె అన్నతంబేర్‌ఙు. ");
INSERT INTO kfc_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","బూమి ముస్కు ఎయెరిఙ్‌బా బుబ్బ ఇజి పేరు ఇడ్ఃమాట్. దేవుణు ఒరేండ్రె మీ బుబ్బ. వాండ్రు పరలొకామ్‌దు మనాన్. ");
INSERT INTO kfc_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","మీరు ఎయిదెర్‌బా నెస్పిస్నికి ఇజి కూకె ఆమాట్. ఎందనిఙ్‌ ఇహిఙ క్రీస్తు ఒరేండ్రె మిఙినెస్పిస్నికాన్. ");
INSERT INTO kfc_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","మీ లొఇ విజేరిఙ్‌ ఇంక పెరికాన్, విజేరిఙ్‌ పణిమన్సి ఆదెఙ్‌వెలె. ");
INSERT INTO kfc_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ఎయెర్‌బా వన్నిఙ్‌ వాండ్రె పెరికాన్‌ కితిఙ వాండ్రు ఇజిరికాన్‌ ఆనాన్. ఎయెన్‌బా వన్నిఙ్‌ వాండ్రె తగె ఆతి మహిఙ వాండ్రు పెరికాన్‌ ఆనాన్. ");
INSERT INTO kfc_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","వేసం కినికిదెరాతి పరిసయ్‌రుఙ్‌ని ఊదురు రూలుఙ్‌ నెస్పిసినికిదెరా! అబయా, మిఙి ఎసోనొ కస్టమ్‌కు వానె. ఎందనిఙ్‌ఇహిఙ లోకుర్‌ దేవుణు ఏలుబడిఃదు సొన్‌ఎండ వరి ఎద్రు సేహ్లెఙ్‌ కెహ్సి పొక్సినిదెర్. మీరె సొన్‌ఇతిదెర్. సొండ్రెఙ్‌ సుడ్ఃజి మహి వరిఙ్‌ సరి సిఇతిదెర్. ");
INSERT INTO kfc_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","వేసం కినికిదెరాతి పరిసయ్‌రుఙ్‌ని యూదురు రూలుఙ్‌ నెస్పిసినికిదెరా, అబయా, మిఙి ఎసోనొ కస్టమ్‌కు వానె. మీరు సిగు సిల్లెండ రాండి బోదెకాఙ్‌ మొసెం కిజి మిఙి లాబం తప్పిసినిదెర్‌ మీరు ఎలాగమర్తికార్‌ ఇజి నస్తెఙ్‌ ఆఏద్‌ ఇజి మీరు లోకుర్‌ ఎద్రు లావ్‌ నీరిండ్ మన్ని పార్దనం కిజినిదెర్‌. దన్నివందిఙ్‌ మిఙి పెరి సిక్స వానాద్లె. ");
INSERT INTO kfc_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","వేసం కినికిదెరాతి పరిసయ్‌రుఙ్‌ని యూదురి రూలుఙ్‌ నెస్పిసినికిదెరా, అబయా! మిఙి ఎస్సొనొ కస్టమ్‌కు వానె. ఒరెన్‌ వన్నిఙ్‌ మీవెట కుడుఃప్తెఙ్‌ మీరు సమ్‌దరం డాట్సి బూమి విజు బూలాజినిదెర్. ఒరెన్‌ మీ వెట కూడిఃతిఙ, వన్నిఙ్‌ ఎల్లకాలం సిసు మంజిని బాడిఃదు సొండ్రెఙ్, మిఙి ఇంక రుండి వంతుఙ్‌ తగ్ని ననికాన్‌ తయార్‌ కిజినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","యూదురు రూలుఙ్‌ నెస్పినికెదెర్‌ ఆతి మీరు లోకురిఙ్‌ నెగ్గిసరి తోరిస్తెఙ్ మన్నికిదెర్‌, గాని మీరు మహివరిఙ్‌ సరి తోరిసిని గుడ్డిదికార్‌ లెకెండ్‌ మన్నిదెర్‌ అబయా! మిఙి ఎసొనొ కస్టమ్‌కు వానె. ఒరెన్‌ దేవుణు గుడిః తోడుః ఇజి పర్‌వణం కితిఙ, అయ పర్‌వణమ్‌దాన్‌ వాండ్రు తప్రె ఆదెఙ్‌ ఆనాద్. గాని దేవుణు గుడిః లొఇ మని బఙారం తోడుః ఇజి ప్రమాణం కితిఙ వాండ్రు అయ ఒపుమానమ్‌దాన్‌ తప్రె ఆదెఙ్‌ అట్‌ఏన్‌ ఇజి మీరు నెస్పిసినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","గుడ్డియాతి బుద్ది సిలికిదెరా! ఎమేణిక పెరిక? దేవుణు గుడిఃదు మని బఙారమ్‌నా, సిలిఙ బఙారమ్‌దిఙ్‌ దేవుణు వందిఙ్‌ కేట కిత్తక ఇజి కిజిని దేవుణుగుడిఃనా? ");
INSERT INTO kfc_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","మరి ఎయెన్‌బా సంద సుర్ని మాలి పీట తోడుః ఇజి ప్రమాణం కితిఙ, వాండ్రు అయ ప్రమాణమ్‌దాన్‌ తప్రె ఆదెఙ్‌అట్నాన్. గాని దని ముస్కు మని పూజ సితి వనకాఙ్‌తొడు అసి ప్రమాణం కితిఙ వాండ్రు అయ ప్రమాణమ్‌దాన్‌ తప్రె ఆదెఙ్‌ అట్‌ఏన్‌ ఇజి మీరు నెస్పిసినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","యూదురు రూలుఙ్‌ నెస్పిసిని గుడ్డిదికార్‌ లెకెండ్‌ మన్నికిదెరా! ఎమేణిక పెరిక? పూజ సితికాదా? సిల్లిఙ పూజ సితిదన్నిఙ్‌ దేవుణు వందిఙ్‌ కేట కిత్తిలెకెండ్‌ కిజిని సంత సుర్ని మాలి పీటనా? ");
INSERT INTO kfc_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","అందెఙె సంత సుర్ని మాలి పీట తోడుః అసి ప్రమాణం కినికాన్‌ సంద సుర్ని మాలి పీటదిఙ్‌ మరి దని ముస్కు మన్ని విజు వనకాఙ్‌ తోడు అసి ప్రమాణం కిజినాన్. ");
INSERT INTO kfc_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","మరి దేవుణు గుడిః తోడు అసి ప్రమాణం కినికాన్, దేవుణు గుడిఃదిఙ్‌ని దని లొఇ మంజిని విజు వనకాఙ్‌ని బాన్‌మంజిని దేవుణుదిఙ్‌ తోడు అసి ప్రమాణం కిజినాన్. ");
INSERT INTO kfc_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","పరలోకం తోడు ఇజి ప్రమాణం కినికాన్, దేవుణు బస్ని సింహాసనమ్‌దిఙ్‌ని దని ముస్కు బసి మంజిని దేవుణుదిఙ్‌బా తోడు అసి ప్రమాణం కిజినాన్. ");
INSERT INTO kfc_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","వేసం కినికిదెరాతి పరిసయ్‌రుఙ్‌ని యూదురి రూలుఙ్‌ నెస్పిస్నికిదెరా, అబయా మిఙి ఎసోనొ కస్టమ్‌కు వానె. మీరు పొదిన కుసాదాన్, సోపుదాన్, జిలకారదాన్‌ దేవుణుదిఙ్‌ దసమ్‌బాగం సీజినిదెర్. గాని నాయం, కనికారం, దేవుణు ముస్కు మని నమకం నన్ని దేవుణు సిత్తి రూలుదుమన్ని ముకెలమతి మాటెఙ్‌ మీరు నెక్సి పొక్సినిదెర్. రుండిబా ఉండ్రె లెకెండ్‌ కిజి మంజినిక ఇహిఙ ఒదె నెగెండ్ మహాద్‌ మరి. ");
INSERT INTO kfc_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","సరి తోరిస్ని గుడ్డిదికిదెరా! ఉణిదని లొఇ డోమెఙ్‌ అర్తి మహిఙ మీరు జాలిస్నిదేర్. గాని ఒంటె ననికెఙ్‌ అర్తిఙ అక్క నెస్తెఙ్‌ సిల్లెద్‌ ఇజి అయాలెకండ్‌నె డిఃఙ్‌నికిదెర్‌ మీరె. ");
INSERT INTO kfc_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","వేసం కిజినిదెర్‌ ఆతి, యూదురి రూలుఙ్‌ నెస్పిస్నికిదెరా, పరిసయెరుఙాండె, లోకుర్‌ ముస్కుహాన్‌ మిడిఃస్తి ఇడ్నిగిన్నెఙ్‌ని కుడుకెఙ్‌ లెకెండ్‌ మన్నికిదెర్. మీరు మీరుబా వెల్లిహాన్‌ సుడిఃతిఙ నెగ్గివరిలెకెండ్‌ తోరె ఆజినిదెర్‌. గాని మీ మన్సు నిండ్రు సెఇ బుద్దిఙ్‌ని సెఇఉదెసమ్‌కు, మరి నాను గణస్తికెఙ్‌ విజు నఙినె ఇజి ఒడ్ఃబిని వరిలెకెండ్‌నె. ");
INSERT INTO kfc_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","గుడ్డి ఆతి పరిసయ వాండ్రు ముఙాల మీరు మన్సు నెగ్గెండ్‌ కిదు, అయావెలె మీరు లొఇని వెల్లి మిడిస్తి మని కుడుకెఙ్‌ని గినెఙ్‌లెకండ్‌ ఆనిదెర్. ");
INSERT INTO kfc_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","వేసం కినికిదెరాతి, యూదురి రూలుఙ్‌ నెస్పిస్నికిదెరా, పరిసయురుఙాండె, వెల్లిదాన్‌ సుడ్ఃతిఙ మీరు గొప్ప సోకుమని సున్నం డెయ్‌తి మని దూకి ననికిదెరె! దూకి లొఇ సాతి వరి డుమ్కు మరి విజు సెఇకెఙ్‌ మన్నిలెకెండ్‌ మీరుబా మన్నిదెర్. ");
INSERT INTO kfc_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","అయా లెకెండ్‌నె మీరు వెల్లి సుడ్ఃతిఙ నాయం మనికిదెర్‌ ఇజి తోరె ఆజి నిదెర్. గాని లొఇ మీరు బక్తి మనికాప్‌ ఇజి పొఙిజి నికిదెర్, సెఇ బుద్దిదాన్‌ నిండ్రితి మన్నికిదెర్. ");
INSERT INTO kfc_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","వేసం కినికిదెరాతి యూదురి రూలుఙ్‌ నెస్పిస్నికిదెరా, పరిసయురుఙాండె, మిఙి ఎసోనొ కస్టమ్‌కు వానె. మీరు దేవుణు ప్రవక్తరు దూకిఙ ముస్కు సమాది తొహ్సి, నీతినిజాయ్తి మన్ని వరి సమాది ముస్కు సోకు కిజినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","అనిగొగొర్‌ కాలమ్‌దు మాపు మంజినిక ఇహిఙ, వారు దేవుణు ప్రవక్తరిఙ్‌ సప్తి మహివలె వరివెట మాపు కూడ్ఃఎతాప్‌ మరి ఇజి మీరు వెహ్సి మంజినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","అందెఙె దేవుణు ప్రవక్తరిఙ్‌ సప్తి మహి వరి మరిసీర్‌ ఇజి మీ మాటదానె మిఙి మీరె సాసెం వెహె ఆజినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","అందెఙె మీ అనిగొగొర్‌ కితి పాపమ్‌దు తకు మనిక మీరు పూర్తి కిదు. ");
INSERT INTO kfc_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","సరాస్‌ ననికిదెరా! సరాస్కు కొడొఃర్‌నని మీరు ఎలాగ ఎలాకాలం సిసు మంజిని బాడ్డిదాన్‌ తప్రె ఆనిదెర్. ");
INSERT INTO kfc_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","అందెఙె నాను, ప్రవక్తరుఙ్‌ని బుద్దిమని వరిఙ్, బోద కిని వరిఙ్‌ మీ నడిఃమి పోక్సిన. సెగొండారిఙ్‌ మీరు సప్నిదెర్, మరి సెగొండారిఙ్‌ మీరు సిలువ పొక్నిదెర్, మరి సెగొండారిఙ్‌ యూదురు మీటిఙ్‌ కిని ఇల్కాణిఙ్‌ కొర్‌డెఙణిఙ్‌ డెఃయ్‌జి ఉండ్రి పట్నమ్‌దాన్‌ మరి ఉండ్రి పట్నమ్‌దు ఉల్‌ప్నిదెర్. ");
INSERT INTO kfc_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","నీతి నిజాయ్తి మనికాన్‌ ఆతి ఏబెలు నలదాన్‌ మొదోల్‌సి, దేవుణు గుడిఃదిఙ్‌ని సంత సుర్ని మాలి పీటదిఙ్‌ నడిఃమి మీరు సప్తి మహి బెరాకియ మరిసి ఆతి జెకరియదాక, నీతి నిజాయ్తి మన్నికారాతి విజేరిఙ్‌ సప్సివరి నల బూమి కారిస్తి మన్ని వందిఙ్‌ సిక్స మీ ముస్కునె వానెలె. ");
INSERT INTO kfc_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","యా సిక్సెఙ్‌ విజు యా తరమ్‌ది వరి ముస్కునె వానె ఇజి నాను మిఙి నిజం వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ఓ యెరూసలేమా, యెరూసలేమా నీను ప్రవక్తరుఙ్‌ సప్నికి, నీ డగ్రు పోక్తివరిఙ్‌ పణకాణిఙ్‌ డెఃయ్‌నికి, ఉండ్రి కొరు దని పిలెకాఙ్‌ కుడుఃప్సి దని రెకెఙ అడ్గి ఇడ్ని లెకెండ్, నీ కొడొఃరిఙ్‌ కుడుఃప్తెఙ్‌ ఇజి నాను ఎసొడు సుట్కునో ఆస్స ఆత మన్న, గాని నిఙి ఇస్టం సిల్లెండ మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ఇదిలో దేవుణు వన్నిగుడిః డిఃసి సినాన్లె, అందెఙె అక్క కాలి మంజినాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ప్రబు సిత్తి అతికారమ్‌దాన్‌ ఆనికాన్‌” ఇజి నీను వెహ్నిదాక నఙి నీను మరి సుడ్ఃఇ, ఇజి నాను నిఙి నిజం వెహ్సిన.” ");
INSERT INTO kfc_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","2","యేసు దేవుణు గుడిఃదాన్‌ సోతాండ్రె దూరం సొన్సి మహిఙ్, సిసూర్‌ వన్ని డగ్రు వాతారె, దేవుణు గుడిః వందిఙ్‌ కూక్కుసాప్సి గొప్పఙ వర్గిజి మహార్‌. వాండ్రు వరిఙ్, “మీరు యాకెఙ్‌ విజు సుడ్ఃతిదెర్‌. గాని ఇక్క ఉండ్రి పణకు ముస్కు మరి ఉండ్రి పణకు నిల్సి మన్‌ఏండ ఆహె ఆనాద్‌లె, ఇజి నాను మిఙి నిజం వెహ్సిన”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","యేసు ఒలివ మరెక్‌ మని గొరొన్‌ముస్కు బస్తి మహివలె, మరి ఎయెర్‌ డగ్రుసిల్లెండ మహివలె, సిసూర్‌ వన్ని డగ్రు వాతారె, “యాకెఙ్‌ ఎసెఙ్‌ జర్గినె? నీను మర్‌జి వానిదనిఙ్, మరి యా తరమ్‌దిఙ్‌ ఆకర్‌దిఙ్‌ గుర్తుఙ్‌ ఇనికెఙ్‌? మఙి వెహ్‌అ”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","యేసు వరిఙ్‌ ఈహు వెహ్తాన్‌. “ఎయెన్‌బా నిఙి మోసెం కిఏండ జాగర్త సుడ్ఃజి మండ్రు. ");
INSERT INTO kfc_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ఎందానిఙ్‌ ఇహిఙ నండొండార్‌ వాజి, నా పేరు ఇడెః ఆజి, “నానె క్రీస్తు’ ఇజి వెహ్సి నండొండారిఙ్‌ మొసెం కినార్. ");
INSERT INTO kfc_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","మీరు విదెమ్‌కు వందిఙ్‌ వెనిదెర్‌లె. మరి విదెమ్‌కు వానెలె ఇజి సాటిస్నికబా వినిదెర్‌లె. అయావలె తియెల్‌ ఆఏండ మండ్రు. యాకెఙ్‌ విజు జర్గిదెఙ్‌వెలె. గాని యాక ఆక్కర్‌ ఆఏద్‌. ");
INSERT INTO kfc_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","లోకుర్‌ ముస్కు లోకుర్‌ని దేసెమ్‌కాఙ్‌ ముస్కు దేసెమ్‌కు పగ ఆజి మంజినె. అబ్బె ఇబ్బె నండొ నాహ్కఙ్‌ కరు, బూమి కద్లినికెఙ్‌ వానెలె. ");
INSERT INTO kfc_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","యాకెఙ్‌ విజు ఉండ్రి బోదెలి కీదు అస్తెఙ్‌ ముఙాల వాని నొప్పి మొదోల్‌స్తి లెకెండె. ");
INSERT INTO kfc_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","నస్తివలె‌ లోకుర్‌ మిఙి అసి తొహ్సి హిమ్సెఙ్‌ కిజి సప్తెఙ్‌ ఒపజెప్నార్‌లె. నా ముస్కు నమకం ఇట్తి వందిఙ్‌ లోకామ్‌దు మన్ని విజు జాతిదికార్‌ మిఙి ఇస్టం కిఏండ ఆనార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","నండొండార్‌ వరి నమకం డిస్న సీనార్‌లె. ఒరెన్‌ మరి ఒరెన్‌ వన్నిఙ్‌ మొసం కినాన్. ఒరెన్‌ మరి ఒరెన్‌ వన్నివెట పడిఃఏండ ఆనాన్. ");
INSERT INTO kfc_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","నండొండార్‌ డొఙ ప్రవక్తరు వాజి తప్ప బోదెఙ్‌ నెస్పిసి లోకురిఙ్‌ తప్ప సర్దు నడిఃపిసి, నండొండారిఙ్‌ మొసెం కినార్. ");
INSERT INTO kfc_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","దేసమ్‌ది రూలుఙ్‌ లొఙిఏండ బత్కిజినికార్‌. ఆజినిఙ్ లోకుర్‌ ప్రేమ సిల్లికార్‌ ఆనార్‌. ‌మహివరిఙ్‌ ప్రేమిస్ని ప్రేమ సిల్లెండాజి మంజినార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","గాని ఆక్కర్‌దాక కస్టమ్‌కు ఓరిసిని వన్నిఙ్‌ దేవుణు రక్సిస్నాన్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","దేవుణు ఏలుబడిః కిని వందిఙ్‌ సువార్త బూమి ముస్కు మని లోకాఙ్‌ విజు ఉండ్రి సాక్‌సెం లెకెండ్‌ వెహె అనాద్‌లె. నస్తివలె యా తరమ్‌దిఙ్‌ ఆక్కర్‌ వానాద్. ");
INSERT INTO kfc_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","ప్రవక్త ఆతి దానియేలువెట దేవుణు ముఙాల వర్గితి మహి లెకెండ్, “నాసనం కిని సెఇక ఆతిక’ దేవుణు గుడిఃదు నెగ్గి బాడిఃదు నిల్సి మంజినిక సూణివెలె (యాక సద్వినికాన్‌ నెసి అర్దం కిదెఙ్‌) అయ గడిఃయ వానాద్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","నస్తివలె యూదయ దేసమ్‌దు మంజినికార్‌ గొరొకాఙ్‌ ఉహ్‌క్తెఙ్‌ వలె. ");
INSERT INTO kfc_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","మిదె ముస్కు మంజినికాన్‌ ఇండ్రొణిఙ్‌ ఇనికబా వెల్లి ఒతెఙ్‌ ఇజి డిగ్దెఙ్‌ ఆఏద్‌. ");
INSERT INTO kfc_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","మడిఃఙ మంజినికాన్‌ వన్ని సాల్వెఙ్‌ ఒత్తెఙ్‌ ఇజి ఇండ్రొ వాదెఙ్‌ ఆఏద్‌. ");
INSERT INTO kfc_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","అయ దినమ్‌కు కొడొఃరిఙ్‌ పాలు ఉట్పిస్ని అయ్‌సికాఙ్‌, పొటాదు మన్ని బోదెకాఙ్ ఎస్సొనొ కస్టమ్‌కు మన్నికెఙె. ");
INSERT INTO kfc_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","21","అయాకెఙ్‌ ఉండ్రి పినికాలమ్‌దునో, రోమ్‌ని దినమ్‌దునో రెఏండ ఆపిద్‌ ఇజి పార్దనం కిజి మండ్రు. ఎందానిఙ్‌ ఇహిఙ, లోకం మొదోల్‌స్తి బాణిఙ్‌అసి ఏలుదాక రెఇ నని కస్టమ్‌కు వానె. అందెఙె అయా కస్టమ్‌కాణిఙ్‌ తప్రె ఆదెఙ్‌ ఇజి మీరు ఉహ్‌క్సి సొనిక ఉండ్రి పిన్నికాలమ్‌దునొ, విస్రాంతిదినమ్‌దునొ ఆఏండ మండ్రెఙ్‌ ఇజి పార్దనం కిజి మండ్రు. ");
INSERT INTO kfc_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","అయా కస్టమ్‌కు మన్ని దినమ్‌కు తక్కు కిదెఙ్‌ ఇజి దేవుణు ఒడ్ఃబిఎండ మహిఙ బూమి ముస్కు మన్నకాన్‌ ఎయెన్‌బా తప్రె ఆదెఙ్‌ అట్‌ఎన్. గాని దేవుణు ఎర్‌లిస్తి మన్ని వరి వందిఙ్‌ అయా దినమ్‌కు తక్కు కినాన్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","అయా కాలమ్‌దు ఎయెన్‌బా మిఙి, “ఇదిలో క్రీస్తు ఇబ్బె మనాన్‌”, సిల్లిఙ, “వాండ్రు అబ్బె మనాన్‌’ ఇజి వెహ్తిఙ వరి మాటెఙ్‌ అస్మాట్. ");
INSERT INTO kfc_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","నస్తివలె డొఙక్రీస్తుర్, డొఙ ప్రవక్తరు వాజి నండొ బమ్మాతి పణిఙ్, ముఙాల ఎసెఙ్‌బా తోఇ నని బమ్మాతి పణిఙ్‌ కిజి, అట్తిఙ దేవుణు ఎర్‌లిస్తి మన్నివరిఙ్‌బా మోసెం కిదెఙ్‌ సూణార్. ");
INSERT INTO kfc_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","జాగర్త మండ్రు! ఏలె అక్కెఙ్‌ ఇనిక్కెఙ్‌బా జర్గినె ముఙాలె నాను మిఙి వెహ్త మన. ");
INSERT INTO kfc_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","అందెఙె ఎయెన్‌బా, “ఇవిలోన్‌ వాండ్రు అబ్బె బిడిఃమ్‌బూమిదు ప్రాంతమ్‌దు మనాన్‌’ ఇజి వెహ్తిఙ్‌బా మీరు సొన్మాట్. సిల్లిఙ, “ఇవిలోన్‌ వాండ్రు ఇబ్బె గొనె మనాన్‌’ ఇజి వెహ్తిఙ్‌బా నమ్మిమాట్. ");
INSERT INTO kfc_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ఎందానిఙ్‌ ఇహిఙ, మిర్సినిక ఎలాగ తూర్‌పుదాన్‌ పడమార దాక తోరె ఆజినాదొ, అయలెకెండ్‌నె లోకు మరిసి ఆతి నాను వానివలెబా మంజినాద్, ");
INSERT INTO kfc_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","డేగెఙ్‌ వానివలె పినుగుఙ్‌ మంజినె ఇజి గుర్తు కిదెఙ్‌ అట్నిలెకెండ్‌ యేసు వానిదన్నిఙ్‌బా టెటాఙ్‌ తోర్ని గుర్తుఙ్‌ మంజినె. ");
INSERT INTO kfc_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","అయా కస్టమ్‌కు మని దినమ్‌కు వీజితివెటనె, “పొద్దు సీకటి ఆనాద్, నెల జాయ్‌ సిఏద్, ఆగాసమ్‌దు మని సుక్కెఙ్‌ రాల్నె. ఆగాసమ్‌దు మన్నిలావ్‌రకమ్‌ది సత్తు మన్నికెఙ్‌ కద్లినె. ");
INSERT INTO kfc_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","నస్తివలె లోకుమరిసి ఆతి నాను వానిదనిఙ్‌ గుర్తు ఆగాసమ్‌దు తొర్నాద్. బూమి ముస్కు మని నండొ తెగ్గెఙాణికార్‌ గుండె కొత్తె ఆజి అడఃబనార్. నస్తివలె లోకుమరిసి ఆతి నాను గొప్ప సత్తుదాన్‌ దేవుణు జాయ్‌దాన్‌ ఆగాసమ్‌దు మని మొసొపు ముస్కు వానిక వారు సూణార్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","జోడుబంకెఙ జాటుదాన్‌ నాను నా దూతెఙ్‌ పోక్న. వారు ఆగాసమ్‌దు యా కొసాదాన్‌ అయా కొసాదాక నాల్‌గి దిక్కుఙాణిఙ్‌ దేవుణు ఎర్‌లిస్తి మన్ని వరిఙ్‌ ఉండ్రెబాన్‌ కినార్. ");
INSERT INTO kfc_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ఇదిలో బొడె మరాన్‌దిఙ్‌ సుడ్ఃజి యాక మీరు నెస్తు. బొడె మరాన్‌ ఆకు రాల్జి సిగ్రిస్నివెలె, ఎండ కాలం డగ్రు ఆతాద్‌ ఇజి మీరు నెసినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","అయలెకెండ్‌నె మీరు యాకెఙ్‌ విజు జర్గినిక సూణివెలె, నాను దారబంద్రమ్‌దునె మన్న ఇజి మీరు నెస్తు. ");
INSERT INTO kfc_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","యాకెఙ్‌ జర్గినిదాక యా తరమ్‌దికార్‌ తప్‌ఏండ బత్కిజినె మంజినార్‌ ఇజి నాను మిఙి నిజం వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ఆగాసమ్‌ని బూమిబా సిల్లెండ ఆనె, గాని నా మాటెఙ్‌ఎసెఙ్‌బా అయాలెకెండ్‌ సొన్‌ఉ. ");
INSERT INTO kfc_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","అయ దినం వందిఙ్‌అయ గడియ వందిఙ్‌ ఎయెర్‌బా నెస్‌ఏర్. పరలోకామ్‌దు మన్ని బుబ్బాతి దేవుణు ఆఏండ దేవుణు దూతార్‌ గాని మరిసిబా నెస్‌ఏన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","నోవాహు కాలమ్‌దు ఎలాగ మనెనొ, అయలెకెండ్‌నె లోకుమరిసి ఆతి నాను వానికబా మంజినాద్. ");
INSERT INTO kfc_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","గడ్డ నిండ్రిని ముఙాల నోవాహు ఓడః లొఇ డుఃగితిమహి దినమ్‌ దాక లోకుర్‌ ఉణిజి, తింజి, పెండ్లి ఆజి, పెండ్లిదిఙ్‌ సీజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","బూమి విజు ముడిఃగ్జిని లెకెండ్‌ గడ్డ నిండ్రిజి విజేరిఙ్‌ పేర్జి ఒతిదాక, ఇనిక జర్గినాద్‌లె ఇజి వారు నెస్‌ఏండ మహార్‌. అయా లెకెండ్‌నె లోకుమరిసి ఆతి నాను వానివలెబా మంజినాద్. ");
INSERT INTO kfc_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","రిఎర్‌మడిఃఙ మంజినార్. ఒరెన్‌ వన్నిఙ్‌ డిఃసి ఒరెన్‌వన్నిఙ్‌ కూక్న ఒనాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","రుండి బోదెక్‌ ఉండ్రి జెత్త పణకుదు నూర్జి మంజినె. ఉండ్రి దనిఙ్‌డిఃసి ఉండ్రి దనిఙ్‌ కూక్న ఒనాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ఎమేణి దినమ్‌దు మీ ప్రబు వానాండ్రొ ఇజి మిఙి తెలిఏద్. అందెఙె మీరు జాగర్‌తదాన్‌ ఎద్రు సుడ్ఃజి మండ్రు. ");
INSERT INTO kfc_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","యాక మీరు అర్దం కిజి నెస్తు. ఎమేణి గడియాదు డొఃఙారి వానాన్‌ఇజి ఇండ్రొణి ఎజుమాని నెస్తిఙ, డొఙారి ఇండ్రొ డుఃగ్‌దెఙ్‌సరి సిఏండ తెలి మంజి సుణాన్. ");
INSERT INTO kfc_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","మీరు నా వందిఙ్‌ ఒడ్ఃబిఇ గడియాదు, లోకు మరిసి ఆతి నాను వాన. అందెఙె మీరు ఎస్తివలెబా తయార్‌ ఆజి మండ్రెఙ్‌ వెలె. ");
INSERT INTO kfc_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","బుద్దిమని నమిదెఙ్‌ అట్తిమని పణిమన్సి ఎయెన్‌? ఇండ్రొణి వరిఙ్‌ విజేరిఙ్‌ నెగెణ్‌ సుడ్ఃజి సరి ఆతి వేలాదు, వరిఙ్‌ సరి ఆతి బోజనం సీదెఙ్‌ ఇజి ఇండ్రొణి ఎజుమాని ఒపజెప్తి లెకెండ్‌ మన్నికాండ్రె బుద్ది మన్ని పణిమనిసి. ");
INSERT INTO kfc_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","అయ ఎజుమాని మర్‌జి వానివలె, వన్నిఙ్‌ ఒపజెప్తి లెకెండ్‌ఆయా పణిమన్సి కిజి మంజినిక ఇహిఙ అయ ఎజుమాని సుడ్ఃతిఙ అయ పణిమన్సిఙ్‌ నెగెద్. ");
INSERT INTO kfc_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","అయ ఎజుమాని వన్నిఙ్‌ కల్గితిమని విజు దనిఙ్‌ సూణికాన్‌ లెకెండ్‌ అయ పణిమనిసి కినాన్‌ ఇజి నాను మిఙి నిజం వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","“గాని అయ పణిమనిసి సెఇకాన్ ఆజి నా ఎజుమాని వాదెఙ్‌ నండొ ఆలస్యం ఆనాద్”, ఇజి అయ సెఇ పణిమన్సి వన్ని మన్సుదు ఆలొసనం కిజి వన్నివెట పణికిని వరిఙ్‌ డెఃయ్‌జి, మరి ఉణివరివెట కూడ్ఃజి ఉణిజి తింజి మంజినాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","వాండ్రు తొఇ దినమ్‌దు ఒడ్ఃబిఇ గడియాదు వన్ని ఎజుమాని వానాన్. ");
INSERT INTO kfc_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","అయ ఎజుమాని వన్నిఙ్‌కత్సి, బక్తి మనికాప్‌ ఇజి పొఙిజిని వరివెట వరివందిఙ్‌ తయార్‌ కిత్తిమన్ని బాడిఃదు పోక్నాన్. అబ్బె పల్కు కొహ్‌క్ని, అడఃబాజి మంజినార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","మరి దేవుణు ఏలుబడిః కినిక ఇహిఙ వరి నూనెఙాణి దీవెఙ్‌ అసి పెండ్లి దఙడః వన్నిఙ్‌ ఎద్రు సుడ్ఃదెఙ్‌ సొహిమహి పదిమన్సి విడ్డిః బోదెకాఙ్‌ పోలిత మనాద్. ");
INSERT INTO kfc_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","వినకాఙ్‌ లొఇ అయ్‌దుగురు బోదెక్‌ బుద్ది సిలికెఙ్, అయ్‌దుగురు బోదెక్‌ బుద్ది మనికెఙ్. ");
INSERT INTO kfc_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","అయ బుద్ది సిలికెఙ్‌ వనక దీవెఙ్‌అస్తె గాని నూనెఙ్‌ ఒఊతె. ");
INSERT INTO kfc_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","బుద్ది మనికెఙ్‌ వనక దీవెఙవెట సీసెఙ నూనెబా ఒతె. ");
INSERT INTO kfc_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","పెండ్లి దఙడఃయెన్‌ వాదెఙ్‌ ఆలస్యం ఆతిఙ్‌ అవిక్‌ విజు కొహొజి నిద్ర కిజి మహె. ");
INSERT INTO kfc_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","మదరెయ్తు, “ఇవిలొన్ పెండ్లి దఙడాఃయెన్, వన్నిఙ్‌ ఎద్రు సుడ్ఃదెఙ్‌ వాతి బోదెకాండె వెల్లి రదు”, ఇజి ఉండ్రి గగోలిదాన్‌జాటు వాతాద్. ");
INSERT INTO kfc_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","నస్తివలె బోదెక్‌ విజుండెక్‌ నిఙ్‌జి వన్కా నూనెఙాణి దీవెఙ్‌ సొడిఃతిఙ్‌ ఎకిసి నెగెండ్‌ కిత్తె. ");
INSERT INTO kfc_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","గాని అయ బుద్ది సిలికెఙ్, “మా దీవెఙ్‌ నమ్‌జి సొన్సినె. అందెఙె మీ నూనె లొఇ కండెక్‌ మఙిబా సిదాట్‌”, ఇజి బుద్ది మని వనకాఙ్‌ లొస్తె. ");
INSERT INTO kfc_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","అయావలె బుద్దిమని బోదెఙ్, “సిల్లె, సిత్తిఙ మఙిని మిఙి సాల్‌ఏండ ఆనాద్. అందెఙె మీరు పొర్నివరిబాన్‌ సొన్సి కొండు”, ఇజి వెహ్తె. ");
INSERT INTO kfc_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","అవి నూనె కొండెఙ్‌ సొన్సి మహిఙ్‌ పెండ్లి దఙడః వాతాన్. నస్తివలె తయార్‌ ఆతి మనికెఙ్‌ వన్నివెట పెండ్లి విందుదిఙ్‌ లొఇ సొహె. దని వెనుక సేహ్‌లెఙ్‌ కెహ్‌పె ఆతె. ");
INSERT INTO kfc_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","దన్ని వెనుక, మహి బుద్దిసిల్లి బోదెక్‌ వాజి, “బాబు, బాబు మఙి సెహ్ల రెఅ”, ఇజి కూక్తె. ");
INSERT INTO kfc_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","వాండ్రు వరిఙ్, “నాను మిఙి నిజం వెహ్సిన, నాను మిఙి నెస్‌ఎ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","నాను వాజిని రోజు గాని అయ గడిఃయబా మీరు నెస్‌ఇతిదెర్, అందెఙె మీరు తెలి ఆజి మండ్రు. ");
INSERT INTO kfc_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","మరి దేవుణు ఏలుబడిః కినిక ఇహిఙ ఒరెన్‌ దేసం సొండ్రెఙ్‌ ఇజి వన్ని పణిమన్సిరిఙ్‌ కూక్సి, వన్ని ఆస్తి వరిఙ్‌ ఒపజెప్తి వన్ని లెకెండ్‌ మనాద్. ");
INSERT INTO kfc_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","వండ్రు ఒరెన్‌ పణిమన్సిఙ్‌ అయ్‌దు తాలంతుఙ్. మరి ఒరెన్‌ వన్నిఙ్‌ రుండి, తాలంతుఙ్‌ మరి ఒరెన్‌ వన్నిఙ్‌ ఉండ్రి తాలంతుఙ్‌ యాలెకెండ్‌ ఒరెన్ ఒరెన్‌ దన్ని వెట పణికిదెఙ్‌ అట్ని లెకెండ్‌ వరిఙ్‌ సితాన్. వెనుక వాండ్రు పయ్‌నం కిజి దేసెం సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","అయ్‌దు తాలంతుఙ్‌ లొస్తికాన్‌ వెటనె సొన్సి వనకవెట బేరం కిజి మరి అయ్‌దు తాలంతుఙ్‌ గణస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","రుండి తాలంతుఙ్‌ లొస్తికాన్‌బా అయా లెకెండ్‌నె కిజి మరి రుండి గణస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","గాని ఉండ్రి తాలంతు లొస్తికాన్‌ సొహాండ్రె బూమిదు గాంద కారిసి వన్ని ఎజుమాని డబ్బు మూస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","లావ్‌కాలం సొహి వెనుక వరి ఎజుమాని మర్‌జి వాతండ్రె వరి సిత్తి డబ్బుఙాణిఙ్‌ వారు ఇనిక కిత్త మనార్‌ ఇజి సుడ్ఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","నస్తివలె అయ్‌దు తాలంతు లొస్తికాన్, మరి అయ్‌దు తాలందుఙ్‌ తతాండ్రె, “బాబు నీను నఙి అయ్‌దు తాలంతుఙ్‌ ఒపజెప్తి గదె, ఇదిలో అకెఙె ఆఏండ మరి అయ్‌దుబా నాను కుడుప్త”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","వన్ని ఎజుమాని వన్నిఙ్, “నమకం ఇడ్‌దెఙ్‌ అట్ని నెగ్గి పణిమన్సి, నీను నెగెండె కిత్తి. యా కండెక్‌బాన్‌ నిఙి నమిదెఙ్‌ అట్ని నని పణి నీను కిత్తి. అందెఙె నండొ వనకాఙ్‌ నాను నిఙి ఒపజెప్నాలె. నీను వాజి నీ ఎజుమానివెట సర్ద ఆజి మన్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","రుండి తాలంతుఙ్‌ లొస్తికాన్‌ వాతాండ్రె, “ఎజుమాని నీను నఙి రుండి తాలంతుఙ్‌ ఒపజెప్తి గదె, ఇదిలో అకెఙె ఆఏండ మరి రుండి తాలందుఙ్‌గణస్త”, ఇజి వన్నిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ఎజుమాని వన్నిఙ్, “నమకం ఇడ్‌దెఙ్‌ అట్ని నెగ్గి పణిమనిసి, నీను నెగెండె కిత్తి. యా కండెక్‌బాన్‌ నీను నమిదెఙ్‌ అట్ని నని పణి నీను కిత్తి. అందెఙె నిఙి నండో వన్కాఙ్‌ ఒపజెప్న. నీను వాజి నీ ఎజమాని వెట సర్ద ఆజి మన్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","నస్తివలె ఉండ్రి తాలంతు లొస్తికాన్‌ వాతాండ్రె, “బాబు నీను విత్‌ఇ బాడిదాన్‌ కొయ్‌నికి, మరి ఉణుస్‌ఇ బాడిఃదాన్‌ పంట కొయ్‌ని మూర్‌కతం మనికి ఇజి నాను నెస్త. ");
INSERT INTO kfc_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","అందెఙె నాను తియెల్‌ ఆజి బూమిదు గాంద కార్జి నీ డబ్బు డాప్త. ఇదిలో నీది, నీను లొస్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","అందెఙె వన్నిఙ్‌ సుడ్ఃజి అయ ఎజుమాని, “బదకమాతి సెఇ పణిమన్సి, నాను విత్‌ఇ బాడిదాన్‌ కొయ్‌నికాన్, ఉణుస్‌ఇ బాడిదాన్‌ పంట కొయ్‌నికాన్‌ ఇజి నీను నెస్తి? ");
INSERT INTO kfc_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","అహిఙ నా డబ్బు వడ్డి సీని సవ్‌కారిఙబాన్‌ నీను సీని మంజినిక ఇహిఙ నాను వాతివెలె వడ్డి కుడుఃప్సి నా డబ్బు నఙి దొహ్‌క్తాద్‌ మరి. ");
INSERT INTO kfc_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","అయ ఉండ్రి తాలంతు వన్నిబాణిఙ్‌ లాగ్‌జి పది తాలందుఙ్‌ మనివన్నిఙ్‌ సిఅ. ");
INSERT INTO kfc_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","నమిదెఙ్‌ అట్నికాన్‌ ఎయెండ్రొ, వన్నిఙ్‌ మరి లావ్‌ దొహ్‌క్నె. వరిఙ్‌ మరి నండొ కల్గిజి మంజినె. నమ్మిదెఙ్‌ అట్‌ఇ వన్ని బాణిఙ్‌, వన్నిఙ్‌ కల్గితిమన్ని ఇజిరికబా లాగె ఆనాద్. ");
INSERT INTO kfc_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","పణిదిఙ్‌ రెఇ యా పణిమన్సిఙ్‌ వెల్లి సీకటుదు విసీర్‌దు. అబ్బె పల్కు కొహ్‌క్నిఅడఃబాజి మంజినాద్. ");
INSERT INTO kfc_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","నస్తివలె యేసు ఈహు వెహ్తాన్‌. “లోకుమరిసి ఆతి నాను నా గొప్ప గవ్‌రమ్‌దాన్, నా విజు దూతెఙ తోడుః అసి వన్నివెలె, రాజు వజ ఏలుబడిః కిదెఙ్‌ దేవుణు మంజిని బాడిఃదు మంజిని గొప జాయ్‌దాన్‌, విజు దూతారిఙ్‌ నావెట తోడు అసి వానివలె, రాజువజ ఏలుబడిః కిదెఙ్‌ పరలోకమ్‌దు మంజిని గొప్ప జాయ్‌ మన్ని నా సింహాసనమ్‌దు బసి మంజిన. ");
INSERT INTO kfc_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","నస్తివలె బూమి ముస్కు మని లోకుర్‌ విజెరె నా ఎద్రు కూడ్ఃజి వానార్. గొర్రెఙ్‌ మేప్ని గవుడుఃయెన్‌ ఎలిటి గొరెఙాణిఙ్‌ మెండ గొర్రెఙ ఎర్‌లిసినిలెకెండ్‌ నాను లోకాఙ్‌ ఒరెన్‌ ఒరెన్‌ వన్నిఙ్‌ ఎర్లిస్నాలె. ");
INSERT INTO kfc_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","నాను ఉణెర్‌పడఃక మెండ గొర్రెఙ, డేబపడఃక ఎలిటి గొర్రెఙ నిల్‌ప్నాలె. ");
INSERT INTO kfc_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","రాజు ఆతి నాను నా ఉణెర్‌ పడఃక మని వరిఙ్‌ సుడ్ఃజి, “నా బుబ్బాతి దేవుణు సిజిని దీవనమ్‌కు మంజి వన్నిఙ్‌ సెందితికిదెరా, లోకం పుట్తి బాణిఙ్‌ అసి దేవుణు మీ వందిఙ్‌ తయార్‌ కితిమన్ని దేసం మీ సొంత కిజి మండ్రు. ");
INSERT INTO kfc_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ఎందానిఙ్‌ ఇహిఙ, నఙి బఙ కట్తిఙ్‌ మీరు బోజనం సితిదెర్, ఏహ్కి కట్తిఙ్‌ ఏరు సితిదెర్, నాను ఆఇకాన్‌ ఆతిమహిఙ్‌ నఙి డగ్రు కితిదెర్. ");
INSERT INTO kfc_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","నాను డుమ్‌డ ఆతిమహిఙ్‌ నఙి సొక్కెఙ్‌ సితిదెర్. జబుదాన్‌ మహిఙ్‌ నఙి నెగెండ్‌ సుడ్ఃతిదెర్, నాను జెలిదు మహివలె సుడ్ఃదెఙ్‌ వాతిదెర్, ఇజి వెహ్నన్. ");
INSERT INTO kfc_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","నస్తివలె దేవుణుదిఙ్‌ లొఙితిమహి నీతినిజాయ్తిమన్నికార్ ఆతి వారు, “ప్రబువా, ఎస్తివలె నిఙి బఙదాన్‌ సుడ్ఃతిఙ్‌ నిఙి బోజనం సితాప్‌? ఎస్తివలె ఎహ్కి కట్తిఙ్‌ మాపు నిఙి ఏరు సితాప్‌? ");
INSERT INTO kfc_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ఎస్తివలె ఆఇకి ఆతిమహిఙ్‌ సుడ్ఃజి నిఙి డగ్రు కితాప్‌? ఎస్తివలె డుమ్‌డ ఆతి మహిక సుడ్ఃజి నిఙి సొక్కెఙ్‌ సితాప్‌? ");
INSERT INTO kfc_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ఎస్తివలె నీను జబుదాన్‌ మహిక, జెలిదు మహిక సుడ్ఃజి నీ డగ్రు వాతాప్‌?”, ఇజి వన్నిఙ్‌ వెన్‌బానార్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","నస్తివలె రాజుఆతి నాను, “నా తంబెరిఙ ఆతివరి లొఇ ఇజిరికాన్‌ ఆతి ఒరెన్‌వన్నిఙ్‌ మీరు ఇనిక కితిదెరొ, అయాక మీరు నఙి కిత్తిదెర్, ఇజి నాను నిఙి నిజం వెహ్సిన”, ఇజి వరిఙ్‌ వెహ్న. ");
INSERT INTO kfc_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","నస్తివలె వాండ్రు డేబ్ర పడఃకాదు మని వరిఙ్‌ సుడ్ఃజి, “సయెప్‌ పొందితికిదెరా, నా డగ్రహాన్ సొండ్రు, సయితానుఙ్‌ని వన్ని దూతర్‌ వందిఙ్‌ తయార్‌ కితి మని ఎలాకాలం సిసు మంజిని బాడిఃదు సొండ్రు. ");
INSERT INTO kfc_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ఎందనిఙ్‌ ఇహిఙ, నాను బఙ సాత, గాని మీరు నఙి బోజనం సిఇతిదెర్. ఎహ్కి కట్తిఙ్‌ ఉండెఙ్‌ ఇనిక సిఇతిదెర్. ");
INSERT INTO kfc_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ఆఇకానాతి మహిఙ్‌ మీరు నఙి డగ్రు కిఇతిదెర్. డుమ్‌డ ఆతిమహిఙ్‌ మీరు నఙి సొక్కెఙ్‌ సిఇతిదెర్. జబ్బుదాన్‌ మహివలె జెలిదు మహివలె మీరు నఙి సుడ్ఃదెఙ్‌ రెఇతిదెర్”, ఇజి వెహ్న. ");
INSERT INTO kfc_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","వారుబా వన్నిఙ్, “ప్రబువా ఎస్తివలె నీను బఙదాన్‌మహిక, ఎహ్కిదాన్‌మహిక, ఆఇకి ఆతి మహిక, డుమ్‌డ మహిక, జబుదాన్‌మహిక, కయ్‌దు మహిక సుడ్ఃజి నిఙి సాయం కిఏతాప్‌?”, ఇజి వెన్‌బానార్. ");
INSERT INTO kfc_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","నస్తివలె నాను, “యా ఇజిరి వరి లొఇ ఒరెన్‌ వన్నిఙ్‌ ఇనిక మీరు కిఇతిదెరొ, అయాక నఙిబా మీరు కిఇతిదెర్”, ఇజి వరిఙ్‌ వెహ్న. ");
INSERT INTO kfc_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","నస్తివలె వారు ఎలాకాలం మంజిని సిక్సాదు సొనార్‌లె, గాని దేవుణుదిఙ్‌ లొఙితికార్‌ ఎల్లకాలం మంజిని బత్కుదు సొనార్.” ");
INSERT INTO kfc_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","2","యేసు యాకెఙ్‌ విజు వెహ్తి వీజితి వెనుక వన్ని సిసూర్‌ఙ ‌సుడ్ఃజి, “రుండి రోస్కు వెనుక పస్క పండోయ్‌ వాజినాద్‌ ఇజి మీరు నెస్నిదెర్. నస్తివలె లోకు మరిసి ఆతి నాను సిలువ పోకె ఆదెఙ్‌ ఇజి ఒపజెపె ఆనాలె”, ఇజి వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","నస్తివలె పెరి పుజెరిఙుని లోకురి పెద్దెల్‌ఙ విజేరె, విజేరె విజు పుజెరిఙ ముస్కు పెరి పుజెరి ఆతి కయప ఇండ్రొ కూడ్ఃజి వాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","యేసుఙ్‌ ఎలాగబా ఉపాయ్‌ కిజి అసి సప్తెఙ్‌ ఇజి అబ్బె వారు ఉండ్రి ఆలోసనం కితార్. ");
INSERT INTO kfc_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“మాపు ఏలు వన్నిఙ్‌ అస్తిఙ లోకుర్‌ వెట గొడఃబ కినార్లె, అందెఙె యా పండొయ్‌దు పోని”, ఇజి వారు వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","7","యేసు బెతానియ ఇని నాటొ ముఙాల కుస్టురోగమ్‌దాన్‌ మహి సీమోను ఇండ్రొ వాతిఙ్, అబ్బె వాండ్రు బోజనమ్‌దిఙ్‌ బస్తాన్. నస్తివలె ఉండ్రి బోదెలి నూన్నాఙ్‌ పణుకుదాన్‌ తయార్‌ కిత్తి ఉండ్రి సీసాదు, నండొ విలువమని, నండొ వాసనం మని నూనె ఉండ్రి పెరి సీస తత్తాదె వన్ని బుర్ర ముస్కు వాక్తాద్. ");
INSERT INTO kfc_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","9","సిసూర్‌ అక్క సుడ్ఃజి కోపం ఆతారె, “ఎందనిఙ్‌ యా ణిదిఙ్‌రెఇ ణి? యాక నండొ డబ్బుదిఙ్‌ పొర్‌సి, అయ డబ్బు బీదవరిఙ్‌ సీదెఙ్‌ ఆనాద్‌ గదె?”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","యేసు అక్క నెస్తాండ్రె, “యా బోదెలి నా వందిఙ్‌ ఉండ్రి నెగ్గి పణి కితాద్‌ మీరు ఎందనిఙ్‌ దన్నిఙ్‌ అర్ల కిజినిదెర్‌? ");
INSERT INTO kfc_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","బీదాదికార్‌ మీవెట ఎస్తివలెబా మంజినార్. గాని నాను ఎలాకాలం మీ వెట మన్‌ఎ. ");
INSERT INTO kfc_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","నఙి మూస్ని వందిఙ్‌ తయార్‌ కిత్తి లెకెండె యా బోదెలి యా నూనె నా ఒడొఃల్‌ ముస్కు వాక్తాద్. ");
INSERT INTO kfc_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","యా బూమి ముస్కు ఎంబెబా యా దేవుణు ఏలుబడిః కిని వందిఙ్‌ సువార్త సాటిస్నివెలె అది కితి యా పణి దన్నిఙ్‌ ఎత్తుకిత్తి లెకెండ్‌ సాటిసి మంజినాద్‌లె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","15","నస్తివలె పన్నెండు మణిసిర్‌ సిసూర్‌ లొఇ ఒరెన్‌ ఇస్కరియోతు యూద ఇనికాన్‌ పెరి పుజెరిఙ డగ్రు సొహాండ్రె, “నాను యేసుఙ్‌ మిఙి ఒపజెప్తిఙ నఙి ఇనిక సీనిదెర్‌?”, ఇజి వెన్‌బాతాన్. అందెఙె వారు ముప్పయ్‌ వెండి రూపయ్‌ఙు తూస్తారె వన్నిఙ్‌ సిత్తార్. ");
INSERT INTO kfc_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","అబ్బెణిఙ్‌ అసి యూద యేసుఙ్‌ వరిఙ్‌ ఒపజెప్తెఙ్‌ ఉండ్రి అవ్‌కాసం సుడ్ఃజి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","పులాఙ్‌ సిల్లి రొట్టెఙ్‌ తయార్‌ కిని పస్క పండొయ్‌ది మొదొహి దినమ్‌దు వన్ని సిసూర్‌ యేసు డగ్రు వాతారె, “పస్క ఉండెఙ్‌ నీ వందిఙ్‌ మాపు ఎంబె తయార్‌ కిదెఙ్, ఇజి నీను కోరిజిని?”, ఇజి వన్నిఙ్‌ వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","వాండ్రు వరిఙ్, “మీరు పట్నమ్‌దు పలానివన్నిబాన్‌ సొన్సి, నా సమయం డగ్రు ఆతాద్. నా సిసూర్‌ వెట కూడ్ఃజి నీ ఇండ్రొ పస్క పండొయ్‌ కిదెఙ్‌ ఇజి బోదకినికాన్‌ వెహ్సినాన్, ఇజి వన్నిఙ్‌ వెహ్తు”, ఇజి వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","వన్ని సిసూర్‌ సొన్సి యేసు వరిఙ్‌ వెహ్తి లెకెండ్‌నె పస్క పండొయ్‌దిఙ్‌ తయార్‌ కిత్తార్. ");
INSERT INTO kfc_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","పొద్దు ఆతివెలె వన్ని పన్నెండు మన్సి సిసూర్‌ వెట బోజనమ్‌దిఙ్‌ బస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","వారు బోజనం కిజి మహివలె వాండ్రు, “మీ లొఇ ఒరెన్‌ నఙి ఆఇవరి కీదు ఒపజెప్నాన్‌లె, ఇజి నాను మిఙి నిజం వెహ్సిన”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","వారు విజేరె నండొ దుకం ఆజి ప్రతి ఒరెన్ ఒరెన్‌, “ప్రబువా, నిజమె నాను ఆఏ గదె?”, ఇజి వన్నిఙ్‌ వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","యేసు, “నావెట గినెదు కియు ముడుఃక్నికాన్‌ ఎయెండ్రొ వాండ్రె నఙి ఒపజెప్నికాన్. ");
INSERT INTO kfc_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","లోకుమరిసి ఆతి నా వందిఙ్‌ దేవుణు మాటదు రాస్తిమహి లెకెండ్‌ నాను సొనాలె, గాని లోకు మరిసి ఆతి నఙి ఎయెన్‌ ఒపజెప్నాండ్రొ వన్నిఙ్‌ కస్టమ్‌నె. వాండ్రు పుట్‌ఏండ మంజినిక ఇహిఙ వన్నిఙ్‌ ఎస్సొనొ బాగ మహాద్‌ మరి”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","వన్నిఙ్‌ ఒపజెప్ని యూద, “బోదకినికి నాను ఆఏ గదె?”, ఇజి వెన్‌బాతాన్. యేసు, “ఒఒ నీనె”, ఇజి మర్‌జి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","వారు బోజనం కిజి మహిఙ్‌ యేసు ఉండ్రి రొట్టె అస్తాండ్రె దేవుణుదిఙ్‌ వందనమ్‌కు వెహ్సి, అయాక రుక్సి, వన్ని సిసూర్‌ఙ సితాండ్రె, “మీరు యాక లొసి తిండ్రు, యాక నా ఒడొఃల్”, ఇజి వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","మరి వాండ్రు గిన్న అసి దేవుణుదిఙ్‌ వందనమ్‌కు వెహ్సి, అయాక వరిఙ్‌ సీజి, “దిన్ని లొఇ మనిక విజేరె ఉండు. ");
INSERT INTO kfc_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","యా గిన్నాదు మన్నిక నా నల, నండొండారిఙ్‌ వరి పాపమ్‌కు సెమిస్తెఙ్‌ ఇజి కారిసిని నా నల. ఇక్కదె దేవుణు నా నలదాన్‌ కిజిని ఒపుమానం. ");
INSERT INTO kfc_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","నా బుబ్బాతి దేవుణు కిని ఏలుబడిఃదు మరి మీ వెట కొత్తాఙ్‌ ఉణిదాక ద్రాక్స పట్కు రసం మరి ఎసెఙ్‌బా నాను ఉణ్‌ఎలె, ఇజి నాను మిఙి వెహ్సిన”, ఇజి వెహ్తాన్‌‌ ");
INSERT INTO kfc_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","మరి, ఉండ్రి పాట పార్తారె వారు ఒలివ మరెక్‌ మని గొరొన్‌ ముస్కు సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","నస్తివలె యేసు వరిఙ్‌ సుడ్ఃజి, “గొర్రెఙ్ అడినివన్నిఙ్‌ నాను కత్నాలె, గొర్రెఙ్‌ మంద సెదరినె సొనెలె, ఇజి దేవుణు మాటదు రాస్తి లెకెండ్, యా పొదొయ్‌నె నా వందిఙ్‌ నిల్‌దెఙ్‌ అట్‌ఏండ మీరు విజిదెరె నఙి డిఃసి సొనిదెర్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","గాని దేవుణు నఙి మర్‌జి బత్కుదు నిక్తి వెనుక, మిఙి ఇంక ముఙాల గలీలయదు సొనాలె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","అందెఙె పేతురు, “విజేరె మీ వందిఙ్‌ నిల్‌దెఙ్‌ అట్‌ఏండ డిఃస్తి సొహిఙ్‌బా, నాను ఎసెఙ్‌బా నిఙి డిఃసి సొన్‌ఎ”, ఇజి వన్నిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","యేసు వన్నిఙ్, “యా పొదొయ్‌నె కొర్రు కెరెని ముఙాల నీను, నఙి నెస్‌ఎ ఇజి మూండ్రి సుట్కు నీను వెహ్నిలె, ఇజి నాను నిఙి నిజం వెహ్సిన”, ఇజి మర్‌జి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","పేతురు వన్నిఙ్, “నాను నీ వెట సాదెఙ్‌ ఇహిఙ్‌బా గాని నిఙి నెస్‌ఎ ఇజి ఎసెఙ్‌బా వెహ్‌ఎ”, ఇజి వెహ్తాన్‌. మహి సిసూర్‌బా అయాలెకెండె వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","నస్తివలె యేసు వన్ని సిసూర్‌వెట గెత్‌సెమిని ఇని టోటాదు సొహాన్‌. వాండ్రు వరిఙ్, “నాను అబె సొన్సి పార్దనం కిజి మర్‌జి వానిదాక ఇబ్బె బసి మండ్రు”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","పేతురుని జెబెదయి మరిసిరిఙ్‌వన్నివెట ఒతాన్. వాండ్రు నండో దుకం ఆజి బాద ఆదెఙ్‌ మొదొల్‌స్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","వాండ్రు వరిఙ్, “నాను సాదెఙ్‌ డగ్రు ఆతిలెకెండ్‌ మన్సు ఓరిస్తెఙ్‌ అట్‌ఇ నసొ బాద నఙి కల్గిజినాద్. మీరు ఇబ్బెనె బసి నావెట తెలి మండ్రు”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","యేసు అబ్బెణిఙ్‌ కండెక్‌ దూరం సొహాండ్రె ముణుకుఙ్‌ ఊర్‌జి, “నా బుబ్బ, నీను అట్తిఙ యా కస్టమ్‌కు నా బాణిఙ్‌ లాగ్‌అ. గాని నా ఇస్టం వజ ఆఎద్‌, నీ ఇస్టం వజనె జర్గిపిద్‌”, ఇజి పార్దనం కితాన్. ");
INSERT INTO kfc_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","వెనుక వాండ్రు సిసూర్‌ డగ్రు మర్‌జి వాతివెలె వారు నిద్ర కినిక సుడ్ఃజి, “ఉండ్రి గంటబా నా వెట తెలి ఆజి మండ్రెఙ్‌ మీరు అట్‌ఇతిదెరా? ఇజి పేత్రుఙ్‌ వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","“సయ్తాను మిఙి పరిస కిజి తప్పదు సొన్‌ఏండ పార్దనం కిజి తెలి మండ్రు. ఆత్మ తయార్‌నె గాని ఒడొఃల్‌ సత్తు సిల్లెండ ఆజినాద్.” ");
INSERT INTO kfc_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","మరి రుండి సుట్కు సొన్సి, “నా బుబ్బ, యా కస్టమ్‌కు నాబాణిఙ్‌ లాగ్దెఙ్‌ ఆఏద్‌, నాను ఓరిస్తెఙ్‌వలె ఇహిఙ నీను ఇస్టం ఆతి లెకెండ్‌, అయావజనె జర్గిపిద్”, ఇజి పార్దనం కితాన్. ");
INSERT INTO kfc_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","మరి వాండ్రు మర్‌జి వాతివెలె, వరి కణక రెపెఙ్‌ బరుదాన్‌ మూగ్జి మహిఙ్‌ వారు మరి నిద్ర కిజినిక సుడ్ఃతాన్‍. ");
INSERT INTO kfc_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","వాండ్రు మర్‌జి సొహాండ్రె మూండ్రి సుట్కుబ అయా మాటెఙ్‌నె వెహ్సి పార్దనం కితాన్. ");
INSERT INTO kfc_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","వెనుక వాండ్రు వన్ని సిసూర్‌ డగ్రు వాత్తాండ్రె వరిఙ్‌ సుడ్ఃజి, “ఏలుబా మీరు నిద్ర కిజి రోమ్‌జినిదెరా? ఇదిలో లోకుమరిసి ఆతి నఙి సెఇవరి కియుదు ఒపజెప్ని గడిఃయ డగ్రు ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ఇదిలో నఙి ఒపజెప్నికాన్‌ వాజినాన్, లెదు మాటు వరి వెట దసూల్‌ ఆదెఙ్‌ సొనాట్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","వాండ్రు వర్గిజి మహివలె, పన్నెండు మణిసి సిసూర్‌ లొఇ ఒరెన్‌ యూద వాతాన్. పెరి పుజెరిఙు, లోకురి పెద్దెల్‌ఙ పోక్తిమని మంద లోకుర్‌ కూడమ్‌కు, డుడ్కు అస్తారె వన్ని వెట వాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","యేసుఙ్‌ ఒపజెప్నికాన్, “నాను ఎయెరిఙ్‌ముదు కిజిననొ, వన్నిఙ్‌అస్తు”, ఇజి ఉండ్రి గుర్తు లెకెండ్‌ముఙాల వరిఙ్‌ వెహ్త మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","యూద వెటనె యేసు డగ్రు వాతండ్రె, “బోదకినికి”, ఇజి వెహ్తండ్రె పొమ్‌జి వన్నిఙ్‌ ముదు కితాన్. ");
INSERT INTO kfc_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","యేసు వన్నిఙ్, “కూలాయెన్, నీను ఇనిక కిదెఙ్‌ వాతిదొ అక్క కిఅ”, ఇజి వెహ్తాన్‌. నస్తివలె లోకుర్‌ ముఙాల్‌ వాజి వన్ని ముస్కు అర్‌సి వన్నిఙ్‌ అస్తారె తొహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","అయావలెనె యేసు వెట మహికాన్‌ ఒరెన్‌ వన్ని కియు సాప్సి కుర్ద లాగిత్తాండ్రె పెరి పుజెరిఙ్‌ పణిమన్సి గిబ్బి తెవు కత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","యేసు వన్నిఙ్, “నీ కూడం మర్‌జి ఒరాదు ఇడ్ఃఅ, కుర్ద అస్నికార్‌ విజేరె కుర్దదానె సానార్. ");
INSERT INTO kfc_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","నాను ఏలు నా బుబ్బెఙ్‌ సాయం లొస్తిఙ, నా బుబ్బ పన్నెండు గుంపుఙ్‌ సయ్‌నమ్‌ది వరిఙ్‌ ఇంక లావ్‌దూతెఙ నా వందిఙ్‌ పోక్‌ఏండ్రా? మీరు ఇనిక ఒడ్ఃబిజినిదెర్‌? ");
INSERT INTO kfc_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","గాని నాను అయలెకెండ్‌ లొస్తిఙ, యాలెకెండ్‌నె ఇకెఙ్‌ జర్‌గిదెఙ్‌ ఇజి దేవుణు మాటదు రాస్తి మహిక ఎలాగ పూర్తి ఆనాద్‌? ");
INSERT INTO kfc_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","అయావలె యేసు మంద లోకురిఙ్‌ సుడ్ఃజి, “నాను ఒరెన్‌ డొఙ కినికాండ్రా? మీరు కుర్దఙాణిఙ్‌, కొణెఙాణిఙ్‌ నఙి అస్తెఙ్‌ వాతిదెరా? విజు రోస్కు నాను దేవుణు గుడిఃదు బసి బోదిసి మహగదె. అయావలె మీరు నఙి అస్‌ఇతిదెర్. ");
INSERT INTO kfc_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ఎందనిఙ్‌ ఇహిఙ ముఙాల దేవుణు వర్గితి మాటెఙ్‌ ప్రవక్తరు రాస్తి మహికెఙ్‌ అయాలెకెండ్‌ పూర్తి ఆదెఙ్‌ యాకెఙ్‌ విజు జర్గితె”, ఇజి వెహ్తాన్‌. నస్తివలె వన్ని సిసూర్‌ విజేరె వన్నిఙ్‌ డిఃస్తారె ఉహ్‌క్త సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","యేసుఙ్‌ అస్తికార్‌ వన్నిఙ్‌ విజు పుజేరిఙ ముస్కు పెరి పుజెరి ఆతి కయప ఇండ్రొ తత్తార్. అబ్బె పెరి పుజేరిఙు లోకురి పెదలుఙు కూడిఃత వాత మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","దినిఙ్‌ ఆక్కర్‌ ఇనిక ఆనాదొ ఇజి నెస్తెఙ్, పేతురు కండెక్‌ దూరమ్‌దాన్‌ వన్ని వెనుక సొన్సి విజు పుజెరిఙ ముస్కు పెరి పుజెరి ఇలు అర్‌ఙుదు కాప్‌కిని వరి వెట బస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","పెరి పుజెరిఙు, సన్‌హెద్రి సఙం ఇజి యూదురి కోర్‌టుదికార్‌ విజేరె యేసుఙ్‌ సప్తెఙ్‌ తగితి రుజుప్‌ వందిఙ్‌ వన్ని ఎద్రు అబద్దం సాక్యం వెహ్నివరిఙ్‌ రెబాజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","వన్ని ఎద్రు అబద్దం సాక్యం వెహ్నికార్‌ నండొండార్‌ వాతార్‌ గాని వన్నిఙ్‌ సప్తెఙ్‌ తగ్ని ఇనికబా దొహ్క్‌ఏతాద్. ");
INSERT INTO kfc_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","కడెఃవేరిదు రిఎర్‌ ముఙాల వాజి, “నాను దేవుణు గుడిఃదిఙ్‌ అర్‌ప్సి మరి మూండ్రి రోస్కాఙ్‌ లొఇ దనిఙ్‌మర్‌జి తొహ్తెఙ్‌ అట్న ఇజి వాండ్రు వెహ్తాన్‌”, ఇజి వారు వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","నస్తివలె విజు పుజెరిఙ ముస్కు పెరి పుజెరి ఆతికాన్‌ నిఙిత్తాండ్రె యేసుఙ్, “నీను ఇనికబా మర్‌జి వెహ్‌ఇదా? వీరు మీ ముస్కు వెహ్సిని యా మాటెఙ్‌ ఇనికెఙ్‌?”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","గాని యేసు ఇనికబా వర్గిఏండ జమ్‌న మహాన్‌. అందెఙె విజు పుజెరిఙ ముస్కు పెరి పుజెరి ఆతికాన్‌ వన్నిఙ్‌ సుడ్ఃజి, “బత్కిజిని దేవుణుదిఙ్‌ తోడు అసి నీ వెట ప్రమాణం కిజి నాను నిఙి వెన్‌బాజిన, “నీను క్రీస్తు నా, దేవుణు మరిసినా? అహిఙ నఙి వెహ్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","యేసు వన్నిఙ్, “నీను వెహ్తిక నిజమె. గాని లోకుమరిసి ఆతి నాను, వాని గొప్ప అతికారం మన్ని కాలమ్‌దు దేవుణు ఉణెర్‌ పడఃకాదు బసిమంజి ఆగాసమ్‌దాన్‌ మొసోపు ముస్కు వానిక మీరు సూణిదెర్‌ ఇజి నాను మిఙి విజేరిఙ్‌ నిజం వెహ్సిన”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","నస్తివలె విజు పుజెరిఙ ముస్కు పెరి పుజెరి ఆతికాన్‌ నండొ కోపం ఆతండ్రె, వన్ని సొక్కెఙ్‌ కిసె ఆజి, “వాండ్రు దేవుణుదిఙ్‌ దూసిసి వర్‌గితాన్‌! మరి ఇంక సాక్సిరిఙు అవ్‌సరం సిల్లెద్‌. ఇదిలో వాండ్రు దేవుణుదిఙ్‌ దూసిసి వర్గితిక మీరె వెహిదెర్. ");
INSERT INTO kfc_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","మీరు ఇనిక ఒడ్ఃబిజినిదెర్‌?”, ఇజి వరిఙ్‌ వెహ్తాన్‌. అందెఙె వారు”, వీండ్రు సావుదిఙ్‌ తగ్నికాన్”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","నస్తివలె వారు వన్ని మొకొమ్‌దు పూసి, ముటి అసి గుదితార్. సెగొండార్ కియుదాన్‌ డెయ్‌జి, “క్రీస్తు నిఙి డెఃయ్‌తికాన్‌ ఎయెండ్రొ ఇజి మఙి వెహ్‌అ, నీను దేవుణు ప్రవక్తగదె?”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","అయావలె వెల్లి అరఙుదు పేతురు బస్తి మహిఙ్‌ పణిమన్సి ఆతి ఉండ్రి బోదెలి వాతాదె, “నీనుబా గలీలయాదికాన్‌ యేసు వెట మహికి”, ఇజి వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","పేతురు, “నీను ఇనిక వర్గిజినిదొ నఙి తెలిఏద్”, ఇజి బాన్‌మహి విజేరె ఎద్రు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","వాండ్రు అబ్బెణిఙ్‌ వెల్లిహి గవుని డగ్రు సొహిఙ్, మరి ఉండ్రి పణిమన్సి ఆతి బోదెలి వన్నిఙ్‌ సుడ్ఃజి, “వీండ్రు నజరేతుదికాన్‌ ఆతి యేసు వెట మహాన్‌”, ఇజి అబె మహివరిఙ్‌ వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","వాండ్రు నాను వన్నివెట మండ్రెఙ్‌ సిల్లెద్‌ ఇజి ప్రమాణం కిజి, “నాను వన్నిఙ్‌ నెస్‌ఎ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","కండెక్‌టయం ఆతి వెనుక అబ్బె నిహిమహికార్‌ పేతురు డగ్రు వాజి, “నిజమె, నీనుబా వన్నివెట మహికి. నీను వర్గిని మాట విహిఙానె తెలిజినాద్”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","నస్తివలె వన్నిఙ్‌ వాండ్రె సయిప్‌సిబె ఆజి ప్రమాణం కిజి, “నాను వన్నిఙ్‌ నెస్‌ఎ”, ఇజి వరిఙ్‌ వెహ్తాన్‌. వెటనె కొరు కెరెతాద్. ");
INSERT INTO kfc_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","నస్తివలె, “కొరు కెరెని ముఙాల నఙి నెస్‌ఎ ఇజి మూండ్రి సుట్కు నీను వెహ్నిలె”, ఇజి యేసు వన్నిఙ్‌ వెహ్తి మాట ఎతు కితాండ్రె పేతురు వెల్లి సొహాండ్రె గుండె కొతె ఆజి డటం అడఃబతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","పెందాల, పెరి పుజెరిఙుని లోకురి పెద్దెల్‌ఙ విజేరె యేసుఙ్‌ సపిస్తెఙ్‌ ఇజి ఉండ్రి నిర్ణెం కిబిస్తెఙ్‌ ఇజి ఉండ్రె కుట్ర ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","వారు వన్నిఙ్‌ తొహ్తరె, రోమఅతికారి ఆతి పీలాతు డగ్రు తత్తారె వన్నిఙ్‌ ఒపజెప్తార్. ");
INSERT INTO kfc_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","నస్తివలె వన్నిఙ్‌ ఒపజెప్తి యూద, వారు యేసుఙ్‌ సప్తెఙ్‌ ఇజి తీర్పు కితార్‌ ఇజి నెస్తాండ్రె, మన్సుదు నండొ దుకం ఆజి అయ ముపయ్‌వెండి రుపయెఙు పెరి పుజెరిఙుని పెద్దెల్‌ఙ ఎద్రు మహ్త తత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“ఇని తప్ప సిలివన్నిఙ్‌ ఒపజెప్తానె నాను పాపం కిత”, ఇజి వాండ్రు వెహ్తాన్‌. “దనిఙ్‌ నఙి ఇని పొతు సిల్లెద్‌. అయాక నీ బాజిత”, ఇజి వారు వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","అందెఙె యూద అయ వెండి రుపయెఙ్‌ దేవుణుగుడిః లొఇ విసీర్‌తాండ్రె సొహాన్‌. వెనుక సొన్సి వన్నిఙ్‌ వాండ్రె ఉరి లాగె ఆతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","పెరి పుజెరిఙు అయ వెండి రూపయ్‌ఙు పెహ్తరె, “ఇకెఙ్‌ ఒరెన్‌ వన్నిఙ్‌ సప్ని వందిఙ్‌ సిత్తి డబ్బుఙ్, అందెఙె సంద పెటెదు అర్‌ప్నిక దేవుణు రూలుదిఙ్‌ పడిఃఏద్‌”, ఇజి వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","వారు అయ డబుదాన్‌ ఆఇ దేసెమ్‌ది వరిఙ్‌ మూస్తెఙ్, కుమెరివన్ని మడిఃఙ్‌ కొణాట్‌ ఇజి ఉండ్రి నిర్ణెం కితార్. ");
INSERT INTO kfc_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","అందెఙె ఏలుదాక అయ మడిఃఙ, “నల మడిఃఙ’ ఇజి కూకె ఆజినాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","“దేవుణు నఙి ఆడ్ర సిత్తిలెకెండ్, ఇస్రాయేలు లోకుర్‌ వన్ని వందిఙ్‌ విలువ లెకెండ్‌ సిత్తి ముప్పయ్‌ వెండి రూపయెఙ్‌ వారు లాగితారె కుమెరి వన్ని బూమి కొండెఙ్‌ సితార్”. ఇజి దేవుణు ముఙాల ప్రవక్త ఆతి యిరిమ్య వెట వర్గితిక యా లెకెండ్‌ పూర్తి ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","యాకెఙ్‌ జరిగిజి మహివలె యేసు పెరి అతికారి ఆతి పిలాతు ఎద్రు నిల్సి మహాన్‌. నస్తివలె అతికారి ఆతి పిలాతు, “యూదురిఙ్‌ రాజు ఆతికి నీనెనా?”, ఇజి వన్నిఙ్‌ వెన్‌బాతాన్. “నిజమె, నీను వెహ్తి లెకెండ్‌నె”, ఇజి యేసు మర్‌జి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","పెరి పుజెరిఙు, పెద్దెల్‌ఙ వన్ని ముస్కు తపుఙ్‌ మోప్తివెలె వాండ్రు ఇనికబా మర్‌జి వెహ్‌ఏతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","నస్తివలె పిలాతు, “వీరు నీ ముస్కు ఎసొ తపుఙ్‌ మోప్సినార్, యాకెఙ్‌ విన్‌ఇతిదా?”, ఇజి వన్నిఙ్‌ వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","వాండ్రు వారు వెహ్తి మాటెఙ్‌ఉండ్రి దనిఙ్‌బా మర్‌జి ఇనికబా వెహ్‌ఎతాన్. అందెఙె అతికారి నండొ బమ్మ ఆతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","పస్కపండొయ్‌దిఙ్‌ జెలిదు మన్నివరి లొఇ, లోకుర్‌ కోరజిని ఒరెన్‌ వన్నిఙ్‌ విడుదల కిని అలవాటు అతికారిఙ్‌ మనాద్. ");
INSERT INTO kfc_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","అయావలె బరాబ ఇని ఒరెన్‌ మూర్‌కతం మన్ని అన్నయ వాండ్రుననికాన్‌ ఒరెన్ జెలిదు మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","అందెఙె లోకుర్‌ విజెరె కూడ్ఃజి వాతివెలె పిలాతు, “నాను ఎయెరిఙ్‌ విడుదల కిదెఙ్‌ ఇజి మీరు కోరిజినిదెర్‌? బరబ్బెనా, సిల్లిఙ క్రీస్తు ఇజి కూకె ఆజిని యేసుఙా?”, ఇజి వరిఙ్‌ వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","వారు యేసు ముస్కు గోస ఆతారె వన్నిఙ్‌ ఒపజెప్త మనార్‌ ఇజి వాండ్రు నెస్త మనాన్. ");
INSERT INTO kfc_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","పిలాతు నాయం తీరిస్ని బాడిఃదు బస్తి మహివలె వన్ని ఆల్సి, “ఇని తప్పబా సిల్లి అయా నెగ్గివన్నిఙ్‌ ఇనికబా కిదెఙ్‌ నీను కూడ్ఃదెఙ్‌ ఆఏద్‌. వన్ని వందిఙ్‌ నేండ్రు ఉండ్రి కలాదు నాను నండొ బాద కల్గిత మన”, ఇజి వన్నిఙ్‌ కబ్రురు పోక్తాద్. ");
INSERT INTO kfc_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","పెరి పుజెరిఙుని పెద్దెల్‌ఙ, బరబ్బెఙ్‌ డిఃసి సీజి యేసుఙ్‌ సప్తెఙ్‌ ఇజి అతికారి ఒప్నిలెకెండ్‌ వెహ్తెఙ్‌ ఇజి లోకురిఙ్‌ రేప్సి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","“యా రిఎర్‌ లొఇ ఎయెరిఙ్‌ నాను డిఃస్తెఙ్‌ ఇజి మీరు కోరిజినిదెర్‌?”, ఇజి అతికారి వరిఙ్‌ వెన్‌బాతిఙ్, “బరబ్బెఙ్‌నె”, ఇజి వారు మర్‌జి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“అహిఙ క్రీస్తు ఇజి కూకె ఆజిని యేసుఙ్‌ నాను ఇనిక కిదెఙ్‌?”, ఇజి వరిఙ్‌ వెన్‌బాతిఙ్‌ “వన్నిఙ్‌ సిలువ పొక్అ”, ఇజి విజేరె వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","“ఎందానిఙ్‌ వన్నిఙ్‌ సిలువ పొక్తెఙ్, వాండ్రు ఇని తపు పణి కిత్తాన్‌?”, ఇజి పిలాతు వరిఙ్‌ వెహ్తిఙ్, “వన్నిఙ్‌ సిలువ పొక్అ”, ఇజి మరి ఒదె వారు డేల్సి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","గగోలినె లావ్‌ఆజినిక ఆఏండ మరి ఇనికబా కిదెఙ్‌ అట్‌ఏన్‌ ఇజి నెస్తాండ్రె పిలాతు, లోకుర్‌ విజెరె ఎద్రు ఏరు లొసి వన్ని కికు నొర్‌బజి, “ఇని తప్పసిల్లి వన్ని నలదిఙ్‌ నఙి ఇని సమందం సిల్లె, మిఙినె సమందం మనాద్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","అందెఙె లోకుర్‌ విజెరె, “వన్ని నల మా ముస్కుని మా కొడొఃర్‌ ముస్కు మనీద్”, ఇజి మర్‌జి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","నస్తివలె వారు కోరితి లెకెండ్‌నె వాండ్రు బరాబెఙ్‌వరి వందిఙ్‌డిఃస్త సితాన్. గాని యేసుఙ్‌ కొర్‌డెఃఙాణిఙ్‌ డెఃయ్‌జి సిలువ పొక్తెఙ్‌ ఒపజెప్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","నస్తివలె అతికారి సయ్‌నమ్‌దికార్‌ యేసుఙ్‌ వారు బత్కిజిని ప్రిటోరియం ఇని ఇండ్రొ ఒతారె, సయ్‌నమ్‌దికార్‌ విజేరె వన్ని సుటులం కూడిఃతార్. ");
INSERT INTO kfc_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","వారు వన్ని నీరి సొకెఙ్‌ లాగితారె మరి ఉండ్రి ఎరాని నీరి సొక వన్నిఙ్‌ తొడుఃగిస్తాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","వారు సాప్కాణిఙ్‌ అటారె ఉండ్రి టోపి తయార్‌ కిజి వన్ని బురాదు ఇట్తార్‌. ఉండ్రి డుడు వన్ని ఉణిర్‌కియుదు అస్పిస్తారె వన్ని ఎద్రు మూణుకుఙ్‌ ఊర్‌జి, “యూదురిఙ్‌ రాజు ఆతికి గెలిస్‌అ”, ఇజి వెహ్సి వన్నిఙ్‌ వెక్రిస్తార్. ");
INSERT INTO kfc_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","వన్ని ముస్కు పూసి, అయ డుడు లాగ్జి వన్ని బురాదు మరి మరి డెయ్‌తార్. ");
INSERT INTO kfc_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","వన్నిఙ్‌ వెక్రిసి వీజితి వెనుక వన్నిఙ్‌ తొడుఃగిస్తి మహి నీరి సొక్క లాగితారె, వన్ని నీరి సొక్కెఙ్‌ తొడిఃగిస్తారె సిలువ పొక్తెఙ్‌ వారు వన్నిఙ్‌ ఒత్తార్. ");
INSERT INTO kfc_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","వారు సొన్సి మహివలె కురెనియ ఇని పట్నమ్‌దికాన్‌ సీమోను ఇని ఒరెన్‌ వన్నిఙ్‌ సుడ్ఃతారె, సిలువ పిండ్ఃదెఙ్‌ వన్నిఙ్‌ బలవంతం కితార్. ");
INSERT INTO kfc_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","బుర్ర పెణకి ఇని అర్దం ఆని పేరుమని గొల్‌గోత్త ఇని బాడిఃదు వాతార్. ");
INSERT INTO kfc_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","అబె సేందు కలప్తి ద్రాస కడు వన్నిఙ్‌ ఉండెఙ్‌ సిత్తార్‌ గాని వాండ్రు కెఏతాన్, ");
INSERT INTO kfc_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","వన్నిఙ్‌ సిలువ పొక్తి వెనుక వన్ని సొక్కెఙ్‌ ఎయెరిఙ్‌ దొహ్‌క్నె ఇజి నెస్తెఙ్‌ సీటిఙ్‌ పొక్తారె వన్ని సొక్కెఙ్‌ సీబె ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","దన్ని వెనుక వారు అబ్బె బసి వన్నిఙ్‌ కాప్‌కిజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","“వీండ్రు యూదురిఙ్‌ రాజు ఆతి యేసు”, ఇజి వాండ్రు కితి తపు రాసి వన్ని బురాదిఙ్‌ ముస్కు ఇట్తార్. ");
INSERT INTO kfc_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","వన్ని ఉణెర్‌ పడకాదు ఒరెన్‌ వన్నిఙ్, వన్ని డేబ్ర పడఃకాదు ఒరెన్‌ వన్నిఙ్‌ రిఎర్‌ డొఙారిఙ వన్ని వెట సిలువ పొక్తార్. ");
INSERT INTO kfc_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","అయ సర్దు సొనికార్‌ విజేరె బుర్ర దుక్సి, “దేవుణు గుడిఃదిఙ్‌ అర్‌ప్సి మూండ్రి దినమ్‌కాఙ్‌ మర్‌జి తొహ్నికి, నీను దేవుణు మరిసి ఇహిఙ నిఙి నీనె రక్సిస్‌అ, సిలువదాన్‌ డిఃగ్‌జి రఅ”, ఇజి వన్నిఙ్‌ పడిఃఎండ సెఇ మటెఙ్‌ వెహ్సి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","అయ లెకెండ్‌నెస, పెరి పుజెరిఙు, లోకురి పెద్దెల్‌ఙ, దేవుణు మోసెఙ్‌ సితి రూలుఙ్‌ నెస్పిస్నికార్‌ విజేరె వన్నిఙ్‌ వెక్రిస్తార్. ");
INSERT INTO kfc_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“వీండ్రు మహి వరిఙ్‌ తప్రిస్తాన్, గాని వన్నిఙ్ ‌వాండ్రె తప్రె ఆదెఙ్‌ అట్‌ఏతాన్. వాండ్రు ఇస్రాయేలుది రాజు ఇహాన్‌. ఏలు వాండ్రు సిలువ ముస్కుహాన్‌ డిఃగితిఙ వన్నిఙ్‌ మాపు నమినాప్. ");
INSERT INTO kfc_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","వాండ్రు దేవుణు ముస్కు నమకం ఇట్తాన్. “నాను దేవుణు మరిసి’ ఇజి వెహ్తాన్‌. అందెఙె దేవుణుదిఙ్‌ వన్నిఙ్‌ సిలువదాన్‌ రక్సిస్నాండ్రా, ఇజి మాటు సూణాట్‌ దేవుణు వన్నిఙ్‌ తప్రిసీన్‌ ఇజి వారు వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","అయా లెకెండ్‌నె వన్నివెట సిలువ పోకె ఆతి మని డొఙారిఙ్‌బా వన్నిఙ్‌ వెక్రిస్తార్. ");
INSERT INTO kfc_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","మదెనమ్‌దాన్‌ మూండ్రి గంటెఙ్‌దాక దేసెం విజు సీకటి ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","డగ్రు మూండ్రి గంటెఙ్‌ఆతివెలె యేసు, “ఏలి, ఏలి లమ సబక్తాని”, ఇజి నండొ డేల్సివెహ్తాన్. “నా దేవుణు, నా దేవుణు నఙి ఎందనిఙ్‌కియు డిఃస్తి?”, ఇజి యా మాటదిఙ్‌ అర్దం. ");
INSERT INTO kfc_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","అబ్బె నిహి మహికార్‌ సెగొండార్‌ యా మాట విహరె, “వాండ్రు ఏలియెఙ్‌ కూక్సినాన్”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","వెటనె వరి లొఇ ఒరెన్‌ ఉహ్‌క్సి సొన్సి దూది తత్తాండ్రె పులాని రసమ్‌దు ముడుక్సి యేసుఙ్‌ ఉండెఙ్‌ ఉండ్రి డుడుదాన్‌ వన్ని వెయ్‌దు అందిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","మహికార్”, ఇనిక కిమ, ఏలియ వాజి వన్నిఙ్‌ తప్రిస్నాన్‌సు, సూణాట్”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","యేసు మరి డటం డేల్‌స్తాండ్రె పాణం డిఃస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","అయ గడిఃయాదునె దేవుణు గుడిఃదు మని తెర ముస్కుహాన్‌ అడ్గి దాక కింజితాదె రుండి ముకెఙ్‌ ఆతె. బూమి కద్లితాద్. సటుఙ్‌బదెఙ్‌ ఆతె. ");
INSERT INTO kfc_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","దూకిఙ్‌ రే ఆతెనె ముఙాల సాతి మహి నీతి నిజాయితి మనికార్‌ నండొండార్‌ ఒడొఃల్‌దాన్‌ మర్‌జి నీఙితార్. ");
INSERT INTO kfc_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","వారు దూకిఙాణిఙ్‌ వెల్లి వాజి, యేసు సాతి వరిబాణిఙ్‌ మర్‌జి నిఙితి వెనుక దేవుణు వన్నివందిఙ్‌ కేట కిత్తి పట్నమ్‌దు సొన్సి నండొండారిఙ్‌ తోరె ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","సదాతిపతి వెటయేసుఙ్‌ కాప్‌కిజి మహికార్ బూమి కద్లినిక, మరి జర్గితికెఙ్‌ విజు సుడ్ఃజి నండొ తియెల్‌ ఆతార్. “వీండ్రు, నిజమె దేవుణు మరిసినె”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","నండొండెక్‌ బోదెక్‌ కండెక్‌ దూరమ్‌దాన్‌ సుడ్ఃజి మహె. వారు యేసుఙ్‌ అవ్‌సరం ఆతికెఙ్‌ కిజి గలీలయదాన్‌ వన్నివెట వాతికెఙ్. ");
INSERT INTO kfc_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","వన్కా లొఇ మగ్దలెనె మరియాని, యాకోబు, యోసె ఇని వరి అయ్‌సి ఆతి మరియని జెబెదాయి మరిసిరిఙ్‌ అయ్‌సి బానె మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","యేసుఙ్‌ లొఙిజి మనికానాతి అరిమతా ఇని పట్నమ్‌దికాన్‌ యోసేపు ఇని ఒరెన్‌ ఆస్తి మన్నికాన్‌. పొద్దు ఆతివెలె, వాండ్రు పిలాతు డగ్రు సొహాండ్రె యేసు ఒడొఃల్‌ లొస్తాన్. యేసు ఒడొఃల్‌ వన్నిఙ్‌ సీదెఙ్‌ ఇజి పిలాతు ఆడ్ర సితాన్. ");
INSERT INTO kfc_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","యోసేపు అయ ఒడొఃల్‌ లొస్తాండ్రె నెగ్గి తెలాని పాతెఙాణిఙ్‌ సుటిసి, సటుదిఙ్‌ దొల్‌పిస్తి, వన్ని వందిఙ్‌ తయార్‌ కితి మహి కొత్త దూకిదు ఇడ్ఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ఉండ్రి గుండ్రాని సెప్ట పణకు సడిపిసి దూకిదిఙ్‌ అడు కితాండ్రె సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","మగ్దలెనె మరియాని మరి ఉండ్రి మరియ అబ్బె దూకిదిఙ్‌ ఎద్రు బస్తెమహె. ");
INSERT INTO kfc_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","63","మర్సనాండిఙ్, ఇహిఙ విస్రాంతిదినం వందిఙ్‌ తయార్‌ ఆని దినం వెనుక, పెరి పుజెరిఙుని, పరిసయ్‌రు పిలాతు డగ్రు కూడ్ఃజి వాతారె, “బాబు, అయ అబద్దం వెహ్సి మొసెం కితికాన్‌ బత్కితి మహివలె, “మూండ్రి దినమ్‌కు ఆతి వెనుక నాను మర్‌జి నీఙ్‌నాలె’ ఇజి వెహ్తి మహిక మఙి ఎతు మనాద్. ");
INSERT INTO kfc_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","అందెఙె మూండ్రి దినమ్‌కుదాక దూకిదిఙ్‌ నెగెండ సుడ్ఃదెఙ్‌ ఆడ్ర సిఅ. సిల్లిఙ వన్ని సిసూర్‌ వాజి వన్నిఙ్‌ పెర్‌జి ఒసి, వాండ్రు సాతి వరి బాణిఙ్‌ మర్‌జి నిఙితాన్, ఇజి లోకురిఙ్‌ వెహ్నర్. ఆహె కితిఙ కడెఃవెరిదిక మొదొహిదనిఙ్‌ ఇంక మరి ఒదె మోసెం ఆనాద్”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","అందెఙె పిలాతు, “కాప్‌ కినివరిఙ్‌ ఒసి మీరు కియుదాన్‌ కిదెఙ్‌అట్ని లెకెండ్‌ దూకిదిఙ్‌ జాగర్త కాప్‌కిదు”, ఇజి వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","వారు సొన్సి అయ దూకిదిఙ్‌సీలు పొకిస్తారె, జాగర్త సుడ్ఃదెఙ్‌ కాప్‌ కిని వరిఙ్‌బ ఇడ్ఃతార్. ");
INSERT INTO kfc_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","విస్రాంతిదినం గడస్తి సొహి వెనుక, వారమ్‌దిఙ్‌ మొదొహి దినమ్‌దు జాయ్‌అజి మహివలె, మగ్దలెనె మరియాని మరి ఉండ్రి మరియ దూకిదు సుడ్ఃదెఙ్‌ సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","వెటనె బూమి కద్లితాద్. ఎందనిఙ్‌ ఇహిఙ పరలోకమ్‌దాన్‌ ఒరెన్‌ దేవుణు దూత డిగిత వాత్తాండ్రె అడు మహి పణుకు ఎర్లిసి దని ముస్కు బస్త మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","అయ దూత ఒడొఃల్‌ మిర్సిని జాయ్‌లెకెండ్‌ మహాద్‌. వన్ని సొక్కెఙ్‌ గాందులెకెండ్‌ తెలాఙ్‌ మహె. ");
INSERT INTO kfc_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","వన్నిఙ్‌ సుడ్ఃజి కాప్‌ కినికార్‌ తియెల్‌ ఆతారె వణక్సి వరి పాణం సొహి లెకెండ్‌ఆత మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","దేవుణు దూత అయ బోదెకాఙ్‌ సుడ్ఃజి, “మీరు తియెల్‌ ఆమాట్. సిలువ పొకె ఆతిమన్ని యేసుఙ్‌ మీరు రెబాజినిదెర్‌ ఇజి నాను నెసిన. ");
INSERT INTO kfc_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","వాండ్రు ఇబ్బె సిల్లెన్. వాండ్రు వెహ్తి లెకెండ్‌నె మర్‌జి నిఙితాన్. రదు, వాండ్రు గూర్తిమహి బాడిః సుడ్ఃదు. ");
INSERT INTO kfc_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","మీరు బేగి సొన్సి వాండ్రు సాతి వరిబాణిఙ్‌ మర్‌జి నిక్తాన్. వాండ్రు మిఙి ఇంక ముఙాల గలీలయ సొన్సినాన్. మీరు అబ్బె వన్నిఙ్‌ దసూల్‌ ఆనిదెర్, ఇజి వన్ని సిసూరిఙ్‌ ‌వెహ్తు. ఇదిలో యాక ఏలు నాను మిఙి వెహ్సిన ఇజి వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","అందెఙె అవిక్‌ తియెల్‌ ఆజి గొప్ప సర్దదాన్‌ వన్ని సిసూర్‌ఙ ‌యా మాటెఙ్‌ వెహ్తెఙ్‌ ఉహ్‌క్సి సొహె. ");
INSERT INTO kfc_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","వెటనె యేసు వన్కా ఎద్రు తొరె ఆతాండ్రె, “మిఙి నెగెండ్‌ మనిద్”, ఇజి వెహ్తాన్‌. అవిక్‌ వన్ని డగ్రు వాజి పాదమ్‌కు అసి వన్నిఙ్‌ పడ్‌గ్జి మాడిఃస్తె. ");
INSERT INTO kfc_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","నస్తివలె యేసు, “మీరు తియెల్‌ ఆమాట్. మీరు సొన్సి నా కూలెఙ వెట గలీలయదు సొండ్రు ఇజి వెహ్తు. వారు అబె నఙి దసూల్‌ ఆనార్‌లె”, ఇజి వనకాఙ్‌ వెహ్తాన్‌‌. ");
INSERT INTO kfc_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","అవిక్‌ సొన్సిమహిఙ్, దూకిదిఙ్‌ కాప్‌కిజి మహికార్‌ సెగొండార్‌ పట్నమ్‌దు సొహారె, జర్గితి సఙతిఙ్‌ విజు పెరి పుజెరిఙ వెట వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","అందెఙె వారు లోకురి పెద్దెల్‌ఙ వెట కూడ్ఃజి వాతారె ఉండ్రి ఆలోసనం కితార్. వారు అయ సయ్‌నమ్‌ది వరిఙ్‌ నండొ డబ్బుఙ్‌ సితారె, “మాపు నిద్ర కిజి మహివలె వన్ని సిసూర్‌ మదరెతు వాతారె వన్నిఙ్‌ పెహ్త ఒతార్‌ ఇజి మీరు వెహ్తు. ");
INSERT INTO kfc_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","యా మాట అతికారి గిబ్బిదు సొహిఙ మాపు వన్నివెట వర్గిజి మిఙి ఇనికబా రెఏండ సూణాప్‌లె”, ఇజి వరిఙ్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","అందెఙె అయ సయ్‌నమ్‌దికార్‌ డబ్బు అస్తారె వరిఙ్‌ వెహ్తివజనె కితార్. యా డొఙకత ఏలుబా యూదురి లొఇ సాటె ఆజినె మంజినాద్. ");
INSERT INTO kfc_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","పదకొండు మన్సి సిసూర్‌ యేసు వరిఙ్‌ వెహ్తి మన్ని గలీలయాది గొరొత్‌ సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","వారు వన్నిఙ్‌ సుడ్ఃతిఙ్‌ వన్నిఙ్‌ పొగ్‌డిజి మాడిఃస్తార్. గాని సెగొండార్‌ అనుమానం ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","నస్తివలె యేసు వరి డగ్రు వాతండ్రె, “పరలోకమ్‌దుని బూమి ముస్కు విజు అతికారమ్‌కు దేవుణు నఙి సిత మనాన్. ");
INSERT INTO kfc_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","అందెఙె మీరు సొన్సి విజు జాతిఙాణి వరిఙ్‌ నా సిసూర్‌ కిదు. బుబ్బ పేరుదాన్, మరిన్‌ పేరుదాన్, దేవుణు ఆత్మ పేరుదాన్‌ వరిఙ్‌ బాప్తిసం సీదు. ");
INSERT INTO kfc_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","మరి నాను మిఙి ఆగ్న సితిలెకెండ్, నాను మిఙి నెస్‌పిస్తి విజు వనకాఙ్‌లొఙిజి మండ్రెఙ్‌ ఇజి వరిఙ్‌ నెస్పిస్తు. ఇదిలో నాను యా లోకమ్‌ది ఆక్కర్‌ దాక ఎలాకాలం తప్‌ఏండ మీవెట మంజిన”, ఇజి వరిఙ్‌ వెహ్తాన్‌.");
INSERT INTO kfc_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","దేవుణు మరిసి ఆతి యేసు క్రీస్తు వందిఙ్‌ సువార్త ఇబ్బె మొదొల్‌సినాద్. ");
INSERT INTO kfc_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","పూర్‌బ దినమ్‌కాఙ్‌ ముఙాల్‌ దేవుణు వన్ని మరిసిఙ్‌ వెహ్తి మాటెఙ్‌ యెసయ ప్రవక్త ఈహు రాస్త మహాన్‌. “ఇదిలొ, నాను నా కబ్రు తన్నివన్నిఙ్‌ నీ ముఙాల పోక్సిన. లోకు నిఙి డ్గరు కిదెఙ్‌ ఇజి వాండ్రు నీ ముందల నీ సరి నెగెండ్‌ కినాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","బిడిఃమ్‌బూమిదాన్‌ వాండ్రు ఈహు డేల్సి వెహ్సినాన్‌ ప్రబుఙ్‌ లోకుడగ్రు వాదెఙ్‌ సరి తయర్‌కిదు. ప్రబుఙ్‌ లోకుడగ్రు వాదెఙ్‌సరి తినాఙ్‌ కిదు”. ");
INSERT INTO kfc_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","యెసయ ప్రవక్త వెహ్తివజ యోహను బిడిఃఙ్‌ బూమిదు వాతాన్. “లోకుర్‌ పాపమ్‌కు డిఃసిసీజి బాప్తిసం లాగె ఆదు. దేవుణు పాపమ్‌కు సెమిస్నాన్‌ ఇజి వెహ్సి యోహాను బానె లోకాఙ్‌ బాప్తిసం సీజి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","యూదయ దేసెమ్‌దికార్‌ విజెరె, యెరూసలేం పట్నమ్‌దికార్‌ విజెరె సోత్తారె యోహాను డగ్రు వాతార్‌. వారు పాపమ్‌కు ఒపు కొటార్. యోహను వరిఙ్‌ యొర్దాన్‌ గడ్డాదు బాప్తిసం సితాన్. ");
INSERT INTO kfc_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","యోహను ఒంటె బులుస్కాణిఙ్‌ తయార్‌ కిత్తి సొక్క పొర్పాజి, నడఃముదు తోలు బెల్టు తొహ్త మహాన్‌. వాండ్రు మెపిలెక్ని అడిఃవి తేనె తింజి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","యోహాను లోకాఙ్‌ ఈహు వెహ్సి వెహ్తాన్‌, “నా వెనుక ఒరెన్‌ వానాన్లె. వాండ్రు నఙి మిస్తి నండొ పెరికాన్‌. వన్ని జోడు బెల్‌టు కూతెఙ్‌బా నాను ఏపటితికాన్‌ ఆఏ. ");
INSERT INTO kfc_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","నాను మిఙి ఏరుదు బాప్తిసం సీజిన. నా వెనుక వానికాన్‌ దేవుణు ఆత్మదాన్‌ బాప్తిసం సీనాన్లె”. ");
INSERT INTO kfc_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ఆ దినమ్‌కాఙ్‌ ఒర్నెండు యేసు గలీలయదు మన్ని నజరేతుదాన్‌ యోర్దాన్‌ గడ్డాదు వాతాన్. అబ్బె యోహను యేసుఙ్‌ యోర్దాను గడ్డాదు బాప్తిసం సిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","గడ్డదాన్‌ వెల్లి వాజిమహిఙ్‌ ఆగాసం రే ఆతాదె దేవుణు ఆత్మ పావరపొటి లెకెండ్‌ వన్ని ముస్కు వానిక యేసు సుడ్ఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","“నీను నాను ప్రేమిసిని నా మరిన్. నీ వందిఙ్‌ నాను నండొ సర్ద ఆజిన”, ఇజి పరలోకమ్‌దాన్‌ ఉండ్రి కంటం వాతాద్. ");
INSERT INTO kfc_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","వెటనె దేవుణు ఆత్మ యేసుఙ్‌ బిడిఃమ్‌ బూమిదు పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","వాండ్రు అబ్బె నలపయ్ రోస్కు రెయుపొగల్ మహాన్‌. సయ్తాన్‌ యేసుఙ్ తప్ప కిబిస్తెఙ్‌ పరిస కిజి సుడ్ఃతాన్‌‌. అబ్బె అడిఃవి జంతుఙ్‌వెట మహాన్‌. దేవుణుదూతార్‌‌ వన్నిఙ్‌ నెగెండ్‌ సుడ్ఃతార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","హేరోదు రాజు యోహానుఙ్‌ జెలిదు ఇడిఃతివెనుక యేసు గలీలయదు సొహాండ్రె దేవుణుసువార్త బోదిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“దేవుణు ముఙాల్నె ఏర్పాటు కిత్తి టయం ఏలు వాతాద్‌. దేవుణు ఏలుబడిః కిని గడిఃయ డగ్రు ఆత మనాద్‌. మీ పాపమ్‌కు ఒప్పకొడ్ఃజి డిఃసిసీదు, నాను వెహ్ని సువార్త నమ్మిదు”, ఇజి యేసు వరిఙ్‌ బోదిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","యేసు గలీలయ సమ్‌దరం ఒడ్డుదాన్‌ సొన్సిమహిఙ్‌ సీమోనుఙ్‌ని వన్నితంబెర్‌సియాతి అంద్రెయెఙ్‌ సుడ్ఃతాన్ వారు సమ్‌దరమ్‌దు వల పొక్సి మొయేఙ్‌ అసి మహార్‌. ఎందానిఙ్‌ ఇహిఙ వారు జాలెరిఙు. ");
INSERT INTO kfc_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","“నా వెట రదు. లోకాఙ్‌ ఎలాగ నా సిసూర్‌ కిదెఙ్ ఇజి నెస్పిస్నాలె”, ఇజి యేసు వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","వారు వెటనె వలేఙ్‌డిఃసి వన్నివెట సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","యేసు కండెక్‌ దూరం నడిఃజి సొహిఙ్‌ జెబెదెయ మరిసి యాకోబుని, యాకోబు తంబెర్సి యోహాను, వరిడోణిదు బసి వలేఙ్‌ నెగెండ్‌ కిజి మహిక సుడ్ఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","యేసు వరిఙ్‌ సుడ్ఃతివెటనె కూక్తాన్. వారు అప్పొసిఙ్, వన్నివెట కూడ్ఃజి పణికినివరిఙ్‌ డోణిదు డిఃసి యేసువెట సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","యేసుని వన్నిసిసూర్, కపెర్నహము ఇని పట్నమ్‌దు సొహార్‌. విస్రాంతిదినమ్‌దు యేసు యూదురి మీటిఙ్‌ ఇండ్రొ సొహాండ్రె నేర్‌పిస్తెఙ్‌ మొదొల్‌స్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","యేసు నెస్పిస్తిక విహారె లోకుర్‌ నండొ బమ్మ ఆతార్. ఎందానిఙ్‌ ఇహిఙ యూదురి రూలు నెస్పిస్నివరి లెకెండ్‌ ఆఎండ నండొ అతికారమ్‌దాన్‌ మన్ని వన్నలెకెండ్‌ నెస్‌పిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","నస్తివలె వరి మీటిఙ్‌ ఇండ్రొ దెయం అస్తి మహికాన్‌ ఒరెన్‌ మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","వాండ్రు “నజరేతుదికి యేసు, మా వెట నిఙి ఇని పణి? మా పణి విజు అడు కిదెఙ్‌ వాతిదా? నీను ఎయెండ్రొ ఇజి నాను నెసిన. నీను దేవుణు బాణిఙ్‌ వాతి నెగ్గి వాండ్రు”, ఇజి డటం గగోలాజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","అందెఙె యేసు, “అల్లెజి మన్‌అ. విన్నిఙ్‌ డిఃసి వెల్లి రఅ”, ఇజి ఆ దెయమ్‌దిఙ్‌ కోపం దాన్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","అయవలె అయ దెయం అది అస్తిమహివన్నిఙ్‌ దూక్సి డట్టం డేల్‌స్తాదె డిఃస్త సొహద్. ");
INSERT INTO kfc_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","అబ్బె మనికార్‌ విజేరె ఇక సుడ్ఃతారె నండొ బమ్మ ఆతార్. “ఇక ఇనిక? వీండ్రు కొత్త సఙతిఙ్‌ నెర్పిసినాన్. దేవుణు సత్తు దాన్‌ అతికారమ్‌దాన్‌ వీండ్రు సొన్‌అ ఇజి దెయమ్‌కాఙ్‌ వెహ్సినాన్‌. అవి డిఃసి సొన్సినె”, ఇజి ఒరెన్‌ వెట ఒరెన్‌ వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","వన్ని వందిఙ్‌ మాటెఙ్‌ అయా గలీలయ ప్రాంతం సుటుల విజు వెటనె సెద్రితె. ");
INSERT INTO kfc_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","వారు మీటిఙ్‌ కిని ఇండ్రొణాఙ్‌ సొన్సి యాకోబు, యోహానువెట, కూడిఃతారె సీమోను, అంద్రెయ ఇని వరి ఇండ్రొ సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","సీమోను మీమ్సి నోబు అస్త మహాద్‌. వారు వెటనె దని వందిఙ్‌ యేసు వెట వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","యేసు దని డగ్రు వాజి కీదిఙ్‌అసి దనిఙ్‌నిక్తాన్. నస్తివలె నోబు డిఃస్తాద్. నోబు డిఃస్తిఙ్‌ అది వరిఙ్‌ ఉండెఙ్‌ సితాద్. ");
INSERT INTO kfc_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","పొద్దు సొహి ఆతివలె లోకుర్‌ నండొ నండొ రకమ్‌కాణిఙ్‌ బాద ఆజి మహివరిఙ్‌ దెయమ్‌కు అస్తివరిఙ్‌ విజెరిఙ్‌ యేసు డగ్రు తత్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","పటనమ్‌దికార్‌ విజేరె ఆ ఇల్లు ముఙాల్‌ కూడిఃత మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","యేసు నండొ రకమ్‌కాణి జబ్బుమహి నండొండారిఙ్‌ నెగెండ్‌ కిత్తాన్. దెయం అస్తివరిబాణిఙ్‌ వన్కాఙ్‌ ఉల్‌ప్తాన్. వీండ్రు దేవుణు మరిసి ఇజి దెయమ్‌కు నెస్తె మహె అందెఙె వాండ్రు వన్కాఙ్‌ వర్గిఏండ కిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","మర్స నాండిఙ్‌ యేసు సీకటి మంబునె నిఙ్‌జి పెందల ఎయెర్‌ సిల్లి ఉండ్రిబాడ్డిదు సొహాండ్రె పార్దనం కితాన్. ");
INSERT INTO kfc_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","సీమోను, వన్ని వెట మహికార్, యేసుఙ్‌రెబాజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","38","యేసుఙ్‌ సుడ్ఃతారె, “విజేరె నిఙి రెబాజినార్”, ఇజి వెహ్తిఙ్‌ యేసు, “డగ్రు మని మరి పట్నమ్‌కాఙ్‌బా సొనాట్. నాను అబెబా దేవుణు మాటెఙ్‌ సాటిస్తెఙ్వలె. దన్ని వందిఙె నాను వాత మన్న”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","యేసు గలీలయ విజు బూలాజి యూదురు మీటిఙ్‌ కిని ఇల్కాఙ్‌ బోదిస్తాన్. దెయం అస్తి వరిబాణిఙ్‌ వన్కాఙ్‌ ఉల్‌ప్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ఒరెన్‌ కుస్టు రోగం మనికాన్‌ యేసు డగ్రు వాజి ముణుకుఙ్‌ ఊర్‌జి, “నిఙి ఇస్టం మహిఙ నఙి నెగెండ్‌ కిదెఙ్‌ అట్‌ని”, ఇజి బతిమాలితాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","యేసు వన్ని ముస్కు కనికారం ఆజి కియు సాప్సి వన్నిఙ్‌ ముట్సి, “నఙి ఇస్టమ్‌నె, నీను నగెండ్‌ ఆఅ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","వెటనె వన్నిఙ్‌ మహి జబ్బు డిఃస్తాద్. వాండ్రు నెగెండ్‌ ఆతాన్. ");
INSERT INTO kfc_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","అయవలె యేసు, “ఎయెవెటబా ఇనికబా వెహ్మ. నీను తినాఙ్‌ సొన్సి నీ ఒడొఃల్‌యూద పుజేరిఙ్‌ తోరిస్‌అ. నీను నెగెండ్‌ఆతి వందిఙ్‌ మోసె ముఙాల్‌ ఆడ్ర సితివజ దేవుణుదిఙ్‌సంత సిఅ” అహె నీను నెగెండ్‌ ఆతి ఇజి లోకురిఙ్‌ తొరిస్‌అ”, ఇజి కసితం వెహ్సి పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","గాని ఆ నెగెండ్‌ఆతికాన్‌ సొన్సి వాండ్రు నెగెండ్‌ఆతిక విజేరిఙ్‌ మరి ఒద్దె వెహ్తాన్‌‌. అహిఙ్‌బా విజుబాణిఙ్‌ నండొ లోకుర్‌ యేసుబాన్‌ వాతార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","సెగం రోస్కు ఆతి వెనుక యేసు మరి కపెర్నహముదు వాతాన్. వాండ్రు ఇండ్రొ వాతాన్ ఇని విజెరె వెహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","నండొ లోకుర్‌బాన్‌ కూడిఃజి వాతార్. అస్తెఙ్‌ అట్‌ఇ లోకుర్‌వాతార్. అందెఙె ఇల్లు లొఇబా అర్‌ఙుదుబా బాడ్డిః సిల్లెండ ఆతాద్‌, యేసు వరిఙ్‌ దేవుణు మాటెఙ్‌ బోదిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","కికు కాల్కు అర్తి వన్నిఙ్‌ నాల్‌ఏర్‌ పిండిత తతారె సెగొండార్‌ యేసుబాన్‌ వాతార్. ");
INSERT INTO kfc_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","అబ్బె నండొ లోకుర్‌ మహిఙ్‌ వన్నిఙ్‌ యేసు డగ్రు ఒతెఙ్‌ అట్‌ఏండ ఆతార్. అందెఙె యేసు నిహిమహి జాగముస్కు మెడదిఙ్‌ బొరొకితారె ఆ జబ్బు ఆతివన్నిఙ్‌ సాపదాన్‌ యేసు నిల్సిమహిబాన్‌ డిప్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","వన్నిముస్కు మని వరి నమకం సుడ్ఃతాండ్రె, యేసు జబ్బు ఆతివన్నివెట కూలయెఙ్‌ నీ పాపమ్‌కు సెమి ఆతె మన్నె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","అబ్బె సెగొండార్‌ యూదురి రూలు నేర్పిస్నికార్‌ బస్త మహార్‌. వారు మనుస్సుదు. ");
INSERT INTO kfc_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","వీండ్రు ఎందానిఙ్‌ ఈహు వెహ్సినాన్‌. వీండ్రు దేవుణువెట సమానం ఆతికాన్‌ ఇజి దేవుణుదిఙ్‌ దూసిసినాన్‌. దేవుణు ఒరేండ్రె పాపమ్‌కు సెమిస్నికాన్‌ గదె”, ఇజి వారు ఒడిఃబితార్. ");
INSERT INTO kfc_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","వారు ఈహు ఒడ్ఃబిజినిక యేసుఙ్‌ వెటనె తెలితాద్‌. యేసు వరిఙ్ వెహ్తాన్‌, “ఎందానిఙ్‌ మీరు మీ మనుస్సుదు అహె ఒడ్ఃబిజినిదెర్‌? ");
INSERT INTO kfc_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","యా జబ్బుది వన్నిఙ్‌ నీ పాపమ్‌కు సెమ ఆత మన్న ఇజి వెహ్నిక సులునా? నీను నిఙ్‌జి సాప పెర్జి నడిఃఅ ఇజి వెహ్నిక సులునా? ");
INSERT INTO kfc_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","11","లోకు మరిసి ఆతి నఙి లోకురి పాపమ్‌కు సెమిస్తెఙ్‌ బూమి ముస్కు అతికారం మనాద్. ఇజి మీరు నెస్తెఙ్‌వలె ఇజి వెహ్తండ్రె కిక్కు కాల్కు అర్తి వన్నిఙ్‌ “నాను నిఙి వెహ్సిన, నిఙ్‌అ, నీ సాప అసి ఇండ్రొ సొన్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","వెటనె ఆ కిక్కు కాల్కు అర్తికాన్‌ నిఙ్‌జి వన్ని సాప అసి వారు విజేరె సుడ్ఃజి మహిఙ్‌ నడిఃజి సొహాన్‌. అక్క సుడిఃతారె వారు విజేరె బమ్మ ఆతార్. “నిన్ని పణి మాట్‌ ఎసెఙ్‌బా తొఏట్” ఇహరె దేవుణుదిఙ్‌ స్తుతి కితార్. ");
INSERT INTO kfc_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","యేసు మరి గలీలయ సమ్‌దరం గట్తుదు సొహాన్‌. లోకుర్‌ వన్ని డగ్రు వాతిఙ్‌ వరిఙ్‌ దేవుణు మాటెఙ్‌ నెస్పిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","యేసు నడిఃజి సొన్సి మహిఙ్‌ అల్‌పయ్‌ఇని వన్ని మరిసి లేవి ఇని పను పెర్నికాన్‌ ఒరెన్‌ వన్ని ఆపిసుదు బస్తమహిక సుడ్ఃతాన్‌. యేసు వన్నిఙ్‌ “నీను నా సిసుడు ఆఅ. నా వెట రఅ”, ఇజి వెహ్తాన్‌. లేవి నిఙిత్తాండ్రె యేసువెట సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","వెనుక యేసు లేవి ఇండ్రొ బోజెనమ్‌దిఙ్‌ బస్తాన్. సెఇ పణి కినికార్‌ అబ్బె మహార్‌. పను పెర్నికార్‌ వారు యూదురు వెహ్తి రూలు వజ నడిఃఇకార్. ఎసొండారొ లోకుర్‌ యేసువెట మహార్‌. వారుబా యేసు, వన్ని సిసూర్‌వెట బోజెనమ్‌దిఙ్‌ బస్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","పరిసయ్‌రు లొఇ మన్ని యూదురి రూలుఙ్‌ నెస్‌పిస్‌నికార్‌ వనిఙ్‌ సుడ్ఃజి “ఎందనిఙ్‌ వీండ్రు పన్నుపెర్నివరివెటని పాపం కినివరివెట ఉణిజినాన్”, ఇజి సిసూరిఙ్‌ వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","యేసు ఆ మాట వెంజి‌ “నెగెండ్‌ సిల్లివరిఙ్‌ డాక్టరు కావాలి. నెగెండ్‌ మన్నివరిఙ్‌ ఎందానిఙ్‌లు మరి డాక్టరు. నీతి నిజమాతి మన్నివరిఙ్‌ అఏద్‌. పాపం కితివరిఙ్‌ కూక్‌క్తెఙె నాను వాత మన్న, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","అయవలె బాప్తిసం సీని యోహాను సిసూర్‌ని, పరిసయ్‌రు, యూదురి రూలువజ ఉపాస్‌కిజి మహార్‌. సెగొండార్‌ లోకుర్‌ వాజి యేసుఙ్‌ వెన్‌బాతార్, “యోహాను సిసూర్‌ ఉపాస్‌కిజినార్, పరిసయ్‌రి సిసూర్‌ ఉపాస్‌కిజినార్, ఎందానిఙ్‌ నీ సిసూర్‌ ఉపాస్‌కిఎర్‌?”. ");
INSERT INTO kfc_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","యేసు ఈహు వెహ్తాన్‌, “పెండ్లి కూలెఙ్‌ పెండ్లిదఙ్‌డఃవెట మన్నివెలె ఉపాస్‌ మండ్రెఙ్‌ అట్నారా? పెండ్లిదఙ్‌డవరివెట మన్నివలె వారు ఉపాస్‌ మండ్రెఙ్‌ అట్‌ఏర్. ");
INSERT INTO kfc_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","పెండ్లిదఙ్‌డెఙ్‌ వరి నడిఃమిహాన్‌ ‌ఒని దినం వానాద్‌లె. అయ రోజు వారు ఉపాస్‌మంజినార్. ");
INSERT INTO kfc_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","యేసు మరి వెహ్తాన్‌‌: “ఎయెర్‌బా పాడాయ్‌ పాతదు కొత్త ముక్క కూడ్ఃప్సి గుత్‌ఏర్. ఆహె కితిఙ అయకొత్త పాత ముక్క పడాయి పాతదిఙ్‌ లాగ్నాదె బొరొ ఒద్దె లావు ఆనాద్. ");
INSERT INTO kfc_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“ఎయెన్‌బా పడాఃయ్‌ తోలుసన్సిదు కొత్త ద్రాక్సకలు వాక్‌ఏన్‌. అహె కిత్తిఙ కొత్త ద్రాక్సకలు పొఙు వాజి అయ సన్సి పెడెల్‌నాద్. ద్రాక్సకలు విజు వాఙ్‌న సొనాద్. సన్సి పాడునాద్‌. అందెఙె కొత్త ద్రాక్సకల్లు కొత్త తోలు సన్సిదునె వాక్తెఙ్”. ");
INSERT INTO kfc_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ఉండ్రి విస్రాంతి దినమ్‌దు యేసుని సిసూర్‌ పంట గుడ్డెదాన్‌ నడిఃసి సొన్సి మహార్‌. అయవలె సిసూర్‌ సెరేక్‌ తెప్సి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","పరిసయ్‌రు అయక సుడ్ఃతారె‌, “ఇదిలో ఎందానిఙ్ వారు విస్రాంతి దినమ్‌దు రూలుదిఙ్‌ తప్సినార్‌. ఇజి వన్నిఙ్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","అయవలె యేసు వెహ్తాన్‌, “దావీదురాజు, వన్నివెట మహి లోకుర్‌ బఙ కట్తిఙ్‌ వాండ్రు ఇనిక కిత్తాండ్రొ ఇజి మీరు ఎసెఙ్‌బా సద్‌విఇదెరా? ");
INSERT INTO kfc_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","అబ్యాతారు ఇనికాన్. విజెరె పుజెరిఙ ముస్కు పెరి పుజెరి మహివలె దావీదురాజు సమాజ గుడారమ్‌దు డుఃగితాండ్రె, దేవుణు ఎద్రు ఇడ్తి రొట్టెఙ్‌ లాగితాండ్రె తిహాన్. అక్క పుజేరి తప మరి ఎయరర్‌బా తిండ్రెఙ్‌ ఆఏద్‌ గాని తిహాండ్రె వన్నివెట మహివరిఙ్‌బా సిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","వెనుక యేసు వరిఙ్‌ వెహ్తాన్‌, “ముఙాల్‌ దేవుణు లోకుదిఙ్‌ విస్రాంతిదినం ఏర్పాటు కిత్తాన్. గాని విస్రాంతి దినమ్‌వందిఙ్‌ లోకుదిఙ్‌ ఏర్పాటు కిఏన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","లోకుమరిసి ఆతి పిట్తి నఙి విజు వన్కాఙ్‌ ముస్కు అతికారం మనాద్. మరి, విస్రాంతి దినమ్‌దు ఇనిక కిదెఙ్‌ ఇజి లోకాఙ్‌ వెహ్తిఙ్‌బా అతికారం మనాద్. ");
INSERT INTO kfc_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","మరి యేసు యూదురి మీటిఙ్‌ ఇండ్రొ సొహాన్‌. అబె ఉండ్రి కియు అర్తికాన్‌ ఒరెన్‌ మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","అబ్బె మహికార్‌ సెగొండార్‌ యేసు యా జబ్బుదివన్నిఙ్‌ విస్రాంతిదినమ్‌దు నెగెండ్‌ కినాండ్రొ ఇజి బాగ సుడిఃజి మహార్‌. ఎందనిఙ్‌ ఇహిఙ విస్రాంతిదినమ్‌దు ఇని పణిబా కిదెఙ్‌ ఆఏద్‌ కాక యేసుఙ్‌ ఇని దన్నిఙ్‌బా తప్ప మొప్తెఙ్‌ ఇజి సుడిఃజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","యేసు కియు అర్తివన్నిఙ్, “విజేరి ముఙాల వాజి నిల్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","నస్తివలె యేసు, “దేవుణు మోసెఙ్‌ సితి రూలువజ విస్రాంతి దినమ్‌దు నెగ్గి పణి కిదెఙా, సెఇ పణి కిదెఙా? పాణం అర్‌ప్తెఙ్‌నా? ఇజి వరిఙ్‌ వెన్‌బాతాన్. గాని వారు అలెతార్. ");
INSERT INTO kfc_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","వరి మన్సు గర్రాజిమహిఙ్‌ యేసు నండొ దుకం ఆతాన్. కోపం దాన్‌వరిఙ్‌ సుడ్ఃతాన్. అయ కియు అర్తివన్నివెట, “నీ కియు సప్‌అ”, ఇజి వెహ్తాన్‌. వాండ్రు కియు సాప్తిఙ్‌ ఆ కియు నెగెణ్‌ ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","నస్తివలె పరిసయ్‌రు వెల్లి సొహి వెటనె హెరోది ఇని వరివెట కూడ్ఃజి యేసుఙ్‌ ఎలాగ్‌సప్తెఙ్‌ ఇజి ఆలోసనం కితార్. ");
INSERT INTO kfc_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","అందెఙె యేసు వన్ని సిసూర్‌వెట గలీలయ సమ్‌దరంబాన్‌ సొహాన్‌. మందలోకుర్‌ గలీలయదాన్‌ వరివెనుక సొహార్. ");
INSERT INTO kfc_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","యేసు కిత్తి గొప్ప పణిఙ వెంజి యూదయ దేసెమ్‌దు మన్ని విజు నాహ్క్‌ణికార్‌, యెరూసలేందాన్, సమ్‌దరం పడకాద్‌ తూరు సీదోను ఇని పట్నమి ప్రాంతమ్‌కాఙ్‌ వాతి నండొ లోకుర్‌ వన్నిబాన్‌ వాతార్. ");
INSERT INTO kfc_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","నండొ లోకుర్‌ వాజి మహిఙ్‌ నిల్సిమండ్రెఙ్‌ ఇహ్‌కు ఆజి దన్ని ముస్కు ఆఎండ మండ్రెఙ్‌ ఉండ్రి ఇజ్రి డోణి తసి బానె ఇడ్‌దు ఇజి సిసూర్‌ వెట యేసు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ఎందానిఙ్‌ ఇహిఙ నండొండారిఙ్‌ యేసు నెగెణ్‌కితాన్. అందెఙె జబ్బు ఆతిమహికార్‌ విజేరె యేసుఙ్‌ ముట్తెఙ్‌ ఇజి నెక్కె ఆజి సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","దెయం అస్తికార్‌ యేసుఙ్‌ సుడ్ఃతివెటనె వన్ని ముఙాల్‌ ముణుకుఙ్‌ ఊర్‌జి, పడగ్‌జి మాడిఃస్తారె “నీను దేవుణు మరిసి”, ఇజి గగోలాతార్. ");
INSERT INTO kfc_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","“నాను ఎయెన్‌ ఇజి ఎయేర్‌వెట వెహ్మట్”, ఇజి యేసు వరివెట కసితం ఆడ్ర సిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","వెనుక యేసు ఉండ్రి గొరోత్‌ ఎక్సి సొహాండ్రె వన్నివెట ఒతెఙ్‌ వాండ్రు కోరితివరిఙ్‌ వన్ని డగ్రు కూక్తాన్‌. వారు వన్నిబాన్‌ సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","యేసు పన్నెండు మనిసిరిఙ్‌ వన్నిబాన్‌ మండ్రెఙ్‌ ఇజి, దేవుణు మాట విజేరిఙ్‌ వెహ్నివందిఙ్‌ పోక్తెఙ్‌ ఇజి ఏర్‌పాటు కిత్తాన్‌. (విరిఙె అపొస్తురు ఇజి కూక్తాన్) ");
INSERT INTO kfc_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","దెయమ్‌కాఙ్‌ ఉల్‌ప్తెఙ్‌ అతికారం వరిఙ్‌ సితాన్. ");
INSERT INTO kfc_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","యా పన్నెండు మణిసిర్‌ ఎయెర్‌ ఎయెర్‌ ఇహిఙ సీమోను (యేసు వన్నిఙ్‌ పేతురు ఇని పేరు సితాన్‌) జెబెదయ మరిసిర్‌ యాకోబు, వన్ని తంబెర్‌సి యోహాను ఇనికార్ (యేసు వరిఙ్‌ బొయనర్గసున్‌ ఇని పేరు సిత్తాన్. దన్ని అర్దం ఇనిక ఇహిఙ దీడ్ఃజినికార్‌ ఇజి) అంద్రెయ, పిలిప్ప, బర్తొలొమయ, మత్తయి, తోమా, అల్పయ మరిసి యాకోబు, తద్దయి, యుదయ దేసెంవందిఙ్‌ ఉసారాజిని సీమోను, యేసుఙ్‌ యూదురు అతికారిఙ కీదు ఒపజెప్నికానాతి ఇస్కరియోతు యూద. ");
INSERT INTO kfc_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","యేసు ఉండ్రి ఇండ్రొ వాతిఙ్‌ మరి నండొ లోకుర్‌ అబ్బె కూడిఃతార్. అందెఙె యేసుఙ్‌ని సిసూరిఙ్‌, బోజనం కిదెఙ్‌బా కాలి సిల్లెతాద్. ");
INSERT INTO kfc_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","యేసు ఇండ్రొణికార్‌ యా సఙతి విహరె వన్నిఙ్‌ మత్తి సెద్రితాద్‌ ఇజి వెహ్సి వన్నిఙ్‌ అస్తెఙ్‌ సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","యెరూసలేమ్‌దాన్‌ వాతి యూదురి రూలుఙ్‌ నెస్పిస్నికార్‌ వెహ్తార్‌, “దెయమ్‌కాఙ్‌ నెయ్‌కి ఆతి బయల్‌జెబ్బులు విన్నిఙ్‌ అస్తాన్. వన్ని సత్తుదాన్‌ వీండ్రు దెయమ్‌కాఙ్‌ పేర్‌జినాన్”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","నస్తివలె యేసు వరిఙ్‌ కూక్సి వరిఙ్‌ అర్దమాదెఙ్‌ కత వజ ఈహు వెహ్తాన్‌, “సయ్తాన్‌ సయ్‌తాను‌ఙ్‌ ఎలాగ ఉల్‌ప్నాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ఉండ్రి దేసమ్‌దికార్‌ వరిఙ్‌ వారె జటిఙాజి ఎర్‌లిజి మహిఙ అయ దేసెం పాడాఃనాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ఉండ్రి ఇండ్రొణికార్‌ వరిఙ్‌ వారె జటిఙాజి ఎర్‌లిజి మహిఙ ఆ కుటం పాడాఃనాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","సయ్తాన్‌ వన్ని గుంపుదు మన్నివరివెట జటిఙాజి కేట ఆతిఙ నండొ కాలం వరిముస్కు ఏలుబడిః కిదెఙ్‌ అట్‌ఏన్. ");
INSERT INTO kfc_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ఒరెన్‌ సత్తుమన్ని వన్నిఙ్‌ ముఙాల తొహ్‌ఏండ, ఎయెర్‌బా వన్ని ఇండ్రొ డుఃగ్‌జి సామనమ్‌కు ఒత్తెఙ్‌ అట్‌ఏర్‌. ముఙాల వన్నిఙ్‌ తొహ్తిఙానె డొఙ కిదెఙ్‌ అట్నార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","నాను నిజం వెహ్సిన, లోకుర్‌ కినివిజు పాపమ్‌కాఙ్‌ని, దూసిసిని మాటెఙ్‌ దేవుణు సెమిస్నాన్. ");
INSERT INTO kfc_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","గాని దేవుణు ఆత్మదిఙ్‌ దూసిస్తిఙ వన్ని పాపం ఎసెఙ్‌బా సెమిస్‌ఏన్. వన్ని పాపం ఎలా కాలం మంజినాద్”. ");
INSERT INTO kfc_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","యేసు ఈహు ఎందానిఙ్‌ వెహ్తాన్‌‌ ఇహిఙ సయ్తాన్‌ సాయమ్‌దాన్‌ యేసు దెయమ్‌కాఙ్‌ ఉల్‌ప్సినాన్‌ ఇజి యూదురి రూలుఙ్‌ నేస్పిసినికార్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","యేసు అయ్‌సిని తంబెర్‌సిర్‌ వాండ్రు మన్ని ఇల్లుముఙాల్‌ వాతారె యేసుఙ్‌ కూక్సి తగ్‌అ ఇజి ఒరెన్‌వన్నిఙ్‌ ఇండ్రొ పోక్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","అయ ఇండ్రొ యేసు సురుల నండొ లోకుర్‌ బస్త మహార్‌. వారు వెహ్తార్‌, “నీ యాయ తంబెర్‌సిర్‌ వెల్లి నిహారె నిఙి కూక్సినార్”. ");
INSERT INTO kfc_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","34","దనిఙ్‌ యేసు, “నా యాయ? నా తంబెర్‌సిర్‌ ఎయెర్‌ ఇజి నాను వెహ్న”. అబ్బె సురుల బస్తిమనివరిఙ్‌ సుడ్ఃజి యేసు వెహ్తాన్‌, “ఇదిలో నా యాయని, నా తంబెర్‌సిర్”. ");
INSERT INTO kfc_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","“ఎందనిఙ్‌ ఇహిఙ దేవుణుదిఙ్‌ ఇస్టమాతివజ కినికాండ్రె నా తంబెరి, నా తఙి, నా యాయ ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","యేసు మరి ఒర్సు గలీలయ సమ్‌దరం పడఃకాదు నెస్‌పిస్తెఙ్‌ మొదోల్‌స్తాన్. మందలోకుర్‌ వన్ని డగ్రు వాతిఙ్‌ సమ్‌దరమ్‌దు ఉండ్రి డోణిదు ఎక్సి బస్తాన్. లోకుర్‌ విజెరె సమ్‌దరం పడఃకాదు నిహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","అయవలె వాండ్రు నండొ సఙతిఙ కతవజ వరిఙ్‌ నెస్పిస్తాన్. వాండ్రు ఉండ్రి సఙతి కత వజ ఈహు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","సుడ్ఃదు, ఒరెన్‌ రయ్తు వాండ్రు విత్కు విత్తెఙ్‌ సొహాన్. ");
INSERT INTO kfc_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","వాండ్రు విత్సి మహిఙ్‌ సెగం విత్కు సరి పడఃకాదు అర్తె. ఆ పొటిఙ్‌ వనకాఙ్‌ పెహ్తె తిహె. ");
INSERT INTO kfc_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","మరి సెగం విత్కు సటు ముస్కు లావ్‌ డుల్లి సిల్లిబాన్‌ అర్తె. డుల్లి లావు సిల్లితిఙ్‌ అవి వెటనె నేర్తెగాని వెల లొఇ సొన్‌ఇఙ్‌ పొద్దు సొసి ఎండ తాక్తివలె అవి సాతె సొహె. ");
INSERT INTO kfc_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","మరి సెగం విత్కు సాప్కు తుపెఙ్‌ లొఇ అర్తె. సాప్కు తుప్పెఙ్‌ పిరిజి వనకాఙ్‌ తిగితె. అందెఙె పంట పండ్‌ఏతాద్. ");
INSERT INTO kfc_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","మరి సెగం నెగ్గి బూమిదు అర్తె. అక్కెఙ్‌ నేర్‌జి పిరితెనె విత్తి విత్కుదిఙ్‌ ముప్పయ్‌ వంతుఙ్‌ లెక్క పండితె. ");
INSERT INTO kfc_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","యేసు మరి వెహ్తాన్‌, “గిబ్బిఙ్‌ ఒడ్ఃజి వెంజి అయవజ నడిఃజి మండ్రు”. ");
INSERT INTO kfc_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","యేసు ఒరెండ్రె మహిఙ్‌ పన్నెండు మణిసిర్‌ సిసూర్‌ని మరి సెగొండార్, “నీను కత వజ నెస్‌పిస్తి మాటెఙ అర్దం ఇనిక?”, ఇజి వన్నిఙ్‌ వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","12","అందెఙె యేసు, “దేవుణు కిని ఏలుబడిః వందిఙ్‌ డాఙితిమహి గొప్ప సఙతిఙ్‌ దేవుణు మిఙి తెలివి కిత్త మనాన్. గాని మహివరిఙ్‌ విజుబా కతవజ నెస్‌పిస్తెఙ్‌ ఎందానిఙ్‌ కతవజ వెహ్త ఇహిఙ “వారు సుడిఃనార్‌ గాని తొ‌ఏర్. వెండ్రెఙ్‌ ఇహిఙ వెంజినార్‌ గాని అర్దం కిదెఙ్‌ అట్‌ఏర్. ఎందానిఙ్‌ ఇహిఙ వారు అర్దం కిజి వరి పాపమ్‌కు సెమిస్నాన్” ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","యేసు వరివెట వెహ్తాన్‌, “రయ్తువన్ని వందిఙ్‌ నాను కతవజ వెహ్తిక మిఙి అర్దం ఆఏదా? అహిఙ నాను కతవజ వెహ్తికెఙ్‌ విజు మిఙి ఎలాగ తెలినాద్‌? ");
INSERT INTO kfc_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","విత్నికాన్‌ దేవుణు మాట వెహ్నికాన్. ");
INSERT INTO kfc_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","సెగొండార్‌ విత్కు అర్తి సరి పడఃకనన్నికార్. వారు వెహివెటనె సయ్తాన్‌ వాజి ఆ మాటెఙ్‌ లాగ్జి ఒసినాన్. ");
INSERT INTO kfc_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","మరి సెగొండార్‌ విత్కు అర్తి సటుపణుకు ముస్కు మన్ని ఇస్కా నన్నికార్. వారు దేవుణుమాట వెహివెటనె సర్‌దదాన్‌ మన్సుదు ఇడ్నార్. ");
INSERT INTO kfc_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","గానివెల లొఇ సొన్‌ఇలెకెండ్‌ దేవుణుమాట వరి మన్సు లొఇ సొన్‌ఏద్‌. వారు కండెక్‌ కాలం నమ్మిజి మంజినార్‌. దేవుణుమాట నమ్మితి వందిఙ్‌ కస్టమ్‌కు మాల్లెఙ్‌, వానెవెలె దేవుణు ముస్కు మన్ని వరి నమకం వెటనె డిస్న సీనార్. ");
INSERT INTO kfc_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","మరి సెగొండార్‌ విత్కు అర్తి సాప్కు తుపెఙ్‌ నేర్ని బూమివజ మనార్. గాని ఎలాగ బత్కిదెఙ్‌ ఇని వందిఙ్‌ మన్ని విసారం, డబ్బు గణిసిని వందిఙ్‌ మన్ని ఆస విజు కూడిఃజి వారు దేవుణుదిఙ్‌ నమ్మిఏండ కిదెఙ్‌ వారు వెహి మాటదిఙ్‌ అణసు తిగ్‌జినె. పంట పండ్‌ఏండ ఆతిలెకెండ్‌ వారుబా ఆజినార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","సెగొండార్‌ అర్తి విత్కునెగ్గి బూమిదువజ మనార్. వారు దేవుణుమాట వెంజి అర్‌దం కిజి దేవుణు ముస్కు నమకం ఇడ్నార్. నెగ్గి బూమిదు అర్తి విత్కు బస్తెణిదిఙ్‌ ముప్పయ్‌ బస్తెఙ్‌ అర్‌వయ్‌ బస్తెఙ్‌ వంద బస్తెఙ్‌ పండ్నివజ వారు మంజినార్.” ");
INSERT INTO kfc_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","యేసు వరివెట ఈహు వెహ్తాన్‌, “దీవ కసిసి అబల మూక్సినొ మన్సం అడిఃగినొ ఎయెరుబా ఇడ్‌ఏర్. జాయ్‌ సీనివజ దీవ కంతూదు ఇడ్నార్. ");
INSERT INTO kfc_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ఎందానిఙ్‌ ఇహిఙ ఏలు డాఃఙితి మన్నికెఙ్‌ విజు ఒర్నెండ్‌ తోరె ఆనె. ");
INSERT INTO kfc_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","మీరు గిబ్బిఙ్‌ ఒడ్ఃజి వెంజి అయావజ నడిఃజి మండ్రు”. ");
INSERT INTO kfc_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","యేసు మరి వెహ్తాన్‌, “మీరు వెహిక జాగర్త అర్‌దం కిదెఙ్‌వలె. మీరు నెగ్రెండ అర్‌దం కిజిమహిఙ, దేవుణు వన్ని మాటెఙ్‌ అర్‌దం కిబిస్నాన్‌లె. ఒఒ మరి ఒద్దె అర్‌దం కిబిస్నాన్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","నాబాణిఙ్‌ వెంజి అర్‌దం కిజినివన్నిఙ్‌ దేవుణు మరి తెలివి కినాన్‌. గాని వెంజి అర్‌దం కిఇవన్నిబాణిఙ్‌ వాండ్రు అర్‌దం కిత్తి మన్నికెఙ్‌బా లాగ్నాన్”. ");
INSERT INTO kfc_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","యేసు మరి వెహ్తాన్‌, “దేవుణు ఏలుబడిః ఈహు మనాద్. ఒరెన్‌ రయ్తు వాండ్రు విత్కు బూమిదు విత్సినాన్. ");
INSERT INTO kfc_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","వాండ్రు రెయ్కాఙ్‌నిద్ర కిజి పెందల నిఙ్‌జి మంజినాన్. వన్నిఙ్‌ తెలిఏండ ఆ విత్కు నేర్‌జి పిరిసినె. ");
INSERT INTO kfc_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ముఙాల ఆకు, దన్ని వెనుక సెరెన్, దన్ని వెనుక సెరెన్‌దు గింజ ఇక విజు బూమినె పుటిసినాద్. ");
INSERT INTO kfc_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","పంట పండ్నాద్. కొయ్‌నికాలం వాతిఙ్‌ వాండ్రు కొడుఃవేలి అసి కొయ్‌జినాన్”. ");
INSERT INTO kfc_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","మరి యేసు ఈహు వెహ్తాన్‌, “దేవుణు వన్నిలోకురిఙ్‌ కినిఏలుబడిః ఇని దనివెట పోలిస్తెఙ్‌ ఆనాద్‌? మాటు ఎమేణి కతవజ అయాక నెస్‌పిస్తెఙ్‌ అట్నాట్‌? ");
INSERT INTO kfc_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","అయాక సర్సు గింజదిఙ్‌ పొలిత మనాద్‌. అక్క బూమిదు విత్తివలె లోకమ్‌దు మన్ని విజు విత్కాఙ్‌ లొఇ ఇజిరికాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ఆహిఙ్‌బా అక్క వితివలె నేర్‌జి పిరిసి విజు కుస మొక్కెఙలొఇ ‌పెరిక ఆనాద్. దన్ని కొమెఙ్‌ పెరికెఙ్‌ ఆనె. ఆగసమ్‌దు ఎగ్రిజిని పొటిఙ్‌ వాజి దన్ని నీడఃదు గూడుక్‌ తొహ్నినె”. ");
INSERT INTO kfc_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","వారు అర్‌దం కిదెఙ్‌ అట్ని నసొ దేవుణు మాటెఙ్‌ ముఙాల్‌ వెహ్తి లెకెండ్‌ కత వజ యేసు నండొ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","కత వజ ఆఎండ యేసు వరిఙ్‌ ఇనికబా నెస్‌పిస్‌ఏతాన్. అహిఙ యేసు వన్ని సిసూర్‌ వెట ఒరెండ్రె మహివలె విజు వన్కాఙ్‌ అర్‌దం కిజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ఆ పొదొయ్‌సమ్‌దరం అతాహ పడక సొనాట్‌ ఇజి యేసు సిసూర్‌ వెట వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","లోకాఙ్‌ డిఃసి యేసు మహి డోణిదు ఎక్సి సిసూరు వన్నిఙ్‌ ఒతార్. మరి సెగం డోణిఙ్‌బా వరి వెట మహె. ");
INSERT INTO kfc_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","వారు సొన్సి మహిఙ్‌ పెరి తుపాన్‌ వాతాద్‌. ‌ఉల్కెణ్‌ విజు డోణిదు డెఃయ్‌తె ఏరుడోణిదు నిండ్రితె. ");
INSERT INTO kfc_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","యేసు డోణి వెనుకపడక బుర్రగడిః ముస్కు నిద్ర కిజి మహాన్‌. సిసూరు వన్నిఙ్‌ నిక్సి, “బోదకినికి, మాటు విజు ముడఃగిజినాట్. నిఙి విసారం సిలెదా?”, ఇజి వన్నిఙ్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","యేసు నిఙ్‌జి గాలిదిఙ్‌ ఉల్కెఙ, పల్లక్‌ ఆదు ఇజి వెహ్తన్‌ పెరి గాలి అణస్తాద్‌ విజు అలెతాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","నస్తివలె వాండ్రు, “మీరు ఎందనిఙ్‌ తియెల్‌ఆజినిదెర్‌? మిఙి నా ముస్కు నమకం సిలెదా?”, ఇజి సిసూర్‌ వెట వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","వారు గొప్ప తియెలాతారె, “వీండ్రు ఎలాగ మహ్తికాండ్రొ గాని, గాలి సమ్‌దరమ్‌బా విన్ని మాటదిఙ్‌ లొఙిత్తె”, ఇజి ఒరెన్‌వెట మరి ఒరెన్‌ వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","యేసుని సిసూర్‌ సమ్‌దరం అతాహ పడక గెరసేను ఇని లోకురి ప్రాంతమ్‌దు వాతార్. ");
INSERT INTO kfc_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","యేసు డోణి డిఃగితి వెటనె దెయం అస్తికాన్‌ ఒరెన్‌ దూకిఙాణ్‌ ఎద్రు వాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","వాండ్రు దూకిఙాణిఙ్‌ బత్కిజి మహాన్‌ వన్నిఙ్‌ గొల్కుదాన్‌బా తొహ్తెఙ్‌ ఎయెర్‌బా అట్‌ఏర్. ");
INSERT INTO kfc_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","నండొ సుట్కు వన్ని కాల్కాఙ్‌ కిక్కాఙ్‌ గొల్‌స్కాణిఙ్ తొహ్తెఙ్‌బా వాండ్రు గొల్‌స్కు తెప్సి ముక్కెఙ్‌ కిత్తాన్. ఎయెరుబా వన్నిఙ్‌ సాదిస్తెఙ్‌ అట్‌ఏతార్. ");
INSERT INTO kfc_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","వాండ్రు ‌రెయుబా వెడెఃకబా దూకిఙాణ్‌ గొరొకాణ్‌ గగోలాజి వన్నిఙ్‌ వాండ్రె పణుకుఙాణ్‌ డెఃయె ఆజి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","వాండ్రు దూరమ్‌దాన్‌ యేసుఙ్‌ సుడ్ఃతాండ్రె ఉహ్‌క్సివాజి ముణుకుఙ్‌ ఊర్‌జి మాడిఃస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","విజు దన్నిఙ్‌ అతికారం ఆతి దేవుణు మరిసియాతి, యేసువా, నా వెట నిఙి ఇని పణి? నఙి బాద కిఏ ఇజి దేవుణు పేరు అసి నీను ఒట్టు కిఅ”, ఇజి డేల్సి వెహ్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ఎందానిఙ్‌ ఇహిఙ యేసు, ఓ దెయం, విన్నిఙ్‌ డిఃసి వెల్లి సొన్‌అ”, ఇజి వెహ్సి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","యేసు, “నీ పేరు ఇనిక? ఇజి వెన్‌బాతాన్. వెన్‌బాతిఙ్, నా పేరు సేన, ఇహిఙ మాపు నండొండార్‌ ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","మఙి యా దేసెమ్‌దాన్‌ ఉల్‌ప్మ ఇజి దెయం అస్తికాన్‌ యేసుఙ్‌ మరి మరి బతిమాలితాన్. ");
INSERT INTO kfc_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","అయావలె పండ్రిఙ్‌ మంద గొరొన్‌ సెల్కుదు మెయ్‌జి మహె. ");
INSERT INTO kfc_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ఆ దెయమ్‌కు, మఙి పండ్రిఙ లొఇబా పోక్‌అ. వనకలొఇ సొండ్రెఙ్‌ మఙి సెలువ సిదా”, ఇజి యేసుఙ్‌ బతిమాలితె. ");
INSERT INTO kfc_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","అందెఙె వాండ్రు వన్కాఙ్‌ సెలవ సిత్తాన్‌ అయావలె దెయమ్‌కు వన్నిఙ్‌ డిఃసినె పండ్రిఙలొఇ సొహె. అయపండ్రిఙ్‌ మంద విజు గొరొతాణ్‌ ఉహ్‌క్సి వాజి ఒడ్డుదాన్‌ సమ్‌దరమ్‌దు అర్తినె సాతె. అక్కెఙ్‌ డగ్రు రుండి వెయిఙ్‌ పండ్రిఙ్‌ మహె. ");
INSERT INTO kfc_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","పండ్రిఙ్ మేప్నికార్‌ ఉహ్‌క్సి సొన్సి పట్నమ్‌ది వరిఙ్‌ పట్నమ్‌ది వల్‌సెఙ మన్నివరిఙ్‌ జర్గితిక్కెఙ్‌ వెహ్తార్‌. లోకుర్‌ జర్‌తిక సుడ్ఃదెఙ్‌ సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","వారు యేసు డగ్రు వాతిఙ్‌ నండొ దెయమ్‌కు అస్తిమహికాన్‌ సొక్కెఙ్‌ తొడిఃగిజి నెగ్గి బుదిదాన్‌ అబ్బెబస్తిమహిక సుడ్ఃతార్. సుడ్ఃతారె తియెలాతార్. ");
INSERT INTO kfc_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","యాక సుడ్ఃతికార్‌ దెయమ్‌కు అస్తివన్నిఙ్‌ ఇనిక జర్గితాద్, పండ్రిఙ ఇనిక జర్గితాద్‌ ఇజి విజు లోకాఙ్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","అయవలె లోకుర్‌ యేసుఙ్, “మా ప్రాంతం డిఃసి సొన్‌అ”, ఇజి బతిమాలితార్. ");
INSERT INTO kfc_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","యేసు డోణి ఎక్తిఙ్‌ దెయమ్‌కు అస్తిమహికాన్‌ వన్ని డగ్రు వాతాండ్రె, నీ వెట నానుబా వాన ఇజి బతిమాలితాన్. ");
INSERT INTO kfc_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","గానియేసు సరి సిఏతాన్‌, నీను ఇండ్రొ సొన్సి ప్రబు నీ వందిఙ్‌ కిత్తి గొప్ప పణివందిఙ్‌ వాండ్రు నీ ముస్కు ఎలాగ కనికారం తోరిస్తాన్‌ ఇనివందిఙ్‌ వరిఙ్‌ వెహ్‌అ ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","వాండ్రు సొహాండ్రె యేసు వన్ని వందిఙ్‌కిత్తి గొప్ప పణిదెకపొలీదు వెహ్తెఙ్ ‌మొదొల్‌స్తాన్. అక్క వెంజి విజేరె బమ్మ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","యేసు డోణిదు ఎక్సి సమ్‌దరం అతాహ పడక మరి సొహాన్‌. నస్తివలె నండొ లోకుర్‌ వన్ని డగ్రు వాతార్. యేసు సమ్‌దరం ఒడ్డుదు నిహ మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","23","నస్తివెలె ఉండ్రి యూదురి మీటిఙ్‌ ఇండ్రొణి అతికారి యాయీరు ఇని ఒరెన్‌బానె వాతాన్. వాండ్రు యేసు డగ్రు వాజి వన్ని పాదమ్‌కాఙ్‌ మాడిఃస్తాండ్రె, నా ఇజ్రి గాలు సాజినాద్, దయకిజి నీను వాజి అది బత్కిని వజ దని ముస్కు కిక్కు ఇడ్ఃజి నెగెణ్‌ కిఅ, ఇజి బతిమాలితాన్. ");
INSERT INTO kfc_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","యేసు వన్నివెట సొహాన్‌. సేన లోకుర్‌ నెక్కె ఆజి యేసువెట సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","వరిలొఇ ఉండ్రి అయ్‌లి కొడొః మహాద్‌. అది పన్నెండు పండెఙాణ్‌ వెల్లి ఆని జబ్బుదాన్‌ బాద ఆజి మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","అది సేన డాక్టరుఙాబాన్‌ నెగెణ్‌ఆదెఙ్‌ సొహద్‌ గాని ఆ జబ్బు సొన్‌ ఏతాద్. అకాదె అఏండ దనిఙ్‌మని డబ్బు విజు కర్సు ఆతిఙ్‌బా ఆ జబు సొన్‌ఏండ మరి నండొ ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","అది యేసువందిఙ్‌ వెహా మహాద్‌. యేసు అయ సరిదాన్‌ వాజినాన్‌ ఇజి వెంజి యేసు తొడిఃగితి మన్ని నిర్రి సొక్క సెంగుదు ముట్తిఙసరి నెగెణ్‌ ఆన ఇజి ఒడ్ఃబితాద్. అది లోకుర్‌ వెట సొన్సి యేసు వెనుక వాతాదె వన్ని నీరిసొక్కది సెంగుదిఙ్‌ ముట్తాద్. ");
INSERT INTO kfc_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","వెటనె వెల్లి సోనిక నిహద్. దనిఙ్‌ మహి జబు డిఃస్తాద్‌ ఇజి అది నెస్తాద్. ");
INSERT INTO kfc_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","వన్నిలొఇహన్‌ దేవుణు సత్తు వెల్లి సొహాద్‌ ఇజి యేసుఙ్‌‌ తెలితాద్. వెటనె వాండ్రు లోకురిఙ్‌ మర్‌జి సు‌డ్ఃజి, ఎయెర్‌ నా సొక్కదు ముట్తాన్‌? ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","దన్ని సిసూర్, సేన లోకుర్‌నెకె ఆజి నిఙి ముట్సినార్‌ గదె. ఆహె ఆతిఙ్‌బా నఙి ఎయెరొ ముట్తార్‌ ఇజి ఎందనిఙ్‌ వెహ్సిని? ఇజి యేసుఙ్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","నఙి ముట్తికాన్ ఎయెండ్రొ ఇజి వరివందిఙ్‌ యేసు సురుల సుడ్ఃజి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","అయవలె అయ బోదెలి అది నెగెణ్‌ ఆతిక నెసి నండొ ‌తియెల్‌ ఆజి వన్నిపాదమ్‌కుఙ్‌ మూడికుఙ్‌ ఊర్‌జి వఙితాద్‌. దన్నిఙ్‌ జర్గితిక విజు వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","యేసు దనిఙ్, బయి నీను నా ముస్కు నమకం ఇడ్తి అందెఙె నీను నెగెణ్‌ ఆతి. సమదనమ్‌దాన్‌ సొన్‌అ. నీను నెగెండ్‌ ఆతి ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","యేసు వర్జిజిమహిఙ్‌ యాయీరు ఇండ్రొణిఙ్‌ సెగొండార్‌ వాజి, నీ గాలు సాతాద్. బోదకిని వన్నిఙ్‌ యేలు బాద కిదెఙ్‌ అక్కర్‌ సిల్లెద్‌ ఇజి యాయీరుఙ్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","వారు వెహ్తిక వెన్‌ఇవజ యేసు అయ అతికారిఙ్, తియెల్‌ఆమ, నా ముస్కు నమకం ఉండ్రె ఇడ్ఃఅ ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","యేసు పేతురు, యాకోబు, యాకోబు తంబెర్సి యోహాను మరి ఎయెఙ్‌బా వన్నివెట ఒఏతాన్. ");
INSERT INTO kfc_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","వారు యూదురి మీటిఙ్‌ ఇల్లు ఆతికారి ఇండ్రొ సొహార్‌. అయావలె అబ్బె లోకుర్‌ గగోలాజి అడఃబాజి మహిక సుడ్ఃతార్. ");
INSERT INTO kfc_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","యేసు ఇలు లొఇ సొన్సి వరిఙ్‌ వెహ్తాన్‌, మీరు ఎందనిఙ్‌ గగోలాజి అడఃబాజినిదెర్‌? యా ఇజ్రికాద్‌ సాఏద్‌ ఇది నిద్ర కిజినాద్. ");
INSERT INTO kfc_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","వారు యేసుఙ్‌ వెక్రసి సికితార్. యేసు అడఃబాజి మహి లోకాఙ్‌ విజేరిఙ్‌ వెల్లి పోక్తాన్. వెల్లి పోక్సి, అయ్‌సి అపొసిరిఙ్, వన్నివెట మహి సిసూరిఙ్‌ అసి యేసు ఆ ఇజ్రికాద్‌ మహి గదిదు సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ఆ ఇజ్రిదన్నిఙ్‌ కీదు అస్తాండ్రె, తలీత కుమి ఇజి వెహ్తాన్‌. అయ మాటదిఙ్‌ అర్దం ఇనిక ఇహిఙ ఇజ్రి అయ్‌లి నిఙ్‌అ ఇజి నాను నీ వెట వెహ్సిన ఇజి, ");
INSERT INTO kfc_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","అయ్‌లి వెటనె నిఙ్‌జి నడిఃతాద్. దనిఙ్‌పన్నెండు పండెఙ్‌వయసు. అబ్బె జర్గితిక సుడ్ఃతారె అయ్‌సి అపోసీరు, సిసూరు బమ్మ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","జర్గితిక ఎయెఙ్‌బా వెహ్మట్‌ ఇజి యేసు వరిఙ్‌ కసితం ఆడ్ర సితాన్‌. దన్నిఙ్‌ బోజనం సీదు ఇజి అయ్‌సి అప్పొసిరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","యేసు అబ్బెణాన్‌ వన్ని సొంత పట్నమాతి నజరేతు సొహాన్‌. సిసూర్‌బా వన్ని వెట సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","3","విస్రాంతి దినమ్‌దు వాండ్రు యూదురి మీటిఙ్‌ ఇండ్రొ నేర్‌పిస్తెఙ్‌ మొదొల్‌స్తాన్. అక్క వెహికార్‌ నండొండార్‌ బమ్మ ఆజి, వీండ్రు ఎమేణిఙ్‌ నెస్తాన్‌? విన్నిఙ్‌ నిన్ని గెణం ఎమేణిఙ్‌ దొహ్‌క్తాద్‌? వీండ్రు బమ్మాని పణిఙ్‌ కిజినాన్. వీండ్రు మాపు నెసిని కంసెల్‌ వాండ్రు‌ గదె. వీండ్రు మరియమ్మ మరిసిగదె. యాకోబు, యోసె, యూద, సీమోను, విని తంబెర్సిర్‌ గదె. విన్ని తఙిసిక్‌ మా వెట మన్నెగదె. ఇజి వెహ్తర్‌. వారు వన్నిముస్కు కోపమాజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","దన్నిఙ్‌ యేసు ఇనిక ఇజి వెహ్తాన్‌‌ ఇహిఙ, ఒరెన్‌ ప్రవక్తెఙ్‌ సొంత పట్నమ్‌దు, సొంత ఇండ్రొ, సొంత కుటుమ్‌దివరిబాన్‌ గవ్‌రం సిల్లెద్‌. మరి ఎంబె సొహిఙ్‌బా వన్నిఙ్‌ గవ్‌రం మనాద్. ");
INSERT INTO kfc_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","సెగొండార్‌ జబ్బు ఆతివరిఙ్‌ కియుదాన్‌ ముట్సి నెగెణ్‌ కిత్తాన్‌ గాని అబ్బె నండొ బమ్మాతి పణికిదెఙ్‌ యేసు అట్‌ఏతాన్. ");
INSERT INTO kfc_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","వన్ని ముస్కు వరిఙ్‌ నమకం సిల్లిదిఙ్‌ వాండ్రు బమ్మ ఆతాన్. యేసు సురుల మన్ని నాహ్కఙ్‌ బూలాజి నేర్‌పిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","యేసు పన్నెండు మణిసిర్‌ సిసూరిఙ్‌ వన్ని డగ్రు కూక్తాండ్రె రిఎరిఙ్‌ రిఎరిఙ్‌ పోక్తాన్. వరిఙ్‌ దెయమ్‌కాఙ్‌ పేర్‌దెఙ్‌ అతికారం సిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","మీరు ప్రయ్‌నం కినివెలె కియుదు ఉండ్రి డుడ్డునె ఒత్తెఙ్. బోజనం గాని సన్సి గాని డబ్బు గాని ఒత్తెఙ్‌ ఆఏద్‌. సొండ్రెఙ్‌ కాల్కాఙ్‌ జోడ్కు ఒత్తగాని, పొర్‌పాదెఙ్‌ రుండి సొక్కెఙ్‌ ఒమాట్”, ఇజి యేసు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","మీరు ఎయె ఇండ్రొ సొనిదెరొ, అయ పట్నం డిఃస్నిదాక బానె మండ్రు. ");
INSERT INTO kfc_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ఎంబెబా మిఙి లోకుర్‌ డగ్రు కిఏండ మహిఙ మీ మాట వెండ్రెఙ్‌ కెఇతిఙ, అబ్బెణిఙ్‌ మీరు డిఃసి సొనివెలె మీ పాదమ్‌క డుల్లి దులుప్తు. వరిముస్కు వారె దేవుణుబాణిఙ్‌ సిక్సి తప్పె ఆజినార్‌ ఇన్నిదన్నిఙ్‌ గుర్తులెకెండ్‌ ఆహె డుల్లి దులుప్తు”. ");
INSERT INTO kfc_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","సిసూర్‌సొన్సి లోకాఙ్, పాపమ్‌కు డిఃస్తు ఇజి బోదిస్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","లోకురిఙ్‌ అస్తి నండొ దెయమ్‌కాఙ్‌ పేర్‌జి, జబ్బు ఆతి నండొండారిఙ్‌ నూనె రాసి నెగెండ్‌ కిత్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","యేసు పేరు విజుబాన్‌ సార్‌త సొహాద్. అందెఙె యేసు కిత్తి గొప్ప పణిఙవందిఙ్‌ హేరోదురాజు వెహాన్‌. సెగొండార్‌ ఇనిక వెహ్తార్‌ ఇహిఙ “వీండ్రు సాతివరిబాణిఙ్‌ మర్‌జి నిఙితి బాప్తిసం సీని యెహాను అందెఙె యా బమ్మాతి పణిఙ్‌ కిదెఙ్‌ సత్తు వన్నిలొఇ మంజినాద్” ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","సెగొండార్‌ వీండ్రు ఏలియ ప్రవక్త ఇహార్‌. మరి సెగొండార్‌ వీండ్రు ముఙల్‌ మహి దేవుణు ప్రవక్తలొఇ ఒరెన్‌ ప్రవక్త వజ మనాన్‌ ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","హేరోదురాజు యాక విజు వెంజి నాను బుర డెఃయిస్తి యోహను నిఙ్‌జి బత్కితికాండ్రె యేసు ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","హేరోదురాజు ఎందానిఙ్‌ ఈహు వెహ్తాన్‌‌ ఇహిఙ, వాండ్రు వన్ని తంబెర్‌సియాతి పిలిపు ఆల్‌సి హేరోదియెఙ్‌ తతాన్. యోహాను హేరోదుఙ్‌, నీ తంబెర్సి ఆల్‌సిఙ్‌ నీవందిఙ్‌ ఇడె ఆతిక దేవుణు మోసెఙ్‌ సిత్తి రూలుదిఙ్‌ పడిఃఏద్‌ ఇజి వెహ్తాన్‌. అందెఙె దన్ని వందిఙ్‌ వాండ్రు యోహనుఙ్‌ అసి తొహ్తండ్రె జెలిదు ఇడిస్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","అందెఙె హేరోదియ యోహను ముస్కు పగదాన్‌ మహాద్‌. వన్నిఙ్‌ సపిస్తెఙ్‌ సుడ్ఃతాద్‌ గాని అట్‌ఏతాద్. ");
INSERT INTO kfc_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ఎందానిఙ్‌ ఇహిఙ హేరోదు యోహనుఙ్‌ తియెలాతాన్‌. వాండ్రు ఒరెన్‌ నీతి నిజాయితి మన్నికాన్ ఇజి దేవుణు కేటాకాన్‌ ఇజి, హెరోదు రాజు నెస్తాన్. అందెఙె జెలిదు ఇడ్జి కాపాడజి మహాన్‌. యోహను వెహ్తి మాటెఙ్‌ వెహివలె హేరోదురాజు అర్‌దం కిదెఙ్‌ అట్‌ఏతాన్‌ గాని సర్దదాన్ వెంజి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","అహిఙ యోహానుఙ్‌ సపిస్తెఙ్‌ హెరోదియెఙ్‌ ఉండ్రి అవ్‌కాసం వాతాద్. అక్క ఎలాగ ఇహిఙ హేరోదురాజు వాండ్రు పుట్తిరోజు గుర్తు కిదెఙ్‌ అయానాండిఙ్‌ ఉండ్రి పెరి విందు కితాన్. వాండ్రు గవ్‌రుమెంటు అదికారిఙ, సయ్నమ్‌ది వరిలొఇ పెరి అతికారి గలీలయ దేసెమ్‌ది పెద్దెల్‌ఙ విజేరిఙ్‌ విందుదిఙ్‌ కూక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","23","నస్తివలె హెరోదియ గాల్‌సి విందుదిఙ్‌ వాతి వరిఙ్‌ సర్ద కిబిస్తెఙ్‌ వరి ముఙాల డాట్సి కర్‌జితాద్. అక్క సుడిఃతారె విజేరె సర్ద ఆతార్. సర్ద ఆతిఙ్‌ హేరోదురాజు, నిఙి ఇస్టమాతిక ఇనికబా నఙి లొస్‌అ, అక్క నాను నిఙి సీన, ఇజి దనివెట ఒట్టు కితాన్. ");
INSERT INTO kfc_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","అది సొన్సి అయ్‌సివెట, నాను రాజుఙ్‌ ఇనిక లొస్తెఙ్‌ ఇజి వెన్‌బాతాన్. అయ్‌సి, బాప్తిసం సీని యోహాను బుర లొస్‌అ ఇజి వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","వెటనె అది రాజు డగ్రు సొన్సి బాప్తిసం సీని యోహాను బుర కత్సి ఉండ్రి పల్లెమ్‌దు ఇడ్ఃజి ఏలె నఙి తసిసిదా ఇజి వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","అక్క వెహాండ్రె హేరోదురాజు గొప్ప బాద ఆతాన్‌ గాని, వాండ్రు కిత్తి ఒట్టువందిఙ్‌ వన్నివెట బోజనమ్‌దిఙ్‌ బస్తిమహి కూలెఙ వందిఙ్‌ దన్నివెట కిత్తి మాట తప్తెఙ్‌ కెఏతాన్‌, ఇజి వెహ్తెఙ్‌ అట్‌ఏతాన్. ");
INSERT INTO kfc_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","28","వెటనె రాజు యోహాను బుర కత్సి తగ్‌అ ఇజి జమానుఙ్‌ ఆడ్ర సీజి పోక్తాన్. జమాను జెలిదు సొన్సి యోహాను బుర కతాండ్రె ఉండ్రి పల్లెమ్‌దు ఇడ్ఃజి తత్తాండ్రె అయ్‌లిదిఙ్‌ సిత్తాన్. అది ఆ బుర అయ్‌సిఙ్‌ సిత్తాద్. ");
INSERT INTO kfc_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","జర్గితిక వెంజి యోహాను సిసూర్‌ వాజి ఆ పీనుగుదిఙ్‌ పెర్‌జి ఒసి సమాది కిత్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","అపొస్తురు మర్‌జివాతాజి వారు కిత్తి పణిఙ్‌ విజు, బోదిస్తి వన్కాఙ్‌వందిఙ్‌ విజు యేసుఙ్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","నస్తివలె యేసు “ఎయెరు సిల్లిబాన్‌ మాటె సొన్సి సణెం రోమ్నాట్, ఇజి సిసూర్‌వెట వెహ్తాన్‌. ఎందానిఙ్‌ ఇహిఙ నండొ లోకుర్‌ వాదెఙ్‌ సొండ్రెఙ్‌ ఆతార్. బోజనం కిదెఙ్‌బా కాలి సిల్లెండ ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","అందెఙె వారు ఉండ్రి డోణి ఎక్సి ఎయెర్‌బా మన్‌ఇ బాడ్డిదు వారె సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","యేసుని, సిసూర్‌ సొన్సిమహిఙ్‌ నండొ లోకుర్‌వరిఙ్‌ సుడ్ఃతారె వరిఙ్‌గుర్తు అసి విజు పట్నమ్‌కాణ్‌ ఉహ్‌క్సి వరిఙ్‌ ఇంక ముఙాల బాన్‌ సొహారె అందితార్. ");
INSERT INTO kfc_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","యేసు డోణిదాన్‌ డిగితివలె మహి నండొ లోకాఙ్‌సుడ్ఃజి వన్ని పాణం నొత్తాద్‌. ఎందానిఙ్‌ ఇహిఙ వారు గవ్‌డుయెన్‌ సిల్లి సెద్రితి గొర్రెఙ్‌లెకెండ్‌ మహార్‌. అందెఙె యేసు వరిఙ్‌ నండొ సఙతిఙ్‌ నెస్‌పిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","యేసు నెర్‌పిసి మహిఙ్‌ పొద్దుఆజి మహాద్‌. సిసూర్‌ వన్నిడగ్రు వాజి యాక ఎయెరు మన్‌ఇ బాడ్డి. ఏలె పొద్దు ఆజినాద్. పడకాద్‌ మన్ని నాహ్కఙ్‌ వల్‌సెఙ సొన్సి బోజనం కొండెఙ్‌ విరిఙ్‌ పోకఅ. ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","గాని యేసు సిసూరిఙ్‌ మీరె వరిఙ్‌ తిండ్రెఙ్‌ ఇనికబా సీదు”, ఇజి వెహ్తాన్‌. దన్నిఙ్‌ వారు మాపు సొన్సి రుండి వంద దెనారిదిఙ్‌ రొట్టెఙ్‌ కొడ్ఃజి తత్తెఙ్‌బా నిస్సొ లోకురిఙ్‌ సాల్‌ఏద్‌ ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","మీబాన్‌ ఎస్సొడు రొట్టెఙ్‌ మన్నె? సొన్సి సుడ్ఃదు”, ఇజి యేసు సిసూరిఙ్‌ వెహ్తాన్‌. వారు సొన్సి సుడ్ఃతారె అయ్‌దు రొట్టెఙ్‌ రుండి మొయెఙ్‌ మన్నె ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","విజేరిఙ్‌ పసిగడ్డి మన్నిబాన్‌ గుంపుఙ్‌లెకెండ్‌ బసెకిదు ఇజి యేసు సిసూరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","లోకుర్‌ యాపయ్‌ మనిసిర్, గుంపుఙ్‌ వంద మనిసిర్‌ గుంపుఙ్‌ బస్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","అయవలె యేసు అయ్‌దు రొట్టెఙ్, రుండి మొయెఙ్‌ అసి, ఆగసం దరోట్‌ సుడ్ఃజి వనకవందిఙ్‌ దేవుణుదిఙ్‌ వందనమ్‌కు వెహ్తాన్. వెహ్తాండ్రె రొట్టెఙ్‌ రుక్సి‌ లోకురిఙ్‌ సీబాజి సీదు ఇజి వెహ్సి సిసూర్‌ఙ్‌ సిత్తాన్. అయ మొయెఙ్‌బా విజేరిఙ్‌ సీబాజి సీదు ఇజి సిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","వారు విజేరె పొట పంజు తిహార్. ");
INSERT INTO kfc_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","మిగిలిత్తి రొట్టె ముక్కెఙ్, మరి మొయెఙ్‌ ముక్కెఙ్‌ పన్నెండు గంపెఙ్‌ సిసూర్‌ కెహ్తర్. ");
INSERT INTO kfc_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","రొట్టెఙ్‌ తిహికార్‌ మొగవారె అయ్‌దువెయిఙ్‌ లోకుర్ మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","యేసు లోకాఙ్‌ పోక్సి వెనుక వెటనె సిసూరిఙ్‌ ‌డోణిదు ఎకిసి అతాహపడఃక బేత్సయిద ఇని నాటొ వన్నిఙ్‌ ఇంక ముఙాల్‌ సొండ్రు ఇజి వెహ్సి పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","వరిఙ్‌ పోక్సి యేసు పార్దనం కిదెఙ్‌ గొరొత్‌ ఒరెండ్రె మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","పొద్దు ఆతివలె డోణి సమ్‌దరం నడిఃమి మహాద్‌, యేసు గొరొత్‌ ఒరెండ్రె మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","గాలి ఎద్రు డెఃయ్తిఙ్‌ డోణి నడ్ఃపిస్తెఙ్‌ సిసూరిఙ్‌ గొప్ప కస్టం ఆత్తాద్. అక్క యేసు సుడ్ఃతాన్. కోడిజం ఆజిమహిఙ్‌ యేసు సమ్‌దరం ముస్కు నడిఃజి వాతాండ్రె సిసూర్‌మన్ని డోణి డాట్సిసొండ్రెఙ్‌ నడిఃసి వాతాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","యేసు సమ్‌దరం ముస్కు నడిఃజినిక సిసూర్‌సుడ్ఃతారె అక ఉండ్రి దూబ ఇజి ఒడిఃబితార్. వారు డటం గగోల్‌ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","అక్క దూబసు ఇజి వారు నండొ తియెలాతార్. వెటనె యేసు వరివెట, “సమ్‌దరమ్‌దాన్ మండ్రు ఇక్క నానె తియెలామ”, ఇజి వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","నస్తివలె యేసు వరివెట డోణిదు ఎక్తాన్. గాలి విజు అణస్తాద్. వారు నండొ బమ్మ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","యేసు అయ్‌దు రొట్టెఙ్‌ రుండి మొయెఙాణ్‌ అయ్‌దువెయిఙ్‌ లోకాఙ్‌ బోజనం సిత్తిక సుడ్ఃతిఙ్‌బ యేసు కిత్తి అయా బమ్మాతి పణివందిఙ్ అర్దం కి‌ఏతార్. ఎందానిఙ్‌ ఇహిఙ వరి మన్సు గట్టిఙ్‌ మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","వారు సమ్‌దరం డాట్సి గెనేసెరెతు ఇనిబాన్‌వాతారె డోణి అబ్బె తొహ్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","వారు డోణి డిఃగితిఙ్‌ సరి లోకుర్‌ యేసుఙ్‌ గుర్తు అస్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","వెటనె ఆ దేసెమ్‌ది నాహ్కణికార్‌ విజేరె సొన్సి జబ్బు ఆతివరిఙ్‌ యేసు మనాన్‌ ఇజి వెహి బాడిఃదు సాపాదు పిండ్జి తత్తెఙ్‌ మొదొ ల్‌స్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","యేసు నాహ్కఙ్‌ పట్నమ్‌కాఙ్‌ ఎంబె సొహిఙ్‌బా లోకుర్‌ జబ్బు ఆతివరిఙ్‌ యేసు వాని సర్దు తత్త ఇడ్ఃతార్. యా జబ్బుఆతికార్‌ నీ సొక్క సెంగుదుబా ముట్తెఙ్‌ సెల్వ సిదా ఇజి బతిమాల్‌జి యేసుఙ్‌ మరి మరి వెహ్తార్‌. ఎస్సొండార్‌ వన్ని సొక్కదిఙ్‌ ముట్తితారొ వారు విజేరె నెగెండ్‌ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","2","యెరూసలేమ్‌దాన్‌ వాతి పరిసయ్‌రుని, యూదురి రూలు నెస్పిసినికార్‌ సెంగొండార్ యేసుబాన్‌ కూడ్ఃజి వాతార్. యేసు సిసూర్‌ యూదురుఙ రూలుదు వెహ్తిలెకెండ్‌ కిక్కు నొర్‌బఏండ బోజనం ఉణిజి మహిక వారు అబ్బె సుడ్ఃతార్. అక్క పరిసయ్‌రు సుడిఃతిఙ తప్ప. ");
INSERT INTO kfc_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","పరిసయ్‌రు, యూదురు, విజేరె, పూర్‌బమ్‌దికార్‌ వెహ్తిరూలు వజ కిక్కు నొర్‌బాతి వెన్‌కనె ఊణార్. ");
INSERT INTO kfc_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","వారు సత్తదాన్‌ వాతిఙ, రూలువజ ఏరు లొంజె ఆఏండ ఇనికబా ఉణ్‌ఏర్. ఇక్కాదె ఆఏండ గిన్నెఙ్‌ కుండెఙ్‌ మరి కంసు బిందెఙ్‌ ఎలాగ‌ మిడిఃస్తెఙ్‌ ఇజి నండొ రూలుఙ్‌ వరిఙ్‌ మన్నె. ఆ రూలుఙ్‌వజ వారు కిజినార్. ");
INSERT INTO kfc_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","అందెఙె పరిసయ్‌రుని, యూదుర్‌ రూలుఙ్‌ నెస్‌పిసినికార్‌, “ఎందానిఙ్‌ నీ సిసూర్‌ పూర్‌బమ్‌దికార్‌ వెహ్తి రూలువజ నడిఃఏండాజినార్ ఎందానిఙ్‌ వారు కిక్కు నొర్‌బఏండ బోజనం కిజినార్‌”, ఇజి యేసుఙ్‌ వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","యేసు వరిఙ్, “వేసం కినికారాతి మీ వందిఙ్‌ యెసయ ప్రవక్త ఎహ్తిక నిజమె. యా లోకుర్‌ నఙి వెయుదాన్‌ గవ్‌రం సీజినార్‌ గాని వరి మన్సు నాబాణిఙ్‌ దూరం మనాద్. వారు నఙి పొగ్‌డిఃజి మాడిఃసినార్‌ గాని అక్క పణిదిఙ్‌ రెఏద్‌. ఎందానిఙ్‌ ఇహిఙ వారు లోకుర్‌ వెహ్తి రూలు దేవుణు మాట ఇజి లోకాఙ్‌ నెస్పిసినార్. ");
INSERT INTO kfc_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","దేవుణు వెహ్తి రూలు డిఃసిసీజి, మీరు పూర్‌బమ్‌దికార్‌ వెహ్తి రూలువజ నడిఃజినిదెర్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","యేసు వరిఙ్‌ మరి వెహ్తాన్‌, “పూర్‌బమ్‌దికార్‌ వెహ్తివజ నడిఃదెఙ్, ఇజి దేవుణు ఆడ్రెఙ్‌ పడఃకాదు నెక్తెఙ్‌ మిఙి బాగ తెలినాద్. ");
INSERT INTO kfc_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ఎలాగ ఇహిఙ మీ యాయ బుబ్బరిఙ్‌ గవ్‌రం సీజి బాగ సుడ్‌దెఙ్ ఇజి యాయెఙ్‌ గాని బుబ్బెఙ్‌ గాని దూసిస్తిఙ వన్నిఙ్‌ సప్తెఙ్ ఇజి దేవుణు మోసెఙ్‌ సిత్తి రూలు మనాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","గాని ఒరెన్‌ వన్ని అయ్‌సి అపొసిరిఙ్, నాను మిఙి ఇనికబా ఉండ్రి సాయమ్‌లెకెండ్‌ కిన ఇజి ఇడ్తిమన్నిక కొర్‌బాన్‌ ఇజి వెహ్తిఙ నాండిఙ్‌ అసి వాండ్రు అయ్‌సి అప్పొసిరిఙ్‌ ఇనికబా సాయం కిదెఙ్‌ అవ్‌సరం సిల్లెద్‌ ఇజి మీరు నెస్‌పిసినిదెర్. (కొర్‌బాన్‌ ఇహిఙ దేవుణుదిఙ్‌ సీన ఇజి ఒట్టు కినిక ఇజి అర్దం) ");
INSERT INTO kfc_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ఈహు మీ పూర్‌బమ్‌దికార్‌ వెహ్తివజ నడిఃజి మీరు దేవుణు వెహ్తి రూలుదిఙ విలువ సిల్లెండ కిజినిదెర్. నిన్ని సఙతిఙ్‌ నండొ మిరు కిజినిదెర్”. ");
INSERT INTO kfc_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","యేసు లోకాఙ్‌ మరి వన్నిడగ్రు కూక్తాండ్రె “నాను వెహ్సినిక మీరు విజిదెరె జాగర్తవెంజి నెగెండ్‌ అర్‌దం కిదు. ");
INSERT INTO kfc_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","వెయుదాన్‌ లొఇ సొనికెఙ్‌ ఇనికబా లోకాఙ్‌ మయ్ల కిదెఙ్‌ అట్‌ఏద్. గాని మన్సు లొఇహాన్‌‌ వెల్లి వానికదె లోకాఙ్‌ సెఏణ్‌ కిజినాద్”. ");
INSERT INTO kfc_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","యేసు లోకాఙ్‌ డిఃసి ఇండ్రొ వాతివెనుక వన్ని సిసూర్, కతవజ వెహ్తి దన్నిఙ్‌ అర్దం వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","యేసు వరిఙ్‌ ఈహు వెహ్తాన్‌ “మీరుబా ఆఇవరిలెకెండ్‌ అర్దం కిదెఙ్‌ ఆట్‌ఇదెరా? వెల్లిహన్‌ పొటలొఇ సొని ఇని బోజనమ్‌బా లోకాఙ్‌ మయ్ల కిఏద్. ఎందనిఙ్‌ ఇహిఙ అక్క మన్సుదు సొన్‌ఏండ వన్ని పొటాదునె సొన్సినాద్. అక్క పొటదాన్‌ బయ్‌లు బస్నివలె వెల్లి సొన్సినాద్. ఇజి మీరు నెస్‌నిదెర్”. (ఇబ్బె సుడ్ఃతి ఇని బోజెనమ్‌బా ఉండెఙ్‌ ఆనాద్‌ ఇజి యేసు సెలవ సిత్తాన్) ");
INSERT INTO kfc_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","మరి యేసు వెహ్తాన్‌, ఒరెన్‌ వన్ని మన్సులొఇహాన్‌‌ వెల్లి వానికదె వన్నిఙ్‌ మయ్ల కిజినాద్. ");
INSERT INTO kfc_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","మన్సులొఇహాన్‌ ‌వానిక ఇనికెఙ్‌ ఇహిఙ, సెఇ ఆలోసనమ్‌కు, కెలార్‌బూలానిక, లోకాఙ్‌ సప్నికెఙ్, రంకు బూలానిక, ఆఇవరిఙ్‌ మన్నికెఙ్‌ దొహ్‌క్తెఙ్‌ ఇజి ఆస, సెఇ పణి కినిక, మొసెం కినిక, మన్సుదు అనసె ఆజి మండ్రెఙ్‌ అట్‌ఇక, గోస దూసిసినిక, నానె పెరికాన్‌ ఇజి గర్ర ఆనిక, అర్దం కిఇ మన్సు మన్నిక. ");
INSERT INTO kfc_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","యాక్కెఙ్‌ విజు లోకుర్‌ మన్సులొఇహాన్‌‌ వెల్లి వాజి ఒరెన్‌ వన్నిఙ్‌ మయ్ల కినె. ");
INSERT INTO kfc_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","యేసు అబెణిఙ్‌ నండొ దూరం సొన్సి ఉండ్రి గొరొన్‌ ఎక్సి డిఃగితాండ్రె తూరు సీదోను ఇని పట్నమ్‌కాఙ్‌ డగ్రు మన్ని ముటెఙ సొహాన్‌. బానెఉండ్రి ఇండ్రొ సొన్సి ఎయెఙ్‌బా తెలిఏండ మంజిన ఇజి మన్సుదు ఒడ్ఃబితాన్. గాని వాండ్రు అట్‌ఏతాన్. ");
INSERT INTO kfc_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","యూదురు ఆఇ జాతిదు పుట్తి సురోపెకొనియదికాద్‌ ఉండ్రి అయ్‌లి కొడొః యేసు అబ్బె మనాన్‌ ఇజి వెంజి వెటనె అబ్బె వాతాదె యేసు పాదమ్‌కాఙ్‌ అర్తాదె మాడిఃస్తాద్. దన్ని గాల్సిఙ్‌ దెయం అస్త మహాద్‌. “నా గాలుఙ్‌ అస్తిమన్ని దెయమ్‌దిఙ్‌ ఉల్‌ప్‌అ”, ఇజి యేసుఙ్‌ బతిమాలితాద్. ");
INSERT INTO kfc_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","దన్నిఙ్‌ యేసు, “ముఙాల్‌ కొడొఃరిఙ్‌ పొట పంజు బోజనం తీపిస్తెఙ్‌. కొడొఃర్‌ తిండ్రెఙ్‌ మన్ని రొట్టెఙ్‌ లాగ్‌జి నుకుడిఃఙ్ సీనిక తగ్ఏద్‌”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","అది, “ప్రబు, నీను వెహ్తిక నిజమె. గాని నుకుడిఃఙ్‌బా కొడొఃర్‌ ఉణిజి బల్ల అడిఃగి అర్‌ప్తిక ఉణిజినె గదె ఇజి వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","యేసు, నీను బాగ వెహ్తి. నీను ఇండ్రొ సొన్‌అ. ఆ దెయం నీ గాలుఙ్‌ డిఃస్త సొహద్‌ ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","అది ఇండ్రొ సొన్సి సుడ్ఃతిఙ్‌ గాల్సి మన్సం ముస్కు గూర్త మహాద్‌. దెయెం దనిఙ్‌ డిఃస్త సొహద్. ");
INSERT INTO kfc_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","యేసు తూరు ప్రాంతం డిఃసి, సీదోను, దెకపొలి ప్రాంతమ్‌దాన్‌ గలీలయ సమ్‌దరం డగ్రు వాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","నస్తివలె బొయ్‌ర నతియాతి ఒరెన్‌వన్నిఙ్‌ సెగొండార్‌ యేసుబాన్‌ తత్తార్. “విన్ని ముస్కు కియు ఇడ్ఃజి నెగెండ్‌ కిఅ”, ఇజి బతిమాల్‌జి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","యేసు లోకుర్‌బాణిఙ్‌ వన్నిఙ్‌ అఙ ఒసి, డెఃస్కెఙ్‌ వన్ని గిబ్బిదు ఇడ్తాన్. వన్ని సొంత డెఃస్కాదు పూస్తాండ్రె గుల్ల వన్నిఙ్‌ నాలికాదు ముట్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ముట్తాండ్రె ఆగసం దరోట్‌ దేవుణుదిఙ్‌ సుడ్ఃజి ఉసుర్‌ గొటాండ్రె బాదఆజి ఎపాత ఇజి వెహ్తాన్‌. దని అర్దం ఇనిక ఇహిఙ రే ఆదెఙ్ ఇజి. ");
INSERT INTO kfc_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","వెటనె వన్నిగిబ్బిఙ్‌ వెండ్రెఙ్, వన్ని నాలిక వర్గిదెఙ్‌ వాతాద్. వాండ్రు బాగ వర్గిదెఙ్‌ మొదొల్‌స్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","“ఎయెవెట వెహ్మట్‌”, ఇజి యేసువరిఙ్‌ కసితం వెహ్తాన్‌. నా వందిఙ్‌ వెహ్మట్‌ ఇజి నండొ వెహ్తిఙ్‌బా అలెఏండ వారు యేసువందిఙ్‌ మరి నండొ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","యేసు విజు బాగ కిత్తాన్. బొయ్‌రవన్నిఙ్‌బా వెనివజ, గుల్లవన్నిఙ్‌బా వర్గినివజ కిజినాన్‌ ఇజి వారు వెహ్తరె బమ్మ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","ఆ దినమ్‌కాఙ్‌ మరి ఒర్సు నండొ లోకుర్‌ కూడ్జి వాతార్. వరిఙ్‌ ఉండెఙ్‌ బోజనం ఇనికబా సిలిఙ్‌ యేసు వన్ని సిసూర్‌ఙ కూక్తాండ్రె వెహ్తాన్‌, నఙి యా లోకుర్‌ నావెట వాజి మూండ్రి రోస్కు ఆతె. వరిఙ్‌ తిండ్రెఙ్‌ ఇనికబా సిల్లెద్‌. అందెఙె విరి వందిఙ్‌ నా పాణం నోజిన. ");
INSERT INTO kfc_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","విరిఙ్‌ నాను బోజనం సిఏండ ఇల్కాఙ్‌ పోక్తిఙ కణుకు తర్‌వ్‌జి సర్దు అర్నార్. ఎందనిఙ్‌ ఇహిఙ వరిలొఇ సెగొండార్‌ నండొ దూరమ్‌దాన్‌ వాత మనార్‌”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","అయవలె వన్ని సిసూర్‌ వెహ్తార్‌, బిడిఃమ్‌బూమిదు విరిఙ్‌విజేరిఙ్‌ బోజనం సీదెఙ్‌ ఎమేణిఙ్‌ తతెఙ్‌? ");
INSERT INTO kfc_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","మీ బాన్‌ఎసోడు రొటెఙ్‌ మన్నె? ఇజి యేసు సిసూరిఙ్‌ వెన్‌బాతాన్. మా బాన్‌ఏడు మన్నె ఇజి సిసూర్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","అయవలె యేసు లోకాఙ్‌ బూమిదు బస్తు ఇజి వెహ్తాన్‌. ఆ ఏడు రొట్టెఙ్‌అసి దేవుణుదిఙ్‌ వందనమ్‌కు కితాండ్రె. వన్కాఙ్‌ రుక్సి‌ లోకాఙ్‌ సీబాజి సీదెఙ్‌ సిసూరిఙ్‌ సిత్తాన్. వారు లోకాఙ్‌ సీబాజి సిత్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","వరిబాన్‌ సెగం ఇజ్రి మొయెఙ్‌బా మహె. యేసు వన్కాఙ్‌బా వందనమ్‌కు వెహ్సి సీబాజి సీదు ఇజి సిసూరిఙ్‌ సిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","లోకుర్‌ విజెరె పొట పంజు తిహర్. వెనుక సిసూర్‌ మిగ్లితి రొట్టె ముక్కెఙ్‌ ఏడుః గపెఙ్‌ కెహ్తర్. ");
INSERT INTO kfc_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","10","డగ్రు నాల్గి వెయిఙ్‌లోకుర్‌ అబ్బె మహార్‌. లోకాఙ్‌ విజేరిఙ్‌ పోక్సి యేసు సిసూర్‌వెట ఉండ్రి డోణి ఎక్తాండ్రె దల్మనుత ఇని ప్రాంతం సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","సెగొండార్‌ పరిసయ్‌రు వాతారె యేసువెట తర్కిస్తెఙ్‌ మొదొల్‌స్తార్. దేవుణునె వన్నిఙ్‌ పోక్తాన్‌ ఇనిదన్నిఙ్‌ రుజుప్‌లెకెండ్‌ ఆగసమ్‌దాన్‌ ఉండ్రి బమ్మాతి పణికిజి మఙి తోరిస్‌అ ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","యేసు మన్సుదు గొప్ప బాదఆజి ఉసుర్‌కొటాండ్రె యా లోకుర్‌ ఎందనిఙ్‌ బమ్మ ఆని పణి తోరిస్‌అ ఇజి వెహ్సినార్. యా లోకాఙ్‌ గుర్తులెకెండ్‌ ఇని బమ్మమాని పణిబా దేవుణు తోరిస్‌ఏన్‌ నిజమెఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","నస్తివలె యేసు వరిఙ్‌ డిఃస్తాండ్రె డోణి ఎక్సి సమ్‌దరం డాట్సి అతాహ పడఃక సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","అహిఙ సిసూర్‌ రొట్టెఙ్‌ తత్తెఙ్‌ పోస్తార్. వరిబాన్‌ డోణిదు ఉండ్రె రొటె మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","యేసు సిసూరిఙ్‌ వెహ్తాన్‌. పరిసయురుది పులాఙ్‌ కిని దూరు వందిఙ్, మరి హేరోదురాజుది పులాఙ్‌ దూరు వందిఙ్‌ మీరు జాగర్త మండ్రు. ");
INSERT INTO kfc_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","మాటు రొట్టెఙ్‌తెఇతిఙ్‌ యేసు ఈహు వెహ్సినాన్, ఇజి వారు ఒరెన్‌వెట ఒరెన్‌ వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","వారు వెహ్‌సినిక యేసు నెసి ఎందానిఙ్‌ మీరు రొట్టెఙ్‌ సిల్లితివందిఙ్‌ వర్గిజినిదెర్‌? ఏలుబా అర్దం కిజి నెస్తెఙ్‌ అట్‌ఇదెరా? మీ మన్సు గట్టి ఆత మనాదా? ");
INSERT INTO kfc_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","మిఙి కణుకు మంజిబ తొఇదెరా? గిబిఙ్‌మంజిబా వెన్‌ఇదెరా? ఇనికబా ఒడ్ఃబిఇదెరా? ");
INSERT INTO kfc_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","అయ్‌దు రొట్టెఙ్‌ ముక్కెఙ్‌ కిజి అయ్‌దు వెయిఙ్‌ లోకాఙ్‌ సీబాతి సిత్తిఙ్‌ మిగ్లితిక్కెఙ్‌ ఎసొడుః గంపెఙ్‌ మీరు కెహ్తిదెర్‌? ఇజి యేసు సిసూరిఙ్‌ వెన్‌బాతాన్. అందెఙె సిసూర్‌ పన్నెండ్‌ గంపెఙ్‌ కెహ్తప్‌ ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","యేసు మరి వెన్‌బాతాన్, ఏడు రొట్టె ముక్కెఙ్‌ కిజి నాల్గి వెయిఙ్‌ లోకాఙ్‌ సితి వెనుక మిగ్లితికెఙ్‌ ఎసోడు గంపెఙ్‌ కెహ్తిదెర్‌? ఏడు గంపెఙ్‌ ఇజి వారు వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","యేసు సిసూరిఙ్‌ వెహ్తాన్‌, మీరు ఏలుబా నాను కితి బమ్మాతి పణిఙ వందిఙ్‌ అర్దం కిదెఙ్‌ నెస్‌ఇదెరా? ");
INSERT INTO kfc_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","యేసుని, వన్ని సిసూర్‌ బేత్‌సెయ్ద ఇని నాటొ వాతార్. అయవలె సెగొండార్‌ ఒరెన్‌ గుడిఃవన్నిఙ్‌ యేసుబాన్‌ తత్తార్. యేసు, నీను విన్నిఙ్‌ ముట్‌అ”, ఇజి వాండ్రు నెగెండ్‌ ఆనివందిఙ్‌ బతిమాలితార్. ");
INSERT INTO kfc_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","యేసు అయ గుడిఃవన్నిఙ్‌ కీదు అస్తాండ్రె నారు డాటిసి ఒత్తాన్. అయ గుడివన్ని కణుకాఙ్‌ పూసి డెఃస్కెఙాణ్‌ ముట్సి “నిఙి ఇనికబా తోర్‌జినాదా”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","వాండ్రు కణుకు పెర్‌జి, సెడిఃబా తోర్జినాద్, గాని లోకు మరెక్‌ నడిఃజిని వజ తోర్‌జినాద్‌ ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","మరి ఒర్సు యేసు వన్ని కణుకెఙ ముట్తాన్. నస్తివలె వన్ని కణుకు నెగెండ్‌ ఆతిఙ్‌ విజు నెగెండ్‌ సుడ్ఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","యేసు వన్నిఙ్‌ బేత్‌సెయ్ద మర్‌జి సొన్మా ఇజి వెహ్సి వన్ని ఇండ్రొ పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","యేసుని, వన్ని సిసూర్‌ పిలిపుది ఆతి కయ్‌సరయ పట్నమ్‌దిఙ్‌ డగ్రు మన్ని నాహ్కఙ్‌ పయ్‌నం కిజి మహార్‌. సొన్సి మహిఙ్‌ సర్దు యేసు వరిఙ్‌ వెన్‌బాతాన్, నాను ఎయెన్‌? ఇజి లోకుర్‌ వర్గిజినార్‌? ");
INSERT INTO kfc_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","దన్నిఙ్‌ సిసూర్, సెగొండార్‌ నీను బాప్తిసం సీని యోహను ఇజినార్‍. మరి సెగొండార్‌ నీను పూర్‌బమ్‌దాన్‌మహి ఏలియ ప్రవక్త ఇజినార్‍. మరి సెగొండార్‌ నీను పూర్‌బమ్‌దుమహి ప్రవక్తలొఇ ఒరెన్‌ ఇజి వెహ్‌సినార్, ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ఆహిఙ మీరు నఙి ఎయెన్‌ ఇజి వెహ్‌సినిదెర్‌? ఇజి యేసు సిసూరిఙ్‌ వెన్‌బాతాన్. నస్తివలె పేతురు, నీను క్రీస్తు ఇహిఙ దేవుణు ఏర్పాటు కితిపోక్తాన్‌”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","యాక ఎయెర్‌వెటబా వెహ్మట్‌ ఇజి కసితంవరిఙ్‌ ఆడ్ర సిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","యేసు వరిఙ్‌ నెస్‌పిస్తెఙ్‌ మొదొల్‌స్తాన్‌, లోకుమరిసి ఆతి నాను నండొ మాలెఙ్‌ ఓరిస్తెఙ్‌వలె. యూద పెద్దెల్‌ఙ, పెరి పుజెరిఙు, యూదురి రూలుఙ్‌ నెస్‌పిస్నికార్‌ నఙి నెక్నపొక్నార్‌ లోకుర్‌ నఙి సప్నార్‌లె. సాజి మూండ్రి దినమ్‌కాఙ్‌ దేవుణు నఙి మర్‌జి నిక్నాన్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","యేసు యాకెఙ్‌ విజు డాఃప్‌ఎండ వెహ్తిఙ్‌ పేతురు యేసుఙ్‌ ఉండ్రిపడఃకాదు ఒసి, ప్రబువ నిఙి యలెకెండ్‌ జర్గిదెఙ్‌ ఆఏద్‌ ఇజి గటిఙ వెహ్తెఙ్‌ మొదిల్‌స్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","యేసు సిసూర్‌దరోట్‌ మర్‌జి సుడ్ఃజి కోపమ్‌దాన్‌ పేతురుఙ్‌ వెహ్తాన్‌. “ఓ సయ్తనా నాబాణిఙ్‌ డిఃసి సొన్‌అ. నీ మన్సుదు మన్ని ఆలోసనమ్‌కు దేవుణుబాణిఙ్‌ వాతికెఙ్‌ ఆఉ. లోకుబాణిఙ్‌ వాతికదె నీను ఆలోసనం కిజిని”. ");
INSERT INTO kfc_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","నస్తివలె యేసు లోకాఙ్‌ విజేరిఙ్, సిసూర్‌ఙ వన్నిబాన్‌ కూక్సి ఈహు వెహ్తాన్‌.‌ ఎయెన్‌బా నావెట వాదెఙ్‌ ఇహిఙ వాండ్రు వన్ని సొంత ఇస్టమ్‌కు నఙి నమ్మితివందిఙ్‌ వన్నిఙ్‌ వాని ఇని మాలెఙ్‌బా ఓరిస్తెఙ్‌ తయారాజి నావెట వాదెఙ్. ");
INSERT INTO kfc_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ఎయెరుబా వన్ని పాణదిఙ్‌ కాపాడ్‌దెఙ్‌ సుడ్‌తిఙ వన్నిఙ్‌ ఎలాకాలం దేవుణువెట బత్కిని బత్కు దొహ్క్‌ఏద్‌. గాని ఎయెన్‌బా నా వందిఙ్, సువార్త వందిఙ్‌ వన్ని పాణం సితిఙ వన్నిఙ్‌ ఎలాకాలం దేవుణువెట బత్కిని బత్కు దొహ్క్‌నాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ఒరెన్‌ వాండ్రు కొరితివజ యా లోకమ్‌ది ఆస్తిసుకం విజు దొహ్కెఆజి వన్నిఙ్‌ ఎలాకాలం దేవుణువెట బత్కిని బత్కు దొహ్‌క్‌ఏండా మహిఙ, ఇని లాబం ఇని లాబంబా సిల్లెద్‌. ");
INSERT INTO kfc_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ఎందానిఙ్‌ ఇహిఙ ఎలాకాలం బత్కిని పాణమ్‌దిఙ్‌ బదులు ఇనికబా సీదెఙ్‌ లోకఅట్‌ఏన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","యా తరమ్‌దికార్‌ నండొ సెఇకార్ దేవుణువందిఙ్‌ మన్సు సిల్లెండ మన్నికార్‌. నా బుబ్బ ఆతి దేవుణుజాయ్‌దాన్‌ దేవుణు దూతెఙ వెట వానివలె, నా వందిఙ్‌ నామాటెఙవందిఙ్‌ సిగు ఆనివరివందిఙ్‌ లోకుమారిసియాతి నానుబా సిగు ఆన”. ");
INSERT INTO kfc_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","యేసు వరిఙ్‌ ఈహు వెహ్తాన్‌, “నాను నిజం వెహ్సిన. ఇబ్బె నిహిమహి వరిలొఇ సెగొండార్‌ దేవుణు గొప్పసత్తుదాన్ వన్ని లోకురిఙ్‌ ఏలుబడిః కిజినిక సూణిదాక సాఏర్”. ");
INSERT INTO kfc_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ఆరు రోస్కుసొహివెనుక యేసు పేతురు, యాకోబు, యోహనుఙ్‌ వన్నివెట ఉండ్రి పెరి గొరొత్‌ కూక్త ఒత్తాన్. ఆ నాల్‌ఎర్‌తప్ప అబ్బె మరి ఎయెర్‌బా సిల్లెర్‌. అబ్బె వరిఎద్రు వన్నిమూర్తి మారితాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","యేసు పొర్‌పాతి మహి సొక్క జిగిజిగి మెరిసిని తెల్లానిజాయ్‌ వజ ఆతాద్. యా లోకమ్‌దు నసొ తెల్లాఙ్‌ నొర్‌బానికార్‌ ఎయెర్‌ సిల్లెర్‌. ");
INSERT INTO kfc_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","మోసెని, ఏలియ వరిఙ్‌‌ తోరె ఆతార్‌. వారు యేసువెట వర్గిజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","అక్క సుడ్ఃజి సిసూర్‌ తియెలాతార్. అందెఙె పేతురు ఇనిక వెహ్తెఙొ నెస్‌ఏండ, “ప్రబు, మాటు ఇబ్బె మహిఙనెగెద్. అందెఙె మూండ్రి గుడుఃసెఙ్‌ తొహ్నిట్. నిఙి ఉండ్రి, మోసెఙ్‌ ఉండ్రి, ఎలియెఙ్‌ ఉండ్రి” ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","అయవలె ఉండ్రి మొసొప్‌ వరిఙ్‌ పిడ్ఃగితాద్‌. అయవలె అయ మొసొప్‌ లొఇహాన్, “వీండ్రు నా ఇస్టమాతి నా మరిన్. విన్నిమాట వెండ్రు”, ఇజి ఉండ్రి కంటం వాతాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","వెటనె వారు సురుల సుడ్ఃతిఙ్‌ వరివెట యేసు తప్ప ఎయెర్‌బా తొర్‌ఏతార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","వారు గొరొన్‌ డిఃగ్‌జివాజి మహివలె, “లోకుమరిసియాతి నాను సాతివరిబాణిఙ్‌ మర్‌జి నిఙినిదాక మీరు సుడ్ఃతిక మహిక ఎయెఙ్‌బా వెహ్మట్”, ఇజి యేసు వరిఙ్‌ కసితం వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","యేసు వెహ్తివజ వారు ఎయెఙ్‌ వెహ్‌ఏండ వరిమన్సుదు ఇడ్ఃజి వరిలొఇ వారె వర్గితార్, “సాజి నిఙ్‌నిక ఇహిఙ అర్దం ఇనిక?”. ");
INSERT INTO kfc_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","నస్తివలె వారు యేసుఙ్‌ వెన్‌బాతార్, “ఏలియ ముఙాల్‌ వాదెఙ్‌వెలె ఇజి యూదురి రూలు నెస్‌పిస్నికార్‌ ఎందానిఙ్‌ ‌వెహ్సినార్‌? ");
INSERT INTO kfc_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","యేసు ఎలియ ముఙాల్‌ వానాన్‌ ఇజి వెహ్తిక నిజమె. వాండ్రు వాజి విజు కొత్తఙ్‌ కినాన్లె. గాని లోకుమరిసియాతికాన్‌ నండొ కస్టమ్‌కు ఓరిసి మాలెఙ్‌ ఆజి లోకువన్నిఙ్‌ నెక్సిపొక్నార్లె ఇజి రాస్తి దనిఙ్‌ అర్దం మిఙి తెలినాదా? ");
INSERT INTO kfc_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","గాని నాను మిఙి వెహ్సిన, ఏలియ వాతాన్. వన్ని వందిఙ్‌ రాస్తి లెకెండ్‌ వరిఙ్‌ ఇస్టం ఆతి వజ వారు వన్నిఙ్‌ కితార్. ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","యేసుని, సిసూర్, మహి సిసూర్‌ మహిబాన్‌ వాతిఙ్‌ సిసూర్‌ సురుల నండొ లోకుర్‌ కూడ్‌తి మహిక సుడుఃతార్. యూదురి రూలు నెస్‌పిస్‌నికార్‌ సిసూర్‌వెట వాదిసి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","అబ్బె మహి లోకుర్‌ విజెరె యేసుఙ్‌ సుడ్ఃతారె నండొ బమ్మ ఆజి వెటనె వన్నిబాన్‌ ఉహ్‌క్సివాజి వన్నిఙ్‌ మాడిఃస్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","నస్తివలె యేసు, “మీరు ఇనిదన్నిఙ్‌ సిసూర్‌వెట వాదిసి మహిదెర్‌? ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ఆ జనమ్‌లొఇ ఒరెన్‌ ఈహు వెహ్తాన్‌, “మేస్టర్‌, నా మరిసిఙ్‌ నీ డగ్రు తత్త. వన్నిఙ్‌ ఉండ్రి దెయం అస్తాదె వన్నిఙ్‌ వర్గిఏండ కితాద్. ");
INSERT INTO kfc_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ఆ దెయం నా మరిన్‌అస్ని వేడఃదు అబ్బెనె వన్నిఙ్‌ అర్‌ప్సినాద్. నస్తివలె వాండ్రు వెయుదాన్‌ పెంపులు కక్సి పల్కు కొహ్‌సినాన్. వాండ్రు డుడ్డువజ డఙ్‌న ఆజినాన్. ఆ దెయమ్‌దిఙ్‌ ఉల్‌ప్తు ఇజి నీ సిసూర్‌ వెట నాను వెహ్త గాని సిసూర్‌ అట్‌ఎతార్. ");
INSERT INTO kfc_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","యేసు వెహ్తాన్‌, “నమకం సిల్లి యా తరమ్‌దికిదెరా, నాను ఎస్సొకాలం మీవెట మంజిన? మీరు కిజినికెఙ్‌ ఎస్తొ ఓరిస్తెఙ్‌? వన్నిఙ్‌ నా డగ్రు తగ్‌అ”. ");
INSERT INTO kfc_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","నస్తివలె వారు ఆ కొడొఃదిఙ్‌ యేసుడగ్రు తత్తార్. ఆ దెయం యేసుఙ్‌ సుడ్ఃతిఙ్‌సరి వన్నిఒడొఃల్‌ విజు వణకిసి బూమిద్‌ అర్‌ప్తాద్. అర్‌ప్తాదె వాండ్రు నుడ్ఃబాజి పొఙు కక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","నస్తివలె యేసు, “విన్నిఙ్‌ దెయం అసి ఎస్సొ కాలం ఆతాద్‌?”, ఇజి అపొసిఙ్‌ వెన్‌బాతాన్. “ఇజ్రి వెలెహనె”, ఇజి అప్పొసి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“ఆ దెయం కొడొఃదిఙ్‌ సప్తెఙ్‌ ఇజి నండొసుట్కు సిసూద్, సిల్లిఙ ఏరుదు అర్‌ప్సి మహాద్‌. నీను ఇనికబా కిదెఙ్‌ అట్ని ఇహిఙ మా ముస్కు కనికారం ఆజి మఙి సాయం కిఅ”, ఇజి అప్పొసి యేసుఙ్‌ వెహ్తాన్‌‌. ");
INSERT INTO kfc_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","యేసు వెహ్తాన్‌, “నీను ఇనికబా కిదెఙ్‌ అట్తిఙ ఇజి మీరు నఙి వెహ్నిదెరా? ఎయెన్‌బా దేవుణు ముస్కు నమకం ఇడ్తిఙ వన్నిఙ్‌ దేవుణు ఇనికబా కిదెఙ్‌ అట్నాన్”. ");
INSERT INTO kfc_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","వెటనె ఆ ఇజ్రి వన్ని అప్పొసి, “నాను నమిజిన. అనుమానం సిల్లెండ నమినివజ నాను నిఙి నమ్మిదెఙ్‌ సాయం కిఅ”, ఇజి డటం వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","అబ్బె లోకుకూడ్ఃజి ఉహ్‌క్సి వానిక యేసు సుడ్ఃజి ఆ దెయమ్‌దిఙ్‌ “ఓ గుల్లబొయ్‌ర దెయం, యా కొడొఃదిఙ్‌ డిఃసి వెల్లి సొన్‌అ ఇజి నాను ఆడ్ర సీజిన. ఎసెఙ్‌బా మర్‌జి వన్ని లొఇ రమ”, ఇజి డటిసి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","నస్తివలె ఆ దెయం గగొలాజి వన్నిఙ్‌ గొప్ప వణకిసి డిఃస్త సొహాద్. ఆ కొడొఃదిఙ్‌ సుడ్ఃతిఙ సాతివన్నివజ మహాన్‌. అక్క సుడ్ఃజి నండొండార్‌ “యా కొడొః సాత సొహాన్‌” ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","గాని యేసు వన్ని కీదు అసి నిక్తిఙ్‌ వాండ్రు నిహాన్. ");
INSERT INTO kfc_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","యేసు ఉండ్రి ఇండ్రొ సొహివెనుక, యేసు అఙ మహిఙ్‌ వన్నిసిసూర్, “మాపు ఎందానిఙ్‌ఆ దెయమ్‌దిఙ్‌ ఉల్‌ప్తెఙ్‌ అట్‌ఏతాప్‌? ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","అందెఙె యేసు, “యా రకం దెయమ్‌కు పార్దనం వెలెనె గాని మరి ఇనిదనివెలెబా సొన్‌ఉ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","వారు అబెణిఙ్‌ సొన్సి గలీలయదాన్‌ సొన్సి మహార్‌. వారు ఎంబె మంజినారొ ఇజి ఎయెఙ్‌బా తెలిదెఙ్‌ యేసుఙ్‌ఇస్టం సిల్లెతాద్. ");
INSERT INTO kfc_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ఎందానిఙ్‌ ఇహిఙ, యేసు వన్ని సిసూర్‌ఙ నెస్‌పిసి మహాన్‌. ఇనిక ఇహిఙ, “లోకుమరిసియాతి నఙి లోకాఙ్‌ ఒపజెప్నార్‌లె. వారు నఙి సప్నార్‌. మూండ్రి రోస్కాఙ్‌ నాను బత్కిజి నిఙ్‌నాలె. ");
INSERT INTO kfc_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","గాని యేసు వెహ్తిమాట సిసూర్‌ అర్దం కిఏతార్. ఆ మాటెఙ వందిఙ్‌ వన్నిఙ్‌ వెన్‌బాదెఙ్‌ వారు తియెలాతార్. ");
INSERT INTO kfc_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","వారు కపెర్నహము ఇని పట్నమ్‌దు వాతార్. వారు ఇండ్రొ వాతిఙ్‌ యేసు మీరు సర్దు ఒరెన్‌వెట ఒరెన్‌ ఇనిదని వందిఙ్‌ వాదిసి మహిదెర్‌. ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","గాని వారు ఇనిక వర్గిఏండ అలెతార్. ఎందానిఙ్‌ ఇహిఙ వానివలె సర్దు ‘మా లొఇఎయెన్‌ పెరికాన్‌’ ఇజి ఒరెన్‌వన్నివెట మరిఒరెన్‌ వాదిసి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","నస్తివలె యేసు బస్తాండ్రె పన్నెండు మణిసిర్‌ సిసూరిఙ్‌ కూక్సి ఈహు వెహ్తాన్‌, ఎయెన్‌ మహి వరిముస్కు పెరికాన్‌ ఆనాండ్రొ, వాండ్రు విజెరి ఇంక అగిజి మండ్రెఙ్. వాండ్రు విజేరిఙ్‌ సేవ కిదెఙ్. ");
INSERT INTO kfc_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","వెనుక యేసు ఒరెన్‌ ఇజ్రి కొడొఃదిఙ్‌ తసి వరినడిఃమి నిల్‌ప్తాన్. మరి ఆ కొడొఃదిఙ్‌ఎతాండ్రె ఈహు వెహ్తాన్‌, “ఒరెన్‌ ఇజ్రి కొడొఃదిఙ్‌ ఎయేర్‌ నా పేరు అసి వరిఇండ్రొ డగ్రు కినారొ వారు నఙి డగ్రు కినార్. ఎయెర్‌ నఙి డగ్రుకినారొ నఙి ఆఎండ నఙి పోక్తివన్నిఙ్‌ డగ్రు కినార్. ");
INSERT INTO kfc_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","యోహాను వెహ్తాన్‌, “మేస్టర్‌, ఒరెన్ నీ పేరు అసి దెయమ్‌కాఙ్‌ ఉల్‌ప్తిక మాప్‌సుడ్ఃతాప్. వాండ్రు మాలొఇ మనికాన్‌ ఆఏన్. అందెఙె మాపు వన్నిఙ్‌ అడ్డు కిత్తాప్. ");
INSERT INTO kfc_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","యేసు వెహ్తాన్‌, “వన్నిఙ్‌ మీరు అడ్డు కిమాట్. నా పేరు అసి యేలు బమ్మాతి పణికినికాన్‌ వెటనె‌ నా వందిఙ్‌ సెఇక వెహ్‌ఏన్. ");
INSERT INTO kfc_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","మా ముస్కు పగ సిల్లికాన్‌ మా పడఃకాదు మనికాండ్రె. ");
INSERT INTO kfc_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","నాను నిజం వెహ్సిన, ఎయెర్‌బా మీరు క్రీస్తు వారుఇజి వెహ్సి, నా పేరు అసి గినాడు ఏరుఉండెఙ్‌ మిఙి సితిఙ దేవుణు వరిఙ్‌నిజం ఇనాయం సీనాన్. ");
INSERT INTO kfc_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","నాముస్కు నమ్మకం ఇడ్తి యా ఇజిరి కొడొఃనన్ని వరిలొఇ ఒరెన్‌వన్నిఙ్‌ ఎయెర్‌బా తప్పకిదెఙ్‌, సరి తోరిస్తిఙ వాండ్రు మెడఃదు పెరి జతపణుకు తొహె ఆజి సమ్‌దరమ్‌దు అడ్ఃగి ముడిఃగి సొనొక వన్నిఙ్‌ నెగెద్. ఎందానిఙ్‌ ఇహిఙ తప్పకిబిస్నివన్నిఙ్‌ ఒద్దె సిక్సి వాన్‌ద్‌. ");
INSERT INTO kfc_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","నీ కియు నిఙి తప్ప కిబిస్తిఙ దనిఙ్‌ కత్సి విసీర్‌అ. ");
INSERT INTO kfc_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","రుండి కికు మంజి ఎలాకాలం సిసు మంజినిబాన్‌ సొన్‌ఏండ ఉండ్రె కియు మంజి ఎలాకాలం బత్కిదెఙ్‌ దేవుణుబాన్‌ సొనిక నెగెద్. ");
INSERT INTO kfc_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","నీ కాలు తప్పకిబిస్తిఙ దన్నిఙ్‌ కత్సి విసీర్‌అ. రుండి కాల్కు మంజి ఎలాకాలం సిసు మంజినిబాన్ దేవుణు నిఙి అర్‌ప్‌ఏండ, సొట వాండ్రు ఆజి ఎల్ల కాలం బత్కిదెఙ్‌ దేవుణు బాన్‌ సొనిక నెగెద్. ");
INSERT INTO kfc_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","నీ కణుక తప్పకిబిస్తిఙ దన్నిఙ్‌ లాగ్జి విసీర్‌అ. రుండి కణుకు మంజి దేవుణు నిఙి నరకమ్‌దు అర్‌పెఎండ ఉండ్రె కణక మంజి దేవుణు ఏలుబడిఃదు మంజినిక నెగెద్. ");
INSERT INTO kfc_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","బానె వరి పిడుఃకు సాఉ. సిసు నమ్‌ఏద్”. ");
INSERT INTO kfc_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","సోరుదాన్‌ ఇడ్నివజ దేవుణుదిఙ్‌ నమ్మిని వన్నిఙ్‌ సిసు నని కస్టందాన్‌ ఇడ్నాన్. ");
INSERT INTO kfc_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","సోరు, నెగ్గికాదె గాని దన్నిఙ్‌మని రుసి సొహిఙ ఎలాగ మరి దన్నిఙ్‌ రుసి తపిస్తెఙ్‌ ఆనాద్‌? మీరుబా సొరు రుసి సీనివజ ఒరెన్‌వెట ఒరెన్‌ సమనం కల్గిజి మండ్రెఙ్”. ");
INSERT INTO kfc_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","యేసు, వాండ్రు మహిబాణిఙ్‌ డిఃసి యూదయ ప్రాంతమ్‌దు వాజి యొర్దాన్‌ గడ్డ డాట్తాన్. మరి వన్నిబాన్‌ నండొ లోకుర్‌ వాతార్. ఎసెఙ్‌బా నెస్‌పిసినిలెకెండ్‌ యేసు వరిఙ్‌ నెస్‌పిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","సెగొండార్‌ పరిసయ్‌రు యేసుడగ్రు వాజి వన్నిమాటెఙ తపు అస్తెఙ్‌ సుడ్ఃతార్. వారు యేసుఙ్‌ వెన్‌బాతార్, మోసె సితి రూలువజ ఒరెన్‌ వన్నిఆల్సిఙ్‌ డిఃస్తెఙ్‌ తగితి రూలుమనాదా? ");
INSERT INTO kfc_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","అందెఙె యేసు, మోసె ఇని రూలు మిఙి సితాన్‌? ఇజి వరిఙ్‌ వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ఒరెన్‌ వన్ని ఆల్సిఙ్‌ డిఃస్తెఙ్‌ ఇహిఙ ఉండ్రి ఆక్కు రాసిసీజి దన్నిఙ్‌ డిఃస్తెఙ్‌ ఆనాద్‌.‌ ఇజి మోసె సితి రూలుదు మనాద్, వారు వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","యేసు వెహ్తాన్‌, మీ మన్సుఙ్‌ నస్సొ గర్ర ఆతిఙ్‌నె యా ఆడ్ర రాసి సితాన్. ");
INSERT INTO kfc_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","గాని దేవుణు లోకాఙ్‌ పుటిస్తివలె మొగకొడొః అయ్‌లి కొడొఃలెకెండ్‌ వరిఙ్‌ పుటిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","అందెఙె మొగవాండ్రు వన్ని అయ్‌సి అపొసిఙ్‌ డిఃసి వన్ని ఆల్సివెట కూడ్ఃజి మంజినాన్. ");
INSERT INTO kfc_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","రిఎర్‌ ఉండ్రి ఒడొఃల్‌వజ ఆజిమంజినార్. అందెఙె మరి ఎసెఙ్‌బా వారు రిఎర్‌ ఆఎండ ఉండ్రె లోకునె. ");
INSERT INTO kfc_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","అందెఙె దేవుణు జత్తకూడిఃప్తివరిఙ్‌ లోకు అఙ కినిక ఆఏద్‌. ");
INSERT INTO kfc_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","వారు ఇండ్రొ మహివలె సిసూర్‌ యా సఙతి వందిఙ్‌ యేసుఙ్‌ మరి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","యేసు వెహ్తాన్‌, “ఒరెన్‌ ఆల్సిఙ్‌ డిఃసి మరిఉండ్రి దనిఙ్‌ ఇడ్డెఆతిఙ వాండ్రు రంకు బూలాజినాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","అయ లెకెండ్‌ అయ్‌లికొడొః మాసిఙ్‌డిఃసి మరి ఒరెన్‌వన్నిఙ్‌ ఇడ్డెఆతిఙ అది రంకుబూలాజినాద్”. ");
INSERT INTO kfc_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","లోకుర్, వరిఇజిరి కొడొఃరిఙ్” వరిముస్కు వన్ని కిక్కు ఇడ్తెదెఙ్‌ ఇజి యేసుబాన్‌ తత్తార్. అక్క సుడ్ఃతారె సిసూర్‌ వరిఙ్‌ జట్టిఙ్‌ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","గాని యేసు అక్క సుడ్ఃతాండ్రె సిసూర్‌ముస్కు కోపం ఆతాన్. “యా ఇజిరి కొడొఃరిఙ్‌ నా డగ్రు రపిర్. వరిఙ్ అడ్డు కిమాట్. ఎందానిఙ్‌ ఇహిఙ యాలెకెండ్‌ మన్నికారె దేవుణు ఏలుబడిఃదు మంజినార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","నాను వెహ్తిక నిజమె. ఇజిరి కొడొఃర్‌ నమకం ఇడ్నివజ దేవుణుముస్కు నమకం ఇడ్తికారె దేవుణు ఏలుబడిఃదు మంజినార్. సిల్లికార్‌ సొన్‌ఏర్”, ఇజి యేసు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","నస్తివలె యేసు అయ ఇజిరి కొడొఃరిఙ్‌ ఎత్సి, వరి ముస్కు కిక్కు ఇడ్జిఙ్‌పొమ్‌జి దీవిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","యేసు అబ్బెణాన్‌ సొండ్రెఙ్‌ సొత్తిఙ్‌ ఒరెన్‌‌ ఉహ్‌క్సి వాజి వన్ని ముఙాల్‌ ముణుకుఙ్‌ ఊర్‌జి మాడిఃస్తాన్, “ఓ నెగ్గి బోదకినికి, దేవుణువెట ఎలాకాలం మంజిని బత్కుదు మండ్రెఙ్‌ ఇహిఙ నాను ఇనిక కిదెఙ్”, ఇజి యేసుఙ్‌ వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","“నీను ఎందానిఙ్‌ నఙి నెగ్గికి ఇజి వెహ్‌సిని? దేవుణు ఒరెండ్రె నెగ్గికాన్‌. మరి ఎయెన్‌బా నెగ్గికాన్‌ ఆఏన్. ");
INSERT INTO kfc_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","దేవుణు వెహ్తి రూలువిజు నిఙి తెలినాద్. లోకాఙ్‌ సప్తెఙ్‌ ఆఏద్‌, రంకు బూలాదెఙ్‌ ఆఏద్‌, డొఙ కిమా,అబద్దమ్‌దిఙ్‌ సాస్య వెహ్మ, ఎయెఙ్‌బా మోసెం కినిక ఆఎద్‌, యాయ బుబ్బరిఙ్‌ గవ్‌రమ్‌దాన్‌ నెగ్గెండ్‌ సుడిఃదెఙ్‌”, ఇజి యేసు వన్నిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","వెహ్తెఙ్‌ “బోదకినికి, ఇజిరి వెలెహన్‌ అసి యా విజువనకాఙ్‌ లొఙిజినె నాను మంజిన”, ఇజి వాండ్రు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","యేసు వన్నిఙ్‌ సుడ్ఃజి వన్నిఙ్‌ ప్రేమిస్తాన్. “నీను ఉండ్రి కిదెఙ్‌ మనాద్. అక్క ఇనిక ఇహిఙ నీను సొన్సి నిఙి కల్గితిమనిక విజు పొర్సి అయ డబ్బుఙ్‌ బీదాతివరిఙ్‌ సిఅ. అయవలె పరలోకమ్‌దు నిఙి ఆస్తి దొహ్‌క్నాద్. వెనుక వాజి నా సిసూ ఆఅ”, ఇజి యేసు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","యామాట వెహాండ్రె వాండ్రు మొకొం ఊతాండ్రె మన్సుదు దుకమాజి సొహాన్‌. ఎందానిఙ్‌ ఇహిఙ వాండ్రు నండొ ఆస్తి మన్నికాన్‌‌. ");
INSERT INTO kfc_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","నస్తివలె యేసు సురుల సుడ్ఃజి సిసూర్‌ఙ ‌వెహ్తాన్. “ఆస్తి మన్నికాన్‌ దేవుణు ఏలుబడిః అడిగి మండ్రెఙ్‌ ఎస్సొనొ కస్టం. ");
INSERT INTO kfc_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","యేసు వెహ్తి మాటెఙ్‌ సిసూర్‌ వెహరె బమ్మ ఆతార్. యేసు మరి వెహ్తాన్‌, “కొడొఃరాండె దేవుణు ఏలుబడిః అడిగి మండ్రెఙ్‌ ఎస్సొనొ కస్టం. ");
INSERT INTO kfc_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ఆస్తిమన్నికాన్‌ దేవుణుకిని ఏలుబడిఃదిఙ్‌ లోఙిజి మండ్రెఙ్‌ఇహిఙ కస్టం. ఉండ్రి ఒంటె బొబానం బొరొదాన్‌ డుఃగ్‌నిక దన్నిఙ్‌ ఇంక సులునె”. ");
INSERT INTO kfc_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","యాక వెంజి సిసూర్‌ మరి ఒద్దె బమ్మ ఆతార్. అహిఙ దేవుణు రక్సిస్తిలెకెండ్‌ ఎయెన్‌ మండ్రెఙ్‌ అట్నాన్‌? ఇజి వారు ఒరెన్‌వెట మరి ఒరెన్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","నస్తివలె యేసు వరిఙ్‌ సుడ్ఃజి, అయా లోకాఙ్‌ అట్‌ఇకాదె గాని దేవుణు విజు కిదెఙ్‌ ట్నాన్‌”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","నస్తివలె పేతురు, మాపు విజు డిఃస్తాపె నీవెట వాతాప్‌ ఇజి యేసుఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","యేసు మరి వెహ్తాన్‌, నాను వెహ్నిక ఇనిక ఇహిఙ, నా వందిఙ్, సువార్త వెహ్ని వందిఙ్, ఇలుజొల్లు నా దాదతంబేరిఙు, తఙిబీబికాఙ్, కొడొఃరిఙ్, అయ్‌సిఅపొసిరిఙ్, బూమిఙ్‌ డిఃస్తివన్నిఙ్‌ యా లోకమ్‌దునె వంద వందుఙ్‌ ఇల్కు, దాదతంబేరిఙ్, బీబితఙికు, కొడొఃరిఙ్, అయ్‌సిఅపొసిర్, బూమి, కల్గినాద్. అక్కాదె ఆఏండ దేవుణుదిఙ్‌ నమ్మితివరిఙ్‌ యా లోకమ్‌దు కస్టమ్‌కుబా వానె. గాని దేవుణు రాజువజ వానివలె వాండ్రు ఎలాకాలం దేవుణువెట బత్కినాన్. ");
INSERT INTO kfc_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","అయలెకెండ్‌నె కడెఃవెర్‌దికార్‌ ఇజి ఒడిఃబినికార్‌ మొదొహికార్‌ ఆనార్‌. ముందహికార్‌ ఇజి ఒడ్ఃబినికార్‌ కడెఃవెరిదికార్‌ ఆనార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","యేసుని, సిసూర్‌ యెరూసలేమ్‌దు సొన్సి మహార్‌. లోకుర్‌బా వరివెట సొన్సి మహార్‌. యేసు వరి ముఙాల్‌నడిఃతాన్. యేసు యెరూసలేమ్‌దు సొన్సిని వందిఙ్‌ సిసూర్‌ బమ్మఆతార్. లోకుర్‌ తియెలాతార్. యేసు పన్నెండు మణిసిర్‌ సిసూర్‌ వన్నిడగ్రు కూక్సి, వన్నిఙ్‌ జర్గినిక వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“ఇదిలో మాటు యెరూసలేమ్‌దు సొన్సినాట్. లోకుమరిసియాతి నాను పెరి పుజెరిఙ, యూదురి రూలువెహ్ని వరిఙ్‌ ఒపజెప్నార్‌లె. వారు నఙి సావుదిఙ్‌ సిక్స సీజి యూదురు ఆఇవరిఙ్‌ నఙి ఒపజెప్నార్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","వారు నఙి వెక్రిసి, నా ముస్కు పూసి, కొర్డదాన్ ‌డెఃయ్‌జి సప్నార్‌లె. మూండ్రి రోస్కాణిఙ్‌ మర్‌జి నిఙ్‌నాలె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","నస్తివలె జెబెదయ మరిసిరాతి యాకోబు యోహాను ఇనికార్‌ యేసుడగ్రు వాతారె, “ఓ బోదకినికి, మాపు ఇనికబా లొస్తిఙ అక్క మఙి సీదెఙ్‌వెలె” ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","యేసు వరిఙ్‌ “నాను మీ వందిఙ్‌ ఇనిక కిదెఙ్‌?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","వారు, “నీను రాజువజ ఏలుబడిః కినివలె మఙి ఒరెన్‌వన్నిఙ్‌ నీ ఉణెర్‌ పడఃకాదు ఒరెన్‌వన్నిఙ్‌ నీ డేబ్ర పడఃకాదు బసె కిఅ ఇజి కోరిజినాప్”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","39","యేసు వరిఙ్‌ “మీరు ఇనిక లొసినిదెరొ మీరు నెస్‌ఇదెర్. నాను ఓరిస్తెఙ్‌ మన్ని నండొ బాదెఙ్‌ మీరు ఓరిస్తెఙ్‌ అట్నిదెరా? నాను పొందిని బాప్తిసం పొందిదెఙ్‌ అట్నిదెరా?”, ఇజి వరిఙ్‌ వెన్‌బాతిఙ్‌ వారు, “మాప్‌ అట్నాప్‌ ఇహార్‌. దనిఙ్‌ యేసు నాను ఓరిస్ని నండొబాదెఙ్‌ మీరు ఓరిస్నిదెర్‌. నాను పొందిని బాప్తిసం మీరు పొందిదెఙ్‌. ");
INSERT INTO kfc_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","గాని నా ఉణెర్‌ పడఃకాద్‌ డేబ్ర పడఃకాద్‌ ఎయెర్‌ బస్తెఙ్‌ ఇజి తీర్మనం కితిక నాను ఆఏ. దన్ని వందిఙ్‌ దేవుణు తీర్మనం కిత్త మనాన్‌. వాండ్రు తీర్మనం కితివరిఙ్‌ అక్క సీనాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","మహి పది మన్సి సిసూర్‌ యా మాట వెహారె యాకోబుని యోహాను ముస్కు కోపమాతార్. ");
INSERT INTO kfc_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","యేసు సిసూరిఙ్‌ విజేరిఙ్‌ కూక్సి ఈహు వెహ్తాన్‌, “యూదురు ఆఇవరిలొఇ ఏలుబడిః కిదెఙ్‌ అతికారం మన్నికార్‌ వరిముస్కు అతికారం తోరిస్నార్‌ వరిలొఇ పెరికార్‌ వరిఙ్‌ మన్ని అతికారమ్‌దాన్‌ లోకురిఙ్‌ అణసు తిగ్‌జినార్ ఇజి మిరు నెస్‌నిదెర్‌. ");
INSERT INTO kfc_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","మీరు వరిలెకెండ్‌ మండ్రెఙ్‌ ఆఏద్‌. గాని మీ లొఇ ఎయెన్‌బా పెరికానాదెఙ్‌ ఇహిఙ వాండ్రు మిఙి పణిమణిసిర్‌ లెకెండ్‌ ఆదెఙ్‌ వలె. ");
INSERT INTO kfc_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","మరి ఎయెన్‌బా మిఙి విజేరె ముస్కు నెయ్‌కి ఆదెఙ్‌ ఇహిఙ వాండ్రు మిఙి విజేరిఙ్‌ వెటిపణిమణిసిలెకెండ్‌ ఆదెఙ్‌ వలె. ");
INSERT INTO kfc_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ఎందానిఙ్‌ ఇహిఙ లోకు మరిసిఆతి నానుబా లోకాఙ్‌ సేవ కిదెఙ్‌ వాత గాని సేవ కిబె ఆదెఙ్‌ రెఏత. మరి నండొండారిఙ్‌ వరి పాపమ్‌కాణ్‌ విడుఃదల కిదెఙ్‌ నా పాణం సీదెఙ్‌ వాత మన్న”. ");
INSERT INTO kfc_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","యేసుని సిసూర్‌ యెరికొపట్నమ్‌దు వాతార్. వారు నండొ లోకుర్‌వెట పట్నమ్‌దాన్‌ సొన్సి మహిఙ్‌ తిమాయి మరిసి ఆతి బర్తిమయి ఇని గుడ్డివాండ్రు సరి పడఃకాదు లొస్‌పాదెఙ్‌ బస్త మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","సరి దాన్‌ వాజినికాన్‌ నజరేతువాండ్రు యేసు ఇజి వెంజి, “ఓ యేసు, దావీదుమరిసి నా ముస్కు కనికరం తోరిస్‌అ”, ఇజి డటం గగోల్‌ఆతాన్. ");
INSERT INTO kfc_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","సేన లోకువన్నిఙ్‌ “పలాక్‌ మండ్రు ఇజి గోల కిత్తార్‌. గాని వాండ్రు “ఓ “దావీదుమరిసి, నా ముస్కు కనికారం తోరిస్‌అ”. మరి ఒద్దె డట్టం డేల్‌స్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","యేసు నిహండ్రె, “వన్నిఙ్‌ కూక్‌అ”, ఇజి వెహ్తాన్‌. వెహ్తిఙ్‌ వారు ఆ గుడ్డివన్నిఙ్‌ కూక్సి, “దయరం మన్‌అ, యేసు నిఙి కూక్సినాన్, నిఙ్‌అ”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","వెటనె వాండ్రు వన్ని నీరి సొక్క విసీర్తాండ్రె నిఙ్‌జి యేసు బాన్‌వాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","యేసు వన్నివెట, “నాను నిఙి ఇనిక కిదెఙ్‌ఇజి నీను కోరిజిని?”, ఇజి వెన్‌బాతాన్. నస్తివలె వాండ్రు, “యేసు, నాను బేస్తెఙ్‌ ఆపిద్‌”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","యేసు, “నీను నా ముస్కు నమకం ఇడ్తి అందెఙె నీను నెగెండ్‌ ఆతి నీను ఇండ్రొ సొన్‌అ” ఇహాన్‌. వెటనె సుడుఃదెఙ్‌ అట్తాన్‌. వాండ్రు యేసువెట సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","యేసుని, వన్నిసిసూర్‌ యెరూసలేం డగ్రుమన్ని బెత్‌పాగె బేతానియ ఇని నాహ్కఙ్‌ వాతార్. యా నాహ్కు ఒలివ గొరొన్‌డగ్రు మన్నె. అబ్బె వాతిఙ్‌ యేసు సిసూర్‌ రిఏరిఙ్‌ కూక్సి, “మీరు ఎద్రు మని నాటో సొండ్రు. అబ్బె సొహిఙసరి తొహ్తి మని ఉండ్రి పెరి గాడఃదె పిల్ల మీరు సూణిదెర్‌ దని ముస్కు ఎయెర్‌బా ఎసెఙ్‌బా బస్‌ఏతారె. దనిఙ్‌ కుత్సి నాబాన్‌ పేర్‌జి తగాట్”. ");
INSERT INTO kfc_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","“మీరు ఎందా‌ కుత్సినిదెర్‌ ఇజి ఎయెర్‌బా వెహ్తిఙ, యాక ప్రబుఙ్‌ కావాలి. మరి వెటనె దన్నిఙ్‌ మర్‌జి పోక్నాన్‌ ఇజి వెహ్తు” ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","5","వారు సొన్సి ఇల్లుముఙాల్‌ వీదిదు తొహ్తి మని ఉండ్రి గాడఃదె పిల్లదిఙ్‌ సుడ్‌తార్. వారు దనిఙ్‌కుత్సి మహిఙ్, అబ్బె మనికార్, “ఎందానిఙ్‌ మీరు యా గాడ్‌దె పిల్లదిఙ్‌ కుత్సినిదెర్”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","యేసు వరిఙ్‌ వెహ్తి వజనె సిసూర్‌ వెహ్తార్‌. అబ్బె మహికార్‌ వరిఙ్‌ సరిసిత్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","వారు గాడ్‌దె పిల్లదిఙ్‌ యేసుబాన్‌ తత్తార్. దన్నిముస్కు బస్తెఙ్‌ వరి పాతెఙ్‌ పహ్తిఙ్‌ యేసు దన్నిముస్కు ఎక్సి యెరూసలేమ్‌దు సొండ్రెఙ్‌ సోతాన్. ");
INSERT INTO kfc_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","సొహిఙ్‌ సేన లోకు వరి నీరి సొక్కెఙ్‌ సర్దు పహ్తర్. మరి సెగొండార్‌గుడ్డెదు మని మరెకాణి కొమ్మెఙ్‌ తతారె సర్దు పహ్తర్. ఆహె కిజి వారు యేసుఙ్‌ మర్యాద కిత్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","10","ముఙాల్‌ సొన్సి మహికార్, వెనుక వాజి మహికార్, “ఓసన్న! ప్రబు సిత్తి అతికారమ్‌దాన్‌ వాజినికాన్‌ పొగ్‌డెః ఆనికాన్‌. మా అని గొగొఆతి దావీదు రాజువజ ఏలుబడిః కిదెఙ్‌ వాని ప్రబు గొప్ప వాండ్రు పరలోకమ్‌దు మన్ని దేవుణుదిఙ్‌ ఓసన్న!”, ఇజి డేల్‌స్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","యేసు యెరూసలేమ్‌దు వాజి దేవుణు గుడిఃదు సొహాన్‌. అబ్బె మహి విజుదనిఙ్‌ యేసు సుడ్‌తాన్. గాని పొద్దు ఆతిఙ్‌ పన్నెండు మణిసిర్‌ సిసూర్‌వెట బేతానియ నాటొ సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","మర్స నాండిఙ్‌ యేసు, వన్ని సిసూరు బేతానియదాన్‌ సొన్సిమహిఙ్‌ యేసుఙ్‌ బఙ కట్తాద్. ");
INSERT INTO kfc_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","యేసు దూరమ్‌దాన్‌ ఉండ్రి బొడెమరాన్‌ సుడ్ఃతాన్. పట్కు కాలం ఆఇఙ్‌బా మరాతు ఆకుఙ్‌ మహె. మరాత్‌పట్కు మంజినె ఇజి డగ్రు సొహాండ్రె సుడ్ఃతాన్. గాని ఆకు తప పట్కు సిల్లు. ");
INSERT INTO kfc_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","యేసు ఆ మరాతిఙ్” నీ పట్కు మరి ఎసెఙ్‌బా లోకుర్‌తిన్‌ఏండ ఆపిర్‌’ ఇజి వెహ్తాన్‌. వాండ్రు వెహ్తిక సిసూర్‌ విహర్. ");
INSERT INTO kfc_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","యేసుని వన్ని సిసూర్‌ యెరుసలేమ్‌దు వాతిఙ్, యేసు అబ్బెమహి యూదురి దేవుణు గుడిఃదు సొహాన్‌. అబ్బెగుడిః అర్‌ఙుదు మహి కొణి వరిఙ్‌ పోర్నివరిఙ్‌ విజేరిఙ్‌ వెల్లి పోక్తాన్. డబ్బు మారిస్ని వరి బల్లెఙ్‌ని పావురపొటిఙ పొర్సిని వరి పిటెఙ్‌ మహ్త విసీర్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ఇని సామానమ్‌బా ఎయెర్‌బా దేవుణు గుడిః బాడిఃదాన్‌ బరు మోస్తెఙ్‌ యేసు సరి సిఏతాన్. ");
INSERT INTO kfc_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","యేసు వరిఙ్‌ నెస్‌పిసినివెలె ఈహు వెహ్తాన్‌, “నా గుడిః విజెరి లోకాఙ్‌ పార్దనం కిని గుడిః ఇజి కూకె ఆనాద్‌లె, ఇజి దేవుణు మాటదు రాస్త మనాద్. గాని మీరు దన్నిఙ్‌ డొఙారిఙ సాలం లెకెండ్‌ కిత్తి మన్నిదెర్”. ");
INSERT INTO kfc_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","యేసు వెహ్తిక లోకుర్‌ విజేరె వెంజి బమ్మ ఆతార్. అబ్బె మహి పెరిపుజెరిఙు, యూదురి రూలుఙ్‌ నెస్‌పిసినికార్‌ అక్క సుడ్ఃజి తియెలాతార్. యేసుఙ్‌ ఎలాగ సప్తెఙ్‌ ఇజి ఆలొసనం కితార్. ");
INSERT INTO kfc_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","పొద్దు ఆతివలె యేసుని, వన్ని సిసూర్‌ ఆ పట్నమ్‌దాన్‌ సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","పెందాల్నె వారు సొన్సిమహిఙ్‌ యేసు పట్కు రెబాతి బొడెమరాన్‌ వెలెఙాణిఙ్‌ మరాన్‌ విజు సాతిక వారు సుడుఃతార్. ");
INSERT INTO kfc_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","పేతురు యేసు వెహ్తిక గుర్తు కిత్తాన్‌. “ప్రబు నీను సయప్‌ సిత్తి బొడెమరాన్‌ సాత మనాద్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","యేసు వరివెట ఈహు వెహ్తాన్‌, “మీరు దేవుణు ముస్కు నమకం ఇడుఃదు. నాను నిజం వెహ్సిన. ఎయెర్‌బా యా గొరొణ్‌దిఙ్” పెర ఆజి సమ్‌దరమ్‌దు అర్‌అ’ ఇజి వన్ని మన్సుదు అనుమానం సిల్లెండ నమిజి వెహ్తిఙ ఆ వజనె జర్గినాద్”. ");
INSERT INTO kfc_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","అందెఙె నాను వెహ్సిన, మీరు పార్దనం కినివెలె మీరు ఇనికెఙ్‌ లొసినిదెరొ అక్కెఙ్‌ దొహ్‌క్‌ఎండ ముఙాలె అక్కెఙ్‌ దొహ్‌క్తాద్‌ ఇజి నమ్మిదు. నస్తివలె అక్కెఙ్‌ విజు మిఙి కల్గినె. ");
INSERT INTO kfc_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","మీరు ఎసెఙ్‌బా పార్దనం కినివెలె ఎయెన్‌బా‌ మీ ముస్కు తప్పకిత్త మనాన్‌ ఇహిఙ వన్నిఙ్‌ సెమిస్తెఙ్. ");
INSERT INTO kfc_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","నస్తివలె పరలోకమ్‌దు మన్ని నీ బుబ్బాతి దేవుణు మీ తప్పఙ్‌బా సెమిస్నాన్. ");
INSERT INTO kfc_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","యేసుని, వన్నిసిసూర్‌, మరి యెరూసలేమ్‌దు వాతార్. యేసు అబ్బె దేవుణుగుడిః నడిఃజి మహిఙ్‌ పెరిపుజెరిఙు యూదురి రూలుఙ్‌ నెస్‌పిసినికార్‌ యూదపెద్దెల్‌ఙ వన్నిబాన్‌ వాతార్. ");
INSERT INTO kfc_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","వారు యేసుఙ్‌ వెన్‌బాతార్, “నీను ఇని అతికారమ్‌దాన్‌ యా పణిఙ్‌కిజిని? యాపణిఙ్‌ విజుకిదెఙ్‌ ఎయెన్‌ నిఙి అతికారం సితాన్‌?”. ");
INSERT INTO kfc_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","యేసు వెహ్తాన్‌, “నాను మిఙి ఉండ్రిమాట వెన్‌బాన. నఙి జబాబ్‌ వెహ్తు. అయవలె యా పణిఙ్‌ ఎమేణి అతికారమ్‌దాన్‌ కిజిన ఇజి నాను మిఙి వెహ్న. ");
INSERT INTO kfc_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","యోహానుఙ్‌ బాప్తిసం సీదెఙ్‌ అతికారం ఎంబెణిఙ్‌ వాతాద్‌? దేవుణు బాణిఙ్‌నా, లోకుర్‌బాణిఙ్‌నా? నఙి వెహ్తు. ");
INSERT INTO kfc_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","32","యేసు వెహ్తిమాట వెంజి వరిలొఇ వారె ఒడిఃబితార్. దేవుణుబాణిఙ్‌ వాతాద్‌ ఇజి వెహ్తిఙ అయవలె ఎందనిఙ్‌ మీరు వన్నిఙ్‌ నమ్మిఇతిదెర్‌ ఇజి వెన్‌బానాన్‌. లోకుర్‌ బాణిఙ్‌ వాతాద్‌ ఇజి వెహ్తిఙ వారు లోకాఙ్‌ తియెల్‌ ఆతార్. ఎందానిఙ్‌ ఇహిఙ యోహాను దేవుణు మాట వెహ్ని ప్రవక్త ఇజి లోకుర్‌ నమ్మితార్. ");
INSERT INTO kfc_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","అందెఙె వారు, “మఙి తెలిఎద్”, ఇజి మర్‌జి వెహ్తర్‌. అయవలె యేసు, “అహిఙ, యా ఎంమేణి అతికారమ్‌దాన్‌ యా పణిఙ్ కిజిన ఇజి మిఙి నానుబా వెహ్‌ఎ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","యేసు వరిఙ్‌ కతవజ ఈహు వెహ్తాన్‌. “ఒరెన్‌వన్నిఙ్‌ కండెక్‌ బూమి మహాద్‌. వాండ్రు ఆ బూమిదు ద్రాసమొకెఙ్‌ ఉణుస్తాన్. దన్ని సురుల కోటి తొహిస్తాన్. దన్నిలొఇ ద్రాక్సపట్కురసం పీర్దెఙ్‌ పణుకుదు ఉండ్రి గనుగు తయార్‌ కిబిస్తాన్‌. టోట కాప్‌కిదెఙ్‌ ఉండ్రి ఎత్తుమన్ని ఇల్లుబా తయార్‌ కిత్తాన్‌. వెనుక ద్రాసటోట సెగొండార్‌ రెయ్తుతురిఙ్‌ పాలిదిఙ్‌ సిత్తాండ్రె పయ్‌నం కిజి మరి ఉండ్రి దేసెం సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","పట్కు పంట్‌ని కాలమ్‌దు ఆ టోట ఎజమాని వన్నిఙ్‌ వానివంతు లొసి తగ్‌అ ఇజి ఒరెన్‌ పణిమన్సిఙ్‌ పాలి అస్తిమన్నివరిడగ్రు పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","గాని పాలి అస్తిమన్నికార్‌ వన్నిఙ్‌ డెఃయ్తారె వహి కీదాన్‌ మర్జి పోక్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","అయవలె ఆ టోట ఎజుమాని మరి ఒరెన్‌ పణిమణిసిఙ్‌ వరిడగ్రు పోక్తాన్. వారు వన్నిఙ్‌బురాదు గాయం ఆనివజ డెఃయ్‌జి సిగు కిజి పోక్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","యజుమాని, వెనుక, మరి ఒరెన్‌వన్నిఙ్‌ వరిబాన్‌ పోక్తాన్. వన్నిఙ్‌ వారు డెఃయ్త సప్తార్. అయవజనె ఎజుమాని వన్ని పణిమణిసిర్‌ సేన లోకురిఙ్‌ పోక్తాన్. సెగొండారిఙ్‌ వారు డెఃయ్‌తార్. మహివరిఙ్‌ సప్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ఆక్కర్‌దిఙ్‌ అయ ఎజుమానిఙ్‌ వాండ్రు ప్రేమ కిత్తి ఒరెండ్రెమహి మరిసి మిగిలిత్తాన్. అందెఙె వన్నిఙ్‌ పోక్తాన్‌. ఆ పాలి అస్తిమన్నికార్‌ నా మరిసిఙ్‌ గవ్‌రం సీనార్‌లె ఇజి వరిబాన్‌ పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ఆ పాలి అస్తిమన్నికార్‌ ఎజుమాని మరిసిఙ్‌ సుడ్ఃతారె వీండ్రు యా టోటదిఙ్‌ అక్కుమన్నకాన్‌ రద్దు మాటు విన్నిఙ్‌ సప్సి యా టోట మాది కినాట్‌”, ఇజి వారు కూడిఃజి వర్గితార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","అందెఙె వారు ముస్కు అర్తాండ్రె వన్నిఙ్‌ సప్తార్‌. సప్తారె టోట వెల్లి విసీర్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","ఆ టోట ఎజుమాని వరిఙ్‌ ఇనిక కినాన్? వాండ్రు వాజి ఆ అస్తిమహివరిఙ్‌ సప్నాండ్రె ఆ టోట ఆఇ రెయ్తురిఙ్‌ పాలిదిఙ్‌ సీనాన్. ");
INSERT INTO kfc_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","యేసు మరి వెహ్తాన్‌. “ఇల్లు తొహ్నికార్‌ నెక్సిపొక్తి పణుకునె మూలదిఙ్‌ ములపణుకు ఆతాద్‌. యాక దేవుణు కియుదాన్‌ జర్గితిక. యక మా కణుకెఙ బమ్మాతిక ఇజి దేవుణు మాట రాస్తి మన్నిక మీరు సద్‌విఇదెరా? ");
INSERT INTO kfc_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","యేసు యా కతవజ నెస్‌పిస్తిక వెహారె ‘మా వందిఙ్‌ వెహ్తాన్‌’ ఇజి పెద్దెలుఙు నెస్తారె యేసుఙ్‌ అస్తెఙ్‌ ఇజి సుడ్ఃతార్. గాని మందలోకురిఙ్‌ తియెలాతారె వన్నిఙ్‌ డిఃస్తారె సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","వెనుక వారు పరిసయ్‌రుఙ్‌ని హెరోదురాజు పార్టిలొఇ సెగొండారిఙ్‌ యేసుమాటదు తపు అస్తెఙ్‌ వన్నిబాన్‌ పోక్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","వారు వన్ని డగ్రు వాజి, ఓ బోదకినికి, నీను నిజం వెహ్నికి ఇజి మాప్‌నెస్నాప్. నీను ఇజిరికార్‌ ఇజి పెరికార్‌ ఇజి తేడ తొఇకి వరిఙ్‌ ఇస్టమాతిలెకెండ్‌ వర్గినికి ఆఇ దేవుణు సరి వందిఙ్‌ నిజమ్‌దాన్‌ నెస్‌పిసినికి. కయ్‌సరుఙ్‌ పన్ను సీనిక నాయమ్‌నా ఆఏదా? ");
INSERT INTO kfc_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","యూదురు ఆతి మాపు అక్కసీదెఙా పోనినా? ఇజి యేసుఙ్‌ వెన్‌బాతార్. వారు వేసం కినికార్‌ ఇజి నెసి “వీరు నా మాటదు ఎందానిఙ్‌ తపు అస్తెఙ్‌ సుడ్ఃజినిదెర్‌? ఇజి యేసు వెన్‌బాతాన్. యేసు మరి వెహ్తాన్‌, ఉండ్రి దినారి కాసు తసి నఙి తోరిస్తు”. ");
INSERT INTO kfc_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","వారు తసి వన్నిఙ్‌ తోరిస్తార్. నస్తివలె వాండ్రు, దిన్నిముస్కు మన్ని బొమ్మ ఎయెది, దని ముస్కు రాస్తి రాంత ఎయెది? ఇజి వెన్‌బాతాన్. “కయ్‌సరుది”, ఇజి వారు వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","అయవలె యేసు కయ్‌సురుఙ్‌ సెందితికెఙ్‌ కయ్‌సురుఙ్‌ సీదు. దేవుణుదిఙ్‌ సెందితికెఙ్‌ దేవుణుదిఙ్‌ సీదు ఇజి వెహ్తాన్‌. యేసు వెహ్తిక వారు వెంజి బమ్మ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","నస్తివలె సాతివెనుక మర్‌జి నిఙినిక సిల్లెద్‌ ఇజి నెస్‌పిసిని సదుకయ్‌రు ఇనివరి లొఇ సెగొండార్‌ యేసుడగ్రు వాతార్. వారు యేసుఙ్‌ ఉండ్రి ప్రస్న వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“ఓ బోదకినికి, ఒరెన్‌ పెండ్లి ఆతి వెనుక కొడొఃర్‌ సిల్లెండ సాతిఙ వన్ని తంబెర్‌సి ఒన్నిసిఙ్‌ ఇడె ఆజి కొడొఃర్‌ ఇడిదెఙ్. అహె సాతివరి వందిఙ్‌ కొడొఃర్‌ పుటిస్తెఙ్‌వలె ఇజి మోసె సిత్తి రూలుదు మనాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ఏలు సుడ్ఃఅ ఉండ్రి కాలమ్‌దు ఏడుగురు తంబెరిఙు మహార్‌. తొల్‌సుర్‌దికాన్‌ ఉండ్రి బోదెలిదిఙ్‌ పెండ్లి ఆతాన్. కొడొఃర్‌ సిల్లెండ సాతాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","సాతిఙ్‌ నడిఃపి వాండ్రు ఒనిసిఙ్‌ పెండ్లి ఆతాన్. వాండ్రుబా కొడొఃర్‌ సిల్లెండ సాతాన్. వెనుక కొగ్రి నడిఃపి దన్నిఙ్‌ ఇడె ఆతాన్. ");
INSERT INTO kfc_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ఆహె ఏడుగురుబా దన్నిఙ్‌ పెండ్లి ఆజి కొడొఃర్‌ సిల్లెండ సాత సొహార్‌. కడెవెరిదు అయ బోదెలిబా సాతాద్. ");
INSERT INTO kfc_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","అహిఙ సాతివరిబాణిఙ్‌ మర్‌జి నిఙినివెలె అ బోదెలి అయా ఏడు గురు లొఇ ఎయెఙ్‌ ఆల్సి ఆనాద్‌? ఏడుగురుదిఙ్‌బా ఆది ఆల్సి ఆత మహాద్‌గదె? ");
INSERT INTO kfc_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","యేసు వరిఙ్‌ ఈహు వెహ్తాన్‌. “దేవుణు మాటెఙ్‌ మిరు నెస్‌ఇదెర్‌. దేవుణుసత్తు ఎస్సొ ఇజి మిఙి నెస్‌ఇదెర్‌. అందెఙె మీరు తపు వెహ్సినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","సాతి వరిబాణిఙ్‌ మర్‌జి నిఙినివలె ఎయెర్‌బా పెండ్లి ఆఏర్. పెండ్లిదిఙ్‌ సిఏర్‌ వారు పరలోకమ్‌దు మన్ని దేవుణు దూతెఙలెకెండ్‌ మంజినార్. ");
INSERT INTO kfc_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","సతి వరిఙ్‌ దేవుణు మర్‌జి నిక్నివందిఙ్‌ మోసె రాస్తి పుస్తకమ్‌దు, వెయ్‌జి మహి తుపెఙా ‌డగ్రుహాన్‌ దేవుణు మోసెఙ్‌ వర్గితి మాట మీరు సద్‌విఇదెరా? నాను, అబ్రాహం దేవుణు, ఇస్సాకు దేవుణు, యాకోబురిదేవుణు, ఇజి దేవుణు అయవలె వెహ్తన్‌ ");
INSERT INTO kfc_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","అందెఙె వాండ్రు సాతిసొహికార్‌ మాడిఃసిని దేవుణు ఆఏన్‌ బత్కిజి మన్నికార్‌ మాడిఃసిని దేవుణునె ఇజిమాటు సుడిఃజినాట్‌. సాతికార్‌బత్కిఏర్‌ ఇజి మీరు వెహ్తిక గొప్ప తప్ప. ");
INSERT INTO kfc_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","యూదురిఙ్‌ రూలు నెస్‌పిస్నివరి లొఇ ఒరెన్‌బానె వాజి యేసు సదుకయ్‌రుఙవెట వాదిసినిక వెహాన్‌. వారు మర్‌జి వెహ్తెఙ్‌ అట్‌ఇవజ యేసువరిఙ్‌ జబాబ్‌ సిత్తాన్‌ ఇజి సుడ్ఃజి వాండ్రు వెన్‌బాతాన్‌ దేవుణు సిత్తి విజు రూలుఙలొఇ ముకెలమాతిక ఎమేణిక?”. ");
INSERT INTO kfc_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","దన్నిఙ్‌ యేసు వెహ్తాన్‌, “విజు వన్కాఙ్‌ లొఇ ముకెలమాతిక యాకదె, “ఓ ఇస్రాయేలుదికిదెరా, మీరు వెండ్రు. ప్రబువాతి మా దేవుణు ఒరెండ్రె. ");
INSERT INTO kfc_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","నీను నీ పూర్తి మన్సుదాన్, పూర్తి పాణమ్‌దాన్, పూర్తి బుద్దిదాన్, పూర్తి సత్తుదాన్‌ ప్రబువాతి దేవుణుదిఙ్‌ ప్రేమిస్తెఙ్”. ");
INSERT INTO kfc_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","దిన్నీ వెనుక ముకెలమాతి రూలు ఇనిక ఇహిఙ, “నీను నిఙినె ప్రేమిస్నిలెకెండ్‌ మహివరిఙ్‌ విజేరిఙ్‌ ప్రేమిస్అ”, యా రుండి రూలుఙ మిస్తిక రూలుఙ్‌ మరి ఎమేణికబా సిల్లెద్‌. ");
INSERT INTO kfc_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","నస్తివలె అయ మణిసి వెహ్తాన్‌. ఓ బోదకినికి నీను బాగ వెహ్తి. “దేవుణు ఒరెండ్రె. వాండ్రు తప్ప మరి ఎయెన్‌ దేవుణు సిలెన్”, ఇజి నీను వెహ్తిక నిజమె. ");
INSERT INTO kfc_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","నీ పూర్తి పాణమ్‌దాన్, పూర్తి బుద్దదాన్‌ పూర్తి సత్తుదాన్‌ నీ దేవుణుఆతి ప్రబుఙ్‌ ప్రేమిస్తెఙ్‌, నిఙి నీనె ప్రేమిస్నివజ మహివరిఙ్‌ ప్రేమిస్నిక, దేవుణుదిఙ్‌ సీజిని విజు పూజెఙ ముస్కు, దేవుణుదిఙ్‌ కిజిని దూపమ్‌కాఙ్‌ ముస్కు నండొ ముకెలమాతిక”. ");
INSERT INTO kfc_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","యేసు వెహ్తిక వాండ్రు నెగ్రెండ అర్దం కిజి జబాబ్‌ వెహ్తాన్‌‌ ఇజి సుడ్ఃజి యేసు ఈహు వెహ్తాన్‌. “నీను దేవుణుదిఙ్‌ ఏలుబడిః అడిగి మండ్రెఙ్‌ డగ్రు ఆతి. అబ్బెణాన్‌ ఎయెన్‌బా యేసుఙ్‌ ఇనికబా వెన్‌బాదెఙ్‌ దయ్‌రం సిల్లెద్‌. ");
INSERT INTO kfc_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ఒర్సు యేసు దేవుణుగుడిఃదు నెస్‌పిసి మహిఙ్‌ ఈహు వెన్‌బాతాన్. రాజువజ వాని క్రీస్తు పూర్‌వమ్‌దు మహి దావీదురాజు కుటుమ్‌దు పుట్నాన్‌ ఇజి యూదురిఙ్‌ రూలుఙ్‌ నెస్‌పినికార్‌ ఎందనిఙ్‌ వెహ్సినార్‌? ");
INSERT INTO kfc_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","దావీదురాజు దేవుణుఆత్మదాన్‌ ఈహు వెహ్తాన్‌‌: “నాను నీ పగ వరిఙ్‌ నీ పాదం అడ్గి ఇడ్నిదాక నీను నా ఉణెర్‌ పడక బసి మన్‌అ ఇజి ప్రబు నా ప్రబువెట వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","దావీదురాజు క్రీస్తుఙ్‌ ప్రబుఇజి కూక్సినాన్. అహిఙ ఎలాగ క్రీస్తు వన్ని మరిసి ఆనాన్‌?”. యేసు వెహ్తిక వెంజి లోకుర్‌విజేరె నండొ సర్ద ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","యేసు లోకాఙ్‌ నెస్‌పిసినివెలె ఈహు వెహ్తాన్‌. “యూదురి రూలుఙ్‌ నెస్‌పిసినివరి వందిఙ్‌ జాగర్త మండ్రు. వారు నండొ దరది నీరి సొక్క తొడ్‌గిజి బూలాదెఙ్‌ కొరిజినార్. సత్తెఙ నడిఃమి పెరికార్‌ ఇజి ‌మాడిఃసి ఆదెఙ్‌ కొరిజినార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","యూదురి మీటిఙ్‌ ఇండ్రొ సొహిఙ ముకెలమాతి బాడ్డిదు బస్తెఙ్‌, విందుదు సొహిఙ బస్తెఙ్‌ ముకెలమతి బాడ్డిదు వారు కోర్‌జినార్. ");
INSERT INTO kfc_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ఇనిక సిల్లి ముండమణిసిఙ్‌ మొసెం కిజి వన్కాఙ్‌ కల్గితిక వారు ఒనార్. లోకుర్‌ విజేరె విరిఙ్‌సుడ్ఃజి గొప్ప నెగ్గికార్‌ ఇజి వెహ్నివజ వారు నండొ పార్దనం కిజినార్. నిని లోకాఙ్‌ గొప్ప సిక్స వానాద్”. ");
INSERT INTO kfc_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","యేసు దేవుణుగుడిఃదు సంత సీనిపెటె ఎద్రుబస్తాన్. దేవుణుగుడిఃదు వాతికార్‌ సంత పెటెదు డబ్బు అర్‌ప్సిమహిక వాండ్రు సుడ్ఃజి మహాన్‌. ఆస్తిమన్నకార్‌ నండొండార్‌ నండొ డబ్బుఙ్‌ ఆ పెటెదు అర్‌ప్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","నస్తివలె ఉండ్రి బీద ముండ మన్సి వాజి రుండి కాణిఙ్‌ అర్‌ప్తాద్. ");
INSERT INTO kfc_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","యేసు సిసూరిఙ్‌ ‌వన్నిడగ్రు కూక్సి, “నాను నిజం వెహ్సిన, దేవుణు సుడ్‌తిఙ్‌ యా ఇనిక సిల్లి రాండి బోదెలి మహివిజేరిఙ్‌ ముస్కు లావు అర్‌ప్తాద్. ");
INSERT INTO kfc_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ఆస్తిమన్నికార్‌ వరిఙ్‌ కల్గితి ఆస్తిబాణిఙ్‌ అర్‌ప్తాద్‌. గాని అది దన్నిఙ్ సిల్లిబాణిఙ్‌ దన్నిఙ్‌ బత్కిదెఙ్‌ మన్నికెఙ్‌ విజు సంత పెట్టెదు అర్‌ప్తాద్‌”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","యేసు దేవుణుగుడిఃదాన్ సొన్సి మహిఙ్‌ వన్ని సిసూర్‌ లొఇ ఒరెన్, “ప్రబు యా పణుకుఙ్‌ ఎస్సొ గొప్పవి యా మేడెఃఙ్‌ ఎస్సొ గొప్పవి”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","పన్నిఙ్‌ యేసు వెహ్తాన్‌, “మీరు ఏలు సుడ్ఃజిని యా గొప్ప నెగెండ్‌ తోర్‌జిని మేడెఃఙ్‌ ఉండ్రి పణుకు ముస్కు మరి ఉండ్రి పణుకు నిల్సిమన్‌ఏండ లోకుర్‌ వనకాఙ్‌ లాగ్న అర్‌ప్నారె పూర్తి నాసనం కినార్‌లె”. ");
INSERT INTO kfc_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","యేసు దేవుణుగుడిః ఎద్రు ఒలివ గొరొత్, బస్తి మహిఙ్‌ పేతురు, యాకోబు, యోహాను, అంద్రెయ ఇనికార్‌ మరి ఎయెర్‌బా వెన్‌ఎండ యేసుఙ్‌ వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“యాకెఙ్‌ ఎసెఙ్‌ జర్గినెలె? ఇక్కెఙ్‌ విజు జర్గిదెఙ్‌ డగ్రు ఆతాద్‌. ఇజి తొరిసిని గుర్తు ఇనిక? మఙి వెహ్‌అ. ");
INSERT INTO kfc_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","యేసు వరిఙ్‌ వెహ్తాన్‌, “ఎయెర్‌బా మిఙి మోసెం కిఎండ జాగర్త సుడ్ఃదు మండ్రు. ");
INSERT INTO kfc_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","నండొ లోకుర్‌ నా పేరు ఇడెఃఆజి వానారెలె. “దేవుణు ఏర్‌పాటు కిత్తి పొక్తి క్రీస్తు నానె”, ఇజి వెహ్సి నండొండారిఙ్‌ మోసెం కినార్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","మీరు విద్దెమ్‌కు వందిఙ్ వినిదెర్లె. మరి విద్దెమ్‌కు వానెలె ఇజి సాటిసినిక వెనిదెర్లె. అయవలె తియెలామ. అక్కెఙ్‌ విజు జర్గిదెఙ్‌వెలె. గాని యాక ఆక్కర్‌ ఆఏద్. ");
INSERT INTO kfc_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","లోకుర్‌ముస్కు లోకుర్‌ని దేసమ్‌కాఙ్‌ ముస్కు దేసమ్‌కు విద్దెం ఆనాలె. అబ్బె ఇబ్బె నండొబాన్‌ బూమి కద్లినాద్లె. కరు వానాద్లె. యాక్కెఙ్‌ విజు ఉండ్రి బోదెలి కియుదు అస్తెఙ్‌ ముఙల వానినొపిఙ్‌ మొదొల్‌స్తిలెకెమడ్‌ ఇక్కెఙ్‌ విజు జర్గిజి మహిఙ ఆక్కర్‌ దినమ్‌కు వాజినాద్‌ ఇజి నెస్తెఙానాద్. ");
INSERT INTO kfc_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","మీరు జాగర్త మండ్రెఙ్. లోకుర్‌ మిఙి కొర్‌టుదు‌ ఒపజెప్నార్లె. యూదురి మీటిఙ్‌ ఇల్కాఙ్‌ మిఙి కొరెడెఃఙాణిఙ్‌ డెఃయ్‌నార్లె. రాజుర్‌ఙ ముందాల అదికారిఙ ముందాల, నా ముస్కు నమకం ఇట్తివందిఙ్‌ మిఙి నిల్‌ప్నార్‌లె. అయావెలె నా వందిఙ్‌ సువార్త వెహ్నిదెర్లె. ");
INSERT INTO kfc_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","దేవుణు సువార్త బూమిముస్కు మని విజేరిఙ్‌ ఆక్కర్‌ దినమ్‌కాఙ్‌ ముఙల వెహ్తెఙ్‌వలె. ");
INSERT INTO kfc_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","వారు మిఙి తొహ్సి ఒసి కోర్టుదు ఒప్పజెప్నివెలె మీరు అబ్బె ఇనిక వెహ్తెఙ్‌ ఇజి బెఙ ఆమాట్. అయవలె దొహ్‌క్నెలె. వెహ్నికిదెర్‌ మీరు ఆఇదెర్‌ దేవుణు ఆత్మ మిఙి వెహ్నికాదె మీరు వెహ్నిదెర్”. ");
INSERT INTO kfc_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","యేసు మరి వెహ్తాన్‌. “దాద్సి తంబేర్సిఙ్‌ తంబెర్‌సి దాద్సిఙ్‌ అప్పొసి మరిసిఙ్‌ సప్తెఙ్‌ ఒపజెప్నాన్‌లె. కొడొర్‌ అయ్‌సి అపొసిర్‌ ముస్కు గొడఃబఆజి వరిఙ్‌ సప్నార్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","మీరు నా ముస్కు నమకం ఇడ్తివందిఙ్‌ విజేరె మీ ముస్కు పగదాన్‌ మంజినార్‌లె. ఆక్కర్‌దాక ఓరిస్ని వన్నిఙ్‌ దేవుణు రక్సినార్లె. ");
INSERT INTO kfc_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","దేవుణుగుడిః లొఇ మండ్రెఙ్‌ ఆఇ నాసనం కిని సెఇక ఆతిక ఉండ్రి దేవుణు గుడిఃదు నెగ్గి బాడ్డిదు నిల్సి మంజినిక సూణివలె (యాక సద్‌వినికాన్ అర్దం కిదెఙ్‌వలె) యూదయ దేసెమ్‌దు మంజినికార్‌ గొరొకాఙ్‌ ఉహ్తెఙ్‌ వెలె. ");
INSERT INTO kfc_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ఇల్లు ముస్కు మన్నికార్‌ ఇనికబా సామానం తత్తెఙ్‌ ఇజి మర్‌జి ఇండ్రొ సొన్మాట్. ");
INSERT INTO kfc_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","గుడెదు పణి కిజి మహికార్‌ వరి పాత తత్తెఙ్‌ ఇజి మర్‌జి ఇండ్రొ సొనిక ఆఏద్‌. ");
INSERT INTO kfc_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ఆ దినమ్‌కాఙ్‌ పోటద్‌ మన్ని వన్కాఙ్‌ పాలు ఊట్‌పిసిని వనకాఙ్‌ గొప్ప కస్టం. ");
INSERT INTO kfc_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ఇక పినికాలమ్‌దు రెఏండ పార్దనం కిదు. ");
INSERT INTO kfc_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ఎందానిఙ్‌ ఇహిఙ దేవుణు యా లోకం పుటిస్తిబాణిఙ్‌ అసి ఏలుదాక రెఇనిన్ని గొప్ప కస్టమ్‌కు వానె. నిన్నికెఙ్‌ మరి ఎసెఙ్‌బా రెఉ. ");
INSERT INTO kfc_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","దేవుణు ఆ కస్టం ఆతి రోస్కుతకు కిఏండ మహిఙ ఎయెన్‌బా తప్రె ఆదెఙ్‌ అఅట్‌ఏన్. గాని దేవుణు ఎర్లిస్తివరి వందిఙ్‌ ఆ రోస్కుకు దేవుణు తక్కు కిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ఆ రొస్కాఙ్‌ ఎయెర్‌బా ఇదిలో క్రీస్తు అబ్బె మనాన్, సిల్లిఙ క్రీస్తు ఇబ్బె మనాన్, ఇజి వెహ్తిఙ వరి మాట నమ్మిమాట్. ");
INSERT INTO kfc_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ఆ కాలమ్‌దు నానె క్రీస్తు ఇజి అబద్దం వెహ్నికార్, నానె దేవుణు పోక్తి ప్రవక్త ఇజి అబద్దం వెహ్నికార్‌ వానార్. వారు నండొ బమ్మాతి పణిఙ్‌ ముఙాల ఎసెఙ్‌బా తొఇ నన్ని బమ్మాతి పణిఙ్‌కిజి మోసెం కిదెఙ్‌ సూణార్. అట్తిఙ దేవుణు ఎర్‌లిస్తి మన్ని వరిఙ్‌బా మొసెం కిదెఙ్‌ సూణార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","అందెఙె మీరు జాగర్త మండ్రెఙ్. నాను ముఙాలె విజు మిఙి వెహ్త మన్న. ");
INSERT INTO kfc_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","ఆ కస్టమాతి రోస్కుసొహి వెనుక పొదు సీకటి ఆనాద్. నెల జాయ్‌ సిఏద్. సుక్కెఙ్‌ ఆగసమ్‌దాన్‌ రాల్నె. ఆగాసమ్‌దు మన్నికెఙ్‌ కద్లినె. ");
INSERT INTO kfc_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","నస్తివలె లోకు మరిసియాతి నండొ సత్తుదాన్‌ గొప్ప జాయ్‌దాన్‌ కూడిఃతి సొకుదాన్ మొసొప్‌ ముస్కువానిక లోకుర్‌ సూణార్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","నాను నా దూతరిఙ్‌ పోక్నానె యా లోకమ్‌ది కొసెఙదాన్‌ ఆగసమ్‌ది కొసెఙదాక నాల్గి మూలెఙాణిఙ్‌ దేవుణు ఎర్‌లిస్తి వరిఙ్‌ ఉండ్రెబాన్‌ తపిస్న. ");
INSERT INTO kfc_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","బొడెమరాన్‌దిఙ్‌ సుడ్ఃజి యాక మీరు నెస్తు. దన్ని ఆక్కుఙ్‌ రాల్‌జి సిగ్రిసినివలె ఎండకాలం డగ్రు ఆతాద్‌ ఇజి మీరు నెస్నిదెర్. ");
INSERT INTO kfc_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ఆయలెకెండ్‌నె మీరు యాక్కెఙ్‌ విజు జర్గిజినిక సుణివలె నాను మర్‌జి వాదెఙ్‌ డగ్రు ఆతాద్‌ ఇజి నెస్‌సినిదెర్‌లె. ");
INSERT INTO kfc_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","యా సఙతిఙ్‌ విజు జార్గిని ముందాల య తరమ్‌దికార్‌ సాఏర్‌ ఇజి నాను మిఙి నిజం వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ఆగసం బూమి సిల్లెండ ఆనె. గాని నా మాటెఙ్‌ ఎలాకాలం మంజినె. ");
INSERT INTO kfc_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","నాను మర్‌జి వాని రోజువమదిఙ్, గడిఃయవందిఙ్‌ ఎయెఙ్‌ నెస్‌ఏర్‌. బుబ్బనె ఆఏండ పరలోకమ్‌దు మన్ని దూతార్‌బా మరిసిబా నెస్‌ఏర్‌. ");
INSERT INTO kfc_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","యేసు మరి వెహ్తాన్‌, “మీరు పార్దనం కిజి జాగర్త మండ్రు. ఆ రోజు ఎసెఙ్‌వానాదొ మిఙి తెలిఏద్. ");
INSERT INTO kfc_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ఎలాగ ఇహిఙ ఒరెన్, ఎజుమాని వన్ని ఇల్లు వన్ని పణిమన్సిరిఙ్‌ ఒపజెప్సి, వరివరిపణిఙ్‌ వరి వరిఙ్‌ తోరిసి, ఇల్లు కాపుదిఙ్‌ ఒరెన్‌ వన్నిఙ్‌ ఇడ్జి దేసం సొండ్రెఙ్‌ సొహి వజనె. ");
INSERT INTO kfc_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","అందెఙె మీరు జాగర్త ఎద్రుసుడిఃజి మండ్రు. ఎందనిఙ్‌ ఇహిఙ ఇల్లు ఎజుమాని పొద్దు ఆతివెలె వానానొ, మదరెయ్తు వానానొ, కొరు కెరెని వెలె వానానొ, సిల్లిఙ జాయ్‌ఆతిఙ వానానొ మిఙి తెలిఏద్. ");
INSERT INTO kfc_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ఎజుమాని వందిఙ్‌ ఎద్రు సుడిఃఇ గడిఃయదు వెటనె వాతిఙ మీరు నిద్ర కిజి మనికవాండ్రు సుడుఃదెఙ్‌ ఆఏద్‌. ");
INSERT INTO kfc_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","నాను మిఙి వెహ్తికదె విజేరిఙ్‌బా వెహ్సిన. జాగర్త కాప్‌కిదు”. ");
INSERT INTO kfc_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","పస్క పండొయ్‌ని, పులాఙ్‌ ఆఇ రొట్టెఙ్‌ పండొయ్‌వాదెఙ్‌ రుండి రోస్కు మనాద్. పెరిపుజెరిఙుని, యూదుర్‌ రూలు నెస్‌పిసినికార్‌‌ యేసుఙ్‌ ఎలాగబా ఉపాయ్‌కిజి అసి సప్తెఙ్‌ సుడిఃజినార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","“పండొయ్‌లొఇ వన్నిఙ్‌ తొహ్తిఙ లోకు గొడఃబ కినార్‌ అందెఙె పండొయచ లొఇ పోని ఇజి వారు వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","యేసు బేతనియ ఇనినాటో సీమోను ఇన్ని వన్ని ఇండ్రొ బోజనమ్‌దిఙ్‌ బస్తాన్. విండ్రు కుస్టురోగం ఆస్తిమహిఙ్‌ యేసు నెగెండ్ కిత్త మహాన్ నస్తివలె ఉండ్రి బోదెలి నూనఙ్‌ పణుకుదాన్‌ తయార్‌ కిత్తి ఉండ్రి సీసాదు నండొ విలువమన్ని జటమామ్సి ఇని నెగ్గి వాసనం మన్ని నూనె తత్తాదె మూతడగ్రు రెక్సి యేసు బురాదు వాక్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","5","అబ్బె మహికార్‌ సెగొండార్‌ యాక సుడ్ఃజి కోపమాజి వరిలొఇ వారె వెహ్తార్‌, “ఎందానిఙ్‌ యా నూనె పాడు కిజినాద్‌? యా నూనె మూండ్రి వందెఙ్‌ దినారమ్‌ఙ్‌ ముస్కు డబ్బుదిఙ్‌ పొర్సి అయ డబ్బు బీదది వరిఙ్‌ ‌సీదెఙ్‌ ఆనాద్‌గదె”, ఇజి దన్నిఙ్‌ గోల కిత్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","నస్తివలె యేసు, “దన్నిఙ్‌ ఉండ్రి డిఃస్తు ఎందనిఙ్‌ దన్నిఙ్‌ అర్ల కిబిసినిదెర్? అది నఙి నెగ్గి పణి కిత్తాద్. ");
INSERT INTO kfc_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","బీదదికార్‌ ఎస్తివలెబా మీవెట మంజినార్. వరిఙ్‌ ఎసెఙ్‌బా మీరు సాయం కిదెఙానాద్. గాని నాను ఎలాకాలం మీవెట మన్‌ఏ. ");
INSERT INTO kfc_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","అది కిదెఙ్‌ అట్నిపణి విజు కిత్తాద్. నఙి సమాది కిని ముఙాల పీనుగు తయార్‌కిని అలవాటువజ నా ఒడొఃల్‌దిఙ్‌ వాసనం నూనె వాక్సి అది నఙి తయార్‌ కిత్తాద్. ");
INSERT INTO kfc_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","నాను మీవెట నిజం వెహ్సిన, యా బూమి ముస్కు ఎంబెబా దేవుణు సువార్త అది ఏలుబడిః వందిఙ్‌ సువార్త సాటిసినివలె అది కిత్తి యా నెగ్గిపణి దన్నిఙ్‌ ఎత్తు కినిలెకెండ్‌ సాటిసి మంజినాదెలె”. ");
INSERT INTO kfc_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","నస్తివలె పన్నెండు మణిసిర్‌ సిసూర్‌లొఇ ఒరెన్‌ ఇస్కరియోతు యూద ఇనికాన్‌ యూదురి పెరిపుజెరిఙబాన్‌ సొన్సి యేసుఙ్‌ ఒపజెప్తెఙ్‌ తోడుః కిన ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","యూదవెహ్తిక వెంజి పెరిపుజెరిఙు సర్ద ఆతార్. వన్నిఙ్‌ డబుఙ్‌ సీనాప్‌ఇజి వారు ఒట్టు కితార్. అందెఙె యేసుఙ్‌ ఒపజెప్తెఙ్‌ యూద ఉండ్రి అవ్‌కాసం సుడ్ఃజి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","పులాఙ్‌ సిల్లి రొట్టెఙ్‌ తయార్‌ కిని పస్కపండొయ్‌ది మొదోహి దినం వాతాద్. అయ దినం దేవుణుదిఙ్‌ మెండ గొర్రె పిల్లాదిఙ్‌ పూజ కినిక యూదురి అలవాట్. యేసు సిసూర్‌ వన్ని డగ్రు వాజి, పస్క బోజనం ఉండెఙ్‌ నీవందిఙ్‌ మాపుఎంబె సొన్సి తయార్‌ కిదెఙ్‌ నీను కొరిజిని? ఇజి వెన్‌బ్‌తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","యేసు రిఎర్‌ సిసూరిఙ్‌ ‌కూక్సి, “మీరు పట్నమ్‌దు సొండ్రు. అబ్బె ఒరెన్, కుండాదు ఏరు పిండ్‌జి మీ ఎద్రు వానాన్. మీరు వన్నివెట సొండ్రు. ");
INSERT INTO kfc_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","వాండ్రు సొహి ఇండ్రొణి ఎజుమానిఙ్‌, “నా సిసూర్‌ వెట పస్క బోజనం కిదెఙ్‌ఎంబె గది మనాద్‌ ఇజి బోదకినికాన్‌ నిఙి వెన్‌బాజినాన్’, ఇజి వెహ్తు. ");
INSERT INTO kfc_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","నస్తివలె ఆ ఇల్లు ఎజుమాని విజు తయార్‌ఆతి మేడముస్కు మని పెరి గది ఉండ్రి తోరిస్నాన్. అబ్బె మఙి పస్క బోజనం తయార్‌కిదు”, ఇజి వెహ్తండ్రె పొక్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","సిసూర్‌పట్నమ్‌దు సొహరె యేసు వెహ్తిలెకెండ్‌నె విజు సుడ్ఃతార్. వారు పస్క బోజనం తయార్‌ కితార్. ");
INSERT INTO kfc_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","పొద్దు ఆతిఙ్‌యేసు పన్నెండు మంది సిసూర్‌వెట అబ్బె వాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","వారు బోజనం కినివెలె యేసు వెహ్తాన్‌, “మీ లొఇ ఒరెన్‌ నఙి పగాతివరి కియుదు ‌ఒపజెప్నాన్లె ఇజి నాను నిజం వెహ్సిన”. ");
INSERT INTO kfc_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","అక్క వెంజి వారు నండొదుకం ఆజి ఒరెన్‌ వెనుక ఒరెన్‌ “నాను ఆఏగదె? ఇజి వన్నిఙ్‌ వెన్‌బాతార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","యేసు వెహ్తాన్‌, “మీరు పనెండు మనిసిర్‌లొఇ ఒరెన్, నావెట గినెదు రొట్టె ముడ్ఃక్నికాండ్రె. ");
INSERT INTO kfc_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","లోకుమరిసి నా వందిఙ్‌ దేవుణు మాటదు రాస్తి మహిలెకెండ్‌ నాను సానాన్లె. గాని లోకు మరిసియాతి నఙి ఒపజెప్ని వన్నిఙ్‌ గొప్ప కస్టం. వాండ్రు పుట్‌ఏండ మంజినిక ఇహిఙ వన్నిఙ్‌ ఎస్సొనొ బాగ మహాద్‌ మరి”. ");
INSERT INTO kfc_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","వారు బోజనం కిజిమహిఙ్‌యేసు ఉండ్రిరొట్టె అస్తాండ్రె దేవుణుదిఙ్‌ వందనమ్‌కు వెహ్సి ముకెఙ్‌ కిజి సిసూరిఙ్‌ సితాన్. “మీరు యక లొసితిండ్రు, ఇక నా ఒడొఃల్”, ఇజి వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","వెనుక యేసు ద్రాక్స కల్లు మన్న గిన అసి దేవుణుదిఙ్‌వందనమ్‌కు కిజి వరిఙ్‌ సితాన్. వారు విజేరె ఆ గినదిక ఉటార్. ");
INSERT INTO kfc_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","యేసు మరి వెహ్తాన్‌. “ఇక్క నా నల, నండొండారిఙ్‌ వరి పాపమ్‌కు సెమిస్తెఙ్‌ ఇజి కారిసిని. నా నల ఇక్కాదె దేవుణు నా నలదాన్‌ కిజిని ఒపుమానం. ");
INSERT INTO kfc_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","నాను నిజం వెహ్సిన, దేవుణు కినిఎలుబడిఃదు నాను కొతాఙ్‌ ఉణి దినం దాక మరి ఎసెఙ్‌బా ద్రాక్స కల్లు ఉణెఏ”. ");
INSERT INTO kfc_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","మరి ఉండ్రి పాట పార్తారె ఒలివ మరెక్‌ మన్ని గొరొన్‌ ముస్కు సొతార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","వారు సొనివెలె యేసు వరిఙ్‌ వెహ్తాన్‌. మీరు విజిదెరె నఙి డిఃసి సొనిదెర్లె. ఎందనిఙ్‌ఇహిఙ దేవుణు మాటదు యాలెకెండ్‌ రాస్త మనాద్. “గొర్రెఙ్ అడినివన్నిఙ్‌ నాను కత్నాలె. గొర్రెఙ్సె మంద సెద్రీనె సొనెలె”. ");
INSERT INTO kfc_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","గాని దేవుణు నఙి మర్‌జి బత్కుదు నిక్తివెనుక మిఙి ఇంక ముఙల గలీలయదు సొనాలె. ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","నస్తివలె పేతురు, “విజేరె మీ వందిఙ్ నిల్దెఙ్‌ అట్‌ఏండ డిఃసి సొహిఙ్‌బా నాను నిఙి డిఃస్‌ సొన్‌ఏ”. ");
INSERT INTO kfc_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","యేసు వెహ్తాన్‌, “ఓ పేతురు, నాను నిఙి నిజం వెహ్సిన, యా పొదొయ్‌ కొరు రిజకెరెని ముఙల నీను నఙి నెస్‌ఎ ఇజి ముసార్‌ వెహ్నిలె”. ");
INSERT INTO kfc_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","గాని పేతురు ఒపుకొడ్ఃఏండ ఒద్దె డట్టం వెహ్తాన్‌, “నాను నీ వెట సాతిఙ సాన. నాను నిఙి నెస్‌ఎ ఇజి వెహ్‌ఏ”. అయ వజనె వారు విజేరె వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","నస్తివలె యేసు, వన్నిసిసూర్‌వెట గెత్సేమనె ఇని టోటదు సొహర్‌. యేసు సిసూరిఙ్‌, “నాను సొన్సి పార్దనం కిజి మర్‌జివాని దాక మీరు ఇబ్బె మండ్రు”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","యేసు పేత్రుఙ్, యాకోబుఙ్, యోహనుఙ్‌ వన్ని వెట ఒతాన్. వాండ్రు నండొ దుకం ఆజి బాద ఆదెఙ్‌ మొదోల్‌స్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","వాండ్రు వరిఙ్‌ వెహ్తాన్‌, “సాదెఙ్‌ డగ్రు ఆతిలెకెండ్‌ మన్సు బరిస్తెఙ్‌ అట్‌ఇ నస్సొ బాదనఙి కల్గిజినాద్‌. మీరు ఇబ్బెనె బసి నా వెటె తెల్లి మండ్రు. ");
INSERT INTO kfc_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","యేసు అబ్బెణిఙ్‌ సెగం దూరం సొహాండ్రె పడిగ్‌జి అర్తాండ్రె “ఓబా, నిఙి ఇస్టమాతివజ యా కస్టమ్‌కాణ్‌ నఙి తప్రిస్‌అ”, ఇజి పార్దనం కితాన్. ");
INSERT INTO kfc_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","యేసు దేవుణుదిఙ్‌ ఈహు వెహ్తాన్‌, “ఓ బా నీను విజు కిదెఙ్‌అట్ని. యా కస్టమ్‌కు నా బాణిఙ్‌లాగ్‌అ. గాని నా ఇస్టమ్‌వజ ఆఎద్‌, నీ ఇస్టంవజనె ఆపిద్”. ");
INSERT INTO kfc_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","పార్దనం కితివెనుక యేసు సిసూర్‌డగ్రు సొహిఙ్‌ వారు నిద్ర కిజి మహార్‌, “ఓ సీమోను, నీను నిద్ర కిజినిదా? ఉండ్రి గంటబా తెలి ఆజి మండ్రెఙ్‌ మీరు అట్‌ఇదెరా?”, ఇజి పేతురుఙ్‌ వెన్‌బాతాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","సయ్తును మిఙి పరిస కిజి తప్పదు అస్‌ఏండ ఇహిఙ పార్దనం కిజి తెలి ఆజి మండ్రు ఆత్మ తయార్‌నె, గాని ఒడొఃల్‌దిఙ్‌‌ సత్తు సిల్లెండ ఆజినాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","యేసు మరి ఒర్సు సొన్సి ముఙాల్‌ వెహ్తి మాటెఙ్‌నె వెహ్సి పార్దనం కితాన్. ");
INSERT INTO kfc_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","యేసు మర్‌జివాజి సుడ్ఃతిఙ్‌ సిసూర్‌ మరి నిద్ర కిజి మహార్‌. ఎందానిఙ్‌ ఇహిఙ వరి కణుకు రెప్పెఙ్‌ బరుదాన్‌ ముగ్‌జి మహె. నస్తివలె వారు యేసుఙ్‌ ఇనిక వెహ్తెఙొ తెలిఏతాద్. ");
INSERT INTO kfc_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","యేసు ముసారి వాజి సిసూర్‌ నిద్ర కిజి మహిక సుడ్ఃజి వరిఙ్‌ వెహ్తాన్‌, “ఏలుబ మీరు నిద్ర కిజి రోమ్‌జినిదెరా? ఏలు ఆనాద్. ఇదిలో, లోకుమరిసియాతి నఙి సెఇవరికియుదు ఒపజెప్ని గడిఃయ డగ్రు వాతాద్. ");
INSERT INTO kfc_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","లెదు, ఏలు మాట్‌ వరివెట. దసూలాదెఙ్‌ సొనాట్‌ ఇదిలో నఙి ఒపజెప్నికాన్‌ వాజినాన్”. ");
INSERT INTO kfc_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","యేసు యా మాటెఙ్‌ వెహ్సిమహిఙ్‌ పన్నెండు మనిసిర్‌ సిసూర్‌లొఇ ఒరెనాతి ఇస్కరి యోతు యూద ఇనికాన్‌ అబ్బె వాతాన్. పెరిపుజేరిఙు లోకురి పెద్దలుఙు పోక్తిమన్ని మందలోకుర్‌ కూర్దెఙ్‌, కోణెఙ్‌ అస్తారె వన్నివెట వాతర్‌. ");
INSERT INTO kfc_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","యేసుఙ్‌ ఒపజెప్నికాన్‌, “నాను ఎయెరిఙ్‌ ముద్దు కినానొ వన్నిఙ్‌ మీరు తొహ్‌సి జాగర్త ఒతు”, ఇజి ముఙల వరిఙ్‌ ఉండ్రి గుర్తులెకెండ్‌ వెహ్త మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","యూద వెటనె యేసుడగ్రు వాతాండ్రె, “ఓ బోదకినికి’ ఇజి వెహ్సి వన్నిఙ్‌ పొంబితాండ్రె ముదు కిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","నస్తివలె వన్నివెట వతిమహిలోకుర్‌ యేసుఙ్‌ అస్తారె తొహ్తర్. ");
INSERT INTO kfc_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","వెటనె యేసుడగ్రు మహిసిసూర్‌ లొఇ ఒరెన్, వన్ని కూర్ద లాగ్జి విజెరి ముస్కు పెరిపుజెరిఙ ముస్కు మన్ని పణిమనిసి ఆతి వని గిబ్బి తెవు కత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","యేసు వెహ్తాన్‌, “నాను డొఙవాండ్రునా? నఙి అస్తెఙ్ కూర్దెఙ్ కోణెఙ్‌ అసి ఎందనిఙ్‌ మీరు వాతిదెర్‌? ");
INSERT INTO kfc_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","రోజు నాను మీ వెటనె మంజి దేవుణుగుడిఃదు నెస్‌పిస్త గదె. అయవలె మీరు నఙి ఎందనిఙ్‌ అస్‌ఇతిదెర్‌? గాని దేవుణు మాటదు రాస్తివజ ఇక విజు ఈహు జర్గిదెఙ్‌ వెలె”. ");
INSERT INTO kfc_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","నస్తివలె వన్ని సిసూర్‌ విజేరె వన్నిఙ్‌ డిఃస్తారె ఉహ్‌క్త సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","ఒరెన్‌ దఙడాఃయెన్, యేసు వెనుక, లోకుర్‌ వెట సొన్సి మహాన్‌. వాండ్రు సొక్క తొడ్‌గిఏండ ఉండ్రి పాతనె పి‌డ్‌గిత మహాన్‌. వారు వన్నిఙ్‌ అస్తిఙ్‌ వాండ్రు పిడిగితిమన్ని పాతడిఃసి డుమ్‌డ ఆతాండ్రె ఉహ్‌క్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","యేసుఙ్‌ తొహ్సి ఒతికార్‌ వన్నిఙ్‌ విజెరిపుజేరిఙ ముస్కు పెరిపుజెరిబాన్‌ తత్తార్. పెరిపుజెరిఙ్‌ విజేరె, పెద్దెల్‌ఙు, యూదురి రూలుఙ్‌ నెస్‌పిసినికార్‌ అబ్బె కూడ్జి వాత మహార్. ");
INSERT INTO kfc_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","యేసుఙ్‌ విజేరి ముస్కు పెరిపుజెరిఙ ఇండ్రొ ఒసిమహిఙ్, పేతురు వెనుక దూరమ్‌దాన్‌ సొన్సి డేవ దాక వాతాన్. వాండ్రు అబ్బె కాప్‌కినివరివెట బస్తాండ్రె సిసు కాయ్‌జి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","పెరిపుజెరిఙు విజేరె, అబ్బె కూడ్జి వాతి సన్‌హద్రిం సఙం విజు యేసుఙ్‌ సప్తెఙ్‌ తగితి రుజుప్‌ వందిఙ్‌ వన్ని ఎద్రు అబద్దం వెహ్నివరిఙ్‌ రెబాజి మహార్‌. గాని వన్నిఙ్‌ సప్తెఙ్‌ అగితి రుజుప్‌ వెహ్ని ఎయెర్‌బా దొహ్‌క్‌ఏతార్. ");
INSERT INTO kfc_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","నండొండార్‌ వన్నిముస్కు అబద్దం సాసెమ్‌కు వెహ్తార్‌. గాని ఒరెన్‌ వెహ్తిక మరి ఒరెన్‌ వెహ్తి దనిఙ్‌ తేడః మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","నస్తివలె సెగొండార్‌ వన్నిముస్కు ఈహు అబద్దం సాసెమ్‌కు వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“లోకు తొహ్తి యా దేవుణుగుడిఃదిఙ్‌ నాను అర్‌ప్సి విసీర్‌జి, మూండ్రి రోస్కాఙ్‌ ‌లోకు కీదు పణి ఆఎండ మరి ఉండ్రి దేవుణుగుడిః తొహ్న ఇజి వాండ్రు వెహ్తిక మాప్‌వెహప్”, ఇజి వారు వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","గాని వారు వెహ్తి సాస్యమ్‌బా ఒరెన్‌ వెహ్తిక మరి ఒరెన్‌ వెహ్తి దనిఙ్‌ తేడః ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","నస్తివలె విజెరి ముస్కు పెరిపుజెరి నిఙితాండ్రె యేసుఙ్‌ వెన్‌బాతాన్, “నీను ఇనికబా మర్‌జి వెహ్‌ఇదా? వీరు నీ ముస్కు వెహ్సిని యా మాటెఙ్‌ ఇనికెఙ్‌?”. ");
INSERT INTO kfc_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","గాని యేసు ఇనికబా మర్‌జి వెహ్‌ఏండ అలెతాన్. విజేరె పుజెరిఙ ముస్కు పెరిపుజేరి యేసుఙ్‌ మరి వెన్‌బాతాన్, “నీను దేవుణు మరిసిఆతి క్రీస్తునా?”. ");
INSERT INTO kfc_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","యేసు వెహ్తాన్‌, “నానె, లోకుమరిసియాతి నాను గొప్ప అతికారం మన్ని దేవుణు ఉణెర్ పడఃకాదు బసిమంజినిక, సయణిదెర్‌ మరి ఆగసమ్‌దు దాన్‌ మొసొప్‌ ముస్కు నాను వానిక మీరు సూణిదెర్లె”. ");
INSERT INTO kfc_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","విజెరి పెరిపుజెరి ముస్కు పెరి పుజేరి యేసు వెహ్తిక వెంజి వన్ని సొక వాండ్రె కిసె ఆతాండ్రె. వెహ్తాన్‌, “మరి ఇంక సాసిరిఙ్‌ అవ్‌సరం‌ సిల్లెద్‌. వాండ్రు వెహ్తిక మీరు వెహిదెర్. వాండ్రు దేవుణు దూసిసి వర్‌గితిక మీరు వెహిదెర్‌ దన్నివందిఙ్‌ మీరు ఇనిక వెహ్సినిదెర్‌? యేసు దేవుణుదిఙ్‌ దూసిస్తి వందిఙ్ ‌సిక్స కిజి సప్తెఙె ఇజి విజేరె ఒప్పుకొటార్. ");
INSERT INTO kfc_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","నస్తివలె సెగొండార్‌ యేసు ముస్కు పూస్తార్. వారు గరండదాన్‌ వన్ని కణుకేఙ తొహ్సి కణుకేఙ్‌ మూక్తారె వన్నిఙ్‌ గుతార్‌. నిఙి ఎయెర్‌ గుతార్‌ ఇజి తొఏండ వెహ్‌అ”, ఇజి వన్నివెట వెహ్తార్‌. జమానుఙుబా యేసుఙ్‌ కికాణిఙ్‌ డెఃయ్‌తారె ఒత్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","పేతురు విజెరి ముస్కు పెరి పుజెరి అర్‌ఙుదు మహివలె అయ ఇండ్రొణి పణి మన్సి ఉండ్రి అబ్బె వాతాద్. ");
INSERT INTO kfc_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","పేతురు సిసు కాయ్‌జిమహిక సుడ్ఃజి వాండ్రు ఎయెన్‌ ఇజి నెస్తెఙ్‌ అది నెగ్రెండ సుడిఃతాద్. “నీనుబా నజరేతు వాండ్రు ఆతి యేసువెట మహికి”, ఇజి అది వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","అందెఙె పేతురు, “నీను ఇనిక వర్గిజినిదొ నఙి తెలిఏద్‌”, ఇజి వెహ్సి వెల్లి గవునిడగ్రు సొహాన్‌. నస్తివలె కొరు కెరెతాద్. ");
INSERT INTO kfc_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","అయ పణికినికాద్‌ పేత్రుఙ్‌ గవునిడగ్రు సుడ్ఃజి అబ్బె నిహిమహి వరివెట మరి వెహ్తాద్‌, “వీండ్రు వరిలొఇమహ్‌కాన్‌ ఒరేన్”. ");
INSERT INTO kfc_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","గాని పేతురు మరి, “నాను ఆఏ ఇజి వెహ్తాన్‌. సణెం సొహివెనుక పేతురు డగ్రు నిహిమహికార్, “నీను గలీలయదికి, నిజం నీనుబా వరిలొఇ ఒరెన్”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","నస్తివలె పేతురు, “మీరు వెహ్‌సిని వన్నిఙ్‌ నఙి నెస్‌ఏ ఇజి వెహ్సి వన్నిఙ్‌ వాండ్రె సయిప్‌ సీబెఆజి ఒట్టు కితాన్. ");
INSERT INTO kfc_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","వెటనె రిజ ఒర్సు కొరు కెరెతాద్. నస్తివలె పేతురు, యేసు వన్నివెట, “కొరు రిజ కెరెని ముఙల నీను నఙి నెస్‌ఏ ఇజి ముసార్‌ వెహ్నిలె”, ఇజి వెహ్తిమాట ఎత్తు కితాండ్రె నండొ దుకమాజి అడఃబ‍తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","పెందాల సీకటి మన్‌బునె, పెరిపుజెరిఙు, యూదపెదెలుఙు, యూదురి రూలుఙ్‌ నెస్‌పిసినికార్, సన్‌హద్రిం సఙమ్‌దికార్‌ విజేరె కూడ్జి యేసుఙ్‌ ఎలాగ సప్తెఙ్‌ ఇజి ఆలోసనం కితార్. వారు వన్నిఙ్‌ తొహ్సి ఒత్తారె రోమ దేసెమ్‌ది అతికారిఆతి పిలాతుఙ్‌ ఒపజెప్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","“నీను యూదురి రాజునా?”, ఇజి పిలాతు యేసుఙ్‌ వెన్‌బాతాన్. నస్తివలె యేసు, “ఒఒ నీను వెహ్తిలెకెండ్‌నె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","పెరిపుజేరిఙు యేసుముస్కు నండొ తపుఙ్‌ మొప్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","నస్తివలె పిలాతు యేసుఙ్‌ మరి వెన్‌బాతాన్, “నీను మర్‌జి ఇనికబా వెహ్నిదా? వీరు నీ ముస్కు ఎస్సొ తప్పఙ్‌ మొప్సినార్‌ గదె”. ");
INSERT INTO kfc_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","అహె వెహ్తితిఙ్‌బా యేసు ఇని మాటబా మర్‌జి వెహ్‌ఎతాన్. అక్క సుడ్ఃజి పిలాతు బమ్మ ఆతాన్. ");
INSERT INTO kfc_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ఏంటు ఏంటు కిని పస్క పండొయ్దిఙ్‌ లోకుర్‌ కోరిజిని ఒరెన్‌ కయ్‌దువన్నిఙ్‌ విడుదల సీదేఙ్‌ పిలాతుఙ్‌ అలవాటు. ");
INSERT INTO kfc_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","అయవలె బరబ్బఇనికాన్‌ ఒరెన్‌ అన్నయవాండ్రు నన్నికాన్‌ జెలిదు మహాన్‌. వాండ్రు, వన్నివెట మహికార్, ఏలుబడిః కినివరిఙ్‌ ఎద్రిస్తారె సెడొండారిఙ్‌ సప్త మహార్‌. అందెఙె వరిఙ్‌జలిదు ఇట్‌త మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","లోకుర్‌ పిలాతుబాన్‌ వాజి, “నీను కిని ఆలవాటువజ ఒరెన్‌వన్నిఙ్‌ డిఃసి సిఅ”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","పెరిపుజెరిఙు గోస ఆతారె యేసుఙ్‌ నఙి ఒపజెప్తార్‌ ఇజి పిలాతు నెస్తాన్. అందెఙె వాండ్రు “యూదురిరాజుఙ్‌ నాను మిఙి డిఃసి సీదెఙ్‌ కొరిజినిదెరా? ఇజి వెన్‌బాతాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","గాని పెరిపుజెరిఙు బరబ్బేఙ్‌ డిఃసి సీజి యేసుఙ్‌ సప్తెఙ్‌ ఇజి ఆతికారి ఒప్నిలెకెండ్‌ వెహ్తాన్‌ ఇజి లోకురిఙ్‌ రేప్సి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","నస్తివలె పిలాతు, “యూదురిరాజు ఇని మీరు వెహ్‌సినివన్నిఙ్ ‌నాను ఇనిక కిదెఙ్‌?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","వారు, “వన్నిఙ్‌ సిలువ పొక్‌అ”, ఇజి నండొ డేల్‌స్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","అందెఙె పిలాతు, “ఎందనిఙ్‌ వన్నిఙ్‌ సిలువ పొక్తెఙ్‌? వాండ్రు ఇని తపుపణి కిఏన్”, ఇజి వెహ్తాన్‌. గాని వారు, “వన్నిఙ్‌ సిలువ డెఃయ్‌జి సప్‌అ”, ఇజి నండొ డేల్‌స్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","పిలాతు లొకాఙ్‌సర్ద కిబిస్తేఙ్‌ బరబ్బెఙ్‌ విడుఃదల కితాన్, యేసుఙ్‌ కొర్డఙాణిఙ్‌ డెఃయ్‌బిసి. సిలువ పొక్తెఙ్‌ ఒపజెప్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","నస్తివలె సయ్‌నమ్‌దికార్‌ యేసుఙ్‌ ప్రెటోరియం ఇని పిలాతుని పెరిఇండ్రొ ఒతారె అబ్బె మహి సయ్‌నమ్‌ది వరిఙ్‌ విజేరిఙ్‌ కూడుప్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","వారు యేసుఙ్‌ ఎరాని రంగుది నీరి సొక్క పొర్పీసి సాప్కాణిఙ్‌ అటారె ఉండ్రి టోపి తయార్‌ కిజి బురాదు ఇడ్ఃతార్. ");
INSERT INTO kfc_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","“యూదురి రాజు గెల్సిఅ? ఇజి వెహ్సి వారు యేసుఙ్‌ వెక్రిస్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","వారు మరి మరి డుడుదాన్‌ వన్ని బురాదు డెఃయ్తారె వన్నిముస్కు పూస్తార్. వెనుక ముణుకుఙ్‌ ఊర్‌జి వన్నిఙ్‌ మాడిసి వెక్రిస్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","వారు వెక్రిసి విజితి వెనుక వన్నిఙ్‌ తొడిఃగిసి మహి ఎరాని సొక్క లాగ్జి వన్ని నీరి సొక్క తొడిగిస్తారె సిలువ పొక్తెఙ్‌ వన్నిఙ్‌ ఒత్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","కురేనియాదికాన్‌ సీమోను ఇని ఒరెన్‌ ఉండ్రి నాటోహన్‌ అయసరి వాజి మహాన్‌. నస్తివలె యేసువందిఙ్ సిలువ పిండ్‌దెఙ్‌ సయ్‌నమ్‌దికార్‌ సీమోనుఙ్‌ బలవంతం కిత్తార్. సీమోను, అలెక్సందరుని, రూపుఇని వరి అప్పొసి. ");
INSERT INTO kfc_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","వారు గొల్గొతఇని బాడ్డిదు యేసుఙ్‌ తత్తర్. గొల్గొత ఇహిఙ బుర్ర పిణికి బాడ్డిఇజి అర్దం. ");
INSERT INTO kfc_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","అబె యేసుఙ్‌ ఉండెఙ్‌ ద్రాక్సకలుదు బోలం ఇని సేందుమాయం కల్‌ప్సి సిత్తర్. గాని వాండ్రు కెఏతాన్. ");
INSERT INTO kfc_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","సయ్‌నమ్‌దికార్‌ యేసుఙ్‌ సిలువదు డెఃయ్తార్. వెనుక వన్ని సొక్కెఙ్‌ ఎయెఙ్‌ దొహ్‌క్నె ఇజి నెస్తెఙ్‌ సీటిఙ్‌ పొక్తారె వని సొక్కెఙ్‌ సీబె ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","పెందాల తొమ్మిది గంటెఙ్‌ యేసుఙ్‌ సిలువ డెయ్‌తార్. ");
INSERT INTO kfc_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","“యూదురిఙ్‌రాజు”, ఇజి యేసుముస్కు మోప్తి నేరం బోర్డుదు రాసి సిలువాదు ఇడ్తార్‍. ");
INSERT INTO kfc_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","యేసువెట రిఎర్‌ డొఙారిఙ్‌ సిలువాదు పొక్తార్. ఒరెన్‌వన్నిఙ్‌ ఉణెర్‌ పడఃకాదు ఉండ్రి సిలువాదు, మరి ఒరెన్‌ వన్నిఙ్‌ డేబ్ర పడఃకాదు ఉండ్రి సిలువాదు. ");
INSERT INTO kfc_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","నస్తివలె అయ సరిదాన్‌ సొన్సిమహికార్‌ వరి బురదూక్సి యేసుఙ్‌ దూసిస్తార్, “ఒహొ దేవుణుగుడిఃదిఙ్‌ అర్‌ప్సి విసీర్‌జి మూండ్రి రోస్కాఙ్‌ నాను తొహ్నకి నిఙి నీనె రక్సిసి. సిలువదాన్‌ డిగ్‌జి రఅ” ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","32","అయవజనె పెరిపుజెరిఙుని యూదురి రూలునెస్‌పిసినికార్, “వీండ్రు మహివరిఙ్‌ రక్సిస్తాన్. గాని వీండ్రు వినిఙె రక్సిస్తెఙ్‌ అట్‌ఎన్. ఇస్రాయేలురాజు ఆతి క్రీస్తు ఏలు సిలువదాన్‌ డిగ్‌జి వాతిఙ అక్క సూణాపె మాపు నమినాప్”, ఇజి ఒరెన్‌ వెట ఒరెన్‌ వెహ్సి వన్నిఙ్‌ వెక్రిస్తార్. యేసువెట సిలువ డెఃయెఆతి డొఙారుఙుబా వన్నిఙ్‌ వెక్రిస్తార్. ");
INSERT INTO kfc_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","వేడెః పన్నెండు గంటెఙాణిఙ్‌ మూండ్రి గంటేఙ్‌దాక దేసం విజు సీకటి ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","మూండ్రి గంటేఙ్‌ యేసు, “ఎలోయ, ఎలోయ లమ సబక్తాని”, ఇజి డటం డేల్సి వెహ్తాన్‌. దని అర్దం ఇనిక ఇహిఙ, “నా దేవుణు, నా దేవుణు నఙి ఎందనిఙ్‌ నీను డిఃస్తి’ ఇజి. ");
INSERT INTO kfc_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","బానె నిహికార్‌ సెగొండార్‌ యామాట వెహారె, “ఇదిలో వీండ్రు ఎలియేఙ్‌ కూక్సినాన్” ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ఒరెన్‌ ఉహ్‌క్సి సొన్సి దూతి తత్తాండ్రె సెందు ద్రాక్స కలుదు ముడఃక్సి ఉండ్రి డుడ్డుదాన్‌ యేసుఙ్‌ ఉండెఙ్‌ వెయ్దు అందిస్తాన్. “సణెం మండ్రు. ఏలియ వాజి వినిఙ్‌ డిప్నాండ్రొ సిలేనొ సూణాట్”, ఇజి వాండ్రు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","నస్తివలె యేసు డటం డేల్‌స్తాండ్రె పాణం డిఃస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","అయవలె యెరూసలేమ్‌దు మహి దేవుణు గుడిఃదు మహి తెర ముస్కుహన్‌ అడిగిదాక కింజితాదె రుండి ముక్కెఙ్‌ ఆతె. ");
INSERT INTO kfc_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","సిలువ డెఃయ్తిబాన్‌ నిహిమహి సయ్‌నమ్‌ది మంద మణిసిరిఙ్‌, యేసు ఈహు డేల్‌స్తాండ్రె పాణం డిఃస్తిక సుడ్ఃజి, “వీండ్రు నిజం దేవుణు మరిసినె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","సెగొండెక్‌ అయ్‌లికొడొఃక్‌ దూరం నిల్సి సుడ్ఃజిమహె. వన్కాఙ్‌ లొఇ మగ్దలేనె మరియ, ఇజిరి యాకోబు, యోసె ఇనివరి అయ్‌సిఆతి మరియ, సలోమి ఇనికెఙ్‌మహె. ");
INSERT INTO kfc_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","యేసు గలీలయదు మహివలె ఇవిక్‌వన్నివెట సొన్సి వన్నిఙ్‌ అవ్‌సరమాతికెఙ్‌ కిజిమహె. ఇవిక్‌ఆఎండ యెరూసలేమ్‌దు యేసువెట వాతి నండొ అయ్‌లికొడొఃక్‌బా అబ్బె మహె. ");
INSERT INTO kfc_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","అరిమతయి ఇని పట్నమ్‌దికాన్‌ యోసేపుఇని ఒరెన్‌ అబ్బె మహాన్‌. వాండ్రు సన్‌హద్రిం సఙమ్‌దు మన్నివరిలొఇ పెరికాన్‌ ఒరెన్. దేవుణు ఏలుబడిః వందిఙ్‌ వాండ్రు ఎద్రు సుడ్ఃజి మహాన్‌. వీండ్రు సొన్సి, దయ్‌రమ్‌దాన్, యేసు పినుగు సిలువ ముస్కుహాన్‌ జాయ్‌ మనుబునె డిప్తెఙ్‌ పిలాతుబాన్‌ సెలవలొస్తాన్. అయ దినం విస్రాంతిదినం ముఙాల మహి తయార్‌ కినిదినం. అందెఙె అయ తయార్‌ కినిదినం పొదొయ్‌నె యోసేపు పిలాతుబాన్‌ సెలవ లొస్తెఙ్‌ సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","యేసు ఎస్కాండె సాతాన్‌ ఇజి వెంజి పిలాతు బమ్మ ఆతాన్. సయ్‌నమ్‌ది వరిఅతికారిఙ్‌ కూక్సి వెన్‌బాతిఙ్‌ యేసు ఎస్కాండె సాతాన్‌ ఇజి నెస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","యేసు సాతాన్‌ ఇజి సయ్‌నమ్‌ది వరిఅతికారి వెహి మాట పిలాతు వెంజి యోసేపుఙ్‌ యేసుఙ్‌ పినుగు ఒపజెప్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","యోసేపు నెగ్గి తెల్లాని పాత కొడ్ఃజితసి, పినుగు సిలువదాన్‌ డిఃప్సి అయ పాతెఙాణ్‌ పినుగుదిఙ్‌ సుటిసి సటుదిఙ్‌ దొల్‌స్తి దూకిదు ఇడ్తాన్. ఉండ్రి గుండ్రని సెప్ట పణుకు సడిపిసి దూకిదిఙ్‌ అడ్డు కిత్తాండ్రె మూక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","మగ్దలేనె మరియ, యోసె అయ్‌సిఆతి మరియ యేసు పినుగుదిఙ్‌ ఇడ్తిబాడ్డి సుడ్ఃతె. ");
INSERT INTO kfc_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","విస్రాంతిదినం గడిఃస్తిసొహివెనుక, మగ్దలేని మరియ, యాకోబు అయ్‌సి మరియ, సలోమి, ఇనికెఙ్‌ యేసు పినుగుదిఙ్‌ రాస్తెఙ్‌ వాసనం నూనె కొడిఃజి తత్తె. ");
INSERT INTO kfc_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","వారమ్‌దిఙ్‌ మొదొహి దినమ్‌దు పెందాల్నె నిఙ్‌జి పొద్దు సోసి మహివలె అవిక్‌సమాది డగ్రు సొహె. ");
INSERT INTO kfc_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","సమాది డగ్రు సొన్సి మహిఙ్‌ అవిక్‌ “సమాది మూక్తి పణుకు మా వందిఙ్‌ ఎయెర్‌ గూర్‌ప్నార్‌?”, ఇహె. ");
INSERT INTO kfc_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","నస్తివలె అవిక్‌ సుడ్ఃతిఙ్‌ ఎయెరొ అయ పెరిపణుకు సమాదిదాన్‌ గూర్‌ప్తిలెకెండ్‌ తోరితాద్. అది ఒద్దె పెరిక ");
INSERT INTO kfc_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","నస్తివలె అవిక్‌అయ సమాది లొఇ వఙ్‌జి సొహిఙ్‌ నీరి తెల్లాని సొక్క పొర్‌పాజి ఉణెర్‌ పడఃకాద్‌ బస్తి మహి ఒరెన్‌ దఙ్‌డాఃయెనుఙ్‌ సుడ్ఃతె. వన్నిఙ్‌ సుడ్ఃజి అవిక్‌నండొ తియెల్‌ఆతె. ");
INSERT INTO kfc_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","అయ దఙ్‌డాఃయెన్‌ వరివెట, “తియెల్‌ ఆమాట్, సిలువ పొకె ఆతి మన్ని నజరేతు వాండ్రు ఆతి యేసుఙ్‌ మీరు రెబాజినిదెరా? వాండ్రు ఇబ్బె సిల్లెన్. వాండ్రు బత్కిజి నిఙిత మనాన్. వన్నిఙ్‌ ఇడ్తి బాడ్డి సుడ్ఃదు. ");
INSERT INTO kfc_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","వాండ్రు మిఙి ఇంక ముఙాల గలీలయ మీరు సొన్సినాన్ వాండ్రు మిఙి వెహ్తివజ మీరు అబ్బెవన్నిఙ్‌ సూణిదెర్లె ఇజి సిసురిఙ్‌ మరి పేతురుఙ్‌ వెహ్తు”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","అక్క వెహెనె అవిక్‌ వణక్సి బమ్మ ఆజి సమాదిదాన్‌ వెల్లి వాజి బాణిఙ్‌ ఉహ్‌క్సి సొహె. అవిక్‌ ‌తియెల్‌ ఆతెనె ఎయెర్‌వెటబా ఇనికబా వెహ్‌ఉతె. ");
INSERT INTO kfc_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","యేసు ఆదివారం పెందాల్నె సమాదిదాన్‌ బత్కిజినిఙ్‌జి మగ్దలెనె మరియెఙ్‌ తోరె ఆతాన్. యా మరియ ఎయెర్‌ ఇహిఙ యేసు ఏడు దెయమ్‌కాఙ్‌ ఉల్‌ప్తి నెగెండ్‌ కిత్తి అయ్‌లి కొడొః. ");
INSERT INTO kfc_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","యేసువెట మహికార్‌ యేసు సాతిఙ్‌ దుకమ్‌దాన్‌ ఒడ్ఃబిజి అడఃబాజి మహిఙ్, అది సొహదె విజు సఙతిఙ్‌ వరిఙ్‌ వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","యేసు బత్కిజి నిఙితాండ్రె నఙి తోరె ఆతాన్‌ ఇజి అది వెహ్తి మాట వారు నమ్మిఏతార్. ");
INSERT INTO kfc_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","వెనుక రిఏర్‌ సిసుర్‌ ఉండ్రి నాటొ నడిఃసి సొన్సిమహిఙ్‌ యేసు వరిఙ్‌ తొరె ఆతాన్‌. గాని ఆఇ మూర్తి వజ తోరెఆతాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","వారు సొన్సి, మహి సిసూరిఙ్‌ యా సఙతి వెహ్తార్‌. గాని వారు యా రిఏరి మాటేఙబా నమిఏతార్. ");
INSERT INTO kfc_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","మరి ఒర్సుపదకొండు మణిసి సిసూర్‌ బోజనం కిజిమహివలె యేసువరిఙ్‌ తోరె ఆతాన్. యేసు నిఙితి వెనుక వన్నిఙ్‌ సుడ్ఃతివరి మాట నమిఏండాతివందిఙ్, వరి అనుమానమ్‌దిఙ్‌ యేసు వరిఙ్‌గటిఙ వెహ్తాన్‌‌. ");
INSERT INTO kfc_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","యేసు వరివెట, “మీరు లోకం ముస్కు మని విజు దేసమ్‌కాఙ్‌ సొన్సి దేవుణు సువార్త విజేరిఙ్‌ వెహ్తు. ");
INSERT INTO kfc_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ఎయెర్‌బా‌ నా ముస్కు నమకం ఇడ్‌జి బాప్తిసం లాగెఆతిఙ వరిఙ్‌ దేవుణు రక్సిస్నాన్‌. గాని నా ముస్కు నమకం ఇడ్‌ఇతి వరిఙ్‌ సిక్స వానాద్. ");
INSERT INTO kfc_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ఎయెర్‌ నఙి నమ్మినారొ వారు యా బమ్మాతి పణిఙ్‌కిదెఙ్‌ అట్నార్. అక్కెఙ్‌ ఇనికెఙ్‌ ఇహిఙ నా పేరుదాన్‌ వారు దెయమ్‌కాఙ్‌ ఉల్‌ప్నార్. వారు కొత్తబాసెఙ్‌ వర్గినార్. ");
INSERT INTO kfc_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","సారాస్కాఙ్‌ అస్తిఙ్‌బా అవిక్‌ కట్తిఙ్‌బా సాఏర్. ఇనికబా గొప్ప విసమాతిక ఉటిఙ్‌బా సాఏర్. జబ్బు ఆతివరి ముస్కు కికు ఇట్తిఙ వారు నెగెండ్‌ ఆనార్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","యేసు యాకెఙ్‌ విజు వెహ్తివెనుక దేవుణు యేసుఙ్‌ పరలోకమ్‌దు ఒత్తాన్. యేసు అబ్బె దేవుణు ఉణెర్‌ పడఃకాద్‌ బస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","యేసు సిసూర్‌ విజుబాన్‌ సొన్సి దేవుణు సువార్త వెహ్తార్‌. వారు కిత్తి విజు పణిదిఙ్‌ దేవుణు సాయం కితాన్. వారు కిత్తి బమ్మాతి పణిఙాణ్‌ వారువెహ్తి మాట నిజం ఇజి దేవుణు తోరిస్తాన్.");
INSERT INTO kfc_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","లూక తియెపిలెఙ్‌ రాసినాన్. మా నడిఃమి జర్గితి సఙతిఙ వందిఙ్‌ కతవజ రాస్తెఙ్‌ నండొండార్‌ సుడ్ఃతార్. మొదోహనె, యా సఙతిఙ సుడ్ఃతి సాసిర్‌, మరి, సువార్త బోదిస్తికార్‌ మఙి వెహ్తార్‌. వారు మఙి వెహ్తి వజనె, వీరు రాస్తార్. నాను యా సఙతిఙ్‌ విజు మొదోహనె బాగ నెస్త మహ. అందెఙె అయాకెఙ్‌ నీ వందిఙ్‌ వరస రాస్తిఙ బాగ మంజినాద్‌ ఇజి నాను ఒడ్ఃబిత. ఎందానిఙ్‌ ఇహిఙ, అయావలె నిఙి నెస్‌పిస్తి విజు వన్కాఙ్‌ పూర్తి అర్దం నిఙి నెస్తెఙానాద్. ");
INSERT INTO kfc_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","హెరోదురాజు యూదయ దేసెం ఏలుబడిః కిజి మహివలె, జెకరియ ఇని ఒరెన్‌ పుజెరి మహాన్‌. వీండ్రు అబియ పుజెరి జట్టుదు మహికాన్. విన్ని ఆల్సి ఎలిసబెతు. అది అహరోను పుజెరి కుటుమ్‌దికాద్‌నె. ");
INSERT INTO kfc_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","వీరు రిఎర్‌బా, నింద సిల్లెండ ప్రబు సితి ఆడ్రెఙ, రూలుఙ విజు లొఙిజి, దేవుణు ముందాల నీతినిజాయితిదాన్‌ మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ఎలిసబెతు గొడ్డు బోదెలి. అందెఙె వరిఙ్‌ కొడొఃర్‌ సిల్లెర్‌. వారు రిఎర్‌బా నండొ డొక్ర ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ఉండ్రి సట్టు జెకరియ జట్టుఙ్‌ పుజేరి పణికిదెఙ్‌ వంతు వాతాద్. అయావలె జెకరియ దేవుణు ముందాల పుజేరి పణి కిజినాన్. ");
INSERT INTO kfc_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","పుజేరిఙ మన్ని అలవాటు లెకెండ్, సీటి పోక్తారె, జెక్రయెఙ్‌ ఏర్‌పాటు కితార్. దేవుణు గుడిఃదు సొన్సి దూపం సురుదెఙ్‌ వన్నిఙ్‌ ఏర్‌పాటు కితార్. ");
INSERT INTO kfc_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","దూపం సురుదెఙ్‌ వేల ఆతాద్. నస్తివలె అబ్బె కూడిఃతిమహి మందలోకుర్‌ విజేరె వెల్లి మంజి పార్దనం కిజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","నస్తివలె, దేవుణుదిఙ్‌ దూపం సుర్ని మాలి పిటె ఉణెర్‌పడఃకాద్‌ దేవుణు దూత నిహన్. నిహండ్రె వన్నిఙ్‌ తోరె ఆతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","జెకరియ, దేవుణు దూతెఙ్‌ సుడ్ఃతాండ్రె, గజిబిజి ఆజి నండొ తియెల్‌ ఆతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","అయావలె దేవుణు దూత వన్నిఙ్, “జెకరియ, నీను తియెల్‌ ఆమ. నీ పార్దనం దేవుణు వెహాన్‌. నీ ఆలు ఎలిసబెతు ఒరెన్‌ కొడొః ఇడ్నాద్లె. వన్నిఙ్‌ యోహాను ఇజి పేరు ఇడ్‌దెఙ్. ");
INSERT INTO kfc_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","17","వాండ్రు ప్రబు ఎద్రు పెరికాన్‌ ఆనాన్. ద్రాక్స కలుని మరి సోస్నిక ఇనికబా వాండ్రు ఉణ్‌ఎన్. అయిసి పొటలొఇ పిండం ఆతి బాణిఙ్‌ మొదోల్సి దేవుణు ఆత్మ వన్నిఙ్‌ నడిఃపిస్నాన్. ఇస్రాయేలు దేసెమ్‌ది లోకురిఙ్‌ నండొండారిఙ్‌ వరి దేవుణు ఆతి ప్రబు దరోట్‌ మహ్సి తనాన్. ఏలియ ప్రవక్త లెకెండ్‌ నండొ గొప్ప సత్తుదాన్‌ వాండ్రు ప్రబు ముఙాల సొనాన్. ఎందానిఙ్‌ ఇహిఙ, అప్పొసి మరిసిరిఙ్‌ కూడుఃప్తెఙ్. నాయం మన్నికార్‌ బుద్దిదాన్‌ నడిఃనివజ, విరి సరిదు దేవుణుమాట వెన్‌ఇవరిఙ్, నడిఃపిస్తెఙ్ ప్రబు వానివలె, వన్నిఙ్‌ ఎద్రు సుడ్ఃదెఙ్‌ లోకాఙ్‌ తయార్‌ కినివందిఙ్‌ యా లెకెండ్‌ కినాన్‌లె. అందెఙె వాండ్రు పుట్నివెలె మిఙి గొప్ప సర్‌ద కినాన్‌లె. మరి, నండొండారిఙ్‌ సర్‌ద కిబిస్నాన్‌లె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","నస్తివలె జెకరియ దేవుణు దూతెఙ్‌ వెన్‌బాతాన్, “యాక ఎలాగ నాను నెస్తెఙ్‌? నాను డొక్ర. నా బోదెల్‌బా డొఃక్రి ఆతాద్”, ఇజి. ");
INSERT INTO kfc_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","అందెఙె దేవుణు దూత, “నాను గబ్రియెలు. దేవుణు పడఃకాద్‌ నిల్సి మంజినికాన్. నీ వెట వర్గిజి, నిఙి యా నెగ్గి కబ్రు వెహ్తెఙ్‌ దేవుణు నఙి పోక్త మనాన్. ");
INSERT INTO kfc_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","గాని నాను వెహ్తి మాటెఙ్‌ నీను నమిఇతి. అందెఙె యాకెఙ్‌ జర్గినిదాక, నీను గుల్ల ఆజి మంజినిలె. నాను వెహ్తికెఙ్‌ జర్గిదెఙ్‌ దేవుణు ఏర్‌పాటు కితి కాలమ్‌దు, పూర్తి ఆనెలె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","నస్తివలె లోకుర్‌ జెక్రయెఙ్‌ కాప్‌ కిజి మహార్‌. వీండ్రు ఎందనిఙ్‌ దేవుణు గుడిఃదు నిసొ ఆల్‌సెం ఆతాన్‌ ఇజి బమ్మ ఆజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","వాండ్రు వెల్లి వాతివెలె, వరి వెట వర్‌గిదెఙ్‌ అట్‌ఎతాన్. అయావలె దేవుణు గుడిఃదు వినిఙ్‌ దేవుణు ఇనికదో ఉండ్రి దర్‌సనం తోరిస్తాన్‌ ఇజి నెస్తార్. వెయు రఇతిఙ్, వాండ్రు వరిఙ్‌ కియు సయ్‌న కితాన్. వాండ్రు గుల్ల ఆజి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","వన్ని పణి కాలం వీజితిఙ్‌ వాండ్రు వన్ని ఇండ్రొ సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","సెగం రోస్కు సొహి వెన్కా, వన్ని ఆల్సి ఎలిసబెతు పాత డిఃస్తాద్. అయ్‌దు నెలదాక అది ఇండ్రొనె మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“ప్రబునె నా వందిఙ్‌ యాక కితాన్. ఏలు నా ముస్కు కణక పెహ్త బస్తాండ్రె లోకుర్‌ ఎద్రు నఙి మహి సిగుసేట్టు లాగితాన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ఎలిసబెతు పాత డిఃసి ఆరునెలాదు, దేవుణు గబ్రియెలు దూతెఙ్, గలిలయ ప్రాంతమ్‌దు మన్ని నజరేతు ఇని పట్నమ్‌దు పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","యోసేపు ఇన్ని ఒరెన్‌ వన్నిఙ్‌ వెన్‌బాతి ఉండ్రి విడ్డి బోదెలిబాన్‌ దేవుణు దూత సొహాన్. అయ విడ్డి బోదెలి పేరు మరియ. యోసేపు దావీదు కుటుమ్‌దికాన్. ");
INSERT INTO kfc_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","దేవుణు దూత లొఇసొహాండ్రె, మరియామ్మెఙ్‌ సుడ్ఃజి, “వందనం, ప్రబు నీ వెట మనాన్. నిఙి నెగెండ దీవిస్త మనాన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","అయ మాటెఙ్‌ వెహదె, మరియ నండొ బాద ఆతాద్. వన్ని మాటెఙదిఙ్‌ అర్దం ఇనికదో ఇజి దన్ని గర్బమ్‌దు బమ్మ ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","అయావలె దేవుణు దూత దన్నిఙ్, “మరియ నీను తియెల్‌ ఆమ. దేవుణు నీ ముస్కు కనికారం తోరిస్త మనాన్. ");
INSERT INTO kfc_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","నీను పాత డిఃస్తిదె, ఒరెన్‌ కొడొఃదిఙ్‌ ఇడ్నిలె. వన్నిఙ్‌ యేసు ఇజి పేరు ఇడ్ఃఅ. ");
INSERT INTO kfc_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","వాండ్రు పెరికాన్‌ ఆనాన్. విజుదనిఙ్‌ అతికారం మని దేవుణు మరిసి ఇజి కూకె ఆనాన్‌లె. వన్ని అనిగొగొర్‌ ఆతి దావీదు రాజు ఆతివజ, దేవుణుఆతి ప్రబు వన్నిఙ్‌ రాజు కినాన్‌లె. ");
INSERT INTO kfc_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","వాండ్రు, యాకోబుఙ్‌ తెగ్గతివరిఙ్‌ ఎలాకాలం ఏలుబడిః కినాన్‌లె. ఏలుబడిః కిదెఙ్‌ అతికారం వన్నిఙ్‌ ఎలాకాలం మంజినాద్‌లె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","అయావలె అది, “నాను ఎసెఙ్‌బా మొగకొడొః వెట కూడ్ఃఎనె. యాక ఎలాగ జర్గినాద్‌?”, ఇజి దేవుణు దూతెఙ్‌ వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","అందెఙె దేవుణు దూత, “దేవుణు ఆత్మ నీ ముస్కు వానాన్‌లె. మొసొప్‌ కితిఙ నీడ పిడ్ఃక్నాద్. అయలెకెండ్, విజు దన్నిఙ్‌ అతికారం మన్ని దేవుణు సత్తు నిఙి పిడ్ఃక్నాద్లె. అందెఙె పుట్నికాన్‌ దేవుణు బాణిఙ్‌ వానికాన్. వాండ్రు దేవుణు మరిసి ఇజి కూకె ఆనాన్‌లె. ");
INSERT INTO kfc_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","నీ డగ్రుహి లోకుఆతి ఎలిసబెతు డొఃక్రి కాలమ్‌దు ఒరెన్‌ బయిఙ్‌ పాత డిఃస్త మనాద్. గొడ్డు బోదెలి ఇజి కూకె ఆతిదనిఙ్‌ ఏలు ఆరు నెలెఙ్. ");
INSERT INTO kfc_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","విజు కిదెఙ్‌ దేవుణు అట్నికాన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","అయావలె మరియ, “ఇదిలో, నాను దేవుణు పణిమణిసి. నీను వెహ్తి లెకెండ్‌నె నఙి జర్గిపిద్”, ఇజి వెహ్తాద్‌. అకవెహాండ్రె దేవుణు దూత దని బాణిఙ్‌ సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","అయావలెనె, మరియ తయార్‌ ఆతాద్. ఆతాదె, యూదయ దేసెమ్‌ది గొరొణ్‌ ప్రాంతమ్‌దు మని ఉండ్రి పట్నమ్‌దు బేగి సొహద్. ");
INSERT INTO kfc_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","అబ్బె మని జెకరియ ఇండ్రొ సొహదె, ఎలిసబెతుఙ్‌ దసూల్‌ఆతాదె, నమొస్తె వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","42","మరియ వెహ్తి వందనం ఎలిసబెతు వెహివెలె, దన్ని పొటాద్‌ మన్ని పిండం సర్దదాన్‌ కద్లితాద్. ఎలిసబెతు దేవుణు ఆత్మ దాన్‌ నిండ్రిజి సర్‌ద ఆజి ఈహు డటం వెహ్తాద్‌. “అబ! బోదెకా లొఇ, దేవుణు నిఙినె నెగెండ దీవిస్తాన్. నీ పొటాద్‌ మన్ని కొడొఃదిఙ్‌బా దీవిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","నా ప్రబుఙ్‌ అయ్‌సి నా డగ్రు వాదెఙ్‌ నాను ఏపటిదిక ఆఏ. ");
INSERT INTO kfc_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ఇదిలో నీ వందనం నా గిబ్బిదు అర్తిఙ్, నా పొటాద్‌ మన్ని పిండం సర్‌దదాన్‌ కద్లితాద్. ");
INSERT INTO kfc_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ప్రబు దనిఙ్‌ వెహ్తి మాటెఙ్‌ జర్గినాద్‌ ఇజి నమకం ఇట్తికాద్‌ గొప్పది. ");
INSERT INTO kfc_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","అయావలె మరియ ఈహు వెహ్తాద్‌. “నా పాణం ప్రబు గొప్ప పెరికాన్‌ ఇజి వెహ్సినాద్. ");
INSERT INTO kfc_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","49","వాండ్రు వన్ని పణిమణిసిఆతి నా ఇజ్రి బత్కుదిఙ్‌ సుడ్ఃతాన్‍. అందెఙె నా పాణం నఙి రక్సిస్ని దేవుణు బానె సర్‌ద ఆజినాద్. గొప్ప సత్తు మన్ని దేవుణు నా వందిఙ్‌ గొప్ప పణిఙ్‌ కితాన్. అందెఙె ఏలుదాన్‌ లోకుర్‌ విజేరె నా వందిఙ్, దేవుణు దీవిస్తికాద్‌ ఇజి వెహ్నర్‌లె. వాండ్రె నెగ్గి దేవుణు. ");
INSERT INTO kfc_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","వన్నిఙ్‌ తియెల్‌ ఆనివరి ముస్కు వన్ని కనికారం తర తరం మంజినాద్. ");
INSERT INTO kfc_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","వాండ్రు వన్ని సత్తుదాన్‌ గొప్ప పణిఙ్‌ కితాండ్రె తోరిస్తాన్. నానె పెరికాన్‌ ఇజి వరి లోఇ ఒడ్ఃబిజి గర్ర ఆతి వరిఙ్‌ వాండ్రు సెద్రిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","గర్ర మని అతికారిఙ, అతికారం దాన్‌ డిఃప్తాండ్రె ఇజిరి వరిఙ్‌ పెరికార్‌ కితాన్. ");
INSERT INTO kfc_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","బఙాతివరిఙ్‌ నెగ్గి టిండి సీజి సర్‌ద కిబిస్తాన్. మని వరిఙ్‌ వహి కీదానె పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","మా అనిరిఙ్‌ ‘కనికారం తోరిస్న’ ఇజి ఒట్టు కితి వజ వాండ్రు కితాన్. వన్నిఙ్‌ సేవ కిని ఇస్రాయేలు లోకాఙ్‌ కనికారం ఆజి సాయం కితాన్. అబహమ్రుఙ్‌ వన్ని కుటుమ్‌ది వరిఙ్‌ విజేరిఙ్‌ ఎలాకాలం కనికారం తోరిస్న ఇజి ఒట్టు కితాన్. అయాక వాండ్రు ఒడిఃబితాన్”, ఇజి మరియ వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","అది డగ్రు మూండ్రి నెలెఙ్‌ దాక ఎలిసబెతు బాన్‌ మహదె దని ఇండ్రొ మర్‌జి సొహద్. ");
INSERT INTO kfc_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","నెలెఙ్‌ నిండ్రితివలె, ఎలిసబెతుఙ్‌ ఒరెన్‌ కొడొః పుట్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ప్రబు దన్నిముస్కు కణక పెహ్త బేస్తాన్‌ ఇజి పడఃకాదికార్‌ని కూలెఙ్‌ వెహరె, దన్నివెట నండొ సర్‌ద ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","కొడొః పుట్సి ఎనిమిది దినమ్‌దు వన్నిఙ్‌ సునతి కిదెఙ్‌ కూడిఃతార్. కొడొఃదిఙ్‌ అప్పొసి పేరు నన్నిక ఇడ్‌దెఙ్‌ వారు ఒడ్ఃబితార్. ");
INSERT INTO kfc_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","నస్తివలె అయ్‌సి, “అహు పోని! వన్నిఙ్‌ యోహను ఇజి పేరు ఇడ్ఃదెఙ్”, ఇజి వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","అందెఙె వారు, “మీ కూలెఙ లొఇ ఎయెరిఙ్‌బా నిన్ని పేరు సిల్లెద్‌”, ఇజి దనిఙ్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","వినిఙ్‌ ఇన్ని పేరు ఇడ్‌దెఙ్‌ అప్పొసి కోరిజినాన్‌ ఇజి నెస్తెఙ్‌ వారు కియు సయ్‌న కిజి జెక్రయెఙ్‌ వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","నస్తివలె వాండ్రు ఉండ్రి రాసిని బల్ల లొస్తాండ్రె, “విన్ని పేరు యోహాను”, ఇజి రాస్తాన్. వారు విజెరె నండొ బమ్మ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","వెటనె, వన్నిఙ్‌ వర్‌గిదెఙ్‌ వెయు వాతాద్. దేవుణుదిఙ్‌ పొగిడిఃజి వర్గిదెఙ్‌ మొదోల్‌స్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","పడఃకాదికార్‌ విజేరె గొప్ప తియెల్‌ ఆతార్. యూదయ దేసెమ్‌ది గొరొణ్‌ ప్రాంతం విజు లోకుర్‌ విజేరె యా జర్గితి సఙతిఙ వందిఙ్‌ వర్గిజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","యాక వెహికార్‌ విజెరెబా దని వందిఙ్‌ ఒడిఃబిజి, “యా కొడొః ఎలాగ మహ్తికాన్‌ ఆనాన్‌లెనొ”, ఇజి వెహ్తాన్‌. ప్రబు సత్తు వన్నివెట మహాద్‌ ఇజి వారు నెస్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","నస్తివలె వన్ని అప్పొసి జెకరియ, దేవుణు ఆత్మదాన్‌ నిండ్రిజి, దేవుణు వెహ్తెఙ్‌ మని సఙతిఙ వందిఙ్‌ ఈహు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“ఇస్రాయేలు లోకురి దేవుణుదిఙ్‌ పొగిడిఃజినాట్. ఎందనిఙ్‌ ఇహిఙ, వాండ్రు వన్ని లోకురిఙ్‌ డిఃబిస్ని వందిఙ్‌ వాత మనాన్. ");
INSERT INTO kfc_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ఒరెన్‌ సత్తు మని మఙి గొప్పఙ రక్సిస్నివన్నిఙ్‌ మా వందిఙ్‌ సిత మనాన్. అయ వాండ్రు వన్ని పణి మణిసి ఆతి దావీదు కుటుమ్‌దు మనికాండ్రె. ");
INSERT INTO kfc_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","సేన దినమ్‌కాఙ్‌ ముఙాలె, దేవుణు వన్ని బాణిఙ్‌ వాతి ప్రవక్తెఙవెట ఒట్టు కిత మనాన్. ఒట్టు ఇనిక ఇహిఙ, “మా పగాతివరి బాణిఙ్‌ మఙి రక్సిస్నఇజి. “మఙి దూసిస్ని వరిబాణిఙ్‌ రక్సిస్న’, ఇజి. అయా ఒట్టువజనె, మఙి రక్సిస్ని వన్నిఙ్‌ సితాన్. ");
INSERT INTO kfc_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","మరి వాండ్రు వెహ్తాన్‌, “మా అనిరిఙ్‌ ఒట్టు కితి వజ కనికారం తోరిస్న ఇజి. వన్ని వందిఙ్‌ కేట ఆతి ఒపుమానం ఒడ్ఃబిన ఇజి. ");
INSERT INTO kfc_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","మా బుబ్బ ఆతి అబ్రాహము వెట ఒట్టు కితాన్, మా పగ ఆతివరి బాణిఙ్‌ మఙి తప్రిస్న ఇజి, తియెల్‌ సిల్లెండ వన్నిఙ్‌సేవ కిదెఙ్‌ మఙి సాయం కిన ఇజి. ");
INSERT INTO kfc_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","మరి, మాటు దేవుణుదిఙ్‌ కేట ఆతి లోకుర్‌ వజ నీతి నిజాయితిదాన్‌ మా బత్కు విజు వన్ని ఎద్రు మండ్రెఙ్‌ మఙి తయార్‌ కిన ఇజి”, వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","మరి, నా కొడొః నీను విజు దన్నిఙ్‌ అతికారం మన్ని దేవుణు ప్రవక్త ఇజి కూకెఆనిలె. ఎందానిఙ్‌ ఇహిఙ, నీను ముఙాలె సొన్‌సి ప్రబుఙ్‌ లోకుడగ్రు వాదెఙ్‌ సరి నెగెణ్‌ కినిలె. ");
INSERT INTO kfc_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","నీ వన్ని లోకాఙ్‌ వెహ్నిలె, “దేవుణు వరి పాపమ్‌కు సెమిసి వరిఙ్‌ రక్సిస్నాన్‌లె’, ఇజి. ");
INSERT INTO kfc_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","మా దేవుణు నండొ కనికారం మనికాన్. వాండ్రు దేవుణు మంజిని బాడ్డిదాన్‌ పొద్దు సోని లెకెండ్‌ రక్సిస్ని వన్నిఙ్‌ తపిస్నాన్‌లె. ");
INSERT INTO kfc_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ఎందానిఙ్‌ ఇహిఙ, సీకటిదు మని వరిఙ్‌ సావు బత్కుదు మని వరిఙ్‌ జాయ్‌ సీదెఙ్. మఙి సమాదనం దాన్‌ నడిఃపిస్తెఙ్. దిని వందిఙె వాండ్రు రక్సిస్ని వన్నిఙ్‌ తపిస్నాన్‌లె”, ఇజి జెకరియ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","కొడొః పిరితాన్. దేవుణు ఆత్మ సత్తు దాన్‌ పిరితాన్. వాండ్రు ఇస్రాయేలు లోకురిఙ్‌ తోర్ని దాక యెరూసలేమ్‌దిఙ్‌ వెల్లి బీడిఃమ్‍ బూమిదు ఒరేండ్రె బత్కితాన్. ");
INSERT INTO kfc_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","అయ కాలమ్‌దు రోమ గవర్‌మెంటు అడిఃగి మన్నివిజు లోకురిఙ్‌ జమబంది లెకెఙ్‌ రాస్తెఙ్‌ ఇజి కయిసరు అయుగుస్తు ఉండ్రి ఆడ్ర సితాన్. ");
INSERT INTO kfc_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","కురెనియ ఇని ఒరెన్‌ సిరియ రాస్ర్టందిఙ్‌ సుడ్ఃజి మహివలె యా మొదోహి జమబంది లెకెఙ్‌ రాస్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","విజేరె వరి వరి పట్నమ్‌కాఙ్‌ పేర్కు రాసె ఆదెఙ్‌ సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","అయలెకెండ్‌ యోసేపు ఇనికాన్‌ ఒరెన్‌బా సొహాన్‌. వీండ్రు దావీదు కుటుమ్‌దికాన్. దావీదు పట్నం బేత్లెహెము. అందెఙె వాండ్రు గలిలయ ఇని ప్రాంతమ్‌ది నజరేతు ఇని పట్నం దాన్, యూదయ ప్రాంతమ్‌దు మని బేత్లెహేము ఇని పట్నమ్‌దు సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","వన్నిఙ్‌ వెన్‌బాతి మహి మరియ వెట జమబంది రాసె ఆదెఙ్‌ సొహాన్‌. అయావలె దన్నిఙ్‌ నెలెఙ్‌ నిండ్రితె మహె. ");
INSERT INTO kfc_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","వారు అబె మహివలె దనిఙ్‌ నొపిఙ్‌ వాతె. ");
INSERT INTO kfc_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","అది దని తొల్‌సుర్‌ కొడొఃదిఙ్‌ ఏరుఈబాతాద్. వరిఙ్‌ మండ్రెఙ్‌ లార్‌జి ఇలు దొహ్‌కెతాద్‌. దొహ్కిఇతిఙ్‌ పుట్తి కొడొఃదిఙ్‌ కసెలిఙాణిఙ్‌ సుటిస్తారె, కొడ్డిఃఙ సాలాది డోణిద్‌ త్రెప్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","నస్తివలె, అయ ప్రాంతమ్‌దు సెగొండార్‌ గొర్రెఙ్ గవ్‌డుఃఙ్‌ వరి గొర్రెఙ, మడిఃఙ మంద కితారె రెయ్‌తు కాపుకిజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","అయావలె ఒరెన్‌ దేవుణు దూత వరిఙ్‌ తోరె ఆతాన్. ప్రబు జాయ్‌ వరి సుటులం వాతాద్. వారు నండొతియెల్‌ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","అయావలె దూత వరిఙ్, “మీరు తియెల్‌ ఆమాట్. లోకురిఙ్‌ విజేరిఙ్‌ నండొ సర్‌ద కిబిస్ని నెగ్గి కబ్రు నాను వెహ్న. ");
INSERT INTO kfc_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","నేండ్రు దావీదు పట్నమ్‌దు మిఙి రక్సిస్నికాన్‌ ఒరెన్‌ పుట్త మనాన్. వాండ్రు ప్రబు ఆతి క్రీస్తు. ");
INSERT INTO kfc_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","యాకదె నాను మీఙి వెహ్తిదనిఙ్‌ గుర్తు “ఒరెన్‌ బయిదిఙ్‌ కసెలిఙాణిఙ్‌ సుటిస్తారె, సాలాది డోణిద్‌ త్రెప్తి మనిక సూణిదెర్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","14","వెటనె, దేవుణు మంజిని బాడిది నండొ దూతెఙ్‌ అయ దూతవెట కూడిఃతె. కూడిఃతారె, “విజు దన్నిఙ్‌ అతికారం మన్ని దేవుణుదిఙ్‌ పొగిడిఃజినాట్. యా లోకమ్‌దు వాండ్రు ఇస్టం కిని లోకురిఙ్‌ సమాదనం మనీద్‌’ ఇజి దేవుణుదిఙ్‌ పొగిడిఃజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","దూతెఙ్‌ వరిఙ్‌ డిఃస్తారె, దేవుణు మంజిని బాడిఃదు సొహార్‌. సొహి వెనుక గొర్రెఙ్ గవ్‌డుఃఙ్, “మాటు బేత్లెహేముదు సొన్సి, ప్రబు మఙి వెహ్‌పిస్తి యా జర్గితి సఙతిఙ సూణాట్”, ఇజి ఒరెన్‌దిఙ్‌ ఒరెన్‌ వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","వారు బేగి సొహరె, మరియామ్మెఙ్, యోసేపుఙ్, డోణిదు త్రెప్తి మని కొడొఃదిఙ్‌ సుడ్ఃతార్. ");
INSERT INTO kfc_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","వారు వన్నిఙ్‌ సుడ్ఃతారె, యా కొడొః వందిఙ్‌ వరిఙ్‌ వెహ్తి మాటెఙ్‌ విజేరిఙ్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","గొర్రెఙ్ గవుడుఃఙ్‌ వెహ్తికెఙ్‌ వెహికార్‌ విజేరె నండొ బమ్మ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","గాని మరియ జర్గితి సఙతిఙ విజు గర్బమ్‌దు ఇడ్జి దన్నివందిఙ్‌ ఎత్తుకిజి మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","గవుడుఃఙ్‌ వరిఙ్‌ వెహ్తికెఙ్, వారు సుడ్ఃతికెఙ్‌ విజు వన్కా వందిఙ్‌ దేవుణుదిఙ్‌ గవ్‌రం సీజి వన్నిఙ్‌ నండొ పొగ్‌డిఃజి మహ్త సొహార్‌. దేవుణు దూత వరిఙ్‌ వెహ్తి వజనె విజు జర్గితె. ");
INSERT INTO kfc_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","పుట్సి ఎనిమిది రోస్కు ఆతిఙ్, బయిఙ్‌ సునతి కితార్. అయావలె వారు వన్నిఙ్‌ యేసు ఇజి పేరు ఇట్తార్. పాత డిఃస్‌ఎండ ముఙాలె దేవుణు దూత వెహ్తి పేరునె ఇట్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","దేవుణు మోసెఙ్‌ సితి రూలుఙ్‌దు మన్నివజ సుబ్రరమ్‌వందిఙ్‌ పూజెఙ్‌ కిదెఙ్‌ దినం ఆతాద్. అయావలె యోసేపుని మరియ బయిఙ్‌ దేవుణుదిఙ్‌ ఒపజెప్తెఙ్, యెరూసలేమ్‌దు ఒత్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ఎందానిఙ్‌ ఇహిఙ, మోసె రాస్తెఙ్‌ ప్రబు వెహ్తి రూలుదు మనాద్, “విజు తొలిత పుట్తి కొడొఃదిఙ్‌ దేవుణు వందిఙ్‌ కెట ఇడ్ఃదెఙ్. ");
INSERT INTO kfc_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","మరి, మోసె రాస్తెఙ్‌ ప్రబు వెహ్తి రూలుదు మని వజ, “జత గువండెఙ్‌నొ రుండి పార పొటి పిలెకుఙ్‌నొ పూజ సీదెఙ్”, ఇజి. అయావజ ఒత్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","అయావలె, సుమెయోను ఇనికాన్‌ ఒరెన్‌ యెరూసలేమ్‌దు మహాన్‌. వీండ్రు నీతి నిజయ్‌తి మనికాన్. దేవుణుదిఙ్‌ తియెల్‌ ఆతికాన్. ఇస్రాయేలు లోకాఙ్‌ రక్సిస్ని వన్ని వందిఙ్‌ ఎద్రు సుడ్ఃజి మహాన్‌. దేవుణు ఆత్మ వన్ని వెట మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ప్రబు ఏర్‌పాటు కితి పోక్తి క్రీస్తుఙ్‌ తొఏండ, నీను సాఇలె’, ఇజి దేవుణు ఆత్మ వన్నిఙ్‌ వెహ్త మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","దేవుణు వన్నిఙ్‌ నడిఃపిస్తివజ వీండ్రు దేవుణు గుడిఃదు సొహాన్‌. నస్తివలె, దేవుణు మోసెఙ్‌ సిత్తి రూలుదు మని లెకెండ్‌ కిదెఙ్‌ అయ్‌సి అపొసిర్‌ కొడొః ఆతి యేసుఙ్‌ తత్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","అయావలె సుమెయోను కొడొఃదిఙ్‌ కికాణిఙ్‌ పెహ్తండ్రె దేవుణుదిఙ్‌ పొగిడిఃజి ఈహు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“ప్రబువా, నీను వెహ్తి మాటెఙ్‌ వజ నాను వన్నిఙ్‌ సుడ్ఃత. అందెఙె నీ పణి మణిసి ఆతి నఙి ఏలు సమాదనం దాన్‌ కూక్సి ఒఅ. ");
INSERT INTO kfc_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","ఎందానిఙ్‌ ఇహిఙ, లోకుర్‌ విజేరె సుడ్ఃదెఙ్‌ నీను తయార్‌ కితి రక్సిస్నివన్నిఙ్‌నా కణకాణిఙ్‌ నాను సుడ్ఃత మన్న. ");
INSERT INTO kfc_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","వాండ్రు ఇస్రాయేలు ఆఇ వరిఙ్‌ దేవుణు సరిదు నడ్‌పిస్తెఙ్‌ జాయ్‌లెకెండ్‌ ఆనాన్‌లె. నీ ఇస్రాయేలు లోకాఙ్‌ గొప్ప గవ్‌రం వాండ్రు కల్గిస్నాన్‌లె. ");
INSERT INTO kfc_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","అయావలె వాండ్రు కొడొః వందిఙ్‌ వెహ్తి మాటెఙ్‌ వెహారె అయ్‌సి అపొసిర్‌ నండొ బమ్మ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","సుమెయోను వరిఙ్‌ దీవిస్తాండ్రె, వన్ని అయ్‌సి ఆతి మరియెఙ్, “ఇస్రాయేలు లోకుర్‌ నండొండార్‌ నాసనం ఆనివందిఙ్, నండొండార్‌ బత్కిని వందిఙ్‌ దేవుణు వినిఙె ఏర్‌పాటు కితాన్. వీండ్రు దేవుణు ఏర్‌పాటు కితి ఉండ్రి గుర్తు. లోకుర్‌ అయాక నెక్న పొక్నార్. ఆహె, వారు మన్సుదు విని వందిఙ్‌ ఒడ్ఃబితికెఙ్‌ వెల్లి ఆనె. అయాక నీను సూణివెలె కూడం గుత్సి సొహి లెకెండ్‌ నీ మన్సుదు దుకం వానాద్‌లె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","నస్తివలె పనుయెలు గాడ్సి ఆతి అన్న ఇని ఉండ్రి ప్రవక్త మహాద్‌. అది ఆసిరు ఇని జాతిదు మనికాద్. అది పెండ్లి ఆజి ఏడు పంటెఙ్‌ మాసి వెట బత్కితాద్. ఎనబయ్‌నాల్గి పంటెఙ్‌ దాక ముండ మొప్త మహాద్‌. అది నండొ డొక్ర ఆతాద్. దేవుణు గుడిః దాన్‌ ఎసెఙ్‌బా డిఃస్‌ఎండ, రెయు పొగాల్‌ ఉపాస్‌దాన్‌ పార్దనమ్‌దాన్‌ దేవుణుదిఙ్‌ పొగిడిఃజి మాడిఃసి మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ఆ గడిఃయదునె, అది దేవుణు గుడిఃదు యోసేపు, మరియ, యేసుబాన్‌ సొహదె దేవుణుదిఙ్‌ పొగిడిఃతాద్. యెరూసలేమ్‌ది లోకుర్‌ రోమ అతికారిఙ అడిఃగి మహార్‌. వారు వరిఙ్‌ డిఃబిస్ని ఒరెన్‌ వన్నిఙ్‌ ఎద్రు సుడ్ఃజి మహార్‌. ఆహె ఎద్రు సుడ్ఃజి మహి వరివెట కొడొఃవందిఙ్‌ వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","యోసేపుని మరియ మోసె రాస్తెఙ్‌ ప్రబు వెహ్తి రూలుఙ్‌దు కిదెఙ్‌ వెహ్తి మనికెఙ్‌ విజు కితార్. కితి వెనుక, మహ్తరె గలీలయదు మని నజరేతు ఇని వరి పట్నమ్‌దు సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","కొడొః సత్తు దాన్‌ పిరితాన్. వన్నిఙ్‌ నండొ బుద్ది మనాద్. దేవుణు వన్నిఙ్‌ దీవిసినె మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ఏంటు ఏంటు యేసు అయ్‌సి అపొసిర్‌ యెరూసలేమ్‌దు పస్క పండొయ్‌దిఙ్‌ సొన్సి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","వారు ఏంటు సొన్సి మహి అలవాటువజ, యేసుఙ్‌ పన్నెండు పంటెఙ్‌ మహివలె పండొయ్‌దిఙ్‌ సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","పండొయ్‌ వీజితిఙ్, వారు మర్‌జి వాజి మహార్‌. గాని కొడొః ఆతి యేసు యెరూసలేమ్‌దు నిహన్. వన్ని అయ్‌సి అప్పొసిర్‌ అయాక నెస్‌ఎతార్. ");
INSERT INTO kfc_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","వీండ్రు మంద లోఇ మనాన్‌ ఇజి ఒడ్ఃబిజి, ఉండ్రి రోజు వారు నడిఃజి వాతార్. వెనుక వారు వరి కూలెఙబాన్‌ నెల్వ ఆతి వరిబాన్‌ వన్నిఙ్‌ రెబాజినార్. ");
INSERT INTO kfc_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","వాండ్రు తోర్‌ఇతిఙ్, వన్నిఙ్‌ రెబాజి యెరూసలేమ్‌దు మర్‌జి వాతార్. ");
INSERT INTO kfc_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","మూండ్రి దినమ్‌కు వెనుక, వాండ్రు, దేవుణు గుడిఃదు బోద కినివరి నడిఃమి బస్తిక సుడ్ఃతార్. వాండ్రు వరి మాటెఙ్‌ వెంజి, వరిఙ్‌ మరి వెన్‌బాజి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","వన్ని మాటెఙ్‌ వెహికార్‌ విజేరె, వాండ్రు మహ్సి వెహ్తి మాటెఙ వందిఙ్, వన్ని బుద్ది వందిఙ్‌ నండొ బమ్మ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","వన్ని అయ్‌సి అపొసిర్‌ వన్నిఙ్‌ సుడ్ఃతిఙ్‌ నండొ బమ్మ ఆతార్. వన్ని అయ్‌సి ఈహు వెహ్తాద్‌ “నా మరిన్, నీను ఎందనిఙ్‌ మఙి ఈహు కితి? ఇదిలో నీ బుబ్బని నాను నండొ బాద ఆజి నిఙి రెబాజి వాతాప్”, ఇజి వెహ్తాద్. ");
INSERT INTO kfc_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","దనిఙ్‌ వాండ్రు, “మీరు నఙి ఎందనిఙ్‌ రెబాతిదెర్. నాను నా బుబ్బ పణిదు మండ్రెఙ్‌వలె ఇజి మీరు నెస్‌ఇదెరా?”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","గాని వాండ్రు వరిఙ్‌ వెహ్సి మాటెఙ్‌ వారు అర్దం కిఎతార్. ");
INSERT INTO kfc_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","వెనుక వాండ్రు వరివెట సోతాండ్రె నజరేతు వాతాన్. అబ్బె వరిఙ్‌ లొఙిజి మహాన్‌. వన్ని అయ్‌సి యా జర్గిజిని విజు సఙతిఙ్‌ దని మన్సుదు ఇడ్జి మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","యేసు బుద్దిదు, వయుసుదు పిరితాన్. దేవుణు, లోకుర్‌ మరి మరి వన్నిఙ్‌ ప్రేమిసి మహార్‌. వన్ని ముస్కు సర్‌ద ఆజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","పొంతి పిలాతు ఇనికాన్‌యూదయ రాస్ర్టం ఏలుబడిః కిజి మహాన్‌. హేరోదు గలిలయ రాస్ర్టమ్‌దిఙ్‌ అతికారి. హేరోదుఙ్‌ తంబెర్‌సిఆతి పిలుప్పు ఇతూరియని త్రకోనీతి రాస్ర్టమ్‌కాఙ్‌ అతికారి. అబిలేనే రాస్ర్టమ్‌కాఙ్‌ లుసానియ అతికారి. అయావలె తిబెరియ కయిసరు ఇనికానె విరిఙ్‌ విజేరె ముస్కు రాజు. వాండ్రు పదిహేను పంటెఙాణిఙ్‌ విరిఙ్‌ ఏలుబడిః కిజినె వాజినాన్. ");
INSERT INTO kfc_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","అయావలె, అన్నని కయప పుజెరిఙ ముస్కు పెరి పుజెరి. అయావలె బీడిమ్‌ బూమిదు, జెకరియ మరిసి ఆతి యోహాను వెట దేవుణు వర్‌గితాన్. ");
INSERT INTO kfc_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","అందెఙె వాండ్రు, “మీరు పాపమ్‌కు డిఃసి బాప్తిసం లాగె ఆదు. దేవుణు మీ పాపమ్‌కు సెమిస్నాన్”, ఇజి యొర్దాను గడ్డ పడఃకాదు మన్ని ప్రాంతం విజు సొన్సిబోదిసి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","యెసయ ప్రవక్త రాస్తివెలె విన్నివందిఙ్‌ ఈహు వెహ్సినాన్. “బీడిమ్‌ బూమిదు ఒరెన్‌ ఈహు డేల్సి వెహ్సినాన్. “ప్రబుఙ్‌ లోకుడగ్రు వాదెఙ్‌ సరినెగెణ్‌ కిఅ. వన్నిఙ్‌ నడిఃదెఙ్‌ సరితినాఙ్‌ కిదు. ");
INSERT INTO kfc_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","విజు గాతెఙ్‌ నిండ్రిస్‌అ. విజు గొరొక్‌ని మెటెఙ్‌ బయ్‌లు కిఅ. వెకొ సరిఙ్‌ తినానికెఙ్‌ కిఅ. కరుకు సరిఙ్‌ నున్నఙ్‌తికెఙ్‌ కిఅ. ");
INSERT INTO kfc_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","అయావలె విజేరె, దేవుణు వరిఙ్‌రక్సిస్ని దన్నివందిఙ్‌ సూణార్‌లె”, ఇజి. ఆహె రాస్తిమహి లెకెండ్‌ యోహాను బోదిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","యోహను వన్నిడగ్రు బాప్తిసం లాగెఆదెఙ్‌ వాజిని మంద లోకురిఙ్‌ ఈహు వెహ్తాన్‌ “మీరు విసం మన్నిసరాస్‌ లెకెండ్‌ మన్నికిదెర్‌, దేవుణుబాణిఙ్‌ కోపం వాజినాద్‌ ఇజి నమ్మిజి మీరు వాతిదెరా? సిల్లెద్‌. వన్ని కొపమ్‌దాన్‌ తప్రెఆదెఙ్‌ ఇజి మీరువాతిదెరా? నిజమే అయలెకెండ్‌ ఇజి నాను ఒడిఃబిదెఙ్‌ సిల్లెద్‌. ");
INSERT INTO kfc_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","మీ పాపమ్‌కు ఒపుకొడొఃజి డిఃసి సీజి దన్నిఙ్‌ తగితి పణిఙ్‌ కిజి తోరిస్తు. “మాపు అబ్రాహము తెగ్గాతికాప్”, ఇజి మీరు మీ మన్సుదు వర్గిమాట్. ఎందానిఙ్‌ ఇహిఙ, యా పణుకుఙాణిఙ్‌ అబహమ్రుఙ్‌ కొడొఃరిఙ్‌ తయార్‌ కిదెఙ్‌ దేవుణు అట్నాన్”, ఇజి నాను మిఙి వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","దేవుణు మరెక మొదొల్‌కత్సి విసీర్‌దెఙ్‌ కియుదు గొడెలి అస్తి వన్నిఙ్‌ పోలిత మనాన్‌. నెగ్గి పట్కు అస్‌ఇ మరెకాఙ్‌ విజు కత్సి సిసుద్‌ విసీర్‌నాన్లె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","అయావలె లోకుర్‌ విజేరె, “అహిఙ మాపు ఇనిక కిదెఙ్‌?”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","యోహాను వెహ్తాన్‌, “రుండి సొకెఙ్‌ మన్నికాన్‌ ఉండ్రి సిలివన్నిఙ్‌ సీదెఙ్. అయలెకెండ్‌ టిండి మన్నికాన్‌ సిల్లివన్నిఙ్‌ సీదెఙ్”, ఇజి. ");
INSERT INTO kfc_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","పన్ను పెర్‌నికార్‌బా బాప్తిసం లాగె ఆదెఙ్‌ వాతార్. వారు, “ఓ బోదకినికి, మాపు ఇనిక కిదెఙ్‌?”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","దనిఙ్‌ వాండ్రు, “మిఙి ఎసొ లొస్తెఙ్‌ ఆడ్ర సిత మనాదొ, నసొ లొస్తు. నండొ లొస్మాట్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","నస్తివలె సెగొండార్‌ ఉద్దం కినికార్, “మాపు ఇనిక కిదెఙ్‌?”, ఇజి వెన్‌బాతార్. అందెఙె వాండ్రు, “బెద్రిసి ఎయెబాన్‌ డబ్బు డిబిస్మాట్. అనయం వెహ్సి డబ్బు లొస్నాట్. మీ జీతం దానె సర్దు ఆదు”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","వీండ్రు క్రీస్తుసు ఇజి యోహాను వందిఙ్‌ లోకుర్‌ విజెరె వరి మన్సుదు ఒడ్ఃబితార్. వారు ఆస దాన్‌ క్రీస్తుఙ్‌ ఎద్రు సుడ్ఃజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","అయావలె యోహాను వరిఙ్‌ విజెరిఙ్‌ వెహ్తాన్‌, “నాను మిఙి ఏరుదాన్‌ బాప్తిసం సీజిన. నఙి మిస్తి నండొ పెరికాన్‌ మరి ఒరెన్‌ వాజినాన్. వన్ని జోడ్కు బేల్‌టు కుతెఙ్‌ నాను ఏపటితికాన్‌ ఆఎ. వాండ్రు మిఙి దేవుణు ఆత్మదాన్‌ సిసుదాన్‌ బాప్తిసం సీనాన్‌లె. ");
INSERT INTO kfc_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","వాండ్రు గాలి ఇడ్‌ని సేహి కీదు అస్త మనాద్. వాండ్రు వన్నికలమ్‌దిఙ్‌ సుబ్బరం కిజి, గింజెఙ్‌ కొటు కిజి గాలి ఇడ్ఃజినాన్. గింజెఙ్‌ గాదిద్‌ ఇడ్నాన్. పొటుదిఙ్‌ నమ్బ్‌ఇ సిసుదు సుర్‌నాన్. ");
INSERT INTO kfc_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","యా మాటెఙ్‌ అఏండ, మరి నండొ సఙతిఙ్‌ వెహ్సి లోకురిఙ్‌ పణిసి వెహ్తాన్‌. సువార్త బోదిసి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","వాండ్రు హేరోదు ఇని అతికారిఙ్‌ వెహ్తాన్‌, వన్ని కొడెఃసి హేరోదియవెట హేరోదు పాపం కిత్తాన్‌ ఇజి. మరి, హేరోదు కితి విజు తప్పుఙబా వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","అందెఙె వాండ్రు యోహానుఙ్‌ జెలిదు ఇట్తాన్. ఆహె హేరోదు కిత్తి విజు తప్పుఙవెట యోహానుఙ్‌ జెలిదు ఇడిస్తి తపుబా కూడిఃతాద్. ");
INSERT INTO kfc_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","యోహనుఙ్‌ జెలిదు ఇడ్ని ముఙాల, ఉండ్రి రోజు లోకుర్‌ విజెరె బాప్తిసం లాగె ఆతార్. అయావలె యేసు బా బాప్తిసం లాగె ఆతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","వాండ్రు పార్దనం కిజి మహివలె, ఆగాసం రెయ్‌ ఆతాదె దేవుణు ఆత్మ ఉండ్రి పార పొటిఙ్‌ మూర్తి లెకెండ్‌ డిఃగ్‌జి వన్ని ముస్కు వాతాద్. అయావలె, “నీనె నాను ప్రేమిస్ని నా మరిన్. నీ వందిఙ్‌ నాను నండొ సర్‌ద ఆజిన”, ఇజి పరలోమ్‌దాన్‌ ఉండ్రి జాటు వాతాద్. ");
INSERT INTO kfc_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","యేసు వన్ని సేవపణి మొదొల్సివెలె వన్నిఙ్‌ డగ్రుదిఙ్‌ ముప్పయ్‌ పంటెఙ్‌ వయ్‌సు మహాన్‌. వీండ్రు యోసేపు మరీన్‌నె ఇజి ఒడిఃబిజి మహార్‌. యోసేపు హెలి మరిసి ");
INSERT INTO kfc_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","హెలి మత్తతు మరిసి మత్తతు లేవి మరిసి లేవి మెల్కి మరిసి మెల్కి యన్న మరిసి యన్న యోసేపు మరిసి ");
INSERT INTO kfc_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","యోసేపు మత్తతియ మరిసి మత్తతియ ఆమోసు మరిసి ఆమోసు నాహోము మరిసి నాహోము ఎస్లికి మరిసి ఎస్లికి నగ్గయ మరిసి ");
INSERT INTO kfc_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","నగ్గయ మయతు మరిసి మయతు మత్తతియ మరిసి మత్తతియ సిమియ మరిసి సిమియ యేసెక మరిసి యేసెక యోదా మరిసి ");
INSERT INTO kfc_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","యోదా యోహన మరిసి యోహన రేపా మరిసి రేపా జెరుబాబెలు మరిసి జెరుబాబెలు సయిల్తీయెలు మరిసి సయిల్తీయెలు నేరి మరిసి ");
INSERT INTO kfc_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","నేరి మెల్కి మరిసి మెల్కి అది మరిసి అది కోసాము మరిసి కోసాము ఎల్కదాము మరిసి ఎల్కదాము ఏరు మరిసి ");
INSERT INTO kfc_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ఏరు యొహసవ మరిసి యొహసవ ఎలియెజెరు మరిసి ఎలియెజరు యోరియ మరిసి యోరియ మత్తతు మరిసి మత్తతు లేవి మరిసి ");
INSERT INTO kfc_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","లేవి సిమొను మరిసి సిమొను యూద మరిసి యూద యోసేపు మరిసి యోసేపు యోనాము మరిసి యోనాము ఎల్యాకిము మరిసి ");
INSERT INTO kfc_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ఎల్యాకిము మెలెయా మరిసి మెలెయా మేన్నా మరిసి మేన్నా మత్తత మరిసి మత్తత నాతాను మరిసి నాతాను దావీదు మరిసి ");
INSERT INTO kfc_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","దావీదు, యెసయ మరిసి. యెసయ ఓబెదు మరిసి ఓబెదు బోయసు మరిసి బోయసు సల్కను మరిసి సల్కను నయస్సోసు మరిసి ");
INSERT INTO kfc_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","నయస్సోసు అమ్మినాదబు మరిసి అమ్మినదాబు అరాము మరిసి అరాము ఎస్రోము మరిసి ఎస్రోము పెరెసు మరిసి పెరెసు యూదా మరిసి ");
INSERT INTO kfc_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","యూదా యాకోబు మరిసి యాకోబు ఇసాకు మరిసి ఇసాకు అబ్రాహము మరిసి అబ్రాహము తేరహు మరిసి తేరహు నాహోరు మరిసి ");
INSERT INTO kfc_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","నాహోరు సేరుగు మరిసి సేరుగు రయూకు మరిసి రయూకు పెలెగు మరిసి పెలెగు హెబెరు మరిసి హెబెరు సేలహు మరిసి ");
INSERT INTO kfc_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","సేలహు కెయినాను మరిసి కెయినాను అర్పక్సదు మరిసి అర్పక్సదు సేము మరిసి సేము నోవహు మరిసి నోవవు లెమెకు మరిసి ");
INSERT INTO kfc_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","లెమెకు మెతుసెలె మరిసి మెతుసెలె హనోకు మరిసి హనోకు యెరుదు మరిసి యెరుదు మహలెలు మరిసి మహలెలు కేయినాను మరిసి ");
INSERT INTO kfc_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","కేయినాను ఎసోసు మరిసి ఎసోసు సేతు మరిసి సేతు ఆదాము మరిసి ఆదాము దేవుణు మరిసి. ");
INSERT INTO kfc_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","యేసు దేవుణు ఆత్మదాన్‌ పూర్తి నిండ్రితాండ్రె, యోర్దాన్‌ గడ్డదాన్‌ మర్‌జి వాతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","నలపయ్ రోస్కు దేవుణు ఆత్మ వన్నిఙ్‌ బీడిఃమ్‌ బూమిదు నడిఃపిస్తాన్. అబె, సయ్‌తాను వన్నిఙ్‌ పరీస కిదెఙ్‌ సుడ్ఃతాన్. వాండ్రు అయా రోస్కాఙ్‌ ఇనికబా ఉణెఎండ మహాన్‌, కడఃవెరిదు వన్నిఙ్‌ బఙ కట్తాద్. ");
INSERT INTO kfc_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","అయావలె సయ్తాన్, “నీను దేవుణు మరిసి ఇహిఙ, యా పణుకు టిండి ఆని లెకెండ వెహ్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","అందెఙె యేసు, “లోకు బత్కిజినిక టిండిదానె ఆఏద్”, ఇజి దేవుణు మాటదు రాస్త మనాద్”, ఇహాన్. ");
INSERT INTO kfc_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","6","అయావలె సయ్‌తాన్‌ వన్నిఙ్‌ ఎత్తు మని బాన్‌ ఒతండ్రె, లోకమ్‌దు మని విజు దేసెమ్‌కు జామె తోరిస్తాన్. “యా లోకమ్‌ది అతికారం సంసారం, విజు నాను నిఙి సీన. ఎందనిఙ్‌ ఇహిఙ అయాకెఙ్‌ విజు నఙినె దేవుణు ఒపజెప్త మనాన్. నఙి ఇస్టం ఆతి ఎయెరిఙ్‌బా సీదెఙ్‌ నఙి అక్కు మనాద్. ");
INSERT INTO kfc_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","అందెఙె నీను నఙి పొగ్‌డిఃజి మాడిఃస్తిఙ, యాకెఙ్‌ విజు నీవి ఆనె”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","నస్తివలె యేసు, “నీను నీ దేవుణు ఆతి ప్రబుఙ్‌నె పొగిడిఃజి మాడిఃసి, వన్నిఙె సేవకిదెఙ్‌ ఇజి దేవుణు మాటదు రాస్త మనాద్”, ఇజి మర్‌జి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","వెన్కా వన్నిఙ్‌ యెరూసలెమ్‌దు కూక్త ఒత్తాండ్రె, దేవుణుగుడిః కోసాదు నిల్‌ప్తాండ్రె, “నీను దేవుణు మరిసి ఇహిఙ ఇబ్బెణిఙ్‌ అడిఃగి డాట్‌అ. ");
INSERT INTO kfc_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","ఎందానిఙ్‌ ఇహిఙ, “'నిఙి నెగ్రెండ కాపాడఃదెఙ్‌ నీ వందిఙ్‌ వన్ని దూతారిఙ్‌ దేవుణు ఆడ్ర సీనాన్. నీ పాదం పణుకుదు తగ్లిఎండ వారు నిఙి వరి కికాణిఙ్‌ పెర్న అస్నార్‌’, ఇజి దేవుణు మాటదు రాస్త మనాద్‌”, ఇజి వన్నిఙ్‌ వెహ్తాన్ ");
INSERT INTO kfc_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","అందెఙె యేసు, “‘నీ దేవుణుఆతి ప్రబుఙ్, పరిస కిదెఙ్‌ ఆఏద్‌’, ఇజి దేవుణు మాటదు రాస్త మనాద్”, ఇజి మర్‌జి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","సయ్‌తాన్‌ విజు పరీసెఙ్‌ వీస్తాండ్రె సెగం కాలం వన్నిఙ్‌ డిఃస్తసొహ మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","యేసు దేవుణు ఆత్మ సత్తుదాన్‌ గలీలయ ప్రాంతమ్‌దు మర్‌జి సొహాన్‌. అయా ప్రాంతం విజు వన్ని వందిఙ్‌ మాటెఙ్‌ సెద్రితె. ");
INSERT INTO kfc_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","వాండ్రు యూదురి మీటిఙ్‌ ఇల్కాఙ్‌ నేర్‌పిస్తాన్. విజెరె వన్నిఙ్‌ పొగిడిఃతార్. ");
INSERT INTO kfc_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","వెనుక, వాండ్రు పిరీతి వన్ని పట్నమ్‌దు సొహాన్‌. అయాక నజరెతు. వన్ని అలవాటు వజ విస్రాంతి దినమ్‌దు యూదురి మీటిఙ్‌ ఇండ్రొ సొహాండ్రె దేవుణు మాట సద్‌విదెఙ్‌ ఇజి నిహన్. ");
INSERT INTO kfc_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","మీటిఙ్‌ ఇండ్రొణి పణిమణిసి వన్నిఙ్‌ యెసయ ప్రవక్త రాస్తి పుస్తకం సితాన్. వాండ్రు అయాక రెక్తిఙ్‌ ఈహు రాస్తి మనికెఙ్‌ వన్నిఙ్‌ దొహ్‌క్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","“ప్రబు పోక్తి దేవుణు ఆత్మ నావెట మనాన్. అందెఙె వాండ్రు బీద ఆతి వరిఙ్‌ సువార్త వెహ్తెఙ్‌ నఙి ఏర్‌పాటు కితాన్. తొహె ఆతి వరిఙ్, “మిఙి విడుఃదల వాతాద్”, ఇజి వెహ్తెఙ్, గుడ్డి వరిఙ్, ‌“మీ కణుకుఙ్‌ తోర్‌నె”, ఇజి వెహ్తెఙ్, నల్గితి వరిఙ్‌ డిఃస్‌పిస్తెఙ్, దేవుణు వన్ని లోకురిఙ్‌ రక్సిస్నికాలం వాతాద్‌ ఇజి వెహ్తెఙ్‌ వాండ్రు నఙి పోక్త మనాన్”, ఇజి రాస్తి మనికెఙ్‌ వన్నిఙ్‌ దొహ్‌క్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","యాకెఙ్‌ సద్‌విజి, పుస్తకం మూక్తాండ్రె పణిమణిసిఙ్‌ మహ్త సితండ్రె బస్తాన్. మీటిఙ్‌ ఇండ్రొ మహికార్‌ విజెరె వన్నిఙ్‌ డిట బేస్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","వాండ్రు వరిఙ్, “ఏలు నాను సద్‌వితి దేవుణు మాటెఙ్‌ మీరు వెహివెలెనె అయాక పూర్తి ఆతె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","వారు విజెరె వన్ని వందిఙ్‌ నెగ్గికెఙ్‌ వెహ్తార్‌. వన్ని వెయ్‌దాన్‌ వాతి నెగ్గి మాటెఙ బమ్మ ఆజి, “వీండ్రు యోసేపు మరిసి గదె?”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","యేసు వరిఙ్‌ వెహ్తాన్‌, “'ఓ గురు, నిఙి నీనె నెగెణ్‌ కిబ్బె ఆఅ’, ఇని బుద్ది మాట మీరు తప్‌ఎండ నఙి వెహ్నదెర్. మరి, మీరు నఙి, ‘నీను కపర్నహొము ఇని పట్నమ్‌దు కిత్తి పణిఙ్‌ మాపు వెహప్. అయా పణిఙ్‌ ఇబ్బె నీ సొంత పట్నమ్‌దుబా కిఅ’, ఇజి వెహ్నిదెర్. ");
INSERT INTO kfc_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ఎమేణి ప్రవక్తెఙ్‌ బా సొంత పట్నమ్‌దు లోకుర్‌ గవ్‌రం సిఎర్, ఇజి నిజం నాను మీ వెట వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","వెండ్రు, ఏలియ దినమ్‌కాఙ్, ఇస్రాయేలు దేసమ్‌దు మూండ్రి పంటెఙ్‌ ఆరు నెలెఙ్‌ దాక పిరు రఎండ మహాద్‌. గొప్ప కరు వాతివలె, అబె నండొ రాండి బోదెక్‌ మహె ఇనిక నిజమ్‌నె. ");
INSERT INTO kfc_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","గాని, దేవుణు ఏలియెఙ్‌ వరి ఎయెర్‌బాన్‌బా పోక్‌ఎతాన్. సీదొను ప్రాంతమ్‌ది సారెపాతు ఇని నాటొణి రాండి బోదెలిబానె పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","అయాలెకెండ్, ఏలీసా ప్రవక్త కాలమ్‌దు, ఇస్రాయేలు దేసమ్‌దు నండొండార్‌ పెరికస్టం దాన్‌ మహార్‌. గాని వారు ఎయెర్‌బా నెగెణ్‌ ఆఎతార్. సిరియ దేసమ్‌దు మని నయమాన్‌ ఒరెండ్రె నెగెణ్‌ ఆతాన్”, ఇజి నాను మిఙి వెహ్సిన. ఇజి యేసు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","యా మాటెఙ్‌ వెహివలె, యూదురి మీటిఙ్‌ ఇండ్రొ మహికార్‌ విజెరె వెరి కోపం ఆతార్‌ ");
INSERT INTO kfc_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","వారు నిహరె, పట్నమ్‌దాన్‌ వన్నిఙ్‌ పేర్తార్. వారు వన్నిఙ్‌ మెటుదు ఒతార్. వరి పట్నం అయా మెటుద్‌నె తయార్‌ కిత మనాద్. గడియ బుర్ర కిజి వన్నిఙ్‌ అర్‌ప్తెఙ్‌ ఇజి ఒతార్. ");
INSERT INTO kfc_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","గాని మంది నడిఃమిఙానె, వన్నిసరి వాండ్రు సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","వెన్కా వాండ్రు గలిలియతి కపెర్నహుము ఇని పట్నమ్‌దు వాతాన్. విస్రాంతి దినమ్‌దు యూదురి మీటిఙ్‌ ఇండ్రొ బస్తాండ్రె లోకురిఙ్‌ నేర్‌పిసి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","వాండ్రు నెస్‌పిస్తి మాటెఙ్‌ వెహరె, లోకుర్‌ నండొ బమ్మ ఆతార్. ఎందనిఙ్‌ ఇహిఙ, నండొ అతికారం దాన్‌ వాండ్రు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","34","యూదురి మీటిఙ్‌ ఇండ్రొ, ఒరెన్‌ దెయం అస్తికాన్‌ మహాన్‌. వాండ్రు, “నజరెతు వాండ్రు ఆతి యేసువా, మా వెట నిఙి ఇని పణి? మఙి నాసనం కిదెఙ్‌ వాతిదా? నీను ఎయిదొ ఇజి నాను నెస్న. నీను దేవుణు బాణిఙ్‌ వాతి నెగ్గి వాండ్రు”, ఇజి డటం గగొల్‌ ఆజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","అందెఙె యేసు, “అలెజి మన్‌అ. వినిఙ్‌ డిఃసి వెల్లి రఅ”, ఇజి డటం అయా దెయమ్‌దిఙ్‌ వెహ్తాన్‌. నస్తివలె అయా దెయం, అది అస్తి వన్నిఙ్, వరి విజెరె నడిఃమి అర్‌ప్తాదె వన్నిఙ్‌ ఇని నస్టం కిఎండ డిఃస్త సొహద్. ");
INSERT INTO kfc_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","అయావలె లోకుర్‌ విజెరె నండొ బమ్మ ఆతార్. “అబ్బ, యాక ఎసొహి మాట. వీండ్రు దేవుణు సత్తుదాన్, అతికారమ్‌దాన్‌ సొన్‌అ ఇజి దెయమ్‌కాఙ్‌ వెహ్సినాన్. అవి డిఃసి సొన్సినె”, ఇజి ఒరెన్‌దిఙ్‌ ఒరెన్‌ వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","వన్ని వందిఙ్‌ మాటెఙ్‌ అయా ప్రాంతమ్‌దు విజు సెద్రితె. ");
INSERT INTO kfc_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","యేసు యూదురి మీటిఙ్‌ ఇండ్రొణాఙ్‌ నిఙితండ్రె, సిమొను వన్ని ఇండ్రొ సొహాన్‌. అయావలె వన్ని మీమ్‌సి నండొ నోబు దాన్‌ మహాద్‌. దనిఙ్‌ నెగెణ్‌ కిఅ ఇజి వారు బతిమాల్‌తార్. ");
INSERT INTO kfc_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","అందెఙె వాండ్రు దని డగ్రు సొహాండ్రె, “నోబు సొన్‌అ”, ఇజి డటం వెహ్తాన్‌. డటం వెహ్తిఙ్‌ నోబు దనిఙ్‌ డిఃస్త సొహద్. వెటనె అది నిఙితాదె, వరిఙ్‌ మర్యాద కితాద్. ");
INSERT INTO kfc_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","పొదు అర్సి మహాద్‌. అయావలె లోకుర్‌ నండొ రకమ్‌కాణిఙ్‌ బాద ఆజి మహి వరిఙ్‌ విజెరిఙ్‌ వన్ని డగ్రు తతార్. కస్టమ్‌దాన్‌ మహి వరి విజెరె ముస్కు కికు ఇడ్జి వరిఙ్‌ నెగెణ్‌ కిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","యాకదె ఆఏండ, నండొ దెయమ్‌కు, నీనె దేవుణు మరిసి, ఇజి గగొల్‌ ఆజి నండొండారిఙ్‌ డిఃస్త సొహె. వాండ్రు అలెజి మండ్రు ఇజి వన్కాఙ్‌ డటం వెహ్తాన్‌. వాండ్రు క్రీస్తు ఇజి దెయమ్‌కు నెస్త మహె. అందెఙె వాండ్రు వన్కాఙ్‌ వర్గిఏండ కిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","పెందాల్నె వాండ్రు సోతాండ్రె బీడిఃమ్‌ బూమిదు సొహాన్‌. లోకుర్‌ వన్నిఙ్‌ రెబాజి వాతార్. వన్నిఙ్‌ సుడ్ఃతిఙ్‌ వాండ్రు వరిఙ్‌ డిఃసి సొన్‌ఎండ, వన్నిఙ్‌ ఆప్‌ కిదెఙ్‌ సుడ్ఃతార్. ");
INSERT INTO kfc_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","గాని వాండ్రు, “నాను మహి పట్నమ్‌కాఙ్‌ బా దేవుణు ఏలుబడిః కిని కాలం వందిఙ్‌ సువార్త వెహ్తెఙ్‌వలె. దిని వందిఙ్‌ దేవుణు నఙి పోక్తాన్”, ఇజి వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","వెన్కా వాండ్రు యూదయ దేసమ్‌దు మని యూదురి మీటిఙ్‌ ఇల్కాఙ్‌ బోదిసి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ఉండ్రి రోజు, యేసు గనెసరెతు సెరుడగ్రు నిహమహాన్‌. నండొ లోకుర్‌ దేవుణు మాటెఙ్‌ వెండ్రెఙ్‌ నెకెఆజి వన్ని ముస్కు అర్సి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","నస్తివలె జాలెరిఙు సెరు దరీద్‌ డిఃస్తి మహి రుండి డోణిఙ్‌ వాండ్రు సుడ్ఃతాన్‍. అయా జాలెరిఙు వరి వల్లెఙ్‌ నొర్‌జి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","వాండ్రు దని లొఇ ఉండ్రి డోణిద్‌ ఎక్తాన్. ఆక సిమొనుతి. ఎక్తాండ్రె దరిదాన్‌ కండెక్‌ నెక్తు ఇజి వన్నిఙ్‌ వెహ్తాన్‌. వాండ్రు డోణిద్‌ బస్తాండ్రె నండొ లోకాఙ్‌ నెస్పిసి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","వాండ్రు వెహ్సి వీజితివలె, సిమోనుఙ్, “ఏరు నిరీ మని బాన్‌ డోణి నడిఃపిస్‌అ. మొయెఙ్‌ అస్తెఙ్‌ మీ వల్లెఙ్‌ విసీర్తు”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","అందెఙె సిమొను, “ఓ బోదకినికి, రెయు విజు మాపు అరల ఆతాప్. గాని మఙి ఇనికబా దొహ్కుతె. అహిఙ్‌బా నీను వెహ్సిని మాట వజ వల్లెఙ్‌ పొక్నా”, ఇజి వన్నిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","వారు అయాలెకెండ్‌ కిత్తార్. నండొ మొయెఙ్‌ అస్తార్. వరివల్లెఙ్‌ కింజిని వజ ఆతె. ");
INSERT INTO kfc_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","అయావలె వారు వేరె డోణిద్‌ మని, వరి జత్త కూడ్ఃజి పణికిని వరిఙ్, “వాజి మఙి తోడుః కిదు”, ఇజి కియు సయ్‌న కితార్. వారు వాతారె, రుండి డోణిఙ్‌ మొయెఙ్‌ నిహ్తర్. డోణిఙ్‌ ముడుగ్నిలెకెండ్‌ ఆతె. ");
INSERT INTO kfc_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","సీమోను ఇని పేతురు యాక సుడ్ఃతాండ్రె, యేసు కాల్కు ఎద్రు ముణుకుఙ్‌ ఊరితండ్రె, “ప్రబువా, నఙి డిఃసి సొన్‌అ, నాను పాపం కితికాన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ఎందానిఙ్‌ ఇహిఙ, వాండ్రుని వన్నివెట మనికార్‌ విజెరె వారు అస్తి యా మొయెఙ్‌ కొట్టు సుడ్ఃతారె నండొ బమ్మ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","అయలెకెండ్‌నె, సీమోనువెట కూడ్ఃజి పణి కిని యాకోబు ని యోహానుబా బమ్మ ఆతార్. వారు జెబదయి మరిసిర్. అందెఙె యేసు, “తియెల్‌ఆమా. నిసొ కాలం నీను మొయెఙ్‌ అస్ని పణికితి. ఏలు లోకాఙ్‌ నా సిసూర్‌కిదెఙ్‌ నెస్‌పిస్నాలె”, ఇజి సిమోనుఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","వారు వరి డోణిఙ్‌ సెరు ఒడ్డుదు తత్తారె, విజు డిఃస్తార్. వన్నివెట సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","యేసు ఉండ్రి పట్నమ్‌దు మహివలె కస్టురోగం ఇనిపెరి జబ్బు లావుఆతి ఒరెన్‌ అబ్బె మహాన్‌. వాండ్రు యేసుఙ్‌ సుడ్ఃతివెలె ముణుకుఙ్‌ ఊర్‌జి మాడిఃస్తాండ్రె, “ప్రబువా, నాను నెగెండ్‌ ఆదెఙ్ ఇజి నిఙి మన్సు మహిఙ నఙి నెగెణ్‌ కిదెఙ్‌ అట్ని”, ఇజి బతిమాల్‌తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","అందెఙె యేసు వన్నికియు సాప్సి వన్నిఙ్‌ ముట్సి, “నఙి మన్సు మనాద్‌, నీను నెగెణ్‌ ఆఅ”, ఇజి వెహ్తాన్‌. వెటనె వన్నిఙ్‌ మహి అయా కస్టురోగం వన్నిఙ్‌ డిఃస్తాద్. ");
INSERT INTO kfc_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","యేసు వన్నిఙ్, “ఎయె వెటబా ఇనికబా వెహ్మ. గాని నీను తినాఙ్‌ సొన్సి నీ ఒడొఃల్‌ పుజెరిఙ్‌ తోరిస్‌అ. నీను నెగెణ్‌ ఆతి వందిఙ్‌ మోసె ముఙాలె ఆడ్రసితి వజ దేవుణుదిఙ్‌ సంత సిఅ. ఆహె నీను నెగెణ్‌ ఆతి ఇజి లోకురిఙ్‌తోరిస్‌అ”, ఇజి కసితం వెహ్త పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","గాని వన్ని వందిఙ్‌ మాటెఙ్‌ మరి ఒదె, నాహ్కఙ్‌ విజు సెద్రితె. అందెఙె నండొ లోకుర్‌ వన్నిమాటెఙ్‌ వెండ్రెఙ్, వరి కస్టమ్‌కాణిఙ్‌ నెగెణ్‌ ఆదెఙ్‌ ఇజి వన్నిడగ్రు కూడ్ఃజి వాజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","గాని వాండ్రు, నడిఃమి నడిఃమి పార్దనం కిదెఙ్‌ ఇజి ఎయెర్‌ సిల్లి బాడిఃదు సొన్సి మనాన్. ");
INSERT INTO kfc_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ఉండ్రి నాండిఙ్, యేసు ఉండ్రి ఇండ్రొబసి బోదిసి మహాన్‌. గలీలయ, యూద దేసమ్‌దు మన్ని విజు నాహ్కణిఙ్, యెరూసలెమ్‌దాన్‌ వాతి పరిసయ్‌రుని యూదురి రూలు నెస్పిస్నికార్‌ అబ్బె బసి వెంజి మహార్‌. కస్టమ్‌దు మన్నివరిఙ్‌ నెగెణ్‌ కిదెఙ్‌ దేవుణుసిత్తి సత్తు వన్నివెట మనాద్. ");
INSERT INTO kfc_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","నస్తివలె, కిక్కు కాల్కు అర్తి పక్సవాయు ఇని జబ్బుది వన్నిఙ్, సెగొండార్‌ ఉండ్రి సాపాద్‌ పిండిత తత్తార్. లొఇఒసి యేసు ఎద్రు ఇడ్‌దెఙ్‌ నండొ అర్‌ల ఆజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","అబ్బె మందలోకుర్‌ మహిఙ్, వన్నిఙ్‌ యేసు డగ్రు ఒతెఙ్‌ అట్‌ఎతార్. అందెఙె వారు వన్నిఙ్‌ ఇల్లు ముస్కు ఒతార్. ఒతారె, రేకం బొరొ కితారె సాపదాన్‌ మంద నడిఃమి యేసు ఎద్రు డిప్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","యేసు వన్నిముస్కు మన్ని వరి నమకం సుడ్ఃతాండ్రె, “కూలాయెన్, నీ పాపమ్‌కు నాను సెమిస్త మన్న”, ఇజి వన్నిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","అయావలె పరిసయ్‌రు ని యూదురి రూలుఙ్‌ నెస్పిస్నికార్‌ వరి లొఇ ఈహు వర్గితార్. “వీండ్రు ఎయెన్‌? నాను నీ పాపమ్‌కు సెమిస్త మన్న ఇజి వెహ్సి దేవుణు వెట సమానం ఆజి దేవుణుదిఙ్‌ దూసిస్నాన్. దేవుణు ఒరెండ్రె పాపమ్‌కు సెమిస్నికాన్‌ గదె”, ఇజి. ");
INSERT INTO kfc_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","వారు ఒడ్ఃబితిక యేసుఙ్‌ తెలితాద్. వాండ్రు వరిఙ్, “ఎందనిఙ్‌ మీరు అహు మీ మన్సుదు ఒడ్ఃబిజినిదెర్‌? ");
INSERT INTO kfc_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","యా జబ్బుది వన్నిఙ్‌ నీ పాపమ్‌కు నాను సెమిస్త మన్న ఇజి వెహ్నిక సులునా? నీను నిఙ్‌జి నడిఃయ ఇజి వెహ్నిక సులునా? ");
INSERT INTO kfc_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","లోకు మరిసి ఆతి నఙి లోకు పాపమ్‌కు సెమిస్తెఙ్‌ బూమి ముస్కు అతికారం మనాద్‌ ఇజి మీరు నెస్తెఙ్‌వలె ఇజి వెహ్తండ్రె, అయా కికు కాల్కు అర్తి పక్సవాయు వన్నిఙ్, “నాను నిఙి వెహ్సిన, నిఙ్‌జి సాప అసి ఇండ్రొ సొన్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","వెటనె వాండ్రు విజెరె ముఙాలె నిఙితండ్రె, వాండ్రు గూర్తి మని సాప నిక్తాండ్రె దేవుణుదిఙ్‌ పొగ్‌డిఃజి ఇండ్రొ సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","వారు విజెరె నండొ బమ్మ ఆతారె, దేవుణుదిఙ్‌ పొగిడిఃతార్. వారు దేవుణుదిఙ్‌ నండొ తియెల్‌ ఆజి, “అబ్బ! మాటు నేండ్రు నండొ బమ్మఆతి పణిఙ్‌ సుడ్ఃతాట్”, ఇజి వెహ్తర్. ");
INSERT INTO kfc_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","యాక కిత్తి వెన్కా, యేసు సోతాండ్రె, లేవి ఇని ఒరెన్‌ పన్ను పెర్నివన్నిఙ్‌ సుడ్ఃతాన్‍. వాండ్రు పన్ను పెర్ని వరి ఆపిసుదు బస్త మహాన్‌. యేసు వన్నిఙ్, “నీను నా సిసూడు ఆఅ. నా వెట రఅ”, ఇజి వెహ్తన్. ");
INSERT INTO kfc_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","లేవి విజు డిస్తాండ్రె, నిఙ్‌జి వన్ని వెట సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","వెనుక లేవి యేసు వందిఙ్‌ వన్ని ఇండ్రొ ఉండ్రి పెరి విందు కితాన్. పన్ను పెర్నికార్‌ని మరి నండొండార్‌ వరి వెట ఉండెఙ్‌బస్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","అయావలె పరిసయ్‌రు ని వరి జటుద్‌ మని యూదురి రూలుఙ్‌ నెస్పిస్నికార్‌ యేసు సిసూరిఙ్, “ఎందనిఙ్‌ మీరు పన్నుపెర్నివరివెట, మరి సెఇ వరివెట ఉణిజి తింజినిదెర్”, ఇజి మొరొ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","అందెఙె యేసు వరిఙ్, “నెగెండ సిల్లి వరిఙె డాక్టరు కావాలి. నెగెండ మన్నివరిఙ్‌ ఎందనిఙ్‌లు మరి డాక్టరు. ");
INSERT INTO kfc_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","నాను పాపం కిజిని వరిఙ్‌ కూక్సి, వరి పాపమ్‌కు వారు ఒప్పుకొడిఃజి డిస్‌పిసిని వందిఙ్‌ వాత మన్న. మాపు నీతినిజాయితి మనికాప్‌ ఇజి ఒడ్ఃబిని వరిఙ్‌ కూక్తెఙ్‌ రఏ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","అయావలె, పరిసయ్‌రుని వరి జటుద్‌మని యూదురి రూలు నెస్‌పిస్నికార్‌ వన్నిఙ్, “యోహాను సిసూర్‌ డిఃసిడిఃస్‌ఎండ ఉపాస్‌ కిజి పార్దనం కిజినార్. అయలెకెండ్‌నె పరిసయురు సిసూర్‌బా. గాని నీ సిసూర్‌ ఉణిజి తింజి మంజినార్”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","అందెఙె యేసు, “పెండ్లి దఙడః పెండ్లి కూలెఙవెట మన్నివెలె వారు ఉపాస్‌ కిజినారా? ");
INSERT INTO kfc_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","పెండ్లి దఙడెఃఙ్‌ వరి నడిఃమిహన్‌ ఒని రోస్కు వానెలె. అయావలె వారు ఉపాస్‌ అయా రోస్కాఙ్‌ మంజినార్”, ఇజి వెహ్తాన్‌‌. ");
INSERT INTO kfc_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","వాండ్రు వరిఙ్‌ కతవజ ఉండ్రి నెస్‌పిస్తాన్. “ఎయెన్‌బా కొత్త సొక్కదాన్‌ ఉండ్రి ముక్క కిసి పడాఃయి దనిఙ్‌ పొక్‌ఎన్. అయాలెకెండ్‌ కితిఙ, వాండ్రు కొత్త సొక్క కిస్‌పిస్నాన్. కింజితి కొత్త ముక్క పడాఃయి దనిఙ్‌ తగ్‌ఏద్. ");
INSERT INTO kfc_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","మరి, ఎయెన్‌బా కొత్త ద్రాక్సకల్లు పడాఃయి తోలు సన్సిదు వాక్‌ఏన్. అయాలెకెండ్‌ వాండ్రు వాక్తిఙ కొత్త ద్రాక్సకల్లు పొఙువాజి అయా తోలుసన్సి పెడెల్‌నాద్. ద్రాక్సకల్లు విజు వాఙ్‌న సొనాద్. సన్సిపాడానాద్. ");
INSERT INTO kfc_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","అందెఙె కొత్త ద్రాక్సకల్లు కొత్త తోలు సన్సిదు వాక్తెఙ్‌వెలె. ");
INSERT INTO kfc_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ఎయెన్‌బా పడాఃయి ద్రాక్సకల్లు ఉటివెనుక కొత్తక కోరిఎన్. ఎందానిఙ్‌ ఇహిఙ, ‘పడాయిక నెగ్గిక’, ఇజి వెహ్నన్”. ");
INSERT INTO kfc_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ఉండ్రి విస్రాంతి దినమ్‌దు యేసుని వన్ని సిసూర్‌పంట గుడ్డెదాన్‌ సొన్సి మహార్‌. అయావలె వన్ని సిసూర్‌ సెరెక్‌ తెప్తారె, వరికీదాన్‌ నులుసి, తింజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","నస్తివలె సెగొండార్‌ పరిసయ్‌రు, “ఎందనిఙ్‌ మీరు దేవుణు మోసెఙ్‌ సితి రూలుఙ్‌ తప్సినిపణి విస్రాంతి దినమ్‌దు కిజినిదెర్‌?”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","అయావలె యేసు, “దావీదురాజుని వన్నివెట మహికార్, బఙ కట్తివెలె, ఇనిక కితాండ్రొ ఇజి మీరు దేవుణుమాటదు ఎసెఙ్‌బా సద్‌విఇతిదెరా? ");
INSERT INTO kfc_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","వాండ్రు ఇనిక కితాన్‌ ఇహిఙ, దేవుణుగుడిఃదు డుగితాండ్రె దేవుణు ఎద్రు ఇడ్తి రొట్టెఙ్‌ లాగితండ్రె తిహన్. పుజెరిఙ్‌ తప్ప మరి ఎయెర్‌బా అయాకెఙ్‌ తిండ్రెఙ్‌ ఆఏద్. గాని వాండ్రు తిహండ్రె వన్నివెట మన్నివరిఙ్‌బా సిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","అందెఙె లోకుమరిసి ఆతి నఙి విజు వన్కాఙ్‌ ముస్కు అతికారం మనాద్. మరి, విస్రాంతి దినమ్‌దు ఇనిక కిదెఙ్‌ ఇజి లోకాఙ్‌ వెహ్తెఙ్‌బా అతికారం మనాద్”, ఇజి వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ఉండ్రి నాండిఙ్‌ విస్రాంతి దినమ్‌దు, యూదురి మీటిఙ్‌ కిని ఇండ్రొ సొహాండ్రె, నెస్పిసి మహాన్‌. అబ్బె ఉణెర్‌ కియు అర్తికాన్‌ ఒరెన్‌ మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","పరిసయ్‌రు ని యూదురి రూలుఙ్‌ నెస్పిస్నికార్, యేసుఙ్‌ ఇన్ని దనిఙ్‌బా నేరం మొప్తెఙ్ ఇజి సుడ్ఃజి మహార్‌. అందెఙె, యేసు యా జబుది వన్నిఙ్‌ విస్రాంతి దినమ్‌దు నెగెణ్‌ కినాండ్రొ ఇజి బాగ సుడ్ఃజి మహార్. ");
INSERT INTO kfc_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","అహిఙ, యేసు వారు ఒడ్ఃబిజినిక నెస్తాండ్రె, కియు అర్తి వన్నిఙ్, “నీను వాజి విజెరె నడిఃమి నిల్‌అ”, ఇజి వెహ్తాన్‌. అయావలె వాండ్రు నిఙితండ్రె అబ్బెనిహాన్. ");
INSERT INTO kfc_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","అయావలె యేసు వరిఙ్”, నాను మిఙి వెన్‌బాజిన, దేవుణు మోసెఙ్‌ సితి రూలుఙ్‌ వజ, విస్రాంతి దినమ్‌దు నెగ్గి పణిఙ్‌ కిదెఙా, సెఇ పణిఙ్‌పణి కిదెఙా? పాణమ్‌దిఙ్‌ నిల్‌ప్తెఙా, పాణమ్‌దిఙ్‌ అర్‌ప్తెఙా?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","వెన్‌బాతాండ్రె వరిఙ్‌ విజెరిఙ్‌ బస్తాండ్రె, అయా కియు అర్తి వన్నిఙ్, “నీ కియు సప్‌అ”, ఇజి వెహ్తాన్‌. వాండ్రు ఆహె కితాన్. వన్ని కియు నెగెణ్‌ ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","అయావలె వారు వెర్రి కోపమ్‌దాన్‌ నిండ్రితారె, యేసుఙ్‌ ఇనిక కిదెఙ్‌ ఆనాద్‌ ఇజి ఒరెన్‌దిఙ్‌ ఒరెన్‌ వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ఆ దినమ్‌కాఙ్‌ ఉండ్రి నాండిఙ్‌ యేసు పార్దనం కిదెఙ్‌ ఇజి గొరొత్‌ సొహాన్‌. సొహాండ్రె ఆ రెయ్తా విజు దేవుణుదిఙ్‌ పార్దనం కిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","పెందాల్‌ ఆతివెలె వాండ్రు వన్ని సిసూర్‌ఙ కూక్తాండ్రె, వరిలొఇ పన్నెండు మణిరిఙ్‌ ఏర్‌పాటు కిత్తాన్. వరిఙ్‌ అపొస్తుడు ఇజి కూక్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","వీరు ఎయెర్‌ ఇహిఙ, పేతురు ఇజి వాండ్రు పేరు ఇడ్తి సిమొను, వన్ని తంబెర్సి ఆతి ఆంద్రెయ, యాకోబు, యోహాను, పిలిపు, బర్తలొమాయి, మత్తాయి, తోమా, అల్‌పాయి మరిసి ఆతి యాకోబు, యూదయ దేసెం వందిఙ్‌ ఉసార్‌ ఆజిని సిమోను, యాకోబుఙ్‌ మరిసి ఆతి యూద, ఇస్కరియొతు యూద. యా ఇస్కరియొతు యుదనె, వెన్కా యేసుఙ్‌ యూదురు అతికారిఙ కీదు ఒపజెప్తికాన్. ");
INSERT INTO kfc_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","వాండ్రు యా పన్నెండు మణిసిర్‌ సిసూర్‌వెట డిఃగిజి వాతండ్రె, ఉండ్రి బయిలుదు నిహన్. వన్ని సిసూరు నండొండార్, యూదయ దేసమ్‌దు మని విజు నాహ్కణికార్, యెరూసలెమ్‌దాన్, సమ్‌దరం పడఃకాద్‌మని తూరు, సీదొను పట్నమ ప్రాంతమ్‌కాఙ్‌వాతి నండొ లోకుర్‌ అబె మహార్‌. వారు వన్ని మాటఙ్‌ వెండ్రెఙ్, వరిఙ్‌ మన్ని కస్టమ్‌కు సొన్‌పె ఆదెఙ్‌ ఇజి వాతార్. ");
INSERT INTO kfc_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","దెయమ్‌కు అస్తి నండొ బాద ఆజి మహికార్‌ నెగెణ్‌ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","దేవుణు సత్తు వన్నిబాణిఙ్‌ వాజి విజెరె నెగెణ్‌ ఆజి మహార్‌. అందెఙె లోకు విజెరె వన్నిఙ్‌ ముట్తెఙ్‌ ఇజి ఆస ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","అయావలె వాండ్రు వన్ని సిసూర్‌ఙ సుడ్ఃతాండ్రె, ఈహు వెహ్సినాన్. “బీదదికార్‌ ఆతి మీరు గొప్ప వారు. ఎందనిఙ్‌ ఇహిఙ, దేవుణు మిఙి ఏలుబడిః కిజినాన్. ");
INSERT INTO kfc_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ఏలు బఙ సాజిని మీరు గొప్ప వారు. ఎందానిఙ్‌ ఇహిఙ, దేవుణు మిఙి కావాలస్తికెఙ్‌ మీ మన్సు నిండ్రు సీనాన్. యేలు అడఃబాజిని మీరు గొప్ప వారు. ఎందనిఙ్‌ ఇహిఙ, మీరు సిక్నిదెర్లె. ");
INSERT INTO kfc_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","లోకు మరిసి ఆతి నఙి నమ్మితి వందిఙ్‌ లోకుర్‌ మిఙి దూసిసి కేట కినార్. నిందెఙ్‌మొప్సి నీను సెఇక ఇజి వెహ్సి నెక్న పొక్నార్. అయావలె మీరు గొప్ప వారు. ");
INSERT INTO kfc_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","నిన్ని కస్టమ్‌కు వానివలె సర్‌ద ఆజి డాట్‌తు. ఎందనిఙ్‌ ఇహిఙ, దేవుణు మంజిని బాడిఃదు మిఙి మన్ని పలితమ్‌కు గొప్ప నండొ మనె. యా లెకెండ్‌నె, మిఙి బాద కిజిని విరి అనిసిర్, వరి కాలమ్‌దు మహి ప్రవక్తెఙ బాద్ద కిత్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","గాని, ఓ ఆస్తిమనికిదెరా, అబాయా మిఙి ఎసొ గొప్ప బాదెఙ్‌ వానెలె. ఎందానిఙ్‌ ఇహిఙ, మిఙి విజు సుకం దొహ్‌క్త మనాద్. ");
INSERT INTO kfc_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ఏలు పొట పంజు ఉణిజినికిదెరె, అబాయా మిఙి ఎసొ గొప్ప బాదెఙ్‌ వానెలె. మీరు బఙ సానిదెర్‌లె. యేలు సిక్సినికిదెరె. అబాయా మిఙి ఎసొ గొప్ప బాదెఙ్‌ వానెలె. మీరు దుకం కిజి అడఃబానిదెర్‌లె. ");
INSERT INTO kfc_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","లోకు విజెరె మీ వందిఙ్‌ నెగ్గికెఙ్‌ వెహ్ని వెలె, అబాయా మిఙి ఎస్సొ గొప్ప బాదెఙ్‌ వానెలె. ఎందానిఙ్‌ అయలెకెండ్‌నె వరి అనిసిర్‌ అబద్దం వర్గిని ప్రవక్తెఙబా కిత్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","నా మాటెఙ్‌ వెంజిని మిఙి నాను వెహ్సిన, మీ పగాతివరిఙ్‌ ప్రేమిస్తు. మిఙి దూసిస్నివరిఙ్‌ నెగ్గికెఙ్‌ కిదు. ");
INSERT INTO kfc_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","మిఙి సాయెప్‌ సీని వరిఙ్, “దేవుణు మిఙి నెగ్గికెఙ్‌ సిపిన్”, ఇజి దీవిస్తు. మిఙి బాదెఙ్‌ కిని వరి వందిఙ్‌ పార్దనం కిదు. ");
INSERT INTO kfc_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ఎయెన్‌బా మిఙి ఉండ్రి లెపాద్‌ డెఃయితిఙ, మరి ఉండ్రి లెప బా తోరిస్తు. ఎయెన్‌బా మీరు ప్‌డ్ఃగితి మని సాల్వ ఒతిఙ, వన్నిఙ్‌ మీ సొక్కబా సిఅ. ");
INSERT INTO kfc_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","మిఙి లొస్నివరిఙ్‌ విజెరిఙ్‌ సీదు. మీ సొంతతిక పెర్జి ఒసిని వరిఙ్‌ ఆక మరి లొస్మాట్. ");
INSERT INTO kfc_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","లోకుర్‌ మిఙి ఎలాగ కిదెఙ్‌ ఇజి మీరు కోరిజినిదెరొ అయాలెకెండ్‌ మీరు వరిఙ్‌ కిదు. ");
INSERT INTO kfc_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","మిఙి ప్రేమిస్నివరిఙె మీరు ప్రేమిస్తిఙ, దేవుణు మిఙి ఇనాయం సీనాన్‌ ఇజి ఒడిఃబిజినిదెరా?. పాపం కినికార్‌బా వరిఙ్‌ ప్రేమిస్ని వరిఙ్‌ ప్రేమిస్నార్. ");
INSERT INTO kfc_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","మిఙి నెగ్గికెఙ్‌ కినివరిఙె మీరు నెగ్గికెఙ్‌ కితిఙ, దేవుణు మిఙి ఇనాయం సీనాన్‌ ఇజి ఒడిఃబిజినిదెరా? పాపం కినికార్‌బా ఆహె కిజినార్. ");
INSERT INTO kfc_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","అప్పు మర్‌జి సీనార్‌ ఇజి నెస్నివరిఙె మీరు సితిఙ, దేవుణు మిఙి ఇనాయం సీనాన్‌ ఇజి ఒడిఃబిజినిదెరా? పాపం కినికార్‌బా ఆహె కిజినార్. వారు సితికెఙ్‌ విజు మర్‌జి సీనార్‌ ఇజి ఒడిఃబిజి పాపం కిజిని వరిఙ్‌ సీజినార్. ");
INSERT INTO kfc_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","గాని మీరు మీ పగ్‌ ఆతి వరిఙ్‌ ప్రేమిస్తు. వరిఙ్‌ నెగ్గికెఙ్‌ కిదు. మర్‌జి సీనార్‌ ఇజి ఆస సిల్లెండ, అప్పు సీదు. అయావలె మిఙి నండొ ఇనాయమ్‌కు ఆనెలె. మీరు విజు దనిఙ్‌ అతికారం మని దేవుణు మరిసిర్‌ ఆనిదెర్. ఇహిఙ, మీరు వాండ్రు కినిలెకెండ్‌ కినిదెర్. ఎందనిఙ్‌ ఇహిఙ, దేవుణు మేలుదిఙ్‌ నెస్‌ఇవరిఙ్‌బా సెఇ పణిఙ్‌ కిని వరిఙ్‌బా దయ తోరిస్నాన్. ");
INSERT INTO kfc_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","మీ బుబ్బ ఆతి దేవుణు ఎలాగ కనికారం ఆతికాండ్రొ అయావజ మీరుబా మండ్రు. ");
INSERT INTO kfc_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","ఒరెన్‌ వన్ని ముస్కు వెహ్మట్. అయ లెకెండ్‌ దేవుణు మీ ముస్కు వెహ్‌ఎన్. లోకు కిని వన్కాఙ్‌ మీరు తీర్పు కిమాట్. అయాలెకెండ్‌ మీ ముస్కు దేవుణు తీర్పు కిఎన్. లోకుర్‌ మిఙి బాదెఙ్‌ కితిఙ, మీరు మర్‌జి కిఏండ వరిఙ్‌ డిఃస్తు. అయాలెకెండ్‌ దేవుణు మిఙి డిఃస్నాన్‌లె. ");
INSERT INTO kfc_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","మహి వరిఙ్‌ సీదు. దేవుణు మిఙి సీనాన్‌లె. మిఙి నండొ సీనాన్‌లె. తిగ్‌జి, కుదిలిసి, వఙ్‌జి సొని లెకెండ్‌ మీ ఒడిఃద్‌ సీనాన్‌లె. మీరు కొలిజి సితివజనె మిఙి దొహ్‌క్నాద్‌లె. ");
INSERT INTO kfc_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","నస్తివలె వాండ్రు కత వజ యాక నెస్‌పిస్తాన్. అయాక ఇనిక ఇహిఙ, “ఒరెన్‌ గుడ్డి వన్నిఙ్‌ మరి ఒరెన్‌ గుడ్డి వాండ్రు సరి తోరిస్తెఙ్‌ అట్‌నాండ్రా? తోరిస్తిఙ, వారు రిఎర్‌బా గాతదు అర్నార్‌గదె? ");
INSERT INTO kfc_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","సద్వినికాన్‌ నెస్‌పిస్‌ని వన్నిముస్కు పెరికాన్‌ ఆఏన్. గాని సదు పూర్తి నెస్తికాన్‌ ఎయెన్‌బా వన్నిఙ్‌ నెస్‌పిస్తి వన్నివజ మంజినాన్. ");
INSERT INTO kfc_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","మీ కణకాదు మన్ని తూలం నన్నిక సుడ్ఃఏండ మీ తంబెరిఙ కణకాద్‌ మన్ని కాసరాదిఙ్‌ ఎందానిఙ్‌ బేసిని? ");
INSERT INTO kfc_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","నీ కణకాదు మన్ని తూలం నన్నిక లాగ్‌ఎండ, మీ తంబెరిఙ్, ‘ఓ తంబెరి నీ కణకాదు‌ మన్ని కసరాదిఙ్ ‌లాగ్‌న’, ఇజి ఎలాగ వెహ్తెఙ్‌ ఆనాద్. వేసం కినికిదెరె, మీ సొంత కణకాదు మన్ని తూలం ననిక ముఙాలె లాగ్‌దు. అయావలె మీ తంబెరిఙ కణకాద్‌ మన్ని ఇజిరి కసరాదిఙ్‌ నెగెండ్‌ సుడిఃజి లాగ్‌దెఙ్‌ అట్ని. ");
INSERT INTO kfc_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","నెగ్గి మరాత్‌ సెఇ పట్కు అస్‌ఉ. అయాలెకెండ్‌ సెఇ మరాత్‌ నెగ్గి పట్కు అస్‌ఉ. ");
INSERT INTO kfc_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","విజు మరెకాఙ్‌బా పట్కు సుడ్ఃజి నెస్తెఙ్‌ ఆనాద్. ఎయెర్‌బా బొడెః పట్కు సాప్కు తుపెఙాణిఙ్‌కొయిఎర్. అయాలెకెండ్‌ ద్రాక్స పట్కు బా సాప్కు లటదాన్‌ కొయిఎర్. ");
INSERT INTO kfc_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","నెగ్గి మన్సు మన్నివన్నిఙ్‌ కూలిఙ్‌ కొట్టు కిత్తి మన్నిలెకెండ్‌ వన్ని మన్సుదు నెగ్గికెఙె మంజినె. అందెఙె వన్ని వెయుదాన్‌ నెగ్గి మాటెఙ్‌ వానె. సెఇ మన్సు మన్నివన్నిఙ్‌ సెఇకెఙె మంజినె. అందెఙె వన్ని వెయుదాన్‌ సెఇ మాటెఙ్‌ వానె. ");
INSERT INTO kfc_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","నాను వెహ్తి మాటెఙ్‌వజ మీరు కిఏండ మరి మీరు ఎందనిఙ్‌ ప్రబువా, ప్రబువా ఇజి నఙి కూక్సినిదెర్‌? ");
INSERT INTO kfc_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","నా డగ్రువాజి నా మాటెఙ్‌ వెంజి అయావజ కినికాన్‌ ఎయెరిఙ్‌ పోలిత మనాండ్రొ ఇజి నాను నెస్‌పిసిన. ");
INSERT INTO kfc_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","వాండ్రు పునాది నిరీడ్‌ కార్‌సి సట్టుముస్కు పునాది కితాండ్రె ఇల్లు తొహ్ని వన్ని లెకెండ్‌ మనాన్. పెరి గడ్డ వాతాద్. ఇల్లుదిఙ్‌ పెరి గడ్డ డెఃయితిఙ్‌బా అది అర్‌ఎతాద్. ఎందనిఙ్‌ ఇహిఙ, అది నెగ్రెండ తొహె ఆత మనాద్. ");
INSERT INTO kfc_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","గాని నా మాటెఙ్‌ వెంజిబా అయావజ కిఇకాన్, బూమి ముస్కు పునాది పొక్‌ఎండ ఇల్లు తొహ్తి వన్ని లెకెండ్‌ మనాన్. పెరిగడ్డ డెఃయితిఙ్‌ సణమె అయా ఇల్లు అర్తాద్. ఇల్లు పూర్తి పాడాఃతాద్. ");
INSERT INTO kfc_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","వాండ్రు వెహ్తెఙ్‌ మన్నిమాటెఙ్‌ విజు లోకురిఙ్‌ వెన్‌పిసి వీస్తాండ్రె, కపెర్నహుము ఇన్ని పట్నమ్‌దు వాతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","అబ్బె రోమ సయినమ్‌దిఙ్‌ సదాతిపతి ఒరెన్‌ మహాన్‌. అతికారిఙ్‌ నండొ ఇస్టం ఆతి ఒరెన్‌ వెట్టిపణి కినికాన్‌ వన్నిఙ్‌ మహాన్‌. వాండ్రు జబు లావు ఆతాదె సాదెఙ్‌ డగ్రు ఆత మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","అయా అతికారి యేసు వందిఙ్‌ వెహాండ్రె, సెగొండార్‌ యూదుర్‌ పెద్దెల్‌ఙ వన్ని డగ్రు పోక్తార్. ఎందనిఙ్‌ ఇహిఙ, వాండ్రు వాజి వన్ని వెటి పణి కిని వన్నిఙ్‌ నెగెణ్‌ కిదెఙ్‌ ఇజి. ");
INSERT INTO kfc_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","వారు వన్ని డగ్రు వాతారె, “యా అతికారి మా లోకాఙ్‌ నండొ ప్రేమిస్తాండ్రె మఙి మీటిఙ్‌ కిదెఙ్‌ ఇజి ఇల్లు తొహిస్త సితాన్. అందెఙె నీను వాజి వన్ని వెటి పణిమణిసిఙ్‌ నెగెణ్‌ కిదెఙ్‌ వాండ్రు తగ్నికాన్”, ఇజి మరి మరి బతిమాల్‌తార్. ");
INSERT INTO kfc_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","అందెఙె యేసు వరివెట సొహాన్. వాండ్రు ఇల్లు డగ్రు వాతాన్. అయావలె సతాదిప కూలెఙ, “మీరు యేసు బాన్‌ సొన్సి ఈహు వెహ్తు, “ప్రబువా, నీను వందమా. నా ఇండ్రొ నీను వాదెఙ్‌ నాను ఏపటితికాన్‌ ఆఏ. ");
INSERT INTO kfc_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","గాని నెగెణ్‌ ఆఅ ఇన్ని నీ మాటదాన్‌ నా వెట్టిపణి మణిసి నెగెండ్‌ ఆనాన్‌లె, ఇజి నాను నెసిన. ");
INSERT INTO kfc_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ఎందానిఙ్‌ ఇహిఙ, నా ముస్కు అతికారం మనికార్‌ మనార్. నా అడిఃగి ఉద్దం కినికార్‌ మనార్. నాను ఒరెన్‌ వన్నిఙ్‌ సొన్‌అ ఇహిఙ సొనాన్. మరి ఒరెన్‌ వన్నిఙ్‌ రఅ ఇహిఙ, వానాన్. నా పణిమణిసిఙ్‌ యాక కిఅ ఇహిఙ కినాన్”, ఇజి వెహ్తండ్రె పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","యేసు యా మాటెఙ్‌ వెహాండ్రె, వన్ని వందిఙ్‌ బమ్మ ఆతాన్. వాండ్రు వన్ని వెట వాతిమన్ని లోకుదరిఙ్‌ మహ్తండ్రె, “అబ్బ, ఇస్రాయేలు లోకుర్‌ లొఇబా విన్నిఙ్‌ మన్ని నమకం లెకెండ్, నమకం మని ఒరెన్‌ వన్నిఙ్‌బా నాను సుడ్ఃఎత ఇజి మీ వెట నాను వెహ్సిన”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","వన్నిబాన్‌ వాతివరిఙ్‌ యేసు మహ్త పోక్తాన్. వారు ఇండ్రొ సొహరె, నెగెణ్‌ ఆతి వెటిపణి మణిసిఙ్‌ సుడ్ఃతార్. ");
INSERT INTO kfc_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","యాక కితి వెన్కా, యేసు నాయి ఇని పట్నమ్‌దు సొన్సి మహాన్‌. వన్ని సిసూర్‌ని మంద లోకు వన్నివెట కూడ్ఃజి సొన్సి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","వాండ్రు పట్నం వెల్‌గు డగ్రు వాతివెలె సాతికాన్‌ ఒరెన్‌ వన్నిఙ్‌ సోప్‌తారె, సెగొండార్‌ పిండిజి ఒసి మహార్‌. సాతికాన్‌ అయ్‌సిఙ్‌ ఒరెండ్రె మరిసి. అది ముండ బోదెలి. పట్నమ్‌ది మంద లోకుర్‌ దన్నివెట మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ప్రబు ముండ బోదెల్‌దిఙ్‌ సుడ్ఃతివెలె, వన్ని పాణం నొతాద్. అడఃబామా’, ఇజి దన్నిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","వాండ్రు డగ్రు వాతండ్రె, జజుద్‌ ముట్తిఙ్, పిండిజి ఒసి మహికార్‌ నిహర్. యేసు సాతి వన్నిఙ్, “ఓ దఙడః, నాను నిఙి వెహ్సిన, నిఙ్‌అ ఇజి”, ఇజి వెహ్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","అయావలె సాతికాన్‌ నిఙ్‌జి బస్తాండ్రె, వర్గిదెఙ్‌ మొదొల్‌స్తాన్. యేసు, వన్నిఙ్‌ అయ్‌సిఙ్‌ ఒపజెప్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","వారు విజెరె బమ్మ ఆజి తియెల్‌ ఆతార్. “ఒరెన్‌ పెరి ప్రవక్త మా నడిఃమి వాతాన్. వన్ని లోకురిఙ్‌ సాయం కిదెఙ్‌ దేవుణు వాతాన్”, ఇజి వెహ్తరె దేవుణుదిఙ్‌ పొగిడిఃతార్. ");
INSERT INTO kfc_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","యేసు వందిఙ్‌ యా మాటెఙ్‌ యూదయ దేసెం ని డగ్రు మని ప్రాంతమ్‌కాఙ్‌ విజు సెద్రితె. ");
INSERT INTO kfc_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","బాప్తిసం సీని యోహనుఙ్‌ సిసూర్‌ యా జర్గితి పణిఙ వందిఙ్‌ యోహనుఙ్‌ వెహ్తార్‌. నస్తివలె వాండ్రు వరి లొఇహాన్‌‌ రిఎర్‌ సిసూర్‌ఙ కూక్తాండ్రె, “వానికి నీనెనా? సిలిఙ, మాపు మరి ఒరెన్‌ వందిఙ్‌ ఎద్రు సుడ్ఃదెఙా?”, ఇజి ప్రబుఙ్‌ వెన్‌బాదెఙ్‌ యేసుడగ్రు పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","వారు యేసుడగ్రు వాతారె, “నీనెనా వాజినికి? సిలిఙ మాపు మరి ఒరెన్‌ వన్నిఙ్‌ ఎద్రు సుడ్ఃదెఙా? ఇజి వెన్‌బాదెఙ్‌ బాప్తిసం సీని యోహాను మఙి నీ డగ్రు పోక్తాన్”, ఇహార్. ");
INSERT INTO kfc_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","అయావలెనె, యేసు జబ్బుదివరిఙ్‌ బాదదాన్‌ మన్ని వరిఙ్, దెయమ్‌కు అస్తి వరిఙ్‌ నండొండారిఙ్‌ నెగెణ్‌ కితాన్. నండొ గుడ్డిది వరిఙ్‌ సూణిలెకెండ్‌ కిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","అందెఙె వాండ్రు వన్నిడగ్రు వాతివరిఙ్, “గుడ్డిదికార్‌ సుడెః ఆజినార్. సొటదికార్‌ నడిఃజినార్. కస్టమ్‌దికార్‌ ఇని పెరిజబ్బు మన్నికార్‌ నెగెణ్‌ ఆజినార్‌. బొయిరదికార్‌ వెంజినార్. సాతికార్‌ నికెఆజినార్. బీదాతివరిఙ్‌ సువార్త వెహెఅజినాద్. ఇజి యాలెకెండ్‌ మీరు సుడ్ఃతికెఙ్, వెంజినికెఙ్‌ మర్జి సొన్సి యోహానుఙ్‌ వెహ్తు. ");
INSERT INTO kfc_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","నా ముస్కు నమకం డిఃస్‌ఎండ మంజినికాన్‌ దేవుణు సీని దీవనమ్‌కు మంజినికాన్‌ఆనాలె”, ఇజి వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","యోహను సిసూర్‌ సొహి వెనుక, యేసు యోహాను వందిఙ్‌ మంద లోకు వెట ఈహు వెహ్తెఙ్‌ మొదొల్‌స్తాన్. “ఇనిక సుడ్ఃదెఙ్‌ మీరు బీడిమ్‌బూమి ప్రాంతమ్‌దు సొహిదెర్‌? గాలిదిఙ్‌ కద్లిజిని గడ్డిదిఙ్‌ సుడ్ఃదెఙా? ");
INSERT INTO kfc_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","సిల్లిఙ, మరి ఇనిక సుడ్ఃదెఙ్‌ సొహిదెర్‌? మెతాని సొక్కెఙ్‌ తొడిఃగితి మని ఒరెన్‌ వన్నిఙ్‌ సుడ్ఃదెఙా? సిల్లె, నండొ దర మన్ని సొక్కెఙ్‌ తొడిఃగిజి, సుకం బత్కినికార్‌ రాజురి ఇల్కాఙ్‌ మంజినార్. ");
INSERT INTO kfc_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","అహిఙ, మీరు ఇనిక సుడ్ఃదెఙ్‌ సొహిదెర్‌? ఒరెన్‌ ప్రవక్తెఙ్‌నా? ఒఒ, ఒరెన్‌ ప్రవక్త ముస్కు పెరివన్నిఙ్‌ సుడ్ఃదెఙ్‌ సొహిదెర్‌ ఇజి నాను మిఙి వెహ్సిన ");
INSERT INTO kfc_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","విన్నివందిఙ్‌ దేవుణు మాటదు ఈహు రాస్త మనాద్, “ఇదిలో, నాను నా కబ్రుతనివన్నిఙ్‌ నీ ముఙాల పోక్సిన వాండ్రు నీ ముఙాల నీ సరి నెగెణ్‌ కినాన్”. ");
INSERT INTO kfc_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","బోదెకాఙ్‌ పుట్తి వరిలొఇ యోహాను ఇంక పెరికాన్‌మరి ఎయెన్‌బా సిలెన్. గాని దేవుణు ఏలుబడిః కిని లోకుర్‌ లొఇ తగిసి కొటికాన్‌ యోహాను ముస్కు పెరికాన్‌ ఇజి నాను మిఙి వెహ్సిన”. ");
INSERT INTO kfc_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","యేసు వెహ్తికెఙ్‌ వెహరె లోకుర్‌ విజెరె పన్ను పెర్నికార్‌బా దేవుణు కిజినిక విజు నాయమ్‌దానె కిజినాన్‌ ఇజి లోకుర్‌ ఎద్రు ఒప్పుకొటార్. ఎందనిఙ్‌ ఇహిఙ, వారు యోహాను బాణిఙ్‌ బాప్తిసం లాగె ఆత మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","గాని పరిసయ్‌రుని యూదురి రూలు నెస్పిస్నికార్‌ యోహాను సీని బాప్తిసం లాగె ఆఏతార్. వారు వరి వందిఙ్‌ దేవుణు ఎతు కితి సఙతి నెక్త పొక్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","యా తరమ్‌ది లోకాఙ్‌ నాను ఇన్ని దని దనటాన్‌ పోల్‌సి వెహ్తెఙ్‌? వారు ఇని దనిఙ్‌ పోలిత మనార్‌? ");
INSERT INTO kfc_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","వారు, సతాదు బసి మంజి పెండ్లి ఇండ్రొ ని సాతి ఇండ్రొ జర్గిజిని దని వందిఙ్‌ఎత్తు కిజి కర్‌జిజిని కొడొఃరిఙ్‌పోలిత మనాద్. అయా కొడొఃర్‌ ఒరెన్‌దిఙ్‌ ఒరెన్‌ కూకె ఆజి ఈహు కర్‌జిజినార్. “మాపు పిరుడిః ఊహ్‌క్తాప్‌ గాని మీరు కర్‌జిఇతిదెర్. మాపు సాతి ఇండ్రొణి పాటెఙ్‌పార్తాప్‌ గాని మీరు అడఃబాఇతిదెర్”. ");
INSERT INTO kfc_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ఎందానిఙ్‌ ఇహిఙ, బాప్తిసం సీని యోహాను మాముల్‌ బోజనం ఉణిజి, ద్రాక్స కడు ఉణెఎండ వాతాన్. అందెఙె మీరు, “వినిఙ్‌ దెయం అస్తాద్”, ఇజి వెహ్సినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","లోకు మరిసిఆతి నాను ఉణిజి తింజి వాజినాన్. అందెఙె మీరు ఇదిలో వీండ్రు టిండి కకుర్‌తికాన్, సోస్నికాన్, పన్ను పెర్నివరిఙ్‌ పాపం కినివరిఙ్‌ కూలాయెన్‌ ఇజి వెహ్సినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","గాని దేవుణుబాణిఙ్‌ వాతి గెణం మనికార్‌ అయా గెణం నిజమాతిక ఇజి వరి విజు నెగ్గి పణిఙాణిఙ్‌ రుజుప్‌ కిజినార్. ");
INSERT INTO kfc_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","పరిసయ్‌రు లొఇ ఒరెన్‌ వన్నివెట బోజనం కిదెఙ్‌ యేసుఙ్‌ కూక్తాన్. అందెఙె యేసు పరిసయ్‌రు ఇండ్రొ సొహాండ్రె, వన్ని వెట బోజెనమ్‌దిఙ్‌ బస్త మహాన్. ");
INSERT INTO kfc_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ఆ నాటొ పాపం కిజి మహి ఉండ్రి బోదెలి మహాద్. యేసు పరిసయ్‌రు ఇండ్రొ బోజెనమ్‌దిఙ్‌ బస్త మహాన్‌ ఇజి నెస్తాదె, నూనాఙ్‌ పణుకుదాన్‌ తయార్‌ కితి ఉండ్రి సీసాదు నెగ్గి వాసనం సీని నూనె తత్తాద్. ");
INSERT INTO kfc_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","యేసు, కాల్కు వెన్కా మహ్తండ్రె బస్త మహాన్‌కాక అది వెనక వన్ని పాదమ్‌క డగ్రు నిహాద్. నిహదె అడఃబాజి మహాద్‌. అది దన్ని కణెర్‌దాన్‌ వన్ని పాదమ్‌కాఙ్‌ ఊత్‌తాదె దని కొపుదాన్‌ తెల్‌తాద్. వన్ని పాదమ్‌కాఙ్‌ ముదు కితాదె వాసనం సీని జటమామ్‌సి నూనె రాస్తాద్. ");
INSERT INTO kfc_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","వన్నిఙ్‌ కూక్తి పరీసయి వాండ్రు యాక సుడ్ఃతాండ్రె, వీండ్రు నిజం ఇక ఒరెన్‌ ప్రవక్త ఇహిఙ, వినిఙ్‌ ముట్తి బోదెలి ఎయిదొ ఎలాగ మర్తికాదొ ఇజి నెస్తాన్‌ మరి. ఎందనిఙ్‌ ఇహిఙ, ఇది పాపం కినికాద్, ఇజి మన్సుదు ఒడిఃబితాన్. ");
INSERT INTO kfc_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","అందెఙె యేసు, “ఓ సిమోను నీవెట ఉండ్రి మాట వెహ్తెఙ్‌ మనాద్”, ఇజి వన్ని వెట వెహ్తిఙ్, “బోదకినికి వెహ్‌అ”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","అయావలె యేసు”, ఒరెన్‌ అప్పు సితి వన్నిఙ్‌ రిఎర్‌ అప్పు లొస్తికార్‌ మహార్. వరి లొఇ ఒరెన్‌ అయ్‌దు వందెఙ్‌ వెండి రుపాయిఙు మరి ఒరెన్‌ యాబయి వెండి రుపాయిఙు సీదెఙ్‌ మనాద్. ");
INSERT INTO kfc_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","అప్పు తిర్‌స్తెఙ్‌ వరిఙ్‌ డబ్బు సిల్లెద్‌. అందెఙె వరిఙ్‌ రిఎరిఙ్‌బా డబ్బు లొస్‌ఎండ డిఃస్తాన్. ఏలు, విరి లొఇ ఎయెన్‌ వన్నిఙ్‌ నండొ ప్రేమిస్నాన్‌? ఇజి వెన్‌బాతాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","అందెఙె సిమోను, “వాండ్రు ఎయెరిఙ్‌ నండొ సితండ్రె, లొస్‌ఎండ డిఃస్త సితాండ్రొ వాండ్రె నండొ ప్రేమిస్నాన్, ఇజి నాను ఒడ్ఃబిజిన”, ఇహాన్. అందెఙె యేసు, “నీను నెగెండ ఎత్తు కితిదె వెహ్తి”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ఇహండ్రె, ఆ బోదెల్‌ దరొట్‌ సుడ్ఃజి సిమోనుఙ్‌ ఈహు వెహ్తన్. “యా బోదెల్‌దిఙ్‌ నీను సుడ్ఃజిని గదె. నాను నీ ఇండ్రొ వాత. నీను నా పాదమ్‌కు ఊర్‌పాదెఙ్‌ ఏరు సిఇతి. గాని ఇది దని కణెర్‌దాన్‌ నా పాదమ్‌కు ఊత్‌తాదె, దని కొపుదాన్‌ తేలితాద్. ");
INSERT INTO kfc_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","నీను నఙి ముదు కిజి డగ్రు కిఇతి. గాని ఇది నాను వాతి బాణిఙ్‌ అసి నా పాదమ్‌కు ముదు కిజినె మనాద్. ");
INSERT INTO kfc_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","నీను నా బురాదు నూనె రాస్‌ఇతి. గాని ఇది నా పాదమ్‌కాఙ్‌వాసనం సీని నూనె రాస్తాద్. ");
INSERT INTO kfc_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","అది నండొ ప్రేమిస్తాద్. అందెఙె దని నండొ పాపమ్‌కు దేవుణు సెమిస్తాన్, ఇజి నాను నీ వెట వెహ్సిన. ఎయెరిఙ్‌ దేవుణు తక్కు సెమిస్త మనాండ్రొ, వాండ్రు తక్కునె ప్రేమిస్నాన్”. ");
INSERT INTO kfc_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","మరి యేసుదనిఙ్, “దేవుణు నీ పాపమ్‌కు సెమిస్త మనాన్”, ఇజి వెహ్తన్. ");
INSERT INTO kfc_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","వన్ని వెట ఉండెఙ్‌ బస్తి మహికార్, “పాపమ్‌కు సెమిస్త మన్న ఇజి వెహ్తెఙ్‌ వీండ్రు ఎయెన్‌?”, ఇజి ఒరెన్‌దిఙ్‌ ఒరెన్‌ వర్గిజి మహార్. ");
INSERT INTO kfc_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","అందెఙె యేసు, “నీను నా ముస్కు నమకం ఇడ్తి. అందెఙె నీ పాపమ్‌కాణిఙ్‌ దేవుణు రక్సిస్తాన్‌ ఇజి ఆ బోదెల్‌దిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","సెగం రోస్కు సొహి వెనుక, యేసు, దేవుణు కిని ఏలుబడిః వందిఙ్‌ సువార్త పట్నమ్‌కాఙ్‌ నాహ్కఙ్‌ బోదిసి వెహ్సి వాజి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","పన్నెండు మణిసి సిసూరు వన్ని వెట మహార్‌. దెయం ‌బాణిఙ్, కస్టమ్‌కాణిఙ్‌ నెగెణ్‌ ఆతి సెగొండెక్‌ బోదెక్‌బా వన్ని వెట మహె. వన్కా లొఇ ఏడు దెయమ్‌కాణిఙ్‌‌ యేసు డిఃస్‌పిస్తి మగ్‌దలెనె ఇని మరియ, హెరొద్‌ ఇండ్రొ ఎజమాని పణి కిజి మహి కూజ ఇని వన్ని ఆల్సి యొహన, సుసనయ, మరి నండొ బోదెక్‌బా మహె. వన్కాఙ్‌ కల్గితి మన్ని లొఇ అవికు, యేసువన్ని సిసూర్‌ వందిఙ్‌ కర్సు కిజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","విజు పట్నమ్‌కాణిఙ్‌ లోకుర్‌ యేసుడగ్రు వాజి మంద ఆతివెలె, వాండ్రు ఉండ్రి కత వజ ఈహు నెస్‌పిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“ఒరెన్‌ రయ్‌తు వాండ్రు విత్కు వితెఙ్‌ సొహాన్. వాండ్రు విత్కు విత్సి మహిఙ్‌ సెగం సరి పడఃకాద్‌ అర్తె. అర్తి విత్కాఙ్‌ మట్సి సొన్సి మహార్‌. ఆగాసమ్‌ది పొటిఙ్‌బా వాతెనె పెహ్త తిహె. ");
INSERT INTO kfc_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","మరి సెగం సటు ముస్కు మన్ని డులిదు అర్తె. నేరితె గాని తడిః సిల్లెండ ఆతిఙ్‌ సాతె. ");
INSERT INTO kfc_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","మరి సెగం సాప్కు తపుఙ్‌ నడిఃమి అర్తె. సాప్కు తుపెఙ్‌వెట పిరితె గాని వన్కాఙ్‌ తిగితె. ");
INSERT INTO kfc_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","మరి సెగం నెగ్గి బూమిదు అర్తె. ఆకెఙ్‌ పిరితెనె పంట నెగెండ పండితాద్. నండొ జణి ఆతాద్. విత్తి విత్తుదిఙ్‌వంత వంతుఙ్‌లెకెండ్‌ ఆతె. యేసు యా మాటెఙ్‌ వెహ్సి, ‘రుండి గిబిఙాణిఙ్‌ వెంజి అయావజ నడిఃదు’”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","వెనుక వన్నిసిసూర్‌ యా కతవజ నెస్‌పిస్తి దనిఙ్‌ అర్దం ఇనిక ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","వెన్‌బాతిఙ్‌ వాండ్రు, “దేవుణు కిని ఏలుబడిః వందిఙ్‌ డాఃఙితి మహి సఙతిఙ్‌ దేవుణు మిఙి తెలివి కిత మనాన్. గాని మహికార్‌ దేవుణు మాటదు వెహ్తి లెకెండ్, ‘సుడ్ఃజినార్‌ గాని తొఎర్, వెంజినార్‌ గాని అర్దం కిఏర్‌’. అందెఙె వరిఙ్‌ కతవజ నాను నెస్‌పిసిన. ");
INSERT INTO kfc_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","యా కతవజ నెస్‌పిస్తి దనిఙ్‌ అర్దం ఇనిక ఇహిఙ, విత్తు ఇహిఙ దేవుణు మాట. ");
INSERT INTO kfc_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","విత్తు అర్తిసరి పడఃకాద్‌ పోలితికార్‌ ఎయెర్‌ ఇహిఙ, దేవుణు మాట వెనికార్. గాని వారు దేవుణుదిఙ్‌ నమిజి, వాండ్రు వరిఙ్‌ రక్సిస్‌ఎండ మంజిని వందిఙ్‌ సయ్‌తాను వాజి వరి మన్సుదు మన్ని దేవుణు మాట పెర్జి ఒనాన్. ");
INSERT INTO kfc_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","విత్తు అర్తి సట్టుముస్కు మని డుల్లిదిఙ్‌ పోలితికార్‌ ఎయెర్‌ ఇహిఙ, దేవుణు మాట వెనివెలె సర్దదాన్‌ మన్సుదు ఇడ్నికార్. గాని వెల్ల లొఇ సొని లెకెండ్‌ దేవుణు మాట వరి మన్సు లొఇ సొన్‌ఎద్. వారు సెగం కాలం నమినార్‌ గాని కస్టం వానివలె డిఃస్నార్. ");
INSERT INTO kfc_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","విత్తు అర్తి సాప్కు తపుఙ్‌ నడిఃమి పోలితికార్‌ ఎయెర్‌ ఇహిఙ, దేవుణు మాట వెంజి నమకం బా ఇడ్నార్. గాని వారు ఆహె బత్కిజి సొనివలె బత్కువందిఙ్‌ మన్ని విసారం, సంసారం, సుకం వందిఙ్‌ ఒడ్ఃబినార్. యాకెఙ్‌ వరి నమకం తిగ్‌జి పొక్సినె. వరి బత్కుదాన్‌ ఇన్ని లాబంబా సిల్లెద్‌. ");
INSERT INTO kfc_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","విత్తు అర్తి నెగ్గి బూమిదిఙ్‌ పోలితికార్‌ ఎయెర్‌ ఇహిఙ, దేవుణు మాట వెనికార్. వారు వరిఙ్‌ తగ్ని నెగ్గి మన్సుదు దేవుణు మాట ఇడ్నార్. కస్టమ్‌కు వాతిఙ, వారు అయాకెఙ్‌ ఓరిసి నమకమ్‌దాన్‌ పిరినార్. ");
INSERT INTO kfc_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","ఎయెన్‌బా దీవ కసిసి వెన్కా తబల మూక్సినొ, మంసం అడ్గినొ ఇడ్‍ఎన్. గాని లొఇ వానివరిఙ్‌ జాయి తోర్‌దెఙ్‌ ఇజి దీవ కంతూదు‌నె ఇడ్నార్. ");
INSERT INTO kfc_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","డాఃఙితిక ఇనికబా వెల్లి ఆనాద్. ముస్తిక ఇనికబా తోరెఆజి వెల్లితనె. ");
INSERT INTO kfc_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","అందెఙె మీరు వెంజినికెఙ్‌ అర్దం కిజి మండ్రు. ఎందనిఙ్‌ ఇహిఙ, నా బాణిఙ్‌వెంజి అర్దం కిజిని వన్నిఙ్‌ దేవుణు మరి తెలివి కినాన్. గాని వెంజి అర్దం కిఇవన్నిఙ్‌వాండ్రు అర్దం కిత మన ఇజి ఒడ్ఃబితికెఙ్‌బా లాగ్నాన్. ");
INSERT INTO kfc_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","నస్తివలె యేసు అయ్‌సిని తంబెర్‌సిర్‌ వన్నిఙ్‌ సుడ్ఃదెఙ్‌ వాతార్. గాని లోకుర్‌ నండొ మహిఙ్‌ వన్ని డగ్రు సొండ్రెఙ్‌ అట్‌ఏతార్. ");
INSERT INTO kfc_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","అయావలె ఒరెన్, “నీ యాయ ని తంబెరిఙు నిఙి సుడ్ఃదెఙ్‌ కోరిజి వెల్లి నిహ మనార్”, ఇజి వన్నిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","వెహ్తిఙ్‌ యేసు, “దేవుణు మాటెఙ్‌ వెంజి అయావజ నడిఃనికారె నా యాయ నా తంబెరిఙు”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","నస్తివలె ఉండ్రి నాండిఙ్‌ యేసు వన్నిసిసూర్‌ఙ, “గనెసరెతు ఇన్ని సెరు అతాహ పడఃక సొనాట్”, ఇజి వెహ్తాన్‌. అందెఙె వారు ఉండ్రి డోణిదు ఎక్తారె సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","వారు సొన్సి మహిఙ్, యేసు నిద్ర కితాన్. అయావలె పెరి గాలి తుపాన్‌సెర్రు ముస్కు వాతాదె, డోణిదు ఏరు నిండ్రిజినాద్. వారు పెరి ప్రమాదమ్‌దు మనార్. ");
INSERT INTO kfc_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","అయావలె సిసూరు వన్ని డగ్రు సొహరె, “ప్రబువా, ప్రబువా మాపు సానా సొనాప్‌లె”, ఇజి వన్నిఙ్‌ నిక్తార్. వాండ్రు నిఙితండ్రె పెరిగాలి ఉల్లాలుఙుదిఙ్, “పలక్‌ ఆదు”, ఇజి డటం వెహ్తాన్‌. పెరిగాలి అణస్తాద్. విజు అలెతె. ");
INSERT INTO kfc_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","అయావలె వాండ్రు, “ఎందనిఙ్‌ మిఙి నా ముస్కు నమకం సిల్లెద్‌?”, ఇజి వరిఙ్‌ వెన్‌బాతాన్. వారు బమ్మఆజి తియెల్‌దాన్, “వీండ్రు గాలిదిఙ్‌ ఏరుదిఙ్‌ అణస్తు ఇజి ఆడ్ర వెహ్తిఙ్‌ అవి లొఙిజినె. వీండ్రు ఎయెండ్రొ”, ఇజి ఒరెన్‌వెట ఒరెన్‌ వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","వారు గరసినియ ఇని లోకురి ప్రాంతమ్‌దు వాతార్. అయా ప్రాంతం గలిలయ ప్రాంతమ్‌దిఙ్‌ ఎద్రు మనాద్. ");
INSERT INTO kfc_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","వాండ్రు సెరుగటుద్‌ డిగితివెలె, ఆ పట్నమ్‌దికాన్‌ ఒరెన్‌ యేసుడగ్రు వాతాన్. వాండ్రు దెయమ్‌కు అస్తికాన్. నండొ కాలమ్‌కాణిఙ్‌ సొక్కెఙ్‌ తొడిఃగిఎండ, ఇండ్రొ మన్‌ఎండ, దూకిఙాఙ్‌ మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","వాండ్రు యేసుఙ్‌ సుడ్ఃతాండ్రె డటం డేల్సి వన్ని పాదమ్‌క ఎద్రు ముణుకుఙ్‌ ఊరితాన్. ఊరితండ్రె, “విజు దనిఙ్‌ అతికారం మన్ని దేవుణు మరిసి ఆతి యేసు, నా వెట నిఙి ఇన్ని పణి, నఙి బాద కిమ ఇజి నిఙి బతిమాల్జిన”, ఇజి డేల్సి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ఎందానిఙ్‌ ఇహిఙ, యేసు, వినిఙ్‌ డిఃసి వెల్లి సొన్‌అ ఇజి ఆ దెయమ్‌దిఙ్‌ ఆడ్ర సిత మహాన్‌. అది వన్నిఙ్‌ నండొ సుట్కు అసి మహాద్‌. అందెఙె వన్నిఙ్‌ గొలుస్కాణిఙ్ కాల్కాఙ్‌ కికాఙ్‌ తొహ్సి కాప్‌ కిని వరిఙ్‌ ఇట్తాద్. గాని వాండ్రు గొలుస్కాఙ్‌ తెప్సి, దెయమ్‌కు వన్నిఙ్‌ బీడిమ్‌బూమిదు ఉలుప్సి మహె. ");
INSERT INTO kfc_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","యేసు వన్నిఙ్, “నీ పేరు ఇనిక?”, ఇజి వెన్‌బాతాన్. నండొ దెయమ్‌కు వన్ని లొఇ మహిఙ్‌ వాండ్రు, “సేన”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","మఙి దర్ణిదు పోక్‌మా ఇజి మరి మరి బతిమాల్‌తె. ");
INSERT INTO kfc_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","నస్తివలె నండొ పండ్రిఙ్‌ మంద గొరొణ్‌ సెల్కాదు మెయిజి మహె. అందెఙె వన్కా లొఇ సొండ్రెఙ్‌ మఙి సెల్వ సిదా”, ఇజి వన్నిఙ్‌ బతిమాల్‌తె. అందెఙె వాండ్రు సెల్వ సితాన్. ");
INSERT INTO kfc_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","అయావలె దెయమ్‌కు వన్నిఙ్‌ డిఃస్తెనె పండ్రిఙ లొఇ సొహె. ఆ పండ్రిఙ్‌ మంద గొరొత్‌దాన్‌ ఉహ్‌క్సి వాజి సెర్రుదు అర్తెనె సాతె. ");
INSERT INTO kfc_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","పండ్రిఙ్‌మేప్సి మహికార్‌ జర్గితి దనిఙ్‌ సుడ్ఃతారె ఉహ్‌క్సి సొన్సి ఆ పట్నమ్‌ది వరిఙ్, పట్నమ్‌ది వల్‌సెఙ మని వరిఙ్‌ జర్గితికెఙ్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","లోకుర్‌ యా జర్గితికెఙ్‌ సుడ్ఃదెఙ్‌ సొహార్‌. వారు యేసు డగ్రు వాతిఙ్‌ దెయమ్‌కు డిఃస్తి సొహికాన్‌ సొక్కెఙ్‌ తొడిఃగిజి నెగ్గి బుద్దిదాన్‌ యేసు పాదమ్‌క అడిఃగి బస్తి మహి సుడ్ఃతార్. సుడ్ఃతారె తియెల్‌ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","యాక సుడ్ఃతికార్‌ దెయం అస్తికాన్‌ ఎలాగ నెగెణ్‌ ఆతాన్‌ ఇజి మరి లోకురిఙ్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","38","అయావలె గరసినియ లోకురి ప్రాంతమ్‌దు మన్ని లోకుర్‌ విజెరె, నండొ తియెల్‌ ఆతార్. అందెఙె, “మఙి డిఃసి సొన్‌అ”, ఇజి యేసుఙ్‌ వెహ్తార్‌. అందెఙె యేసు డోణి ఎక్తాండ్రె మర్‌జి సొన్సి మహిఙ్, దెయమ్‌కు డిఃస్తి సొహికాన్, “నాను బా నీ వెట వానా”, ఇజి బతిమాలితాన్. ");
INSERT INTO kfc_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","గాని యేసు, “నీను మర్‌జి ఇండ్రొ సొన్‌అ. దేవుణు నీ వందిఙ్‌ కిత్తి గొప్ప పణి విజు వెహ్‌అ”, ఇజి వెహ్తండ్రె పోక్తాన్. వాండ్రు సొహాండ్రె యేసు వన్నివందిఙ్‌ కిత్తి గొప్ప పణి పట్నం విజు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","యేసు మర్‌జి వాతివెలె, నండొ లోకుర్‌ వన్నిఙ్‌ ఎద్రు సుడ్ఃజి మహార్‌. అందెఙె వారు వన్నిఙ్‌ డగ్రు కిత్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","నస్తివలె, యూదురి మీటిఙ్‌ ఇండ్రొణి అతికారి యాయిరు ఇనికాన్‌ యేసు పాదం ముస్కు అర్తాండ్రె, “నఙి ఒరెదె గాలు. అది సాదెఙ్‌ డగ్రు ఆత మనాద్. దనిఙ్‌ డగ్రు పనెండు పంటెఙ్. అందెఙె నీను నా ఇండ్రొ రఅ”, ఇజి బతిమాల్‌తాన్. వాండ్రు సొన్సి మహిఙ్‌ నండొ లోకుర్‌ వన్ని ముస్కు నెకె ఆజి అర్సి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","అయావలె ఉండ్రి బోదెలి పనెండు పంటెఙాణిఙ్‌ వెల్లి ఆని జబుదాన్‌ బాద ఆజి మహాద్‌. ఎయెర్‌బా దనిఙ్‌ నెగెణ్‌ కిదెఙ్‌ అట్‌ఎతార్. ");
INSERT INTO kfc_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","యేసు వెన్కాఙ్‌ వాతాదె, వాండ్రు తొడిఃగితిమన్ని వన్నినిరీ సొక్కది సెంగుదిఙ్‌ ముట్తాద్. ముట్తి వెటనె దనిఙ్‌ వాజి మహి నల అణస్తాద్. ");
INSERT INTO kfc_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","యేసు, “నఙి ముట్తికాన్‌ ఎయెన?”, ఇజి వెన్‌బాతాన్. విజెరె, “మాపు నెస్‌ఎప్”, ఇజి వెహ్తార్‌. అయావలె పేతురు, “బోదకినికిదా, నండొ లోకుర్‌ కూడిఃతారె నీ ముస్కు అర్సినార్‌ గదె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","గాని యేసు, “నఙి ఎయెండ్రొ ముట్తాన్. నా లొఇదాన్‌ దేవుణు సత్తు వెల్లి సోసి సొని లెకెండ్‌ నఙి తెలిజినాద్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","అయావలె అది యేసుఙ్‌ డాఙ్‌జి సొండ్రెఙ్‌ అట్‌ఎ ఇజి నెస్తాదె వణక్సి వాతాదె వన్ని పాదం ఎద్రు ముణుకుఙ్‌ ఊర్‌జి వఙితాద్. నాను ఎందనిఙ్‌ వన్నిఙ్‌ ముట్త ఎలాగ వెటనె నెగెణ్‌ ఆత ఇనిక విజెరె ఎద్రు అది వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","అందెఙె యేసు”, గాలు, నీను నా ముస్కు నమకం ఇడ్తి. అందెఙె నీను నెగెన్‌ఆతి. సమాదనమ్‌దాన్‌ సొన్‌అ”, ఇజి దనిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","యేసువర్గిజి మహివలెనె, యాయెరు ఇండ్రొణికాన్‌ ఒరెన్‌ వాతండ్రె, “నీ గాలు సాతాద్. బోదకినివన్నిఙ్‌ మరి వందిస్మ”, ఇజి వన్నిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","యేసు అయా మాట వెహాండ్రె, “తియెల్‌ ఆమ. నా ముస్కు నమకం ఉండ్రె ఇడ్ఃఅ. అది నెగెణ్‌ ఆనాద్”, ఇజి యాయిరుఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","యాయిరు ఇండ్రొ వాతివెలె, పేతురు, యాకోబు, యోహాను ఇని వరిఙ్‌ ని ఇజ్రి దని అయిసి అప్పొసిరిఙ్‌బా లొఇ ఒతాన్. గాని మహివరిఙ్‌ లొఇ సొండ్రెఙ్‌ సరి సిఏతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","విజెరె దన్ని వందిఙ్‌ గుండెఙ డెయ్‌ఎ ఆజి, అడఃబాజి మహార్‌. యేసు వరిఙ్, “అడఃబామాట్, అది నిద్ర కిజినాద్‌ గాని సాఎద్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","అది సాతాద్‌ ఇజి వారు నెస్త మహార్‌. అందెఙె యేసుఙ్‌ సెకాల్ కిత్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","అహిఙ, యేసు దన్నికిదు అస్తాండ్రె, “ఇజ్రి బయి నిఙ్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","దనిఙ్‌ పాణం మర్‌జి వాతిఙ్‌ అది నిఙితాద్. అయావలె వాండ్రు దనిఙ్‌ బోజనం సీదు ఇజి ఆడ్ర సితాన్. ");
INSERT INTO kfc_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","దని అయ్‌సి అపొసిర్‌ నండొ బమ్మ ఆతార్. గాని వాండ్రు యాక ఎయెరిఙ్‌బా వెహ్మట్‌ ఇజి వరిఙ్‌ ఆడ్ర సితాన్. ");
INSERT INTO kfc_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","యేసు పన్నెండు మణిసి సిసూరిఙ్‌ కూక్సి కుడుఃప్తాండ్రె విజు దెయమ్‌కాఙ్‌ పేర్‌దెఙ్, కస్టమ్‌కాఙ్‌ నెగెణ్‌ కిదెఙ్‌ వరిఙ్‌ సత్తుని అతికారం సిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","వాండ్రు, “దేవుణు ఏలుబడిః కినాన్‌ ఇజి సువార్త బోదిస్తెఙ్, కస్టమ్‌కాణిఙ్‌ మహి వరిఙ్‌ నెగెణ్‌ కిదెఙ్”, ఇజి వరిఙ్‌ పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","మరి వాండ్రు వెహ్తాన్‌, “మీరు పయాణం వందిఙ్‌ కీదు డుడ్డు గాని, సన్సి గాని రొట్టె గాని, డబ్బు గాని రుండి సొక్కెఙ్‌ గాని ఇనికబా ఒత్తెఙ్‌ ఆఏద్. ");
INSERT INTO kfc_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","మీరు ఎయె ఇండ్రొ సొనిదెరొ, అయా పట్నం డిఃస్నిదాక బానె మండ్రు. ");
INSERT INTO kfc_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","మిఙి ఎయెర్‌ డగ్రు కిఏండ మహిఙ ఆ పట్నమ్‌దాన్‌ డిఃసి సొనివలె మీ పాదమ్‌కాణి డుల్లిబాన్‌ దుల్‌ప్తు. దేవుణు మాట వారు నెక్త పొక్తిఙ్‌ దేవుణు వరిఙ్‌ కోపం ఆతాన్‌ ఇజి తోరిస్తెఙ్‌ ఆహె డుల్లి దులుప్తు”, ఇజి వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","అందెఙె వారు సోతారె, నాహ్కఙ్‌ విజు బూలాజి, సువార్త బోదిసి, ఎంబెబా కస్టమ్‌దాన్‌ మహి వరిఙ్‌ నెగెణ్‌ కిజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","గలీలయ ముటదిఙ్‌ రాజు ఆతి హేరోదు యేసుని వన్నిసిసూరు కిత్తి పణిఙ్‌ వందిఙ్‌ వెహివెలె అసల అర్దం ఆఎండ మహాన్‌. ఎందనిఙ్‌ ఇహిఙ, సెగొండార్‌ యోహాను సాతండ్రె మర్‌జి నిఙితాన్‌ ఇజి, సెగొండార్‌ ఏలియ ప్రవక్త తోరె ఆతాన్‌ ఇజి మరి సెగొండార్‌ పూర్‌బా కాలమ్‌దు మహి ఒరెన్‌ ప్రవక్త నిఙిత వాతాన్‌ ఇజి యేసు వందిఙ్‌ వర్గిజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","అయావలె హేరోదు, “నాను యోహాను బుర్ర డెఃయిస్త గదె. మరి ఎయి వందిఙ్‌ యా సఙతిఙ్‌ నాను వెంజిన? వాండ్రు ఎయెన్‌?”, ఇజి వన్నిఙ్‌ సుడ్ఃదెఙ్‌ ఆస ఆతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","అపొస్తుడు మర్‌జి వాతారె, వారు కితి పణిఙ్‌ విజు యేసుఙ్‌ వెహ్తార్‌. వాండ్రు వరిఙ్‌ వెట కూక్తాండ్రె, బత్‌సయుద ఇని పట్నమ్‌దు కేట సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","గాని మంద లోకుర్‌ ఆక నెస్తారె, వన్ని వెన్కా వాజి మహార్‌. వాండ్రు వరిఙ్‌ డగ్రు కితాండ్రె దేవుణు ఏలుబడిః వందిఙ్‌ వరిఙ్‌ వెహ్తార్‌. కస్టమ్‌దు మహి వరిఙ్‌ నెగెణ్‌ కిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","పొద్దు డిఃగ్‌జి మహివలె, పన్నెండు మణిసి సిసూర్‌ వాతారె, “మాటు ఎయెర్‌ మన్‌ఇ బాడిఃద్‌ మనాట్. అందెఙె యా లోకురిఙ్‌ మండ్రెఙ్‌ బాడిః, ఉండెఙ్‌ టిండి, దొహ్‌క్సిని వజ పడఃకాద్‌ మన్ని నాహ్కఙ్‌ వల్‌సెఙ పోక్అ”, ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","యాక వెహాండ్రె, యేసు, “మీరె వరిఙ్‌ తిండ్రెఙ్‌ఇనికబా సీదు”, ఇజి వెహ్తాన్‌. వెహ్తిఙ్‌ వారు, “మాబాన్‌ అయ్‌దు రొట్టెఙ్, రుండి మొయెఙ్‌ మనె. నిసొ మంద లోకుదిఙ్‌ బోజనం కొండెఙ్‌ మాపు అట్నాపా?”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(వాతి మని లోకుర్‌ లొఇ మొగకొడొఃర్‌నె డగ్రు అయ్‌దు వేలుఙ్‌ మనార్‌) వాండ్రు, “యాబయి మణిసిర్‌ యాబయి మణిసిర్‌ వర్‌స బసె కిదు”, ఇజి వన్ని సిసూర్‌ఙ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","వారు ఆహె కిజి విజెరిఙ్‌ బసె కిత్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","నస్తివలె వాండ్రు అయ్‌దు రొట్టెఙ్‌ని రుండి మొయెఙ్‌ అస్తాండ్రె, ఆగసం దరోట్‌ బేసి, వన్కాఙ్‌వందిఙ్‌ దేవుణుదిఙ్‌ వందనం వెహ్తాన్‌. అయాకెఙ్‌ ముకెఙ్‌ కితాండ్రె లోకురిఙ్‌ సీబాజి సీదు ఇజి వన్ని సిసూర్‌ఙ సిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","వారు విజెరె పొట పంజు తిహార్. తిహి వెనుక మిగిలితి ముకెఙ్‌ పనెండు గంపెఙ్‌ సిసూరు కెహ్తర్. ");
INSERT INTO kfc_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ఉండ్రి నాండిఙ్‌ యేసు ఒరెండ్రె పార్దనం కిజి మహాన్‌. వన్ని సిసూర్‌ వన్ని డగ్రు మహార్‌. అయావలె వాండ్రు, “నాను ఎయెన్‌ ఇజి లోకుర్‌ వర్గిజినార్‌?”, ఇజి వరిఙ్‌ వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","వారు, “బాప్తిసం సీని యోహాను ఇజి సెగొండార్‌ వెహ్సినార్. సెగొండార్‌ ఏలియ ప్రవక్త ఇజినార్‍. మరి సెగొండార్‌ పూర్‌బా కాలమ్‌దు సాతి ప్రవక్తెఙ లొఇ ఒరెన్‌ మర్‌జి నిఙితాన్‌ ఇజి వర్గిజినార్”, ఇజి వన్నిఙ్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“అహిఙ, మీరు నాను ఎయెన్‌ ఇజి వెహ్సినిదెర్‌?”, ఇజి వరిఙ్‌ వెన్‌బాతిఙ్, పేతురు, “దేవుణు ఏర్‌పాటు కితి పోక్తి క్రీస్తు”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","యాక ఎయెవెట వెహ్మట్‌ ఇజి కసితం వరిఙ్‌ ఆడ్ర సితాన్. ");
INSERT INTO kfc_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","మరి, “లోకు మరిసి ఆతి నాను నండొ కస్టమ్‌కు ఓరిస్తెఙ్‌వలె. యూద పెద్దెల్‌ఙ, పెరి పుజెరిఙు, యూదురి రూలు నెస్పిస్నికార్‌ నఙి వెల్లి కినార్. లోకుర్‌ నఙి సప్నార్‌లె. సాజి మూండ్రి దినమ్‌కాఙ్‌ దేవుణు నఙి నిక్‌నాన్‌లె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","మరి వాండ్రు వరిఙ్‌ విజెరిఙ్‌ ఈహు వెహ్తాన్‌. “ఎయెన్‌బా నా వెట వాదెఙ్‌ ఇహిఙ, వాండ్రు వన్ని సొంత ఇస్టమ్‌కు డిఃసి, వన్నిఙ్‌ వాని కస్టమ్‌కు రోజు ఓరిసి సాదెఙ్‌బా తయార్‌ ఆజి నా వెట వాదెఙ్. ");
INSERT INTO kfc_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ఎయెన్‌బా వన్ని సొంత పాణమ్‌దిఙ్‌ కాపాడఃదెఙ్‌ సుడ్ఃతిఙ, వన్నిఙ్‌ ఎల్లకాలం దేవుణు వెట బత్కిని బత్కు దొహ్‌క్‌ఎద్. గాని ఎయెన్‌బా నా వందిఙ్‌ వన్ని పాణం సితిఙ, వన్నిఙ్‌ ఎల్లకాలం దేవుణు వెట బత్కిని బత్కు దొహ్‌క్నాద్. ");
INSERT INTO kfc_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ఒరెన్‌ వాండ్రు, వాండ్రు కోరితి విజు, యా లోకమ్‌ది సంసారం సుకం విజు దొహ్‌కె ఆజి, వన్నిఙ్‌ ఎలాకాలం దేవుణు వెట బత్కిని బత్కు దొహ్‌క్‌ఎండ మహిఙ, ఇన్ని లాబం? ");
INSERT INTO kfc_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","నా వందిఙ్‌ నా మాట వందిఙ్‌ సిగు ఆని ఎంబె వన్నిఙ్‌బా నాను నెస్న ఇజి వెహ్తెఙ్ ‍లోకు మరిసి ఆతి నానుబా సిగు ఆన. నాను దేవుణు జాయ్‌దు ఒడ్ఃబిదెఙ్‌ అట్‌ఇ నని సోకుదాన్‌ వానా. అయావలె నా బుబ్బదిని, దూతెఙది జాయ్‌ ఒడ్ఃబిదెఙ్‌ అట్‌ఇ సోకుబా నా వెట మంజినాద్. అయావలె నా వందిఙ్‌ నా మాట వందిఙ్‌ సిగు ఆతి వన్ని వందిఙ్‌ నానుబా సిగు ఆన. ");
INSERT INTO kfc_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","నాను మిఙి నిజం వెహ్సిన, “ఇబ్బె నిహి మన్ని వరి లొఇ సెగొండార్, దేవుణు వన్ని లోకురిఙ్‌ ఏలుబడిః కిజినిక సూణిదాక సాఎర్”. ");
INSERT INTO kfc_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","యా మాటెఙ్‌ వెహ్తి డగ్రు ఉండ్రి వారం వెన్కా వాండ్రు, పేతురు, యాకోబు, యోహాను ఇన్ని వరిఙ్‌ వెట్ట కూక్తాండ్రె, పార్దనం కిదెఙ్‌ ఉండ్రి గొరొత్‌ ఎక్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","వాండ్రు పార్దనం కిజి మహివలె వన్ని మొకమ్‌ది మూర్తి మారితాద్. వన్ని సొకెఙ్‌ తెలాఙ్‌ ఆతె, జిగి జిగి మెరిసి మహె. ");
INSERT INTO kfc_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","అయావలె, దేవుణు మంజిని బాడ్డిదాన్‌ రిఎర్‌ వన్ని వెట వర్గిజి మహార్‌. దేవుణు బాణిఙ్‌ వాతి జాయ్‌ వరి సుటులం మహాద్‌. వారు మోసె, ఏలియ ఇనికార్. యేసు యెరూసలెమ్‌దు సాజి, ఆహె దేవుణు ఎతు కితిక బేగి పూర్తి కిని వందిఙ్‌ వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","పేతురు ని వన్ని వెట మహికార్‌ బాగ నిద్ర కితార్. తెలి ఆతి మహిఙ్‌ వారు యేసుఙ్‌ మని దేవుణు జాయ్‌దిఙ్‌ వన్ని వెట నిహి మని రిఎరిఙ్‌బా సుడ్ఃతార్. ");
INSERT INTO kfc_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ఆ రిఎర్‌ వన్ని బణిఙ్‌ సొన్సి మహిఙ్, పేతురు యేసుఙ్, “బాబు, మాటు ఇబ్బె మనిక గొప్ప నెగెద్. అందెఙె నిఙి ఉండ్రి మోసెఙ్‌ ఉండ్రి ఏలియెఙ్‌ ఉండ్రి మండ్రెఙ్‌ మూండ్రి గుడుఃసెఙ్‌ తొహ్‌నాప్. ");
INSERT INTO kfc_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","వాండ్రు ఆహె వర్గిజి మహిఙ్‌ మొసొప్‌ వాతాదె వరిఙ్‌ పిడ్ఃగ్‌తాద్. వారు మొసొప్‌ లొఇ సొహివలె సిసూరు తియెల్‌ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","అయావలె, “వీండ్రు నాను ఏర్‌పాటు కితి నా మరిను. విని మాటెఙ్‌ వెండ్రు”, ఇజి ఉండ్రి జాటు మొసొప్‌దాన్‌ వాతాద్. ");
INSERT INTO kfc_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","అయా జాటు వాతి వెనుక యేసుఙ్‌నె తోరితాద్. సిసూరు సుడ్ఃతి వన్కాఙ్‌ ఉండ్రి దనిఙ్‌బా అయా దినమ్‌కాఙ్‌ మహి ఎయెరిఙ్‌బా వెహ్‌ఎండ అల్లెత మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","మహ్స నాండిఙ్, వారు ఆ గొరొణ్‌ డిఃగ్‌జి వాతివలె నండొ లోకుర్‌ వన్నిఙ్‌ ఎద్రు వాతార్. ");
INSERT INTO kfc_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","అయావలె ఆ మంద లోకు లొఇ ఒరెన్, “ఓ బోదకినికి, నా మరిసిఙ్‌ కనికారం తోరిస్‌అ ఇజి నాను నిఙి బతిమాల్జిన. వాండ్రు నఙి ఒరెండ్రె మరిసి. ");
INSERT INTO kfc_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ఉండ్రి దెయం వన్నిఙ్‌ అస్నాద్. వెటనె వాండ్రు డెడిః‌స్నాన్. వెయ్‌దాన్‌ పంపుల్‌ వాజి అది వన్నిఙ్‌ గజగజ వణికిసి అర్‌ప్నాద్. వన్నిఙ్‌ నండొ బాద కిజి వందిసినె డిఃస్నాద్. ");
INSERT INTO kfc_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","దనిఙ్‌ సొన్‌పిస్తెఙ్‌ నీ సిసూర్‌ఙ బతిమాల్‍త గాని వారు కిదెఙ్‌ అట్‌ఎతార్”, ఇజి మొరొ కిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","అందెఙె యేసు, “యా తరమ్‌దు మనికిదెరా, మీరు తప్పు సరిదు నడఃపె ఆజినికిదెర్. నమకం సిలికిదెర్. ఎసోడ్‌ రోస్కు మీవెట మంజిన? మీరు కినికెఙ్‌ ఎసొ ఓరిస్తెఙ్‌?”, ఇజి వెహ్తండ్రె, “నీ మరినిఙ్‌ ఇబ్బె తగ్‌అ”, ఇజి వన్నిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ఆ కొడొః వాజిమహివలె వన్నిఙ్‌ అసి మహి దెయం వన్నిఙ్‌ అర్‌ప్తాదె గజ గజ వణకిస్తాద్. అయావలె యేసు ఆ దెయమ్‌దిఙ్‌ సొన్‌అ ఇజి డటిసి వెహ్తాన్‌. కొడొఃదిఙ్‌ నెగెణ్‌ కితాండ్రె అపొసిఙ్‌ ఒపజెప్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","లోకుర్‌ యా జర్గితిక సుడ్ఃతారె, దేవుణు గొప్ప సత్తు మనికాన్‌ ఇజి నండొ బమ్మ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","యేసు కితి పణి వందిఙ్‌ లోకుర్‌ విజెరె బమ్మ ఆజి మహివలె, వాండ్రు ఈహు వన్ని సిసూరిఙ్‌ వెహ్తాన్‌. “నాను యేలు వెహ్సిని మాటెఙ్‌ బాగ వెంజి పోస్‌ఎండ మండ్రు. లోకు మరిసి ఆతి నాను లోకు కీదు ఒపజెపె ఆనాలె”, ఇజి. ");
INSERT INTO kfc_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","గాని వాండ్రు వెహ్తి మాటెఙ్‌ వరిఙ్‌ అర్దం ఆఎతాద్. దేవుణు ఆక డాప్తాన్. ఎందనిఙ్‌ ఇహిఙ వారు అర్దం కిఎండ మండ్రెఙ్. ఆ మాట వందిఙ్‌ వన్నిఙ్‌ వెన్‌బాదెఙ్‌ వారు తియెల్‌ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","సిసూరు లొఇ ఎయెన్‌ పెరికాండ్రొ ఇజి ఉండ్రి ఇజ్రి గొడబ వాతాద్. ");
INSERT INTO kfc_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","యేసు వరి మన్సుదు మన్ని ఆలోసన నెస్తాండ్రె ఒరెన్‌ ఇజ్రి కొడొఃదిఙ్‌ అస్తాండ్రె వన్ని పడఃకాద్‌ నిల్‌ప్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","నిల్‌ప్తి వెన్కా వాండ్రు వరిఙ్, “ఎయెన్‌బా యా ఇజ్రి కొడొఃదిఙ్‌ నా ముస్కు నమకం ఇడ్తికాన్‌ఇజి ఒడిఃబిజి డగ్రు కితిఙ, నఙి డగ్రు కితి వజ. నఙి డగ్రు కితికాన్‌ నఙి పోక్తి దేవుణు డగ్రు కితి వజ. మీ లొఇ ఎయెన్‌ తగిజి మంజి నాండ్రొ వాండ్రె పెరికాన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","అయావలె యోహాను, “బోదకినికి, నీ సత్తుదాన్‌ దెయమ్‌కాఙ్‌ పోక్సి మహి ఒరెన్‌ వన్నిఙ్‌ మాపు సుడ్ఃతాప్. వాండ్రు మా వెట మనికాన్‌ ఆఎన్. అందెఙె మాపు వన్నిఙ్‌ అడ్డు కితాప్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","అందెఙె యేసు, “వన్నిఙ్‌ అడ్డు కిమాట్. ఎందనిఙ్‌ ఇహిఙ, మీ ముస్కు పగ సిలికాన్‌ మీ దరిఙ్‌ మనికానె”, ఇజి వన్నిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","యేసు పరలోకమ్‌దు సొండ్రెఙ్‌ దినమ్‌కుడగ్రు ఆతివెలె వాండ్రు మన్సు పూర్తి నమకం కిజి యెరూసలెమ్‌దు సొండ్రెఙ్‌ సోతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","వాండ్రు వన్నిఙ్‌ మండ్రెఙ్‌ బాడ్డిః తయార్‌ కిదెఙ్‌ ఇజి సెగొండారిఙ్‌ ముఙాల్‌ పోక్తాన్. వారు దని వందిఙ్‌ సమరియ ఇనన్ని దేసెమ్‌ది ఉండ్రి నాటొ వాతార్. ");
INSERT INTO kfc_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","గాని నాటొణికార్‌ వన్నిఙ్‌ డగ్రు కిఎతార్. ఎందనిఙ్‌ ఇహిఙ వాండ్రు యెరూసలెమ్‌దు మన్ని దేవుణు గుడిఃదు సొని ఒరెన్‌ యూద వాండ్రు. ");
INSERT INTO kfc_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","సిసూర్‌ఙ లొఇ యాకోబు, యోహాను ఇనికార్‌ యాక సుడ్ఃతారె, “ప్రబువా, యా లోకురిఙ్‌ నాసనం కిదెఙ్‌ ఆగాసం దాన్‌ మాపు సిసు తపిస్తెఙ్‌ నిఙి ఇస్టమ్‌నెనా?”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","యేసు వరి దరొట్‌ మహ్తండ్రె వరిఙ్‌ గటిఙ వెహ్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","నస్తివలె వారు మరి ఉండ్రి నాటొ సొహార్. ");
INSERT INTO kfc_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","వారు సరిదాన్‌ సొన్సి మహివలె, ఒరెన్, “నీను ఎంబె సొహిఙ్‌బా నాను నీ వెట వానా”, ఇజి వన్ని వెట వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","అందెఙె యేసు, “నక్కెఙ మండ్రెఙ్‌ బొరొఙ్‌మన్నె. ఆగాసమ్‌ది పొటిఙ మండ్రెఙ్‌ గూడుఃకు మనె. గాని లోకు మరిసి ఆతి నఙి బుర్ర అడ్డు కిదెఙ్‌బాడి సిల్లెద్‌”, ఇజి మర్‌జి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","వాండ్రు మరి ఒరెన్‌ వన్నిఙ్, “నా వెట రఅ”, ఇజి వెహ్తాన్‌. అయావలె అయా వాండ్రు, “ప్రబువా, ముఙాల నాను సొన్సి నా బుబ్బెఙ్‌ ముసి వానా”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","అందెఙె యేసు, “సాతికారె వరి సాతివరిఙ్‌ముస్తెఙ్. గాని నీను సొన్సి దేవుణు ఏలుబడిః వందిఙ్‌ బోదిస్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","మరి ఒరెన్, “ప్రబువా, నీ వెట నాను వానా. గాని నాను ముఙాల మర్‌జి సొన్సి నా ఇండ్రొణి వరిఙ్‌ వెహ్సి వాన”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","అందెఙె యేసు, “మేడిః ముస్కు కియు ఇడ్జి వెన్కా మర్‌జి బేస్నికాన్‌ ఎయెన్‌బా దేవుణు ఏలుబడిః కినివరి లొఇ ఎందనిఙ్‌ పణిదిఙ్ ‌రఇకాన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","యాక జర్గితి వెనుక, ప్రబు మరి డబయ్‌ మణిసి సిసూరిఙ్‌ ఏర్‌పాటు కితాన్. వాండ్రు సొని విజు పట్నమ్‌కాఙ్‌ విజు బాడిఃదు వన్ని ముఙల రిఎరిఙ్‌ రిఎరిఙ్‌ పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","పోక్సి, వాండ్రు వరిఙ్‌ ఈహు వెహ్తాన్‌, “కొయ్‌దెఙ్‌ మన్నిపంట లెకెండ్‌ లోకుర్‌ నండొండార్‌ మన్నె. గాని తక్కునె కొయ్‌నికార్‌ తక్కునె అందెఙె వన్ని పంట కొయ్‌నివందిఙ్‌ పణికిని వరిఙ్‌ పోక్‌అ, ఇజి కోత్త ఏజుమానిఙ్‌ బతిమాల్‌దు ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","మీరు సొండ్రు! ఇదిలో, కార్‌నుకుడిఃఙ నడిఃమి గొర్రె పిల్లెకాఙ్‌ పోక్తిలెకెండ్‌ నాను మిఙి పోక్సిన. ");
INSERT INTO kfc_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","మీరు సన్సి గాని, డబ్బుఙ్‌ ఇడ్ని సన్సి గాని, సన్సిదు మరి ఉండ్రి జత జోడ్ఃకు గాని ఒతెఙ్‌ ఆఎద్. మీరు సర్దు ఎయెరిఙ్‌ నెగెణ్‌ మనిదా ఇజి నిల్సి వర్గిజి, సమయం పాడు కిమ. ");
INSERT INTO kfc_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","మీరు ఎయె ఇండ్రొ బా సొనివలె, “యా ఇండ్రొ మంజిని వరిఙ్‌ సమాదనం కల్గిపిద్‌ ఇజి ముఙాల వెహ్తు. ");
INSERT INTO kfc_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","సమాదనం కోరిజినికాన్‌ ఒరెన్‌ బాన్‌ మహిఙ, మీ సమదనం వన్ని ముస్కు మంజినాద్. సిలిఙ, మర్‌జి మీ బానె వానాద్. ");
INSERT INTO kfc_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","వారు ఇనిక సితిఙ్‌బా ఉణిజి తింజి బానె మండ్రు. ఎందనిఙ్‌ ఇహిఙ, పణి కిని వన్నిఙ్‌వన్నిఙ్‌కావాలస్తికెఙ్‌దొహ్‌క్తెఙ్‌తగ్నికాన్. ఇల్కు ఇల్కు బూలమాట్. ");
INSERT INTO kfc_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","మరి మీరు ఎమేణి పట్నమ్‌దు సొనివలె వారు మిఙి డగ్రు కిజి ఇనిక సితిఙ ఆకదె ఉండు. ");
INSERT INTO kfc_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","బాన్‌ మని కస్టమ్‌ది వరిఙ్‌ నెగెణ్‌ కిదు. దేవుణు ఏలుబడిః కిని కాలం మీ డగ్రు వాత మనాద్‌ ఇజి వరిఙ్‌ వెహ్తు. ");
INSERT INTO kfc_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","గాని మీరు ఎమేణి పట్నమ్‌దుబా సొనివెలె వారు మిఙి డగ్రు కిఏండ మహిఙ, అయా పట్నమ్‌ది వీదిఙ సొన్సి, “మా పాదమ్‌కాఙ్‌ కస్తి మన్ని మీ పట్నమ్‌ది డుల్లిబా ఇబ్బె దుల్‌ప్సి సొన్‌సినాప్. ఎందనిఙ్‌ ఇహిఙ, దేవుణు మీ ముస్కు కోపం ఆత మనాన్‌ ఇజి తోరిస్తెఙ్. గాని ఒడ్ఃబిదు ఏలుబడిః కిని కాలం డగ్రు ఆత మనాద్‌ ఇజి తప్‌ఏండ నెస్తు”, ఇజి వెహ్తు. ");
INSERT INTO kfc_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","నాను మిఙి వెహ్సిన, దేవుణు తీర్పు కిని దినమ్‌దు యా పట్నమ్‌ది వరిఙ్‌ సిక్స మరి నండొ మంజినాద్. సొదొమ పట్నమ్‌దు మహి లోకురిఙ్‌ నసొ మన్‍ఎద్‍. ");
INSERT INTO kfc_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ఓ కొరాజి పట్నమ్‌దు మనికిదెరా, అబాయా మిఙి ఎసొ పెరి కస్టమ్‌కు వానెలె. ఓ బెత్‌సెయుద పట్నమ్‌దు మనికిదెరా, అబయా మిఙి ఎసొ గొప్ప పెరి కస్టమ్‌కు వానెలె. ఎందనిఙ్‌ ఇహిఙ, మీ నడిఃమి కితి బమ్మాతి గొప్ప పణిఙ్‌ తూరు సీదొను ఇని పట్నమ్‌కాఙ్‌ కినిక ఇహిఙ, వారు పూర్‌బమ్మ్‌దునె బస్త గరండెఙ్‌ తొహె ఆజి, నీరు వాకె అజి, పాపమ్‌కు డిఃస్తాప్‌ ఇజి తోరిస్తార్‌ మరి. ");
INSERT INTO kfc_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","దేవుణు తీర్పు కినివలె మీ పట్నమ్‌కాఙ్‌ సిక్స, తూరు సిదొను పట్నమ్‌కాఙ్‌ నండొ మంజినాద్‌లె. ");
INSERT INTO kfc_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","కపర్నహొము పట్నమ్‌దు మనికిదెరా, ఆగాసం దాక గొప్ప పెరికాప్‌ ఇజి ఒడిఃబిజినిదెరా? సిల్లె, దేవుణు మిఙి వాండ్రు మంజిని బాడిఃదాన్‌ అర్‌ప్నాన్‌లె. ఇహిఙ, దేవుణు మిఙి నాసనం కినాన్‌లె. ");
INSERT INTO kfc_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","మరి యేసు వన్ని సిసూరిఙ్, “మీ మాట వెనికాన్‌ నా మాట వెనాన్. మీ మాటదిఙ్‌ నెక్న పొక్నికాన్, నా మాటదిఙ్‌ నెక్న పొక్నాన్. నా మాటదిఙ్‌ నెక్ని పొక్నికాన్, నఙి పోక్తి వన్నిఙ్‌ నెక్న పొక్నాన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","డబయ్‌ మణిసి సిసూరు సర్‌దాన్‌ మర్‌జి వాతారె, “ప్రబువా, దెయమ్‌కుబా, నీ అతికారం దాన్‌ సొండ్రు ఇజి మాపు ఆడ్ర సీజినివలె మఙి లోబడిఃజినె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","నస్తివలె యేసు, “ఒఒ, సయ్‌తాను మిరిస్తి లెకెండ్‌ వన్ని అతికారం సిల్లెండ ఆగాసమ్‌దాన్‌ అర్తిక నాను సుడ్ఃత ");
INSERT INTO kfc_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","సారస్‍కాఙ్‌ సోర్‌కుపిఙ మట్తెఙ్‌ మిఙి అతికారం సిత మన్న. సయ్‌తాను సత్తుదిఙ్‌ గెలిస్తెఙ్‌ మిఙి అతికారం సిత్త మన్న. సయ్‌తాను మిఙి ఇనికబా కిదెఙ్‌ అట్‌ఎన్. ");
INSERT INTO kfc_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","దెయమ్‌కు మిఙి లోబడిఃజినె ఇజి సర్‌ద లావు ఆమ. గాని దేవుణు మీ పేరు వాండ్రు మంజిని బాడిఃదు రాస్త మనాన్‌ ఇజి నండొ సర్‌ద ఆదు”, ఇజి వెహ్తాన్‌‌ ");
INSERT INTO kfc_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","అయావలె యేసు, దేవుణు ఆత్మదాన్‌ నండొ సర్‌ద ఆజి, “ఓ బా, నీనె ఆగాసమ్‌దిఙ్‌ బూమిదిఙ్‌ ప్రబు. నాను నిఙి పొగిడిఃజిన. ఎందనిఙ్‌ ఇహిఙ, గెణం మని వరిఙ్, సదు మని వరిఙ్, యా నిజమాతి సఙతి డాఃప్తిదె, ఇజ్రి కొడొః లెకెండ్‌ మని వరిఙ్‌ తోరిస్తి. ఒఒ బా, అయ లెకెండ్‌ కిదెఙె నిఙి ఇస్టం ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","నా బుబ్బ నఙి విజు సఙతిఙ్‌ నా కీదు ఒపజెప్త మనాన్. మరిసి ఎయెండ్రొ ఇజి అప్పొసినె నెస్నాన్.మరి ఎయెన్‌బా నెస్‌ఎన్. అప్పొసి ఎయెండ్రొ ఇజి మరిసి ని అప్పొసిఙ్‌ తెలివి కిదెఙ్‌మరిసి ఎర్లితికార్‌నె నెస్నార్. మరి ఎయెన్‌బా నెస్‌ఎన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","వాండ్రు సిసూర్‌ దరోట్‌ మహ్తండ్రె, “దేవుణు వందిఙ్‌ వాండ్రు కిని ఏలుబడిః వందిఙ్‌ మీరు సుడ్ఃతి గొప్ప సఙతిఙ్‌ సుడ్ఃదెఙ్‌ అట్తి మీరు అంతు సిల్లి సర్‌ద మంజినికార్. ఎందనిఙ్‌ఇహిఙ, నండొ ప్రవక్తరు, రాజురుఙు మీరు సుడ్ఃజినికెఙ్, సుడ్ఃదెఙ్‌ ఇజి ఆస ఆతార్‌ గాని సుడ్ఃదెఙ్‌ అట్‌ఎతార్. మీరు వెహికెఙ్‌ వెండ్రెఙ్‌ ఇజి ఆస ఆతార్‌ గాని అట్‌ఎతార్”, ఇజి వన్ని సిసూరిఙ్‌నె వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ఉండ్రి నాండిఙ్, యూదురు రూలు నెస్‌పిస్నాన్‌ ఒరెన్‌ నిఙ్‌జి, “ఓ బోదకినికి, ఎలాకాలం దేవుణు వెట బత్కిని బత్కు దొహ్‌క నాను ఇనిక కిదెఙ్‌?”, ఇజి యేసుఙ్‌ పరీక్స కిజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","అందెఙె వాండ్రు, యూదురి రూలుదు ఇనిక రాస్త మనాద్. బాన్‌ ఇనిక సద్‌విజిని?”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","వాండ్రు, “నీ ప్రబుఆతి దేవుణుదిఙ్‌ నీ పూర్తి మన్సుదాన్, నీ పూర్తి పాణమ్‌దాన్, నీ పూర్తి సత్తుదాన్, నీ పూర్తి బుద్దిదాన్‌ ప్రేమిస్తెఙ్”. మరి, “నిఙి నీను ప్రేమిసిని లెకెండ్‌ మహివరిఙ్‌ ప్రేమిస్‌అ ఇజి రాస్త మనాద్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","అందెఙె యేసు, “నీను నెగెణ్‌ వెహ్తి. ఆహె కిఅ. అయావలె నీను ఎలాకాలం దేవుణు వెట బత్కినిలె”, ఇజి వన్ని వెట వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","అయావలె అయా యూదురి రూలు నెస్‌పిస్నాన్‌ నీతి నిజాయితి మనికాన్‌ నాను ఇజి తోరె ఆదెఙ్‌ ఈహు వెన్‌బాతాన్, “నా పడఃకాదికాన్‌ ఎయెన్‌?”, ఇజి. ");
INSERT INTO kfc_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","అందెఙె యేసు ఈహు మహ్సి వెహ్తాన్‌. “ఒరెన్‌ యెరూసలెమ్‌దాన్‌ డిఃగ్‌జి యెరికొ పట్నమ్‌దు సొనివెలె సెగొండార్‌ డొఙారి వన్నిఙ్‌ అస్తార్. అస్తారె, వాండ్రు తొడిఃగితి మహికెఙ్‌ లాగితార్. వన్నిఙ్‌ ఇజ్రి పాణం ఇట్తారె డెఃయితారె డిఃస్త సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","యావలె ఒరెన్‌ యూదురి పుజెరి ఆ సరిదాన్‌ సొండ్రెఙ్‌ పణి తాక్తాద్. వాండ్రు వన్నిఙ్‌ సుడ్ఃతాండ్రె పడఃకదాన్‌ సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","అయా లెకెండ్‌నె, లేవి ఒరెన్‌ ఆ సరిదాన్‌నె సొహాన్‌. గాని వాండ్రుబా సుడ్ఃతాండ్రె పడఃకదాన్‌ ఎర్‌లిజి సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","34","అయా సరిదాన్‌నె ఒరెన్ సమరియ వాండ్రు పయాణం కిజి మహాన్‌. వాండ్రు అర్తి మని వన్నిఙ్‌ సుడ్ఃతాండ్రె వన్ని పాణం నొతాద్. వన్ని డగ్రు సొహాండ్రె ఒలివ ఇని నూనె, ద్రాక్సకల్లు వాక్తాండ్రె వన్ని గాయమ్‌కాఙ్‌ తొహ్‌క్తాన్. వాండ్రు వన్ని సొంత గాడఃదె ముస్కు ఎకిస్తాండ్రె ఉండ్రి లార్‌జి ఇండ్రొ సొహాన్‌. వన్నిఙ్‌ నెగెణ్‌ సుడ్ఃతాన్‍. ");
INSERT INTO kfc_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","మహ్స నాండిఙ్‌ వాండ్రు రుండి వెండి రుపాయుఙ్‌ లాగితండ్రె లార్‌జి సవ్‌కారిఙ్‌ సితాన్. సితండ్రె, “వినిఙ్‌ నెగ్రెండ సుడ్ఃఅ. వినివందిఙ్‌ మరి కర్సు ఆతి మహిఙ నాను మర్‌జి వానివలె అయా డబ్బు నిఙి సీన”, ఇజి వన్ని వెట వెహ్తండ్రె సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","యా కత వెహ్తి వీస్తి వెనుక, యేసు వన్నిఙ్, “డొఙారి అస్తి వన్నిఙ్‌ యా ముఎర్‌ లొఇ ఎయెన్‌ పడఃకాదికాన్‌ ఆనాన్, ఇజి నీను వెహ్‌అ”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","యూదురి రూలు నెస్‌పిస్నాన్, “వన్ని ముస్కు పాణం నొత్తికాండ్రె, వన్ని పడఃకాదికాన్”, ఇహాన్‌. అందెఙె యేసు, “నీను సొన్సి యా లెకెండ్‌నె కిఅ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","యేసు ని వన్ని సిసురు పయ్‌నం కిజి సొన్సి మహార్‌. ఉండ్రి నాటొ సొహార్‌. అబ్బె మార్త ఇన్ని ఉండ్రి బోదెలి దన్ని ఇండ్రొ వన్నిఙ్‌ డగ్రు కిత్తాద్. ");
INSERT INTO kfc_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","దనిఙ్‌ మరియ ఇన్ని ఉండ్రి తఙిసి మనాద్. అది ప్రబు పాదమ్‌క డగ్రు బస్తాదె వన్ని బోద వెంజి మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","మార్త విజు పణి వందిఙ్‌ నండొ బాద ఆజి వన్ని డగ్రు వాతాద్. వాతాదె, “ప్రబువా, నాను ఒరెనె పణి కిదెఙ్‌ నా తఙి డిఃస్త మనాద్. నిఙి బాద సిల్లెదా? నఙి తోడుః కిఅ ఇజి దనిఙ్‌ వెహ్‌అ”, ఇజి వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","42","అందెఙె యేసు, “మార్త, నీను నండొ పణిఙ వందిఙ్‌ విసారిసి బాద ఆజిని. గాని ముకెలమతిక ఉండ్రె. మరియ అయా నెగ్గి దనిఙ్‌ కోరితాద్. దన్నిబాణిఙ్‌ ఎయెన్‌బా అయాక లాగ్జి ఒతెఙ్‌ అట్‌ఎన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ఉండ్రి నాండిఙ్‌ యేసు ఉండ్రి బాడిఃదు పార్దనం కిజి మహాన్‌. వాండ్రు పార్దనం వీస్తి వెన్కా వన్ని సిసూర్‌ లొఇ ఒరెన్, “ప్రబువా, యోహాను వన్ని సిసూరిఙ్‌ పార్దనం నెస్‌పిస్తాన్. అయాలెకెండ్‌ మఙిబా పార్దనం నెస్పిస్‌అ”, ఇజి వన్నిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","అందెఙె యేసు వరిఙ్, మీరు పార్దనం కినివెలె ఈహు వెహ్తు. “ముస్కు మన్ని మా బుబ్బ, లోకుర్‌ విజెరె నీ పేరు గొప్ప నెగ్గిక ఇజి గవ్‌రం సిపిర్. నీను లోకుర్‌ విజెరిఙ్‌ ఏలుబడిః కిపిన్. ");
INSERT INTO kfc_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","రోజు రోజు కావాలిస్తి టిండి మఙి సిదా. ");
INSERT INTO kfc_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","మఙి పాపమ్‌కు కితి వరిఙ్‌ మాపు సెమిస్తి వజ నీను మా పాపం సెమిస్‌అ. తప్ప కిబిస్నిసెఇ అసెఙ్‌ మాలొఇ రెఏండ మఙి ఇడ్ఃఅ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","మరి యేసు వరివెట ఈహు వెహ్తాన్‌. “మీ లొఇ ఒరెన్‌ వన్నిఙ్‌ ఒరెన్‌ కూలాయెన్‌ మనాన్. నీను మదరెయితు వన్నిబాన్‌ సొన్సి, ‘ఓ కూలవాండ్రు, నఙి మూండ్రి రొట్టెఙ్‌ బదలు సిదా. ఎందనిఙ్‌ ఇహిఙ, మరి ఒరెన్‌ కూలాయెన్‌ పయాణం కిజిని సరిదాన్‌ నా బాన్‌ వాత మనాన్. వన్నిఙ్‌ సీదెఙ్‌ నాబాన్‌ ఇనికబా సిల్లెద్‌”, ఇజి వెహ్సిని. ");
INSERT INTO kfc_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","అయావలె వాండ్రు లొఇహాన్‌, “నఙి బాద కిమ. సెహ్‌ల కెహ్త మనాద్. నా ఇజ్రి కొడొఃర్‌ నా వెట నిద్ర కిజినార్. నిఙ్‌జి సీదెఙ్‌ నాను అట్‌ఎ”, ఇజి వెహనండ్రా? ");
INSERT INTO kfc_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","నాను మిఙి వెహ్సిన, వన్నిఙ్‌ నిఙ్‌జి సీదెఙ్‌ ఇస్టం సిలిఙ్‌బా వాండ్రు నిఙ్‌జి సీనాన్. ఎందనిఙ్‌ ఇహిఙ, వాండ్రు కూలాయెన్‌ ఇజి ఒడిఃబిజి అహు కిఏన్. గాని సిగు డిస్తాండ్రె ఏక ఏక లొసినాన్‌ ఇజి ఒడిఃబిజి నిఙి కావలస్తిక విజు సీనాన్. ");
INSERT INTO kfc_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","అందెఙె నాను మిఙి వెహ్సిన, మీరు ఇనిక లొస్నిదెరొ, అక్క దేవుణు మిఙి సీనాన్. ఇనిక మీరు రెబాజినిదెరొ అక దేవుణు మిఙి సీనాన్‌. కొత్తు, మీ వందిఙ్‌ దేవుణు సేహ్ల రెనాన్లె. ");
INSERT INTO kfc_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ఎందానిఙ్‌ ఇహిఙ, లొస్ని విజెరిఙ్‌ దొహ్‌క్నె. రెబాని వన్నిఙ్‌ తోరె ఆజినాద్, కొత్సిని వన్నివందిఙ్‌ సేహ్ల రే ఆనాద్. ");
INSERT INTO kfc_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","మీ లొఇ అప్పొసి ఆతికాన్‌ ఎయెన్‌బా, వన్ని మరిసి మొయ లొస్తిఙ, సరాస్‌ సీనాండ్రా? ");
INSERT INTO kfc_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","కొరు గుడ్డు లొస్తిఙ, సొర్‌కుప్పి సీనాండ్రా? ");
INSERT INTO kfc_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","అహిఙ, మీరు సెఇకిదెర్‌ ఆతిఙ్‌బా, మీ కొడొఃరిఙ్‌ నెగ్గి ఇనాయమ్‌కు సీదెఙ్‌ నెస్నిదెర్. అహిఙ, ముస్కు మన్ని మీ బుబ్బ వన్నిఙ్‌ లొస్ని వరిఙ్‌ ఎసొనొ దేవుణు ఆత్మ సీనాన్”. ");
INSERT INTO kfc_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","యేసు ఒరెన్‌ వన్ని బాణిఙ్‌ గుల్ల దెయమ్‌దిఙ్‌ పేర్‌జి మహాన్‌. ఆ దెయం డిఃస్తి సొహి వెన్కా గుల్ల ఆతి మహికాన్‌ వర్గితాన్. ఆక సుడ్ఃతారె లోకుర్‌ విజెరె బమ్మ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","గాని వరి లొఇ సెగొండార్, “దెయమ్‌కాఙ్‌ నెయ్‌కి ఆతి బయిల్‌జెబెలు సత్తుదాన్‌ వీండ్రు దెయమ్‌కాఙ్‌ పేర్‌జినాన్‌ ఇజి వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","మరి సెగొండార్‌ వన్నిఙ్‌ పరిస కిదెఙ్‌ సుడ్ఃతార్. దేవుణునె వినిఙ్‌పోక్త మనాన్‌ ఇజి రుజుప్‌ కిదెఙ్‌ ఉండ్రి గుర్తు లెకెండ్‌ ఉండ్రి బమ్మ ఆని పణికిజి తోరిస్‌అ ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","వాండ్రు వరి ఆలోసన నెస్తాండ్రె వరి వెట ఈహు వెహ్తాన్‌, “ఎమేణి దేసెమ్‌దికార్‌బా వరిఙ్‌ వారె జటిఙ్‌ ఆజి కేట ఆతిఙ పాడాఃనాద్. ఆహె, ఉండ్రి కుటుమ్‌దికార్‌బా వరిఙ్‌ వారె జటిఙ్‌ ఆజి కేటఆతిఙ, ఆ కుటుం నిల్‌ఏద్. ");
INSERT INTO kfc_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","అయాలెకెండ్‌ సయ్తాను దెయమ్‌కుబా వరిఙ్‌ వారె జటిఙ్‌ఆజి కేట ఆతిఙ, సయ్‌తాను వరి ముస్కు కిని ఏలుబడిః ఎలాగ నిల్‌నాద్‌? సయ్తాను సత్తుదాన్‌ నాను దెయమ్‌కాఙ్‌ పేర్‌జిన ఇజి మీరు వెహ్సినిదెర్‌ గదె. ");
INSERT INTO kfc_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","అహిఙ, మీ సొంత లోకుర్‌ ఇన్ని దని దనటాన్‌ దెయమ్‌కాఙ్‌ పేర్‌జినార్. అందెఙె మీ సొంత లోకుర్‌నె మీరు తప్తిదెర్‌ ఇజి రుజుప్‌కిజినార్. ");
INSERT INTO kfc_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","నాను దేవుణు సత్తుదాన్‌ దెయమ్‌కాఙ్‌ పేర్త మన్నఇహిఙ దేవుణు ఏలుబడిః కినిక మీడగ్రు వాతమనాన్‌ ఇజి రుజుప్‌ ఆజినాద్. ");
INSERT INTO kfc_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","విజు అయుదమ్‌కు తొడిఃగిజి ఒరెన్‌ సత్తుమనికాన్‌ వన్నిఇల్లు అస్తి విజు కాప్‌ కితిఙ, ఇనికబా సోరిసొన్‌ఎద్. ");
INSERT INTO kfc_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","గాని వినిఙ్‌ మిస్తి నండొ సత్తు మనికాన్‌ ఒరెన్‌ వినిఙ్‌ అస్తాండ్రె విని ముస్కు గెలిస్తిఙ, వీండ్రు నమ్మితి అయుదమ్‌కు విజు వాండ్రు లాగ్జి, విని ఆస్తి సీబాన సీనాన్. ");
INSERT INTO kfc_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","నా దరిఙ్‌ మన్‌ఇకాన్‌ నఙి పగాతికాన్. నా వెట మంద కిఇకాన్, సెద్రిస్నాన్. ");
INSERT INTO kfc_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","ఉండ్రి దెయం ఒరెన్‌ వన్నిఙ్‌ డిఃస్తి సొహి వెనుక, దనిఙ్‌ మండ్రెఙ్‌ బాడ్డి రెబాజి బయిలుదు బూలాజినాద్. గాని ఎంబెబా దనిఙ్‌ బాడ్డి దొహ్‌క్‌ఇతిఙ్, “నాను డిఃస్తి వాతి నా ఇండ్రొ మర్‌జి సొనాలె”, ఇజి వెహ్నాద్. ");
INSERT INTO kfc_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","మర్‌జి వాతిఙ్‌ అది డిఃస్తివాతికాన్‌ నెగెండ్‌ సిపాజి సుబ్బరం కిజి ఇల్లు లెకెండ్, నెగెణ్‌ మనాన్‌ ఇజి నెస్తాద్. ");
INSERT INTO kfc_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","నస్తివలె అది మర్జి సొన్సి దనిఙ్‌ ఇంక సెఇకెఙ్‌ ఆతి మరి ఏడు దెయమ్‌కాఙ్‌ కూక్న తనాద్‌, అవిక్‌ వన్ని లొఇ సొన్సి అబ్బ కినె. అయవలె వన్ని గతి ముందాహి దన్నిఙ్‌ ముస్కు కస్ట్టమానాద్‌. ");
INSERT INTO kfc_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","యేసు యా మాటెఙ్‌ వెహ్సి మహివలె, ఆ మంద లొఇ మన్ని ఉండ్రి బోదెలి, “నిఙి కాస్తి పోసకితి నీ యాయ అంతు సిల్లి సర్‌ద మంజినికాద్”, ఇజి డటం వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","అయావలె వాండ్రు, “నిజమ్‌నె, గాని దేవుణు మాట వెంజి అయావజ నడిఃని విజెరెబా అంతు సిల్లి సర్‌ద మంజినికార్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","లోకుర్‌ మరి నండొ కూడిఃతి మహివలె, వాండ్రు ఈహు వెహ్తాన్‌. “యా తరమ్‌దికార్‌ నండొ సెఇకార్. వారు ఉండ్రి గుర్తు లెకెండ్‌ ఉండ్రి బమ్మ ఆని పణి కిఅ ఇజి వెన్‌బాజినార్. గాని దేవుణు ప్రవక్త ఆతి ఓనెఙ్‌ జర్గిదిక ఆఎండ, మరి ఇన్ని గుర్తుబా వరిఙ్‌ తోర్‌ఎద్. ");
INSERT INTO kfc_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","నినవె పట్నమ్‌దివరిఙ్‌ ఓన ఎలాగ ఉండ్రి గుర్తు మహండ్రొ అయాలెకెండ్‌ లోకు మరిసిఆతి నాను యా తరమ్‌దివరిఙ్‌ ఉండ్రి గుర్తు మనాన్. ");
INSERT INTO kfc_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ఆక్కరి దినమ్‌ది తీర్పుదు, దసిణ్‌ దేసెమ్‌ది రాణి యా తరమ్‌ది లోకుర్‌ వెట నిఙ్‌నాదె వరి ముస్కు నేరం మొప్నాద్. ఎందనిఙ్‌ ఇహిఙ, సొలొమోను వెహ్సిని గెణం మన్ని మాటెఙ్‌ వెండ్రెఙ్‌ బూమి కొసాదు మన్ని దని దేసెమ్‌దాన్‌ అది వాతాద్. ఏలు సొలోమొనుఙ్‌ మిస్తి పెరికాన్‌ ఇబ్బె మనాన్. ");
INSERT INTO kfc_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","కడెఃవేరి దినమ్‌ది తీర్పు, నినివె పట్నమ్‌ది లోకుర్‌ యా తరమ్‌ది లోకుర్‌ వెట నిల్‌నారె, వరి ముస్కు నేరం మొప్నార్. ఎందనిఙ్‌ ఇహిఙ, ఓన వెహ్తి బోద వెహరె, వారు పాపమ్‌కు డిఃసి ఒప్పుకొటార్. ఏలు ఓనెఙ్‌ మిస్తి పెరికాన్‌ ఇబ్బె మనాన్. ");
INSERT INTO kfc_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ఎయెర్‌బా దీవ కసిసి వెనుక డాఃప్సినొ, తూము ముసినొ ఇడ్‌ఎర్. గాని లొఇ వానివరిఙ్‌ జాయి తోర్‌దెఙ్‌ ఇజి దీవ కంతూదుద్‌నె ముస్కునె ఇడ్నార్. ");
INSERT INTO kfc_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","నీ ఒడొఃల్‌ది దీవ లెకెండె నీ కణుకు. నీ కణుకు నెగ్రెండ మనివలె, నిఙి విజు సుడ్ఃదెఙ్‌ ఆనాద్. అయాకెఙ్‌ సెఇకెఙ్‌ ఆతిఙ, నిఙి సుడ్ఃదెఙ్‌ అట్‌ఇ. ");
INSERT INTO kfc_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","అందెఙె సీకటు మన్‌ఎండ, నాను నెస్పిస్ని నిజమాతి సఙతిఙ్‌ ఆతి జాయి మీ మన్సుదు మండ్రెఙ్‌ సుడ్ఃదు. ");
INSERT INTO kfc_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","అందెఙె మన్సు పూర్తి అయా జాయిదాన్‌ నిడ్రింతి మహిఙ, అయాక నాను నెస్‌పిస్తి వజ, నెగ్రెండ మీరు బత్కిజినిదెర్‌ ఇజి తోర్నాద్. ఉండ్రి పెరి జాయి నీ ముస్కు డెఃయితిఙ ఎలాగ మంజినాదొ, అయాలెకెండ్‌ అయా జాయి నాను నెస్‌పిస్తి వజ మీరు బత్కిజినిదెర్‌ ఇజి తోర్నాద్. ");
INSERT INTO kfc_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","యేసు వర్గిజి వీస్తి వెనుక ఒరెన్‌ పరిసయు వాండ్రు, వన్ని వెట ఉండెఙ్‌ రఅ, ఇజి కూక్తాన్. అందెఙె వాండ్రు లొఇ సొహాండ్రె ఉండెఙ్‌ బస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ఉణి ముఙాల వాండ్రు యూదురిఙ్‌ మన్ని అలవాటు వజ కియు నొర్‌బాఏతాన్‌ ఇజి నెస్తాండ్రె, ఆ పరిసయు వాండ్రు బమ్మఆతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","అందెఙె ప్రబు ఈహు వెహ్తాన్‌, “పరిసయురుఙాండె, లోకుర్‌ ముస్కుహాన్‌ మిడిఃస్తి ఇడ్ని గిన్నెఙ్‌ని సొడువెఙ్‌ లెకెండ్‌ మన్నికిదెర్‌? మీరు మిఙిబా వెల్లిహాన్ సుడిఃఙ నెగ్గివరి లెకెండ్‌ తోరె ఆజినిదెర్. గాని మీ మన్సు సెఇ బుద్దిఙాణిఙ్, కకుర్‌తిదాన్‌ కూడిఃతి ఆసదాన్‌ నిండ్రితె మన్నె. ");
INSERT INTO kfc_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","బుద్ది సిలికిదెరా, ఒడొఃల్‌ తయార్‌ కిత్తి దేవుణునె మీ మన్సుదు మన్ని ఆలోసనమ్‌కు నెసినికాన్‌ ");
INSERT INTO kfc_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","మీరు కనికారం ఆజి, మిఙి కల్గితి మన్ని లొఇహాన్‌‌ సిల్లి వరిఙ్‌ దాన సీదు. అయావలె దేవుణు ఎద్రు నెగ్గికిదెర్‌ ఆనిదెర్. ");
INSERT INTO kfc_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","పరిసయురుఙాండె, అబాయా, మిఙి ఎసొనొ కస్టమ్‌కు వానెలె. ఎందానిఙ్‌ ఇహిఙ, పుదిన, సదాప, విజు కుసెఙ్, విజు దనిఙ్‌బా దసం బాగం సీజినిదెర్. గాని మీరు లోకురిఙ్‌ నాయం కిఇదెర్. దేవుణుదిఙ్‌ ప్రేమిస్‌ఇదెర్. రుండిబా ఉండ్రెలెకెండ్‌ కిజి మంజినిక ఇహిఙ ఒద్దె నెగ్గెండ్‌ మహాద్‌ మరి. ");
INSERT INTO kfc_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","పరిసయురుఙాండె, అబాయా మిఙి ఎసొనొ కస్టమ్‌కు వానెలె. ఎందానిఙ్‌ ఇహిఙ, యూదురి మీటిఙ్‌ ఇల్కాఙ్‌ ముకెలమాతి బాడిఃదు బస్తెఙ్‌ మీరు ఆస ఆనిదెర్. సతెఙ నడిఃమి పెరికార్‌ ఇజి మాడెఃసె ఆదెఙ్‌ కోరిజినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","పరిసయురుఙాండె, అబాయా, మిఙి ఎసొనొ కస్టమ్‌కు వానెలె. ఎందానిఙ్‌ ఇహిఙ, మీరు తోర్‌ఇ దూకిలెకెండ్‌ మంజినిదెర్. లోకుర్‌ దూకి ఇజి నెస్‌ఎండ వన్కా ముస్కు నడిఃజినార్. ");
INSERT INTO kfc_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","అయావలె యూదురి రూలు నెస్‌పిస్నాన్‌ ఒరెన్, “బోదకినికి, నీను యా లెకెండ్‌ వెహ్సి మఙిబా దుసలాడిఃజిని”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","అందెఙె యేసు, యూదురు రూలు నెస్పిస్నికిదెరా, అబాయా మిఙి ఎసొనొ కస్టమ్‌కు వానెలె. ఎందానిఙ్‌ ఇహిఙ, లోకుర్‌ కిదెఙ్‌ నసొ కస్టం మన్ని యూదురి రూలుఙ్, అలవాటుఙ్‌ వారు కిదెఙ్‌ ఇజి వెహ్సినిదెర్. గాని మీరు వరిఙ్‌ ఉండ్రి డఃడఃస్క దాన్‌బా తోడుః కిఇదెర్. ");
INSERT INTO kfc_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","యూదురి రూలు నెస్పిస్నికిదెరా, అబాయా మిఙి ఎసొనొ కస్టమ్‌కు వానెలె. ఎందానిఙ్‌ ఇహిఙ, మీ అనిరిఙ్‌ సప్తి ప్రవక్తరి, దూకిఙ్‌ ముస్కు మీరు గుండమ్‌కు పెర్‌జిన్‌దెర్. ");
INSERT INTO kfc_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","అయావలె వారు కితిపణివెట మీరు కూడిఃతి మనిదెర్‌ ఇజి రుజుప్‌ కిజినిదెర్. సాక్సిర్‌లెకెండ్‌ మనిదెర్‌ వారు ప్రవక్తరిఙ్‌ సప్తార్. మీరు వరి గుండమ్‌కు పెర్‌జినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","అందెఙె, దేవుణు వన్ని గెణమ్‌దాన్, ‘నాను వరి నడిఃమి ప్రవక్తెఙ, అపొస్తుడుఙ పోక్న. వరి లొఇ సెగొండారిఙ్‌ వారు సప్నార్‌లె. మరి సెగొండారిఙ్‌ మాలెఙ్ కినార్‌లె. ");
INSERT INTO kfc_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","యా లోకం పుట్తి బాణిఙ్‌ మొదొల్సి లోకుర్‌ సప్తి విజు ప్రవక్తరి నల్ల వందిఙ్‌ యా తరమ్‌ది లోకురిఙ్‌ సిక్స వానాద్. ఇహిఙ, ఏబేలు నల దాన్‌ మొదొల్సి జెకరియ నల దాక. జెక్రయెఙ్‌ సంద సుర్ని మాలి పీటని దేవుణు వందిఙ్‌ కేటఆతి గది, దినిఙ్‌ నడిఃమినె సప్తార్. వరిఙ్‌ విజేరిఙ్‌ సప్తికెఙ్‌ విజు యా తరమ్‌దివరి పణినె ఇజి నాను నిజం మీవెట వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","యూదురి రూలు నెస్పిస్నికిదెరా, అబాయా, మిఙి ఎసొనొ కస్టమ్‌కు వానెలె. ఎందానిఙ్‌ ఇహిఙ, దేవుణు వందిఙ్‌ మన్ని గెణమ్‌దు నడిఃపిసిని సేహ్‌లది తాలం మీరు అసినిదెర్. మీరు దేవుణుదిఙ్‌ టెటాఙ్‌ నెస్‌ఇదెర్. దేవుణుదిఙ్‌ నెస్తెఙ్‌ ఆస మన్ని వరిఙ్‌ మీరు అడ్డు కిజినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","వాండ్రు అబెదాన్‌ సొహి వెనుక, పరీసయిరు యూదురి రూలు నెస్పిస్నికార్‌ నండొ కోపమ్‌దాన్‌ వన్నిముస్కు నేరం మొప్తార్. వన్ని వెయ్‌దాన్‌ వాని మాటెఙ లొఇ తపుఙ్‌ అస్తెఙ్‌ ఇజి నండొ సఙతిఙ వందిఙ్‌ ప్రస్నెఙ్‌ వెనబాజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","నస్తివలె వెయుఙ్‌వెయుఙ్‌ లోకుర్‌ కూడ్ఃజి వాతార్. ఒరెన్‌దిఙ్‌ ఒరెన్‌ మట్టె ఆజి మహార్‌. అయావలె యేసు ముఙాలె వన్ని సిసూర్‌ వెట ఈహు వర్గిదెఙ్‌ మొదొల్‌స్తాన్. “మాపు నెగ్గికాప్‌ ఇజి పరిసయ్‌రు తోరె ఆని వేసం, పులాని దూరు లెకెండ్‌ మనాద్. అందెఙె జాగర్త మండ్రు. ");
INSERT INTO kfc_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","డాఃప్తిక మన్నికెఙ్‌ విజు తోరెఆనెలె. నెస్‌ఏండ ముస్కు మన్నికెఙ్‌ విజు నెసె ఆనెలె. ");
INSERT INTO kfc_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","అందెఙె మీరు సీకటుదు వర్గితికెఙ్‌ జాయిదు వెనార్. ఇహిఙ, డాఙ్‌జి వర్గితికెఙ్‌ విజెరె వెనార్‌లె. మీరు గదిఙ, గిబ్బిదు వర్గితిక మెడెఃఙ ముస్కు సాట్నార్‌లె. ");
INSERT INTO kfc_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","నా కూలెఙాతి మీ వెట వెహ్సిన, ఒడొఃల్‌దిఙ్‌ సప్తి వెనుక మరి ఇనికబా కిదెఙ్‌ అట్‌ఇ వరిఙ్‌ తియెల్‌ ఆమాట్. ");
INSERT INTO kfc_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","గాని మీరు ఎయెరిఙ్‌ తియెల్‌ ఆదెఙ్‌ ఇజి నాను నెస్‌పిస్న. ఒడొఃల్‌దిఙ్‌ సప్తి వెనుక, ఎలాకాలం మంజిని బాడిఃదు పొక్తెఙ్‌ అతికారం మన్ని వన్నిఙ్‌ తియెల్‌ ఆదు. నిజమె నాను వెహ్సిన, వన్నిఙ్‌ తియెలాదు. ");
INSERT INTO kfc_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","అయ్‌దు పంట పొటిఙ రుండి కాసుదిఙ్‌ పొర్‌నార్‌ గదె? గాని వన్కాలొఇ ఉండ్రె దనిఙ్‌బా దేవుణు పోస్‌ఎన్. ");
INSERT INTO kfc_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","మీ బురాది కొప్ప విజుబా దేవుణు లెకిస్త మనాన్. తియెలామాట్. మీరు నండొ పంట పొటిఙ మిస్తి విలువ మన్నికిదెర్. ");
INSERT INTO kfc_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","నాను మిఙి వెహ్సిన, లోకుర్‌ ముఙాలెనఙి ఒపుకొణి ఎయెవన్నిఙ్‌బా లోకుమరిసి ఆతి నాను దేవుణు దూతెఙ ఎద్రు ఒప్పకొణా. ");
INSERT INTO kfc_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","గాని లోకుర్‌ ఎద్రు నఙి నెస్‌ఎ ఇన్ని వన్నిఙ్‌ దేవుణు దూతెఙ్‌ ఎద్రు నాను బా నెస్‌ఎ ఇజి వెహ్న. ");
INSERT INTO kfc_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","లోకుమరిసిఆతి నా ముస్కు ఎయెన్‌బా పడ్ఃఇ మాట వర్గితిఙ, దేవుణు వన్నిఙ్‌ సెమిస్నాన్. గాని దేవుణు ఆత్మదిఙ్‌ దూసిస్ని ఎయెరిఙ్‌బా దేవుణు సెమిస్‌ఎన్. ");
INSERT INTO kfc_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","వారు మిఙి యూదురి మీటిఙ్‌ ఇల్కాణిఙ్‌ యూదురి అతికారిఙ ఎద్రునొ, పెద్దల్‌ఙ ఎద్రునొ ఒనార్. అయావలె ఎలాగ మర్‌జి వెహ్తెఙ్, ఇనిక వెహ్తెఙ్, ఇనిక వర్గిదెఙ్‌ ఇజి బెఙఆమాట్. ");
INSERT INTO kfc_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ఎందానిఙ్‌ ఇహిఙ, మీరు వర్గిదెఙ్‌ మనిక అయా గడిఃయద్‌నె దేవుణు ఆత్మ మిఙి నెస్‌పిస్నాన్. ");
INSERT INTO kfc_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","అయావలె ఆ మందలొఇ ఒరెన్, “బోదకినికిదా, నా బుబ్బ గణస్తి దనిఙ్‌ నఙి వానివంతు సీబాజి సిఅ ఇజి నా అన్నెఙ్‌ వెహ్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","అయావలె యేసు, “ఒరె, మీ ముస్కు తీర్పు కిని వన్ని వజనొ, సీబాజి సీని వన్ని వజనొ నఙి ఎయెన్‌ నిల్‌ప్తాన్‌?”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","మరి వరిఙ్‌ వెహ్తాన్‌, “జాగర్త మండ్రు. ఇని దనిఙ్‌బా లావుఆసెఙ్‌ ఆమాట్. ఎందనిఙ్‌ ఇహిఙ, ఎసొ ఆస్తిమన్నికాన్‌ ఆతిఙ్‌బా, వన్ని ఆస్తిలొఇ వన్ని బత్కు ఆఏద్. ఇహిఙ ఆస్తివన్నిఙ్‌ నిజమాతి బత్కు సిఏద్. ");
INSERT INTO kfc_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","మరి వాండ్రు వరిఙ్‌ కతవజ ఈహు నెస్‌పిస్తాన్. “ఒరెన్‌ ఆస్తి మనివన్నిఙ్‌ బూమిదు నండొ పంట పండితాద్. ");
INSERT INTO kfc_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","అయావలె వాండ్రు, ‘నా గింజ ఇడ్‌దెఙ్‌ నఙి బాడ్డి సాల్‌ఎద్. అందెఙె ఇనిక కిదెఙ్?’, ఇజి వన్నిమన్సుదు వాండ్రు ఒడిఃబితాన్. ");
INSERT INTO kfc_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ఒడ్ఃబితాండ్రె, ‘నాను ఈహుకిన. నా గాదిఙ్‌ లాగ్జి పెరికెఙ్‌ కిన. అబె నా గింజెఙ్, మహి సామానమ్‌కుఙ్‌ విజు ఇడ్న’, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","మరి నాను, నా వెట ఈహు వెహ్న, ‘నఙి నండొ పంటెఙ్‌ వందిఙ్‌ నండొ ఆస్తి కుడుఃప్త మన్న. సుకం ఆఅ. ఉణఅ, తిన్‌అ, సర్‌ద ఆజి మన్‌అ’, ఇజి. ");
INSERT INTO kfc_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","గాని దేవుణు వన్నిఙ్, ఓ బుద్ది సిలికి, యా రెయునె నీ పాణం లొసిన. అయావలె నీ వందిఙ్‌ ఇడ్తి మనికెఙ్‌ ఎయెరిఙ్‌ ఆనెలె? ఇజి ");
INSERT INTO kfc_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","సొంత బత్కు వందిఙ్‌ ఆస్తి కుడుఃప్ని ఎయెరిఙ్‌బా యా లెకెండ్‌ వానాద్. గాని, దేవుణు ఎద్రు, దేవుణుదిఙ్‌ ఇస్టం ఆనివజ వాండ్రు ఆస్తిమనికాన్‌ ఆఏన్”. ");
INSERT INTO kfc_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","మరి, యేసు వన్ని సిసూర్‌వెట ఈహు వెహ్సినాన్, “అందెఙె, నాను మిఙి వెహ్సిన, మీరు ఇనిక ఉండెఙ్‌ ఇజి పాణం వందిఙ్‌ విసారిస్మాట్. ఇనిక తొడ్ఃగిదెఙ్‌ ఇజి ఒడొఃల్‌వందిఙ్‌ విసారిస్మాట్. ");
INSERT INTO kfc_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ఎందానిఙ్‌ ఇహిఙ, టిండి ముస్కు పాణం ముకెలమతిక. సొక్కెఙ్‌ ముస్కు ఒడొఃల్‌ ముకెలమతిక. ");
INSERT INTO kfc_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","కాకిఙవందిఙ్‌ సుడ్ఃదు. అవి విత్‌ఉ, కొయిఉ, వన్కాఙ్‌ గాదినొ గప్పెఙ్‌నొ సిల్లు. గాని దేవుణు వన్కాఙ్‌ తిండి సీజినాన్. అహిఙ పొటిఙ ముస్కు మీరు ఎసొ విలువ మనికిదెర్. ");
INSERT INTO kfc_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","26","మీ లొఇ ఎయెన్‌బా విసారిసి వన్ని బత్కుదిఙ్‌ ఉండ్రి గంటబా కుడుఃప్సి మీ వయ్‌సు పిరీప్తెఙ్‌ అట్‌నిదెరా? అట్‌ఇదెర్. యా ఇజ్రి పణికిదెఙ్‌ మీరు అట్‌ఇదెర్‌ ఇహిఙ మరి ఎందనిఙ్‌ మహి పెరి సఙతిఙ వందిఙ్‌విసారిస్నిదెర్. ");
INSERT INTO kfc_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","పూఙదిఙ్‌ సుడ్ఃదు. అవి ‌కస్టబడిఃఉ. సొక కిదెఙ్‌ నూలుఙ్‌ తయార్‌ కిఉ. ఆఙ్‌బ విజు ఆస్తి కలిగితి మన్ని సొలోమొన్‌రాజు యా ఉండ్రి పూఙలెకెండ్‌ సోకు మన్ని ఉండ్రి సొక్కె తొడిఃగిఏతాన్‌ ఇజి నాను మిఙి వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","నేండ్రు మంజి విగెహిఙ్‌ సిసూదు విసిర్ని మడిఃఙ మంజిని గడ్డిదిఙ్‌ యా లెకెండ్‌ దేవుణు సోకు సితాన్, ఇహిఙ ఇజిరి నమకం మన్నికిదెరా మరి ఒద్దె నెగెండ సొకెఙ్‌ మిఙిసొక్కెఙ్‌ తొడిఃగిస్‌పిఏండ్రా? ");
INSERT INTO kfc_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ఇనిక ఉండెఙ్, ఇనిక తిండ్రెఙ్‌ ఇన్ని దనిఙ్‌ ఎత్తు కిజి విసారిస్మాట్. ");
INSERT INTO kfc_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ఎందనిఙ్‌ ఇహిఙ, దేవుణుదిఙ్‌ నెస్‌ఇకార్‌నె విన్క వందిఙ్‌ రెబాజినార్. మిఙి యాకెఙ్‌ కావాలె ఇజి మీ బుబ్బాతి దేవుణు నెస్నాన్. ");
INSERT INTO kfc_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","గాని దేవుణు మిఙి ఏలుబడిః కినాన్‌ ఇజి ఆసఆదు. అయావలె దేవుణు మిఙి కావాలిస్తికెఙ్‌ విజు సీనాన్. ");
INSERT INTO kfc_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ఇజిరిమంద తియెల్‌ ఆమాట్. దేవుణు, వన్నిబత్కుదు రాజులెకెండ్‌ ఇట్తి వరిఙ్‌ నెగ్గికెఙ్‌ సీదెఙ్‌ మీ బుబ్బ ఇస్టంఆత మనాన్. ");
INSERT INTO kfc_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","మిఙి కల్గితి మనికెఙ్‌ పొర్సి బీదవరిఙ్‌ సీదు. అయావలె మీరు దేవుణు మంజిని బాడిఃదు మీ వందిఙ్‌ ఆస్తిగణస్నిదెర్. అబ్బె డొఙారి రఏన్. కరి తిన్‌ఏద్. అందెఙె మీ ఆస్తితకు ఆఏద్. ");
INSERT INTO kfc_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ఎందనిఙ్‌ ఇహిఙ, మీ ఆస్తిఎంబె మనాదొ, అబెనె మీ మన్సుబా మంజినాద్. ");
INSERT INTO kfc_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","ఎస్తివలెబా పణికిదెఙ్‌ నడుఃము తొహె ఆజి, తయార్‌ఆజి మండ్రు. మీ దీవెఙ్‌ ఎస్తివలెబా కసిసి మండ్రు. పెండ్లి విందుదాన్‌ ఇండ్రొ వాజిని ఎజుమానిఙ్‌ ఎద్రు సుడ్ఃజి మంజిని పణిమణిసిర్‌ పోలిసి మండ్రు. ఎజుమాని విందుదాన్‌ వాజి సేహ్ల కొత్నివెలె వెటనె సేహ్ల వాండ్రు రేనాన్. నన్నివరిఙ్‌ పోలిసి మండ్రు. ");
INSERT INTO kfc_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ఎజుమాని వాతివెలె, వన్ని వందిఙ్‌ తెలి మంజి ఎద్రు సుడ్ఃజి మంజిని పణిమణిసిరిఙ్‌ నెగెద్. నిజమె నాను వెహ్సిన, ఎజుమాని, నడుఃము తొహె ఆజి, బోజెనమ్‌దిఙ్‌ వాతి వరిఙ్‌ బసె కిజి వరిఙ్‌ తిండి సీనాన్. ");
INSERT INTO kfc_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","మదరెయితునొ కోడిఃజామ్‌నొ ఎజుమాని వాతివెలె, వన్నివందిఙ్‌ ఎద్రు సుడ్ఃజి తెలి మంజిని వన్నిఙ్‌ నెగెద్. ");
INSERT INTO kfc_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ఎమేణి గడిఃయదు డొఙారి వానాన్‌ ఇజి ఇండ్రొణి ఏజుమాని నెస్తిఙ వాండ్రు తెలిమంజి వన్నిఇల్లు బొరొ కిఏండ సుణాన్‌ ఇజి మీరు నెస్తు. ");
INSERT INTO kfc_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","మీరు నా వందిఙ్‌ ఎద్రు సుడ్ఃఇ గడ్డిఃయాదు, లోకు మరిసి ఆతి నాను వాన. అందెఙె మీరు బా తయార్‌ ఆజి మండ్రెఙ్‌ వెలె. ");
INSERT INTO kfc_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","అయావలె పేతురు, “ప్రబువా, యా కతవజ మఙినె నెస్‌పిస్నిదా, విజెరిఙ్‌ నెస్‌పిస్నిదా?”, ఇజి యేసుఙ్‌ వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","అందెఙె యేసు, “నమకం మని, బుద్దిమని గొత్తి మణిసి ఎయెన్‌? ఎయెన్‌ ఇహిఙ, ఇండ్రొణి మహి గొత్తియారిఙ్‌ సరిఆతి గడ్డిఃయా సుడ్ఃజి వరి కార్‌డువజ వరిఙ్‌ దొహ్‌క మన్ని తిండి సామనమ్‌కు సీదెఙ్‌ ఇజి ఎజుమాని వరిముస్కు ఏర్‌పాటు కిత్తికాండ్రె. ");
INSERT INTO kfc_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ఎజుమాని మర్‌జి వానివలె వెహ్తివజ పణికితి వన్నిఙ్‌ నెగెద్. ");
INSERT INTO kfc_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","అయ ఎజుమాని వన్నిఙ్‌ కల్గితి మన్ని విజు దనిముస్కు అతికారం మని వన్నిలెకెండ్‌ వన్నిఙ్‌కినాన్, ఇజి నాను నిజం వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","46","గాని, ఉండ్రి వేల యా గొతియయెన్, ‘నా ఎజుమాని వాదెఙ్‌ ఆల్‌సెం ఆజినాన్‌’ ఇజి వన్నిమన్సుదు ఒడిఃబిజి, మహి గొతియారిఙ్‌ గొతియాణికాఙ్‌ డెఃయిజినాన్. వాండ్రు ఉణిజి, తింజి సోస్త మహాన్‌. ఆహె మహిఙ్, వాండ్రు ఎద్రు సుడ్ఃఇ దినమ్‌దు నెస్‌ఇ గడియాదు వన్ని ఎజుమాని వానాన్. అయావలె వాండ్రు వన్నిఙ్‌ కత్సి దేవుణుదిఙ్‌ నమ్‌ఇ వరివెట వరి వందిఙ్‌ తయార్‌ కిత్తిమన్ని బాడ్డిదు పొక్నాన్. ");
INSERT INTO kfc_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","ఎజుమాని ఇస్టమ్‌కు నెసిబా అయావజ కిఎండ తయారాజి మన్‌ఎండ మన్ని గొతియ వన్నిఙ్‌ నండొ సిక్ససీనాన్. ");
INSERT INTO kfc_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ఎజుమాని ఇస్టమ్‌కు నెస్‌ఎండ, సిక్సదిఙ్‌ తగితి పణిఙ్‌ కితి వరిఙ్‌ కండెక్‌ సిక్సనె సీనాన్. ఎయెరిఙ్‌ దేవుణు నండొ సిత్త మనాండ్రొ వన్నిబాణిఙ్‌ నండొ లొస్నాన్. ఎయెన్‌బాన్‌ దేవుణు మరి నండొ ఒపజెప్త మనాండ్రొ, వన్నిబాణిఙ్‌ నండొనె లొస్నాన్. ");
INSERT INTO kfc_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","సిసు లెకెండ్‌ మన్ని దేవుణు సీని సిక్స యా లోకమ్‌దు తత్తెఙ్‌ నాను వాతమన. ఆక విజెరిఙ్‌ సుర్‌నాద్. ఏలునె సురుదెఙ్‌ మొదొల్‌స్తిఙ బాగ మంజినాద్, ఇజి ఆస ఆజిన. ");
INSERT INTO kfc_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","కస్టం ఇని ఉండ్రి బాప్తిసంబా లాగెఆదెఙ్‌ మనాద్. ఆక్క పూర్తి కినిదాక నఙి నండొ విసారం మంజినాద్‌లె. ");
INSERT INTO kfc_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","యా లోకమ్‌దు సమాదనం తతెఙ్‌ నాను వాతమన్న ఇజి మీరు ఒడిఃబిజినిదెరా? సిల్లె, కేటకిదెఙ్‌నె వాత మన్న. ");
INSERT INTO kfc_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ఏలుదాన్‌ అయ్‌దుగురు మంజిని ఉండ్రి కుటుం వరిఙ్‌ వారె కేట ఆనార్‌లె. ముఏర్‌ ఉండ్రి పడఃకాద్‌ రిఏర్‌ మరి ఉండ్రి పడఃకాద్. ");
INSERT INTO kfc_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","వారు కేట ఆనార్‌లె. అప్పొసి మరిసిఙ్‌ని, మరిసి అప్పొసి ఙ్‌ని, అయిసి గాల్సిఙ్‌ని, గాడ్సి దని అయ్‌సిఙ్‌ని, మీమ్‌సి దన్ని కొడెఃసిఙ్‌ని, కొడెఃసి దన్ని మీమ్‌సిఙ్‌ని పడిఃఏండ మంజినాద్‌లె. ");
INSERT INTO kfc_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","అయావలె వాండ్రు మందలోకుదిఙ్‌ ఈహు వెహ్తాన్‌, “పడఃమటదాన్‌ మొసొప్‌ వాతిక సుడ్ఃతిఙ పిర్రు వానాద్‌లె, ఇజి మీరు వెహ్నిదెర్. ఆహె జర్గినాద్. ");
INSERT INTO kfc_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","దసిణదాన్‌ గాలి వాతిఙ గొప్పఎండ కినాద్‌ ఇజి వెహ్నిదెర్. ఆహె జర్గినాద్. ");
INSERT INTO kfc_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","వేసం కినికిదెరా, మీరు బూమిదు ఆగాసమ్‌దు జర్గినికెఙ్‌ సుడ్ఃజి గుర్తు అస్తెఙ్‌ నెస్నిదెర్. మరి ఎందానిఙ్‌ యా కాలమ్‌దు జర్గినికెఙ్‌ గుర్తు అస్తెఙ్‌ మీరు అట్‌ఏండ మంజినిదెర్‌? ");
INSERT INTO kfc_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","ఎమేణిక నాయం ఇజి మిఙి మీరె తర్పు కిదెఙ్‌ అట్‌ఇదెరా? ");
INSERT INTO kfc_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","మీ ముస్కు నేరం మొప్తివన్నివెట లాయిరి కోర్‌టుదు సొన్సి మహివలె సర్దు వన్ని వెట రాజినం ఆదెఙ్‌ సుడ్ఃదు. సిలిఙ, వాండ్రు మిఙి తీర్పు కిని వన్ని డగ్రు ఈడిఃసి ఒనాన్. తీర్పు కినికాన్‌ జమాన్‌ఙ ఒపజెప్నాన్. వాండ్రు మిఙి జెలిదు ఇడ్నాన్. ");
INSERT INTO kfc_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","తీర్పు కినికాన్‌ లొస్ని డబ్బు విజు సీనిదాక జెలిదాన్‌ వెల్లి వాదెఙ్‌ అట్‌ఇదెర్‌ ఇజి నాను మిఙి వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","అయావలె బాన్‌ మహికార్‌ సెగొండార్‌ యేసుఙ్, గలీలియాతి సెగొండార్‌ వరిఙ్‌ వెహ్తార్‌. ఇనిక వెహ్తార్‌‌ ఇహిఙ, గలీలియాతికార్‌ పూజ కిజి మహివలె, పిలాతు వరిఙ్‌ సపిస్తాన్. అయావలె పూజసిత్తి నలని లోకుర్‌నల కూడిఃతాద్. ");
INSERT INTO kfc_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","అందెఙె యేసు వరిఙ్, “వరిఙ్‌ సప్తారె యా లెకెండ్‌ నండొ బాదెఙ్‌కితార్. అందెఙె వారు మహి గలీలియాతి వరి విజెరె ఇంక నండొ పాపం కితికార్‌ ఇజి మీరు ఒడ్ఃబిజినిదెరా? ");
INSERT INTO kfc_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","సిల్లెద్‌ ఇజి మీవెట వెహ్సిన. గాని మీరు పాపమ్‌కు డిఃసిసీదు. సిల్లిఙ, మీరు విజిదెరెబా అయాలెకెండ్‌ నాసనం ఆనిదెర్. ");
INSERT INTO kfc_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","మరి సుడ్ఃదు, సిలొయొము ఇని పట్నమ్‌దు నిరిండ్‌ తొహ్తిమన్ని గుడిః అర్తిఙ్, యెరూసలెమ్‌దు బత్కిజి మహికార్‌ పద్‌ఎనిమితి మణిసి సాతార్. వారు బత్కిజిని వరి ఇంక నండొ సెఇకార్‌ ఇజి మీరు ఒడిఃబిజినిదెరా? ");
INSERT INTO kfc_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","సిల్లె ఇజి నాను మీ వెట వెహ్సిన. గాని మీరు పాపం డిఃసి సీదు. సిలిఙ, మీరుబా అయాలెకెండ్‌ నాసనం ఆనిదెర్. ");
INSERT INTO kfc_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","మరి వాండ్రు కతవజ ఈహు నెస్‌పిస్తాన్. ఒరెన్‌ వన్నిఙ్‌ ద్రాక్స టోట మనాద్. అబ్బె వాండ్రు బొడెమరాన్‌ ఉండ్రి ఉణుస్తాన్. వాండ్రు దన్నిపట్కు రెబాతివెలె ఇనికబా దొహ్‌క్‌ఎతాద్. ");
INSERT INTO kfc_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","అందెఙె వాండ్రు, ‘ఇదిలో నాను మూండ్రి పంటెఙాణిఙ్‌ యా మరాతి పట్కుఙ్‌ రెబాజి వాజిన. గాని ఇనిక బా దొహ్‌క్‌ఎతాద్. దినిఙ్‌ కత్సి విసీర్‌అ. దిన్నిదనాట్‌ యా బూమి ఎందనిఙ్‌ పాడాఃదెఙ్‌?”, ఇజి టోట కాప్‌కిని వన్నివెట వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","అందెఙె వాండ్రు, “బాబు యా ఉండ్రి ఏంటు మనిద్. నాను సుటులం కార్‌సి గతం పొక్సి సూణాట్. ");
INSERT INTO kfc_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","అక్కపట్కు అస్తిఙ నెగెద్, అస్‌ఇఙ కత్సి విసీర్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ఉండ్రి విస్రాంతిదినమ్‌దు, యేసు ఉండ్రి యూదురి మీటిఙ్‌ ఇండ్రొ బోద కిజి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","అబె పద్‌ఎనిమితి పంటెఙాణిఙ్‌ నడుఃము వక్ని దెయం అస్తి ఉండ్రి బోదెలి మహాద్‌. దన్ని నడుఃము వఙితిఙ్, అసల నెగెణ్‌ నిల్‌దెఙ్‌ అట్‌ఎద్. ");
INSERT INTO kfc_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","యేసు దనిఙ్‌ సుడ్ఃతాండ్రె, “రఅ”, ఇజి డగ్రు కూక్తాన్. మరి, “బీబి, నిఙి మన్ని కస్టమ్‌కాణిఙ్‌ నాను డిఃస్‌పిస్న”, ఇజి దనిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","మరి దనిముస్కు వన్ని కికు ఇట్తాన్. వెటనె అది నెగెణ్‌ నిహదె, దేవుణుదిఙ్‌ పొగిడిఃతాద్. ");
INSERT INTO kfc_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","విస్రాంతి దినమ్‌దు యేసు నెగెణ్‌ కితిఙ్, యూదురి మీటిఙ్‌ఇండ్రొణి అతికారి నండొ కోపం ఆతాన్. ఆతాండ్రె, లోకురిఙ్‌పణి కిదెఙ్‌ ఆరు దినమ్‌కు మనె. అందెఙె మీరు ఆ దినమ్‌క లొఇ వాజి నెగెణ్‌ ఆదు. విస్రాంతి దినమ్‌దు రమాట్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","అందెఙె యేసు, “ఓ వేసం కినికిదెరా, మీ లొఇ విజిదెరెబా మీ డాఃనుదిఙ్, మీ గాడ్ఃదెదిఙ్‌ విస్రాంతి దినమ్‌దు సాలాదాన్, డిఃసి ఒసి ఏరు సీజినిదెర్‌ గదె? ");
INSERT INTO kfc_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","అహిఙ, అబ్రాహముఙ్‌ తెగ్గతి యా బోదెల్‌దిఙ్‌ పద్‌ఎనిమితి పంటెఙ్‌ సయ్‌తాను తొహ్త ఇట్తా మనాన్. విస్రాంతి దినమ్‌దు దనిఙ్‌ తొహ్‌క్తి బాణిఙ్‌ డిఃస్‌పిస్తెఙ్‌ కూడ్ఃఎదా?”, ఇజి వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","వాండ్రు యా మాటెఙ్‌ వెహ్తివలె వన్ని పగాతికార్‌ విజెరె సిగు ఆతారె, మొకొం డిప్తార్. గాని లోకుర్‌ విజెరె వాండ్రు కితి గొప్ప పెరిపణిఙ వందిఙ్‌ సర్ద ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","మరి యేసు వన్ని లోకురిఙ్, “దేవుణు వన్ని లోకురిఙ్‌ కిని ఏలుబడిః ఇన్ని దనిఙ్ పోలిత మనాద్. ఇనిదనివెట నాను పోలిస్న? ");
INSERT INTO kfc_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","అక్కసర్‌సు గింజదిఙ్‌ పోలిత మనాద్. ఒరెన్‌ ఆక ఒతండ్రె వన్ని టోటాదు ఉణుస్తాన్. ఆక పిరిసి మరాన్‌ ఆతాద్. ఆగాసం ముస్కు ఎగ్రిజిని పొటిఙ్‌ దనికొమెఙ ముస్కు గూడుక్‌ తొహ్‌క్తె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","మరి వెహ్సినాన్, “దేవుణు వన్ని లోకురిఙ్‌ కిని ఏలుబడిః ఇని దని వెట పోలిత మనాద్‌? ");
INSERT INTO kfc_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","అక్క పులాని దూరుదిఙ్‌ పోలిత మనాద్. ఉండ్రి బోదెలి అక్కఒతాదె మరి నండొ దూరు వెట కలప్తాద్. వాక్తి దూరుదిఙ్‌బా పులాఙ్‌ కితాద్. ");
INSERT INTO kfc_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","యేసు యెరూసలెమ్‌దు సొండ్రెఙ్‌ ఇజి పయాణం కిజి మహివలె సరి పడఃకాద్‌ మన్ని నాహ్కఙ్‌ పట్నమ్‌కాఙ్‌ బోదిసి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","అయావలె ఒరెన్, “ప్రబువా, సెగొండారె దేవుణు సిక్సదాన్‌ తప్రె ఆనారా?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","అందెఙె వాండ్రు వరిఙ్, “ఇహ్కు దార్‌బందరం దాన్‌ డుగ్‌దెఙ్‌ నండొ కస్టబడిఃదు. ఎందనిఙ్‌ ఇహిఙ, నండొండార్‌ సొండ్రెఙ్‌ సుడ్ఃజినార్. గాని వారు సొండ్రెఙ్‌ అట్‌ఎర్‌ ఇజి మీ వెట వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ఇండ్రొణి ఎజుమాని నిఙ్‌జి సేహ్ల కెహ్‌తి వెన్కా మీరు వెల్లినిల్సి, సేహ్ల కొత్సి “బాబు, మఙి సేహ్ల రేఅ”, ఇజి వెహ్సినిదెర్. అయావలె వాండ్రు, “మీరు ఎమేణికిదెరొ నాను మిఙి నెస్‌ఏ”, ఇజి వెహ్నన్. ");
INSERT INTO kfc_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","అందెఙె మీరు, “ని వెట మాపు ఉణిజి, తింజి మహప్. నీను మా వీదిఙ బోదిస్తిగదె”, ఇజి వెహ్నిదెర్. ");
INSERT INTO kfc_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","గాని వాండ్రు, “మీరు ఎమేణికిదెరొ, మిఙి నాను నెస్‌ఎ. సెఇపణి కిని మీరు విజిదెరె, నా బాణిఙ్‌డిఃసి సొండ్రు”, ఇజి వెహ్నన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","మరి వాండ్రు, “అబ్రాహము, ఇస్సాకు, యాకొబురిఙ్‌ విజెరె ప్రవక్తరు దేవుణు మంజిని బాడిఃదు వాండ్రు ఏలుబడిః కినివెలె మంజినిక సుడ్ఃజినిదెర్. గాని వాండ్రు మిఙి వెల్లి కినాన్. అయావలె, మీరు అడఃబాజి, పల్కు కొహ్‌క్సి ఎలాకాలం సిసు మంజిని బాడ్డిదు మంజినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","మరి, దేవుణు మంజిని బాడిఃదు వాండ్రు ఏలుబడిః కినివలె, తూర్‌పుదాన్‌ పడఃమటదాన్, ఉస్సన్‌దాన్, దసిణదాన్‌ నండొ యూదురు ఆఇకార్‌ వాజి వింతుదు బస్నార్. ");
INSERT INTO kfc_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ఇదిలో, పెరికాప్‌ ఇజి ఒడ్ఃబితికార్‌ ఇజ్రికార్‌ ఆనార్. తగిజి మహికార్‌ ముఙాల్‌ ఆనార్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","అయావలెనె, సెగొండార్‌ పరిసయ్‌రు వాతారె, “నీను ఇబ్బెణిఙ్‌ సోసి సొన్‌అ. హెరొదు నిఙి సప్తెఙ్‌ సుడ్ఃజినాన్”, ఇజి యేసుఙ్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","అందెఙె వాండ్రు, “మీరు సొన్సి ఆ పాడు కిని నక్కవెట ఈహు వెహ్తు. “నాను నేండ్రు, విగెహిఙ్, దెయమ్‌కాఙ్‌ పేర్‌జి, కస్టమ్‌దివరిఙ్‌ నెగెణ్‌ కిజి, ముఎహి, దినమ్‌దు పూర్తి కిన. ");
INSERT INTO kfc_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","గాని నాను నేండ్రు, విగెహిఙ్, ముఎహిఙ్‌ నా సరిదు నాను సొండ్రెఙ్‌వెలె. ఎందానిఙ్‌ ఇహిఙ, ప్రవక్త యెరుసలెమ్‌దిఙ్‌ వెల్లి సాదెఙ్‌ ఆఎన్. ");
INSERT INTO kfc_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ఓ యెరూసలెమ్‌దు మనికిదెరా, మీరు ప్రవక్తరిఙ్‌ సప్తిదెర్. మీ డగ్రు దేవుణు పోక్తి వరిఙ్‌ పణకాణిఙ్‌ డెఃయితిదెర్. కొరు దన్నిపిల్లెకాఙ్‌ దన్నిరెక్కెఙ్‌ అడిఃగి ఎలాగ ఇడ్నాదొ, అయావజ మిఙి డగ్రు కిదెఙ్‌ ఎసోడ్‌ సుట్కు నాను ఆస ఆత, గాని నిఙి ఇస్టం సిల్లెండ మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ఇదిలో, దేవుణు వన్ని గుడిఃడిఃసి సొనాన్‌లె. ప్రబు సిత్తి అతికారమ్‌దాన్‌ వాతికాన్‌ పొగ్‌డెఃఆనికాన్‌ ఇజి మీరు వెహ్నిదాక మీరు నఙి తొఇదెర్‌ ఇజి మీ వెట వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ఉండ్రి విస్రాంతి దినమ్‌దు, యేసు పరిసయ్‌రు అతికారిఙ ఒరెన్‌ వన్ని ఇండ్రొ బోజెనమ్‌దిఙ్‌ సొహాన్‌. అయావలె యేసు ఇనిక కినాండ్రొ ఇజి వారు బాగసుడ్ఃజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","నస్తివలె కిక్కుకాల్కు వాస్తికాన్‌ ఒరెన్‌ వన్ని ఎద్రు మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","యేసు”, విస్రాంతి దినమ్‌దు నెగెణ్‌ కినిక మీ యూదురిఙ్‌ రూలుఙ్‌ తప్నికాదా సిలికాదా?”, ఇజి పరిసయ్‌రుఙని యూదురి రూలు నెస్‌పిస్నివరిఙ్‌ వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","గాని వారు అలెత మహార్‌. అందెఙె యేసు అయా జబుది వన్నిఙ్‌ డగ్రు కూక్తాండ్రె, నెగెణ్‌ కితాండ్రె పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","వెనుక వాండ్రు వరిఙ్, “మీ లొఇ ఎయెది బా గాడఃదె గాని కోడిః గాని విస్రాంతి దినమ్‌దు గుటాద్‌అర్తిఙ, దన్నిఙ్‌ వెటనె వెల్లి లాగ్‌ఇదెరా?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","యా మాటెఙ్‌ వారు మర్‌జి వెహ్తెఙ్‌ అట్‌ఏతార్. ");
INSERT INTO kfc_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","వాతి కూలెఙ్, విందుదు ముకెలమాతి బాడిఃఙ్‌ సుడ్ఃజి బాన్‌ బస్తిక సుడ్ఃతాన్‍. సుడ్ఃతాండ్రె కతవజ ఈహు నెస్‌పిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","ఎయెన్‌బా పెండ్లి విందుదిఙ్‌ మిఙి కూక్నివెలె, పెరికార్‌బస్నిబాడిదు బస్మాట్. ఉండ్రి వేలా మిఙి ఇంక పెరివన్నిఙ్‌ వాండ్రు కూక్తాన్‌సు. వాండ్రు వాతిఙ, మీ రిఎరిఙ్‌ కూక్తికాన్‌ వాజి నిఙి, “ఇదిలో, నీ బాడ్డిః వినిఙ్‌ సిఅ”, ఇజి వెహ్నన్. నస్తివలె మీరు సిగు ఆజి వెన్కాహి బాడిఃదు బస్తెఙ్‌ సొనిదెర్. ");
INSERT INTO kfc_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","అందెఙె మిఙి ఎయెన్‌బా కూక్తిఙ, మీరు సొన్సి వెన్కాహి బాడిఃదు బస్తు. అయావలె మిఙి కూక్తికాన్‌ వాజి, “కూలాయెన్‌ నీను పెరికార్‌బస్ని బాడిఃదు సొన్సి బస్‌అ”, ఇజి వెహ్నన్. అయావలె నీ వెట బస్తివరి ఎద్రు నిఙి గొప్ప గవ్‌రం వానాద్. ");
INSERT INTO kfc_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","వన్నిఙ్‌ వాండ్రె పెరికాన్‌ ఇజి ఒడ్ఃబిని ఎయె వన్నిఙ్‌బా దేవుణు ఇజ్రికాన్‌ కినాన్. వన్నిఙ్‌ వాండ్రె ఇజ్రికాన్‌ ఇజి తగిజి ఒడ్ఃబిని ఎయె వన్నిఙ్‌బా దేవుణు పెరికాన్‌ కినాన్. ");
INSERT INTO kfc_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","మరి, యేసు వన్నిఙ్‌ విందుదిఙ్‌ కూక్తి వన్నివెట, “నీను విందు కిదెఙ్‌ ఇహిఙ, నీ కూలెఙనొ, నీ అన్నారిఙ్‌నొ, నీ నేస్తమ్‌కాఙ్‌నొ, నీ పడఃకాద్‌ మన్ని సంసారిఙనొ కూక్మ. ఎందనిఙ్‌ ఇహిఙ, ఉండ్రి వేలా వారు నిఙి మర్‌జి కూక్నార్. అయావలె నీను కిత్తిదన్నిఙ్‌ వారు మర్‌జి కిజినార్. ");
INSERT INTO kfc_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","అందెఙె నీను విందు కినివెలె, బీదాతి వరిఙ్, నీర్‌సమ్‌దివరిఙ్, సొటవరిఙ్, గుడ్డివరిఙ్‌ కూక్‌అ. ");
INSERT INTO kfc_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ఎందనిఙ్‌ ఇహిఙ, మిఙి మర్‌జి సీదెఙ్‌ వారు అట్‌ఎర్. అందెఙె దేవుణు మిఙి దీవిస్నాన్‌లె. దేవుణు తీర్పు కిని దినమ్‌దు నీతి మన్ని విజు లోకురివెట నీను సాజి మర్‌జి నిఙ్‌ని వెలె, నీను కితి నెగ్గి పణి వందిఙ్‌ దేవుణు మిఙి మర్‌జి సీనాన్. ");
INSERT INTO kfc_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","వన్ని వెట ఉండెఙ్‌ బస్తిమహి వరిలొఇ ఒరెన్‌ యాక విహండ్రె, యేసుఙ్, “దేవుణు ఏలుబడిః కినిక టెటాఙ్‌ సూణివెలె, విందుద్‌ ఉణికాన్‌ అంతు సిల్లి సర్‌ద మంజినికాన్‌ ఆనాన్‌లె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","17","అందెఙె యేసు ఈహు వెహ్తాన్‌. “ఒరెన్‌ విందు కిదెఙ్‌ ఇజి వన్ని నండొ కూలెఙ కబ్రుఙ్‌ పోక్తార్. విందు తయార్‌ ఆతిఙ్, వన్ని పణిమణిసిఙ్‌ కూక్తాండ్రె, “ఉండెఙ్‌ రదు. విజు తయార్‌ ఆతె ఇజి కబ్రు కిత్తివరిఙ్‌ సొన్సి వెహ్‌అ”, ఇజి పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","గాని కూలెఙ్‌ ఉండ్రె లెకెండ్‌ పణిఙ్‌ వెహ్సి తప్రె ఆతార్. మొదొహికాన్, “నాను ఉండ్రి మడిఃఙ్‌ కొట మన్న. నాను అయక సొన్సి సుడ్ఃదెఙ్‌వెలె, నఙి సెమిస్‌అ ఇజి బతిమాల్‌జిన”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","మరి ఒరెన్, “నాను అయ్‌దు సెర్కు డాను కొట మన్న. ఆకెఙ్‌ నెగెణ్‌ మనెనొ సిలెనొ ఇజి సుడ్ఃదెఙ్‌ సొన్సిన. నఙి సెమిస్‌అ, ఇజి బతిమాల్‌జిన”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","మరి ఒరెన్, “నాను ఏలు పెండ్లి ఆత మన్న. అందెఙె వాదెఙ్‌ అట్‌ఏ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","22","పణిమణిసి మర్‌జి వాతండ్రె, యా మాటెఙ్‌ వన్ని ఎజుమానిఙ్‌ వెహ్తాన్‌. అయావలె అయా ఇండ్రొ ఎజుమాని కొపం ఆతండ్రె, “నీను పట్నమ్‌క వీదిఙ, సందిఙ బేగి సొన్సి బీదాతి వరిఙ్‌, నీర్‌సమ్‌ది వరిఙ్, సొటాది వరిఙ్, గుడ్డి వరిఙ్‌ కూక్సి తగ్‌అ”, ఇజి పణి మణిసిఙ్‌ వెహ్తాన్‌. వాండ్రు, “బాబు నీను వెహ్తి లెకెండ్‌ కిత. గాని మరి నండొ బాడ్డి మనాద్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","అయావలె ఎజుమాని, “నా ఇల్లు నిండ్రిదెఙ్, నీను నాహ్క వీదిఙ సందిఙ సొన్సి లోకురిఙ్‌ ఈడిఃసి తగ్‌అ”, ఇజి వన్ని పణిమణిసిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ఎందానిఙ్‌ ఇహిఙ, కూక్తి అయా కూలెఙ లొఇ ఒరెన్‌బా ఆ టిండి రుసి నెస్‌ఎన్”, ఇజి మీ వెట వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","మంద లోకు వన్ని వెట సొన్సి మహివలె వరిదరిఙ్‌ సుడ్ఃజి వాండ్రు ఈహు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“ఎయెన్‌బా నా సిసూడుః ఆదెఙ్‌ ఇహిఙ, నఙి ఇంక, వన్ని అయిసి అపొసిఙ్‌ వన్ని ఆలు ని కొడొరిఙ్, వన్ని అన్న తంబెరిఙ్, వన్ని తఙి బీబిఙ్‌ మరి వన్ని సొంత పాణమ్‌దిఙ్‌బా నండొ ప్రేమిస్తెఙ్‌ ఆఏద్. వాండ్రు నండొ ప్రేమిస్తిఙ, నా సిసూడుః ఆదెఙ్‌ అట్‌ఏన్. ");
INSERT INTO kfc_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ఎయెన్‌బా కస్టమ్‌కు ఓరిసి సాదెఙ్‌బా ఇస్టం ఆజి నా వెట వాతిఙనె నా సిసూడుః ఆనాన్. ");
INSERT INTO kfc_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","మీ లొఇ ఎయెన్‌బా ఉండ్రి నిరీ గుడిః తొహ్‌తెఙ్‌ఆస వాతిఙ, వాండ్రు ముఙాల బసి, దనిఙ్‌ కర్సు ఎసొ ఆనాద్‌ ఇజి లెక్కసుణాన్. పణి పూర్తి కిదెఙ్‌ వన్ని కీదు మనిక ఆనాదొ, సాల్‌ఎదొ ఇజి సూణాన్‌ గదె? ");
INSERT INTO kfc_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","అయక తొఏండ వాండ్రు పునాది పొక్సి, పూర్తి తొహ్‌తెఙ్‌ అట్‌ఇతిఙ, అక్కసూణికార్‌ విజెరె, “వీండ్రు తొహ్‌తెఙ్‌ మొదొల్‌స్తాన్‌ గాని పూర్తి కిదెఙ్‌ అట్‌ఎతాన్”, ఇజి వన్నిఙ్‌ కరాయి ఇనార్. ");
INSERT INTO kfc_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","ఒరెన్‌ రాజు మరి ఒరెన్‌ రాజువెట ఉద్దం కిదెఙ్‌ సొండ్రెఙ్‌ ఇహిఙ, వాండ్రు ముఙాలె బస్తాండ్రె సుణాన్, ఇరువయ్‌ వేలుఙ్‌ లోకుర్‌వెట అయా రాజు వాజినాన్. వన్ని ముస్కు ఉద్దం కిదెఙ్‌ నా పది వెయుఙ్‌లోకుర్‌ వెట నాను అట్నానా, సిలెనా ఇజి. ");
INSERT INTO kfc_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","అట్‌ఇఙ, అయా రాజు దూరం మనివెలెనె సల్‌వాణిఙ్‌ పోక్సి సమాదనం కిదెఙ్‌ వాండ్రు సుణాన్. ");
INSERT INTO kfc_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","అయలెకెండ్‌నె, మీ లొఇ ఎయెన్‌బా వన్నిఙ్‌ కల్గితికెఙ్‌ డిఃస్‌ఎండ మహిఙ, నా సిసూడుః ఆఏన్. ");
INSERT INTO kfc_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","సోరు నెగ్గికదె, గాని దనిఙ్‌ మన్ని రుసి సొహిఙ, ఎలాగ మరి రుసి తపిస్తెఙ్‌ ఆనాద్‌? ");
INSERT INTO kfc_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","అయాక బూమిదిఙ్‌బా గాని గత్తమ్‌దిఙ్‌బా గాని పణిదిఙ్‌ రఎద్. అందెఙె అయాక వెల్లి విసీర్నార్. గిబ్బిఙ్ ఒడ్ఃజి‌ వెండ్రు. అయావజ నడిఃజి మండ్రు”, ఇజి వెహ్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ఉండ్రి నాండిఙ్‌ పన్ను పెర్నికార్‌ని పాపం కిజినికార్‌ ఇజి యూదురు సుడ్ఃతికార్‌ విజెరె వన్ని బోద వెండ్రెఙ్‌ వన్ని డగ్రు కూడిఃత మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","పరిసయ్‌రు ని యూదురి రూలుఙ్‌ నెస్పిస్నికార్, “వీండ్రు పాపం కిజిని వరిఙ్‌ డగ్రు కిజి వరివెట కూడ్ఃజి బోజనం కిజినాన్”, ఇజి సణిఙితార్. ");
INSERT INTO kfc_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","అందెఙె వాండ్రు వరిఙ్‌ కతవజ నెస్‌పిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“ఉండ్రి వేల మీ లొఇ ఒరెన్‌వన్నిఙ్‌ వంద గొర్రెఙ్ మనె. వన్కాలొఇ ఉండ్రి గొర్రె మురుతిఙ, వాండ్రు అయా తొమ్‌బయి తొమెది గొర్రెఙ, అడిఃవిదు డిఃసి మురుతి మని గొర్రెదొహ్నిదాక రెబానాన్‌గదె? ");
INSERT INTO kfc_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","అది దొహ్‌క్తివలె సర్‌ద ఆజి వన్ని గుంజమ్‌దు పిండిజి ఇండ్రొ తనాన్. మరి వన్ని కూలెఙ పడఃకాతి వరిఙ్‌ కూక్సి, “మురుతి మహి నా గొర్రె దొహ్‌క్తె. అందెఙె నా వెట సర్‌ద ఆదు”, ఇజి వెహ్నన్. ");
INSERT INTO kfc_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","అయా వజనె, తొమ్‌బయి తొమెది మణిసిర్‌ పాపం ఒప్పుకొండెఙ్‌ అవుసరం సిలి నీతి నిజాయితిదికార్‌ మనార్. వరి వందిఙ్‌ కల్గిని సర్‌ద ముస్కు పాపమ్‌కు డిఃసి సితి వన్ని వందిఙ్‌ దేవుణు మంజిని బాడిఃదు నండొ సర్‌ద కల్గినాద్, ఇజి నాను మీ వెట వెహ్సిన”. ");
INSERT INTO kfc_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“మరి, ఉండ్రి బోదెల్‌దిఙ్‌ పది వెండి రుపాయి మహె. వన్కాలొఇ ఉండ్రి రుపాయి మురుతిఙ, అది దీవ కసిసి, ఇల్లు సిపాజి, అది దొహ్‌క్నిదాక నెగెండ రెబాఏదా? ");
INSERT INTO kfc_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","అక్కదొహ్‌క్తివెలె దన్ని కూలెఙాణిఙ్, పడఃకాతి వన్కాఙ్‌ కూక్సి, “నా మురుతి మహి రుపాయి దొహ్‌క్తాద్. అందెఙె నా వెట సర్ద ఆదు”, ఇజి వెహ్నద్. ");
INSERT INTO kfc_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","అయావజనె పాపమ్‌కు డిఃసి సితి వన్ని వందిఙ్‌ దేవుణు వన్ని దూతెఙ ఎద్రు సర్ద ఆజినాన్‌ఇజి నాను మీ వెట వెహ్సిన”. ");
INSERT INTO kfc_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","మరి వాండ్రు ఉండ్రి వెహ్తాన్‌, “ఒరెన్‌ వన్నిఙ్‌ రిఎర్‌ మరిసిర్‌ మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","కొగ్రి మరిసి, “ఓ బా, నీను గణస్తి దన్నిలొఇ నఙి వానివంతు సిదా”, ఇజి అపొసిఙ్‌ లొస్తాన్. అందెఙె అపొసి వన్ని ఆస్తి వరిఙ్‌ సీబాత సిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","సెగం రోస్కు సొహి వెనుక, కొగ్రి మరిసి వన్నిఙ్‌ కల్గితికెఙ్‌ విజు కుడుఃప్సి, నండొ దూరం మన్ని దేసమ్‌దు సొహాన్‌. అబ్బె వాండ్రు సెఇ అలవాటుఙ ఆతాండ్రె వన్ని ఆస్తివిజు పాడు కిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","విజు కర్సు కిత్తివెనుక, ఆ దేసమ్‌దు గొప్ప కరు వాతాద్. వన్నిఙ్‌ ఇనిక బా దొహ్‌క్‌ఎతాద్. ");
INSERT INTO kfc_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","అందెఙె వాండ్రు ఆ దేసెమ్‌ది ఒరెన్‌ వన్ని డగ్రు పణికిదెఙ్‌ సొహాన్‌. వాండ్రు పండ్రిఙ్‌ మెప్తెఙ్‌ వన్ని మడిఃఙ వన్నిఙ్‌ పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","పండ్రిఙ్‌ తిని పొడుః తింజి బఙ సొన్‌పిస్తెఙ్‌ ఇజి ఆస ఆతాన్. గాని ఎయెర్‌బా వన్నిఙ్‌ ఇనికబా సిఏతార్. ");
INSERT INTO kfc_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","వన్నిఙ్‌ బుద్ది వాతివెలె వాండ్రు ఈహు ఒడిఃబితాన్, “నా బుబ్బ డగ్రు ఎసొండారొ పణిమణిసిర్‌ మనార్. వరిఙ్‌ ఉండెఙ్‌ అట్‌ఇ నస్సొ జావ దొహ్‌క్సినాద్. ఇబ్బె నాను బఙ సాజిన. ");
INSERT INTO kfc_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","నాను ఇబ్బె డిఃసి నా బుబ్బ డగ్రు సొన్సి, ‘ఓ బా, నాను దేవుణుదిఙ్‌ పడ్ఃఇ పణి కిత. నీ ఎద్రు పాపం కిత. ");
INSERT INTO kfc_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","నీ మరిన్‌ ఇజి కూకె ఆదెఙ్‌ నాను ఏపటితికాన్‌ ఆఏ. నీ పణిమణిసి ఒరెన్‌ వన్నిలెకెండ్‌ నఙి సుడ్ఃఅ’, ఇజి నాను వెహ్న”, ఇజి ఒడ్ఃబితాండ్రె అబెణిఙ్‌ డిస్తాండ్రె వాజినాన్. ");
INSERT INTO kfc_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","వాండ్రు దూరం మహివలెనె అప్పొసి వన్నిఙ్‌ సుడ్ఃతాన్‍. వన్ని పాణం నొతాండ్రె ఉహ్‌క్సి సొన్సి పొంబితాండ్రె ముదు కిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","నస్తివలె వాండ్రు అప్పొసిఙ్, “ఓ బా, నాను దేవుణుదిఙ్‌ పడ్ఃఇ పణి కిత్త. నీ ఎద్రు పాపం కిత్త. నీ మరిన్‌ ఇజి కూకె ఆదెఙ్‌ నాను ఏపటితికాన్‌ ఆఏ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","గాని అప్పొసి వన్ని పణిమణిసిర్‌ కూక్తాండ్రె, “సొక్క బేగి తగ్‌అ. వినిఙ్‌ తొడిఃగిస్తు. బొందు ఇడ్ఃకిస్తు. పాదమ్‌కాఙ్‌జోడ్ఃకు తొడిఃగిస్తు. ");
INSERT INTO kfc_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","బలిస్తి దూడః తసి ఓహ్‌క్తు. మాటు తింజి సర్ద ఆనాట్. ");
INSERT INTO kfc_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ఎందానిఙ్‌ ఇహిఙ, యా నా మరిన్‌ సాతి లెకెండ్‌ మహాన్‌. మరి ఏలు బత్కితాన్. మురుతి లెకెండ్‌ మహాన్‌. మరి యేలు దొహ్‌క్తాన్”, ఇజి వెహ్తాన్‌. వారు సర్ద ఆజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","అయావలె పెరిమరిసి మడిఃఙ సొహ మహాన్‌. వాండ్రు మడిఃఙాణిఙ్‌ వాజి ఇల్లు డగ్రు వాతివెలె, బాజెఙ్‌ డెఃయిజినిక, కర్‌జిజినిక వెహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","అందెఙె వాండ్రు పణిమణిసిర్‌ లొఇ ఒరెన్‌ వన్నిఙ్‌ కూక్తాండ్రె, ఇనిక జర్‌గిజినాద్, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","అయా పణిమణిసి, “నీ తంబెరి వాతాన్. వాండ్రు నెగ్రెండ మర్‌జి వాతివందిఙ్‌ నీ బుబ్బ బలస్తి దూడః ఓహ్‌క్తాన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","పెరి మరిసి కోపం ఆతండ్రె, లొఇ సొండ్రెఙ్‌ కెఎతాన్. అందెఙె అప్పొసి వెల్లి వాతండ్రె, లొఇ రఅ, ఇజి వన్నిఙ్‌ బతిమాల్‌తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","అయావలె వాండ్రు వన్ని అప్పొసి వెట, “ఇదిలో నిసొడు పంటెఙాణిఙ్‌ ఒరెన్‌ గొతియయెన్‌ లెకెండ్‌ పణి కిత్త. ఎసెఙ్‌బా, నీ మాటెఙ్‌ నాను లొఙిఏండ మన్‌ఏత. నా కూలెఙ్‌వెట సర్ద ఆదెఙ్‌ నీను నఙి ఉండ్రి గొర్రె పిల్లబా సిఇతి. ");
INSERT INTO kfc_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","గాని సాని బూలాని వరిఙ్‌ సీజి నీ ఆస్తి విజు పాడు కిత్తి యా మరిసి వాతిఙ్‌ బలస్తి దూడః ఓహ్‌క్తి”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","అందెఙె అప్పొసి, “నా మర్రిన్, నీను ఎస్తివలెబా నా వెటనె మన్ని. నఙి మనికెఙ్‌ విజు నీవి. ");
INSERT INTO kfc_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","మాటు విందు కిజి సర్‌ద ఆనిక నెగెద్. ఎందానిఙ్‌ ఇహిఙ, నీ యా తంబెరి సాతి లెకెండ్‌ మహండ్రె, మర్‌జి నిఙితాన్. మురుతి లెకెండ్‌ మహండ్రె దొహ్‌క్తాన్”, ఇజి వన్ని వెట వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","మరి, యేసు వన్ని సిసూర్‌ఙ ఈహు వెహ్తాన్‌. ఒరెన్‌ సంసారం మన్ని వన్ని ఇండ్రొణి సఙతిఙ సూణి పెరి గొతియయెన్‌ ఒరెన్‌ మహాన్‌. యా గొతియయెన్‌ సామనమ్‌కు పాడు కిజినాన్‌ ఇజి నేరం మొప్తిక వెహాన్. ");
INSERT INTO kfc_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","అందెఙె వన్నిఙ్‌ కూక్‌పిస్తాండ్రె, “నీ వందిఙ్‌ నాను వెంజిని యా మాట ఇనిక? ఇండ్రొణి పణిఙ లెక్క తోరిస్‌అ. ఎందానిఙ్‌ ఇహిఙ, నీను ఏలుదాన్‌ నా గొతియయెన్‌ ఆఇ”, ఇజి వన్నిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","యాక వెహాండ్రె వాండ్రు ఈహు ఒడ్ఃబితాన్. “నా ఎజుమాని యా పణిదాన్‌ నఙి లాగ్‌జినాన్. అందెఙె నాను ఇనిక కిదెఙ్‌? కార్తెఙ్‌ అట్‌ఎ. లొసి ఉండెఙ్‌ సిగు వాజినాద్. ");
INSERT INTO kfc_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","యా పణిదాన్‌ లాగ్నివెలె, లోకుర్‌ నఙి డగ్రు కినిలెకెండ్‌ ఇనిక కిదెఙ్‌ ఇజి నాను నెసిన. ");
INSERT INTO kfc_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","అందెఙె వాండ్రు వన్ని ఎజుమాని బాన్‌ అప్పు ఒతివరిఙ్‌ ఒరెన్‌ ఒరెన్‌ వన్నిఙ్‌ కూక్‌పిస్తాన్. “నీను నా ఎజుమాని బాణిఙ్‌ ఎసొ ఒతిమన్ని?”, ఇజి మొదొహి వన్నిఙ్‌ వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","వాండ్రు, “వంద కాయెఙ్‌ నూనె”, ఇజి వెహ్తాన్‌. అందెఙె వాండ్రు, “ఇదిలో నీ సీటి. బేగి బసి యాబయి కాయెఙ్‌ ఇజి రాస్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","వెన్కాహివన్నిఙ్, “నీను ఎసొ ఒతిమన్ని?”, ఇజి వెన్‌బాతాన్. వాండ్రు, “వంద తూముఙ్‌ గోదము”, ఇజి వెహ్తాన్‌. అయావలె వాండ్రు, “ఇదిలో నీ సీటి. ఎనబయి తూముఙ్‌ ఇజి రాస్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","అనెయం కిత్తి యా పెరి గొత్తియయెన్‌ తెలివందిఙ్‌ ఎజుమాని పొగిడిఃతాన్. ఎందానిఙ్‌ ఇహిఙ, వానికాలమ్‌ది వన్ని బత్కు వందిఙ్‌ వాండ్రు యా లెకెండ్‌ కితాన్. అందెఙె యేసు, వెహ్సినాన్, “దేవుణుదిఙ్‌ నమిజి వాండ్రు వెహ్తి వజ నడిఃనివరి ముస్కు, అయా పెరి గొతియయెన్‌ లెకెండ్, యా లోకమ్‌ది సఙతిఙ వందిఙె ఒడ్ఃబినికారె తెలిమనికార్. వారు వరిలెకెండ్‌ మన్ని వరివెట కూడ్ఃజి పాడిఃజి మండ్రెఙ్‌ తెలిమనికార్. ");
INSERT INTO kfc_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","మీరు యా లోకమ్‌దు బత్కిజిని మనివలె ఇబ్బె మిఙి మనికెఙ్‌ విజు దని వెట మీరు నెగ్రెండ తెలిదాన్‌ మండ్రెఙ్‌ సుడ్ఃదు. ఎందనిఙ్‌ ఇహిఙ, మీరు మీ బత్కు ఇబ్బె డిఃస్నివలె దేవుణు మిఙి వాండ్రు మంజిని బాడిఃదు ఎలాకాలం మండ్రెఙ్‌ డగ్రు కినాన్‌లె. ");
INSERT INTO kfc_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","తక్కు దన్నిముస్కు నమకం మంజినికాన్‌ లావు దన్నిముస్కుబా నమకమ్‌దాన్‌ మంజినాన్. తక్కు దన్నిముస్కు నమకం సిలికాన్, లావు దన్నిముస్కుబా నమకం మన్‌ఎన్. ");
INSERT INTO kfc_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","అందెఙె, మిఙి మన్ని ఆస్తి నమకమ్‌దాన్‌ తొఎండ మహిఙ, నిజమాతి ఆస్తి ఎయెర్‌ మిఙి ఒపజెప్నార్. ");
INSERT INTO kfc_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","పడఃకాతి వరి దన్నిముస్కు నమకమ్‌దాన్‌ తొఏండ మహిఙ, నీ సొంతదిక ఆతి నిజమాతి ఆస్తి ఎయెన్‌ మిఙి సీనాన్. ");
INSERT INTO kfc_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","ఎమేణి గొతియయెన్‌బా రిఎర్‌ యజమానరిఙ వందిఙ్‌ఉండ్రె లెకెండ్‌పణి కిదెఙ్‌ అట్‌ఎన్. వాండ్రు ఒరెన్‌ వన్నిఙ్‌ ఇస్టం కిఎండ మరి ఒరెన్‌ వన్నిఙ్‌ ప్రేమిస్నాన్. సిలిఙ, ఒరెన్‌ వన్ని మాట వెంజి నమకమ్‌దాన్‌ మంజినాన్. మరి ఒరెన్‌ వన్నిఙ్‌ దుసలాడ్ఃనాన్. అయలెకెండ్‌నె దేవుణుదిఙ్‌ ని డబ్బుదిఙ్‌ ఉండ్రె లెకెండ్‌నె సేవకిదెఙ్‌ మీరు అట్‌ఇదెర్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","డబ్బు ఆస మన్ని పరిసయ్‌రు యా మాటెఙ్‌ విజు వెహరె, వన్నిఙ్‌ వెక్రిస్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","వాండ్రు వరిఙ్‌ ఈహు వెహ్తాన్‌, “లోకుర్‌ ముఙాల మీరు నీతి నిజాయితి మనికిదెర్‌ ఇజి తోరిస్నిదెర్. గాని దేవుణు మీ మన్సుదికెఙ్‌ నెస్నాన్. లోకుర్‌ ఎద్రు గొప్ప విలువ మనిక దేవుణుదిఙ్‌ ఇస్టం సిల్లికాదె. ");
INSERT INTO kfc_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","దేవుణు మోసెఙ్‌ సిత్తి రూలుఙ్‌ని ప్రవక్తరు రాస్తికెఙ్‌ బాప్తిసం సీని యోహాను కాలం దాక బోదిసి మహార్‌. అబెణిఙ్‌ అసి దేవుణు, వన్నిలోకురిఙ్‌ కిని ఏలుబడిః వందిఙ్‌ సువార్త వెహె ఆజి మహాద్‌. దేవుణు కిని ఏలుబడిఃదు మండ్రెఙ్‌లోకుర్‌నండొ కస్టబడిఃజినార్. ");
INSERT INTO kfc_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ఆగసం బూమి సిల్లెండ ఆదెఙ్‌సులునె, గాని దేవుణు సితి రూలుఙది ఉండ్రి గీతబా తప్సి సొన్‌ఏద్. ");
INSERT INTO kfc_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ఎయెన్‌బా వన్ని ఆల్సిఙ్‌ డిఃసి మరి ఉండ్రి బోదెల్‌దిఙ్‌ ఇడ్డెః ఆతిఙ, దని వెట వాండ్రు రంకు బూలాజినాన్. మాసిఙ్‌ డిఃస్తి దనిఙ్‌ ఒరెన్‌ఇడెః ఆతిఙ, వాండ్రు రంకు బూలాజినాన్. ");
INSERT INTO kfc_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ఒరెన్‌ ఆస్తిమన్నికాన్‌ మహాన్‌. వాండ్రు నండొ కరీది సొక్కెఙ్‌ తొడ్ఃగిజి విజు దినమ్‌కు సుకం ముస్కు మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","లాజరు ఇని లొసిఉణికాన్‌ ఒరెన్‌ మహాన్‌. వన్ని ఒడొఃల్‌కండి విజు పుట్కు మహె. ఆస్తిమన్ని వన్ని ఇండ్రొణి డేవాద్‌ వన్నిఙ్‌ ఇట్తా మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","వన్ని బల్లదాన్‌ అర్తి జావ పరెఙ్‌ ఉణిజి బఙ సొన్‌పిస్తెఙ్‌ ఆసఆజి మహాన్‌. నుకుడిఃఙ్‌బా వాజి వన్ని పుట్కు నాక్సి మహె. ");
INSERT INTO kfc_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","లొస్ని ఉణికాన్‌ సాతాన్. దేవుణు దూతెఙ్‌ వన్నిఙ్‌ దేవుణు మంజిని బాడిఃదు అబ్రాహం పడఃకాదు ఒతాన్. ఆస్తిమన్నికాన్‌బా సాతాన్. వన్నిఙ్‌ ముస్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","వాండ్రు అయా లోకమ్‌దు బాదఆజినె, బుర్ర పెర్జి ముస్కు బేస్తాన్. దూరం మన్ని అబ్రాహముఙ్‌ని వన్నిపడఃకాద్‌ మన్ని లాజరుఙ్‌ సుడ్ఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","అందెఙె వాండ్రు, “బుబ్బ ఆతి అబ్రాహము, నా ముస్కు కనికారం తోరిస్‌అ. నాను యా సిసుదు నండొ బాద ఆజిన. అందెఙె లాజరు వాజి వన్ని డెఃస్క ఏరుదు ముడుక్సి నా నాలిక సలెఙ్‌ కిదెఙ్‌ వన్నిఙ్‌ పోక్‌అ”, ఇజి డేల్సి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","అందెఙె అబ్రాహము, “మరిన్‌ నీను బత్కితి కాలమ్‌దు సుకం ముస్కు మహి. గాని లాజరు కస్టమ్‌దు మహాన్‌. ఏలు వాండ్రు ఇబ్బె సుకం దాన్‌ మనాన్. నీను కస్టమ్‌దు మన్ని. ");
INSERT INTO kfc_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","యాకదె ఆఏండ, ఇబ్బెణికార్‌ అబ్బె వాదెఙ్‌ అట్‌ఏండ, అబెణికార్‌ ఇబ్బె వాదెఙ్‌ అట్‌ఏండ మఙి నిఙి నడిఃమి పెరిజోరె ఇట్తా మనాద్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","అయావలె వాండ్రు, “అహిఙ, ఓ బా, నఙి అయ్‌దుగురు దాదార్‌ మనార్. వారు బా యా కస్టమ్‌కు మన్నిబాడిఃదు రఏండ మండ్రెఙ్‌ నా బుబ్బ ఇండ్రొ లాజరుఙ్‌ పోక్‌అ. వాండ్రు సొన్సి వరిఙ్‌ వెహ్నన్, ఇజి నాను నిఙి బతిమాల్‌జిన”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","అందెఙె అబ్రాహము, “వరి డగ్రు మోసె రాస్తికెఙ్, ప్రవక్తరు రాస్తికెఙ్‌ మనె. వారు అయాకెఙ్‌ వెంజి మండ్రెఙ్”, ఇజి వన్నిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","వాండ్రు, “బుబ్బాతి అబ్రాహము, ఆహె వారు కిఎర్. సాతికాన్‌ ఒరెన్‌ వరి డగ్రు సొన్సి వెహ్తిఙనె, వారు పాపమ్‌కు డిఃసి సీనార్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","అందెఙె వాండ్రు, “మోసె రాస్తి మనికెఙ్‌ ప్రవక్తరు రాస్తికెఙ్‌ వారు వెన్‌ఎండ మహిఙ, సాతికాన్‌ మర్‌జి నిఙ్‌జి సొన్సి వెహ్తిఙ్‌బా వారు నమ్మిఏర్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","యేసు వన్ని సిసూర్‌ఙ ఈహు వెహ్తాన్‌. “తప్పఙ్‌ కిబిస్ని సఙతిఙ్‌ తప్‌ఎండ వానెలె. గాని యా సఙతిఙ్‌ ఎయెవెట వానెనొ వన్నిఙ్‌ అబాయా, నండొ బాద. ");
INSERT INTO kfc_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ఎయెన్‌బా నా ముస్కు నమకం ఇడ్తి మన్ని యా కొడొః నన్ని ఒరెన్‌వన్నిఙ్‌ తప్పకిబిస్తెఙ్‌ సుడ్ఃతిఙ పెరిసిక్స వానాద్. దిన్నిముస్కు ఇజిరిసిక్సనె వన్ని మెడఃదు జత్త పణుకు తొహ్సి సందారమ్‌దు విసీర్‌నిక. ఆకదె వన్నిఙ్‌ నెగెద్. ");
INSERT INTO kfc_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","అందెఙె మీ వందిఙ్‌ మీరె జాగర్త మండ్రు. నీ తంబెరినొ, ఎయెన్‌బా నిఙి తప్పు కితిఙ, వన్నిఙ్‌ డటం బుద్ది వెహ్‌అ. వాండ్రు తప్పడిఃసి ఒప్పకొటిఙ వన్నిఙ్‌ సెమిస్‌అ. ");
INSERT INTO kfc_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ఉండ్రి దినమ్‌దు ఏడు సుట్కు వాండ్రు నిఙి తపుఙ్‌ కిజి, ఏడు సుట్కు నీ డగ్రు వాజి ‘నాను తప్పడిఃసి ఒపుకొడిఃజిన’, ఇజి వెహ్తిఙ నీను వన్నిఙ్‌ సెమిస్‌అ”. ");
INSERT INTO kfc_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","నస్తివలె పన్నెండు మణిసి అపొస్తుడుఙ, మఙి నండొ నమకం సిదా”, ఇజి ప్రబుఙ్‌ లొస్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","అందెఙె వాండ్రు, “మిఙి సర్సుగింజ నస్తు నమకం మహిఙ, యా మలబరి మరాతిఙ్‌ సుడ్ఃజి, “వెలెఙాణిఙ్‌ పెర్రె ఆజి సందారమ్‌దు ఉణుసె ఆఅ”, ఇజి వెహ్ని వెలె అది మిఙి లొఙినాద్. ");
INSERT INTO kfc_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","8","ఉండ్రి వేల, మీలొఇ ఒరెన్‌వన్నిఙ్‌ డూదెఙ్‌నొ గొర్రెఙ మేప్తెఙ్‌నొ వెట్టిపణి కినికాన్‌ ఒరెన్‌ మనాన్. వాండ్రు మడిఃఙదాన్‌ వాతిఙ, “బేగి రఅ, వాజి ఉణఅ”, ఇజి వెహ్నిదెరా? సిల్లె, గాని, ‘సుబ్బరం ఆజి వర్‌అ, నఙి బాట సీజి ఉణితిని దాక మన్‌అ. వెనుక నీను ఉణఅ’, ఇజి వెహ్నిదెర్. ");
INSERT INTO kfc_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","వన్నిఙ్‌ ఒపజెప్తి పణి కితిఙ్‌ ఎజుమాని వన్నిఙ్‌ వందనమ్‌కు వెహ్నండ్రా? ");
INSERT INTO kfc_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","అందెఙె మీరు బా మిఙి ఒపజెప్తి పణిఙ్‌ విజు కితి వెనుక, “మాటు పణిమణిసీర్. వందనమ్‌కు వెహె ఆదెఙ్‌ అవ్‌సరం సిల్లెద్‌. మాటు కిదెఙ్‌ మన్ని పణినె కితాట్”, ఇజి వెహ్తెఙ్. ");
INSERT INTO kfc_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","యేసు యెరూసలెమ్‌దు సొన్సి మహివలె, సమరియ గలిలయ ముట్ట సరిఅద్దుదాన్‌ సొన్సి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","వాండ్రు ఉండ్రి నాటొ సొన్సి మహివలె పది మణిసి కుస్టురోగం మనికార్‌ వన్నిఙ్‌ ఎద్రు వాతార్. వారు దూరం నిహరె, “యేసు ఎజుమాని, మా ముస్కు కనికారం తోరిస్‌అ”, ఇజి డెడిఃస్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","వాండ్రు వరిఙ్‌ సుడ్ఃతాండ్రె, “సొన్సి, మీరు నెగెణ్‌ ఆతిదెర్‌ ఇజి పుజెరిఙ తోరె ఆదు”, ఇజి వెహ్తాన్‌. వారు సొన్సి మహిఙ్‌ నెగెణ్‌ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","వరిలొఇ ఒరెన్, నెగెణ్‌ ఆత ఇజి నెస్తాన్. వాండ్రు డటం దేవుణుదిఙ్‌ పొగిడిఃజి మర్‌జి వాతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","వాతాండ్రె యేసుఙ్‌ పాదమ్‌క ముస్కు ముణుకుఙ్‌ ఊర్‌జి మాడిఃస్తాండ్రె, వందనమ్‌కు వెహ్తాన్‌. వాండ్రు సమరియదికాన్. ");
INSERT INTO kfc_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","అందెఙె యేసు, “పది మణిసిర్‌ నెగెణ్‌ ఆతార్‌ గదె. ఆ తొమెది మణిసిర్‌ ఎంబె మనార్‌? ");
INSERT INTO kfc_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","19","ఎందానిఙ్‌ వీండ్రు ఒరెండ్రె దేవుణుదిఙ్‌ పొగిడిఃదెఙ్‌ మర్‌జి వాతాన్. వీండ్రు యూదురిఙ్‌ సెంద్‌ఇకాన్. ఇస్రాయేలుదికార్‌ ఎందనిఙ్‌ తోరె ఆఎతార్‌?”, ఇజి వెహ్తాన్‌. వెహ్తండ్రె, “నీను నిఙ్‌జి సొన్‌అ. నీను నా ముస్కు నమకం ఇడ్తి అందెఙె నెగెణ్‌ ఆతి”, ఇజి వన్నిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ఒర్నెండు, దేవుణు ఏలుబడిః కినిక లోకుర్‌ ఎసెఙ్‌ సూణార్‌ ఇజి పరిసయిరు వన్నిఙ్‌ వెన్‌బాతార్. అందెఙె వాండ్రు, “దేవుణు రాజువజ వాని ముఙాల్‌ తోర్ని గుర్తు ఇనిక సిల్లెద్‌. ");
INSERT INTO kfc_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","దేవుణు మిఙి ఏలుబడిః కిజినిక ఇయేలె మొదొల్‌స్త మనాన్. అందెఙె, ఇదిలో ఇబ్బె మనాద్, అదిలో అబ్బె మనాద్‌ ఇజి లోకుర్‌ వెహ్ని గుర్తు ఇనిక సిల్లెద్‌”, ఇజి వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","మరి వాండ్రు వన్ని సిసూర్‌ఙ వెహ్తాన్‌, “లోకు మరిసి ఆతి నాను గొప్ప అతికారం దాన్‌ సోకుదాన్‌ మంజినిక కండెక్‌ టయం బా సుడ్ఃదెఙ్‌ ఇజి మీరు కోరిజిన రోస్కు వానెలె. గాని ఆ రోస్కు లొఇ ఉండ్రి రోజుబా మీరు తొఇదెర్. ");
INSERT INTO kfc_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","లోకుర్‌ మిఙి, “ఇదిలో ఇబ్బె మనాన్, అదిలో అబ్బె మనాన్”, ఇజి వెహ్నర్. గాని వరి వెట సొన్మాట్. వరి మాట అస్మాట్. ");
INSERT INTO kfc_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ఎందానిఙ్‌ఇహిఙ, ఆగసమ్‌దు మెరిస్నివెలె ఉండ్రి పడఃకదాన్‌ మరి ఉండ్రి పడఃకాద్‌ జాయి తోర్నివజనె లోకు మరిసి ఆతి నాను వానివలె మంజినాద్. ");
INSERT INTO kfc_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","గాని ముఙాల యా తరమ్‌దికార్‌ నఙి నెక్సిపొక్సినార్. వాండ్రు నండొ ఇమ్‌సెఙ్‌ ఓరిస్తెఙ్‌వెలె. ");
INSERT INTO kfc_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","నోవాహు కాలమ్‌దు మహిలెకెండ్‌నె లోకు మరిసిఆతి నాను వాని ముఙాల మంజినాద్. ");
INSERT INTO kfc_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","నోవాహు ఓడఃదు సొనిదాక లోకుర్‌ ఉణిజి తింజి మహార్‌. పెండ్లి ఆజి పెండ్లిదిఙ్‌ సీజి మహార్‌. నస్తివలె గడ్డ నిండ్రిజి, వరిఙ్‌ విజెరిఙ్‌ నాసనం కిత్తాద్. ");
INSERT INTO kfc_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","లోతు కాలమ్‌దు మహిలెకెండ్‌నె, నాను వాని ముఙాల మంజినాద్. లోకుర్‌ ఉణిజి, తింజి, కొడుఃజి పొర్సి మహార్‌. పల వాక్సి, ఉణుసి, ఇల్కు తొహ్సి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","లోతు సొదొమ డిఃస్తి సొహి నాండిఙ్, ఆగసమ్‌దాన్‌ సిసు రంజికం పిరు లెకెండ్‌ వాజి వరిఙ్‌ విజెరిఙ్‌ నాసనం కిత్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","యా లెకెండ్‌నె, లోకు మరిసి ఆతి నాను వాని దినమ్‌దు జర్గిజి మంజినాద్. ");
INSERT INTO kfc_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","నాను వాని దినమ్‌దు, మీద్దె ముస్కు మంజినికాన్‌ ఇండ్రొ మన్ని వన్ని సామనమ్‌కు ఒతెఙ్‌ డిగ్‌దెఙ్‌ ఆఎద్. అయలెకెండ్‌నె మడిఃఙ మంజినికాన్‌ ఇనికబా ఒతెఙ్‌ మర్‌జి వాదెఙ్‌ ఆఏద్. ");
INSERT INTO kfc_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","లోతు ఆల్‌సిఙ్‌ ఒడ్ఃబిదు. అది దేవుణు వెహ్తి మాట వెన్‌ఇతిఙ్‌ సాతాద్. ");
INSERT INTO kfc_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ఎయెన్‌బా వన్ని సొంత పాణమ్‌దిఙె కాపాడఃదెఙ్‌సుడ్ఃతిఙ వన్నిఙ్‌ ఎలాకాలం దేవుణు వెట బత్కిని బత్కు దొహ్‌క్‌ఎద్. ఎయెన్‌బా నా వందిఙ్‌ వన్ని పాణం సితిఙ, వాండ్రు ఎలాకాలం దేవుణు వెట బత్కిని బత్కు దొహ్‌క్నాద్‌. ");
INSERT INTO kfc_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","నాను మీ వెట వెహ్సిన, అయా పొదొయి రిఎర్‌ ఉండ్రి మన్సమ్‌దు గూర్నార్. ఒరెన్‌ వన్నిఙ్‌ దేవుణు ఒనాన్. ఒరెన్‌ వన్నిఙ్‌ డిఃస్న సొనాన్. ");
INSERT INTO kfc_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","రుండి బోదెక్‌ కూడ్ఃజి నూర్‌జి మంజినె. ఉండ్రి దనిఙ్‌ దేవుణు ఒనాన్. ఉండ్రి దనిఙ్‌ డిస్న సొనాన్. ");
INSERT INTO kfc_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","రిఎర్‌ మడిఃఙ మంజినార్. ఒరెన్‌ వన్నిఙ్‌ దేవుణు ఒనాన్. ఒరెన్‌ వన్నిఙ్‌ డిఃస్న సొనాన్. ");
INSERT INTO kfc_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","అయావలె సిసూరు, “ప్రబువా, ఎంబె యాక జర్గినాద్‌?”, ఇజి వెనబాతార్. వెనబాతిఙ్‌ వాండ్రు, “పీనుగు ఎంబె మంజినాద్‌ ఇజి నెస్తెఙ్‌ డేగెఙ్‌ ఉండ్రి గుర్తు ఆనిలెకెండ్, యేసు వానిక నెస్తెఙ్‌ టెటాఙ్‌ గుర్తుఙ్‌ మన్నె. ");
INSERT INTO kfc_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","వన్నిసిసూర్‌ డిఃస్‌ఏండ ఎస్తివలెబా పార్దన కిజి మండ్రెఙ్‌ ఇజి నేర్‌పిస్తెఙ్‌ యేసు వరిఙ్‌ కతవజ ఈహు నెస్‌పిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","అక్కఇనిక ఇహిఙ, ఉండ్రి పట్నమ్‌దు ఒరెన్‌ నాయం కినికాన్‌ మహాన్‌. వాండ్రు దేవుణుదిఙ్‌ తియెల్‌ ఆఇకాన్. లోకాఙ్‌ లసెం కిఇకాన్. ");
INSERT INTO kfc_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ఆ పట్నమ్‌దు ఉండ్రి రాండి బోదెల్‌ మహాద్‌. అది వన్ని డగ్రు డిఃస్‌ఎండ వాజి, “నా ముస్కు పగ ఆతికాన్‌ ఒరెన్‌ మనాన్. వాండ్రు నఙి సీదెఙ్‌ మనిక సీనిలెకెండ్‌ నీను నాయం తీరిస్‌అ”, ఇజి బతిమాల్‌జి మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","వాండ్రు సెగం కాలం కెఏతాన్. వెనుక వాండ్రు, “నాను దేవుణుదిఙ్‌ తియెల్‌ ఆఇకాన్. లోకాఙ్‌ లసెం కిఇకాన్. గాని యా ముండ బోదెలి డిఃస్‌ఎండ వాజి నఙి ఏక ఏక లొసినాద్. అందెఙె అది మరి మరి వాజి బాద కల్గిస్‌ఏండ దన్నిఙ్‌ నాయం తీర్‌స్న”, ఇజి వన్నిఙ్‌ వాండ్రె వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","మరి యేసు వెహ్తాన్‌, “విండ్రు, యా నీతి నిజాయితి సిలి నాయం కినికాన్‌ ఇనిక వెహ్తాన్‌‌ ఇజి. ");
INSERT INTO kfc_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","అహిఙ, నీతి నిజాయితి మన్ని దేవుణు, వాండ్రు ఏర్‌పాటు కితి వన్ని లోకుర్‌ రెయు పొకాల్‌ వన్నిఙ్‌ పార్దనం కితిఙ, వాండ్రు వరిఙ్‌ నాయం తీర్‌స్‌ఎండ మంజినాండ్రా? వాండ్రు ఆల్‌సెం కినాండ్రా? ");
INSERT INTO kfc_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","నాను మీ వెట వెహ్సిన, వాండ్రు బేగి నాయం తీర్‌స్నాన్. గాని లోకు మరిసి ఆతి నాను మర్‌జి వానివలె, నా ముస్కు నమకం దాన్‌ మన్ని వరిఙ్‌ సుణానా? ");
INSERT INTO kfc_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","సెగొండార్‌ మాపు నీతి మనికాప్‌ ఇజి వరిఙ్‌ వారె గర్ర ఆజి మహివరిఙ్‌ దుసలాడ్ఃతికార్‌ మహార్‌. నన్నివరిఙ్‌ వాండ్రు కతవజ నెస్‌పిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“రిఎర్‌ లోకుర్‌ పార్దనం కిదెఙ్‌ ఇజి దేవుణు గుడిఃదు సొహార్‌. ఒరెన్‌ పరిసయి వాండ్రు ఒరెన్‌ పన్ను పెర్నికాన్. ");
INSERT INTO kfc_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","పరిసయు వాండ్రు సొహాండ్రె, వన్నిలొఇ వాండ్రు ఈహు పార్దనం కితాన్, “ఓ దేవుణు, నాను మహి లోకుర్‌ లెకెండ్‌ ఆఎ. ఆసగొటుఙు లెకెండొ, అనయం కిని వరిలెకెండొ, రంకు బూలాని వరి లెకెండొ ఆఎ. యా పన్ను పెర్ని వన్ని లెకెండ్‌బా ఆఎ. అందెఙె నిఙి వందనమ్‌కు. ");
INSERT INTO kfc_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","నాను వారమ్‌దిఙ్‌ రుండి సుట్కు ఉపాస్‌ మంజిన. నఙి వాజిని విజు దన్నిలొఇబా నిఙి దెసం బాగం సీజిన”, ఇజి పార్దనం కిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","గాని పన్ను పెర్నికాన్‌ దూరం నిహన్. వాండ్రు ఆగాసం దరొట్‌బా బేస్‌ఎండ, వన్ని గుండె కొత్తె ఆజి, “ఓ దేవుణు, నాను పాపం కితిక. నఙి కనికారం తోరిస్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","నాను మీ వెట వెహ్సిన, పరీసయు వన్ని ముస్కు విని పాపమ్‌కునె దేవుణు సెమిస్తాన్. వీండ్రు దేవుణు ముఙాల నీతి నిజాయితి మనికాన్‌ ఇజి తీర్‌సె ఆతండ్రె ఇండ్రొ సొహాన్‌. వన్నిఙ్‌ వాండ్రె పెరికాన్‌ ఇజి ఒడ్ఃబినికాన్‌ ఎయెన్‌బా ఇజ్రికాన్‌ ఆనాన్. వన్నిఙ్‌ వాండ్రె తగిజి ఇజ్రికాన్‌ ఇజి ఒడ్ఃబినికాన్‌ ఎయెన్‌బా పెరికాన్‌ ఆనాన్. ");
INSERT INTO kfc_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","సెగొండార్, యేసుడగ్రు ఇజిరి బయిరిఙ్‌బా తసి మహార్‌. వరిముస్కు వన్నికికు ఇడ్‌దెఙ్‌ ఇజి తత్తార్. అక్క సుడ్ఃతారె సిసూర్‌ వరిఙ్‌ జటిఙ్‌ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","గాని యేసు, కొడొఃరిఙ్‌ వన్ని డగ్రు కూక్తాన్. కూక్తాండ్రె, “యా ఇజ్రి కొడొఃరిఙ్‌ నా డగ్రు రపీర్. వరిఙ్‌అడు కిమాట్. ఎందానిఙ్‌ ఇహిఙ, యా కొడొఃర్‌ లెకెండ్‌ మనికారె దేవుణు ఏలుబడిః కినివెలె మంజినార్. ");
INSERT INTO kfc_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","నిజమె, మీ వెట వెహ్సిన, ఇజ్రి కొడొఃర్‌ నమ్మిని వజ, దేవుణుదిఙ్‌ నమినికార్‌ దేవుణు ఏలుబడిఃదు మజినార్. నమ్మిఇకార్‌ మండ్రెఙ్‌ అట్‌ఎర్”. ");
INSERT INTO kfc_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ఒరెన్‌ అతికారి యేసుఙ్‌ సుడ్ఃజి, “ఓ నెగ్గి బోదకినికి, ఎలాకాలం దేవుణువెట బత్కిని బత్కు దొహ్‌కిద్‌ఇహిఙ, నాను ఇనిక కిదెఙ్‌?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","అందెఙె యేసు, “నాను నెగ్గికాన్‌ ఇజి ఎందనిఙ్‌ నీను వెహ్సిని దేవుణు ఒరెండ్రె నెగ్గికాన్. మరి ఎయెన్‌బా నెగ్గికాన్‌ ఆఎన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","మరి వన్నిఙ్, “రంకు బూలామా. లోకుదిఙ్‌ సప్‌మా. డొఙ కిమ. అబద సాక్సి వెహ్‌మా. నీ యాయ బుబ్బెఙ్‌ గవ్‌రమ్‌దాన్‌ నెగెండ సుడ్ఃఅ ఇని మోసె సిత్తి ఆడ్రెఙ్‌ నెసినిగదె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","వెహ్తిఙ్‌ వాండ్రు, “ఇజ్రివెలెహన్‌ అసి యా విజు వన్కాఙ్‌ లొఙిజిన వాజిన”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","యేసు యాక వెహాండ్రె వన్నిఙ్, “మరి ఉండ్రి బా నీన్‌ కిదెఙ్‌ మనాద్. నిఙి కల్గితిమనికెఙ్‌ విజు పొర్సి అయా డబ్బుఙ్‌ బీద వరిఙ్‌సిఅ. అయావలె దేవుణు మంజిని బాడిఃదు నిఙి సంసారం మంజినాద్. మరి, నీను వాజి నా సిసూడుః ఆఅ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","యా మాటెఙ్‌ వెహిఙ్, వన్ని మొకొం ఇజ్రిక ఆతాద్. ఎందనిఙ్‌ ఇహిఙ, వాండ్రు నండొ ఆస్తిమనికాన్. ");
INSERT INTO kfc_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","యేసు వన్నిఙ్‌ సుడ్ఃజి, “ఆస్తిమనికార్‌ దేవుణు కిని ఏలుబడిఃదిఙ్‌ అడిఃగి మండ్రెఙ్‌ ఎసొనొ కస్టం. ");
INSERT INTO kfc_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ఒరెన్‌ సంసారం మనికాన్‌ దేవుణు కిని ఏలుబడిఃదిఙ్‌ అడిఃగి మన్ని దని ముస్కు ఉండ్రి ఒంటె దొబానం బొరొదాన్‌డుఃగ్‌దెఙ్‌ సూలు ఆనాద్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","అయావలె యా మాటెఙ్‌ వెహికార్, “అహిఙ, దేవుణు రక్సిస్తి లెకెండ్‌ ఎయెర్‌ మండ్రెఙ్‌ అట్నార్‌?”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","అందెఙె యేసు, “లోకు కిదెఙ్‌ అట్‌ఇక దేవుణు కిదెఙ్‌ అట్నాన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","నస్తివలె పేతురు, “ఇదిలో, మాపు మఙి కల్గితి మనికెఙ్‌ విజు డిఃస్తాపె నీ వెట వాతాప్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","అందెఙె యేసు, “ఒరెన్‌ వన్ని ముస్కు దేవుణు ఏలుబడిః కిదెఙ్‌ ఇజి ఇల్లుదిఙ్‌బా ఆల్సిఙ్‌బా, దాద తంబెరిఙ్‌బా అయిసి అప్పొసిరిఙ్‌బా కొడొఃకొక్రాదిఙ్‌బా, డిఃస్తికాన్‌ ఎయెండ్రొ వన్నిఙ్‌ యేలు మరి నండొ కల్గినాద్. వాని కాలమ్‌దు వన్నిఙ్‌ ఎలాకాలం దేవుణు వెట బత్కిని బత్కుదు బా మంజినాద్, ఇజి కసితం నాను మీ వెట వెహ్సిన”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","యేసు వన్ని పన్నెండు మణిసిర్‌ సిసూరిఙ్‌ కూక్సి వరిఙ్‌ ఈహు వెహ్తాన్‌. “ఇదిలో మాటు యెరూసలెమ్‌దు సొన్సినాట్. లోకు మరిసి ఆతి నా వందిఙ్‌ ప్రవక్తరు రాస్తి విజు మాటెఙ్‌ అబ్బె పూర్తి ఆనాద్. ");
INSERT INTO kfc_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","33","యూదురు ఆఇ వరి కీదు నాను ఒపజెపె ఆన. వారు నఙి వెక్రిసి సిగు లాగ్జి, నా ముస్కు పూసి కొరెడెఃఙాణిఙ్‌ డెఃయిజి సప్నార్. మూండ్రి దినమ్‌కాఙ్‌ నాను మర్‌జి నిక్‌పె ఆనాలె. ");
INSERT INTO kfc_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","గాని సిసూరిఙ్‌ యా మాటెఙ లొఇ ఉండ్రిబా అర్దం ఆఏతార్. దిన్ని అర్దం వరిఙ్‌ డాఃఙితాద్. వాండ్రు వెహ్తి సఙతిఙ్‌ వారు నెస్‌ఏతార్. ");
INSERT INTO kfc_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","యేసు యెరికొ పట్నమ్‌దిఙ్‌ డగ్రు వాతివెలె, ఒరెన్‌ గుడ్డి వాండ్రు సరి పడఃకాద్‌ బసి లొసి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","సేన లోకుర్‌ అయా సరిదాన్‌ సొన్సి మహిక, వెహాండ్రె, ఇనిక జర్‌గిజినాద్‌ ఇజి వెనబాతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","వారు వన్నిఙ్, “నజరెతు వాండ్రు ఆతి యేసు, సొన్‌సినాన్”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","వాండ్రు, “ఓ దావీదు మరిసి ఆతి యేసువా, నా ముస్కు కనికారం తోరిస్‌అ”, ఇజి డటం డేల్‌స్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ముఙాలె సొన్సి మహికార్, “అలెఅ”, ఇజి వన్నిఙ్‌ కసితం వెహ్తార్‌. గాని వాండ్రు మరి నండొ దావీదు మరిసి, నా ముస్కు కనికారం ఆఅ”, ఇజి మరి ఒదె డటం డేల్‌స్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","యాక వెహాండ్రె యేసు అబ్బె నిహన్. “అయా గుడ్డి వన్నిఙ్‌ నా డగ్రు తగ్‌అ”, ఇజి వరిఙ్‌ డటం వెహ్తాన్‌. వాండ్రు వాతిఙ్, నాను నిఙి ఇనిక కిదెఙ్‌ ఇజి కోరిజిని?”, ఇజి వన్నిఙ్‌ వెన్‌బాతాన్. దనిఙ్‌ వాండ్రు, “ప్రబువా, నాను బేస్తెఙ్‌ ఇజి ఆస ఆజిన”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","అందెఙె యేసు, “ఇదిలో నీను సూణిలె. నీను నా ముస్కు నమకం ఇడ్తి. అందెఙె నెగెణ్‌ ఆతి”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","వెటనె వాండ్రు బేస్తెఙ్‌ అట్తాన్. వాండ్రు దేవుణుదిఙ్‌ పొగిడిఃజి యేసువెట సొహాన్‌. యాక సుడ్ఃతిఙ్‌ లోకుర్‌ విజెరెబా దేవుణుదిఙ్‌ పొగిడిఃతార్. ");
INSERT INTO kfc_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","యేసు నడిఃజి యెరికొ పట్నమ్‌దు వాతండ్రె అయా సరిదాన్‌ సొన్సి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","జెకయ ఇన్ని ఒరెన్‌ అబ్బె మహాన్‌. వాండ్రు పన్ను పెర్ని వరిఙ్‌ నెయ్‌కి. వాండ్రు గొప్ప ఆస్తిమన్నికాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","యేసుఙ్‌ సుడ్ఃదెఙ్‌ ఇజి వాండ్రు కోరితాన్. గాని నండొ లోకుర్‌ మహిఙ్‌ వన్నిఙ్‌ సుడ్ఃదెఙ్‌ అట్‌ఎతాన్. ఎందనిఙ్‌ ఇహిఙ, వాండ్రు కురికాన్. ");
INSERT INTO kfc_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","యేసు అయా సరిదాన్‌నె వాజి మహిఙ్, వాండ్రు ముఙాల్‌ ఉహ్‌క్సి సొన్సి ఉండ్రి బొడ్డె మరాత్‌ ఎక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","యేసు మరాన్‌ అడిఃగి వాతివెలె, ముస్కు బేసి, “జెకయ, బేగి డిఃగ్‌జి రఅ. నేండ్రు నాను నీ ఇండ్రొ మండ్రెఙ్‌ వెలె”, ఇజి వన్నిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","అందెఙె వాండ్రు గజిబిజి డిగితాండ్రె వన్ని ఇండ్రొ కూక్త ఒతండ్రె సర్దదాన్‌ డగ్రు కిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","యాక సుడ్ఃతారె, లోకుర్‌ విజెరె సణిఙితార్. “వీండ్రు, పాపం కిని వన్ని ఇండ్రొ కూల సొహాన్‌”, ఇజి. ");
INSERT INTO kfc_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","అయావలె జెకయ నిఙితండ్రె, యేసుఙ్‌ ఈహు వెహ్తాన్‌. “ఇదిలో ప్రబువా, యేలు నా ఆస్తి లొఇ సగం బీదవరిఙ్‌ సీజిన. అనయమ్‌దాన్‌ ఎయె బాన్‌బా ఇనిక లొస్తిఙ, నాను దని నాల్గి వంతు మర్‌జి సీన”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","యేసు వన్నిఙ్, “నేండ్రు యా ఇండ్రొణి వరి పాపమ్‌కు దేవుణు సెమిస్త మనాన్. ఎందానిఙ్‌ ఇహిఙ, విన్ని అనిసిఆతి అబ్రాహము దేవుణు ముస్కు నమకం ఇడ్తి వజ, వీండ్రుబా నమకం ఇట్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","లోకు మరిసి ఆతి నాను పాడాఃజి సొని వరిఙ్‌ రెబాజి రక్సిస్తెఙ్‌ వాత”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","లోకుర్‌ యాకెఙ్‌ వెంజి మహార్‌. వాండ్రు యెరూసలెం డగ్రు ఆతాన్. దేవుణు రాజు వజ వెటనె వానాన్‌లె ఇజి లోకుర్‌బా ఒడ్ఃబితార్. అందెఙె వాండ్రు కత వజ వరిఙ్‌ ఈహు నెస్‌పిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ఒరెన్‌ రాజు వజ కుటుమ్‌దికాన్‌ వన్ని దేసమ్‌దు రాజు ఆదెఙ్‌ ఇజి ఉండ్రి దూరం మని దేసెం సొహాన్‌. మరి, మర్‌జి వాదెఙ్‌ ఇజి సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","సొని ముఙాల, వన్ని పణిమణిసిర్‌ లొఇ పది మణిసిర్‌ కూక్సి ఒరెన్‌ ఒరెన్‌ వన్నిఙ్‌ ఉండ్రి మీనా సిత్తాన్. సితాండ్రె, “నాను మర్‌జి వాని దాక బేరం కిజి మండ్రు”, ఇజి వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","గాని వన్ని పట్నమ్‌దికార్‌ వన్నిఙ్‌ ఇస్టం సిలెతాద్. అందెఙె వారు, “వీండ్రు మఙి ఏలుబడిః కిదెఙ్‌ మఙి ఇస్టం సిల్లెద్‌”, ఇజి వన్ని వెనుక పెరి రాజుఙ్‌ కబ్రు పోక్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","అహిఙ్‌బా, వాండ్రు రాజు ఆతాన్. మర్‌జి వాతివెలె, వాండ్రు డబ్బు సిత్తి మణిసిర్, అయా డబుదాన్‌ బేరం కిజి ఇనిక గణస్తార్‌ ఇజి నెస్తెఙ్‌ వరిఙ్‌ కూక్‌పిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","వరిలొఇ మొదొహికాన్‌ వన్ని డగ్రు వాజి, “బాబు, నీను సితి యాబయి రుపాయుఙాణిఙ్, అయ్‌దు వందెఙ్‌ రుపయిఙు వాతె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","వాండ్రు, “నెగ్గి పణిమణిసి నీను నెగెండ కితి. నీను ఇజ్రి పణిదు నమకం దాన్‌మహి. అందెఙె పది పట్నమ్‌క ముస్కు అతికారి ఆఅ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","అయావలె మరి ఒరెన్‌ వాజి, “బాబు, నీను సితి యాబయి రుపాయుఙాణిఙ్‌ రుండి వందెఙ్‌ యాబయి రుపాయ్‌ఙు వాతె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","నీను బా అయ్‌దు పట్నమ్‌క ముస్కు అతికారి ఆఅ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","అయావలె మరి ఒరెన్‌ వాజి, “బాబు, ఇదిలో నీ డబ్బు. నీను నీది ఆఇక ఒనికి. నీను విత్‌ఇకెఙ్‌ కొయ్‌జి ఒనికి. నీను గటి పాణం మనికి. అందెఙె నిఙి తియెల్‌ ఆజి యా డబ్బు రుమాల్‌దు మూట తొహ్‌క్త ఇట్తా మహ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","అందెఙె వాండ్రు వన్నిఙ్‌ వెహ్తాన్‌, “పణిదిఙ్‌ రఇ పణిమణిసి, నీ వెయిది సొంత మాటదిఙ్‌నె, నాను నిఙి తీర్పు తిర్‌సిన. నాను నాది ఆఇదనిఙ్‌ పెర్ని ఒనికాన్‌ ఇజి, నాను విత్‌ఇకెఙ్‌ కొయ్‌జి ఒనికాన్‌ ఇజి నీను నెస్ని గదె. నాను గటి పణం మనికాన్‌ ఇజి నీను నెస్ని. మరి ఎందనిఙ్‌ నా డబ్బు బెంకుదు ఇడ్ఇతి? అహు ఇడ్నిక ఇహిఙ, నాను మర్‌జి వాతివెలె వడ్డిదాన్‌ దొహ్‌క్తాద్‌ మరి. ");
INSERT INTO kfc_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","విన్నిబాన్‌ మన్నిడబ్బు లాగ్జి పది పట్నమ్‌కాఙ్‌ అతికారి ఆతి మొదొహివన్నిఙ్‌ సీదు”, ఇజి పడఃకాద్‌ నిహి మహి వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","వారు, “బాబు, వన్నిఙ్‌ అయ్‌దు వందెఙ్‌ రుపాయ్‌ఙు మనె గదె”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","వెహ్తిఙ్‌ వాండ్రు, “నమిదెఙ్‌ తగ్ని వన్నిఙ్‌ మరి నండొ కల్గినాద్‌లె. గాని నమిదెఙ్ ‌తగ్‌ఇ వన్నిఙ్‌ కల్గితి మన్ని కండెక్‌బా లగ్నాన్, ఇజి నాను మీ వెట వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","మరి, నాను వరి ముస్కు ఏలుబడిః కిదెఙ్‌ ఇస్టం సిల్లి నా పగ ఆతి వరిఙ్‌ ఇబ్బె తగ్‌అ. వరిఙ్‌ నా ఎద్రు కత్తు”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","యేసు యా మాటెఙ్‌ వెహ్తి వెనుక, యెరుసలం సొండ్రెఙ్‌ వరి ముఙాల సొన్సినాన్. ");
INSERT INTO kfc_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","30","ఒలివ గొరొణ్‌ డగ్రు మన్ని బెత్‌సెగె, బెతానియ ఇని నాహ్కఙ్‌ డగ్రు వాతాన్. వాతివెలె వన్ని సిసూర్‌ లొఇ రిఎరిఙ్‌ కూక్సి, “మీ ఎద్రు మన్ని నాటొ సొండ్రు. అబె సొహిఙ సరి, తొహ్‌క్తి మని గాడఃదె పిల్ల తోర్నాద్. దన్నిముస్కు ఎసెఙ్‌బా ఎయెర్‌బా బస్‌ఎరె. దనిఙ్‌ కుత్సి పేర్‌జి తగాట్. ");
INSERT INTO kfc_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ఎయెన్‌బా, “మీరు ఎందనిఙ్‌ దనిఙ్‌ కుత్‌సినిదెర్, ఇజి వెన్‌బాతిఙ, యాకెఙ్‌ ప్రబుఙ్‌ కావాలి, ఇజి వరిఙ్‌ వెహ్తు”, ఇజి వెహ్తండ్రె పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","పోక్తి మనికార్‌ సొన్సి వాండ్రు వరిఙ్‌ వెహ్తి లెకెండ్‌నె సుడ్ఃతార్. ");
INSERT INTO kfc_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","వారు ఆ గాడఃదె పిల్లదిఙ్‌ కుత్సి మహిఙ్, దన్ని ఎజుమానుర్, “మీరు ఎందానిఙ్‌ గాడఃదె పిల్లదిఙ్‌ కుత్సిన్‌దెర్”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","అందెఙె వారు, “యాక ప్రబుఙ్‌ కావాలి”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","వారు యేసుడగ్రు తత్తార్. తతారె, దన్నిముస్కు వరి పాతెఙ్‌ పహ్తర్. యేసుఙ్‌ దని ముస్కు ఎకిస్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","వాండ్రు సొన్సి మహిఙ్, వరి పాతెఙ్‌ సొన్‌సిని సర్దు పహ్తర్. ");
INSERT INTO kfc_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ఒలివ గొరొణ్‌ డిఃగ్ని వాని సర్దు వాతివెలె, వన్ని సిసూర్‌ ని వన్ని వెట మన్ని మంద లోకుర్‌ విజెరె దేవుణుదిఙ్‌ పొగిడిఃతార్. వారు సుడ్ఃతి విజు గొప్ప పణిఙ వందిఙ్‌ సర్దదాన్‌ దేవుణుదిఙ్‌ డటం పొగిడిఃతార్. వారు ఈహు పొగిడిఃతార్. ");
INSERT INTO kfc_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“దేవుణు సితి అతికారమ్‌దాన్‌ వాజిని రాజుఙ్‌ పొగ్‌డెః ఆనికాన్‌. పరలోమ్‌దు సమాదనం మనాద్. ముస్కు మన్ని దేవుణు గొప్ప పెరికాన్”, ");
INSERT INTO kfc_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","నస్తివలె ఆ మంద లొఇ మన్ని సెగొండార్‌ పరిసయ్‌రుఙు, “ఓ బోదకినికి, నీ మంద సిసూర్‌ విజెరిఙ్‌ అలెజి మండ్రు ఇజి డటం వెహ్‌అ”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","అందెఙె వాండ్రు, “వీరు అల్లెత మహిఙ, యా పణుకుఙ్‌ డటం డేల్సి పొగిడిఃజినె ఇజి నాను మీ వెట వెహ్సిన”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","42","వాండ్రు యెరూసలెం పట్నం డగ్రు వాతండ్రె, పట్నమ్‌దిఙ్‌ సుడ్ఃజి అబ్బె మన్ని లోకుర్‌ వందిఙ్‌ అడఃబ‍తాన్. అడఃబతాండ్రె ఈహు వెహ్తాన్‌, “మీరు యా దినమ్‌దు బా సమాదనం ఆని సఙతిఙ నెస్తిఙ మిఙి ఎసొనొ మేలు మంజినాద్. గాని యేలు యాకెఙ్‌ మీ కణకాఙ్‌ తోర్‌ఎండ డాఃఙిత మనె. ");
INSERT INTO kfc_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","దేవుణు మిఙి రక్సిస్తెఙ్‌ మీ డగ్రు వాతి కాలం మీరు నెస్‌ఇదెర్. అందెఙె మీ పగ్‌ఆతికార్‌ మీ సుటులం కోట తొహ్‌క్సి వెల్లి సొన్‌ఎండ, లావు అడ్డుఙ్‌ కినార్. వారు మిఙి, మీ పట్నమ్‌దిఙ్‌ పూర్తి నాసనం కినార్. వారు పణుకు ముస్కు పణుకు మన్‌ఏండ పట్నం పూర్తి నాసనం కిని కాలం వానాద్‌లె. ");
INSERT INTO kfc_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","46","యాకెఙ్‌ వెహ్తండ్రె, వాండ్రు దేవుణు గుడిఃదు సొహాన్‌. అయావలె అబ్బె సవ్‌కారిఙు పొర్సి మహార్‌. వరిఙ్, “నా గుడిః పార్దనం కిదెఙ్‌ ఇడ్తి గుడిః ఇజి దేవుణు మటదు రాస్త మనాద్. గాని మీరు డొఙారి మంజిని సాలం లెకెండ్‌ దనిఙ్‌ కితిదెర్”, ఇజి వెహ్తండ్రె వరిఙ్‌ పేర్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","యేసు రోజు, గుడిఃదు బోదకిజి మహాన్‌. పెరిపుజెరిఙు, యూదురి రూలుఙ్‌ నెస్పిస్నికార్, లోకుర్‌ లొఇ మన్ని పెద్దెల్‌ఙు వన్నిఙ్‌ సప్తెఙ్‌ సుడ్ఃజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","గాని లోకుర్‌ విజెరె వన్ని మాటెఙ్‌ బాగ వెంజి వన్ని సుటులం మహిఙ్, వన్నిఙ్‌ సప్తెఙ్‌ అట్‌ఏతార్. ");
INSERT INTO kfc_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","అయా దినమ్‌కలొఇ ఉండ్రి నాండిఙ్, వాండ్రు దేవుణు గుడిఃదు లోకాఙ్‌ నేర్‌పిసి, సువార్త బోదిసి మహాన్‌. అయావలె పెరి పుజెరిఙు ని యూదురి రూలుఙ్‌ నెస్పిస్నికార్, పెద్దెల్‌ఙ వెట కూడ్ఃజి వన్ని ముస్కు వాతాద్. ");
INSERT INTO kfc_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","నీను ఇనిఅతికారమ్‌దాన్‌ యా పణిఙ్‌ కిజిని? ఎయెన్‌ నిఙి యా అతికారం సితాన్‌? మఙి వెహ్‌అ”, ఇజి వన్నిఙ్‌ వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","అందెఙె వాండ్రు, “నాను బా మిఙి ఉండ్రి మాట వెన్‌బానా. ");
INSERT INTO kfc_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","బాప్తిసం సీదెఙ్‌ అతికారం యోహనుఙ్‌ ఎయె బాణిఙ్‌ వాతాద్‌ దేవుణు బాణిఙ్‌నా లోకు బాణిఙ్‌నా నఙి యేలు వెహ్తు? ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","వరిలొఇ వారు ఈహు వర్గితార్. దేవుణు బాణిఙ్‌ వాతాద్‌ ఇజి మాటు వెహ్తిఙ, ఎందనిఙ్‌ మీరు వన్నిఙ్‌ నమ్‌ఇతిదెర్‌ ఇజి వాండ్రు వెన్‌బానాన్. ");
INSERT INTO kfc_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","లోకురి బాణిఙ్‌ ఇజి మాటు వెహ్తిఙ, లోకుర్‌ విజెరె మఙి పణకాణిఙ్‌ డెఃయినార్. ఎందనిఙ్‌ఇహిఙ, యోహాను, ఒరెన్‌ దేవుణు ప్రవక్త ఇజి విజెరె పూర్తి నమ్మిజినార్. ");
INSERT INTO kfc_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","అందెఙె వారు, “అయాక ఎంబెణిఙ్‌ వాతాదొ మఙి తెలిఎద్”, ఇజి వారు మర్‌జి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","అహిఙ, ఎంబెణి అతికారమ్‌దాన్‌ నాను యా పణిఙ్‌ కిజిన ఇజి నాను బా వెహ్‌ఎ”, ఇజి యేసు వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","మరి, వాండ్రు ఉండ్రి కత వజ లోకురిఙ్‌ నెస్‌పిస్తాన్. “ఒరెన్‌ లోకు ద్రాక్స టోట ఉణుస్తాన్. ఆ టోట సెగొండార్‌ రయ్‌తూఙ తనక సితాన్. సితండ్రె నండొ కాలం మండ్రెఙ్‌ ఉండ్రి దూరం దేసెం సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","పంట కొయ్‌ని కాలమ్‌దు వన్నిఙ్‌ వాని పట్కుఙ వంతు లొసి తగ్‌అ ఇజి ఒరెన్‌ గొతియ వన్నిఙ్‌ రయ్‌తూఙ డగ్రు పోక్తాన్. అయా రయ్‌తూఙ వన్నిఙ్‌ డెఃయితారె వహి కీదాన్‌ మర్‌జి పోక్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","వాండ్రు మరి ఒరెన్‌ గొతియవన్నిఙ్‌ పోక్తాన్. వారు వన్నిఙ్‌బా డెఃయిజి, సిగు కితారె వహి కీదాన్‌ పోక్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","మరి బా, ఒరెన్‌ వన్నిఙ్‌ పోక్తాన్. వారు వన్నిఙ్‌ గాయమ్‌కు ఆని లెకెండ్‌ డెఃయితారె వెల్లి విసీర్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","అయావలె ద్రాక్స టోట ఎజుమాని, “నాను ఇనిక కిదెఙ్‌? నాను లావు ప్రేమిస్ని నా సొంత మరిసిఙ్‌ పోక్న. వారు వన్నిఙ్‌ గవ్‌రం సీనార్‌లెసు”, ఇజి ఒడ్ఃబితాండ్రె పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","గాని పాలి ఆస్తి మన్నికార్‌ వన్నిఙ్‌ సుడ్ఃతారె, “వీండ్రు యా టోటాదిఙ్‌ అక్కు మనికాన్. యా టోట మాది ఆదెఙ్‌ వన్నిఙ్‌ సప్నాట్. రదు”, ఇజి వరి లొఇ వారు వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","అందెఙె వారు వన్నిఙ్‌ ద్రాక్స టోటదాన్‌ వెల్లి పొక్తారె సప్తార్. అహిఙ, ద్రాక్స టోట ఎజుమాని వరిఙ్‌ ఇనిక కినాన్‌? ");
INSERT INTO kfc_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","వాండ్రు వాజి, అయా రయ్‌తూఙ సప్సి మహి వరిఙ్‌ టోట ఒపజెప్నాన్. లోకుర్‌ యాక వెహరె, “ఆ లెకెండ్‌ కిదెఙ్‌ ఆఎద్”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","యేసు వరిఙ్‌ డిటం బేసి ఈహు వెన్‌బాతాన్, “అహిఙ, ఇల్లు తొహ్నికార్‌ నెక్తి పొక్తి పణుకు మూలదిఙ్‌ మూల పణుకు ఆతాద్‌ ఇజి దేవుణు మాటదు రాస్తి మన్ని దన్ని అర్‌దం ఇనిక? ");
INSERT INTO kfc_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","అయా పణుకు ముస్కు అర్ని విజెరె ముకెఙ్‌ ఆనార్. అయా పణుకు ఎయెన్‌ ముస్కు అర్తిఙ, వాండ్రు సింద్‌సింద ఆనాన్”. ");
INSERT INTO kfc_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","యూదురి రూలుఙ్‌ నెస్పిస్నికార్, పెరి పుజెరిఙు, మా వందిఙ్‌నె వీండ్రు కత వజ వెహ్తాన్‌‌ ఇజి నెస్తారె, వెటనె వన్నిఙ్‌ అస్తెఙ్‌ సుడ్ఃతార్. గాని లోకురిఙ్‌ తియెల్‌ ఆతారె, అస్‌ఎతార్. ");
INSERT INTO kfc_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","అందెఙె వారు వన్నిఙ్‌ బాగ గురి కిజి మహార్‌. ఎందానిఙ్‌ఇహిఙ, వాండ్రు వెహ్సిని మాట లొఇ ఇని దనిఙ్‌బా తపు అసి వన్నిఙ్‌ తొహ్సి అతికారిఙ బాన్‌ఒపజెప్తెఙ్. దిని వందిఙ్‌ వారు నండొండారిఙ్‌ పోక్సినార్. యా సెగొండార్‌ మాపు నీతి నిజాయితి మనికాప్‌ ఇజి వేసం కినికార్. నని వరిఙ్‌ వన్ని డగ్రు పోక్తార్. వీరు సొన్సి వన్ని మాటెఙలొఇ తప్ప అస్తెఙ్‌ ఇజి. ");
INSERT INTO kfc_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","వారు వాతారె వన్నిఙ్, “ఓ బోదకినికి, నీను నిజమతిక వెహ్సి బోదిసిని ఇజి మాపు నెస్నాప్. నీను ఇజ్రికార్‌ పెరికార్‌ ఇజి తేడ తొఇకి. దేవుణుదిఙ్‌ ఇస్టం ఆతి నిజమాతి బత్కు వందిఙ్‌ నీను నిజం నెస్పిస్ని ఇజి మాపు నెస్నాప్. ");
INSERT INTO kfc_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","మాపు కయ్‌సరుఙ్‌ పన్ను సీనికెఙ్‌ నాయమ్‌నా? అనయమ్‌నా?”, ఇజి వన్నిఙ్‌ వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","వాండ్రు వరి సెఇ బుద్దిదిఙ్‌ నెస్తాండ్రె వరిఙ్, “ఉండ్రి దినారి కాసు తోరిస్తు. దిని ముస్కు మన్ని బొమ్మ ఎయెది? రాస్తి మన్ని రాంత ఎయెది?”, ఇజి వెన్‌బాతాన్. “కయిసర్‌వి”, ఇహార్‌ వారు. ");
INSERT INTO kfc_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","అందెఙె వాండ్రు, “కయిసరుది, కయ్‌సరుఙ్‌ సీదు. దేవుణుది దేవుణుదిఙ్‌ సీదు”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","వారు అబ్బె మంద ఎద్రు వాండ్రు వెహ్తి మాటదు తపు అస్తెఙ్‌ అట్‌ఎతార్. వాండ్రు మర్‌జి వెహ్తి మాటదిఙ్‌ నండొ బమ్మ ఆతారె అలెతార్. ");
INSERT INTO kfc_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","నస్తివలె సెగొండార్‌ సదుకయ్‌రు యేసు డగ్రు వాతార్. సాతి వెనుక మర్‌జి నిఙ్‌నిక సిల్లెద్‌ ఇజి వారు వెహ్సినార్. వారు వాతారె ఈహు వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ఓ బోదకినికి, ఒరెన్‌ కొడొఃర్‌ సిల్లెండ సాతిఙ. వన్ని తంబెర్సి ఒన్నిఙ్‌ ఇడ్డెః ఆజి కొడొఃర్‌ ఇడ్ఃదెఙ్. ఆహె సాతి వన్ని వందిఙ్‌ కుటుం నిల్‌ప్తెఙ్, ఇజి మోసె మఙి రాస్త సిత్తమనాన్. ");
INSERT INTO kfc_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","31","యేలు సుడ్ఃఅ, ఉండ్రి కాలమ్‌దు, దాదతంబెర్‌సిర్, ఏడు గురు మహార్‌. తొల్‌సుర్‌దికాన్‌ ఉండ్రి బోదెల్‌దిఙ్‌ పెండ్లి ఆతాన్. కొడొఃర్‌ సిల్లెండ సాతాన్. సాతిఙ్, నడిఃపి వాండ్రు దనిఙ్‌ ఇడ్డెః ఆతాన్. కొడొఃర్‌ సిల్లెండ సాతాన్. వెనుక కొగ్రి నడిఃపి దనిఙ్‌ ఇడ్డెః ఆతాన్. కొడొఃర్‌ సిల్లెండ వాండ్రుబ సాతాన్. ఆహె ఏడు గురు బా కొడొఃర్‌ సిల్లెండ సాతార్. ");
INSERT INTO kfc_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","కడిఃవేరిదు ఆ బోదెల్‌బా సాతాద్. ");
INSERT INTO kfc_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","అందెఙె సాతి వరిబాణిఙ్‌ మర్‌జి నిఙ్‌ని వెలె, ఆ బోదెల్‌ ఎయెరిఙ్‌ ఆల్సి ఆనాద్‌? ఆ ఏడు గురుదిఙ్‌బా అది ఆల్సి ఆత మహాద్‌ గదె?”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","అందెఙె యేసు వరిఙ్‌ ఈహు వెహ్తాన్‌, “యా లోకమ్‌ది లోకుర్‌ పెండ్లి ఆజినార్. పెండ్లిదిఙ్‌ సీజినార్. ");
INSERT INTO kfc_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","గాని సాతి వరిబాణిఙ్‌ మర్‌జి నిఙ్‌జి పరలోకమ్‌దు మండ్రెఙ్‌ తగ్నికార్‌ పెండ్లి ఆఏర్. పెండ్లిదిఙ్‌ సిఏర్. ");
INSERT INTO kfc_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ఎంఆనిఙ్‌ ఇహిఙ, వారు మరి సాఏర్. వారు దేవుణు దూతెఙ పోలితికార్. వారు సావుదాన్‌ మర్‌జి నిఙ్‌నార్. అందెఙె వారు దేవుణు కొడొఃర్. ");
INSERT INTO kfc_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","38","సాతికార్‌ నిఙ్‌నార్‌ ఇజి మోసె నెగ్రెండ రుజుప్‌ కిజినాన్. లట కస్ని బాన్‌ మోసె సొహాన్‌. అబ్బె, ‘అబ్రాహము దేవుణు, ఇస్సాకు దేవుణు, యాకోబు దేవుణు ఇజి వాండ్రు దేవుణు ఆతి ప్రబు వందిఙ్‌ వెహ్సినాన్. అయావలె అబ్రాహము, ఇస్సాకు, యాకోబు బత్కిజినార్‌ ఇజి తోర్నాద్. వాండ్రు బత్కితి మన్ని వరిఙ్‌నె దేవుణు. సాతి వరిఙ్‌ దేవుణు ఆఎన్. ఎందనిఙ్‌ ఇహిఙ, వన్ని వెట కూడిఃతి మనికార్‌ విజెరె బత్కిజినార్. ");
INSERT INTO kfc_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","సెగొండార్, యూదురి రూలుఙ్‌ నెస్పిస్నికార్, “బోదకినికి, నీను నెగెండ వెహ్తి”, ఇజి వన్నిఙ్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","వెనుక వారు వన్నిఙ్‌ ఇనికబా వెన్‌బాదెఙ్‌ ఎయెరిఙ్‌బా దయ్‌రం సాల్‌ఏతార్. ");
INSERT INTO kfc_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","యేసు వరివెట ఈహు వెహ్తాన్‌. “క్రీస్తు దావీదు తెగ్గాతికాన్‌ ఇజి ఎలాగ వారు వెహ్సినార్‌? ");
INSERT INTO kfc_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","‘నాను నీ పగాతి వరిఙ్‌ నీ పాదమ్‌క అడిఃగి ఇడ్నిదాక, నీను నా ఉణెర్‌ పడఃకాదు బస్‌అ”, ఇజి ప్రబు నా ప్రబు వెట వెహ్తాన్‌”, ఇజి కీర్తన పుస్తకమ్‌దు దావిదునె వెహ్సినాన్. ");
INSERT INTO kfc_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","దావిదునె వన్నిఙ్, “ప్రబు“ ఇజి కూక్సినాన్. అయావలె వాండ్రు ఎలాగ దావీదు మరిసి ఆనాన్. ");
INSERT INTO kfc_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","46","లోకుర్‌ విజెరె వెంజి మహివలె, యేసు వన్ని సిసూరిఙ్‌ వెహ్తాన్‌, “మీరు యూదురి రూలుఙ్‌ నెస్పిస్నివరి వందిఙ్‌ జాగర్త మండ్రు వారు నిరీ సొక తొడ్ఃగిజి బూలాదెఙ్‌ ఇస్టం ఆతికార్. సత నడిఃమి పెరికార్‌ ఇజి మాడెః ఆదెఙ్‌ కోరిజినార్. యూదురి మీటిఙ్‌ ఇండ్రొ పెరికార్‌ బస్ని బాడిఃదు బస్తెఙ్, విందుద్‌ నెగ్గి బాడిఃదు బస్తెఙ్‌ కోరిజినార్. ");
INSERT INTO kfc_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","వారు రాండి బోదెక్‌ ఇల్కాణికెఙ్‌ అనయమ్‌దాన్‌ లాగ్‌జినార్. మహి వరి ఇంక నెగ్గికాప్‌ ఇజి తోరె ఆదెఙ్‌ నిరీ పార్దనం కిజినార్. దేవుణు వరిఙ్‌ నండొ సిక్స సీనాన్”. ");
INSERT INTO kfc_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","యేసు దేవుణు గుడిఃదు బస్తాండ్రె, సుటులం బేస్తాన్. అయావలె ఆస్తిమన్నికార్‌ సంత పెట్టెదు పెరి సంత అర్ప్‌సినిక సుడ్ఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ఇనిక సిల్లి ఉండ్రి రాండి బోదెలి సంత అర్పస్నిక బా సుడ్ఃతాన్. అది రుండి పయిసెఙ్‌ అర్‌ప్తాద్. ");
INSERT INTO kfc_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","వాండ్రు వరిఙ్, “నాను నిజం మీ వెట వెహ్సిన, యా ఇనిక సిలి రాండి బోదెలి మహి విజెరె ముస్కు లావు అర్‌ప్తాద్. ");
INSERT INTO kfc_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","వారు విజెరె వరిఙ్‌ కల్గితి మన్ని సంసారం బాణిఙ్‌ అర్‌ప్తాద్. గాని అది దనిఙ్‌ సిల్లి బాణిఙ్‌ దనిఙ్‌ బత్కిదెఙ్‌ మనికెఙ్‌ అర్‌ప్తాద్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","అయావలె వన్ని సిసూర్‌లొఇ సెగొండార్, అయా దేవుణు గుడిః వందిఙ్‌ వర్గిజి మహార్‌. నెగ్గి పణుకుదాన్‌ తొహ్‌క్తిక యా గుడిః ఇజి వర్గితార్. సంద సిత్తి నెగ్గి ఇనాయమ్‌కు ఇబ్బె ఇడ్తె మనె. గొప్ప సోకు మనాద్”, ఇజి వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","అయావలె యేసు, “మీరు సుడ్ఃతికెఙ్‌ పణుకు ముస్కు పణుకు మన్‌ఏండ అరె ఆని దినమ్‌కు వానెలె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","అయావలె వారు, “ఓ బోదకినికి, యాకెఙ్‌ ఎసెఙ్‌ జర్గిజినె? యాక జర్గిని కాలం డగ్రు ఆతాద్‌ ఇజి తోరిస్ని గుర్తు ఇనిక?”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","అందెఙె వాండ్రు వెహ్తాన్‌, “మీరు మొసెం కిబె ఆఎండ జాగర్త మండ్రు. ఎందనిఙ్‌ ఇహిఙ నండొండార్‌ నా పేరు అసి వానార్‌లె. వారు, “నానె దేవుణు పోక్తి క్రీస్తు ఇజి, కాలం డగ్రు ఆతాద్‌ ఇజి వెహ్సి వానార్. వరి వెట సొన్మాట్. ");
INSERT INTO kfc_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","మీరు విదెమ్‌కు వందిఙ్, జటిఙ్‌ వందిఙ్‌ వెనివెలె తియెల్‌ ఆమాట్. యాక ముఙాలె జర్గిదెఙ్‌వెలె. గాని ఆక్కర్‌ రోజు వెటనె రెఉ. ");
INSERT INTO kfc_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","మరి వాండ్రు వరిఙ్‌ వెహ్తాన్‌, “లోకుర్‌ ముస్కు లోకుర్, రాజెం ముస్కు రాజెం జటిఙ్‌దిఙ్‌ నిఙ్‌నార్లె. ");
INSERT INTO kfc_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","అబ్బె ఇబ్బె బూమి గొప్ప కద్లినికెఙ్‌ వానెలె. నండొ దేసమ్‌దు కర్రుఙ్, నండొ లోకురిఙ్‌ సెద్రిజి అస్ని కస్టమ్‌కు వానెలె. గొప్ప తియెల్‌ కల్గిస్ని గుర్తుఙ్‌ ఆగాసమ్‌దు పుట్నెలె. ");
INSERT INTO kfc_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","గాని యాకెఙ్‌ జర్గిని ముఙాల, వారు మిఙి అస్నారె, ఇమ్‌సెఙ్‌ కినార్. వారు మిఙి యూదురి మీటిఙ్‌ ఇండ్రొని, జెలిదు ఒపజెప్నార్. రాజుఙ ముఙాల, మహి అతికారిఙ ముఙాల మిఙి తనార్. యాకెఙ్‌ విజు నా ముస్కు నమకం ఇడ్తి వందిఙె జర్గినె. ");
INSERT INTO kfc_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","అయావలె, యాకదె మీరు నా వందిఙ్‌ సువార్త వెహ్తెఙ్‌ నెగ్గి సమయం. ");
INSERT INTO kfc_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","వారు వెన్‌బానివెలె, వరిఙ్‌ ఎలాగ మర్‌జి వెహ్తెఙ్‌ ఇజి ఒడ్ఃబిజి ముఙాల బాద ఆఏ ఇజి తిరుమానం కిజి మన్‌అ. ");
INSERT INTO kfc_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ఎందానిఙ్‌ ఇహిఙ, మీ పగాతికార్‌ ఎయెర్‌బా మిఙి ఎద్రిస్‌ఎండ మంజిని వజ మీరు వెహ్తెఙ్‌మాటెఙ్, గెణం నాను మిఙి సీన. ");
INSERT INTO kfc_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","మిఙి మీ అయిసి అపొసీర్‌బా దాదతంబెర్‌సిర్‌బా కూలెఙ్‌బా అతికారిఙబాన్‌ సిక్స సిబిస్తెఙ్‌ ఒపజెప్నార్. మీ లొఇ సెగొండారిఙ్‌ వారు సప్నార్. ");
INSERT INTO kfc_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","నా ముస్కు నమకం ఇడ్తి వందిఙ్‌ విజెరె మీ ముస్కు పగదాన్‌మంజినార్. ");
INSERT INTO kfc_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","గాని మీరు ఎలాకాలం బత్కినార్. ");
INSERT INTO kfc_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","కస్టమ్‌కు ఓరిసి మండ్రు. అయావలె మీఙి ఎలాకాలం దేవుణు వెట బత్కిని బత్కు దొహ్‌క్నిదెర్. ");
INSERT INTO kfc_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","యెరూసలెం పట్నం సుటులం ఉద్దం కినికార్‌ కూడ్ఃజి మహిక, మీరు సుడ్ఃతిఙ, దన్ని నాసనం డగ్రు ఆతాద్‌ ఇజి మీరు నెస్తెఙ్‌వెలె. ");
INSERT INTO kfc_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","అయావలె నాసనం ఆఏండ మండ్రెఙ్‌ యూదయ దేసమ్‌దు మన్నికార్‌ గొరొకాఙ్‌ ఉహ్‌క్తెఙ్‌వెలె. యెరూసలెం పట్నం నడిఃమి మనికార్‌ వెల్లి ఉహ్‌క్తెఙ్‌వెలె. యెరూసలెం పట్నం వెల్లి మనికార్‌ లొఇ సొండ్రెఙ్‌ ఆఏద్. ");
INSERT INTO kfc_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ముఙాలె రాస్తి మనికెఙ్‌ పూర్తి అదెఙె యా సిక్స దినమ్‌కు. ");
INSERT INTO kfc_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ఆ దినమ్‌కాఙ్‌ పొటాద్‌ మన్ని వన్కాఙ్, పాలు ఉట్‌పిస్ని వన్కాఙ్‌ గొప్ప కస్టం. ఎందనిఙ్‌ ఇహిఙ, యూదయ దేసెం ముస్కు నండొ కస్టమ్‌కు వానెలె. దేవుణు కోపం యా లోకుర్‌ ముస్కు వానాద్‌లె. ");
INSERT INTO kfc_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","వారు కూర్దెఙాణిఙ్‌ సానార్‌లె. సెగొండారిఙ్‌ తొహ్‌క్సి పయ్‌ దేసెమ్‌కాఙ్‌ విజు ఒనార్‌లె. దేవుణుదిఙ్‌ నెస్‌ఇకార్‌ యెరుసలెమ్‌దిఙ్‌ ఏలుబడిః కినార్‌లె. వరి ఏలుబడిః అబ్బె పూర్తి ఆని కాలమ్‌దాక యెరూసలెం వరి అడిఃగి ఆనాద్. ");
INSERT INTO kfc_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","పొద్దుదు, నెలదు, సుక్కెఙదు బమ్మకిని గుర్తుఙ్‌ తోర్‌నెలె. సమ్‌దరమ్‌ది ఉల్కెఙ్‌ గొప్ప గగొల్‌ కిజి వరిఙ్‌ తియెల్‌ కల్గిస్నె. ఆహె బూమిద్‌ మన్ని లోకుర్‌ విజెరె ఇనిక కిదెఙ్‌ ఇజి అర్దం కిఏండ మంజినార్. ");
INSERT INTO kfc_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ఆగసమ్‌దు మన్ని నండొ రకమ్‌కాణికెఙ్‌ కద్‌లినె. అందెఙె లోకమ్‌దు జర్గిని వన్కాఙ్‌ వందిఙ్‌ ఎత్తు కిజి తియెల్‌ ఆజి లోకుర్‌ సానార్. ");
INSERT INTO kfc_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","అయావలె లోకు మరిసి ఆతి నాను మొసొపుదు వానిక వారు సూణార్. గొప్ప అతికారం దాన్‌ గొప్ప జాయ్‌దాన్‌ కూడిఃతి సోకుదాన్‌ మొసొప్‌దు వానిక వారు సూణార్. ");
INSERT INTO kfc_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","యాకెఙ్‌ జర్గిదెఙ్‌ మొదొల్‌స్నివెలె నిల్సి బుర్ర పెర్‌దు. ఎందానిఙ్‌ ఇహిఙ, మీ కస్టమ్‌కాణిఙ్‌ విడుఃదల డగ్రు ఆజినాద్. ");
INSERT INTO kfc_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","వాండ్రు వరిఙ్‌ కతవజ నెస్‌పిస్తాన్. బొడెమరాతిఙ్‌ని విజు మరెకాఙ్‌ సుడ్ఃదు. ");
INSERT INTO kfc_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ఆకెఙ్‌ సెగ్రిసినివెలె, జేట కాలం డగ్రు ఆతాద్‌ ఇజి మీరె సుడ్ఃజి నెసినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","అయా లెకెండ్‌నె, మీరు యా సఙతిఙ్‌ జర్గినిక సూణివెలె, దేవుణు యా లోకమ్‌దిఙ్‌ ఏలుబడిః కిజినిక డగ్రు ఆతాద్‌ ఇజి నెసినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","యా సఙతిఙ్‌ జర్గినిదాక, యా తరమ్‌దికార్‌ సాఏర్, ఇజి నాను మీ వెట కసితం వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ఆగాసం బూమి సిల్లెండ ఆనాద్. గాని నా మాటెఙ్‌ ఎసెఙ్‌బా అయాలెకెండ్‌ సొన్‌ఉ. ");
INSERT INTO kfc_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","మీరు ఉణిజి తింజి మత్తుదాన్‌ మన్‌ఏండ యా లోకమ్‌ది బత్కు వందిఙ్‌ విసారిస్‌ఎండ జాగర్త మండ్రు. సిల్లిఙ, లోకుమరిసిఆతి నాను వాని దినం ఉరి వాతి లెకెండ్‌ వెటనె వానాద్. అందెఙె జాగర్త మండ్రు. ");
INSERT INTO kfc_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","యా లోకమ్‌దు బత్కిజిని లోకుర్‌ విజెరె ముస్కు అయా దినం నెస్‌ఎండ వానాద్. ");
INSERT INTO kfc_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","యా జర్గిదెఙ్‌ మన్ని విజు వన్కాఙ్‌ ఓరిసి మంజిని సత్తు వందిఙ్, లోకు మరిసి ఆతి నా ముఙాలె నిల్‌ని సత్తు వందిఙ్‌ ఎస్తివలె బా పార్దనం కిజి జగర్‌త మండ్రు. ");
INSERT INTO kfc_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","యేసు రోజు దేవుణు గుడిఃదు వేడెఃక నెస్పిసి మహాన్‌. రెయ్‌క ఒలివ గొరొత్‌ మండ్రెఙ్‌ సొన్సి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","లోకుర్‌ విజెరె పెందాల్‌నె, వన్ని మాటెఙ్‌ వెండ్రెఙ్‌ దేవుణు గుడిఃదు వాజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","పస్క ఇని పులాఙ్‌ సిల్లి రొట్టెఙ్‌ తయార్‌కిని పండొయి డగ్రు ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","నస్తివలె పెరిపుజెరిఙు, యూదురి రూలుఙ్‌ నెస్పిస్నికార్‌ యేసుఙ్‌ ఎలాగ సప్తెఙ్‌ ఇజి ఉపాయి సుడ్ఃజి మహార్‌. ఎందానిఙ్‌ ఇహిఙ, వారు లోకురిఙ్‌ తియెల్‌ ఆజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","అయావలె, పన్నెండు మణిసి సిసూర్‌ లొఇ మన్ని ఇస్కరియొతు ఇని యూదెఙ్‌ సయ్తాను అస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","వాండ్రు పెరి పుజెరిఙ, అతికారిఙ బాన్‌ సొహాండ్రె ఎలాగ వన్నిఙ్‌ వరికీదు ఒపజెప్తెఙ్, ఇజి వరివెట వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","అందెఙె వారు సర్‌ద ఆతారె, వన్నిఙ్‌ డబ్బు సీనాప్‌ ఇజి ఒప్పకొటార్. ");
INSERT INTO kfc_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","వాండ్రు దనిఙ్‌ ఒప్పుకొటాన్. మంద లోకుర్‌ సిల్లివెలె వన్నిఙ్‌ వరిఙ్‌ ఒపజెప్తెఙ్‌ తవ్‌కాసం సుడ్ఃజి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","పులాఙ్‌ సిల్లి రొట్టెఙ్‌ తయార్‌కిని పండొయి కిని దినం వాతాద్. ఆ దినమ్‌దు మెండ గొర్రె పిల్లెఙ్‌ పూజ సీజి పస్క బోజనం కిదెఙ్. ");
INSERT INTO kfc_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","అందెఙె యేసు పేతురుఙ్, యోహనుఙ్, “మీరు సొన్సి, మాటు పస్క బోజనం ఉండెఙ్‌ తయార్‌ కిదు”, ఇజి వెహ్తండ్రె వరిఙ్‌ పోక్సినాన్. ");
INSERT INTO kfc_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","వారు, “మాపు ఎంబె తయార్‌ కిదెఙ్‌ఇజి నీను కోరిజిని?”, ఇజి వన్నిఙ్‌ వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","11","అందెఙె యేసు వరిఙ్‌ ఈహు వెహ్తాన్‌. “మీరు పట్నమ్‌దు సొనివెలె, కుండాదు ఏరు పిణ్‌జి ఒరెన్‌ మీ ఎద్రు వానాన్. వాండ్రు సొని ఇండ్రొ వన్ని వెట సొండ్రు. సొన్సి ఆ ఇండ్రొణి యజమానిఙ్, ఈహు వెహ్తు, ‘నాను నా సిసూర్‌ వెట పస్కబోజనం కిదెఙ్‌ గది ఎంబె మనాద్‌ ఇజి బోదిస్నికాన్‌ నిఙి వెన్‌బాజినాన్‌’, ఇజి. ");
INSERT INTO kfc_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","అయావలె ఆ ఎజుమాని విజు తయార్‌ కితి మేడః ముస్కు మన్ని పెరి గది ఉండ్రి తోరిస్నాన్. అబ్బె మీరు తయార్‌ కిదు”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","వారు పట్నమ్‌దు సొహరె, యేసు వరిఙ్‌ వెహ్తివజ విజు సుడ్ఃతార్. వారు పస్కబోజనం తయార్‌ కితార్. ");
INSERT INTO kfc_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","పస్కబోజనం కిదెఙ్‌ టయం ఆతివెలె, వాండ్రు వన్ని పన్నెండు మణిసిర్‌ అపొస్తులు వెట బోజెనమ్‌దిఙ్‌ బస్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","అయావలె వాండ్రు వరిఙ్, “నఙి సప్ని ముఙాల మీ వెట కూడ్ఃజి యా పస్క బోజనం ఉండెఙ్‌ నండొ ఆస ఆత. ");
INSERT INTO kfc_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ఎందానిఙ్‌ ఇహిఙ, యా పస్క బోజెనమ్‌దిఙ్‌ గుర్తు దేవుణు రాజెమ్‌దు పూర్తి ఆనిదాక నాను మరి ఎసెఙ్‌బా ఉణెఏ. ");
INSERT INTO kfc_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","యేసు ద్రాక్సకల్లు మన్ని గిన్న అసి దేవుణుదిఙ్‌ వందనం కితాన్. కితాండ్రె, “లొసి, మీరు సీబాజి ఉండు. ");
INSERT INTO kfc_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ఎందానిఙ్‌ ఇహిఙ, ఏలుదాన్‌ దేవుణు లోకురిఙ్‌ ఏలుబడిః కినిక సూణిదాక నాను మరి ద్రాక్స పట్కు రసం ఉణెఎ ఇజి నాను మీ వెట వెహ్సిన”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","మరి వాండ్రు రొట్టెఅసి దేవుణుదిఙ్‌ వందనం వెహ్సి దనిఙ్‌ ముకెఙ్‌ కిజి వరిఙ్‌ సితాన్. “ఇక మీ వందిఙ్‌ సీజిని నా ఒడొఃల్‌దిఙ్‌ గుర్తు. నఙి ఎత్తు కిదెఙ్‌ యాక కిజి మండ్రు”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","అయలెకెండ్‌నె, బోజనం ఆతి వెన్కా వాండ్రు వరిఙ్‌ ద్రాక్సకల్లు మన్ని గిన్న సితాన్. ‘యా గినెదు మనికెఙ్‌ మీ పాపమ్‌క వందిఙ్‌ వాక్సిని నా నలదిఙ్‌ గుర్తు. యాకదె నా నలదాన్‌ దేవుణు ఇడ్తి కొత్త ఒపుమానం. ");
INSERT INTO kfc_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","గాని నఙి ఒపజెప్నికాన్‌ నావెట బోజెనమ్‌దిఙ్‌ బస్త మనాన్. ");
INSERT INTO kfc_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","దేవుణు ఏర్‌పాటు కితి వజ, లోకు మరిసి ఆతి నాను సానాలె. గాని నఙి ఒపజెప్ని వన్నిఙ్‌ అబాయా గొప్ప కస్టం”, ఇజి వెహ్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","వారు యా పణిఙ్‌ వరి లొఇ ఎయెన్‌ కినాన్‌ ఇజి వరి లొఇ వారె వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","మరి, వరిలొఇ ఎయెన్‌ పెరికాన్‌ ఇజి ఉండ్రి ఇజ్రి గొడఃబ వాతాద్. ");
INSERT INTO kfc_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","అందెఙె యేసు వరిఙ్, “దేవుణుదిఙ్‌ నెస్‌ఇ వరి రాజుర్‌ వరి ముస్కు నండొ అతికారం కిజినార్. వరి ముస్కు అతికారమ్‌దు మనికార్, ‘మాపు లోకురిఙ్‌ కూలెఙ్‌’, ఇజి అనుపె ఆజినార్. ");
INSERT INTO kfc_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","గాని మీరు అయ లెకెండ్‌ మన్‌మాట్. మీలొఇ పెరికాన్‌ ఆతికాన్‌తగిసి ఇజ్రి వన్నిలెకెండ్‌ ఆదెఙ్. నెయ్‌కి సేవ కిని వన్ని లెకెండ్‌ ఆదెఙ్. ");
INSERT INTO kfc_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","సుడ్ఃదు, ఎయెన్‌ పెరికాన్. విందుదు బస్నికాండ్రా, బాట కిజి సీనికాండ్రా? విందుదు బస్నికాండ్రె గదె? గాని నాను మీ నడిఃమి, సేవ కిని వన్ని లెకెండ్‌ మన్న. ");
INSERT INTO kfc_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","నా కస్టమ్‌దు మీరె నా వెట నమ్మకమ్‌దాన్‌ నిహి మహికిదెర్. ");
INSERT INTO kfc_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","నా బుబ్బ వన్ని లోకురిఙ్‌ ఏలుబడిః కిదెఙ్‌ అతికారం నఙి ఒపజెప్తి వజ, నాను మిఙి అయా అతికారం ఒపజెప్సిన. ");
INSERT INTO kfc_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","అందెఙె నాను ఏలుబడిః కినివెలె నా విందుదు నా వెట ఉణిజి తినిదెర్. మీరు రాజుర్‌ బసి మంజిని సింహసనమ్‌కాఙ్‌ బసి ఇస్రాయేలురి పన్నెండు తెగ్గాతి వరిఙ్‌ ఏలుబడిః కినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“ఓ సిమోన్, సిమోన్, ఇదిలో రయ్తు వాండ్రు గింజెఙ జలిస్ని వజ, నీ లొఇ మన్ని నెగ్గికెఙ్‌ నెస్తెఙ్‌ సయ్తాను నిఙి పరిస కినాన్. దిన్నివందిఙ్‌ సెల్‌వ దొహ్‌క్త మనాద్. ");
INSERT INTO kfc_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","గాని సిమోన్, నీను నమకం డిఃస్‌ఎండ మండ్రెఙ్‌ నాను నీ వందిఙ్‌ పార్దనం కిత మన్న. నీను మర్‌జి నా దరిఙ్‌ వానివలె, మహి సిసూరిఙ్‌ వరి నమకం పిరిప్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","అయావలె సిమోను, “ప్రబువా, నీ వెట జెలిదు వాదెఙ్, నీ వెట సాదెఙ్‌బా నాను తయార్‌నె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","దన్నిఙ్‌ యేసు, “పేతురు నాను వెహ్సిన, నేండ్రు కొరు కెరెయెండ ముఙాల నీను నఙి నెస్‌ఎ ఇజి ముసార్‌ వెహ్నిలె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","మరి, వాండ్రు వరిఙ్‌ వెన్‌బాతాన్, “డబ్బు ఇడ్ని ససి, మరి ఉండ్రి ససి, జోడ్కు సిల్లెండ నాను మిఙి పోక్తివెలె, మిఙి ఇనికబా తక్కు ఆతాదా?”, “సిల్లె”, ఇజి వారు వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","“అహిఙ, ఏలు, మిఙి డబ్బు ఇడ్ని ససి మహిఙ, ఆక ఒతెఙ్. అయలెకెండ్‌నె, మరి ఉండ్రి ససి బా ఒతెఙ్. మిఙి ఉండ్రి కూడం సిలిఙ, మీ సొక పొర్సి ఉండ్రి కూడం కొండెఙ్. ");
INSERT INTO kfc_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ఎందానిఙ్‌ ఇహిఙ, ‘జెలిదు మన్ని వరి వెట వన్నిఙ్‌ కుడుఃప్తార్‌’, ఇజి దేవుణు మాటదు రాస్త మనాద్. నాను వెహ్సిన, అయా మాట నావెట పూర్తి ఆదెఙ్‌వెలె. నిజమె నా వందిఙ్‌ రాస్తి మనికెఙ్‌ పూర్తి ఆజినాద్”, ఇజి వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","అయావలె సిసూర్, “ప్రబువా, ఇదిలో ఇబ్బె రుండి కూణమ్‌కు మనె”, ఇజి వెహ్తాన్‌. దనిఙ్‌ వాండ్రు, “ఆకెఙ్‌ ఆనె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","యేసు పట్నం డిఃస్తాండ్రె వన్నిఙ్‌ మన్ని అలవాటు లెకెండ్‌ ఒలివ గొరొత్‌ సొహాన్‌. వన్ని సిసూర్‌ వన్ని వెట సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","అబ్బె సొహిఙ్, వాండ్రు వరిఙ్, “సయ్‌తాన్‌ సికుదు అర్‌పెఎండ పార్దనం కిదు”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","వాండ్రు వరి బాణిఙ్‌ పణుకు విసీర్ని నసొ దూరం సొహాండ్రె, ముణుకుఙ్‌ ఊర్‌జి పార్దనం కిజినాన్. ");
INSERT INTO kfc_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“ఓ బా, నిఙి ఇస్టం ఆతిఙ యా కస్టమ్‌కు నా బణిఙ్‌ లాగ్‌అ. అహిఙ్‌బా నా ఇస్టం ఆఎద్, నీ ఇస్టమ్‌నె ఆపిద్”, ఇజి. ");
INSERT INTO kfc_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","అయావలె దేవుణు మంజిని బాడ్డిః దాన్‌ ఉండ్రి దేవుణు దూత వన్నిఙ్‌ తోరె ఆతండ్రె, వన్నిఙ్‌ ఓదరిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","వాండ్రు ఓరిస్తెఙ్‌ అట్‌ఇ గొప్ప దుకమ్‌దు మహిఙ్, మరి నండొ పార్దనం కితాన్. వన్ని రూణు నల బొటుఙ్‌ లెకెండ్‌ బూమిదు అర్తె. ");
INSERT INTO kfc_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","వాండ్రు పార్దనం కితి నిఙితండ్రె, వెనుక సిసూర్‌ డగ్రు సొహాన్‌. సొహిఙ్‌ వారు దుకం దాన్‌ నిద్ర కిజినిక సుడ్ఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","అందెఙె వాండ్రు వరిఙ్, “ఎందనిఙ్‌ మీరు నిద్ర కిజినిదెర్‌? నిఙ్‌జి, సయ్తాను మిఙి పరిస కిజి తప్పదు అర్‌ప్‌ఏండ పార్దనం కిదు”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","యేసు యా మాటెఙ్‌ వెహ్సి మహిఙ్, నండొ జెనం వాతాద్. పనెండు సిసూర్‌ లొఇ మన్ని యూద ఇనికానె వరి ముఙాల సొహాన్‌. వాండ్రు యేసుఙ్‌ ముదు కిదెఙ్‌ వన్ని డగ్రు వాతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","అయావలె యేసు, “ఓ యూద, ముదు కిజినె, నీను లోకు మరిసి ఆతి నఙి ఒపజెప్నిదా?”, ఇజి వన్నిఙ్‌ వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","యేసు వెట మహి సిసూర్‌ జర్గినికెఙ్‌ సుడ్ఃతిఙ్, వారు, “ప్రబువా, మాపు కూర్దదాన్‌ వరిఙ్‌ కత్తెఙ?”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","వరి లొఇ ఒరెన్‌ విజు పుజెరిఙ ముస్కు పెరి పుజెరి పణిమణిసిఙ్‌ ఉణెర్‌ గిబ్బి తెవు కత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","గాని యేసు, “అలె కిదు”, ఇజి వెహ్తండ్రె, అయా పణిమణిసిఙ్‌ గిబ్బిదిఙ్‌ ముట్తాండ్రె వన్నిఙ్‌ నెగెండ్‌ కిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","యేసు వన్నిఙ్‌ అస్తెఙ్‌ వాతి పెరి పుజెరిఙు, దేవుణు గుడిః అతికారిఙు పెద్దెల్‌ఙ వెట, “నాను డొఙ వాండ్రునా? నఙి అస్తెఙ్‌ పెరి కూడఃమ్‌కు కొణెఙ్‌ అసి మీరు వాతిదెర్‌? ");
INSERT INTO kfc_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","రోజు నాను మీ వెటనె మంజి గుడిఃదు నేర్‌పిస్త గదె. అయావలె మీరు నఙి తొహ్‌ఇతిదెర్. యాకదె నఙి తొహ్‌క్తెఙ్‌ దేవుణు మిఙి సిత్తి సమయం. ఏలు సయ్తాన్‌ అతికారమ్‌దు మనాన్”, ఇజి వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","వారు వన్నిఙ్‌ తొహ్‌క్తారె, విజు పుజెరిఙ ముస్కు మన్ని పెరి పుజెరి ఆతి వన్ని ఇండ్రొ ఒతాన్. పేతురు దూరం దాన్‌ వెన్కా సొన్సి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","వారు డేవ నడిఃమి, సిసు ఎర్‌సి కూడ్ఃజి బసి మహివలె, పేతురు వరి వెట బస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","అయా ఇండ్రొణి పణిమణిసి ఉండ్రి, పేతురు సిసు డగ్ర బస్తిక సుడ్ఃతాద్. వాండ్రు ఎయెన్‌ ఇజి నెస్తెఙ్‌ వన్నిఙ్‌ డిటాఙ్‌ బేస్తాద్. బేస్తాదె, “వీండ్రు బా వన్ని వెట మహాన్‌”, ఇజి అది వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","అందెఙె పేతురు, “ఓ బీ, నాను వన్నిఙ్‌ నెస్‌ఎ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","సణెం వెనుక మరి ఒరెన్‌ వన్నిఙ్‌ సుడ్ఃతాన్. “నీను బా వరి వెట మహికిదె”, ఇజి వెహ్తిఙ్, “బాబు, నాను వన్నిఙ్‌ నెస్‌ఎ”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","డగ్రు ఉండ్రి గంట వెన్కా మరి ఒరెన్‌ కసితం వెహ్తాన్‌, “నిజమె, వీండ్రు బా వన్ని వెట మహాన్‌. ఎందనిఙ్‌ ఇహిఙ, వీండ్రు గలిలియదికానె”, ఇజి. ");
INSERT INTO kfc_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","దన్నిఙ్‌ పేతురు, “ఓ బాబు, నీను వెహ్నిక నఙి తెలిఎద్”, ఇజి వెహ్తాన్‌. వాండ్రు వెహ్సిమహివలె వెటనె కొరు కెరెతాద్. ");
INSERT INTO kfc_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","యేసు వెనుక మహ్తండ్రె పేతురుఙ్‌ డిఃటాఙ్‌ బేస్తాన్. అయావలె ప్రబు వన్నిఙ్, నేండ్రు కొరు కెరెని ముఙాల నీను నఙి నెస్‌ఎ ఇజి ముసార్‌ వెహ్నిలె ఇజి”, వెహ్తి మాట పేతురు ఒడ్ఃబితాన్. ");
INSERT INTO kfc_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","వీండ్రు వెల్లి సొహాండ్రె నండొ దుకం ఆజి అడఃబ‍తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","యేసుఙ్‌ కాప్‌ కిజి మహికార్‌ వన్నిఙ్‌ వెక్రిసి డెఃయిదెఙ్‌ మొదొల్‌స్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","వారు ని కణకెఙ కసెల్‌దాన్‌ తొహ్‌క్తారె, “ఓ ప్రవక్త, వెహ్‌అ, ఎయెన్‌ నిఙి డెఃయితాన్‌ ఇజి”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","వారు వన్నిఙ్‌ దూసిస్ని మరి నండొ మాటెఙ్‌ వన్నిఙ్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","పెందాల్‌ ఆతివెలె, యూదురి పెద్దలుఙ్, పెరి పుజెరిఙు, యూదురి రూలుఙ్‌ నెస్పిస్నికార్‌ విజెరె కూడిఃతార్. యేసుఙ్‌ వరి ముఙాల నిల్‌ప్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","68","వారు వన్నిఙ్, “నీను క్రీస్తు నా, మఙి వెహ్‌అ”, ఇజి వెన్‌బాతార్. అందెఙె యేసు వరిఙ్, “క్రీస్తు ఇజి నాను వెహ్తిఙ, మీరు నమిఇదెర్. నాను మిఙి వెన్‌బాతిఙ మీరు మర్‌జి వెహ్‌ఇదెర్. ");
INSERT INTO kfc_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","గాని ఏలుదాన్, లోకుమరిసిఆతి నాను గొప్ప అతికారం మని దేవుణు ఉణెర్‌ పడఃకాదు బస్నలె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","అయావలె వారు విజెరె, “అహిఙ, నీను దేవుణు మరిసినా?”, ఇజి వన్నిఙ్‌ వెన్‌బాతార్. వెన్‌బాతిఙ్‌ వాండ్రు, “మీరు వెహ్తి లెకెండ్‌నె, నానె దేవుణు మరిసి”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","అందెఙె వారు, “ఎందానిఙ్‌ మఙి మరి రుజుప్‌ వెహ్నికార్. వన్ని వెయ్‌దానె మాట వెహట్”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","అయావలె, యూదురు అతికారిఙు విజెరె నిహరె, యూదయ దేసెం సుడ్ఃజిని రోమ అతికారి ఆతి పిలాతు బాన్‌ వన్నిఙ్‌ ఒత్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","వారు, “వీండ్రు మా లోకుర్‌ నడిఃమి గొడఃబ రేప్సినాన్. రోమ రాజు ఆతి కయ్‌సరుఙ్‌ పన్ను సీమాట్‌ ఇజి వెహ్సినాన్. నానె క్రీస్తు అహిఙ రాజు ఇజి వెహ్సినాన్”, ఇజి వన్ని ముస్కు నేరం మొప్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","అందెఙె పిలాతు యేసుఙ్, “నీను యూదురిఙ్‌ రాజునా?”, ఇజి వెన్‌బాతాన్. వెన్‌బాతిఙ్, “ఒఒ, నీను వెహ్తి వజనె”, ఇజి మర్‌జి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","పిలాతు పెరి పుజెరిఙ వెట మంద లోకుర్‌ వెట, “విని ముస్కు నఙి, ఇని తప్పు బా తోర్‌ఎద్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","గాని వారు, “ఏక ఏక వెహ్తార్‌, “వీండ్రు యూదయ దేసెమ్‌ది లోకుర్‌ విజెరిఙ్‌ వన్ని మాట నెస్పిసి గొడబ రేప్సినాన్. యా పణి గలిలయదు మొదొల్సి ఇబ్బె దాక వాతాన్”, ఇజి. ");
INSERT INTO kfc_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","యాక వెంజి, “వీండ్రు గలిలయదికాండ్రా”, ఇజి పిలాతు వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","యేసు హేరోదు ఏలుబడిః కిని గలీలయ ముటదికాన్‌ ఇజి పిలాతు నెస్తాన్. అందెఙె వాండ్రు వన్నిఙ్‌ హెరొద్‌బాన్‌ పోక్తాన్. అయావలె హెరొదు బా యెరూసలెమ్‌దు మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","హేరోదు యేసుఙ్‌ సుడ్ఃతివెలె నండొ సర్‌ద ఆతాన్. ఎందనిఙ్‌ ఇహిఙ, యేసు వందిఙ్‌ నండొ వెహ మహాన్‌. నండొ కాలమ్‌దాన్‌ వన్నిఙ్‌ సుడ్ఃదెఙ్‌ ఆస ఆజి మహాన్‌. యేసు కిని బమ్మ ఆని పణిఙ సుడ్ఃదెఙ్‌ కోరితాన్. ");
INSERT INTO kfc_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","అందెఙె వాండ్రు నండొ మాటెఙ్‌ వెన్‌బాతాన్. గాని యేసు ఇనికబా మర్‌జి వెహ్‌ఏతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","పెరి పుజెరిఙు, యూదురి రూలుఙ్‌ నెస్పిస్నికార్‌ బాన్‌ నిల్సి, వన్ని ముస్కు డటిసి నేరం మొప్సి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","హేరోదుని వన్ని సయ్‌నమ్‌దికార్‌ వన్నిఙ్‌ వెక్రిసి సెకాల్‌ కితార్. నండొ దర మన్ని గొప్ప ఉండ్రి సొక తొడ్ఃగిస్‌పిస్తాండ్రె పిలాతు డగ్రు మర్‌జి పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","అయా రోజునె పిలాతుని హేరోదు కూలెఙ్‌ ఆతార్. దిని ముఙాలె వారు పగ్‌దాన్‌ మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","14","అయావలె పిలాతు, పెరి పుజెరిఙ, అతికారిఙ, లోకాఙ్‌ కూక్‌పిస్తాండ్రె వరిఙ్, “లోకుర్‌ నడిఃమి గొడబ రేప్సినాన్‌ ఇజి వెహ్సి వినిఙ్‌ మీరు నా బాన్‌ తతిదెర్. మీ ఎద్రు నాను వినిఙ్‌ వెన్‌బాత. గాని మీరు వెహ్తి నేరం ఇనికబా విని లొఇ నఙి తోర్‌ఏత. ");
INSERT INTO kfc_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","అయలెకెండ్‌నె, హెరొదుఙ్‌బా తోర్‌ఎతాన్. వాండ్రు వినిఙ్‌ మా డగ్రు మర్‌జి పోక్తాన్. ఇదిలో వీండ్రు సావుదిఙ్‌ తగితి ఇన్ని పణి బా కిఎన్. ");
INSERT INTO kfc_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","అందెఙె నాను వినిఙ్‌ సిక్స సీజి డిస్న సీన”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(ఏంటు ఏంటు కిని పస్క పండొయిదిఙ్‌ లోకు కోరిపాతి ఒరెన్‌ జెలిదు మన్ని వన్నిఙ్‌ డిఃసి సీదెఙ్‌ పిలాతుఙ్‌ అలవాటు). ");
INSERT INTO kfc_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","గాని లోకుర్‌ విజెరె, “సప్‌అ వన్నిఙ్‌ బరబెఙ్‌ మఙి డిఃసి సిదా”, ఇజి ఉండ్రె లెకెండ్‌ డటం డేడిఃస్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","బరబ్బ పట్నమ్‌దు గొడఃబ రేపిస్తాండ్రె, సెగొండారిఙ్‌ సప్తాన్. అందెఙె వన్నిఙ్‌ జెలిదు ఇట్తా మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","యేసుఙ్‌ డిఃస్తెఙ్‌ కోరిజి పిలాతు మరి లోకురిఙ్‌ నాను వన్నిఙ్‌ డిఃస్తెఙా? ఇజి వెన్‌బాజినాన్. ");
INSERT INTO kfc_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","గాని వారు, “వినిఙ్‌ సిలువాదు కుటిఙాణిఙ్‌ డెఃయిజి సప్‌అ, సిలువాదు కుటిఙాణిఙ్‌ డెఃయిజి సప్‌అ”, ఇజి నండొ గగొల్‌ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ముసార్‌దిఙ్‌ వాండ్రు వరిఙ్, “ఎందానిఙ్‌? ఇన్ని తప్పు వీండ్రు కితాన్‌? సావుదిఙ్‌ తగితి ఇన్ని తప్పు బా నాను విని లొఇ తొఏత. అందెఙె నాను వినిఙ్‌ సిక్స సీజి డిస్న సీన”, ఇజి వెహ్తాన్‌‌ ");
INSERT INTO kfc_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","గాని వారు, “వినిఙ్‌ సప్తెఙ్‌వెలె”, ఇజి మరి మరి డటం డేడిఃస్తార్”. ఆహె వరి గగొల్‌ గెలిస్తాద్. ");
INSERT INTO kfc_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","అందెఙె పిలాతు వారు వెహ్తి వజ జర్గిపిద్‌ ఇజి తీర్పు సిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","పిలాతు వారు లొస్తి వన్నిఙ్‌ డిఃస్త సితాన్. అయా వాండ్రు పట్నమ్‌దు గొడఃబ రేప్‌తి వందిఙ్‌ సెగొండారిఙ్‌ సప్తి వందిఙ్‌ జెలిదు మహాన్‌. యేసుఙ్‌ వారు కోరితివజ కిదెఙ్‌ వరి కీదు ఒపజెప్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","వారు వన్నిఙ్‌ ఒసి మహార్‌. అయావలె, మరి ఉండ్రి దేసెమ్‌ది కురెనియ పట్నమ్‌దికాన్‌ ఆతి సిమోన్‌ ఇనికాన్‌ ఒరెన్‌ యెరూసలెం పట్నం వెల్లిదాన్‌ అయా సరి యెరూసలెం పట్నమ్‌దు వాజి మహాన్‌. వారు వన్నిఙ్‌ అస్తారె, యేసువెట, వన్ని వందిఙ్‌ సిలువ పిండిదెఙ్‌ వన్నిఙ్‌ సితార్. ");
INSERT INTO kfc_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","మంద లోకుర్‌ వన్ని వెన్కా వాజి మహార్‌. వరిలొఇ బోదెక్‌ వన్ని వందిఙ్‌ గుండె కొత్తె ఆజి అడఃబాజి వాజి మహె. ");
INSERT INTO kfc_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","యేసు వరిదరిఙ్‌ మర్‌జి, “యెరుసలెమ్‌ది బీబికండె, మీరు నా వందిఙ్‌ అడఃబామాట్. మీ వందిఙ్‌ని మీ కొడొఃర్‌ వందిఙ్‌ అడఃబాదు. ");
INSERT INTO kfc_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ఎందానిఙ్‌ ఇహిఙ వారు, “గొడ్డు బోదెకాఙ్‌ బా పాలు ఉట్‌పిస్‌ఇ వన్కాఙ్‌ గొప్ప నెగెద్”, ఇజి వెహ్ని దినమ్‌కు వానెలె. ");
INSERT INTO kfc_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","అయావలె వారు, “మా ముస్కు అర్‌అ”, ఇజి గొరొకాఙ్‌ వెట, మఙి పడ్ఃగ్‌అ”, ఇజి మెటెఙ వెట వెహ్నర్‌లె. ");
INSERT INTO kfc_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ఎందానిఙ్‌ ఇహిఙ, “మరాన్‌ పసీఙ్‌ మనివెలె నిసొ బాదెఙ్‌ కితిఙ మరాన్‌ వహ్తిఙ మరి ఎసొ బాద కినారొ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","మరి రిఎర్‌ డొఙారిఙబా వన్నివెట సప్తెఙ్‌ ఒసి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","వారు బుర్ర పిణికి ఇజి కూక్ని బాడిఃదు వాతార్. అబ్బె యేసుఙ్‌ సిలువాదు కుటిఙాణిఙ్‌ డెయ్‌తార్. ఒరెన్‌ వన్నిఙ్‌ ఉణెర్‌ పడఃకాద్‌, మహి వన్నిఙ్‌ డేబర పడఃకాద్‌. సిలువ పొక్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","అయావలె యేసు, “ఓ బా, వీరు కిజినిక ఇనిక ఇజి విరిఙ్‌ తెలిఏద్. అందెఙె విరిఙ్‌ సెమిస్‌అ”, ఇజి పార్దనం కితాన్. వారు వన్ని సొక్కెఙ్‌ సీబె ఆదెఙ్‌ సీటిఙ్‌ పోక్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","లోకుర్‌ నిహరె సుడ్ఃజి మహివలె, అతికారమ్‌దు మనికార్, “వీండ్రు మహి వరిఙ్‌ రక్సిస్తాన్. వీండ్రు క్రీస్తు ఇహిఙ, వినిఙ్‌ వీండ్రె రక్సిసె ఆపిన్”, ఇజి వెహ్సి వెక్రిస్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","37","సయ్‌నమ్‌దికార్‌బా వాతారె, వన్నిఙ్‌ సెకాల్‌ కితార్. వారు వన్నిఙ్‌ సేందుదిక ఉండ్రి ఉండెఙ్‌ సితారె, “నీను యూదురి రాజు ఇహిఙ, నిఙి నీనె రక్సిసె ఆఅ”, ఇజి వెహ్సి సెకాల్‌ కిత్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","“వీండ్రు యూదురిఙ్‌ రాజు’ ఇజి వన్ని ముస్కు మొప్తి నేరం బోర్‌డుదు రాసి సిలువాదు ఇట్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","సిలువాదు డెఃయితి డొఙారిఙ లొఇ ఒరెన్, “నీను క్రీస్తుగదె. నిఙి నీనె రక్సిసె ఆపిన్. మఙి బా రక్సిస్‌అ”, ఇజి వన్నిఙ్‌ దూసిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","41","గాని మహికాన్, “నీను దేవుణుదిఙ్‌ తియెల్‌ ఆఇదా? వన్నిఙ్‌ దొహ్‌క్తి సిక్సనె నిఙి బా దొహ్‌క్త మనాద్. నాయం దానె మఙి సిక్సిస్తార్. ఎందనిఙ్‌ఇహిఙ, మాటు కితి మని పణిదిఙ్‌ తగితి సిక్స సితార్. గాని వీండ్రు ఇని తప్పు బా కిఎన్”, ఇజి వన్నిఙ్‌ గోల కిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","మరి, “యేసు, నీను రాజు ఆజి మర్‌జి వానివలె, నఙి ఒడ్ఃబిఅ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","అందెఙె యేసు, “నిజమె నాను నీ వెట వెహ్సిన, నేండ్రు నీను నా వెట పరలోకమ్‌దు మంజినిలె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","అయావలె సమయం వేడెః పన్నెండు గంటెఙ ఆతాద్. మూండ్రు గంటెఙదాక లోకం విజు సీకటి వాతాద్. పొదు జాయి సిఎతాద్. యెరూసలెం గుడిః తెర మహి పాత ముస్కుహాన్‌ అడ్గి దాక నడిఃమిహాన్‌ రుండి ముకెఙ్‌ కింజితాద్. ");
INSERT INTO kfc_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","యేసు, “ఓ బా, నా పాణం నీ కీదు ఒపజెప్సిన”, ఇజి వెహ్తాన్‌. యా లెకెండ్‌ వెహ్తండ్రె వాండ్రు పాణం డిఃస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","అయావలె సయినమ్‌దివరి అతికారి, జర్గితిక సుడ్ఃతండ్రె, “నిజమె వీండ్రు నీతినిజయిదికాండ్రె”, ఇజి వెహ్సి దేవుణుదిఙ్‌ పొగిడిఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","సుడ్ఃదెఙ్‌ కూడిఃతి వాతి లోకుర్‌ విజెరె జర్గితికెఙ్‌ సుడ్ఃజి, గుండె కొత్త్తె ఆజి మర్‌జి ఇండ్రొ సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","గాని వన్నిఙ్‌ నెల్వ ఆతికార్‌ విజెరె, నెలవాతివరి లొఇ గలిలయదాన్‌ వన్ని వెట వాతి బోదెకు, దూరం నిల్సి యాకెఙ్‌ సుడ్ఃజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","అయావలె యోసేపు ఇనికాన్‌ ఒరెన్‌ మహాన్‌. వాండ్రు యూదయ దేసెమ్‌ది అరిమతియ ఇన్ని పట్నమ్‌దికాన్‌ వాండ్రు సన్‌హద్రి సఙమ్‌దు మన్ని వరిలొఇ పెరికాన్‌ ఒరెన్. వాండ్రు నీతి నిజాయితి మనికాన్. యేసుఙ్‌ సిలువాదు డెఃయిజి సప్తెఙ్‌ యూద పెద్దల్‌ఙ కితి తిరుమానం ఒప్పకొడ్ఃఏతాన్. దేవుణు ఏలుబడిః తోరె ఆనివందిఙ్‌ వాండ్రు ఎద్రు సుడ్ఃజి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","వాండ్రు పిలాతు డగ్రు సొహాండ్రె యేసు పీనుగు లొస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","వాండ్రు, అయా పీన్‌గు సిలువ ముస్కుహాన్‌ డిఃప్తాండ్రె తెల్లాని పాతదాన్‌ సుటిసి సటు పణుకుదిఙ్‌ దొల్‌స్తి దూకిదు ఇట్తాన్. అయా దూకిదు, ముఙాలె ఎయెరిఙ్‌బా ఇడ్ఏరె. ");
INSERT INTO kfc_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","అయా రోజు, విస్రాంతి దినం ముఙాల మన్ని తయార్‌ కిని రోజు. విస్రాంతిదినం మొదొల్‌స్తెఙ్‌ టయం డగ్రు ఆజినాద్. ");
INSERT INTO kfc_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","యేసు వెట గలీలయదాన్‌ వాతి బోదెకు యోసేపు వెట సొహెనె, దూకి ని వన్నిఙ్‌ ఇట్తిక సుడ్ఃతె. ");
INSERT INTO kfc_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","వాండ్రు ఇండ్రొ మహరె, పీన్‌గుదిఙ్‌ రాస్తెఙ్‌ వాసనం నూనె తయార్‌ కితార్. విస్రాంతి దినం మొదొల్‌స్తెఙ్‌ యూదురి రూలుఙ్‌ నమ్మిజి అవిక్‌ రొంబితార్. ");
INSERT INTO kfc_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","వారమ్‌దిఙ్‌ మొదొహి రోజు కోడిఃజామ్‌నె, బోదెకు అవి తయార్‌ కితి వాసనం నూనెఙ్‌ అస్తెనె దూకిదు సొహె. ");
INSERT INTO kfc_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","3","అవిక్‌ అబ్బె వాతిఙ్, దూకి మూక్తి పెరిపణుకు గూర్‌బాతి మహిక సుడ్ఃతె. అవిక్‌ లొఇ డుగితిఙ్‌ యేసు పీనుగు తోర్‌ఏతాద్. ");
INSERT INTO kfc_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","దిన్ని వందిఙ్‌ బమ్మ ఆజి నిహి మహివలె, మిరిస్నివజ తెలాని సొక్కెఙ్‌ తొడ్ఃగితి రిఎర్‌ మొగవారు వన్కా డగ్రు నిహర్. ");
INSERT INTO kfc_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","అవిక్‌ నండొ తియెల్‌ ఆజి ముణుకుఙ్‌ ఊర్‌జి మాడిఃస్తె. ");
INSERT INTO kfc_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","అయావలె అయా మొగవారు వన్కాఙ్, “ఎందనిఙ్‌ మీరు బత్కితి మన్నివన్నిఙ్‌ సాతివరిబాన్‌ రెబాజిన్‌దెర్‌? వాండ్రు ఇబ్బె సిలెన్. నిఙిత మనాన్. మీ వెట గలిలయదు మహివలె వాండ్రు ఇనిక వెహ్తాన్‌‌ ఇజి ఎత్తు కిదు. ");
INSERT INTO kfc_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ఇనిక వెహ్తాన్‌‌ ఇహిఙ, ‘లోకుమరిసి సెఇవరి కీదు ఒపజెపె ఆదెఙ్‌వెలె. సిలువాదు పొకె ఆజి, వాండ్రు సాజి మూండ్రి రోస్కాఙ్‌ నిఙ్‌నాన్‌లె’, ఇజి”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","అయావలె అవిక్‌ యేసువెహ్తి మాట ఒడ్ఃబితె. ");
INSERT INTO kfc_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","దూకిదాన్‌ మహ్తెనె, అబె సుడ్ఃతికెఙ్‌ విజు పదకొండు మణిసి సిసూరిఙ్‌ని మహి వరిఙ్‌ విజెరిఙ్‌ వెహ్తె. ");
INSERT INTO kfc_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","అవిక్‌ ఎయెక్‌ ఇహిఙ, మగ్దలెనె మరి, యోసన, యాకోబుఙ్‌ అయిసి ఆతి మరియ, వన్కావరివెట మహి మరి సెగొండెక్‌ బోదెక్‌ ఇవిక్‌నె జర్గితికెఙ్‌ అపొస్తుడురిఙ్‌ వెహ్తికెఙ్. ");
INSERT INTO kfc_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","గాని వారు బోదెక్‌ వెహ్తి మాటెఙ్‌ నమిఎతార్. ఎందానిఙ్‌ ఇహిఙ, ఆకెఙ్‌ పంబర మాటెఙ్‌ లెకెండ్‌ వారు ఒడ్ఃబితార్. ");
INSERT INTO kfc_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","అహిఙ్‌బా, పేతురు నిఙితండ్రె, దూకిదు ఊహ్‌క్సి సొహాన్‌. వఙితి సుడ్ఃతిఙ్‌ పీన్‌గు సుటిస్తి తెల్లాని పాతెఙ్‌ అర్తి మహికదె సుడ్ఃతాన్. వాండ్రు జర్గితికెఙ్‌ వందిఙ్‌ బమ్మ అజి ఇండ్రొ మర్‌జి సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","అయా రోజునె, సిసూర్‌లొఇ రిఎర్‌ ఎమాయుఇని ఉండ్రి నాటొ సొన్సి మహార్‌. ఎమాయు యెరూసలెమ్‌దాన్‌ పదకొండు కిలో మీటర్‌ దూరం మనాద్. ");
INSERT INTO kfc_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","వారు రిఎర్‌ జర్గితి విజు వందిఙ్‌ వర్గిజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","16","వారు ఆహె వర్గిజి మహిఙ్‌ యేసు వాండ్రె వాజి వరి వెట నడిఃతాన్. వారు వన్నిఙ్‌ సుడ్ఃతార్, గాని వన్నిఙ్‌ గుర్తు అస్తెఙ్‌ అట్‌ఏతార్. ");
INSERT INTO kfc_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","నస్తివలె యేసు, “మీరు నడిఃజి వర్గిజిని యా మాటెఙ్‌ ఇనికెఙ్”, ఇజి వరిఙ్‌ వెన్‌బాతాన్. వారు దుకందాన్‌ మొకొం డిఃప్తారె, కద్లిఎండ నిహర్. ");
INSERT INTO kfc_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","వెనుక వరిలొఇ క్లెయొపా ఇనికాన్‌ ఒరెన్‌ యేసుఙ్, “యెరూసలెమ్‌దు కూల వాతి వరి లొఇ మంజి, సొహి రోస్కాఙ్‌ జర్గితికెఙ్‌ నెస్‌ఇతికి నీను ఒరిదె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“ఇనికెఙ్‌ జర్గితె?”, ఇజి వాండ్రు వెన్‌బాతాన్. దనిఙ్‌ వారు ఈహు వెహ్తార్‌. “నజరెతుదికాన్‌ యేసుఙ్‌ జర్గితి సఙతిఙ వందిఙ్‌ వర్గిజినాప్. వాండ్రు ఒరెన్‌ ప్రవక్త. వాండ్రు కితి గొప్ప పణిఙాణిఙ్‌ వెహ్తి గొప్ప సఙతిఙాణిఙ్‌ దేవుణు వన్నిఙ్‌ ఇస్టం ఆతాన్. లోకుర్‌ విజెరె బా వన్నిఙ్‌ ఇస్టం ఆతారె నమ్మితార్. ");
INSERT INTO kfc_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","మా పెరి పుజెరిఙు, అతికారిఙు, రోమ అతికారి కీదు సావుదిఙ్‌ సిక్స సీదెఙ్‌ వన్నిఙ్‌ ఒపజెప్తార్. వారు వన్నిఙ్‌ సిలువాదు కుటిఙాణిఙ్‌ డెఃయిజి సప్తార్. ");
INSERT INTO kfc_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","వీండ్రునె ఇస్రాయేలు లోకాఙ్‌ డిస్‌పిస్నికాన్‌ ఇజి మాపు ఎద్రు సుడ్ఃజి మహప్. యాకదె ఆఎండ, యా సఙతి జర్గిజి నేహన్‌ మూండ్రి దినమ్‌కు ఆతె. ");
INSERT INTO kfc_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","మరి. మా లొఇ మన్ని సెగొండెక్‌ బోదెక్‌ మఙి నండొ బమ్మ కిబిస్తె. ఎలాగ ఇహిఙ, కోడిఃజామ్‌నె దూకిదు సొహి గాని వన్కాఙ్‌ వన్ని పీన్‌గు తోర్‌ఎతాద్. అవీకు మర్‌జి వాతెనె మఙి ఈహు వెహ్తె. దూతార్‌ వన్కాఙ్‌ తోరె ఆతారె, యేసు బత్కిత మనాన్‌ ఇజి వెహ్తార్‌‌ ఇజి. ");
INSERT INTO kfc_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","మా వెట మనికార్‌ సెగొండార్‌ దూకిదు సొహరె, బోదెక్‌ వెహ్తి వజనె సుడ్ఃతార్. వన్నిఙ్‌ వారు సుడ్ఃఏతార్. ");
INSERT INTO kfc_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","26","అయావలె వాండ్రు వరిఙ్, “బుద్ది సిలికిదెర్, ప్రవక్తరు వెహ్తి మాటెఙ్‌ విజు నమిదెఙ్‌ మిఙి నండొ కస్టం ఆజినాద్. క్రీస్తు యా లెకెండ మాలెఙ్‌ఓరిసి, దేవుణు మంజిని బాడిఃదు వన్నివెట అతికారమ్‌దు మండ్రెఙ్‌గదె?”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","వాండ్రు దేవుణు మాటదు వన్ని వందిఙ్‌ రాస్తి మన్ని దని అర్దం వరిఙ్‌ వెహ్తాన్‌. మోసె రాస్తి పుస్తకమ్‌దాన్‌ మొదొల్సి ప్రవక్తరు విజెరె రాస్తి పుస్తకమ్‌ దాక మన్ని మటెఙ వెహ్సి వాతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","వారు సొన్సిని నారు డగ్రు ఆతిఙ్, వాండ్రు వరిఙ్‌ డిఃసి మరి దూరం సొన్సిని లెకెండ్‌ నడిఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","గాని వారు, “మా వెట మన్‌అ. పొద్దుఆజినాద్. సీకాట్‌ ఆతాద్”, ఇజి వెహ్సి వన్నిఙ్‌ మరి మరి వెహ్తాన్‌. అందెఙె వాండ్రు వరి వెట మండ్రెఙ్‌ సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","వాండ్రు వరి వెట ఉండెఙ్‌ బస్తివెలె, రొటె అస్తాండ్రె దేవుణుదిఙ్‌ వందనమ్‌కు వెహ్సి దనిఙ్‌ రుక్సి వరిఙ్‌ సితాన్‌ ");
INSERT INTO kfc_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","వెటనె వారు వీండ్రు యేసు ఇజి గుర్తు అస్తార్. గాని వాండ్రు వరిఙ్‌ తోర్‌ఏండ ఆతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","అయావలె వారు రిఎర్, “వాండ్రు సర్దు, మా వెట వర్గిజి, దేవుణు మాటెఙ్‌ మఙి నెస్‌పిస్తివెలె, మా మన్సుదు నండొ సర్‌ద వాతి లెకెండ్‌ ఆతాద్‌ గదె”, ఇజి ఒరెన్‌ వెట ఒరెన్‌ వర్గితాన్. ");
INSERT INTO kfc_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","34","వెటనె వారు నిఙితారె, యెరూసలెమ్‌దు సొహార్‌. అబె, వారు పదకొండు మణిసిర్‌ సిసూర్‌ని వరి వెట మహికార్‌ కూడ్ఃజి, “నిజమె, యేసు మర్‌జి నిఙితాన్. సిమొనుఙ్‌తోరె ఆతాన్‌ ఇజి వర్గిజి మహిక సుడ్ఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","అయావలె వారు రిఎర్, సర్దు జర్గితికెఙ్‌ యేసు రొటె రుక్సివెలె వారు ఎలాగ గుర్తు అస్తారొ దన్నివందిఙ్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","వారు వర్గిజి మహివలెనె యేసు వాండ్రె వరి నడిఃమి నిహండ్రె, “సమాదనం కల్గిపిద్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","దూబ తోరితాద్‌ ఇజి ఒడిఃబిజి వారు నండొ తియెల్‌ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","నస్తివలె వాండ్రు, “ఎందానిఙ్‌ మీరు తియెల్‌ ఆజిన్‌దెర్‌? ఎందనిఙ్‌ అనుమానమ్‌కు మీ మన్సుద్‌ వాజినె? ");
INSERT INTO kfc_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","నానె వాండ్రు ఇజి నమిదెఙ్‌ నా కిక్కాఙ్‌ కాల్కాఙ్‌ సుడ్ఃదు. ఎందానిఙ్‌ ఇహిఙ, నఙి మన్ని లెకెండ్‌ దూబదిఙ్‌ ఒడొఃల్‌ మన్‌ఉ. ");
INSERT INTO kfc_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","యా మటెఙ్‌ వెహ్సి వాండ్రు వరిఙ్‌ వన్ని కిక్కు కాల్కు తోరిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","43","అహిఙ్‌బా వారు సర్దదాన్‌ బమ్మదాన్‌ ఇంక నమ్మిఎండ మహార్‌. అందెఙె వాండ్రు వరిఙ్, “తిండ్రెఙ్‌ ఇనికబా మనాదా?”, ఇజి వెన్‌బాతిఙ్, వారు ఉండ్రి సుహ్తి మొయ ముకెఙ్‌ సితార్. వాండ్రు లొస్తాండ్రె వరి ఎద్రు తిహన్. ");
INSERT INTO kfc_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","మరి వాండ్రు వరిఙ్, “నాను మీ వెట మహివలె యాకెఙ్‌నె మీ వెట వెహ్త. ఇనిక ఇహిఙ, మోసె రాస్తి పుస్తకమ్‌దు, ప్రవక్తరు రాస్తి పుస్తకమ్‌దు, కీర్తన పుస్తకమ్‌దు నా వందిఙ్‌ రాస్తి మనికెఙ్‌ విజు పూర్తి ఆదెఙ్‌వెలె”, ఇజి. ");
INSERT INTO kfc_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","వాండ్రు దేవుణు మాటెఙ్‌ అర్దం కిదెఙ్‌ వరిఙ్‌ సాయం కిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","47","వాండ్రు వరిఙ్‌ ఈహు వెహ్తాన్‌. “యా మాటెఙ్‌ రాస్త మనాద్. అయాక ఇనిక ఇహిఙ, క్రీస్తు మాలెఙ్ ఓరిసి, సాజి మూండ్రి రోస్కాణిఙ్‌ సావుదాన్‌ నిఙ్‌నాన్‌లె. యెరూసలెమ్‌దు మొదొల్సి లోకాఙ్‌ విజెరిఙ్‌ వన్ని అతికారమ్‌దాన్‌ ‘పాపమ్‌కు ఒప్పుకొడ్ఃఅ’, దేవుణు సెమిస్నాన్”, ఇని మాట వెహె ఆనాద్‌లె. ");
INSERT INTO kfc_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","మీరు సుడ్ఃతికెఙ్‌ లోకాఙ్‌ వెహ్తెఙ్. ");
INSERT INTO kfc_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","నా బుబ్బ ఒట్టు కితి దేవుణు ఆత్మదిఙ్‌ నాను మిఙి పోక్న. గాని ముస్కుహాన్‌ సత్తు మీ ముస్కు వానిదాక మీరు యెరూసలెం పట్నమ్‌దునె మండ్రు. ");
INSERT INTO kfc_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","పట్నం వెల్లి బెతానియ నారు డగ్రు దాక వాండ్రు వరిఙ్‌ ఒతాన్. వాండ్రు కికు పెహ్తండె, వరిఙ్‌ దీవిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","దీవిసి మహివలె వాండ్రు వరిఙ్‌ డిఃస్తాన్. దేవుణు వన్నిఙ్‌ వాండ్రు మంజిని బాడిఃదు ఒత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","53","వారు వన్నిఙ్‌ మాడిఃస్తారె, నండొ సర్దదాన్‌ యెరూసలెమ్‌దు మర్‌జి వాతార్. వారు డిఃస్‌ఏండ గుడిఃదు మంజి, దేవుణుదిఙ్‌ పొగిడిఃజి మహార్‌.");
INSERT INTO kfc_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","లోకం పుటిస్ఏం‍డ ముఙాలె, దేవుణు వందిఙ్‌ వెహ్సిని వాక్యం ఇనికాన్‌ ఒరెన్‌ మహాన్‌. వాండ్రు దేవుణు వెట మహాన్‌. వాండ్రె దేవుణు. ");
INSERT INTO kfc_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","వాండ్రు లోకం పుటిస్‍ఏండ ముఙాలె, దేవుణువెట మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","విజు వన్నివెట దేవుణు తయార్‌ కితాన్. కల్గితిమన్నిక ఇనికబా వాండ్రు సిల్లెండ కల్గిఏతాద్. ");
INSERT INTO kfc_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","జీవు వన్నిబాన్‌ మనాద్. అయా జీవు లోకురిఙ్‌ జాయి ఆత మనాద్. ");
INSERT INTO kfc_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","జాయ్‌ సీకటిదు జాయ్‌ సీజినాద్. గాని సీకటిదుమన్నికార్‌ జాయ్‌దిఙ్‌ నెస్‌ఏతార్. ");
INSERT INTO kfc_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","దేవుణు బాణిఙ్‌ పోక్తి ఒరెన్‌ మణిసి వాతాన్. వన్ని పేరు యోహాను. ");
INSERT INTO kfc_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","వాండ్రు అయా జాయ్‌వందిఙ్‌ సాస్యం వెహ్తెఙ్‌ ఒరెన్‌ సాసిలెకెండ్‌ వాతాన్. ఎందానిఙ్‌ ఇహిఙ, విన్నిబోద వెంజి లోకుర్‌ విజెరె అయా జాయ్‌దిఙ్‌ నమ్మిదెఙ్‌ వాతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","యొహాను అయా జాయ్‌ ఆఏన్. గాని అయా జాయ్‌వందిఙ్‌ సాక్సం వెహ్తెఙ్‌ వాతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","అయా జాయ్‌నె నిజమాతి జాయ్‌. నిజమాతి జాయ్‌ లోకమ్‌దు వాజి లోకురిఙ్‌ విజెరిఙ్‌ జాయ్‌ సీజినాన్. వాక్యంనె నిజమాతి జాయ్‌. ");
INSERT INTO kfc_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","వాండ్రు లోకమ్‌దు మహాన్‌. లోకమ్‌దు మనికెఙ్‌ విజు వన్నివెటనె దేవుణు తయార్‌ కితాన్. గాని లోకుర్‌ వన్నిఙ్‌ పోలిస్తెఙ్‌ అట్‌ఏతార్. ");
INSERT INTO kfc_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","వాండ్రు వన్ని సొంత దేసమ్‌దు సొహాన్‌. గాని వన్ని సొంత యూదురి లోకుర్‌ వన్నిఙ్‌ డగ్రు కిఏతార్. ");
INSERT INTO kfc_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","వన్నిఙ్‌ ఎసొండార్‌ డగ్రు కిత్తారొ, వారె వన్నిముస్కు నమకం ఇట్తికార్. నన్నివరిఙ్‌ వన్నికొడొఃర్‌ ఆదెఙ్‌ వాండ్రు అతికారం సిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","వారు అప్పొసి వెట పుట్తికార్‌ ఆఏర్. ఒడొఃల్‌ ఆసదాన్‌ పుట్తికార్‌ ఆఏర్. వారు ఎత్తు కితివజ పుట్తికార్‌ ఆఏర్. దేవుణునె వరిఙ్‌ వన్ని కొడొఃర్‌ ఇజి ఇట్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","వాక్యం ఇనికాన్‌ లోకు ఆతాండ్రె మా నడిఃమి బత్కితాన్. వాండ్రు మా ముస్కు వన్నిదయాదర్మం పూర్తి తోరిస్తాన్. వాండ్రు దేవుణు వందిఙ్‌ నిజమాతికెఙ్‌ పూర్తి తోరిస్తాన్. వాండ్రు ఎసొ గొప్పపెరికాన్‌ ఇజి మాపు సుడ్ఃతాప్. బుబ్బ బాణిఙ్‌ వాతి ఒరెండ్రె మరిసి ఆతి గొప్ప పెరివన్నిఙ్‌ సుడ్ఃతాప్. ");
INSERT INTO kfc_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","యోహాను వన్నివందిఙ్‌ సాక్సం వెహ్సినాన్. వాండ్రు లోకురిఙ్, “నా వెన్కా వానికాన్‌ నఙి మిస్తికాన్. ఎందానిఙ్‌ ఇహిఙ, వాండ్రు నాను పుట్‌ఏండ ముఙాల్‌ మన్నికాన్‌ ఇజి నాను వెహ్తికాన్‌ వీండ్రె”, ఇజి డటం డేల్సి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","వన్ని పూర్తి దయాదర్‌మందాన్‌ వాండ్రు మఙి విజెరిఙ్‌ దీవిస్తాన్. కాలమ్‌కు గడఃప్సి మహిఙ్‌బా వాండ్రు మఙి దీవిసినె మంజినాన్. ");
INSERT INTO kfc_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","యూదురిఙ్, రూలుఙ్‌ మోసెవెట దేవుణు సితాన్. వన్ని దయా దర్మం ని వన్ని వందిఙ్‌ నిజమాతి సఙతిఙ్‌ యేసు క్రీస్తు వెట వాతె. ");
INSERT INTO kfc_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ఎయెన్‌బా ఎసెఙ్‌బా దేవుణుదిఙ్‌తొఎన్. గాని అప్పొసి పడఃకాద్‌ మన్ని, దేవుణు వెట సమానం ఆతి, ఒరెండ్రె మరిసినె దేవుణు ఎయెన్‌ ఇజి మఙి తెలివి కిబిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","20","యెరూసలెమ్‌దాన్‌ యూదురి పెద్దలిఙు, యోహాను డగ్రు పుజెరిఙు ని లేవి జాతిదు మన్ని వరిఙ్‌ పోక్తార్. “నీను ఎయెన్‌ ఇజి వెహె ఆజిని?”, ఇజి వెన్‌బాదెఙ్‌ వరిఙ్‌ పోక్తార్. నస్తివలె యోహను ఈహు వరిఙ్‌ సాక్సి వెహ్తాన్‌. “నాను క్రీస్తు ఆఏ”, ఇజి నెగ్రెండ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","అయావలె వారు, మరి నీను ఎయి? నీను ఏలియ ప్రవక్తనా? ఇజి వెన్‌బాతార్. “ఆఏ”, ఇహాన్‌. “నీను మాపు ఎద్రు సూణి ప్రవక్తనా?”, ఇజి వెన్‌బాతిఙ్, “ఆఏ”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","అందెఙె వారు, “నీను ఎయెన్‌? మఙి పోక్తివరిఙ్‌ మర్‌జి వెహ్తెఙ్‌ నీను ఉండ్రి జబాబు సిదా. నీ వందిఙ్‌ నీను ఇన్నిక ఇజి వెహె ఆజిని?”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","దన్నిఙ్‌ యోహాను యెసయ ప్రవక్త వెహ్తివజ వెహ్తాన్‌. “‘ప్రబు వందిఙ్‌ సరితినాఙ్‌ కిదు, ఇజి బిడిఃమ్‌ బూమిదు డేల్‌సినివన్ని లెకెండ్‌ మన్న నాను”. ");
INSERT INTO kfc_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","వన్ని డగ్రు వాతికార్‌ పరిసయ్‌రు పోక్తికార్. అయావలె, అయా పరిసయురుఙ లొఇ సెగొండార్‌ వన్నిఙ్, “నీను క్రీస్తు ఆఇఙ, ఏలియ ప్రవక్త ఆఇఙ, మాపు ఎద్రు సూణి ప్రవక్త ఆఇఙ, మరి ఎందనిఙ్‌ నీను బాప్తిసం సీజిని?”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","దన్నిఙ్‌ వాండ్రు, “నాను ఏరుదాన్‌ బాప్తిసం సీజిన. గాని మరి ఒరెన్‌ మనాన్. వాండ్రు మీ నడిఃమి మనాన్. వన్నిఙ్‌ మీరు పోలిస్‌ఇదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","వాండ్రె నా వెన్కా వాజినికాన్. వన్ని జోడ్ఃకు బేల్టు కూతెఙ్‌బా నాను ఏపటితికాన్‌ ఆఎ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","యొర్దాను ఇన్ని గడ్డ అతాహ పడఃకాద్‌ మన్ని బెతానియ ఇన్ని పట్నమ్‌దు యాకెఙ్‌ విజు జర్గితె. బానె యోహాను బాప్తిసం సీజి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","మర్‌సనాండిఙ్, యేసు వన్నిడగ్రు వాజినిక యోహాను సుడ్ఃతాన్. సుడ్ఃతండ్రె వాండ్రు, “ఇదిలో లోకురి పాపమ్‌క వందిఙ్‌ పూజ ఆదెఙ్‌దేవుణు పోక్తి వన్ని మెండ గొర్రె పిల్ల. వాండ్రు లోకురి పాపమ్‌కు సొన్పిస్నాన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","“నా వెన్కా ఒరెన్‌ వాజినాన్, వాండ్రు నఙి ఇంక మిస్తికాన్. ఎందనిఙ్‌ ఇహిఙ, వాండ్రు నాను పుట్‌ఎండ ముఙాల మన్నికాన్‌ ఇజి నాను ఎయె వందిఙ్‌ వెహ్తనొ వాండ్రె వీండ్రు'. ");
INSERT INTO kfc_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","వీండ్రు ఎయెన్‌ ఇజి నానె నెస్‌ఎత. గాని ఇస్రాయేలు లోకురిఙ్‌ వీండ్రు ఎయెన్‌ ఇజి తెలివి కిని వందిఙె నాను ఏరుదాన్‌ బాప్తిసం సీజి వాత”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","మరి వాండ్రు నెస్తిక ఈహు సాక్సి వెహ్తాన్‌‌: “దేవుణు ఆత్మ ఉండ్రి పారపొటి లెకెండ్‌ ఆగాసమ్‌దాన్‌ డిఃగ్‌జి వాజి వన్నిముస్కు మంజినిక నాను సుడ్ఃత. ");
INSERT INTO kfc_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","నానుబా వన్నిఙ్‌ నెస్‌ఎండ మహ. గాని ఏరుదాన్‌ బాప్తిసం సిఅ ఇజి నఙి వెహ్తి పోక్తి దేవుణునె నఙి వెహ్తాన్‌, ‘దేవుణు ఆత్మ డిఃగ్‌జి ఎయెర్‌ ముస్కు మంజినిక నీను సూణిదొ వాండ్రె దేవుణు ఆత్మదాన్‌ బాప్తిసం సీనాన్‌’, ఇజి. ");
INSERT INTO kfc_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","వెహ్తి లెకెండ్‌ వినిఙ్‌ జర్గితిక నాను సుడ్ఃత. అందెఙె నాను వెహ్సిన, ‘వీండ్రె దేవుణు మరిసి ఇజి’. ");
INSERT INTO kfc_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","మర్‌సనాండిఙ్, మరి, యోహాను వన్ని రిఎర్‌ సిసూర్‌ వెట నిహ మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","అయావలె యేసు అయా సరి సొన్సి మహిఙ్, వన్నిఙ్‌ డిటం సుడ్ఃజి, ‘ఇదిలో, పూజ ఆదెఙ్‌ దేవుణు పోక్తి వన్ని మెండ గొర్రె పిల్ల’, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","అయా రిఎర్‌ సిసూర్‌ వాండ్రు వెహ్తిక వెహరె, యేసు వెన్కా సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","యేసు మహ్తండ్రె, వారు వెన్కా వాజినిక సుడుఃతాన్. సుడ్ఃతాండ్రె వరిఙ్, “మీరు ఇనిక రెబాజినిదెర్‌?”, ఇజి వెన్‌బాతాన్. వారు వన్నిఙ్, “రబ్బి, ఇహిఙ బోదిస్నికాన్, నీను ఎంబె మంజిని?”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","వాండ్రు, “రదు, వాజి సుడ్ఃదు”, ఇహాన్‌. అందెఙె వారు సొహరె, వాండ్రు మంజినిబాన్‌ సుడ్ఃతార్. అయా రోజు వారు వన్నివెట మహార్‌. అయావలె రమారమి పొగల్‌నాల్గి గంటెఙ్‌ ఆత మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","సిమోన్‌ పేతురు తంబెర్సి ఆతి ఆంద్రెయ ఇన్నికానె యోహాను వెహ్తిక వెంజి యేసువెట సొహి రిఏర్‌ లొఇ ఒరెన్. ");
INSERT INTO kfc_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","వాండ్రు వెటనె, వన్నిఅన్నసి సిమోనుఙ్‌ రెబాతాండ్రె, “మాపు మెసయెఙ్‌ సుడ్‌తాప్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","వెహ్తండ్రె వన్నిఙ్‌ యేసు డగ్రు తతాన్. యేసు సిమోనుఙ్‌ సుడ్ఃజి, “నీను యోహాను మరిసి ఆతి సిమొను. నీను కేప ఇజి కూకె ఆనిలె”, ఇజి వెహ్తాన్‌. (గ్రీకు బాసదు అయా మాట పేతురు ఇజి రాస్త మనాద్. దని అర్దం ఇన్నిక ఇహిఙ సటు ఇజి). ");
INSERT INTO kfc_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","మహ్స నాండిఙ్, గలీలయ ముటదు సొండ్రెఙ్‌ ఇజి యేసు ఒడ్ఃబితాన్. అయావలె, వాండ్రు పిలిపుఙ్‌ దసూల్‌ ఆతాతాండ్రె వన్నిఙ్, “నా వెట వాజి నా సిసూడుః ఆఅ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","పిలిపు బెత్‌సెయ్ద ఇని పట్నమ్‌దికాన్. పిలిపు, ఆంద్రెయ, పేతురు వీరు ఉండ్రె పట్నమ్‌దికార్. ");
INSERT INTO kfc_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","పిలిపు నతనయయేలు ఇని వన్నిఙ్‌ రెబాతాండ్రె వన్నిఙ్, “మోసె రాస్తి సితి రూలుదు వాండ్రు రాస్తి మన్ని వన్నిఙ్, ప్రవక్తరు బా రాస్తి మన్ని వన్నిఙ్‌ మాపు దసూల్‌ ఆతాప్. వాండ్రు నజరెతుదికాన్‌ ఆతి యేసు. యోసేపు మరిసి”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","అందెఙె నతనియేలు వన్నిఙ్, “నెగ్గికెఙ్‌ ఇనికబా నజరేతుదాన్‌ వానాదా?”, ఇజి వెన్‌బాతాన్. వన్నిఙ్‌ పిలిపు, “వాజి సుడ్ఃఅ”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","యేసు నతనియేలు వన్ని డగ్రు వాజినిక సుడ్ఃతండ్రె, “ఇవిలొన్‌ నిజమాతి ఇస్రాయేలుదికాన్‌ వాజినాన్. విని లొఇ ఇన్ని సెఇకెఙ్‌బా సిల్లు”, ఇజి వన్ని వందిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","అయావలె నతనియేలు వన్నిఙ్, “నీను ఎలాగ నఙి నెస్ని?”, ఇజి వెన్‌బాతిఙ్‌ యేసు, “పిలిపు నిఙి కూక్‌ఏండ ముఙాలె, నీను బొడెమరాన్‌ అడిఃగి మనిక నాను సుడ్ఃత”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","నతనియెలు, “బోదిస్నికి, నీను దేవుణు మరిసి. నీను ఇస్రాయేలు లోకురి రాజు”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","అందెఙె యేసు వన్నిఙ్, “నీను బొడెమరాన్‌ అడిఃగి మంజినిక నాను సుడ్ఃత ఇజి నాను వెహ్తిఙ్‌నె నీను నమిజిని. దినిఙ్‌ ఇంక మిస్తి నండొ పెరి పణిఙ్‌ నీను సూణిలె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","వాండ్రు వన్నిఙ్, “నాను నిజం వెహ్సిన, ఆగాసం రెయ్‌ ఆజి దేవుణు దూతెఙ్‌ లోకుమరిసిఆతి నా డగ్రు ఎక్సి సొనిక డిగ్‌జి వానిక నీను సూణిలె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","రుండి దినమ్‌కు సొహి వెన్కా, గలీలయ ముటది కానా ఇని పట్నమ్‌దు ఉండ్రి పెండ్లి జర్గితాద్. ");
INSERT INTO kfc_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","యేసు అయ్‌సిబాన్‌ మహాద్‌. యేసుఙ్‌ని వన్ని సిసూర్‌ఙ‌బా ఆ పెండ్లిదు కూక్తార్. ");
INSERT INTO kfc_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ద్రాక్సకల్లు వీజితివెలె, యేసు అయ్‌సి వన్నిఙ్, “ద్రాక్సకల్లు వీజితాద్”, ఇజి వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","అయావలె యేసు, “ఓ యా, దిని వందిఙ్‌ నీను నఙి ఎందనిఙ్‌ పణసిని? నాను ఎయెన్‌ ఇజి తోరె ఆదెఙ్‌ దేవుణు నా వందిఙ్‌ ఏర్‌పాటు కితి వేలా ఇంక రఎదె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","యేసు అయ్‌సి పణికినివరిఙ్, “వాండ్రు మిఙి ఇన్నిక వెహ్తిఙ్‌బా మీరు కిదు”, ఇజి వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","దేవుణుదిఙ్‌ ఇస్టం ఆత్తివజ మండ్రెఙ్‌ యూదురు సుబ్బరం ఆనార్. సుబ్బరం ఆనివందిఙ్‌ వారు నొర్‌బానార్. అయాక వరి ఉండ్రి ఆసారం. ఆహె నొర్‌బాని దన్నివందిఙ్‌ పణుకుదాన్‌ తయార్‌ కితి గోలమ్‌కు మహె. డగ్రు తొంబయ్‌దాన్‌ నూటి ముపయ్‌ లీటర్‌ ఏరు అస్నె. నన్ని గోలమ్‌కు ఆరుబాన్‌ మహె. ");
INSERT INTO kfc_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","యేసు, “అయా గోలెమ్‌కాఙ్‌ ఏరు నిహ్‌తు”, ఇజి పణికిని వరిఙ్‌ వెహ్తాన్‌. వారు నిండ్రు నిహ్తర్. ");
INSERT INTO kfc_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","అయావలె వాండ్రు వరిఙ్, “ముడుక్సి సవ్‌దెరి బాన్‌ ఒతు”, ఇజి వెహ్తాన్‌. వారు అయా లెకెండ్‌ కితార్. ");
INSERT INTO kfc_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","సవ్‌దెరి యెలు ద్రాక్స కడు ఆతి ఏరు రుసి సుడ్ఃతాన్. అయా ద్రాక్సకల్లు ఎమేణిఙ్‌ వాతాదొ ఇజి ఆ ఏరు ముడుక్తి ఒతి పణికిని వరిఙె తెలినా ద్‌గాని సవ్‌దెరిఙ్‌ తెలిఎద్. వాండ్రు పెండ్లి మరిసిఙ్‌ కూక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","కూక్తాండ్రె వన్నిఙ్, “విజెరె కూలెఙ నెగ్గి ద్రాక్సకల్లు ముందాలె సీనార్. లావు ఉటి వెన్కా అడ్డెబెడ్డెదిక సీనార్. గాని నీను ఏలుదాక నెగ్గి ద్రాక్సకల్లునె ఇడ్తి మన్ని”, ఇజి వెహ్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","యాకాదె యేసు కితి మొదొహి బమ్మ ఆతి పణి. యాక గలీలయ ముటది కానా ఇన్ని పట్నమ్‌దు జర్గితాద్. అయా లెకెండ్‌ కిజి, యేసు వాండ్రు గొప్పపెరికాన్‌ ఇజి తోరిస్తాన్. వన్ని సిసూర్‌ వన్ని ముస్కు నమకం ఇట్తార్. ");
INSERT INTO kfc_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","దిని వెన్కా వాండ్రు వన్ని అయిసి, తంబెర్‌సిర్, సిసూర్‌ వెట కపర్‌నహొముదు సొహాన్‌. అబ్బె సెగం దినమ్‌కు మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","యూదురి పస్క పండొయి కిదెఙ్‌ కాలం డగ్రు ఆతాద్. అందెఙె యేసు యెరూసలెమ్‌దు సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","బాన్‌ దేవుణుగుడిఃది అరుఙుదు బేరం కిజిని వరిఙ్‌ వాండ్రు సుడ్ఃతాన్. కోడ్డిఙ్, గొర్రెఙ్, పూజ కిని వందిఙ్‌ పారపొటిఙ్‌ పొర్ని వరిఙ్‌ సుడ్ఃతాన్. పయు దేసెమ్‌ది డబ్బుఙ్‌ మరిసి యూదురి కాసుఙ్‌ సీజిని బేరం కిని వరిఙ్‌బా సుడ్ఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","అయావలె వాండ్రు నాసుదాన్‌ కొర్‌డ కితాండ్రె, కొడ్డిఃఙ, గొర్రెఙ వెట వరిఙ్‌ విజెరిఙ్‌ అరుఙుదాన్‌ పేర్తాన్. డబ్బుమరిసి బేరం కినివరి డబ్బు విజు సెద్రిస్తాండ్రె, వరిబల్లెఙ్‌ మహ్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","పార పొటిఙ్‌ పొర్ని వరివెట, “విన్కాఙ్‌ ఇబ్బెణిఙ్‌ ఒతు. నా బుబ్బ ఇల్లు సత్తలెకెండ్‌ కిమాట్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","నస్తివలె వన్నిసిసూర్, “ఓ దేవుణు, నీ ఇల్లువందిఙ్‌ నఙిమన్ని గొప్ప ఆస, ఉండ్రి సిసులెకెండ్‌ నా లొఇ కస్నాద్”, ఇజి దేవుణు మాటదు రాస్తి మనిక వారు ఒడ్ఃబితార్. ");
INSERT INTO kfc_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","అయావలె యూదురు, యా పణిఙ్‌కిదెఙ్‌ నిఙి ఇని అతికారం మనాద్‌? ఉండ్రి బమ్మ ఆని పణికిజి మఙి తోరిసి అయాక రుజుప్‌ కిఅ’, ఇజి వన్నిఙ్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","“యా గుడిః డెఃయిజి అర్‌ప్తు. మూండ్రి రోస్కాఙ్‌ నాను మరి తొహ్న”, ఇజి యేసు వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","దన్నిఙ్‌ యూదురు, “యా గుడిః తొహ్తెఙ్‌ నలపయ్ ఆరు పంటెఙ్‌ ఆతాద్. నీను మూండ్రి రోస్కాణిఙ్‌ తొహ్నిదా?”, ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","గాని దేవుణుగుడిః వందిఙ్‌ వెహ్తివలె వన్ని ఒడొఃల్‌ వందిఙె వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","వాండ్రు సాతాండ్రె మర్‌జి నిఙితివెనుక, యా లెకెండ్‌ మాట వాండ్రు వెహ్తాన్‌‌ ఇజి సిసూరు ఒడిఃబితార్. అందెఙె దేవుణు మాట వారు నమ్మితార్. యేసు వెహ్తి మాటబా నమ్మితార్. ");
INSERT INTO kfc_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","యేసు పస్కపండొయ్‌దిఙ్‌ యెరూసలెమ్‌దు మహివలె, వాండ్రు కితి బమ్మ ఆతి పణిఙ్‌ సుడ్ఃతారె, నండొండార్‌ వన్నిఙ్‌ నమ్మితార్. ");
INSERT INTO kfc_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","గాని వాండ్రు వరిఙ్‌ వన్నిఙె ఒపజెప్‌ఎతాన్. ఎందనిఙ్‌ ఇహిఙ, వాండ్రు విజెరిఙ్‌ నెస్నాన్. ");
INSERT INTO kfc_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ఎయెర్‌బా వన్నిఙ్‌ లోకుర్‌ వందిఙ్‌ వెహ్తెఙ్‌ అవ్‌సరం సిల్లెద్‌. ఎందానిఙ్‌ ఇహిఙ, వరి మన్సుదు మన్ని ఆలోసనమ్‌కు వాండ్రు నెసినాన్. ");
INSERT INTO kfc_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","యుదురిఙ్‌ అతికారి ఆతి నికొదెము ఇనికాన్‌ ఒరెన్‌ మహాన్‌. వాండ్రు పరిసయిరుఙు లొఇ ఒరెన్. ");
INSERT INTO kfc_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","వాండ్రు ఉండ్రి పొదొయ్‌, యేసుడగ్రు వాతాన్. వాతాండ్రె, “ఓ బోదకినికి, నీను దేవుణు పోక్తి ఒరెన్‌ నెస్‌పిస్నాన్‌ ఇజి మాపు నెసినాప్. దేవుణు ఒరెన్‌ వన్నివెట సిల్లెండ మహిఙ, నీను కిజిని బమ్మఆతి పణిఙ్‌ కిదెఙ్‌ ఎయెన్‌బా అట్‌ఎన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","అందెఙె యేసు వన్నివెట ఈహు వెహ్తాన్‌‌: “నాను నిజమ్‌నె వెహ్సిన, ఒరెన్‌ మరి కొతాఙ్‌ పుట్తిఙనె, దేవుణు ఏలుబడిఃదు మంజినాన్”. ");
INSERT INTO kfc_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","అయావలె నికొదెము, “పిరీతిలోకు ఒరెన్‌ ఎలాగ మరి కొత్తాఙ్‌ పుట్నాన్. వాండ్రు అయిసి పొటాద్‌ సొన్సి మరి ఉండ్రి సుట్కు పుట్తెఙ్‌ అట్‌ఎన్”, ఇజి వెహ్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","యేసు వెహ్తాన్‌, “నాను నిజ్‌నె వెహ్సిన, ఒరెన్‌ బాప్తిసం లాగె ఆఎండ మహిఙ, దేవుణు ఆత్మ బాణిఙ్‌ కొత్త బత్కు దొహ్‌క్‌ఎండ మహిఙ, వాండ్రు దేవుణు ఏలుబడిఃదు మన్‌ఎన్. ");
INSERT INTO kfc_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","యాయ బుబ్బర్‌వెటనె కొడొఃర్‌ కాసినార్. గాని దేవుణు ఆత్మ వెటనె దేవుణు కొడొఃర్‌ ఆనార్. ");
INSERT INTO kfc_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","“నీను మరి కొత్తాఙ్‌ పుట్తెఙ్‌వెలె”, ఇజి నాను వెహ్తి మాటదిఙ్‌ నీను బమ్మ ఆమా. ");
INSERT INTO kfc_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","“గాలి దన్నిఙ్‌ ఇస్టమాతి బాడిద్‌ డెయ్నాద్. నీను దన్నిజాటు వెని గాని అది ఎంబెణిఙ్‌ వాజినాద్, ఎంబె సొన్సినాద్, ఇజి నిఙి తెలిఎద్. అయలెకెండ్‌నె, దేవుణు ఆత్మ ఒరెన్‌ వన్నిఙ్‌ కొత్త బత్కు సీదెఙ్‌ వన్నిఙ్‌ ఇస్టమాతివజ విజు కినాన్. వాండ్రు అయాక ఎలాగ కినాన్‌ ఇజి తెలిఏద్”. ");
INSERT INTO kfc_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","“యాక ఎలాగ జర్గినాద్‌?”, ఇజి నికోదెము యేసుఙ్‌ వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","దనిఙ్‌ యేసు, “ఇస్రాయేలుదు మన్ని బోదిసిని వరిలొఇ తగమాతికి ఒరెన్‌నీను గదె? యాకెఙ్‌ నీను నెస్‌ఇదా? ");
INSERT INTO kfc_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","నాను నిజం వెహ్సిన, మాపు నెస్తికెఙె వెహ్సినాప్, సుడ్ఃతికెఙె వెహ్సినాప్. గాని మీరు అయాకెఙ్‌ నమ్మిఇదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","యా బూమిదు జర్గిని దన్నివందిఙ్‌ నాను మిఙి వెహ్త మన్న. గాని మీరు నమిఇ. అహిఙ, నాను దేవుణు మంజిని బాడిఃదు మన్ని సఙతిఙ వందిఙ్‌ వెహ్తిఙ, మరి మీరు ఎలాగ నమ్మినిదెర్‌? ");
INSERT INTO kfc_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ఎయెన్‌బా ఎసెఙ్‌బా దేవుణు మంజిని బాడిఃదు సొన్‌ఎతార్. దేవుణు మంజిని బాడ్డిః దాన్‌ డిఃగితి వాతి లోకుమరిసి ఆతి నాను ఆఏండ మరి ఎయెన్‌బా దేవుణు మంజిని బాడిఃదు సొన్‌ఏతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","బీడిమ్‌బూమిదు మోసె కంసుదాన్‌ తయార్‌ కితి సరాస్‌దిఙ్‌ పెహ్తి లెకెండ్, లోకు మరిసి ఆతి నాను పెరె ఆనాలె. నా ముస్కు నమకం ఇడ్ని వరిఙ్‌ విజెరిఙ్‌ ఎలాకాలం బత్కిని బత్కు దొహ్‌క్నివందిఙె నాను పెరె ఆదెఙ్‌వెలె. ");
INSERT INTO kfc_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","దేవుణు లోకుర్‌ విజెరిఙ్‌ ఎసొనొ ప్రేమిస్తాన్. అందెఙె వాండ్రు వన్ని ఒరెండ్రె ఒరెన్‌ మరిసిఙ్‌ సాదెఙ్‌ సితాన్. వన్నిఙ్‌ నమినికార్‌ ఎలాకాలం సిసుదు మన్‌ఎండ, ఎలాకాలం దేవుణు వెట మంజిని వందిఙ్‌ వాండ్రు మరిసిఙ్‌ సిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","దేవుణు లోకురిఙ్‌ తీర్పు సీజి సిక్స సీని వందిఙ్‌ ఆఎద్, వాండ్రు వన్ని మరిసిఙ్‌ లోకమ్‌దు పోక్తిక. గాని వాండ్రు వరిఙ్‌ ఎల్లకాలం మన్ని సిక్సదాన్‌ గెల్‌పిస్నివందిఙె పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","మరిసిఙ్‌ నమ్మిని ఎయెరిఙ్‌బా తీర్పు సీజి సిక్స సీనిక సిల్లెద్‌. గాని వన్నిఙ్‌ నమిఇ వరిఙ్‌ ఏలునె దేవుణు తీర్పు సీజి సిక్స సిత మనాద్. ఎందనిఙ్‌ ఇహిఙ, దేవుణు ఒరెండ్రె మరిసిఙ్‌ వారు నమ్మిఏతార్. ");
INSERT INTO kfc_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","జాయ్‌ లోకమ్‌దు వాతమనాద్. గాని లోకుర్‌ జాయ్‌దిఙ్‌ ప్రెమిస్‌ఎండ సీకట్‌దిఙ్‌ ప్రేమిస్నార్. ఎందనిఙ్‌ ఇహిఙ, వారు సెఇ పణిఙ్‌ కిజినార్. యాక సుడ్ఃజినె, లోకురిఙ్‌ దేవుణు తీర్పు సీజి సిక్స సీనాన్. ");
INSERT INTO kfc_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","సెఇ పణిఙ్‌ కిజినికార్‌ విజెరె జాయ్‌దిఙ్‌ ఇస్టం కిఎర్. వారు జాయ్‌దు రెఏర్. ఎందనిఙ్‌ ఇహిఙ, వరి సెఇ పణిఙ్‌ విజు జాయ్‌దు తోర్నె ఇజి తియెల్‌ ఆజినార్. ");
INSERT INTO kfc_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","గాని నిజమాతి పణిఙ్‌ కినికాన్‌ ఎయెన్‌బా జాయ్‌దు వాజినాన్. ఎందానిఙ్‌ ఇహిఙ, వారు కిజిని పణిఙ్‌ విజు దేవుణుదిఙ్‌ లొఙిజి కిజినార్‌ ఇజి జాయ్‌వెల్లి తోర్నాద్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","వెనుక, యేసుని, వన్నిసిసూర్‌ యూదయప్రాతమ్‌దు సొహార్‌. బాన్‌ వాండ్రు వరివెట సగం కాలం గడప్సి, లోకురిఙ్‌ బాప్తిసం సీబిసి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","సలిముడగ్రు అయినొ ఇన్ని బాడిఃదు యోహాను బాప్తిసం సీజి మహాన్‌. ఎందనిఙ్‌ ఇహిఙ, బాన్‌ నండొ ఏరు మహె. లోకుర్‌ వన్ని డగ్రు సొన్సి బాప్తిసం లాగెఆజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","యాక యోహనుఙ్‌ జెలిదు ఒఇ ముఙాల జర్గితాద్. ");
INSERT INTO kfc_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","యోహాను సిసూర్‌ని ఒరెన్‌ యూద వాండ్రు సుబ్రం అని యూదురు రూలు వందిఙ్‌ వెహ్సి గొడఃబ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","వారు యోహానుడగ్రు వాతారె, “బోదకినికి, యొర్దాను గడ్డ అతాల్‌ని వెట ఒరెన్‌ మహాన్‌ గదె. నీను వన్ని వందిఙ్‌ వెహ్తి మన్ని. ఇవిలొన్‌ వాండ్రు ఏలు బాప్తిసం సీజినాన్. లోకుర్‌ విజెరె వన్నిడగ్రు సొన్‌సినార్”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","అందెఙె యోహాను వెహ్తాన్‌, “దేవుణు ఇస్టం కితివజనె ఒరెన్‌ వన్నిబత్కుదు విజు జర్గిజినాద్. ");
INSERT INTO kfc_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","“నాను క్రీస్తు ఆఏ. గాని వన్నిఙ్‌ ఇంక ముఙాల దేవుణు నఙి పోక్తాన్”, ఇజి నాను వెహ్తిక మీరు వెహిదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","పెండ్లి ఆని వన్నిదినె పెండ్లి బోదలి. పెండ్లి దఙడః కూలయెన్‌ వన్నిడగ్రు మంజి వాండ్రు వెహ్తికెఙ్‌ వెంజినాన్. వెహ్సినికెఙ్‌ వెంజినికాదె కూలాయెన్‌ వన్ని సర్‌ద. పెండ్లి దఙడః కూలాయెన్‌ పెండ్లి దఙడఃవెట సర్‌ద ఆని లెకెండ్‌ నా సర్‌ద క్రీస్తువెట పూర్తి ఆజినాద్. ");
INSERT INTO kfc_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","వాండ్రు పెరికాన్‌ ఆదెఙ్‌వలె. నాను ఇజ్రికాన్‌ ఆదెఙ్. ");
INSERT INTO kfc_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","పరలోకమ్‌దాన్‌ వాజినికాన్‌ విజెరి ముస్కు పెరికాన్. యా లోకమ్‌దాన్‌ వాజినికాన్‌ యా లోకమ్‌దికానె. వాండ్రు లోకమ్‌ది సఙతిఙ వందిఙ్‌ వెహ్సినాన్.పరలోకమ్‌దాన్‌ వాజినికాన్‌ విజెరె ముస్కు పెరికాన్. ");
INSERT INTO kfc_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","వాండ్రు సుడ్ఃతి వనకవందిఙ్‌ వెహి వన్కా వందిఙ్‌ వెహ్సినాన్. గాని సెగొండారె వాండ్రు వెహ్సినికెఙ్‌ డగ్రు కినార్. ");
INSERT INTO kfc_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","వన్నిమాట వెంజినికాన్‌ దేవుణు వెహ్సినికెఙ్‌ నిజం ఇజి ముద్ర పొకె ఆజినాన్. ");
INSERT INTO kfc_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","దేవుణు పోక్తాన్‌ దేవుణు మాటనె వర్గిజినాన్. ఎందనిఙ్‌ ఇహిఙ, దేవుణు వన్ని ఆత్మ అంతు సిల్లెండ వన్నిఙ్‌ సీజినాన్. ");
INSERT INTO kfc_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","అప్పొసి మరిసిఙ్‌ ప్రేమిస్నాన్. అందెఙె వాండ్రు వన్నిఙ్‌ విజుదనిఙ్‌ అతికారం సిత్త మనాన్. ");
INSERT INTO kfc_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","మరిసి ముస్కు నమకం ఇడ్తి మన్నివన్నిఙ్‌ ఎలాకాలం దేవుణువెట బత్కిని బత్కు మనాద్. గాని వన్నిఙ్‌ లొఙ్‌ఇ వన్నిఙ్‌ ఎలాకాలం బత్కిని బత్కు సిల్లెద్‌. గాని దేవుణు సిక్స వన్ని ముస్కు ఎలాకాలం మనాద్. ");
INSERT INTO kfc_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","యోహాను ఇంక యేసు నండొండారిఙ్‌ వన్ని వెట కుడుఃప్సినాన్, వరిఙ్‌ బాప్తిసం సీజినాన్‌ ఇజి పరిసయ్‌రు వెహర్. (నిజం ఇన్నిక ఇహిఙ, యేసు ఎయెరిఙ్‌బా బాప్తిసం సిఏతాన్. వన్ని సిసూర్‌నె సితార్‌) ");
INSERT INTO kfc_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ఆహె పరిసయ్‌రు వర్గిజినార్‌ ఇజి యేసునెస్తాండ్రె, వాండ్రు యూదయ ప్రాంతం డిస్తాండ్రె గలీలయ ముటదు మరి మహ్త సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","వాండ్రు సమరియ దేసమ్‌దాఙె సొండ్రెఙ్‌ సరి మనాద్‌. ");
INSERT INTO kfc_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","అందెఙె వాండ్రు సమరియ దేసమ్‌దు మన్ని సుకారు ఇన్ని పట్నమ్‌దు వాతాన్. అయా పట్నం, పూర్‌బమ్‌దు బత్కిజి మహి యాకోబు వన్ని మరిసి యొసెపుఙ్‌ సిత్తి మన్ని బూమిడగ్రు మన్నికాద్. ");
INSERT INTO kfc_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","యాకోబు కారిస్తి నూతి బాన్‌ మహాద్‌. యేసు పయిణం కిజి వందితాండ్రె అయా నూతి డగ్రు బస్తాన్. నస్తివలె, మదెనం. ");
INSERT INTO kfc_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","అయావలె సమరియాతి బోదెలి ఉండ్రి ఏరు ఒతెఙ్‌ బాన్‌ వాతాద్. యేసు దని వెట, “ఏహ్‌ కట్సినాద్. ఏరు బుకెండ్‌ సిదా”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(వన్ని సిసూర్‌ టిండి కొండెఙ్‌ పట్నమ్‌దు సొహ మహార్‌) ");
INSERT INTO kfc_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","అయా బోదెలి వన్నిఙ్, “నీను యూద వాండ్రు. నాను సమరియ బోదెలి. అబాయా, నీను నఙి ఏరు లొస్నిదా”, ఇహాద్‌. (ఎందనిఙ్‌ఇహిఙ, యూదురు సమరియతి వరి వెట కూడ్ఃజి మన్‌ఏర్‌) ");
INSERT INTO kfc_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","అందెఙె యేసు, “నీను దేవుణు సీనిక నెస్ని మంజినిక ఇహిఙ, నిఙి ఏరు లొస్నికాన్‌ ఎయెన్‌ ఇజి నెస్నిమంజినికిహిఙ, నీను వన్నిఙ్‌ దేవుణు సీనిక వెన్‌బాతి మరి. వాండ్రు నిఙి ఎలాకాలం బత్కిస్‌పిస్ని ఏరు సితాన్‌ మరి”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","అయా బోదెలి వన్నిఙ్, “బాబు నూతి నిరీక మనాద్. ఏరు లాగ్‌దెఙ్‌ నిఙి డొక్కు ఇన్నిక సిల్లెద్‌. మరి ఎలాగ నీను బత్కిస్‌పిస్ని ఏరు లాగ్ని? ");
INSERT INTO kfc_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","మా అనిగొగొ యాకోబు యా నూతి మఙి సితాన్. వాండ్రు, వన్ని మరిసిర్, వన్ని కోడ్డిఙ్, గొర్రెఙ్ విజు యా నూతిది ఏరు ఉణిజి మహార్‌. నీను వన్నిఙ్‌ మిస్తికిదా?”, ఇజి వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","14","అందెఙె యేసు, “యా ఏరు ఉణి విజెరిఙ్‌బా మరి ఏహ్కి కట్నాద్. గాని నాను సీని ఏరు ఉణివరిఙ్‌ఎసెఙ్‌బా ఏహ్‌ కట్‌ఎద్. నాను సీని ఏరు బూమిదాన్ సోసిని ఊట ఏరు లెకెండ్‌ వన్ని లొఇ మంజినె. అయాక వన్నిఙ్‌ ఎలాకాలం దేవుణు వెట బత్కిని బత్కు సీజినాద్‌”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","నస్తివలె అది, “బాబు యా ఏరు నఙి సిదా. అయావలె ఎసెఙ్‌బా ఏహ్‌ కట్‌ఎద్. ఇబ్బె వాజి ఏరు లాగ్జి ఒతెఙ్‌ నఙి అవ్‌సరం సిల్లెద్‌”, ఇజి వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","యేసు దనిఙ్, “సొన్సి నీ మాసిఙ్‌ ఇబ్బె కూక్సి తగ్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","దన్నిఙ్‌ అది, “నఙి మాసి సిలెన్”, ఇహాద్‌. అందెఙె యేసు, “నఙి మాసి సిలెన్‌ ఇజి నీను వెహ్తిమాట నిజమ్‌నె. ");
INSERT INTO kfc_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","నిఙి అయ్‌దుగురు మాసీర్‌ మహార్‌. ఏలు నీ వెట మంజినికాన్‌ నీ మాసి ఆఏన్. నీను నిజమ్‌నె వెహ్తి”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","అయావలె అది వెహ్తాద్‌, “బాబు నీను ఒరెన్‌ ప్రవక్త ఇజి నాను నెస్నా. ");
INSERT INTO kfc_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","మా సమరియది అనిగొగొర్‌ యా గొరొత్‌నె దేవుణుదిఙ్‌ పొగ్‌డిఃజి మాడిఃస్తార్. గాని యూదురు ఆతి మీరు, దేవుణుదిఙ్‌ పొగిడిఃజి మాడిఃస్తెఙ్‌ మన్ని బాడ్డి యెరూసలెం ఇజి వెహ్సినిదెర్”. ");
INSERT INTO kfc_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","అందెఙె యేసు, “బీబి, యెరుసలెమ్‌దుబా, యా గొరొత్‌బా బుబ్బ ఆతి దేవుణుదిఙ్‌ మీరు పొగిడిఃజి మాడిఃస్‌ఇ ఉండ్రి కాలం వాజినాద్. నీను నా మాట నమ్మిఅ. ");
INSERT INTO kfc_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ఎలాగ మర్తి వన్నిఙ్‌ పొగిడిఃజి మాడిఃసిన్‌దెర్‌ ఇజి మిఙి తెలిఏద్. గాని యూదురు ఆతి మఙి తెలినాద్, ఎలాగ మర్తి వన్నిఙ్‌ మాపు పొగిడిఃజి మాడిఃస్నాప్‌ ఇజి. ఎందానిఙ్‌ ఇహిఙ, యూదురు బాణిఙె, లోకురిఙ్‌ రక్సిస్నికాన్‌ వాజినాన్. ");
INSERT INTO kfc_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","దేవుణు ఆత్మసత్తుదాన్‌ లోకుర్‌ బుబ్బెఙ్, వరి మన్సు పూర్తి నిజం పొగిడిఃజి మాడిఃసిని ఉండ్రి కాలం వాజినాద్. అయాక ఏలునె మనాద్. ఆహె పొగిడిఃజి మాడిఃసిని వరిఙె దేవుణుదిఙ్‌ ఇస్టం. ");
INSERT INTO kfc_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","దేవుణు, ఆత్మనె. అందెఙె వన్నిఙ్‌ పొగిడిఃజి మాడిఃస్నికార్‌ వన్ని ఆత్మ సత్తుదాన్, నిజం ఇక వన్నిఙ్‌ పొగిడిఃజి మాడిఃస్తెఙ్‌వెలె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","అయా బోదెల్‌ వన్నిఙ్, “క్రీస్తు ఇజి కూకె ఆని మిసియ వానాన్‌ ఇజి నాను నెస్న. వాండ్రు వానివలె మఙి విజు వన్కా వందిఙ్‌ టెటాఙ్‌ వెహ్నన్”, ఇజి వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","అయావలె యేసు, “నీవెట వర్గిజిని నాను వాండ్రె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","అయావలెనె వన్ని సిసూర్‌ మర్‌జి వాతార్. వాండ్రు అయా బోదెల్‌ వెట వర్గిజినిక సుడ్ఃతారె నండొ బమ్మ ఆతార్. గాని నిఙి ఇన్నిక కావాలి ఇజి బా, నీను ఎందనిఙ్‌ దన్నివెట వర్గిజిని ఇజిబా ఎయెర్‌బా వెన్‌బాఏతార్. ");
INSERT INTO kfc_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","అయా బోదెల్‌ దని కుండ డిఃస్తాదె పట్నం సొహాద్. సొహాదె, బాన్‌ మహి లోకురిఙ్, “నాను కితి విజు వన్కా వందిఙ్‌ నఙి వెహ్తి ఒరెన్‌ వన్నిఙ్‌ మీరు వాజి సుడ్ఃదు. వీండ్రు క్రీస్తు ఆఏండ్రా?”, ఇజి వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","వారు పట్నమ్‌దాన్‌ సోతారె వన్నిడగ్రు వాజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","32","అయావలె వన్ని సిసూరు, “మెస్టరు ఇనికబా ఉణామె’, ఇజి వన్నిఙ్‌ బతిమాలితార్. ‘మిఙి తెలిఇ బోజనం నఙి ఉండెఙ్‌ మనాద్”, ఇజి వాండ్రు వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","“వన్నిఙ్‌ బోజనం ఎయెన్‌బా తతాండ్రా?”, ఇజి ఒరెన్‌దిఙ్‌ ఒరెన్‌ సిసూర్‌ వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","యేసు వరిఙ్, “నఙి పోక్తాన్‌ నఙి వెహ్తి పణి పూర్తి కినికాదె నా బోజనం లెకెండ్‌ మనాద్. ");
INSERT INTO kfc_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","‘నాల్గి నెల్లెఙ్‌ మనాద్‌ పంట కొయ్‌ని కాలం’, ఇజి మీరు వెహ్నిదెర్‌గదె. నాను మిఙి వెహ్సిన, మీ కణుకు పెర్జి మడిఃఙ సుడ్ఃదు. ఆకెఙ్‌ సోపాతెనె పండితె మన్నె. ");
INSERT INTO kfc_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","నా మాటెఙ్‌ వెండ్రెఙ్‌ తయార్‌ ఆతి మన్ని యా లోకురిఙ్‌ సుడ్ఃఅ. కొయిదెఙ్‌ సోపాతి మన్ని మడిఃఙ లెకెండ్‌ మనార్. వరిఙ్‌ ఎలాకాలం దేవుణు వెట బత్కిని బత్కు దొహ్‌క్నాద్‌ ఇజి నా డగ్రు తని వన్నిఙ్‌ లాబం మనాద్. విత్నికాన్‌ని కొయినికాన్‌ రిఎర్‌ కూడ్ఃజి సర్‌ద ఆని లెకెండ్‌ వీండ్రు ని విని ముఙాల లోకురిఙ్‌ సువార్త వెహ్తికార్‌ రిఎర్‌ కూడ్ఃజి సర్‌ద ఆనార్. ");
INSERT INTO kfc_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","‘విత్నికాన్‌ ఒరెన్. కొయినికాన్‌ మరి ఒరెన్‌’, ఇజి వెహ్నిక నిజమ్‌నె. ");
INSERT INTO kfc_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","మహికార్‌ కస్టబడిఃజి పణి కితార్. మీరు కిఇతిదెర్. వారు కస్టపడిఃజి కితి పణిది లాబం లాగ్‌దెఙ్‌ నాను మిఙి పోక్సిన. ");
INSERT INTO kfc_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","“నాను కితి విజు వన్కా వందిఙ్‌ వాండ్రు నఙి వెహ్తాన్‌”, ఇజి అయా బోదెలి మాట వెహరె, అయా పట్నమ్‌ది నండొ సమరియదికార్‌ యేసుఙ్‌ నమ్మితార్. ");
INSERT INTO kfc_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","అందెఙె సమరియదికార్‌ వన్ని డగ్రు వాతారె, “మా డగ్రు మన్‌అ ఇజి వన్నిఙ్‌ బతిమాలితార్. అందెఙె వాండ్రు అబె రుండి రోస్కు మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","వన్ని మాట వెహరె, మరి నండొండార్‌ వన్నిఙ్‌ నమ్మితార్. ");
INSERT INTO kfc_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","వారు అయా బోదెల్‌దిఙ్, “నీను వెహ్తి దనిదాన్‌ ఆఎద్‌ మాపు యేలు నమిజినిక. గాని విని మాటెఙ్‌ మాపు వెహప్. నిజమె, వీండ్రె లోకురిఙ్‌ పాపమ్‌కాఙ్‌ రక్సిస్నికాన్‌ ఇజి మాపు నెసినాప్. అందెఙె మాపు వినిఙ్‌ నమ్మిజినాప్”, ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","రుండి రోస్కు బాన్‌ మహి వెన్కా, యేసు సమరియదాన్‌ గలీలయ ప్రాంతమ్‌దు సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(యేసునె వెహ్త మహాన్‌, “ఒరెన్‌ ప్రవక్తెఙ్‌ వన్నిసొంత ప్రాంతమ్‌దు ఎయెర్‌బా గవ్‌రం సిఎర్‌”, ఇజి) ");
INSERT INTO kfc_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","వాండ్రు గలీలయదు వాతివలె, గలీలియదికార్‌ వన్నిఙ్‌ డగ్రు కితార్. ఎందనిఙ్‌ఇహిఙ, వారుబా పస్క పండొయిదిఙ్‌ యెరూసలెమ్‌దు సొహ మహరె, వాండ్రు అబ్బె కితి విజు పణిఙ్‌ సుడ్ఃత‌ మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","వాండ్రు గలీలియది కానా ఇన్ని పట్నమ్‌దు మరి వాతాన్. బానె వాండ్రు ఏరుదిఙ్‌ ద్రాక్స కడు కితాన్. అబ్బె ఒరెన్‌ గవర్‌మెంటు అతికారి మహాన్‌. వన్ని మరిసి కపర్‌నహొముదు కస్టం అర్త మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","యేసు యుదయదాన్‌ గలీలయదు వాతాన్‌ ఇజి వెహివెలె వాండ్రు యేసు డగ్రు వాతాన్. వాతండ్రె, “నా మరిన్‌ సాదెఙ్‌ డగ్రు ఆత మనాన్. అందెఙె నీను వాజి వన్నిఙ్‌ నెగెణ్‌ కిఅ”, ఇజి వన్నిఙ్‌ బతిమాల్‌తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","యేసువన్నిఙ్, “నండొ బమ్మాని గుర్తుఙ్‌ సుడ్ఃతిఙనె మీరు నమినిదెర్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","అయా అతికారి, “బాబు, నా మరిన్‌ సాని ముఙాల రఅ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","దన్నిఙ్‌ యేసు వన్నిఙ్, “సొన్‌అ. నీ మరిన్‌ బత్కినాన్”, ఇజి వెహ్తాన్‌. వాండ్రు యేసు వెహ్తిమాట నమితాండ్రె సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","వాండ్రు సొన్సి మహివలె వన్ని ఇండ్రొణి పణి మణిసీర్‌ వన్ని ఎద్రు వాతారె, “నీ మరిన్‌ బత్కిత మనాన్”, ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ఎసొడు గంటెఙ్‌ వన్నిమరిసి నెగెణ్‌ ఆతాన్‌ ఇజి వరిఙ్‌ వెన్‌బాతిఙ్‌ వారు, “ఇఏన్‌ ఒంటి గంటదిఙ్‌ నోబు డిఃస్తాద్”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","నీ మరిన్‌ బత్కినాన్‌ ఇజి యేసు వెహ్తి ఆ టయిమ్‌దునె, వన్నిమరిన్‌ నెగెణ్‌ ఆతాన్‌ ఇజి బుబ్బ నెస్తాన్. అందెఙె వాండ్రు వన్ని కుటుమ్‌దికార్‌ యేసుఙ్‌ నమ్మితార్. ");
INSERT INTO kfc_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","యాకదె యేసు యుదయదాన్‌ గలీలయదు వాతి వెనుక కిత్తి మరి ఉండ్రి బమ్మాతి పణి. ");
INSERT INTO kfc_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","వెన్కా యూదుర్‌ఙ పండొయ్‌ ఉండ్రి వాతాద్. అందెఙె యేసు యెరూసలెమ్‌దు సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","యెరూసలెం సుటులం తొహ్‌క్తి కోటదు గొర్రెఙ్ సొని గోర్‌జె ఉండ్రి మనాద్. దన్నిడగ్రు ఉండ్రి సెరు మనాద్. దన్ని పేరు ఎబ్రి బాసదు బెదెస్త ఇజి. దన్నిఙ్‌ అయ్‌దు అరుఙుఙ్‌ సురులం మన్నె. ");
INSERT INTO kfc_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","అయా అరుఙుఙ మందెఙ్‌ మందెఙ్‌ కస్టమ్‌కాణికార్‌ గూర్త మహార్‌. గుడ్డిదికార్, సొటాదికార్, కిక్కుకాల్కు అర్తికార్‌ బాన్‌ మహార్‌. ఎస్తివలెనొ ఉండ్రి సుటు దేవుణు దూత ఒరెన్‌ అయా సెర్రుదు డిఃగ్‌జి ఏరుదిఙ్‌ కద్లిసినాన్. అయావలె ఎయెన్‌ ముఙాల ఏరుదు డిఃగ్‌నాండ్రొ, వాండ్రు ఎలాగ మర్తి జబ్బు ఆతికాన్‌ ఆతిఙ్‌బా నెగెణ్‌ ఆనాన్. యా కస్టమ్‌కాణికార్‌ ఏరు కద్లిని దన్నిఙ్‌ ఎద్రుసుడ్ఃజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","వరి లొఇ ఒరెన్‌ మహాన్‌. వాండ్రు ముప్పయెనిమిది పంటెఙాణిఙ్‌ కస్టమ్‌దాన్‌ మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","యేసు వన్నిఙ్‌ సుడ్ఃతాన్. వాండ్రు నండొ పంటెఙాణిఙ్‌ కస్టమ్‌దాన్‌ మనాన్‌ ఇజి నెస్తాండ్రె, వన్నిఙ్, “నీను నెగెణ్‌ ఆదెఙ్‌ కోరిజినిదా?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","వెన్‌బాతిఙ్‌ అయా కస్టమ్‌దికాన్, “బాబు, ఏరు కద్లిసినివలె నఙి సెరుదు డిఃప్తెఙ్, ఎయెన్‌బా నఙి సిల్లెన్. నాను డిఃగ్‌న ఇనిఙ్, నఙి ఇంక ముఙాలా మరి ఒరెన్‌ డిఃగ్‌జినాన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","యేసు వన్నిఙ్, “నీను నిఙ్‌జి నీ సాప అసి నడిఃఅ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","వెటనె వాండ్రు నెగెణ్‌ ఆతండ్రె వన్ని సాప నిక్తాండ్రె నడిఃతాన్. యాక విస్రాంతి దినమ్‌దు జర్గితాద్. ");
INSERT INTO kfc_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","అందెఙె యూదురు నెగెణ్‌ఆతి వన్నిఙ్, “నేండ్రు విస్రాంతి దినం గదె. నీను సాపెఙ్‌ నిక్సి ఒతెఙ్‌ ఆఎద్. ఎందనిఙ్‌ ఇహిఙ, మోసె సితి రూలుఙ్‌దు వెహ్సినాద్, ఇన్ని పణిబా విస్రాంతి దినమ్‌దు కిదెఙ్‌ ఆఎద్‌ ఇజి”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","దన్నిఙ్‌ వాండ్రు, “నఙి నెగెణ్‌ కితికాన్, ‘నీ సాప నిక్సి నిడిఃఅ’, ఇజి నఙి వెహ్తాన్‌”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","అందెఙె వారు, “నీ సాపెఙ్‌ నిక్సి నడిఃఅ ఇజి నిఙి వెహ్తికాన్‌ ఎయెన్‌?”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","నెగెణ్‌ కిత్తికాన్‌ ఎయెన్‌ ఇజి వన్నిఙ్‌ తెలిఎతాద్. ఎందనిఙ్‌ ఇహిఙ, అబ్బె మందలోకుర్‌ కూడిఃత మహార్‌. యేసు వరి లొఇహాన్‌‌ తప్రె ఆతండ్రె సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","వెనుక యేసు వన్నిఙ్‌ దేవుణు గుడిఃదు సుడ్ఃతాన్. సుడ్ఃతండ్రె వన్నిఙ్, “సుడ్ఃఅ, నీను ఏలు నెగెణ్‌ ఆతి. ఏలుదాన్‌ పాపమ్‌కు కిమ. సిలిఙ నిఙి మరి బాదెఙ్‌ లావు వానె”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","వాండ్రు సొహాండ్రె వన్నిఙ్‌ నెగెణ్‌ కితికాన్‌ యేసు ఇజి యూదురిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","అందెఙె యా పణిఙ్‌ యేసు విస్రాంతిదినమ్‌దు కితిఙ్‌ యూదురు వన్నిఙ్‌ నండొ మాలెఙ్ కిత్తార్. ");
INSERT INTO kfc_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","గాని యేసు వరిఙ్, “నా బుబ్బ ఎస్తివలెబా నెగ్గి పణిఙ్‌ మహి వరి వందిఙ్‌ కిజినె మంజినాన్. నానుబా కిజిన”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","యా లెకెండ్‌ యేసు వెహ్తిఙ్, యూదురు వన్నిఙ్‌ సప్తెఙ్‌ మరి నండొ సుడ్ఃతార్. ఎందానిఙ్‌ ఇహిఙ, వాండ్రు విస్రాంతిదినమ్‌ది రూలుఙ్‌ తప్తికాదె ఆఎండ, దేవుణు వన్ని సొంత బుబ్బ ఇజిబా వెహ్సినాన్. అయాలెకెండ్, వాండ్రు దేవుణు వెట సమానం ఆతికాన్‌ ఇజి వెహె ఆజినాన్. అందెఙె యేసుఙ్‌ సప్తెఙ్‌ మరి నండొ సుడ్ఃతార్. ");
INSERT INTO kfc_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","యేసు వరిఙ్‌ ఈహు మర్‌జి వెహ్తాన్‌. “నాను మిఙి నిజం వెహ్సిన, మరిసి ఆతి నాను ఇనికబా నా సొంత సత్తుదాన్‌ కిదెఙ్‌ అట్‌ఎన్. నా బుబ్బ ఇన్ని ఇనికెఙ్‌ కిజినిక సుడ్ఃజినానొ, అయాకెఙ్‌ నాను బా కిజిన. బుబ్బ కిజినికెఙ్‌ మరిసి బా కిజినాన్. ");
INSERT INTO kfc_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ఎందానిఙ్‌ ఇహిఙ, అపొసి మరిసిఙ్‌ ప్రేమిస్నాన్. వాండ్రు కిజినికెఙ్‌ విజు మరిసిఙ్‌ తోరిస్నాన్. వాండ్రు వన్నిఙ్‌ దినిఙ్‌ మిస్తి మరి నండొ పెరి పణిఙ్‌ తోరిస్నాన్. అయాకెఙ్‌ సుడ్ఃజి మీరు విజెరె నండొ బమ్మ ఆనిదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","అప్పొసి ఎలాగ సాతివరిఙ్‌ నిక్సి, వరిఙ్‌ బత్కిసినాండ్రొ అయ లెకెండ్, మరిసిబా బత్కిసినాన్. వన్నిఙ్‌ ఇస్టం మన్ని వరిఙ్‌ బత్కిస్నాన్. ");
INSERT INTO kfc_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","అప్పొసి ఎయెరిఙ్‌బా, వారు తీర్పు కిఎన్. గాని విజెరిఙ్‌ తీర్పు కిదెఙ్‌ మరిసిఙ్‌ అతికారం విజు ఒపజెప్త మనాన్. అపొసిఙ్‌ గవ్‌రం సీనిలెకెండ్‌ విజెరె మరిసిఙ్‌ గవ్‌రం సీదెఙ్‌నె యా అతికారం ఒపజెప్త మనాన్. మరిసిఙ్‌ గవ్‌రం సిఇకాన్‌ ఎయెన్‌బా, వన్నిఙ్‌ పోక్తి అపొసిఙ్‌ గవ్‌రం సిఏన్. ");
INSERT INTO kfc_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","నాను మిఙి నిజం వెహ్సిన, నా మాట వెంజి, నఙి పోక్తి వన్నిఙ్‌ నమ్మిజినివన్నిఙ్‌ ఎలాకాలం దేవుణు వెట బత్కిని బత్కు మనాద్. వన్నిఙ్‌ నాను తీర్పుసిఏ. వన్నిఙ్‌ ఎలాకాలం మన్ని సిక్స సిల్లెద్‌. గాని వాండ్రు ఎలాకాలం దేవుణు వెట బత్కినాన్. ");
INSERT INTO kfc_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","సాతి లెకెండ్‌ మనికార్‌ దేవుణు మరిసి ఆతి నాను వెహ్ని మాటెఙ్‌ వెని కాలం వాజినాద్. అయాక ఏలునె వాత మనాద్. నా మాటెఙ్‌ వెంజి, అయ లెకెండ్‌ కినికార్‌ బత్కినార్, ఇజి నాను మిఙి నిజమ్‌నె వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ఎందానిఙ్‌ ఇహిఙ, నా బుబ్బ బాణిఙె బత్కు వానాద్. వాండ్రు విజెరె బత్కిసిని లెకెండ్, నాను లోకురిఙ్‌ బత్కిస్తెఙ్‌ నఙి అతికారం సిత మనాన్. ");
INSERT INTO kfc_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","మరి లోకురిఙ్‌ తీర్పు సీదెఙ్‌ వాండ్రు నఙి అతికారం సిత మనాన్. ఎందనిఙ్‌ ఇహిఙ, నాను లోకు మరిసి. ");
INSERT INTO kfc_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","దిన్నివందిఙ్‌ బమ్మ ఆమాట్. ఎందానిఙ్‌ ఇహిఙ, దూకిదు మనికార్‌ విజెరె నా మాటెఙ్‌ వెని కాలం ఉండ్రి వాజినాద్. ");
INSERT INTO kfc_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","వారు దూకిదాన్‌ వెల్లి వానార్. నెగ్గి పణిఙ్‌ కితికార్‌ నిఙ్‌జి మరి ఎల్లకాలం దేవుణు వెట బత్కినార్. సెఇ పణిఙ్‌ కితికార్‌ నిఙ్‌జి సిక్స పొందినార్. ");
INSERT INTO kfc_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","నా సొంత సత్తుదాన్‌ ఇనికబా కిదెఙ్‌ నాను అట్‌ఏ. దేవుణు వెహ్తి వజనె నాను తీర్పు సీజిన. అందెఙె నాను తీర్పు సీజి సిక్స సీనిక నాయం ఆత్తిక. ఎందానిఙ్‌ ఇహిఙ, నాను నఙి ఇస్టం ఆతి వజ కిఎ, నఙి పోక్తి వన్నిఙ్‌ ఇస్టం ఆతివజనె కిజిన. ");
INSERT INTO kfc_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","నా వందిఙ్‌ నానె వెహ్తిఙ, నాను వెహ్సిని వన్కాఙ్‌ పేరు సిల్లెద్‌. ");
INSERT INTO kfc_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","గాని నా వందిఙ్‌ మరి ఒరెన్‌ సాక్సి వెహ్సినాన్. వాండ్రు నా బుబ్బ. వాండ్రు నా వందిఙ్‌ వెహ్సిని సాక్సి నిజం ఇజి నాను నెసిన. ");
INSERT INTO kfc_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","మీరు యోహాను డగ్రు సెగొండారిఙ్‌ పోక్తిదెర్. వాండ్రు నా వందిఙ్‌ నిజమాతి సాక్సి వెహ్తాన్‌‌ ");
INSERT INTO kfc_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","లోకుర్‌ నా వందిఙ్‌ వెహ్సిని సాక్సి నఙి అవుసరం సిల్లెద్‌. గాని మీరు యోహాను వెహ్తి మాటెఙ్‌ నమిజి దేవుణు మిఙి రక్సిస్తెఙ్, నాను వాండ్రు వెహ్తి దని వందిఙ్‌ వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ఉండ్రి దీవ కసి జాయ్‌ సీజినిలెకెండ్‌ యోహాను నిజమాతికెఙ్‌ నెస్‌పిస్తాన్. సెగం కాలం వన్ని మాటెఙ్‌ వెంజి మీరు సర్‌ద ఆతిదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","నాను కిజిని పణిఙ్‌ యోహాను వెహ్తి సాక్సి ఇంక గొప్ప పెరి సాక్సినె. ఎందనిఙ్‌ ఇహిఙ, నాను పూర్తి కిదెఙ్‌ బుబ్బ నఙి ఒపజెప్తికెఙె నాను కిజిని పణిఙ్. అయా పణిఙ్‌ బుబ్బ నఙి పోక్త మనాన్‌ ఇజి రుజుప్‌కిజినె. ");
INSERT INTO kfc_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","38","మరి, నఙి పోక్తి బుబ్బనె నా వందిఙ్‌ నిజమాతికెఙ్‌ వెహ్సినాన్. మీరు వన్నిఙ్‌ ఎసెఙ్‌బా వెన్‌ఇతిదెర్. వన్ని రూపు ఎసెఙ్‌బా తొఇతిదెర్. వన్ని మాటెఙ్‌ మీ మన్సుదు ఇడ్ఇతిదెర్. ఎందనిఙ్‌ ఇహిఙ, వాండ్రు పోక్తి నఙి మీరు నమిఇదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","40","మీరు దేవుణు మాట బాగ సద్‌విజినిదెర్. ఎందనిఙ్‌ ఇహిఙ, అయాక మిఙి ఎలాకాలం దేవుణు వెట బత్కిని బత్కు సీనాద్‌ ఇజి ఒడ్ఃబిజినిదెర్. అయా మాటెఙ్‌ నా వందిఙె వెహ్సినె. గాని దేవుణు వెట ఎలాకాలం బత్కిని బత్కు వందిఙ్‌ నా డగ్రు రెఇదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","లోకుర్‌ పొగ్‌డిఃజినికెఙ్‌ నాను కోరిఏ. ");
INSERT INTO kfc_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","గాని మీరు ఎలాగ మర్తికిదెర్‌ ఇజి నాను నెస్న. మీరు దేవుణుదిఙ్‌ నిజం ప్రేమిస్‌ఇకిదెర్‌ ఇజి నాను నెస్న. ");
INSERT INTO kfc_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","నా బుబ్బ సిత్తి అతికారమ్‌దాన్‌ నాను వాత మన్న. గాని మీరు నఙి డగ్రు కిఇదెర్. మరి ఒరెన్, వన్ని సొంత అతికారమ్‌దాన్‌ వాతిఙ, మీరు వన్నిఙ్‌ డగ్రు కినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","లోకుర్‌ పొగ్‌డిఃదెఙ్‌ ఇజి మీరు కోరిజినిదెర్. ఒరెండ్రె దేవుణు ఆతికాన్‌ మిఙి పొగ్‌డిఃదెఙ్‌ మీరు కోర్‌ఇదెర్. మరి మీరు ఎలాగ నఙి నమ్మినిదెర్‌? ");
INSERT INTO kfc_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","నాను బుబ్బ డగ్రు నేరం మోప్నాన్‌ ఇజి మీరు ఒడ్ఃబిమాట్. మీరు ఆస దాన్‌ ఎద్రు సుడ్ఃతి మోసెనె మీ ముస్కు నేరం మొప్నాన్. ");
INSERT INTO kfc_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","మీరు మోసెఙ్‌ నమ్మినికిదెర్‌, నఙిబా నమ్మితార్‌ మరి. ఎందానిఙ్‌ ఇహిఙ, మోసె నా వందిఙ్‌ రాస్త మనాన్. ");
INSERT INTO kfc_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","మీరు వాండ్రు రాస్తి మనికెఙ్‌ నమ్మిఇదెర్. మరి ఎలాగ నాను వెహ్సినిక నమ్మినిదెర్?”. ");
INSERT INTO kfc_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","దన్నివెనుక యేసు గలీలయ సమ్‌దరం డాట్సి అతాహ ఒడ్డుద్‌ సొహాన్‌. తిబెరియ సమ్‌దరం ఇజిబా ఇనార్. ");
INSERT INTO kfc_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","కస్టమ్‌దాన్‌ మహి వరిఙ్‌ వాండ్రు నెగెణ్‌ కితి బమ్మ ఆతి పణిఙ లోకుర్‌ సుడ్ఃతార్. అందెఙె మంద లోకుర్‌ వన్ని వెట వాతార్. ");
INSERT INTO kfc_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","యేసు అబెణి గొరొణ్‌ సెల్కాదు ఎక్తాండ్రె వన్ని సిసూర్‌ వెట బస్త మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","నస్తివలె యూదురు కిని పస్క ఇని పండొయ్‌ డగ్రు ఆత మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","యేసు కణక పెహ్తి బేస్తిఙ్, మంద లోకుర్‌ వన్ని డగ్రు వాజినిక సుడ్ఃతాన్. “వీరు ఉండెఙ్‌ బోజనం ఎలాగ కొండెఙ్‌ ఆనాప్‌?”, ఇజి పిలిపుఙ్‌ వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ఇనిక కిదెఙ్‌ ఇజి యేసు నెస్నాన్‌ గాని పిలిపుఙ్‌ వన్నిముస్కు నమకం మనాదా ఇజి సుడ్ఃదెఙె వాండ్రు అయా లెకెండ్‌ వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","అందెఙె పిలిపు, “వరి లొఇ ఒరెన్‌ ఒరెన్‌ కండెక్‌ కండెక్‌ ఉండెఙ్‌బా రుండి వందెఙ్‌ వెండి రుపాయుఙాణి బోజనం కొటిఙ్‌బా సాల్‌ఎద్”, ఇజి వన్నిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","అయావలె వన్ని సిసూర్‌ లొఇ ఒరెన్‌ ఆతి ఆంద్రెయ ఇనికాన్‌ యేసుఙ్‌ వెహ్తాన్‌. వీండ్రు సిమోన్‌ పేతురుఙ్‌ తంబెర్సి. ");
INSERT INTO kfc_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","వాండ్రు ఇన్నిక వెహ్తాన్‌‌ ఇహిఙ, ‘ఇబ్బె ఒరెన్‌ ఇజ్రి కొడొః మనాన్. వన్నిబాన్‌ అయ్‌దు యావల రొట్టెఙ్, రుండి మొయెఙ్‌ మనె. గాని నిసొ మందదిఙ్‌ యాకెఙ్‌ సాల్‌ఉ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","అయావలె యేసు, “యా లోకాఙ్‌ బసె కిదు”, ఇజి వెహ్తాన్‌. అయా బాడిఃదు నండొ గడ్డి మనాద్. అందెఙె మొగ్గకొడొఃర్‌ బస్తార్. వారె డగ్రు అయ్‌దు వెయుఙ్‌ మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","యేసు అయా రొట్టెఙ్‌ అస్తాండ్రె, దేవుణుదిఙ్‌ వందనమ్‌కు వెహ్తండ్రె, బస్తి వరిఙ్‌ సీబాజి సితాన్. అయాలెకెండె మొయెఙ్‌బా. వరిఙ్‌ కావాలస్తి నసొ సీబాత సిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","వారు పొటపంజు తిహి వెనుక, “ఇన్నిక పాడు ఆఏండ, మిగిలితికెఙ్‌ కొటు కిదు”, ఇజి సిసూర్‌ఙ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","అందెఙె మిగిలితికెఙ్‌ సిసూర్‌ కెహ్తర్. లోకుర్‌ తిహి వెన్కా మన్ని అయ్‌దు యావల రొట్టెఙాణి ముకెఙ్‌ కొటు కితారె, పన్నెండు గప్పెఙ్‌ నిహ్తర్. ");
INSERT INTO kfc_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","యేసు కిత్తి యా బమ్మాతి పణి సుడ్ఃతారె, “నిజమె, లోకమ్‌దు వాని ప్రవక్త వీండ్రె”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","యా లోకుర్‌ వాజి, కెఇ కెఇ నఙి రాజు కినార్‌ ఇజి యేసు నెస్తాన్. అందెఙె వాండ్రు బాణిఙ్‌ డిస్తాండ్రె ఒరెండ్రె మరి గొరొత్‌ సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","పొద్దు ఆతివెలె, వన్నిసిసూర్‌ డిఃగితారె, సమ్‌దరం ఒడ్డుదు వాతార్. అబ్బె వారు ఉండ్రి డోణిదు ఎక్తారె, సమ్‌దరం డాట్సి, కపర్‌నహొముదు సొండ్రెఙ్‌ ఇజి సోతార్. అయావలె సీకాట్‌ ఆతాద్. యేసు వరి డగ్రు ఇంక రఎండ మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","నస్తివలె పెరి గాలి ఉండ్రి వాతాద్. సందారమ్‌దు లావు ఉల్కెఙ్‌ నిఙితె. ");
INSERT INTO kfc_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","వారు రమారమి మూండ్రి నాల్గి మయ్‌లు నడిఃపిస్తార్. అయావలె యేసు సందారం ఏరు ముస్కు నడిఃజి డోణి డగ్రు వాజినిక సుడ్ఃతార్. అయాక సుడ్ఃతారె, వారు నండొ తియెల్‌ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","గాని వాండ్రు, “నానె, తియెల్‌ ఆమాట్”, ఇజి వరిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","అందెఙె వారు వన్నిఙ్‌ డోణిదు ఎకిస్తెఙ్‌ ఇస్టం ఆతార్‌ గాని వెటనె వారు సొండ్రెఙ్‌ సరి సోతి మన్ని గటుదు అందితార్. ");
INSERT INTO kfc_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","సిసూరు డోణి ఎక్సి సొని ముఙాల నిహి మహి సమ్‌దరం ఒడ్డుదు మంద లోకుర్‌ మహార్‌. మహ్స నాండిఙ్‌ వారు నెస్తార్, అబ్బె ఉండ్రి డోణినె మహాద్‌. యేసు వన్ని సిసూర్‌ వెట అయా డోణి ఎక్సి సొన్‌ఎతాన్. సిసూర్‌నె ఎక్త సొహార్‌ ఇజి. ");
INSERT INTO kfc_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","నస్తివలె, తిబెరియదాన్‌ మరి డోణిఙ్‌ వాతె. యేసు రొట్టెఙ వందిఙ్‌ దేవుణుదిఙ్‌ వందనమ్‌కు వెహ్తాన్‌. వెహ్తి వెన్కా లోకుర్‌ అయాక తిహర్. వారు రొటెఙ్‌ తిహి బాడ్డిః డగ్రు అయా డోణిఙ్‌ వాతె. ");
INSERT INTO kfc_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","యేసుని వన్ని సిసూర్‌ బాన్‌ సిల్లెర్‌‌ ఇజి మంద నెస్తార్. ఆహె నెస్తివెలె, వారు డోణిఙ్‌ ఎక్తారె, వన్నిఙ్‌ రెబాజి కపర్‌నహొముదు సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","వారు యేసుఙ్‌ అతాహ ఒడ్డుదు సుడ్ఃతారె, “బోదకినికిదా, నీను ఎస్‌కాండె ఇబ్బె వాతి?”, ఇజి వన్నిఙ్‌ వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","దన్నిఙ్‌ యేసు వెహ్తాన్‌, “నాను మీ వెట నిజం వెహ్సిన, మీరు పొట పంజు రొటెఙ్‌ తిహిదెర్. అందెఙె మీరు నఙి రెబానిదెర్. గాని నాను కితి బమ్మ ఆతి పణి అర్దం నెస్ని వందిఙ్‌ ఆఎద్‌ రెబాజినిక. ");
INSERT INTO kfc_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","పాడాఃజి సొని టిండి వందిఙ్‌ కస్టబడఃమాట్. గాని ఎలాకాలం దేవుణు వెట బత్కిని బత్కు సీని నిజమాతి టిండి వందిఙ్‌ కస్టబడఃదు. లోకు మరిసి అయా టిండి మిఙి సీనాన్. ఎందనిఙ్‌ ఇహిఙ అయా టిండి సీదెఙ్‌ వన్నిఙ్‌ బుబ్బ ఆతి దేవుణు అతికారం సిత మనాన్. ");
INSERT INTO kfc_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","వారు వన్నిఙ్, “మాపు దేవుణు పణికిదెఙ్‌ ఇహిఙ, ఇన్నిక కిదెఙ్‌వెలె?”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","యేసు వరిఙ్, “దేవుణు పోక్తి వన్నిముస్కు నమకం ఇడ్ఃజి మంజినికాదె దేవుణు సేవ పణి”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","అందెఙె వారు, “అహిఙ, నీను ఇని బమ్మాని పణికినిలె? అయాక సుడ్ఃజి నీ ముస్కు నమకం ఇడ్‌దెఙ్‌ నీను ఇనిక కినిలె? ");
INSERT INTO kfc_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","మోసె వెట మహి మా అనిగొగొర్‌ బీడిమ్‌బూమిద్‌ మన్న ఇని బోజనం ఉటార్. దేవుణు మాటదు రాస్త మనాద్, ‘వారు ఉండెఙ్‌ దేవుణు మంజిని బాడ్డిదాన్‌ వాండ్రు బోజనం సితాన్‌ ఇజి’”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","అందెఙె యేసు వరిఙ్‌ వెహ్తాన్‌, “నాను మిఙి నిజం వెహ్సిన, దేవుణు మంజిని బాడ్డిదాన్‌ బోజనం మిఙి సితికాన్‌ మోసె ఆఎన్, గాని నా బుబ్బనె సితాన్. వాండ్రె మిఙి దేవుణు మంజిని బాడ్డిదాన్‌ నిజమాతి బోజనం సీజినికాన్. ");
INSERT INTO kfc_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","దేవుణు సీజిని బోజనం ఇన్నిక ఇహిఙ, వాండ్రు మంజిని బాడిదాన్‌డిఃగితి వాతి, యా లోకమ్‌ది లోకురిఙ్‌ ఎలాకాలం దేవుణు వెట బత్కిజిని బత్కు సీజినికానె”. ");
INSERT INTO kfc_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","అహిఙ, ప్రబువా, యా బోజనం ఎలాకాలం మఙి సీజి మన్‌అ”, ఇజి వారు వన్నిఙ్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","అందెఙె యేసు వరిఙ్‌ ఈహు వెహ్తాన్‌, “ఎలాకాలం దేవుణు వెట బత్కిదెఙ్‌ లోకురిఙ్‌ బత్కిస్‌పిస్ని టిండి నానె. నా డగ్రు వాజినికాన్‌ ఎసెఙ్‌బా బఙ సాఎన్, నఙి నమ్మినికాన్‌ ఎసెఙ్‌బా ఏహ్కి సాఎన్. ");
INSERT INTO kfc_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","నాను మిఙి వెహ్తి లెకెండ్, మీరు నఙి సుడ్ఃతి మనిదెర్, గాని నఙి నమిఇదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","బుబ్బ నఙి ఒపజెప్తి లోకుర్‌ విజెరె నా డగ్రు వానార్. నా డగ్రు వాని ఎయెరిఙ్‌బా నాను వెల్లి నెక్సి పొక్‌ఏ. ");
INSERT INTO kfc_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ఎందానిఙ్‌ఇహిఙ, నాను నఙి ఇస్టం వాతి లెకెండ్‌ కిదెఙ్‌ ఆఏద్, దేవుణు మంజిని బాడ్డిదాన్‌ డిఃగితి వాతిక. గాని నఙి పోక్తి వన్నిఙ్‌ ఇస్టం వాతి లెకెండ్‌ కిదెఙె డిగిత వాత. ");
INSERT INTO kfc_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","నఙి పోక్తి దేవుణు, నా బాణిఙ్‌ ఇన్నిక కోరిజినాన్‌ ఇహిఙ, వాండ్రు నఙి ఒపజెప్తి వరి లొఇ ఎయెరిఙ్‌బా నాను డిఃస్తెఙ్‌ ఆఏద్. గాని వరిఙ్‌ నాను మరి వాని కడెఃవెరి దినమ్‌దు ఎలాకాలం బత్కిస్తెఙె. యాకదె వాండ్రు నా బాణిఙ్‌ కోరిజినాన్. ");
INSERT INTO kfc_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","నా బుబ్బ కోరిజినిక ఇన్నిక ఇహిఙ, నాను దేవుణు మరిసి ఇజి నెసి నఙి నమ్మిని ఎయెరిఙ్‌బా ఎలాకాలం దేవుణు వెట బత్కిని బత్కు మండ్రెఙ్‌ ఇజి. మరి నాను మర్‌జి వానివలె నాను వరిఙ్‌ సావుదాన్‌ బత్కిస్తెఙె ఇజి. యాకదె నా బుబ్బ నా బాణిఙ్‌ కోరిజినాన్. ");
INSERT INTO kfc_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","యూదురు యేసువందిఙ్‌ మొరొ ఆతార్. దేవుణు మంజిని బాడ్డిదాన్‌ డిఃగితి వాతి టిండి నానె, ఇజి వాండ్రు వెహ్తాన్‌. దిని వందిఙ్‌ వారు మొరొ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","వారు, “వీండ్రు యోసేపు మరిన్‌ ఆతి యేసు గదె? విని అయిసి అప్పొసిరిఙ్‌ మాటు నెస్నాట్‌గదె? మరి ‘నాను దేవుణు మంజిని బాడ్డిదాన్‌ డిఃగిత వాత’, ఇజి వీండ్రు ఎలాగ వెహ్సినాన్”, ఇజి వర్గిజినార్. ");
INSERT INTO kfc_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","అందెఙె యేసు, “మీ లొఇ మీరు మొరొ ఆమాట్. ");
INSERT INTO kfc_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","నఙి పోక్తి బుబ్బ ఎయెరిఙ్‌బా నా డగ్రు నడిఃపిస్‌ఎండ మహిఙ, వారు నా డగ్రు వాదెఙ్‌ అట్‌ఎర్. నాను వన్నిఙ్‌ కడెఃవెరి దినమ్‌దు నాను వానివలె సావుదాన్‌ బత్కిస్నాలె. ");
INSERT INTO kfc_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ప్రవక్తరు దేవుణు మాటదు ముఙాలె రాస్త మనాద్, ‘దేవుణునె లోకురిఙ్‌ విజెరిఙ్‌ నెస్‌పిస్నాన్‌’, ఇజి. బుబ్బ వెహ్తి మాట వెంజి, అయాకెఙ్‌ వన్ని బాణిఙ్‌ నెస్తికార్‌ నాడగ్రు వానార్. ");
INSERT INTO kfc_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","దేవుణు బాణిఙ్‌ వాతికానె ఆఎండ మరి ఎయెన్‌బా బుబ్బెఙ్‌ తొఏన్. వాండ్రు ఒరెండ్రె బుబ్బెఙ్‌ సుడ్ఃత‌ మనాన్. ");
INSERT INTO kfc_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","నాను మీ వెట నిజమ్‌నె వెహ్సిన, నా ముస్కు నమకం ఇడ్నివన్నిఙ్‌ ఎలాకాలం దేవుణు వెట బత్కిని బత్కు మనాద్. ");
INSERT INTO kfc_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ఎలాకాలం దేవుణు వెట బత్కిదెఙ్‌ లోకురిఙ్‌ బత్కిస్‌పిస్ని టిండి నానె. ");
INSERT INTO kfc_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","మీ అనిరు బీడిమ్‌బూమిదు మన్న ఇన్ని బోజనం ఉటార్. గాని వారు సాతార్. ");
INSERT INTO kfc_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","గాని యా టిండి ఎయెర్‌ ఉటిఙ్‌బా వారు సాఎర్. సాఇ నని టిండినె దేవుణు మంజిని బాడ్డిదాన్‌ డిఃగితి వాతిక. ");
INSERT INTO kfc_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","నానె దేవుణు మంజిని బాడ్డిదాన్‌ డిఃగితి వాతి ఎలాకాలం దేవుణు వెట బత్కిని బత్కు సీని టిండి. ఎయెన్‌బా యా టిండి తిహిఙ, వాండ్రు ఎలాకాలం బత్కినాన్. నా సొంత ఒడొఃల్‌నె నాను సీని టిండి. యా లోకమ్‌దికార్‌ ఎలాకాలం బత్కిదెఙె నాను అయక సీజిన”. ");
INSERT INTO kfc_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","యేసు వెహ్తిక వెహరె, అయావలె యూదురు వారె వరి లొఇ ఉండ్రి గొడఃబ రేఙితాద్. “విని ఒడొఃల్‌ ఎలాగ మాటు తిండ్రెఙ్‌ మఙి సీనాన్”, ఇజి వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","అందెఙె యేసు వరిఙ్‌ వెహ్తాన్‌, “నిజమె నాను మీ వెట వెహ్సిన, లోకుమరిసి ఆతి నా ఒడొఃల్‌ మీరు తిన్‌ఎండ మహిఙ, నా నల మీరు ఉణెఎండ మహిఙ, మీరు ఎలాకాలం బత్కిఇదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","నా ఒడొఃల్‌ తిని ఎయెరిఙ్‌బా, నా నల ఉణి ఎయెరిఙ్‌బా ఎలాకాలం దేవుణు వెట బత్కిని బత్కు మనాద్. నాను వన్నిఙ్‌ కడెఃవెరి దినమ్‌దు నాను వానివలె సావుదాన్‌ ఎలాకాలం బత్కిస్నాలె. ");
INSERT INTO kfc_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ఎందానిఙ్‌ ఇహిఙ, నా ఒడొఃల్, నా నల యాకెఙె తిండ్రెఙ్‌ ఉండెఙ్‌ మనికెఙ్. యాకెఙె నిజమాతి టిండి. ");
INSERT INTO kfc_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","నా ఒడొఃల్‌ తినికాన్, నా నల ఉణికాన్, నా వెట కూడ్ఃజి మంజినాన్. నాను వన్ని వెట కూడ్ఃజి మంజిన. ");
INSERT INTO kfc_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","లోకుర్‌ విజెరిఙ్‌ బత్కిదెఙ్‌ పాణం సీజిని బుబ్బ నఙి పోక్త మనాన్. వాండ్రు నఙి బత్కు సీజినాన్. అయాలెకెండ్‌ ఎయెన్‌బా నా ఒడొఃల్‌ తిహిఙ, నాను వన్నిఙ్‌ ఎలాకాలం దేవుణు వెట బత్కిని బత్కు సీన. ");
INSERT INTO kfc_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","నానె దేవుణు మంజిని బాడ్డిదాన్‌ డిఃగితి వాతి టిండి. మీ అనిరిఙ్‌ ఉటి మన్న ఇన్ని బోజనంలెకెండ్‌ ఆఎద్‌ యాక. వారు ఉటారె సాతార్. గాని యా టిండి తినికాన్‌ ఎయెన్‌బా ఎలాకాలం బత్కినాన్. ");
INSERT INTO kfc_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","కపెర్నహుముదు మన్ని యూదురి మీటిఙ్‌ ఇండ్రొ నేర్‌పిసి మహివలె వాండ్రు యా మాటెఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","వన్ని సిసూర్‌ నండొండార్‌ యా మాటెఙ్‌ వెహరె, “యా మాటెఙ్‌ గొప్ప కస్టం ఆతికెఙ్. ఎయెన్‌దనిఙ్‌ అర్దం కినాన్?’, ఇజి వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","వన్ని మాటెఙ వందిఙ్‌ వన్ని సిసూర్‌ మొరొ ఆజినార్‌ ఇజి యేసు నెస్తాండ్రె వరిఙ్, “యా మాటెఙ్‌ మిఙి బాద కిజినెనా?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","“అహిఙ, లోకు మరిసి ఆతి నాను, ముఙాల నాను మహి బాడిఃదు ఎక్సి సొనిక మీరు సూణివలె, మీరు ఇన్నిక ఒడ్ఃబినిదెరొ? ");
INSERT INTO kfc_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","దేవుణు ఆత్మనె, ఎలాకాలం దేవుణు వెట బత్కిని బత్కు సీజినాన్. లోకుర్‌ అయాక సీదెఙ్‌ అట్‌ఎర్. నాను మిఙి వెహ్సిని మాటెఙ్‌వెట, దేవుణు ఆత్మ మీ ముస్కు వాజినాన్. దేవుణు ఆత్మ మిఙి బత్కు సీజినాన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","“గాని మీ లొఇ సెగొండార్‌ నాను వెహ్తి మాటెఙ్‌ నమ్మిఇకార్‌ మనార్”. సిసూర్‌ లొఇ ఎయెన్‌ వాండ్రు వెహ్తి మాటెఙ్‌ నమ్మిఏర్, ఎయెన్‌ వన్నిఙ్‌ ఒపజెప్నాన్‌ ఇజి యేసు మొదొహనె నెస్త మహాన్‌. అందెఙె వాండ్రు ఆహె వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","యేసు మరి వెహ్సినాన్, “మీ లొఇ సెగొండార్‌ నమ్మిఇదెర్. అందెఙె నాను మీ వెట వెహ్త మన్న, బుబ్బ సరి సిఎండ మహిఙ, ఎయెన్‌బా నా డగ్రు వాదెఙ్‌ అట్‌ఏన్”, ఇజి. ");
INSERT INTO kfc_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","దిన్ని వెనుక, వన్ని సిసూర్‌ లొఇ నండొండార్‌ వన్నిఙ్‌ డిఃస్తారె వన్నివెట మరి సొన్‌ఎతార్. ");
INSERT INTO kfc_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","నస్తివలె యేసు పన్నెండు మణిసి సిసూరిఙ్, “మీరు బా నఙి డిఃసి సొండ్రెఙ్‌ కోరిజినిదెరా?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","అందెఙె సిమోన్‌ పేతురు, “ప్రబువా, ఎయెర్‌బాన్‌ మాపు సొండ్రెఙ్‌? నీ మాటెఙ్‌నె ఎలాకాలం దేవుణు వెట బత్కిని బత్కు వందిఙ్‌ వెహ్సినె. ");
INSERT INTO kfc_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","మాపు ఏలు నమ్మిజినాప్, మాపు నెస్తాప్, నీనె దేవుణు బాణిఙ్‌ వాతికాన్‌ ఇజి”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","అందెఙె యేసు, మిఙి పన్నెండు మణిసీర్‌ సిసూరిఙ్‌ ఏర్‌పాటు కితిక నానె గదె. గాని మీ లొఇ ఒరెన్, సయ్తానుఙ్‌ మన్ని బుద్ది ననికాన్‌ మనాన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","వాండ్రు ఇస్కరియొతు సిమోన్‌ మరిసి యూద వందిఙ్‌ వెహ్తాన్‌. యూద సిసూర్‌ లొఇ ఒరెన్‌ ఆతిఙ్‌బా వాండ్రు యేసుఙ్‌ వెన్కా ఒపజెప్నాన్‌లె. ");
INSERT INTO kfc_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","వెనుక, యేసు గలీలయ దేసమ్‌దునె మంజి నాహ్కఙ్‌ బూలాజి మహాన్‌. వాండ్రు యూదయ దేసమ్‌దు మండ్రెఙ్‌ కెఏతాన్. ఎందానిఙ్‌ ఇహిఙ, యూదురు వన్నిఙ్‌ సప్తెఙ్‌ సుడ్ఃజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","నస్తివలె, యూదురి ఉండ్రి పండొయ్‌ డగ్రు ఆతాద్. అయా పండొయ్‌ పేరునె గుడుస పండొయ్‌ ఇజి. ");
INSERT INTO kfc_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","పండొయ్‌ డగ్రు ఆతిఙ్, యేసు తంబెర్‌సిర్‌ వన్నిఙ్, “ఇబ్బెణిఙ్‌ నీను యూదయ దేసమ్‌దు సొన్‌అ. ఎందానిఙ్‌ ఇహిఙ, నీ సిసూర్‌ ఆతికార్‌ నీను కిజిని బమ్మ ఆతి పణిఙ్‌ సుడ్ఃదెఙ్”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","“పెరికాన్‌ ఆదెఙ్‌ కోరిజినికాన్‌ ఎయెన్‌బా డాప్సి వన్ని పణి కిఎన్. విజెరె ఎద్రునె కినాన్. నీను యా బమ్మాని పణిఙ్‌ కిజిని ఇహిఙ, నిఙి నీనె లోకమ్‌ది లోకుర్‌ ఎద్రు తోరె ఆదెఙ్‌ మరి. యా గలీలియదికార్‌ ఉండ్రె ఆఏండ”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","వన్ని తంబెర్‌సీర్‌బా వన్నిఙ్‌ నమిఎతార్. ");
INSERT INTO kfc_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","అందెఙె యేసు వరిఙ్, “నాను పండొయిదిఙ్‌ సొండ్రెఙ్‌ సమయం ఇంక రఏదె. గాని మిఙి ఎస్తివలెబా సొండ్రెఙ్‌ ఆనాద్. ");
INSERT INTO kfc_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","యా లోకమ్‌దు మన్ని దేవుణుదిఙ్‌ దూసిస్నికార్‌ మిఙి దూసిస్‌ఎర్. ఎందానిఙ్‌ ఇహిఙ, మీరు బా వరి వెట మనిదెర్. గాని వారు నఙి దూసిస్నార్. ఎందానిఙ్‌ ఇహిఙ, వారు సెఇకెఙ్‌ కిజినార్‌ ఇజి నాను వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","మీరు పండొయిదిఙ్‌ సొండ్రు. నాను ఏలు సొన్‌ఏ. ఎందానిఙ్‌ ఇహిఙ, నాను సొండ్రెఙ్‌ సమయం పూర్తి రఏదె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","యాక వెహ్తండ్రె వాండ్రు గలీలయదు మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","వన్ని తంబెర్‌సిర్‌ పండొయ్‌దిఙ్‌ సొహి వెన్కా, వాండ్రు బా సొహాన్‌. లోకుర్‌ విజెరె వన్నిఙ్‌ నెస్‌ఇ లెకెండ్‌ వాండ్రు డాఙ్‌జి సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","గాని పండొయ్‌దు, యూదురు వన్నిఙ్‌ రెబాజి, “అయా వాండ్రు ఒంబొవీన్”, ఇజి వెన్‌బాజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","లోకుర్‌ లొఇ వన్ని వందిఙ్‌ నండొ మొరొ ఆతార్. సెగొండార్‌ వాండ్రు నెగ్గికాన్‌ ఇజి, మరి సెగొండార్, సిల్లె వాండ్రు లోకురిఙ్‌ మోసెం కిజినికాన్‌ ఇజి మొరొ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","గాని యూదురిఙ్‌ తియెలాజి, ఎయెర్‌బా వన్ని వందిఙ్‌ డటం వెహ్‌ఏతార్. ");
INSERT INTO kfc_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","పండొయి దినమ్‌కు సెగం ఆతాద్. అయావలె వాండ్రు దేవుణు గుడిఃది అరుఙుదు సొహాండ్రె అబె మన్ని లోకురిఙ్‌ నెర్పిసినాన్. ");
INSERT INTO kfc_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","అందెఙె యూదురు నండొ బమ్మ ఆతారె, “వీండ్రు బడిఃదు సొన్సి సద్‌విఇతికాన్‌ గదె? మరి ఎలాగ వీండ్రు నిసొ నెస్త మనాన్‌?”, ఇజి వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","నస్తివలె యేసు వెహ్తాన్‌, “నాను నేర్‌పిస్ని మాట నా సొంత మాట ఆఎద్. గాని అయాక నఙి పోక్తి వన్ని బాణిఙ్‌ వాజినాద్. ");
INSERT INTO kfc_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","దేవుణు ఇస్టం కిదెఙ్‌ కోరిజినికాన్‌ ఎయెన్‌బా, నాను నేర్‌పిస్ని మాట దేవుణు బాణిఙ్‌ వాజినాదొ, నా సొంత అతికారం దాన్‌ నాను నేర్‌పిసినికాదొ ఇజి నెస్నాన్. ");
INSERT INTO kfc_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","సొంత అతికారమ్‌దాన్‌ నెస్‌పిసినికాన్‌ ఎయెన్‌బా వన్నిఙ్‌ గవ్‌రం వాదెఙె నెస్‌పిస్నాన్. గాని వన్నిఙ్‌ పోక్తి వన్నిఙ్‌ గవ్‌రం వాదెఙ్‌ ఇజి కోరిజినికాన్‌ నిజామాతికాన్. వన్ని లొఇ ఇనితప్పబా సిల్లెద్‌. ");
INSERT INTO kfc_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","దేవుణు మోసెఙ్‌ సిత్తి రూలుఙ్‌ వాండ్రు మిఙి సితాన్‌ గదె? గాని మీ లొఇ ఒరెన్‌బా ఆ రూలుఙ వజ నడ్ఃఇదెర్. మీరు ఎందానిఙ్‌ నఙి సప్తెఙ్‌ సుడ్ఃజినిదెర్‌?”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","అయావలె మందలోకుర్, “నిఙి దెయం అస్తాద్. ఎయెర్‌ నిఙి సప్తెఙ్‌ సుడ్ఃజినార్‌?”, ఇజి మర్‌జి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","యేసు వరిఙ్‌ వెహ్తాన్‌, “నాను బమ్మాతి ఉండ్రి పణి కిత. మిరు విజిదెరె నండొ బమ్మ ఆతిదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","మీరు సునతి కిదెఙ్‌ ఇజి మోసె మిఙి రూలు సిత మనాన్. అందెఙె మీరు కొడొఃదిఙ్‌ విస్రాంతి దినమ్‌దు సునతి కిజినిదెర్. సుడ్ఃదు, మోసె ఆఏన్‌ సునతి మొదొల్‌స్తికాన్, మీ అనిర్‌నె అయాక మొదొల్‌స్తార్. ");
INSERT INTO kfc_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","విస్రాంతిదినమ్‌దు ఒరెన్‌ కొడొఃదిఙ్‌ సునతి కిజినిదెర్. ఎందానిఙ్‌ ఇహిఙ, మోసెఙ్‌ దేవుణు సిత్తి రూలుఙ్‌ తప్తెఙ్‌ ఆఎద్‌ఇజి. అహిఙ, నాను ఒరెన్‌ లోకుదిఙ్‌ విస్రాంతి దినమ్‌దు పూర్తి నెగెణ్‌ కితి వందిఙ్‌ మీరు ఎందానిఙ్‌నా ముస్కు కోపం ఆజినిదెర్‌? ");
INSERT INTO kfc_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","మీరు ముస్కు తోర్‌జిని దన్నివందిఙ్‌ సుడ్ఃజి తీర్పు కిమాట్. గాని నిజమాతికెఙ్‌ సుడ్ఃజి తీర్‌పు కిదు. ");
INSERT INTO kfc_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","నస్తివలె సెగొండార్‌ యెరుసలెమ్‌దికార్, “వినిఙె గదె అతికారిఙు సప్తెఙ్‌ సుడ్ఃజినార్. ");
INSERT INTO kfc_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ఇవిలొన్‌ వీండ్రు దయ్‌రమ్‌దాన్‌ విజెరె ఎద్రు వర్గిజినాన్. గాని వారు వన్నిఙ్‌ ఇనికబా ఇన్‌ఎర్. వీండ్రు క్రీస్తు ఇజి అతికారిఙు నిజమె ఒపుకొటారా? ");
INSERT INTO kfc_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","క్రీస్తు వానివలె, వాండ్రు ఎమేణికాన్‌ ఇజి ఎయెర్‌బా నెస్‌ఏర్. గాని వీండ్రు ఎంబెణికాన్‌ ఇజి మాపు నెస్నాప్”, ఇజి వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","29","అందెఙె యేసు గుడిః అరుఙుదు నేర్‌పిసి మహివలె, ఈహు డటం వెహ్తాన్‌. “నాను ఎయెన్, ఎమేణికాన్‌ ఇజి మీరు నిజం నెస్నిదెరా? నాను నా సొంత ఇస్టందాన్‌ వాతికాన్‌ ఆఎ. గాని నఙి పోక్తాన్‌ ఒరెన్‌ మనాన్. వాండ్రు నిజమాతి దేవుణు. మీరు వన్నిఙ్‌ నెస్‌ఇదెర్. గాని నాను వన్నిఙ్‌ నెస్న. ఎందనిఙ్‌ ఇహిఙ, నాను వన్ని బాణిఙ్‌ వాత మన్న. వాండ్రె నఙి పోక్తాన్”, ఇజి. ");
INSERT INTO kfc_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","యాకెఙ్‌ వెహారె, వారు వన్నిఙ్‌ అస్తెఙ్‌ సుడ్ఃతార్. గాని ఎయెన్‌బా వన్నిఙ్‌ అస్‌ఎతార్. ఎందానిఙ్‌ ఇహిఙ, వాండ్రు అస్పె ఆదెఙ్‌ దేవుణు ఏర్‌పాటు కితి సమయం రెఏదె. ");
INSERT INTO kfc_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","అహిఙ్‌బా లోకుర్‌ లొఇ నండొండార్‌ వన్ని ముస్కు నమకం ఇట్తార్. వారు, “వీండ్రు నండొ బమ్మాని పణిఙ్‌ కిత్తాన్. లోకురిఙ్‌ రక్సిస్తెఙ్‌ దేవుణు ఏర్‌పాటు కితి పోక్తి క్రీస్తు వానివలె, విని ముస్కు మరి నండొ బమ్మాని పణిఙ్‌ వాండ్రు కినాండ్రా?”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","లోకుర్‌ యేసు వందిఙ్‌ అయాకెఙ్‌ మొరొ ఆజినికెఙ్‌ పరీసయిరు వెహర్. నస్తివలె పెరి పుజెరిఙు ని పరిసయ్‌రు వన్నిఙ్‌ తొహ్సి ఒతెఙ్‌ దేవుణు గుడిఃది జమాన్‌ఙ పోక్తార్. ");
INSERT INTO kfc_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","అందెఙె యేసు, “నాను మీ వెట సెగం కాలమ్‌నె మంజినె. వెన్కా నాను నఙి పోక్తి వన్ని డగ్రు సొన్‌సిన. ");
INSERT INTO kfc_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","మీరు నఙి రెబానిదెర్. గాని తొఇదెర్. నాను మన్ని బాన్‌ మీరు వాదెఙ్‌ అట్‌ఇదెర్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","36","నస్తివలె యూదురు అతికారుఙు, ఒరెన్‌వెట ఒరెన్, “వీండ్రు మఙి తోర్‌ఎండ ఎంబె సొండ్రెఙ్‌ సుడ్ఃజినాన్‌? వాండ్రు, సెగొండార్‌ యూదురు మా బాణిఙ్‌ సెద్రిజి బత్కిజిని గ్రీకు పట్నమ్‌కాఙ్‌ సొనాండ్రా? వాండ్రు యూదురు ఆఇ వరిఙ్‌ నేర్‌పిస్నాండ్రా? వాండ్రు వెహ్సినాన్, “మీరు నఙి రెబానిదెర్. గాని తొఇదెర్. నాను మన్ని బాన్‌ మీరు వాదెఙ్‌ అట్‌ఇదెర్‌’ ఇజి. ఎందానిఙ్‌ వాండ్రు ఆహె వెహ్సినాన్‌?”, ఇజి వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","పండొయ్‌ కడెఃవెరి రోజు వాతాద్. కడెఃవెరి రోజునె ముకెలమాతి దినం. అయా నాండిఙ్‌ యేసు నిహండ్రె ఈహు డటం వెహ్తాన్‌. “ఏహ్కి కట్నికాన్‌ ఎయెన్‌బా నా డగ్రు రఅ. నాను వన్నిఙ్‌ ఉండెఙ్‌ సీన. ");
INSERT INTO kfc_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","దేవుణు మాటదు వెహ్తివజ, “నా ముస్కు నమకం ఇడ్తి ఎయెర్‌ గర్బం దాన్‌బా, నిజమాతి బత్కు సీని ఏరు సోసి సొనెలె. అయాక ఉండ్రి ఊట సోసి సొని లెకెండ్‌ సొనెలె. ");
INSERT INTO kfc_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ఇబ్బె యేసు నిజమాతి బత్కు సీని ఏరు ఇజి వెహ్తిక దేవుణు ఆత్మ వందిఙె. యా దేవుణు ఆత్మ, యేసు ముస్కు నమకం ఇడ్తి వరిఙ్, యేసుఙ్‌ దేవుణు మంజిని బాడిఃదు ఒతి వెన్కా దొహ్‌క్నాన్‌లె. గాని యేసు యాక వెహ్తివలె, దేవుణు వన్ని ఆత్మ వన్నిఙ్‌ నమ్మితి వరిఙ్‌ సిఏండ్రె. ఎందానిఙ్‌ ఇహిఙ, దేవుణు యేసుఙ్‌ వన్ని వెట వన్ని గొప్ప జాయ్‌దు మండ్రెఙ్‌ దేవుణు మంజిని బాడిఃదు ఒఏండ్రె. ");
INSERT INTO kfc_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","వన్ని మాటెఙ్‌ వెహరె, లోకుర్‌ లొఇ సెగొండార్, “నిజమె, వీండ్రె మాపు ఎద్రు సుడ్ఃజి మహి ప్రవక్త”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","మరి సెగొండార్, “సిల్లె వీండ్రె క్రీస్తు”, ఇహార్‌. గాని సెగొండార్, “క్రీస్తు ఎలాగ గలీలయదాన్‌ వానాన్‌? ");
INSERT INTO kfc_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","క్రీస్తు దావీదు రాజు కుటుమ్‌దాన్, దావీదు బత్కిజి మహి పట్నమాతి బెత్లెహెమ్‌దాన్‌ వానాన్, ఇజి దేవుణు మాటదు మనాద్‌ గదె”, ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ఆహె వన్ని వందిఙ్‌ లోకుర్‌ ఎర్‌లితార్. ");
INSERT INTO kfc_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","సెగొండార్‌ వన్నిఙ్‌ అస్తెఙ్‌ కోరితార్. గాని ఎయెర్‌బా వన్నిఙ్‌ అస్‌ఏతార్. ");
INSERT INTO kfc_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","అందెఙె యేసుఙ్‌ అస్తెఙ్‌ వాతి దేవుణు గుడిఃది జమానుఙు మర్‌జి పెరి పుజెరిఙ ని పరిసయురుఙ బాన్‌ సొహార్‌. వారు జమాన్‌ఙ, “మీరు ఎందానిఙ్‌ వన్నిఙ్‌ అసి తెఇదెర్‌?”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","దన్నిఙ్‌ వారు, “వీండ్రు వెహ్తి మాటెఙ్‌ లెకెండ్‌ ఎయెర్‌బా ఎసెఙ్‌బా వెహ్‌ఏర్”, ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","పరిసయ్‌రుఙు, “మీరు బా మొసం ఆత్తిదెరా? ");
INSERT INTO kfc_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","అతికారిఙ లొఇనొ పరిసయురుఙ లొఇనొ ఎయెన్‌బా వన్నిఙ్‌ నమితాండ్రా? ");
INSERT INTO kfc_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","గాని యా మంద లోకుర్‌ దేవుణు మోసెఙ్‌ సిత్తి రూలుఙ్‌ నెస్‌ఎర్. అందెఙె వరిఙ్‌ దేవుణు సాయెప్‌ సీనాన్”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","నికొదిమొస్‌ ఇనికాన్‌ ఒరెన్‌ ముఙాలె యేసు డగ్రు సొహ మహాన్‌. వాండ్రు పరిసయిరుఙ లొఇ మన్నికాన్. ");
INSERT INTO kfc_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","నస్తివలె నికొదెము, “మా యూదురి రూలుఙ వజ, ఒరెన్‌ వాండ్రు వెహ్సినికెఙ్‌ మాపు ముఙాల వెంజి, వాండ్రు కితికెఙ్‌ నెస్తి వెన్‌కనె వన్ని ముస్కు తీర్పు కిదెఙ్‌ ఆనాద్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","అందెఙె వారు, “నీను బా గలీలయదాన్‌ వాతికాండ్రా? నీను దేవుణు మాట బాగ సద్‌విఅ. ఒరెన్‌ ప్రవక్తబా గలీలయదాన్‌ సోఏన్, ఇజి నీను నస్తివలె నెస్నిలె”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","వెనుక వారు విజెరె వరివరి ఇల్కాఙ్‌ సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","గాని యేసు ఒలివ గొరొత్‌సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","జాయ్‌ ఆతివెలె మరి వాండ్రు దేవుణు గుడిఃది అరుఙుదు వాతాన్. లోకుర్‌ విజెరె వాజి వన్నిడగ్రు కూడిఃతార్. వాండ్రు బస్తాండ్రె వరిఙ్‌ నెస్‌పిసినాన్. ");
INSERT INTO kfc_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","4","నస్తివలె పరిసయ్‌రుని యూదురి రూలుఙ్‌ నెస్పిస్నికార్‌ ఉండ్రి బోదెల్‌దిఙ్‌ తతార్. అది, రంకు బూలాజి మహివలె వారు దన్నిఙ్‌ అస్తార్. వారు దన్నిఙ్‌ మంద ఎద్రు నిల్‌ప్తారె యేసుఙ్, “బోదకినికిదా, యా బోదెల్‌ రంకు బూలాజి మహివలె, మాపు అస్తాప్. ");
INSERT INTO kfc_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","మోసె మఙి రూలు సితివెలె మఙి ఆడ్ర వెహ్తాన్‌, “ఆహె బూలాని వన్కాఙ్‌ పణకాణిఙ్‌ డెఃయిజి సప్తెఙ్‌’ ఇజి. గాని నీను ఇనిక వెహ్సిని”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","వన్ని ముస్కు నేరం మోప్తెఙ్‌ ఇజి వన్నిఙ్‌సికుదు అర్‌ప్తెఙ్‌ అహు వెన్‌బాతార్. గాని యేసువఙితాండ్రె బూమిదు వన్ని డెఃస్కదాన్‌రాసి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","వారు మరిమరి వెన్‌బాజి మహిఙ్, వాండ్రు బుర్ర పెహ్తండ్రె వరిఙ్, “మీ లొఇ పాపం కిఇకాన్‌ ముఙాల దన్నిఙ్‌ పణుకుదాన్ డెఃయ్‌దు”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","వెహ్తండ్రె వాండ్రు మరి వఙ్‌జి, బూమిదు రాసి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","గాని వారు యా మాటెఙ్‌ వెహారె, ఒరెన్‌ వెన్కా ఒరెన్‌ డిఃస్త సొహార్‌. ముఙాలె పెరికార్‌ సొహార్‌. వెన్కా ఇజ్రికార్. ఆహె విజెరె సొహార్‌. యేసుని అయా బోదెల్‌ని బాన్‌ మహార్‌. అది నిహిమహిబానె మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","యేసు బుర్ర పెహ్తండ్రె, దనిఙ్, “వారు ఎంబె మనార్‌? ఎయెర్‌బా, నిఙి తీర్పు సీజి సిక్స సిఎరా?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“సిల్లె బాబు”, ఇహాద్‌‌ అది.అందెఙె యేసు, “అహిఙ, నానుబా, నిఙి తీర్పు సీజి సిక్స సిఏ. సొన్‌అ. ఏలుదాన్‌ మరి పాపం కిమా”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","మరి, యేసు లోకురిఙ్‌ వెహ్సినాన్, “నానె లోకమ్‌ది లోకురిఙ్‌ జాయ్‌. నా సిసూ ఆనికాన్‌ ఎయెన్‌బా సీకటుదు మన్‌ఎన్. గాని వన్నిఙ్‌ బత్కు సీని జాయ్‌ మంజినాద్‌'. ");
INSERT INTO kfc_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","నస్తివలె పరిసయ్‌రు వన్నిఙ్, “నీనె నీ వందిఙ్‌ సాక్సి వెహ్సిని, మరి ఎయెర్‌బా అయాక నిజం ఇజి వెహ్‌ఎండ. అందెఙె నీ సాక్సమ్‌దిఙ్‌ నిజం సిల్లెద్‌”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","అందెఙె యేసు వెహ్తాన్‌, “నానె నా వందిఙ్‌ సాక్సి వెహ్సిన. అహిఙ్‌బా నాను వెహ్తి సాక్సి నిజమ్‌నె. ఎందానిఙ్‌ ఇహిఙ, నాను ఎమెణాఙ్‌ వాత, ఎంబె సొన్‌సిన ఇజి నాను నెస్న. గాని మీరు నెస్‌ఇదెర్‌ నాను ఎమెణాఙ్‌ వాత ఎంబె సొన్‌సిన ఇజి. ");
INSERT INTO kfc_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","మీరు లోకుర్‌ సుడ్ఃజినికెఙ్‌ సుడ్ఃజి తీర్‌పు సీజినిదెర్. గాని నాను అయాలెకెండ్‌ ఎయెరిఙ్‌బా తీర్‌పు సిఏ. ");
INSERT INTO kfc_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","నాను తీర్‌పు సితిఙ్‌బా నాను సిత్తి తీర్పు నిజమ్‌నె. ఎందానిఙ్‌ ఇహిఙ, నాను ఒరెనె ఆఏ తీర్పు సీజిన. నఙి పోక్తి బుబ్బ నా వెట మనాన్. ");
INSERT INTO kfc_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","దేవుణు మోసెఙ్‌ సిత్తి మీ రూలుఙ్‌దు రాస్త మనాద్, ‘రిఏర్‌ వెహ్సిని సాసి ఉండ్రె లెకెండ్‌ మహిఙ, అయాక నిజం ఇజి'. ");
INSERT INTO kfc_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","నానె నా వందిఙ్‌ సాక్సి వెహ్సిన. మరి నఙి పోక్తి నా బుబ్బ బా నా వందిఙ్‌ సాసి వెహ్సినాన్”. ");
INSERT INTO kfc_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","నస్తివలె వారు వన్నిఙ్, “ఎంబె నీ బుబ్బ మనాన్‌?”, ఇజి వెన్‌బాతార్. దన్నిఙ్‌ యేసు”, మీరు నఙి నెస్‌ఇదెర్. నా బుబ్బెఙ్‌ నెస్‌ఇదెర్. మీరు నఙి నెస్నికిహిఙ, నా బుబ్బెఙ్‌బా నెస్తిదెర్‌ మరి”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","వాండ్రు యా మాటెఙ్‌ దేవుణు గుడిఃదు సంత అర్‌ప్ని పెటెఙ్‌ ఇడ్నిబాన్‌ మంజి నెస్‌పిసి మహివలె వెహ్తాన్‌. గాని ఎయెన్‌బా వన్నిఙ్‌ అస్‌ఏతార్. ఎందానిఙ్‌ ఇహిఙ, వన్నిఙ్‌ అస్తెఙ్‌ దేవుణు ఎత్తు కిత్తి సమయం రెఏదె. ");
INSERT INTO kfc_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","మరి యేసు వరిఙ్, “నాను సొనాలె. మీరు నఙి రెబానిదెర్. మీరు పాపమ్‌కు కిజి మంజినె సానిదెర్. నాను సొని బాడిఃదు మీరు వాదెఙ్‌ అట్‌ఇదెర్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","అందెఙె యూదురు ఒరెన్‌ వెట ఒరెన్, “వన్నిఙ్‌ వాండ్రె సపె ఆనాండ్రా? వాండ్రు వెహ్సినాన్‌ గదె నాను సొని బాడిఃదు మీరు వాదెఙ్‌ అట్‌ఇదెర్‌ ఇజి’, ఇజి వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","యేసు వరిఙ్‌ ఈహు వెహ్తాన్‌‌: “మీరు ఇబ్బె యా లోకమ్‌దికిదెర్. గాని నాను ముస్కు దేవుణు మంజిని బాడిదికాన్. మీరు యా లోకమ్‌దికిదెర్. నాను ఇబ్బెణికాన్‌ ఆఎ. ");
INSERT INTO kfc_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","నాను మిఙి వెహ్త మన్న మీరు పాపం కిజి మంజినె సానిదెర్‌ ఇజి. నాను ఎయెన్‌ ఇజి వెహ్సినానొ, నానె వాండ్రు ఇజి మీరు నమ్మిఎండ మహిఙ, మీరు నిజమ్‌నె పాపమ్‌దు మంజినె సానిదెర్”. ");
INSERT INTO kfc_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","వారు వన్నిఙ్, “నీను ఎయెన్?”, ఇజి వెన్‌బాతార్. ‘నాను ఎయెన్‌ ఇజి మొదొహనె వెహ్త మనానో, నానె వాండ్రు’, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","యేసు మరి వెహ్తాన్‌ “మీ వందిఙ్‌ నండొ వెహ్తెఙ్‌ నఙి మనాద్. మీ ముస్కు నండొ తీర్‌పుఙ్‌బా మనాద్. గాని నఙి పోక్తాన్‌ నిజామాతికాన్. వాండ్రు నఙి వెహ్తి సఙతిఙ్‌నె నాను లోకమ్‌ది లోకురిఙ్‌ వెహ్తిన. ");
INSERT INTO kfc_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","వాండ్రు దేవుణు మంజిని బాడిఃదు మన్ని వన్ని బుబ్బ వందిఙె వరిఙ్‌ వెహ్సినాన్‌ ఇజి వారు అర్దం కిఎతార్. ");
INSERT INTO kfc_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","అందెఙె యేసు వరిఙ్, “మీరు లోకు మరిసి ఆతి నఙి సిలువాదు సప్నివెలె, మీరు నస్నిదెర్, నాను ఎయెన్‌ ఇజి. మరి, నాను నా సొంత అతికారం దాన్‌ ఇనికబా కిఎ. గాని నా బుబ్బ నఙి నెస్‌పిస్తివజనె నాను వెహ్సిన, ఇజి మిరు నెస్నిదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","నఙి పోక్తాన్‌ నఙి తోడుః మంజినాన్. వాండ్రు నఙి ఒరెన్‌ వన్నిఙె డిఃస్‌ఎతాన్. ఎందానిఙ్‌ ఇహిఙ వన్నిఙ్‌ ఇస్టం వాతికెఙె నాను ఎస్తివలెబా కిజిన”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","వాండ్రు యా మాటెఙ్‌ వెహ్తివలె నండొండార్‌ వన్ని ముస్కు నమకం ఇడ్తార్. ");
INSERT INTO kfc_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","వన్ని ముస్కు నమకం ఇడ్తి యూదురిఙ్‌ వాండ్రు వెహ్తాన్‌, “నాను వెహ్తి మాటెఙ్‌ లొఙిజి మహిఙ, మీరు నిజమ్‌నె నా సిసూర్‌ ఆనిదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","నస్తివలె మీరు దేవుణు వందిఙ్‌ నిజమాతికెఙ్‌ నెస్నిదెర్. అయాక మిఙి పాపమ్‌కాణిఙ్‌ డిఃస్‌పిస్నాద్”. ");
INSERT INTO kfc_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","వారు వన్నిఙ్, “మాపు అబ్రాహము తెగ్గదు పుట్తికాప్. మాపు ఎసెఙ్‌బా ఎయె అడిఃగి వెట్టిపణి మణిసిర్‌ లెకెండ్‌ మన్‌ఎపె. నస్తివలె ‘మీరు డిఃబె ఆనిదెర్‌’, ఇజి ఎలాగ వెహ్సిని”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","అందెఙె యేసు, “ఒరెన్‌ వెట్టిపణి కినికాన్, ఎలాగ తొహె ఆతి మన్ని వజ ఎజమాని అడిఃగి మంజి నాండ్రొ, అయాలెకెండ్‌ పాపం కిని విజెరె పాపమ్‌దిఙ్‌ అడిఃగి తొహె ఆతి లెకెండ్‌ మంజినాన్. ");
INSERT INTO kfc_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ఒరెన్‌ వెట్టిపణి కినికాన్‌ అక్కు మన్ని వన్ని లెకెండ్‌ ఎలాకాలం అయా ఇండ్రొ మండ్రెఙ్‌ అట్‌ఎన్. గాని అయా ఇండ్రొణి మరిసిఙ్‌ ఎలాకాలం అయా ఇండ్రొ అక్కు మంజినాద్. ");
INSERT INTO kfc_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","అందెఙె దేవుణు మరిసి మిఙి తొహె ఆతి బాణిఙ్‌ డిఃస్‌పిస్తిఙ, మీరు నిజమ్‌నె డిఃబెఆనిదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","నాను నెస్న మీరు అబ్రాహము తెగ్గాతికిదెర్‌ ఇజి. గాని మీరు నఙి సప్తెఙ్‌ సుడ్ఃజినిదెర్. ఎందానిఙ్‌ ఇహిఙ నాను వెహ్సిని మాటెఙ్‌ మిఙి పడిఃఉ. ");
INSERT INTO kfc_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","నా బుబ్బ నఙి తోరిస్తికెఙ్‌ నాను వెహ్సిన. గాని మీరు మీ బుబ్బ వెహ్సినికెఙ్‌ కిజినిదెర్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","నస్తివలె వారు, “అబ్రహమునె మా బుబ్బ”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","“మీరు అబ్రాహము కొడొఃర్‌ ఇహిఙ, మీరు అబ్రాహము కితి పణిఙ్‌నె కితిదెర్‌ మరి. దేవుణు బాణిఙ్‌ నాను వెహికెఙె మిఙి వెహ్తెఙ్‌ నాను ఎసెఙ్‌బా సుడ్ఃత. గాని మీరు నఙి సప్తెఙ్‌ సుడ్ఃజినిదెర్. అబ్రాహము యా లెకెండ్‌ ఇనికబా కిఎన్. ");
INSERT INTO kfc_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","మీ బుబ్బ కిజినికెఙె మీరు బా కిజినిదెర్”, ఇజి వెహ్తాన్‌. అయావలె వారు, “మాపు అప్పొసి వెట పుట్తికాపె. దేవుణు ఒరెండ్రె మా బుబ్బ”, ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","అందెఙె యేసు వరిఙ్‌ ఈహు వెహ్తాన్‌‌: “దేవుణునె మీ బుబ్బ ఇహిఙ, మీరు నఙి ప్రేమిస్తిదెర్‌ మరి. ఎందానిఙ్‌ ఇహిఙ, నాను దేవుణు బాణిఙ్‌ వాత. నాను యేలు ఇబ్బె మన్న. నాను నా సొంత ఇస్టమ్‌దాన్‌ రెఏత. గాని వాండ్రు నఙి పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ఎందానిఙ్‌ నాను వెహ్సిని మాటెఙ్‌ మీరు అర్దం కిఇదెర్‌? ఎందానిఙ్‌ ఇహిఙ, నాను వెహ్సిని మాటెఙ్‌ వెండ్రెఙ్‌ మీరు కెఇదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","మీ బుబ్బ సయ్‌తానె. మీరు వన్ని కొడొఃర్. మీరు వన్నిఙ్‌ ఇస్టం ఆతికెఙ్‌ కిదెఙ్‌ కోరిజినిదెర్. మొదొహన్‌ అసి వాండ్రు సప్నికాన్. వాండ్రు నిజమాతి బాడిఃదు నిల్‌ఏన్. ఎందానిఙ్‌ ఇహిఙ, వన్ని లొఇ నిజమాతికెఙ్‌ సిల్లు. వాండ్రు అబద్దం వర్గినివలె, వన్ని సొంత బుద్దిదాఙె వర్గిజినాన్. ఎందానిఙ్‌ ఇహిఙ, వాండ్రు అబద్దం వర్గినికాన్. అబద్దం వర్గిని వరి అపొసి. ");
INSERT INTO kfc_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","గాని నాను దేవుణు వందిఙ్‌ నిజమాతికెఙ్‌ వెహ్సిన. అందెఙె మీరు నఙి నెస్‌ఇదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","మీ లొఇ ఎయెన్‌బా నాను తపు కితికాన్‌ ఇజి రుజుప్‌ కిదెఙ్‌ అట్‌నాండ్రా? నాను నిజమాతికెఙ్‌ వెహ్తిఙ, ఎందానిఙ్‌ మీరు నఙి నమిఇదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","దేవుణు కొడొఃర్‌ ఆతికార్‌ వన్ని మాటెఙ్‌ వెనార్. మీరు దేవుణు కొడొఃర్‌ ఆఇదెర్. అందెఙె నా మాటెఙ్‌ వెన్‌ఇదెర్”. ");
INSERT INTO kfc_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","నస్తివలె యూదురు వన్నిఙ్, “నీను సమరియదికి, నిఙి దెయం అస్తాద్‌ ఇజి మాపు వెహ్సిని మాటదు తపు ఇనికబా మనాదా?”, ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","నఙి దెయం అస్‌ఏద్. నాను నా బుబ్బెఙ్‌ గవ్‌రం సీజిన. గాని మీరు నఙి కరాయి ఇజినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","నాను నా వందిఙ్‌ గవ్‌రం అన్‌పె ఆదెఙ్‌ సుడ్ఃఎ. గాని అయాకెఙ్‌ సుడ్ఃజినాన్‌ ఒరెన్‌ మనాన్. వాండ్రె నా వందిఙ్‌ నాయమ్‌దాన్‌ తీర్పు సీజినికాన్. ");
INSERT INTO kfc_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","నా మాటెఙవజ బత్కినికాన్‌ ఎయెన్‌బా సాఎన్, ఇజి నాను నిజం మీ వెట వెహ్సిన”, ఇజి మర్‌జి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","అయావలె యూదురు, “ఏలు మాపు నెస్నాప్‌ నీను దెయం అస్తికి ఇజి. అబ్రాహము సాతాన్. అయా లెకెండ్‌ ప్రవక్తరుబా సాతార్. గాని నీను వెహ్సిని, ‘నా మాటెఙ వజ బత్కిజినికాన్‌ ఎయెన్‌బా సాఏన్‌’, ఇజి. ");
INSERT INTO kfc_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","నీను మా బుబ్బ ఆతి అబ్రాహము ఇంక పెరికిదా? వాండ్రు సాతాన్. అయా లెకెండ్‌ ప్రవక్తరు బా సాతార్. నీను ఎయెన్‌ ఇజి నీను ఒడ్ఃబిజిని?”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","అందెఙె యేసు, “నానె నఙి పొగ్‌డిఃతిఙ దనిఙ్‌ విలువ సిల్లెద్‌. గాని నఙి పొగ్‌డిఃనికాన్‌నా బుబ్బనె. వన్నిఙె మీరు, మా దేవుణు ఇజి వెహ్సినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","మీరు వన్నిఙ్‌ నెస్‌ఇదెర్. గాని నాను వన్నిఙ్‌ నెస్న. నాను వన్నిఙ్‌ నెస్‌ఏ ఇజి వెహ్తిఙ, మీ లెకెండ్‌ ఒరెన్‌ అబద్దం వర్గినికాన్‌ ఆత మరి. గాని నాను వన్నిఙ్‌ నెస్న. వన్నిమాటెఙ వజ బత్కిజిన. ");
INSERT INTO kfc_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","మీ బుబ్బాతి అబ్రాహము, నాను వాని దినం సుడ్ఃదెఙ్‌ అట్న ఇజి సర్‌ద ఆతాన్. వాండ్రు అయా దినం సుడ్ఃతాండ్రె సర్‌ద ఆతాన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","నిఙి ఏలు యాబయ్‌ పంటెఙ్‌బా సిల్లు. నీను అబహమ్రుఙ్‌ సుడ్ఃతిదా?”, ఇజి యూదురు వన్నిఙ్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","అందెఙె యేసు, “అబ్రాహము పుట్‌ఏండ ముఙాలె నాను మన్న ఇజి నిజం మీ వెట వెహ్సిన”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","యాక వెహిఙ్, వారు వన్నిఙ్‌ డెఃయ్‌దెఙ్‌ పణుకు పెహ్తర్. గాని వాండ్రు డాఃఙితాండ్రె గుడిఃదాన్‌ సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","యేసు సొన్సి మహివలె, పుట్తిబాణిఙ్‌ అసి గుడ్డి ఆతి ఒరెన్‌వన్నిఙ్‌ సుడ్ఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","నస్తివలె వన్నిసిసూర్‌ వన్నిఙ్, “బోదకినికి, ఎయెర్‌ పాపం కితిఙ్‌ వీండ్రు గుడ్డిదాన్‌ పుట్తాన్‌? వీండ్రునా విన్ని అయ్‌సి అప్పొసిర్‌నా?”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","అందెఙె యేసు, “వీండ్రు పాపం కితిఙ్‌ ఆఏద్, విన్ని అయ్‌సి అప్పొసిర్‌ పాపం కితిఙ్‌ ఆఏద్. గాని దేవుణు ఒరెండ్రె కిదెఙ్‌ అట్ని పణి వినిలొఇ సుడ్ఃదెఙె వీండ్రు గుడ్డి ఆతాండ్రె పుట్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","వేడె మనివలె, మాటు నఙి పోక్తివన్ని పణి కిదెఙ్‌వలె. సీకట్‌ బేగి ఆనాద్. అయావలె ఎయెర్‌బా ఇనికబా కిదెఙ్‌ అట్‌ఏర్. ");
INSERT INTO kfc_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","నాను యా లోకమ్‌దు మనివలె, యా లోకమ్‌దివరిఙ్‌ జాయ్‌లెకెండ్‌ మన”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","వెహ్తాండ్రె, వాండ్రు బూమిదు పూస్తాన్. వన్ని పూసవలిదాన్‌ కండెక్‌ బుర్‌ద కితాండ్రె, అయా బుర్ద గుడిః వన్ని కణకెఙ ముస్కు రాస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","రాస్తాండ్రె, “నీను సొన్సి సిలొయొము ఇన్ని గుమ్మిదు కణుకు నొరె ఆఅ”, ఇజి వెహ్తాన్‌. (సిలొయొము ఇన్ని మాటదిఙ్‌ పోక్తికాన్‌ ఇజినె అర్దం) వాండ్రు సొహాండ్రె నొరె ఆతాన్. వన్ని కణుకు నెగెణ్‌ఆతె. వాండ్రు మర్‌జి వాతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","అయావలె వన్ని పడఃకాదికార్‌ని వాండ్రు ముఙాలె లొస్‌పానిక సుడిఃతి మహికార్‌ వెన్‌బాతార్, “వీండ్రు అబ్బె బసి లొసి మహికాన్‌గదె”, ఇజి. ");
INSERT INTO kfc_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","సెగొండార్, “వీండ్రె”, ఇజి. మరి సెగొండార్, “సిలె, వినిలెకెండ్‌ మన్ని మరి ఒరెనె”, ఇహార్‌. గాని వాండ్రు, “నానె లొస్‌పాజి మహికాన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","అయావలె వారు, “నీ కణుకు ఎలాగ రెకె ఆతె?”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","అందెఙె వాండ్రు, “యేసు ఇజి కూక్ని ఒరెన్‌బుర్‌ద కితాండ్రె నా కణకెఙ ముస్కు రాస్తాన్. సిలొయము ఇన్ని గుమ్మిదు సొన్సి నొరె ఆఅ, ఇహాన్‌. అందెఙె నాను సొన్సి నొరె ఆత్తిఙ్‌నాను సుడ్ఃదెఙ్‌ అట్త”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“ఎంబె మనాన్‌ అయా వాండ్రు”, ఇజి వారు వెన్‌బాతార్. “ఏమొ నాను నెస్‌ఏ”, ఇహాన్‌ వాండ్రు. ");
INSERT INTO kfc_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ముఙాల గుడ్డిదాన్‌ మహివన్నిఙ్‌ వారు పరిసయ్‌రుఙు డగ్రు తత్తార్. ");
INSERT INTO kfc_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ఉండ్రి విస్రాంతి నాండిఙె, యేసు బుర్ద కితాండ్రె అయా వన్ని కణుకు నెగెణ్‌ కిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","పరిసయ్‌రు బా నీను ఎలాగ బేస్తెఙ్‌ అట్తి ఇజి వెన్‌బాతార్. వాండ్రు, “అయా వాండ్రు నా కణుకు ముస్కు బుర్ద రాస్తాన్. నాను నొర్‌బాత. ఏలు నాను బేసిన”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","అందెఙె సెగొండార్‌ పరిసయ్‌రు, “యా వాండ్రు దేవుణు బాణిఙ్‌వాతికాన్‌ఆఎన్. ఎందానిఙ్‌ ఇహిఙ, విస్రాంతిదినమ్‌దు అహు కిజి వాండ్రు రూలుఙ్‌ తప్సినాన్”, ఇహార్‌. గాని మరి సెగొండార్, “ఒరెన్‌పాపం కిజినికాన్‌ ఎలాగ నిసొ బమ్మాని పణిఙ్‌ కిదెఙ్‌ అట్నాన్”, ఇహార్‌. ఆహె వారు కేటెఙ్‌ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","అందెఙె పరిసయ్‌రు మరి అయా గుడిఃదాన్‌ మహి వన్నిఙ్, “వాండ్రు నీ కణుకునె రేక్తాన్. అందెఙె నీను వన్ని వందిఙ్‌ ఇన్నిక వెహ్సిని”, ఇజి వెన్‌బాతార్. దనిఙ్‌ వాండ్రు, “వాండ్రు ఒరెన్‌ ప్రవక్త”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","యా యూదురు అదికారిఙు, వీండ్రు గుడిఃదాన్‌ మహాన్‌. వీండ్రు ఏలు రెకె ఆతండ్రె బేసినాన్‌ ఇజి నమ్మిఏతార్. అందెఙె వారు వన్ని అయిసి అపొసిఙ్‌ రపిస్తార్. ");
INSERT INTO kfc_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","రపిస్తారె వరిఙ్, “వీండ్రు మీ మరీన్‌నా? వీండ్రునా గుడిదాన్‌పుట్తాన్‌ఇజి మీరు వెహ్సినిదెర్. అహిఙ, ఏలు వాండ్రు ఎలాగ బేసినాన్‌?”, ఇజి వరిఙ్‌ వెన్‌బాతార్. అహు వెన్‌బాని దాక, వాండ్రు గుడిదాన్‌ మహాన్‌. వాండ్రు నెగెణ్‌ఆతాండ్రె బేసినాన్‌ ఇజి నమ్మిఏతార్. ");
INSERT INTO kfc_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","వన్ని అయిసి అప్పొసిర్‌ వెహ్తార్‌, “వీండ్రు మా మర్రిన్, ఇజి మాపు నెస్నాప్. వీండ్రు గుడిః దాన్‌పుట్తాన్‌ఇజి బా నెస్నాప్. ");
INSERT INTO kfc_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","గాని ఏలు వాండ్రు ఎలాగ బేసినాన్‌ ఎయెన్‌వన్ని కణుకు రెక్తాన్‌ఇన్నిక మాపు నెస్‌ఎప్. వాండ్రు బుద్ది వాతికాన్‌గదె. వన్నిఙ్‌వెన్‌బాదు. వాండ్రు వన్నిఙ్‌జర్గితిక వెహ్నన్”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","వన్ని అయిసి అపొసిర్‌ ఆహె వెహ్తార్‌. ఎందానిఙ్‌ ఇహిఙ వారు యూదురి అదికారిఙ తియెల్‌ ఆతార్. యా యూదురు ఉండ్రి తిరుమానం కిత మహార్‌. ఎయెన్‌బా యేసు క్రీస్తు ఇజి ఒప్పుకొటిఙ వన్నిఙ్‌యుదురి మీటిఙ్‌ ఇండ్రొదాన్‌ వెల్లి కిదెఙ్‌ ఇజి. ");
INSERT INTO kfc_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","అందెఙె వన్ని అయ్‌సి అప్పొసిర్, వాండ్రు బుద్ది వాతికాన్‌గదె, వన్నిఙ్‌వెన్‌బాదు”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","అందెఙె యూదురు అతికారిఙు మరిబా గుడిదాన్‌మహి వన్నిఙ్‌ కూక్‌పిస్తార్. కూక్‌పిస్తారె, “నీను దేవుణుదిఙ్‌ పొగిడిఃజి వెహ్‌అ. నిఙి నెగెణ్‌ కితాన్‌ ఇజి నీను వెహ్సిని యా వాండ్రు పాపం కిజినికాన్‌ ఇజి మాపు నెసినాప్”, ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","నస్తివలె వాండ్రు, “వాండ్రు పాపం కిజినికానొ సిలెనొ ఇజి నాను నెస్‌ఏ. ఉండ్రి నాను నెస్న. నాను గుడిఃదాన్‌ మహ. ఏలు నాను బేసిన”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","వారు వన్నిఙ్, “వాండ్రు నిఙి ఇనిక కిత్తాన్‌? వాండ్రు ఎలాగ నీ కణుకు రెక్తాన్‌?”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","అందెఙె వాండ్రు, నాను ముఙాలె మిఙి వెహ్త మన. గాని మీరు విన్‌ఇదెర్. ఎందానిఙ్‌ మీరు మరిబా విండ్రెఙ్‌? మీరుబా వన్ని సిసూర్‌ఆదెఙ్‌ కోరిజినిదెరా?”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","“నీను బా వన్ని సిసూనె. మాపు మోసె సిసూర్‌ఙ. ");
INSERT INTO kfc_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","దేవుణు మోసెవెట వర్గితాన్‌ ఇజి మాపు నెసినాప్. గాని అయా వాండ్రు ఎమేణికాన్‌ ఇజి మాపు నెస్‌ఏప్”, ఇజి వారు వన్నిఙ్‌నండొ దూసిస్తార్. ");
INSERT INTO kfc_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","అందెఙె వాండ్రు ఈహు వెహ్తాన్‌, “అబ్బ గొప్ప పణి యాక! వాండ్రు ఎమేణికాన్‌ ఇజి మీరు నెస్‌ఇదెర్‌ గాని వాండ్రు నా కణుకు రెక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","దేవుణు పాపం కినివరి మొరొ విన్‌ఏన్‌ ఇజి మాటు నెస్నాట్. వన్నిఙ్‌ గవ్‌రం సీజి వన్నిఙ్‌ ఇస్టం ఆతి పణిఙ్‌కిని వరి మొరొ వాండ్రు వినాన్. ");
INSERT INTO kfc_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","యాయ పొటలొఇహనె గుడిదాన్‌ మహివన్ని కణుకు ఎయెన్‌బా ఎసెఙ్‌బా రెక్తిక విన్‌ఏర్. ");
INSERT INTO kfc_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","నా కణుకు రేక్తి యా వాండ్రు దేవుణు బాణిఙ్‌వాతికాన్‌ ఆఏన్‌ఇహిఙ నఙి నెగెణ్‌కిదెఙ్‌అట్‌ఏతాన్‌మరి”. ");
INSERT INTO kfc_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","దన్నిఙ్‌ వారు, “నీను పాపమ్‌దానె పుట్తికి. ఏలు మఙి నెస్‌పిస్తెఙ్‌ వాజినిదా?”, ఇజి వెహ్తరె వన్నిఙ్‌వెల్లి కితార్. ");
INSERT INTO kfc_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","అయా గుడ్డిదాన్‌ మహివన్నిఙ్‌ పరిసయ్‌రు వెల్లి కిత్తార్‌ ఇజి యేసు విహన్. వాండ్రు వన్నిఙ్‌ సుడ్ఃతివెలె, “నీను లోకు మరిసిఙ్‌ నమిజినిదా?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","వెన్‌బాతిఙ్‌ వాండ్రు, “బాబు నాను వన్నిఙ్‌ నమిదెఙ్‌ వాండ్రు ఎయెన్‌ ఇజి నఙి వెహ్‌అ”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","అయావలె ఏలు, “నీను యేలు వన్నిఙ్‌సుడ్ఃతి మన్ని. వాండ్రె నీ వెట వర్గిజినికాన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","నస్తివలె వాండ్రు, “ప్రబువా, నాను నిఙి నమిజిన”, ఇహండ్రె యేసు పాదమ్‌కాఙ్‌ ముణుకుఙ్‌ ఊర్‌జి మాడిఃస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","అందెఙె యేసు, “నాను లోకురిఙ్‌కేట కిదెఙె వాత మన. గుడివారు బేస్తెఙ్‌ బేస్నికార్‌ గుడిః ఆదెఙ్‌ నాను వాత మన”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","నస్తివలె వన్నిడగ్రు నిహి మహి సెగొండార్‌ పరిసయ్‌రు వాండ్రు వెహ్సినిక విహర్. విహరె, “ఇనిక? మాపు బా గుడిదికాపా?”, ఇజి వెన్‌బాతార్. ");
INSERT INTO kfc_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","అందెఙె యేసు, “మీరు గుడిఃదికిదెర్‌ ఇహిఙ, దేవుణు మీ పాపమ్‌కు లెక్క కిఏతాన్‌ మరి. గాని ‘మాపు సుడ్ఃజినాప్‌’ ఇజి మీరు వెహ్సినిదెర్. అందెఙె మీ లొఇ పాపమ్‌కు నిహె మనె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“గొర్రెఙ సాలదు, సరిదాన్‌ డుగ్‌ఏండ, ఆఇ సరిదాన్‌ డుగ్నికాన్‌ డొఙారి కఙరి ఆత మనాన్. ");
INSERT INTO kfc_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","గాని సరిదాన్‌ డుగ్నికాన్‌ గొర్రెఙ్‌ గవుడుఃయెన్. ");
INSERT INTO kfc_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","సాలదిఙ్‌ రెయ్‌క కాప్‌కినికాన్, వన్నివందిఙ్‌ సేహ్లె రేనాన్. గొర్రెఙ్‌ వన్నికంటం వెన్నె. వాండ్రు వన్నిసొంత గొర్రెఙ పేరు అసి కూక్సి వన్కాఙ్‌ వెల్లి సోప్నాన్. ");
INSERT INTO kfc_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","వన్ని సొంతవనకాఙ్‌ విజు వెల్లి సోప్తి వెనుక, గొర్రెఙ ముఙాల వాండ్రు నడిఃనాన్. గొర్రెఙ్‌ వన్ని కంటం నెస్నె. అందెఙె అవి వన్నివెట సొనె. ");
INSERT INTO kfc_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","గాని నెస్‌ఇవన్ని కంటం అవి నెస్‌ఉ. అందెఙె వన్నివెట సొన్‌ఏండ, అవి వన్నిబాణిఙ్‌ ఉహ్‌క్నె, ఇజి నాను నిజం మీవెట వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","యేసు అబ్బె నిహిమహివరిఙ్‌ కతవజ యాక నెస్‌పిస్తాన్. గాని వారు వాండ్రు వెహ్సినిదనిఙ్‌ అర్‌దం కిఏతార్. ");
INSERT INTO kfc_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","అందెఙె వాండ్రు మరి వరివెట ఈహు వెహ్తాన్‌‌: “నాను నిజం మీవెట వెహ్సిన, నానె గొర్రెఙ్‌ సరిలెకెండ్‌ మన్న. ");
INSERT INTO kfc_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","నా ముఙాల వాతికార్‌ విజెరెబా డొఙారి కఙరి ఆత మనార్. గాని గొర్రెఙ్‌ వరిఙ్‌ విన్‌ఉతె. ");
INSERT INTO kfc_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","నాను దేవుణుడగ్రు సొండ్రెఙ్‌ సరిలెకెండ్‌ మన్న. నా వెట డుఃగ్నికాన్‌ ఎయెన్‌బా నెగ్రెండ మంజినాన్. వాండ్రు లొఇ సొన్సి వెల్లి వాజి మేత మేజి మంజినాన్. ");
INSERT INTO kfc_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","డొఙారి డొఙ కిదెఙ్‌నొ, సప్తెఙ్‌నొ పాడు కిదెఙ్‌నొ వానాన్. మరి ఇన్నిదనిఙ్‌బా రెఏన్. నాను నఙి వెనివరిఙ్‌ దేవుణువెట ఎలాకాలం బత్కిని బత్కు సీని వందిఙె వాత మన్న. అయాక పూర్తి సీని వందిఙె వాత మన్. ");
INSERT INTO kfc_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","నాను గొర్రెఙ నెగ్గి గవుడుయెన్. నెగ్గి గవుడుయెన్‌ గొర్రెఙ వందిఙ్‌ వన్ని పాణం సీనాన్. ");
INSERT INTO kfc_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","జీతం వందిఙ్‌ గొర్రెఙ్ అడిజినికాన్‌ గవుడుయెన్‌ ఆఏన్. అక్కెఙ్‌ వన్ని సొంతగొర్రెఙ్‌ ఆఉ.అందెఙె దుమాల్‌గొండి వాజినిక సుడ్ఃజి గొర్రెఙడిఃసి ఉహ్‌క్నాన్. అయావలె దుమాల్‌గొండి వన్కాఙ్‌ అసి సెద్రిస్నాద్. ");
INSERT INTO kfc_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","వాండ్రు జీతం వందిఙ్‌ అడిజినాన్. గొర్రెఙ ముస్కు వన్నిఙ్‌ బాజిత సిల్లెద్‌. అందెఙె వాండ్రు డిఃస్న ఉహ్‌క్నాన్. ");
INSERT INTO kfc_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","నాను గొర్రెఙ నెగ్గి గవుడుఃయెన్. బుబ్బ నఙి ఎలాగ నెసినాండ్రొ, నాను బుబ్బెఙ్‌ ఎలాగ నెసినానొ, అయావజ నాను గొర్రెఙ నెసిన. నా గొర్రెఙ్‌ నఙి నెసినె. నాను గొర్రెఙవందిఙ్‌ నా పాణం సీజిన. ");
INSERT INTO kfc_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","యా మందదు మనికెఙ్‌ ఆఏండ, మరి సెగం గొర్రెఙ నఙి మన్నె. వన్కాఙ్‌బా నాను పేర్‌జి తత్తెఙ్‌వెలె. అవి నా కంటం వినె. అయావలె మంద ఉండ్రె ఆనాద్. గవుడుఃయెన్‌ ఒరెన్‌ ఆనాన్. ");
INSERT INTO kfc_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","నాను మర్‌జి బత్కినివందిఙె, నా పాణం సీజిన. అందెఙె నా బుబ్బ నఙి ప్రేమిస్నాన్. ");
INSERT INTO kfc_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ఎయెన్‌బా నా పాణం నా బాణిఙ్‌ లాగ్‌ఏన్. నా సొంత ఇస్టమ్‌దానె నా పాణం సీజిన. నా పాణం సీదెఙ్‌ నఙి అతికారం మనాద్. మర్‌జి లాగె ఆదెఙ్‌బా నఙి అతికారం మనాద్. యా లెకెండ్‌ కిదెఙ్‌ ఇజినె నా బుబ్బ నఙి ఆడ్ర సిత్తమనాన్”. ");
INSERT INTO kfc_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","వాండ్రు వెహ్తి యా మాటెఙవందిఙె, యూదురు లొఇ ఉండ్రి ఇజ్రి గొడఃబ పుట్తాద్‌ ");
INSERT INTO kfc_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","వరి లొఇ నండొండార్, “వీండ్రు దెయం అస్తికాన్, వెరి వాండ్రు, విన్నిమాట ఎందానిఙ్‌ వెంజినిదెర్”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","మరి సెగొండార్, “దెయం అస్తికాన్‌ ఒరెన్‌ యాలెకెండ్‌ వర్గిఏన్. దెయం గుడిఃదివరిఙ్‌ నెగెండ్‌ కిదెఙ్‌ అట్నాదా?”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","అయావలె పిన్నికాలం. యెరూసలెమ్‌దు యూదురు దేవుణుగుడిఃదు బసె ఆతి దినంవందిఙ్‌ ఎత్తుకిని పండొయ్ కిజినార్. ");
INSERT INTO kfc_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","నస్తివలె యేసు, దేవుణుగుడిఃదు మన్ని సొలొమోను అరుఙు ఇజి కూకె ఆని అరుఙుదు బూలాజి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","అయావలె యూదురు వన్ని సుటులం ఆతారె, “ఎసోడ్‌ రోస్కు నీను మఙి టెటాఙ్‌ వెహ్‌ఏండ, అనుమానమ్‌కు ఇడ్‌జిని? నీను క్రీస్తు ఇహిఙ, మఙి తినాఙ్‌ వెహ్‌అ”, ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","అందెఙె యేసు, నాను మీవెట వెహ్త. గాని మీరు నమ్మిఇదెర్. నా బుబ్బ సత్తుదాన్‌ నాను బమ్మాని పణిఙ్‌ కిజిన. అయా పణిఙ్‌ నావందిఙ్‌ సాసి వెహ్సినె. ");
INSERT INTO kfc_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","గాని మీరు నమ్మిఇదెర్. ఎందానిఙ్‌ ఇహిఙ, మీరు నా గొర్రెఙ్ ఆఇదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","నా గొర్రెఙ్ నా కంటం వెంజినె. నాను వన్కాఙ్‌ నెసిన. అవి నావెట వాజినె. ");
INSERT INTO kfc_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","నాను వన్కాఙ్‌ ఎలాకాలం దేవుణువెట బత్కిజిని బత్కు సీజిన. అవి ఎసెఙ్‌బా నాసనం ఆఉ. వన్కాఙ్‌ ఎయెన్‌బా నా కీదాన్‌ ఒత్తెఙ్‌ అట్‌ఏన్. ");
INSERT INTO kfc_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","వనకాఙ్‌ నఙి సిత్తి నా బుబ్బ విజెరిఙ్‌ ఇంక పెరికాన్. అందెఙె ఎయెన్‌బా వనకాఙ్‌ బుబ్బకీదాన్‌ డొఙ కిజి ఒత్తెఙ్‌ అట్‌ఏన్. ");
INSERT INTO kfc_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","నానుని నా బుబ్బ, ఉండ్రె ఆత మనాప్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","నస్తివలె, యూదురు వన్నిఙ్‌ మరి డెఃయిదెఙ్‌ ఇజి పణుకు పెహ్తర్. ");
INSERT INTO kfc_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","గాని యేసు వరిఙ్, “నా బుబ్బ సత్తుదాన్‌ నండొ బమ్మ ఆని పణిఙ్‌కిజి మిఙి తోరిస్త మన్న. వనకలొఇ ఎమేణి పణి వందిఙ్‌ నఙి మీరు పణుకుఙాణిఙ్‌ డెఃయినిదెర్‌?”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","అందెఙె యూదురు, “మాపు పణుకుఙాణిఙ్‌ డెఃయిజినిక నీను కిత్తి ఇని నెగ్గి పణిఙవందిఙ్‌ ఆఏద్‌. గాని నీను ఒరెన్‌ లోకుఆజి మంజి, నాను దేవుణు ఇజి వెహె ఆజి దేవుణుదిఙ్‌ దూసిస్నివందిఙె మాపు పణుకుఙాణిఙ్‌ డెఃయినాప్”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","అందెఙె వాండ్రు వరిఙ్‌ ఈహు వెహ్తాన్‌, “మీరు దేవుణుఙు’ ఇజి దేవుణునె వెహ్తాన్‌, ఇజి దేవుణు మాటదు రాస్త మనాద్‌ గదె? ");
INSERT INTO kfc_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","దేవుణు మాటదు వెహ్సినికెఙ్‌ ఎసెఙ్‌బా తప్‌ఉ. దేవుణు మాట సిత్తి లోకురిఙ్, ‌‘దేవుణుఙు’, ఇజి దేవుణు కూక్సినాన్. ");
INSERT INTO kfc_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","బుబ్బాతి దేవుణునె నఙి వన్ని వందిఙ్‌ కేట కితాండ్రె యా లోకమ్‌దు పోక్తాన్. అహిఙ, ‘నానె దేవుణుమరిసి’ ఇజి నాను వెహ్నివలె దేవుణుదిఙ్‌ దూసిస్నాన్‌ ఇజి మీరు ఎలాగ వెహ్సినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","నాను నా బుబ్బ వెహ్తి పణికిఏండ మహిఙ, నఙి నమ్మిమాట్. ");
INSERT INTO kfc_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","గాని నాను కిత్తి అయా పణిఙ నమ్మిదు. నఙి నమ్‌ఇఙ్‌బా అయా పణిఙ నమ్మిదు. ఎందానిఙ్‌ ఇహిఙ, బుబ్బ నావెట కూడ్ఃజి మంజినాన్. నాను బుబ్బవెట కూడ్ఃజి మంజిన, ఇజి మీరు నెసి అర్దం కిజి మండ్రెఙ్”. ");
INSERT INTO kfc_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","యాకెఙ్‌ విహరె, మరి వారు వన్నిఙ్‌ అస్తెఙ్‌ సుడ్ఃతార్. గాని వాండ్రు వరి కీదాన్‌ తప్రె ఆతాండ్రె సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","వాండ్రు యొర్దాను గడ్డ అతాహ పడఃకాద్‌ మన్ని ఉండ్రి బాడిఃదు మరిబా సొహాన్‌. బానె యోహాను బాప్తిసం సీజి మహాన్‌. వాండ్రు బాన్‌ మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","నండొడార్‌ వన్నిడగ్రు వాతార్. వారు, “యోహాను ఇని బమ్మాని పణిబాన్‌ కిఏతాన్. గాని విని వందిఙ్‌ యొహాను వెహ్తి సఙతిఙ్‌ విజు నిజమ్‌నె”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","అబ్బె నండొడార్‌ యేసుముస్కు నమకం ఇడ్తార్. ");
INSERT INTO kfc_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","3","బెతానియ ఇన్ని నాటొ లాజరు ఇన్నికాన్‌ ఒరెన్‌మనాన్. వన్ని బీబిక్‌నె మార్త మరియ ఇనికెఙ్. యా మరియనె యేసు పాదమ్‌కాఙ్‌ అతరు ఇన్ని వాసన నూనె వాక్తాదె, దన్నికొప్పదాన్‌ తెల్‌తాద్. ఉండ్రి నాండిఙ్‌ లాజరుఙ్‌ జబ్బు వాతాద్. నీర్‌సం లావు ఆతిఙ్, వన్ని బీబ్‌సిక్‌ యేసుడగ్రు కబ్రు పోక్తె, ‘ప్రబువా, నీను లావు ప్రేమ కిజిని నీకూలాయెన్‌ నీరసం ఆత మనాన్‌’, ఇజి. ");
INSERT INTO kfc_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","యేసు యా కబ్రు విహండ్రె, “వాండ్రు సాఏన్. సానివందిఙ్‌ వాతిక ఆఏద్‌ యా నీర్‌సం. గాని దేవుణు గొప్ప పెరికాన్‌ ఇజి లోకురిఙ్‌ తోరిస్తెఙ్. ఎందానిఙ్‌ ఇహిఙ, దిన్నిదటాన్‌ దేవుణు మరిసి గొప్పపెరికాన్‌ ఇజి తోరె ఆదెఙ్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","యేసు మార్తెఙ్, దన్నితఙిసి మరియెఙ్, లాజరుఙ్‌ లావు ప్రేమిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","గాని లాజరు నీర్‌సం లావు ఆతాన్‌ ఇజి కబ్రు విహిఙ్‌బా వాండ్రు బేగి సొన్‌ఏతాన్. వాండ్రు మహి బాన్‌మరి రుండి రోస్కుబా మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","వెనుక వాండ్రు వన్ని సిసూర్‌ఙ, “రదు, మాటు యూదయ దేసమ్‌దు మర్‌జి సొనాట్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","అయావలె వారు, “బోదకినికి, యూదురు నిఙి పణకాణిఙ్‌ డెఃయ్‌దెఙ్‌ సెగం రోస్కు ముఙాలె సుడ్ఃతార్ ‌గదె. మరిబా నీను అబ్బె సొండ్రెఙ్‌ సుడ్ఃజినిదా?”, ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","అందెఙె యేసు, “వేడకాఙ్‌ పన్నెండు గంటెఙ్‌ మనె. సిలె? అందెఙె ఒరెన్‌ వేడె బూలాతిఙ, వాండ్రు తొరొ ఇడ్ఃజి అర్‌న్. ఎందానిఙ్‌ ఇహిఙ, వాండ్రు యా లోకమ్‌ది జాయి సుడ్ఃజినాన్. ");
INSERT INTO kfc_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","గాని వాండ్రు రెయితు బూలాతిఙ, వాండ్రు తొరొ ఇడ్ఃజి అర్నాన్. ఎందనిఙ్‌ ఇహిఙ, వన్ని లొఇ జాయి సిల్లెద్‌”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","యాక వెహ్తండ్రె, మరి సిసూరిఙ్‌ వెహ్సినాన్, “మా కూలాయెన్‌ ఆతి లాజరు నిద్రకిజినాన్. వన్నిఙ్‌ నిక్తెఙ్‌ నాను బాన్‌ సొన్సిన. ");
INSERT INTO kfc_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","వన్ని సిసూరు, “ప్రబువా, వాండ్రు నిద్రకిజినాన్‌ ఇహిఙ, వాండ్రు నెగెణ్‌ ఆనాన్‌లె”, ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","లాజరు సాత మనాన్‌ ఇజి యేసు వెహ్తాన్‌. గాని వన్నిసిసూర్‌ మాముల్‌ నిద్రవందిఙె వాండ్రు వెహ్సినాన్‌ ఇజి ఒడిఃబితార్. ");
INSERT INTO kfc_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","15","అందెఙె వాండ్రు వరిఙ్‌ తినాఙ్‌ వెహ్తాన్‌, “లాజరు సాతాన్. అయావలె నాను వన్నివెట మన్‌ఏత. అందెఙె నాను మీ వందిఙ్‌ సర్ద ఆజిన. ఎందానిఙ్‌ ఇహిఙ, మీరు నఙి నమ్మినిదెర్లె. అందెఙె రదు, వన్ని బాన్‌సొనాట్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","నస్తివలె దిదుము ఇజి కూకె ఆని తోమా మహి సిసూరిఙ్, “రదు మాటు బా సొనాట్. వన్నివెట సాదెఙ్‌సొనాట్”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","యేసు వాతివలె, లాజరుఙ్‌ సమాది కిజి నాల్గి దినమ్‌కు ఆతె ఇజి నెస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","బెతానియ యెరూసలెమ్‌దాన్‌ ఎంజు ఇంసుమింసు రుండి మయ్‌లుఙ్‌ దూరం మన్నె. నండొండార్‌ మార్తెఙ్‌ మరియెఙ్‌ ఓదిస్తెఙ్‌ వాత మహార్‌. వరి తంబెర్సి సాతి వందిఙ్, వారు ఓదిస్తెఙ్‌ వాతార్. ");
INSERT INTO kfc_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","యేసువాజినాన్‌ ఇజి వెహ్తి మాట విహదె, మార్త ఎద్రు సొహద్. వన్నిఙ్‌ సుడ్ఃదెఙ్‌ అది సొహద్. గాని మరియ ఇండ్రొ బస్త మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","నస్తివలె మార్త యేసుఙ్, “ప్రబువా, నీను ఇబ్బె మంజినిక ఇహిఙ, నా తంబెరి సాఎతాన్‌మరి. ");
INSERT INTO kfc_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","గాని ఏలుబా నీను దేవుణుదిఙ్‌ ఇనిక లొస్తిఙ్‌బా వాండ్రు నిఙి సీనాన్‌ ఇజి నాను నెస్న”, ఇజి వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","అందెఙె యేసు, “నీ తంబెర్సి మర్‌జి నిఙ్‌నాన్‌లె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","అయావలె అది, “యా లోకమ్‌దిఙ్‌ కడఃవెరి దినమ్‌దు, వాండ్రు మరి బత్కినాన్‌లె ఇజి నాను నెస్న”, ఇహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","26","అందెఙె యేసు దనిఙ్‌ ఈహు వెహ్తాన్‌, “నానె సాతి వరిఙ్‌ నిక్నికాన్. వరిఙ్‌ మరి బత్కు సీనికాన్‌ నానె. నఙి నమ్మినికాన్‌ ఎయెన్‌బా వాండ్రు సాతిఙ్‌బా మరి బత్కినాన్. నఙి నమ్మిజి బత్కిజిని ఎయెన్‌బా ఎసెఙ్‌బా సాఏన్. నీను యాకెఙ్‌ నమిజినిదా?”. ");
INSERT INTO kfc_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","అయావలె అది, “ఒఒ, నాను నమిజిన, నీనె దేవుణు మరిసి ఆతి క్రీస్తు ఇజి. నీనె యా లోకమ్‌దు వాదెఙ్‌మన్నికాన్‌ఇజి దేవుణు వెహ్తికి”, ఇజి వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","యాకెఙ్‌ వెహ్తదె, అది మర్‌జి సొహదె, దన్నితఙి మరియెఙ్‌కూక్తాదె, “బోదిస్నికాన్‌ఇబ్బె మనాన్. నిఙి కూక్సినాన్”, ఇజి గిబ్బి డగ్రు వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","మరియ యాక విహిఙ్, అది గజిబిజి నిఙితాదె, వన్ని డగ్రు సొహద్. ");
INSERT INTO kfc_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","అయావలె యేసు ఇంక ఆ నాటొ రెఎండ్రె. మార్త వన్నిఙ్‌ దసూల్‌ఆత్తి బాడిఃద్‌నె మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","మార్తెఙ్‌ ఓదరిసి దనివెట ఇండ్రొ మహి యూదురు అది గజిబిజి నిఙ్‌జి సొన్సినిక సుడ్ఃతివలె, అది అడఃబదెఙ్‌ దూకిదు సొన్సినాన్‌సు ఇజి దన్నివెనుక సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","యేసు మన్ని బాడిఃదు మరియ వాతాదె, వన్నిఙ్‌సుడ్ఃతాదె, వన్ని పాదమ్‌కాఙ్‌ అర్తాద్. అర్తాదె, “ప్రబువా, నీను ఇబ్బె మంజినిక ఇహిఙ, నా తంబెరి సాఎతాన్‌మరి”, ఇహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","అది అడఃబాజినిక యేసు సుడ్ఃతాన్. దని వెట వాతి యూదురు బా అడఃబాజినిక సుడ్ఃతాన్. అయావలె వాండ్రు మన్సుదు బాద ఆతాండ్రె మొకొం డిఃప్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“వన్నిఙ్‌ఎంబె ఇడ్తి మన్నిదెర్‌?”, ఇజి వరిఙ్‌ వెన్‌బాతాన్. “వాజి సుడ్ఃఅ ప్రబువా”, ఇహార్‌ వారు. ");
INSERT INTO kfc_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","యేసు కనీర్‌డిఃప్తాన్‌ ");
INSERT INTO kfc_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","అయావలె యూదురు, “సుడ్ఃదు వాండ్రు ఎసొ వన్నిఙ్‌ప్రేమిస్తాన్”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","గాని వరి లొఇ సెగొండార్, “వీండ్రు గుడిః వరిఙ్‌ నెగెణ్‌కితాన్. మరి ఎందనిఙ్‌లాజరు సాఏండ కిదెఙ్‌అట్‌ఎతాన్”, ఇజి వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","అయావలె యేసు నండొ బాద ఆతాండ్రె దూకిదు వాతాన్. అయాక ఉండ్రి సాలం. దన్నిముఙాల ఉండ్రి పెరి పణుకు ఇడ్త మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","యేసు, “అయా పణుకు లాగ్‌దు”, ఇజి వెహ్తాన్‌. నస్తివలె సాతివన్ని బీబ్‌సి మార్త వన్నిఙ్, “ప్రబువా, వినిఙ్‌ముసి నాల్గి రోస్కు ఆజినాద్. అందెఙె గొప్ప కంపు ఏలు మంజినాద్‌లె”, ఇజి వెహ్తాద్‌‌ ");
INSERT INTO kfc_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","అందెఙె యేసు దనిఙ్, “నీను నమ్మితిఙ, దేవుణు గొప్ప పెరికాన్‌ ఇజి నీను సూణిలె ఇజి నాను నిఙి వెహ్త గదె?”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","అందెఙె వారు పణుకు లాగితార్. యేసు కణుకు ముస్కు బస్తాండ్రె, “ఓ బా నీను నా పార్దనం వెంజినిఙ్‌నిఙి వందనమ్‌కు. ");
INSERT INTO kfc_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","నీను ఎస్తివలె బా నఙి వెంజినిలె ఇజి నాను నెస్న. గాని ఇబ్బె నిల్సి మంజిని యా లోకుర్‌వందిఙ్‌ నాను నిఙి వందనమ్‌కు వెహ్త మన. ఎందానిఙ్‌ ఇహిఙ, నీనె నఙి పోక్తి మన్నికాన్‌ఇజి వారు నమిదెఙ్”, ఇజి పార్దనం కితాన్. ");
INSERT INTO kfc_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","పార్దనం కితాండ్రె, వాండ్రు, “లాజరు వెల్లి రఅ”, ఇజి డేల్సి డటం వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","అయావలె లాజరు వెల్లి వాతాన్. వన్ని కికు కాల్కు పాతెఙాణిఙ్‌సుటిస్త మహార్‌. వన్ని మొకొం రూమాల్‌దాన్‌ తొహ్క్‌త మహాద్‌. యేసు వరిఙ్, “వన్నిఙ్‌సుటిస్తి మన్నికెఙ్‌లాగ్‌దు. వన్నిఙ్‌ నడిఃనిలెకెండ్‌ కిదు”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","అందెఙె మరియెఙ్‌ సుడ్ఃదెఙ్‌ వాతి యూదురు లొఇ నండొండార్, యేసు కితిక సుడ్ఃతారె, వన్ని ముస్కు నమకం ఇట్తార్. ");
INSERT INTO kfc_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","గాని వరి లొఇ సెగొండార్‌ పరిసయురుఙ డగ్రు సొన్సి, యేసు కితిక వరిఙ్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","నస్తివలె పెరి పుజెరిఙు నీ పరిసయురు, పెద్దల్‌ఙ కూక్‌పిస్తారె, “వాండ్రు గొప్ప బమ్మ ఆని పణిఙ్‌ కిజినాన్‌? అందెఙె మాటు ఇన్నిక కిదెఙ్‌? ");
INSERT INTO kfc_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","మాటు వన్నిఙ్‌ యా లెకెండ్‌ పణి కిదెఙ్‌ సరి సితిఙ, లోకుర్‌ విజెరె వన్నిఙ్‌ నమినార్. రోమాదికార్‌ వానారె, మా గుడిః, యూదురు ఆతి మఙి విజు నాసనం కినార్”, ఇజి వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","50","నస్తివలె వరి లొఇ కయపా ఇన్నికాన్‌ ఒరెన్‌ మహాన్‌. వాండ్రు అయా ఏంటు విజు పుజెరిఙ ముస్కు పెరి పుజెరి. వాండ్రు వరిఙ్, “మీరు ఇనికబా నెస్‌ఇతిదెర్. రోమాదికార్‌ మా గుడిః, యూదురు ఆతి మఙి పూర్తి నాసనం కినిదని ముస్కు లోకుర్‌ వందిఙ్‌ ఒరెన్‌ వాండ్రు సానికాదె మిఙి నెగెద్‌ ఇజి మీరు నెస్‌ఇదెరా?”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","52","వాండ్రు వెహ్సిని దని అర్దం వాండ్రె నెస్‌ఎతాన్. గాని వాండ్రు ఆ ఏంటు విజు పుజెరిఙ ముస్కు పెరి పుజెరి. అందెఙె యేసు యూదురు వందిఙ్‌ సానాన్‌లె ఇజి, యూదురు వందిఙె ఆఏండ, సెద్రితి మన్ని దేవుణు కొడొఃరిఙ్‌ కుడుఃప్సి తసి వరిఙ్‌ ఉండ్రె లోకుర్‌కిదెఙ్. దినివందిఙ్‌ యేసు సానాన్‌లె ఇజి వాండ్రు ఎతు కిజి జర్‌గ్‌ఇ ముఙాలె వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","అందెఙె అయా నాండిఙ్‌అసి వన్నిఙ్‌సప్తెఙ్‌ వారు సుడ్ఃజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","అందెఙె యేసు విజెరె వన్నిఙ్‌ నెస్నిలెకెండ్‌ బూలాఎతాన్. గాని వాండ్రు ఎయెర్‌ మన్‌ఇ బాడిః డగ్రు మన్ని ఉండ్రి ప్రాంతమ్‌దు సొహాన్‌. అయా ప్రాంతమ్‌దు మన్ని ఎప్రయెం ఇన్ని ఉండ్రి పట్నమ్‌దు వన్ని సిసూర్‌ వెట వాండ్రు మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","యూదురి పస్కపండొయ్ డగ్రు వాతివలె, నండొ ప్రాంతమ్‌కాణిఙ్‌ నండొండార్‌ యెరూసలెమ్‌దు సొహార్‌. పండొయ్‌ ముఙాల విజెరె సుబ్బరం మనిక ఉండ్రి ఆసారం. అందెఙె, వారు సుబ్బరం మన్నివందిఙ్‌ వారు యెరూసలెమ్‌దు వాతార్. ");
INSERT INTO kfc_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","వారు యేసుఙ్‌ రెబాజినె మహార్‌. వారు దేవుణు గుడిః అరుఙుదు నిహి మహివలె, ఒరెన్‌ వెట ఒరెన్, “ఇన్నిక ఒడ్ఃబిజిని? వాండ్రు పండొయ్‌దిఙ్‌ వానాండ్రా, సిలెనా?”, ఇజి వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","గాని పెరి పుజెరిఙు ని పరిసయురు ఉండ్రి ఆడ్ర సిత మనార్. ఎయెన్‌బా యేసు ఎంబె మనాన్‌ ఇజి నెస్తిఙ, వాండ్రు వరిఙ్‌వెహ్తెఙ్. ఎందానిఙ్‌ ఇహిఙ, వన్నిఙ్‌ అరెస్టు కిదెఙ్. ");
INSERT INTO kfc_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","పస్కపండొయ్‌ మొదొల్‌స్తెఙ్‌ ఆరు దినమ్‌కు మనె. అయావలె, యేసు లాజరు మన్ని బెతానియ ఇని పట్నమ్‌దు సొహాన్‌. యా లాజరుఙ్‌నె యేసుసావుదాన్‌ బత్కిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","అబ్బె వారు యేసువందిఙ్‌ ఉండ్రి వింతు తయార్‌ కిత్తార్. మార్తనె వింతుదు సవ్‌దర్‌ణి. బోజనమ్‌దిఙ్‌ బస్తి మహివరివెట లాజరుబా యేసువెట బస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","నస్తివలె, మరియ ఉండ్రి సీసాదు మన్ని వాసన నూనె లాగితాదె, యేసు పాదమ్‌కాఙ్‌ వాక్తాదె దనికొపుదాన్‌ వన్ని పాదమ్‌కు తెలితాద్. యా వాసన నూనె, నండొ కరీద్‌తిక. యాక జటమాంసి ఇని ఉండ్రి మొకదానె, తయార్‌ కితిక. అది వాసన నూనె వాక్తివెలె, అయా ఇల్లు విజు నెగ్గి వాసనందాన్‌ నిండ్రితాద్. ");
INSERT INTO kfc_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","అయావలె వన్ని సిసూర్‌ లొఇ ఒరెన్‌ఆతి ఇస్కరియొతు యూద, “ఎందానిఙ్‌ యా వాసనం నూనె మూండ్రి వందెఙ్‌ వెండి రుపాయ్‌ఙు పొర్సి అయా డబ్బు బీదాతి వరిఙ్‌ సిఇతి?”, ఇజి వెహ్తాన్‌. యా ఇస్కరియొతు యుదనె, వెన్కా యేసుఙ్‌ యుదురి అదికారిఙ కీదు ఒపజెప్నికాన్. ");
INSERT INTO kfc_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ఏలు వాండ్రు యా లెకెండ్‌ వెహ్తిక, బీదాతివరిఙ్‌ నెగెండ సుడ్ఃజిన ఇజి ఆఏద్‌ గాని వాండ్రు డొఙ వాండ్రు. వరి సేవపణి వందిఙ్‌ లోకుర్‌ సీజిని డబ్బు ఇడ్ని సన్సి వీండ్రె అస్త మనాన్. వాండ్రు వన్కాలొఇహాన్‌ ‌వన్ని సొంత కర్సు వందిఙ్‌ డొఙ కిజి మహాన్‌. అందెఙె వాండ్రు ఆహె వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","అందెఙె యేసు, “దనిఙ్‌బాద కిమాట్. నఙి సమాది కిని దినమ్‌దాక అయాక దని బాన్‌మన్నిద్. ");
INSERT INTO kfc_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","బీదదికార్‌ ఎస్తివలెబా మీ వెట మంజినార్. గాని నాను ఎలాకాలం మీ వెట మన్‌ఎ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","అహిఙ, యూదుర్‌ఙ లొఇ మంద లోకుర్, యేసు బెతానియదు మనాన్‌ ఇజి నెస్తారె అబె వాతార్. వారు యేసుఙ్‌ సుడ్ఃదెఙ్‌ఇజినె ఆఏండ, వాండ్రు సావుదాన్‌బత్కిస్తి లాజరుఙ్‌ సుడ్ఃదెఙ్‌బా వాతార్. ");
INSERT INTO kfc_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","అందెఙె పెరి పుజెరిఙు, లాజరుఙ్‌బా సప్తెఙ్‌ ఇజి ఆలోసనం కితార్. ఎందానిఙ్‌ ఇహిఙ, వన్నిఙ్‌ జర్గితి దనివందిఙ్‌ సుడ్ఃజి యూదురు నండొండార్, వరి పెద్దల్‌ఙ డిఃసి యేసుముస్కు నమకం ఇడ్ఃజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","మర్‌సనాండిఙ్, పస్క పండొయ్‌దిఙ్‌ యెరుసలెం పట్నమ్‌దు వాతి మందలొకుర్‌ యేసు యెరూసలెమ్‌దు వాజినాన్‌ ఇజి వెహార్. ");
INSERT INTO kfc_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","అందెఙె వారు ఈత మటెఙ్‌ అస్తారె, పట్నమ్‌దాన్‌ వెల్లి సొహార్‌. వన్నిఙ్‌ ఎద్రు సొన్సి, “ఓసన్న ప్రబు సిత్తి అతికారమ్‌దాన్‌ వాజిని వన్నిఙ్‌ పొగిడిఃపిద్. ఇస్రాయేలు లోకురిఙ్‌ ఏలుబడిః కినిరాజుఙ్‌ పొగిడిఃపిద్”, ఇజి డటం డేల్సి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","15","“ఓ సియోను గాల్‌సి, తియెలామాట్. ఇవిలొన్‌ మీ రాజు గాడఃదె పిల్ల ముస్కు ఎక్త బస్తాండ్రె వాజినాన్”, ఇజి దేవుణు మాటదు రాస్తి మన్నిలెకెండె, యేసు ఉండ్రి గాడఃదె పిల్లదిఙ్‌ సుడ్ఃతాండ్రె దనిముస్కు బస్తాండ్రె వాజినాన్. ");
INSERT INTO kfc_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","అయావలె వన్నిసిసూర్‌ యా జర్గితి వన్కాఙ్‌ అర్‌దం కిఏతార్. గాని వెనుకయేసు సాజి, మరి బత్కిజి, దేవుణు మంజిని బాడిఃదు వన్ని వెట గొప్ప జాయ్‌దు మండ్రెఙ్‌ దేవుణు వన్నిఙ్‌ ఒతివెలెనె, యా జర్గితి సఙతిఙ్‌ వన్నివందిఙ్‌ దేవుణు మాటదు ముఙాలె రాస్త మనాద్‌ ఇజి అయాక వన్నిఙ్‌ జర్గితాద్‌ ఇజి వారు అర్దం కితార్. ");
INSERT INTO kfc_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","అహిఙ, యేసు లాజరుఙ్‌ దూకిదాన్‌ కూక్సి సావుదాన్‌ మరి బత్కిస్తివలె వన్ని వెట మహి లోకుర్‌నె, లాజరుఙ్‌ జర్గితిక సాటిసినార్. ");
INSERT INTO kfc_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","యా లోకుర్‌ వెహ్తి మాట విహరె, మంద లోకుర్‌వన్నిఙ్‌ ఎద్రు సొన్‌సినార్. ఎందానిఙ్‌ఇహిఙ, వాండ్రు బమ్మాతి గొప్ప పణిఙ్‌ కిత్తాన్‌ ఇజి వెహార్. ");
INSERT INTO kfc_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","అయావలె పరిసయ్‌రుఙు వరిఙ్‌ వారె, “ఇదిలో, నండొ లోకుర్‌ వన్ని వెన్కా సొన్‌సినార్. మాటు కిజినికెఙ్‌ ఇనికబా, వన్ని వెట సొన్‌ఎండ వరిఙ్‌ ఆప్‌కిఉ”, ఇజి వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","నస్తివలె, పస్క పండొయ్‌ కినివలె దేవుణుదిఙ్‌ పొగిడిఃజి మాడిఃస్తెఙ్‌ యెరూసలెమ్‌దు వాతి వరి లొఇ సెగొండార్‌ యూదురు ఆఇకార్‌ మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","వారు గలీలయ ప్రాంతమ్‌ది బెత్‌సయిద పట్నమ్‌ది పిలిపు డగ్రు వాతారె, “బాబు మాపు యేసుఙ్‌ సుడ్ఃదెఙ్‌ ఆస ఆజినాప్”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","పిలిపుఙ్‌వెహ్తిఙ్, వాండ్రు ఆంద్రెయెఙ్‌ వెహ్తాన్‌‌. వీరు రిఏర్‌ కూడ్జి యేసుఙ్‌ వరి ఆస వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","24","అందెఙె యేసు వరివెట ఈహు వెహ్సినాన్. “లోకు మరిసి ఆతి నఙి దేవుణు వన్ని వెట వన్ని జాయిదు మండ్రెఙ్‌ వాండ్రు మంజిని బాడిఃదు ఒని దినమ్‌కు డగ్రు ఆతె మనె. నాను నిజం వెహ్సిన ‘ఉండ్రి గోదము గిడ బూమిదు అర్సి సాఎండ మహిఙ, అది అయ లెకెండ్‌ మంజినాద్. గాని ఆ గిడ సాతిఙ నండొ గిడెఙ్‌ఆనె. ");
INSERT INTO kfc_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ఎయెన్‌బా వన్ని సొంత పాణమ్‌దిఙ్‌ లావు ప్రేమిస్తిఙ, వాండ్రు వన్ని పాణం ఎలాకాలం దేవుణు వెట బత్కిని బత్కుదు మన్‌ఎండ అయాక పాడు కిజినాన్. గాని ఎయెన్‌బా యా లోకమ్‌దు బత్కినివలె, వన్ని సొంత పాణమ్‌దిఙ్‌ లావు ప్రేమిస్‌ఏండ మహిఙ, వాండ్రు ఎలాకాలం బత్కిని బత్కు వందిఙ్‌ వన్ని పాణం కాపాడిఃజినాన్. ");
INSERT INTO kfc_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ఎయెన్‌బా నఙి సేవ కితిఙ, వాండ్రు నా సిసూ ఆదెఙ్‌వలె. నాను ఎంబె మంజినానొ, అబె నఙి సేవ కినికాన్‌బా మంజినాన్. నఙి సేవ కిని వన్నిఙ్‌ నా బుబ్బ గవ్‌రం సీనాన్”. ");
INSERT INTO kfc_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","మరిబా వాండ్రు వెహ్సినాన్, “ఏలు నా పాణం బాద ఆజిన. నాను ఇన్నిక ఇండ్రెఙ్‌? ఓ బా, నఙి వాని కస్టమ్‌దాన్‌ నఙి తప్రిస్‌అ, ఇజి వెహ్తెఙా? సిలె. ఎందానిఙ్‌ ఇహిఙ, యా కస్టమ్‌కు ఓరిస్ని వందిఙె నాను వాత మన. ");
INSERT INTO kfc_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ఓ బా, నీను గొప్ప పెరికి ఇజి లోకురిఙ్‌తోరె ఆఅ”, ఇజి వెహ్తాన్‌. అయావలె ఆగాసమ్‌దాన్‌ ఉండ్రి జాటు వాతాద్. “నాను గొప్ప పెరికాన్‌ ఇజి నీను కితి పణిఙాణిఙ్‌ తోరె ఆత మన. నీను సాజి మరి బత్కినివలె నాను మరి అయాక తోరె ఆన”, ఇజి జాటుదు దేవుణు వర్గితాన్. ");
INSERT INTO kfc_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","నస్తివలె అబె నిహి మహి లోకుర్‌ అయాక విహరె, అయా జాటు ఆగాసమ్‌దు దీడిఃతిక ఇజి వెహ్తార్‌. గాని మరి సెగొండార్, “దేవుణు మంజిని బాడిదాన్‌దేవుణు దూత ఒరెన్‌ వన్ని వెట వర్గితాన్”, ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","అందెఙె యేసు, “ఏలు మీరు జాటుదాన్‌విహి మాటెఙ్‌నఙి దేవుణు పోక్తాన్‌ఇజి మీరు నెస్తెఙ్‌మీ వందిఙె వాతె. నా వందిఙ్‌ ఆఎద్. ");
INSERT INTO kfc_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ఇయేలె, దేవుణు యా లోకమ్‌ది లోకురిఙ్‌ తీర్పు సీని సమయం. ఇయేలె లోకమ్‌ది అతికారి ఆతి సయ్తానుఙ్‌ వన్ని అతికారమ్‌దాన్‌ దేవుణు వెల్లి నెక్ని సమయం. ");
INSERT INTO kfc_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","నఙి బూమి ముస్కుహాన్‌ సిలువాదు ఎకిస్నివలె, విజు దేసెమ్‌కాణి లోకురిఙ్, నాను నా డగ్రు తపిస్నాలె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","వన్నిఙ్‌ఎలాగ సప్నార్‌లె ఇజి లొకురిఙ్‌ తోరిస్తెఙ్‌ వాండ్రు యా మాటెఙ్‌జర్గిని ముఙాలె వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","అయావలె మంద లోకుర్‌వన్నిఙ్, “దేవుణు మాటదు మాపు సద్‌విజినాప్‌గదె క్రీస్తు ఎలాకాలం బత్కినాన్‌లె ఇజి. మరి నీను ఎలాగ వెహ్సిని, లోకు మరిసి ఆతి నిఙి సిలువాదు ఎకిస్తెఙ్‌వలె ఇజి. అహిఙ, నీను వెహ్సిని లోకు మరిసి ఎలాగ మర్తికాన్. ");
INSERT INTO kfc_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","అందెఙె యేసు, “వాండ్రె జాయి ఇజి వన్ని వందిఙె వరిఙ్‌ ఈహు వెహ్సినాన్‌: “జాయి ఆతి నాను మీ వెట సెగం కాలమ్‌నె మంజినలె. అందెఙె సీకట్‌వాని ముఙాల, జాయ్‌ఆతి నాను మనివలె మీరు నఙి ఇస్టం ఆని వజ నడిఃదు. సీకటుదు నడిఃనికాన్‌ వాండ్రు ఎంబె సొన్‌సినాండ్రొ ఇజి వాండ్రు నెస్‌ఎన్. ");
INSERT INTO kfc_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","అందెఙె మీరు జాయ్‌దు బత్కిజిని నా కొడొఃర్‌ఆదెఙ్, జాయి ఆతి నాను మీ వెట మనివలె నఙి నమ్మిదు. వాండ్రు యా మాటెఙ్‌వెహ్తండ్రె వరిబాణిఙ్‌ సొహాండ్రె వరిఙ్‌ తోర్‌ఏండ డాఙ్‌జి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","వాండ్రు నిసొ గొప్ప బమ్మాతి పణిఙ్‌ వరిఎద్రు కితిఙ్‌బా యూదురు లొఇ నండొ లోకుర్‌ వన్నిఙ్‌ నమిఎతార్. ");
INSERT INTO kfc_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","‘ప్రబువా మాపు వెహ్తి మాటెఙ్‌ ఎయెర్‌ నమ్మితార్‌? ఎయెరిఙ్‌ దేవుణు వన్నిసత్తు తోరిస్తాన్?’, ఇజి యెసయ ప్రవక్త వెహ్తి మాట పూర్తిఆని వందిఙె వారు నమ్మిఏతార్. ");
INSERT INTO kfc_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","యెసయ ప్రవక్త మరి ఈహు వెహ్త మనాన్, ‘వారు వరి కణకాణిఙ్‌ తొఏండ మండ్రెఙ్‌ దేవుణు వరి కణుకు గుడిః కితాన్. వారు వరిదాన్‌ అర్దం కిఎండ మండ్రెఙ్‌ దేవుణు వరి మన్సుసు గటి కితాన్. వరిఙ్‌ నెగెణ్‌ కిదెఙ్‌ వారు నా డగ్రు రెఎండ మండ్రెఙ్‌ నాను అయా లెకెండ్‌ కిత”, ఇజి. అందెఙె వారు యేసుఙ్‌ నమ్మిదెఙ్‌ అట్‌ఏండఆతార్. ");
INSERT INTO kfc_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","యెసయ ఎందానిఙ్‌ యా లెకెండ్‌ వెహ్తాన్‌‌ ఇహిఙ, యేసు గొప్ప పెరికాన్‌ ఇజి వాండ్రు సుడ్‌త మహాన్‌. వాండ్రు వెహ్తి మాటెఙ్‌ యేసు వందిఙె వెహ్సినె. ");
INSERT INTO kfc_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","గాని యూదురు అదికారిఙలొఇ నండొండార్‌ యేసు ముస్కు నమకం ఇట్తార్. గాని పరిసయ్‌రు వరిఙ్‌ ఇన్నిక కినార్‌ ఇజి తియెల్‌ ఆజి వారు యేసుఙ్‌ నమ్మిజినాప్‌ ఇజి లోకుర్‌ ఎద్రు వెహ్ఎతార్. వరిఙ్‌ యూదురి మీటిఙ్‌ ఇండ్రొణిఙ్‌ వెల్లి కినార్‌ ఇజి తియెల్‌ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ఎందానిఙ్‌ ఇహిఙ, వారు దేవుణు వరిఙ్‌ పొగిడిః దని ముస్కు లోకుర్‌ వరిఙ్‌ పొగిడిఃదెఙ్‌ ఇజి నండొ కోరితార్. ");
INSERT INTO kfc_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","మరి యేసు ఈహు డటం వెహ్సినాన్, “నా ముస్కు నమకం ఇడ్తికాన్‌ ఎయెన్‌బా నఙినె ఆఎండ, నఙి పోక్తివన్నిఙ్‌బా నమిజినాన్. ");
INSERT INTO kfc_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","నఙి సుడ్ఃజినికాన్‌ ఎయెన్‌బ నఙి పోక్తి వన్నిఙ్‌బా సుడ్ఃజినాన్. ");
INSERT INTO kfc_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","నఙి నమ్మినికాన్‌ ఎయెన్‌బా సీకట్‌దు బత్కిఎండ మంజిని వందిఙ్‌ నాను జాయి లెకెండ్‌ లోకమ్‌దు వాత మన్న. ");
INSERT INTO kfc_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","నా మాటెఙ్‌ వెంజి అయావజ కిఇవన్నిఙ్, తీర్పు సీజినాను సిక్స సిఏ. ఎందానిఙ్‌ ఇహిఙ, ఆహె తీర్పు సీజి సిక్స సీదెఙ్‌ ఆఏద్‌ నాను అయా లోకమ్‌దాన్‌ వాతిక. గాని లోకురిఙ్‌ రక్సిస్ని వందిఙె వాత. ");
INSERT INTO kfc_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","నఙి నెక్సి పొక్సి నా మాటెఙ వజ కిఇవన్నిఙ్, వాండ్రు కిఇకాదె వన్నిఙ్‌ ఎలాకాలం మన్ని సిక్స సీనాద్. నాను వెహ్తి మాటెఙ్‌నె ఆకార్‌ దినమ్‌దు నాను మర్‌జి వానివలె వన్నిఙ్‌ తీర్పు సీనాద్. ");
INSERT INTO kfc_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ఎందనిఙ్‌ ఇహిఙ, నాను నా సొంత అతికారమ్‌దాన్‌ వెహ్తిక ఆఎద్. గాని నఙి పోక్తి నా బుబ్బనె, నాను ఇన్నిక వెహ్తెఙ్, ఎలాగ వెహ్తెఙ్‌ ఇజి ఆడ్ర సిత మనాన్. ");
INSERT INTO kfc_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","వాండ్రు వెహ్తి ఆడ్రెఙ్‌ లొఙిజినికాన్‌ ఎలాకాలం బత్కినాన్. అందెఙె నా బుబ్బ నఙి వెహ్‌అ ఇజి వెహ్తికెఙ్‌నె నాను వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","నస్తివలె, పస్క పండొయ్‌ కిని ముఙాహి దినం. యా లోకం డిఃసి బుబ్బ డగ్రు సొండ్రెఙ్‌ టయం ఆతాద్‌ ఇజి యేసు నెస్తాన్. వాండ్రు ఎస్తివలెబా వన్ని ముస్కు నమకం ఇడ్తివరిఙ్‌ ప్రేమిసి మహాన్‌. వాండ్రు సానిదాక ప్రేమిసినె మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","యేసుని వన్ని సిసూరు పొదొయ్‌ బోజనమ్‌దిఙ్‌ బస్త మహార్‌. సిమొను మరిసి ఆతి ఇస్కరియొతు యూద మన్సుదు సయ్తాను ముఙాలె ఉండ్రి ఆలోసన పుటిస్త మహాన్‌, యేసుఙ్‌ సెఇవరి కీదు ఒపజెప్తెఙ్‌ ఇజి. ");
INSERT INTO kfc_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","బుబ్బ వన్నిఙ్‌ విజు దనిముస్కు అతికారం ఒపజెప్త మహాన్‌, ఇజి యేసు నెస్తాన్. వాండ్రు దేవుణుబాణిఙ్‌ వాత మహాన్‌, దేవుణుడగ్రు సొన్సినాన్‌ ఇజిబా నెస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","అందెఙె వాండ్రు బీజనమ్‌దిఙ్‌ బస్తి మహిబాణిఙ్‌ నిఙితాండ్రె, వాండ్రు పిడ్ఃగితి మన్ని సాల్వ లాగితాండ్రె ఉండ్రి తువాలు నడుముదు తొహె ఆతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","తొహ్తాండ్రె, ఉండ్రి పల్లెమ్‌దు ఏరు వాక్తాండ్రె వన్ని సిసూర్‌ పాదమ్‌కు నొర్‌జి వన్ని నడుముదు తొహ్‌తి మహి తువాల్‌దాన్‌ వరి పాదమ్‌కు తేల్‌జినాన్. ");
INSERT INTO kfc_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ఆహె, వాండ్రు సిమొను పెతురుడగ్రు వాతివలె, వాండ్రు, “ప్రబువా, నీను నా పాదమ్‌కు నొర్‌దెఙ్‌ సుడ్ఃజినిదా?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","అందెఙె యేసు, “నాను ఇనిక కిజిన ఇజి ఏలు నీను నెస్‌ఇ గాని వెనుక నీను అర్దం నెస్నిలె”, ఇజి వన్నిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","అయావలె పేతురు, “సిల్లె, నీను నా పాదమ్‌కు ఎసెఙ్‌బా నొర్‌దెఙ్‌ ఆఏద్”, ఇజి వెహ్తాన్‌. దనిఙ్‌యేసు, “నాను నీ పాదమ్‌కు నొర్‌ఏండమహిఙ, నీను నా సిసూడు ఆఇ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","అయావలె సిమోన్‌ పేతురు, “అహిఙ ప్రబువా, నా పాదమ్‌కునె ఆఏండ నా కికు, నా బుర్రబా నొర్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","అందెఙె యేసు, “ఏరుఈబతి వన్నిఙ్‌ వన్నిఒడొఃల్‌ విజు నొర్‌దెఙ్‌ అవ్‌సరం సిల్లెద్‌. వన్ని పాదమ్‌కునె నొర్‌దెఙ్. ఎందానిఙ్‌ ఇహిఙ, పాదమ్‌కునె వెటనె డుల్లిఆనె. నా సిసూర్‌ ఆత్తి మీరు విజిదెరె సుబ్రరం ఆతిదెర్. గాని ఒరెన్‌ ఆఏన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","వన్నిఙ్‌సెఇవరి కీదు ఒపజెప్నికాన్‌ ఎయెన్‌ ఇజి వాండ్రు నెసి మహాన్‌. అందెఙె ‘మీరు విజెరె సుబ్రరం ఆత్తికిదెర్‌ ఆఇదెర్‌’, ఇజి వాండ్రు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","వరి పాదమ్‌కు నొర్‌జి వీస్తి వెన్కా, వాండ్రు లాగితి ఇడ్తి వన్ని సాల్వ ప్‌డ్ఃగితాండ్రె, బోజనమ్‌దిఙ్‌ బస్తిమహి బాడిఃదు సొహాన్‌. సొహాండ్రె వాండ్రు వరిఙ్‌ వెన్‌బాజినాన్, “నాను ఏలు మిఙి కితిపణిది అర్దం మిఙి తెలినాదా? ");
INSERT INTO kfc_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","మీరు నఙి కూక్నివలె, ‘ఓ బోదకినికి’ ఇజినొ, ‘ఓ ప్రబువా’ ఇజినొ కూక్‌సినిదెర్. నాను బోదకినికానె. ప్రబునె. అందెఙె మీరు కూక్సినిక తప్ప సిల్లెద్‌. ");
INSERT INTO kfc_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ఏలు మీ ప్రబు ఆతి, బోదకినికి ఆతి నాను నీ పాదమ్‌కు నొర్‌త మన్న. అందెఙె మీరుబా ఒరెన్‌ మరి ఒరెన్‌ వన్ని పాదమ్‌కు నొర్‌దెఙ్. ");
INSERT INTO kfc_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","నాను మిఙి కితిలెకెండ్‌ మీరు బా కిని వందిఙ్, అయా పణి ఎలాగ కిదెఙ్‌ఇజి నాను మిఙి తోరిస్త మన్న. ");
INSERT INTO kfc_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","నాను నిజం వెహ్సిన, ఎమేణి పణి మన్నిసి బా వన్ని ఎజుమాని ముస్కు పెరికాన్‌ ఆఎన్. అయ లెకెండ్‌ ఎమేణి కబ్రు తనికాన్‌బా వన్నిఙ్‌పోక్తి వన్ని ముస్కు పెరికాన్‌ ఆఏన్. ");
INSERT INTO kfc_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","మీరు ఏలు యా నిజమాతి సఙతిఙ్‌ నెస్తిదెర్. అందెఙె మీరు అయా లెకెండ్‌కితిఙ మీరు గొప్ప వారు”. ");
INSERT INTO kfc_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“మీరు పాపమ్‌కాణిఙ్‌నొరె ఆత్తిదెర్‌ ఇజి నాను వెహ్సినిక మీ విజెరె వందిఙ్‌ ఆఏద్. నాను ఏర్‌పాటు కితికార్‌ ఎలాగ మర్తికార్‌ఇజి నాను నెస్న. గాని, ‘నా వెట బోజనం ఉణిజి మహికాన్‌నఙి పడ్ఃఇకాన్‌ ఆతాన్‌’, ఇజి దేవుణు మాటదు రాస్తి మన్ని మాట పూర్తి ఆదెఙ్‌ నాను యా లెకెండ్‌ కిత్త. ");
INSERT INTO kfc_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","అయాక జర్గినివలె, నానె మెసయ ఇజి మీరు నమినివందిఙె, అయాక జర్గిని ముఙాల, యెలె నాను వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","నాను నిజం వెహ్సిన, ఎయెన్‌బా నాను పోక్నివన్నిఙ్‌డగ్రు కితిఙ, వాండ్రు నఙి డగ్రు కితి లెకెండ్. ఎయెన్‌బా నఙి డగ్రు కితిఙ, నఙి పోక్తి వన్నిఙ్‌డగ్రు కితి లెకెండ్”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","యేసు యాక వెహ్తివలె వన్ని మన్సుదు బాద ఆతండ్రె, “నాను నిజం వెహ్సిన, మీ లొఇ ఒరెన్‌ నఙి సెఇవరి కీదు ఒపజెప్నాన్‌లె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","అయావలె వన్ని సిసూర్‌ ఎయెన్‌వందిఙ్‌ వాండ్రు ఈహు వెహ్తాన్‌‌ ఇజి అర్దం ఆఇతిఙ్‌ ఒరెన్‌ మొకొం ఒరెన్‌సుడెః ఆజినార్. ");
INSERT INTO kfc_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","బోజనమ్‌దిఙ్‌ బస్తి మహివలె, సిసూర్‌ లొఇ యేసు నండొ ప్రేమిస్తి సిసూ వన్ని డగ్రునె బోజనమ్‌దిఙ్‌ బస్త మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","సిమోన్‌ పేతురు వన్నిఙ్‌ సయ్‌న కిజి, “ఎయెన్‌ వందిఙ్‌ వాండ్రు వర్గిజినాన్‌ఇజి వన్నిఙ్‌ వెన్‌బాఅ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","అందెఙె అయా సిసూడుః యేసుఙ్‌ రోస్‌పె ఆజి, “ప్రబువా, వాండ్రు ఎయెన్‌?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","అందెఙె యేసు, “నాను యా రొటె ముక పులాదు ముడుక్సి ఎయెన్‌సీనానొ వాండ్రె నఙి ఒపజెప్నికాన్”, ఇజి వెహ్తాన్‌. వెహ్తండ్రె ముక పులాదు ముడుక్సి సిమొను మరిసి ఆతి ఇస్కరియొతు యుదెఙ్‌ సిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","యూద అయా రొట్టెముక్క తిహి వెటనె సయ్‌తాను వన్ని లొఇ డుగితాండ్రె వన్ని ముస్కు అతికారం కితాన్. అయావలె యేసు, “నీను కిదెఙ్‌ ఒడ్ఃబిజినిక బేగి కిఅ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","గాని బోజెనమ్‌దిఙ్‌ బస్తివరి లొఇ ఎయెరిఙ్‌బా ఎందానిఙ్‌ యేసు ఆహె వెహ్తాన్‌‌ ఇజి అర్దం ఆఏతాద్. ");
INSERT INTO kfc_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","వరి కర్‌సువందిఙ్‌ మన్ని డబ్బు విజు యూద కీదునె మనె. అందెఙె పండొయ్‌దిఙ్‌ కావాలిస్తికెఙ్, సొన్సి కొల్‌అ ఇజిసు, సిలిఙ బీదాతివరిఙ్‌ డబ్బు సిఅ ఇజి వెహ్సినాన్‌సు ఇజి సిసూర్‌ సెగొండార్‌ ఒడిఃబితార్. ");
INSERT INTO kfc_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","యూద ఆ రొట్టెముక్క తిహివెటనె వెల్లి సొహాన్‌. అక్క రెయు. ");
INSERT INTO kfc_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","వాండ్రు సొహి వెన్కా యేసు ఈహు వెహ్తాన్‌, “లోకు మరిసి ఆతి నాను ఎసొ గొప్ప పెరికాన్‌ ఇజి లోకుర్‌ ఏలునూణార్లె. దేవుణు ఎసొ గొప్ప పెరికాన్‌ ఇజి నా వెట సూణార్‌లె. ");
INSERT INTO kfc_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","దేవుణు గొప్ప పెరికాన్‌ ఇజి లోకు మరిసి వెట తోరె ఆతిఙ, లోకు మరిసి గొప్ప పెరికాన్‌ ఇజి దేవుణునె తోరిస్నాన్. అయాక వెటనె తోరిస్నాన్. ");
INSERT INTO kfc_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","నాను ప్రేమిస్నికిదెరా, కండెక్‌ సమయమ్‌నె నాను మీ వెట మంజిన. మీరు నఙి రెబానిదెర్, గాని యూదురు అదికారిఙ నాను వెహ్తి లెకెండ్, “నాను సొని బాడిఃదు మీరు వాదెఙ్‌ అట్‌ఇదెర్‌’ ఇజి ఏలు మీవెట వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","నాను కొత్త ఆడ్ర మిఙి సీజిన. మీరు ఒరెన్‌ మరి ఒరెన్‌ వన్ని వెట ప్రేమిస్‌అ, ఇజి. నాను మిఙి ప్రేమిస్తిలెకెండ్‌ మీరు బా ఒరెన్‌ వన్ని వెట ఒరెన్‌ ప్రేమిస్తెఙ్‌వలె. ");
INSERT INTO kfc_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","మీరు ఒరెన్‌ వన్ని వెట ఒరెన్‌ ప్రేమిస్తిఙ, మీరు నా సిసూర్‌ ఇజి లోకుర్‌ విజెరె నెస్నార్. ");
INSERT INTO kfc_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","అయావలె సిమోన్‌ పేతురు, “ప్రబువా, నీను ఎంబె సొన్‌సిని?”, ఇజి వెన్‌బాతాన్. వెన్‌బాతిఙ్‌ యేసు, “నాను ఏలు సొని బాడిఃదు నీను ఏలు వాదెఙ్‌అట్‌ఇ. గాని వెన్కా వానిలె”, ఇజి వెహ్తాన్‌‌ ");
INSERT INTO kfc_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","అందెఙె పేతురు, “ప్రబువా, ఎందానిఙ్‌ నాను ఏలు మీ వెట వాదెఙ్‌ అట్‌ఇ. నీ వందిఙ్‌ సాదెఙ్‌బా నాను తయార్‌నె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","అందెఙె యేసు, “నా వందిఙ్‌ సాదెఙ్‌బా నీను నిజం తయార్‌నెనా? కొరు కెరెని ముఙాలె, ‘నీను నఙి నెస్‌ఏ’ ఇజి ముసార్‌ వెహ్నిలె”, ఇజి వెహ్తాన్‌‌. ");
INSERT INTO kfc_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","యేసు మరిబా వన్ని సిసూరిఙ్‌ వెహ్సినాన్, “మీ మన్సుదు తియెల్‌ ఆజి బాద ఆమాట్. దేవుణు ముస్కు నమకం ఇడ్తిదెర్. నా ముస్కుబా నమకం ఇడ్ఃదు. ");
INSERT INTO kfc_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","పరలోకమ్‌దు నా బుబ్బ ఇండ్రొ నండొ గదిఙ్‌మనె. అయ లెకెండ్‌ సిల్లెండ మహిఙ, నాను మిఙి వెహ్త మరి. మిఙి ఉండ్రి బాడిః తయార్‌కిదెఙ్‌ నాను అబ్బె సొన్సిన. ");
INSERT INTO kfc_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","నాను సొన్సి మిఙి ఉండ్రి బాడ్డి తయార్‌ కితి వెనుక, నాను మర్‌జివాజి నావెట నాను మంజినిబాన్‌ మీరుబా మండ్రెఙ్, కూక్న ఒనాలె. ");
INSERT INTO kfc_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","నాను సొన్సిని బాడిఃదు సొండ్రెఙ్‌ సరి మీరు నెస్నిదెర్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","అయావలె తోమా వన్నిఙ్, “ప్రబువా, నీను ఎంబె సొన్సిని ఇజి మాపు నెస్‌ఏప్. అందెఙె సరి మాపు ఎలాగ నెస్తెఙ్‌ ఆనాప్‌?”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","అందెఙె యేసు వన్నిఙ్, “నానె బుబ్బ డగ్రు సొండ్రెఙ్‌ సరి. నానె బుబ్బ వందిఙ్‌ నిజమాతికెఙ్‌ తోరిసి నెస్‌పిస్నాన్. నానె ఎలాకాలం దేవుణు వెట బత్కిని బత్కు సీనికాన్. నా వెటనె లోకుర్‌ విజెరె బుబ్బడగ్రు సొనార్. ");
INSERT INTO kfc_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","నాను ఎయెన్‌ ఇజి మీరు నెస్తి మహిదెర్‌ఇహిఙ, నా బుబ్బ ఎయెన్‌ఇజిబా మీరు నెస్తిదెర్‌మరి. ఏలుదాన్‌ మీరు వన్నిఙ్‌నెస్తి మనిదెర్, సుడిఃతి మనిదెర్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","నస్తివలె పిలిపు, “ప్రబువా, బుబ్బెఙ్‌ మఙి తోరిస్‌అ. ఆకాదె మఙి సాలు”, ఇజి వన్నిఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","అందెఙె యేసు వన్నిఙ్, నాను నిసొ కాలం మీ వెట మహ. మహిఙ్‌బా నీను నఙి నెస్‌ఇదా పిలిపు? నఙి సుడ్ఃతికాన్‌ ఎయెన్‌బా నా బుబ్బెఙ్‌ సుడ్ఃత మనాన్. అయావలె బుబ్బెఙ్‌మఙి తోరిస్‌అ ఇజి ఎలాగ నీను వెహ్తెఙ్‌ అట్‌సిని? ");
INSERT INTO kfc_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","నాను నా బుబ్బ వెట కూడిఃత మన. బుబ్బ నా వెట కూడిఃత మనాన్‌ ఇజి నీను నమ్‌ఇదా? నాను మీ వెట వెహ్సిని మాటెఙ్‌నా సొంత మాటెఙ్‌ ఆఉ. గాని నా వెటకూడిఃతి మన్ని బుబ్బ బాణిఙ్‌వాతికెఙె అయాకెఙ్. వాండ్రు వన్ని పణిఙ్‌ నావెట కిబిసినాన్. ");
INSERT INTO kfc_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","నాను నా బుబ్బ వెట కూడిఃత మన, బుబ్బ నా వెట కూడిఃత మనాన్‌ ఇజి నాను వెహ్సినిక మీరు నమ్మిదు. సిలిఙ, నాను కిజిని విజు బమ్మ ఆని పణిఙ సుడ్ఃజి అయాక నమ్మిదు. ");
INSERT INTO kfc_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","నాను నా బుబ్బ డగ్రు సొన్సిన. అందెఙె నఙి నిజం నమ్మితికాన్, నాను కిజిని బమ్మ ఆని పణిఙ్‌ వాండ్రు బా కినాన్. ఒఒ, దనిఙ్‌ఇంక లావు పణిఙ్‌ వాండ్రు కినాన్‌ ఇజి మీ వెట నిజం ఇక వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","నా ఇస్టమ్‌దిఙ్‌ కూడిఃతి మన్ని ఇనికబా మీరు లొస్తిఙ, నాను అయాక కిన. బుబ్బ గొప్ప పెరికాన్‌ ఇజి లోకురిఙ్‌ తోరిస్తెఙె, మరిసి ఆతి నాను అయాక కిన. ");
INSERT INTO kfc_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","నా ఇస్టమ్‌దిఙ్‌ కూడిఃతి మన్ని ఇనికబా మీరు లొస్తిఙ, నాను అయాక కిన. ");
INSERT INTO kfc_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","మీరు నఙి ప్రేమిస్తిఙ, నా ఆడ్రెఙ్‌మీరు వెనిదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","నాను బుబ్బెఙ్‌ లొస్న. మీ వెట ఎలాకాలం మండ్రెఙ్‌ మరి ఒరెన్‌ తోడుః మంజిని వన్నిఙ్‌ బుబ్బ మిఙి సీనాన్. ");
INSERT INTO kfc_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","వాండ్రు దేవుణు బాణిఙ్‌ నిజమాతికెఙ్‌ వెహ్సిని దేవుణు ఆత్మ. క్రీస్తుఙ్‌ నమ్మిఇకార్‌ ఒరెన్‌ తోడుః మంజిని వన్ని వజ వన్నిఙ్‌ డగ్రు కిదెఙ్‌ అట్‌ఏర్. ఎందనిఙ్‌ ఇహిఙ, వారు వన్నిఙ్‌ రెబాఏర్. వన్నిఙ్‌ నెస్‌ఎర్. గాని మీరు వన్నిఙ్‌ నెస్నిదెర్. ఎందానిఙ్‌ ఇహిఙ, వాండ్రు మీ వెట మంజినాన్. మీ లొఇ మంజినాన్. ");
INSERT INTO kfc_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","నాను మిఙి డిఃసి సొనివలె, మిఙి దిక్కు సిలి వరి లెకెండ్‌డిఃస్‌ఎ. నాను మర్‌జి మీ డగ్రు వానాలె. ");
INSERT INTO kfc_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","సెగం కాలం వెన్కా, నఙి నమ్మిఇకార్‌ నఙి మరి తొఎర్‌లె. గాని మీరు నఙి సూణిదెర్. నాను బత్కిజిన. అందెఙె మీరుబా బత్కినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","నాను నా బుబ్బవెట కూడిఃత మన్న, మిరు నా వెట కూడిఃతి మనిదెర్. నాను మీ వెట కూడిఃత మన ఇజి దేవుణు ఆత్మ మీ నడిఃమి మండ్రెఙ్‌వాని దినమ్‌దు మీరు నెస్నిదెర్లె. ");
INSERT INTO kfc_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","నా ఆడ్రెఙ్‌ వెంజి అయావజ కినికానె నఙి ప్రేమిస్నికాన్. నఙి ప్రేమిస్ని వన్నిఙ్‌ నా బుబ్బ ప్రేమిస్నాన్. నాను వన్నిఙ్‌ప్రేమిసి వన్నిఙ్‌తోరె ఆన”, ఇజి యేసువెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","నస్తివలె ఇస్కరియొతు యూద ఆఇ మరి ఒరెన్‌యుద, “ప్రబువా నీను లోకురిఙ్‌ విజెరిఙ్‌ తోరెఆఏండ, ఎలాగ నీను మఙి తోరె ఆనిలె?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","అందెఙె యేసు, “ఒరెన్‌ నఙి ప్రేమిస్తిఙ, వాండ్రు నా మాటెఙ్‌ వినాన్. అయావలె నా బుబ్బ వన్నిఙ్‌ ప్రేమిస్నాన్. నా బుబ్బని నాను వన్నిడగ్రు వాజి వన్నివెట మంజినాప్. ");
INSERT INTO kfc_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","నఙి ప్రేమిస్‌ఇకాన్, నా మాటెఙ్‌ విన్‌ఏన్. మీరు వెంజిని యా మాటెఙ్‌నా సొంత మాటెఙ్‌ ఆఉ. నఙి పోక్తి నా బుబ్బవినె. ");
INSERT INTO kfc_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","నాను మీవెట మంజినె యా మాటెఙ్‌ వెహ్త మన్న. ");
INSERT INTO kfc_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","నా బుబ్బ, నా బదులు తోడుః మంజిని వన్నిఙ్‌ ఇహిఙ, దేవుణు ఆత్మదిఙ్‌ పోక్నివెలె, వాండ్రు మిఙి దేవుణు వందిఙ్‌ విజు సఙతిఙ్‌ నెస్‌పిస్నాన్. నాను మిఙి వెహ్తి విజు వన్కాఙ్‌ ఎత్తు కిబిసి మంజినాన్. ");
INSERT INTO kfc_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","నాను మిఙి డిఃసి సొన్‌సిన. గాని మీరు సమాదనమ్‌దాన్‌ మంజినిదెర్‌లె. అయా సమాదనం నా బాణిఙ్‌ వాజినాద్. నఙి నమ్మిఇ లోకురిఙ్‌ మన్ని సమాదనం ననికాద్‌ ఆఏద్‌నా బాణిఙ్‌ వాజినికాద్. మీ మన్సుదు విసారిసి బాద ఆమాట్. మీరు తియెల్‌ ఆమాట్. ");
INSERT INTO kfc_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‘నాను సొన్‌సిన. మర్‌జి మీ డగ్రు వానాలె’, ఇజి నాను వెహ్తి మాట మీరు విహిదెర్. నా బుబ్బ నఙి ఇంక పెరికాన్. అందెఙె మీరు నఙి నిజం ప్రేమిస్తిఙ, వీండ్రు బుబ్బ డగ్రు సొన్‌సినాన్‌ఇజి సర్‌ద ఆజినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","యాకెఙ్‌ జర్గినివలె, నాను వెహ్తికెఙ్‌ నిజం ఇజి మీరు నమ్మిని వందిఙె, అయాకెఙ్‌ జర్గిని ముఙాల, ఇయేలె నాను మిఙి వెహ్త మన్న. ");
INSERT INTO kfc_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","మరి నండొ సమయం మీ వెట వర్గిదెఙ్‌నాను అట్‌ఏలె. ఎందానిఙ్‌ఇహిఙ, యా లోకమ్‌ది అతికారి ఆతి సయ్తాను వాజినాన్. నా ముస్కు వన్నిఙ్‌ఇన్ని అతికారం సిల్లెద్‌. ");
INSERT INTO kfc_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","గాని, నాను నా బుబ్బెఙ్‌ ప్రేమిస్న. అందెఙె వాండ్రు వెహ్సినికెఙ్‌ విజు అయావజ నాను కిజిన ఇజి లోకమ్‌దికార్‌ నెస్తెఙ్‌వలె. రదు, ఇబ్బెణిఙ్‌ సొనాట్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","నాను నిజమాతి ద్రాక్సబడ్డుదిఙ్‌ మొదొల్. నా బుబ్బ పణికినికాన్. ");
INSERT INTO kfc_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","నా వెట కూడిఃతి మన్ని పట్కు అస్‌ఇ విజు కొనెఙ్‌ వాండ్రు కత్‌నాన్. పట్కుఅస్‌ని విజు కొనెఙ్, మరి నండొ పట్కు అస్నివందిఙ్‌ తెప్నాన్. ");
INSERT INTO kfc_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","నాను మీవెట వెహ్తి మాటెఙ్, మీ పాపమ్‌కాణిఙ్‌ సుబ్బరం కిత్తె మనె. ");
INSERT INTO kfc_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","నాను మీ వెట కూడ్ఃజి మంజినిలెకెండ్‌ మీరు నా వెట కూడ్ఃజినె మండ్రు. ఇన్ని కొనెఙ్‌బా బడ్డుదు మన్‌ఏండ మహిఙ, అవి పట్కు అస్‌ఉ. పట్కు అస్తెఙ్‌ఇహిఙ, అవి బడ్డదు మండ్రెఙ్‌వలె. అయాలెకెండ్, నావెట కూడిఃతి మహిఙనె, మీరు పట్కు అస్నిదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","నాను ద్రాక్సబడ్డఉదిఙ్‌ మొదొల్. మీరు కొనెఙ్. ఎయెన్‌బా నా వెట కూడ్ఃజి మంజి, నాను వన్ని వెట కూడిఃతి మహిఙ, వాండ్రు నండొ పట్కు అస్నాన్. నాను సిల్లెండ, నఙి ఇస్టం ఆతి నెగ్గికెఙ్‌ ఇనికెఙ్‌బా మీరు కిదెఙ్‌ అట్‌ఇదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","వెల్లి విసీర్తి ఉండ్రి కొన వహ్తి లెకెండె, నా వెట కూడ్ఃజి మన్‌ఇకాన్‌మనాన్. వాండ్రు వెల్లి ఆజి వహ్నన్. నన్ని కొనెఙ, లోకుర్‌ కుంబ కిజి సుర్‌నార్. ఆకెఙ్‌ వెయ్‌నె. ");
INSERT INTO kfc_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","మీరు నావెట కూడ్ఃజినె మంజి నాను వెహ్తిక మీ లొఇ మహిఙ, ఇనికబా మీరు దేవుణుదిఙ్‌ లొస్తు. వాండ్రు అయాక మిఙి సీనాన్. ");
INSERT INTO kfc_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","మీరు నండొ పట్కు అసి ఆహె నా సిసూర్‌ఇజి తోరె ఆతిఙ, నా బుబ్బ గొప్ప పెరికాన్‌ ఇజి లోకురిఙ్‌ తోరిసినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","నా బుబ్బ నఙి ప్రేమిస్ని లెకెండ్, నాను మిఙి ప్రేమిస్న. నాను మిఙి ప్రేమిస్ని వందిఙ్, నా వెట కూడ్ఃజినె మండ్రు. ");
INSERT INTO kfc_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","నాను నా బుబ్బ వెహ్తి ఆడ్రెఙ్‌లొఙిత మన. వాండ్రు నఙి ప్రేమిస్నాన్. అయాలెకెండ్‌ మీరు నాను వెహ్తి ఆడ్రెఙ్‌లొఙితిఙ, నాను మిఙి ప్రేమిసినె మంజిన. ");
INSERT INTO kfc_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","నఙి మన్ని సర్‌ద మిఙి బా మండ్రెఙ్, మీ సర్‌ద పూర్తి ఆదెఙ్, ముఙాలె వెహ్తి యా మటెఙ్‌నాను మిఙి వెహ్త మన్న. ");
INSERT INTO kfc_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","నాను మిఙి ప్రేమిసివజ, మీరు ఒరెన్‌ వన్ని వెట ఒరెన్‌ ప్రేమిసి మండ్రు ఇజినె నా ఆడ్ర. ");
INSERT INTO kfc_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ఒరెన్‌ వన్ని కూలెఙ వందిఙ్‌ వన్ని సొంత పాణం సీనికాదె నండొ ప్రేమ. దిని ఇంక మిస్తి మరి ప్రేమ సిల్లెద్‌. ");
INSERT INTO kfc_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","నాను ఆడ్ర సితిక మీరు కితిఙ, మీరు నా కూలెఙె. ");
INSERT INTO kfc_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ఒరెన్‌ పణికినికాన్, వన్ని ఎజుమాని కిని పణిఙ్‌ నెస్‌ఎన్. అందెఙె నాను మరి ఎసెఙ్‌ మిఙి పణికినికార్‌ ఇజి కూక్‌ఏ, గాని కూలెఙ్‌ ఇజి కూక్త మన. ఎందనిఙ్‌ ఇహిఙ, నాను నా బుబ్బ బాణిఙ్‌ విహికెఙ్‌ విజు మిఙి వెహ్త మన్న. ");
INSERT INTO kfc_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","మీరు నఙి ఏర్‌పాటు కిఇదెర్. గాని నాను మిఙి ఏర్‌పాటు కిత్త. పట్కు అస్నివజ, మీరు సొన్సి లోకురిఙ్‌ సువార్త వెహ్సి దేవుణు దరొట్‌ మహ్సి తని వందిఙె నాను మిఙి ఏర్‌పాటు కితానె పోక్సిన. మీరు అస్తి పట్కు ఎలాకాలం మంజినాద్. అయావలె మీరు నా ఇస్టమ్‌దిఙ్‌ కూడిఃతి మన్ని ఇనికబా బుబ్బెఙ్‌ లొస్తిఙ, వాండ్రు సీనాన్. ");
INSERT INTO kfc_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","మీరు ఒరెన్‌ వన్నివెట ఒరెన్‌ ప్రేమిస్తెఙ్‌ ఇజినె నాను సీజిని ఆడ్ర. ");
INSERT INTO kfc_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","యా లోకమ్‌దు మన్ని దేవుణుదిఙ్‌ దూసిస్నికార్, మిఙి దూసిస్తిఙ, మీరు ఒడిఃబిదు వారు మిఙి దూసిస్ని ముఙాలె నఙి దూసిస్తార్‌ ఇజి. ");
INSERT INTO kfc_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","మీరు యా లోకమ్‌దు మన్ని దేవుణుదిఙ్‌ దూసిస్ని వరిలొఇ మన్నికిదెర్‌ ఇహిఙ, వరి సొంత లోకుర్‌వజ వారు మిఙి ప్రేమిస్తార్‌ మరి. గాని నాను వరి లెకెండ్‌ మీరు మన్‌ఎండ, మిఙి ఎర్లిస్త. అయావలె, మీరు వరి లొఇ మన్నికిదెర్‌ ఆఇదెర్. అందెఙె వారు మిఙి దూసిసినార్. ");
INSERT INTO kfc_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ఎమేణి పణిమణిసిబా‌ వన్ని ఎజుమాని ముస్కు పెరికాన్‌ ఆఏన్‌’, ఇజి నాను వెహ్తి మాట మీరు ఎత్తు కిదు. వారు నఙి హిమ్సెఙ్‌ కితార్‌ ఇహిఙ, మిఙి బా హిమ్సెఙ్‌ కినార్. వారు నా మాటెఙ్‌ లొఙితార్‌ ఇహిఙ, మీ మాటెఙ్‌బా లొఙినార్. ");
INSERT INTO kfc_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","మీరు నఙి నమ్మితి వందిఙ్‌ వారు యా లెకెండ్‌ విజు మిఙి కినార్. ఎందానిఙ్‌ ఇహిఙ, వారు నఙి పోక్తి వన్నిఙ్‌ నెస్‌ఏర్. ");
INSERT INTO kfc_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","నాను వాజి దేవుణు వందిఙ్‌ నిజమాతికెఙ్‌ వరిఙ్‌ వెహ్‌ఏండ మంజినిక ఇహిఙ, వారు పాపమ్‌కు కితార్‌ ఇజి దేవుణు వరిఙ్‌ సుడ్ఃఏతాన్‌ మరి. అహిఙ, ఏలు వారు వరి పాపమ్‌కాణిఙ్‌ తప్రె ఆదెఙ్‌ అట్‌ఏర్. ఎందానిఙ్‌ ఇహిఙ, నాను వరిఙ్‌ వెహ్త మన్న. ");
INSERT INTO kfc_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","నఙి దూసిస్నికాన్‌నా బుబ్బెఙ్‌ దూసిసినాన్. ");
INSERT INTO kfc_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ఎయెన్‌బా కిఇ బమ్మాని పణిఙ్‌ నాను వరి నడిఃమి కిఏండ మంజినిక ఇహిఙ, వారు పాపమ్‌కు కితార్‌ ఇజి దేవుణు వరిఙ్‌ సుడ్ఃఏతాన్‌ మరి. గాని ఏలు వారు యా బమ్మ ఆని పణిఙ్‌ సుడుఃత మనార్. అహిఙ్‌బా, నఙి ని నా బుబ్బెఙ్‌ వారు దూసిస్త మనార్. ");
INSERT INTO kfc_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","‘ఇని కారణంబా సిల్లెండ వారు నఙి దూసిస్తార్‌’, ఇజి దేవుణు మాటదు రాస్తి మన్ని మాట పూర్తి అదెఙె యా లెకెండ్‌ వారు కిజినార్. ");
INSERT INTO kfc_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","నాను మీ డగ్రు తోడుః మంజిని వన్నిఙ్‌ ఇహిఙ, దేవుణుబాణిఙ్‌ నిజమాతికెఙ్‌ వెహ్సి తోరిస్ని దేవుణు ఆత్మెఙ్‌ పోక్న. వాండ్రు బుబ్బ బాణిఙ్‌ మీ డగ్రు వానాన్. అయావలె నా వందిఙ్‌ విజు వాండ్రు వెహ్నన్. ");
INSERT INTO kfc_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","నాను సేవ మొదొల్‌స్తి బాణిఙ్‌ మీరు నావెట మనిదెర్. అందెఙె మీరు బా నా వందిఙ్‌ విజెరిఙ్‌ వెహ్తెఙ్‌వలె. ");
INSERT INTO kfc_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“మిఙి ఇమ్‌సెఙ్‌ కినివలె, మీరు నమకం దాన్‌డిఃస్‌ఏండ మంజిని వందిఙె, మిఙి దూసిస్నికార్‌ కిని సఙతిఙ వందిఙ్‌ నాను వెహ్త. ");
INSERT INTO kfc_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","వారు మిఙి యూదురి మీటిఙ్‌ఇల్కాణిఙ్‌వెల్లి కినార్. మిఙి సప్నికాన్‌ఎయెన్‌బా, వాండ్రు దేవుణుదిఙ్‌ సర్ద కిజిన ఇజి ఒడిఃబిని కాలం వాజినె. ");
INSERT INTO kfc_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","వారు నన్నికెఙ్‌ కినార్. ఎందనిఙ్‌ఇహిఙ, బుబ్బెఙ్‌నొ నఙినొ నెస్‌ఏర్. ");
INSERT INTO kfc_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","అయ కాలం వానివలె, నాను దినివందిఙ్‌ వెహ్త మన ఇజి మీరు ఎత్తుకిని వందిఙ్‌ నాను యాక మీ వెట వెహ్త మన. నాను యాకెఙ్‌ ముఙాలె మిఙి వెహ్తెఙ్‌సిలె. ఎందానిఙ్‌ఇహిఙ, నాను మీవెట మహ”. ");
INSERT INTO kfc_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“ఏలు నాను నఙి పోక్తి వన్ని డగ్రు సొన్సిన. గాని మీ లొఇ ఎయెన్‌బా, ‘నీను ఎంబె సొన్సిని?’, ఇజి నఙి వెన్‌బాఇదెర్”. ");
INSERT INTO kfc_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","నాను యా సఙతిఙ్‌ మిఙి వెహ్తి మనిఙ్, మీ మన్సుసు దుకమ్‌దాన్‌ నిండ్రిత మనాద్. ");
INSERT INTO kfc_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","గాని నాను నిజం మీ వెట వెహ్సిన, మిఙి మేలు వాని వందిఙె నాను సొన్సిన. నాను సొన్‌ఏండ మహిఙ, తోడుః మంజినికాన్‌ మీ డగ్రు రెఏన్. గాని నాను సొహిఙ, నాను వన్నిఙ్‌ మీ డగ్రు పోక్న. ");
INSERT INTO kfc_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","వాండ్రు వాజి, దేవుణుదిఙ్‌ నమ్మిఇవరిఙ్ ‌పాపం ఇహిఙ ఇన్నిక ఇజి, నాను నీతి నిజాయితి మన్నికాన్‌ ఇజి, దేవుణు సీని ఎలాకాలం మన్ని సిక్స ఇన్నిక ఇజి కసితం వెహ్సి తోరిస్నాన్. ");
INSERT INTO kfc_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","వారు పాపం కిత్తమనార్‌ ఇజి వాండ్రు కసితం వెహ్సి తోరిస్నాన్. ఎందానిఙ్‌ఇహిఙ, వారు నఙి నమ్మిఏర్. ");
INSERT INTO kfc_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","నాను నీతి నిజాయితి మన్నికాన్‌ఇజి వాండ్రు కసితం వెహ్సి తోరిస్నాన్. ఎందనిఙ్‌ఇహిఙ, నాను నా బుబ్బ డగ్రు సొన్‌సిన. మీరు నఙి మరి తొఇదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","దేవుణు సీని ఎలాకాలం మన్ని సిక్స ఇన్నిక ఇజి వరిఙ్‌ కసితం వెహ్సి తోరిస్నాన్. ఎందానిఙ్‌ ఇహిఙ, దేవుణుదిఙ్‌ నమిఇ వరి ముస్కు అతికారం కిని సయ్‌తానుఙ్, దేవుణు ఎలాకాలం మన్ని సిక్స సిత్తమనాన్. ");
INSERT INTO kfc_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","‘నఙి మరి నండొ మిఙి వెహ్తెఙ్‌మనాద్, గాని ఏలు మీరు నసొ అర్దం కిదెఙ్‌ అట్‌ఇదెర్. ");
INSERT INTO kfc_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","గాని దేవుణు వందిఙ్‌ నిజమాతికెఙ్‌ నెస్‌పిస్ని దేవుణు ఆత్మ వానివలె, వాండ్రు దేవుణు బాణిఙ్‌ వాజిని విజు నిజమాతికెఙ్‌ మీరు నెస్తెఙ్‌ మిఙి నడిఃపిసినాన్. వాండ్రు వన్ని సొంతదిక ఇనికబా వెహ్‌ఎన్. గాని బుబ్బ వెహ్సినికెఙ్‌వెంజి మిఙి వెహ్నన్. వాండ్రు జర్గిని వన్కాఙ్‌ వందిఙ్‌ మిఙి వెహ్నన్. ");
INSERT INTO kfc_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","నాను వెహ్సిని నిజమాతికెఙ్‌ వెంజి, అయాక మిఙి వెహ్నన్. అయ లెకెండ్‌ నాను గొప్ప పెరికాన్‌ ఇజి మిఙి తోరిస్నాన్. ");
INSERT INTO kfc_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","బుబ్బెఙ్‌ మన్నికెఙ్‌ విజు నాదినె. అందెఙె నాను వెహ్త, నాను వెహ్సిని నిజమాతికెఙ్‌ వాండ్రు వెంజి, అయాక మిఙి వెహ్నన్‌ ఇజి. ");
INSERT INTO kfc_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","సెగం రోస్కు వెన్కా, నాను సొన. మీరు నఙి మరి తొఇదెర్. మరి సెగం రోస్కు వెన్కా, మీరు నఙి సూణిదెర్”. ");
INSERT INTO kfc_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","వన్ని సిసూర్‌ లొఇ సెగొండార్‌ ఒరెన్‌ వెట ఒరెన్‌ ఈహు వెహ్తాన్‌, “సెగం కాలం వెన్కా మీరు నఙి తొఇదెర్. మరి సెగం కాలం వెన్కా మీరు నఙి సూణిదెర్. నాను నా బుబ్బ డగ్రు సొన్‌సిన. అందెఙె మీరు నఙి తొఇదెర్”, ఇజి వాండ్రు వెహ్సిని తర్‌దం అర్దం ఇనిక? ఇజి. ");
INSERT INTO kfc_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“‘సెగం కాలం’ ఇజి వాండ్రు వెహ్సిని దని అర్దం ఇన్నిక? వాండ్రు వెహ్సిని దనిఙ్‌ మఙి అర్దం రెఏండ ఆజినాద్”, ఇజి మరి వర్గిజినె మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","దినివందిఙ్‌వారు వన్నిఙ్‌ వెన్‌బాదెఙ్‌ కోరిజినార్‌ ఇజి యేసు నెస్తాండ్రె, ఈహు వరిఙ్‌ వెహ్సినాన్, “'సెగం కాలం వెన్కా మీరు నఙి తొఇదెర్. మరి సెగం కాలం వెన్కా మీరు నఙి సూణిదెర్‌’, ఇజి నాను వెహ్తి దని అర్దం ఇన్నిక ఇజినా మీరు ఒరెన్‌దిఙ్‌ ఒరెన్‌ వెన్‌బాజినిదెర్‌? ");
INSERT INTO kfc_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","మీరు దుకం కిజి అడఃబానిదెర్‌ గాని దేవుణుదిఙ్‌ దూసిస్నికార్‌ సర్‌ద ఆనార్. మీరు దుకం కినిదెర్‌ గాని మీ దుకం వెనుక సర్‌దమనాద్‌ ఇజి నాను మీ వెట నిజం వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ఉండ్రి బోదెలి ఏరుఈబదెఙ్‌ నొపిదిఙ్‌ అడఃబానాద్. ఎందానిఙ్‌ఇహిఙ, దనిఙ్‌నెగెండ్‌ ఆదెఙ్‌కాలం ఆతాద్. గాని దన్నికొడొః పుట్తిఙ, లోకమ్‌దు ఒరెన్‌పుట్తాన్‌ ఇజి సర్‌దదాన్‌ అయా బాదెఙ్‌ అది ఎత్తు కిఏద్. ");
INSERT INTO kfc_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","అయాలెకెండె మిఙి బా. మీరు ఏలు దుకం ఆనిదెర్. గాని నాను మర్‌జి వానివలె మిఙి మరి సూణ. అయావలె మీరు సర్‌దఆనిదెర్. అయా సర్‌ద ఎయెన్‌బా మీ బాణిఙ్‌లాగ్‌దెఙ్‌అట్‌ఎన్. ");
INSERT INTO kfc_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","నాను నిఙితి సొహి వెన్కా, మీరు ఇనికబా నెస్తెఙ్‌నఙి వెన్‌బాఇదెర్. ఎందానిఙ్‌ ఇహిఙ, దేవుణు ఆత్మ మిఙి నెస్‌పిస్నాన్. నా ఇస్టమ్‌దిఙ్‌ కూడిఃతి మన్నికెఙ్‌ఇన్నికబా మీరు బుబ్బెఙ్‌ లొస్తిఙ, వాండ్రు అయాక సీనాన్, ఇజి నాను నిజం మీ వెట వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ఏలుదాక నా ఇస్టమ్‌దిఙ్‌ కూడిఃతి మన్నికెఙ్‌ ఇన్నికబా లొస్‌ఇతిదెర్. మీ సర్‌ద పూర్తి ఆని వందిఙ్‌లొస్తు. మిఙి దొహ్క్‌నాద్. ");
INSERT INTO kfc_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","నాను మిఙి కతవజ యా సఙతిఙ్‌నెస్‌పిస్త మన. గాని కతవజ నెస్‌పిస్‌ఏండ, బుబ్బ వందిఙ్‌ మిఙి టెట అర్దం ఆనిలెకెండ్‌ వెహ్ని కాలం వాజినాద్. ");
INSERT INTO kfc_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","అయా కాలమ్‌దు, నా ఇస్టమ్‌దిఙ్‌ కూడిఃతి మన్నికెఙ్‌ మీరు లొస్నిదెర్. మీరు లొస్తికెఙ్‌ వరిఙ్‌ సిఅ ఇజి బుబ్బెఙ్‌ వెహ్న ఇజి నాను వెహ్‌ఏ. ");
INSERT INTO kfc_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ఎందానిఙ్‌ ఇహిఙ, బుబ్బనె మిఙి నండొ ప్రేమిస్నాన్. మీరు నఙి ప్రేమిస్నిదెర్. నాను బుబ్బ బాణిఙ్‌వాత ఇజి మీరు నమిజినిదెర్. అందెఙె వాండ్రు మిఙి నండొ ప్రేమిస్నాన్. ");
INSERT INTO kfc_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","నాను బుబ్బ బాణిఙె యా లోకమ్‌దు వాత. ఏలు నాను యా లోకం డిఃసి మర్‌జి బుబ్బ డగ్రు సొన్సిన”. ");
INSERT INTO kfc_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","నస్తివలె వన్ని సిసూర్, “ఇదిలో, వానివలె నీను కత లెకెండ్‌ ఆఏండ, అర్దం ఆని లెకెండ్‌ వెహ్సిని. ");
INSERT INTO kfc_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","నీను విజు నెస్నికి ఇజి ఏలు మాపు నెసినాప్. ఎయెర్‌బా నిఙి వెన్‌బాఎండ ముఙాలె, వారు ఒడ్ఃబిజినికెఙ్‌ నీను నెసిని ఇజి మాపు నెసినాప్. అందెఙె నీను దేవుణు బణిఙ్‌వాతికి ఇజి మాపు నమ్మిజినాప్”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","అందెఙె యేసు, “మీరు ఏలు నమిజినిదెరా? ");
INSERT INTO kfc_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ఇదిలో, మీరు మీ ఇల్కాఙ్‌సెద్రిజి సొని కాలం వాజినాద్. అయాక ఏలె వాత మనాద్. మీరు నఙి డిఃసి సొనిదెర్‌లె. నాను ఒరెనె ఆన. గాని నాను ఒరెనె ఆఎ. నా బుబ్బ నావెట మనాన్. ");
INSERT INTO kfc_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","మీరు నా వెట కూడిఃతి మన్నిదెర్. అందెఙె మీరు సమాదనం దాన్‌ మండ్రెఙ్‌ నాను యా సఙతిఙ్‌ మిఙి వెహ్త మన. యా లోకమ్‌దు మిఙి కస్టమ్‌కు బాదెఙ్‌మనె. గాని దయ్‌రమ్‌దాన్‌ మండ్రు. నాను యా లోకమ్‌దు మన్ని దేవుణుదిఙ్‌ దూసిస్నివరిఙ్‌ గెలస్త మన్న. ");
INSERT INTO kfc_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","యా మాటెఙ్‌వెహ్సి వీస్తాండ్రె, యేసు ముస్కు పరలోకం దరోట్‌బేసి ఈహు పార్దనం కిజినాన్. “ఓ బా, నాను సాదెఙ్‌ నీను ఏర్‌పాటుకితి కాలండగ్రు ఆత మనాద్. నీను గొప్పపెరికి ఇజి నీ మరిన్‌ఆత్తి నాను తోరిస్ని వందిఙ్‌ని మరిన్‌ఆత్తి నాను గొప్పపెరికాన్‌ ఇజి నీను తోరిస్‌అ. ");
INSERT INTO kfc_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","నీను నఙి సితిలోకుర్‌ విజెరిఙ్‌ ఎలాకాలం దేవుణువెట బత్కినిబత్కు నాను సీనివందిఙ్, నీను లోకుర్‌ విజెరె ముస్కు నఙి అతికారం సిత్తి. ");
INSERT INTO kfc_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ఒరెండ్రె నిజమాతి దేవుణుఆతి నిఙిని, నీను యా లోకమ్‌దు పోక్తి యేసు క్రీస్తుఙ్‌ నెస్తిఙనె ఎలాకాలం దేవుణువెట బత్కినిబత్కు మనాద్. ");
INSERT INTO kfc_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","నాను కిదెఙ్‌ ఇజి నీను నఙి సిత్తి పణివిజు నాను పూర్తి కిజి నీను గొప్పపెరికి ఇజి బూమిముస్కు నాను తోరిస్త. ");
INSERT INTO kfc_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ఏలు ఓ బా, లోకం నీను పుటిస్ని ముఙాల నివెట నాను మహివలె నఙి గవ్‌రం కితిలెకెండ్, ఏలు నీ ఎద్రు నఙి గవ్‌రం కిఅ. ");
INSERT INTO kfc_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","నీను నఙి సితివరిఙ్‌ నాను నీ వందిఙ్‌ వెహ్సి తోరిసి నెస్పిస్త. వీరు దేవుణుదిఙ్‌ దూసిస్ని ననికార్‌ ఆఏర్. వీరు నీ వారు. నీను వరిఙ్‌ నఙి సితి. నీ మాటెఙ వారు లొఙితార్. ");
INSERT INTO kfc_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","నీను నఙి సితి విజు నీబాణిఙె వాతెమనె ఇజి ఏలు వారు నెస్తార్. ");
INSERT INTO kfc_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ఎందానిఙ్‌ ఇహిఙ, నీను నఙి సితి మాటెఙ్‌నాను వరిఙ్‌సిత. వారు అయకెఙ్‌ నమ్మితార్. నాను నీ బాణిఙ్‌వాతికాన్‌ ఇజి వారు అనుమానం సిల్లెండ నెస్తార్. నీనె నఙిపోక్తి ఇజి వారు నమ్మిత మనార్. ");
INSERT INTO kfc_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","నాను యా సిసూర్‌వందిఙ్‌ పార్తనం కిజిన. యా లోకమ్‌ది లోకుర్‌ విజెరెవందిఙ్‌ నాను పార్దనం కిఏ. గాని నీను నఙి సితి విరివందిఙ్‌ పార్దనం కిజిన. ఎందానిఙ్‌ఇహిఙ, వీరు నీ వారు. ");
INSERT INTO kfc_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","నా వారు విజెరె నీ వారు. నీ వారువిజెరె నా వారు. అయలెకెండ్‌ వారు బత్కినారె, నాను గొప్పపెరికాన్‌ ఇజి వారు తోరిసినార్. ");
INSERT INTO kfc_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ఏలు నాను నీ డగ్రు వాజిన. నాను మరి యా లోకమ్‌దు మన్‌ఏ. గాని వీరు ఇబ్బె మంజినార్. ఓ నెగ్గి బుబ్బ, మాటు ఉండ్రె ఆతి లెకెండ్‌ వీరుబా ఉండ్రె ఆదెఙ్, నీను నఙి సితి సత్తుదాన్‌ వరిఙ్‌ కాపాడ్ఃఅ. ");
INSERT INTO kfc_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","నాను యా లోకమ్‌దు వరి వెట మహివలె, నీను నఙి సితి సత్తుదాన్‌ వరిఙ్‌ కాపాడఃత. నాను వరిఙ్‌ నెగ్రెండ తప్రిసి మహ. వరి లొఇ ఎలాకాలం నాసనం ఆదెఙ్‌ మన్నికాన్‌ ఆఏండ, మహికార్‌ విజెరె ఎలాకాలం నాసనం ఆఎతార్. దేవుణు మాటదు రాస్తి మనికెఙ్‌ పూర్తి ఆదెఙ్‌ యాకెఙ్‌ విజు జర్గిదెఙ్‌ వలె. ");
INSERT INTO kfc_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","నాను ఏలు నీ డగ్రు వాజిన. నఙి మన్ని సర్‌ద వరి మన్సుదుబా నిండ్రు మంజిని వందిఙె, నాను యా లోకమ్‌దు మన్నివలెనె యా సఙతిఙ్‌ వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","నాను వరిఙ్‌నీ మాటెఙ్‌ సిత మన్న. యా లోకమ్‌దు మన్ని దేవుణుదిఙ్‌ దూసిస్నికార్‌ వరిఙ్‌ దూసిస్తార్. ఎందానిఙ్‌ఇహిఙ, నాను లోకమ్‌దికాన్‌ ఆఇలెకెండ్, వారు బా లోకమ్‌దికార్‌ ఆఏర్. ");
INSERT INTO kfc_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","నీను వరిఙ్‌యా లోకమ్‌దాన్‌ ఒఅ ఇజి నాను పార్దనం కిఏ గాని సయ్తాను బాణిఙ్‌ వరిఙ్‌ కాపాడ్ఃఅ ఇజినె పార్దనం కిజిన. ");
INSERT INTO kfc_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","నాను లోకమ్‌దికాన్‌ఆఇలెకెండ్, వారు బా లోకమ్‌దికార్‌ఆఎర్. ");
INSERT INTO kfc_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","నీ నిజమాతి మాటెఙ్‌నెస్‌పిసి, వారు దేవుణువందిఙ్‌ కేట ఆతిలెకెండ్‌ వరిఙ్‌ ఇడ్ఃఅ. నీ మాటెఙ్‌నిజమాతి మాటెఙ్. ");
INSERT INTO kfc_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","నీను నఙి యా లోకమ్‌దు పోక్తి లెకెండ్, నాను వరిఙ్‌లోకమ్‌దు పోక్సిన. ");
INSERT INTO kfc_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","నిజమాతి మాట నెసి వారు వరిఙె నీ కీదు ఒపజెప్సిని వందిఙ్, నాను వరి వందిఙ్‌ని కీదు ఒపజెపె ఆజిన. ");
INSERT INTO kfc_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","21","ఓ బా, నాను కిజిని పార్దనం వరి వందిఙె ఆఏ. వరి మాటెఙ్‌ వెంజి నమ్మిదెఙ్‌మన్ని వరిఙ్‌విజెరె వందిఙ్‌ నాను పార్దనం కిజిన. ఎందానిఙ్‌ఇహిఙ, నీను నా వెట కూడ్ఃజి మంజిని లెకెండ్, నాను నీ వెట కూడ్ఃజి మంజిని లెకెండ్‌ వారు విజెరె ఉండ్రె ఆదెఙ్. నీను నఙి పోక్తి మన్ని ఇజి లోకమ్‌ది లోకుర్‌ విజెరె నమ్మినివందిఙ్‌ వారు మావెట కూడ్ఃజి మనీర్. ");
INSERT INTO kfc_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","నాను పెరికాన్‌ ఇజి నీను నఙి గవ్‌రం నాను వరిఙ్‌ సిత మన. మాటు ఉండ్రె ఆతి లెకెండ్‌ వారుబా ఒండ్రె అదెఙె నాను సిత్త. ");
INSERT INTO kfc_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","వారు పూర్తి ఉండ్రె ఆనివందిఙ్‌ నాను వరివెట కూడిఃత మన. నీను నా వెట కూడిఃతి మన్ని. నీను నఙి పోక్తి ఇజి, నీను నఙి ప్రేమిస్ని లెకెండ్‌వరిఙ్‌బా ప్రేమిస్ని ఇజి లోకుర్‌విజరె నెస్ని వందిఙ్‌ వారు ఉండ్రె ఆదెఙ్. ");
INSERT INTO kfc_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","ఓ బా, నీను వరిఙ్‌నఙి సితి. అందెఙె నాను మంజిని బాన్‌వారుబా మండ్రెఙ్‌ ఇజి నాను కోరిజిన. ఎందానిఙ్‌ఇహిఙ, నాను గొప్ప పెరికాన్‌ ఇజి నీను నఙి సితి గవ్‌రం వారు సుడ్ఃదెఙె. లోకం పుటిస్‍ఏండ ముఙాల, నీను నఙి ప్రేమిస్తి. అందెఙె నీను నఙి అయా గవ్‌రం సిత్తి. ");
INSERT INTO kfc_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","నీతి నిజాయితి మన్ని బుబ్బ, లోకమ్‌ది లోకుర్‌ నిఙి నెస్‌ఎర్. గాని నాను నెస్న. నీను నఙి పోక్తి ఇజి వీరు నెసినార్. ");
INSERT INTO kfc_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","నాను వరి వెట కూడ్ఃజి మంజిని వందిఙ్, నీను నఙి ప్రేమిస్తి లెకెండ్, వారు బా మహివరిఙ్‌ ప్రేమిస్నివందిఙ్‌ నాను నీ వందిఙ్‌ వరిఙ్‌ నెస్‌పిస్త మన. నెస్‌పిసినె మంజిన. ");
INSERT INTO kfc_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","యేసు పార్దనం వీస్తి వెన్కా, వన్ని సిసూర్‌వెట సోతాండ్రె, కెద్రొన్‌ఇని జోరెడాట్సి సొహాన్‌. అబ్బె ఉండ్రి టోట మహాద్‌. వాండ్రుని వన్నిసిసూర్‌ అయా టోటాదు సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","నండొ సుట్కు యేసుని వన్నిసిసూర్‌ అబ్బె కూడ్ఃజి మహార్‌. అందెఙె యేసు అయా టోటాదు మంజినాన్‌లె ఇజి యూద నెస్నాన్. వీండ్రె యేసుఙ్‌యుదురి అదికారిఙ కీదు ఒపజెప్నికాన్. ");
INSERT INTO kfc_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","అందెఙె యూద అబె వాతాన్. పెరి పుజెరిఙు పరిసయ్‌రు పోక్తి సెగొండార్‌ దేవుణు గుడిఃది జమాఙ్‌ణు, మరి రోమ సయ్‌నమ్‌ది సెగొండారిఙ్‌బా వన్ని వెట కూక్త తత్తాన్. వారు సిసు బొద్దు, లాందెరిఙు, కూణమ్‌కు అస్త మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","యేసు వన్ని ముస్కు వానికెఙ్‌విజు నెసినె, వాండ్రు సోతాండ్రె వరిఙ్, “మీరు ఎయెరిఙ్‌ రెబానిదెర్‌?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","దన్నిఙ్‌ వారు, “నజరేతుది యేసుఙ్”, ఇహార్‌. అందెఙె వాండ్రు, “వాండ్రు నానె”, ఇజి వెహ్తాన్‌. అయావలె యేసుఙ్‌ ఒపజెప్తి యూద వరి వెట నిహ మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","‘వాండ్రు నానె’, ఇజి యేసు వరిఙ్‌ వెహ్తివలె, వారు వెన్కా గుసె ఆజి బూమిదు అర్తార్. ");
INSERT INTO kfc_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","మరి వాండ్రు వరిఙ్‌ వెన్‌బాతాన్, “మీరు ఎయెరిఙ్‌ రెబానిదెర్‌?”, ఇజి. “నజరేతుది యేసుఙ్”, ఇహార్‌ వారు. ");
INSERT INTO kfc_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","అందెఙె యేసు, “నాను మిఙి వెహ్తగదె, వాండ్రు నానె ఇజి. మీరు నఙి రెబానిదెర్‌ ఇహిఙ, నా సిసూర్‌ ఆత్తి విరిఙ్‌ పోక్తు”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","వారు సిసూరిఙ్‌ పోక్తిఙ్, ‘నీను నఙి సితి వరి లొఇ ఒరెన్‌ వన్నిఙ్‌బా నాను పాడుకిఏ’ ఇజి వాండ్రు ముఙాలె వెహ్తి మాటెఙ్‌ పూర్తి ఆతె. ");
INSERT INTO kfc_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","సిమోన్‌ పేతురు డగ్రు ఉండ్రి కూడం మహాద్‌. నస్తివలె వాండ్రు అయాక లాగితండ్రె, విజు పుజెరిఙ ముస్కు పెరిపుజెరి పణిమన్నిసిఙ్‌ ఉణెర్‌గిబి కత్తాన్. అయా పణిమన్నిసి పేరు మల్కు ");
INSERT INTO kfc_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","యేసు పేతురుఙ్, “నీ కూడం దన్నిఒరదు ఇడ్ఃఅ. నాను ఓరిస్తెఙ్‌నా బుబ్బ ఏర్‌పాటుకితి స్రమెఙ్‌ నాను ఓరిస్తెఙ్‌ఆఎద్‌ఇజి నీను ఒడ్ఃబిజినిదా?”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","13","నస్తివలె రోమ సయ్‌నమ్‌దికార్, వరి అతికారి, జమానుర్‌ యేసుఙ్‌ అస్తారె తొహ్క్‌తార్. వారు వన్నిఙ్‌ తొహ్క్‌తారె, ముఙాల, అన్న ఇని వన్నిడగ్రు ఒతార్. వాండ్రు అయా ఏంటు విజు పుజెరిఙ ముస్కు పెరి పుజెరి ఆతి కయపెఙ్‌ మామ్‌సి. ");
INSERT INTO kfc_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","యా కయపనె, ‘లొకుర్‌విజెరె వందిఙ్‌ ఒరెన్‌ సానికాదె నెగెద్‌’ ఇజి యూదురి అతికారిఙ్‌ బుద్ది వెహ్త మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","సిమోన్‌ పేతురు ని మరి ఒరెన్‌సిసూ యేసు వెన్కా సొహార్‌. అయా సిసూ, విజు పుజెరిఙ ముస్కు పెరిపుజెరిఙ్ ‌నెల్వ ఆతికాన్. అందెఙె వాండ్రు యేసువెట పెరిపుజెరి ఇండ్రొణి డేవాదు సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","పేతురు గవుని వెల్లి నిహమహాన్‌. పెరిపుజెరిఙ్‌ నెల్వ ఆతి అయా సిసూ మర్‌జి వాతండ్రె, గవ్‌నిడగ్రు నిల్సి మంజిని అయ్‌లిదిఙ్‌ వెహ్తండ్రె, పేతురుఙ్‌ లొఇ కూక్త ఒతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","అయావలె అయా అయ్‌లి పేతురువెట, “నీనుబా వన్ని సిసూర్‌లొఇ ఒరిగదె?”, ఇజి వెన్‌బాతాన్. దన్నిఙ్‌వాండ్రు, “నాను ఆఏ?”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","అయావలె గొప్ప పిని మహాద్‌. అందెఙె అతికారిఙుని పణిమన్నిసిర్‌సిసు ఎర్‌సి దన్ని సుటులం నిల్సికాయ్‌జి మహార్‌. పేతురుబా వరివెట నిహండ్రె, సిసు కాయ్‌జి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","అయావలె, విజు పుజెరిఙ ముస్కు మన్ని పెరిపుజెరి యేసుఙ్‌ వన్నిసిసూర్‌ వందిఙ్‌ వాండ్రు నెస్‌పిస్తి బోద వందిఙ్‌ వెన్‌బాజి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","అందెఙె యేసు, “నాను లోకుర్‌ విజెరె ఎద్రునె వెహ్తమన. యూదురు విజెరె కూడ్జి వాజి మంజిని, యూదురి మీటిఙ్‌ ఇల్కాఙ్‌ని దేవుణుగుడిఃదు ఎస్తివలెబా నేర్‌పిసి మహ. నాను ఇనికబా డొఙసాటు వెహ్‌ఏత. ");
INSERT INTO kfc_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","మరి ఎందానిఙ్‌ నఙి వెన్‌బాజిని? నా మాట విహివరిఙ్‌వెన్‌బాఅ. నాను వెహ్తికెఙ్‌వర్గితికెఙ్‌వారు నెస్నార్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","యేసు యాకెఙ్‌ వెహ్తిఙ్, అబ్బె నిహిమహి అతికారిఙ లొఇ ఒరెన్‌ యేసుఙ్‌ ఉండ్రి లెపడెఃయితాండ్రె, “యాలెకెండ విజు పుజెరిఙ ముస్కు మన్ని పెరిపుజెరిఙ్‌ మర్‌జి వెహ్సిని?”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","అయావలె యేసు, “నాను తపు ఇన్నిక వెహ్తిఙ, అయాక నఙి వెహ్‌అ. గాని నాను నిజం వెహ్తిఙ, ఎందనిఙ్‌ నఙి డెఃయిజిని?”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","అందెఙె అన్న వన్నిఙ్‌ తొహ్తి డఃసనె విజు పుజెరిఙ ముస్కు పెరిపుజెరి కయపడగ్రు పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","పేతురు సిసు కాయిజి నిహ మహాన్‌. అయావలె మహికార్‌వన్నిఙ్, “నీనుబా వన్ని సిసూర్‌లొఇ ఒరిగదె?”, ఇజి వెన్‌బాతార్. గాని పేతురు, “నాను ఆఏ”, ఇజి కెఏతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","నస్తివలె పేతురు గిబ్బి తెవ్‌కతి పణిమన్నిసి బంతుకులు ఒరెన్‌ అబ్బె మహాన్‌. వాండ్రు విజు పుజెరిఙ ముస్కు మన్ని పెరి పెరి పుజెరి పణిమన్నిసిర్‌లొఇ ఒరెన్. వాండ్రు, “నిఙి వన్నివెట టోటాదు నాను సుడ్ఃతగదె?”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","మరిబా, “నాను నెస్‌ఏ”, ఇజి వెహ్తాన్‌. వెటనె కొరు కెరెతాద్. ");
INSERT INTO kfc_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","వెన్కా యూదురు యేసుఙ్‌ కయప బాణిఙ్‌రోమా గవర్నరు మన్ని పెరి ఇండ్రొ ఒతార్. అయావలె పెందాల్‌ఆతాద్. యూదురు ఆఇ వన్ని ఇండ్రొ డుగ్‌జి మయ్‌ల ఆనాప్‌ఇజి ఒడిఃబిజి వారు గవర్నరు మన్ని ఇండ్రొ డుఃగ్‌ఏతార్. ఎందానిఙ్‌ఇహిఙ, వారు పస్క బోజనం ఉండెఙ్‌సుబమ్ర్‌క మండ్రెఙ్‌వలె. అయాక ఉండ్రి ఆసారం. ");
INSERT INTO kfc_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","అందెఙె గవర్నరు ఆతి పిలాతు, వెల్లి వరిడగ్రు వాతండ్రె, విని ముస్కు ఇనిఇని నేరమ్‌కు మొప్సినిదెర్‌?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","అయావలె వారు, “వీండ్రు తపు కిఇకాన్‌ ఇహిఙ, నీ బాన్‌తెఎతాప్‌మరి”, ఇజి మర్‌జి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","పిలాతు వరిఙ్, “మీరె వన్నిఙ్‌ఒసి, మీ యూదురి రూలుదు మన్ని వజ తీర్పు సీదు”, ఇహాన్‌. దనిఙ్‌వారు, “ఎయెరిఙ్‌బా సప్తెఙ్‌మఙి అక్కుసిల్లెద్‌”, ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","యేసుఎలాగ మర్తి సావు సానాన్‌ఇజి వాండ్రు వెహ్తి మాటెఙ్‌ పూర్తి ఆదెఙ్‌ యాక జర్గితాద్. ");
INSERT INTO kfc_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","పిలాతు వన్ని ఇండ్రొ మర్‌జి సొహాండ్రె, యేసుఙ్‌ కూక్పిస్తాండ్రె వన్నిఙ్, “నీను యుదురిఙ్‌రాజునా?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","అందెఙె యేసు, “నీలొఇహాన్‌ ‌వాతి మాటనా, మహికార్‌నా వందిఙ్‌నిఙి వెహ్తరా?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","అయావలె పిలాతు, “నాను యూద వాండ్రనా? నీ సొంత లోకుర్‌ని నీ సొంత పెరిపుజెరిఙు నిఙి నాబాన్‌ ఒపజెప్తార్. నీను ఇన్నిక కితి?”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","అందెఙె యేసు, “నా అతికారం యా లోకమ్‌ది రాజురిఙ్‌ మన్ని అతికారం లెకెండ మన్నిక‌ ఆఏద్. నన్నిఅతికారం నఙి మహిఙ, యూదురు నఙి అరెస్టు కిఏండ నా సిసూర్‌ అడ్డు కిత్తార్‌ మరి. గాని నాను యా లోకమ్‌ది రాజు ఆఏ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","“అహిఙ, నీను ఒరెన్‌రాజునా?”, ఇజి పిలాతు వెహ్తాన్‌. అందెఙె యేసు, “నాను రాజు ఇజి నీను వెహ్సిని. నిజమాతి మాటెఙ్‌వెహ్ని వందిఙె నాను పుట్తానె యా లోకమ్‌దు వాత. నీజమాతికెఙ్‌ కోరిజినికాన్‌ నాను వెహ్సిని మాటెఙ్‌ వినాన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","అయావలె పిలాతు, “నిజమాతి మాటెఙ్‌ఇన్నికెఙ్‌?”, ఇజి వెన్‌బాతాన్. వెన్‌బాతాండ్రె వాండ్రు వెల్లి యూదురు బాన్‌సొహాండ్రె, “వినిఙ్‌తిర్‌పు సీదెఙ్‌విని లొఇ ఇన్ని నేరంబా తోర్‌ఏద్. ");
INSERT INTO kfc_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","గాని మీ అలవాటులెకెండ్, ఏంటుఏంటు పస్క పండొయ్‌ కాలమ్‌దు, “కయ్‌దు మన్ని ఒరెన్‌వన్నిఙ్‌మఙి డిఃసి పోక్‌అ”, ఇజి మీరు లొస్నిదెర్. అందెఙె యుదురిఙ్‌రాజుఙ్‌ నాను డిఃసి సీదెఙ్‌ మీరు కోరిజినిదెరా?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","అయావలె వారు, “పోని! వినిఙ్‌పోని. బరబెఙ్‌డిఃసి సిదా మఙి”, ఇజి డేల్సి మర్‌జి వెహ్తాన్‌. యా బరబ్బ ఒరెన్‌ కఙారి. ");
INSERT INTO kfc_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","అందెఙె పిలాతు, “యేసుఙ్‌ ఒసి కొరడెఃఙాణిఙ్‌ డెఃయ్‌దు”, ఇజి సయ్‌నమ్‌దివరిఙ్‌ వెహ్తాన్‌‌. ");
INSERT INTO kfc_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","3","సయ్‌నమ్‌దికార్‌ సాప్కాణిఙ్‌ టోపి తయార్‌ కితారె వన్ని బురాదు తొడిఃగిస్తార్. వారు వన్నిఙ్‌నండొ ఎరాని నరీ సొక్క తొడ్‌గిస్తారె, వన్నిడగ్రు సొన్సి, “యూదురిఙ్‌ రాజు నిఙి జెయము”, ఇజి వెక్రిసి వెహ్తార్‌. వారు వన్ని లెపాదు డెఃయ్తార్. ");
INSERT INTO kfc_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","మరి ఉండ్రిసుటుబా, పిలాతు వన్ని ఇండ్రొణిఙ్‌ వెల్లి వాతాండ్రె, మంద యూదురిఙ్” ఇదిలో, వన్ని లొఇ ఇనితప్పబా నఙి తోర్‌ఏద్‌ ఇజి మీరు నెస్తెఙ్‌నాను వన్నిఙ్‌వెల్లి మీ డగ్రు తపిస్న”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","అందెఙె యేసుఙ్‌ సాప్కాణి టోపి ని ఎరాని సొక్క తొడ్ఃగిస్తారె వెల్లి తతార్. అయావలె పిలాతు వరిఙ్, “ఇవిలొన్‌వాండ్రు”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","పెరిపుజెరిఙుని దేవుణు గుడిఃది జమాఙ్‌ణు వన్నిఙ్‌ సుడిఃతారె, “వన్నిఙ్‌ సిలువాదు కుటిఙాణిఙ్‌ డెఃయిజి సప్‌అ, సిలువాదు కుటిఙాణిఙ్‌ డెఃయిజి సప్‌అ”, ఇజి డేడిఃస్తార్. గాని పిలాతు, “విని లొఇ నఙి ఇన్ని తపు బా తోర్‌ఏద్. అందెఙె మీరె వన్నిఙ్‌ఒసి, సిలువాదు డెఃయిజి సప్తు”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","అయావలె వారు, “మఙి మా యూదురి రూలుఙ్‌మనాద్. అయా రూలుఙ్‌ వజ వీండ్రు సాదెఙ్‌వలె. ఎందానిఙ్‌ఇహిఙ, వీండ్రు, “నానె దేవుణు మరిసి ఇజి వెహ్తాన్‌”, ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","పిలాతు యా మాటెఙ్‌విహిఙ్‌మరి ఒదె తియెల్‌ఆతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","వాండ్రు మరి వన్ని ఇండ్రొ డుగితాండ్రె యేసుఙ్, నీను ఎంబెణిఙ్‌ వాతికి? ఇజి వెన్‌బాతాన్. గాని యేసు మర్‌జి ఇనికబా వెహ్‌ఏతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","అందెఙె పిలాతు, “నీను నా వెట వర్గ్ఇదా? నిఙి సిలువాదు కుంటిఙాణిఙ్‌ డెఃయ్‌జి సప్తెఙ్‌బా నఙి అతికారం మనాద్. విడుఃదల కిదెఙ్‌బా అతికారం మనాద్‌ ఇజి నీను నెస్‌ఇదా?”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","అందెఙె యేసు, “నా ముస్కు దేవుణు నిఙి అతికారం సితిఙ్‌నె, నిఙి అతికారం మనాద్. అందెఙె నఙి నీ బాన్‌ఒపజెప్తికాన్‌నిఙి ఇంక లావు పాపం కిత్తాన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","యా మాట విహండ్రె పిలాతు యేసుఙ్‌విడుఃదల కిదెఙ్‌సుడ్ఃతాన్. గాని యూదురు, “నీను వినిఙ్‌డిఃసి సితిఙ, నీను కయ్‌సరు రాజుఙ్‌కూలవాండ్రు ఆఇ. రాజు ఇజి వన్నిఙ్‌ వాండ్రె వెహె ఆనికాన్‌ ఎయెన్‌బా కయ్‌సరుఙ్‌ పగ ఆతికాన్”, ఇజి మరి డటం డేల్‌స్తార్. ");
INSERT INTO kfc_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","పిలాతు యా మాటెఙ్‌విహివెలె, వాండ్రు యేసుఙ్‌వెల్లి తతాన్. తతాండ్రె నాయం తిర్‌స్నికాన్‌ బస్ని కుర్‌సిదు బస్తాండ్రె యేసుఙ్‌సిలువాదు డెఃయ్‌అ ఇజి తీర్పు సితాన్. అయా కుర్‌సి పణకాణిఙ్‌ తయార్‌ కితి బాడిః ఇజి కూక్ని బాడిఃదు మనాద్. అయా బాడిఃఙ్‌ఎబ్రి బాసదు గబత ఇనార్. ");
INSERT INTO kfc_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","నస్తివలె పస్కపండొయ్‌ నడిఃమి మన్ని విస్రాంతిదినం ముఙాల మన్ని తయార్‌ఆని రోజు. పెందాల్‌ఆరు గంటెఙ్‌ఆతాద్. అయావలె పిలాతు, “ఇవిలొన్‌ మీ రాజు”, ఇజి యుదురిఙ్‌ వెహ్తాన్‌‌. ");
INSERT INTO kfc_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","అందెఙె వారు, “సప్‌అ వన్నిఙ్, సప్‌అ వన్నిఙ్, సిలువాదు వన్నిఙ్‌కుంటిఙాణిఙ్‌ డెఃయ్‌జి సపఅ”, ఇజి డెడిఃస్తార్. “నాను మీ రాజుఙ్‌సిలువాదు కుటిఙాణిఙ్‌ డెఃయిజి సప్తెఙా?”, ఇజి పిలాతు వెన్‌బాతాన్. అయావలె పెరి పుజెరఙు, “కయ్‌సరు ఒరెండ్రె మా రాజు. మరి ఎమేణి రాజు మఙి సిల్లెన్”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","అందెఙె పిలాతు యేసుఙ్‌ సిలువాదు డెఃయ్‌జి సప్తెఙ్‌ వరిఙ్‌ ఒపజెప్తాన్. వారు వన్నిఙ్‌ ఒతార్. ");
INSERT INTO kfc_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","యేసు వన్ని సొంత సిలువ పిండిజి, పట్నం వెల్లి వాతండ్రె బుర్ర పిణికి ఇజి కూకె ఆని బాడిఃదు వాతాన్. ఎబ్రి బాసదు దన్నిఙ్‌ గోల్‌గోత ఇనార్. ");
INSERT INTO kfc_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","అబ్బె సయ్‌నమ్‌దికార్‌ వన్నిఙ్‌ సిలువాదు కుటిఙాణిఙ్‌ డెయ్‌తార్. వారు రిఏర్‌ లోకురిఙ్‌బా వన్నివెట సిలువాదు కుటిఙాణిఙ్‌ డెయ్‌తార్. యేసుఙ్‌ నడిఃమి ఇట్తాన్. ఒరెన్‌ వన్నిఙ్‌ ఉణెర్‌ పడఃకాద్. ఒరెన్‌ డెఃబర పడఃకాద్. ఆహె సిలువాదు డెయ్తార్. ");
INSERT INTO kfc_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","పిలాతుబా ఉండ్రి బోర్‌డు తయార్‌ కిబిస్తాండ్రె, సిలువాదు తొహ్క్‌త ఇట్తాన్. అయా బోర్‌డుదు, ‘నజరెతుదికాన్‌ ఆతి యేసు. యూదురిఙ్‌ రాజు’, ఇజి రాసి ఇట్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ఎబ్రి, గ్రీకు, రోమ యా మూండ్రి బాసెఙాణిఙ్‌ బోర్‌డుదు ఆహెరాస్త మహార్‌. యేసు ప్రబుఙ్‌ సిలువాదు డెఃయితి బాడ్డిః పట్నం డగ్రు మనాద్. అందెఙె నండొండార్‌ యూదురు అయాక సద్‌విత్తార్. ");
INSERT INTO kfc_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","నస్తివలె యూదుర్‌ఙ పెరి పుజెరిఙు పిలాతుఙ్, “యూదురిఙ్‌ రాజు ఇజి రాస్మ. గాని ‘నానె యూదురిఙ్‌ రాజు’, ఇజి వీండ్రు వెహ్తాన్‌‌ ఇజి రాస్‌అ”, ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","అందెఙె పిలాతు, “నాను రాస్తి మన్నికదె మన్నిద్. మరి మారిస్‌ఏ”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","సయ్‌నమ్‌దికార్‌ యేసుఙ్‌ సిలువాదు కుటిఙాణిఙ్‌ డెఃయితివలె వన్ని సొక్కెఙ్‌ లాగితార్. వాండ్రు ప్‌డ్‌గితి మహి సాల్‌వదిఙ్‌నాల్గి ముకెఙ్‌కిస్తారె, ఉండ్రి ముక ఒరెన్‌ వన్నిఙ్‌ ఆహె సీబె ఆతార్. పాదమ్‌దాక మంజిని ఉండ్రి నిరీ సొక్కబ మహాద్. అయాక కుటు సిలిక. ముస్కుహాన్‌ అడ్గి దాక కుటు సిల్లెండ ఉండ్రె లెకెండ్‌గుత మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ఒరెన్‌ మరి ఒరెన్‌ వెట, “అయాక కిస్మాట్. ఎయెరిఙ్‌ అయాక వానాద్‌ ఇజి సీటి పొక్సి సూణాట్”, ఇజి వర్గితార్. ‘నా సాల్వ వారు సీబె ఆతార్. నా నిరీ సొక వరిఙ్‌ సీటి పొక్తార్”, ఇజి దేవుణు మాటదు రాస్తి మనికెఙ్‌ పూర్తి ఆని వందిఙ్‌ యాక జర్గితాద్. సయ్‌నమ్‌దికార్‌ అయాలెకెండె కిత్తార్. ");
INSERT INTO kfc_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","నస్తివలె, యేసుఙ్‌ డెఃయ్‌తి సిలువ డగ్రు వన్ని అయిసి, వన్ని కొగ్రి అయ్‌సి, క్లొపా ఇన్ని వన్ని ఆల్సి మరియ, మగ్‌దలెనె మరియ ఇనికెఙ్‌ నిహె మహె. ");
INSERT INTO kfc_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","యేసువన్ని అయ్‌సిని వాండ్రు నండొ ప్రేమిస్తి సిసూ, డగ్రునిహి మహిక సుడ్ఃతాండ్రె అయ్‌సిఙ్, “ఓ యా, నేండ్రుహన్‌ వీండ్రె నీ మరిన్‌ లెకెండ్‌ మంజినాన్‌లె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","మరి సిసూడుఃఙ్, “ఇదిలో నీ యాయ”, ఇజి వెహ్తాన్‌. నాండిహన్‌అయా సిసూ దనిఙ్‌వన్ని ఇండ్రొ కూక్త ఒతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","వెన్కా, బుబ్బ ఒపజెప్తి పణిఙ్‌ విజు ఏలు పూర్తిఆతె, ఇజి ఏలు నెస్తాన్. నెస్తాండ్రె, కీర్తన పుస్తకమ్‌దు రాస్తి మన్ని మాటెఙ్‌ పూర్తి ఆని వందిఙ్‌ ‘నఙి ఏహ్కి కట్సినాద్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","అయావలె అబె నండొ సేందు ద్రాక్స కడు మన్ని ఉండ్రి డొకు మహాద్‌. సయ్నమ్‌దికార్‌ ఉండ్రి దూది ననిక అయా సేందు ద్రాక్సకల్లుదు ముడుక్‌తారె, అయాక ఇసొపు మరాతి కొమాదు తొహ్తరె, వన్ని వెయ్‌దు సిత్తార్. ");
INSERT INTO kfc_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","వాండ్రు అయాక ఉటాండ్రె, “నా పణిఙ్‌పూర్తి ఆతాద్”, ఇజి వెహ్తండ్రె, బుర్ర వక్సి పాణం డిఃస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","నస్తివలె, అయా రోజు విస్రాంతిదినం ముఙాల మన్ని తయార్‌ఆని రోజు. మహ్స నాండిఙ్‌ విస్రాంతి దినం. యా దినం ముకెలమాతిక. ఎందానిఙ్‌ ఇహిఙ, యూదురి పస్క పండొయి అయనాండిఙె మొదొల్‌సినాద్. నాండిఙ్‌ మొడ సిలువాదు మండ్రెఙ్‌ వరిఙ్‌ ఇస్టం సిల్లెద్‌. అందెఙె యూదురు పిలాతుఙ్, సిలువాదు పొక్తి వరి కాల్కు రుఙు డెఃయ్‌జి వరిఙ్‌ బేగి సపిసి, వరి పీనుగు సిలువెఙాణిఙ్‌ డిఃప్తెఙ్‌ సెల్వ లొస్తార్. ");
INSERT INTO kfc_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","పిలాతు సెలవ సిత్తిఙ్, సయ్‌నమ్‌దికార్‌ వాతారె, యేసువెట సిలువాదు డెఃయిజి మొదొహి వన్ని కాల్కు రుఙు డెయ్‌తార్. వెన్కా మహి వన్ని కాల్కు బా రుఙు డెయ్‌తార్. ");
INSERT INTO kfc_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","గాని యేసుడగ్రు వాతిఙ్, వాండ్రు ముఙాలె సాతాన్‌ ఇజి వారు నెస్తార్. అందెఙె వారు వన్ని కాల్కు రుఙు డెఃయ్‌ఏతార్. ");
INSERT INTO kfc_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","గాని సయ్నమ్‌దివరి లొఇ ఒరెన్‌ బలెందాన్‌ ఉండ్రి పడఃకాదు గుతాన్. గుతిఙ్‌వెటనె, ఏరు నల సోతె. ");
INSERT INTO kfc_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","మీరుబా నమినివందిఙ్, యాక జర్గితివలె సుడ్ఃతికాన్‌ దనివందిఙ్‌ వెహ్తాన్‌‌. వాండ్రు వెహ్తిక నిజమ్‌నె. వాండ్రు నిజం వెహ్సినాన్‌ఇజి వాండ్రు నెస్నాన్. ");
INSERT INTO kfc_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","37","‘వన్ని డుముక లొఇ ఉండ్రి బా రుఙ్‌ఏద్‌’, ఇజి, మరి, ‘వారు గుతివన్నిఙ్‌ వారు సూణార్‌’, ఇజి రాస్తి మన్ని దేవుణు మాటెఙ్‌ పూర్తిఆని వందిఙె యా సఙతిఙ్‌ జర్గితె. ");
INSERT INTO kfc_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","యోసేపు ఇనికాన్‌ ఒరెన్‌ మహాన్‌. వాండ్రు అరిమతియ ఇని పట్నమ్‌దికాన్. వాండ్రు యేసు సిసూ ఒరెన్. గాని వాండ్రు అయాక ఎయెరిఙ్‌బా వెహ్‌ఏతాన్. ఎందానిఙ్‌ ఇహిఙ, వాండ్రు యూదురిఙ్‌ తియెల్‌ ఆతార్. వెన్కా వాండ్రు యేసు పీనుగు సిలువదాన్‌ డిఃప్సి సమాది కిదెఙ్‌ పిలాతుఙ్ ‌సెల్‌వ లొస్తాన్. సెల్వ సితిఙ్‌ వాండ్రు వాతండ్రె మొడః ఒతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","నికొదిమొ ఇన్నికాన్‌ఒరెన్‌బా వన్ని వెట సొహాన్‌. యా నికొదిమొనె, ముఙాలె, యేసుఙ్‌రెయ్‌తు సొన్సి సుడ్ఃతికాన్. వాండ్రు డగ్రు ముప్పయ్‌ నాల్గి కె. జి, బోలము కలప్తి అగరు ఇన్ని మొడః సబ్‌ఎండ ఇడ్ని మాయమ్‌కు తత్తాన్‌ ");
INSERT INTO kfc_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","వారు రిఏర్, యేసు పీనుగు ఒతారె, మాయమ్‌కు రాసి తెలాని పాతెఙాణ్‌ సుటిస్తార్. యూదురు సమాది కిని ముఙాల, పీనుగుతయార్‌ కిని అలవాటు లెకెండ్‌ ఈహు కిత్తార్. ");
INSERT INTO kfc_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","యేసుఙ్‌ సిలువాదు డెఃయ్‌తి బాడిఃదు ఉండ్రి టోట మనాద్. అబ్బె పణుకుదు దొలిస్తి ఉండ్రి కొత్తదూకి మహాద్‌. అబ్బె ఎయెరిఙ్‌బా ఎసెఙ్‌బా ఇడ్ఃఏరె. ");
INSERT INTO kfc_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","అయా రోజు యూదురి విస్రాంతిదినం ముఙాల మన్ని తయార్‌ఆని రోజు. మరి, అయా దూకిడగ్రు మహాద్‌. అందెఙె వారు యేసుఙ్‌ అబ్బె ఇట్తార్. ");
INSERT INTO kfc_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","వారమ్‌దిఙ్‌ మొదొహి రోజు పెందాల్, సీకట్‌మన్‌బునె మగ్దలెనె మరియ పీనుగు నూనెఙ్‌ రాస్తెఙ్‌ దూకిదు సొహద్. అది వాతిఙ్, పీనుగుఇడ్తి సమాదిదిఙ్‌ మూక్తి పణుకు లాగితిక సుడ్ఃతాద్. ");
INSERT INTO kfc_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","అందెఙె అది ఉహ్క్‌జి సొన్సి, యేసు నండొ ప్రేమిస్తి సిసూ బాన్, సిమోన్‌ పేతురుబాన్‌ వాతాదె వరిఙ్, “ప్రబుఙ్‌ సమాదిదాన్‌ వారు ఒతార్. వన్నిఙ్‌ ఎంబె ఇడ్తారొ ఇజి మాపు నెస్‌ఏప్”, ఇజి వెహ్తాద్‌. (మరియవెట మరి సెగొండెక్‌బోదెక్‌బా మహె) ");
INSERT INTO kfc_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","అందెఙె పేతురుని, అయా సిసూ సోతారె సమాదిదు సొహార్. ");
INSERT INTO kfc_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","వారు రిఏర్‌ ఉహ్క్‌జి సొన్‌సి మహార్‌. గాని అయా సిసూ పేతురుఙ్‌ ఇంక బేగి ఉహ్క్‌తాండ్రె సమాది ముఙాల్‌ వాతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","వాండ్రు వఙ్‌జి సుడ్‌తిఙ్, తెలాని పాతెఙ్‌ అబె అర్త మహిక సుడ్‌తాన్. వాండ్రు లొఇ డుఃగ్‌ఏతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","7","నస్తివలె సిమోన్‌ పేతురు వన్ని వెన్కా వాతండ్రె లొఇ డుగితాన్. వాండ్రు తెలాని పతెఙ్‌అర్తి మహిక సుడ్ఃతాన్. యేసు బుర్ర సుటిస్తి మహి పన్‌సెబా అబ్బె అర్త మహిక సుడ్ఃతాన్. అయా పన్‌సె, తెలాని పాతవెట కూడ్ఃఏండ సుటిస్తిడఃసనె వేరె మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","వెనుక ముఙాల సమాదిదు వాతి సిసూబా డుగితాన్. వాండ్రు పాతెఙ్‌ అర్తి మహిక సుడ్ఃతాండ్రె, యేసు మర్‌జి నిఙితాన్‌ ఇజి నమ్మితాన్. ");
INSERT INTO kfc_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","యేసు సాతి వరిబాణిఙ్‌ తప్‌ఏండ మర్‌జి నిఙ్‌నాన్‌లె ఇజి దేవుణు మాటదు రాస్తి మన్ని మాటదిఙ్‌ వారు ఇంక అర్దం కిఎరె. ");
INSERT INTO kfc_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","సిసూర్‌ వరి ఇల్కాఙ్‌ మర్‌జి సొహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","మరియ మరి సమాదిదు వాత మహాద్‌. అది వెల్లినిహదె, అడఃబాజి మహాద్‌. అడఃబాజినె అది వఙ్‌జి సమాది లొఇ సుడ్ఃతాద్. ");
INSERT INTO kfc_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","అయావలె, తెలాని పాతెఙ్‌ పొర్‌పాతి రిఎర్‌ దేవుణు దూతెఙ అది సుడిఃతాద్. యేసు పీనుగుమహి బాడిఃదు బస్త మహార్‌. పాదమ్‌క దరిఙ్‌ ఒరెన్‌ బస్త మహాన్‌. బుర్ర గాడిఃద్‌ ఒరెన్‌ బస్త మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","వారు మరియెఙ్, “ఓ బీ ఎందానిఙ్‌ నీను అడఃబాజిని?”, ఇజి వెన్‌బాతార్.అందెఙె అది, “నా ప్రబు మొడః ఎయెరొ పెహ్త ఒతార్. ఎంబె ఇడ్తారొ నఙి తెలిఎద్”, ఇజి వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","యా మాటెఙ్‌ వెహ్తదె, వెన్కా మర్‌జి బేస్తాద్. బేస్తిఙ్‌ యేసు అబ్బె నిహి మహిక సుడ్ఃతాద్. గాని వన్నిఙ్‌ గుర్తు అస్‌ఏతాద్. ");
INSERT INTO kfc_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","అయావలె యేసు, “ఓ బీ, ఎందానిఙ్‌ నీను అడఃబాజిని? ఎయెరిఙ్‌రెబాజిని?”, ఇజి వెన్‌బాతాన్. వీండ్రు అయా టోటాదు పణి కినికాన్‌సు ఇజి ఒడిఃబిజి, “బాబు, నీను వన్ని పీనుగుపిండితి ఒతి మహిఙ, ఎంబె ఇడ్తి మన్నిదొ నఙి వెహ్‌అ. నాను సొన్సి వన్నిఙ్‌పెర్న ఒనాలె”, ఇజి వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","నస్తివలె యేసు దన్నిఙ్, “మరియ”, ఇజి కూక్తాద్. వెటనె అది మర్‌జి వన్ని దరిఙ్‌ మహ్తద్. వాండ్రు యేసు ఇజి గుర్తు అస్తాదె ఎబ్రి బాసదు, “రబుని”, ఇజి కూక్తాద్. దని అర్దం బోదిస్నికాన్‌ ఇజి. ");
INSERT INTO kfc_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","అయావలె యేసు, “నాను నా బుబ్బడగ్రు ఇంక మర్‌జి సొన్‌ఎనె. అందెఙె నఙిఅసి మన్‌మా. గాని నీను నా సిసూర్‌ డగ్రు సొన్సి వరిఙ్, “నాను నా బుబ్బడగ్రు మర్‌జి సొన్‌సిన. వాండ్రునె నా బుబ్బ మీ బుబ్బ. వాండ్రె నా దేవుణు మీ దేవుణు”, ఇజి వెహ్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","అందెఙె మగ్దలెనె మరియ సిసూర్‌ డగ్రు వాతాదె, “ప్రబుఙ్‌సుడ్ఃత”, ఇజి వెహ్తాద్‌. మరి ప్రబు దన్నిఙ్‌ వెహ్తికెఙ్‌బా వెహ్తాద్‌. ");
INSERT INTO kfc_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","అయా ఆదివారమ్‌నె, పొదొయ్‌ సిసూర్‌కూడిఃతారె, సేహ్ల కెహ్సి బస్త మహార్‌. ఎందానిఙ్‌ ఇహిఙ, వారు యుదురిఙ్‌ తియెల్‌ఆతార్. యూదురు వరిఙ్‌అదికారుఙ ఒపజెప్నార్‌ ఇజి. నస్తివలె యేసు వాతండ్రె వరినడిఃమి నిహండ్రె, “సమాదనం కల్గిపిద్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","యాక వెహ్తండ్రె, సిలువాదు డెయ్‌ఏ ఆతివెలె వన్ని కికాఙ్, వన్ని పడఃకాద్‌ వాతి గాయమ్‌కు వాండ్రు వరిఙ్‌ తోరిస్తాన్. ప్రబుఙ్‌సుడ్‌తారె సిసూర్‌ నండొ సర్‌ద ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","22","మరి బా యేసువరిఙ్, “మిఙి సమాదనం కల్గిపిద్. నా బుబ్బ వన్ని మాట బోదిస్తెఙ్‌ నఙి యా లోకమ్‌దు పోక్తి వజ నాను మిఙి పోక్సిన”, ఇజి వెహ్తండ్రె, వరి ముస్కు తూబితాన్. తూబితాండ్రె, వరిఙ్, “దేవుణు ఆత్మదిఙ్‌ మీ మన్సుదు ఇడ్ఃదు. ");
INSERT INTO kfc_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","మీరు ఎయిపాపమ్‌కు సెమిస్నిదెరొ, వరి పాపమ్‌కు సెమిస్త మనె. ఎయిపాపమ్‌కు మీరు సెమిస్‌ఇదెరొ, అయకెఙ్‌ సెమిసి మన్‌ఉ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","యేసు సిసూరిఙ్‌ తోరె ఆతివలె, పన్నెండు మన్నిసీర్‌ సిసూర్‌లొఇ మన్ని దిదుము ఇన్ని తోమా సిల్లెండ మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","అందెఙె మహి సిసూర్, “మాపు ప్రబుఙ్‌సుడ్ఃతాప్‌ ఇజి వెహ్తిఙ్, వాండ్రు, “నాను వన్ని కిక్కాఙ్‌ కుంటిఙాణిఙ్‌ డెఃయ్‌తి గాయమ్‌ది మసదిఙ్‌తొఎండ, అయా మసదు ముట్‌ఏండ, వన్ని పడఃకాదు నాను కియు ఇడ్ఃఏండ, వాండ్రు నిఙిత మనాన్‌ ఇజి నమిఎ”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ఉండ్రి వారం వెన్కా వన్ని సిసూర్‌విజెరె మరిబా కూడిఃతారె, ఉండ్రి ఇండ్రొ మహార్‌. తోమాబా వరివెట మహాన్‌. సేహ్ల కెహె ఆత మహాద్‌. గాని యేసు వాతండ్రె వరినడిఃమి నిహండ్రె, “సమాదనం కల్గిపిద్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","మరి తోమెఙ్, “నీ డెఃస్క ఇబ్బె ఇడ్ఃఅ. నా కికాఙ్‌ సుడ్ఃఅ. నీ కియు సాప్సి నా పడఃకాద్‌ మన్ని గాయమ్‌దు ఇడ్ఃఅ. అనుమానం సిల్లెండ నమిఅ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","అయావలె తోమా, “నీనె నా ప్రబు. నీనె నా దేవుణు”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","అందెఙె యేసు వన్నిఙ్, “నీను నఙి సుడ్ఃతిఙ్‌ నిఙితమనాన్‌ ఇజి నమ్మితి. నఙి తొఏండ నమ్మితికార్‌ గొప్ప వారు”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","యేసు వన్నిసిసూర్‌ఙ నడిఃమి, మరి నండొ బమ్మాని పణిఙ్‌ కితాన్. అయకెఙ్‌ యా పుస్తకమ్‌దు రాస్‌ఉ. ");
INSERT INTO kfc_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","గాని, యేసు క్రీస్తు ఇజి, వాండ్రు దేవుణుమరిసి ఇజి మీరు నమ్మినివందిఙ్, వన్ని ముస్కు మన్ని మీ నమకమ్‌దాన్‌ మిఙి ఎలాకాలం దేవుణువెట బత్కిని బత్కు దొహ్నివందిఙ్‌ యాకెఙ్‌ రాస్త మన్నె. ");
INSERT INTO kfc_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","దిని వెనుక, యేసు తిబెరియ సమ్‌దరం డగ్రు మరి వన్ని సిసూర్‌ఙ తోరె ఆజినాన్. వాండ్రు ఈహు తోరె ఆతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","సిమోన్‌ పేతురు, దిదిమ ఇజి కుకెఆని తోమా, గలీలయ ప్రాంతమ్‌ది కానా ఇన్ని పట్నమ్‌ది నతనయేలు, జెబెదయ మరిసిర్‌ఆతి యాకోబు యోహాను, మరి రిఏర్‌ సిసూర్‌ కూడిఃత మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","సిమోన్‌ పేతురు, “నాను మొయెఙ్‌ అస్తెఙ్‌సొన్‌సిన”, ఇజి వరిఙ్‌ వెహ్తాన్‌. అయావలె వారు, “మాపు బా నీ వెట వానాప్”, ఇహార్‌. అందెఙె వారు సొహరె, ఉండ్రి డోణి ఎక్తారె సొహార్‌. గాని ఆ రెయితు ఇనికబా అస్‌ఏతార్. ");
INSERT INTO kfc_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","పొద్దు సోసి మహివలె, యేసు సమ్‌దరం దరీదు నిహన్. గాని వన్ని సిసూర్‌ యేసుఇజి గుర్తు అస్‌ఏతార్. ");
INSERT INTO kfc_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","అందెఙె వాండ్రు వరిఙ్, “తంబెరిఙాండె, మొయెఙ్‌ఇన్నికబా అస్తిదెరా?”, ఇజి వెన్‌బాతాన్. వారు, “సిల్లెద్‌”, ఇజి వన్నిఙ్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","నస్తివలె వాండ్రు, “డోణి ఉణెర్‌ పడఃకాదు మీ వలెఙ్‌పొక్తు. మిఙి దొహ్క్‌నె”, ఇజి వెహ్తాన్‌. వారు అయ లెకెండ్‌ కిత్తార్. మొయెఙ్‌ నండొ అర్తె. వల లాగ్‌దెఙ్‌ అట్‌ఏతార్. ");
INSERT INTO kfc_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","అయావలె, యేసు నండొ ప్రేమిస్తి సిసూ, “వాండ్రు ప్రబు”, ఇజి పేతురుఙ్‌వెహ్తాన్‌. “వాండ్రు ప్రబు”, ఇజి అయా సిసూ వెహ్తి మాట విహి వెటనె, సిమోన్‌ పేతురు వాండ్రు లాగితి ఇడ్తి సాల్వ ప్‌డ్‌గితాండ్రె, సమ్‌దరమ్‌దు డాట్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","వారు గటుదాన్‌ ఎంజు మెంసు నూరు మూరెఙ్‌నె దూరం మనార్. అందెఙె మహి సిసూర్‌ మొయెఙ్‌మన్ని వల లాగ్‌జినె డోణిదు వాతార్. ");
INSERT INTO kfc_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","వారు డిఃగ్‌జి వాతిఙ్‌గటుదు, సిసూ డిఃప్కుఙ్‌ దనిముస్కు మొయెఙ్‌ రొటెఙ్‌ తోరితె. ");
INSERT INTO kfc_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","యేసు వరిఙ్, “మీరు ఏలు అస్తి మహి సెగం మొయెఙ్‌ అగాట్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","సిమోన్‌ పేతురు డోణి ఎక్తాండ్రె వల గటుదు లాగితాన్. అబె నూటి యాబయి మూండ్రి పెరి మొయెఙ్‌వలదు నిండ్రితె మహె. గాని నిసొ మహిఙ్‌బా వల కింజ్‌ఏతాద్. ");
INSERT INTO kfc_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","యేసు వరిఙ్, “రదు తిండ్రు”, ఇజి వెహ్తాన్‌. వాండ్రు ప్రబు ఇజి వరిఙ్‌తెలితార్. అందెఙె, నీను ఎయి ఇజి వన్నిఙ్‌ వెన్‌బాదెఙ్‌ సిసూర్‌ లొఇ ఎయెన్‌ వన్నిఙ్‌బా దయ్‌రం సిల్లెతాద్. ");
INSERT INTO kfc_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","యేసు వాతాండ్రె, రొట్టెఙ్‌ లాగితాండ్రె వరిఙ్‌ సీబాత సితాన్. అయ లెకెండ్‌ మొయెఙ్‌బా సిత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","యేసు సాతి వరిబాణిఙ్‌ బత్కితి వెన్కా, దినివెట ఏలు ముసార్‌ సిసూర్‌ఙ తోరె ఆత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","వారు తిహి వెన్కా, యేసు సిమొన్‌పేతురుఙ్, “యోహాను మరిసి ఆతి సిమొను, నీను మహి సిసూర్‌ఙ ఇంక నీను నండొ నఙి ప్రేమిస్నిదా?”, ఇజి వెన్‌బాతాన్. “ఒఒ ప్రబువా, నాను నిఙి ప్రేమిస్న ఇజి నీను నెస్ని”, ఇజి వాండ్రు వెహ్తాన్‌. అందెఙె యేసు, “నా గొర్రె పిలెకాఙ్‌మేప్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","మరిబా యేసు వన్నిఙ్, “యోహాను మరిసి ఆతి సిమొను, నీను నఙి ప్రేమిస్నిదా?”, ఇజి వెన్‌బాతాన్. “ఒఒ ప్రబువా, నాను నిఙి ప్రేమిస్న ఇజి నీను నెస్ని”, ఇజి రిజ వెహ్తాన్‌. అందెఙె యేసు, “నా గొర్రెఙ్అడిఃఅ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","“యోహాను మరిసిఆతి సిమొను, నఙి ప్రేమిస్నిదా?”, ఇజి ముసార్‌వెన్‌బాతాన్. నీను నఙి ప్రేమిస్నిదా ఇజి ముసార్‌దిఙ్‌వెన్‌బాతిఙ్, పేతురు బాద ఆతాన్. “ప్రబు నీను విజు నెస్నికి. నాను నిఙి ప్రేమిస్న ఇజి నీను నెస్ని”, ఇజి పేతురు వెహ్తాన్‌. అందెఙె యేసు, “నా గొర్రెఙ్‌ మెప్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“నాను నిజం నీవెట వెహ్సిన, నీను దఙడః మనివలె, నీను తయార్‌ ఆజి నీ ఇస్టం ఆతి బాడిఃదు సొహి. గాని నీను డొక్ర ఆనివెలె, నీకికు నీను సాప్ని. మరి ఎయెన్‌బా నిఙి తొహ్సి నిఙి ఇస్టం సిల్లి బాడిఃదు పిండిజి ఒనాన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","పేతురు ఎలాగమర్తి సావు సాజి దేవుణు గొప్పపెరికాన్‌ ఇజి తోరిస్నాండ్రొ, దనివందిఙ్‌ వాండ్రు యా మాటెఙ్‌వెహ్తాన్‌‌. వెన్కా వన్నిఙ్, “నా సిసూ ఆజి రఅ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","పేతురు వెనుక మహ్తండ్రె, యేసు నండొ ప్రేమిస్తి సిసూ, వరి వెన్కా వాజినిక సుడ్‌తాన్. (యా సిసూనె పస్క బోజనం తిహివలె యేసు గుంజమ్‌దు ఒరిగితాండ్రె, “ప్రబువా, నిఙి అదికారిఙ కీదు ఒపజెప్నికాన్‌ ఎయెన్”, ఇజి వెన్‌బాతికాన్). ");
INSERT INTO kfc_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","పేతురు వన్నిఙ్‌ సుడ్ఃతాండ్రె, “ప్రబువా, వినిఙ్‌ఇన్నిక జర్గినాద్‌?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","అందెఙె యేసు, “నాను మర్‌జి వానిదాక వాండ్రు బత్కిదెఙ్‌నఙి ఇస్టం ఆతిఙ, నిఙి ఇన్నిక? నీను నా సిసూ ఆజి వెన్కా వాదెఙ్‌వలె”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","యేసు అయలెకెండ్‌ వెహ్తిఙ్, యా సిసూ సాఏన్‌ ఇజి ఉండ్రి మాట మహి వరి నడిఃమి సెద్రిస్తాద్. గాని వాండ్రు సాఏన్‌ ఇజి యేసు వెహఏతాన్. నాను వానిదాక వాండ్రు బత్కిదెఙ్‌నఙి ఇస్టం ఆతిఙ, నిఙి ఇన్నిక?”, ఇజినె వాండ్రు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","యా సఙతిఙ వందిఙ్‌ వెహ్తికాన్‌ యా సిసూనె. వీండ్రె ఆయాకెఙ్‌రాస్త ఇట్తాన్. వాండ్రు వెహ్తికెఙ్‌ నిజం ఇజి మాపు నెసినాప్. ");
INSERT INTO kfc_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","యేసు మరి నండొ సఙతిఙ్‌ కిత్తాన్. అయాకెఙ్‌ విజు రాసి ఇడ్‌దెఙ్‌ ఇహిఙ, రాసిని పుస్తకమ్‌కు అస్తెఙ్‌ యా లోకమ్‌దు మన్ని బాడ్డి సాల్‌ఏద్‌ ఇజి నాను ఒడ్‌కీస్తు ఇజి.");
INSERT INTO kfc_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","నా ప్రియమాతి దెయొపిలా, నాను ముందాల్‌ రాస్తి పుస్తకమ్‌దు, దేవుణు యేసుఙ్‌ పరలోకమ్‌దు ఒనెండ యేసు కిత్తి విజు పణిఙ వందిఙ్, యేసు నెస్‌పిస్తి విజు మాటెఙవందిఙ్ ‌రాస్త మనాద్. దేవుణు యేసుఙ్‌ పరలోకమ్‌దు ఒనిముందాల యేసు, వాండ్రు ఏర్‌పాటు కిత్తి అపొస్తురుఙ్‌ వారు కిని పణి వందిఙ్ దేవుణు ఆత్మ సత్తుదాన్ ‌ఆడ్ర సిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","యేసు కస్టమ్‌కు ఓరిసి సాతి వెనుక నిఙితండ్రె, నాను బత్కిత్త ‌ఇజి అపొస్తురు అనుమానం సిల్లెండ నమ్మిదెఙ్‌ ‌యేసు వరిఙ్ ‌తోరె ఆతాన్. నలపయ్ ‌రోస్కాఙ్‌ నండొ సుట్కు యేసు అపొస్తురుఙ్‌ ‌తోరె ఆతండ్రె దేవుణు ఏలుబ‍డిః వందిఙ్ ‌వర్గితాన్. ");
INSERT INTO kfc_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","వారు కూడ్ఃజి వాతివలె యేసు ఈహు ఆడ్ర సిత్తాన్‌, “యెరూసలేం పట్నం డిఃసి సొన్మాట్. నా బుబ్బ మిఙి సీనా ఇజి ఒట్టు కిత్తి వన్ని ఆత్మ ఇని ఇనాయమ్‌వందిఙ్‌ నాను ముందాల్నె వెహ్తగదె. ద‍న్నివందిఙ్ కాప్‌ కిజి మండ్రు. ");
INSERT INTO kfc_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","యోహాను ఏరుదాన్‌ బాప్తిసం సిత్తాన్‌. గాని సెగం రోస్కు సొహిఙ దేవుణు మిఙి వన్ని ఆత్మదాన్‌ ‌బాప్తిసం సీనాన్”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","అపొస్తురు యేసు వెట కూడ్ఃజి వాతారె వెన్‌బాతార్, “ప్రబువా, ఏలునె మా ఇస్రాయేలు లోకాఙ్‌ ‌మా దేసెమ్‌ది ఏలుబడిః మర్‌జి సీనిలెనా?”. ");
INSERT INTO kfc_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","యేసు వెహ్తాన్‌, “కాలం వందిఙ్ ‌నా బుబ్బానె ఏర్పాటు కిత్తాన్. అక్కెఙ్‌ విజు నా బుబ్బాతి దేవుణు అతికారమ్‌దు మనాద్. యాకెఙ్‌ విజు ఎసెఙ్‌ ‌జర్గినాద్ ‌ఇజి మీరు నెస్తెఙ్‌ ‌అవ్‌సరం సిల్లెద్‌. ");
INSERT INTO kfc_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","అహిఙ, దేవుణు ఆత్మ మీ ముస్కు వానివలె మీరు సత్తు ఆనిదెర్. అయావలె మీరు యెరూసలేమ్‌దు, యూదయ దేసెం విజు, సమరియ దేసెం విజు, లోకం విజుబాన్‌ నా వందిఙ్‌ ‌వెహ్సి నా సాసిర్‌ ఆనిదెర్”. ");
INSERT INTO kfc_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","యా మాటెఙ్‌ వెహ్తండ్రె వారు సుడ్ఃజిమహిఙ్ ‌దేవుణు యేసుఙ్‌ పరలోకమ్‌దు ఒతాన్. అయావలె ఉండ్రి మొసొప్‌ వాతాదె అడ్డు కిత్తిఙ్‌ ‌వారు యేసుఙ్‌ ‌తోర్‌ఏండ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","యేసు ఆగాసం ముస్కు సొన్సి మహిఙ్ ‌వారు ఆగాసం దరోట్నె డిటం బేసి మహార్‌. అయావలె వెటనె తెల్లాని పాతెఙ్‌ ‌పొర్‌పాతిమ‍హి రిఎర్‌ ‌దూతార్‌ వరి డగ్రు నిహార్. ");
INSERT INTO kfc_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“ఓ గలీలయాదికిదెరా, మీరు ఎందనిఙ్‌ ‌ఆగాసం దరోట్‌ ‌సుడ్ఃజినిదెర్‌? మీ డగ్రుహాన్ దేవుణు పరలోకమ్‌దు యేసుఙ్‌ ఒతాన్. ఎలాగ సొహాండ్రొ అయావజనె మర్‌జి వానాన్‌లె”, ఇజి వారు వరిఙ్ ‌వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","వెనుక అపొస్తురు ఒలివ మరెక్‌ మన్ని గొరొతాణ్ ‌యెరూసలేం పట్నమ్‌దు మహ్త సొహార్. (ఒలివ మరెక్‌ మన్ని గొరొన్‌ ‌యెరూసలేం పట్నం డగ్రునె. ఉండ్రి కిలో మీటర్ ‌దూరం మనాద్) ");
INSERT INTO kfc_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","వారు యెరూసలేమ్‌దు సొహరె వారు మహి మేడః గదిదు ఎక్తార్. వారు ఎయెర్‌ ఎయెర్‌ ఇహిఙ, పేతురు, యోహాను, యాకోబు, అంద్రెయ, పిలిపు, తోమా, బర్తొలొమయి, మత్తయి, అల్‌పయ్‌ మరిసి ఆతి యాకోబు, జలొతె ఇని మరి ఉండ్రి పేరు మహి సీమోను, యాకోబు మరిసి ఆతి యూద ఇనికార్. ");
INSERT INTO kfc_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","వారు విజేరె కూడిఃతారె ఉండ్రె మన్సుదాన్ ‌డిఃస్‌ఏండ పార్దనం కిజి మహార్‌. వరివెట సెగొండెక్‌ అయ్‌లికొడొఃక్‌బా వాతె మహె. యేసు యాయ ఆతి మరియ, వన్ని తంబెర్‌సీర్‌బా అబ్బె మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","సెగం రోస్కు సొహి వెనుక డగ్రు డగ్రు నూట ఇర్‌వయ్‌ మణిసిర్‌ యేసుఙ్‌ నమ్మితికార్ ‌కూడిఃత మహార్‌. పేతురు వరినడిఃమి నిహండ్రె ఈహు వెహ్తాన్‌, ");
INSERT INTO kfc_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“తంబెరిఙాండె, దేవుణు మాటదు రాస్తి మహిక తప్‌ఏండ జర్గితాద్. దేవుణు ఆత్మ సత్తుదాన్ ‌దావీదు రాజు యూద వందిఙ్ ‌ముందాల్నె వెహ్తికాద్‌ ‌జర్గితాద్. యా యూద యేసుఙ్‌ అస్తెఙ్‌ ‌వాతివరిఙ్‌ సరి తోరిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","వాండ్రు మా లొఇ ఒరెన్. ఎందనిఙ్‌ ఇహిఙ మాపు అపొస్తురు వెట కూడ్ఃజి పణి కిదెఙ్ ‌యేసు వన్నిఙ్‌ ఏర్‌పాటు కిత్తాన్”. ");
INSERT INTO kfc_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(యా యూద మొసెం పణిదాన్‌ సంపాదిస్తి డబ్బుఙాణ్ ‌బూమి కొటాన్. అబ్బె గ‍డిఃయబుర కితాండ్రె అర్తాండ్రె సాతాన్. అయావలె పొట బదెఙ్‌ ఆజి వస్కిఙ్‌ విజు వెల్లి సోతె. ");
INSERT INTO kfc_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","యెరూసలేమ్‌దికార్‌ విజేరె యా సఙతిఙ్‌ ‌వెహరె నెస్తార్. అందెఙె యూద అర్తిసాతి యా బూమిదిఙ్‌ వరి బాసాదు అక్కెల్దెమ ఇజి వెహ్తార్‌. దన్ని అర్దం ఇనిక ఇహిఙ, ‘ఒరెన్‌ లోకుదిఙ్‌ సప్తి వందిఙ్ ‌దొహ్తి డబ్బుదాన్‌ కొటి బూమి’ ఇజి అర్దం). ");
INSERT INTO kfc_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","పేతురు మరి వెహ్తాన్‌, “కీర్తనం పుస్తకమ్‌దు ముందాల్నె ఈహు రాస్త మనాద్‌: వన్ని ఇల్లు ఎయెన్‌బా మన్‌ఏండ ఆపిన్, దన్ని లొఇ ఎయెన్‌బా బత్కిఎండ ఆపిన్”. ఈహుబా రాస్త మనాద్‌: అపొస్తుడు వ‍జ వాండ్రు కిత్తి పణి మరి ఒరెన్‌ లాగె ఆపిన్. ");
INSERT INTO kfc_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","అందెఙె మాపు పదకొండు మణిసిర్‌ ‌అపొస్తురు వెట కూడ్ఃజి మండ్రెఙ్‌ మరి ఒరెన్‌ వన్నిఙ్ ‌ఏర్‌పాటు కిదెఙ్‌వలె. యోహాను యేసుప్రబుఙ్‌ బాప్తిసం సిత్తి బాణిఙ్ అసి ‌యేసుప్రబు పరలోకమ్‌దు సొనిదాక మా నడిఃమినె కూడ్ఃజిపాడ్ఃజి మా వెట మహికాన్ ‌ఒరెన్‌ వన్నిఙ్ ‌అవ్‌సరం. ఎందనిఙ్‌ ఇహిఙ యేసు సాతి వరిబాణిఙ్ ‌మర్‌జి బత్కితాన్‌ ఇజి వాండ్రుబా మా వెట సాసి మండ్రెఙ్. ");
INSERT INTO kfc_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","అందెఙె కూడ్ఃజి వాతి మహికార్ ‌రిఎరి పేర్‌కు వెహ్తార్‌. ఒరెన్ ‌యోసేపు (వన్నిఙ్‌ యుస్తు, బర్సబ ఇని పేర్కుబా మహె) మరి ఒరెన్ ‌మత్తియ. ");
INSERT INTO kfc_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","అయావలె వారు ఈహు పార్దనం కిత్తార్‌, “ప్రబువా, విజెరి మన్సుదు మన్ని విజు ఆలోసనమ్‌కు నీను నెసిని. యూద, వన్నిఙ్ ‌తగితి బాడ్డిదు ‌సొహాన్‌. వాండ్రు డిఃసిసొహి పణి, ఇహిఙ స‍ఙమ్‌దిఙ్ న‍డ్ఃపిసి సేవ‍కిని ప‍ణి సీదెఙ్‌ ‌వన్నిఙ్ ‌బదలు యా రిఎర్‌ లొఇ ఎయెఙ్‌ నీను ఏర్‌పాటు కిత్తి ఇజి మఙి తోరిస్‌అ”. ");
INSERT INTO kfc_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","వెనుక వారు సీటిఙ్‌ పొక్తార్. అయావలె మత్తియ ఇని పేరుదాన్‌ ‌సీటి వాతాద్. అందెఙె మత్తియెఙ్‌బా పదకొండు మణిసిర్‌ అపొస్తురు వెట లెక్క కల్‌ప్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","పెంతెకొస్తు ఇని పండొయ్‌ నాండిఙ్ ‌యేసుఙ్‌ నమ్మితికార్ విజేరెకూడ్ఃజి ఉండ్రి ఇండ్రొ మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","వెటనె ఆగాసమ్‌దాన్ ‌ఉండ్రి జాటు వాతాద్. అయ జాటు, పెరి గాలి వానివజ జాటుదాన్ ‌వాతాదె వారు బస్తిమహి ఇండ్రొ నిండ్రితాద్. ");
INSERT INTO kfc_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","వారు సుడ్ఃతిఙ్‌ సిసుబొద్దు లెకెండ్‌ తోర్నిక ఉండ్రి వాతాదె ఒరెన్‌ ఒరెన్‌ ముస్కు ఉండ్రె ఉండ్రె కొనెఙ్ ‌డిఃగితె. ");
INSERT INTO kfc_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","విజేరె ముస్కు దేవుణు ఆత్మ సత్తు వాతిఙ్‌ వారు, వరిఙ్ ‌నెస్‌ఇ బాసెఙ్‌ వర్గిదెఙ్‌ మొదొల్‌స్తార్. దేవుణు ఆత్మనె నెస్‌ఇ బాస వర్గిదెఙ్‌ వరిఙ్‌ సత్తు సిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","అయావలె విజు దేసమ్‌కాణిఙ్ ‌వాతిమహి బక్తిమన్ని యూదురు యెరూసలేం పట్నమ్‌దు మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","యూదురు మంద లోకుర్ యా జాటు వాతిబాన్ కూడిఃతార్. వారు వర్‌గినిక వీరు వ‍న్ని వన్ని సొంత బాసెఙాణిఙ్ వెహారె యా కూడ్ఃజి వాతి మహి యూదురు బమ్మ ఆతార్. “వీరు మాటు వర్గిని బాసెఙ్ వ‍ర్‌గిజినార్‌ కొటె”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","అయావలె వాతి మహికార్ విజేరె ఒదె బమ్మ ఆతారె ఒరెన్‌ వెట ఒరెన్‌ వెహ్తార్‌, “యాక ఎలాగ? వీరు విజేరె గలీలయాదికార్‌ ఆఏరా? ");
INSERT INTO kfc_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","గాని మాపు పుట్తిమ‍హి నాహ్కణి ఆఇ ఆఇ బాసెఙ్‌‌ యా గలీలయాదికార్ ‌వర్గిజినార్. యాక మాపు వెంజినాప్. ");
INSERT INTO kfc_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","11","పార్తియికు, మదియికు, ఎలామియుకు, మెసొపొతేమియ, యూదయ, కపదొకియ, పొంతు, ఆసియ, ప్రుగియ, పంపులియ, అయ్‌గుప్తు, కురేనె డగ్రు మన్ని లిబియ, రోమ దేసెమ్‌దాన్‌ కూల వాతికార్ (యూదురు, యూదమతం నమ్మితి యూదురు ఆఇకార్‌) క్రేతియురు, అరెబియురు, దేవుణు కిత్తి గొప్ప పణిఙ్‌ మాటు విజెటె పుట్తి బాసాదు వెహ్నిక వెంజినాట్‌. ");
INSERT INTO kfc_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ఒడిఃబిత్తిఙ మన్సు కూడ్ఃఏద్. యాక ఇనిక ఆనాద్‌లెనొ”, ఇజి వారు విజేరె పంబ్ర ఆతారె ఒరెన్‌ వెట ఒరెన్‌ వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","సెగొండార్‌ వీరు తియాఙ్ ద్రాక్స రసం ఉటారె సోస్త మనార్‌ ‌ఇజి వరిఙ్‌ సెకాల్‌ కిత్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","అయావలె పదకొండు మణిసిర్‌ అపొస్తురు వెట మహి పేతురు నిఙితండ్రె అబ్బె కూడ్ఃజి వాతి లోకుర్‌ వెట డటం వెహ్తాన్‌, “యెరూసలేమ్‌దు బత్కిజిని మా ‍సొంత లోకుర్ ఆతి యూదయ లోకాండె, నాను వెహ్నిక నెగ్రెండ వెండ్రు. వీరు విరిఙ్ ‌నెస్‌ఇ బాసెఙ్‌ వర్గితిక మీరు వెహిదెర్. ");
INSERT INTO kfc_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","మీరు ఒడిఃబిని లెకెండ్‌ వీరు సోస్తికార్‌ ఆఏర్. పొద్దు సోసి ఏలు అంబెలి వేడఃబా ఆఏద్‌. ");
INSERT INTO kfc_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","గాని దేవుణు మాటెఙ్‌ వెహ్తి యోవెల్ ప్రవక్త ముఙాలె వెహ్తికదె మీరు సుడ్ఃజినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","యోవెల్‌ ప్రవక్త ఇనిక వెహ్తాన్‌‌ ఇహిఙ ఆకార్‌ దినమ్‌కాఙ్‌ ‌నాను ఇనిక కిన ఇజి దేవుణు వెహ్సినాన్. విజు లోకాఙ్‌ నా ఆత్మదిఙ్‌ సీన. మీ మరిసిర్, మీ గాడ్సిక్, ప్రవక్తరు లెకెండ్‌ దేవుణు మాటెఙ్‌ వర్‌గినార్‌లె. మీ దఙ్‌డెఃఙ్ ‌దేవుణు బాణిఙ్‌ వాని దర్సనమ్‌కు సూణార్. మీ డొక్రార్‌బా దేవుణు బాణిఙ్‌ వాని కలెఙ్ ‌సూణార్‌లె. ");
INSERT INTO kfc_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","అయ ఆకార్‌ దినమ్‌కాఙ్‌ ‌నా ముస్కు నమకం ఇడ్ఃతి పణి మణిసిరిఙ్‌బా విజేరిఙ్, అయ్‌లి కొడొఃకాఙ్, మొగ్గ కొడొఃకాఙ్‌ నా ఆత్మ సీనా. వారు విజేరె దేవుణు మాటెఙ్‌ వెహ్నార్‌లె. ");
INSERT INTO kfc_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ఆగాసం ముస్కు విజేరె సూణి వజ నాను గొప్ప బమ్మాతి పణిఙ్ ‌తోరిస్న. యా బూమి ముస్కు ఎయెర్‌బా తొఇ పణి నాను కిన. నల, సిసు, కర్నిగోయి బూమి ముస్కు వానెలె. ");
INSERT INTO kfc_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ప్రబు మర్‌జి వాని అయ గొప్ప బమ్మాని దినం వాని ముఙాల పొద్దు సీకటి ఆనాద్‌లె. నెల నల లెకెండ్‌ ఎరాఙ్ ‌ఆనాద్‌లె. ");
INSERT INTO kfc_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","అయావలె ఎయెర్‌బా దేవుణు పేరు అసి వన్ని ముస్కు నమకం ఇట్తిఙ వరిఙ్‌ విజేరిఙ్, దేవుణు, తీర్‌పుదాన్‌ గెల్‌పిస్నాన్‌లె. ");
INSERT INTO kfc_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","పేతురు మరి వెహ్తాన్‌, “ఇస్రాయేలు లోకాండె, నెగ్రెండ వెండ్రు. నజరేతు వాండ్రు ఆతి యేసు అతికారం దేవుణు బాణిఙ్‌ వాతిక ఇజి దేవుణు రుజుప్‌ కిత్తాన్. ఎలాగ ‌ఇహిఙ, యేసు వెట మీ లొఇ కిత్తి గొప్ప పణిఙాఙ్, ఎయెర్‌ కిదెఙ్‌ అట్‌ఇ బమ్మాతి పణిఙాణ్ ‌రుజుప్ ‌కిత్తాన్. యాక విజు మీరు నెసినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","యా యేసుఙ్, ఒరెన్‌ మణిసి మీ డగ్రు ఒపజెప్తాన్. యా సఙతి దేవుణు ముందాల్నె నెస్తాన్. యాక దేవుణు ముందాల్నె ఏర్‌పాటు కిత్తి సఙతి. మీరు యేసుఙ్‌ సెఇవరి దర్పుదాన్‌ అస్తిదెరె సిలువ ముస్కు డెఃయ్‌జి సప్తిదెర్. ");
INSERT INTO kfc_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","గాని దేవుణు యేసుఙ్‌ సావుదాన్‌ తప్రిసి బత్కిస్తాన్. నండొ మా‍లెఙ్ ఆజి సాతాన్‌ గాని దేవుణు వన్నిఙ్‌ సావుదు డిఃస్ఏతాన్. యేసుఙ్‌ ఎలాకాలం తొహ్సి ఇడ్ఃదెఙ్‌ ‌సావుదిఙ్ ‌అట్‌ఏండ ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","యేసు మాటెఙ్‌ దావీదురాజు ముందాల్నె ఈహు వెహ్తాన్‌ నాను దేవుణుదిఙ్‌ ‌ఎల్లకాలం నా డగ్రు సుడ్ఃజి మహ. దేవుణు నా ఉణెర్‌ ‌పడఃక మనాన్. అందెఙె నాను మన్సుదు మాలెఙ్ ఆఏ. ");
INSERT INTO kfc_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","అందెఙె నా మన్సుదు నాను గొప్ప సర్ద ఆజిన. నాను సర్ద ఆజి వర్గిజిన. నాను నా ఒడొఃల్‌ దేవుణుదిఙ్‌ ఒపజెప్న. ఎందనిఙ్‌ ‌ఇహిఙ ఒడొఃల్‌ సాతి వెనుక మరి బత్కిన ఇజి నాను నెసిన. ");
INSERT INTO kfc_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ఎందనిఙ్‌ ఇహిఙ నీను నా పాణమ్‌దిఙ్‌ డిఃస్‌ఇ. న‍మ్మిదెఙ్ తగ్నికాన్‌ ఆతి నీ సేవ కినివన్ని పీనుగు సబ్‌జి సొండ్రెఙ్‌ సరి సిఇ. ");
INSERT INTO kfc_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","నీను నఙి ఎలాకాలం బత్కిని సరి తోరిస్తి. నీను నా వెట మహిఙ్‌ నాను గొప్ప సర్ద ఆజిన”. ");
INSERT INTO kfc_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“నా తంబెరిఙాండె, నాను దయ్‌రమ్‌దాన్‌ వెహ్సిన, మా అనిగొగొ ఆతి దావీదురాజు సాతండ్రె వన్నిఙ్‌ ముస్తార్. వన్నిఙ్ ముస్తి బాడ్డి ఎంబె మనాద్‌ ‌ఇజి ఏలుబా మాటు నెసినాట్. ");
INSERT INTO kfc_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","గాని దావీదురాజు దేవుణు ప్రవక్త. దేవుణు వన్ని పేరు అసి వాండ్రె దావీదురాజు వెట ఒట్టు పొక్తాన్. అక్క ఇనిక ఇహిఙ, దావీదురాజు కుటుమ్‌దాన్‌ ఒరెన్‌ వన్నిఙ్ ‌దావీదురాజు లెకెండ్ ‌రాజు కిన ఇజి. యాక దావీదురాజు నెస్త మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","దేవుణు యేసుక్రీస్తుఙ్‌ సాతి వరి బాణిఙ్‌ డిఃస్‌ఏన్‌ ఇజి, యేసుక్రీస్తు పీనుగు సబ్‌జి సొన్‌ఏద్‌ ఇజి దావీదురాజు ముందాల్నె నెస్తాన్. ముందాల్నె నెస్తాండ్రె, యేసు సాతి వెనుక మరి మర్‌జి నిఙ్‌నాన్‌లె ఇజి ముందాల్నె దావీదురాజు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","యా యేసుఙ్‌ దేవుణు మర్‌జి బత్కిస్తాన్. దన్నిఙ్‌ మాపు విజెపె సాసిర్. ");
INSERT INTO kfc_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","అహిఙ దేవుణు యేసుఙ్‌ వన్ని ఉణెర్‌ పడఃకాద్‌ ‌బస్‌పిసి వన్నిఙ్ ఇంక మిస్తి గవ్‌రం ఏలు సిత్తాన్‌. దేవుణు సీనా ఇజి ఒట్టు కిత్తి వన్ని ఆత్మ యేసుఙ్‌ సిత్తాన్‌. ఏలు మీరు సుడ్ఃజినికెఙ్‌ వెంజినికెఙ్ ‌యేసు మ‍ఙి సీనా ఇజి వెహ్తి దేవుణు ఆత్మనె. ");
INSERT INTO kfc_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","దావీదురాజు వెహ్తిక వన్ని వందిఙె ఆఏద్‌. దావీదురాజు పరలోకమ్‌దు సొన్‌ఏన్. గాని వాండ్రు ఈహు వెహ్తాన్‌, నాను నిఙి ప‍డ్ఃఇ వ‍రిఙ్ నీ పాదమ్‌కాఙ్ ‌ముణుకుఙ్ ‌ఊర్‌జి మాడిఃస్‌పిస్నిదాక నీను నా ఉణెర్‌ పడఃకాదు బసి మన్‌అ ఇజి దేవుణు నా ప్రబు వెట వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","పేతురు మరి వెహ్తాన్‌, “ఇస్రాయేలు కుటుమ్‌దికార్‌ ఆతి మాటు విజెటె యాక అనుమానం సిల్లెండ నెస్తెఙ్‌ వలె. మీరు సిలువాద్ ‌సప్తి యేసుఙ్‌ దేవుణు ప్రబువజ, క్రీస్తువజ ఏర్‌పాటు కిత్తాన్”. ");
INSERT INTO kfc_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","యాక వెహారె లోకుర్ ‌వరి మన్సుదు నండొ బాద ఆజి పేతురుఙ్‌ మరి అపొస్తురుఙ్‌ వెన్‌బాతార్, “దాదారండె, ఏలు మాపు ఇనిక కిదెఙ్‌ అట్నాప్?”. ");
INSERT INTO kfc_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","అయావలె పేతురు వెహ్తాన్‌, “మీ పాపమ్‌కు విజు ఒప్పుకొడ్ఃజి డిఃసిసీజి, దేవుణుదిఙ్‌ లొఙిజినాప్ ‌ఇజి విజెరిఙ్‌ ‌తోరిస్తెఙ్‌ యేసు, క్రీస్తు ఇజి, వాండ్రు, మీ ప్రబు ఇజి తోరిస్తెఙ్‌ బాప్తిసం లాగె ఆదు. అయావలె మీ పాపమ్‌కు నొరె ఆనె. దేవుణు సీనా ఇజి ఒట్టు కిత్తి దేవుణు ఆత్మ నిఙి దొహ్‌క్నాద్‌లె. ");
INSERT INTO kfc_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","దేవుణు సీనా ఇజి ఒట్టు కిత్తి యా దేవుణు ఆత్మ మిఙి, మీ కొడొఃరిఙ్, దూరమ్‌ది వరిఙ్ విజెరిఙ్‌ ‌దేవుణు సీనాన్. వన్ని ముస్కు నమ్మిదెఙ్‌ ‌దేవుణు కూక్ని వరిఙ్‌ విజెరిఙ్‌ ‌దేవుణు ఆత్మ సీనాన్”. ");
INSERT INTO kfc_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","మరి నండొ నండొ మాటెఙాణ్‌ పేతురు వరిఙ్ ‌గటిఙ వెహ్తాన్‌. దేవుణుదిఙ్‌ డిఃసి సొని యా సెఇ లోకాఙ్‌ వాని తీర్‌పుదాన్ ‌మీరు గెల్సి సొండ్రెఙ్‌ ఇజి పేతురు వరిఙ్‌ మరి మరి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","పేతురు వెహ్తి మాటెఙ్‌ నమ్మితికార్‌ బాప్తిసం లాగె ఆతార్. అయా రోజు రమరమి మూండ్రి వేలు లోకుర్‌ యేసుఙ్‌ నమ్మిత్తి వరివెట కూడిఃతార్. ");
INSERT INTO kfc_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","వారు అపొస్తురు నెస్‌పిస్తి మాటెఙ్‌ డిఃస్‌ఏండ మహార్‌. వారు యేసుఙ్‌ నమ్మిత్తికార్‌ కూడ్ఃజి మంజిని బాన్ డిఃస్ఏండ కూడ్ఃజి వాతారె ప్రబు ఏర్‌పాటు కిత్తి బోజనం కిజి మ‍హార్. డిఃస్‌ఏండ పార్దనం కిజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","అపొస్తురు దేవుణు సత్తుదాన్‌ నండొ బమ్మాని పణిఙ్ బమ్మాని గుర్తుఙ్‌ ‌కిత్తార్‌. అయావలె విజేరె నండొ బమ్మ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","యేసుఙ్‌ ‌నమ్మితికార్ విజేరె ఉండ్రె మన్సు మంజి వరిఙ్‌ కల్గితి మహిక‍ విజు విజేరి వందిఙ్ ‌కర్సు కిత్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","అక్కాదె ఆఏండ వారు వరి ఆస్తిఙ్‌ పొర్సి ఎయెఙ్ ‌ఎయెఙ్‌ అవ్‌సరం మనాదొ వరిఙ్ ‌సిత్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","రోజు తప్‌ఏండ వారు యెరూసలేమ్‌దు మన్ని దేవుణు గుడిఃది డేవాదు కూడ్ఃజి వాజి మహార్‌. వారు విజేరె ఇల్లుదిఙ్ తప్‌ఏండ కూడ్ఃజి వాతారె సర్ద ఆజి బోజనం కిజి మ‍హార్. ఎయెఙ్‌బా అవ్‌సరం మ‍న్ని వ‍రిఙ్ వారు సర్దదాన్‌ ‌సీజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","వారు దేవుణుదిఙ్‌ ‌స్తుతి కిజి మహార్‌. బాన్‌ మహికార్‌ విజేరె యా యేసుఙ్‌ ‌నమ్మిత్తి వరి వందిఙ్ ‘వీరు ఎసొనొ నెగ్గికార్‌’ ఇజి వెహ్తార్‌. రోజురోజు ‌యేసుప్రబు ముస్కు నమకం ఇడ్ఃతి వరి లెక్క వాండ్రు నండొ కిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ఒర్నెండు వేలె మూండ్రి గంటెఙ్‌ టయమ్‌దు, లోకుర్‌ దేవుణు గుడిఃదు పార్దనం కిని టయమ్‌దు పేతురు, యోహాను, రిఎర్‌ ‌కూడ్ఃజి దేవుణు గుడిఃదు సొన్సి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","పుట్తి బాణిఙ్‌ అసి నడిఃదెఙ్‌ అట్‌ఇ ఒరెన్‌ సొట వాండ్రు అబ్బె దేవుణు గుడిః లొఇ సొని సరిపడఃకాద్‌ డబ్బు లొసి మహాన్‌. దేవుణు గుడిఃది డేవాదు సొని అయ సరి పేరు సుందరం ఇహార్‌. అయ సొట వన్నిఙ్ ‌వన్ని లోకుర్‌ రోజు పిండిజి తసి అయ పడఃకాద్‌ ఇడ్ఃజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","పేతురు యోహాను దేవుణు గుడిఃదు సొని సరి డగ్రు వాతిఙ్‌ అయ సొట వాండ్రు డబ్బుఙ్ లొస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","లొస్తిఙ్, పేతురు వన్నిఙ్‌ డిటం బేస్తాన్. యోహానుబా వన్నిఙ్‌నె డిటం బేస్తాన్. పేతురు వన్నివెట, “నీను మా దరోట్నె బేస్అ” ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","అందెఙె సొట వాండ్రు, వీరు ఇనికబా సీనార్‌ ఇజి ఒడిఃబిజి వరి దరోట్నె బేస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","గాని పేతురు, “నిఙి సీదెఙ్‌ నా బాన్‌ డబ్బుఙ్ సిల్లు. గాని నా బాన్‌ మనిక నాను నిఙి సీనా. నజరేతుదికాన్‌ ‌యేసుక్రీస్తు అతికారమ్‌దాన్‌ ‌నీను నడిఃఅ”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","పేతురు అయ సొట వన్నిఙ్‌ ఉణికీదు అస్తాండ్రె నిక్తాన్. వెటనె వన్ని పాదమ్‌కు కణ్‌క కాల్కు సత్తు ఆతె. ");
INSERT INTO kfc_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","వాండ్రు లిట్‌నె నిఙితండ్రె నడిఃతాన్. పేతురు యోహాను వెట దేవుణు గుడిః డేవాదు నడిఃజి సొహాండ్రె డాట్సి దేవుణుదిఙ్‌ స్తుతి కిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","వీండ్రు నడిఃసినిక, దేవుణుదిఙ్‌ స్తుతి కినిక విజేరె సుడ్ఃతార్. ");
INSERT INTO kfc_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","దేవుణు గుడిఃదు సొని సుందరం ఇని సరిడగ్రు బసి డబ్బు లొసి మహి అయ సొట వాండ్రు వీండ్రె ఇజి వారు గుర్తు అస్తార్. వన్నిఙ్‌ జర్గితిక సుడ్ఃజి వారు విజేరె గొప్ప బమ్మ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","పేతురు, యోహానుని అయ నెగెండ ఆతికాన్‌ ‌దేవుణు గుడిఃదు మన్ని సొలొమోను ఇని అరఙుదు మహార్‌. ఆ నెగెండ ఆతికాన్‌ పేతురుఙ్‌ ‌యోహనుఙ్‌ గ‍టిఙ కిక్కాఙ్‌ అసి మహాన్. అబ్బె మహికార్‌ జర్గితిక సుడ్ఃజి గొప్ప బమ్మ ఆతారె పేతురు యోహానుని నెగెండ ఆతి సొట వాండ్రు మహిబాన్ ‌ఉహ్క్‌సి వాతార్. ");
INSERT INTO kfc_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","లోకుర్‌ విజేరె కూడ్ఃజి వానిక సుడ్ఃతండ్రె పేతురు వరిఙ్‌ వెన్‌బాతాన్, “ఇస్రాయేలు లోకాండె, ఇబ్బె జర్గితిక సుడ్ఃజి మీరు ఎందనిఙ్‌ బమ్మ ఆజినిదెర్‌? మీరు ఎందనిఙ్‌ మఙి బేసినిదెర్‌? మా సొంత సత్తుదాన్, మా బక్తిదాన్‌ వీండ్రు నడిఃదెఙ్‌ ‌కిత్తాప్ ‌ఇజి మీరు ఒడిఃబిజినిదెరా? ");
INSERT INTO kfc_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","మా అనిగొగొర్‌ ‌ఆతి అబ్రాహాం, ఇస్సాకు, యాకోబు పార్దనం కిత్తి దేవుణు, యా సొట వన్నిఙ్‌ నెగెండ కిజి వన్ని సేవ కినికాన్‌ ఆతి యేసుఙ్‌ నండొ మర్యాద సిత్తాన్‌. గాని మీరు యా యేసుఙ్‌ ‌సప్తెఙ్ ఒపజెప్తిదెర్. పిలాతు యేసుఙ్‌ డిఃసిసీదెఙ్ ‌ఒడ్ఃబిత్తిఙ్‌బా మీరు పోని ఇహిదెర్. ");
INSERT INTO kfc_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","పాపం సిల్లి నీతినిజయ్తిమన్ని వన్నిఙ్ ‌మీరు పోని ఇజి వెహ్తిదెర్. లోకాఙ్‌ సప్ని ఒరెన్‌ వన్నిఙ్‌ మీరు డిఃసిసీదు ఇజి వెహ్తిదెర్. ");
INSERT INTO kfc_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","విజు దన్నిఙ్ బత్కు సిత్తి వన్నిఙ్ ‌మీరు సప్తిదెర్. గాని దేవుణు వన్నిఙ్‌ మర్‌జి నిక్తాన్. యా సఙతి వందిఙ్‌ మాపు విజెపె సాసిర్. ");
INSERT INTO kfc_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","యేసు సత్తుదాన్‌నె యా సొట వాండ్రు సత్తుఆతాన్. మీరు విజిదెరె ఏలు సుడ్ఃజినిక యేసు పేరుదు ఇడ్తి నమకమ్‌దానె వాతాద్. యేసు ముస్కు ఇడ్తి నమకమ్‌దానె విన్నిఙ్ సత్తు వాతాద్”. ");
INSERT INTO kfc_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“ఏలు నా తంబెరిఙాండె, మీరుని, మీ పెద్దెలుఙ్, యేసుఙ్‌ కిత్తిక మీరు ఇనిక కిజినిదెరొ ఇజి నెస్‌ఏండ కిత్తిదెర్‌ ఇజి నాను నెస్న. ");
INSERT INTO kfc_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","దేవుణు నండొ పంటెఙ్‌ ముందాల్నె విజేరె ప్రవక్తర్‌ వెట ‘వన్ని క్రీస్తు కస్టమ్‌కు ఓరిస్నాలె’ ఇజి వెహ్త మహాన్‌. దేవుణు ముందాల్నె వెహ్తివజనె ఈహు జర్గితాద్. ");
INSERT INTO kfc_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","20","దేవుణు మీ పాపమ్‌కు సెమిస్ని వందిఙ్‌ మీరు మీ పాపమ్‌కు ఒప్పుకొడ్ఃజి డిఃసిసీజి దేవుణు డగ్రు మర్‌జి రదు. దేవుణు మీ ఆత్మదిఙ్‌ నెగ్గి పాణం సీని వందిఙ్, దేవుణు మీ వందిఙ్‌ ఏర్‌పాటు కిత్తి క్రీస్తు ఆతి యేసుఙ్‌ ‌మీ డగ్రు పోక్ని వందిఙ్‌ దేవుణు డగ్రు మర్‌జి రదు. ");
INSERT INTO kfc_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","దేవుణు ముందాల్నె వాండ్రు పోక్తి ప్రవక్తర్‌ వెట వెహ్తివజ దేవుణు విజు దన్నిఙ్‌ కొత్తాక లెకెండ్ ‌కినిదాక యేసు పరలోకమ్‌దు మండ్రెఙ్‌ వలె. ");
INSERT INTO kfc_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","దేవుణు - ప్రవక్తరు లొఇ ఒరెన్‌ మోసె ఇనికాన్‌ ‌ఈహు వెహ్తాన్‌‌: “ప్రబు ఆతి మీ దేవుణు, నా లెకెండ్‌ ఒరెన్‌ ప్రవక్తెఙ్‌ మీ లోకుర్‌ లొఇహాన్‌ పుటిస్నాన్‌లె. వాండ్రు వెహ్నిక విజు మీరు నెగ్రెండ వెంజి లొఙిదెఙ్‌ వలె. ");
INSERT INTO kfc_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ఎయెర్‌బా ఆ ప్రవక్త వెహ్నిక వెంజి లొఙిఏండ మహిఙ వాండ్రు దేవుణు లోకుర్‌ వెట మన్‌ఏండ పూర్తి పాడాఃనా సొనాన్. ");
INSERT INTO kfc_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","సముయేలు ప్రవక్త, వన్ని వెనుక వాతి ప్రవక్తరు విజేరె యా దినమ్‌కాఙ్‌ వందిఙ్‌ దేవుణు సిత్తి మాటెఙ్‌ ముందాల్నె వెహ్త మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","దేవుణు ప్రవక్తర్‌ వెట కిత్తి ఒట్టు మీ వందిఙె. దేవుణు మీ అనిగొగోరు వెట కిత్తి ఒట్టు మీ వందిఙె. మీ అనిగొగొ ఆతి అబ్రాహాం వెట దేవుణు కిత్తి ఒట్టు ఇనిక ఇహిఙ, మీ తెగాది వ‍న్ని బాణిఙ్ యా లోకమ్‌దు మన్ని విజేరిఙ్‌ నాను దీవిస్న. ");
INSERT INTO kfc_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","అందెఙె దేవుణు వన్ని సేవ కిని క్రీస్తుఙ్‌ ‌ఏర్‌పాటు కితాండ్రె ముందాల మీబానె పోక్తాన్. ఎందనిఙ్‌ పోక్తాన్‌ ‌ఇహిఙ మీ సెఇ పణిఙాణ్ ‌మఙి డిఃబిసి దేవుణుబాన్‌ మర్‌జి తసి మిఙి దీవిస్తెఙ్‌ వన్నిఙ్‌ పోక్తాన్”, ఇజి పేతురు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","పేతురు యోహాను లోకుర్‌ వెట వర్గిజి మహిఙ్ ‌పుజేరిఙు, సదుకెయరు, దేవుణు గుడిఃదు మన్ని జమాన్‌ఙ అతికారి పేతురు యోహాను బాన్‌ వాతార్. ");
INSERT INTO kfc_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","అపొస్తురు నెస్‌పిసినిక వెహారె వారు కోపం ఆతార్. ఎందనిఙ్‌ ఇహిఙ యేసు సాజి మర్‌జి బత్కితాన్‌ ఇజి వెహ్సి సాతికార్‌ మరి బత్కినార్‌ ఇజి వారు రుజుప్‌ కిత్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","వారు పేతురుఙ్‌ యోహనుఙ్‌ తొహ్త ఒతారె మహ్స నాండిఙ్‌ పెందాల్‌ దాక జెలిదు ఇట్తార్. ఎందనిఙ్‌ ఇహిఙ అయావలె పొదొయ్‌ ‌ఆత మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","గాని వారు నెస్‌పిసినిక వెహికార్ నండొ లోకుర్ ‌యేసుఙ్ ‌నమ్మితార్. యేసుఙ్‌ ‌నమ్మిత్తి వరి లెక్క ఏలు రమరమి అయ్‌దు వేలు ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","మహ్స నాండిఙ్‌ యూద అతికారిఙ్, యూద పెద్దెలుఙు, యూదురి రూలు నెస్పిసినికార్‌ వీరు విజేరె యెరూసలేమ్‌దు కూడిఃత వాతార్. ");
INSERT INTO kfc_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","విజేరె పుజేరిఙ ముస్కు పెరి పుజేరి ఆతి అనయు, కయపయు, పెరి పుజేరి కుటుమ్‌దికార్‌ ‌యోహాను, అలెక్సంతరు ఇనికార్, మరి సెగొండార్ ‌మొగకొడొఃర్‌ బాన్‌ కూడిఃత వాతార్. ");
INSERT INTO kfc_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","వారు పేతురుఙ్‌ యోహనుఙ్‌ వరి ముందాల నిల్‌ప్తారె వెన్‌బాతార్, “మీరు ఎమేణి సత్తుదాన్, ఎయె పేరుదాన్‌ ఇక కిత్తిదెర్‌?”. ");
INSERT INTO kfc_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","9","అయావలె దేవుణు ఆత్మ సత్తు పేతురు ముస్కు వాతాద్. అయ సత్తుదాన్‌నె పేతురు వెహ్తాన్‌‌: “లోకాఙ్‌ అతికారిఙాండె, పెద్దెలుఙాండె, యా సొట వన్నిఙ్ ‌కిత్తి నెగ్గి పణి వందిఙ్ వాండ్రు ఎయె సత్తుదాన్ ‌నెగెండ్‌ ఆతాన్‌ ‌ఇజి మీరు మఙి నేండ్రు కరాయి ఇజినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","దిన్ని వందిఙ్‌ మాపు వెహ్తెఙ్‌ ఇహిఙ, మీరు విజిదెరె, ఇస్రాయేలు లోకుర్‌ విజేరె యాక నెస్తెఙ్‌ వలె. మీరు సిలువాదు డెఃయ్‌జి సప్తి యేసుక్రీస్తుఙ్ ‌దేవుణు మర్‌జి బత్కిస్తాన్. సాతి బత్కితి నజరేతు వాండ్రు ఆతి యేసుక్రీస్తు సత్తుదాన్‌నె వీండ్రు పూర్తి నెగెండ ఆజి మీ నడిఃమిదు మనాన్. ");
INSERT INTO kfc_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","యా యేసుక్రీస్తు వందిఙ్‌ ఈహు రాస్త మనాద్. అక్క ఇనిక ఇహిఙ, ఇల్లు తొహ్ని మీరు నెక్తిపొక్తి పణుకునె మూలదిఙ్‌ మూలపణుకు ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","యేసునె మిఙి వాజిని సిక్సదాన్‌ ‌గెల్‌పిస్తెఙ్‌ అట్నాన్. ఎందనిఙ్‌ ‌ఇహిఙ యా లోకమ్‌దు లోకాఙ్‌ వాని సిక్సదాన్‌ వరిఙ్‌ గెల్‌పిస్తెఙ్‌ మరి ఎయెరి పేరుబా దేవుణు సిఏతాన్. యేసు పేరునె సిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","పేతురు యోహాను తియెల్‌ ఆఏండ నెగ్రెండ వర్గిజిని మాటెఙ్‌ ‌వెంజి సన్‌హద్రిం సఙమ్‌దికార్‌ బమ్మ ఆతార్. ‘వీరు ఇనికబా నెస్‌ఇకార్, పెరి స‍దువు సద్‌విఇకార్’ ఇజి నెస్తారె బమ్మ ఆతార్. పేతురు యోహాను యేసు వెట కూడ్ఃజి మహికార్‌ ఇజి వారు నెస్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","గాని ఆ నెగెండ ఆతికాన్‌ పేతురు యోహాను వెట నిల్సి మహిఙ్‌ ఇనికబా మర్‌జి వెహ్తెఙ్‌ ‌సన్‌హద్రిం సఙమ్‌దికార్‌ అట్‌ఎతార్. ");
INSERT INTO kfc_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","అందెఙె వారు పేతురుఙ్‌ ‌యోహానుఙ్‌ నెగెండ ‌ఆతి వన్నిఙ్‌ సఙమ్‌ లొఇహాన్‌ వెల్లి పోక్తారె వరి లొఇ వారె వర్గితార్. ");
INSERT INTO kfc_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“విరిఙ్‌ ఇనిక కిదెఙ్‌? వీరు కిత్తి బమ్మాని పణి వందిఙ్ ‌యెరూసలేమ్‌దికార్‌ విజేరె నెసినార్. అక్క జర్గిఏతాద్‌ ఇజి మాటు వెహ్తెఙ్‌ ‌అట్‌ఎట్. ");
INSERT INTO kfc_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","యేసు పేరు అసి ఎయెన్‌ వెటబా ఎసెఙ్‌బా ఇనికబా వెహ్మాట్‌ ఇజి మాటు విరిఙ్ ‌గటిఙ వెహ్నాట్. యా సఙతి మహికార్‌బా నెస్‌ఏండ మండ్రెఙ్” ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","అయావలె వారు పేతురుఙ్‌ యోహనుఙ్‌ ‌లొఇ కూక్తారె, “ఎసెఙ్‌బా యేసు పేరు అసి వెహ్మాట్. యేసు పేరు అసి బోదిస్మాట్”, ఇజి ఆడ్ర సితార్. ");
INSERT INTO kfc_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","గాని పేతురు యోహాను ఈహు వెహ్తార్‌, “ఏలు మీరె వెహ్తు, దేవుణుదిఙ్‌ లోబడ్ఃదెఙా మిఙి లొఙిదెఙా? దేవుణు సుడ్ఃతిఙ ఎమేణిక సరియాతిక? ");
INSERT INTO kfc_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","మాపు ఇహిఙ, మాపు సుడ్ఃతి దన్ని - వందిఙ్‌ మాపు వెహి దన్ని వందిఙ్‌ వెహ్‌ - ఏండ మండ్రెఙ్ ‌అట్‌ఎప్”. ");
INSERT INTO kfc_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","పేతురుఙ్‌ని యోహానుఙ్‌ ఎలాగ ‌సిక్స సీదెఙ్‌ ఇజి వారు నెస్ఏతార్. ఎందనిఙ్‌ ఇహిఙ దేవుణు కిత్తి గొప్ప పణి వందిఙ్‌ లోకుర్ విజేరె దేవుణుదిఙ్‌ ‌స్తుతి కిజి మహార్‌. అందెఙె సఙమ్‌దికార్ ‌పేతురుఙ్ ‌యోహానుఙ్‌ ‘యేసు పేరు అసి వెహ్తెఙ్‌ ఆఏద్‌’ ఇజి గటిఙ మరి బెద్రిసి వెహ్తరె డిఃస్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","దేవుణు వన్ని సత్తుదాన్‌ బమ్మాతి పణి కిజి నెగెండ ‌కిత్తి యా సొట వన్నిఙ్‌ వయ్‌సు నలపయ్ ‌పంటెఙ్ ‌ఎక్కునె మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","పేతురు యోహాను డిఃబె ఆతి వెటనె నమ్మిత్తి వరి డగ్రు సొహార్. సొహరె పెరి పుజేరిఙు, పెద్దెలుఙు వరి వెట వెహ్తిక విజు వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","పేతురు యోహాను వెహ్తిక వెహారె వారు విజేరె కూడిఃతారె ఉండ్రె మన్సుదాన్‌ దేవుణుదిఙ్‌ ఈహు పార్దనం కిత్తార్‌, “విజు దన్నిఙ్ ‌ప్రబు ఆతి దేవుణు, నీనె ఆగాసం, బూమి, సమ్‌దరం, వనక లొఇ మన్ని విజు దన్నిఙ్‌ పుటిస్తి. ");
INSERT INTO kfc_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","దేవుణు, నీ సేవ కినికాన్‌ ‌ఆతి మా అనిగొగొ దావీదురాజు వెహ్తిక నీ ఆత్మ సత్తుదాన్‌ నీనె వెహ్‌పిస్తి. అక్క ఇనిక ఇహిఙ, యా యూదురు ఆఇకార్‌ ఎందనిఙ్‌ కోపం ఆజినార్. యా లోకుర్ ఎందనిఙ్‌ ఇని దన్నిఙ్ పణిదిఙ్‌ రెఏకెఙ్‌‌ ఒడిఃబిజినార్‌? ");
INSERT INTO kfc_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","బూ లోకమ్‌ది రాజుర్, అతికారి లోకుర్, ‌ప్రబు ఆతి దేవుణు వెట, దేవుణు ఏర్‌పాటు కిత్తి క్రీస్తు వెట ఎద్రిస్తెఙ్ ‌కూడ్ఃజి వాజినార్. ");
INSERT INTO kfc_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ఆహె హేరోదు, పొంతి పిలాతు, యూదురు, యూదురు ఆఇ లోకుర్‌ వెట యా పట్నమ్‌దు కూడిఃత ‌మహార్‌. వారు నీను ఏర్‌పాటు కిత్తి పాపం సిల్లి నీ సేవ కినికాన్ ‌ఆతి యేసుఙ్‌ సప్తెఙ్‌ ‌ఒడ్ఃబిజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","దేవుణు, నీ సత్తుదాన్, నీ ఇస్టమ్‌దాన్‌ ఇనిక జర్గినాద్‌లె ఇజి ముందాల్నె నీను ఏర్‌పాటు కిత్తిదొ అయాలెకెండె వారు కిత్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ఏలు ప్రబువా, వారు మఙి బద్రిసిని దన్నిఙ్ ‌సుడ్ఃఅ. మీ సేవ కినికార్‌ ‌ఆతి మాపు నండొ దయ్‌రమ్‌దాన్‌ ‌నీ మాటెఙ్‌ బోదిస్తెఙ్‌ మఙి సత్తు సిదా. ");
INSERT INTO kfc_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","కస్టమ్‌కు మన్ని వరిఙ్ ‌నెగెండ్‌ ‌కిజి మీ సత్తు తోరిస్‌అ. మీ బాణిఙ్‌ వాతి నమ్మిదెఙ్‌ తగ్నికాన్‌ ఆతి మీ సేవ కినికాన్‌ ఆతి యేసు పేరుదాన్‌ గొప్ప బమ్మాతి పణిఙ్ బ‍మ్మాతి గుర్తుఙ్‌ ‌కిఅ”. ");
INSERT INTO kfc_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","వారు పార్దనం కిత్తి వెనుక వారు కూడ్ఃజి మహి బాడ్డి కద్లితాద్. అయావలె దేవుణు ఆత్మ సత్తు వరి ముస్కు వాతాద్. వారు దయ్‌రమ్‌దాన్‌ దేవుణు మాటెఙ్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","నమ్మితికార్‌ విజేరె ఉండ్రె మన్సు ఆజి ఎయెన్‌బా సరినె వన్నిఙ్ మన్నిదన్ని - బాణిఙ్ ఇనికబా నాదినె ఇజి ఆఏద్‌ ఇజి వరిఙ్‌ మన్నిక విజెరె వందిఙ్‌ కర్సు కిత్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","దేవుణు సత్తుదాన్ బమ్మాతి పణిఙ్‌ కిజి అపొస్తురు ప్రబు ఆతి యేసు, సాతివరి - బాణిఙ్‌ మర్‌జి బత్కితాన్‌ ఇజి సాసి వెహ్సి మహార్‌. దేవుణు ద‍యాదర్మం వరి ముస్కు నండొ మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","బూమిఙ్‌ ఇల్కు కల్గితి మహికార్‌ విజేరె అక్కెఙ్‌ పొర్సి కల్గితి డబ్బు అపొస్తురు డగ్రు తతార్. విజేరిఙ్‌ వరివరి అవ్‌సరం సుడ్ఃజి సీబాజి సితార్. అందెఙె వరి లొఇ ఎయెన్‌బా సరి అవ్‌సరం వాతిఙ తక్కు సిల్లెండ ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","కుప్ర దేసమ్‌దు పుట్తి లేవి కుటుమ్‌దికాన్‌ ఆతి యోసేపు ఇని ఒరెన్‌ మహాన్‌. వన్నిఙ్‌ అపొస్తురు బర్నబ ఇజి కూక్సి మహార్‌. (వన్ని పేరు అర్దం ఇనిక ఇహిఙ సాయం కినికాన్‌ ఇజి) ");
INSERT INTO kfc_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","వాండ్రు వన్నిఙ్ మహి బూమి ఉండ్రి పొర్సి అయ డబ్బు అపొస్తురు డగ్రు తతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","అయావలె అననియ ఇని ఒరెన్‌ మహాన్‌. వన్ని ఆల్సి పేరు సపీర. వారుబా ఉండ్రి బూమి పొర్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","పొర్తారె మాసి సెగం ఇట్తాండ్రె మిగ్లితి డబ్బు అపొస్తురు డగ్రు ఒతాన్. యాక విజు ఆల్సిబా నెస్తాద్. ");
INSERT INTO kfc_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","అయావలె పేతురు అననియెఙ్, “నీ బూమి పొర్తి డబ్బుఙాణి సెగం డాఃప్తి దేవుణు ఆత్మదిఙ్‌ ఎందనిఙ్‌ మొసెం కిత్తి? నన్ని మొసెం పణి కిదెఙ్‌ నీను ఎందనిఙ్‌ నీ మన్సుదిఙ్‌ సయ్తానుఙ్ ఒపజెప్తి? ");
INSERT INTO kfc_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","బూమి నీ బాన్‌ మహివలె నీదినెగదె. అక్క పొర్తివలెబా ఆ డబ్బు నీ సొంతనె గదె. నిన్ని పణి కిదెఙ్‌ ఎందనిఙ్‌ నీ మన్సుదు ఒడిఃబిత్తి? నీను లోకు వెట ఆఏద్‌, దేవుణు వెటనె అబద్దం వర్గితి”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","అననియ యా మాటెఙ్‌ వెహివెటనె అర్తాండ్రె పాణం డిఃస్తాన్. యాక వెహికార్‌ విజేరె తియెల్‌ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","దఙ్‌డాఃయెర్‌ వాతారె పీనుగుదిఙ్ ‌పాతెఙ్ ‌సుటిస్తారె, పిండిజి ఒతారె ముస్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","రమరమి మూండ్రి గంటెఙ్ ‌వెన్కా వన్ని ఆల్సి జర్గితిక నెస్‌ఏండ లొఇ వాతాద్. ");
INSERT INTO kfc_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","పేతురు దన్ని వెట, “మీరు యా బూమి నిస్సొ డబ్బుదిఙె పొర్తిదెరా, వెహ్‌అ”, ఇహాన్‌. వెన్‌బాతిఙ్‌ ‌అది, “నిస్సొదిఙె పొర్తాప్”, ఇహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","పేతురు దన్ని వెట, “మీరు రిఇదెర్‌ కూడ్ఃజి దేవుణు ఆత్మదిఙ్‌ ‌తప్పు వెహ్తిదెర్. దేవుణు ఆత్మదిఙ్‌ తప్పు వెహ్సి మొసెం కిదెఙ్ మీరు ఎందనిఙ్‌ ఒడిఃబిత్తిదెర్‌? ఇదిలో నీ మాసిఙ్‌ ముస్తికార్‌ ఇబ్బె మనార్. వారు నిఙిబా పిండిజి ఒనార్లె”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","వెటనె అది పేతురు పాదం డగ్రు అర్తాదె పాణం డిఃస్తాద్. అయ దఙ్‌డాఃయెర్‌ లొఇ వాతారె అది సాతాద్‌ ఇజి సుడ్ఃతారె దన్నిఙ్ ‌పిండిత ఒతార్. ఒతారె మాసి డగ్రు ముస్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","దేవుణు సఙమ్‌దు మహికార్‌ విజేరె, యా మాటెఙ్‌ వెహికార్‌ విజేరె గొప్ప తియెల్‌ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","అపొస్తురు లోకుర్‌ నడిఃమి నండొ బమ్మాతి పణిఙ్ బమ్మాతి గుర్తుఙ్‌ ‌కిత్తార్‌. నమ్మితికార్‌ విజేరె ఉండ్రె మన్సు ఆజి దేవుణు గుడిఃదు మన్ని సొలొమోను అరుఙు ఇని బాడ్డిదు కూడ్ఃజి వాజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","‘యా నమ్మితికార్ ‌ఎస్సొనొ నెగ్గికార్‌’ ఇజి లోకుర్ ‌వెహ్తార్‌. అహిఙ్‌బా మరి ఎయెర్‌బా నమ్మిత్తికార్‌ వెట కూడ్ఃదెఙ్‌ తియెల్‌ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","గాని నండొ లోకుర్, మొగ్గకొడొఃర్, అయ్‌లికొడొఃక్‌ యేసుఙ్‌ నమ్మిత్తారె నమ్మిత్తి వరివెట కూడిఃతార్. ");
INSERT INTO kfc_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","అందెఙె అపొస్తురు కిత్తి గొప్ప పణిఙ్‌ సుడ్ఃతారె కస్టం మన్ని వరిఙ్‌ సాప ముస్కు మన్సమ్‌ ముస్కు పేతురు నడిఃజి వాని సరిపడఃకాదు తతార్. ఎందనిఙ్‌ ‌ఇహిఙ పేతురు అయ సరి వానివలె వన్ని నీడఃబా తాక్తిఙ నెగెండ ‌ఆనార్‌ ‌ఇజి. ");
INSERT INTO kfc_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","యెరూసలేమ్‌దు సురుల మన్ని నాహ్కణిఙ్‌బా నండొ లోకుర్ ‌బాన్‌ వాతార్. వరి లొఇ కస్టమ్‌కు ఆతివరిఙ్, దెయమ్‌ కాణిఙ్ మాలెఙ్ ఆతివరిఙ్ ‌అబె తసి మహార్‌. విజేరె నెగెండ ‌ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","నస్తివలె విజేరె పుజేరిఙ ముస్కు పెరి పుజేరి, వన్ని వెట కూడిఃతి మహికార్‌ విజేరె, ఇహిఙ, సదుకెయరు ఇని పార్టి లొఇ సెగొండార్‌ అపొస్తురు వెట గొప్ప గోస ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","వారు అపొస్తురుఙ్‌ అస్తారె పట్నమ్‌దు మన్ని జెలిదు ఇట్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","గాని దేవుణు దూత పొదొయ్‌ వాతండ్రె జెలిది సేహ్లెఙ్‌ రేతాండ్రె వరిఙ్ ‌వెల్లి తతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","వెల్లి తతాండ్రె దూత, “మీరు దేవుణు గుడిః డేవాదు సొన్సి లోకాఙ్‌ విజెరిఙ్‌ యా కొత్త్తబత్కువందిఙ్‌ పూర్తి వెహ్తు” ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","వారు జాయ్‌ ‌ఆని డగ్రు దేవుణు గుడిః డేవాదు సొహరె దూత వెహ్తి వజ లోకాఙ్‌ ‌బోదిస్తెఙ్ ‌మొదొల్‌స్తార్. వెనుక, విజేరె పుజేరిఙ ముస్కు పెరి పుజేరి, వన్నివెట మహికార్‌ వాతారె సన్‌హద్రి సఙమ్‌దు మహి యూదపెద్దెలుఙ విజేరిఙ్‌ కూక్సి మీటిఙ్‌ ‌కిత్తార్‌. మీటిఙ్‌దు కూడిఃతారె జెలిదు మన్ని అపొస్తురుఙ్‌ ‌వరిబాన్ ‌తత్తెఙ్‌ జమాన్‌ఙ ‌పోక్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","23","గాని వారు జెలిదు సొన్సి సుడ్ఃతిఙ్‌ పేతురుని యోహాను లొఇ ‌సిల్లెర్. వారు మహ్త వాతారె వెహ్తార్‌, “మాపు సొన్సి సుడ్ఃతిఙ్‌ ‌జేలిదు సేహ్లెఙ్‌ తాలం అర్‌ప్తె మహె, కాప్‌ కినికార్ ‌సేహ్లెఙ ‌ముందాల్‌నె నిహ మహార్‌. గాని మాప్‌ సొన్సి సేహ్లెఙ్‌ రేనివలె లొఇ వారు సిల్లెర్”. ");
INSERT INTO kfc_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","వీరు వెహ్తిక వెహరె పెరి పుజేరిఙు, దేవుణు గుడిఃది జమాన్‌ఙ అతికారి గొప్ప బమ్మ ఆతారె, ‘ఇక ఇనిక ఆనాద్‌లెనొ’ ఇజి ఒడిఃబితార్. ");
INSERT INTO kfc_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","అయావలె ఒరెన్‌ వాతండ్రె, “ఇదిలో మీరు జెలిదు ఇడ్తిమహి లోకుర్‌ ఏలు దేవుణు గుడిఃదు నిహరె లోకాఙ్‌ బోదిసినార్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","వెహ్తిఙ్, అతికారి జమానుఙ వెట సొహాండ్రె అపొస్తురుఙ్‌ కూక్త తతార్. ‘లోకు మఙి పణుకుఙాణిఙ్‌ డెఃయ్‌నార్‌లెసు’ ఇజి తియెల్‌ ‌ఆతారె అపొస్తురుఙ్‌ ఒపిసి కూక్త తతార్. ");
INSERT INTO kfc_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","వరిఙ్‌ కూక్త తత్తారె సన్‌హద్రిం సఙం నడిఃమి నిల్‌ప్తార్. నిల్‌ప్తారె విజేరె పుజేరిఙ ముస్కు పెరి పుజేరి వరివెట వెన్‌బాతాన్‌: ");
INSERT INTO kfc_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“యా యేసు పేరు అసి బోదిన్మాట్’ ‌ఇజి మాపు మిఙి డటం బెద్రిసి వెహ్తాప్‌గదె. గాని మీరు యెరూసలేమ్‌దు విజు మీ బోద సాట్తిదెర్. సాతి వన్ని వందిఙ్‌ మాప్ వన్నిఙ్ ‌సప్తాప్ ‌ఇజి మీరు మా ముస్కు తప్పు ఇడ్ఃదెఙ్‌ సుడ్ః‌జినిదెర్”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","దన్నిఙ్‌ పేతురు మరి అపొస్తురు, “లోకాఙ్‌ ‌ఆఏద్‌, దేవుణుదిఙె మాపు లొఙిదెఙ్‌ గదె? ");
INSERT INTO kfc_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","మీరు యేసుఙ్‌ సిలువాదు డెఃయ్‌జి సప్తిదెర్. గాని మా అనిగొగొరి వలెహన్ ‌అసి మన్ని దేవుణు, వన్నిఙ్‌ సాతి వరి బాణిఙ్ ‌నిక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","యా యేసుఙ్‌ రాజు మరిసి వజ, విజెరిఙ్‌ ‌రక్సిసిని వన్ని వజ దేవుణు ‌గొప్ప మర్యాద సితండ్రె వన్ని ఉణెర్‌ పడఃకాదు బస్‌పిస్తాన్. ఎందనిఙ్‌ ఇహిఙ ఇస్రాయేలు లోకుర్ వరి పాపమ్‌కు డిఃసి దేవుణుదిఙ్‌ లొఙిదెఙ్. వరి పాపమ్‌కు నొరె ఆదెఙ్‌ సరి సీదెఙ్‌ ఇజి ‌దేవుణు వన్ని ఉణెర్‌ ‌పడఃకాదు యేసుఙ్‌ బస్‌పిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","యా సఙతిఙ వందిఙ్‌ మాపు సాసిర్. దేవుణుదిఙ్‌ లొఙిని వరిఙ్ ‌దేవుణు సీని వన్ని ఆత్మబా యా సఙతిఙ వందిఙ్‌ సాసి”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","అపొస్తురు వెహ్తిక వెంజి విజేరె పుజేరిఙ ముస్కు పెరి పుజేరి, వన్నివెట మహికార్‌ ‌కోపం ఆతారె ‘వరిఙ్ ‌సప్నాప్’ ‌ఇజి ఒడిఃబితార్. ");
INSERT INTO kfc_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","అయావలె సఙమ్‌దు మహి పరిసయ్‌రు లొఇ ఒరెన్ ‌గమాలియేలు ఇనికాన్‌ ‌సన్‌హద్రిం సఙమ్‌దు నిహండ్రె వెహ్తాన్‌, “వీరు సణెం సఙమ్‌దాన్‌ వెల్లినె మనీర్”. గమాలియేలు ఎయెన్‌ ‌ఇహిఙ యూదురి రూలుఙ్‌ నెస్పిసిని వరిలొఇ ఒరెన్. లోకుర్‌ విజేరె వన్నిఙ్‌ మర్యాద సీజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","అపొస్తురుఙ్‌ వెల్లి పోక్తారె గమాలియేలు సఙమ్‌ది లోకాఙ్‌ ఈహు వెహ్తాన్‌, “ఇస్రాయేలు లోకాండె, యా లోకాఙ్‌ మీరు ఇనిక కిదెఙ్ ‌ఇజి ఒడిఃబిజినిదెరొ జాగర్త మండ్రు. ");
INSERT INTO kfc_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","సెగం పంటెఙ్‌ ముందాల దూద ఇనికాన్‌ ఒరెన్ నిఙితండ్రె నాను గొప్పవాండ్రు ఇజి వెహ్తాన్‌. రమరమి నాల్గి వందెఙ్‌ లోకుర్ ‌వన్నివెట కూడిఃతార్. ఎయెరొ వన్నిఙ్ ‌సప్తార్. వన్నివెట కూడిఃతి మహికార్‌ విజేరె సెద్రితారె వరి పణి ఇని దన్నిఙ్ ‌రెఏండాతా సొహాద్. ");
INSERT INTO kfc_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","వెనుక, లోకుర్‌ లెక్క సుడ్ఃని జనాబా దినమ్‌కాఙ్‌ ‌గలీలయ వాండ్రు ఆతి యూద ఇనికాన్‌ ఒరెన్ ‌నిఙిత్తాన్. మంద లోకుర్‌ వన్నివెట కూడిఃతారె వారు ఏలుబడిః కినివరి ముస్కు ఎద్రిస్తార్. వన్నిఙ్‌బా ఎయెరొ సప్తార్. వన్నివెట కూడిఃతి మహికార్‌ విజేరె సెద్రిత సొహార్. ");
INSERT INTO kfc_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","అందెఙె, నాను ఇనిక వెహ్సిన ఇహిఙ, విరిఙ్ ‌ఇనికబా కిమాట్. విరిఙ్‌ డిఃసిసిఅ. ఎందనిఙ్‌ ‌ఇహిఙ విరి ఆలోసనమ్‌కు, విరి పణిఙు లోకువలెహాన్ ‌వాతిక ఇహిఙ అది ఇనిదన్ని పణిదిఙ్‌ ‌రెఏండాన సొనాద్. ");
INSERT INTO kfc_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","గాని ఇక్క దేవుణు బాణిఙ్‌ వాతిక ఇహిఙ విరిఙ్‌ అడ్డు కిదెఙ్ ‌మీరు అట్‌ఇదెర్. అక్కాదె ఆఏండ మీరు దేవుణు వెట టంటెఙ్ ‌ఆతికార్ ‌ఇజి మిఙి తెలినాద్”. ");
INSERT INTO kfc_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","సఙమ్‌దికార్‌ గమాలియేలు వెహ్తి మాటదిఙ్‌ ‌ఒపుకొటార్. వారు అపొస్తురుఙ్‌ ‌కూక్‌పిసి వరిఙ్‌ కొరెడెఃదాన్‌ డెఃయ్‌బిసి యేసు పేరు అసి ఎసెఙ్‌బా బోదిస్మాట్‌ ఇజి డటం వెహ్సి వరిఙ్ ‌డిఃస్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","యేసు పేరు వందిఙ్ ‌మాలెఙ్ ఓరిస్తెఙ్‌ తగితికార్‌ ఆతి వందిఙ్‌ అపొస్తురు డెఃయ్‌తి దెబ్బ తిహిఙ్‌బా సర్ద ఆజి అబెణిఙ్‌ సొహార్. ");
INSERT INTO kfc_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","రోజు అపొస్తురు దేవుణు గుడిః డేవాదు, లోకురి ఇల్‌కాఙ్‌ బోదిసి మహార్‌. యేసు దేవుణు పోక్తి క్రీస్తునె ఇజి నెగ్గిమాట వారు తప్‌ఏండ బోదిసి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","యేసుప్రబుఙ్‌ నమ్మితికార్ ‌ఆ కాలమ్‌దు నండొ లోకుర్‌ ఆజి వాతార్. అయావలె ముండ మణిసిరిఙ్ ‌బోజనం సీని దన్నిలొఇ, మా ముండ మణిసిరిఙ్‌ బోజనం సిఏర్ ‌ఇజి గ్రీకు బాస వర్గిని యూదురు ఏబ్రి బాస వర్గిని యూదురు ముస్కు మొరొ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","అయావలె పన్నెండు మణిసిర్‌ అపొస్తురు నమ్మితి వరిఙ్ ‌విజెరిఙ్‌ కూక్తరె వెహ్తార్‌, “మాపు బోజనం సీబాజి సీని వందిఙ్ ‌దేవుణు మాట నెస్పిస్తెఙ్ ‌డిఃసి సీనిక తగిఏద్. ");
INSERT INTO kfc_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","తంబెరిఙాండె, అందెఙె ఏడుగురు మొగ వరిఙ్‌‌ ఏర్‌పాటు కిదు. మీ లొఇ దేవుణు ఆత్మ నిండ్రితి మన్ని, గెణం నిండ్రితి మన్ని విజేరె ఒపుకొటి మని ఏడుగురు మొగ్గ వరిఙ్‌ ‌ఏర్‌పాటు కిదు, మాపు వరిఙ్ ‌యా పణి ఒపజెప్నాప్. ");
INSERT INTO kfc_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","అహిఙ మాపు పార్దనం కిదెఙ్, దేవుణు - మాట నెస్పిస్తెఙ్‌ కేట మంజినాప్”, ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","6","అపొస్తురి మాటెఙ్‌ అబ్బె కూడిఃతి మహి లోకాఙ్‌ విజెరిఙ్‌ ‌ఇస్టం ఆతాద్. అందెఙె దేవుణు ముస్కు పూర్తి నమకం ఇడ్ఃజి దేవుణు ఆత్మ సత్తు పూర్తి నిండ్రితి మహి స్తెపాను, పిలిపు, ప్రొకొరు, నికనొరు, తిమొను, పర్మనసు, యూద మతమ్‌దు కూడిఃతి అంతియొకియ దేసెమ్‌దికాన్‌ ‌నికొలాసు ఇని ఏడుగురు మొగవరిఙ్, నమ్మితికార్‌ ‌అపొస్తురి ముందాల తతార్. అపొస్తురు పార్దనం కితారె వరి ముస్కు కిక్కు ఇడ్ఃజి వరిఙ్ అయా ‍పణి కిదెఙ్ ‌అతికారం సితార్. ");
INSERT INTO kfc_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","అందెఙె మరి నండొ లోకుర్‌ దేవుణు మాటెఙ్‌ నమ్మితార్. యెరూసలేమ్‌దు మన్ని నమ్మితి వరి లెక్క నండొ ఆజి వాతాద్. నండొండార్‌ పుజేరిఙు యేసుప్రబు ముస్కు నమకం ఇట్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","వరి లొఇ ఒరెన్, స్తెపాను ఇనికాన్, దేవుణు దయదర్మమ్‌దాన్ దేవుణు ఆత్మ సత్తుదాన్ నిండ్రితాండ్రె లోకుర్‌ నడిఃమి గొప్ప బమ్మాని పణిఙ్ ‌బమ్మాని గుర్తుఙ్‌ కిజి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","గాని, కురెనియ పట్నమ్‌దికార్‌ యూదురు, అలెక్సంత్రియు పట్నమ్‌దికార్‌ యూదురు, (వీరు లిబెర్తి ఇని యూదురు మీటిఙ్‌ ఇండ్రొణి గుంపుదికార్‌) మరి కిలికియ దేసమ్‌దాన్ ‌వాతి యూదురు, ఆసియ దేసమ్‌దాన్ ‌వాతి ‌యూదురు వాతారె స్తెపాను వెట తర్కిస్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","గాని వాండ్రు వెహ్తి మాటెఙ ‌ఎద్రిస్తెఙ్ ‌వారు అట్‌ఎండాతార్. ఎందనిఙ్‌ ఇహిఙ దేవుణు బాణిఙ్‌ వాతి గెణమ్‌దాన్, దేవుణు ఆత్మ సత్తుదాన్‌ స్తెపాను వరివెట వర్గితాన్. ");
INSERT INTO kfc_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","అయావలె వారు, ‘వీండ్రు మోసె ముస్కు, దేవుణు ముస్కు దూసిసిని మాటెఙ్‌ వర్గినిక మాప్‌ వెహాప్‌’ ఇజి వెహ్తెఙ్‌ సెగొండార్‌ లోకాఙ్‌ ఎయెర్‌ నెస్ఏండ సుత్రిస్తారె కూడుఃప్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","కూడుఃప్తారె, లోకాఙ్, పెద్దెల్‌ఙ, యూదురి రూలు నెస్పిసినికార్‌ విజెరిఙ్‌ ‌రేప్తారె వన్ని ముస్కు వాతార్. వాతారె స్తెపానుఙ్‌ అస్తారె యూద పెద్దెల్‌ఙ సన్‌హద్రిం ఇని పెరి సఙమ్‌దు తతార్. బానె అబద్దం సాసి వెహ్ని వరిఙ్‌ నిల్‌ప్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","వారు ‌ఈహు వెహ్తార్‌, “వీండ్రు ఎస్తివలెబా దేవుణుదిఙ్‌ కేట కిత్తి యా దేవుణు గుడిఃదిఙ్, మోసె సిత్తి రూలుఙ ‌వెత్రేకం వర్గిజినాన్. ");
INSERT INTO kfc_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","యా నజరేతు వాండ్రు ఆతి యేసు యా దేవుణు గుడిః పాడు కినాన్, మాటు ఎలాగ నడిఃదెఙ్‌ ఇజి మోసె మా అనిగొగొరిఙ్‌ సిత్తి మాటెఙ్‌ మారిస్నాన్ ‌ఇజి వీండ్రు వెహ్తిక మాపు వెహాప్”. ");
INSERT INTO kfc_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","సన్‌హద్రిం సఙమ్‌దికార్‌ స్తెపాను మొకొం డిటం ‌సుడ్ఃజి మహిఙ్ వన్ని మొకొం దేవుణు దూత మొకొం లెకెండ్‌ జాయ్‌ తోర్నిక వారు సుడ్ఃతార్. ");
INSERT INTO kfc_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","అయావలె విజేరె పుజేరిఙ ముస్కు పెరి పుజేరి స్తెపానుఙ్‌ వెన్‌బాతాన్, “యా మాటెఙ్‌ ‌నిజమా? వీరు వెహ్తి లెకెండ్‌ నీను వెహ్తిదా సిల్లెదా?”. ");
INSERT INTO kfc_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","దన్నిఙ్‌ స్తెపాను వెహ్తిక ఇనిక ఇహిఙ, “తంబెరిఙాండె, బుబ్బరాండె, వెండ్రు, మా అనిగొగొ ఆతి అబ్రాహాం ఆరోను ఇని పట్నమ్‌దు బత్కిఎండ ముందాల, మెసొపొతెమియ ఇని దేసమ్‌దు బత్కిజి మహాన్‌. అయావలె నండొ జాయ్‌ మన్ని దేవుణు వన్నిఙ్ ‌తోరె ఆతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","దేవుణు అబ్రాహాం వెట ఈహు వెహ్తాన్‌, ‘నీను నీ దేసెం డిఃసి, నీ సొంత లోకాఙ్‌ ‌డిఃసి నాను నిఙి తోరిసిని దేసెం సొన్‌అ'. ");
INSERT INTO kfc_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","అయావలె వాండ్రు కల్దియుఙ్‌ బత్కితి మహి మెసొపొతెమియ దేసెం డిఃసి ఆరోను పట్నమ్‌దు సొన్సి బత్కితాన్. వన్ని బుబ్బ సాతి వెనుక అబెణిఙ్ ‌మీరు ఏలు బత్కిజిని యా దేసమ్‌దు బత్కిదెఙ్‌ ‌దేవుణు వన్నిఙ్ ‌కూక్త తతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","అయావలె దేవుణు వన్నిఙ్ ‌ఉండ్రి ముక బూమిబా అక్కు సిఏతాన్, యా దేసమ్‌దు. గాని అయావలె అబ్రాహాముఙ్‌ కొడొఃర్‌ సిల్లితిఙ్‌బా దేవుణు వన్ని వెట ఉండ్రి మాట సిత్తాన్‌. అక్క ఇనిక ఇహిఙ, ‘నిఙి, నీ పొటెఙాణి వరిఙ్ విజెరిఙ్‌ ‌యా బూమి ఆనాద్’. ");
INSERT INTO kfc_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","దేవుణు వన్ని వెట, ‘నీ పొటెఙాణికార్ ‌ఆఇ దేసమ్‌దు సొనారె బానె ఆఇకార్‌ లెకెండ్ ‌మనార్. అయ దేసెమ్‌దికార్ ‌నీ లోకాఙ్‌ నాల్గి వందెఙ్ ‌పంటెఙ్ ‌వెట్టిపణి కిజిని వరిలెకెండ్ ‌పణి కిబిసి వరిఙ్‌ లొఙిజి మంజిని వజ ఇడ్ఃజి మాలెఙ్ ‌కినార్’. ");
INSERT INTO kfc_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","గాని వారు ఎమేణి దేసమ్‌దు పణి కిజినారొ అయ దేసెమ్‌ది వరిఙ్ ‌నాను తీర్‌పు తీరిసి సిస‍ సీనాలె. వెనుక వారు ఆ దేసెం డిఃసి వాజి యా బాడ్డిదు మంజి నఙి పొగ్‌డిఃజి మాడిఃస్నార్లె ఇజి వెహ్త మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","దేవుణు అబ్రాహాం వెట ‘విజెరి కుటుమ్‌కాఙ్‌ పుట్తి మొగ్గ కొడొఃరిఙ్‌ సున‍తి కిదెఙ్‌ వలె’, ఇజి వెహ్తాన్‌. అందెఙె అబ్రాహాం, వన్ని మరిసి ఇస్సాకు పుట్తి ఏడు రోస్కు వెనుక మహ్స నాండిఙ్, ఇహిఙ, ఎనిమిది రోస్కాఙ్‌ సునతి కిత్తాన్‌. ఇస్సాకు, వన్ని మరిసి యాకోబుఙ్‌ ‌సునతి కిత్తాన్‌. యాకోబు వన్ని పన్నెండు మంది మరిసిరిఙ్‌ సునతి కిత్తాన్‌. యా పనెండు మందినె ఇస్రాయేలుది పనెండు కుటుమ్‌ది అనిగొగొర్‌ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","10","యా పన్నెండు మంది అనిగొగొర్‌ వరి లొఇ తంబెరి ‌ఆతి యోసేపు ముస్కు గోస ఆతారె వన్నిఙ్‌ గొత్తి పణి కిదెఙ్‌ పొర్తార్. ఆహె యోసేపు అయ్‌గుప్తు దేసమ్‌దు గొత్తి పణి కిత్తాన్‌. గాని దేవుణు వన్ని వెట మహండ్రె వన్నిఙ్ వాతి విజు మాలెఙాణిఙ్ తప్రిస్తాన్. దేవుణు వన్నిఙ్‌ గెణం సిత్తిఙ్ అయ్‌గుప్తు రాజు ఆతి పరొ యోసేపు ముస్కు దయ తోరిస్తాన్. పరొ రాజు యోసేపుఙ్‌ ‌అయ్‌గుప్తు దేసెమ్‌దిఙ్ నడిఃపిసిని వన్నిలెకెండ్‌ నిల్‌ప్తాన్. పరొ రాజుఙ్‌ కల్గితి మహి విజు వనకాఙ్‌ ముస్కు నడిఃపిసిని వన్నిలెకెండ్‌ కిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","అయావలె అయ్‌గుప్తు దేసమ్‌దు విజు, మా అనిగొగొర్‌ బత్కిజి మహి కనాను దేసమ్‌దు విజు పెరి కరు వాతాద్. కరు వాతిఙ్‌ నండొ మాలెఙ్ ‌వాతె. మా అనిగొగొర్‌ ఆతి వరిఙ్‌ తిండి దొహ్క్‌ఏండ ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","అయావలె, అయ్‌గుప్తు దేసమ్‌దు తిండి మనాద్‌ ఇజి యాకోబు వెహాన్‌. వెహాండ్రె వన్ని మరిసిరిఙ్, ఇహిఙ, మా అనిగొగొరిఙ్‌ ‌ముందాల్నె ఉండ్రి సుటు బాన్‌ పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","వారు మరి ఉండ్రి సుటు సొహిఙ్, యోసేపు, వన్ని దాదారిఙ్ వాండ్రు ఎయెన్‌ ఇజి నెల్వ కిబె ఆతాన్. అయావలె యోసేపు కుటుమ్‌ది వరి వందిఙ్‌ పరొ రాజు నెస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","వెనుక యోసేపు వన్ని బుబ్బ ఆతి యాకోబుఙ్‌ వన్ని సొంత లోకాఙ్‌ విజేరిఙ్‌ అయ్‌గుప్తు దేసమ్‌దు రదు ఇజి కబ్రు పోక్తాన్. వారు మొత్తం డబయ్‌ అయ్‌దుగురు మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","అయావలె యాకోబు, వన్నివెట మహికార్‌ విజేరె అయ్‌గుప్తు దేసెం సొహార్. వారు అబ్బె బత్కిత్తార్. వెనుక యాకోబు, మహి అనిగొగొరు బానె సాతార్. ");
INSERT INTO kfc_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","వెనుక వరి డుముక్‌ సెకెం ఇని పట్నమ్‌దు మర్‌జి తత్తారె, ముందాల అబ్రాహాం హామోరు మరిసిర్‌‌ బాణిఙ్‌ ‌కొటి దూకి లొఇ ముస్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","దేవుణు అబ్రాహముఙ్‌ ముందాల్నె సిత్తి మాట వజ జర్గిదెఙ్‌ డగ్రు ఆజి వాతాద్. అయావలె మా లోకు అయ్‌గుప్తు దేసమ్‌దు నండొ లోకు ఆజి వాతార్. ");
INSERT INTO kfc_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","అయావలె, యోసేపు ఎయెన్‌ ఇజి నెస్‌ఇ ఒరెన్ ‌రాజు అయ్‌గుప్తు దేసెమ్‌దిఙ్ ఏలుబడిః కిదెఙ్ ‌మొదొల్‌స్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","యా రాజు మా లోకాఙ్‌ ‌మాయ మాటెఙ్‌ వెహ్సి మొసెం కిత్తాన్‌. గొప్ప మాలెఙ్ కిత్తాన్‌. మొగ్గకొడొఃర్‌ పుట్తిఙ వరిఙ్‌ సప్తెఙ్‌ వెటనె గడ్డదు విసీర్దెఙ్‌ వలె ఇజి యా రాజు ఆడ్ర సిత్తాన్‌. ఎందనిఙ్‌ ఇహిఙ వారు సాజి సొండ్రెఙ్. ");
INSERT INTO kfc_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ఆ కాలమ్‌దు మోసె ఇనికాన్‌ ఒరెన్ ‌పుట్తాన్. వాండ్రు సుడ్ఃదెఙ్‌ గొప్ప నెగ్గికాన్. వాండ్రు మూండ్రి నెలెఙ్‌ దాక వన్ని బుబ్బ ఇండ్రొ పిరితాన్. ");
INSERT INTO kfc_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","మూండ్రి నెలెఙ్‌ వెనుక వన్నిఙ్‌ ఇండ్రొ వెల్లి సోప్సి గడ్డ ఒడ్డుదు ఇట్తార్. అయావలె పరో రాజు గాల్సి వాతాదె కొడొఃదిఙ్‌ లాగితాదె దన్ని మరిసి లెకెండ్ పోస కిబిస్తాద్. ");
INSERT INTO kfc_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","మోసెఙ్‌ అయ్‌గుప్తు వరి విజు తెలివి నెస్‌పిస్తాన్. వాండ్రు, వ‍ర్గిని మాటెఙ‍ లొఇ బాగ వ‍ర్గిదెఙ్ అట్నాన్. కిని పణిఙ లొఇ నెగ్రెండ కిదెఙ్ అట్నాన్. ");
INSERT INTO kfc_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","మోసెఙ్‌ నలపయ్ ‌పంటెఙ్ ‌ఆతివలె నా సొంత లోకుర్ ‌ఆతి ఇస్రాయేలుర్‌ బానె సొన ఇజి బుద్ది పుట్తాద్. ");
INSERT INTO kfc_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","వాండ్రు సొహిఙ్‌ అయ్‌గుప్తుదికాన్‌ ఒరెన్, ఒరెన్‌ ఇస్రాయేలు వన్నిఙ్ మాలెఙ్ కిజి మహిఙ్‌ ‌సుడ్ఃతాన్. సుడ్ఃతండ్రె, ఇస్రాయేలు వన్నిఙ్ గెల్పిస్తెఙ్ ఇజి అయ్‌గుప్తు వన్నిఙ్ ‌సప్తాన్. ఆహె నాయం తీరిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ఇస్రాయేలు లోకాఙ్‌ వరి బాదెఙాణిఙ్ డిఃబిస్తెఙ్ ‌దేవుణు నఙి పోక్తాన్‌ ‌ఇజి మోసె ఒడిఃబితాన్. గాని వారు అర్దం కిఏతార్. ");
INSERT INTO kfc_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","మహ్స నాండిఙ్‌ మోసె ‌ఇస్రాయేలు లోకాఙ్‌ సుడ్ఃజి సొహాన్‌. ‌రిఎర్ ఇస్రాయేలు లోకుర్‌ ‌టంటెఙ్ ఆజి మహిఙ్‌ ‌మోసె వరిఙ్‌ సుడ్ఃతండ్రె, ‘ఒరె ఒరె బాబు, మీరు తంబెరి రిఇదెర్‌గదె? మీరు ఎందనిఙ్‌ ఒరెన్‌ వన్ని ముస్కు ఒరెన్ ‌టంటెఙ్‌ ఆజినిదెర్’ ‌ఇజి వెహ్తండ్రె వారు రిఎరిఙ్‌ కూడుఃప్తెఙ్‌ ఇజి సుడ్ఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","28","గాని ఆఇ వన్ని ముస్కు అనయం కినికాన్‌ వెహ్తాన్‌, ‘మా ముస్కు అతికారి వజ మండ్రెఙ్, తీర్‌పు తీర్‌స్ని వన్నివజ మండ్రెఙ్‌ నిఙి ఎయెన్‌ ఏర్‌పాటు కిత్తాన్‌? నీను ఇఎన్ ‌అయా అయ్‌గుప్తు వన్నిఙ్‌ సప్తిలెకెండ్ ‌నఙిబా సప్తెఙ్‌ ఇజి సుడ్ఃజినిదా ఇజి వెహ్తండ్రె మోసెఙ్‌ నెక్తపొక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","యాక వెహాండ్రె మోసె తియెల్‌ ‌ఆతాన్. వెటనె అయ్‌గుప్తు దేసెం డిఃసి సొహాన్‌. మిద్యాను ఇని దేసమ్‌దు సొహాండ్రె ఆఇకాన్‌ లెకెండ్ ‌బత్కిత్తాన్. బానె పెండ్లి ఆతండ్రె రిఎర్‌ కొడొఃరిఙ్‌ ఇట్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","నలపయ్ పంటెఙ్‌ వెనుక, సినాయి ఇని పెరి గొరొన్‌ డగ్రు మన్ని బిడిఃమ్‌ బూమిదు మహిఙ్, ఒరెన్ ‌దేవుణు దూత మోసెఙ్‌ తోరె ఆతాన్. యా దూత వెయ్‌జి మహి తుప్పెఙ నడిఃమి ఉండ్రి సిసు కొణ లొఇ తోరె ఆతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","మోసె అక్క సుడ్ఃతిఙ్‌ ‌బమ్మ ఆతాన్. బమ్మ ఆతండ్రె నెగ్రెండ సుడ్ఃదెఙ్‌ తుప్ప డగ్రు సొహాన్‌. డగ్రు సొహిఙ్‌ దేవుణు మాట ఈహు వెహాన్‌, ");
INSERT INTO kfc_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘నాను నీ అనిగొగొర్‌ ఆతి అబ్రాహాం, ఇస్సాకు, యాకోబు ఇని వరి దేవుణు'. యాక వెహాండ్రె మోసె తియెల్‌ ఆజి వణక్తాన్. సుడ్ఃదెఙ్‌బా అట్‌ఏతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","దేవుణు మరి వెహ్తాన్‌, ‘నీ జోడ్కు కుత్సి ఇడ్ఃఅ. నీను నిహిమన్ని బాడ్డి దేవుణుదిఙ్‌ ‌కేట ఆతి బాడ్డి'. ");
INSERT INTO kfc_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","అయ్‌గుప్తు దేసమ్‌దు మన్ని నా లోకాఙ్‌ మాలెఙ్ ‌నాను నెగ్రెండ సుడ్ఃత. వారు అడఃబానిక వెహ. అందెఙె నాను వరిఙ్‌ డిఃబిస్తెఙ్ ‌డిఃగిత వాత. ఏలు రఅ నిఙి నాను అయ్‌గుప్తు దేసెం పోక్న ఇజి వన్నివెట వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","‘మా ముస్కు అతికారి వజ మండ్రెఙ్‌ తగ్గు తెప్నికాన్‌ వజ మండ్రెఙ్ ‌నిఙి ఎయెర్‌ ఏర్‌పాటు కిత్తాన్’ ఇజి వెహ్సి ఇస్రాయేలు లోకుర్, ముందాల నెక్సి పొక్తి యా మోసెఙ్‌నె, దేవుణు అతికారి వజ, తప్రిసినికాన్‌ వజ వరిబాన్‌ పోక్తాన్. వెయ్‌జి మహి తుప్ప లొఇ తోరె ఆతి దేవుణు దూత సాయమ్‌దాన్‌ మోసెఙ్ ‌దేవుణునె పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","అయ్‌గుప్తు దేసమ్‌దు బమ్మ పణిఙ్ ‌కిజి మోసె ఇస్రాయేలురిఙ్‌ తప్రిస్త తతాన్. ఎర్రఙ్‌ సమ్‌దరంబానె, మరి వారు నలపయ్ పంటెఙ్ నడిఃజి సొహిమహి బిడిఃమ్‌ బూమిదుబా మోసె బమ్మాని పణిఙ్ బమ్మాని ‌గుర్తుఙ్ ‌కిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","యా మోసెనె ఇస్రాయేలురు వెట, ‘దేవుణు నఙి పోక్తి లెకెండ్‌ మీబాణిఙె ఒరెన్‌ ప్రవక్తెఙ్‌ మీబాన్‌ పోక్నాన్’, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","బిడిఃమ్‌ బూమిదు సఙం కూడిఃతి మహి ఇస్రాయేలు లోకుర్‌ వెట మహికాన్‌ ‌యా మోసెనె. మా అనిగొగొర్‌ వెట మహికాన్‌ వీండ్రె. సీనాయి గొరొతు దేవుణు దూత విన్నివెటనె వర్గితాన్. మఙి సీదెఙ్‌ ‌దేవుణు బాణిఙ్ ‌ఎల్లకాలం బత్కిని మాటెఙ్‌ తత్తికాన్ ‌వీండ్రె. ");
INSERT INTO kfc_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","గాని యా మోసెఙ్‌ మా అనిగొగొర్‌ లొఙిజి మన్‌ఏండ నెక్తపొక్తార్. మర్‌జి అయ్‌గుప్తు దేసమ్‌దు సొహిఙ నెగ్గెద్‌ ఇజి వారు కోరితార్. ");
INSERT INTO kfc_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","అయ్‌గుప్తు దేసెమ్‌దాన్‌ మఙి కూక్తి తత్తి యా మోసె ఇనిక అతాండ్రొ మఙి తెలిఏద్. అందెఙె మర్‌జి అయ్‌గుప్తు దేసమ్‌దు సొండ్రెఙ్‌ మఙి ముందాల నడిఃదెఙ్‌ దెయమ్‌కు తయార్ ‌కిజి సిదా ఇజి మోసె అన్నసి ఆతి ఆరోను వెట వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","అయావలె వారు ఉండ్రి దూడః లెకెండ్‌ బొమ్మ తయార్‌ కిత్తరె పూజ కిత్తార్‌. వరి కిక్కాణిఙ్‌ ‌తయార్‌ కిత్తి దన్నిముస్కు వారు నండొ సర్ద ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","గాని దేవుణు కోపం ఆతండ్రె మొకొం వెనుక మహ్తాన్. ఆగాసమ్‌దు మన్నికెఙ్ ‌సుడ్ఃదెఙ్, నెల పొద్దు సుక్కెఙ్ విజు దన్నిఙ్ ‌పూజ కిదెఙ్‌ వరిఙ్ ‌డిఃస్త సిత్తాన్‌. ప్రవక్తరు ముందాల్నె రాస్తిమహిక దిని వందిఙె. అక్క ఇనిక ఇహిఙ “ఇస్రాయేలు లోకాండె, మీరు బిడిఃమ్‌ బూమిదు ‌నల్‌పయ్ ‌పంటెఙ్ ‌నడిఃసి సొన్సి మహివలె పూజ కిత్తిక నఙినె ఆఏద్‌. ");
INSERT INTO kfc_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","మీరు పూజ కినాట్‌ ఇజి తయార్ ‌కిత్తి మొలూకు రొంపయు ఇని సుక్కెఙాణి దెయమ్‌కాఙె గూడాఃరమ్‌దు పిండిజి ఒసి మహిదెర్. వనకాఙె పూజ కిత్తిదెర్. అందెఙె బబులోను దేసెం అతాల్‌ మిఙి తొహ్సి ఒతెఙ్‌ నాను సరి సీనాలె. ");
INSERT INTO kfc_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","మా అనిగొగొర్‌ బిడిఃమ్‌ బూమిదు సొన్సి మహివలె సాసి గూడారం వరివెట మహాద్‌. దేవుణు మోసెఙ్‌ తోరిస్తి లెకెండె మోసె యా సాసి గూడారం తయార్ ‌కిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","మరి లావు పంటెఙ్‌ వెనుక యెహొసువ ఇనికాన్‌ అయ టయమ్‌దు యా సాసి గుడారం పిండిత ఒతండ్రె మా అనిగొగొరిఙ్‌ ‌నడిఃపిస్తాన్. అయావలె ఇస్రాయేలు లోకాఙ్‌ సీనా ఇజి దేవుణు వెహ్తి దేసమ్‌దు వారు సొహార్. దేవుణు వరివెట మహిఙ్‌ బానె మహి యూదురు ఆఇ లోకుర్‌ వెట ఉద్దం కితారె, గెల్‌స్తారె ఆ దేసెం సొంతం కిత్తార్‌. బానెబా మా అనిగొగొర్‌ యా సాసి గూడారం పిండిత ఒతార్. దావీదురాజు వరిఙ్ ఏలుబడిః కిత్తి కాలమ్‌దాక యా సాసి గూడారం బానె మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","దావీదురాజు ఇహిఙ దేవుణు వెహ్తి వజ నడిఃతికాన్. దేవుణు దయ వన్ని ముస్కు లావు మహాద్‌. అహిఙ్‌బా మా అనిగొగొ ఆతి యాకోబు పార్దనం కిత్తి యా దేవుణుదిఙ్‌ ఎలాకాలం మండ్రెఙ్‌ ఉండ్రి గుడిః తొహ్తెఙ్‌ ‌దావీదు రాజు వెన్‌బాతిఙ్‌బా దేవుణు సరి సిఏతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","గాని దావీదురాజు మరిసి ఆతి సొలోమొనుఙ్‌నె దేవుణు గుడిః తొహ్తెఙ్‌ సరి సిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","అహిఙ్‌బా విజెరిఙ్‌ ఇంక గొప్ప పెరి దేవుణు, లోకు కిక్కాణిఙ్‌ ‌తయార్ ‌కిత్తి బాడ్డిదు మన్‌ఏన్. ");
INSERT INTO kfc_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","దేవుణు మాటెఙ్‌ ప్రవక్త ఈహు వెహ్సినాన్‌: “పరలోకం నాను బసిని సిమసనం. బూమి నా పాదమ్‌కు ఇడ్ని పీట. నాను మండ్రెఙ్ ‌ఉండ్రి గుడిః తొహ్తెఙ్‌ ‌మీరు అట్‌ఇదెర్. ");
INSERT INTO kfc_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ఎందనిఙ్‌ ఇహిఙ, పరలోకం, బూమి, దన్ని లొఇ మన్నికెఙ్ విజు నానె పుటిస్త”. ");
INSERT INTO kfc_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","మూర్కం బుద్ది మన్నికిదెరా, దేవుణు మాటెఙ్‌ ఒప్పుకొటాప్ ‌ఇజి మీరు సునతి కిత్తిదెర్‌ గాని దేవుణు మాటెఙ్‌ గిబ్బిఙాణి వెంజిబా సరినె వెన్‌ఇ లెకెండ్ ‌మంజినిదెర్. వెహిఙ్‌బా సరినె మన్సుదు ఇడ్ఃఏండ లొఙిఇదెర్. మీ అనిగొగొర్‌ లెకెండ్‌ మీరుబా ఎసెఙ్‌బా సరినె దేవుణు ఆత్మదిఙ్‌ ‌నెక్సిపొక్సినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","మీ అనిగొగొర్‌ ప్రవక్తరిఙ్‌ విజెరిఙ్‌ ‌గొప్ప మాలెఙ్ కిత్తార్‌. దేవుణు పోక్న ఇజి వెహ్తి ఆ నీతి వాండ్రు వందిఙ్‌ ముందాల్నె వెహ్తి ప్రవక్తరిఙ్‌బా మీ అనిగొగొర్‌ సప్తార్. ఏలు ఆ నీతి వన్నిఙ్ ‌మీరు ఒపజెప్తిదెర్. వన్నిఙ్‌ సప్తిదెర్. ");
INSERT INTO kfc_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","దేవుణు వన్ని దూతవెట మిఙి సిత్తి రూలుఙ్‌ మిఙి దొహ్‌క్తె గాని మీరు దన్నిఙ్‌ లొఙిఇతిదెర్”. ");
INSERT INTO kfc_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","యా మాటెఙ్‌ ‌వెహరె వారు గొప్ప కోపం ఆతారె స్తెపానుఙ్‌ ‌సుడ్ఃజి పల్కు కొహ్‌క్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","గాని స్తెపాను దేవుణు ఆత్మ సత్తు పూర్తి నిండ్రిజి ఆగాసం దరోట్‌ సుడ్ఃతాన్. సుడ్ఃతిఙ్‌ దేవుణు గొప్ప జాయ్‌ సుడ్ఃతాన్. యేసుప్రబు దేవుణు ఉణెర్‌ పడఃక నిహి మహిక సుడ్ఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“సుడ్ఃఅ, ఆగాసం రే ఆతి మహిక, లోకు మరిసి ఆతి యేసు దేవుణు ఉణెర్‌ పడఃక నిహిమహిక నాను సుడ్ఃజిన”, ఇజి స్తెపాను వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","గాని యా మాటెఙ్‌ వెహరె వెటనె వారు గిబ్బిఙ్ ‌మూకె ఆతారె డటం గగోలాజి విజేరె ఉండ్రె ఆజి వన్ని ముస్కు వాతార్. ");
INSERT INTO kfc_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","పట్నమ్‌దాన్‌ వెల్లి లాగిత ఒతారె వన్నిఙ్‌ పణుకుఙాణ్‌ డెఃయ్‌జి సప్తెఙ్‌ మొదొల్‌స్తార్. పణుకుఙ్ ‌విసీర్‌ని సాసి లోకుర్‌ వరి సొక్కెఙ్‌ ముందాల సవులు ఇని ఒరెన్‌ దఙడాఃయెన్‌ పాదమ్‌కాఙ్‌ డగ్రు తత్తారె ఇట్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","వారు స్తెపానుఙ్‌ పణుకుఙాణిఙ్ ‌డెఃయ్‌జి మహిఙ్‌ ‌స్తెపాను, “యేసుప్రబువా నా పాణమ్‌దిఙ్ ఏలు నీ డగ్రు కూడుఃప్‌అ”, ఇజి పార్దనం కిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","వెనుక స్తెపాను ముణుకుఙ్‌ ‌ఊర్‌జి, “ప్రబువా, వీరు కిజిని యా పాపం విరి ముస్కు మోప్మ”, ఇజి డటం డేల్‌స్తాన్. యా మాట వెహ్తండ్రె వాండ్రు పాణం డిఃస్తాన్. స్తెపానుఙ్‌ సప్తిక సవులు ఒప్పుకొటాన్. ");
INSERT INTO kfc_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ఆ దినమ్‌కాఙ్‌ యెరూసలేమ్‌దు మహి దేవుణు సఙమ్‌దిఙ్‌ ‌గొప్ప మాలెఙ్ ఆజి మహాద్‌. అపొస్తురు ఆఏండ మహి నమ్మితికార్ విజేరె యూదయ సమరియ దేసమ్‌కాఙ్ ‌సెద్రిత సొహార్. ");
INSERT INTO kfc_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","బక్తి కల్గితి నమ్మిత్తి లోకుర్ స్తెపానుఙ్‌ ‌సమాది కితారె వన్ని వందిఙ్‌ గొప్ప దుకం ఆజి అడఃబాతార్. ");
INSERT INTO kfc_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","నస్తివలె సవులు ఇనికాన్‌ యేసుప్రబు ముస్కు నమకం ఇడ్తిమహి వరి నమకం పాడుః కిదెఙ్ ‌సుడ్ఃతాన్. ఇల్కాఙ్‌ ఇల్కాఙ్‌ ‌డుఃగ్‌జి మొగ్గకొడొఃరిఙ్‌ అయ్‌లికొడొఃకాఙ్ ‌ఈడిఃసి ఒసి జెలిదు ఇడ్ఃజి, వాండ్రు సఙమ్‌దిఙ్‌ ‌పాడుః కిదెఙ్ మొదొల్‌స్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","అయావలె సెద్రితి సొహి సఙమ్‌దికార్‌ సువార్త సాటిసి విజు బాడ్డిఙ విజెరిఙ్‌ ‌వెన్‌పిసి బూలాతార్. ");
INSERT INTO kfc_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","అయావలె అపొస్తురు ఏర్‌పాటు కిత్తివరి లొఇ ఒరెన్‌ పిలిపు ఇనికాన్‌ సమరియ పట్నమ్‌దు సొహాన్‌. అబ్బె యేసు, క్రీస్తు ఇజి బోదిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","పిలిపు వెహ్తి మాటెఙ్‌ లోకుర్‌ విజేరె నెగ్రెండ వెహారె వాండ్రు కిత్తి బమ్మాని గుర్తుఙ్‌ సుడ్ఃతార్. ");
INSERT INTO kfc_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","కిక్కు కాల్కు సాతికార్, సొటవారు నండొండార్ ‌అబ్బె వాతారె నెగెండ ‌ఆతార్. నండొండార్‌ లోకుర్‌ దెయం అస్తి మహికార్‌ అబ్బె మహార్‌. దెయమ్‌కు నండొ గగోలాజి వరిఙ్ ‌డిఃస్తె సొహె. ");
INSERT INTO kfc_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","అందెఙె సమరియ పట్నమ్‌దు నండొ సర్ద కల్గితాద్. ");
INSERT INTO kfc_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","సమరియ పట్నమ్‌దు సిమోను ఇని ఒరెన్ మహాన్‌. సిమోను ఆ పట్నమ్‌దు సెగం పంటెఙ్ ‌గార్డి విదె కిజి నాను ఒరెన్ ‌గొప్ప వాండ్రు ఇజి వెహ్సి మహాన్‌. అబ్బె మహి లోకాఙ్‌ ‌సిమోను బమ్మ కిబిసి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","అయ పట్నమ్‌దు మహికార్‌ ‌ఇజిరికార్ ‌పెరికార్‌ విజేరె వీండ్రు ‘దేవుణు గొప్ప సత్తు ఇనికాన్‌’ ‌ఇజి వెహ్సి వన్ని ముస్కు నమకం ఇడ్ఃతార్. ");
INSERT INTO kfc_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","నండొ కాలం సిమోను గార్డి పణి కిజి లోకాఙ్‌ బమ్మ కిబిసి మహాన్‌. అందెఙె వారు సిమోనుఙ్ ‌నమ్మితార్. ");
INSERT INTO kfc_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","గాని దేవుణు ఏలుబడిః వందిఙ్, యేసుక్రీస్తు వందిఙ్ ‌పిలిపు పట్నమ్‌ది లోకాఙ్‌ ‌సాటిస్తిఙ్ ‌యా సువార్త వెహికార్. నమ్మిత్తారె మొగ్గకొడొఃర్, అయ్‌లికొడొఃక్‌ బాప్తిసం లాగె ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","అయావలె సిమోనుబా నమ్మిజి బాప్తిసం పొందితాండ్రె పిలిపుఙ్‌ డిఃస్‌ఏండ వన్నివెటనె మహాన్‌. పిలిపు కిని బమ్మాని గుర్తుఙ్, బమ్మాని పణిఙ్ ‌సుడ్ఃజి సిమోను గొప్ప బమ్మ ఆతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","యేసు ప్రబు వందిఙ్‌ వెహ్తి సువార్త సమరియ దేసెమ్‌దికార్‌ ఒపుకొటార్ ‌ఇజి యెరూసలేమ్‌దు మన్ని అపొస్తురు వెహర్. వెహారె పేతురుఙ్‌ యోహానుఙ్‌ ‌వరి డగ్రు పోక్తార్‌ ");
INSERT INTO kfc_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","వీరు వాతారె సమరియ పట్నమ్‌దు నమ్మితి వరి ముస్కు దేవుణు ఆత్మ సత్తు వాదెఙ్‌ ‌ఇజి పార్దనం కిత్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ఎందనిఙ్‌ ‌ఇహిఙ అబ్బెణి దాక ‌దేవుణు ఆత్మ సత్తు వరి ఎయేరి ముస్కుబా రెఏండ మహాద్‌. వారు ప్రబువాతి యేసు పేరుదాన్‌ బాప్తిసం ఉండ్రెనె లాగె ఆజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","అయావలె పేతురు, యోహాను వరి ముస్కు కిక్కు ఇడ్తిఙ్ ‌దేవుణు ఆత్మ సత్తు వరి ముస్కు వాతాద్. ");
INSERT INTO kfc_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","అపొస్తురు లోకుర్‌ ముస్కు కిక్కు ఇట్తి వలె వారు దేవుణు ఆత్మదాన్‌ నిండ్రిజినార్ ‌ఇజి సిమోను సుడ్ఃతాన్. సుడ్ఃతండ్రె, “నాను ఎయెన్‌ ‌ముస్కు కిక్కు ఇడ్నానొ, వాండ్రు దేవుణు ఆత్మ సత్తుదాన్ నిండ్రిని వజ యా అతికారం నఙిబా సిదా”, ఇజి వెహ్సి వరి ముందాల డబ్బు ఇట్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","అయావలె పేతురు, “నీను డబ్బు సీజి దేవుణు వరం సంపాదనం కిన ఇజి ఒడిఃబిత్తిదా? నీ డబ్బు నీ వెట నాసనం ఆపిద్. ");
INSERT INTO kfc_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","నీ ఆలోసనం దేవుణు సుడ్ఃతిఙ్ సరి ఆతిక ఆఏద్‌. అందెఙె మాపు కిని పణిదు నిఙి ఇని వంతు సిల్లెద్‌. ");
INSERT INTO kfc_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","అందెఙె యా సెఇ ఆలోసనమ్‌కు డిఃసిసీజి దేవుణు డగ్రు వాజి పార్దనం కిదు. నీను ఒడిఃబిత్తి ఆలోసనమ్‌ వందిఙ్‌ దేవుణు నిఙి సెమిస్నాన్సు. ");
INSERT INTO kfc_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","నీ మన్సుదు నండొ గోస నిండ్రిత మనాద్‌ ‌ఇజి నాను నెస్నా. అక్కాదె ఆఏండ నీ పాపమ్‌కు నిఙి తొహ్తె మన్నె‌ ఇజి నాను నెస్నా”, ఇజి పేతురు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","దన్నిఙ్ ‌సిమోను, “నీను వెహ్తికెఙ్‌ ఇనికబా నా ముస్కు రెఏండ మీరు నావందిఙ్‌ యేసుప్రబుఙ్‌ పార్దనం కిదు”, ఇజి పేతురుఙ్‌ యోహానుఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","వెనుక పేతురు, యోహాను సాసి వెహ్సి, యేసుప్రబు సువార్త సాటిసి, యెరూసలేమ్‌దు మహ్త వాతార్. వాని సరి సమరియదు మహి నండొ నాహ్‌కాఙ్ ‌సువార్త సాటిసి వాతార్. ");
INSERT INTO kfc_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","అయావలె, ఒరెన్ ‌దేవుణు దూత పిలిపుఙ్‌ వెహ్తాన్‌, “నీను దసిణం దరోట్‌ సొన్సి యెరూసలేమ్‌దాన్ ‌గాజ ఇని పట్నం సొని బిడిఃమ్‌ బూమిదు సొన్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","అందెఙె పిలిపు సోతాండ్రె సొహాన్‌. సొన్సి మహిఙ్‌ ఒరెన్‌ అయ్తియొపియదికాన్‌ రదం ముస్కు సొన్సినాన్. వాండ్రు అయ్తియొపియ దేసెమ్‌ది రాణి కందెకెబాన్ ‌ముకెలమతి పణి కినికాన్‌ ఒరెన్. ఇని పణి ఇహిఙ దేసెమ్‌ది డబ్బు నడిఃపిసిని దన్ని ముస్కు వీండ్రు మంత్రి. వీండ్రు యెరూసలేమ్‌దు పార్దనం కిదెఙ్ ‌సొహాండ్రె మర్‌జి సొన్సినాన్. సొన్సి మహిఙ్ ‌వీండ్రు రదమ్‌దు బసి యెసయ ప్రవక్త రాస్తి పుస్తకం సద్‌విజినాన్. ");
INSERT INTO kfc_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","అయావలె దేవుణు ఆత్మ పిలిపుఙ్, “నీను రదం డగ్రు సొన్సి దన్ని వెట నడిఃజి సొన్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","పిలిపు రదం డగ్రు ఉహ్‌క్సి సొహిఙ్‌ ‌అయా అయ్తియొపియదికాన్‌ యెసయ ప్రవక్త రాస్తి పుస్తకం సద్‌విజినాన్. పిలిపు అక్క వెహాన్. వెహాండ్రె, “నీను సద్‌విజినిక అర్దం కిజినిదా?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","వెన్‌బాతిఙ్, “ఎలాగ అర్దం కిన? ఎయెన్‌బా నఙి అర్దం వెహ్‌ఏండ మహిఙ ఎలాగ అర్దం కినా? రదమ్‌ ముస్కు ఎక్సి నా వెట బస్‌అ. దిన్ని అర్దం వెహ్సి సిదా” ఇహాన్‌, అయ అయ్తియొపియదికాన్. అందెఙె పిలిపు రదం ఎక్సి వన్ని డగ్రు బస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","అయ అయ్తియొపియదికాన్‌ సద్‌విజి మహి మాటెఙ్‌ ఇనికెఙ్‌ ‌ఇహిఙ “సప్తెఙ్‌ ఒని గొర్రె వజ వన్నిఙ్‌ ఒతార్. బుడుఃస్కుఙ్‌ కత్రిసినివలె అలెజి మంజిని మెండగొర్రెపిల్ల వజ అలేత మహాన్‌. వాండ్రు ఇనికబా ఇన్‌ఎతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","వారు వన్నిఙ్‌ సిగు కిత్తార్‌. వన్నిఙ్‌ నాయం దొహ్‌క్‌ఏండాత సొహాద్. వన్ని పొటెఙాణి వరి వందిఙ్‌ ఎయెర్‌బా వెహ్‌ఏండ ఆనార్. ఎందనిఙ్‌ ఇహిఙ, వన్ని పాణమ్‌దిఙ్ ‌బూమి ముస్కుహాన్ ‌లాగితార్”. ");
INSERT INTO kfc_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","అయ అయ్తియొపియదికాన్ ‌ఈహు వెన్‌బాతాన్, “ప్రవక్త ఎయె వందిఙ్‌ ఈహు వెహ్సినాన్‌? వన్ని వందిఙెనా, మరి ఒరెన్‌ వందిఙా? దయ కిజి వెహ్‌అ”. ");
INSERT INTO kfc_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","అందెఙె పిలిపు అయ అయ్తియొపియదికాన్ ‌సద్‌వీజి మహి యెసయ ప్రవక్త రాస్తి పుస్తకమ్‌దు మహి మాటదాన్‌ మొదొల్సి యేసుప్రబు వందిఙ్ ‌సువార్త వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ఆహె వారు సొన్సి మహిఙ్‌ ఏరు మహి ఉండ్రి బాడ్డిదు వాతార్. అయ అయ్తియొపియదికాన్‌ వెహ్తాన్‌, “ఇబ్బె ఏరు మన్నె. నాను బాప్తిసం లాగె ఆదెఙ్‌ ఇనికబా అడ్డు మనాదా?”. ");
INSERT INTO kfc_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","దన్నిఙ్ ‌పిలిపు, “నీను మన్సు పూర్తి యేసుప్రబుఙ్‌ నమ్మిత్తిఙ బాప్తిసం లాగె ఆదెఙ్‌ ఇని అడ్డుబా సిల్లెద్‌”, ఇహాన్‌. అందెఙె వాండ్రు, “ఒఒ, యేసుక్రీస్తు దేవుణు మరిసి ఇజి నాను నమ్మిజిన”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","అయావలె, “రదం నిల్‌ప్‌అ”, ఇజి అయ్తియొపియదికాన్‌ ఆడ్ర సిత్తాన్‌. రదం నిల్‌ప్తాండ్రె వాండ్రు, పిలిపు, రిఎర్‌ డిఃగ్‌జి ఏరుదు డిఃగితార్. పిలిపు అయ్తియొపియది వన్నిఙ్‌ బాప్తిసం సిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","వారు ఏరు లొఇహాన్‌ ‌వెల్లి వాతిఙ్‌ ‌వెటనె దేవుణు ఆత్మ పిలిపుఙ్‌ కూక్త ఒతాన్. అయ్తియొపిదికాన్‌ పిలిపుఙ్‌ మరి సుడ్ఃఏతాన్. గాని వాండ్రు సర్‌ద ఆజి వన్ని సరినె సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","పిలిపు సుడ్ఃతిఙ్‌ అజొతు పట్నమ్‌దు మన్న ఇజి నెస్తాన్. అబ్బెణిఙ్‌ సోసి వాండ్రు సొహి సరిదు మహి విజు పట్నమ్‌కాఙ్‌ యేసు ప్రబు వందిఙ్‌ సువార్త వెహ్సి కయ్‌సరియ ఇని పట్నమ్‌దాక వాతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","అయావలె సవులు ఇనికాన్‌ యేసుప్రబు ముస్కు నమ్మితి వరిఙ్ ‌బెద్రిసి మహాన్‌. వరిఙ్‌ మాలెఙ్ కిజి మహాన్‌. వాండ్రు విజేరె పుజేరిఙ ముస్కు పెరి పుజేరిబాన్‌ సొహాండ్రె దమస్కు పట్నమ్‌దు మన్ని యూదురి మీటిఙ్‌ ఇల్కాణి పెద్దెల్‌ఙ సీదెఙ్‌ ‌ఉత్రమ్‌కు లొస్తాన్. ఇని ఉత్రమ్‌కు ఇహిఙ, దమస్కు పట్నమ్‌దు యేసుప్రబు ముస్కు నమకం ఇడ్తికార్ ఎయెర్‌బా మహిఙ, మొగ్గకొడొఃర్‌ గాని అయ్‌లికొడొఃక్‌ గాని వరిఙ్‌ తొహ్సి ఒసి యెరూసలేం పట్నమ్‌దు తతెఙ్‌ సవులుఙ్‌ ‌అతికారం మనాద్‌ ఇజి వెహ్సిని ఉత్రమ్‌కు. ");
INSERT INTO kfc_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","విజేరె పుజేరిఙ ముస్కు పెరి పుజేరి సిత్తి ఉత్రమ్‌కు అస్తాండ్రె సవులు దమస్కు పట్నమ్‌దు సొండ్రెఙ్ ‌సోత్తాన్. దమస్కు పట్నం డగ్రు వాజి మహిఙ్ గదెం ఆగసమ్‌దాన్‌ ఉండ్రి గొప్ప జాయ్‌ వన్ని సురులం డెఃయ్‌తాద్. ");
INSERT INTO kfc_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","అయావలె సవులు బూమిదు అర్తాన్. అర్తిఙ్, “సవులు, సవులు, నీను ఎందనిఙ్‌ నఙి మాలెఙ్ కిజిని”, ఇజి వన్ని వెట వెహ్ని ఉండ్రి మాట వెహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","“ప్రబు, నీను ఎయి”, ఇజి సవులు వెన్‌బాతాన్. “నీను మాలెఙ్ కిజిని యేసునె నాను. ");
INSERT INTO kfc_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ఏలు నిఙ్‌జి పట్నమ్‌దు సొన్‌అ. నీను ఇనిక కిదెఙ్‌ ఇజి ఒరెన్‌ నిఙి వెహ్ననాన్‌లె”, ఇజి మాట వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","సవులు వెట సొన్సి మహికార్ ‌జాటు వెహార్‌ గాని ఎయెరిఙ్‌బా తోర్‌ఏతార్. వారు అల్లెత నిహ మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","సవులు బూమిదాన్ ‌నిఙిత్తాండ్రె బేస్తాన్‌ గాని కణుకు తోర్‌ఏండ ఆతె. అందెఙె వారు వన్నిఙ్ ‌కికాఙ్ ‌అస్తారె దమస్కు పట్నమ్‌దు నడిఃపిసి ఒతార్. ");
INSERT INTO kfc_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","వాండ్రు మూండ్రి రోస్కు కణుకు తోర్‌ఏండ మహాన్‌. ఇనికబా తిన్‌ఏండ ఉణెఎండ మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","దమస్కు పట్నమ్‌దు యేసుప్రబు సిసూడుః ఒరెన్‌ ‌అననియ ఇనికాన్‌ మహాన్‌. యేసుప్రబు వన్నిఙ్‌ దర్సనమ్‌దు తోరె ఆతండ్రె, “అననియ”, ఇజి కూక్తాన్. కూక్తిఙ్‌ అననియ, “ప్రబువా నాను ఇబ్బె మన్న”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","యేసుప్రబు వన్నివెట, “నీను తినాఙ్‌ ఇజి కూక్ని సరిదు సొన్‌అ. బానె యూద ఇని వన్ని ఇండ్రొ సొన్సి తార్సు పట్నమ్‌దికాన్ ‌సవులు ఇని వన్ని వందిఙ్‌ ‌వెన్‌బాఅ. సవులు పార్దనం కిజి మంజినాన్. ఉండ్రి దర్సనమ్‌దు సవులు ఇనిక సుడ్ఃతాన్‌ ఇహిఙ, ");
INSERT INTO kfc_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","అననియ ఇనికాన్‌ ఒరెన్‌ వాతండ్రె వన్ని కణెకెఙ్‌ ‌నెగెండ్‌ కిజి మరి సూణి లెకెండ్‌ ఆదెఙ్‌ వన్ని బురాదు కిక్కు ఇడ్నివజ సుడ్ఃతాన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","దన్నిఙ్‌ అననియ వెహ్తాన్‌, “ప్రబు వీండ్రు యెరూసలేమ్‌దు నిఙి కేట ఆతి వ‍రిఙ్‌ ‌ఎస్సొనొ మాలెఙ్ కిత్తాన్‌‌ ఇజి వన్ని వందిఙ్‌ నాను నండొ వెహ మహ. ");
INSERT INTO kfc_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ఇబ్బె యా పట్నమ్‌దు నీ ముస్కు నమకం ఇడ్తి వరిఙ్ ‌తొహ్సి ఒసి యెరూసలేమ్‌దు ఒతెఙ్‌ ‌వన్నిఙ్ ‌అతికారం సీని ఉత్రమ్‌కు పెరి పుజేరిఙ బాణిఙ్‌ అస్తాండ్రె వాత మహాన్”. ");
INSERT INTO kfc_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","యేసుప్రబు అననియ వెట, “నీను సొన్‌అ. యూదురు ఆఇ లోకుర్‌ నడిఃమి, రాజురిఙ నడిఃమి, ఇస్రాయేలు లోకాఙ్‌ నడఃమి నా వందిఙ్‌ ‌వెహ్తెఙ్ ‌నాను వన్నిఙ్‌ ఏర్‌పాటు కిత మన్న. ");
INSERT INTO kfc_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","నా వందిఙ్‌ వాండ్రు ఎసొనొ మాలెఙ్ ఆనాన్‌ ‌ఇజి నాను వన్నిఙ్ ‌తోరిస్న”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","అందెఙె అననియ అయ ఇండ్రొ సొహాండ్రె సవులు ముస్కు కిక్కు ఇట్తాన్. “సవులునా, నీను వాతి సరిదు నిఙి తోరె ఆతి ప్రబు ఆతి యేసు నఙి పోక్త మనాన్. నీను మరి సూణి వందిఙ్‌ దేవుణు ఆత్మ సత్తు నీ ముస్కు వాని వందిఙ్‌ నఙి పోక్త మనాన్”, ఇజి సవులు వెట వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","అయావలె వన్ని కణకాణిఙ్‌ పొరొఙ్‌ నన్నికెఙ్ ‌రాల్తిఙ్ ‌సుడ్ఃదెఙ్‌ ‌అట్తాన్. సవులు నిఙితండ్రె బాప్తిసం లాగె ఆతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","వెనుక బోజనం కితాండ్రె సత్తు ఆతాన్. సవులు దమస్కు పట్నమ్‌దు మహి యేసుప్రబు సిసూర్‌ వెట సెగం దినమ్‌కు మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","యూదురి మీటిఙ్‌ ‌ఇల్కాఙ్ ‌తిన్నాఙ్‌ సొహాండ్రె యేసునె దేవుణు మరిసి ఇజి యేసుప్రబు వందిఙ్ ‌బోదిస్తెఙ్ ‌మొదొల్‌స్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","అక్క వెహికార్ విజేరె నండొ బమ్మ ఆతార్. యెరూసలేమ్‌దు యేసుప్రబుఙ్‌ నమ్మితి వరిఙ్ ‌పాడుః కిజి మహికాన్‌ ‌వీండ్రెగదె. యేసుప్రబుఙ్‌ ‌నమ్మితి వరిఙ్ ‌తొహ్సి పెరి పుజేరిర్ డగ్రు కూక్సి ఒతెఙ్‌ ‌ఇబ్బెబా వీండ్రు వాత మనాన్‌ ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","అహిఙ్‌బా పవులు మరి నండొ సత్తుదాన్ ‌బోదిసి మహాన్‌. యేసునె ‌దేవుణు పోక్తి క్రీస్తు ఇజి రుజుప్‌ ‌కిత్తాండ్రె దమస్కు పట్నమ్‌దు మహి యూదురుఙ్ గాబ్ర కిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","నండొ రోస్కు సొహి వెనుక సవులుఙ్‌ ‌సప్తెఙ్ ‌ఇజి యూదురు ఆలోసనం కిత్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","గాని వరి ఆలోసనం సవులుఙ్‌ తెలితాద్. వన్నిఙ్‌ సప్తెఙ్‌ ‌వారు రెయువేల పూర్తి పట్నం వెల్లి సొని సేహ్ల బాన్‌ సుడ్ఃజి కాత మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","గాని వన్ని సిసూర్‌ రయ్తు వన్నిఙ్ ‌ఒతారె ఉండ్రి గంపదు బసె కితారె పట్నం సురుల మన్ని గోడఃదు మన్ని ఉండ్రి కిటికి బొరొదాన్‌ వన్నిఙ్ ‌అడిఃగి డిఃప్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","సవులు యెరూసలేమ్‌దు సొహిఙ్‌ ‌సిసూర్‌ వెట కూడ్ఃదెఙ్‌ ‌సుడ్ఃతాన్. గాని వాండ్రు సిసూర్‌ లొఇ ఒరెన్ ఆఏన్‌ ఇజి వారు ఒడిఃబిత్తారె వన్నిఙ్ ‌వరివెట కూడుఃప్తెఙ్‌ ‌తియెల్ ‌ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","గాని బరబ్బ ఇనికాన్‌ ‌వన్నిఙ్ ‌అపొస్తురుబాన్ ‌కూక్సి ఒతాన్. సవులు దమస్కు పట్నమ్‌దు సొహి సరిదు ఎలాగ యేసుప్రబు వన్నిఙ్‌ తోరె ఆతాన్‌ ‌ఇజి, ఎలాగ యేసుప్రబు వన్నివెట వర్గితాన్ ‌ఇజి, వెనుక సవులు ఎలాగ దమస్కు పట్నమ్‌దు తియెల్‌ సిల్లెండ యేసుప్రబు వందిఙ్ ‌బోదిస్తాన్‌ ఇజి బరబ్బ అపొస్తురు వెట వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","అయావలె అపొస్తురు సవులుఙ్‌ కూడుఃప్తిఙ్ వాండ్రు వరివెట కూడిఃత మహాన్‌. వరివెట కూడిఃతాండ్రె యెరూసలేమ్‌దు విజు బాడ్డిదు సొన్సి తియెల్‌ ‌సిల్లెండ యేసుప్రబు వందిఙ్ ‌బోదిస్తెఙ్ ‌మొదొల్‌స్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","గ్రీకు బాస వర్గిని యూదురు వెట వర్గితాండ్రె తర్కిస్తాన్. అందెఙె వారు సవులుఙ్‌ ‌సప్తెఙ్ ‌సుడ్ఃతార్. ");
INSERT INTO kfc_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","యాక తెలితారె సిసూర్‌ వన్నిఙ్ ‌డిగు మన్ని కయ్‌సరియాదు ఒతారె తార్సు పట్నం పోక్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","అయ కాలమ్‌దు యూదయ, గలిలయ, సమరియ దేసమ్‌కాఙ్ ‌మహి దేవుణు సఙం ‌తియెల్ ‌సిల్లెండ సమదానమ్‌దాన్ ‌మహార్‌. సఙం దేవుణుదిఙ్‌ లొఙిజి దేవుణు ఆత్మ సాయమ్‌దాన్‌ సత్తు ఆజి వాతె. నమ్మితికార్‌ నండొండార్‌ ఆజి వాతార్. ");
INSERT INTO kfc_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","అయావలె పేతురు నాహ్కునాహ్కు, పట్నమ్‌కుపట్నమ్‌కు సొన్సి లుద ఇని నాటొ దేవుణుదిఙ్‌ కేట ఆతి వరిఙ్‌ సుడిః సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","బానె ఒరెన్ ‌అయ్‌నెయ ఇనికాన్‌ ఎనిమిది పంటెఙాణ్ ‌అసి నిఙ్‌దెఙ్ ‌అట్ఇ వన్నిఙ్ సుడ్ఃతాన్. వాండ్రు కిక్కు కాల్కు అర్తికాన్. ");
INSERT INTO kfc_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","పేతురు వన్నిఙ్‌ సుడ్ఃజి, “అయ్‌నెయ, యేసుక్రీస్తు నిఙి నెగెండ కిజినాన్. నిఙ్‌జి, నీ మంసం నీనె పెర్జి ఉండ్రి పడఃకాద్‌ ఇడ్ఃఅ” ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","వెటనె అయ్‌నెయ నిఙిత్తాన్. లుదా నాటొదు, సారోను దేసమ్‌దు మహికార్‌ విజేరె, వన్నిఙ్‌ జర్గితిక సుడ్ఃతారె యేసుప్రబుఙ్‌ ‌నమ్మితార్. ");
INSERT INTO kfc_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","అయావలె యోప ఇని పట్నమ్‌దు తబిత ఇని ఉండ్రి అయ్‌లి కొడొః మహాద్‌. అదిబా యేసుప్రబు సిసూ. గ్రీకు బాసాదు దన్ని పేరు దొర్క. దొర్క ఇహిఙ డుపి ఇజి అర్దం. అది ఎసెఙ్‌బా నెగ్గి పణి కిజి మహాద్‌. సిల్లి వరిఙ్ ‌సాయం కిజి మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","గాని అది అయావలె ఉండ్రి కస్టం అస్తాదె సాతాద్. వారు పీనుగుదిఙ్‌ ఏరు వడిఃస్తారె మేడః ముస్కు మన్ని గదిదు తెర్‌ప్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","లుద పట్నం యోప పట్నం డగ్రు మహాద్‌. పేతురు అబ్బె మనాన్‌ ఇజి యోపాదు మన్ని సిసూర్‌ వెహారె రిఎర్‌ మణిసిరిఙ్ ‌పోక్సి, “దయ కిజి వెటనె రఅ”, ఇజి కబ్రు పోక్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","పేతురు నిఙితండ్రె వరివెట యోపాదు సొహాన్‌. వారు వన్నిఙ్ ‌మేడఃగది లొఇ ఒతార్. అబ్బె ముండ మణిసిక్‌ అడఃబాజి, దొర్క వరివెట మహివలె గుతిస్తి సొక్కెఙ్ ‌పాతెఙ్ ‌తోరిసి వన్ని సురుల నిహె. ");
INSERT INTO kfc_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","పేతురు విజేరిఙ్‌ వెల్లి పోక్తాండ్రె ముణుకుఙ్‌ ఊర్‌జి పార్దనం కిత్తాన్‌. పీనుగుదిఙ్ ‌సుడ్ఃజి, “తబిత, నిఙ్‌అ” ఇహాన్‌. అయావలె అది బేస్తాదె పేతురుఙ్‌ సుడ్ఃజి నిఙిత బస్తాద్. ");
INSERT INTO kfc_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","పేతురు దన్నిఙ్‌ కిక్కాఙ్ ‌అస్తాండ్రె నిక్తాన్. నమ్మితి వరిఙ్, ముండ మణిసికాఙ్‌ కూక్సి అది బత్కిత్తాద్‌ ఇజి వరిఙ్‌ ఒపజెప్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","యాక యోపాదు మనికార్‌ విజేరె నెస్తారె నండొండార్ ‌యేసుప్రబు ముస్కు నమకం ఇట్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","పేతురు యోపాదు సీమోను ఇని ఒరెన్‌ తోల్కు పొర్ని వన్ని‌బాన్ ‌యోప పట్నమ్‌దు నండొ దినమ్‌కు బత్కితాన్. ");
INSERT INTO kfc_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","అయావలె కయ్‌సరియ ఇని పట్నమ్‌దు, ఉద్దం కినివరి లొఇ కొర్నెలి ఇని ఒరెన్‌ సదాతిపతి మహాన్‌. వాండ్రు, వన్ని అడ్గి మహి ఉద్దం కినికార్‌ ఇటలి దేసెమ్‌దాన్‌ వాతి మహి గుంపుదికార్‌ ఇజి కూకె ఆతమహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","కొర్నెలి, వన్ని ఇండ్రొణికార్, బక్తి మనికార్. వారు దేవుణుదిఙ్‌ తియెల్‌ ఆతికార్. వాండ్రు సిల్లి వరిఙ్‌ వన్నిఙ్‌ మనిక సెడ్డినె సీజి మహాన్. దేవుణుదిఙ్‌ ఎస్తివలెబా పార్దనం కినికాన్. ");
INSERT INTO kfc_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ఒర్నెండు మదెనం రమరమి మూండ్రి గంటెఙ, దేవుణు బాణిఙ్‌ ‌వాతి ఒరెన్‌ దూత వన్నిబాన్‌ నిహండ్రె, “కొర్నెలి”, ఇజి కూక్తాన్. కూక్తిఙ్‌ యా దూతెఙ్ టెటాఙ్‌ సుడ్ఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","కొర్నెలి గొప్ప తియెల్‌ ఆతండ్రె, “ప్రబు, ఇనిక?”, ఇహాన్‌. దూత వెహ్తాన్‌, “నీను దేవుణుదిఙ్‌ ‌కిత్తి పార్దనమ్‌కు, సిల్లి వరిఙ్ ‌సీని దానం విజు దేవుణు సుడ్ఃతండ్రె నీ వందిఙ్ ఒడిఃబిజినాన్. ");
INSERT INTO kfc_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ఏలు యోప ఇని పట్నమ్‌దు లోకాఙ్‌ ‌పోక్సి పేతురు ఇజి కూకె ఆని సీమోను ఇని వన్నిఙ్‌ కూక్పిస్‌అ. ");
INSERT INTO kfc_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","వాండ్రు సమ్‌దరం డగ్రు మన్ని సీమోను ఇని తోల్కు తయార్ కినికాన్‌ ఒరెన్‌ వన్ని ఇండ్రొ బత్కిజినాన్”. ");
INSERT INTO kfc_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","యాక వెహ్సి దూత సొహిఙ్, కొర్నెలి వన్ని పణి మణిసిర్‌ రిఎరిఙ్‌ కూక్‌పిస్తాన్. ఎస్తివలెబా వన్నివెట కూడ్ఃజి మంజిని బక్తి మన్ని ఒరెన్‌ ఉద్దం కిని వ‍న్నిఙ్‌బా కూక్‌పిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","జర్గితిక విజు వరివెట వెహ్తండ్రె వరిఙ్‌ యోప పట్నమ్‌దు పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","మ‍ర్సనాండిఙ్ వారు సొన్సి యోప పట్నం డగ్రు ఆతార్. అయావలె మదెనం ఆతాద్. పేతురు పార్దనం కిదెఙ్‌ మేడః ముస్కు ఎక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","పేతురు గొప్ప బఙ కట్తిఙ్‌ ఇనికబా ఉండెఙ్‌ కోరిత్తాన్. బోజనం తయారాజి మహిఙ్‌ వాండ్రు ఉండ్రి దర్సనం సుడ్ఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","అక్క ఇనిక ఇహిఙ ఆగాసం రే ఆజి నాల్గి సెంగుఙ అసిమహి పెరి దుపాటి ననిక ఉండ్రి బూమిదు డిపె ఆతిలెకెండ్‌ సుడ్ఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","దన్ని లొఇ బూమి ముస్కు మన్ని నాల్గి కాల్కు మన్ని విజు రకం జంతుఙ్, బూమి ముస్కు ఊజి బూలానికెఙ్, ఆగసమ్‌ ముస్కు ఎగ్రిని పొటిఙ్‌ మహె. ");
INSERT INTO kfc_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","అయావలె, “పేతురు, నిఙ్‌అ, సప్సి తిన్‌అ”, ఇజి, ఉండ్రి మాట పేతురు వెహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","దన్నిఙ్ పేతురు, “సిల్లె ప్రబువా, తిండ్రెఙ్‌ ‌ఆఇకెఙ్ ‌ఎసెఙ్‌బా నాను తిన్‌ఏ”, ఇజి వెహ్తాన్‌‌. ");
INSERT INTO kfc_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","వెహ్తిఙ్, మాట మరి వాతాద్, “దేవుణు నెగ్గిక ఇజి ఇడ్తికెఙ్ ‌నీను సెఏద్ ఇజి ఎర్లిస్మ”. ");
INSERT INTO kfc_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ఈహు మూండ్రి సుట్కు జర్గితాద్. వెటనె ఆ దుపాటినన్నిక ఆగాసమ్‌దు మర్‌జి పెరె ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","దర్సనమ్‌దు సుడ్ఃతి దన్ని అర్దం ఇనికాదొ ఇజి పేతురు గొప్పఙ ఒడిఃబిజి మహాన్‌. అయావలె కొర్నెలి పోక్తి లోకుర్ ‌సీమోను ఇల్లు ఎమేణిక ఇజి వెన్‌బాజి నెస్తారె వన్ని ఇల్లు ముందాల వాతార్. ");
INSERT INTO kfc_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","“పేతురు ఇజి కూకె ఆని సీమోను ఇబ్బె మనాండ్రా, సిల్లెండ్రా”, ఇజి పేరు అస్తారె డేడిఃస్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","పేతురు దర్సనమ్‌దు సుడ్ఃతి దన్ని వందిఙ్‌ ఒడిఃబిజి మహివలెనె దేవుణు ఆత్మ వన్నివెట వెహ్తాన్‌, “సీమోను, ముఎర్ లోకుర్ ‌నిఙి రెబాజినార్. ");
INSERT INTO kfc_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","నీను నిఙ్‌జి అడ్గి డిఃగ్‌జి సొన్‌అ. అనుమానం ఆఏండ వరివెట సొన్‌అ. ఎందనిఙ్‌ ఇహిఙ నానె వరిఙ్‌ పోక్త”. ");
INSERT INTO kfc_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","పేతురు డిఃగ్‌జి సొహాండ్రె, “మీరు నఙినె రెబాజినిదెర్. ఎందనిఙ్‌ ‌వాతిదెర్?”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","దన్నిఙ్‌ వారు, “సదాతిపతి ఆతి కొర్నెలి మఙి పోక్తాన్. వాండ్రు నీతి నిజాయితి మన్నికాన్. దేవుణుదిఙ్‌ తియెలాజి మన్నికాన్. వాండ్రు గొప్ప నెగ్గికాన్ ‌ఇజి యూదురు విజేరె వెహ్సినార్. ఒరెన్‌ దేవుణు ‌దూత వన్నిఙ్‌ తోరె ఆతండ్రె, ‘పేతురుఙ్‌ నీ ఇండ్రొ కూక్సి తసి వన్ని మాటెఙ్‌ వెన్‌అ’ ఇహాన్‌”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","అయావలె పేతురు వరిఙ్‌ ఇండ్రొ తతాండ్రె, “నేండ్రు మా బాన్‌ మండ్రు”, ఇహాన్‌. మహ్స నాండిఙ్‌ పేతురు నిఙితండ్రె వరివెట పయ్‌నం ఆతాన్. యోపాదికార్ ‌సెగొండార్‌ యేసుప్రబుఙ్‌ ‌నమ్మితికార్ ‌వరివెట సొహార్. ");
INSERT INTO kfc_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ఉండ్రి రోజు పయ్‌నం ఆతారె మహ్స నాండిఙ్‌ వారు కయ్‌సరియాదు అందితార్. కొర్నెలి వన్ని కుటుమ్‌ది వరిఙ్ ‌వన్ని డగ్రుహి కూడెఃఙ ఇండ్రొ కూడుఃప్తాండ్రె పేతురు వందిఙ్‌ కాప్‌ కిజి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","పేతురు ఇండ్రొ వాతిఙ్‌ కొర్నెలి సొహాండ్రె వన్ని పాదమ్‌కాఙ్ ‌ఆర్తాండ్రె వన్నిఙ్ ‌మాడిఃస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","గాని పేతురు వన్నిఙ్‌ నిక్తాండ్రె, “నిఙ్‌అ, నానుబా నీ న‍న్ని లోకునె” ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","కొర్నెలి వెట వర్గిజి పేతురు లొఇ సొహిఙ్ ‌మంద లోకుర్‌ బాన్‌ కూడ్ఃజిమహిక సుడ్ఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","పేతురు వరి వెట వెహ్తాన్‌. “మా యూదురి రూలు వజ ఇహిఙ యూదురు ఆఇ లోకుర్‌ వెట కూడ్ఃనిక ఆఏద్‌. వరివెట మంజినిక ఆఏద్‌. ఇక్క మీరు నెసినిదెర్‌గదె. గాని లోకాఙ్‌ ‌ఎయెరిఙ్‌బా తక్కుదికార్ ఇజి ఇండ్రెఙ్ ‌ఆఏద్‌ ‌ఇజి దేవుణు నఙి తోరిస్త మనాన్. ");
INSERT INTO kfc_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","అందెఙె నఙి కూక్‌పిస్తిఙ్ ‌నాను అడ్డు వెహ్‌ఏండ వాత. నఙి ఎందనిఙ్‌ ‌కూక్‌పిస్తిదెర్. ఏలు వెహ్‌అ”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","అయావలె కొర్నెలి వెహ్తాన్‌, “నాల్గి దినమ్‌కు ముందాల యా గ‍డిఃయా‍దునె నాను మదెనం మూండ్రి గంటెఙ ఇండ్రొ పార్దనం కిజి మహ. వెటనె మెర్సిని నన్ని పాతెఙ్‌ పొర్పాతి మన్ని ఒరెన్‌ నా ఎద్రు నిహాన్. ");
INSERT INTO kfc_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","“కొర్నెలి, దేవుణు నీ పార్దనమ్‌కు వెహాన్‌. సిల్లి వరిఙ్ సెడ్డినె సిత్తికెఙ్ దేవుణు సుడ్ఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","యోపాదు కబ్రు పోక్సి పేతురు ఇజి కూకె ఆని సీమోనుఙ్‌ కూక్పిస్‌అ. వాండ్రు సమ్‌దరం డగ్రు తోల్కు తయార్ కినికాన్‌ ఒరెన్‌ ‌సీమోను ఇని వన్ని ఇండ్రొ బత్కిజినాన్. ");
INSERT INTO kfc_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","అందెఙె వెటనె నిఙి కబ్రు పోక్త. నీను వాతికాదె నెగెద్. ఏలు మాపు విజెపె దేవుణు డగ్రు వాతాప్. మా వెట వెహ్తెఙ్‌ దేవుణు నిఙి ఆడ్ర సిత్తి విజు మాటెఙ్‌ వెండ్రెఙ్‌ ‌మాపు వాతాప్. ");
INSERT INTO kfc_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","దన్నిఙ్‌ పేతురు వెహ్తాన్‌, “దేవుణు విజెరిఙ్‌ ‌ఉండ్రె లెకెండ్ ‌సుడ్ఃజినాన్, ఇజి ఏలు నాను నిజమ్‌నె నెస్నా. ");
INSERT INTO kfc_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ఎమేణి జాతి ఇహిఙ్‌బా దేవుణుదిఙ్ తియెలాజి, నీతి నిజాతిదాన్ నడిఃతిఙ దేవుణు వన్నిఙ్‌ ఒప్పుకొణాన్. ");
INSERT INTO kfc_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","యేసు క్రీస్తు విజెరిఙ్‌ ప్రబు. దేవుణు వెట లోకాఙ్‌ కూల తొహ్పిస్తెఙ్ వాండ్రు యేసుఙ్‌ పోక్తాన్. యేసువ‍లెహాన్ ఇస్రాయేలు లోకాఙ్‌ స‍మదనం వాతాద్‌ ఇజి దేవుణు సువార్త పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","యోహాను దేవుణు మాటెఙ్‌ ‌బోదిసి బాప్తిసం సిత్తి వెనుక గలీలయాదాన్ మొదొల్సి ‌యూదయ దేసమ్‌దు విజు ఇనిక జర్గితాద్‌ ఇజి మీరు నెసినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","యాక ఇనిక ఇహిఙ, దేవుణు, నజరేతు వాండ్రు ఆతి యేసుఙ్‌ దేవుణు ఆత్మ సత్తు సీజి ఏర్‌పాటు కిత్తాన్‌. వాండ్రు సొన్సి నెగ్గి పణిఙ్ కితాండ్రె స‍య్తాన్ లోకురిఙ్‌ కిజిని బాదెఙాణిఙ్ డిఃబిస్తాన్. దేవుణు వన్నివెట మహిఙానె వాండ్రు అక్కెఙ్‌ విజు కిదెఙ్‌ అట్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","వాండ్రు యూదురి దేసమ్‌దుని, యెరూసలేమ్‌దుని, కిత్తి విజు వ‍నకాఙ్‌ ‌మాపు సాసిర్. యూదురు వన్నిఙ్ ‌సిలువాదు డెఃయ్తారె సప్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","గాని మూండ్రి రోస్కాఙ్‌ దేవుణు వన్నిఙ్‌ సాతి వరిబాణిఙ్ ‌నిక్తాండ్రె మఙి తోరిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","విజేరె లోకాఙ్‌ వాండ్రు తోరె ఆఏతాన్. దేవుణు ముఙాలె ఏర్‌పాటు కిత్తి సాసిర్, ఇహిఙ, మఙినె వాండ్రు తోరె ఆతాన్. సాతి వరిబాణిఙ్‌ నిఙితి వెన్కా మాపె వ‍న్నివెట తింజి ‍ఉణిజి మహాప్. ");
INSERT INTO kfc_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","సాతి వరిఙ్, బత్కిజిని వరిఙ్‌ తీర్‌పు సీదెఙ్‌ దేవుణు యేసుఙె ఏర్‌పాటు కిత్తాన్‌ ఇజి సాసి వెహ్సి సువార్త సాటిస్తెఙ్ యేసుప్రబు మఙి ఆడ్ర సిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ప్రవక్తరు విజేరె వన్ని వందిఙ్‌ ఇని సాసి వెహ్తార్‌ ‌ఇహిఙ, వన్ని ముస్కు నమకం ఇడ్ని‌ విజెరి ‌పాపం దేవుణు వ‍న్ని వందిఙ్ సెమిస్నాన్లె ఇజి. ");
INSERT INTO kfc_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","పేతురు యా మాటెఙ్‌ వెహ్సి మహిఙ్‌నె, వన్ని మాటెఙ్‌ వెంజి మహివరి ముస్కు దేవుణు ఆత్మ వాతాద్. ");
INSERT INTO kfc_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","పేతురు వెట వాతి మహి నమ్మితికార్‌ యూదురు, యాక సుడ్ఃతారె బమ్మ ఆతార్. “యూదురు ఆఇ వరిఙ్‌బా దేవుణు ఆత్మ సత్తు ఇని ఇనాయం దేవుణు సీజినాన్”, ఇజి బమ్మ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ఎందనిఙ్‌ ఇహిఙ దేవుణు ఆత్మ సత్తు వరి ముస్కు వాతిఙ్‌ ‌వారు ఆఇ బాసెఙ్ ‌వర్గిజి దేవుణు ఎసొనొ పెరికాన్‌ ఇజి ‌స్తుతి కినిక వీరు వెహర్. అయావలె పేతురు వెహ్తాన్‌, ");
INSERT INTO kfc_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“మఙి దేవుణు ఆత్మ దొహ్‌క్తి లెకెండ్‌ విరిఙ్‌బా దొహ్‌క్తాద్. ఏలు వీరు ఏరుదు బాప్తిసం లాగె ఆదెఙ్‌ ‌ఇహిఙ ఎయెర్‌బా అడ్డు కిదెఙ్‌ అట్నారా?”. ");
INSERT INTO kfc_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","అందెఙె యేసుక్రీస్తు పేరు అసి ఏరుదు బాప్తిసం లాగె ఆదెఙ్‌ పేతురు వరిఙ్ ‌ఆడ్ర సిత్తాన్‌. వెనుక, సెగం రోస్కు మా వెట మన్‌అ ఇజి వారు పేతురుఙ్‌ వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","యూదురు ఆఇ లోకుర్‌బా దేవుణు - మాటెఙ్ ‌నమ్మితార్‌ ఇజి యూదయ దేసమ్‌దు మన్ని నమ్మిత్తికార్‌ని, అపొస్తురు వెహర్. ");
INSERT INTO kfc_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","3","అందెఙె పేతురు ఎక్కు యెరూసలేమ్‌దు సొహివలె బానె మహి సునతి కిబె ఆతి యూదురు, వన్నివెట తర్కిస్తార్. “నీను సునతి కిఇ లోకుర్‌ వెట కూడిఃతి మహి, వరివెట ఉణిజి మహి”, ఇజి వన్ని ముస్కు తర్కిస్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","అయావలె పేతురు, జర్గితికెఙ్‌ విజు మొదొహన్‌ అసి వరివెట వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“నాను యోప పట్నమ్‌దు మహివలె ఒర్‌నెండ్ ‌పార్దనం కిజి మహిఙ్‌ ‌ఉండ్రి దర్సనం సుడ్ఃత. ఇనిక సుడ్ఃత‌ ఇహిఙ, ఆగాసం రే ఆజి నాల్గి సెంగుఙ అసిమహి పెరి దుపాటి ననిక ఉండ్రి బూమిదు డిఃపె ఆతిలెకెండ్‌‌ నా డగ్రు డిఃగ్‌జి వాతాద్. ");
INSERT INTO kfc_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","అక్క నెగ్రెండ ‌సుడ్ఃతిఙ్‌ ‌దన్ని లొఇ నాల్గి కాల్కు మన్ని జంతుఙ్, అడిఃవి జంతుఙ్, బూమి ముస్కు ఊజి ‌బూలానికెఙ్, ఆగాసం ముస్కు ఎగ్రిని పొటిఙ్‌ నఙి తోరితె. ");
INSERT INTO kfc_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","అయావలె, ‘పేతురు నిఙ్‌అ. సప్సి తిన్‌అ’, ఇజి ఉండ్రి మాట వెహ. ");
INSERT INTO kfc_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","దన్నిఙ్ ‌నాను, ‘సిల్లె ప్రబు, సెఏద్ ఇజి ఇడ్తికెఙ్ ఇనికెఙ్‌బా నాను ఎసెఙ్‌బా తిన్‌ఏ’ ఇహ. ");
INSERT INTO kfc_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ఆగాసమ్‌దాన్‌ మాట మరి వాతాద్, ‘దేవుణు నెగ్గిక ఇజి వెహ్తికెఙ్‌ నీను ఏరిస్మ'. ");
INSERT INTO kfc_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ఈహు మూండ్రి సుట్కు వాతాద్. ఆక్కర్‌దిఙ్ ‌అక్కెఙ్‌ విజు ఆగసమ్‌దు మర్‌జి పెరె ఆతె. ");
INSERT INTO kfc_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","యాక జర్గితి వెటనె కయ్సరియదాన్‌ కొర్నెలి పోక్తి ‌ముఎర్‌ లోకుర్ నఙి రెబాజి నాను మహి ఇల్లు డగ్రు వాతార్. ");
INSERT INTO kfc_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","అయావలె దేవుణు ఆత్మ, ‘నీను ఇని అనుమానం సిల్లెండ వరివెట సొన్‌అ’ ఇహాన్‌. వీరు ఆరుగురు నమ్మిత్తికార్‌బా నావెట వాతార్. వాతారె మాపు కొర్నెలి ఇండ్రొ సొహప్‍. ");
INSERT INTO kfc_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","14","కొర్నెలి ఇండ్రొ సొహిఙ్, ‌దేవుణు దూత వన్నివెట వెహ్తికెఙ్‌ విజు వెహ్తాన్‌. ‘నీను యోపాదు లోకాఙ్‌ పోక్సి పేతురు ఇజి కూకె ఆని సీమోనుఙ్‌ కూక్పిస్‌అ. వాండ్రు వానాండ్రె నీను, నీ కుటుమ్‌దికార్‌ విజేరె పాపం కిత్తి దన్ని సిక్సదాన్‌ ఎలాగ గెలిస్తెఙ్ ఆనాద్‌ ఇజి వెహ్ననాన్‌లె’ ఇజి వెహ్తికెఙ్‌ విజు కొర్నెలి మఙి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","నాను వరివెట వర్గిదెఙ్‌ ‌మొదొల్‌స్తిఙ్, మా ముస్కు దేవుణు ఆత్మ తొలిత ఎలాగ వాతాదొ అయావజనె వరి ముస్కుబా వాతాద్. ");
INSERT INTO kfc_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","అయావలె నఙి ప్రబు మాటెఙ్‌ ‌గుర్తు వాతాద్. ఇనిక ఇహిఙ, ‘యోహాను ఏరుదాన్ ‌బాప్తిసం సిత్తాన్‌. గాని మీరు దేవుణు ఆత్మదాన్‌ బాప్తిసం లాగె ఆనిదెర్‌లె’ ఇజి. ");
INSERT INTO kfc_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","అహిఙ మాపు ప్రబు ఆతి యేసుక్రీస్తు ముస్కు నమకం ఇట్తి వలె దేవుణు మఙి సిత్తి ఇనాయమ్‌నె వరిఙ్‌బా సిత్తాన్.‌ దేవుణుదిఙ్‌ అడ్డు కిదెఙ్ నాను ఎపటిదికానా?”. ");
INSERT INTO kfc_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","యాక వెహారె వారు మరి ఇని అడ్డుబా వెహ్‌ఏతార్. “నిజమ్‌నె, యూదురు ఆఇ వరిఙ్‌బా వరి పాపమ్‌కు డిఃసిసీజి దేవుణుదిఙ్‌ లొఙిజి ఎలాకాలం బత్కిదెఙ్‌ దేవుణు సరి సీజినాన్”, ఇజి వెహ్సి వారు దేవుణుదిఙ్‌ ‌స్తుతి కిత్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","స్తెపానుఙ్‌ సప్తివెనుక యేసుప్రబు ముస్కు నమ్మితి వరిఙ్‌ లావు మాలెఙ్ ‌వాతిఙ్ ‌వారు సెద్రిత సొహార్. సెద్రితికార్ ‌సెగొండార్‌ పెనికె, కుప్ర, అంతియొకియ ఇని దేసమ్‌దాక సొహరె యూదురిఙ్ ‌ఉండ్రెనె దేవుణు మాటెఙ్‌ ‌వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","గాని వరి లొఇ సెగొండార్‌ కుప్రదికార్, కురేనియదికార్‌ మహార్‌. వారు సొన్సి అంతియోకయాదు మన్ని గ్రీకు బాస వర్గిని వరిఙ్‌బా యేసు ప్రబు వందిఙ్‌ సువార్త వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ప్రబు సత్తు వరివెట మహాద్‌. అందెఙె మంద లోకు దేవుణు మాట నమ్మిత్తారె ప్రబు ముస్కు నమకం ఇట్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","యెరూసలేమ్‌దు మన్ని సఙమ్‌దికార్‌ యాక వెహారె బర్నబెఙ్‌ అంతియోకయాదు పోక్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","బర్నబ వాతండ్రె దేవుణు దయ వరి ముస్కు వా‍తా‍ద్ ఇజి సుడ్ఃతాండ్రె‌ సర్ద ఆతాన్. దేవుణు ముస్కు ఉండ్రె మన్సుదాన్‌ నమ్మిదు ఇజి వాండ్రు వరిఙ్‌ దయ్‌రం వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","బర్నబ దేవుణు ఆత్మ సత్తుదాన్, నమకమ్‌దాన్ నిండ్రితికాన్, నెగ్గికాన్. వాండ్రు దేవుణు మాటెఙ్‌ బోదిస్తిఙ్‌ మంద లోకుర్‌ యేసుప్రబు ముస్కు నమకం ఇట్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","వెనుక బర్నబ సవులుఙ్‌ ‌రెబాజి తార్సు పట్నం సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","సవులుఙ్‌ రెబాజి దొహ్‌క్తిఙ్ ‌వన్నిఙ్ ‌అంతియోకయాదు తతాన్. వారు రిఎర్‌ ఉండ్రి ఏండు బానె మహి సఙమ్‌దికార్‌ వెట కూడిఃతారె మంద లోకాఙ్‌ దేవుణు మాటెఙ్‌ బోదిస్తార్. అంతియోకయాదునె, న‍మ్మితి వరిఙ్‌ క్రీస్తు లోకు ఇజి పేరు తొలిత ఇడెః ఆత మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","యా కాలమ్‌దు ప్రవక్తరు సెగొండార్‌ యెరూసలేమ్‌దాన్ ‌అంతియోకయదు వాతార్. ");
INSERT INTO kfc_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","వరి లొఇ అగబ ఇనికాన్‌ ఒరెన్ ‌దేవుణు ఆత్మదాన్‌ నిండ్రితాండ్రె రోమరాజు ఏలుబడిః కిని దేసమ్‌కాఙ్‌ విజు ఉండ్రి పెరి కరు వానాద్‌లె ఇజి వెహ్తాన్‌. (క్లవుదియ ఇని రాజు ఏలుబడిః కిత్తి కాలమ్‌దు యా కరు వాతాద్‌) ");
INSERT INTO kfc_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","అయావలె నమ్మితికార్ విజేరె యూదయదు బత్కిని నమ్మిని వరిఙ్ ‌సాయం పోక్తెఙ్‌ ఒడిఃబితార్. మాపు ఎసొ సీనాపొ నసొ సీనాప్‌ ఇజి వారు ఒడిఃబితార్. ");
INSERT INTO kfc_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","వరి సాయమ్‌కు వారు బర్నబని, సవులు వెట ‌పెద్దెలుఙబాన్‌ పోక్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","అయ కాలమ్‌దు హేరోదు రాజు సఙమ్‌ది వరిఙ్ ‌సెగొండారిఙ్‌ మాలెఙ్ కిదెఙ్ ‌మొదొల్‌స్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","యోహానుఙ్‌ దాద ఆతి యాకోబుఙ్‌ ‌కుర్దదాన్ ‌సపిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","యా సఙతి యూదురిఙ్‌ ఇస్టం ఆతాద్‌ ఇజి నెస్తాండ్రె హేరోదు రాజు పేతురుఙ్‌బా తొహ్సి ఇడ్ఃదెఙ్‌ ‌ఆడ్ర సిత్తాన్‌. యూదురి పులాఙ్‌ ఆఇ రొటెఙ్‌ తిని పండొయ్‌ ‌దినమ్‌కాఙ్‌ యాక జర్గితాద్. ");
INSERT INTO kfc_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","పేతురుఙ్‌ అరెస్టు కితారె వన్నిఙ్ ‌జేలిదు ఇట్తార్. జెలిదు ఇట్తారె వన్నిఙ్‌ కాప్‌ కిజి మండ్రెఙ్‌ పదహారు మణిసిర్‌ ‌జమానుఙ ‌ఒపజెప్తాన్. ఉండ్రె సుటు నాల్‌ఎర్ ‌మణిసిర్‌ కాపు మంజినార్. పస్క పండొయ్‌ ‌వెన్కా లోకాఙ్‌ ‌నడిఃమి తసి పేతురుఙ్‌ ‌తీర్‌పు తీరిస్తెఙ్‌ హేరోదు రాజు ఒడిఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ఆహె పేతురు జెలిదు మహాన్‌. గాని సఙమ్‌దికార్‌ వన్ని వందిఙ్ ‌గటిఙ దేవుణుదిఙ్‌ ‌పార్దనం కిజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","మర్‌సనాండిఙ్‌ పేతురుఙ్‌ ‌తీర్‌పు తీరిస్తెఙ్ ‌వెల్లి తన ఇజి హేరోదు రాజు ఒడిఃబిత మహాన్‌. అయ పొదొయ్‌ పేతురు రిఎర్‌ ‌జమానుఙ నడిఃమి రుండి గొల్‌స్కాణిఙ్ ‌తొహె ఆజి నిద్ర కిజి మహాన్‌. రిఎర్‌ జమానుఙ్‌ ‌వెల్లి కాపు మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","అయావలె వెటనె ఒరెన్ ‌దేవుణు దూత తోరె ఆతాన్. ఆ గది లొఇ జాయ్‌ నన్ని వెల్తుర్ ‌వాతాద్. దూత పేతురుఙ్‌ ‌పడఃకాదు డెఃయ్‌జి బేగి నిఙ్‌అ ఇజి వెహ్సి నిక్తాన్. వన్ని కిక్కాణిఙ్‌ గొల్‌స్కు ఊడ్ఃజి అర్తె. ");
INSERT INTO kfc_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","దూత వన్నివెట, “నీను నడుముదు తొహె ఆజి జోడ్కు తొడ్ఃగిఅ”, ఇహాన్‌. పేతురు అక్కెఙ్‌ ‌తొహ్తిఙ్ ‌దూత, “నీ పాత పిడిఃగ్జి నా వెనుక రఅ”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","పేతురు దూత వెనుక సొహాండ్రె జెలిదాన్‌ వెల్లి వాతాన్. గాని జర్గినిక నిజమొ ఆఏదొ ఇజి పేతురు నెస్‌ఏతాన్. యాక విజు దర్సనమ్‌దు సుడ్ఃజిన ఇజి ఒడిఃబితాన్. ");
INSERT INTO kfc_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","వారు ముందాల కాప్‌ కిని వరిఙ్ ‌డాట్సి వెనుకాది వరిఙ్‌బా డాట్సి పట్నం సొని ఇనుము గవుని డగ్రు వాతార్. వాతిఙ్‌ అదినె రే ఆతాద్. వారు సోసి వాజి ఉండ్రి వీది డాట్తిసొహి వెటనె దూత వన్నిఙ్‌ డిఃస్త సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","అయావలె, జర్గితికెఙ్‌ విజు నిజమె ఇజి పేతురు తెలి ఆతాన్. దేవుణు వన్ని దూతెఙ్ ‌పోక్తాండ్రె నఙి హేరోదురాజు బాణిఙ్‌ డిఃబిస్తాన్. యూదురు నఙి ఇనిక కిదెఙ్‌ ఒడిఃబిత్తారొ దన్ని లొఇహాన్‌బా డిఃబిస్తాన్‌ ‌ఇజి ఏలు నాను నిజం నెస్నా ఇజి ఒడిఃబితాన్. ");
INSERT INTO kfc_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","యాక నెస్తాండ్రె పేతురు, మార్కు ఇజి కూకె ఆని యోహానుఙ్‌ అయ్‌సి ఆతి మరియ ఇండ్రొ సొహాన్‌. బాన్‌ మంద లోకుర్ కూడిఃత మహారె‌ పార్దనం కిజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","పేతురు వెల్లి మహి సేహ్లదు కొత్తాన్. ఎయెన్‌ ఇజి వెండ్రెఙ్‌ ‌రోద ఇని పణి మణిసిబాన్‌ సొహాద్. ");
INSERT INTO kfc_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","అది పేతురు కంటం గుర్తు అస్తాదె గొప్ప సర్ద ఆతాద్. సేహ్ల రేఏండ ఉహ్‌క్సి సొహాదె, “పేతురు సేహ్ల డగ్రు నిహ మనాన్”, ఇజి మహి వరిఙ్‌ ‌వెహ్తాద్. ");
INSERT INTO kfc_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","వారు, “నిఙి వెరి మనాద్” ఇహార్‌. గాని అది మరి మరి వెహ్తిఙ్‌ వారు, “అహిఙ వన్ని దూత వాతాద్” ఇహార్. ");
INSERT INTO kfc_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","గాని పేతురు సేహ్లదిఙ్‌ కొత్సి మహాన్‌. వారు సొన్సి సేహ్ల రేతిఙ్‌ పేతురుఙ్‌ సుడ్ఃతారె గొప్ప బమ్మ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","మీరు జమ్‌న మండ్రు ఇజి పేతురు వరిఙ్‌ కియు సయ్‌న కితాండ్రె, దేవుణు వన్నిఙ్‌ ఎలాగ ‌జెలి లొఇహాన్‌ వెల్లి తత్తాన్ ‌ఇజి వరిఙ్ విజు వెహ్తాన్‌. యాక యాకోబుఙ్‌ని ‌మహి నమ్మితి వరిఙ్‌ వెహ్తు ఇహండ్రె మరి ఉండ్రి బాడ్డిదు సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","పెందాహిఙ్ ‌జేలిదు మహి జమాఙ్‌ణు గొప్ప గాబ్ర ఆతార్. పేతురు‌ ఇనిక అతాండ్రొ ఎంబె సొహండ్రొ ఇజి వారు గొప్ప గాబ్ర ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","పేతురుఙ్‌ రెబాజి దొహ్‌కిస్తెఙ్ ‌హేరోదు రాజు ఆడ్ర సిత్తాన్‌. గాని వారు ఎసొ రెబాతిఙ్‌బా తోర్‌ఏతాన్. అందెఙె హేరోదు రాజు కాప్‌ కిజిమహి జమాన్‌ఙ మరి మరి యా సఙతి వందిఙ్ వెన్‌బాజి పేతురు గెలస్త సొహాన్‌ కాక వ‍రి ముస్కు తీర్‌పు కితాండ్రె వరిఙ్ ‌సప్తెఙ్ ఆడ్ర సిత్తాన్‌. హేరోదు రాజు యూదయదాన్‌ కయ్‌సరియాదు సొహాండ్రె బాన్‌ సెగం కాలం బత్కితాన్. ");
INSERT INTO kfc_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","హేరోదురాజు తూరు పట్నమ్‌ది వరి ముస్కు, సీదోను పట్నమ్‌దివరి ముస్కు గొప్ప కోపం కల్గిజి మహాన్‌. అందెఙె వారు ఉండ్రె మన్సుదాన్‌ వాతారె రాజు ఇండ్రొణి అతికారి ఆతి ఒరెన్‌ బ్లాస్తు ఇని వన్నిఙ్‌ వరి పడఃకాదు కూడుఃప్తార్, రాజు వరి ముస్కు సమదనం ఆదెఙ్‌ ఇజి. ఎందనిఙ్‌ ‌ఇహిఙ రాజు దేసమ్‌దానె వరిఙ్‌ పంట దొహ్‌క్సి మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ఏర్‌పాటు కిత్తి రోజు, హేరోదు రాజు, రాజుర్‌ తొడ్ఃగిని సొక్కెఙ్‌ పొర్‌పాతాండ్రె రాజు కుర్సిదు బస్తాండ్రె వాతివరివెట మీటిఙ్‌దు వర్గితాన్. ");
INSERT INTO kfc_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","అక్క వెహారె లోకుర్, వీండ్రు ఒరెన్‌ దేవుణు లెకెండ్ ‌వెహ్సినాన్, లోకు లెకెండ్ ‌ఆఏన్ ‌ఇజి గగోల్‌ కిత్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","రాజు యాక వెహిఙ్ ‌దేవుణుదిఙ్ ‌స్తుతి కిఎతాన్. వెటనె దేవుణు దూత వన్నిఙ్ ‌ఉండ్రి కస్టం పుటిస్తిఙ్‌ వాండ్రు పిడుఃకు ఆజి సాతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","గాని దేవుణు సువార్త మరి మంద లోకు వెహార్‌కాక దేవుణు ముస్కు నమకం ఇట్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","బర్నబని సవులు యెరూసలేమ్‌దు సొన్సి వరి పణిఙ్‌ వీస్తారె మార్కు ఇజి కూకె ఆని యొహానుఙ్‌ కూడుఃప్తారె యెరూసలేమ్‌దాన్‌ మర్‌జి వాతార్. ");
INSERT INTO kfc_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","అంతియోకయాదు మహి సఙమ్‌దు, సెగొండార్ ‌ప్రవక్తరు, మరి సెగొండార్ ‌దేవుణు మాటెఙ్‌ బోదిసినికార్ ‌మహార్‌. వారు ఎయెర్‌ ఇహిఙ, బర్నబ, నిగెర్ ‌ఇజి కూకె ఆని సిమెయోను, కురేనదికాన్ ‌లూకియ, హేరోదు అంతిపాస్. ");
INSERT INTO kfc_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","వీరు దేవుణుదిఙ్‌ పార్దనం కిజి ఉపాస్‌ కిజి మహివలె దేవుణు ఆత్మ వెహ్తాన్‌, “బర్నబెఙ్‌ని సవులుఙ్‌ నాను కూక్తి పణి వందిఙ్ ‌మీరు ఏర్‌పాటు కిదు”. ");
INSERT INTO kfc_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","వెహ్తిఙ్, సఙం ఉపాస్‌ మంజి పార్దనం కితారె వరి ముస్కు కిక్కు ఇట్తారె, దేవుణు వెహ్తి పణి వందిఙ్‌ పోక్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","దేవుణు ఆత్మ పోక్తిఙ్‌ బర్నబని సవులు డిఃగు సమ్‌దరం డగ్రు మన్ని సెలూకిన ఇని పట్నం సొహరె ఓడఃదు ఎక్తారె కుప్ర ఇని ద్వీపుదు సొహార్. ");
INSERT INTO kfc_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","వారు సలామి ఇని పట్నమ్‌దు సొహరె బాన్‌ మహి యూదురి మీటిఙ్‌ కిని ఇల్కాఙ్‌ ‌సొహరె దేవుణు మాటెఙ్‌ సాటిసి మహార్‌. మార్కు ఇజి కూకె ఆని యోహాను వరివెట వరిఙ్ తోడుః లెకెండ్‌ మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","వారు అయ ద్వీపు విజు పయ్‌నం కితారె పాపు ఇని పట్నమ్‌దు వాతార్. బానె వారు బర్‌యేసు ఇజి కూకె ఆని ఒరెన్‌ యూద వన్నిఙ్ ‌సుడ్ఃతార్. వాండ్రు ఒరెన్ సెట్ణికాన్. వాండ్రు అబద్దం మాటెఙ్‌ ‌వెహ్ని ప్రవక్త. దేవుణు మాటెఙ్‌ ‌వెహ్ని ప్రవక్త ఇజి నా‍టిసినాన్ గాని ఆఏన్. ");
INSERT INTO kfc_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","వాండ్రు రోమ గవర్నరు ఆతి సెర్గిపవులు వెట మహికాన్. అయ రోమ గవర్నరు ఇహిఙ వాండ్రు తెలివి మన్నికాన్. వాండ్రు దేవుణు మాటెఙ్‌ వెనా ఇజి బర్నబెఙ్‌ని సవులుఙ్‌ కూక్‌పిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","గాని అయ సెట్ణికాన్ వరిఙ్‌ అడ్డు కిత్తాన్‌. (గ్రీకు బాసదు వన్ని పేరు ఎలీమ) రోమ గవర్నరు ఆతి సెర్గిపవులు యేసుప్రబు ముస్కు నమకం ఇడ్ఃఏండాదెఙ్ ‌సుడ్ఃతాన్, ‌యా గార్డి విదె కినికాన్. ");
INSERT INTO kfc_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","10","అయావలె సవులు (వన్నిఙ్‌ పవులు ఇని పేరుబా మహాద్‌) దేవుణు ఆత్మదాన్‌ నిండ్రితాండ్రె ఎలీమేఙ్ తినాఙ్‌ ‌సుడ్ఃజి వెహ్తాన్‌, “నీను సయ్తాన్ పొటాదికాన్, నీతి నిజాయితి ఆతి విజు దన్నిఙ్‌ పడ్ఃఇకి. నీను పూర్తి సెఇకి, గొప్ప మొసెం కినికి. నిజమాతి దేవుణు మాటెఙ్‌ నిజం ఆఇకెఙ్ ‌ఇజి తోరిసిని. ");
INSERT INTO kfc_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ఇదిలో, దేవుణు ఏలు నిఙి తీర్‌పు సీజి సిక్స సీజినాన్. నీను సెగం కాలం గుడ్డి ఆజి పొద్దుదిఙ్‌ సుడ్ఃదెఙ్‌ అట్‌ఏండ ఆనిలె” వెటనె వాండ్రు గుడ్డి ఆతాన్. గోయ్‌ న‍న్ని గాందుదాన్ వన్ని కణెకెఙ్‌ సీకటి ఆతె. ఎయెర్‌బా కికాఙ్‌ అసి బుల్లెయ్‌ కిబిస్నారా ఇజి అతాల్ ‌ఇతాల్ ‌బూలాజి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","అయ రోమ గవర్నరు జర్గితిక సుడ్ఃతివలె యేసుప్రబు ముస్కు నమకం ఇడ్తాన్. ఎందనిఙ్‌ ఇహిఙ యేసుప్రబు - వందిఙ్ బోద ‌వెంజి బమ్మ ఆతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","వెనుక పవులుని వన్నివెట మహికార్‌ ఓడః ఎక్తారె పాపుదాన్‌ పంపులియాదు మన్ని పెర్గ ఇని పట్నం సొహార్. బానె యోహాను వరిఙ్ ‌డిఃస్తారె యెరూసలేమ్‌దు మర్‌జి సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","వారు పెర్గు పట్నమ్‌దాన్‌ సోత్తారె పిసిదియ దేసమ్‌దు మన్ని అంతియోకయాదు సొహార్. బానె వారు విస్రాంతి దినమ్‌దు యూదురి మీటిఙ్‌ ఇండ్రొ సొహరె బస్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","మోసె సిత్తి రూలుదాన్, ప్రవక్తరు రాస్తి మాటెఙదాన్ ‌సెగం సద్‌వితి వెనుక మీటిఙ్‌ ఇండ్రొణి అతికారిఙు ‌పవులుని బర్నబ వెట. “దాదారండె, లోకాఙ్‌ బోదిస్తెఙ్ ఇని మాటెఙ్‌బా ‌మహిఙ వెహ్తు” ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","అయావలె పవులు నిఙితండ్రె విజేరె అలెజి మండ్రు ఇజి కియు సయ్‌న కితాండ్రె వరివెట వెహ్తాన్‌, “ఇస్రాయేలు లోకాండె, దేవుణుదిఙ్‌ తియెల్‌ ఆని యూదురు ఆఇ లోకాండె, నా మాట వెండ్రు. ");
INSERT INTO kfc_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","మా ఇస్రాయేలు లోకు పార్దనం కిని దేవుణు, మా అనిగొగొరిఙ్, వన్ని లోకుర్‌ ఇజి మండ్రెఙ్‌ ఏర్‌పాటు కిత్తాన్‌. వారు అయ్‌గుప్తు దేసమ్‌దు ఆఇదేసెమ్‌దివరిలెకెండ్‌ మహివలె వరిఙ్‌ నండొ లోకు ఎల్పిస్తాన్. వెనుక గొప్పసత్తుదాన్‌ వరిఙ్ ‌అబ్బెణాన్ ‌గెల్‌పిసి తత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","రమారమి నలపయ్ ‌పంటెఙ్ ‌వారు బిడిఃమ్‌ బూమిదు సొన్సి మహివలె దేవుణు వరిఙ్ ఓరిసి మహా‍న్. ");
INSERT INTO kfc_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","కనాను దేసమ్‌దు మహి ఏడు జాతిఙాణి వరిఙ్ ‌విదెం కిజి గెల్‌పిస్తాండ్రె వరిఙ్‌ పాడు కిజి వరి దేసెం వన్ని లోకాఙ్‌ అక్కు లె‍కెండ్ ‌సిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","యాకెఙ్‌ విజు నాల్గి వందెఙ్‌ యబాయ్‌ పంటెఙాణ్ ‌జర్గితె. వెనుక సముయేలు ఇని ప్రవక్త వాతి కాలమ్‌దాక వరిఙ్‌ ఏలుబడిః కిదెఙ్‌ తీర్పు తీరిస్ని నెయ్కి లోకాఙ్ ‌దేవుణు ఏర్‌పాటు కిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","దన్ని వెనుక ఇస్రాయేలు లోకుర్ ‘మఙి ఉండ్రి రాజుఙ్‌ ఏర్‌పాటు కిఅ’ ఇజి వెహ్తిఙ్‌ దేవుణు వరిఙ్‌ బెన్యమిను కుటుమ్‌దికాన్‌ ‌కీసు మరిసి ఆతి సవులుఙ్‌ నలపయ్ పంటెఙ్‌ ఏలుబడిః కిదెఙ్ ‌ఏర్‌పాటు కిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","వెనుక సవులుఙ్‌ ‌లాగితాండ్రె దావీదుఙ్ ‌రాజువజ దేవుణు ఏర్‌పాటు కిత్తాన్‌. దావీదు వందిఙ్‌ దేవుణు ఇని సాసి వెహ్తాన్ ఇహిఙ, ‘యెసెయి మరిసి ఆతి దావీదు ఇహిఙ నాను ఒడిఃబిని లె‍కెండ్ ఒడిఃబిజినాన్. నాను ఇస్టం ఆనికెఙ్ వాండ్రు ఇస్టం ఆజినాన్. వాండ్రు ఇనిక కిదెఙ్‌ ఇజి నాను కోరిజినానొ అక్కెఙ్‌ వాండ్రు కినాన్‌'. ");
INSERT INTO kfc_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","యా దావీదు పొటెఙాణిఙె మా అనిగొగొర్‌ వెట దేవుణు ఒట్టుకిత్తి లెకెండ్‌ ఇస్రాయేలు లోకాఙ్ తప్రిస్నికాన్‌ ‌ఆతి యేసుఙ్‌ పుటిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","యేసు వాని ముందాల యోహాను ఇస్రాయేలు లోకాఙ్‌ బోదిస్తాన్. ఇనిక ఇహిఙ ‘విజేరె పాపమ్‌కు ఒప్పుకొడ్ఃజి డిఃసిసీజి బాప్తిసం లాగె ఆదెఙ్‌’ ఇజి. ");
INSERT INTO kfc_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","యోహాను వన్ని పణి వీస్నివలె లోకాఙ్‌ వెహ్తాన్‌, ‘నాను ఎయెన్‌ ‌ఇజి మీరు ఒడిఃబిజినిదెర్‌? మీరు ఒడిఃబిజినికాన్ ఆఏన్‌ నాను. మీరు ఎద్రు సుడ్ఃజి మహికాన్‌ ‌వెన్కా వాజినాన్. వన్ని జోడ్కుబెల్టు కూతెఙ్‌బా నాను ఏపటిదిక ఆఏ'. ");
INSERT INTO kfc_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","తంబెరిఙాండె, అబ్రాహాం కుటుమ్‌దికిదెరా, దేవుణుదిఙ్‌ తియెల్‌ ఆనికిదెరా, దేవుణు లోకాఙ్‌ ఎలాగ ‌గెల్పిస్నాన్లె ఇజి కబ్రు దేవుణు మఙి విజేరిఙె పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ఎందనిఙ్‌ ఇహిఙ యెరూసలేమ్‌దు మహికార్, వరి అతికారి లోకుర్, యేసు, దేవుణు పోక్తాన్‌ ‌ఇజి గుర్తు అస్‌ఏతార్. విజు విస్రాంతి దినమ్‌దు వారు ప్రవక్తరు రాస్తి మాటెఙ్‌ సద్‌వితార్‌ గాని అర్దం కి‌ఏతార్. గాని ‌ప్రవక్తరు ముందాల్నె వెహ్తి అయ మాటెఙ్‌ వ‍జ‍ జర్పిస్తార్. ఎలా‍గ ఇహిఙ యేసుఙ్‌ సప్తెఙ్‌ వారు తీర్పు కిత్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","యేసుఙ్‌ తీర్పు కిని వ‍న్నిడగ్రు త‍సి సావుదిఙ్‌ ‌తగితి తప్పు ఇనికబా కిఏతా‍న్ ఇజి సుడ్ఃతిఙ్‌బా గాని విన్నిఙ్ సిలువ డెఃయ్‌జి సప్తు ఇజి వారు పిలాతుఙ్ బతిమాలితార్. ");
INSERT INTO kfc_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","యేసుఙ్‌ యూదురు ఇనికెఙ్‌ ఇనికెఙ్‌ కినారొ ఇజి ప్రవక్తరు రాస్తి మహికెఙ్ విజు వారు కిత్తి వెనుక వన్ని సిసూర్‌ వన్ని పీనుగుదిఙ్ సిలువదాన్‌ డిప్తారె సట్టుపణుకుదు దొలిస్తి సాలమ్‌ లొఇ ఇడ్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","గాని దేవుణు యేసుఙ్‌ ‌సాతి వరిబాణిఙ్ నిక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","గలీలయదాన్‌ యెరూసలేమ్‌దు వన్నివెట సొన్సి మహి వరిఙ్ ‌యేసు నండొ రోస్కు తోరె ఆతాన్. వారు ఏలు మాటు ఇస్రాయేలు లోకాఙ్‌ నడిఃమి యేసుఙ్‌ సాసిర్. ");
INSERT INTO kfc_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","ఏలు మాపు మిఙి సువార్త వెహ్సినాప్. అయ సువార్త ఇనిక ఇహిఙ దేవుణు యేసుఙ్‌ ‌సాతి వరిబాణిఙ్ ‌నిక్తాన్. యాక మా అనిగొగొర్‌ వెట దేవుణు కిత్తి ఒట్టు. వరిఙ్‌ కిత్తి ఒట్టు వరి పొటెఙాణికార్ ‌ఆతి మా వందిఙ్ ఏలు జర్గితాద్. “నీను నా మరిన్, నేండ్రు నాను నీ బుబ్బ ఆత మన్న”, ఇజి కీర్తన రుండిదు రాస్తి మనిక దిన్నివందిఙె. ");
INSERT INTO kfc_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","దేవుణు వన్నిఙ్‌ సాతి వరిబాణిఙ్ ‌నిక్తాన్. ‌వన్ని పీనుగు సబ్‌ఏద్ ‌ఇజి వ‍న్నివందిఙ్ ‌దేవుణు మాటాదు ఈహు రాస్త మనాద్. “దావీదుఙ్ ‌సీనా ఇజి ఒట్టు కిత్తి నెగ్గి దీవెనమ్‌కు నాను మిఙి తప్‌ఏండ సీనా”. ");
INSERT INTO kfc_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","కీర్తన పుస్తకమ్‌దు మరి రాస్త మనాద్. అక్క ఇనిక ఇహిఙ “నీను పోక్తివ‍న్ని పీనుగు సబ్‌జి సొండ్రెఙ్‌ ‌నీను సరి సిఇ”. ");
INSERT INTO kfc_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","అహిఙ దావీదురాజు దేవుణు ఏర్‌పాటు కిత్తి వజ వన్ని తరమ్‌ది వరిఙ్ సేవ కిజి వీస్తాండ్రె సాత సొహాన్‌. వన్ని అనిగొగొరిబాన్ ‌వన్నిఙ్‌బా ముస్తార్. వన్ని పీనుగు సబిత సొహాద్. ");
INSERT INTO kfc_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","గాని సాతి వరిబాణిఙ్‌ దేవుణు నిక్తి యా యేసు పీనుగు సబ్‌జి సొన్‌ఏతాద్. ");
INSERT INTO kfc_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","అందెఙె తంబెరిఙాండె, మిఙి వెహ్సిని సువార్త యా‍కాదె. పాపమ్‌కు సెమిస్తెఙ్ యేసు అట్నాన్. యాక మీరు నెగ్రెండ నెస్తెఙ్‌ ఇజి నాను ఆస ఆజిన‍. ");
INSERT INTO kfc_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","మోసె సిత్తి రూలుఙ్‌ ఒరెన్‌ వన్నిఙ్ ‌వన్ని పాపమ్‌కాణ్‌ డిఃబిస్తెఙ్ ‌అట్ఉ. గాని యేసు ముస్కు నమకం ఇడ్ని వరిఙ్‌ వరి పాపమ్‌కాణ్ యేసు పూర్తి డిఃబిస్నాన్. ");
INSERT INTO kfc_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ప్రవక్తరు వెహ్తివజ మిఙి రెఏండ సుడ్ఃదు. వారు ఇనిక వెహ్తార్‌ ఇహిఙ. ");
INSERT INTO kfc_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“సుడ్ఃదు, వెక్రిసినికిదెరా, మీరు బమ్మ నిదెర్‌లె గాని పాడాఃజి సొనిదెర్లె. ఎందనిఙ్‌ ‌ఇహిఙ మీ కాలమ్‌దు నాను ఉండ్రి బమ్మాని పణి కిన. గాని అయ పణి వందిఙ్ ఎయెర్‌బా వెహ్తిఙ్‌బా మీరు నమ్ఇదెర్”. ");
INSERT INTO kfc_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","పవులుని బర్నబ యూదురి మీటిఙ్‌ ఇండ్రొణిఙ్ ‌సోత్తిఙ్, “వాని విస్రాంతి దినమ్‌దు వాజి యా మాటెఙ్‌ మఙి మరి వెహ్సి సిదాట్”, ఇజి బానె కూడిఃతి మహికార్‌ ‌వరిఙ్‌ బతిమాలితార్. ");
INSERT INTO kfc_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","మీటిఙ్‌ ‌ఆతి వెనుక నండొండార్ ‌యూదురు, నండొండార్ ‌యూద మతమ్‌దు కూడిఃతి యూదురు ఆఇ బక్తి మన్నికార్‌ పవులుని బర్నబ వెట సొహార్. పవులు, బర్నబ వరివెట వర్గితార్. దేవుణు మిఙి తోరిస్ని ద‍యాదర్మమ్‌దిఙ్ డిఃస్‌ఏండ ఎలాకాలం నడిఃదు ఇజి పవులుని బర్నబ వరిఙ్ ఉసార్‌ కిబిస్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","మరి వాతి విస్రాంతి దినమ్‌దు పట్నమ్‌దికార్‌ విజేరె సొహి లె‍కెండ్ మంద లోకుర్‌ దేవుణు మాట వెండ్రెఙ్‌ ఇజి యూదురు మీటిఙ్‌ కిని ఇండ్రొ కూడ్ఃజి వాతార్. ");
INSERT INTO kfc_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","పవులు వెహ్ని మాటెఙ్‌ వెండ్రెఙ్‌ ‌మంద లోకుర్ కూడ్ఃజినార్‌ ‌ఇజి సుడ్ఃతారె ‌యూదురు గోస ఆతార్. వారు పవులు వెహ్తి మాటదిఙ్‌ మర్‌జి వెహ్తరె వన్నిఙ్‌ దూసలాడితార్. ");
INSERT INTO kfc_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","అయావలె పవులు, బర్నబ తియెల్‌ ఆఏండ వెహ్తార్‌, “దేవుణు మాట ముందాల మిఙి వెహ్తెఙ్‌వలె. అందెఙె మాపు ముందాల మిఙి వెహ్తాప్. గాని మీరు, ఎలాకాలం బత్కిని బ‍త్కు దొహ్‌క్నికాప్‌ ఆఏప్ ఇజి మిఙి మీరె నెక్సి పొక్తిదెరె తీర్పు కిజినిదెర్‌ కక మాపు మిఙి డిఃసి యూదురు ఆఇ లోకుర్‌ బాన్ సొన్సినాప్. ");
INSERT INTO kfc_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","దేవుణు మఙి సిత్తి ఆడ్ర ఇనిక ఇహిఙ, ‘యూదురు ఆఇ వరిఙ్ ‌ఉండ్రి జాయ్‌ వజ మిఙి ఇట్తా మన్న. ఎందనిఙ్‌ ‌ఇహిఙ యా లోకమ్‌దు మన్ని విజు లోకాఙ్, వరి పాపమ్‌కాణ్ ‌వాని సిక్సదాన్‌ ‌గెల్‌పిస్తెఙ్’ ‌ఇజి వెహ్త మనాన్. ");
INSERT INTO kfc_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","యూదురు ఆఇ లోకుర్ విజేరె యా మాటెఙ్‌ వెహారె సర్ద ఆతార్. దేవుణు మాటెఙ్‌ ‌ఎస్సొనొ నెగ్గికెఙ్‌ ఇజి వారు వెహ్తార్‌. ఎలాకాలం బత్కిని బత్కుదిఙ్ ‌ఏర్‌పాటు ఆతికార్‌ విజేరె దేవుణు మాటెఙ్‌ నమ్మితార్. ");
INSERT INTO kfc_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","దేవుణు మాట అయ దేసమ్‌దు విజు సాటె ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","గాని యూదురు ఆ పట్నమ్‌దు బక్తి మన్ని పల్కుబడిః మనికెఙ్‌ ఆతి అయ్‌లి కొడొఃక వెట, ‌పెరికార్‌ ఆతి మొగవరి వెట‌ వర్గిజి కోపం రేప్తారె పవులు ముస్కు, బర్నబ ముస్కు ‌మాలెఙ్ కితారె వరిఙ్ ‌అయా పట్నమ్‌దాన్‌ నెక్త పొక్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","అందెఙె పవులుని బర్నబ, వరి కాల్కాణి దూల్లి అయ పట్నమ్‌ది వరి ఎద్రు దుల్‌ప్తార్. ఎందనిఙ్‌ ‌ఇహిఙ వా‍రు దేవుణు మాట నెక్సిపొక్తిఙ్ వరిఙ్‌ వాని సిక్స వారె తపిస్తార్ ఇజి సాసి లెకెండ్ ‌మండ్రెఙ్ ‌ఇజి. వెనుక వారు ఇకోనియ ఇని పట్నమ్‌దు సొహార్. ");
INSERT INTO kfc_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","అంతియోకయాదు మన్ని సిసూర్‌ ఎసొనొ సర్ద ఆతార్. దేవుణు ఆత్మ వరి ముస్కు పూర్తి వాతాద్. ");
INSERT INTO kfc_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","పవులుని బర్నబ కూడ్ఃజి ఇకొనియా‍దు సొహరె అంతియోకయాదు కిత్తిలె‍కెండ్ యూదురు మీటిఙ్‌ కిని ఇండ్రొ సొహార్. వారు నెగ్రెండ బోద వెహ్తిఙ్‌ ‌నండొండార్ ‌యూదురు, నండొండార్ ‌యూదురు ఆఇకార్‌బా ‌నమ్మితార్. ");
INSERT INTO kfc_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","గాని నమ్మిఇకార్‌ ‌యూదురు, యూదురు ఆఇ వరిఙ్ ‌రేప్తారె అపొస్తురుఙ ముస్కు కోపం పుటిస్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","గాని పవులు, బర్నబ నండొ రోస్కు బానె మహార్‌. యేసువందిఙ్ ‌దయ్‌రమ్‌దాన్‌ వర్గితార్. వారు ప్రబు దయాదర్‌మమ్‌ వందిఙ్‌ వెహ్తి మాటెఙ్‌ ‌నిజం ఇజి ప్రబు విజెరిఙ్‌ ‌తోరిస్తాన్. ఎలాగ ‌ఇహిఙ బమ్మాతి పణిఙ్ బమ్మాతి గుర్తుఙ్‌ ‌కిదెఙ్‌ ‌పవులుఙ్‌ బర్నబెఙ్ ‌సత్తు సిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","అయ పట్నమ్‌దు మహి లోకుర్ ‌రుండి గుంపుఙ్ ఆతార్. సెగొండార్ ‌యూదురు పడఃకాద్, మరి సెగొండార్‌ అపొస్తురి పడఃకాద్. ");
INSERT INTO kfc_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","అయావలె సెగొండార్ ‌యూదురు ఆఇకార్, మరి సెగొండార్‌ యూదురు, యూదురి అతికారిఙు ‌వెట కూడ్ఃజి అపొస్తురుఙ్‌ ‌అసి వరిఙ్ ‌సిగు కిజి పణుకుఙాణిఙ్ ‌డెఃయ్‌జి సప్తెఙ్‌వలె ఇజి ఒడిఃబిజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","అపొస్తురు అయ సఙతి నెస్తారె లుకయొనియాదు మహి లుస్‌త్ర, దెర్‌బ ఇని పట్నమ్‌కాణ్, వన్కా సురుల మన్ని దేసమ్‌కాఙ్ ‌ఉహ్క్‌సి సొహరె అబ్బె సువార్త సాటిస్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","లుస్‌త్ర ఇని పట్నమ్‌దు, నడిఃదెఙ్‌ అట్‌ఇ సొట వాండ్రు ఒరెన్‌ మహాన్‌. వాండ్రు పుట్తిబాణిఙ్‌ మొదొల్సి సొటాదికాన్ ఆతండ్రె ఎసెఙ్‌బా నడిఃదెఙ్‌ అట్‌ఏండ బసినె మంజినాన్. ");
INSERT INTO kfc_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","పవులు బోదిసి మహిఙ్‌ వాండ్రు వెంజి మహాన్‌. పవులు వన్నిఙె సుడ్ఃతిఙ్‌ ‌నెగెండ్‌ ‌ఆన ఇజి వన్నిఙ్ నమకం పుట్సినాద్‌ ఇజి నెస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","అయావలె పవులు వన్నిఙ్, “నిఙ్అ, నీ పాదమ్‌కు బూమిదు మొప్సి ‌నిల్‌అ”, ఇజి డటం వెహ్తిఙ్‌ అయ సొటాదికాన్ లిట్నె నిఙితండ్రె డాట్తెఙ్‌ మొదొల్‌స్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","పవులు కిత్తి బమ్మాతి పణి సుడ్ఃతారె బాన్‌ మహి లోకుర్‌ లుకోనియ బాసాదు గగోలాతార్‌. “దెయమ్‌కు లోకు లెకెండ్ ఆతెనె మాడగ్రు డిఃగ్‌జి వాతె”, ఇజి డటం గగోలాతార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","బర్నబెఙ్ ‌బ్రుహస్‌పతి ఇజి పేరు ఇట్తార్. నండొ బోద వెహ్తి వందిఙ్‌ పవులు ‌హెర్మ ఇజి పేరు ఇట్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","పట్నం వెల్లి మహి బ్రుహస్‌పతి గుడిఃది పుజేరి వాతండ్రె డాఃకుఙ్, పూఙుదండెఙ్ ‌అస్తాండ్రె పట్నం వెల్లి మహి సేహ్ల డగ్రు తత్తాన్. మంద లోకు కూడ్ఃజి వాతారె పూజ కినాట్‌ ఇజి అయ పుజేరిని, కూడిఃతి మహి లోకుర్ ‌ఒడ్ఃబితార్. ");
INSERT INTO kfc_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","బర్నబని పవులు యాక నెస్తారె వారు కిని ప‍ణిదిఙ్ ఒప్పుకొడ్ఃఎప్ ఇజి తోరిసిని వందిఙ్ వరి సొక్కెఙ్ ‌పాతెఙ్ ‌కిస్తారె లోకురి ‌నడిఃమిదు ఉహ్‌క్సి సొహరె డటం వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“తంబెరిఙాండె, మీరు ఎందనిఙ్‌ ‌ఈహు కిజినిదెర్‌? మాపుబా మీ నన్ని లోకునె. మీరు యా పణిదిఙ్‌ రెఇకెఙ్‌‌ డిఃసిసీజి ఆగాసం, బూమి, సమ్‌దరం, బాన్‌ ‌మన్ని విజు వనకాఙ్ ‌పుటిస్తి బత్కిజి మంజిని దేవుణుదిఙ్‌ నమ్మిదు ఇజి మిఙి సువార్త వెహ్సినాప్. ");
INSERT INTO kfc_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","గడ్డిఃస్తి కాలమ్‌దు విజు జాతిఙ్ ‌వరిఙ్‌ వరిఙ్ ఇస్టమాతి వ‍న్కాఙ్ పొగిడిఃజి మాడిఃస్తెఙ్‌ దేవుణు డిఃస్త సిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","అహిఙ్‌బా దేవుణు ఆగాసమ్‌దాన్‌ మిఙి పిరు, ఎమేణివేల పంట అయావలె కనికారం ఆజి సీజినాన్. తక్కు సిల్లెండ బోజనం సీజినాన్. మీ మన్సుదిఙ్‌ సర్ద కిబిసి ‌పోస కిజినాన్. ఈహు వాండ్రు ఎలాగ మహ్తి దేవుణు ఇజి లోకాఙ్‌ తోరిస్తాన్”. ");
INSERT INTO kfc_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","అపొస్తురు యాలెకెండ్ వెహ్తిఙ్‌బా వారు ‌వి‍రిఙ్ పూజ‍ కిఏండ ఆదెఙ్‌ ఇజి లోకురిఙ్‌ అడ్డు కిదెఙ్ గొప్ప కస్టం ఆతాద్. ");
INSERT INTO kfc_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","అయావలె అంతియోకయదాన్, ఇకొనియదాన్ ‌సెగొండార్‌ యూదురు వాతారె వరి మాటెఙాణిఙ్ నండొ లోకాఙ్‌ వరి పడఃకాదు కూడుఃప్తార్. కూడుఃప్తారె, పవులు ముస్కు పణుకుఙ్‌ డెఃయ్తా‍ర్. వాండ్రు సాతాన్‌ ఇజి ఒడిఃబిత్తారె పట్నం వెల్లి వన్నిఙ్ ‌ఈడ్డిస్తారె బానె డిఃస్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","గాని సిసూర్‌ వన్ని సురుల కూడిఃతి మహివలె పవులు నిఙితండ్రె పట్నమ్‌ లొఇ మర్‌జి సొహాన్‌. మహ్స నాండిఙ్‌ పవులు, బర్నబ కూడిఃతారె దెర్‌బ ఇని పట్నమ్‌దు సొహార్. ");
INSERT INTO kfc_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","పవులుని బర్నబ దెర్‌బ ఇని పట్నమ్‌దు సువార్త బోదిస్తార్. నండొ లోకుర్‌ యేసుప్రబుఙ్‌ నమ్మితార్. వెనుక పవులుని బర్నబ, లుస్‌త్ర, ఇకొనియ, అంతియొకయాదు మర్‌జి వాతార్. ");
INSERT INTO kfc_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","వాతారె, ఎమేణి పట్నమ్‌ది వ‍రిఙ్ బానె సిసూరిఙ్‌ ఉసార్‌ కిబిస్తార్. “మీ నమకం డిఃస్‌ఏండ మండ్రు. మాటు నండొ మాలెఙ్ ఓరిసి దేవుణు రాజెమ్‌దు సొండ్రెఙ్‌ వలె”, ఇజి మరి మరి పణిసి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","పవులు, బర్నబ విజు సఙమ్‌కాఙ్‌ పెద్దెల్‌ఙ ‌ఏర్‌పాటు కితారె ఉపాస్‌ మంజి పార్దనం కిజి, వారు నమ్మితి దేవుణుదిఙ్‌ వరిఙ్‌ ఒపజెప్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","వెనుక పిసిదియ దేసెం డాట్తారె పంపులియాదు వాతార్. ");
INSERT INTO kfc_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","పెర్గ ఇనిబాన్‌ దేవుణు మాటెఙ్‌ ‌బోదిసి వెనుక అతలియ పట్నమ్‌దు డిఃగ్‌జి సొహార్. ");
INSERT INTO kfc_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","అబ్బెణిఙ్ ‌ఓడః ఎక్తారె వారు మొదొహి సోత్తి సొహి అంతియొకయాదు మర్‌జి వాతార్. యా అంతియొకయాదునె దేవుణు పణివందిఙ్, వన్ని దయాదర్మమ్‌దిఙ్ ఒపజెపె ఆతార్. అయ పణి వీస్తారె ఏలు బానె మర్‌జి వాతార్. ");
INSERT INTO kfc_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","మర్‌జి వాతారె ‌సఙమ్‌ది వరిఙ్ విజెరిఙ్‌ ‌కూడుఃప్తారె, దేవుణు వరి వెటనె కిత్తి పణిఙ్ విజు వెహ్తార్‌. యూదురు ఆఇకార్‌ ‌దేవుణుదిఙ్‌ నమ్మిదెఙ్‌ వాండ్రు ఎలాగ సరి సిత్తాన్‌‌ ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","వారు నండొ కాలం బానె మంజి సిసూరి వెట బత్కిత్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","సెగొండార్‌ యూదయ దేసెమ్‌దికార్ ‌అంతియొకయాదు వాతార్. వారు అబ్బె మన్ని లోకాఙ్‌ ‌ఈహు నెస్పిస్తెఙ్‌ మొదొల్‌స్తార్. ఇనిక ఇహిఙ మోసె సిత్తి రూలు వజ సునతి కిబె ఆఏండ మహిఙ మీరు సిక్సదాన్‌ గెలిస్తెఙ్ అట్ఇదెర్ ‌ఇజి నెస్‌పిస్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","పవులుని బర్నబ యా సఙతి వందిఙ్‌ కూడిఃతారె యూదయ దేసెమ్‌ది వరివెట నండొ వర్గిజి ఆహె తర్కిస్తార్. అందెఙె యా మాటెఙ వందిఙ్‌ పవులు, బర్నబ, వరివెట అంతియొకయ దేసమ్‌దు మన్ని మరి సెగొండార్‌ ఎక్కు యెరూసలేమ్‌దు సొన్సి అబ్బె మన్ని అపొస్తురుఙ, పెద్దెల్‌ఙ డగ్రు సొండ్రెఙ్‌ వలె ఇజి తీర్మానం ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ఆహె అయ సఙమ్‌ది లోకుర్‌ వరిఙ్ ‌పోక్తార్. వారు పినెకె, సమరియ ఇని దేసమ్‌క సరి సొహరె బానె మహి వ‍రివెట యూదురు ఆఇకార్‌ దేవుణు దరోట్ మహ్త వాతారె దేవుణుదిఙ్‌ నమ్మిజినార్ ‌ఇజి విజు వెహ్తరె సొహార్. అబ్బె మహి నమ్మితికార్ ‌యాక వెహారె గొప్ప సర్ద ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","వారు యెరూసలేమ్‌దు వాతివలె ‌సఙమ్‌దికార్, పెద్దెలుఙు, అపొస్తురు విజేరె వరిఙ్ గవ్‌రం సీజి బసె కిత్తార్‌. దేవుణు వరివెట కిత్తి పణిఙ వందిఙ్‌ విజు వారు వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","గాని బాన్‌ పరిసయ్‌రు ఇని జటుదు మహి నమ్మితికార్ ‌సెగొండార్‌ నిఙ్‌జి వెహ్తార్‌, “నమ్మిత్తి వరి లొఇ యూదురు ఆఇ లోకుర్‌ సునతి కిబె ఆదెఙ్‌ వలె. మోసె సిత్తి రూలుదు మన్ని ఆడ్రెఙ్‌ విజు వారు ఒప్పుకొడ్ఃజి ఆహె కిదెఙ్‌వలె ఇజి మాటు వరిఙ్‌ వెహ్తెఙ్‌వలె”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","అయావలె అపొస్తురు, పెద్దెలుఙు యా సఙతి వందిఙ్‌ ఆలోసనం కిదెఙ్ ‌కూడ్ఃజి వాతార్. ");
INSERT INTO kfc_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","నండొ తర్కిసి వెనుక పేతురు నిఙితండ్రె వరివెట ఈహు వెహ్తాన్‌. “తంబెరిఙాండె, సెగం కాలమ్‌కాఙ్ ‌ముందాల్నె యూదురు ఆఇ లోకాఙ్‌ సువార్త వెహ్తెఙ్‌ మీ నడిఃమిహానె దేవుణు నఙి ఏర్‌పాటు కిత్తాన్‌‌ ఇజి మీరు నెసినిదెర్. ఎందనిఙ్‌ ‌ఇహిఙ వారుబా దేవుణు మాట వెంజి దేవుణుదిఙ్‌ ‌నమ్మిదెఙ్. ");
INSERT INTO kfc_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","లోకు ఒడిఃబినికెఙ్ విజు నెసిని దేవుణు, దేవుణుదిఙ్‌ నమ్మితి యూదురు ఆఇ లోకా‍ఙ్‌బా వ‍న్నిబాన్ కూడుఃప్నాన్ ఇజి తోరిస్తాన్. ఎలాగ తోరిస్తాన్‌ ‌ఇహిఙ మఙి సిత్తివజనె యూదురు ఆఇ లోకాఙ్‌బా దేవుణు వన్ని ఆత్మ సిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","యూదురు ఆతి మఙిని ఆఇ లోకుర్‌ ఆతి వరిఙ్‌ ఇని తేడ సిల్లెండ దేవుణు ఉండ్రె వజనె కిత్తాన్‌. ఎలాగ ‌ఇహిఙ వారు న‍మ్మితిఙ్ వరి మన్సుదు మన్ని పాపమ్‌కు విజు లాగితండ్రె సుబరం కిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","అహిఙ, మాపు గాని, మా అనిగొగొర్‌ గాని పిండిదెఙ్‌ అట్‌ఇ బరుదిఙ్ ఎందనిఙ్‌ యా నమ్మితి వరి ముస్కు మొప్సినిదెర్‌? ఆహె మీరు కిత్తిఙ మీరు దేవుణుదిఙ్‌ కోపం రేప్సినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","గాని ప్రబు ఆతి యేసు దయాదర్‌మమ్‌దానె మాటు గెలిస్త‍మనాట్‌ ఇజి మాటు నమ్మిజినాట్. అయావజనె వారుబా గెలస్త మ‍నా‍ర్”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ఆఇ జాతి లోకుర్‌ నడిఃమి దేవుణు వరివెట కిత్తి గొప్ప బమ్మాతి పణిఙ వందిఙ్ గొప్ప బమ్మాతి గుర్తుఙ వందిఙ్ పవులు, బర్నబ వెహ్తిఙ్, అబ్బె మహి లోకుర్‌ విజేరె జమ్‌న అలెతారె వెహర్. ");
INSERT INTO kfc_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","వారు వెహ్తి వీస్తి వెనుక యాకోబు ఈహు వెహ్తాన్‌. “తంబెరిఙాండె, నా మాట నెగ్రెండ వెండ్రు. ");
INSERT INTO kfc_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ఆఇ జాతి లోకుర్‌ వెట దేవుణు ముందాల్నె దయ తోరిస్తాన్. అక్క ఎలాగ ఇహిఙ వరి బాణిఙ్‌ ‌ఉండ్రి జటు వన్ని సొంత లోకు వజ ఏర్‌పాటు కిదెఙ్ ‌దేవుణు వరిఙ్ ‌దయ తోరిస్తాన్. అక్క విజు పేతురు యెలె వెహ్త మనాన్. ");
INSERT INTO kfc_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ప్రవక్తరు ముందాల్నె వెహ్తికెఙ్‌ యాక‍దె. ఇని తేడ సిల్లెద్‌. వారు ముందాల్నె వెహ్తి మాట ఇనిక ఇహిఙ. ");
INSERT INTO kfc_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“దిన్ని వెనుక నాను మర్‌జి వాజి దావీదురాజుది అర్తి సొహి ఇల్లు తొహ్న. లాగ్జి విసీర్‌జి దన్నిఙ్‌ నాను మర్‌జి తొహ్సి దన్నిఙ్ ‌నాను ముందాల్ ‌మహిలెకెండ్‌ కిన. ");
INSERT INTO kfc_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","18","అయావలె ఆఇ జాతి లోకుర్ విజేరె నఙి రెబానార్‌లె. ఆఇ జాతి లోకుర్‌ బాణిఙ్‌ నా పేరు అస్తెఙ్‌ నాను ఏర్‌పాటు కిత్తికార్‌ విజేరె నఙి రెబానార్‌లె ఇజి దేవుణునె వెహ్సినాన్”, “యాక నండొ కాలమ్‌కాఙ్ ‌ముందాల్నె దేవుణు వెహ్త మనాన్”. ");
INSERT INTO kfc_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","యాకోబు మరి వెహ్తాన్‌, “నా మన్సుదు ఇనిక ఇహిఙ, దేవుణు దరోట్‌ మహ్తి వాతి ఆఇ జాతి లోకురిఙ్ మాటు మాలెఙ్ కినిక ఆఏద్‌. ");
INSERT INTO kfc_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","మాటు వరిఙ్ ‌ఉండ్రి ఉత్రం రాసి పోక్తెఙ్. అబ్బె ఇనిక రాస్తెఙ్‌ ఇహిఙ, బొమ్మెఙ ‌పూజ సిత్తి కండ తినిక ఆఏద్‌. అక్క సెఇక. సాని బూలానిక ఆఏద్‌. గొత్తిక పిడిఃక్సి సప్తిక తినిక ఆఏద్‌. నల తినిక ఆఏద్‌. యాక విజు డిఃసిసీదెఙ్. అక్కెఙె. మరి ఇనిక సిల్లెద్‍. ");
INSERT INTO kfc_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ఎందనిఙ్ ఇహిఙ యాక విజు రాస్తిమని మోసె సిత్తి రూలుఙ్‌ ప్రతి విస్రాంతి దినమ్‌దు, నండొ కాలమ్‌కాణిఙ్‌ ‌యూదురు మీటిఙ్‌ కిని ఇల్కాఙ్‌ సదివిజి మంజినాద్. మోసె వెహ్తి మాటెఙ్‌ విజు పట్నమ్‌దు బోదిసి మంజినాద్, అందెఙె వన్కాఙ్‌ విజు వారు లోబ‍డ్ఃదెఙ్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","అయావలె అపొస్తురు, పెద్దెలుఙు, సఙమ్‌దికార్‌ విజేరె కూడిఃతారె నమ్మిత్తి వరిలొఇహాన్ సెగొండారిఙ్‌ ఏర్‌పాటు కిజి పవులుని బర్నబవెట అంతియొకయాదు పోక్తెఙ్ ‌ఇజి తెగిస్తార్. వారు బర్సబ ఇని మరి ఉండ్రి పేరు మన్ని యూద వన్నిఙ్, సీలెఙ్‌ ఏర్‌పాటు కిత్తార్‌. యూదని, సీల రిఎర్. అయ సఙమ్‌దు ముకెలమతికార్. ");
INSERT INTO kfc_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","వరివెట సఙమ్‌దికార్‌ ఉండ్రి ఉత్రం రాస్త పోక్తార్. అబ్బె ఇనిక రాస్త మనాద్‌ ఇహిఙ, ‘మీ దాద్‌సీర్‌ ఆతి అపొస్తురు, పెద్దెలుఙు, అంతియొకయాదు, సిరియాదు, కిలికియాదు మన్ని దేవుణుదిఙ్‌ ‌నమ్మిత్తి యూదురు ఆఇ జాతిఙ విజేరిఙ్‌ వందనమ్‌కు పోక్సినార్. ");
INSERT INTO kfc_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","సెగొండార్‌ మా డగ్రుహాన్ ‌సొహరె వరి బోదదాన్ ‌మఙి మాలెఙ్ కిత్తార్‌, మీ మన్సుఙ విజు బాద కిత్తార్‌ ఇజి మాపు నెస్తాప్. గాని వరిఙ్ ‌మాపు పోక్‌ఏతాప్, ఇని అతికారంబా సిఏతాప్. ");
INSERT INTO kfc_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","26","అందెఙె, మా యేసు ప్రబు వందిఙ్‌ పాణం సావుదిఙ్‌ ఒప‍జెప్తి మా ప్రియమాతి బర్నబ, పవులు ఇని వరివెట మా డగ్రుహాన్‌ సెగొండారిఙ్‌ ‌మీ బాన్‌ పోక్నాప్ ‌ఇజి మాపు ఉండ్రె మన్సు ఆత మనాప్. ");
INSERT INTO kfc_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","అందెఙె మాపు యూద, సీల ఇని రిఎరిఙ్‌ ‌పోక్సినాప్. వారు వాజి మాపు రాస్తి మాటనె వెహ్నార్లె. ");
INSERT INTO kfc_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","29","మిఙి అవ్‌సరం ఆతి ఆడ్రెఙ్‌ ‌ఇనికెఙ్‌ ఇహిఙ, దెయమ్‌కాఙ్‌ పూజ కిత్తికెఙ్‌ తిన్మాట్. నల తిన్మాట్. గొత్తిక పిడిఃక్సి సప్తివనకాఙ్‌ తిన్మాట్. సాని బూలాదెఙ్‌ ఆఏద్‌. యా పణిఙ్ ‌కిఏండ మీరు దూరం మహిఙ మిఙినె నెగెద్. మిఙి అవ్‌సరం ఆతి యా ఆడ్రెఙ్‌ ‌ఆఏండ మరి నండొ ఆడ్రెఙ్‌ ‌వెహ్సి మీ ముస్కు బరు ఇడ్నిక ఆఏద్‌ ఇజి దేవుణు ఆత్మని, మాపు ఉండ్రె మన్సు ఆజినాప్. మిఙి మా వందనమ్‌కు. ");
INSERT INTO kfc_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","అయావలె సఙమ్‌దికార్‌ సెల్వ సిత్తిఙ్ ‌వారు సోత్తారె డిఃగు అంతియొకయాదు వాతార్. బానె నమ్మితి వరిఙ్ ‌విజెరిఙ్‌ కూడుఃప్తారె ఉత్రం సితార్. ");
INSERT INTO kfc_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","వారు అయ ఉత్రం సద్‌వితారె డటం సర్ద ఆతార్. ఎందనిఙ్‌ ఇహిఙ అయ ఉత్రం వరిఙ్ ‌దయ్‌రం కిత్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","యూద, సీల రిఎర్‌ దేవుణు మాటెఙ్‌ వెహ్నికార్. అందెఙె వారు దేవుణు మాటెఙ్‌ నండొ వెహ్సి అబ్బె మహి దాద్సిరిఙ్ ‌తంబెర్‌సిరిఙ్ ‌దయ్‌రం వెహ్సి ఇడ్తార్‍. అక్క వెంజి వరి మన్సుదు బలం ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","వారు అబ్బె సెగం రోస్కు గడఃప్తార్‌. వెనుక, బానె మహి నమ్మితికార్‌ వరిఙ్‌ యెరూసలేమ్‌దు వరిఙ్‌ పోక్తి వ‍రిబాన్ మర్‌జి పోక్తార్. “దేవుణు సమదనం మీబాన్ మనీద్”, ఇహారె పోక్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","గాని పవులుని బర్నబ అంతియొకయాదు మహారె మరి నండొ లోకుర్‌ వెట దేవుణు మాటెఙ్‌ ‌బోదిసి సువార్త వెహ్సి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","సెగం రోస్కు ఆతి వెనుక పవులు బర్నబెఙ్, “ఏలు సొనాటె మాటు దేవుణు మాట వెహ్తి విజు పట్నమ్‌కాఙ్‌ మన్ని తంబెరిఙు విజేరె ఎలాగ ‌మనారొ ఇజి సూణ సొనాట్ ‌ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","అయావలె మార్కు ఇజి ఆఇ పేరు మన్ని యోహానుఙ్‌ ‌వరివెట కూక్సి ఒతెఙ్‌ బర్నబ ఇస్టం ఆతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","గాని మార్కుఙ్‌ వరివెట ఒతెఙ్‌ ‌ఆఏద్‌‌ ఇజి పవులు వెహ్తాన్‌. ఎందనిఙ్‌ ఇహిఙ మార్కు ముందాల వరివెట పణిదిఙ్‌ ‌సొహిఙ్ ‌పూర్తి టయం మన్‌ఏండ పంపులియదు వరిఙ్ ‌డిఃస్త సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","మార్కు వందిఙ్ ‌పవులుని బర్నబ నండొ గొడఃబ ఆతారె రియాఙ సొహార్. బర్నబ మార్కుఙ్ ‌వెట ఒతండ్రె ఓడః ఎక్సి కూప్ర ఇని ద్వీపుదు సొహార్. ");
INSERT INTO kfc_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","గాని పవులు సీలెఙ్‌ కూక్సి ఒతాన్. బాన్‌ మహి తంబెరిఙు వారు రిఎరిఙ్‌ ‌దేవుణు దయాదర్‌మమ్‌దిఙ్ ఒపజెప్తారె వరిఙ్ పోక్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","వారు సోత్తారె సిరియ కిలికియ పట్నమ్‌కాఙ్ మన్ని సఙమ్‌కాఙ్ సొహార్‌. బానె ‌దేవుణు ముస్కు న‍మ‍కం ఇడ్తివ‍రి నమకం సత్తు కిబిస్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","పవులు, సీల వెట దెర్‌బ, లుస్‌త్ర ఇని పట్నమ్‌కాణ్ ‌వాతాన్. అబ్బె తిమోతి ఇనికాన్‌ ఒరెన్ ‌యేసుప్రబుఙ్‌ నమ్మిత్తికాన్ మహాన్‌. వన్ని అయ్‌సిబా నమకం ఇట్తా మహాద్‌. అది యూద జాతిదికాద్. వన్ని బుబ్బ ఆఇ జాతిదికాన్. వాండ్రు గ్రీసు దేసెమ్‌దికాన్. ");
INSERT INTO kfc_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","తిమోతి వందిఙ్‌ లుస్‌త్రదు, ఇకొనియాదు నమ్మితికార్ వాండ్రు గొప్ప పేరు మన్నికాన్, ఇజి పొగ్‌డిఃతార్. ");
INSERT INTO kfc_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","తిమోతిఙ్‌ వన్నివెట ఒతెఙ్‌ ఇజి పవులు ఆస ఆతండ్రె వన్నిఙ్‌ సునతి కిబిస్తాన్. ఎందనిఙ్‌ ‌ఇహిఙ ‌వన్ని బుబ్బ ఆఇ జాతిదికాన్‌ ఇజి అబ్బె మహి యూదురు విజేరె నెస్త మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","వారు పట్నమ్‌కాణిఙ్‌ సొన్సి మహిఙ్, యేసుప్రబుఙ్‌ ‌నమ్మితికార్ ఎలాగ నడిఃదెఙ్‌ ‌ఇజి యెరూసలేమ్‌దు మన్ని అపొస్తురు, పెద్దెలుఙు ఏర్‌పాటు కిత్తి ఆడ్రెఙ్‌ బోదిస్తారె అక్కెఙ్‌ లొఙిదెఙ్ ‌ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ఆహె సఙమ్‌దు మన్నివరి నమకం లావు పిరితాద్. వరి లెక్క రోజు రోజు లావు ఆజి మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ఆసియ ప్రాంతమ్‌దు దేవుణు మాటెఙ్‌ ‌వెహ్నిక ఆఏద్‌ ‌ఇజి దేవుణు ఆత్మ వరిఙ్‌ అడ్డు కిత్తిఙ్‌ ‌వారు ప్రుగియ, గలతీయ దేసమ్‌కాణిఙ్ సొహార్. ");
INSERT INTO kfc_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","అయావలె ముసియ బెతనియ డగ్రు వాతారె బెతనియ సొండ్రెఙ్ ‌ఇజి సుడ్ఃతార్. గాని బాన్‌ సొండ్రెఙ్‌ యేసుప్రబు ఆత్మ వరిఙ్‌ సరి సిఏతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","అందెఙె వారు ముసియ ప్రాంతం డాట్తారె డిఃగు సమ్‌దరం డగ్రు మ‍ని త్రోయ ఇని పట్నమ్‌దు‌ సొహార్. ");
INSERT INTO kfc_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","అయ పొదొయ్‌ పవులు, బాన్‌ మహిఙ్, ఉండ్రి దర్సనం సుడ్ఃతాన్. అక్క ఇనిక ఇహిఙ మసిదోనియ దేసెమ్‌దికాన్‌ ఒరెన్ ‌నిల్సి, “నీను మసిదోనియాదు వాజి మఙి సాయం కిఅ”, ఇజి బతిమాలితి వజ దర్సనం సుడ్ఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","పవులు ‌అయా దర్సనం వాతిఙ్, మాపు వెటనె మసిదోనియ సొండ్రెఙ్‌ తయార్ ‌ఆతాప్. ఎందనిఙ్‌ ఇహిఙ, మసిదోనియాది వరిఙ్‌ దేవుణు సువార్త వెహ్ని వందిఙ్ ‌దేవుణు మఙి కూక్త మనాన్‌ ‌ఇజి మాపు నెస్తాప్. ");
INSERT INTO kfc_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","మాపు త్రోయ పట్నమ్‌దాన్‌ ‌ఓడః ఎక్తాపె తినాఙ్‌ ‌సమొత్ర ఇని ద్వీపుదు సొహప్‍. మహ్స నాండిఙ్‌ ‌నెయపోలి ఇని పట్నమ్‌దు అందితాప్. ");
INSERT INTO kfc_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","అబ్బెణిఙ్ ‌పిలిప్పి ఇని పట్నం వాతాప్. మసిదోనియ దేసమ్‌దు పిలిప్పి పట్నం ఉండ్రి ముకెలమాతి పట్నం. అక్క నండొండార్ ‌రోమాదికార్‌ బత్కిజి మహి పట్నం. మాపు సెగం రోస్కు ఆ పట్నమ్‌దు మహప్. ");
INSERT INTO kfc_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","విస్రాంతి దినమ్‌దు మాపు పట్నం వెల్లి వాతాపె గడ్డ ఒడ్డు దరోట్ ‌యూదురు పార్దనం కిని బాడ్డి మనాద్‌సు ఇజి వాతాప్. వాతిఙ్, బాన్‌ బస్తాపె కూడ్ఃజి వాతి మహి అయ్‌లి కొడొఃక్‌వెట వర్గిదెఙ్‌ మొదొల్‌స్తాప్. ");
INSERT INTO kfc_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","అయావలె లుదియ ఇని ఉండ్రి అయ్‌లి కొడొః వెంజి మహాద్‌. అది తుయతయ్‌ర పట్నమ్‌దికాద్.‌ అది లావు దరది ఊద రంగుది పాతెఙ్‌ పొర్నికాద్. ‌అది దేవుణుదిఙ్‌ ‌పార్దనం కినికాద్. దేవుణు మాటెఙ్‌ ‌అర్దం కిదెఙ్ ‌దేవుణు బుద్ది సిత్తిఙ్ అది పవులు వెహ్తి మాటెఙ్‌ మన్సుదు ఇడ్ఃతాదె అయావజనె నడిఃతాద్. ");
INSERT INTO kfc_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","అది, దన్ని ఇండ్రొణికార్, విజేరె బాప్తిసం లాగె ఆతార్. వెనుక అది, “నాను దేవుణుదిఙ్‌ పూర్తి నమ్మిజిన ఇజి మీరు ఒప్పుకొటిఙ నా ఇండ్రొ వాజి మండ్రు”, ఇజి మఙి బతిమాలితాద్. ");
INSERT INTO kfc_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ఒర్నెండు మాపు పార్దనం కిని బాడ్డిదు సొన్సి మహిఙ్‌ ఉండ్రి వెట్టిపణి కిని ఇజిరి అయ్‌లి మా ఎద్రు వాతాద్. దన్నిఙ్‌ పుతొన్ ఇని దెయం అస్త మహాద్‌. అది జాతకం వెహ్సి దన్ని ఎజుమానురిఙ్ నండొ డబ్బు గణపిస్తాద్. ");
INSERT INTO kfc_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","అది పవులుని ‌మఙి వెనుక వాజి డటం గగోల్‌ ఆజి వెహ్తాద్‌, “యా లోకుర్, ‌విజెరిఙ్‌ ఇంక పెరి దేవుణుదిఙ్‌ ‌సేవ కినికార్. దేవుణు ఎలాగ మిఙి గెల్పిస్నాన్లె ‌ఇజి వీరు వెహ్నార్లె” ఇహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","నండొ రోస్కు అది ఆహె కిజి మహిఙ్, పవులు మన్సుదు గొప్ప బాద ఆతండ్రె అయ దెయమ్‌దిఙ్‌ “నీను యా ఇజిరి దన్నిఙ్ ‌డిఃసి సొన్‌అ ఇజి యేసుక్రీస్తు అతికారమ్‌దాన్‌ ‌వెహసిన”, ఇజి వెహ్తాన్‌. వెటనె అయ దెయం అయ్‌లిదిఙ్ ‌డిఃస్త సొహాద్. ");
INSERT INTO kfc_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","గాని దన్ని ఎజుమానిరు వరిఙ్ ‌వాని డబ్బు విజు సొహె ఇజి సుడ్ఃతారె పవులు ‌సీలెఙ్ ‌పట్నం నడిఃమి, అతికారిఙ డగ్రు ఈడిఃసి తతార్. ");
INSERT INTO kfc_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","21","కోర్టు నడిఃపిసిని వరిబాన్‌ తత్తారె, “వీరు యూదురు. వీరు బోదిసిని అలవాటుఙ్ ‌మఙి పడ్ఃఇకెఙ్. మాటు రోమాదికాట్. మాటు అక్కెఙ్‌ ‌ఒపుకొణిక ఆఏద్‌, అయావజనె నడిఃనిక ఆఏద్‌. మా పట్నమ్‌దు వీరు గొప్ప కలిబిలి కిజినార్”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","అయావలె బాన్‌ కూడిఃతి మహి లోకుర్ విజేరె పవులుఙ్‌ని, సీలెఙ్‌ ఎద్రు వాతారె నింద మొప్తారె గగొల్‌ ఆతార్. వరి సొక్కెఙ్ ‌లాగ్‌జి వరిఙ్ ‌డెఃయ్దు ఇజి కోర్టు నడిఃపిసినికార్‌ ఆడ్ర‌ సితార్. ");
INSERT INTO kfc_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","వారు లావు దెబ్బెఙ్‌ డెఃయ్తారె పవులు ‌సీలెఙ్‌ జెలి లొఇ ఇడ్తార్‌. “వరిఙ్ జాగర్త సుడ్ఃదు”, ఇజి జేలి ఎజుమానిఙ్‌ ఆడ్ర ‌సిత్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","అయ ఆడ్ర ‌వాతిఙ్ ‌జెలి ఎజుమాని వరిఙ్ ‌జేలిదు లొఇ మన్ని గదిదు వరి కాల్కాఙ్‌ డుకేఙ లొఇ తొహ్తాండ్రె ఇట్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","రమారమి మదరెయ్‌తు పవులుని సీల దేవుణుదిఙ్‌ పార్దనం కిజి పాటెఙ్‌ పార్జి మహార్‌. వీరు పార్‌జి మహిఙ్‌ జెలిదు తొహె ఆతి మహికార్ విజేరె వెంజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","అయావలె వెటనె బూమి విజు డటం కద్లితాదె అయ జేలి పునాదిఙ్‌ విజు కద్లితె. వెటనె సేహ్లెఙ్‌ విజు రే ఆతె. జెలిదు మహివరి విజెరి కట్కు ఊడిఃతె. ");
INSERT INTO kfc_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","అయ జేలి ఎజుమాని తెలి ఆతండ్రె జెలిది సేహ్లెఙ్‌ విజు రే ఆతిమనిక సుడ్ఃతాన్. సుడ్ఃతండ్రె జెలిదు మహికార్‌ ‌ఉహ్‌క్త సొహార్‌ ఇజి ఒడిఃబిజి కుర్ద లాగితండ్రె వన్నిఙ్‌ వాండ్రె గుత్తె ఆజి సాదెఙ్ ‌తయార్ ఆతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","అయావలె పవులు, “నీను ఇని కూనిబా కిబె ఆమ. మాప్‌ విజెపె ఇబ్బెనె మనాప్”, ‌ఇజి డటం గగోల్‌ ఆజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","అయ జేలి ఎజుమాని, దీవ తగ్‌అ ఇజి వెహ్సి లొఇ ఉహ్‌క్సి వాతాండ్రె వణక్సి పవులు సీలారి పాదమ్‌కాఙ్‌ డగ్రు అర్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","వాండ్రు పవులుఙ్‌ని సీలెఙ్‌ ‌వెల్లి తతాండ్రె వెన్‌బాతాన్, “బాబురాండె, నాను తప్రె ఆదెఙ్‌ ‌ఇహిఙ ఏలు ఇనిక కిదెఙ్‌?”. ");
INSERT INTO kfc_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","“యేసుప్రబు ముస్కు నమకం ఇట్తిఙ, అయావలె నీను నీ ఇండ్రొణికార్‌ ‌విజిదెరె తప్రె ఆనిదెర్”, ‌ఇజి పవులు సీల వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","పవులుని సీల వన్నిఙ్, వన్ని ఇండ్రొణి వరిఙ్‌ యేసుప్రబు వందిఙ్ సువార్త వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ఆ పొదొయ్‌ ‌అయా గడిఃయాదునె వాండ్రు పవులుని సీలెఙ్‌ ‌ఒతాండ్రె వరి దెబ్బెఙ్ నొహ్తాన్. వెటనె వాండ్రు, వన్ని ఇండ్రొణికార్‌ విజేరె బాప్తిసం లాగె ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","వాండ్రు పవులుఙ్‌ని సీలెఙ్‌ వన్ని ఇండ్రొ కూక్సి తసి బోజనం సిత్తాన్‌. దేవుణు ముస్కు నమకం ఇట్తి వందిఙ్ వాండ్రు వన్ని ఇండ్రొణికార్‌ విజేరె నండొ సర్ద ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","పెందల కోర్టు నడిఃపిసినికార్, “అయ లోకాఙ్‌ డిఃస్తు”, ఇజి ఆడ్ర ‌సిత్తారె జమాన్‌ఙ ‍జెలి ఎజుమానిబాన్‌ ‌పోక్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","జేలి ఎజుమాని అయ మాటెఙ్‌ పవులు ‌వెహ్తాన్‌. “మిఙి డిఃస్తు ఇజి కోర్టు నడిఃపిసినికార్‌ ఆడ్ర ‌పోక్త మనార్. మీరు ఏలు జమ్‌న సొండ్రు”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","గాని పవులు, “మాపు వర్గిదెఙ్‌ ‌అవకాసం సిఏండ వారు తీర్‌పు కిజి విజేరె ముందాల డెఃయ్తార్. మాపు రోమాదిఙ్ అక్కు మ‍నికాప్‌ ఇహిఙ్‌బా మఙి జెలిదు ఇట్తార్. ఏలు మఙి ఎయెర్‌బా నెస్‌ఏండ పోక్తెఙ్‌ సుడ్ఃజినార్. మాపు ఒప్‌ఏప్. వారె వాజి మఙి వెల్లి తసి పోక్తెఙ్”, ఇజి జమానుఙ్‌ ‌వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","యా మాటెఙ్‌ అయ జమానుఙ్‌ కోర్టు న‍డ్ఃపిసిని వ‍రిఙ్ వెహ్తార్‌. పవులుని సీల రోమాదిఙ్ అక్కు మనికార్‌ ఇజి వెహారె వారు తియెల్‌ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","అయ కోర్టు నడిఃపిసినికార్‌ వాతారె పవులుఙ్, సీలెఙ్‌ ‌సెమ లొస్తారె జెలిదాన్‌ ‌వెల్లి కూక్సి తత్తారె ‘పట్నం డిఃసి సొండ్రు’ ఇజి వరిఙ్ ‌వెహ్సి పోక్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","వారు జెలిదాన్‌ ‌వెల్లి వాతారె లుదియబాన్‌ సొహార్. అబ్బె నమ్మిత్తివరి వెట వర్గిజి వరిఙ్ ఆదరిస్తారె వరి నమకందిఙ్ సత్తు కిబిసి ‌దయ్‌రమ్‌ ముస్కు మండ్రు ఇజి వెహ్తార్‌. వెనుక వారు బాణిఙ్‌ సోత్త సొహార్. ");
INSERT INTO kfc_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","అయావలె పవులుని సీల పిలిప్పి పట్నమ్‌దాన్‌ ‌సోత్తారె అంపిపొలి, అపొలోనియ పట్నమ్‌కు డాట్సి దెసలొనిక ఇని పట్నమ్‌దు వాతార్. అబ్బె యూదురు మీటిఙ్‌ ‌కిని ఇల్లు ఉండ్రి మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","పవులు, వాండ్రు ఒజ ఆతి లెకెండ్‌ యూదురి మీటిఙ్‌ కిని ఇండ్రొ సొహాన్‌. సొహాండ్రె, బానె మహి వరివెట మూండ్రి విస్రాంతి దినమ్‌కు దేవుణు మాట వెహ్సిమహాన్. ఇనిక ఇహిఙ, ");
INSERT INTO kfc_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","“క్రీస్తు ఇనికాన్‌ మాలెఙ్ ఆజి సానాన్లె. సాజి మర్‌జి ని‌ఙ్‌నాన్‌లె’ ఇజి ప్రవక్తరు రాస్తిక దేవుణు మాటాదు మనాద్. అయ లెకెండ్ జర్గిదెఙె. నాను మీ వెట సాటిసి వెహ్ని యా యేసుప్రబునె క్రీస్తు”. యా మాటెఙాణిఙ్‌ సదివిజి వెహ్సి సిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","యూదురు - లొఇహాన్ ‌సెగొండార్‌ పవులు వెహ్తి మాటెఙ్‌ ఒపుకొటారె పవులుని సీల వెట కూడిఃతార్. బక్తి మన్ని గ్రీకు జాతిదికార్‌ నండొండార్, ముకెలమాతి అయ్‌లికొడొఃక్ ‌నండొండెక్‌బా వరివెట కూడిఃతార్. ");
INSERT INTO kfc_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","అహిఙ యూదురు గోస ఆతార్. గోస ఆతారె ఇని పణి సిల్లెండ తిరిగిని సెఇ లోకాఙ్‌ సర్దుహాన్‌ కూడుఃప్తారె మందెఙ్‌ ఆజి పట్నమ్‌దు కలిబిలి కిజి యాసోను ఇని వన్ని ఇండ్రొ సొహార్‌. ఇండ్రొణి సేహ్ల‍దిఙ్ డెఃయ్‍త పొక్తారె పవులుని సీలెఙ్‌ ‌లోకుర్‌ నడిఃమి అసి తనాట్ ఇజి లొఇ డుఃగితార్. ");
INSERT INTO kfc_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","గాని పవులుఙ్‌ని సీలెఙ్‌ తోర్‌ఏతార్‌కాక యాసోనుఙ్‌ మరి నమ్మితి వరిఙ్ ‌సెగొండారిఙ్‌ పట్నం అతికారిఙ డగ్రు లాగిత తతార్. “వీరు, యా లోకం విజు కలిబిలి కినికార్, ఇబ్బెబా వాత మనార్. ");
INSERT INTO kfc_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","విరిఙ్‌ యా యాసొను వన్ని ఇండ్రొ ఇట్తా మహాన్‌. వీరు విజేరె యేసు ఇజి మరి ఒరెన్ ‌రాజు మనాన్‌ ఇజి వెహ్సి కయ్‌సరు రూలుఙ లొఙిఏండ నడిఃసినార్”, ఇజి డటం గగోలాజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","యాక వెహారె లోకుర్, పట్నం అతికారిఙు గొప్ప కలిబిలి ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","అతికారిఙు యాసోను బాణిఙ్, అయ నమ్మిత్తి వరి బాణిఙ్ డబ్బు తొహ్పిస్తారె వరిఙ్ ‌డిఃస్త సితార్. ");
INSERT INTO kfc_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","సీకటి ఆతిఙ్‌ ‌వెటనె నమ్మితికార్ ‌పవులుఙ్, సీలెఙ్‌ బెరెయ ఇని బాడ్డిదు ‌పోక్తార్. వారు బానె వాతారె యూదురు మీటిఙ్‌ కిని ఇండ్రొ సొహార్. ");
INSERT INTO kfc_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","బెరెయాదు మహికార్‌ తెసలొనికదు మహి వరిలెకెండ్ ఆఏర్. వారు గొప్ప ఆసదాన్‌ దేవుణు మాటెఙ్‌ ‌వెహరె వనక వందిఙ్ ఒడిఃబిజి మ‍హార్. పవులుని సీల వెహ్సి మహి సఙతిఙ్‌ నిజమ్‌నెనొ ఆఏదొ ఇజి వారు రోజు దేవుణు మాటాదు సుడ్ఃజి సదివిజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","అందెఙె వరి లొఇ నండొండార్ ‌యూదురు నమ్మితార్. నండొండార్‌ గ్రీసు జాతిది వరి లొఇ పల్కుబడిః మన్ని అయ్‌లి కొడొఃక్‌ని మొగకొడొఃర్ ‌నమ్మితార్. ");
INSERT INTO kfc_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","గాని బెరెయాదుబా పవులు దేవుణు మాటెఙ్‌ సాటిసినాన్ ‌ఇజి తెసలొనికదు మన్ని యూదురు నెస్తారె బాణిఙ్‌ వాతారె బెరెయా లోకాఙ్‌ ‌కోపం పుటిస్తారె కలిబిలి కిత్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","అయావలె నమ్మితికార్ ‌పవులుఙ్‌ వెటనె సమ్‌దరం డగ్రు సొన్‌అ ఇజి పోక్తార్. గాని సీలని, తిమోతి బెరెయాదునె నిహ మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","పవులుఙ్‌ పోక్తెఙ్‌ సొహికార్ ‌ఏదెన్సు పట్నమ్‌దాకానె ఒతార్. సీల, తిమోతి వెటనె నా బాన్ ‌రద్దు ఇజి కబ్రు సితండ్రె పవులు వరిఙ్‌ మహ్సి పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","పవులు ఏదెన్సు పట్నమ్‌దు సీలెఙ్‌ ‌తిమోతిఙ్‌ ఎద్రు సుడ్ఃజి మహాన్‌. మహిఙ్‌ అయ పట్నమ్‌దు వారు మాడిఃస్తి మహి దె‍య‍మ్‌కాణి బొమ్మెఙ్ నండొ మహిఙ్‌ ‌అక్కెఙ్ ‌సుడ్ఃజి మన్సుదు నండొ బాద ఆతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","అయావలె యూదురు మీటిఙ్‌ కిని ఇండ్రొ సొహాండ్రె యూదురు వెట, బ‍క్తి మన్ని యూదురు ఆఇ వరివెట పవులు వాదిస్తాన్. రోజు రోజు సత సహ్క కూడ్ఃజి వాతి వరివెట వాదిసి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","అబ్బె లావు సద్‌వితి మన్నికార్ ‌ఎపికూరియ జటుదికార్‌ సెగొండార్‌ స్తోయికుల లోకుర్‌ లొఇ సెగొండార్‌ మహార్‌. వారు పవులు వెట వాదిస్తార్. సెగొండార్, యా బడాకి ఇనిక వెహ్సినాన్‌ ఇజి వెహ్తార్‌. యేసుప్రబు వందిఙ్, సాతికార్‌ మర్‌జి నిఙ్‌ని వందిఙ్ పవులు నెస్పిస్తిఙ్ ‌అబ్బె మరి సెగొండార్ ‌వీండ్రు ఆఇ దెయమ్‌కాఙ్‌ వందిఙ్‌ వెహ్సినాన్‌ ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","వారు పవులు ‌అరెయొపగు ఇని సద్రుదు లాగిత తత్తారె, “నీను వెహ్సిని యా కొత్త మాట ఎలాగ మర్తికాదొ, మాపుబా నెస్తెఙ్‌ ఆనాదా? ");
INSERT INTO kfc_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","నీను సెగం కొత్త మాటెఙ్‌ ‌వెహ్సిని. అక్కెఙ్‌ ‌మాపు ఎసెఙ్‌బా వెన్‌ఇకెఙ్. వన్కా అర్దం ఇనికాదొ ఇజి నెస్తెఙ్‌ ‌మాపు కోరిజినాప్”, ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ఆ ఏదెన్సు పట్నమ్‌దికార్‌ విజేరె, అబ్బె బత్కిజి మహి ఏదెన్సు పట్నమ్‌దికార్‌ ఆఇకార్‌బా ఇనికాదొ ఉండ్రి కొత్త మాట విని వందిఙ్, వర్గిని వందిఙ్‌ లావు ఇస్టమాజి వరి సమయం విజు బానె గడఃప్సి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","అయావలె పవులు అరెయొపగు సద్రుదు నిహండ్రె ఈహు వెహ్తాన్‌, “ఏదెన్సు పట్నమ్‌దికిదెరా, మీరు విజు పణిఙ లొఇ గొప్ప బక్తి మన్నికిదెర్‌ ఇజి నఙి తోరిజినాద్. ");
INSERT INTO kfc_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ఎందనిఙ్‌ ఇహిఙ నాను బూలాజి బూలాజి మీ బొమ్మెఙ నెగ్రెండ సుడ్ఃజి మహిఙ్‌ ఉండ్రి మాలి పీట సుడ్ఃత. దన్ని ముస్కు ‘నెస్‌ఇ దెయమ్‌దిఙ్’ ఇజి రాస్త మనాద్. అందెఙె మీరు నెస్‌ఏండ ఇని దన్నిఙ్ మాడిఃసినిదెరొ దన్ని వందిఙ్‌ నాను మిఙి బోదిసిన”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","పవులు మరి వెహ్తాన్, “యా బూ లోకమ్‌దిఙ్, ‌దన్ని లొఇ మన్ని విజువ నకాఙ్, ‌దేవుణునె పుటిస్తాన్. అయ దేవుణునె పరలోకమ్‌దిఙ్, బూమిదిఙ్‌ ‌ప్రబు ఆత మనాన్. అయ దేవుణు లోకు ‌తొహ్తి గుడిఃదు బత్కిఎన్. ");
INSERT INTO kfc_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","దేవుణునె విజు లోకాఙ్‌ బత్కు, పాణం, విజు సీజినాన్. దేవుణుదిఙ్‌ ఇనికబా తక్కు ఆఏండ మన్‍ఎద్‍. అందెఙె లోకు వన్నిఙ్‌ ఇనికబా సీదెఙ్‌ అవ్‌సరం సిల్లెద్‌. ");
INSERT INTO kfc_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","దేవుణు ఒరెన్‌ వన్ని వెట విజు జాతి లోకాఙ్‌ పుటిస్తాన్. ఎందనిఙ్‌ ఇహిఙ యా బూలోకం ముస్కు విజుబాన్‌ బత్కిని వందిఙ్‌ పుటిస్తాన్. వారు ఎంబె బత్కిదెఙ్‌ ఇజి, ఎమేణి కాలమ్‌దు బత్కిదెఙ్‌ ‌ఇజి దేవుణు ముందాల్నె ఏర్‌పాటు కిత మనాన్. ");
INSERT INTO kfc_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ఎందనిఙ్‌ ‌ఇహిఙ ఉండ్రి వేలా వారు నఙి ‌రెబాజి వానార్సు ఇజి ఇక్కెఙ్‌ విజు దేవుణు ఏర్‌పాటు కిత్తాన్‌. దేవుణు మా డగ్రుహాన్ ‌దూరం మంజినికాన్‌ ఆఏన్. ");
INSERT INTO kfc_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","మాటు దేవుణు వెటనె బత్కినాట్, దేవుణు వెటనె నడిఃసినాట్, దేవుణు వెటనె మంజినాట్. మీ లొఇ పాటెఙ్‌ రాస్నికార్‌ వెహ్తివజ ‘మాటు దేవుణు కొడొఃరె'. ");
INSERT INTO kfc_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","అందెఙె మాటు దేవుణు కొడొఃర్‌ ఆతిఙ్, లోకు, వరి మన్సుదు మన్ని ఆలోసనం వజ, వారు నెస్తిమన్ని పణి వజ బఙారమ్‌దాన్, వెండిదాన్, పణుకుఙాణ్‌ తయార్‌ కిత్త బొమ్మెఙ వజ దేవుణు మనాన్‌ ‌ఇజి ఒడిఃబిదెఙ్ ‌ఆఏద్‌. ");
INSERT INTO kfc_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","నస్తివలె మాటు నెస్‌ఏండ మహివలె దేవుణు అక్క సుడ్ఃతిఙ్‌బా సుడ్ఃఇ లెకెండ్ ‌డిఃస్తాన్. ఏలు ఇహిఙ ఎంబెబా సరినె, విజేరె లోకుర్‌ వరి పాపమ్‌కు డిఃసిసీజి దేవుణుబాన్ ‌రద్దు ఇజి దేవుణు ఆడ్ర సీజినాన్. ");
INSERT INTO kfc_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ఎందనిఙ్‌ ఇహిఙ, దేవుణు విజేరె లోకాఙ్‌ నీతినిజయ్తిదాన్‌ తీర్‌పు కిదెఙ్ ‌ఉండ్రి రోజు ఏర్‌పాటు కిత మనాన్. అయా రోజు దేవుణు ఏర్‌పాటు కిత్తి ఒరెన్‌ లోకువెట తీర్‌పు తీరిస్నాన్. దేవుణు ఆ లోకుదిఙ్‌ ‌సావుదాన్‌ మర్‌జి నిక్త మనాన్. ఎందనిఙ్‌ నిక్తాన్ ‌ఇహిఙ ఆ లోకుదిఙ్‌ తీర్‌పు కిదెఙ్ ‌అతికారం మనాద్‌ ‌ఇజి విజేరిఙ్‌ రుజుప్‌ కిదెఙ్”. ");
INSERT INTO kfc_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","లోకు సాజి మర్‌జి నిఙ్‌ని వందిఙ్‌ వెహారె వరి లొఇ సెగొండార్ ‌కరాయితార్. గాని మరి సెగొండార్‌ “దిన్ని వందిఙ్ మరి వెహ్‌అ, వెనాప్”, ఇజి పవులుఙ్‌ ‌వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ఆహె మహిఙ్‌ పవులు వరిబాణిఙ్‌ సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","అహిఙ సెగొండార్‌ పవులు వెహ్తి మాటెఙ్‌ ‌నమ్మిత్తారె వన్ని వెట కూడిఃతార్. పవులు వెట ‌కూడిఃతి మహి వరి లొఇ అరెయొపగు సద్రుదికాన్ ఒరెన్‌ ‌దియొనుసియు, దమరి ఇని ఉండ్రి అయ్‌లి కొడొః, మరి సెగొండార్‌ మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","వెనుక, పవులు ఏదెన్సు పట్నమ్‌దాన్‌ సోతాండ్రె కొరింతు ఇని పట్నం సొహాన్‌. అయ కొరింతు పట్నమ్‌దు సొహిఙ్‌ బానె పొంతు దేసెమ్‌దికాన్‌ ‌అక్కుల ఇని ఒరెన్ ‌యూదు వన్నిఙ్‌ని వన్ని ఆల్సి ఆతి ప్రిస్కిలదిఙ్‌ సుడ్ఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","యూదురు విజేరె రోమ పట్నం డిఃసి సొండ్రెఙ్‌వలె ఇజి క్లవుదియ ఇని రోమ పెరిరాజు ఆడ్ర సిత్తాన్‌. ఆడ్ర ‌సిత్తిఙ్ ‌యా ఆల్సి మాసిర్‌ ఇటలి దేసెం డిఃస్తారె కొరింతు పట్నమ్‌దు కొత్తాఙ్ ‌వాతార్. పవులు వరిఙ్‌ సుడ్ఃదెఙ్‌ సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","పవులు వరివెట బ‍త్కిజి వరివెట కూడ్ఃజి పణి కిత్తాన్‌. ఎందనిఙ్‌ ఇహిఙ వారుని పవులు టంబుఙ్ ‌గుత్నికార్. ");
INSERT INTO kfc_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ప్రతి విస్రాంతి దినమ్‌దు పవులు యూదురు మీటిఙ్‌ కిని ఇండ్రొ సొహాండ్రె, యూదురు వెట, గ్రీసు వరివెట తర్కిసి వెహ్సి వాండ్రు వెహ్తికెఙ్‌ నిజం ఇజి ఒపిసి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","సీలని తిమోతి మసిదోనియదాన్‌ వాతారె పవులు వెట కూడిఃతార్. అయావలె పవులు పూర్తి టయం దేవుణు మాటెఙ్‌ ‌బోదిసి మహాన్‌. యేసునె క్రీస్తు ఇజి యూదురుఙ డటిసి సాసి వెహ్సి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","పవులు వెహ్తి మాటెఙ్‌ యూదురు నెక్తపొక్తారె పవులుఙ్‌ ‌దుసలాడిఃతార్. అయావలె పవులు, “దేవుణు మిఙి సిక్ససిత్తిఙ అక్క మీరె మీ ముస్కు తపిసినిదెర్. దిన్ని వందిఙ్ నా బాన్ తప్పు సిల్లెద్‌. ఇబ్బెహాన్‌ ‌నాను యూదురు ఆఇ వరిబాన్ ‌సొనానె దేవుణు మాటెఙ్‌ నెస్పి‍స్నాలె”, ఇజి వెహ్తండ్రె, సొక్కెఙ దూల్లి దుల్‌ప్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","పవులు యూదురు మీటిఙ్‌ ‌కిని ఇండ్రొహాన్ ‌సోత్తాండ్రె పడఃకాద్‌ మహి తీతియు యూస్తు ఇని వన్ని ఇండ్రొ సొహాన్‌. తీతియు దేవుణుదిఙ్‌ ‌పార్దనం కినికాన్. వన్ని ఇల్లు యూదురు మీటిఙ్‌ కిని ఇల్లు డగ్రునె మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","యూదురి మీటిఙ్‌ ఇల్లు నడిఃపిసినికాన్‌ ‌ఆతి క్రిస్పసు, వన్ని ఇండ్రొణికార్‌ విజేరె యేసుప్రబుఙ్‌ ‌నమ్మితార్. మరి కొరింతు పట్నమ్‌దికార్‌ నండొండార్‌బా దేవుణు మాట వెహారె నమ్మిత్తారె బాప్తిసం లాగె ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ఒర్‌నెండ్‌ పొదొయ్, దర్సనమ్‌దు యేసుప్రబు, “నీను తియెల్‌ ‌ఆఏండ వర్గిఅ. అలెజి మన్‌అ. ");
INSERT INTO kfc_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ఎందనిఙ్‌ ఇహిఙ నాను నీవెటనె మంజిన. నిఙి పాడు కిదెఙ్‌ నీ ముస్కు ఎయెన్‌బా రెఏన్. ఎందనిఙ్‌ ఇహిఙ యా పట్నమ్‌దు నాలోకుర్‌ నండొండార్‌ మనార్”, ఇజి పవులుఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","అందెఙె పవులు దేవుణు మాటెఙ్‌ నెస్పిసి వరి నడిఃమి ఉండ్రి ఏండుని ఆరు నెలెఙ్‌ దాక మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","గాని గలియోను ఇనికాన్‌ అయ అకాయ దేసెమ్‌దిఙ్ ఏలుబడిః కినికాన్‌ ఆతివలె యూదురు ఉండ్రె జటు ఆతారె పవులు ముస్కు వాతార్. పవులుఙ్‌ అస్తారె కోర్టుదు ఒతార్. ");
INSERT INTO kfc_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","వారు పవులు ముస్కు పిరాద్‌ కిత్తార్‌. ఇనిక ఇహిఙ, “దేవుణుదిఙ్‌ ఎలాగ పార్దనం కిదెఙ్‌ ఇజి మఙి మన్ని రూలుదిఙ్ ‌ఎదిరిసివెహ్సి వీండ్రు ఒపిసి మారిస్నిలె‍కెండ్ వెహ్సినాన్” ");
INSERT INTO kfc_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","పవులు వర్గిదెఙ్‌ సుడ్ఃతాన్. అయావలె గలియోను యూదురిఙ్‌ ఈహు వెహ్తాన్‌, “యూదురాండె, ఇక్క ఉండ్రి తప్పు పణి వందిఙ్ ‌ఇహిఙ, ఉండ్రి సెఇ పణి వందిఙ్‌ ఇహిఙ నాను మీమాటెఙ్ ‌నెగ్రెండ వెండ్రెఙ్‌ ఆనాద్. ");
INSERT INTO kfc_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","గాని ఇక్క ఇనికాదొ ఉండ్రి మాటవందిఙ్, పేర్‌కువందిఙ్, మీ రూలుఙ్‌ వందిఙ్ ‌తర్కిస్తెఙ్‌ ఇహిఙ మీరె పన్నిఙ్ ‌సుడ్ఃదు. నిన్ని సఙతిఙ వందిఙ్‌ తీర్‌పు తీరిస్తెఙ్ నఙి ఇస్టం సిల్లెద్”, ఇజి యూదురు వెట వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ఈహు వెహ్తండ్రె వరిఙ్‌ కోర్టుదాన్ ‌పేర్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","అయావలె విజేరె కూడిఃతారె యూదురి మీటిఙ్‌ ‌ఇల్లు నడిఃపిసినికాన్‌ ఆతి సోస్తెనేసు ఇనివన్నిఙ్ ‌అస్తారె కోర్టు డగ్రు తత్తారె డెఃయ్తార్. అహిఙ్‌బా గలియోను యా సఙతిఙ వందిఙ్‌ ఇనికబా ఇన్‌ఎతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","పవులు దేవుణువెట మొకిత మ‍హాన్‌కా‍క అక్క వీస్తివలె బుర్ర కత్రె ఆతాన్. కొరింతు పట్నమ్‌దు మరి నండొ రోస్కు మంజి వెనుక నమ్మిత్తివరిబాణిఙ్ ‌సెలవ లొస్తాండ్రె సొహాన్‌. కెంక్రెయాదు సొహరె బుర్ర కత్రె ఆతాన్. బాణిఙ్‌ ఓడః ఎక్తాండ్రె సిరియ ఇని దేసెమ్‌దిఙ్ ప్రిస్కిల, అక్కుల వెట సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","వారు ఎపెసు పట్నమ్‌దు వాతార్. ప్రిస్కిల అకులరిఙ్‌ డిఃసి పవులు సొనివలె వీరు యా పట్నమ్‌దునె మంజినార్. పవులు ఇహిఙ ఒరెండ్రె బానె మహి యూదురి మీటిఙ్‌ ఇండ్రొ సొహాన్‌. సొహాండ్రె యూదురు వెట తర్కిసి వర్గిజి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","సెగం రోస్కు మా వెట మన్‌అ ఇజి యూదురు పవులు ‌వెన్‌బాతిఙ్‌ పవులు కెఏతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","వరిఙ్‌ డిఃసి సొహివలె, “దేవుణు ఇస్టం ఇహిఙ మీ డగ్రు మర్‌జి వాన”, ఇజి వెహ్తండ్రె సోత్తాన్. ఓడః ఎక్తాండ్రె ఎపెసుదాన్‌ సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","కయ్‌సరియాదు అందితాండ్రె పవులు యెరూసలేం పట్నమ్‌దు ఎక్త సొహాన్‌. బానె మహి సఙమ్‌దివరిఙ్‌ సుడిః సొహాన్‌. వెనుక అంతియోకయాదు సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","బానె సెగం కాలం మహి వెనుక సోతాండ్రె గలతియ ప్రుగియ ఇని దేసమ్‌కాణిఙ్ ‌వర్స బూలాతాండ్రె నమ్మితి వరిఙ్ నెస్పిస్తాన్. దేవుణుదిఙ్‌ ‌డిఃస్‌ఏండ నెగ్రెండ మండ్రు ఇజి వెహ్సి వరిఙ్‌ దయ్‌రం సిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","అయావలె అలక్సంత్రియదికాన్ ‌అపొలొ ఇని ఒరెన్ ‌యూదవాండ్రు ఎపెసు పట్నమ్‌దు వాతాన్. వాండ్రు గొప్ప స‍ద్‌వితికాన్. దేవుణు మాటదు రాస్తిమ‍న్నికెఙ్ విజు బాగ నెస్తిమనికాన్. దేవుణు మాట నెగ్రెండ వర్గిదెఙ్‌ వాండ్రు అట్నాన్. ");
INSERT INTO kfc_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","వాండ్రు యేసు ప్రబువందిఙ్‌ నెగ్రెండ సుర్‌కుదాన్ ‌నెస్‌పిస్తాన్. ఎలాగ బత్కిదెఙ్‌ ఇజి యేసుప్రబు నెస్‌పిస్తి మాటెఙ్‌ వాండ్రు నెస్తాన్. గాని యోహాను లోకాఙ్‌ సిత్తి బాప్తిసం వందిఙె వాండ్రు నెస్త మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","యూదురు మీటిఙ్‌ ‌కిని ఇండ్రొ దయ్‌రమ్‌దాన్‌ దేవుణు మాటెఙ్‌ వర్గితాన్. ప్రిస్కిల అక్కుల విన్ని మాటెఙ్‌ వెహారె విన్నిఙ్ వరి ఇండ్రొ కూక్త ఒత్తార్. ఒత్తారె దేవుణు వరిఙ్ సిత్తి సువార్త వందిఙ్‌ వీండ్రు నెస్ఇ వనకవందిఙ్ వన్నిఙ్‌ నెస్‌పిస్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","వెనుక అపొలొ అకాయ దేసమ్‌దు సొండ్రెఙ్ ‌సుడ్ఃతిఙ్, ఎపెసుదు మన్ని నమ్మితికార్, నీను సొన్‌అ ఇజి వెహ్సి, అక్కాయాదు మహి నమ్మితివరిఙ్, ‘విన్నిఙ్ ‌మీ వెట కూడుఃప్తు’ ఇజి ఉత్రం రాస్తార్. వాండ్రు అబ్బె సొహాండ్రె దేవుణు దయాదర్మమ్‌దాన్ ‌నమ్మితి వరిఙ్ నండొ సాయం కిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","విజేరె కూడిఃతి మహి బాడ్డిదు అపొలొ యూదురువెట వాదిస్తాండ్రె వరి వాదం తప్పు ఇజి గటిఙ‌ వెహ్తాన్‌. యేసునె క్రీస్తు ఇజి దేవుణు మాటదు రాస్తికెఙ్ ‌వెహ్సి రుజుప్‌ ‌కిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","అపొలొ కొరింతు పట్నమ్‌దు మహివలె పవులు, ముస్కుమ‍న్ని దేసెమ్‌ది నాహ్‌కాణిఙ్‌ బూలాజి సువార్త వెహ్సి ఎపెసు పట్నమ్‌దు వాతాన్. బాన్‌ సెగొండార్‌ సిసూరిఙ్ ‌సుడ్ఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","“మీరు నమ్మిత్తివలె దేవుణు ఆత్మ సత్తు మీ ముస్కు వాతాదా సిల్లెదా?”, ఇజి వరిఙ్ వెన్‌బాతాన్. వెన్‌బాతిఙ్‌ సిల్లెద్‌, దేవుణు ఆత్మ మనాద్‌ ఇజి మాప్‌ ఎసెఙ్‌బా నెస్‌ఏప్”, ఇజి వారు వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","దన్నిఙ్‌ పవులు, “మీరు ఎమేణి బాప్తిసం లాగె ఆతిదెర్”, ఇజి వెన్‌బాతిఙ్, “మాపు యోహాను సిత్తినన్ని బాప్తిసం లాగె ఆతాప్” ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","పవులు మరి వెహ్తాన్‌, “పాపమ్‌కు ఒప్పుకొడ్ఃజి డిఃస్తివరిఙె యోహాను బాప్తిసం సిత్తాన్‌. నా వెనుక వాని యేసు ముస్కు నమకం ఇడ్‌దు”, ఇజి వెహ్తాండ్రె బాప్తిసం సిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","యాక వెహారె వారు యేసుప్రబు పేరు అస్తారె బాప్తిసం లాగె ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","పవులు వరి ముస్కు కికు ఇడ్తిఙ్ ‌దేవుణు ఆత్మ వరి ముస్కు వాతాద్. వాతిఙ్, వారు వరిఙ్ ‌నెస్‌ఇ ఆఇ బాసెఙ్‌ వర్గితార్. దేవుణుబాణిఙ్‌ వాతి మాటెఙ్‌ ‌వెహ్తెఙ్‌ మొదొల్‌స్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","వారు డగ్రుడగ్రు పన్నెండు మణిసిర్‌ మొగకొడొఃర్ ‌మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","పవులు అయ ఎపెసు పట్నమ్‌దు మన్ని యూదురి మీటిఙ్‌ ‌ఇండ్రొ సొహాండ్రె దేవుణు ఏలుబడిః వందిఙ్‌ తర్కిసి వర్గిజి వరిఙ్ ‌ఒపుకొడిఃసి దయ్‌రమ్‌దాన్‌ వర్గితాన్. ఆహె మూండ్రి నెలెఙ్‌ బానె మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","గాని సెగొండార్‌ గర్ర ఆజి అసల నమ్మిఏతార్. వారు పవులు వెహ్తి సువార్త వందిఙ్ విజెరి ముందాల దుసలాడిఃజి వర్గితార్. అందెఙె పవులు వరిఙ్‌ డిఃసి నమ్మితి వరిఙ్‌ వన్నివెట ఒతండ్రె రోజు రోజు తురాను ఇని ఒరెన్‌ వన్ని బడిః ఇండ్రొ నెస్పిస్త మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","రుండి పంటెఙ్‌ దాక పవులు యాలెకెండ్‌ వెహ్సిసిత్తిమహిఙ్‌ అయ ఆసియ ప్రాంతమ్‌దు బత్కిజిని యూదురు, యూదురు ఆఇకార్, విజేరె దేవుణు మాట వెహార్. ");
INSERT INTO kfc_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","దేవుణు పవులువెట ఒద్దె గొప్ప బమ్మాతి పణిఙ్ ‌జర్గిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","వన్ని తువాలిఙ్, నడుఃముదు తొహ్ని కటు జబ్బు మన్నివరి డగ్రు తత్తిఙ్‌ వారు నెగెండ ఆతార్. దెయమ్‌కు విజు డిఃస్తె సొహె. ");
INSERT INTO kfc_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","అయావలె యూదురు లొఇ సెగొండార్‌ మోటిగురుఙ్‌ బూలాజి దెయమ్‌కాఙ్‌ పేర్‌జి మహార్‌. దెయమ్‌కాఙ్‌ పేర్దెఙ్ నెస్తికార్‌ వారు. వారు యేసుప్రబు పేరు అసి దెయమ్‌కాఙ్‌ ‌పేర్దెఙ్ ‌సుడ్ఃతార్. “పవులు వెహ్ని యేసు సత్తుదాన్‌ వెహ్సిన, నీను విన్నిఙ్ డిఃసిసి సొన్‌అ ఇజి నాను ఆడ్ర ‌సీజిన”, ఇజి వారు దెయమ్‌కాఙ్‌ అస్తి వరిఙ్ ‌వెహ్సి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","స్కెవ ఇని ఒరెన్‌ యూదపెరిపుజేరి మరిసిర్‌‌ ఏడుగురు యా లెకెండ్ దెయమ్‌కాఙ్‌ పేర్‌దెఙ్‌ సుడ్ఃజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","గాని ఆ దెయం వరివెట, “నాను యేసుఙ్‌ నెస్నా, పవులు ‌నెసిన, గాని మీరు ఎయిదెర్‌?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","అయ దెయం అస్తిమహికాన్ ‌వరిముస్కు ఎగ్రితాండ్రె విజెరిఙ్‌ ‌అడిఃగి అర్‌ప్తాండ్రె గెలిస్తాన్. వరి పాతెఙ్‌ కిస్త విసీర్తాండ్రె గొప్ప దెబ్బెఙ్ ‌డెఃయ్తాన్. అందెఙె వారు ఏడుగురు లోకుర్ డుమ్‌డ ఆతారె దెబ్బెఙ్ ‌తాక్తిఙ్‌ అయ ఇండ్రొణిఙ్‌ సోత్తారె ఉహ్‌క్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","అయ ఎపెసు పట్నమ్‌దు మహి విజేరె యూదురు, యూదురు ఆఇ జాతిదికార్‌ యాక వెహారె గొప్ప తియెలాతార్. యేసుప్రబు పేరుదిఙ్‌ గొప్ప గవ్‌రం సిత్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","కొత్తఙ్‌ నమ్మితికార్ ‌నండొండార్‌ వాతారె వారు కిత్తి సెఇ పణిఙ్‌ విజు విజెరి ముందాల వెహ్తరె ఒప్పుకొటార్. ");
INSERT INTO kfc_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","కొత్తఙ్ నమ్మితి సెట్ణిపణికినికార్ ‌నండొండార్‌ మంత్రమ్‌కు రాస్తిమని వరి పుస్తకమ్‌కు తత్తారె విజెరి ముందాల అక్కెఙ్‌ సుర్తార్. వారు లెక్క సుడ్ఃతిఙ్‌ ‌వనక దర యబాయ్‌ వెయిఙ్‌ వెండిరుపాయిఙ్ వాతె. ");
INSERT INTO kfc_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ఈహె దేవుణు - మాట విజుబాన్ సాటె ఆతాదె నండొండార్ నమ్మితికార్ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ఇక్కెఙ్ విజు జర్గితి వెనుక పవులు మసిదోనియ అకాయ ఇని దేసమ్‌కాఙ్ సొన్సి దేవుణు సఙమ్‌కాఙ్ సుడిః సొన్సి వెనుక బాణిఙ్‌ ‌యెరూసలేం పట్నమ్‌దుబా సొండ్రెఙ్‌వలె ఇజి ఒడిఃఒడిఃబితాన్. వెనుక‍ రోమ‍ ప‍ట్నమ్‌దుబా సొండ్రెఙ్‌వలె ఇజి ఒడిఃబితాన్. ");
INSERT INTO kfc_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","వన్నివెట కూడ్ఃజి పణి కిజిమహి తిమోతి, ఎరాస్తు ఇనివరిఙ్ ‌మసిదోనియాదు పోక్తాండ్రె పవులు సెగం కాలం ఆసియ ప్రాంతమ్‌దు బత్కితాన్. ");
INSERT INTO kfc_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","అయ కాలమ్‌దు యేసుప్రబు ముస్కు లోకుర్ నమకం ఇట్తి వందిఙ్ ‌ఉండ్రి గొప్ప గొడఃబ వాతాద్. ");
INSERT INTO kfc_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ఇక్క ఎలాగ ‌ఇహిఙ, దెమెత్రి ఇని ఒరెన్‌ సరాబు మహాన్‌. వాండ్రు వెండిదాన్‌ అర్తెమి ఇని దెయమ్‌దిఙ్ ‌ఇండ్రొ ఇడ్ని ఇజిరి గుడిఃఙ్ ‌తయార్‌ కినికాన్. యా దెమెత్రిఙ్, వన్నివెట మహి సరాబురిఙ్ ‌విజెరిఙ్‌ యా పణిదాన్ నండొ లాబం దొహ్‌క్సి మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","యా దెమెత్రి యా పణికినివరిఙ్‌ని, వ‍రిలె‍కెండ్ ఆఇపణిఙ్ కిని వరిఙ్‌బా కూడుఃప్తాండ్రె ఈహు వెహ్తాన్‌, “బాబురాండె, యా పణిదానె ఎక్కు ఆస్తి మఙి వానాద్ ‌ఇజి మీరు నెసినిదెర్‌గదె. ");
INSERT INTO kfc_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","గాని కికాణిఙ్‌ ‌తయార్‌ కినికెఙ్‌ దెయమ్‌కు ఆఉ ఇజి యా పవులు వెహ్సి, ఎపెసు పట్నమ్‌దు ఉండ్రె ఆఏద్‌, ఆసియ ప్రాంతమ్‌దు విజుబాణిలెకెండ్ నండొండారిఙ్‌ నమ్మిసి మహ్తాన్. ఇక మీరు సుడ్ఃజినిదెర్. వెంజినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ఏలు గొప్ప ప్రమాదం ఆజినాద్. మా పణి వందిఙ్ మన్ని నెగ్గి పేరు పాడాఃనాద్లె. అక్కాదె ఆఏండ పెరి దెయమాతి యా అర్తెమి దెయమ్‌ది గుడిఃబా ఎయెరిఙ్‌బా అవ్‌సరం సిల్లెండ ఆనాద్. ఆసియ దేసెమ్‌దికార్‌ విజేరె, బూలోకం విజు పూజ కిని యా అర్తెమి దెయమ్‌ది గొప్ప పేరు సిల్లెండ ఆనాద్‌లె”, ఇజి యా దెమెత్రి వరివెట వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","యాక వెహారె వారు గొప్ప కోపం ఆతారె, “ఎపెసుదికార్‌ పూజకిని అర్తెమి దెయం గొప్ప పెరి దెయం”, ఇజి గొప్ప గగోల్‌ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","అయ పట్నమ్‌దు గొప్ప కలిబిలి ఆతాద్. వారు ఉండ్రె మన్సు ఆతారె పవులువెట బూలాజి మహి మసిదోని - యాదికార్ గాయి, అరిస్తర్కు ఇని రిఏరిఙ్‌ ‌అస్తారె అయ పట్నమ్‌దు మన్ని పెరి సద్రుదు లాగిత ఒతార్. ");
INSERT INTO kfc_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","మంద కూడిఃతి మహి అయ సద్రుదు సొండ్రెఙ్‌ ఇజి పవులు ఒడిఃఒడిఃబితాన్. గాని నమ్మితికార్‌ వన్నిఙ్‌ సరి సిఏతార్. ");
INSERT INTO kfc_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","పవులు కూలయెర్‌ ‌ఆతి అయ ఆసియ ప్రాంతమ్‌ది అతికారి లోకుర్ ‌సెగొండార్‌బా లోకుర్‌ కూడ్ఃజివాతిమహిబాన్ సొన్మా ఇజి కబ్రు పోక్తారె బతిమాలితార్. ");
INSERT INTO kfc_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","అయ సద్రుదు గొప్ప కలిబిలి జర్గితాద్. సెగొండార్‌ అహు వెహ్సి, మరి సెగొండార్‌ ఈహు వెహ్సి గగోల్‌ ఆతార్. గాని వారు ఇని దన్నిఙ్‌ కూడిఃత మనారొ ఇజి నండొ లోకుర్‌ నెస్‌ఏతార్. ");
INSERT INTO kfc_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","యూదురు అలెక్‌జెండర్‌ ఇనివన్నిఙ్, విజెరె వందిఙ్‌ నీనె వర్‌గిఅ ఇజి లోకుర్‌ నడిఃమిహాన్ ‌ముందాల నిల్‌ప్తార్. అలెజి మండ్రు ఇజి వాండ్రు కియు సాప్తాండ్రె ఉండ్రి మాట వెహ్న ఇజి సుడ్ఃజి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","గాని వాండ్రు యూద వాండ్రు ఇజి నెస్తారె వారు రుండి గంటెఙ్‌ దాక, ‘ఎపెసువరి అర్తెమి దెయం గొప్ప దెయం’ ఇజి ఉండ్రెలెకెండ్ ‌గగోల్ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","అయావలె అయ పట్నం కర్ణం వాతాండ్రె లోకాఙ్‌ విజెరిఙ్‌ ‌గగొల్‌ ఆఏండ మండ్రు ఇజి వెహ్తాన్‌. “ఎపెసు పట్నమ్‌దికిదెరా, మాపు అర్తెమి పెరి దెయమ్‌ది గుడిఃదిఙ్ ‌కాప్‌ కినికాప్‌ ‌ఇజి విజేరె నెసినార్‌గదె. ఆగాసమ్‌దాన్ ‌అర్తి అర్తెమి దెయమ్‌ది పణుకుదిఙ్‌బా కాపు కినికార్‌ ‌మాపె ఇజి విజేరె నెసినార్‌గదె. ");
INSERT INTO kfc_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","యా సఙతిఙ విజు ఎద్రిసినిక ఆఏద్‌. అహిఙ మీరు ఏలు అలెజి మండ్రెఙ్‌ వలె. ఇనికబా గజిబిజి ఆజి కిదెఙ్ ‌ఆఏద్‌. ");
INSERT INTO kfc_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","మీరు యా లోకాఙ్‌ లాగితి తత్తిదెర్. గాని వీరు గుడిఃఙ డొఙ కినికార్‌ ‌ఆఏర్. మా దెయమ్‌దిఙ్‌ దుసలాడ్ఃఏర్. ");
INSERT INTO kfc_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","దెమెత్రిఙ్, వన్నివెట కూడిఃతి మహి పణిమణిసిరిఙ్ ‌ఎయెన్ ‌ముస్కుబా నేరం మొప్తెఙ్ ఇహిఙ, కోర్టుఙ్ నడిఃసినె, అతికారి లోకుర్‌ మనార్. బానె సొన్సి వారు ఒరెన్‌ముస్కు మరి ఒరెన్ నేరమ్‌కు సీదెఙ్. ");
INSERT INTO kfc_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","గాని మరి ఇనివందిఙ్ ‌ఇనికబా తగ్గు మహిఙ అక్క రోజు జర్గిని సద్రుదు వర్గిజి తీర్‌పు తీరిస్తెఙ్. ");
INSERT INTO kfc_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","నేండ్రు జర్గితి గొడఃబవందిఙ్‌ రోమ అతికారిఙు మా ముస్కు కేసు పొక్నారొ ఇజి నాను తియెలాజిన. ‌జ‍ర్గితి గొడఃబవందిఙ్ వెహ్తెఙ్‌ ఇని మాటబా సిల్లెద్‌. ఎందానిఙ్‌ ఇహిఙ యావజ కూడ్ఃజి గగోలాజి వర్గినిదన్నిఙ్ ‌వెహ్తెఙ్‌ అసల కారణం సిల్లెద్‌”, ఇజి వరివెట వెహ్తాన్‌‌. ");
INSERT INTO kfc_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","వాండ్రు ఈహు వెహ్సి కూడిఃతి మహి వరిఙ్ విజెరిఙ్‌ ‌సొండ్రు ఇజి పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","అయ గొడఃబ అణస్తి వెనుక పవులు నమ్మిత్తివ‍రిఙ్ ‌కూక్‌పిస్తాండ్రె వరి న‍మకమ్‌దిఙ్ స‍త్తు కిబిస్తాన్. దయ్‌రమ్‌ముస్కు ‌మండ్రు ఇజి వెహ్సి సెల్వ లొస్తాండ్రె మసిదోనియదు సొండ్రెఙ్‌ సోత్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","పవులు ఆ దేసెం విజు బూలాజి నమ్మితి వరిఙ్‌ సుడ్ఃజి సొహాన్‌. వరి నమకమ్‌దిఙ్ సత్తు కిబిస్తాన్. వెనుక అకాయ ఇజి కూక్ని గ్రీసు దేసమ్‌దు వాతాన్‌ ");
INSERT INTO kfc_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","పవులు అబ్బె మూండ్రి నెలెఙ్‌ మహాన్‌. ఓడః ఎక్సి సిరియాదు సొన ఇజి మహిఙ్‌ యూదురు వన్నిఙ్ ‌సప్తెఙ్ కుట్ర ఆజి మహార్‌‌ ఇజి వెహాన్. అక్క నెస్తాండ్రె మసిదోనియదాన్ నడిఃజి సొన్సి అబ్బెణాన్ ఓడః ఎక్సి సొండ్రెఙ్‌ ఒడిఃబితాన్. ");
INSERT INTO kfc_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","పురు మరిసి ఆతి బెరెయ పట్నమ్‌దికాన్‌ ‌సొపత్రు ఇనికాన్, దెసలోనియదికార్ ‌అరిస్తర్‌కు, సెకుందు ఇనికార్, దెర్‌బ పట్నమ్‌దికాన్‌ గాయి ఇనికాన్, మరి తిమోతి, ఆసియ దేసెమ్‌దికార్‌ ఆతి తుకికు, త్రోపిము ఇనికార్‌ పవులు వెట సొహార్. ");
INSERT INTO kfc_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","వీరు ముందాల్నె సొహరె త్రోయ ఇని పట్నం మా వందిఙ్‌ సుడ్ఃజి మహార్‌‌. ");
INSERT INTO kfc_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","పులాఙ్‌ ఆఇ రొట్టెఙ పండొయ్‌ ఆతి వెనుక మాపు పిలిప్పి పట్నం డిఃసి ఓడః ఎక్సి అయ్‌దు రోస్‌కాణ్‌ త్రోయ పట్నం వాతాప్. అబ్బె ముందాల సొహిమహివరివెట ఏడు రోస్కు మహప్. ");
INSERT INTO kfc_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","వారమ్‌ది మొదొహి రోజు ప్రబు ఏర్‌పాటు కిత్తి బోజనం తిండ్రెఙ్‌ మాపు కూడిఃత వాతాప్. అయావలె పవులు మర్స నాండిఙ్‌ సొనాలె ఇజి వరిఙ్ నెస్పిస్తాన్. మదరెయు - దాక నండొ మాటెఙ్‌ ‌వర్గిజి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","మాపు కూడిఃతి మహి మేడః గదిదు నండొ దీవెఙ్‌ మహె. ");
INSERT INTO kfc_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","అయావలె అయ్తుకు ఇని ఒరెన్ ‌దఙ్‌డాఃయెన్‌ కిటికిదు బస్తాండ్రె వెంజిమహాన్. వెంజిమహిఙ్ నిద్ర వాతాద్. పవులు లావు సుట్కు నెస్పిస్తి మహిఙ్‌ యా దఙడాఃయెన్‌ నిద్ర లావాత్తిఙ్‌ జోఙితాండ్రె మూండ్రి అంత్రంకాణిఙ్ ‌అడిఃగి అర్తాన్. పెహ్తి సుడ్ఃతిఙ్‌ సాత మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","గాని పవులు అడ్గి డిఃగితాండ్రె వన్ని ముస్కు అర్సి వన్నిఙ్‌ పొంబిజి అస్తాన్. “మీరు బాద ఆమాట్. వన్ని పాణం వన్నిలొఇనె మనాద్”, ఇజి వరివెట వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","పవులు మరి మేడఃముస్కు సొహాండ్రె రొటె రుక్సి వరివెట బోజనం కిత్తాన్‌. జాయానిదాక నండొ మాటెఙ్‌ వర్గిజి సోతాండ్రె సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","వారు బత్కితి మహి అయ దఙ్‌డెఃఙ్ ‌ఇండ్రొ తతార్‌ గొప్ప సర్ద ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","పవులు అసోసు ఇనిబాన్‌ నడిఃజి సొండ్రెఙాతిఙ్‌ మాపు వన్నిముందాల ఓడః ఎక్సి అసోసు సొహప్‍. పవులుఙ్‌ బానె ఓడఃదు ఎక్నాప్‌ ఇజి మాపు ఒడిఃబిత్తాప్. ");
INSERT INTO kfc_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","అసోసుదు పవులు మా వెట కూడిఃతివలె మాపు వన్నిఙ్ ‌ఓడఃదు ఎకిస్తాపె మితులె ఇని బాడ్డిదు వాతాప్. ");
INSERT INTO kfc_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","బాణిఙ్‌ సోసి మహ్స నాండిఙ్‌ కియోసు ఇని బాడ్డిఙ ఎద్రు వాతాప్. మహ్స నాండిఙ్‌ ‌సమోసు ఇనిబాన్‌ ‌సొహాపె బాణిఙ్‌ మహ్స నాండిఙ్‌ ‌మెలితె ఇని బాడ్డిదు వాతాప్. ");
INSERT INTO kfc_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","పెంతెకోస్తు ఇని పండొయ్‌నాండిఙ్‌ యెరూసలేమ్‌దు అందిదెఙ్‌వలె ఇజి పవులు తొంత్ర ఆతాన్. ఆసియదు సొహిఙ అలస్యం ఆనాద్‌ ఇజి ఎపెసు పట్నమ్‌దు సొన్ఎండ తినాఙ్‌ సొండ్రెఙ్‌ ఒడిఃఒడిఃబితాన్. ");
INSERT INTO kfc_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","అందెఙె పవులు మిలెతుదు అందితివలె ఎపెసు పట్నమ్‌దు మన్ని సఙమ్‌ది పెద్దెల్‌ఙ వన్నిబాన్‌ కూక్‌పిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","వారు వన్ని డగ్రు వాతిఙ్‌ పవులు వరివెట ఈహు వెహ్తాన్‌, “నాను ఆసియదు వాతి మొదొల్ దినమ్‌కాఙ్‌ ఎలాకాలం మీ నడిఃమి ఎలాగ బత్కిజి మహానొ ఇజి మీరె నెస్నిదెర్‌గదె. ");
INSERT INTO kfc_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","యూదురు నఙి సప్తెఙ్‌ కుట్ర కిజి నఙి మాలెఙ్ కిత్తార్‌ గాని నాను గొప్ప వాండ్రు ఇజి ఒడిఃబిఏండ కణెరు వాక్సి దేవుణు పణి కిజి ఎలాగ మహానొ ఇజి నిఙినె తెలినాద్. ");
INSERT INTO kfc_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","సిక్సదాన్‌ ఎలాగ గెలిస్తెఙ్‌ ఇని వందిఙ్‌ అవ్‌సరమాతిక ఇనికబా సరినె మీలోకుర్‌ నడిఃమి విజేరె కూడిఃతి మహి బాడ్డిదు నాను సాటిస్త. మీ ఇల్కాఙ్‌బా వాతానె మిఙి నెస్పిస్త. ");
INSERT INTO kfc_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","పాపమ్‌కు ఒప్పుకొడ్ఃజి డిఃసిసీజి, దేవుణుదిఙ్‌ లొఙిజి, మా ప్రబు ఆతి యేసుక్రీస్తు ముస్కు నమకం ఇడ్‌దు ఇజి నాను యూదురిఙ్‌ యూదురు ఆఇ వరిఙ్‌ సాసి వెహ్త. ");
INSERT INTO kfc_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ఇదిలో, నాను దేవుణు ఆత్మదిఙ్‌ లొఙిత్తానె యెరూసలేమ్‌దు సొన్సిన. అబ్బె నఙి ఇనిక జర్గినాద్లెనొ నఙి తెలిఏద్. ");
INSERT INTO kfc_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","గాని విజు పట్నమ్‌కాఙ్‌బా, నఙి మాలెఙ్ ‌వాజినె ఇజి, యెరూసలేమ్‌దు నఙి జెలిదు ఇడ్నార్లె ఇజి, దేవుణు ఆత్మ నఙి వెహ్సినాన్. ");
INSERT INTO kfc_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","గాని నా పాణమ్‌దిఙ్‌ నాను కండెక్‌బా విలువ సిఏ. ఎందానిఙ్‌ ఇహిఙ ప్రబు ఆతి యేసు నఙి సిత్తి పణి పూర్తి కిదెఙె. అయ పణి ఇనిక ఇహిఙ దేవుణు దయాదర్‌మమ్‌వందిఙ్‌ మన్ని సువార్త వందిఙ్ నాను సాసి వెహ్తెఙ్. ");
INSERT INTO kfc_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","నాను బూలాజి దేవుణు ఏలుబడిః వందిఙ్‌ మీ నడిఃమి వెహ్త గాని మీలొఇ ఎయిదెర్‌బా మరి నఙి తొఇదెర్లె ఇజి నాను ఏలు నెస్నా. ");
INSERT INTO kfc_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","గాని మీలొఇ ఎయిదెర్‌బా పాడాఃజి సొహిఙ నా పూసి తెవితాద్ ‌ఇజి నేండ్రు మీరె సాసిర్‌ ఆనిదెర్‌లె. ");
INSERT INTO kfc_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","దేవుణు ఇస్టం పూర్తి నాను మిఙి నెస్పిస్త. ఇనికబా డాఃప్‌ఏత. ");
INSERT INTO kfc_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","దేవుణు వన్ని సొంత మరిసి నల సితండ్రె సఙమ్‌దిఙ్‌ ‌సమ్‌పాదిస్తాన్. అయ సఙమ్‌దిఙ్‌ మీరు బాగ కాప్‌కిదెఙ్. దేవుణు ఆత్మ మిఙి సఙమ్‌దిఙ్‌ సుడ్ఃదెఙ్‌ ఒపజెప్తాన్. అయ పణిలొఇ నెగ్రెండ సుడ్ఃదు. మీవందిఙ్‌బా మీరు జాగర్త సుడ్ఃదు. ");
INSERT INTO kfc_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","నాను సొహి వెనుక క్రూరమాతి కార్‌నుకుడిఃఙ్ నన్ని లోకుర్ ‌మీలొఇ డుఃగ్నార్లె ఇజి నాను నెస్నా. వారు నమ్మితి వరి ముస్కు కనికారం తోరిస్‌ఏర్. సఙమ్‌దిఙ్‌ పాడు కినార్. ");
INSERT INTO kfc_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","మీలొఇహానె సెగొండార్, నమ్మితి వరిఙ్ వెకొరి మాటెఙ్‌ వెహ్సి ‌నెగ్గి సరిదాన్‌ లాగ్జి సెఇ సరిదు నడిఃపిసి, వరివెట కూక్సి ఒతెఙ్‌ ‌సూణార్లె. ");
INSERT INTO kfc_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","అహిఙ జాగర్త మండ్రు. నాను మూండ్రి పంటెఙ్‌ దాక రెయుపొగలు కణెరు వాక్సి నమకమ్‌వందిఙ్ విజెరిఙ్, ఒరెన్ ఒరెన్ వన్నిఙ్ డిఃస్‌ఏండ‍ వెహ్త మన్న. అక్క మీరు ఒడిఃబిజి జాగర్త మండ్రు. ");
INSERT INTO kfc_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","దేవుణుదిఙ్‌ని వన్ని ద‍యాదర్మం తోరిస్ని మాటదిఙ్‌ మిఙి ఒపజెప్సిన. మీ నమకం నండొ కిదెఙ్‌ అట్ని దేవుణు - మాటదిఙ్ మిఙి ఒపజెప్సిన. దేవుణుదిఙ్‌ ‌కేట ఆతి వరివెట మిఙి అక్కు సీదెఙ్‌ అట్ని‌ దేవుణుమాటదిఙ్ మిఙి ఒపజెప్సిన. ");
INSERT INTO kfc_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","నాను ఎయె డబ్బుదిఙ్, బఙరమ్‌దిఙ్, సొక్కెఙ్ పాతెఙ్‌ వందిఙ్ ఆస ఆఏత ");
INSERT INTO kfc_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","నా అవ్‌సరమ్‌వందిఙ్‌ గాని నావెట మహివరి అవ్‌సరమ్‌కు వందిఙ్ గాని ‌నా కికాఙణిఙె పణి కిజి బత్కిత్త ఇజి మీరు నెసినిదెర్. ");
INSERT INTO kfc_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","నాను కిత్తి విజు పణిఙాఙ్‌ మిఙి నెస్‌పిస్తిక ఇనిక ఇహిఙ మీరు డటం పణి కిజి సిల్లి వరిఙ్‌ సాయం కిదెఙ్. దిన్ని వందిఙ్‌ యేసుప్రబు నెస్‌పిస్తి మాట గుర్తు కిదెఙ్. అక్క ఇనిక ఇహిఙ సీనివన్ని సర్ద లొస్నివ‍న్ని సర్ద ఇంక పెరిక. ");
INSERT INTO kfc_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","పవులు ఈహు వెహ్తండ్రె ముణుకుఙ్‌ ‌ఊర్‌జి వారు విజెరె వెట పార్దనం కిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","వారు విజేరె పవులుఙ్‌ పొంబితారె వన్నిఙ్‌ ముద్దు కిజి ‌లావు అడఃబాతార్. ");
INSERT INTO kfc_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ఎందానిఙ్‌ ‌ఇహిఙ, మీరు ఇబ్బెహాన్ నఙి సుడ్ఃఇదెర్లె ఇజి పవులు వెహ్తి అయ మాటవందిఙె గొప్ప దుకం ఆతార్. వారు ఓడః ఎక్ని అందు పవులు ఇట్తా వాతార్. ");
INSERT INTO kfc_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","మాపు వరిఙ్ ‌డిఃసిసోత్తి వెనుక ఓడః ఎక్తాపె తినాఙ్‌ సొన్సి కోసు ఇనిబాన్‌ వాతాప్. మహ్స నాండిఙ్‌ ‌రోదు ఇనిబాన్‌ ‌వాతాపె బాణిఙ్‌ ‌పతరు ఇనిబాన్‌ వాతాప్. ");
INSERT INTO kfc_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","బానె పెనికెదిఙ్‌ సొని ఉండ్రి ఓడః సుడ్ఃతాపె, ఎక్తాపె సొహప్‍. ");
INSERT INTO kfc_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","సొహపె కుప్ర ఇని ద్వీపు మా డేబ్ర పడఃకాద్‌ సుడ్ఃతాప్‌ గాని దన్ని డేబ్ర పడఃకదాన్‌ తినాఙ్‌ సిరియ దరోట్‌ ‌సొహాపె, తూరు ఇనిబాన్‌ డిఃగితాప్. బాన్‌ డిఃప్తెఙ్ ‌ఓడఃదు సామనమ్‌కు మహె. ");
INSERT INTO kfc_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","బాన్‌ సిసూరిఙ్‌ రెబాజి సుడ్ఃతిఙ్‌ ‌వరివెట కూడిఃతాపె ఏడు రోస్కు బానె మహప్. ‘నీను యెరూసలేమ్‌దు సొన్మా’, ఇజి దేవుణు ఆత్మ వెహ్తి లెకెండ్ పవులు ‌వెహ్తార్‌ ");
INSERT INTO kfc_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","6","గాని బాణిఙ్‌ ‌సొండ్రెఙ్‌ టయం ఆతివలె మాపు సోత్తాపె పయ్‌నం కితాప్. నమ్మితికార్‌ విజేరె, అయ్‌లికొడొఃక్, కొడొఃర్, మా వెట పట్నం వెల్లిదాక ఇడ్డిః వాతార్. మాపు విజెపె సమ్‌దరం ఒడ్డుదు ముణుకుఙ్‌ ‌ఊర్‌జి పార్దనం కిత్తాపె ఒరెన్‌ వెట ఒరెన్‌ సెలవ లొస్తాపె ఓడః ఎక్తాప్. వారు వరి ఇండ్రొ మర్‌జి సొహార్. ");
INSERT INTO kfc_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","మాపు తూరుదాన్ ‌సోత్తాపె తొలెమాయి ఇని పట్నమ్‌దు వాతాప్. బాన్‌ నమ్మితి తంబెర్‌సిరిఙ్‌‌ సుడిః సొహపె వరివెట ఉండ్రి రోజు మహప్. ");
INSERT INTO kfc_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","మహ్స నాండిఙ్‌ సోత్తాపె కయ్‌సరియాదు వాతాప్. బానె సువార్త వెహ్నికాన్‌ పిలిపు ఇండ్రొ సొహపె వన్ని ఇండ్రొ మహప్. పిలిపు యెరూసలేమ్‌దు మన్ని సఙమ్‌దు ఏర్‌పాటు కిత్తి ఏడుగురు లొఇ ఒరెన్. ");
INSERT INTO kfc_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","అయా పిలిపుఙ్‌ నాల్గురు విడ్డిః అయ్‌లిక్‌ మహె. అవిక్‌ ‌దేవుణుబాణిఙ్ వాని మాటెఙ్‌ వెహ్నికెఙ్. ");
INSERT INTO kfc_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","మాపు సెగం రోస్కు బానె మహివలె అగబు ఇని ఒరెన్‌ ప్రవక్త యూదయ ప్రాంతమ్‌దాన్ ‌బానె వాతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","అగబు మాపు మన్నిబాన్ ‌వాతాండ్రె పవులు నడుముదు తొహ్తి మన్ని కటు కుతాన్. కుతాండ్రె, వన్ని కికాఙ్‌ కాల్కాఙ్‌ అగబు తొహె ఆతాన్. తొహె ఆతండ్రె, యా కటు ఎయెర్‌ది ఇహిఙ వన్నిఙ్ ‌యెరూసలేమ్‌దు మన్ని యూదురు తొహ్సి ఆఇ లోకాఙ్‌ ‌ఒపజెప్నార్లె ఇజి దేవుణు ఆత్మ వెహ్సినాన్‌ ‌ఇజి యా అగబు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","యాక మాపు వెహాపె ‌మాపు, బానె మహి నమ్మితికార్, పవులు వెట, “యెరూ - సలేమ్‌దు సొన్మా”, ఇజి బతిమాలితాప్. ");
INSERT INTO kfc_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","దన్నిఙ్‌ పవులు, “మీరు ఎందనిఙ్‌ ‌అడఃబాజి నఙి దుకం కిబిసినిదెర్? నా ప్రబు ఆతి యేసువందిఙ్‌ తొహె అదెఙె ఆఏద్‌, వన్ని వందిఙ్ ‌యెరూసలేమ్‌దు సాదెఙ్‌బా నాను ఒప్పుకొడ్ఃజిన”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","పవులు మా మాటెఙ్‌ ఒప్పుకొడ్ఃఇతిఙ్‌ మాపు అలెతాప్. దేవుణుదిఙ్‌ ఇస్టమాతి వజ జర్గిపిద్‌ ఇహాప్. ");
INSERT INTO kfc_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","అయ పట్నమ్‌దు సెగం రోస్కు మహి వెనుక మాపు సామనమ్‌కు విజు అస్తాపె ఎక్కు యెరూసలేం పట్నమ్‌దు సొండ్రెఙ్‌ సోత్తాప్. ");
INSERT INTO kfc_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","కయ్‌సరియదాన్‌ సెగొండార్‌ సిసూర్‌ మా వెట వాతారె మాపు మండ్రెఙ్‌ ఇజి ఒడిఃబిత్తి మ్నాసోను ఇండ్రొ మఙి తతార్. మ్నాసోను కుప్రదికాన్. మొదొహాన్ ‌అసి యేసుప్రబు సిసూడుః ఆతికాన్. ");
INSERT INTO kfc_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","మాపు యెరూసలేమ్‌దు వాతిఙ్‌ ‌నమ్మిత్తి తంబెర్‌సిర్‌ ‌మఙి సర్దదాన్‌ ‌మర్యాద కిత్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","మర్స నాండిఙ్‌ పవులు మా వెట యాకోబు డగ్రు సొహాన్‌. సఙం పెద్దెలుఙు విజేరె బానె మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","పవులు వరిఙ్ ‌మాడిఃస్తాన్. వెనుక యూదురు ఆఇవరిలొఇ పవులు కిత్తి సువార్త పణిదాన్ ‌దేవుణు జర్గిస్తికెఙ్‌ విజు పూర్తి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","వారు ఇక్కెఙ్‌ వెహారె దేవుణుదిఙ్‌ స్తుతి కిత్తార్‌. పవులు వెట వారు ఈహు వెహ్తార్‌, “పవులునా, యూదురు లొఇ నమ్మితికార్‌ నండొ వెయుఙ్ ‌లోకుర్ ‌మనార్ ‌ఇజి నీను సుడ్ఃజినిగదె. వారు విజేరె దేవుణు మోసెఙ్‌ సిత్తి రూలుఙ్‌ వందిఙ్ నండొ పటుదల మనికార్. ");
INSERT INTO kfc_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ఇబ్బె మన్ని యూదురు విజేరె నీవందిఙ్‌ ఉండ్రి బోగట్ వెహ మనార్. అక్క ఇనిక ఇహిఙ, మోసె వెహ్తికెఙ్‌ విజు డిఃస్తెఙ్ ‌ఇజి నీను యూదురు ఆఇవరి లొఇ బత్కిని యూదు‍రిఙ్ నెస్పిసిని ఇజి. వరి ఇజిరి కొడొఃరిఙ్ సునతి కినిక ఆఏద్‌ ఇజి నీను నెస్పిసిని ఇజి. మరి, యూదురు ఎలాగ నడిఃదెఙ్‌ ఇజి మహి పదతిఙ్‍ వజ నడిఃనిక ఆఏద్‌ ఇజి నీను నెస్పిసిని ఇజి. వినకవందిఙ్‌ బోగట్ వెహ మహా‍ప్”, ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","“అహిఙ మాటు ఇనిక కిదెఙ్‌? నీను వాతివందిఙ్ విజేరె తప్‌ఏండ వెనార్. ");
INSERT INTO kfc_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","అందెఙె మాపు వెహ్నివజ నీను కిఅ. ఇనిక ఇహిఙ మొకు నిల్‌ప్తి మన్ని నాల్‌ఎర్ మొగావారు ‌ఇబ్బెనె మనార్. ");
INSERT INTO kfc_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","నీను వరిఙ్‌ వెట కూక్సి ఒసి వారు మొకుబడిః సొన్పిస్తెఙ్ వరివెట దేవుణు గుడిఃదు సొన్అ. వారు పూజ సీజి బుర్ర బోడి కిదెఙ్ మన్ని కర్సు నీనె సిఅ. అహిఙ నీవందిఙ్‌ లోకుర్‌ వెహిమన్ని బోగట్‌ నిజం ఆఏద్‌ ఇజి విజేరె నెస్నార్. నీను మోసె సిత్తి రూలుఙ లొఙిజి నడిఃజినాన్ ‌ఇజి విజేరె నెస్నార్. ");
INSERT INTO kfc_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","అహిఙ యూదురు ఆఇ నమ్మితి వరిఙ్ ‌మాపు ఇనిక తీర్‌మానం కిజి రాస్త మనాద్‌ ‌ఇహిఙ, బొమ్మెఙ ‌పూజ కిత్తి వన్కాఙ్‌ తినిక ఆఏద్‌ ఇజి, నల తినిక ఆఏద్‌ ఇజి, మెడః పిడిఃక్సి సప్తి వనకాఙ్ ‌తినిక ఆఏద్‌ ఇజి. రంకు బూలానిక ఆఏద్‌ ఇజి”. ఈహు సఙమ్‌ది పెద్దెలుఙు పవులు వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","అందెఙె పవులు, మహ్స నాండిఙ్‌ అయ నాల్‌ఎరిఙ్‌ వెట కూక్సి ఒతండ్రె వరివెట సుబ్బరం ఆతాన్. వారు సుబ్బరం ఆజి మంజిని కాలం ఎసెఙ్‌ ‌అందినాద్, వరి లొఇ విజేరివందిఙ్ ‌ఎసెఙ్‌ పూజ కిదెఙ్, ఇక్కెఙ్‌ ‌వెహ్నివందిఙ్‌ పవులు దేవుణు గుడిఃదు యూదురు లొఇ మొగావారు మండ్రెఙ్ మన్ని బాడ్డిదు సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","సుబ్బరం ఆజిమంజిని ఏడు రోస్కు డగ్రు ఆతాద్. అయావలె ఆసియదాన్ ‌వాతిమహి సెగొండార్‌ యూదురు, దేవుణు గుడిఃదు యూద మొగవ‍రిఙ్ మన్ని బాడ్డిఃదు పవులు సుడ్ఃతారె, బానె మహి లోకాఙ్‌ విజేరిఙ్‌ కలిబిలి కితారె వన్నిఙ్‌ అస్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","“ఇస్రాయేలు లోకాండె, తోడుః కిదెఙ్ ‌రద్దు. మా లోకాఙ్‌ పడ్ఃఇకెఙ్, మోసె సిత్తి రూలుఙ ‌పడ్ఃఇకెఙ్, యా దేవుణు గుడిఃదిఙ్‌ పడ్ఃఇకెఙ్‌ విజు బాడ్డిఙ సొన్సి లోకాఙ్‌ విజేరిఙ్‌ నెస్‌పిసినికాన్‌ వీండ్రె. అక్కాదె ఆఏండ, వీండ్రు యూదురు ఆఇ వరిఙ్ ‌దేవుణు గుడిఃదు కూక్త తతాండ్రె దేవుణుదిఙ్‌ కేట కిత్తి యా బాడ్డి మయ్ల కిత్తాన్‌”, ఇజి నండొ గగోలాతార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ఎందానిఙ్‌ ఇహిఙ, పట్నమ్‌దు పవులు వెట యూదురు ఆఇ ఎపెసుదికాన్ ‌త్రోపిమును ఇని ఒరెన్‌ వన్నిఙ్‌ ముందాల్నె వారు సుడ్ఃత‌ మహార్‌. వన్నిఙ్ పవులు దేవుణు గుడిఃదు యూదురి మొగ్గ వరిఙ్‌ మండ్రెఙ్ మన్ని బాడ్డిఃదు తతాన్‌ ఇజి వారు ఒడిఃబితార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","పట్నమ్‌దు మహి లోకుర్ విజేరె కలిబిలి ఆతార్. విజుబాణిఙ్ లోకుర్‌ మందెఙ్‌ మందెఙ్‌ ఆజి ఉహ్‌క్సి వాతారె పవులుఙ్‌ అస్తారె దేవుణు గుడిఃదు యూదురి మొగ్గ వరిఙ్‌ మండ్రెఙ్ మన్ని బాడ్డిహాన్‌ వెల్లి లాగితార్. వెటనె యూదురి మొగ్గ వరిఙ్‌ మండ్రెఙ్ మన్ని బాడ్డిదు సొని సేహ్లెఙ్‌ ‌కెహె ఆతె. ");
INSERT INTO kfc_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","పవులుఙ్‌ వారు సప్తెఙ్‌ ఇజి సుడ్ఃజిమహిఙ్ ‌యెరూసలేం పట్నం విజు కలిబిలి ఆతాద్‌ ‌ఇజి అబ్బె మహి రోమ సయ్‌నమ్‌ది పెరి అతికారిఙ్‌ కబ్రు వాతాద్. ");
INSERT INTO kfc_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","వెటనె అయ పెరి అతికారి సయ్‌నమ్‌దివరిఙ్, సదాతిపతివరిఙ్‌ వెట ఒతండ్రె కూడిఃతి మహి లోకుర్‌ డగ్రు ఉహ్‌క్సి వాతాన్. లోకుర్‌ అయ పెరి అతికారిఙ్, వన్నివెట వాతి సయ్‌నమ్‌ది వరిఙ్ ‌సుడ్ఃతిఙ్‌ ‌పవులుఙ్‌ ‌డెఃయ్దెఙ్‌ డిఃస్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","అయ పెరి అతికారి డగ్రు వాతండ్రె పవులు ‌అస్తాన్. ‘రుండి గొలుస్కాణిఙ్ వన్నిఙ్ ‌తొహ్తు’ ఇజి ఆడ్ర సిత్తాన్‌. వీండ్రు ఎయెన్‌? ఇనిక కి‌త్తాన్‌ ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","వెన్‌బాతిఙ్‌ ‌లోకుర్‌ సెగొండార్‌ ఈహు ఇజి, సెగొండార్ ‌అహు ఇజి వెహ్సి డేల్సి మ‍హిఙ్‌ గగోల్ ‌లావాత్తిఙ్ ని‌జం ఇనికాదొ ఇజి నెస్‌ఏండ ఆతండ్రె ‘బారి గోడఃలొఇ వన్నిఙ్‌ ఒతు’ ఇజి ఆడ్ర సిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","పవులు పావు అన్సు ముస్కు వాతివలె లోకుర్‌ ఒదె కోపమాజి లాగ్‌దెఙ్ ‌నెక్తెఙ్ ‌కిత్తిఙ్‌ సయ్‌నమ్‌దికార్‌ ‌పవులుఙ్‌ ‌పిండితారె ఒతార్. ");
INSERT INTO kfc_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ఎందానిఙ్‌ ఇహిఙ, వన్నిఙ్‌ సప్‌అ ఇజి లోకుర్‌ విజేరె డటం గగోలాజి వెటసొహార్. ");
INSERT INTO kfc_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","మొదొహి పావు అన్సుదాన్ ఎక్సి సొన్సి ఆకరి పావు అన్సు దాక వారు సొహార్‌. సయ్‌నమ్‌దికార్‌ ‌పవులుఙ్‌ ‌బారిగోడఃలొఇ ఒతెఙ్‌ ‌సుడ్ఃజి మహిఙ్‌ పవులు అయ పెరి అతికారి వెట, నీ వెట ఉండ్రి మాట వెహ్తెఙ్‌ ‌ఆనాదా ఇజి వెన్‌బాతాన్. అందెఙె అయ అతికారి, “గ్రీకు బాస నీను నెసినిదా?”, ఇజి వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","“యా దినమ్‌కాఙ్‌ ‌ముందాల్నె అతికారిఙ ఎద్రువెహ్సి లోకాఙ్‌ ‌సప్ని నాల్గి వెయి లోకాఙ్‌ బిడిఃఙ్‌బూమిదు వెట కూక్సి ఒసి మహి అయ్‌గుప్తు దేసెమ్‌దికి నీను ఆఇదా?”, ఇజి పవులుఙ్‌ వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","దన్నిఙ్‌ పవులు, “నాను కిలికియాదు మన్ని తార్సు పట్నమ్‌దికాన్‌ ‌యూద వాండ్రు. నాను అయ గొప్ప పట్నమ్‌ది లోకు. లోకుర్‌ వెట వర్గిదెఙ్‌ నఙి సెల్వ సిదా”, ఇజి బతిమాలితాన్. ");
INSERT INTO kfc_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","పవులు సెలవ లొస్తిఙ్ పెరి అతికారి సరి సిత్తాన్. అయావలె పవులు పావు అన్సు ముస్కు నిహండ్రె లోకాఙ్‌ అలెజి మండ్రు ఇజి కియు సయ్న కిత్తాన్‌. వారు అలెతి మహివలె పవులు యూదురి బాసాదు ఈహు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“తంబెరిఙాండె, బుబ్బరాండె, నా లొఇ ఇని తప్పుబా సిల్లెద్‌ ఇజి మీరు నెసినివందిఙ్ ‌నాను వెహ్సిని మాటెఙ్‌ వెండ్రు”. ");
INSERT INTO kfc_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","పవులు వరి సొంత బాసాదు వర్గినిక వెహారె వారు జమ్‌న అల్లెత మహార్‌. అయావలె పవులు ఈహు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“నాను కిలికియాదు మన్ని తార్సు పట్నమ్‌దికాన్‌ యూద వాండ్రు. అహిఙ యా పట్నమ్‌దు గొప్ప పేరు పొందితి మేస్టర్ గమాలియెలు బాన్‌ మోసె మా అనిగొగొరిఙ్ సిత్తి రూలుఙ ఎలాగ లోబడ్ఃదెఙ్‌ ‌ఇజి నెగ్రెండ నెస్తానె పిరితా. మీరు విజిదెరె నేండ్రు ఎలాగ పటుదలదాన్ మన్నిదెరొ అయ వజనె నానుబా యా రూలుఙ్‌ వందిఙ్ పటుదలదాన్‌ మహ. ");
INSERT INTO kfc_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","నాను యేసుప్రబు ముస్కు నమ్మితి వరిఙ్ మొగ్గకొడొఃరిఙ్, అయ్‌లి కొడొఃకాఙ్‌ ‌అసి తొహ్సి జెలిదు ఇడ్‌జి సానేండ మాలెఙ్ కిత. ");
INSERT INTO kfc_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","దిన్ని వందిఙ్, విజేరె పుజేరిఙ ముస్కు పెరి పుజేరి, పెద్దెలుఙు విజేరె నఙి సాసి ఆత మనార్. దమస్కు పట్నమ్‌దు మహి మా సొంత లోకురాతి యూదురు లొఇ మహి నమ్మిత్తి వరిఙ్‌బా అసి తొహ్సి మాలెఙ్ కిదెఙ్‌ యెరూసలేమ్‌దు తతెఙ్‌ ఇజి పుజేరిఙ బాణిఙ్‌ ‌ఉత్రమ్కు లొస్త ఒతానె దమస్కు పట్నమ్‌దు మహి యూదురుబాన్ ‌సొహ. ");
INSERT INTO kfc_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","నాను పయ్‌నం కిజి దమస్కు పట్నం డగ్రు సొన్సి మహిఙ్, మదెనం వేడఃదు, ఆగాసమ్‌దాన్ ‌వెటనె గొప్ప జాయ్‌ ‌నా సుటులం డెఃయ్‌తాద్. ");
INSERT INTO kfc_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","అయావలె నాను బూమి ముస్కు అర్తానె, ‘సవులు, సవులు, నీను ఎందానిఙ్‌ నఙి మాలెఙ్ కిజిని’, ఇజి నావెట ఉండ్రి జాటు వాతిక వెహ. ");
INSERT INTO kfc_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","‘ప్రబు, నీను ఎయి’ ఇజి నాను వెన్‌బాత. వెన్‌బాతిఙ్‌ వాండ్రు ‘నీను మాలెఙ్ కిజిని నజరేతుదికాన్‌ ‌ఆతి యేసునె నాను’, ఇజి నావెట వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","నావెట సొన్సి మహికార్‌ అయ జాయ్‌ సుడ్ఃతార్ గాని నావెట వర్గితిమహివన్ని జాటు నెస్‌ఏతార్. ");
INSERT INTO kfc_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","అయావలె నాను, ‘ప్రబు నాను ఇనిక కిదెఙ్’ ‌ఇజి వెన్‌బాతిఙ్, ‘నీను నిఙ్‌జి దమస్కు పట్నం సొన్‌అ. అబ్బె నీను ఇని పణి కిదెఙ్‌ ఇజి నీ వందిఙ్ ‌నాను ఏర్‌పాటు కిత్తికెఙ్‌ విజు నిఙి ఒరెన్ వెహ్ననాన్‌లె’ ఇజి నావెట ప్రబు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","అయ సుడ్ఃదెఙ్‌ అట్ఇ నన్ని పెరి జాయ్‌ మహిఙ్‌ ‌నాను కణుకు తోర్‌దెఙ్‌ ‌అట్‌ఎండాత. నావెట మహికార్‌ నా కికు అసి నడిఃపిసి దమస్కు పట్నమ్‌దు కూక్త తతార్. ");
INSERT INTO kfc_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","అయావలె మోసె సిత్తి రూలుఙ్‌ లొఙిజి, బక్తి మన్నికాన్‌ అననియ ఇనికాన్‌ ఒరెన్‌ బాన్‌ మహాన్‌. అబ్బె మహి యూదురు విజేరె యా అననియ, ఒరెన్ పల్కుబడిః మన్నికాన్‌ ‌ఇజి వెహ్సి మహార్‌. వాండ్రు నా డగ్రు వాతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","డగ్రు వాతండ్రె నా డ‍గ్రు నిహండ్రె, ‘సవులునా, బేస్‌అ’, ఇజి వెహ్తిఙ్‌ ‌వెటనె నాను బేస్తానె వన్నిఙ్ ‌సుడ్ఃత. ");
INSERT INTO kfc_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","అయావలె అయ అననియ వెహ్తాన్‌, ‘మా అనిగొగొరి దేవుణు నిఙి ఏర్‌పాటు కిత మనాన్. దేవుణు నిఙి ఇని పణి వందిఙ్‌ ఏర్‌పాటు కిత్తాండ్రొ అక్క నీను నెస్తెఙ్. అందెఙె నీను సుడ్ఃతిమహి, వెహిమహి నీతి నిజాయితి మన్నికాన్‌ నిఙి ఏర్‌పాటు కిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ఎందనిఙ్‌ ‌ఇహిఙ, నీను సుడ్ఃతికెఙ్, నీను వెహికెఙ్, విజు లోకాఙ్‌ ‌సొన్సి వెహ్తెఙ్, ‌వన్నివందిఙ్ ‌ఉండ్రి సాసివజ నీను మంజిని. ");
INSERT INTO kfc_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ఏలు ఎందనిఙ్‌ ఆలస్యమాజిని? నిఙ్‌జి బాప్తిసం లాగె ఆఅ. యేసు పేరు అసి, పార్దనం కిజి నీ పాపమ్‌కాణ్‌ నొరె ఆఅ’, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","నాను యెరూసలేమ్‌దు మర్‌జి వాతానె దేవుణు గుడిఃదు పార్దనం కిజి మహ. పార్దనం కిజి మహిఙ్‌ ఎద్రునె ఉండ్రి దర్సనం సుడ్ఃత. ");
INSERT INTO kfc_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","అయ దర్సనమ్‌దు నావెట, ‘నీను యెరూసలేం డిఃసి గజిబిజి సొన్‌అ. ఎందానిఙ్‌ ఇహిఙ నావందిఙ్‌ ‌నీను వెహ్ని సాసి వీరు ఒప్పుకొడ్ఃఏర్’, ఇజి వెహ్సి మహిక నాను సుడ్ఃత. ");
INSERT INTO kfc_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ప్రబు అయ మాట వెహ్తిఙ్‌ ‌నాను, ‘నాను యూదురి మీటిఙ్‌ ‌ఇల్కాఙ్‌ వరస సొన్సి మీ ముస్కు నమకం ఇట్తి వరిఙ్‌ డెఃయ్‌జి జెలిదు ఇట్తా ఇజి వారు విజేరె బాగ నెసినార్. ");
INSERT INTO kfc_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","అక్కాదె ఆఏండ, నీవందిఙ్‌ సాసి వెహ్తి స్తెపానుఙ్‌ ‌సప్తివలె, నానుబా అక్క ఒపుకొటానె వన్నిఙ్‌ సప్తివరి సాల్‌వెఙ్‌ కాప్‌కిజి మహగదె’, ఇజి ప్రబు వెట వెహ్త. ");
INSERT INTO kfc_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","గాని ప్రబు, ‘నీను సొన్‌అ, దూరం మన్ని దేసమ్‌దు బత్కిని యూదురు ఆఇవరిబాన్‌ నాను నిఙి పోక్న’ ఇజి నావెట వెహ్తాన్”. ");
INSERT INTO kfc_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","యా మాటదాక లోకుర్‌ పవులు ‌వెంజి మహార్‌. గాని యాక వెహ్తిఙ్, “నిన్ని వన్నిఙ్ ‌ఇడ్మాట్‌. విన్నిఙ్ ‌సప్తు. వీండ్రు బత్కిదెఙ్‌ ‌ఆఏద్‌”, ‌ఇజి వారు విజేరె డటం గగోలాత్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ఈహె వారు గగోలాజి వరి సాల్‌వెఙ్ కిసి విసీర్‌తారె దూల్లి అసి ఎగ్రిస్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","అయావలె ‘పవులుఙ్‌ బారిగోడః లొఇ తగ్‌అ’ ఇజి రోమ సయ్‌నమ్‌ది పెరి అతికారి ఆడ్ర సిత్తాన్‌. లోకు పవులు ముస్కు ఎందానిఙ్‌ ‌ఈహు కోపం ఆతారె గగోల్ ఆతార్‌ ఇజి నెస్ని వందిఙ్ ‌పవులుఙ్‌ ‌కొర్డదాన్ ‌డెఃయ్‌దెఙ్‌ అయ అతికారి ఆడ్ర సిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","గాని పవులు ‌డెఃయ్దెఙ్ తొహ్తిఙ్ పవులు వన్ని డగ్రు మహి సదాతిపతివెట ఈహు వెన్‌బాతాన్, “రోమదిఙ్ అక్కు మన్నికాన్‌ ఆతి ఒరెన్‌ వన్నిఙ్ తీర్‌పు సిఏండనె కొరెడెఃదాన్‌ డెఃయ్దెఙ్‌ రోమ రూలుఙ్‌ వజ మిఙి అతికారం మనాదా?”. ");
INSERT INTO kfc_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","అయ సతాతిపతి యాక వెహాండ్రె రోమ సయ్‌నమ్‌ది పెరి అతికారిబాన్ ‌సొహాండ్రె ఈహు వెహ్తాన్‌. “నీను ఇనిక కిదెఙ్ ‌సుడ్ఃజిని? వీండ్రు రోమదిఙ్ అక్కు మన్నికాన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","అయావలె అయ పెరి అతికారి పవులుబాన్‌ వాతండ్రె, “నీను రోమదిఙ్ అక్కుమన్నికిదెనా?”, ఇజి వెన్‌బాతాన్. “ఒఒ”, పవులు ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","దన్నిఙ్‌ అయ పెరి అతికారి, “లావు డబ్బు సిత్తానె యా రోమది అక్కు నాను పొందిత”, ఇహిఙ్ పవులు, “నాను ఇహిఙ పుట్తివలెహానె రోమదిఙ్ అక్కు మన్నికాన్” ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","అందెఙె పవులు వెట డటిసి వెహ్తెఙ్‌ ‌వాతికార్ ‌వెటనె వన్నిఙ్ ‌డిఃస్త సితార్. రోమదిఙ్ అక్కుమన్ని వన్నిఙ్ ‌గొలుస్కాణిఙ్‌ ‌తొహ్‌పిస్త మహ ఇజి నెసి అయ రోమ సయ్‌నమ్‌ది పెరి అతికారి తియెలాతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","మహ్స నాండిఙ్, పవులు ముస్కు యూదురు ఇని నేరం మొప్నారొ ఇజి నెస్తెఙ్‌ అయ రోమ పెరి అతికారి ఆస ఆతాన్. అందెఙె పవులు డిఃబిస్తాన్. పెరి పుజేరిఙ్‌ని సంహద్రి సఙమ్‌దిఙ్‌ కూక్‌పిస్తాండ్రె ‘మీటిఙ్‌ కినాట్‌’ ఇజి ‌ఆడ్ర సిత్తాన్‌. వారు కూడ్ఃజి వాతివలె పవులుఙ్‌ వరి ముందాల నిల్‌ప్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","పవులు సంహద్రి సఙమ్‌దివరిఙ్‌ తినాఙ్‌ సుడ్ఃజి ఈహు వెహ్తాన్‌, “తంబెరిఙాండె, గడిఃస్తి సొహి దినమ్‌కు విజు నాను దేవుణు ఎద్రు నా గర్బం గదిస్ఏండ మహ”. ");
INSERT INTO kfc_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","అయావలె విజేరె పుజేరిఙ ముస్కు పెరి పుజేరి ఆతి అననియ పవులు డగ్రు నిల్సిమహివరివెట, “వన్ని వెయ్దు డెఃయ్‌అ”, ఇజి ఆడ్ర సిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","దన్నిఙ్‌ పవులు, “నీను తెలాఙ్‌‌ దూల్లి రాస్తి గోడ్డః నన్నికి. దేవుణు నిఙి డెఃయ్‌నాన్లె. మోసె సిత్తి రూలుఙ్‌ తగితివజ నఙి తీర్‌పు కిదెఙ్ ‌నీను బస్తిమన్ని. గాని మోసె సిత్తి రూలుదిఙ్ తగ్‌ఏండ నఙి డెఃయ్దెఙ్‌ ఆడ్ర ‌సీజినిదా?”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","పవులుడగ్రు నిహికార్, “నీను దేవుణు పెరి పుజేరిదిఙ్‌ దుసలాడిఃజినిదా?”, ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","దన్నిఙ్‌ పవులు, “తంబెరిఙాండె, వాండ్రు విజేరె పుజేరిఙ ముస్కు పెరి పుజేరి ఇజి నాను నెస్‌ఏత. మీ లోకాఙ్‌ ఏలుబడిః కినివరిఙ్‌ దుసలాడిఃజినిక ఆఏద్‌ ‌ఇజి దేవుణు మాటదు రాస్త మనాద్‌ ‌గదె”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","యూద పెద్దెల్‌ఙ పెరి సఙమ్‌లొఇ సెగొండార్ ‌పరిసయ్‌రు, సెగొండార్‌ సదుకయ్‌రు ఇజి పవులు నెస్తాన్. నెస్తాండ్రె వెనుక పవులు డటం వెహ్తాన్‌, “తంబెరిఙాండె, నానుబా పరిసయ్ వాండ్రునె, పరిసయ్‌వన్నిఙ్‌ పుట్తికాన్. దేవుణు సాతివరిఙ్ ‌నిక్నాన్‌ ఇజి నాను నమ్మిజిన. అక్క నాను ఎద్రు సుడ్ఃజి మంజిన. దన్నివందిఙ్ ‌నాముస్కు తప్పు మొప్సి తీర్‌పు కిజినార్”. ");
INSERT INTO kfc_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","పవులు యాక వెహ్తివలె పరిసయురుఙ సదుకయ్‌రుఙ నడిఃమి గొడఃబ పుట్తాద్. గొడఃబ పుట్తాదె వారు రుండి జటుఙ్‌ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(ఎందానిఙ్‌ ఇహిఙ సాతికార్‌ మర్‌జి బత్కిఎర్, దూతార్‌ ‌సిల్లు, దెయమ్‌కు సిలు ఇజి సదుకయ్‌రు వెహ్సినార్. పరిసయ్‌రు ఇహిఙ అక్కెఙ్‌ విజు మన్నె ఇజి వెహ్సినార్). ");
INSERT INTO kfc_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","అయావలె అబ్బె గొప్ప గగోల్‌ ఆతాద్. పరిసయ్‌రులొఇ సెగొండార్ దేవుణు మోసెఙ్‌ సిత్తి రూలుఙ్‌ నెస్పిసినికార్‌ ‌నిఙిత్తారె, “మాపు సుడ్ఃతిఙ్, యా లోకు ముస్కు ఇని తప్పుబా తోర్‌ఎద్. ఒరెన్‌ దూత గాని ఉండ్రి తోర్దెఙ్ అట్ఇకాద్ గాని వన్నివెట వర్గితాద్‌సు, ఇజి గొడఃబెఙ్ ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","వరి లొఇ గొడఃబ లావాత్తిఙ్‌ వారు పవులు కిస్న విసీర్నార్లెసు ఇజి తియెలాతాండ్రె అయ రోమ సయ్‌నమ్‌ది పెరి అతికారి సయ్‌నమ్‌ది వరిఙ్ ‌పోక్తాండ్రె పవులుఙ్‌ వరి నడిఃమిహన్‌ లాగ్జి బారిగోడః లొఇ తత్తెఙ్ ‌ఆడ్ర సిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ఆ పొదొయ్‌ ప్రబు పవులు ‌తోరె ఆతండ్రె, “దయ్‌రం ముస్కు మన్‌అ. నీను యెరూసలేమ్‌దు నావందిఙ్‌ ‌ఎలాగ ‌సాసి వెహ్తిదొ అయావజనె రోమ పట్నమ్‌దుబా సాసి వెహ్‌అ”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","మర్స నాండిఙ్‌ ‌పెందల సెగొండార్ ‌యూదురు కూడిఃతారె, ‘మాటు పవులు ‌సప్ఏండ ఉండెఙ్‌ తిండ్రెఙ్‌ ఆఏద్‌’ ‌ఇజి ఒట్టు కితారె పవులు ‌సప్తెఙ్ ‌ఇజి పూర్తి తెగిస్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","పవులుఙ్‌ సప్తెఙ్‌ ఆలోసనం కిత్తికార్‌ ‌నల్‌పయ్‌ ముస్కు మొగావారు ‌మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","వారు పెరి పుజేరిఙబాన్‌ పెద్దెలుఙబాన్ ‌సొహరె వెహ్తార్‌, “మాపు పవులుఙ్‌ సప్ఏండ ఇనికబా తిన్ఏప్ ఉణ్‌ఎప్, ఇజి గటిఙ ఒట్టు కిత మహప్. ");
INSERT INTO kfc_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","అందెఙె మీరు, సంహద్రి సఙమ్‌దికార్‌ విజేరె కూడ్ఃజి రోమ సయ్‌నమ్‌ది పెరి అతికారి వన్నిఙ్ కబ్రు పోక్‌అ. అక్క ఇనిక ఇహిఙ, పవులు మరి మాబాన్ ‌రపిన్ ఇండ్రు. వన్నివెట మరి వర్గిజి వన్ని వందిఙ్‌ మాపు విజు నెస్తెఙ్‌ ఇజి నాటిస్నాట్. వాండ్రు ఇబ్బె అందిఏండనె మాపు వన్నిఙ్ ‌సప్తెఙ్ తయారాజి మనాప్”. ");
INSERT INTO kfc_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","గాని పవులుఙ్‌ బణిజ ఆతికాన్‌ యాక నెస్తాండ్రె సెల్వ లొస్తాండ్రె బారిగోడః లొఇ సొన్సి పవులుఙ్‌ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","అయావలె పవులు సదాతిపతిర్‌లొఇ ఒరెన్‌ వన్నిఙ్ ‌కూక్తాండ్రె, “యా దఙ్‌డెఃఙ్ ‌రోమ సయ్‌నమ్‌ది పెరి అతికారిబాన్ ‌ఒఅ. పెరి అతికారి వెట విన్నిఙ్ ఉండ్రి మాట వెహ్తెఙ్‌ మనాద్” ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","వెహ్తిఙ్‌ అయ సతాతిపతి అయ దఙ్‌డెఃఙ్‌ ‌పెరి అతికారిబాన్ ‌ఒతాన్. ఒతండ్రె, “జెలిదు మన్ని పవులు నఙి కూక్తాండ్రె యా దఙ్‌డెఃఙ్ ‌మీబాన్ ఒతెఙ్‌ ఇజి ‌వెహ్తాన్‌. యా దఙ్‌డః ‌మీ వెట ఇనికాదొ వెహ్నన్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","అయ పెరి అతికారి అయ దఙ్‍డెఃఙ్ ‌కీదు అస్తాండ్రె ఉండ్రి పడఃకాద్‌ ‌ఒతాన్. “నా వెట వెహ్తెఙ్‌ ఇని మాట మనాద్‌?”, ఇజి వన్నిఙ్ వెన్‌బాతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","వెన్‌బాతిఙ్‌ ‌అయా దఙ్‌డాఃయెన్, “విగెహిఙ్ ‌పవులుఙ్‌ సంహద్రి సఙం నడిఃమి తసి వన్ని వందిఙ్ మరి నెస్తెఙ్‌ ఇజి నాటిసి వన్నివెట మరి వర్గిదెఙ్‌ నీబాన్‌ సెలవ లొస్తెఙ్‌ ఇజి యూదురు ఒపుకొట మనార్. ");
INSERT INTO kfc_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","గాని నీను వరిఙ్ సరి సీమ. ఎందానిఙ్‌ ఇహిఙ నలపయ్ ‌మణిసిరిఙ్ ‌ముస్కు మొగావారు, పవులు ‌సప్ఏండ మాటు ఉండెఙ్‌ తిండ్రెఙ్‌ ఆఏద్‌ ఇజి ఒట్టు కితారె వన్ని వందిఙ్ ‌సరిదు సుడ్ఃజినార్. వారు వన్నిఙ్ ‌సప్తెఙ్ ‌తయారాత మనార్. మీమాటదిఙ్ కాప్‌కిజినార్” ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","యాక వెహాండ్రె అయ పెరి అతికారి, “నీను నఙి యాక వెహ్తి ఇజి ఎయెఙ్‌బా వెహ్మ”, ఇజి గటిఙ ‌వెహ్తాండ్రె అయ దఙ‌డాఃయెనుఙ్ ‌పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","వెనుక అయ పెరి అతికారి సదాతిపతిర్ లొఇ రిఎరిఙ్‌ కూక్తాండ్రె, “యా పొదొయ్‌ ‌తొమ్మిది గంటెఙ కయ్‌సరియ దాక సొండ్రెఙ్ ‌తయార్ ‌ఆదు. రుండి వందెఙ్‌ ‌సయ్నమ్‌దికార్, డబయ్‌మణిసిర్ ‌గుర్రమ్‌దాన్‌ ‌సొని సయ్‌నమ్‌దికార్, రుండి వందెఙ్‌ ‌బల్లెమ్‌కు అస్తికార్‌ ‌సొండ్రెఙ్‌ వలె. ");
INSERT INTO kfc_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","పవులుఙ్‌ ఎకిసి ఒతెఙ్‌ ‌గుర్రమ్‌కు సీదు. వన్నిఙ్ ‌గవర్నరు ఆతి పేలిక్సుబాన్‌ ఇని ప్రమాదం రెఏండ ఒతెఙ్”, ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","అయ పెరి అతికారి ఈహె ఉండ్రి ఉత్రం రాస్తాన్, ");
INSERT INTO kfc_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“క్లవుదియ లూసియ ఆతి నాను గొప్ప పేరు మన్ని పేలిక్సు గవర్నరిఙ్ వందనమ్‌కు వెహ్సిన‍. ");
INSERT INTO kfc_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","విన్నిఙ్ యూదురు అస్తారె సప్తెఙ్‌ సుడ్ఃతిఙ్‌ ‌నాను నా సయ్‌నమ్‌దివరివెట వాతానె విన్నిఙ్ ‌గెల్‌పిస్త. ఎందనిఙ్‌ ‌ఇహిఙ వీండ్రు రోమదిఙ్ అక్కుమన్నికాన్ ‌ఇజి నాను నెస్త. ");
INSERT INTO kfc_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","విని ముస్కు యూదురు ఎందనిఙ్‌ ‌నేరం మొప్సినార్‌ ఇజి నెస్తెఙ్‌ ‌నాను విన్నిఙ్ యూదురి సంహద్రి సఙమి నడిఃమి ఒత. ");
INSERT INTO kfc_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ఒతిఙ్, యూదురి రూలుఙలొఇ మన్ని ఇనికెఙొ వందిఙ్ ‌వారు విన్నిఙ్ నేరం మొప్తార్‌ గాని, సప్తెఙ్‌నొ, జెలిదు పోక్తెఙ్‌నొ ‌తగితి తపుఙ్‌ తోర్‌ఉతె. ");
INSERT INTO kfc_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","విన్నిఙ్ ‌సప్తెఙ్ ఇజి యూదురు కుట్ర కిజినార్‌ ఇజి నాను నెస్తానె ‌వెటనె విన్నిఙ్ ‌నీబాన్ ‌పోక్సిన. విని ముస్కు నేరం మొప్తికార్‌బా నీబాన్‌ వాజి వన్ని ముస్కు మన్ని నేరమ్‌కు విజు వెహ్తెఙ్‌ నాను వరిఙ్ ‌ఆడ్ర ‌సిత్త”. ");
INSERT INTO kfc_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","అయ రోమ సయ్‌నమ్‌ది పెరి అతికారి ఆడ్ర ‌సిత్తిలెకెండ్ ‌సయ్‌నమ్‌దికార్‌ పవులు ‌ఆ పొదొయ్‌నె అంతిపత్రి ఇని పట్నమ్‌దాక కూక్త ఒతార్. ");
INSERT INTO kfc_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","మహ్స నాండిఙ్‌ వారు పవులు ‌గుర్రమ్‌కు అస్తి సయ్‌నమ్‌ది - వరివెట పోక్తారె మహికార్‌ మర్‌జి వాతార్. ");
INSERT INTO kfc_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","వారు కయ్‌సరియదు అందితిఙ్‌ ‌అతికారి పోక్తి ఉత్రం గవర్నరిఙ్‌ సితార్. పవులుఙ్‌బా గవర్నరుబాన్‌ ఒపజెప్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","35","గవర్నరు అయ ఉత్రం సద్‌వితాండ్రె పవులు వెట, “నీను ఎమేణి ప్రాంతమ్‌దికి”, ఇజి వెన్‌బాతాన్. “కిలికియదికాన్”, ఇజి వెహ్తిఙ్, “నీ ముస్కు నేరం మొప్తికార్‌ వానివలె నీ సఙతి సూణ ఇజి వెహ్తాన్‌. పవులు ‌హేరోదు రాజు పెరిఇండ్రొ ఇడ్‌జి కాప్‌ కిజి మండ్రెఙ్ ‌ఆడ్ర సిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","అయ్‌దు రోస్కు సొహిఙ్‌ విజేరె పుజేరిఙ ముస్కు పెరి పుజేరి ఆతి అననియ, వన్నివెట సెగొండార్‌ యూద పెద్దెలుఙు, తెర్తుల ఇని ఒరెన్‌ తగ్గు వర్గినికాన్, డిఃగు మన్ని కయ్‌సరియాదు వాతార్. వాతారె పేలిక్సు గవర్నరుబాన్, పవులు వందిఙ్ మొప్తి నేరమ్‌కు వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","3","పవులుఙ్‌ కూక్పిసి కోర్టుదు నిల్‌ప్తాన్. అయావలె తెర్తుల ఇని తగ్గు వర్గినికాన్‌ పవులు వందిఙ్ ‌ఈహె నేరం మొప్తెఙ్ ‌మొదొల్‌స్తాన్, “పెరి పేరు మన్ని గవర్నరు ఆతి పేలిక్సు, నీను నండొ కాలం ఏలుబడిః కిజినిఙ్‌ ‌మాపు సమదానమ్‌దాన్ మంజి - నాప్. మా జాతివందిఙ్ మీరు బాగ కిత్తిఙ్‌ ‌మఙి నెగ్రెండ బత్కిదెఙ్‌ అవ్‌సరం ఆతికెఙ్‌ విజు మన్నె. మాపు విజెపె మీరు కిత్తి యా నెగ్గి పణిదిఙ్‌ ఒప్పుకొడ్ఃజి నిఙి వందనమ్‌కు వెహ్సినాప్. ");
INSERT INTO kfc_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","గాని నాను నీ పణిదిఙ్‌ ‌అడ్డు కిఏండ, మాపు ఎందానిఙ్‌ ‌మీబాన్‌ వాతాపొ అయ సఙతి వందిఙ్‌ వర్గిన. దయ కిజి వెన్అ. ");
INSERT INTO kfc_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","యా పవులు గొప్ప గొడఃబ కినికాన్. లోకం విజు యూదురి నడిఃమి గొడఃబెఙ్ ‌రేప్నికాన్. వీండ్రు నజరేతుది జటుదిఙ్ ‌నెయ్కి. యాక విజు మాపు నెసినాప్. ");
INSERT INTO kfc_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","7","విండ్రు యెరూసలేమ్‌దు మన్ని దేవుణు గుడిఃదిఙ్ మయ్ల ‌కిదెఙ్‌బా సుడ్ఃతాన్. అందెఙె మాపు విన్నిఙ్ ‌అస్తాప్. గాని రోమ సయ్‌నమ్‌ది పెరి అతికారి లూసియ వాతండ్రె మాబాణిఙ్‌ విన్నిఙ్ లాగితాన్. ");
INSERT INTO kfc_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","నీను విన్నిఙ్ వెన్‌బాఅ. మాపు విన్నివందిఙ్ ‌వెహ్నికెఙ్ విజు నిజమె ఇజి నిఙి నెస్తెఙ్‌ ఆనాద్”. ");
INSERT INTO kfc_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","తెర్తుల వెహ్తి మాటెఙ్‌ విజు నిజం ఇజి బానె వాతిమహి యూదురుబా ఒప్పుకొటార్. ");
INSERT INTO kfc_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","పవులు వర్గిదెఙ్‌ గవర్నరు సయ్‌న కిత్తిఙ్‌ పవులు వర్గిదెఙ్‌ ‌మొదొల్‌స్తాన్, “గవర్నర్‌ ఆతి పేలిక్సు, నీను నండొ పంటెఙ్‌ యా యూదురి లోకాఙ్‌ ‌నెగ్రెండ ఏలుబడిః కిజిమహి. అందెఙె నాను దయ్‌రమ్‌దాన్‌ ‌వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","నాను యెరూసలేమ్‌దు దేవుణు గుడిఃదు పార్దనం కిదెఙ్‌ సొహిఙ్‌ ఏలు పనెండు రోస్కునె ఆతె ఇజి విరిఙ్‌ వెన్‌బాతిఙ నీను నెస్ని. ");
INSERT INTO kfc_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","దేవుణు గుడిః లొఇబా, యూదురి మీటిఙ్‌ ఇండ్రొబా, పట్నమ్‌దుబా నాను ఎయెన్‌ వెటబా లోకురిఙ్‌ నెక్తి పొక్తిక, జటు కిజి రేప్నిక, ఇనికబా యూదురు సుడ్ఃఏతార్. ");
INSERT INTO kfc_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ఏలు నావందిఙ్‌ వీరు వెహ్నికెఙ్‌ నిజం ఇజి రుజుప్‌ ‌కిదెఙ్‌ ‌వీరు అట్‌ఏర్. ");
INSERT INTO kfc_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","గాని నాను ఉండ్రి నిజం మాట వెహ్న. అక్క ఇనిక ఇహిఙ. నిజం ఆఏద్‌ ‌ఇజి వీరు వెహ్సిని బోదవజ నాను నడిఃజిన. ఆహె నడిఃజి దేవుణు మోసెఙ్‌ సిత్తి రూలుఙ్‌ వజ విజు, ప్రవక్తరు రాస్తికెఙ్‌ విజు నాను నమ్మిజి మా అనిగొగొర్‌ పొగ్‌డిఃజి మాడిఃస్తి దేవుణుదిఙ్‌ ‌పార్దనం కిజిన. ");
INSERT INTO kfc_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","వీరు నమ్మినివజ నెగ్గికార్, సెఇకార్‌ విజేరె సాతి వరిబాణిఙ్‌ మర్‌జి నిఙ్‌నార్ ‌ఇజి నానుబా దేవుణుదిఙ్‌ నమ్మిజి ఆసదాన్‌ ఎద్రు సుడ్ఃజిన. ");
INSERT INTO kfc_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","అందెఙె నాను, దేవుణు ఎద్రు‌గాని, లోకుర్ ఎద్రు‌గాని నా గ‍ర్బం గదిస్ఏండ మండ్రెఙ్ సుడ్ఃజిన. ");
INSERT INTO kfc_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","సెగం పంటెఙ్‌ సొహి వెనుక ఏలు నాను నా సొంత జాతిఙ్ సాయం కిదెఙ్, దేవుణు గుడిఃదు పూజ కిదెఙ్‌ యెరూసలేమ్‌దు వాత. ");
INSERT INTO kfc_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","19","దిన్ని వందిఙ్‌ నాను దేవుణు గుడిఃదు సొహిమహిఙ్, సుబ్బరం ఆతి వెనుకానె యూదురు నఙి బాన్‌ సుడ్ఃతార్. అయావలె నావెట మంద లోకుర్‌ ఎయెర్‌ ‌సిల్లెతార్. ఇని గొడఃబ జర్గిఏతాద్. గాని నాను బాన్‌ మహివలె ఆసియ దేసెమ్‌దాన్‌ వాతిమహి సెగొండార్ ‌యూదురు, బాన్‌ మహారె నా ముస్కు గొడఃబ ఆతార్. నా ముస్కు వరిఙ్ ఇని నేరం మహిఙ వారె వాజి నీ వెట వర్గిదెఙ్. ");
INSERT INTO kfc_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","సిలిఙ నాను సంహద్రి సఙమ్‌దు వర్గిజి మహిఙ్‌ ఇని తప్పు వర్గిత ఇజి వీరు వెహిర్. ");
INSERT INTO kfc_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","గాని ఉండ్రి మాట నాను వెహ్త. అక్క ఇనిక ఇహిఙ, సాతి లోకుర్ మర్‌జి బత్కినార్ ‌ఇజి నమ్మినివందిఙ్ ‌మీరు నేండ్రు నఙి తీర్‌పు కిజినిదెర్‌ ‌ఇజి నాను బానె డటం వెహ్త మహ”. ");
INSERT INTO kfc_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","పవులు వెహ్తి బోదవందిఙ్ గవర్నరాతి పేలిక్సు నెగ్రెండ్ర నెస్త మహాన్‌. అందెఙె వాండ్రు, “రోమ సయ్‌నమ్‌ది పెరి అతికారి ఆతి లూసియ వానివలె తీర్‌మానం కిన”, ఇజి వెహ్తండ్రె అయ సద్రు మీటిఙ్‌ ముగిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","వెనుక పవులు ‌జేలిదు ఇడ్‌జి వన్నిఙ్ ‌కాపు ఇడ్‌దెఙ్‌ ‌సదాతిపతిఙ్ ఆడ్ర సిత్తాన్‌. వన్ని లోకుర్‌ వాజి వన్నిఙ్ ‌సుడ్ఃజి వన్నిఙ్‌ సాయం కిదెఙ్‌ అడ్డు కిమాట్‌ ఇజి ఆడ్ర ‌సిత్తాండ్రె వన్నిఙ్ ‌కండెక్ సరి సిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","సెగం రోస్కు సొహిఙ్‌ పేలిక్సు వన్ని ఆల్సి ఆతి ద్రుసిలవెట వాతాన్. అది యూదురి అయ్‌లి కొడొః. పేలిక్సు పవులుఙ్‌ కూక్‌పిస్తాన్. యేసు క్రీస్తు ముస్కు మన్ని నమకంవందిఙ్ పవులు వెహ్తికెఙ్‌ ‌వెంజి మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","గాని పవులు సరియాతి పణి కిని వందిఙ్, మన్సుదిఙ్‌ అణసె ఆజి ఇడ్నివందిఙ్, ‌దేవుణు, లోకుర్‌ ముస్కు కిని తీర్‌పువందిఙ్‌ గటిఙ వర్గితిఙ్ ‌పేలిక్సు తియెలాతాండ్రె, “ఆనె, ఏలు సొన్‌అ. మరి ఒర్సు టయం మహివలె కూక్‌పిస్న”, ఇజి వెహ్తండ్రె పోక్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","పవులు నఙి డబ్బు సీనాన్సు ఇజిబా పేలిక్సు ఒడిఃఒడిఃబితాన్. అందెఙె పవులు ‌మాట మాటదిఙ్‌ కూక్‌పిస్తాండ్రె వన్నివెట వర్గితాన్. ");
INSERT INTO kfc_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","రుండి పంటెఙ్‌ సొహిఙ్, పేలిక్సు వెనుక పోర్కియు పెస్తు ఇనికాన్‌ గవర్నరు ఆతాన్. పేలిక్సు యూదురిఙ్‌ సర్ద కిబిస్తెఙ్‌ ‌పవులుఙ్‌ ‌జెలిదునె ఇట్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","పోర్కియు పెస్తు అయ ప్రాంతమ్‌దిఙ్ ‌గవర్నరు ఆజి మూండ్రి రోస్కు సొహిఙ్‌ వాండ్రు కయ్‌సరియాదాన్‌ ఎక్సి యెరూసలేమ్‌దు సొహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","బానె పెరి పుజేరిఙు యూదురి పెద్దెలుఙు పవులు ముస్కు మహి తప్పుఙవందిఙ్‌ గవర్నరుఙ్ ‌వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","“దయ కిజి పవులు ‌యెరూసలేమ్‌దు పోక్‌అ”, ఇజి వారు గవర్నరుబాన్‌ నండొ సుట్కు బతిమాలితార్. ఎందానిఙ్‌ ఇహిఙ పవులుఙ్‌ సర్దు సప్నాప్ ‌ఇజి వారు కుట్ర కిజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","గాని గవర్నరు, “పవులు ‌కయ్‌సరియాదు కాప్‌ ఇట్తా మనాద్. నాను వెటనె బానె సొన్సిన. ");
INSERT INTO kfc_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","అందెఙె మీలొఇ మన్ని పెరిలోకుర్ ‌నావెట బానె సొండ్రెఙ్. పవులు ముస్కు ఇని తప్పుబా మహిఙ వీరు కోర్టుదు నేరమ్‌కు తోరిస్తెఙ్‌ ఆనాద్” ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","గవర్నరు వరివెట ఎనిమిదినొ పది రోస్కునొ మహి వెనుక, డిఃగు కయ్‌సరియాదు సొహాన్‌. మహ్స నాండిఙ్‌ కోర్టుదు సొహాండ్రె తీర్‌పు కిదెఙ్ ఇజి, తీర్‌పు కినిబాన్‌ బస్తాన్. ‘పవులు ‌కోర్టుదు తగాట్’ ఇజి ఆడ్ర సిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","పవులు వాతిఙ్‌ యెరూసలేమ్‌దాన్‌ డిఃగు వాతి యూదురు వన్ని సుటులం నిహరె వన్ని ముస్కు నండొ రకమ్‌ది బల్‌మి ఆతి తప్పుఙ్ ‌మొప్తార్ గాని అక్కెఙ్‌ ‌నిజం ఇజి రుజుప్‌ ‌కిదెఙ్‌ ‌వారు అట్‌ఎతార్. ");
INSERT INTO kfc_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","పవులు, “నాను యూదురు రూలుఙ్‌ వందిఙ్ గాని, యెరూసలేమ్‌దు మన్ని దేవుణు - గుడిఃవందిఙ్ గాని, రోమ దేసెమ్‌దిఙ్ ఏలుబడిః కిని కయ్‌సరువందిఙ్ గాని ఇని తప్పుబా కిఏత”, ఇజి వన్ని వందిఙ్ ‌వాండ్రె వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","నాను నెగ్గికాన్ ఇజి యూదురు ఒడిఃబిదెఙ్‌ ఇజి గవర్నరు సుడ్ఃతాన్. అందెఙె వాండ్రు పవులు వెట వెన్‌బాతాన్, “యెరూసలేమ్‌దు సొన్సి బానె నీ వందిఙ్ ‌వీరు వెహ్నికెఙ్‌ నిజమ్‌నొ అబద్దమ్‌నొ ఇజి నాను తీర్‌పు కిదెఙ్‌ నీను ఒప్పుకొడ్ఃజినిదా?”. ");
INSERT INTO kfc_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","దన్నిఙ్‌ పవులు, “రోమ రాజు ఆతి కయ్‌సరుది కోర్టుదు నిల్సిన. యా కోర్టుదునె నఙి తీర్‌పు కిదెఙ్. యూదురిఙ్‌ ఇని తప్పుబా నాను కిఏత. అక్క నీను నెగ్రెండ నెస్నిగదె. ");
INSERT INTO kfc_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","నాను ఇని రూలుదిఙ్‌బా తప్తిఙ, సావుదిఙ్‌ ‌తగితి పణి కిత ఇహిఙ, సిక్సదాన్‌ తప్రె ఆదెఙ్‌ ‌నాను సుడ్ఃఏ. గాని నా ముస్కు వీరు వెహ్నికెఙ్ ‌నిజం ఆఉ ఇహిఙ నఙి వరిఙ్‌ ఒపజెప్తెఙ్ ‌ఎయెరిఙ్‌బా అక్కు సిల్లెద్‍. నాను రోమ పెరి రాజు ఆతి కయ్‌సరుబాన్‌ సొండ్రెఙ్ ‌ఆజిన”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","అయావలె గవర్నరు వన్నివెటమహి లోకుర్‌ వెట వర్గితాండ్రె పవులుఙ్, “నీను కయ్‌సరుబాన్‌ సొన్సి వెహ్తెఙ్‌ ఇజి వెహ్తి. అందెఙె కయ్‌సరుబానె సొన్అ”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","సెగం రోస్కు సొహి వెనుక రాజు ఆతి అగ్రిప వన్ని తఙిసి ఆతి బెర్నీకయువెట కొత్త్త గవర్నరు ఆతి పోర్కియు పెస్తుఙ్‌ మాడిఃస్తెఙ్‌ ‌కయ్‌సరియాదు వాతార్‌ ");
INSERT INTO kfc_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","వారు పెస్తువెట నండొ రోస్కు మహార్‌. మహిఙ్‌ పెస్తు పవులు వందిఙ్ రాజు వెట వర్గితాన్, “గవర్నరు ఆతి పేలిక్సు పవులు ఇని ఒరెన్‌ వన్నిఙ్‌ జెలిదు ఇడిఃస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","నాను యెరూసలేమ్‌దు సొహివలె, యూదురి పెరి పుజేరిఙు, పెద్దెలుఙు విని ముస్కు నేరమ్‌కు మొప్తారె ‌సిక్ససిఅ ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","దన్నిఙ్ ‌నాను వరివెట వెహ్త, ‘రోమ అలవాటు ఇహిఙ, నిందెఙ్ ‌మొప్నికార్‌ ఎయెన్‌ ముస్కు తప్పు మొప్నారొ, వాండ్రు వాజి వరి నడిఃమి వన్ని వందిఙ్‌ వర్గిదెఙ్‌ ‌అవకాసం సిఏండ ముందాల్నె తీర్‌పు కిదెఙ్‌ ఆఎద్‌’ ఇజి. ");
INSERT INTO kfc_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","అందెఙె వారు నావెట ఇబ్బె వాతివలె నాను ఆల్‌సెం ఆఏండ మర్సనాండిఙ్‌నె సద్రు కూడ్ఃప్తానె పవులు ‌నాముందాల తపిస్త. ");
INSERT INTO kfc_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","నేరమ్‌కు ‌మోప్తికార్ ‌నిహివలె నాను ఒడిఃబిత్తిలెకెండ్ వారు నేరమ్‌కు లొఇ ఉండ్రి నేరంబా వన్ని ముస్కు మొప్‌ఏతార్. ");
INSERT INTO kfc_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ఇహిఙ, వరి మతంవందిఙ్, సాతి సొహి యేసు ఇని ఒరెన్‌వందిఙ్‌ పవులు వెట గొడఃబ ఆతికాదె తోరితాద్. పవులు ఇహిఙ యేసు బత్కిజినాన్ ‌ఇజి వెహ్సినాన్. ");
INSERT INTO kfc_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","యా సఙతివందిఙ్ మరి ఇనిక కిదెఙ్ ‌ఇజి నెస్‌ఏండాతానె నాను పవులు వెట, ‘నీను యెరూసలేమ్‌దు సొన్సి బానె దిన్ని వందిఙ్ ‌తీర్‌పు తీరిసె ఆదెఙ్‌ మన్సు ఆజినిదా?’, ఇజి వెన్‌బాత. ");
INSERT INTO kfc_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","గాని పవులు, ‘రోమ రాజు ఆతి కయ్‌సరు నఙి తీర్‌పు కిదెఙ్’ ‌ఇజి వెహ్తిఙ్‌ నాను వన్నిఙ్‌ కయ్‌సరుబాన్‌ ‌పోక్నేండ ఇబ్బె జెలిదునె ఇడ్‌దెఙ్‌ ‌ఆడ్ర ‌సిత్త”. ");
INSERT INTO kfc_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","అగ్రిప రాజు పెస్తువెట, “అయ పవులు వెహ్నికెఙ్‌ వెండ్రెఙ్‌ నాను ఇస్టమాజిన” ఇహిఙ్, “విగెహిఙ్ ‌నీను వెండ్రెఙ్‌ ఆనాద్”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","మహ్స నాండిఙ్‌ అగ్రిప రాజుని, వన్ని తఙిసి ఆతి బెర్నికయ రాజు వర్గిని అతికారం ఇండ్రొ వాతార్. వారు ఎసొ గొప్ప పెరికార్ ఇజి తోరిసి కర్సు ఆతి రాజురి సొక్కెఙ్ ఇట్‌కిజి, బఙారం, వెండి ఇడ్కిజి రోమ సయ్‌నమ్‌ది పెరి అతికారి లోకుర్‌ వెట, పట్నమ్‌ది ముకెలమతివరివెట వాతార్. వాతారె పవులుఙ్‌ తగ్‌అ ఇజి పెస్తు ఆడ్ర ‌సిత్తిఙ్ జమానుఙ్‌ సొహరె ‌పవులుఙ్‌ వరి నడిఃమి తతార్. ");
INSERT INTO kfc_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","అయావలె పెస్తు వెహ్తాన్‌, “అగ్రిప రాజు, మాబాన్‌ కూడ్ఃజి వాతిమహి విజు లోకాండె, మీరు యా పవులు ‌సుడ్ఃజినిదెర్. యెరూసలేమ్‌దు మరి ఇబ్బెబా యూదురు విజేరె వీండ్రు బత్‌కినిక ఆఏద్‌ ఇజి గగోలాత్తారె నావెట పిరాడ్‌ కిత్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","గాని సావుదిఙ్‌ ‌తగితిక ఇనికబా వీండ్రు కిఎతాన్‌ ఇజి నాను నెస్తానె రోమ రాజుబాన్‌ సొండ్రెఙ్ ‌వీండ్రు వెహ్తిఙ్‌ ‌రోమ రాజుబాన్‌ సొన్సి తీర్‌పు ఆపిద్ ఇజి‌ నాను తీర్‌మానం కిత. ");
INSERT INTO kfc_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","గాని నాను రోమ రాజుఙ్‌ ‌విన్నివందిఙ్‌ ఇనిక రాస్తి పోక్తెఙ్ ఇజి తోర్‌ఏత. తీర్‌పు కిదెఙ్‌ తగితిక ఇనికబా విని ముస్కు సిల్లెద్‌. అందెఙె మీరు విజెరి నడిఃమిని, అగ్రిప రాజు, నీ నడిఃమిబా విన్నిఙ్ ‌తత్త మన్న. మాపు విన్నివెట వర్గితివెనుక ఇనికబా రాస్తెఙ్ ‌నెస్నాసు. ");
INSERT INTO kfc_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","తొహ్సి అసి తీర్‌పు కిదెఙ్ పోక్తివన్నిముస్కు ఇని నింద మోప్త మనాద్‌ ఇజి వెహ్‌ఏండ వన్నిఙ్‌ కయ్‌సరుబాన్‌ పోక్తెఙ్‌ ఆఏద్‌ ఇజి నాను నెస్నా”. ");
INSERT INTO kfc_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","అగ్రిప రాజు పవులుఙ్‌ సుడ్ఃజి, “ఏలు నీ వందిఙ్ ‌వర్గిదెఙ్ ‌నాను సరి సీజిన”, ఇజి వెహ్తాన్‌. అయావలె పవులు కియు సాప్తాండ్రె వన్ని వందిఙ్ వాండ్రె ముదాయి ఇజి మొదొల్‌స్తాన్, ");
INSERT INTO kfc_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“అగ్రిప రాజు, యూదురు నా ముస్కు మొప్తి నేరమ్‌కు నిజం ఆఏద్‌ ‌ఇజి నావందిఙ్‌ నీ ఎద్రు వర్గిదెఙ్‌ నాను గొప్ప సర్ద ఆజిన. ");
INSERT INTO kfc_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ఎందానిఙ్‌ ఇహిఙ యూదురి అలవాటుఙ్ విజు వరి గొడఃబెఙ్ విజు నీను బాగ నెసినికి. అందెఙె దయ కిజి నా మాట ఓరిసి వెండ్రు. ");
INSERT INTO kfc_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","ఇజిరివలెహాన్ అసి నాను ఎలాగ ‌మహ ఇజి, నా సొంత లోకుర్ ‌నడిఃమి, నా సొంత దేసమ్‌దు, యెరూసలేమ్‌దుబా, ఎలాగ ‌బత్కిజి మహ ఇజి, యూదురు విజేరె బాగ నెసినార్. ");
INSERT INTO kfc_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","మా మతమ్‌దు పరిసయ్‌రి జటుదికార్‌ ఉండ్రి రూలుబా తప్‌ఏండ నీతి నిజాతిదాన్ నడిఃనార్. వరి లొఇ ఒరెన్‌వజ నాను బత్కిజి మహ ఇజి వారు నావందిఙ్‌ సాసి వెహ్తెఙ్‌ ‌ఇహిఙ, సాసి వెహ్తెఙ్‌ ‌అట్‌నార్. ఎందనిఙ్‌ ఇహిఙ, వారు మొదొహన్‌ అసి నఙి నెసినార్. ");
INSERT INTO kfc_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","ఏలు ఇహిఙ, దేవుణు మా అనిగొగొర్‌ వెట, సీనా ఇజి కిత్తి ఒట్టుదిఙ్ ‌ఎద్రుసుడ్ఃజి మహిదన్నివందిఙ్‌ నఙి తీర్‌పు కిజినార్. ");
INSERT INTO kfc_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","మా పన్నెండు తెగ్గదికార్ ‌యా ఒట్టువందిఙె ఎద్రు సుడ్ఃజి దేవుణుదిఙ్‌ ‌రెయు పొగల్ డిఃస్‌ఏండ పార్దనం కిజి మంజినార్. ఓ రాజు, నానుబా ఆసదాన్‌ ఎద్రు సుడ్ఃజి మంజినిదన్నివందిఙె యూదురు నా ముస్కు నేరం మొప్సినార్. ");
INSERT INTO kfc_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","సాతివరిఙ్ ‌దేవుణు నిక్నాన్ ‌ఇజి నమ్మిదెఙ్‌ ‌మాపు అట్‌ఎప్‌ ఇజి మీరు ఎందనిఙ్‌ వెహ్సినిదెర్‌? ");
INSERT INTO kfc_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","నజరేతుదికాన్‌ ‌యేసువందిఙ్‌ వెహ్తిమని విజు దన్నిఙ్‌ నెక్సిపొక్తెఙ్ ‌నాను‌ అట్ని పణి విజు కిదెఙ్‌వలె ఇజి నానుబా ముందాల ఒడిఃబిజి మహ. ");
INSERT INTO kfc_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","అయావజనె నాను యెరూసలేమ్‌దు కిత. పెరి పుజేరిఙ్‌ నఙి అతికారం సిత్తిఙ్ ‌నాను దేవుణుదిఙ్‌ కేట ఆతి‌ నండొండారిఙ్‌ జెలిదు ఇట్తా. అక్కాదె ఆఏండ, వరిఙ్‌ సప్తెఙ్‌ తీర్‌మానం ఆతిఙ్‌ ‘నాను‌బా ఒప్పుకొడ్ఃజిన’, ఇజి వెహ్త. ");
INSERT INTO kfc_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","నాను నండొ సుట్కు యూదురి మీటిఙ్‌ ఇల్కాఙ్‌ ఇల్కాఙ్‌ ‌సొన్సి నమ్మితి వరిఙ్ ‌గొప్ప మాలెఙ్ కిత. యేసు ముస్కు నమకం ఇడ్‌ఏప్ ‌ఇజి వారు వెహ్నిదాక‌ నాను బలవంతం కిత. అక్కాదె ఆఏండ వరి ముస్కు ఒదె కోపం ఆతానె, ఆఇ పట్నమ్‌కాఙ్‌బా సొహనె బాన్‌బా మాలెఙ్ కిత”. ");
INSERT INTO kfc_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“ఆహె నాను ఒర్సు, పెరి పుజేరిఙు సిత్తి అతికారమ్‌దాన్‌ ఆడ్రదాన్‌ దమస్కు పట్నమ్‌దు సొన్సి మహ. ");
INSERT INTO kfc_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ఓ రాజు, మదెనెం ఆతివలె సర్దు సొన్సి మహివలె, ఆగాసమ్‌దాన్ ‌వాతి పెరి జాయ్‌ సుడ్ఃత. అయ జాయ్‌ ‌పొద్దు జాయ్‌ ఇంక పెరి జాయ్. అక్క నఙి సుటులం, నావెట మహివరి సుటులం డెఃయ్‌తాద్. ");
INSERT INTO kfc_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","మాపు విజెపె బూమిదు అర్తాప్. అయావలె, ‘సవులు, సవులు, నీను నఙి ఎందానిఙ్‌ మాలెఙ్ కిజిని? ముల్లు డుడ్డుదాన్ ‌గుతివలె మర్‌జి వెనుక గుసె ఆతిఙ నండొ కస్టం తపిస్ని’, ఇజి అరామియ బాసాదు వెహ్తి మాట నాను వెహ. ");
INSERT INTO kfc_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","‘నీను ఎయి, ప్రబు’, ఇజి నాను వెన్‌బాతిఙ్, ‘నీను మాలెఙ్ కిజిని యేసు నానె’ ఇజి ప్రబు నావెట వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","‘ఏలు నిఙ్‌జి నిల్‌అ. నాను ఎందనిఙ్‌ నిఙి తోరె ఆత ఇహిఙ, నావందిఙ్‌ ‌పణి కిదెఙ్, నావందిఙ్‌ నేండ్రు సుడ్ఃతికెఙ్‌ విజెరిఙ్‌ ‌వెహ్సి, వాని కాలమ్‌దు నాను నిఙి తోరిస్నికెఙ్‌ విజేరిఙ్‌‌ వెహ్సి నఙి ఉండ్రి సాసివజ మండ్రెఙ్‌ నిఙి నాను ఏర్‌పాటు కిజిన. ");
INSERT INTO kfc_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","ఇస్రాయేలు లోకాణిఙ్‌ నిఙి నాను గెల్‌పిస్న. యూదురు ఆఇ లోకాణిఙ్‌ గెల్‌పిస్న. యూదురు ఆఇవరినడిఃమి నాను నిఙి పోక్న. ");
INSERT INTO kfc_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ఎందానిఙ్‌ నిఙి పోక్సిన ఇహిఙ, వారు సీకటిదాన్‌ జాయ్‌దు వాజి వరి కణెకెఙ్‌ తోరె ఆదెఙ్. వరిఙ్‌ సయ్‌తాన్‌ సత్తుహాన్‌ ‌దేవుణు దరోట్‌ ‌మహ్తెఙ్. నా ముస్కు నమకం ఇడ్‌జి, వరి పాపమ్‌కు నొరె ఆదెఙ్. నావందిఙ్‌ కేట ఆతి వరివెట కూడ్ఃజి మండ్రెఙ్. దిన్నివందిఙె నిఙి వరి నడిఃమి పోక్సిన’ ఇజి ప్రబు నావెట వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","అందెఙె ఓ అగ్రిప రాజు, నాను ఆగాసమ్‌దాన్ ‌వాతి అయ మాటెఙ లొఙిత్త. ");
INSERT INTO kfc_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","లొఙిత్తానె తొలిత దమస్కు పట్నమ్‌దు, వెనుక యెరూసలేం పట్నమ్‌దు, మరి యూదయ ప్రాంతం విజు, యూదురు ఆఇ వరిఙ్‌బా నెస్పిస్త. ఇనిక నెస్పిస్త ఇహిఙ, విజేరె, పాపమ్‌కు డిఃసి దేవుణు దరోట్‌ మర్దు ఇజి. పాపమ్‌కు డిఃస్తిసిత్తిదన్నిఙ్ ‌తగితిలెకెండ్ నెగ్గి పణిఙ్ ‌కిదు ఇజి. ");
INSERT INTO kfc_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","నాను ఈహె నెస్‌పిస్తి దన్నివందిఙె యూదురు నఙి యెరూసలేమ్‌దు మన్ని దేవుణు గుడిఃదు సుడ్ఃతారె నఙి అస్తారె సప్తెఙ్‌ సుడ్ఃతార్. ");
INSERT INTO kfc_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","గాని గడఃస్తి సొహి కాలం విజు దేవుణు నఙి తోడుః మహాన్‌. అందెఙె నాను ఏలు ఇబ్బె నిల్సి తక్కువరివెట, పెరివరివెట నిజం వెహ్సిన. వాని కాలమ్‌దు ఇనికెఙ్‌ ‌జర్గినెలె ఇజి ప్రవక్తరుని, మోసె వెహ్తికెఙె నానుబా వెహ్సిన. ");
INSERT INTO kfc_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","అక్కెఙ్‌ ‌ఇనికెఙ్ ‌ఇహిఙ, క్రీస్తు నండొ మాలెఙ్ ఆజి సాతాన్. సాతి వరిబాణిఙ్ తొలిత నిఙ్‌నాన్. నిఙ్‌జి, యూదురిఙ్, యూదురుఆఇవరిఙ్‌ దేవుణు - దరోట్‌ సొండ్రెఙ్‌ జాయ్‌ తోరిస్నాన్”. ");
INSERT INTO kfc_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","పవులు ఈహె, వన్ని వందిఙ్ ‌వర్గిజి మహిఙ్‌ ‌పెస్తు, “పవులు, నీను వెరి వాండ్రు. నండొ సదు కిత్తిఙ్‌ అక్క నిఙి వెరి కిబిసినాద్”, ఇజి డటం వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","దన్నిఙ్ పవులు, “గొప్ప పెరికాన్‌ ఆతి పెస్తు, నాను వెరి వాండ్రు ఆఏ. నాను నెగ్గిబుద్దిదానె నిజం వెహ్సిన”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","“రాజు యా సఙతిఙ వందిఙ్‌ నెసినాన్. అందెఙె వన్నివెట దిన్ని వందిఙ్ ‌నాను అడ్డు సిల్లెండ వర్గిజిన. దిన్ని వందిఙ్‌ ఇనికబా వన్నిఙ్‌ డాఙ్‌జి మనిక సిల్లెద్‌. ఎందనిఙ్‌ ‌ఇహిఙ, జర్గితికెఙ్‌ విజు ఉండ్రి మూల పడఃకాద్‌ జర్గిఏతాద్. ");
INSERT INTO kfc_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ఓ రాజు, ప్రవక్తరిమాటెఙ్ ‌నీను నమ్మిజిని ఇజి నాను నెస్నా”. ");
INSERT INTO kfc_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","దన్నిఙ్‌ రాజు, “నిస్సొ సులువుదాన్‌ నఙి క్రీస్తు లోకు కిదెఙ్ ఇజి ‌నీను నఙి ఒపిసినిదా?”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","“సులువుదానొ ఆలస్యమ్‌దానొ నీను ఒరిదె ఆఏ, నేండ్రు నఙి వెంజినికార్ విజేరె నా వజ ఆదెఙ్‌ ఇజి ‌నాను దేవుణుదిఙ్‌ పార్దనం కిజిన. గాని నా వజ గొల్‌స్కాణిఙ్ ‌తొహె ఆదెఙ్‌ ‌పార్దనం కిఏ”, ఇజి పవులు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","అయావలె రాజు, గవర్నరు, బెర్నిక, వరివెట బస్తి మహికార్‌ విజేరె ‌నిఙిత్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","వారు వెల్లి వాతారె, “వీండ్రు సావుదిఙ్‌ గాని, తొహె ఆదెఙ్‌ గాని తగితి పణి ఇనికబా కిఏతాన్”, ఇజి ఒరెన్‌ వెట ఒరెన్ వర్గితాన్. ");
INSERT INTO kfc_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","“వీండ్రు ‘కయ్‌సరు రాజుబాన్‌ సొన’, ఇజి‌ వెహ్‌ఏండ మహాన్‌ ఇహిఙ విన్నిఙ్ డిఃస్తిసిత్తిక మరి”, ఇజి అగ్రిప రాజు పెస్తుఙ్ వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","మాపు ఓడః ఎక్సి ఇటలి దేసెం సొండ్రెఙ్‌ ఇజి ఆడ్ర ‌వాతిఙ్, పవులుఙ్, మరి జెలిదు మహి సెగొండారిఙ్‌ యూలి ఇని సదాతిపతిఙ్ ‌ఒపజెప్తార్. వాండ్రు రోమ సయ్‌నమ్‌లొఇ ఉండ్రి గుంపు ఆతి అవ్‌గుస్తు ఇని గుంపుదికాన్. ");
INSERT INTO kfc_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","మాపు అద్రమత్తియదాన్‌ వాతి ఉండ్రి ఓడః ఎక్తాపె పయ్‌నం ఆతాప్. యా ఓడః ఆసియ ప్రాంతమ్‌దు సమ్‌దరం డగ్రు మహి పట్నమ్‌కాఙ్‌ ‌సొనిక. దెసలొనిక పట్నమ్‌దాన్‌ ఒరెన్‌ ‌మసిదోని దేసెమ్‌దికాన్‌ ‌అరిస్తర్‌కు ఇనికాన్‌ ‌మావెట మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","మహ్స నాండిఙ్‌ ‌సీదోను ఇనిబాన్‌ వాతాప్. సతాతిపతి ఆతి యూలి పవులు ముస్కు దయ తోరిస్తాండ్రె పవులు వన్ని కూలబాబుర్‌బాన్ ‌సొన్సి వారు వన్నిఙ్ ‌నెగ్రెండ సుడ్ఃదెఙ్‌ సెల్వ సిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","వెనుక బాణిఙ్‌ సోతాపె కుప్ర ఇని ద్వీపు ఓరమ్‌దాన్ ‌గాలి తక్కు మహి బాడ్డిదు పయ్‌నం ఆతాప్. ఎందానిఙ్‌ ఇహిఙ ‌ద్వీపుదాన్ ‌గొప్ప గాలి సమ్‌దరం దరోట్‌ డెఃయ్‌జి మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","వెనుక మాపు కిలికియ, పంపులియ ఇని ప్రాంతమ్‌కాఙ్ డగ్రు మహి సమ్‌దరం డాట్తాపె లుకియాదు మన్ని మూర ఇని పట్నమ్‌దు వాతాప్‌. ");
INSERT INTO kfc_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","బానె అలెక్సంత్రియదాన్‌ వాతి ఉండ్రి ఓడః ఇటలి పట్నం సొండ్రెఙ్‌ తయారాత మనాద్‌ ‌ఇజి రోమ సతాతిపతి సుడ్ఃతాన్. సుడ్ఃతండ్రె మఙి అయ ఓడఃదు ఎకిస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","మాపు నండొ రోస్కు మెలేక పయ్‌నం కిత్తాపె గాలివందిఙ్ ‌మాలెఙ్ ఆతాపె క్నీదు ఇని ద్వీపుదిఙ్ ‌ఎద్రు వాతాప్. గాలి మఙి ఎద్రు డెయ్‌తిఙ్‌ ‌అయా సరి మరి సొండ్రెఙ్ ‌అట్‌ఎతాప్. అందెఙె మాపు గాలి తక్కు డెఃయ్తిమహి బాడ్డిదాన్ సొహపె సల్మోను ఇని బాడ్డి డాట్సి క్రేతు ద్వీపు ఓరదాన్ ‌పయ్‌నం కితాప్. ");
INSERT INTO kfc_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","గాలి డెయ్‌తిఙ్‌ మాలెఙ్ ఆజి, ఓరదాన్ ‌పయ్‌నం కిత్తాపె నెగ్గిబాడ్డి ఇని కూక్ని జాగదు వాతాప్. దన్ని డగ్రు లుసెయ పట్నం మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","పయ్‌నం కిజినిఙ్‌ నండొ రోస్కు ఆతె. యూదురి పండొయ్‌ ఆతి ఉపాసి రోజుబా గడఃస్త సొహాద్. సమ్‌దరమ్‌దు ఓడఃదు సొండ్రెఙ్ ‌ప్రమాదమాని కాలం ఆత మహాద్‌. అందెఙె పవులు వరిఙ్ ‌బుద్ది వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“బాబురాండె, మాటు ఏలు సొన్సి మహిఙ ఓడఃదిఙ్‌ని ఇబ్బె మన్ని సామానమ్‌కాఙ్, ప్ప నస్టమ్‌కు, మరి మా పాణమ్‌కాఙ్‌బా నస్టమ్‌కు వానాద్, ఇజి నాను నెస్నా”. ");
INSERT INTO kfc_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","గాని అయ రోమ సతాతిపతి పవులు వెహ్తి మాట అస్‌ఎండ, అయ ఓడః నడిఃపిసినివన్ని మాటెఙ్‌ని అయ ఓడః ఎజుమాని మాటెఙ్‌ అస్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","పిన్ని కాలమ్‌దు మండ్రెఙ్ ‌అయా బాడ్డి నెగ్గికాద్ ‌ఆఏద్‌ ఇహిఙ్ ‌బాణిఙ్ ‌డిఃసి సోతెఙ్ ‌నండొండార్ ‌వెహ్తార్‌. క్రేతదు మన్ని పీనిక్సు ఇనిబాన్‌ అందిజి బానె పిన్ని కాలం గడఃప్నాట్‌ ఇజి వారు విజేరె ఒడిఃబితార్. యా పీనిక్సు పట్నం దసిణ పడఃమర, ఉస్సన్‌ పడఃమర దరోట్‌ ‌మొకొం మహ్త మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","దసిణ దరోటాణ్ ఉండ్రి ఇజిరి గాలి డెయ్‌తిఙ్‌ వారు సొండ్రెఙ్ ‌ఒడ్ఃబిత్తిలెకెండ్ ‌సొనాట్‌ ఇజి ఒడిఃబిత్తారె, ఓడఃది లంగరు లాగితారె సోత్తార్. క్రేతు ఓర దానె సొన్సి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","గాని సణెం వెనుక ఉస్సన్‌ తూర్‌పు దరొటాన్‌ ఊరకులొన్‌ ఇని పెరి గాలి ద్వీపుదాన్‌ గొప్పఙ్‌ ‌డెఃయ్తాద్. ");
INSERT INTO kfc_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","పెరి గాలి ఓడఃదిఙ్ డెయ్‌తిఙ్‌ గాలి ఎద్రు సొండ్రెఙ్ ‌అట్‌ఎండాతాద్. అందెఙె మాపు గాలి ఎద్రు సొండ్రెఙ్ అట్‌ఎండాతానె గాలి డెఃయ్‌తి మహి దరోట్నె ఓడః మహ్తాపె సొహప్‍. ");
INSERT INTO kfc_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","వెనుక కంద ఇని ఉండ్రి ఇజిరి ద్వీపు ఓరదాన్ ‌సొహివలె అయ గాలి మా ముస్కు డెఃయ్ఏండ అయ ద్వీపు మఙి ముస్తాద్. నండొ కస్టబాడిఃతాపె ఇజిరి ఓడఃదిఙ్ ముస్కు లాగితాప్. ");
INSERT INTO kfc_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ముస్కు లా‍గితాపె నెగ్రెండ తొహ్త ఇడ్తాప్. వెనుక పెరి ఓడఃదిఙ్ పెరి నాసుదాన్ ‌సుటులం గటిఙ తొహ్తార్. మరి సుర్తిసు ఇని ఇస్క మెటు ముస్కు ఓడః డెఃయ్‌నాద్‌సు ఇజి తియెలాతారె ఓడః మెలేక సొనీద్ ‌ఇజి ఓడఃది సాప డిఃప్తారె గాలి డెఃయ్‌నిదరోట్‌ సొనీద్ ‌ఇజి డిఃస్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","అయ ముసూర్‌ డిఃస్‌ఏండ డెఃయ్‌జి మహిఙ్‌ మహ్స నాండిఙ్‌ ‌వారు ఓడఃదు మహి బరుఙ్ సమ్‌దరమ్‌దు విసీర్దెఙ్ ‌మొదొల్‌స్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","దన్ని మహ్స నాండిఙ్‌ వారు ఓడః నడపిసిని సెగం సామనమ్‌కు వరి సొంత కికాణిఙ్‌ సమ్‌దరమ్‌దు విసీర్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","నండొ రోస్కు పొద్దు గాని సుక్కెఙ్ గాని తోర్‌ఏండ మహె. గాలి గొప్పఙ డెఃయ్‌జి మహాద్‌. మా పాణమ్‌దిఙ్‌ ఎలాగ ‌గెల్‌పిస్తెఙ్, మాపు సానాప్లెసు‌ ఇజి తియెలాతాప్. ");
INSERT INTO kfc_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","వారు నండొ రోస్కు బోజనం కిఏండ మహిఙ్‌ పవులు వరి నడిఃమి నిహండ్రె వెహ్తాన్‌, “బాబురాండె, మీరు నామాట వెంజిమంజినిక ఇహిఙ నెగ్రెండ మహాద్‌ మరి. క్రేతుదాన్‌ సో‌ఏండ మహిదెర్‌ మరి. సోఏండ మంజినిక ‌ఇహిఙ, యా నస్టమ్‌కు కస్టమ్‌కు జర్గిఏండాతాద్‌ మరి. ");
INSERT INTO kfc_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","ఏలు ఇహిఙ దయ్‌రమ్‌దాన్‌ మండ్రు ఇజి నాను గటిఙ వెహ్సిన. ఎందానిఙ్‌ ఇహిఙ మీలొఇ ఎయెన్‌బా సాజి సొన్‌ఇదెర్. గాని ఓడః ఉండ్రెనె పాడాఃన సొనాద్. ");
INSERT INTO kfc_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","24","ఎందానిఙ్‌ ఇహిఙ, పొదొయ్‌ ‌నాను, ఎయె వాండ్రునొ, ఎమేణి దేవుణుదిఙ్‌ పార్దనం కిజిననొ, అయ దేవుణు దూత నాబాన్‌ వాతండ్రె, ‘పవులు, తియెల్‌ ‌ఆమ. నీను కయ్‌సరు రాజు ఎద్రు నిల్దెఙ్‌వలె. దేవుణు కనికారమాతికాన్. నీవందిఙ్‍ ఇదిలో నీ వెట మ‍న్నివ‍రి పాణమ్‌కు దేవుణు గెల్‌పిస్నాన్లె’ ఇజి వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","అందెఙె బాబురాండె, దయ్‌రమ్‌దాన్‌ మండ్రు. ఎందనిఙ్‌ ఇహిఙ దూత నావెట వెహ్తివజ జర్గినాద్‌ ఇజి నాను దేవుణు మాట ‌నమ్మిజిన. ");
INSERT INTO kfc_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","గాని మా ఓడః గాలిదు సొన్సి ఎంబెబా ఉండ్రి ద్వీపుదు పాడానాద్”, ఇజి పవులు వరివెట వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","పదినాల్గి రోస్కు అద్రియ ఇని సమ్‌దరమ్‌దు మాపు ముసూర్దిఙ్ ‌అబె ఇబ్బె బూలాజి మహప్. మదరెయ్‌తు ఆతిఙ్‌ ఎంబెనొ ఉండ్రి దేసమ్‌ డగ్రు వాజినాప్‌ ఇజి ఓడః నడిఃపిసినివరిఙ్‌ ఉదెసమ్‌దు వాతాద్. ");
INSERT INTO kfc_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","అందెఙె వారు ఇజిరి బరుదిఙ్ తాడు తొహ్సి డిఃప్తారె ఎసొ లోతు మనాద్‌ ‌ఇజి సుడ్ఃతార్. నూట ఇర్‌వయ్ ‌అడుఃగుఙ్ లోతు మనాద్‌ ‌ఇజి నెస్తార్. సెగం వెనుక మరి డిఃప్తారె తొంబయ్‌ అడుఃగుఙ్ ‌లోతు మనాద్‌ ‌ఇజి నెస్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","మా ఓడః ఓరదు మన్ని పణుకుముస్కు తగ్లినాదొ ఇజి తియెలాతారె వారు ఓడః వెనుకపడఃకదాన్ ‌నాల్గి లంగరుఙ్ డిఃప్తారె జాయ్‌ ఆనెండ పార్దనం ‌కిజి మహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","ఇహిఙ్, ఓడః నడిఃప్నికార్ ‌ఓడః డిఃసి సొండ్రెఙ్‌ సుడ్ఃతార్. వారు ఓడః ముందాల్‌పడఃక మన్ని లంగరుఙ్ డిఃప్తెఙ్ ‌ఇజి నాటిసి ఓడఃదు మన్ని ఇజిరి ఓడః సమ్‌దరమ్‌దు డిప్తార్. ఇజిరి ఓడఃదు ఎక్సిసొండ్రెఙ్ ఆలోసనం కిత్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","పవులు అక్క నెస్తాండ్రె సదాతిపతివెట, “సయ్‌నమ్‌దివరివెట, యా ఓడః నడిఃపిసినికార్‌ ‌ఓడః డిఃసి సొనార్‌ ఇహిఙ, మీరు తప్రె ఆదెఙ్‌ ‌అట్‌ఇదెర్”, ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","అందెఙె సయ్‌నమ్‌దికార్‌ ‌ఇజిరి ఓడః తొహ్తిమహి నాసు కుతారె సమ్‌దరమ్‌దు డిఃస్త సితార్. ");
INSERT INTO kfc_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","కోడిఃజామ్‌దు పవులు విజెరె వెట వెహ్తాన్‌, “ఏలు బోజనం కిదు, మీరు బోజనం కిఏండాజి ‌పదినాల్గి రోస్కు ఆతె. నిస్సొ రోస్కు మీరు మన్సు బాద ఆజి ఇనికబా ఉణెఎండ మహిదెర్. ");
INSERT INTO kfc_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","అందెఙె నాను బతిమాల్జిన, బోజనం కిదు. ఎందనిఙ్‌ ఇహిఙ మీరు సాఏండ మండ్రెఙ్‌ వలె ఇహిఙ బోజనం కిదెఙ్‌వలె. తియెలామాట్. మీలొఇ ఎయె బుర్రదాన్‌బా ఉండ్రి కొప్పుబా రాల్‌జి సొన్‌ఏద్‌ ఇహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ఈహు వెహ్తి వెనుక పవులు రొట్టె అస్తాండ్రె వారు సుడ్ఃజి మహివలె దేవుణుదిఙ్‌ వందనమ్‌కు వెహ్తండ్రె రొటె ముకెఙ్‌ కితాండ్రె తిండ్రెఙ్‌ ‌మొదొల్‌స్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","వారు విజేరె దయ్‌రం ఆతారె బోజనం కిత్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","అయ ఓడఃదు మాపు మొత్తం రుండివందెఙ్ ‌డబయ్‌ఆరు - మంది మణిసిర్‌ ‌మహాప్. ");
INSERT INTO kfc_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","వారు పొటపంజు ఉటి వీస్తి వెనుక గొదుముఙ్ సమ్‌దరమ్‌దు విసీర్‌తారె ఓడః సుల్‌కాఙ్ కిత్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","పొద్దు సోత్తిఙ్ ‌వారు అందితి దేసెం ఎంబెణి దేసెం ఇజి నెస్‌ఏతార్ గాని ఓడః ఉండ్రి ఇస్క మన్ని పడఃకాద్‌ ఒతెఙ్‌ ‌తగితి ఉండ్రి నెగ్గి పడక సుడ్ఃతారె‌ బాన్‌ ఒనాట్ ఇజి ఒడిఃబితార్. ");
INSERT INTO kfc_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","అందెఙె ఓడః నడిఃపిసినికార్‌ లంగరుఙ్ తొహ్తిమహి నాస్కుఙ్‌ కుతారె సమ్‌దరమ్‌దు డిఃస్తార్. ఓడః నడిఃప్ని సుకానుఙ్ కట్టుఙ్‌ కుతార్. ముందాల్‌ పడఃకాదు మహి సాప ఎకిస్తారె గాలి నెక్సి ఒనిలెకెండ్ ఓరదు నడ్ఃపిస్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","గాని ఓడః ఏరులొఇ మన్ని ఉండ్రి ఇస్క మెటుదు డఃసె ఆతాదె ఓడః ముందాహిక ఇస్కాదు నాడిఃతాద్. వెనుక పడఃకాదు పెరి ఉల్కెఙ్‌ డెయ్‌తిఙ్‌ ఓడః బదెఙ్ ‌బదెఙ్ ‌ఆత సొహాద్. ");
INSERT INTO kfc_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","జెలిదాన్‌ ఒసి మహి లోకుర్ సమ్‌దరమ్‌దు ఈత డెఃయ్‌జి తప్రె ఆజి సొనార్‌ ఇజి తియెలాతారె వరిఙ్ ‌సప్తెఙ్ ‌సయ్‌నమ్‌దికార్‌ ఆలోసనం కిత్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","గాని సతాతిపతి పవులు ‌గిల్‌పిస్తెఙ్ ‌ఒడ్ఃబిజి సయ్‌నమ్‌ది వరి ఆలోసనమ్‌దిఙ్ సరి సిఏతాన్. ఈత డెఃయ్దెఙ్ ‌నెస్నివారు ముందాల సమ్‌దరమ్‌దు డిఃగ్‌జి గదెం డాట్సి ఈత డెఃయ్‌జి ఓరదు సొండ్రు ఇజి ఆడ్ర సిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","మహివరిఙ్‌ బల్లెఙ్ సెక్కెఙ్ ‌ఓడఃది ముక్కెఙ్ ‌అసి ఒడ్డుదు సొండ్రెఙ్‌ ఆడ్ర ‌సిత్తాన్. ‌ఈహె మాపు విజెపె గెల్‌స్తాపె ఒడ్డుదు అందితాప్. ");
INSERT INTO kfc_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","మాపు తప్రె ఆతి వెనుక ‌అయా ద్వీపు పేరు మెలిత ఇజి నెస్తాప్. ");
INSERT INTO kfc_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","అయ ద్వీపుదికార్ ‌మఙి కిత్తి సాయం నిస్సొ నసొ ఆఏద్‌. వారు సిసు ఎర్తారె మఙి విజేరిఙ్‌ కూడ్ఃప్తార్. ఎందానిఙ్‌ ఇహిఙ పిరు డెఃయ్దెఙ్ ‌మొదొల్‌స్తిఙ్ ‌పిన్ని కితాద్. ");
INSERT INTO kfc_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","పవులు ఉండ్రి కట రివెఙ్ పెహ్త తతాండ్రె దోస్తాన్. అక్క సిసుముస్కు అర్‌ప్తివలె గొప్ప విసం మన్ని ఉండ్రి సరాస్‌ ‌వేడిఃదిఙ్ ‌వెహ్‌కాణ్ ‌వెల్లి వాతాదె పవులు కీదు కట్తాద్. ");
INSERT INTO kfc_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","పవులు కీదు సరాస్‌ ‌దూఙ్‌జిమహిక అయ ద్వీపుదికార్ ‌సుడ్ఃతిఙ్‌ ‌వారు ఒరెన్‌ వెట ఒరెన్ ‌వర్గితార్, “నిజమ్‌నె, వీండ్రు లోకాఙ్‌ ‌సప్నికాండ్రె, ఏలు సుడ్ఃఅ, సమ్‌దరమ్‌దాన్ ‌గెలిసి వాతాన్ గాని నాయం సీని దేవుణు విన్నిఙ్ ‌బత్కిదెఙ్ సరి సిఎన్. ");
INSERT INTO kfc_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","గాని పవులు అయ సరాస్‌దిఙ్ ‌సిసుముస్కు సడ్ఃతిఙ్‌ అది సిసుద్ అర్‌తాద్. పవులుఙ్‌ ఇనికబా ఆఏతాద్. ");
INSERT INTO kfc_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ఆ ద్వీపుదు మనికార్‌ పవులు ఉబినాన్, సిలిఙ వెటనె సానాన్ ‌ఇజి ఒడిఃబిజి సుడ్ఃజి మహార్‌. గాని వారు సుడ్ఃజిమహిఙ్ పవులు ‌ఇనికబా ఆఏతాద్. అందెఙె వారు వరి మన్సు మారిస్తారె, ‘వీండ్రు ఒరెన్‌ దేవుణులెకెండ్ మన్నికాన్‌’ ఇజి వెహ్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","అయ ద్వీపుది నెయ్కి ఆతి పొప్లి ఇనివన్నిఙ్‌ బానె డగ్రునె బూమిఙ్‌ ‌మహె. వాండ్రు మఙి వన్ని కూలెఙ వజ ‌మర్యాద సితండ్రె మూండ్రి రోస్కు వన్ని ఇండ్రొ కూడుఃప్తాన్. ");
INSERT INTO kfc_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","అయ నెయ్కి అప్పొసి నోబుదిఙ్, మరి నెత్తెర్‌పొటదాన్‌ బాద ఆజి మహాన్‌. పవులు, వాండ్రు మహి గదిలొఇ సొహాండ్రె పార్దనం కితాండ్రె వన్ని ముస్కు కికు ఇడ్‌జి వన్నిఙ్ ‌నెగెండ్‌ కిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ఇక జర్గితిఙ్ ‌అయా ద్వీపుదు ‌కస్టం అస్తిమహికార్ విజేరె బానె వాతారె నెగెండ ‌ఆతార్. ");
INSERT INTO kfc_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","వారు మఙి నండొ ఇనాయమ్‌కు సిత్తారె నెగ్గిక కిత్తార్‌. వెనుక మాపు పయ్‌నమాతివలె మఙి అవ్‌సరం మనికెఙ్‌ విజు ఓడఃదు తత్తారె ఇట్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ముండ్రి నెలెఙ్‌ ఆతి వెనుక అలెక్సంత్రియదాన్ ‌వాతి ఉండ్రి ఓడః ఎక్తాపె పయ్‌నమాతాప్. అయ ఓడః పిన్ని కాలమ్‌దు మెలిత ద్వీపుదు మహాద్‌. కాస్తరు, పోలుక్సు ఇని జవల దె‍య‍మ్‌కాణి బొమ్మెఙ్ ఆ ఓడః ముందాహిబాన్‌ మహాద్‌. ");
INSERT INTO kfc_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","మాపు సురకూస్ ‌ఇనిబాన్‌ వాతాపె బానె మూండ్రి రోస్కు మహప్. ");
INSERT INTO kfc_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","బాణిఙ్‌ పయ్‌నమాతాపె సుటులం తిర్‌వ్‌జి రేగియు ఇనిబాన్‌ వాతాప్. ఉండ్రి రోజు వెనుక దసిణ దరోట్‌దాన్ ‌గాలి డెయ్‌తిఙ్‌ మహ్స నాండిఙ్‌ పొతియొలి ఇనిబాన్‌ వాతాప్. ");
INSERT INTO kfc_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","బానె నమ్మితి వరిఙ్‌ సెగొండారిఙ్‌ ‌సుడ్ఃతాప్. ‘మాబాన్ వారం రోస్కు మండ్రు’ ఇజి వారు మఙి బతిమాలితార్. దన్నివెనుక మాపు రోమ పట్నమ్‌దు వాతాప్. ");
INSERT INTO kfc_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","రోమాదు మహి నమ్మితికార్‌ మాపు రోమాదు వాజినాప్ ఇజి కబ్రు వెహారె సెగొండార్ రోమ పట్నమ్‌దాన్‌ అపియాదు మహి సత దాక, మరి సెగొండార్ మూండ్రి సత్రమ్‌కు మహి బాడ్డిదాక మఙి కూక్సి ఒతెఙ్‌ వాతార్. పవులు వరిఙ్‌ సుడ్ఃతిఙ్‌ దేవుణుదిఙ్‌ స్తుతి కిత్తాన్‌. వన్నిఙ్‌ దయ్‌రం వాతాద్. ");
INSERT INTO kfc_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","రోమ పట్నమ్‌దు అందితిఙ్‌ పవులుఙ్, వన్నిఙ్‌ కాప్‌కిని జమానివెట ఉండ్రి ఆదు ఇండ్రొ కేట మండ్రెఙ్ ‌సెలవ దొహ్‌క్తాద్. ");
INSERT INTO kfc_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","మూండ్రి రోస్కు సొహి వెనుక పవులు బానె మహి యూద పెద్దెల్‌ఙ వన్నిబాన్‌ ‌కూక్‌పిస్తాన్. వారు కూడ్ఃజి వాతివలె పవులు వరివెట వెహ్తాన్‌, “తంబెరిఙాండె, మా లోకాఙ్‌ ‌పడ్ః‌ఇకెఙ్ గాని, మా అనిగొగొరి అలవాటుఙ పడ్ఃఇకెఙ్‌ గాని ఇనికబా నాను కిఏత. ఇహిఙ్‌బా, నఙి యెరూసలేమ్‌దు అస్తారె రోమవరిఙ్‌ ఒపజెప్తార్. ");
INSERT INTO kfc_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","వారు నఙి గవర్నరుబాన్ తత్తారె నండొ ప్రస్నెఙ్ వెన్‌బాజి సుడ్ఃతివలె‌ సావుదిఙ్‌ తగితి తప్పు ఇనికబా నాను కిఏత ఇజి తెలితాద్. అయావలె నఙి డిఃస్తెఙ్ ‌సుడ్ఃతార్. ");
INSERT INTO kfc_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","గాని నఙి డిఃస్తెఙ్‌ యూదురు ఒప్పుకొడ్ఃఏతార్. అందెఙె నా సొంత లోకుముస్కు నఙి ఇని మొరొ సిల్లిఙ్‌బా కయ్‌సరుబాన్‌ సొన్సి నావందిఙ్‌ వెహ్తెఙ్‌ ఆత. ");
INSERT INTO kfc_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","అందెఙె నాను మిఙి సుడ్ఃదెఙ్‌ ‌మీ వెట వర్గిదెఙ్‌ మిఙి కూక్‌పిస్త. ఎందానిఙ్‌ ఇహిఙ ఇస్రాయేలు లోకు ఎయెవన్నివందిఙ్‌ ఎద్రు సుడ్ఃజి మంజినారొ వన్నివందిఙె నాను ఏలు యా గొలుస్కాణ్ తొహె ఆత మన్న”, ఇజి వరివెట వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","దన్నిఙ్‌ యూదురు, “యూదయ ప్రాంతమ్‌దు మన్ని మా లోకాణిఙ్ ‌మీవందిఙ్ ‌మఙి ఇని ఉత్రమ్‌బా రెఏతాద్. ఇబ్బె వాతి మా లోకు ఎయెర్‌బా మీ వందిఙ్‌ ఇని సెఇ మాటబా వెహ్‌ఏతార్. నీను ఇనికాదొ తప్పు కిత్తి ఇజి మాపు వెన్ఏతాప్. ");
INSERT INTO kfc_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","గాని యా సఙతివందిఙ్ ‌మీ ఆలోసనం ఇనిక ఇజి వెండ్రెఙ్‌ ‌మాపు ఆస ఆజినాప్. ఎందానిఙ్‌ ఇహిఙ నీను కూడిఃతి మహి యా జటువందిఙ్‌ విజేరె లోకుర్‌ పగదాన్‌ వెహ్సినార్‌ ‌ఇజి మాపు నెసినాప్”, ఇహార్‌. ");
INSERT INTO kfc_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","అందెఙె వారు పవులు వెట పలాన్‌ రోజు కూడ్ఃదెఙ్‌ ‌ఏర్‌పాటు కితారె పవులు బత్కినిబాన్ ‌మంద ఆజి వాతార్. పవులు పెందాహాన్ అసి‌ పొదొయ్‌దాక నెగ్రెండ వరిఙ్‌ వెహ్సి దేవుణు ఏలుబడిః వందిఙ్ ‌వరివెట వెహ్తాన్‌. ‌మోసె సిత్తి రూలుఙ్‌ దాన్, ప్రవక్తరు రాస్తి మాటెఙాణ్ ‌యేసువందిఙ్ తోరిసి, వాండ్రు వెహ్నికెఙ్ నిజమె ఇజి వెహ్సి తోరిస్తాన్. వరిఙ్ ఒపుకొడిఃస్తెఙ్ సుడ్ఃతాన్. ");
INSERT INTO kfc_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","పవులు వెహ్తి మాటెఙ్‌ సెగొండార్‌ నమ్మితార్, మహికార్‌ ‌నమ్మిఏతార్. ");
INSERT INTO kfc_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","వారు ఒరెన్‌ వెట మరి ఒరెన్‌ వర్గిజి నెక్త పొక్తారె ఉండ్రె మన్సు ఆదెఙ్‌ ‌అట్‌ఎండాతారె మర్‌జి సొహార్‌. ‌వారు మర్‌జి సొని ముందాల పవులు వరివెట ఉండ్రి మాట వెహ్తాన్‌, “దేవుణు ఆత్మ యెసయ ప్రవక్త దాన్‌ మీ అనిగొగొర్‌ వెట వెహ్తి మాట నిజమె. ");
INSERT INTO kfc_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","అక్క ఇనిక ఇహిఙ, “నీను సొన్సి యా లోకాఙ్‌ వెహ్తు. ‘మీరు బాగ వెంజినిదెర్ గాని అర్దం కిదెఙ్ అట్ఇదెర్. బాగ సుడ్ఃజినిదెర్ గాని తొఇదెర్‌'. ");
INSERT INTO kfc_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","ఎందానిఙ్‌ ‌ఇహిఙ యా లోకురి మన్సు బేగి అర్దం కిఎద్. వారు కణుకెఙ్ ‌గిబ్బిఙ్ ‌మూక్త మనార్. సిల్లిఙ్ ‌వారు కణకాణ్ ‌సుడ్ఃతార్ మరి. మన్సుదు అర్దం కిత్తార్‌ మరి. నా దరోట్‌ ‌మహ్తిఙ నాను వరిఙ్‌ నెగెండ ‌కిన”, ఇజి దేవుణు వెహ్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","అందెఙె దేవుణు రక్సణ సీనాన్‌ ఇని సువార్త యూదురు ఆఇ వరిఙ్ ‌సీజినాన్‌ ఇజి, వారు అయ మాట వెనార్, ఇజి మీరు నెస్తెఙ్‌ వలె”. ");
INSERT INTO kfc_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","30","రుండి పంటెఙ్ ‌పూర్తి పవులు ఉండ్రి ఇల్లు అదె లొస్తాండ్రె బత్కితాన్. వన్నిబాన్‌ ‌వాతివరిఙ్ విజెరిఙ్‌ వాండ్రు డగ్రు కిత్తాన్‌. ");
INSERT INTO kfc_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","దేవుణు ఏలుబడిః వందిఙ్, ప్రబు ఆతి యేసుక్రీస్తు వందిఙ్‌ దయ్‌రమ్‌దాన్, ఇని అడ్డు సిల్లెండ, నెస్పిస్తాన్.");
INSERT INTO kfc_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","క్రీస్తుయేసుఙ్‌ పణి కినికానాతి పవులు ఇని నాను యా ఉత్రం రాసిన. సువార్త వెహ్తెఙ్‌ దేవుణు నఙి అపొస్తుడుఙ వజ నిల్‌ప్తాన్. ");
INSERT INTO kfc_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","సేన కాలమ్‌కు ముఙాలె, ఇహిఙ, యేసు ప్రబు యా లోకమ్‌దు వానెండ మహివలెనె, దేవుణు మాటెఙ్‌ రాస్తి మహి ప్రవక్తరుబాన్‌ దేవుణు యా సువార్త వందిఙ్‌ వెహ్న ఇజి ఒపందం కిత్త మహాన్‌. ");
INSERT INTO kfc_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","దేవుణు మరిసి వందిఙె యా సువార్త. వీండ్రు లోకు వజ దావీదు రాజు తెగాదు పుట్తికాన్. ");
INSERT INTO kfc_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","వీండ్రు దేవుణు వజ ఇహిఙ, దేవుణు మరిసి ఇజి గొప్ప సత్తుదాన్‌ తోరె ఆతాన్. ఎలాగ ఇహిఙ, వాండ్రు సాతి వరిబాణిఙ్‌ మర్‌జి నిఙితాన్. వాండ్రు మా ప్రబు ఆతి యేసు క్రీస్తునె. ");
INSERT INTO kfc_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","క్రీస్తు దయాదర్మమ్‌దాన్‌ అపొస్తుడు వజ దేవుణు నఙి కూక్తాన్. ఎందానిఙ్‌ ఇహిఙ, విజు జాతిదికార్‌ క్రీస్తుముస్కు నమకం ఇడ్జి, వన్నిఙ్‌ మాడిఃసి, వన్నిఙ్‌ లొఙిజి మండ్రెఙ్‌ ఇజి. ");
INSERT INTO kfc_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","రోమ పట్నమ్‌దు యేసు క్రీస్తుఙ్‌ నమ్మితికార్‌ ఆతి మీరుబా దేవుణు కూక్తి వరి లొఇ మన్నిదెర్. ");
INSERT INTO kfc_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","దేవుణు ప్రేమ కిజి, వన్నిఙ్‌ కేట ఆతి మిఙి విజేరిఙ్‌ నాను యా ఉత్రం రాసిన. బుబ్బాతి మా దేవుణుబాణిఙ్‌, ప్రబు ఆతి యేసుక్రీస్తుబాణిఙ్‌ కనికారమ్‌ని నిపాతి మిఙి మనీద్‌ ఇజి నాను పార్దనం కిజిన. ");
INSERT INTO kfc_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","యా ఉత్రమ్‌దు తొలిత నాను మీరు విజిదెరె వందిఙ్‌ దేవుణుదిఙ్‌ వందనమ్‌కు వెహ్సిన. యేసు ప్రబువలెహాన్‌ నమ్మిత్తి దన్నివందిఙ్‌ రోమ దేసెమ్‌దికార్‌ ఏలుబడిః కిని విజు బాడ్డిదు మన్ని లోకుర్‌ వెహ్సినార్‌. ");
INSERT INTO kfc_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","10","నాను ఎస్తివలెబా పార్దనం కినివెలె మీ వందిఙ్‌ వెహ్సిని సువార్త పూర్తి మన్సుదాన్‌ నాను కిజిన ఇజి నెసిని దేవుణునె దిన్నిఙ్‌ సాసి. గాని నాను ఎలాగ ఇహిఙ్‌బా ఏలు వాజి మిఙి సుడ్ఃదెఙ్‌ దేవుణు సిత్తం ఆదెఙ్‌ ఇజి పార్దనం కిజిన. ");
INSERT INTO kfc_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","ఎందానిఙ్‌ ఇహిఙ, మిఙి వాజి సుడ్ఃజి దేవుణు వందిఙ్‌ బత్కిని బత్కుదు మిఙి దయ్‌రం కిబిస్తెఙ్‌ ఇజి ఆస ఆజిన. ");
INSERT INTO kfc_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ఎలాగ దయ్‌రం కిబిస్తెఙ్‌ ఇహిఙ మాటు ఒరెన్‌ వన్ని నమకమ్‌దాన్‌ మరి ఒరెన్‌ వన్నిఙ్‌ దయ్‌రం వెహ్తెఙ్‌వెలె. ");
INSERT INTO kfc_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","నమ్మితి తంబెరిఙాండె, నాను నండొ సుట్కు మిఙి సుడిః వాదెఙ్‌ ఇజి ఆలోసనం కిత్త ఇజి మీరు నెస్తెఙ్‌వెలె. గాని అట్‌ఎండ ఆత. ఎందానిఙ్‌ ఇహిఙ, నండొ అడ్డుఙ్‌ వాతె. మీ బాన్‌ వాజి మిఙి సుడ్ఃతిఙ మీ బాణిఙ్‌ మఙి గొప్ప లాబం వాని లెకెండె. ఎందానిఙ్‌ ఇహిఙ మీ నన్ని నండొ జాతిఙ నడిఃమి నాను సొని లెకెండ్‌ మీ నడిఃమిబా నాను వాజి సువార్త వెహ్తెఙె ఇజి. సువార్త వెంజి నమ్మిజి దేవుణు కొడొఃర్‌ ఆనార్. ");
INSERT INTO kfc_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","యూదురు ఆఇ వరిఙ్‌ విజేరిఙ్‌ సువార్త వెహ్తెఙ్‌ నాను ఉండ్రి అప్పు మన్నికాన్. గ్రీకు బాస నెస్తి వరిఙ్‌బా, నెస్‌ఇ వరిఙ్‌బా, పెరి సదువు మన్ని వరిఙ్‌బా, సదువు సిల్లి వరిఙ్‌బా వెహ్సి సీదెఙ్‌ ఇజి నఙి ఉండ్రి అప్పు మనాద్. ");
INSERT INTO kfc_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","అందెఙె, రోమ పట్నమ్‌దు మన్ని మిఙిబా యా సువార్త వెహ్తెఙ్‌ ఇజి నాను గొప్ప ఆస ఆత మన. ");
INSERT INTO kfc_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","ఎందానిఙ్‌ ఇహిఙ, నాను సువార్త వెహ్తెఙ్‌ సిగు ఆఏ. యేసుక్రీస్తు ముస్కు నమకం ఇడ్ని విజేరిఙ్‌ వరి పాపమ్‌కాణిఙ్‌ రక్సిస్తెఙ్‌ యా సువార్తదిఙ్‌ దేవుణుబాణిఙ్‌ ఒద్దె సత్తు మనాద్. యా సువార్త తొలిత యూదురిఙ్‌ వెనుక ఆఇ జాతిఙ సాటె ఆజినాద్‌. ");
INSERT INTO kfc_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","యా సువార్తదు దేవుణు ఇనిక వెహ్సినాన్‌ ఇహిఙ, లోకు కిత్తి తప్పు పణిఙ వందిఙ్‌ వారు సిక్స పొందిదెఙ్‌ అక్కర్‌ సిల్లెద్‌ ఇజినె. వారు యేసుప్రబు ముస్కు నమకం ఇడ్తి వందిఙె సిక్సదాన్‌ తప్రె ఆతార్. యాక ముందాల్‌ ఒరెన్‌ దేవుణు ప్రవక్త రాస్తి లెకెండ్‌నె. “ఎయెర్‌ నీతినిజయ్తికాన్‌ ఇజి నాను ఇడ్త మనానొ, వాండ్రు నా ముస్కు నమకం ఇడ్తి వందిఙ్‌ ఎలాకాలం బత్కినాన్”. ");
INSERT INTO kfc_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","దేవుణువందిఙ్‌ మన్సు సిల్లి లోకాఙ్‌ విజేరిఙ్‌ సెఇపణి కిని విజేరిఙ్‌ దేవుణు సిక్స సీనాన్‌ ఇజి పరలోకమ్‌దాన్‌ తోరిస్త మనాన్‌. ఎందానిఙ్‌ ఇహిఙ, వరి సెఇ పణిదాన్‌ దేవుణు వందిఙ్‌ నెస్తిమన్ని నిజమాతికెఙ్‌ విజు వారు అడ్డు కిజినార్‌. ");
INSERT INTO kfc_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","దేవుణు వందిఙ్‌ నిజమాతికెఙ్‌ అర్దం కిదెఙ్‌ వారు అట్నార్‌. ఎందానిఙ్‌ ఇహిఙ, దేవుణు ఎలాగమర్తికాన్‌ ఇజి వాండ్రు విజేరిఙ్‌ తోరిస్త మనాన్‌. ");
INSERT INTO kfc_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","మాపు దేవుణుదిఙ్‌ నెస్‌ఏప్‌ ఇజి ఎయెన్‌బా వెహ్తెఙ్‌ వీలు సిల్లెద్‌. ఎందానిఙ్‌ ఇహిఙ, దేవుణు ఎలాగ మర్తికాన్‌ ఇజి మాటు సుడ్ఃదెఙ్‌ సిల్లె, గాని వాండ్రు లోకం తయార్‌ కిత్తిబాణిఙ్‌ అసి లోకమ్‌దు తయార్‌ కిత్తి వనకబాణిఙ్‌ వాండ్రు ఎలాగ మర్తికాన్‌ ఇజి ఎలాకాలం మన్ని వన్ని పెరిసత్తు ఎలాగమర్తిక ఇజి మాటు సుడ్ఃజినాట్‌. అందెఙె దేవుణుదిఙ్ నెస్‌ఏన్‌ ఇజి ఎయెన్‌బా వెహ్తెఙ్‌ వీలు సిల్లెద్‌. ");
INSERT INTO kfc_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","యూదురు ఆఇకార్, దేవుణు ఎలాగ మర్తికాన్‌ ఇజి నెస్తిఙ్‌బా దేవుణు ఇజి మాడిఃస్‌ఎర్, వాండ్రు కిత్తి దన్నివందిఙ్‌ వందనమ్‌కు వెహ్ఏర్. నస్తివలె వారు దేవుణు వందిఙ్‌ అర్దం కిదెఙ్‌ అట్‌ఎండ ఆతారె. వరి ఆలోసనమ్‌కు సెఇకెఙ్‌ ఆతె. ");
INSERT INTO kfc_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","వారు బుద్ది మన్నికార్‌ ఇజి వెహె ఆజి బుద్ది సిల్లి పణిఙ్‌ కిత్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ఎలాకాలం మంజిని దేవుణుదిఙ్‌ పొగ్‌డిఃజినగవ్‌రం సిఏండ బొమ్మెఙ పొగ్‌డిఃజి గవ్‌రం సిత్తార్‌. సబ్జిసొని లోకులెకెండ్‌, పొటిఙ్‌ లెకెండ్‌, జమతుఙ్‌ లెకెండ్‌, మరి బూమి ముస్కు ఊజి బూలాని వనకాఙ్‌ లెకెండ్‌ తోర్ని బొమ్మెఙ తయార్‌ కిత్తారె వనకాఙ్‌ పొగ్‌డిఃజి గవ్‌రం సిత్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","అందెఙె వారు, కిదెఙ్‌ ఆఇ ఆసెఙ్‌ వరి మన్సుదు పుట్తి లెకెండ్‌ కిదెఙ్‌, దేవుణు వరిఙ్‌ సరి సిత్తాన్‌. ఇనిక ఇహిఙ వారు వరిఙె సుగు ఆతి సెఇ పణిఙ్‌ కిత్తార్‌. ");
INSERT INTO kfc_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ఎందానిఙ్‌ ఇహిఙ, నిజమాతి దేవుణు వందిఙ్, నిజమ్‌దిఙ్‌ డిఃస్తారె నిజం ఆఇ దన్నిఙ్‌ ఇడ్తార్. విజు దన్నిఙ్‌ పుటిస్తికాన్‌ ఆతి ఒరెండ్రె దేవుణుదిఙ్, మాడిఃసి వన్నిఙ్‌ లొఙిఎండ, దేవుణు పుటిస్తి వనకాఙ్‌ మాడిఃస్తార్, వనకాఙ్‌ లొఙిత్తార్. గాని పుటిస్తికెఙ్ విజు అయ దేవుణుదిఙె ఎస్తివలెబా మాడిఃస్తెఙ్‌ వెలె. ");
INSERT INTO kfc_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","అందెఙె సిగు ఆతి ఒడొఃల్‌ ఆసెఙ వందిఙ్‌ దేవుణు వరిఙ్‌ ఒపజెప్తాన్. అందెఙె వరిలొఇ అయ్‌లికొడొఃక్‌ మాసిరిఙ్‌ సొన్‌ఏండ అయ్‌లికొడొఃకాఙ్‌ దరోట్‌ ఒడొఃల్‌ ఆస ఆజి మహ్తె. ");
INSERT INTO kfc_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","అయావజనె యూదురు ఆఇవరి లొఇ మొగకొడొఃర్‌ ఆల్సికాఙ్‌ ఇడ్‌ఏండ మొగకొడొఃర్‌ దరోట్‌ ఏక ఉత్‌పుత్‌ ఆజి మహ్తార్‌. వారు మొగకొడొఃర్‌ వెట సిగు ఆతి పణిఙ్‌ కిత్తార్. అయ ఒద్దె తప్పు ఆతి పణిఙ్‌ వరిఙ్‌ తగితి సక్స ఆజి వరిముస్కు వాతాద్‌. ");
INSERT INTO kfc_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","వారు దేవుణుదిఙ్‌ నెక్తపొక్తారె వన్ని వందిఙ్‌ నెస్తిమన్ని నిజమాతికెఙ్‌ విజు డిఃస్తసితార్‌. నస్తివలె వరి సెఇ బుద్దిదు నడిఃదెఙ్‌ ఇజి దేవుణు వరిఙ్‌ డిఃస్తసిత్తాన్‌. అందెఙె సరి ఆఇ పణిఙ్‌ కిదెఙ్‌ వరి బుద్ది మహ్తద్. ");
INSERT INTO kfc_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","విజు రకమ్‌కాణి సెఇ పణిఙ్‌ కిదెఙ్‌ వారు ఏక ఒడ్ఃబినార్‌. ఇనికెఙ్‌ ఇహిఙ, మహి వరిఙ్‌ సెడ్డ కిదెఙ్, మహివరిఙ్‌ మన్నికెఙ్‌ మఙి దొహ్‌క్తెఙ్‌ ఇజి సెఇ ఆస ఆదెఙ్‌, ఎలాగబా మహివరిఙ్‌ సెఇక కిదెఙ్, మహివరి వెట గోస ఆదెఙ్, సప్తెఙ్, గొడఃబ కిబిస్తెఙ్, మొసెం కిదెఙ్, మహివరివందిఙ్‌ సెఇకెఙ్‌ వెహ్తెఙ్, సొండి వెహ్తెఙ్. ");
INSERT INTO kfc_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","నండొ లోకుర్‌ మహివరివందిఙ్‌ తప్పుఙ్‌ వెహ్సినార్. నండొండార్‌ దేవుణు ఎద్రు వెత్రేకం కిజినార్, ఆఇవరిఙ్‌ సిగు కిబిస్నార్, గర్ర ఆజినార్, పొఙిజినికార్‌ ఆజినార్, మరి రెకరకమ్‌ది కొత్త సెఇపణిఙ్‌ ఎలాగ కిదెఙ్‌ ఇజి సుడ్ఃజినార్‌, వరి కొడొఃర్‌ అయ్‌సి అప్పొసిరిఙ్‌ లొఙిఏర్‌. ");
INSERT INTO kfc_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","వారు అర్దం కిదెఙ్‌ అట్‌ఏర్‌. 