﻿USE sofia;
DROP TABLE IF EXISTS sofia.key_vpl;
CREATE TABLE key_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES key_vpl WRITE;
INSERT INTO key_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","అబ్రాహామ్‌చి సెకుమ్‍తె జెర్మిలొ దావీదు రానొచి వంసుమ్‍తే యేసుక్రీస్తు జా జెర్మిలన్. జోచి వంసుమ్ ఇసి జలి. ");
INSERT INTO key_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","అబ్రాహామ్ ఇస్సాకుక పాయిలన్. ఇస్సాకు యాకోబుక పాయిలన్. యాకోబు యూదాక చి జోచ అన్నసీంక బావుడ్సివొక పాయిలన్. ");
INSERT INTO key_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","యూదా తామారు మెలి తేర్సి తెన్ పెరెసుక చి జెరహుక పాయిలన్. ");
INSERT INTO key_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","పెరెసు ఎస్రోముక పాయిలన్. ఎస్రోము అరాముక పాయిలన్. అరాము అమ్మినాదాబుక పాయిలన్. ");
INSERT INTO key_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","అమ్మినాదాబు నయస్సోనుక పాయిలన్. నయస్సోను సల్మానుక పాయిలన్. సల్మాను రాహాబు మెలి తేర్సి తెన్ బోయజుక పాయిలన్. బోయజు రూతు మెలి తేర్సి తెన్ ఓబేదుక పాయిలన్. ఓబేదు యెస్సయిక పాయిలన్. ");
INSERT INTO key_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","యెస్సయి దావీదు రానొక పాయిలన్. ఈంజొ దావీదు రానొ ఊరియా మెలొ ఎక్కిలొచి తేర్సి తెన్ సొలొమోనుక పాయిలన్. ");
INSERT INTO key_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","సొలొమోను రెహబాముక పాయిలన్. రెహబాము అబీయాక పాయిలన్. అబీయా ఆసాక పాయిలన్. ");
INSERT INTO key_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ఆసా యెహోసాపాతుక పాయిలన్. యెహోసాపాతు యెహోరాముక పాయిలన్. యెహోరాము ఉజ్జియాక పాయిలన్. ");
INSERT INTO key_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ఉజ్జియా యోతాముక పాయిలన్. యోతాము ఆహాజుక పాయిలన్. ఆహాజు హిజ్కియాక పాయిలన్. ");
INSERT INTO key_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","హిజ్కియా మనస్సేక పాయిలన్. మనస్సే ఆమోనుక పాయిలన్. ఆమోను యోసీయాక పాయిలన్. ");
INSERT INTO key_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","పడ్తొ యూదుల్‍క బబులోను దేసిమి విరోదుమ్ సుదల్ దెర గెలి కాలుమ్, యోసీయా యెకోన్యాక చి జోచ బావుడ్సివొక పాయిలన్. ");
INSERT INTO key_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","యూదుల్‍క బబులోను దేసిమ్‍చి విరోదుమ్ సుదల్ దెర గెలి పడ్తొ, యెకోన్యా సయల్తీయేలుక పాయిలన్. సయల్తీయేలు జెరుబ్బాబెలుక పాయిలన్. ");
INSERT INTO key_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","జెరుబ్బాబెలు అబీహూదుక పాయిలన్. అబీహూదు ఎల్యాకీముక పాయిలన్. ఎల్యాకీము అజోరుక పాయిలన్. ");
INSERT INTO key_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","అజోరు సాదోకుక పాయిలన్. సాదోకు ఆకీముక పాయిలన్. ఆకీము ఎలీహూదుక పాయిలన్. ");
INSERT INTO key_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ఎలీహూదు ఎలీయాజరుక పాయిలన్. ఎలీయెజెరు మత్తానుక పాయిలన్. మత్తాను యాకోబుక పాయిలన్. ");
INSERT INTO key_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","యాకోబు మరియచొ మున్సుసి జలొ యోసేపుక పాయిలన్. మరియచి పెట్టి క్రీస్తు మెంతొ యేసు జెర్మిలన్. ");
INSERT INTO key_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ఇసి, అబ్రాహామ్ తెంతొ మొదొల్ కెర, దావీదు రానొ ఎదక, వర్స తెన్ మొత్తుమ్ చొవ్ద తరుమ్‍లు జల. అన్నె, దావీదు రానొ తెంతొ మొదొల్ కెర, యూదుల్‍క బబులోను దేసిమి విరోదుమ్ సుదల్ కడ నిలి ఎద చొవ్ద తరుమ్‍లు జల. బబులోనుతె గెలి తెంతొ అన్నె మొదొల్ కెర, క్రీస్తు ఎద కి చొవ్ద తరుమ్‍లు జల. ");
INSERT INTO key_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","యేసుక్రీస్తు జెర్మిలిసి కీసి జలి మెలె, మరియచ అయ్యసిఁసి, “అమ్‍చి బోదక తుక దెమ్‍దె” మెన యోసేపుక సంగిలి పడ్తొ, జేఁవ్ దొగుల నే బెదితె అగ్గె, దేముడుచి సుద్ది తిలి ఆత్మ తెన్ మరియ అంగి జలి. ");
INSERT INTO key_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","మరియచొ మున్సుసి జంక తిలొ యోసేపు, జా దస్సి జా అస్సె మెన సూన కెర, జో పున్నిమ్ జలొసొ మాన్సుచి రిసొ, పడ్తొ మాన్సుల్‍చి మొక్మె జాక లాజ్ కెరుక నెస కెర, గగ్గొల్ నే జతె లుంకవ జాక ముల దెంక మెల ఉచర్లన్. ");
INSERT INTO key_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","జో ఇసి కెరుక మెన ఉచర్తె తతికయ్, ప్రబుచొ దూత ఎక్కిలొ సివ్న తెన్ జోక డీస కెర, “దావీదు రానొచి సెకుమ్‍చొ ఓ యోసేపు, తుచి తెర్ని జతి మరియక ఆననుక తుయి బి నాయ్. దేముడుచి సుద్ది తిలి ఆత్మసెక్తిక జా అంగి జా అస్సె. ");
INSERT INTO key_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","జాచి పెట్టి ఏక్ పుత్తుసి జెర్మెదె. జొయ్యి జోచ ప్రెజల్‍క జోవయించ పాపల్ తెంతొ రచ్చించుప కెరెదె. జాచి రిసొ, జోక ‘యేసు’ మెన నావ్ తీ” మెన జో దూత సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ఈంజ ఎత్కి కిచ్చొక జర్గు జలి మెలె, దేముడు జోచ కబుర్లు సంగిలొసొచి అత్తి సంగిలి కోడు నెరవెర్సుప జంకయ్ ఇసి జలి. ");
INSERT INTO key_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“ఈందె, విడ్డి బోద అంగి జయెదె, చి జాచి పెట్టి ఏక్ పుత్తుసి జెర్మెదె. జోక ‘ఇమ్మానుయేలు’ మెన నావ్ తిస్తె,” జా నావ్‌చి అర్దుమ్ కిచ్చొ మెలె, ‘దేముడు అమ్‍క తోడ్ తయెదె’. ");
INSERT INTO key_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","జలె, యోసేపు నిజ తా ఉట్ట కెర, ప్రబుచొ దూత జోక సంగిలి రితి, జోచి తేర్సిక ఆనన్లన్. ");
INSERT INTO key_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","దస్సి, జాచి పుత్తుసి నే జెర్మితె ఎదక, జాచి తెన్ బెద నిజె నాయ్, జో జెర్మితికయ్, యోసేపు జోక ‘యేసు’ మెన నావ్ తిలన్. ");
INSERT INTO key_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","హేరోదు రానొ జా యూదయ ప్రదేసిమి ఏలుప కెర్తె తిలి పొది, జా ప్రదేసిమ్‍చి బేత్లెహేమ్ పట్నుమ్‍తె యేసు జెర్మిలి పిమ్మట్, ఈందె, తూర్పు దేసిమ్‍చ పండితుల్ సగుమ్‍జిన్ యెరూసలేమ్ మెలి వెల్లి పట్నుమ్‍తె జా కెర, ");
INSERT INTO key_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“యూదుల్‍చొ రానొ జంక జెర్మిలొసొ కేనె అస్సె? తూర్పు పక్క జోచి సుక్కొక దెకిలమ్, చి జోక బక్తి కెరుక జా అస్సుమ్” మెన ప్రెజల్‍క సంగితె తిల. ");
INSERT INTO key_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","హేరోదు రానొ ఈంజ కోడు సూన కెర, జో కి, జో తెన్ యెరూసలేమ్ పట్నుమ్‍చ ఎత్కిజిన్ కి ‘అన్నెక్లొ రానొ జంక ఉచరెదె’ మెన బియఁ కెర, పంబ్ర జా. ");
INSERT INTO key_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","దేముడు నిసాన యూదుల్‍చ వెల్లెల పూజర్లుక చి మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస ఎత్కిజిన్‍క, బుకారా కెర, “క్రీస్తు కేనె జెర్ముక అస్సె?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","జేఁవ్, “ఈంజ యూదయ ప్రదేసిమ్‍చి బేత్లెహేమ్ పట్నుమ్‍తె జెర్మెదె. ");
INSERT INTO key_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘ఓ యూదయ ప్రదేసిమ్‍చి బేత్లెహేమ్ పట్నుమ్, తుయి యూదయ ప్రదేసిమ్‍తె తిలి దాక్ పట్నుమ్ నెంజిస్. కిచ్చొక మెలె, ఇస్రాయేలులు మెల అంచ ప్రెజల్‍క ఏలుప కెర్తొసొ తుచితె జెర్మెదె’ దేముడుచ కబుర్లు సంగిలొ పూర్గుమ్‍చొ ఎక్కిలొచి అత్తి రెగ్డ అస్సె” మెన జబాబ్ దిల. ");
INSERT INTO key_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","తెదొడి హేరోదు రానొ తూర్పు దేసిమి తెంతొ అయ్‍ల పండితుల్‍క గుట్టు తెన్ బుకారా కెర, జేఁవ్ దెకిలి సుక్కొ కెఁయ డీసిలి గే సూన కెర, ");
INSERT INTO key_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","“తుమ్ గెచ్చ, జో బోద కేనె అస్సె గే సరిగా చజ దెక జా, అన్నె జా కెర, అంక సంగ. ఆఁవ్ కి గెచ్చ, జోక బక్తి కెరిందె” మెన మోసిమ్ తెన్ సంగ, జేఁక బేత్లెహేమ్ పట్నుమ్‍తె తెద్రయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","జేఁవ్ పండితుల్ జో రానొచ కొడొ సూన కెర, బార్ జా గెతె తతికయ్, ఈందె, తూర్పు దేసిమి జేఁవ్ దెకిలి సుక్కొ జేఁవ్‍చి కంట అగ్గె ఇండ గెతె తా, జో బోద తిలొ గేర్‍చి ఉప్పిరి టీఁవొ జలి. ");
INSERT INTO key_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","జా సుక్కొ టీఁవొ జలిసి దెక కెర, ఒగ్గర్ సర్దసంతోసుమ్ జా, ");
INSERT INTO key_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","జా గెరి పెస, మరియ అయ్యస్ తెన్ తిలొ జో బోదక దెక, సెర్ను సేడ జోక జొకర, జోవయించ పెట్టెల్ ఉగ్డ కెర, బఙార్, దూపుమ్, చెంగిలి వాసెన తేలు, దసచ, బవుమానుమ్‍క దిల. ");
INSERT INTO key_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","బక్తి కెర్లి పిమ్మట్, “హేరోదు రానొతె అన్నె గెచ్చ నాయ్” మెన, సివ్నతె దేముడు జేఁవ్‍క జాగర్త సంగితికయ్, జేఁవ్ వేర వాటు జోవయించి దేసిమి బుల, ఉట్ట గెల. ");
INSERT INTO key_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","జేఁవ్ తూర్పు దేసిమ్‍చ ఉట్ట గెలి పిమ్మట్, ప్రబుచొ దూత ఎక్కిలొ సివ్న తెన్ యోసేపుక డీస కెర, “హేరోదు ఈంజొ బోదక మార గెలుక ఉచర్తయ్. జాచి రిసొ, తుయి ఉట్ట, ఈంజొ బోదక చి అయ్యస్‍క కడ దెరన, ఐగుప్తు దేసిమి ఉట్ట గో. ఆఁవ్ తుక అన్నె సంగితె ఎద ఒత్త తా” మెన యోసేపుక జో దూత సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","జో ఉట్ట కెర, అందరె బోదక చి అయ్యస్‍క కడ దెరన, ఐగుప్తు దేసిమి ఉట్ట గెచ్చ, ");
INSERT INTO key_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","హేరోదు రానొ మొర గెతి ఎదక ఒత్త తా గెల. దేముడుచ కబుర్లు సంగిలొ పూర్గుమ్‍చొచి అత్తి సంగిలి కొడొ నెరవెర్సుప జంకయ్ ఇసి జర్గు జలి. “ఐగుప్తు దేసిమి తెంతొ అంచొ పుత్తుక బుకార్లయ్.”, మెన సంగిలిసి. ");
INSERT INTO key_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","తెదొడి, ‘జా దీసి జా తిల పండితుల్ అంక మోసిమ్ కెర్ల’ మెన హేరోదు రానొ జాన కెర, ఒగ్గర్ కోపుమ్ ఆనన, యేసుక మారుక మెన, కెఁయ జెర్మ తయెదె గే జేఁవ్ పండితుల్ అగ్గె సంగిల కొడొక ఉచర, బేత్లెహేమ్‍తె, పడ్తొ జా పట్నుమ్‍చి సుట్టునంతచ గాఁవ్వొ ఎత్కితె, దొన్ని వెర్సుల్ తెంతొ మొదొల్ కెర, తొక్కి వయసుచ మున్సుబోదల్ ఎత్కిక మొరవ గెలన్. ");
INSERT INTO key_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ఇన్నెతెన్ కి యిర్మీయా మెలొ పూర్గుమ్‍చొచి అత్తి దేముడు సంగిలి కోడు నెరవెర్సుప జలి. ");
INSERT INTO key_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“రామా మెలి పట్నుమ్‍చి ఎది దూరి తెంతొ, ఒగ్గర్ ఏడుకుడు జతిసి, దుకుమ్ జతిసి, సూన్ల. జేఁవ్‍చ బోదల్ మొర గెలి రిసొ, రాహేలు ఏడ ఏడ సేంతుమ్ జయ్యె నాయ్.” ");
INSERT INTO key_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","హేరోదు రానొ మొర గెలి పడ్తొ, ఈందె, ప్రబుచొ దూత ఐగుప్తు దేసిమి యోసేపుక సివ్న తెన్ అన్నె డీస కెర, ");
INSERT INTO key_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“తుయి ఉట్ట, బోదకచి అయ్యస్‍క కడ దెరన, తుమ్‍చి ఇస్రాయేలు దేసిమి అన్నె ఉట్ట గెచ్చ. బోదక మార గెలుక ఉచర్లొసొ మొర గెలన్” మెన సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","జో ఉట్ట కెర, బోదకచి అయ్యస్‍క కడ దెరన, ఇస్రాయేలు దేసిమి అన్నె ఉట్ట అయ్‍ల. ");
INSERT INTO key_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","జలె, హేరోదు రానొ మొర గెలి రిసొ, అప్పె జా యూదయ ప్రదేసిమి జోచొ పుత్తుసి అర్కెలాయు ఏలుప కెర్తయ్ మెన సూన కెర, యోసేపు ఒత్త గెచ్చుక బియఁ కెర, అన్నెక్ సివ్న తెన్ ప్రబుచి అన్నెక్ కబుర్ సూన కెర, ");
INSERT INTO key_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","గలిలయ ప్రాంతుమ్‍తె ఉట్ట గెచ్చ. నజరేతు గఁవ్వి జా కెర, ఒత్త జితె తిల. ఒత్త జిలిస్ తెన్, “యేసుక ‘నజరేయుడు’ మెనుక జయెదె” మెన పూర్గుమ్ దేముడుచ కబుర్లు సంగిలసచి అత్తి జో సంగిలిసి కోడు నెరవెర్సుప జంకయ్ ఇసి జర్గు జలి. ");
INSERT INTO key_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","జా దీసల్‍తె, బాప్తిసుమ్ దెతొ యోహాను మెలొసొ బార్ జా, ");
INSERT INTO key_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“దేముడుచి రాజిమ్ పాసి జా అస్సె. జాకయ్ తుమ్‍చి పాపల్‍చి రిసొ దుకుమ్ జా ఒప్పన, పాపుమ్‍బుద్ది ముల దాస” మెన యూదయ ప్రదేసిమ్‍చి బయిలె బుల బుల సాట్ప కెర్తె తిలన్. ");
INSERT INTO key_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","జోచ కబుర్లు సంగిలొ యెసయా పూర్గుమ్‍చొచి అత్తి ఈంజొ యోహానుచి రిసొయి దేముడు సంగిలి కోడు ఇన్నెతెన్ నెరవెర్సుప జలి. “ఎక్కిలొ అంచొ బారికి రితొ జా, అంచొ అవాడ్ రితొ జా. ప్రబు జెతికయ్ వాటు తిన్నగ కెర్లి రితి, తుమ్ ఎత్కిజిన్ బుద్ది జా మెన, బయిలె ప్రదేసిమి తా కేక్ గల సాట్ప కెరెదె.” ");
INSERT INTO key_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ఈంజొ యోహాను ఒంటెచ రోమల్‍క పాలల్ గలన, చామ్‍క కెర్లి పట్క నెడిమి బందన తయెదె. చిట్కల్‍చి ఒండడ్ తేల్ జో కయెదె. ");
INSERT INTO key_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","జా దీసల్‍తె, యెరూసలేమ్ పట్నుమ్‍తెచ మాన్సుల్ కి, జా ఒంటి యూదయ ప్రదేసిమ్‍చ మాన్సుల్ కి, ఒంటి యోర్దాను మెంతి గాడు పాసిచ మాన్సుల్ కి, యోహానుతె జా కెర, ");
INSERT INTO key_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","జేఁవ్ కెర్ల పాపల్ దుకుమ్ తెన్ ఒప్పన ఎదార్దుమ్ సంగ, యోర్దాను గడ్డె జోచి అత్తి బాప్తిసుమ్ నఙన్‍తె తిల. ");
INSERT INTO key_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","పరిసయ్యుల్‍క కి, సద్దూకయ్యులుక కి, ఒగ్గర్‍జిన్ జా బాప్తిసుమ్ నఙనుక జెతిసి యోహాను దెక కెర, “అయివొచి రితి విస్సుమ్ పెట్టి తిలస, తుమ్! దేముడు కెర్తి సిచ్చ పిట్టవనుక ఉచరుక మెన తుమ్‍క సికడ్లొసొ కొన్సొ? ");
INSERT INTO key_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","తుమ్ కెర్త పాపల్ ముల దా, చెంగిల్ బుద్దితె ఇండ, ఆత్మచి పంటొ దెర. ");
INSERT INTO key_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","పిమ్మట్, ‘అబ్రాహామ్ అమ్‍క అబ్బొ జయెదె, చి రిసొ దేముడు తెన్ బెద అస్సుమ్’ మెన తుమ్‍క తూమ్ ఉచరన, సొంత గవురుమ్ సంగనుక నాయ్. కిచ్చొక మెలె, ఇన్నెచ పత్రల్ తెన్ కి దేముడు అబ్రాహామ్‌చి రిసొ బోదల్‍క జెర్మవుక తెరె, మెన తుమ్‍క ఆఁవ్ సంగితసి. ");
INSERT INTO key_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ఈందె, అప్పె కి ప్రబు కురాడు వాండి కెర, రూకుక బుంది కండితి రితి, కురాడు దెర టీఁవొ జా అస్సె. జలె, చెంగిల్ పంటొ నే దెర్తొ, ఎత్కి రూకుక కండ కెర ఆగితె గలుల” మెన, జేఁవ్‍క యోహాను సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","తెదొడి, ప్రెజల్‍క యోహాను “తుమ్ కెర్త పాపల్‍చి రిసొ తుమ్ దుకుమ్ జా ముల దెతి గుర్తుకయ్ ఆఁవ్ తుమ్‍క ఇసి పానితె బాప్తిసుమ్ దెతసి. గని, అంచి పడ్తొ అన్నెక్లొ అప్పె జెతయ్. జో అంచి కంట వెల్లొ, జోక అదికారుమ్ ఒగ్గరి. జోచ జోడ్లు వయుక జలెకు, ఆఁవ్ విలువ నాయ్. జో, దేముడుచి సుద్ది తిలి ఆత్మ తెన్ చి ఆగి తెన్ తుమ్‍క బాప్తిసుమ్ దెయెదె. ");
INSERT INTO key_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","జోచి పూన్‍తి సూపు జోచి అత్తి అస్సె, చి జోచి కెల్ని సుబ్రుమ్ కెర, జోక కామ్‍క జెతికయ్ గోదుమ్ పంటొ గుడ్డ కెర కొట్టుతె కుడవనెదె, చి కో విజవుక నెతిర్లి ఆగితె పోటు గల, డయ గెలెదె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","జా సమయుమి, ఈంజ బాప్తిసుమ్ నఙనుక మెన యేసు గలిలయ ప్రాంతుమ్ తెంతొ ఉట్ట జా కెర, యోర్దాను గడ్డె యోహానుతె అయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","యోహాను జోక దెక కెర, “ఆఁవ్ తుచి అత్తి బాప్తిసుమ్ నఙనుక అస్సె. తుయి కిచ్చొక అంచితె బాప్తిసుమ్ నఙనుక జెతసి? బెదె నాయ్” మెన యేసుక సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","యేసు “అల్లె, అప్పెచి మట్టుక ఇసి జర్గు జవుస్. దేముడుచి నీతి ఎత్కి ఇసి నెరవెర్సుప కెరుక అమ్‍క చెంగిలి” మెన యేసు జబాబ్ దెతికయ్, యోహాను జోక బాప్తిసుమ్ దిలొ. ");
INSERT INTO key_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","యేసు ఈంజ బాప్తిసుమ్ నఙన్లి బేగి, గడ్డె తెంతొ బార్ జతికయ్, ఆదె, పరలోకుమ్ ఉగ్డి జలి, చి దేముడుచి సుద్ది తిలి ఆత్మ పార్వ పిట్టచి రితి జా ఉత్ర జా కెర, యేసుచి ఉప్పిరి వెసిలిస్ జో దెకిలొ. ");
INSERT INTO key_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","“ఈందె, ఈంజొయి అంచొ ప్రేమ తిలొ పూత్తు. ఇనాచి రిసొ అంక సర్దసంతోసుమ్” మెన, ఇసి పరలోకుమ్ తెంతొ సంగిలిస్‍చి అవాడ్ అయ్‍లి. ");
INSERT INTO key_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","తెదొడి సయ్‍తాన్‍చి అత్తి జోచి పరిచ్చ కెరవనుక దేముడుచి సుద్ది తిలి ఆత్మ, జోక కో నెంజిలి డొంగ్రె కడ నిలన్. ");
INSERT INTO key_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","జలె, దొన్ని విస్సొ పొదులు, దొన్ని విస్సొ అందర్లు యేసు చువ్వె తతికయ్, జోక చూ కెర్తికయ్, ");
INSERT INTO key_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","పాపుమ్ కెరవుక ఉచర సయ్‍తాన్ జోతె జా కెర, “తుయి దేముడుచొ పుత్తుసి జలె, ఈంజేఁవ్ పత్రల్ పోడియొ జతి రితి సంగు” మెలన్. ");
INSERT INTO key_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","తెదొడి యేసు, “‘ఎక్కి పోడియొ తెన్ నాయ్, గని దేముడుచి చోండి తెంతొ జెతి ఎత్కి కోడు తెన్ మాన్సుల్ జింక అస్సె’ మెన దేముడుచి కోడుతె రెగ్డ అస్సె” మెలన్. ");
INSERT INTO key_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","తెదొడి సయ్‍తాన్ యేసుక దేముడుచి గుడి తిలి యెరూసలేమ్ పట్నుమ్‍తె కడ నా కెర, జా దేముడుచి గుడితెచి వెన్గొపుచి ఉప్పిరి జోక టీఁవొ కెర, ");
INSERT INTO key_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“తుయి దేముడుచొ పుత్తుసి జలె, ఎట్టొతొ డేఁవు. ‘తుక ప్రమాదుమ్ నే జతి రితి, జోచ దూతల్‍క దేముడు ఆడ్ర దా తెద్రయెదె’, ‘తుచ చట్టొ పత్రె నే లయితి రితి, జేఁవ్ దూతల్ జోవయించ అత్తొ చంపొ కెర, తుక ఉక్కులనుల,’ మెన దేముడుచి కోడుతె రెగ్డ అస్సె” మెన యేసుక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","సయ్‍తాన్ దస్సి సంగితికయ్, యేసు జోక “‘ప్రబు జలొ తుమ్‍చొ దేముడుక పరిచ్చ కెరుక నాయ్’ మెన అన్నెక్ టాన్‍తె రెగ్డ అస్సె” మెన సయ్‍తాన్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","పడ్తొ అన్నె, ఒగ్గర్ డోంక్ తిలి ఏక్ డొంగుర్ ఉప్పిరి సయ్‍తాన్ యేసుక కడ నా కెర, ఈంజ లోకుమ్‍చ రాజిమ్‍లు ఎత్కి, జేఁవ్‍చి విలువ ఎత్కి జోక దెకవ కెర, ");
INSERT INTO key_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“తుయి సెర్ను సేడ అంక జొకర్లెగిన, ఈంజ ఎత్కి తుక దెయిందె” మెన యేసుక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","యేసు జోక, “సయ్‍తాన్, తుయి ఉట్ట గో. కిచ్చొక మెలె, ‘ప్రబు జలొ తుమ్‍చొ దేముడుకయ్ జొకర, జో ఎక్కిలొచి సేవ తుమ్ కెరుక అస్సె’ మెన రెగ్డ అస్సె.” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","తెదొడి సయ్‍తాన్ జోక ముల దా ఉట్ట గెలన్, చి ఈందె దేముడుచ దూతల్ జా కెర, యేసుక సావ్రెచన కెర, సుక్కుమ్ కెర్ల. ");
INSERT INTO key_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ఒత్త తెంతొ ‘బాప్తిసుమ్ దెతొ యోహానుక జేలి కెర జేల్‍తె గల అస్తి’ మెన యేసు సూన కెర, ఉత్తర పక్క గలిలయ ప్రాంతుమ్‍తె బుల ఉట్ట గెచ్చ కెర, ");
INSERT INTO key_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ఒత్తచి నజరేతు మెలి జో వడ్డిలి గాఁవ్ తెంతొ ముల దా కెర, జెబులూను చి నప్తాలి మెల పూర్గుల్‌చ నవ్వొ దిలి ప్రాంతుమ్‍తెచి సముద్రుమ్‍చి పాసిచి కపెర్నహూమ్ మెంతి పట్నుమ్‍తె ఉట్ట జా జితె తిలస్. ");
INSERT INTO key_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","దేముడుచ కబుర్లు సంగిలొ యెసయా పూర్గుమ్‍చొచి అత్తి జో సంగిలి కోడు ఇసి నెరవెర్సుప జలి. ");
INSERT INTO key_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“జెబులూను ప్రదేసిమి, నప్తాలి ప్రదేసిమి, యోర్దాను గాడు ఒత్తల్‍తొ తిలి వెల్లి సముద్రుమ్‍చి పక్క, పూర్గుమ్ యూదుల్ నెంజిలస జితె తిలి గలిలయ ప్రాంతుమ్‍తె తిల ప్రెజల్ ");
INSERT INTO key_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","అగ్గె అందర్‍బుద్ది తెన్ తిలె కి, అప్పె వెల్లి ఉజిడి దెక అస్తి. జేఁవ్ పాపుమ్ తెన్ మొర గెల రిత జా తిలె కి, జోవయింక రాత్ పాయిలి రితి జా, పరలోకుమ్‍చి ఉజిడి జోవయింక డీస అస్సె” మెన సంగిలి కోడు. ");
INSERT INTO key_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","జా దీసి తెంతొ, జా ప్రాంతుమ్‍చ ప్రెజల్‍క యేసు బోదన కెర్లిసి కిచ్చొ మెలె, “పరలోకుమ్‍చి రాజిమ్ ఇన్నె పాఁవ జా అస్సె. జాచి రిసొ, తుమ్‍చ పాపల్‍చి రిసొ దుకుమ్ జా, పాపుమ్‍బుద్ది ముల దాస” మెన బోదన కెర్తె తిలొ. ");
INSERT INTO key_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","యేసు జా గలిలయ సముద్రుమ్‍చి గట్టుతె ఇండితె తా, ‘పేతురు’ మెన ఆసిమ్ నావ్ తిలొ సీమోను, చి జోచొ అంద్రెయ మెలొ బావొసి దొగులక దెకిలన్. జేఁవ్ దొగుల సముద్రుమ్‍తె వల గల్తె తిల. జేఁవ్ జాలర్లు. ");
INSERT INTO key_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","జలె, జోవయింక దెక కెర, “జలె, తుమ్ అంచి పట్టి జా, చి మాన్సుల్ అంక నంపజతి రిసొ తుమ్ జోవయింక అంచితె కడ ఆన్‍త జాలర్లు జతి రితి, తుమ్‍క ఆఁవ్ కెరిందె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ఇసి సంగ బుకార్లి బేగి, జేఁవ్ జోవయించ వలల్ ముల దా కెర, జోచి పట్టి గెచ్చ, జో తెన్ బులుక దెర్ల. ");
INSERT INTO key_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ఒత్త తెంతొ ఇదిల్ దూరి గెచ్చ, యాకోబుచి యోహాను మెల అన్నె దొగుల అన్నొబావొక యేసు దెక జేఁవ్‍క బుకార్లన్. జేఁవ్ దొగుల జెబెదయి మెలొ అబ్బొసి తెన్ జోవయించి దోనితె వెస తా, జోవయించ వలల్ చెంగిల్ కెర్తె తిల. ");
INSERT INTO key_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","యేసు బుకార్లి బేగి, జోవయించొ అబ్బొస్‍క చి దోనిక ముల దా కెర, జోచ సిస్సుల్ జతి రితి జోచి పట్టి గెల. ");
INSERT INTO key_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","యేసు జా ఒండి గలిలయ ప్రాంతుమ్‍తె బుల బుల, యూదుల్‍చ ఒత్తచ సబ గెరలె గెచ్చ గెచ్చ, “పరలోకుమ్‍చి రాజిమ్ ఇత్తల్ పాఁవ జా అస్సె” మెన సుబుమ్ కబుర్ సంగ, ప్రెజల్‍క, కిచ్చొ జబ్బు తిలె కి, జబ్బులు బాదల్ ఎత్కి గెచ్చయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ఒండి సిరియ దేసిమ్‍చ ఎత్కిజిన్ జోచి రిసొ సూన్ల, చి రగరగాల్‍చ జబ్బుల్ తిలసక, జొర్జొల్ నొప్పుల్ తిలసక, బూతల్ దెర్లసక, మోర్చల్‍క, చి అత్తొ చట్టొ కదుల్ కెరుక నెతిర్లసక, ఇసచ ఎత్కిక యేసుతె కడ ఆన్‍తికయ్, జోవయింక చెంగిల్ కెర్లన్. ");
INSERT INTO key_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ఈంజ ఎత్కిచి రిసొ, గలిలయ ప్రాంతుమ్ తెంతొ, దెకపొలి ప్రాంతుమ్ తెంతొ, యెరూసలేమ్ పట్నుమ్ తెంతొ, యూదయ ప్రదేసిమ్ తెంతొ, పడ్తొక యోర్దాను గాడు ఒత్తల్‍తొ తెంతొ, ఒగ్గర్‍జిన్ మాన్సుల్ జట్లు తెన్ జోచి పట్టి గెల. ");
INSERT INTO key_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","యేసు జేఁవ్ ఒగ్గర్‍జిన్ పట్టి అయ్‍లసక దెక కెర, ఏక్ మెట్టయ్ వెగ వెసితికయ్, జోచ సిస్సుల్ జోతె జెతికయ్ ");
INSERT INTO key_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","జో చోండి పుటవ జేఁవ్ ఎత్కిజిన్‍క బోదన కెరుక దెర్లన్. ");
INSERT INTO key_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“అమ్ ఆత్మతె ఎద్గరె తొక్కిచ సుదల్ మెన కో చిననుల గే, జోవయింక చెంగిలి. కిచ్చొక మెలె, దస మాన్సుల్‍కయ్ పరలోకుమ్‍చి రాజిమ్‍తె వాట తయెదె. ");
INSERT INTO key_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“దుకుమ్ సేడ్తసక చెంగిలి, కిచ్చొక మెలె, దేముడు జోవయింక బురియవెదె. ");
INSERT INTO key_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“సొంత గవురుమ్ నే ఉచరంతసక చెంగిలి. కిచ్చొక మెలె, జేఁవ్ ఈంజ బూలోకుమ్‍తె ఏలుప కెరుల. ");
INSERT INTO key_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“చూ తాన్ గెతె ఎదక మాన్సుల్ కీసి అన్నిమ్‍క పితిస్‍క ఆస జవుల గే, దస్సి, పున్నిమ్ ఇండుక కో ఎక్కి ఆస జవుల గే, జోవయింక చెంగిలి. కిచ్చొక మెలె, దేముడు జోవయింక పున్నిమ్ దా సర్దసంతోసుమ్ కెరెదె. ");
INSERT INTO key_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“మాన్సుల్‍క కన్కారుమ్ దెకితసక చెంగిలి. కిచ్చొక మెలె, దేముడు జోవయింక కన్కారుమ్ దెకెదె. ");
INSERT INTO key_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“పెట్టి సుద్ది తతసక చెంగిలి. కిచ్చొక మెలె, జేఁవ్ దేముడుక దెకుల. ");
INSERT INTO key_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“కోపుమ్ జలసక కో సేంతుమ్ కెర్తస జవుల గే, జోవయింక చెంగిలి. కిచ్చొక మెలె, దేముడుచ పుత్తర్సులు, మెన జోవయింక సంగుక జయెదె.” ");
INSERT INTO key_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“సత్తిమ్ ఇండితి రిసొ కో అన్నె మాన్సుల్‍చి అత్తి అల్లర్‍లు సిచ్చలు సేడుల గే, జోవయింక చెంగిలి. కిచ్చొక మెలె, దస మాన్సుల్‍కయ్ పరలోకుమ్‍చి రాజిమ్‍తె వాట తయెదె.” ");
INSERT INTO key_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“తుమ్ అంచ మాన్సుల్ జలి రిసొ తుమ్‍క మాన్సుల్ ఆరిక దూసుప కెర్లెగిన, అల్లర్ కెర్లెగిన, ఎత్కి రగల్ అబద్దుమ్ సంగిలెగిన, తుమ్‍క చెంగిలి. ");
INSERT INTO key_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","జేఁవ్ దస్సి కెర్లె కి, సర్దసంతోసుమ్ తెన్ తా. కిచ్చొక మెలె, పరలోకుమ్‍తె తుమ్‍క వెల్లి బవుమానుమ్ దొర్కు జయెదె. పూర్గుమ్ కి, దేముడుచ కబుర్లు సంగిల మాన్సుల్ కి జేఁవ్ దస అల్లర్ కెర్ల.” ");
INSERT INTO key_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“తుమ్ ఈంజ లోకుమ్‍క లోన్‍చి రితి జస్తె. గని జాగర్త తెన్ తా, లోన్‍చి కారు గెలెగిన, జా లోన్ కీసి అన్నె కారు జయెదె? అన్నె కిచ్చొక కి కామ్‍క నే జయె. ఎత్కి వెంట గెలుక జయెదె. దస్సి వెంట గెలెగిన, మాన్సుల్ సుఁదుక జయెదె.” ");
INSERT INTO key_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“తుమ్ ఈంజ లోకుమ్‍క ఉజిడి జా అస్సుస్. ఏక్ పట్నుమ్ మెట్టచి ఉప్పిరి తిలెగిన, జా పట్నుమ్‍క లుంకడుక నెంజె. ");
INSERT INTO key_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","దస్సి, మాన్సుల్ దీవు లంబడ తిలెగిన, జా దీవుక నాడి గట్ర డంకితి నాయ్, గని దీవు కంబుమ్‍తె టీఁవుల, చి జా గెరి తిలస ఎత్కిక జా ఉజిడి కామ్‍క జెయెదె. ");
INSERT INTO key_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","తుమ్‍చి తెన్ కి దస్సి తంక అస్సె. తుమ్ చెంగిల్ బుద్ది ఇండితిసి మాన్సుల్ దెక, పరలోకుమ్ తిలొ అబ్బొది జలొ దేముడుక గవురుమ్ దెతు మెన, తుమ్‍చి పెట్టి తిలి ఉజిడి మాన్సుల్‍చి ముక్మె లగితి రితి తుమ్ ఇండ.” ");
INSERT INTO key_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“మోసే పూర్గుమ్‍చొచి అత్తి దేముడు రెగ్డయ్‍ల ఆగ్నల్ జలెకు, పూర్గుల్‍చి అత్తి సంగిల దేముడుచ కబుర్లు జలెకు, పెట గెలుక ఆఁవ్ అయ్‍లయ్ మెన తుమ్ ఉచర నాయ్. జా ఎత్కి నెరవెర్సుప కెరుకయ్ ఆఁవ్ అయ్‍లయ్, గని పెట గెలుక మెన తుమ్ ఉచర నాయ్. ");
INSERT INTO key_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","కిచ్చొక మెలె, తుమ్‍క ఆఁవ్ కిచ్చొ కచితుమ్ సంగితసి మెలె, ఆగాసుమ్ బుఁయి పాడ్ జా గెతె ఎదక, మోసే పూర్గుమ్‍చొచి అత్తి రెగిడ్లిసి దేముడుచ ఆగ్నల్‍చి కొడొ పూర్తి నెరవెర్సుప జతె ఎదక, జేఁవ్‍తె ఎక్కి కోడు కి ఎక్కి కామ కి పిట్టె నాయ్. ");
INSERT INTO key_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","జాచి రిసొ, ఈంజ ఆగ్నల్ రితి కెర్తిస్‍క కో విలువ దెకితి నాయ్ గే, చి విలువ నే దెకితి రితి అన్నె మాన్సుల్‍క సికడుల గే, పరలోకుమ్‍చి రాజిమ్‍తె జో దాకు జవుల. గని కో జేఁవ్ కొడొ రితి నిదానుమ్ కెర, దస్సి నిదానుమ్ కెరుక అన్నె మాన్సుల్‍క సికడుల గే, జెఁవ్వి పరలోకుమ్‍చి రాజిమ్‍తె గవురుమ్ జవుల. ");
INSERT INTO key_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","తుమ్‍క ఆఁవ్ కిచ్చొ మెంతసి మెలె, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస చి పరిసయ్యుల్, కెర్తి కంట తుమ్ పున్నిమ్ ఇండిలెకయ్ నెంజిలె, తుమ్ కచితుమ్ పరలోకుమ్‍చి రాజిమ్‍తె బెదుస్ నాయ్.” ");
INSERT INTO key_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","‘నరు అత్య కెర నాయ్. నరు అత్య కో కెర్లె, సిచ్చ జంక అస్సె’ మెన పూర్గుమ్‍చక సంగిలిసి తుమ్ సూన్‍తసు. ");
INSERT INTO key_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ఆఁవ్, జలె, తుమ్‍క అన్నె కిచ్చొ సంగితసి మెలె, కక్క జలెకు కో జలెకు కోపుమ్ జలె, జో కోపుమ్ జలొ సిచ్చ జతి తప్పు కెర అస్సె, కో జలెకు అన్నెక్లొక నిస్కారుమ్ సంగిలె, వెల్లి సబచి అత్తిచి సిచ్చ జతి తప్పు కెర అస్సె. కో జలెకు అన్నెక్లొక ‘తుయి గడ్సు’ మెలి ఎదిలి కోడు సంగిలె, వెల్లి ఆగిచి గొయిచి సిచ్చ జతి తప్పు కెర అస్సె. ");
INSERT INTO key_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","జలె, తుమ్‍చితె కో గే కిచ్చొగె అర్పితుమ్ దెంక మొదొల్ కెర తిలె జవుస్, ఈంజొ మాన్సు కిచ్చొగె కెర్లిస్‍చి రిసొ అన్నెక్లొ ఇనాచి ఉప్పిరి కోపుమ్ తెన్ అస్సె మెన ఈంజొ ఏదస్ట కెర్లెగిన, ");
INSERT INTO key_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ఈంజొ అర్పితుమ్ దెతిసి బలి దెతి టాన్‍తె నే దెతె, పాసి ముల దా కెర, తొలితొ గెచ్చ, జో అన్నెక్లొ తెన్ సేంతుమ్ కెరన, అన్నె జా కెర, ఇన్నెచి అర్పితుమ్ ఈంజొ దెవుసు. ");
INSERT INTO key_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“తుమ్‍చితె ఎక్కిలొక కో గే నేరిమ్ వయడ తిలెగిన, తుమ్ బెద గెతె తా తీర్పు కెర్తి గెరి నే పాఁవితె అగ్గె, జో నేరిమ్ వయడ్తొ మాన్సు తెన్, నేరిమ్ జలొసొ బేగి సేంతుమ్ జంక అస్సె. నెంజిలె నేరిమ్ వయడ్తొసొ తుమ్‍క తీర్పు కెర్తొసొతె సొర్ప కెర్లె, జో తీర్పు కెర్తొసొ తుమ్‍క జమాన్లుచి అత్తి సొర్ప కెర్లె, జో జమాన్లు తుమ్‍క జేల్‍తె గల దెయెదె. ");
INSERT INTO key_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","దస్సి, తుమ్‍క ఆఁవ్ కిచ్చొ కచితుమ్ సంగితసి మెలె, తుమ్‍చితె కో సిచ్చ జవుల గే, ఆకర్‍చి కాసు ఎద కి పూర్తి తీర్సుప కెర్తె ఎదక, తుమ్‍క ములుక నెంజె.” ");
INSERT INTO key_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“పడ్తొ ‘తుమ్ లంజెకమొ కెర నాయ్’ మెన సంగిలి కోడు తుమ్ అగ్గె తెంతొ సూన అస్సుస్. ");
INSERT INTO key_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","గని ఆఁవ్ తుమ్‍క సంగితిసి కిచ్చొ మెలె, ఏక్ తేర్‍బోదక దస్సి దెకుక కి కో దెకెదె గే, ఎక్కి దెకిలి రిసొ, జోచి మెన్సుతె జా తెన్ లంజె కెర అస్సె.” ");
INSERT INTO key_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“జలె, తుమ్‍చితె కచి గే ఉజిల్ అంకి జవుస్ జోక పాపుమ్ కెరవ తిలెగిన, పాపుమ్ నే కెర్తి రిసొ, జో జా అంకి కడ వెంట గెలి రితి జవుస్. జోవయించ ఆఁగ్‍తె తత్తస ఎత్కి తెన్ ఒండొయి మాన్సు వెల్లి ఆగి గొయ్‍తె గలి జతి కంట, జోచి ఆఁగ్‍తె తత్తసతె ఎక్కి జవుస్ పిట్ట గెలి రితి జలె, జోక చెంగిలి. ");
INSERT INTO key_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","దస్సి, తుమ్‍చితె ఎక్కిలొచొ ఉజిల్ ఆతు జవుస్ జోక పాపుమ్ కెరవ తిలెగిన, జా దీసి తెంతొ అన్నె దస్సి పాపుమ్ నే కెర్తి రిసొ, జో ఆతు కండ గెలి రితి జా, జోచి తెంతొ వెంట గెలి రితి జవుస్. కిచ్చొక మెలె, జోచ ఆఁగ్‍తె తిల వాటల్ ఎత్కి తెన్ ఒండొయి మాన్సు వెల్లి ఆగి గొయ్‍తె గలి జతి కంట, జోచ ఆఁగ్‍తె తత్తస ఎక్కి ఆతు పిట్ట గెలి రితి జలె, జోక చెంగిలి.” ");
INSERT INTO key_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","‘కో జలెకు జోచి తేర్సిక ముల దెయెదె గే, జో జాక ముల దెంక మెన ఏక్ కాగ్తుమ్ రెగ్డ దెంక అస్సె’ మెన పూర్గుమ్ తెంతొ సంగిలి కోడు అస్సె. ");
INSERT INTO key_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","గని ఆఁవ్ తుమ్‍క కిచ్చొ మెన సంగితిసి మెలె, జా తేర్సి లంజె జలిస్‍క పిట్టవ, కో జలెకు తేర్సిక ముల దెయెదె గే, జొయ్యి జాక లంజె కెర్తయ్. అన్నె, మున్సుస్ ముల దిలి తేర్‍బోదక పెండ్లి జతొసొ కో జలెకు, లంజె జతయ్. ");
INSERT INTO key_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“అన్నె, ‘ఆరిక అప్పుడుక నాయ్, గని కిచ్చొ జవుస్ కెర్తి రిసొ కో గే ప్రమానుమ్ తిలెగిన, ప్రబుక సత్తిమ్ కెర్తి రిసొ జో మాన్సు జో సంగిలిసి జర్గు కెరుక అస్సె’ మెన పూర్గుల్‍క సంగిలి కోడు తుమ్ సూన అస్సుస్. ");
INSERT INTO key_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","గని ఆఁవ్ తుమ్‍క సంగితిసి కిచ్చొ మెలె, ఎద్గరె ఒట్టు గలన్‍క నాయ్. ‘పరలోకుమ్ సాచి’ మెన జవుస్ ఒట్టు గల నాయ్. కిచ్చొక మెలె, జా ఎత్కి అదికారుమ్ తిలొ దేముడుచి సిజాసనుమ్. ");
INSERT INTO key_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","‘బుఁయ్‍చి సాచి’ మెన జవుస్, ఒట్టు గలన్‍క నాయ్. కిచ్చొక మెలె, జా దేముడు సుఁదితి పొద్రొ. అన్నె, ‘యెరూసలేమ్ పట్నుమ్ సాచి’ మెన జవుస్, ఒట్టు గలన్‍క నాయ్. కిచ్చొక మెలె, జా పరలోకుమ్‍చొ రానొ జలొ దేముడుచి గుడిక నిసాన్ల పట్నుమ్. ");
INSERT INTO key_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","అన్నె, ‘బోడిచి ఒటు జవుస్’ మెననుక నాయ్. కిచ్చొక మెలె, ఎక్కి సెండి వాడొ కి నీడి జతి రితి జలెకు, చొక్కిల్ జతి రితి జలెకు మార్సుప కెరుక తూమ్ నెతుర్సు. ");
INSERT INTO key_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","జలె, తుమ్ ‘ఎఁ ఎఁ’ మెనుక అస్సె మెలెగిన, ‘ఎఁ ఎఁ’ మెన. తుమ్ ‘నాయ్’ మెనుక అస్సె మెలెగిన, ఎక్కి ‘నాయ్’ మెన. ఇన్నెక జీన్‍తిస్ సయ్‍తాన్ తెంతొయ్ జతయి.” ");
INSERT INTO key_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","‘ఏక్ మాన్సుచి అంకి జవుస్ అన్నెక్లొ కోపుమ్‌క కడ్లెగిన, జో కడ్లొసొచి అంకి కి జో అంకి గెలొ మాన్సు గెచ్చ కడుక అస్సె. అన్నె, ఏక్ మాన్సుచొ దాంతు అన్నెక్లొ పెట బగయ్‍లెగిన, ఈంజొ కి జోచి దాంతు పెట బగవ గెలుక అస్సె’ మెన పూర్గుమ్ సంగిలి కోడు తుమ్ సూన అస్సుస్. ");
INSERT INTO key_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","జలె, ఆఁవ్ తుమ్‍క కిచ్చొ సంగితిసి మెలె, తుమ్‍క అల్లర్ కెర్లొసొక తుమ్ అల్లర్ కెర్క నాయ్. మూర్కుడు జవుస్ తుమ్‍చితె ఎక్కిలొక ఉజిల్ గలి జవుస్ పెట్లెగిన, దెబ్బ కయ్‍లొసొ తుక్లె తా, జోచి డెబ్రి గలి కి జో అన్నెక్లొ అన్నె పెటితి రితి, జోచి పక్క పస్లవుక అస్సె. ");
INSERT INTO key_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","“అన్నె దస్సి, తుమ్‍చితె ఎక్కిలొక కో జలెకు తీర్పు కెర్తి గేర్‍తె కడన, ఇనెతె సొక్క నఙిలె, ఈంజొ ఇనాచి కోటు కి దా గెల్సు. ");
INSERT INTO key_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","కో జలెకు తుమ్‍చితె ఎక్కిలొక ‘ఏక్ మయిలు దూరి బెద జె’ మెన బలవంతుమ్ కెర్లెగిన, జో తెన్ ఈంజొ దొన్ని మయిలు దూరి బెద గెస్సు. ");
INSERT INTO key_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","కో జలెకు తుమ్‍చితె ఎక్కిలొతె కిచ్చొ జవుస్ నఙిలె, దెంక. అన్నె, కో జలెకు తుమ్‍చితె ఎక్కిలొతె బదుల్ నఙిలె, తుక నే దెయింద్ మెనుక నాయ్, దెంకయి.” ");
INSERT INTO key_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“అన్నె, ‘తుమ్‍చి తెన్ బెదితసక ప్రేమ కెర’ మెన, ‘తుమ్‍క విరోదుమ్ జలసచి ఉప్పిరి విరోదుమ్ తెన్ తా’ మెన సంగిలిసి సూన అస్సుస్. ");
INSERT INTO key_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","గని ఆఁవ్ తుమ్‍క సంగితిసి కిచ్చొ మెలె, తుమ్‍క విరోదుమ్ జలసక ప్రేమ కెర. తుమ్‍క అల్లర్ కెర్తసచి రిసొ ‘చెంగిల్ జతు’ మెన ప్రార్దన కెర్తె తా. ");
INSERT INTO key_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","తుమ్ ఇసి కెర్లెగిన, తుమ్‍చొ పరలోకుమ్‍తె తిలొ దేముడు జలొ అబ్బొస్‍చ పుత్తర్లు జలదు మెన డీసెదె. కిచ్చొక మెలె, గార్ సుదల్‍క కి చెంగిల్ సుదల్‍క కి రోజుక జో పొద్దు బార్ కెర్తయ్. సత్తిమ్ ఇండితసచి రిసొ కి, పాపుమ్ ఇండితసచి రిసొ కి పాని పెటయ్‍తయ్. ");
INSERT INTO key_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ఎక్కి తుమ్‍క ప్రేమ కెర్తసకయ్ తుమ్ ప్రేమ కెర్లెగిన, తుమ్‍క కిచ్చొ పున్నిమ్ జా? సిస్తు నఙితస కి దస్సి కెరుల. ");
INSERT INTO key_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ఎక్కి తుమ్‍చ సొంత మాన్సుల్‍క ముద్దు కెర్లె, గని వేర మాన్సుల్‍క నాయ్ మెలె, మాములుమ్ మాన్సుల్ కెర్తిసిచి కంట జా కిచ్చొ జీన్లిసి! దేముడుక నేన్ల మాన్సులి దస్సి కెరుల. ");
INSERT INTO key_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","తుమ్, జలె, సూన. పరలోకుమ్ తిలొ అబ్బొసి జలొ దేముడు కీసి ప్రేమక పూర్తి అస్సె గే, తుమ్ కి దస్సి ప్రేమక పూర్తి జా తంక అస్సె.” ");
INSERT INTO key_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“మాన్సుల్‍చి మొక్మె గవురుమ్ ఆనన్‍తి రితి తుమ్‍చ నీతికమొ కెర నాయ్. మాన్సుల్‍చి గవురుమ్ ఆనన్‍తి రిసొ కెర తిలెగిన, తుమ్‍చొ పరలోకుమ్ తిలొ దేముడు జలొ అబ్బొద్‍తె బవుమానుమ్ తుమ్‍క దొర్కు జయె నాయ్. ");
INSERT INTO key_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","జాచి రిసొ, తుమ్ దర్ముమ్ దెంక జలె, నప్పిర్ బజయ్‍లి రితి జా మాన్సుల్‍చి మొక్మె గవురుమ్ జతి రిసొ దాస నాయ్. కిచ్చొక మెలె, మాన్సుల్ గవురుమ్ దెతి రిసొ ఉప్రమెన్సుచొ మాన్సుల్ సబ గెరలె జవుస్, వీదులె జవుస్, దస్సి, ఎత్కిజిన్ దెకితి రితి, నప్పిర్ బజవ కెర దెతతి. దస్సి గవురుమ్ ఆనన్‍తసచి రిసొ ఆఁవ్ తుమ్‍క కిచ్చొ కచితుమ్ సంగితసి మెలె, జేఁవ్ ఈంజయి లోకుమ్‍తె జోవయించి బవుమానుమ్ నఙన గెల అస్తి.” ");
INSERT INTO key_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","“తుమ్, జలె, దర్ముమ్ దెతె పొది, తుమ్‍చి దర్ముమ్ గుట్టు తెన్ తతి రితి, తుమ్‍చొ ఉజిల్ ఆతు తెన్ దర్ముమ్ దిలె, తుమ్‍చొ డెబ్రొ ఆతుక నేన్‍తె నే జాన్‍తి రితి దాస. ");
INSERT INTO key_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","దస్సి తుమ్ దిలదు మెలె, అన్నె కోయి నేన్లె కి, తుమ్‍చొ దేముడు అబ్బొసి దెక, తుమ్‍క బవుమానుమ్ దెయెదె.” ");
INSERT INTO key_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“పడ్తొ, తుమ్ ప్రార్దన కెర్తి పొది, ఉప్రమెన్సుచొ మాన్సుల్‍చ రిత జా నాయ్. దస మాన్సుల్ సొంత గవురుమ్ ఆనన్‍తి రితి, మాన్సుల్ దెకుత్ మెన, సబ గెరలె, వీదులె టీఁవొ జా ప్రార్దన కెరుక ఓజ జా అస్తి. తుమ్‍క కచితుమ్ కిచ్చొ సంగితసి మెలె, జేఁవ్ జోవయించి బవుమానుమ్ నఙన గెల అస్తి. ");
INSERT INTO key_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","దస్సి తుమ్ ప్రార్దన కెరుక జలె, మాన్సుల్ నే దెకితి రితి, గని తుమ్‍చి గదితె పెస, కెవ్డి డంకన, నే డీసయ్ జతొ తుమ్‍చొ దేముడు అబ్బొస్‍క ప్రార్దన కెర. మాన్సుల్ నే దెకితిసి కి జో అబ్బొసి జలొ దేముడు దెకితయ్, తుమ్ ప్రార్దన కెర్తిసి జో జానన, తుమ్‍క బవుమానుమ్ దెయెదె. ");
INSERT INTO key_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","పడ్తొ, తుమ్ ప్రార్దన కెర్తె పొది, దేముడుక నేన్ల మాన్సుల్ కెర్తి రితి పోన. మెలె, కామ్‍క నెంజిత కొడొచి ఉప్పిరి కొడొ లట్టబా నాయ్. కిచ్చొక మెలె, దేముడుక నేన్ల మాన్సుల్ కిచ్చొ ఉచర్తతి మెలె, ‘ఒగ్గర్ ఒగ్గర్ కొడొ సంగిలె దేముడు అమ్‍చ ప్రార్దనల్ మెన్సెదె’ మెన ఆరిక ఉచర్తతి. ");
INSERT INTO key_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","తూమ్ జోవయించి రితి జా నాయ్. తుమ్ దేముడు అబ్బొస్‍తె నే నఙితె అగ్గె, తుమ్‍క కిచ్చొ కామ్‍క జెయెదె గే జో జానె.” ");
INSERT INTO key_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“జాకయ్, తుమ్ ఇసి ప్రార్దన కెర. ఓ పరలోకుమ్ తిలొ అమ్‍చొ దేముడు జలొ అబ్బొ, తుచి నావ్ గవురుమ్ జవుస్. ");
INSERT INTO key_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","తుచి రాజిమ్ అమ్‍చి తెన్ జెవుసు. తుచి ఇస్టుమ్ రితి పరలోకుమ్‍తె కీసి కెర్తతి గే, ఈంజ లోకుమ్‍తె కి ఆమ్ కెరుక మెన, అమ్‍క దయ కెర సికడు. ");
INSERT INTO key_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","అమ్‍క సరిపుచుప జతి అన్నిమ్ అమ్‍క రోజుక దె. ");
INSERT INTO key_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","పడ్తొ, అమ్‍క తప్పు కెర్ల మాన్సుల్‍క ఆమ్ కెద్ది చెమించుప కెర అస్సుమ్ గే, ఆమ్ కెర్ల తప్పుల్ తుయి అమ్‍క చెమించుప కెరు. ");
INSERT INTO key_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","పడ్తొ, అమ్ పాపుమ్ నే కెర్తి రితి, సయ్‍తాన్ కెరయ్‍తిసి తెంతొ అమ్‍క పిట్టవు, అన్నె, సయ్‍తాన్ కెర్త అల్లర్ తెంతొ కి అమ్‍క పిట్టవు.” ");
INSERT INTO key_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“కిచ్చొక మెలె, కో కో తుమ్‍క తప్పు కెర తిలెగిన, తుమ్ జోవయింక చెమించుప కెర్లెగిన, తుమ్‍చొ పరలోకుమ్ తిలొ దేముడు జలొ అబ్బొ తుమ్‍క చెమించుప కెరెదె. ");
INSERT INTO key_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","గని మాన్సుల్ తుమ్‍క కెర్త తప్పుల్ తుమ్ నే చెమించుప కెర్లెగిన, తుమ్‍చొ అబ్బొ జలొ దేముడు తుమ్‍క చెమించుప కెరె నాయ్.” ");
INSERT INTO key_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“పడ్తొక, తుమ్ చువ్వె తంక జలె, ఏడ్లి రితి మొకొమ్ తెన్ తా నాయ్. ఉప్రమెన్సుచొ మాన్సుల్, జలె, ‘చువ్వె అస్సుమ్’ మెన, ‘అమ్‍క నీతి మెన మాన్సుల్ గవురుమ్ సంగుతు’ మెన, మొకొమ్ వెట్కారుమ్ తెయార్ కెరన తవుల. తుమ్‍క ఆఁవ్ కిచ్చొ కచితుమ్ సంగితసి మెలె, దస్సి కెర్త మాన్సుల్ జోవయించి బవుమానుమ్ నఙన గెల అస్తి. ");
INSERT INTO key_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","తుమ్, జలె, తుమ్ చువ్వె తతె పొది, మాన్సుల్ నేన్లి రితి, తుమ్‍చి బోడి తేలు గాంసన, ఓడన, తుమ్‍చి మొకొమ్ దోవన, సర్ద తెన్ తా. ");
INSERT INTO key_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","మాన్సుల్ నే దెకిలెకి, తుమ్‍చొ అబ్బొసి జలొ దేముడు దెక కెర, తుమ్‍క బవుమానుమ్ దెయెదె. ");
INSERT INTO key_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“బూలోకుమ్‍తెచి దనుమ్ తుమ్‍క తూమ్ కుడవన్‍క నాయ్. ఈంజ లోకుమ్‍చి దనుమ్ కుడవన్‍లెగిన, రుస్సి కా గెలెదె, నెంజిలె కిఁవ్వొ కా గెలెదె, నెంజిలె చోర్లు గెరి బొరొ కెర చోర నెవుల. ");
INSERT INTO key_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","తుమ్, జలె, రుస్సి కిఁవ్వొ నే కతి లోకుమ్‍తె, చోర్లు నే పెసితి లోకుమ్‍తె, మెలె పరలోకుమ్‍తె, ఒత్తచి దనుమ్ కుడవన కెరన. ");
INSERT INTO key_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","తుమ్ కేన్ లోకుమ్‍తె దనుమ్ కుడవన తస్తె గే, ఒత్త తిలిస్‍చి రిసొ తుమ్‍చి పెట్టి ఉచర్తె తస్తె. ");
INSERT INTO key_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“ఆఁగుక దీవు అంకివొ. జాచి రిసొ, తుమ్‍చ అంకివొ టేంట తిలెగిన, తుమ్‍చి ఒండి ఆఁగ్ ఉజిడ్ తెన్ తయెదె. ");
INSERT INTO key_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","తుమ్‍చ అంకివొ మయ్‍ల జా తిలెగిన, తుమ్‍చి ఆఁగ్ ఎత్కి ఆమస్ రితి అందర్ జా తయెదె. దస్సి, తుమ్‍చి పెట్టి తిలి బుద్ది అందర్‍చి తిలెగిన, కెద్ది అందర్ జయెదె! ");
INSERT INTO key_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“ఎక్కిలొ గొత్తి సుదొ కో జలెకు దొగుల ఎజొమాన్లుచి సేవ ఎక్కె దడి కెరుక నెత్రె. ఎక్కిలొక విరోదుమ్ కెర, అన్నెక్లొక ప్రేమ కెరెదె. నెంజిలె ఎక్కిలొక నిదానుమ్ దెక, అన్నెక్లొక నిస్కారుమ్ దెకెదె. జలె, దేముడుక చి ఈంజ లోకుమ్‍చి దనుమ్‍క ఎక్కె దడి సేవ కెరుక నెతుర్సు. ");
INSERT INTO key_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","జాకయ్, ఆఁవ్ తుమ్‍క కిచ్చొ మెంతసి మెలె, ‘కిచ్చొ కమ్‍దె గే కిచ్చొ పిమ్‍దె గే కిచ్చొ గలనుమ్‍దె గే కీసి జా జిమ్‍దె’ మెన, తుమ్‍చి మెన్సుతె చింత గలన నాయ్. అన్నిమ్‍చి కంట ఆత్మ విలువ, గెద. పాలల్‍చి కంట ఆఁగ్ విలువ, గెద. ");
INSERT INTO key_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","“ఆగాసుమ్‍చ పిట్టల్‍చి రిసొ ఉచర. జేఁవ్ పిట్టల్ ఉంపితి నాయ్. ఉంప లాయితి నాయ్. లాయ కొట్టుతె ఆన కుడవంతి నాయ్. జలెకి, తుమ్‍చొ పరలోకుమ్ తిలొ అబ్బొ జలొ దేముడు జోవయింక పోస్తయ్. తుమ్, జలె, జోవయించి కంట విలువ నెంజుసు గే? ");
INSERT INTO key_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","పడ్తొ, తుమ్‍చితె కో కెద్ది చింత గలన్‍లెకి, జోచి బత్కుక కొల్తక ఏక్ అత్తెక్ జవుస్ ఒగ్గర్ కెరనుక తెరె గే? నెత్రె. ");
INSERT INTO key_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“పాలల్‍చి రిసొచి చింత గలనుక కిచ్చొక? డొంగ్రెచ పుల్లొ కీసి వడ్డితతి గే ఉచరన. జేఁవ్ కామ్ కెర్తి నాయ్, పాలల్ వీంతి నాయ్. ");
INSERT INTO key_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","జలెకి, ఎదివాట్ సొమ్సారుమ్ కలుగు జలొ సొలొమోను మెలొ పూర్గుమ్‍చొ రానొ కి ఈంజేఁవ్ పుల్లొచి రితి సూటి కెరనుక నేన్లొ. ");
INSERT INTO key_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","తుమ్ తొక్కి నముకుమ్ తిలస, ఏక్ కోడు ఉచరన. ఆజి తా కెర కలిక డయ దెతి చివ్వర్‍క దేముడు ఎదిలి సూటి కెర్తయ్ జలె, తుమ్‍క అన్నె ఒగ్గర్ చెంగిల్ గలంతిసి దొర్కు కెరె నాయ్ గె? దొర్కు కెరెదె. ");
INSERT INTO key_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“జాకయ్, ‘కిచ్చొ కమ్‍దె గే, కిచ్చొ పిమ్‍దె గే, కిచ్చొ గలనుమ్‍దె’ మెన చింత గలన ఉచర నాయ్. ");
INSERT INTO key_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","దేముడుక నేన్ల మాన్సుల్ కి ఇసిచి ఎత్కిక ఉచరంతె తవుల, అన్నె, ఇస సామన్లు తుమ్‍క కి దొర్కు జతతి మెన; తుమ్‍చొ పరలోకుమ్ తిలొ అబ్బొసి జలొ దేముడు జానె. ");
INSERT INTO key_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","తుమ్, కిచ్చొ కెరుక అస్సె మెలె, తొలితొ దేముడుచి రాజిమ్ జోచి పున్నిమ్ చజ, జో సికడ్తి బుద్ది ఇండుక ఆస జా తా. తుమ్ ఇసి జలదు మెలె, తెదొడి ఎత్కి తుమ్‍క దొర్కు జవుల. ");
INSERT INTO key_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","జాకయ్, ‘కలిక కీసి జా జిమ్‍దె?’ మెన తుమ్ చింత గలన ఉచర నాయ్. కలికచి రిసొ సమ్మందుమ్ జతిసి కలిక దొర్కు జయెదె. కేన్ దీసిచి బాద జయి దీసిక సాలు.” ");
INSERT INTO key_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“తుమ్ ఎక్కిలొక ఎక్కిలొ కుస్సిదుమ్ తెన్ తీర్పు ఉచర నాయ్, చి ఎత్కి అదికారుమ్ తిలొ దేముడు తుమ్‍క తీర్పు కెర సిచ్చ కెరుక నాయ్. ");
INSERT INTO key_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","కిచ్చొక మెలె, తుమ్ అన్నె మాన్సుల్‍క కీసి తీర్పు దెకితె గే, దేముడు తుమ్‍కయ్ కి దస్సి దెకెదె. తుమ్ అన్నె మాన్సుల్‍చి రిసొ కట్టడ్తి కొల్త రితి దేముడు తుమ్‍క కి జయ్యి కొల్త తెన్ కట్టడెదె. ");
INSERT INTO key_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“తుమ్‍చితె ఎక్కిలొచి అంకితె ఏక్ దూలుమ్ బెర తిలెగిన, బావొచి అంకితె ఇదిలిదిల్ తొక్కు సేడ తిలెగిన, అంకితె దూలుమ్ తిలొసొ కిచ్చొక జోచి బావొచి అంకితె తిలి ఇదిలిదిల్ తొక్కు దెకితసి, గని సొంత అంకితెచి దూలుమ్ దెకిస్ నాయ్? ");
INSERT INTO key_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","నెంజిలె, తుచి అంకితెచి తొక్కు కడిందె” మెన చిల్ప అంకితె తిలొసొ కీసి తుచొ బావొక సంగుక జయెదె! ");
INSERT INTO key_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","తుయి ఉప్రమెన్సుచొ, తొలితొ తుచి సొంత అంకితెచి చిల్ప కడను, చి తుచొ బావొచి అంకితెచి తొక్కు కడితి రితి టేంట దెకితె. ");
INSERT INTO key_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“సుద్ది తిలిసి సూనర్లుక దాస నాయ్. అండ్రుల్‍చి చట్టె ముత్యల్ గల దాస నాయ్. అండ్రుల్‍క దిలె, విలువ నే దెకితె సుఁద కెర, పస్ల కెర, తుమ్‍క చిర గెలుల. ");
INSERT INTO key_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“నఙ తుమ్‍క దెయెదె. ఎక్కి మెన్సు తెన్ చజిలె, దొర్కు జయెదె. కెవ్డితె పెట్లె, తుమ్‍క కెవ్డి ఉగిడిందె. ");
INSERT INTO key_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","కో సంగిలె, జోక దొర్కు జయెదె, చి చజిలె, దొర్కు జయెదె, చి జోచి కెవ్డితె పెట్లె, జోచి రిసొ ఉగ్డి జయెదె. ");
INSERT INTO key_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“తుమ్‍చి తెన్ కేన్ మాన్సు జలెకు జోచొ పుత్తుసి పోడి నఙిలె, జోక పత్తురు దెయెదె గే? నాయ్. ");
INSERT INTO key_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","జో పుత్తుసి మొస్సొ నఙిలె అయి దెయెదె గె? నాయ్. ");
INSERT INTO key_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","జలె, తుమ్ మాన్సుల్ పాపుమ్ సుదల్ జలెకి, తుమ్‍చ బోదల్‍క చెంగిల్ వస్తువల్ దెంక జాన్సు. జలె, పరలోకుమ్ తిలొ అబ్బొస్ జలొ దేముడుతె కో చెంగిల వరల్ నఙిలె, మాన్సుల్ దెతి కంట జో అన్నె ఒగ్గర్ చెంగిల్ వరల్ దెయెదె! ");
INSERT INTO key_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“మాన్సుల్ తుమ్‍క కీసి కెరుక మెన తుమ్ ఇస్టుమ్ జస్తె గే, తూమ్ కి జోవయింక దస్సి కెర. కిచ్చొక మెలె, మోసే పూర్గుమ్‍చొచి అత్తి దేముడు రెగ్డయ్‍ల ఆగ్నల్, అన్నె పూర్గుల్‍చి అత్తి సంగిల దేముడుచ కబుర్లు ఎత్కితె ఈంజ కోడు బెదితయ్. ");
INSERT INTO key_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“వెల్లొ నాసెనుమ్‍తె గెతి వాట్ సుల్లు, జా వాట్ పెసితి గుమ్ముమ్ రూందు. జా వాట్ ఒగ్గర్‍జిన్ గెతతి. తూమ్, మాత్రుమ్, ఇర్కు వాట్‍చి గుమ్ముమ్ పెస. ");
INSERT INTO key_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","కిచ్చొక మెలె, పరలోకుమ్‍తె బెదితి వాట్‍చి గుమ్ముమ్ ఇర్కు అస్సె, జా వాట్ సుల్లు నాయ్, చి ఒత్త పాఁవితస ఒగ్గర్ తొక్కిజిన్ జవుల. ");
INSERT INTO key_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“దేముడు తెంతొ కబుర్ ఆన్‍తొసొ ఆఁవ్” మెన అబద్దుమ్‍క సంగితస సగుమ్‍జిన్ జెవుల, ఉప్రమెన్సుచ జేఁవ్. దస మాన్సుల్‍చి రిసొ తుమ్ జాగర్త తెన్ తా. చెంగిల్ మాన్సుల్ రితి, జేఁవ్ మెండల్‍చ రోమల్ గలన డీసయ్ జవుల, గని జోవయించి పెట్టి తెడి డుర్కొవ రితి కుస్సిదుమ్ తిలస. ");
INSERT INTO key_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","జోవయించ కమొచి పలితుమ్ దెకిలె, జోవయించి బుద్ది తుమ్ చినితె. కంట చెట్లె ద్రాచ పండ్లు కోడుక జయెదె గె? లస్వన్ రూకి తెన్ అంజూరుమ్ పండ్లు కోడుక జయెదె గె? నెంజె. ");
INSERT INTO key_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ఎత్కి చెంగిలొ రూక్‍తె చెంగిలి పండ్లు దెరుల, గని కామ్‍క నెంజితె రూక్‍తె కామ్‍క నెంజిత పండ్లు దెరుల. ");
INSERT INTO key_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","చెంగిల్ రూక్‍తె కామ్‍క నెంజితి రగుమ్ పండ్లు దెర్తి నాయ్. కామ్‍క నెంజితె రూక్‍తె చెంగిల్ పండ్లు దెర్తి నాయ్, ");
INSERT INTO key_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","అన్నె, చెంగిల పండ్లు నే దెర్తొ ఎత్కి రూకుక కండ కెర, ఆగితె గలుల. ");
INSERT INTO key_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","తుమ్‍చితె జెతసచి పలితుమ్ దెకిలె, జోవయించి రగుమ్ చినితె. ");
INSERT INTO key_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“‘ప్రబు, ప్రబు!’ మెన, అంక సంగితస ఎత్కిజిన్ పరలోకుమ్‍చి రాజిమ్‍తె పెసితి నాయ్. గని పరలోకుమ్ తిలొ అంచొ అబ్బొ జలొ దేముడు సికడ్లి కోడు రితి కెర్తసయ్ ఒత్త గెచ్చుల. ");
INSERT INTO key_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ఈంజ లోకుమ్‍చ ఎత్కిక వెల్లి తీర్పు కెర్తి దీసిక, అంక ఒగ్గర్‍జిన్ మాన్సుల్, ‘ప్రబు, ప్రబు’, తుచి నావ్ తెన్ తూయి సంగిల కబుర్లు సంగిలమ్, నాయ్ గె? తుచి నావ్ తెన్ బూతల్ గట్రక ఉదడ్లమ్, నాయ్ గె? తుచి నావ్ దెర ఒగ్గర్ ఒగ్గర్ అద్బుతుమ్ కమొ కెర్లమ్, నాయ్ గె?” మెన సంగుల. ");
INSERT INTO key_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","జలె “ఆఁవ్, తుమ్‍క అగ్గె తెంతొ నేని. తుమ్ గార్ కమొ కెర్తతస, అంచి తెంతొ దూరి ఉట్ట గెచ్చ” మెన జోవయింక సంగెదె. ");
INSERT INTO key_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“అంచ కొడొ సూన అంచి కోడు రితి ఇండుల గే కీస జవుల, జో బుద్ది తిలొసొ కిచ్చొ కెర్లొ మెలె, జోచొ గేరు రెంగ్నిచి ఉప్పిరి బందిలొ. ");
INSERT INTO key_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","బందితికయ్, పాని పెట్లి, వర్దల్ జలి, చి గట్టిఙ వాదు జో గేరుచి సుట్టునంత కెర్లె కి, జా గేర్‍చి పునాది రెంగ్నిచి ఉప్పిరి తిలి రిసొ, కెద్ది వాదు పాని కెర్లె కి, సేడె నాయ్. ");
INSERT INTO key_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“జలె, కో అంచ కొడొ సూన కి నే కెరుల గే, జేఁవ్ కీసి జవుల మెలె, బుద్ది నెంజిలొ ఎక్కిలొచి రితి జవుల. జో బుద్ది నెంజిలొసొ కిచ్చొ కెర్లొ మెలె, జోచొ గేరు ఇస్కచి ఉప్పిరి బందిలొ. ");
INSERT INTO key_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","జో గేరు ఇస్కచి ఉప్పిరి బంద తతికయ్, పాని పెట్లి, వర్దల్ అయ్‍లి చి గట్టిఙ వాదు జో గేరుచి సుట్టునంత కెర్లి, చి జా గేరు సేడ గెలొ. జా గేరు ఎద్గరె సేడయ్ గెలి!” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","యేసు ఈంజేఁవ్ కొడొ సంగ కేడయ్‍లి పడ్తొ, జనాబ్ ఎత్కి జో కెర్లి బోదనచి రిసొ ఆచారిమ్ జల. ");
INSERT INTO key_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","కిచ్చొక మెలె, జేఁవ్‍చ మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస కెర్తి రితి నాయ్, గని దేముడు దిలి అదికారుమ్ తెన్ జో సొస్టుమ్ బోదన కెర్తె తిలన్. ");
INSERT INTO key_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","జేఁవ్ జా మెట్ట తెంతొ ఉత్ర జెతె తిలె, ఒగ్గర్ ఒగ్గర్‍జిన్ జనాబ్ జోచి పట్టి అయ్‍ల. ");
INSERT INTO key_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","జేఁవ్ ఎత్కిజిన్ దస్సి ఉత్తిర్తె తతికయ్, వెల్లి రోగి ఎక్కిలొ యేసుక దస్సుల్ జా, సెర్ను సేడ జొకర, “ప్రబు తుక ఇస్టుమ్ జలె, తుయి అంక చెంగిల్ కెర సుద్ది కెరుక తెర్సి” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","యేసు ఆతు చంప కెర జోక చడ, “అంక ఇస్టుమి. చెంగిల్ జా సుద్ది జా” మెన సంగిలి బేగి, జోచి వెల్లి జబ్బు గెతికయ్, చెంగిల్ జా సుద్ది జలన్. ");
INSERT INTO key_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","యేసు జోక “వట్టె కక్క కిచ్చొ సంగు నాయ్. గని, దేముడుచి గుడితె గెచ్చ, తుచి ఆఁగ్ సుద్ది జలి మెన, ఒత్త పూజరిక దెకవు, చి తుయి సుద్ది జలిసి ఒత్త తిల మాన్సుల్‍క రుజ్జు జతి రితి, మోసే పూర్గుమ్ సంగిలి కానుక దేసు” మెన సంగ, అన్నె ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","యేసు కపెర్నహూమ్ పట్నుమ్‍తె అన్నె పాఁవితికయ్, రోమ్ దేసిమ్‍చొ పుంజెక్‍జీన్ జమాన్లుక వెల్లొ ఎక్కిలొ జా కెర, ");
INSERT INTO key_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","యేసుక “బాబు, అంచొ గొత్తి నాడు కదుల్ జంక నెత్ర కెర ఒగ్గర్ బాద జా గెరి ఎంగ్డ తత్తయ్” మెన బతిమాల్ప జా సంగిలన్ ");
INSERT INTO key_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","యేసు జోక “ఆఁవ్ జెయిందె, చి జోక చెంగిల్ కెరిందె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","గని జో పుంజెక్‍జీన్ జమాన్లుక వెల్లొ మాన్సు జోక, “ప్రబు, తుయి అంచి గెరి జెంక మెలె, ఆఁవ్ విలువ నాయ్. తుయి ఇన్నె తెంతొ ఎక్కి సెలవ్ కోడు దిలది మెలె, అంచొ గొత్తి నాడు చెంగిల్ జయెదె. ");
INSERT INTO key_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ఆఁవ్ కి అదికారుమ్‍క బితొసొ. అంచి తెడి జమాన్లు అస్తి. ఆఁవ్ ఎక్కిలొక ‘గో’ మెలె, గెచ్చెదె. అన్నెక్లొక ‘జె’ మెలె, జెయెదె. అంచొ గొతిమాన్సుక ‘ఈంజ కామ్, జా కామ్ కెరు’ మెలె కెరెదె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","యేసు ఈంజొ సంగిలిసి సూన సర్ద జా, పట్టి జెతె తిలసక దెక, జోవయింక, “తుమ్‍క ఆఁవ్ కిచ్చొ కచితుమ్ సంగితసి మెలె, అమ్‍చ ఇస్రాయేలుల్‍తె ఆఁవ్ కక్క కి ఎదిలి నముకుమ్ తిలసక అప్పె ఎదక కి దెకుక నాయ్. ");
INSERT INTO key_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","తుమ్‍క కిచ్చొ మెంతసి మెలె, తూర్పు దేసిమ్‍లు తెంతొ, పడమర దేసిమ్‍లు తెంతొ కి యూదుల్ నెంజిల ఒగ్గర్‍జిన్ మాన్సుల్ జాఁ కెర, అమ్‍చ యూదుల్‍చ పూర్గుమ్‍చ అబ్రాహామ్, ఇస్సాకు చి యాకోబు తెన్ పరలోకుమ్‍తె ఎక్కితె అన్నిమ్ కవుల. ");
INSERT INTO key_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","గని, అమ్‍చి రాజిమ్‍చి రిసొ తుమ్‍క నిసాన అస్సి మెన, అమ్‍చ యూదుల్‍క దేముడు సంగ తిలె కి, ఈంజేఁవ్ అమ్‍చ యూదుల్‍తె ఒగ్గర్‍జిన్ అందర్‍చి ఉప్పిరి అందర్‍తె బయిలె గలి జవుల. ఒత్త మాన్సుల్ ఏడ్తె తవుల, దంతొ చప్పిల్తె తవుల.” మెన సంగ కెర, ");
INSERT INTO key_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","యేసు జో పుంజెక్‍జీన్ జమాన్లుక వెల్లొక “సరె, గో. తుయి నంపజలి రితి తుక జర్గు జవుస్” మెన సంగిలన్. సంగిలి బేగి, జో మాన్సుచొ గొత్తి నాడు చెంగిల్ జలన్. ");
INSERT INTO key_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","పడ్తొ, యేసు పేతురు మెలొ జోచొ సిస్సుడుచి గెరి గెచ్చ కెర, పేతురుచి అత్తస్ జొర్జొ సేడ ఎంగ్డ అస్సె మెన దెక కెర, ");
INSERT INTO key_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","జాచి ఆతు దెర్తికయ్, జా జొర్జొ గెలి, చి జా ఉట్ట కెర, యేసుక మరియాద ఎత్కి కెరుక దెర్లి. ");
INSERT INTO key_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","సాంజ్ జతికయ్, ఒగ్గర్‍జిన్ బూతుమ్ దెర్లసక ఒత్త తిల ప్రెజల్ యేసుతె కడ ఆన్‍తికయ్, జేఁవ్ బూతల్ ఎక్కెక్‍క “ఉట్ట గో” మెన ఎక్కి కోడు తెన్ యేసు ఉదడ గెలన్. కిచ్చొ కిచ్చొ జబ్బుల్ తిలసక కి చెంగిల్ కెర్లన్. ");
INSERT INTO key_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","“జొయ్యి అమ్‍చ బాదల్ జబ్బుల్ దెర గెచ్చయ్‍లొ” మెన దేముడుచ కబుర్లు సంగిలొ యెసయా పూర్గుమ్‍చొచి అత్తి జో సంగిలి కోడు నెరవెర్సుప జంకయ్ మెన ఇసి జలి. ");
INSERT INTO key_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","సుట్టునంత ఒగ్గర్ ఒగ్గర్‍జిన్ బెర తిలిసి యేసు దెక, కెర, “సముద్రుమ్ ఒత్తల్‍తొ గెచ్చుమ” మెన సిస్సుల్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","జలె, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తొసొ ఎక్కిలొ యేసుతె జా కెర, “గురుబాబు, తుయి కేనె గెలె కి, ఆఁవ్ కి తుచి తెన్ బెద జెయిందె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","యేసు జోక “నక్కల్‍క పార్లు, ఆగాసుమ్‍చ పిట్టల్‍క గూడలు, గని ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొక బోడి వంపొ కెర్తి టాన్ నాయ్” మెన సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","సిస్సుల్‍తె అన్నెక్లొ యేసుక “ప్రబు, ఆఁవ్ తుచి తెన్ నే జెతె అగ్గె, గెచ్చ కెర, అంచొ అబ్బొ మొర గెతె ఎదక జోక పోస కెర, జో మొర్లె జోక రోవ గెలుక మెన, అంక సెలవ్ దె” మెన సంగిలన్. చి యేసు జోక దెక, ");
INSERT INTO key_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","“మొర్లస జోవయించ సొంత మొర్లసక రోవ గెల్తు, గని తూయి బేగి అంచి పట్టి బులుక జె.” మెన జో సిస్సుడుక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","తెదొడి యేసు దోనితె వెగితికయ్, జోచ సిస్సుల్ జోచి పట్టి వెగిల. ");
INSERT INTO key_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","జేఁవ్ సగుమ్ దూరి ఇండయ్‍తికయ్, సముద్రుమ్‍తె వాదు కెర్తికయ్, వెల్లెల కెర్టల్ జా దోనితె డేఁవితె తిల, గని యేసు నిజ తిలన్. ");
INSERT INTO key_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","జేఁవ్ సిస్సుల్ జోతె గెచ్చ, ఉట్టవ కెర, “ప్రబు మొర గెతసుమ్. అమ్‍క రచ్చించుప కెరు!” మెన సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","యేసు ఉట్ట కెర, జోవయింక “ఇదిల్ నముకుమ్‍చ, తుమ్, కిచ్చొక బితసు?” మెన జోవయింక సంగ కెర, వాదుక సముద్రుమ్‍క గట్టిఙ ఆడ్ర దిలన్. వాదు కెర్టలు ముల దిలి, చి ఎత్కి అన్నె సేంతుమ్ జలి రిసొ, ");
INSERT INTO key_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","సిస్సుల్, “ఈంజొ కీసొ మాన్సు, చి వాదు కి సముద్రుమ్ కి ఇన్నెచి కోడ్‍క వంపొ జత్తయ్!” మెన ఆచారిమ్ జల. ");
INSERT INTO key_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","జో సముద్రుమ్ జీన కెర, గదరేనులుచి ప్రాంతుమ్‍తె పాఁవితికయ్, బూతల్ దెర్లస దొగుల మెస్నె తెంతొ బార్ జా కెర, యేసుక దస్సుల్ జల. జేఁవ్ దొగులచి ఎదివాట్ కోపుమ్‍చి రిసొ, కో కి జా వాట్ గెచ్చుక దయిరిమ్ నాయ్. ");
INSERT INTO key_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","యేసు జా వాట్ జెతికయ్, “ఈందె, దేముడుచొ పుత్తుసి, అమ్‍చి తెన్ తుక కిచ్చొ? అమ్ సిచ్చ జతి పొది నే జెతె అగ్గె అమ్‍క అల్లర్ కెరుక ఇన్నె అయ్‍లది గే?” మెన కేకుల్ గలిల. ");
INSERT INTO key_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","జలె, జోవయించి ఇదిల్ ఒత్తల్‍క ఒగ్గర్ అండ్రుల్ తిలి మంద కతె తతికయ్, ");
INSERT INTO key_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","జేఁవ్ బూతల్ యేసుక “తుయి అమ్‍క ఇన్నె తెంతొ ఉదడ్లెగిన, అండ్రుల్ తిలి జా మందతె అమ్‍క తెద్రవ్” మెన, యేసుక బతిమాల్ప జా సంగిల. ");
INSERT INTO key_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","జో జోవయింక “గెచ్చ!” మెన సంగితికయ్, జేఁవ్ బూతల్ బార్ జా, జేఁవ్ మాన్సుల్‍క ముల దా, అండ్రుల్‍చి పెట్టి పెస గెల, చి జా మందచ అండ్రులు ఎత్కి వెర్రి జా, జా వెల్లి గాటిక నిగ ఉత్ర, సముద్రుమ్‍తె సేడ మొర గెల. ");
INSERT INTO key_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","దస్సి జర్గు జతికయ్, మంద రకితస బమ్మ జా, జా పట్నుమ్‍తె నిగ గెచ్చ, బూతల్ దెర్లసక జర్గు జలిసి ఎత్కి, కిచ్చొ నే పిట్తె, పట్నుమ్‍చక సంగిల. ");
INSERT INTO key_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","జాచి రిసొ, పట్నుమ్‍చ ఎత్కిజిన్ యేసు తెన్ దస్సుల్ జంక మెన బార్ జా, దెక కెర, “అమ్‍చి దేసిమ్ తెంతొ ముల దా ఉట్ట గో!” మెన బతిమాల్ప జా, జోక బమ్మ తెన్ సంగిల. ");
INSERT INTO key_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ఒత్త తెంతొ, యేసు దోనితె వెగ కెర, జా సముద్రుమ్ జీన కెర, జోచి సొంత పట్నుమ్‍తె పాఁవితికయ్, ");
INSERT INTO key_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ఒత్త తిల మాన్సుల్ వాతుమ్ జొర్జొ తెన్ తిలొసొ, ఉట్టుక నెతిర్లొ అంతుర్నొతె ఎంగ్డ తిలొసొ ఎక్కిలొక జోతె కడ ఆన్ల. యేసు జేఁవ్ కడ ఆఁన్లసచి నముకుమ్ దెక కెర, జో ఉట్టుక నెతిర్లొసొక దెక, “ఓ పూత్తు, తుయి దయిరిమ్ జా. తుచి పాపల్ చెమించుప జా అస్తి” మెన జోక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","జలె, ఒత్త తిల మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస సగుమ్‍జిన్ ‘యేసు దేముడు తెన్ సమ్మందుమ్ సంగితయ్. జా వెల్లి పాపుమ్’ మెన బమ్మ జా, లట్టబన్ల. ");
INSERT INTO key_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","యేసు జోవయించి మెన్సుతె తిలిసి చిన కెర, “తుమ్‍చి పెట్టి కిచ్చొక కుస్సిదుమ్ ఉచర్తసు? ");
INSERT INTO key_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","‘తుచి పాపల్ చెమించుప జా అస్తి’ మెనుక సుల్లు గే, ‘ఉట్ట ఇండు’ మెనుక సుల్లు గే? ");
INSERT INTO key_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","జలె, ‘మాన్సు జా జెర్మున్ అయ్‍లయ్ అంక అప్పె ఈంజ లోకుమ్‍తె తిలె కి, మాన్సుల్‍చి పాపల్ చెమించుప కెర్తి అదికారుమ్ అస్సె’ మెన తుమ్‍క రుజ్జు దెకయిందె” మెన, జో ఉట్టుక నెతిర్లొ మాన్సుక అన్నె దెక, యేసు జోక, “తుయి ఉట్ట కెర, తుచి అంతుర్నొ వయన గెరి గో” మెన సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","జో మాన్సు ఉట్ట కెర, గెరి గెలన్. ");
INSERT INTO key_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ఇసి జర్గు జతికయ్, ప్రెజల్ దెక కెర, బియఁ గెచ్చ, మాన్సుచి అత్తి జో ఇసి అదికారుమ్ దిలిస్‍చి రిసొ, దేముడుక గవురుమ్ కెల. ");
INSERT INTO key_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","యేసు ఒత్త తెంతొ ఇదిల్ దూరి ఇండ గెచ్చ, జా పట్నుమ్‍చి సిస్తు కడన్‍తి గెరిచి వాట్ గెచ్చ కెర, ఒత్త పెస తిలొ మత్తయి మెలొ సిస్తు నఙితొసొక దెక, “అంచి పట్టి జా అంచొ సిస్సుడు జా” మెన జోక సంగిలన్, చి జో ఉట్ట కెర, యేసుచి పట్టి గెలన్. ");
INSERT INTO key_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","జో మత్తయి మెలొసొచి గెరి అన్నిమ్ కంక మెన యేసు గెచ్చ వెస తతికయ్, జా దేసిమ్‍చ నిస్కారుమ్ దెకిల సిస్తు నఙితస కి, చి నీతి నే కెరంత ‘పాపుమ్ కెర్లస’ మెన ఒత్తచ యూదుల్ నిస్కారుమ్ దెకిలస ఒగ్గర్‍జిన్ జోతె జా కెర, జో తెన్ సిస్సుల్ తెన్ వెసిల. ");
INSERT INTO key_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","జేఁవ్ ఇన్నె బెద వెసిలిసి దెక కెర, పరిసయ్యుల్ మెంత పండితుల్ యేసుచ సిస్సుల్‍తె జా కెర, జోవయింక “తుమ్‍చొ గురు సిస్తు నఙితస తెన్ పాపుమ్ కెర్లస్ తెన్ కిచ్చొక వెస అన్నిమ్ కతయ్?” మెన పుసిల. ");
INSERT INTO key_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","జేఁవ్ దస్సి సంగిలిసి యేసు సూన కెర, “జబ్బు తెన్ అస్సుమ్ మెన చినన్లస డాక్టర్ అవ్‍సురుమ్, గని జబ్బు నెంజిలసక డాక్టర్ అవ్‍సురుమ్ నాయ్.” ");
INSERT INTO key_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","జలె, “తుమ్ కిచ్చొ కెర్తిసి అంచి ఆస మెలె, బలి దెతిసి నాయ్, గని మాన్సుల్‍క కన్కారుమ్ దెకితిసి మెలి కోడుచి అర్దుమ్ కిచ్చొ జయెదె గే, తుమ్ గెచ్చ సిక్క. ‘ఆమ్ పాపుమ్ కెర్లస’ మెన చినంతసకయ్ బుకార్‍క ఆఁవ్ అయ్‍లయ్, గని ఆమ్ పున్నిమ్ తిలస మెన ఉచరంతసక బుకార్‍క నాయ్.” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","తెదొడి బాప్తిసుమ్ దెతె తిలొ యోహానుచ సిస్సుల్ యేసుతె జా కెర “పరిసయ్యుల్ కి ఆమ్ కి చువ్వె తంక అలవాట్, గని తుచ సిస్సుల్ చువ్వె తతి నాయ్. కిచ్చొక?” మెన, యేసుక పుసిల. ");
INSERT INTO key_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ఇసి పుసితికయ్, యేసు జోవయింక, “కేన్ పెండ్లితె, జోవయించి నెడిమి పెండ్లిఉబేడొ తిలె పొది, పెండ్లి విందుతె బుకార్లస ముసుర్న తవుల గె? నాయ్. బెదె నాయ్. జలె, పెండ్లిఉబేడొచి పచ్చెన జలసచి నెడ్‍మె తెంతొ జోక దెర వేరతె కడ నిలె, జేఁవ్ పొదుల్‍క జోచ మాన్సుల్ ఏడ ఏడ చువ్వె తవుల. ");
INSERT INTO key_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“జలెకు, పొర్ని పాలుమ్ చిరి జా తిలెగిన, మాసికచి రిసొ నే కేడయ్‍లి నే కేడ్తె నొవి బట్ట గండ కో జాన్‍ల మాన్సుల్ గల్తి నాయ్. దస్సిచి పోర్నిచితె గల తిలెగిన, జో పాలుమ్ కేడ్లె, జా మాసిక కడెదే. మాన్సు జా పాలుమ్ గలన్లె, అవ్కు జలి పొర్ని బట్ట నొవి బట్టచి మాసిక బెదయ్‍లి కుటు సొడి చిరి జయెదె, చి అగ్గెచి కంట వెల్లి బొరొ జయెదె. ");
INSERT INTO key_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","పడ్తొ, జలె, ఒత్త నొవి ద్రాచ రస్సుమ్ పోర్నిచి కాయ తెన్ కో సువితి నాయ్. జా కాయ పొర్ని జలి రిసొ, దస్సితె నొవి రస్సుమ్ సువిలెగిన, జా కాయ పులుక నెతిరి రిసొ, జా రస్సుమ్ పొంగుప జలె, జా కాయ పుట్టెదె. పుట్టిలె, జా రస్సుమ్ సూఁయి జయెదె, చి కాయ కి పాడ్ జా గెచ్చెదె. జాచి రిసొ, నొవి ద్రాచ రస్సుమ్ నొవి కాయల్‍తె సువుల. దస్సి, జా రస్సుమ్ కి జా కాయ కి పాడ్ నే జస్తె, చెంగిల్ తయెదె” మెన, జోక పరిచ్చ కెర్ల మాన్సుల్‍క యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ఒత్త జా తిల మాన్సుల్‍క యేసు ఈంజేఁవ్ కొడొ సంగితె తతికయ్, ఒత్తచి సబ గెర్‍చొ అదికారి ఎక్కిలొ జా కెర, యేసుక దస్సుల్ జా, సెర్ను సేడ జొకర, “అంచి దూ అప్పె మొర గెచ్చ అస్సె. తుయి, జలె, అమ్‍తె జా కెర జాక చడిలెగిన, అన్నె జియెదె” మెలన్. ");
INSERT INTO key_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","జో దస్సి మెంతికయ్, యేసు ఉట్ట కెర జోచి పట్టి గెలన్. జోచ సిస్సుల్ కి బెద గెల. ");
INSERT INTO key_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","జేఁవ్ వట్టె గెతె తతికయ్, బార వెర్సుల్ తెంతొ లొఁయి గెతి బాద తెన్ తిలి ఏక్ తేర్‍బోద యేసుచి పట్టి జా, పాఁవ కెర, “ఆఁవ్ ఎక్కి జోచొ పాలుమ్ జవుస్ చడిలెగిన, చెంగిల్ జయిందె” మెన, జాక జయ్యి ఉచరన, జోచొ పాలుమ్‍చి కొంగు చడిలి. ");
INSERT INTO key_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","జా చడితికయ్, యేసు పడ్తొ పస్ల జాక దెక, “ఓ దూ, దయిరిమ్ తెన్ తా. అంచి ఉప్పిరిచి తుచి నముకుమ్ తుక చెంగిల్ కెర్లి.” మెన సంగిలన్. జా బేగి చెంగిల్ జలి. ");
INSERT INTO key_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","తెదొడి యేసు జో అదికారిచొ గెరి పాఁవ కెర, నాడి మొర్లి రిసొ మూరి పుఙితస, చి బెర తిల ఏడుకుడు జతస ఒగ్గర్ గొడబ జతిసి దెక కెర, ");
INSERT INTO key_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“తుమ్ గెచ్చ. ఈంజ నాడి మొర గెచ్చె నాయ్. నిజ అస్సె” మెన జోవయింక సంగితికయ్, జోక ఆఁసిల. ");
INSERT INTO key_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","జలె, జనాబ్ ఎత్కిక బార్ కెరవడ కెర, యేసు తెడి గెచ్చ, జా నాడిచొ ఆతు దెర్లి బేగి, జీవ్ జా ఉట్లి. ");
INSERT INTO key_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ఈంజ కామ్‍చి రిసొ జా ప్రాంతుమ్ ఎత్కితె పాఁవిలి. ");
INSERT INTO key_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","యేసు బార్ జా కెర, ఒత్త తెంతొ గెరి గెతె తతికయ్, దొగుల గుడ్డి మాన్సుల్ జోచి పట్టి జా, “దావీదు రానొచి సెకుమ్‍తె జెర్మిలొ రచ్చించుప కెర్తొసొ, అమ్‍చి ఉప్పిరి కన్కారుమ్ తిఁయ, అమ్‍క చెంగిల్ కెరు!” మెన కేకుల్ గల్తె తిల. ");
INSERT INTO key_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","యేసు గెరి గెచ్చ పెసిలి పడ్తొ, జేఁవ్ గుడ్డి మాన్సుల్ ఒత్త జోతె అయ్‍ల. జెతికయ్, యేసు జోవయింక “తుమ్ ఉచర్లిసి అంక ‘కెరుక తెరె’ మెన తుమ్ నంపజతసు గే?” మెన జోవయింక పుసితికయ్, జేఁవ్, “ప్రబు, అమ్ నంపజతసుమ్” మెన జోక సంగిల. ");
INSERT INTO key_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","యేసు జోవయింక అంకివొతె చడ కెర, “ఆఁవ్ తుక ‘చెంగిల్ కెరుక తెరె’ మెన తుమ్ నంపజలిసి రిసొయి తుమ్‍క జర్గు జవుస్!” మెన, సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","సంగిలి బేగి, జోవయింక అంకివొ డీసిల. పిమ్మట్, యేసు జోవయింక “ఈంజ కామ్ కో కి నేన్‍తె రితి దెకన, తుమ్ దొగుల తుక్లె తా” మెన గట్టిఙ సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","గని, జేఁవ్ ఉట్ట గెచ్చ, జా ఒండి గలిలయ ప్రాంతుమ్‍తె జోచి గవురుమ్ సంగితె తిల. ");
INSERT INTO key_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","యేసు సిస్సుల్ తెన్ బార్ జా కెర, అన్నె బులుక గెతె తతికయ్, బూతుమ్ దెర్లొ గుల్లొ సుదొ ఎక్కిలొక జోతె కో గే కడ ఆన్ల. ");
INSERT INTO key_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","యేసు జో బూతుమ్‍క ఉదడ గెలి బేగి, జో గుల్లొ సుదొ లట్టబన్లొ. ఒత్త బెర తిల జనాబ్ ఆచారిమ్ జా, “అమ్‍చ ఇస్రాయేలుల్‍తె ఇసిచి జర్గు జలిసి కెఁయ్య దెకుమ్ నాయ్. ఆజి జర్గు జలి!” మెన లట్టబన్ల. ");
INSERT INTO key_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","గని పరిసయ్యుల్ కిచ్చొ మెల మెలె, “బూతల్‍క రానొ జలొసొచి నావ్ తెన్ ఈంజొ బూతల్‍క ఉదడ్తయ్” మెన అరుగురు జా, గోసక సంగిల. ");
INSERT INTO key_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","యేసు జా గలిలయ ప్రాంతుమ్ ఒండిచ పట్నలె గఁవ్విలె బుల బుల, జోవయించ సబ గెరలె గెచ్చ, పరలోకుమ్‍చి రాజిమ్ పాసి జా అయ్‍లిస్‍చి రిసొచి సుబుమ్ కబుర్ సంగ, ఎత్కి రగల్‍చ జబ్బులు నొప్పులు గెచ్చవ, మాన్సుల్‍క చెంగిల్ కెర్తె తిలన్. ");
INSERT INTO key_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","దస్సి బుల్తె పొది, ఒగ్గర్ జనాబ్ జోతె అయ్‍ల జేఁవ్ మాన్సుల్‍క దెక దెక, జేఁవ్ గొవుడు నెంజిల మెండల్ రిత మాలఙ్ జా స్రెమల్ తెన్ తిలిసి దెక, జోవయించి ఉప్పిరి కన్కారుమ్ జా, ");
INSERT INTO key_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","“గట్టిఙ పంటొ పిక లాయితి సమయుమ్ జా అస్సె. ");
INSERT INTO key_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","జాచి రిసొ, ‘ఈంజ పంటొ లాయితి రితి, ఈంజ పంటొక ఎజొమాని జలొ ప్రబు లాయిత మాన్సుల్‍క తెద్రవుసు’ మెన, తుమ్ జోక ప్రార్దన కెర” మెన యేసు సిస్సుల్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","తెదొడి యేసు జోచ బారజిన్ సిస్సుల్‍క పాసి బుకారా కెర, బూతల్ గట్రక ఉదడ గెలుక మెన, రగరగాల్‍చ జబ్బులు బాదల్ జల మాన్సుల్‍క చెంగిల్ కెరుక మెన, జోవయింక అదికారుమ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","జేఁవ్ బారజిన్ యేసుచ, బారికుల్‍చ నవ్వొ కిచ్చొ కిచ్చొ మెలె, తొలితొ పేతురు మెన అన్నెక్ నావ్ తిలొ సీమోను, చి జోచొ బావొసి అంద్రెయ. ఒత్త తెంతొ, జెబెదయిచొ పుత్తుసి యాకోబు, చి యాకోబుచొ బావొసి యోహాను. ");
INSERT INTO key_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ఒత్త తెంతొ, పిలిప్ చి బర్తొలొమయి, తోమా చి మత్తయి మెలొ సిస్తు నఙితొసొ. ఒత్త తెంతొ, అల్పయిచొ పుత్తుసి యాకోబు, చి తద్దయి మెలొసొ. ");
INSERT INTO key_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ఒత్త తెంతొ, కనానుచొ సీమోను మెలొ అన్నెక్లొ, చి పడ్తొ యేసుక దెర తిలొ ఇస్కరియోతు మెలి గఁవ్విచొ యూదా. ");
INSERT INTO key_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","యేసు జేఁవ్ బారజిన్‍క అదికారుమ్ దా కెర బులుక తెద్రయ్‍లి పొది, కిచ్చొ సెలవ్ దిలన్ మెలె, “యూదుల్ నెంజిలసతె అప్పె గెచ్చుక పోన, చి సమరయ ప్రదేసిమ్‍చ పట్నలె పెస నాయ్. ");
INSERT INTO key_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","జలె, పిట్ట గెల గొవుడు నెంజిలి మంద రితి జా తిల ఇస్రాయేలుల్‍తె తుమ్‍చ సొంత మాన్సుల్‍తె తుమ్ గెచ్చ. ");
INSERT INTO key_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","తుమ్ గెచ్చ, చి ‘పరలోకుమ్‍చి రాజిమ్ పాసి జా అస్సె’ మెన బోదన కెర. ");
INSERT INTO key_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","జబ్బు మాన్సుల్‍క చెంగిల్ కెర. మొర గెలసక జీవ్ కెర. వెల్లి జబ్బుల్ తిలసక చెంగిల్ కెర సుద్ది కెర, చి బూతల్‍క ఉదడ గెల. ఆఁవ్ దెతిసి ఆరి తుమ్‍క దొర్కు జలి. మాన్సుల్‍క ఆరి తుమ్ దాస. ");
INSERT INTO key_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“తుమ్ బుల్తె పొది, బఙార్ గే వెండి గే రాగిచ కాసుల్ గే, కిచ్చొ రగుమ్ డబ్బుల్ జలెకు దెరన బార్ జా నాయ్. ");
INSERT INTO key_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","దస్సి, సెంచె జలెకు, దొన్ని సొక్కల్ జలెకు, జోడ్లు జలెకు, టెక్నొ డండొ జలెకు దెరన బార్ జా నాయ్. తుమ్ కచి రిసొ కామ్ కెర్తె గే, తుమ్ కెర్తి కామ్‍చి రిసొ జో దెతి అన్నిమ్ తుమ్ నఙనుక నాయిమ్. ");
INSERT INTO key_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“అన్నె, తుమ్ కేన్ పట్నుమ్‍తె జలెకు గఁవ్వి జలెకు పెసితె పొది, ఒత్త తగుప జలొసొ కో గె జానన, చి తుమ్ ఒత్త తెంతొ ఉట్ట గెతె ఎదక జోచితె తా. ");
INSERT INTO key_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","జోచి గెరి తుమ్ పెసితె పొది, జా గేర్‍చక, తుమ్‍క సేంతుమ్ తవుసు మెన చెంగిల్ సంగ. ");
INSERT INTO key_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","జా గేర్ సేంతుమ్‍క తగుప జతిస్ జలె, తుమ్ ఆన్‍లి సేంతుమ్ జోవయింక జర్గు జా, తవుసు. జా గెర్‍చ సేంతుమ్‍క నే తగుప జతిస్ జలె, తుమ్ ఆన్‍లి సేంతుమ్ జోవయింక నే తతె తుమ్‍క అన్నె బుల జెయెదె. ");
INSERT INTO key_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","కో జలెకు తుమ్‍క మరియాద నే కెర్లెగిన, తుమ్ ఆన్‍తి కబుర్ నే సూన్లెగిన, జో గేరు జలెకు, జా గాఁవ్ జలెకు ముల దా, తుమ్ ఉట్ట గెతె పొది, జా గుర్తుక, తుమ్‍చ చట్టొ జా టాన్‍తెచి లంబిలి దూడి పంప్డ గెల, చి ఉట్ట గెచ్చ. ");
INSERT INTO key_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ఈంజ లోకుమ్‍చక వెల్లి తీర్పు కెర్తి దీసి అయ్‍లె, సొదొమ చి గొమొరా మెల పూర్గుమ్ కుడ్తె నాసెనుమ్ జల పట్నల్‍చి గత్తిచి కంట, తుమ్‍క మరియాద నే కెర్లి కేన్ గఁవ్విచచి గత్తి ఒగ్గర్ సిచ్చచి జయెదె, మెన నిజుమి తుమ్‍క ఆఁవ్ సంగితసి. ");
INSERT INTO key_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“ఈందె, డొర్కొవచి నెడ్‍మె మెండల్‍క తెద్రయ్‍లి రితి, దస్సి, తుమ్‍క మాన్సుల్‍తె ఆఁవ్ తెద్రయ్‍తసి. జాచి రిసొ, అయివొ కెద్ది తెలివి అస్తి గే, తుమ్ కి తెద్ది తెలివి జా తా. గని, దస్సి తెలివి జలెకి, పార్వ పిట్టల్‍చి రితి, తేట మెన్సు తిల సుదల్ జా తా. ");
INSERT INTO key_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","కోపుమ్ జత మాన్సుల్‍చి రిసొ జాగర్త తెన్ తా. జేఁవ్ తుమ్‍క తీర్పు కెర్త సబల్‍తె సొర్ప కెర, జోవయించ సబ గెరలె తుమ్‍క కొర్డల్ తెన్ పెటుల. ");
INSERT INTO key_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","తెదొడ్‍క అంచి రిసొ జేఁవ్ మాన్సుల్ తుమ్‍క దెర అదికారుల్‍తె, రానల్‍తె ఒర్గొడ నెవుల. చి జోవయించి మొక్మె కి, వేర దేసిమ్‍లు తెంతొ అయ్‍ల అమ్‍చ యూదుల్ నెంజిలసచి మొక్మె కి తుమ్ అంచి రిసొ సాచి సంగితె. ");
INSERT INTO key_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","మాన్సుల్ తుమ్‍క దస్సి సొర్ప కెర్తె పొదిక, కీసి లట్టబుక గే, కిచ్చొ సంగుక గే, ఉచర చింత గలన నాయ్. కిచ్చొక మెలె, తుమ్ జోవయింక కిచ్చొ సంగుక గే, తెదొడ్‍కయ్ దేముడుచి సుద్ది తిలి ఆత్మ తుమ్‍క దెయెదె. ");
INSERT INTO key_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","మెలె, తుమ్‍చొ అబ్బొసి జలొ దేముడుచి సుద్ది తిలి ఆత్మ తుమ్‍చి పెట్టి తా కెర, జొయ్యి లట్టబెదె. తుమ్ ఉచర లట్టబ్సు నాయ్. ");
INSERT INTO key_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“జా పొదిక, అన్నొస్‍క బావొసి జలెకు, పుత్తుస్‍క అబ్బొసి జలెకు, మొర్తి సిచ్చతె సొర్ప దెవుల. అన్నె, పుత్తర్సుల్ అయ్యస్‍అబ్బొస్‍చి ఉప్పిరి విరోదుమ్ జా, జోవయింక మొరవుల. ");
INSERT INTO key_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","అంచి నావ్‌చి రిసొ ఒగ్గర్ ఒగ్గర్‍జిన్ తుమ్‍క విరోదుమ్ జవుల. ఈంజేఁవ్ అల్లర్ పూర్తి జతె ఎదక కో అంక నిదానుమ్ తా ఓర్సుప జవుల గే, రచ్చించుప జవుల. ");
INSERT INTO key_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","మాన్సుల్ ఏక్ పట్నుమ్‍తె తుమ్‍క అల్లర్ కెర్లె, అన్నెక్ పట్నుమ్‍తె ఉట్ట నిగ. కిచ్చొక మెలె, తుమ్‍క ఆఁవ్ కిచ్చొ సంగితసి మెలె, ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ అన్నె జెతె ఎదక, అమ్‍చ ఇస్రాయేలుల్‍చ పట్నల్ ఎత్కితె తుమ్ బుల కేడవుక నెతుర్సు. ");
INSERT INTO key_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“జోచొ గురుచి కంట సిస్సుడు వెల్లొ నెంజె. దస్సి కి, జోచొ ఎజొమాసిచి కంట గొత్తి మాన్సు వెల్లొ నెంజె. ");
INSERT INTO key_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","సిస్సుడు జోచొ గురుచొ రితొ, గొత్తి మాన్సు జోచొ ఎజొమానిచొ రితొ జలె, సరి జతయ్. దస్సి, ఆఁవ్ గెర్‍చొ ఎజొమానిక ‘బయెల్జెబూల్’ మెన కోపుమ్ జల మాన్సుల్ సంగ అస్తి జలె, తుమ్ అంచి గెర్‍చ ఎత్కిక కి కచితుమ్ దస్సి దూసుప కెరుల. ");
INSERT INTO key_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“జలె, జేఁవ్ అల్లర్ కెర్తసక తుమ్ బియఁ నాయ్. డంక తిలిసి కిచ్చొ జలెకి కెఁయఁక తెఁయఁక నే డీస్తె తయె నాయ్, లుంకడ్లిసి కిచ్చొ జలెకి కెఁయఁక తెఁయఁక ఎత్కిక నే జాన్‍తి రితి తయె నాయ్. ఆకర్‍క డీసెదె, ఆకర్‍క జానన్‍క జయెదె. ");
INSERT INTO key_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ఆఁవ్ గుట్టు తెన్ తుమ్‍క సంగితిసి తూమ్ ఎదార్దుమ్ సంగ. కంగ్డయి తుమ్‍క ఆఁవ్ సంగితిసి తూమ్ మేడల్‍చ ఒర్నెలె తెంతొ సాట్ప కెర. ");
INSERT INTO key_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","తుమ్‍చి ఆఁగుక మారుక తెర్లసక తుమ్ బియఁ నాయ్. కిచ్చొక మెలె, తుమ్‍క మార్లె కి, తుమ్‍చి ఆత్మక మారుక నెతిర్తి. గని ఆత్మక కి ఆఁగుక కి మార వెల్లి ఆగి గొయ్‍తె గల దా, నాసెనుమ్ కెరుక తెర్లొసొకయ్ తుమ్ బియఁ. ");
INSERT INTO key_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“ఈంజ దేసిమ్‍చ మాన్సుల్ దొన్ని గెర్‍పిట్టల్ ఎక్కి కాసుక వికుల. జలెకి, తుమ్‍చొ అబ్బొసి జలొ దేముడుచి సెలవ్ నెంజిలె, దస పిట్టల్‍తె ఎక్కి కి బుఁయ్యె సేడె నాయ్. ");
INSERT INTO key_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","తుమ్‍చి బోడిచ సెండి వాడల్ ఎత్కి మొత్తుమ్ కెత్తి అస్తి గే జొయ్యి జానె. ");
INSERT INTO key_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","జాచి రిసొ, తుమ్ బియఁ నాయ్. తుమ్ పిట్టల్‍చి కంట ఒగ్గర్ విలువ అస్సుస్. ");
INSERT INTO key_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“కో అంక నంపజా, మాన్సుల్‍చి మొక్మె ఒప్పనుల గే, జోక అమ్‍చ మాన్సుల్ ఈంజేఁవ్ మెన, పరలోకుమ్ తిలొ అబ్బొసి జలొ దేముడుచి మొక్మె ఆఁవ్వి సాచి సంగిందె. ");
INSERT INTO key_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","గని, మాన్సుల్‍చి మొక్మె కో అంచి రిసొ ‘జోచొ నెంజి’ మెనుల గే, దస్సి పరలోకుమ్ తిలొ అబ్బొసి జలొ దేముడుచి మొక్మె జోక ‘అమ్‍చ నెంజితి’ మెన సంగిందె. ");
INSERT INTO key_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“‘జో బూలోకుమ్‍తె అయ్‍లిసి మాన్సుల్‍తె ఎక్కి సేంతుమ్ కెరెదె’ మెన తుమ్ అంక ఉచర నాయ్. సేంతుమ్ నాయ్, గని జట్టి కెరయ్‍తి రితి అయ్‍లయ్. ");
INSERT INTO key_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","కీసి మెలె, ఆఁవ్ అయ్‍లి రిసొ, జోచొ అబ్బొస్‍క పుత్తుసి, జాచి అయ్యస్‍క దువిసి, జాచి అత్తస్‍క సూనుసి విరోదుమ్ జవుల. ");
INSERT INTO key_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","దస్సి, ఏక్ మాన్సుచి కుటుంబుమ్‍చయ్ జోక విరోదుమ్ సుదల్ జవుల. ");
INSERT INTO key_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“అబ్బొస్‍క జలెకు, అయ్యస్‍క జలెకు అంచి కంట కో ఒగ్గర్ ప్రేమ కెరుల గే, దస్సి మెననుక అంక తగుప జలస నెంజితి. పుత్తుస్‍క జలెకు, దువిస్‍క జలెకు అంచి కంట కో ప్రేమ కెరుల గే, దస్సి మెననుక అంక తగుప జలస నెంజితి. ");
INSERT INTO key_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","అంచి రితి జోవయించి సొంత సిలువ వయన్లి రితి జా, కో అంచి పట్టి జెతి నాయ్, దస్సి మెననుక అంక విలువ జలస నెంజితి. ");
INSERT INTO key_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","కో జోచి సొంత ప్రానుమ్ రచ్చించుప కెరనుక చజుల గే, జోచి ప్రానుమ్ పాడ్ జా గెచ్చెదె. గని అంచి రిసొ కో జోచి ప్రానుమ్ దెతి రితి ఎక్కి నిదానుమ్ ఇండుల గే, జోచి ప్రానుమ్ రచ్చించుప జా జోక దొర్కు జయెదె. ");
INSERT INTO key_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“తుమ్‍క కో మరియాద కెరుల గే, జేఁవ్ తుమ్‍క మరియాద కెర్లిసి, అంకయి మరియాద కెర్లిసి జతయ్. అన్నె, అంకయి కో మరియాద కెరుల గే, జేఁవ్ దస్సి కెర్లిసి అంక తెద్రయ్‍లొసొక కి మరియాద కెర్లిసి జతయ్. ");
INSERT INTO key_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","జలె, ‘దేముడు సంగిలి కబుర్ ఆన్‍తొసొ, ఈంజొ’ మెన కో దస మాన్సుల్‍క మరియాద దెకుల గే, జోవయింక కి ప్రబుచి కబుర్ సంగితొసొక దెతి రితి బవుమానుమ్ దొర్కు జయెదె. పడ్తొ, ‘ప్రబుచి నీతి తెన్ తిలొసొ, ఈంజొ’ మెన చిన, కో దసొ మాన్సుక మరియాద కెరుల గే, జోక కి నీతి తిలొసొక దెతి రితి బవుమానుమ్ దొర్కు జయెదె. ");
INSERT INTO key_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","పడ్తొ, ‘యేసుచ సిస్సుల్’ మెన కో ఈంజేఁవ్ గవురుమ్ నెంజిల నంపజలసతె ఎక్కిలొక కి ఎక్కి బుక్కెక్ పాని కి పియడుల గే, జోవయింక కి బవుమానుమ్ దొర్కు జయెదె, మెన నిజుమి సంగితసి” మెన సిస్సుల్‍క యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","యేసు జోచ బారజిన్ సిస్సుల్‍క బోదన కెర్లిసి కేడ్లి పడ్తొ, జా గలిలయ ప్రాంతుమ్‍చ పట్నల్‍తె బోదన కెరుక మెన బార్ జలన్. ");
INSERT INTO key_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","బాప్తిసుమ్ దెతొ యోహానుక హేరోదు రానొ జేల్‍తె గల తిలొ. జలె, క్రీస్తు కెర్త కమొచి రిసొ యోహాను జేల్‍తె సూన కెర, జోచ సిస్సుల్ తెన్ యేసుక కిచ్చొ కబుర్ తెద్రయ్‍లన్ మెలె, “దేముడు తెద్రయిందె మెలొ రచ్చించుప కెర్తొసొ నిజుమి తుయి గే, అమ్ అన్నెక్లొక రకుక గే? ");
INSERT INTO key_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","మెన పుస” మెన సంగ తెద్రయ్‍లొ. ");
INSERT INTO key_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","యేసు యోహానుచ సిస్సుల్‍క, దెక కెర సూన కెర, “తుమ్ గెచ్చ, చి దెకిలిసి సూన్లిసి ఎత్కి యోహానుక సంగ. ");
INSERT INTO key_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","గుడ్డి జా తిల మాన్సుల్ దెకితతి, సొట్ట జా తిల మాన్సుల్ ఇండితతి, వెల్లి రోగుమ్ సేడ తిలస చెంగిల్ జా సుద్ది జతతి, బొయ్‍రొ జా తిల మాన్సుల్ సూన్‍తతి, మొర గెలస జీవ్ జతతి, సుబుమ్ కబుర్ బీద మాన్సుల్‍క సూనయ్‍తసి. ");
INSERT INTO key_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","జలె, ‘కో జలెకు అంచి రిసొ అన్మానుమ్ నెంతె తవుల గే, జోక చెంగిలి’” మెన యేసు సంగ తెద్రయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","యోహానుచ సిస్సుల్ ఉట్ట గెతె తతికయ్, ఒత్త తిల ప్రెజల్‍క యోహానుచి రిసొ యేసు ఇసి మెన సంగుక దెర్లన్. “తుమ్ కిచ్చొ దెకుక జా బయిలె గెచ్చ తిలదు? వాదుతె చివ్వర్ పెల్లి జతిసి దెకుక గెచ్చ తిలదు గే? ");
INSERT INTO key_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","నాయ్ మెలె, కిచ్చొ వేరచి దెకుక గెలదు? సొమ్సార్లు గలంత పాలల్ గలన్లొ మాన్సుక దెకుక గెలదు గే? ఈందె, దస్స పాలల్ గలంతస రానల్‍చి గెరలె తవుల. ");
INSERT INTO key_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","జలె, కిచ్చొ దెకుక గెలదు? దేముడు తెద్రయ్‍లి కబుర్ సంగితొసొ ఎక్కిలొక దెకుక గెలదు గే? నిజుమి. గని, జో ప్రబుచ మాములుమ్ కబుర్లు సంగితసచి కంట యోహాను ముక్కిమ్‍చొ జయెదె,” మెన తుమ్‍క ఆఁవ్ సంగితసి. ");
INSERT INTO key_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","“ఈందె, అంచి కబుర్ సంగితొసొ జతి రితి ఎక్కిలొక తుచి పుర్రె తెద్రయ్‍తసి. తుచి కంట అగ్గె గెచ్చ, తుయి జెతిసి సాట్ప కెరెదె” మెన రెగిడ్లి కోడ్ అస్సె. జా కోడు యోహానుచి రిసొయి ‘అంచి కబుర్ సంగితొసొ’ మెన కచి రిసొ సంగితయ్. ");
INSERT INTO key_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","జాచి రిసొ, తెర్నిమున్సు లట్టబ్లి రిసొ జెర్మిలసతె బాప్తిసుమ్ దిలొ యోహానుచి కంట వెల్లొచొ కోయి నాయ్ మెన ఆఁవ్ కచితుమ్ తుమ్‍క సంగితసి. జలెకి, పరలోకుమ్‍చి రాజిమ్‍తె బెదితసతె, కో ఎత్కిచి కంట దాక్ జవుల గే, జో యోహానుచి కంట వెల్లెల జవుల. ");
INSERT INTO key_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“బాప్తిసుమ్ దిలొ యోహానుచ దీసల్ తెంతొ మొదొల్ కెర, పరలోకుమ్‍చి రాజిమ్ పెలయ్‍లి రితి జెతె అస్సె, చి మాన్సుల్ బమ్మ తెన్ జేఁవ్‍తె బెదితతి. ");
INSERT INTO key_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","యోహాను ఎదక దేముడుచ కబుర్లు సంగిలస, మోసే పూర్గుమ్‍చొచి అత్తి దేముడు రెగ్డయ్‍ల ఆగ్నల్‍చి కొడొ ఎత్కి పరలోకుమ్‍చి రాజిమ్ జెతిస్‍చి రిసొ సంగితయ్. జేఁవ్ ఎత్కిజిన్‍చి ఆకర్‍తె యోహాను అయ్‍లొ. ");
INSERT INTO key_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","అంచి కబుర్ పూర్గుమ్ సంగిలొ ఏలీయా రితొసొ ఎక్కిలొక తెద్రయిందె” మెన ప్రబు అగ్గె సంగ తిలొ. జలె, తుమ్ నంప కెర్తె గే నాయ్ గే, గని జో తెద్రయి జలొసొ యోహాను. ");
INSERT INTO key_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","సూన్‍త కంగ్డొ తిలస సూన. ");
INSERT INTO key_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“జలె, ఈంజ ఉగుమ్‍చ మాన్సుల్‍చి బుద్దిక కిచ్చొ టాలి జయెదె? వీదులె వెస కెల్త బోదల్‍చ రిత జతతి, జేఁవ్ బోదల్ జోవయింతెన్ బెద కెల్త బోదల్ బుకార కెర, ");
INSERT INTO key_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","తుమ్‍క ‘నచ్చుతు’ మెన బఁవ్సి పుంగిలెకి నచ్చుసు నాయ్. అమ్ ఏడ్లెకి, తుమ్ బెద ఏడ్సు నాయ్, మెన దస బోదల్ కీసి సంగుల గే, దస్సి ఆఁవ్ చి యోహాను కిచ్చొ కెర్లె కి, తుమ్ మెన్సుస్ నాయ్. ");
INSERT INTO key_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","కిచ్చొక ఆఁవ్ ఇసి టాలి కెర్తసి మెలె, యోహాను చువ్వె తన్నె తతొసొచి రిసొ, ‘జోక బూతుమ్ దెర అస్సె’ మెన సంగితె తిల. ");
INSERT INTO key_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ఆఁవ్, జలె, మాన్సు జా జెర్మున్ అయ్‍లొసొ, మాములుమ్ కతె పితె తతిస్‍చి రిసొ కిచ్చొ మెంతతి మెలె, ‘ఆదె, కయ్‍రొ మత్వాలొ ఈంజొ. సిస్తు నఙితస తెన్ పాపుమ్ కెర్లస తెన్ బెదితొసొ’ మెన అంక నిస్కారుమ్ సంగితతి. గని ఎక్కిలొచి పెట్టి చెంగిల్ తెంతొ చి బుద్ది తిలె, జోచ కమొచి పలితుమ్‍తె రుజ్జు జయెదె” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","యేసు జా గలిలయ ప్రాంతుమ్‍తెచ సగుమ్ పట్నల్‍తె ఒగ్గర్ ఒగ్గర్ అద్బుతుమ్ కమొ కెర్లన్. ఈంజేఁవ్ కమొ జోచి అదికారుమ్‍క రుజ్జు దెకయ్‍లెకి, ఒత్త తిల మాన్సుల్ జేఁవ్ కెర్ల పాపల్‍చి రిసొ దుకుమ్ జతి నాయ్, ములితి నాయ్. జాచి రిసొ, యేసు ఇసి మెన జోవయింక గోల కెరుక దెర్లన్: ");
INSERT INTO key_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“అయ్యొ! కొరాజీనా పట్నుమ్‍తెచ చి బేత్సయిదా పట్నమ్‍తెచ, తుమ్‍చి సిచ్చ పిట్టె నాయ్! తుమ్‍చి నెడిమి కెర్ల కమొ అమ్‍చ యూదుల్ నెంజిల తూరు చి సీదోను మెల పట్నల్‍తె ఆఁవ్ కెర్తయ్ జలె, జేఁవ్ పట్నల్‍చ మాన్సుల్ అగ్గెయి జేఁవ్ కెర్ల పాపల్‍క దుకుమ్ జా, ములిత. జేఁవ్ కెర్ల పాపల్‍చి దుకుమ్‍చి రుజ్జుక బస్తల్ బందన సార్ గాంసంత. ");
INSERT INTO key_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","పూర్గుమ్ జేఁవ్ తూరు పట్నుమ్‍చ కి సీదోను పట్నుమ్‍చ కి ఒగ్గర్ పాపుమ్ కెర్తె తిలె కి, ఈంజ లోకుమ్‍చ ఎత్కిజిన్‍క వెల్లి తీర్పు కెర్తి జా దీసిక, తూమ్ జతి సిచ్చ జేఁవ్ పట్నల్ జతి సిచ్చచి కంట ఒగ్గరి జయెదె, మెన తుమ్‍క ఆఁవ్ కచితుమ్ సంగితసి. ");
INSERT INTO key_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“పడ్తొ, తుమ్ కపెర్నహూమ్ పట్నుమ్‍తెచ, తుమ్ పరలోకుమ్‍తె ఉక్కిల్ జస్తె గే? నాయ్. తుమ్ మొర్లస రకితి టాన్‍తె ఉత్ర గెతె. కిచ్చొక మెలె, తుమ్‍చితె ఇస వెల్లొ కమొ అమ్‍చ యూదుల్ నెంజిలి సొదొమ పట్నుమ్‍తె పూర్గుమ్ కెర తత్తయ్ జలె, ఒత్త తిలస నంపజత, చి జా పట్నుమ్ నాసెనుమ్ నే జతె, ఆజి ఎద తత్తి. ");
INSERT INTO key_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","సొదొమ పట్నుమ్‍చ మాన్సుల్ ఒగ్గర్ పాపుమ్ కెర్తె తిలె కి, ఈంజ లోకుమ్‍చ మాన్సుల్‍క వెల్లి తీర్పు కెర్తి దీసిక, తూమ్ జతి సిచ్చ జా పట్నుమ్‍చ జతి సిచ్చచి కంట ఒగ్గరి జయెదె, మెన ఆఁవ్ తుమ్‍క సంగితసి.” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","తెదొడి యేసు కిచ్చొ సంగిలన్ మెలె, “పరలోకుమ్‍క కి బూలోకుమ్‍క కి అదికారుమ్ తిలొ ఓ అబ్బొ, ‘జానుమ్’ మెన జేఁవ్‍క జెఁవ్వి గవురుమ్ ఉచరంతసక చి ఒగ్గర్ సదు కెర్లసక ఈంజ జర్గు జతిసి ఎత్కిచి అర్దుమ్ లుంకడ, బాలబోదల్ జల రిత గవురుమ్ నెంజిలసక అర్దుమ్ దెకవ అస్సిసి మెన తుక జొఒర, మెన అంచి సర్ద జతసి. ");
INSERT INTO key_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","తుచి దయ తెన్ ఇసి కెర్లది” మెన ప్రార్దన కెర్లన్. దస్సి ప్రార్దన కెర, అన్నె ఇసి మెన సంగిలొ. ");
INSERT INTO key_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“అంచొ అబ్బొ ఎత్కి అంచి అత్తి సొర్ప కెర దా అస్సె. అన్నె, అబ్బొ ఎక్కిలొయి ఆఁవ్ పుత్తుస్‍క సరిగా జానె అన్నె కో కి నేన్‍తి. పడ్తొ, ఆఁవ్ పుత్తుసి అంక పిట్టవ కో కి అబ్బొక నేన్‍తి చి అన్నె కక్క ఆఁవ్ అబ్బొక దెకవుక మెన నిసాన్‍దె గే, జో కి జానెదె. ");
INSERT INTO key_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“స్రెమల్ బాదల్‍చ జాడ్లు వయ టక్క తిలస ఎత్కిజిన్ అంచితె జా, చి తుమ్‍చి జాడు ఆఁవ్ వయిలి రితి జా, తుమ్‍క పుండయిందె. ");
INSERT INTO key_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","అంచి తెన్ లంకె జా, చి అంచితె బుద్ది సిక్క. కిచ్చొక మెలె, ఆఁవ్ గవురుమ్ నే ఉచరంతె, పెట్టి అమ్మయికుమ్ తెన్ అస్సి, చి తుమ్‍చ ఆత్మల్‍తె పుండితె. ");
INSERT INTO key_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","కిచ్చొక మెలె, ఆఁవ్ గల్తి పూందు సుల్లు అస్సె, ఆఁవ్ వయడ్తి జాడు సుల్కన అస్సె” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","జా పొదులె, సెలవ్ కడన్లి దీస్‍తె, యేసుచి సిస్సుల్, పంటొ పికిలి బుఁయి వాట్ గెతె తిల. జలె, యేసుచ సిస్సుల్‍క చూ కెర్తికయ్. జా వాట్ సొడిచి పికిలి పంటొచ ఎన్నులు దొన్ని కోడ కంక దెర్ల. ");
INSERT INTO key_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","జలె, పరిసయ్యుల్ సగుమ్‍జిన్, జేఁవ్ సిస్సుల్ కెర్లిసి దెక కెర, “ఆదె, బక్తి కెర్తి సెలవ్ కడన్లి దీసి కెరుక నాయిమ్ నెంజిలిసి తుచ సిస్సుల్ కెర్తతి” మెన యేసుక గోల కెర్తికయ్, ");
INSERT INTO key_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","జో జోవయింక ఇసి మెలన్: “పూర్గుమ్ తిలొ దావీదు రానొ, జోక చి జో తెన్ తిలసక చూ కెర్తికయ్, జో కెర్లిస్‍చి రిసొ తుమ్ సదు కెర్సు నాయ్ గే? ");
INSERT INTO key_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","కిచ్చొ కెర్లిసి మెలె, దేముడుచి గుడితె జో పెసిలన్, చి ఒత్త తిల పూజర్లు అర్పితుమ్ దిల పోడియొ కయ్‍ల. జేఁవ్ పోడియొ పూజర్లు కంక జయెదె, గని అన్నె కో కంక జయె నాయ్. జో కి, జో తెన్ తిలస కి జా కంక నాయిమ్ నెంజిలె కి జేఁవ్ కయ్‍ల. ");
INSERT INTO key_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","పడ్తొ, ఎత్కి బక్తి కెర్తి సెలవ్ కడన్లి దీసి, దేముడుచ పూజర్లు దేముడుచి గుడితె సేవ కెర్తతి. జా సేవక ‘కామ్. సుద్ది దీసి పిట్టవ గార్ కెర్తతి మెన ఉచరుక జయెదె జలెకి, పాపుమ్ నెంజె’ మెన మోసే పూర్గుమ్‍చొచి అత్తి రెగిడ్లి దేముడుచ ఆగ్నల్‍తె తిలిసి సదు కెర్సు నాయ్ గే? ");
INSERT INTO key_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","జలె, ఆఁవ్ తుమ్‍క సంగితిసి కిచ్చొ మెలె, దేముడుచి గుడిచి కంట వెల్లొ సుదొ ఇన్నె అస్సె. ");
INSERT INTO key_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","‘తుమ్ కిచ్చొ కెర్తిసి అంక ఆస మెలె, బలి దెతిసి నాయ్, గని మాన్సుల్‍క కన్కారుమ్ దెకితిసి’ మెన తెదొడి సంగిలి కోడు తుమ్ అర్దుమ్ కెరంతదు జలె, పాపుమ్ నే కెర్ల ఈంజేఁవ్ సిస్సుల్‍క ‘పాపుమ్ కెర్ల’ మెన, నింద కెర్తదు నాయ్. ");
INSERT INTO key_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","సెలవ్ కడన్లి దీసిచి ఉప్పిరి ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొక అదికారుమ్ అస్సె.” మెన, జేఁవ్ పరిసయ్యుల్‍క యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","యేసు ఒత్త తెంతొ గెచ్చ, జా కపెర్నహూమ్ పట్నుమ్‍తెచి సబ గెరి పెసిలొ. ");
INSERT INTO key_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ఓదె, ఆతు లంబ గెలొసొ ఎక్కిలొ ఒత్త తిలన్. జేఁవ్ పండితుల్, కి, జో బాద తిలొ మాన్సు అస్సె మెన దెక కెర, యేసుక నేరిమ్ వయడుక ఉచర, “సెలవ్ కడన్లి దీసి ఏక్ బాద తిలొ మాన్సుక చెంగిల్ కెరుక నాయిమ్ గే, నాయ్?” మెన జోక పుసిల. ");
INSERT INTO key_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","జో జోవయింక, “తుమ్‍చితె కేన్ మాన్సుక జలెకు ఎక్కి మెండ జవుస్ తిలెగిన, జా మెండ బక్తి కెర్తి సెలవ్ కడన్లి దీసి ఏక్ గొయితె సేడ తిలెగిన, జో ఎజొమాని జాక జా గొయి తెంతొ కడె నాయ్ గె? ");
INSERT INTO key_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","జలె, మెండచి కంట మాన్సు ఒగ్గర్ విలువ. జాకయ్, సెలవ్ కడన్లి దీసి కి మాన్సుక చెంగిల్ కెరుక నాయిమి” మెన జబాబ్ దా, ");
INSERT INTO key_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","యేసు జో ఆతు లంబిలొసొక దెక, “తుచి ఆతు చంపొ కెరు” మెలన్. జో మాన్సు ఆతు చంపొ కెర్లన్, చి ఈంజొ ఆతు బేగి అన్నెక్ చెంగిల్ తిలి ఆతుచి రితి చెంగిల్ జలి. ");
INSERT INTO key_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","గని యేసు దస్సి కెర్తికయ్, పరిసయ్యుల్ కిచ్చొ కెర్ల మెలె, బార్ జా కెర, యేసుక కీసి మారుక గే కుట్ర ఉచరన లట్టబన్ల. ");
INSERT INTO key_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","జేఁవ్ పరిసయ్యుల్ ఉచర్లిసి యేసు జానెచి రిసొ, ఒత్త తెంతొ ఉట్ట గెలన్. ఒగ్గర్ ఒగ్గర్‍జిన్ జనాబ్ జోచి పట్టి గెల, చి జోవయింతె జొర్జొ తిలస ఎత్కిజిన్‍క జో చెంగిల్ కెర, ");
INSERT INTO key_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","“అంచి రిసొ తుమ్ కేనె తెర్లె ఒత్త సంగ నాయ్” మెన, జేఁవ్ ప్రెజల్‍క ఆడ్ర దిలన్. ");
INSERT INTO key_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ఈంజ ఎత్కి కిచ్చొక జర్గు జలి మెలె, దేముడుచ కబుర్లు సంగిలొ యెసయా పూర్గుమ్‍చొచి అత్తి సంగిలి కోడ్ నెరవెర్సుప జతి రిసొయి. ");
INSERT INTO key_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“ఈంజొ, ఆఁవ్ నిసాన్ల అంచొ సేవ కెర్తొసొ, ఈంజొ ఆఁవ్ ప్రేమ కెర్లొసొ, చి రిసొ అంక పూర్తి సర్దసంతోసుమ్. ఇనాచి పెట్టి అంచి ఆత్మ తియిఁదె, చి ‘యూదుల్ నెంజిల మాన్సుల్ కి రచ్చించుప జంక జయెదె’ మెన సూనఎదె. ");
INSERT INTO key_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ఈంజొ పోటి జయె నాయ్. గగ్గొల్ జయె నాయ్, అన్నె, గవురుమ్ ఆనన్‍తి రితి వీదులె గట్టిఙ లట్టబ జోచి అవాడ్ సూనయె నాయ్. ");
INSERT INTO key_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","జలె, ఆకర్ దీసిక సత్తిమ్ తెన్ ఎత్కిక పరిచ్చ కెర తీర్పు కెర, సిచ్చల్ గే బవుమానల్ గే దెతి ఎద, కామ్‍క నెంజిలి పీరి గండక జో మోడ కెర వెంట గెల్తి నాయ్. సరిపుచుప జతి ఉజిడి నే దెతి వత్తి జో నే విజవ దెవుల. ");
INSERT INTO key_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","పడ్తొ, ఇనాచి నావ్‌చి తెడి యూదుల్ నెంజిలస దయిరిమ్ జా ఆస జవుల” మెన, దేముడు సంగిలి కోడు నెరవెర్సుప జలి. ");
INSERT INTO key_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","తెదొడి బూతుమ్ దెర్లి రిసొ గుడ్డి జా గుల్లొ జా తిలొ మాన్సుక ఒత్త తిల మాన్సుల్ యేసుతె కడ ఆన్‍తికయ్, యేసు జోక చెంగిల్ కెర్లన్. జో మాన్సు లట్టబుక దెర్లొ చి అంకివొ డీసిల. ");
INSERT INTO key_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ఇస్సె జలి రిసొ, ప్రెజల్ ఎత్కి ఆచారిమ్ జా, “ఈంజొ యేసు కొన్సొ? దావీదు రానొచి సెకుమ్‍తె జెర్ముక తిలొ రచ్చించుప కెర్తొసొ ఈంజొ ఏక్ వేల జయెదె గే?” మెన లట్టబ్‍క దెర్ల. ");
INSERT INTO key_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","పరిసయ్యుల్, జా కోడు సూన కోపుమ్ జా. “బూతల్‍క రానొ జలొ బయెల్జెబూల్‍చి నావ్ తెన్ ఈంజొ బూతల్‍క ఉదడ్తయ్” మెన గోసక సంగిల. ");
INSERT INTO key_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","గని జేఁవ్ ఉచర్లిసి యేసుక జానెచి రిసొ, ఇసి మెలన్. “కేన్ జవుస్ రాజిమ్‍తెచ మాన్సుల్, జోవయింక జెఁవ్వి విరోదుమ్ జా వర్స వర్స జా యుద్దుమ్ కెరన్లె, జా రాజిమ్ పాడ్ జా గెచ్చెదె. కేన్ పట్నుమ్ జవుస్ కేన్ గేరు జవుస్ మాన్సుల్ వర్స వర్స జా జోవయింక జెఁవ్వి విరోదుమ్ కెరన్లె, జా పట్నుమ్ జవుస్, గేరు జవుస్ టీఁవొ జయె నాయ్. ");
INSERT INTO key_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","దస్సి, సయ్‍తాన్‍చక సయ్‍తాన్ ఏక్ వేల ఉదడ గెలెగిన, జోవయింక జొయ్యి యుద్దుమ్ కెర్తయ్, జోవయింక జొయ్యి యుద్దుమ్ కెర్లె, జోచి రాజిమ్ కీసి జా టీఁవొ జయెదె? ");
INSERT INTO key_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ఆఁవ్ ఏక్ వేల బయెల్జెబూల్‍చి నావ్ తెన్ బూతల్‍క ఉదడ్లెగిన, తుమ్‍చ సిస్సుల్ కచి నావ్ తెన్ ఉదడ్తతి? బూతల్‍క ఉదడ్త తుమ్‍చయ్ సిస్సుల్ అంచి రిసొ తుమ్‍క తీర్పు సంగుతు! ");
INSERT INTO key_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","దేముడుచి సుద్ది తిలి ఆత్మసెక్తిక ఆఁవ్ బూతల్‍క ఉదడ గెల్తసి జలె కచితుమ్ దేముడుచి రాజిమ్ తుమ్‍తె అప్పె పాఁవ జా అస్సె. ");
INSERT INTO key_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“అన్నెక్ టాలి ఉచర, కిచ్చొ మెలె, కేన్ జవుస్ బలుమ్ సుదొచి గెరి పెస జోచి ఆస్తి దెర గెచ్చుక చోరు ఉచర్లెగిన, తొలితొ జో చోరు జో బలుమ్ సుదొక నే బంద తిలెగిన, చోరుక నెత్రె. జో బలుమ్ సుదొక తొలితొ బందిలెగిన, గెరిచి సామన్ జో చోర గెలుక జయెదె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","దస్సి సంగ, యేసు అన్నె, “కో అంచి పచ్చెన జయె నాయ్ గే, అంక విరోదుమ్ జా అస్సె, చి అంచి రాజిమ్‍తె జేఁవ్ బెదిత్ రితి కో అంచి తెన్ మాన్సుల్‍క ఆనె నాయ్ గే అంచి మందక చెదుర్ప కెర్తయ్. ");
INSERT INTO key_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“జలె, ఆఁవ్ తుమ్‍క సంగితిసి కిచ్చొ మెలె, ఎక్కిక పిట్టవ మాన్సుల్ కెర్త పాపల్ దూసెనల్ ఎత్కి జోవయింక చెమించుప కెరుక జయెదె. గని, దేముడుచి సుద్ది తిలి ఆత్మక దూసుప కెర్తిసి చెమించుప జయె నాయ్. ");
INSERT INTO key_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","కో గడియ బమ్మ జా ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొచి రిసొ అన్మానుమ్ కోడ్ లట్టబెదె గే, జోవయింక చెమించుప కెరుక జయెదె. గని దేముడుచి సుద్ది తిలి ఆత్మక కో దూసుప కెరుల గే, ఈంజ ఉగుమ్‍తె కి జా ఉగుమ్‍క కి చెమించుప జతి నాయ్. ");
INSERT INTO key_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“రూక్‍చి పండ్లు చెంగిల్‌చి జలె, జా రూకుక చెంగిల్ మెన ఒప్పన. రూక్‍చి పండ్లు గర్చి జలె, జా రూకుక గర్చొ మెన ఒప్పన. రూక్‍చి పండ్లు దెకిలెగిన, జా రూకుక చెంగిల్ గే, గర్చొ గే చినుక జయెదె. ");
INSERT INTO key_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","పెట్టి అయివొచి రితి విస్సుమ్ తిల మాన్సుల్, తుమ్. తుమ్‍చి పెట్టి విస్సుమ్ తిలి రిసొ తుమ్ కీసి చెంగిల్‌చి లట్టబుక జయెదె! పెట్టితె తిలి బుద్దిచి కొల్ది చోండి లట్టబెదె. ");
INSERT INTO key_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","చెంగిల్ మాన్సు జోచి చెంగిల్ బుద్ది బెర్తుచి కొల్ది చెంగిల్‌చి బార్ కెరెదె. గర్చొ మాన్సు జోచి పెట్టిచి విస్సుమ్‍చి బెర్తుచి కొల్ది విస్సుమ్ బార్ కెరెదె. ");
INSERT INTO key_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ఆఁవ్ తుమ్‍క సంగితిసి కిచ్చొ మెలె, ఈంజ లోకుమ్‍చ ఎత్కిక వెల్లి తీర్పు కెర్తి దీసిక మాన్సుల్ లట్టబ్లి ఎత్కి కామ్‍క నెంజిలి కోడుచి రిసొ నేరిమ్ వయుల. ");
INSERT INTO key_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","తుమ్‍చ కొడొ తుమ్‍చి పెట్టి తిలిస్‍క సాచి జలి రిసొ నీతి సుదొ గే, నెంజిలె పాపుమ్ సుదొ గే బార్ కెరెదె.” మెలన్. ");
INSERT INTO key_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","తెదొడి పరిసయ్యుల్ చి మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస సగుమ్‍జిన్ యేసుక, “గురుబాబు, దేముడుచి అదికారుమ్ తుక అస్సె మెన రుజ్జు దెకయ్‍తి వెల్లి కామ్ ఏక్ అప్పె కెరు. దెకుమ్‍దె” మెన యేసుక సంగిల. ");
INSERT INTO key_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","గని, జో జోవయింక కిచ్చొ జబాబ్ దిలన్ మెలె, “ప్రబుక నిదానుమ్ నెంజ లంజెబుద్ది పాపుమ్‍బుద్ది జల తుమ్ ఈంజ కాలుమ్‍చ మాన్సుల్, రుజ్జు దెకయ్‍త కమొక కోర్‍ప జతసు. అంచి అదికారుమ్ దెకయ్‍తి రిసొ ఎక్కి పిట్టవ, కేన్ వేర కామ్ కెర దెంక నెంజె. జా రుజ్జుచి కామ్ కీసిచి జయెదె మెలె, దేముడుచ కబుర్లు పూర్గుమ్ సంగిలొ యోనాక జర్గు జలిస్‍చి రితి జయెదె. ");
INSERT INTO key_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","మెలె, యోనా కీసి తిర్రతి అందరె మెద్దెనె సముద్రుమ్‍చి వెల్లి మొస్సొచి పెట్టి తిలన్ గె, దస్సి, మాన్సు జా జెర్మున్ అయ్‍లయ్ ఆఁవ్ తిన్ని అందర్లు తిన్ని మెద్దెనె బుఁయి తెడి తయిందె. ");
INSERT INTO key_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","అన్నె, ఈంజ లోకుమ్ ఎత్కిక వెల్లి పరిచ్చ కెర్తి దీసిక, తుమ్ ఈంజ కాలుమ్‍చ అన్మానుమ్ జల యూదుల్ కి, యోనా బోదన కెర్ల నీనెవె పట్నుమ్‍చ ప్రెజల్ కి, బెద టీఁవొ జా, జేఁవ్ తుమ్‍క ‘గర్చ’ మెన రుజ్జు దెకవుల. కిచ్చొక మెలె, జా పట్నుమ్‍చ మాన్సుల్ యోనా కెర్లి బోదన సూన కెర, జేఁవ్ కెర్ల పాపల్‍చి రిసొ దుకుమ్ జా, నంపజా, బుద్ది జల. ఈందె, యోనాచి కంట వెల్లొ తుమ్‍చి నెడిమి అస్సె. ");
INSERT INTO key_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","పడ్తొ, వెల్లి తీర్పు కెర్తి జా దీసిక, దచ్చెన దేసిమ్‍చి పూర్గుమ్ తిలి రాని ఎక్లి ఈంజ కాలుమ్‍చ మాన్సుల్ తెన్ టీఁవొ జా, తుమ్‍క ‘గర్చ’ మెన రుజ్జు దెకయెదె. కిచ్చొక మెలె, పూర్గుమ్ జా రాని ‘సొలొమోను రానొ సంగితి బుద్దిచి కోడు సూనిందె’ మెన, ఒగ్గర్ ఒగ్గర్ దూరి తెంతొ అయ్‍లి. గని, ఈందె, సొలొమోనుచి కంట వెల్లొ సుదొ తుమ్‍చి నెడిమి అస్సె. ");
INSERT INTO key_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“ఏక్ మాన్సుక బూతుమ్ దెర తిలెగిన, జా బూతుమ్ జో మాన్సుచి తెంతొ ముల దా తత్తిచి రిసొ టాన్ చజన, బయిలె గెచ్చ బుల్తె తయెదె, గని, టాన్ నే దొర్కు జలి రిసొ, ");
INSERT INTO key_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","జో ఉచరన, ఆఁవ్ ముల దిలొ గెరి అన్నె గెచ్చిందె మెన, జా గేర్ విడి అస్సె మెన, జా గెర్‍చొ మాన్సు వడ్డవ కెర సుబ్రుమ్ కెర అస్సె మెన దెక కెర, ");
INSERT INTO key_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","అన్నె గెచ్చ, జాచి కంట గర్చ సత్తు బూతల్‍క పట్టి కడ ఆనెదె, చి జేఁవ్ ఎత్కి జో మాన్సుచి తెడి పెస కెర, ఒత్తయ్ బస జవుల. జాచి రిసొ, జో మాన్సుక అగ్గెచి కంట, ఆకర్‍క ఒగ్గర్ అల్లర్ తయెదె. గర్చి బుద్దిచి ఈంజ కాలుమ్‍చ మాన్సుల్ తెన్ దస్సి జయెదె.” మెన, యేసు బోదన కెర్లన్. ");
INSERT INTO key_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","యేసు ప్రెజల్‍క అన్నె బోదన కెర్తె తతికయ్, ఈందె, జోచి అయ్యసి బావుడ్సివొ జా కెర, ‘జో తెన్ లట్టబుమ్‍దె’ మెన వీదె టీఁవొ జా తిల. ");
INSERT INTO key_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","తెదొడి ఎక్కిలొ “ఈందె, తుచి అయ్యది తుచ బావుడ్దివొ తుచి తెన్ లట్టబుక మెన వీదె టీఁవ అస్తి” మెన యేసుక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","జోక సంగిలొ మాన్సుక యేసు “కొన్సి అంక అయ్య, కొన్స అంక బావుడ్లు జవుల గే జాన్సు గే?” మెన సంగ, ");
INSERT INTO key_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","జోచి సిస్సుల్ తిలి పక్క ఆతు చంప కెర, “ఈందె, అంచి అయ్య, అంచ బావుడ్లు. ");
INSERT INTO key_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","కిచ్చొక మెలె, పరలోకుమ్ తిలొ అంచొ దేముడు అబ్బొ సంగిలి రితి కో కెరుల గే, జెఁవ్వి అంచ బావుడ్లు, అంచ బేనివొ, అంచి అయ్య” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","జా దీసి, యేసు గెరి తెంతొ బార్ జా, సముద్రుమ్‍చి ఒడ్డుతె గెచ్చ, వెసిలన్. ");
INSERT INTO key_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ఒగ్గర్ ఒగ్గర్‍జిన్ జనాబ్ జోతె జా కెర, సుట్టునంత బెర పెలపెలి జలి రిసొ, జో ఏక్ దోనితె వెగ వెసిలన్. అన్నె బెర తిల మాన్సుల్ ఎత్కిజిన్ సముద్రుమ్‍చి ఒడ్డుతె టీఁవొ జా తతికయ్, ");
INSERT INTO key_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","యేసు జోవయింక దెక దెక, బోదన కెర్తి రిసొ ఒగ్గర్ టాలివొ సంగుక దెర్లన్. “ఈందె, ఉంపితొసొ ఎక్కిలొ బీ ఉంపుక బార్ జలన్. ");
INSERT INTO key_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","జో ఉంపితె తతికయ్, సగుమ్ బీ బయిలె వాట్ పక్క సేడ్తికయ్, పిట్టల్ ఉత్ర జా, జా బీ కాఁ గెల. ");
INSERT INTO key_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","అన్నె సగుమ్ బీ ఒగ్గర్ మత్తి నెంజిలి పత్తురు బుఁయ్యె సేడ్లన్. ఉప్పిరి ఇదిలిదిల్ మత్తి తిలి రిసొ, ఒత్త సేడ్లి బీ బేగి గజ్జల్ జలి ");
INSERT INTO key_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ఒప్పడ్ లయితికయ్, మొక్కల్ డడ్డ గెల. చి చెర్రొ బుఁయి తెడి పెస వడ్డుక నెతిర్లి రిసొ, జేఁవ్ మొక్కల్ సుకా గెచ్చ, మొర గెల. ");
INSERT INTO key_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","అన్నె సగుమ్ బీ కంట మొక్కల్ తిలిస్‍తె సేడ గజ్జల్ జా మొక్కల్ జల. గని ఒత్త తిల కంట మొక్కల్ వడ్డ కెర, ఒత్త సేడ్లి బీచ మొక్కల్‍క పెల గెల్తికయ్, జేఁవ్ మొక్కల్ పలితుమ్ దెర్తి నాయ్. ");
INSERT INTO key_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","గని అన్నె సగుమ్ బీ చెంగిల్ బుఁయ్యె సేడ కెర, కేన్ మొక్క పుంజెక్ వంతుల్, అరవయ్ వంతుల్, ముప్పయ్ వంతుల్, పలితుమ్ దిల. ");
INSERT INTO key_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","సూన్‍త కంగ్డొ తిలస, సూన” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","పడ్తొ యేసుచ సిస్సుల్ జోతె జా కెర, “తుయి కిచ్చొక టాలివొ సంగయ్ ప్రెజల్‍క బోదన కెర్తసి?” మెన జోక పుసిల. ");
INSERT INTO key_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","యేసు జోవయింక, “పరలోకుమ్‍చి రాజిమ్‍చి రిసొచి గుట్టుల్ జానన్‍క తుమ్‍క సెలవ్ దా అస్సె. గని జోవయింక జా సెలవ్ నాయ్. ");
INSERT INTO key_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","కిచ్చొక మెలె, తిలొసొక అన్నె దెంక జయెదె, చి జోక ఒగ్గర్ కలుగు జయెదె. గని, నెంజిలొసొ జలె, జోక తిలిసి కి జోతె తెంతొ కడ నెంక జయెదె. ");
INSERT INTO key_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","జేఁవ్ ప్రెజల్ దెక నే దెకిలి రితి, సూన నే సూన్లి రితి, అర్దుమ్ కెరంతి నాయ్. ఇసిచి రిసొ ఆఁవ్ టాలివొ కెరయ్ జోవయింక బోదన కెర్తసి. ");
INSERT INTO key_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","జేఁవ్ నంప నే జతిస్‍చి రిసొ యెసయాచి అత్తి పూర్గుమ్ దేముడు సంగిల్ కోడ్ కచితుమ్ నెరవెర్సుప జతయ్. తుమ్ నిజుమ్ సొంత సూన్లె కి, కచితుమ్ కెఁయఁక అర్దుమ్ కెరన్సు నాయ్, నిజుమ్ సొంత దెకిలెకి, కచితుమ్ అర్దుమ్ చినుస్ నాయ్. ");
INSERT INTO key_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","కిచ్చొక మెలె, ఈంజ ప్రెజల్‍చి పెట్టి బేడు బంద అస్సె, ఇనాచి కంగ్డల్ దిమ్మల్ డంకి జలి రితి జా అస్సె. ఇనయించ అంకివొ డంకన్లి రితి జా అస్తి. నెంజిలె, ఇనయించ అంకివొ దెక చినిత, ఇనయించ కంగ్డల్ సూన సూనిత, చి ఇనాచి పెట్టి అర్దుమ్ కెరంత, చి ఆఁవ్ ఇన్నెక చెంగిల్ కెర్తి రితి పసుల కెర అంచితె జెత”. మెన జేఁవ్‍చి రిసొ సంగిలి కోడు. ");
INSERT INTO key_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“జలె, తుమ్ నంపజలసచ అంకివొ డీస్తతిచి రిసొ తుమ్‍క చెంగిలి. తుమ్‍క అర్దుమ్ సూన్‍త కంగ్డొల్ అస్తిచి రిసొ తుమ్‍క చెంగిలి. ");
INSERT INTO key_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","పూర్గుమ్‍చక చి కంట తుమ్‍క ఒగ్గర్ చెంగిలి మెన కచితుమ్ తుమ్‍క ఆఁవ్ సంగితసి. కిచ్చొక మెలె, పూర్గుమ్ దేముడుచ కబుర్లు సంగిలస ఒగ్గర్‍జిన్, సత్తిమ్ ఇండిలస ఒగ్గర్‍జిన్, తూమ్ దెకితిసి దెకుక జేఁవ్ కోర్‍ప జలెకి, దెకుక నెతిర్ల. తూమ్ సూన్‍తిసి సూనుక జేఁవ్ కోర్‍ప జలెకి, సూనుక నెతిర్ల. జా అవ్‍కాసుమ్ జోవయింక దొర్కు జయె నాయ్. ");
INSERT INTO key_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“ఉంపితొసొచి రిసొ సంగిలి టాలి తుమ్ అర్దుమ్ కెరన. ");
INSERT INTO key_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","కో జలెకు పరలోకుమ్‍చి రాజిమ్‍చి రిసొచి బోదన సూన అర్దుమ్ నే కెరన్లె, సయ్‍తాన్ జా కెర, జో మాన్సుచి పెట్టి ఉంపిలి జా బోదన ఉర్ల కెర దెర గెచ్చెదె. వట్టెచి ఉంపిలి బీ ఈంజ జయెదె. ");
INSERT INTO key_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","పత్రల్ బుఁయ్యె ఉంపిలిసి, కో జలెకు చి బోదన సూన్లి బేగి, సర్ద జా నంపజతసి మెనెదె, ");
INSERT INTO key_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","గని జోచి సొంత పెట్టి సుబుమ్ కబుర్‌చ చెర్రొ నెంజిలి రిసొ, జో జిలి రితి జా గడియ టీఁవొ జా తిలె కి, సుబుమ్ కబుర్ జో నంపజలిస్‍చి రిసొ కిచ్చొ జవుస్ బాద సేడ్లె జలెకు, నెంజిలె విరోదుమ్ జలస జోక అల్లర్ కెర్లె జలెకు, జో మాన్సు బమ్మ జా, బే బేగి నముకుమ్ ముల దెయెదె. ");
INSERT INTO key_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","కంట దుబ్బుల్ తిలి బుఁయ్యె ఉంపిలి బీ, కో జలెకు, చి బోదన సూన్లె కి, ఈంజయ్ లోకుమ్‍తె తిలిసి ఎత్కిక ఉచర్తె తా, కీసి జా జియిందె? మెన చింత గలనెదె జలెకు, సొమ్సారుమ్ జంక ఆస జయెదె జలెకు, దస్సి, జా ఆస జవుస్, జా చింత జవుస్, జా బోదనక పెలగెలి రితి జతయ్‍చి రిసొ జా బోదన జోతె పలితుమ్ దెరె నాయ్. ");
INSERT INTO key_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","గని, చెంగిలి బుఁయ్యె ఉంపిలి బీ, చి బోదన సూన కో అర్దుమ్ కెరనెదె గే, జో మెలె, చెంగిలి బుఁయ్యె ఉంపిలి బీతె కేన్ గిడ్డ పుంజెక్ వంతుల్, అరవయ్ వంతుల్, ముప్పయ్ వంతుల్ కీసి పలితుమ్ దెరుల గే, దస్సి, సూన అర్దుమ్ కెరంతొ మాన్సు తమ్మస పలితుమ్ దెరెదె” మెన యేసు బోదన కెర్లన్. ");
INSERT INTO key_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","యేసు ప్రెజల్‍క సంగిలి అన్నెక్ టాలి ఇసి జలి. “పరలోకుమ్‍చి రాజిమ్ తెన్ కీసి మెలె, జోచి వెడయ్ చెంగిల్ గోదుమ్‍చి బీ ఉంపిలిస్‍చి ఏక్ మాన్సు రితి జతయ్. ");
INSERT INTO key_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","మాన్సుల్ నిజ గెల తతికయ్, జో ఉంపిలొసొచొ విరోదుమ్‍చొ జా కెర, జా చెంగిల్ బీ ఉంప తిలిస్‍తె వెర్రి గిడ్డల్ ఉంప దా, ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","చెంగిల్ బీచ మొక్కల్ ఉట్ట వడ్డ ఎన్నులు దెర్లి పొది, జేఁవ్ వెర్రి మొక్కల్ కి డీసిల. ");
INSERT INTO key_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","జో ఉంపిలొ ఎజొమానితె జోచ గొత్తి సుదల్ జా కెర, ‘బాబు, తుయి తుచి వెడయ్‍తె చెంగిలి బీ ఉంపిలది. జలె కీసి ఒత్త వెర్రి మొక్కల్ కి ఉట్ట అస్తి?’ మెన పుసితికయ్, ");
INSERT INTO key_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","జో జేఁవ్‍క, ‘ఈంజ కో గే విరోదుమ్‍చొ కెర్లి కామ్ జయెదె’ మెన సంగిలన్. జోచ గొత్తి సుదల్ జోక, ‘దస్సి జలె, అమ్ వెడయ్ గెచ్చ జేఁవ్ వెర్రి మొక్కల్ కడ గెలుక తుక ఇస్టుమ్ గే?’ మెన పుసిల. ");
INSERT INTO key_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","దస్సి జో, ‘పోన. జేఁవ్ వెర్రి మొక్కల్ అప్పె కడ్లెగిన, ఏక్ వేల జోవయింతెన్ ఎక్కె దడి గోదుమ్‍చ మొక్కల్ కి బెదవ కడితె. అప్పె పోన. ");
INSERT INTO key_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","లాయితి కాలుమ్ ఎద దొన్ని కి బెద వడ్డుతు. లాయితె పొదిక, వెర్రి మొక్కల్ తొలితొ కడ కెర, డయ గెల్తి రిసొ కట్టల్ బందిలి పడ్తొక, గోదుమ్ లాయ కెర అంచి కొట్టుతె ఆన’ మెన లాయితసక సంగిందె. మెన జో ఎజొమాని సంగిలన్” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","యేసు జోవయింక అన్నెక్ టాలి సంగిలన్. “పరలోకుమ్‍చి రాజిమ్ ఏక్ మాన్సు జోచి పట్టయ్ ఉంపిలి సొర్సుగిడ్డచి రితి జతయ్. ");
INSERT INTO key_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","గిడ్డల్ ఎత్కిచి కంట జా గిడ్డ ఇదిలిసి డీసిలెకి, జా మొక్క వడ్డిలి మెలె, రోస్‍తె గల్తి మొక్కల్ ఎత్కిచి కంట వెల్లొ జా, రూకు జయెదె, చి ఆగాసుమ్‍చ పిట్టల్ జా కెర, జో చెట్టెచ కొమ్మల్‍తె గూడల్ బందుల” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","యేసు జోవయింక అన్నెక్ టాలి సంగిలన్. “పరలోకుమ్‍చి రాజిమ్ తెన్ కీసి మెలె, అన్నిమ్ కెర్తి పీట్ ఎత్కి పొంగుప జా పులితి రిసొ, ఏక్ తేర్‍బోద ఏక్ తీనడి పీట్‍తె గలిలి పులయ్‍తి పీట్‍చి రితి జతయ్. ఇదిలిదిల్ గలిలెకి, జా కలొయ్‌లి సామన్ ఎదివాట్ పుల కెర ఒగ్గర్ జయెదె”, మెన, యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ప్రెజల్‍క సంగితి బోదన ఎత్కి టాలివొ తెన్ యేసు సంగితె తిలన్. టాలివొ నెంతె జేఁవ్ ప్రెజల్‍క జో కిచ్చొ సంగె నాయ్. ");
INSERT INTO key_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ఇసి, దేముడు జోచ కబుర్లు సంగిలొ ఎక్కిలొచి అత్తి రెగిడ్లి కోడ్ నెరవెర్సుప జలి. “టాలివొ సంగ ఆఁవ్ అంచి చోండి పుట్టయిందె, చి బూలోకుమ్ జెర్మున్ జలి మొదొల్ తెంతొ లుంకడ్లిసి సంగిమ్‍దె” మెన రెగిడ్లి కోడు. ");
INSERT INTO key_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","తెదొడ్ యేసు ప్రెజల్‍చి జనాబ్‍క ముల దా, గెరి గెలన్. జోచ సిస్సుల్ జోతె జా కెర, “బట్టిచ వెర్రి మొక్కల్‍చి రిసొ సంగిలి టాలి అమ్‍క అర్దుమ్ సంగు” మెన పుసితికయ్, ");
INSERT INTO key_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","జో జోవయింక ఇసి మెలన్. “చెంగిల్ బీ ఉంపితొసొ కొన్సొ మెలె, ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ. ");
INSERT INTO key_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","బాటి కిచ్చొ మెలె, ఈంజ లోకుమ్. చెంగిల్ బీ కిచ్చొ మెలె, పరలోకుమ్‍చి రాజిమ్‍చ బోదల్ జల మాన్సుల్. వెర్రి మొక్కల్ కిచ్చొ మెలె, సయ్‍తాన్‍చ బోదల్ జల మాన్సుల్. ");
INSERT INTO key_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","జా వెర్రి బీ ఉంపితొసొ కొన్సొ మెలె, సయ్‍తాన్. పంటొ లాయితి పొది కెఁయఁక మెలె, ఈంజ ఉగుమ్ పూర్తి జతి ఆకర్ దీసి. లాయితస కొన్స మెలె, దేముడుచి దూతల్. ");
INSERT INTO key_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“వెర్రి మొక్కల్‍క కీసి కుడవ ఆగితె గలుక జయెదె గే, దస, ఈంజ ఉగుమ్ పూర్తి జతి పొదిక, దస్సి సిచ్చ తయెదె. ");
INSERT INTO key_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","జా పొదిక, ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ అంచ దేముడుచి దూతల్‍క తెద్రయిందె, చి పాపుమ్ కెరయ్‍తి వెట్కారుమ్‍చి ఎత్కిక కి, పాపుమ్ ఇండితస ఎత్కిక కి, ఈంజ లోకుమ్ తెంతొ కడ కెర, ఎక్కితె కుడవ కెర, ");
INSERT INTO key_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","జేఁవ్ దేముడుచి దూతల్ జోవయింక వెల్లి ఆగి గొయ్‍తె గల దెవుల. ఒత్త గలి జలస ఏడుల, దంతొ చప్పిల్తె తవుల. ");
INSERT INTO key_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","తెదొడ్‍క, పొద్దుచి ఉజిడి కెద్ది జతయ్ గే, దస్సి, అంక నంపజా పున్నిమ్ జలస జోవయించొ దేముడు అబ్బొస్‍చి రాజిమ్‍తె ఉజిడి జవుల. సూన్‍త కంగ్డొ తిలస సూన. ");
INSERT INTO key_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“పడ్తొ, పరలోకుమ్‍చి రాజిమ్‍క కిచ్చొ టాలి కెరుక జయెదె మెలె, ఏక్ వెడయ్‍తె లుంకడ తిలి దనుమ్‍చి రితి జయెదె. ఎక్కిలొ జా దనుమ్ చజ కెర, అన్నె లుంకడ కెర, జా దొర్కు జలి మెన, సంతోసుమ్ తెన్ గెచ్చ, జోక కలుగు జలిసి ఎత్కి విక గెల కెర, జా దనుమ్ రోవిలి వెడ గెనెదె. ");
INSERT INTO key_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“అన్నె, పరలోకుమ్‍చి రాజిమ్‍తె బెదితిసి చెంగిలి ముత్యల్ గెన్‍తొ సావుకరి కెర్లిస్‍చి రితి జతయ్. ");
INSERT INTO key_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","జో ఒగ్గర్ విలువచి ముత్యల్ ఏక్ చజ కెర, గెచ్చ, జోక కలుగు జలిసి ఎత్కి విక గెల కెర, జా ముత్యల్ గెనెదె. ");
INSERT INTO key_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“అన్నె, పరలోకుమ్ రాజిమ్‍తె బెదయ్‍తిసి కీసి మెలె, సముద్రుమ్‍తె గలిలి రగరగాల్‍చ మొస్స దెర్తి వలచి రితి జతయ్. ");
INSERT INTO key_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","జా బెరిలె పొది మాన్సుల్ జేఁక ఒడ్డుతె కడ కెర, వెస కెర, చెంగిలచ తిర్రితె బెరవ కెర, గర్చ బయిలె వెంట గెలుల. ");
INSERT INTO key_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","దస్సి, ఈంజ ఉగుమ్ పూర్తి జతి ఆకర్ దీసిక అమ్‍చ దేముడుచి దూతల్ జా కెర, నంపజా పున్నిమ్ జలసక ఏక్‍తె, నంపనెంజిల్ రిసొ గార్ జలసక వేరతె కుడవ తా, ");
INSERT INTO key_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","జేఁవ్ నంపనెంజిలసక వెల్లి ఆగి గొయ్‍తె గల దెవుల. ఒత్త గలి జలస ఏడుల, దంతొ చప్పిల్తె తవుల. ");
INSERT INTO key_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“ఈంజ ఎత్కిచి అర్దుమ్ కెరన్లదు గే నాయ్?” మెన యేసు జేఁవ్ సిస్సుల్‍క పుసిలన్, చి “అమ్‍క అర్దుమ్” మెల. ");
INSERT INTO key_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","జేఁవ్ దస్సి సంగితికయ్, యేసు జోవయింక “జలె, కేన్ జలెకు మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తొసొ, పరలోకుమ్‍చి రాజిమ్‍చి సుబుమ్ కబుర్ కామ్‍తె బెదితి రిసొ కో సిస్సుల్ జా జవుల గే, జో ఏక్ గెర్‍చొ ఎజొమాని కీసి జోచి దనదాన్యుమ్ తెంతొ నొవ పోర్న సామన్లు వెంట వాడిక కెరెదె గే, దస్సి అస్సె.” ");
INSERT INTO key_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","యేసు ఈంజేఁవ్ టాలివొ సంగ కేడయ్‍లి పడ్తొ, ఒత్త తెంతొ బార్ జా ఉట్ట గెచ్చ, ");
INSERT INTO key_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","జోచి సొంత గఁవ్వి పాఁవ కెర, జోవయించ సబ గెరలె బోదన కెరుక దెర్లొ. జో కెర్లి బోదన సూన ఆచారిమ్ జా, “ఈంజ గ్యానుమ్‍చి, ఈంజొ కెర్త కమొచి కెర్తి సెక్తి ఇన్నెక కేనె తెంతొ అయ్‍లి? ");
INSERT INTO key_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ఈంజొ మాములుమ్, ఈంజ గఁవ్విచొ దార్‍చ కామ్ కెర్తొసొచొ పుత్తుసి గెద? ఇన్నెచి అయ్యస్‍చి నావ్ మరియ గెద? అన్నె, యాకోబు, సీమోను అన్నె యూదా జోచ బావుడ్సివొ జవుల గెద? ");
INSERT INTO key_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ఇన్నెచ బేన్సివొ ఎత్కిజిన్ అమ్‍చి తెన్ అస్తి గెద? దస్సి జలె, ఇన్నెక ఈంజ గ్యానుమ్ ఎత్కి కేనె తెంతొ అయ్‍లి?” మెన లట్టబన్ల, ");
INSERT INTO key_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","యేసుచి రిసొ అన్మానుమ్ జా గెల. జేఁవ్ దస్సి జతికయ్, యేసు జోవయింక, “కేన్ జవుస్ మాన్సు దేముడుచి కబుర్ ఆన్‍తొసొ జలె, జోచి సొంత దేసిమ్‍చ మాన్సుల్ సొంత గెర్‍చ మాన్సుల్ జోక గవురుమ్ దెకిత్ నాయ్” మెన జోవయించి అన్మానుమ్‍చి రిసొ సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","జలె, జా గఁవ్విచ మాన్సుల్‍చి అన్మానుమ్‍చి రిసొ, యేసు ఒత్త వెల్లొ కమొ ఒగ్గర్ కెరె నాయ్. ");
INSERT INTO key_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","జా సమయుమ్‍తె, హేరోదు మెలొ జా గలిలయ ప్రాంతుమ్‍చొ అదికారి, యేసు కెర్త కమొచి రిసొ సూన తా, ");
INSERT INTO key_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","బియఁ కెర, జోచి గొత్తి సుదల్‍క బుకారా కెర, జోవయింక, “ఈంజొ యేసు, జో బాప్తిసుమ్ దెతె తిలొ యోహాను మొర గెచ్చ అన్నె జిఁయ అస్సె. జాచి రిసొ, ఇస వెల్లొ కమొ కెరుక జోక సెక్తి అస్సె” మెన ఉచర సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","కిచ్చొక జో అదికారి దస్సి బియఁ కెర ఉచర్లన్ మెలె, జోచొ పిలిప్ మెలొ అన్నొస్‍చి హేరోదియ మెలి తేర్సిక హేరోదు నెతికయ్, యోహాను జోక “తుయి జాక తియనుక నాయిమ్ నాయ్” మెన సంగితె తిలి రిసొ, జో అదికారి యోహానుక దెర, బందవడ, జేల్‍తె గల తిలన్. ");
INSERT INTO key_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","జోక మారుక ఉచర్లె కి, దేముడుచి కబుర్ సంగిలొసొ, మెన ప్రెజల్ యోహానుక ఉచర్లి రిసొ, జోవయింక బియఁ కెర, మారుక వాయిద కెర తిలన్. ");
INSERT INTO key_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","జలె, హేరోదుచి జెర్మున్ పండుగు దీసి అయ్‍లె, జోచి హేరోదియ మెలి తేర్సిచి దువిసి విందుతె బుకారా తిలసచి నెడిమి నచితికయ్, హేరోదు రానొ మెన్సిలన్, చి ");
INSERT INTO key_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","జో ఒట్టు గలన, “తుయి కిచ్చొ నఙిలె కి దెయిందె.” మెన జాక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","జా నాడిచి అయ్యసి సంగితికయ్, బెర్ల మాన్సుల్‍చి మొక్మె జా దువిసి, “బాప్తిసుమ్ దెతొ యోహానుచి బోడి, గండ కెరవ పలెరుమ్‍తె గల, అంక ఇత్తల్ ఆన దె” మెన రానొక సంగిలి. ");
INSERT INTO key_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ఈంజ కోడు సూన దుకుమ్ జలెకి, హేరోదు జేఁవ్ బుకార్ల మాన్సుల్‍చి మొక్మె ఒట్టు గల తిలి రిసొ, జా సంగిలిసి దెంక మెన ఒప్పన తిలొ, చి ");
INSERT INTO key_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","జమాన్లుక తెద్రవ కెర, “జేల్‍తె యోహానుచి బోడి కండ కెర దా” మెలొ. ");
INSERT INTO key_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","జో జమాను, దస్సి కెర, యోహానుచి బోడి పలెరుమ్‍తె గల ఆన నాడిక దెతికయ్, జా నాడి అయ్యస్‍క నా దిలి. ");
INSERT INTO key_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","యోహానుచ సిస్సుల్ జో మొర్లిస్‍చి సూన కెర, జా కెర, పీనుమ్ ఉక్కుల దెర గెచ్చ రోవ గెల, అన్నె యేసుతె జా కెర, జోక సంగిల. ");
INSERT INTO key_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","యోహానుక జర్గు జలిసి యేసు సూన కెర, దోనితె వెగ కెర, మాన్సుల్ నెంజిలి టాన్‍తె గెచ్చుక మెన సముద్రుమ్ జీన, ఉట్ట గెలన్. యేసు ములిలి ఏక్ తిల జనాబ్ ‘జో ఒత్తల్‍తొ గెతయ్’ మెన సూన కెర, పట్నల్‍తె గఁవ్విలె తెంతొ బార్ జా, ఇండ కెర, జోచి పట్టి గెల. ");
INSERT INTO key_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","యేసు జా ఒడ్డుతె పాఁవ కెర, ఒత్త బెర తిల పట్టి అయ్‍ల ప్రెజల్ ఎత్కిక దెక కెర, జోవయించి ఉప్పిరి కన్కారుమ్ జా, జోవయింతె జబ్బుల్ తిల మాన్సుల్ ఎత్కిక చెంగిల్ కెర్లన్. ");
INSERT INTO key_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","సాంజ్ జతికయ్, యేసుచ సిస్సుల్ జోతె జా కెర, “ఈంజ డొంగుర్ దేసిమ్ గెద, పొద్దు గెలి రిసొ, అన్నిమ్ సామన్ గెనన్‍తి రిసొ, ఈంజేఁవ్ ప్రెజల్‍క గఁవ్విలె తెద్రవు” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","యేసు జోవయింక, “జేఁవ్ గెచ్చుక నాయ్. తుమి జోవయింక కిచ్చొ జవుస్ అన్నిమ్ దాస” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","జేఁవ్ సిస్సుల్ జోక, “అమ్‍చితె పాఁచ్ పోడియొ, చి దొన్ని మొస్స పిట్టవ, అన్నె కిచ్చొ నాయ్” మెన, యేసుక సంగిల. ");
INSERT INTO key_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","యేసు, “దస్సి జలె, జా తిలి సామన్ అంచితె ఆన దా” మెన, సిస్సుల్‍క సంగ కెర, ");
INSERT INTO key_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ప్రెజల్‍క దెక, “తుమ్ ఎత్కిజిన్ వెస” మెన సంగ, జా చివ్వర్‍చి బుఁయ్యె వెసడ కెర, జేఁవ్ పాఁచ్ పోడియొ చి దొన్ని మొస్స దెరన, ఆగాసుమ్ పక్క దెక, “ఈంజ అన్నిమ్ తుయి దిలది” మెన దేముడు అబ్బొస్‍క జొకర కెర, జేఁవ్ పోడియొ మోడ కెర, జోచ సిస్సుల్‍క దెతికయ్, జేఁవ్ సిస్సుల్ ప్రెజల్‍క వంట దిల. ");
INSERT INTO key_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","జేఁవ్ బెర తిల ప్రెజల్ ఎత్కిజిన్ పేట్ బెర్తు కయ్‍ల. కయ్‍లి పడ్తొ, సేంసిల గండల్ బార గంపల్‍తె బెర్తు సిస్సుల్ గుడ్డిల. ");
INSERT INTO key_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","తేర్‍బోదల్ బాలబోదల్‍క ముల్తె, అన్నిమ్ కత్తస పాసి పాసి పాఁచ్ వెయిల్‍జిన్ మున్సుబోదల్ జల. ");
INSERT INTO key_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","జా ఎత్కి జర్గు జలి పడ్తొ, “ప్రెజల్‍క అఁవ్వి తెద్రయిందె. తూమ్ దోనితె వెగ, అంచి కంట అగ్గె ఒత్తల్‍తొచి గట్టుతె గెచ్చ” మెన, సిస్సుల్‍క యేసు బలవంతుమ్ కెర్లొ. ");
INSERT INTO key_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","పడ్తొ, జో జేఁవ్ ప్రెజల్‍క తెద్రవ దా కెర, ప్రార్దన కెర్తి రిసొ, మెట్టయ్ ఎక్కిలొయి వెగ గెలన్. సాంజ్ జతికయ్, యేసు ఎక్కిలొయి ఒత్త తిలన్. ");
INSERT INTO key_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","సిస్సుల్ తిలి జా దోని మాత్రుమ్, ఒడ్డు తెంతొ దూరి గెతికయ్, వాదు కెర పెలయ్‍తె తతికయ్, కెర్టల్ జా దోనితె పెట్టి జస్తె తిల. ");
INSERT INTO key_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","అందరె, పాసి పాసి కుకుడొ వాంసెనె, యేసు జా సముద్రుమ్‍చి ఉప్పిరి ఇండ జా, జేఁవ్ సిస్సుల్ తిలిస్‍తె జెతె తిలన్. ");
INSERT INTO key_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","జో సముద్రుమ్‍చి ఉప్పిరి ఇండిలిసి జోచ సిస్సుల్ దెక కెర, బమ్మ జా బియఁ గెచ్చ, “డుంబొ!” మెన బియఁ కెర కేకుల్ గల్తికయ్, ");
INSERT INTO key_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","యేసు బేగి, “దయిరిమ్ ఆనన. బియఁ నాయ్. ఆఁవ్వి జెతసి” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","యేసు “ఆఁవ్వి జెతసి” మెన సంగితికయ్, పేతురు జోక కేక్ గల, “ప్రబూ, తుయి జలె, ఆఁవ్ కి పానిచి ఉప్పిరి ఇండ తుచితె జెతి రితి అంక సెలవ్ దే” మెన సంగిలన్ ");
INSERT INTO key_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","యేసు జోక “జే!” మెంతికయ్, పేతురు దోని తెంతొ ఉత్ర కెర, యేసుతె గెతి రిసొ పానిచి ఉప్పిరి ఇండ కెర, సగుమ్ దూరి గెలన్. ");
INSERT INTO key_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","గని, వాదుక దెక కెర, బియఁ కెర, డుంబ గెచ్చె తా, “ప్రబూ, ప్రబూ, అంక రచ్చించుప కెరు!” మెన, కేక్ గలన్. ");
INSERT INTO key_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","యేసు బేగి ఆతు చంప కెర, పేతురుచి ఆతు దెరన, “తొక్కి నముకుమ్‍చొ, తుయి కిచ్చొక అన్మానుమ్ జలది?” మెన పేతురుక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","తెదొడి, జేఁవ్ దొగుల దోనితె వెగిల, చి వాదు ముల దిలి. ");
INSERT INTO key_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","దస్సి జర్గు జలి రిసొ, దోనితె తిలస యేసుక జొకర, “తుయి నిజుమి దేముడుచొ పుత్తుసి” నేన, జోచి గవురుమ్ చిన సంగిల. ");
INSERT INTO key_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","జేఁవ్ యేసు ఒత్తల్‍తొచి గట్టుతె పాఁవ కెర, గెన్నేసరెతు మెలి టాన్‍తె ఉత్తిర్ల. ");
INSERT INTO key_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ఒత్తచ ప్రెజల్ యేసుక చిన కెర, సుట్టుపట్లు గఁవ్విలె కబుర్లు తెద్రవ, జబ్బుల్ తిలస ఎత్కిజిన్‍క జోతె కడ ఆనయ్‍తికయ్, ");
INSERT INTO key_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","యేసుచొ పాలుమ్‍చి అంచు జలెకు జేఁవ్ చడుక మెన బతిమాల్ప జా సెలవ్ నఙన్‍తె తిల, చి జోచొ పాలుమ్‍చి అంచు చడిలస ఎత్కిజిన్ చెంగిల్ జల. ");
INSERT INTO key_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","జా పొది, యెరూసలేమ్ పట్నుమ్ తెంతొ పరిసయ్యుల్ చి మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస యేసుతె బెద జా కెర, ");
INSERT INTO key_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“తుచ సిస్సుల్ అత్తొ నే దొవన్‍తె అన్నిమ్ కతతి. జేఁవ్ కిచ్చొక ఇసి పాపుమ్ కెర పూర్గుమ్‍చ వెల్లెల మాన్సుల్ సికయ్‍లి రితి కెర్తి నాయ్?” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","యేసు జోవయింక, “తూమ్ తుమ్‍చ పూర్గుమ్‍చ అఁవ్వి ఉచర్లిసి కెర్తి ఆసక, కిచ్చొక పాపుమ్ కెర దేముడుచి ఆగ్న రితి కెర్సు నాయ్? ");
INSERT INTO key_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","కిచ్చొ ఆగ్నచి రిసొ ఆఁవ్ సంగితసి మెలె, అయ్యద్‍అబ్బొద్‍క చెంగిల్ దెక గవురుమ్ కెర” మెన సంగిలి కోడు. అన్నెక్ కిచ్చొ మెలె, “అబ్బొస్‍క జలెకు అయ్యస్‍క జలెకు కో దూసుప కెరుల గే, నే పిట్తె మొర్నుచి సిచ్చ దెంకయ్” మెన సంగిలి కోడు. ");
INSERT INTO key_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","తూమ్, మాత్రుమ్, కిచ్చొ మెంతసు మెలె, తుమ్ అఁవ్వి ఉచర్లి కోడు. కిచ్చొ కోడు మెలె, ‘అంచితె తుమ్‍క కిచ్చొ కలుగు జతి గే, జయ్యి అమ్‍చొ దేముడుక దెంక సంగ అస్సి మెన కో అయ్యస్‍క అబ్బొస్‍క సంగుల గే, జేఁవ్ దస్సి సంగిలస అయ్యస్‍క జలెకు, అబ్బొస్‍క జలెకు, అన్నె తోడు దెంక నాయ్’, మెన, తుమ్ సంగితసు. ");
INSERT INTO key_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","జలె, తుమ్ దస్సి మెన తుమ్‍చ పూర్గుమ్‍చక అఁవ్వి ఉచర్లిసి కెరుక ముక్కిమ్ మెలి రితి, ‘దేముడుక అదికారుమ్ నాయ్’ మెలి రితి జా, జో సంగిలి ఆగ్న మార్సుప కెర అస్సుస్. ");
INSERT INTO key_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","“తుమ్ ఉప్రమెన్సుచొ! యెసయా పూర్గుమ్‍చొచి అత్తి దేముడు సంగిలి కోడు తుమ్‍చితె నిజుమి నెరవెర్సుప జతయ్. ");
INSERT INTO key_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","ఈంజ ప్రెజల్ అంక జేఁవ్‍చి ఒటొ తెన్ గవురుమ్ కెర్త రిత కొడొ సంగిలే కి, జోవయించి పేట్ అంక దూరి అస్తి. ");
INSERT INTO key_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","మాన్సుల్ అఁవ్వి ఉచర్ల కొడొక ‘దేముడు సంగిలస’ మెన, ప్రెజల్‍క సికడ, అంక ఆరిక జొకర్తతి. మెన తుమ్‍చి రిసొచి కోడు” మెన, యేసు జేఁవ్ వెల్లెల మాన్సుల్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","యేసు జేఁవ్‍క దస్సి సంగ కెర, పాసి తిల ప్రెజల్‍క బుకారా కెర, జోవయింక ఇసి మెన బోదన కెర్లన్. “తుమ్ సూన అర్దుమ్ కెరన. ");
INSERT INTO key_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","మాన్సుక గార్ కెర్తిసి కిచ్చొ మెలె, చోండి తెడి తెంతొ గెతిసి నెంజె, గని చోండి తెంతొ బార్ జతిసి. జయ్యి మాన్సుక గార్ కెర్తిసి” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","యేసు దస్సి సంగిలి పిమ్మట్, జోచ సిస్సుల్ జోతె జా కెర, “పరిసయ్యుల్ జా కోడు సూన కోపుమ్ జల మెన జాన్సి గె?” మెన, యేసుక పుసిల. ");
INSERT INTO key_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","జలె జో, “వెర్రి రూకుక కీసి ఉట్కవుల గే, దస్సి, పరలోకుమ్ తిలొ అంచొ దేముడు అబ్బొ జోక కామ్‍క నెంజితొ ఎత్కి మాన్సుక ఉట్కయ్‍లి రితి గెచ్చవ కెర గెలెదె. ");
INSERT INTO key_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","జాకయ్, జేఁవ్ సంగితిస్‍చి రిసొ తుమ్ చింత గలన నాయ్. జేఁవ్ నంప నెంజ ఆత్మ గుడ్డి జా, మాన్సుల్‍క వాట్ దెకడుక ఉచర్లిసి. గని గుడ్డి సుదొ గుడ్డి సుదల్‍క వాట్ దెకయ్‍లెగిన, జో కి ఈంజొ కి గొయితె సేడుల.” మెలన్. ");
INSERT INTO key_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","జలె, పేతురు యేసుక, “జా టాలిచి అర్దుమ్ అమ్‍క సంగు” మెన సంగిలన్, చి ");
INSERT INTO key_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","యేసు జోవయింక, “అప్పె ఎద తూమ్ కి అర్దుమ్ నెంతె అస్సుస్ గే? ");
INSERT INTO key_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ఈందె, చోండి గలంతిసి కిచ్చొ జలెకి పెట్టి గెచ్చ కెర, కామ్‍క నెంజిలెగిన, బార్ జా గెచ్చెదె, మెన తుమ్‍క అర్దుమ్ నాయ్ గె? ");
INSERT INTO key_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","మాన్సుచి చోండి తెంతొ బార్ జతి ఎత్కి కోడు, మాత్రుమ్, జోవయించి పెట్టితె జెర్మ కెర బార్ జతయ్. జా కోడు లట్టబ్లొ మాన్సుక జయ్యి గార్ కెరెదె, ");
INSERT INTO key_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","కిచ్చొక మెలె, గర్చ ఉద్దెసుమ్‌లు, నరు అత్యల్, లంజెకమొ, చోరు కమొ, అబద్దుమ్ సాచి, మాన్సుల్‍క దూసుప కెర్తిసి, దసచ ఎత్కి, మాన్సుచి పెట్టి తెంతొ జెయెదె. ");
INSERT INTO key_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","దసచయ్ మాన్సుక గార్ కెరుల, గని అత్తొ నే దొవన్‍తె కతిసి మాన్సుక గార్ కెరె నాయ్” మెన యేసు బోదన కెర్లన్. ");
INSERT INTO key_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","యేసు ఒత్త తెంతొ బార్ జా ఉట్ట గెచ్చ, తూరు పట్నుమ్ చి సీదోను పట్నుమ్‍చి ప్రాంతుమ్‍తె గెతికయ్, ");
INSERT INTO key_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ఈందె, జా ప్రాంతుమ్‍చ కనానుచి సెకుమ్‍చి తేర్‍బోద ఎక్లి బార్ జా, జోక దస్సుల్ జా కెర, “ప్రబువ, దేముడు తెద్రయ్‍లొ, దావీదు రానొచి సెకుమ్‍తె జెర్మిలొ, క్రీస్తు జలొ రచ్చించుప కెర్తొసొ తుయి. అంచి ఉప్పిరి దయ తీ. అంచి దూక బూతుమ్ దెర అస్సె, చి ఒగ్గర్ స్రెమ జతయ్” మెన యేసుక కేకుల్ గలిలి. ");
INSERT INTO key_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","గని యేసు తుక్లె తా, జాక ఎక్కి కోడు కి జబాబ్ సంగె నాయ్. తెదొడి, జోచ సిస్సుల్ జోతె జా కెర, “ఈంజ అమ్‍చి పట్టి జా జా, కేకుల్ గలితయ్, ఇన్నెక తెద్రవ దేసు” మెన, యేసుక బతిమాల్ప జా సంగిల. ");
INSERT INTO key_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","యేసు, “గొవుడు నెంజిల మెండల్ రిత జా అమ్‍చి ఇస్రాయేలుచ ప్రెజల్‍తెయి అంక అబ్బొ తెద్రయ్‍లన్, గని వేర మాన్సుల్‍తె నాయ్” మెలన్. ");
INSERT INTO key_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","యేసు దస్సి మెలె కి, జా తేర్‍బోద అన్నె పాసి జా కెర, సెర్ను సేడ జొకర, “ప్రబు, అంక తోడు కెరు” మెన సంగిలి. ");
INSERT INTO key_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","యేసు జాక దెక, “బోదల్‍చి అన్నిమ్ గుడ్డ కెర, సూనకూనర్లుక గల దెంక చెంగిల్ నాయ్” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","జా కిచ్చొ మెలి మెలె, “నిజుమి, ప్రబు, గని సూనకూనర్లు కి జోవయించొ ఎజొమానిచి బల్ల తెంతొ సేడ్లి ఉస్టొ వెంట కవుల” మెన, సంగిలి. ");
INSERT INTO key_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","జా తేర్‍బోద దస్సి జబాబ్ దెతికయ్, యేసు జాక, “అమ్మ, తుయి గట్టిఙ నంపజతసి. తుయి కోర్‍ప జలిసి తుక జర్గు జవుస్” మెన, జాక వరుమ్ దిలన్. చి బేగి జాచి దువిసి చెంగిల్ జలి. ");
INSERT INTO key_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","యేసు ఒత్త తెంతొ ఉట్ట గెచ్చ, గలిలయచి సముద్రుమ్‍తెచి ఒడ్డుతెచి వట్టె గెచ్చ, ఏక్ మెట్టయ్ వెగ వెసితికయ్, ");
INSERT INTO key_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ఒగ్గర్ ఒగ్గర్‍జిన్ జనాబ్ మాన్సుల్ జోతె సొట్ట జలసక, అత్తొ చట్టొ నెంజిలసక, గుడ్డి జలసక, గుల్ల జలసక, అన్నె వేర బాదల్ తిలస ఎత్కిక, కడ ఆన, జోచి పాసి వెసయ్‍తికయ్, యేసు జేఁక చెంగిల్ కెర్లన్. ");
INSERT INTO key_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","గుల్ల మాన్సుల్ లట్టబ్లిసి, అత్తొ చట్టొ నెంజిలస చెంగిల్ జలిసి, సొట్ట మాన్సుల్ ఇండిలిసి, గుడ్డి మాన్సుల్ దెకిలిసి ఒత్త తిల మాన్సుల్ దెక కెర, ఆచారిమ్ జా, ఇస్రాయేల్ ప్రెజల్‍చొ దేముడుక గవురుమ్ కెర్ల. ");
INSERT INTO key_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","జేఁవ్ జనాబ్ ఎత్కిజిన్ యేసు తెన్ జా మెట్టయ్ తిర్రతి తతికయ్, జోచి సిస్సుల్‍క యేసు పాసి బుకారా కెర, “ఈంజేఁవ్ ప్రెజల్ తిర్రతి అంచితె అస్తి. జోవయింక అన్నిమ్ కిచ్చొ కి నాయ్, చి జోవయించి ఉప్పిర్ ఆఁవ్ కన్కారుమ్ జతసి. జేఁవ్ నే కతె ఉట్ట గెలెగిన, వట్టె మొకొమ్ గుంజ్ర సేడుక జయెదె, చి రిసొ జోవయింక చువ్వె తెద్రవుక అంక ఇస్టుమ్ నాయ్” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","సిస్సుల్ ఆచారిమ్ జా, జోవయింక “ఎతివాట్‍జిన్ మాన్సుల్‍క అన్నిమ్ దెంక మెలె, జోవయింక సరిపుచుప జతి అన్నిమ్ ఈంజ బయిలె అమ్‍క కేనె దొర్కు జవుల?” మెన సంగిల, చి ");
INSERT INTO key_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","యేసు జోవయింక, “జలె, తుమ్‍చితె కెత్తి పోడియొ అస్తి?” మెన పుసిలన్, చి జేఁవ్ సిస్సుల్ చజన కెర, “అమ్‍చితె సత్తు పోడియొ, చి ఇదుద్ల మొస్స దొన్ని అస్తి” మెన సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","యేసు ప్రెజల్ ఎత్కిక “వెస” మెన సంగ కెర, ");
INSERT INTO key_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","జేఁవ్ సత్తు పోడియొచి జేఁవ్ మొస్స నఙన, అత్తి దెరన, ‘తుయి దా దయ కెర్లది’ మెలి రితి దేముడు అబ్బొస్‍క ఉచర, పోడియొ మోడ కెర, జోచ సిస్సుల్‍క వంట దెతికయ్, జేఁవ్ సిస్సుల్ ప్రెజల్‍క జా ఎత్కి వంట దిల. ");
INSERT INTO key_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","జేఁవ్ ప్రెజల్ ఎత్కిజిన్ పేట్ బెర్తు కయ్‍లి పడ్తొ, సేంసిల గండల్ సత్తు గంపల్‍తె సిస్సుల్ గుడ్డ బెరయ్‍ల. ");
INSERT INTO key_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","తేర్‍బోదల్ బాలబోదల్‍క ముల్తె, చెత్తర్ వెయిల్‍జిన్ మున్సుబోదల్ కయ్‍ల. ");
INSERT INTO key_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","పడ్తొ, జేఁవ్ బెర తిల జనాబ్‍క తెద్రవ దా కెర, దోనితె వెగ, యేసుచి సిస్సుల్ మగదాన్ మెంతి ప్రాంతుమ్‍తె ఉట్ట గెల. ");
INSERT INTO key_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","తెదొడి, పరిసయ్యుల్ చి సద్దూకయ్యులు యేసుతె జా కెర, జోక పరిచ్చ కెర్తి రిసొ, “ఆన్లె, తుక పరలోకుమ్‍చి అదికారుమ్ అస్సె మెన అమ్ చినితి రిసొ, అమ్‍చి మొక్మె వెల్లి కామ్ ఏక్ కెరు” మెన, మోసిమ్‍క జోక సంగిల. ");
INSERT INTO key_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","యేసు జోవయింక ఏక్ టాలి సంగిలన్. “సాంజ్ జతి పొది ఆగాసుమ్‍తె మబ్బు నెంజ పొద్దు బగుక ఎరన లగితయ్ మెన దెకిలెగిన, ‘కలిక చెంగిల్ కెరెదె’ మెన తుమ్ చినితసు. ");
INSERT INTO key_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","పడ్తొ, పెందలె ఒగ్గర్ మబ్బు కెర్లెగిన, ‘వెల్లొ పాని పెటెదె’ మెన చినితసు గెద? జలె ఆగాసుమ్ కీసి తిలె కీసి కెరెదె గే తుమ్ చినితసు, గని అప్పె జర్గు జత కమొచి అర్దుమ్ చినుక నెతుర్సు. ");
INSERT INTO key_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ప్రబుక నిదానుమ్ నెంజ లంజెబుద్ది పాపుమ్‍బుద్ది జల తుమ్ ఈంజ కాలుమ్‍చ మాన్సుల్, రుజ్జు దెకయ్‍త కమొక కోర్‍ప జతసు. అంచి అదికారుమ్ దెకయ్‍తి రిసొ, ఎక్కి ముల కేన్ వేర కామ్ కెర దెంక నెంజె. దేముడుచ కబుర్లు పూర్గుమ్ సంగిలొ యోనాక జర్గు జలిస్‍చి రితి జయెదె.” ");
INSERT INTO key_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","పడ్తొ యేసు సిస్సుల్ తెన్ గాడు ఒత్తల్‍తొ జీన ఒడ్డుతె పాఁవ కెర, “పోడియొ గట్ర ఆనుక పఁవ్స గెలమ్” మెన సిస్సుల్ ఏద కెర్తికయ్, ");
INSERT INTO key_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","యేసు జోవయింక టాలి సంగిత్ రితి ఇసి మెలన్. “తుమ్ దెకన. పరిసయ్యుల్‍చి సద్దూకయ్యుల్‍చి పులయ్‍తి పీట్‍చి రిసొ తుమ్ జాగర్త తెన్ తా” మెన, జోవయింక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","జేఁవ్ ఎక్కిలొ తెన్ ఎక్కిలొ “కిచ్చొ పోడియొ రిసొ సంగితయ్? అమ్ పోడియొ నే ఆన్‍లి రిసొయి ఇస్సె మెలన్.” మెన బమ్మ జా లట్టబన్ల. ");
INSERT INTO key_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","యేసు, మాత్రుమ్, జేఁవ్ ఉచర్లిసి జాన కెర, “తొక్కి నముకుమ్‍చ, తుమ్. తుమ్‍చితె పోడియొ నెంజిలిస్‍చి రిసొ కిచ్చొక ఉచరన లట్టబంతసు? ");
INSERT INTO key_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","తుమ్ అప్పెక అర్దుమ్ కెరన్సు నాయ్ గె? పాఁచ్ పోడియొ పాఁచ్ వెయిల్ జిన్‍క వంటితికయ్, కెత్తి గంపల్‍తె సేంసిలిసి బెరయ్‍లదు గే? ");
INSERT INTO key_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","సత్తు పోడియొ చెత్తర్ వెయిల్ జిన్‍క వంటిత్‍కయ్, కెత్తి గంపల్‍తె సేంసిలిసి బెరయ్‍లదు గే? తుమ్ ఏద కెర్సు నాయ్ గె? ");
INSERT INTO key_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","జలె, ఆఁవ్ మాములుమ్ అన్నిమ్‍చి రిసొ తుమ్‍క సంగుక నాయ్, మెన కిచ్చొక అర్దుమ్ కెరన్సు నాయ్? పరిసయ్యుల్‍చి, సద్దూకయ్యుల్‍చి పులయ్‍తి పీట్‍చి రితి బోదనచి రిసొ జాగర్త తెన్ తా” మెన యేసు అన్నె సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","తెదొడి ‘మాములుమ్ పులయ్‍తి పీట్‍చి రిసొ నాయ్, గని సద్దూకయ్యులు చి పరిసయ్యుల్ సికడ్తిసిచి రిసొ అమ్‍క జాగర్త సంగితయ్’ మెన సిస్సుల్ అర్దుమ్ కెరన్ల. ");
INSERT INTO key_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","యేసు సిస్సుల్ తెన్ ఇండ గెచ్చ కైసరియ పిలిప్పిచి ప్రాంతుమ్‍తె పాఁవ అయ్‍లె పొది, “మాన్సు జా జెర్మున్ అయ్‍లయ్ అంక, కో మెన ప్రెజల్ సంగితతి?” మెన పుసిల. జేఁవ్ సిస్సుల్ జోక, ");
INSERT INTO key_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","“సగుమ్‍జిన్ తుక ‘బాప్తిసుమ్ దెతె తిలొ యోహాను’ మెంతతి. సగుమ్‍జిన్ తుక ‘దేముడుచ కబుర్లు సంగిలొ ఏలీయా జయెదె’ మెంతతి. అన్నె సగుమ్‍జిన్, యిర్మీయా, నెంజిలె ప్రబుచ కబుర్లు సంగిలొ అన్నెక్లొ జయెదె.” మెన, సిస్సుల్ సంగిల. ");
INSERT INTO key_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","యేసు జోవయింక, “జలె, తూమ్ అంక కో మెన ఉచర్తసు?” మెన పుసితికయ్, ");
INSERT INTO key_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","“తుయి ఎక్కిలొ జీవ్ తిలొ దేముడుచొ పుత్తుసి. జో తెద్రయ్‍లొ క్రీస్తు మెలొ రచ్చించుప కెర్తొసొ తుయి” మెన, సీమోను పేతురు ఒప్పన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","యేసు జోక, “ఓ సీమోను, యోహాను మెలొసొచొ పుత్తుసి, తుక చెంగిలి. కిచ్చొక మెలె, ఈంజ కోడు తుక కో మాన్సు సికయ్‍లిసి నెంజె, గని పరలోకుమ్ తిలొ అంచొ అబ్బొయి జలొ దేముడు తుచి ఆత్మతె ఇసి మెన సికడ అస్సె. ");
INSERT INTO key_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","అన్నె, తుక ఆఁవ్ కిచ్చొ మెంతసి మెలె, తుక ‘పేతురు’ మెన నావ్ తిఁయ అస్సి. ‘వెల్లొ పత్తుర్’ మెలి అర్దుమ్ తెన్. ఈంజ రంగ్ని పత్తుర్‍తె అంచి సంగుమ్ బందిందె, చి మొర్ను ఆన్‍త సెక్తివొ కి జేఁవ్‍చి ఉప్పిరి జీనుక నెతిర్తి. ");
INSERT INTO key_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","పరలోకుమ్‍చి తాలుమ్లు వాడిక కెరుక మెలి రితి, తుక అదికారుమ్ దెతసి. మెలె, బూలోకుమ్‍తె కిచ్చొచి రిసొ ‘పోని’ మెనిస్తె గే, పరలోకుమ్‍తె ‘పోని’ మెనుమ్‍దె. అన్నె, కిచ్చొచి రిసొ సెలవ్ దెస్తె గే, పరలోకుమ్‍చి సెలవ్ దెమ్‍దె” మెన, యేసు పేతురుక అదికారుమ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","తెదొడి, “ఆఁవ్, ‘ఎత్కి అదికారుమ్ తిలొ దేముడు తెద్రయ్‍లొ క్రీస్తు రచ్చించుప కెర్తొసొ జెయెదె’ మెన కక్క సంగ నాయ్” మెన, యేసు సిస్సుల్‍క గట్టిఙ సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","జా దీసి తెంతొ, “ఆఁవ్ యెరూసలేమ్ పట్నుమ్‍తె గెచ్చ కెర, వెల్లి సబ కెర్త వెల్లెల మాన్సుల్, పూజర్లు చి మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తసతె, చి అత్తి ఒగ్గర్ స్రెమల్ సేడ మొరుక అస్సె. గని, తిర్రత్‍క అన్నె జీవ్ జా ఉట్టిందె” మెన యేసు జోచ సిస్సుల్‍క సంగుక దెర్లన్. ");
INSERT INTO key_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","తెదొడి, పేతురు జోక పక్కయ్ కడ నా కెర, “ప్రబు, దేముడుచి దయక తుక జా పిట్టవుసు! దస్సిచి తుక కెఁయ్యఁక కి జర్గు జవుస్ నాయ్” మెన, యేసుక గోల కెర్లన్. ");
INSERT INTO key_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","పేతురు దస్సి సంగితికయ్, యేసు పస్ల కెర, జోక దెక, “సయ్‍తాన్, అంచి పడ్తొ గో! అంచి తిలి కామ్‍క తుయి అడ్డు అస్సిస్. దేముడుచి పచ్చెనచి బుద్ది ఉచర్లది నాయ్, గని మాన్సుల్ ఉచర్తి రగుమ్ ఉచర్లది” మెన, పేతురుక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","యేసు పేతురుక దస్సి సంగ కెర, సిస్సుల్ ఎత్కిక, “కో నంపజా, అంచి పట్టి బులుక ఉచరుల గే, జోచి సొంత ఇస్టుమ్ ఎత్కి ముల దా, జోచి సొంత సిలువ వయన్లి రితి జా, అంచి పట్టి బులుక అస్సె. ");
INSERT INTO key_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","కిచ్చొక మెలె, జోచి సొంత ప్రానుమ్ రచ్చించుప కెరన తంక, కో కోర్‍ప జవుల గే, జోచి ప్రానుమ్ పాడ్ జా గెచ్చెదె. గని, అంచి రిసొ కో జోచి ప్రానుమ్ దెతి రితి ఎక్కి మెన్సు నిదానుమ్ ఇండుల గే, జోచి ప్రానుమ్ రచ్చించుప జా జోక దొర్కు జయెదె. ");
INSERT INTO key_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ఈంజ లోకుమ్‍తె తిలిసి ఎత్కి కేన్ మాన్సు జవుస్ కలుగు కెరన, జోచి సొంత ప్రానుమ్ పాడ్ కెరన్లెగిన, జోక కిచ్చొ లాబుమ్? కిచ్చొ లాబుమ్ నాయ్. అన్నె, కేన్ మాన్సుచి ఆత్మ పాడ్ జలెగిన, జోచి ప్రానుమ్ దేముడు తెన్ అన్నె బెదవంతి రితి కిచ్చొ దిలె సరిపుచుప జయెదె గే? ");
INSERT INTO key_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“కిచ్చొక ఈంజ ఎత్కి ఆఁవ్ సంగితసి మెలె, పడ్తొక ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ, అంచ దూతల్ తెన్, కచితుమ్ అంచొ అబ్బొసి జలొ దేముడుచి పరలోకుమ్‍చి ఉజిడి తెన్, అన్నె జెంక అస్సె. ఎత్కి మాన్సు ఇండిలి కొల్ది జోక సిచ్చ గే బవుమానుమ్ గే దెయిందె. ");
INSERT INTO key_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","అన్నె, తుమ్‍క ఆఁవ్ కిచ్చొ కచితుమ్ సంగితసి మెలె, ఇన్నె టీఁవొ జా తిలసతె సగుమ్‍జిన్ నే మొర్తె అగ్గె, ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ అంచి రాజిమ్‍చి అదికారుమ్ తెన్ డీస్తిసి దెకుల” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","అన్నె సొవ్వు దీసల్ గెలి పడ్తొ, యేసు పేతురుక, యాకోబుక చి యాకోబుచొ బావొస్ జలొ యోహానుక పట్టి కడ దెరన, డోంక్ తిలి ఏక్ మెట్టయ్ వెగ కెర, ");
INSERT INTO key_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","జోవయించి మొక్మె జోచి రూపుమ్ మార్సుప జా, జోచి మొకొమ్ పొద్దు రితి తల్కున ఉజిడ్ జలి, చి జోచ పాలల్ ఉజిడ్ రితి చోక్ డీసిల. ");
INSERT INTO key_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","పడ్తొ, ఈందె, పూర్గుమ్‍చ దేముడుచి కబుర్లు సంగిత మోసే చి ఏలీయా దొగుల యేసు తెన్ లట్టబ్తె తా. జేఁవ్ తీగ్ల సిస్సుల్‍క డీసన్ సేడ్ల. ");
INSERT INTO key_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","జేఁవ్ దొగుల పూర్గుమ్‍చ యేసు తెన్ లట్టబ్తె తతికయ్, పేతురు యేసుక, “ప్రబు, అమ్ ఇన్నె తంక చెంగిలి. తుక ఇస్టుమ్ తిలె, ఏక్ తుక, ఏక్ మోసేక, ఏక్ ఏలీయాక, మొత్తుమ్ తిన్ని కుడియల్ బందిందె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","పేతురు దస్సి సంగితె తతికయ్, ఈందె, ఉజిడ్ తిలి ఏక్ మబ్బు జోవయింక డంకి జలన్, చి “ఈందె, ఈంజొ అంచొ ప్రేమ తిలొ సొంత పుత్తు. ఇన్నెచి రిసొ అంక ఒగ్గర్ సర్దసంతోసుమ్. ఇన్నెచి కోడు తుమ్ సూన” మెన, జా మబ్బు తెంతొ అవాడ్ సంగిలిసి సూన్ల. ");
INSERT INTO key_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","సిస్సుల్ ఈంజ కోడు సూన పుడ్జొ సేడ ఒగ్గర్ బియఁ గెల. ");
INSERT INTO key_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","గని యేసు జోవయించి పాసి జా కెర, జోవయింక చడ, “ఉట్ట. బియఁ నాయ్” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","జేఁవ్ సిస్సుల్ అంకివొ ఉగుడ దెకిలె, యేసు ఎక్కిలొయి డీసిలన్, అన్నె కక్క దెకిత్ నాయ్. ");
INSERT INTO key_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","యేసుచి సిస్సుల్ జా మెట్టయ్ తెంతొ ఉత్ర జెతె తతికయ్, “ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ మొర గెచ్చ అన్నె జీవ్ జతె ఎద, ఈంజ తుమ్‍క డీసిలిస్‍చి రిసొ తుమ్ కక్క సంగ నాయ్” మెన యేసు జోవయింక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","తెదొడి జోచ సిస్సుల్, “క్రీస్తు మెలొ రచ్చించుప కెర్తొసొ నే జెతె అగ్గె ఏలీయా పూర్గుమ్‍చొ జెంక అస్సె, మెన మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస కిచ్చొక సంగితతి?” మెన, యేసుక పుసిల. ");
INSERT INTO key_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","జో జోవయింక, “‘ఏలీయా పూర్గుమ్‍చొ జా కెర ఎత్కి తెయార్ కెరుక అస్సె’ మెన పూర్గుమ్ దేముడు సంగిలి కోడు నిజుమి, ");
INSERT INTO key_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","గని తుమ్‍క ఆఁవ్ కిచ్చొ మెంతసి మెలె, ఈంజొ ఏలీయా అగ్గెయి అయ్‍లన్. అయ్‍లె కి, జేఁవ్ జోక చినితి నాయ్, చి జోవయింక ఇస్టుమ్ అయ్‍లి రితి జేఁవ్ జోక కెర్ల. ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ కి జోవయింతె దస స్రెమల్ సేడిందె” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","జో బాప్తిసుమ్ దెతె తిలొ యోహానుచి రిసొయి ఏలీయా పూర్గుమ్‍చొ రితొసొ మెన యేసు సంగిలన్, మెన సిస్సుల్ అర్దుమ్ కెరన్ల. ");
INSERT INTO key_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","యేసుచి సిస్సుల్ జా మెట్టయ్ తెంతొ ఉత్ర జా కెర, ఒత్త బెర్లి జనాబ్‍తె పాఁవితికయ్, ఎక్కిలొ యేసుతె జా కెర, సెర్ను సేడ జొకర, ");
INSERT INTO key_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“బాబు, అంచొ పుత్తుచి ఉప్పిరి కన్కారుమ్ తీ. జో మోర్చ జబ్బు తెన్ ఒగ్గర్ బాద సేడ్తె తత్తయ్. జో కెఁయఁక తెఁయఁక ఆగితె నెంజిలె గడ్డె సేడుక అస్సె. ");
INSERT INTO key_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","తుచ సిస్సుల్‍తె జోక కడ ఆన్లయ్, గని జోక చెంగిల్ కెరుక జేఁవ్ నెతిర్ల” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","యేసు, “నముకుమ్ నెంజిలి వెర్రి బుద్దిచి కాలుమ్‍చ, తుమ్. తుమ్‍చి తెన్ ఆఁవ్ కెత్తి దీసల్ తంక? కెత్తి దీసల్ తుమ్‍క ఆఁవ్ ఓర్సుప జంక? అల్లె, జో నాడుక అంచితె కడ ఆన” మెన, సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","జో నాడుక కడ ఆన్‍తికయ్, యేసు జోక దెర్లి బూతుమ్‍క గోల కెర్తికయ్, జా బూతుమ్ జోక ముల దా, ఉట్ట గెలన్. గెలి వెంటనె, జో నాడు చెంగిల్ జలన్. ");
INSERT INTO key_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","పడ్తొ, అన్నె కో నెంతె, యేసుచ సిస్సుల్ జోతె జా కెర, “ఆమ్ కిచ్చొక జా బూతుమ్‍క ఉదడుక నెతిర్లమ్?” మెన పుసిల, ");
INSERT INTO key_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","చి యేసు జోవయింక, “తుమ్ తొక్కి నంపతిలి రిసొ, తుమ్‍క సొర్సుగిడ్డచి ఎదిలి నముకుమ్ తిలెగిన, ఈంజ మెట్టక జవుస్ దెక ‘ఇన్నె తెంతొ ముల దా, ఒత్తల్‍తొ గో’ మెలె బేగి గెచ్చెదె. తుమ్ కిచ్చొ నంపజలెకి, జయ్యి జెయిమ్ జయెదె, మెన తుమ్‍క ఆఁవ్ కచితుమ్ సంగితసి ");
INSERT INTO key_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","గని ఎక్కి చువ్వె తా ప్రార్దన కెర్లెకయ్ ఇసిచిక ఉదడుక జయెదె.”, మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","పడ్తొ, జేఁవ్ గలిలయ ప్రాంతుమ్‍తె బెద బుల్తె తతికయ్. యేసు సిస్సుల్‍క దెక, “ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొక మాన్సుల్‍చి అత్తి విరోదుమ్ సుదల్ దెర దెవుల, ");
INSERT INTO key_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","చి అంక జేఁవ్ మారుల. మార్లె కి, తిర్రత్‍క అన్నె జీవ్ జా ఉట్టిందె” మెన, యేసు అన్నె సంగిలి రిసొ, సిస్సుల్ ఒగ్గర్ దుకుమ్ జల. ");
INSERT INTO key_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","యేసు కపెర్నహూమ్ పట్నుమ్‍తె పాఁవిలి పొది, దేముడుచి గుడితె దెతి చెత్తర్ వెండ్లుచి పన్ను నఙితస పేతురుతె జా కెర, “తుమ్‍క బోదన కెర్తొసొ ఈంజ చెత్తర్ వెండ్లుచి పన్ను దెయెదె గే నాయ్?” మెన పుసిల, చి “దెయెదె” మెలన్. ");
INSERT INTO key_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","జో పేతురు గెరి జా కెర, నే లట్టబ్తె అగ్గె, యేసు జా సంగతి జాన్లి రిసొ, “ఓ సీమోను, తుయి కిచ్చొ ఉచర్తసి? ఈంజ లోకుమ్‍చ రానలు కచితె పన్ను నఙుల? సొంత పుత్తర్సుల్‍తె గే, వేర మాన్సుల్‍తె గె?” మెన పుసిలన్, ");
INSERT INTO key_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","చి పేతురు “వేర మాన్సుల్‍తె” మెంతికయ్, యేసు, “దస్సి జలె, పుత్తర్సుల్‍తె సంగుక నాయ్. ");
INSERT INTO key_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","గని, దేముడుచి గుడిక ఈంజ పన్ను నఙితసక అన్మానుమ్ నే కెర్తి రిసొ, తుయి సముద్రుమ్‍తె గెచ్చ, గాలుమ్ గలు. తొలితొ దెర్ను సేడ్తొ మొస్సొక దెర, జో మొస్సొచి చోండి చిర దెకిలె, ఒత్త ఏక్ అట్టు వెండ్లుచి విలువచి కాసు డీసెదె. జా దెర జా కెర, తుచి రిసొ కి అంచి రిసొ కి జోవయింక దేసు” మెన, యేసు పేతురుక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","జా పొదుల్‍తె, యేసుచ సిస్సుల్ జోతె జా కెర, “పరలోకుమ్‍చి రాజిమ్‍తె కో వెల్లొ జయెదె?” మెన పుసితికయ్, ");
INSERT INTO key_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","జో ఏక్ బాలబోదక జోచి పాసి బుకారా కెర, జోవయించి నెడిమి టీఁవొ కెర, ");
INSERT INTO key_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ఇసి మెలన్. “తుమ్‍క ఆఁవ్ కిచ్చొ కచితుమ్ సంగితసి మెలె, తుమ్ బుద్ది మార్సుప కెరన బాలబోదల్ రిత గవురుమ్ నే ఉచరంతి రితి జలెకయ్, పరలోకుమ్‍చి రాజిమ్‍తె బెదుక తెరితె, జయె నాయ్. ");
INSERT INTO key_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","జాకయ్, ఈంజొ బోదచి రితి కో దాక్ కెరన తయెదె గే, జొయ్యి పరలోకుమ్‍చి రాజిమ్‍తె వెల్లొ జయెదె. ");
INSERT INTO key_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","అన్నె ఇస బాలబోదల్‍తె ఎక్కిలొక జలెకు, కో అంచి నావ్ తెన్ మరియాద కెరుల గే, అంకయి మరియాద కెర్లి రితి జవుల. ");
INSERT INTO key_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","గని అంక నంపజల ఇస బాలబోదల్ జల రితసతె ఎక్కిలొక కి, కో పాపుమ్ కెరవుల గే, జోవయించి టొట్రయ్ తిర్వేలి రితొ వెల్లొ పత్తురు ఒడొవ దా, జోక సముద్రుమ్‍తె బుడ్డవ గెలుక చెంగిలి. ");
INSERT INTO key_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“అయ్యొ! పాపుమ్ కెరయ్‍తిస్‍చి రిసొ ఈంజ లోకుమ్‍క కస్టుమ్! పాపుమ్ కెరయ్‍తిసి కచితుమ్ జెయెదె, గని కచి అత్తి దస అల్లర్ జవుల గే, ");
INSERT INTO key_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","అయ్యొ! జాచి రిసొ, తుమ్‍చితె ఎక్కిలొచొ ఆతు జలెకు, చాటు జలెకు, జోక పాపుమ్ కెరవ తిలెగిన, జోచి ఆతు జవుస్, జోచి చాటు జవుస్, కండ గెల వెంట గెలి రితి జవుస్. కిచ్చొక మెలె, దొన్ని అత్తొ దొన్ని చట్టొ తెన్ కెఁయఁక నే విజితి ఆగితె గలి జతి కంట, ఆతు జలెకు, చాటు జలెకు నెంజ పరలోకుమ్‍చి రాజిమ్‍తె బెదుక తుమ్‍క చెంగిలి. ");
INSERT INTO key_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","అన్నె, తుమ్‍చితె ఎక్కిలొచి అంకి జవుస్ తుమ్‍క పాపుమ్ కెరవ తిలెగిన, అన్నె జా అంకి జోతె తెంతొ కడ వెంట గెలి రితి జవుస్. కిచ్చొక మెలె, దొన్ని అంకివొ తెన్ వెల్లి ఆగి గొయ్‍తె గలి జతి కంట, ఎక్కి అంకి తెన్ పరలోకుమ్‍చి రాజిమ్‍తె బెదుక తుమ్‍క చెంగిలి. ");
INSERT INTO key_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“ఈంజేఁవ్ బాలబోదల్ రితసతె ఎక్కిలొక కి నిస్కారుమ్ నే దెకితి రితి దెకన. కిచ్చొక మెలె, ఇన్నెక రకిత దూతల్ కెఁయఁక తెఁయఁక పరలోకుమ్ తిలొ అబ్బొచి మొకొమ్ దెకితె తవుల మెన ఆఁవ్ తుమ్‍క కచితుమ్ సంగితసి. ");
INSERT INTO key_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","కిచ్చొక మెలె, ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ కిచ్చొక అయ్‍లయ్, మెలె, జోవయించి ఆత్మక నెస గెల మాన్సుల్‍క రచ్చించుప కెరుక అయ్‍లయ్. ");
INSERT INTO key_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“అల్లె, తుమ్ కిచ్చొ ఉచర్తసు? ఏక్ మాన్సుక పుంజెక్ మెండల్ తిలె, జోవయింతె ఎక్కి పిట్ట తిలెగిన, ఏక్ తకు పుంజెక్ మెండల్‍క ఒత్త డొంగ్రె ముల దా కెర, జా పిట్ట గెచ్చ తిలి మెండక చజుక గెచ్చె నాయ్ గె? ");
INSERT INTO key_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","అన్నె జేఁవ్ కెఁయ నే నాసిల ఏక్ తకు పుంజెక్ మెండల్‍చి రిసొ సంతోసుమ్ జతి కంట, ఈంజ నాస గెలి మెండక చజిలె, డీసిలె, జో గొవుడు ఒగ్గర్ సర్దసంతోసుమ్ జయెదె మెన, తుమ్‍క కచితుమ్ ఆఁవ్ సంగితసి. ");
INSERT INTO key_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","దస్సి కి, ఈంజేఁవ్ బోదల్ ఎక్కిలొ కి నాసెనుమ్‍తె గెచ్చుక పరలోకుమ్ తిలొ అబ్బొస్‍క ఇస్టుమ్ నాయ్. ");
INSERT INTO key_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“తుమ్‍చితె బావొ ఎక్కిలొక అన్నెక్లొ పాపుమ్ కెర తిలెగిన, జో జా పాపుమ్ నే కెర్లొసొ పాపుమ్ కెర్లొసొతె గెచ్చ కెర, అన్నె కో నెంతె, జో కెర్లి పాపుమ్ జోకయ్ సంగుక అస్సె. జో పాపుమ్ కెర్లొసొ జా కోడు సూన్లెగిన, నిజుమి, పాపుమ్ కెర్లయ్ మెన, ఒప్పన సంగిలెగిన, జోక అన్నె బెదవన తస్తె. ");
INSERT INTO key_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","గని, జో నే సూన్లెగిన, జా తగుచి రిసొ తుమ్ లట్టబ్తిస్‍చి రిసొ దొగుల తీగ్ల సాచి జతి రితి, అన్నెక్లొక గే అన్నె దొగులక గే కడన, జో పాపుమ్ కెర్లొసొతె గెచ్చ, సంగ. ");
INSERT INTO key_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","జో తీగ్లచి కోడు నే సూన్లెగిన, అంక నంపజలస మొత్తుమ్ బెద సబ కెర్తిస్‍తె జా తగు సూనవ. జో జా సంగుమ్ సబ కెర్లిస్‍చి కోడు కి నే సూన్లెగిన, జోక తుమ్‍చితె నే బెదవంతె, బార్ కెర, దస్సి, యూదుల్ నెంజిలసక కి సిస్తు నఙితసక కి యూదుల్ కీసి బెదవంతి నాయ్ గే, దస్సి దెక సిచ్చ కెర. ");
INSERT INTO key_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","తుమ్ నంపజలస బెద ఈంజ లోకుమ్‍తె సబ కెర కిచ్చొ రుజ్జు సంగితె గే, జాకయ్ పరలోకుమ్ తిలి అమ్‍చి అదికారుమ్ దెతసుమ్, మెన నిజుమి తుమ్‍క ఆఁవ్ సంగితసి. ");
INSERT INTO key_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“పడ్తొ, తుమ్‍క అన్నె కిచ్చొ మెంతసి మెలె, ఈంజ లోకుమ్‍తె తుమ్‍చితె కో కో, ఎక్కి దొగులయి జలెకి, మెన్సుతె ఎక్కి రితి ఉచర, కిచ్చొచి రిసొ ప్రార్దన కెర్తె గే, పరలోకుమ్ తిలొ అంచొ అబ్బొ తుమ్‍చి రిసొ జాక జర్గు కెరెదె. ");
INSERT INTO key_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","కిచ్చొక మెలె, దొగుల తీగ్ల అంచి నావ్ తెన్ కేనె ఎక్కితె తవుల గే, ఒత్త జోవయించి నెడిమి ఆఁవ్ తయిందె” మెన, యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","తెదొడి పేతురు పుర్రె జా కెర, యేసుక, “ప్రబు, కేన్ జవుస్ బావొ అంక కెత్తి సుట్లు పాపుమ్ కెర్తిసి, ఆఁవ్ జోక చెమించుప కెరుక? సత్తు సుట్లు ఎద గే?” మెన, పుసిలన్. ");
INSERT INTO key_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","యేసు జోక, “సత్తు సుట్లు నాయ్. తిని విసొ సత్ర సుట్లు ఎదక.” మెలన్. ");
INSERT INTO key_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“పరలోకుమ్‍చి రాజిమ్‍తె బెదితస ఎక్కిలొక ఎక్కిలొ చెమించుప కెర్తిస్‍చి రిసొ కిచ్చొ టాలి సంగుక జయెదె మెలె, జోచ గొత్తి సుదల్ దెంక తిలి డబ్బుల్ ఏక్ రానొ నఙనుక దెర్లొ. ");
INSERT INTO key_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","నఙనుక దెర్లి పొది, ఈందె, జోక దెస్సు వెయి వెండ్లు దెంక తిలొ ఎక్కిలొక బుకార్తికయ్, జమాన్లు జోక జో రానొతె కడ ఆన్ల. ");
INSERT INTO key_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","జా రునుమ్ తీర్సుప కెరుక మెన జో మాన్సుతె కిచ్చొ నెంజిలి రిసొ, జోచొ ఎజొమాని, ‘జోక కి జోచి తేర్సిక కి, జోచ బోదల్‍క కి, జోక కలుగు జలిసి ఎత్కి కి విక గెల కెర, రునుమ్ తీర్సుప కెరవడ’ మెన, జమాన్లుక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","జలె, రునుమ్ జలొ జో గొత్తి సుదొ సెర్ను సేడ, జొకర, బాబు, అంచి ఉప్పిరి దయ తిఁయ, దొరత్ రక్కు. జా రునుమ్ ఎత్కి ఆఁవ్ తీర్సుప కెరిందె” మెన, బతిమాల్ప జా సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","జో రానొ జోచి ఉప్పిరి కన్కారుమ్ జా, జోక ముల కెర, జోచి రునుమ్ చెమించుప కెర్లన్. ");
INSERT INTO key_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“గని, జో దస్సి బార్ జా కెర, జోచి జతచ గొతి మాన్సుల్‍తె ఎక్కిలొ జోక దొన్ పుంజొ వెండ్లు దెంక తిలొసొక దస్సుల్ జా, జోచి పీకతె దెర, ‘తుయి అంక దెంక తిలిసి అంక దే’ మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","జోచి జతచొ జో గొత్తి సుదొ సెర్ను సేడ, జొకర జొకర, ‘అంచి ఉప్పిరి దయ తిఁయ దొరత్ రక్కు. తుక దా గెలిందె’ మెన, బతిమాల్ప జా సంగిలే కి, ");
INSERT INTO key_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","జో నే ఒప్పన్‌తె, జో అన్నెక్లొ దెంక తిలిసి దా గెల్తె ఎద జోక జేల్‍తె గలయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“తెదొడి, ఈంజొ కన్కారుమ్ నే దెకిలొ గొత్తి సుదొచి ఒత్తచ గొత్తి సుదల్ జా జర్గు జలిసి దెక కెర, ఒగ్గర్ బాద సేడ, జర్గు జలిసి ఎత్కి జోచొ ఎజొమానిక సంగిల. ");
INSERT INTO key_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","తెదొడి, జో ఎజొమాని, జో కన్కారుమ్ నెంజిలొ గొత్తి సుదొక బుకారా కెర, జోక, ‘తుయి, గర్చొ గొత్తి సుదొ, తుయి అంక బతిమాల్ప జా జొకర్లది, చి తుచి ఎదివాట్ తిలి రునుమ్ పెట గెలయ్. ");
INSERT INTO key_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ఆఁవ్ తుక చెమించుప కెర్లి రితి, తుయి తుచొ జతచొ గొత్తి సుదొక చెమించుప కెరుక తిలి నాయ్ గె?’ మెన, జోక సంగ కెర, ");
INSERT INTO key_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","జో గొత్తి సుదొ రునుమ్ జలిసి ఎత్కి దెతె ఎద, సిచ్చల్ కెర్తసతె జో జేలి తంక మెన జోచొ ఎజొమాని సొర్ప కెర దిలన్. ");
INSERT INTO key_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“జలె, తుమ్‍తె కో తుమ్‍చొ బావొ జలొ అన్నెక్లొక పెట్టి ఎత్కి చెమించుప నే కెర్లె, పరలోకుమ్ తిలొ అంచొ అబ్బొ కచితుమ్ జో మాన్సుక సిచ్చ దెయెదె” మెన యేసు బుద్ది సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","యేసు ఈంజేఁవ్ కొడొ సంగ కేడయ్‍లి పడ్తొ, గలిలయ ప్రాంతుమ్ తెంతొ ముల దా, యూదయ ప్రదేసిమ్‍తెచి యోర్దాను గాడు ఒత్తల్‍తొ పక్క ఉట్ట అయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ఒగ్గర్‍జిన్ జనాబ్ జోచి పట్టి జెతికయ్, జోవయించ జబ్బులు ఒత్త చెంగిల్ కెర్లన్. ");
INSERT INTO key_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","పరిసయ్యుల్ సగుమ్‍జిన్ యేసుక పరిచ్చ కెర, తెర్లె నింద కెరుక మెన, జోతె అయ్‍ల, అన్నె, “కేన్‍చి రిసొ జలెకు మున్సుబోద జోచి తేర్సిక ములుక నాయిమ్ గె?” మెన, పుసిల, చి యేసు జోవయింక, ");
INSERT INTO key_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","“ఈంజ లోకుమ్ జెర్మయ్‍లి పొది తెంతొ, మున్సుబోద తేర్‍బోద మెన, జెర్మిలొసొ జేఁక జెర్మయ్‍లొ. ");
INSERT INTO key_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ఇసికయి మున్సుబోద అయ్యస్అబ్బొస్‍క ముల దా, జోచి తేర్సి తెన్ బెద తంక అస్సె, అన్నె జేఁవ్ దొగుల ఎక్కి ఆఁగ్ జా తవుల మెన జెర్మయ్‍లొసొ సంగిలన్ మెన సదు కెర్సు నాయ్ గె? ");
INSERT INTO key_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","జలె, జేఁవ్ దొగుల ఎక్కి జీవ్ జా అస్తి. జాచి రిసొ, దేముడు పెండ్లితె కక్క జత కెరవ తయెదె గే, కేన్ మాన్సు ములవుక జయె నాయ్.” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","జేఁవ్ పరిసయ్యుల్ యేసుక “జలె, ‘ముల దెతి పుస్తకుమ్ రెగ్డ దిలెగిన ముల దెంక జయెదె’ మెన మోసే పూర్గుమ్‍చొ కిచ్చొక ఆడ్ర దిలన్?” మెన, సంగిల. ");
INSERT INTO key_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","యేసు జోవయింక, “తుమ్ రాడ్ జీవ్‌చ మాన్సుల్‍చి రిసొ ‘తుమ్‍చ తేర్దివొక ముల దెంక జయెదె’ మెన మోసే సెలవ్ దిలన్, గని మాన్సుల్‍క జెర్ముయ్‍లి కెర్లి మొదొల్ తెంతొ దస్సి తయె నాయ్. ");
INSERT INTO key_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ఆఁవ్ కిచ్చొ మెన తుమ్‍క సంగితసి మెలె, జా లంజె జలి రిసొ పిట్టవ, కో జలెకు జోచి తేర్సిక ముల దా అన్నెక్లిక పెండ్లి జయెదె గే, లంజె వంసుమ్‍చొ జతయ్, మెన గట్టిఙ సంగితసి” మెన, జోవయింక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ఈంజ కోడు సూన కెర, యేసుచ సిస్సుల్ జోక “తెర్నిమున్సు చి నెడిమి ఇసి తిలెగిన, పెండ్లి నే జలెగిన చెంగిల్.” మెన యేసుక సంగిల, ");
INSERT INTO key_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","చి యేసు జోవయింక, “దేముడు జా సెక్తి దిలెకయ్, నెంజిలె కో కి జా కోడు ఓర్సుప జంక నెతిర్తి. ");
INSERT INTO key_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ఈందె, జెర్మున్ తెంతొ గొడ్డు జలస తవుల, మాన్సుల్ సగుమ్‍జిన్‍క గొడ్డు జతి రితి కెర్ల, పడ్తొ పరలోకుమ్‍చి రాజిమ్‍చి సేవ ఎక్కి మెన్సు తెన్ కెర్తి రిసొ, సగుమ్‍జిన్ కి గొడ్డు రిత జా తవుల. జలె, తుమ్ ఉచర్లి రితి తంక కో తెరుల గే, దస్సే తత్తు.” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","పడ్తొ, యేసు జోవయింక చడ ప్రార్దన కెరుక మెన, సగుమ్‍జిన్ జోవయించ బాలబోదల్‍క జోతె కడ ఆన్ల. ");
INSERT INTO key_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","జలె, జేఁవ్ బోదల్‍క కడ ఆన్ల మాన్సుల్‍క యేసుచ సిస్సుల్ “పోన” మెన గోల కెర్ల. గని, యేసు, “జోవయింక అడ్డు కెర నాయ్. బోదల్ అంచితె జెతు. కిచ్చొక మెలె, పరలోకుమ్‍చి రాజిమ్ ఇస సుదల్‍చియి” మెన, సిస్సుల్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","జేఁవ్ బోదల్‍క బోడి చడ కెర ఒత్త తెంతొ ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","పడ్తొ, ఈందె, ఉబెడొ ఎక్కిలొ యేసుతె జా కెర, “గురుబాబు, జొఒర. ఆఁవ్ పరలోకుమ్‍చి రాజిమ్‍తె కెఁయఁక తెఁయఁక జితి వాట అంక దొర్కు జంక మెలె, ఆఁవ్ కిచ్చొ చెంగిల్ కామ్ కెర్లె జయెదె?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","యేసు జోక, “కేన్ చెంగిల్‌చి మెన కిచ్చొక అంక తుయి పుసితసి? చెంగిల్ తిలొసొ ఎక్కిలొయి. అన్నె కోయి నాయ్. పరలోకుమ్‍తె జితి వాట కావలె మెలె, దేముడుచ ఆగ్నల్ రితి కెర్తె తా” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","జో ఉబెడొ, “కేన్ కేన్ ఆగ్నల్ రితి కెరుక?” మెన యేసుక పుసిలన్, చి యేసు, “నరు అత్య కెరు నాయ్, లంజెకమొ కెరు నాయ్, కిచ్చొ చోరు నాయ్, అబద్దుమ్ సాచి సంగు నాయ్, ");
INSERT INTO key_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","అయ్యద్‍అబ్బొద్‍క గవురుమ్ దెకితె తా, అన్నె, తుక్క తుయి కీసి ప్రేమ కెరంతసి గే దస్సి, వేర సుదల్‍క కి ప్రేమ కెర్తె తా” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","జో మాన్సు యేసుక, “ఇసచ ఎత్కి ఆఁవ్ నిదానుమ్ కెర దెకన్‍తసి. గని కిచ్చొగె పిట్ట అస్సె మెన అంక అజ్జ. అన్నె కిచ్చొ పిట్ట అస్సె?” మెన పుసిలన్, చి యేసు జోక, “తుయి పూర్తి జంక ఆస తిలెగిన, గో, చి ");
INSERT INTO key_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","తుచి ఆస్తి ఎత్కి విక కెర, బీద సుదల్‍క దేసు, చి పరలోకుమ్‍తె తుక ఆస్తి కలుగు జెయెదె. అన్నె, అంచి తెన్ బెద, అంచి పట్టి జే!” మెలన్. ");
INSERT INTO key_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","గని, జో ఉబెడొ ఒగ్గర్ సొమ్సారుమ్‍చి రిసొ, యేసు దస్సి సంగితికయ్, దుకుమ్ జా మొకొమ్ ఇదిలిసి కెర ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","తెదొడి యేసు జోచి సిస్సుల్‍క, “ఆఁవ్ తుమ్‍క కిచ్చొ కచితుమ్ సంగితసి మెలె, సొమ్సార్లు పరలోకుమ్‍చి రాజిమ్‍తె బెదుక కస్టుమ్. ");
INSERT INTO key_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","అన్నె, దస సొమ్సార్లు దేముడుచి జా రాజిమ్‍తె బెదితి కంట, సూజిబొరొ వాట్ ఒంటె గెచ్చుక సుల్లు, మెన తుమ్‍క ఆఁవ్ సంగితసి” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","సిస్సుల్ ఈంజ కోడు సూన కెర, ఆచారిమ్ జా, “దస్సి జలె, కో రచ్చించుప జంక జయెదె?” మెన, సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","యేసు జోవయింక దెక, “మాన్సుల్ కెర్క నెత్తిర్లిసి, గని ఎత్కి జర్గు కెరుక కి దేముడుక సెక్తి అస్సె.” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","పేతురు, “ఈందె, ఆమ్ ఎత్కి ముల దా తుచి పట్టి బులితసుమ్, చి రిసొ అమ్‌కయి కిచ్చొ దొర్కు జయెదె?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","యేసు జోవయింక ఇసి మెలన్, “తుమ్‍క ఆఁవ్ కిచ్చొ కచితుమ్ సంగితసి మెలె, ఈంజ లోకుమ్‍క నొవర్ చెంగిల్ కెర్తె పొదిక, ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ ఎత్కిక ఏలుప కెర్తి రిసొ, అంచి పరలోకుమ్‍చి ఉజిడ్‍చి సింగాసనుమ్‍తె వెసితె పొదిక, అంక నంపజా తుమ్ బారజిన్, బార సిఙాసనల్‍తె వెస, ఇస్రాయేలుల్‍చ బార సెకుమ్‍లుచక అంచి తెడి తుమ్ తీర్పు కెర్తె. ");
INSERT INTO key_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","అన్నె, అంచి నావ్‌చి రిసొ గెరల్ జలెకు, అన్నొబావొక జలెకు, బయిబేనిక జలెకు, అబ్బొస్‍క జలెకు, అయ్యస్‍క జలెకు, బోదల్‍క జలెకు, బుఁయి జలెకు, జో ముల తయెదె గే, జోక దసచ పుంజెక్ వంతుల్ దొర్కు జయెదె, అన్నె, పరలోకుమ్‍తె గెచ్చ కెఁయఁక తెఁయఁక చెంగిల్ తా జివుల. ");
INSERT INTO key_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ఈంజ అగ్గె జల మాన్సుల్ ఒగ్గర్‍జిన్ పడ్తొ జవుల, పడ్తొ జలస అగ్గె జవుల.” ");
INSERT INTO key_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“పరలోకుమ్‍చి రాజిమ్‍తె మాన్సుల్‍క బెదయ్‍తొసొచి దయ కీసి మెలె, ఎజొమాని ఎక్కిలొచి దయచి రితి జయెదె. జో జోచి ద్రాచ తోటతె కామ్ కెరవుక మెన, కూలి మాన్సుల్‍క బుకార్తి రిసొ, పెందలె బార్ జా కెర, ");
INSERT INTO key_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ఏక్ దీసిచి కామ్‍క ఏక్ ఒండి మెద్దెన్‍చి కూలి డబ్బుల్ దెయిందె” మెన, జేఁవ్ కూలి మాన్సుల్‍చి మొక్మె ఒప్పన సంగ తా, ద్రాచ తోటతె జేఁవ్ కామ్ కెర్తి రిసొ జోవయింక తెద్రయ్‍లొ. ");
INSERT INTO key_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“పిమ్మట్, పాసి పాసి నొవ్వు గంటల్‍క, జో ఎజొమాని, సంతవీది గెచ్చ కెర, కామ్ నెంజ ఆరి టీఁవొ జా తిలస్‍క సగుమ్‍జిన్ ఒత్త తిలిసి దెక కెర, ");
INSERT INTO key_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","తూమ్ కి అంచి ద్రాచ తోటతె గెచ్చ, కామ్ కెర, చి సరిపుచుప జతి కూలి డబ్బుల్ తుమ్‍క దెయిందె” మెన, జోవయింక సంగితికయ్, జేఁవ్ జోచి కామ్‍తె గెల. ");
INSERT INTO key_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","అన్నె, పాసి పాసి బార గంటల్ మెద్దెనె కి, తిన్ని గంటల్‍క కి, జా వీదె జో ఎజొమాని గెచ్చ కెర, అన్నె దస్సి కెర్లన్. ");
INSERT INTO key_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“ఒత్త తెంతొ, పాఁచ్ గంటల్ సంజె, జా వీదె అన్నె గెచ్చ కెర, అన్నె సగుమ్‍జిన్ దస్సి ఒత్త టీఁవొ జా తతికయ్, తుమ్ ఒండి మెద్దెనె కిచ్చొక దస్సి, కామ్ నే కెర్తె కిచ్చొక టీఁవొ జా అస్సుస్?” మెన పుసితికయ్, ");
INSERT INTO key_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","జేఁవ్, “కో అమ్‍క కూలి కెరయ్‍తి నాయ్” మెన సంగిల. సంగితికయ్, జో ఎజొమాని, “జలె, తూమ్ కి అంచి ద్రాచ తోటతె గెచ్చ కామ్ కెర” మెన, జోవయింక కి తెద్రయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“సాంజ్ జతికయ్, జో ద్రాచ తోటచొ ఎజొమాని జోచొ గెర్‍చి డబ్బుల్ దెకితొ మాన్సుక, ‘జేఁవ్ కూలి కెర్లసక బుకారా కెర, పడ్తొ అయ్‍లసక తెంతొ తొలితొ అయ్‍లసక ఎద, ఎత్కిక ఆఁవ్ సంగిలి కూలి డబ్బుల్ దేసు’ మెన, జోక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","జాచి రిసొ, పాఁచ్ గంటల్ సంజె జా కెర గడియయ్ కామ్ కెర్లసక కి, ఒండి మెద్దెన్‍చి ఎదిలి కూలి డబ్బుల్ దిలన్. ");
INSERT INTO key_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","జేఁవ్ ఆల్సిమ్ అయ్‍లసక తెద్దిలి దిలి రిసొ, జేఁవ్ అగ్గె అయ్‍లస, ‘అమ్‍క ఒగ్గర్ దెయెదె’ మెన ఉచర్ల. ఎత్కిజిన్‍క ఎక్కి రితి ఒండి మెద్దెన్‍చి కూలి డబ్బుల్ దొర్కు జలి. ");
INSERT INTO key_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","జాచి రిసొ, జేఁవ్ అగ్గె అయ్‍లస జా కూలి డబ్బుల్ నఙన, ‘పెందలె తెంతొ సాంజ్ ఎద ఒప్పడ్‍క కెద్ది స్రెమ జా, అమ్ కామ్ కెర్లమ్. ");
INSERT INTO key_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","జేఁవ్ ఎక్కి గంట కెర్లసక అమ్‍చి తెన్ సమానుమ్ దిలది’ మెన గోస లట్టబ, ఎజొమానిక సంగిల. ");
INSERT INTO key_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ఈంజొ ఎజొమాని జోవయింతె ఎక్కిలొక, ‘నేస్తమ్, ఆఁవ్ తుమ్‍క అన్యాయిమ్ కెరుక నాయ్. తుయి ఏక్ ఒండి మెద్దెన్‍చి కూలి డబ్బుల్ నఙనుక ఒప్పన్లది. ");
INSERT INTO key_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","అల్లె, తుయి ఒప్పస్లిసి నఙన గో’ మెన సంగ కెర, పడ్తొ అయ్‍లొ ఎక్కిలొక దెకవ, జో తొలితొ అయ్‍లొసొక అన్నె, ‘తుక దిలి రితి, ఈంజొ పడ్తొ అయ్‍లొసొక కి దెంక అంక ఇస్టుమ్ జలి. ");
INSERT INTO key_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","అంచి సొంత ఆస్తి అంచి ఇస్టుమ్ అయ్‍లి రితి వంట దెంక నెంజె గే? అంచి సర్దక జోవయింక దర్ముమ్ తెన్ దిలి రిసొ తుమ్‍క గోస గే?’ మెన, జో ఎజొమాని సంగిలొ మెన యేసు సంగ కెర, ");
INSERT INTO key_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","అన్నె, జలె, తొలితొ బెదిలస పడ్తొ బెదిలస జవుల. పడ్తొ బెదిలస తొలితొ బెదిలస జవుల”, మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","యేసు యెరూసలేమ్ పట్నుమ్‍తె గెచ్చుక మెన బార్ జా, ఇండ గెతె తిలి పొది, వట్టె గెతసతె తెంతొ జోచ బారజిన్ సిస్సుల్‍క పాసి బుకారాన, ఇసి మెలన్. ");
INSERT INTO key_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“ఈందె, యెరూసలేమ్‍తె గెతసుమ్. ఒత్త కిచ్చొ జయెదె మెలె, ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొక, మాన్సు దెర్లె, వెల్లెల మాన్సుల్ పూజర్లుతె చి మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తసతె దెర్ను సేడిందె, చి జేఁవ్ అంక మొర్తి సిచ్చ వయడ కెర, ");
INSERT INTO key_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","అంక కొంకడ్తి రిసొ, అంక కొర్డల్ తెన్ పెటితి రిసొ, అంక సిలువతె టీఁవొ కెర మార్తి రిసొ, అమ్‍చ యూదుల్ నెంజిల అదికారుల్‍చి అత్తి అంక సొర్ప కెర దెవుల. గని తిర్రత్‍క అన్నె జీవ్ జా ఉట్టిందె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","తెదొడి యేసుచ సిస్సుల్ జల జెబెదయిచ దొగుల పుత్తర్సుల్‍చి అయ్యసి, జేఁవ్ పుత్తర్సుల్ తెన్ యేసుతె జా కెర, సెర్ను సేడ జొకర, “ఏక్ వరుమ్ దే” మెన, సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","యేసు జాక, “తుయి కిచ్చొ కోర్‍ప జతసి?” మెన పుసిలన్, చి ఈంజ, “తుచి రాజిమ్‍తె అంచ పుత్తర్లు దొగుల, తుచి ఉజెతొ పక్క ఎక్కిలొ, డెబ్రి పక్క ఎక్కిలొ వెస తతి రితి ఆడ్ర దేసు” మెన సంగిలి. ");
INSERT INTO key_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","చి యేసు, “తుమ్ కిచ్చొ పుసితసు గే, తుమ్ నేన్సు. అంచి గిన్నతె బెద పితి రితి, ఆఁవ్ సేడుక తిలి దుకుమ్‍తె బెదుక ఓర్సుప జంక తెర్సు గే?” మెన సంగితికయ్, జేఁవ్ “అమ్ తెరుమ్‍దే” మెలె. ");
INSERT INTO key_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","దస్సి జబాబ్ దెతికయ్, యేసు, “ఆఁవ్ పితి గిన్నచి తుమ్ పిస్తె, గని అంచి ఉజెతొ పక్క ఎక్కిలొ, అంచి డెబ్రి పక్క అన్నెక్లొ తుమ్ వెసుక మెన సెలవ్ దెంక అంచి అత్తి నాయ్. పరలోకుమ్ తిలొ అంచొ దేముడు అబ్బొ కక్క కక్క సెలవ్ దా తయెదె గే, జెఁవ్వి ఒత్త వెసుల.” మెలన్. ");
INSERT INTO key_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","తెదొడి, జేఁవ్ దొగుల బావుడ్లు ఎత్కిచి కంట వెల్లెల మాన్సుల్ జంక ఉచర్లిస్‍చి రిసొ సేంసిల దెస్సుజిన్ సిస్సుల్ జా ఎత్కి సూన కెర, జోవయించి ఉప్పిరి ఒగ్గర్ కోపుమ్ జల. ");
INSERT INTO key_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","తెదొడి యేసు జేఁవ్ బారజిన్ సిస్సుల్‍క జోతె బుకారా కెర, “యూదుల్ నెంజిల అదికారుల్ జోవయించి తెడి తిల వెల్లెల మాన్సుల్, సొంత గవురుమ్ ఉచరన, ప్రెజల్‍క జాడ్లు వయడ్లి రితి, జోవయింక పోటి తెన్ ఏలుప కెర్తతి మెన తుమ్ జాన్సు. ");
INSERT INTO key_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","గని తుమ్‍చితె దస్సి తంక జయె నాయ్. తుమ్‍చితె కో వెల్లొ జంక ఉచరెదె గే, జొయ్యి తుమ్‍చొ సేవ కెర్తొసొ రితొ జా తంక. ");
INSERT INTO key_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","తుమ్‍చితె కో ముక్కిమ్ జంక ఉచరెదె గే, జో తుమ్‍చొ గొతిమాన్సు రితొ జా తంక. ");
INSERT INTO key_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","దస్సి, ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ కి మాన్సుల్‍చి అత్తి సేవ కెరవడనుక నాయ్, గని మాన్సుల్‍క ఆఁవ్ సేవ కెరుకయ్ అయ్‍లయ్. మెలె, ఒగ్గర్‍జిన్ మాన్సుల్‍క సయ్‍తాన్‍చి రాజిమ్ తెంతొ నెతొవ గెల్తి రిసొయి మొర అంచి ప్రానుమ్ దెంక అస్సెచి రిసొ ఈంజ లోకుమ్‍తె అయ్‍లయ్” మెన సిస్సుల్‍క యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","పడ్తొ, యేసుచి సిస్సుల్ యెరికో పట్నుమ్ తెంతొ బార్ జా, యెరూసలేమ్ పట్నుమ్‍తె గెతె తిలి పొది, ఒగ్గర్‍జిన్ ప్రెజల్ జోచి పట్టి గెతె తిల. ");
INSERT INTO key_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","జలె, ఈందె, వాట్ సొడి దొగుల గుడ్డి మాన్సుల్ వెస తిల. యేసు జా వాట్ జెతయ్ మెన సూన తా, “ఓ యేసుప్రబు, దావీదు రానొచి సెకుమ్‍తె జెర్మిలొ రచ్చించుప కెర్తొసొ, అమ్‍చి ఉప్పిరి కన్కారుమ్ తిఁయ, చెంగిల్ కెరు!” మెన, బతిమాల్ప జా కేక్ గల. ");
INSERT INTO key_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","తిల జనాబ్, జలె, “తుక్లె తా” మెన గోల కెర్లె కి, జేఁవ్ గుడ్డి మాన్సుల్ అన్నె, “ప్రబు, దావీదు రానొచి సెకుమ్‍తె జెర్మిలొ రచ్చించుప కెర్తొసొ, అమ్‍చి ఉప్పిరి కన్కారుమ్ తిఁయ చెంగిల్ కెరు!” మెన, అగ్గెచి కంట గట్టిఙ కేకుల్ గల్తికయ్, ");
INSERT INTO key_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","యేసు టీఁవొ కెర, జోవయింక బుకారా కెర, “ఆఁవ్ తుమ్‍క కిచ్చొ కెరుక మెన తుమ్ ఉచర్తసు?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","జేఁవ్ జోక, “అమ్‍చ అంకివొ దెకితి రితి కెరు” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","జేఁవ్‍చి ఉప్పిర్ యేసు కన్కారుమ్ జా, జోవయించ అంకివొ చడిలన్. చడిలి బేగి, జోవయించ అంకివొ టేంట డీసిల, చి జేఁవ్ జోచి పట్టి గెల. ");
INSERT INTO key_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","పడ్తొ, యేసు ఇసి ఇండ జా యెరూసలేమ్ పట్నుమ్‍చి పాసి జా కెర, ఒలీవ మెలి మెట్టచి పాసి తిలి బేత్పగే మెలి గఁవ్వి అయ్‍లి పొది, జోచ సిస్సుల్‍తె దొగులక, ");
INSERT INTO key_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“తుమ్‍చి మొక్మె తిలి గఁవ్వి గెచ్చ పెస, చి బేగి, ఒత్త బంద తిలి ఏక్ గాడ్దెచి, జాచి తెన్ తిలి ఏక్ గాడ్దె పిల్ల తుమ్‍క డీసుల. జోవయింక యిప కెర, అంచితె ఉదడ ఆన. ");
INSERT INTO key_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","కో జలెకు తుమ్‍క కిచ్చొ జలెకు సంగిలెగిన, ‘ఇన్నెతెన్ ప్రబుక కామ్ అస్సె’ మెన సంగ. సంగిలె, బేగి జో మాన్సు జేఁవ్ గాడ్దెల్‍క తెద్రయెదె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","పూర్గుమ్ దేముడు జోచి కబుర్ సంగిలొ అత్తి సంగిలి కోడు నెరవెర్సుప జంక మెన, ఈంజ జర్గు జలి. ");
INSERT INTO key_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“తుమ్‍చొ సేంతుమ్ తిలొ రానొ గాడ్దె పిల్లతె వెగ జెతయ్, మెన దేముడు నిసాన సీయోను పట్నుమ్‍తెచ ప్రెజల్‍క సాట్ప కెర” మెన, రెగిడ్లి కోడు. ");
INSERT INTO key_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","జలె, జేఁవ్ దొగుల సిస్సుల్ గెచ్చ, యేసు జోవయింక సంగిలి రితి కెర, ");
INSERT INTO key_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","జా గాడ్దెక చి, జాచొ పిల్లక ఉదడ ఆన, జోచి సిస్సుల్ జోవయించ దుప్పట్లు జా పిల్లచి ఉప్పిర్ గల్తికయ్, యేసు వెగ వెసిలన్. ");
INSERT INTO key_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","అన్నె, ఒత్త బెర్ల జనాబ్‍తె ఒగ్గర్‍జిన్ జోవయించ దుప్పట్లు వట్టె అంతిర్ల. అన్నె సగుమ్‍జిన్ రూక్‍చ మట్టల్ రొడ్డల్ కండ కెర వట్టె అంతిర్ల. ");
INSERT INTO key_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","అంత్ర కెర, జోవయించి పుర్రెతొ గెతె తిలస కి పడ్తొ గెతె తిలస కి, “దావీదు రానొచి సెకుమ్‍తె జెర్మిలొ అమ్‍చొ రచ్చించుప కెర్తొసొక జొఒర, జొఒర! దేముడు ప్రబుచి నావ్ తెన్ జెతొసొక ఓసన్న, ఓసన్న! ఎత్కిచి కంట ఉప్పిర్‍చి టాన్‍తె తిలొసొక ఓసన్న!” మెన, కేకుల్ గల్తె తిల. ");
INSERT INTO key_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","జలె, యేసు యెరూసలేమ్‍తె పాఁవితికయ్, పట్నుమ్‍చ ఎత్కిజిన్ “ఈంజొ కో?” మెన, బమ్మ జతికయ్. ");
INSERT INTO key_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ఒత్త జో తెన్ అయ్‍ల ప్రెజల్ కిచ్చొ మెల మెలె, “దేముడుచి కబుర్ ఆన్‍తొ, గలిలయ ప్రాంతుమ్‍చి నజరేతు గఁవ్విచొ, యేసు ఈంజొ” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","తెదొడి యేసు దేముడుచి గుడితె పెస కెర, ఒత్త, సామన్లు వికితస, గెంతస ఎత్కిజిన్‍క ఉదడ కెర, డబ్బుల్ పల్టయ్‍తసచ, బల్లల్ చి పార్వ పిట్టల్ వికితసచ, బల్లల్ సేడవ దా. ");
INSERT INTO key_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","“‘అంచి గేరు ప్రార్దన కెర్తి గేరు జా అస్సె. దస్సి తవుస్’ మెన రెగ్డ అస్సె, గని తుమ్ కీసి కెర అస్సుస్ మెలె, ఈంజ దేముడుచి గేరుక, చోర్లు జితొ రితొ గేరు జతి రితి తుమ్ మార్సుప కెర అస్సుస్” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","తెదొడి, గుడ్డి మాన్సుల్, సొట్ట మాన్సుల్ దేముడుచి గుడితె యేసుతె అయ్‍ల, చి జోవయింక చెంగిల్ కెర్లన్. ");
INSERT INTO key_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","గని, వెల్లెల పూజర్లు, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస కి, యేసు కెర్ల కమొ దెక, పడ్తొ, “దావీదు రానొచి సెకుమ్‍తె జెర్మిలొ అమ్‍చొ రచ్చించుప కెర్తొసొ, తుక జెయ్యి, జెయ్యి!” మెన, దేముడుచి గుడితె బోదల్ యేసుక కేకుల్ గల్తె తిలిసి దెక, కోపుమ్ జల. ");
INSERT INTO key_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","కోపుమ్ జా, యేసుక, “ఈంజేఁవ్ సంగిలిసి తుయి సూన్‍తసి గె?” మెన పుసిల, చి యేసు జోవయింక, “సూన్‍తసి. ఈందె, బాలబోదల్‍చి కొవ్‍న బోదల్‍చి చోండివాట్ గవురుమ్ ఆనన్లది” మెన దేముడుచి కొడొతె రెగిడ్లి కోడు తుమ్ కెఁయ్య సదు కెర్సు నాయ్ గే? మెన, జేఁవ్ వెల్లెల మాన్సుల్‍క సంగ కెర, ");
INSERT INTO key_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","జోవయింక ముల దా కెర, జా పట్నుమ్‍తె తెంతొ బార్ జా, బేతనియ గఁవ్వి గెచ్చ, ఒత్త నిద్ర తిలన్. ");
INSERT INTO key_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","అన్నెక్ దీసి పెందలె, యేసు యెరూసలేమ్ పట్నుమ్‍తె అన్నె జెతె తతికయ్, జోక చూ కెర్లన్. ");
INSERT INTO key_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","తెదొడి వాట్ సొడి తిలొ ఏక్ అంజూరుమ్ రూకుక దెక కెర, రూక్‍చి పాసి గెలె, జా రూక్‍తె అక్కుడ్లు పిట్టవ అన్నె కిచ్చొ కి నాయ్. జాకయ్, జో రూకుక దెక, “అప్పె తెంతొ తుచితె కెఁయ్యఁక కి కాయల్ దెర్తు నాయ్” మెన సంగిలన్, చి జా రూకు బేగి సుక్క గెలి. ");
INSERT INTO key_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","యేసుచ సిస్సుల్ జా జర్గు జలిసి దెక బమ్మ జా, “ఈంజ రూకు కీసి జా బేగి సుక్క గెలి గె?” మెన లట్టబంతికయ్, ");
INSERT INTO key_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","యేసు, “తుమ్‍క ఆఁవ్ కిచ్చొ కచితుమ్ సంగితసి మెలె, తుమ్ నంపజా ఎదిలి అన్మానుమ్ కి నే జతె నంపజలెగిన, ఈంజొ చెట్టొక జర్గు జలి రితి తూమ్ కి వెల్లొ కమొ కెర్తె. గని అన్నె, ఈంజ మెట్టక జలెకు దెక, ఉట్కి జా, సముద్రుమ్‍తె గలి జా మెన సంగిలెగిన, దస్సి జర్గు జయెదె మెన తుమ్‍క నిజుమి ఆఁవ్ సంగితసి. ");
INSERT INTO key_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","మెలె, తుమ్ ప్రార్దన కెర్తె పొది కిచ్చొ నఙితె గే, జా దొర్కు జలి మెన నంపజలెగిన, తుమ్ నఙిలిసి నే పిట్తె తుమ్‍క దొర్కు జయెదె.” మెన, యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","యేసు దేముడుచి గుడితె పాఁవ కెర బోదన కెర్తె తతికయ్, వెల్లెల పూజర్లు చి అన్నె వెల్లెల మాన్సుల్ జోతె జా కెర, “తుయి కెర్త కమొ కెరుక, తుయి ఇన్నె బోదన కెరుక తుక కిచ్చొ అదికారుమ్ అస్సె? కొన్సొ తుక అదికారుమ్ దిలన్?” మెన జోక పుసిల. ");
INSERT INTO key_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","యేసు జోవయింక, “ఆఁవ్ కి తుమ్‍కయ్ ఏక్ కోడు పుసిందె. ఈంజ కోడుక తుమ్ జబాబ్ సంగిలెగిన, ఆఁవ్ కిచ్చొ అదికారుమ్‍క ఇసి కెర్తసి గే, తుమ్‍క సంగిందె. ");
INSERT INTO key_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","యోహాను బాప్తిసుమ్ దెతె తిలిస్‍చి అదికారుమ్ కేనె తెంతొ చి? పరలోకుమ్ తెంతొ చి గే, మాన్సు తెంతొ చి గె?” మెన పుసిలన్. జలె, జేఁవ్ వెల్లెల మాన్సుల్ ఎక్కిలొ తెన్ ఎక్కిలొ బమ్మ తెన్ లట్టబన, ‘పరలోకుమ్ తెంతొ చి’ మెన అమ్ సంగిలెగిన, ఈంజొ ‘దస్సి జలె, తుమ్ కిచ్చొక జోక నంప కెర్సు నాయ్?’ మెన అమ్‍క సంగెదె. ");
INSERT INTO key_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","గని, ‘మాన్సు తెంతొ చి’ మెన అమ్ సంగిలెగిన, జనాబ్ కిచ్చొ మెనుల గే బితసుమ్. కిచ్చొక మెలె, యోహానుక ‘దేముడుచి కబుర్ సంగిలొసొ జయెదె’ మెన ఎత్కిజిన్ నంపజతతి మెన వెల్లెల మాన్సుల్ జోవయింక జెఁవ్వి ఉచరన, “అమ్ నేనుమ్” మెన జబాబ్ సంగిల. ");
INSERT INTO key_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","జేఁవ్ వెల్లెల మాన్సుల్ దస్సి సంగితికయ్, యేసు “జలె, కిచ్చొ అదికారుమ్‍తె ఆఁవ్ ఈంజేఁవ్ కమొ ఆఁవ్ కెర్తసి గే, తుమ్‍క సంగి నాయ్” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","ఒత్త తెంతొ వెల్లెల మాన్సుల్‍క యేసు అన్నె ఇసి మెలన్. “ఏక్ టాలి ఉచర. ఏక్ మాన్సుక దొగుల పుత్తర్సులు తిల. అబ్బొసి జో వెల్లొ పుత్తుస్‍క ‘ఓ పూత్తు, తుయి ఆజి గెచ్చ, అమ్‍చి ద్రాచ తోటతె కామ్ కెరు మెన’ మెలన్. ");
INSERT INTO key_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","జో పుత్తుసి ‘నెసి’ మెన జబాబ్ సంగిలొ, గని పడ్తొ తప్పు ఒప్పన దుకుమ్ జా బుద్ది ఆననా, జా కామ్‍తె గెలన్. ");
INSERT INTO key_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","పడ్తొ జో అబ్బొసి అన్నెక్లొ పుత్తుస్‍తె జా కెర, తొలితొచొక సంగిలి రితి, ఇన్నెక కి సంగిలన్, చి ‘గెచ్చిందె, బ’ మెలన్. గని గెచ్చె నాయ్. ");
INSERT INTO key_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“జలె, ఈంజేఁవ్ దొగులతె కో అబ్బొస్‍చి కోడు రితి కెర్లొసొ జయెదె?” మెన, యేసు జేఁవ్ వెల్లెల మాన్సుల్‍క పుసితికయ్, జేఁవ్ “తొలితొచొ” మెన సంగితికయ్, యేసు జోవయింక, “తుమ్‍క ఆఁవ్ కిచ్చొ కచితుమ్ సంగితసి మెలె, ఈంజ దేసిమ్‍చ తుమ్ నిస్కారుమ్ దెకిత సిస్తు నఙితస కి లంజె కమొచ తేర్‍బోదల్ కి తుమ్‍చి కంట సుల్లు తెన్ దేముడుచి రాజిమ్‍తె బెదుల. ");
INSERT INTO key_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","కిచ్చొక మెలె, యోహాను సత్తిమ్ వాట్ ఇండ, సత్తిమ్ వాట్ దెకయ్‍తి రిసొ తుమ్‍చితె అయ్‍లె కి, తుమ్ జోక నంపజసు నాయ్. గని, సిస్తు నఙితస కి లంజె కమొచ కి జోక నంపజల. జలె, జేఁవ్ నంపజా చెంగిల్ జలిసి తుమ్ దెకిలెకి, తుమ్ కెర్త పాపల్‍క విసారుమ్ జసు నాయ్, చి యోహానుచి కోడు నంపజసు నాయ్.” మెన రుజ్జు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","పిమ్మట్ యేసు, “అన్నెక్ టాలి సంగిందె. సూన, ఏక్ ఎజొమాని తిలన్. జో ద్రాచ తోట రోవడ కెర, జా తోట సుట్టునంత కోట గలవ కెర, ఒత్త ద్రాచ రస్సుమ్ కడవనుక వెల్లొ పత్తుర్ కూనవ కెర, తోట రకితి గోపురుమ్ బందవ కెర, రకితసక నిసాన, జోవయింక జా తోట గుత్త దా కెర, వేర దేసిమ్ ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“పండ్లుచి పంటొ లాయితి సమయుమ్ జెతికయ్, జోచి వాట నఙన్‍తి రిసొ, తోట రకితసతె జోచ గొత్తి సుదల్‍క, జో ఎజొమాని తెద్రయ్‍లొ. ");
INSERT INTO key_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","గుత్త నఙిలస, ఒత్త రక తిలస జో ఎజొమానిచ గొతి మాన్సుల్‍తె ఎక్కిలొక దెర పెట్ల, అన్నెక్లొక మార గెల, అన్నెక్లొక పత్రల్ గల పెట్ల. ");
INSERT INTO key_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","జేఁవ్ రకితస దస్సి కెర్తికయ్, జో ఎజొమాని అగ్గెచి కంట ఒగ్గర్‍జిన్ వేర గొత్తి సుదల్‍క తెద్రయ్‍లన్, గని జేఁవ్ తోట రకితస ఇన్నెయింక కి దస్సి అల్లర్ కెర్ల. ");
INSERT INTO key_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“పడ్తొ, జో ఎజొమాని కిచ్చొ కెర్లన్ మెలె, ‘అంచొ పూత్తుక తెద్రయ్‍లెగిన, జోక మరియాద దెకుల, కిచ్చొగె’ మెన, పుత్తుస్‍క జేఁవ్ గర్చ రకితసతె తెద్రయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","జేఁవ్ జో ఎజొమానిచొ పుత్తుస్‍క దెక కెర, ‘ఇన్నెకయి అబ్బొస్‍చి దనుమ్ కలుగు జయెదె, అల్లె, ఇన్నెక మార కెర, ఇన్నెక జెతి దనుమ్ అమ్‍క కడనుమ.’ మెన ఉచర, ");
INSERT INTO key_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","జోక దెర కెర, ద్రాచ తోట తెంతొ బార్ కెర మార్ల. ");
INSERT INTO key_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","జలె, జా తోటచొ ఎజొమాని అయ్‍లె, గుత్త నఙిలస, జేఁవ్ రకితసక కిచ్చొ కెరెదె?” మెన యేసు పుసిలన్. ");
INSERT INTO key_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","జో ఎజొమాని, “జేఁవ్ గార్చ సుదల్‍క మార, పంటొ లాయితె పొదిక జోచి వాట జోక నిదానుమ్ తెన్ దెతు మెన, వేర మాన్సుల్‍క నిసాన, జోవయింకయి జా తోట రకుక గుత్త దెయెదె” మెన జబాబ్ దిల. ");
INSERT INTO key_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","జలె, యేసు జోవయింక, “దేముడుచి కొడొతె రెగిడ్లిసి కెఁయ సదు కెర్సు నాయ్ గే? ‘గేర్ బందిత సుదల్ కామ్‍క నే జయె మెన పక్కయ్ పెలవ దిలి పత్తుర్ మెన ఉచర్లె కి, జొయ్యి పత్తురు బోడిపత్తురు జయెదె. ప్రబుయి సొంతయ్ ఇసి జర్గు కెర్లొ. జో ఇసి కెర్లి రిసొ, అమ్ దెకిలె ఆచారిమ్ జతయి!’ మెన రెగిడ్లి కోడు. ");
INSERT INTO key_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","దేముడుచి రాజిమ్‍క దెకితి కామ్ తుమ్‍చితె తెంతొ కడ కెర, జోచి రాజిమ్ తెన్ బెదితి పలితుమ్ దెర్త ప్రెజల్‍చి అత్తి దెయెదె మెన తుమ్‍క కచితుమ్ సంగితసి. ");
INSERT INTO key_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","“పడ్తొ, ఈంజొ ముక్కిమ్ జలొ పత్తుర్‍చి ఉప్పిరి కో సేడుల, బద్దల్ జా గెచ్చుల, గని కచి ఉప్పిరి పత్తురు సేడెదె గే, జోక బీడవ గెలెదె” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","వెల్లెల పూజర్లు చి పరిసయ్యుల్ జో సంగిల టాలివొ సూన కెర, “అమ్‍చి రిసొయి సంగితయ్” మెన అర్దుమ్ కెరన, ");
INSERT INTO key_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","యేసుక దెరుక మెన ఉచర్ల. గని జనాబ్ జోక దేముడు తెద్రయ్‍లొ కబుర్ సంగితొసొ మెన ఉచర్లి రిసొ, జోవయింక బియఁ కెర, జా పొది జోక దెరుక ముల దిల. ");
INSERT INTO key_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","అన్నెక్ టాలి కెర, యేసు జేఁవ్ కోపుమ్ జల వెల్లెల మాన్సుల్‍క ఇసి సంగిలన్ ");
INSERT INTO key_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“పరలోకుమ్‍చి రాజిమ్‍తె బెదుక బుకార్లిసి కీసి మెలె, జోచొ పుత్తుస్‍చి రిసొ పెండ్లి విందు దిలొ ఎక్కిలొ రానొ కెర్లిస్‍చి రితి జయెదె. ");
INSERT INTO key_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","జా పెండ్లి విందుతె బుకార్లసక కడ ఆన్‍తి రిసొ, జో రానొ జోచ గొత్తి సుదల్‍క తెద్రయ్‍లన్. గని, జేఁవ్ బుకార్లస జెంక నెసిల. ");
INSERT INTO key_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","జాకయ్, జో రానొ, ‘ఈందె, అంచి విందు తెయార్ కెర అస్సి. బెయిలల్‍క, బేడు జల సొమ్ముల్‍క కండ అస్సి. ఎత్కి తెయార్ కెర అస్సి. విందు కంక జా’ మెన బుకార్లసక అన్నె సంగ” మెన, వేర గొత్తి సుదల్‍క జో రానొ అన్నె సంగ తెద్రయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","జేఁవ్ బుకార్లస జో మాన్సు బుకార్లిస్‍క మరియాద నే దెకితె, జోవయింతె ఎక్కిలొ జోచి బుఁయితె గెలొ, అన్నెక్లొ జోచి బియ్యార్‍తె ఉట్ట గెలొ. ");
INSERT INTO key_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","అన్నె, సేఁస్‍ల సుదల్, జో రానొచ కబుర్ గెల గొత్తి సుదల్‍క దెర కెర, జోక నిస్కారుమ్ కెర, మార గెల. ");
INSERT INTO key_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","జాచి రిసొ, జో రానొ కోపుమ్ జా, జోచ జమాన్లుక తెద్రవ దా, జేఁవ్ అత్య కెర్లసక మొర్తి సిచ్చ దిలొ, చి జోవయించి పట్నుమ్‍క ఆగి లంబడ డయవడ్లొ. ");
INSERT INTO key_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“తెదొడి జో రానొ గొత్తి సుదల్ ఇసి మెన సంగిలన్. ‘పెండ్లి విందు తెయార్ కెర అస్సి, గని బుకార్లస ఈంజ విందుతె జెంక తగుప జలస్ నెంజి. ");
INSERT INTO key_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","జాచి రిసొ, వీదుల్‍తె గెచ్చ కెర, తుమ్‍క డిస్తస ఎత్కిక పెండ్లి విందుతె జా మెన, తుమ్ బుకారా.’ మెన, జోచ గొత్తి సుదల్‍క జో రానొ తెద్రయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","జేఁవ్ గొత్తి సుదల్ వీదుల్‍తె గెచ్చ కెర, ఒత్త డీసిల మాన్సుల్ ఎత్కిక విందుతె బుకారా ఆన్ల, చి జా పెండ్లి బడ్డితె బెర్ల. ");
INSERT INTO key_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“పడ్తొ జో రానొ, ‘పెండ్లి బడ్డితె వెసిలసక దెకిన్‍దె’ మెన, జా పెండ్లి బడ్డిచి తెడి జా కెర, ఒత్త పెండ్లి పాలల్ నే గలన్లొ ఎక్కిలొక దెక కెర, ");
INSERT INTO key_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘ఓ నేస్తమ్, తుయి పెండ్లి పాలల్ నెంజితె ఇన్నె కీసి అయ్‍లది?’ మెన, జో రానొ సంగితికయ్, జో మాన్సు బియఁ గెచ్చ, తుక్లె తిలన్. ");
INSERT INTO key_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","తెదొడి రానొ, ‘ఇన్నెక చట్టొ అత్తొ బంద కెర, ఇన్నెక బయిలె అందర్‍చి కంట అందర్‍తె గల దాస. ఒత్త గెతస ఏడ ఏడ, దంతొ చప్పిల్తె తవుల’ మెన, జోచ గొత్తి సుదల్‍క రానొ సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","పరలోకుమ్‍చి రాజిమ్‍తె బెదుక బుకార్లస ఒగ్గర్‍జిన్ గని నిసాన జలస తొక్కిజిన్ జవుల.” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","తెదొడి పరిసయ్యుల్, కొడొతె యేసుక అడ్జవుక మెన, ");
INSERT INTO key_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","హేరోదు పచ్చెన జతస తెన్ పరిసయ్యుల్ జోచ సొంత సిస్సుల్‍క కి యేసుతె తెద్రయ్‍తికయ్, జేఁవ్ యేసుక, “గురుబాబు, తుయి సత్తిమ్‍చొ మెన జానుమ్. మొకమాటుమ్ నే దెకితె, వెల్లెల మాన్సుల్ కిచ్చొ ఉచరుల గే నే బితె, దేముడు దెకయ్‍లి వాట్‍చి రిసొ సత్తిమ్ తెన్ బోదన కెర్తసి మెన జానుమ్” మెన, పులయ్‍తి రితి సంగ, అన్నె, ");
INSERT INTO key_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","“జలె, రోమ్ దేసిమ్‍చొ కైసర్ రానొక అమ్ సిస్తు దెంక నాయిమ్ గే నాయ్ గే? తూయి కీసి ఉచర్తసి? తుయి అమ్‍క సంగు” మెన, పరిసయ్యుల్ తెద్రయ్‍లస యేసుక పుసిల. ");
INSERT INTO key_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","గని యేసు జోవయించి పెట్టిచి విస్సుమ్ జాన, “ఉప్రమెన్సుచొ మాన్సుల్, తుమ్. అంక కిచ్చొక పరిచ్చ కెర్తసు? ");
INSERT INTO key_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","అల్లె, జా సిస్తు దెతి డబ్బుల్‍చి కాసు ఏక్ అంక దెకవ” మెన, జోవయింక సంగితికయ్, జేఁవ్ జోక ఏక్ వెండి కాసు దెకయ్‍ల. ");
INSERT INTO key_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","యేసు “ఈందె, ఇన్నె కచి పోలిక, కచి నావ్ డీస్తయ్?” మెన జోవయింక పుసిలన్, ");
INSERT INTO key_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","చి జేఁవ్, “కైసర్ రానొచి” మెంతికయ్, యేసు జోవయింక, “కైసర్‍క దెతిసి కైసర్‍క, దేముడుక దెతిసి దేముడుకయ్ దెంక అస్సె” మెన, జోవయింక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","జోచి కోడు సూన ఆచారిమ్ జా, జేఁవ్ వెల్లెల మాన్సుల్ తెద్రయ్‍ల మాన్సుల్ యేసుక ముల దా, ఉట్ట గెల. ");
INSERT INTO key_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","‘మొర గెలెగిన అన్నె జీవ్ జంక నెంజె, అన్నెక్ లోకుమ్‍తె గెచ్చుక నెంజె’ మెన ప్రెజల్‍క సికయ్‍త సద్దూకయ్యులు జా దీసి యేసుతె జా కెర, ");
INSERT INTO key_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“ఓ గురుబాబు, ఎక్కిలొ బోదల్ నెంజితె మొర గెలెగిన, జోచొ బావొసి జో అన్నొస్‍చి తేర్సిక పెండ్లి జా, జోచొ అన్నొస్‍చి నావ్ తెన్ బోదల్ పాయ దెంక అస్సె, మెన, మోసే పూర్గుమ్‍చ సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","జలె, అమ్‍చి తెన్ సత్తుజిన్ బావుడ్లు తిల. వెల్లొ పెండ్లి జా మొర గెలన్. ఇన్నెక బోదల్ నెంజిలి రిసొ, ఇన్నెచి పట్టి జెర్మిలొ బావొస్‍క ఈంజ తేర్సి పెండ్లి కెరన్లి. ");
INSERT INTO key_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","తొల్సుర్ తెంతొ కర్వడ్‍చొ ఎద, వర్స తెన్ వెల్లొచి తేర్సిక దస్సి పెండ్లి జర్గు కెరన మొర గెల. ");
INSERT INTO key_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ఎత్కి మొర గెలి పడ్తొ, ఈంజ తేర్‍బోద కి మొర గెలి. ");
INSERT INTO key_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","జలె, మొర గెలస అన్నె జీవ్ జతె పొదిక, ఈంజేఁవ్ సత్తుజిన్‍తె కక్క ఈంజ తేర్సి జా తయెదె? ఈంజేఁవ్ సత్తుజిన్ వర్స తెన్ ఇన్నెక పెండ్లి జా తిల గెద?” మెన యేసుక పుసిల. ");
INSERT INTO key_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","గని, యేసు జేఁవ్‍క, “తుమ్ దేముడుచి కొడొ నేన అస్సుస్. కిచ్చొక మెలె, దేముడుచి కొడొతె రెగ్డయ్‍లి తుమ్ సదు కెర్లె కి, ఒత్త తిలిసి అర్దుమ్ కెరన్సు నాయ్, చి జో దేముడు కెరయ్‍త కమొ దెకిలెకి, జోచి అదికారుమ్, సెక్తి, కెద్ది గే చినుస్ నాయ్. ");
INSERT INTO key_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","మెలె, మొర గెచ్చ అన్నె జీవ్ జతిస్‍తె, పెండ్లివొ నే జతె, మాన్సుల్ దూతల్‍చి రితి దస్సే తవుల. ");
INSERT INTO key_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","పడ్తొ, ‘మొర గెలస అన్నె జితి నాయ్’ మెన ఉచర, తుమ్ అన్మానుమ్ తెన్ అస్సుస్. జలె, దేముడు తుమ్‍క సొంత సంగిలిసి సదు కెర్సు నాయ్ గె? మొర జీవు జా ఉట్టితి రిసొ, ‘ఆఁవ్ అబ్రాహామ్‍క, ఇస్సాకుక చి యాకోబుక దేముడుయి’, మెన, దేముడు సంగిలి కోడు. ");
INSERT INTO key_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","జలె, జేఁవ్ పూర్గుల్ మొర తిలె కి, జోవయింక జో దేముడు జా తా కామ్‍క జెతయ్ జలె, అన్నెక్ లోకుమ్‍తె గెచ్చ జివ్వి అస్తి మెన రుజ్జు జతయ్. రితి మొర గెలసక నాయ్, గని జీవ్ తిలసకయ్ జో దేముడు.” మెన, యేసు జేఁవ్ సద్దూకయ్యుల్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ప్రెజల్, జలె, జో బోదన కెర్లిస్‍చి రిసొ సూన కెర, ఆచారిమ్ జల. ");
INSERT INTO key_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","‘యేసు సద్దూకయ్యులు చి చోండి ముద్దొ కెర దిలొ’ మెన పరిసయ్యుల్ సూన కెర, యేసుతె బెద అయ్‍ల, ");
INSERT INTO key_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","చి జోవయింతె మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తొసొ ఎక్కిలొ యేసుక పరిచ్చ కెరుక మెన, ఏక్ కోడు పుసిలన్. ");
INSERT INTO key_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“గురుబాబు, ఒండి మోసే పూర్గుమ్‍చొచి అత్తి దేముడు దిలి ఆగ్నల్ తెన్ కేన్ ఆగ్న తొలితొచి ముక్కిమ్‍చి?” ");
INSERT INTO key_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","యేసు జోక, “తుమ్‍చొ ప్రబు జలొ దేముడుక తుమ్‍చి ఒండి పెట్టి తెన్, తుమ్‍చి ఒండి ఆత్మ తెన్, ఒండి మెన్సు తెన్ ఎక్కి ప్రేమ కెర్తె తంక. ");
INSERT INTO key_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ఎత్కి ఆగ్నల్‍తె ఈంజ తొలితొ చి, ముక్కిమ్‍చి. ");
INSERT INTO key_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","అన్నె, ‘తుమ్‍క తుమీ కెద్ది ప్రేమ కెరంతసు గే, తుచి పక్క సుదొక కి తెద్ది ప్రేమ కెర్తె తంక’ మెన, అన్నెక్ ఆగ్న ముక్కిమ్. ");
INSERT INTO key_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","మోసే పూర్గుమ్‍చొచి అత్తి దేముడు రెగ్డయ్‍ల ఆగ్నల్ ఎత్కిక కి, దేముడుచ కబుర్లు సంగిలస సంగుల ఎత్కి కోడు కి, ఈంజేఁవ్ దొన్ని ఆగ్నల్ ఆదారుమ్ జా అస్తి” మెన, యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","పరిసయ్యుల్ ఎత్కి యేసుచి సుట్టునంత బెర తతికయ్, యేసు జోవయింక ఏక్ కోడ్ పుసిలన్. ");
INSERT INTO key_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“రచ్చించుప కెర్తొసొ జతొ క్రీస్తుచి రిసొ తుమ్ కిచ్చొ మెన ఉచర్తసు? జో కచ్చొ పుత్తుసి జయెదె?” మెన పుసితికయ్, జేఁవ్ జోక, “దావీదు రానొచొ పుత్తుసి, జోవయించి సెకుమ్‍చొ” మెలన్. ");
INSERT INTO key_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","జేఁవ్ దస్సి సంగితికయ్, యేసు జోవయింక, “దస్సి జలె, క్రీస్తు దావీదుక పుత్తుసి జలెగిన, దేముడుచి సుద్ది తిలి ఆత్మ సికయ్‍తికయ్, దావీదు రానొ కిచ్చొక క్రీస్తుక ‘ప్రబు’ మెన సంగిలన్. కిచ్చొ కోడుతె దస్సి సంగిలన్ మెలె; ");
INSERT INTO key_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘తుచ విరోదుమ్ సుదల్‍క తుయి సుఁదితి రితి ఆఁవ్ కెర్తె ఎద, అంచి ఉజెతొ పక్కయ్ తుయి పెస తా’ మెన, ప్రబు అంచొ ప్రబుక సంగిలన్.” ");
INSERT INTO key_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","దస్సి దావీదు రానొ క్రీస్తుక ‘ప్రబు’ మెన సంగితయ్ జలె, జో క్రీస్తు కీసి జా జోక పుత్తుసి జయెదె? ఉచర మెన యేసు జేఁవ్ వెల్లెల మాన్సుల్‍క సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","కో కి అన్నెక్ కోడ్ సంగుక నెతిర్ల. అన్నె, జా దీసి తెంతొ, జోవయింతె కో కి యేసుక ఎక్కి కోడు కి పుసుక దయిరిమ్ తిలె నాయ్. ");
INSERT INTO key_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","తెదొడి యేసు జా దేముడుచి గుడితె బెర్ల ప్రెజల్‍క కి జోచ సిస్సుల్‍క కి ఇసి మెలన్. ");
INSERT INTO key_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస చి పరిసయ్యుల్ మోసే పూర్గుమ్‍చొచి పీటతె వెసిలి రితి జా ప్రెజల్‍క మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడుక అదికారుమ్ అస్సె. ");
INSERT INTO key_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","జాకయ్, జేఁవ్ తుమ్‍క సికయ్‍తిసి ఎత్కి కెర, గని, జోవయించ కమొ రితి తుమ్ కెర నాయ్. జేఁవ్, ఇసి కెర, దస్సి కెర, మెన సంగితిసి జేఁవ్ సొంత కెర్తి నాయ్. ");
INSERT INTO key_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","పిమ్మట్, కూలి మాన్సుల్‍క సావుకర్లు కీసి కంది వయితి జాడు వయడుల గే, దస్సి ఈంజేఁవ్ వెల్లెల మాన్సుల్, ఒగ్గర్ ఆగ్నల్ రితి కెరుక అస్సె మెన, ప్రెజల్‍క జాడు వయడ్తి రితి కెర్తతి. గని, జేఁవ్ వయడ్త జాడ్లు రిత కమొ సుల్కన కెర్తి రిసొ జేఁవ్‍చి కిడి ఊంటి కి నే తెన్ జవుస్ కదుల్‍ప కెర్తి నాయ్, ప్రెజల్‍క కన్కారుమ్ జతి నాయ్. ");
INSERT INTO key_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","జోవయించ కమొ కిచ్చొ బుద్ది తెన్ కెర్తతి మెలె, అమ్ కెరంతి పున్నిమ్ మాన్సుల్ మెన్సుతు మెన, దేముడుచ ఆగ్నల్ రెగ్డ రచ్చల్ రిత బంద, రూందు వెల్లొ కెర, నిర్డె బందంతతి, చి జోవయించ పాలల్‍చ జుల్పల్ దీగు కెర్తతి. ");
INSERT INTO key_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","పడ్తొ, విందుల్‍తె ముక్కిమ్ టాన్లుక కోర్‍ప జతతి. అన్నె, జోవయించ సబ గెరలె కి ముక్కిమ్‍చ వెసిత పీటల్ కడన్‍తతి. ");
INSERT INTO key_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","పడ్తొ సంతవీదులె, మాన్సుల్ ఎత్కి అమ్‍క జొకర్తు మెన కోర్‍ప జతతి. పడ్తొ, మాన్సుల్ జోక ‘గురుబాబు’ మెన జొకరుక కి కోర్‍ప జతతి” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“తూమ్, జలె, తుమ్‍తె కక్క ‘గురుబాబు’ మెన నాయ్. తుమ్‍క ఎక్కిలొయి తుమ్‍చొ గురుబాబు రితొ జా అస్సె, చి తుమ్ ఎత్కిజిన్ ఎక్కి జతి రిత బావుడ్లు జా అస్సుస్. ");
INSERT INTO key_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","అన్నె, ఈంజ లోకుమ్‍తెచ కక్క కి ‘దేముడు జలొ అబ్బొ’ మెలి రితి నావ్ తియ నాయ్. కిచ్చొక మెలె, ఎక్కిలొయి తుమ్‍చొ అబ్బొసి జలొ దేముడు, పరలోకుమ్‍తె తిలొసొ. ");
INSERT INTO key_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","అన్నె, తుమ్‍తె కక్క ‘గురు’ మెనుక పోన. కిచ్చొక మెలె, తుమ్‍క క్రీస్తు ఎక్కిలొయి గురు జా అస్సె. ");
INSERT INTO key_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","అన్నె, తుమ్‍చితె కో వెల్లొ జయెదె గే, జో తుమ్‍క గొత్తి సుదొ జా సేవ కెర్సు. ");
INSERT INTO key_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","కో జోవయింక జెఁవ్వి గవురుమ్ కెరంతి రితి జవుల గే, జేఁవ్ దాక్ జవుల, చి కో జోవయింక జెఁవ్వి దాక్ కెరనుల గే, వెల్లెల్ జవుల” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","పడ్తొ వెల్లెల మాన్సుల్‍క యేసు ఇసి మెన తీర్పు సంగిలన్. “అయ్యొ! ఉప్రమెన్సుచొ పరిసయ్యుల్ చి మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస, నాసెనుమ్ జస్తె! కిచ్చొక మెలె, మాన్సుల్‍చి మొక్మె తుమ్ పరలోకుమ్‍చి కెవ్డివొ డంకితసు. కిచ్చొక మెలె, తుమ్ జా రాజిమ్‍తె సొంత బెదుస్ నాయ్, చి బెదుక ఇస్టుమ్ జలస బెదుక తుమ్ ఒప్పుస్ నాయ్. ");
INSERT INTO key_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","అయ్యొ! తుమ్ మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస, పరిసయ్యుల్, నాసెనుమ్ జస్తె! తుమ్ రండెల్ మాన్సుల్‍చ గెరల్ విక కయ్‍లెకి, ‘మాన్సుల్ అమ్‍చి బుద్ది చినుతు నాయ్’ మెన మాన్సుల్‍చి మొక్మె దిగిల ప్రార్దనల్ కెర్తసు. జాకయ్ తుమ్‍చి పాపుమ్ ఒగ్గర్, చి వెల్లి సిచ్చ జస్తె. ");
INSERT INTO key_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“అయ్యొ! ఉప్రమెన్సుచొ పరిసయ్యుల్, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస, నాసెనుమ్ జస్తె! తుమ్ కక్క జలెకు తుమ్‍చి మొత్తుమ్‍తె బెదవంతి రిసొ, సముద్రుమ్ బుఁయి దెకజెతసు, చి జో తుమ్‍చితె బెదిలొ మెలె, జోవయించి బుద్ది తుమ్‍చి బుద్దిచి కంట దొన్ని వాటల్ గార్ జతి రితి కెర్తసు, చి వెల్లి ఆగి గొయ్‍తె తూమ్ గెతె జలె, జో అన్నె దస్సి సిచ్చ జంక విలువ జయెదె. ");
INSERT INTO key_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“అయ్యొ! తుమ్ గుడ్డి రిత జా, ‘మాన్సుల్‍క చెంగిల్ వాట్ దెకడుమ్‍దె’ మెన తుమ్‍క తూమ్ ఉచర్లె కి, చెంగిల్ వాట్ పిట్టయ్‍తస, తుమ్ నాసెనుమ్ జస్తె. తుమ్ సికడ్తిసి ఏక్ కిచ్చొ మెలె, ఎక్కిలొ ‘దేముడుచి గుడి తోడు’ మెన ఒట్టు గలన్లె కిచ్చొ నెంజె, గని ‘దేముడుచి గుడితె తిలి బఙరి తోడు’ మెన ఒట్టు గలన్లె, జో గలిలి ఒట్టు నెరవెర్సుప కెరనుక అస్సె మెన తుమ్ సంగితసు. ");
INSERT INTO key_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","తుమ్ బుద్ది నెంజిల గుడ్డి జల మాన్సుల్. దొన్నితె కేన్ ముక్కిమ్? బఙరి గే, బఙర్‍క చెంగిల్ కెర్తి దేముడుచి గుడి గే? ");
INSERT INTO key_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“అన్నె, ‘బలి దెతి టాన్ సాచి’ మెన ఎక్కిలొ ఒట్టు గలన్లె కిచ్చొ నెంజె, గని ‘జాచి ఉప్పిరి తిలి అర్పితుమ్ సాచి’ మెన ఒట్టు గలన్లె, జో మాన్సు గలిలి జా ఒట్టు నెరవెర్సుప కెరనుక అస్సె” తుమ్ మెంతసు. ");
INSERT INTO key_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","తుమ్ గుడ్డి జల రిత మాన్సుల్, దొన్నితె కేన్ ముక్కిమ్? అర్పితుమ్ గే, అర్పితుమ్‍క సుద్ది కెర్తి బలి దెతి టాన్ గే? ");
INSERT INTO key_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","జలె, బలి దెతి టాన్ తోడు మెన కో ఒట్టు గలన తవుల గే, ‘జేఁవ్‍చి ఉప్పిరి తిలిసి ఎత్కి సాచి’ మెన ఒట్టు గలన్లి రితి జతయ్. ");
INSERT INTO key_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","పడ్తొ, ‘ఈంజ దేముడుచి గుడి సాచి’ మెన కో ఒట్టు గలన తవుల గే, దేముడు సాచి మెన ఒట్టు గలన్లి రితి జతయ్. జో ఒత్త జితయ్‍చి రిసొ. ");
INSERT INTO key_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","అన్నె, ‘పరలోకుమ్ తోడు’ మెన కో ఒట్టు గలన తవుల గే, ‘దేముడుచి సిఙాసనుమ్ తోడు’ మెలి రితి జా, ‘ఒత్త వెసితొసొ తోడు’ మెలి రితి ఒట్టు గలన్లి రితి జతయ్. ");
INSERT INTO key_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“అయ్యొ! ఉప్రమెన్సుచొ, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస చి పరిసయ్యుల్, తుమ్ నాసెనుమ్ జస్తె! తుమ్ పొచెర్‍ఁడొ రొడ్డొతె, చెరమల్లితె, జిల్లకరతె, దస్సచతె దెస్సు వంతుల్ కెర, ఏక్ వంతు దేముడుక దెతసు, గని మోసే తెన్ దేముడు దిలి ఆగ్నల్ తెచ ముక్కిమ్ జల సెలవ్ కొడొ పఁవ్స అస్సుసు. కిచ్చొ కిచ్చొ సెలవ్ కొడొ రితి కెరుక ముల అస్సుస్ మెలె, సత్తిమ్ తెన్ రుజ్జు కెర తీర్పు కెర్తిసి, కన్కారుమ్ జతిసి, చి దేముడుచి ఉప్పిరి నిదానుమ్ నముకుమ్ తితిసి. జోవయించి వంతు దస్స వస్తువల్‍క దెంక తప్పు నాయ్, గని అన్నె ముక్కిమ్ జల సెలవ్ కొడొ రితి తుమ్ కెర్తదు జలె, తుమ్‍క చెంగిల్ తత్తి ");
INSERT INTO key_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","గుడ్డి జల రిత వాట్ దెకయ్‍తస, తూమ్. పితిస్‍తె డోమ తిలె జాక వెంట గెల, ఒంటె తిలె కి నాయ్ మెన జాక గీడ్లి రితి జతసు. ");
INSERT INTO key_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“అయ్యొ! ఉప్రమెన్సుచొ, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస చి పరిసయ్యుల్, నాసెనుమ్ జస్తె! గలస్లు గిన్నలు ఉప్పిరి పక్క మంజితి రితి, చెంగిల్ వేసిమ్ గలంతి రితి జతసు, గని తుమ్‍చి పేట్ తెడి పక్క చోరు బుద్దిచి ఆస బెర అస్సె. ");
INSERT INTO key_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","తుమ్ గుడ్డి రిత పరిసయ్యుల్, గలస్ చి గిన్న తెడి సుబ్రుమ్ కెరుక కీసి ముక్కిమ్ తయెదె గే, దస్సి, తుమ్‍చి బుద్ది చెంగిల్ జలెగిన, నిజుమి పున్నిమ్ రితి చెంగిల్ జంక జయెదె. ");
INSERT INTO key_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“అయ్యొ! ఉప్రమెన్సుచొ, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస, పరిసయ్యుల్, తుమ్ నాసెనుమ్ జస్తె! తుమ్ చున్నుమ్ సరొయ్‍లి మెస్సున్‍చి రితి అస్సుస్. ఉప్పిరి చొక్కిల్ సూటి డీస్తయ్, గని తెడి మొర గెల మాన్సుల్‍చ అడ్డొ, కువ గెలి ముక్కల్ తయెదె. ");
INSERT INTO key_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","దస్సి, తుమ్‍క దెకిత మాన్సుల్‍క నీతిసుదల్‍చ రిత డీస్తసు, గని తుమ్‍చి ఆత్మ తెడి ఉప్రమెన్సు, మూర్కుమ్ బుద్ది బెర అస్సె. ");
INSERT INTO key_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“అయ్యొ! ఉప్రమెన్సుచొ, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస చి పరిసయ్యుల్, తుమ్ నాసెనుమ్ జస్తె! దేముడుచ కబుర్లు సంగిలసక తుమ్‍చ పూర్గుమ్‍చ మార్లి రిసొ తుమ్‍క లాజుచి రిసొ, జేఁవ్ నీతిసుదల్‍చి రిసొ తుమ్ మెస్సున్‍లు బందవ, సూటి కెరవ, ");
INSERT INTO key_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ఆమ్ అమ్‍చ పూర్గుమ్‍చ తిల దీసలె జితమ్ జలె, దేముడుచి కబుర్ ఆన్లసక మార్లిస్‍తె ఆమ్ బెదితమ్ నాయ్” మెనన, నీతి సంగితసు, తుమ్. ");
INSERT INTO key_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","దస్సి మెనన, దేముడుచి కబుర్ ఆన్లసక మార్లసచ పుత్తర్సులు జా అస్సుమ్ మెన, తుమ్‍చి ఉప్పిరి తుమీ సాచి లట్టబంతసు. ");
INSERT INTO key_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","తుమ్‍చ పూర్గుమ్‍చ మొదొల్ తెంతొ కెర్లిసి తుమ్ పూర్తి నెరవెర్సుప కెర, జలె. ");
INSERT INTO key_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“పెట్టి అయిచి విస్సుమ్‍చ, తుమ్. విస్సుమ్‍చ అయివొచి జట్టుచ, వెల్లి ఆగి గొయ్‍తెచి సిచ్చ తుమ్ కీసి పిట్టవన్‍తె? పిట్టవనుక నెతుర్సు. ");
INSERT INTO key_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","జాచి రిసొ, దేముడుచి కబుర్ ఆన్‍తసక కి, బుద్ది సుదల్‍క కి, అంచి సుబుమ్ కబుర్ సికడ్తసక కి తుమ్‍చితె తెద్రయిందె. గని జోవయింతె సగుమ్‍జిన్‍క మార్తె, సిలువల్‍తె గలుల. అన్నె సగుమ్‍జిన్‍క తుమ్‍చ సబ గెరలె కొర్డల్ తెన్ పెట కెర, అల్లర్ కెర, ఏక్ పట్నుమ్ తెంతొ అన్నెక్ పట్నుమ్ ఎద, ఉదడ గెల్తె తస్తె. ");
INSERT INTO key_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","తుమ్ దస్సి కెర్తసుచి రిసొ, మాన్సుల్‍చి అత్తి మొర గెల నీతిసుదల్ ఎత్కిజిన్‍చి లొఁయిచి పాపుమ్ తుమ్‍క లయెదె. నీతి జలొ హేబెలుక మార్లి తెంతొ మొదొల్ కెర, దేముడుచి గుడిచి నెడిమి బలి దెతి టాన్ సొడి తుమ్‍చ అబ్బదింసి మార్లొ బరకీయచొ పుత్తుస్ మెలొ జెకర్యాచి లొఁయి ఎద, ");
INSERT INTO key_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","జా పాపుమ్ ఎత్కి ఈంజ కాలుమ్‍చ మాన్సుల్‍క లయెదె మెన, తుమ్‍క ఆఁవ్ కచితుమ్ సంగితసి. ");
INSERT INTO key_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“ఓ యెరూసలేమ్‍చ, అమ్‍చి యెరూసలేమ్‍చ మాన్సుల్! అమ్ తెద్రయ్‍ల కబుర్ ఆన్లసక, బోదన కెర్లసక పత్రల్ గల మార్తసు. కిచ్చొ ప్రమాదుమ్ నే లయితి రితి కుకిడి జాచి పిల్లల్‍క జాచి రెప్పల్ తెడి కీసి ముద్దొ కెరన తయెదె గే, ఆఁవ్ తుమ్‍క కెత్తిగే సుట్లు ముద్దొ కెరంతి రితి తుమ్‍క చెంగిల్ కెర్తయ్, గని తుమ్ నెసిలదు. ");
INSERT INTO key_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ఈందె, తుమ్‍చి గేర్ కో నెంజితె రితి తుమ్‍క తూమి ముల దెస్తె. ");
INSERT INTO key_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","అప్పె తెంతొ మొదొల్ కెర, ప్రబుచి నావ్ తెన్ జెతొసొక ‘జెయ్యి, జెయ్యి!’ మెన తుమ్ సంగుక దెర్తె ఎదక తుమ్ అంక దెకుక నెతుర్సు మెన, కచితుమ్ సంగితసి” మెన, యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","తెదొడి యేసు దేముడుచి గుడి తెంతొ బార్ జా ఉట్ట గెతె తతికయ్, జోచ సిస్సుల్, ‘ఈంజ దేముడుచి గుడి కెద్ది సూటి కెర అస్తి!’ మెన జోక దెకవుక అయ్‍ల. ");
INSERT INTO key_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","జాచి రిసొ యేసు జోవయింక, “ఈంజ ఎత్కి తుమ్ దెకితసు, గని, తుమ్‍క ఆఁవ్ కిచ్చొ కచితుమ్ సంగితసి మెలె, పత్తుర్‍చి ఉప్పిర్ పత్తుర్ దొంత్రల్ అప్పె తిలె కి, ఎక్కి జలెకు నే టీఁవొ నే జతి దీసి జెయెదె” మెన, సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","పిమ్మట్, యేసు దేముడుచి గుడిచి మొక్మె తిలి ఒలీవ మెట్టయ్ గెచ్చ వెసితికయ్, అన్నె కో నెంతె సిస్సుల్ జోతె జా కెర, “తుయి సంగిలిసి కెఁయఁక జర్గు జయెదె? పిమ్మట్, తుయి ఈంజ లోకుమ్‍తె అన్నె జెతిసి కి, ఈంజ ఉగుమ్ మార్సుప జతిసి కి పాసి జెతయ్ మెన, అమ్ కీసి చినుక జయెదె?” మెన పుసిల. ");
INSERT INTO key_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","జలె యేసు జోవయింక ఇసి మెలన్. “కో జలెకు తుమ్‍క మోసిమ్ నే కెర్తి రితి, తుమ్ జాగర్త దెకన. ");
INSERT INTO key_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","కిచ్చొక మెలె, ఒగ్గర్‍జిన్ మాన్సుల్, ‘అంచి నావ్ తెన్ జా కెర అఁవ్వి క్రీస్తు’ మెన సంగుక జలెకు, ఒగ్గర్‍జిన్‍క మోసిమ్ కెర, వేర బుద్ది సికడుల. ");
INSERT INTO key_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","పిమ్మట్, ‘యుద్దుమ్ జతయ్’ మెన జలెకు, ‘యుద్దుమ్ జెయెదె’ మెన జలెకు, తుమ్ సూన్‍తె. గని, బమ్మ నెంతె తా. ఇసచ ఎత్కి జర్గు జంక అస్సె, గని ఈంజ ఉగుమ్ తెద్ది బేగి పూర్తి జయె నాయ్. ");
INSERT INTO key_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","పిమ్మట్, దేసిమ్‍చి ఉప్పిర్ దేసిమ్, రాజిమ్‍చి ఉప్పిర్ రాజిమ్ యుద్దుమ్‍క టీఁవొ జవుల. అన్నె, వేర వేర దేసిమ్‍లుతె కరులు కి బూకంపల్ కి జర్గు జవుల. ");
INSERT INTO key_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","అంచి రాజిమ్ ఏలుప కెర్తి ఉగుమ్‍క జెర్మయ్‍తి అగ్గె జెతి సల్వ నొప్పుల్ రితి జా, ఇసచ మొదొల్ జవుల. ");
INSERT INTO key_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“దస్సి జర్గు జతి పొదిక, ప్రెజల్ తుమ్‍క స్రెమల్ కెర్తి రిసొ అదికారుల్‍తె సొర్ప కెర మొరవుల. అంచి నావ్‌చి రిసొ, దేసిమ్‍లు ఎత్కితె తుమ్‍క విరోదుమ్ కెరుల. ");
INSERT INTO key_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","దస్సి జర్గు జతిస్‍చి రిసొ, ఒగ్గర్‍జిన్ బమ్మ జా అంక ముల దా, ఎక్కిలొక ఎక్కిలొ మోసిమ్ కెర అదికారుల్‍చి అత్తి దెరవ దెవుల, చి ఎక్కిలొక ఎక్కిలొ విరోదుమ్ జవుల. ");
INSERT INTO key_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","“జేఁవ్ దీసల్‍క, ఒగ్గర్‍జిన్ మాన్సుల్ ‘దేముడుచి కబుర్ సంగితొసొ ఆఁవ్’ మెనన, తుమ్‍చితె జా కెర, వేర బుద్ది సికడ, ఒగ్గర్‍జిన్‍క అంక ములవ దెవుల. ");
INSERT INTO key_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","అన్నె, ‘పాపుమ్ కెర్తిసి ఒగ్గర్ జా గెతయ్’ మెన, ఒగ్గర్‍జిన్‍తె ఎక్కిలొక ఎక్కిలొ ప్రేమ కెర్తిసి పిట్ట గెచ్చెదె. ");
INSERT INTO key_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","దస్సి జలెకి, ఆకర్ ఎద నముకుమ్ తెన్ తా, కో ఓర్సుప జవుల గే, జెఁవ్వి రచ్చించుప జవుల. ");
INSERT INTO key_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","“‘ఒండి లోకుమ్‍చ ప్రెజల్ ఈంజ సాచి సూన తత్తు’ మెన, ఈంజ లోకుమ్ ఎత్కిక పరలోకుమ్‍చి రాజిమ్‍చి రిసొచి ఈంజ అంచి సుబుమ్ కబుర్ సూనయిందె. ఎత్కితె సూనయ్‍లెకయ్ ఆకర్ దీసి జెయెదె” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“జాకయ్, పిమ్మట్‍క, ‘జర్గు జయెదె’ మెన దానియేలు పూర్గుమ్‍చొచి అత్తి రెగ్డయ్‍లి కోడు తిలిసి, మెలె, దేముడుక విరోదుమ్ జా జోక బలే దూసుప కెర నాసెనుమ్ కెర్తిక దేముడుచి గుడితె టీఁవొ జంక, తుమ్ దెకితె, ఇన్నెచి అర్దుమ్ కిచ్చొ మెలె, ఈంజ సదు కెర్తస తుమ్ చెంగిల్ ఉచరన, జలె, జా గుర్తు తుమ్ దెకిలె, ");
INSERT INTO key_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","యూదయ ప్రదేసిమ్‍తెచ మాన్సుల్ చట్కున డొంగ్రలె ఉట్ట నిగుతు. ");
INSERT INTO key_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","జా జర్గు జతిసి తుమ్ దెకిలె, కేన్ మిద్దెచి ఉప్పిర్ తిలొ సుదొ, ఉత్ర కెర, జోచి గెరి తెంతొ కిచ్చొ జలెకు వెంట నెంక ఉత్ర జెంక నాయ్. ");
INSERT INTO key_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","వెడయ్ తిలొ సుదొ, కామ్‍చి రిసొ కడ్ల జోచ సొక్కల్ జవుస్ వెంట నెంక పస్ల జెంక నాయ్. ");
INSERT INTO key_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","“అయ్యొ! జేఁవ్ దీసల్‍క వయ తిల తేర్‍బోదల్, బోదల్ వడ్నివొ ఉట్ట నిగుక నెత్ర ఒగ్గర్ స్రెమల్ జవుల. ");
INSERT INTO key_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","‘చల్లి పొది జవుస్, సెలవ్ కడన్లి దీసి జవుస్ అమ్‍క ఈంజ ఉట్ట నిగితి స్రెమ జెవుస్ నాయ్’ మెన, తుమ్ ప్రార్దన కెర. ");
INSERT INTO key_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","కిచ్చొక మెలె, లోకుమ్ జెర్మున్ జలి తెంతొ అప్పె ఎదక, దస్సి స్రెమ కెఁయ్యఁక కి కలుగు జయె నాయ్, చి తెద్ది స్రెమ కెఁయ్యఁక కి అన్నె జయె నాయ్. ");
INSERT INTO key_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","జాచి రిసొ, తొక్కి దీసల్‍క దస స్రెమల్ జతి రితి ప్రబు సెలవ్ దెతొ నాయ్ జలె, కో కి రచ్చించుప జంక నెత్ర. గని, నంపజతి రిసొ రచ్చనక నిసాన జలస పాడ్ నే జతి రిసొయి, జేఁవ్ స్రెమల్ తొక్కి దీసల్ తతి సెలవ్ అస్సె. ");
INSERT INTO key_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“జా కాలుమ్‍క, ‘ఈందె, క్రీస్తు!’, ‘ఓదె క్రీస్తు’ మెన కో జలెకు తుమ్‍క సంగిలెగిన, తుమ్ నంప కెర నాయ్. ");
INSERT INTO key_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","కిచ్చొక మెలె, అబద్దుమ్‍చ జా కెర, ‘ఆఁవ్ క్రీస్తు’ మెనన జలెకు ‘ఆఁవ్ దేముడుచి కబుర్ ఆన్‍తొసొ’ మెనన జలెకు, రచ్చనక నిసాన్లసక మోసిమ్ కెర జోవయించి నముకుమ్ పిట్టపుక మెన ఉచర, వెల్లెల మాయకమొ కెరుల. ");
INSERT INTO key_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ఈందె, ఈంజ నే జతె అగ్గె తుమ్‍క ఆఁవ్ సంగితసి. ");
INSERT INTO key_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","జాకయ్, కో జలెకు, ‘ఈందె, క్రీస్తు జా బయిలె అస్సె’ మెన సంగిలె జవుస్, తుమ్ ఒత్త గెచ్చ నాయ్. నెంజిలె, ‘ఈందె, గేర్ తెడి మూలయి పెస అస్సె’ మెన సంగిలె జవుస్, నంప కెర నాయ్. ");
INSERT INTO key_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","కిచ్చొక మెలె, బిజిలి తూర్పు పక్క మొల్క, పడమర పక్క గెతె ఎదక కీసి ఉజిడ్ జతయ్ గే, దస్సి కి ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ అన్నె జెతె పొదిక, దస్సి, కేన్ పక్క కి డీసిందె. ");
INSERT INTO key_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","పీనుమ్ కేనె తయెదె గే, ఒత్త గిద్దుల్ బెరుల. ");
INSERT INTO key_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“ఆఁవ్ సంగిలి జా వెల్లి స్రెమచి దీసల్ కేడ్లె, బేగి పొద్దు అందర్ జయెదె. జోను కి ఉజిడి దెయె నాయ్. ఆగాసుమ్ తెంతొ సుక్కల్ గెసురుల, ఆగాసుమ్‍తె ఎత్కి అద్దుర్ జయెదె. ");
INSERT INTO key_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","తెదొడ్‍క ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ జెతిస్‍క గుర్తు ఆగాసుమ్‍తె డీసెదె. సొస్టుమ్ డీసెదె, చి ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ ఆగాసుమ్‍చ మబ్బుల్‍తె ఉత్ర, అంచి అదికారుమ్ అంచి పరలోకుమ్‍చి ఉజిడి తెన్ జెతిసి బూలోకుమ్ తిలి ఎత్కి ప్రెజల్‍చ మాన్సుల్ ఎత్కిజిన్ దెక, జేఁవ్ కెర్ల పాపల్‍చి రిసొ దుకుమ్ కెరనుల. ");
INSERT INTO key_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","తెదొడ్‍క నప్పిర్ గట్టిఙ బజవ, అంచ దూతల్‍క తెద్రయిందె, చి చెత్తర్ పక్కల్ తెంతొ ఆఁవ్ నిసాన అంక నంపజల మాన్సుల్‍క జేఁవ్ ఎక్కితె కుడవుల. ");
INSERT INTO key_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“అంజూరుమ్ రూకుక టాలి కెర అర్దుమ్ కెరన. మెలె, దసొ రూక్‍చ కొమ్మల్ కొవ్‍ని జా పలొయ్‍లె, ‘వేసెగు అప్పె పాఁవ జెయెదె’ మెన, తుమ్ చినితె. ");
INSERT INTO key_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","దస్సి, ఆఁవ్ సంగిల గుర్తుల్ తుమ్ దెకిలె, జా గుమ్ముమె పాఁవిల్ రితి జా అన్నె జెతికయ్ సమయుమ్ పాసి జా అస్సె మెన తుమ్ జాన్‍తె. ");
INSERT INTO key_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ఆఁవ్ సంగిల స్రెమల్, గుర్తుల్ పూర్తి జలెకయ్ ఈంజ ఉగుమ్ అంతుమ్ జయెదె మెన తుమ్‍క ఆఁవ్ కచితుమ్ సంగితసి. ");
INSERT INTO key_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","జలె, ఆగాసుమ్ బుఁయి నాసెనుమ్ జా గెచ్చుల, గని అంచ కొడొ ఎద్గరె పిట్టితి నాయ్. ");
INSERT INTO key_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“జలె, కేన్ దీసిక ఈంజ లోకుమ్‍తె అన్నె జెయిందె గే, జా దీస్, జా గడియ కెఁయెఁక జెయెదె గే, మెన దేముడు అబ్బొక పిట్టవ కేన్ మాన్సు జలెకు, పరలోకుమ్‍చ దూతల్ జలెకు, దేముడు అబ్బొచొ పుత్తుసి జలెకు, కోయి నేనుమ్. ");
INSERT INTO key_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","నోవహు పూర్గుమ్‍చొ తిలి పొది ఎత్కి కీసి తిలి గే, దస్సి ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ అన్నె జెతె పొదిక దస్సి తయెదె. ");
INSERT INTO key_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","మెలె, నోవహు తిలి పొది, దేముడు సంగిలే కి, జా దీసల్‍తె తిల మాన్సుల్ నంప కెర్ల నాయ్, చి జా వర్దల్‍చి పాని పెటుక దెర్లి పొది కి, నోవహుచి కుటుంబుమ్ వెల్లి ఓడతె పెస కెవ్డి డంకిలి ఎద, అన్నె కో కి కతె తా, పితె తా, పెండ్లివొ కెర్తె తా, కిచ్చొ నే జతి రితి బుల్తె తిల. ");
INSERT INTO key_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","జా వర్దల్ పాని గెడ్సుప జతిసి నిజుమి జర్గు జంక తిలి మెన నంప నే కెరంతికయ్, జా జర్గు జతికయ్, జేఁవ్ ఎత్కిజిన్‍క బూరుమ్ గుడ్డ నిలి, చి డుఙ గెల. దస్సి, ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ అన్నె ఉత్ర జెతిసి తెన్ కి, ఒగ్గర్‍జిన్ మాన్సుల్ అంక నే సూన్‍తె, జోవయింక ఇస్టుమ్ అయ్‍లి రితి కెర్తె తవుల, చి తెదొడ్‍క నాసెనుమ్ జాఁ గెచ్చుల. ");
INSERT INTO key_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“జా కాలుమ్‍క, దొగుల బట్టి తిలె, ఎక్కిలొక ముల దా, అన్నెక్లొక కడ నెవుల. ");
INSERT INTO key_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","దొగుల తేర్‍బోదల్ తిర్వేల్ తెన్ రోడ్తె తిలె, ఎక్లిక ముల దా, అన్నెక్లిక కడ నెవుల. ");
INSERT INTO key_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“జలె, కేన్ సమయుమ్‍క తుమ్‍చొ ప్రబు ఆఁవ్ అన్నె జెయిందె గే, తుమ్ నేన్సు. జాచి రిసొ, తుమ్ తెలివి తా, అంక రకితె తా. ");
INSERT INTO key_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","గని ఏక్ టాలి అర్దుమ్ కెరన. ‘కేన్ సమయుమ్‍క చోరు జెయెదె గే, గెర్‍చొ ఎజొమాని కో జలెకు జాన్‍తొ జలె, జో జా సమయుమ్‍క చెద్దొయి తా, రకితె తా, జోచొ గెరి చోరు నే పెసితి రితి దెకన్‍తొ’ మెలి కోడుక తుమ్ అర్దుమ్ కెరన. ");
INSERT INTO key_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","మెలె, తుమ్ నే ఉచర్లి సమయుమ్‍క ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ అన్నె జెయిందె. జాచి రిసొ, తుమ్ తెయార్ జా, తెలివి తెన్ రకితె తా. ");
INSERT INTO key_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“జలె, ప్రయానుమ్ గెచ్చుక మెన ఎజొమాని బార్ జంక జలె, జోచ గేర్‍చక దెక సమయుమ్‍క అన్నిమ్ దెంక మెన జో నిసాన్లొ బుద్ది తిలొ నిదానుమ్‍చొ గొత్తి సుదొ కో జవుల? ");
INSERT INTO key_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","జో ఎజొమాని అన్నె ఉట్ట అయ్‍లె, జో గొత్తి సుదొ జో ఎజొమాని తియార్లి కామ్ కెర్తె తిలె, జోక చెంగిలి. ");
INSERT INTO key_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","దస్సి నిదానుమ్ కెర్తె తిలొ మెలె, జో ఎజొమాని అయ్‍లె, జోచి ఆస్తి ఎత్కిచి ఉప్పిరి జో గొత్తి సుదొక అదికారుమ్ దెయెదె, తుమ్‍క ఆఁవ్ కిచ్చొ కచితుమ్ సంగితసి. ");
INSERT INTO key_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“జో గొత్తి సుదొ గార్ సుదొ జలె, ‘ఎజొమాని ఆల్సిమ్ కెర్తయ్’ మెన ఉచర, ");
INSERT INTO key_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","జోచి తెన్ తిల గొత్తి సుదల్‍క పెటుక మొదొల్ కెర, సూర్ పిత మాన్సుల్ తెన్ బెద, జేఁవ్ కతిసి పితిస్‍తె బెద దస్స అలవాట్లు సికెదె. ");
INSERT INTO key_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","‘ఎజొమాని ఆజి జెయె నాయ్’ మెన గొత్తి సుదొ ఉచర, నే రకితె దీసిక గడియక జో ఎజొమాని ఉట్ట అయ్‍లె, ");
INSERT INTO key_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","జోక మొర్తి సిచ్చ తియడ కెర, ఉప్రమెన్సుచ మాన్సుల్ సిచ్చ జతిస్‍తె గలెదె. ఒత్త గెతస సిచ్చక ఏడ్తె తవుల, దంతొ చప్పిల్తె తవుల. ");
INSERT INTO key_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“పరలోకుమ్‍చి రాజిమ్‍చి ఉజిడి తెన్ ఆఁవ్ అన్నె జెతిస్‍క రకితిసి కీసి జయెదె మెలె, పెండ్లి ఉబేడొక దస్సుల్ జంక మెన, దెస్సుజిన్ ఉబెడివొ దివ్వొ దెరన బార్ జలిస్‍చి రితి జయెదె. ");
INSERT INTO key_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","జోవయింతె బుద్ది నెంజిలస పాఁచ్‍జిన్, చి బుద్ది తిలస పాఁచ్‍జిన్ తిల. ");
INSERT INTO key_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","బుద్ది నెంజిలస జోవయించ దివ్వొ దెరన, తేల్ నే దెర్తె గెల. ");
INSERT INTO key_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","గని బుద్ది తిలస, మాత్రుమ్, జోవయించ దివ్వొ కి, అన్నె సువితి తేల్ కి దెరన గెల. ");
INSERT INTO key_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","“పెండ్లిఉబేడొ ఆల్సిమ్ కెర్తికయ్, జేఁవ్ దెస్సుజిన్ గూన్‌క జుమ నిజిల. ");
INSERT INTO key_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","సొక్కుక, ఈందె, పెండ్లిఉబేడొ జెతయ్. జోక దస్సుల్ జంక బార్ జా” మెన, బారికి కేకుల్ గల్తికయ్, ");
INSERT INTO key_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","జేఁవ్ దెస్సుజిన్ ఉబెడివొ ఎత్కిజిన్ సూన కెర, ఉట్ట, జోవయించ దివ్వొచ వాటివొ చెంగిల్ కెరన, ");
INSERT INTO key_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","జోవయింతె జేఁవ్ పాఁచ్‍జిన్ బుద్ది నెంజిలస, అమ్‍చ దివ్వొ విజ గెతతి. తుమ్‍చి తేల్ సగుమ్ అమ్‍క దా మెన, బుద్ది తిల తెయార్ జలసక సంగిలి ");
INSERT INTO key_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","జేఁవ్ తెలివి జా తిలస అమ్‍తె తిలిసి అమ్‍క తుమ్‍క పాఁవె నాయ్. సావుకర్లుతె తుమ్ గెచ్చ, తుమ్‍చి రిసొ గెనన మెన సంగిలి. ");
INSERT INTO key_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“జలె, సమయుమ్‍క బుద్ది నెంజిలస తేల్ గెనుక గెతె తతికయ్, పెండ్లిఉబేడొ పాఁవ అయ్‍లన్, చి తెయార్ జా తిలస జోవయింతెన్ బెద పెండ్లి గెరి పెస, విందుతె వెసిల. తెదొడి, విందు దెతొసొ కెవ్డి డంక దిలొ. ");
INSERT INTO key_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","డంక దిలి పిమ్మట్, బుద్ది నెంజిల ఉబెడివొ ఒత్త జా కెర, ‘బాబు, బాబు, అమ్‍క కెవ్డి ఉగుడ దే’ మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","జో ఎజొమాని జోవయింక, ‘ఆఁవ్ తుమ్‍క నేని మెన తుమ్‍క నిజుమి ఆఁవ్ సంగితసి’ మెన సంగెదె. ");
INSERT INTO key_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","జలె, ఆఁవ్ ఉట్ట గెలె, కేన్ దీసిక కేన్ గంటక అన్నె జెయిందె గే, తుమ్ నేన్సు, చి రిసొ తెలివి తా రకితె తా. ");
INSERT INTO key_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“ఏక్ మాన్సు ప్రయానుమ్ గెచ్చుక తిలి రిసొ, జోచ గొత్తి సుదల్‍క బుకారా కెర, ‘చెంగిల్ రకుతు’ మెన జోచి ఆస్తి ఎత్కి జోవయించి అత్తి సొర్ప కెర దిలన్. ");
INSERT INTO key_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ఎక్కిలొక పాంచ్ తాలంతుల్, ఎక్కిలొక దొన్ని తాలంతుల్, ఎక్కిలొక ఎక్కి తాలంతు, దస్సి. కక్క జేఁవ్ వాడిక కెర్తి సెక్తిచి ఎదిలి వంట దా కెర, బార్ జా, ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","జలె, జేఁవ్ గొత్తిమాన్సుల్‍తె పాంచ్ తాలంతుల్ కడన్లొసొ గెచ్చ, జేఁవ్ తెన్ బియ్యార్ కెర, అన్నె పాంచ్ తాలంతుల్ లాబుమ్ కెరన బెదయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","దస్సి, దొన్ని తాలంతుల్ కడన్లొసొ అన్నె దొన్ని తాలంతుల్ లాబుమ్ కెరన బెదయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","జలె, ఏక్ తాలంతు కడన్లొసొ గెచ్చ, బుఁయి కూన కెర, జోచొ ఎజొమాని దిలి దనుమ్ లుంకడ దిలన్. ");
INSERT INTO key_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“ఒగ్గర్ దీసల్ గెలి పిమ్మట్, జేఁవ్ గొత్తి సుదల్‍చొ ఎజొమాని అన్నె జా కెర, జోవయింక దిలి జోచి డబ్బుల్ లెక్క కెర నఙనుక మెన, జోవయింక బుకార్లొ. ");
INSERT INTO key_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","తెదొడి, పాంచ్ తాలంతుల్ కడన్లొసొ పుర్రె జా కెర, బాబు తుయి పాంచ్ తాలంతుల్ అంక దిలది, చి ఈందె, ఆఁవ్ అన్నె పాంచ్ తాలంతుల్ బెదయ్‍లయ్” మెన, జా డబ్బుల్ ఎత్కి ఆన దెకయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","జలె, జా ఎజొమాని జోక, “తుయి నిదానుమ్ తిలొ చెంగిలొ గొత్తి సుదొ, ఈంజ ఇదిల్ తుక దిలయ్, గని తుచొ ఎజొమానిచి రిసొ నిదానుమ్ తెన్ లాబుమ్ కెర్లది చి రిసొ, ఇన్నెచి కంట ఒగ్గర్ ఆస్తిచి ఉప్పిరి తుక అదికారుమ్ దెయిందె. తుచొ ఎజొమానిచి సంతోసుమ్‍తె తుయి బెదు” మెన జోక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“దస్సి, దొన్ని తాలంతుల్ కడన్లొసొ కి పుర్రె జా కెర, ‘బాబు, తుయి అంక దొన్ని తాలంతుల్ దిలది, చి ఈందె ఆఁవ్ దొన్ని తాలంతుల్ లాబుమ్ బెదయ్‍లయ్’ మెన సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","జోచొ ఎజొమాని, ‘నిదానుమ్ తిలొ చెంగిలొ గొత్తి సుదొ, తుయి. ఈంజ ఇదిల్ తెన్ అంచి కామ్ నిదానుమ్ కెర్లది. అప్పె ఒగ్గర్‍చి ఉప్పిరి కి తుక అదికారుమ్ దెయిందె. తుచొ ఎజొమానిచి సంతోసుమ్‍తె తుయి బెదు’ మెన జోక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“పిమ్మట్, ఎక్కి తాలంతు కడన్లొసొ జా కెర, బాబు, తుయ్ ‘కన్కారుమ్ నెంజిలొసొ’ మెన, ‘తుయి నే ఉంపిలి పంటొ, లాయితొసొ’ మెన, ‘తుయి నే పూన్లిస్‍తె కుడవంతొసొ’ మెన, ఆఁవ్ జాని. ");
INSERT INTO key_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","జాచి రిసొ, ఆఁవ్ తుక బియఁ కెర, తుయి దిలి తాలంతు జాగర్త తెన్ బుఁయ్యె రోవ దిలయ్, చి జెతికయ్, ఉట్కవ ఆన్లయ్. ఈందె, కడను” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","గని, జోచొ ఎజొమాని జోక, “గర్చొచొ బద్దుకుమ్‍చొ గొత్తి సుదొ తుయి. ఆఁవ్ నే ఉంపిలిస్‍తె లాయితొసొ మెన, నే పూన్లిసి కుడవంతొసొ మెన తుయి జాన్లది? ");
INSERT INTO key_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","జలె అంచి డబ్బుల్ కేన్ జవుస్ సావుకారితె తుయి దా తత్తది జలె, ఆఁవ్ అయ్‍లె అంచి డబ్బుల్ వడ్డి తెన్ నఙన్‍తయ్” మెన, జో గొత్తి సుదొక గోల కెర, ");
INSERT INTO key_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","జా తాలంతు జో గొత్తి సుదొ తెంతొ నఙన, దెస్సు తాలంతుల్ తిలొసొక దేసు. ");
INSERT INTO key_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ఇదిల్ జవుస్ తిలొసొక అన్నె దెంక జయెదె, గని నెంజిలొసొతె తెంతొ జోక తిలిసి కి కడ గెలుక జయెదె. ");
INSERT INTO key_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","జో కామ్‍క నెంజిలొ గొత్తి సుదొక అందర్‍చి కంట రితి అందర్‍తె బయిలె గల దాస. ఒత్త గెలస జా సిచ్చక ఏడ ఏడ, దంతొ చప్పిల్తె తవుల మెన, ఎజొమాని ఆడ్ర దిలన్. ");
INSERT INTO key_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ, అంచ దేముడుచి దూతల్ తెన్ పరలోకుమ్‍చి ఉజిడి తెన్ అన్నె జెతె పొదిక, అంచి ఒత్తచి ఉజిడ్‍చి సింగాసనుమ్‍తె వెసిందె. ");
INSERT INTO key_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","మంద రకితొసొ, మంద ఎత్కి ఎక్కితె కుడవన, కీసి మెండల్ తెంతొ గొర్రెల్‍క వేర కెరెదె గే, తెదొడ్‍క ఆఁవ్ అన్నె జెతె పొదిక దేసిమ్‍లు ఎత్కితెచ ప్రెజల్ ఎత్కిజిన్‍క అంచి మొక్మె కుడవన కెర, నంపజలస తెంతొ నంపనెంజిలసక వేర కెరిందె. ");
INSERT INTO key_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","అంచి ఉజెతొ పక్క మెండల్ రిత నంపజలసక, డెబ్రి పక్క గొర్రెల్ రిత నంపనెంజిలసక టీఁవొ కెరెదె. ");
INSERT INTO key_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“ఒత్త తెంతొ, ఆఁవ్ పరలోకుమ్‍చొ రానొ, అంచి ఉజెతొ పక్క తిలసక కిచ్చొ మెనిందె మెలె, అంచొ అబ్బొ రచ్చన వరుమ్ దిలస, తూమ్. బూలోకుమ్ జెర్మయ్‍లి పొది తెంతొ తుమ్‍చి రిసొ తెయార్ కెర్లి రాజిమ్‍తె తుమ్‍చి వాట తూమ్ నఙన. ");
INSERT INTO key_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","కిచ్చొక మెలె, అంక చూ కెర్తికయ్, తుమ్ అంక అన్నిమ్ దిలదు, అంక తాన్ కెర్తికయ్, తుమ్ పాని దిలదు. వేర దేసిమ్‍చొ జా తిలయ్, గని అంక తుమ్‍చితె బెదవన్లదు. ");
INSERT INTO key_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","అంక సరిపుచుప జత పాలల్ నెంజితికయ్, అంక పాలల్ దిలదు. జొర్జొ తెన్ తతికయ్, అంక దెకుక అయ్‍లదు. జేల్‍తె తతికయ్, ఒత్త అంక దయిరిమ్ కెరుక అయ్‍లదు” మెన, సంగిందె. ");
INSERT INTO key_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“జా కోడు సూన్లె, పున్నిమ్ మెన జో తీర్పు సంగిలస కిచ్చొ మెనుల మెలె, ప్రబు, తుయి కెఁయ్య చూ జలిసి దెకిలమ్ చి అన్నిమ్ దిలమ్? తుక కెఁయ్య తాన్ కెర్లిసి దెకిలమ్ చి పాని దిలమ్? ");
INSERT INTO key_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","తుయి కెఁయ్య వేర దేసిమ్ తెంతొ అయ్‍లిసి దెకిలమ్ చి అమ్‍చి తెన్ బెదవన్లమ్? కెఁయ్య తుక పాలల్ నెంజిలిసి దెకిలమ్ చి పాలల్ దిలమ్? ");
INSERT INTO key_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","తుక జొర్జొ తిలిసి, తుయి జేల్‍తె తిలిసి కెఁయ్య దెకిలమ్, చి దయిరిమ్ కెరుక గెలమ్? కెఁయ్య నాయ్, కిచ్చొగె” మెన సంగుల, జేఁవ్, పున్నిమ్ జలస. ");
INSERT INTO key_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","జేఁవ్ దస్సి సంగిలె, రానొ జోవయింక కిచ్చొ మెనిందె మెలె, తుమ్‍క ఆఁవ్ కిచ్చొ కచితుమ్ సంగితసి మెలె, అంచ బావుడ్లు జల ఈంజేఁవ్ అంచ మాన్సుల్‍క తుమ్ మరియాద కెర్లిసి, అంక కి మరియాద కెర్లి రితి జలి మెనిందె. ");
INSERT INTO key_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“పడ్తొ, జా దీసిక అంచి డెబ్రి పక్క తిలసక కిచ్చొ మెనిందె మెలె, గర్చ, తూమ్, గెచ్చ! సయ్‍తానుక చి జోచ దూతల్‍క గల్తి రిసొ తెయార్ కెర్లి నే విజితి ఆగితె తుమ్ సేడ! ");
INSERT INTO key_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","కిచ్చొక మెలె, అంక చూ కెర్లి పొది తుమ్ అంక అన్నిమ్ దిలదు నాయ్. అంక తాన్ కెర్తికయ్, పాని దిలదు నాయ్. ");
INSERT INTO key_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","వేర దేసిమ్‍చొ ఆఁవ్ అయ్‍లె కి, అంక తుమ్ బెదవన్సు నాయ్. సరిపుచుప జత పాలల్ నెంజిలి పొది, అంక తుమ్ పాలల్ దిలదు నాయ్. జబ్బు తెన్ తిలె కి, జేల్‍తె తిలె కి, తుమ్ అంక దెకుక అయ్‍లదు నాయ్, మెన అంచి డెబ్రి పక్క తిలసక సంగిందె. ");
INSERT INTO key_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","తెదొడ్‍క జేఁవ్ కి ఇసి మెన జబాబ్ దెవుల. ప్రబు, తుక చూ కెర్తికయ్, తాన్ కెర్తికయ్, తుయి వేర దేసిమ్‍చొ జెతికయ్, పాలల్ నెంతె తతికయ్, జొర్జొ తెన్ తతికయ్, జేల్‍తె తతికయ్, అమ్ తుక తోడు కెరుక నాయ్ గె? మెన సంగుల. ");
INSERT INTO key_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","జోవయింక ఆఁవ్ కిచ్చొ జబాబ్ దెయిందె మెలె, తుమ్‍క ఆఁవ్ కిచ్చొ కచితుమ్ సంగితసి మెలె, అంచ మాన్సుల్‍తె కక్క కి తుమ్ ఇసి నే కెర్లిసి, అంక కి నే కెర్లి రితి జలి, మెన జోవయింక సంగుమ్‍దె, ");
INSERT INTO key_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","చి కెఁయఁక తెఁయఁక సిచ్చ జతిస్‍తె గెచ్చుల, గని పున్నిమ్ జలస కెఁయఁక తెఁయఁక పరలోకుమ్‍తె జింక గెచ్చుల.” మెన సిస్సుల్‍క యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","యేసు సిస్సుల్‍క ఈంజేఁవ్ కొడొ ఎత్కి సంగ కేడయ్‍లి పిమ్మట్ జర్గు జలిసి కిచ్చొ మెలె, జో జోచ సిస్సుల్‍క, ");
INSERT INTO key_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“దొరతి గెలె, పస్కా పండుగు జెయెదె మెన తుమ్ జాన్సు. జా పొదిక, ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొక సిలువతె టీఁవొ కెర మార్తి రిసొ, అంక దెర దెయెదె” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","జా సమయుమి, వెల్లెల పూజర్లు కి వెల్లెల మాన్సుల్‍తె అన్నె సగుమ్‍జిన్ కి, కయప మెంతొ ఎత్కిక వెల్లొ పూజరిచి గేర్‍తె బెద జా కెర, ");
INSERT INTO key_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","కీసిగె లుంకచోరు యేసుక దెర, మారుక మెన, బెద ఉచర్ల, గని, ");
INSERT INTO key_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“పండుగు పొది పోని, నెంజిలె పండుగ్‍క బెర అయ్‍ల ప్రెజల్ కుమ్మత్ తెన్ గగ్గొల్ జా అమ్‍క బలే అల్లర్ కెరుల” మెన సంగితె తిల. ");
INSERT INTO key_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","జలె, యేసు బేతనియ గఁవ్వి గెచ్చ కెర, సీమోను మెలొ వెల్లి రోగి జా తిలొ ఎక్కిలొచొ గెరి తిలి పొది, ");
INSERT INTO key_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ఏక్ తేర్‍బోద, ఒగ్గర్ చెంగిలి విలువచి వాసెన తేల్‍చి బుడ్డి దెరన, జోతె అయ్‍లి. అన్నె, జో అన్నిమ్ కంక వెస తతికయ్, జోచి బోడి ఉప్పిరి సుఁవిలి. ");
INSERT INTO key_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","సిస్సుల్ దెక కెర, కోపుమ్ జా, “ఈంజ నస్టుమ్ కిచ్చొక? ");
INSERT INTO key_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ఈంజ తేల్ ఒగ్గర్ కరీద్‍క వికిలెగిన, బీద మాన్సుల్‍క దర్ముమ్ దెంక జతి” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","యేసు జా కోడు జాన్లి రిసొ, “ఈంజ తేర్‍బోద అంక కెర్లిసి చెంగిల్ వెల్లొ కామ్. తుమ్ కిచ్చొక ఇన్నెక ఉస్సుర్ కెరుక? ");
INSERT INTO key_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","బీద మాన్సుల్ కెఁయఁక కి తుమ్‍చి తెన్ తవుల, గని ఆఁవ్ కెఁయఁక తెఁయఁక తుమ్‍చి తెన్ ఈంజ లోకుమ్‍తె ఇసి తయె నాయ్. ");
INSERT INTO key_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ఈంజ తేర్‍బోద ఈంజ వాసెన తేల్ అంచి ఆఁగ్‍తె సువ కిచ్చొ గుర్తు కెర్తయ్ మెలె, ఆఁవ్ నే మొర్తె అగ్గె, అంక నే రోవితె అగ్గె, అంచి ఆఁగ్ తెయార్ కెర్తి గుర్తు కెర్తయ్. ");
INSERT INTO key_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","తుమ్‍క ఆఁవ్ కిచ్చొ నిజుమి సంగితసి మెలె, ఒండి లోకుమ్‍తె కేనె ఈంజ అంచి సుబుమ్ కబుర్ బోదన కెరుల గే, ఒత్తయ్ ఈంజ అప్పె కెర్లిసి సంగ, ఇన్నెచి రిసొ ఉచరవడుల” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","తెదొడి, బారజిన్ సిస్సుల్‍తె తిలొ ఇస్కరియోతు గఁవ్విచొ యూదా, వెల్లెల పూజర్లుతె గెచ్చ కెర, ");
INSERT INTO key_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“ఆఁవ్ యేసుక తుమ్‍క దెర దిలెగిన, తుమ్ అంక కిచ్చొ దెస్తె?” మెన పుసిలన్. జేఁవ్ జోక ముప్పయ్ వెండి బిల్లల్ దిల. ");
INSERT INTO key_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","జా గడియ తెంతొ యూదా యేసుక దెర దెంక మెన సమయుమ్ చజితె తిలన్. ");
INSERT INTO key_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","నే పులయ్‍ల పోడియొ కతి పండుగ్‍క తొలితొ చి దీసి, సిస్సుల్ యేసుతె జా కెర, “తుయి పస్కా అన్నిమ్ కెర్తి రిసొ, అమ్ కేన్ టాన్ తెయార్ కెరుక?” మెన, జోక పుసిల. ");
INSERT INTO key_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","చి యేసు జేఁవ్‍క, “యెరూసలేమ్‍తె తిలొ పలాన్ సుదొతె తుమ్ గెచ్చ కెర, ‘అంచి సమయుమ్ పాఁవ జా అస్సె. అంచ సిస్సుల్ తెన్ తుచి గెరి పండుగు కెరిందె’ మెన, ప్రబు తుక సంగ మెన అమ్‍క తెద్రయ్‍లొ” మెలన్. ");
INSERT INTO key_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","యేసు జోవయింక, సంగిలి రితి జేఁవ్ సిస్సుల్ కెర, పస్కా అన్నిమ్‍క దొర్కు జలిసి తెయార్ కెర్ల. ");
INSERT INTO key_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","సాంజ్ జతికయ్, యేసు జేఁవ్ బారజిన్ సిస్సుల్ తెన్ అన్నిమ్ కంక వెసిల. ");
INSERT INTO key_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","జేఁవ్ అన్నిమ్ కత్తె తతికయ్, యేసు జేఁవ్‍క, “తుమ్‍క ఆఁవ్ కిచ్చొ కచితుమ్ సంగితసి మెలె, తుమ్‍చితె ఎక్కిలొ అంక విరోదుమ్ సుదల్‍చి అత్తి సొర్ప కెర దెయెదె” మెలన్. ");
INSERT INTO key_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","దస్సి మెంతికయ్, జేఁవ్ ఒగ్గర్ దుకుమ్ తెన్ ఎత్కి మాన్సు, “ప్రబు, ఆఁవ్ గే?” మెన పుసిల, ");
INSERT INTO key_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","చి యేసు కిచ్చొ జబాబ్ దిలన్ మెలె, “అంచి తెన్ పలెరుమ్‍తె కో ఆతు గల పోడి గండ బుడ్డవ తయెదె గే, జొయ్యి అంక దెర, సొర్ప కెర దెయెదె. ");
INSERT INTO key_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","“ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొచి రిసొ రెగిడ్లి రితి ఆఁవ్ ఉట్ట గెచ్చిందె. గని, అయ్యొ! ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొక, కేన్ మాన్సు దెర విరోదుమ్ సుదల్‍చి అత్తి సొర్ప కెర దెయెదె గే, జో మాన్సు జతి సిచ్చచి రిసొ, జో నే జెర్మ తిలె జోక చెంగిల్ తత్తి” మెన, యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","జోక దెర దెతొ యూదా “గురుబాబు, ఆఁవ్ గె?” మెన సంగితికయ్, యేసు జోక, “తుయి జా సంగిలి” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","యేసు, సిస్సుల్, జా పస్కా అన్నిమ్ కెర్తె తా, యేసు పోడియొ దెరన, “దయ కెర్లది” మెలి రితి దేముడు అబ్బొస్‍క జొకర కెర, జా పోడియొ మోడ, సిస్సుల్‍క వంట దా, జోవయింక, “తుమ్ ఈంజ కడన కా. అంచి ఆఁగుక ఈంజ గుర్తు జయెదె” మెన కెర, ");
INSERT INTO key_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ఏక్ గిన్నచి ద్రాచ రస్సుమ్ దెర, దేముడు అబ్బొస్‍క అన్నె ఉచర, సిస్సుల్‍క దా కెర, “ఇన్నెచి రస్సుమ్ పియ. ");
INSERT INTO key_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","కిచ్చొక మెలె, ఈంజ రస్సుమ్ కిచ్చొ గుర్తుచి మెలె, ఒగ్గర్‍జిన్ మాన్సుల్‍చి పాపుమ్ గెచ్చయ్‍తి రిసొ అంచి లొఁయి సూఁయి జంక అస్సె మెన నొవి ప్రమానుమ్. ");
INSERT INTO key_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","అంచొ అబ్బొచి రాజిమ్‍తె తుమ్‍చి తెన్ ఇసి ఆఁవ్ ద్రాచ రస్సుమ్ నొవర్ పితి ఎద, ఇసిచి అన్నె పియ నాయ్ మెన తుమ్‍క సంగితసి” మెన, సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","తెదొడి, జేఁవ్ దేముడుక గనుమ్ గాయ కెర, బార్ జా కెర, ఒలీవ మెట్టయ్ ఉట్ట గెల. ");
INSERT INTO key_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","తెదొడి యేసు జోవయింక, “ఆజి రాతిక, తుమ్ ఎత్కిజిన్ అంచి రిసొ బమ్మ జా అంక ములితె. కిచ్చొక మెలె, మెండల్ రకితొసొక మొరయిందె, చి జోచ మెండల్ ఎత్కిజిన్ చెదుర్ప జా గెచ్చుల మెన దేముడు రెగ్డయ్‍లి కోడు నెరవెర్సుప జంక అస్సె. ");
INSERT INTO key_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","గని, ఆఁవ్ అన్నె జీవ్ జా ఉట్లి పిమ్మట్, తుమ్‍చి కంట అగ్గె గలిలయ ప్రాంతుమ్‍తె గెచ్చిందె” మెన, ప్రమానుమ్ కెర్లన్. ");
INSERT INTO key_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","జాకయ్ పేతురు, “తుచి రిసొ ఎత్కిజిన్ బమ్మ జా తుక ములిలెకి, ఆఁవ్ తుక కెఁయంక ములి నాయ్” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","యేసు జోక, “తుక ఆఁవ్ కిచ్చొ నిజుమి కచితుమ్ సంగితసి మెలె, ఆజి రాతిక, కుకుడొ నే వాఁసితె అగ్గె, ‘జోక నేని’ మెన అంచి రిసొ తివ్వెరి తుయి సంగితె” మెన, సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","పేతురు జోక అన్నె, “ఆఁవ్ తుచి తెన్ మొరుక అస్సె మెలె కి, ఆఁవ్ తుక ‘నేని’ మెన, కెఁయ్యఁక కి సంగి నాయ్” మెన సంగిలన్, చి సిస్సుల్ ఎత్కిజిన్ కి దస్సి మెల. ");
INSERT INTO key_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","తెదొడి యేసు సిస్సుల్ తెన్ గెత్సేమనే మెంతి తోటతె గెచ్చ కెర, జో “ఆఁవ్ ఒత్తల్‍తొ గెచ్చ ప్రార్దన కెర జెతి ఎద, తుమ్ ఇన్నె వెస తా” మెన సంగ కెర, ");
INSERT INTO key_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ఎక్కి పేతురుక చి జెబెదయిచ దొగుల పుత్తర్సుల్ జత యాకోబుక చి యోహానుక పట్టి కడన, ఇదిల్ దూరి గెచ్చ కెర, దుకుమ్ దా, మెన్సుతె ఒగ్గర్ బాద సేడుక దెర్లొ. ");
INSERT INTO key_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","తెదొడి, “అంచి పెట్టి తిలి దుకుమ్ రిసొ మొర గెచ్చుక జయెదె. తుమ్ ఇన్నె తా, అంచి తెన్ చెదొయి తా” మెన, సంగ కెర, ");
INSERT INTO key_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","సగుమ్ దూరి గెచ్చ కెర, సెర్ను సేడ, దేముడు అబ్బొస్‍క ఇసి మెన ప్రార్దన కెర్లన్. “ఓ బ, జతి లెక జలె, ఈంజ గిన్నచి ఆఁవ్ నే పితి రితి అంక పిట్టవు, గని అంచి ఇస్టుమ్ పోని. తుచి ఇస్టుమ్ జర్గు జవుస్” మెన, ప్రార్దన కెర, ఉట్ట కెర, ");
INSERT INTO key_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","జేఁవ్ సిస్సుల్‍తె అన్నె ఉట్ట జా, జేఁవ్ నిజ అస్తి మెన దెక కెర, పేతురుక, “జలె, ఎక్కి గడియ జలెకు అంచి తెన్ తుయి రకితె తంక నెతిర్లది గే? ");
INSERT INTO key_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","జత అల్లర్‍తె తుయి పాపుమ్ నే కెర్తె రితి జాగర్త తా ప్రార్దన కెర్తె తా. ‘ఆత్మ నిదానుమ్ అస్సె’ మెన ఉచరన్లెకి, ఆఁగ్‍క సెక్తి నాయ్” మెన యేసు సంగ కెర, ");
INSERT INTO key_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","అన్నెక్ సుట్టు ఇదిల్ దూరి ఉట్ట గెచ్చ కెర, “ఓ బ, ఈంజ స్రెమచి గిన్న ఆఁవ్ పిలెకయి గెచ్చెదె జలె, తుచి ఇస్టుమ్ జర్గు జవుస్” మెన ప్రార్దన కెర, ");
INSERT INTO key_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","అన్నె ఉట్ట అయ్‍లె, జేఁవ్ సిస్సుల్ గూన్‌క నెత్ర కెర అన్నె నిజ అస్తి మెన దెక కెర, ");
INSERT INTO key_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","జోక అన్నె ముల దా, ఉట్ట గెచ్చ, అన్నెక్ సుట్టు తెదొడ్‍చ కొడొ ప్రార్దన కెర్లన్. ");
INSERT INTO key_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","తెదొడి యేసు జోచ సిస్సుల్‍తె అన్నె ఉట్ట జా, జోవయింక, “అప్పెకయ్ సెలవ్ కడన, నే రకితె నిజ అస్సుస్ గే? ఈందె, సమయుమ్ జఁయి గెలి. ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ పాపుమ్ కెర్తసచి అత్తి దెర్ను సేడిందె. ");
INSERT INTO key_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","జొమ్మ, గెచ్చుమ! ఈందె, అంక దెర దెతొసొ పాసి జా అస్సె” మెన, సిస్సుల్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","యేసు లట్టబ్తె తతికయ్, బారజిన్ సిస్సుల్‍తె జో అగ్గె తిలొ యూదా పాఁవ అయ్‍లస. జో తెన్ కి ఒగ్గర్‍జిన్ జనాబ్ కత్తుల్ డండల్ దెరన యూదుల్‍చ వెల్లెల పూజర్లు చి అన్నె వెల్లెల మాన్సుల్‍తె యూదా తెన్ అయ్‍ల. ");
INSERT INTO key_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","జలె, ఈంజ నే జతె అగ్గె, “ఆఁవ్ కక్క చుంబిందె గే, జొయ్యి యేసు. జోకయి దెరన” మెన యేసుక దెర దెతొ యూదా జేఁవ్ జనాబ్‍క గుర్తు సంగ తిలన్. ");
INSERT INTO key_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","జాచి రిసొ, జో యేసుతె బేగి జా కెర, “గురుబాబు, జొఒర!” మెన సంగ, జోక చుంబిలన్. ");
INSERT INTO key_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","యేసు జోక దెక, “ఓ నేస్తము, తుయి కిచ్చొ కెరుక అయ్‍లది గే, జయి కెరు” మెన, జోక సంగిలన్. జేఁవ్ అయ్‍లస పాసిక జా, యేసుక దెర్ల. ");
INSERT INTO key_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","జలె, యేసు తెన్ తిలొసొ ఎక్కిలొ, ఆతు చంపొ కెర, కత్తి కడన, ఎత్కిక వెల్లొ పూజరిచొ గొత్తి సుదొక పెట, జోచొ కంగ్డొ సింద గెలన్. ");
INSERT INTO key_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","యేసు జోక, “తుచి కత్తి తిఁయ దేసు. కత్తివొ తెన్ యుద్దుమ్ కెర్తస కత్తి తెన్ మొరుల. ");
INSERT INTO key_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","అల్లె, ఈంజ సమయుమ్ ఆఁవ్ అంచొ అబ్బొక ప్రార్దన కెరుక నెతిరి మెన ఉచర్తసి గె? నెంజిలె, ప్రార్దన కెర్లెగిన, జో డబ్బయ్ వెయిలు దూతల్‍క బేగి తోడ్ తెద్రవుక నెత్రె మెన తుయి ఉచర్తసి గే? ");
INSERT INTO key_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","గని, దస్సి కెర్లెగిన, అంక ఈంజ ఎత్కి జర్గు జంక అస్సె మెన దేముడుచి కొడొతె రెగిడ్లిసి కీసి నెరవెర్సుప జయెదె!” మెన జో సిస్సుడుక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","తెదొడి, జయి గడియయ్, యేసు జనాబ్‍క, “ఆఁవ్ కిచ్చొ చోర్లయ్ చి కత్తులు డండల్ దెరన అంక దెరుక తుమ్ అయ్‍లదు గే? ఆఁవ్ రోజుక దేముడుచి గుడితె పెస బోదన కెర్లె కి, అంక జా పొది దెర్సు నాయ్. ");
INSERT INTO key_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","జలె, దేముడుచి కబుర్లు రెగిడ్లసచి అత్తి రెగిడ్ల కొడొ నెరవెర్సుప జతి రిసొయి ఈంజ ఎత్కి జర్గు జలి” మెన, యేసు సంగితికయ్, సిస్సుల్ ఎత్కి బియఁ కెర, జోక ముల దా, ఉట్ట నిగిల. ");
INSERT INTO key_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ఒత్త తెంతొ, యేసుక జేఁవ్ విరోదుమ్ సుదల్ దెర కెర, కయప మెలొ ఎత్కిక వెల్లొ పూజరితె జోక కడ నెతికయ్, ఒత్త దేముడు మోసే తెన్ దిలి ఆగ్నల్ సికడ్తస చి అన్నె వెల్లెల మాన్సుల్ బెర తిల. ");
INSERT INTO key_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","పేతురు, మాత్రుమ్, దూరి దూరి యేసుచి పట్టి జా జా, జో ఎత్కిక వెల్లొ పూజరిచి వీదె పాఁవ కెర, వీదె పెస కెర, ఆకర్‍క కిచ్చొ జర్గు జయెదె గే దెకుక మెన, జమాన్లు తెన్ వెసిలన్. ");
INSERT INTO key_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","వెల్లెల పూజర్లు చి అన్నె వెల్లి సబ కెర్తస ఎత్కిజిన్ యేసుక మారుక కోర్‍ప జా, జోక నేరిమ్ వయడ్తి సాచి చజితె తిల. ");
INSERT INTO key_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","గని అబద్దుమ్ సాచి సంగితస ఒగ్గర్‍జిన్ పుర్రె జలెకి, సరి జతి సాచి దొర్కు జయె నాయ్. గని, ఆకర్‍క, దొగుల పుర్రె జా కెర, ");
INSERT INTO key_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“ఈంజొ మాన్సు ‘దేముడుచి గుడి ఆఁవ్ సేడవ గెల కెర, తిర్రత్‍క అన్నె బందిందె’ మెన సంగిలొ” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","జేఁవ్ దస్సి సంగితికయ్, ఎత్కిక వెల్లొ పూజరి టీఁవొ జా, యేసుక దెక, “ఈంజేఁవ్ సంగిలిస్‍క కిచ్చొ జబాబ్ దెంక నెతిర్సి గే? ఈంజేఁవ్ తుక కిచ్చొ నేరిమ్ వయడ్తతి?” మెన, పుసితికయ్ కి ");
INSERT INTO key_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","యేసు తుక్లె తిలన్. జాకయ్, ఎత్కిక వెల్లొ పూజరి జోక అన్నె, “తుయి దేముడుచొ క్రీస్తు జలొ పుత్తుసి జస్తె జలె, ‘జీవ్ తిలొ దేముడు తోడు’ మెన, జోచి నావ్ తెన్ అమ్‍చి మొక్మె ఒప్పన సంగు” మెల, ");
INSERT INTO key_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","యేసు జోక, “తుయి సంగిలి రితి. గని తుమ్‍క ఆఁవ్ కిచ్చొ మెంతసి మెలె, ఆకర్‍క ఎత్కి సెక్తి అదికారుమ్ తిలొసొచి ఉజెతొ పక్క ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ వెస తతిసి కి, ఆగాసుమ్‍చి మబ్బుతె, ఆఁవ్ పరలోకుమ్ తెంతొ అన్నె ఉత్ర జెతిసి కి తుమ్ దెకితె” మెన, సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","జో ఎత్కిక వెల్లొ పూజరి, కోపుమ్‌క జో గలన్లి దిగిల్ చొక్క చిరన గెల కెర, “అయ్యొ! ‘దేముడుక సమానుమ్ జతసి’ ఈంజొ సంగుక ప్రబుచి విలువ కడ వెల్లి పాపుమ్ కెర్తయ్. అమ్‍క అన్నె సాచుల్ అక్కర్ నాయ్. ఈందె, దేముడుక ఈంజొ సమ్మందుమ్ సంగన్లిసి. తుమ్ అప్పె సొంత సూన్లదు ఈంజయి సరి జతయ్. ");
INSERT INTO key_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","తుమ్ కిచ్చొ రుజ్జు సంగితె?” మెన సబ కెర్తసక పుసితికయ్, జేఁవ్, “ఈంజొ మొర్తి సిచ్చచి ఎదిలి తప్పు కెర అస్సె” మెన సంగ, ");
INSERT INTO key_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","యేసుచి మొక్మె తుంక్ర దా, జోక కుందిల. అన్నె, సగుమ్‍జిన్ జోక పెట కెర, ");
INSERT INTO key_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“క్రీస్తు, తుక కో పెట్ల గే తుయ్ క్రీస్తు గద, అమ్‍క సంగు!” మెన కొంకడ్ల. ");
INSERT INTO key_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ఈంజ మదెనె, పేతురు వీదె వెస తతికయ్, ఒత్తచి తేర్‍బోద గొత్తి సుది ఎక్లి జోతె జా కెర, “తుయి కి గలిలయ ప్రాంతుమ్‍చొ యేసు తెన్ తిలది” మెన, జోక సంగిలి. ");
INSERT INTO key_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","జా దస్సి మెన సంగితికయ్, పేతురు, “తుయి సంగిలిసి అంక అర్దుమ్ జయె నాయ్” మెన, ఎత్కిజిన్‍చి మొక్మె, యేసుక నేన్లి రితి సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","పేతురు అన్నె వీదిచి గుమ్ముమ్ పక్క గెతికయ్, అన్నెక్లి తేర్‍బోద గొత్తి సుది జోక దెక కెర, “ఈంజొ కి నజరేతు గఁవ్విచొ యేసు తెన్ తిలొ” మెన, ఒత్త టీఁవ తిలసక సంగిలి. ");
INSERT INTO key_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","జలె పేతురు ఒట్టు గలన, “జో మాన్సుక ఆఁవ్ నేని” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","గడియ గెలి పిమ్మట్, ఒత్త టీఁవొ జా తిలస పేతురుతె జా కెర, “నిజుమి, తుయి జోచ సిస్సుల్‍తె ఎక్కిలొ. తుయి లట్టబ్లె చినుక ఒత్తయ్” మెన, సంగిల. ");
INSERT INTO key_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","జేఁవ్ దస్సి సంగితికయ్, పేతురు, “జో మాన్సుక ఆఁవ్ నేని” మెన సపెన గల కెరన ఒట్టు గలనుక దెర్లొ, చి బేగి కుకుడొ వాఁసిలన్. ");
INSERT INTO key_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","జాచి రిసొ, “కుకుడొ నే వాఁస్తె అగ్గె, ‘జోక నేని’ మెన, తుయి తివ్వెరి అంచి రిసొ సంగితె” మెన యేసు అగ్గె సంగిలిసి ఏదస్ట కెర, పేతురు బార్ జా ఎదివాట్ దుకుమ్ జా ఏడ గెలన్. ");
INSERT INTO key_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","రాత్ పాయితికయ్, వెల్లెల పూజర్లు చి యూదుల్‍చ అన్నె వెల్లెల మాన్సుల్ ఎత్కిజిన్ సబ కెర, యేసుక మారుక మెన తీర్పు కెర, ");
INSERT INTO key_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","జోక బంద కడన, అదికారి జలొ పిలాతుతె సొర్ప దిల. ");
INSERT INTO key_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","తెదొడి, యేసుక దెర దిలొ యూదా, “యేసుక నేరిమ్ వయడ అస్తి, చి మారుల” మెన దెక కెర, “పాపుమ్ కెర్లయ్” మెన దుకుమ్ జా బమ్మ జా, జేఁవ్ ముప్పయ్ వెండి బిల్లల్ జేఁవ్ వెల్లెల పూజర్లుతె చి అన్నె వెల్లెల మాన్సుల్‍తె అన్నె ఆన కెర, ");
INSERT INTO key_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“కేన్ తప్పు నే కెర్లొ నీతి తిలొసొక ఆఁవ్ దెర దా ఆఁవ్ పాపుమ్ కెర్లయ్” మెన సంగిలన్. గని జేఁవ్ వెల్లెల మాన్సుల్ కిచ్చొ మెల మెలె, “జాకయ్ అమ్‍క కిచ్చొ? అమ్‍చి పూచి నెంజె. తుయి దెకన్” మెన, సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","జో యూదా జేఁవ్ వెండి బిల్లల్ దేముడుచి గుడితె గల దా, గెచ్చ, ఉరి గలన, మొర గెలొ. ");
INSERT INTO key_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","యూదా దస్సి కెర్తికయ్, వెల్లెల పూజర్లు జా డబ్బుల్ వెంట కెర, కిచ్చొ మెలె, “ఈంజ ఎక్కిలొచి లొఁయి సువిలి పాపుమ్ డబ్బుల్. జాచి రిసొ, దేముడుచి గుడిచి డబ్బుల్ పెటెతె ఈంజ డబ్బుల్ గలుక జయె నాయ్” మెన ");
INSERT INTO key_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","లట్టబన, ఉచరన, ‘యూదుల్ నెంజిల వేర దేసిమ్‍చ మాన్సుల్‍క ఒత్త రోవ గెలుక జయెదె’ మెన, కుమ్మరొ ఎక్కిలొచి బాటి జా డబ్బుల్‍క గెనిల. ");
INSERT INTO key_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","జాచి రిసొ, ఆజి ఎద, జా బాటిక ‘ఎక్కిలొచి లొఁయి సువిలి పాపుమ్‍చి డబ్బుల్‍క గెన్లి బాటి’ మెంతతి. ");
INSERT INTO key_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ఇసి జర్గు జలిసి తెన్, దేముడుచి కబుర్ సంగిలొ యిర్మీయాచి అత్తి రెగిడ్లి కోడు నెరవెర్సుప జలి. “ప్రబు సంగిలి రితి, ఇస్రాయేలులు సగుమ్‍జిన్, ఎక్కిలొక గెనుక మెన ఒప్పన్లి సొమ్ముక, మెలె ముప్పయ్ వెండి బిల్లల్‍క, ");
INSERT INTO key_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","కుమ్మరొచి వెడ ఏక్ గెనిల,” మెన రెగిడ్లి కోడు. ");
INSERT INTO key_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","యూదుల్‍చ వెల్లెల మాన్సుల్ యేసుక జో పిలాతు మెలొ అదికారిచి మొక్మె టీఁవొ జలొ, చి జో అదికారి యేసుక “యూదుల్‍చొ రానొ తుయి గె?” మెన పుసితికయ్, యేసు “తుయి సంగిలి రితి,” మెన జబాబ్ మెలన్. ");
INSERT INTO key_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","గని వెల్లెల పూజర్లు చి అన్నె వెల్లెల మాన్సుల్ జోచి ఉప్పిరి నేరిమ్ వయడ్తికయ్, జో జబాబ్ కిచ్చొ కి సంగె నాయ్. ");
INSERT INTO key_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","జాకయ్, పిలాతు యేసుక అన్నె, “తుచి ఉప్పిరి ఈంజేఁవ్ కెత్తి నేరిమ్‍లు వయడ్తతి గే, తుయి సూన్సి నాయ్ గే?” మెన జోక సంగిలే కి, ");
INSERT INTO key_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","జేఁవ్ మాన్సుల్ సంగిల నేరిమ్‍లుతె ఎక్కిక కి యేసు జబాబ్ సంగె నాయ్, చి అదికారి ఎదివాట్ ఆచారిమ్ జలన్. ");
INSERT INTO key_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","జలె, జా పండుగు పొది, ప్రెజల్ కోర్‍ప జలొ కేన్ జలెకు జేలి జలొసొక ముల దెంక జో అదికారిక అలవాట్ జా అస్సె. ");
INSERT INTO key_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","జా కాలుమ్, జలె, బరబ్బ మెలొ ఎత్కిజిన్ జాన్లొ ఒగ్గర్ మూర్కుమ్ తిలొ జేలి జలొ ఎక్కిలొ అదికారిచి జేల్‍తె తిలన్. ");
INSERT INTO key_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","జలె, ప్రెజల్ బెర తతికయ్, పిలాతు జోవయింక “ఆఁవ్ కక్క ముల దెంక మెన తుమ్ కోర్‍ప జతసు? బరబ్బక గే, క్రీస్తు మెంతొ యేసుక గే?” మెన జోవయింక పుసిలన్. ");
INSERT INTO key_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","జో అదికారి కిచ్చొక ఇసి జేఁవ్ ప్రెజల్ నిసానుక సెలవ్ దిలొ మెలె, యూదుల్‍చ వెల్లెల మాన్సుల్ ఎక్కి గోసచి రిసొ యేసుక తీర్పు కెర్తి టాన్‍తె ఆన అస్తి మెన జానె. ");
INSERT INTO key_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","పిమ్మట్, రుజ్జు కెర్తి పొది వెసితి పీటతె, జో అదికారి తెదొడి వెసితికయ్, జోచి తేర్సి ఏక్ గొత్తి సుదిచి అత్తి, జో తెన్ కబుర్ తెద్రయ్‍లి. “జో నీతి తిల మాన్సుక జేఁవ్ యూదుల్ కెర్తిస్‍తె తుయి జోలిక గో నాయ్. ఆజి ఆఁవ్ జోచి రిసొ సివ్న దెక అల్లర్ జలయ్” మెన, అదికారి జలొ మున్సుస్‍తె కబుర్ తెద్రయ్‍లి. ");
INSERT INTO key_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","గని, వెల్లెల పూజర్లు చి అన్నె వెల్లెల మాన్సుల్ కిచ్చొ కెర్ల మెలె, “‘బరబ్బక ముల దేసు!’ మెన సంగ” మెన ప్రెజల్‍క సికడ్తె తిల. ");
INSERT INTO key_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","జలె, అదికారి జనాబ్‍క అన్నె కిచ్చొ పుసిలన్ మెలె, “దొగులతె ఆఁవ్ కక్క ముల దెంక?” మెన పుసిలన్, చి జేఁవ్ “బరబ్బకయ్” మెన కేక్ గల్తికయ్, ");
INSERT INTO key_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","పిలాతు “దస్సి జలె, క్రీస్తు మెంతొ యేసుక ఆఁవ్ కిచ్చొ కెరుక?” మెన పుసిలన్. జేఁవ్ జనాబ్ ఎత్కిజిని, “సిలువతె గల, మొర్తి సిచ్చ కెరు!” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","జేఁవ్ జనాబ్ దస్సి జతికయ్, జో అదికారి “కిచ్చొక? ఈంజొ కిచ్చొ నేరిమ్ కెర అస్సె?” మెన పుసిలన్, గని, “సిలువతె గల, మొర్తి సిచ్చ కెరు!” మెన గట్టిఙ కేకుల్ గలిల. ");
INSERT INTO key_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","జలె, ‘కెద్ది సంగిలే కి కామ్‍క నెంజె, గని ప్రెజల్ అన్నె గగ్గొల్ జతతి, చి ఒగ్గర్ అల్లర్ కెరుల. యేసుచి రిసొ పూచి సేడుక అంక కిచ్చొ లాబుమ్ నాయ్’ మెన పిలాతు దెక కెర, పాని నఙన, ప్రెజల్‍చి మొక్మె అత్తొ దోవన, “ఈంజొ నీతి మాన్సుక మార్తిస్‍చి రిసొ తుమి దెకన్. జోచి లొఁయి అంచి పూచి నాయ్” మెన ప్రెజల్‍చి మొక్మె సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","జో అదికారి దస్సి సంగితికయ్, ప్రెజల్ ఎత్కి, “జోచి లొఁయిచి పూచి, అమ్‍చి ఉప్పిర్ చి అమ్‍చ బోదల్‍చి ఉప్పిర్ తవుస్.” మెన ఒప్పన, కేకుల్ గలిల. ");
INSERT INTO key_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","తెదొడి, జేఁవ్ కోర్‍ప జలి రితి, పిలాతు బరబ్బక ముల కెర, యేసుక కొర్డల్ తెన్ పెటవడ, ‘జోక సిలువతె గల్తు, జలె’ మెన జోవయింక జమాన్లుతె సొర్ప దిలన్. ");
INSERT INTO key_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","తెదొడి, అదికారితెచ జేఁవ్ జమాన్లు యేసుక అదికారి గేర్‍చి తెడిచి గదితె కడ నా కెర, జమాన్లు ఎత్కిక ఒత్త ఆనవ కెర, ");
INSERT INTO key_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","యేసుచ సొంత పాలల్ కడ గెల కెర, ఏక్ ఎరన రగుమ్‍చి పాలుమ్ యేసుక గల దా, ");
INSERT INTO key_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","కంటక ఏక్ కిరీటుమ్ గంచ కెర, యేసుచి బోడితె గల దా కెర, ఏక్ డండొ జోచి ఉజిల్ అత్తి దెరవ కెర, జొకర జోచి పుర్రెతొ సెర్ను సేడ, “యూదుల్‍చొ రానొ, తుక జెయ్యి!” మెన జోక కొంకడ్ల. ");
INSERT INTO key_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","పిమ్మట్, జోచి ఉప్పిరి తుంక్ర, జా డండొ కడ కెర జా తెన్ జోక బోడితె పెట పెట, ");
INSERT INTO key_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","జోక దస్సి దూసుప కెర్లి పడ్తొ, జోక గల తిలి ఎరన పాలుమ్ కడ కెర, జోచ సొంత పాలల్ జోక అన్నె గల దా కెర, సిలువతె గల్తి రిసొ జోక కడ నిల. ");
INSERT INTO key_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","యేసుక సిలువతె గల్తి రిసొ, జేఁవ్ ఎత్కిజిన్ గెతె తతికయ్, కురేనియు దేసిమ్‍చొ సీమోను మెలొ ఎక్కిలొక డీస్తికయ్, యేసుక గల్తి సిలువ వయితి రిసొ జోక బలవంతుమ్ కెర్ల. ");
INSERT INTO key_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","గొల్గొతా మెంతి టాన్‍తె, మెలె గిడ్గి పోలికచి ఏక్ మెట్టయ్, పాఁవ కెర, ");
INSERT INTO key_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","నొప్పి తొక్కి కెర్తి ఓస్తు బెదయ్‍లి ద్రాచ రస్సుమ్ యేసుక జమాన్లు దా కెర, “పి” మెన సంగితికయ్, జో జా చక దెక, పియె నాయ్. ");
INSERT INTO key_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","పిమ్మట్, సిలువతె గల టీఁవడ కెర, “జోచ పాలల్ వంటనుమ” మెన చీట్లు గల, వంటన్ల. ");
INSERT INTO key_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","తెదొడి జోక రకుక మెన ఒత్త వెసిల. ");
INSERT INTO key_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","అన్నె, “ఈంజొ యేసు, యూదుల్‍చొ రానొ” మెన, జోచి ఉప్పిరి నేరిమ్ రెగిడ్లి దారుగండ ఏక్ జోచి బోడిచి ఉప్పిరి ఒడొవ దిల. ");
INSERT INTO key_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","యేసుచి ఉజెతొ పక్క ఎక్కిలొక, డెబ్రి పక్క ఎక్కిలొక, దొగుల చోర్లుక కి ఎక్కెక్ సిలువల్‍తె గల టీఁవడ్ల. ");
INSERT INTO key_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","జా వాటు గెతె తిల మాన్సుల్ యేసుక ఆఁస, ఆఁస బోడి దున్నొవ, ");
INSERT INTO key_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“దేముడుచి గుడి సేడవ తిర్రత్‍క అన్నె బందితొసొ తుయి జలె, తుక తూయి రచ్చించుప కెరను. తుయి దేముడుచొ పుత్తుసి జలె, జా సిలువ తెంతొ ఉత్రు” మెన జోక దూసుప కెర్ల. ");
INSERT INTO key_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","వెల్లెల పూజర్లు, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస, చి అన్నె వెల్లెల మాన్సుల్ కి, జోక దూసుప కెర్తి రితి, ");
INSERT INTO key_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","కిచ్చొ మెన కొంకడ్ల మెలె, “ఈంజొ వేర సుదల్‍క రచ్చించుప కెర్లె కి, జోక జొయ్యి రచ్చించుప కెరనుక నెత్రె. ఈంజొ ఇస్రాయేలు ప్రెజల్‍చొ రానొ జలె, అప్పె సిలువతె తెంతొ ఉత్రుసు, చి జోక నంపజమ్‍దె. ");
INSERT INTO key_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","జో దేముడుచి ఉప్పిరి నంపజా అస్సె బెర్తె. ఆఁవ్ ఎత్కి అదికారుమ్ తిలొ దేముడుచొ పుత్తుసి, మెలన్ గెద? జలె, దేముడుక ఇస్టుమ్ తిలె, ఈంజొ నే మొర్తి రితి ఇన్నెక రచ్చించుప కెర్సు!” మెన, ఆఁస ఆఁస, దూసుప కెర్ల. ");
INSERT INTO key_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","యేసు తెన్ బెదవ సిలువల్‍తె టీఁవడ్ల దొగు చోర్లు కి, జోక దస్సి దూసుప కెర్ల. ");
INSERT INTO key_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","జలె, బార గంటల్ మెద్దెనె తెంతొ మొదొల్ కెర, తిన్ని గంటల్ ఎద, జా ఒండి దేసిమి అందర్ డంక తిలి. ");
INSERT INTO key_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","జలె, పాసి పాసి తిన్ని గంటల్‍క, యేసు, “ఏలీ, ఏలీ, లామా సబక్తానీ” మెన సంగ, గట్టిఙ ఒర్స దిలన్. జా కోడుక కిచ్చొ అర్దుమ్ మెలె, ‘అంచొ దేముడు ప్రబు, అంచొ దేముడు ప్రబు, అంక కిచ్చొక ఆతు ముల దిలది?’ ");
INSERT INTO key_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","“జలె, ఒత్త టీఁవొ జా తిలసతె సగుమ్‍జిన్ జా కోడు సూన కెర, ‘ఈంజొ ఏలీయా పూర్గుమ్‍చొక బుకార్తయ్, కిచ్చొగె’” మెల. ");
INSERT INTO key_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","బేగి జోవయింతె ఎక్కిలొ నిగ గెచ్చ, బూంజు రితిసి వెంట, అమ్‌డి ద్రాచ రస్సుమ్‍తె బుడ్డవ కెర, ఏక్ రివ్వతె బంద, చంప కెర, యేసుక ‘పి’ మెన దిలన్. ");
INSERT INTO key_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","గని పాసి తిలస, “పోని. ఏలీయా జోక రచ్చించుప కెరుక ఉత్రెదె గే, నాయ్ గే, దెకుమ” మెన కొంకడ్ల. ");
INSERT INTO key_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","తెదొడి, యేసు అన్నె గట్టిఙ కేక్ గల కెర, ప్రానుమ్ ముల దిలన్. ");
INSERT INTO key_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","యేసు మొర గెలి గడియయ్ దేముడుచి గుడితె ఒడొవ తిలి తెర, ఉప్పిర్ తెంతొ ఎట్టొ ఎదక చిరి జా దొన్ని గండల్ జలి. బుఁయి అద్దుర్ జలి. రంగ్నిపత్రల్ పుట్ట గెల. ");
INSERT INTO key_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","అన్నె, మెస్సున్‍లు ఉగ్డి జతికయ్, ఒగ్గర్‍జిన్ నిజ తిల దేముడుచొ సుదల్ మొర్లస మెస్సున్‍తె జీవ్ జా, ఉట్ల. ");
INSERT INTO key_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","యేసు జీవ్ జా ఉట్లి పడ్తొ, మెస్సున్‍లు తెంతొ బార్ జా, దేముడుచి గుడి తిలి యెరూసలేమ్ పట్నుమ్‍తె గెచ్చ కెర, ఒగ్గర్‍జిన్‍క డీసిల. ");
INSERT INTO key_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","జలె, యేసుక రక తిల జమాన్లు, జోవయించొ పుంజెక్‍జీన్ జమాన్లుక వెల్లొ తెన్, బూకంపుమ్ కెర్లి పొది జర్గు జలిసి ఎత్కి దెక కెర, బలే బియఁ కెర, “నిజుమి, ఈంజొ దేముడుక పుత్తుసి జా తిలొ” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","యేసుక సవ్రెచన కెర్తి రిసొ, గలిలయ ప్రాంతుమ్ తెంతొ జోచి పట్టి జా తిల తేర్‍బోదల్ ఒగ్గర్‍జిన్ కి జో మొర్లి పొది ఒత్త తిల. ");
INSERT INTO key_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","జోవయింతె కో కో తిల మెలె, మగ్దలేనే పట్నుమ్‍చి మరియ మెలిసి, పడ్తొ యాకోబుక చి యోసేపుక అయ్యసి జలి మరియ, పడ్తొ జెబెదయిచ పుత్తర్సుల్‍చి అయ్యసి. ");
INSERT INTO key_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","సాంజ్ జతికయ్, యేసుక నంపజా సిస్సుడు రితొ జలొ యోసేపు మెలొ అరిమతయ్ గఁవ్విచొ సొమ్సారి ఎక్కిలొ జా కెర, ");
INSERT INTO key_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","పిలాతు అదికారితె గెచ్చ కెర, “యేసుచి పీనుమ్ అంక దే” మెన సంగితికయ్, జో అదికారి జోక దాస మెన ఆడ్ర దిలన్. ");
INSERT INTO key_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","జలె, యోసేపు జా పీనుమ్ ఉత్రవ జాక నొవి విలువచి బట్ట పంగ్రవ కెర, ");
INSERT INTO key_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","జోచి రిసొ నొవర్ కెరవ తిలి రంగ్ని పత్తుర్‍చి డొల్మి కెర్లి మెస్సున్‍తె నా కెర, తెడి రోవ దిలన్, చి గుమ్ముమె వెల్లొ పత్తురు పెలవ దా డంక గెల కెర, ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","తెదొడి మగ్దలేనే పట్నుమ్‍చి మరియ చి జా అన్నెక్ మరియ ఒత్త మెస్సున్‍చి మొక్మె వెస తిల. ");
INSERT INTO key_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","అన్నెక్ దీసి, మెలె పండుగ్‍చి బోగి దీసిక అన్నెక్ దీసి, వెల్లెల పూజర్లు చి పరిసయ్యుల్ పిలాతు అదికారితె బెద జా కెర, ");
INSERT INTO key_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","జోక, “బాబు, జో మోసిమ్ కెర్లొసొ జీవ్ తిలి పొది, మొర్లె తిర్రత్‍క ఆఁవ్ అన్నె జీవ్ జా ఉట్టిందె మెలిసి ఏదస్ట కెర్తసుమ్. ");
INSERT INTO key_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","జాకయ్, తిర్రత్ ఎద మెస్సున్‍క చెంగిల్ బందు కెరవడు, నెంజిలె జోచ సిస్సుల్ జా కెర, జోక ఉక్కుల నా కెర, యేసు జీవ్ జా మెస్నె తెంతొ బార్ జలొ మెన, ప్రెజల్‍క సికడుల, చి అగ్గెచి మోసిమ్‍చి కంట ఆకర్‍చి మోసిమ్ ఒగ్గర్ జయెదె” మెన, యూదుల్‍చ జేఁవ్ వెల్లెల మాన్సుల్ అదికారిక సంగిల. ");
INSERT INTO key_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","పిలాతు “జమాన్లుక కడన రకవడ, చి తుమ్ గెచ్చ కెర, తుమ్ తెర్లి ఎదిలి డిట్టుమ్ బందు కెరవడ” మెన, జేఁవ్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","జేఁవ్ గెచ్చ కెర, రకితసక టీఁవడ కెర, జోక అడ్డు కెర్తొ పత్తురు డిట్టుమ్ రెచ కెర, ముద్ర గల దా, మెస్సున్‍క కో లుంకచోరు నే ఉగిడ్తి రితి కెర్ల. ");
INSERT INTO key_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","సెలవ్ కడన్లి దీసి జీన గెలి పడ్తొ, సెలవ్ కడన్లి దీసి రాత్ పాయితె తతికయ్, మగ్దలేనే పట్నుమ్‍చి మరియ కి, జా అన్నెక్ మరియ కి, జా మెస్సున్ దెకుక గెల. ");
INSERT INTO key_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ఒత్త పాఁవిలె, ఈందె, దేముడుచి దూత ఎక్కిలొ పరలోకుమ్ తెంతొ ఉత్తిర్తికయ్, ఒగ్గర్ బూకంపుమ్ జర్గు జలి, చి జో దూత జో అడ్డు తిలొ పత్తురు ఒస్సుల్ కెర, పత్తుర్‍చి ఉప్పిరి వెసిలన్. ");
INSERT INTO key_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","జోక దెకిలె, ఉజిడ్ తిలి రితి డీసిలొ, జోచ పాలల్ మంచుచి ఎదిలి చొక్కిల డీసిల. ");
INSERT INTO key_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","జోక బియఁ కెర, ఒత్త రక తిల జమాన్లు మొర గెల రిత జల. ");
INSERT INTO key_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","గని, జో దేముడుచి దూత జేఁవ్ దొగుల తేర్‍బోదల్‍క దెక, జేఁవ్‍క, “తుమ్ బియఁ నాయ్. సిలువతె జేఁవ్ టీఁవడ్లొ యేసుక తుమ్ చజితసు మెన ఆఁవ్ జాని. ");
INSERT INTO key_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","జో ఇన్నె నాయ్. జో సంగిలి రితి, జీవ్ జా ఉట్ట అస్సె. ఈందె, తుమ్ జా కెర, జో తిలి టాన్ దెక కెర, ");
INSERT INTO key_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","బే బేగి గెచ్చ, చి జోచ సిస్సుల్‍క ఇసి మెన సంగ. యేసుప్రబు మొర గెచ్చ తా, జీవ్ జా ఉట్ట అస్సె, చి ఈందె, జో తుమ్‍చి కంట అగ్గె గలిలయతె గెతయ్. తుమ్ ఒత్త జోక దెకితె, మెన జోవయింక సంగ దాస.” మెన జేఁవ్ తేర్‍బోదల్‍క జో దూత సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","జాచి రిసొ, జేఁవ్ దొగుల బి తెన్, సర్ద తెన్, మెస్నె తెంతొ బార్ జా, యేసుచ సిస్సుల్‍తె గెచ్చ జా కబుర్ బేగి సంగుక మెన, ఉట్ట నిగిల. ");
INSERT INTO key_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","జేఁవ్ దొగుల తేర్‍బోదల్ యేసుచ సిస్సుల్‍తె గెచ్చుక నిగితె తతికయ్, యేసు జోవయింక వట్టె దస్సుల్ జా, “చెంగిల్ అస్సుస్ గే?” మెన సంగిలన్, చి జేఁవ్ జోచి పాసి జా కెర, జోచ చట్టొ దెరన జొకర్తికయ్, ");
INSERT INTO key_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","యేసు జోవయింక, “బియఁ నాయ్. అంచ సిస్సుల్‍తె గెచ్చ జోవయింక కిచ్చొ మెన సంగ దాస మెలె, గలిలయతె గెచ్చ. ఒత్త అంక దెకితె మెన యేసు తుమ్‍క సంగ తెద్రయ్‍లన్, మెన సంగ దాస” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","జేఁవ్ దొగుల తేర్‍బోదల్ యేసుచ సిస్సుల్‍తె గెతె తతికయ్, జా మెస్నె రక తిల జమాన్లు సగుమ్‍జిన్ యెరూసలేమ్‍తె గెచ్చ కెర, మెస్నె జర్గు జలిసి ఎత్కి వెల్లెల పూజర్లుక సంగిల. ");
INSERT INTO key_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","జాకయ్ జేఁవ్ పూజర్లు, అన్నె వెల్లెల మాన్సుల్ తెన్ సబ కెర, లట్టబన, జేఁవ్ జమాన్లుక లంచుమ్ దా కెర, ");
INSERT INTO key_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","జోవయింక ఇసి మెన సికడ్ల. “ప్రెజల్‍క తుమ్ ఇసి మెన: ‘జోవయించ సిస్సుల్ అందరె జా కెర, అమ్ నిజ తతికయ్, జోక ఉక్కుల నిల’ మెన సంగ. ");
INSERT INTO key_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ఈంజ ఎత్కి అదికారిక నేన్‍తె జలెగిన, తుమ్ కిచ్చొ సిచ్చ నే జతి రితి అమ్ జోక సేంతుమ్ కెరుమ్‍దే” మెన, యూదుల్‍చ వెల్లెల మాన్సుల్ పూచి సేడ్ల. ");
INSERT INTO key_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","జేఁవ్ వెల్లెల మాన్సుల్ దస్సి సంగితికయ్, జేఁవ్ జమాన్లు జా లంచుమ్ కడ నా కెర, జోవయింక సంగిలి రితి కెర్ల. ఆజి ఎద కి జా అబద్దుమ్ యూదుల్ సూన నంప కెర్తతి. ");
INSERT INTO key_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ఎగరజిన్ సిస్సుల్ గలిలయతెచి యేసు సంగిలి మెట్టతె ఉట్ట గెల. ");
INSERT INTO key_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","గెచ్చ, జోక దెక కెర, సెర్ను సేడ జోక జొకర్ల. గని సగుమ్‍జిన్ అన్మానుమ్ జల. ");
INSERT INTO key_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","తెదొడి, యేసు జోవయించి పాసి జా కెర, “పరలోకుమ్‍తె, బూలోకుమ్‍తె ఎత్కి అదికారుమ్ అంక దొర్కు జా అస్సె. ");
INSERT INTO key_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","జాచి రిసొ తుమ్ దేసిమ్‍లు ఎత్కితె గెచ్చ కెర, మాన్సుల్ ఎత్కితెచ ప్రెజల్‍తె అంక నంపజా సిస్సుల్ జతి రితి కెర, అబ్బొసి జలొ దేముడుచి, దేముడు పుత్తుస్‍చి, దేముడుచి సుద్ది తిలి ఆత్మచి నావ్ తెన్, జోవయింక బాప్తిసుమ్ దాస. ");
INSERT INTO key_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","అన్నె, ఆఁవ్ తుమ్‍క కిచ్చొ కిచ్చొ సంగ బోదన కెర అస్సి గే, జా ఎత్కి జేఁవ్ నంపజతసక కి సంగ బోదన కెర. ఈందె, ఉగుమ్ పూర్తి జతె ఎదక కి, కెఁయఁక తెఁయఁక తుమ్‍చి తెన్ ఆఁవ్ తోడ్ అస్సి” మెన యేసు సిస్సుల్‍క సంగిలన్.");
INSERT INTO key_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","దేముడుచొ పుత్తుసి జలొ యేసుక్రీస్తుచి సుబుమ్ కబుర్ ఇసి మొదొల్ జతయ్. ");
INSERT INTO key_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","దేముడుచ కబుర్ సంగిలొ యెసయా పూర్గుమ్‍చొచి అత్తి దేముడు రెగిడ్లి రితి జర్గు జలి. “ఈందె, తుక వాట్ తెయార్ కెరయ్‍తి రితి, అంచొ బారికి జతొ ఎక్కిలొక తుచి కంట అగ్గె తెద్రయిందె” మెన, ");
INSERT INTO key_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","అన్నె, “ఎక్కిలొ అంచొ బారికి రితొ జా, అంచి అవాడ్ రితొ జా, ‘ప్రబుకయ్ వాట్ చెంగిల్ కెరు. జోక వాట్ తిన్నగ కెర్లి రితి తుమ్ ఎత్కిజిన్ బుద్ది ఆననా’ మెన, బయిలె ప్రదేసిమి తా కేక్ గల సాట్ప కెరెదె” మెన, రెగిడ్లి కోడు. ");
INSERT INTO key_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ఈంజేఁవ్ కొడొ కీసి నెరవెర్సుప జల మెలె, బాప్తిసుమ్ దెతొ యోహాను మెలొసొ బయిలె బార్ జా బులుక దెర కెర, “తుమ్‍చి పాపల్‍చి రిసొ తుమ్ పెట్టి దుకుమ్ జా, పాపుమ్ ముల్తి బుద్ది జా, దేముడు తుమ్‍చి పాపుమ్ చెమించుప కెర్తి గుర్తుక, తుమ్ బాప్తిసుమ్ నఙన.” మెన సాట్ప కెర్తె తిలన్. ");
INSERT INTO key_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","యోహాను ఇసి కెర్తె తతికయ్, యూదయ మెలి జా ప్రదేసిమ్‍చ ప్రెజల్ ఒగ్గర్ ఒగ్గర్‍జిన్ జా ప్రదేసిమ్‍చి యెరూసలేమ్ మెలి వెల్లి పట్నుమ్‍చ ప్రెజల్ ఒగ్గర్ ఒగ్గర్‍జిన్, జోతె జా బయిలె జా కెర, జేఁవ్ కెర్ల పాపల్‍చి రిసొ పెట్టి దుకుమ్ జా, ఎదార్దుమ్ తెన్ ఒప్పన సంగ కెర, యోర్దాను మెంతి ఒత్తచి గడ్డె, జోచి అత్తి బాప్తిసుమ్ నఙన్‍తె తిల. ");
INSERT INTO key_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","యోహాను కీసొ తిలొ మెలె, ఒంటెచ రోమల్‍చ పాలల్ గలన, చామ్ తెన్ కెర్లి పట్క కెరంటె బందన, డొంగ్రెచి ఒండాల్ తేల్, చిట్కల్ కతొసొ. ");
INSERT INTO key_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","కిచ్చొ మెన యోహాను బోదన కెర్తె తిలన్ మెలె, “అంచి పట్టి అన్నెక్లొ జెతయ్, అంచి కంట జోక అదికారుమ్ ఒగ్గరి. ఆఁవ్ వంపొ జా జోచ చట్టొతెచ జోడ్లుతెచ వాలివొ యిపుక జలెకు అంక విలువ నాయ్. ");
INSERT INTO key_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ఆఁవ్ జలె, పానితె తుమ్‍క బాప్తిసుమ్ దెతసి, గని అప్పె జెతొసొ జలె, దేముడుచి సుద్ది తిలి ఆత్మతె తుమ్‍క బాప్తిసుమ్ దెయెదె” మెన సాట్ప కెర్తె తిలన్. ");
INSERT INTO key_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","తెదొడి ఏక్ దీసి, యేసు గలిలయ ప్రాంతుమ్‍తెచి నజరేతు గఁవ్వి తెంతొ ఉట్ట జా కెర, ఒత్త యోర్దాను గడ్డె యోహానుచి అత్తి బాప్తిసుమ్ నఙన్లొ. ");
INSERT INTO key_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","యేసు పాని తెంతొ బార్ జలి బేగి యోహాను కిచ్చొ దెకిలన్ మెలె, పరలోకుమ్ ఉగ్డి జలి, చి దేముడుచి సుద్ది తిలి ఆత్మ, పార్వ పిట్టచి రితి జా, ఉత్ర జా యేసుచి ఉప్పిరి టీఁవొ జలి. ");
INSERT INTO key_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","అన్నె, “తుయి అంచొ ప్రేమ తిలొ పూత్తు. తుచి రిసొ అంక సర్దసంతోసుమ్” మెన పరలోకుమ్ తెంతొ సంగిలిస్‍చి అవాడ్ అయ్‍లి. ");
INSERT INTO key_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","దస్సి జలి బేగి, కో నెంజిలి బయిలె యేసు గెతి రితి, దేముడుచి సుద్ది తిలి ఆత్మ జోక పెలవ నిలన్. ");
INSERT INTO key_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","యేసు ఒత్త దొన్ని విసొ దీసల్ తతికయ్, సయ్‍తాన్ జోక పాపుమ్ కెరవుక ఉచర్లన్. ఒత్త రితయ్ జంతువుల్ తిల. దేముడుచి దూతల్ జా కెర, యేసుక సావ్రెచన కెర, సుక్కుమ్ కెర్ల. ");
INSERT INTO key_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","జా పొది, బాప్తిసుమ్ దెతె తిలొ యోహాను జేలి జలొ. జో యోహాను జేలి జలి పిమ్మట్, యేసు, దేముడు జలొ అబ్బొస్‍చి సుబుమ్ కబుర్ బోదన కెర కెర, బుల బుల, గలిలయ ప్రాంతుమ్‍తె అన్నె ఉట్ట అయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“దేముడుచి రాజిమ్ ఈంజ లోకుమ్‍తె జెతిస్‍క రకితి కాలుమ్ పూర్తి జా అస్సె. దేముడుచి రాజిమ్ పాసి జా అస్సె. జాచి రిసొ, తుమ్ కెర్ల పాపల్‍చి రిసొ పెట్టి దుకుమ్ జా. పాపుమ్ ముల్తి బుద్ది జా, సుబుమ్ కబుర్ సూన నంపజా” మెన బోదన కెర్తె తిలన్. ");
INSERT INTO key_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","యేసు జా గలిలయ ప్రాంతుమ్‍చి సముద్రుమ్‍చి గట్టుతె ఇండితె తా, సీమోనుక చి అంద్రెయ మెలొ సీమోనుచొ బావొస్‍క దెకిలన్. జేఁవ్ దొగుల గడ్డె వల గల్తె తిల. జేఁవ్ మొస్స దెర్తస. ");
INSERT INTO key_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","జలె, యేసు జోవయింక దెక, “తుమ్ అంచి పట్టి జా, చి మాన్సుల్ అంక నంపజతి రిసొ, జోవయింక తుమ్ అంచితె కడ ఆన్‍తి రితి తుమ్‍క సికడిందె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ఇసి సంగ బుకార్లి బేగి, జేఁవ్, జోవయించ వలల్ ముల దా కెర, జోచి పట్టి గెచ్చ, జో తెన్ బులుక దెర్ల. ");
INSERT INTO key_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ఒత్త తెంతొ అన్నె ఇదిల్ దూరి గెచ్చ కెర, జెబెదయి మెలొ ఎక్కిలొచ దొగుల పుత్తర్సుల్‍క యేసు దెకిలన్. వెల్లొచి నావ్ యాకోబు, బావొస్‍చి నావ్ యోహాను. జేఁవ్ దొగుల జోవయించి దోనితె వెస తా, చిరి జల వలల్ చెంగిల్ కెర్తె తిల. ");
INSERT INTO key_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","జోవయింక దెకిల్ బేగి, యేసు జోవయింక బుకార్లన్. జెబెదయి మెలొ జోవయించొ అబ్బొస్‍క, జోవయింతె కూలి కెర్తసక కి దోనితె ముల దా, జేఁవ్ దొగుల బావుడ్లు జోచ సిస్సుల్ జతి రితి యేసుచి పట్టి గెల. ");
INSERT INTO key_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","జలె, యేసు, జేఁవ్ సిస్సుల్ తెన్ కపెర్నహూమ్ పట్నుమ్‍తె బెద గెల. అన్నెక్ సెలవ్ కడన్లి దీసి, దేముడుక బక్తి కెర్తి యూదుల్‍చి ఒత్తచి సబ గెరి గెచ్చ, తెడి పెస కెర, యేసు బోదన కెరుక దెర్లన్. ");
INSERT INTO key_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస కెర్తి రితి నాయ్, గని దేముడు దిలి అదికారుమ్ తెన్ యేసు సొస్టుమ్ బోదన కెర్లన్, చి ఒత్త తిల మాన్సుల్ బలే ఆచారిమ్ జల. ");
INSERT INTO key_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","తెదొడి జేఁవ్ తిలి సబగేరి బూతుమ్ దెర్లొ ఎక్కిలొ డీసిలొ. ");
INSERT INTO key_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","జో జలె “ఓ నజరేతు గఁవ్విచొ యేసుప్రబు, అమ్‍చి తెన్ తుక కిచ్చొ కామ్? అమ్‍క పాడ్ కెరుక జా అస్సిస్ గే? తుయి కొన్సొ గే జాని. దేముడుచి సుద్ది తిలొసొ, తుయి.” మెన కేక్ గలొ. ");
INSERT INTO key_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","యేసు, జలె, “తుక్లె తా ఇన్నెక ముల దా గో!” మెన జో మాన్సుక దెర్లి బూతుమ్‍క గోల కెర్లన్. ");
INSERT INTO key_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","బూతుమ్ జో మాన్సుక అద్దుర్ కెర దా, గట్టిఙ ఒర్సవడ కెర, జోక ముల దిలొ. ");
INSERT INTO key_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","జర్గు జలిసి ఎత్కిజిన్ దెక ఆచారిమ్ జా, “అబ్బరేయ్య! ఈంజ కెద్ది అదికారుమ్ తిలి బోదన. నొవి రగుమ్. బూతల్‍క కి అదికారుమ్ తెన్ ఈంజొ ‘గో!’ మెన సంగిలె, జా సూన, ఈంజొ సంగిల్ రితి ఉట్ట గెతతి!” మెన బమ్మ తెన్ ఎక్కిలొక ఎక్కిలొ సంగన్ల. ");
INSERT INTO key_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","జా దీసి తెంతొ, జా ఒండి గలిలయ ప్రాంతుమ్‍తె, కేనె ఒత్త, యేసుచి రిసొ ఎత్కిజిన్ సూన్ల. ");
INSERT INTO key_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","బూతుమ్ దెర్లొసొక చెంగిల్ కెర్లి బేగి, సబ గెరి తెంతొ బార్ జా ముల కెర, యాకోబు చి యోహాను తెన్ యేసు బెద గెచ్చ, సీమోను చి అంద్రెయ చి గెరి గెల. ");
INSERT INTO key_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","జలె, గెరి పెసిలె, సీమోనుచి అత్తస్ జొర్జొ సేడ నిజ అస్సె. దస్సి అస్సె మెన దెక కెర, సిస్సుల్ యేసుక సంగిల. ");
INSERT INTO key_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","యేసు జాచి పాసి జా కెర, ఆతు దెర ఉట్టయ్‍తికయ్, జొర్జొ జాక ముల దిలి, చి చెంగిల్ జలి, జా మంతిరి గెరి తిలసక సవ్రెచన ఎత్కి కెర్లి. ");
INSERT INTO key_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","జా దీసి సాంజ్ జతికయ్, ఒగ్గర్ ఒగ్గర్‍జిన్ జబ్బుల్ తిలసక కి, బూతుమ్ దెర్లసక కి యేసుతె ప్రెజల్ కడ ఆన్ల. ");
INSERT INTO key_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","జా పట్నుమ్‍చ ప్రెజల్ ఎత్కిజిన్ జా గెర్‍చి వీదె బెర జా, గుమ్ముమె టీఁవొ జా తిల. ");
INSERT INTO key_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","జోవయింతె రగరగాల్‍చ జబ్బుల్ తిల మాన్సుల్‍క యేసు చెంగిల్ కెర్లన్, ఒగ్గర్ బూతల్‍క ఉదడ గెలన్. గని జో కొన్సొ గే బూతల్ చినిలి రిసొ, జా గుట్టు బార్ కెర్తు నాయ్ మెన, జేఁవ్ బూతల్ లట్టబుక సెలవ్ నే దిలొ. ");
INSERT INTO key_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","అన్నెక్ దీసి, రాతి నే పాయితె ఒగ్గర్ అందర్ తత్తయి, యేసు ఉట్ట కెర బార్ జా, కో నెంజిలి టాన్‍తె గెచ్చ, ప్రార్దన కెరుక దెర్లన్. ");
INSERT INTO key_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ప్రార్దన కెర్తె తతికయ్, సీమోను, జో తెన్ తిలస కి, యేసుచి పట్టి జా చజన, ");
INSERT INTO key_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","జోతె పాఁవ కెర, “ఇన్నెచ మాన్సుల్ ఎత్కిజిన్ తుక చజితతి” మెన యేసుక సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","జో, “జొమ్మ, ఈంజ ప్రాంతుమ్‍తెచ అన్నె గఁవ్విలె గెచ్చుమ, ఆఁవ్ ఒత్త కి బోదన కెర్తి రిసొ. జాకయ్ బార్ జలయ్,!” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","జలె, జా గలిలయ ప్రాంతుమ్ ఎత్కితె బుల బుల, ఒత్తచ యూదుల్‍చ సబ గెరలె బోదన కెర్తె తిలన్, చి మాన్సుల్‍క దెర్ల బూతల్‍క ఉదడ గెల్తె తిలన్. ");
INSERT INTO key_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","జా పొది, వెల్లి రోగి ఎక్కిలొ యేసుతె జా కెర, సెర్ను సేడ, “తుక ఇస్టుమ్ తిలె, తుయి అంక చెంగిల్ కెర సుద్ది కెరుక తెర్సి.” మెన బతిమాల్ప జా జొకర్తికయ్, ");
INSERT INTO key_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","యేసు కన్కారుమ్ జా, ఆతు చంప కెర, జోక చడ, “అంక ఇస్టుమి. తుయి చెంగిల్ జా సుద్ది జా” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","వెల్లి రోగుమ్ బేగి జో మాన్సుక ముల దిలి, చి చెంగిల్ జా సుద్ది జలన్. ");
INSERT INTO key_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","తెదొడి యేసు జోక, “జర్గు జలిస్‍చి రిసొ కక్క సంగు నాయ్, గని దేముడుచి గుడితె గెచ్చ, ఒత్త సేవ కెర్తొ పూజరితె గెచ్చ, తుయి చెంగిల్ జలిసి జోక దెకవ, తుయి చెంగిల్ జా సుద్ది జలిసి ఎత్కిజిన్‍క రుజ్జు దెకయ్‍తి రితి, మోసే పూర్గుమ్‍చొ సంగిలి కానుక దేసు” మెన యేసు ఆడ్ర దా జోక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","గని, “కేనె ఒత్త సంగు నాయ్” మెన యేసు సంగ తిలె కి, జో మాన్సు బార్ జా ఉట్ట గెచ్చ కేనె ఒత్త సంగుక దెర్లన్. జర్గు జలిసి జో దస్సి ఎత్కిజిన్‍క సూనయ్‍తికయ్, ‘కేన్ పట్నుమ్‍తె ఇస్టుమ్ అయ్‍లి రితి ఎదార్దుమ్ పెసుక నెంజె’ మెన, యేసు జా బయిలె తాఁ గెలొ. ఒత్త జా బయిలె తతికయ్, చెత్తర్ దిక్కుల్ తెంతొ కి, ప్రెజల్ జోతె బెర గెతె తిల. ");
INSERT INTO key_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","సగుమ్ దీసల్ గెలి పడ్తొ, యేసు కపెర్నహూమ్ పట్నుమ్‍తె అన్నె బుల జెతికయ్, జో ‘గెరి అస్సె’ మెన సూన కెర, ");
INSERT INTO key_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ఒగ్గర్ ఒగ్గర్‍జిన్ జనాబ్ జోతె బెర అయ్‍ల. బెర అయ్‍లి రిసొ, జోచి గదితె కి, గుమ్ముమె కి, అన్నె కక్క టాన్ నాయ్. జలె, యేసు జనాబ్‍క దేముడుచి బోదన కెర్తె తతికయ్, ");
INSERT INTO key_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","వాతుమ్ జొర్జొ తెన్ తిలొసొ ఉట్టుక నెతిర్లొ మాన్సు ఎక్కిలొక, చెత్తర్‍జిన్ యేసు తిలిస్‍తె కడ ఆన్ల. జో మాన్సుక కడ ఆన్లసతె తిల చెత్తర్‍జిన్ జోక జోచి అంతుర్నొ తెన్ వయ ఆన తిల. ");
INSERT INTO key_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","జలె, జో రోగిక యేసుతె పాసి కడ ఆనుక చజిలె కి, బెర్ల జనాబ్‍చి రిసొ నెతిర్ల. జోచి పాసి జెంక నెతిర్లి రిసొ, జో తిలి గదిచి ఉప్పిర్ ఒర్నెచి వెల్లి బొరొ కెర, జో ఎంగ్డ తిలి అంతుర్నొ తెన్ జో రోగిక జా బొరొ వాట్ ఉత్రవ దా, యేసుచి పాసిక పాఁవడ్ల. ");
INSERT INTO key_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","జలె, ‘కడ ఆన ఉత్రవ తిల జేఁవ్ మాన్సుల్ నంప తెన్ అస్తి’ మెన యేసు రుజ్జు దెక కెర, ఉట్టుక నెతిర్లొ జో రోగిక దెక, “ఓ పూత్తు, తుచి పాపల్ చెమించుప జా అస్తి” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","జలె, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస సగుమ్‍జిన్ ఒత్త వెస అస్తి. యేసు సంగిలిసి జేఁవ్ సూన కెర బమ్మ జా, ");
INSERT INTO key_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“ఈంజొ మాన్సు కీసొ జా లట్టబ్‍తయ్! ఇసి లట్టబ దేముడుచి విలువ కడ పాపుమ్ కెర్తయ్! దేముడు ఎక్కిలొక పిట్టవ, కో కి పాపల్ చెమించుప కెరుక నెతిర్తి!” మెన, జోవయించి పెట్టి ఉచరన్ల. ");
INSERT INTO key_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","జోవయించి పెట్టి తిలి అన్మానుమ్ యేసు జోచి ఆత్మతె బేగి చిన కెర, “తుమ్‍చి పెట్టి కిచ్చొక దస్సి అన్మానుమ్ తియంతసు? ");
INSERT INTO key_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ఉట్టుక నెతిర్లొ ఈంజొ మాన్సుక ‘తుచి పాపల్ చెమించుప జా అస్తి’ మెన సంగుక సుల్లు గే, ‘ఉట్టు, తుచి అంతుర్నొ వయన ఇండు’ మెనుక సుల్లు గే? ");
INSERT INTO key_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","జలె, మాన్సు జా జెర్మున్ అయ్‍లయ్ అంక, ఈంజయ్ లోకుమ్‍తె కి పాపల్ చెమించుప కెర్తి అదికారుమ్ అస్సె మెన రుజ్జు దెకయిందె, మెన జేఁవ్‍క సంగ కెర, ఉట్టుక నెతిర్లొ జో మాన్సుక అన్నె దెక కెర, ");
INSERT INTO key_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","‘అల్లె, తుయి ఉట్ట, తుచి అంతుర్నొ వయన ఇండ గెరి గో, మెన తుక ఆఁవ్ సంగితసి!’” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","బేగి, జో మాన్సు ఉట్ట కెర, జోచి అంతుర్నొ ఉక్కుల వయన, జేఁవ్ ఎత్కిజిన్‍చి మొక్మె ఇండుక దెర, బార్ జా కెర, ఉట్ట గెలన్. ఇసి జర్గు జలి రిసొ, ఒత్త బెర తిలస ఎత్కిజిన్ ఆచారిమ్ జా, “ఇస కమొ అమ్ కెఁయ్య దెకుక నాయ్. ఆజి దెకిలమ్” మెన, దేముడుక గవురుమ్ సంగిల. ");
INSERT INTO key_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","యేసు అన్నె బార్ జా, సముద్రుమ్‍చి జా గాడుచి ఒడ్డుతెచి వాట్ గెలన్. ఒత్త ఒగ్గర్‍జిన్ జనాబ్ జోతె బెర జెతికయ్, జోవయింక బోదన కెరుక దెర్లన్. బోదన కెర కెర, ");
INSERT INTO key_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","అన్నె ఇదిల్ దూరి గెలె, సిస్తు నఙితి గెరి ఒత్త వట్టె అస్సె. జా గెరితె అల్పయి మెలొ ఎక్కిలొచొ లేవీ మెలొ పుత్తుసి ఎక్కిలొ వెస అస్సె. యేసు జోక దెక కెర, “అంచి పట్టి జా, అంచొ సిస్సుడు జా” మెన జోక బుకార్లన్. బుకార్లి బేగి, జో ఉట్ట, యేసుచి పట్టి గెలన్. ");
INSERT INTO key_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","జలె, లేవీయింతె యేసు అన్నిమ్ కంక గెలన్. జోతె అన్నిమ్ కంక మెన యేసు సిస్సుల్ తెన్ వెస తతికయ్, జో తెన్ జా దేసిమ్‍చ నిస్కారుమ్ కెర్ల ఒగ్గర్‍జిన్ బెద వెస తిల. కొన్స మెలె, సిస్తు నఙితస కి, నీతి రితి నే కెర్తస కి సగుమ్‍జిన్, దస మాన్సుల్ ఒగ్గర్‍జిన్ యేసుచి పట్టి గెచ్చ ఒత్త తిల. ");
INSERT INTO key_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","జలె, పరిసయ్యుల్ తెన్ బెదిత మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస సగుమ్‍జిన్ తిల. ‘సిస్తు నఙితస తెన్, నీతి నెంజిలస తెన్ యేసు వెస కతయ్’ మెన జేఁవ్ మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస దెక కెర, “సిస్తు నఙితస తెన్, పాపుమ్ సుదల్ తెన్ ఈంజొ కిచ్చొక కతయ్?” మెన యేసుచ సిస్సుల్‍క పుసిల. ");
INSERT INTO key_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","జేఁవ్ వెల్లెల మాన్సుల్ పుసిలిసి సూన కెర, యేసు జోవయింక దెక, “జబ్బు తెన్ అస్సుమ్ మెన చినన్లసక డాక్టర్ అవ్‍సురుమ్, గని జబ్బు నెంజిలసక డాక్టర్ అవ్‍సురుమ్ నాయ్. జలె, పాపుమ్ సుదల్ ఆమ్ మెన చినంతసకయ్ బుకార్‍క ఆఁవ్ అయ్‍లయ్, గని ఆమ్ పున్నిమ్ సుదల్ మెన ఉచరంతసక బుకార్‍క నాయ్” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","బాప్తిసుమ్ దెతె తిలొ యోహానుచ సిస్సుల్ కి, పరిసయ్యుల్ కి చువ్వె తతికయ్, ప్రెజల్ సగుమ్‍జిన్ యేసుతె జా కెర, “యోహానుచ సిస్సుల్, పరిసయ్యుల్‍చ సిస్సుల్, చువ్వె తంక అలవాట్, గని తుచ సిస్సుల్ చువ్వె తత్తి నాయ్. కిచ్చొక?” మెన జోక పుసిల. ");
INSERT INTO key_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ఇసి పుసితికయ్, యేసు జోవయింక, “కేన్ పెండ్లితె, జోవయించి నెడిమి పెండ్లిఉబేడొ తిలె పొది పెండ్లి విందుతె బుకార్లస చువ్వె తవుల గే? నాయ్! జలె, పెండ్లిఉబేడొ జోవయించి నెడిమి తతి ఎదిలి సేంపుక జేఁవ్ చువ్వె తంక బెదె నాయ్. సర్ద తెన్ తవుల. ");
INSERT INTO key_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","జలె, పెండ్లిఉబేడొచి పచ్చెన జలసచి నెడిమి తెంతొ జోక దెర వేరతె కడ నిలె, జేఁవ్ మాన్సుల్ ఏడ ఏడ చువ్వె తవుల. ");
INSERT INTO key_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“అన్నె, పొర్ని పాలుమ్ చిరి జా తిలెగిన, మాసికచి రిసొ నే కేడయ్‍లి నే కేడ్తె నొవి గండ కో జాన్‍ల మాన్సుల్ గల్తి నాయ్. ఏక్ వేల, దస్సే, తొలితొ నే కేడ్తె నే కేడయ్‍తె గల తిలెగిన, జా ఒండి పాలుమ్ కేడ్లె, జా మాసిక కడెదే. మాన్సు జా పాలుమ్ గలన్లె, అవ్కు జలి పొర్ని బట్ట నొవి బట్టచి మాసిక బెదయ్‍లి కుటు సొడి చిరి జయెదె, చి అగ్గెచి కంట వెల్లి బొరొ జయెదె. ");
INSERT INTO key_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“పిమ్మట్, పోర్నిచి కాయ తెన్ ఒత్త నొవి ద్రాచ రస్సుమ్ సువితి నాయ్. కిచ్చొక మెలె, జా కాయ పొర్ని జలి రిసొ, జాచితె నొవి ద్రాచ రస్సుమ్ సువిలెగిన, జా పులుక నెతిరి రిసొ, జా రస్సుమ్ పొంగుప జలె పొది జా కాయ పుట్టెదె, జా రస్సుమ్ సూఁయి జయెదె. దస్సి, కాయ, రస్సుమ్, దొన్ని కి పాడ్ జా గెచ్చుల. జాకయ్, నొవి ద్రాచ రస్సుమ్‍క నొవి కయల్ అవ్‍సురుమ్.” మెన జోక పుసితి మాన్సుల్‍క యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","జా పొదులె, ఏక్ సెలవ్ కడన్లి దీసి, యేసుచి సిస్సుల్ పంటొ పికిలి బుఁయి వాట్ గెతె తిల. వాట్ సొడి పికిలి పంటొచ ఎన్నులు దొన్ని జోచ సిస్సుల్ కోడ కయ్‍ల. ");
INSERT INTO key_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","జేఁవ్ సిస్సుల్ ఎన్నులు కోడ్లిసి, జలె, పరిసయ్యుల్ సగుమ్‍జిన్ దెక కెర, ‘జేఁవ్ దస్సి కెర్లిసి కామ్ కెర్లి రితి జతయ్’ మెన, “ఈందె, సెలవ్ కడన్లి దీసి కెరుక నాయిమ్ నెంజిలిసి కిచ్చొక తుచ సిస్సుల్ కెర్తతి?” మెన యేసుక గోల కెర్ల. ");
INSERT INTO key_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","యేసు జోవయింక, “దావీదు పూర్గుమ్‍చొ జో తెన్ తిలస, చూ కెర్తికయ్ కిచ్చొ కెర్ల గే తుమ్ కెఁయ సదు కెర్సు నాయ్ గే? ");
INSERT INTO key_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","మెలె, అబ్యాతారు మెలొసొ ఎత్కిక వెల్లొ పూజరి జా తిలి కాలుమ్, దేముడుచి గుడి తెడి దావీదు పెస కెర, దేముడుచి గుడిచ పూజర్లు దేముడుక అర్పితుమ్ దిల పోడియొ వెంటన, పూజర్లు కంక జయెదె గని అన్నె కో కి కంక నెంజె మెన జాన్లె కి, జో తెన్ తిలసక వంట దా, జోవయింతెన్ కయ్‍ల!” మెన జేఁవ్ పరిసయ్యుల్‍క యేసు సంగిలన్. జోవయింక అన్నె, ");
INSERT INTO key_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","“సెలవ్ కడన్లి దీసి మాన్సుల్‍క ఒగ్గర్ ఏలుప కెర్తు మెన నాయ్, గని మాన్సుల్‍క ‘చెంగిల్ తత్తు’ మెనయ్ దేముడు సెలవ్ కడన్లి దీసి దిలన్. ");
INSERT INTO key_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","జలె, సెలవ్ కడన్లి దీసిచి ఉప్పిరి ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొక అదికారుమ్ అస్సె” మెన పరిసయ్యుల్‍క యేసు జబాబ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","తెదొడి జా కపెర్నహూమ్ పట్నుమ్‍తె యూదుల్‍చి సబ గెరి యేసు అన్నె గెచ్చ, పెస, కిచ్చొ దెకిలన్ మెలె, ఆతు లంబ గెలొసొ ఎక్కిలొ ఒత్త అస్సె. ");
INSERT INTO key_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","జలె, ‘బక్తి కెర్తి సెలవ్ కడన్లి దీసి యేసు జో మాన్సుక చెంగిల్ కెరెదె గే నాయ్ గే’ మెన దెకుక మెన, వెల్లెల మాన్సుల్ రకితె అస్తి. ‘జోక చెంగిల్ కెర్లెగిన, సెలవ్ కడన్లి దీసి కామ్ కెర్లి రితి జయెదె, చి యేసుక నేరిమ్ వయడుక జయెదె’ మెన ఉచర అస్తి. ");
INSERT INTO key_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","జేఁవ్ వెల్లెల మాన్సుల్ దస్సి రకితె తతికయ్, యేసు జో ఆతు లంబిలొసొక దెక, “ఇత్తల్ జే!” మెన సంగ కెర, ");
INSERT INTO key_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","జేఁవ్ వెల్లెల మాన్సుల్‍క దెక, “సెలవ్ కడన్లి దీసి ఎక్కిలొక చెంగిల్ కెరుక నాయిమ్ గే, గార్ కెరుక నాయిమ్ గె? జోచి ప్రానుమ్ రచ్చించుప కెరుక గే, జోక మార గెలుక చెంగిల్ కి?” మెన జోవయింక పుసిలన్. గని జేఁవ్ తుక్లె తిల. ");
INSERT INTO key_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","జోవయించి మెన్సుతె ఇదిల్ కన్కారుమ్ కి జతి నాయ్, చి రిసొ యేసు దుకుమ్ జా, కోపుమ్ తెన్ ఒత్త తిలసక దెక కెర, జో మాన్సుక అన్నె దెక, “తుచొ ఆతు చంపొ కెరు” మెన జోక సంగితికయ్, జో ఆతు చంపొ కెర్లన్, చి జా ఆతు చెంగిల్ జలి. ");
INSERT INTO key_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","యేసు కెర్లిసి దెక కెర, పరిసయ్యుల్ బార్ జా, హేరోదు పచ్చెన జతస తెన్ సబ కెర, “జోక కీసి మారుమ?” మెన కుట్ర ఉచర్ల. ");
INSERT INTO key_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","యేసు బార్ జా కెర, జోచ సిస్సుల్ తెన్ జా గలిలయ ప్రాంతుమ్‍చి సముద్రుమ్ గాడుచి ఒడ్డుతె గెలన్. ఒత్తచ ప్రెజల్ ఒగ్గర్‍జిన్ జనాబ్ జోచి పట్టి గెల. పిమ్మట్, జో కెర్ల కమొచి రిసొ సూన తా, యూదయ ప్రదేసిమ్ తెంతొ, ");
INSERT INTO key_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","యెరూసలేమ్ పట్నుమ్ తెంతొ, ఇదుమయ ప్రాంతుమ్ తెంతొ, యోర్దాను గాడు ఒత్తల్‍తొ తెంతొ, పడ్తొ సీదోనుచి తూరు మెల పట్నల్‍చి ప్రాంతుమ్ తెంతొ, దూర్‍దూరిచ మాన్సుల్ ఒగ్గర్ ఒగ్గర్‍జిన్ జనాబ్ జా కెర, ఒత్త యేసుతె జా బెర్ల. ");
INSERT INTO key_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","జలె, “ఈందె, ప్రెజల్ పెలపెలి జతతి. ఇసి జలె, దస్సి ప్రమాదుమ్ నే జతి రిసొ, దోని ఏక్‍క సంగ తా” మెన, సిస్సుల్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","కిచ్చొక మెలె ప్రెజల్‍తె ఒగ్గర్ ఒగ్గర్‍జిన్‍చ జొర్జొల్ గట్రక యేసు గెచ్చయ్‍తికయ్, “జోక చడిలె జలెకు చెంగిల్ జమ్‍దె” మెన, అన్నె జబ్బు తిలస ఎత్కిజిన్, జోక చడుక మెన పెలపెలి జతె తిల. ");
INSERT INTO key_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","పిమ్మట్ జా పొది అన్నె కిచ్చొ జర్గు జతె తిలి మెలె, బూతల్ యేసుక దెకిలె, జేఁవ్ దెర్లసక సెర్ను సేడవ దా, “దేముడుచొ పుత్తుసి, తుయి” మెన జేఁవ్ దెర్లసచి చోండివాట్ బూతల్ యేసుచి రిసొ కేకుల్ గల్తె తిల. ");
INSERT INTO key_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","గని, “ఆఁవ్ కొన్సొ గే తుమ్ కక్క కి సంగుక నాయ్” మెన బూతల్‍క యేసు ఆడ్ర దిలన్. ");
INSERT INTO key_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","తెదొడి యేసు ఏక్ మెట్టయ్ వెగ గెచ్చ, జో ఇస్టుమ్ జల మాన్సుల్‍క బుకార్లన్, చి జోతె అయ్‍ల. ");
INSERT INTO key_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","యేసు బారజిన్ బారికుల్‍క నిసాన, “తుమ్ అంచి తెన్ తత్తి రిసొ తుమ్‍క ఆఁవ్ నిసాన అస్సి. పడ్తొ, అంచి నావ్ తెన్ తుమ్ బోదన కెర్తి రిసొ, అంచి నావ్ తెన్ బూతల్‍క తుమ్ ఉదడ్తి రిసొ తుమ్‍క ఆఁవ్ తెద్రయ్‍తసి” మెన, జోవయింక అదికారుమ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","జో నిసాన అదికారుమ్ దిల బారజిన్ కొన్స మెలె, ఎక్కిలొ సీమోను మెలొసొ, జోక ‘పేతురు’ మెన యేసు పడ్తొ ఆసిమ్ నావ్ తిలన్. ");
INSERT INTO key_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","జెబెదయి మెలొ ఎక్కిలొచ దొగుల పుత్తర్సులు, మెలె, యాకోబు చి యోహాను మెలొ బావొసి. ‘ఉర్ముల్ జల మాన్సుల్’ మెలి అర్దుమ్ తెన్ ‘బోయనేర్గెస్’ మెన జేఁవ్ దొగులక యేసు ఆసిమ్ నావ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","పిమ్మట్, అన్నె కొన్స మెలె, అంద్రెయ, పిలిప్, బర్తొలొమయి, మత్తయి, తోమా. పడ్తొ అల్పయి మెలొ ఎక్కిలొచొ యాకోబు మెలొ పుత్తుసి, పడ్తొ తద్దయి, కనానుచొ జలొ సీమోను మెలొ అన్నెక్లొ. ");
INSERT INTO key_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","అన్నె కొన్సొ మెలె, ఇస్కరియోతు మెలి గఁవ్విచొ యూదా మెలొసొ. జో పడ్తొ విరోదుమ్ సుదల్‍చి అత్తి యేసుక దెర దిలొసొ. తెదొడి యేసు కపెర్నహూమ్ గెరి గెలన్. ");
INSERT INTO key_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","యేసు గెరి గెతికయ్, ఒగ్గర్‍జిన్ జనాబ్ జోతె అన్నె బెర్ల. జేఁవ్ ఒత్త బెర్లి రిసొ, అన్నిమ్ కంక కి యేసుక సెలవ్ నాయ్. ");
INSERT INTO key_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","దస్సి యేసు జోచి బోదన జోచ కమొ కెరుక ఆస జా ఎద్గరె పుండె నాయ్ చి రిసొ “వెర్రి జా తయెదె” మెన మాన్సుల్ సంగిత్ తిలిసి సూన కెర, జోక దెర, గెరి కడ నెంక మెన, జోచి కుటుంబుమ్‍చ బార్ జల. ");
INSERT INTO key_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","జా మదెనె, యెరూసలేమ్ పట్నుమ్ తెంతొ జా తిల, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస, యేసు ఉత్తిర్లిస్‍తె అయ్‍ల. జా కెర, యేసుచి రిసొ “‘బయెల్జెబూల్’ మెలొ జో వెల్లొ బూతుమ్ జోక దెర అస్సె”, “బూతల్‍క రానొ జలొచి నావ్ తెన్ ఈంజొ బూతల్‍క ఉదడ్తయ్” మెన సంగితె తిల. ");
INSERT INTO key_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","జలె, యేసు జోవయింక పాసి బుకారా కెర టాలివొ కెర ఇసి మెలన్. “సయ్‍తాన్ కీసి జా జోక జొయ్యి ఉదడెదె! బెదె నాయ్! ");
INSERT INTO key_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","మెలె, కేన్ జవుస్ రాజిమ్‍చ ప్రెజల్ జలెకు విరోదుమ్ కెరన వర్స వర్స జా జోవయింక జెఁవ్వి యుద్దుమ్ కెరన్లె, జా రాజిమ్ టీఁవొ జంక నెత్ర నాసెనుమ్ జా గెచ్చెదె. ");
INSERT INTO key_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","పడ్తొ, కేన్ గెర్‍చ జలెకు జోవయింక జెఁవ్వి విరోదుమ్ కెరన్లె, వర్స వర్స జా గెచ్చుల, చి కట్టు పిట్టవన పాడ్ జా గెచ్చుల. ");
INSERT INTO key_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","జలె, దస్సి, సయ్‍తాన్ జోక జొయ్యి విరోదుమ్ జలి రితి జా జోచ సొంత సేవ కెర్తసక ఉదడుక బెదె నాయ్. జో దస్సి జోక జొయ్యి విరోదుమ్ జలెగిన, జోచి రాజిమ్ టీఁవొ జయె నాయ్, నాసెనుమ్ జా గెచ్చెదె. ");
INSERT INTO key_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“గని, కేన్ గెర్‍చొ ఎజొమాని బలుమ్ సుదొ జలె, జోకయ్ తొలితొ బందిలెకయ్, జోచి గెరి పెస జోచి సామన్ చోరుక జయెదె. గని జోక తొలితొ బంద తిలె, జోచి గెర్‍చి ఎత్కి చోర గెలుక జయెదె. ");
INSERT INTO key_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“ముక్కిమ్‍క తుమ్‍క ఆఁవ్ గట్టిఙ సంగితసి. కిచ్చొ మెలె, ఎక్కిక పిట్టవ, మాన్సుల్ కెర్త పాపల్ దూసెనల్ ఎత్కి జోవయింక చెమించుప కెరుక జయెదె. ");
INSERT INTO key_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","గని, దేముడుచి సుద్ది తిలి ఆత్మక కో దూసుప కెరుల గే, జెఁవ్వి కెఁయ్యఁక కి చెమించుప జతి నాయ్. జోవయించి పాపుమ్ కెఁయఁక తెఁయఁక తయెదె, చి నాసెనుమ్‍తె గెచ్చుల” మెన జేఁవ్‍క యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","కిచ్చొక మెలె, యేసుచి సుద్ది తిలి ఆత్మ జలెకి, ‘జోక సయ్‍తాన్‍చి ఆత్మ అస్సె’ మెలి రితి, “జోక బూతుమ్ దెర అస్సె” మెన జేఁవ్ దూసుప కెర తిల. ");
INSERT INTO key_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","తెదొడి, యేసుచి అయ్యసి, బావుడ్సులు, జో తిలిస్‍తె పాఁవ కెర, వీదె టీఁవొ జా కెర, “అమ్ జా అస్సుమ్. బార్ జవుస్” మెన సంగ తెద్రయ్‍ల. ");
INSERT INTO key_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","జలె, యేసుచి సుట్టునంత ఒగ్గర్‍జిన్ జనాబ్ వెస తిల. జేఁవ్ జలె, జోక “ఈందె, అయ్యది చి తుచ బావుడ్లు జా కెర, వీదె టీఁవొ జా కెర తుక బుకార్తతి” మెన సంగ దిల. ");
INSERT INTO key_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","యేసు జోక కిచ్చొ జబాబ్ దిలన్ మెలె, “కొన్స అంక అయ్య బావుడ్లు జవుల గే జాన్సు గె?” మెన సంగ, ");
INSERT INTO key_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","జోచి సుట్టునంత వెస తిల ప్రెజల్‍క దెక, జోవయింక దెకవ, “ఈందె, అంచి అయ్య, అంచ బావుడ్లు! ");
INSERT INTO key_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","దేముడుచి ఇస్టుమ్ రితి కో కెరుల గే, జెఁవ్వి అంక బావొ, బేని, అయ్య జవుల” మెన సికడ్లన్. ");
INSERT INTO key_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","యేసు సముద్రుమ్ గాడుచి ఒడ్డుతె అన్నె గెచ్చ కెర, అన్నె బోదన కెరుక దెర్లన్, గని ఒగ్గర్‍జిన్ జనాబ్ జోచి సుట్టునంత బెర పెలపెలి జతె తిలి రిసొ, యేసు ఏక్ దోనితె వెగ వెస, ఒడ్డు తెంతొ ఇదిల్ దూరి గెలన్. బెర తిల మాన్సుల్ ఎత్కిజిన్ జా ఒడ్డుతె టీఁవొ జా తిల. ");
INSERT INTO key_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","యేసు జోవయింక కిచ్చొ కిచ్చొ సికడ్తి రిసొ, ఒగ్గర్ టాలివొ సంగ బోదన కెరుక దెర్లన్. జో జోవయింక బోదన కెరుక, ");
INSERT INTO key_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“ఈందె, తుమ్ సూన! ఉంపితొసొ ఎక్కిలొ, బీ ఉంపుక బార్ జలన్. ");
INSERT INTO key_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","జో ఉంపితె తతికయ్, సగుమ్ బీ బయిలె వాట్ పక్కయ్ సేడ్తికయ్, పిట్టల్ ఉత్ర జా కాఁ గెల. ");
INSERT INTO key_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","అన్నె సగుమ్ బీ ఒగ్గర్ మత్తి నెంజిలి పత్తురు బుఁయ్యె సేడ్లన్. ఉప్పిరి ఇదిలిదిల్ మత్తి తిలి రిసొ, ఒత్త సేడ్లి బీ బేగి గజ్జల్ జలి. ");
INSERT INTO key_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","బేగి గజ్జల్ జలె కి, ఒప్పడ్ లయితికయ్, పత్రలె మొక్కల్ డడ్డ గెల, చి చెర్రొ బుఁయి తెడి పెస వడ్డుక నెతిర్లి రిసొ, జేఁవ్ మొక్కల్ సుకా గెచ్చ మొర గెల. ");
INSERT INTO key_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","అన్నె సగుమ్ బీ కంట దుబ్బుల్ తిలిస్‍తె సేడ గజ్జల్ జా మొక్కల్ జలన్. గని ఒత్త తిల కంట మొక్కల్ వడ్డ కెర ఒత్త సేడ్లి బీచ మొక్కల్‍క పెల గెల్తికయ్, జా బీచ మొక్కల్ ఎన్నులు నే దెర్తె కిచ్చొ పలితుమ్ దెయె నాయ్. ");
INSERT INTO key_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","గని, అన్నె సగుమ్ బీ చెంగిలి బుఁయ్యె సేడ కెర, చెంగిల్ వడ్డ చెంగిల్ పంటొ పిక, విస్సెక్ దెస్సు వంతుల్, తిని విస్సొ వంతుల్, పుంజెక్ వంతుల్, పలితుమ్ దిలి.” ");
INSERT INTO key_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","అన్నె, “సూన్‍త కంగ్డొ తిలస సూన!” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","బెర తిల మాన్సుల్ ఉట్ట గెతికయ్, యేసు తెన్ బెదిల మాన్సుల్ సగుమ్‍జిన్ జోచ బారజిన్ సిస్సుల్ తెన్ బీచి రిసొచి టాలిచి అర్దుమ్‍చి రిసొ పుసిల. ");
INSERT INTO key_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","చి, జో జోవయింక, “దేముడుచి రాజిమ్‍చి రిసొచి గుట్టు జలిసి జానన్తు మెన తుమ్‍క సెలవ్ దా అస్సె, గని అమ్‍చి తెన్ నే బెదిలసక ఎత్కి టాలివొ తెన్ని సంగుక అస్సె. ");
INSERT INTO key_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","కిచ్చొక మెలె, పూర్గుమ్ రెగిడ్లి రితి, ఆఁవ్ కెర్త కమొ కచితుమ్ దెకుత్ గని అర్దుమ్ చినుత్ నాయ్. ఆఁవ్ సంగితి బోదన కచితుమ్ సూనుల, గని అర్దుమ్ కెరంతు నాయ్. నెంజిలె అర్దుమ్ కెరన్లెగిన బుద్ది మార్సుప జా అంచి తెన్ పస్ల చెమించుప జత, మెన రెగ్డ అస్సె.” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","తెదొడి యేసు జోవయింక అన్నె, “ఈంజ టాలిచి అర్దుమ్ కెరన్సు నాయ్ గె? దస్సి జలె, అన్నె టాలివొచి అర్దుమ్ కీసి కెరంతె! ");
INSERT INTO key_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ఈందె, ఉంపితొసొ బీ ఉంపిలి రితి, ఆఁవ్ బోదన సూనయ్‍తసి. ");
INSERT INTO key_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","వట్టె ఉంపిలి బీక జర్గు జలిసి, జలె, ఈంజ బోదన సగుమ్‍జిన్ సూన్లిస్‍చి రితి జతయ్. వట్టె ఉంపిలి బీక పిట్టల్ కీసి జా కెర కా గెల గే, దస్సి, సగుమ్‍జిన్ మాన్సుల్ ఈంజ బోదన సూన్లి బేగి, సయ్‍తాన్ జా కెర, జోవయించి పెట్టి తెంతొ ఉర్లిలి రితి కెర పఁవ్స వడ్తయ్. ");
INSERT INTO key_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","“పత్తురు బుఁయ్యె ఉంపిలి బీక జర్గు జలిసి, జలె, అన్నె సగుమ్‍జిన్ మాన్సుల్‍చి బోదన సూన జితిస్‍చి రితి జతయ్. మెలె, జా బీ బేగి గజ్జల్ జలి రితి జా, జేఁవ్ మాన్సుల్ సుబుమ్ కబుర్ సూన్లి బేగి, సర్ద జా, ‘నంపజతసుమ్’ మెనుల. ");
INSERT INTO key_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","గని జోవయించి సొంత పెట్టి సుబుమ్ కబుర్‌చ చెర్రొ నెంజిలి రిసొ, గడియ జిలి రితి డీసిలెకి, చి రిసొ కిచ్చొ జవుస్ బాద సేడ్లె జలెకు, నెంజిలె వేర మాన్సుల్ జాచి రిసొ జోవయింక అల్లర్ కెర్లె జలెకు, జేఁవ్ మాన్సుల్ బమ్మ జా, బే బేగి నమకుమ్ ముల దెవుల. ");
INSERT INTO key_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“అన్నె సగుమ్‍జిన్ మాన్సుల్, చి బోదన సూన, కంట దుబ్బుల్ తిలిస్‍తె ఉంపిలి బీ రితి జతయ్. మెలె, చి బోదన జేఁవ్ సూన్లె కి, ");
INSERT INTO key_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ఈంజయ్ లోకుమ్‍తె తిలిసి ఎత్కిక ఉచర్తె తా, ‘కీసి జా జిమ్‍దె’ మెన చింత గలనుల, సొమ్సారుమ్ జంక ఆస జవుల, దస్సి, జా ఆస జవుస్, జా చింత జవుస్, జోవయించి పెట్టి పెస తా, జా బోదనక పెలగెలి రితి జయెదె, చి రిసొ, జా బోదన జోవయింతె పలితుమ్ దెయె నాయ్. ");
INSERT INTO key_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“అన్నె సగుమ్‍జిన్ మాన్సుల్ బోదన సూన, చెంగిల్ బుఁయ్యె ఉంపిలి బీ రితి జతయ్. మెలె, చెంగిలి బుఁయ్యె ఉంపిలి బీతె విస్సెక్ దెస్సు వంతుల్, తిన్ విసొ వంతుల్, పుంజెక్ వంతుల్ కీసి పలితుమ్ దెవుల గే, దస్సి, జేఁవ్ మాన్సుల్ కి బోదన సూన, నంపజా గెచ్చ, పలితుమ్ దెవుల” మెన బోదన కెర్లన్. ");
INSERT INTO key_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","సిస్సుల్‍క యేసు అన్నె సంగిలిసి కిచ్చొ మెలె, “దీవు దీవుకంబుమ్‍చి ఉప్పిరి తివుల గని ఆరి నాడిచి తెడి జవుస్, మంచుమ్‍చి తెడి జవుస్ తింకయ్ మెన కేన్ గెర్‍చ మాన్సుల్ దీవు ఆనుల గే? నాయ్. ‘కామ్‍క జెవుస్’ మెన దీవుకంబుమ్‍చి ఉప్పిరి తివుల. ");
INSERT INTO key_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","జలె, డీసుస్ మెనయ్ కిచ్చొ జవుస్ లుంకడ తవుల. ఆకర్‍క బార్ కెర్తి రిసొయి కిచ్చొ జవుస్ గుట్టు లుంకడ తవుల. ");
INSERT INTO key_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","సూన్‍తస కంగ్డొ కక్క తిలె, సరిగా సూన్‍సు!” ");
INSERT INTO key_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","అన్నె జోవయింక, “తుమ్ కిచ్చొ సూన్‍తె గే, సరిగా అర్దుమ్ కెరన దెకన. తూమ్ కేన్ కొల్త తెన్ కట్టడ్‍తె గె, జయి కొల్త తెన్ అన్నె తుమ్‍కయ్ కి కట్టడ దెవుల. తుమ్‍క అన్నెయ్ మీన దెయిందె. ");
INSERT INTO key_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","తిలొసొక అన్నె దెంక జయెదె, గని నెంజిలొసొక జలె, జోవయింక తిలిసి కి జోతె తెంతొ కడ నెంక జయెదె” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","యేసు సిస్సుల్‍క అన్నెక్ టాలి సంగిలన్. “ఎక్కిలొ బుఁయ్యె బీ గల్లి రితి అస్సె. జా బీ కీసి జయెదె గే, దేముడుచి రాజిమ్ పూర్తి జతిస్ తెన్ కి దస్సి. ");
INSERT INTO key_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","జలె, జో మాన్సు జోచి బట్టి బీ గల తా, జో అలవాట్ జలి రితి, రోజుక అందరె నిజ, పెందలె ఉట్ట, మాములుమ్ జితె తయెదె. మదెనె, జా బీ గజ్జల్ జా వడ్డుక దెరెదె. కీసి వడ్డితయ్ గే జో మాన్సు నేనె. ");
INSERT INTO key_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","గని జా బీ బుఁయ్యె తా, దస్సే జేఁవ్‍చి ఇస్టుమ్‍క మెలి రితి జిఁయ గజ్జల్ జా వడ్డ, తొలితొ మొక్క, పడ్తొ ఎన్నులు, పడ్తొ పికిలి పంటొ దెయెదె. ");
INSERT INTO key_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","జలె, పంటొ పికిలి పొది, ‘లాయితి సమయుమ్ జా అస్సె’ మెన చీన, జో మాన్సు బార్ జా లాయెదె” మెన సిస్సుల్‍క యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","జో అన్నె ఇసి మెలన్, “దేముడుచి రాజిమ్ కీసి జతయ్ గే తుమ్ అర్దుమ్ కెరంతి రిసొ కిచ్చొ టాలి ఉచరుమ? ");
INSERT INTO key_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ఇసి జయెదె, బుఁయ్యె ఉంపిలి సొర్సు గిడ్డక జర్గు జతిస్‍చి రితి జయెదె. మెలె, జా గిడ్డ ఈంజ లోకుమ్‍చ గిడ్డల్ ఎత్కిచి కంట ఇదిలిసి తిలె కి, ఉంపిలె, గజ్జల్ జా వడ్డిలి మెలె, ");
INSERT INTO key_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","రోస్‍తె గల్తి మొక్కల్ ఎత్కిచి కంట వెల్లొ జా, జా మొక్కచ కొమ్మల్ వడ్డిలె, జా రూక్‍చ కొమ్మల్‍చి నీడతె ఆగాసుమ్‍చ పిట్టల్ జోవయించ గూడల్ బంద చెంగిల్ తంక జయెదె” మెన యేసు బోదన కెర్లన్. ");
INSERT INTO key_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ఒగ్గర్ టాలివొ సంగయ్ యేసు ప్రెజల్‍క సుబుమ్ కబుర్ బోదన కెర్లన్, జేఁవ్ సూనుక అర్దుమ్ కెరనుక తెరితి రితి. ");
INSERT INTO key_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","టాలివొ నెంతె జోవయింక సికడ్తె నాయ్. గని ప్రెజల్ నెంజిలి పొది, జోచ సొంత సిస్సుల్‍కయ్ అర్దుమ్ ఎత్కి సికడ్తె తిలన్. ");
INSERT INTO key_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","జా దీసి సాంజ్ జతికయ్, “సముద్రుమ్ జీన ఒత్తల్‍తొ గెచ్చుమ,” మెన సిస్సుల్‍క యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","బెర తిల జనాబ్‍క సిస్సుల్ ముల దా కెర, యేసు అగ్గె తెంతొ వెస తిలి దోనితె వెగ కెర, జోవయింతెన్ గాడు ఒత్తల్‍తొ గెచ్చుక మెన దోని జీనవుక దెర్ల. అన్నె సగుమ్ దోనివొ కి జో తిలి దోని తెన్ తిల. ");
INSERT INTO key_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","జలె, యేసు దోనితె గెతె తతికయ్, వాదు ఒగ్గర్ కెర్తికయ్, కెర్టల్ దోనితె పెట్టి జా డేఁవిత్ తిలి రిసొ, దోనితె పాని బెరితె తిలి. ");
INSERT INTO key_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ఇసి జతె తిలె కి, యేసు దోనితెచి పడ్తొచి బల్లయ్ నిజ తిలన్. నిజ తతికయ్, సిస్సుల్ బమ్మ జా, గురుబాబు, అమ్ మొర్లె తుక బాద నాయ్ గె? మెన కేక్ గల, జోక ఉట్టయ్‍ల. ");
INSERT INTO key_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","జో ఉట్ట, వాదుక గోల కెర, “సేంతుమ్ జా తుక్లె తా” మెన సముద్రుమ్‍క సంగితికయ్, వాదు ముల దిలి, చి ఎత్కి అన్నె సేంతుమ్ జా గెలి. ఇసి సేంతుమ్ జతికయ్, ");
INSERT INTO key_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","జేఁవ్ సిస్సుల్‍క యేసు, “కిచ్చొక బితసు? అంచి రిసొ తుమ్‍క ఇదిల్ కి నముకుమ్ నాయ్ గే?” మెన సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","జేఁవ్ ఎత్కిజిన్ బియఁ గెచ్చ, ఎక్కిలొక ఎక్కిలొ “ఈంజొ కొన్సొ జయెదె? వాదు సముద్రుమ్ కి ఇన్నెచి కోడ్ రితి కెర్తతి!” మెన ఆచారిమ్ జా లట్టబనుక దెర్ల. ");
INSERT INTO key_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","యేసు జోచ సిస్సుల్ తెన్ సముద్రుమ్ జీన కెర, ఒత్త తిలి గెరాసేనుల్‍చి ప్రాంతుమ్‍తె పాఁవిల. ");
INSERT INTO key_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","యేసు దోని తెంతొ ఉత్తిర్లి బేగి, బూతుమ్ దెర్లొ మాన్సు ఎక్కిలొ మెస్నెలె తెంతొ బార్ జా, జోక దస్సుల్ జలొ. ");
INSERT INTO key_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","జో మాన్సు మెస్నెలె జితె తిలొ. జోక బూతల్ దెర్లి రిసొ, గొల్సుల్ తెన్ కి జోక కో అన్నె బందుక నెతిర్ల. ");
INSERT INTO key_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ఒగ్గర్ దప్పలు జోచ అత్తొ చట్టొక గొల్సుల్ తెన్ మాన్సుల్ అగ్గె బంద తిల, గని కెత్తి సుట్లు జవుస్, కెద్ది డిట్టుమ్ బంద తిలె కి, అత్తొచ గొల్సుల్ కుట్టవుక, చట్టొచ గొల్సుల్ గండల్ కెరుక, దస్సి జతె తిలొ. జోక అన్నె ముద్దొ కెరుక కో కి నెతిర్ల. ");
INSERT INTO key_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","జో రాతి మెద్దెనె మెస్నెలె డొంగ్రలె బుల బుల, కెద్దొడి తెదొడి ఒర్స, జోక జొయ్యి పత్రల్ తెన్ పెటన, బాద కెరంతె తిలన్. ");
INSERT INTO key_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","జలె, జో దూరి తెంతొ యేసుక దెక, నిగ జా, సెర్ను సేడ యేసుక జొకర, ");
INSERT INTO key_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","“ఓ యేసుప్రబు, ఎత్కిచి ఉప్పిరి తిలొ దేముడుచొ పుత్తుసి, తుయి. అంచి తెన్ తుక కిచ్చొ కామ్? అంక అల్లర్ నే కెర్తి రితి దేముడుచి నావ్ తెన్ ఒట్టు గలను.” మెన గట్టిఙ కేకుల్ గలుక దెర్లొ. ");
INSERT INTO key_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","కిచ్చొక దస్సి జలొ మెలె, “ఓ బూతుమ్, ఈంజొ మాన్సు తెంతొ బార్ జా ముల దేసు!” మెన యేసు సంగ తిలొ. ");
INSERT INTO key_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","జలె, యేసు జో బూతుమ్‍క అన్నె, “తుచి నావ్ కిచ్చొ?” మెన పుసిలన్, చి జో యేసుక “అంచి నావ్ ‘సయ్‍న్యుమ్’. ఎత్తివాట్ జిన్ బూతల్ అస్సుమ్” మెన సంగ, ");
INSERT INTO key_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","“అమ్‍క ఈంజ దేసిమ్ తెంతొ ఉదడ గెలు నాయ్.” మెన జో బూతుమ్ యేసుక బతిమాల్ప జా సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","జలె, జా మెట్టయ్ వెల్లి మంద అండ్రులు కతె తిల. ");
INSERT INTO key_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","చి “ఆదె, జేఁవ్ అండ్రుల్‍క అమ్ దెర్తి రితి సెలవ్ దా, అమ్‍క జోవయింతె తెద్రవు” మెన యేసుక జేఁవ్ బూతల్ బతిమాల్ప జా సంగిల. ");
INSERT INTO key_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","దస్సి జతికయ్, యేసు సెలవ్ దిలన్. సెలవ్ దెతికయ్, జేఁవ్ బూతల్ బార్ జా జో మాన్సుక ముల దా, జేఁవ్ అండ్రుల్‍చి పెట్టి పెసిల, చి జేఁవ్ పాసి పాసి దొన్ని వెయిలు బోడియొ అండ్రులు బమ్మ జా, ఒత్తచి గాటిక నిగ ఉత్ర గెచ్చ, గడ్డె సేడ డుఙ మొర గెల. ");
INSERT INTO key_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","జేఁవ్ అండ్రుల్ దస్సి జతికయి, మంద రకితస బమ్మ జా ఉట్ట నిగ, పట్నుమ్‍తె, ఒండి ప్రాంతుమ్‍తె సూనయ్‍ల, చి జర్గు జలిసి దెకుక మెన, ప్రెజల్ ఎత్కి బార్ జల. ");
INSERT INTO key_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","జేఁవ్ ప్రెజల్ ఎత్కి యేసుతె జా, ఒగ్గర్ బూతల్ దెర తిలొ జో వెర్రి జా తిలొసొ అప్పె చెంగిల్ బుద్ది జా పాలల్ గలన ఒత్త వెస తిలిసి దెక, బియఁ గెల. ");
INSERT INTO key_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","జో చెంగిల్ జలిసి జర్గు జలి పొది సొంత దెక తిల మాన్సుల్, జలె, జో బూతల్ దెర వెర్రి జా తిలొసొక చి జేఁవ్ అండ్రుల్‍క జర్గు జలిసి ఎత్కి పిమ్మట్ అయ్‍లసక జేఁవ్ సాచి సంగిల. ");
INSERT INTO key_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ఒత్తచ మాన్సుల్ ఎత్కిజిన్ “అమ్‍చి ప్రాంతుమ్ ముల దా ఉట్ట గో” మెన యేసుక బతిమాల్ప జా సంగిల. ");
INSERT INTO key_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","పడ్తొ యేసు, సిస్సుల్, ఉట్ట గెచ్చుక మెన దోనితె తతికయ్, బూతల్ అగ్గె దెర తిలొ జో మాన్సు పట్టి జా, “ఆఁవ్ కి తుమ్‍చి తెన్ బెద జెంక అంక సెలవ్ దే.” మెన బతిమాల్ప జా సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","గని యేసు దస్సి సెలవ్ నే దెతె, జోక, “పోని, తుయి గెరి గెచ్చ తుచ సొంత మాన్సుల్‍క, ప్రబు తుక కన్కారుమ్ దెక చెంగిల్ కెర ఎదివాట్ దయ కెర్లిసి సంగు” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","జో మాన్సు యేసుక ముల దా ఉట్ట గెచ్చ, యేసు జోక ఎదివాటు దయ కెర్లిస్‍చి రిసొ దెకపొలి మెలి జా ప్రాంతుమ్‍తెచ పట్నల్ ఎత్కితె సూనపుక దెర్లొ. జా సూనయ్‍తికయ్, ఎత్కిజిన్ ఆచారిమ్ జల. ");
INSERT INTO key_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","యేసు అన్నె దోనితె వెగ గాడు అన్నె జీన్‍తికయ్, జోచి సుట్టునంత ఎదివాట్‍జిన్ జనాబ్ బెర అయ్‍ల. జో జా ఒడ్డుతె ఉత్ర తతికయ్, ");
INSERT INTO key_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","యూదుల్‍చి ఒత్తచి సబ గెర్‍చి అదికారి జలొ యాయీరు మెలొసొ జా కెర, యేసుక దెక కెర, జోచి చట్టె సెర్ను సేడ, ");
INSERT INTO key_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“అంచి నాడి జొర్జొ సేడ, జియెదె గే, నాయ్ గే, దస్సి జా అస్సె. తుయి, అమ్‍తె జా కెర జాక చడిలెగిన, జా చెంగిల్ జా అన్నె జియెదె.” మెన బతిమాల్ప జా జో సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","యేసు జో తెన్ బెద గెలన్. జేఁవ్ వట్టె గెతె తతికయ్, ఒగ్గర్ ఒగ్గర్‍జిన్ జనాబ్ యేసుచి పట్టి జా జోచి సుట్టునంత తా పెలపులి జతె తిల. ");
INSERT INTO key_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","జలె, బార వెర్సుల్ తెంతొ లొఁయి గెతి బాద తిలి తేర్‍బోద ఎక్లి జా జనాబ్‍తె అస్సె. ");
INSERT INTO key_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","జా స్రెమచి రిసొ చెంగిల్ కెరంతి రిసొ, ఎక్కిలొచి పిమ్మట్ అన్నెక్లొ గురుతె వర్స తెన్ గెచ్చ గెచ్చ, జాక తిలి దనుమ్ ఎత్కి విక కెరవన తిలి. దస్సి కెర కెర జలెకి, జా బాద తెన్ నే చెంగిల్ జతె, ఒగ్గర్ జతె తిలి. ");
INSERT INTO key_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","జలె, యేసుచి రిసొ సూన తా, “ఆఁవ్ జోచ పాలుమ్ జవుస్ చడిలె చెంగిల్ జయిందె” మెన ఉచర, ");
INSERT INTO key_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","యేసుచి సుట్టునంత తిలి జనాబ్‍చి తెడి పెస, యేసుచి పడ్తొ పాసి పాఁవ కెర, జోచొ పాలుమ్‍క చడిలి. ");
INSERT INTO key_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","చడిలి బేగి లొఁయి గెతిసి బందు జలి, చి బాద గెచ్చ జీవ్ చెంగిల్ జలి మెన చినన్లి. ");
INSERT INTO key_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","యేసు మాత్రుమ్, జోచి సెక్తిక కో గే, చెంగిల్ జా అస్తి మెన చినిలి బేగి, జా జనాబ్‍చి నెడిమి టీఁవొ జా పడ్తొ పస్ల, “అంచి పాలుమ్ చడిలొసొ కో?” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","జోచ సిస్సుల్ జోక, “తుచి ఉప్పిరి మాన్సుల్ పెలపెలి జలెకి, ‘అంక చడిలొసొ కో?’ మెన కిచ్చొక పుసితసి?” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","జలె, కో చడిలన్ గే జానన్‍క మెన, యేసు అన్నె పస్ల దెకితికయ్, ");
INSERT INTO key_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","జా తేర్‍బోద జాక జర్గు జలిసి జాన, బియఁ కెర, అద్దుర్ జా, యేసుచి పుర్రెతొ సెర్ను సేడ, జర్గు జలిసి ఎత్కి సత్తిమ్ తెన్ జోక సంగిలి. ");
INSERT INTO key_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","యేసు జాక, “ఓ పుత్తరి, అంచి ఉప్పిరి తుయి నముకుమ్ తిలి రిసొ తుయి చెంగిల్ జా అస్సిసి. సేంతుమ్ తెన్ గెచ్చ, చెంగిల్ జా, చెంగిల్ తా” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","జా తేర్‍బోదక యేసు దస్సి సంగితె తిలి పొది, దువిస్‍చి రిసొ యేసుతె జా తిలొ అదికారిచి గెర్‍చ సగుమ్‍జిన్ జా కెర, జో అదికారిక “తుచి నాడి మొర గెచ్చ అస్సె. ఈంజొ గురుబాబుక బుకార్లె లాబుమ్ నాయ్. గురుబాబుక జా బాద పోని” మెన జోక సంగిల. ");
INSERT INTO key_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","జలె, జేఁవ్ సంగిలిసి సూన నే సూన్లి రితి జా, యేసు సబగేర్‍చొ జో అదికారిక దెక, “జేఁవ్ సంగిలిస్‍క కాతర్ నే కెర్తె, బి నాయ్. నంపజా దయిరిమ్ తెన్ తా” మెన జోక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ఒత్త తెంతొ పేతురు, యాకోబు, యాకోబుచొ బావొసి యోహానుక పిట్టవ, జోచి పట్టి అన్నె కో జెంక సెలవ్ నే దా కెర, ");
INSERT INTO key_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","యేసు, జేఁవ్ తెన్ జో అదికారిచి గెరి పాఁవ కెర, ఒత్త తిలస ఏడుకుడు జా గోల జతిసి దెకిలన్. ");
INSERT INTO key_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","జో గెరి పెస, ఒత్త తిలసక దెక, “తుమ్ గోల జా ఏడ్తసు కిచ్చొక? ఈంజ బోద మొర గెచ్చె నాయ్ నిజ అస్సె.” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","దస్సి సంగితికయ్, జేఁవ్, జోక ఆఁసిల. గని యేసు జేఁవ్ ఎత్కిజిన్‍క బార్ కెర దా, నాడిచ అయ్యస్అబ్బొస్‍క కి, జో తెన్ అయ్‍ల సిస్సుల్‍క కి కడ ఆన, జా నాడి తిలిస్‍తె గెచ్చ, ");
INSERT INTO key_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","జా నాడిచి ఆతు దెర, జాక “ఆఁవ్ సంగిలయ్, నాడి, ఉట్టు!” మెలి అర్దుమ్ తెన్ “తలీతా కుమి” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","సంగిల్ బేగి, జా నాడి ఉట్ట కెర, ఇండుక దెర్లి. ఒత్త తిలస ఎత్కిజిన్ ఆచారిమ్ జా బలే ఉచర్ల. ");
INSERT INTO key_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","పడ్తొ, జర్గు జలిస్‍చి రిసొ కక్క సంగుక జయె నాయ్ మెన జాగర్త సంగ, “నాడిక కిచ్చొ జవుస్ అన్నిమ్ దాస” మెన, జా గేర్‍చక యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","యేసు ఒత్త తెంతొ ముల దా కెర, నజరేతు మెలి జోచి సొంత గఁవ్వి ఉట్ట జెతికయ్, జోచ సిస్సుల్ జోచి పట్టి అయ్‍ల. ");
INSERT INTO key_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","బక్తి కెర్తి సెలవ్ కడన్లి దీసి, ఒత్తచి సబ గెరి గెచ్చ, యేసు బోదన కెరుక దెర్లన్. జో సంగిలి బోదన సూన, ఒగ్గర్‍జిన్ మాన్సుల్ ఆచారిమ్ జా, “ఇసి బోదన ఇన్నెక కేనె తెంతొ అయ్‍లి? ఇన్నెక దిలి గ్యానుమ్ కీసిచి? కెద్ది అందుమ్‍చ వెల్లెల కమొ ఇన్నెచి అత్తి జర్గు జతతి! ");
INSERT INTO key_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","గని ఈంజొ దార్‍చ కామ్ కెర్తొసొ జయెదె, మరియచొ పుత్తుసి గెద? యాకోబుక, యోసేక, యూదాక, సీమోనుక అన్నొసి జయెదె గెద? ఇన్నెచ బేన్సివొ ఇన్నె అమ్‍చి తెన్ అస్తి గెద?” మెన యేసుచి రిసొ అన్మానుమ్ జా నంప కెర్తి నాయ్. ");
INSERT INTO key_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","జేఁవ్ దస్సి అన్మానుమ్ జతికయ్, “కేన్ జవుస్ మాన్సు దేముడుచి కబుర్ ఆన్‍తొసొ జలె, జోచి సొంత దేసిమ్‍చ మాన్సుల్, సొంత గెర్‍చ మాన్సుల్ జోక గవురుమ్ దెకిత్ నాయ్” మెన యేసు, జోవయించి అన్మానుమ్‍చి రిసొ సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ఒత్తచ మాన్సుల్‍చి అన్మానుమ్‍చి రిసొ, జలె, ఒత్త యేసు కేన్ వెల్లొ కమొ కెరుక బెదిలన్ నాయ్. ఎక్కి సగుమ్‍జిన్ జబ్బు తిల మాన్సుల్‍క బోడి చడ చెంగిల్ కెర్లన్. ");
INSERT INTO key_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","జా పలాన్‍చ మాన్సుల్‍చి అన్మానుమ్‍చి రిసొ ఆచారిమ్ జా, విసారుమ్ జలన్. గని, జా ప్రాంతుమ్‍చ గఁవ్విలె బుల బుల బోదన కెర్తె తిలన్. ");
INSERT INTO key_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ఒత్త తెంతొ, జేఁవ్ బారజిన్ సిస్సుల్‍క యేసు పాసి బుకారా కెర, జేఁవ్‍క దొగుల దొగులక గఁవ్విలె బులుక మెన తెద్రవుక దెర్లన్. తెద్రయిలి పొది, బూతల్‍క జేఁవ్ ఉదడ్తి రితి జోవయింక అదికారుమ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","తెదొడి కిచ్చొ ఆడ్ర దిలన్ మెలె, “ప్రయానుమ్‍చి రిసొ టెక్నొ డండొ పిట్టవ, పోడి జలెకు, సెంచె జలెకు, కెరంటెచి బెల్టుచి జేబితె డబ్బుల్ జలెకు దెరన నాయ్. ");
INSERT INTO key_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","జోడ్లు గలన, గని దొన్ని సొక్కల్ పోన. ఎక్కి సరి జతయ్” మెన సంగ. ");
INSERT INTO key_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","అన్నె, “తుమ్ కేనె జలెకు పాఁవిలె పొది, కేన్ గెర్‍చ తుమ్‍క టాన్ దెవుల గే, జా గాఁవ్ తెంతొ ఉట్ట గెతె ఎదక జయ్యి గెరి బస జా తా. ");
INSERT INTO key_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","గని, కేన్ టాన్‍తె జలెకు తుమ్‍క మరియాద కెర్తి నాయ్ గే, తుమ్‍చి కబుర్ సూనుక ఎద్గరె ఇస్టుమ్ జతి నాయ్ గే, తుమ్ ఒత్త తెంతొ ఉట్ట గెచ్చ. ఉట్ట గెతె పొది, ‘జేఁవ్ దస్సి జలి రిసొ, జేఁవ్ దేముడుచ నెంజితి’ మెలి రితి గుర్తుక తుమ్‍చ చట్టొచి దూడి పంప్డ గెలన” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","యేసు దస్సి అదికారుమ్ దా బులుక తెద్రయ్‍తికయ్, జేఁవ్ సిస్సుల్ దొగుల, దొగుల బార్ జా, “తుమ్ కెర్ల పాపల్‍చి రిసొ పెట్టి దుకుమ్ జా పాపుమ్ ముల్తి బుద్ది జా” మెన బోదన కెర బుల్తె తిల. ");
INSERT INTO key_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","పడ్తొ, మాన్సుల్‍క దెర్ల ఒగ్గర్ బూతల్‍క ఉదడ గెల, చి ఒగ్గర్‍జిన్ జబ్బుల్ తిలసక బోడి తేల్ సువ దా యేసుచి నావ్ తెన్ జోవయింక చెంగిల్ కెర్ల. ");
INSERT INTO key_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","యేసుచ కమొచి రిసొ హేరోదు మెలొ జా గలిలయ ప్రాంతుమ్‍క ఏలుప కెర్తొ రానొ కి సూన్లొ. జా ఒండి దేసిమి యేసుచి రిసొ ఎత్కిజిన్ సూన తిల. సగుమ్‍జిన్ జోక “బాప్తిసుమ్ దెతొ యోహాను అన్నె జీవ్ జా అస్సె, కిచ్చొగె, చి ఇస వెల్లొ కమొ కెర్తి సెక్తి జోచి పెట్టి అస్సె” మెంతె తిల. ");
INSERT INTO key_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","అన్నె సగుమ్‍జిన్, “ఏలీయా పూర్గుమ్‍చొ జా తయెదె” మెంతె తిల. అన్నె సగుమ్‍జిన్, “దేముడుచ కబుర్లు పూర్గుమ్ సంగిలొ ఎక్కిలొ రితొ జయెదె. దసొచొ జా తయెదె” మెంతె తిల. ");
INSERT INTO key_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","హేరోదు, మాత్రుమ్, సూన, కిచ్చొ ఉచర్లన్ మెలె, “ఆఁవ్ బోడి గండ కెరవ తిలొ యోహాను జా తయెదె. అన్నె జీవ్ జా అస్సె, కిచ్చొగె” మెన బియఁ గెలొ. ");
INSERT INTO key_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","హేరోదు రానొ కిచ్చొక దస్సి బిలన్ మెలె, జోచొ పిలిప్ మెలొ బావొసిచి హేరోదియ మెలి తేర్సిక ఆనన హేరోదు జాక పెండ్లి జా తిలొ. ");
INSERT INTO key_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","దస్సి, అన్నెక్లొచి తేర్సిక పెండ్లి జతికయ్, యోహాను హేరోదుక “తుచొ బావొదిసి తేర్సిక తుయి తియనుక నాయిమ్ నాయ్” మెన సంగితె తిలన్. జాక, హేరోదు యోహానుక జేలి కెరవ, జేల్‍తె గల బందవడ తిలన్. ");
INSERT INTO key_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","జేల్‍తె గల తతికయ్, యోహానుచి ఉప్పిరి హేరోదియ కుస్సిదుమ్ తా, జోక మారుక ఆస జా అస్సె. గని నెత్రె. కిచ్చొక మెలె, ");
INSERT INTO key_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","యోహాను, దేముడుచొ సత్తిమ్ సుదొ, నీతి సుదొ, మెన హేరోదు జాన కెర, జోక కిచ్చొ ప్రమాదుమ్ నే జతి రితి రకవ అస్సె. అన్నె, యోహాను సంగితి తీర్పుక హేరోదు బాద సేడ్లె కి, రోజుక సంతోసుమ్ తెన్ జోచి బోదన సూన్‍తె తిలన్. ");
INSERT INTO key_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","జలె, జా మదెనె జా తేర్‍బోద యోహానుక కిచ్చొ కెరుక నెతిర్లె కి, ఆకర్‍క జోక మొరవుక అవ్‍కాసుమ్ అయ్‍లి. హేరోదుచి జెర్మున్ పండుగు దీసి జెతికయ్, జోచ మంత్రివొక, వెల్లెల మాన్సుల్‍క, చి గలిలయ ప్రాంతుమ్‍చ వెల్లెల మాన్సుల్ ఎత్కిజిన్‍క వెల్లి విందుతె రానొ బుకార్లొ. ");
INSERT INTO key_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","జా విందు కెర్లి పొది, హేరోదియ మెలి జా తేర్‍బోదచి దువిసి విందుతె బుకార్లసచి నెడిమి జా నచిలి. హేరోదు, బుకార్లస, ఎత్కిజిన్ జా నచిలిసి మెన్స గెల, చి హేరోదు జా నాడిక, “కిచ్చొ ఇస్టుమ్ జస్తె గే అంక సంగు చి జయ్యి దెయిందె” మెన అన్నె, ");
INSERT INTO key_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","“తుయి కిచ్చొ నఙిలె కి, అంచి రాజిమ్‍తె ఏక్ అర వాట నఙిలె కి, జయ్యి దెయిందె” మెన ఒట్టు గలన్లన్. ");
INSERT INTO key_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","జలె, జా నాడి బార్ జా, అయ్యస్‍తె గెచ్చ, “ఆఁవ్ కిచ్చొ నఙుక?” మెన పుసితికయ్, అయ్యసి, “బాప్తిసుమ్ దెతొ యోహానుచి బోడి అంక దే మెన సంగు” మెన దువిస్‍క సంగిలి. ");
INSERT INTO key_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","సంగిలి బేగి, జా నాడి హేరోదుతె నిగ జా, “బాప్తిసుమ్ దెతొ యోహానుచి బోడి ఏక్ పలెరుమ్‍తె అంక దే” మెన సంగిలి. ");
INSERT INTO key_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","నాడి ఇసి సంగితికయ్, జో రానొ బలే దుకుమ్ జలెకి, జో గలన తిలి ఒట్టుచి రిసొ, విందుతె బుకార్లసచి మొక్మె జాక సంగిలిసి పిట్టవుక నెస కెర, ");
INSERT INTO key_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","బేగి, “జోచి బోడి ఆను” మెన జమాను ఎక్కిలొక తెద్రయ్‍లన్. జో జమాను గెచ్చ, జేల్‍తె యోహానుచి బోడి గండ కెర, ");
INSERT INTO key_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","పల్లెరుమ్‍తె ఆన, జా నాడిక దెతికయ్, జా నాడి అయ్యస్‍క నా దిలి. ");
INSERT INTO key_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","జలె, యోహానుచ సిస్సుల్ సూన కెర, జా కెర, పీనుమ్ నఙన ఉక్కుల నా, మెస్నె రోవిల. ");
INSERT INTO key_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","యేసు తెద్రయ్‍ల జోచ బారజిన్ సిస్సుల్ బోదన కెర కెర మాన్సుల్‍క చెంగిల్ కెర కెర, జోతె అన్నె బుల జా, జేఁవ్ కెర తిలిసి, బోదన కెర తిలిసి ఎత్కి జోక సంగిల. ");
INSERT INTO key_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","జలె, ఒగ్గర్ ఒగ్గర్‍జిన్ మాన్సుల్ జోవయింతె జెంక గెచ్చుక జతె తిలి రిసొ, అన్నిమ్ కంక కి పుండితి సమయుమ్ దొర్కు నెంజితికయ్, యేసు సిస్సుల్‍క “జొమ్మ, తుమ్ గడియ పుండితి రిసొ, కేనెగె, మాన్సుల్ నెంజిలి టాన్‍తె బెద గెచ్చుమ” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","జేఁవ్ బార్ జా దోనితె వెగ, అన్నె కోయి నెంజిలి టాన్‍తె గెచ్చుక బార్ జల. ");
INSERT INTO key_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","గని, జేఁవ్ బార్ జా ఉట్ట గెలిసి ఒగ్గర్‍జిన్ దెక, జోవయింక చిన, వేర వేర పట్నలె గఁవ్విలె తెంతొ బార్ జా నిగ, నిగ జోవయించి తొల్లితొ జేఁవ్ గెతె తిలిస్‍తె పాఁవిల. ");
INSERT INTO key_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","యేసు జా ఒడ్డుతె పాఁవ, దోనితె తెంతొ ఉత్ర, ఒగ్గర్ ఒగ్గర్‍జిన్ జనాబ్ బెర అయ్‍లిసి దెక, ‘గొవుడు నెంజిల మెండల్ కీసి జా కేనె తెర్లె ఒత్తలి ఉట్ట గెతె తవుల గే దస్సి, ఈంజేఁవ్ ప్రెజల్ అస్తి’ మెన యేసు కన్కారుమ్ జా, ఈంజ ఎత్కి బోదన జోవయింక సికడుక దెర్లన్. ");
INSERT INTO key_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","సాంజ్ జంక దెర్తికయ్, యేసుచ సిస్సుల్ జోతె జా కెర, “ఈంజ డొంగుర్ దేసిమ్. పొద్దు ఒగ్గర్ జలి, తొక్కి అస్సె. ");
INSERT INTO key_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ఈంజేఁవ్ ప్రెజల్ ఎత్కి ఈంజ పల్లల్‍చ గఁవ్విలె గెచ్చ, కిచ్చొ జవుస్ అన్నిమ్ గెనన్‍తి రిసొ ఇన్నెక తెద్రవు.” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ఇసి సంగితికయ్, యేసు సిస్సుల్‍క కిచ్చొ జబాబ్ దిలన్ మెలె, “తూమ్ జోవయింక కిచ్చొ జవుస్ అన్నిమ్ దాస”. ఇసి యేసు సంగితికయ్, జేఁవ్ జోక, “జోవయింక అన్నిమ్ దెంక మెన దొన్ పుంజొ వెండ్లుచ పోడియొ గెనుక ఆమ్ గెచ్చుక గే?” మెంతికయ్, ");
INSERT INTO key_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","యేసు జోవయింక, “తుమ్‍తె కెత్తి పోడియొ అస్తి గే, గెచ్చ దెక” మెలన్, చి జేఁవ్ గెచ్చ దెక జా కెర, “పాఁచ్ పోడియొ చి దొన్ని మొస్స అస్తి” మెన జోక సంగిల. ");
INSERT INTO key_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","జో, జేఁవ్ జనాబ్‍క దెక, జోవయింక “తుమ్ ఎత్కిజిన్ వర్సవర్సల్ తెన్ బుఁయ్యె వెస” మెన జా చివ్వర్ బుఁయ్యె వెసడ్లన్. ");
INSERT INTO key_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","జాకయ్ జేఁవ్ ఎక్కెక్ వర్సల్‍తె పుంజెక్ జిన్, యాబయ్‍జిన్ వెసితికయ్, ");
INSERT INTO key_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","యేసు జేఁవ్ పాఁచ్ పోడియొ దొన్ని మొస్స దెర, ఆగాసుమ్ పక్క దెక, ‘ఈంజ తూయి దిలది’ మెన దేముడు జలొ అబ్బొస్‍క జొకర కెర, జేఁవ్ పోడియొ మోడ కెర, “ఎత్కిజిన్‍క వంట దాస” మెన సిస్సుల్‍చి అత్తి సొర్ప కెర దా, జేఁవ్ దొన్ని మొస్సక కి ఎత్కిజిన్‍క వంట దిలన్. ");
INSERT INTO key_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","జేఁవ్ జనాబ్ ఎత్కిజిన్ పేట్ బెర్తు కతికయ్, ");
INSERT INTO key_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","సేంసిల పోడి గండలు, మొస్స గండలు బార గంపల్‍తె సిస్సుల్ గుడ్డ బెరయ్‍ల. ");
INSERT INTO key_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","జా దీసి పోడియొ కయ్‍లస, పాఁచ్ వెయిల్‍జిన్ మున్సుబోదల్ జల. ");
INSERT INTO key_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","తెదొడి బేగి, యేసు ప్రెజల్‍క నే తెద్రయ్‍తె తొలితొ, “తుమ్ దోని వెగ అంచి కంట తొలితొ గాడు జీన, బేత్సయిదా గఁవ్వి గెచ్చ” మెన సిస్సుల్‍క తెద్రవ దా, ");
INSERT INTO key_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","జేఁవ్ ప్రెజల్‍తె సెలవ్ నఙన తెద్రవ దా, ప్రార్దన కెర్తి రిసొ యేసు డొంగ్రె వెగిలన్. ");
INSERT INTO key_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ఒగ్గర్ సాంజ్ జతికయ్, సిస్సుల్ తిలి జా దోని సముద్రుమ్ రితి జా గాడుచి మదెనె పాఁవ తతికయ్, యేసు ఎక్కిలొ గట్టుతె తా, ");
INSERT INTO key_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","కిచ్చొ దెకిలొ మెలె, దోనిక వాదు పెలయ్‍తె తిలి రిసొ, దోని ఇండవుక సిస్సుల్ కస్టుమ్ జతె అస్తి. జలె, అందరె, పాసి పాసి కుకుడొ వాఁసెనె, యేసు జా సముద్రుమ్‍చి ఉప్పిరి ఇండ జా, సిస్సుల్‍చి పాసి పాఁవ అయ్‍లొ. జోవయింక జిన్‍తె ఉట్ట గెచ్చుక మెనన్లొ. ");
INSERT INTO key_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","గని, పానిచి ఉప్పిరి జో ఇండ గెతిసి సిస్సుల్ దెక, “డుంబొ, కిచ్చొగె” మెన ఉచర బమ్మ జా ఒర్సిల. ");
INSERT INTO key_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","జేఁవ్ ఎత్కిజిన్ జోక దెక దస్సి పంబ్ర జలి బేగి, జో, “దయిరిమ్ జా. ఆఁవ్వి, తుమ్ బియఁ నాయ్” మెన జోవయింక సంగ ");
INSERT INTO key_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","దోనితె జోవయించి నెడిమి వెగితికయ్, వాదు ముల దిలి. జాచి రిసొ జేఁవ్‍క జెఁవ్వి ఆచారిమ్ జా ఒగ్గర్ బమ్మ జల. ");
INSERT INTO key_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","గని పోడియొక యేసు జర్గు కెర్లిసి అర్దుమ్ నే కెరన తిలి రిసొ, జో కొన్సొగె, జోచి పెట్టి బేడు బందిల్ జోచి సెక్తి అదికారుమ్ కేనెచి గే అర్దుమ్ నే కెరంతె, బలే ఆచారిమ్ తెన్ తిల. ");
INSERT INTO key_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","జేఁవ్ దోనితె గాడు జీన గెన్నేసరెతు ప్రాంతుమ్‍తె పాఁవ దోని ఒడ్డుతె బంద కెర ");
INSERT INTO key_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","దోని తెంతొ ఉత్తిర్లి బేగి, ఒత్త తిల మాన్సుల్ జోక చిన కెర, ");
INSERT INTO key_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","జబ్బు తిల మాన్సుల్ జా ఒండి పలాన్‍తె కేనె తిలె ఒత్త గెచ్చ, జేఁవ్ నిజ తిలి అంతుర్నొ తెన్ ఉక్కుల కెర యేసు కేనె అస్సె గే సూన్లె, ఒత్తయ్ వయ ఆన్‍తె తిల. ");
INSERT INTO key_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","జా ప్రాంతుమ్‍చ పట్నలె గఁవ్విలె బయిలె, కేన్ జలెకు టాన్‍తె జో అయ్‍లొ గే, బాద తిలసక కడ ఆన, సంతవీదులె జలెకు ఎంగ్డవ దా, యేసుచొ పాలుమ్‍చి అంచు జలెకు జేఁవ్ చడుక మెన బతిమాల్ప జా సెలవ్ నఙన్‍తె తిల. కో జలెకు చడిల గే, జేఁవ్ చెంగిల్ జల. ");
INSERT INTO key_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","యెరూసలేమ్ పట్నుమ్ తెంతొ సగుమ్‍జిన్, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస కి పరిసయ్యుల్ సగుమ్‍జిన్‍చి ఒత్త జా తా, యేసుతె బెద జా కెర, ");
INSERT INTO key_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","జోచ సిస్సుల్‍తె సగుమ్‍జిన్ గర్చ అత్తొ తెన్, మెలె నే దొవన్‍తె, అన్నిమ్ కెర్తిసి దెక కెర, బమ్మ జల. ");
INSERT INTO key_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","కిచ్చొక మెలె, పరిసయ్యుల్ కి యూదుల్ ఎత్కిజిన్ కి ‘పూర్గుమ్‍చ వెల్లెల మాన్సుల్ సికయ్‍లిసి కెరుకయ్’ మెన, గుర్తు అత్తొ దొవన్లెకయ్ కవుల, నెంజిలె నాయ్. ");
INSERT INTO key_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","అన్నె, సంతయ్ తెంతొ గెరి అయ్‍లె, ‘నే దొవన్లె గారు’ మెన, పాని చించన్లెకయి కవుల, నెంజిలె నాయ్. దస్సి, గిన్నలు, గేడివొ, కంచు సామన్, ఈంజ జా ఎత్కి కెఁయఁక దోవుక గే, కీసి దోవుక గే, కిచ్చొ కిచ్చొ అలవాట్లు రితి కెరుక పూర్గుమ్‍చ జోవయించ వెల్లెల మాన్సుల్ సికడ అస్తి. ");
INSERT INTO key_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","జాచి రిసొ, జేఁవ్ పరిసయ్యుల్ చి మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస యేసుక, “తుచ సిస్సుల్ కిచ్చొక వెల్లెల మాన్సుల్ సంగిలి రితి ఇండుక ముల దా, గర్చ అత్తొ తెన్ అన్నిమ్ కతతి?” మెన పుసిల. ");
INSERT INTO key_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","జలె, యేసు జోవయింక, “తుమ్ ఉప్రమెన్సుచొచి రిసొ యెసయా పూర్గుమ్‍చొచి అత్తి దేముడు సంగిలి కోడు సత్తిమ్. ఈంజ ప్రెజల్ అంక గవురుమ్ కెర్త రిత కొడొ సంగిలే కి, జోవయించి పెట్టి అంక దూరి అస్తి. ");
INSERT INTO key_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","మాన్సుల్ అఁవ్వి ఉచర్ల కొడొక ‘దేముడు సంగిలస’ మెన ప్రెజల్‍క సికడ, అంక ఆరిక జొకర్తతి” మెన తుమ్‍చి రిసొచి కోడు. ");
INSERT INTO key_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“తూమ్, దేముడు దిలి ఆగ్న ముల దా, మాన్సు అఁవ్వి ఉచర్లిసి ఎక్కి మెన్సు నిదానుమ్ కెర్తసు” మెన జేఁవ్ వెల్లెల మాన్సుల్‍క యేసు సంగ, ");
INSERT INTO key_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","జోవయింక అన్నె, “తుమ్‍చ పూర్గుమ్‍చ అఁవ్వి సికయ్‍ల అలవాట్లు నిదానుమ్ కెర్తి రిసొ దేముడుచి ఆగ్న రితి ఇండుక ముల అస్సుస్. కీస మాన్సుల్, తూమ్! ");
INSERT INTO key_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","తుమ్ ములిలి కేన్ ఆగ్నచి రిసొ ఆఁవ్ అప్పె సంగితసి మెలె, తుమ్‍చ అయ్యద్‍అబ్బొద్‍క చెంగిల్ దెక, గవురుమ్ కెర” మెన, పిమ్మట్, “అయ్యస్‍క జలెకు, అబ్బొస్‍క జలెకు, కో దూసుప కెరుల గే, కచితుమ్ జోక మొర్నుచి సిచ్చ దెంక” మెన మోసేచి అత్తి రెగిడ్లి కోడు అస్సె. ");
INSERT INTO key_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","“గని, తుమ్ జలె ఇన్నె మెంతసు, అంచితె తుమ్‍క కిచ్చొ కలుగు జతి గే, జయ్యి ‘కొర్బాను’ మెలె ‘ప్రబుక దెంక ఒప్పన అస్సి’, మెన కో పుత్తుసి అయ్యస్అబ్బొస్‍క సంగిలెగిన, ");
INSERT INTO key_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","‘జా దీసి తెంతొ, జో మాన్సుచి పూచి నాయ్’ తుమ్ సంగిల్ రితి జా, జో అయ్యస్అబ్బొస్‍క దెంక తిలి సాయిమ్ జో మాన్సు దెంక తుమ్ ఒప్పుస్ నాయ్. ");
INSERT INTO key_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","తుమ్ దస్సి జా, తుమ్‍చ పూర్గుమ్‍చ అఁవ్వి ఉచర్ల అలవాట్లు ప్రెజల్ కెర్తు మెన, ‘దేముడు సంగిలి కోడుక అదికారుమ్ నాయ్’ మెన సికడ్లి రితి జా, తుమ్ దేముడుచి కోడు మార్సుప కెర్లి రితి కెర్తసు. అన్నె దస్స మాయల్ ఒగ్గర్ కెర్తసు.” మెన, జేఁవ్ వెల్లెల మాన్సుల్‍క యేసు గోల కెర్లన్. ");
INSERT INTO key_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","తెదొడి యేసు ప్రెజల్‍క అన్నె పాసి బుకారా కెర, జోవయింక ఇస్సె మెలన్. ఆఁవ్ సంగితి కోడు తుమ్ ఎత్కిజిన్ ఏక్ కోడు సూన అర్దుమ్ కెరన. ");
INSERT INTO key_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","బయిలె తెంతొ మాన్సుచి పేట్ తెడి కిచ్చొ వస్తువ పెసిలె, జయ్యి జో మాన్సుక గార్ కెరుక నెత్రె. గని, మాన్సుచి పెట్టి తిలి బుద్ది గార్ జలె, జయ్యి జో మాన్సుక గార్ కెరెదె. ");
INSERT INTO key_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","సూన్‍త కంగ్డొ కక్క తిలె, సరిగా సూన్‍సు! ");
INSERT INTO key_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","జేఁవ్ ప్రెజల్‍క ముల దా గెరి గెచ్చ తెడి పెసిలి పొది, జోచ సిస్సుల్ ఈంజ టాలిచి రిసొ పుసిల. ");
INSERT INTO key_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","యేసు జోవయింక, “తూమ్ కి అర్దుమ్ నెంతె అస్సుస్ గే? మాన్సు కయ్‍లె, బయిలె తెంతొ జో మాన్సుచి పెట్టి కిచ్చొ పెస తయెదె గే, జో మాన్సుక గార్ కెరుక నెత్రె మెన అర్దుమ్ కెరన్సు నాయ్? ");
INSERT INTO key_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ఈందె, జోచి పేట్ వాట్ గెచ్చ, అన్నె బార్ జయెదె. జోచి పెట్టితె పెసె నాయ్! జాకయ్, జోక గార్ కెరె నాయ్” మెన సంగిలన్. ఇసి మెన యేసు సంగిలిస్‍చి అర్దుమ్ కిచ్చొ మెలె, “కిచ్చొక కి కంక గారు మెనుక నెంజె. కిచ్చొ కి కంక జయెదె” మెన సెలవ్ సంగిల్ రితి జతయ్. ");
INSERT INTO key_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","తెదొడి యేసు సిస్సుల్‍క “మాన్సుచి పెట్టితె మొదొల్ జా, కిచ్చొ కిచ్చొ బార్ జయెదె, జయ్యి జోక గార్ కెరెదె. ");
INSERT INTO key_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","మెలె, గర్చ ఉద్దెసుమ్‌లు, లంజెబుద్ది, చోరు బుద్ది, అత్య కెర్తి బుద్ది, లంజెకమొ, ");
INSERT INTO key_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","అన్నె మాన్సుల్‍చి ఆస్తిక ఆస జతిసి, పాపుమ్ ఇండితి ఆస, మోసిమ్‍బుద్ది, గోసలు, మాన్సుల్‍క దూసుప కెర్తిసి, గవురుమ్ ఉచరంతిసి, కామ్‍క నెంజిత కొడొ, దసచ ఎత్కి, మాన్సుచి తెడి జోచి పెట్టితె మొదొల్ జతతి. ");
INSERT INTO key_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","గర్చ బుద్దుల్ ఎత్కి మాన్సుచి పేట్ తెడి మొదొల్ జా బార్ జతతి. దసచయ్ మాన్సుక గార్ కెర్తతి” మెన అన్నె సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","యేసు ఒత్త తెంతొ బార్ జా, తూరు చి సీదోను మెల పట్నల్‍చి ప్రాంతుమ్‍తె ఉట్ట గెచ్చ, ఏక్ గెరి గెలన్. జో ఒత్త తిలి రితి కో కి సూనుక జో నెసిలె కి, జో తిలిసి లుంకడుక నెతిర్ల, ");
INSERT INTO key_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","చి బేగి, బూతుమ్ దెర్లి ఇదిలిస్ దువిసి తిలి ఏక్ తేర్‍బోద, యేసుచి రిసొ సూన కెర, జోతె జా కెర, జోచి చట్టె సెర్ను సేడ్లి. ");
INSERT INTO key_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","జా తేర్‍బోద కేనెచి మెలె, జా సిరియ దేసిమ్‍చి జా పెనికయ ప్రాంతుమ్‍తె జెర్మిలి, గ్రీకు మెలి వేర దేసిమ్‍చి మాన్సు. జలె, జా తేర్‍బోద యేసుతె జా కెర, “అంచి దూక దెర్లి బూతుమ్‍క ఉదడ గెల్తె గె?” మెన యేసుక బతిమాల్ప జా సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","జో జాక, “సొంత బోదల్ తొలితొ కతు. బోదల్‍చి వంతు అన్నిమ్ గుడ్డ కెర, సూనకూనర్లు కతి రితి గల దెంక చెంగిల్ నాయ్” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","జా జోక, “నిజుమి, ప్రబు, గని సూనకూనర్లు కి అన్నిమ్ కెర్తి బల్లచి ఎట్టొ రక తా, బోదల్ సేడయ్‍లి ఉస్టొ కవుల” మెన సంగిలి. ");
INSERT INTO key_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ఇసి సంగితికయ్, తెదొడి యేసు జాక, “ఈంజ తుయి సంగిలి తుచి నముకుమ్‍చి రిసొ, సేంతుమ్ తెన్ గో. బూతుమ్ తుచి దువిద్‍క ముల దా గెచ్చ అస్సె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ఇసి సంగితికయ్, జా తేర్‍బోద గెరి గెచ్చ కిచ్చొ దెకిలి మెలె, బూతుమ్ ముల దా గెలి రిసొ, జా నాడి మంచుమ్‍తె నిజ తిలిసి. ");
INSERT INTO key_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ఒత్త తెంతొ యేసు తూరు ప్రాంతుమ్ ముల దా సీదోను ప్రాంతుమ్ వాట్ గెచ్చ, దెకపొలి ప్రాంతుమ్ వాట్ కి గెచ్చ. గలిలయ ప్రాంతుమ్‍చి సముద్రుమ్ రితి గాడు పక్క అన్నె ఉట్ట అయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ఉట్ట జెతికయ్, బొయ్‍రొ తిలొ తొత్లొ మాన్సు ఎక్కిలొక మాన్సుల్ యేసుతె కడ ఆన, “ఇన్నెక చడ చెంగిల్ కెర్తె గే?” మెన యేసుక బతిమాల్ప జా పుసిల. ");
INSERT INTO key_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","జలె, ప్రెజల్‍తె తెంతొ యేసు జోక ఎక్కిలొక పక్క కడన, జో మాన్సుచ కంగ్డొతె ఏక్ ఏక్ ఊంటివొ గల దా తుంక్ర, జో తొత్లొచి జీబు చడ జోచి సొంత లాడు దెరవ దా, ");
INSERT INTO key_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ఆగాసుమ్ పక్క దెక, కన్కారుమ్ తెన్ పెట్టి ఏడ్లి రితి జా, ‘ఉగ్డి జా’ మెలి అర్దుమ్ తెన్, ఒత్తచి బాస తెన్ “ఎప్పాతా” మెన సంగ యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","యేసు దస్సి సంగితికయ్, జో బొయ్‍రొచ కంగ్డొ ఉగ్డి జలి చి చెంగిల్ జలన్, చి జీబు బులుక దెర్తికయ్, సొస్టుమ్ లట్టబుక దెర్లన్. ");
INSERT INTO key_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","తెదొడి, “కక్క సంగ నాయ్” మెన ఒత్త తిల మాన్సుల్‍క యేసు సంగిలన్. గని “సంగుక పోన” మెన జో కెత్తి సుట్లు సంగిలే కి, జేఁవ్ అన్నె ఒగ్గర్ జా కేన్ తెన్ సంగితె తిల. ");
INSERT INTO key_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","జర్గు జలిస్‍చి రిసొ ఎదివాట్ ఆచారిమ్ జా, యేసుచి రిసొ “ఈంజొ కిచ్చొ కెర్లె కి జెయిమ్ జతయ్. బొయ్‍ర మాన్సుల్ సూన్‍తి రితి కెరుక జానె, తొత్ల మాన్సుల్ సొస్టుమ్ లట్టబ్తి రితి కెరుక జానె. ఎత్కి చెంగిల్ కెర అస్సె” మెన ఎత్కిజిన్ సంగితె తిల. ");
INSERT INTO key_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","జేఁవ్ దీసలె అన్నెక్ సుట్టు ఒగ్గర్‍జిన్ జనాబ్ యేసుతె బెర తతికయ్, జోవయింక కతిసి కిచ్చొ నెంజిలి రిసొ, యేసు జోచ సిస్సుల్‍క పాసి బుకారా, జోవయింక ");
INSERT INTO key_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“ప్రెజల్ అప్పెక తిర్రతి ఎద అంచి తెన్ అస్తి. జోవయింక కతిసి కిచ్చొ కి నాయ్ చి రిసొ జోవయించి ఉప్పిరి ఆఁవ్ కన్కారుమ్ జా అస్సి. ");
INSERT INTO key_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","జోవయింక చువ్వెచి పెట్టి గెరి తెద్రయ్‍లెగిన, వట్టె ఏక్ వేల మొకొమ్ గుంజ్ర సేడుల. జోవయింతె సగుమ్‍జిన్ దూర్ తెంతొ జా అస్తి.” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","జేఁవ్ సిస్సుల్ ఆచారిమ్ జా, “ఈంజ బయిలు దేసిమి ఎతివాట్‍జిన్ మాన్సుల్‍క అన్నిమ్ దొర్కు కెరుక కీసి?” మెన అన్మానుమ్ జా సంగిల. ");
INSERT INTO key_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ఇసి సంగితికయ్, యేసు జోవయింక “తుమ్‍తె కెత్తి పోడియొ అస్తి?” మెన పుసిలన్, చి “సత్తు” మెన జబాబ్ దిల. ");
INSERT INTO key_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","జలె, యేసు జా జనాబ్‍క “బుఁయ్యె వెస” మెన ఆడ్ర దా, జేఁవ్ సత్తు పోడియొ దెర, “తుయి దా దయ కెర్లది” మెన దేముడు అబ్బొస్‍క ఉచర, జేఁవ్ పోడియొ మోడ కెర, “ప్రెజల్‍క వంట దాస” మెన సిస్సుల్‍క దెతికయ్, ప్రెజల్‍క వంట దిల. ");
INSERT INTO key_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","దొన్ని ఇదుద్ల మొస్స కి తతికయ్, యేసు దేముడు అబ్బొస్‍క అన్నె దస్సి జొకర, “ఈంజేఁవ్ మొస్స కి వంట దాస” మెన ఆడ్ర దెతికయ్, సిస్సుల్ ప్రెజల్‍క వంట దిల. ");
INSERT INTO key_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ఎత్కిజిన్ పేట్ బెర్తు కతికయ్, సేంసిల గండలు సిస్సుల్ గుడ్డిల, చి సత్తు గంపల్‍తె బెర్ల. ");
INSERT INTO key_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","అన్నిమ్ కత్తస కెత్తిజిన్ జల మెలె, పాసి పాసి చెత్తర్ వెయిల్‍జిన్ జల. ");
INSERT INTO key_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","జలె, యేసు ప్రెజల్‍క గెరి తెద్రవ దా, సిస్సుల్ తెన్ బేగి దోనితె వెగ, దల్మనూతా ప్రాంతుమ్‍తె ఉట్ట గెల. ");
INSERT INTO key_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","యేసు ఇసి ఒత్త తిలి పొది, పరిసయ్యుల్ సగుమ్‍జిన్ జా కెర, యేసు తెన్ జట్టి జతి రితి జా, జోక “తుచి అదికారుమ్ పరలోకుమ్ తెంతొ చి జలె, అమ్‍క రుజ్జు దెకయ్‍తి రిసొ కిచ్చొ జవుస్ వెల్లి కామ్ కెరు.” చెంగిల రితి జోక పరిచ్చ కెర్ల. ");
INSERT INTO key_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","యేసు, జలె, జోచి మెన్సుతె ఒగ్గర్ దుకుమ్ జా ఏడ్లి రితి జా, “తుమ్ ఈంజ కాలుమ్‍చ మాన్సుల్ కిచ్చొక అంచి రిసొ రుజ్జు దెకయ్‍త కమొక ఆస జతసు? ఆఁవ్ తుమ్‍క కిచ్చొ కచితుమ్ సంగితసి మెలె, తుమ్ అన్మానుమ్ జల ఈంజ కాలుమ్‍చ మాన్సుల్‍క తుమ్ ఉచర్లి సాచి కామ్ ఎక్కి కి కెర దెంక నెంజె.” మెన జేఁవ్ వెల్లెల మాన్సుల్‍క సంగ కెర, ");
INSERT INTO key_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","జోవయింక ముల దా, సిస్సుల్ తెన్ దోని అన్నె వెగ, గాడు జీన ఒత్తల్‍తొ గెచ్చుక మెన బార్ జల. ");
INSERT INTO key_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","దోనితె ఎక్కి పోడి తిలి, గని అన్నె పోడియొ ఆనుక సిస్సుల్ పఁవ్స తిల. ");
INSERT INTO key_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","జలె, యేసు జోవయింక కిచ్చొ సంగిలన్ మెలె, “తుమ్ దెకన. పరిసయ్యుల్ చి రానొ జలొ హేరోదుచి పులయ్‍తి పీట్‍చి రగుమ్‍చి రిసొ తుమ్ జాగర్త తెన్ తా” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ఇసి సంగితికయ్, జేఁవ్ ఎక్కిలొక ఎక్కిలొ “అమ్‍క పోడి నాయ్. కిచ్చొక ఇసి మెన అమ్‍క సంగితయ్?” మెన లట్టబంతె తిల. ");
INSERT INTO key_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","యేసు జేఁవ్ ఉచర్లిసి జానెచి రిసొ, జో “‘అమ్‍క పోడియొ నాయ్’ మెన కిచ్చొక లట్టబంతసు? తుమ్ అప్పెక అర్దుమ్ కెరన్సు నాయ్ గే? తుమ్‍క పెట్టి బేడు బంద అస్సె గే, చి అర్దుమ్ కెరనుక ఇస్టుమ్ జసు నాయ్ గే? ");
INSERT INTO key_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","తుమ్‍క అంకివొ తిలె కి దెకుస్ నాయ్ గె? తుమ్‍క కంగ్డల్ తిలె కి సూన్‍సు నాయ్ గే? అప్పె రితి జర్గు జలిసి కి ఏదస్ట కెర్సు నాయ్ గే? ");
INSERT INTO key_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","జేఁవ్ పాఁచ్ వెయిల్‍జిన్ మాన్సుల్‍క ఆఁవ్ పాఁచ్ పోడియొ మోడ వంట్లి దీసి, కెత్తి గంపల్‍తె సేంసిల గండల్ గుడ్డ బెరయ్‍లదు?” మెన సంగితికయ్, జేఁవ్ “బార గంపల్‍తె” మెన జబాబ్ దిల. ");
INSERT INTO key_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“అన్నె, జేఁవ్ చెత్తర్ వెయిల్‍జిన్ మాన్సుల్ తిలిస్‍తె జేఁవ్ సత్తు పోడియొ మోడ వంట్లి దీసి, కెత్తి గంపల్‍తె సేంసిల గండల్ గుడ్డ బెరయ్‍లదు?” మెన సంగితికయ్, జేఁవ్ “సత్తు గంపల్‍తె” మెన జబాబ్ దిల. ");
INSERT INTO key_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","జాకయ్ జో జోవయింక “జలె, అప్పెక కి తుమ్ అర్దుమ్ కెరన్సు నాయ్ గే?” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","తెదొడి యేసు, సిస్సుల్, బేత్సయిదా గఁవ్విచి ఒడ్డుతె దోనితె పాఁవ ఉత్తిర్ల. గుడ్డి మాన్సు ఎక్కిలొక ఒత్తచ మాన్సుల్ సగుమ్‍జిన్ యేసుతె కడ ఆన, “దయ కెర, ఇన్నెక చడ చెంగిల్ కెరు” మెన బతిమాల్ప జా సంగిల. ");
INSERT INTO key_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","జలె, యేసు జో గుడ్డి మాన్సుచి ఆతు దెర, జా గఁవ్వి తెంతొ ఇదిల్ దూరి కడ నా కెర, జోచ అంకివొతె తుంక్ర, చడ, “తుక కిచ్చొ జలెకు డీస్తయ్ గే?” మెన పుసిలన్, చి ");
INSERT INTO key_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","జో మాన్సు, “మాన్సుల్‍క దెకితసి, గని జేఁవ్ రూకుల్ ఇండితి రితి డీస్తతి” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","జలె, జో మాన్సుచ అంకివొతె యేసు అన్నె చడితికయ్, జో చెంగిల్ దెక, ఎత్కి సొస్టుమ్ దెకిలొ. ");
INSERT INTO key_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ఇసి చెంగిల్ జతికయ్, యేసు జోక, “తుయి గఁవ్వి అన్నె నే పెసితె కి తుచి సొంత గెరి ఉట్ట గో” మెన తెద్రవ దిలన్. ");
INSERT INTO key_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ఒత్త తెంతొ యేసు, జోచ సిస్సుల్ తెన్ కైసరియ పిలిప్పి మెలి ప్రాంతుమ్‍చ గఁవ్విలె ఇండ గెతె తత్తికయ్, “కొన్సొ మెన ప్రెజల్ అంక సంగితతి?” మెన సిస్సుల్‍క పుసిలన్. ");
INSERT INTO key_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","జేఁవ్ జోక “బాప్తిసుమ్ దెతొ యోహాను జా తయెదె మెన సగుమ్‍జిన్ తుక సంగితతి. అన్నె సగుమ్‍జిన్ తుక ‘ఏలీయా పూర్గుమ్‍చొ జా తయెదె’ మెంతతి. అన్నె సగుమ్‍జిన్, ‘దేముడుచి కబుర్ పూర్గుమ్ సంగిలొ అన్నెక్లొ జా తయెదె’ మెన తుక సంగితతి” మెన సిస్సుల్ సంగిల. ");
INSERT INTO key_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ఇసి సంగితికయ్, జో జేఁవ్‍క, “తుమ్, జలె, కొన్సొ మెన అంక సంగితసు?” మెన పుసిలన్. జలె, పేతురు, “తెద్రయిందె మెన దేముడు సంగ తిలొ ‘క్రీస్తు’ మెలొ రచ్చించుప కెర్తొసొ, తుయి” మెన ఒప్పన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","పేతురు ఇసి మెన ఒప్పన్‍తికయ్, యేసు జోక, “అంచి రిసొ తుమ్ చినిలిసి కక్క సంగ నాయ్” మెన జాగర్త సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","“ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ ఒగ్గర్ స్రెమల్ సేడ, వెల్లెల మాన్సుల్‍చి అత్తి, వెల్లెల పూజర్లుచి అత్తి, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తసచి అత్తి, మొరుక అస్సె. గని తిర్రతి గెలె, అన్నె జీవ్ జా ఉట్టుక అస్సె” మెన యేసు జోచ సిస్సుల్‍క బోదన కెరుక దెర్లన్. ");
INSERT INTO key_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","జో ఈంజ కోడ్ ఒండిజిన్‍క సొస్టుమ్ సంగిలన్. దస్సి సంగితికయ్, పేతురు జోక ఏక్ పక్కయ్ కడ నా కెర, “దస్సి సంగు నాయ్. తుక దస్సిచి పోని!” మెన పేతురు జోక గోల కెరుక దెర్లన్. ");
INSERT INTO key_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","పేతురు ఇసి సంగితికయ్, యేసు పస్ల, సిస్సుల్‍క దెక, పేతురుక, “సయ్‍తాన్, అంచి పడ్తొ గో! తుయి దేముడుచి పచ్చెనచి బుద్ది ఉచర్లద్ నాయ్, గని మాన్సుల్ ఉచర్తి రితి ఉచర్లది” మెన యేసు గోల కెర్లన్. ");
INSERT INTO key_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","తెదొడి జోచ సిస్సుల్‍క, ప్రెజల్‍చి జనాబ్‍క, జోచి పాసి బుకారా కెర, యేసు జోవయింక, “కో నంపజా అంచి పట్టి బులుక ఉచరుల గే, జోచి సొంత ఇస్టుమ్ కెరుక ముల దా, జోచి సొంత సిలువ వయన అంచి పట్టి బులుక అస్సె. ");
INSERT INTO key_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","కిచ్చొక మెలె, జోచి సొంత ప్రానుమ్ రచ్చించుప కెరనుక కో కోర్‍ప జవుల గే, జోచి ప్రానుమ్ గెచ్చవానెదె. గని అంచి రిసొ, అంచి సుబుమ్ కబుర్ సూనయ్‍తి రిసొ, కో జోచి ప్రానుమ్ దెతి రితి ఎక్కి మెన్సు నిదానుమ్ ఇండుల గే, జోచి ప్రానుమ్ రచ్చించుప జెయెదె. ");
INSERT INTO key_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","మెలె, ఈంజ లోకుమ్‍తె తిలిసి ఎత్కి కేన్ మాన్సు జవుస్ కలుగు కెరన జోచి ప్రానుమ్ గెచ్చవాన్లెగిన, జోక కిచ్చొ లాబుమ్? కిచ్చొ లాబుమ్ నాయ్. ");
INSERT INTO key_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","మెలె, జో మాన్సుచి ఆత్మ గెచ్చవాన్లెగిన, జోచి ప్రానుమ్ దేముడు తెన్ అన్నె బెదయ్‍తి రితి కేన్ మాన్సు కిచ్చొ దిలె సరిపుచుప జయెదె గే? ");
INSERT INTO key_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","మెలె, గర్చ కమొ కెర్తి ఈంజ పాపుమ్‍చి లంజెచి ఉగుమ్‍తెచి బుద్ది కెరన, అంచి సత్తిమ్ జవుస్, అంచ కొడొచి సత్తిమ్ జవుస్, కో లాజ్ జా నే ఒప్పన్‌తె తవుల గే, ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ పరలోకుమ్‍తె గెచ్చ అబ్బొసి జలొ దేముడుచి పరలోకుమ్‍చి ఉజిడ్‍చి గవురుమ్ తెన్ సుద్ది తిల దూతల్ తెన్ బెద ఈంజ లోకుమ్‍తె అన్నె జెతి దీసిక, జేఁవ్ మాన్సుల్‍క ‘అంచ’ మెన ఒప్పన్‍తి రితి అమ్‍చి తెన్ బెదవనుక అంక లాజు తయెదె.” మెన సిస్సుల్‍క ప్రెజల్‍క యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","జో ఇసి సంగ, “దేముడుచి రాజిమ్ అదికారుమ్ తెన్ జా అస్సె మెన, ఇన్నె టీఁవొ జా తిల సుదల్‍తె సగుమ్‍జిన్ నే మొర్తె అగ్గె దెకుల మెన తుమ్‍క ఆఁవ్ కచితుమ్ సంగితసి” మెన సిస్సుల్‍క ప్రెజల్‍క యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","సొవ్వు దీసల్ గెలి పిమ్మట్, యేసు పేతురుక యాకోబుక, యోహానుక, అన్నె కో నెంజిలి డోంక్ తిలి మెట్టయ్ కడ నిలన్. మెట్టయ్ వెగితికయ్, జేఁవ్‍చి మొక్మె యేసుచి రూపుమ్ మార్సుప జలి. ");
INSERT INTO key_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","జోచ పాలల్ కీసి జల మెలె, ఈంజ లోకుమ్‍తె కేన్ సార్ కేన్ సబ్బు తెద్ది చోక్ కెరుక నెతిర్లి రితి, ఉజిడ్ జా చోక్ జల. ");
INSERT INTO key_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","తెదొడి, పూర్గుమ్‍చ దేముడుచి కబుర్లు సంగిత మోసే చి ఏలీయా దొగుల యేసు తెన్ లట్టబ్తె తా, జేఁవ్ సిస్సుల్‍క డీసన్ సేడ్ల. ");
INSERT INTO key_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","ఇసి జతికయ్, జేఁవ్ సిస్సుల్ బలే బియఁ గెతికయ్, తెదొడి పేతురు, కిచ్చొ మెనుక గే నేన గెచ్చ, యేసుక “గురుబాబు, అమ్ ఇన్నె తంక చెంగిలి. తుక ఏక్, మోసేక ఏక్, ఏలీయాక ఏక్, మొత్తుమ్ తిన్ని కుడియల్ ఇన్నె బందుక అమ్‍క సెలవ్ దే” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","సంగితె తతికయ్, తెదొడి మబ్బు ఏక్ ఉత్ర జా, జోవయింక డంకిలన్, అన్నె, “ఈంజొయి అంచొ పుత్తు, అంచొ ప్రేమ తిలొ పుత్తు. ఇన్నెచి కోడు తుమ్ సూన” మెన, మబ్బు తెంతొ అవాడ్ సంగిలిసి సూన్ల. ఇసి జలి బేగి, ");
INSERT INTO key_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","సిస్సుల్ సుట్టునంత అంకి గలెకి, యేసుక పిట్టవ జో తెన్ అన్నె కో కి డీస్తి నాయ్. ");
INSERT INTO key_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","జేఁవ్ జా మెట్టయ్ తెంతొ ఉత్ర జెతె తతికయ్, “ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ మొర గెచ్చ అన్నె జీవ్ జా ఉట్టితి ఎద, తుమ్ అప్పె ఇన్నె దెకిలిసి కక్క కి సంగ నాయ్” మెన సిస్సుల్‍క యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ఇసి సంగితికయ్, జర్గు జలిస్‍చి రిసొ తుక్లె తా గెల, గని “మొర గెచ్చ అన్నె జితిస్‍చి రిసొ సంగిల్ కోడుక కిచ్చొ అర్దుమ్?” మెన ఉచరంతె తిల. ");
INSERT INTO key_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","తెదొడి జోక కిచ్చొ పుసిల మెలె, “రచ్చించుప కెర్తొసొ జతొ క్రీస్తుచి అగ్గె ఏలీయా పూర్గుమ్‍చొ జెంక అస్సె, మెన మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస కిచ్చొక సంగితతి?” మెన పుసిల. ");
INSERT INTO key_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","యేసు జోవయింక, “ఎత్కి తెయార్ కెర్తి రిసొ ఏలీయా తొలితొ జెంక అస్సె మెలి కోడు సత్తిమ్. జా ఏక్, రచ్చించుప కెర్తొసొ, ఆఁవ్ మాన్సు జా జెర్మిలె ఒగ్గర్ స్రెమల్ సేడుక అస్సె మెన, మాన్సుల్ జోక నిస్కారుమ్ దెకుల” మెన రెగిడ్లిసి కిచ్చొచి రిసొ గే తుమ్ ఉచర. ");
INSERT INTO key_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","అన్నె, జలె ఆఁవ్ తుమ్‍చి తెన్ సంగితిస్ కిచ్చొ మెలె, జో ఏలీయా తొలితొ జా తిలన్ మెన ఆఁవ్ తుమ్‍క కచితుమ్ సంగితసి. జో జా తిలొ, అన్నె జోచి రిసొ రెగిడ్లి కోడు కి నెరవెర్సుప జలి. “జేఁవ్‍చి ఇస్టుమ్ అయ్‍లి రితి మాన్సుల్ జోక కెల మెన రెగిడ్లి కోడు” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","యేసు, జేఁవ్ సిస్సుల్, మెట్టక ఎట్టొ తా గెల సిస్సుల్‍తె పాఁవ కెర, జోవయించొ సుట్టునంత ఒగ్గర్‍జిన్ జనాబ్ బెర అస్తి, చి మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస జోవయింతెన్ గగ్గొల్ జతె అస్తి మెన యేసు ఇసి దెకిలొ. ");
INSERT INTO key_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","జలె, జేఁవ్ జనాబ్ యేసుక దెకిల్ బేగి, ఒగ్గర్ ఆచారిమ్ జా, జోతె నిగ జా జొకర్ల. ");
INSERT INTO key_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","యేసు, జలె, “జోవయింతెన్ కిచ్చొచి రిసొ లట్టబ్తసు?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","జనాబ్‍తె తిలొ ఎక్కిలొ, “గురుబాబు, గుల్లొ కెర్తి బూతుమ్ దెర్లొ అంచొ పుత్తుక తుచితె కడ ఆన్లయ్. ");
INSERT INTO key_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","జా బూతుమ్ జోక కేనె దెరెదె గే, ఒత్త సేడవ దెయెదె. సేడయ్‍లె, ఈంజొ పొగుర్లు బార్ కెరవన, దంతొ చప్ల, మోర్చ సేడుక. ‘జా బూతుమ్‍క ఉదడ దాస’ మెన తుచ సిస్సుల్‍క బతిమాల్ప జా సంగిలే కి, జేఁవ్ నెతిర్ల.” మెన జో నాడుచొ అబ్బొసి సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","తెదొడి యేసు కిచ్చొ జబాబ్ దిలన్ మెలె, “నముకుమ్ నెంజిలి కాలుమ్‍చ, తుమ్! తుమ్‍చి తెన్ ఆఁవ్ కెత్తి దీసల్ తంక? కెత్తి దీసల్ తుమ్‍చి బుద్ది ఆఁవ్ ఓర్సుప జంక? జో నాడుక అంచితె కడ ఆన” మెన సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","నాడుక యేసుతె ఆన్ల. ఆన్‍తికయ్, జా బూతుమ్ యేసుక దెకిలి బేగి, జో నాడుక పొర్లు కెరవ గెల్తికయ్, నాడు బుఁయ్యె సేడ ఎంగ్డ ఎంగ్డ జా పొగుర్లు కెరవన, పొర్లుప జతె తిలన్. ");
INSERT INTO key_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","దస్సి జతె తతికయ్, “ఇన్నెక కెత్తి దీసల్ తెంతొ ఈంజ బాద అస్సె?” మెన యేసు నాడుచొ అబ్బొస్‍క పుసిలన్, చి జో “బాల తతె తెంతొ. బాల తతె తెంతొ దస్సి జా జా, ");
INSERT INTO key_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ఇన్నెక నాసెనుమ్ కెర్తి రిసొ ఒగ్గర్ ఒగ్గర్ సుట్లు ఆగితె పానితె సేడయ్‍లి. తుయి కిచ్చొ జలెకు కెరుక తెర్లెగిన, అమ్‍చి ఉప్పిరి కన్కారుమ్ తిఁయ అమ్‍క తోడ్ కెరు!” మెన సంగ జొకర్తికయ్, ");
INSERT INTO key_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","తెదొడి యేసు జోక, “‘తుయి తెర్లెగిన’ మెంతసి అంక, కిచ్చొక? కో అంక నంపజలొసొక, జోక ఎత్కి జెయిమ్ జయెదె!” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","బేగి నాడుచొ అబ్బొసి, “ఆఁవ్ నంపజతసి. అంచి నముకుమ్ తొక్కి చి జలె, ఒగ్గర్ జతి రితి అంక తోడు తా!” మెన ఏడ కేక్ గలన్. ");
INSERT INTO key_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","తెదొడి ఒగ్గర్‍జిన్ జనాబ్ ఎక్కితె బెద పాసి నిగ జెతతి మెన యేసు దెక కెర, “ఓ గుల్లొ కెర్తి బొయ్‍రొ కెర్తి బూతుమ్. తుయి ఇన్నెక ముల దా, కెఁయ్యఁక కి ఇన్నెక అన్నె దెరు నాయ్ మెన ఆఁవ్ తుక ఆడ్ర దెతసి,” మెన జా బూతుమ్‍క యేసు గోల కెర్తికయ్, ");
INSERT INTO key_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","బూతుమ్ గట్టిఙ కేక్ గల, నాడుక గట్టిఙ పొర్లు కెరవ బార్ జా ముల దిలన్, చి నాడు మొర గెలి రితి జలి. “మొర గెలొ” మెన ఒగ్గర్‍జిన్ సంగిల, ");
INSERT INTO key_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","గని యేసు నాడుక ఆతు దెర ఉట్టయ్‍తికయ్, జో చెంగిల్ జా టీఁవొ జలన్. ");
INSERT INTO key_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","జలె, యేసు గెరి గెచ్చ తెడి పెసితికయ్, జోచ సిస్సుల్, “ఆమ్ కిచ్చొక జా బూతుమ్‍క ఉదడుక నెతిర్లమ్?” మెన కో వేర మాన్సుల్ నే సూన్‍తి రితి యేసుక పుసిల. ");
INSERT INTO key_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","పుసితికయ్, జో “ప్రార్దన కెర్లెకయ్ ఇసిచి ఉదడుక జయెదె, నెంజిలె నాయ్” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","యేసు, సిస్సుల్, ఒత్త తెంతొ బార్ జా గలిలయ ప్రాంతుమ్ వాట్ గెల. ‘ఆమ్ ఇన్నె తిలిసి ప్రెజల్ నేన్‍తు’ మెన గుట్టు తెన్ గెతె తిల. ");
INSERT INTO key_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","కిచ్చొక మెలె, యేసు జోచ సిస్సుల్‍క బోదన కెర్తె తిలొ. “ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొక మాన్సుల్‍చి అత్తి దెర దెవుల, చి అంక మార గెలుల. జేఁవ్ అంక మార గెలె కి, తిర్రత్‍క అన్నె జీవ్ జా ఉట్టిందె” మెలన్. ");
INSERT INTO key_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","గని జో సంగిలిసి అర్దుమ్ నే కెరన్లెకి, పుసుక బియఁ కెర, తుక్లె తిల. ");
INSERT INTO key_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","తెదొడి యేసు, సిస్సుల్, కపెర్నహూమ్ పట్నుమ్‍తె పాఁవ గెరి గెచ్చ తెడి పెసిలి పొది, యేసు జోవయింక “వట్టె ఎక్కిలొ తెన్ ఎక్కిలొ కిచ్చొచి రిసొ వాదెన జతె తిలదు?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","జేఁవ్ తుక్లె తిల. కిచ్చొక మెలె, “అమ్‍చితె కొన్సొ వెల్లొ జయెదె?” మెన జేఁవ్ వట్టె లట్టబన తిల. ");
INSERT INTO key_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","తెదొడి యేసు వెస, జేఁవ్ బారజిన్‍క పాసి బుకారా కెర, జోవయింక, “కొన్సొ జలెకు వెల్లొ జంక ఉచరెదె గే, జో గవురుమ్ నే ఉచరంతె తా, ఎత్కిచి కంట దాక్ కెరన, ఎత్కిజిన్‍క సేవ కెర్తొసొ జంక అస్సె” మెన సంగ, ");
INSERT INTO key_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ఏక్ బాలబోదక దెర, జోవయించి నెడ్‍మె టీఁవొ కెర, ఉక్కుల, జోవయింక అన్నె, ");
INSERT INTO key_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“ఇస బాలబోదల్‍తె ఎక్కిలొక జలెకు కో అంచి నావ్ తెన్ మరియాద కెరుల గే అంకయ్ మరియాద కెర్లి రితి జవుల. అన్నె, అంకయ్ కో మరియాద కెర తవుల గే, ఎక్కి అంకయ్ నాయ్, గని అంక తెద్రయ్‍లొసొకయ్ మరియాద కెర్లి రితి జవుల” మెన యేసు బోదన కెర్లన్. ");
INSERT INTO key_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","తెదొడి యోహాను మెలొ సిస్సుడు యేసుక కిచ్చొ మెన సంగిలన్ మెలె, “గురుబాబు, ఎక్కిలొ తుచి నావ్ తెన్ బూతల్‍క ఉదడ్లిసి దెకిలమ్. జో అమ్‍చి పట్టి జెతొసొ నెంజెచి రిసొ జోక అడ్డు కెర్లమ్” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","జలె యేసు, “జోక అడ్డు కెర నాయ్. కిచ్చొక మెలె, కో జలెకు అంచి నావ్ తెన్ ఏక్ వెల్లి కామ్ కెరెదె గే, జా జర్గు జలి తెంతొ అంచి రిసొ విరోదుమ్ లట్టబుక నెత్రె. ");
INSERT INTO key_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","అమ్‍చి కామ్‍చి ఉప్పిరి విరోదుమ్ నెంజిలొసొ అమ్‍చి పచ్చెన జెతొసొ జయెదె. ");
INSERT INTO key_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","“ఆఁవ్ క్రీస్తు జలొసొ తెన్ తుమ్ బెదిలి రిసొ, కో జలెకు తుమ్‍క బుక్కెక్ పాని జలెకు దెయెదె గే, జో దస్సి కెర్లి రిసొ కచితుమ్ జోక బవుమానుమ్ పిట్టె నాయ్, మెన తుమ్‍క ఆఁవ్ కచితుమ్ సంగితసి. ");
INSERT INTO key_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“గని అంక నంపజల ఇస బాలబోదల్ రిత జలసతె ఎక్కిలొక కి, కో పాపుమ్ కెరవుల గే, జోక జెతికయ్ సిచ్చచి కంట, జోక టొట్రయ్ తిర్వేలి రితొ వెల్లొ పత్తురు ఒడొవ దా, సముద్రుమ్‍తె బుడ్డవన్కయ్ జోక చెంగిలి. ");
INSERT INTO key_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","తుమ్‍చితె ఎక్కిలొచొ ఆతు జలెకు జోక పాపుమ్ కెరవ తిలెగిన, జో ఆతు జో కండన గెలి రితి జవుస్. కిచ్చొక మెలె, దొన్ని అత్తొ తెన్ తా వెల్లి ఆగి గొయ్‍తె, కెఁయఁక నే విజయ్‍తి ఆగితె, గలి జతి కంట, పాపుమ్ కెరయ్‍తొ ఆతు జలెకు నెంజిలి రితి జా పరలోకుమ్‍తె బెదుక చెంగిలి. ");
INSERT INTO key_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","45","దస్సి, తుమ్‍చితె ఎక్కిలొచొ చాటు జలెకు జోక పాపుమ్ కెరవ తిలెగిన, జో చాటు కండన గెలి రితి జవుస్. కిచ్చొక మెలె, దొన్ని చట్టొ తెన్ తిలి రితి తా వెల్లి ఆగి గొయ్‍తె గలి జతి కంట, పాపుమ్ కెరయ్‍తి చాటు జలెకు నెంజిలి రితి జా పరలోకుమ్‍తె బెదుక చెంగిలి. ");
INSERT INTO key_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","47","తుమ్‍తె ఎక్కిలొచి అంకి జలెకు జోక పాపుమ్ కెరవ తిలెగిన, జా అంకి కడ వెంట గెలి రితి జవుస్. కిచ్చొక మెలె, దొన్ని అంకివొ తెన్ తిలి రితి తా వెల్లి ఆగి గొయ్‍తె గలి జతి కంట, ఎక్కి అంకి తెన్ జలి రితి జా దేముడుచి రాజిమ్‍తె బెదుక చెంగిలి. ");
INSERT INTO key_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","వెల్లి ఆగి గొయ్‍తె కిఁవ్వొ మొర్తి నాయ్, చి జా ఆగి విజె నాయ్. ");
INSERT INTO key_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“‘సుద్ది జవుస్’ మెన బలి దెతి ఎత్కితె లోన్ దెరవుక అస్సె. దస్సి, లోన్‍క, ఆగిక మెలి రితి, ఎత్కి మాన్సుక సుద్ది నిదానుమ్ కెరుక అస్సె. ");
INSERT INTO key_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“లోన్ చెంగిలిచి. గని జా లోన్‍చి కారు గెచ్చ చప్పయ్ జలెగిన, జా అన్నెక్ సుట్టు కీసి కెర కారు కెరుక జయెదె! నెంజె. తూమ్, జలె, తుమ్‍చి పెట్టి లోన్ దెర్లి రితి జా, చి ఎక్కిలొ తెన్ ఎక్కిలొ సేంతుమ్ తెన్ తా” మెన సిస్సుల్‍క యేసు బోదన కెర్లన్. ");
INSERT INTO key_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","యేసు కపెర్నహూమ్ పట్నుమ్ తెంతొ ముల దా యూదయ ప్రదేసిమ్ వాట్ గెచ్చ, యోర్దాను గాడు ఒత్తల్‍తొ ఉట్ట గెలన్. ఒత్త తతికయ్, ఒగ్గర్‍జిన్ జనాబ్ అన్నె జోతె బెర జెతికయ్, జో అలవాట్ జలి రితి జోవయింక బోదన కెరుక దెర్లన్. ");
INSERT INTO key_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","జా పొది, పరిసయ్యుల్ సగుమ్‍జిన్ జోక పరిచ్చ కెర తెర్లె నింద కెరుక మెన, జోతె జా కెర, “మున్సుబోద జోచి తేర్సిక ములుక నాయిమ్ గె?” మెన పుసిల. ");
INSERT INTO key_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","యేసు “మోసే పూర్గుమ్‍చొ తుమ్‍క కిచ్చొ ఆడ్ర దిలన్?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ఈంజొ ఇసి సంగితికయ్, జేఁవ్ “ముల దెతి కాగ్తుమ్ రెగ్డ దిలెగిన ముల దెంక జయెదె మెన మోసే పూర్గుమ్‍చొ సెలవ్ దిలన్” మెన జబాబ్ దిల. ");
INSERT INTO key_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","జలె, యేసు జోవయింక, “తుమ్ రాడ్ జీవ్‌చ మాన్సుల్‍చి రిసొ మోసే జా ఆగ్న రెగిడ్లన్. ");
INSERT INTO key_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","గని లోకుమ్ జెర్మయ్‍లి మొదొల్ పొది తెంతొ ‘మున్సుబోద తేర్‍బోద’ మెన దేముడు దొన్ని రగల్ జర్గు కెర్లొ” మెన, అన్నె ");
INSERT INTO key_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“జాకయ్ మున్సుబోద అయ్యస్అబ్బొస్‍క ముల దా జోచి తేర్సి తెన్ బెద తంక అస్సె. ");
INSERT INTO key_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","అన్నె జేఁవ్ దొగుల ఎక్కి ఆఁగ్ జాఁ తవుల మెన దేముడు రెగ్డయ్‍లి కోడు అస్సె. జాచి రిసొ, పెండ్లి జలి తెంతొ జేఁవ్ దొగుల నెంజితి. ఎక్కి ఆఁగ్ జా అస్తి. ");
INSERT INTO key_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","జాకయ్, దేముడు పెండ్లితె కక్క జట్టు కెరవ తయెదె గే, కేన్ మాన్సు ములవుక జయె నాయ్” మెన జేఁవ్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","యేసు, సిస్సుల్, జేఁవ్ బస జతి గెరి గెచ్చ తెడి పెసిలి పడ్తొ, ఈంజ కోడుచి రిసొ సిస్సుల్ అన్నె పుసిల. ");
INSERT INTO key_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","యేసు సిస్సుల్‍క, “కో జలెకు జోచి తేర్సిక ముల దా అన్నెక్లిక పెండ్లి కెరనెదె గే, జో లంజె వంసుమ్‍చొ జా తేర్సిక లంజె కెర్తయ్, ");
INSERT INTO key_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","అన్నె, మున్సుస్‍క తేర్సి ముల దా అన్నెక్లొక పెండ్లి కెరన్లెగిన, జయ్యి లంజె జతయ్” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ఒత్త తిలి పొది, ‘అమ్‍చ బోదల్‍క చడ చెంగిల్ జవుస్’ మెన, సగుమ్‍జిన్ జోవయింక యేసుచి పాసి కడ ఆన్‍తికయ్, సిస్సుల్, “పోన” మెన కడ ఆన్లసక గోల కెర్ల. ");
INSERT INTO key_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","గని జేఁవ్ గోల కెర్లిసి యేసు దెక, బాద సేడ, “బోదల్ అంచితె జెతు. జోవయింక అడ్డు కెర నాయ్. దేముడుచి రాజిమ్ ఇస బాలబోదల్ జల సుదల్‍చియి. ");
INSERT INTO key_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","తుమ్‍క ఆఁవ్ కిచ్చొ కచితుమ్ సంగితసి మెలె, గవురుమ్ నే ఉచరంతె బాలబోదల్‍చి రితిచి నముకుమ్ తెన్ దేముడుచి రాజిమ్‍తె బెదితి రితి నఙన్లెకయ్, పరలోకుమ్‍తె గెచ్చుక జయెదె. ఇసి నే జలెగిన, కో కి ఒత్త బెదుక జయె నాయ్” మెన సంగ ");
INSERT INTO key_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","జేఁవ్ బోదల్‍క ఉక్కుల దెర, జోవయింక ఎక్కెక్లక బోడి చడ, ‘చెంగిల్ తత్తు’ మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","యేసు అన్నె బార్ జా వట్టె గెతె తతికయ్, ఉబెడొ ఎక్కిలొ నిగ జా, యేసుచి పుర్రెతొ సెర్ను సేడ జొకర, “చెంగిల్ తిలొ గురుబాబు, పరలోకుమ్‍చి రాజిమ్‍తె కెఁయఁక తెఁయఁక జితి వాట, అంక దొర్కు జంక మెలె, ఆఁవ్ కిచ్చొ కెర్లె జయెదె?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","పుసితికయ్, యేసు, “చెంగిల్ తిలొసొ మెన అంక కిచ్చొక సంగిలది? దేముడు ఎక్కిలొయి చెంగిలొసొ, గని అన్నె కో కి చెంగిలస నెంజితి. ");
INSERT INTO key_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","జో దిల ఆగ్నల్ మెలె, తుయి జాన్సి. ‘నరు అత్య కెరుక జయె నాయ్, లంజెకమొ కెరుక జయె నాయ్, చోరుక జయె నాయ్, అబద్దుమ్ సాచి సంగుక జయె నాయ్, మోసిమ్ కెరుక జయె నాయ్, అయ్యద్‍అబ్బొద్‍క గవురుమ్ దెకితె తంక అస్సె’ దసచయ్” మెన జోక యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","జో మాన్సు, “గురుబాబు, బాల తెంతొ ఈంజేఁవ్ ఆగ్నల్ రితి నిదానుమ్ కెర దెకన్‍తసి” మెన జబాబ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","యేసు జోక దెక కన్కారుమ్ జా, “తుక ఎక్కి పిట్ట గెచ్చ అస్సె. తుయి గెచ్చ, తుచి ఆస్తి ఎత్కి విక గెల కెర, బీద సుదల్‍క దేసు. దస్సి కెర్లెగిన, పరలోకుమ్‍తె తుక ఆస్తి కలుగు జెయెదె. అన్నె, అంచి తెన్ బెద, అంచి పట్టి జే!” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","జలె, జో ఉబెడొక ఒగ్గర్ సొమ్సారుమ్‍చి రిసొ, దుకుమ్ జా మొకొమ్ ఇదిలిసి కెర ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","జో సొమ్సారుమ్‍చొ ఉట్ట గెతికయ్, యేసు పస్ల సిస్సుల్‍క దెక జోవయింక, “సొమ్సార్లు దేముడుచి రాజిమ్‍తె బెదుక జలె, కస్టనె జలెకయ్ జయెదె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","జోచ ఈంజేఁవ్ కొడొక సిస్సుల్ ఎదివాట్ ఆచారిమ్ జతికయ్, జోవయింక అన్నె, “ఓ పుత్తర్లు, ఈంజ లోకుమ్‍తెచి ఆస్తిక నముకుమ్ తిల సుదల్ దేముడుచి రాజిమ్‍తె బెదుక కెద్ది కస్టుమ్! ");
INSERT INTO key_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ఇసొ సొమ్సారి దేముడుచి రాజిమ్‍తె బెదితి కంట, సూజిబొరొ వాట్ ఒంటె గెచ్చుక సుల్లు!” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","జేఁవ్ ఎదివాట్ ఆచారిమ్ జా, “దస్సి జలె, కో రచ్చించుప జంక జయెదె?” మెన జోక పుసిల. ");
INSERT INTO key_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","యేసు జోవయింక దెక, “మాన్సు ఈంజ కెర్క నెత్తిర్లిసి, గని దేముడు జా ఎత్కి జర్గు కెరుక తెరె.” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","జలె, పేతురు జోక, “ఈందె, ఆమ్ ఎత్కి ముల దా తుచి పట్టి బులితసుమ్” మెన సంగుక దెర్లన్. ");
INSERT INTO key_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","జలె యేసు జోవయింక, “తుమ్‍క ఆఁవ్ కిచ్చొ కచితుమ్ సంగితసి మెలె, అంచి రిసొ, అంచి సుబుమ్ కబుర్‌చి రిసొ, గేరు జలెకు, అన్నొబావొక జలెకు, బయిబేనిక జలెకు, అయ్యస్అబ్బొస్‍క జలెకు, బోదల్‍క జలెకు, బుఁయి జలెకు, కో ముల తవుల గే, ");
INSERT INTO key_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","అప్పె ఈంజ లోకుమ్‍తె కి, జోవయింక గెరలు, అన్నొబావొ, బయిబేని, అయ్యసిఁసి, బోదల్, బుఁయి, దసచ ఎత్కి జోవయింక దొర్కు జయెదె. అన్నె, జెతి కాలుమ్‍తె, కెఁయఁక తెఁయఁక పరలోకుమ్‍తె జితి వాట జోవయింక దొర్కు జయెదె. ");
INSERT INTO key_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","గని తుమ్ జాగర్త ఉచరన. అప్పె అగ్గె జలస ఒగ్గర్‍జిన్ పడ్తొ జవుల. అప్పె పడ్తొ జలస ఒగ్గర్‍జిన్ అగ్గె జవుల” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","యేసు, సిస్సుల్, యెరూసలేమ్ పట్నుమ్‍తె గెతి రిసొ వట్టె గెతె తతికయ్, యేసు దయిరిమ్ తెన్ జోవయించి అగ్గెతొ ఇండిలిసి సిస్సుల్ దెక, బలే బమ్మ జల. జోచి పడ్తొ గెతె తిలసక కి బలే బిడ్కి దెర గెలి. జలె, యేసు సిస్సుల్‍క అన్నె పాసి కెరన, జోక జర్గు జంక తిలస్‍చి రిసొ జోవయింక అన్నె సంగుక దెర, ");
INSERT INTO key_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“ఈందె సూన, అమ్ యెరూసలేమ్‍తె గెతసుమ్. ఒత్త గెలమ్ మెలె, ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొక వెల్లెల పూజర్లుతె, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తసతె దెర దెవుల, చి జేఁవ్ వెల్లెల మాన్సుల్ అంక మొర్తి సిచ్చ వయడ దా, యూదుల్ నెంజిల అదికారుల్‍తె అంక సొర్ప కెర దెవుల. ");
INSERT INTO key_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","దస్సి కెర్లె, జేఁవ్ అంక కొంకడ, తుంక్ర దా, కొర్డల్ తెన్ పెట కెర, అంక మారుల. మార్లె కి, తిర్రత్‍క అన్నె జీవ్ జా ఉట్టిందె” మెన యేసు సిస్సుల్‍క అన్నె సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","తెదొడి యాకోబు, యోహాను మెల జెబెదయి మెలొసొచ దొగుల పుత్తర్సుల్ పుర్రెతొ జా, యేసుక “గురుబాబు, కిచ్చొ అమ్ నఙుమమ్‍దె గె అమ్‍క దెంక.” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ఇసి సంగితికయ్ యేసు “ఆఁవ్ తుమ్‍క కిచ్చొ జర్గు కెరుక మెన తుమ్ కోర్‍ప జతసు?” మెన పుసితికయ్, ");
INSERT INTO key_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","జేఁవ్ జోక, “తుచి పరలోకుమ్‍చి ఉజిడ్‍చి రాజిమ్‍తె తుయి ఏలుప కెర్తి పొదిక అమ్ దొగుల, తుచి ఉజెతొ పక్క ఎక్కిలొ, తుచి డెబ్రి పక్క ఎక్కిలొ వెసితి రితి అమ్‍క సెలవ్ దే” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","యేసు జలె, జోవయింక, “తుమ్ కిచ్చొ పుసితసు గే తుమ్ నేన్సు. అల్లె, అంచి గిన్నతె బెద పిలి రితి, ఆఁవ్ సేడుక తిలి దుకుమ్‍తె బెదుక ఓర్సుప జంక జలెకు, అంచి తెన్ అంచి బాప్తిసుమ్ నఙన్లి రితి జా, ఆఁవ్ సేడుక తిలి స్రెమతె బెదుక జలెకు తెరితె గే?” మెన జేఁవ్ దొగులక సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","జేఁవ్ ‘తెరుమ్’ మెన సంగిల. దస్సి సంగితికయ్, యేసు జోవయింక, “ఆఁవ్ పితి గిన్న దుకుమ్ తుమ్ పిస్తె. ఆఁవ్ స్రెమల్ సేడ్తి బాప్తిసుమ్ తూమ్ కి నఙన్‍తె, ");
INSERT INTO key_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","గని అంచి ఉజెతొ పక్క ఎక్కిలొ, అంచి డెబ్రి పక్క ఎక్కిలొ వెసుక మెన సెలవ్ దెంక అంచి అత్తి నాయ్. పరలోకుమ్ తిలొ అంచొ దేముడు అబ్బొ కక్క కక్క సెలవ్ దా తయెదె గే, జెఁవ్వి ఒత్త వెసుల.” మెన జబాబ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","జలె, యాకోబు యోహాను ఎత్కిచి కంట వెల్లొ జంక ఉచర్లిసిచి రిసొ సేంసిల దెస్సుజిన్ సిస్సుల్ సూన కెర, జోవయించి ఉప్పిరి కోపుమ్ జంక దెర్ల. ");
INSERT INTO key_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","తెదొడి యేసు జేఁవ్ బారజిన్ సిస్సుల్‍క జోతె బుకారా కెర, “యూదుల్ నెంజిల వేర అదికారుల్ అన్నె జోవయించి తెడి తిల వెల్లెల మాన్సుల్ సొంత గవురుమ్ ఉచరన, ప్రెజల్‍క జాడ్లు వయడ్లి రితి జోవయింక పోటి తెన్ ఏలుప కెర్తతి మెన తుమ్ జాన్సు. ");
INSERT INTO key_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","గని తుమ్‍చి తెన్ దస్సి తంక జయె నాయ్. తుమ్‍చితె కో వెల్లొ జంక ఉచరెదె గే, జొయ్యి తుమ్‍చొ సేవ కెర్తొసొ జా తంక. ");
INSERT INTO key_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","తుమ్‍చితె కో ముక్కిమ్ జంక ఉచరెదె గే, జో ఎత్కిజిన్‍క గొతిమాన్సు జా తంక. ");
INSERT INTO key_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","కిచ్చొక మెలె, ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ కి మాన్సుల్‍చి అత్తి సేవ కెరవన్క జెయ్యి నాయ్, గని మాన్సుల్‍క ఆఁవ్ సేవ కెరుకయ్ అయ్‍లయ్. మెలె, ఒగ్గర్‍జిన్ మాన్సుల్‍క సయ్‍తాన్‍చి రాజిమ్ తెంతొ అన్నె గెనన్‍తి రిసొయి మొర అంచి ప్రానుమ్ దెంక అస్సెచి రిసొ ఈంజ లోకుమ్‍తె అయ్‍లయ్” మెన సిస్సుల్‍క యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ఒత్త తెంతొ యేసు సిస్సుల్ వట్టె గెచ్చ గెచ్చ యెరికో పట్నుమ్‍తె జా కెర, సిస్సుల్ తెన్ కి, ఒగ్గర్ ఒగ్గర్‍జిన్ జనాబ్ తెన్ కి ఒత్త తెంతొ బార్ జతె తతికయ్, తీమయిచొ పుత్తుసి, బర్తిమయి బిచ్చిమ్ నఙితొ గుడ్డి జలొసొ, వాట్ సొడి పెస అస్సె. ");
INSERT INTO key_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ఒత్త వెస తా, “జెతొసొ నజరేతు గఁవ్విచొ యేసు” మెన జో సూన కెర, “ఓ యేసుప్రబు, దావీదు రానొచి సెకుమ్‍తె జెర్మిలొ రచ్చించుప కెర్తొసొ, అంచి ఉప్పిరి కన్కారుమ్ తిఁయ, అంక చెంగిల్ కెరు!” మెన కేక్ గలన్. ");
INSERT INTO key_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","జలె, పాసి తిలస ఒగ్గర్‍జిన్ “తుక్లె తా” మెన గోల కెర్లె కి, జో గుడ్డి మాన్సు అన్నె, “దావీదుచి సెకుమ్‍తె జెర్మిలొ రచ్చించుప కెర్తొసొ, అంచి ఉప్పిరి కన్కారుమ్ తిఁయ, అంక చెంగిల్ కెరు!” మెన అగ్గెచి కంట గట్టిఙ కేకుల్ గలొ. ");
INSERT INTO key_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ఇసి జతికయ్, యేసు టీఁవొ జా కెర, “జోక ఇత్తల్‍తొ బుకారా” మెన సిస్సుల్‍క సంగిలన్. జేఁవ్, జలె, “అల్లె, దయిరిమ్ జా ఉట్టు! యేసు తుక బుకార్తయ్” మెన జో గుడ్డి మాన్సుక బుకార్తికయ్, ");
INSERT INTO key_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","జో చట్కున ఉట్ట జోచి దుప్పటి పక్కయ్ వెంట గల, యేసుతె అయ్‍లొ. ");
INSERT INTO key_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","యేసుతె జెతికయ్, “ఆఁవ్ తుక కిచ్చొ కెరుక మెన తుయి కోర్‍ప జతసి?” మెన పుసితికయ్, జో గుడ్డి మాన్సు, “గురుబాబు. ఆఁవ్ దెకిత్ రితి కెరు.” మెన సంగిలొ. ");
INSERT INTO key_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","జలె, యేసు జోక “గో, అంచి ఉప్పిర్‍చి తుచి నముకుమ్ తుక చెంగిల్ కెర అస్సె.” మెన సంగిలన్. బేగి, జో మాన్సుచ అంకివొ డీసిల, చి జో యేసుచి పట్టి వట్టె గెలొ. ");
INSERT INTO key_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","యేసు సిస్సుల్ తెన్ వట్టె గెచ్చ గెచ్చ, యెరూసలేమ్ పట్నుమ్‍క పాసి అయ్‍లి పొది, బేత్పగే బేతనియ మెంత గాఁవిలెచి పాసిచి ఒలీవ మెట్టయ్ పాఁవిలి పొది, యేసు జోచ సిస్సుల్‍తె దొగులక బుకారా, ");
INSERT INTO key_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“తుమ్‍చి మొక్మె తిలి గఁవ్వి గెచ్చ పెస, చి బేగి బంద తిలి గాడ్దె పిల్ల ఏక్ డీసెదె. జాచి ఉప్పిరి కేన్ మాన్సు కెఁయఁ కి వెసుక నేతయ్. జాక యిప కెర ఉదడ ఆన. ");
INSERT INTO key_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","కొన్సొ జలెకు తుమ్ కిచ్చొక దస్సి కెర్తసు?” మెన సంగిలెగిన, “ఇన్నెతెన్ ప్రబుక కామ్ అస్సె. కామ్ జలి బేగి ఇత్తల్‍తొ అన్నె బే బేగి తెద్రయెదె, మెన సంగ” మెన సిస్సుల్‍క యేసు సంగ, తెద్రయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","జలె, జో సంగిలిస్‍తె జేఁవ్ గెతికయ్, ఏక్ వీదె ఏక్ గుమ్ముమె బంద తిలి ఏక్ గాడ్దె పిల్ల జోవయింక డీసిలి. ");
INSERT INTO key_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","జేఁవ్ జాక యిపితె తతికయ్, జా వీదె టీఁవొ జా తిల మాన్సుల్, “తుమ్ కిచ్చొక జా గాడ్దె పిల్లక యిపితసు?” మెన జోవయింక పుసిల. ");
INSERT INTO key_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","జేఁవ్ పుసితికయ్, యేసు సంగిలి రితి సిస్సుల్ సంగిల. జేఁవ్ మాన్సుల్, “దస్సి జలె, దెర గెచ్చ!” మెన సెలవ్ దిల. ");
INSERT INTO key_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","సిస్సుల్ జా గాడ్దె పిల్లక యేసుతె ఉదడ ఆన, జోవయించ దుప్పట్లు గట్ర గాడ్దెచి ఉప్పిరి గలిల, చి యేసు వెగ వెసిలన్. ");
INSERT INTO key_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","పిమ్మట్ ఒగ్గర్‍జిన్ మాన్సుల్ జోవయించ దుప్పట్లు గట్ర వటె వటె అంతిర్ల. అన్నె సగుమ్‍జిన్ వాట్ సొడిచ బట్టిలె తిల చెట్లె కండిల రొడ్డల్ మట్టల్ ఆన, వట్టె అంతిర్ల. ");
INSERT INTO key_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","దస్సి అంత్ర అంత్ర, పుర్రెతొ గెతస పడ్తొ గెతస “జొఒర, జొఒర!” మెలి అర్దుమ్ తెన్ “ఓసన్న, ఓసన్న!” మెన, “దేముడు ప్రబుచి నావ్ తెన్ జెతొసొక ఓసన్న! ");
INSERT INTO key_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","అమ్‍చొ దావీదు పూర్గుమ్‍చొ తెన్ మొదొల్ జలి రాజిమ్ ముక్కిమ్ జా అన్నె బార్ జతిస్‍క జొఒర! ఎత్కిచి కంట ఉప్పిర్‍చి టాన్‍తె తిలొసొక ఓసన్న!” మెన కేకుల్ గల్తె తిల. ");
INSERT INTO key_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","జలె, యేసు యెరూసలేమ్‍తె పాఁవ, దేముడుచి గుడితె గెచ్చ, పెస, సుట్టునంత అంకి గల, ఎత్కి దెక, సాంజ్ జలి రిసొ అన్నె బార్ జా, బారజిన్ సిస్సుల్ తెన్ బేతనియ గఁవ్వి అన్నె ఉట్ట గెల. ");
INSERT INTO key_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","అన్నెక్ దీసి, జేఁవ్ బేతనియ గఁవ్వి తెంతొ యెరూసలేమ్‍తె అన్నె గెతె తత్తికయ్, యేసుక చూ కెర్లి. ");
INSERT INTO key_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","జలె అక్డల్ తిలి ఏక్ అంజూరుమ్ రూకుక దెకిలన్. జలె, జో రూక్‍తె పండ్లు దెర అస్తి గే నాయ్ గే మెన దెకుక గెలొ. అక్కుడ్‍లీ గని అన్నె కిచ్చొయ్ నాయ్. కిచ్చొక మెలె, జా రూక్‍తె జా కాలుమ్ పండ్లు దెర్తి నాయ్. ");
INSERT INTO key_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","యేసు జలె, జో రూకుక, “అప్పె తెంతొ తుచి తెంతొ కో కి పండ్లు కతు నాయ్” మెన రూకుక సంగిలన్. జో సంగిలిసి జోచ సిస్సుల్ సూన్ల. ");
INSERT INTO key_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","తెదొడి జేఁవ్ యెరూసలేమ్‍తె పాఁవ కెర, యేసు దేముడుచి గుడితె పెస, దేముడుచి గుడిచి తెడి కిచ్చొ కిచ్చొ వికితసక గెంతసక దెక, జోవయింక ఉదడుక దెర, డబ్బుల్ పల్టయ్‍తసచ బల్లల్, అర్పితుమ్ దెత పార్వ పిట్టల్ వికితసచ బల్లల్ సేడవ దా, ");
INSERT INTO key_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","కో కి, కిచ్చొ కి దేవులుమ్ వాటు వయ నెంక కి ఒప్పె నాయ్. ");
INSERT INTO key_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","దస్సి కెర తా, “‘దేసిమ్‍లు ఎత్కిచ మాన్సుల్ అంచితె జెతి రితి, అంచి గేరు ప్రార్దన కెర్తి గేరు జా, దస్సే తవుస్.’ మెన దేముడుచి కొడొతె రెగ్డవ అస్సె. తూమ్ జలె, జాక చోర్లు జితొ గేరు జతి రితి ఈంజొ దేముడుచి గుడిక మార్సుప కెర అస్సుస్” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","వెల్లెల పూజర్లు, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస సూన కెర, పిమ్మట్ జొయ్యి కెర్తి బోదనక సర్ద తెన్ సూన ప్రెజల్ ఎత్కిజిన్ ఆచారిమ్ జతతి మెన దెక, జో యేసు వెల్లొ జయెదె మెన బియఁ కెర, “జోక కీసి మారుమ” మెన కుట్ర ఉచరన్ల. ");
INSERT INTO key_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","సాంజ్ జతికయ్, యేసు పట్నుమ్ తెంతొ అన్నె బార్ జలొ. ");
INSERT INTO key_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","పెందలె, యేసు సిస్సుల్ అన్నె యెరూసలేమ్‍తె గెతె తతికయ్, వట్టె జో అంజూరుమ్ పండ్లు రూకుక దెకిలె, చెర్రొ తెంతొ మొదొల్ జా ఒండి సుకా గెచ్చ అస్సె. ");
INSERT INTO key_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","సుకాగెలిస్ దెక, జో రూకుక యేసు సంగిలి కోడు ఏదస్ట కెర, పేతురు, “గురుబాబు, ఆదె! తుయి సాపెన దిలొ రూకు సుకా గెచ్చ అస్సె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","యేసు సిస్సుల్‍క దెక కిచ్చొ సంగిలన్ మెలె, “దేముడుచి ఉప్పిరి తుమ్ నముకుమ్ తియన. ");
INSERT INTO key_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","తుమ్‍క ఆఁవ్ కిచ్చొ కచితుమ్ సంగితసి మెలె, ఈంజ మెట్టక జవుస్ దెక, ‘ఓ మెట్ట, ఉట్కి జా సముద్రుమ్‍తె గలి జా’, మెన పెట్టితె కిచ్చొ అన్మానుమ్ నెంతె తా, పూర్తి నంపజా నెరవెర్సుప జయెదె మెన, కొన్సొ జలెకు సంగెదె గే, జయ్యి జోచి రిసొ ప్రబు జర్గు కెరెదె మెన తుమ్‍క ఆఁవ్ కచితుమ్ సంగితసి. ");
INSERT INTO key_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","జాకయ్ తుమ్‍క ఆఁవ్ కిచ్చొ మెంతసి మెలె, ప్రార్దన కెర్తె పొది తుమ్ కిచ్చొ సంగిలే కి, ‘జా అమ్‍క దొర్కు జలి’ మెన తుమ్ నంపజా, చి కచితుమ్ తుమ్‍క దొర్కు జయెదె. ");
INSERT INTO key_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","గని ప్రార్దన కెర్తె పొది తుమ్‍క కిచ్చొ బుద్ది తంక మెలె, తుమ్‍తె ఎక్కిలొ అన్నెక్లొక కిచ్చొ జవుస్ అల్లర్ కెర తిలెగిన, అల్లర్ కెర్లొసొక, జో అల్లర్ సేడ్లొసొ చెమించుప కెరుక అస్సె. తుమ్ దస్సి ఎక్కిలొక ఎక్కిలొ చెమించుప కెర్లె, పరలోకుమ్ తిలొ తుమ్‍చొ అబ్బొ జలొ దేముడు తుమ్‍క చెమించుప కెరెదె. ");
INSERT INTO key_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","తుమ్ అన్నెక్లొ మాన్సుల్‍క చెమించుప నే కెర్లెగిన, దస్సి పరలోకుమ్ తిలొ అబ్బొ జలొ దేముడు తుమ్‍క చెమించుప కెరె నాయ్” మెన యేసు సికడ్లన్. ");
INSERT INTO key_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","జలె, యెరూసలేమ్‍తె అన్నె పాఁవిలి. యేసు దేముడుచి గుడితె అన్నె గెచ్చ ఒత్త బుల్తె తతికయ్, వెల్లెల పూజర్లు, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస, అన్నె సగుమ్‍జిన్ వెల్లెల మాన్సుల్ కి, జోతె జా కెర, ");
INSERT INTO key_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“తుయి కెర్త కమొ కెరుక, తుయి బోదన కెరుక తుక కిచ్చొ అదికారుమ్ అస్సె? కొన్సొ తుక అదికారుమ్ దిలన్?” మెన జోక పుసిల. ");
INSERT INTO key_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","జాకయ్ యేసు జోవయింక, “ఆఁవ్ కి తుమ్‍క ఏక్ కోడ్ పుసిందె. తుమ్ చెంగిల్ జబాబ్ సంగిలె, ఆఁవ్ కిచ్చొ అదికారుమ్‍క ఇసి కెర్తసి గే, ఆఁవ్ కి తుమ్‍క సంగిందె. ");
INSERT INTO key_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","జలె, యోహాను బాప్తిసుమ్ దెతె తిలిస్‍చి అదికారుమ్ కేనె తెంతొ చి? పరలోకుమ్ తెంతొ చి గే, మాన్సు తెంతొ చి గే, తుమ్ సంగ” మెన వెల్లెల మాన్సుల్‍క యేసు పుసిలన్. ");
INSERT INTO key_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","దస్సి పుసితికయ్, జేఁవ్ వెల్లెల మాన్సుల్ కీసి జల మెలె, ఎక్కిలొ తెన్ ఎక్కిలొ బమ్మ తెన్ లట్టబన, ఇసి మెంతె తిల, “‘పరలోకుమ్ తెంతొ చి’ మెన అమ్ సంగిలెగిన, దస్సి జలె, తుమ్ కిచ్చొక జోక నంప కెర్సు నాయ్?” మెన అమ్‍క సంగెదె. ");
INSERT INTO key_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","“‘మాన్సు తెంతొ చి’ మెన సంగుక నెంజె” మెన ఉచర్లస. కిచ్చొక మెలె, ‘యోహాను నిజుమి దేముడుచి కబుర్ ఆన్లొసొ’ మెన ప్రెజల్ ఎత్కిజిన్ నంపజా అస్తి మెన జేఁవ్ వెల్లెల మాన్సుల్ ప్రెజల్‍క బితె తిల. ");
INSERT INTO key_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","జాచి రిసొ “నేనుమ్” మెన జబాబ్ సంగిల. జేఁవ్ దస్సి సంగితికయ్, యేసు జోవయింక “దస్సి జలె, కేన్ అదికారుమ్‍క ఆఁవ్ అంచ కమొ కెర్తసి గే, ఆఁవ్ తుమ్‍క సంగి నాయ్” మెన సంగ ముద్దొ కెర్లన్. ");
INSERT INTO key_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","తెదొడి యేసు వెల్లెల మాన్సుల్‍క దస్సి సంగ, జోవయింక టాలివొ సంగ అన్నె బోదన కెరుక దెర్లన్. తెదొడి కిచ్చొ టాలి ఏక్ సంగిలన్ మెలె, ఇసి జతయ్; “ఏక్ మాన్సు ద్రాచ తోట రోవడ కెర, జాచి సుట్టునంత కోట గలవడ కెర, ద్రాచ రస్సుమ్ కడ గన్న వెల్లొ పత్తుర్ కూనవ కెర, తోట రకితి మాటు రితిసి బందవ కెర, రకితసక నిసాన, జోవయింక జా తోట గుత్త దా, వేరతె ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“పంటొ పికిలి పొది, జేఁవ్ గుత్త నఙిలసతె జా తోటచి పంటొ ఏక్ వాట నఙ ఆన్‍తి రిసొ, గొత్తి సుదొ ఎక్కిలొక ఎజొమాని తెద్రయ్‍లన్. జో ఒత్త పాఁవితికయ్, ");
INSERT INTO key_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","గుత్త నఙిల జేఁవ్ రకిత మాన్సుల్ జో గొత్తి సుదొక దెర, పెట, కిచ్చొ నే దెతె ఉదడ్ల. ");
INSERT INTO key_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ఒత్త తెంతొ, అన్నెక్లొ గొత్తి సుదొక జో ఎజొమాని తెద్రయ్‍లన్, గని జేఁవ్ రకితస జోచి బోడి పెట కెర దా, మరియాద నెంతె జోక ఉదడ గెల. ");
INSERT INTO key_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","పిమ్మట్ అన్నెక్లొక ఎజొమాని తెద్రయ్‍తికయ్, జేఁవ్ రకితస జోక మార గెల. అన్నె ఒగ్గర్‍జిన్‍క తెద్రయ్‍తికయ్, జోవయింతె సగుమ్‍జిన్‍క పెట గెల, సగుమ్‍జిన్‍క మార గెల. ");
INSERT INTO key_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“జలె, జో ఎజొమానిక అన్నెక్లొ తిలన్, కొన్సొ మెలె, సొంత ప్రేమ తిలొ పుత్తుసి. ‘అంచొ పుత్తుక మరియాద దెకుల, కిచ్చొగె’ మెన, ఆకర్‍క జోకయ్ తెద్రయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","గని జేఁవ్ గుత్త నఙిలస ‘ఇన్నెకయ్ అబ్బొస్‍చి దనుమ్ కలుగు జయెదె. అల్లె, ఇన్నెక మారుమ, చి ఇన్నెక కలుగు జతి వాట అమ్‍కయ్ దొర్కు జయెదె’ మెన జోవయింక జెఁవ్వి లట్టబన్ల. ");
INSERT INTO key_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","జేఁవ్ ఎజొమానిచొ పుత్తుస్‍క దెర కెర, మార కెర, పీనుమ్ జా ద్రాచ తోట తెంతొ బార్ కెర వెంట గెల. ");
INSERT INTO key_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","జలె, దస్సి కెర్లి రిసొ, జా తోటచొ ఎజొమాని కిచ్చొ కెరెదె మెలె, జో జా కెర, జేఁవ్ గుత్త నఙిలసక నాసెనుమ్ కెర, జా తోట వేర మాన్సుల్‍క గుత్త దెయెదె. ");
INSERT INTO key_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“అల్లె, ఆఁవ్ అప్పె తుమ్‍క సంగితిస్‍చి రిసొ, దేముడుచి కొడొతె రెగిడ్లిసి తుమ్ కెఁయ్య సదు కెర్సు నాయ్ గె? ‘కామ్‍క నెంజె’ మెన ఉచర, గేర్ బందిలస పిటయ్‍ల పత్తురు, బోడిపత్తురు జలన్. ");
INSERT INTO key_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ప్రబు సొంతయ్ ఇసి జర్గు కెర్లొ. జో ఇసి కెర్లి రిసొ, అమ్ దెకిలె ఆచారిమ్ జతయి!” మెన జేఁవ్ కోపుమ్ జల వెల్లెల మాన్సుల్‍క యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","“అమ్‍చి రిసొయి యేసు సంగితయ్” మెన వెల్లెల మాన్సుల్ చినన కోపుమ్ జా, జోక దెరుక ఉచర్ల, గని ప్రెజల్ కోపుమ్ జా అల్లర్ కెరుల మెన, జోవయింక బియఁ కెర, జోక ముల దా ఉట్ట గెల. ");
INSERT INTO key_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","‘యేసుక కొడొతె అడ్జవ నేరిమ్ వయడుమ’ మెన, సగుమ్‍జిన్ పరిసయ్యుల్‍క కి హేరోదు పచ్చెన జతస సగుమ్‍జిన్‍క కి, జేఁవ్ కోపుమ్ జల వెల్లెల మాన్సుల్ తెద్రయ్‍తికయ్, ");
INSERT INTO key_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","జేఁవ్ యేసుతె జా కెర, “గురుబాబు, తుయి సత్తిమ్‍చొ మెన జానుమ్. తుయి మొకమాటుమ్ నే దెకితె, వెల్లెల మాన్సుల్ కిచ్చొ ఉచరుల మెన నే బితె, దేముడు దెకయ్‍లి వాట్‍చి రిసొ సత్తిమ్ తెన్ బోదన కెర్తసి మెన అమ్ జానుమ్” మెన పులయ్‍తి రితి సంగ, అన్నె, “రోమ్ దేసిమ్‍చి ప్రబుతుమ్‍చొ కైసర్ రానొక అమ్ సిస్తు దెంక నాయిమ్ గే, నాయ్ గె? అమ్ జా సిస్తు దెంక గే పోని గే? సంగు” మెన యేసుక సంగిల. ");
INSERT INTO key_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ఇసి సంగితికయ్, యేసు జోవయించి ఉప్రమెన్సు జాన, “అంక కిచ్చొక పరిచ్చ కెర్తసు? డబ్బుల్ కాసు ఏక్ అంచితె ఆన దెకవ” మెన సంగితికయ్, ఆన్ల. ");
INSERT INTO key_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","జేఁవ్ జో తెన్ జా కాసు ఆన్‍లి పొది, జా కాసు దెకవ, “ఇన్నె కచి పోలిక, కచి నావ్ డీస్తయ్?” మెన జోవయింక పుసిలన్, చి జేఁవ్ జోక, “కైసర్ రానొచి” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","యేసు జోవయింక, “కైసర్‍క దెతిసి కైసర్‍క, దేముడుక దెతిసి దేముడుకయ్ దెంక అస్సె” మెన, జోవయింక జబాబ్ దిలన్. దస్సి జబాబ్ దెతికయ్, వెల్లెల మాన్సుల్ తెద్రయ్‍ల మాన్సుల్ ఆచారిమ్ జల. ");
INSERT INTO key_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","తెదొడి, ‘మొర గెలెగిన అన్నె జీవ్ జంక నెంజె, అన్నెక్ లోకుమ్‍తె గెచ్చుక నెంజె’ మెన ప్రెజల్‍క సికయ్‍త సద్దూకయ్యులు సగుమ్‍జిన్ యేసుతె జా కెర, ");
INSERT INTO key_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“గురుబాబు, ఈందె, ‘ఎక్కిలొచొ అన్నొసి బోదల్ నెంతె మొర గెలె, తేర్సిక ఎక్కిల్‍క ముల దా గెలెగిన, జోచొ బావొసి అన్నొస్‍చి తేర్సిక ఆనన, అన్నొస్‍చి నావ్ తెన్ బోదల్ పాయిక అస్సె’ మెన మోసే పూర్గుమ్‍చొ అమ్ యూదుల్‍చి రిసొ రెగిడ్లొ గెద? ");
INSERT INTO key_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","జలె సత్తుజిన్ బావుడ్లు తిల. జోవయింతె తొల్సుర్ తెర్ని ఆనన, బోదల్ నెంతె మొర గెలన్. ");
INSERT INTO key_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ఒత్త తెంతొ, జో మాన్సుచి పట్టి జెర్మిలొసొ జా తేర్‍బోదక ఆనన, జో కి బోదల్ నెంతె మొర గెలన్. జోచి పట్టి జెర్మిలొసొ కి దస్సి కెరన దస్సి జలన్. ");
INSERT INTO key_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","జేఁవ్ సత్తుజిన్ బావుడ్లు ఎత్కిజిన్ వర్స తెన్ దస్సి కెరన మొర గెల. జేఁవ్ ఎత్కిజిన్ మొర గెతికయ్, జా తేర్‍బోద కి మొర గెలి. ");
INSERT INTO key_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","జలె, మొర గెలస అన్నె జీవ్ జతి పొదిక, జోవయింతె కక్క తేర్సి జా తయెదె? జేఁవ్ సత్తుజిన్ వర్స తెన్ జా తెన్ పెండ్లి జల గెద?” మెన యేసుక పుసిల. ");
INSERT INTO key_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ఇసి జతికయ్, యేసు జోవయింక, “తుమ్ పొరపాట్ జా గెతసు. కిచ్చొక గే తుమ్ ఉచర. మెలె, దేముడు పూర్గుమ్ రెగ్డయ్‍లిసి సదు కెర్లె కి, ఒత్త తిలిసి అర్దుమ్ కెరన్సు నాయ్, చి జో కెరయ్‍త కమొ దెకిలెకి, జోచి సెక్తి అదికారుమ్ చినుస్ నాయ్. ");
INSERT INTO key_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","మెలె, మొర గెచ్చ అన్నె జీవ్ జతిస్‍తె పెండ్లివొ నే జతె, పరలోకుమ్‍తె మాన్సుల్ దూతల్‍చి రితి దస్సే తవుల. ");
INSERT INTO key_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","పడ్తొ, ‘మొర గెలస అన్నె జితి నాయ్’ మెన ఉచర, తుమ్ అన్మానుమ్ తెన్ అస్సుస్. గని జా సుట్టు, పూర్గుమ్, రూకు తెడి జా ఆగి లగితె తిలిస్‍చి రిసొ రెగిడ్లిస్‍తె ఆఁవ్ అబ్రాహామ్‍క, ఇస్సాకుక చి యాకోబుక దేముడుయి, మెన దేముడుచి కోడు మోసే రెగిడ్లి పుస్తకుమ్‍తె సదు కెర్సు నాయ్ గె? ");
INSERT INTO key_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","జలె, జేఁవ్ మొర్ల పూర్గుల్‍క మోసేచి కాలుమ్ ఎద కి జోవయింక జో దేముడు తా కామ్‍క అయ్‍లిస్ తెన్ జేఁవ్ అన్నెక్ లోకుమ్‍తె గెచ్చ జివ్వి అస్తి మెన రుజ్జు జతయ్, రితి మొర గెలసక నాయ్, గని జీవ్ తిలసకయ్ జో దేముడు. తుమ్ ఎదివాట్ పొరపాట్ జా అస్సుస్” మెన జేఁవ్ సద్దూకయ్యుల్‍క యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ఈంజ కోడుచి రిసొ జేఁవ్ సద్దూకయ్యుల్ తెన్ పరిసయ్యుల్ గగ్గొల్ జంక దెర్ల. ఇసి జతికయ్, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తొసొ ఎక్కిలొ సూన, జోవయించి నెడిమి జా కెర, జేఁవ్ వెల్లెల మాన్సుల్‍చ పరిచ్చల్‍క యేసు చెంగిల్ జబాబుల్ దెతయ్ మెన దెక, జోక, “ఆగ్నల్ ఎత్కితె ముక్కిమ్‍చి కేన్?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","యేసు జోక, “ముక్కిమ్‍చి ఇసి జతయ్; ‘ఓ అమ్‍చ ఇస్రాయేలులు, సూన, ప్రబు జలొ అమ్‍చొ దేముడు ఎక్కిలొ. జో ఎక్కిలొయి అదికారుమ్ తిలొ దేముడు. అన్నె కోయి నాయ్’ మెన, అన్నె; ");
INSERT INTO key_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","‘తుచొ ప్రబు జలొ దేముడుక తుమ్‍చి ఒండి పెట్టి తెన్, తుమ్‍చి ఒండి ఆత్మ తెన్, తుమ్‍చి ఒండి మెన్సు తెన్, తుమ్‍చి ఒండి బుద్ది తెన్, తుమ్‍చి సెక్తి ఎత్కి తెన్ ప్రేమ కెర్తె తంక.’ మెన మోసేచి అత్తి రెగిడ్లి దేముడుచ ఆగ్నల్‍తె ముక్కిమ్. ");
INSERT INTO key_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","పడ్తొ, ‘తుమ్‍క తుమి కెద్ది ప్రేమ కెరంతసు గే, పక్కయ్‍చక కి తెద్ది ప్రేమ కెర్తె తంక’ మెన అన్నెక్ ఆగ్న కి ముక్కిమ్ అస్సె. ఈంజేఁవ్ దొన్ని ఆగ్నల్‍చి కంట కేన్ ఆగ్న కి జీనె నాయ్” మెన జోక యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","జలె, జో మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తొసొ యేసుక “నిజుమి, గురుబాబు. ‘జో ఎక్కిలొయి’ మెన, ‘అదికారుమ్ తిలొ దేముడు అన్నె కోయి నాయ్’ మెన తుయి సత్తిమ్ సంగిలది. ");
INSERT INTO key_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","అన్నె, ‘ఒండి పెట్టి తెన్, తుమ్‍చి ఒండి బుద్ది తెన్, తుమ్‍చి ఎత్కి సెక్తి తెన్ జోక ప్రేమ కెరుక’ మెన, అన్నె ‘తుమ్‍క తుమి కెద్ది ప్రేమ కెరంతసుమ్ గే, పక్కయ్‍చక తెద్ది ప్రేమ కెర్తె తంక ముక్కిమ్’ మెన తుయి అన్నె మాన్సుల్‍క సంగిలిసి సత్తిమ్. బలి గట్ర ఎత్కిచి కంట ఈంజేఁవ్ దొన్ని ఆగ్నల్ రితి కెరుక విలువ” మెన మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తొసొ ఒప్పన యేసుక జబాబ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","‘ఇసి సంగ బుద్ది తెన్ జబాబ్ దిలొ’ మెన యేసు దెక, జోక “దేముడుచి రాజిమ్‍క తుయి దూరి నాయ్” మెన సంగిలన్. జలె, యేసు బలే బుద్ది తెన్ ప్రస్నల్ ఎత్కిక బులవ సంగితికయ్, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తొసొక, జో జా కోడు సంగిలి తెంతొ, కో కి కేన్ కోడుక కి యేసుక పుసుక దయిరిమ్ కెర్తి నాయ్. ");
INSERT INTO key_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","యేసు దేముడుచి గుడితె అన్నె బోదన కెర్తె తత్తికయ్, “రచ్చించుప కెర్తొసొ జలొ క్రీస్తు దావీదు రానొచి సెకుమ్‍తె జెర్మ జోక పుత్తుసి జయెదె మెన మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస కీసి సంగుక జతయ్? ");
INSERT INTO key_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","మెలె, దేముడుచి సుద్ది తిలి ఆత్మ దావీదుచి పెట్టి సికయ్‍తికయ్ తుచ విరోదుమ్ సుదల్‍క తుయి సుఁదితి రితి ఆఁవ్ కెర్తి ఎద, అంచి ఉజెతొ పక్కయ్ తుయి వెస తా, మెన ప్రబు అంచొ ప్రబుక సంగిలన్. మెన దావీదు రానొ సొంత సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","దస్సి దావీదు రానొ క్రీస్తుక ‘ప్రబు’ మెన సంగితయ్ జలె, జో క్రీస్తు కీసి జా జోక పుత్తుసి జయెదె? ఉచర” మెన ఒత్త తిలసక యేసు సంగిలన్. జలె, ప్రెజల్‍చి ఒగ్గర్‍జిన్ జనాబ్ సర్ద తెన్ జోచ కొడొ సూన్‍తె తిల. ");
INSERT INTO key_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","యేసు అన్నె బోదన కెర్తె తిలి పొది ఇసి మెలన్. “దిగిల సూటిచ పాలల్ గలంత గవురుమ్ ఉచరంత మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తసచి రిసొ తుమ్ జాగర్త తెన్ తా. జేఁవ్ సంతవీదులె టీఁవ, మాన్సుల్ ఎత్కి అమ్‍క జొకర్తు మెన కోర్‍ప జతతి. ");
INSERT INTO key_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","సబ గెరలె ముక్కిమ్‍చ టాన్లుతె, విందుల్‍తె ముక్కిమ్‍చ టాన్లుతె వెసుక కోర్‍ప జతతి. ");
INSERT INTO key_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","జేఁవ్ మోసిమ్‍లు కెర రండెల్ మాన్సుల్‍చ గెరల్ విక కతతి, అన్నె ఉప్రమెన్సుక దిగిల ప్రార్దనల్ కెర్తతి. దస్సి, జోవయించి పాపుమ్ ఒగ్గరి, చి వెల్లి సిచ్చ సేడుల” మెన జేఁవ్‍చి రిసొ యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","తెదొడి యేసు దేముడుచి గుడితె తతి, దేముడుచి కామ్‍క కానుక దెతి డబ్బుల్ పెట్టెల్‍చి మొక్మె వెసిలన్. ఒత్త వెస, బెర అయ్‍ల మాన్సుల్ ఒత్త డబ్బుల్ గల దెతిసి దెకితె తిలొ. జలె, ఒగ్గర్‍జిన్ సొమ్సార్లు ఒగ్గర్ డబ్బుల్ జేఁవ్ పెట్టెల్‍తె గల్తె తతికయ్, ");
INSERT INTO key_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ఎద్గరె నెంజిలి రండెల్ మాన్సు ఎక్లి జా కెర, దొన్ని ఇదుల రాగి కాసుల్ పెటెతె గలిలి. ");
INSERT INTO key_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","గల్తికయ్, యేసు జోచ సిస్సుల్‍క పాసి బుకారాన, “‘ఈందె, జేఁవ్ సొమ్సార్లు ఎత్కిజిన్ మొత్తుమ్ దిలిస్‍చి కంట ఈంజ ఎద్గరె నెంజిలి రండెల్ మాన్సు ఒగ్గర్ దా అస్సె’ మెన కచితుమ్ సంగితసి. ");
INSERT INTO key_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","కిచ్చొక మెలె, జోవయించి ఎదివాట్ సొమ్సారుమ్ తెంతొ సేఁసిలిసి జా దా అస్తి. ఇన్నెక, కిచ్చొ నెంజిలె కి, కలుగు జలిసి ఎత్కి దా గెల అస్సె” మెన సిస్సుల్‍క బుద్ది దెకయ్‍లొ. ");
INSERT INTO key_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ఒత్త తెంతొ, యేసు దేముడుచి గుడి తెంతొ బార్ జతె తతికయ్, జోచ సిస్సుల్‍తె ఎక్కిలొ, “ఈందె, గురుబాబు, ఈంజ దేముడుచి గుడి బందిల పత్రల్, కెద్ది బమ్మ జతి రితి అస్సె!” మెన దెకయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","దస్సి మెన దెకయ్‍తికయ్, యేసు జోవయింక “ఈంజేఁవ్ ఎత్కి దెకితసు, గని అప్పె పత్తుర్‍చి ఉప్పిర్ పత్తురు దొంత్రల్ తిలె కి, ఎక్కి జలెకు నే టీఁవొ నే జతె, గలి జతి దీసి జెయెదె” మెన జబాబ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","తెదొడి దేముడుచి గుడిచి మొక్మె తిలి ఒలీవ మెట్టయ్ యేసు గెచ్చ వెసిలన్, చి పేతురు యాకోబు యోహానుచి అంద్రెయ మెల సిస్సుల్ జోతె జా కెర, అన్నె కో నెంతె, ");
INSERT INTO key_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“గురుబాబు, తుయి సంగిలిసి కెఁయఁక జర్గు జయెదె గే అమ్‍క సంగు. ఈంజ నెరవెర్సుప జతి పొది అయ్‍లి మెలె, అమ్ చినితి రిసొ కిచ్చొ గుర్తు తయెదె?” మెన యేసుక పుసిల. ");
INSERT INTO key_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","జో జోవయింక “కొన్సొ జలెకు తుమ్‍క అంచి రిసొ మోసిమ్ నే కెర్తి రితి తుమ్ జాగర్త దెకన. ");
INSERT INTO key_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","కిచ్చొక మెలె, ఒగ్గర్‍జిన్ మాన్సుల్ క్రీస్తుచి నావ్ తెన్ జా అస్సి, మెన సంగుక జలెకు, ‘ఆఁవ్ క్రీస్తు’ మెన సంగుక జలెకు, ఒగ్గర్‍జిన్‍క మోసిమ్ కెర, వేర బుద్ది సికడుల. ");
INSERT INTO key_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","అన్నె, ‘యుద్దుమ్ జతయ్’ మెన జలెకు, ‘యుద్దుమ్ జయెదె’ మెన జలెకు తుమ్ సూన్‍తె. గని బమ్మ నెంతె తా. ఇసచ ఎత్కి జర్గు జంక అస్సె. గని ఈంజ ఉగుమ్ ఒగ్గర్ బే బేగి పూర్తి జయె నాయ్. ");
INSERT INTO key_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","అన్నె, దేసిమ్‍చి ఉప్పిరి దేసిమ్, రాజిమ్‍చి ఉప్పిరి రాజిమ్ యుద్దుమ్‍క టీఁవొ జవుల. వేర వేరతె బూకంపల్, కరువుల్ జర్గు జవుల. గని ఈంజ ఎత్కి అంచి రాజిమ్ ఏలుప కెర్తి ఉగుమ్ జెర్మయ్‍త నొప్పుల్ రిత జా, ఇసచ ఎక్కి మొదొల్ జవుల. ");
INSERT INTO key_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“తుమ్ మాత్రుమ్, జాగర్త దెకన. కిచ్చొక మెలె, జా పొదిక మాన్సుల్ తుమ్‍క తీర్పు కెర్త సబల్‍తె సొర్ప దెవుల. అమ్‍చ యూదుల్‍చ సబ గెరలె తుమ్‍క పెట గెలుల. జేఁవ్ దస్సి విరోదుమ్ కెర్లె, అంచి నావ్‌చి రిసొ, అంచి రిసొ సాచి సంగితి రిసొ, అదికార్లుచి మొక్మె రానల్‍చి మొక్మె తుమ్ టీఁవొ జస్తె. ");
INSERT INTO key_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","గని తొలితొ, ఉగుమ్ నే మార్సుప జతె, అగ్గె, ఒండి లోకుమ్‍చ కేన్ దేసిమ్‍చ ప్రెజల్‍క కి సుబుమ్ కబుర్ సూనపుక అస్సె. సూనయ్‍లెకయ్, ఈంజ ఉగుమ్‍చి ఆకర్ దీసి జెయెదె. ");
INSERT INTO key_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“జలె, తుమ్‍క మాన్సుల్ నేరిమ్ వయడ అదికారుల్‍తె సొర్ప దెతి పొదిక, ‘కిచ్చొ సంగుక గే?’ మెన తుమ్ చింత గలన నాయ్. తుమ్ సంగుక మెన జయ్యి గడియయ్ దేముడుచి సుద్ది తిలి ఆత్మ కిచ్చొ దెయెదె గే, జయ్యి సంగ. కిచ్చొక మెలె, తుమి లట్టబ్సు నాయ్. దేముడుచి సుద్ది తిలి ఆత్మయి లట్టబెదె. తుమ్‍క తుమి సంగుస్ నాయ్. ");
INSERT INTO key_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“జా పొదిక అన్నె కిచ్చొ బాద తయెదె మెలె, అన్నొస్‍క బావొసి జలెకు, పుత్తుస్‍క అబ్బొసి జలెకు, మొర్తి సిచ్చతె సొర్ప దెవుల. అన్నె, అయ్యస్అబ్బొస్‍క పుత్తర్లు సగుమ్‍జిన్ విరోదుమ్ జా, జోవయింక మొరవుల. ");
INSERT INTO key_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","అన్నె, తుమ్ అంచి నావ్ తెన్ బులితె తత్తెచి రిసొ ఎతివాట్‍జిన్ తుమ్‍క విరోదుమ్ జవుల. గని ఇస అల్లర్ జలెకి, ఆకర్ ఎద కో నముకుమ్ తెన్ తా ఓర్సుప జవుల గే జెఁవ్వి రచ్చించుప జవుల” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“జలె, పిమ్మట్, దేముడుక విరోదుమ్ జా జోక బలే దూసుప కెర నాసెనుమ్ కెర్తిక ఏక్, దేముడుచి గుడితె టీఁవొ నే జతి టాన్‍తె టీఁవొ జంక తుమ్ దెకిలె, ఇన్నెచి అర్దుమ్ కిచ్చొ మెలె, ఈంజ సదు కెర్తస తుమ్ చెంగిల్ ఉచరన. జా గుర్తు తుమ్ దెకిలె, ఈంజ యూదయ ప్రదేసిమ్‍తెచ మాన్సుల్ చట్కున డొంగ్రలె ఉట్ట నిగుతు! ");
INSERT INTO key_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","జా పొదిక కేన్ మిద్దెచి ఉప్పిరి కో తవుల గే, ఉత్ర కెర, జోచి గెరి తెంతొ కిచ్చొ జలెకు వస్తువ వెంట నెంక జవుస్ గెరి పెసుక జయె నాయ్. ");
INSERT INTO key_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","వెడయ్ గట్ర కో తవుల గే, కామ్‍చి రిసొ కడ్ల జోచ పాలల్ జవుస్ వెంట నెంక పస్ల జెంక నాయ్. ");
INSERT INTO key_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","అయ్యొ! జేఁవ్ దీసల్‍క వయ తిల తేర్‍బోదల్, బోదల్ వడ్నివొ, ఉట్ట నిగుక నెత్ర ఒగ్గర్ స్రెమల్ జవుల! ");
INSERT INTO key_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","“‘ఈంజ ఎత్కి చల్లి పొది జర్గు జవుస్ నాయ్’ మెన తుమ్ ప్రార్దన కెర. ");
INSERT INTO key_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","కిచ్చొక మెలె, లోకుమ్ జెర్మయ్‍లి తెంతొ అప్పె ఎద కలుగు జల స్రెమల్‍చి ఒగ్గర్ స్రెమల్ జేఁవ్ దీసల్‍క ఎత్తివాట్ తయెదె. జలి మెలె, ఒత్త తెంతొ అన్నె కెఁయఁక కి తెద్ది స్రెమ తయె నాయ్. ");
INSERT INTO key_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","జాచి రిసొ, జేఁవ్ అల్లర్ జత దీసల్ తొక్కి జతి రితి ప్రబు సెలవ్ దెతొ నాయ్ జలె, కో కి మాన్సుల్ రచ్చించుప జంక నెత్తిర్ తా. గని నంపజతి రిసొ రచ్చనక నిసాన జల మాన్సుల్ పాడ్ నే జతి రిసొయి, ‘జేఁవ్ స్రెమల్ తొక్కి దీసల్ తత్తు’ మెన ప్రబు సెలవ్ దా అస్సె. ");
INSERT INTO key_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","అన్నె తెదొడ్‍క, ‘ఈందె క్రీస్తు!’, ‘ఓదె క్రీస్తు!’ మెన కో జలెకు తుమ్‍క సంగిలె, జా నంప కెర నాయ్. ");
INSERT INTO key_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","కిచ్చొక మెలె, అబద్దుమ్‍చ జా కెర, ‘ఆఁవ్ క్రీస్తు’ మెనన జలెకు, ‘ఆఁవ్ దేముడుచి కబుర్ ఆన్‍తొసొ’ మెనన జలెకు, రచ్చనక నిసాన జలసక మోసిమ్ కెర జోవయించి నముకుమ్ పిట్టవుక మెన ఉచరన, వెల్లొ మాయకమొ కెరుల. ");
INSERT INTO key_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","అల్లె, చెంగిల్ దెకన. ఈంజ ఎత్కి నే జతె అగ్గెయ్ తుమ్‍క ఆఁవ్ సంగితసి. ");
INSERT INTO key_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“జేఁవ్ దీసల్‍క, ఆఁవ్ సంగిల జేఁవ్ స్రెమల్ పూర్తి జలె పిమ్మట్‍క, పొద్దు అందర్ జయెదె, జోను కి ఉజిడి దెయె నాయ్. ");
INSERT INTO key_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ఆగాసుమ్ తెంతొ సుక్కల్ గెసురుల, చి ఆగాసుమ్‍తె ఎత్కి అద్దుర్ జయెదె. ");
INSERT INTO key_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","తెదొడ్‍క ఎదివాట్ అదికారుమ్ తెన్, పరలోకుమ్‍చి ఉజిడి తెన్, ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ మబ్బుల్‍తె పరలోకుమ్ తెంతొ ఉత్ర జెయిందె. ఆఁవ్ దస్సి ఉత్ర జెతిసి లోకుమ్ ఎత్కి దెకుల. ");
INSERT INTO key_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","తెదొడ్‍క అంచ దూతల్‍క తెద్రయిందె, చి జేఁవ్, చెత్తర్ దిక్కుల్ తెంతొ, లోకుమ్‍చి ఏక్ పక్క తెంతొ, అన్నెక్ పక్క ఎద, కేన్ దేసిమ్‍చక నే పిట్తె, రచ్చనక ఆఁవ్ నిసాన్ల మాన్సుల్‍క ఆనవ, ఎక్కితె కుడవనిందె. ");
INSERT INTO key_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“అంజూరుమ్ రూకుక టాలి కెర అర్దుమ్ కెరన. మెలె, దసొ రూక్‍చ కొమ్మల్ కొవ్‍ని జా పలొయ్‍లె ‘వేసెక్ అప్పె పాఁవ జెయెదె’ మెన తుమ్ చినితె. ");
INSERT INTO key_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","దస్సి, ఆఁవ్ సంగిల గుర్తుల్ జర్గు జతిసి తుమ్ దెకిలె, జా గుమ్ముమె పాఁవిల్ రితి జా, అన్నె జెతికయ్ సమయుమ్ పాసి జా అస్సె మెన తుమ్ జాన్‍తె. ");
INSERT INTO key_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ఆఁవ్ సంగిల స్రెమల్ గుర్తుల్ పూర్తి జలెకయ్ ఈంజ ఉగుమ్ అంతుమ్ జయెదె మెన తుమ్‍క ఆఁవ్ కచితుమ్ సంగితసి. ");
INSERT INTO key_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","జలె, ఆగాసుమ్ బుఁయి నాసెనుమ్ జా గెచ్చుల, గని అంచ కొడొ ఎద్గరె పిట్టితి నాయ్. ");
INSERT INTO key_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“జలె, కేన్ దీసిక ఈంజ లోకుమ్‍తె అన్నె జెయిందె గే, జా దీసిక కేన్ గడియక జెయిందె గే, దేముడు జలొ అబ్బొక పిట్టవ కేన్ మాన్సు జలెకు, పరలోకుమ్‍చ దూతల్ జలెకు, దేముడు అబ్బొచొ పుత్తుసి జలెకు, కోయి నేనుమ్. ");
INSERT INTO key_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","జాకయ్, జాగర్త తెన్ తా, తెలివి తా, ప్రార్దన కెర్తె తా. జా కాలుమ్ కెఁయఁక జెయెదె గే నేన్సు. ");
INSERT INTO key_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ఆఁవ్ అప్పె దేముడు జలొ అబ్బొతె గెతిసి, ఈంజ లోకుమ్‍తె అన్నె జెతిసి కీసి మెలె, ప్రయానుమ్ గెతొ మాన్సు కెర్తిస్‍చి రితి జయెదె. జో మాన్సు గెచ్చుక బార్ జతి పొది, జోక కలుగు జతిసి జోచ గొత్తి సుదల్‍క రకితి రితి జోవయింక అదికారుమ్ దా, జోవయింక ఎక్కిలొక కమొ దా, గుమ్ముమ్ రకితొసొ ఎక్కిలొక రకవ, ఉట్ట గెచ్చెదె. అంచి తెన్ కి దస్సి. ");
INSERT INTO key_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“జలె, తుమ్ జాగర్త తెన్ రకితె తా. కిచ్చొక మెలె, గేర్‍చొ ఎజొమాని కెర్లి రితి ఆఁవ్ ఉట్ట గెలె, సంజెక జెయిందె గే, సొక్కుక జెయిందె గే, కుకుడొ వాంసెనె జెయిందె గే, పెందలె జెయిందె గే, కెద్దొడ్‍క జెయిందె గే, తుమ్ నేన్సు. ");
INSERT INTO key_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","తెలివి తా రకితె తా. నెంజిలె, తుమ్ నే రకితె నిజిల్ రితి బదుకుమ్ జా తిలె పొది ఆఁవ్ అయ్‍లె, దెకిలె, తుమ్ కీసి జస్తె! ");
INSERT INTO key_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","తుమ్‍కయ్ మెన నాయ్, ఎత్కిజిన్ మాన్సుల్‍క ఆఁవ్ కిచ్చొ జాగర్త సంగితసి మెలె, ఈంజ లోకుమ్‍తె ఆఁవ్ అన్నె జెతిస్‍క తెలివి తెన్ రకితె తా” మెన సిస్సుల్‍క యేసు ఈంజ బోదన ఎత్కి సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","దొరతి గెలి పిమ్మట్ పస్కా పండుగు, జలె నే పులయ్‍ల పోడియొ కతి పండుగు, నే జెతె అగ్గె, వెల్లెల పూజర్లు చి మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస కుట్ర ఉచర ఉచర, “కీసి కెర జలెకు గుట్టు తెన్ యేసుక అప్పెయి దెర మారుమ” మెన ఆస తెన్ తిల. ");
INSERT INTO key_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","గని, “పండుగు పొది పోని, కిచ్చొక మెలె పండుగ్‍క బెర అయ్‍ల ప్రెజల్ కుమ్మత్ తెన్ గగ్గొల్ జా అమ్‍క బలే అల్లర్ కెరుల.” ");
INSERT INTO key_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","యేసు బేతనియ గఁవ్వి గెచ్చ, సీమోను మెలొ వెల్లి రోగుమ్ జా తిలొ ఎక్కిలొచి గెరి తా, అన్నిమ్ కంక వెస తతికయ్, ఏక్ తేర్‍బోద ఒగ్గర్ విలువచి వాసెన తేలుచి బుడ్డి దెరన జా, జా బుడ్డి పుట్టవ కెర యేసుచి బోడి ఉప్పిరి సువిలి. ");
INSERT INTO key_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ఒత్త తిలస సగుమ్‍జిన్ కోపుమ్ జా “ఈంజ తేల్ ఇసి పాడ్ కెరుక కిచ్చొక? ");
INSERT INTO key_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ఈంజ తేల్ సొవ్వు పుంజొ వెండ్లుచి కంట అన్నె డబ్బుల్‍క వికుక జతి, చి బీద సుదల్‍క దర్ముమ్ దెంక జతి” మెన లట్టబన, జా తేర్‍బోదక గోల కెర్ల. ");
INSERT INTO key_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","జలె యేసు, “ఇన్నెక గోల కెర నాయ్. కిచ్చొక ఇన్నెక ఉస్సుర్ కెర్తసు? అంచి రిసొ ఈంజ కెర్లిసి వెల్లొ కామ్. ");
INSERT INTO key_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","బీద సుదల్ కెఁయఁక కి తుమ్‍చి తెన్ తవుల చి రిసొ తుమ్‍క కెఁయఁక ఇస్టుమ్ అయ్‍లె, జోవయింక దర్ముమ్ దెంక జయెదె. గని ఆఁవ్ కెఁయఁక తెఁయఁక తుమ్‍చి తెన్ ఈంజ లోకుమ్‍తె ఇసి తయె నాయ్. ");
INSERT INTO key_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ఇన్నెచి అత్తి తిలిసి సర్దక ఈంజ కెర అస్సె. ఆఁవ్ నే మొర్తె అగ్గె, అంక నే రోవితె అగ్గె, అంచి ఆఁగ్ తెయార్ కెర్తి గుర్తు రితి కెర అంక ఈంజ తేల్ బోడి సువ దా అస్సె. ");
INSERT INTO key_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","అన్నె ఆఁవ్ తుమ్‍క కిచ్చొ నిజుమి సంగితసి మెలె, ఒండి లోకుమ్‍తె కేనె అంచి రిసొ సుబుమ్ కబుర్ బోదన కెరుల గే ఒత్తయ్ ఈంజ అప్పె కెర్లిసి సంగ, ఇన్నెచి రిసొ ఉచరవడుల” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","యేసుచ బారజిన్ సిస్సుల్‍తె ఎక్కిలొ ఇస్కరియోతు గఁవ్విచొ యూదా మెలొసొ, తెదొడి జో, యేసుక దెర వెల్లెల పూజర్లుచి అత్తి దెంక ఉచర, జోవయింతె గెచ్చ, సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","జేఁవ్ సూన సర్ద జా, “తుక డబ్బుల్ దెమ్‍దె” మెన ఒప్పన్‍తికయ్, యేసుక కీసి కెర కెఁయఁక దెర దెంక గే, యూదా వాట్ చజితె తిలొ. ");
INSERT INTO key_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","నే పులయ్‍ల పోడియొ కతి పండుగ్‍చి మొదొల్ కెర్తి దీసి, మెలె, ‘పస్కా’ మెన మెండపిల్లక అర్పితుమ్ దా జోచి లొఁయి సుఁవితి దీసి, సిస్సుల్ యేసుక “తుయి పస్కా అన్నిమ్ కెర్తి రిసొ అమ్ కేన్ టాన్ తెయార్ కెరుక?” మెన జోక పుసిల. ");
INSERT INTO key_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","జో సిస్సుల్‍తె దొగులక పాసి బుకారా, “తుమ్ పట్నుమ్‍తె గెచ్చ, చి పట్నుమ్ తెడి పెసిలదు మెలె, పాని వయితొసొ ఎక్కిలొ తుమ్‍క దస్సుల్ జయెదె. జోచి పట్టి గెచ్చ, ");
INSERT INTO key_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","చి కేన్ గెరి జో పెసెదె గే, జా గేర్‍చొ ఎజొమానిక తుమ్ కిచ్చొ మెన మెలె, ‘అంచ సిస్సుల్ తెన్ ఆఁవ్ పస్కా అన్నిమ్ కతి గది కేన్?’ మెన అమ్‍చొ గురుబాబు పుసితయ్ మెన సంగ, చి ");
INSERT INTO key_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","తెయార్ కెర్లి వెల్లి అంతస్తు గది ఏక్ తుమ్‍క దెకయెదె. ఒత్తయ్ అమ్‍చి రిసొ పస్కా అన్నిమ్ తెయార్ కెర తా” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","జేఁవ్ సిస్సుల్ బార్ జా పట్నుమ్‍తె గెచ్చ, జో సంగిలి రితి ఎత్కి జర్గు జా అస్సె మెన దెక, జా పస్కా అన్నిమ్‍క దొర్కు జలిసి తెయార్ కెర్ల. ");
INSERT INTO key_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","సాంజ్ జతికయ్, యేసు జేఁవ్ బారజిన్ సిస్సుల్ తెన్ జా గదితె జా కెర, ");
INSERT INTO key_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","జేఁవ్ వెస అన్నిమ్ కెర్తె తతికయ్, యేసు “తుమ్‍క ఆఁవ్ కిచ్చొ కచితుమ్ సంగితసి మెలె, తుమ్ అంచి తెన్ కతసతె ఎక్కిలొ అంక దెర విరోదుమ్ సుదల్‍చి అత్తి సొర్ప కెర దెయెదె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ఇసి సంగితికయ్, జేఁవ్ దుకుమ్ జా, “ఆఁవ్ గె?” మెన ఎక్కిలొచి పడ్తొ ఎక్కిలొ ఎత్కిజిన్ సంగుక దెర్ల. ");
INSERT INTO key_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","జలె, జో జోవయింక, “తుమ్ బారజిన్‍తె ఎక్కిలొ దస్సి కెరెదె. అంచి తెన్ ఆతు తప్పెలయ్ పోడి బెద బుడ్డయ్‍తొ ఎక్కిలొ. ");
INSERT INTO key_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ఆఁవ్ మాన్సు జా జెర్మిలొసొచి రిసొ రెగిడ్లి లెక్క ఉట్ట గెచ్చిందె. గని, అయ్యొ! ఆఁవ్ మాన్సు జా జెర్మిలొసొక కేన్ మాన్సు దెర విరోదుమ్ సుదల్‍చి అత్తి సొర్ప కెర దెయెదె గే, జో మాన్సు జతి సిచ్చచి రిసొ జో నే జెర్మ తిలె జోక చెంగిల్ తత్తి!” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","యేసు, సిస్సుల్ జా పస్కా అన్నిమ్ కెర్తె తా, యేసు పోడియొ దెరన “దయ కెర్లది” మెలి రితి దేముడు అబ్బొస్‍క జొఒర సంగ కెర, జా పోడియొ మోడ, సిస్సుల్‍క వంట దా, జోవయింక “తుమ్ ఈంజ కడన కా. అంచి ఆఁగ్‍క ఈంజ గుర్తు జయెదె” మెన కెర, ");
INSERT INTO key_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ఏక్ గిన్నచి ద్రాచ రస్సుమ్ దెర, దేముడు అబ్బొస్‍క అన్నె ఉచర, సిస్సుల్‍క దెతికయ్, జేఁవ్ ఎత్కిజిన్ జా గలస్‍చి ద్రాచ రస్సుమ్ వర్స తెన్ పిల. ");
INSERT INTO key_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","తెదొడి యేసు “ఈంజ రస్సుమ్ కిచ్చొచి గుర్తు మెలె, ఒగ్గర్‍జిన్ మాన్సుల్‍చి పాపుమ్ గెచ్చయ్‍తి రిసొ అంచి లొఁయి సూఁయి జంక అస్సె మెన అంచి నొవి ప్రమానుమ్. ");
INSERT INTO key_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","తుమ్‍క ఆఁవ్ కిచ్చొ నిజుమి సంగితసి మెలె, అబ్బొసి జలొ దేముడుచి రాజిమ్‍తె ఆఁవ్ నొవర్ పితె ఎద, ఇసి ద్రాచ రస్సుమ్ పియి నాయ్” మెన సిస్సుల్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","తెదొడి జేఁవ్ దేముడుక గనుమ్ గాయ కెర బార్ జా, ఒలీవ మెట్టయ్ ఉట్ట గెల. ");
INSERT INTO key_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","యేసు జోవయింక, “తుమ్ ఎత్కిజిన్ బమ్మ జా అంక ములితె. కిచ్చొక మెలె, మెండల్ రకితొసొక ఆఁవ్ మొరయిందె, చి జోచ మెండల్ ఎత్కిజిన్ చెదుర్ప జా గెచ్చుల, మెన దేముడు కోడుతె రెగ్డయ్‍లిసి నెరవెర్సుప జంక అస్సె. ");
INSERT INTO key_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","గని ఆఁవ్ అన్నె జీవ్ జా ఉట్లి పిమ్మట్‍క, తుమ్‍చి కంట అగ్గె గలిలయ ప్రాంతుమ్‍తె గెచ్చిందె” మెన ప్రమానుమ్ కెర్లన్. ");
INSERT INTO key_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","యేసు ఇసి సంగితికయ్, పేతురు జోక “ఎత్కిజిన్ తుక ములిలెకి, ఆఁవ్ తుక ములి నాయ్” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","జలె యేసు జోక, “తుక ఆఁవ్ కిచ్చొ నిజుమి కచితుమ్ సంగితసి మెలె, ఆజి రాతిక, కుకుడొ తివ్వెరి నే వాఁసితె అగ్గె, ‘జోక నేని’ మెన అంచి రిసొ తుయి తివ్వెరి సంగితె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","దస్సి సంగిలే కి, పేతురు బమ్మ తెన్ “ఆఁవ్ తుచి తెన్ మొరుక అస్సె మెలె కి, ఆఁవ్ తుక ‘నేని’ మెన కెఁయ్యఁక కి సంగి నాయ్” మెన పేతురు గట్టిఙ సంగిలన్. జేఁవ్ సిస్సుల్ ఎత్కిజిన్ దస్సి సంగిల. ");
INSERT INTO key_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ఒత్త తెంతొ యేసు సిస్సుల్ గెత్సేమనే మెంతి తోటతె గెచ్చ, జో “ఆఁవ్ ఒత్తల్‍తొ గెచ్చ ప్రార్దన కెర జెతి ఎది ఎద తుమ్ ఇన్నె వెస తా” మెన జేఁవ్ సిస్సుల్‍క సంగ, ");
INSERT INTO key_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ఎక్కి పేతురుక, యాకోబుక చి యోహానుక పట్టి కడన ఇదిల్ దూరి గెచ్చ తా, దుకుమ్ జా మెన్సుతె ఒగ్గర్ బాద సేడుక దెర్లొ. దస్సి బాద సేడ, ");
INSERT INTO key_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","“అంచి పెట్టి తిలి దుకుమ్‍క మొర గెచ్చుక జయెదె. తుమ్ ఇన్నె తెలివి తెన్ రకితె తా” మెన సంగ, ");
INSERT INTO key_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","సగుమ్ దూరి గెచ్చ కెర, సెర్ను సేడ, దేముడు అబ్బొస్‍క ఇసి మెన ప్రార్దన కెర్లన్. “ఓ బ, తుక జంక తిలెగిన, ఈంజ దుకుమ్ జతి గడియ నెంజిలె, జతి లెక జలె అంక పిట్టవు” మెన అన్నె, ");
INSERT INTO key_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“ఓ బ, ఎత్కి తుచి అత్తి అస్సె. ఈంజ గిన్నచి ఆఁవ్ నే పితి రితి అంక పిట్టవు. గని అంచి ఇస్టుమ్ పోని. తుచి ఇస్టుమ్ జర్గు జవుస్” మెన ప్రార్దన కెర, ");
INSERT INTO key_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","జేఁవ్ సిస్సుల్‍తె ఉట్ట జా, జేఁవ్ నిజ అస్తి మెన దెక కెర, పేతురుక, “ఓ సీమోను, తుయి నిజ అస్సిస్ గే? ఎక్కి గడియ జవుస్ రకితె తంక నెతిర్లది గే? ");
INSERT INTO key_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","జెత అల్లర్‍తె తుయి పాపుమ్ నే కెర్తి రితి జాగర్త తెన్ తా, ప్రార్దన కెర్తె తా. ‘ఆత్మ నిదానుమ్ అస్సె’ మెన ఉచరన్లెకి, ఆఁగ్‍క సెక్తి నాయ్,” మెన పేతురుక యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","అన్నెక్ సుట్టు ఇదిల్ దూరి ఉట్ట గెచ్చ కెర, తొలితొ ప్రార్దన కెర్ల కొడొ, అన్నెక్ సుట్టు ప్రార్దన కెర్లొ. ");
INSERT INTO key_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","దస్సి ప్రార్దన కెర, అన్నె బుల జా, జేఁవ్ సిస్సుల్ గూన్‌క నెత్ర కెర నిజ అస్తి మెన దెకిలన్. దెకితికయ్, జేఁవ్ లాజ్ జా, జోక కిచ్చొ సంగుక గే నేన గెల. ");
INSERT INTO key_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","అన్నెక్ సుట్టు కి యేసు దస్సి గెచ్చ అన్నె జా, మొత్తుమ్ తివ్వెరి జేఁవ్ నిజిలిసి దెక, “అప్పెకయ్ సెలవ్ కడన నే రకితె నిజ అస్సుస్ గే? సాలు. ఈందె సమయుమ్ జా గెలి గే. ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ పాపుమ్ కెర్తసచి అత్తి దెర్ను సేడిందె. ");
INSERT INTO key_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","జొమ్మ, గెచ్చుమ! ఓదె, అంక దెర దెతొసొ పాసి జా అస్సె” మెన జోవయింక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","యేసు దస్సి లట్టబ్తె తతికయ్, జోచ బారజిన్ సిస్సుల్‍తె అగ్గె బెద తిలొ యూదా పాఁవ అయ్‍లొ. వెల్లెల పూజర్లు, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తసచి అన్నె వెల్లెల మాన్సుల్ తెద్రయ్‍ల జనాబ్ కి, కత్తులు డండల్ దెరన, యూదా తెన్ అయ్‍ల. ");
INSERT INTO key_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","జలె ఈంజ నే జతె అగ్గె, “కక్క ఆఁవ్ చుంబిందె గే, జొయ్యి యేసు. జోకయ్ దెరన కో నే పిట్టయ్‍తి రితి చెంగిల్ రక కడన” మెన యేసుక దెర దెతొ యూదా జేఁవ్ జనాబ్‍క గుర్తు సంగ తిలన్. ");
INSERT INTO key_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","జో అయ్‍లి బేగి, యేసుతె జా కెర, “గురుబాబు” మెన సంగ చుంబితికయ్, ");
INSERT INTO key_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","జేఁవ్ బెద అయ్‍లస యేసుక దెర్ల. ");
INSERT INTO key_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","జలె, ఒత్త టీఁవొ జా తిలొ ఎక్కిలొ కత్తి కడన, ఎత్కిక వెల్లొ పూజరిచొ గొత్తి సుదొక పెట జోచొ కంగ్డొ కండ గెలన్. ");
INSERT INTO key_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","తెదొడి జోక దెర్లసక యేసు, “ఆఁవ్ కిచ్చొగె చోర్లయ్ గే, చి తుమ్ కత్తులు డండల్ దెరన అంక దెరుక తుమ్ అయ్‍లదు గే? ");
INSERT INTO key_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ఆఁవ్ రోజుక తుమ్‍చి తెన్ దేముడుచి గుడితె తా బోదన కెర్లె కి, జా పొది అంక దెర్సు నాయ్. జలె, దేముడుచి కొడొతె రెగిడ్లిసి ఎత్కి జర్గు జవుస్!” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","జలె, సిస్సుల్ ఎత్కిజిన్ బమ్మ జా, జోక ముల దా ఉట్ట నిగిల. ");
INSERT INTO key_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","జలె, పట్టి బందన తిలొ ఏక్ ఉబెడొ యేసుచి పట్టి గెతె తిలన్ యేసుక కడ నెత మాన్సుల్‍తె సగుమ్‍జిన్ జో ఉబెడొక దెర్ల. ");
INSERT INTO key_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","గని, జో జా పట్టి సేడవ దా డుమ్‍డొయ్ ఉట్ట నిగిలన్. ");
INSERT INTO key_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","యేసుక ఎత్కిక వెల్లొ పూజరితె కడ నిల. ఒత్త కడ నెతికయ్, వెల్లెల పూజర్లు, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస, వెల్లెల మాన్సుల్ ఎత్కిజిన్ ఒత్త బెర తిల. ");
INSERT INTO key_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","పేతురు, జలె, దూరి దూరి తా యేసుచి పట్టి జా జా, జో ఎత్కిక వెల్లొ పూజరిచి వీదె పెస, ఆగితె తపితి రిసొ జమాన్లు తెన్ వెస తిలొ. ");
INSERT INTO key_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","వెల్లెల పూజర్లు చి అన్నె వెల్లెలొ సబ కెర్తస ఎత్కిజిన్ యేసుక మార గెలుక మెన జోక నేరిమ్ వయడ్తి సాచిక చజితె తిల, గని సరి జతి సాచి దొర్కు జయె నాయ్. ");
INSERT INTO key_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","మెలె, ఒగ్గర్‍జిన్ జోచి ఉప్పిరి అబద్దుమ్ సాచి సంగిలే కి కచి, కచి సాచి ఎక్కి రితి జయె నాయ్. ");
INSERT INTO key_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","తెదొడి, సగుమ్‍జిన్ టీఁవొ జా, “మాన్సు బందిలి ఈంజ దేముడుచి గుడి సేడవ కెర తిర్రత్‍కయ్ మాన్సు నే బందిలి ఏక్ దేముడుచి గుడి బందిందె, మెన ఈంజొ సంగిలిసి సూన్లమ్” మెన అబద్దుమ్ సంగిల. ");
INSERT INTO key_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","గని జేఁవ్ సంగిలి సాచి కి సరిగా బెదె నాయ్. ");
INSERT INTO key_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","తెదొడి, ఒత్త తిల మాన్సుల్‍చి నెడ్‍మె ఎత్కిక వెల్లొ పూజరి టీఁవొ జా కెర, యేసుక “ఈంజేఁవ్ సంగితిస్‍క కిచ్చొ జబాబ్ దెంక నెతిర్సి గే? ఈంజేఁవ్ తుక కిచ్చొ నేరిమ్ వయడ్తతి?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","గని యేసు తుక్లె తా, కిచ్చొ జబాబ్ కి సంగె నాయ్. యేసు తుక్లె తతికయ్, ఎత్కిక వెల్లొ పూజరి జోక అన్నె “పరలోకుమ్ తిలొ అమ్‍చొ దేముడు ప్రబుచొ పుత్తుస్ జలొ క్రీస్తు తూయి గే?” మెన యేసుక పుసితికయ్, ");
INSERT INTO key_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","జో “అఁవ్వి. అన్నె, ఆకర్‍క, ఎత్కి సెక్తి అదికారుమ్ తిలొసొచి ఉజెతొ పక్కయ్ ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ వెస తతిసి కి, ఆగాసుమ్‍చ మబ్బుల్ తెన్ ఆఁవ్ పరలోకుమ్ తెంతొ అన్నె ఉత్ర జెతిసి కి తుమ్ దెకితె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ఇసి సంగితికయ్, జో ఎత్కిక వెల్లొ పూజరి కోపుమ్ జా, జో గలన్లి దిగిల్ సొక్క చిరన గెల కెర, “అన్నె సాచి సంగితస అమ్‍క అక్కర్ నాయ్. ");
INSERT INTO key_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","దేముడుక ఆఁవ్ సమ్మందుమ్ జతసి మెన ఈంజొ సంగ ప్రబుచి విలువ కడ వెల్లి పాపుమ్ కెర్తిసి తుమ్ ఎత్కిజిన్ సొంత సూన్లదు, తుమ్ కిచ్చొ తీర్పు సంగితె?” మెన సబ కెర్తసక పుసితికయ్, “మొర్తి సిచ్చచి తప్పు కెర అస్సె” మెన జేఁవ్ ఎత్కిజిన్ తీర్పు సంగిల. ");
INSERT INTO key_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","తెదొడి జోవయింతె సగుమ్‍జిన్ యేసుక తుంకుర్‍క దెర, నిస్కారుమ్ కెర్ల. అన్నె, జోచి మొక్మె పాలుమ్ డంక దా జోక పెట, “తుక కో పెట్ల గే, తుయ్ క్రీస్తు గే సంగు!” మెన కొంకడ్ల. అన్నె, జమాన్లు జోక ఎత్తివాట్ దెబ్బల్ పెట గెల. ");
INSERT INTO key_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","పేతురు ఎట్టొతొ వీదె తతికయ్, జో ఎత్కిక వెల్లొ పూజరితెచి తేర్‍బోద గొత్తి సుది ఎక్కిల్ జా కెర, ");
INSERT INTO key_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","పేతురు ఆగితె తపిత్ తిలిసి దెక కెర, “తుయి కి నజరేతు గఁవ్విచొ యేసు తెన్ తిలది, గెద” మెలి. ");
INSERT INTO key_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ఇసి మెన సంగితికయ్, “నాయ్, గెద. తుయి సంగితిసి కిచ్చొ గే, ఆఁవ్ నేని. అంక అర్దుమ్ జయె నాయ్” మెన సంగ, జా వీదెచి ఒత్తల్‍తొచి గుమ్ముమె ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","గని జా గొతిమాన్సు జోక ఒత్త అన్నె దెక, “ఈంజొ కి జోచ సిస్సుల్‍తె ఎక్కిలొ” మెన ఒత్త టీఁవొ జల సుదల్‍క సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","పేతురు అన్నె, “ఆఁవ్ నెంజి” మెన సంగిలన్. అన్నె గడియ గెతికయ్, ఒత్త తిలస పేతురుక దెక, “తుయి, నిజుమి జోతె తిలొసొ. తుయి కి గలిలయ ప్రాంతుమ్‍తెచొ మాన్సు గెద?” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","జాకయ్ పేతురు, “తుమ్ సంగిలొ మాన్సుక ఆఁవ్ నేని” మెన సాపెన గల కెరన ఒట్టు గలనుక దెర్తికయ్, ");
INSERT INTO key_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","బేగి కుకుడొ వాఁసిలన్. జలె ఇన్నెతెన్ దొవ్వెర్ జలి, చి “కుకుడొ తివ్వెరి నే వాఁసితె అగ్గె, తుయి అంక ‘నేని’ మెన తివ్వెరి సంగితె” మెన యేసు అగ్గె సంగిలిసి ఏదస్ట కెర, పేతురు ఎదివాట్ దుకుమ్ జా ఏడ గెలన్. ");
INSERT INTO key_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","రాత్ పయితికయ్, వెల్లెల పూజర్లు, వెల్లెల మాన్సుల్, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస, వెల్లి సబ కెర్త సుదల్ ఎత్కిజిన్ బెద వెస, యేసుక కిచ్చొ కెరుక గే ఉచర, జోక బంద కడన, అదికారి జలొ పిలాతు మెలొసొతె సొర్ప దిల. ");
INSERT INTO key_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","పిలాతు యేసుక దెక, “తుయి గే యూదుల్‍చొ రానొ?” మెన పుసిలన్, చి యేసు “తుయి సంగిలి రితి” మెన జబాబ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","తెదొడి వెల్లెల పూజర్లు యేసుక ఒగ్గర్ నేరిమ్‍లు వయడ్తికయ్, ");
INSERT INTO key_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","పిలాతు మెలొ జో అదికారి జోక అన్నె, “తుయి జోవయింక కిచ్చొ జబాబ్ దెసి నాయ్ గే? ఈందె, తుక కెత్తి నేరిమ్‍లు వయడ్తతి గే సూను”, మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","గని యేసు అన్నె కిచ్చొ జబాబ్ దిలొ నాయ్, చి రిసొ పిలాతు ఒగ్గర్ ఆచారిమ్ జలొ. ");
INSERT INTO key_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","జలె, జా పండుగు పొది, ప్రెజల్ కోర్‍ప జలొ కేన్ జలెకు జేలి జలొసొక ముల దెంక పిలాతుక అలవాట్ జా అస్సె. ");
INSERT INTO key_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","జలె, ప్రబుతుమ్‍క విరోదుమ్ జా అదికారుల్‍క విత్రేకుమ్ కెర అత్య కెర్ల మాన్సుల్ సగుమ్‍జిన్ జా పొది జేల్‍తె తిల. జోవయింతె బరబ్బ మెలొ ఎక్కిలొ తిలొ. ");
INSERT INTO key_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","జలె, ఒత్త తిల జనాబ్ పిలాతుచి పాసి బెర జా కెర, “తుయి ఈంజ పండుగ్‍క అలవాట్ జలి రితి అమ్‍క కెరు!” మెన బలవంతుమ్ కెర్ల. ");
INSERT INTO key_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","జాకయ్ జో పిలాతు జోవయింక “తుమ్ యూదుల్‍క రానొ జలొసొక తుమ్‍క ఆఁవ్ ముల దెంక తుమ్‍చి ఆస గే?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","కిచ్చొక మెలె, ఎక్కి గోసకయ్ వెల్లెల పూజర్లు యేసుక జో తెన్ ఆన అస్తి మెన జో జానె. ");
INSERT INTO key_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","గని, “‘యేసుక పోని. బరబ్బక ములు!’ మెన సంగ” మెన వెల్లెల పూజర్లు జేఁవ్ బెర తిల జనాబ్‍క సికయ్‍తె తిల. ");
INSERT INTO key_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","తెదొడి పిలాతు జేఁవ్‍క అన్నె, “దస్సి జలె, తుమ్ యూదుల్‍చొ రానొ మెలొసొక ఆఁవ్ కిచ్చొ కెరుక?” మెన పుసిలన్, ");
INSERT INTO key_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","చి జేఁవ్ జనాబ్ “జోక సిలువతె గల మొర్తి సిచ్చ కెరు!” మెన ఒర్సిల. ");
INSERT INTO key_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","జేఁవ్ ఇసి జతికయ్, పిలాతు అన్నె, “కిచ్చొక? కిచ్చొ నేరిమ్ కెర అస్సె?” మెన పుసిలన్. గని జేఁవ్, అగ్గెచి కంట ఒగ్గర్ విస్సుమ్ తెన్ “సిలువతె గల మొర్తి సిచ్చ కెరు!” మెన గట్టిఙ కేకుల్ గలిల. ");
INSERT INTO key_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","జాకయ్ పిలాతు, ప్రెజల్‍క ముద్దొ కెరుక మెన, జేఁవ్ సంగిలొ బరబ్బక ముల కెర, యేసుక కొర్డల్ తెన్ పెటవడ, ‘జోక సిలువతె గల్తు, జలె’ మెన సొర్ప దిలన్. ");
INSERT INTO key_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","తెదొడి అదికారితెచ జమాన్లు సుదల్ యేసుక ‘ప్రేతోరియమ్’ మెంతి అదికారి గేర్‍చి తెడిచి గదితె కడ నా కెర, సయ్‍న్యుమ్ ఎత్కిజిన్‍క ఒత్త బుకారా కెర, ");
INSERT INTO key_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ఊద రంగుచొ ఏక్ పాలుమ్ జోక గల దా, కంటక ఏక్ కిరీటుమ్ గంచ కెర, జోచి బోడితె గల దా కెర, ");
INSERT INTO key_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","యూదుల్‍చొ రానొ, తుక జెయ్యి, జెయ్యి! మెన కొంకడ కొంకడ జొకర, ");
INSERT INTO key_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ఏక్ డండొ తెన్ జోక బోడి పెట, జోక తుంక్ర కెర, సెర్ను సేడ జొకర కొంకడ్ల. ");
INSERT INTO key_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","దస్సి దూసుప కెర్లి పిమ్మట్, జోక గల తిలి ఊద రంగుచొ పాలుమ్ కడ గెల కెర, జోచొ సొంత పాలుమ్ జోక అన్నె గల కెర, జోక సిలువతె గలుక మెన కడ నిల. ");
INSERT INTO key_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","వట్టె గెతె తతికయ్, కురేనియు దేసిమ్‍చొ సీమోను మెలొ ఎక్కిలొ పాసిచి బయిలె తెంతొ జా, ఒత్త పాఁవిలన్. జో, అలెక్సంద్రు రూపు మెల దొగులక అబ్బొసి జయెదె. జలె, జోకయ్ “యేసుచి సిలువ తుయి వయు” మెన జమాన్లు సుదల్ బలవంతుమ్ కెర్ల. ");
INSERT INTO key_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","జలె, యేసుక గొల్గొతా మెలి మెట్టయ్ కడ నిల. ‘గొల్గొతా’ మెలె, ‘గిడ్గి పోలికచి టాన్’. జలె, జోక ఒత్త కడ నా కెర, ");
INSERT INTO key_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","నొప్పి తొక్కి కెర్తి ఓస్తు బెదయ్‍లి ద్రాచ రస్సుమ్ యేసుక సయ్‍న్యుమ్ సుదల్ “పి” మెన దిలెకి, పియె నాయ్. ");
INSERT INTO key_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","తెదొడ్ జోక ఏక్ సిలువతె గల టీఁవడ సిలువక బుఁయ్యె రోవ కెర, “జోచ పాలల్ వంటనుమ” మెన చీటి గల వంటన్ల. ");
INSERT INTO key_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","జోక సిలువతె గలిలి సమయుమ్ కెద్ది జలి మెలె, పెందలె నొవ్వు గంటల్ జలి. ");
INSERT INTO key_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","“యూదుల్‍చొ రానొ, ఈంజొ” మెన జోచి నేరిమ్ రెగిడ్లి దార్చిగండ యేసుచి బోడిచి ఉప్పిరి సిలువతె ఒడొవ దిల. ");
INSERT INTO key_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","అన్నె, ఉజెతొ పక్క ఎక్కిలొక, డెబ్రి పక్క ఎక్కిలొక, దొగుల చోర్లుక ఎక్కెక్ సిలువల్‍తె గలిల. ");
INSERT INTO key_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","జేఁవ్ తెన్ దేముడు పూర్గుమ్ రెగ్డయ్‍లి ఏక్ కోడు నెరవెర్సుప జలి. “జో పాపుమ్ నెంజిలొసొ జలెకి, నేరిమ్ వయడ, జోక ‘పాపుమ్ కెర్లొసొ’ మెన పాపుమ్ కెర్లస తెన్ బెదవ సిచ్చ కెర్ల.” ");
INSERT INTO key_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","జా వాట్ గెతె తిల మాన్సుల్ యేసుక ఆఁస, ఆఁస బోడి దున్నొవ, “దేవులుమ్ సేడవ తిర్రత్‍క అన్నె బందితొసొ, తుయి. ");
INSERT INTO key_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","జలె, తుక తూయి రచ్చించుప కెరన, జా సిలువ తెంతొ ఉత్రు!” మెన జోక కొంకడ దూసుప కెర్ల. ");
INSERT INTO key_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","దస్సి, వెల్లెల పూజర్లు, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస తెన్ బెద జా, ఎక్కిలొ తెన్ ఎక్కిలొ ఆఁస, ఆఁస “ఈంజొ వేర సుదల్‍క రచ్చించుప కెర్లన్, గని జోక జొయ్యి రచ్చించుప కెరనుక నెత్రె. ");
INSERT INTO key_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ఆమ్ దెక నంప కెర్తి రిసొ, ఈంజొ క్రీస్తు, ఇస్రాయేలు ప్రెజల్‍చొ రానొ జలె, సిలువ తెంతొ ఉత్ర జెవుసు!” మెన యేసుక దూసుప కెర్ల. జో తెన్ బెదవ సిలువల్‍తె గలిల దొగుల చోర్లు కి జోక దూసుప కెర్ల. ");
INSERT INTO key_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","బార గంటల్ మెద్దెన్ జలి తెంతొ, మొదొల్ కెర తిన్ని గంటల్ ఎద జా ఒండి దేసిమి అందర్ డంక తిలి. ");
INSERT INTO key_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","జలె, తిన్ని గంటల్‍క యేసు, “ఏలీ, ఏలీ, లామా సబక్తానీ” మెన అరమయ్ బాస తెన్ “అంచొ దేముడు ప్రబు, అంచొ దేముడు ప్రబు, అంక కిచ్చొక ఆతు ముల దా అస్సిసి?” మెన గట్టిఙ ఒర్స దిలన్. ");
INSERT INTO key_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","జలె, ఒత్త టీఁవొ జా తిలసతె సగుమ్‍జిన్ జా కోడు సూన కెర, “ఆదె, ఏలీయా పూర్గుమ్‍చొక బుకార్తయ్, కిచ్చొగె” మెల. ");
INSERT INTO key_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","జోవయింతె ఎక్కిలొ నిగ గెచ్చ, బూంజు రితి తిలి ఏక్ వస్తువ వెంట, అమ్‌డి ద్రాచ రస్సుమ్‍తె బుడ్డవ కెర, ఏక్ రివ్వతె బంద, చాంప కెర, జోక “పి” మెన దా, “అల్లె, ఇన్నెక సిలువ తెంతొ ఉత్రవుక మెన ఏలీయా తోడ్ జా ఉత్ర జెయెదె గే, నాయ్ గే దెకుమ!” మెన కొంకడ్లన్. ");
INSERT INTO key_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","జలె, యేసు గట్టిఙ కేక్ గల దా, ప్రానుమ్ ముల దిలన్. ");
INSERT INTO key_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","మొర గెలి గడియయ్, దేముడుచి గుడితె ఒడొవ తిలి తెర, ఉప్పిర్ తెంతొ ఎట్టొ ఎద చిరి జా దొన్ని గండల్ జా గెలి. ");
INSERT INTO key_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","తెదొడి, యేసుక మొక్మె రక తిలొ పుంజెక్‍జీన్ జమాన్లుక వెల్లొ యేసుక మొర గెలొ మెన దెక కెర, “నిజుమి, ఈంజొ మాన్సు దేముడుచొ పుత్తుసి జా తిలొ” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","యేసు మొర్లి పొది, సగుమ్‍జిన్ తేర్‍బోదల్ దూరి తెంతొ దెకితె తిల. జోవయింతె సగుమ్‍జిన్ కొన్స మెలె, మగ్దలేనే పట్నుమ్‍చి మరియ మెలి ఎక్లి, దకిలొ జలొ యాకోబు అన్నె యోసే మెల ఉబెడల్‍చి మరియ మెలి అయ్యసి, పడ్తొ సలోమే మెలి ఎక్లి తిల. ");
INSERT INTO key_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","యేసు తిలి ప్రాంతుమ్‍తె బుల్తె తిలి పొది, ఈంజేఁవ్ తీగ్ల జోవయించి పట్టి గెచ్చ సవ్రెచన కెర్తె తిల. యేసు యెరూసలేమ్‍తె ఉట్ట అయ్‍లి పొది అన్నె ఒగ్గర్‍జిన్ తేర్‍బోదల్ కి జా తిల. జో మొర్లి పొది, జేఁవ్ కి సిలువ తిలిస్‍తె రకితె తిల. ");
INSERT INTO key_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","యూదుల్‍క బక్తి కెర్తి సెలవ్ కడన్లి దీసి జయెదె, జలె జా దీసి సెలవ్ కడన్లి దీస్‍క అగ్గెచి దీసి. ");
INSERT INTO key_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","జలె సాంజ్ జలి పొది, యూదుల్‍చి వెల్లి సబతె బెదితొ ‘చెంగిలొ మాన్సు’ మెన ఎత్కిజిన్ జాన్‍తొ, అరిమతయ్ గఁవ్విచొ యోసేపు, దయిరిమ్ కెరన, పిలాతుతె గెచ్చ, “యేసుచి పీనుమ్ జోక దా” మెన వెంట గెల్తి రిసొ నఙిలొ. జో యోసేపు, ‘దేముడుచి రాజిమ్ ఈంజ లోకుమ్‍తె ఏలుప కెర్తి కాలుమ్ కెఁయఁక జెయెదె.’ మెన, నిదానుమ్ తెన్ రకితె తిలొ. ");
INSERT INTO key_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","జలె, పిలాతు “జో తెద్ది బేగి మొర గెలన్ గె?” మెన అన్మానుమ్ జా, పుంజెక్‍జీన్ జమాన్లుక వెల్లొక బుకారా, “నిజుమి జో తెద్ది బేగి మొర గెచ్చ అస్సె గే?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","“నిజుమి మొర గెచ్చ అస్సె” మెన జో పుంజెక్‍జీన్ జమాన్లుక వెల్లొచి అత్తి సూన, యోసేపు పీనుమ్ వెంట గెలుక మెన పిలాతు సెలవ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","జాకయ్, జో విలువచి బట్ట ఆన, యేసుచి పీనుమ్ సిలువ తెంతొ ఉత్రవ దా, జో పాలుమ్ పంగ్రవ దా, రంగ్ని పత్తుర్ డొల్మి కెరయ్‍లి బొరొచి మెస్సున్‍తె ఎంగ్డవ దా, జా బొరొచి గుమ్ముమె వెల్లొ పత్తురు ఒస్కవ కెర డంకిలన్. ");
INSERT INTO key_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","కేనె ఎంగ్డవ దా వెంట గల గే, మగ్దలేనే పట్నుమ్‍చి మరియ మెలిసి కి, యోసే మెలొసొచి మరియ మెలి అయ్యసి కి దెకిల. ");
INSERT INTO key_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","సెలవ్ కడన్లి దీసి కేడ గెలి రాతి, మగ్దలేనే పట్నుమ్‍చి మరియ, యాకోబుచి అయ్యసి మరియ, సలోమే తెన్, యేసుక గాంసుక మెన, చెంగిల్ వాసెన తేల్ గెనన్ల, చి ");
INSERT INTO key_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","జా అయ్‍తర్ దీసి ఒగ్గర్ పెందలె ఉట్ట, బార్ జా, పొద్దు బార్ జలి సమయుమి జా మెస్నె పాఁవ, ");
INSERT INTO key_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","“మెస్నె డంపిలొ పత్తుర్ అమ్‍చి రిసొ కో ఒస్కవ దెవుల గె?” మెన ఎక్లి తెన్ ఎక్లి లట్టబ్తె తిల. ");
INSERT INTO key_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ఇసి లట్టబ లట్టబ, ఉప్పిరి దెక, పత్తురు ఒస్క జా అస్సె మెన దెకిల. జో పత్తుర్ ఒగ్గర్ వెల్లొచొ. ");
INSERT INTO key_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","తెదొడి, మెస్నె గెచ్చ పెస, కిచ్చొ దెకిల మెలె, జా మెస్నె తెడిచి ఉజెతొ పక్క, చొక్కిల పాలల్ గలన తిలొ ఉబెడొ రితొ దేముడుచి దూత వెస అస్సె. జోక దెక, ఆచారిమ్ జా పంబ్ర జల. ");
INSERT INTO key_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","జేఁవ్ ఇసి జతికయ్, జో దేముడుచి దూత జోవయింక “పంబ్ర జా నాయ్. సిలువతె గల మొర తిలొ నజరేతు గఁవ్విచొ యేసుక తుమ్ చజితసు. జో జీవ్ జా ఉట్ట అస్సె. జో ఇన్నె నాయ్. ఈందె జోక ఎంగ్డవ తిలి టాన్‌క అంకి గల.” ");
INSERT INTO key_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","అన్నె, సిస్సుల్‍క, పేతురుక “తుమ్‍చి కంట అగ్గెతొ, యేసు గలిలయతె ఉట్ట గెతయ్. తుమ్‍క జో అగ్గె సంగిలి రితి, జోక ఒత్త దెకితె మెన తుమ్ గెచ్చ సంగ” మెన దూత సంగిలన్. ");
INSERT INTO key_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","జేఁవ్ తేర్‍బోదల్ బమ్మ తెన్ మెస్నె తెంతొ బార్ జా, సిస్సుల్‍క జా కబుర్ సంగుక ఉట్ట నిగ గెల. గట్టిఙ ఆచారిమ్ జా, అద్దుర్ జా గెచ్చ తిల, చి బియఁ కెర, సిస్సుల్‍క పిట్టవ, కక్క కి కిచ్చొ సంగితి నాయ్. ");
INSERT INTO key_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","యేసు అయ్‍తర్ దీసి జీవ్ జా ఉట్ట, జా దీసి పెందలె మగ్దల పట్నుమ్‍చి మరియక తొలితొ డీసిలన్. ఒగ్గర్ అగ్గె, జాచిక దెర్ల బూతల్‍క యేసు ఉదడ గెల తిలన్. జా తేర్‍బోద ఈంజయి. ");
INSERT INTO key_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","జలె, యేసు జాక డీస్తికయ్, జా జో తెన్ బుల్తె తిల సిస్సుల్ జివ్వి అస్సె మెన నేన కెర దుకుమ్ జా ఏడ్తె అస్తి, మెన జా జాన కెర, జా మాన్సు జోవయింతె గెచ్చ కెర, “జీవ్ జా అస్సె. ఆఁవ్ సొంత దెక అస్సి” మెన సాచి సంగిలి. ");
INSERT INTO key_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","గని జో జీవ్ జలిసి జా దెకిలిసి సూన్లె కి, తెదొడి నంప కెర్తి నాయ్. ");
INSERT INTO key_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ఒత్త తెంతొ, బయిలుచి వట్టె దొగుల సిస్సుల్ ఇండ గెతె తతికయ్, యేసు, జోచి పోలిక ఇదిల్ వేర మార్సుప జా తా, జోవయింక డీసిలన్. ");
INSERT INTO key_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","తెదొడి జేఁవ్ దొగుల అన్నె బుల గెచ్చ, అన్నె సిస్సుల్‍క సంగిల. గని జేఁవ్ అన్నె సిస్సుల్ తెదొడి నంప కెర్తి నాయ్. ");
INSERT INTO key_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","జాచి పిమ్మట్, ఎగరజిన్ సిస్సుల్ అన్నిమ్ కంక వెస తిలి పొది, యేసు జోవయింక డీసిలన్, చి గోల కెర్లన్. జో జీవ్ జలి పిమ్మట్ జోక దెక తిలస, జోక సాచి సంగ తిలె కి, జేఁవ్ రాడ్ జీవ్ తెన్ తిలి రితి అన్మానుమ్ జా నంప నే కెర్లి రిసొ గోల కెర్లన్. ");
INSERT INTO key_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","తెదొడి యేసు సిస్సుల్‍క, “తుమ్ దేసిమ్‍లు ఎత్కితె గెచ్చ, లోకుమ్‍చ ఎత్కిక అంచి రిసొ సుబుమ్ కబుర్ బోదన కెర. ");
INSERT INTO key_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","కో నంపజఁయి గెచ్చులచి బాప్తిసుమ్ నఙనుల గే, జేఁవ్ రచ్చించుప జవుల. గని కో నంప నే జవుల గే, మొర గెలె, సిచ్చతె గెచ్చుల. ");
INSERT INTO key_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","“అంక నంపజతస తెన్ అంచి అదికారుమ్ అస్సె మెన కీస గుర్తులు తయెదె మెలె, అంచి నావ్ తెన్ బూతల్‍క ఉదడ గెలుల, జేఁవ్ అగ్గె నే సికిల బాసల్ తెన్ లట్టబుల, ");
INSERT INTO key_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","అయివొక ఉక్ల దెర్లె జవుస్, మొర్తిసి పిల్లె జవుస్, జోవయింక ప్రమాదుమ్ జయె నాయ్. అన్నె, జొర్జొ జబ్బుల్ తెన్ తిల మాన్సుల్‍క అంచి నావ్ తెన్ బోడి చడిలె, చెంగిల్ జవుల.” ");
INSERT INTO key_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ప్రబు జలొ యేసు, జలె, సిస్సుల్ తెన్ లట్టబ బోదన కెర కేడయ్‍లి ఇదిల్ పడ్తొ, జోవయించి మొక్మె ఆగాసుమ్‍తె వెగ, పరలోకుమ్‍తె దేముడు అబ్బొస్‍చి ఉజెతొ పక్కయ్ వెసిలన్. ");
INSERT INTO key_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","అన్నె, జో సంగిలి రితి, సిస్సుల్ కేనె ఒత్త గెచ్చ బోదన కెర్తె తతికయ్, ప్రబు జోవయింక తోడ్ తా జేఁవ్ సిస్సుల్‍చి అత్తి వెల్లొ కమొ కెరవ కెరవ, జేఁవ్ సంగిలి చి సత్తిమ్‍క రుజ్జు దెకయ్‍లన్.");
INSERT INTO key_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","యేసుక్రీస్తు ఈంజ లోకుమ్‍తె అయ్‍లిసి, జో ఇన్నె తిలి పొది అమ్‍చితె ఎత్కి జర్గు కెర్ల కమొ ఎత్కి మొదొల్ తెంతొ సగుమ్‍జిన్, సొంత దెక సాచుల్ జా, జా ఎత్కిచి రిసొచి సుబుమ్ కబుర్ సూనయ్‍త సేవ కెర్తస జల. ");
INSERT INTO key_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","జలె, జో యేసుక్రీస్తు అయ్‍లిసి తెన్ నెరవెర్సుప జలిసి ఎత్కిచి రిసొ జేఁవ్ సాచుల్ అమ్‍క జాన కెర అస్తి, అమ్‍చి అత్తి జా సుబుమ్ కబుర్ దా అస్తి, చి యేసు తెన్ జర్గు జలిస్ ఎత్కిచి మత్తెలితెచ బెదవ ఒగ్గర్‍జిన్ రెగ్డ అస్తి. ");
INSERT INTO key_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","జలె, ఓ వెల్లొ దెయొపిలా, ఈంజ ఎత్కి సూన ఆఁవ్ సరిగా పరిచ్చ కెర అస్సి, చి తుక ‘జో సూన్లిస్‍చి రిసొ సత్తిమ్ చినుస్’ మెనయ్, తుచి రిసొ ఈంజ ఎత్కి వర్స తెన్ ఆఁవ్ రెగుడుక అంక చెంగిల్ డీస్తయ్, చి ఇన్నె రెగ్డితసి. ");
INSERT INTO key_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","హేరోదు రానొ యూదుల్‍చి ఒండి దేసిమి ఏలుప కెర్తె తిలి పొది, దేముడుచి గుడితె జోచి సేవ కెర్తొ పూజరి జలొ జెకర్యా మెలొ ఎక్కిలొ తిలన్. పూజర్లుతెచొ అబీయా పూర్గుమ్‍చొచి తెగచొ జో. జోచి తేర్సి, అహరోను పూర్గుమ్‍చొ జలొ యూదుల్‍చొ తొలితొచొ ఎత్కిక వెల్లొ పూజరిచి సెకుమ్‍తెచి తేర్‍బోద జా తిలి. జాచి నావ్ ఎలీసబెతు. ");
INSERT INTO key_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","జేఁవ్ దొగుతెర దేముడుచి కోడు తెన్ సత్తిమ్ ఇండితె తిల. నే పిట్టయ్‍తె నెంతె దేముడు దిల ఆగ్నల్ ఎత్కి తెన్ నాయిమ్ ఇండితె తిల. ");
INSERT INTO key_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","గని ఎలీసబెతు గొడ్డు జా తిలి రిసొ జోవయింక బోదల్ నాయ్. జేఁవ్ ఒగ్గర్ వెర్సుల్ వయసుచ మంత్రొ మంతిరి జా తిల. ");
INSERT INTO key_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","జెకర్యా తిలి తెగచ పూజర్లు దేముడుచి గుడితె సేవ కెర్తి కాలుమ్ జా తిలి, చి జెకర్యా దేముడుచి జా సేవ కెర్తె తిలి పొది, ");
INSERT INTO key_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","దేముడుచ పూజర్లుతె కీసి కెర్తతి గే, దస్సి జొయ్యి జో ప్రబు జలొ దేముడుచి గుడితెచి దూపుమ్ డయుక మెన చీట్లు గల్‍క జోచి నావ్ సేడ్లి. ");
INSERT INTO key_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","దూపుమ్ డయిలి పొది ప్రెజల్ ఒండిజీన్ దేముడుచి గుడిచి కోటచి తెడి బయిలె ప్రార్దన కెర్తె తిల. ");
INSERT INTO key_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","తెదొడి దేముడు ప్రబుచొ దూత ఎక్కిలొ జా దూపుమ్ డయితి టాన్‍చి ఉజెతొ పక్క టీఁవ డీసిలన్. ");
INSERT INTO key_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","జెకర్యా జో దూతక దెక కెర బేగి బమ్మ జా బియఁ గెలన్, ");
INSERT INTO key_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","గని దూత జోక, “జెకర్యా, తుయి బి నాయ్. తుయి కెర్లి ప్రార్దన దేముడు సూన అస్సె. చి తేర్ది ఎలీసబెతు తుక పుత్తు పాయ దెయెదె. జోక ‘యోహాను’ మెన నావ్ తిస్తె. ");
INSERT INTO key_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","జో బోద జెర్మిలె తుయి సర్దసంతోసుమ్ జస్తె. అన్నె ఒగ్గర్‍జిన్ కి జా సర్ద జవుల. ");
INSERT INTO key_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","పడ్తొ, ప్రబుచి కామ్ కెర్తసతె జోక ‘వెల్లొ’ మెన ప్రబు దెకెదె. అంబడ్లి ద్రాచ రస్సుమ్ కి, కిచ్చొ మచ్చితి సూరు కి జో పియె నాయ్. చి జో దేముడుచి సుద్ది తిలి ఆత్మ జోచి పెట్టి బెర తయెదె; అయ్యస్‍చి పెట్టి జో తిలి మొదొల్ తెంతొ కి. ");
INSERT INTO key_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ప్రబు జలొ జో జోక దేముడుక జేఁవ్ అన్నె సత్తిమ్ కెరుక దెర్తి రితి జో యోహాను ఒగ్గర్‍జిన్ ఇస్రాయేలుల్‍క దేముడుచి పక్క పస్లయెదె, ");
INSERT INTO key_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","చి ఏలీయా పూర్గుమ్‍చొక తిలి ఆత్మసెక్తి, ప్రబుచ కబుర్లు సంగితి ఆత్మసెక్తి, యోహానుచి పెట్టి తయెదె చి, ప్రబుచి పుర్రె జో గెచ్చెదె. పుర్రె గెచ్చ అబ్బదింసి జోవయించ బోదల్‍క అన్నె చెంగిల్ దెకిత్ రితి జోవయింక పసులవెదె, అన్నె బుద్ది సుదల్‍చి గ్యానుమ్ జేఁవ్ సూన్‍తి రితి దేముడుచి నీతి కోడు తెన్ అగ్గె నెసిలసక పసులవ దెయెదె. కిచ్చొక మెలె, ప్రబుచి సేవ జేఁవ్ కెర్తి రితి మాన్సుల్‍క తెయార్ కెర్తి రిసొయి” మెన దూత జెకర్యాక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","గని, “ఈంజ కోడుచి సత్తిమ్‍క అంక కిచ్చొ రుజ్జు? ఆఁవ్ మంత్రొ మాన్సు, చి అంచి తెర్ని ఒగ్గర్ వెర్సుల్‍చి మంతిరి” మెన జెకర్యా అన్మానుమ్ సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","దూత జోక కిచ్చొ జబాబ్ దిలన్ మెలె, “ఎత్కి అదికారుమ్ తిలొ దేముడుచి పుర్రెతొ టీఁవ్‍తొ జోచి సేవ కెర్తొసొ ఆఁవ్. అంచి నావ్ గబ్రియేలు. తుక ఈంజ కోడు ఆఁవ్ సంగుక మెన, తుక ఈంజ సర్దచి కబుర్ ఆనుక మెన, దేముడు అంక తెద్రయ్‍లొ. ");
INSERT INTO key_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ఈందె, సూను, ఆఁవ్ సంగిల కొడొ తుయి నంప కెర్లది నాయ్ చి రిసొ, జా ఎత్కి జర్గు జతి ఎద తుయి గుల్లొ జా తస్తె. జేఁవ్ కొడొ కచితుమ్ దేముడు దిలి కాలుమ్‍కయ్ ఎత్కి జర్గు జయెదె” మెన దూత జబాబ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","జలె, మదెనె, జెకర్యా అన్నె బార్ జతిస్‍క ప్రెజల్ రకితె తిల. దేవులుమ్‍తె జో ఆల్సిమ్ తా గెలి రిసొ ఆచారిమ్ జల. ");
INSERT INTO key_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","జలె, జో బార్ జలె, జోవయింతెన్ లట్టబుక నెతిర్లి రిసొ, ‘దేముడుచి గుడితె కిచ్చొ జవుస్ డీసన్ సేడ్లిస్ దెకిలన్’ మెన చినిల, అన్నె, గుల్లొ జా తా అత్తొ తెన్ జోవయింక సయ్‍నల్ కెర్లన్. ");
INSERT INTO key_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","అన్నె, జోచి సేవచ దీసల్ బెర జోచి సేవ కెర కేడవ కెర, గెరి ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","సగుమ్ దీసల్ గెలి పడ్తొ, జోచి తేర్సి ఎలీసబెతు అంగి జలి, అన్నె పాఁచ్ జొన్నొ ఎద లుంకిల్ రితి జా గెరి తాఁ గెలి. ");
INSERT INTO key_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“ఆఁవ్ మంతిర్ జా అయ్‍లి పొది ప్రబు అంక చెంగిల్ దెక చెంగిల్ వరుమ్ దా అస్సె. అంక ‘గొడ్డు జా అస్సె’ మెన మాన్సుల్ అగ్గె ఆఁస్తె తిల, గని అప్పె అంగి జా అస్సిచి మరియాద అయ్‍లి. దేముడుచి దయక అంక మరియాద దిలొ. అంచి అవమానుమ్ కడ గెలొ.” మెన ఎలీసబెతు సర్ద తెన్ తిలి. ");
INSERT INTO key_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ఎలీసబెతు అంగి జా సొవ్వు జొన్నొ జతికయ్, దేముడు జో గబ్రియేలు మెలొ దూతక గలిలయ ప్రాంతుమ్‍చి నజరేతు మెలి గఁవ్వి కబుర్ తెద్రయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","యూదుల్‍చొ దావీదు పూర్గుమ్‍చొచి సెకుమ్‍చొ యోసేపు మెలొ ఎక్కిలొక పెండ్లి కెరుక మెన అయ్యసిఁసి సంగ తిలి విడ్డి బోదతె తెద్రయ్‍లన్. జా విడ్డి బోదచి నావ్ మరియ. ");
INSERT INTO key_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","జలె, జో దూత జాతె జా కెర, “ఓ మరియ, తుక జొఒర, తుయి సంతోసుమ్ జా. ఎత్కి అదికారుమ్ తిలొ దేముడు తుక చెంగిల్ దెక అస్సె. తుక చెంగిల్ వరుమ్ దెతయ్. జో తుక తోడు అస్సె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","గని జా నాడి ఈంజ కోడు సూన బలే ఆచారిమ్ జా ఇదిల్ బాద సేడ కిచ్చొ కెరుక గే నేన కెర, “ఈంజ కోడుచి అర్దుమ్ కిచ్చొ?” మెన ఉచరన బియఁ గెలి. ");
INSERT INTO key_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","“మరియ, తుయి బి నాయ్. కిచ్చొక మెలె, ఎత్కి అదికారుమ్ తిలొ దేముడు తుక దయ దెక అస్సె. ");
INSERT INTO key_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ఈందె, సూను, తుయి అంగి జస్తె. పుత్తు పాయితె, చి జో బోదక ‘యేసు’ మెన నావ్ తిస్తె. ");
INSERT INTO key_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","జో ముక్కిమ్ జయెదె, చి ‘ఎత్కిచి ఉప్పిరి తిలొసొచొ పుత్తుసి’ మెన జోచి రిసొ సంగుల. అన్నె, దావీదు రానొచి సెకుమ్‍తె జెర్మెదె, చి జో ఒగ్గర్ పూర్గుమ్ తిలొ ముచ్చొతాతొస్ జలొ రిసొ దావీదుచి సింగాసనుమ్‍తె జో వెసయెదె జోచి రాజిమ్‍క జో ఏలుప కెర్తి రితి ప్రబు జలొ దేముడు దెయెదె. ");
INSERT INTO key_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","యాకోబు పూర్గుమ్‍చొచి సేకుమ్‍చచి ఉప్పిరి జో కెఁయఁక తెఁయఁక ఏలుప కెరెదె. జోచి రాజిమ్ కెఁయఁక కి అంతుమ్ జయె నాయ్” మెన మరియక జో దూత సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","దూత దస్సి సంగితికయ్, మరియ జోక, “ఈంజ కీసి అంక జర్గు జయెదె? ఆఁవ్ మున్సుక నే గెలి మాన్సు, గెద” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","దూత జాక, దేముడుచి సుద్ది తిలి ఆత్మసెక్తి తుచి పెట్టి జెయెదె. జో ఎత్కిచి ఉప్పిరి తిలొసొచి ఆత్మసెక్తి తుచి సుట్టునంత జోచి నీడ సెక్తి డంక తయెదె. జాచి రిసొ, తుచి పెట్టి జెర్ముక తిలొ బోదక “పూర్తి దేముడుచి సుద్ది తిలొసొ, జోచొ సొంత పుత్తుసి” మెనుల. ");
INSERT INTO key_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","అన్నె, “ఈందె, అన్నెక్ కోడు కి సూను. తుమ్‍చి మాన్సు జతి ఎలీసబెతు కి మంతిరి జలి పొది అంగి జా అస్సె, చి పుత్తు పాయెదె. జా అగ్గె గొడ్డు జా తిలిసి అంగి జా అప్పె సొవ్వు జొన్నొ జా అస్సె. ");
INSERT INTO key_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","జలె, కిచ్చొచి రిసొ కి ‘జో జర్గు కెరుక నెత్రె’ మెన అమ్‍చొ దేముడుచి రిసొ సంగుక నెంజె, గెద. జో ఎత్కి తెరె” మెన దూత సంగిలన్. సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","మరియ, “ఆఁవ్, ప్రబుచి సేవ కెర్తొ సుది, తుయి సంగిలిసి అంక జర్గు జవుస్” మెన సంగిలి చి దూత జాచి తెంతొ బార్ జా ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","జలె, ఒగ్గర్ దీసల్ నే గెతె అగ్గె ఏక్ దీసి, మరియ బార్ జా, బే బేగి గెచ్చ యూదయ ప్రదేసిమ్‍చి డొంగుర్ దేసిమ్ పక్కచి ఏక్ గఁవ్వి పాఁవిలన్. ");
INSERT INTO key_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","జెకర్యాచి గెరి గెచ్చ ఎలీసబెతుక దస్సుల్ జా జొకర్లన్. ");
INSERT INTO key_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","మరియ జొకర్లి కోడు ఎలీసబెతు సూన్లి బేగి, జాచి పెట్టి తిలొ బోద డేఁవిలన్. తెదొడి జాచి పెట్టి దేముడుచి సుద్ది తిలి ఆత్మ బెర్తికయ్, ");
INSERT INTO key_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","జా ఆత్మసెక్తిక కిచ్చొ మెన గట్టిఙ అవాడ్ తెన్ ఎలీసబెతు కేక్ గలిలన్ మెలె, “తేర్‍బోదల్ ఎత్కిచి కంట దేముడు తుకయ్ దీవెన దిలన్ అస్సె, చి తుచి పెట్టి జెర్మితొ బోద చెంగిల్‍చొ! ");
INSERT INTO key_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","అంచొ ప్రబుక పాయితి అయ్యసి అంచితె జెంక దేముడు కిచ్చొక వరుమ్ దా అస్సె? ");
INSERT INTO key_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ఈందె, తుయి జొకర్లి కోడు అంచి కంగ్డల్ సూన్లి బేగి అంచి పెట్టి తిలొ బోద సర్దక అంచి పేట్ తెడి డేఁవిలన్. ");
INSERT INTO key_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ఒహొ, దేముడు జాక సంగ తెద్రయ్‍లి కోడుక ‘నిజుమి జర్గు జయెదె’ మెన నంప కెర్లి తేర్‍బోదక చెంగిలి!” మెన ఎలీసబెతు కేక్ గల్తికయ్, ");
INSERT INTO key_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","మరియ జా ఇసి మెలి. అంచి జీవు ప్రబు జలొ దేముడుచి గవురుమ్ కెర్తసి. ");
INSERT INTO key_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","అంచొ రచ్చించుప కెర్తొసొ జలొ దేముడు జర్గు కెర్లిస్‍చి రిసొ అంచి ఆత్మతె సర్ద జతసి. ");
INSERT INTO key_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ఆఁవ్ జోచి సేవ కెర్తొ సుది ఒగ్గర్ దాకు జలెకి, అంక జో చెంగిల్ దెక అస్సె. మెలె, ఈందె, “జాక చెంగిలి” మెన అప్పె తెంతొ యుగల్‍చి ఉప్పిరి యుగల్‍చ మాన్సుల్ అంచి రిసొ దీవెన పాయిలిసి మెన సంగుల. ");
INSERT INTO key_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ఒండి సెక్తి తిలొ దేముడు జోచి దయక అంక గొప్ప కామ్ కెర అస్సె, జోచి నావ్ పరలోకుమ్‍చి సుద్ది తిలిసి. జో సుద్ది తిలిస్‍క జోచి నావ్ కెద్ది గవురుమ్ కెరుక జయెదె! ");
INSERT INTO key_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","యుగుమ్‍చి ఉప్పిరి యుగుమ్‍చ జోక బిత మాన్సుల్‍క జో కన్కారుమ్ దెకితె తయెదె. ");
INSERT INTO key_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","జో అప్పె జర్గు కెర్తిస్ తెన్ కచితుమ్ జోచి ఆతుచి ఒగ్గర్ సెక్తి కమొ కెర కెర, జోచి సెక్తి దెకవ అస్సె. వెల్లొ మెనన్లసచి పెట్టిచ ఆలొసుమ్‍లు పాడ్ కెర, జోవయింక చెదుర్ప కెర అస్సె, ");
INSERT INTO key_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ఏలుప కెర్తసక జోవయించ సిఙాసనల్ తెంతొ సేడవ గెల కెర, విలువ నెంజిల రిత మాన్సుల్‍క జో విలువ దా అస్సె. ");
INSERT INTO key_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","చూ జలసక చెంగిల్ అన్నిమ్ దొర్కు కెర అస్సె, చి సొమ్సార్లుక కిచ్చొ నే దెతె రితి తెద్రవ దా అస్సె. ");
INSERT INTO key_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","అమ్‍చ పూర్గుల్‍క, ముక్కిమ్‍క అబ్రాహామ్ పూర్గుమ్‍చొక, “తుక, చి యుగుమ్‍చి ఉప్పిరి యుగుమ్‍చ తుచి సంతానుమ్ జతసక తోడు తయిందె” మెన జో ప్రమానుమ్ సంగిలన్, గెద, జలె, జా రచ్చనచి రిసొచి ప్రమానుమ్‍చి జోవయించి కన్కారుమ్ నే పఁవ్సితె. ");
INSERT INTO key_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","మరియ ఎలీసబెతు తెన్ తిన్ని జొన్నొ తా కెర గెరి అన్నె ఉట్ట గెలి. ");
INSERT INTO key_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","జలె, ఎలీసబెతుచి కంట్లు పాఁవ అయ్‍లి, చి మున్సుబోద జెర్మిలన్. ");
INSERT INTO key_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","జెర్మితికయ్, దేముడు జాచి ఉప్పిరి కన్కారుమ్ జా అస్సె మెన, జేఁవ్‍చి గేర్ పాసిచ గెరల్‍చ మాన్సుల్‍చి జేఁవ్‍చ అన్నొబావొ చి బందుగులు ఎత్కిజిన్ సూన కెర, జేఁవ్ తెన్ ఒగ్గర్ సర్దసంతోసుమ్ జల. ");
INSERT INTO key_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","జలె, బోద జెర్మ అట్టు పొదుల్ జతికయ్, యూదుడు కెర్తి సున్నతి జో బోదక కెరుక చి, జోక నావ్ తింక మెన ఎత్కిజిన్ బెద అయ్‍ల. ‘జెకర్యా’ మెన అబ్బొస్‍చి నావ్ జో బోదక తిల. ");
INSERT INTO key_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","గని అయ్యసి కిచ్చొ మెలి మెలె, “పోన. జోక ‘యోహాను’ మెన నావ్ తింక అస్సె” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","దస్సి మెంతికయ్, “జేఁవ్ తుమ్‍చ మాన్సుల్‍తె కక్కయ్ జా నావ్ నాయ్. జా నావ్ కీసి తితె!” మెన ఒత్త బెర్లస సంగ కెర. ");
INSERT INTO key_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","“బోదక కిచ్చొ నావ్ తింక?” మెలి రితి అబ్బొస్‍క సయ్‍న కెర్ల. ");
INSERT INTO key_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","రెగిడ్తి ఏక్ బల్ల జో నఙన, “జోచి నావ్ యోహాను” మెన జా బల్లయ్ రెగ్డ దెతికయ్, జేఁవ్ ఎత్కిజిన్ ఆచారిమ్ జల. ");
INSERT INTO key_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","జా నావ్ జెకర్యా రెగ్డ దెకయ్‍లి బేగి, జోక చోండి పుట్లి చి జీబు బులిలి, లట్టబుక దెర తొలితొ దేముడుచి గవురుమ్ సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","జలె, జా జర్గు జలిసి ఎత్కిచి రిసొ జా పల్లెల్‍చ మాన్సుల్ ఎత్కిజిన్ బియిఁ గెల, చి జర్గు జలిస్ ఎత్కిచి రిసొ, జా యూదయ ప్రదేసిమ్‍చి డొంగుర్ దేసిమ్‍చ మాన్సుల్ గాఁవ్వొ ఎత్కితె లట్టబ్తె తిల. ");
INSERT INTO key_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","అన్నె, జర్గు జలిస్‍చి రిసొచ కొడొ సూన్లస ఎత్కిజిన్ మెన్సు చెంగిల్ ఉచర, ‘జో నాడు దేముడుచి అత్తి అస్సె. జొయ్యి జోక తోడు’ మెన చిన కెర, “ఈంజొ బోద వడ్డిలె కిచ్చొ కామ్ కెరెదె, కీసొచొ జయెదె?” మెన ఉచర్తె తిల. ");
INSERT INTO key_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","జలె, యోహానుక నావ్ తిలి గడియ దేముడుచి సుద్ది తిలి ఆత్మ జెకర్యాచి పెట్టి బెర, దేముడు దెతి రచ్చన తెదొడి తెంతొ ఎత్కి జర్గు జంక దెరుక తిలిస్‍చి రిసొ చోండి పుట్టవ జెకర్యా ఇసి మెలన్; ");
INSERT INTO key_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“ప్రబు జలొ అమ్‍చ ఇస్రాయేలుల్‍చొ దేముడుక జొఒర! కిచ్చొక మెలె, జోచయ్ ప్రెజల్ జల అమ్‍చ ఇస్రాయేలుల్‍క అన్నె గెనన రచ్చించుప కెర్తి రిసొ జో ఉత్ర జా అస్సె. ");
INSERT INTO key_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","జోచొ సేవ కెర్తొసొ జలొ దావీదు పూర్గుమ్‍చొచి సెకుమ్‍తె సెక్తి తిలొ రచ్చించుప కెర్తొసొక జో జెర్మవ అస్సె; అమ్‍క రచ్చించుప కెర్సు మెన. ");
INSERT INTO key_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","దస్సి కెరిందె, మెన దేముడుచ కబుర్లు సంగిల పూర్గుల్‍చి చోండి పుట్టవ సంగిలన్, గెద. ");
INSERT INTO key_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","అమ్‍క విరోదుమ్ జల మాన్సుల్ తెంతొ అమ్‍క విరోదుమ్ కెర్తస ఎత్కిజిన్‍చి అత్తి తెంతొ అమ్‍క రచ్చించుప కెరుక మెన జో సంగ అస్సె. ");
INSERT INTO key_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","ఒగ్గర్ అగ్గెచ అమ్‍చ పూర్గుల్‍క ప్రమానుమ్ సంగిలి కోడు జర్గు కెరుకయ్ మెన, జేఁవ్ పూర్గుల్‍తె అమ్‍చొ అబ్రాహామ్ పూర్గుమ్‍చొక ఒట్టు గలన దేముడు సంగిలి నిజుమ్ కోడు నే పఁవ్సితె జర్గు కెరుకయ్ మెన జో ఒప్పన అస్సె, జర్గు కెరెదె! ");
INSERT INTO key_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","ప్రమానుమ్ జర్గు కెర్తిస్‍తె అమ్‍క జో కిచ్చొ గుర్తు దెతయ్ మెలె. అమ్‍క విరోదుమ్ సుదల్ జలసచి అత్తి తెంతొ అమ్ ములవుక జలె, బయిమ్ నెంతె పూర్తి జోచయ్ జా జో దెతి సుద్ది సత్తిమ్ ఇండ అమ్‍చి జీవితుమ్ పూర్తి జోచి సేవ అమ్ కెర్తె తంక వాటు జెయెదె. ");
INSERT INTO key_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","తుయి, పుత్త, తుయి వడ్డిలె తుకయ్ కిచ్చొ మెనుల మెలె, ఎత్కిచి కంట వెల్లొ తిలొసొచి కబుర్ సంగితొసొ జో మెన సంగుల. కిచ్చొక మెలె, ప్రబు జెతికయ్ జోక వాటు తెయార్ కెరవుక తుయి జోచి పుర్రెతొ బుల్తె తస్తె; ");
INSERT INTO key_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","జోచ ప్రెజల్‍క జో ప్రబు రచ్చన దెతిస్‍చి కోడు జాన కెర, కేన్ రచ్చన మెలె, జోచ పాపల్ చెమించుప కెర్తిసి. ");
INSERT INTO key_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","దేముడుచి పెట్టిచి కన్కారుమ్‍చి జోచి దయచి రిసొచి రచ్చన. ఈంజ రచ్చనచి రిసొ, పరలోకుమ్ తెంతొ ఉజిడి అమ్‍చి ఉప్పిరి లగిలి, నొవి దీసి అయ్‍లి రితి అమ్‍క ఉజిడి దెయెదె. ");
INSERT INTO key_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","అందర్‍తె వెసిల, మొర్నుచి నీడతె వెసిల రిత మాన్సుల్‍క దొర్కు జలి ఉజిడి దెతి రిసొయి. జో దెతి రచ్చనచి సేంతుమ్ వాటు అమ్ ఇండితి రితి అమ్‍క వాటు దెకయ్‍తి రిసొయి అమ్‍చొ దేముడు ఈంజ ఉజిడి అమ్‍చి ఉప్పిరి దెకయెదె.” మెన జెకర్యా దేముడుచి సుద్ది తిలి ఆత్మ తెన్ చోండి పుట్టవ సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","జలె, జో బోద యోహాను వడ్డ ఆత్మక డిట్టుమ్ జలన్ అన్నె, జోచ ఇస్రాయేలుల్‍తె జో బార్ జా, జోక దిలి కామ్ మొదొల్ కెరుక మెన దేముడు సంగిలి కాలుమ్ ఎద జో బయిలు దేసిమి తాఁ గెలన్. ");
INSERT INTO key_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","జేఁవ్ పొదులె, ఔగుస్తు మెలొ కైసర్ రానొ రోమ్ దేసిమ్ తెంతొ ఒగ్గర్ దేసిమ్‍లు ఏలుప కెర్తె తిలి పొది, “ఒండి లోకుమ్‍తె కెత్తిజిన్ ప్రెజల్ జవుల గే తుమ్ లెక్క కెర రెగుడ” మెన మాన్సుల్‍క ఆడ్ర దిలన్. ");
INSERT INTO key_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","జేఁవ్ పొదులె కురేనియు మెలొసొ సిరియ దేసిమి అదికారి జా తిలి పొది జా ప్రెజల్ లెక్క కెర్ల. ఇస ప్రెజల్ లెక్కల్ రెగుడుక ఈంజ తొలితొ చి. ");
INSERT INTO key_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","జలె, ప్రెజల్ ఎత్కి కేనెచ మాన్సుల్ ఒత్త జేఁవ్‍చ సొంత టాన్లుతె జేఁవ్‍చ నవ్వొ రెగ్డవనుక గెల. ");
INSERT INTO key_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","దస్సి, యోసేపు దావీదు పూర్గుమ్‍చొచి వంసుమ్‍చొ జోచి తెగచొ మాన్సుచి రిసొ, గలిలయ ప్రాంతుమ్‍చి జో జితె తిలి నజరేతు గఁవ్వి తెంతొ బార్ జా, యూదయ ప్రదేసిమ్‍చి బేత్లెహేమ్ మెంతి గఁవ్వి ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","తేర్సి జతి మరియ తెన్ ప్రెజల్ లెక్కతె ఒత్త జోవయించ నవ్వొ రెగ్డవనుక మెన గెల. జా జలె, అంగి జా తిలి. ");
INSERT INTO key_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","జలె, జేఁవ్ ఒత్త తిలి పొది జాచి కంట్లు పాఁవ అయ్‍లి, చి ");
INSERT INTO key_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","తొల్సుర్ మున్సుబోద లడెస్ జలన్. జోక పాలల్ గుడియవ, జేఁవ్ తిలి సొమ్ముల్ సాడె తిలి సొమ్ముల్ దొవ్నొ పితి దోనెతె పెటెతె నిజవ తిల. ఒత్తయ్ కిచ్చొక మెలె, జా గఁవ్వి జేఁవ్ తంక, కేనె టాన్ విడి నాయ్. ");
INSERT INTO key_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","జలె, జా రాతి జా గాఁవ్‍క పాసి, మెండల్ రకిత గొవుడ్లు సగుమ్‍జిన్ బయిలె మెండల్ రకితె తిల. ");
INSERT INTO key_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","రకితె తిలె, దేముడుచొ, దూత ఎక్కిలొ జోవయింక డీసిలన్, చి జో ప్రబుచి పరలోకుమ్‍చి ఉజిడి జోవయించి సుట్టునంత లగిలి, చి ఒగ్గర్ బియఁ గెల. ");
INSERT INTO key_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","తెదొడి దూత జోవయింక, “తుమ్ బియఁ నాయ్. తుమ్‍క చెంగిల్ కబుర్ ఆన్‍తసి. ప్రెజల్ ఎత్కిక ఒగ్గర్ సర్దసంతోసుమ్ ఆన్‍తి కబుర్, ఈంజ. ");
INSERT INTO key_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ఆజి దావీదు పూర్గుమ్‍చొచి గఁవ్వి తుమ్‍చొ రచ్చించుప కెర్తొసొ జెర్మ అస్సె. కొన్సొ మెలె, క్రీస్తు జలొ ప్రబుయి. ");
INSERT INTO key_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","జోక తుమ్ చినితి రిసొ తుమ్‍క కిచ్చొ గుర్తు దెతసి మెలె, జో బోదక పాలల్ గుడియవ తా జోక ఏక్ సొమ్ముల్ సాడె తిలి సొమ్ముల్ దొవ్నొ పితి దోనెతె నిజవ తవుల” మెన దూత కబుర్ సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","సంగిలి బేగి, పరలోకుమ్ తెంతొ ఒగ్గర్‍జిన్ దూతల్ ఉత్ర జా కిచ్చొ మెన దేముడుచి గవురుమ్ గాయిల మెలె, ");
INSERT INTO key_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“పరలోకుమ్‍తె దేముడుక జొఒర! చి బూలోకుమ్‍తె జో దయ దెకిత మాన్సుల్‍తె జో దెతి సేంతుమ్ ఏలుప కెర్సు!” మెన గనుమ్ గాయిల. ");
INSERT INTO key_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","జలె, దూతల్ జా గనుమ్ గాయ ఉట్ట గెల. చి మెండల్ రకిత జేఁవ్ గొవుడ్లు “బేత్లెహేమ్‍తె గెచ్చుమ, చి ‘జర్గు జలి’ మెన దేముడు అమ్‍క జానయ్‍లిసి దెకుమ. జొమ్మ!” మెన ఎక్కిలొక ఎక్కిలొ సంగన్ల. ");
INSERT INTO key_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","గఁవ్వి బే బేగి నిగ గెచ్చ, మరియక, యోసేపుక, చి సాడెచి సొమ్ముల్ దొవ్నొ పితి దోనెతె నిజ తిలొ బోదక చజ దెకిల. ");
INSERT INTO key_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","జా రుజ్జు దెకిల్ రిసొ, జో బోదచి రిసొ దూత జేఁవ్‍క జానయ్‍లి కోడు ఎత్కి కక్క కక్క, ");
INSERT INTO key_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","జేఁవ్ గొవుడ్లు సంగిలిసి సూన్ల ఎత్కిజిన్ ఆచారిమ్ జా గెల. ");
INSERT INTO key_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","మరియ మాత్రుమ్ ఈంజేఁవ్ కొడొ ఎత్కి జాచి పెట్టితె తియఁ జోచి అర్దుమ్ కిచ్చొ జయెదె గే ఉచర్తె తిలి. ");
INSERT INTO key_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","జలె, మెండల్ రకితసక దూత సూనయ్‍లిసి చి జేఁవ్ సాడె దెకిలిసి ఎక్కి రితి బెదిలి రిసొ దేముడుక జొకర, గవురుమ్ గాయ గాయ, జేఁవ్ రకిత మెండల్‍తె అన్నె ఉట్ట గెల. ");
INSERT INTO key_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","బోద జెర్మ అట్టు పొదుల్ జతికయ్, జోక యూదుడు కెర్తి సున్నతి కెర దిల, చి జోక ‘యేసు’ మెన నావ్ తిల. అయ్యసి అంగి నే జతె అగ్గె ‘యేసు’ మెన నావ్ తిత్తు మెన దూతచి అత్తి దేముడు ఈంజ నావ్ దా తిలన్. ");
INSERT INTO key_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","మోసే పూర్గుమ్‍చొచి అత్తి రెగిడ్లి దేముడుచి ఆగ్నల్ రితి మరియక అన్నె సుద్ది కెర్తి కామ్‍చి దీసి అయ్‍లి పొది, జా కామ్‍క మెన అన్నె యేసుక దేముడుచి టాన్‍తె జోవయించి పుర్రె టీఁవడుక మెన యోసేపు జోక యెరూసలేమ్‍తె దేముడుచి గుడితె కడ నిలన్. ");
INSERT INTO key_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","కిచ్చొక మెలె, మోసే పూర్గుమ్‍చొచి అత్తి దేముడు రెగ్డయ్‍ల ఆగ్నల్‍చి రిసొ, “తొల్సుర్ బోద పుత్తు జలె, జోక ‘ప్రబుకయ్ అర్పితుమ్ దిలొసొ’ మెనుక అస్సె” మెన రెగిడ్లి కోడు. ");
INSERT INTO key_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","జలె, మోసే పూర్గుమ్‍చొచి అత్తి దేముడు రెగ్డయ్‍ల ఆగ్నల్‍తె రెగ్డయ్‍లి రితి, “పూజరిచి అత్తి దొన్ని పన్కొ పిట్టల్ జలెకు, దొన్ని పార్వ పిట్ట పిల్లల్ జలెకు దెంక” మెన రెగిడ్లిసి జర్గు కెరుక మెన, అయ్యస్‍క సుద్ది కెర్తి రుజ్జుక దసచ దెంక జేఁవ్ దేముడుచి గుడితె గెల. ");
INSERT INTO key_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","జలె, జా కాలుమ్ యెరూసలేమ్‍తె ఏక్ మాన్సు తిలన్. జోచి నావ్ సుమెయోను. జో మాన్సు సత్తిమ్ ఇండితొసొ. దేముడుక నిదానుమ్ బక్తి కెర్తొసొ. ‘అమ్‍చ ఇస్రాయేలుల్‍చొ రచ్చించుప కెర్తొసొ కెఁయఁక జెయెదె గె,’ మెన జో దెకితె తిలన్. దేముడుచి సుద్ది తిలి ఆత్మ జో తెన్ తిలి. ");
INSERT INTO key_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","“దేముడుచొ క్రీస్తుక తుయి దెకిలెకయ్ మొర గెతె” మెన జో దేముడుచి సుద్ది తిలి ఆత్మ జో సుమెయోనుక సూనవ తిలన్. ");
INSERT INTO key_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","జలె, ‘క్రీస్తు రచ్చించుప కెర్తొసొ జాఁ అస్సె’ మెన జో జాన్లి రితి, జయ్యి దీసి జో సుమెయోను దేముడుచి గుడితె గెతి రితి దేముడుచి సుద్ది తిలి ఆత్మ జోక పెలవ నెతికయ్, ఒత్త గెలన్. ‘తొల్సుర్ బోద’ మెన మోసే పూర్గుమ్‍చొచి అత్తి దేముడు రెగ్డయ్‍ల ఆగ్నల్‍తె రెగిడ్లి రితి యేసుచి రిసొ కెరుక మెనయ్, జోక అయ్యసిఁసి దేముడుచి గుడి తెడి పాయ ఆన్‍తికయ్, ");
INSERT INTO key_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","జో సుమెయోను జోక దెర పాయ దేముడుచి గవురుమ్ సంగ ఇసి మెన జొఒర కెర్లన్: ");
INSERT INTO key_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“ఓ ప్రబువ, ఆఁవ్ తుచొ గొత్తి సుదొ, అప్పె సేంతుమ్ తెన్ మొర గెతి సెలవ్ తుయి దెతసి, తుయి అంక సంగిలిసి ఎత్కి జర్గు కెర అస్సిస్, ");
INSERT INTO key_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","తుయి తెద్రయ్‍లొ రచ్చించుప కెర్తొసొక దెక అస్సి. ");
INSERT INTO key_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ఈంజ లోకుమ్ ఎత్కిచ ప్రెజల్ దెకిత్ రితి ఈంజ రచ్చన తుయి తెయార్ కెర్లది. ");
INSERT INTO key_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","యూదుల్ నెంజిలస సత్తిమ్ ఇండితి రితి ఈంజొ రచ్చించుప కెర్తొసొచి ఉజిడి వాట్ దెకయెదె, చి తుచయ్ ప్రెజల్ జల అమ్‍చ ఇస్రాయేలుల్‍క జోవయించి ఉజిడి అన్నె గవురుమ్ ఆనెదె.” మెన, సుమెయోను దేముడుచి సుద్ది తిలి ఆత్మసెక్తిక చోండి పుట్టవ సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","జలె, యేసుచి రిసొ సంగిలిస్‍చి రిసొ అయ్యస్ అబ్బొస్ ఆచారిమ్ జా గెల. ");
INSERT INTO key_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","తెదొడి “దేముడుచి దయ తుమ్‍చి ఉప్పిరి తవుస్” మెన సుమెయోను జేఁవ్‍క దీవెన సంగిలన్, చి దేముడుచి సుద్ది తిలి ఆత్మ తెన్ యేసుచి అయ్యస్ మరియక జో సుమెయోను అన్నె ఇసి మెలన్. “ఈందె, ఈంజొ బోదచి రిసొ అమ్‍చ ఇస్రాయేలుల్‍తె ఒగ్గర్‍జిన్ నంపజా రచ్చించుప జవుల. గని ఒగ్గర్‍జిన్ అన్మానుమ్ జా పాడ్ జవుల, దేముడుచి గుర్తుక ఈంజొ టీఁవ్‍దె, చి ఇన్నెచి ఉప్పిరి ఒగ్గర్‍జిన్ విరోదుమ్ లట్టబుల, ");
INSERT INTO key_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ఒగ్గర్‍జిన్‍చి పెట్టిచి బుద్దిక ‘కీసిచి గే’ చినుక జయెదె. ఈంజ ఎత్కిచి రిసొయి జో ఈంజ లోకుమ్‍తె జా అస్సె, తుచి పెట్టి ఏక్ కండా బూసి జయెదె తుక దుకుమ్ జెయెదె,” మెన సుమెయోను మరియక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","జలె, దేముడుచ కబుర్లు సంగితి ‘అన్నా’ మెలి మంతిరి దేముడుచి గుడితె తిలి. జా ఆసేరు పూర్గుమ్‍చొచి తెగచి మాన్సు. పనూయేలు మెలొసొచి దువిసి జయెదె. జా ఒగ్గర్ వెర్సుల్ వయసుచి మంతిరి. జా బాల తతె పెండ్లి జా సత్తు వెర్సుల్ మున్సుస్ తెన్ తిలన్, ");
INSERT INTO key_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","చి రండెలి జా అప్పె చెత్తర్ విస్సొ చెత్తర్ వెర్సుల్ జా తా, దేవులుమ్ నే ముల్తె, చువ్వె తా, రాతి మెద్దెనె ప్రార్దన కెర్తె తా బక్తి కెర్తె తయెదె. ");
INSERT INTO key_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","తెదొడి జయ్యి గడియయ్ మరియయింసితె జా కెర, యేసుచి రిసొ దేముడుక “ఇన్నెక తెద్రవ తుయి దయ కెర్లది” మెన ప్రార్దన కెర్లన్. అన్నె తెదొడి ‘రచ్చించుప కెర్తొసొ కెఁయఁక జా కెర యెరూసలేమ్‍క విడ్దల్ కెరెదె’ మెన రకిత మాన్సుల్ ఎత్కిజిన్‍క “ఈంజొయి జో” మెన యేసుచి రిసొ సంగిలి. ");
INSERT INTO key_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","మోసే పూర్గుమ్‍చొచి అత్తి దేముడు రెగ్డయ్‍ల ఆగ్నల్‍తె రెగ్డయ్‍లిస్‍తెచ జేఁవ్ కెరుక తిల కమొ ఎత్కి కెర కేడవ కెర, గలిలయ ప్రాంతుమ్‍చి జోవయించి సొంత గాఁవ్ జలి నజరేతు గఁవ్వి మరియయింసి అన్నె ఉట్ట గెల. ");
INSERT INTO key_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","జో బోద వడ్డ డిట్టుమ్ జలొ, ఒగ్గర్ బుద్ది సుదొ జలొ, దేముడుచి దయ జోచి ఉప్పీర్ తిలి. ");
INSERT INTO key_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","యేసుచ అయ్యసిఁసి వెర్సు వెర్సు పస్కా పండుగ్‍క యెరూసలేమ్ పట్నుమ్‍తె దేముడుచి గుడితె గెచ్చుక అలవాట్. ");
INSERT INTO key_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","జలె, యేసుక బార వెర్సుల్ జా తిలి పొది జోవయించి అలవాట్‍క పండుగ్‍క ఒత్త గెల. ");
INSERT INTO key_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","జలె, పండుగు కేడ జేఁవ్ గెరి గెచ్చుక బార్ జలె, యేసు యెరూసలేమ్‍తె తాఁ గెలన్, గని అయ్యసిఁసి నేన్‍తి. ");
INSERT INTO key_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","‘యేసు అమ్‍చి తెన్ జెతస తెన్ అస్సె’ మెన ఉచర తా, ఏక్ ఒండి మెద్దెన్‍చి ఎదిలి ప్రయానుమ్ గెలి పడ్తొ, జోవయించ మాన్సుల్‍తె చి గోతుసుదల్‍తె చజిల. ");
INSERT INTO key_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","గని డీసె నాయ్, చి జోక చజన చజన యెరూసలేమ్‍తె అన్నె గెల. ");
INSERT INTO key_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ఒత్త పాఁవిలె, అన్నెక్ దీసి యేసు దేముడుచి గుడితె ఒత్త పండితుల్‍చి నెడిమి పెస తిలొ డీసిలన్. జో జేఁవ్‍చ కొడొ సూన, జేఁవ్‍క ప్రస్నల్ కి పుసితె తిలన్. ");
INSERT INTO key_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ఒత్త తిలస ఎత్కిజిన్ యేసుచ కొడొ, చి జోచ ప్రస్నల్ సూన, జోచి బుద్ది గ్యానుమ్‍చి రిసొ పండితుల్‍క జో దెత జబాబుల్‍చి రిసొ బలే ఆచారిమ్ జతె తిల. ");
INSERT INTO key_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","జలె, దస్సి జతె తతికయ్, అయ్యసిఁసి జోక దెక, జేఁవ్ కి బలే ఆచారిమ్ జల, చి అయ్యసి జోక కిచ్చొ పుసిలి మెలె “కిచ్చొక, పుత్త, అమ్‍క ఇసి అల్లర్ కెర్లది? ఈందె, అబ్బొది ఆఁవ్ గొప్ప దుకుమ్ సేడ ఒండి చజితె తిలమ్” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","యేసు జేఁవ్‍క కిచ్చొ సంగిలన్ మెలె, “అంచి రిసొ కిచ్చొక చజుక? ఆఁవ్ అంచొ అబ్బొచి గెరి తంక మెన తుమ్ నేన్సు గె?” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","జలె, జో సంగిలి కోడు జేఁవ్‍క అర్దుమ్ జయె నాయ్. ");
INSERT INTO key_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","జలె, జోవయింతెన్ యేసు నజరేతు గఁవ్వి అన్నె ఉట్ట గెలన్. చి జోవయింతెన్ జిఁయ జేఁవ్ సంగిల్ కోడు రితి ఇండితె తిలొ. అయ్యసి, జలె, దేముడుచి గుడితె జో సంగిలిసి పెట్టి తియన, ఒత్త జర్గు జలిసి ఎత్కిచి రిసొ జాచి పెట్టి ఉచర్తె తిలి. ");
INSERT INTO key_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","జలె, యేసు ఆఁగ్‍క కి బుద్దిక కి వడ్డిలన్, చి మాన్సుల్ జోక మెన్సితె తిల, చి దేముడుచి దయ జోచి ఉప్పీర్ తిలి. ");
INSERT INTO key_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","తిబెరియ మెలొ కైసర్ రానొ పనర వెర్సుల్ రోమ్ పట్నుమ్ తెంతొ ఒగ్గర్ దేసిమ్‍లు ఏలుప కెర్తె తిలి పొది, జోవయించి తెడి పొంతి పిలాతు యూదయ ప్రదేసిమి అదికారి జా తా, హేరోదు మెలొసొ గలిలయ ప్రాంతుమ్‍తె అదికారి జా తా, జోచొ బావొసి పిలిప్ ఇతూరయ అన్నె త్రకోనీతి మెల ప్రాంతుమ్‍లుతె అదికారి జా తా, లుసానియ అబిలేనే ప్రాంతుమ్‍తె అదికారి జా తా, ");
INSERT INTO key_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","అన్నా మెలొసొ ఎత్కిక వెల్లొ పూజరి జా తా, దూజాంవొస్ జలొ కయప తెదొడి ఎత్కిక వెల్లొ పూజరి జా తిలి పొది, జెకర్యాచొ పుత్తుసి యోహాను బయిలు దేసిమి బుల్తె తిలి పొది, దేముడుచి జో సంగుక తిలి కబుర్ జోక అయ్‍లి. ");
INSERT INTO key_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","జలె, జోచి కబుర్ జో సంగుక దేముడు తియార్తికయ్, “తుమ్‍చి పాపల్‍చి రిసొ తుమ్ దుకుమ్ జా, అమ్‍చొ దేముడు తుమ్‍చి పాపుమ్ చెమించుప కెర్తి గుర్తుక తుమ్ బాప్తిసుమ్ నఙన” మెన యోర్దాను గాడు పాసి ఒండి బుల బుల సాట్ప కెర్తె తిలన్. ");
INSERT INTO key_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","దేముడుచ కబుర్లు సంగిలొ యెసయాచ కోడు రెగిడ్లి పుస్తకుమ్‍తె రెగిడ్లి రితి; “ఎక్కిలొ అంచొ బారికి జా, అంచి అవాడ్ రితొ జా, ప్రబు జెతికయ్ వాటు తిన్నగ కెర్లి రితి తుమ్ ఎత్కిజిన్ బుద్ది జా మెన, బయిలె ప్రదేసిమి తా కేక్ గల సాట్ప కెరెదె. ");
INSERT INTO key_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ఎత్కి డొంగుర్, ఎత్కి మెట్ట, ఎత్కి లోయ సదూనుమ్ జవుల, వంకుడ వట్టొ తిన్నగ జవుల, చి గర్కు తిల వట్టొ మిన్న జవుల, ");
INSERT INTO key_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","దేముడు మాన్సుల్‍క కీసి రచ్చించుప కెరెదె గే ఎత్కిజిన్ దెకుల.” మెన రెగిడ్లి కోడు. ");
INSERT INTO key_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","జలె, జోచి అత్తి బాప్తిసుమ్ నఙనుక మెన బార్ జల ఒగ్గర్‍జిన్ జనాబ్‍క దెక కెర, యోహాను జోవయింక ఇసి మెలన్: “అయివొచి రితి విస్సుమ్ పెట్టి తిలస, తుమ్! దేముడు కెర్తి సిచ్చ పిట్టవనుక ఉచరుక మెన తుమ్‍క సికడ్లొసొ కొన్సొ? ");
INSERT INTO key_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","తుమ్ కెర్తె పాపల్ ముల దా, చెంగిల్ బుద్ది ఇండ, ఆత్మపలితుమ్ దెర. పడ్తొ, ‘అబ్రాహామ్ అమ్‍క అబ్బొ జయెదె చి రిసొ, దేముడు తెన్ బెద అస్సుమ్’ మెన తుమ్‍క తూమ్ ఉచరన సొంత గవురుమ్ సంగుక నాయ్. కిచ్చొక మెలె, దేముడుక ఇన్నెచ పత్రల్ తెన్ అబ్రాహామ్‌చి రిసొ బోదల్‍క జెర్మవుక తెరె, మెన తుమ్‍క ఆఁవ్ సంగితసి. ");
INSERT INTO key_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ఈందె, అప్పె ప్రబు కురాడు వాండి కెర, రూకుక బుంది కండుక, కుర్రడి దెర టీఁవ అస్సె, జలె, చెంగిల్ పలితుమ్ నే దెర్తొ ఎత్కి రూకుక కండ కెర ఆగితె గలుల,” మెన యోహాను జాగర్త బుద్ది సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","జో ఇసి సంగితికయ్, “దస్సి జలె, అమ్ కిచ్చొ కెరుక గే అమ్‍క సంగు” మెన జనాబ్ పుసిల, ");
INSERT INTO key_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","జో జోవయింక కిచ్చొ జబాబ్ దిలన్ మెలె, “కక్క దొన్ని సొక్కల్ తవుల గే, ఎద్గరె సొక్క నెంజిలొసొక ఏక్ దెంక. కక్క అన్నిమ్ తిలె, జో అన్నిమ్ నెంజిలొసొక అన్నిమ్ దెంక.” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","జలె, బాప్తిసుమ్ నఙనుక మెన సిస్తు నఙిత సుంకర్లు కి యోహానుతె అయ్‍ల, చి “గురుబాబు, ఆమ్ కిచ్చొ కెరుక?” మెన పుసిల. ");
INSERT INTO key_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","జో జోవయింక, “తుమ్ కెద్ది సిస్తు నఙుక నాయిమ్ తయెదె గే, తెద్దిలి నఙ. అన్నె ఒగ్గర్ నఙ నాయ్” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","“ఆమ్, జలె, కిచ్చొ కెరుక?” మెన సయ్‍న్యుమ్ సుదల్ పుసిలె, యోహాను జోవయింక, “బియఁడ జవుస్, ఆరిచ నిందల్ కెర జవుస్, కచి ఆస్తి దొర్కు కెరన నాయ్. దస్సి కెర్లె చోర్లి రితి జయెదె. జా పోన, గని తుమ్‍చి నాయిమ్ తెన్ చి జీతుమ్ నఙన, ‘సాలు’ మెన సర్ద తెన్ జియ,” మెన యోహాను సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","‘జెతొ క్రీస్తు జా తయెదె’ మెన ప్రెజల్ ఎత్కి అజ్జ కెరన, యోహానుచి రిసొ “ఈంజొ ఏక్ వేల క్రీస్తు జా తయెదె” మెన పెట్టి ఉచరంతె తతికయ్, ");
INSERT INTO key_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","జో ఇసి మెన జబాబ్ దిలన్. “ఆఁవ్ పానితె తుమ్‍క బాప్తిసుమ్ దెతసి, గని అంచి కంట అదికారుమ్ తిలొసొ జెతయ్. జోచ చట్టొతెచ జోడ్లుచ వాలివొ యిపుక జలెకు అంక విలువ నాయ్. జో, జలె, దేముడుచి సుద్ది తిలి ఆత్మ తెన్, ఆగి తెన్ తుమ్‍క బాప్తిసుమ్ దెయెదె. ");
INSERT INTO key_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","జోచి పూనితి సూపు జోచి అత్తి అస్సె. జోచి కెల్ని సుబ్రుమ్ కెర జోక కామ్‍క జెతి పంటొ గుడ్డ కెర కొట్టుతె కుడవ, కో విజవుక నెతిర్లి ఆగితె పోటు గల డయ గెలెదె,” మెన యోహాను సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ఒగ్గర్ దస దయిరిమ్ కొడొ సంగిత జాగర్త సంగిత కొడొ తెన్ ప్రెజల్‍క దేముడు దెతి రచ్చనచి రిసొ యోహాను సుబుమ్ కబుర్ బోదన కెర్లన్. ");
INSERT INTO key_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","గలిలయ ప్రాంతుమ్‍చొ అదికారి జలొ హేరోదు, జలె, బావొస్‍చి తేర్సి హేరోదియక ఆనన తిలన్, చి అన్నె కిచ్చొ కిచ్చొ గర్చ కమొ ఒగ్గర్ కెర్తె తిలన్. జాచి రిసొ యోహాను జోవయింక గోల కెర్తె తిలన్, చి రిసొ ");
INSERT INTO key_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","అన్నెక్ పాపుమ్ కి కెర్లన్. కిచ్చొ మెలె, యోహానుక జేలి కెర జేల్‍తె గలిలన్. ");
INSERT INTO key_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","జా నే జతె అగ్గె, జలె, ప్రెజల్ ఎత్కిజిన్ బాప్తిసుమ్ నఙన్‍తికయ్, యేసు కి బాప్తిసుమ్ నఙన ప్రార్దన కెర్తె తతికయ్, పరలోకుమ్ ఉగ్డి జలి. ");
INSERT INTO key_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","దేముడుచి సుద్ది తిలి ఆత్మ పార్వ పిట్టచి రితి ఉత్ర జా, జోచి ఉప్పిరి టీఁవిలి, చి “తుయి అంచొ ప్రేమ తిలొ పుత్తు. తుచి రిసొ అంక సర్దసంతోసుమ్” మెన, పరలోకుమ్ తెంతొ అవాడ్ అయ్‍లి. ");
INSERT INTO key_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","యేసు సేవ మొదొల్ కెర్లి పొది, జోచి వయసు పాసి పాసి ముప్పయ్ వెర్సుల్ జా తిలి. యేసుక యోసేపుచొ పుత్తుసి మెంతె తిల. యోసేపు హేలీచొ పుత్తుసి, ");
INSERT INTO key_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","హేలీ మత్తతుచొ పుత్తుసి, మత్తతీయ లేవీచొ పుత్తుసి, లేవీ మెల్కీచొ పుత్తుసి, మెల్కీ యన్నచొ పుత్తుసి, యన్న యోసేపుచొ పుత్తుసి, ");
INSERT INTO key_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","యోసేపు మత్తతీయచొ పుత్తుసి, మత్తతీయ ఆమోసుచొ పుత్తుసి, ఆమోను నాహాముచొ పుత్తుసి, నాహాము ఎస్లిచొ పుత్తుసి, ఎస్లి నగ్గయిచొ పుత్తుసి, ");
INSERT INTO key_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","నగ్గయి మయతుచొ పుత్తుసి, మయతు మత్తతీయచొ పుత్తుసి, మత్తతీయ సిమియచొ పుత్తుసి, సిమియ యోశేకుచొ పుత్తుసి, యోశేకు యోదాచొ పుత్తుసి, ");
INSERT INTO key_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","యోదా యోహన్నచొ పుత్తుసి, యోహన్న రేసాచొ పుత్తుసి, రేసా జెరుబ్బాబెలుచొ పుత్తుసి, జెరుబ్బాబెలు సయల్తీయేలుచొ పుత్తుసి, సయల్తీయేలు నేరిచొ పుత్తుసి, ");
INSERT INTO key_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","నేరి మెల్కీచొ పుత్తుసి, మెల్కీ అద్దిచొ పుత్తుసి, అద్ది కోసాముచొ పుత్తుసి, కోసాము ఎల్మదాముచొ పుత్తుసి, ఎల్మదాము ఏరుచొ పుత్తుసి, ");
INSERT INTO key_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ఏరు యెహోసువచొ పుత్తుసి, యెహోసువ ఎలీయెజెరుచొ పుత్తుసి, ఎలీయెజెరు యోరీముచొ పుత్తుసి, యోరీము మత్తతుచొ పుత్తుసి, మత్తతు లేవీచొ పుత్తుసి, ");
INSERT INTO key_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","లేవీ సిమ్యోనుచొ పుత్తుసి, సిమ్యోను యూదాచొ పుత్తుసి, యూదా యోసేపుచొ పుత్తుసి, యోసేపు యోనాముచొ పుత్తుసి, యోనాము ఎల్యాకీముచొ పుత్తుసి, ");
INSERT INTO key_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ఎల్యాకీము మెలెయాచొ పుత్తుసి, మెలెయా మెన్నచొ పుత్తుసి, మెన్న మత్తతాచొ పుత్తుసి, మత్తతా నాతానుచొ పుత్తుసి, నాతాను దావీదుచొ పుత్తుసి, ");
INSERT INTO key_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","దావీదు యెస్సయిచొ పుత్తుసి, యెస్సయి ఓబేదుచొ పుత్తుసి, ఓబేదు బోయజుచొ పుత్తుసి, బోయజు సల్మానుచొ పుత్తుసి, సల్మాను నయస్సోనుచొ పుత్తుసి, ");
INSERT INTO key_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","నయస్సోను అమ్మినాదాబుచొ పుత్తుసి, అమ్మినాదాబు అరాముచొ పుత్తుసి, అరాము ఎస్రోనుచొ పుత్తుసి, ఎస్రోము పెరెసుచొ పుత్తుసి, పెరెసు యూదాచొ పుత్తుసి, ");
INSERT INTO key_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","యూదా యాకోబుచొ పుత్తుసి, యాకోబు ఇస్సాకుచొ పుత్తుసి, ఇస్సాకు అబ్రాహామ్‍చొ పుత్తుసి, అబ్రాహామ్ తెరహుచొ పుత్తుసి, తెరహు నాహోరుచొ పుత్తుసి, ");
INSERT INTO key_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","నాహోరు సెరూగుచొ పుత్తుసి, సెరూగు రయూచొ పుత్తుసి, రయూ పెలెగుచొ పుత్తుసి, పెలెగు హెబెరు పుత్తుసి, హెబెరు షేలహు పుత్తుసి, ");
INSERT INTO key_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","షేలహు కేయినానుచొ పుత్తుసి, కేయినాను అర్పక్షదుచొ పుత్తుసి, అర్పక్షదు సేముచొ పుత్తుసి, సేము నోవహుచొ పుత్తుసి, నోవహు లెమెకుచొ పుత్తుసి, ");
INSERT INTO key_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","లెమెకు మెతూసెలచొ పుత్తుసి, మెతూసెల హనోకుచొ పుత్తుసి, హనోకు యెరెదుచొ పుత్తుసి, యెరెదు మహలలేలుచొ పుత్తుసి, మహలలేలు కేయినానుచొ పుత్తుసి, ");
INSERT INTO key_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","కేయినాను ఎనోషుచొ పుత్తుసి, ఎనోషు సేతుచొ పుత్తుసి, సేతు ఆదాముచొ పుత్తుసి, ఆదాము దేముడుచొ పుత్తుసి. ");
INSERT INTO key_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","దేముడుచి సుద్ది తిలి ఆత్మ యేసుచి పెట్టి బెర తా, జో యోర్దాను గాడు పక్క ముల దా, జా ఆత్మ జోక పెలవ నెతికయ్, ఒత్తల్‍తొచి బయిలు దేసిమి గెచ్చ, ఒత్త బుల్తె తిలన్. ");
INSERT INTO key_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","జా డొంగుర్ దేసిమి దొన్ని విస్సొ దీసల్ తిలన్‍క సయ్‍తాన్ జోక పాపుమ్ కెరవుక మెన ఉచర, జా దొన్ని విసొ దీసల్ అల్లర్ కెర్తె తిలన్. జేఁవ్ దొన్ని విసొ పొదుల్ గెతికయ్, యేసుక చూ కెర్లి. ");
INSERT INTO key_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","తెదొడి సయ్‍తాన్ యేసుతె జా కెర జోక, “తుయి దేముడుచొ పుత్తుసి జలె, ఈంజొ పత్తురు పోడియొ జతి రితి సంగు” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","యేసు జోక ఇసి సంగిలన్, “మాములుమ్ పోడిచి సెక్తి తెన్ మాన్సుల్ జితి నాయ్. దేముడుచి కొడొతె రెగ్డ అస్సె.” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","తెదొడి సయ్‍తాన్ యేసుక ఒగ్గర్ డోంకుతె కడ నా కెర, ఎక్కి నిమ్సుమ్‍కయ్ జోక ఒండి లోకుమ్‍చ రాజిమ్‍లు దెకవ కెర, ");
INSERT INTO key_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","“ఈంజ ఎత్కిచి ఉప్పిరి ఏలుప కెర్తి అదికారుమ్, ఈంజేఁవ్ రాజిమ్‍లు ఎత్కితె తిలిస్‍చి గవురుమ్ తుక దెయిందె. ఈంజ ఎత్కి అంచి అత్తి అస్సె, కక్క దెయిందె గే అంచి ఇస్టుమ్. ");
INSERT INTO key_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","జాక, తుయి అంక జొకర్లెగిన, తుకయ్ దెయిందె” మెన సయ్‍తాన్ సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","దస్సి సంగితికయ్, యేసు ఇసి మెన జబాబ్ దిలన్, “ప్రబు జలొ తుమ్‍చొ దేముడుకయ్ తుమ్ జొకర. జో ఎక్కిలొచి సేవ తుమ్ కెరుక అస్సె. మెన దేముడుచి కొడొతె రెగ్డ అస్సె.” ");
INSERT INTO key_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","తెదొడి సయ్‍తాన్ యేసుక యెరూసలేమ్ పట్నుమ్‍తె కడ నా కెర, దేముడుచి గుడిచి వెన్గొపుచి ఉప్పిరి జోక టీఁవడ కెర, ఇసి మెలన్, “తుయి దేముడుచొ పుత్తుసి జలె, ఎట్టొతొ డేఁవు. ");
INSERT INTO key_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","కిచ్చొక మెలె, తుయి ప్రమాదుమ్ నే జతి రితి జోచ దూతల్‍క దేముడు ఆడ్ర దా తెద్రయెదె ");
INSERT INTO key_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","తుచ చట్టొ పత్రె నే లయితి రితి జేఁవ్ దూతల్ జోవయించ అత్తొ చంపొ కెర తుక ఉక్కులనుల, మెన దేముడుచి కొడొతె రెగ్డ అస్సె” మెన సయ్‍తాన్ సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","యేసు జోక, “ప్రబు జలొ తుమ్‍చొ దేముడుక పరిచ్చ కెరుక నాయ్ మెన దేముడుచి కొడొతె సంగ అస్సె” మెన యేసు జబాబ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","జలె, సయ్‍తాన్ జేఁవ్ అల్లర్ కెర్త, పరిచ్చ కెర్త కొడొ సంగ కేడవ కెర, ‘అన్నె కెఁయఁక గే అవ్‍కాసుమ్ అయ్‍లె, అన్నె దస్సి అల్లర్ కెరిందె’ మెనయ్ ఉచర, ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","జలె, అబ్బొస్‍చి జోచి దేముడుచి సుద్ది తిలి ఆత్మ పెలవ నెతికయ్ యేసు జో వడ్డిలి గలిలయ ప్రాంతుమ్‍తె అన్నె గెలన్, చి జా ప్రాంతుమ్ ఎత్కితెచ సుట్టునంతచ గఁవ్విలె జోచి రిసొ ఎత్కిజిన్ సూన్ల. ");
INSERT INTO key_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","అన్నె, జా ప్రాంతుమ్‍చ యూదుల్‍చ సబ గెరల్ ఎత్కితె బోదన కెర్తె తిలన్, చి ఎత్కిజిన్ జోచి గవురుమ్ సంగితె తిల. ");
INSERT INTO key_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","జో బాల తతె తెంతొ వడ్డిలి ఒత్తచి నజరేతు గఁవ్వి యేసు అయ్‍లన్, అన్నె, సెలవ్ కడన్లి దీసి యూదుల్‍చి సబ గెరలె గెలన్. రోజుక సెలవ్ కడ దీసి దస్సి సబగేరి గెచ్చుక జోక అలవాట్. జలె, జయ్యి దీసి ఒత్తచి సబగేరి గెచ్చ కెర, దేముడుచి కొడొ సదు కెరుక మెన టీఁవిలన్. ");
INSERT INTO key_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","జలె, దేముడుచ కబుర్లు సంగిలొ యెసయా పుస్తకుమ్‍తెచి కొడొ సదు కెర్సు మెన జోచి అత్తి దిల, చి జా ఉగ్డ కెర, సదు కెర సూనయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“దేముడుచి సుద్ది తిలి ఆత్మ అంచి పెట్టి అస్సె. బీద సుదల్‍క సుబుమ్ కబుర్ ఆఁవ్ సూనయ్‍తి రిసొ జో జోవయించి ఆత్మసెక్తి అంచి బోడి సువ దా అదికారుమ్ దా అస్సె. జేలి జలస విడ్దల్ జతిసి ఆఁవ్ సాట్ప కెర్తి రితి, పడ్తొ గుడ్డి జలస అన్నె దెకితిస్‍చి రిసొ ఆఁవ్ సాట్ప కెర్తి రితి, అన్నె మాన్సుల్ నిస్కారుమ్ కెర్త మాన్సుల్‍చ బాదల్ ఆఁవ్ పిట్టవ దస బాదల్ తెంతొ విడ్దల్ కెర్తి రిసొ, ");
INSERT INTO key_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","‘ఎత్కి అదికారుమ్ తిలొ దేముడు ప్రబు జోచి దయ మాన్సుల్‍క దెకయెదె’ మెన ఆఁవ్ సాట్ప కెర్తి రిసొయి జో అంక తెద్రవ అస్సె” మెన దేముడుచ కబుర్లు సంగిలొ యెసయాచి అత్తి రెగిడ్లి కోడు యేసు సదు కెర సూనవ కెర, ");
INSERT INTO key_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","జా పుస్తకుమ్ డంప కెర, జా సబగేర్‍చొ సేవ కెర్తొస్‍క అన్నె దా కెర, అన్నె వెసిలన్. జా సబగేరి తిలస ఎత్కిజిన్ జోక చెంగిల్ దెకితె తిల. ");
INSERT INTO key_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","తెదొడి జోవయింక, “దేముడుచి కొడొతెచ ఆఁవ్ అప్పె తుమ్‍క సూనయ్‍ల కొడొ ఆజి ఎత్కి జర్గు జంక దెర అస్తి” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","తెదొడి, “చెంగిలొ మాన్సు, ఈంజొ సంగిల కొడొ నిజుమి సత్తిమ్‍చ” మెన జేఁవ్ ఆచారిమ్ సంగ తా, “గని ఈంజొ యోసేపుచొ పుత్తుసి, నెంజె గె?” మెన అన్నె ఇదిల్ అన్మానుమ్ జా సంగిల. ");
INSERT INTO key_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","జలె, యేసు జోవయించి బుద్ది జాన కెర, జోవయింక అన్నె, “డాక్టర్, తుకయ్ తూయి చెంగిల్ కెరను” మెంతె అంక, అన్నె “కపెర్నహూమ్ పట్నుమ్‍తె ఇస దస వెల్లెల కమొ కెర్లన్ మెన తుచి రిసొ సూన అస్సుమ్. ఇన్నె కి తుచి సొంత దేసిమి దస కమొ కెరు మెన అంక సంగితె, కిచ్చొగె?” ");
INSERT INTO key_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","అన్నె, “తుమ్‍క ఆఁవ్ కిచ్చొ కచితుమ్ సంగితసి మెలె, దేముడుచ కబుర్లు సంగితొ కేన్ మాన్సుక కి జోచి సొంత దేసిమ్‍చ మాన్సుల్ ఇస్టుమ్ జతి నాయ్” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","గని తుమ్‍క ఆఁవ్ కిచ్చొ మెంతసి మెలె, ఏలీయా పూర్గుమ్‍చొ తిలి పొది, తిన్ని వెర్సుల్ నర పూర్తి కిచ్చొ పాని పెటె నాయ్. చి ఒండి దేసిమి ఒగ్గర్ కరు జా గెలి. జలె, అమ్‍చ ఇస్రాయేలుల్ అమ్ యూదుల్ మొత్తుమ్‍తె జా పొది ఒగ్గర్‍జిన్ రండెలివొ తిల. ");
INSERT INTO key_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","గని జేఁవ్ మొత్తుమ్‍జిన్‍తె ఎక్లితె కి దేముడు ఏలీయాక తోడు తెద్రయె నాయ్. సీదోను ప్రాంతుమ్‍చి సారెపతు గఁవ్విచి రండెలి ఎక్లితె జోక తోడు తెద్రయ్‍లొ. ");
INSERT INTO key_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","పడ్తొ, దేముడుచ కబుర్లు సంగిలొ ఎలీషాచి కాలుమ్ అమ్‍చ ఇస్రాయేలుల్‍తె వెల్లి రోగుమ్ దెర్ల మాన్సుల్ ఒగ్గర్‍జిన్ తిల. జలె, జోవయింతె కో కి చెంగిల్ జతి నాయ్. గని సిరియ దేసిమ్‍చొ అమ్‍చొ యూదుడు నెంజిలొ నయమానుయి చెంగిల్ జలొ; యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","జలె, యూదుల్‍క నాయ్, గని వేర దేసిమ్‍చక దేముడు చెంగిల్ కెరయ్‍లిస్‍చి రిసొ యేసు సంగిలిసి సూన కెర, జా సబ గెరితె తిల యూదుల్ ఎత్కిజిన్‍క ఒగ్గర్ కోపుమ్ అయ్‍లి. ");
INSERT INTO key_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","జేఁవ్ ఉట్ట జా, యేసుక పట్నుమ్ తెంతొ ఉదడ కెర, జోవయించి పట్నుమ్ టీఁవిలి మెట్టచి కొసా ఎద ఉదడ్ల; ‘ఒత్త తెంతొ గలి జవుస్’ మెన సేడయ్‍తి రిసొ, ");
INSERT INTO key_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","గని యేసు ప్రమాదుమ్ నే జతె జోవయించి నెడిమి తెంతొ బార్ జా జో గెచ్చుక ఉచర్లి వాట్‍క గెలన్. ");
INSERT INTO key_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","తెదొడి జా గలిలయ ప్రాంతుమ్‍చి కపెర్నహూమ్ పట్నుమ్‍తె యేసు ఉట్ట గెచ్చ, సెలవ్ కడన్లి దీసి మెన, సబగేరి గెచ్చ జా పట్నుమ్‍చ యూదుల్‍క బోదన కెర్లన్. ");
INSERT INTO key_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","దేముడు దిలి అదికారుమ్ కొల్ది బోదన కెర్తె తతికయ్, జనాబ్ ఆచారిమ్ జల. ");
INSERT INTO key_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","జలె, జేఁవ్ తిలి సబ గెరి బూతుమ్ దెర్లొ ఎక్కిలొ తిలొ. జో జలె, గట్టిఙ అవాడ్ కెరన కిచ్చొ మెన కేక్ గలన్ మెలె, ");
INSERT INTO key_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“ఓ నజరేతు గఁవ్విచొ యేసుప్రబు, అమ్‍చి తెన్ తుక కిచ్చొ? అమ్‍క పాడ్ కెరుక జా అస్సిస్ గె? తుయి కొన్సొ గే ఆఁవ్ జాని. తుయి దేముడుచి సుద్ది తిలొసొ తుయి, అమ్‍క ములు” మెన కేక్ గల సంగిలొ. ");
INSERT INTO key_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","యేసు, జలె, “తుక్లె తా ఇన్నెక ముల దా గో!” మెన జో మాన్సుక దెర్లి బూతుమ్‍క గోల కెర్లన్. గోల కెర్తికయ్, ఎత్కిజిన్‍చి నెడిమి బూతుమ్ జో మాన్సుక సేడవ దా, జోక ప్రమాదుమ్ నే కెర్తె జోతె తెంతొ బార్ జలన్. ");
INSERT INTO key_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","జర్గు జలిసి ఎత్కిజిన్ దెక ఎక్కిలొక ఎక్కిలొ, “ఇన్నెచి కోడు కిచ్చొ అదికారుమ్‍చి? బూతల్‍క గో! మెన ఆడ్ర దెతయ్, చి జేఁవ్ బార్ జా గెతతి” మెన ఆచారిమ్ జా సంగిల. ");
INSERT INTO key_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","జా దీసి తెంతొ ఒండి ప్రాంతుమ్‍తె జో కెర్ల కమొచి రిసొ జాన్‍ల. ");
INSERT INTO key_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","జలె, యేసు ఉట్ట సబ గెరి తెంతొ బార్ జా సీమోనుచి గెరి గెలన్. జలె, సీమోనుచి అత్తస్‍క జొర్జొ తా ఆఁగ్ ఒగ్గర్ తాత్ తతికయ్, జాక “చెంగిల్ కెరు” మెన జేఁవ్ బతిమాల్ప జా సంగిల, చి ");
INSERT INTO key_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","యేసు జాచి పాసి టీఁవ జొర్జోక గోల కెర్తికయ్, జొర్జొ చట్కున గెలి, చి బేగి జా ఉట్ట కెర, జేఁవ్‍క సవ్రెచన కెర్లి. ");
INSERT INTO key_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","జా సంజె పొద్దు గెతె తతికయ్, కచ మాన్సుల్‍క కిచ్చొ కిచ్చొ జొర్జొల్ తిల గే, యేసుతె జోవయింక కడ ఆన్ల, చి జోవయింతె ఎత్కి మాన్సుక చడ, చెంగిల్ కెర్లన్. ");
INSERT INTO key_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","అన్నె, ఒగ్గర్‍జిన్ మాన్సుల్ తెంతొ బూతల్ బార్ జా, “తుయి, దేముడుచొ పుత్తుసి.” మెన కేక్ గల. గని జేఁవ్ బూతల్‍క యేసు గోల కెర్లన్, అన్నె జేఁవ్ లట్టబుక సెలవ్ దెయె నాయ్. కిచ్చొక మెలె, జోక ‘క్రీస్తుయి’ మెన జేఁవ్ జాన్లి రిసొ. ");
INSERT INTO key_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","రాత్ పాయితికయ్, యేసు బార్ జా కోయి నెంజిలి టాన్‍తె గెలన్, గని ప్రెజల్ జోక చజన జోతె అయ్‍ల, చి “అమ్‍క ముల దా గో నాయ్” మెన జో ఉట్ట గెచ్చుక అడ్డు కెర్క దెకిల. ");
INSERT INTO key_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","జో జోవయింక, “దేముడుచి రాజిమ్‍చి రిసొచి సుబుమ్ కబుర్ ఆఁవ్ అన్నె తిల పట్నాల్‍తె కి సూనపుక అస్సె. ఈంజయ్ కామ్‍కయ్ దేముడు అంక తెద్రవ అస్సె.” మెన జబాబ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","జలె, యూదయ దేసిమ్‍చ సబ గెరలె బుల బుల యేసు బోదన కెర్తె తిలన్. ");
INSERT INTO key_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","జలె ఏక్ దీసి కిచ్చొ జలి మెలె, యేసు గెన్నేసరెతు మెంతి గాడు పాసి టీఁవ తతికయ్, దేముడు దిలి కోడు సూనుక జోవయింక ఇస్టుమ్ అయ్‍లి రిసొ, ప్రెజల్ బెర జా జోచి ఉప్పిరి డంకి జల. ");
INSERT INTO key_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","జలె, గాడు సొడి దొన్ని దోనివొ తిలిసి యేసు దెకిలన్. జాలర్లు జోవయించ జేఁవ్ దోనివొ తెంతొ ఉత్రజాఁత జోవయించ వలల్ దోవితె తిల. ");
INSERT INTO key_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","జేఁవ్ దోనివొతె ఏక్ సీమోను మెలొసొచి, జో సీమోనుచి దోనితె యేసు వెగ కెర, జోక “ఒడ్డు తెంతొ దోని ఇదిల్ పెలవ దేసు” మెన సంగిలన్, చి పెలవ దెతికయ్, యేసు వెస కెర, దోని తెంతొ ప్రెజల్‍క బోదన కెరుక మొదొల్ కెర్లన్. ");
INSERT INTO key_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","యేసు బోదన కెర కేడయ్‍లి పడ్తొ, “దీగు తిలిస్‍తె తుమ్‍చ వలల్ గల చి మొస్స దెర్తె” మెన సీమోనుక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","దస్సి సంగితికయ్, “గురుబాబు, ఒండి సరారాతి వలల్ గల తిలమ్, గని కిచ్చొ దెరుమ్ నాయ్. గని తుయి సంగిలె, అమ్‍చ వలల్ గలుమ్‍దె” మెన సంగ ");
INSERT INTO key_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","గలిల, చి ఒగ్గర్ మొస్స వలతె సేడ్తికయ్, వలల్ కుట్టిత్ రితి జల. ");
INSERT INTO key_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","అన్నెక్ దోనితె తిల జోవయించ గోతుసుదల్‍క “తుమ్ తోడు జా” మెన సయ్‍న కెర్ల. జేఁవ్ తోడు అయ్‍ల, చి జేఁవ్ దొన్ని దోనివొ బెర్తు బెరయ్‍ల, చి దోనివొ బుడ్డుక దెర్ల. ");
INSERT INTO key_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","జర్గు జలిసి జో సీమోను పేతురు దెక కెర, యేసుచి చట్టె సెర్ను సేడ, “ప్రబువ, అంక ముల దా ఉట్ట గో, ఆఁవ్ పాపుమ్ సుదొ” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","కిచ్చొక మెలె, జేఁవ్ దెర్ల మొస్సచి కొట్టె ఎదివాట్ మెన దెక కెర, జో కి, జో తెన్ తిలస ఎత్కిజిన్ కి ఒగ్గర్ ఆచారిమ్ జల. ");
INSERT INTO key_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","దస్సి సీమోను మొస్స దెర్త జట్టుచ జెబెదయిచ పుత్తర్లు యాకోబు చి యోహాను కి, జో తెన్ ఆచారిమ్ జల. యేసు, జలె, “తుమ్ బియఁ నాయ్. అప్పె తెంతొ, మాన్సుల్ అంక నంపజతి రితి జోవయింక కడ ఆన్‍త జాలర్లు తుమ్ జస్తె” మెన సీమోనుక సంగిలన్, ");
INSERT INTO key_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","జలె, దోనివొ ఒడ్డుతె ఒర్గొడ ఆన కెర, ఎత్కి ముల దా, యేసుచ సిస్సుల్ జంక జోచి పట్టి గెచ్చ, జో తెన్ బులుక దెర్ల. ");
INSERT INTO key_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","యేసు ఏక్ గఁవ్వి తిలి పొది, వెల్లి రోగుమ్ బెర్తు తిలొ ఎక్కిలొ ఒత్త అయ్‍లొ, అన్నె, యేసుక దెక సెర్ను సేడ, “ప్రబు, తుక ఇస్టుమ్ తిలె, తుయి అంక చెంగిల్ కెర సుద్ది కెరుక తెర్సి” మెన బతిమాల్ప జా సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","దస్సి సంగితికయ్, యేసు ఆతు చంపొ కెర జోక చడ, “తుయి చెంగిల్ జంక, అంక ఇస్టుమి. తుచి వెల్లి రోగుమ్ గెచ్చ సుద్ది జా” మెన సంగిలన్, చి బేగి జోచి వెల్లి రోగుమ్ గెలి. ");
INSERT INTO key_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","యేసు జోక కిచ్చొ ఆడ్ర దిలన్ మెలె, “కక్క సంగు నాయ్, గని దేముడుచి గుడితె గెచ్చ, ఒత్త సేవ కెర్తొ పూజరితె గెచ్చ, తుచి ఆఁగ్ చెంగిల్ జలిసి జోక దెకవ, మోసే పూర్గుమ్ సంగిలి రితి, తుయి చెంగిల్ సుద్ది జలిసి ఎత్కిజిన్‍క రుజ్జు దెకయ్‍తి రితి, ఒత్త కానుక దేసు.” ");
INSERT INTO key_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","“కక్క సంగు నాయ్” మెన జో మాన్సుక యేసు సంగ తిలె కి, అగ్గెచి కంట అప్పె అన్నె ఒగ్గర్‍జిన్ యేసుచి రిసొ సూన్ల, చి ఒగ్గర్‍జిన్ “యేసుచి బోదన సూనుమ్‍దె” మెన, “అమ్‍చ జొర్జొల్ గెచ్చవెదె” మెన బెర జెతె తిల. ");
INSERT INTO key_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","గని ఎక్కెక్ సుట్లు యేసు కో నెంజిలి టాన్‍తె గెచ్చ ప్రార్దన కెరెదె. ");
INSERT INTO key_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ఏక్ దీసి యేసు బోదన కెర్తె తతికయ్, పరిసయ్యుల్ చి మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస పాసి వెస తిల. ఈంజేఁవ్ గలిలయ ప్రాంతుమ్‍చ చి యూదయ ప్రదేసిమ్‍చి గాఁవ్వొ ఎత్కి తెంతొ చి యెరూసలేమ్ పట్నుమ్ తెంతొ జా తిల. అన్నె, మాన్సుల్‍చ జొర్జొల్ బాదల్ జో గెచ్చవుక మెన యేసు దేముడుచి సెక్తి తెన్ తిలొ. ");
INSERT INTO key_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","జలె, కిచ్చొ జర్గు జలి మెలె, ఓదె, వాతుమ్ జొర్జొ తెన్ తిలొసొ ఉట్టుక నెతిర్లొ మాన్సు ఎక్కిలొక అన్నె మాన్సుల్ అంతుర్నొ తెన్ వయ ఆన, యేసుతె ఆన కెర జోచి చట్టె తిఁయ దెంక మెన వాట్ చజిల. ");
INSERT INTO key_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","గని జనాబ్ ఒగ్గర్‍జిన్ బెర తిలి రిసొ యేసు తిలి గెరి పెసుక వాట్ నాయ్ మెన, ఒర్నె వెగ కెర, జో తిలి గదిచి ఉప్పిర్ ఒర్నెచి వెల్లి బొరొ కెర, జా బొరొ వాట్ ప్రెజల్‍చి నెడిమి యేసుచి పుర్రెతొక జో మాన్సుక అంతుర్నొ తెన్ ఉత్రవ దిల. ");
INSERT INTO key_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","జలె, జేఁవ్ కడ ఆన్ల మాన్సుల్‍చి జో ఉట్టుక నెతిర్లొ మాన్సుచి నముకుమ్ యేసు దెక కెర, “నేస్తము, తుచి పాపల్ చెమించుప జా అస్తి” మెన జో ఉట్టుక నెతిర్లొ మాన్సుక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","జో దస్సి సంగితికయ్, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస చి పరిసయ్యుల్ బమ్మ జా, “ఈంజొ మాన్సు కొన్సొ? ఇసి లట్టబ దేముడుచి విలువ కడ పాపుమ్ కెర్తయ్. దేముడుక పిట్టవ కో కి పాపల్ చెమించుప కెరుక నెతిర్తి!” మెన ఎక్కిలొ తెన్ ఎక్కిలొ లట్టబన్ల. ");
INSERT INTO key_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","జలె, జేఁవ్ అన్మానుమ్ జా లట్టబంతె తిలిసి యేసు పూర్తి జాన కెర, జోవయింక కిచ్చొ జబాబ్ దిలన్ మెలె, “తుమ్‍చి పెట్టి కిచ్చొక దస్సి అన్మానుమ్ తియంతసు? ");
INSERT INTO key_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‘తుచి పాపల్ చెమించుప జా అస్తి’ మెనుక సుల్లు గే, ‘ఉట్ట ఇండు’ మెనుక సుల్లు గే తుమ్ ఉచర. ");
INSERT INTO key_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","జలె, మాన్సు జా జెర్మున్ అయ్‍లయ్ అంక, ఈంజయి లోకుమ్‍తె కి పాపల్ చెమించుప కెర్తి అదికారుమ్ అస్సె మెన రుజ్జు దెకయిందె, మెన జేఁవ్‍క సంగ కెర, ఉట్టుక నెతిర్లొ జో మాన్సుక అన్నె దెక కెర, అల్లె, తుయి ఉట్ట, తుచి అంతుర్నొ వయన ఇండ గెరి గో మెన తుక ఆఁవ్ సంగితసి!” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","బేగి జో మాన్సు, జో ఎంగ్డ తిలిసి ఉక్కుల వయన, దేముడుచి గవురుమ్ సంగ, సంగ గెరి ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","దస్సి జర్గు జతికయ్, ఒగ్గర్ ఆచారిమ్ జేఁవ్ ఎత్కిజిన్‍క దెర్లి, చి “ఆజి బలే ఆచారిమ్‍చి కామ్ దెకిలమ్” మెన దేముడుక గవురుమ్ కెర్ల, చి జోచి సెక్తిచి ఉప్పిర్‍చి బయిమ్ జోవయించి పెట్టి బెర్లి. ");
INSERT INTO key_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ఇన్నెచి పడ్తొ, యేసు బార్ జా ఒత్త తెంతొ గెచ్చ, సిస్తు నఙితొ సుంకరొ ఎక్కిలొక దెకిలొ. జోచి నావ్ లేవీ. జో సిస్తు నఙితి టాన్‍తె వెస తిలన్, చి “అంచి పట్టి జా అంచొ సిస్సుడు తుయి జా” మెన యేసు జోక బుకార్లన్. ");
INSERT INTO key_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","బుకార్తికయ్, సుంకరొ జలొ జో లేవీ, ఉట్ట జోచి కామ్ ఎత్కి ముల దా, యేసుచి పట్టి ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","లేవీ యేసుక గెరి కడ ఆన కెర, జోక వెల్లి విందు దిలన్. సిస్తు నఙితస చి వేర మాన్సుల్ ఒగ్గర్‍జిన్ జోవయింతెన్ అన్నిమ్ కంక వెసిల. ");
INSERT INTO key_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","జలె, పరిసయ్యుల్ చి జోవయింతెన్ బెదిత మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస జా దెక కెర, “సిస్తు నఙితస తెన్ పాపుమ్ కెర్ల సుదల్ తెన్ తుమ్ కిచ్చొక వెస అన్నిమ్ కత్తసు?” మెన యేసుచ సిస్సుల్‍క గోల కెర్ల. ");
INSERT INTO key_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","దస్సి జతికయ్, యేసు జేఁవ్‍క కిచ్చొ సంగిలన్ మెలె, “జబ్బు తెన్ అస్సుమ్ మెన చినన్లస డాక్టర్ అవ్‍సురుమ్, గని జబ్బు నెంజిలసక డాక్టర్ అవ్‍సురుమ్ నాయ్. ");
INSERT INTO key_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","జలె, ‘పాపుమ్ కెర్లొసొ అమ్’ మెన చినంతసక ‘జోవయించి పాపుమ్‍చి రిసొ దుకుమ్ జా ముల దెతు’, మెన జోవయింకయ్ బుకారుక మెన అయ్‍లయ్ గని ‘పాపుమ్ కెర్లొసొ నెంజుమ్, అమ్‍క పున్నిమ్’ మెన ఉచరంతసక బుకారుక నాయ్” మెన జోవయింక యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","జలె, సగుమ్‍జిన్ మాన్సుల్ యేసుక, “యోహానుచ సిస్సుల్ చువ్వె తా ప్రార్దన కెరుక అలవాట్. పరిసయ్యుల్‍చ సిస్సుల్ కి దస్సి కెరుల, గని తుచయ్ సిస్సుల్ కంక పింక జతతి” మెన అన్మానుమ్ తెన్ పుసిల. ");
INSERT INTO key_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","యేసు జోవయింక ఇసి సంగిలన్. “కేన్ పెండ్లితె, జోవయించి నెడిమి పెండ్లిఉబేడొ తిలె పొది పెండ్లి విందుక బుకార్లస చువ్వె తతి రితి కెరుక జయెదె గె? ");
INSERT INTO key_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","జలె, పెండ్లిఉబేడొచి పచ్చెన జలసచి నెడిమి తెంతొ జోక దెర వేరతె కడ నిలె, జేఁవ్ దీసల్‍క జోచ మాన్సుల్ ఏడ ఏడ చువ్వె తవుల” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","యేసు జోవయింక అన్నెక్ టాలి కి సంగిలన్. కిచ్చొ మెలె, “నొవి పాలుమ్ తెంతొ గండ చిర పొర్ని పాలుమ్‍తె మాసిక గల్తి నాయ్. దస్సి కెర్లె, జా నొవి పాలుమ్ చిరి జా తయెదె, చి జా గండ పొర్ని పాలుమ్ తెన్ బెదె నాయ్. ");
INSERT INTO key_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","పడ్తొ జలె, ఒత్త నొవి ద్రాచ రస్సుమ్ పోర్నిచి కాయ తెన్ కో సువితి నాయ్. కిచ్చొక మెలె, జా కాయ పొర్ని జలి రిసొ దస్సితె నొవి ద్రాచ రస్సుమ్ సువిలెగిన, జా కాయ పులుక నెత్రెచి రిసొ జా రస్సుమ్ పొంగుప జలె పొది జా కాయ పుట్టెదె. పుట్టిలె, జా రస్సుమ్ సూఁయి జయెదె, చి కాయ కి పాడ్ జా గెచ్చెదె. ");
INSERT INTO key_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","నొవి ద్రాచ రస్సుమ్ నొవి కాయల్‍తె సువుక అస్సె. ");
INSERT INTO key_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","అన్నె, తొలితొ పొర్ని ద్రాచ రస్సుమ్ పియ తిలె, నొవి ద్రాచ రస్సుమ్‍క కోర్‍ప జతి నాయ్. కిచ్చొక మెలె, ‘నొవిచి కంట పోర్నిచి చెంగిలి’ మెనుల” మెన యేసు టాలి సంగ బోదన కెర్లన్. ");
INSERT INTO key_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ఏక్ సెలవ్ కడన్లి దీసి, యేసు జోచ సిస్సుల్ తెన్ పంటొ పికిలి బుఁయి వాట్ గెతె తా, వాట్ సొడి తిల ఎన్నులు దొన్ని జోవయించ సిస్సుల్ కోడ అత్తొ తెన్ రెగ్డ చొప్ప జేడవ కతె తిల. ");
INSERT INTO key_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","జలె, పరిసయ్యుల్ సగుమ్‍జిన్ పాసి తా యేసుచ సిస్సుల్ కెర్లిసి దెక కెర, “జేఁవ్ దస్సి కెర్లిసి ‘కామ్ కెర్లి రితి జతయ్’ మెన, ఈందె, సెలవ్ కడన్లి దీసి కెరుక నాయిమ్ నెంజిలిసి తుమ్ కిచ్చొక కెర్తసు?” మెన జోవయింక గోల కెర్ల. ");
INSERT INTO key_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","జలె యేసు జేఁవ్‍క కిచ్చొ జబాబ్ దిలన్ మెలె, “పూర్గుమ్ తిలొ దావీదు రానొ, జోక, చి జో తెన్ తిలసక కి చూ కెర్తికయ్, జాచి రిసొ కిచ్చొ కెర్ల గే, కెఁయ తుమ్ సదు కెర్సు నాయ్ గే? ");
INSERT INTO key_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","కిచ్చొ కెర్లిసి మెలె, దావీదు దేముడుచి గుడితె పెస కెర, ఒత్త తిల పూజర్లు దేముడుక అర్పితుమ్ దిల పోడియొ వెంటన, జేఁవ్ పోడియొ పూజర్లుయి కంక జయెదె గని అన్నె కో కంక జయె నాయ్ మెన జాన్లె కి, జేఁవ్ పోడియొ వంట దా, దావీదు కి జో తెన్ తిలస కి నాయిమ్ నెంతె కి కయ్‍ల.” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","తెదొడి జోవయింక అన్నె, “సెలవ్ కడన్లి దీసిచి ఉప్పిరి ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొక అదికారుమ్ అస్సె” మెన జేఁవ్ పరిసయ్యుల్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","అన్నెక్ సెలవ్ కడన్లి దీసి యేసు జా పట్నుమ్‍తెచి యూదుల్‍చి సబ గెరి గెచ్చ పెస బోదన కెర్తె తతికయ్, ఒత్త ఉజిల్ ఆతు లంబ గెలొ మాన్సు ఎక్కిలొ తిలొ. ");
INSERT INTO key_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","జలె, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస చి పరిసయ్యుల్ యేసుక చెంగిల్ దెకితె తిల. కిచ్చొక మెలె, “సెలవ్ కడన్లి దీసి యేసు జో మాన్సుక చెంగిల్ కెరెదె గే నాయ్ గె” మెన దెకుక మెన, రకితె అస్తి. “జోక చెంగిల్ కెర్లెగిన, సెలవ్ కడన్లి దీసి కామ్ కెర్లి రితి జయెదె, చి యేసుక నేరిమ్ వయడుక జయెదె” మెన ఉచర అస్తి. ");
INSERT INTO key_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","గని జేఁవ్‍చి మెన్సుతె ఉచర్లిసి యేసుక ఎర్కె, చి ఆతు లంబ గెలొ జో మాన్సుక కిచ్చొ మెలొ మెలె, “ఇత్తల్ జా ఎత్కిజిన్ దెకిత్ రితి నెడిమి టీఁవ.” మెలన్, చి జో ఉట్ట ఒత్త టీఁవిలన్. ");
INSERT INTO key_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","తెదొడి యేసు జేఁవ్‍క, “సెలవ్ కడన్లి దీసి ఎక్కిలొక చెంగిల్ కెరుక గే కస్టుమ్ కెరుక నాయిమ్? జోవయించి ప్రానుమ్ రచ్చించుప కెరుక గే పాడ్ కెరుక నాయిమ్?” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","సుట్టునంత అంకి గల జోవయింతె ఎత్కి మాన్సుక చెంగిల్ దెక కెర, ఆతు లంబ గెలొ మాన్సుక దెక, “తుచొ ఆతు చంపొ కెరు” మెన సంగిలన్, చి యేసు సంగిల్ రితి జో మాన్సు కెర్తికయ్, జోచొ ఆతు చెంగిల్ జలి. ");
INSERT INTO key_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","పరిసయ్యుల్ చి మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస జర్గు జలిసి దెకిలె, జోవయింక ఒగ్గర్ కోపుమ్ అయ్‍లి, చి “యేసుక కీసి కెరుమ?” మెన ఎక్కిలొ తెన్ ఎక్కిలొ లట్టబన్ల. ");
INSERT INTO key_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","జలె, కిచ్చొ జలి మెలె, జేఁవ్ పొదులె ఏక్ దీసి, ప్రార్దన కెరుక మెన యేసు బార్ జా డొంగ్రె గెలన్. జో ఒండి సరారాతి ఒత్త ప్రార్దన కెర్తె తిలొ. ");
INSERT INTO key_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","జలె, రాత్ పాయితికయ్, యేసు జోవయించ సిస్సుల్‍క బుకారా కెర, జోవయింతె బారజిన్‍క నిసాన, ఈంజేఁవ్ బారజిన్‍క ‘బారికుల్’ మెన నావ్ తిలన్. ");
INSERT INTO key_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","జేఁవ్ కో కో మెలె, ఎక్కిలొ సీమోను మెలొసొ. జోక ‘పేతురు’ మెన యేసు అన్నెక్ నావ్ తిలన్. పడ్తొ పేతురుచొ బావొసి అంద్రెయ. ఒత్త తెంతొ యాకోబు చి యోహాను. ఒత్త తెంతొ పిలిప్ చి బర్తొలొమయి. ");
INSERT INTO key_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","పడ్తొ మత్తయి చి తోమా. ఒత్త తెంతొ అల్పయిచొ పుత్తుసి యాకోబు, పడ్తొ సొంత దేసిమ్ ఏలుప కెరంతి ఆస తిలొ సీమోను మెలొ అన్నెక్లొ, ");
INSERT INTO key_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","యాకోబుచొ పుత్తుసి యూదా, పడ్తొ ఇస్కరియోతు మెలి గఁవ్విచొ యూదా మెలొసొ. ఈంజొ యూదా పడ్తొ యేసుక దెర విరోదుమ్ సుదల్‍చి అత్తి దిలొ. ");
INSERT INTO key_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","జలె, యేసు జో నిసాన్ల బారజిన్ తెన్ డొంగ్రె తెంతొ ఉత్ర జా, సదూనుమ్ తిలి ఏక్ టాన్‍తె టీఁవిల. చి జోచ అన్నె సిస్సుల్ జో తెన్ తిల, చి ఒండి యూదయ దేసిమ్‍చ మాన్సుల్, యెరూసలేమ్ పట్నుమ్‍చ మాన్సుల్, వెల్లి సముద్రుమ్‍చి పాసి తిల తూరు చి సీదోను పట్నల్‍చ మాన్సుల్ ఒగ్గర్‍జిన్ ఒత్త తిల. ఈంజేఁవ్ జోచి బోద సూనుక చి “అమ్‍చ జొర్జొల్ గెచ్చవెదె” మెన జా తిల. ");
INSERT INTO key_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","యేసు బూతల్ ఉదడ, బూతల్ దెర్ల మాన్సుల్‍క చెంగిల్ కెర్లొ. ");
INSERT INTO key_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ప్రెజల్ ఎత్కి యేసుక చడుక మెన అత్తొ చంపొ కెర్తె తిల. కిచ్చొక మెలె, జోక చడిలె, జోతె తెంతొ సెక్తి జెయెదె, చి జా సెక్తిచి రిసొ చెంగిల్ జవుల. జోక చడ్లస ఎత్కిజిన్ దస్సి చెంగిల్ జల. ");
INSERT INTO key_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","యేసు జోచ సిస్సుల్ జల మాన్సుల్‍క చెంగిల్ దెక ఇసి మెన సంగిలన్. “బీద సుదల్ తుమ్‍క చెంగిలి. కిచ్చొక మెలె, దేముడుచి రాజిమ్‍తె తుమ్‍క వాట తయెదె. ");
INSERT INTO key_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","తుమ్ అప్పె చూ జలసక చెంగిలి. కిచ్చొక మెలె, పడ్తొక తుమ్‍క సరిపుచుప జతిసి దొర్కు జయెదె. తుమ్ అప్పె ఏడ్తసక చెంగిలి. కిచ్చొక మెలె, పడ్తొక సర్దక ఆఁస్తె. ");
INSERT INTO key_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“పడ్తొ, ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొక తుమ్ నంప కెర్లి రిసొ మాన్సుల్ తుమ్‍క విరోదుమ్ దెకిలె, తుమ్‍క అమ్‍చి తెన్ బెదుత్ నాయ్ మెన సంగిలె, తుమ్‍క దూసుప కెర్లె, పడ్తొ జోవయింక నంపజా గార్ జల, చి జోవయించి నావ్ కి సంగుక నెంజె, మెన తుమ్‍చి రిసొ మాన్సుల్ సంగిలె, తుమ్‍క చెంగిలి. ");
INSERT INTO key_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","దస్సి జర్గు జతి దీసిక సర్ద సంతోసుమ్‍క తుమ్ నచ్చ. కిచ్చొక మెలె, ఈందె, పరలోకుమ్‍తె తుమ్‍క వెల్లి బవుమానుమ్ దొర్కు జయెదె. తుమ్‍కయ్ మాన్సుల్ కీస అల్లర్ కెరుల గే అగ్గెయ్ దేముడుచ కబుర్లు సంగిలసక కి, జేఁవ్‍క అబ్బదింసి దసయ్ అల్లర్ కెర్ల.” మెన యేసు సంగిలన్. తెదొడి యేసు అన్నె, ");
INSERT INTO key_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“అబ్బవోమ్మ! తుమ్ అప్పె సొమ్సారుమ్ తిలసక కెద్ది నస్టుమ్ జెయెదె! కిచ్చొక మెలె, ఈంజయ్ లోకుమ్‍చి రగుమ్‍చి సుక్కుమ్ పూర్తి దొర్కు కెరన అస్సుస్ ఈంజయ్ లోకుమ్‍తె. ");
INSERT INTO key_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","అబ్బవోమ్మ, తుమ్ అప్పె ఈంజ లోకుమ్‍తె పెట్టి బెరవన్లస, తుమ్ కెద్ది నస్టుమ్ జస్తె! తెదొడ్‍క చూ జస్తె. అబ్బవోమ్మ, తుమ్ అప్పె ఈంజ లోకుమ్‍తె ఆఁస్తస, తుమ్ కెద్ది నస్టుమ్ జస్తె! తెదొడ్‍క ఏడ్తె, ఏడుకుడు జస్తె. ");
INSERT INTO key_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","అబ్బవోమ్మ, ఈంజేఁవ్ చెంగిల మాన్సుల్ మెన తుమ్‍చి రిసొ ఎత్కిజిన్ సంగిలె, తుమ్‍క కెద్ది సంతోసుమ్ జెయెదె! కిచ్చొక మెలె, తుమ్‍క ఈంజేఁవ్ కీసి అప్పె దస్సి సంగితతి గే, దేముడుచ కబుర్లు సంగితసుమ్ మెన అబద్దుమ్‍క సంగిల పూర్గుల్‍క ఇనయించ అబ్బదింసి దస్సి కెర,” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","ఒత్త తెంతొ యేసు అన్నె, “తుమ్ సూన్‍తసక ఆఁవ్ కిచ్చొ మెంతసి మెలె, తుమ్‍చ విరోదుమ్ సుదల్‍క తుమ్ ప్రేమ కెర్తె తా, చి తుమ్‍క విరోదుమ్ కెర్తసక చెంగిల్ దెకితె తా. ");
INSERT INTO key_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","తుమ్‍క సాపెనల్ దెతసక, దేముడు జోవయింక చెంగిల్ దెకుస్.” మెన తుమ్ ఇస్టుమ్ జా, చి తుమ్‍క దూసుప కెర్తసచి రిసొ ‘చెంగిల్ తత్తు’ మెన తుమ్ ప్రార్దన కెర. ");
INSERT INTO key_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","తుమ్‍చితె ఎక్కిలొక జవుస్ కో జలెకు అన్నెక్లొ గలి పెట్లెగిన, దెబ్బ కయ్‍లొసొ తుక్లె తా, జోచి అన్నెక్ గలి కి జో అన్నెక్లొ పెటతి రితి, జోచి పక్క పసులవుస్. అన్నె, తుమ్‍చితె ఎక్కిలొచి కోటు జవుస్ కో జలెకు అన్నెక్లొ దెరన గెలె, జోచి సొక్క కి ఈంజొ అన్నెక్లొ దెర గెతి రితి జో అడ్డు కెర్సు నాయ్. ");
INSERT INTO key_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","తుమ్‍చితె కో జలెకి కిచ్చొ జవుస్ నఙిలె, దెంక. అన్నె, తుచితెచొ కేన్ జవుస్ మాన్సుచి సామన్ అన్నెక్లొ దెర గెలె, జో సంతోసుమ్ జలొసొ “అంచి వస్తువ అంక దె” మెన జోచి సామన్ అన్నె నఙన్సు నాయ్. ");
INSERT INTO key_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","మాన్సుల్ తుమ్‍క కీసి కెరుక మెన తుమ్ ఇస్టుమ్ జస్తె గే, తూమ్ కి జోవయింక దస్సి చెంగిల్ కెర. ");
INSERT INTO key_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“ఎక్కి తుమ్‍క ప్రేమ కెర్తసకయ్ తుమ్ ప్రేమ కెర్లెగిన, అన్నె మాన్సుల్‍క నాయ్ మెలె, తుమ్‍క కిచ్చొ పున్నిమ్ జా? పాపుమ్ సుదల్ కి జోవయింక ప్రేమ కెర్తసక ప్రేమ కెరుల. ");
INSERT INTO key_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","తుమ్‍కయ్ చెంగిల్ దెకితసకయ్ చెంగిల్ కెర్తసక, అన్నె వేర మాన్సుల్‍క నాయ్ మెలె, జయి తుమ్‍క కిచ్చొ పున్నిమ్? పాపుమ్ సుదల్ కి దస్సి కెరుల, గెద. ");
INSERT INTO key_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","తుమ్‍క పూర్తి అన్నె దెంక సెక్తి తిలసకయ్ తుమ్ కిచ్చొ జవుస్ తోడు దిలె, అన్నె మాన్సుల్‍క నాయ్ మెలె, జయి తుమ్‍క కిచ్చొ పున్నిమ్? తెద్దిలి అన్నె నఙితి రితి పాపుమ్ సుదల్ కి ఒప్పన పాపుమ్ సుదల్‍క తోడు దెవుల. ");
INSERT INTO key_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“తూమ్, జలె, తుమ్‍చ విరోదుమ్ సుదల్‍క ప్రేమ కెర, చి ఎత్కిజిన్‍క చెంగిల్ దెక, చి కిచ్చొ అన్నె దొర్కు కెరనుక ఆస నే జతె, మాన్సుల్‍క తోడు దాస. తుమ్ ఇసి బుద్ది ఇండిలె, తుమ్‍క వెల్లి బవుమానుమ్ దొర్కు జయెదె, చి ‘ఎత్కిచి ఉప్పిరి తిలొ దేముడుచ పుత్తర్లు ఈంజేఁవ్’ మెన తుమ్‍చి రిసొ రుజ్జు జెయెదె. కిచ్చొక మెలె, ఎక్కి జోచి దయ ఒప్పన్‍తసకయ్ మెన నాయ్, గని అన్నె జో కెర్లి దయ నే ఒప్పన్లసక కి, ఏక్ జోవయింకయ్ జెఁవ్వి దెకన్‍తసక కి, జో ఎత్కి అదికారుమ్ తిలొ దేముడు సొంత దయ దెకితయ్. ");
INSERT INTO key_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","జో పరలోకుమ్ తిలొ అబ్బొసి జలొ దేముడు మాన్సుల్‍క కీసి కెద్ది కన్కారుమ్ దెకితయ్ గే, తుమ్ కి అన్నె మాన్సుల్‍క కన్కారుమ్ దెక. ");
INSERT INTO key_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“అన్నె మాన్సుల్‍క కుస్సిదుమ్‍చ తీర్పుల్ తుమ్ ఉచర నాయ్, చి దేముడు తుమ్‍కయ్ తీర్పు కెర సిచ్చ కెరుక నాయ్. అన్నె మాన్సుల్‍క నేరిమ్‍లు వయడ నాయ్ చి, దేముడు తుమ్‍కయ్ నేరిమ్ వయడుక నాయ్. అన్నె మాన్సుల్‍క చెమించుప కెర చి, దేముడు తుమ్‍కయ్ చెమించుప కెరెదె. ");
INSERT INTO key_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","అన్నె మాన్సుల్‍క తోడు దాస చి, దేముడు తుమ్‍కయ్ తోడు దెయెదె. కీసి దెయెదె మెలె, చెంగిల్ మీన, గట్టిఙ పెల, దున్నొవ, పూర్తి బెరవయ్, తుమ్‍చి ఒట్నె సువ దెయెదె. తూమ్ అన్నె మాన్సుల్‍క కీసి మీన తస్తె గే, ఎత్కి అదికారుమ్ తిలొ దేముడు తుమ్‍కయ్ దస్సి మీన దెయెదె.” మెన యేసు ఒత్త బెర తిలసక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","తెదొడి యేసు ఈంజ టాలి సంగిలొ. కిచ్చొ మెలె, “కేన్ జవుస్ గుడ్డి సుదొ అన్నెక్లొ గుడ్డి సుదొక వాట్ దెకవుక నెత్రె, గెద! వాట్ దెకవుక దెర్లె, జేఁవ్ దొగుల కి కేన్ జవుస్ గొయితె సేడుల. ");
INSERT INTO key_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","సిస్సుడు జోచొ గురుచి కంట వెల్లొ నెంజె, గని జో గురుచి లెక పూర్తి సికిలొ సిస్సుడు, జోచొ గురుచొ రితొ జా తయెదె. ");
INSERT INTO key_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“తుమ్‍చితె ఎక్కిలొచి అంకితె ఏక్ చిల్ప బెర తిలెగిన, బావొచి అంకితె ఇదిలిదిల్ తొక్కు సేడ తిలెగిన, అంకితె చిల్ప తిలొసొ కిచ్చొక జోచి బావొచి అంకితె తిలి ఇదిలిదిల్ తొక్కు దెకితసి, గని సొంత అంకితెచి చిల్పక ‘అస్సె’ మెన దెకిస్ నాయ్? ");
INSERT INTO key_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","నెంజిలె, అంకితె చిల్ప తిలొసొ కో జలెకు, జోచి సొంత అంకితెచి చిల్ప నే దెకిలె, బావొ, తుచి అంకితెచి తొక్కు కడిందె మెన తుచొ బావొక తుయి కీసి సంగుక జయెదె! తుయి ఉప్రమెన్సుచొ, తొలితొ తుచి సొంత అంకితెచి చిల్ప కడను, చి తెదొడ్‍కయ్ తుచొ బావొచి అంకితెచి తొక్కు కడితి రితి టేంట దెకితె. ");
INSERT INTO key_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“కేన్ చెంగిలొ రూకు జలెకు గర్చ పండ్లు దెరె నాయ్, చి గర్చొ రూకు చెంగిల్ పండ్లు దెర నాయ్. ");
INSERT INTO key_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","రూకుక చెంగిలొచొ గే గర్చొ గే చినుక జలె, జో దెర్త పండ్లుక దెకిలె డీసెదె. కంట రూక్‍తె అంజూరుమ్ పండ్లు కోడుక నెంజె, దుబ్బల్‍తె ద్రాచ పండ్లు కోడుక నెంజె, గెద! ");
INSERT INTO key_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","చెంగిలొ మాన్సు జోవయించి పెట్టిచి చెంగిల్ బుద్ది బెర్తుచి కెద్ది చెంగిల్ బుద్దిచ కొడొ లట్టబెదె. గర్చొ మాన్సు, జలె, జోచి పెట్టిచి విస్సుమ్‍చి బెర్తుచి గర్చ కొడొ లట్టబెదె. జోచి పెట్టి కేన్ రగుమ్‍చి బెర్తు జా తిలె, జయ్యి జోవయించి చోండి లట్టబెదె. ");
INSERT INTO key_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“‘ప్రబు, ప్రబు’ మెన అంక కిచ్చొక సంగితసు? అంక దస్సి సంగితసు, గని అంచి కోడు రితి ఇండుస్ నాయ్. ");
INSERT INTO key_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","కో అంచితె జా కెర అంచ కొడొ సూన అంచి కోడు రితి ఇండుల గే కీస జవుల గే ఏక్ టాలితె సంగిందె. ");
INSERT INTO key_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","దసొ మాన్సు కీసొ జయెదె మెలె, గేరు బందిలొ ఏక్ మాన్సు దీగుక గొయి కూన కెర, రెంగ్నిచి ఉప్పిరి పునాది గల కెర జా పునాదిచి ఉప్పిరి గేరు బందిలొ. జలె, పాని గట్టిఙ పెట, బూరుమ్ జా జో గేరుచ కుడ్డిలె జా బూరుమ్ కెర్టల్ జా గట్టిఙ లయితె తిలె కి, జా గేరు చెంగిల్ డిట్టుమ్‍చి పునాదితె తిలి రిసొ, ఎదిలి కి కదుల్ జయె నాయ్. ");
INSERT INTO key_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","గని అంచి కోడు సూన్లె కి కో కెర్తి నాయ్ గే కీసి జవుల మెలె, జో మాన్సు పునాది నే కెర్తె, రితి మత్తిచి ఉప్పిరి గేరు బందిలొ, చి పాని పెట బూరుమ్ జా అయ్‍లె, గేరుచి కుడ్డి బూరుమ్ కెర్టల్ జా అయ్‍లి బేగి జా గేరు సేడ్లి, చి జా గేరు పూర్తి నాసెనుమ్ జా గెలి” మెన యేసు బోదన కెర్లన్. ");
INSERT INTO key_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ఈంజేఁవ్ కొడొ ఎత్కి ప్రెజల్ సూన్‍తి రితి సంగ కేడయ్‍లి పడ్తొ, యేసు కపెర్నహూమ్ పట్నుమ్‍తె అన్నె గెచ్చ పెసిలన్. ");
INSERT INTO key_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","జలె, ఒత్త రోమ్ దేసిమ్‍చి పుంజెక్‍జీన్ జమాన్లుక వెల్లొ ఎక్కిలొ తిలొ. జోక ఒగ్గర్ ప్రేమ తిలొ గొత్తి సుదొ ఎక్కిలొ తిలన్. జో గొత్తి సుదొ గట్టిఙ జొర్జొ సేడ మొర్తి రితి జా తిలన్. ");
INSERT INTO key_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","జలె, జో పుంజెక్‍జీన్ జమాన్లుక వెల్లొ యేసుచి రిసొ సూన కెర, యూదుల్‍చ వెల్లెల మాన్సుల్‍తె సగుమ్‍జిన్‍క యేసుతె తెద్రయ్‍లన్; యేసుక “జెవుస్ చి అంచొ గొత్తి సుదొక చెంగిల్ కెర్సు” మెనయ్ జోవయించి అత్తి కబుర్ తెద్రయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","జలె, జేఁవ్ వెల్లెల మాన్సుల్ యేసుతె జాఁ కెర, “జో పుంజెక్‍జీన్ జమాన్లుక వెల్లొచొ గొత్తి సుదొక తుయి చెంగిల్ కెరుక జో తగుప జలొసొ. కిచ్చొక మెలె, అమ్ యూదుల్‍చ ప్రెజల్‍క జో ప్రేమయ్ అస్సె, చి అమ్‍చి సబగేర్ జొయ్యి బందిలొ” మెన, యేసుక బతిమాల్ప జా సంగిల. ");
INSERT INTO key_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","జలె, యేసు జోవయింతెన్ బార్ జా గెలాఁచి. జో గెరి నే పాఁవితె అగ్గె ఇదిల్ దూరి తిలి పొది, జో పుంజెక్‍జీన్ జమాన్లుక వెల్లొ మాన్సు, జోచ మితర్సుల్ సగుమ్‍జిన్‍క యేసుతె కబుర్ తెద్రయ్‍లన్. కిచ్చొ మెలె, “ప్రబు, అమ్‍చి రిసొ తుయి అన్నె అల్లర్ సేడు నాయ్. తుయి అంచి గెరి జెంక మెలె, ఆఁవ్ తగుప జలొసొ నెంజి. ");
INSERT INTO key_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","అంక విలువ నాయ్ చి రిసొ తుచితె సొంత జా దస్సుల్ జంక నిసాని నాయ్. గని ఒత్త తెంతొ కి తుయి సెలవ్ కోడు సంగిలె, అంచొ గొత్తి సుదొ చెంగిల్ జయెదె. ");
INSERT INTO key_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ఆఁవ్ కీసి జాని మెలె, అఁవ్ కి అదికారుమ్‍క బితొసొ, అంచి తెడి జమాన్లు అస్తి. ఆఁవ్ ఎక్కిలొక ‘గో’ మెలె, గెచ్చెదె. అన్నెక్లొక ‘జె’ మెలె, జెయెదె. అంచొ గొతిమాన్సుక ‘ఈంజ కామ్, జా కామ్ కెరు’ మెలె, కెరెదె” మెన. జో పుంజెక్‍జీన్ జమాన్లుక వెల్లొ జేఁవ్ వెల్లెల మాన్సుల్‍చి అత్తి సంగ తెద్రయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","జలె, ఈంజ కోడు సూన కెర, జో పుంజెక్‍జీన్ జమాన్లుక వెల్లొచి నముకుమ్‍చి రిసొ యేసు ఆచారిమ్ జలన్. అన్నె జోచి పట్టి జెత ప్రెజల్‍చి పక్క పసుల జోవయింక, “తుమ్‍క ఆఁవ్ కిచ్చొ మెంతసి మెలె, అమ్‍చ ఇస్రాయేలుల్‍తె ఎదిలి నముకుమ్ తిలసక అప్పె ఎద కి ఆఁవ్ దెకుక నాయ్” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","తెదొడి, కబుర్ అయ్‍లస జో పుంజెక్‍జీన్ జమాన్లుక వెల్లొచొ గెరి అన్నె కిచ్చొ దెకిల మెలె, జో గొత్తి సుదొ చెంగిల్ జా చెంగిల్ తిలిసి. ");
INSERT INTO key_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ఒత్త తెంతొ అన్నె కిచ్చొ జర్గు జలి మెలె, యేసు నాయీను మెలి పట్నుమ్‍తె గెచ్చుక మెన బార్ జలన్, చి జోవయించ సిస్సుల్ చి ఒగ్గర్‍జిన్ ప్రెజల్ జోవయింతెన్ గెల. ");
INSERT INTO key_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","జా పట్నుమ్‍చి కోటచి గుమ్ముమ్ పాసి పాఁవిలె, ఈందె, ఒత్త మాన్సుల్ ఏక్ పీనుమ్ జా గుమ్ముమ్ వాట్ బయిలె వయ నెతె తిల. జా పీనుమ్ కచి మెలె, రండెల్ మాన్సు ఎక్కిలొచి ఎక్కిలొ పుత్తుసి. జా పట్నుమ్‍చ ఒగ్గర్‍జిన్ మాన్సుల్ జా రండెలి తెన్ ఒత్త తిల. ");
INSERT INTO key_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","జలె, ప్రబు జా రండెలిక దెక జాచి ఉప్పిరి కన్కారుమ్ జలొ, చి “ఏడు నాయ్, అమ్మ” మెన సంగ కెర, ");
INSERT INTO key_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","పీనుమ్‍క పాసి జా, పీనుమ్ వయిలి కట్కి చడిలన్, చి ఒత్త జేఁవ్ వయ నెతె తిలస టీఁవిల. తెదొడి “నాడు, ఉట్టు మెన తుక ఆఁవ్ సంగితసి” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","జలె, జో మొర్లొ ఉబెడొ జీవ్ జా వెస కెర లట్టబుక మొదొల్ కెర్లన్, చి యేసు అయ్యస్‍క బుకారా కెర, “ఈందె, తుచొ పుత్తుది” మెన జోక జాచి అత్తి అన్నె దిలొ. ");
INSERT INTO key_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ఇసి జర్గు జతికయ్, ఒత్త తిల జనాబ్ ఎత్కిజిన్ బియఁ, యేసుచి రిసొ “అమ్‍చి నెడిమి దేముడుచ కబుర్లు సంగితొ గొప్ప కమొ కెర్తొసొ బార్ జా అస్సె. వెల్లొచొ, ఈంజొ” మెన, అన్నె “ఎత్కి అదికారుమ్ తిలొ దేముడు అమ్‍తె ఉత్ర జా అస్సె” మెన, దేముడుచి గవురుమ్ సంగితె తిల. ");
INSERT INTO key_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ఒత్త తెంతొ, జా దీసి యేసు జర్గు కెర్లిస్‍చి రిసొ యూదుల్ జితి ఒండి దేసిమి, చి సుట్టునంతచ ఎత్కి గఁవ్విలె ఎత్కిజిన్ సూన్ల. ");
INSERT INTO key_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","జలె, బాప్తిసుమ్ దెతె తిలొ యోహానుచ సిస్సుల్ జోతె గెచ్చ, యేసు జర్గు కెర్ల కమొ జోక సంగిల. ");
INSERT INTO key_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","యోహాను, జోచ సిస్సుల్‍తె దొగులక బుకారా కెర, “దేముడు తెద్రవుక సంగ తిలొ రచ్చించుప కెర్తొసొ నిజుమి తుయి గే, అమ్ అన్నెక్లొక రకుక గె? తుమ్ పుస” మెన కబుర్ తెద్రయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","జలె, జేఁవ్ మాన్సుల్ యేసుతె జాఁ కెర, “దేముడు తెద్రవుక సంగ తిలొ రచ్చించుప కెర్తొసొ నిజుమి తుయి గే, అమ్ అన్నెక్లొక రకుక గె?” మెన సంగ మెన “బాప్తిసుమ్ దెతొ యోహాను అమ్‍క తుచితె తెద్రవ అస్సె.” మెన జా కబుర్ సంగిల. ");
INSERT INTO key_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","జలె, జయ్యి గడియయ్ ఒగ్గర్‍జిన్ జబ్బుల్ బాదల్ తిలసక చి బూతల్ దెర్లసక యేసు చెంగిల్ కెర్లన్, చి ఒగ్గర్‍జిన్ గుడ్డి జలసక చెంగిల్ కెర్లన్. ");
INSERT INTO key_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","తెదొడి యేసు జేఁవ్ కబుర్ అయ్‍లసక కిచ్చొ జబాబ్ దిలన్ మెలె, “తుమ్ యోహానుతె గెచ్చ కెర, తుమ్ దెకిలిసి, సూన్లిసి ఎత్కి జోక సంగ. గుడ్డి జా తిల మాన్సుల్ దెకితతి, సొట్ట జా తిల మాన్సుల్ ఇండితతి, వెల్లి రోగుమ్ సేడ తిలస చెంగిల్ జతతి, బొయ్‍రల్ జా తిల మాన్సుల్ సూన్‍తతి, మొర గెలస జీవ్ జతతి, చి సుబుమ్ కబుర్ బీద మాన్సుల్‍క ఆఁవ్ సూనయ్‍తసి. ");
INSERT INTO key_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","జలె, కో జలెకు అంచి రిసొ అన్మానుమ్ నెంతె తవుల గే, జోవయింక చెంగిలి.” మెన యేసు యోహానుచ సిస్సుల్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","యోహాను కబుర్ తెద్రవ తిలస ఉట్ట గెలి బేగి, జో యోహానుచి రిసొ ఒత్త తిల ప్రెజల్‍క యేసు ఇసి మెన సంగుక దెర్లన్. “జేఁవ్ పొదులె తుమ్ కిచ్చొ దెకుక జా బయిలె గెచ్చ తిలదు? వాదుతె చివ్వర్ పెల్లి జతిసి దెకుక గెచ్చ తిలదు గె? ");
INSERT INTO key_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","నాయ్ మెలె, కిచ్చొ వేరచి దెకుక గెలదు? సొమ్సార్లు గలంత పాలల్ గలన్లొ మాన్సుక దెకుక గెలదు గె? ఈందె, చెంగిల పాలల్ గలంత సుక్కుమ్ తెన్ జితస రానల్‍చ మేడల్‍తె తవుల. ");
INSERT INTO key_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","జలె, కిచ్చొ దెకుక గెలదు? దేముడు తెద్రయ్‍లి కబుర్ సంగితొ ఎక్కిలొక దెకుక గెలదు గె? నిజుమి, గని జో ప్రబుచ మాములుమ్ కబుర్లు సంగితసచి కంట యోహాను అన్నె ముక్కిమ్‍చొ జయెదె మెన, తుమ్‍క ఆఁవ్ సంగితసి. ");
INSERT INTO key_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","కిచ్చొక మెలె, ఈందె, అంచి కబుర్ సంగితొ బారికి జతి రితి ఎక్కిలొక తుచి పుర్రె తెద్రయ్‍తసి. తుచి కంట అగ్గె గెచ్చ, తుయి జెతిసి సాట్ప కెరెదె మెన రెగిడ్లి కోడు అస్సె. జా కోడుతె ‘అంచి కబుర్ సంగితొసొ’ మెన ఈంజ యోహానుచి రిసొయి రెగ్డి జా అస్సె. ");
INSERT INTO key_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","తుమ్‍క ఆఁవ్ కిచ్చొ మెంతసి మెలె, తేర్‍బోదల్‍క జెర్మిలసతె, యోహానుచి కంట వెల్లొచొ కోయి నాయ్. జలెకి, దేముడుచి రాజిమ్‍తె కో ఎత్కిచి కంట దాక్ జవుల గే, జో యోహానుచి కంట వెల్లొ జవుల” మెన యేసు ప్రెజల్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","జలె, ఈంజ కోడు మాములుమ్ ప్రెజల్ ఎత్కిచి సిస్తు నఙిత సుంకర్లు సూన కెర, “ఎత్కి అదికారుమ్ తిలొ దేముడుచ తీర్పుల్ సత్తిమ్‍చ” మెన ఒప్పన్ల. జేఁవ్, అగ్గె యోహానుచి అత్తి బాప్తిసుమ్ నఙన తిల. ");
INSERT INTO key_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","గని పరిసయ్యుల్ చి మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తొసొ సికడ్తస జోచి అత్తి బాప్తిసుమ్ నఙిత్ నాయ్. యోహానుచి అత్తి బాప్తిసుమ్ జేఁవ్ నఙుక నెసిలిస్ తెన్ జోవయించి రిసొచి దేముడుచి ఇస్టుమ్ జేఁవ్ నెసిలిస్‍చి రుజ్జు దెకవ తిల. అప్పె కి యేసుచి కోడు నెసిల. ");
INSERT INTO key_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","యేసు అన్నె, “ఈంజ ఉగుమ్‍చ మాన్సుల్‍చి బుద్దిక కిచ్చొ టాలి సంగుక జయెదె? జేఁవ్ కీసి జతతి? ");
INSERT INTO key_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","వీదులె వెస కెల్త బోదల్‍చ రిత జతతి. జేఁవ్ బోదల్ ఎక్కిలొచి ఉప్పిరి ఎక్కిలొ అన్మానుమ్ జా, తుమ్‍క ‘నచ్చుత్’ మెన బఁవ్సి పుంగిలెకి నచ్చుస్ నాయ్. అమ్ ఏడ్లెకి, తుమ్ బెద ఏడ్సు నాయ్” మెన దస బోదల్ కీసి సంగుల గే, దస్సి ఆఁవ్ చి యోహాను కిచ్చొ కెర్లె కి, తుమ్ మెన్సుస్ నాయ్. ");
INSERT INTO key_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","కిచ్చొక ఆఁవ్ ఇసి టాలి కెర్తసి మెలె, బాప్తిసుమ్ దెతె తిలొ యోహాను కిచ్చొ అన్నిమ్ నే కతె చువ్వె తతొసొ, కిచ్చొ ద్రాచ రస్సుమ్ గట్ర నే పితె తన్నె తతొసొ తుమ్‍తె అయ్‍లొ, చి జోచి రిసొ “జోక బూతుమ్ దెర అస్సె.” మెంతసు. ");
INSERT INTO key_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ఆఁవ్ జలె, మాన్సు జా జెర్మున్ అయ్‍లొసొ, మాములుమ్ కతె పితె తతిస్‍చి రిసొ తుమ్ కిచ్చొ మెంతసు మెలె, “‘ఆదె, కయ్‍రొ మత్వాలొ ఈంజొ. సిస్తు నఙిత సుంకర్లు తెన్ పాపుమ్ సుదల్ తెన్ బెదితొసొ’ మెన, అంచి రిసొ సంగితసు. ");
INSERT INTO key_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","గని కచి కచి పెట్టి దేముడుచి బుద్ది తిలె, జేఁవ్ ఎత్కిజిన్‍చ కమొచి పలితుమ్‍తె రుజ్జు జయెదె” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","పరిసయ్యుడు జలొ ఎక్కిలొ యేసుక అన్నిమ్‍క బుకార్లన్, చి జో పరిసయ్యుడుచి గెరి గెచ్చ. జా దేసిమ్‍చ సొమ్సార్లుచ గెరలె అన్నిమ్‍క కీసి ఒర్గు జా బల్లయ్ కవుల గే, దస్సి, అన్నిమ్ కతస ఎత్కిజిన్ తెన్ యేసు కి ఒర్గు జలన్. ");
INSERT INTO key_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","జలె, ఈందె, లంజె జితె తిలి జా పట్నుమ్‍చి తేర్‍బోద ఎక్లి యేసుక ‘జో పరిసయ్యుడుచి గెరి అన్నిమ్ కంక గెచ్చ అస్సె’ మెన సూన కెర, ఏక్ బుడ్డితె అత్తర్ తేల్ దెరన అయ్‍లి. ");
INSERT INTO key_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","యేసుచి పడ్తొ జోచ చట్టొక పాసి టీఁవ వంపొ జా ఏడుక దెర్లి, చి జాచి ఆఁసునొ సువి జతికయ్ యేసుచ చట్టొ తిమిలచి, జాచి సెండి తెన్ జా తేర్‍బోద జోచ చట్టొ పుంచ, జోక చుంబ కెర, జా అత్తర్ తేలు గాఁసిలి. ");
INSERT INTO key_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","జలె, యేసుక బుకారా తిలొ పరిసయ్యుడు జా ఎత్కి దెక కిచ్చొ ఉచర్లన్ మెలె, “ఈంజొ నిజుమి ఎత్కి అదికారుమ్ తిలొ దేముడుచ కబుర్లు సంగితొసొ జలె, జోక చడితి తేర్‍బోద కొన్సి జయెదె, కీసిచి జయెదె గే జాన్‍తొ. ఇన్నెక ‘పాపుమ్ సుది’ మెన జాన్‍తొ.” ");
INSERT INTO key_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","జలె, జో ఉచర్లిసి జాన కెర, యేసు జోక కిచ్చొ జబాబ్ దిలన్ మెలె, “ఓ సీమోను, తుక ఏక్ కోడు సంగిందె” మెన సంగిలన్, చి “కిచ్చొ, గురుబాబు? సంగు” మెన సీమోను సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","సంగితికయ్, యేసు ఏక్ టాలి సంగిలన్. “ఏక్ సావుకారితె దొగుల రునుమ్ జా తిల. జేఁవ్ దొగులతె ఎక్కిలొ పాఁచ్ పుంజొ పొదుల్‍చి కూలిచి ఎదిలి డబ్బుల్‍క బాకి జా అస్సె, అన్నెక్లొ యాబయ్ పొదుల్‍చి కూలిచి ఎదిలిక బాకి జా అస్సె. ");
INSERT INTO key_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","జేఁవ్ జోవయించి రునుమ్ కుట్టవుక నెతిర్లి రిసొ, సావుకరి దొగులచి రునుమ్‍కి ముల దా చెమించుప కెర్లన్. జలె, తుయి సంగు, ఈంజేఁవ్ దొగులతె కేన్ మాన్సు జో సావుకరిక ఒగ్గర్ ప్రేమ జయెదె?” మెన యేసు జో సీమోనుక పరిచ్చ కెర్లన్, చి ");
INSERT INTO key_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","జో కిచ్చొ జబాబ్ దిలన్ మెలె, “ఒగ్గర్ బాకి జా తిలొసొ, కిచ్చొగె” మెలన్, చి “తుయి సరిగా ఉచర్లది” మెన యేసు జోక సంగ కెర, ");
INSERT INTO key_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","జా తేర్‍బోదచి పక్క పసుల సీమోనుక అన్నె ఇసి మెలన్: “ఈంజ తేర్‍బోదక దెకితసి గె? జలె, ఆఁవ్ తుచి గెరి అయ్‍లయ్, గని ఆఁవ్ చట్టొ దొవన్‍తి రిసొ తూయి పాని దెసి నాయ్. ఈంజ, జలె, ఇన్నెచి ఆఁసునొ తెన్ అంచ చట్టొ దోవ అస్సె, చి ఇన్నెచి సెండి తెన్ పుంచ అస్సె. ");
INSERT INTO key_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","తూయి అంక చుంబిస్ నాయ్, గని ఆఁవ్ ఈంజ గెరి అయ్‍లి తెంతొ ఈంజ అంచ చట్టొ చుంబుక దెర ములె నాయ్. ");
INSERT INTO key_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","అంచి బోడి తూయి తేల్ కి సువిస్ నాయ్. గని ఈంజ అంచ చట్టెలె అత్తర్ తేలు గాఁస దా అస్సె. ");
INSERT INTO key_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","జాచి రిసొ తుక ఆఁవ్ కిచ్చొ మెంతసి మెలె, ఇన్నెచ పాపల్ ఒగ్గర్ జా తిలె కి, చెమించుప జా అస్తి. ఈంజ చెమించుప జలిస్‍క కిచ్చొ రుజ్జు మెలె, ఇన్నెచి ఒగ్గర్ ప్రేమయ్ జా రుజ్జు దెకయ్‍తయ్. గని కక్క తొక్కి పాపుమ్ చెమించుప జా తయెదె గే, జోచి పెట్టి తొక్కి ప్రేమ తయెదె” మెన యేసు జో పరిసయ్యుడుక సంగ కెర, ");
INSERT INTO key_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","జా తేర్‍బోదక, “తుచ పాపల్ చెమించుప జా అస్తి” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","జో దస్సి మెంతికయ్, జోవయింతెన్ అన్నిమ్ కెర్తె తిలస జోవయించి పేట్ తెడి కిచ్చొ మెల మెలె, “ఈంజొ పాపల్ చెమించుప కెర్తయ్ జలె, ఈంజొ కొన్సొ?” మెన పేట్ తెడి ఉచరన్ల. ");
INSERT INTO key_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","జలె, “తుయి అంచి ఉప్పిరి తుచి నముకుమ్ తిలి రిసొ రచ్చించుప జా అస్సిసి. సేంతుమ్ తెన్ గో.” మెన యేసు జా తేర్‍బోదక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ఈంజ ఎత్కి జర్గు జా ఒగ్గర్ దీసల్ నే గెతె అగ్గె, యేసు బార్ జా పట్నలె గఁవ్విలె బుల బుల, దేముడుచి రాజిమ్‍చి రిసొచి సుబుమ్ కబుర్ బోదన కెర్తె తిలొ. జో తెన్ జోచ బారజిన్ సిస్సుల్ బుల్తె తిల. ");
INSERT INTO key_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","అన్నె కొన్స మెలె, యేసు అగ్గె సగుమ్‍జిన్ జబ్బుల్ తిల తెర్‍బోదల్‍చ జబ్బుల్ గెచ్చవ చెంగిల్ కెర తిలన్, సగుమ్‍జిన్ తేర్‍బోదల్‍క బూతల్ దెర్తికయ్ ఉదడ జోవయింక కి చెంగిల్ కెర తిలన్. జేఁవ్ తెర్‍బోదల్‍తె సగుమ్‍జిన్, జలె, యేసు తెన్ సిస్సుల్ తెన్ బుల్తె తిల. జోవయింతె ఎక్లి కొన్సి మెలె, మగ్దల పట్నుమ్‍చి మరియ, జాక దెర్ల సత్తు బూతల్‍క యేసు ఉదడ తిలన్. ");
INSERT INTO key_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","అన్నె కొన్స మెలె, హేరోదు రానొచి గేర్‍క దెకితొ కూజా మెలొసొచి తేర్సి యోహన్న, పడ్తొ సూసన్న చి అన్నె ఒగ్గర్‍జిన్, జోవయింక తిలి సొంత డబ్బుల్‍క యేసుక చి సిస్సుల్‍క సావ్రెచన కెర్తె తిల. ");
INSERT INTO key_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ఒగ్గర్‍జిన్ జనాబ్ కుప్పల్ కుప్పల్ బెర జా, పట్నల్ ఎత్కి గాఁవ్వొ ఎత్కి తెంతొ యేసుతె అయ్‍లి. జో ఏక్ టాలి జోవయింక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“ఎక్కిలొ జోచి బీ ఉంపుక బార్ జలన్. ఉంపితె తతికయ్, సగుమ్ బీ బయిలె వట్టె సేడ్లన్, చి వట్టె జెతస గెతస జా బీ సుఁదిల, చి పిట్టల్ జేఁవ్ దాన్ వెంట కాఁ గెల. ");
INSERT INTO key_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","అన్నె సగుమ్ బీ పత్తురు బుఁయ్యె సేడ్లన్ చి, తెడి సాల్‍వ నాయ్ చి రిసొ గజ్జల్ జలెకి, డడ్డ మొర గెల. ");
INSERT INTO key_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","అన్నె సగుమ్ బీ కంట దుబ్బుల్‍తె సేడ్ల చి, కంట దుబ్బుల్ తెన్ వడ్డితికయ్, కంట మొక్కల్ ఈంజేఁవ్ మొక్కల్‍క పెల గెల్తికయ్, ఈంజేఁవ్ మొక్కల్ పలితుమ్ దెర్తి నాయ్. ");
INSERT INTO key_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","అన్నె సగుమ్ బీ చెంగిల్ బుఁయ్యె సేడ్లన్ చి, వడ్డ పంటొ పికిలె, పుంజెక్ వంతుల్ పలితుమ్ దిలి” మెన సంగ యేసు అన్నె, “సూన్‍త కంగ్డొ తిలస సూన!” మెన కేక్ గలన్. ");
INSERT INTO key_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","జలె, వేర మాన్సుల్ ఉట్ట గెతికయ్, “ఈంజ టాలిచి అర్దుమ్ కిచ్చొ?” మెన యేసుక సిస్సుల్ పుసిల చి, ");
INSERT INTO key_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","జోవయింక, “దేముడుచి రాజిమ్‍చి రిసొచ గుట్టుల్ జాన్సుప మెన, అంచ సిస్సుల్ జతి తుమ్‍క సెలవ్ దా అస్సె, గని వేర మాన్సుల్‍చి రిసొయి టాలివొ తెన్ సంగితసి. కిచ్చొక మెలె, పూర్గుమ్ దేముడుచి కొడొతె రెగిడ్లి రితి. తుమ్ దెకుతసు, గని అర్దుమ్ చినుతు నాయ్, ఆఁవ్ సంగితి బోదన సూన్‍తు, గని అర్దుమ్ కెరంతు నాయ్.” ");
INSERT INTO key_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“జలె, జా టాలిచి అర్దుమ్ సంగిందె. తుమ్ సూన, బీ మెలె, దేముడు దిలి కోడు. ");
INSERT INTO key_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","వట్టె సేడ్ల గిడ్డల్‍చి అర్దుమ్ కిచ్చొ మెలె, సగుమ్‍జిన్‍చి బోదన సూన అస్తి, గని సయ్‍తాన్ జా కెర, జోవయించి పెట్టి తెంతొ జా బోదన ఉర్ల కెర, పఁవ్సడ్తయ్; ‘నంపజా రచ్చించుప జతు నాయ్’ మెన. ");
INSERT INTO key_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","పత్తురు బుఁయ్యె సేడ్లి బీ జలె, సగుమ్‍జిన్ సుబుమ్ కబుర్ సూన్లి పొది సర్దసంతోసుమ్ తెన్ సూన్‍తతి గని, జోవయించి పెట్టి సుబుమ్ కబుర్‌చ చెర్రొ నెంజిలి రిసొ గడియ నంపజలి రితి జలెకి, జోవయించి నముకుమ్ పిట్టయ్‍తి రితి కిచ్చొ జవుస్ అల్లర్ అయ్‍లె, నముకుమ్ ముల దెతతి. ");
INSERT INTO key_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","జలె, కంట దుబ్బుల్‍తె సేడ్లి బీ కిచ్చొ మెలె, సగుమ్‍జిన్ సూన్‍తతి గని, జేఁవ్ జోవయించి వట్టె గెతె తా, ఈంజ లోకుమ్‍చి జీవితుమ్‍చ బాదల్, సొమ్సారుమ్, సుక్కుమ్ జోవయింక పెల్లితయ్ చి, జోవయించి పంటొ పికె నాయ్. ");
INSERT INTO key_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","జలె, చెంగిల్ బుఁయ్యె ఉంపిలిస్ కిచ్చొ మెలె, సగుమ్‍జిన్ సుబుమ్ కబుర్ చెంగిల్ నిదానుమ్ పేట్ తెన్ సూన, దెరన, జా కోడ్ రితి నిదానుమ్ ఇండ బాదల్ ఓర్సుప జా ఆత్మపలితుమ్ దెరుల. ");
INSERT INTO key_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“ఏక్ దీవు లంబడ తిలె, జా దీవుక ఆరి లంబడ్లి రితి నాడిచి తెడి జవుస్ కో డంకితి నాయ్, మంచుమ్‍చి తెడి జవుస్ కో లుంకడ్తి నాయ్. జా దీవుకంబుమ్‍చి ఉప్పిరి తివుల; ‘ఒత్త తిలె, గెరి జెత ఎత్కిజిన్‍క, జా ఉజిడి కామ్‍క జెవుస్’ మెనయ్. ");
INSERT INTO key_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","లుంకాడ తిలిసి ఎత్కి పడ్తొక డీసెదె, అప్పె గుట్టు తిలిసి ఎత్కి జాన్‍తి రితి జా బార్ జయెదె. ");
INSERT INTO key_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“జలె, తుమ్ కీసి సూన్‍తె గే జాగర్త దెకన. కిచ్చొక మెలె, తిలొసొక అన్నె దెంక జయెదె, గని నెంజిలొసొ జలె, ‘అంక అస్సె’ మెన జో ఉచరంతిసి కి జోతె తెంతొ కడ నెంక జయెదె” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ఏక్ దీసి యేసుచి అయ్యసి జోవయించ బావుడ్సివొ జోతె అయ్‍ల, గని యేసు తిలి గదితె ఒగ్గర్‍జిన్ జనాబ్ బెర తిలి రిసొ, జోతె పాఁవుక నెతిర్ల. ");
INSERT INTO key_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","జలె, “తుచి అయ్యది, తుచ బావుడ్దివొ తుక దెకుక మెన జా కెర, వీదె టీఁవ అస్తి” మెన కో గే యేసుక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","గని జో జోవయింక, “అంచి అయ్య, అంచ బావుడ్లు కో జవుల మెలె, దేముడుచి కోడు సూన జయ్యి రితి కెర్తసయ్” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ఏక్ దీసి యేసు జోచ బారజిన్ సిస్సుల్ తెన్ దోనితె వెగ కెర, “గాడు ఒత్తల్‍తొ గెచ్చుమ, జొమ్మ” మెన సంగిలన్, చి జీనుక దెర్ల. ");
INSERT INTO key_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","జలె, నెడిమి గడ్డె పాఁవిలె యేసు నిజ గెలన్. తెదొడి వాదు పాని గట్టిఙ కెర, జేఁవ్ తిలి పక్క ఉడ్డ అయ్‍లి చి, కెర్టల్‍క దోనితె ఒగ్గర్ పాని బెర్తికయ్, ప్రమాదుమ్ జతి. ");
INSERT INTO key_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","జేఁవ్, యేసుక పాసి జా “ప్రబు, ప్రబు, అమ్ మొర గెచ్చుమ్‍దే!” మెన సిస్సుల్ కేక్ గల ఉట్టయ్‍తికయ్, జో ఉట్ట వాదుక చి కెర్టల్‍క గోల కెర్లన్, చి వాదు ముల దిల, చి ఎత్కి అన్నె సేంతుమ్ జా గెలి. ");
INSERT INTO key_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","తెదొడి యేసు జోవయింక, “తుమ్‍చి నముకుమ్ కేతె?” మెలన్, చి బియఁ గెచ్చ, ఆచారిమ్ జా, ఎక్కిలొక ఎక్కిలొ కిచ్చొ మెల మెలె, “ఈంజొ కొన్సొ జయెదె, చి వాదుక పానిక ఆడ్రల్ దిలె ఇన్నెచి కోడుక లొంగుప జా కెర్తతి?” మెన జేఁవ్ ఆచారిమ్ జల. ");
INSERT INTO key_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","జలె, యేసు సిస్సుల్ తెన్ గాడు జీన గలిలయచి మొక్మెచి గాడు ఒత్తల్‍తొచి గెరాసీనుల్‍చి ప్రాంతుమ్‍తె పాఁవిల. ");
INSERT INTO key_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","యేసు దోని తెంతొ ఉత్ర కెర ఒడ్డుతె టీఁవితికయ్, జా గఁవ్విచొ ఎక్కిలొ జోవయింక దస్సుల్ జలన్. జో మాన్సుక బూతల్ దెర తిల. ఒగ్గర్ దీసల్ జలి జో కిచ్చొ పాలల్ గలనె నాయ్, చి కేనె జితె తిలన్ మెలె, గెరి నాయ్, గని మెస్సున్‍తె. ");
INSERT INTO key_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","జో బూతుమ్ జో మాన్సుక ఒగ్గర్ సుట్లు దెర తిలన్, చి అగ్గె గఁవ్విచ జోక చట్టెలె అత్తిలె గొల్సుల్ బంద రకితె తిల, గని జేఁవ్ గొల్సుల్ కుట్టవనెదె, చి జో బూతుమ్ జోక బయిలు టాన్‍తె పెలవ నెయెదె. జలె, బూతుమ్ దెర్లొ జో మాన్సు అప్పె యేసుక దెక కెర, కేక్ గల జోచి చట్టె సెర్ను సేడ్లన్, చి “ఓ బూతుమ్, ఈంజొ మాన్సుచి తెంతొ బార్ జా తుయి ఉట్ట గో!” మెన యేసు ఆడ్ర దిలన్. జో మాన్సు గట్టిఙ అవాడ్ కెరన, “ఓ యేసుప్రబు, ఎత్కిచి ఉప్పిరి తిలొ దేముడుచొ పుత్తుసి తుయి, అంచి తెన్ తుక కిచ్చొ కామ్? అంచి ఉప్పిరి దయ తిఁయ అంక అల్లర్ కెరు నాయ్!” మెన కేక్ గలన్. ");
INSERT INTO key_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","తెదొడి, “తుచి నావ్ కిచ్చొ?” మెన యేసు బూతుమ్‍క పుసిలన్, చి “ఎతివాట్‍జిన్” మెలన్. కిచ్చొక మెలె, ఒగ్గర్‍జిన్ బూతల్ జోక దెర తిల. ");
INSERT INTO key_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","“జా వెల్లి గొయ్యితె అమ్‍క తెద్రవు నాయ్” మెన యేసుక బతిమాల్ప జా సంగిల. ");
INSERT INTO key_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","జలె, జా మెట్టయ్ వెల్లి మంద అండ్రుల్ కతె తిల, చి “అండ్రుల్‍చి తెన్ అమ్ పెసిత్ రితి అమ్‍క సెలవ్ దె.” మెన యేసుక జేఁవ్ బూతల్ బతిమాల్ప జా సంగితికయ్, జో సెలవ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","తెదొడి జో మాన్సుచి తెంతొ బూతల్ బార్ జా ముల దా, అండ్రుల్ తెన్ పెసిల, చి జా అండ్రుల్ మంద మొత్తుమ్ ఒత్తచి గాటిక నిగ ఉత్ర గెచ్చ, గడ్డె సేడ డుఙ మొర గెల. ");
INSERT INTO key_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","జా అండ్రుల్ మంద రకితస జర్గు జలిసి దెక కెర, బమ్మ జా నిగ గెచ్చ, ఒండి పట్నుమ్‍తెచి సుట్టునంతచ గఁవ్వొ ఎత్కితె సూనయ్‍ల. ");
INSERT INTO key_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","తెదొడి జర్గు జలిస్‍చి రుజ్జు సొంత దెకుక మెన ప్రెజల్ ఎత్కి బార్ జల, చి యేసుతె జా కెర కిచ్చొ దెకిల మెలె, బూతల్ ముల దిలొ మాన్సు యేసుచి చట్టె వెస అస్సె. పాలల్ గలన తా అప్పె వెర్రి నెంతె మాములుమ్ చెంగిల్ బుద్ది తెన్ అస్సె, మెన దెక కెర, బియఁ గెల. ");
INSERT INTO key_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","అన్నె, జర్గు జలి పొది దెక తిల మాన్సుల్, జలె, బూతల్ దెర తిలొ మాన్సుక యేసు కీసి చెంగిల్ కెర్లొ గే జేఁవ్ పడ్తొ అయ్‍లసక సంగిల. ");
INSERT INTO key_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","తెదొడి జేఁవ్ గెరాసీనుల్‍చి ప్రాంతుమ్ ఎత్కిచ మాన్సుల్ ఎత్కిజిన్ “అమ్‍చి దేసిమ్ తుయి ముల దా ఉట్ట గో” మెన యేసుక బతిమాల్ప జా సంగిల. కిచ్చొక మెలె, జోవయింక ఒగ్గర్ బయిమ్ దెర తిలి. జాకయ్ యేసు దోనితె వెగ ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","బూతల్ ముల దిలొ మాన్సు, జో నే గెతె “ఆఁవ్ కి తుచి తెన్ బెద జెంక అంక సెలవ్ దె” మెన బతిమాల్ప జా సంగిలన్. గని యేసు జోక, ");
INSERT INTO key_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“తుచి గెరి గో చి, దేముడు తుక చెంగిల్ కెర ఎదివాట్ దయ కెర్లిసి ఒత్త సంగు” మెన యేసు తెద్రవ దిలన్ చి, జో ఉట్ట గెచ్చ, యేసు జోక ఎదివాట్ దయ కెర్లిస్‍చి రిసొ జా ఒండి పట్నుమ్‍తె సూనయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","యేసు గాడు అన్నె జీన గట్టుతె పాఁవితికయ్, జో అన్నె జెతిస్‍క రక తిల చి రిసొ ప్రెజల్ ఒగ్గర్‍జిన్ జోక దస్సుల్ జల. ");
INSERT INTO key_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","జలె, యాయీరు మెలొ ఎక్కిలొ ఒత్త అయ్‍లొ. జో యూదుల్‍చి సబగేర్‍చొ అదికారి జయెదె. జో యేసుచి చట్టె సెర్ను సేడ్లన్, అన్నె “అమ్‍చి గెరి జె” మెన యేసుక బతిమాల్ప జా సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","కిచ్చొక మెలె, జాక బార వెర్సుల్ వయసుచి ఎక్కి దువిసి, మొరెదె గే జియెదె గే, దస్సి జాఁ తిలి. జలె, యేసు జో అదికారి తెన్ గెల, చి వట్టె ఒగ్గర్‍జిన్ ప్రెజల్ జోచి సుట్టునంత తా పెలపులి జతె తిల. ");
INSERT INTO key_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","జలె, బార వెర్సుల్ తెంతొ లొఁయి గెతి బాద తిలి తేర్‍బోద ఎక్లి ఒత్త తిలి. కో కి జాచి బాద గెచ్చవుక నెత్ర గెచ్చ తిల. ");
INSERT INTO key_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","జా, జలె, యేసుచి పడ్తొ జా పాసి జా, జోచి పాలుమ్‍చి కొంగు చడిలి చి, బేగి జా లొఁయి గెతిసి బందు జా గెలి. ");
INSERT INTO key_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","దస్సి జతికయ్, “కో అంక చడిలన్?” మెన యేసు పుసిలన్ చి, పేతురు యేసుక “గురుబాబు, జనాబ్ ఎత్కి తుచి సుట్టునంత బెర పెలపులి జతతిచి లయడ్ జతతి, గెద” మెలన్, ");
INSERT INTO key_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","“గని అంక చడుక మెన, కో గే అంక చడిలన్. అంచి తెంతొ ఆత్మసెక్తి బార్ జా గెచ్చ అస్సె.” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","జలె, జా కెర్లిసి గుట్టు తయె నాయ్, మెన జా తేర్‍బోద చిన కెర, అద్దుర్ జా యేసుచి చట్టె సెర్ను సేడ్లన్, అన్నె “‘అంచి బాద గెస్సు’ మెన తుక చడిలయ్ చి, చడిల్ బేగి చెంగిల్ జలయ్” మెన ఎత్కిజిన్ ప్రెజల్‍చి మొక్మె ఒప్పన్లన్. ");
INSERT INTO key_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ఒప్పన్‍తికయ్, యేసు జాక, “పుత్త, అంచి ఉప్పిరి తుయి నముకుమ్ తిలి రిసొ, తుయి చెంగిల్ జా అస్సిసి. సేంతుమ్ తెన్ గో” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","జా తేర్‍బోదక యేసు దస్సి సంగితె తిలి పొది, దువిస్‍చి రిసొ యేసుతె జా తిలొ అదికారిచి గెర్‍చ సగుమ్‍జిన్ జా కెర, జో అదికారిక “తుచి నాడి మొర గెచ్చ అస్సె. ఈంజొ గురుబాబుక బుకార్లె లాబుమ్ నాయ్. జోక జా బాద పోని” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","యేసు ఈంజ కోడు సూన, “జేఁవ్ సంగిలిస్‍క కాతర్ నే కెర్తె, తుయి బి నాయ్. నంపజా దయిరిమ్ తెన్ తా చి, తుచి నాడి చెంగిల్ జయెదె.” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","జలె, యాయీరుచి గెరి పాఁవిలె, పేతురుక యోహానుక చి యాకోబుక, చి నాడిచి అయ్యస్అబ్బొస్‍క పిట్టవ, అన్నె కోయి జో తెన్ జా నాడి తిలిస్‍తె గెచ్చుక యేసు ఒప్పె నాయ్. ");
INSERT INTO key_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","నాడి మొర గెలి రిసొ ఎత్కిజిన్ ఏడుకుడు జతె తిల, గని “తుమ్ ఏడ నాయ్. ఈంజ మొర గెచ్చె నాయ్. జా నిజ అస్సె.” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","జాకయ్ జా నాడి ‘నిజుమి మొర గెచ్చ అస్సె’ మెన జాన కెర, జోక జేఁవ్ ఆఁస గెల. ");
INSERT INTO key_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","గని జో, జా నాడి తిలిస్‍తె గెచ్చ కెర, జాచి ఆతు దెర, “నాడి, ఉట్టు!” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","జాచి జీవ్, జాచి పెట్టి అన్నె అయ్‍లిచి, బేగి ఉట్లి. తెదొడి “ఇన్నెక తుమ్ కిచ్చొ జలెకు కవడ” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","జా నాడిచ అయ్యసిఁసి బలే ఆచారిమ్ జల, గని “జర్గు జలిసి కక్క సంగ నాయ్” మెన యేసు ఆడ్ర దిలన్. ");
INSERT INTO key_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","పడ్తొ, యేసు జోచ బారజిన్ సిస్సుల్‍క ఎక్కితె బుకారా కెర, ఎత్కి రగల్ బూతల్‍క జేఁవ్ ఉదడ్తి రిసొ, జబ్బుల్ జేఁవ్ గెచ్చయ్‍తి రిసొ జోవయింక సెక్తి అన్నె అదికారుమ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","అన్నె, “దేముడుచి రాజిమ్ పాఁవ జా అయ్‍లిస్‍చి రిసొ తుమ్ బోదన కెర చి, మాన్సుల్‍చ జబ్బుల్ గెచ్చవ” మెన తెద్రయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","తెద్రయ్‍తె పొది ఇసి మెలన్: “ప్రయానుమ్‍చి రిసొ కిచ్చొ దెరన గెచ్చ నాయ్. టెక్నొ డండొ జలెకు, సెంచె జలెకు, అన్నిమ్ జలెకు, డబ్బుల్ జలెకు, దొన్ని సొక్కల్ జలెకు దెరన గెచ్చ నాయ్. ");
INSERT INTO key_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","పడ్తొ కేన్ గెర్‍చ తుమ్‍క టాన్ దెవుల గే, తుమ్ జా గాఁవ్ జవుస్ ముల్తె ఎదక, జయ్యి గెరి బస జా తా. ");
INSERT INTO key_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","అన్నె, కేన్ పట్నుమ్‍తె జవుస్ తుమ్‍క మరియాద కెర్తి నాయ్ గే, జా పట్నుమ్ తెంతొ బార్ జతె పొది ‘జేఁవ్ దస్సి జలి రిసొ దేముడుచ నెంజితి’ మెన గుర్తుక తుమ్‍చ చట్టొచి దూడి పంప్డన గెల” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","తెదొడి జేఁవ్ బారజిన్ సిస్సుల్ బార్ జా గాఁవ్వొ ఎత్కితె బుల బుల, చి రిసొ బోదన కెర్తె తా, మాన్సుల్‍చ జబ్బుల్ గెచ్చయ్‍తె తిల. ");
INSERT INTO key_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","జా పొది, గలిలయ ప్రాంతుమ్‍తె ఏలుప కెర్తొ అదికారి హేరోదు, యేసు జర్గు కెర్ల కమొ ఎత్కిచి రిసొ సూన్లి రిసొ, కిచ్చొ ఉచరుక నేన కెర బాద సేడ్లొ. కిచ్చొక మెలె, యేసుక “యోహాను మొర తా అన్నె జీవ్ జా అస్సె” మెన సగుమ్‍జిన్ సంగితె తిల, ");
INSERT INTO key_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","గని అన్నె సగుమ్‍జిన్ “పూర్గుమ్ దేముడుచ కబుర్లు సంగిలొ ఏలీయా అన్నె జా అస్సె” మెల, చి అన్నె సగుమ్‍జిన్ “పూర్గుమ్ దేముడుచి కబుర్లు సంగిలొ అన్నెక్లొ మొర, అన్నె జీవ్ జా అన్నె జా అస్సె” మెన ఉచర్తె తిల. ");
INSERT INTO key_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","జా ఎత్కి సూన కెర, హేరోదు, “యోహానుక బోడి గండల్ కెర గెలయ్, గని ఈంజేఁవ్ కమొ కెర్తొసొచి రిసొ ఆఁవ్ ఒగ్గర్ సూన్‍తసి. ఈంజొ కొన్సొ జయెదె?” మెన, యేసు తెన్ దస్సుల్ జంక మెన వాటు చజితె తిలొ. ");
INSERT INTO key_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","యేసుచ బారజిన్ బారికుల్, జలె, జేఁవ్ బులుక మెన జో తెద్రయ్‍లిస్ తెంతొ అన్నె ఉట్ట జా, జేఁవ్ జర్గు కెర్లిసి ఎత్కి జోక సంగిల చి, జో వేరతె జోవయింతెన్ గడియ తతి రితి, బేత్సయిదా మెంతి గఁవ్వి జోవయింక కడ నిలన్. ");
INSERT INTO key_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","జలె, జోవయింక ‘ఒత్త బేత్సయిదాతె గెతయ్’ మెన యేసుచి రిసొ ప్రెజల్ జనాబ్ సూన కెర, జోచి పట్టి గెల. జోతె పాఁవితికయ్, జో జోవయింక పాసి కెరన్లన్ చి, దేముడుచి రాజిమ్‍చి రిసొ జోవయింక బోదన కెర, జోవయింతె జొర్జొల్, బాదల్ తిలసక చెంగిల్ కెర్లన్. ");
INSERT INTO key_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","జలె, పొద్దు గెచ్చుక దెర్లి చి, యేసుచ బారజిన్ సిస్సుల్ జోతె జా కెర, “ఈంజేఁవ్ జనాబ్ అన్నిమ్ దొర్కు కెరంతి రితి, నిద్ర తతి రిసొ ఇన్నెక సుట్టునంతచ గఁవ్విలె తెద్రవు బయిలు దేసిమి అస్సుమ్, గెద. ఇన్నె కిచ్చొయ్ దొర్కు జయె నాయ్” మెల, ");
INSERT INTO key_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","గని జో జోవయింక, “తుమి జోవయింక కిచ్చొ జవుస్ అన్నిమ్ దాస” మెలన్. దస్సి మెంతికయ్, జేఁవ్ “అమ్‍చితె ఎక్కి పాఁచ్ పోడియొ చి దొన్ని మొస్స అస్తి. నెంజిలె, అమ్ గెచ్చ ఈంజేఁవ్ ఎత్కిజిన్‍క అన్నిమ్ గెన ఆనుక గె?” మెల. ");
INSERT INTO key_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","జా జనాబ్‍తెచ మున్సుబోదల్ కెత్తిజిన్ జవుల మెలె, పాఁచ్ వెయిల్‍జిన్. గని యేసు సిస్సుల్‍క “యాబయ్ జిన్‍క ఏక్ దవుని, యాబయ్ జిన్‍క అన్నెక్ దవుని, దస్సి దవుని దవునివొ తెన్ జేఁవ్ ఎత్కిజిన్‍క వెసడ” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","జేఁవ్ దస్సి కెర ప్రెజల్ ఎత్కిజిన్‍క వెసడ్ల. ");
INSERT INTO key_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","తెదొడి యేసు జేఁవ్ పాఁచ్ పోడియొ చి దొన్ని మొస్స దెర, ఆగాసుమ్ పక్క దెక, ‘ఈంజ తూయి దిలది’ మెన దేముడు అబ్బొస్‍క జొఒర సంగ కెర, జేఁవ్ పోడియొ మోడ కెర, “ఎత్కిజిన్‍క వంట దాస” మెన సిస్సుల్‍చి అత్తి సొర్ప కెర దిలన్. ");
INSERT INTO key_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","జేఁవ్ ఎత్కిజిన్ పేట్ బెర్తు కయ్‍ల చి, సేంసిల పోడియొ గండల్ మొస్స గండల్ బార గంపల్‍తె బెర్తు జల. ");
INSERT INTO key_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ఏక్ సుట్టు, యేసు ఎక్కిలొయి ప్రార్దన కెర్తె తిలన్, గని జోచ బారజిన్ సిస్సుల్‍క ఒత్తయ్ తిల, చి “కొన్సొ మెన ప్రెజల్ అంక సంగితతి?” మెన యేసు సిస్సుల్‍క పుసిలన్. ");
INSERT INTO key_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","పుసితికయ్, “బాప్తిసుమ్ దెతె తిలొ యోహాను” మెన సగుమ్‍జిన్ తుక సంగితతి. అన్నె సగుమ్‍జిన్ తుక “దేముడుచి కబుర్లు సంగిలొ ఏలీయా జాఁ తయెదె” మెంతతి చి, అన్నె సగుమ్‍జిన్ “దేముడుచి కబుర్లు సంగిలొ అన్నెక్లొ పూర్గుమ్‍చొ జీవ్ జా అమ్‍చితె జా అస్సె.” మెంతతి మెల. ");
INSERT INTO key_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","జేఁవ్ దస్సి మెంతికయ్, యేసు “తుమ్, జలె, కొన్సొ మెన అంక సంగితసు?” మెన జోవయింక పుసిలన్ చి, “‘తెద్రయిందె’ మెన దేముడు సంగ తిలొ క్రీస్తు మెలొ రచ్చించుప కెర్తొసొ తుయి” మెన పేతురు జబాబ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","గని “జా కోడు అన్నె కక్క కి సంగ నాయ్” మెన జోవయింక యేసు కచితుమ్ తెన్ ఆడ్ర దిలన్. ");
INSERT INTO key_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","అన్నె జో, “ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ ఒగ్గర్ స్రెమల్ సేడుక అస్సె. వెల్లెల సుదల్, వెల్లెల పూజర్లు చి, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస అంక ‘జివుస్ నాయ్’ మెనుక అస్సె చి, ఆఁవ్ మొరుక అస్సె. గని తిర్రత్‍క ఆఁవ్ అన్నె జీవ్ జా ఉట్టుక అస్సె” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","తెదొడి ఎత్కిజిన్‍క యేసు, “కో అంక నంపజా అంచి పట్టి బులుక ఉచరుల గే, జోచి సొంత ఇస్టుమ్ కెరుక ముల దా, రోజుక జోచి సొంత సిలువ వయన అంచి పట్టి బులుక అస్సె. ");
INSERT INTO key_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","కిచ్చొక మెలె, జోచి సొంత ప్రానుమ్ రచ్చించుప కెరనుక కో కోర్‍ప జవుల గే, జోచి ప్రానుమ్ పాడ్ జా గెచ్చెదె. గని అంచి రిసొ కో జోచి ప్రానుమ్ దెతి రితి ఎక్కి మెన్సు నిదానుమ్ ఇండుల గే, జోచి ప్రానుమ్ రచ్చించుప జయెదె. ");
INSERT INTO key_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","మెలె, ఈంజ లోకుమ్‍తె తిలిసి ఎత్కి కేన్ మాన్సు జవుస్ కలుగు కెరన జోచి ప్రానుమ్ పాడ్ కెరన్లెగిన, జేఁవ్‍క సిచ్చ జలెగిన, జోక కిచ్చొ లాబుమ్? కిచ్చొ లాబుమ్ నాయ్. ");
INSERT INTO key_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","కో జలెకు అంచి రిసొచి అంచ కొడొచి రిసొ లాజ్ జా సత్తిమ్ నే ఒప్పనుల గే, ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ పరలోకుమ్ గెచ్చ అంచి అన్నె అబ్బొసి జలొ దేముడుచి దూతల్‍చి పరలోకుమ్‍చి ఉజిడ్‍చి గవురుమ్ తెన్ ఈంజ లోకుమ్‍తె అన్నె ఉత్ర జెతి దీసిక, జేఁవ్ మాన్సుల్‍క ‘అంచ’ మెన ఒప్పన్‍తి రితి అంచి తెన్ బెదవనుక అంక లాజ్ తయెదె. ");
INSERT INTO key_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","గని తుమ్‍క ఆఁవ్ కిచ్చొ కచితుమ్ సంగితసి మెలె, ఇన్నె టీఁవ తిలస సగుమ్‍జిన్ నే మొర్తె అగ్గె దేముడుచి రాజిమ్ దెకుల” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","జలె, యేసు ఈంజేఁవ్ కొడొ సంగ పాసి పాసి అట్టు దీసల్ గెతికయ్, ప్రార్దన కెరుక మెన, పేతురుక యోహానుక చి యాకోబుక వట్టె కడ దెరన, యేసు డోంక్ తిలి మెట్టయ్ గెచ్చ వెగిల. ");
INSERT INTO key_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","యేసు ప్రార్దన కెర్తె తతికయ్, జోచి మొకొమ్ మార్సుప జలన్ చి, జోచ పాలల్ చొక్కిల జా దగదగాల్న మెర్సుప జల. ");
INSERT INTO key_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","అన్నె, ఈందె, దొగుల మున్సుబోదల్ డీస యేసు తెన్ లట్టబ్ల. కొన్స మెలె, పూర్గుమ్‍చ దేముడుచి కబుర్లు సంగిత మోసే అన్నె ఏలీయా తిల. ");
INSERT INTO key_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","జేఁవ్ పరలోకుమ్‍చి ఉజిడ్ తెన్ డీసిల చి, కిచ్చొచి రిసొ లట్టబ్తె తిల మెలె, దేముడుచి కోడు తెన్ రెగిడ్లి రితి యేసు మొరుక తిలిస్‍చి రిసొ, జో మొర్తిసి ఉట్ట గెతిసి యెరూసలేమ్‍తె జర్గు జంక తిలిస్‍చి రిసొ. ");
INSERT INTO key_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","పేతురు చి జోవయింతెన్ తిల దొగుల గూన్‌క నిజ తిల గని, అన్నె చెద్దొయి జలె. యేసు పరలోకుమ్‍చి ఉజిడి జలిసి చి, జో తెన్ జేఁవ్ దొగుల పూర్గుమ్‍చ టీఁవిలిసి దెకిల. ");
INSERT INTO key_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","జలె, జేఁవ్ పూర్గుమ్‍చ యేసుక ములుక దెర్లి పొది పేతురు యేసుక “గురుబాబు, అమ్ ఇన్నె తతిసి చెంగిలి. తుక ఏక్, మోసేక ఏక్, ఏలీయాక ఏక్ మొత్తుమ్ తిన్ని కుడియల్ బందుమ్‍దె” మెలన్, గని జో కిచ్చొ సంగితయ్ గే నేనె. ");
INSERT INTO key_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","జలె, జో ఇసి సంగితె తతికయ్, మబ్బు ఏక్ ఉత్ర జా జోవయింక డంకిలన్ చి, డంకి జతికయ్, సిస్సుల్ బియఁ గెల. ");
INSERT INTO key_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","మబ్బు తెంతొ “ఈంజొ అంచొ పుత్తు, అఁవ్ నిసాన్లసొ. ఇన్నెచి కోడు తుమ్ సూన” మెన జా మబ్బు తెంతొ అవాడ్ సంగిలిసి సూన్ల. ");
INSERT INTO key_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","జలె, జా కోడు సంగ కేడయ్‍లి బేగి, యేసు ఎక్కిలొయి జేఁవ్ తీగ్ల సిస్సుల్ తెన్ తిలొ. జలె, జర్గు జలిస్‍చి రిసొ సిస్సుల్ తుక్లె తా, జేఁవ్ పొదులె కక్క కి జేఁవ్ దెకిలిస్‍చి రిసొ ఎక్కి కోడు కి సంగితి నాయ్. ");
INSERT INTO key_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","అన్నెక్ దీసి, జేఁవ్ మెట్టయ్ తెంతొ ఉత్ర జెతికయ్. ఒగ్గర్‍జిన్ జనాబ్ యేసుక దస్సుల్ జల. ");
INSERT INTO key_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ఈందె, జేఁవ్ జనాబ్‍తెచొ మాన్సు కేక్ గలొ. “గురుబాబు, అంక ఎక్కిలొ పుత్తు. జోక దెకు, మెన తుక ఆఁవ్ బతిమాల్ప జతసి! ");
INSERT INTO key_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ఈందె, ఏక్ బూతుమ్ జోక దెరుక అలవాట్ అస్సె చి, కెఁయ దెర్లె, ఈంజొ కేక్ గలన ఒర్సెదె చి, బూతుమ్ జోక పొర్లుప కెరెదె చి, చోండివాట్ ఈంజొ పొగుర్లు బార్ కెరవంతయ్ చి, ఇన్నెక ఒగ్గర్ అల్లర్ కెర పూర్తి అల్పు కెర కస్టనె ముల ఉట్ట గెతయ్. ");
INSERT INTO key_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","అన్నె బూతుమ్‍క ఉదడ దాస మెన తుచ సిస్సుల్‍క బతిమాల్ప జా సంగితె తిలయ్, గని జేఁవ్ నెతిర్ల” మెన జో మాన్సు యేసుక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","సంగితికయ్, యేసు కిచ్చొ జబాబ్ దిలన్ మెలె, “నముకుమ్ నెంజిలి వెర్రి బుద్దిచి కాలుమ్‍చ, తుమ్. తుమ్‍చి తెన్ ఆఁవ్ కెత్తి దీసల్ తంక? కెత్తి దీసల్ తుమ్‍క ఆఁవ్ ఓర్సుప జంక? అల్లె, జో నాడుక అంచితె కడ ఆను!” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","జలె, జో నాడు పాసి జెతె తతికయ్, బూతుమ్ జోక పొర్లు కెరవ గిజ్జిగిజ్జిల్ కెరయ్‍లన్. గని యేసు జో బూతుమ్‍క గోల కెర్లన్ చి, జో నాడుక చెంగిల్ కెర, అబ్బొస్‍చి అత్తి జోక అన్నె సొర్ప కెర్లన్, ");
INSERT INTO key_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","“దేముడు అమ్‍చొ కెద్ది సెక్తి అదికారుమ్‍చొ!” మెన ఎత్కిజిన్ జోచి ఆచారిమ్ సంగితె తిల చి, యేసు జర్గు కెర్లిస్‍చి రిసొ ఎత్కిజిన్ జోచి ఆచారిమ్ సంగితె తతికయ్, యేసు జోచ బారజిన్ సిస్సుల్‍క, ");
INSERT INTO key_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“ఆఁవ్ అప్పె సంగితిసి తుమ్ చెంగిల్ సూన. మెలె, ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొక విరోదుమ్ సుదల్ అన్నె మాన్సుల్‍చి అత్తి సొర్ప కెర దెంక అస్సె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","గని జా కోడుచి అర్దుమ్ జోవయింక జయె నాయ్. జేఁవ్ జా అర్దుమ్ నే కెరంతి రితి ఎత్కి అదికారుమ్ తిలొ దేముడు లుంకడ్లన్ చి, యేసుక పుసుక బియఁ తుక్లె తిల. ");
INSERT INTO key_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","జలె, “అమ్‍చితె కో వెల్లొ ముక్కిమ్ జయెదె?” మెన సిస్సుల్ లట్టబన ఇదిల్ గగ్గొల్ జల. ");
INSERT INTO key_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","గని జోవయించి పెట్టి ఉచర్లిసి యేసు చిన కెర, ఏక్ బాలబోదక దెర, జోచి పక్క టీఁవడ, ");
INSERT INTO key_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","జోవయింక ఇసి మెలన్. “ఈంజొ బాలబోదక జవుస్ అంచి నావ్ తెన్ కో జలెకు మరియాద కెరెదె గే, అంకయ్ మరియాద కెర్లి రితి జయెదె. అన్నె, కో జలెకు అంకయ్ మరియాద కెరుల గే, అంక తెద్రయ్‍లొ దేముడు అబ్బొక కి మరియాద కెర్లి రితి జయెదె. తుమ్ ఎత్కిజిన్‍తె కో దాకు కెరనెదె గే, జొయ్యి వెల్లొ జయెదె” మెన జోవయింక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","తెదొడి యోహాను మెలొ సిస్సుడు యేసుక కిచ్చొ మెన సంగిలన్ మెలె, “గురుబాబు, ఎక్కిలొ తుచి నావ్ తెన్ బూతల్‍క ఉదడ్లిసి దెకిలమ్. జో అమ్‍చి తెన్ తుచి పట్టి గెతొసొ నెంజెచి రిసొ జోక ఆటంకుమ్ కెర్లమ్” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","గని యేసు జోవయింక, “జోక ఆటంకుమ్ కెర నాయ్. కిచ్చొక మెలె, కో తుమ్‍చి కామ్‍చి ఉప్పిరి విరోదుమ్ కెరె నాయ్ గే, తుమ్‍చి పచ్చెన జతొసొ జయెదె” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ఒత్త తెంతొ కిచ్చొ జర్గు జలి మెలె, యేసు మొర్తి పరలోకుమ్‍తె అన్నె గెతి సమయుమ్ పాసి జా అయ్‍లి పొది, ‘యెరూసలేమ్‍తె అప్పె ఉట్ట గెచ్చుక అస్సె’ మెన జాన కెర బార్ జలన్, అన్నె వట్టె గెతె తా, ");
INSERT INTO key_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","‘అంక టాన్ తెయార్ కెర్తు’ మెన, సగుమ్‍జిన్‍క యేసు పుర్రె కబుర్ తెద్రయ్‍లన్. దస్సి మెన జేఁవ్ గెచ్చ, సమరయ సుదల్‍చి ఏక్ గఁవ్వి గెల. ");
INSERT INTO key_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","గని జా గఁవ్విచ ప్రెజల్ యేసుక టాన్ దెంక నెసిల. కిచ్చొక మెలె, యెరూసలేమ్‍తె గెచ్చుక జోచి ఉద్దెసుమ్. ");
INSERT INTO key_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","‘జా గఁవ్విచ దస్సి బుద్ది తెన్ అస్తి’ మెన యేసుచ సిస్సుల్ యాకోబు చి యోహాను దెక కెర, కిచ్చొ మెల మెలె, “ప్రబువ, ఇన్నెక డయ గెలి రితి ఆగాసుమ్ తెంతొ ఆగి ఆనవుమ గె?” మెన పుసిల. ");
INSERT INTO key_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","గని యేసు పసుల జోవయింక గోల కెర్లన్. ");
INSERT INTO key_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","జోచ సిస్సుల్ తెన్ తోడ్ అయ్‍ల తేర్‍బోదల్ తెన్ వట్టె గెచ్చ, అన్నెక్ గఁవ్వి గెల. ");
INSERT INTO key_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","యేసు సిస్సులీఁసి తెన్ వట్టె గెతె తతికయ్, ఏక్ మాన్సు యేసుతె జాఁ కెర, “తుయి కేనె గెలె కి, అఁవ్ కి తుచి తెన్ బెద జెయిందె” మెన యేసుక సంగిలన్ చి, ");
INSERT INTO key_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","యేసు జోక, “నక్కల్‍క పార్లు, ఆగాసుమ్‍చ పిట్టల్‍క గూడలు, గని ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొక బోడి వంపొ కెర్తి టాన్ నాయ్” మెన జబాబ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","అన్నెక్లొక, “అంచి పట్టి జె” మెలన్, గని “ప్రబు, ఆఁవ్ తుచి తెన్ నే జెతె అగ్గె గెచ్చ కెర, అంచొ అబ్బొ మొర గెతె ఎదక జోక పోస కెర, జో మొర్లె జోక రోవ గెలుక మెన, అంక సెలవ్ దె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","యేసు జోక కిచ్చొ సంగిలన్ మెలె కి, “మొర్లస జోవయించ సొంత మొర్లసక రోవ గెల్తు, గని తుయి కిచ్చొ కెరుక అస్సె మెలె, ‘దేముడుచి రాజిమ్ పాఁవ జా అస్సె’ మెన, తుయి గెచ్చ, జా రాజిమ్‍చి రిసొచి సుబుమ్ కబుర్ బోదన కెరు” మెన ఆడ్ర దిలన్. ");
INSERT INTO key_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ఒత్త తెంతొ అన్నెక్లొ “తుచి పట్టి జెయిందె, ప్రబు. గని తొలితొ ఆఁవ్ గెరి గెచ్చ, గెర్‍చ మాన్సుల్‍క ఆఁవ్ సంగ జెతి రితి సెలవ్ దె” మెన యేసుక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","జోక యేసు, “కో జలెకు నాఙెల్ దెర కేఁసుక మొదొల్ కెర పడ్తొ దెకితె తిలె, జో మాన్సు దేముడుచి రాజిమ్‍చి కామ్‍క నెంజె” మెన జబాబ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ఇన్నెచి పడ్తొ యేసు అన్నె డబ్బయ్‍జిన్ మాన్సుల్‍క నిసాన, జేఁవ్ దొగుల దొగుల బార్ జా, జో గెచ్చుక తిలి ఎత్కి పట్నుమ్, ఎత్కి టాన్‍తె జేఁవ్ పుర్రె గెచ్చుక మెన జోవయింక తెద్రయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","తెద్రయ్‍లి పొది జోవయింక, “గట్టిఙ పంటొ పిక లాయితి కాలుమ్ జా అస్సె. పంటొ బలేగ ఒగ్గర్ అస్సె, గని పికిల్ పంటొ లాయ ఆన్‍తి రిసొ దస్సి ఆన్‍త మాన్సుల్ తొక్కిజిన్ అస్తి. జాకయ్, ఈంజ పంటొ లాయితసక బార్ కెర తెద్రవు” మెన ఈంజ పంటొ పికడ్తొ ఎజొమానిక తుమ్ ప్రార్దన కెర. ");
INSERT INTO key_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","అల్లె, బార్ జా గెచ్చ. ఈందె, నక్కల్‍చి నెడిమి మెండ పిల్లల్‍క తెద్రయ్‍లి రితి తుమ్‍క ఆఁవ్ తెద్రయ్‍తసి. ");
INSERT INTO key_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","డబ్బుల్ సెంచె జవుస్, జోడ్లు జవుస్ దెరన గెచ్చ నాయ్, అన్నె వట్టె సమయుమ్ పాడ్ కెర్తి రితి కచి తెన్ లట్టబా నాయ్. ");
INSERT INTO key_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","అన్నె, కేన్ గెరి తుమ్ గెతె గే బేగి, “ఈంజ గేరుచి ఉప్పిరి దేముడుచి సేంతుమ్ తవుస్!” మెన తుమ్ సంగ. ");
INSERT INTO key_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","జా గెరితె సేంతుమ్‍చొ మాన్సు తిలె, తుమ్ సంగిలి సేంతుమ్ జోవయించి ఉప్పిరి తయెదె. గని దసొ మాన్సు నెంజిలె, తుమ్ ఆన్‍లి సేంతుమ్ ఒత్త నే తయెదె, పసుల తుమ్‍చితె అన్నె బుల జెయెదె. ");
INSERT INTO key_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","జలె, కేన్ సేంతుమ్ గెర్‍చ తుమ్‍క టాన్ దిలె జయ్యి గెరి తా, వేరచితె ఉట్ట గెచ్చ నాయ్. అన్నె, తుమ్ ఒత్త తిలె పొది, జేఁవ్ దెతిసి కతె పితె తా జా గెరి తా, కిచ్చొక మెలె కామ్ కెర్తొసొ జోచి జీతుమ్ నఙనుక నాయిమ్. గేర్ గేర్ బుల నాయ్. ");
INSERT INTO key_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","తుమ్ కేన్ పట్నుమ్ గెలె కి, జేఁవ్ తుమ్‍క మరియాద కెర, జేఁవ్ తుమ్‍క కిచ్చొ దిలెకి జా కా. ");
INSERT INTO key_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","అన్నె, జా పట్నుమ్‍చ జొర్జొల్ జబ్బుల్ తిల మాన్సుల్‍క చెంగిల్ కెర చి, “దేముడుచి రాజిమ్ తుమ్‍క పాసి జా అస్సె.” మెన జోవయింక బోదన కెర. ");
INSERT INTO key_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","గని కేన్ పట్నుమ్ తుమ్‍క కిచ్చొ మరియాద కెర్తి నాయ్ గే, జా పట్నుమ్‍చ వీదులె తుమ్ గెచ్చ, ఇసి మెన సంగ. ");
INSERT INTO key_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“అమ్‍చ చట్టెలె లంబిలి తుమ్‍చి పట్నుమ్‍చి దూడి కి తుమ్‍చి బుద్దిచి ఉప్పిరి సాచి తతి రితి పంప్డ దా ఉట్ట గెతసుమ్. గని కిచ్చొ కోడు తుమ్ ఉచరన మెలె, దేముడుచి రాజిమ్ పాసి జా అస్సె మెన తుమ్ సాచి సంగ. ");
INSERT INTO key_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","తుమ్‍క ఆఁవ్ కిచ్చొ మెంతసి మెలె, ఈంజ లోకుమ్‍చ మాన్సుల్‍క వెల్లి తీర్పు కెర్తి దీసి అయ్‍లె, సొదొమ మెలి పూర్గుమ్ కుడ్తె నాసెనుమ్ జలి పట్నుమ్‍చి గత్తిచి కంట, తుమ్‍క మరియాద నే కెర్లి కేన్ పట్నుమ్‍చచి ఉప్పిర్ ఒగ్గర్ సిచ్చ జయెదె” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“అయ్యొ! కొరాజీనా పట్నుమ్‍చ చి బేత్సయిదా పట్నుమ్‍చ, తుమ్‍చి సిచ్చ కెద్ది! తుమ్‍చి నెడిమి ఆఁవ్ కెర్ల కమొ అమ్‍చ యూదుల్ నెంజిల తూరు చి సీదోను మెల పట్నలె ఆఁవ్ కెర్తయ్ జలె, జేఁవ్ పట్నల్‍చ మాన్సుల్, జేఁవ్ కెర్ల పాపల్‍క రిసొ అగ్గెయి దుకుమ్ జా ములిత, జేఁవ్ కెర్ల పాపల్‍చి రిసొచి దుకుమ్‍క బస్తల్ బందన, సార్ గాంసన వెస తా జేఁవ్ జోవయించి పాపుమ్‍క దుకుమ్ జలిస్‍చి రుజ్జుల్ దెకయ్‍త. ");
INSERT INTO key_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","గని పూర్గుమ్ జేఁవ్ తూరు పట్నుమ్‍చ కి సీదోను పట్నుమ్‍చ కి ఒగ్గర్ పాపుమ్ కెర్తె తిలె కి, ఈంజ లోకుమ్‍చ ఎత్కిజిన్‍క వెల్లి తీర్పు కెర్తి జా దీసి తుమ్‍క జతి సిచ్చ జేఁవ్ పట్నల్ జతి సిచ్చచి కంట ఒగ్గరి జయెదె. ");
INSERT INTO key_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","పడ్తొ తూమ్, కపెర్నహూమ్ పట్నుమ్‍చ మాన్సుల్, తుమ్ పరలోకుమ్‍తె ఉక్కిల్ జస్తె గె? నాయ్, గెద, తుమ్ వెల్లి ఆగి గొయ్‍తె ఉత్ర గెతె” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","తెదొడి యేసు జోచ సిస్సుల్‍క, “తుమ్‍చి కోడు కో సూనుల గే, అమ్‍చి కోడు సూన్లి రితి జయెదె. తుమ్‍కయ్ కో మరియాద కెర్తి నాయ్ గే, అంకయ్ కి మరియాద నే కెర్లి రితి జయెదె. కో అంకయ్ మరియాద కెర్తి నాయ్ గే, అంక తెద్రయ్‍లొ దేముడు అబ్బొక కి మరియాద నే కెర్లి రితి జతయ్” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","యేసు అగ్గె గఁవ్విలె తెద్రయ్‍ల డబ్బయ్‍జిన్ జోవయించి కామ్ కెర కేడవన, సర్దసంతోసుమ్ తెన్ యేసుతె అన్నె ఉట్ట జా కెర, “ప్రబు, గెచ్చ మెన బూతల్‍క తుచి నావ్ తెన్ ఉదడ్లె, అమ్‍చి కోడు జేఁవ్ కి సూన ఉట్ట గెతతి” మెన జోవయించి సర్ద సంగిల. ");
INSERT INTO key_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","యేసు జోవయింక, “సయ్‍తాన్ పరలోకుమ్ తెంతొ, జోచి టాన్ తెంతొ బిజిలి మొల్కిలి రితి. డీస సేడ గెలిసి ఆఁవ్ దెకిలయ్. ");
INSERT INTO key_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ఈందె, తుమ్‍క కెద్ది అదికారుమ్ దా అస్సి మెలె, తుమ్ అయివొక, పొట్టెల్‍క సుఁదిలె జవుస్ తుమ్ కిచ్చొ ప్రమాదుమ్ జసు నాయ్, సయ్‍తాన్‍చి సెక్తి తిలస ఎత్కిచి ఉప్పిరి తుమ్ ప్రమాదుమ్ నెంతె జీన్‍తె. తెద్ది సెక్తి అదికారుమ్ తుమ్‍క దా అస్సి. ");
INSERT INTO key_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","గని ముక్కిమ్‍క తుమ్ కిచ్చొచి రిసొ సర్దసంతోసుమ్ తంక మెలె, బూతల్ గట్ర తుమ్‍క బియఁ ఉట్ట గెతిస్‍చి రిసొ నాయ్, గని ‘ఇన్నె జెవుల’ మెన తుమ్‍చ నవ్వొ పరలోకుమ్‍తె రెగిడ్లిస్‍చి రిసొయి తుమ్ సర్దసంతోసుమ్ జా” మెన యేసు జోవయింక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","జయ్యి గడియయ్ దేముడుచి సుద్ది తిలి ఆత్మసెక్తిక యేసు ఒగ్గర్ సర్దసంతోసుమ్ జా దేముడు అబ్బొస్‍క కిచ్చొ మెన ప్రార్దన కెర్లన్ మెలె, “పరలోకుమ్‍క కి బూలోకుమ్‍క కి అదికారుమ్ తిలొ ఓ బ, ‘జానుమ్’ మెన జోవయింక జెఁవ్వి గవురుమ్ ఉచరంతసక చి ఒగ్గర్ సదు కెర్లసక ఈంజ జర్గు జతిసి ఎత్కిచి అర్దుమ్ లుంకడ, బాలబోదల్ జల రిత గవురుమ్ నెంజిలసక అర్దుమ్ దెకవ అస్సిసి మెన తుక జొఒర, మెన అంచి సర్ద ఆఁవ్ సంగితసి. తుచి దయతె ఇసి కెర్లది, గెద” మెన ప్రార్దన కెర్లన్. ");
INSERT INTO key_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“అంచొ అబ్బొ ఎత్కి అంచి అత్తి సొర్ప కెర దా అస్సె. అన్నె, ఆఁవ్ పుత్తుసి కొన్సొ జయిందె గే అబ్బొ ఎక్కిలొయి జానె, చి అబ్బొ కొన్సొ జయెదె గే, ఎక్కి ఆఁవ్ పుత్తుసి జాని, చి అన్నె కక్క జోవయింక దెకయిందె గే, జెఁవ్వి జాన్‍తి” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","తెదొడి యేసు జోచ బారజిన్ సిస్సుల్ తిలి పక్క పసుల ఎక్కి జోవయింకయ్, “తుమ్ దెకితిసి దెకిత మాన్సుల్‍క చెంగిలి! ");
INSERT INTO key_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","తుమ్‍క ఆఁవ్ కిచ్చొ మెంతసి మెలె, పూర్గుమ్‍చక చి కంట తుమ్‍క ఒగ్గర్ చెంగిలి. కిచ్చొక మెలె, పూర్గుమ్ దేముడుచ కబుర్లు సంగిలస ఒగ్గర్‍జిన్, రానల్ ఒగ్గర్‍జిన్ తుమ్ దెకితిసి దెకుక జేఁవ్ కోర్‍ప జలెకి, దెకుక నెతిర్ల. తూమ్ సూన్‍తిసి సూనుక జేఁవ్ కోర్‍ప జలెకి, సూనుక నెతిర్ల. జా అవ్‍కాసుమ్ జోవయింక దొర్కు జయె నాయ్” మెన యేసు సిస్సుల్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ఏక్ సుట్టు యూదుల్‍చి మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తొసొ ఎక్కిలొ టీఁవ కెర, యేసుక పరిచ్చ కెరుక ఉచర ఇసి పుసిలన్. “గురుబాబు, పరలోకుమ్‍చి రాజిమ్‍తె ఆఁవ్ బెద కెఁయఁక తెఁయఁక జితి వాట్ అంక దొర్కు జంక మెలె, ఆఁవ్ కిచ్చొ కెర్లె జయెదె?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","జో దస్సి పుసితికయ్, యేసు జోక, “మోసే పూర్గుమ్‍చొచి అత్తి దేముడు రెగ్డయ్‍ల ఆగ్నల్‍తె కిచ్చొ మెన రెగ్డ అస్సె? ఒత్త కిచ్చొ సంగితయ్?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","జో యేసుక కిచ్చొ జబాబ్ దిలన్ మెలె, “తుమ్‍చొ ప్రబు జలొ దేముడుక తుచి ఎత్కి పెట్టి తెన్, తుచి ఎత్కి మెన్సు తెన్, తుచి ఎత్కి సెక్తి ఎత్కి తెన్, తుచి ఎత్కి బుద్ది తెన్ నిదానుమ్ ఎక్కి ప్రేమ కెర్తె తంక. అన్నె, తుమ్‍క తుమి కెద్ది ప్రేమ కెరంతసు గే, తుచి పక్కయ్‍చక కి తెద్ది ప్రేమ కెర్తె తంక” నేన దేముడు మోసేచి అత్తి దిలి ఆగ్నల్‍చి కోడు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","జో దస్సి జబాబ్ దెతికయ్, యేసు జోక “తుయి సరిగా జబాబ్ దిలది. తుయి సంగిల్ రితి కెర్తె తిలె, పరలోకుమ్‍తె తుయి బెద కెఁయఁక తెఁయఁక జితి వాట తుక దొర్కు జయెదె” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","జో మాన్సు, జలె, జో అన్నె సగుమ్‍జిన్‍క చెంగిల్ నే దెకితిస్‍క, ‘తప్పు నెంజె’ మెన రుజ్జు దెకుక ఉచర, “జలె, అన్నె మాన్సుల్‍క మెలె, కక్క?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","పుసితికయ్, యేసు ఏక్ టాలి సంగ జబాబ్ దిలన్. ఇసి మెన; “అమ్‍చొ యూదుడు ఎక్కిలొ యెరూసలేమ్ తెంతొ యెరికో పట్నుమ్‍తె గెచ్చుక మెన వట్టె గెతె తిలన్, చి చోర్లుచి అత్తి దెర్ను సేడ్లన్‍క, జేఁవ్ జోచ పాలల్ కడ కెర జోక పెట గెల కెర, జోక ఇదిలిదిల్ జీవ్ తతె, జో మొర్తి రితి ముల దా ఉట్ట గెల. ");
INSERT INTO key_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“జలె, కీసి గే పూజరి ఎక్కిలొ జయి వాట్ అయ్‍లన్, అన్నె, జో మాన్సుక దెక పాసి నే గెతె వాట్‍చి ఒత్తల్‍తొ పక్క ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","దస్సి, దేముడుచి గుడితెచి సేవ కెర్తొ లేవీయుడు ఎక్కిలొ కి జా టాన్‍తె అయ్‍లె, జో కి దెక కెర, వాట్‍చి ఒత్తల్‍తొచి పక్క ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“గని సమరయ సుదొ ఎక్కిలొ జా వట్టె ప్రయానుమ్ గెతె తా, జో మాన్సు సేడ తిలిస్‍తె అయ్‍లన్, అన్నె జోక దెక కెర, యూదుల్ నిస్కారుమ్ దెకితొ ఈంజొ సమరయ సుదొ, జో సేడ తిలొ యూదుడుచి ఉప్పిరి కన్కారుమ్ జా, ");
INSERT INTO key_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","పాసి గెచ్చ దెబ్బల్ లయ్‍లిస్‍తె తేలు చి ద్రాచ రస్సుమ్ ‘ఓస్తు’ మెన సువ దా, కట్లు బందిలన్ చి, ఇన్నెచి సొంత గాడ్దెచి ఉప్పిరి వెగడ దా, ఏక్ అద్దె గెరితె న కెర, జోవయింక దొర్కు జలి సావ్రెచన కెర్లన్. ");
INSERT INTO key_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","అన్నెక్ దీసి, దొరత్ చి కూలిచి ఎదిలి డబ్బుల్ జేబితె తెంతొ వెంట కెర, జా అద్దె గెరిచొ సావుకరిక దా, ఈంజొ మాన్సుక చెంగిల్ దెకితె తా, ఇన్నెచి రిసొ అన్నె కిచ్చొ కర్చు సేడ్తె గే, ఆఁవ్ అన్నె అయ్‍లి పొది తుక దెందె మెన ఈంజొ సమరయ సుదొ ఒప్పన్లన్. ");
INSERT INTO key_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“జలె, చోర్లుతె దెర్ను సేడ్లొ జో అన్నెక్లొక ఈంజేఁవ్ తీగ్లతె కేన్ మాన్సు ప్రేమ కెర్లొసొ జలొ? కిచ్చొ ఉచర్తసి? సంగు” మెన జోక యేసు పరిచ్చ కెర్లన్. ");
INSERT INTO key_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","“జోక కన్కారుమ్ దెకిలొసొ” మెన జబాబ్ దిలన్‍చి, రిసొ యేసు జోవయింక, “తుయి గో, చి అన్నె మాన్సుల్‍క దస్సి ప్రేమ కన్కారుమ్ దెకితె తా” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","జలె, యేసు అన్నె సిస్సుల్ వట్టె గెతె తతికయ్, ఏక్ గఁవ్వి పాఁవ అయ్‍లక, మార్త మెలి తేర్‍బోద జోవయింక మరియాద కెరుక మెన గెరి బుకార్లన్. ");
INSERT INTO key_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","జాక మరియ మెలి బేన్సి తిలి. జా, జలె, ప్రబుచి చట్టె వెస జో సంగితె తిలి బోదన సూన్‍తె తిలి. ");
INSERT INTO key_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","మార్త, గెర్‍చి కామ్ కెరుక మెన బమ్మ జతె తిలి, అన్నె, యేసుతె గెచ్చ కెర, “ప్రబు, ఆఁవ్ ఎక్కిలి ఈంజ కామ్ కెర్తి రితి అంచి బేని బద్దుకుమ్ జా ములితయ్ మెన దెకిస్ నాయ్ గె? జా అంక తోడు కెర్సు. సంగు” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","గని ప్రబు జేఁవ్‍క కిచ్చొ జబాబ్ దిలన్ మెలె, “మార్త, మార్త, తుయి ఒగ్గర్ కమొ తియన బమ్మ జా పంబ్ర జతసి. ");
INSERT INTO key_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ఎత్కి కమొతె ఎక్కి ముక్కిమ్‍చి సుబుమ్ కబుర్ సూన్‍తి జయ్యి వాట మరియ నఙన అస్సె, జా జాచి తెంతొ కడుక జెయె నాయ్.” మెన జాక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ఏక్ దీసి కిచ్చొ జర్గు జలి మెలె, యేసు ఏక్ టాన్‍తె ప్రార్దన కెర్తె తిలన్, అన్నె, ప్రార్దన కెర కేడయ్‍లె, జోచ సిస్సుల్‍తె ఎక్కిలొ జోక “ప్రబు, బాప్తిసుమ్ దెతె తిలొ యోహాను జోచ సిస్సుల్‍క ప్రార్దన కెరుక సికడ్లి రితి, అమ్‍క కి ప్రార్దన కెరుక తుయి సికడ.” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","దస్సి సంగితికయ్, యేసు జోవయింక ఇసి మెలన్. “తుమ్ ప్రార్దన కెర్తె పొది ఇసి మెన; ఓ బ, తుచి నావ్ గవురుమ్ జవుస్. తుచి రాజిమ్ అమ్‍చితె జెవుస్. ");
INSERT INTO key_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","సరిపుచుప జతి అన్నిమ్ అమ్‍క రోజుక దొర్కు కెర దె. ");
INSERT INTO key_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","పడ్తొ, అమ్‍క పాపుమ్ కెర్త మాన్సుల్‍క ఆమ్ చెమించుప కెర్తసుమ్, చి ఆమ్ కెర్త పాపల్ తుయి అమ్‍క చెమించుప కెరు. అమ్ పాపుమ్ నే కెర్తి రితి, సయ్‍తాన్ పాపుమ్ కెరయ్‍తిస్ తెంతొ దయ కెర అమ్‍క పిట్టవు, మెన తూమ్ ప్రార్దన కెర” మెన యేసు సిస్సుల్‍క సికడ్లన్. ");
INSERT INTO key_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","తెదొడి జోవయింక అన్నె, “తుమ్‍తె కో జలెకు ఎక్కిలొ మితుసి జలె, అందరె సొక్కుక మింతుస్‍చి గెరి గెచ్చ, ఓ నేస్తము, అంక తిన్ని పోడియొ బదుల్ దె. ");
INSERT INTO key_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","అంచొ అన్నెక్లొ మిత దూరి ప్రయానుమ్ జా అస్సె చి, జోక అన్నిమ్ దెతిసి అమ్‍తె కిచ్చొ కి నాయ్”. ");
INSERT INTO key_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","పోడియొ సంగుక గెలి గెర్‍చొ ఎజొమాని, జలె, గేర్ తెడి తెంతొ “అంక ఇసి అల్లర్ కెరుక పోని. కెవ్డి డంక అస్సి చి, ఆఁవ్ అంచ బోదల్ నిజ అస్సుమ్. అప్పె ఉట్ట దెంక నెతిరి” మెనెదె, ");
INSERT INTO key_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","జలె, తుమ్‍క ఆఁవ్ కిచ్చొ మెంతసి మెలె, జో జోక మింతుస్ జయెదె చి రిసొ నాయ్; మింతుస్ జలెకి నెసె, గెద; గని జో లాజ్ నెంతె పుసితె తత్తయ్‍చి రిసొ, జో ఉట్ట కెర జోక దొర్కు జలిసి ఎత్కి దెయెదె. ");
INSERT INTO key_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","జాకయ్ తుమ్‍క ఆఁవ్ కిచ్చొ మెంతసి మెలె, దొర్కు జలిసి ఎత్కి, దేముడుతె తుమ్ సంగితె తా, తుమ్‍క దెయెదె. ఎక్కి మెన్సు తెన్ చజిలె దొర్కు జయెదె. కెవ్డితె ఉంక్రయ్‍తె తిలె, తుమ్‍క కెవ్డి ఉగ్డ దెయెదె. ");
INSERT INTO key_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","కో నఙిలె, జోక దొర్కు జయెదె, చజిలొసొక, దొర్కు జయెదె. కెవ్డితె కో ఉంక్రయ్‍లె, జోచి రిసొ ఉగ్డ దెయెదె. ");
INSERT INTO key_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","తుమ్‍తె సగుమ్‍జిన్‍క బోదల్, తుమ్‍తె కేన్ జవుస్ మాన్సుచొ పుత్తుసి “మొస్సొ రోస్ దె” మెలె, అబ్బొసి అయి దెయెదె గె? నాయ్, గెద. ");
INSERT INTO key_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","నెంజిలె “అండొ దె” మెలె, పొట్టె దెయెదె గె? నాయ్, గెద. ");
INSERT INTO key_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","జలె, తుమ్ మాన్సుల్ పాపుమ్ సుదల్ తిలె కి తుమ్‍చ బోదల్‍క చెంగిల్‌చి దెంక జాన్సు జలె, పరలోకుమ్ తిలొ దేముడు అబ్బొతె కో జోచి సుద్ది తిలి ఆత్మక నఙిలె దెయె నాయ్ గె? కచితుమ్ దెయెదె. ");
INSERT INTO key_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ఏక్ సుట్టు యేసు గుల్లొ కెర్తొ ఏక్ బూతుమ్‍క ఉదడ్తె తిలొ. జో బూతుమ్ జో మాన్సుక ముల దిలె, జో మాన్సు లట్టబుక మొదొల్ కెర్లొ, చి దెకిల ప్రెజల్ ఒగ్గర్ ఆచారిమ్ జల. ");
INSERT INTO key_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","గని జోవయింతె సగుమ్‍జిన్ పండితుల్ సూన కెర కిచ్చొ మెల మెలె, “బూతల్‍క రానొ జలొ బయెల్జెబూల్‍చి నావ్ తెన్ ఈంజొ బూతల్‍క ఉదడ్తయ్” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","అన్నె సగుమ్‍జిన్, జోక పరిచ్చ కెరుమ మెన ఉచర, “తుచి సెక్తి పరలోకుమ్‍చి అదికారుమ్‍చి తిలె, జా రుజ్జు దెకయ్‍తి కిచ్చొ జవుస్ వెల్లి కామ్ అమ్‍చి మొక్మె కెరు” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","గని యేసు జోవయించి మెన్సుతె తిలిసి జానె చి, జోవయింక, “కేన్ జవుస్ రాజిమ్‍తెచ మాన్సుల్ జోవయింక జెఁవ్వి విరోదుమ్ జా వర్స వర్స జా యుద్దుమ్ కెరన్లె, జా రాజిమ్ పాడ్ జా గెచ్చెదె, అన్నె, కేన్ గేరు జవుస్ మాన్సుల్ వర్స వర్స జా జోవయింక జెఁవ్వి విరోదుమ్ కెరన్లె, జా గేరు జవుస్ సేడెదె. ");
INSERT INTO key_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","దస్సి, సయ్‍తాన్ సయ్‍తాన్‍చి ఉప్పిరి జొయ్యి యుద్దుమ్ కెర్లె, జోచి రాజిమ్ కీసి టీఁవెదె, టీఁవుక నెత్రె మెలె, అంక బయెల్జెబూల్ జోవయింక సాయిమ్ తతికయ్ బూతల్‍క ఉదడ్తయ్” మెన తుమ్ సంగితసు. ");
INSERT INTO key_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","జలె, ఏక్ కోడు తుమ్ ఉచర. ఆఁవ్ ఏక్ వేల బయెల్జెబూల్‍చి నావ్ తెన్ బూతల్‍క ఉదడ్లెగిన, తుమ్‍చయ్ సిస్సుల్ కచి నావ్ తెన్ ఉదడ్తతి? బూతల్‍క ఉదడ్త తుమ్‍చయ్ సిస్సుల్ అంచి రిసొ తుమ్‍క తీర్పు సంగుతు! ");
INSERT INTO key_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","గని దేముడుచి ఆతుక మెలి కోడు జోచి సెక్తికయ్ ఆఁవ్ బూతల్‍క ఉదడ గెల్తసి జలె, కచితుమ్ దేముడుచి రాజిమ్ తుమ్‍తె అప్పె పాఁవ జా అస్సె. ");
INSERT INTO key_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","కేన్ జవుస్ బలుమ్ సుదొ, జోచ అయ్‍దల్ ఎత్కి దెరన జోచి సొంత గేరు రకితె తిలె, కో నే దెర గెతి రితి జోచ ఆస్తుల్ చెంగిల్ తవుల. ");
INSERT INTO key_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","గని జోచి కంట ఒగ్గర్ సెక్తి తిలొసొ అయ్‍లె, జోక పెట జీన్లె, జో మాన్సు నంప కెర్ల అయ్‍దల్ ఈంజొ అన్నె సెక్తి తిలొసొ వెంట గెల కెర, జోచ ఆస్తుల్ దెర గెచ్చ జోచ మితర్సుల్ తెన్ వాటల్ కెరన వంటనుల. ");
INSERT INTO key_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“జలె, కో అంచి పచ్చెన జయె నాయ్ గే, అంక విరోదుమ్ జా అస్సె, చి అంచి రాజిమ్‍తె జేఁవ్ బెదితి రితి కో అంచి తెన్ మాన్సుల్‍క అంచితె ఆనె నాయ్ గే, అంచి మందక చెదుర్ప కెర్తయ్.” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","తెదొడి యేసు అన్నెక్ కోడు సంగిలొ, “ఏక్ మాన్సుక బూతుమ్ దెర తిలెగిన, జో బూతుమ్ జో మాన్సుచి తెంతొ ముల దా తత్తిచి రిసొ టాన్ చజన బయిలె గెచ్చ బుల్తె తయెదె, గని టాన్ నే దొర్కు జలి రిసొ, ఉచరన, ఆఁవ్ ముల దిలొ గెరి అన్నె గెచ్చిందె మెన ");
INSERT INTO key_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","జో గెరి అయ్‍లె, జో గెర్‍చొ మాన్సు వడ్డవ కెర సుబ్రుమ్ కెర అస్సె మెన దెక కెర ");
INSERT INTO key_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","గెచ్చ, అన్నె జాచి కంట గర్చ సత్తు బూతల్‍క పట్టి కడ ఆనెదె చి, జేఁవ్ ఎత్కి జో మాన్సుతె పెస కెర, ఒత్తయ్ బస జవుల. జాచి రిసొ, పట్తొ జో మాన్సుక అగ్గెచి కంట ఒగ్గర్ అల్లర్ జయెదె” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","యేసు ఈంజ కోడు సంగితికయ్, కిచ్చొ జర్గు జలి మెలె, ఒత్త బెర తిల జనాబ్‍తె ఏక్ తేర్‍బోద “తుక పాయిలి దూదు పియడ్లి అయాద్‍క ఒగ్గర్ చెంగిలి!” మెన కేక్ గలిలి. ");
INSERT INTO key_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","జలె, యేసు కిచ్చొ జబాబ్ దిలన్ మెలె, “నాయ్, గెద. కక్క ఒగ్గర్ చెంగిల్ మెలె, దేముడుచి కోడు సూన, జయ్యి కోడ్ రితి ఇండితసకయ్” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","అన్నె ఒగ్గర్‍జిన్ ప్రెజల్ బెర జెతె తతికయ్, యేసు ఇసి మెన బోదన కెరుక దెర్లన్. “ఈంజ కాలుమ్‍చ మాన్సుల్ ఒగ్గర్ పాపుమ్‍చ. అంచి అదికారుమ్‍క రుజ్జు దెకయ్‍త వెల్లెల కమొక కోర్‍ప జతసు, గని అంచి అదికారుమ్ దెకయ్‍తి రిసొ ఎక్కిక పిట్టవ, కేన్ వేర కామ్ కెర దెంక నెంజె. కేన్ మెలె, దేముడుచ కబుర్లు సంగిలొ యోనా పూర్గుమ్‍చొక జర్గు జలిసి జా వెల్లి కామ్ టాలి జయెదె. ");
INSERT INTO key_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","యోనా పూర్గుమ్‍చొ తిర్రతి వెల్లొ మొస్సొచి పెట్టి తా బార్ జలిసి నీనెవె పట్నుమ్‍చ మాన్సుల్‍క ఏక్ రుజ్జు జలి, గెద. దస్సి, మాన్సు జా జెర్మున్ అయ్‍లయ్ అంక జర్గు జతిసి దొర్కు జలి రుజ్జు జయెదె. ");
INSERT INTO key_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“జలె, ఈంజ లోకుమ్‍చ మాన్సుల్‍క వెల్లి తీర్పు కెర్తి దీసిక, తుమ్ ఈంజ కాలుమ్‍చ అన్మానుమ్ జల యూదుల్ కి, యోనా బోదన కెర్ల నీనెవె పట్నుమ్‍చ ప్రెజల్ కి, బెద టీఁవితె. జేఁవ్ తుమ్‍క ‘గర్చ’ మెన రుజ్జు దెకవుల. కిచ్చొక మెలె, జా దేసిమ్‍చ మాన్సుల్ యోనా కెర్లి బోదన సూన కెర, జేఁవ్ కెర్ల పాపల్‍చి రిసొ దుకుమ్ జా, మెన్సు మార్చుప, నంపజా బుద్ది జల గని తూమ్ నాయ్. ఈందె, యోహానుచి కంట వెల్లొ తుమ్‍చి నెడిమి అస్సె. ");
INSERT INTO key_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","పడ్తొ, వెల్లి తీర్పు కెర్తి జా దీసిక, సేబా మెలి దచ్చెన దేసిమ్‍చి పూర్గుమ్ తిలి రాని ఎక్లి, ఈంజ కాలుమ్‍చ మాన్సుల్ తెన్ టీఁవ, తుమ్‍క ‘గర్చ’ మెన రుజ్జు దెకయెదె. కిచ్చొక మెలె, పూర్గుమ్ జా రాని ‘సొలొమోను రానొ సంగితి బుద్ది సూనిందె’ మెన, ఒగ్గర్ ఒగ్గర్ దూరి తెంతొ అయ్‍లి. గని, ఈందె, సొలొమోనుచి కంట వెల్లొ తుమ్‍చి నెడిమి అస్సె. ");
INSERT INTO key_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“కేన్ జవుస్ మాన్సు ఏక్ దీవు లంబడ తిలె, జా దీవుక ఆరి లంబడ్లి రితి గెర్‍చి మజ్‍గెర్‍తె కూన్లి గొయితె జవుస్ తితి నాయ్, నాడిచి తెడి జవుస్ డంకితి నాయ్, గని గెరి జెత ఎత్కిజిన్‍క జా ఉజిడి దెతి రిసొ దీవుకంబుమ్‍చి ఉప్పిరి తివుల. ");
INSERT INTO key_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“తుమ్‍చి ఆఁగుక తుమ్‍చ అంకివొ దీవు జలె, తుమ్‍చ అంకివొ టేంట తిలె, తుమ్‍చి ఒండి ఆఁగ్ ఉజిడ్ తెన్ తయెదె. గని తుమ్‍చ అంకివొ మయ్‍ల జా తిలె, తుమ్‍చి ఆఁగ్ ఎత్కి ఆమస్ రితి అందర్ తెన్ తయెదె. ");
INSERT INTO key_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","జాకయ్, తుమ్‍చి పెట్టి తిలి ఉజిడి అందర్ నే జతి రితి జాగర్త తెన్ తా. ");
INSERT INTO key_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","జలె, తుమ్‍చి ఒండి అఁగి కేన్ పక్క కి అందర్ నెంజితె రితి ఉజిడి బెర తిలె, దీవుచి ఉజిడి కీసి తుమ్‍క ఉజిడి దెకయెదె గే, దస్సి, తుమ్‍చి పెట్టిచి ఉజిడి సొస్టుమ్ డీసెదె” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","యేసు జా బోదన సంగ కేడయ్‍తికయ్, పరిసయ్యుడు ఎక్కిలొ యేసుక జోచి గెరి అన్నిమ్ కా జె మెన బుకార్లన్, చి యేసు జో తెన్ గెరి గెచ్చ అన్నిమ్ కంక వెసిలన్. ");
INSERT INTO key_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","జలె, యేసు అత్తొ నే దొవన్‍తె అన్నిమ్ కతయ్ మెన దెక కెర జో ఆచారిమ్ జలొ. ");
INSERT INTO key_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","యేసుప్రబు జోక, “తుమ్ పరిసయ్యుల్ గలస్లు గిన్నలు ఉప్పిర్ పక్క దోవ, తుమ్‍చి ఆఁగుచి ఉప్పిరి దొవన్‍తసు, గని గలసు గిన్న తెడి ముర్కి తా గెలి రితి, తుమ్‍చి పేట్ తెడి కిచ్చొ అస్సె మెలె, ఆస బుద్ది పాపుమ్‍బుద్ది బెర అస్సె. ");
INSERT INTO key_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","తుమ్ బుద్ది నెంజిలస, ఉప్పిరి తిలిసి జెర్మయ్‍లొ దేముడు, తెడి తిలిసి కి జెర్మయ్‍లొసొ నెంజె గె? కెర్లొ, గెద! ");
INSERT INTO key_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","జలె, తెడి తిలిసి దర్ముమ్‍క దాస, చి ఈందె, తుమ్‍క ఎత్కి సుద్ది జయెదె. ");
INSERT INTO key_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“అయ్యొ తుమ్ పరిసయ్యుల్, తుమ్‍క సిచ్చ పిట్టె నాయ్! కిచ్చొక మెలె, తుమ్ పొచ్చెన్ రొడ్డొతె చెరమల్లితె దసచ ఎత్కితె దెస్సు వంతుల్ కెర, ఏక్ వంతు ఎత్కి అదికారుమ్ తిలొ దేముడుక దెతసు. గని మాన్సుల్‍చి ఉప్పిరి సత్తిమ్ తీర్పు కెరుక చి, దేముడుక ప్రేమ కెరుక తుమ్ పఁవ్సితసు. జలె, కిచ్చొ కిచ్చొ వస్తువల్‍తె దెస్సు వాటల్ కెర ఏక్ వాట జోవయింక దెంక తప్పు నెంజె, గని ముక్కిమ్‍క సత్తిమ్ తీర్పు కెర్తె తత్తదు జలె, దేముడుక ప్రేమ కెర్తె తత్తదు జలె, తుమ్‍క చెంగిల్ తత్తి! ");
INSERT INTO key_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“అయ్యొ, తుమ్ పరిసయ్యుల్, తుమ్‍క సిచ్చ పిట్టె నాయ్! కిచ్చొక మెలె, సబ గెరిచ ముక్కిమ్ టాన్లుతె వెసుక కోర్‍ప జతసు, సంతవీదులె ఎత్కిజిన్ అమ్‍క జొకర్తు మెన కోర్‍ప జతసు. ");
INSERT INTO key_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","అయ్యొ, తుమ్‍క సిచ్చ పిట్టె నాయ్! తుమ్ కీసి జతసు మెలె, బయిలె తతా నే డీస్త మెస్నల్ రిత అస్సుస్. ‘మెస్నల్’ మెన నేన కెర, మాన్సుల్ ఒత్త సుఁదితతి” మెన యేసు టాలి కెర సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","తెదొడి, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తొసొ ఎక్కిలొ యేసుక, “గురుబాబు, తుయి ఇసి సంగిలె, అమ్‍క కి మరియాద కడ్తసి” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","యేసు జోక కిచ్చొ జబాబ్ దిలన్ మెలె, “తుమ్ మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస, అయ్యొ! తుమ్‍క కి సిచ్చ పిట్టె నాయ్! కిచ్చొక మెలె, కూలి మాన్సుల్‍క సావుకర్లు కీసి కంది వయితి జాడు వయడుల గే, దస్సి తూమ్, ఒగ్గర్ ఆడ్ర రితి కెరుక అస్సె మెన, ప్రెజల్‍క జాడు వయడ్తి రితి కెర్తసు. గని తుమ్ వయడ్త జాడ్లు రిత ఆడ్ర సుల్కన కెర్తి రిసొ తుమ్‍చి కిడి ఊంటి కి నే చంపొ కెర్తి రితి, జేఁవ్ ప్రెజల్‍క కన్కారుమ్ జసు నాయ్. ");
INSERT INTO key_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","అయ్యొ, తుమ్‍చి సిచ్చ పిట్టె నాయ్! కిచ్చొక మెలె, తుమ్‍చ పూర్గుమ్‍చ దేముడుచ కబుర్లు సంగిలసక మార్ల, చి జా టాన్‌క జోవయించి రిసొ చెంగిల మెస్సున్‍లు తుమ్ బందయ్‍తసు. ");
INSERT INTO key_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","దస్సి, జోవయించి పాపుమ్‍తె తుమ్ బెదిలిస్‍చి రిసొ తుమ్‍చి ఉప్పిరి జోవయించి ఉప్పిరి సాచుల్ జతసు. కిచ్చొక మెలె, జేఁవ్ జోవయింక మార్ల, చి తూమ్ జోవయింక మెస్సున్‍లు బందయ్‍తసు. ");
INSERT INTO key_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","జాకయ్ దేముడుచి గ్యానుమ్ సంగిలిసి కిచ్చొ మెలె, అంచ కబుర్లు సంగితస సగుమ్‍జిన్‍క, అంచ బారికుల్ జతస సగుమ్‍జిన్‍క, జా కాలుమ్‍క అమ్‍చ యూదుల్‍తె తెద్రయిందె, చి జా కాలుమ్‍క అమ్‍చ యూదుల్ జోవయింతె సగుమ్‍జిన్‍క మారుల, సగుమ్‍జిన్‍క వేర సిచ్చల్ అల్లర్ కెరుల” మెన అస్సె. ");
INSERT INTO key_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","దస్సి, బూలోకుమ్ జెర్మయ్‍లి తెంతొ అప్పె ఎద అబ్బదింసి తూమ్ దేముడుచ కబుర్లు సంగిలసచి లొఁయి సువిలి పాపుమ్ తుమ్ ఈంజయ్ కాలుమ్‍చ వయితె. కెఁయ తెంతొ సూఁయి జలిసి మెలె, ");
INSERT INTO key_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","హేబెలు అన్నొసి అత్య కెర్లి తెంతొ మొదొల్ కెర, దేముడుచి గుడిచి నెడిమి బలి దెతి స్తంబుమ్ సొడి మాన్సుల్ మార్లొ జెకర్యాచి లొఁయి సువిలి ఎదచి లొఁయి. నిజుమి తుమ్‍క ఆఁవ్ కచితుమ్ సంగితసి, జేఁవ్ ఎత్కిజిన్‍చి లొఁయి సువిలి పాపుమ్‍చి సిచ్చ ఈంజయ్ కాలుమ్‍చక లయెదె. ");
INSERT INTO key_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“అయ్యొ, తుమ్ మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస, తుమ్‍క సిచ్చ పిట్టె నాయ్! కిచ్చొక మెలె, దేముడు రెగిడ్లిస్‍తెచి బుద్ది గ్యానుమ్‍చి గేరుచి తాలల్ కడి తుమ్ దెర గెచ్చ లుంకాడ అస్సుస్. తూమ్ కి ఒత్త పఁవ్స నాయ్, చి ఒత్త పెసుక గెల అన్నె మాన్సుల్‍క కి అడ్డు కెర, ఒత్త పెసడ్సు నాయ్” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","యేసు ఒత్త తెంతొ ఉట్ట గెతికయ్, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస చి పరిసయ్యుల్ జోచి ఉప్పిరి ఒగ్గర్ కుస్సిదుమ్ జా, కిచ్చొ కిచ్చొచి రిసొ జోవయింక పుస లట్టబడ పరిచ్చ కెర్లి రితి జతె తిల. ");
INSERT INTO key_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","‘ఏక్ వేల జో కిచ్చొ జవుస్ తప్పు సంగిలె జోక దెరుక జయెదె’ మెన, రకితె తిల. ");
INSERT INTO key_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","తెదొడి ఒగ్గర్ ఒగ్గర్‍జిన్ మాన్సుల్ యేసుతె బెర జా ఎక్కిలొక ఎక్కిలొ సుఁద సుఁది జతె తతికయ్, యేసు తొలితొ జోచ సిస్సుల్ తెన్ లట్టబుక దెర, “పరిసయ్యుల్ జేఁవ్ సొంత సికడ్తి బుద్ది ఇండితి నాయ్. పోడియొ కెర్తి పీట్‍తె కీసి జా పోడియొ కెర్తిసి ఎత్కిక పులయెదె గే, దస్సి పరిసయ్యుల్ చి జా మాయబుద్ది దెకిలె, అన్నె మాన్సుల్ కి దస్సి మాయబుద్ది సికుక జయెదె. జాకయ్ తుమ్ జాగర్త దెకన. ");
INSERT INTO key_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","డంకి జలిసి కిచ్చొ జలెకి కెఁయఁక తెఁయఁక నే డీస్తె తయె నాయ్. లుంకడ్లిసి కిచ్చొ జలెకి కెఁయఁక తెఁయఁక ఎత్కిక నే జాన్‍తి రితి జెయె నాయ్. ఆకర్‍క డీసెదె, ఆకర్‍క జానుప జయెదె. ");
INSERT INTO key_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","అందర్‍తె తుమ్ కిచ్చొ సంగ తస్తె గే, ఉజిడ్‍తె సూనయ్ జయెదె, చి అన్నె కోయి నెంతె కెవ్డివొ డంకన కిచ్చొ కచి కండయి సంగ తస్తె గే, మేడల్‍చ ఒర్నెల్ తెంతొ సాట్ప జయెదె. ");
INSERT INTO key_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“జాకయ్, గోతుసుదల్, తుమ్‍క ఆఁవ్ కిచ్చొ మెంతసి మెలె, తుమ్‍చి ఆఁగుక మారుక తెరితసక తుమ్ బియఁ నాయ్. జేఁవ్‍చి పడ్తొ తుమ్‍క అన్నె కిచ్చొ అల్లర్ కెరుక నెతిర్తి ");
INSERT INTO key_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","నాయ్, గని తుమ్ కక్క బింక గే తుమ్‍క సంగితసి. కక్క మెలె, మాన్సుచి ఆఁగుక మార్లి పడ్తొ జోవయింక వెల్లి ఆగి గొయ్‍తె గల దెతి అదికారుమ్ తిలొ దేముడుకయ్ తుమ్ బియఁ. తుమ్ జోకయ్ బియఁ మెన తుమ్‍క ఆఁవ్ సంగితసి. ");
INSERT INTO key_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“ఈంజ దేసిమ్‍చ మాన్సుల్ పాఁచ్ గెర్‍పిట్టల్ దొన్ని కాసుక వికుల, గెద. జలె, దసచక ‘విలువ’ మెన మాన్సుల్ నే దెకిలెకి, దేముడు జోవయింతె ఎక్కిక కి పఁవ్సె నాయ్. ");
INSERT INTO key_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","దేముడు తుమ్‍చి ఉప్పిర్ కెద్ది ప్రేమ అస్సె మెలె, తుమ్‍చి బోడిచ సెండి వాడల్ ఎత్కి మొత్తుమ్ కెత్తి అస్తి గే, జొయ్యి జానె. జాచి రిసొ తుమ్ బియఁ నాయ్. తుమ్ పిట్టల్‍చి కంట ఒగ్గర్ విలువ అస్సుస్. ");
INSERT INTO key_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“జలె, తుమ్‍క ఆఁవ్ కిచ్చొ మెంతసి మెలె, కో అంక నంపజా యేసుక్రీస్తుకయ్ ఆఁవ్ నంపజా అస్సి, మెన మాన్సుల్‍చి మొక్మె ఒప్పనుల గే, అంచయ్ మాన్సుల్, మెన, పరలోకుమ్‍తె దేముడుచ దూతల్‍చి మొక్మె ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ ఒప్పనిందె. ");
INSERT INTO key_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","గని, మాన్సుచి మొక్మె కో అంచి రిసొ జోచొ నెంజి మెనుల గే, దస్సి, ఒత్త దూతల్‍చి మొక్మె జోవయించి రిసొ ‘అంచ నెంజితి’ మెన ఆఁవ్ సంగిందె. ");
INSERT INTO key_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“అన్నె, కో గడియ బమ్మ జా కెర ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొచి రిసొ అన్మానుమ్ కోడు లట్టబుల గే, జోవయింతె ఎత్కి మాన్సుచి జా పాపుమ్ చెమించుప కెరుక జయెదె. గని, దేముడుచి సుద్ది తిలి ఆత్మక కో దూసుప కెరుల గే, జోవయింతె కచి పాపుమ్ చెమించుప జయె నాయ్. ");
INSERT INTO key_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“అన్నె కిచ్చొ మెలె, తుమ్‍చి ఉప్పిరి కోపుమ్ జల యూదుల్ తుమ్‍క నిందల్ కెర జోవయించ సబ గెరల్ నెంజిలె అదికార్లుచి మొక్మె, నెంజిలె రానల్‍చి మొక్మె పరిచ్చ కెరుల, గని తుమ్ కీసి రుజ్జు నఙనుక గే, కిచ్చొ జబాబ్ దెంక గే, తుమ్ కిచ్చొ సంగుక గే, తుమ్ బియఁ నాయ్. ");
INSERT INTO key_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","కిచ్చొక మెలె, తుమ్ కిచ్చొ సంగుక గే తెదొడ్‍క, జయి గడియయ్ పరలోకుమ్‍చొ దేముడుచి సుద్ది తిలి ఆత్మ తుమ్‍క సికడెదె” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","తెదొడి ప్రెజల్‍తె ఎక్కిలొ యేసుక ఇసి మెలన్: “ప్రబు, అమ్‍చి ఆస్తితెచి అంచి వాట దెవుస్ మెన అంచొ అన్నొక సంగు” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","యేసు, జలె, జోక, “ఓ మాన్సు, జోక చి తుక నెడిమి తీర్పు దెతొసొ ఆఁవ్ జతి రితి, జోచి తుచి ఆస్తి వంటితి రితి, దస్సి కెరిందె మెన కో అంక టీఁవ అస్తి?” ");
INSERT INTO key_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","జనాబ్‍క అన్నె, “తుమ్ సూన. సొమ్సారుమ్ దొర్కు కెరంతి ఆస నే జతి రితి తుమ్ జాగర్త తెన్ తా. మాన్సుక కెద్ది సొమ్సారుమ్ తిలె కి, జోవయించి ఆత్మక జియడ్తిసి నెంజె, జా” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","తెదొడి జనాబ్‍క యేసు ఏక్ టాలి సంగిలన్. కిచ్చొ మెలె, “సొమ్సారి ఎక్కిలొ తిలన్. జోచి బుఁయితె చెంగిల్ పంటొ పికడ్లన్. ");
INSERT INTO key_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","గట్టిఙ పంటొ పికిత్‍కయ్ కిచ్చొ ఉచర్లన్ మెలె, ‘అంచి దాను సువుక టాన్ దెరె నాయ్. కీస్ కెరుక?’ మెన ఉచర, అస్సె, ");
INSERT INTO key_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ఒహొ, జాని. దాన్ కొట్లు తియంత గెరల్ సేడవ కెర, అన్నె వెల్లెల్‍చ బందయిందె, చి ఒత్తయ్ అంచ దాన్ చి అంచి సామన్ ఎత్కి తియనిందె. ");
INSERT INTO key_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","అన్నె, కిచ్చొ మెననిందె మెలె, తుయి అద్రుస్టుమ్‍చొ! కెత్తిగే వెర్సుల్ తుక కామ్‍క జెతిసి తుక సొమ్సారుమ్ అస్సె. సుక్కుమ్ తెన్ తా, చి ఇస్టుమ్ అయ్‍లి రితి కా పియ సర్ద కెరంతె తా జి మెననిందె మెలన్. ");
INSERT INTO key_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","గని దేముడు జో మాన్సుక, ‘తుయి బుద్ది నెంజిలొ వెర్రి సుదొ, తుచి. జీవు ఆజి రాతికయ్ కడ నెంక జెవుల. జయి అంచి ఆడ్ర. తుకయ్ తుయి కుడవన్లిసి తెదొడ్‍క కచి జయెదె?’ మెలన్. ");
INSERT INTO key_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","జలె, కో ఈంజ లోకుమ్‍చి ఆస్తి కుడవన సొమ్సారుమ్ కెరనుల చి దేముడుక పఁవ్స జో దెతి ఆత్మ సొమ్సారుమ్ జోక తయె నాయ్ గే, జోచి గత్తి ఈంజ టాలిచొ మాన్సుచి గత్తి ఎక్కి” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","“జాకయ్, ఆఁవ్ తుమ్‍క కిచ్చొ మెంతసి మెలె, ‘కిచ్చొ కమ్‍దె గే, కిచ్చొ గలనుమ్‍దె గే, కీసి జా జిమ్‍దె’ మెన తుమ్‍చి మెన్సుతె చింత గలన నాయ్. ");
INSERT INTO key_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","కిచ్చొక మెలె, అన్నిమ్‍చి కంట మాన్సుచి ఆత్మ ముక్కిమ్ గెద, పాలల్‍చి కంట ఆఁగ్ విలువ గెద?. ");
INSERT INTO key_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","కాడల్‍చి రిసొ తుమ్ ఉచర. జేఁవ్ ఉంపితి నాయ్, పంటొ లాయితి నాయ్, చి జోవయింక కొట్లు నాయ్ కొట్లు గెరల్ నాయ్ జలెకి, దేముడు జోవయింక అన్నిమ్ దెతయ్. జలె, పిట్టల్‍చి కంట తుమ్ ఒగ్గర్ విలువ అస్సుస్ గెద? కచితుమ్ తుమ్‍క దొర్కు జలిసి జో దొర్కు కెరెదె. ");
INSERT INTO key_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","పడ్తొ, తుమ్‍చితె కో కెద్ది చింత గలన్‍లెకి, జోచి బత్కుక కొల్తక అత్తెక్ జవుస్ ఒగ్గర్ కెరనుక తెరె గే? నెత్రె. ");
INSERT INTO key_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","దస్స ఇస ఇదుద్ల కమొ జర్గు కెరుక నెతుర్సు జలె, అన్నె తిల కమొ జర్గు కెరుక కిచ్చొక బమ్మ జతసు? ");
INSERT INTO key_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“డొంగ్రెచ పుల్లొ కీసి వడ్డితతి గే, తుమ్ ఉచర. జేఁవ్ కామ్ కెర్తి నాయ్, పాలల్ వీంతి నాయ్. జలెకి, ఎదివాట్ సొమ్సారుమ్ కలుగు జలొ పూర్గుమ్‍చొ రానొ సొలొమోను కి ఈంజేఁవ్ పుల్లొచి రితి సూటి కెరనుక నేన్లొ. ");
INSERT INTO key_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","తుమ్ తొక్కి నముకుమ్ తిలస, ఏక్ కోడు ఉచర. ఆజి బట్టి వడ్డితి, గని కలిక డయ దెతి వెర్రి చివ్వర్‍క దేముడు ఎదిలి సూటి కెర్తయ్, జలె, కచితుమ్ తుమ్ మాన్సుల్‍క అన్నె చెంగిల్ గలంతిసి దొర్కు కెరెదె. ");
INSERT INTO key_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","అన్నె, ‘అన్నిమ్ కీసి దొర్కు జయెదె, పితిసి కీసి దొర్కు జయెదె?’ మెన తుమ్ బమ్మబుద్ది తెన్ తా నాయ్. ");
INSERT INTO key_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","కిచ్చొక మెలె, ఈంజ లోకుమ్‍చ ఎత్కి మాన్సుల్ ఇస వస్తువల్ దొర్కు కెరనుక ఆస జతతి. ఇస సామన్లు తుమ్‍క కి దొర్కు జతతి మెన తుమ్‍క అబ్బొది జతొ దేముడు జానె. ");
INSERT INTO key_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","తూమ్, కిచ్చొ కెరుక అస్సె మెలె, జోచి రాజిమ్‍తె బెద, జోక గవురుమ్ కెర్తి బుద్ది ఇండుక ఆస జా, చి దొర్కు జల ఈంజేఁవ్ అన్నె వస్తువల్ కి తుమ్‍క జో దొర్కు కెరెదె. ");
INSERT INTO key_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“అంచి ఇదిలిసి మంద జల అంక నంపజలస, తుమ్ బియఁ నాయ్. కిచ్చొక మెలె, జోచి రాజిమ్‍తె తుమ్ బెద జో తెన్ ఏలుప కెర్తి రితి అంచొ అబ్బొసి జలొ దేముడుచి ఉద్దెసుమ్. ");
INSERT INTO key_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","తుమ్‍చ ఆస్తుల్ విక గెల కెర, బీద సుదల్‍క జా డబ్బుల్‍క తుమ్ దర్ముమ్ దాస. పరలోకుమ్‍తెచి పోర్న నే జతి రగుమ్ పాడ్ నే జతి రగుమ్ సెంచెల్ కోడు దొర్కు కెరన తా. జేఁవ్ సెంచెల్‍తె కిచ్చొ తంక మెలె, పాడ్ నే జతి, కేన్ చోరు జా దనుమ్‍క పాసి గెచ్చుక నెతిర్తి, చి కేన్ కీఁవు జాక కంక నెతిర్తి. ");
INSERT INTO key_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","తుమ్ కేన్ లోకుమ్‍తె దనుమ్ సంపాదన కెరన తస్తె గే, ఒత్త తిలిస్‍చి రిసొ తుమ్‍చి పెట్టి ఉచర్తె తస్తె. ");
INSERT INTO key_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“పెండ్లి విందు తెంతొ బుల జెతొ కేన్ ఎజొమాని గెరి అన్నె జెతిస్‍క జోచ సేవ కెర్తస జోచ పాలల్ చెంగిల్ కుంచన దీవు లంబడ తా, జో అయ్‍లె కెవ్డితె ఉంక్రయ్‍లె కెవ్డి ఉగ్డ దెంక మెన, రకితె తవుల, గెద. తుమ్, జలె, దస్సి తెయార్ జా తా. ");
INSERT INTO key_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ఆఁవ్ ఎజొమాని అన్నె ఉట్ట అయ్‍లె, అంచ సేవ కెర్తస రితసతె కో చెదొయ్ తా రకితె తిలె, జోవయింకయ్ చెంగిలి. తుమ్‍క కిచ్చొ కచితుమ్ మెంతసి మెలె, ఆఁవ్ అంచి పాలుమ్ కుంచన జోవయింక అన్నిమ్‍క వెసడ దా, జోవయించి రిసొ జొగుడ దెయిందె. ");
INSERT INTO key_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","అన్నె ఆల్సిమ్ అయ్‍లి రితి సొక్కుక నెంజిలె కుకుడొ వాంసెనె అయ్‍లె, తెద్ది గడియ గెలె కి కో దస్సి చెద్దొయ్ తా రకితె తవుల గే, జోవయింక చెంగిలి! ");
INSERT INTO key_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“గని ఏక్ టాలి తుమ్ చెంగిల్ అర్దుమ్ కెరన. కిచ్చొ మెలె, కేన్ సమయుమ్‍క చోరు జెయెదె మెన గెర్‍చొ ఎజొమాని కో జలెకు జాన్‍తొ జలె, జో చెదొయి తత్తొ, అన్నె చోరు జోచి గెరి పెసితి అవ్‍కాసుమ్ తతి రితి గేర్ ములితొ నాయ్. ");
INSERT INTO key_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","జలె, తుమ్ తెయార్ జా తా రకితె తంక అస్సె. కిచ్చొక మెలె, తుమ్ నే ఉచర్లి సమయుమ్‍క ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ అన్నె జెయిందె” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","తెదొడి పేతురు “ప్రబు, ఈంజ టాలి అమ్‍కయ్ సంగితసి, గే ఎత్కిజిన్‍చి రిసొ గె?” మెన యేసుక పుసిలన్. ");
INSERT INTO key_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","యేసుప్రబు జోక, “ప్రయానుమ్ గెచ్చుక మెన ఎజొమాని బార్ జంక జలె, జోచ గేర్‍చక దెక సమయుమ్‍క అన్నిమ్ దెంక మెన జో నిసాన నిదానుమ్‍చొ గొత్తి సుదొ కో జవుల? ");
INSERT INTO key_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","జో ఎజొమాని అన్నె ఉట్ట అయ్‍లె, జో గొత్తి సుదొ జో ఎజొమాని తియార్లి కామ్ కెర్తె తిలె, గొత్తి సుదొక చెంగిలి. ");
INSERT INTO key_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","దస్సి నిదానుమ్ కెర తయెదె మెలె, తుమ్‍క ఆఁవ్ కిచ్చొ కచితుమ్ మెంతసి మెలె, జో ఎజొమాని అయ్‍లె, జోచి ఆస్తి ఎత్కిచి ఉప్పిరి జో చెంగిల్ రకిలొ గొత్తి సుదొక అదికారుమ్ దెయెదె. ");
INSERT INTO key_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","గని జో గొత్తి సుదొ ఏక్ వేల ఎజొమాని ఆల్సిమ్ కెర్తయ్ మెన ఉచర, జోచి జత జల అన్నె మున్సుబోద గొత్తి సుదల్‍క జలెకి, తేర్‍బోద గొత్తి సుదల్‍క జలెకి, పెటుక చి కంక పింక సూరు పియ మచ్చుక దెర్లె, ");
INSERT INTO key_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","‘ఎజొమాని ఆజి జెయె నాయ్’ మెన గొత్తి సుదొ ఉచర నే రకితె దీస్‍క, గడియక జో ఎజొమాని ఉట్ట జెయెదె చి, జోక మొర్తి సిచ్చ తియడ కెర, జోక నంప నెంజిలస సిచ్చ జతిస్‍తె జో గలెదె. ");
INSERT INTO key_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“జో కిచ్చొ కామ్ కెరుక మెన జోచొ ఎజొమాని తియార అస్సె గే కేన్ గొత్తి సుదొ జానె గని జోచొ ఎజొమానిచి ఇస్టుమ్ జర్గు కెరె నాయ్ అన్నె జా జర్గు కెరుక తెయార్ కి జయె నాయ్ గే, జోవయింక ఎజొమాని గట్టిఙ పెటయెదె. ");
INSERT INTO key_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","జోచొ ఎజొమానిచి ఇస్టుమ్ కిచ్చొ జయెదె గే నేన కెర, పెట్తి సిచ్చచి ఎదిలి తప్పు కేన్ గొత్తి సుదొ కెరెదె గే, జోక ఎజొమాని తొక్కి పెటయెదె. కక్క దేముడు ఒగ్గర్ బుద్ది గే, సెక్తి గే, ఆస్తి గే, కిచ్చొ గే దా తయెదె గే, జో మాన్సు నిదానుమ్ తెన్ జా వాడిక కెర ప్రబుచి సేవ కెరుక అస్సె, చి అమ్‍క ‘దస్సి నిదానుమ్ కెర్ల గే, నాయ్ గె’ జో ప్రబు దెకెదె. దస్సి, కచి అత్తి జో ఒగ్గర్ సొర్ప కెర తయెదె గే, జో మాన్సు అన్నె లాబుమ్ తెన్ అన్నె దెంక అస్సె. ");
INSERT INTO key_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“బూలోకుమ్‍చి ఉప్పిరి ఆగి సువుక అయ్‍లయ్, చి జా ఆగి అప్పె లంబ తత్తి జలె ఆఁవ్ ‘చెంగిల్’ మెన్‍తయ్. ");
INSERT INTO key_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ఏక్ మాన్సు మాములుమ్ పానిచి బాప్తిసుమ్ నఙనుక జలె, కీసి పానితె డుఙుక తయెదె గే, దస్సి ఆఁవ్ స్రెమల్‍తె డుఙ మొరుక అస్సె, చి జా పూర్తి జర్గు జతె ఎదక అంచి పెట్టి కెద్ది బాద సేడ్తసి! ");
INSERT INTO key_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“జలె, అంక ‘జో బూలోకుమ్‍తె అయ్‍లిసి మాన్సుల్‍తె ఎక్కి సేంతుమ్ కెరెదె’ మెన తుమ్ ఉచర్తసు గె? ఆఁవ్ అయ్‍లిసి సేంతుమ్ దెయె నాయ్, గని ఆఁవ్ అయ్‍లి రిసొ మాన్సుల్ జట్లు జవుల. ");
INSERT INTO key_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","మెలె, అప్పె తెంతొ ఎక్కి గెరి పాఁచ్‍జిన్ తిలె, జట్లు జవుల. దొగుల ఏక్ జట్టు జా, తీగ్ల ఏక్ జట్టు జా, దొగులచి ఉప్పిరి తీగ్ల విరోదుమ్ జవుల. నెంజిలె, తీగ్లచి ఉప్పిరి దొగుల విరోదుమ్ జవుల. ");
INSERT INTO key_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","దస్సి, పుత్తుస్‍చి ఉప్పిరి అబ్బొసి విరోదుమ్ జయెదె, అబ్బొస్‍చి ఉప్పిరి పుత్తుసి విరోదుమ్ జయెదె, దువిస్‍చి ఉప్పిరి అయ్యసి చి, అయ్యస్‍చి ఉప్పిరి దువిసి విరోదుమ్ జవుల, చి సూనుస్‍చి ఉప్పిరి అత్తస్, చి అత్తస్‍చి ఉప్పిరి సూనుసి విరోదుమ్ జవుల” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","యేసు ప్రెజల్‍క, “పడమర పక్క పాని దెతి మబ్బు అయ్‍లె, ‘పాని పెటెదె’, మెన తుమ్ బేగి సంగితసు గెద, కచితుమ్ జర్గు జతయ్. ");
INSERT INTO key_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","పడ్తొ దచ్చెన పక్క తెంతొ వాదు వీర్లె, ‘ఆజి గట్టిఙ వేడి కెరెదె’ మెన చినితె చి, దస్సి జర్గు జయెదె గెద? ");
INSERT INTO key_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","తుమ్ ఉప్రమెన్సుచొ మాన్సుల్! తుమ్ చినితిస్‍క ‘నేనుమ్’ మెంతసు. బుఁయిక చి ఆగాసుమ్‍క దెకిలె కీసి కెరెదె గే చినితసు జలె, ఈంజ కాలుమ్‍తె జర్గు జతిసి దెకిలె ఈంజ కాలుమ్‍క కీసిచి గే చినుక నెతుర్సు గె? చినుక తెరితసు, గెద” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","యేసు అన్నె కిచ్చొ బుద్ది జోవయింక ఉచరయ్‍లన్ మెలె, “తుమ్ కిచ్చొ కెర్లె చెంగిల్ తయెదె గే, కిచ్చొక చినుస్ నాయ్? ");
INSERT INTO key_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","తుచి తగు సూనితొ తీర్పు కెర్తొస్‍తె గెచ్చుక మెన తుక నేరిమ్ వయడ్తొసొచి తుయి నేరిమ్ జలొసొ వట్టె గెతె తిలె పొది, జోవయింతెన్ తుయి సేంతుమ్ జంక దెకను. నెంజిలె, తీర్పు కెర్తొసొతె తుక ఒర్గొడ తిలె, తుచి తగు సూన్లె, తీర్పు కెర్తొసొ తుక జమాన్లుచి అత్తి సొర్ప కెర దెయెదె, చి జమాన్లు తుక జేల్‍తె గల దెయెదె. ");
INSERT INTO key_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ఆఁవ్ తుమ్‍క కిచ్చొ మెంతసి మెలె, తుయి తుచి సిచ్చచి ఆకర్ కాసు ఎద కి తుయి పూర్తి తీర్సుప కెర్తె ఎదక, తుక ములుక నెంజె.” ");
INSERT INTO key_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","యేసు జేఁవ్ కొడొ సంగిలి సమయుమ్ తిలస సగుమ్‍జిన్ జోక, సగుమ్‍జిన్ గలిలయుల్ మొర్లిస్‍చి రిసొ సంగిల. “జేఁవ్ గలిలయుల్ యెరూసలేమ్‍తె దేముడుక బలి దెతె తతికయ్, పిలాతు అదికారి జోవయింక కండయ్‍లన్, చి జేఁవ్ అర్పితుమ్ దిలిస్‍తె జోవయించి లొఁయి కలొయ్ జలి” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","యేసు జోవయింక కిచ్చొ జబాబ్ దిలన్ మెలె, “ఈంజేఁవ్ గలిలయుల్ ఇసి మొర గెలి రిసొ, తిల గలిలయుల్‍చి కంట ఒగ్గర్ పాపుమ్‍చ జవుల మెన ఉచర్తసు గె? ");
INSERT INTO key_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","నాయ్, దస్సి నాయ్, మెన తుమ్‍క ఆఁవ్ సంగితసి. గని తుమ్‍క కిచ్చొ ఆఁవ్ సంగితసి మెలె, తుమి పాపుమ్ ఇండుక ముల దెంకయ్, నెంజిలె తూమ్ కి ఇసి మొర గెతె. ");
INSERT INTO key_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","“నెంజిలె, అమ్‍చి యెరూసలేమ్‍తె సిలోయము పక్కచి గోపురుమ్ సేడ గెలి పొది జాచి తెడి తిల అట్టర జిన్ మాన్సుల్ తెడి తా మొర్లిస్‍క ఉచర్లె, అన్నె యెరూసలేమ్‍తె తిల మాన్సుల్‍చి కంట, జేఁవ్ అన్నె పాపుమ్‍చ జా తిల మెన తుమ్ ఉచర్తసు గె? ");
INSERT INTO key_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","దస్సి నాయ్ మెన ఆఁవ్ సంగితసి గని, తుమ్‍క ముక్కిమ్‍క ఆఁవ్ కిచ్చొ సంగితసి మెలె, తుమి పాపుమ్ ఇండుక ముల దెంకయ్, నెంజిలె తూమ్ కి ఇసి మొర గెతె” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","తెదొడి యేసు ఈంజ టాలి సంగిలన్: “ఎక్కిలొక ఏక్ అంజూరుమ్ రూకు అస్సె. తిన్ని వెర్సుల్ జలి జో రూకు జోచి ద్రాచ తోటతె రోవ అస్సె. జలె, జో ఎజొమాని ‘జా రూక్‍తె పండ్లు అస్తి కిచ్చొగె. దొన్ని కోడిందె’ మెన రూక్‍తె అయ్‍లె, ఎక్కి పండు కి నాయ్. ");
INSERT INTO key_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","తెదొడి జా తోటక దెకితొ గొత్తి సుదొక ఎజొమాని, ఈందె, పండ్లు చజ కోడుక మెన తిన్ని వెర్సుల్ జలి ఆఁవ్ జెతసి, గని కేన్ పండు కి దెరె నాయ్. ఈంజొ రూకు కండ గెలు. ఆరి ఈంజ టాన్‌క పాడ్ కెర్తయ్” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","జో ఎజొమాని దస్సి సంగితికయ్, జా తోట రకితొసొ, “బాబు, ఏసుమ్ జవుస్ దెకుమ. రూకుక మత్తి వెగవ కెర, సొవును సువ దెకిన్‍దె, ");
INSERT INTO key_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","పోరుమ్‍క పండ్లు దెర్లె రూకు తవుస్, నే దెర్లె, కండ గెలుమ” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","జలె, ఏక్ సెలవ్ కడన్లి దీసి, యేసు సబగేరి బోదన కెర్తె తతికయ్, ");
INSERT INTO key_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","బూతుమ్ చి రిసొచి జబ్బు తిలి తేర్‍బోద ఒత్త తిలన్. జా తేర్‍బోదక జా జబ్బు జా అట్టర వెర్సుల్ జా తిలి. జా కుబ్డి జా, వంపొ జా ఎద్గరె టీఁవ్‍క నెత్రె. ");
INSERT INTO key_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","జలె, యేసు జాక దెక కెర, “పాసి జె” మెన జాక బుకారా కెర, “అమ్మ, తుచి జబ్బు తెంతొ చెంగిల్ జా అస్సిస్” మెన సంగ, ");
INSERT INTO key_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","జేఁవ్‍క చడిల్ బేగి సోగ జా టీఁవిలన్, అన్నె దేముడుచి గవురుమ్ సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","గని సెలవ్ కడన్లి దీసి జా తేర్‍బోదక చెంగిల్ కెర్లి రిసొ జేఁవ్ యూదుల్‍చి జో సబగేర్‍చొ అదికారి కోపుమ్ జా, ప్రెజల్‍క, “సత్తరెక్క మాన్సుల్ కామ్ కెర్తి రిసొ సొవ్వు పొదుల్ అస్తి. తుమ్‍క జొర్జొల్ గట్ర తిలె, సెలవ్ కడన్లి దీస్ నాయ్, గని తిల సొవ్వు పొదుల్‍తె జా” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","దస్సి సంగితికయ్, యేసు జోవయింక కిచ్చొ జబాబ్ దిలన్ మెలె, “తుమ్ ఉప్రమెన్సుచ, సెలవ్ దీస్ కామ్ కెరుక నెంజె మెంతసు, గని సెలవ్ కడన్లి దీసి కి తుమ్‍చ బెయిలల్ కి గాడ్దెల్ కి కిచ్చొ సొమ్ముల్ జలెకి యిప జేఁవ్ పాని పింక మెన గడ్డె ఉదడ నెసు నాయ్ గె? దస్సి కెర్తసు, గెద. ");
INSERT INTO key_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","జలె, ఈంజ తేర్‍బోద, అమ్ యూదుల్‍చి అబ్రాహామ్‌చి సెకుమ్‍చి తేర్‍బోదక సయ్‍తాన్ బంద, అట్టర వెర్సుల్ జా అస్సె. జలె, తుమ్‍చ సొమ్ముల్‍క సెలవ్ కడన్లి దీసి యిపుక జతయ్ జలె, సెలవ్ కడన్లి దీసి జలెకి ఈంజ తేర్‍బోదక బందిలిస్ తెంతొ ఇన్నెక యిప, విడ్దల్ కెరుక అన్నె ముక్కిమ్ నాయ్ గె?” మెన యేసు సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","జోక ‘తప్పు కెర్తయ్’ మెన ఉచర్లస ఎత్కిజిన్ ‘అమ్‍చి తప్పు’ మెన లాజ్ జల చి, జోచి అత్తి జర్గు జల వెల్లెల కమొ ఎత్కిచి రిసొ ప్రెజల్ ఎత్కి సర్దసంతోసుమ్ జా గెల. ");
INSERT INTO key_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","జో జర్గు కెర్లిస్‍క ప్రెజల్ దస్సి సర్దసంతోసుమ్ జతికయ్, యేసు, “దేముడుచి రాజిమ్ కీసి జతయ్ గే ఉచరుమ. జాక కిచ్చొ టాలి ఉచరుమ? ");
INSERT INTO key_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ఈందె, సొర్సు గిడ్డక జలిస్‍చి రితి జతయ్. ఏక్ మాన్సు సొర్సు గిడ్డ ఆన, జోచి పట్టయ్ రోవిలన్, చి మొక్క వడ్డ రూకు జా గెలన్, చి జేఁవ్‍చ కొమ్ముల్‍తె పిట్టల్ గూడల్ బంద జిల” మెన టాలి బెదవ సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ఒత్త తెంతొ యేసు అన్నెక్ కోడు పుస కిచ్చొ టాలి సంగిలన్ మెలె, “దేముడుచి రాజిమ్‍క కిచ్చొ అన్నెక్ టాలి ఉచరుమ? ");
INSERT INTO key_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","‘పోడియొ కెర్తి పీట్ ఎత్కి పొంగుప జా పులుస్’ మెన, ఏక్ తేర్‍బోద తీనడి పీట్‍తె పులయ్‍తి పీట్ గలిలి. గల జా పాకుమ్ పులితి రితి తిఁయ దిలి, చి జా పులయ్‍తి పీట్ ఇదిలిదిల్ జలెకి. జా కలొయ్‌లి పాకుమ్ తిరీమ్ తిరీమ్ పుల, ఒగ్గర్ జా గెలి” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","జేఁవ్ పొదులె యేసు యెరూసలేమ్‍తె గెచ్చుక మెన ప్రయానుమ్ గెతె తిలన్. జలె, వట్టె అన్నె ఒగ్గర్ పట్నలె గఁవ్విలె గెలన్. ");
INSERT INTO key_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","జేఁవ్ పొదులె కో గే జోక కిచ్చొ మెన పుసిలన్ మెలె, “ప్రబు, పాపుమ్ తెంతొ రచ్చించుప జా పరలోకుమ్‍తె గెతస తొక్కిజిన్ జవుల గె?” మెన పుసిలన్, చి యేసు ఒత్త తిలసక, ");
INSERT INTO key_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“పరలోకుమ్‍చి గుమ్ముమ్ ఇర్కు జయెదె. జా ఇర్కు గుమ్ముమె తుమ్ పెసితి రితి దొర్కు జలిసి కెరనుక దెకన. కిచ్చొక మెలె, జా గుమ్ముమె పెసుక మెన ఒగ్గర్‍జిన్ ఉచర్లె కి, జోవయింతె ఒగ్గర్‍జిన్ నెతిర్తి.” ");
INSERT INTO key_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","“పరలోకుమ్‍క ‘గేరు’ మెనుమ. జో గేర్‍చొ ఎజొమాని ఉట్ట తెదొడ్‍క కెవ్డి డంక దెయెదె, చి తెదొడ్‍క తుమ్ జా కెవ్డి ఇత్తల్‍తొ బయిలె టీఁవ ఉంక్రవుక దెర, ‘ప్రబువ, అమ్‍క కెవ్డి ఉగ్డ దె’ మెంతె, చి జో తుమ్‍క కిచ్చొ జబాబ్ దెయెదె మెలె, ‘తుమ్ కేనె తెంతొచ గే నేని’ మెనెదె. ");
INSERT INTO key_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","తెదొడ్‍క తూమ్ కిచ్చొ మెంతె మెలె, ‘తుచి తెన్ బెద అన్నిమ్ కయ్‍లమ్ పిలమ్, చి అమ్‍చి వీదులె తుయి బోదన కెర్లది’ మెంతె, ");
INSERT INTO key_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","గని జో తుమ్‍క కిచ్చొ మెనెదె మెలె, ‘నాయ్, తుమ్ కేనె తెంతొ జెతసు గే నేని. తుమ్‍క కచితుమ్ నేని. తుమ్ గార్ కమొ కెర్లసొ అంచి తెంతొ దూరి ఉట్ట గెచ్చ’ మెనెదె. ");
INSERT INTO key_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","జలె, అమ్‍చ పూర్గుల్ అబ్రాహామ్, ఇస్సాకు, యాకోబు తెన్ దేముడుచ కబుర్లు సంగిల పూర్గుమ్‍చ జోచి రాజిమ్‍తె పరలోకుమ్‍తె తిలిసి తుమ్ తెదొడ్‍క దెకితె, గని తుమి ఒత్త పెసుక సెలవ్ తయె నాయ్ చి రిసొ ఏడుకుడు జస్తె, దంతొ చప్లన్‍తె తస్తె. ");
INSERT INTO key_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","తుమ్ నంప నెంజిలస ఒత్త పెసుస్ నాయ్, గని తూర్పు పక్క తెంతొ, పడమర పక్క తెంతొ, ఉత్తర పక్క తెంతొ చి దచ్చెన పక్క తెంతొ యూదుల్ నెంజిల ఒగ్గర్‍జిన్ మాన్సుల్ జా కెర, దేముడుచి పరలోకుమ్‍చి రాజిమ్‍తె వెస, జో తెన్ అన్నిమ్ కవుల. ");
INSERT INTO key_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","అన్నె, అప్పె పడ్తొ జలస జా అగ్గె జవుల, చి అగ్గె జలస పడ్తొ జవుల” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","జయి గడియయ్ పరిసయ్యుల్ సగుమ్‍జిన్ యేసుతె జాఁ కెర జోక కిచ్చొ మెల మెలె, “తుయి కేనెగె వేరతె గో. హేరోదు అదికారి తుక మారుక ఉచర్తయ్” మెల. ");
INSERT INTO key_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","జేఁవ్ దస్సి మెంతికయ్, యేసు జోవయింక, “తుమ్ గెచ్చ, జో నక్కొ రితొ మాన్సుక కిచ్చొ మెన మెలె, ‘ఈందె, ఆజి చి కలిక ఆఁవ్ బూతల్‍క ఉదడ్తసి చి, జబ్బుల్ తిల మాన్సుల్‍క చెంగిల్ కెర్తసి చి, పేర్‍క అంచి కామ్ పూర్తి జయెదె. ");
INSERT INTO key_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","జలెకి, ఆజి కలికచి పేర్‍క ఆఁవ్ అంచి ప్రయానుమ్ గెచ్చ గెచ్చ యెరూసలేమ్‍తె పాఁవుక అస్సె. మెలె, దేముడుచ కబుర్లు సంగితొ మాన్సు యెరూసలేమ్‍క వేర టాన్‍తె మొరుక బెదె నాయ్’ మెన జోక తుమ్ సంగ” మెన పరిసయ్యుల్‍క యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","తెదొడి యేసు కీసి జలన్ మెలె, “ఓ యెరూసలేమ్‍చ, అమ్‍చి యెరూసలేమ్‍చ మాన్సుల్! అమ్ తెద్రయ్‍ల కబుర్ ఆన్లసక చి బోదన కెర్లసక పత్రల్ గల మార్తసు! కిచ్చొ ప్రమాదుమ్ తుమ్‍క నే లయితి రితి కుకిడి జాచ పిల్లల్‍క రెప్పల్ తెడి కీసి ముద్దొ కెరన తయెదె గే, దస్సి, ఆఁవ్ తుమ్‍క కెత్తిగే సుట్లు ముద్దొ కెరంతి రితి తుమ్‍క చెంగిల్ కెర్తయ్, గని తుమ్ నెసిలదు. ");
INSERT INTO key_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ఈందె, తుమ్‍చి గేర్ కో నెంజితె రితి తుమ్‍క తూమి ముల దెస్తె. అన్నె అప్పె తెంతొ మొదొల్ కెర ‘ప్రబుచి నావ్ తెన్ జెతొసొక జెయ్యి! జెయ్యి!’ మెన తుమ్ కేక్ గల్తి దీసి ఎద అంక అన్నె దెకుస్ నాయ్ మెన తుమ్‍క ఆఁవ్ కచితుమ్ సంగితసి.” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","2","అన్నె కిచ్చొ జర్గు జలి మెలె, సెలవ్ కడ దీసి, అన్నిమ్‍క మెన యేసు పరిసయ్యుల్‍చొ అదికారి ఎక్కిలొచి గెరి గెచ్చ తతికయ్, అత్తొ చట్టొ పుల తిలొ మాన్సు ఎక్కిలొ యేసుచి మొక్మె తిలన్, చి “యేసు కిచ్చొ కెరెదె గే దెకుమ” మెన ఒత్త తిల మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస చి పరిసయ్యుల్ చెంగిల్ దెకితె తిల. ");
INSERT INTO key_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","జలె, జేఁవ్ పరిసయ్యుల్‍చి మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తసచి మెన్సుతె తిలి జోవయించి ఉప్పిర్‍చి కుస్సిదుమ్ యేసు జాన కెర, జోవయింక, “సెలవ్ కడన్లి దీసి జబ్బు తిలసక చెంగిల్ కెరుక అమ్‍చి మోసేచి అత్తి దేముడు దిలి ఆగ్నల్ తెన్ బెదితయ్ గే నాయ్? గె? తుమ్ సంగ” మెన పుసిలొ. ");
INSERT INTO key_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","గని జేఁవ్ ఎత్కిజిన్ తుక్లె తిల. తెదొడి జో అత్తొ చట్టొ పుల తిలొ మాన్సుక యేసు పాసి బుకారా కెర జోక చెంగిల్ కెర “గో” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","తెదొడి యేసు జేఁవ్ పండితుల్‍క అన్నె కిచ్చొ పుసిలన్ మెలె, “తుమ్‍చి తెన్ ఎక్కిలొక పుత్తుస్ జలెకు, బెయిలు జలెకు తిలె, జో పుత్తుస్ జలెకు బెయిలు జలెకు సెలవ్ కడన్లి దీసి కుండితె సేడ తిలె, జయ్యి దీసి, సెలవ్ కడన్లి దీసి జలెకి, బేగి జోక జా కుండితె తెంతొ కడె నాయ్ గె? కడెదే, గెద” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","‘జో సంగిలిసి సత్తిమ్’ మెన జేఁవ్ కిచ్చొ జబాబ్ దెంక నెతిర్ల. ");
INSERT INTO key_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","జలె, జా అన్నిమ్‍క జో పరిసయ్యుడు బుకార్లసతె సగుమ్‍జిన్ వెసుక మెన గవురుమ్‍చ టాన్లు నిసాన, యేసు జోవయింక ఇసి మెన ఏక్ టాలి సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“కో జలెకు తుమ్‍చితె కక్క జలెకు పెండ్లి విందుతె బుకార్లెగిన, విందుతె అయ్‍లొసొ తుయి గవురుమ్‍చి టాన్‍తె వెసు నాయ్, నెంజిలె తుచి కంట వెల్లొ మాన్సుక జో బుకారా తిలె, ");
INSERT INTO key_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","జో వెల్లొ మాన్సు అయ్‍లె, తుక చి జోక బుకార్లొసొ తుచితె జాఁ కెర ‘ఈంజొ మాన్సుక జా టాన్ దేసు’, మెన సంగిలె, తుయి లాజ్ జా ఎత్కిచి కంట తొక్కి గవురుమ్‍చి టాన్‍తె తుయి తిరీమ్ గెచ్చ వెసిస్తె. ");
INSERT INTO key_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","తుక కో జలెకు బుకార్లె, ఎత్కిచి కంట తొక్కి గవురుమ్‍చి సొడిచి టాన్‍తె గెచ్చ వెసు, చి తుక బుకార్లొసొ అయ్‍లె తుక ‘మిత, అన్నె చెంగిల్‍తె వెసు’, మెన సంగిలెగిన, జా విందుక తుచి తెన్ వెస తిల ఎత్కిజిన్‍చి మొక్మె తుయి గవురుమ్ జస్తె. ");
INSERT INTO key_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","కిచ్చొక మెలె, కో జోవయింక జొయ్యి గవురుమ్ కెరనెదె గే, దేముడు జోవయింక దాక్ కెరెదె, గని కో జోవయింక జొయ్యి దాక్ కెరనెదె గే, దేముడు జోవయింక వెల్లొ కెరెదె” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","తెదొడి జా అన్నిమ్‍క బుకార్లొ పరిసయ్యుడుక యేసు, “తుయి మెద్దెన్‍చి జవుస్ సంజెచి జవుస్ అన్నిమ్‍క మాన్సుల్‍క బుకారుక ఉచర్లె, ముక్కిమ్‍క మితర్దుల్‍క జవుస్, బావొదింసిక జవుస్, తుమ్‍చ బందుగుల్‍క జవుస్, నెంజిలె అన్నె సొమ్సార్లుక జవుస్ బుకారా నాయ్. కిచ్చొక మెలె, జేఁవ్ జోవయించ అన్నిమ్‍తె తుమ్‍క అన్నె బుకారుక జోవయింక సెక్తి అస్సె, చి తుమ్‍క జేఁవ్ బుకార్లె, ఈంజయ్ లోకుమ్‍తె తుమ్‍చి బవుమానుమ్ సంగుక తస్తె. ");
INSERT INTO key_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","తుమ్ అన్నిమ్‍క మాన్సుల్‍క బుకారుక మెలె, కక్క బుకారా మెలె, బీద సుదల్‍క, మొండివొ మాన్సుల్‍క, సొట్ట మాన్సుల్‍క, గుడ్డి మాన్సుల్‍క, చి ");
INSERT INTO key_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","జేఁవ్ తుమ్‍క అన్నె బుకారుక నెతిర్‍తస్‍చి రిసొ తుమ్‍క చెంగిల్ జయెదె. కిచ్చొక మెలె, సత్తిమ్ ఇండిలస అన్నె జీవ్ జా ఉట్టితి పొదిక తుమ్‍క ఎత్కి అదికారుమ్ తిలొ దేముడు బవుమానుమ్ దెయెదె” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","జా అన్నిమ్‍క యేసు తెన్ వెస తిలొ మాన్సు ఎక్కిలొ జోచి జా కోడు సూన కెర, “దేముడుచి రాజిమ్‍తె, కో జో తెన్ బెద అన్నిమ్ కవుల గే, జోక ఒగ్గర్ చెంగిలి!” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","యేసు టాలిక కిచ్చొ మెలన్ మెలె, “ఏక్ మాన్సు వెల్లి విందు తెయార్ కెర, ఒగ్గర్‍జిన్‍క బుకార్లన్. ");
INSERT INTO key_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","జలె, విందు వంటితి సమయుమ్ జా అయ్‍లి పొది, ‘తుమ్ జా, విందు తెయార్ జా అస్సె’ మెన బుకార్ల సుదల్‍క సంగు మెన ఎజొమాని జోచొ గొత్తి సుదొక తెద్రయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","గని జేఁవ్ బుకార్లస ఎత్కిజిన్ ఎక్కి బుద్ది జా, జోవయింతె ఎత్కి మాన్సు జెంక నెతిరి మెల. జోవయింతె తొలితొచొ జో ఎజొమాని తెద్రయ్‍లొ గొత్తి సుదొక, ‘ఆఁవ్ బుఁయి గెన అస్సి, చి జా దెకుక మెన గెచ్చుక అస్సె. దయ కెర, ఆఁవ్ నే జెతిసి చెమించుప కెరు’ మెలన్. ");
INSERT INTO key_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","పడ్తొ అన్నెక్లొ, ‘ఆఁవ్ పాఁచ్ జతల్ బెయిలల్ గెన అస్సి చి, జేఁవ్ చెంగిల్ కామ్ కెరుల గె నాయ్ మెన దెకుక గెతసి. దయ కెర, ఆఁవ్ నే జెతిసి చెమించుప కెరు’ మెలన్. ");
INSERT INTO key_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","పడ్తొ అన్నెక్లొ, ‘ఆఁవ్ అప్పె పెండ్లి జలయ్ చి, జాకయ్ ఆఁవ్ జెంక నెతిరి’ మెలన్. ");
INSERT INTO key_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“జాకయ్ జో గొత్తి సుదొ ఎజొమానితె అన్నె ఉట్ట జా కెర, జేఁవ్ మాన్సుల్ సంగిలిసి ఎత్కి జో ఎజొమానిక సంగిలన్, చి జో ఎజొమాని ఒగ్గర్ కోపుమ్ జా, జోచొ గొత్తి సుదొక, ‘తుయి బేగి గో, చి పట్నుమ్‍చ వీదులె వట్టెలె కో బీద సుదల్, మొండివొ మాన్సుల్, గుడ్డి మాన్సుల్‍చి సొట్ట మాన్సుల్ తవుల గే, జోవయింక అంచి విందుతె కడ ఆను’ మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","సంగితికయ్, జో దస్సి గెచ్చ దస్సి కెర, అన్నె జా కెర ఎజొమానిక బాబు, తుయి సంగిల్ రితి కెర అస్సి, గని విందుతె అన్నె టాన్ అస్సె, మెలన్, ");
INSERT INTO key_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","జో గొత్తి సుదొక ఎజొమాని అన్నె, జలె, పట్నుమ్ ఒత్తల్‍తొచి బయిలె తుయి గెచ్చ ఒత్తచ వట్టెలె కో తిలె, ఏడెల్‍చి తెడి కో బిచ్చిమ్ నఙితస జవుస్ వెస తిలె, జేఁవ్ ఎత్కిజిన్‍క బలవంతుమ్ కెర కడ ఆను. అంచొ గేరు బెరుకయ్ మెలన్. ");
INSERT INTO key_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","జలె, తుమ్‍క ఆఁవ్ కిచ్చొ మెంతసి మెలె, జేఁవ్ తొలితొ బుకార్లసచ రిత జల మాన్సుల్‍తె కో కి అంచి విందు కంక ఆఁవ్ సెలవ్ దెయి నాయ్.” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","జలె, యేసు యెరూసలేమ్‍తె గెతి రిసొ వట్టె గెతె తతికయ్, ఒగ్గర్‍జిన్ జనాబ్ జో తెన్ బెద గెతె తిల. తతికయ్, యేసు పసుల జోవయింక, ");
INSERT INTO key_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“అంచొ సిస్సుడు జంక మెన కో అంచితె జెయెదె గే, అంక ప్రేమ కెర్తి కంట అబ్బొస్‍క, అయ్యస్‍క, తేర్సిక, జోవయించ బోదల్‍క, అన్నసీంసిక, అప్పసీంసిక చి జోకయ్ తొక్కి ప్రేమ నే కెర్లె, నెంజె. ");
INSERT INTO key_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","జోచి సొంత సిలువ వయన, కో అంచి పట్టి జెయె నాయ్ గే, జో, అంచొ సిస్సుడు జంక నెత్రె. ");
INSERT INTO key_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“తుమ్‍చితె కో జలెకు ఉప్పిర్ గేర్ బందుక ఉచర తిలె, జా పూర్తి బందితి రిసొ డబ్బుల్ సరిపుచుప జయెదె గే నాయ్ గే దెకుక మెన, లెక్క కెరుక మెన వెసెదె. ");
INSERT INTO key_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","జో తొల్లితొ జా లెక్క నే కెర్తె జా ఉప్పిర్ గేర్‍చి పునాది గలిలె పడ్తొ డబ్బుల్ సరిపుచుప నే జతిస్‍చి రుజ్జు పడ్తొ దెక పూర్తి బందుక నెత్ర ముల దిలె, దెకితస ఎత్కిజిన్ జోక ఆఁసుల. ");
INSERT INTO key_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘ఈంజొ మాన్సు ఉప్పిర్ గేర్ బందుక మొదొల్ కెర్లొ, గని పూర్తి బందుక నెత్’ మెన ఆఁసుల. ");
INSERT INTO key_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“అన్నె, ఏక్ రానొ అన్నెక్లొ రానొచి ఉప్పిరి యుద్దుమ్ కెరుక ఉచర్తయ్. ఈంజొ రానొక దెస్సు వెయిల్‍జిన్ సయ్‍న్యుమ్ సుదల్ తిలె, గని జో అన్నెక్లొ రానొక విస్సెక్ వెయిల్‍జిన్ సయ్‍న్యుమ్ సుదల్ తిలె, ఈంజొ తొక్కి సయ్‍న్యుమ్ తిలొసొ తొలితొ వెస, ‘జో అన్నెక్లొచి ఉప్పిరి జీనుక సెక్తి అస్సె గే, నాయ్ గె’ మెన ఉచరెదె. ");
INSERT INTO key_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","‘జీనుక సెక్తి నాయ్’ మెన డీసిలె, ఈంజేఁవ్ జోక దూరి తా పాసి నే జతె అగ్గె, ‘అమ్ కట్టు జమ. తుమ్‍క అమ్ కిచ్చొ దెంక గే తుమ్ సంగ’ మెన ఈంజొ రానొ జో అన్నెక్లొ రానొక కబుర్ తెద్రయెదె. ");
INSERT INTO key_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“దస్సి, తుమ్‍చితె కో జోక తిలిసి ఎత్కి ములె నాయ్ గే, అంచొ సిస్సుడు జంక నెత్రె” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“లోన్ చెంగిల్ అస్సె, గని లోన్‍చి కారు గెలెగిన, జా లోన్ కీసి అన్నె కారు జయెదె? జయె నాయ్. అన్నె ");
INSERT INTO key_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","జా కారు గెలి లోన్‍క ‘ఎరు’ మెన బుఁయ్యె సువుక కి కామ్‍క నెంజె. ఆరి వెంట గెలుక జయెదె. సూన్‍త కంగ్డొ కక్క తిలె, సూన్‍తు!” ");
INSERT INTO key_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ఏక్ సుట్టు సిస్తు నఙిత సుంకర్లు చి ‘పాపుమ్ సుదల్’ మెన యూదుల్ నిస్కారుమ్ దెకిత అన్నె ఒగ్గర్‍జిన్ యేసుచి బోదన సూనుక మెన పాసి జెతె తిల, చి ");
INSERT INTO key_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","పరిసయ్యుల్ చి మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస దెక కెర, “ఈంజొ మాన్సు పాపుమ్ సుదల్ బెదవన జోవయింతెన్ అన్నిమ్ కతయ్” మెల. ");
INSERT INTO key_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","జాకయ్ జోవయింక ఈంజ టాలి యేసు సంగిలన్. ఇసి జతయ్: ");
INSERT INTO key_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“తుమ్‍తె, మెనుమ, ఎక్కిలొక పుంజెక్ మెండల్ తిలె, చి జోవయింతె ఏక్ నెస తిలె, జేఁవ్ తిలి బయిలె తిల ఏక్ తకు పుంజెక్ మెండల్‍క ముల దా కెర, జో నెస తిలొ మెండపిల్ల చజనుక గెచ్చెదె. ");
INSERT INTO key_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","గెచ్చ చజ, డీసిల్ బేగి సర్దసంతోసుమ్ జా కందిగోడొ కెరన ");
INSERT INTO key_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","గెరి దెరన జెయెదె, అన్నె, గోతుసుదల్‍క చి పాసి గెరల్‍చ మాన్సుల్‍క బుకారా కెర, ‘అంచి సంతోసుమ్‍తె తుమ్ బెద. కిచ్చొక మెలె, నెస తిలి అంచి మెండపిల్ల అన్నె దొర్కు జా అస్సె’ మెనెదె. ");
INSERT INTO key_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","దస్సి తుమ్‍క ఆఁవ్ కిచ్చొ మెంతసి మెలె, తుమ్‍చి తెన్ పుంజెక్ మెండల్‍తె ఏక్ నెస తిలె, జా ఏక్ అన్నె దొర్కు జలె కీసి సర్దసంతోసుమ్ జస్తె గే, దస్సి, పుంజెక్ జిన్ మాన్సుల్‍తె ఏక్ తకు పుంజెక్‍జీన్ ‘పాపుమ్ సుదల్ నెంజుమ్’ మెన ఉచరన్లస తిలె, గని అన్నెక్లొ జో కెర్ల పాపల్ చినన దుకుమ్ జా పాపుమ్ ముల దిలె, జేఁవ్ ఏక్ తకు పుంజెక్‍జిన్‍చి రిసొచి కంట జోవయించి పాపుమ్ ముల మార్సుప జలొసొచి రిసొ పరలోకుమ్‍తె ఒగ్గర్ సర్దసంతోసుమ్ జవుల. ");
INSERT INTO key_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“అన్నెక్ టాలి ఉచరుమ. ఏక్ తేర్‍బోదక దెస్సు వెండి కాసుల్ తిలె, జోవయింతె ఏక్ సేడ గెలె, జా కిచ్చొ కెరెదె? దీవు లంబడ, గేరు వడ్డవ, జా డీస్తె ఎదక సరిగా చజెదె, గెద! ");
INSERT INTO key_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","జలె, జా డీసిలె, బేగి జేఁవ్‍చ గోతుసుదల్‍క చి జేఁవ్‍చి గేర్‍క పాసి తిల గెరల్‍చ మాన్సుల్‍క బుకారా కెర, ‘అంచి సంతోసుమ్‍తె తుమ్ బెద. కిచ్చొక మెలె, నెస తిలి అంచి వెండి కాసు అన్నె డీస అస్సె’ మెనెదె. ");
INSERT INTO key_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","దస్సి, తుమ్‍క ఆఁవ్ కిచ్చొ మెంతసి మెలె, కో జలెకు ఎక్కిలొ కి జో కెర్ల పాపల్ చినన దుకుమ్ జా పాపుమ్‍బుద్ది ముల దిలె, పరలోకుమ్‍తె దేముడుచ దూతల్ సర్దసంతోసుమ్ జవుల” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","తెదొడి యేసు అన్నె, “ఏక్ మాన్సుక దొగుల పుత్తర్లు తిల. ");
INSERT INTO key_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","జేఁవ్ పుత్తర్సుల్‍తె దకిలొ పుత్తుసి అబ్బొస్‍క ఇసి మెన సంగిలొ. ‘ఓ బ, తుచి ఆస్తితె అంక జెతి వాట అప్పె దె’ మెలన్. జలె, జో అబ్బొసి జోచి ఆస్తిక దొన్ని వాటల్ కెర, జేఁవ్ దొగుల ఎక్కెక్లక జెత వాటల్ జోవయింక వంట దిలన్. ");
INSERT INTO key_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“జలె, ఒగ్గర్ దీసల్ నే గెతె అగ్గె, జో దకిలొ పుత్తుసి జోచి వాట సామన్లు ఎత్కి కి బెదవన కెర, ఏక్ దూరి దేసిమి గెచ్చుక మెన బార్ జలన్. జా దూరి దేసిమి గెచ్చ తా, ఈంజొ కిచ్చొ కెర్లన్? బుద్ది నెంజిల కమొతె జోక దిలిసి ఎత్కి పాడ్ కెర గెలన్. ");
INSERT INTO key_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","జా పూర్తి కేడ్తికయ్, జా దేసిమి వెల్లి గార్ జా గెలి, చి జింక అల్లర్ జలన్. ");
INSERT INTO key_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","జింక అల్లర్ జా, జా దేసిమ్‍చొ మాన్సు ఎక్కిలొతె కామ్ నఙనుక గెలొ, చి ‘అంచ అండ్రుల్ కతిస్‍తె గెచ్చ జేఁవ్‍క రక్కు’ మెన కామ్ దిలన్, చి యూదుల్ తెన్ జా కామ్ నిస్కారుమ్‍చి జలెకి, కెర్లన్. ");
INSERT INTO key_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","జలె చూ బమ్మక జో ఉబెడొ కీసి జలొ మెలె, జేఁవ్ అండ్రుల్ కతిసి జో కి సర్ద తెన్ కతొ, గని జోక కో దెతి నాయ్. ");
INSERT INTO key_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“దస్సి, జోక కొవ్‍ని నాయ్, తోడు నాయ్ చి రిసొ సగుమ్ దీసల్ గెతికయ్, జోక బుద్ది అయ్‍లి, చి కిచ్చొ మెన ఉచరన్లన్ మెలె, ‘అబ్బొచ గొతిమాన్సుల్‍క సరిపుచుప జతి అన్నిమ్ అస్సె, గని ఆఁవ్ పుత్తుసి ఇన్నె చుక మొర గెతసి. ఈంజ అల్లర్ ఆఁవ్ కిచ్చొక సేడుక? ");
INSERT INTO key_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","అబ్బొతె గెచ్చిందె, చి ఓ బ, దేముడుక అన్నె తుక విరోదుమ్ జలి రితి, ఆఁవ్ పాపుమ్ కెర అస్సి.’ ");
INSERT INTO key_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","‘అంచొ పుత్తు’ మెన తుయి అంక సంగుక జలె, అంక విలువ నాయ్, గని అంక ‘అంచొ గొతిమాన్సు’ మెన తుయి అంక తియన కామ్ దె” మెన సంగిందె మెన జో ఉబెడొ ఉచరన, ");
INSERT INTO key_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ఉట్ట, అబ్బొస్‍తె అన్నె గెచ్చుక బార్ జలొ. జలె, అబ్బొస్‍చొ గేరుక అన్నె దూరి తిలి పొది, అబ్బొసి జోవయింక దెక కెర, జో బుద్ది నెంజ తిలొ గని అప్పె ఇదిల్ బుద్ది జలొ పుత్తుస్‍చి ఉప్పిరి కన్కారుమ్ జా నిగ జా కెర, జోక అమ్‍డ చుంబిలన్. ");
INSERT INTO key_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“తెదొడి జో పుత్తుసి జోక ‘ఓ బ, దేముడుచి ఉప్పిరి, అన్నె తుచి ఉప్పిరి విరోదుమ్ జలి రితి, ఆఁవ్ పాపుమ్ కెర అస్సి. అంచొ పుత్తు మెన తుయి అంక సంగుక అంక విలువ నాయ్,’ మెలన్. ");
INSERT INTO key_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","గని అబ్బొసి జోవయించ గొత్తి సుదల్‍క బుకారా కెర, ‘అమ్‍చ పాలల్ ఎత్కితె చెంగిల్‌చి బే బేగి ఆన ఇన్నెక గల దాస, చి ఇన్నెచి ఊంటితె ఉంగారుమ్ చి చట్టెలె జోడ్లు గల దాస. ");
INSERT INTO key_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","దస్సి కెర్లదు మెలె, అమ్ బల్సుప జలొ పోతుపిల్ల తుమ్ ఆన కండ, చి ఈంజొ గెరి ఉట్ట అయ్‍లి సర్దక విందు కెరుమ. ");
INSERT INTO key_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","కిచ్చొక మెలె, ఈంజొ అంచొ పుత్తు మొర గెచ్చ అన్నె జిఁయ అస్సె. నెస తిలొ, చి అన్నె దొర్కు జలొ’ మెన అబ్బొసి సంగిలొ, అన్నె, ఎత్కి తెయార్ జతికయ్, సర్ద కెరనుక దెర్ల. ");
INSERT INTO key_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“జలె, ఈంజొ గెరి ఉట్ట అయ్‍లొ ఉబెడొచొ అన్నొసి జోవయించి బుఁయితె కామ్ కెర్తె తిలొ, చి గెరి అన్నె ఉట్ట జెతె తిలి పొది పాసి అయ్‍లె, బాజె నచితి అవాడ్ సూన్లన్. ");
INSERT INTO key_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","సూన కెర, గొత్తి సుదొ ఎక్కిలొక బుకారా కెర, ‘కిచ్చొక బజయితతి, సర్ద కెరంతతి?’ మెన పుసిలన్, ");
INSERT INTO key_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","చి గొత్తి సుదొ జోక, ‘బావొది గెరి అయ్‍లన్ చి జో జీవ్ తా గెరి ఉట్ట జా అస్సెచి రిసొ అబ్బొది బేడు తిలొ పోతుపిల్ల కండయ్‍లన్.’ ");
INSERT INTO key_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“జలె, జో మాన్సుచొ ఈంజొ వెల్లొ పుత్తుస్‍క కోపుమ్ అయ్‍లి, చి గెరి పెసుక కి జోక ఇస్టుమ్ నాయ్. జాకయ్ అబ్బొసి బార్ జా, తెడి జె మెన బతిమాల్ప జా సంగిలన్, గని ");
INSERT INTO key_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","అబ్బొస్‍క జో, ‘ఈందె, ఎత్తి వెర్సుల్ తుచి సేవ కెర్లయ్, తుయి సంగిలిసి నిదానుమ్ కెర, కెఁయ్య కి పిట్టవి నాయ్. జలెకి, అంచ గోతుసుదల్ తెన్ ఆఁవ్ సర్ద తెన్ విందు కెరంతి రితి కెఁయ్య కి ఏక్ ఇదిలిసి గొర్రె కి దెస్సి నాయ్. ");
INSERT INTO key_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","గని సానివొ తెన్ బెద తుచి ఆస్తి పాడ్ కెర్లొ ఈంజొ పుత్తుది గెరి జెతికయ్, తుయి బేడు తిలొ పోతు కండయ్‍లది! కిచ్చొ సత్తిమ్, జా!’ మెన జో వెల్లొ పుత్తుసి సంగిలన్, చి ");
INSERT INTO key_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","అబ్బొసి జోక, ‘ఓ పుత్త, తుయి కెఁయఁక కి అంచి తెన్ అస్సిసి, చి అంచి ఆస్తి ఎత్కి తుచి. ");
INSERT INTO key_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","జలెకి, ఈంజొ తుచొ బావొది మొర గెచ్చ అన్నె జీవ్ జలన్. నెస తిలన్, గని అన్నె దొర్కు జలొచి రిసొ ఇసి విందు దా సర్ద కెరనుక చెంగిలి’ మెన సంగిలన్, మెన సిస్తు సంగిత సుంకర్లుక చి ‘పాపుమ్ సుదల్’ మెన అన్నె మాన్సుల్ నిస్కారుమ్ సంగిలస జోవయింక నంప కెర్తిస్‍చి రిసొ యేసు పండితుల్‍క టాలి సంగ జేఁవ్ పండితుల్‍చి తప్పుచి రిసొ ఉచరయ్‍లన్.” ");
INSERT INTO key_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","తెదొడి యేసు జోచ సిస్సుల్‍క, “సొమ్సారి ఎక్కిలొ తిలన్. జోచి గెర్‍చి కామ్ ఎత్కి దెకుక చి జోచి ఆస్తి ఎత్కి దెకుక జోతె ఏక్ మాన్సు తిలొ. జలె, ‘తుచి ఆస్తి దెకితొసొ జా ఆస్తి పాడ్ కెర్తయ్’ మెన జో ఎజొమానిక కబుర్ అయ్‍లి. ");
INSERT INTO key_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","జో జోచి ఆస్తి దెకితొసొక బుకారా కెర, ‘తుచి రిసొ ఆఁవ్ సూన్లిసి కిచ్చొక? అప్పె తెంతొ తుక ఇన్నె కామ్ నాయ్. తుచి అత్తి ఆఁవ్ సొర్ప కెర్లిస్‍క కిచ్చొ కెర అస్సిస్ గే కక్క కెద్ది దా అస్సిస్ గే లెక్కల్ కెర రెగుడ అంక దెకవు’ మెన ఎజొమాని సంగిలొ. ");
INSERT INTO key_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“జలె, ఎజొమానిచి ఆస్తి దెకితొ ఈంజొ మాన్సు కిచ్చొ తెలివి ఉచరన్లన్ మెలె, అంచొ ఎజొమాని అంక కడ గెలెదె జలె, ఆఁవ్ కిచ్చొ కెర్లె జయెదె? కూలి కామ్ కెరుక అంక సత్తు నాయ్, అఁవ్ నెతిరి. బిచ్చిమ్ నఙుక లాజు, మెన ఉచర అస్సి. ");
INSERT INTO key_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ఎజొమాని అంక కడ గెలె పొది మాన్సుల్ అంక సినేతుమ్ జా తా జోవయించ గెరలె బుకార్లె బాద తయె నాయ్ మెన ఉచరన కెర, ");
INSERT INTO key_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ఎక్కిలొకచి పడ్తొ అన్నెక్కిలొక వర్స తెన్ జోచొ ఎజొమానితె రునుమ్ జల ఎత్కిజిన్‍క బుకారా కెర, తొలితొచొక అంచొ ఎజొమానిక తుయి కెద్ది బాకి జా అస్సిసి? మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","జో రునుమ్ జలొసొ చెత్తర్ వెయిల్ కాయల్ తేలు మెలన్, చి ఈంజొ జలె తుచి బాకి నఙ తిలి పుస్తకుమ్ బేగి చజన వెస ‘దొన్ని వెయిలు’ మెన రెగుడు మెలన్. ");
INSERT INTO key_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“తెదొడి ఎజొమానిచొ గేర్ దెకితొసొ అన్నెక్లొక బుకారా కెర, ‘తుయి కెద్ది బాకి జా అస్సిస్’, మెన పుసిలన్, చి జో ‘వెయి నాడివొ గోదుమ్’ మెంతికయ్, ‘దస్సి జలె, తుచి బాకి కాగ్తుమ్ వెంట అట్టు పుంజొ’ మెన రెగ్డను మెలన్. ");
INSERT INTO key_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“జలె, జోచి ఆస్తిక దెకితొ జో అబద్దుమ్ కెర్లొ మాన్సుచి తెలివి దెక, తెలివి కామ్ కెర్లది మెన జో ఎజొమాని సంగిలొ. ఈందె, దేముడుచి ఉజిడ్ బుద్ది జలసచి కంట ఈంజ లోకుమ్‍చి బుద్ది తిలస జోవయించి ఈంజ కాలుమ్‍చ మాన్సుల్ తెన్ బలే తెలివి దెకన్‍తతి. ");
INSERT INTO key_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“జలె, తుమ్‍క ఆఁవ్ కిచ్చొ మెంతసి? ఈంజ లోకుమ్‍చి దనుమ్ తెన్ తుమ్‍క నేస్తమ్ కెరన, చి జా డబ్బుల్ కేడ్లె పరలోకుమ్‍తె ఎల్లకాలుమ్ జియఁతస్తితె తుమ్‍క బెదవనుల. ");
INSERT INTO key_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ఈందె, కో జలెకు ఇదిలిస్ కామ్‍తె నిదానుమ్ కెరెదె గే, వెల్లి కామ్‍తె కి నిదానుమ్ కెరెదె. గని కో జలెకు ఇదిలిస్ కామ్‍తె అబద్దుమ్ కెరెదె గే, వెల్లి కామ్‍తె కి అబద్దుమ్మి కెరెదె. ");
INSERT INTO key_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","జాకయ్, మాములుమ్ ఈంజ లోకుమ్‍చి డబ్బుల్ వాడిక కెర్తిస్‍తె తుమ్ నిదానుమ్ నే కెర తిలెగిన, పరలోకుమ్‍చి దనుమ్ తెన్ తుమ్ కామ్ కెర్తి రితి దేముడు కీసి తుమ్‍చి అత్తి జా సొర్ప కెర దెయెదె! తుమ్‍క జో కీసి నంప కెరుక జయెదె! ");
INSERT INTO key_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","అన్నె, జోవయించి ఆస్తిక తుమ్ దెకుక మెన అన్నెక్లొ తుమ్‍చి అత్తి సొర్ప కెర తిలె, గని తుమ్ జా ఆస్తిక నిదానుమ్ నే కెర్లె, తుమ్‍క జెతికయ్ తుమ్‍చి సొంత ఆస్తి కో తుమ్‍క దెవుల! దిలె, పాడ్ కెరుల మెనుల. ");
INSERT INTO key_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","కేన్ గొతిమాన్సు ఎక్కె దడి దొగుల ఎజొమాన్లుచి సేవ కెరుక నెత్రె. కిచ్చొక మెలె, ఎక్కిలొక విరోదుమ్ కెర, అన్నెక్లొక ప్రేమ కెరెదె, నెంజిలె జో అన్నెక్లొక నిదానుమ్ కెర, తొలితొచొక నిస్కారుమ్ దెకెదె. జలె, దేముడుక చి ఈంజ లోకుమ్‍చి దనుమ్‍క ఎక్కె దడి సేవ కెరుక నెతుర్సు” మెన యేసు జోచ సిస్సుల్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ఈంజ లోకుమ్‍చి దనుమ్‍చి రిసొ యేసు తెదొడి సిస్సుల్‍క సంగిలిసి పరిసయ్యుల్ సూన కెర జోక కొంకడ్ల. కిచ్చొక మెలె దేముడుచి సేవ కెర్తసుమ్ మెనన్లె కి, డబ్బుల్‍క జోవయింక ఒగ్గర్ ప్రేమ. ");
INSERT INTO key_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","యేసు జోవయింక, “మాన్సుల్‍చి మొక్మె పున్నిమ్ తిలి రితి డీసుక ఆస జతస తుమి. గని తుమ్‍చి పెట్టి కిచ్చొ బుద్ది అస్సె గే దేముడు జానె. జలె, ఈంజ లోకుమ్‍చ మాన్సుల్ కిచ్చొచి రిసొ ‘ముక్కిమ్‍చి’ మెనుల గే, దస్సిచిక దేముడు వెట్కారుమ్‍చి మెనెదె. ");
INSERT INTO key_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“బాప్తిసుమ్ దెతె తిలొ యోహాను బార్ జలి ఎదక మోసే పూర్గుమ్‍చొచి అత్తి దేముడు రెగ్డయ్‍ల ఆగ్నల్, అన్నె పూర్గుల్‍చి అత్తి సంగిల దేముడుచ కబుర్లు రెగిడ్లిసి ముక్కిమ్ జా తిల. గని యోహాను అయ్‍లి తెంతొ, దేముడుచి రాజిమ్ పాఁవ జా అయ్‍లిస్‍చి రిసొచి, సుబుమ్ కబుర్ సూనయి జతయ్, జో సూనయ్‍లొ, ఆఁవ్ సూనయ్‍తసి, చి పాఁవ జా అయ్‍లి ఈంజ రాజిమ్‍తె బెదితస ఎత్కిజిన్ బెదుక మెన బమ్మ జతతి. ");
INSERT INTO key_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","మోసే పూర్గుమ్‍చొచి అత్తి దేముడు రెగ్డయ్‍ల ఆగ్నల్‍చి ఎక్కి అచ్రుమ్‍చి విలువ గెచ్చె నాయ్, జెతె కేన్ అచ్రుమ్ కామ్‍క నెంజితి రితి జతి కంట, పరలోకుమ్ బూలోకుమ్ కేడ గెచ్చుక సుల్లు. ");
INSERT INTO key_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“కో జలెకు జో జోచి తేర్సిక ముల దా అన్నెక్లిక పెండ్లి కెరన్లె, లంజె వంసుమ్‍చొ జతయ్, చి జాకయ్ పెండ్లి ముల దిలి కేన్ తేర్‍బోదక కో పెండ్లి జయెదె గే, జో కి లంజె వంసుమ్‍చొ జతయ్. ");
INSERT INTO key_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“సొమ్సారి ఎక్కిలొ తిలన్. జో రోజుక చెంగిల చెంగిల సొమ్సార్లు గలంతి ఊద రంగుచ ఒగ్గర్ కరీద్‍చ పాలల్ గలనెదె, చి రోజుక ఇస్టుమ్ అయ్‍లి సర్ద కెరన సుక్కుమ్ తెన్ జితె తిలొ. ");
INSERT INTO key_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","జలె, జో సొమ్సారొచి మేడచి గుమ్ముమె లాజర్ మెలొ బీద సుదొ ఎంగ్డ తయెదె. జోచి ఆఁగ్ బెర్తు గావ్వో తిల. ");
INSERT INTO key_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","జో సొమ్సారొ అన్నిమ్ కెర్తి బల్లయ్ తెంతొ సేడ్త చింబొ గిడ్డల్ జో బీద సుదొక దొర్కు జలె, సర్ద తెన్ కతొ, తెద్ది మాలఙ్ జా తెద్ది చూ జా తిలొ, అన్నె సూనర్లు జోచ గావ్వో లేంవితె తిల. ");
INSERT INTO key_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“జలె, ఏక్ దీసి జో బీద మాన్సు మొర గెలొ, చి పరలోకుమ్‍తె అబ్రాహామ్ పూర్గుడు తెన్ తతి రితి దూతల్ జో బీద జలొ లాజర్‍క వయ కడ నిల. జలె, జో సొమ్సారొ కి మొర గెలన్, చి జోక మాన్సుల్ రోవ గెల. ");
INSERT INTO key_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","అన్నె జో వెల్లి ఆగ్ లగితి గొయితె ఒగ్గర్ సిచ్చల్ జతె తా, ఉప్పిరి దెకిలె, దూరిక అబ్రాహామ్‍క చి జోచి పాసి వెస తిలొ లాజర్‍క దెకిలన్. ");
INSERT INTO key_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","దెక కెర, ‘ఓ అమ్‍చొ అబ్రాహామ్ తాతొ, అంచి ఉప్పిరి కన్కారుమ్ తీ, చి జోచి ఊంటి పానితె బుడ్డవ అంచి జీబుతె ఇదిల్ లయడ తిమడ్తి రిసొ జో లాజర్‍క అంచితె తెద్రవు. ఈంజ ఆగి అంక ఒగ్గర్ నొప్పి దెతయ్‍చి రిసొ’ మెన సొమ్సారొ బతిమాల్ప జా సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","గని అబ్రాహామ్ జోక, ‘పుత్త, తుయి బూలోకుమ్‍తె జితె తిలి పొది తుక ఇస్టుమ్ అయ్‍లిసి దొర్కు కెరన సుక్కుమ్ తెన్ జితె తిలది. గని లాజర్ కస్టల్ సేడ్తె తిలన్. గని అప్పె జో ఇన్నె సుక్కుమ్ జా అస్సె, చి తుయి ఒత్త సిచ్చల్ సేడ్తె తత్తసి. ");
INSERT INTO key_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","అన్నె కిచ్చొ మెలె, తుమ్‍క అమ్‍క మదెనె వెల్లి గొయి అడ్డు అస్సె. ఏక్ వేల ఇన్నె తెంతొ సగుమ్‍జిన్ ఒత్త గెచ్చుక ఉచర్లె అడ్డు తవుసు. నెతుర్సు’ చి ‘ఒత్త తిలస కో కి ఇన్నె డేఁవ జెతు నాయ్ మెన జా గొయి అడ్డు అస్సె’ మెన ");
INSERT INTO key_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","అబ్రాహామ్ సంగితికయ్, సొమ్సారొ అన్నె, దస్సి జలె, తాతొ, అంచి ఏక్ మనవి సంగిమ్‍దె. దయ కెర, అంచొ అబ్బొచి గెరి జో లాజర్‍క తెద్రవు. ");
INSERT INTO key_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","అంక పాఁచ్‍జిన్ బావుడ్లు అస్తి, చి జేఁవ్ కి ఈంజ సిచ్చ జతి లోకుమ్‍తె నే ఉత్ర, సేడ్తి రితి జోవయింక బుద్ది సికడ్సు మెలన్. ");
INSERT INTO key_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","గని అబ్రాహామ్ జోక అన్నె, ‘మోసేచి అత్తి రెగిడ్లి దేముడుచి ఆగ్నల్, అన్నె దేముడుచ కబుర్లు సంగిల పూర్గుల్ రెగిడ్ల పుస్తకల్ ఎత్కి జోవయింక అస్సె. ఒత్త తిలిసి సరిగా సూన్‍తు, చి జేఁవ్ బుద్ది జంక జయెదె’ మెన అబ్రాహామ్ సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","గని జో అన్నె అబ్రాహామ్ తెన్, ‘నాయ్, ఒత్త తిలిసి సూన్లె కి కెర్తి నాయ్, గని మొర గెలొసొ కో జలెకు జేఁవ్‍తె గెచ్చ బుద్ది సంగిలె, జేఁవ్ కెర్ల పాపల్ చినన దుకుమ్ జా పాపుమ్‍బుద్ది ముల మార్సుప జవుల’ మెలన్. ");
INSERT INTO key_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","చి ఆకర్‍క అబ్రాహామ్ జోక కిచ్చొ జబాబ్ దిలన్ మెలె, ‘మోసేచి అత్తి దేముడుచి ఆగ్నల్ రెగిడ్లి కొడొ కి, దేముడుచ కబుర్లు సంగిల పూర్గుల్ రెగిడ్లి కొడొ సూన నంప నే కెర్లె, కో జవుస్ మొర్లొ మాన్సు అన్నె జీవ్ జా ఉట్లెకి నంప కెర్తి నాయ్.’”, మెన పరిసయ్యుల్‍క యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","తెదొడి యేసు జోవయించ సిస్సుల్‍క, “పాపుమ్ కెరయ్‍త అల్లర్ కచితుమ్ జెయెదె, గని కచి అత్తి దస అల్లర్ జెవుల మెలె, అయ్యొ, జోవయింక సిచ్చ పిట్టె నాయ్! ");
INSERT INTO key_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","అంక నంపజల ఇస బాలబోదల్ జలసతె ఎక్కిలొక కి, కో పాపుమ్ కెరయెదె గే, జోచి టొట్రయ్ తిర్వేలి పత్తురు. ఒడొవ దా జోవయింక సముద్రుమ్‍తె బుడ్డవ గెలుక చెంగిలి. ");
INSERT INTO key_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","తూమ్ జాగర్త తా. తుమ్‍చితె కో గే మెనుమ. తుచొ కేన్ జవుస్ బావొ పాపుమ్ కెర్లెగిన, జోవయింక బుద్ది సంగు, చి జోవయించి తప్పుక దుకుమ్ జా బుద్ది జలెగిన, జోవయింక చెమించుప కెరు. ");
INSERT INTO key_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","అన్నె, రోజుక సత్తు సుట్లు కి తుక పాపుమ్ కెర జేఁవ్ సత్తు సుట్లు తుచి పక్క పసుల ‘అంచి తప్పు. చెమించుప కెరు’ మెన జో సంగిలెగిన, తుయి జోక చెమించుప కెరుక అస్సె” మెన యేసు జోచ సిస్సుల్‍క బుద్ది సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","తెదొడి యేసుచ జేఁవ్ బారజిన్ బారికుల్ యేసుప్రబుక కిచ్చొ మెలన్ మెలె, “అమ్‍క అన్నె ఒగ్గర్ నముకుమ్ దె” మెల చి, ");
INSERT INTO key_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","యేసు జోవయింక, “సొర్సుగిడ్డచి ఎదిలి నముకుమ్ తుమ్‍క తిలె, ఈంజొ మారోడు రూకుక ‘ఉట్కి జా సముద్రుమ్‍తె గెచ్చ రోవి జా’ మెలె, తుమ్ సంగిలె, జా కోడు సూన్లె జా దస్సి జయెదె.” ");
INSERT INTO key_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“తుమ్‍చితె ఎక్కిలొక గొత్తి సుదొ తయెదె మెనుమ, చి జో గొత్తి సుదొ కేఁస్సొతొ జవుస్, మెండల్ రక తా జవుస్ గెరి అన్నె అయ్‍లె, ‘తుయి బేగి గెచ్చ అన్నిమ్ కెరు’ మెన ఎజొమాని సంగెదె గె? ");
INSERT INTO key_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","నాయ్, గెద. ‘తొలితొ అంచి రిసొ అన్నిమ్ తెయార్ కెర తుచొ పాలుమ్ కుంచన అంక జొగుడ దె, చి ఆఁవ్ అన్నిమ్ కెర పాని పిలి పడ్తొ తుయి కా, పి’ మెన ఎజొమాని సంగెదె. ");
INSERT INTO key_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","అన్నె, జో గొత్తి సుదొ జోక దిలి కామ్ కెర జోచి పూచి తిలిసి కెర్లి రిసొ జో ఎజొమాని జోక ‘తుయి దయ కెర్లది’ మెనెదె గె? నాయ్, గెద. ");
INSERT INTO key_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","జలె, తుమ్‍చి పూచి తెన్ కి దస్సి, దేముడు తుమ్‍క సంగిలిసి ఎత్కి కెర తుమ్‍చి పూచి కెర తిలె, తుమ్ కిచ్చొ మెన మెలె, ‘అమ్ రితయ్ గొత్తి సుదల్. అమ్ గవురుమ్‌క విలువ నాయ్. అమ్‍క పూచి తిలిసి కెర అస్సుమ్. తెద్దిలి’ మెన తుమ్” మెన యేసు సిస్సుల్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ఒత్త తెంతొ అన్నె కిచ్చొ జర్గు జలి మెలె, యేసు యెరూసలేమ్ పట్నుమ్‍తె గెచ్చుక మెన సమరయ ప్రదేసిమ్‍క చి గలిలయ ప్రాంతుమ్‍క మదెనె గెతి వట్టె గెతె తా, ");
INSERT INTO key_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ఏక్ గాఁవ్‍క పాసి అయ్‍లె, వెల్లి రోగుమ్ దెర్ల దెస్సుజిన్ మాన్సుల్ జోక దస్సుల్ జంక మెన అయ్‍ల, అన్నె, ఇదిల్ దూరి తా ");
INSERT INTO key_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","కేక్ గల. కిచ్చొ మెన కేక్ గల మెలె, “యేసుప్రబు, బాబు, అమ్‍చి ఉప్పిరి కన్కారుమ్ తీ” మెన కేక్ గల. ");
INSERT INTO key_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","జలె, యేసు జోవయింక దెక కెర “దేముడుచి గుడితె తుమ్ గెచ్చ, ఒత్తచ పూజర్లుతె దెకవన” మెన సంగిలన్, చి ఒత్త యెరూసలేమ్‍తె గెచ్చుక మెన వట్టె గెలె కిచ్చొ జర్గు జలి మెలె, జోవయించి ఆఁగ్ చెంగిల్ జా సుద్ది జల. ");
INSERT INTO key_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","జలె, జోవయింతె ఎక్కిలొ జో చెంగిల్ జలిసి దెకన, గట్టిఙ అవాడ్ కెరన దేముడుచి గవురుమ్ సంగ సంగ, యేసు తిలిస్‍తె ఉట్ట అయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ఉట్ట జా, “అంక రచ్చించుప కెర దయ కెర్లది” మెన యేసుక జోచి సర్ద సంగ యేసుచి చట్టె సెర్ను సేడ్లొ. జో మాన్సు సమరయ సుదొ. ");
INSERT INTO key_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","జలె, యేసు తెదొడి, “దెస్సుజిన్‍క చెంగిల్ కెర్లయ్, గెద. జేఁవ్ అన్నెక్ నొవ్వుజిన్ కేతె? ");
INSERT INTO key_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ఈంజొ యూదుడు నెంజిలొసొక పిట్టవ, జేఁవ్ అమ్‍చ యూదుల్‍తె అన్నె కో జోవయించి సర్ద సంగుక జెతి నాయ్ గె?” మెన పుస కెర, ");
INSERT INTO key_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","జో చెంగిల్ జలొసొక అన్నె, “తుయి ఉట్ట, గెరి గో. అంచి ఉప్పిరి తుయి నముకుమ్ తిలి రిసొ చెంగిల్ జా అస్సిసి” మెన యేసు జో మాన్సుక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","జలె, “దేముడుచి రాజిమ్ కెఁయఁక జెయెదె?” మెన సగుమ్‍జిన్ పరిసయ్యుల్ యేసుక పుసిల చి, జో, “దేముడుచి రాజిమ్ డీస్తిసి నెంజె. కెఁయఁక గే డీస జెయెదె మెన నాయ్. ");
INSERT INTO key_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","‘ఈందె, ఇన్నె అస్సె’ జలెకు, ‘ఓదె, ఒత్త అస్సె’ జలెకు మెనుక బెదె నాయ్. కిచ్చొ మెలె, దేముడుచి రాజిమ్ అప్పెయి కి తుమ్‍చి నెడిమి అస్సె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","జోచ సొంత సిస్సుల్‍క యేసు, ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొక “ఏక్ దీసి గడియ జవుస్ డీసుస్” మెన తుమ్ ఒగ్గర్ ఆస జత దీసల్ జెవుల, గని జా మదెనె అంక దెకుక నెతుర్సు. ");
INSERT INTO key_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","అన్నె, “ఓదె, ఒత్త అస్సె. ఓదె, ఒత్తయ్ అస్సె” మెన సగుమ్‍జిన్ తుమ్‍క సంగుల, గని జోవయించి పట్టి తుమ్ గెచ్చ నాయ్. ");
INSERT INTO key_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","కిచ్చొక మెలె, బిజిలి మొల్కిలె, కీసి ఆగాసుమ్ పూర్తి ఏక్ పక్క తెంతొ అన్నెక్ పక్క ఎద ఉజిడి దెయెదె, దస్సి, ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ ఏలుప కెరుక మెన ఉత్ర జెతి దీసిక కేన్ పక్క కి డీసిందె. ");
INSERT INTO key_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","గని జా నే జతె అగ్గె తొలితొ ఆఁవ్ ఒగ్గర్ బాదల్ స్రెమల్ సేడుక అస్సె, ఈంజ కాలుమ్‍చ మాన్సుల్ అంక “అమ్‍క నాయ్. మొర్సు!” మెనుక అస్సె. ");
INSERT INTO key_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","నోవహు పూర్గుమ్‍చొచి కాలుమ్ మాన్సుల్ కీస్ జతె తిల గే, దస్సి, ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ అన్నె నే జెతె అగ్గెచి మదెనె ఆఁవ్ జెతె ఎదక మాన్సుల్ దస్సి జతె తవుల. ");
INSERT INTO key_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","మెలె, ‘జోవయించి పాపుమ్‍చి రిసొచి సిచ్చక’ మెన ఎత్కి అదికారుమ్ తిలొ దేముడు వెల్లి వర్దల్‍చి పాని గెడ్సుప కెరయ్‍లి గడియ ఎద, నోవహు జోచి కుటుంబుమ్ తెన్ జా వెల్లి ఓడతె పెస కెవ్డి డంకిల్ ఎద, నే నంప కెర్తె మాన్సుల్ కతె తా, పితె తా, పెండ్లివొ కెర్తె తా, పెండ్లివొ జతె తా జితె తిల, చి జేఁవ్ ఎత్కిజిన్‍క వర్దల్‍చి పాని గీడ గెలి. ");
INSERT INTO key_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","పడ్తొ లోతు పూర్గుమ్‍చొచి కాలుమ్ కి జో జితె తిలి సొదొమ పట్నుమ్‍చ దస్సి జతె తిల. ప్రెజల్ కతె తా, పితె తా, బియ్యారి కెర్తె తా, పంటొ పికయ్‍తె తా, గెరల్ బందితె తిల. ");
INSERT INTO key_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","గని లోతు జా సొదొమ పట్నుమ్ తెంతొ బార్ జా ముల దిలి దీసి, ఎత్కి అదికారుమ్ తిలొ దేముడు పరలోకుమ్ తెంతొ జా పట్నుమ్‍చి ఉప్పిరి ఆగిచి ఎడ్ది రితి ఇంగుడు సువ దిలన్, చి జా పట్నుమ్‍చ ఎత్కిజిన్ మొర గెల. ");
INSERT INTO key_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","అన్నె, ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ ఏలుప కెరుక మెన అన్నె ఉత్ర జా డీస్తి దీసి జెతి ఎద దస్సి మాన్సుల్ అంక నే ఉచర్తె, బుద్ది నే ఉచర్తె ఇస్టుమ్ అయ్‍లి రితి జితె తవుల, చి తెదొడ్‍క తీర్పు జా సిచ్చ జవుల. ");
INSERT INTO key_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“జా దీసిక జోచి గేరుచి ఒర్నె కో తవుల గే, జోచి సామన్ గెరి తిలె కి, జా వెంట నెంక మెన ఉత్రుతు నాయ్, అన్నె కో జోచి బట్టి జవుస్ తిలె, కిచ్చొ వెంటుక పసుల్తు నాయ్, గని బే బేగి ఉట్ట గెతు. ");
INSERT INTO key_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","లోతుచి తేర్సి జా సొదొమ పట్నుమ్‍క ఇదిల్ ఇస్టుమ్ జా జాక దెకుక మెన పసుల లోన్‍చి పత్తురు మర్లు జా గెలి, గెద. జలె, జాక దస్సి జర్గు జలిసి తుమ్ పఁవ్స నాయ్. ");
INSERT INTO key_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","కిచ్చొక మెలె, సొంత ప్రానుమ్ రచ్చించుప కెరనుక కో ఉచరుల గే, జోవయించి ప్రానుమ్ పాడ్ జా గెచ్చెదె, గని దేముడు దిలి వాటు ఎక్కి సత్తిమ్ ఇండుక మెన జోవయించి ప్రానుమ్ కో దెవుల గే, జోవయించి ప్రానుమ్ రచ్చించుప జయెదె. ");
INSERT INTO key_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“జా రాతిక దొగుల ఎక్కితె నిజ తిలె, ఎక్కిలొక ముల దా, అన్నెక్లొక కడ నెవుల. ");
INSERT INTO key_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","దస్సి, దొగుల తేర్‍బోదల్ రోడ్తె తిలె ఎక్లిక ముల దా, అన్నెక్లిక కడ నెవుల, ");
INSERT INTO key_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","అన్నె, దొగుల మున్సుబోదల్ బట్టి తిలె, ఎక్కిలొక ముల దా, అన్నెక్లొక కడ నెవుల” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","దస్సి సంగితికయ్, “కేనె కడ నెవుల, ప్రబు?” మెన సిస్సుల్ పుసిల, చి జోవయింక, “పీనుమ్ కేనె తయెదె గే, ఒత్త గిద్దుల్ బెరుల.” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","తెదొడి యేసు జేఁవ్ సిస్సుల్‍క ఈంజ టాలి సంగిలన్. కిచ్చొక మెలె, జో తీర్పు కెర ఏలుప కెరుక మెన అన్నె జెతె ఎదకచి మదెనె జేఁవ్ బద్దుకుమ్ గే అన్మానుమ్ గే నే జతె ప్రార్దన కెర్తె తంక మెన జోవయింక సికడ్తి రిసొ సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","ఇసి జతయ్ “ఏక్ పట్నుమ్‍తె తీర్పు కెర్తి టాన్‍తె తీర్పు దెతొసొ ఎక్కిలొ తిలొ. జో అన్నె మాన్సుల్‍క బియె నాయ్, దేముడుక బియె నాయ్. ");
INSERT INTO key_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","పడ్తొ, జయి పట్నుమ్‍తె రండెల్ మాన్సు ఎక్లి తిలి. ఈంజ జలె, రోజుక జో తీర్పు దెతొసొతె గెచ్చ కెర, ‘విరోదుమ్ సుదొ ఎక్కిలొ అంచి ఉప్పిరి దావ దా అస్సె. అంచి సంగిలీస్ సూన్లె జో మాన్సు సంగిలి నిందక ఆరిచి మెన రుజ్జు దెకయ్‍తిస్‍తె అంక తోడు తా’ మెన పుసితె తిలన్. ");
INSERT INTO key_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ఒగ్గర్ దీసల్ జో ఒప్పనె నాయ్, గని పడ్తొ కిచ్చొ బుద్ది జోక అయ్‍లి మెలె, ఆఁవ్ దేముడుక బితొసొ, మాన్సుక బితొసొ నెంజి, గని ");
INSERT INTO key_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ఈంజ రండెలి అంక అల్లర్ దా పుసుక ములె నాయ్ చి రిసొ, జాచి సంగిలీస్ సూన్‍తిస్తె తోడు సంగిమ్‍దె. నెంజిలె, జా రోజుక జెతె తతిస్‍క అంక పూర్తి అల్పు కెరెదె మెలన్” మెన యేసుప్రబు టాలి సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","కిచ్చొ అర్దుమ్ సంగిలన్ మెలె, “ఆదె, జో బుద్ది నెంజిలొ తీర్పు దెతొసొ కీస్ సంగిలొ! ");
INSERT INTO key_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","జలె, రాతి మెద్దెనె జాక జాచి బాదల్ కస్టల్ సంగిత జో నిసాన్ల జోచయ్ జల మాన్సుల్‍చ ప్రార్దనల్ దేముడు సూనె నాయ్ గె? జోవయింక తోడు జెయె నాయ్ గె? కచితుమ్ సూనెదె, తోడు జెయెదె. అన్నె జా తోడు జెంక ఆల్సిమ్ కెరెదె గె? నాయ్ గెద. ");
INSERT INTO key_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","బే బేగి తోడు జెయెదె. గని, జాగర్త, ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ ఈంజ లోకుమ్‍తె అన్నె ఉత్ర జెతి పొదిక మాన్సుల్ నిదానుమ్ నముకుమ్ తవుల గే నాయ్ గె?” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","పడ్తొ ‘అమ్‍క పున్నిమ్’ మెనన అన్నె మాన్సుల్‍క నిస్కారుమ్ ఉచర్ల మాన్సుల్‍క ‘సూన్‍తు’ మెన యేసు అన్నెక్ టాలి సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“ప్రార్దన కెరుక మెన దొగు మాన్సుల్ అమ్‍చి దేముడుచి గుడితె గెల. జోవయింతె ఎక్కిలొ పరిసయ్యుడు, ఎక్కిలొ సిస్తు నఙితొ సుంకరొ. ");
INSERT INTO key_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","జలె, పరిసయ్యుడు పుర్రెతొ టీఁవ, జోచి పెట్టి ఉచరన ఇసి ప్రార్దన కెరన్లన్, ‘ఓ అమ్‍చొ దేముడు, ఆఁవ్ జేఁవ్ అన్నె మాన్సుల్‍చి రితి నెంజిల్ రిసొ తుక అంచి సర్ద ఆఁవ్ సంగితసి. జేఁవ్, జలె, మాన్సుల్‍క బియఁడ, జోవయించి ఆస్తి దొర్కు కెరంతతి, కిచ్చొ కిచ్చొ నాయిమ్ నెంజిల కమొ కెర్తతి, లంజెకమొ కెర్తతి, చి సగుమ్‍జిన్ కి జో ఒత్తల్‍తొచొ సిస్తు నఙితొసొచి రితి జతతి. ");
INSERT INTO key_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","గని అఁవ్ సత్తరెక్క తివ్వెరి చువ్వె తత్తసి, చి అంక దొర్కు జతిస్ ఎత్కితె దెస్సు వాటల్‍తె ఏక్ వాట తుక దెతసి’ మెన దేముడుక ప్రార్దన కెర్లన్. ");
INSERT INTO key_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“గని, జో సిస్తు నఙితొసొ, ఇదిల్ దూరి టీఁవ తా, మాములుమ్ జేఁవ్ యూదుల్ కెర్తి రితి నే కెర్తె, ఉప్పిరి నే దెకితె, లాజుక మొకొమ్ లుంకడ గుండెతె పెటన ‘ఓ దేముడు, ఆఁవ్ పాపుమ్‍చొ మాన్సు. అంచి ఉప్పిరి కన్కారుమ్ జా అంచ పాపల్ చెమించుప కెరు!’ మెన ప్రార్దన కెర్లన్. ");
INSERT INTO key_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","జలె, జేఁవ్ దొగులతె కక్క ‘సత్తిమ్ జలొ’ మెన దేముడు దెకిలన్? జో గవురుమ్ ఉచరన్లొసొక, నాయ్, గని పాపుమ్ ఒప్పన్లొ ఈంజొ సుంకరొకయ్, మెన తుమ్‍క ఆఁవ్ సంగితసి. జోచి పాపుమ్ చెమించుప జా గెరి ఉట్ట గెలన్. కిచ్చొక మెలె, కో జోక జొయ్యి గవురుమ్ కెరనెదె గే, జోక దేముడు దాక్ కెరెదె, గని కో జోక జొయ్యి దాక్ కెరనెదె గే జోక దేముడు వెల్లొ కెరెదె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","జలె, జా దీసి ‘యేసు జోవయింక చడ చెంగిల్ వరుమ్ దెవుసు’ మెన, సగుమ్‍జిన్ ప్రెజల్ జోవయించ బాలబోదల్‍క జోతె కడ ఆన్‍తె తిల. గని జేఁవ్ జెతె తిలిసి యేసుచ సిస్సుల్ దెక కెర, జేఁవ్ బోదల్‍క కడ ఆన్ల మాన్సుల్‍క “పోన” మెన గోల కెర్ల. ");
INSERT INTO key_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","గని యేసు జా దెక కెర, జోవయింక పాసి బుకారా కెర, “బోదల్ అంచితె జెతు. జోవయింక ఆటంకుమ్ కెర నాయ్. కిచ్చొక మెలె, దేముడుచి రాజిమ్ ఇస బాలబోదల్ జల సుదల్‍చియి. ");
INSERT INTO key_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","తుమ్‍క ఆఁవ్ కిచ్చొ కచితుమ్ సంగితసి మెలె, మాన్సు గవురుమ్ నే ఉచరంతె బాలబోదల్‍చి రితిచి నముకుమ్ తెన్ దేముడుచి రాజిమ్‍తె బెదితి వరుమ్ నఙన్లెకయ్, పరలోకుమ్‍తె గెచ్చుక జయెదె” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","యూదుల్‍చొ అదికారి ఎక్కిలొ యేసుతె జా కెర, “చెంగిల్ తిలొ గురుబాబు, పరలోకుమ్‍చి రాజిమ్‍తె ఆఁవ్ కెఁయఁక తెఁయఁక జితి వాట అంక దొర్కు జంక మెలె, ఆఁవ్ కిచ్చొ కామ్ కెర్లె జయెదె?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","పుసితికయ్ యేసు, “‘చెంగిల్ తిలొసొ’ మెన అంక కిచ్చొక సంగిలది? చెంగిలొసొ దేముడు ఎక్కిలొయి, గని అన్నె కో కి చెంగిలొస నెంజితి. ");
INSERT INTO key_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","జో దిల ఆగ్నల్ మెలె తుయి జాన్సి. లంజెకమొ కెరుక జయె నాయ్, నరు అత్య కెరుక జయె నాయ్, చోరుక జయె నాయ్, అబద్దుమ్ సాచి సంగుక జయె నాయ్, అయ్యద్‍అబ్బొద్‍క గవురుమ్ దెకితె తంక అస్సె. దసచయ్” మెన జోక యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","సంగితికయ్ జో మాన్సు, “బాల తతె తెంతొ ఈంజేఁవ్ ఆగ్నల్ రితి ఆఁవ్ నిదానుమ్ కెర దెకన్‍తసి” మెన జబాబ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","జా కోడు సూన కెర యేసు, జోక, “అప్పెక తుక ఎక్కి పిట్ట అస్సె. తుచి ఆస్తి ఎత్కి తుయి విక కెర, జా వికిలి డబ్బుల్ బీద సుదల్‍క దేసు, దస్సి కెర్లెగిన పరలోకుమ్‍తె తుక ఆస్తి కలుగు జెయెదె. అన్నె అంచి తెన్ బెద అంచి పట్టి జె!” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","గని ఈంజ కోడు సూన కెర, జోక ఒగ్గర్ సొమ్సారుమ్ తిలిచి రిసొ జో మాన్సు ఒగ్గర్ విసారుమ్ జలొ. ");
INSERT INTO key_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","తెదొడి, జో మాన్సు దస్సి విసారుమ్ జలిసి దెక కెర యేసు, “సొమ్సార్లు దేముడుచి రాజిమ్‍తె గెచ్చుక జలె, కెద్ది గే కస్టుమ్ జలెకయ్ జయెదె. ");
INSERT INTO key_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","కిచ్చొక మెలె, ఇస సొమ్సార్లు దేముడుచి రాజిమ్‍తె బెదితి కంట, సూజిబొరొ వాట్ ఒంటె గెచ్చుక సుల్లు!” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","జలె, జా కోడు సూన్లస “దస్సి జలె, కో రచ్చించుప జంక జయెదె?” మెన బమ్మ జల. ");
INSERT INTO key_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","గని యేసు, “మాన్సు కెర్క నెత్తిర్లిసి కి, దేముడు జర్గు కెరుక తెరె” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","తెదొడి యేసుచ బారజిన్ బారికుల్‍తె తిలొ పేతురు మెలొ సిస్సుడు “ఈందె, అమ్‍చ గెరల్ ఎత్కి ముల దా ఆమ్ తుచి పట్టి బులితసుమ్” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","యేసు జేఁవ్ బారికుల్‍క, నిజుమి, అన్నె తుమ్‍క ఆఁవ్ కిచ్చొ కచితుమ్ మెంతసి మెలె, దేముడుచి రాజిమ్‍చి కామ్ కెర్తి రిసొ గేరు జలెకు, తేర్సిక జలెకు, అన్నొబావొక జలెకు, అయ్యస్అబ్బొస్‍క జలెకు, బోదల్‍క జలెకు కో ముల తవుల గే, ");
INSERT INTO key_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","అప్పె ఈంజ లోకుమ్‍తె ఈంజ కాలుమ్‍తె కి జోక దసచ అన్నె ఒగ్గర్ వంతుల్ రితి దొర్కు జయెదె, అన్నె, జెతి కాలుమ్‍తె, కెఁయఁక తెఁయఁక పరలోకుమ్‍తె జితి వాట జోక దొర్కు జయెదె. ");
INSERT INTO key_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","తెదొడి జేఁవ్ యెరూసలేమ్‍తె గెతె తిలి వట్టె యేసు జోచ బారజిన్ సిస్సుల్‍క పక్క కడన ఇసి మెలన్. “ఈందె, అమ్ యెరూసలేమ్‍తె గెతసుమ్, చి ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొచి రిసొ దేముడుచ కబుర్లు సంగిలస రెగిడ్లిసి ఎత్కి కచితుమ్ పూర్తి జర్గు జయెదె. ");
INSERT INTO key_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","కిచ్చొక మెలె, యూదుల్ నెంజిలసచి అత్తి అంక సొర్ప కెర దెవుల, చి అంక కొంకడుల, అంచి మరియాద కడుల, చి అంక తుంక్ర దెవుల. ");
INSERT INTO key_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","అంక కొర్డల్ తెన్ పెటుల, చి అంక మారుల, తిర్రత్‍క అన్నె జీవ్ జా ఉట్టిందె” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","గని ఇన్నెచి కిచ్చొ అర్దుమ్ కి కెరంతి నాయ్. జా అర్దుమ్ లుంకిల్ రితి తిలి, చి జో కిచ్చొచి రిసొ సంగిలొ గే నేన్ల. ");
INSERT INTO key_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","యెరూసలేమ్‍తె గెచ్చుక మెన యేసు వట్టె గెతె తా యెరికో పట్నుమ్‍క పాసి అయ్‍లి పొది, గుడ్డి జలొ మాన్సు ఎక్కిలొ వాట్ సొడి వెస తా, బిచ్చిమ్ నఙితె తిలొ. ");
INSERT INTO key_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ఒగ్గర్‍జిన్ మాన్సుల్ జా వాట్ గెతె తిలిస్‍చి అవాడ్ సూన కెర, “కిచ్చొక ఒగ్గర్ జనాబ్ ఈంజ వాట్ గెతతి?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","పుసిలె, జేఁవ్ “నజరేతు గఁవ్విచొ యేసు ఈంజ వాట్ గెతయ్” మెన జోక సంగిల, ");
INSERT INTO key_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","చి సూన, జో “ఓ యేసుప్రబు, దావీదు రానొచి సెకుమ్‍తె జెర్మిలొ రచ్చించుప కెర్తొసొ, అంచి ఉప్పిరి కన్కారుమ్ తిఁయ, అంచ చెంగిల్ కెరు!” మెన కేక్ గలన్. ");
INSERT INTO key_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","తెదొడి పుర్రెతొ ఇండితె తిలస సగుమ్‍జిన్ జో గుడ్డి మాన్సుక “తుక్లె తా” మెన గోల కెర్ల, గని జో అన్నె, “దావీదు రానొచి సెకుమ్‍తె జెర్మిలొ రచ్చించుప కెర్తొసొ, అంచి ఉప్పిరి కన్కారుమ్ తిఁయ చెంగిల్ కెరు!” మెన అగ్గెచి కంట గట్టిఙ కేకుల్ గలొ. ");
INSERT INTO key_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ఇసి జతికయ్, యేసు టీఁవ కెర, “జోక ఇత్తల్ కడ ఆన” మెన ఆడ్ర దిలన్, చి జోక జోచితె కడ ఆన్లస పాసి జెతికయ్, ");
INSERT INTO key_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“ఆఁవ్ తుక కిచ్చొ కెరుక మెన తుయి కోర్‍ప జతసి?” మెన పుసితికయ్, జో గుడ్డి మాన్సు, “ప్రబు, ఆఁవ్ దెకిత్ రితి కెరు” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","యేసు జోక, “ఈందె తుచ అంకివొ డీస్తు. అంచి ఉప్పిరి తుయి నముకుమ్ తిలి రిసొ తుయి చెంగిల్ జా అస్సిసి” మెన సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","బేగి జో మాన్సుచ అంకివొ డీసిల చి, దేముడుచి గవురుమ్ సంగ యేసుచి పట్టి గెలన్. అన్నె, ప్రెజల్ ఈంజ ఎత్కి దెక తా, జేఁవ్ కి దేముడుచి గవురుమ్ సంగిల. ");
INSERT INTO key_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","జలె, యేసు యెరికో పట్నుమ్ పెస జా పట్నుమ్ వాట్ గెచ్చ ముల్తి పొది, ");
INSERT INTO key_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ఒత్త జక్కయ్య మెలొ మాన్సు తిలన్. జో సిస్తు నఙిత సుంకర్లుచొ అదికారి, చి జో ఒగ్గర్ సొమ్సారుమ్ తిలొ. ");
INSERT INTO key_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","జలె, ‘యేసు కీసొచొగె దెకిన్‍దె’ మెన ఇస్టుమ్ జలన్, గని జో పాట్టి మాన్సు, చి యేసుచి సుట్టునంత బెర్ల జనాబ్ అడ్డు జా అస్తి. ");
INSERT INTO key_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","జాకయ్ జో కిచ్చొ కెర్లన్ మెలె, యేసు జా వాట్ గెచ్చెదె, చి జో పుర్రెతొ నిగ గెచ్చ, ఏక్ బొడ్డ రూక్‍తె వెగిలన్. ");
INSERT INTO key_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","జలె, యేసు ఒత్త పాఁవ కెర, ఉప్పిరి రూక్‍తె దెక, “జక్కయ్య, బే బేగి ఉత్రు. ఆజి ఆఁవ్ తుచి గెరి తంక అస్సె” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","దస్సి మెంతికయ్, జక్కయ్య బమ్మ తెన్ జా రూక్‍తె తెంతొ ఉత్ర జా, సర్ద తెన్ యేసుక గెరి కడన, మరియాద ఎత్కి కెర్లన్. ");
INSERT INTO key_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ఇసి జర్గు జలిసి దెక కెర ప్రెజల్ ఎత్కి కుసుమ్‍కసుమ్ లట్టబ్ల. “పాపుమ్ సుదొచి గెరి జో గోత్ గెచ్చుక కిచ్చొక?” మెల. ");
INSERT INTO key_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","జలె, యేసు ఒత్త తిలి పొది, జక్కయ్య పుర్రె జా టీఁవ ప్రబుక కిచ్చొ కోడు సంగిలన్ మెలె, “ఈందె, ప్రబు, అంచి ఆస్తితెచి ఏక్ వంతు బీద సుదల్‍క దా గెలిందె. అన్నె, డబ్బుల్‍క ఆఁవ్ కక్క మోసిమ్ కెర తిలె, జోవయింక ఆఁవ్ మోసిమ్ కెర నఙిలి కంట అన్నె అన్నె చెత్తర్ వాటల్ జోవయింక అన్నె దెయిందె” మెన ఒప్పన్లన్. ");
INSERT INTO key_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","దస్సి జతికయ్, యేసు జోక, “దేముడు పాపల్ చెమించుప కెర్తి రచ్చన ఆజి ఈంజ గెరి పాఁవ అస్సె. పాపుమ్ ఇండితె తిలె కి ఈంజొ కి అబ్రాహామ్‌చి సెకుమ్‍చొ, గెద. ");
INSERT INTO key_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","మెలె, ఆత్మక నెస గెలసకయ్ చజన జోవయించ పాపల్ తెంతొ రచ్చించుప కెరుక మెనయ్ ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ ఈంజ లోకుమ్‍తె అయ్‍లయ్”. ");
INSERT INTO key_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","యేసు సంగిలి కోడు ప్రెజల్ సూన్‍తె తిలి పొది, యెరూసలేమ్‍క పాసి జెతె తిల, చి ప్రెజల్ జేఁవ్‍చి పెట్టి కిచ్చొ మెన ఉచర్తె తిల మెలె, “యేసు అమ్‍చి యెరూసలేమ్ పట్నుమ్‍తె పాఁవిలె, దేముడుచి రాజిమ్ ఎదార్దుమ్ ఏలుప కెరుక మొదొల్ జయెదె.” మెన ఉచర్తె తిల. ");
INSERT INTO key_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","జాకయ్ యేసు జోవయింక ఏక్ టాలి సంగిలన్. “వెల్లొ మాన్సు ఎక్కిలొ తిలొ. ఈంజ దేసిమ్‍క రానొ జంక మెన, రానల్‍క టీఁవడ్తొసొ తిలి దూరి దేసిమి ఉట్ట గెచ్చ జెంక మెన, ఈంజొ బార్ జలొ. ");
INSERT INTO key_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","గని, నే గెతె అగ్గె, జోచ దెస్సుజిన్ గొత్తి సుదల్‍క బుకారా కెర, జోవయింక ఎక్కెక్లొక ఎక్కెక్ బఙర్‍చ కాసుల్ దా కెర, ‘ఆఁవ్ జెతె ఎదక ఇన్నెతెన్ బియ్యారి కెర్తె తా’ మెలన్. ");
INSERT INTO key_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","గని జోవయించ ప్రెజల్ జోక ఒగ్గర్ విరోదుమ్ జా అస్తి, చి ‘ఈంజొ మాన్సు అమ్‍చి ఉప్పిరి ఏలుప కెరుక మెలె, అమ్‍క ఎద్గరె ఇస్టుమ్ నాయ్’, మెన జో మాన్సుచి పట్టి కబుర్ తెద్రయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“గని, జో మాన్సు రానొ జా బుల అయ్‍లన్, చి జో డబ్బుల్ దా తిల గొత్తి సుదల్ బియ్యారి కెర కెద్ది లాబుమ్ కెర అస్తి సూనుక మెన జేఁవ్‍క బుకార్లన్. ");
INSERT INTO key_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","తొలితొచొ జా కెర, రానొచి పుర్రెతొ టీఁవిలన్ అన్నె, ‘బాబు, తుయి దిలి బఙార్ కాసుక అన్నె దెస్సు బఙార్ కాసుల్ లాబుమ్ దొర్కు జా అస్సె’ మెలన్, చి ");
INSERT INTO key_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‘బొల్లొయ్ కెర్లది, తుయి చెంగిలొ గొత్తి సుదొ. ఇదిలిసి కామ్ దెతికయ్ తుయి నిదానుమ్ కెర్లది, చి తుయి దెస్సు పట్నల్‍చి ఉప్పిరి ఏలుప కెరుక మెన తుక ఆఁవ్ అదికారుమ్ దెతసి’ మెన రానొ సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","తెదొడి అన్నెక్లొ గొత్తి సుదొ అయ్‍లొ, అన్నె, ‘బాబు, తుయి దిలి బఙార్ కాసుక అన్నె పాఁచ్ బఙార్ కాసుల్ లాబుమ్ దొర్కు జా అస్సె’ మెలన్, చి ");
INSERT INTO key_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","‘బొల్లొయ్ కెర్లది, తుయి చెంగిలొ గొత్తి సుదొ, పాఁచ్ పట్నల్‍చి ఉప్పిరి ఏలుప కెరుక మెన తుక ఆఁవ్ అదికారుమ్ దెతసి’ మెన రానొ సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“తెదొడి అన్నెక్లొ గొత్తి సుదొ అయ్‍లొ అన్నె, ‘బాబు, ఉంద, తుచి బఙార్ కాసు. ఇన్నెక మూటొ బంద తిఁయ దిలయ్’. ");
INSERT INTO key_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","కిచ్చొక మెలె, తుయ్ ‘కన్కారుమ్ నెంజిలొసొ’ మెన బిలయ్. తుయి కామ్ నే కెర్లిసి నఙన్‍తసి, తుయి నే ఉంపిలిసి లాయితసి మెలన్. ");
INSERT INTO key_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","జలె, జోక జో రానొ కిచ్చొ జబాబ్ దిలన్ మెలె, ‘తుయి గర్చొ గొత్తి సుదొ! తుయి సొంత సంగిలిసి తుకయ్ నేరిమ్ వయడ్తయ్. అంక కన్కారుమ్ నెంజిలొసొ, సొంత కామ్ నే కెర్లిసి నఙితొసొ, సొంత నే ఉంపిలిసి లాయితొసొ’ మెన తుయి జాన్సి. ");
INSERT INTO key_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","జలె, ‘అంచి డబ్బుల్ కిచ్చొక సావుకర్‍తె జవుస్ తిసి నాయ్? సావుకర్‍తె జవుస్ తితది జలె, ఆఁవ్ బుల అయ్‍లి పొది సర్ద తెన్ వడ్డి నఙన్‍తయ్’ మెన జో గర్చొ గొత్తి సుదొక సంగ కెర, ");
INSERT INTO key_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","పాసి టీఁవ తిల మాన్సుల్‍క, జా బఙార్ కాసు జోతె నఙన, దెస్సు బఙార్ కాసుల్ తిలొ జో అన్నెక్లొ గొత్తి సుదొక దాస, మెలన్. ");
INSERT INTO key_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","జో దస్సి మెంతికయ్, జేఁవ్ తిల గొత్తి సుదల్ గోస జా, గని బాబు, జోక దెస్సు బఙార్ కాసుల్ అస్తి! జోక అన్నె కాసుల్ కిచ్చొక దెంక! మెల. ");
INSERT INTO key_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","గని జో రానొ కిచ్చొ సంగిలన్ మెలె, ‘తుమ్‍క కిచ్చొ మెంతసి మెలె, కక్క తిలె, జోక అన్నె దెంక జయెదె. కక్క నెంజిలె, జోక తిలిసి కి జోతె తెంతొ అన్నె కడ గెలుక జయెదె. ");
INSERT INTO key_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","జలె, అంక అమ్‍చి ఉప్పిరి జో ఏలుప కెరుక మెలె, అమ్‍క ఎద్గరె ఇస్టుమ్ నాయ్’ మెల అంచ విరోదుమ్ సుదల్‍క కిచ్చొ కెరుక? జోక ఇన్నె కడ ఆన, చి అంచి మొక్మె కండ గెల మెన రానొ సంగిలన్” మెన యేసు టాలి సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","యేసు ఈంజ టాలి సంగ కేడవ కెర, యెరూసలేమ్‍తె గెచ్చుక మెన జోచ సిస్సుల్‍చి పుర్రె గెలన్. ");
INSERT INTO key_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","జలె, బేత్పగే చి బేతనియ మెల గఁవ్వొక పాసిచి ఒలీవ మెంతి మెట్టయ్ పాఁవిలి పొది, యేసు జోచ సిస్సుల్‍తె దొగులక పాసి బుకారా కెర, ");
INSERT INTO key_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“తుమ్‍చి మొక్మె తిలి గఁవ్వి తుమ్ పెస, చి గఁవ్వి పెసిలదు మెలె, బంద తిలి ఏక్ గాడ్దె పిల్ల బేగి తుమ్‍క డీసెదె. జాచి ఉప్పిరి అప్పె ఎద కో కి వెగుక నేతయ్. జాక యిప కెర ఉదడ ఆన. ");
INSERT INTO key_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","అన్నె, ‘కిచ్చొక యిపితసు?’ మెన తుమ్‍క కో జవుస్ పుసిలె, తుమ్ కిచ్చొ మెన మెలె, ‘ఇన్నెతెన్ ప్రబుక కామ్ అస్సె’” మెన సంగ, మెన యేసు జేఁవ్ దొగుల సిస్సుల్‍క సంగ జా గఁవ్వి తెద్రయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","జలె, జో తెద్రయ్‍ల దొగుల గెచ్చ కెర, యేసు సంగిల్ రితి జలి మెన దెకిల. ");
INSERT INTO key_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","జేఁవ్ జా గాడ్దె పిల్లక యిపుక దెర్తికయ్, “గాడ్దె పిల్లక కిచ్చొక యిపితసు?” మెన జేఁవ్‍చ సావుకర్లు పుసిల. ");
INSERT INTO key_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","పుసితికయ్, “ఇన్నెతెన్ ప్రబుక కామ్ అస్సె” మెల. ");
INSERT INTO key_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","జలె, జేఁవ్ సిస్సుల్ జా గాడ్దె పిల్లక యేసుతె ఉదడ ఆన కెర, జోవయించ దుప్పట్లు గాడ్దెచి ఉప్పిరి గల దా, యేసుక వెగడ్ల, ");
INSERT INTO key_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","అన్నె, యెరూసలేమ్‍తె జో గెతె తతికయ్, జో గెతి వట్టె జనాబ్ జోవయించ పాలల్ అంతిర్ల. ");
INSERT INTO key_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","అన్నె, యేసు జా ఒలీవ మెట్టచి కొన్స జీన యెరూసలేమ్ పట్నుమ్ పక్క ఉత్ర పాసి పాఁవిలి పొది, జోక నంపజల ప్రెజల్ ఎత్కిజిన్ సర్దసంతోసుమ్ జా గట్టిఙ అవాడ్ కెరన, ");
INSERT INTO key_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“దేముడుచి నావ్ తెన్ జెతొ రానొక జొఒర, జొఒర! పరలోకుమ్‍తె సేంతుమ్, చి ఎత్కిచి ఉప్పిర్ టాన్‍తె తిలొసొక జొఒర!” మెన కేకుల్ గల, యేసుచి అత్తి కెర్ల జేఁవ్ దెకిల కమొచి రిసొ దేముడుచి గవురుమ్ సంగితె తిల. ");
INSERT INTO key_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","తెదొడి జేఁవ్ జనాబ్‍తె బెద తిల సగుమ్‍జిన్ పరిసయ్యుల్ యేసుక “గురుబాబు, తుచ సిస్సుల్ తుక్లె తతి రితి సంగు” మెలె, ");
INSERT INTO key_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","గని యేసు జేఁవ్‍క కిచ్చొ సంగిలన్ మెలె, “తుమ్‍క ఆఁవ్ కిచ్చొ మెంతసి మెలె, ఈంజేఁవ్ తుక్లె తత్త జలె, ఈంజేఁవ్ పత్రల్ కేక్ గలుల” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","యేసు యెరూసలేమ్ పట్నుమ్‍క అన్నె పాసి జా జాక దెక కెర, జాచి రిసొ ఏడ్లన్. ");
INSERT INTO key_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","కిచ్చొ మెన ఏడ్లన్ మెలె, “ఓ యెరూసలేమ్, దేముడు తెన్ కీసి సేంతుమ్ జంక తుయి ఆజి జాన్‍తతి జలె, చెంగిల్ తత్తి! గని నాయ్, అప్పె జా అర్దుమ్ ఎత్కి తుమ్‍క లుంకిల్ రితి అస్సె. ");
INSERT INTO key_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ఓ యెరూసలేమ్ పట్నుమ్, తుయి ఒగ్గర్ స్రెమల్ సేడ్తి ఏక్ కాలుమ్ జెతయ్. జేఁవ్ దీసల్‍క తుక కిచ్చొ జయెదె మెలె, తుచ విరోదుమ్ సుదల్ తుచి సుట్టునంత మత్తి డిబ్బల్ వెగడ, తుచి సుట్టునంత బెర జా, ఎత్కి పక్కల్ తెంతొ పెల జెవుల. ");
INSERT INTO key_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","తుచ కోటల్, తుచ గెరల్ పూర్తి సేడవ గెల కెర, తుచి తెడి తిల మాన్సుల్ ఎత్కిజిన్‍క జేఁవ్ మారుల, చి తుచితె పత్తుర్‍చి ఉప్పిరి పత్తురు తతి రితి ములితి నాయ్. కిచ్చొక మెలె, దేముడు తుక రచ్చించుప కెర్తి వాటు ఆఁవ్ దెకయ్‍లయ్, గని చినుస్ నాయ్” మెన యేసు యెరూసలేమ్‍చి రిసొ ఏడ గెలన్. ");
INSERT INTO key_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","యేసు పట్నుమ్‍తె పాఁవ కెర, దేముడుచి గుడితె పెస కెర, ఒత్త సామన్ వికితసక ఉదడ గెలుక దెర, ");
INSERT INTO key_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","జోవయింక, “‘అంచి గేరు ప్రార్దన కెర్తి గేరు, జా దస్సే తవుస్’ మెన దేముడుచి కొడొతె రెగ్డవ అస్సె, గని తూమ్ చోర్లు జితొ రితొ గేరు జతి రితి జాక మార్సుప కెర అస్సుస్.” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","జలె, జా దొరతి యేసు రోజుక దేముడుచి గుడితె బోదన కెర్తె తిలన్, అన్నె వెల్లెల పూజర్లు, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస చి, యూదుల్‍చ వెల్లెల మాన్సుల్ జోక మారుక వాట్ చజితె తిల, గని ");
INSERT INTO key_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ప్రెజల్ ఎత్కి రోజుక జెతె తా జోవయించ కొడొ ఒగ్గర్ సర్ద తెన్ సూన్‍తె తిల, చి నెతిర్ల. ");
INSERT INTO key_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","తెదొడి ఏక్ దీసి, యేసు దేముడుచి గుడితె ప్రెజల్‍క బోదన కెర్తె తా సుబుమ్ కబుర్ సంగితె తతికయ్, వెల్లెల పూజర్లు, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస చి అన్నె సగుమ్‍జిన్ వెల్లెల మాన్సుల్ జోతె జాఁ కెర, ");
INSERT INTO key_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“తుయి కెర్త కమొ కెరుక, తుయి బోదన కెరుక, తుక కిచ్చొ అదికారుమ్ అస్సె? కొన్సొ తుక అదికారుమ్ దిలన్?” మెన జోక గోల కెర్ల. ");
INSERT INTO key_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","యేసు జోవయింక కిచ్చొ జబాబ్ దిలన్ మెలె, “ఆఁవ్ కి తుమ్‍కయ్ ఏక్ కోడు పుసిందె. జలె, అంక తుమ్ సంగ. ");
INSERT INTO key_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","యోహాను బాప్తిసుమ్ దెతె తిలిస్‍చి అదికారుమ్ కేనె తెంతొ చి? పరలోకుమ్ తెంతొ చి గే, మాన్సు తెంతొ చి గే, తుమ్ సంగ” మెన వెల్లెల మాన్సుల్‍క యేసు పుసిలన్. ");
INSERT INTO key_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","దస్సి పుసితికయ్, జేఁవ్ వెల్లెల మాన్సుల్ కీసి జల మెలె, ఎక్కిలొ తెన్ ఎక్కిలొ బమ్మ తెన్ లట్టబన, ఇసి మెంతె తిల, “పరలోకుమ్ తెంతొ చి మెన అమ్ సంగిలెగిన, ‘దస్సి జలె, తుమ్ కిచ్చొక జోక నంప కెర్సు నాయ్?’ మెన ఈంజొ అమ్‍క సంగెదె. ");
INSERT INTO key_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","గని, ‘మాన్సు తెంతొ చి’ మెన సంగిలె, జనాబ్ అమ్‍క పత్రల్ తెన్ పెట మారుల. యోహానుక ‘అమ్‍చొ దేముడుచ కబుర్లు సంగితొసొ కచితుమ్ తిలొ’ మెన జేఁవ్ జనాబ్‍క నముకుమ్.” ");
INSERT INTO key_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","జాకయ్ జేఁవ్ యేసుక కిచ్చొ జబాబ్ దిలి మెలె, “జా అదికారుమ్ కేనె తెంతొ గే నేనుమ్” మెల. ");
INSERT INTO key_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","జేఁవ్ దస్సి సంగితికయ్, యేసు జోవయింక, “దస్సి జలె, కేన్ అదికారుమ్‍క ఆఁవ్ అంచ కమొ కెర్తసి గే, ఆఁవ్ తుమ్‍క సంగి నాయ్” మెన సంగ జేఁవ్‍క ముద్దొ కెర్లన్. ");
INSERT INTO key_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","తెదొడి యేసు ప్రెజల్‍క ఈంజ ఏక్ టాలి సంగుక దెర్లన్. “ఏక్ మాన్సు ద్రాచ తోట రోవడ కెర, రకితసక నిసాన, జేఁవ్‍క జా తోట గుత్త దా, ఇదిల్ ఒగ్గర్ దీసల్ వేర దేసిమి గెచ్చ తంక మెన, ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","జలె, పంటొ పికిలి పొది, ‘సమయుమ్ జా అయ్‍లి’ మెన, జేఁవ్ గుత్త నఙిలసతె జా తోటచి పంటొ ఏక్ వాట నఙ ఆన్‍తి రిసొ, గొత్తి సుదొ ఎక్కిలొక ఎజొమాని తెద్రయ్‍లన్. గని జో గొత్తి సుదొ ఒత్త పాఁవితికయ్, గుత్త నఙిల జేఁవ్ రకిత మాన్సుల్ జోక పెట గెల కెర, కిచ్చొ నే దెతె ఉదడ్లొ. ");
INSERT INTO key_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","“ఒత్త తెంతొ, అన్నెక్లొ గొత్తి సుదొక జో ఎజొమాని తెద్రయ్‍లన్, గని జేఁవ్ రకితస జోక కి పెట కెర జోచి మరియాద కడ, జోక కి కిచ్చొ నే దెతె ఉదడ గెల. ");
INSERT INTO key_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ఒత్త తెంతొ అన్నెక్లొ గొత్తి సుదొక ఎజొమాని తెద్రయ్‍లన్ చి, ఇన్నెక కి బలే అల్లర్ కెర గంటివొ గాయిమ్‍లు కెర దా ఉదడ గెల. ");
INSERT INTO key_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“తెదొడి జా ద్రాచ తోటచొ ఎజొమాని, ‘ఆఁవ్ కిచ్చొ కెర్లె జయెదె? నాయ్, గెద, ఇసి కెరిందె. అంచొ ప్రేమ తిలొ పుత్తుక తెద్రయిందె. జోకయ్ మరియాద దెకుల, కిచ్చొగె’ మెన ఆకర్‍క జోకయ్ తెద్రయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","జేఁవ్ తోట గుత్త నఙిలస జోక దెక కెర, ‘ఇన్నెకయ్ అబ్బొస్‍చి దనుమ్ కలుగు జయెదె. అల్లె, ఇన్నెక మారుమ, చి ఇన్నెక కలుగు జతి వాట అమ్‍కయ్ దొర్కు జయెదె’ మెన జోవయింక జెఁవ్వి లట్టబన, ");
INSERT INTO key_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","జో ఎజొమానిచొ పుత్తుస్‍క దెర కెర, జోక తోట తెంతొ పెలవ న కెర, బయిలె మార గెల. జలె, జేఁవ్ ఎజొమానిచొ పుత్తుస్‍క దస్సి కెర్లి రిసొ, జా తోటచొ ఎజొమాని జోవయింక కిచ్చొ కెరెదె? ");
INSERT INTO key_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","కిచ్చొ కెరెదె మెలె, జాఁ కెర, జేఁవ్ గుత్త నఙిలసక మొరవ కెర, జా తోట వేర మాన్సుల్‍క గుత్త దెయెదె” మెన యేసు సంగిలన్. ప్రెజల్ జాక సూన కెర, దస్సి కెఁయఁక జర్గు జంక జయె నాయ్! మెల. ");
INSERT INTO key_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","గని యేసు జోవయించి పక్క పసుల దెక, “జలె, దేముడు దేముడుచ కొడొతె రెగ్డయ్‍లి ఏక్ కోడు సంగిందె, జాచి అర్దుమ్ కిచ్చొ గే తుమ్ ఉచర. ‘కామ్‍క నెంజె’ మెన గేరు బందిలస జా ఏక్ పత్తురు పిట్టవుక మెన ఉచర్లె కి, జయ్యి పత్తురు గేరుక బోడిపత్తుర్ జలన్. మెన రెగిడ్లి కోడు. ");
INSERT INTO key_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ఈంజొ పత్తుర్‍చి ఉప్పిరి కో సేడుల గే, జేఁవ్ బద్దల్ జా గెచ్చుల, గని కచి ఉప్పిరి ఈంజొ పత్తుర్ సేడెదె గే, జోక బీడవ గెలెదె.” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","పంటొ నఙుక గెలసక మార్ల సంగిలస మెన అమ్‍చి రిసొ యేసు సంగితయ్ మెన మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస చి వెల్లెల పూజర్లు చినన కోపుమ్ జా, జోక జయ్యి గడియయ్ దెరుక ఉచర్ల, గని ‘ప్రెజల్ కోపుమ్ జా అల్లర్ కెరుల’ మెన, జోవయింక బియ్ కెర, తుక్లె తిల. ");
INSERT INTO key_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","జలె, ‘వాట్ అయ్‍లె యేసుక దెరుమ్‍దె’ మెన మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస చి వెల్లెల పూజర్లు దెకితె తిల చి, సగుమ్‍జిన్‍క లంచుమ్ దా కెర, “తుమ్ సత్తిమ్‍క పుసిల్ రితి డీస” మెన, జేఁవ్ మాన్సుల్ యేసుక ఏక్ కోడు పుసితి రితి తెద్రయ్‍ల. జోవయించి ఉద్దెసుమ్ కిచ్చొ మెలె, ‘యేసు కిచ్చొ జవుస్ తప్పు సంగిలె, జోక దెర, రోమ్ దేసిమ్‍చొ అదికారితె సొర్ప కెర దెంక జయెదె చి, యేసుచి రిసొ సూన, సిచ్చ దెయెదె’ మెన కోర్‍ప జతతి. ");
INSERT INTO key_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","జలె, జేఁవ్ మాన్సుల్ యేసుతె జా కెర, “గురుబాబు, తుయి సత్తిమ్ లట్టబ, సత్తిమ్ బోదన కెర్తసి మెన. తుయి మొకమాటుమ్ నే దెకితె, వెల్లెల మాన్సుల్ కిచ్చొ ఉచరుల గే నే బితె, దేముడు దెకయ్‍లి వాట్‍చి రిసొ సత్తిమ్ తెన్ బోదన కెర్తసి మెన జానుమ్” మెన పులయ్‍తి రితి సంగ, ");
INSERT INTO key_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","అన్నె, “రోమ్ దేసిమ్‍చి ప్రబుతుమ్‍చొ కైసర్ రానొక అమ్ సిస్తు దెంక నాయిమ్ గే నాయ్ గె?” మెన పుసిల. ");
INSERT INTO key_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","గని యేసు జోవయించి ఉచరన్ల, జోవయించి ఉప్రమెన్సు చిన కెర, ");
INSERT INTO key_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“ఏక్ వెండి కాసు అంక దెకవ” మెలన్, చి జేఁవ్ ఆన దెకయ్‍తికయ్, “ఇన్నెతె కచి బొమ్మ కడ అస్తి? కచి నావ్ డీస్తయ్?” మెన పుసిలన్ చి, “కైసర్ రానొచి” మెన జనాబ్ సంగిల. ");
INSERT INTO key_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","యేసు జోవయింక, “దస్సి జలె, కైసర్‍క దెతిసి కైసర్‍క, దేముడుక దెతిసి దేముడుకయ్ తుమ్ దాస.” మెన, జోవయింక జబాబ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","దస్సి, జో సంగిలిస్‍తె తప్పు నాయ్ చి, ప్రెజల్‍చి మొక్మె జో కిచ్చొ తప్పు సంగితిస్‍చి రుజ్జు దెకవుక నెతిర్ల, చి దెరుక నెతిర్ల. గని జో దిలి జబాబ్‍చి తెల్విక ఆచారిమ్ జా, తుక్లె జల. ");
INSERT INTO key_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","పడ్తొ, ‘మొర గెలెగిన అన్నె జీవ్ జంక నెంజె, అన్నెక్ లోకుమ్‍తె గెచ్చుక నెంజె’ మెన ప్రెజల్‍క సికయ్‍త సద్దూకయ్యులు సగుమ్‍జిన్ యేసుతె జాఁ కెర, ");
INSERT INTO key_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“గురుబాబు, ఈందె, ‘ఎక్కిలొచొ అన్నొసి పెండ్లి జా బోదల్ నెంతె మొర గెలెగిన, జో బావొసి అన్నొస్‍చి తేర్సిక ఆనన, అన్నొస్‍చి నావ్ తెన్ బోదల్ పాయిక అస్సె’ మెన, మోసే పూర్గుమ్‍చొ అమ్ యూదుల్‍చి రిసొ రెగ్డ అస్సె. ");
INSERT INTO key_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","జలె, సత్తుజిన్ బావుడ్లు తిల. జోవయింతె తొల్సుర్ తెర్ని ఆనన, బోదల్ నెంతె మొర గెలన్. ");
INSERT INTO key_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","జో మాన్సుచి పట్టి జెర్మిలొసొ కి జాక ఆనన, బోదల్ నెంతె మొర గెలన్. ");
INSERT INTO key_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","జోచి పట్టిచొ, జోచి పట్టిచొ, దస్సి వర్స తెన్ సత్తుజిన్ మొత్తుమ్ జా తెన్ పెండ్లి జా సంతానుమ్ నెంతె మొర గెల. ");
INSERT INTO key_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ఆకర్‍క జా తేర్‍బోద కి మొర గెలి. ");
INSERT INTO key_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","జాకయ్, మొర గెలస అన్నె జీవ్ జతి పొదిక, జా తేర్‍బోద జోవయింతె కక్క తేర్సి జా తయెదె? జేఁవ్ సత్తుజిన్ వర్స తెన్ జా తెన్ పెండ్లి జల, గెద” మెన యేసుక పుసిల. ");
INSERT INTO key_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ఇసి జతికయ్, యేసు జేఁవ్ సద్దూకయ్యుల్‍క, “ఈంజయ్ కాలుమ్‍చ మాన్సుల్ పెండ్లి జా పుత్తర్సుల్‍క పెండ్లివొ కెర్తతి, ");
INSERT INTO key_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","గని ‘అన్నె జీవ్ జా పరలోకుమ్‍తె జా కాలుమ్‍క జితు’ మెన కక్క దేముడు విలువ దెకెదె గే, ఒత్త పెండ్లివొ నెంతె దస్సే తవుల. ");
INSERT INTO key_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","కిచ్చొక మెలె, ఒత్త గెలె దూతల్ కీసి మొర్తి నాయ్ గే, దస్సి, ఈంజేఁవ్ కి కెఁయఁక కి అన్నె మొర్తి నాయ్. అన్నె, జేఁవ్ మొర గెచ్చ అన్నె జీవ్ జలి రిసొ, జేఁవ్ దేముడుచ పుత్తర్లు జా అస్తి. ");
INSERT INTO key_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“జలె, ‘మొర గెలస అన్నె జీవ్ జవుల’ మెన రూకు తెడి జా ఆగి లగితె తిలిస్‍చి రిసొ జో రెగిడ్లిస్‍తె అమ్‍చొ మోసే పూర్గుమ్‍చొ కి దెకయ్‍తయ్. కేన్ కోడుతె మెలె, దేముడుచి రిసొ ‘అబ్రాహామ్‍చొ దేముడు, ఇస్సాకుచొ దేముడు, చి యాకోబుచొ దేముడు’ మెన ఏక్‍తె సంగితయ్, గెద. ");
INSERT INTO key_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","జలె జేఁవ్ మొర్ల పూర్గుల్‍క మోసేచి కాలుమ్ ఎద కి జో దేముడు తా కామ్‍క అయ్‍లిస్ తెన్ జేఁవ్ అన్నెక్ లోకుమ్‍తె గెచ్చ జివ్వి అస్తి మెన రుజ్జు జతయ్. రితి మొర గెలసక నాయ్, గని జీవ్ తిలసకయ్ జో దేముడు తయెదె. కో దేముడుచి రిసొ జిఁయ మొర అస్తి గే, జోవయించి రిసొ జితతి” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","జలె, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస కి ఒత్త తిల. జేఁవ్, జలె, పరిసయ్యుల్ తెన్ బెదితస జవుల చి, మొర్లె జీవ్ జంక జయెదె, అన్నెక్ లోకుమ్‍తె గెచ్చుక జయెదె మెన నంప కెర్తతిచి రిసొ “గురుబాబు, తుయి చెంగిల్ జబాబ్ దిలది!” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ఒత్త తెంతొ జోవయింతె అన్నె కో కి యేసుక కిచ్చొ పుసుక కి దయిరిమ్ జతి నాయ్. ");
INSERT INTO key_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","తెదొడి యేసు జోవయింక ఇసి మెలన్. “‘దేముడు తెద్రయ్‍లొ రచ్చించుప కెర్తొసొ జతొ క్రీస్తు అమ్‍చొ దావీదు రానొచి సెకుమ్‍తె జెర్మ జోక పుత్తుసి జయెదె’ మెన కీసి సంగుక జతయ్?” మెన, అన్నె, ");
INSERT INTO key_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","కీర్తనల్‍తె దావీదు, “తుచ విరోదుమ్ సుదల్ తయె సుఁదితి పొద్రొ జతి రితి ఆఁవ్ కెర్తి ఎది ఎద తుయి అంచి ఉజెతొ పక్కయ్ వెస తా అంచి తెన్ ఏలుప కెరు, మెన ప్రబు అంచొ ప్రబుక సంగిలన్ మెన రెగిడ్లన్. ");
INSERT INTO key_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","దస్సి, దావీదు రానొ క్రీస్తుక ‘ప్రబు’ మెన సంగితయ్ జలె, జో క్రీస్తు కీసి జోక పుత్తుసి జయెదె? తుమ్ ఉచర” మెన ఒత్త తిలసక యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ప్రెజల్ ఎత్కి సూన్‍తె తతికయ్, యేసు జోచ సిస్సుల్‍క ఇసి మెలన్. ");
INSERT INTO key_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“దిగిల సూటిచ పాలల్ గలన బులిత గవురుమ్ ఉచరంత అమ్‍చ మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తసచి రిసొ తుమ్ జాగర్త తెన్ తా. జేఁవ్ సంతవీదులె టీఁవ మాన్సుల్ ఎత్కి అమ్‍క జొకర్తు మెన కోర్‍ప జతతి. సబ గెరలె ముక్కిమ్‍చ టాన్లుతె, విందుల్‍తె ముక్కిమ్‍చ టాన్లుతె వెసుక కోర్‍ప జతతి. ");
INSERT INTO key_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","జేఁవ్ మోసిమ్‍లు కెర రండెల్ మాన్సుల్‍చ గెరల్ విక కతతి, అన్నె ఉప్రమెన్సుక దిగిల ప్రార్దనల్ కెర్తతి. దస్సి, జోవయించి పాపుమ్ ఒగ్గరి, చి వెల్లి సిచ్చ సేడుల” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","దేముడుచి గుడితె డబ్బుల్ దెతి కానుక పెటె ఏక్ తయెదె. దేముడుచి కామ్‍క మెన మాన్సుల్ ఒత్త డబ్బుల్ గలుల. జలె, యేసు జా పక్క అంకి గల, సొమ్సార్లు జోవయించి డబ్బుల్ జా పెట్టెతె గల్తె తిలిసి దెకిలన్. ");
INSERT INTO key_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","తెదొడి ఎద్గరె నెంజిలి రండెల్ మాన్సు జా డబ్బుల్ దెతి కానుక పెట్టెతె దొన్ని ఇదుల రాగి కాసుల్ గలిలిసి యేసు దెకిలన్. ");
INSERT INTO key_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","జా దెక కెర, యేసు, “నిజుమి తుమ్‍క ఆఁవ్ కిచ్చొ మెంతసి మెలె, జేఁవ్ సొమ్సార్లు ఎత్కిజిన్ మొత్తుమ్ దిలిస్‍చి కంట ఈంజ ఎద్గరె నెంజిలి రండెల్ మాన్సు ఒగ్గర్ దా అస్సె. ");
INSERT INTO key_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","జోవయించి ఎదివాట్ సొమ్సారుమ్ తెంతొ సేంసిలిసి జేఁవ్ దా అస్తి. ఇన్నెక, మాత్రుమ్, కిచ్చొ నెంజిలె కి, కలుగు జలిసి ఎత్కి దాఁయి గెల అస్సె” మెన యేసు సంగిలొ. ");
INSERT INTO key_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","దేముడుచి గుడి “చెంగిల్ పత్రల్ తెన్ కెద్ది సూటి తెయార్ కెర అస్తి, కెద్ది తమ్మస వస్తువల్‍క సూటి కెర అస్తి!” మెన సిస్సుల్ యేసుక దెకయ్‍ల. ");
INSERT INTO key_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","యేసు, “తుమ్ దెకితిసి ఎత్కి జలె, సగుమ్ దీసల్ గెలె కీసి జయెదె మెలె, అప్పె పత్తుర్‍చి ఉప్పిరి పత్తురు దొంత్రల్ తిలె కి, ఎక్కి జలెకు నే టీఁవితె గలి జతి దీసి జెయెదె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","తెదొడి యేసుక, జోచ బారజిన్ సిస్సుల్ “గురుబాబు, తుయి సంగిలిసి కెఁయఁక జర్గు జయెదె? ఈంజ జర్గు జతి పొది అయ్‍లి మెలె, అమ్ చినితి రిసొ కిచ్చొ గుర్తు తయెదె?” మెన పుసిల. ");
INSERT INTO key_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","జో జోవయింక, “కొన్సొ జలెకు తుమ్‍క అంచి రిసొ మోసిమ్ నే కెర్తి రితి తుమ్ జాగర్త దెకన. కిచ్చొక మెలె, ‘ఆఁవ్వి క్రీస్తు’ మెనన జలెకు. క్రీస్తు జెతి సమయుమ్ జా అయ్‍లి మెన జలెకు, కో కో మాన్సుల్ బార్ జవుల. జోవయించి పట్టి తుమ్ గెచ్చ నాయ్. ");
INSERT INTO key_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","అన్నె, దేసిమ్‍చి ఉప్పిరి దేసిమ్ యుద్దుమ్ కెర్తిస్‍చి రిసొ జలెకు, ఏక్ దేసిమ్‍చ జోవయించి ఉప్పిరి జెఁవ్వి యుద్దుమ్ కెర్తిస్‍చి రిసొ జలెకు తుమ్ సూన్లె, తుమ్ బమ్మ జా నాయ్. దసచ ఎత్కి జర్గు జంక అస్సె, గని ఈంజ ఉగుమ్ తెద్ది బేగి పూర్తి జయె నాయ్” మెన సంగ కెర ");
INSERT INTO key_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","జోవయింక అన్నె, దేసిమ్‍చి ఉప్పిరి దేసిమ్, రాజిమ్‍చి ఉప్పిరి రాజిమ్ యుద్దుమ్‍క టీఁవ్‍ల. ");
INSERT INTO key_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","వేర వేరతె బూకంపల్ కరువుల్ చి, కిచ్చొ కిచ్చొ కస్టల్ నస్టల్ జర్గు జవుల చి, ఆగాసుమ్ తెంతొ జెత ఒగ్గర్ బయిమ్ దెత వెల్లొ గుర్తులు జెవుల. ");
INSERT INTO key_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“గని ఈంజ ఎత్కి జర్గు నే జతె అగ్గె, మాన్సుల్ తుమ్‍క దెర, జోవయించి కోపుమ్‌క తుమ్‍క కిచ్చొ కిచ్చొ అల్లర్ కెర, ‘అదికారుల్ జోవయింక సిచ్చ కెర్తు’ మెన అమ్‍క యూదుల్‍చ సబ గెరలె జోవయించి అత్తి సొర్ప కెర దెవుల, చి తుమ్‍క జేల్‍తె గల దెవుల. అంచి సేవ తుమ్ కెర్తసుచి రిసొ, రానల్‍చి మొక్మె అదికార్లుచి మొక్మె తుమ్ తీర్పు జతి రిసొ సిచ్చల్ జతి రిసొ తుమ్‍క టీఁవడుల. ");
INSERT INTO key_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","జేఁవ్ దస్సి కెర్తి పొదిక, అంచి రిసొ తుమ్ సాచి సంగితె. ");
INSERT INTO key_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","తుమ్ అప్పె మెన్సుతె కిచ్చొ బుద్ది దెరన మెలె, మాన్సుల్‍చి మొక్మె తుమ్ పరిచ్చ జంక జలె, జా నే జతె అగ్గె, జేఁవ్ పరిచ్చ కెర్లె కిచ్చొ జబాబుల్ దెమ్‍దె?, మెన తుమ్ ఉచరంతె తా నాయ్. ");
INSERT INTO key_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","కిచ్చొక మెలె, తుమ్‍క చోండి దెయిందె, తుమ్‍క దొర్కు జలి బుద్ది గ్యానుమ్ దెయిందె. తుమ్‍చ జబాబుల్‍చి తెల్విచి ఉప్పిరి జేఁవ్ అల్లర్ కెర్తసతె వెల్లెల మాన్సుల్‍తె కో జీనుక నెతిర్తి, తుమ్‍క కిచ్చొ జబాబ్ సంగుక నెతిర్తి. ");
INSERT INTO key_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“అదికారుల్‍చి అత్తి తుమ్‍క సొర్ప కెర దెతసతె సగుమ్‍జిన్ కొన్స జవుల మెలె, తుమ్‍చ అయ్యదింసి, అన్నొబావొదింసి, తుమ్‍చ బందుగులు, తుమ్‍చ సినేతులు. అన్నె, తుమ్‍తె సగుమ్‍జిన్‍క మాన్సుల్ మారుల. ");
INSERT INTO key_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","అన్నె, తుమ్ అంచి నావ్ తెన్ బులితె తత్తెచి రిసొ, ఎతివాట్‍జిన్ తుమ్‍క విరోదుమ్ జవుల. ");
INSERT INTO key_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","గని, పరలోకుమ్‍తె తుమ్ జెతిస్‍క ఉచర్లె, తుమ్‍చ సెండివాడల్‍తె ఎక్కి కి నాసెనుమ్ జా గెచ్చె నాయ్, ఈంజ లోకుమ్‍తె ఈంజ ఆఁగ్‍క మార్లె కి, తుమ్ పరలోకుమ్‍తె గెతిసి అడ్డు కెరుక నెతిర్తి. ");
INSERT INTO key_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","తుమ్ ఎక్కి నిదానుమ్ ఓర్సుప జా, చి పరలోకుమ్‍తె గెతి రితి తుమ్‍చి జీవు దొర్కు కెరన తా. ");
INSERT INTO key_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“గని యెరూసలేమ్ పట్నుమ్‍క సయ్‍న్యుమ్ ఒండి సుట్టునంత బెర తతిసి తుమ్ కెఁయఁక దెకితె గే, ‘పట్నుమ్ పాడ్ జంక తిలి సమయుమ్ పాఁవ జా అస్సె’ మెన చినితె. ");
INSERT INTO key_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","జా గుర్తు దెకిలె, తుమ్‍చితె కో ఈంజ యూదయ ప్రదేసిమి తవుల గే, చట్కున డొంగ్రలె ఉట్ట నిగుతు చి, పట్నుమ్‍చి తెడి తిలస బార్ జా ఉట్ట గెతు, చి పట్నుమ్ ఒత్తల్‍తొచి బయిలె గఁవ్విలె జవుస్ కో తవుల గే, పట్నుమ్‍తె అన్నె పెసుత్ నాయ్. ");
INSERT INTO key_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","కిచ్చొక మెలె, జోవయింక పఁవ్సిల్ రితి ఇండిల జోవయించ అమ్‍చ యూదుల్‍క దేముడు సిచ్చ దెత దీసల్ జవుల, జేఁవ్. జో అగ్గె రెగిడ్లిసి దస్సి జర్గు జా పూర్తి జంక అస్సె. ");
INSERT INTO key_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","“అయ్యొ! జేఁవ్ దీసల్‍క వయ తిల తేర్‍బోదల్, బోదల్ వడ్నివొ ఉట్ట నిగుక నెత్ర ఒగ్గర్ స్రెమల్ జవుల! ఈంజ దేసిమి ఒగ్గర్ కస్టల్ సిచ్చల్ జవుల! ");
INSERT INTO key_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","అమ్‍చ యూదుల్‍తె సగుమ్‍జిన్‍క కండ గెలుల, సగుమ్‍జిన్‍క దెర వేర దేసిమ్‍లుతె కడ నెవుల. అన్నె యూదుల్ నెంజిలస ఈంజ యెరూసలేమ్ పట్నుమ్‍చి ఉప్పిరి, ఈంజ దేముడుచి గుడిచి ఉప్పిరి ఏలుప కెర్తి కాలుమ్ కేడ్తె ఎదక జేఁవ్ ఈంజ ఎత్కి సుంద గెలుల. ");
INSERT INTO key_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“పడ్తొక, పొద్దుతె, జోనుతె, చి సుక్కల్‍తె కిచ్చొ కిచ్చొ గుర్తుల్ డీసుల చి, తుపాన్ కెర్లె సముద్రుమ్‍చ కెర్టల్ ఎదిలి డోంక్‍క జా, బుఁయ్యె ఉట్ట జా గెరల్ గుడ్డ దెర గెలె, జా అల్లర్ జా అవాడ్ కీస్ తయెదె గే, దస్సి జయెదె చి, దసచచి రిసొ ఒండి లోకుమ్‍తె వేర వేర దేసిమ్‍లుచ మాన్సుల్ స్రెమల్ సేడుల చి, కిచ్చొ ఉచరుక గే నేన గెచ్చుల. ");
INSERT INTO key_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ఈంజ లోకుమ్‍తె జెంక తిల అల్లర్‍చి రిసొచి జోవయించి బయిమ్‍క మాన్సుల్‍చి మొకొమ్ గుంజ్ర సేడుల. కిచ్చొక మెలె, ఆగాసుమ్‍తె సెక్తి తిలిసి ఎత్కి అద్దుర్ జా గెచ్చెదె. ");
INSERT INTO key_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","తెదొడ్‍క, ఎదివాట్ అదికారుమ్ తెన్, పరలోకుమ్‍చి ఉజిడి తెన్ ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ మబ్బుతె పరలోకుమ్ తెంతొ ఉత్ర జెతిసి ఎత్కిజిన్ దెకుల. ");
INSERT INTO key_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","“జలె, ఈంజ ఎత్కి జర్గు జంక దెర్లె పొది, అమ్‍చి రచ్చన పాసి జా జెతయ్ మెనన, తుమ్ సోగ టీఁవ దయిరిమ్‍క ఉప్పిరి దెక, సర్దసంతోసుమ్ జా” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","తెదొడి యేసు జోవయింక అన్నె కిచ్చొ టాలి సంగిలన్ మెలె, “అంజూరుమ్ రూకుక చి అన్నె రగల్ రూకుల్‍క ఉచరుమ. ");
INSERT INTO key_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","జేఁవ్ పలొయిలె బేగి, ‘వేసెగు అప్పె పాఁవ జెయెదె’ మెన తుమ్ చినితసు, జాన్సు. ");
INSERT INTO key_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","దస్సి, ఆఁవ్ సంగిల గుర్తుల్ జర్గు జతిసి తుమ్ దెకిలె, ‘దేముడుచి రాజిమ్ పాఁవ జా అస్సె చి జెయెదె’ మెన జాన్‍తె. ");
INSERT INTO key_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“తుమ్‍క ఆఁవ్ కిచ్చొ కచితుమ్ సంగితసి మెలె, ఆఁవ్ సంగిల స్రెమల్ గుర్తుల్ పూర్తి జర్గు జతి ఎద ఈంజ ఉగుమ్ అంతుమ్ జయె నాయ్. ");
INSERT INTO key_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ఆగాసుమ్ బుఁయి నాసెనుమ్ జా గెచ్చుల, గని అంచ కొడొ ఎద్గరె పిట్టితి నాయ్. ");
INSERT INTO key_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“తుమ్ మెన్సుతె కిచ్చొ బుద్ది ఇండితె గే తుమ్ జాగర్త దెకన! నెంజిలె, తుమ్ ఓడుప జతి రితి ఒగ్గర్ సూరు పియ మచ్చితిస్ గట్ర, దస్సి మచ్చితిస్‍క వెర్రి రితి ఇండితిస్ గట్ర చి, ఈంజ లోకుమ్‍చ రోజుకచ బాదల్ చి రిసొ ఉచర్తిసి తుమ్‍క పెల గెలెదె. తుమ్ దసచతె అలవాట్ జా తిలె, ఈంజ ఉగుమ్‍చి జా ఆకర్ దీసి అయ్‍లె, బోనుక ‘అస్సె’ మెన జంతు నేన్లె కీసి చట్కున దెర్ను సేడుక జయెదె గే, దస్సి తుమ్ చట్కున లాజ్ బెట్టుక జయెదె. ");
INSERT INTO key_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","కిచ్చొక మెలె, బూలోకుమ్ తిలస ఎత్కిజిన్‍క జా దీసి లయెదె. ");
INSERT INTO key_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ఈంజేఁవ్ స్రెమల్‍తె జా దీసి జెతికయ్ గుర్తుచ అల్లర్ ఎత్కితె తుమ్ ఓర్సుప జా జీన్‍తి రితిచి, జీన ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ ఏలుప కెరుక మెన అన్నె జెతి పొదిక అంచి మొక్మె తుమ్ టీఁవ్‍తి రితి, తుమ్ జాగర్త దెకన, జా ఎత్కిక దొర్కు జలి సెక్తి తుమ్‍క తవుస్ మెన తుమ్ ప్రార్దన కెర్తె తా” మెన యేసు సిస్సుల్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","జలె, జా దొరతి యేసు రోజుక మెద్దెన్ పొది దేముడుచి గుడితె గెచ్చ బోదన కెర్తె తయెదె చి, రోజుక సంజె పట్నుమ్ తెంతొ బార్ జా ఒలీవ మెట్టయ్ నిద్ర తయెదె. ");
INSERT INTO key_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","రోజుక పెందల్ పొది ప్రెజల్ ఎత్కి బే బేగి బార్ జా జోచి బోదన సూనుక మెన దేముడుచి గుడితె గెచ్చుల. ");
INSERT INTO key_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","పస్కా పండుగు, జలె నే పులయ్‍ల పోడియొ కతి పండుగు పాసి జా అయ్‍లి. ");
INSERT INTO key_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","తెదొడి “కెఁయఁక కీసి ప్రెజల్‍క బమ్మ నే కెర్తె యేసుక మారుమ?” మెన వెల్లెల పూజర్లు చి మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస కుట్ర ఉచర్తె తిల. కిచ్చొక మెలె, ప్రెజల్‍క బితె తిల. ");
INSERT INTO key_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","తెదొడి, యేసుచ బారజిన్ సిస్సుల్‍తె తిలొ ఇస్కరియోతు మెలొ యూదాక సయ్‍తాన్ దెర్లన్. ");
INSERT INTO key_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","యూదా వెల్లెల పూజర్లుతె చి దేముడుచి గుడిచ జమాన్లు సుదల్‍చ అదికారుల్‍తె గెచ్చ కెర, “యేసుక తుమ్‍చి అత్తి ఆఁవ్ దెర దెయిందె. కీస్ కెరుమ?” మెన జోవయింతెన్ లట్టబ్ల, ");
INSERT INTO key_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","జేఁవ్ సర్ద జా “తుక డబ్బుల్ దెమ్‍దె” మెన ఒప్పన్ల. ");
INSERT INTO key_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","జో కి ఒప్పన్లొచి, జనాబ్ నెంజిలిస్‍తె యేసుక దెర దెంక మెన వాట్ చజితె తిలొ. ");
INSERT INTO key_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","తెదొడి నే పులయ్‍ల పోడియొ కతి దీసి అయ్‍లి. జా దీసి పస్కా పండుగ్‍చి రిసొచి మెండపిల్ల కండ అర్పితుమ్ దెవుల. ");
INSERT INTO key_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","జాకయ్ యేసు పేతురుక చి యోహానుక “తుమ్ గెచ్చ, చి పస్కా పండుగు అన్నిమ్ అమ్ కతి రిసొ దొర్కు జలిసి తెయార్ కెర” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","“అమ్ కేనె తెయార్ కెరుక తుచి ఆస?” మెన జేఁవ్ పుసిల. ");
INSERT INTO key_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","జోవయింక, “ఈందె, పట్నుమ్‍చి తెడి పెసిలదు మెలె, పాని వయితొసొ ఎక్కిలొ తుమ్‍క దస్సుల్ జయెదె. జోచి పట్టి తుమ్ గెచ్చ చి, కేన్ గెరి జో పెసెదె గే, ");
INSERT INTO key_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","జో గెర్‍చొ ఎజొమానిక తుమ్ కిచ్చొ మెన మెలె, ‘అంచ సిస్సుల్ తెన్ ఆఁవ్ పస్కా అన్నిమ్ కతి గది కేన్ మెన అమ్‍చొ గురుబాబు సంగితయ్’ మెన తుమ్ సంగ, ");
INSERT INTO key_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","సామన్ తెయార్ కెర్లి వెల్లి అంతస్తు గది ఏక్ తుమ్‍క జా దెకయెదె. ఒత్తయ్ అమ్‍చి రిసొ పస్కా అన్నిమ్ తుమ్ తెయార్ కెర తా” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","జేఁవ్ గెచ్చ కెర, ‘జో సంగిల్ రితి ఎత్కి జర్గు జా అస్సె’ మెన దెక కెర, జా పస్కా అన్నిమ్‍క దొర్కు జలిసి ఎత్కి తెయార్ కెర్ల. ");
INSERT INTO key_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","పండుగ్ అన్నిమ్ కెర్తి సమయుమ్ పాఁవ జెతికయ్, యేసు సిస్సుల్ తెన్ జా అన్నిమ్ కంక మెన వెసిల. ");
INSERT INTO key_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","తెదొడి యేసు జోవయింక, ఆఁవ్ సేడుక తిల స్రెమల్ నే జతె అగ్గె తుమ్‍చి తెన్ ఈంజ పస్కా అన్నిమ్ కంక మెన ఆఁవ్ ఒగ్గర్ ఆస జలయ్. ");
INSERT INTO key_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","కిచ్చొక మెలె, దేముడు ఎదార్దుమ్ ఏలుప కెరుక అయ్‍లె పొదిక, జోచి రాజిమ్‍తె ఈంజ పస్కా పండుగు గుర్తు జతి రచ్చనచి ముక్కిమ్‍చి అర్దుమ్‍చి కామ్ పూర్తి జర్గు కెర్తె ఎదక ఈంజ మదెనె, ఈంజ పండుగ్ అన్నిమ్ ఆఁవ్ అన్నె కయి నాయ్ మెన తుమ్‍క ఆఁవ్ సంగితసి. ");
INSERT INTO key_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","జా పండుగ్ అన్నిమ్ పితి డొమ్న ద్రాచ రస్సుమ్ యేసు తెదొడి దెర కెర, ‘ఈంజ తుయి దా దయ కెర్లది’ మెన దేముడు అబ్బొస్‍క సంగ కెర, సిస్సుల్‍క “ఉంద, ఇన్నె తిలిసి తుమ్ వర్స తెన్ పియ వంటన. ");
INSERT INTO key_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","కిచ్చొక మెలె, దేముడుచి రాజిమ్ ఎదార్దుమ్ ఏలుప కెర్తి రితి జెతె ఎదక ఈంజ మదెనె ఆఁవ్ ద్రాచ రస్సుమ్ పియి నాయ్ మెన తుమ్‍క ఆఁవ్ సంగితసి” మెన యేసు సంగ కెర, ");
INSERT INTO key_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","పోడి వెంట ‘తుయి ఈంజ దయ కెర్లది’ మెన దేముడు అబ్బొస్‍క సంగ కెర, జా పోడి మోడ కెర, సిస్సుల్‍క దా “ఉంద, ఈంజ అంచి ఆఁగ్. అంక తుమ్ ఏద కెర్తి గుర్తుక తుమ్ ఇసి కంక అలవాట్ జా. ఉంద కా,” మెన దిలన్. ");
INSERT INTO key_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","దస్సి, జా అన్నిమ్ కా కేడయ్‍లి పొది గలస్ అన్నె దెర, “ఈంజ గలస్ ద్రాచ రస్సుమ్, ఆఁవ్ దెతి నొవి ప్రమానుమ్. తుమ్‍చి పాపుమ్ గెచ్చయ్‍తి రిసొ సువ దెతి అంక లొఁయి. జా లొఁయిచి గుర్తు ఈంజ ద్రాచ రస్సుమ్. ");
INSERT INTO key_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“ఈందె, అంక దెర, సొర్ప కెర దెతొసొ ఈంజ బల్లతె వెస అంచి తెన్ అన్నిమ్ కెర్తయ్. జోచి ఆతు అంచి ఆతు తెన్ ఈంజ బల్లచి ఉప్పిరి అస్సె. ");
INSERT INTO key_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","కిచ్చొక మెలె, ‘జర్గు జంక అస్సె’ మెన దేముడు అగ్గె తెంతొ రెగిడ్లి రితి ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ గెచ్చుక అస్సె, గని అయ్యొ! కేన్ మాన్సు అంక దెర విరోదుమ్ సుదల్‍చి అత్తి సొర్ప కెర దెయెదె గే, జో మాన్సు జతి సిచ్చ కెద్ది!” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","జో దస్సి సంగితికయ్, ‘ఆఁవ్ గె? ఆఁవ్ గె?’ మెన ఎక్కిలొ తెన్ ఎక్కిలొ లట్టబుక దెర్ల. ");
INSERT INTO key_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","జలె, జోవయింతె కొన్సొ వెల్లొ జయెదె గే సిస్సుల్ లట్టబనుక దెర్ల. ");
INSERT INTO key_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","జేఁవ్ దస్సి జతికయ్, యేసు జోవయింక, “యూదుల్ నెంజిల వేర రానల్ సొంత గవురుమ్ ఉచరన ప్రెజల్‍క జాడ్లు వయడ్తె తిలి రిత జోవయింక పోటి తెన్ ఏలుప కెర్తతి, అన్నె ప్రెజల్‍చి ఉప్పిర్‍చ అదికారుల్ ‘దర్ముమ్ కెర్తస’ మెనంతతి. ");
INSERT INTO key_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","గని తుమ్‍చి తెన్ దస్సి తంక జయె నాయ్. తుమ్‍చి తెన్ వెల్లొ జతొసొ ఎత్కిచి కంట దకిలొ రితొ జవుస్ చి, తుమ్‍క ఏలుప కెర్తొసొ సేవ కెర్తొసొ రితొ జవుస్. ");
INSERT INTO key_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","మాములుమ్ ఈంజ లోకుమ్‍చి రగుమ్ ఉచర్లె, కొన్సొ వెల్లొ జయెదె? అన్నిమ్‍క బల్లతె వెసితొసొ గే జోవయించి అన్నిమ్ వంట దెతొ గొత్తి సుదొ గె? బల్లతె వెసితొసొ వెల్లొ జయెదె, గెద. జలె, ఆఁవ్ తుమ్‍చి నెడిమి తా వంట దెతొ గొత్తి సుదొచొ రితొ జతసి. ఈంజ అర్దుమ్ కిచ్చొ జయెదె గే తుమ్ ఉచర. ");
INSERT INTO key_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“తుమ్ అంచ సిస్సుల్ ఆఁవ్ సేడ్ల బాదల్ ఎత్కితె బెద నిదానుమ్ తా అస్సుస్, ");
INSERT INTO key_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","అన్నె, జోచి రాజిమ్‍చి ఉప్పిరి ఆఁవ్ ఏలుప కెర్తి రిసొ కీసి అంచొ దేముడు అబ్బొ అంక అదికారుమ్ దా అస్సె గే, దస్సి ");
INSERT INTO key_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","తుమ్ అంచి రాజిమ్‍తె అంచి బల్లతె వెస కంక పింక చి, తుమ్ బారజిన్ బార సిఙాసనల్‍తె వెస, ఇస్రాయేలుల్‍చ బార సెకుమ్‍లుచక అంచి తెడి ఏలుప కెరుక మెన తుమ్‍క ఆఁవ్ నిసాన అస్సి” మెన యేసు జోచ సిస్సుల్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","పడ్తొ, పేతురుచి అగ్గెచి నావ్ దెర, “సీమోను, సీమోను, ఈందె, తేర్‍బోద కీసి తందుడు పూన నిసెదె గే, దస్సి తుమ్‍క నిసితి రితి అల్లర్‍చి పరిచ్చ కెరుక మెన సయ్‍తాన్ సెలవ్ నఙన అస్సె. ");
INSERT INTO key_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","గని తుచి నముకుమ్ పాడ్ జా గెస్సు నాయ్ మెన ఆఁవ్ ప్రార్దన కెర అస్సి. అన్నె, తుమ్ అన్నె బుద్ది జా అంచి పచ్చెన అన్నె జెతి రితి తుమ్ మార్సుప జలదు మెలె, తుమ్‍చ బావుడ్లు జల అంక నంపజల అన్నె మాన్సుల్‍చి నముకుమ్ తుమ్ డిట్టుమ్ కెర” మెన యేసు పేతురుక చి, అన్నె సిస్సుల్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","తెదొడి పేతురు “ప్రబు, తుయి జేల్‍తె జేలి తంక జలెకి, మొరుక జలెకి, తుచి తెన్ బెద జేలి జయిందె జవుస్, మొరిందె జవుస్, అంక బి నాయ్” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","జలె, పేతురు దస్సి సంగితికయ్, యేసు జోక, “ఓ పేతురు, తుక ఆఁవ్ కిచ్చొ మెంతసి మెలె, జోక ఆఁవ్ నేని మెన, తుయి తివ్వెరి అంచి రిసొ సంగితె ఎదక కుకుడొ వాఁసె నాయ్”. ");
INSERT INTO key_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","తెదొడి యేసు సిస్సుల్‍క అన్నె, “జా సుట్టు దేముడుచి రాజిమ్ పాసి జా అయ్‍లిస్‍చి రిసొచి సుబుమ్ కబుర్ సంగ సంగ మాన్సుల్‍క చెంగిల్ కెర కెర తుమ్ బుల” మెన తుమ్‍క ఆఁవ్ తెద్రయ్‍లి పొది “సెంచె నెంతె, డబ్బుల్ సెంచె నెంతె, చి జోడ్లు నెంతె గెచ్చ మెన సంగిలయ్ గెద. జలె, దసచ నెంతె గెతికయ్, తుమ్‍క కిచ్చొ జలెకు కొత్కు తిలి గె?” మెన పుసిలన్, చి “కిచ్చొయ్ కొత్కు నాయ్” మెల. ");
INSERT INTO key_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","దస్సి జబాబ్ దెతికయ్, జోవయింక అన్నె, “అప్పె జలె, కక్క సెంచె గే డబ్బుల్ సెంచె గే అస్సె గే, దెర తంక, చి కక్క కండా తయె నాయ్ గే, జోవయించి కోటు విక కండా గెననుక. ");
INSERT INTO key_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","కిచ్చొక మెలె, తుమ్‍క ఆఁవ్ కిచ్చొ సంగితసి మెలె, క కి ‘నేరిమ్ కెర్లొసొ’ మెన తీర్పు కెరు మెన దేముడుచి కొడొతె రెగ్డయ్‍లి కోడు అంచితె పూర్తి జర్గు జంక అస్సె. కిచ్చొక మెలె, అంచి రిసొ రెగిడ్లిసి ఎత్కి కచితుమ్ జర్గు జయెదె” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","తెదొడి సిస్సుల్, “ఈందె, ప్రబు, అమ్‍చితె దొన్ని కడ్గుమ్‍లు అస్తి” మెల, చి “సాలు” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","యేసు ఒలీవ మెట్టయ్ గెచ్చుక అలవాట్ తిలి చి, తెదొడి బార్ జా ఒత్తయ్ గెలన్. జోచ సిస్సుల్ కి జో తెన్ బెద గెల. ");
INSERT INTO key_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","జలె, ‘గెత్సేమనే’ మెంతి జో గెతి ఒత్తచి తోటతె పాఁవ కెర, సిస్సుల్‍క యేసు, “అప్పె జెత అల్లర్ తుమ్‍క ఏక్ పరిచ్చ రితి జయెదె. ఈంజ ఎత్కితె తుమ్ పాపుమ్ నే కెర్తి రిసొ ప్రార్దన కెర్తె తా” మెన యేసు సంగ కెర, ");
INSERT INTO key_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","పత్తురు గల్తి ఎదిలి దూరి గెచ్చ కెర, మొగ్రల్ టెక, ");
INSERT INTO key_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“ఓ బ, తుక ఇస్టుమ్ తిలె, ఈంజ గిన్నచి ఆఁవ్ నే పితి రితి అంక పిట్టవు, గని అంచి ఇస్టుమ్ పోని. తుచి ఇస్టుమ్ జర్గు జవుస్” మెన దేముడు అబ్బొస్‍క ప్రార్దన కెర్లన్. ");
INSERT INTO key_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","పరలోకుమ్ తెంతొ దూత ఎక్కిలొ డీస జోక డిట్టుమ్ కెర్లన్. ");
INSERT INTO key_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","తెదొడి జోచి పెట్లి ఒగ్గర్ బాద దుకుమ్ సేడ, అన్నె ఒగ్గర్ ఆస తెన్ ప్రార్దన కెర్లన్ చి, జోచి గాము కీసి పుట్టిలి మెలె, సుక్కల్ లొఁయి జా బుఁయ్యె సేడ గెలన్. ");
INSERT INTO key_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","జలె, యేసు ప్రార్దన కెరుక ముల ఉట్ట కెర సిస్సుల్ తిలిస్‍తె అయ్‍లె, జేఁవ్ ఒగ్గర్ దుకుమ్‍క అల్పు జా నిజ గెల అస్తి. ");
INSERT INTO key_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","అన్నె, జోవయింక “తుమ్ కిచ్చొక నిజుక? ఉట్ట, చి ఈంజ జెతి అల్లర్‍చి పరిచ్చతె తుమ్ పాపుమ్ నే కెర్తె రితి ప్రార్దన కెర్తె తా” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","యేసు జా కోడు సంగితె తతికయ్, ఒగ్గర్‍జిన్ జనాబ్ మాన్సుల్ జట్టు తెన్ అయ్‍ల, చి కో జోక పుర్రె గెచ్చ వాట్ దెకయ్‍తె తిలన్ మెలె, యేసుచ బారజిన్ సిస్సుల్‍తె తిలొ ఇస్కరియోతు యూదా. జో యూదా, జలె, యేసుక చుంబుక మెన జోచి పాసి అయ్‍లన్, ");
INSERT INTO key_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","గని యేసు జోక, “ఓ యూదా, ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొక దెర దెతి పొది ఉప్రమెన్సుక చుంబ దెతె గె?” మెన జోక పుసిలన్. ");
INSERT INTO key_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","జలె, ‘జోక దెరుల’ మెన యేసు తెన్ తిల జోచ సిస్సుల్ దెక కెర, “ప్రబు, అమ్‍చ కడ్గుమ్‍లు తెన్ జోవయింక కండుమ గె?” మెన పుసిల. ");
INSERT INTO key_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","జోవయింతె ఎక్కిలొ కిచ్చొ కెర్లొ మెలె, ఎత్కిక వెల్లొ పూజరిచొ గొత్తి సుదొక కండుక గెచ్చ, జోచొ ఉజిలొ కంగ్డొ సింద గెలన్. ");
INSERT INTO key_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","జలె యేసు “అన్నె దస కమొ పోన” మెన సంగ కెర, జో గొత్తి సుదొచొ కంగ్డొ చెంగిల్ కెర్లన్. ");
INSERT INTO key_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","తెదొడి జోక దెరుక మెన బార్ జా అయ్‍ల వెల్లెల పూజర్లుక, దేముడుచి గుడిచ సయ్‍న్యుమ్ సుదల్‍చ అదికారుల్‍క చి వెల్లెల సుదల్‍క యేసు, “ఆఁవ్ కిచ్చొ చోర్లయ్ గే, చి కత్తులు డండల్ దెరన తుమ్ అయ్‍లదు? ");
INSERT INTO key_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ఆఁవ్ రోజుక దేముడుచి గుడితె గెతె తిలె కి, తెదొడి తుమ్ అంక దెర్లద్ నాయ్. గని తుమ్‍చి కామ్ తుమ్ జర్గు కెర్తి గడియ ఈంజ, అందర్ లోకుమ్‍చి సెక్తి ఏలుప కెర్తి గడియ ఈంజ” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","తెదొడి యేసుక దెర ఎత్కిక వెల్లొ పూజరిచి మేడతె కడ నిల. కడ నెతె తిలి పొది పేతురు, జలె, దూరి దూరి యేసుచి పట్టి గెతె తిలన్, అన్నె, ");
INSERT INTO key_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ఎత్కిక వెల్లొ పూజరిచి మేడచి వీదిచి నెడిమి సగుమ్‍జిన్ చల్లిక ఆగి లావ తపుక మెన వెస తతికయ్, పేతురు జోవయింతెన్ వెసిలన్. ");
INSERT INTO key_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","పేతురు దస్సి ఆగిచి ఉజిడ్‍తె వెస తతికయ్, తేర్‍బోద గొత్తి సుదొ ఎక్లి జోక దెక కెర, చెంగిల్ దెక కెర, “ఈంజొ మాన్సు యేసు తెన్ బుల్తె తిలొ” మెలి. ");
INSERT INTO key_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","గని పేతురు “అమ్మ, జోక ఆఁవ్ నేని” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","పడ్తొ అన్నె గడియ గెతికయ్, అన్నెక్లొ పేతురుక దెక కెర, “తుయి కి జో తెన్ తిలొసొ” మెలన్, గని “బాబు, ఆఁవ్ నెంజి” మెన పేతురు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","అన్నెక్ గంట గెతికయ్, అన్నె అన్నెక్లొ పేతురుచి రిసొ “నిజుమి, ఈంజొ మాన్సు కచితుమ్ జో యేసు తెన్ తిలన్. ఈంజొ కి గలిలయు సుదొ గెద!” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","పేతురు “బాబు, తుయి సంగితిస్‍చి అర్దుమ్ ఆఁవ్ నేని” మెలన్, జో అన్నె లట్టబ్తె తతికయ్, బేగి కుకుడొ వాఁసిలన్. ");
INSERT INTO key_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","తెదొడి యేసుప్రబు పసుల పేతురుక చెంగిల్ దెకిలన్ చి, “కుకుడొ ఆజి నే వాఁసితె అగ్గె తుయి తివ్వెరి అంచి రిసొ ‘జోక నేని’ మెంతె” మెన యేసుప్రబు సంగిలిసి పేతురు ఏదస్ట కెర్లను, చి ");
INSERT INTO key_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","జా వీదె తెంతొ బార్ జా బయిలె గెచ్చ కొక్క కొక్క ఏడ్లన్. ");
INSERT INTO key_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","తెదొడి యేసుక రకితె తిల మాన్సుల్ యేసుక కొంకడ కెర దెబ్బల్ పెట్ల చి, ");
INSERT INTO key_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","జోచ అంకివొతె కచ్చెల్ బంద కెర, “తుక కో పెట్ల గే తుయ్ క్రీస్తు గద, అమ్‍క సంగు!” మెల, అన్నె ");
INSERT INTO key_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","జోక దూసుప కెర్త అన్నె ఒగ్గర్ కొడొ సంగిల. ");
INSERT INTO key_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","రాత్ పాయితికయ్, యూదుల్‍చ వెల్లెల సుదల్, జోవయించ వెల్లెల పూజర్లు చి, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస తగు కెరుక మెన వెసిల చి, జా తగు కెర్తిస్‍తె యేసుక కడ ఆన్ల. ");
INSERT INTO key_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“‘తెద్రయిందె’ మెన దేముడు సంగిలొ క్రీస్తు రచ్చించుప కెర్తొసొ తుయి గే?” మెన అగ్గెతె వెసిలస పుసిల. యేసు కిచ్చొ సంగిలన్ మెలె, “ఆఁవ్ తుమ్‍క సంగిలె, అంక నంప కెర్సు నాయ్, ");
INSERT INTO key_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","అన్నె, తుమ్‍క ఆఁవ్ ఏక్ కోడు పుసిలె, అంక జబాబ్ దేసు నాయ్, ");
INSERT INTO key_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","గని ఇన్నెచి పడ్తొ ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ ఎత్కి సెక్తి అదికారుమ్ తిలొ అమ్‍చొ దేముడుచి ఉజెతొ పక్క వెస తతిసి దెకితె” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","“దస్సి జలె, అమ్‍చొ దేముడుచొ పుత్తుసి తుయి గె?” మెన పుసిల, చి జో జోవయింక “తుమ్ సొంత సంగిల్ రితి జొయ్యి ఆఁవ్” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","యేసు దస్సి సంగితికయ్, ‘దేముడుచొ పుత్తుసి ఆఁవ్’ మెన యేసు ఒప్పన్లిసి జో దేముడు తెన్ సమ్మందుమ్ సంగన్లి రితి జతయ్. జా తప్పు మెన ఉచర, “అమ్‍క అన్నె సాచి అవ్‍సురుమ్ నాయ్. జో సొంత సంగితికయ్ సూన్లమ్.” ");
INSERT INTO key_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","తెదొడి తగుతె వెసిల వెల్లెల సుదల్ ఎత్కి ఉట్ట యేసుక పిలాతు అదికారితె కడ నిల చి, ");
INSERT INTO key_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","జోచి మొక్మె జోక టీఁవడ కెర, కిచ్చొ నేరిమ్ సంగిల మెలె, “కైసర్ రానొచి అమ్‍క ఏలుప కెర్తొ ప్రబుతుమ్‍క సిస్తు దాస నాయ్” మెన. “ఆఁవ్ క్రీస్తు, ఆఁవ్ రానొ మెనన, ఈంజొ మాన్సు అమ్‍చ ప్రెజల్‍క వెర్రి సికడ్తయ్”. ");
INSERT INTO key_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","పిలాతు అదికారి యేసుక కిచ్చొ పుసిలన్ మెలె, “తుయి యూదుల్‍చొ రానొ గె?”. “తుయి సంగిల్ రితి మెన”, యేసు జబాబ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","తెదొడి వెల్లెల పూజర్లుక చి జనాబ్‍క “ఈంజొ మాన్సు కిచ్చొ నేరిమ్ నే కెర్లి రితి అంక డీస్తయ్” మెన పిలాతు అదికారి తీర్పు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","జేఁవ్ కిచ్చొ మెల మెలె, గలిలయతె మొదొల్ కెర ఈంజ యెరూసలేమ్ ఎద కి “అమ్‍చ యూదుల్ జితిస్ ఎత్కితె, ఈంజొ కిచ్చొ కిచ్చొ సికడ, ప్రబుతుమ్‍చి ఉప్పిర్ ప్రెజల్‍చి సేంతుమ్ పిట్టయ్‍తయ్” మెన యేసుచి రిసొ పిలాతుక బియఁడుక ఉచర అబద్దుమ్ సంగిల. ");
INSERT INTO key_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","గలిలయచి కోడు పిలాతు అదికారి సూన కెర, యేసుచి రిసొ “దస్సి జలె, ఈంజొ మాన్సు గలిలయుడు గె?” మెన పుసిలన్ ");
INSERT INTO key_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","‘హేరోదు ఏలుప కెర్తి గలిలయతె తెంతొ యేసు బార్ జలొ’ మెన సూన కెర, జోక జో హేరోదు రానొతె తెద్రయ్‍లన్. జా పొది హేరోదు యెరూసలేమ్‍తె జా తిలన్. ");
INSERT INTO key_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","జలె, హేరోదు యేసుక దెక కెర, సర్దసంతోసుమ్ జలొ. కిచ్చొక మెలె, జోచి రిసొ అగ్గెయ్ తెంతొ సూన తిలొ చి, ‘జో కెర్తి కిచ్చొ జవుస్ వెల్లి కామ్ దెకిన్‍దె’ మెన హేరోదు జోక దెకుక ఒగ్గర్ ఆస జా తిలొ. ");
INSERT INTO key_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","జాకయ్, యేసుక జేఁవ్ మాన్సుల్ ఒత్త కడ నెతికయ్, హేరోదు ఒగ్గర్ కొడోల్ జోక పుసిలన్, గని యేసు ఎక్కి కోడు కి జబాబ్ దెయె నాయ్. ");
INSERT INTO key_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","తెదొడి వెల్లెల పూజర్లు చి మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస పుర్రె టీఁవ కెర, ఒగ్గర్ విస్సుమ్ తెన్ యేసుచి ఉప్పిరి నేరిమ్‍లు వయడుక దెర్ల. ");
INSERT INTO key_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","అన్నె హేరోదు అదికారి జోచి సయ్‍న్యుమ్ తెన్ జోక నిస్కారుమ్ దెకిత్ రితి మార్సుప జా, కొంకడ్ల చి, చెంగిల పాలల్ జోక గల దా, పిలాతుతె అన్నె తెద్రయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","చి హేరోదు చి పిలాతు అగ్గె తెంతొ ఎక్కిలొక ఎక్కిలొ విరోదుమ్ జా తిలె కి, జయ్యి దీసి తెంతొ సినేతుమ్ బందిల. ");
INSERT INTO key_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","తెదొడి పిలాతు వెల్లెల పూజర్లుక చి యూదుల్‍చ అదికారుల్ ఎత్కిక బుకారా కెర, ");
INSERT INTO key_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","జోవయింక, “‘ప్రెజల్ ప్రబుతుమ్‍చి తెడి సేంతుమ్ నే తతి రితి ఈంజొ సికడ్తయ్’ మెన సంగ తుమ్ ఈంజొ మాన్సుక అంచితె కడ ఆన్లదు, అన్నె, తుమ్‍చి మొక్మె ఆఁవ్ పరిచ్చ కెర్లె, ఈందె, ఇన్నెక ఉప్పిరి తుమ్ సంగిల నేరిమ్‍లుతె కేన్ కి ‘కెర్లొ’ మెన రుజ్జు డీసె నాయ్. ");
INSERT INTO key_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","హేరోదు కి పరిచ్చ కెర్లొ చి, జోక అమ్‍తె అన్నె తెద్రయ్‍లొ, గెద. ఈందె, మొర్తి సిచ్చ జతి కిచ్చొ నేరిమ్ కి కెరె నాయ్. ");
INSERT INTO key_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","జాకయ్, ఇన్నెక ఇదిల్ బుద్ది సికడ్తి రితి అంచ సయ్‍న్యుమ్‍లు కొర్డల్ తెన్ పెటుతు చి, ఇన్నెక విడ్దల్ కెరిందె” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","కిచ్చొక మెలె, యూదుల్‍క సర్ద కెర్తి రితి వెర్సి వెర్సి జా పండుగు పొది జేలి జలొ కేన్ జవుస్ మాన్సుక విడ్దల్ కెరుక జో అదికారిక అలవాట్. ");
INSERT INTO key_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","గని “జో మాన్సుక పోని. జోక మారు చి, బరబ్బక ములు. జోకయ్ అమ్‍క కావలె” మెన ఎక్కి జట్టు జా కేక్ గల. ");
INSERT INTO key_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","బరబ్బ, జలె, కొన్సొ మెలె, యెరూసలేమ్ పట్నుమ్‍తె ప్రబుతుమ్‍చి ఉప్పిరి ప్రెజల్ విరోదుమ్ కెర్తి రితి జో అల్లర్ కెర తిలి రిసొచి, నరు అత్య జో కెర తిలి రిసొ జోక జేలి కెర జేల్‍తె గల తిల. ");
INSERT INTO key_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","తెదొడి కిచ్చొ జలి మెలె, యేసుక విడ్దల్ కెరుక మెన తెదొడి ఎద పిలాతుక ఇస్టుమ్ తిలి రిసొ, దస్సి మెన కేక్ గల బెర తిలసక అన్నెక్ సుట్టు సంగుక దెర్తికయ్, ");
INSERT INTO key_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","జేఁవ్ ఎత్కిజిన్ “జోక సిలువతె గల టీఁవడ మొర్తి సిచ్చ కెరు! మొర్తి సిచ్చ కెర!” మెన కేక్ గల. ");
INSERT INTO key_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","తెదొడి అన్నెక్ సుట్టు, ఇన్నెతెన్ మొత్తుమ్ తివ్వెర్ జలి, పిలాతు “కిచ్చొక? ఈంజొ కిచ్చొ నేరిమ్ కెర అస్సె? మొర్తి సిచ్చ జతి ఎదిలి కేన్ నేరిమ్ ఈంజొ కెర్లిస్‍చి రుజ్జు అంక డీసె నాయ్. జాకయ్ ఇన్నెక కొర్డల్ తెన్ పెట బుద్ది సికడ్తు చి, విడ్దల్ కెరిందె” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","గని బెర తిల జనాబ్ “జోక సిలువ గలు! మొర్సు!” మెన కేకుల్ గల గల, బలవంతుమ్ కెర జీన్ల. ");
INSERT INTO key_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","జాకయ్ “జేఁవ్ బలవంతుమ్ కెర సంగిలి రితి జర్గు జవుస్” మెన పిలాతు తీర్పు దిలన్, ");
INSERT INTO key_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","అన్నె, ప్రబుతుమ్‍చి ఉప్పిరి ప్రెజల్‍క విరోదుమ్ సికడ్లొ నరు అత్య కెర తిలొ బరబ్బకయ్ ముల దిలన్; బెర తిల జనాబ్ బలవంతుమ్ కెర తిలి రిసొ-చి “యేసుక కిచ్చొ కెర్తె గే కెర తుమ్‍చి ఇస్టుమ్ తుమ్‍చి పూచి” మెన, జోవయించి అత్తి జోక సొర్ప కెర దిలన్. ");
INSERT INTO key_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","జలె, యేసుక పట్నుమ్ ఒత్తల్‍తొచి బయిలె కడ నెతె తా, ‘యేసుక టీఁవడ్తి సిలువ వయన జోవయించి పట్టి ఇండుస్’ మెన, కేనె గే బయిలు దేసిమ్ తెంతొ జా వాట్ జెతె తిలొ సీమోను మెలొ కురేనియు ప్రాంతుమ్‍చొ మాన్సుక దెర కెర, జోక జా సిలువ వయడ్ల. ");
INSERT INTO key_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","అన్నె, యేసుచి పట్టి ఒగ్గర్‍జిన్ జనాబ్ జెతె తిల, అన్నె జోవయింతెన్ ఒగ్గర్‍జిన్ తేర్‍బోదల్ గుండెతె పెటన ఏడుకుడు జతె తిల. ");
INSERT INTO key_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","గని యేసు పసుల జోవయింక, “ఓ యెరూసలేమ్‍చ తేర్‍బోదలు, అంక జెతి బాద చి రిసొ తుమ్ ఏడ నాయ్, గని తుమ్ కిచ్చొచి రిసొ ఏడుక మెలె, తుమ్‍క చి తుమ్‍చ బోదల్‍క రిసొయ్ ఏడ. ");
INSERT INTO key_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","మెలె, ఈందె, ‘గొడ్డు జలసక, బోదల్ నే పాయిలసక, దూద్ నే పియడ్లసక చెంగిలి!’ మెన తుమ్ సంగిత దీసల్ జెవుల. ");
INSERT INTO key_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","కిచ్చొక మెలె, జేఁవ్ దీసల్‍కచ సిచ్చల్ దెక కెర, ‘అమ్‍చి ఉప్పిరి సేడ అమ్‍క డంక గెల’ మెన డొంగ్రల్‍క చి మెట్టల్‍క సంగుల. ");
INSERT INTO key_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","అఁవ్వి తిలి మట్టుక మాన్సుల్ ఇసి కెర్లె, సుకా గెలి మట్టుక కిచ్చొ కెరులగే?” మెన జేఁవ్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","యేసు తెన్ మొర్తి సిచ్చ జతి రిసొ అన్నె దొగులక కి ఒత్త కడ నిల. జేఁవ్ నిజుమి నేరిమ్‍లు కెర్లస. ");
INSERT INTO key_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","జలె, ‘గిడ్గి రితి పోలికచి మెట్ట’ మెలిస్‍తె జేఁవ్ ఎత్కిజిన్ గెచ్చ పాఁవ కెర, యేసుక జోచి సిలువతె టీఁవడ్ల చి, జో డెబ్రి పక్క ఎక్కిలొక చి ఉజెతొ పక్క ఎక్కిలొక జేఁవ్ దొగుల నేరిమ్ కెర్లసక కి ఎక్కెక్ సిలువల్‍తె టీఁవడ్ల. ");
INSERT INTO key_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","అన్నె, జోక దస్సి కెర్లసచి రిసొ యేసు “ఓ బ, ఇన్నెక చెమించుప కెరు. కిచ్చొ కెర్తతి గే నేన్‍తి” మెన దేముడు అబ్బొస్‍క ప్రార్దన కెర్లన్. జోక సిలువతె టీఁవడ్ల జమాన్లు సుదల్ జోచ పాలల్ వంటనుక మెన చీటి గలిల. ");
INSERT INTO key_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ప్రెజల్ పాసి టీఁవ తా దెకితె తిల, “జో అన్నె మాన్సుల్‍క రచ్చించుప కెర్లొ, గెద. దేముడు ‘తెద్రయిందె’ మెన సంగ తిలొ రచ్చించుప కెర్తొసొ క్రీస్తు జయెదె జలె, జొయ్యి నిసాన్లొసొ జయెదె జలె, జోక జొయ్యి రచ్చించుప కెరన్సు!” మెన యూదుల్‍చ అదికారుల్ జోక ఆఁసిల. ");
INSERT INTO key_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","జమాన్లు సుదల్ కి జోక కొంకడ్ల. జోచి పాసి జా కెర, అమ్‌డి తిలి ద్రాచ రస్సుమ్ చంపొ కెర దా, ");
INSERT INTO key_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“తుయి యూదుల్‍చొ రానొ జలె, తుకయ్ తుయి రచ్చించుప కెరను!” మెన కొంకడ్తె తిల. ");
INSERT INTO key_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","పడ్తొ అన్నె కిచ్చొ కెర్ల మెలె, “యూదుల్‍చొ రానొ ఈంజొ” మెన రెగిడ్లి దార్చిగండ యేసుచి బోడిచి ఉప్పిరి ఒడొయ్‍ల. ");
INSERT INTO key_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ఒత్త అన్నె సిలువల్‍తె ఒడొయ్ జా తిల నేరిమ్ కెర్ల దొగులతె ఎక్కిలొ, జలె, “‘తెద్రయిందె’ మెన దేముడు సంగిలొ క్రీస్తు రచ్చించుప కెర్తొసొ నెంజిస్ గె? జలె, తుకయ్ తుయి రచ్చించుప కెరను చి అమ్‍క కి రచ్చించుప కెరు!” మెన యేసుక దూసుప కెర సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","జలె, జో ఎక్కిలొ దస్సి లట్టబ్తికయ్, అన్నెక్లొ జోక “ఇన్నెతెన్ తుయి ఎక్కి రితి సిచ్చ జలెకి, దేముడుక బిస్సి నాయ్ గె? ");
INSERT INTO key_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ఆమ్ జలె, అమ్ నేరిమ్‍లు కెర్లి రిసొయి నాయిమ్ తెన్ అమ్‍క సిచ్చ కెర అస్తి, అమ్ కెర్ల కమొక జెతి సిచ్చతె అమ్‍క గల అస్తి. గని ఈంజొ మాన్సు కిచ్చొ ఇదిలిస్ తప్పు కి కెరె నాయ్” మెన ఈంజొ అన్నెక్లొ చోరు తొల్లితొచొక గోల కెర. ");
INSERT INTO key_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","జో యేసుక, “ఓ యేసుప్రబు, తుయి రానొ జా ఏలుప కెర్తి తుచి అదికారుమ్ తెన్ అన్నె జెతి పొదిక అంక ఉచర దయ దెకు” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","యేసు జోక, “తుక ఆఁవ్ కచితుమ్ సంగితసి మెలె, ఆజి కి చెంగిల్ తోట రితి పరదైసుతె అంచి తెన్ తస్తె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","మెద్దెనె, బార గంటల్ జలి పొది తెంతొ, జలె, తిన్ని గంటల్ ఎద, పొద్దు అందర్ జా గెలి చి, జా దేసిమి ఒండి అందర్ జా గెలి. ");
INSERT INTO key_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","అన్నె కిచ్చొ జర్గు జలి మెలె, దేముడుచి గుడితె ఒడొవ తిలి తెర ఉప్పిర్ తెంతొ ఎట్టొ ఎద చిరి జా దొన్ని గండల్ జా గెలి. ");
INSERT INTO key_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","తెదొడి యేసు గట్టిఙ అవాడ్ కెరన “ఓ బ, తుచి అత్తి అంచి జీవు ఆఁవ్ సొర్ప కెర దెతసి” మెన సంగ ప్రానుమ్ ముల దిలన్. ");
INSERT INTO key_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","జలె, యేసుక దెకితె తిలొ పుంజెక్‍జీన్ జమాన్లుక వెల్లొ, జర్గు జలిసి ఎత్కి దెక కెర, దేముడుక గవురుమ్ కెర్లొ చి, “ఈంజొ మాన్సు కచితుమ్ పున్నిమ్‍చొ!” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","అన్నె, కిచ్చొ జర్గు జయెదె గే దెకుమ మెన ఒత్త గెచ్చ తిల మాన్సుల్ ఎత్కిజిని, జర్గు జలిసి దెక కెర, గుండెతె పెటన గెరి ఉట్ట గెల. ");
INSERT INTO key_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","అన్నె యేసుచ గోతుసుదల్, చి గలిలయ ప్రాంతుమ్ తెంతొ జోచి పట్టి జా సవ్రెచన కెర తిల తేర్‍బోదల్ కి సిలువల్‍క ఇదిల్ దూరి టీఁవ తా జర్గు జలిసి ఎత్కి దెకితె తిల. ");
INSERT INTO key_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","అరిమతయ్ మెంతి ఏక్ గఁవ్విచొ యోసేపు మెలొ ఎక్కిలొ తిలొ. యూదుల్‍చి వెల్లి తగుతె వెసితొసొ జయెదె, జో, చెంగిలొ సత్తిమ్‍చొ మాన్సు జయెదె. ");
INSERT INTO key_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","జేఁవ్ అన్నె వెల్లెల సుదల్ యేసుచి ఉప్పిరి కుట్ర కెర్లిస్‍తె జో బెదె నాయ్, జోక ఇస్టుమ్ నాయ్ చి, ‘ఎత్కి అదికారుమ్ తిలొ దేముడుచి రాజిమ్ కెఁయఁక ఎదార్దుమ్ డీసెదె, జా రాజిమ్‍చొ క్రీస్తు రానొ ఏలుప కెరెదె?’ మెన జో రకితె తిలన్. ");
INSERT INTO key_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ఈంజొ మాన్సు, జలె, పిలాతు అదికారితె గెచ్చ కెర, “యేసుచి పీనుమ్ అంక దె” మెన జా ఉత్రవ వెంట గెల్తి రిసొ సెలవ్ నఙిలన్, ");
INSERT INTO key_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","అన్నె, ఉత్రవ కెర, జోచి ఉప్పిరి చెంగిల్ విలువ బట్ట గండ పంగ్రవ కెర, కక్క అగ్గె నే రోవ తిలి సాప్రయ్ డొల్మి కెర్లి మెస్సున్‍తె రోవ దిలన్. ");
INSERT INTO key_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","కేన్ దీసి దస్సి కెర్లన్ మెలె, యూదుల్‍చి సెలవ్ కడన్లి దీసిక బోగి జయెదె. ");
INSERT INTO key_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","యేసుక సవ్రెచన కెరుక మెన అగ్గె గలిలయ ప్రాంతుమ్ తెంతొ జో తెన్ బెద జా తిల తేర్‍బోదల్ జలె, యోసేపుచి పట్టి జా తిల, మెస్సున్ దెక, యేసుచి పీనుమ్ కీసి ఎంగ్డవ దిల గే దెకిల. ");
INSERT INTO key_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","దెక కెర, జేఁవ్ తతా గెరలె గెచ్చ కెర, జోక పడ్తొ గాఁసుక మెన చెంగిల వాసెన తేల్లు తెయార్ కెర్ల. అన్నె దేముడు మోసే తెన్ దిలి ఆగ్నల్‍తె రెగిడ్లి రితి సెలవ్ కడన్లి దీసి తుక్లె తిల. ");
INSERT INTO key_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","సెలవ్ కడన్లి దీసి రాత్ పాయితె తతికయ్, జేఁవ్ తేర్‍బోదల్ జేఁవ్ తెయార్ కెర్ల వాసెన తేల్లు దెరన మెస్నె గెల. ");
INSERT INTO key_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","జలె, ఒత్త పాఁవిలె, కిచ్చొ దెకిల మెలె, జా సాప్రయ్ డొల్మి కెర్లి మెస్సున్ పెసితి వాట్‍క డంక తిలొ వెల్లొ పత్తురు ఒస్సుల్ జా అస్సె మెన దెకిల, ");
INSERT INTO key_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","పెసిలె, యేసుచి పీనుమ్ జేఁవ్‍క డీసె నాయ్. ");
INSERT INTO key_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","జలె, యేసుచి పీనుమ్ అప్పె నెంజిలిస్‍చి రిసొ కిచ్చొ ఉచరుక గే జేఁవ్ నేన తతికయ్, ఈందె, దగదగాల్న మెర్సుప జల పాలల్ గలన్ల దొగుల ఉబెడల్ రిత దూతల్ జోవయించి పాసి టీఁవిల. ");
INSERT INTO key_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ఈంజేఁవ్ తేర్‍బోదల్ బియఁ గెచ్చ బుఁయి పక్క దెకితె తతికయ్, జేఁవ్ దూతల్ జోవయింక కిచ్చొ మెల మెలె, “జీవు తిలొసొక కిచ్చొక మెస్నె చజితసు? జో ఇన్నె నాయ్. జో జీవ్ జా ఉట్ట అస్సె. ");
INSERT INTO key_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ఈందె, జో తెదొడి గలిలయతె తా ఒత్త తెంతొ నే బార్ జతె అగ్గె తుమ్‍క సంగిలిసి తుమ్ ఏద కెర.” ");
INSERT INTO key_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","కిచ్చొ మెలె, “ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొక విరోదుమ్ సుదల్ అన్నె పాపుమ్ సుదల్‍చి అత్తి సొర్ప కెర దెంక అస్సె చి, జేఁవ్ అంక సిలువతె టీఁవడ మారుక అస్సె, చి తిర్రత్‍క ఆఁవ్ అన్నె జీవ్ జా ఉట్టుక అస్సె, మెన సంగిలన్, గెద” మెన దూతల్ సంగిల. ");
INSERT INTO key_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","జేఁవ్ తేర్‍బోదల్ యేసుచ తెదొడ్‍చ కొడొ ఏదస్ట కెర్ల, ");
INSERT INTO key_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","అన్నె, మెస్నె తెంతొ పసుల ఉట్ట గెచ్చ, ఎగరజిన్ యేసుచ సిస్సుల్‍క చి జోవయింక నంపజల అన్నె ఎత్కిజిన్‍క జా కబుర్ సంగిల. ");
INSERT INTO key_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","జేఁవ్ ఎగరజిన్ యేసుచ బారికుల్‍క జో జీవ్ జా ఉట్లిస్‍చి రుజ్జు సంగిల జేఁవ్ తేర్‍బోదల్ కొన్స మెలె, మగ్దల గఁవ్విచి మరియ, యోహన్న, యాకోబుచి అయ్యసి మరియ, చి జోవయింతెన్ తిల అన్నె తేర్‍బోదల్. ");
INSERT INTO key_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","జేఁవ్ సంగిలిస్‍క ‘వెర్రి కోడు’ మెన ఈంజేఁవ్ ఎగరజిన్ ఉచర నంప కెర్తి నాయ్. ");
INSERT INTO key_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","గని పేతురు ఉట్ట కెర, మెస్సున్‍తె నిగ గెలొ, అన్నె ఒత్త పాఁవ వంపొ జా తెడి దెకిలె, యేసుచి పీనుమ్‍క అగ్గె పంగ్రవ తిలి బట్టయ్, గని పీనుమ్ నాయ్, కిచ్చొ నాయ్. జలె, జర్గు జలిస్‍క ఆచారిమ్ జా ఉచరన ఉచరన, గెరి ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","జయ్యి దీసి, యేసుచ సిస్సుల్ జల దొగుల ఎమ్మాయు మెంతి గఁవ్వి గెతె తిల. జా గాఁవ్ యెరూసలేమ్ పట్నుమ్‍క ఎగర కిలొమిటర్లు దూరి తయెదె. ");
INSERT INTO key_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","జర్గు జలిస్ ఎత్కిచి రిసొ జేఁవ్ దొగుల లట్టబ్తె తిల, ");
INSERT INTO key_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","జలె, జేఁవ్ దస్సి లట్టబ్తె తతికయ్, యేసు సొంత జా వాట్ జా జోవయింతె పాఁవ కెర, జోవయింతెన్ బెద ఇండుక దెర్లన్. ");
INSERT INTO key_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","జలె, జోక దెకిలెకి, జోక జేఁవ్ చినుక అడ్డు కెర్తె తిలన్, చి చినితి నాయ్. ");
INSERT INTO key_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","తెదొడి యేసు జోవయింక “తుమ్ ఇండ ఇండ, కిచ్చొచి రిసొ ఎక్కిలొ తెన్ ఎక్కిలొ లట్టబ్తె అస్సుస్?” మెన పుసిలన్ చి, జేఁవ్ ముసుర్న జా ఇదిలిస్ మొకొమ్ కెరన అస్తి. ");
INSERT INTO key_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","జోవయింతె ఎక్కిలొ క్లెయొపా మెలొసొ. జో, జలె, “ఈంజ మదెనె యెరూసలేమ్‍తె జర్గు జలిసి ఒత్త అయ్‍లస ఎత్కిజిన్ జాన్‍తి. ఎక్కి తుయి నేన్సి గె?” మెన జోచి ఆచారిమ్ సంగిలొ. ");
INSERT INTO key_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","యేసు జోవయింక “కిచ్చొ జర్గు జలిసి?” మెలన్, చి జేఁవ్ జోక నజరేతు గఁవ్విచొ యేసుచి రిసొ జర్గు జలిసి. జో దేముడుచ కబుర్లు సంగితొసొ జా తిలొ. జో కెర్లి బోదన, జో కెర్ల వెల్లెల కమొ, దేముడు దిలస చి, జోచి బోదన జోచ కమొక ఎత్కిజిన్ ప్రెజల్ నంప కెర తిల. ");
INSERT INTO key_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","గని అమ్‍చ వెల్లెల పూజర్లు చి అమ్‍చ అదికారుల్ ‘జో మొర్తి సిచ్చ జవుస్ తుమ్ మొర్తి సిచ్చ తియ’ రోమ్ దేసిమ్‍చ అదికారుల్‍చి అత్తి సొర్ప కెర దిల చి, సిలువతె టీఁవడ మార్ల. ");
INSERT INTO key_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ఆమ్, జలె, జోక “‘అమ్‍చ ఇస్రాయేలుల్‍క రచ్చించుప కెరుక తిలొసొ జొయ్యి’ మెన ఆస జా తిలమ్. అన్నె, అమ్ సంగిలిసి జర్గు జలి తెంతొ, జో మొర్లి తెంతొ, అప్పె తిర్రతి జా అస్సె. ");
INSERT INTO key_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","అన్నె కిచ్చొ మెలె, అమ్‍చి తెన్ బెదిత సగుమ్‍జిన్ తేర్‍బోదల్ ఆజి అమ్‍క ఆచారిమ్‍చి కోడు సంగిల. రాత్ పాయితె తతికయ్. జేఁవ్ మెస్నె గెల చి, ");
INSERT INTO key_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ఒత్త యేసుచి పీనుమ్ డీసె నాయ్, చి అమ్‍తె జా కెర అన్నె కిచ్చొ మెల మెలె, దూతల్ అమ్‍క డీసన్ సేడ్ల చి, యేసుక ‘జీవ్ జా ఉట్ట అస్సె’ మెన అమ్‍క సంగిల మెల. ");
INSERT INTO key_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","అమ్‍చితె తిలస సగుమ్‍జిన్ మెస్నె గెచ్చ దెకిల చి, జేఁవ్ తేర్‍బోదల్ సంగిల్ రితి తిలి. గని యేసుక, దెకితి నాయ్” మెన జేఁవ్ దొగుల సంగిల. ");
INSERT INTO key_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","యేసు జోవయింక, “కిచ్చొ గ్యానుమ్ నెంజిలస, తుమ్! దేముడుచ కబుర్లు సంగిల పూర్గుల్‌చ కొడొ అర్దుమ్ కెరనుక నంప కెరుక ఆల్సిమ్ కెర్తసు, కిచ్చొక? ");
INSERT INTO key_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","క్రీస్తు రచ్చించుప కెర్తొసొ దస బాదల్ సేడ జో గవురుమ్ జతిస్‍తె గెచ్చుక దొర్కు జలి, గెద” మెన, ");
INSERT INTO key_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","మోసే చి అత్తి రెగిడ్లి దేముడుచ ఆగ్నల్, అన్నె దేముడుచ కబుర్లు సంగిల పూర్గుల్‍చి అత్తి రెగిడ్ల, జోచి రిసొచ దేముడుచ కొడొతె రెగిడ్ల ఎత్కిచి అర్దుమ్ యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","జలె, జేఁవ్ గెతి గాఁవ్ పాసి జా జెతికయ్, యేసు అన్నె దూరి గెచ్చుక మెలి రితి జలొ, ");
INSERT INTO key_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","గని, “సాంజ్ జలి. పొద్దు గెతయ్. అమ్‍చి తెన్ ఇన్నె తుయి నిద్ర తా” మెన జోక బతిమాల్ప జా సంగిల, చి జేఁవ్ తతిస్‍తె బెద గెలన్. ");
INSERT INTO key_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","జలె, జోవయింతెన్ అన్నిమ్ కంక మెన వెసిలొ, అన్నె, ఏక్ పోడి అత్తి దెరన ‘ఈంజ తుయి దా దయ కెర్లది’ మెన దేముడు అబ్బొస్‍క జొఒర సంగ కెర, జా పోడి మోడ కెర, జోవయింక వంట దిలన్. ");
INSERT INTO key_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","దస్సి కెర్తికయ్, జోవయించ అంకివొ టేంట జల చి, అర్దుమ్ అయ్‍లి చి జోక చినిల. చినిలి బేగి, యేసు మాయ జా ఉట్ట గెలొ. ");
INSERT INTO key_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","దస్సి జర్గు జతికయ్. “నిజుమి, అమ్ వట్టె జో తెన్ జెతె తిలి పొది, దేముడుచ కొడొచి అర్దుమ్ అమ్‍క జో దెకయ్‍తె తిలి పొది అమ్‍చి పెట్టి డడ్డిల్ రితి సర్ద తిలి, గెద” మెన లట్టబన్ల. ");
INSERT INTO key_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","జోవయించి ఒగ్గర్ సర్దక బేగి ఉట్ట జయ్యి గడియయ్ బార్ జా యెరూసలేమ్ పట్నుమ్‍తె అన్నె గెల. ఒత్త పాఁవ కెర, ఎగరజిన్ యేసుచ సిస్సుల్‍క చి జోవయింతెన్ తిలసక చజిల చి, ");
INSERT INTO key_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","జేఁవ్ ఈంజేఁవ్ దొగులక కిచ్చొ మెల మెలె, “ప్రబు నిజుమి జీవ్ జా ఉట్ట అస్సె. సీమోనుక డీసిలన్!” మెన జేఁవ్ సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","యేసు ఎమ్మాయుస్‍తె గెతి వట్టె దస్సుల్ జలిసి అన్నె పోడి మోడ్తికయ్ ఈంజేఁవ్ జోక చినిలిసి ఈంజేఁవ్ జోవయింక సంగిల. ");
INSERT INTO key_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","జేఁవ్ దస్సి లట్టబంతె తతికయ్, యేసు డీస జోవయించి నెడిమి టీఁవిలన్, అన్నె, “తుమ్‍క సేంతుమ్ తవుస్. తుమ్ బమ్మ జా నాయ్. ఆఁవ్వి, గెద” మెలన్. ");
INSERT INTO key_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","గని జేఁవ్ బియఁ గెచ్చ బమ్మ జల. జోక ‘డుంబొ’ మెన ఉచర్ల. ");
INSERT INTO key_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","జో, జలె, జోవయింక “తుమ్ కిచ్చొక బమ్మ జతసు? తుమ్‍చి పెట్టి కిచ్చొక అన్మానుమ్ జతసు? ");
INSERT INTO key_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","అంక సిలువతె గలిలి పొది జేఁవ్ అంచ అత్తిలె చట్టెలె పెట్ల మేకుల్‍చ మచ్చల్ దెక అంక తుమ్ చిన. ఆఁవ్వి గెద. అంక చడ దెక. డుంబొక ఆఁగ్ తయె నాయ్ అడ్డొ తయె నాయ్, గెద, గని అంక అస్సె.” ");
INSERT INTO key_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","మెన జోచ అత్తొ చట్టొ జోవయింక దెకయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","జలె, జోవయించి సర్దసంతోసుమ్, జోవయించి ఆచారిమ్‍క జేఁవ్ తెదొడి ఎద నంప కెరుక ఇదిల్ అల్లర్ జలి రిసొ, “ఇన్నె కిచ్చొ జలెకు కతిసి అస్సె గె?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","మొస్సొ గండ దిల, ");
INSERT INTO key_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","జో డుంబొ నెంజిలిస్‍చి రుజ్జుక జో నఙన జోవయించి మొక్మె కయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","తెదొడి జోవయింక, “ఆఁవ్ తుమ్‍చి తెన్ తిలి పొది, ‘మోసే పూర్గుమ్‍చొచి అత్తి దేముడు రెగ్డయ్‍ల ఆగ్నల్‍తె అంచి రిసొ మోసే పూర్గుమ్‍చొచి అత్తి రెగిడ్లి దేముడుచ ఆగ్నల్, దేముడుచ కబుర్లు సంగిల పూర్గుమ్‍చచి కోడు, చి కీర్తనల్‍తె రెగిడ్లిసి ఎత్కి కచితుమ్ పూర్తి జర్గు జంక అస్సె’ మెన సంగిలయ్, గెద” మెన సంగ కెర, ");
INSERT INTO key_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","దేముడుచ కొడొతె తిలిసి జేఁవ్ అర్దుమ్ కెరంతి రితి అర్దుమ్ దెకయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","జోవయింక కిచ్చొ మెలన్ మెలె, “దేముడుచి కోడుతె రెగ్డయ్‍లిసి కిచ్చొ మెలె, ‘దొర్కు జలొ క్రీస్తు రచ్చించుప కెర్తొసొ ఒగ్గర్ బాదల్ సేడ మొర తిర్రత్‍క అన్నె జీవ్ జా ఉట్టుక అస్సె’ మెన అస్సె. అన్నె, ‘కచితుమ్ జర్గు జయెదె’ మెన దేముడుచి అప్పెచి సెలవ్ కిచ్చొ మెలె, ");
INSERT INTO key_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","మాన్సుల్ జేఁవ్ కెర్ల పాపల్ చినన జేఁవ్ పాపల్‍క దుకుమ్ జా ఒప్పన ములిలె, క్రీస్తు దొర్కు జలి అర్పితుమ్ జలిస్‍చి రిసొ అప్పె జేఁవ్ కెర్ల పాపల్ చెమించుప జతి వాటు దొర్కు జా అస్సె మెన ఆఁవ్ క్రీస్తుచి నావ్ తెన్ తొలితొ యెరూసలేమ్‍తె పడ్తొ ఒండి లోకుమ్‍చ ప్రెజల్ ఎత్కిచ మాన్సుల్‍తె తుమ్ బోదన కెరుక అస్సె. ");
INSERT INTO key_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ఈంజ ఎత్కిచి రిసొ సాచుల్ జా అస్సుస్, చి తుమ్ బుల సాచి సంగుక అస్సె. ");
INSERT INTO key_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ఈందె, అంచొ దేముడు అబ్బొ ‘జోవయించి పెట్టి తెద్రయిందె’ మెన సంగ తిలి జోచి పరలోకుమ్‍చి దేముడుచి సుద్ది తిలి ఆత్మ తుమ్‍చి పెట్టి తెద్రయిందె, గని పరలోకుమ్ తెంతొ చి జా ఆత్మసెక్తి తుమ్‍చి పెట్టి జా తుమ్‍క తెయార్ కెర్తె ఎదక, ఈంజ మదెనె ఈంజ యెరూసలేమ్ పట్నుమ్‍తె తుమ్ రకితె తా” మెన యేసు జేఁవ్ ఎగరజిన్‍క చి ఒత్త తిల జోక నంపజల అన్నె మాన్సుల్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","తెదొడి యేసు జోవయించ సిస్సుల్‍క కడన, బేతనియ గాఁవ్ పక్క గెల చి, అత్తొ ఉక్కుల జోవయింక దీవెన దిలన్. ");
INSERT INTO key_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","జో దస్సి జా దీవెన దెతె తా, జోవయించి నెడిమి తెంతొ ముల ఉక్కిల్ జా పరలోకుమ్‍తె ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","తెదొడి జేఁవ్ సెర్ను సేడ జోక బక్తి కెర తా ఒగ్గర్ సర్దసంతోసుమ్ తెన్ యెరూసలేమ్‍తె అన్నె గెల. ");
INSERT INTO key_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","రోజుక దేముడుచి గుడితె గెచ్చ, యేసుచి రిసొ జో దేముడుచి గవురుమ్ సంగితె తిల.");
INSERT INTO key_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","మొదొల్ తెంతొ కి దేముడుచి కోడు తిలొ. కిచ్చొ జెర్మున్ నెంజిలి పొది తెంతొ కి జా కోడు దేముడు తెన్ తిలొ. జా కోడుయి దేముడు జా తిలొ. ");
INSERT INTO key_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","జొయ్యి కిచ్చొ నెంజిలి జా పొది దేముడు తెన్ తిలొ. ఎత్కి జోచి అత్తి కల్గుప జలి. ");
INSERT INTO key_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","తిలిసి ఎత్కి జో నెంజితె జెర్మున్ జయె నాయ్. ");
INSERT INTO key_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","జోచితె జీవు తిలి, జా జీవు మాన్సుల్‍క ఉజిడి జా అస్సె. ");
INSERT INTO key_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","జా ఉజిడి అందర్‍తె ఉజిడి దెతె అస్సె గని అందర్ జా ఉజిడిక చినన్‍క నెతిర్తయ్. ");
INSERT INTO key_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","దేముడు తెద్రయ్‍తికయ్, ఏక్ మాన్సు బార్ జలన్. జోవయించి నావ్ యోహాను. ");
INSERT INTO key_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","జో సాచి సంగుక అయ్‍లన్. ఎత్కిజిన్ క్రీస్తుక నంపజా పాపుమ్ తెంతొ రచ్చించుప జతు మెన, ‘దొర్కు జలి ఉజిడి యేసుక్రీస్తుయి’ మెన సాచి సంగుక అయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","యోహాను, జలె, జా ఉజిడి నెంజె, గని ‘క్రీస్తుయి దొర్కు జలి జా ఉజిడి’ మెన సాచి సంగుక అయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ఈంజ లోకుమ్‍తె జెర్మిత ఎత్కి మాన్సుక ఉజిడి దెతి నిజుమ్ జలి ఉజిడి ఈంజ లోకుమ్‍తె జెతె అస్సె. ");
INSERT INTO key_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","జలె, ఈంజ లోకుమ్‍తె జో తిలొ. ఈంజ లోకుమ్ జోచి అత్తి జెర్మున్ జలి, గని ఈంజ లోకుమ్‍చ మాన్సుల్ జోక చినితి నాయ్. ");
INSERT INTO key_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","జోచి సొంత గేర్‍చి మాన్సుల్‍తె జో అయ్‍లన్, గని జోచి సొంత మాన్సుల్ జోక ఒప్పన్‍తి నాయ్, నంపజతి నాయ్. ");
INSERT INTO key_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","దస్సి జలి పొది సగుమ్‍జిన్ జోక ఒప్పన బెదవన నంపజా గెల. జోవయింకయి, జలె, ‘తెదొడి తెంతొ దేముడుచ బోదల్ తుమ్ జలదు’ మెన సెలవ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","జోచ బోదల్ జతి జెర్మున్, జలె, కేన్ సెకుమ్‍తె జెర్మిలి రిసొ జర్గు జలిసి నెంజె, కేన్ తేర్సి మున్సుసి ఆఁగ్‍క ఆసచి రిసొ జెర్మున్ జలిసి నెంజె. ఈంజ దేముడుచి దయచి రిసొ జోచి ఆత్మసెక్తి దిలి రిసొచి జెర్మిలస. ");
INSERT INTO key_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","జలె, దేముడుచి కోడు ఈంజ లోకుమ్‍తె మాన్సు జా జెర్మున్ జా అమ్ మాన్సుల్ తెన్ బెద జిలన్. పూర్తి దయ, పూర్తి సత్తిమ్ తా అమ్‍చి తెన్ జిలన్, చి జోచి పరలోకుమ్‍చి ఉజిడి దెకిల్ రితి జలమ్, చి ‘దేముడు తెంతొ అయ్‍లొ దేముడుచొ ఎక్కి పుత్తుసి ఈంజొయి’ మెన అమ్‍క నిజుమి రుజ్జు అయ్‍లి. ");
INSERT INTO key_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","జోచి రిసొ “‘అంచి కంట పడ్తొ జెతొసొ అంచి కంట వెల్లొ. కిచ్చొక మెలె, అంచి కంట జో అగ్గెయ్ తిలొసొ’ మెన ఇన్నెచి రిసొయి సంగిలయ్” మెన యోహాను సాచి జా కేక్ గల సాట్ప కెర్తె తిలొ. ");
INSERT INTO key_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","జోచి ఎదివాట్ బెర్తుతె తిలి దయ తెంతొ అమ్ ఎత్కిజిన్ దయ పడ్తొ దయ పాయ అస్సుమ్. ");
INSERT INTO key_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","మోసే పూర్గుమ్‍చొచి అత్తి దేముడుచ ఆగ్నల్ అగ్గె తెంతొ అమ్‍క దా అస్సె, గని దేముడుచి దయ, నిజుమ్ యేసుకీస్తుచి అత్తి దొర్కు జలి. ");
INSERT INTO key_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","కేన్ మాన్సుకి కెఁయ్య కి దేముడుక దెకిత్ నాయ్. మాన్సు జోక దస్సే దెకుక నెంజితయ్. జాకయ్, జోచి పక్కయ్ తిలొ దేముడుచొ ఎక్కి పుత్తుసి, ఈంజ లోకుమ్‍తె జెర్మ అమ్‍చి తెన్ జిఁయ, అబ్బొసి కీసొచొ గే అమ్‍క దెకవ అస్సె, చి అబ్బొస్‍క దెకిల్ రితి జా అస్సుమ్. ");
INSERT INTO key_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","యెరూసలేమ్ పట్నుమ్‍చ యూదుల్‍చ వెల్లెల మాన్సుల్ ‘తుయి కో?’ మెన పుసితి రిసొ, జోవయించ పూజర్లుక చి దేముడుచి గుడిచి సేవ కెర్తి లేవీ పూర్గుమ్‍చొచి సెకుమ్‍చ మాన్సుల్ సగుమ్‍జిన్‍క బాప్తిసుమ్ దెతె తిలొ యోహానుతె తెద్రయ్‍ల. ");
INSERT INTO key_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","జేఁవ్ జోక ‘తుయి కో’ మెన పుసితికయ్, జో అబద్దుమ్ జయె నాయ్. జో కీసి సాచి జలొ మెలె, “ఆఁవ్ క్రీస్తు నెంజి” మెన సత్తిమ్ ఒప్పన్లన్. ");
INSERT INTO key_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","దస్సి ఒప్పన్‍తికయ్, “దస్సి జలె, దేముడుచ కబుర్లు సంగిలొ ఏలీయా పూర్గుమ్‍చొ ఏక్ వేల జస్తె గే?” మెన పుసిల. పుసిలె, “నెంజి” మెన సంగిలన్, చి “దస్సి జలె, దేముడుచ కబుర్లు సంగుక జెంక తిలొ జో అన్నెక్లొ జస్తె గే?” మెన పుసిల, గని అన్నె “నెంజి” మెన యోహాను సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","జోక జేఁవ్ అన్నె, “దస్సి జలె, తుయి కొన్సొ? అమ్‍క తెద్రయ్‍ల వెల్లెల మాన్సుల్‍క అమ్ సంగుక అస్సె. కొన్సొ మెన తుయి సంగితసి?” మెన జో తెన్ పుసిల. ");
INSERT INTO key_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","జో జోవయింక, “యెసయా పూర్గుమ్‍చొచి అత్తి దేముడు రెగ్డయ్‍లి ‘ప్రబు జెంక వాట్ సోగ కెర!’ మెన బయిలె ప్రదేసిమి కేక్ గల ప్రబుచి అవాడ్ ఆఁవ్. మెన రెగ్డ అస్సె, గెద. ఆఁవ్ ఎక్కి జో” మెన యోహాను సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","పిమ్మట్ యోహానుక జేఁవ్ పరిచ్చ కెర్లస, జలె, పరిసయ్యుల్ తెంతొ జా అస్తి, ");
INSERT INTO key_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“తుయి క్రీస్తు నెంజిలె, ఏలీయా నెంజిలె, దేముడుచ కబుర్లు సంగిలొ అన్నెక్లొ కి నెంజిలె, తుక కిచ్చొ అదికారుమ్ తయెదె, చి బాప్తిసుమ్ దెతసి?” మెన జేఁవ్ పుసిల. ");
INSERT INTO key_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","యోహాను, జలె, “ఆఁవ్ జలె, మాన్సుల్‍క పానితె బాప్తిసుమ్ దెతసి, గని తుమ్‍చి నెడిమి తుమ్ నేన్లొ ఎక్కిలొ టీఁవ అస్సె. ");
INSERT INTO key_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","జో అంచి కంట పడ్తొ జెంక తిలొసొ. జో అంచి పడ్తొ అయ్‍లె కి, జో కెద్ది ముక్కిమ్‍చొ మెలె, జోచ జోడ్లుచ వాలివొ యిపుక అంక విలువ నాయ్!” మెన జేఁవ్‍క ఇసి సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ఈంజ ఎత్కి యోర్దాను గాడుక తూర్పు పక్కచి ఒడ్డుతెచి బేతనియ మెలి ఏక్ టాన్‍తె జర్గు జలి. ");
INSERT INTO key_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","అన్నెక్ దీసి, యేసు పాసి తతికయ్, యోహాను జోక దెక, “ఈంజ లోకుమ్‍చ చి పాపుమ్ వయ గెచ్చయ్‍తొ అమ్‍చొ దేముడు దిలొ మెండపిల్ల జలొసొ ఓదె!” మెన సంగిలొ. అన్నె, ");
INSERT INTO key_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","“ఇన్నెచి రిసొయి ఆఁవ్ సంగిలి, ‘జో అంచి పడ్తొ జెర్మిలెకి, అంచి కంట అగ్గెయ్ తెంతొ తిలొసొ, చి రిసొ అంచి కంట వెల్లొ జయెదె’ మెలయ్. ");
INSERT INTO key_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ఈంజొ కొన్సొ గే ఆఁవ్ కి అగ్గె నేన్లయ్, గని ఆఁవ్ అయ్‍లిసి జోచి రిసొయి. ఇస్రాయేలులు ఇన్నెక ‘అమ్‍చొ రచ్చించుప కెర్తొసొ’ మెన చినుతు మెన, పాపుమ్ జో గెచ్చయ్‍తి రిసొ పానితె మాన్సుల్‍క బాప్తిసుమ్ దెతసి.” ");
INSERT INTO key_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","తెదొడి యోహాను అన్నె కిచ్చొ సాచి సంగిలన్ మెలె, “దేముడుచి సుద్ది తిలి ఆత్మ పార్వ పిట్టచి రితి జా, ఆగాసుమ్ తెంతొ ఉత్ర జా, జోచి ఉపీర్ టీఁవిలిసి ఆఁవ్ దెకిలయ్. ");
INSERT INTO key_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ఆఁవ్ జోక ‘జొయ్యి’ మెన నేన్లయ్. నేన్‍తయ్, గని పానితెచి బాప్తిసుమ్ ఆఁవ్ దెంక మెన అంక తెద్రయ్‍లొ జో అమ్‍చొ దేముడు కిచ్చొ గుర్తు సంగ తిలొ మెలె, ‘అంచి ఆత్మ ఉత్ర జా ఎక్కిలొచి ఉప్పిర్ టీఁవెదె, కచి ఉప్పిరి ఉత్ర జా టీఁవెదె గే, అంచి పరలోకుమ్‍చి సుద్ది తిలి ఆత్మక జోక నంపజలసక జొయ్యి బాప్తిసుమ్ దా కెరెదె.’ ");
INSERT INTO key_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","జలె, జోక ‘దేముడుచొ పుత్తుసి ఈంజొయ్’ మెన ఆఁవ్ రుజ్జు దెక అస్సి, సాచి జా అస్సి” మెన ఒత్త తిలసక యోహాను సాచి సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","అన్నెక్ దీసి, యోహాను జోచి దొగుల సిస్సుల్ తెన్ టీఁవ తతికయ్, ");
INSERT INTO key_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","యేసు జా వాట్ ఇండ గెతె తతికయ్, యోహాను జోక దెక, “పాపుమ్ గెచ్చయ్‍తొ దొర్కు జలి దేముడుచి మెండపిల్ల, ఓదె!” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","యోహానుచ జేఁవ్ దొగుల సిస్సుల్, జలె, సూన కెర, యేసుచి పట్టి గెచ్చుక దెర్ల. ");
INSERT INTO key_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","జలె, యేసు పస్ల, జేఁవ్ పట్టి జెతె తిలిసి దెక కెర, జోవయింక “కిచ్చొ చజితసు?” మెన పుసిలన్, చి జేఁవ్ ‘గురుబాబు’ మెలి అర్దుమ్ తెన్ జోవయించి అరమయ్ బాస తెన్ “రబ్బీ” మెన సంగ, “కేనె బస జా అస్సిసి?” మెన జోక పుసిల. ");
INSERT INTO key_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","జో “జొమ్మ. జా, దెక” మెన సంగిలన్, చి జేఁవ్ జో తెన్ గెచ్చ, జో బస జలి టాన్ దెకిల. జలె, పాసి పాసి చెత్తర్ గంటల్ సంజె జలి రిసొ, జా దీసి జేఁవ్ దొగుల యేసుతె తా గెల. ");
INSERT INTO key_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","యోహానుచి జా కోడు సూన యేసుచి పట్టి గెల జేఁవ్ దొగులతె ఎక్కిలొ అంద్రెయ మెలొసొ జయెదె. జో కొన్సొ మెలె, సీమోను పేతురుచొ బావొసి. ");
INSERT INTO key_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","జో జలె, అన్నెక్ దీసి పెందలె కిచ్చొ తొలితొ కెర్లన్ మెలె, సీమోను మెలొ జోచొ అన్నొస్‍క చజ కెర, “మెస్సయక జలె క్రీస్తుక చజ దెక అస్సుమ్!” మెన సంగిలన్. ‘మెస్సయ’ మెన జా బాస తెన్ సంగిలె, గ్రీకు బాస తెన్ ‘క్రీస్తు’ మెలి అర్దుమ్ తయెదె. ");
INSERT INTO key_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","దస్సి సంగ, సీమోనుక అంద్రెయ యేసుతె కడ ఆన్లొ. కడ ఆన్‍తికయ్, యేసు సీమోనుక చెంగిల్ దెక, “యోహాను మెలొ ఎక్కిలొచొ సీమోను మెలొ పుత్తుసి, తుయి. జలె, అప్పె తెంతొ తుక ‘కేపా’ మెన నావ్ తితసి” మెన సంగిలన్. ‘కేపా’ మెన అరమయ్ బాస తెన్ సంగిలె, గ్రీకు బాస తెన్ ‘పేతురు’ జయెదె. ");
INSERT INTO key_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","అన్నెక్ దీసి, గలిలయ ప్రాంతుమ్‍తె ఉట్ట గెచ్చిందె మెన యేసు ఉట్ట గెలన్. ఒత్త పాఁవ కెర, పిలిప్ మెలొ ఎక్కిలొక చజ కెర, “అంచి పట్టి జా అంచొ సిస్సుడు జా” మెన, యేసు జోక బుకార్లన్. ");
INSERT INTO key_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","పిలిప్ బేత్సయిదా పట్నుమ్‍చొ. అంద్రెయ పేతురు కి జయ్యి పట్నుమ్‍చ. ");
INSERT INTO key_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","జలె, నతనియేలు మెలొ ఎక్కిలొక పిలిప్ చజ కెర, “అమ్‍చొ, మోసే పూర్గుమ్‍చొచి అత్తి దేముడు రెగ్డయ్‍లి ఆగ్నల్‍తె, క్రీస్తుచి రిసొ రెగిడ్లొ, గెద. అమ్‍చొ దేముడుచ కబుర్లు సంగిల పూర్గుమ్‍చ కి జోవయించి రిసొ రెగిడ్ల, గెద. జలె, జో క్రీస్తుక అమ్ చజ అస్సుమ్. జో కొన్సొ మెలె, నజరేతు గఁవ్విచొ యోసేపుచొ యేసు మెలొ పుత్తుసి. జొయ్యి” మెన నతనియేలుక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","సంగిలె నతనియేలు అన్మానుమ్ జా “నజరేతు గఁవ్వి తెంతొ కిచ్చొ జలెకు చెంగిల్ తిలిసి బార్ జయెదె గే?” మెన పుసిలన్, గని పిలిప్ జోక “తుయి జా కెర, సొంత దెకు!” మెన జోక యేసుతె కడ ఆన్లొ. ");
INSERT INTO key_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","జలె, నతనియేలు పాసి జెతె తతికయ్, యేసు జోక దెక జోచి రిసొ “ఈందె, సత్తిమ్ తిలొ ఇస్రాయేలుడు, ఈంజొ. ఇనాచితె కిచ్చొ ఉప్రమెన్సు నాయ్!” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","దస్సి సంగితికయ్, నతనియేలు ఆచారిమ్ జా “తుయి కీసొ మాన్సుచి అంచి బుద్ది చినిలది?” మెన యేసుక పుసిలన్, చి యేసు జోక “పిలిప్ తుక నే బుకార్తె అగ్గె, తుయి జో రూక్ మొదొలె వెస తిలి పొది తుక ఇన్నె తెంతొ దెకిలయ్” మెన జబాబ్ దిలన్, చి ");
INSERT INTO key_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","నతనియేలు జోక “గురుబాబు, దేముడుచి పెట్టిచొ దేముడు పుత్తుసి, తుయి! అమ్‍చ ఇస్రాయేలులుచొ రానొ, తుయి!” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","యేసు జోక “‘ఆఁవ్ తుక రూక్ మొదొలె దెకిలయ్’ మెన సంగిలి రిసొ తుయి అంక నంప కెర్లది, గెద. ఇన్నెచి కంట అన్నె వెల్లెల కమొ దెకితె” మెన సంగ యేసు అన్నె, ");
INSERT INTO key_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","“జలె, ఆఁవ్ తుక కిచ్చొ నిజుమి కచితుమ్ సంగితసి మెలె, పరలోకుమ్ ఉగ్డి జతిసి, చి ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొచి ఉప్పిరి దేముడుచి దూతల్ పరలోకుమ్‍తె వెగితిసి చి పరలోకుమ్ తెంతొ ఉత్ర జెతిసి దెకితె” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","దొరతి గెతికయ్, గలిలయ ప్రాంతుమ్‍తెచి కానా మెంతి గఁవ్వి ఏక్ పెండ్లి జలి. యేసుచి అయ్యసి ఒత్త జా పెండ్లితె అస్సె. ");
INSERT INTO key_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","యేసుక, జోచ సిస్సుల్‍క కి పెండ్లితె బుకారా అస్తి. ");
INSERT INTO key_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","జలె, పెండ్లి విందుతె అయ్‍లస పితి ద్రాచ రస్సుమ్ ఎత్కి కేడ గెలి. యేసుచి అయ్యసి జోతె జా కెర, “విందుక అన్నె ద్రాచ రస్సుమ్ నాయ్” మెన సంగిలి. ");
INSERT INTO key_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","యేసు జాక “అంచి తెన్ తుక కిచ్చొ కామ్, అయ? అంచి సమయుమ్ అప్పెక కి జెంక నేతయ్” మెన అయ్యస్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","తెదొడి అయ్యసి, జా గెర్‍చ గొత్తి సుదల్‍క “తుమ్ కెరుక మెన ఈంజొ కిచ్చొ సంగెదె గే, జయ్యి కెర” మెన సంగిలి. ");
INSERT INTO key_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","జలె, ఒత్త పాని దెర్త పత్తుర్ బానల్ సొవ్వు అస్తి. ఏక్ బానొ, జలె, పుంజెక్ నెంజిలె పుంజెక్ యాబయ్ కాయల్ పాని దెరెదె. ఇస బానల్‍తె పాని కిచ్చొక ఒత్త తయెదె మెలె, యూదుల్ సుద్ది కెరంత అలవాట్లు చి రిసొ. ");
INSERT INTO key_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","యేసు, జలె, కిచ్చొ కెర్లన్ మెలె, “తుమ్ ఈంజేఁవ్ బానల్‍తె బెర్తు పాని సుఁవ” మెన, కామ్ కెర్తసక సంగిలన్. సంగితికయ్, జేఁవ్ బానల్‍తె పాని బెరయ్‍ల. ");
INSERT INTO key_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","తెదొడి జో “అప్పె, బానల్‍తె తిలిసి తుమ్ డుంబ కెర, విందు వంటితొ మాన్సుతె నా దాస” మెన సంగిలన్, చి జోక నా దిల. ");
INSERT INTO key_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","జలె, జా పాని ద్రాచ రస్సుమ్ మార్సుప జా అస్సె. ద్రాచ రస్సుమ్ మార్సుప జలి జా పానిచి రుసి జో విందు వంటితొ మాన్సు చక దెకిలన్. జా ద్రాచ రస్సుమ్ కేనె తెంతొ అయ్‍లి గే పాని డుంబిలసక ఎర్కె, గని విందు వంటితొ మాన్సుక ఎర్కె నాయ్. తెదొడి జో, ఆచారిమ్ జా, పెండ్లిబూలొక బుకారా కెర, జోక ");
INSERT INTO key_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“అమ్‍చి తెన్ ఇస విందుల్‍తె కో కి చెంగిలి రస్సుమ్ తొలితొ వంట దెవుల. మాన్సుల్ ఒగ్గర్ పిలి పడ్తొ, గర్చి రస్సుమ్ బార్ కెరుల. గని చెంగిల్‌చి ఆకర్‍క పితి రితి తుమ్ తిఁయ తిలదు. కీసి?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","గలిలయ ప్రాంతుమ్‍తెచి కానా మెంతి గఁవ్వి, యేసు ఈంజ వెల్లి కామ్ జర్గు కెర్లొ. జోవయించి అదికారుమ్ దెకయ్‍త వెల్లెల కమొ ఎత్కితె ఈంజయి తొలితొ చి. జోచ సిస్సుల్ జోచి ఉప్పిరి నముకుమ్ తిల. ");
INSERT INTO key_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ఒత్త తెంతొ యేసు, జోచి అయ్యసి, జోచ బావుడ్సులు, సిస్సుల్, ఇదిల్ ఉత్తర పక్కచి కపెర్నహూమ్ పట్నుమ్‍తె ఉట్ట గెచ్చ, ఒత్త సగుమ్ దీసల్ తా గెల. ");
INSERT INTO key_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","యూదుల్‍చి పస్కా పండుగు పాసి అయ్‍లి. ఈంజ పండుగ్‍చి రిసొ యెరూసలేమ్ పట్నుమ్‍తె యేసు ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","జలె, దేముడుచి గుడితె పెస కిచ్చొ దెకిలన్ మెలె, ‘అర్పితల్‍క’ మెన, బెయిలల్, గొర్రెలు, పార్వ పిట్టల్, దసచ వికుక బెర తిల మాన్సుల్‍క దెకిలన్. డబ్బుల్ పల్టయ్‍తసచి కామ్ కి దెకిలన్. ");
INSERT INTO key_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","తెదొడి, వాలివొ తెన్ కొర్డ తెయార్ కెర, జేఁవ్ ఎత్కిజిన్‍క, సొమ్ముల్‍క, గొర్రెల్‍క, ఎత్కి, దేముడుచి గుడి తెంతొ ఉదడ గెలన్, అన్నె డబ్బుల్ పల్టయ్‍తసచి డబ్బుల్ ఎత్కి వించ గెల కెర, జోవయించ బల్లల్ సేడవ దిలన్. ");
INSERT INTO key_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","దస్సి కెర, పార్వ పిట్టల్ వికితసక ఇసి మెన సంగిలన్: “ఈంజేఁవ్ ఎత్కి బయిలె దెర గెచ్చ! అంచొ దేముడు అబ్బొచొ గేర్‍క బియ్యార్ కెర్తి సంత రితి కెరుక జయె నాయ్!” మెన గోల కెర్లన్. ");
INSERT INTO key_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","జో దస్సి కెర్తికయ్, దేముడు పూర్గుమ్ రెగ్డయ్‍లి ఏక్ కోడు యేసుచ సిస్సుల్ ఏదస్ట కెర్ల. “తుచొ గేరు జతి దేముడుచి గుడి సుద్ది తా తుకయ్ తవుసు మెన అంచి జీవ్ డడ్డెదె” మెన దేముడు రెగిడ్లి కోడు. ");
INSERT INTO key_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","తెదొడి, దేముడుచి గుడిచ అదికారుల్ జల యూదుల్‍చ వెల్లెల మాన్సుల్ యేసుతె జా కెర, “తుయి అప్పె కెర్లి రితి కెరుక తుక కిచ్చొ అదికారుమ్? తుక అదికారుమ్ తిలె, అమ్‍క రుజ్జు దెకయ్‍తి రిసొ కిచ్చొ వెల్లి కామ్ కెర్తె?” మెన కోపుమ్ తెన్ సంగిల. ");
INSERT INTO key_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","యేసు, జలె, జోవయింక కిచ్చొ జబాబ్ దిలన్ మెలె, “ఈంజ దేముడుచి గుడి తుమ్ సేడవ గెల, చి తిర్రతి తెడి ఆఁవ్ అన్నె బందిందె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","యూదుల్‍చ జేఁవ్ వెల్లెల మాన్సుల్ “అప్పెక ఈంజ దేముడుచి గుడి బందుక దొన్ని విసొ సొవ్వు వెర్సుల్ దెర అస్సె. సేడయ్‍లెగిన, తుయి తిర్రత్‍క బందుక కీసి? నెతిర్సి!” మెన ఆఁసిల. ");
INSERT INTO key_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","గని, ‘దేముడుచి గుడి’ మెన జో కిచ్చొ అర్దుమ్ తెన్ సంగిలన్ గే, జేఁవ్ వెల్లెల మాన్సుల్ నేన్ల. జోచి సొంత ఆఁగుచి రిసొ సంగ తిలొ. ");
INSERT INTO key_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","జలె, పడ్తొ, మెలె జో మొర గెచ్చ తిర్రతి తెడి అన్నె జీవ్ జలి పడ్తొ, జో ఇసి సంగ తిలొ మెన జోచ సిస్సుల్ ఉచార కెరుల. ఉచార కెర్లె, క్రీస్తు “మొర అన్నె జీవ్ జా ఉట్టెదె” మెన దేముడు పూర్గుమ్ రెగ్డయ్‍లి కోడు, చి క్రీస్తు అప్పె సంగిలి కోడు నంప కెరుల. ");
INSERT INTO key_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","జా పస్కా పండుగు పొది, యేసు యెరూసలేమ్‍తె తా, కిచ్చొ కిచ్చొ వెల్లెల కమొ కెర్తె తిలన్, చి జేఁవ్ కమొ దెకితె తా, జోవయింక ‘క్రీస్తు జా తయెదె’ మెన ఒగ్గర్‍జిన్ మాన్సుల్ నంప కెర్ల. ");
INSERT INTO key_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","గని మాన్సుచి పెట్టి తిలి ఉప్రమెన్సుక యేసు జానె. మాన్సుచి బుద్ది కీసి గే కో జోక సాచి సంగుక నాయ్, జానెచి రిసొ, జోవయింక నంప కెరె నాయ్. ");
INSERT INTO key_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","యూదుల్‍చొ అదికారి ఎక్కిలొ, జో పరిసయ్యుల్ మెంత పండితుల్‍తె ఎక్కిలొ, జోచి నావ్ నీకొదేమొ. ");
INSERT INTO key_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","జో ఏక్ దీసి అందరె యేసుతె అయ్‍లన్, అన్నె, “గురుబాబు తుయి బోదన కెర్తి రిసొ అమ్‍చొ దేముడు తుక తెద్రవ అస్సె మెన జానుమ్. కిచ్చొక మెలె, దేముడు తోడు నెంజిలె, తుయి కెర్త వెల్లెల కమొ కెరుక కో కి నెతిర్తి” మెన యేసుక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","యేసు, జలె, జోక, “తుక ఆఁవ్ కిచ్చొ నిజుమి కచితుమ్ సంగితసి మెలె, నొవర్ నే జెర్మిలె దేముడుచి రాజిమ్ దెకుక నెతిర్తి.” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ఇసి సంగితికయ్, నీకొదేమొ జోక “మంత్రొ జలొ మాన్సు అన్నెక్ దప్ప జెర్ముక కీసి? అన్నెక్ సుట్టు అయ్యస్‍చి పెట్టి పెస గెచ్చ జెర్ముక జయెదె గె? నెంజె!” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","యేసు జోక, “దేముడుచి రాజిమ్‍తె మాన్సు బెదుక జలె, పానిక చి దేముడుచి సుద్ది తిలి ఆత్మకచి జెర్మున్ జంకయ్. ఈంజ ఆత్మతె జెర్మున్ కో జతి నాయ్ గే, దేముడుచి రాజిమ్‍తె జో బెదుక నెంజె. ");
INSERT INTO key_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ఈంజ లోకుమ్‍తె ఆఁగ్‍తె జెర్మున్ జలె, ఆఁగ్‍చి జెర్మున్ జయెదె. దేముడుచి రాజిమ్‍తె బెదుక జలె, దేముడుచి సుద్ది తిలి ఆత్మతె జెర్మున్ జెంక అస్సె. ");
INSERT INTO key_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","‘ఇసి నొవర్ జెర్ముక అస్సె’ మెన తుక ఆఁవ్ సంగిలి రిసొ తుయి బమ్మ జా నాయ్. ");
INSERT INTO key_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ఇసిచి రిసొ వాదుక చి దేముడుచి సుద్ది తిలి ఆత్మక టాలి కెరుమ. వాదు, జలె, ఇస్టుమ్ అయ్‍లి పక్క వీర్తి రితి జతయ్. వీరితి సప్పుడు మాన్సు సూన్లె కి, కేనె తెంతొ జెతయ్ గే, కేనె గెతయ్ గే, మాన్సుల్ నేన్‍తి. జలె, కేన్ మాన్సు దేముడుచి సుద్ది తిలి ఆత్మచి జెర్మున్ జలె, దస్సి. జా కీసి జర్గు జతయ్ గే కో నేన్‍తి, గని జర్గు జా అస్సె మెన జో మాన్సుచ కొడొతె కమొతె రుజ్జు జతయ్.” ");
INSERT INTO key_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","నీకొదేమొ, జలె, యేసుక అన్నె “తుయి సంగిలి జెర్మున్ కీసి జర్గు జంక జయెదె?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","యేసు జోక కిచ్చొ జబాబ్ దిలన్ మెలె, “ఇస్రాయేలులుక తుయి సికడ్తొసొ జలెకి, ఇన్నెచి అర్దుమ్ కెరన్సి నాయ్ గె? ");
INSERT INTO key_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","తుక ఆఁవ్ కిచ్చొ నిజుమి కచితుమ్ సంగితసి మెలె, అమ్ జాన్‍తిసి తుమ్‍క సంగితసుమ్, అమ్ దెకిలిసి తుమ్‍క సాచి సంగితసుమ్, గని అమ్‍చి సాచి తుమ్ వెల్లెల మాన్సుల్ నంప కెర్సు నాయ్. ");
INSERT INTO key_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","మాములుమ్ ఈంజ లోకుమ్‍తె జర్గు జతిస్‍క తుమ్‍క సంగిలే కి తుమ్ నంప నే కెర్లె జలె, దస్సే, పరలోకుమ్‍చి రిసొచి తుమ్‍క సంగిలే కి, కీసి నంప కెర్తె! ");
INSERT INTO key_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","కో మాన్సుయి పరలోకుమ్‍తె వెగ గెతి నాయ్, చి తుమ్‍క సికడుక నెతిర్తి, గని ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ ఒత్త తెంతొ ఉత్ర జా అస్సి, చి ఒత్తయ్ అన్నె వెగ గెచ్చిందె. ");
INSERT INTO key_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","సూను, పూర్గుమ్ ‘అయివొ చడితిస్ తెంతొ ప్రెజల్ రచ్చించుప జా జితు’ మెన జా బయిలు దేసిమి మోసే కంచుక తెయార్ కెర్లి అయిచి బొమ్మక కీసి ఉక్కుల టీఁవడ్లన్ గే, దస్సి ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొక ఉక్కుల టీఁవడుక అస్సె. ");
INSERT INTO key_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","కిచ్చొక మెలె, అంచి ఉప్పిరి కో, జోచి నముకుమ్ తివుల గే, పరలోకుమ్‍చి రాజిమ్‍తె బెద, మొర్లె పరలోకుమ్‍తె గెచ్చ కెఁయఁక తెఁయఁక జివుల” మెన జోక యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","జలె, దేముడు ఈంజ లోకుమ్‍చక ఎదివాట్ ప్రేమ కెర్లి రిసొ, జోచొ సొంత ఎక్కి పుత్తుసి ఈంజ లోకుమ్‍చ చి పాపుమ్ వయితి రితి జోవయింక తెద్రవ దిలన్. కిచ్చొక మెలె, కోయి జోక నంపజా గెచ్చుల గే, ఎత్కిక నాసెనుమ్ నే జతె, సిచ్చతె నే గెతె పరలోకుమ్‍తె గెచ్చ కెఁయఁక తెఁయఁక చెంగిల్ తా జివుల. ");
INSERT INTO key_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","దేముడు జోచొ సొంత పుత్తుస్‍క ఈంజ లోకుమ్‍తె తెద్రయ్‍లిసి కిచ్చొక మెలె, లోకుమ్‍చక పాపుమ్ వయడ సిచ్చతె తెద్రయె నాయ్, గని జోచి ఎత్కి పాపుమ్ తెంతొ జోవయింక రచ్చించుప కెర్తి రిసొ తెద్రయిలొ. ");
INSERT INTO key_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","కో జోక నంపజా గెచ్చుల గే, జోవయించి పాపుమ్ జేఁవ్ వయుక నాయ్. గని కో జోవయింక నంపజతి నాయ్ గే, జోవయించి పాపుమ్ అప్పె కి వయ అస్తి, చి దేముడుచొ సొంత ఎక్కి దేముడు పుత్తుస్‍క నంపజతి నాయ్ చి రిసొయి సిచ్చ జతి మొర్నుతె గెచ్చుల. ");
INSERT INTO key_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","జేఁవ్ కిచ్చొక జోవయించి పాపుమ్ వయ సిచ్చతె గెచ్చుక మెలె, ఉజిడి ఈంజ లోకుమ్‍తె అయ్‍లె కి, గర్చ కమొ కెరుక ఒగ్గర్‍జిన్ అలవాట్ జా అస్తిచి రిసొ, అందర్ రితి పాపుమ్‍తె ఇండుక ఆస జా, జా ఉజిడి నెసితి. ");
INSERT INTO key_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","పాపుమ్ కెరుక ఓజ జల మాన్సుల్, జలె, జా ఉజిడి ఎద్గరె నెస కెర, జోవయించ కమొ బయిలె దెకవనుక నెస కెర బియఁ, జా ఉజిడ్‍తె జెతి నాయ్. ");
INSERT INTO key_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","గని కో సత్తిమ్ ఇండుల గే, జా ఉజిడ్‍క బింక నాయ్, చి జేఁవ్ కెర్త కమొక ‘దేముడుచ కమొ, జోచి ఆత్మసెక్తిక సత్తిమ్‍క కెర్త కమొ’ మెన రుజ్జు జతి రితి, దయిరిమ్ తెన్ జోచి జా ఉజిడ్‍తె జెవుల. ");
INSERT INTO key_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ఒత్త తెంతొ, యేసు జోచ సిస్సుల్ తెన్ బార్ జా, యూదయ ప్రదేసిమ్‍చి బయిలె ఉట్ట గెల. జా పొది యేసు జోచ సిస్సుల్ తెన్ తా, జోవయించి అత్తి మాన్సుల్‍క బాప్తిసుమ్ దెతె తిలొ, ");
INSERT INTO key_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","అన్నె, ఒత్త తెంతొ ఇదిల్ దూరిక, సలీము మెలి గఁవ్విచి పాసి తిలి అయ్‍నోను మెలి టాన్‍తె ఒగ్గర్ పాని తతికయ్, యోహాను కి బాప్తిసుమ్ దెతె తతికయ్, మాన్సుల్ జోతె జా కెర బాప్తిసుమ్ నఙన్‍తె తిల. ");
INSERT INTO key_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","జా పొది యోహానుక హేరోదు రానొ జేలి కెరుక నేతయ్. ");
INSERT INTO key_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","జలె, యోహానుచ సిస్సుల్ సగుమ్‍జిన్, సుద్ది కెరంత అలవాట్లు చి రిసొ యూదుల్‍చొ వెల్లొ మాన్సు ఎక్కిలొ తెన్ లట్టబుక దెర్ల. ");
INSERT INTO key_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","తెదొడి జేఁవ్ యోహానుతె జా కెర, జోవయింక “గురుబాబు, ఈంజ యోర్దాను గాడు ఒత్తల్‍తొ జా పొది తుచి తెన్ తిలొసొ, తుయి సాచి సంగిలొసొ, జో కి ఇన్నె తుచి రితి బాప్తిసుమ్ దెతయ్, చి ఎత్కిజిన్ జోతె గెతతి” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","యోహాను జోవయింక కిచ్చొ జబాబ్ దిలన్ మెలె, “పరలోకుమ్‍చొ దేముడు జా దిలెకయ్ మాన్సుక జా అదికారుమ్ తయెదె. జో కెర్తిసి తప్పు నెంజె. ");
INSERT INTO key_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","తుమ్‍క అగ్గె సంగిలయ్, గెద. ‘క్రీస్తు నెంజి, గని ఆఁవ్ జోచొ బారికి జా జో జెతిసి సాట్ప కెరుక మెన దేముడు అంక జోచి పుర్రెతొ తెద్రవ అస్సె’ మెన తుమ్‍క ఆఁవ్ తెదొడి సంగిలయ్. ఆఁవ్ దస్సి సంగిలిస్‍క తుమి సాచి జా అస్సుస్. ");
INSERT INTO key_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","జలె, కేన్ జలెకు పెండ్లితె, పెండ్లిబూలి పెండ్లిబూలొకయ్ గెచ్చెదె, గెద. బూలొచొ మింతుసి జోచి పచ్చెన జా అయ్‍లె కి, జో ఒత్త టీఁవ, బూలొక దెక, జోచి అవాడ్ సూన, సర్దసంతోసుమ్ జయెదె. జలె, పెండ్లితె బూలొయి కీసి ముక్కిమ్ జయెదె గే, దస్సి, క్రీస్తు ముక్కిమ్ జా అస్సె, చి అంక సర్దసంతోసుమ్. ");
INSERT INTO key_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","జో వెల్లొ జంక, ఆఁవ్ దాక్ జంక” మెన యోహాను సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","పరలోకుమ్ తెంతొ అయ్‍లొసొ ఎత్కిచి కంట వెల్లొ. మాములుమ్ ఈంజ లోకుమ్‍చ మాన్సుల్, జలె, మాములుమ్ ఈంజ లోకుమ్‍చి రగుమ్ తా, మాములుమ్ ఈంజ లోకుమ్‍తె తిలిస్‍చి రిసొ లట్టబుల. గని యేసుక్రీస్తు పరలోకుమ్ తెంతొ అయ్‍లొచి రిసొ, జో ఎత్కిచి కంట వెల్లొ. ");
INSERT INTO key_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ఒత్త దేముడు అబ్బొస్‍తె సొంత దెకిలిసి సొంత సూన్లిస్‍చి రిసొ జో సాచి సంగిలే కి, మాములుమ్ ఈంజ లోకుమ్‍చి బుద్ది తిల మాన్సుల్ కోయి జోచి సాచి నంప కెర్తి నాయ్. ");
INSERT INTO key_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","గని, జోచి సాచి కో సూన నంప కెర్తతి గే, ‘దేముడు సత్తిమ్‍చొ’ మెన పూర్తి దయిరిమ్ జా జోచి సాచి దెతతి. ");
INSERT INTO key_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","దేముడు తెద్రయ్‍లొసొ జా, జో దేముడుచ కబుర్లు నిదానుమ్ తెన్ సంగితయ్, అన్నె జోచి పెట్టి దేముడుచి సుద్ది తిలి ఆత్మ ఎదివాట్ దెతయ్. ");
INSERT INTO key_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","జలె, దేముడు అబ్బొసి దేముడు పుత్తుస్‍క పూర్తి ప్రేమ అస్సె, చి అదికారుమ్ ఎత్కి జోచి అత్తి సొర్ప కెర దాఁయి గెల అస్సె. ");
INSERT INTO key_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","దేముడు పుత్తుస్‍క కో నంపజా గెచ్చుల గే, పరలోకుమ్‍చి రాజిమ్‍తె కచితుమ్ బెద, మొర్లె ఒత్త గెచ్చ కెఁయఁక తెఁయఁక జివుల. గని, దేముడు పుత్తుస్‍చి కొడొ రితి కో కెర్తి నాయ్ గే, జోచి జా పాపుమ్ వయ అస్తి, చి దేముడు దిలి సిచ్చ జోవయింక కెఁయ్యఁక కి పిట్టె నాయ్. ");
INSERT INTO key_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","యోహానుచి కంట యేసు అప్పె ఒగ్గర్ సిస్సుల్ కెరన బాప్తిసుమ్ దెతయ్ మెన పరిసయ్యుల్ సూన్ల. ");
INSERT INTO key_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","యేసు మాత్రుమ్ సొంత బాప్తిసుమ్ దెయె నాయ్, గని జోచ సిస్సుల్‍చి అత్తి దెతె తిలన్, ");
INSERT INTO key_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","జలె, “బాప్తిసుమ్‍క ఎత్కిజిన్ అంచితె జెతిస్‍చి రిసొ పరిసయ్యుల్ సూన అస్తి” మెన యేసు చిన కెర, “జోవయించి కోపుమ్‍చి రిసొ అప్పెచి మట్టుక ఇన్నె తంక బెదె నాయ్” మెన, యూదయ ప్రదేసిమ్ ముల దా, జో వడ్డిలి గలిలయ ప్రాంతుమ్‍తె గెచ్చుక మెన అన్నె బార్ జలన్. ");
INSERT INTO key_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","అప్పె యేసుక సమరయ ప్రదేసిమ్‍చి వాట్ గెచ్చుక జంకయ్. ");
INSERT INTO key_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","జలె, సిస్సుల్ తెన్ బార్ జా సమరయ ప్రదేసిమ్‍చి సుకారు మెంతి ఏక్ గాఁవ్ సొడి అయ్‍ల. జా గాఁవ్ కేనె మెలె, యాకోబు మెలొ పూర్గుమ్‍చొ జోచొ యోసేపు మెలొ పుత్తుస్‍క దిలి బుఁయి పాసి అస్సె. ");
INSERT INTO key_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ఊంటక యాకోబు కూనయ్‍లి కుండి ఒత్త అస్సె. జలె, యేసు ప్రయానుమ్‍చి రిసొ అల్పు జా, జా కుండి సొడి వెసిలన్. పాసి పాసి మెద్దెన్ జా అస్సె. ");
INSERT INTO key_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","తెదొడి, అన్నిమ్ గెన ఆన్‍తి రిసొ యేసుచ సిస్సుల్ జా గఁవ్వి పెస గెల. యేసు ఎక్కిలొ ఒత్త వెస అస్సె ");
INSERT INTO key_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","జా సమరయ ప్రదేసిమ్‍చి తేర్‍బోద ఎక్లి పాని కడన్‍తి రిసొ అయ్‍లి. యేసు జాక “పాని దె, పియిందె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","జలె, యూదుల్ సమరయ సుదల్ తెన్ బెదితి నాయ్ చి రిసొ, జా తేర్‍బోద ఆచారిమ్ జా, “ఆఁవ్ ఈంజ సమరయతెచి తేర్‍బోద, తుయి యూదుడు. జలె, ‘పాని దే’ మెన కిచ్చొక అంచి అత్తి తుయి సంగితసి?” మెన యేసుక సంగిలి. ");
INSERT INTO key_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","యేసు జాక, “మాన్సుల్‍క దేముడు దిలి వరుమ్ తుయి చినితది జలె, అన్నె, ‘పాని దే, పియిందె’ మెన తుక సంగితొసొ కొన్సొ జయిందె గే తుయి చినితది జలె, ‘జీవ్ దెతొ పాని అంక దే’ మెన తుయి అంకయ్ సంగితది,” మెన యేసు జాక జబాబ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","జలె, జా తేర్‍బోద అర్దుమ్ కెరనె నాయ్ చి రిసొ, “బాబు, ఈంజ కుండి దీగ్ అస్సె. పాని కడన్‍తి సామన్ కిచ్చొ నాయ్, తుక. జీవ్ దెతొ జో పాని కేనె తెంతొ తుక దొర్కు జయెదె? ");
INSERT INTO key_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","అమ్‍చొ యాకోబు పూర్గుమ్‍చొ, జోచ పుత్తర్సులు, జోచ సొమ్ముల్ ఎత్కి ఈంజయ్ ఊంటచి పాని పితె తిల. జొయ్యి అమ్‍క ఈంజ కుండి దిలన్. తుయి అమ్‍చొ యాకోబు పూర్గుమ్‍చొచి కంట వెల్లొ గే?” మెన సంగిలి. ");
INSERT INTO key_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","జా తేర్‍బోద దస్సి సంగితికయ్, యేసు జాక, “ఈందె, ఈంజ పాని కేన్ మాన్సు పిలెకి, జోక అన్నె తాన్ కెరెదె. ");
INSERT INTO key_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","గని ఆఁవ్ దెతిసి ‘పాని’ కో పివుల గే, జోక కెఁయఁక కి అన్నె తాన్ కెరె నాయ్. ఆఁవ్ దెతొ పాని జోచి పెట్టి ఊంట పుట్లి రితి జతె తయెదె, చి కెఁయఁక తెఁయఁక చెంగిల్ తతి జీవుమ్ జోక దొర్కు జయెదె.” ");
INSERT INTO key_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","జలె, జా తేర్‍బోద అర్దుమ్ కెరనుక నేతయ్‍చి రిసొ, “అప్పె తెంతొ అంక తాన్ నే కెర్తి రితి, పానిక ఆఁవ్ అన్నె ఇన్నె నే జెతె తతి రిసొ, తుయి సంగిలొ పాని అంక దె” మెలి. ");
INSERT INTO key_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","యేసు జాక, “తుయి గెచ్చ, తుచొ మున్సుద్‍క కడ ఆను” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","జా తేర్‍బోద జోక “అంక మున్సు నాయ్” మెన సంగిలి, చి యేసు జాక “‘అంక మున్సు నాయ్’ మెన తుయి సంగిలి కోడు సత్తిమ్. ");
INSERT INTO key_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","తుక అప్పె ఎద పాఁచ్‍జిన్ మున్సర్లు అస్తి, చి అప్పె తిలొసొ తుచొ మున్సుది నెంజె. సత్తిమ్ సంగిలది” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","యేసు ఇసి సంగితికయ్, జా తేర్‍బోద, “బాబు, దేముడు తుక కిచ్చొ కిచ్చొ దెకయ్‍తయ్ మెన అప్పె ఆఁవ్ చినితసి. జొయ్యి తెద్రయ్‍లొ మాన్సు, తుయి. ");
INSERT INTO key_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","అమ్‍చ పూర్గుమ్‍చ తెంతొ అమ్ సమరయ సుదల్ ఈంజ అమ్‍చి మొక్మె తిలి డొంగుర్‍తె దేముడుక బక్తి కెర్తసుమ్, గని ‘యెరూసలేమ్‍తె దేముడుచి గుడితె జోక బక్తి కెరుక అస్సె’ మెన తుమ్ యూదుల్ సంగితసు” మెన జా సంగిలి. ");
INSERT INTO key_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","యేసు జాక, “అమ్మ, ఇదిల్ పడ్తొక, ‘దేముడు అబ్బొక బక్తి కెర్తి రిసొ ఈంజ డొంగుర్ జవుస్, యెరూసలేమ్ పట్నుమ్ జవుస్ ముక్కిమ్ మెనుక నాయ్’ మెన మాన్సుల్‍క అర్దుమ్ జయెదె. ");
INSERT INTO key_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","తుమ్ సమరయ సుదల్, దేముడుక బక్తి కెర్లె కి, జోవయింక అప్పెక దూరి అస్సుస్. అమ్ యూదుల్‍క మాత్రుమ్, జో నిసాన అస్సె. మాన్సుల్‍క దొర్కు జలొ రచ్చించుప కెర్తొసొ అమ్ యూదుల్‍తె జెర్ముక జోచి సెలవ్. ");
INSERT INTO key_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","జలె, ఇదిల్ పడ్తొక, అప్పె రితి కి, జో దేముడు అబ్బొక నిజుమి నంపజల మాన్సుల్ కో జవుల గే, జోవయించి ఆత్మతె నిదానుమ్ జా జోవయింక సత్తిమ్ తిలి బక్తి కెరుల. దేముడు అబ్బొస్ దస్స మాన్సుచి రిసొ రకితయ్. ");
INSERT INTO key_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","దేముడు డీస్తొసొ నెంజె, గెద. ఆత్మయి, జో. జాకయ్, కో జోక బక్తి కెరుక ఉచరుల గే, జోవయించి ఆత్మయి నిదానుమ్ తెన్ జోక సత్తిమ్ తిలి బక్తి కెరుక అస్సె” మెన యేసు జా తేర్‍బోదక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","జో ఇసి సంగితికయ్, జా తేర్‍బోద, “‘దేముడు తెద్రయిందె’ మెన సంగ తిలొ ‘మెస్సయ మెలొ రచ్చించుప కెర్తొసొ జెయెదె’ మెన జాని. జో అయ్‍లి పొది, జొయ్యి అమ్‍క ఎత్కి దెకయెదె” మెన సంగిలి. ");
INSERT INTO key_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","జలె, జా దస్సి సంగితికయ్, యేసు జాక “ఆఁవ్ తుచి తెన్ లట్టబ్తొసొ జొయ్యి” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","యేసు ఇసి సంగిలి బేగి, జోచ సిస్సుల్ జా గఁవ్వి తెంతొ బుల అయ్‍ల. తేర్‍బోద తెన్ యేసు లట్టబ్‍తయ్ మెన దెక ఆచారిమ్ జల, గని ‘తుక కిచ్చొ కావలె?’ జలెకు, ‘జాచి తెన్ కిచ్చొక లట్టబ్తసి?’ జలెకు మెన కో పుసితి నాయ్. ");
INSERT INTO key_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","తెదొడి జా తేర్‍బోద, జాచి గేడి ముల దా నిగ గెచ్చ, జా గాఁవ్ తెడి పెస, ");
INSERT INTO key_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“తుమ్ బేగి జా ఎక్కిలొక దెక! ఈంజొ మాన్సు కక్క నే పుసితె, ఆఁవ్ అగ్గె కెర్లిసి ఎత్కి అంక సంగ దిలొ. ఈంజొయి క్రీస్తు జయెదె, కిచ్చొగె” మెన ప్రెజల్‍క బుకార్లి, ");
INSERT INTO key_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","చి జా తెన్ ఒగ్గర్‍జిన్ యేసుతె జెంక బార్ జల. ");
INSERT INTO key_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","జా తేర్‍బోద గఁవ్వి పెస ప్రెజల్‍క బుకార్లి మెద్దెనె, యేసుచ సిస్సుల్ జోక “గురుబాబు, అన్నిమ్ కెరు!” మెన బలవంతుమ్ కెర్ల. ");
INSERT INTO key_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","గని జో “తుమ్ నేన్లి ఏక్ రగుమ్ అన్నిమ్ అంక అస్సె” మెన జబాబ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","జో ఇసి సంగిలి రిసొ, జోచ సిస్సుల్ “ఇన్నెక కో జలెకు కిచ్చొ జవుస్ అన్నిమ్ ఆన దా అస్తి గే?” మెన ఎక్కిలొ తెన్ ఎక్కిలొ లట్టబుక దెర్ల. ");
INSERT INTO key_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","జేఁవ్ దస్సి జతికయ్, యేసు జోవయింక, “అంచి అన్నిమ్ కిచ్చొ మెలె, అంక తెద్రయ్‍లొసొచి ఇస్టుమ్ రితి కెరుకయ్. జోచి కామ్ పూర్తి జర్గు కెరుకయ్. ");
INSERT INTO key_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“ఈందె, ‘అన్నె చెత్తర్ జొన్నొ గెలెకయ్ పంటొ లాయ ఆనుక జయెదె’ మెన మొక్కల్ రోవితి పొది సంగితసు. జలె, ఆఁవ్ తుమ్‍క కిచ్చొ మెంతసి మెలె, ఆదె! అంకివొ ఉగుడ దెక! బట్టిలె పంటొ అప్పె పిక తెయార్ జా రితి, అంక నంపజంక ఎతివాట్‍జిన్ మాన్సుల్ తెయార్ జలి రితి సమయుమ్ జా అస్సె. ");
INSERT INTO key_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ప్రెజల్‍క దేముడుచి రాజిమ్‍తె బెదయ్‍తి ఈంజ ఆత్మపంటొ లాయితితె కో లాయ ఆన్‍తస జవుల గే, జోవయింక ఆత్మజీతుమ్ దొర్కు జయెదె. జాచి రిసొ, అంచి సుబుమ్ కబుర్ తిలి బి గలిలస కి, జా ఆత్మపంటొ లాయ ఆన్‍తస కి, సర్దసంతోసుమ్ జవుల. ");
INSERT INTO key_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","అంచి ఆత్మపంటొచి కామ్‍తె, జలె, ‘ఎక్కిలొ బి గలెదె, అన్నెక్లొ పంటొ లాయ ఆనెదె’ మెలి కోడు సత్తిమ్ జయెదె. ");
INSERT INTO key_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","అల్లె, తుమ్ మొదొల్ నే కెర్లి ఈంజ కామ్‍తె బెదుక తుమ్‍క ఆఁవ్ తెద్రవ అస్సి. కో కో కస్టుమ్ జా అగ్గె తెంతొ ఈంజ కామ్ కెర తతికయ్, తూమ్ కి అప్పె ఈంజ కామ్‍తె బెద అస్సుస్” మెన యేసు జోచ సిస్సుల్‍క సికయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","జలె, ‘ఆఁవ్ కెర్లిసి ఎత్కి అంక సంగ దిలొ’ మెన యేసుచి రిసొ జా తేర్‍బోద సంగిలి సాచి సూన కెర, జా గఁవ్విచ సమరయ సుదల్ ఒగ్గర్‍జిన్ యేసుక నంపజల. ");
INSERT INTO key_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","జాకయ్, యేసుతె జా కెర, “అమ్‍చి గఁవ్వి జా తా” మెన జేఁవ్ సమరయ సుదల్ బతిమాల్ప జా సంగిల, చి దొరతి తా గెలన్. ");
INSERT INTO key_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","జో సొంత బోదన కెర్తికయ్, అన్నె ఒగ్గర్‍జిన్ జోక నంపజల, ");
INSERT INTO key_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","చి జా తెర్‍బోదతె జా కెర, “తుక ‘జయ్యి సంగిలి రిసొ నంపజలమ్’ మెన అప్పె తెంతొ సంగుమ్ నాయ్. కిచ్చొక మెలె, అమ్ అప్పె జోచి కొడొ సొంత సూన్లి రిసొ, ‘ఈంజ లోకుమ్‍చ ఎత్కిక దొర్కు జలొ రచ్చించుప కెర్తొసొ ఈంజొయి’ మెన పూర్తి దయిరిమ్ జా అస్సుమ్” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","జా దొరతి గెలి పడ్తొ, యేసు జోచ సిస్సుల్ తెన్ ఒత్త బార్ జా గెచ్చ, గలిలయ ప్రాంతుమ్‍తె పాఁవిల. ");
INSERT INTO key_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","‘దేముడుచ కబుర్లు సంగితొసొ కో జలెకు సొంత టాన్‍తె తిలె, సొంత టాన్‍చ మాన్సుల్ జోక గవురుమ్ దెకితి నాయ్’ మెన జాన కెర, యేసు సొంత సంగితె తిలన్. జాకయ్ యూదయ ప్రదేసిమ్ ముల తిలొ. ");
INSERT INTO key_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","గలిలయ ప్రాంతుమ్‍చ ప్రెజల్ ఒగ్గర్‍జిన్, జలె, యెరూసలేమ్ పట్నుమ్‍తె పండుగ్‍క జేఁవ్ కి గెచ్చ తా అన్నె ఉట్ట జా అస్తి. జేఁవ్ యెరూసలేమ్‍తె తిలి పొది, యేసు కెర్ల కమొ ఎత్కి దెక తిల. జేఁవ్, జలె, జేఁవ్ గలిలయులు, సర్ద తెన్ జోక మరియాద కెర్ల. ");
INSERT INTO key_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","జలె, జా గలిలయ ప్రాంతుమ్‍తెచి కానా మెంతి గఁవ్వి యేసు అన్నె ఉట్ట అయ్‍లన్. జా సుట్టు, ఒత్తయ్ పానిక ద్రాచ రస్సుమ్ మార్సుప కెర తిలొ. జలె, యేసు అప్పె కానాతె తతికయ్, ఇదిల్ దూరి తిలి కపెర్నహూమ్ మెంతి గఁవ్వి హేరోదు రానొచొ వెల్లొ అదికారి ఎక్కిలొచొ పుత్తుసి జొర్జొ సేడ అస్సె. ");
INSERT INTO key_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","యేసు యూదయ ప్రదేసిమ్ ముల దా గలిలయ ప్రాంతుమ్‍తె జా అస్సె మెన జో వెల్లొ మాన్సు సూన్లి బేగి, బార్ జా, యేసుతె అయ్‍లన్. జోచొ పుత్తుసి మొర గెచ్చెదె గే జియెదె గే, దస్సి జా అస్సెచి రిసొ, “బేగి జా అమ్‍చొ పుత్తుక చెంగిల్ కెరు” మెన యేసుక బతిమాల్ప జా సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","జలె, యేసు జోక, “దేముడు దిలి అదికారుమ్‍క రుజ్జు దెకయ్‍త కమొ నే దెకిలె, తుమ్ నంప కెర్సు నాయ్” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","యేసు ఇసి సంగితికయ్, జో “బాబు, అమ్‍చొ బోబొ నే మొర్తి రితి బే బేగి జె” మెన జో అన్నె బతిమాల్ప జా సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","తెదొడి యేసు జోక, “గో, తుచొ పుత్తుది జియెదె!” మెన సంగిలన్. యేసు సంగిలి కోడు జో మాన్సు నంప కెర, గెరి గెచ్చుక బార్ జలన్. ");
INSERT INTO key_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","జో వట్టె గెతె తతికయ్, జోచ గొత్తి సుదల్ జో తెన్ దస్సుల్ జల. “తుచొ పుత్తుది జిలొ!” మెన జోక సంగిల. ");
INSERT INTO key_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","“కెత్తి గంటల్‍క చెంగిల్ జలొ?” మెన జో పుసిలన్, చి జేఁవ్ జోక “కాలి ఒంటి గంటక జొర్జొ గెలి!” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","జలె, “తుచొ పుత్తుది జియెదె” మెన యేసు సంగిలి గడియ జయ్యి మెన జొర్జొ సేడ్లొ నాడుచొ అబ్బొసి చినన్‍లొ. జాకయ్, జోచి గెర్‍చ మాన్సుల్ ఎత్కిజిన్ యేసుక నంపజా గెల. ");
INSERT INTO key_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","యూదయ ప్రదేసిమ్ ముల గలిలయ ప్రాంతుమ్‍తె తొలితొ ఉట్ట అయ్‍లి జా సుట్టు తెంతొ, ఈంజొ నాడుక చెంగిల్ కెర్లిసి తెన్ జోచి అదికారుమ్‍క రుజ్జు దెకయ్‍త కమొ దొన్ని జల. ");
INSERT INTO key_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ఈంజ జర్గు జలి పడ్తొ, యూదుల్‍చి పండుగు అన్నెక్ అయ్‍లిచి రిసొ దేముడుచి దేవులుమ్ తిలి యెరూసలేమ్ పట్నుమ్‍తె యేసు ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","జలె, జా పట్నుమ్‍తె ‘మెండల్ వీది’ మెన ఏక్ టాన్ అస్సె. ఒత్త ఏక్ వెల్లొ కుండి అస్సె. ఎబ్రీ బాస తెన్ జా కుండిచి నావ్ ‘బేతెస్ద’. జా కుండిచి సుట్టునంత, పాఁచ్ గుమ్మల్ తిలి టాన్ ఏక్ అస్సె. ");
INSERT INTO key_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ఒత్త రగరగాల్ రోగల్‍చ బెర అస్తి, గుడ్డి మాన్సుల్, సొట్ట మాన్సుల్, అత్తొ చట్టొ లంబ గెల మాన్సుల్, దసచ అస్తి. ");
INSERT INTO key_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","కిచ్చొక ఒత్త అస్తి మెలె, గడియ గడియక ఏక్ దూత జా గడ్డె ఉత్ర జా కెర, పాని కదుల్ కెరెదె, చి జో పాని కదుల్ జలి బేగి కో జలెకు రోగి తొలితొ పానితె ఉత్రెదె గే, జోవయించి జబ్బు గెచ్చ, చెంగిల్ జయెదె. ");
INSERT INTO key_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","జలె, ముప్పయ్ అట్టు వెర్సుల్‍చి జబ్బు తిలొ ఏక్ మాన్సు ఒత్త అస్సె. ");
INSERT INTO key_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","యేసు జా వెల్లి కుండి తిలిస్‍తె గెచ్చ, జో రోగిక దెక, ‘ఒత్త ఎత్తివాట్ దీసల్ తెంతొ జోచి అంతుర్నొతె నిజ తా మాలఙ్ జా అస్సె’ మెన చిన కెర, “తుక నిజుమి చెంగిల్ జంక ఇస్టుమ్ అస్సె గే?” మెన జోక పుసిలన్. ");
INSERT INTO key_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","జో రోగి “బాబు, పాని కదుల్ జలి బేగి అంక పానితె ఉత్రయ్‍తొసొ కో నాయ్, చి ఆఁవ్ ఉత్తిర్తె ఎద అన్నె కో గే అంచి కంట అగ్గె ఉత్రెదె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","యేసు జోక “తుయి ఉట్ట, తుచి అంతుర్నొ వయన ఇండు!” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","సంగిలి బేగి, జో మాన్సు చెంగిల్ జా జోచి అంతుర్నొ వయన ఇండిలన్. ");
INSERT INTO key_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","జా దీసి, యూదుల్‍చి బక్తి కెర్తి సెలవ్ కడన్లి దీసి. జలె, యూదుల్‍చ వెల్లెల మాన్సుల్ సగుమ్‍జిన్ చెంగిల్ జలొ జో మాన్సుక దెకిల. దెక, “ఈంజ సెలవ్ కడన్లి దీసి. తుచి అంతుర్నొ వయుక గారు!” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","దస్సి సంగితికయ్, చెంగిల్ జలొ జో మాన్సు “‘తుచి అంతుర్నొ వయన ఇండు’ మెన, అంక చెంగిల్ కెర్లొసొ సంగిలన్, చి వయన ఇండిలయ్” మెన జోవయింక జబాబ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","“‘తుచి అంతుర్నొ వయన ఇండు’ మెలొసొ కో?” మెన జేఁవ్ వెల్లెల మాన్సుల్ పుసిల. ");
INSERT INTO key_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","జో కొన్సొ జయెదె గే చెంగిల్ జలొ జో మాన్సు నేనె. కిచ్చొక మెలె, ఒత్త ఒగ్గర్‍జిన్ జనాబ్ తతికయ్, యేసు, కో నే దెకితె, ఉట్ట గెచ్చ తిలొ. ");
INSERT INTO key_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","పడ్తొ, చెంగిల్ జలొసొక యేసు దేముడుచి గుడితె చజ కెర, జోక “ఈందె, అప్పె తుయి చెంగిల్ అస్సిసి. అన్నె కిచ్చొ జవుస్ వెల్లి బాద నే సేడ్తి రిసొ అన్నె పాపుమ్ కెరు నాయ్” మెన జాగర్త సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","జో మాన్సు ఒత్త తెంతొ గెచ్చ, “అంక చెంగిల్ కెర్లొసొ యేసుయి” మెన యూదుల్‍చ వెల్లెల మాన్సుల్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","జలె, సెలవ్ కడన్లి దీసి యేసు ఈంజ కామ్ కెర్లి రిసొ, యూదుల్‍చ వెల్లెల మాన్సుల్ జోక అల్లర్ కెరుక దెర్ల. ");
INSERT INTO key_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","దస్సి జతికయ్, యేసు జోవయింక, “అగ్గె తెంతొ ఎద కి అంచొ దేముడు అబ్బొ కామ్ కెర్తె తత్తయ్. ఆఁవ్ కి జోచి కామ్ కెర్తె అస్సి” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","జలె, ‘సెలవ్ కడన్లి దీసి పిట్టవన కామ్ కెర్తయ్’ మెన, అన్నె, దేముడు తెన్ సమ్మందుమ్ మెనన్లొ జోక ‘అబ్బొ’ మెన యేసు సంగిలిస్‍చి రిసొ, యేసుక మారుక మెన అన్నె ఒగ్గర్ ఉచర జల. ");
INSERT INTO key_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","జలె, కోపుమ్ జల జేఁవ్ వెల్లెల మాన్సుల్‍క యేసు ఇసి మెన సంగిలన్. “ఆఁవ్ తుమ్‍క కిచ్చొ నిజుమి కచితుమ్ సంగితసి మెలె, దేముడు అబ్బొ కెర్తిసి కేన్ జలెకి ఆఁవ్ పుత్తుసి దెకిలె, జయ్యి దస్సి కెర్తె తయిందె, వేరచి కిచ్చొ కెరుక నెంజె. అబ్బొ కిచ్చొ కెర్లె, ఆఁవ్ పుత్తుసి జయ్యి కెర్తసి. ");
INSERT INTO key_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ఆఁవ్ పుత్తుస్‍క దేముడు అబ్బొ ప్రేమ కెర్తయ్. దేముడు అబ్బొ కెర్తిసి ఎత్కి ఆఁవ్ జోచొ పుత్తుస్‍క దెకయ్‍తె తత్తయ్. తుమ్ దెకిల ఈంజేఁవ్ కమొచి కంట అన్నె జీన్ల కమొ ఆఁవ్ పుత్తుస్‍క దేముడు అబ్బొ దెకయెదె. తుమ్ ఆచారిమ్ జస్తె. ");
INSERT INTO key_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","కీస కమొ మెలె, మొర గెలసక ఉట్టవ దేముడు అబ్బొ జోవయింక కీసి అన్నె జియడ్తయ్ గే, దస్సి, కక్క జియడుక సర్ద జయిందె గే, జోవయింక జియడ చెంగిల్ కెరిందె. ");
INSERT INTO key_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","పడ్తొ, దేముడు అబ్బొ కక్క సొంత తీర్పు కెరె నాయ్. తీర్పు కెర్తి అదికారుమ్ ఆఁవ్ జోచొ పుత్తుస్‍క సొర్ప కెర దా అస్సె. ");
INSERT INTO key_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","దేముడు అబ్బొక మాన్సుల్ కీసి గవురుమ్ కెర్తతి గే, దస్సి ఎత్కిజిన్ ఆఁవ్ జోచొ పుత్తుస్‍క కి గవురుమ్ కెర్తు మెన, జో సెలవ్ దా అస్సె. ఆఁవ్ పుత్తుస్‍క కో గవురుమ్ కెర్తి నాయ్ గే, అంక తెద్రయ్‍లొ దేముడు అబ్బొక కి గవురుమ్ కెర్తి నాయ్. ");
INSERT INTO key_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“తుమ్‍క కిచ్చొ నిజుమి కచితుమ్ ఆఁవ్ సంగితసి మెలె, అంక తెద్రయ్‍లొసొక నంప కెర కో అంచి కోడు సూన కెరుల గే, పరలోకుమ్‍చి రాజిమ్‍తె బెదితి వరుమ్ జోవయింక దొర్కు జా అస్సె. పాపుమ్‍చి రిసొ జేఁవ్ మొర గెల రిత జా తిలె కి, జేఁవ్ కెర్ల పాపల్ చెమించుప జా సిచ్చతె గెతి నాయ్, గని జివ్వి జా అస్తి. ");
INSERT INTO key_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“తుమ్‍క నిజుమి కచితుమ్ ఆఁవ్ కిచ్చొ సంగితసి మెలె, మొర గెలస ఆఁవ్ దేముడు పుత్తుస్‍చి అవాడ్ సూన్‍తి సమయుమ్ జెతయ్, అప్పె కి జా అస్సె, కో సూన నంపజవుల గే, నొవర్ జిలి రితి జా, దేముడుచి రాజిమ్‍తె బెదుల. ");
INSERT INTO key_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","జీవ్ కెర్తి సెక్తి జో అబ్బొసి జలొ దేముడుచి అత్తి అస్సె, జలె, దొర్కు జలి జయ్యి సెక్తి ఆఁవ్ జోచొ అబ్బొ జలొ దేముడు పుత్తుస్‍క దా అస్సె. ");
INSERT INTO key_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","అన్నె, ఆఁవ్ మాన్సు జా జెర్మున్ అస్సిచి రిసొ అంక మాన్సుల్‍క తీర్పు కెర సిచ్చ కెరుక, చెమించుప కెరుక, అదికారుమ్ దా అస్సె. ");
INSERT INTO key_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ఇన్నెచి రిసొ తుమ్ కిచ్చొ ఆచారిమ్ సేడ నాయ్, కిచ్చొక మెలె, మొర గెల మాన్సుల్, మెస్సున్‍ల్‍తె తిలస ఎత్కి, అంచి అవాడ్ సూన బార్ జతి సమయుమ్ జెయెదె. ");
INSERT INTO key_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","తెదొడ్‍క జేఁవ్ బార్ జా, సత్తిమ్ కెర్లస అన్నె జీవ్ జా ఉట్ట పరలోకుమ్‍తె గెచ్చ చెంగిల్ జితె తవుల, సత్తిమ్ నే కెర్లస ఉట్ట, సిచ్చతె గెచ్చుల. ");
INSERT INTO key_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“జలె, కిచ్చొ అఁవ్వి కెరుక అంక అదికారుమ్ నాయ్, దేముడు అబ్బొతె ఆఁవ్ సూన్లి రితి ఆఁవ్ తీర్పు కెర్తసి ఆఁవ్ కెర్తి తీర్పుతె కిచ్చొ తప్పు నాయ్. కిచ్చొక మెలె, ఆఁవ్ కిచ్చొ వేర ఉచరి నాయ్, గని అంక ఎక్కి ఆస. కిచ్చొ మెలె, అంక తెద్రయ్‍లొసొచి ఇస్టుమ్ తిలిసి పూర్తి జర్గు కెరుక. ");
INSERT INTO key_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“అంచి రిసొ ఆఁవ్ ఎక్కిలొ సాచి సంగన్లె, అంచి సాచి సత్తిమ్‍చి గే అబద్దుమ్‍చి గే రుజ్జు నాయ్. ");
INSERT INTO key_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","అంచి రిసొ సాచి సంగితొసొ అన్నెక్లొ అస్సె. జో అంచి రిసొ సాచి సంగిలిసి సత్తిమ్ మెన జాని. ");
INSERT INTO key_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","మెలె, యోహానుక ‘కిచ్చొ సాచి సంగెదె?’ మెన సూన్‍తి రిసొ తుమి జా సుట్టు సగుమ్‍జిన్‍చి అత్తి కబుర్ తెద్రయ్‍లదు, చి ఆఁవ్ కొన్సొ గే జో సాచి సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","అంచి రిసొచి ముక్కిమ్ జలి సాచి మాన్సు సంగిలిసి నెంజె, గని తుమ్‍క ‘నంపజా రచ్చించుప జతు’ మెన, యోహానుచి సాచిచి రిసొ తుమ్‍క ఆఁవ్ ఉచరయ్‍తసి. ");
INSERT INTO key_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","దొర్కు జలిసి మాన్సు చినితి రిసొ దీవు లగితె తిలె కీసి తమ్మస ఉజిడ్ దెతయ్ గే, దస్సి, ఉజిడ్ రితొ జా, అంచి రిసొ యోహాను సాచి సంగితె తిలొ. జో సంగిలి సాచి సూన, తూమ్ కి గడియయ్ సర్ద తెన్ తిలదు. ");
INSERT INTO key_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“గని, యోహానుచి సాచిచి కంట అంక జీన్లి సాచి అస్సె. ఆఁవ్ కెరుక మెన దేముడు అబ్బొ దిల కమొ, ఈంజేఁవ్ ఆఁవ్ కెర్త కమొయి దెకిలె, జొయ్యి అంక తెద్రయ్‍లొ మెన ఈంజేఁవ్ కమొయి అంచి రిసొ సాచి సంగితతి. ");
INSERT INTO key_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","“పడ్తొ, అంక తెద్రయ్‍లొ అబ్బొయి అంచి రిసొ సొంత సాచి సంగిలన్. తూమ్ కెఁయ జోచి అవాడ్ సూన్‍సు నాయ్, జోచి రూపుమ్ తుమ్ కెఁయ దెకుస్ నాయ్. ");
INSERT INTO key_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","జోచి కోడు తుమ్‍చి పెట్టి నాయ్ మెన కిచ్చొ రుజ్జు తత్తయ్ మెలె, జో తెద్రయ్‍లొసొక తుమ్ నంప కెర్సు నాయ్. ");
INSERT INTO key_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","దేముడుచి రాజిమ్‍తె బెద పరలోకుమ్‍తె గెతి రిసొ దొర్కు జలి గ్యానుమ్ పున్నిమి దెతిసి దేముడుచ కొడొతె తయెదె మెన దేముడుచ కొడొ తుమ్ రోజుక దెకితసు. జలె, జెఁవ్వి అంచి రిసొ సాచి సంగితతి. ");
INSERT INTO key_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","జేఁవ్ కొడొ అంచి రిసొ సాచి సంగిలే కి, అంచితె దొర్కు జతి పరలోకుమ్‍చి జీవ్ సంగితి రిసొ తుమ్ అంచితె జెంక ఎద్గరె నెసుసు. అంక నంపజలె, తుమ్‍క దొర్కు జతి. ");
INSERT INTO key_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“మాన్సు దెతి గవురుమ్ అంక నాయ్. ");
INSERT INTO key_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","గని దేముడుచి ప్రేమబుద్ది తుమ్‍చి పెట్టి నాయ్ మెన జాని. ");
INSERT INTO key_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","అంచొ అబ్బొసి జలొ దేముడుచి నావ్ తెన్ ఈంజ లోకుమ్‍తె ఆఁవ్ జా అస్సి, గని తుమ్ అంక నంప కెర్సు నాయ్. గని, కో జలెకు వేర మాన్సు అఁవ్వి కెర అయ్‍లె, జోకయ్ నంప కెర్తె. ");
INSERT INTO key_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","మాన్సు సంగితి గవురుమ్ ఎక్కిలొతె ఎక్కిలొ తుమ్ సంగితసు, గని ఎక్కిలొ దేముడు దెతి గవురుమ్‌క తుమ్ కోర్‍ప జసు నాయ్. జాకయ్ తుమ్ కీసి నంప జస్తె, నెతుర్సు. ");
INSERT INTO key_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“జలె, అబ్బొసి జలొ దేముడుచి మొక్మె తుమ్‍క నేరిమ్ వయడ్తొసొ ఆఁవ్ మెన తుమ్ ఉచర నాయ్. ‘మోసేచి అత్తి ప్రబు రెగిడ్లి ఆగ్నల్ నంపజలమ్, చి జాకయ్ రచ్చించుప జమ్‍దె.’ మెన, తుమ్‍క తుమి ఉచర్తసు. గని జయి బోదన తుమ్‍క నేరిమ్ వయడ్తె అస్సె. ");
INSERT INTO key_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","మోసే పూర్గుమ్‍చొచి అత్తి దేముడు రెగిడ్లిసి కోడు తుమ్ నంప కెర్తదు జలె, అంకయ్ నంప కెర్తదు! కిచ్చొక మెలె, అంచి రిసొయి జో రెగిడ్లొ. ");
INSERT INTO key_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","గని మోసే రెగిడ్లిసి తుమ్ నంప నే కెర్లె, ఆఁవ్ సంగిత కొడొ కీసి నంప కెర్తె!” మెన జేఁవ్ వెల్లెల మాన్సుల్‍క యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ఇన్నెచి పడ్తొ యేసు గలిలయ ప్రాంతుమ్‍తె అన్నె గెచ్చ, జా గలిలయచి సముద్రుమ్ గాడు జీన ఒత్తల్‍తొ గెలన్. జా గాడుక ‘తిబెరియ గాడు’ కి మెనుల. ");
INSERT INTO key_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","జలె, జబ్బుల్‍క జో యేసు చెంగిల్ కెర్త దేముడు అబ్బొసి దిలి అదికారుమ్‍క రుజ్జు దెకయ్‍త కమొ జేఁవ్ దెక తిలి రిసొ, ఒగ్గర్‍జిన్ జనాబ్ గాడుచి ఒడ్డువాట్ ఇండ యేసుచి పట్టి గెచ్చుక బార్ జల. ");
INSERT INTO key_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","జలె, యేసు జోచ సిస్సుల్ తెన్ ఏక్ మెట్టయ్ వెగ, వెస అస్తి. ");
INSERT INTO key_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","యూదుల్‍చి పస్కా మెంతి పండుగు అన్నెక్ సుట్టు పాసి జెతయ్. ");
INSERT INTO key_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","యేసు దెకిల్ పొది, ప్రెజల్ జట్లు జట్లు తెన్ జోతె జెతిసి దెక, పిలిప్ మెలొ సిస్సుడుక “ఈంజేఁవ్ ప్రెజల్ కతి రిసొ అమ్ కీసి అన్నిమ్ గెనుక?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","కిచ్చొ కెరుక గే యేసు జానె, గని, జోచి రిసొ పిలిప్ కెద్ది దయిరిమ్ తెన్ నంపజతయ్ గే దెకితి రిసొ దస్సి మెన యేసు పుసిలన్. ");
INSERT INTO key_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","జలె, పిలిప్ జోక, “ఈంజేఁవ్ మాన్సుల్ ఎత్కిజిన్‍క ఇదిల్ ఇదిల్ జవుస్ దెంక జలె, వెయి వెండ్లుచ పోడియొ జలెకు నే బెరె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","గని సీమోను పేతురు మెలొ సిస్సుడుచొ అంద్రెయ మెలొ బావొసి జేఁవ్ సిస్సుల్‍తె అస్సె. ");
INSERT INTO key_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","ఈంజొ, జలె యేసుక “ఓదె, ఇన్నె తిలొ ఇదిలోసొ నాడు ఎక్కిలొక పాఁచ్ పోడియొ చి దొన్ని ఇదుద్ల మొస్స అస్తి, గని ఎత్కిజిన్‍క తెద్దిలి కీసి వంట దెంక జయెదె!” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","యేసు “ఎత్కిజిన్‍క వెసవ దాస” మెన సిస్సుల్‍క సంగిలన్. జలె, ఒత్త చెంగిలి వెసితి రితి గర్చి చివ్వర్ తిలి టాన్ ఒగ్గర్ అస్సె, చి ఎత్కిజిన్ ప్రెజల్ వెసిల. ఎక్కి మున్సుబోదల్‍క లెక్క కెర్లె, జేఁవ్ మొత్తుమ్ పాసి పాసి పాఁచ్ వెయిల్‍జిన్ జల. ");
INSERT INTO key_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","జలె, యేసు జేఁవ్ పోడియొ నఙన, “తూయి ఈంజ అన్నిమ్ దా దయ కెర్లది” మెన దేముడు అబ్బొస్‍క ఉచర, వెస తిలస ఎత్కిజిన్‍క పాఁవితి రితి వంట దిలన్. మొస్సతెన్ కి దస్సి కెర, జేఁవ్ పేట్ బెర్తు కతి రితి వంట దిలన్. ");
INSERT INTO key_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ఎత్కిజిన్ పేట్ బెర్తు కయ్‍లి పడ్తొ, “ఆరి పాడ్ జవుస్ నాయ్ మెన, సేంసిల గండల్ గుడ్డ ఆన” మెన సిస్సుల్‍క యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","జలె, ఎత్కిజిన్ కయ్‍ల జేఁవ్ పాఁచ్ పోడియొచ సేంసిల గండల్ సిస్సుల్ గుడ్డిల. గుడ్డిలె, బార గంపల్ బెర్తు జల. ");
INSERT INTO key_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","జలె, దేముడు అబ్బొసి దిలి అదికారుమ్‍క రుజ్జు దెకయ్‍లి ఈంజ కామ్ ప్రెజల్ దెక కెర, “ఒహొ, ‘అంచి కబుర్ సూనయ్‍తొసొక బూలోకుమ్‍తె బార్ కెరిందె’ మెన దేముడు సంగిలొసొ ఈంజొయి” మెన సంగితె తిల. ");
INSERT INTO key_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","తెదొడి, జోక రానొ కెర్తి రిసొ దెరుక మెన ప్రెజల్ కోర్‍ప జల, గని జోవయించి ఉద్దెసుమ్ చిన కెర, యేసు జోవయింక ముల దా, ఎక్కిలొ గెచ్చ, మెట్టయ్ అన్నె గెలన్. ");
INSERT INTO key_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","సాంజ్ జతికయ్, అందర్ జంక దెర తిలి, చి యేసు జోవయింతె అన్నె ఉత్ర జెంక నేతయ్‍చి రిసొ సిస్సుల్ “గెరి గెచ్చుమ!” మెన గడ్డె గెచ్చ, ");
INSERT INTO key_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","జోవయించి దోనితె వెగ, గాడు ఒత్తల్‍తొ తిలి కపెర్నహూమ్ పట్నుమ్‍తె గెచ్చుక మెన, దోని జీనవుక దెర్ల. ");
INSERT INTO key_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ఇదిల్ దూరి జీనయ్‍లి పొది, వాదు ఒగ్గర్ కెర్లి, చి వెల్లెల కెర్టల్ కెరుక దెర్లి. ");
INSERT INTO key_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","దస వెల్లెల కెర్టల్ కెర్తిస్‍తె జేఁవ్ పాసి పాసి దొన్ని కోసుల్ దూరిక దోని ఇండయ్‍తికయ్, యేసు పానిచి ఉప్పిరి ఇండ జా, దోనిక పాసి పాఁవిలన్. జో దస్సి పాసి ఇండ జెతె తతికయ్, సిస్సుల్ దెక, “డుంబొ, కిచ్చొ గే!” మెన, బియఁ గెల. ");
INSERT INTO key_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","యేసు జోవయింక “తుమ్ బియఁ నాయ్. ఆఁవ్వి జెతసి” మెన దయిరిమ్ సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","తెదొడి సర్ద తెన్ జోకయి దోనితె వెగయ్‍ల, చి బేగి జేఁవ్ గెతి ఒడ్డుతె దోని పాఁవ గెలి. ");
INSERT INTO key_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","జలె, జా గెలి దీసి పోడియొ మొస్స కయ్‍ల ప్రెజల్ సగుమ్‍జిన్, అన్నెక్ దీసి ఎద గాడు ఒత్తల్‍తొ రకితె అస్తి. ‘గెలి దీసి ఎక్కి దోని తిలి’ మెన, ‘యేసు జోచ సిస్సుల్ తెన్ దోనితె వెగె నాయ్, చి జో నెంతె సిస్సుల్ ఉట్ట గెచ్చ తిల’ మెన, జేఁవ్ ప్రెజల్ ఉచార కెర అస్తి. జాకయ్, యేసుచి రిసొ ‘మెట్టయ్ తెంతొ ఉత్ర జెంక నేతయ్. కిచ్చొగె’ మెన రకితె అస్తి. ");
INSERT INTO key_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","రకితె తిలె, తిబెరియ పట్నుమ్ తెంతొ, వేర దోనివొ అయ్‍ల. గెలి దీసి యేసు దేముడు అబ్బొస్‍క ఉచర వంట దిల పోడియొ కయ్‍ల జేఁవ్ ప్రెజల్ తిలిస్‍తె, జలె, జేఁవ్ దోనివొ అయ్‍ల. ");
INSERT INTO key_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","జెతికయ్, జోచ సిస్సుల్ కి యేసు కి ఇన్నె నాయ్ మెన ప్రెజల్ దెక, జేఁవ్ అప్పె అయ్‍ల దోనివొతె వెగ, యేసుక చజుక మెన, కపెర్నహూమ్ పట్నుమ్‍తె గెచ్చ పాఁవిల. ");
INSERT INTO key_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ప్రెజల్ గాడు జీన, యేసుక చజ, జో తిలిసి జానన “గురుబాబు, కెఁయ ఉట్ట అయ్‍లది?” మెన పుసిల. ");
INSERT INTO key_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","యేసు జోవయింక, “తుమ్ ఆఁవ్ నిజుమి కచితుమ్ కిచ్చొ మెంతసి మెలె, తుమ్ ఒత్త పేట్ బెర్తు పోడియొ కా కెర సుకుమ్ జలి రిసొ అంక చజుక అయ్‍లదు, గని అంచి అదికారుమ్‍క రుజ్జు దెకయ్‍లి జా కామ్‍చి గుర్తు అర్దుమ్ కెరన్లి రిసొ నాయ్. ");
INSERT INTO key_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ఆఁగ్ సుకుమ్ కెర్తి అన్నిమ్ గట్రచి రిసొ తుమ్ ఉచర్తె తా నాయ్. జా ఎత్కి పాడ్ జతిసి. అన్నిమ్, మెన పరలోకుమ్‍తె బెదితి సెక్తి దెతిస్‍క టాలి కెర్లె, జయ్యి అన్నిమ్‍క కోర్‍ప జా. జయ్యి అన్నిమ్, జలె, కెఁయఁక తెఁయఁక తా గెతిసి. జయ్యి అన్నిమ్. జలె, ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ తుమ్‍క దెయిందె. జయ్యి తుమ్‍క ముక్కిమ్. జా దెంక అంక అదికారుమ్ కీసి తంక మెలె, దేముడు అబ్బొ, దేముడు, అంచి అదికారుమ్‍చి రిసొ సాచి సంగ జోచి ముద్ర దా అస్సె,” మెన ప్రెజల్‍క యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","తెదొడి జేఁవ్ ప్రెజల్ జోక “దేముడుచ కమొ అమ్ కెరుక మెలె, అమ్ కిచ్చొ కెర్లె జయెదె?” మెన పుసిల. ");
INSERT INTO key_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","యేసు జోవయింక “దేముడు తుమ్‍క కిచ్చొ పూచి తియార్తయ్ మెలె, ఆఁవ్ జో తెద్రయ్‍లొసొక తుమ్ పూర్తి నంపజంకయ్” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","సంగితికయ్, జేఁవ్ జోక “జలె, ‘జో తెద్రయ్‍లొ రచ్చించుప కెర్తొసొ తుయి’ మెన అమ్ దయిరిమ్ తెన్ నంపజతి రిసొ తుచి అదికారుమ్‍క కిచ్చొ గుర్తు అమ్‍క దెకయ్‍తె? కిచ్చొ వెల్లి కామ్ కెర అమ్‍క రుజ్జు దెకయ్‍తె? ");
INSERT INTO key_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","అమ్‍చ పూర్గుమ్‍చ వెల్లి బయిలె బుల్తె తిలి పొది, ‘మన్నా’ మెలి పోడియొ రితిసి కతె తిల. జాకయ్, పరలోకుమ్‍తె తెంతొ చి పోడియొ రితిసి జోవయింక జో దిలొ మెన దేముడుచ కొడొతె రెగ్డ అస్సె, గెద” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ప్రెజల్ యేసుక దస్సి సంగితికయ్, జో జోవయింక, “తుమ్‍క కిచ్చొ నిజుమి కచితుమ్ ఆఁవ్ సంగితసి మెలె, తుమ్‍చ పూర్గుల్‍క పరలోకుమ్ తెంతొ చి పోడియొ మోసే దిలిసి నెంజె. దేముడు అబ్బొయి దిలిసి. జలె, తుమ్‍క నిజుమ్ జలి పోడి రితి, నిజుమ్ జలి పోడి దేముడు అబ్బొ అప్పె పరలోకుమ్ తెంతొ తెద్రవ దా తుమ్‍క దెతయ్. ");
INSERT INTO key_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","దేముడు అబ్బొ దిలి జయ్యి పోడియొ, కిచ్చొ జయెదె మెలె, పరలోకుమ్ తెంతొ అప్పె రితి ఉత్ర అయ్‍లిసి. జయ్యి పోడి ఒండి లోకుమ్‍చక సరి జతి జీవ్ దెతిసి” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","యేసు దస్సి సంగితికయ్, “బాబు, జయ్యి పోడి అమ్‍క దెతె తా” మెన ప్రెజల్ సంగిల. ");
INSERT INTO key_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","జలె, యేసు జోవయింక, “సరి జతి జీవ్ దెతి జా పోడి ఆఁవ్వి. కో అంక పూర్తి నంపజా అంచితె జెవుల గే, జోవయింక చూ, తాన్ కెఁయఁక అన్నె కెరె నాయ్. ");
INSERT INTO key_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","గని, ‘అంక దెకిలెకి తుమ్ నంప కెర్సు నాయ్’ మెన తుమ్‍క అగ్గె తెంతొ సంగితసి. ");
INSERT INTO key_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","“‘నంపజా రచ్చించుప జతు’ మెన కక్క దేముడు అబ్బొ అంచితె తెద్రయెదె గే, జెవుల, చి కో అంక నంపజా జెవుల గే, జోవయింక కెఁయఁక కి ‘తుమ్‍క నెసి’ మెన ఉదడి నాయ్. ");
INSERT INTO key_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ఆఁవ్ పరలోకుమ్ తెంతొ అయ్‍లిసి కిచ్చొక మెలె, అంచి సొంత ఇస్టుమ్ అయ్‍లి రితి కెరుక నాయ్, గని, అంక తెద్రయ్‍లొసొ సంగిలిసి నెరవెర్సుప కెరుకయ్. ");
INSERT INTO key_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","అంక నంపజతి రిసొ కక్క జో అంచితె తెద్రయెదె గే, జోవయింతె కక్క నే పిట్టయ్‍తె, వెల్లి తీర్పు కెర్తి జా ఆకర్ దీసిక, జోవయింక జియడ పరలోకుమ్‍తె బెదవుక అస్సె. ");
INSERT INTO key_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","మెలె, అంచొ అబ్బొసి జలొ దేముడుచి ఇస్టుమ్ కిచ్చొ మెలె, ‘దేముడు ప్రబుచొ ఎక్కి పుత్తుసి ఈంజొయి’, మెన ‘ఈంజొయి అమ్‍క దొర్కు జలొ రచ్చించుప కెర్తొసొ’ మెన, కో అంక చిన పూర్తి నంపజవుల గే, పరలోకుమ్‍తె బెదితి జీవ్ జోవయింక దొర్కు జయెదె, చి వెల్లి తీర్పు కెర్తి జా ఆకర్ దీసిక జోవయింక జియడ పరలోకుమ్‍తె బెదయిందె. ఈంజయ్ అబ్బొసి జలొ దేముడుచి ఇస్టుమ్” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","‘పరలోకుమ్ తెంతొ ఉత్ర అయ్‍లి పోడి ఆఁవ్వి’ మెన యేసు సంగిలి రిసొ, ఒత్త తిల జేఁవ్ యూదుల్‍చ వెల్లెల మాన్సుల్ జోచి రిసొ కోపుమ్ జా, ");
INSERT INTO key_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ఇసి మెన లట్టబన్ల. “ఈంజొ యేసు యోసేపుచొ పుత్తుసి, గెద. జోచ అయ్యస్అబ్బొస్‍క జానుమ్, గెద. దస్సి జలె, ‘పరలోకుమ్ తెంతొ ఉత్ర అయ్‍లయ్’ మెన కిచ్చొక సంగితయ్?” మెన ఆఁసిల. ");
INSERT INTO key_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","జేఁవ్ దస్సి జతికయ్, యేసు జోవయింక కిచ్చొ జబాబ్ దిలన్ మెలె, “ఆఁవ్ సంగిలిస్‍చి రిసొ అన్మానుమ్ జా లట్టబన నాయ్. ");
INSERT INTO key_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","అంక తెద్రయ్‍లొ దేముడు అబ్బొ మాన్సుచి పెట్టి జోవయింక సికడ బుకార్లెకయ్ జేఁవ్ అంక నంపజా జెవుల. అయ్‍లె, వెల్లి తీర్పు కెర్తి జా ఆకర్ దీసిక జోవయింక జియడ పరలోకుమ్‍తె బెదయిందె. ");
INSERT INTO key_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","పూర్గుల్‍చి అత్తి సంగిల దేముడుచ కబుర్లుచ కొడొతె రెగ్డ అస్సె. దేముడు జేఁవ్ ఎత్కిజిన్‍క సొంత సికడెదె” మెన రెగిడ్లి కోడు. దేముడు అబ్బొ జోవయింక సంగిలిసి కో సూన సికుల గే, అంక నంపజా జెవుల. ");
INSERT INTO key_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“జోతె తెంతొ అయ్‍లొసొక పిట్టవ, కోయి దేముడు అబ్బొక కెఁయ దెకితి నాయ్. ఎక్కిలొయి జోక దెక అస్సె. ");
INSERT INTO key_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","జలె, ఆఁవ్ తుమ్‍క కిచ్చొ నిజుమి కచితుమ్ సంగితసి మెలె, అంక కో సత్తిమ్ తెన్ నంపజవుల గే, జేఁవ్ నంపజలి తెంతొ, పరలోకుమ్‍చి రాజిమ్‍తె బెదయ్ అస్తి. ");
INSERT INTO key_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","సరి జతి జీవ్ దెతి పోడి, ఆఁవ్వి. ");
INSERT INTO key_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","“తుమ్‍చ పూర్గుమ్‍చ జా వెల్లి బయిలె బుల్తె తిలి పొది ‘మన్నా’ మెలి జా పోడి కయ్‍లెకి, మాములుమ్ మొర్తి సమయుమ్ జా అయ్‍లె పొది, మొర గెల. ");
INSERT INTO key_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ఆఁవ్ అప్పె సంగితిసి, జలె, పరలోకుమ్ తెంతొ దొర్కు జతి ఈంజయ్ పోడి, జలె, కిచ్చొక ఉత్ర జా అస్సె మెలె, ఈంజయి పోడి, కో కవుల గే, మొర్లె పొది సిచ్చ తిలి మొర్నుతె గెతి నాయ్. ");
INSERT INTO key_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","పరలోకుమ్ తెంతొ ఉత్ర అయ్‍లి జీవ్ దెతి పోడి ఆఁవ్వి. ఈంజయ్ పోడి కో కవుల గే, పరలోకుమ్‍తె గెచ్చ కెఁయఁక తెఁయఁక చెంగిల్ జివుల. జలె, ‘జోవయించి పాపుమ్‍చి సిచ్చ జతి మొర్నుతె గెతు నాయ్, గని అంచి వరుమ్ నఙ రచ్చించుప జతు’ మెన ఆఁవ్ కిచ్చొ పోడి దెయిందె మెలె, అంచి ఆఁగ్” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","యేసు జా సంగితికయ్, యూదుల్‍చ వెల్లెల మాన్సుల్ బమ్మ జా, “అమ్ కతి రిసొ ఈంజొ మాన్సు జోచి ఆఁగ్ అమ్‍క కీసి దెంక జయెదె?” మెన ఎక్కిలొ తెన్ ఎక్కిలొ లట్టబ్తె తిల. ");
INSERT INTO key_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","జాకయ్ యేసు జోవయింక, “తుమ్‍క ఆఁవ్ నిజుమి కచితుమ్ కిచ్చొ సంగితసి మెలె, ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొచి ఆఁగ్ తుమ్ నే కయ్‍లె, అంచి లొఁయి తుమ్ నే పిల్లె, తుమ్‍చి పెట్టి కిచ్చొ జీవ్ తయె నాయ్. ");
INSERT INTO key_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","అంచి ఆఁగ్ కో కవుల గే, అంచి లొఁయి కో పివుల గే, దేముడుచి రాజిమ్‍తె బెదితి జీవ్ జోవయింక దొర్కు జా అస్సె, చి వెల్లి తీర్పు కెర్తి జా ఆకర్ దీసిక, జోవయింక జియడ, పరలోకుమ్‍తె బెదయిందె. ");
INSERT INTO key_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","జాకయ్, అంచి ఆఁగ్ ముక్కిమ్ జలి అన్నిమ్, అంచి లొఁయి ముక్కిమ్ జలి పితిసి జయెదె. ");
INSERT INTO key_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","కో అంచి ఆఁగ్ కతి రితి అంచి లొఁయి పితి రితి జతతి గే, జో అంచి పెట్టి తత్తతి, చి ఆఁవ్ జోచి పెట్టి తయిందె. ");
INSERT INTO key_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","“జీవ్ తిలొ దేముడు అబ్బొ అంక ఈంజ లోకుమ్‍తె తెద్రయ్‍లొ. జోచి జీవ్ అంచి పెట్టి అస్సె, చి జోచి జీవ్‍కయ్ ఆఁవ్ జితసి. దస్సి అంకయ్ కో కయ్‍లి రితి జా అంక జోచి పెట్టి తియనుల గే, అంచి జీవ్‍చి రిసొ జేఁవ్ కి జివుల. ");
INSERT INTO key_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","పరలోకుమ్ తెంతొ ఉత్ర అయ్‍లి పోడి ఈంజయి. తుమ్‍చ పూర్గుమ్‍చ కయ్‍లి రగుమ్ నెంజె. గని, ఈంజయ్ పోడియొ కో కవుల గే, పరలోకుమ్‍తె గెచ్చ కెఁయఁక తెఁయఁక జివుల” మెన యేసు సికడ్లన్. ");
INSERT INTO key_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","యేసు కపెర్నహూమ్ పట్నుమ్‍చి జేఁవ్ యూదుల్‍చి సబ గెరి ఇసి మెన సికడ్లన్. ");
INSERT INTO key_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","యేసుక ఇదిల్ నంపజా సిస్సుల్ జంక దెర్ల మాన్సు, జలె, జో సంగిలిసి సూన కెర, జోవయింతె సగుమ్‍జిన్ బమ్మ జా, “జా కోడు అల్లర్‍చి! జా కోడు కో సూనుల!” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","జో నిసాన్ల సిస్సుల్ కి అన్మానుమ్ లట్టబ్‍తతి మెన యేసు పెట్టి జానిలన్, చి “ఆఁవ్ అప్పె సంగిలిస్‍చి రిసొ తుమ్ అన్మానుమ్ జతసు గే? ");
INSERT INTO key_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","జలె, ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ ఆఁవ్ అగ్గె తిలిస్‍తె అన్నె వెగ గెతిసి తుమ్ దెకిలె, కీస్ జస్తె! ");
INSERT INTO key_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","జీవ్ తిలెకయ్ మాన్సు జియెదె. జీవ్ నెంజిలె, ఆఁగ్ కామ్‍క నెంజె. ముక్కిమ్ జలి ఆఁవ్ సంగిలి జీవ్ కిచ్చొతె మెలె, ఆఁవ్ తుమ్‍క సంగిల కొడొతెయ్ అస్సె. ");
INSERT INTO key_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","గని తుమ్‍చితె సగుమ్‍జిన్ నంపజతి నాయ్” మెన జోవయింక సంగిలన్. జోవయింతె కో నంపజతి నాయ్ గే, అన్నె పడ్తొక జోక మార్తసచి అత్తి కో దెర దెయెదె గే, యేసు అగ్గె తెంతొ జానె. ");
INSERT INTO key_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","తెదొడి అన్నె, “జాకయ్ ‘దేముడు అబ్బొ జా సెక్తి దిలెకయ్, నెంజిలె కో కి అంక నంపజంక, అంచితె జెంక నెతిర్తి’ మెన తెదొడి సంగిలయ్” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","జలె, జా దీసి జో సంగిలిసి ఓర్సుప జంక నెత్ర కెర, జోవయించి పట్టి గెతె తిలసతె ఒగ్గర్‍జిన్ సిస్సుల్ అన్మానుమ్ జా, ఒత్త తెంతొ జో తెన్ బుల్తి నాయ్. ");
INSERT INTO key_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","జేఁవ్ దస్సి జతికయ్, జో నిసాన్ల బారజిన్ సిస్సుల్‍క యేసు, “తూమ్ కి అంక ముల దా ఉట్ట గెతె గే?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","“ప్రబు, అమ్ అన్నె కత్తెయ్ గెచ్చుమ్‍దే? దేముడుచి రాజిమ్‍తె బెదుక కీసి గే తుచయ్ కొడొతె సూనుక జతయ్, గని అన్నె కత్తెయ్ నాయ్. ");
INSERT INTO key_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","జాకయ్ ‘దేముడుచి సుద్ది తిలొసొ క్రీస్తు తుయి’ మెన తుకయ్ అమ్ నంపజా అస్సుమ్, కచితుమ్ జానుమ్” మెన సీమోను పేతురు దయిరిమ్ తెన్ సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","తెదొడి యేసు జేఁవ్ బారజిన్‍క కిచ్చొ జాగర్త సంగిలన్ మెలె, “తుమ్ బారజిన్ ఎత్కిక ఆఁవ్ నిసాన్లయ్, గెద. గని, తుమ్‍చితె కి సయ్‍తాన్‍చొ సేవ కెర్తొసొ ఎక్కిలొ అస్సె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","కచి రిసొ దస్సి సంగిలొ మెలె, సీమోను ఇస్కరియోతు మెలొ ఎక్కిలొచొ యూదా మెలొ పుత్తుస్‍చి రిసొ. కిచ్చొక మెలె, పడ్తొ, జేఁవ్ జోక మార్తి రిసొ, విరోదుమ్ సుదల్‍చి అత్తి యూదా యేసుక దెర దెయెదె మెన తెదొడి కి యేసు జానె. ");
INSERT INTO key_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","జా మదెనె, యూదుల్‍చ వెల్లెల మాన్సుల్ జోక మారుక కోర్‍ప జా అస్తి మెన యేసు జానెచి రిసొ జోవయింక ముక్కిమ్ తిలి యూదయ ప్రదేసిమ్‍తె గెచ్చె నాయ్, గని గలిలయ ప్రాంతుమ్‍తె బుల్తె తిలొ. ");
INSERT INTO key_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","జలె, యూదుల్‍చి అన్నెక్ పండుగు పాసి జా అయ్‍లి. జాక ‘కుడియల్ పండుగు’ మెనుల. ");
INSERT INTO key_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","జలె, యేసుచ బావుడ్సివొ జోక కిచ్చొ మెల మెలె, “ఒత్త తిల తుచ సిస్సుల్ జల మాన్సుల్ దెకితి రిసొ, ఈంజ డొంగుర్ దేసిమ్ ముల దా, యూదయ ప్రదేసిమ్‍తె గెచ్చ, తుచ వెల్లెల కమొ ఒత్తయ్ కెరు. ");
INSERT INTO key_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","మెలె, ‘అంచి అదికారుమ్ మాన్సుల్ చినుతు’ మెన ఎక్కిలొచి ఆస జలె, జోచ కమొ కో నెంజిల్‍తె కెరె నాయ్. ఒగ్గర్‍జిన్ తిలిస్‍తె కెరెదె. తుయి వెల్లెల కమొ కెర్తసి జలె, ఎత్కిజిన్ దెకితి రితి ఒత్త కెరు” మెన సికడుక దెర్ల. ");
INSERT INTO key_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","జోచి అయ్యస్‍చి పెట్టి జెర్మిల ఈంజేఁవ్ బావుడ్సివొ కి జోక ‘దేముడు తెద్రయ్‍లొ క్రీస్తు రచ్చించుప కెర్తొసొ’ మెన నంప కెర్తి నాయ్. ");
INSERT INTO key_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","జేఁవ్ దస్సి సంగితికయ్, యేసు జోవయింక, “ఆఁవ్ గవురుమ్ జతి సమయుమ్ జెంక నేతయ్. తూమ్, మాత్రుమ్, కెద్దొడ్ తెదొడ్ గవురుమ్ జంక జతయ్. ");
INSERT INTO key_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","జేఁవ్ కెర్తి రితి తూమ్ కి కెర్తసుచి రిసొ, ఈంజ లోకుమ్‍చ మాన్సుల్ తుమ్‍క విరోదుమ్ దెకుక నెతిర్తి, గని జోవయించ కమొక ‘గర్చ’ మెన ఆఁవ్ తీర్పు సంగితసిచి రిసొ అంక విరోదుమ్ దెకితతి. ");
INSERT INTO key_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","తుమి ఒత్త గెచ్చ పండుగు కెర. ఆఁవ్ అప్పెచి మట్టుక ఈంజ పండుగ్‍క గెచ్చి నాయ్. ఆఁవ్ గెతి సమయుమ్ పూర్తి జెంక నేతయ్” మెన సంగ, ");
INSERT INTO key_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","యేసు గలిలయతె తా గెలొ. ");
INSERT INTO key_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","జలె, జోవయించ బావుడ్సివొ పండుగ్‍తె ఉట్ట గెలి ఇదిల్ పడ్తొ, యేసు కి గెలన్. ఎత్కిజిన్ దెకిత్ రితి నాయ్, గని కో నేన్లి రితి గెలన్. ");
INSERT INTO key_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","జా మదెనె, పండుగ్‍తె గెల యూదుల్‍చ వెల్లెల మాన్సుల్ ‘యేసు కేతె?’ మెన జోక చజితె తిల. ");
INSERT INTO key_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ప్రెజల్ కి జోచి రిసొ జోవయింతెన్ ఇనయింతెన్ లట్టబ్తె తిల. “జో చెంగిలొ మాన్సు” మెన సగుమ్‍జిన్ సంగితె తిలె, “నాయ్, ప్రెజల్‍క మోసిమ్ కెర్తయ్” మెన అన్నె సగుమ్‍జిన్ సంగితె తిల. ");
INSERT INTO key_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","గని వెల్లెల మాన్సుల్‍క బియఁ కెర, జోచి రిసొ కో ఎదార్దుమ్ లట్టబ్తి నాయ్. ");
INSERT INTO key_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","జలె, సగుమ్ పండుగ్ కేడ్లి పొది, యేసు దేముడుచి గుడితె గెచ్చ, తెడి పెస, బోదన కెరుక దెర్లన్. ");
INSERT INTO key_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","జోచి బోదన సూన కెర, యూదుల్‍చ వెల్లెల మాన్సుల్ “అమ్‍చి తెన్ ఈంజొ మాన్సు కెఁయ నే సదు కెర్లె కి, బలే తెలివి తెన్ బోదన కెర్తయ్, కీసి?” మెన ఆచారిమ్ తెన్ లట్టబన్ల. ");
INSERT INTO key_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","జాచి రిసొ యేసు జోవయింక కిచ్చొ జబాబ్ దిలన్ మెలె, “ఆఁవ్ కెర్తి బోదన ఆఁవ్ ఉచర్లిసి నెంజె. ఈంజ అంక తెద్రయ్‍లొసొచి బోదన. ");
INSERT INTO key_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","అంక తెద్రయ్‍లొసొచి ఇస్టుమ్ రితి కెరుక కో కోర్‍ప జవుల గే, జెఁవ్వి అంచి బోదన సూన్లె, జేఁవ్ ‘దేముడు సికడ్లిసి జయెదె గే, నాయ్ మెలె, ఆఁవ్ ఉచర్లిసి జయెదె గే’ జోవయించి పెట్టి చినుల. ");
INSERT INTO key_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","గవురుమ్ ఆననుక ఆస జలస, జలె, జేఁవ్ జేఁవ్‍చి ఉచర్లిసి సికడుల. గని, జోక తెద్రయ్‍లొసొచి గవురుమ్ దెకవుక ఆస జలొసొ జలె, సత్తిమ్‍చొ జయెదె, జోతె కిచ్చొ అబద్దుమ్ తయె నాయ్. ");
INSERT INTO key_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“మోసే పూర్గుమ్‍చొ దేముడుచ ఆగ్నల్ తుమ్‍చి రిసొ దేముడుచ ఆగ్నల్ రెగ్డ దిలన్. గని ఒత్త తిల ఆగ్నల్ రితి తుమ్‍చితె కో కి నిదానుమ్ కెర్సు నాయ్. నెంజిలె, కిచ్చొక అంక మారుక కోర్‍ప జతసు?” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","యేసు దస్సి సంగితికయ్, ప్రెజల్ తుక “బూతుమ్ దెర అస్సె, కిచ్చొగె, చి దస్సి సంగితసి! కో తుక మారుక కోర్‍ప జతతి?” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","జలె, యేసు జోవయింక, “ఆఁవ్ జా సెలవ్ కడన్లి దీసి జో రోగిక చెంగిల్ కెర్లి కామ్ కెర్లయ్, చి ‘కామ్ కెర సెలవ్ కడన్లి దీసిచి ఆగ్న పిట్టయ్‍లొ’ మెన తుమ్ ఎత్కిజిన్ అంచి రిసొ బమ్మ జతసు. ");
INSERT INTO key_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","తుమ్ ఉచర. ‘తుమ్ యూదుల్‍క మున్సుబోద జెర్మిలె, జోవయింక దేముడుచొ మాన్సు జవుస్’ మెన సున్నతి కెరనుక, జో బోదక ఇదిలిస్ సుద్ది కెర మెన మోసే పూర్గుమ్‍చొ రెగిడ్లొ, గెద. జా కారిమ్, జలె, మోసే తెన్ మొదొల్ జలిసి నెంజె. జోచి కంట అగ్గెచ పూర్గుల్ కి దస్సి కెర్తె తిల. గని సున్నతి కెర మెన ఆగ్నల్‍తె రెగిడ్లన్. జాకయ్, ఏక్ నాడు జెర్మ అట్టు పొదుల్ జలిసి సెలవ్ కడన్లి దీసి సేడ్లె, జా ఆగ్న పిట్టుస్ నాయ్ మెన, జయ్యి దీసి, సెలవ్ కడన్లి దీసి జలెకి, జా కామ్ కెర్తసు. ");
INSERT INTO key_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","జలె, ‘మోసే రెగిడ్లి దేముడుచి ఆగ్నల్ తెన్, ఈంజ ఏక్ ఆగ్న పిట్టుస్ నాయ్’ మెన సెలవ్ కడన్లి దీసి కి ఏక్ మాన్సుకి సున్నతి కెరుక జయెదె జలె, సెలవ్ కడన్లి దీసి కి ఏక్ ఒండొయి మాన్సుచి ఆఁగ్ చెంగిల్ కెరుక నెంజె గె? ");
INSERT INTO key_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","జలె, కిచ్చొ జవుస్ జర్గు జా తిలె, ఇసి గే దస్సి గే డీసిలి రిసొ ‘ఆగ్న పిట్లి’ జవుస్, నాయ్ మెలె, ‘ఆగ్న పిట్టె నాయ్’ రిత ఆగ్నల్‍క నంపజా అస్సుస్. దస్సి, అర్దుమ్ నెంతె, కన్కారుమ్ నెంతె తీర్పు కెరుక పోన. ఆగ్నచి అర్దుమ్, జర్గు జలిస్‍చి అర్దుమ్, సరిగా ఉచర తీర్పు కెర” మెన జేఁవ్ వెల్లెల మాన్సుల్‍క యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","యేసు దస్సి బోదన కెర్తికయ్, యెరూసలేమ్ పట్నుమ్‍చ మాన్సుల్ సగుమ్‍జిన్ “‘జోక మారుమ’ మెన వెల్లెల మాన్సుల్ కోర్‍ప జలొసొ ఈంజొయి, కిచ్చొగె. ");
INSERT INTO key_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","గని, ఈందె, జోవయించి మొక్మె దయిరిమ్ తెన్ బోదన కెర్తయ్, గని జోక ‘పోని’ కి మెంతి నాయ్. జలె, జోక ‘తెద్రయిందె’ మెన దేముడు సంగిలొ ‘దొర్కు జలొ రచ్చించుప కెర్తొసొ జతొ క్రీస్తు ఈంజొయి’ మెన ఏక్ వేల అదికారుల్‍క రుజ్జు జా అస్సె గె? ");
INSERT INTO key_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","నాయ్, కిచ్చొగె. మెలె, ఈంజొ మాన్సు కేనె తెంతొ అయ్‍లొ గే జానుమ్. గని క్రీస్తు అయ్‍లెగిన, కేనె తెంతొ జెతయ్ గే కక్క నేన్‍తె జయె నాయ్” మెన ఉచర లట్టబన్ల. ");
INSERT INTO key_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","జేఁవ్ ఉచర్లిసి యేసు జాన్లి రిసొ, దేముడుచి గుడితె బోదన కెర్తె తిలి పొది, ఇసి మెన కేక్ గలన్. “‘జోక జానుమ్! జో కేనె తెంతొ అయ్‍లొ గే అమ్ జానుమ్!’ మెన, అంచి రిసొ తుమ్ ఉచర్తసు జలె. గని నేన్సు. ఆఁవ్ అఁవ్వి జెంక నాయ్. అంక తెద్రయ్‍లొసొ సత్తిమ్ తిలొసొ. జోక తుమ్ నేన్సు. ");
INSERT INTO key_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ఆఁవ్ మాత్రుమ్, జోక జాని. కీసి మెలె, ఆఁవ్ జోతె తెంతొ ఉత్ర అయ్‍లయ్. జొయ్యి అంక తెద్రయ్‍లన్” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","యేసు దస్సి సంగితికయ్, జేఁవ్ వెల్లెల మాన్సుల్ “జోక జేలి కెరుమ!” మెన ఉచర్ల, గని జోక కో దెర్తి నాయ్. కిచ్చొక మెలె, అబ్బొస్‍తె జో గెతి సమయుమ్ తెదొడి జెంక నేతయ్. ");
INSERT INTO key_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","యేసుక వెల్లెల మాన్సుల్ దస్సి విరోదుమ్ జలెకి, మాములుమ్ ప్రెజల్, జలె, ఒగ్గర్‍జిన్ జోక నంపజల. “ఈంజొ మాన్సు ఒగ్గర్ ఒగ్గర్ వెల్లెల కమొ కెర్తయ్. క్రీస్తు మెలొ అమ్‍చొ రచ్చించుప కెర్తొసొ అయ్‍లె ఇసి తయెదె. అన్నె వెల్లెల కమొ కెరుక కో తెరితి గే? ఈంజొ జొయ్యి, కిచ్చొగె” మెన నంపజల. ");
INSERT INTO key_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ప్రెజల్ యేసుక నంపజలి రితి జా ఎక్కిలొ తెన్ ఎక్కిలొ ఇసి తిరీమ్ లట్టబంతిసి పరిసయ్యుల్ సూన్లచి రిసొ “జోక జేలి కెరుక దెర జా!” మెన దేముడుచి గుడితెచ జమాన్లుక వెల్లెల పూజర్లు చి పరిసయ్యుల్ తెద్రయ్‍ల. ");
INSERT INTO key_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","జలె, జా మదెనె యేసు అన్నె బోదన కెర్తె తా, “అన్నె సగుమ్ దీసల్ తుమ్‍చి తెన్ తయిందె, చి తెదొడ్‍క అంక తెద్రయ్‍లొసొతె అన్నె ఉట్ట గెచ్చిందె. ");
INSERT INTO key_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ఆఁవ్ ఉట్ట గెలి పడ్తొ తుమ్ అంక చజితె, గని అంచితె పాఁవుక నెతుర్సు. ఆఁవ్ కేనె తయిందె గే, తుమ్ ఒత్త జెంక నెతుర్సు” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","జాకయ్ యూదుల్‍చ వెల్లెల మాన్సుల్ ఎక్కిలొక ఎక్కిలొ “అమ్ నే పాఁవితి రితి ఈంజొ కేనె గెచ్చెదె? గ్రీకు దేసిమి తిల చెదుర్ప జల అమ్‍చ యూదుల్‍తె గెచ్చ, గ్రీసు దేసుమ్‍చ సుదల్‍క బోదన కెరెదె గే? ");
INSERT INTO key_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","నాయ్ మెలె, ‘తుమ్ అంక చజిలె కి అంచితె పాఁవుక నెతుర్సు’ మెన ‘కేనె తయిందె గే, తుమ్ ఒత్త జెంక నెతుర్సు’ మెన కిచ్చొక సంగిలన్?” మెన లట్టబనుక దెర్ల. ");
INSERT INTO key_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","జా పండుగ్‍చి ఆకర్ దీసి అయ్‍లి. జాక ‘వెల్లొ దీసి’ మెనుల. జా దీసి, ఎత్కిజిన్ బెర తిలిస్‍తె యేసు టీఁవ జా, ఇసి మెన కేక్ గలన్. “కక్క జలెకు తాన్ కెర్లె, అంచితె జా పివుసు. ");
INSERT INTO key_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","కో అంక పూర్తి నంపజవుల గే, దేముడుచి కొడొతె రెగ్డయ్‍లి రితి, జోచి పెట్టి తెడి ఊంట పుట్లి రితి జా, జీవ్ దెతొ పాని జోచి ఆత్మ చెంగిల్ కెర్తె తయెదె” మెన, ఎత్కిజిన్ సూన్‍తి రితి యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","‘జీవ్ దెతొ పాని’ మెన కిచ్చొచి గుర్తుక సంగిలన్ మెలె, దేముడుచి సుద్ది తిలి ఆత్మచి గుర్తుకయ్. యేసు మొర దేముడు అబ్బొస్‍తె అన్నె గెలె, జోక కో నంపజా తవుల గే, జోచి జా ఆత్మ జోవయించి పెట్టి జెయెదె. జలె, యేసు తెదొడి అబ్బొస్‍తె అన్నె గెచ్చుక, గవురుమ్ జంక, నేతయ్‍చి రిసొ, జో సంగిలి జా ఆత్మ తిలిసి తెదొడి జర్గు జంక నేతయ్. ");
INSERT INTO key_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","యేసు దస్సి బోదన కెర్తికయ్, సూన కెర జోచి రిసొ ప్రెజల్ సగుమ్‍జిన్ కిచ్చొ మెల మెలె, “‘తెద్రయిందె’ మెన దేముడు సంగిలొ జోచ కబుర్లు సంగుక జెంక తిలొసొ ఈంజొ నిజుమ్ జా తయెదె” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","గని అన్నె సగుమ్‍జిన్ “తెద్రయిందె మెన దేముడు సంగిలొ క్రీస్తు రచ్చించుప కెర్తొసొ జా తయెదె” మెల, గని “నెంజె. ఈంజొ గలిలయ ప్రాంతుమ్‍చొ మాన్సు. క్రీస్తు, జలె, గలిలయతె జెర్ముక నెంజె. ");
INSERT INTO key_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ఈందె, దేముడుచి కొడొతె రెగిడ్లి రితి, అమ్‍చొ రానొ జలొ దావీదు పూర్గుమ్‍చొచి సెకుమ్‍తె క్రీస్తు జెర్మెదె. దావీదుచి గాఁవ్ బేత్లెహేమ్. ఒత్తయ్ జో జెర్ముక అస్సె. దస్సి జలె ఈంజొ క్రీస్తు జయె నాయ్” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","దస్సి జతికయ్, జోచి రిసొ ప్రెజల్ దొన్ని మెన్సు జల. ");
INSERT INTO key_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","జోవయింతెన్ సగుమ్‍జిన్ “జోక జేలి కెర్తు!” మెన కోర్‍ప జల. గని జోక దెరుక మెన కో చడితి కి నాయ్. ");
INSERT INTO key_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","తెదొడి, జోక దెర్తి రిసొ గెచ్చ తిల జమాన్లు వెల్లెల పూజర్లు చి పరిసయ్యుల్ తిలిస్‍తె అన్నె అయ్‍ల. జెతికయ్, జేఁవ్ పరిసయ్యుల్, పూజర్లు, “కిచ్చొక జోక దెర ఆన్సు నాయ్?” మెన గోల కెర్ల. ");
INSERT INTO key_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","గోల కెర్తికయ్, జేఁవ్ జమాన్లు, “కేన్ మాన్సు కెఁయ తెద్ది చెంగిల్‌చి బోదన సంగె నాయ్” మెన సాచి సంగిల. ");
INSERT INTO key_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","పరిసయ్యుల్ కోపుమ్ జా జోవయింక కిచ్చొ జబాబ్ దిల మెలె, “తూమ్ కి జోచ కొడొక మోసిమ్ జలదు గే? ");
INSERT INTO key_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","అమ్ పరిసయ్యుల్‍తె జవుస్, అమ్‍చ అదికారుల్‍తె జవుస్ కో జలెకు జోక నంపజా అస్సుమ్ గే? నాయ్, గెద. దస్సి జలె, తూమ్ కిచ్చొక జోక నంప కెరుక? ");
INSERT INTO key_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","మాములుమ్ ఈంజేఁవ్ ప్రెజల్ నంప కెర అస్తి, గని మోసే తెన్ దేముడు దిలి ఆగ్నల్ నేన్‍తి జేఁవ్‍క కిచ్చొ పున్నిమ్ నాయ్, దేముడుక నేన్‍తి” మెన ప్రెజల్ నంపజలిస్‍క వెల్లెల మాన్సుల్ నిస్కారుమ్ సంగిల. ");
INSERT INTO key_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","యేసుతె అగ్గె రాతి లుంకచోరు కిచ్చొగె పుసుక గెచ్చ తిలొ నీకొదేమొ మెలొ పరిసయ్యుడు, జలె, జో వెల్లెల మాన్సుల్‍తె అస్సె. ");
INSERT INTO key_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","అన్నె తిల జేఁవ్ వెల్లెల మాన్సుల్‍క జో, జలె, “కేన్ జలెకు మాన్సుక నేరిమ్ వయడ తిలె, దేముడు మోసే తెన్ దిలి ఆగ్నల్‍తె రెగ్డయ్‍లి రితి జో మాన్సు సంగన్‍తి సాచి నే సూన్‍తె అగ్గె, జో కిచ్చొ కెర్లొ గే నాయ్ గే, రుజ్జు నే దెకయ్‍తె అగ్గె జోక తీర్పు కెర సిచ్చ కెరుక అమ్‍చి తెన్ నాయిమ్ గే? నాయ్, గెద” మెన జాగర్త సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","జేఁవ్ అన్నె పండితుల్ నీకొదేమొక కిచ్చొ జబాబ్ దిల మెలె, “తూయి కి గలిలయచొ గే, చి జోచి పచ్చెనచి కోడు తుయి సంగితసి? దేముడుచి కొడొ సరిగా సదు కెరు, చి దేముడుచ కబుర్లు సంగితస కో కి గలిలయతె జెర్మితి నాయ్ మెన దెకితె” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","తెదొడి ఎత్కిజిన్ జోవయించ గెరలె ఉట్ట గెల. ");
INSERT INTO key_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","యేసు, దేముడుచి గుడి తెంతొ బార్ జా, జేఁవ్‍చి మొక్మె తిలి ఒలీవ మెట్టయ్ ఎక్కిలొ గెలన్. ");
INSERT INTO key_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","చి రాత్ పాయితికయ్, దేముడుచి గుడితె అన్నె ఉట్ట అయ్‍లొ. అయ్‍లె, ఒగ్గర్‍జిన్ జనాబ్ అయ్‍ల, చి జో వెస కెర, జోవయింక బోదన కెరుక దెర్లన్. ");
INSERT INTO key_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","యేసు బోదన కెర్తె తతికయ్, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస, పరిసయ్యుల్, బెద జా, ఏక్ తేర్‍బోదక కడ ఆన్ల. జా తేర్‍బోద లంజె జతె తతికయ్, దెర తిల. జలె, బెర తిల మాన్సుల్‍చి నెడిమి జాక టీఁవడ్ల. ");
INSERT INTO key_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","యేసుక కిచ్చొ మెల మెలె, “గురుబాబు ఈంజ తేర్‍బోద లంజె జతె తతికయ్, దెర్ల. ");
INSERT INTO key_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","‘ఇస లంజె జలసక పత్రల్ తెన్ పెట మారుక అస్సె’ మెన అమ్‍చొ మోసే పూర్గుమ్‍చొచి అత్తి రెగిడ్లి దేముడుచి ఆగ్నల్‍తె అమ్‍క ఆగ్న దిలన్. జలె, ఈంజ తేర్‍బోదచి రిసొ తూయి కిచ్చొ తీర్పు సంగితె?” మెన యేసుక పుసిల. ");
INSERT INTO key_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","కిచ్చొక దస్సి పుసిల మెలె, జో కిచ్చొ జవుస్ తప్పు సంగిలె, నేరిమ్ వయడుమ! మెన దస్సి కెర్ల. యేసు మాత్రుమ్, వంపొ జా, బుఁయ్యె ఊంటి తెన్ కిచ్చొగె రెగిడ్లన్. ");
INSERT INTO key_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","జేఁవ్ జోక పుసుక ములితి నాయ్ చి రిసొ యేసు టీఁవ, జోవయింక, “తుమ్‍చితె కో కిచ్చొ పాపుమ్ నే కెర తయెదె గే, జొయ్యి తొలితొ చి పత్తురు జాక గలుక జయెదె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","చి అన్నె వంపొ జా, బుఁయ్యె అన్నె కిచ్చొగె రెగిడ్లన్. ");
INSERT INTO key_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","జలె, జో సంగిలిసి ఎత్కిజిన్ సూన అర్దుమ్ కెరన, తొలితొ వెల్లెల మాన్సుల్, పడ్తొ ఎత్కిజిన్ ఎక్కిలొచి పట్టి ఎక్కిలొ వర్స తెన్ బార్ జా, ఉట్ట గెల, చి టీఁవ తిలి జా తేర్‍బోదక పిట్టవ, యేసు ఎక్కిలొ ఒత్త తిలొ. ");
INSERT INTO key_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","జలె, యేసు అన్నె ఉప్పిరి దెక, జా తేర్‍బోదక, “అమ్మ, కేతె జేఁవ్ ఎత్కిజిన్? కో తుక నేరిమ్ వయడ్తి నాయ్?” మెన సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","జా తేర్‍బోద యేసుక, “బాబు, కోయి నాయ్!” మెన సంగిలి. తెదొడి యేసు జాక, “ఆఁవ్ కి తుక నేరిమ్ వయడి నాయ్. తుయి గో, చి అప్పె తెంతొ పాపుమ్ నే కెర్తె జి!” మెన సంగ తెద్రవ దిలన్. ");
INSERT INTO key_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","అన్నెక్ సుట్టు యేసు బోదన కెర్తె తత్తికయ్ కిచ్చొ మెన సంగిలన్ మెలె, “ఈంజ లోకుమ్‍చక దొర్కు జలి ఉజిడి ఆఁవ్వి. కో అంచి పట్టి ఇండుల గే, అందర్‍తె తిలి రితి అందర్‍బుద్ది ఇండితి నాయ్, గని జీవ్ దెతి ఉజిడి జోవయింక దొర్కు జా జోవయించి పెట్టి తయెదె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","జో దస్సి సంగితికయ్, పరిసయ్యుల్ జోక, “తుచి రిసొ తుయి సాచి సంగితసి; తుచి సాచి సత్తిమ్‍చి నెంజె” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","జలె, యేసు జోవయింక, “ఆఁవ్ సొంత సాచి సంగన్లె కి, అంచి సాచి సత్తిమి. కిచ్చొక మెలె, ఆఁవ్ కేనె తెంతొ అయ్‍లయ్ గే, కేనె అన్నె గెతసి గే, ఆఁవ్ జాని గని కేనె తెంతొ ఆఁవ్ అయ్‍లయ్ గే, కేనె గెతసి గే, తూమ్ నేన్సు. ");
INSERT INTO key_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","తూమ్ అఁవ్వి కెర మాన్సు ఉచర్తి రగుమ్ తీర్పు కెర్తసు, గని ఆఁవ్ అప్పెచి మట్టుక కక్క తీర్పు కెరి నాయ్. ");
INSERT INTO key_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","గని ఆఁవ్ తీర్పు కెరుక జలె, అంచి తీర్పు సత్తిమ్ జయెదె. కిచ్చొక మెలె, ఆఁవ్ అఁవ్వి కెర కి ఎక్కిలొ కి తీర్పు కెరి నాయ్. ఆఁవ్, అంక తెద్రయ్‍లొసొ తెన్ని తీర్పు కెరుమ్‍దే. ");
INSERT INTO key_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","“‘కో దొగుల ఎత్కి రితి సాచి సంగుల గే, జా సాచి సత్తిమ్‍చి జయెదె’ మెన తుమ్‍చి మోసే పూర్గుమ్‍చొచి అత్తి దేముడు రెగ్డయ్‍ల ఆగ్నల్‍తె రెగ్డ అస్సె. ");
INSERT INTO key_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","జలె, ఆఁవ్ సొంత సాచి సంగితసి, చి అంక తెద్రయ్‍లొ అబ్బొ కి అంచి రితి ఎక్కి రితి సాచి సంగితయ్” మెన వెల్లెల మాన్సుల్‍క యేసు జబాబ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","జేఁవ్ జోక, “అబ్బొది కేతె?” మెన పుసిల. పుసితికయ్, యేసు జోవయింక, “తుమ్ అంక నేన్సు. అంచొ అబ్బొక కి నేన్సు. అంకయ్ జాన్‍తదు జలె, అబ్బొక కి జాన్‍తదు” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","బోదన కెర కెర ఇసి సంగిలి పొది యేసు కేనె తిలన్ మెలె, దేముడుచి గుడితెచి డబ్బుల్ పెట్టెల్ తిలి గదితె తిలన్. గని జోక జేలి కెర్తి నాయ్. కిచ్చొక మెలె, జో దేముడు అబ్బొస్‍తె గెతి సమయుమ్ జంక నేతయ్. ");
INSERT INTO key_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","జేఁవ్ వెల్లెల మాన్సుల్‍క యేసు అన్నె, “ఆఁవ్ ఉట్ట గెచ్చిందె. ఉట్ట గెలె, తుమ్ అంక చజిలె కి, తుమ్‍చ పాపల్ తెన్ని మొర గెతె. మొర గెలె, ఆఁవ్ గెతిస్‍తె తుమ్ జెంక నెతుర్సు” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","యూదుల్‍చ జేఁవ్ వెల్లెల మాన్సుల్ ఎక్కిలొ తెన్ ఎక్కిలొ కిచ్చొ మెల మెలె, “‘ఆఁవ్ గెతిస్‍తె తుమ్ జెంక నెతుర్సు’ మెన జో సంగిలిసి కిచ్చొక? జో అత్య కెరన ఎట్టొతొ గెచ్చెదె గే?” మెన లట్టబన్ల, ");
INSERT INTO key_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","జలె, యేసు జోవయింక, “తుమి ఎట్టొచ మాన్సుల్, ఆఁవ్ ఉప్పిర్ తెంతొచొ మాన్సు. తూమ్ ఈంజ లోకుమ్‍చ కమొ కెర్తస, ఆఁవ్ ఈంజ లోకుమ్‍చొ మాన్సు నెంజి. ");
INSERT INTO key_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","‘తుమ్‍చ పాపల్ తెన్ని మొర గెతె’ మెలయ్. కిచ్చొక మెలె ‘దేముడు తెద్రయ్‍లొ క్రీస్తు, రచ్చించుప కెర్తొసొ, ఈంజొయి’ మెన అంక తుమ్ నే నంపజలె, నిజుమి తుమ్‍చ పాపల్ తెన్ మొర గెతె, పాపుమ్‍తె గెతె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","జోక, జేఁవ్ వెల్లెల మాన్సుల్ యేసుక “తుయి కొన్సొ?” మెన పుసిల. యేసు జోవయింక, “ఆఁవ్ కొన్సొ జయిందె గే ఆఁవ్ తుమ్‍క అగ్గె తెంతొ సంగితసి గెద, జొయ్యి ఆఁవ్. ");
INSERT INTO key_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","తుమ్‍చి రిసొ, తుమ్ కెర్త కమొచి రిసొ ఆఁవ్ ఒగ్గర్ ఒగ్గర్ తీర్పు సంగుక జయెదె. గని అంక తెద్రయ్‍లొసొ సత్తిమ్‍చొ, చి లోకుమ్‍చక ఆఁవ్ సూనయ్‍తిసి కిచ్చొ మెలె, అంక తెద్రయ్‍లొసొతెయి ఆఁవ్ సూన్లిసి” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","గని, ‘తెద్రయ్‍లొసొ’ మెన దేముడు అబ్బొస్‍చి రిసొ సంగితయ్ మెన వెల్లెల మాన్సుల్ అర్దుమ్ కెరంతి నాయ్, చి రిసొ ");
INSERT INTO key_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","యేసు అన్నె, “ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొక తుమ్ టీఁవడ్తె. టీఁవడ్లె, అంక ‘జొయ్యి’ మెన పడ్తొక చినితె. తెదొడ్‍క అంక ‘జో అఁవ్వి కెర్లిసి కిచ్చొయ్ నాయ్, గని దేముడు అబ్బొసి సికడ్లి రితి కెర్తె తత్తయ్’ మెన అంచి రిసొ అర్దుమ్ కెరంతె. ");
INSERT INTO key_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","అంక తెద్రయ్‍లొసొ అంక తోడు అస్సె, అంచి తెన్ అస్సె. జో కెఁయ అంక ములె నాయ్. కిచ్చొక మెలె, ఆఁవ్ కెఁయఁక తెఁయఁక జోచి ఇస్టుమ్ రితి కెర్తసి” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","జో దస్సి సంగితె తతికయ్, ఒత్త తిలసతె ఒగ్గర్‍జిన్ జోవయింక నంపజా గెల. ");
INSERT INTO key_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","జోక నంపజంక దెర్ల వెల్లెల మాన్సుల్‍క యేసు తెదొడి, “ఆఁవ్ సంగిలి రితి ఇండితె తస్తె జలె, నిజుమి అంచ సిస్సుల్ జస్తె. ");
INSERT INTO key_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","చి సత్తిమ్ జాన్‍తె, చి జా సత్తిమ్ తుమ్‍క విడ్దల్ కెరెదె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","గని, విడ్దల్ జతిసిక మాములుమ్ ఈంజ లోకుమ్‍తె జితిస్‍చి అర్దుమ్ జేఁవ్ కెరన, జోక “ఆమ్ అబ్రాహామ్ పూర్గుమ్‍చొచి సేకుమ్‍తెచ మాన్సుల్‍చి రిసొ, కక్క కి కెఁయ కి గొతిమాన్సుల్ జము నాయ్. జాకయ్ ‘విడ్దల్ జస్తె’ మెన తుయి కిచ్చొక అమ్‍క సంగిలది?” మెన బమ్మ జా పుసిల. ");
INSERT INTO key_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","యేసు జోవయింక, “తుమ్‍క ఆఁవ్ నిజుమి కచితుమ్ కిచ్చొ సంగితసి మెలె, కో కిచ్చొ పాపుమ్ కెరుల గే, పాపుమ్‍క గొతిమాన్సుల్ జా అస్తి. ");
INSERT INTO key_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","గొతిమాన్సుల్, జలె, సావుకరిచొ గేరు కెఁయఁక తెఁయఁక తంక జోవయింక సెలవ్ నాయ్. గని, సావుకరిచొ సొంత పుత్తుసి జలె, కెఁయఁక తెఁయఁక అబ్బొస్‍చి గెరి తయెదె. ");
INSERT INTO key_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","తుమ్ కెర్త పాపల్‍క తుమ్ దెర్ను సేడ్లిసి తెంతొ దేముడుచొ పుత్తుసి తుమ్‍క విడ్దల్ కెర్లెగిన, నిజుమి విడ్దల్ జస్తె. ");
INSERT INTO key_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“అబ్రాహామ్ పూర్గుమ్‍చొచి సెకుమ్‍తె తుమ్ జెర్మ అస్సుస్ మెన జాని, గని జోచి సెకుమ్‍తె తుమ్ జెర్మిలెకి, అంచి కొడొ తుమ్‍చి పెట్టి తియనుక నెసుస్‍చి రిసొ, అంక మారుక కోర్‍ప జా అస్సుస్. ");
INSERT INTO key_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","అంచొ అబ్బొతె ఆఁవ్ దెకిలిస్‍క ఆఁవ్ సాచి సంగితసి. తూమ్ మాత్రుమ్, తుమ్‍చొయ్ అబ్బొది సంగిలిసి కెర్తసు” మెన వెల్లెల మాన్సుల్‍క యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","యేసు ఇసి సంగితికయ్, జేఁవ్ వెల్లెల మాన్సుల్ జోక, “అబ్రాహామ్ అమ్‍చొ అబ్బొ!” మెన సంగిలచి రిసొ యేసు జోవయింక అన్నె, “తుమ్ అబ్రాహామ్‍చ బోదల్ జతదు జలె, అబ్రాహామ్ కెర్ల కమొ తూమ్ కి కెర్తదు. ");
INSERT INTO key_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","దేముడుతె ఆఁవ్ సూన్లి సత్తిమ్ తుమ్‍క ఆఁవ్ సంగ అస్సి, గని అప్పె అంక మారుక తుమ్ కోర్‍ప జా అస్సుస్. అబ్రాహామ్ దస్సి కెరె నాయ్. ");
INSERT INTO key_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","గని తుమ్‍చొ సొంత అబ్బొది కెర్ల కమొ తుమ్ కెర్తసు” మెన సంగిలన్. జేఁవ్ జోక “ఆమ్ లంజెపెట్టి జెర్మిలస నెంజుమ్. అమ్‍క ఎక్కిలొ అబ్బొ జయెదె, మెలె, దేముడు” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","యేసు జోవయింక, “దేముడు తుమ్‍చొ అబ్బొది జతొ జలె, తుమ్ అంకయ్ ప్రేమ కెర్తదు. కిచ్చొక మెలె, ఆఁవ్ జోచి పెట్టి తా జోతె తెంతొ బార్ జా ఉట్ట అయ్‍లయ్. ఆఁవ్ అఁవ్వి జెంక నాయ్, జొయ్యి అంక తెద్రయ్‍లొ. ");
INSERT INTO key_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ఆఁవ్ సంగితిసి తుమ్ కిచ్చొక అర్దుమ్ కెరన్సు నాయ్? కిచ్చొక మెలె, అంచ కొడొతెచి సత్తిమ్ తుమ్‍క అల్లర్ కెర్తయ్, చి సూనుక ఓర్సుప జంక నెతుర్సు. ");
INSERT INTO key_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","తుమ్‍చొ అబ్బొది సయ్‍తాన్. తుమ్ జోచ మాన్సుల్ జా, జో కీసొచొ గే, తూమ్ కి దస్సచ. తుమ్‍చొ అబ్బొద్‍చ ఆసల్ తీర్సుప కెరుక తుమ్ కోర్‍ప జా అస్సుస్. మొదొల్ తెంతొ జో కూని కెర్తొసొ. సత్తిమ్, జోతె, ఎదిలి కి బెదితి నాయ్. జోతె కిచ్చొ సత్తిమ్ కి నాయ్. జో అబద్దుమ్ సంగుక, జోచి సొంత అబద్దుమ్ జొయ్యి లట్టబెదె. జో పూర్తి అబద్దుమ్‍చొ. జో అబ్బదల్‍క అబ్బొసి. ");
INSERT INTO key_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","జాకయ్, ఆఁవ్ సత్తిమ్ సంగితసిచి రిసొ, ఆఁవ్ సంగితిసి తుమ్ నంప కెర్సు నాయ్. ");
INSERT INTO key_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ఆఁవ్ కెఁయ్య కేన్ పాపుమ్ కెర్లయ్ గే, చి తుమ్‍తె కో అంక ‘అబద్దుమ్‍చొ’ మెన సాచి సంగుక జయెదె? కెఁయ కేన్ పాపుమ్ కెరి నాయ్, చి కో కి దస్సి సాచి సంగుక నెతుర్సు. జలె, ఆఁవ్ సత్తిమ్ సంగితసి జలె, తుమ్ అంక కిచ్చొక నంప కెర్సు నాయ్? తుమ్ ఉచర. ");
INSERT INTO key_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","దేముడుచ మాన్సుల్ కో జవుల గే, జో దేముడుచ కొడొ సూనుల. తూమ్ కిచ్చొక జోవయించ కొడొ సూన్‍సు నాయ్ మెలె. తుమ్ జోవయించ మాన్సుల్ నెంజుసు” మెన వెల్లెల మాన్సుల్‍క యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","యూదుల్‍చ జేఁవ్ వెల్లెల మాన్సుల్, జలె, జోక “సమరయ సుదొ జస్తె, చి తుక బూతుమ్ దెర అస్సె మెన అమ్ ఉచర్తిసి సత్తిమ్, కిచ్చొగె” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","జేఁవ్ దస్సి సంగితికయ్, యేసు జోవయింక కిచ్చొ జబాబ్ దిలన్ మెలె, “అంక బూతుమ్ దెరె నాయ్. ఆఁవ్, మాత్రుమ్, దేముడు అబ్బొక గవురుమ్ కెర్తసి, గని తూమ్ అంకయ్ గవురుమ్ కెర్సు నాయ్. ");
INSERT INTO key_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","అంచి రిసొ అంక గవురుమ్ నాయ్. గని అంక గవురుమ్ కెర్తొ ఎక్కిలొ అస్సె. జొయ్యి అంచి రిసొ తుమ్‍చి రిసొ తీర్పు కెర సత్తిమ్‍క రుజ్జు దెకయెదె. ");
INSERT INTO key_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","“జలె, తుమ్‍క ఆఁవ్ నిజుమి కచితుమ్ కిచ్చొ సంగితసి మెలె, అంచ కొడొ కో నిదానుమ్ కెరుల గే, కెఁయఁక కి మొర్తి నాయ్” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","దస్సి సంగితికయ్, జేఁవ్ వెల్లెల మాన్సుల్ జోక కిచ్చొ మెల మెలె, “అప్పె రుజ్జు అయ్‍లి. నిజుమి తుక బూతుమ్ దెర అస్సె. అబ్రాహామ్ మొర గెలన్. దేముడుచ కబుర్లు సంగిల పూర్గుమ్‍చ కి మొర గెల, గని ‘అంచ కొడొ కో నిదానుమ్ కెరుల గే, కెఁయఁక మొర్తి నాయ్’ మెన తుయి సంగితసి! ");
INSERT INTO key_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","అమ్‍చొ పూర్గుమ్‍చొ అబ్రాహామ్‌చి కంట తుయి వెల్లొ గే? జో మొర గెలొ. దేముడుచ కబుర్లు సంగిలస కి మొర గెల. తుయి కొన్సొ మెన సంగితసి? సంగు!” మెన యేసుక పుసిల. ");
INSERT INTO key_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","జలె, యేసు జోవయింక, “ఆఁవ్ సొంత గవురుమ్ సంగన్లెగిన, అంచి గవురుమ్ ఆరిచి. జలె, ‘అమ్‍చొ దేముడు’ మెన అంచొ అబ్బొచి రిసొ తుమ్ సంగితసు. జొయ్యి అంక గవురుమ్ కెర్తయ్. ");
INSERT INTO key_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","గని జోక తుమ్ అగ్గె తెంతొ నేన్సు. ఆఁవ్, మాత్రుమ్, జోక జాని. ‘జోక నేని’ మెన ఆఁవ్ ఏక్ వేల సంగితయ్ జలె, తుమ్‍చి రితి అబద్దుమ్‍చొ జతయ్. గని, నిజుమి జోక జాని, చి జోచి కోడు నిదానుమ్ కెర్తసి. ");
INSERT INTO key_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ఆఁవ్ ఈంజ లోకుమ్‍తె జెర్మ తతి దీసి దెకుక మెన తుమ్‍చొ పూర్గుమ్‍చొ అబ్రాహామ్, జలె, ఆస తెన్ తిలన్. జలె, అబ్బొసి జలొ దేముడుచి సెలవ్ తెన్ దెకిలన్, చి సర్దసంతోసుమ్ జలన్” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","యూదుల్‍చ జేఁవ్ వెల్లెల మాన్సుల్ జోక, “తుక యాబయ్ వెర్సుల్ జంక నేతయ్. దస్సి జలె, తుయి పూర్గుమ్‍చొ అబ్రాహామ్‍క కీసి దెక తస్తె! నెంజిలె జో తుక దెక తయెదె గే? బెదె నాయ్!” మెన సంగిల, ");
INSERT INTO key_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","చి యేసు, “తుమ్‍క ఆఁవ్ కిచ్చొ నిజుమి కచితుమ్ సంగితసి మెలె, అబ్రాహామ్ నే జెర్మితె అగ్గె తెంతొ ఆఁవ్వి తిలయ్, అస్సి” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","జో దస్సి సంగితికయ్, ‘దేముడు తెన్ సమ్మందుమ్ సంగితయ్, జా వెల్లి పాపుమ్’ మెన ఉచర, యేసుక పత్రల్ తెన్ పెట మారుక మెన, వెల్లెల మాన్సుల్ పత్రల్ వెంట్ల, గని యేసు నే దెకయ్ జతె, దేముడుచి గుడి తెంతొ బార్ జా, ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","పడ్తొ యేసు జోచ సిస్సుల్ తెన్ వట్టె గెతె తిలి పొది, జెర్మున్ తెన్ గుడ్డి మాన్సు ఎక్కిలొక దెకిల. ");
INSERT INTO key_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","జోక దెక కెర, యేసుచ సిస్సుల్ కిచ్చొ పుసిల మెలె, “గురుబాబు, ఈంజొ మాన్సు గుడ్డి జెర్మిలిసి జోచి పాపుమ్‍చి రిసొ గే, అయ్యస్‍అబ్బొస్‍చి పాపుమ్‍చి రిసొ గే?” మెన పుసిల. ");
INSERT INTO key_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","యేసు జోవయింక, “ఈంజొ పాపుమ్ కెర్లిసి నెంజె, అయ్యస్ అబ్బొస్ పాపుమ్ కెర్లిసి కి నెంజె. జలె, ఇన్నెక చెంగిల్ కెర్తిస్ తెన్ దేముడుచి గవురుమ్ జోచితె దెకయ్ జతి రిసొయి దస్సి జెర్మిలన్. ");
INSERT INTO key_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","మెద్దెన్ తిలి రితి మదెనె, అంక తెద్రయ్‍లొసొచ కమొ ఆమ్ కెర్తె తంకయ్. కిచ్చొక ‘మెద్దెన్’ మెలయ్ మెలె, అందర్ అయ్‍లె, కో కి కామ్ కెరుక నెంజె. ");
INSERT INTO key_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ఆఁవ్ ఈంజ లోకుమ్‍తె ఇసి బుల్తె తిలి మదెనె ఈంజ లోకుమ్‍చక దొర్కు జలి ఉజిడి ఆఁవ్వి జతసి” మెన యేసు బోదన కెర్లన్. ");
INSERT INTO key_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","యేసు దస్సి సంగితె తా కిచ్చొ గుర్తు కెర్లన్ మెలె, బుఁయ్యె తుంక్ర బుర్ద కెర, జా బుర్ద జో మాన్సుచ అంకివొతె గాఁస దా, ");
INSERT INTO key_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","జోక “తుయి గెచ్చ సిలోయమ్ మెంతి వెల్లొ కుండితె దోవను” మెన సంగిలన్. జా సిలోయమ్ మెంతి నావ్‌చి అర్దుమ్ కిచ్చొ మెలె, ‘తెద్రయ్‍లిసి’. జలె, యేసు సంగిలి రితి జో మాన్సు ఒత్త గెచ్చ, దోవన కెర, అంకివొ దెకయ్ జా, ఉట్ట అయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","జో దస్సి చెంగిల్ జా ఉట్ట జెతికయ్, జోచి గఁవ్విచ మాన్సుల్, జో అగ్గె బిచ్చిమ్ నఙితె తిలిసి దెక తిల అన్నె సగుమ్‍జిన్ కిచ్చొ మెన లట్టబన్ల మెలె, “ఈంజొయి అగ్గె బిచ్చిమ్ నఙ నఙ రోజుక వట్టె వెస తిలొసొ, కిచ్చొగె” మెన లట్టబంతె తిల. ");
INSERT INTO key_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","సగుమ్‍జిన్ “జొయ్యి” మెన సంగిల. అన్నె సగుమ్‍జిన్ “నెంజె, గని జోచి పోలికచొ మాన్సు” మెన సంగిల. గని జో “ఆఁవ్ జొయ్యి!” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","జేఁవ్ ప్రెజల్, జలె, జో మాన్సుక, “జలె, కీసి జా అప్పె దెకితసి?” మెన ఆచారిమ్ జా పుసిల. ");
INSERT INTO key_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","జో మాన్సు జోవయింక, “యేసు మెంతొ జో మాన్సు బుర్ద కెర అంచ అంకివొతె గాఁస దా, తుయి గెచ్చ సిలోయమ్ వెల్లొ కుండితె దోవను! మెన అంక సంగిలన్. ఆఁవ్ గెచ్చ దోవన్లయ్, చి అంకివొ డీసిల!” మెన సాచి సంగిలొ. ");
INSERT INTO key_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“జో అప్పె కేతె?” మెన జేఁవ్ జోక పుసిల, చి “ఆఁవ్ నేని” మెన జో సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","జో గుడ్డి జా జెర్మిలొసొక ప్రెజల్ పరిసయ్యుల్‍తె కడ నిల. ");
INSERT INTO key_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","జలె, యేసు బుర్ద కెర జోచ అంకివొతె గాఁస చెంగిల్ కెర్లి దీసి కేన్ దీసి మెలె, జోవయించి బక్తి కెర్తి సెలవ్ కడన్లి దీసి. ");
INSERT INTO key_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","జాకయ్, పరిసయ్యుల్ కి “తుక అంకివొ డీసయ్‍లిసి కీసి జర్గు జలి?” మెన పరిచ్చ కెర్ల. చి జో మాన్సు జోవయింక, “జో బుర్ద అంచ అంకివొతె గాఁసిలన్, చి ఆఁవ్ దోవన్లయ్, చి అప్పె దెకితసి” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","పరిసయ్యుల్‍తె సగుమ్‍జిన్ “జో మాన్సు దేముడుతె తెంతొ అయ్‍లొసొ నెంజె. కిచ్చొక మెలె, సెలవ్ కడన్లి దీసి పిట్టవన్‍తయ్” మెన యేసుచి రిసొ తీర్పు సంగిల. గని అన్నె సగుమ్‍జిన్ “పాపుమ్ కెర్తొ మాన్సు, జలె, దేముడుచి అదికారుమ్ దెకయ్‍త గుర్తుల్ కెరుక నెతిర్తొ” మెల, చి దొన్ని జటుల్ జల. ");
INSERT INTO key_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","జాకయ్, జో గుడ్డి మాన్సుక కిచ్చొ మెన అన్నె పరిచ్చ కెర్ల మెలె, “జో తుక అంకివొ డీసయ్‍లి రిసొ, తుయి జోచి రిసొ కిచ్చొ ఉచర్తసి?” మెన పుసిల. జో జోవయింక “దేముడుచ కబుర్లు సంగితొ ఎక్కిలొ జయెదె” మెన జబాబ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","జో ‘నిజుమ్ అగ్గె గుడ్డి తిలొ, చి చెంగిల్ జలొ’ మెన, యూదుల్‍చ జేఁవ్ వెల్లెల మాన్సుల్ మొదొల్‍క నంప కెర్తి నాయ్ చి రిసొ జోచ అయ్యస్అబ్బొస్‍క బుకార్ల. ");
INSERT INTO key_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","బుకారా కెర, జోవయింక “ఈంజొ తుమ్‍చొ పుత్తుది గే? జెర్మిల్ తెంతొ గుడ్డి తిలొ గే? దస్సి జలె, కీసి జా అప్పె దెకితయ్?” మెన పుసిల. ");
INSERT INTO key_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","అయ్యస్ అబ్బొసి కిచ్చొ జబాబ్ దిల మెలె, “‘ఈంజొ అమ్‍చొ పుత్తు’ మెన, ‘ఈంజొ గుడ్డి జా జెర్మిలన్’ మెన జానుమ్. ");
INSERT INTO key_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","గని అంకివొ అప్పె డీసిలిసి కీసి జర్గు జలి గే, కో జోచ అంకివొ చెంగిల్ కెర్లన్ గే, నేనుమ్. జోక తుమ్ పుస దెక. జో ఉబెడొబోద గెద? జొయ్యి సంగెదె” మెన జబాబ్ దిల. ");
INSERT INTO key_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","అయ్యసి అబ్బొసి కిచ్చొక దస్సి మెల మెలె, వెల్లొ మాన్సుక బితె తిల. కిచ్చొక మెలె, యేసుక ‘దేముడు తెద్రయ్‍లొ క్రీస్తు రచ్చించుప కెర్తొసొ’ మెన కో జలెకు ఒప్పన్లె, జోవయింక సబగేర్ తెంతొ ఉదడ గెలుక అస్సె, చి అన్నె కెఁయఁక కి పెసడుక జయె నాయ్ మెన వెల్లెల మాన్సుల్ అగ్గె తెంతొ ఉచర అస్తి. ");
INSERT INTO key_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","జాకయ్, “జో ఉబెడొబోద. జోకయ్ పుస!” మెన అయ్యస్ అబ్బొసి సంగ తిల. ");
INSERT INTO key_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","జాకయ్ తెదొడి, గుడ్డి జా జెర్మ తిలొ జో మాన్సుక జేఁవ్ వెల్లెల మాన్సుల్ అన్నెక్ సుట్టు బుకారా కెర జోక కిచ్చొ మెల మెలె, “జో యేసు పాపుమ్ కెర్లొసొ మెన ఆమ్ జానుమ్. జాకయ్, తుయి చెంగిల్ జలిస్‍చి రిసొ దేముడుక గవురుమ్ కెరు, గని జో యేసుక పోని” మెన ఆటంకుమ్ కెర్ల. ");
INSERT INTO key_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","గని జేఁవ్ దస్సి సంగిలే కి, జో జోవయింక, “జో పాపుమ్ కెర్లొసొ గే నెంజె గే ఆఁవ్ నేని, గని కిచ్చొ కచితుమ్ జాని మెలె, ఆఁవ్ అగ్గె గుడ్డి జా తిలె కి, అప్పె దెకితసి” మెన సాచి సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","దస్సి సంగితికయ్, జేఁవ్ జోక “తుక జో కెర్లిసి కిచ్చొ? తుచ అంకివొ కీసి చెంగిల్ కెర్లన్?” మెన అన్నెక్ సుట్టు పుసిల. ");
INSERT INTO key_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","చి జో అన్నె జోవయింక, “ఆఁవ్ తెదొడి సంగిలయ్, గని తుమ్ సూన్‍సు నాయ్. కిచ్చొక అన్నెక్ సుట్టు సూనుక కోర్‍ప జతసు? తూమ్ కి ఏక్ వేల జోచ సిస్సుల్ జంక కోర్‍ప జతసు గే?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","జో దస్సి పుసితికయ్, జేఁవ్ “తూయి జోచొ సిస్సుడు. తుచి ఇస్టుమ్! ఆమ్, మాత్రుమ్, మోసే పూర్గుమ్‍చొచ సిస్సుల్! ");
INSERT INTO key_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","మోసేచి అత్తి ఎత్కి అదికారుమ్ తిలొ దేముడు జోచ కబుర్లు సంగ అస్సె మెన జానుమ్. జో యేసు జలె, కేనె తెంతొ అయ్‍లొ గే, నేనుమ్” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","జాకయ్, చెంగిల్ జలొ జో మాన్సు జోవయింక అన్నె కిచ్చొ జబాబ్ దిలన్ మెలె, “అబ్బవోమ్మ! అంచ అంకివొ జో అన్నె డీసయ్‍లెకి, కేనె తెంతొ అయ్‍లొ గే తుమ్ నేన్సు గే? ");
INSERT INTO key_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","‘కో పాపుమ్ కెర్లొసొ జవుల గే, దేముడు జోక దెకె నాయ్ గని, కో జలెకు జోవయింక సత్తిమ్ కెరెదె గే, జోకయ్ జో ప్రబు దెకెదె’ మెన ఎత్కిజిన్ జానుమ్. ");
INSERT INTO key_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","లోకుమ్ జెర్మయ్‍లి తెంతొ, కేన్ జెర్మున్ గుడ్డి జా తిలొ మాన్సుక కో చెంగిల్ కెర్లిసి కో సూనుక నాయ్. ");
INSERT INTO key_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","దేముడు తెంతొ ఈంజొ మాన్సు జెతొ నాయ్ జలె, అంచి బాద గెచ్చవుక ఎద్గరె నెతిర్తొ” మెన వెల్లెల మాన్సుల్‍క బుద్ది సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","జో దస్సి సంగితికయ్, జేఁవ్ వెల్లెల మాన్సుల్ జోక కిచ్చొ జబాబ్ దిలన్ మెలె, “నిజుమి రితి పాపుమ్ తెన్ జెర్మిలొసొ, తుయి అమ్‍క సికడుక జయె నాయ్” మెన, జో కెఁయఁక కి అన్నె నే జెతి రితి సబగేర్ తెంతొ జోక ఉదడ గెల. ");
INSERT INTO key_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","జో మాన్సుక వెల్లెల మాన్సుల్ ఉదడ్లి సిచ్చ కెర్లిస్‍చి రిసొ యేసు సూన కెర, జోక చజ దెక, “మాన్సు జా జెర్మున్ అయ్‍లొసొక తుయి నంపజా అస్సిసి గే?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","జో మాన్సు యేసుక “బాబు, ఆఁవ్ జోక నంపజంక ఇస్టుమ్ జా అస్సి. జో కేతె?” మెన పుసిలన్, చి ");
INSERT INTO key_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","యేసు జోక, “తుయి జోక దెక అస్సిసి. తుచి తెన్ అప్పె లట్టబ్తొసొ జొయ్యి.” మెలన్. ");
INSERT INTO key_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","జో మాన్సు “ప్రబు, ఆఁవ్ నంపజతసి” మెన జొకర బక్తి కెర్లొ. ");
INSERT INTO key_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","తెదొడి యేసు ఒత్త తిల మాన్సుల్‍క, “ఆఁవ్ ఈంజ లోకుమ్‍తె అయ్‍లిసి లోకుమ్‍చక తీర్పు కెర్తి రితి జతయ్. కిచ్చొక మెలె, ఆఁవ్ జెతికయ్, గుడ్డి జల మాన్సుల్ దెకితతి, చి గుడ్డి నెంజిల మాన్సుల్ గుడ్డి రితి జతతి” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","జలె, జోచి పాసి తిల పరిసయ్యుల్ సగుమ్‍జిన్ ఈంజ కోడు సూన కెర “అమ్‍క కి ‘గుడ్డి మాన్సుల్’ మెన తుయి సంగితసి గే?” మెన యేసుక పుసిల. ");
INSERT INTO key_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","యేసు జోవయింక, “తుమ్ నిజుమి గుడ్డి జా తత్తదు జలె, తుమ్‍క కిచ్చొ పాపుమ్ తత్తి నాయ్. గని ‘అమ్ దెకితసుమ్’ మెన తుమ్ సంగితసుచి రిసొ తుమ్‍చి పాపుమ్ గెచ్చె నాయ్. ");
INSERT INTO key_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“తుమ్‍క కచితుమ్ నిజుమి ఆఁవ్ కిచ్చొ సంగితసి మెలె, మెండల్‍సాడు ఏక్ తిలె, ఎక్కిలొ జా కెర గుమ్ముమ్ వాట్ నే గెతె, కూడ్ డేఁవ పెసిలె, జో చోరు జయెదె. ");
INSERT INTO key_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","గని గుమ్ముమ్ వాట్ కో పెసెదె దే, జొయ్యి గొవుడు జయెదె. ");
INSERT INTO key_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","జా సాడుక గుమ్ముమ్ రకితొసొ ఎక్కిలొ తిలె, గొవుడుక వాట్ తయెదె. జో గొవుడుచి అవాడ్ జో రకిత మెండల్ కి చినుల, చి జో రకిత మెండల్‍క జో నవ్వొ తిఁయ తయెదె, చి జోవయింక జో రోజుక బార్ కెరెదె. ");
INSERT INTO key_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","జొయ్యి సొంత రకిత మెండల్‍క బార్ కెర్లె, జో కేనె ఉదడెదె గే, జేఁవ్ గెచ్చుల. కిచ్చొక మెలె, జేఁవ్ నంపజలొ గొవుడుచి అవాడ్ జేఁవ్ చినితతి. ");
INSERT INTO key_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","వేర మాన్సు అయ్‍లె, జోవయించి అవాడ్ నేన్‍తి, చి నంపజతి నాయ్, చి ఉట్ట నిగుల” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","జలె, యేసు జా సంగిలే కి, జేఁవ్ వెల్లెల మాన్సుల్ అర్దుమ్ కెరంతి నాయ్. ");
INSERT INTO key_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","జాకయ్ యేసు జేఁవ్‍క అన్నె, “ఆఁవ్ తుమ్‍క నిజుమి కచితుమ్ కిచ్చొ సంగితసి మెలె, ఆఁవ్ సంగిలి మెండల్‍సాడె పెసితి గుమ్ముమ్ ఆఁవ్వి. ");
INSERT INTO key_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","అంచి కంట అగ్గె అయ్‍ల గొవుడ్లు ఎత్కిజిన్ చోర్లు, చోర్లస జల. మెండల్ జోవయింక అవాడ్ సూన్‍తి నాయ్. ");
INSERT INTO key_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","దొర్కు జలి గుమ్ముమ్ ఆఁవ్వి. ఆఁవ్ తిలి గుమ్ముమ్ వాట్ కో పెసుల గే, రచ్చించుప జవుల, చి జా సాడు జోవయించి సొంత టాన్ జయెదె, చి పెసుక బార్ జంక జతె తవుల, చి చెంగిల్ అన్నిమ్ జోవయింక దొర్కు జతె తయెదె. ");
INSERT INTO key_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","చోరు, జలె, ఆరి మెండల్‍క చోరుక, కండ గెలుక, పాడ్ కెరుక జెయెదె. ఆఁవ్, మాత్రుమ్, కిచ్చొక అయ్‍లయ్ మెలె, అంచ మెండల్ జల మాన్సుల్‍క ‘జితు, ఎదిలి చెంగిల్ జీవ్ జోవయింక దొర్కు జవుస్’ మెనయ్ అయ్‍లయ్. ");
INSERT INTO key_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“ఆఁవ్వి చెంగిలొ గొవుడు జయిందె. గొవుడు చెంగిలొచొ జలె, మెండల్ కిచ్చొ ప్రమాదుమ్ జతి రితి జలె, జోవయింక ‘మొర్తు నాయ్. జితు’ మెన జొయ్యి అడ్డు జా, జోవయింక రచ్చించుప కెర్తి రిసొ జోచి జీవ్ దా మొరెదె. ఆఁవ్ కి దస్సి జయిందె. ");
INSERT INTO key_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ఎక్కిలొ జవుస్ నిజుమ్ తిలొ గొవుడు నెంజితె, ఆరి డబ్బుల్‍క జవుస్ మంద రకిలె, జేఁవ్ మెండల్ జోచ సొంత మెండల్ నెంజిలి రిసొ, మెండల్‍క మారితొ కిచ్చొ జవుస్ జంతు అయ్‍లె, కూలిక రకితొ జో మాన్సు ఉట్ట నిగ, మెండల్ నస్టుమ్ జతి రితి ముల దెయెదెచి. ఉట్ట నిగిలె, జో జంతు కేన్ మెండక దెర, తిల మెండల్‍క చెదుర్ప కెరెదె. ");
INSERT INTO key_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","జో వేర మాన్సు కిచ్చొక దస్సి ఉట్ట నిగ మెండల్‍క మాలఙ్ కెర ములెదె మెలె, ఆరి డబ్బుల్‍కయ్ రకితయ్‍చి రిసొ. జోచ సొంత మెండల్ నెంజితి, చి మొర్లె కి జిలె కి, జోక బాద నాయ్. ");
INSERT INTO key_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“ఆఁవ్ జలె, చెంగిలొ గొవుడు. ");
INSERT INTO key_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","అంచొ అబ్బొ అంక జానె, ప్రేమ కెర్తయ్. ఆఁవ్ కి అబ్బొక జాని ప్రేమ కెర్తసి. దస్సి, అంచ మెండల్‍క ఆఁవ్ జాని, ప్రేమ కెర్తసి. జేఁవ్ కి అంక జాన్‍తి, ప్రేమ కెర్తతి. అన్నె, జేఁవ్ అంచ మెండల్ జల మాన్సుల్‍క ‘మొర్తు నాయ్, గని జితు’ మెన ఆఁవ్ మొర గెచ్చిందె. ");
INSERT INTO key_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","“అన్నె, వేర దేసిమ్‍లుచ వేర ప్రెజల్‍చ మాన్సుల్ అంక నంపజా అంచ మెండల్ జవుల. జోవయింక కి అంచి మందయ్ బెదవనుక అస్సె. జేఁవ్ కి అమ్‍చి అవాడ్ సూన జెవుల. అయ్‍లె, జేఁవ్ కి ఈంజేఁవ్ కి ఎక్కి మంద జవుల, చి జేఁవ్ ఎత్కిక ఆఁవ్ ఎక్కిలొ గొవుడు జయిందె. ");
INSERT INTO key_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","జలె, అంచ మెండల్ జలసక రచ్చించుప కెర్తి రిసొ మొర గెచ్చిందె చి రిసొ అబ్బొ అంక ఒగ్గర్ ప్రేమ దెకితయ్, చి మొర గెలె కి, అన్నె జీవ్ జా ఉట్టిందె. ");
INSERT INTO key_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","మాన్సుల్ అంక మార గెలె కి, ఆఁవ్ నే ఒప్పిలె నెతిర్తి. గని, అంచి ఇస్టుమ్‍కయ్ మొరిందె. అంచి ఇస్టుమ్‍క మొరుక అదికారుమ్ అస్సె, అన్నె, అన్నె జీవ్ జా ఉట్టుక కి అంక అదికారుమ్ అస్సె. జా ఎత్కి ఆఁవ్ నెరవెర్సుప కెరుక మెన అంచొ అబ్బొ తియార్లి కామ్” మెన యేసు బోదన కెర్లన్. ");
INSERT INTO key_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","యేసుచ ఈంజేఁవ్ కొడొచి రిసొ యూదుల్‍చ ఒత్తచ వెల్లెల మాన్సుల్ అన్నె దొన్ని జట్లు జల. ");
INSERT INTO key_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","జోవయింతె ఒగ్గర్‍జిన్, “జోక బూతుమ్ దెర్లి రిసొ వెర్రి జా అస్సె. జోచ కొడొ అమ్ కిచ్చొక సూనుక?” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","అన్నె సగుమ్‍జిన్ “ఇస కొడొ బూతుమ్ దెర్ల కొడొ నెంజితి. అన్నె, గుడ్డి జల మాన్సుల్‍క చెంగిల్ కెరుక బూతల్ దెర్లసక సెక్తి తయెదె గే? నాయ్, గెద?” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ఇదిల్ పడ్తొ, అన్నెక్ పండుగు అయ్‍లి. ‘ఎక్కి దేముడుకయ్ తవుస్’ మెన పూర్గుమ్ పొది దేముడుచి గుడి సుద్ది కెర్లి ఏక్ కామ్‍చి గుర్తుచి పండుగు, జా. ");
INSERT INTO key_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","చల్లి పొది జా, జలె, దేముడుచి గుడితెచి రానొ జలొ సొలొమోను పూర్గుమ్‍చొచి నావ్ తిలి వెల్లి పేడితె యేసు బుల్తె తతికయ్, ");
INSERT INTO key_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","యూదుల్‍చ వెల్లెల మాన్సుల్ జోచి సుట్టునంత బెర జా, జోక అన్నె పరిచ్చ కెరుక దెర్ల. కిచ్చొ మెన పుసిల మెలె, “అన్నె కెత్తి దీసల్ అమ్ నేన తతి రితి కెర్తె? తుయి రచ్చించుప కెర్తొసొ జతొ క్రీస్తు జలె, అమ్‍క సొస్టుమ్ సంగు!” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","జలె, యేసు జోవయింక, “తుమ్‍క అగ్గె సంగిలయ్, గని తుమ్ నంప కెర్సు నాయ్. అబ్బొసి జలొ దేముడుచి నావ్ తెన్ ఆఁవ్ కెర్త కమొ కి అంచి రిసొ ‘జొయ్యి’ మెన సాచి సంగితతి. ");
INSERT INTO key_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","గని, అంచి మెండల్ మందతెచ తుమ్ నెంజుస్‍చి రిసొ తుమ్ నంపజంక నెతుర్సు. ");
INSERT INTO key_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","అంచ మెండల్ జలె, అంచి అవాడ్ సూన్‍తతి. ఆఁవ్ జోవయింక జాని, స్రెమ కెర్తసి, చి అంచి పట్టి జెతతి. ");
INSERT INTO key_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","దేముడుచి రాజిమ్‍తె బెదితి, మొర్లె పరలోకుమ్‍తె గెచ్చ కెఁయఁక తెఁయఁక జితి వరుమ్ జోవయింక ఆఁవ్ దెతసిచి రిసొ, జేఁవ్ కెఁయఁక కి సిచ్చ జతి మొర్నుతె గెతి నాయ్, అన్నె, కో కి జోవయింక అంచి అత్తి తెంతొ ఉర్లుక నెతిర్తి. ");
INSERT INTO key_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","అంచొ దేముడు అబ్బొ జోవయింక అంచి అత్తి సొర్ప కెర దిలన్. జొయ్యి ఎత్కిచి కంట వెల్లొచి రిసొ, జో అంచొ అబ్బొసి జలొ దేముడుచి అత్తి తెంతొ జోవయింక కో కి ఉర్లుక నెతిర్తి. ");
INSERT INTO key_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ఆఁవ్ అంచొ అబ్బొ ఎక్కి” మెన యేసు వెల్లెల మాన్సుల్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","యేసు ఇసి సంగితికయ్, ‘జోక పత్రల్ తెన్ పెట మార గెలుమ’ మెన, జా దీస్‍చి రితి వెల్లెల మాన్సుల్ పత్రల్ వెంట్ల. ");
INSERT INTO key_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","యేసు జోవయింక, “దేముడు అబ్బొ కెరయ్‍ల చెంగిల్ కమొ ఒగ్గరి తుమ్‍క దెకవ అస్సి. జేఁవ్ కమొతె కేన్ కామ్‍క ‘గర్చి’ మెన తుమ్ అంక పత్రల్ గల మారుక ఉచర్తసు?” మెన పుసిలన్, చి ");
INSERT INTO key_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","వెల్లెల మాన్సుల్ జోక, “కిచ్చొ చెంగిల్ కామ్ కెర్లి రిసొ పత్రల్ గల మారుమ్ నాయ్, గని తుయి రితొయి మాన్సు దేముడు తెన్ సమ్మందుమ్ సంగుక, జోచి విలువ కడ్లి రిసొయి, జా వెల్లి తప్పుకయ్” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","35","జాకయ్ యేసు జోవయింక ఇసి మెన జబాబ్ సంగిలన్, “తుమ్‍క ‘దేముడ్లు జస్తె’ మెన సంగిలయ్ మెన జోవయించ కబుర్లు సూన సికడ్ల మాన్సుల్‍చి రిసొ తుమ్‍చి మోసే పూర్గుమ్‍చొచి అత్తి దేముడు రెగ్డయ్‍ల ఆగ్నల్‍తె రెగ్డయ్‍లొ, గెద? జో దేముడు రెగ్డయ్‍లిసి కో మాన్సు పిట్టవుక నెతిర్తి, గెద. ");
INSERT INTO key_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","జలె, జో దేముడు అబ్బొ అంక జోవయించి కామ్‍కయ్ నిసాన అదికారుమ్ దా అంక ఈంజ లోకుమ్‍తె తెద్రయ్‍లొ. తెద్రయ్‍లొ జలె, ‘ఆఁవ్ దేముడుచొ పుత్తుసి’ మెన ఆఁవ్ సంగిలి రిసొ ‘జోచి విలువ కడ్తయ్’ మెన తుమ్ కీసి సంగుక జయెదె! ");
INSERT INTO key_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ఆఁవ్ దేముడు అబ్బొచ కమొ కెర్తసి నాయ్ జలె, అంక నంపజంక పోన. ");
INSERT INTO key_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","గని దేముడు అబ్బొచ కమొ ఆఁవ్ కెర్తసి జలె, అంకయ్ తుమ్ నే నంప కెర్లె కి, జేఁవ్ కమొ దెక జేఁవ్ కమొకయ్ నంపజా. జేఁవ్ కమొక నంపజలె, దేముడు అబ్బొ అంచి పెట్టి తిలిసి, ఆఁవ్ జో అబ్బొచి పెట్టి తిలిసి చినితె, చి తుమ్‍క అర్దుమ్ జెయెదె” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","యేసు దస్సి సంగితికయ్, జేఁవ్ వెల్లెల మాన్సుల్ జోక దెరుక దెకిల, గని జోవయించి అత్తి దెర్ను నే సేడ్తె బార్ జా ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","యేసు ఉట్ట గెచ్చ, యోర్దాను గాడు ఒత్తల్‍తొ గెచ్చ, అగ్గె యోహాను బాప్తిసుమ్ దెతె తిలిస్‍తె టాన్‍తె సగుమ్ దీసల్ ఒత్త తిలన్. ");
INSERT INTO key_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ఒత్త తతికయ్, మాన్సుల్ ఒగ్గర్‍జిన్ జోతె జా కెర, కిచ్చొ మెన సంగితె తిల మెలె, “దేముడుచి అదికారుమ్‍క గుర్తు దెకయ్‍త కమొ కేన్ కి యోహాను కెరె నాయ్, గని ఈంజొ యేసుచి రిసొ జో సంగిలిసి ఎత్కి సత్తిమ్!” ");
INSERT INTO key_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ఒత్త తిలస బలేగ జీన యేసుక ఒత్త తెన్ నంపజల. ");
INSERT INTO key_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","లాజర్ మెలొ ఎక్కిలొ జొర్జొ సేడ్లన్. జో కేన్ గఁవ్విచొ మెలె, మరియ మార్త మెల దొగుల బేన్సివొ చి బేతనియ గఁవ్విచొ. ");
INSERT INTO key_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","పడ్తొ తేర్‍బోద ఎక్లి యేసుక తేల్ గాఁస, జాచి సెండి తెన్ జోచ చట్టొ పుంచెదె. జయ్యి ఈంజ మరియ జయెదె. జొర్జొ సేడ్లొసొ జేఁవ్‍చొ అన్నొసి జయెదె. ");
INSERT INTO key_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","జలె, లాజర్‍చ బేన్సివొ “ప్రబువ, తుయి ప్రేమ కెర్తొసొ జబ్బు సేడ అస్సె” మెన యేసుతె కబుర్ తెద్రయ్‍ల. ");
INSERT INTO key_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","గని యేసు ఈంజ కబుర్ సూన, “ఈంజ జబ్బు సేడ్లిసి జో మొర్తి రిసొయి నాయ్, గని దేముడుచి నావ్ గవురుమ్ జతి రిసొయి, ఆఁవ్ జోచొ పుత్తుస్‍చి అదికారుమ్ దెకయ్‍తి రిసొయి” మెన, సిస్సుల్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","మార్తక, జాచి బేన్సిక, లాజర్‍క, యేసు బలే ప్రేమ తిలొ, ");
INSERT INTO key_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","గని లాజర్ ‘జబ్బు తెన్ అస్సె’ మెన సూన్లె కి, జో తిలి టాన్‍తె యేసు అన్నె దొరతి తాఁ గెలొ. ");
INSERT INTO key_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","జా దొరతి గెతికయ్, జోచ సిస్సుల్‍క, “యూదయ ప్రదేసిమి అన్నె గెచ్చుమ!” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","జేఁవ్ సిస్సుల్ జోవయింక “గురుబాబు, ఈంజ మదెనె యూదుల్‍చ వెల్లెల మాన్సుల్ తుక పత్రల్ గల మారుక ఉచర్తె తిలె కి, తుయి అన్నె ‘ఒత్త గెచ్చిందె’ మెన ఉచర్తసి గే?” మెన బియఁ గెచ్చ జోక సంగిల. ");
INSERT INTO key_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","యేసు జోవయింక, “ఒండి మెద్దెనె పాసి పాసి బార గంటల్‍చి ఉజిడి తయెదె, గెద? దస్సి జలె, జా బార గంటల్‍చి ఉజిడి తిలె పొది మాన్సు ఇండిలె, ఈంజ లోకుమ్‍చి ఉజిడ్‍చి రిసొ జోక వాట్ డీస్తయ్, చి సేడె నాయ్. ");
INSERT INTO key_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","గని, జేఁవ్ అందరె ఇండిలె, ఉజిడి నెంజిలి రిసొ జేఁవ్ సేడుల” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","యేసు జోవయింక దస్సి సంగ అన్నె, “ఆఁవ్ ప్రేమ కెర్లొ లాజర్ నిజ అస్సె, గని జోవయింక ఉట్టవుక గెతసి” మెలన్, చి ");
INSERT INTO key_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","సిస్సుల్ “దస్సి జలె, ప్రబు, జో నిజ తిలెగిన, చెంగిల్ జయెదె. కిచ్చొ బాద నాయ్” మెలె. ");
INSERT INTO key_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","జలె, ‘నిజ అస్సె’ మెన జో మొర్లిస్‍చి రిసొ యేసు సంగ తిలన్. గని, ‘మాములుమ్ నిజ తతిస్‍చి రిసొ సంగితయ్’ మెన సిస్సుల్ ఉచర్తతి. ");
INSERT INTO key_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","తెదొడి “లాజర్ మొర గెచ్చ అస్సె” మెన యేసు జోవయింక సొస్టుమ్ సంగ, ");
INSERT INTO key_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","అన్నె, “జో మొర గెలి పొది ఆఁవ్ ఒత్త నెంజిలిసి చెంగిలి. కిచ్చొక మెలె, తుమ్‍చి రిసొయి. మెలె, అంచి రిసొ తుమ్ దయిరిమ్ తెన్ నంపజతి రిసొ ఈంజ ఎత్కి జర్గు జతయ్. అల్లె, జోతె గెచ్చుమ!” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","‘కల్వల్ జెర్మిలొసొ’ మెలి ఆసిమ్ నావ్ తిలొ తోమా మెలొ సిస్సుడు, జలె, తిల సిస్సుల్‍క, “జొమ్మ, ఆమ్ ఇన్నెతెన్ మొర గెచ్చుక గెచ్చుమ!” మెన సంగిలన్, చి జేఁవ్ బార్ జల. ");
INSERT INTO key_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","జేఁవ్ బేతనియ గఁవ్వి పాసి అయ్‍లె, యేసు కిచ్చొ కబుర్ సూన్లొ మెలె, ‘లాజర్‍క మెస్నె రోవ చెత్తర్ పొదుల్ జా అస్సె’ మెన సూన్లన్. ");
INSERT INTO key_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","జలె, జా గాఁవ్ యెరూసలేమ్ పట్నుమ్ తెంతొ పాసి పాసి ఎక్కి దొన్ని మయిలు దూరి అస్సె. ఒగ్గర్ దూరి నాయ్, ");
INSERT INTO key_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","చి జేఁవ్‍చి అన్నొసి మొర్లి రిసొ మార్తక చి మరియక బురియవుక మెన, యెరూసలేమ్‍చ యూదుల్ ఒగ్గర్‍జిన్ జా అస్తి. ");
INSERT INTO key_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","జలె, యేసు జెతయ్ మెన మార్త సూన కెర, జోక దస్సుల్ జంక మెన వాట్ ఎదక అయ్‍లి, గని మరియ గెరి తా గెలి. ");
INSERT INTO key_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","మార్త జోక దస్సుల్ జా జొకర, యేసుక, “ప్రబు, తుయి ఇన్నె తత్తది జలె, అంచొ అన్నొ మొర్తొ నాయ్. ");
INSERT INTO key_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","గని అప్పె కి తుయి దేముడుతె కిచ్చొ సంగిలే కి తుక దెయెదె మెన జాని” మెన సంగిలి. ");
INSERT INTO key_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","యేసు జాక, “తుచొ అన్నొది అన్నె జీవ్ జా ఉట్టెదె” మెలన్. ");
INSERT INTO key_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","మార్త జలె, జోక “ఈంజ లోకుమ్ ఇసి తతిస్‍చి ఆకర్ దీసిక, ఈంజ లోకుమ్‍చ మాన్సుల్ ఎత్కిజిన్ అన్నె జీవ్ జా ఉట్టితి దీసిక, అన్నొ అన్నె ఉట్టెదె మెన జాని” మెన సంగిలి. ");
INSERT INTO key_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","చి యేసు జాక, “మొర గెలసక ఉట్టయ్‍లొసొ, దొర్కు జలి జీవ్ దెతొసొ ఆఁవ్వి. అంక కో నంపజా గెచ్చుల గే జోవయించి ఆఁగ్ మొర గెలె కి, జివుల. ");
INSERT INTO key_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","చి, కో అంక నంప తెన్ జితతి గే, సిచ్చ జతి మొర్నుతె కెఁయఁక కి గెతి నాయ్. అమ్మ, ఈంజ కోడు తుయి నంపజతసి గే?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","మార్త యేసుక “నంపజా అస్సి ప్రబు. ఈంజ లోకుమ్‍తె జెంక తిలొ రచ్చించుప కెర్తొసొ జతొ క్రీస్తు తుయి మెన, దేముడుచొ పుత్తుసి తుయి మెన నంప తెన్ అస్సి” మెన ఒప్పన సంగిలి. ");
INSERT INTO key_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","జలె, మార్త ఇసి సంగిలి బేగి, యేసుక ఒత్త ముల దా గెరి గెచ్చ, “గురుబాబు జా అస్సె. తుక బుకార్తయ్” మెన బేన్సి జలి మరియక తిరీమ్ సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","మరియ ఈంజ కోడు సూన, చట్కున ఉట్ట, యేసుతె గెచ్చుక బార్ జలి. ");
INSERT INTO key_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ఈంజ మదెనె, యేసు కేనె అస్సె మెలె, మార్త జోక దస్సుల్ జా ముల దిలి టాన్‍తె రక అస్సె. గఁవ్వి జెంక నేతయ్. ");
INSERT INTO key_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","మరియ చట్కున బార్ జతికయ్, జాతె జా తా జాక బురియయ్‍తె తిల యూదుల్ దెక, “మెస్నె ఏడుక గెతయ్, కిచ్చొగె” మెన ఉచర, జాచి పట్టి గెల. ");
INSERT INTO key_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","జలె, యేసు తిలిస్‍తె మరియ పాఁవ కెర, జోక దెక జోచి చట్టె సెర్ను సేడ, “ప్రబు, తుయి ఇన్నె తత్తది జలె, అంచొ అన్నొ మొర గెతొ నాయ్” మెన సంగిలి. ");
INSERT INTO key_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","జా ఏడ్తిసి, జేఁవ్ తెన్ అయ్‍ల యూదుల్ ఏడ్తిసి దెక, యేసు కన్కారుమ్ జా జోచి ఆత్మతె బాద సేడ, ");
INSERT INTO key_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“జోక కేనె రోవిలదు?” మెన పుసిలన్, చి జేఁవ్ జోక “జా దెకు, ప్రబు!” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","యేసు ఆఁసుమ్ గేడవ ఏడ్లన్. ");
INSERT INTO key_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","జో ఏడ్లిసి దెక, ఒత్త తిల యూదుల్ సగుమ్‍జిన్ “ఆదె, జోవయింక కెద్ది ప్రేమ తిలొ, ఈంజొ!” మెన దెకయ్‍ల. ");
INSERT INTO key_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","జోవయింతె అన్నె సగుమ్‍జిన్, మాత్రుమ్, “జో గుడ్డి మాన్సుచ అంకివొ డీసయ్‍లొ, గెద. జలె, లాజర్ నే మొర్తి రితి కెర్తొ జలె”, మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","తెదొడి యేసు జోచి ఆత్మతె అన్నె ఒగ్గర్ ఒగ్గర్ కన్కారుమ్ జా, మెస్నె పాఁవిలన్. ఈంజ మెస్సున్ కీసిచి మెలె, మెట్టయ్ తిలి సాప్రయ్ డొల్మి కెర్లి గది. జా డొల్మి కెర్లిస్‍క డంక తిలిసి వెల్లొ పత్తురు. ");
INSERT INTO key_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","యేసు, “పత్తురు కడ గెల!” మెలన్. దస్సి మెంతికయ్, మొర గెలొసొచి మార్త మెలి బేన్సి జోక “ప్రబు, జో మొర గెచ్చ చెత్తర్ పొదుల్ జలి! పీనుమ్ వాసెన పెట్తె తయెదె!” మెన సంగిలి. ");
INSERT INTO key_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","యేసు జాక “ఆఁవ్ తుక కిచ్చొ సంగిలయ్ గే, తుయి నంప తెన్ తిలెగిన, దేముడుచి గవురుమ్ సెక్తిచి రుజ్జు దెకితె.” మెన ఇదిల్ గోల కెర్లన్. ");
INSERT INTO key_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","జలె, పత్తురు కడ గెల, చి యేసు ఆగాసుమ్ పక్క దెక “ఓ బ, తుయి అంచి ఆస సూన్లది మెన అంక సర్ద. ");
INSERT INTO key_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","తుచి తెన్ ఆఁవ్ లట్టబ్తిసి తుయి కెఁయఁక తెఁయఁక సూన్‍తసి మెన ఆఁవ్ పూర్తి జాని, గని తుయి అంక తెద్రయ్‍లిస్‍చి రుజ్జు దెక నంపజతు మెన, ఇన్నె టీఁవ తిల ప్రెజల్‍చి రిసొ ఇసి చోండి పుట్టవ సంగితసి” మెన సంగ, గట్టిఙ ఒర్స, ");
INSERT INTO key_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","“లాజర్, బార్ జా!” మెన బుకార్లన్. ");
INSERT INTO key_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","చి జో మొర గెలొసొ, జోచ అత్తొ చట్టొ బందున్ తెన్ తతె, జోచి మొక్మె తువ్వల్ గుడియవ తతె, బార్ జా అయ్‍లొ, చి తిల మాన్సుల్‍క యేసు “కట్లు యిప, జోక విడ్దల్ కెర!” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","మరియ తెన్ జా తిల యూదుల్‍తె ఒగ్గర్‍జిన్ జలె, యేసు కెర్లిసి దెక, జోక నంపజల. ");
INSERT INTO key_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","గని జోవయింతె అన్నె సగుమ్‍జిన్, పరిసయ్యుల్‍తె గెచ్చ, యేసు కెర్లిసి జోవయింక సంగిల. ");
INSERT INTO key_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","వెల్లెల పూజర్లు పరిసయ్యుల్ సబ కెర్తసక వెసవ దా, “అమ్ కిచ్చొ కెర్లె జయెదె? ఈంజొ మాన్సు ఒగ్గర్ ఒగ్గర్ వెల్లెల కమొ కెర్తయ్, చి ");
INSERT INTO key_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","అమ్ జోక నే ములయ్‍లె, ప్రెజల్ ఎత్కిజిన్ జోక నంపజా గెచ్చుల. చి రోమ్ దేసిమ్‍చ సయ్‍న్యుమ్ జా కెర, అమ్‍చి దేముడుచి గుడి కి అమ్‍చి ఒండి దేసిమ్ కి పాడ్ కెరుల” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","జలె, జేఁవ్ వెల్లెల మాన్సుల్‍తె కయప మెలొ ఎక్కిలొ తిలొ. జా వెర్సి జొయ్యి ఎత్కిక వెల్లొ పూజరి జా తిలొ. సబతె తిలసక జో కిచ్చొ మెన సంగిలన్ మెలె, “తుమ్ కిచ్చొయ్ నేన్సు. ");
INSERT INTO key_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ఏక్ కోడు తుమ్ ఉచర. అమ్‍చ యూదుల్ అమ్‍చి దేసిమ్ పాడ్ నే జతి రితి ఎక్కిలొ మొర్లె తుమ్‍క చెంగిలి” మెన సంగిలొ. ");
INSERT INTO key_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","జలె, జోక జొయ్యి ఈంజ కోడు సంగె నాయ్. గని జా వెర్సి జో ఎత్కిక వెల్లొ పూజరి జా తిలి రిసొ, దేముడు జోచి చోండి పుట్టవ సంగయ్‍లొ. జా కబుర్‌చి అర్దుమ్ కిచ్చొ మెలె, యూదుల్‍తెచ మాన్సుల్‍క పాపుమ్ తెంతొ రచ్చించుప కెర్తి రిసొ యేసు మొరుక తిలి. ");
INSERT INTO key_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ఎక్కి యూదుల్‍తెచ మాన్సుల్‍క నాయ్. గని జోవయింక బోదల్ జల జోక నంపజల మాన్సుల్ ఎత్కిక, జేఁవ్ కేన్ దేసిమ్‍చ జలెకి, జేఁవ్‍క ఎక్కితె జోవయించి బెదవంతి రిసొయి మొరుక తిలి. ");
INSERT INTO key_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","జలె జా దీసి తెంతొ, ‘యేసుక కీసి మారుమ’ మెన, వెల్లెల మాన్సుల్ కుట్ర ఉచర్తె తిల. ");
INSERT INTO key_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","జలె, జో మొర్తి సమయుమ్ జెంక నేతయ్‍చి రిసొ యేసు, యూదుల్‍చ వెల్లెల మాన్సుల్ తిలిస్‍తె నే బుల్తె, ఒత్త తెంతొ వెల్లి బయిలు పక్క, ఎప్రాయిమ్ మెంతి గఁవ్వి ఉట్ట గెచ్చ, జా మదెనె జోవయించ సిస్సుల్ తెన్ ఒత్త తా గెల. ");
INSERT INTO key_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","యూదుల్‍చి జా వెర్సిచి పస్కా పండుగు పాసి జా అయ్‍లి. జా పండుగు నే జెతె అగ్గె, సుద్ది కెరనుక మెన, యూదుల్ ఎత్కిజిన్ జోవయించ జోవయించ గఁవ్విలె తెంతొ యెరూసలేమ్‍తె జా అస్తి. ");
INSERT INTO key_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","దేముడుచి గుడితె గెలస యేసుక రకితె అస్తి. ఒత్త రకితె తా కిచ్చొ మెన లట్టబంతె అస్తి మెలె, “తుమ్ కిచ్చొ ఉచర్తసు? ఏక్ వేల పండుగ్‍క జెయె నాయ్ గే?” మెన లట్టబంతె అస్తి. ");
INSERT INTO key_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","కిచ్చొక మెలె, జా మదెనె వెల్లెల పూజర్లు చి పరిసయ్యుల్ జోక జేలి కెరుక మెన ఉచర “జో కేనె తయెదె గే కో జాన్లె, అమ్‍క సంగ!” మెన ప్రెజల్‍క ఆడ్ర దా అస్తి. ");
INSERT INTO key_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","పస్కా పండుగ్‍క సొవ్వు పొదుల్ అగ్గె, యేసు బేతనియ గఁవ్వి అన్నె ఉట్ట అయ్‍లన్. జా గఁవ్వి యేసు జియడ్లొ లాజర్ అస్సె. ");
INSERT INTO key_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","జలె, యేసు ఒత్త తతికయ్, జోచి రిసొ విందు దిల. మార్త జొగిడ్లి, చి యేసు తెన్ అన్నిమ్ కయ్‍లసతె లాజర్ తిలన్. ");
INSERT INTO key_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","జేఁవ్ ఎత్కిజిన్ వెస తిలిస్‍తె, జలె, మరియ ఒగ్గర్ విలువ తిలి ఏక్ ఎదిలి చెంగిల్ వాసెన తేల్ ఆన్‍లి. ఆన, యేసుచ చట్టొతె గాఁస, జాచి సెండి తెన్ పుంచిలి, చి ఒండి గెరి జా తేల్‍చి వాసెన బెర్లి. ");
INSERT INTO key_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","జలె, ఇస్కరియోతు యూదా మెలొ యేసుచ సిస్సుల్‍తె తా, జో కి ఒత్త అస్సె. కొన్సొ మెలె, జో పడ్తొ విరోదుమ్ సుదల్‍తె యేసుక దెర దెయెదె. జలె, యేసుక మరియ జా తేల్ గాఁస్తికయ్, జో యూదా జాక, ");
INSERT INTO key_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“ఈంజ తేల్ సొవ్వు పుంజొ వెండ్లుక విక గెల్తది జలె, బీద సుదల్‍క జా డబ్బుల్ దర్ముమ్ దెంక జతి!” మెన గోల కెర్లన్. ");
INSERT INTO key_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","గని ఆరిక సంగిలొ, బీద సుదల్‍చి ఉప్పిర్‍చి కన్కారుమ్‍క నాయ్. కిచ్చొక మెలె, జో చోరు. సిస్సుల్‍చి డబ్బుల్ పెట్టె జోచి అత్తి తిలి, చి జా డబ్బుల్ జో చోర కంక అలవాట్ జా తిలొ. ");
INSERT INTO key_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","జలె, యూదా జా కోడు సంగితికయ్, యేసు జోక, “జాక గోల కెరు నాయ్. అంక రోవితి దీసికచి కామ్‍క ఈంజ గుర్తు తతి రితి జా, జా తేల్ తిఁయ దా తిలి. తవుసు. ");
INSERT INTO key_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","బీద సుదల్ కెఁయఁక తెఁయఁక తుమ్‍చి తెన్ తవుల చి రిసొ ఇస్టుమ్ అయ్‍లి పొది జోవయింక దర్ముమ్ దెంక జయెదె. ఆఁవ్, మాత్రుమ్, కెఁయఁక తెఁయఁక తుమ్‍చి తెన్ ఇసి తయె నాయ్” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","యెరూసలేమ్‍తె పండుగ్‍క బెర తిల యూదుల్, జలె, యేసుచి రిసొ, జో ‘బేతనితె లాజర్‍తె అస్సె’ మెన సూన కెర, యేసుక దెకుక మెన, చి జో జియడ్లొ లాజర్‍క దెకుక మెన ఒత్త ఉట్ట అయ్‍ల. ");
INSERT INTO key_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","జాకయ్, ‘లాజర్‍క జియడ్లిసిచి రుజ్జు దెక ఒగ్గర్‍జిన్ అమ్‍చి ఆచారిమ్ ముల దా యేసుక నంపజతతి’ మెన వెల్లెల పూజర్లు బియఁ కెర, లాజర్‍క కి మారుక ఉచర్ల. ");
INSERT INTO key_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","‘యేసు యెరూసలేమ్‍తె జెతయ్’ మెన పండుగ్‍క బెర తిల మాన్సుల్ అన్నెక్ దీసి సూన కెర, ");
INSERT INTO key_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","‘జో తెన్ దస్సుల్ జమ్‍దె’ మెన, పట్నుమ్ తెంతొ బార్ జా కజురుమ్ రూకుల్‍చ మట్టల్ మోడ దెరన వట్టె జా తా, యేసు పాసి అయ్‍లి పొది “అమ్‍చొ ప్రబుచి నావ్ తెన్ జెతొ రచ్చించుప కెర్తొసొక జొఒర, జొఒర! అమ్‍చి ఇస్రాయేల్‍చ ప్రెజల్‍చొ రానొక ఓసన్న, ఓసన్న!” మెన జోచి రిసొ కేకుల్ గల్తె తిల. ");
INSERT INTO key_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","15","జలె, ‘జర్గు జయెదె’ మెన దేముడుచి కొడొతె పూర్గుమ్ దేముడు రెగ్డయ్‍లి తిలిసి జర్గు జలి. కీసి మెలె, యేసు ఏక్ గాడ్దె పిల్ల దొర్కు కెరన, వెగ, పట్నుమ్‍తె అయ్‍లొ. “ఓ సీమోనుచి దువిసి, తుయి అన్నె బి నాయ్! గాడ్దె పిల్లతె వెగ, తుమ్‍చొ రానొ జెతయ్!” మెన రెగిడ్లి కోడు. ");
INSERT INTO key_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ఈంజ ఎత్కి జర్గు జతె తిలి పొది యేసుచ సిస్సుల్ కి అర్దుమ్ కెరంతి నాయ్. గని యేసు దేముడు అబ్బొస్‍తె అన్నె వెగ గెలి పడ్తొ, యేసుక ఇసి జలి, చి జోచి రిసొ దేముడు అబ్బొసి జా కోడు రెగ్డవ తిలన్ మెన ఉచార కెర్ల. ");
INSERT INTO key_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","జలె, యేసు జో లాజర్‍క మెస్సున్ తెంతొ బుకారా జియడ తిలిస్‍తె బెర తిల మాన్సుల్ జేఁవ్ జా ఇసి సొంత దెకిలిస్‍క అప్పె సాచి సంగితె తిల. ");
INSERT INTO key_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","యెరూసలేమ్‍తెచ ప్రెజల్ కిచ్చొక యేసు తెన్ దస్సుల్ జంక బార్ జా తిల మెలె, లాజర్‍క యేసు జియడ జోచి అదికారుమ్‍క రుజ్జు దెకయ్‍లిస్‍చి రిసొ సూన తిల. ");
INSERT INTO key_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ప్రెజల్ యేసుక నంపజతతి మెన పరిసయ్యుల్ దెక, “అయ్యొ, జోవయింక పిట్టయ్‍తిసి అమ్ అన్నె కిచ్చొ కెరుక కామ్‍క నెంజె. ఆదె, లోకుమ్ ఎత్కిచ మాన్సుల్ జోచి పట్టి గెచ్చ అస్తి” మెన ఎక్కిలొ తెన్ ఎక్కిలొ లట్టబన్ల. ");
INSERT INTO key_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","పండుగు పొది బక్తి కెరుక అయ్‍లసతె సగుమ్‍జిన్ గ్రీసు దేసిమ్‍చ మాన్సుల్ ఒత్త అయ్‍ల. ");
INSERT INTO key_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","జేఁవ్ జలె, గలిలయతె తిలి బేత్సయిదా గఁవ్విచొ పిలిప్ మెంతొ యేసుచొ సిస్సుడు ఎక్కిలొక చజ కెర జోక “బాబు, యేసు తెన్ లట్టబుక మెన అయ్‍లమ్” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","చి పిలిప్ అంద్రెయ మెలొ సిస్సుడుక సంగ, జేఁవ్ దొగుల యేసుతె జా, జోక సంగిల. ");
INSERT INTO key_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","యేసుక జేఁవ్ దొగుల సిస్సుల్ జా కబుర్ సంగితికయ్, జో జోవయింక, “ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొ గవురుమ్ జతి సమయుమ్ జా అస్సె. ");
INSERT INTO key_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","తుమ్‍క ఆఁవ్ కిచ్చొ నిజుమి కచితుమ్ సంగితసి మెలె, గోదుమ్ గిడ్డ జవుస్ పంటొ దెరుక జలె, బుఁయ్యె సేడ చొప్పొ కుసుడ గెలెకయ్ జయెదె. దస్సి తొలితొ మొర్లి రితి నే జలెగిన, ఎక్కి గిడ్డయ్ తాఁ గెచ్చెదె. గని దస్సి మొర్లి రితి జలె, ఒగ్గర్ పంటొ దెరెదె. ");
INSERT INTO key_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","“జోచి జీవుక జో కో ప్రేమ కెర రచ్చించుప కెరనుక ఉచరుల గే, జోచి ప్రానుమ్ పాడ్ జా గెచ్చెదె, గని ఈంజ లోకుమ్‍తె కో జోచి సొంత జీవుక విలువ నే దెకితె దేముడుక నిదానుమ్ కెరుల గే, జోచి జీవు జోక దొర్కు జా, పరలోకుమ్‍తె గెచ్చ కెఁయఁక తెఁయఁక ఒత్త జివుల. ");
INSERT INTO key_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","అంచి సేవ కో కెరుల గే, అంచి పట్టి అయ్‍లి రితి ఆఁవ్ కెర్తి రితి కెరుక, చి ఆఁవ్ కేనె తయిందె గే, అంచొ సేవ కెర్తొసొ ఒత్తయ్ తంక. కో అంచి సేవ కెరుల గే, జోక కచితుమ్ దేముడు అబ్బొ గవురుమ్ కెరెదె. ");
INSERT INTO key_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“ఓ బ, అప్పె అంచి పెట్టి ఒగ్గర్ బాద జతసి. ఆఁవ్ తుక కిచ్చొ సంగుక? ‘ఓ బ, ఈంజ సమయుమ్‍చి కామ్ అంక పిట్టవు’ మెన సంగుక గే? నాయ్, నెంజె. ఈంజ కామ్‍చి రిసొయి, సమయుమ్‍చి రిసొయి ఈంజ లోకుమ్‍తె ఆఁవ్ అయ్‍లయ్, గెద? ");
INSERT INTO key_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ఓ బ, తుచి నావ్‌క గవురుమ్ కెరను” మెన దేముడు అబ్బొస్‍క ప్రార్దన కెర్లన్, చి బేగి, ఆగాసుమ్ తెంతొ జో దేముడు జోచి అవాడ్ సూనయ్‍లన్. కిచ్చొ మెన సూనయ్‍లన్ మెలె, “అంచి నావ్‌క గవురుమ్ కెర అస్సి, చి అన్నె గవురుమ్ కెరనిందె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","పాసి టీఁవ తిల జనాబ్ సూన్ల, చి “ఉర్ముల్ కెర్లి” మెన జోవయింతె సగుమ్‍జిన్ సంగిల. అన్నె సగుమ్‍జిన్, మాత్రుమ్, “దేముడుచి దూత ఎక్కిలొ జో తెన్ లట్టబ్లన్” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","యేసు జోవయింక, “ఈంజ అవాడ్ సూనయ్‍లిసి అంక దయిరిమ్ కెర్తి రిసొ నాయ్, అంక దయిరిమ్ అస్సె. గని తుమ్‍కయ్ ‘నంపజతు’ మెన సూనయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","కిచ్చొక మెలె, అప్పె జర్గు జంక తిలిస్‍చి రిసొ ఈంజ లోకుమ్‍చ తీర్పు జవుల. అప్పె జర్గు జంక తిలిస్‍చి రిసొ, ఈంజ లోకుమ్‍క అప్పెచి మట్టుక ఏలుప కెర్తొ సయ్‍తానుక బార్ కెర పెలవ దెయెదె. ");
INSERT INTO key_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","అన్నె, మాన్సుల్ అంక బుఁయి తెంతొ ఉక్కుల టీఁవడ్లి పొదిక దేసిమ్‍లు ఎత్కి తెంతొచ మాన్సుల్‍క అంచితె బుకారా ఆనిందె” మెన ఒత్త తిలసక యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","‘ఉక్కుల టీఁవడ్తి పొదిక’ మెలి కోడుతె కిచ్చొ అర్దుమ్ మెలె, ఏక్ సిలువతె మాన్సుల్ యేసుక టీఁవడ్లె, మొరెదె. జో సంగిలిస్‍తె జయ్యి అర్దుమ్. ");
INSERT INTO key_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","జలె, యేసు జా కోడు సంగితికయ్, జనాబ్‍తెచ మాన్సుల్ ఆచారిమ్ జా కిచ్చొ మెల మెలె, “‘రచ్చించుప కెర్తొసొ జతొ క్రీస్తు నే మొర్తె కెఁయఁక తెఁయఁక తా గెచ్చెదె’ మెన మోసే పూర్గుమ్‍చొచి అత్తి దేముడు రెగ్డయ్‍ల ఆగ్నల్‍తె తిలిసి సూన అస్సుమ్. గని తూయి జలె, ‘ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొక ఉక్కుల టీఁవడుక అస్సె’ మెన తుయి సంగితసి. దస్సి జలె మాన్సు జా జెర్మున్ అయ్‍లొసొ క్రీస్తు జయెదె గే, నెంజె గే?” మెన అన్మానుమ్ జల. ");
INSERT INTO key_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","జేఁవ్ దస్సి జతికయ్, యేసు జోవయింక, “అన్నె సగుమ్ దీసల్ అంచి ఉజిడి తుమ్‍చి తెన్ తయెదె. తుమ్ అందర్‍బుద్దిక దెర్ను నే సేడ్తి రిసొ, ఈంజ ఉజిడి తతె తుమ్ ఈంజ ఉజిడ్‍తె ఇండ. కిచ్చొక మెలె, అందర్‍తె కో ఇండుల గే, కేనె గెతతి గే నేన్‍తి. ");
INSERT INTO key_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","తుమ్ ఉజిడ్‍చ పుత్తర్లు జతి రిసొ, ఈంజ ఉజిడి తుమ్‍తె తతె ఎద ఈంజ ఉజిడ్‍క పూర్తి నంపజంక దెర” మెన బోదన కెర్లన్. యేసు ఇసి సంగ కేడయ్‍లి పడ్తొ, ఒత్త తెంతొ బార్ జా, యూదుల్ నే చజితి రితి లుంకిల్ రితి తిలొ. ");
INSERT INTO key_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","యేసు జోవయించి మొక్మె జోచి అదికారుమ్‍క రుజ్జు దెకయ్‍త ఎత్తివాట్ కమొ కెర తిలె కి, జోక జేఁవ్ నంపజతి నాయ్. ");
INSERT INTO key_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","జేఁవ్ నే నంపజతిసి కిచ్చొక మెలె, యెసయా పూర్గుమ్‍చొచి అత్తి దేముడు రెగిడ్లి కోడు నెరవెర్సుప జతి రిసొయి. “ఓ ప్రబువ, అమ్ సంగిలి తుచి కబుర్ సూన్లె కి, కో నంపజా అస్తి? కోయి నాయ్. తుచి అదికారుమ్‍క రుజ్జు దెకయ్‍త కమొ దెకిలెకి, జోవయించి జా సెక్తి కో చిన అస్తి? కోయి నాయ్” మెన రెగిడ్లి కోడు. ");
INSERT INTO key_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","జాకయ్ యేసుక నంపజంక నెతిర్ల. ");
INSERT INTO key_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","పడ్తొ జోవయించి సిచ్చచి రిసొ యెసయా పూర్గుమ్‍చొచి అత్తి జో ప్రబు రెగ్డియ్‍లిసి అన్నెక్‍తె కి జయ్యి అర్దుమ్. “జోవయించ అంకివొ గుడ్డి కెర్లి రితి కెర, జోవయించి పెట్టి బేడు బందిలి రితి దేముడు కెర అస్సె. ‘జోవయించ అంకివొ దెకుత్ నాయ్, జోవయించి పెట్టి అర్దుమ్ కెరంతు నాయ్, ఆఁవ్ దెతి వరుమ్ నఙనుక బుల జెతు నాయ్’ మెన అంచి సెలవ్” మెన ప్రబు రెగ్డయ్‍లి కోడు. ");
INSERT INTO key_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","యెసయా పూర్గుమ్‍చొ కీసి ఇసి మెలన్ మెలె, దేముడు దెకయ్‍లి సివ్నతె యేసుచి గవురుమ్‍చి గుర్తు దెక తిలొ, చి జోచి రిసొ రెగిడ్లన్. ");
INSERT INTO key_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","యూదుల్‍తె ఒగ్గర్‍జిన్ యేసుక నే నంపజలెకి, జోవయింతె ఒగ్గర్‍జిన్ వెల్లెల మాన్సుల్ కి నంపజల. గని మాన్సుల్‍చి మొక్మె ఒప్పన్‍తి నాయ్. కిచ్చొక మెలె, ‘పరిసయ్యుల్ సూన్లె, అమ్‍క సబ గెరలె అన్నె పెసయితి నాయ్’ మెన బిల. ");
INSERT INTO key_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","కిచ్చొక దస్సి బిల మెలె, దేముడు దెతి గవురుమ్‍చి కంట, మాన్సు దెతి గవురుమ్‍కయ్ ఆస జా తిల. ");
INSERT INTO key_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","జలె, ఎత్కిజిన్ సూన్‍తి రితి కేక్ గల యేసు కిచ్చొ మెన బోదన కెర్లన్ మెలె, “కో అంకయ్ నంపజతతి గే, ఎక్కి అంకయ్ నాయ్, గని అంక తెద్రయ్‍లొసొక నంపజతతి. ");
INSERT INTO key_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","అంకయ్ కో దెకితతి గే, అంక తెద్రయ్‍లొసొక దెకితతి. ");
INSERT INTO key_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","“ఈంజ లోకుమ్‍తె కిచ్చొక అయ్‍లయ్ మెలె, అందర్‍బుద్ది ఇండిత ఈంజ లోకుమ్‍చ మాన్సుల్‍క ‘దస్సి తత్తు నాయ్, గని అంక నంపజా రచ్చించుప జతు’ మెన దొర్కు జలి ఉజిడి తా ఈంజ లోకుమ్‍తె అయ్‍లయ్. ");
INSERT INTO key_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","అంచ కొడొ కో సూన్‍తతి గని కెర్తి నాయ్ గే, జోవయింక ఆఁవ్ తీర్పు కెరి నాయ్. కిచ్చొక మెలె, ఆఁవ్ ఈంజ లోకుమ్‍తె అయ్‍లిసి ఈంజ లోకుమ్‍చక తీర్పు కెర సిచ్చ కెర్తి రిసొ నాయ్, గని జోవయింక రచ్చించుప కెర్తి రిసొయి అయ్‍లయ్. ");
INSERT INTO key_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","“గని జాగర్త తా. కిచ్చొక మెలె, కో అంక నంప కెర్తి నాయ్, చి అంచ కొడొ సూన కెరుక నెసితి గే, జోవయింక తీర్పు కెర సిచ్చతె తెద్రయ్‍తిసి అస్సె. మెలె, ఈంజ లోకుమ్‍చక తీర్పు కెర్తి జా ఆకర్ దీసిక, ఆఁవ్ అప్పె సంగిల కొడొ జోవయింక కచితుమ్ తీర్పు కెర సిచ్చతె తెద్రవుల. ");
INSERT INTO key_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","కిచ్చొక మెలె, అఁవ్వి కెర ఆఁవ్ కిచ్చొ సంగి నాయ్. ఆఁవ్ కిచ్చొ మెన లట్టబుక గే, కిచ్చొ సంగుక గే, అంక తెద్రయ్‍లొ దేముడు అబ్బొయి అంక ఆడ్ర దా అస్సె. ");
INSERT INTO key_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","అన్నె కేనె నాయ్, గని జోచి కోడు కెర్తిస్‍తెయ్ పరలోకుమ్‍తె బెదితి కెఁయఁక తెఁయఁక చెంగిల్ తతి సెక్తి అస్సె మెన కచితుమ్ జాని. జాకయ్ ఆఁవ్ కిచ్చొ సంగితసి గే, దేముడు అబ్బొయి సంగిల్ రితి ఆఁవ్ సంగితసి.” ");
INSERT INTO key_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ఈంజ లోకుమ్ ముల దా దేముడు అబ్బొస్‍తె అన్నె ఉట్ట గెతి సమయుమ్ అయ్‍లి మెన యేసు జానె. జో ఈంజ లోకుమ్‍తె నిసాన్ల బారజిన్ సిస్సుల్‍క అగ్గె తెంతొ ప్రేమ కెర్తయ్, గని అప్పె, పస్కా పండుగ్‍క ఏక్ దీసి అగ్గె, ఆకర్ ఎదచి జోచి ఎదివాట్ ప్రేమ సొస్టుమ్ దెకయ్‍లొ. ");
INSERT INTO key_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","జా సంజె, యేసు జోవయించ బారజిన్ సిస్సుల్ తెన్ ఎక్కితె అన్నిమ్ కెర్తతి. ఇస్కరియోతు సీమోనుచొ యూదా మెలొ పుత్తుసి జోవయింతె అస్సె. జలె, యేసుక విరోదుమ్ సుదల్‍చి అత్తి దెర దెంక మెన సయ్‍తాన్ యూదాక సికడ అస్సె. ");
INSERT INTO key_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","గని, ‘దేముడు అబ్బొ అంచి అత్తి ఎత్కి సొర్ప కెర దా అస్సె, చి దేముడు అబ్బొ తెంతొ ఉత్ర అయ్‍లయ్, చి దేముడు అబ్బొతెయి ఆఁవ్ అన్నె ఉట్ట గెతసి’ మెన యేసు జానె. ");
INSERT INTO key_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","జలె, అన్నిమ్ కెర్తె తిలి పొది యేసు ఉట్ట, జో గలన తిలి దిగిల్ సొక్క రితిసి తిఁయ దా, జోవయించ సిస్సుల్‍క, జో గొత్తి సుదొ జతి రితి గుర్తుక, ఏక్ తువ్వల్ కెరంటె బందన్లన్. ");
INSERT INTO key_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","తెదొడి తప్పెలయ్ పాని సువ కెర, సిస్సుల్‍చ చట్టొ దోవ జో బందన్లి తువ్వల్ తెన్ పుంచుక దెర్లన్. సగుమ్‍జిన్‍చ చట్టొ దోవ పుంచ తా, ");
INSERT INTO key_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","సీమోను పేతురుచ చట్టొ దోవుక మెన జోతె పాఁవిలన్. గని పేతురు జోక, “ప్రబు, తుయి అంచ చట్టొ దోవుక గే? పోని!” మెన బమ్మ తెన్ సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","‘పోని’ మెన సంగితికయ్, యేసు జోక “ఆఁవ్ అప్పె కెర్తిసి తుక అప్పె అర్దుమ్ నాయ్. గని పడ్తొక అర్దుమ్ కెరంతె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","పేతురు జోక అన్నె, “ప్రబు, తుయి అంచయ్ చట్టొ కెఁయఁక కి దోవుక ఆఁవ్ ఒప్పి నాయ్” మెన ఒగ్గర్ జా సంగిలన్. యేసు జోక, “ఆఁవ్ తుక సుబ్రుమ్ నే కెర్లె, అంచి రాజిమ్‍తె తుక కిచ్చొ వాట తయె నాయ్” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","పేతురు జోక, “ప్రబు, దస్సి జలె, అంచ చట్టొ అత్తొ బోడి కి, ఎత్కి దోవ గెలు!” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","తెదొడి యేసు జోక, “కో పాని నాయ తవుల గే, జోచ చట్టొక పిట్టవ, పూర్తి సుబ్రుమ్ జా తవుల. దస్సి, ఎక్కిలొక పిట్టవ, తుమ్ ఎత్కిజిన్ సుబ్రుమ్ జా అస్సుస్” మెలన్. ");
INSERT INTO key_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","యేసు కిచ్చొక దస్సి మెలన్ మెలె, కో జోక విరోదుమ్ సుదల్‍తె దెర దెయెదె గే జో జానె. జాకయ్ ‘ఎక్కిలొక పిట్టవ తుమ్ ఎత్కిజిన్ సుబ్రుమ్ జా అస్సుస్’ మెన సంగ తిలొ. ");
INSERT INTO key_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","సిస్సుల్‍చ చట్టొ దోవ కేడయ్‍లి పడ్తొ, జోచ పాలల్ అన్నె గలన, అన్నె అన్నిమ్‍తె వెస, యేసు జోవయింక, “ఆఁవ్ తుమ్‍క కెర్లి గుర్తుచి రిసొ తుమ్‍క అర్దుమ్ జలి గే నాయ్ గే? ");
INSERT INTO key_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","అల్లె, అంక ‘గురు’, ‘ప్రబు’ మెన తుమ్ సంగితసు. బాద నాయ్. ఆఁవ్ నిజుమి తుమ్‍చొ గురు, తుమ్‍చొ ప్రబు. ");
INSERT INTO key_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ఆఁవ్ జలె, తుమ్‍చొ ప్రబు తుమ్‍చొ గురు జలెకి, తుమ్‍క సేవ కెర్తి ఏక్ గుర్తుక తుమ్‍చ చట్టొ దోవితసి జలె, తూమ్ జా గుర్తుచి అర్దుమ్ కెరన తూమ్ కి ఎక్కిలొచ చట్టొ ఎక్కిలొ దోవిలి రితి జా, ఎక్కిలొక ఎక్కిలొ సేవ కెర్తె తంక. ");
INSERT INTO key_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ఆఁవ్ అప్పె కెర్లిసి జా గుర్తుకయ్, తుమ్‍క ఆఁవ్ కెర్లి రితి తుమ్ ఎక్కిలొక ప్రేమ కెర్తె తంకయ్. ");
INSERT INTO key_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","తుమ్‍క నిజుమి కచితుమ్ ఆఁవ్ కిచ్చొ సంగితసి మెలె, సేవ కెర్తొసొ జోచొ ఎజొమానిచి కంట వెల్లొ నెంజె. దస్సి, తెద్రయ్ జలొసొ, జలె, జోక తెద్రయ్‍లొసొచి కంట వెల్లొ నెంజె. ");
INSERT INTO key_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","జలె, ఈంజ ఎత్కిచి అర్దుమ్ కెరన్లదు మెలె, జా బుద్ది ఇండితె తిలె తుమ్‍క చెంగిలి. ");
INSERT INTO key_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“గని, ఆఁవ్ అప్పె సంగిలి బుద్ది తుమ్ ఎత్కిజిన్ జసు నాయ్. కిచ్చొక మెలె, ఆఁవ్ నిసాన్లసచి బుద్ది ఆఁవ్ జాని. అప్పె జర్గు జతిసి కిచ్చొక జయెదె మెలె, అంచి తెన్ అన్నిమ్ కెర్లొ ఎక్కిలొ అంక తాప్ దిలి రితి కెరెదె మెన రెగిడ్లి కోడు అప్పె నెరవెర్సుప జంకయ్. ");
INSERT INTO key_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ఈంజ ఎత్కి జర్గు నే జతె అగ్గె ఆఁవ్ తుమ్‍క కిచ్చొక సంగితసి మెలె, జా జర్గు జలి మెలె, జా రుజ్జు దెక, ‘నిజుమి దేముడు తెద్రయ్‍లొ క్రీస్తు రచ్చించుప కెర్తొసొ’ మెన అంచి రిసొ తుమ్ పూర్తి దయిరిమ్ తెన్ నంప జస్తె. ");
INSERT INTO key_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","తుమ్‍క అన్నె కిచ్చొ నిజుమి కచితుమ్ ఆఁవ్ సంగితసి మెలె, ఆఁవ్ తెద్రయ్‍త మాన్సుల్‍క కో నంపజా మరియాద కెరుల గే, అంకయ్ నంపజా మరియాద కెర్లి రితి జయెదె. అంకయ్ నంపజా కో మరియాద కెరుల గే, అంక తెద్రయ్‍లొసొక నంపజా మరియాద కెర్లి రితి జయెదె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ఈంజేఁవ్ కొడొ సంగ కెర, యేసు జోచి మెన్సుతె బాద సేడ, సిస్సుల్‍క కిచ్చొ సాచి సంగిలన్ మెలె, “తుమ్‍క కిచ్చొ నిజుమి కచితుమ్ ఆఁవ్ సంగితసి మెలె, తుమ్‍చితె ఎక్కిలొ అంక విరోదుమ్ సుదల్‍చి అత్తి సొర్ప కెర దెయెదె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","జలె, కిచ్చొ రిసొ సంగితయ్ గే నేన్‍తి, చి ఎక్కిలొక ఎక్కిలొ అన్మానుమ్ తెన్ దెక దుకుమ్ జల. ");
INSERT INTO key_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","గని యేసు ఒగ్గర్ ప్రేమ కెర్లొ సిస్సుడు ఎక్కిలొ యేసుచి గుండెచి ఉప్పిరి పెల వెస అస్సె. ");
INSERT INTO key_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","జాకయ్, సీమోను పేతురు జో సిస్సుడుక సయ్‍న కెర, “కచి రిసొ సంగితయ్ గే, సూన అమ్‍క సంగు” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","జాకయ్, యేసుచి గుండెచి ఉప్పిరి పెల తిలొ జో సిస్సుడు “ప్రబు, కచి రిసొ దస్సి సంగిలది?” మెన పుసిలన్, చి ");
INSERT INTO key_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","యేసు పోడి గండ దెర, “ఈంజ పోడి గండ రోస్‍తె బుడ్డవ కక్క దెయిందె గే, జొయ్యి” మెన సంగిలన్. సంగ, జా గండ బుడ్డవ కెర, ఇస్కరియోతు సీమోనుచొ పుత్తుస్ జలొ యూదాక దిలొ. ");
INSERT INTO key_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","యూదా జా గండ నఙన్లి బేగి, సయ్‍తాన్ జోక దెర్లన్. యేసు జానె, చి “తుయి కెరుక తిలిసి బే బేగి జర్గు కెరు!” మెన యూదాక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","యేసు యూదాక కిచ్చొక దస్సి సంగిలన్ గే జా అన్నిమ్ కెర్తె తిలసతె కోయి నేన్‍తి. ");
INSERT INTO key_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","గని జోచి డబ్బుల్ పెటె యూదాచి అత్తి తిలి, చి ‘పండుగు అన్నిమ్‍క దొర్కు జలిసి గెన ఆను’ జలెకు, ‘బీద సుదల్‍క కిచ్చొ జవుస్ దర్ముమ్ దేసు’ మెన యేసు జా కోడు సంగ తయెదె మెన సగుమ్‍జిన్ ఉచర్ల. ");
INSERT INTO key_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","జలె, జా గండ నఙన, యూదా చట్కున బార్ జా ఉట్ట గెలన్. తెదొడి అందర్ జా తిలి. ");
INSERT INTO key_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","యూదా బార్ జతికయ్, తిల సిస్సుల్‍క యేసు, “అప్పెయి జర్గు జతిసి తెన్ ఆఁవ్ మాన్సు జా జెర్మున్ అయ్‍లొసొచి గవురుమ్ డీసెదె, చి అంక జర్గు జతిస్‍చి రిసొ దేముడు ప్రబుచి గవురుమ్ డీసెదె. ");
INSERT INTO key_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","అంచితె జర్గు జతిస్‍తె దేముడుక గవురుమ్ జెయెదె, చి జా కామ్‍తె అంక కి జో గవురుమ్ కెరెదె. బేగి గవురుమ్ కెరెదె. ");
INSERT INTO key_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“ఓ పుత్తర్లు, అప్పె ఏక్ గడియయ్ తుమ్‍చి తెన్ ఇసి తయిందె, చి ఉట్ట గెచ్చిందె. ఆఁవ్ గెలె, అంక చజితె, గని యూదుల్‍క ఆఁవ్ సంగిలి రితి, ఆఁవ్ కేనె గెచ్చిందె గే, తుమ్ అప్పె ఒత్త జెంక నెతుర్సు. ");
INSERT INTO key_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“జలె, తుమ్‍క ఏక్ నొవి ఆగ్న దెతసి. కిచ్చొ ఆగ్న మెలె, తుమ్ ఎక్కిలొక ఎక్కిలొ ప్రేమ కెర్తె తా. ఆఁవ్ తుమ్‍క కెద్ది ప్రేమ దెకవ అస్సి గే, దస్సి తూమ్ కి ఎక్కిలొక ఎక్కిలొ ప్రేమ కెర్తె తంక. ");
INSERT INTO key_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","తుమ్‍చితె ఎక్కిలొక ఎక్కిలొ దస్సి ప్రేమ కెర్తె తిలె, తుమ్‍క ‘అమ్‍చ సిస్సుల్’ మెన ప్రెజల్ ఎత్కి చినుల. జయ్యి జోవయింక రుజ్జు తయెదె” మెన బోదన కెర్లన్. ");
INSERT INTO key_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","తెదొడి సీమోను పేతురు “ప్రబు, కేనె గెతి రిసొ తుయి సంగితసి?” మెన యేసుక పుసిలన్, చి యేసు జోక, “ఆఁవ్ కేనె గెతసి గే, తుయి అప్పె అంచి పట్టి జెంక నెతిర్సి, గని పడ్తొక జెస్తె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","జాకయ్ పేతురు జోక, “ప్రబు, ఆఁవ్ కిచ్చొక అప్పె తుచి పట్టి జెంక నెతిరి? తుచి రిసొ ఆఁవ్ మొర కి గెచ్చిందె!” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","యేసు జోక, “అంచి రిసొ తుయి మొర గెచ్చుక దయిరిమ్ గే? తుక కిచ్చొ నిజుమి కచితుమ్ ఆఁవ్ సంగితసి మెలె. ఆజి రాతిక, కుకుడొ నే వాఁస్తె అగ్గె, ‘జోక నేని’ మెన తుయి తివ్వెరి అంచి రిసొ సంగితె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","తెదొడి యేసు సిస్సుల్‍క, “ఆఁవ్ ఉట్ట గెలె, తుమ్‍చ పెట్టి చింత గలన నాయ్. దేముడుక నంపజా దయిరిమ్ తెన్ తా. అంక కి నంప తెన్ తా. ");
INSERT INTO key_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","జో అంచొ అబ్బొసి జలొ దేముడుచి గెరి ఒగ్గర్ గదివొ అస్తి. తుమ్‍క కి ఒత్త టాన్ అస్సె. నెంజిలె తుమ్‍క సంగితయ్. తుమ్‍క జా టాన్ తెయార్ కెరుకయ్ ఆఁవ్ గెతసి. ");
INSERT INTO key_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ఆఁవ్ గెచ్చ తుమ్ తతి టాన్ తెయార్ కెర్లయ్ మెలె, తూమ్ కి అంచి తెన్ తంక మెన, అంచితె కడ నెతి రిసొ అన్నె జెయిందె. ");
INSERT INTO key_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ఆఁవ్ గెతి టాన్‍చి వాట్ తుమ్ జాన్సు” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","జాకయ్ తోమా మెలొ సిస్సుడు జోక, “ప్రబు, తుయి కేనె గెతసి గే నేనుమ్. జా వాట్ అమ్ కీసి జానుక జయెదె?” మెన పుసిలన్, ");
INSERT INTO key_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","చి యేసు జోవయింక, “ఒత్త గెతి వాట్ ఆఁవ్వి. ఒత్త గెతి రిసొ దొర్కు జలి సత్తిమ్ ఆఁవ్వి. ఒత్త గెతి రిసొ దొర్కు జలి జీవు ఆఁవ్వి. అంక నంపజలెకయ్ మాన్సు దేముడు అబ్బొతె జెంక జయెదె. నెంజిలె కో జెంక నెతిర్తి. కేన్ వేర వాట్ నాయ్. ");
INSERT INTO key_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","అంక తుమ్ నిజుమి జాన్‍తసు జలె, అంచొ దేముడు అబ్బొకయ్ జాన్‍తసు. అప్పె తెంతొ తుమ్ జోక జాన్సు, జోక దెక అస్సుస్” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","జలె, పిలిప్‍క అర్దుమ్ నాయ్ చి రిసొ, “ప్రబు, దేముడు అబ్బొద్‍క అమ్‍క దెకవు, చి అమ్‍క అన్నె కిచ్చొ నాయ్” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","యేసు జోక, “ఓ పిలిప్, తుమ్‍చి తెన్ ఆఁవ్ ఎత్తి దీసల్ తిలె కి, అప్పెక అంక చినిస్ నాయ్ గే? కో అంకయ్ దెక అస్తి గే, దేముడు అబ్బొస్‍క కి దెక అస్తి. జాకయ్, దేముడు అబ్బొద్‍క అమ్‍క దెకవు మెన తుయి కిచ్చొక పుసుక? ");
INSERT INTO key_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ఆఁవ్, అబ్బొసి జలొ దేముడుచి పెట్టి తిలిసి, దేముడు అబ్బొ అంచి పెట్టి తిలిసి, తుయి నంప కెర్సి నాయ్ గె? తుమ్‍క ఆఁవ్ సంగితిసి సికడ్తిసి ఆఁవ్ అఁవ్వి ఉచర్లిసి నెంజె. అంచి పెట్టి తిలొ దేముడు అబ్బొ అంచి అత్తి జోచ కమొ కెర్తయ్. ");
INSERT INTO key_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ఆఁవ్ అబ్బొసి జలొ దేముడుచి పెట్టి అస్సి, దేముడు అబ్బొ అంచి పెట్టి అస్సె. ఈంజ కోడు నంప కెరు. నెంజిలె, ఆఁవ్ సంగిలి రిసొ నే నంప కెర్లె, అంచి అత్తి జర్గు జత కమొక ఉచర నంప కెరు. ");
INSERT INTO key_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","తుమ్‍క నిజుమి కచితుమ్ ఆఁవ్ కిచ్చొ సంగితసి మెలె, అంక కో నంపజవుల గే, ఆఁవ్ కెర్త కమొ జేఁవ్ కి కెరుల. ఆఁవ్ కెర్లసచి కంట జీన్లస కెరుల. కిచ్చొక మెలె, ఆఁవ్ దేముడు అబ్బొతె ఉట్ట గెతసి. ");
INSERT INTO key_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","అంచి నావ్ తెన్ తుమ్ కిచ్చొ నఙితె గే, ఆఁవ్ పుత్తుసి కెర్తిస్‍తె అబ్బొసి జలొ దేముడుచి గవురుమ్ డీసుస్ మెనయ్, జయి ఆఁవ్ జర్గు కెరిందె. ");
INSERT INTO key_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","అంచి నావ్ తెన్ తుమ్ కిచ్చొ జలెకి నఙిలె కి, జర్గు కెర దెయిందె. ");
INSERT INTO key_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“తుమ్ అంచి ఉప్పిరి ప్రేమ తెన్ తిలె, అంచ కొడొ రితి ఇండితె తస్తె. ");
INSERT INTO key_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","తుమ్ దస్సి జలె, దేముడు అబ్బొస్‍క సంగిమ్‍దె, చి అన్నెక్లొ తోడు కెర్తొసొక తుమ్‍తె తెద్రయెదె. జో తుమ్‍చి పెట్టి తా, కెఁయఁక తెఁయఁక తుమ్‍క తోడు తయెదె. ");
INSERT INTO key_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","జో కొన్సొ మెలె, పరలోకుమ్‍చి సత్తిమ్ తిలి సత్తిమ్ దెకయ్‍తి ఆత్మ. ఈంజ లోకుమ్‍చి బుద్ది తిల మాన్సుల్ జోక నంపజంక నెతిర్తి. కిచ్చొక మెలె, జో డీస్తొసొ నెంజె, చి జోక చినితి నాయ్, నేన్‍తి. తూమ్ మాత్రుమ్, జోక జాన్సు. కిచ్చొక మెలె, జో తుమ్‍చి తెన్ తత్తయ్, చి పడ్తొక తుమ్‍చి పెట్టి తయెదె. ");
INSERT INTO key_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“తుమ్‍క ములిలె, తుమ్ పొరబోదల్ తతి రితి కెరి నాయ్. తుమ్‍తె జెయిందె. ");
INSERT INTO key_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","గడియయ్ తిలె, మాములుమ్ ఈంజ లోకుమ్‍చ మాన్సుల్ అంక అన్నె దెకితి నాయ్, గని తూమ్ అంక అన్నె దెకితె. మెలె, ఆఁవ్ జితసిచి రిసొ తూమ్ కి జిస్తె. ");
INSERT INTO key_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ఆఁవ్ అబ్బొసి జలొ దేముడుచి పెట్టి తిలిసి, తూమ్ అంచి పెట్టి తిలిసి, చి ఆఁవ్ తుమ్‍చి పెట్టి తిలిసి, తెదొడ్‍కయ్ తుమ్‍క అర్దుమ్ జెయెదె. ");
INSERT INTO key_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","అంచ కొడొ కో సూన కెరుల గే, జెఁవ్వి అంక ప్రేమ కెర్తసయ్. కో అంకయ్ ప్రేమ కెర్తతి గే, అంచొ దేముడు అబ్బొ జోవయింకయ్ ప్రేమ కెరెదె. ఆఁవ్ కి జోక ప్రేమ కెర, అంచి సత్తిమ్‍చి రిసొ జోక రుజ్జుల్ దెకయిందె, జోక ఆఁవ్ సొస్టుమ్ సొంత డీసిలి రితి” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","తెదొడి యూదా మెలొ ఎక్కిలొ, ఇస్కరియోతు యూదా నెంజె, వేరచొ జో, జలె, యేసుక “కిచ్చొక ఈంజ లోకుమ్‍చ మాములుమ్ మాన్సుల్‍క నాయ్, గని ఎక్కి అమ్‍కయ్ డీస్తె, తుచ రుజ్జుల్ దెకయ్‍తె?” మెన పుసిలొ. ");
INSERT INTO key_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","పుసిలె యేసు జోక, “అంచి ఉప్పిరి కో ప్రేమ తెన్ తవుల గే, అంచి కొడొ రితి కెరుల, దస్సి జలసకయ్ దేముడు అబ్బొ ప్రేమ కెరెదె. దస్సి జలసతెయి దేముడు అబ్బొ ఆఁవ్ జెమ్‍దె, చి జోచి తెన్ బస జా జో తెన్ తా గెచ్చుమ్‍దే. ");
INSERT INTO key_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","అంచి ఉప్పిరి కో ప్రేమ తెన్ తతి నాయ్ గే, జెఁవ్వి అంచ కొడొ రితి కెర్తి నాయ్. తుమ్ సూన్‍తి ఈంజ కోడు, జలె, కచి మెలె, ఆఁవ్ అఁవ్వి ఉచర్లిసి నెంజె. అంక తెద్రయ్‍లొ అబ్బొసి జలొ దేముడుచి కోడు. ");
INSERT INTO key_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“జలె, ఆఁవ్ తుమ్‍చి తెన్ ఈంజ లోకుమ్‍తె తతె, ఆఁవ్వి ఈంజ బోదన ఎత్కి తుమ్‍క సూనవ అస్సి. ");
INSERT INTO key_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","గని, ఆఁవ్ దేముడు అబ్బొతె గెలె, దేముడు అబ్బొ అంచి నావ్ తెన్ తుమ్‍క తోడు తతొసొక తెద్రయెదె. జో తోడు తతొసొ కొన్సొ మెలె, దేముడుచి సుద్ది తిలి అబ్బొసి జలొ దేముడుచి సుద్ది తిలి ఆత్మయి. జో అమ్‍చి ఆత్మయి తతొసొ తుమ్‍క ఎత్కి సికడెదె. ఆఁవ్ తుమ్‍క సంగిలిసి ఎత్కి తుమ్‍క ఉచార కెరయెదె. ");
INSERT INTO key_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“జలె, ఆఁవ్ తుమ్‍క సేంతుమ్ దా కెర ఉట్ట గెతసి. అంచి సేంతుమ్ తుమ్‍క దెతసి. ఈంజ లోకుమ్‍చ దెతి రగుమ్‍చి నెంజె. జాకయ్ కిచ్చొ బాదల్ అల్లర్ అయ్‍లె కి, తుమ్‍చ పెట్టి చింత గలన నాయ్, బయిమ్ తియన నాయ్. ");
INSERT INTO key_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‘ఆఁవ్ ఉట్ట గెలె కి, తుమ్‍తె అన్నె జెయిందె’ మెన సంగిలిసి సూన్లదు. తుమ్ అంచి ఉప్పిరి పూర్తి ప్రేమ తత్తదు జలె, ఆఁవ్ దేముడు అబ్బొతె గెతిస్‍చి రిసొ సర్ద జతదు. కిచ్చొక మెలె, దేముడు అబ్బొ అంచి కంట వెల్లొ. ఒత్త గెలె, ఇన్నె తతి కంట అంక చెంగిలి, తుమ్‍క చెంగిలి. ");
INSERT INTO key_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","జలె, జా ఎత్కి జర్గు నే జతె అగ్గె తుమ్‍క కిచ్చొక సంగితసి మెలె, తుమ్‍క ‘జా జర్గు జతి పొదిక, పూర్తి నంప తెన్ తా, బమ్మ నెంతె దయిరిమ్ తత్తు’ మెనయ్ అంచి ఆస. ");
INSERT INTO key_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“తుమ్‍చి తెన్ అన్నె ఒగ్గర్ లట్టబుక సమయుమ్ నాయ్. కిచ్చొక మెలె, ఈంజ లోకుమ్ ఈంజ మదెనె ఏలుప కెర్తొసొ, సయ్‍తాన్ జెతయ్. అంచి ఉప్పిరి జోక కిచ్చొ అదికారుమ్ నాయ్, ");
INSERT INTO key_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","గని దేముడు అబ్బొ అంక తియార్లి కామ్ ఆఁవ్ కెరుక అస్సె. జో సంగిలి రితి ఆఁవ్ కెర్లె, అంక ‘నిజుమి, దేముడు అబ్బొస్‍క ప్రేమ కెర్తయ్’ మెన లోకుమ్ ఎత్కిచ చినుల. అల్లె, జొమ్మ, గెచ్చుమ!” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","తెదొడి యేసు ఇసి మెన టాలి సంగిలన్. “ఆఁవ్ నిజుమ్ జలొ ద్రాచ రూకు జయిందె. అంచొ దేముడు అబ్బొ రూకుక పోస్తొసొ జయెదె. ");
INSERT INTO key_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","జలె, అంచ కొన్నల్‍తె కేన్ కొన్నతె పంటొ దెరె నాయ్ గే, ఈంజొ రూకు పోస్తొ దేముడు అబ్బొ జా కొన్న గెచ్చవ గెలెదె. గని కేన్ కొన్నతె పంటొ దెరెదె గే, ‘అన్నె ఒగ్గర్ పంటొ దెర్సు’ మెన, కొస్సల్ కుట్టవ గెలెదె. ");
INSERT INTO key_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","“తుమ్‍క ఆఁవ్ సూనయ్‍లి కొడొ సూన్లదుచి రిసొ, తుమ్ సుద్ది జా అస్సుస్. ");
INSERT INTO key_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","జలె, ఆత్మక అంచి తెన్ బెద తా అంచి తెడి తుమ్ జిఁయ అంచి సెక్తిక ఇండ, అంచి పెట్టి తా. ఆఁవ్ కి తుమ్‍చి పెట్టి తయిందె. తీగెచి కొన్న అఙ జలె, ఒత్త కిచ్చొ పంటొ దెరుక నెత్రె. తీగె తెన్ ఎక్కి తిలెకయ్ ఒత్త పంటొ దెరెదె. దస్సి, తుమ్ ఆత్మక అంక ముల అఙ జలె, తుమ్‍తె కిచ్చొ పంటొ దెర్తి రితి జంక నెతుర్సు. అంచి తెన్ ఎక్కి తిలెకయ్ పంటొ తుమ్‍తె దెరెదె. ");
INSERT INTO key_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“ద్రాచ రూకు అఁవ్వి, రూక్‍చి జీవు అంచి పెట్టి అస్సె. తూమ్ అంచ కొన్నల్. ఆత్మక అంచి తెన్ బెద తా అంచి తెడి జిఁయ అంచి సెక్తిక కో ఇండ అంచి పెట్టి తవుల గే, జోచి పెట్టి ఆఁవ్ తయిందె, చి జో తెన్ ఒగ్గర్ పంటొ దెర్తె తయెదె. ఆఁవ్ నెంజిలె, తుమ్ కిచ్చొ కెరుక నెతుర్సు. ");
INSERT INTO key_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","కో ఆత్మక అంచి తెన్ బెద నే తతె అంచి తెడి నే తతె అంచి సెక్తిక నే ఇండితె అంచి పెట్టి తతి నాయ్ గే, కామ్‍క నెంజిలి కొన్న కుట్టవ వెంట గెలి రితి జయెదె, కొమ్జ జా మొర గెచ్చెదె. కొన్నల్ దస్సి జలె, జోవయింక గుడ్డ కెర ఆగితె గల డయుల. కో ఆత్మక అంచి తెన్ బెద నే తతె అంచి తెడి నే తతె అంచి సెక్తిక నే ఇండితె అంచి పెట్టి తతి నాయ్ గే, దస్సి జవుల. ");
INSERT INTO key_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","గని ఆత్మక అంచి తెన్ బెద తా అంచి తెడి జిఁయ అంచి సెక్తిక తుమ్ ఇండ అంచి పెట్టి తా అంచి కోడు రితి తుమ్ కెర్తె తిలె, తుమ్ అంచితె కిచ్చొ నఙితె గే, తుమ్‍చి రిసొ జర్గు జయెదె. ");
INSERT INTO key_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","తుమ్ దస్సి జా చెంగిల్ పంటొ ఒగ్గర్ తుమ్‍తె దెర్లె, చి దేముడు అంచొ అబ్బొస్‍క మాన్సుల్ గవురుమ్ కెరుల. జయ్యి పంటొ జోవయింక గవురుమ్ ఆనెదె, అంచ సిస్సుల్ తుమ్ కచితుమ్ జలిస్‍క రుజ్జు డీసెదె. ");
INSERT INTO key_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“దేముడు అంచొ అబ్బొ అంకయ్ కీసి ప్రేమ కెర్తయ్ గే, ఆఁవ్ కి తుమ్‍క దస్సి ప్రేమ కెర అస్సి. అంచి ప్రేమ తెడి తుమ్ తా. ");
INSERT INTO key_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","దేముడు అంచొ అబ్బొచ కొడొ ఆఁవ్ కెర్తె తా జోచి ప్రేమచి తెడి తా జోచి ప్రేమ తెన్ ఇండితసి. దస్సి, అంచయ్ కొడొ తూమ్ కెర్తె తిలె, అంచి ప్రేమచి తెడి తుమ్ తా అంచి ప్రేమ ఇండితె. ");
INSERT INTO key_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","‘అంచి సంతోసుమ్ తుమ్‍చి పెట్టి తవుస్’ మెన, తుమ్‍క ‘పూర్తి సంతోసుమ్ జా తత్తు’ మెనయ్, ఈంజేఁవ్ కొడొ ఎత్కి ఆఁవ్ సంగ అస్సి. ");
INSERT INTO key_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“ఆఁవ్ తుమ్‍కయ్ కీసి ప్రేమ కెర అస్సి గే, తూమ్ కి ఎక్కిలొక ఎక్కిలొ ప్రేమ కెర్తె తా, మెన తుమ్‍క ఆఁవ్ సంగితసి. ఈంజయి తుమ్‍క ఆగ్న జా అస్సె. ");
INSERT INTO key_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","‘జితు’ మెన, జోవయించ మింతర్సుల్‍చి రిసొ కో జలెకు మొర్తి కంట, కిచ్చొ జీన్లి ప్రేమ నాయ్. ");
INSERT INTO key_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ఆఁవ్ తుమ్‍క సంగిల్ రితి తుమ్ కెర్లె, అంచ గోతుసుదల్ జా తస్తె. ");
INSERT INTO key_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","తుమ్‍క ‘గొత్తి సుదల్’ రితి అప్పె తెంతొ దెకి నాయ్. కిచ్చొక మెలె, జోవయించొ ఎజొమాని కిచ్చొ కెర్తె తయెదె గే గొత్తి సుదల్ నేన్‍తి. ఆఁవ్, మాత్రుమ్, అంచొ అబ్బొస్‍తె సూన్లిసి ఎత్కి తుమ్‍క సంగ అస్సి. జాచి రిసొ తుమ్‍క ‘గోతుసుదల్’ రితి దెకితసి. ");
INSERT INTO key_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“తూమ్ అంకయ్ నిసాన్సు నాయ్. ఆఁవ్ తుమ్‍కయ్ నిసాన్లయ్. ఆఁవ్ తుమ్‍క కిచ్చొక నిసాన అంచి కామ్ తియార్ అస్సి మెలె, తుమ్ ఈంజ లోకుమ్‍తె బార్ జతు, చి అంచి ఆత్మపంటొ జోవయింతె దెర్తె తవుస్ మెన ‘జోవయింతె దెర్తి ఈంజ పంటొ కెఁయఁక తెఁయఁక చెంగిల్ తా కామ్‍క జెతె తవుస్’. తుమ్ అంక నిదానుమ్ తిలెగిన, అంచి నావ్ తెన్ దేముడు అంచొ అబ్బొతె తుమ్ కిచ్చొ నఙిలె కి, తుమ్‍క దెయెదె. ");
INSERT INTO key_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","తుమ్‍క కిచ్చొ ఆగ్న దెతసి మెలె, ఎక్కిలొక ఎక్కిలొ తుమ్ ప్రేమ కెర్తె తంకయ్. ");
INSERT INTO key_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“ఈంజ లోకుమ్‍చ మాన్సుల్ తుమ్‍క విరోదుమ్ జతతి జలె, అంక కి అగ్గె తెంతొ విరోదుమ్ జా అస్తి. ");
INSERT INTO key_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ఈంజ లోకుమ్‍చ కమొ కెర్తస తుమ్ జతదు జలె, ఈంజ లోకుమ్‍చ మాన్సుల్ తుమ్‍క ప్రేమ కెర్త. గని, ఈంజ లోకుమ్‍చ తెంతొ తుమ్‍క ఆఁవ్ నిసాన్లయ్, చి ఈంజ లోకుమ్‍చ కమొ తుమ్ కెర్సు నాయ్ చి రిసొ ఈంజ లోకుమ్‍చ తుమ్‍క విరోదుమ్ జా అస్తి. ");
INSERT INTO key_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","“జలె, ఆఁవ్ తుమ్‍క సంగిలి కోడు తుమ్ పఁవ్స నాయ్. కేన్ కోడు మెలె, ‘సేవ కెర్తొసొ జోచొ ఎజొమానిచి కంట వెల్లొ నెంజె’ మెలిసి. ఈంజ లోకుమ్‍చ మాన్సుల్ అంకయి అల్లర్ కెర అస్తి జలె, తుమ్‍క కి అల్లర్ కెరుల. జేఁవ్ అంచయ్ కొడొ రితి కెర్తతి జలె, తుమ్‍చయ్ కొడొ సూన కెరుల. ");
INSERT INTO key_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","అంచి రిసొయి తుమ్‍క అల్లర్ కెరుల మెలె, కిచ్చొక మెలె అంక తెద్రయ్‍లొ దేముడుక జేఁవ్ నేన్‍తి. ");
INSERT INTO key_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“ఆఁవ్ జెతయ్ నాయ్ జలె, జోవయింక సుబుమ్ కబుర్ సంగితయ్ నాయ్ జలె, జా పాపుమ్ జేఁవ్ వయిత నాయ్. గని, అయ్‍లయ్, సంగిలయ్, చి అప్పె, ‘నేన కెర దస్సి కెర్లమ్’ మెన జేఁవ్ సంగుక నెతిర్తి. జా పాపుమ్ వయ అస్తి. ");
INSERT INTO key_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","మెలె అంకయ్ కో విరోదుమ్ జవుల గే, దేముడు అబ్బొస్‍క విరోదుమ్ జా అస్తి. ");
INSERT INTO key_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","అన్నె, కేన్ మాన్సుకి కెఁయ కి నే కెర్త కమొ ఆఁవ్ జోవయించి మొక్మె కెర్తయ్ నాయ్ జలె, జా పాపుమ్ వయిత నాయ్. గని అంక దెకయ్ అంక విరోదుమ్ జా అస్తి. జేఁవ్ అంకయ్ దెక విరోదుమ్ జలిసి జలె, అబ్బొక దెక విరోదుమ్ జలిసి జయెదె. దస్సి జా, అబ్బొస్‍క కి విరోదుమ్ జా అస్తి. ");
INSERT INTO key_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","జోవయించి మోసే పూర్గుమ్‍చొచి అత్తి దేముడు రెగ్డయ్‍ల ఆగ్నల్‍తె పూర్గుమ్ దేముడు అబ్బొ రెగ్డయ్‍లిసి నెరవెర్సుప జంకయ్ ఇసి జా అస్తి. కేన్ కోడు మెలె, ‘ఆరిక అంక విరోదుమ్ జల.’ ");
INSERT INTO key_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“దేముడు అంచొ అబ్బొతె తెంతొ ఆఁవ్ సంగిలొ తోడ్ కెర్తొసొక తుమ్ సిస్సుల్‍తె తెద్రయిందె. జో అబ్బొచి పెట్టి తెంతొ బార్ జా జెతొసొ. నిజుమ్ జలి ఆత్మ, జో. జో తుమ్‍తె జా కెర, అంచి రిసొయి సాచి సంగెదె. ");
INSERT INTO key_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","తూమ్ కి అంచి రిసొ సాచుల్ జా అస్సుస్. కిచ్చొక మెలె, అంచ కమొ మొదొల్ కెర్లి తెంతొ అంచి తెన్ని అస్సుస్.” ");
INSERT INTO key_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“ఆఁవ్ కిచ్చొక తుమ్‍క ఈంజ ఎత్కి సంగ అస్సి మెలె, తుమ్‍క ‘తెదొడ్‍క బమ్మ జా అన్మానుమ్ జతు నాయ్’ మెన జేఁవ్ అల్లర్ నే జతె అగ్గె తుమ్‍క ఆఁవ్ సంగితసి. ");
INSERT INTO key_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","జేఁవ్ దీసల్‍క తుమ్‍క జోవయించ సబ గెరల్ తెంతొ ఉదడ అన్నె పెసయ్‍తి నాయ్. అన్నె, ‘ఇన్నెక మార్లె చెంగిలి, మార్లె దేముడుచి సేవ కెర తమ్‍దె’ మెన సగుమ్‍జిన్ ఉచర తుమ్‍క మారుల. ");
INSERT INTO key_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","కిచ్చొక దస్సి కెరుల మెలె, జేఁవ్ అంక నేన్‍తి. ");
INSERT INTO key_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","జా నే జతె అగ్గె తుమ్‍క ఆఁవ్ కిచ్చొక సంగ అస్సి మెలె, జా సమయుమ్ జా అయ్‍లె, ‘ఇసి జయెదె మెన సంగిలొ’ మెన తుమ్ ఉచార కెర్తె. జలె, తుమ్ అంచ సిస్సుల్ జలి మొదొల్ తెంతొయ్ ఈంజ ఎత్కి తుమ్‍క ఆఁవ్ కిచ్చొక సంగుక నాయ్ మెలె, తుమ్‍చి తెన్ తిలయ్, చి సంగుక నాయ్. ");
INSERT INTO key_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“అప్పె, అంక తెద్రయ్‍లొసొతె ఆఁవ్ అన్నె గెతసి. గని ‘కేనె గెతసి?’ మెన అప్పె తుమ్‍చితె కో అంక పుసుస్ నాయ్. ");
INSERT INTO key_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ఆఁవ్ ఈంజ ఎత్కి తుమ్‍క సంగిలి రిసొ దుకుమ్ జా అస్సుస్. ");
INSERT INTO key_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","జలెకి, తుమ్‍క కిచ్చొ సత్తిమ్ సంగితసి మెలె, ఆఁవ్ గెలెకయ్ తుమ్‍క చెంగిలి. కిచ్చొక మెలె, ఆఁవ్ నే గెలె, అమ్‍చి ఆత్మ జతొ ఆఁవ్ సంగిలొ తోడ్ కెర్తొసొ తుమ్‍క తోడ్ జెయె నాయ్. గని ఆఁవ్ గెలె, తుమ్‍తె జోక తెద్రయిందె. ");
INSERT INTO key_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","“జో అయ్‍లొ మెలె, పాపుమ్‍చి రిసొ, సత్తిమ్‍చి రిసొ, తీర్పు కెర్తిసిచి రిసొ ఈంజ లోకుమ్‍చ మాన్సుల్‍క రుజ్జుల్ దెకయెదె. ");
INSERT INTO key_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","లోకుమ్ అంక నంపజయె నాయ్ చి రిసొ పాపుమ్ వయ అస్తి మెన అంక నంపనెంజిలసక రుజ్జు దెకయెదె. ");
INSERT INTO key_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","అంచొ దేముడు అబ్బొస్‍తె ఆఁవ్ ఉట్ట గెచ్చిందె, అంక అన్నె తూమ్ ఇసి దెకుస్ నాయ్. అంచి పున్నిమ్‍చి రిసొ ఈంజ లోకుమ్‍చక జో రుజ్జు దెకయెదె. ");
INSERT INTO key_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","జాచి రిసొ ఈంజ లోకుమ్‍క అప్పెచి మట్టుక ఏలుప కెర్తొ సయ్‍తాన్ తీర్పు జా, జోచి పాపుమ్ వయ సిచ్చతె గెచ్చుక అస్సె మెన రుజ్జు దెకయెదె. ");
INSERT INTO key_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“ఆఁవ్ తుమ్‍క సంగితిసి కెత్తిగే అస్సె. గని, అప్పె సంగిలె తుమ్ ఓర్సుప జంక నెతుర్సు. ");
INSERT INTO key_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","జలె జో, సత్తిమ్ జలి ఆత్మ జలొసొ తుమ్‍చి పెట్టి అయ్‍లె, జొయ్యి సత్తిమ్‍తె తుమ్‍క ఇండయెదె. జోక, జొయ్యి కిచ్చొ సంగె నాయ్. జో ఒత్త అమ్‍తె కిచ్చొ సూనెదె గే, జయ్యి తుమ్‍క సంగెదె. ");
INSERT INTO key_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","జో అంచితె తిలిసియి కడన తుమ్‍క సూనఎదె. జాచి రిసొయి అంక గవురుమ్ కెరెదె. ");
INSERT INTO key_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","అబ్బొసి జలొ దేముడుచి ఎత్కి అంచి, జాకయ్ ‘జో తుమ్‍క సంగితిసి ఎత్కి అంచి’ మెన తుమ్‍క సంగిలయ్. ");
INSERT INTO key_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“ఇదిల్ కాలుమ్ గెలి పడ్తొ అంక తుమ్ దెకుక నెతుర్సు, అన్నె, ఇదిల్ కాలుమ్‍తె అంక దెకితె మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","జోచ సిస్సుల్‍తె సగుమ్‍జిన్ ఎక్కిలొ తెన్ ఎక్కిలొ లట్టబ, గడియ గెలె, అంక దెకుస్ నాయ్. ఒత్త తెంతొ అన్నె గడియ గెలె, అంక అన్నె దెకితె మెన కిచ్చొక సంగిలన్. ఆఁవ్ ‘దేముడు అబ్బొతె ఉట్ట గెచ్చిందె’ మెన కిచ్చొక సంగిలన్?” మెన సంగితె తిల. ");
INSERT INTO key_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“గడియ గెలె మెన కిచ్చొ అర్దుమ్ తెన్ సంగితయ్? జో కిచ్చొచి రిసొ సంగితయ్ గే నేనుమ్” మెన లట్టబన్ల. ");
INSERT INTO key_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","జేఁవ్ జొయ్యి పుసితతి మెన, నా యేసు జానయ్ జేఁవ్‍చి తెన్ ఇసి సంగిలొ. అన్నె గడియ గెలె, తుమ్ అంక దెకుస్ నాయ్. ఒత్త తెంతొ. అన్నె గడియ గెలె, తుమ్ అంక అన్నె దెకితె మెన ఆఁవ్ సంగిలయ్, గెద. ఇన్నెచి రిసొ ఎక్కిలొ తెన్ ఎక్కిలొ లట్టబ్తసు, నాయ్ గే? ");
INSERT INTO key_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","తూమ్ దుకుమ్ జా ఏడ్తె. గని, లోకుమ్‍చ సర్ద జవుల తుమ్‍చి దుకుమ్ సర్దతెను తయెదె మెన తుమ్‍క కచితుమ్ సంగితసి. ");
INSERT INTO key_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","లడెస్ జతి తేర్‍బోద, జలె, జాచి కంట్లు పాఁవ జా అయ్‍లి మెలె, ఏడెదె, గెద. గని, లడెస్ జలి మెలె, ఈంజ లోకుమ్‍తె ఏక్ ‘బోద జెర్మిలొ’ మెన జాచి సర్దక బేగి దుకుమ్ ఎత్కి పఁవ్స గెలెదె. ");
INSERT INTO key_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","దస్సి, ఆఁవ్ అప్పె గెలె, తుమ్‍క గడియ దుకుమ్ తయెదె. గని, ఆఁవ్ తుమ్‍చి తెన్ అన్నె దస్సుల్ జయిందె, చి తుమ్‍చి పెట్టి సంతోసుమ్ జా గెతె, చి కో కి తుమ్‍చితె తిలి సంతోసుమ్ కడుక నెతిర్తి. ");
INSERT INTO key_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","జేఁవ్ దీసల్‍తె అంక తుమ్ కిచ్చొ కి పుసితిసి నాయ్. తుమ్ దేముడు అబ్బొతె కిచ్చొ సంగిలే కి, అంచి నావ్ తెన్ దొర్కు జయెదె మెన తుమ్‍క కచితుమ్ సంగితసి. ");
INSERT INTO key_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","అప్పె ఎద అంచి నావ్ తెన్ తుమ్ కిచ్చొ నఙుక నాయ్. తుమ్‍చి సంతోసుమ్ పూర్తి జతి లెక నఙ, దొర్కు జయెదె. ");
INSERT INTO key_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“ఈంజ సంగతి ఒండి కి అర్దుమ్ లుంకయ్ జలి రితి సంగ అస్సి. జలె ఆఁవ్ కెఁయ్యఁక జలెకి అర్దుమ్ లుంకయ్ జలి రితి తుమ్‍చి తెన్ నే లట్టబ్తె, అబ్బొస్‍చి రిసొ తుమ్‍క సొస్టుమ్‍గ సూనయ్‍తి గడియ జెతయ్. ");
INSERT INTO key_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","జా దీసల్ అయ్‍లి పొది అంచి నావ్ తెన్, తుమ్ నఙితె. గని, దేముడుక తుమ్‍చి తెన్ ఆఁవ్ నెడిమి జా ప్రార్దన కెర్తిసి నెంజె మెన సంగుక నాయ్. ");
INSERT INTO key_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","కిచ్చొక మెలె అబ్బొ తుమ్‍క ప్రేమించుప కెర్తయ్. తూమ్ అంక ప్రేమించుప కెర, అంక అబ్బొ జలొ దేముడు తెంతొ బార్ జా అయ్‍లన్ మెన నంపజలదు. ");
INSERT INTO key_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","దేముడు అబ్బొ తెంతొ ఆఁవ్ బార్ జా ఈంజ లోకుమ్‍తె అయ్‍లయ్. అన్నె, అప్పె ఈంజ లోకుమ్ ముల దా, ఒత్త జోతె అన్నె గెతసి” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","జోచ సిస్సుల్, జలె, “ఈందె, అర్దుమ్ లుంకయ్ జలి రితి కిచ్చొ కి నే సంగితె సొస్టుమ్‍గ లట్టబ్తసి. ");
INSERT INTO key_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","తుయి ఎత్కి జాన్సి, చి అమ్ నే పుసిలెకి, అమ్‍చి మెన్సు తిలిసి తుయి జాన్సి మెన అప్పె జానుమ్. దేముడుతె తెంతొ తూయి బార్ జా అయ్‍లదు మెన నంపజా సంగితి కాయ్. ");
INSERT INTO key_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","యేసు జోవయింక దెక, అప్పె తూమ్ నంపజతసు గే? ");
INSERT INTO key_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ఈందె తుమ్‍చితె ఒండిజిన్‍క కి కచి గెరి జొయ్యి సెదుర్‍ప జా అంక ఎక్కిలోకయి ముల దెతి గడియ జెతయ్, జా అస్సె. జలె అబ్బొ అంచితె అస్సె చి రిసొ ఆఁవ్ ఎక్కిలొయి నెంజి. ");
INSERT INTO key_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“ఈంజ ఎత్కి కిచ్చొక తుమ్‍క సంగ అస్సి మెలె, ‘అంచి తెడి తుమ్‍క సేంతుమ్ తవుస్’ మెనయ్. కిచ్చొక మెలె, ఈంజ లోకుమ్‍తె అల్లర్ సేడ్తె, గని దయిరిమ్ తెన్ తా. ఈంజ లోకుమ్‍తెచ అల్లర్‍చి ఉప్పిరి ఆఁవ్ జీన అస్సి” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","యేసు ఈంజ ఎత్కి సంగ కేడవ, ఆగాసుమ్ పక్క దెక, పరలోకుమ్ తిలొ దేముడు అబ్బొస్‍క ప్రార్దన కెర్లన్. “ఓ బ, అంచి సమయుమ్ జా అయ్‍లి మెన జాని. ఆఁవ్ తుచొ పుత్తుది తుచి గవురుమ్ దెకయ్‍తి రితి, ఆఁవ్ పుత్తుస్ తా గవురుమ్ కెరు. ");
INSERT INTO key_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ఈంజ లోకుమ్ ఎత్కిచ మాన్సుల్‍చి ఉప్పిరి ఆఁవ్ పుత్తుక తుయి అదికారుమ్ దా అస్సిస్. కో అంక నంపజంక తుయి సెలవ్ దా అస్సిస్ గే, జెఁవ్వి తుచి రాజిమ్‍తె బెదితి, మొర్లె పరలోకుమ్‍తె గెచ్చ కెఁయఁక తెఁయఁక జితి రితి ఆఁవ్ దెంక మెన, తుయి అంచి అత్తి సొర్ప కెర దా అస్సిస్. ");
INSERT INTO key_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","తుయి ఎక్కిలొయి నిజుమ్ జలొ దేముడు తుక, తుయి తెద్రయ్‍లొ అంక, జేఁవ్ నంపజతిసి, అమ్‍క జేఁవ్ జాన్‍తిసి, ఆఁవ్ యేసు తుయి తెద్రయ్‍లొ రచ్చించుప కెర్తొసొ జతొ క్రీస్తు. ");
INSERT INTO key_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","తుయి అంక తియార్లి కామ్ ఆఁవ్ పూర్తి నెరవెర్సుప కెర, ఈంజ లోకుమ్‍తె తుక గవురుమ్ ఆన అస్సి. ");
INSERT INTO key_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ఓ బ, ఈంజ లోకుమ్ నే జెర్మున్ జతె అగ్గె తెంతొ తుచి తెన్ ఆఁవ్ ఒత్త తతె అంక కీసి గవురుమ్ తిలి గే, అప్పె తుచితె పరలోకుమ్‍తె అన్నె దస్సి గవురుమ్ జతి రితి కెరు. ");
INSERT INTO key_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“అంచ సిస్సుల్ జతి రితి, ఈంజ లోకుమ్‍చ మాన్సుల్‍తె సగుమ్‍జిన్‍క తుయి నిసాన, అంచి అత్తి సొర్ప కెర దా అస్సిస్. తుయి కీసొచొ గే ఈంజేఁవ్ దెకిత్ రితి ఆఁవ్ ఈంజ లోకుమ్‍తె జిఁయ అస్సి. తుచయ్ మాన్సుల్ ఈంజేఁవ్, చి ఇన్నెక అంచి అత్తి తుయి సొర్ప కెర దిలది, చి తుచి కోడు రితి ఈంజేఁవ్ నిదానుమ్ ఇండ అస్తి. ");
INSERT INTO key_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","తుయి అంక దిలిసి ఎత్కిచి రిసొ ‘వేరచి నెంజె, గని తుయి దిలిసి’ మెన అప్పె జాన్‍తి. అంక తుయి తెద్రయ్‍లొసొ నిజుమ్ మెన చినిల. ");
INSERT INTO key_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","‘సంగు’ మెన తుయి సంగిలి కొడొ ఎత్కి ఇన్నెయింక ఆఁవ్ సంగ అస్సి, చి ఈంజేఁవ్ సూన, నంపజా, ఆఁవ్ తుచితె తెంతొ ఉట్ట అయ్‍లిస్‍క ‘నిజుమ్’ మెన జాన్‍తి. తుయి అంక తెద్రవ అస్సిస్ మెన నంపజా అస్తి. ");
INSERT INTO key_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“ఇన్నెచి రిసొయి ఆఁవ్ అప్పె ప్రార్దన కెర్తసి. ఈంజ లోకుమ్‍చ ఎత్కిజిన్‍చి రిసొ ఇసి మెన ప్రార్దన కెరి నాయ్, గని ఈంజేఁవ్ తుయి అంచి అత్తి సొర్ప కెర దిలసయ్‍చి రిసొ ప్రార్దన కెర్తసి. ఈంజేఁవ్ తుచయ్ మాన్సుల్. ");
INSERT INTO key_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","అంచి ఒండి తుచయ్, తుచి ఒండి అంచయ్, చి ఈంజేఁవ్ నిదానుమ్ జలిస్ తెన్ అంక గవురుమ్ జెతయ్. ");
INSERT INTO key_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“ఆఁవ్ తుచితె అప్పె అన్నె జెతసి చి అప్పె తెంతొ ఆఁవ్ ఈంజ లోకుమ్‍తె తయె నాయ్. గని ఈంజేఁవ్, మాత్రుమ్ తవుల. సుద్ది తిలొ ఓ బ, ఈంజేఁవ్ చెంగిల్ తతి రితి, తుయి అంక దిలి తుచి నావ్‌చి సెక్తిక ఇన్నెక రక్కు, చి ఆఁవ్ తుయి కీసి ఎక్కి జా అస్సుమ్ గే ఈంజేఁవ్ కి ఎక్కి జా తంక తుచి నావ్ తెన్ ఇనయింక దెకు. ");
INSERT INTO key_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ఆఁవ్ ఇనయింతెన్ బుల్తె తిలి పొది, తుయి అంక దిలి తుచి నావ్ తెన్ ఇన్నెక రకితె తిలయ్. ఆఁవ్ జేఁవ్‍క జాగరిత తెన్ రకిలయ్ చి, ఇనయింతె కో నాసెనుమ్ జతి నాయ్. నాసెనుమ్‍తె గెతొ జో ఎక్కిలొ పిట్టవ, జలె, తుయి పూర్గుమ్ రెగ్డయ్‍లి రితి నాసెనుమ్ జా అస్సె, దేముడుచి కొడొతె తిలి జా కోడు అప్పె నెరవెర్సుప జతి రిసొ. ");
INSERT INTO key_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“అప్పె, జలె, ఆఁవ్ తుచితె జెతసిచి రిసొ, ‘అంచి సంతోసుమ్ ఇన్నెచి పెట్టి నెరవెర్సుప జా కామ్ కెర్సు’ మెన ఈంజ ఎత్కి, అప్పె ఈంజ లోకుమ్‍తె ఆఁవ్ తతె, ఇన్నెచి మొక్మె తుక సూనయ్‍తసి. ");
INSERT INTO key_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","“‘సంగు’ మెన తుయి సంగిలిసి ఎత్కి ఇన్నెయింక ఆఁవ్ సంగ అస్సి. ఆఁవ్ ఈంజ లోకుమ్‍చొ నెంజి, చి అంచ సిస్సుల్ ఈంజేఁవ్ జలి తెంతొ, ఈంజేఁవ్ కి ఈంజ లోకుమ్‍చ నెంజితిచి రిసొ, ఈంజ లోకుమ్‍చ ప్రెజల్ ఇన్నెయింక విరోదుమ్ దెకితతి. ");
INSERT INTO key_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","జలె, తుక ‘ఈంజ లోకుమ్‍తె తెంతొ ఇన్నెయింక కడ నెవుసు’ మెన అంచి ఆస నాయ్, గని ‘ఈంజ లోకుమ్‍తె ఈంజేఁవ్ తా గెలె, సయ్‍తాన్‍క, జోచి సేవక, ఈంజేఁవ్ దెర్ను నే సేడ్తి రితి రక్కు’ మెన తుక ప్రార్దన కెర్తసి. ");
INSERT INTO key_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","“ఆఁవ్ కీసి ఈంజ లోకుమ్‍చొ నెంజి గే, అంక నంపజలి తెంతొ ఈంజేఁవ్ కి ఈంజ లోకుమ్‍చ నెంజితి. ");
INSERT INTO key_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ఈంజేఁవ్ పూర్తి తుచయ్ జా తుచి సేవ నిదానుమ్ కెర్తె తతి రితి, తుచి సత్తిమ్‍తె ఇన్నెక సుద్ది కెరు. తుచి కోడు సత్తిమ్. ");
INSERT INTO key_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","తుయి కీసి అంకయ్ ఈంజ లోకుమ్‍తె తెద్రయ్‍లది గే, మాన్సుల్‍క ఈంజేఁవ్ సత్తిమ్ వాట్ దెకయ్‍తి రితి, ఆఁవ్ ఇన్నెక తెద్రవ దా అస్సి. ");
INSERT INTO key_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ఈంజేఁవ్ కి తుచి సత్తిమ్‍తె తుచయ్ జా, తుచి సుద్ది జా తుక నిదానుమ్ తత్తు మెనయ్, అంచి జీవ్ తుచి అత్తి ఆఁవ్ సొర్ప కెర దెతసి. ");
INSERT INTO key_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“ఎక్కి ఈంజేఁవ్ అంచ సిస్సుల్‍చి రిసొ ఇసి ప్రార్దన కెరి నాయ్. ఈంజేఁవ్ అంచి రిసొ సాచి సంగిలె, ఇన్నెయించి కోడు సూన అన్నె కో అంక నంపజా గెచ్చుల గే, జోవయించి రిసొ కి ఆఁవ్ ప్రార్దన కెర్తసి. ");
INSERT INTO key_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ఓ బ, తుయి కీసి అంచి పెట్టి అస్సిస్ గే, చి ఆఁవ్ కీసి తుచి పెట్టి అస్సి గే, దస్సి ఈంజేఁవ్ కి, జేఁవ్ కి, అమ్‍చి పెట్టి తా ఎక్కి జతు, చి దస్సి ఎక్కి జల మెలె, ఈంజ లోకుమ్‍చ అన్నె మాన్సుల్ దెకిలె, తుయి అంక తెద్రయ్‍లిసి జేఁవ్ కి నంపజవుల. ");
INSERT INTO key_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","తుచి గవురుమ్‍తె అంక కీసి తుయి టీఁవడ అస్సిస్ గే, అంచి గవురుమ్‍తె ఆఁవ్ ఇన్నెయింక టీఁవడ అస్సి, చి ఆఁవ్, తూయి, కీసి ఎక్కి జా అస్సుమ్ గే, ఈంజేఁవ్ కి ఎక్కి జతు మెనయ్ అంచి ఆస. ");
INSERT INTO key_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","దస్సి, ఆఁవ్ ఇన్నెయించి పెట్టి, తుయి అంచి పెట్టి తమ్‍దె, చి ఈంజేఁవ్ పూర్తి ఎక్కి జవుల. దస్సి జలె, ఈంజ లోకుమ్‍చ మాన్సుల్ కిచ్చొ దొన్ని చినుల మెలె, అంక తెద్రయ్‍లొసొ తుయి మెన చినుల, చి తుయి అంకయ్ కెద్ది ప్రేమ కెర అస్సిస్ గే, ఇన్నెయింక కి తుయి తెద్ది ప్రేమ కెర్తసి మెన చినుల. ");
INSERT INTO key_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“ఈంజ లోకుమ్ నే జెర్మున్ కెర్తె అగ్గె తెంతొ అంచి ఉప్పిర్‍చి తుచి ఎదివాట్ ప్రేమక అంక ఒగ్గర్ గవురుమ్ దా అస్సిస్. జలె, ఓ బ, తుయి అంక దిల సిస్సుల్ కి ఆఁవ్ తిలిస్‍తె అంచి తెన్ తత్తు, చి తుయి అంక దిలి గవురుమ్ దెకుతు, మెన అంచి ఆస. ");
INSERT INTO key_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","పున్నిమ్ తిలొ ఓ బ, ఈంజ లోకుమ్‍చ తుక నేన తిలె కి, ఆఁవ్ తుక జాని, చి కచితుమ్ తుయి అంక తెద్రయ్‍లిసి ఈంజేఁవ్ సిస్సుల్ జాన్‍తి. ");
INSERT INTO key_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","తుయి అంక ప్రేమ కెర్లి ప్రేమ ఇన్నెయించి పెట్టి తవుస్ మెన, ఆఁవ్ ఇన్నెయించి పెట్టి తంక మెన, తుయి కీసొచొ జా అస్సిస్ గే, ఇన్నెయింక ఆఁవ్ దెకవ అస్సి, దెకయ్‍తె తయిందె” మెన దేముడు అబ్బొస్‍క యేసు ప్రార్దన కెర్లన్. ");
INSERT INTO key_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","యేసు ఈంజేఁవ్ కొడొ సంగ కేడవ, జోచ సిస్సుల్ తెన్ బార్ జా, కెద్రోను మెంతి లోయ ఒత్తల్‍తొచి ఒడ్డుతె జీన గెచ్చ, సిస్సుల్ తెన్ ఒత్త తిలి తోటతె పెసిల. ");
INSERT INTO key_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","పుండితి రిసొ యేసు జోచ సిస్సుల్ తెన్ ఒత్త గెచ్చుక అలవాట్‍చి రిసొ, అప్పె ఒత్త గెచ్చ తవుల మెన, జోక విరోదుమ్ సుదల్‍తె దెర దెంక గెలొ యూదాక అజ్జ. ");
INSERT INTO key_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","జో యూదా జలె, వెల్లెల పూజర్లుతె చి పరిసయ్యుల్‍తె గెచ్చ, జోచ జమాన్లు సగుమ్‍జిన్‍క, సయ్‍న్యుమ్ సుదల్ సగుమ్‍జిన్‍క కడ ఆన, జేఁవ్, లాంతెర్లు దివ్వొ, అయ్‍దల్ దెరన, యేసు తిలిస్‍తె ఉట్ట అయ్‍ల. ");
INSERT INTO key_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","జోక జర్గు జంక తిలిసి ఎత్కి యేసు జానె చి, జేఁవ్ దెర్తస ఒత్త పాఁవ జెతికయ్, జో పుర్రెతొ జా, “కక్క చజితసు?” మెన జోవయింక పుసిలన్. ");
INSERT INTO key_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","జేఁవ్ జోక, “నజరేతు గఁవ్విచొ యేసుక చజితసుమ్” మెన జబాబ్ దిల, చి యేసు జోవయింక “అఁవ్వి జో!” మెలన్. జోవయించి అత్తి జోవయింక దెర దెంక ఒప్పన్లొ యూదా జోవయింతెన్ ఒత్త టీఁవ అస్సె. ");
INSERT INTO key_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","జలె, “ఆఁవ్వి జో” మెన యేసు సంగితికయ్, జోక దెరుక మెన అయ్‍ల జనాబ్ పడ్తొ గుంచ బుఁయ్యె సేడ గెల. ");
INSERT INTO key_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","పడ్తొ, “కక్క చజితసు?” మెన యేసు జోవయింక అన్నెక్ సుట్టు పుసిలన్, చి “నజరేతు గఁవ్విచొ యేసుక” మెన అన్నెక్ సుట్టు సంగిల. ");
INSERT INTO key_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","సంగిలె, యేసు జోవయింక “‘ఆఁవ్వి జో’ మెన తుమ్‍క సంగిలయ్, గెద. అంకయ్ చజితసు జలె, అంకయ్ దెర, గని అంచి తెన్ తిలసక పోన” మెన జబాబ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","చి యేసు అగ్గె సంగ తిలి ఏక్ కోడు ఇన్నెయితెన్ ఏక్ రగుమ్‍క నెరవెర్సుప జలి. “తుయి అంచి అత్తి సొర్ప కెర దిలసతె కో నాసెనుమ్ జతి నాయ్” మెన దేముడు అబ్బొస్‍క తెదొడి సంగ తిలి కోడు. ");
INSERT INTO key_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","జలె, సీమోను పేతురుక ఏక్ కండా తిలి. జో పేతురు జా కండా కడన, ఎత్కిక వెల్లొ పూజరిచొ గొతిమాన్సు ఎక్కిలొక కుంద, జోచి ఉజిల్ కంగ్డొ సింద గెలన్. జో గొతిమాన్సుచి నావ్ ‘మల్కు’. ");
INSERT INTO key_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","పేతురు దస్సి కెర్తికయ్, “కండా తిఁయ దేస్! దేముడు అబ్బొ అంక తియార్లి కామ్ దుకుమ్ స్రెమల్ జతిసి జలెకి, ఆఁవ్ జా కామ్ కెరుకయ్, జా దుకుమ్, జా స్రెమ ఓర్సుప జంకయ్” మెన పేతురుక యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","జలె, జేఁవ్ జమాన్లు, జోవయించొ అదికారి చి దేముడుచి గుడిచ సయ్‍న్యుమ్ సుదల్ యేసుక దెర, బంద గెల. ");
INSERT INTO key_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","తొలితొ ‘అన్నా’ మెలొసొతె కడ నిల. జో కొన్సొ మెలె, కయప మెలొ జా వెర్సిచొ ఎత్కిక వెల్లొ పూజరిచొ మామొసి. ");
INSERT INTO key_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","‘అమ్‍చ యూదుల్ నస్టుమ్ నే జతి రిసొ ఎక్కిలొ మొర్లె చెంగిలి’ మెన యూదుల్‍చ వెల్లెల మాన్సుల్‍క, ఎత్కిక వెల్లొ పూజరి అగ్గె సంగ తిలొ. ఈంజొ కయప జో ఎత్కిక వెల్లొ పూజరి. ");
INSERT INTO key_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","యేసుక జేఁవ్ మాన్సుల్ దెర ఎత్కిక వెల్లొ పూజరితె కడ నెతె తిలి పొది, సీమోను పేతురు, అన్నెక్లొ సిస్సుడు, దొగుల, జేఁవ్ దెర్లసచి పట్టి గెల. ఎత్కిక వెల్లొ పూజరి జో అన్నెక్లొ సిస్సుడుక జానె, చి జో సిస్సుడు కి యేసు తెన్ ఎత్కిక వెల్లొ పూజరిచి గెరి తెడి పెసిలన్. ");
INSERT INTO key_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","గని, పేతురు గుమ్ముమ్ పాసి, బయిలె టీఁవ జా తిలొ. జలె, ఎత్కిక వెల్లొ పూజరి జాన్లొ జో అన్నెక్ సిస్సుడు అన్నె బార్ జా, గుమ్ముమె రకితి తేర్‍బోద గొత్తి సుదొక సంగ, పేతురుక తెడి కడ ఆన్లన్. ");
INSERT INTO key_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","జా తేర్‍బోద గొత్తి సుదొ పేతురుక దెక, “తుయి కి జో మాన్సుచొ సిస్సుడు, కిచ్చొగె” మెలన్, గని “నెంజి” మెన పేతురు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","జలె, ‘చల్లి’ మెన, ఎత్కిక వెల్లొ పూజరిచ గొత్తి సుదల్ దేముడుచి గుడిచ సయ్‍న్యుమ్ సుదల్ తెన్ మెసి బొగుల్‍చి ఆగి లావ తపితె తిల. పేతురు కి, తపుక మెన గెచ్చ, ఒత్త జోవయింతెన్ అస్సె. ");
INSERT INTO key_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","మదెనె ఎత్కిక వెల్లొ పూజరి యేసుక పరిచ్చ కెర్లన్. జోచ సిస్సుల్‍చి రిసొ, జోచి బోదనచి రిసొ పరిచ్చ కెర్లన్. ");
INSERT INTO key_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","యేసు జోక కిచ్చొ జబాబ్ దిలన్ మెలె, “అంచి బోదన, జలె, ఈంజ లోకుమ్‍చ ఎత్కిజిన్ సూన్‍తి రితి ఎదార్దుమ్ సంగ అస్సి. అమ్‍చ యూదుల్‍చ సబ గెరలె బోదన కెర్తె తిలయ్, చి దూరి పాసి తెంతొ ఎత్కిజిన్ యూదుల్ బెర జెతికయ్ అమ్‍చి దేముడుచి గుడితె కి బోదన కెర్తె తిలయ్. ఆఁవ్ కెఁయ్య కి, కిచ్చొ కి లుంకచోరు సంగి నాయ్. ");
INSERT INTO key_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","జాకయ్, కిచ్చొక అంకయ్ పుసుక? కిచ్చొ కిచ్చొ సంగ అస్సి గే, అంక సూన్లసకయ్ పుస” మెన యేసు జబాబ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","యేసు దస్సి సంగితికయ్, పాసి టీఁవ తిలొ సయ్‍న్యుమ్ సుదొ ఎక్కిలొ యేసుక పెట, “ఎత్కిక వెల్లొ పూజరిక తుయి దస్సి జబాబ్ దెంక బెదెదె గే? పోని!” మెన గోల కెర్లన్. ");
INSERT INTO key_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","యేసు జోక కిచ్చొ జబాబ్ దిలన్ మెలె, “ఆఁవ్ సంగిలిసి తప్పు తిలెగిన, రుజ్జు దెకవ సాచి సంగ, గని, ఆఁవ్ సంగిలిసి సత్తిమ్ జతయ్. జాక, కిచ్చొక అంక పెటుక?” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","తెదొడి అన్నా, యేసుక బందున్ తెన్ ఎత్కిక వెల్లొ పూజరి జలొ కయపతె తెద్రయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","సీమోను పేతురు ఒత్త ఆగి తపితె అస్సె, జలె, ఒత్త తిల మాన్సుల్ జోక “తుయి కి యేసుచొ సిస్సుడు, నెంజిస్ గే?” మెంతికయ్, జో “ఆఁవ్ నెంజి” మెలన్. ");
INSERT INTO key_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","గని ఎత్కిక వెల్లొ పూజరిచొ గొతిమాన్సుచి కండొ పేతురు అగ్గె సింద తిలొ. జలె, జో మాన్సుచొ సొంత మాన్సు ఎక్కిలొ ఒత్త తిలొ. జో, జలె, పేతురుక “అప్పె తూయి జోవయింతెన్ తోటతె తిలది. తుక దెకిలయ్, గెద?” మెలన్. ");
INSERT INTO key_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","గని, “నాయ్, జో మాన్సుక నేని!” మెన పేతురు సంగిలన్, చి జో సంగిల్ బేగి కుకుడొ వాఁసిలన్. ");
INSERT INTO key_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","తెదొడి, యేసుక కయప మెలొ జో ఎత్కిక వెల్లొ పూజరి పుస కెర కేడయ్‍తికయ్, జా రోమ దేసిమ్ తెంతొచొ అదికారిచి మేడతె జోక వెల్లెల మాన్సుల్ కడ నిల. గని, జోక కడ నిలస జా మేడ తెడి పెసితి నాయ్. కిచ్చొక మెలె, జేఁవ్ యూదుల్ జవుల, చి పస్కా మెలి జోవయించి పండుగు తిలి, చి ‘యూదుల్ నెంజిల మాన్సుల్‍చ గెరలె పెసిలె గార్ జమ్‍దె, చి గార్ జలె పండుగ్ అన్నిమ్ కంక గారు. పండుగు పిట్టెదె’ మెంతతి. ");
INSERT INTO key_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","జాకయ్, పిలాతు మెలొ జో అదికారి బార్ జా, జోవయింతెన్ జా కెర “కిచ్చొ నేరిమ్ కెర్లొ మెన ఈంజొ మాన్సుచి రిసొ తుమ్ సంగితసు?” మెన యూదుల్‍చ జేఁవ్ వెల్లెల మాన్సుల్‍క పుసిలన్. ");
INSERT INTO key_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","జేఁవ్ జోక “ఈంజొ నేరిమ్ కెర్తొ నాయ్ జలె, ఇన్నెక తుచితె సొర్ప కెరుక మెన కడ ఆన్‍తమ్ గే? నాయ్” మెన జబాబ్ దిల. ");
INSERT INTO key_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","దస్సి సంగితికయ్, పిలాతు జోవయింక, “తుమ్ ఇన్నెక కడన, తుమి, దేముడు మోసే తెన్ దిలి తుమ్‍చ సొంత ఆగ్నల్ రితి ఇన్నెక తీర్పు కెర!” మెలన్. దస్సి మెంతికయ్ జేఁవ్ జోక “ఆమ్ కెర్తి రితి పత్రల్ గల మార్తి సిచ్చ కెరుక జలె, ‘నాయిమ్ నాయ్’ మెన, తుమ్ రోమియులు ఒప్పుస్ నాయ్” మెన జబాబ్ దిల. ");
INSERT INTO key_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","జేఁవ్ దస్సి జబాబ్ దిలి తెంతొ ‘సిలువతె మొర గెచ్చిందె’ మెలి అర్దుమ్ తెన్, జో మొర్తిసి కిచ్చొ రగుమ్ జర్గు జతిస్‍చి రిసొ యేసు అగ్గె సంగ తిలి కోడు నెరవెర్సుప జలి. ");
INSERT INTO key_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","పడ్తొ పిలాతు, మేడచి తెడి అన్నె పెస, యేసుక బుకార్లన్. యేసుచి రిసొచ కొడొ సూన తిలొ, చి “తుయి యూదుల్‍చొ రానొ గే?” మెన జోక పుసిలన్. ");
INSERT INTO key_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ఇసి పుస పరిచ్చ కెర్తికయ్, యేసు జోక, “తుయి అజ్జ కెర అంక దస్సి సంగితసి గే? నాయ్ మెలె, కో జలెకు వేర మాన్సు తుక దస్సి మెన అంచి రిసొ సంగ అస్తి గే?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","జాచి రిసొ, పిలాతు జోక “ఆఁవ్ యూదుడు గే, చి దస్సి మెనిందె? నెంజి, తుచ సొంత యూదుల్‍చ వెల్లెల మాన్సుల్, వెల్లెల పూజర్లు, తుక అంచితె సొర్ప కెర అస్తి. కిచ్చొ కెర అస్సిస్, చి తుక దస్సి కెర్తతి?” మెన పిలాతు పుసిలన్. ");
INSERT INTO key_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","యేసు, జలె, కిచ్చొ జబాబ్ దిలన్ మెలె, “అంచి రాజిమ్ ఈంజ లోకుమ్‍చి నెంజె. అంచి రాజిమ్ ఈంజ లోకుమ్‍చి జతి జలె, యూదుల్‍చ వెల్లెల మాన్సుల్‍చి అత్తి ఆఁవ్ దెర్ను నే సేడ్తి రితి అంచ గొత్తి సుదల్ యుద్దుమ్ కెర్త. గని అంచి రాజిమ్ ఈంజ లోకుమ్‍చి నెంజె” మెన జబాబ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","యేసు దస్సి సంగితికయ్, పిలాతు జోక “దస్సి జలె, ‘రానొ’ మెన తుయి నిజుమ్ సంగితసి గే?” మెన అన్నె పరిచ్చ కెర్లన్, చి యేసు జోక, “‘రానొ’ మెన తుయి అంక సంగితసి. ఆఁవ్ కిచ్చొక జెర్మిలయ్, కిచ్చొక ఈంజ లోకుమ్‍తె అయ్‍లయ్ మెలె, సత్తిమ్ దెకవుక, సత్తిమ్‍చి రిసొ సాచి సంగుక అయ్‍లయ్. జయ్యి అంచి కామ్. కో సత్తిమ్‍తె బెదితస జవుల గే, అంక నంపజవుల” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","యేసు దస్సి సంగితికయ్, పిలాతు మెలొ జో అదికారి, “కేతె, సత్తిమ్?” మెన సంగిలొ. పిలాతు దస్సి సంగ కెర, మేడ తెంతొ బార్ జా, యూదుల్‍చ వెల్లెల మాన్సుల్ తిలిస్‍తె అన్నె గెచ్చ, “ఈంజొ కిచ్చొ నేరిమ్ నే కెర్లి రితి అంక డీస్తయ్. ");
INSERT INTO key_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","తుమ్‍చి పస్కా పండుగ్‍క మాత్రుమ్, జేల్‍తె తిలొ కేన్ జవుస్ జేలి జలొసొక తుమ్‍చి రిసొ ఆఁవ్ విడ్దల్ కెరుక అంక అలవాట్. జలె, కక్క ఆఁవ్ ముల దెంక? తుమ్‍చ యూదుల్‍చొ ఈంజొ రానొక ముల దెంక?” మెన పిలాతు పుసిలన్. ");
INSERT INTO key_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","గని జేఁవ్ కీసి జల మెలె, “ఈంజొ మాన్సుక పోని! బరబ్బక ములు!” మెన ఒర్స దిల. బరబ్బ, జలె, మాన్సుక మొరయ్‍తెసొ. ");
INSERT INTO key_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","జలె, పిలాతు తెదొడి కిచ్చొ కెర్లన్ మెలె, ‘పెట్లె సాలు కిచ్చొగె’ మెన ఉచర, కొర్డల్ తెన్ పెటయిలన్. ");
INSERT INTO key_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ఒత్త తెంతొ, సయ్‍న్యుమ్ సుదల్ సగుమ్‍జిన్, యేసుక మేడచి తెడి కడ నా కెర, ఆరి కొంకడ్తి రితి ‘రానొ’ మెన కంటకంపల్ తెన్ ఏక్ కిరీటుమ్ గంచ, జోచి బోడితె గల, ఊద రంగుచొ పాలుమ్ జోక గల దా తెయార్ కెర, ");
INSERT INTO key_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","పాసి జా జొకర, “యూదుల్‍చొ రానొ, తుక జెయ్యి!” మెన మొక్మె పెట్ల. ");
INSERT INTO key_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","తెదొడి, యూదుల్‍చ వెల్లెల మాన్సుల్ తిలిస్‍తె పిలాతు అన్నె బార్ జా, జోవయింక “ఓదె, జో కిచ్చొ నేరిమ్ నే కెర్లి రితి అంక డీస్తయ్, చి జయి గుర్తుక, తుమ్‍క రుజ్జు దెకయ్‍తి రితి, తుమ్ తిలిస్‍తె ఆఁవ్ జోక బార్ కెర్తసి” మెన సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","కంట కంపల్‍చి కిరీటుమ్ జోచి బోడి తతె, ఎరన పాలుమ్ జో గలన తతె, యేసుక బార్ కెర్ల, చి “ఈందె జో మాన్సు!” మెన, పిలాతు దెకయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","యేసుక దెకిల్ బేగి, వెల్లెల పూజర్లు చి దేముడుచి గుడిచ సయ్‍న్యుమ్ సుదల్ కీసి జల మెలె, “జోక సిలువతె గల మొర్తి సిచ్చ కెరు! సిలువతె గలు!” మెన ఒర్సిల. జేఁవ్ దస్సి జతికయ్, “తుమి కడన సిలువతె గల! ఈంజొ కిచ్చొ నేరిమ్ నే కెర్లి రితి అంక డీస్తయ్. జా పూచి నెసి!” మెన పిలాతు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","యూదుల్‍చ వెల్లెల మాన్సుల్ జోక కిచ్చొ జబాబ్ దిల మెలె, “అమ్‍క దేముడు మోసే తెన్ దిలి ఆగ్నల్ అస్సె. జా ఆగ్న కీసిచి మెలె, అమ్‍చొ దేముడు తెన్ కో జలెకు సమ్మందుమ్ సంగన్లె, ‘వెల్లి పాపుమ్ కెర అస్సె’ మెన, జో మాన్సు మొర్తి సిచ్చ జంక అస్సె. ఈంజొ, జలె, ‘దేముడుచొ పుత్తుసి ఆఁవ్’ మెనన, జయ్యి పాపుమ్ కెర అస్సె, చి మొర్తి సిచ్చ జో జంక అస్సె!” మెన వెల్లెల మాన్సుల్ సంగిల. ");
INSERT INTO key_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","పిలాతు, జలె, జేఁవ్ కొడొ సూన, బలే బియఁ గెచ్చ, యేసుక అన్నె కడన, ");
INSERT INTO key_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","జా మేడచి తెడి అన్నె పెస, జోక, “తుయి కేనె తెంతొ అయ్‍లది?” మెన పుసిలన్. గని యేసు తుక్లె తా జబాబ్ దెయె నాయ్. ");
INSERT INTO key_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","తుక్లె తతికయ్, పిలాతు జోక, “తుయి కిచ్చొక అంచి తెన్ లట్టబ్సి నాయ్? తుక విడ్దల్ కెరుక జవుస్, నెంజిలె మొర్తి సిచ్చ దా సిలువతె గలుక జవుస్, అంక అదికారుమ్ అస్సె మెన తుయి నేన్సి గే?” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","జో దస్సి సంగితికయ్, యేసు జోక కిచ్చొ జబాబ్ దిలన్ మెలె, “జా అదికారుమ్, జలె, దేముడు తుక దెతొ నాయ్, జలె, అంచి ఉప్పిరి తుక కిచ్చొ అదికారుమ్ తత్తి నాయ్. గని, తుయి ఇన్నె ఏలుప కెరుక నాయిమ్. జాకయ్, తూయి అప్పె కెర్తిస్‍చి పాపుమ్ తొక్కి. తుచి అత్తి అంక సొర్ప కెర్లసచి పాపుమ్ ఒగ్గరి!” మెన పిలాతుక యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","తెదొడి, యేసుక విడ్దల్ కెరుక మెన పిలాతు ఇస్టుమ్ జా, యూదుల్‍చ వెల్లెల మాన్సుల్ తిలిస్‍తె అన్నె బార్ జా, జోవయింక సంగిలన్, గని జేఁవ్ పిలాతుక కిచ్చొ మెన బియడ్ల మెలె, “ఎక్కిలొ ‘రానొ’ మెనన్లె, జో తుచొ అదికారి జలొ రోమ్ దేసిమ్‍చొ కైసర్ రానొక యుద్దుమ్ కెర్లి రితి జయెదె, చి దసొ మాన్సుక తుయి విడ్దల్ కెర్లె, ‘కైసర్‍క విరోదుమ్ జలొ’ మెన తుచి రిసొ కి నేరిమ్ వయడుక జయెదె” మెన పిలాతుక బియడ్ల. ");
INSERT INTO key_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","జేఁవ్ కొడొ సంగ పిలాతుక దస్సి బియడ్తికయ్, ఒత్త జేఁవ్ తిలిస్‍తె పిలాతు యేసుక అన్నె బార్ కెరవ, మేడచి పుర్రెచి సద్రె తిలి తీర్పు కెర్తి టాన్‍తె వెసిలన్. సద్దుర్‍క ‘గబ్బతా’ మెన యూదుల్‍చి ఎబ్రీ బాస తెన్ సంగుల. ");
INSERT INTO key_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ఈంజ కెఁయ జర్గు జలి మెలె, యూదుల్‍చి పస్కా పండుగ్‍కచి సెలవ్ కడన్లి తెయార్ కెర్లి అగ్గె దీసి, పాసి పాసి మెద్దెనె. పిలాతు, జలె, యేసుక అన్నె దెకవ, “అల్లె, తుమ్‍చొ రానొ, ఈంజొ!” మెన యూదుల్‍చ వెల్లెల మాన్సుల్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","జేఁవ్, “జోక అమ్‍చొ రానొ మెంతసి గె? జో గెస్సు! మొర్సు! సిలువతె గలు!” మెన ఒర్సిల. జేఁవ్ దస్సి జతికయ్, పిలాతు జోవయింక అన్నె, “తుమ్‍చొ రానొక ఆఁవ్ సిలువతె గల మారుక గే?” మెన జోవయింక కొంకడ్లన్. చి వెల్లెల పూజర్లు కిచ్చొ మెల మెలె, “ఎక్కి కైసర్ అమ్‍క రానొ. అన్నె కో నాయ్!” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","జేఁవ్ దస్సి సంగితికయ్, యేసుక సిలువతె గల మొర్తి సిచ్చ కెర్తి సెలవ్ దా, జోక జోవయించి అత్తి పిలాతు సొర్ప కెర దిలన్. తెదొడి జమాన్లు యేసుక దెర నిల. ");
INSERT INTO key_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","తెదొడి, సిలువతె గల మారుక మెన, యేసుక దెర్ల, చి జోక గల్తి సిలువ జొయ్యి వయన బార్ జా, ‘గొల్గొతా’ మెలి మెట్టయ్ ఉట్ట గెల. ఎబ్రీ బాస తెన్ జా నావ్‌చి అర్దుమ్ కిచ్చొ మెలె, ‘గిడ్గి పోలికచి టాన్’. ");
INSERT INTO key_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ఒత్త, జా సిలువతె జోక గల, జోచి అత్తొచట్టొతె మేకుల్ పెట, సిలువతె టీఁవడ రోవిల. యేసుచి సిలువ నెడిమి రోవ, జోచి డెబ్రి పక్క ఎక్కిలొక, ఉజెతొ పక్క అన్నెక్లొక, దొగుల చోర్లుక కి దస ఎక్కెక్ సిలువల్‍తె గల, దస్సి టీఁవడ్ల. ");
INSERT INTO key_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","‘యేసుచి సిలువచి బోడి గల’ మెన పిలాతు ఏక్ దార్చిగండతె రెగ్డయిలన్. కిచ్చొ రెగ్డయిలన్ మెలె, “నజరేతు గఁవ్విచొ యేసు, ఈంజొ యూదుల్‍చొ రానొ జయెదె” మెన రెగ్డయిలన్. ");
INSERT INTO key_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","యేసుక సిలువతె గలిలి టాన్, జలె, యెరూసలేమ్ పట్నుమ్‍చి పాసిచి రిసొ, యూదుల్ ఒగ్గర్‍జిన్ జా వాట్ గెచ్చుక జెంక జతె తిల, చి జా దార్చిగండతె కొడొ సదు కెర్ల. తిన్ని బాసల్ తెన్ కి పిలాతు జా దార్చిగండతె రెగ్డవ తిలొ, జోవయించి సొంత ఎబ్రీ బాస తెన్ కి, రోమ దేసిమ్‍చి లాటిన్ బాస తెన్ కి, పడ్తొ ఒగ్గర్ బియ్యారి కెర్తి గ్రీకు దేసిమ్‍చి గ్రీకు బాస తెన్ కి, రెగ్డవ తిలన్. దస్సి తిలె, కో అయ్‍లె కి అర్దుమ్ కెరనుల, గెద, ");
INSERT INTO key_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","చి ‘జా దార్చిగండ దెకితస అమ్‍క ఆఁసుల’ మెన యూదుల్‍చ వెల్లెల మాన్సుల్‍క లాజు, కోపుమ్, చి రిసొ, జోవయించ వెల్లెల పూజర్లు పిలాతుతె గెచ్చ, “‘యూదుల్‍చొ రానొ జయెదె’ మెన రెగుడుక కిచ్చొక? జా పోని, గని ‘యూదుల్‍చొ రానొ ఆఁవ్ మెన ఈంజొ మాన్సు సంగన్లొ’ మెన రెగుడు!” మెన పిలాతుక సంగిల. ");
INSERT INTO key_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","గని పిలాతు, “ఆఁవ్ రెగ్డయిలిసి ఆఁవ్ రెగ్డవ అస్సి. దస్సి తవుసు” మెన, మార్సుప కెరె నాయ్. ");
INSERT INTO key_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","సయ్‍న్యుమ్ సుదల్, జలె, యేసుక సిలువతె గల టీఁవడ్లి పడ్తొ, జోచ పాలల్‍క చెత్తర్ వాటల్ కెర, వంటన్ల. జోచి దిగిల్ సొక్క కి తిలి, గని కుటు నెంతె వీంన్లొ పాలుమ్ జా, చి దస్సే వంటనుక నెంజిలి. ");
INSERT INTO key_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","జాక, “జా పాలుమ్ చిరుక పోని. చీటి గలుమ, చి కక్క సేడెదె గే, దెకుమ” మెన చీటి గలిల. కిచ్చొక ఇసి జర్గు జలి మెలె, దేముడు పూర్గుమ్ రెగ్డయ్‍లి కోడు నెరవెర్సుప జంకయ్ ఇసి జలి. “అంచ పాలల్ వంటనుల, చి అంచొ ఏక్ పాలుమ్‍క చీటి గలుల” మెన రెగిడ్లి కోడు. ");
INSERT INTO key_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","సయ్‍న్యుమ్ సుదల్, జలె, యేసుచ పాలల్‍క ఆస జా దస్సి కెర్ల, గని యేసుచి అయ్యసి, పడ్తొ క్లోప మెలొ ఎక్కిలొచి తేర్సి మరియ, యేసుచి అయ్యస్‍చి అప్పసి జయెదె, యేసుక పెద్దయసి జయెదె, పడ్తొ మగ్దల పట్నుమ్‍చి మరియ కి, జేఁవ్ తేర్‍బోదల్ యేసుచి సిలువచి పాసి టీఁవఁ అస్తి. ");
INSERT INTO key_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","జలె, యేసు అయ్యస్‍క దెకిలన్, చి జో ఒగ్గర్ ప్రేమ కెర్లొ సిస్సుడు కి ఒత్త టీఁవ అస్సె మెన దెకిలన్, చి జో సిస్సుడుక దెకవ అయ్యస్‍క “ఓదె, తుచొ పుత్తుది!” మెన సంగ, ");
INSERT INTO key_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","అయ్యస్‍క దెకవ, జో సిస్సుడుక “ఈందె, తుచి అయ్యది!” మెన సంగిలన్. జాక జయి గడియ తెంతొ జో సిస్సుడు దెకిత్ తంక మెన, సొర్ప కెర దిలొ, చి జయి గడియ తెంతొ జో సిస్సుడు జాక గెరి కడన, ‘అయ్య’ మెన జాక పోసిలొ. ");
INSERT INTO key_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","తెదొడి ‘అంచి కామ్ ఎత్కి కేడ గెలి’ మెన యేసు జానన, “అంక తాన్ కెర్తయ్” మెన సంగిలన్. ఇన్నెతెన్ కి, దేముడు పూర్గుమ్ రెగ్డయ్‍లి కోడు నెరవెర్సుప జలి. ");
INSERT INTO key_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","జలె, ఒత్త ఏక్ తప్పెలయ్ అమ్‌డి ద్రాచ రస్సుమ్ తిలి, చి ఏక్ బూంజు రితిసి జా రస్సుమ్‍తె బుడ్డవ కెర, ఏక్ రివ్వతె దెరవ కెర, యేసు చుపిర్తి రితి ఒత్తచ సయ్‍న్యుమ్ సుదల్ చంపొ కెర్ల. ");
INSERT INTO key_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","జలె, యేసు జా రస్సుమ్ చుప్ర కెర, “అంచి కామ్ పూర్తి జలి” మెన సంగ, బోడి వంపొ కెర, జోచి ప్రానుమ్ దేముడు అబ్బొస్‍చి అత్తి సొర్ప కెర దా, మొర గెలన్. ");
INSERT INTO key_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","జా దీసి తెయార్ జతి దీసి. అన్నెక్ దీసి, సెలవ్ కడన్లి దీసి, ‘మొర్త పీనుమ్‍లు సిలువల్‍తె తా గెలె గారు’ మెన, ‘బేగి మొర్తి చి అగ్గెయ్ ఉత్రవ వెంట గెలుక జయెదె’ మెన, యూదుల్‍చ వెల్లెల మాన్సుల్ పిలాతుతె గెచ్చ కెర, “సిలువల్‍తె గలిలసచ చట్టొ బగయ్‍తు, చి పీనుమ్‍ల్‍క ఉత్రవ దా బేగి వెంట గెల్తు” మెన సెలవ్ నఙిల, చి పిలాతు సెలవ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","జాకయ్, సయ్‍న్యుమ్ సుదల్ గెచ్చ కెర, తొలితొ ఎక్కిలొచ పడ్తొ అన్నెక్లొచ, యేసు తెన్ బెద సిలువల్‍తె గలిల దొగుల చోర్లుచ చట్టొ బగవ గెల. ");
INSERT INTO key_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","గని, యేసుతె అయ్‍లె, ‘నాయ్, అగ్గెయి మొర గెచ్చ అస్సె’ మెన దెక, జోక చట్టొ బగయితి నాయ్. ");
INSERT INTO key_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","గని, జోవయింతె ఎక్కిలొ యేసుక ఈంటె తెన్ పక్కయ్ బూసిలన్. బూసిల్ బేగి, లొఁయి కి పాని కి సూఁయి జలి. ");
INSERT INTO key_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","తుమ్ ఈంజ సదు కెర్తస కి సూన్‍తస కి, తుమ్‍క ‘జేఁవ్ కి పూర్తి నంపజతు’ మెనయ్ జా ఎత్కి దెకిలొసొ జోచి సాచి సంగ అస్సె. జో సంగిలి సాచి సత్తిమ్, చి ‘సత్తిమ్’ మెన జో కచితుమ్ జానె. ");
INSERT INTO key_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ఈంజ కిచ్చొక ఇసి జర్గు జలి మెలె, ఇన్నెతెన్ దేముడు పూర్గుమ్ రెగ్డయ్‍లి కోడు నెరవెర్సుప జలి. “జో అర్పితుమ్ జలొసొతె కేన్ ఆడు కి బగయితి నాయ్” మెన రెగిడ్లి కోడు, చి ");
INSERT INTO key_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","“జేఁవ్ బూసిలొసొక జేఁవ్ దెక ఉచరుల” మెన అన్నెక్ కోడు అస్సె. ");
INSERT INTO key_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","యూదుల్‍చ వెల్లెల మాన్సుల్‍తె ఎక్కిలొ, అరిమతయ్ మెలి గఁవ్విచొ యోసేపు మెలొసొ, జో, జలె, యేసుచ సిస్సుడు, గని అన్నె వెల్లెల మాన్సుల్‍క బియఁ కెర, ఎదార్దుమ్ ఒప్పనె నాయ్. లుంకచోరు యేసుక సిస్సుడ్ రితొ జా అస్సె. జో, జలె, అప్పె పుర్రె జా పిలాతుతె గెచ్చ కెర, “యేసుచి పీనుమ్ కావలె. దెర గెచ్చుమ్‍దే” మెన సంగితికయ్, పిలాతు సెలవ్ దిలొ, చి పీనుమ్ దెర గెచ్చుక మెన, సిలువ తిలిస్‍తె అయ్‍లొ. ");
INSERT INTO key_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","అన్నెక్లొ కి అయ్‍లొ. కొన్సొ మెలె, నీకొదేమొ మెలొ పరిసయ్యుడు. యేసుచి బోదన సూనుక మెన, ఒగ్గర్ అగ్గెయ్ రాతి, లుంకచోరు యేసుతె జా తిలొసొ జొయ్యి. జో, జలె, అప్పె ఒగ్గర్ విలువ తిలి వాసెన సామన్ దెరన అయ్‍లొ. జా వాసెన సామన్ కెద్ది జాడుచి మెలె, పాసి పాసి యాబయ్ కేజిల్ చి జాడు. ");
INSERT INTO key_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","జేఁవ్ దొగుల, జలె, యూదుల్ కెర్తి అలవాట్ కెర, వెల్లొ గండల్ విలువ బట్ట తెన్ జా వాసెన సామన్ బెదవ బెదవ, పీనుమ్‍క గుడియవ బందిల. పీనుమ్‍క దస్సి తెయార్ కెర మెస్నె వయ నిల. ");
INSERT INTO key_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","యేసుక సిలువతె గలిలి టాన్‍చి పాసి, జలె, ఏక్ తోట అస్సె. జా తోటతె సాప్రయ్ డొల్మి కెర్లి గది తిలి రితి నొవి మెస్సున్ అస్సె. కక్క నే రోవిలిసి. ");
INSERT INTO key_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","సెలవ్ కడన్లి దీసిక చి పండుగు దీసిక జా దీసి తెయార్ జతి దీసి రిసొ ‘దూరి వయుక గారు’ మెన యూదుల్ సంగులచి రిసొ, జా మెస్సున్ పాసి తతికయ్, యేసుచి పీనుమ్ ఒత్తయ్ తెడి ఎంగ్డవ దిల. ");
INSERT INTO key_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","యేసుక విరోదుమ్ సుదల్ మార తిర్రత్‍క, అయ్‍తర్ దీసి పెందలె, మగ్దల పట్నుమ్‍చి మరియ మెస్నె అయ్‍లి. అయ్‍లె, కిచ్చొ దెకిలి మెలె, సాప్రయ్ డొల్మి కెర్లి మెస్సున్‍క డంక తిలొ పత్తురు కీసి గే ఒస్సుల్ జా అస్సె. ");
INSERT INTO key_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ఇసి జా అస్సె మెన దెక, బమ్మ జా, సీమోను పేతురు చి యేసు ఒగ్గర్ ప్రేమ కెర్లొ జో అన్నెక్లొ సిస్సుడు దొగుల ఎక్కితె తిలిస్‍తె మరియ నిగ గెచ్చ, “యేసు ప్రబుచొ పీనుమ్ మెస్సున్ తెంతొ ఉక్లన అస్తి, చి జోక కేనె అన్నె ముల దా అస్తి గే నేనుమ్” మెన జోవయింక సంగిలి. ");
INSERT INTO key_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","జా మరియ దస్సి సంగితికయ్, పేతురు, జో అన్నెక్లొ సిస్సుడు మెస్నె గెచ్చుక మెన బార్ జల. ");
INSERT INTO key_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","జేఁవ్ దొగుల నిగ గెలె, జో అన్నెక్లొ సిస్సుడు బేగి నిగ, పేతురుచి కంట తొలితొ మెస్నె పాఁవిలన్. ");
INSERT INTO key_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ఈంజొ తొలితొ పాఁవ, వంపొ జా తెడి ఒయర దెకిలె, రితయ్ బట్ట గండల్ ఒత్త సేడ అస్తి మెన దెకిలన్, గని తెడి పెసె నాయ్. ");
INSERT INTO key_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","తెదొడి, జోవయించి పడ్తొ సీమోను పేతురు నిగ జా పాఁవిలన్, చి మెస్సున్ తెడిక పెసిలన్. రితయ్ బట్ట గండల్ ఒత్త సేడ అస్సె. ");
INSERT INTO key_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","చి జేఁవ్ గండల్‍క ఇదిల్ దూరిక, యేసుచి బోడి బంద తిలి బట్ట గండ, గుడియయ్ జలి రితి జా, అఙ సేడ అస్సె. ");
INSERT INTO key_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","తెదొడి, జో అన్నెక్లొ సిస్సుడు కి, మెలె, మెస్నె తొలితొ పాఁవిలొసొ, మెస్సున్ తెడి పెస దెక, యేసుక ‘జీవ్ జా ఉట్ట అస్సె’ మెన, నంపజలన్. ");
INSERT INTO key_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","యేసుక “మొర జీవ్ జా ఉట్టుక అస్సె” మెన అగ్గెయ్ తెంతొ దేముడు రెగ్డవ తిలిసి సిస్సుల్ తెదొడి ఉచార అర్దుమ్ కెరనుక నేతయ్. ");
INSERT INTO key_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","జలె, దెక కెర, యేసుక ‘జీవ్ జా ఉట్ట అస్సె’ మెన నంపజా, జేఁవ్ దొగుల సిస్సుల్ జోవయించ గెరలె ఉట్ట గెల. ");
INSERT INTO key_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","మదెనె మగ్దల పట్నుమ్‍చి మరియ, ఏడ ఏడ మెస్నెచి బయిలె టీఁవ అస్సె. తెదొడి, ఏడ ఏడ, మెస్నెచి తెడి ఒయర్తి రిసొ వంపొ జలి. ");
INSERT INTO key_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ఒయర్లె, కిచ్చొ దెకిలి మెలె, చొక్కిల పాలల్ గలన తిల దొగుల దూతల్ యేసుచి పీనుమ్ అగ్గె ఎంగ్డ తిలిస్‍తె దెకిలి. యేసుచి బోడి అగ్గె తిలిస్‍తె ఎక్కిలొ, చట్టొ అగ్గె తిలిస్‍తె ఎక్కిలొ వెస అస్తి. ");
INSERT INTO key_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ఈంజేఁవ్ జాక “అమ్మ, కిచ్చొక ఏడ్తసి?” మెన సంగిల. చి జా జోవయింక “అంచొ ప్రబుక దెర గెచ్చ అస్తి, చి జోక కేనె అన్నె ముల దా అస్తి గే నేని” మెన సంగిలి. ");
INSERT INTO key_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","దస్సి మెన సంగ, కీసిగె పడ్తొ పసిలి, చి యేసు ఒత్తయ్ టీఁవ తిలిసి దెకిలి. గని ‘జొయ్యి’ మెన చినుక నెత్ర గెలి. ");
INSERT INTO key_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","యేసు జలె, జాక “అమ్మ, కిచ్చొక ఏడ్తసి? కక్క చజితసి?” మెన సంగిలన్. జా, జోక ‘తోట రూకుల్ పోస్తొసొ’ మెన ఉచర, జోక “బాబు, తూయి జలెకు జోక ఉక్కుల వేరతె నిలది జలె, జోక కేనె ముల దా అస్సిస్ గే, అంక సంగు, చి ఆఁవ్ జోచి పీనుమ్ దెర గెచ్చ రోవిందె” మెన సంగిలి. సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","యేసు జాక “మరియ!” మెన, ఎక్కి జాచి నావ్ సంగిలన్. సంగిల్ బేగి జా, జోక చిన పసుల, “రబ్బోనీ!” మెన సంగిలి. అరమయ్ బాసతె ‘రబ్బోనీ’ మెలె, ‘గురు’ మెలి అర్దుమ్ తయెదె. ");
INSERT INTO key_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","యేసు, జలె, జాక, “అంక చడు నాయ్. ఆఁవ్ అన్నె దేముడు అబ్బొతె వెగ గెచ్చుక నేతయ్. గని, తుయి కిచ్చొ కెరుక జయెదె మెలె, అంచ బావుడ్లు జల అంచ సిస్సుల్‍తె గో, చి పరలోకుమ్ తిలొ తుమ్‍చొ దేముడు తుమ్‍చొ అబ్బొది జలొ అంచొ దేముడు అంచొ అబ్బొతె ఆఁవ్ ఉట్ట గెతసి మెన యేసుప్రబు సంగిలన్ మెన సంగు” మెన, జాచి అత్తి జోచ సిస్సుల్‍క కబుర్ తెద్రయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","జాకయ్, మగ్దల పట్నుమ్‍చి జా మరియ, యేసుచ సిస్సుల్‍తె గెచ్చ, “యేసుప్రబుక దెక అస్సి!” మెన సంగ, జో సంగిలి కబుర్ ఎత్కి జోవయింక సంగిలి. ");
INSERT INTO key_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","జా దీసి సంజె, సత్తరెక్క తొల్లి దీసి, మెలె యేసు జీవ్ జలి జా అయ్‍తర్ దీసి సంజె, సిస్సుల్ ఎక్కితె బెర తిల. గని యూదుల్‍చ వెల్లెల మాన్సుల్‍క బియఁ కెర, కెవ్డివొ డంపన లుంకిల్ రితి తిల. జేఁవ్ దస్సి బిలి రితి జా ఒత్త కెవ్డివొ డంపన తతికయ్, యేసు జా కెర, జోవయించి నెడిమి టీఁవ, “తుమ్‍క సేంతుమ్ తవుసు!” మెన ఉంక్రయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","దస్సి ఉంక్రవ కెర, ‘అఁవ్వి’ మెన దెకయ్‍తి రిసొ, సిలువతె గలిలి పొది మేకుల్ అత్తితె పెట్లిస్‍చి మచ్చల్, పక్కయ్ బూసిలిస్‍చి మచ్చ, జోవయింక దెకయ్‍లన్, చి జేఁవ్, ‘యేసుప్రబు’ మెన జోక చిన, సర్దసంతోసుమ్ జల. ");
INSERT INTO key_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","యేసు, జలె, జోవయింక అన్నె, “అంచి సేంతుమ్ తుమ్‍చి పెట్టి తవుసు. పరలోకుమ్ తిలొ దేముడు అబ్బొ ఈంజ లోకుమ్‍తె అంక కీసి తెద్రయ్‍లన్ గే, దస్సి ఈంజ లోకుమ్‍చ మాన్సుల్‍తె తుమ్‍క ఆఁవ్ తెద్రయ్‍తసి” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ఇసి సంగ కెర, జోవయించి ఉప్పిరి పుఙ దా, “దేముడుచి సుద్ది తిలి ఆత్మ తుమ్‍క ఆఁవ్ దెతసి. నఙనా. ");
INSERT INTO key_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","కచ పాపల్ తుమ్ చెమించుప కెర్తె గే, చెమించుప జా అస్తి. కచ పాపల్ చెమించుప నే జతి రితి తుమ్ కెర్తె గే, జా పాపుమ్ జోవయింక తయెదె” మెన సంగ యేసు ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","యేసు జా సుట్టు సిస్సుల్‍క డీసిలిసి, జలె, ‘కల్వల్‍తె జెర్మిలొసొ’ మెన ఆసిమ్ నావ్ తిలొ తోమా మెలొసొ ఒత్త నాయ్. ");
INSERT INTO key_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","చి జో తెన్ దస్సుల్ జలి పొది “యేసుప్రబుక దెకిలమ్!” మెన తిల సిస్సుల్ సంగిల. గని, తోమా జోవయింక, “జో జీవ్ జా తిలె, అంక రుజ్జు దెకాయితు. జోచ అత్తొతె దెకిలె, ఒత్త మేకుల్ పెట్ల మచ్చల్ తిలెకయ్, జేఁవ్ మచ్చల్ ఆఁవ్ చడ దెకిలెకయ్, పడ్తొ జేఁవ్ జోక పక్కయ్ బూసిలిస్ తెడి ఆఁవ్ సొంత ఆతు గల దెకిలెకయ్, ‘జొయ్యి’ మెన నంపజయిందె” మెలన్. ");
INSERT INTO key_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","జలె, ఒత్త తెంతొ అన్నె అట్టు పొదుల్ గెతికయ్, యేసుచ సిస్సుల్ జా గెరి అన్నె అస్తి. గని, ఈంజ సుటు తోమా కి జోవయింతెన్ అస్సె. జా సుట్టుచి రితి జేఁవ్ కెవ్డివొ డంపన తిలె కి, యేసు జా జోవయించి నెడిమి టీఁవ, జోవయింక “తుమ్‍క సేంతుమ్ తవుసు!” మెన ఉంక్రయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","తెదొడి, తోమాక దెక, “తుచి ఊంటి చంప కెర, అంచ అత్తొ చడ దెకు! తుచి ఆతు చంప కెర, అంచి పక్కయ్ బూసిలిస్‍చి తెడి గల దెకు! అన్మానుమ్ జా నాయ్. నంపజా దయిరిమ్ జా!” మెన, యేసు జోక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","తోమా సర్దసంతోసుమ్ జా, “అంచొ ప్రబు, అంచొ దేముడు!” మెన పూర్తి నముకుమ్ జా సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","జాకయ్ యేసు జోక, “అంక దెకిలి రిసొ తుయి నంపజలది. అంక నే దెకిలెకి కో అంక నంపజవుల గే, జోక చెంగిలి!” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ఇన్నె రెగిడ్లసచి కంట, జోచి అదికారుమ్ దెకయ్‍త వెల్లెల కమొ ఒగ్గరి యేసు జోచ సిస్సుల్‍చి మొక్మె కెర్లన్, గని మొత్తుమ్‍తె ఎత్లయి రెగ్డ అస్సి. ");
INSERT INTO key_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ఈంజేఁవ్, జలె, కిచ్చొక రెగ్డ అస్సి మెలె, యేసుక ‘నిజుమి దేముడు తెద్రయ్‍లొ రచ్చించుప కెర్తొసొ క్రీస్తు జో’ మెన తుమ్‍క ‘నంపజతు’ మెనయ్ రెగ్డ అస్సి. తూమ్ కి సదు కెర్తస సూన్‍తస నంపజలె, తూమ్ కి యేసుప్రబుచి దయచి రిసొ జోచి జీవ్‍క జిఁయ, పరలోకుమ్‍చి రాజిమ్‍తె బెదితె. ");
INSERT INTO key_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","యేసు సిస్సుల్‍క డీస అన్నె సగుమ్ దీసల్ గెలి పడ్తొ, తిబెరియ సముద్రుమ్‍తె, మెలె గలిలయతెచి సముద్రుమ్ రితి గడ్డె, జోచ సిస్సుల్ సగుమ్‍జిన్ తతికయ్, యేసు జోవయింక అన్నె డీస జో జీవ్ జలిస్‍క జోచి అదికారుమ్‍క రుజ్జు దెకయ్‍లన్. ఇసి జర్గు జలి. ");
INSERT INTO key_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ఏక్ దీసి, సీమోను పేతురు, ‘కల్వల్‍తె జెర్మిలొసొ’ మెన ఆసిమ్ నావ్ తిలొ తోమా, జా గలిలయ ప్రాంతుమ్‍చి కానా గఁవ్విచొ నతనియేలు, జెబెదయి మెలొసొచ దొగుల పుత్తర్సుల్, చి అన్నె దొగుల సిస్సుల్, మొత్తుమ్ సత్తుజిన్, ఎక్కితె తిల, చి ");
INSERT INTO key_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","“ఆఁవ్ మొస్స దెరుక గెతసి” మెన సీమోను పేతురు సంగ బార్ జంక దెర్తికయ్, తిల సిస్సుల్ “ఆమ్ కి బెద జెమ్‍దె!” మెన సంగిల. జేఁవ్ ఎత్కిజిన్ బార్ జా, జోవయించి దోనితె వెగ, మొస్స దెరుక గెల. గని జయి రాతి ఎక్కి మొస్సొ కి దెర్తి నాయ్. ");
INSERT INTO key_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","గని, రాత్ పయితె తతికయ్, ఒత్త ఒడ్డుతె యేసు టీఁవ అస్సె. గని ‘యేసు’ మెన సిస్సుల్ చినితి నాయ్. ");
INSERT INTO key_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","జో, జలె, జోవయింక కేక్ గల, “ఓ గోతుసుదల్, మొస్స దెర అస్సుస్ గే?” మెన పుసిలన్. చి “నాయ్, బాబు, కిచ్చొయ్ నాయ్!” మెన జబాబ్ దా కేక్ గల. ");
INSERT INTO key_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","యేసు, జలె, జోవయింక కిచ్చొ సంగిలన్ మెలె, “దోనిచి ఉజెతొ పక్కయ్ వల గల, చి దొర్కు జవుల!” మెన కేక్ గలన్, చి జో సంగిల్ రితి జయ్యి పక్క వల గలిల. గలిలె, ఎత్తివాట్ మొస్స బెర తిలి రిసొ వల కడుక నెతిర్ల. ");
INSERT INTO key_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","దస్సి జతికయ్, యేసు ఒగ్గర్ ప్రేమ కెర్లొ సిస్సుడు జోక చిన కెర, “అమ్‍చొ యేసుప్రబు, జో!” మెన పేతురుక సంగిలన్. జోక ‘అమ్‍చొ యేసుప్రబు’ మెన సీమోను పేతురు సూన్లి బేగి, కామ్‍చి రిసొ జో కడ తిలి సొక్క అన్నె గలన, సముద్రుమ్‍తె డేఁవ, యేసుతె గెలన్. ");
INSERT INTO key_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","గని, తిల సిస్సుల్ దోనితె తా, మొస్స బెర తిలి వల ఒర్గొడ ఆన, పడ్తొ అయ్‍ల. ఒగ్గర్ దూరి జెంక నాయ్. ఒడ్డు తెంతొ పాసి పాసి ఎక్కి పుంజెక్ గజాలు దూరి తిల. ");
INSERT INTO key_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","జలె, ఒడ్డుతె అయ్‍లె కిచ్చొ దెకిల మెలె, ఒత్త మెసి బొగుల్‍చి ఆగి తిలి, చి ఆగితె మొస్స సిజితె తిల. పోడియొ కి తిల. ");
INSERT INTO key_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","తెదొడి యేసు జోవయింక “తుమ్ అప్పె దెర్ల మొస్స సగుమ్ ఆన” మెలన్, ");
INSERT INTO key_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","చి సీమోను పేతురు దోనితె అన్నె వెగ, వల ఒడ్డుతె ఒర్గొడ ఆన్లన్. ఆన్లె, వెల్లెల మొస్స బెరయ్ అస్తి. కెత్తి మెలె, పుంజెక్ యాబయ్ తిన్ని వెల్లెల మొస్స. గని, ఎత్తివాట్ తిలె కి, వల చిరి జయె నాయ్. ");
INSERT INTO key_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","“అల్లె, కంక జా,” మెన యేసు సిస్సుల్‍క బుకార్లన్. జేఁవ్ సిస్సుల్‍తె జలె, “తుయి కో?” మెన కో కి జోక పుసుక దయిరిమ్ నాయ్. జోక ‘యేసుప్రబు’ మెన జాన్‍తి. ");
INSERT INTO key_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","జేఁవ్ దస్సి ఇదిల్ బితె తతికయ్, యేసు పుర్రె జా, పోడియొ వెంట, వంట దిలన్. దస్సి మొస్స కి వెంట, వంట దిలన్. ");
INSERT INTO key_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","యేసు మొర జీవ్ జా ఉట్ట సిస్సుల్‍క డీసిలిసి ఇన్నెతెన్ తివ్వెర్ జలి. ");
INSERT INTO key_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","జేఁవ్ అన్నిమ్ కెర కేడయ్‍లి పడ్తొ, సీమోను పేతురుక యేసు బుకారా, ఇదిల్ దూరి కడన, జోక ఇసి మెలన్. “ఓ సీమోను, యోహానుచొ పుత్తుసి, ఇన్నెచి కంట అంక తుయి ఒగ్గర్ ప్రేమ కెర్తసి గే?” మెన పుసిలన్. పుసిలె, పేతురు “ఒయ్యి, ప్రబు, ఆఁవ్ తుక ప్రేమ కెర్తిసి తుయి జాన్సి” మెలన్. యేసు జోక “దస్సి జలె, విలువ జల మెండ పిల్లల్‍క చెంగిల్ అన్నిమ్ గొవుడు దొర్కు కెర్తె తతి రితి తా!” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","పడ్తొ అన్నెక్ సుట్టు, “ఓ సీమోను, యోహానుచొ పుత్తుసి, అంక ప్రేమ కెర్తసి గే?” మెన పుసిలన్. పుసిలె, పేతురు జోక అన్నె, “ఒయ్యి, ప్రబు, ఆఁవ్ తుక ప్రేమ కెర్తిసి తుయి జాన్సి” మెన సంగిలన్. యేసు జోక అన్నె, “దస్సి జలె, విలువ జల మెండల్‍క చెంగిల్ రకిత్ రితి తుయి దెకితె తా!” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","తెదొడి అన్నెక్ సుట్టు కి, పేతురుక యేసు పుసిలన్. “ఓ సీమోను, యోహానుచొ పుత్తుసి, అంక ప్రేమ కెర్తసి గే?” మెన అన్నె పుసితికయ్, ‘అంక ప్రేమ కెర్తసి గె?’ మెన యేసు పుసిలిసి అప్పె తివ్వెర్ జలి రిసొ, పేతురు మెన్సు ఒగ్గర్ దుకుమ్ జలన్, చి “ప్రబు, తుయి ఎత్కి జాన్సి. ఆఁవ్ తుక ప్రేమ కెర్తిసి తుయి దెకితసి!” మెన అన్నె సంగిలన్, చి యేసు జోక “విలువ జల మెండల్‍క సరి జతి అన్నిమ్ దొర్కు కెర్లి రితి తుయి తా. ");
INSERT INTO key_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“తుక ఆఁవ్ అన్నె కిచ్చొ కచితుమ్ సంగితసి మెలె, తుయి ఉబెడొబోద తిలి పొది, తుకయ్ తూయి తెయార్ కెరన, ఇస్టుమ్ అయ్‍లి రితి బుల్తె తిలది, గని తుయి మంత్రొ జలె పొది కీసి జస్తె మెలె, తుచ అత్తొ చంపొ కెర్తె, చి వేర సుదొ తుక తెయార్ కెరెదె. చి తుయి ఇస్టుమ్ నెంజిలిస్‍తె తుక వయ నెయెదె” మెన పేతురుక యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","కిచ్చొక దస్సి సంగిలన్ మెలె, పేతురు మంత్రొ జలె పొది, విరోదుమ్ సుదల్ జోక మారుల. దస్సి జయెదె మెలి గుర్తుకయ్ యేసు దస్సి మెలన్. జలె, ఒత్త తెంతొ యేసు పేతురుక, “అంచి పట్టి జే!” మెలన్. ");
INSERT INTO key_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","తెదొడి పేతురు పస్ల, యేసు ఒగ్గర్ ప్రేమ కెర్లొ సిస్సుడు జోచి పట్టి జెతిసి దెకిలన్. కక్క మెలె, యేసు సిస్సుల్ తెన్ ఆకర్ అన్నిమ్ కెర్లి పొది, యేసుచి గుండెతె పెల వెస తిలొ సిస్సుడు. జొయ్యి, జా సుట్టు ‘తుక విరోదుమ్ సుదల్‍తె దెర దెతొసొ కొన్సొ?’ మెన యేసుక పుస దిలన్. ");
INSERT INTO key_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","పేతురు, జలె, జో సిస్సుడుక దెక కెర, “ప్రబు, ఈంజొ మాన్సుక కిచ్చొ జయెదె?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","పుసితికయ్, యేసు జోక, “ఆఁవ్ దేముడు అబ్బొతె పరలోకుమ్‍తె గెచ్చ ఈంజ లోకుమ్‍తె అన్నె జెతె ఎదక ఈంజొ తాఁ గెచ్చుక అంచి ఇస్టుమ్ జలె, తుక కిచ్చొ బాద? అంచి పూచి, జా. తుచి పూచి కిచ్చొ మెలె, ఆఁవ్ తియార్లి కామ్ కెరుక. అంచి పట్టి జె!” మెలన్. ");
INSERT INTO key_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","జో అన్నెక్లొ సిస్సుడుచి రిసొ యేసు సంగిలి జా కోడుచి రిసొ సగుమ్‍జిన్ పడ్తొ కిచ్చొ సంగితె తిల మెలె, ‘ఈంజొ అన్నెక్లొ సిస్సుడు మొరె నాయ్’ మెంతె తిల. గని జో ‘మొరె నాయ్’ మెన యేసు సంగె నాయ్. ఎక్కి “ఆఁవ్ అన్నె జెతె ఎదక ఈంజొ తా గెచ్చుక అంచి ఇస్టుమ్ జలె, తుకయ్ కిచ్చొ బాద?” మెనయ్ సంగ తిలొ. ");
INSERT INTO key_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ఈంజ ఎత్కిచి రిసొ సాచి జలొసొ, ఈంజ ఎత్కిచి రిసొ రెగిడ్లొసొ కొన్సొ మెలె, జొయ్యి సిస్సుడు. యేసు ఒగ్గర్ ప్రేమ కెర్లొసొ. జోచి సాచి సత్తిమ్ మెన జానుమ్. ");
INSERT INTO key_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","యేసు కెర్ల కమొ అన్నె ఒగ్గర్ అస్తి. జేఁవ్ కమొ ఎత్కిచి రిసొ రెగుడుక జలె, జేఁవ్ కమొ ఎత్తివాట్ జవులచి రిసొ జోవయించి రిసొ రెగిడ్ల పుస్తకల్ ఈంజ బూలోకుమ్ దెరుక నెత్రె. తెద్దిలి.");
INSERT INTO key_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ఓ దెయొపిలా, ఆఁవ్ తొలితొ రెగిడ్లి పుస్తకుమ్‍తె కిచ్చొచి రిసొ రెగిడ్లయ్ గే జాన్సి. యేసు కెర్ల కమొ, యేసు కెర సికడ్లిసి రిసొ రెగిడ్లిసి. ");
INSERT INTO key_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","మొదొల్ తెంతొ, యేసు పరలోకుమ్‍తె తిలొ దేముడు జలొ అబ్బొస్‍తె అన్నె వెగ గెలి ఎదకచి రిసొ ఎత్కి జా పుస్తకుమ్‍తె రెగిడ్లయ్. పడ్తొ, జో దేముడు అబ్బొస్‍తె అన్నె వెగ నే గెతె అగ్గె, దేముడుచి సుద్ది తిలి ఆత్మ తెన్, జో అగ్గె నిసాన్ల సిస్సుల్‍క ఆడ్ర దా, జోచి సుబుమ్ కబుర్ కామ్ జేఁవ్ కెర్తి రిసొ, జో ఆగ్న దా తిలొ. ");
INSERT INTO key_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","జో మొర గెచ్చ అన్నె జీవ్ జలి పడ్తొ, జా అన్నెక్ దొన్ని విసొ పొదుల్‍చి తెడి, జో జోవయింక సగుమ్ సుట్లు డీసయ్ జా, జో అన్నె జీవ్ జలిస్‍క జోవయింక ఒగ్గర్ రుజ్జుల్ దెకవ, దేముడుచి రాజిమ్‍చి రిసొ జోవయింక అన్నె సికడ్తె తిలొ. ");
INSERT INTO key_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","జేఁవ్ దొన్ని విసొ పొదుల్‍చి తెడి ఏక్ సుట్టు, జోవయింతెన్ అన్నిమ్ కత్తె తా, జేఁవ్‍క కిచ్చొ ఆడ్ర దిలన్ మెలె, “తుమ్ కిచ్చొక రకుక మెలె, తుమ్ ఈంజ యెరూసలేమ్ పట్నుమ్ తెంతొ నే గెతె, ఇన్నె తా. అంచి రిసొ సూన్లిసి, అబ్బొ జలొ దేముడు తుమ్‍క దెయిందె మెన అగ్గె తెంతొ కోడు దిలిసి దొర్కు జతి ఎద రకితె తా. ");
INSERT INTO key_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","యోహాను జలె, అగ్గె పానితె మాన్సుల్‍క బాప్తిసుమ్ దెతె తిలొ, గని తుమ్‍క అప్పె కిచ్చొ జర్గు జయెదె మెలె, అన్నె ఒగ్గర్ దీసల్ నే గెతె అగ్గె, జా అమ్‍చి దేముడుచి సుద్ది తిలి ఆత్మతె తుమ్‍క బాప్తిసుమ్ దొర్కు జయెదె” మెన యేసు జోచ సిస్సుల్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","యేసు సిస్సుల్ తెన్ బెద తిలి పొది, జేఁవ్ జోక, “ప్రబువ, అప్పె జలె, తుచి తెడి అమ్‍క ఆమి ఏలుప కెరంతి రితి కెర, అమ్‍చి ఇస్రాయేల్ దేసిమ్‍క జోవయింక అన్నె దెస్తెగె?” మెన పుసిల. ");
INSERT INTO key_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","పుసితికయ్, జోక సిస్సుల్‍క, “కేన్ కాలుమ్‍క, కేన్ సమయుమ్‍క, కిచ్చొ జర్గు జంక అస్సె గే, మెన ఎత్కిచి ఉప్పిరి తిలొ దేముడు అబ్బొక అదికారుమ్‍తె తిఁయ అస్సె. ");
INSERT INTO key_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","దేముడుచి సుద్ది తిలి ఆత్మ తుమ్‍చి పెట్టి అయ్‍లి మెలె, తుమ్ సెక్తి జస్తె, అంచి రిసొ సాచి జతి రితి, తుమ్ యెరూసలేమ్ పట్నుమ్‍తె, ఈంజ ఒండి యూదయ ప్రదేసిమ్‍తె, పడ్తొ సమరయ ప్రదేసిమ్‍తె, పడ్తొ ఒండి లోకుమ్‍చ దూరి దేసిమ్‍లుతె కి సాచి దెకయ్‍తె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","యేసు ఇసి సంగ కేడయ్‍లి పడ్తొ, జేఁవ్ సిస్సుల్ దెకితె తతికయ్, జో పరలోకుమ్‍తె అన్నె గెచ్చుక మెన ఉక్కిల్ జలొ. జో వెగ గెతె తతికయ్, ఏక్ మబ్బు జోక లుంకడ్లి, చి సిస్సుల్ జోక అన్నె దెకుక నెతిర్ల. ");
INSERT INTO key_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","జో పరలోకుమ్‍తె వెగ గెతె తతికయ్, సిస్సుల్ ఆగాసుమ్ పక్క ఆచారిమ్ తెన్ దెకితె తతికయ్, ఆదె, చొక్కిల పాలల్ గలన తిల దేముడుచ దూతల్ దొగుల జోవయించి నెడిమి ఉత్ర జా టీఁవొజ జల, ");
INSERT INTO key_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“ఓ గలిలయ ప్రాంతుమ్‍చ మాన్సుల్, కిచ్చొక దస్సి ఆగాసుమ్ పక్క దెక దెక టీఁవొజ జా అస్సుస్? తుమ్‍చి నెడిమి తెంతొ ఉక్కిల్ జా పరలోకుమ్‍తె వెగ గెలొ ఈంజొ యేసు, పడ్తొక అన్నె ఉత్ర జెయెదె. జో కీసి పరలోకుమ్‍తె వెగ గెలొ గే దెకిల్ రితి, దస్సెయి అన్నె ఉత్ర జెయెదె” మెన జేఁవ్‍క సంగిల. ");
INSERT INTO key_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","తెదొడి జేఁవ్ జా ఒలీవ మెట్ట తెంతొ ఉత్ర జా, యేసుచ సిస్సుల్ యెరూసలేమ్ పట్నుమ్‍తె ఉట్ట అయ్‍ల. మెట్టక పట్నుమ్ పాసి తయెదె. కెద్ది దూరి మెలె, సెలవ్ కడన్లి దీసి యూదుల్ ఇండితి ఎదిలి దూరి. ");
INSERT INTO key_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","పట్నుమ్‍తె పాఁవ కేనె గెల మెలె, జేఁవ్ సంగ తిలొ ఒత్తచొ గేరుచి అంతస్తుమ్‍తెచి గదితె గెల. కొన్స మెలె, పేతురు, యోహాను, యాకోబు, అంద్రెయ, పిలిప్, తోమా, బర్తొలొమయి, మత్తయి, అల్పయిచొ యాకోబు మెలొ పుత్తుస్, పడ్తొ సొంత దేసిమ్ ఏలుప కెరంతి ఆస తిలి మందతె తిలొ సీమోను, పడ్తొ యాకోబు మెలొ ఎక్కిలొచొ పుత్తుస్ మెలొ యూదా; మొత్తుమ్ ఎగరజిన్ సిస్సుల్. ");
INSERT INTO key_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","జో గెరి తా కిచ్చొ ఎక్కి నిదానుమ్ కెర్తె తిల మెలె, ప్రార్దన కెర్తె తిల. ప్రార్దన కెరుక మెన జోవయింతెన్ అన్నె కో కో జేఁవ్ పొదులె బెదితె తిల మెలె, యేసుచి అయ్యసి మరియ తెన్, జోక బావుడ్సివొ, జోవయింక అన్నె నంపజల తేర్‍బోదల్ తిల. ");
INSERT INTO key_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","జేఁవ్ దస్సి ప్రార్దన కెర్తె తిల పొదులె, ఏక్ దీసి, రమారమి సొవు విస్సొజిన్ మాన్సుల్ ఒత్త బెర తతికయ్, జేఁవ్ ప్రబుక నంపజలసచి నెడిమి పేతురు టీఁవొజ జా, ఇసి మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“ఓ బావుడ్లు, అమ్‍చొ యేసుక జేలి కెర్క దెరవ దిలొ యూదాచి రిసొ, దేముడుచి సుద్ది తిలి ఆత్మ సికయ్‍తికయ్, దావీదు మెలొ పూర్గుమ్‍చొచి అత్తి సంగిలిసి కోడు జా, కచితుమ్ నెరవెర్సుప జంక అస్సె. జాకయ్, యూదాచి రిసొ సంగిల్ రితి నెరవెర్సుప జలి. ");
INSERT INTO key_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","మెలె, యూదా అమ్‍చి తెన్ యేసు నిసాన్లొసొ జలొ, చి ఆమ్ కెర్తి సేవతె జో బెదుక ప్రబు సెలవ్ దా తిలొ.” ");
INSERT INTO key_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","మదెనె యూదాక కిచ్చొ జర్గు జలి మెలె, జో యేసుక విక పాపుమ్ కెర్లి డబ్బుల్ తెన్ బుఁయి గెన్లొ. జా బుఁయి తిలిస్‍తె సేడ గెలన్, చి పెట్టి బద్దల్ జతికయ్, పెట్టిచి అంతున్ ఎత్కి సూఁయి జా గెలి. ");
INSERT INTO key_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","యెరూసలేమ్ పట్నుమ్‍చ మాన్సుల్ ఎత్కిజిన్ జాన్లి దీసి తెంతొ, జా బుఁయిక ‘అకెల్‍దామ’ మెన జోవయించి అరమయ్ బాస తెన్ సంగితతి. జా నావ్‌చి అర్దుమ్ కిచ్చొ మెలె, ‘లొఁయి సూఁయి జా తిలి బుఁయి’. ");
INSERT INTO key_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","జాకయ్ యూదాక జర్గు జలిసి తెన్, కీర్తన పుస్తకుమ్‍తె రెగిడ్లి కోడు నెరవెర్సుప జలి. “జోవయించి టాన్ పాడ్ జలి బయిలు రితి జవుస్, చి ఒత్త తెంతొ కో ఒత్త జితు నాయ్” మెన రెగ్డ అస్సె. అన్నెక్ కోడు కి రెగ్డ అస్సె. కేన్ కోడు మెలె, “జోవయింక దా తిలి టాన్ జోవయింక పిట్టుస్, చి వేర మాన్సుక దొర్కు జవుస్.” మెన రెగిడ్లిసి మెన, బెర తిలసక పేతురు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","అన్నె కిచ్చొ మెలన్ మెలె, “జా కోడుచి రిసొ, యేసుప్రబు అన్నె జీవ్ జా ఉట్లిస్‍క అమ్‍చి తెన్ సాచి జా జోచి గవురుమ్ దెకయ్‍తి రిసొ, అన్నెక్లొ అమ్‍చి తెన్ బెదుక అస్సె. కొన్సొ మెలె, యోహాను బాప్తిసుమ్ దెతె తిలి, యేసుప్రబు అమ్‍చి తెన్ ఈంజ లోకుమ్‍తె బుల్తె తిలి మొదొల్ తెంతొ, యేసు పరలోకుమ్‍తె వెగ గెలి ఎదక అమ్‍చి తెన్ బుల్తె తిలొసొ ఎక్కిలొ అమ్‍చి తెన్ బెదుక అస్సె” మెన పేతురు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","సంగితికయ్, జేఁవ్‍తె తిల దొగులక టీఁవొజ కెల. జేఁవ్ దొగుల కొన్స మెలె, ‘బర్సబా’ మెన ఆసిమ్ నావ్ తిలొ యోసేపు మెలొ యూస్తు మెలొ ఎక్కిలొ, చి మత్తీయ మెలొ అన్నెక్లొ. ");
INSERT INTO key_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","జేఁవ్ దొగులతె ప్రబు కక్క నిసాన్‍దె గే, జానుక జతి రిసొ, సిస్సుల్ ప్రార్దన కెర్ల. “ఓ ప్రబు, మాన్సుచి పెట్టి తిలి బుద్ది ఎత్కి తుయ్ జాన్సి. ");
INSERT INTO key_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","తుయి దిలి సేవ, తుచొ బారికి జతి తుయి దిలి టాన్, యూదా నిస్కారుమ్ కెర్లి రితి జా నెస కెర, జోచి టాన్‍తె జో గెచ్చ అస్సె. జోక తుయి దా తిలి కామ్ కెర్తి రిసొ, ఈంజేఁవ్ దొగులతె కక్క నిసాన అస్సిస్ గే, దయ కెర అమ్‍క రుజ్జు దెకవు” మెన ప్రార్దన కెర్ల. ");
INSERT INTO key_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ప్రార్దన కెర, చీటి గల్తిక మత్తీయచి నావ్ సేడ్లి. జా రుజ్జు జతికయ్, ‘అమ్‍చి తెన్ ప్రబుచొ బారికి జవుస్’ మెన, ప్రబుచి సుబుమ్ కబుర్ సూనయ్‍త ఎగరజిన్ బారికుల్ జో మత్తీయక బెదవన్ల, చి బారజిన్ అన్నె జా గెల. ");
INSERT INTO key_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","యేసు మొర అన్నె జీవ్ జా ఉట్ట సత్తు సంతల్ గెతికయ్, ‘పెంతెకొస్తు’ మెన యూదుల్‍చి పండుగు దీసి, యేసుక నంపజలస ఎత్కిజిన్ ఎక్కితె బెద అయ్‍ల. ");
INSERT INTO key_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","జేఁవ్ ఒత్త ఎక్కితె బెద తతికయ్, ఆగాసుమ్ పక్క తెంతొ, వెల్లొ వాదు గట్టిఙ వీర్తి రితి వెల్లి అవాడ్ అయ్‍లి, చి గేర్ ఒండి జా అవాడ్ సప్పుడు బెర్లి. ");
INSERT INTO key_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","తెదొడి, కిచ్చొ దెకిల మెలె, ఆగి లగితి రితిసి డీస ఉత్ర జా చెదుర్ప జా, జోవయింక ఎక్కెక్లచ బోడివొచి ఉప్పిరి ఆగివొ లగిల్ రితి జలి. జోవయింతె కక్క నే పిట్తె దస్సి జలి. ");
INSERT INTO key_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","దస్సి జతికయ్, కక్క నే పిట్తె, దేముడుచి సుద్ది తిలి ఆత్మసెక్తి జోవయించి పెట్టి బెర అయ్‍లి, చి జోవయించి ఆత్మచి సెక్తి తెన్ దొర్కు జలి ఎదిలి, వేర వేర అగ్గె నేన్ల బాసల్ తెన్ జేఁవ్ లట్టబుక దెర్ల. ");
INSERT INTO key_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","జేఁవ్ పొదులె, ఒగ్గర్ ఒగ్గర్ దేసిమ్‍లుతె చెదుర్ప జా తిల దేముడుక నిదానుమ్ తెన్ జొకర్త యూదుల్ అన్నె ఉట్ట జా యెరూసలేమ్ పట్నుమ్‍తె జితె తిల. ");
INSERT INTO key_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","జలె, యేసుక నంపజలసచి పెట్టి అబ్బొస్‍చి జోచి ఆత్మ బెర్లి జా అవాడ్ సూన, కేనె కేనె తెంతొ నిగ జా, ఒగ్గర్‍జిన్ జేఁవ్ యూదుల్ జా గెరి అయ్‍ల. అయ్‍లె, ఆచారిమ్ జల. కిచ్చొక మెలె, జోవయించ సొంత వేర వేర బాసల్ తెన్ యేసుచ సిస్సుల్ లట్టబ్తె తిల; జేఁవ్ బాసల్ కెఁయ నే సిక తిలె కి, ");
INSERT INTO key_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ఆచారిమ్ జా ఎక్కిలొక ఎక్కిలొ, “వేర వేర అమ్‍చ సొంత బాసల్ తెన్ ఈంజేఁవ్ లట్టబ్తస గలిలయులు జవుల గెద? ");
INSERT INTO key_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","అమ్‍చ బాసల్ నేన్‍తి దస్సి జలె, కీసి జా అమ్‍చ బాసల్ తెన్ లట్టబ్‍తతి” మెన జేఁవ్ ఆచారిమ్ సంగితె తిల. ");
INSERT INTO key_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","“ఆమ్ పార్తీ దేసిమ్‍చ, మాదీయులు, ఏలామియుల్, పడ్తొ మెసొపొతమియ తెంతొ చి, యూదయ తెంతొచ, కప్పదొకియ తెంతొచ, పొంతు తెంతొచ, ఆసియా తెంతొచ, ");
INSERT INTO key_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ప్రుగియ తెంతొచ, పంపూలియా తెంతొచ, ఐగుప్తు దేసిమ్‍చ, పడ్తొ కురేనియు పట్నుమ్‍చి సుట్టునంత తిలి లిబియ దేసిమ్ తెంతొచ. పడ్తొ అన్నె కి అమ్‍తె సగుమ్‍జిన్ రోమ్ దేసిమ్ తెంతొ ఆజి కాలి ఉట్ట జా అస్తి. జోవయింతె సగుమ్‍జిన్ యూదుల్ జెర్మిలస. సగుమ్‍జిన్ అగ్గె యూదుల్ నెంజిలె కి, దేముడుక నంపజా మార్సుప కెరన్లస కి అస్తి. ");
INSERT INTO key_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","పడ్తొ, క్రేతు దేసిమ్‍చ, అరేబియ దేసిమ్‍చ కి ఇన్నె అస్తి. ఆమ్ ఎత్తివాట్ దేసిమ్‍లు తెంతొ ఉట్ట అయ్‍లె కి, అమ్‍చ సొంత బాసల్ తెన్ ఈంజేఁవ్ లట్టబ, ఈంజెఁవు దేముడుచ ఆచారిమ్‍చ కమొ అమ్‍క సూనయ్‍తతి!” ");
INSERT INTO key_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","జోవయించి ఆచారిమ్‍చి రిసొ అన్నె కిచ్చొ మెన ఎక్కిలొక ఎక్కిలొ సంగితె తిల మెలె, “అప్పె జర్గు జలిస్‍చి అర్దుమ్ కిచ్చొ?” మెన పుసుక దెర్ల. ");
INSERT INTO key_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","గని ఒత్త బెర అయ్‍లసతె అన్మానుమ్ జల మాన్సుల్ సగుమ్‍జిన్ కి తిల, జేఁవ్ కిచ్చొ మెల మెలె, “ఈంజేఁవ్ మచ్చ అస్తి” మెన జేఁవ్‍చి రిసొ ఆఁస్తె తిల. ");
INSERT INTO key_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","జలె తెదొడి పేతురు, ఎగరజిన్ సిస్సుల్‍చి నెడిమి టీఁవొజ జా, బెద తిల మాన్సుల్‍క సూన్‍తు మెన, గట్టిఙ అవాడ్ కెరన, సంగుక దెర్లన్. జో ఇసి మెన సంగిలన్, “ఓ అమ్‍చ యూదుల్, ఈంజ యెరూసలేమ్ పట్నుమ్ తిలస ఎత్కిజిని, ఆఁవ్ అప్పె సంగితిసి సరిగా సూన, అర్దుమ్ కెరన. ");
INSERT INTO key_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ఈంజేఁవ్ తుమ్ దెకిల మాన్సుల్‍క ‘మచ్చ అస్తి’ మెన తుమ్ మెన్సుతె ఉచర్లి రిసొ మచ్చితి నాయ్. అప్పె పెందలె నొవ్వు గంటల్ జా అస్సె! ");
INSERT INTO key_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","అప్పె జర్గు జలిస్‍చి రిసొ దేముడు పూర్గుమ్ జోచ కబుర్లు సంగిలొ యోవేలు మెలొసొచి అత్తి సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","దేముడు కిచ్చొ సంగితయ్ మెలె, ‘ఆకర్ దీసల్‍క దేసిమ్‍లు ఎత్కితె తిల మాన్సుల్‍చి పెట్టి అంచి ఆత్మ సువ దెయిందె. తుమ్‍చ పుత్తర్లు, దువిద్లుచి అత్తి అంచ కబుర్లు సంగిమ్‍దె. పడ్తొ తుమ్‍చ ఉబెడ్లు, జలె, ఆఁవ్ దెకయ్‍త సివ్నల్ దెకుల, తుమ్‍చ మంత్రమాన్సుల్ కి ఆఁవ్ దెకయ్‍త సివ్నల్ దెకుల. ");
INSERT INTO key_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","కచితుమ్, మున్సుబోదల్ జలెకి, తేర్‍బోదల్ జలెకి, అంచ సేవ కెర్తస ఎత్కిజిన్‍చి పెట్టి అంచి ఆత్మ సువ దెయిందె, చి అంచ కబుర్లు సంగితె తవుల. ");
INSERT INTO key_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ఆగాసుమ్‍తె కి, బూలోకుమ్‍తె కి, వెల్లెల వెల్లెల కమొ కెర, అంచి అదికారుమ్‍క రుజ్జుల్ దెకయిందె. లొఁయి సూఁయి జతిసి, ఆగి లగితిసి, చి దుమ్మొ జతిసి. ");
INSERT INTO key_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ప్రబు అన్నె ఉత్ర జతి జా వెల్లి దీసి నే జెతి అగ్గె పొద్దు అందర్ జయెదె, జోను లొఁయి రంగు జయెదె. ");
INSERT INTO key_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","గని, తూయి నిజుమి పరలోకుమ్‍చొ దేముడు, తుక నంపజతసి, అంక రచ్చించుప కెరు! మెన జోవయించి పెట్టి కో అంక ఎక్కి నిదానుమ్ నంపజవుల గే, జోవయించి పాపుమ్ చెమించుప కెర, జోవయింక రచ్చించుప కెరిందె.’ ” ");
INSERT INTO key_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“దస్సి ఉచర కెర, ఒత్త బెద తిల యూదుల్‍క పేతురు అన్నె కిచ్చొ మెలన్ మెలె, ఓ ఇస్రాయేలులు మెంత అమ్‍చ యూదుల్, ఏక్ కోడు తుమ్ సూన. నజరేతు గఁవ్విచొ యేసు కీసి తిలొ గే, తుమ్ జాన్సు. ‘జోక దేముడు దిలి అదికారుమ్ రుజ్జు జవుస్’ మెన, దేముడు జోచి అత్తి తుమ్‍చి మొక్మె వెల్లెల వెల్లెల కమొ కెరవ, రుజ్జుల్ డీసయ్‍లొ. ");
INSERT INTO key_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","జలె, ‘జర్గు జతిస్, జర్గు జవుస్’ మెన దేముడు అగ్గెయి తెంతొ రెగిడ్లి రితి, జో యేసుక మూర్కుడ్లుచి అత్తి తూమ్ సొర్ప కెర దా, సిలువతె గలవ మార్లదు. ");
INSERT INTO key_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","జోక తుమ్ మార్లె కి, జో మొర్ను తెంతొ విడ్దల్ జా, దేముడు జోక అన్నె జియడ్లొ; యేసుచి ఉప్పిరి మొర్నుక అదికారుమ్ నాయ్. ");
INSERT INTO key_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","“యేసు అగ్గె తెంతొ జానన్లిస్ కిచ్చొ మెలె అమ్‍చొ దావీదు పూర్గుమ్‍చొచి అత్తి దేముడు రెగ్డయ్‍లొ మెలె; దేముడు కెద్దొడి తెదొడి అంక తోడు అస్సె మెన దెకిలయ్. కిచ్చొ కి అంక బమ్మ నే కెర్తె, జో అంచి ఉజెతొ పక్క తా తోడు తత్తయ్ మెన దెకిలయ్ చి ఆఁవ్ కదుల్ నే జయి. ");
INSERT INTO key_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","జాక, సర్దసంతోసుమ్ జలయ్, చి జో ప్రబుచి గవురుమ్‍చి రిసొ గనుమ్ గాయ్‍తొస్ జలయ్. జాకయ్, అన్నె, కిచ్చొ జర్గు జలెకి, అంచి పెట్టి అంచి ఆఁగ్ కి ఆస తెన్ తయెదె. ");
INSERT INTO key_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ఆఁవ్ మొర్లె కి, ఆఁవ్ మొర్నుతె గెలె కి, జో అంక ఒత్త ములె నాయ్, తుచి సుద్ది తిలసచి ఆఁగ్ కువితి రితి నే ఒప్పన్‌తె. ");
INSERT INTO key_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","జితి సెక్తి అంక దా అస్సిస్, చి తుచితె పరలోకుమ్‍తె తిఁయ తా, తుచితె ఆఁవ్ తతిస్‍క అంక పూర్తి సర్దసంతోసుమ్ కెర్తె.” పేతురు జేఁవ్ బెర తిల యూదుల్‍క ఏద కెరవ, అన్నె కిచ్చొ మెన బోదన కెర్లన్ మెలె, ");
INSERT INTO key_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“ఓ బావుడ్లు, అమ్‍చొ దావీదు పూర్గుమ్‍చొచి రిసొ కిచ్చొ మెన కచితుమ్ ఆఁవ్ సంగితసి మెలె, జో మాములుమ్ మాన్సు జా మొర గెలన్, చి జోక మెస్నె రోవ చి అప్పెక మెస్సున్ దస్సే అస్సె. ");
INSERT INTO key_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","గని మాములుమ్ మాన్సు జలెకి, దేముడు ఒట్టు గలన్ కిచ్చొ మెన నే పిట్తి కచితుమ్ కోడు పూర్గుల్‍క సూనయ్‍లిసి కబుర్లు జో జాన అస్సె. దేముడు జోవయింక కిచ్చొ సంగిలన్ మెలె; తుమ్‍చి వమ్‍సుమ్‍చొ ఎక్కిలొక తుచి సింగాసనుమ్‍తె వెసడిందె” ");
INSERT INTO key_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","జాకయ్, జో దేముడు సికయ్‍తికయ్, కిచ్చొ అగ్గె తెంతొ దెకిలి రితి జా దావీదు రెగ్డ అస్సె మెలె; “క్రీస్తు మొర్లె కి, మొర్నుతె నే తయెదె, జోచి ఆఁగ్ నే కువితె, అన్నె జీఁవ్ జా ఉట్టెదె.” ");
INSERT INTO key_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“జలె, ఈంజొ యేసుకయ్ దేముడు అన్నె జియడ్లొ మెన అమ్ ఇన్నె బెర్లస ఎత్కిజిన్ సాచి జా అస్సుమ్. ");
INSERT INTO key_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","జో, జలె, అన్నె జీవ్ జా ఉట్ట దేముడు అబ్బొస్‍తె పరలోకుమ్‍తె వెగ గెచ్చ గవురుమ్ జా, జోచి ఉజెతొ పక్క వెస అస్సె. చి జో దేముడు అబ్బొసి అగ్గె సంగ తిలి రితి, జోచి సుద్ది తిలి ఆత్మ వంట దెతిసి, పూర్తి జో తుమ్ అప్పె దెకిలిసి సూన్లిసి జర్గు కెర అస్సె. ");
INSERT INTO key_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","“దావీదు, జలె, పరలోకుమ్‍తె వెగ గెచ్చె నాయ్, గని జో ఇసి సంగిలన్. దేముడు ప్రబు అంచొ ప్రబుక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","‘తుక విరోదుమ్ జలస తుచి చాటు సుఁదితి పొద్రొ జతి రితి కెర్తె ఎదక, తుయి అంచి ఉజెతొ పక్క వెస తా.’ ");
INSERT INTO key_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“జాకయ్, తుమ్ ఇస్రాయేలులు మెల అమ్‍చ యూదుల్ ఎత్కిజిన్‍క ఆఁవ్ కిచ్చొ కచితుమ్ సంగితసి మెలె, తుమ్ సిలువ గల మార్లొ యేసు అమ్‍క దొర్కు జలొ రచ్చించుప కెర్తొసొ జతొ క్రీస్తు జా, ఎత్కిక ఏలుప కెర్తొ ప్రబు జవుస్” ఇసి పేతురు రుజ్జు కెర్లన్. ");
INSERT INTO key_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ఈంజ ఎత్కి సూన కెర, ఒత్త బెర తిల యూదుల్, “నిజుమి దేముడుచొ పుత్తుస్‍క మార పాపుమ్ కెర్లమ్ మెన జోవయించి పెట్టి దుకుమ్ తెన్ ఒప్పన, బియఁ గెచ్చ, ఓ బావుడ్లు, అమ్‍చి పాపుమ్ గెస్సు మెన అమ్ అప్పె కిచ్చొ కెర్లె జయెదె?” మెన పేతురుక చి జోవయింతెన్ తిల యేసుచ అన్నె బారికుల్‍క పుసిల. ");
INSERT INTO key_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","జేఁవ్‍క, పేతురు, “తుమ్ కెర్ల పాపల్‍చి రిసొ దుకుమ్ జా పాపుమ్ ముల్తి బుద్ది జా యేసుక్రీస్తుక నంపజా, తుమ్‍చి పాపుమ్ గెచ్చయ్‍తి గుర్తుక జోచి నావ్ తెన్ బాప్తిసుమ్ కడన్క. దస్సి కెర్లదు మెలె, దేముడుచి సుద్ది తిలి ఆత్మ తుమ్‍క దొర్కు జయెదె. ");
INSERT INTO key_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","జోచి కక్క ప్రబు జలొ అమ్‍చొ దేముడు నిసాన్‍దె గే, ‘జోవయించి పెట్టి అమ్‍చి సుద్ది తిలి ఆత్మ దెయెదె’ మెన, తుమ్‍చి రిసొ కి, తుమ్‍చ బోదల్‍చి రిసొ కి, పడ్తొచ మాన్సుల్‍క కి, పడ్తొ దూరి దేసిమ్‍లుచ మాన్సుల్‍చి రిసొ కి సంగ అస్సె” ఇసి పేతురు జేఁవ్‍క సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","పడ్తొ అన్నె సాచుల్ రుజ్జుల్ బెదవ, జోవయింక కిచ్చొ మెన బతిమాల్ప జా సంగిలన్ మెలె, “పాపుమ్‍బుద్ది తిల ఈంజ ఉగుమ్‍చ మాన్సుల్‍చి బుద్ది ముల, విడ్దల్ కెరన, రచ్చించుప జా” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","జోచి కోడు సూన నంపజలస, జలె, బాప్తిసుమ్ నఙన్ల. చి జా దీసి రమారమి తిన్ని వెయిల్‍జిన్ మాన్సుల్ అగ్గె నంపజల సిస్సుల్ తెన్ బెదిల. ");
INSERT INTO key_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","జా దీసి తెంతొ, నిదానుమ్ తెన్ యేసుచ బారికుల్‍చి బోదన సూన్‍తె తా, సిస్సుల్ తెన్ సర్ద తెన్ బెద, మాన్సుల్‍చి పాపుమ్ గెచ్చయ్‍తిస్‍క యేసు బలి జలొచి జా గుర్తు దెకయ్‍తి పోడియొ, ద్రాచ రస్సుమ్ కంక పింక అలవాట్ జల, జోవయింతెన్ నిదానుమ్ తెన్ ప్రార్దన కెర్తె తిల. ");
INSERT INTO key_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ఎత్కిజిన్ ఉచర ఉచర ఆచారిమ్ తెన్ తిల, చి జేఁవ్ బారికుల్‍చి అత్తి ప్రబు ఒగ్గర్ వెల్లెల కమొ జర్గు జలి. ");
INSERT INTO key_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","పడ్తొ, నంపజలస ఎత్కిజిన్ సర్ద తెన్ ఎక్కి మెన్సు తెన్ తిల, చి బీద సుదల్, సొమ్సార్లు, కోయి ముస్క నే జతె, ఎక్కిలొక ఎక్కిలొ తోడు దెతె తిల. ");
INSERT INTO key_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ఆస్తి తిల మాన్సుల్ జోవయించి వికన, నెంజిల మాన్సుల్‍క తోడు దెతె తిల. ఎక్కిలొక కొత్కు తిలెగిన, అన్నెక్లొ జోక తోడు దెంక. ");
INSERT INTO key_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","దేముడుచి గుడితె బెద, ప్రబుక ఉచరుక మెన రోజుక గెతె తిల, చి జోవయించి గెరలె, ఎక్కిలొక ఎక్కిలొ అన్నిమ్‍క బుకారా, జా పోడియొ కా, జా ద్రాచ రస్సుమ్ పియఁ, సర్దసంతోసుమ్ తెన్ కట్టు తెన్ తిల. ");
INSERT INTO key_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","దేముడుచి గవురుమ్ సంగితె తిల, చి ఎత్కిజిన్ జోవయింక మెన్సిత్ తిల, చి ప్రబు రోజుక కక్క కక్క నొవ మాన్సుల్‍క నిసాన రచ్చించుప కెర నంపజలస మొత్తుమ్‍చి సంగుమ్‍తె బెదయ్‍తె తిలన్. ");
INSERT INTO key_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ఏక్ దీసి, ప్రార్దన కెరుక బెదుక మెన, పేతురు చి యోహాను దేముడుచి గుడితె గెతె తిల. తెదొడి తిన్ని గంటల్ జా తిలి. ");
INSERT INTO key_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","దేముడుచి గుడిక పాసి అయ్‍లె పొది, జెర్మిల్ తెంతొ సొట్టొ జలొ ఎక్కిలొక మాన్సుల్ వయ నెతె తిల. రోజుక జోక వయన దేముడుచి గుడిచి కోటచి ‘సూటి’ మెన నావ్ తిలి గుమ్ముమ్ సొడి వెసడ్లె, గుమ్ముమె పెసిత తతె జో మాన్సు దర్ముమ్ నఙితె తిలొ. ");
INSERT INTO key_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","పేతురు చి యోహాను దేముడుచి గుడి తెడి పెసుక దెర్లిసి, జో దెక, “డబ్బుల్ దా” మెన, దెక నే దెకిల్ రితి జా సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","సంగిలె, పేతురు యోహాను జోక చెంగిల్ దెకిల. అన్నె పేతురు జోక, “అమ్‍క సరిగా దెకు” మెలన్. ");
INSERT INTO key_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","దస్సి మెంతికయ్, ‘కిచ్చొ జవుస్ దెవుల’ మెన ఉచర, జో మాన్సు జోవయింక సరిగా దెకిలన్. ");
INSERT INTO key_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","గని పేతురు జోక, “అంక వెండి కాసుల్ నాయ్, బఙార్ కాసుల్ నాయ్, గని అంక తిలిసి తుక దెయిందె. నజరేతుచొ యేసుక్రీస్తుచి నావ్ తెన్ ఉట్ట ఇండు” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","సంగ, జోచి ఉజిల్ ఆతు పేతురు దెర, జోక ఉట్టవ టీఁవొ కెలన్. బేగి, జోచ చట్టొ, ఆఁగ్ అడ్డొ డిట్టుమ్ జల. ");
INSERT INTO key_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","డిట్టుమ్ జతికయ్, జో చట్కున ఉట్ట అద్దుర్ నెంతె టీఁవొ ఇండుక దెర, సర్దక నచ్చ నచ్చ, దేముడుచి గవురుమ్ సంగ సంగ, దేముడుచి గుడితె పెసిలొ. ");
INSERT INTO key_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","జో మాన్సు ఇండితె తిలిసి, దేముడుచి గవురుమ్ సర్ద తెన్ సంగితె తిలిసి ఒత్త బెర్ల ప్రెజల్ ఎత్కి దెక కెర, ");
INSERT INTO key_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","“ఒరె, ఈంజొయి రోజుక దేముడుచి గుడిచి గుమ్ముమె దర్ముమ్ నఙ వెస తతొసొ, గని చెంగిల్ జా ఇండితయ్” మెన, బమ్మ జా ఆచారిమ్ తెన్ ఎక్కిలొక ఎక్కిలొ సంగితె తిల. ");
INSERT INTO key_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","జో మాన్సు, జలె, పేతురుక చి యోహానుక ములుక నెతిర్లిసి జా జనాబ్ దెక, ఆచారిమ్ జా, జేఁవ్ తీగ్ల దేముడుచి గుడిచి వెల్లి పేడె గెచ్చ తతికయ్, ఈంజెఁవు జనాబ్ బెద నిగ గెచ్చ, సొలొమోను రానొచి నావ్ తిలి పేడెక జోచి సుట్టునంత బెర గెల. ");
INSERT INTO key_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","జేఁవ్ జనాబ్ దస్సి బెర అయ్‍లిసి దెక, పేతురు జోవయింక ఇసి మెన బోదన కెరుక దెర్లన్. “ఓ ఇస్రాయేలులు మెల అమ్‍చ యూదుల్, ఈంజొ మాన్సుచి రిసొ తుమ్ కిచ్చొక ఆచారిమ్ జతసు? అమ్‍క కిచ్చొక దస్సి ఆచారిమ్ తెన్ దెకితసు? అమ్‍చి సొంత సెక్తి తెన్, సొంత పున్నిమ్‍చి రిసొ జోక చెంగిల్ కెర ఇండయ్‍ల మెన తుమ్ ఉచర్తసు గె? ");
INSERT INTO key_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","“అమ్‍చ పూర్గుల్ జల అబ్రాహామ్‍క, ఇస్సాకుక చి యాకోబుక దేముడు, జోచొ సేవ కెర్తొసొ యేసుకయ్ అన్నె జియడ గవురుమ్ కెర దా అస్సె. తుమి యేసుక దెర పిలాతు అదికారిచి అత్తి సొర్ప దిలదు, చి జో పిలాతు ‘జోక విడ్దల్ కెరిందె, జో కేన్ తప్పు కెరె నాయ్’ మెన తీర్పు సంగిలే కి, తూమ్ నే ఒప్పన్‌తె యేసుచి విలువ కడ్లదు. ");
INSERT INTO key_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","తుమ్ దస్సి కెర, సుద్ది చి పున్నిమ్ తిలొ క్రీస్తు రచ్చించుప కెర్తొసొచి మరియాద కడ్లదు. అత్య కెర్లొ బరబ్బక విడ్దల్ కెరు, జోకయ్ కావలె మెన, తుమ్ కోర్‍ప జా పిలాతుక సంగ. ");
INSERT INTO key_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ఎత్కి జీవుల్‍క జీవు దెతొసొ, ఎత్కిక ఆదారుమ్ జలొ యేసుక తుమ్ మార గెలదు. గని దేముడు జలొ అబ్బొసి జోక అన్నె జియడ్లొ మెన ఆమ్ దెక, సాచి జా అస్సుమ్. ");
INSERT INTO key_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","జోచి అదికారుమ్‍చి రిసొ జొయ్యి ఈంజొ సొట్టొ మెన తుమ్ అగ్గె తెంతొ జాన్లొ మాన్సుక చెంగిల్ కెర అస్సె. యేసుకయ్ నంపజా జోచి నావ్ తెన్, ఉట్ట ఇండు మెన ఇన్నెక అమ్ సంగితికయ్, యేసుయి ఇన్నెక చెంగిల్ కెర్లన్. తుమ్‍చి మొక్మె ఈంజొ మాన్సు పూర్తి చెంగిల్ జలిసి కీసి జర్గు జలి మెలె, యేసుయి దయిరిమ్ కెర, నంప కెరవ, చెంగిల్ కెర్లన్. ");
INSERT INTO key_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“జలె, అమ్‍చ బావుడ్లు, ఉచర, తూమ్, తుమ్‍చ అదికారుల్, నేన కెర దస్సి కెర్లదు మెన జాని. ");
INSERT INTO key_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","గని, దేముడు పూర్గుమ్ జో కబుర్ తెద్రయ్‍లస చి అత్తి సంగ తెద్రయ్‍లిసి, జో ఏలుప కెరయ్‍తొ క్రీస్తు సేడుక తిల స్రెమల్ ఎత్కిచి రిసొ పూర్గుమ్ కబుర్ సంగ తెద్రయ్‍లిసి. యేసుక తుమ్ మార్లిసి తెన్ జో దేముడు నెరవెర్సుప కెర అస్సె. ");
INSERT INTO key_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","జలె, అమ్ కెర్ల పాపల్ పుంచి జతు మెన తుమ్ కోర్‍ప జలె, తుమ్ కెర్ల పాపల్‍చి రిసొ పెట్టి పూర్తి దుకుమ్ జా, ఆజి తెంతొ ప్రబుచి ఇస్టుమ్ రితి కెరుక పూర్తి కోర్‍ప జా మార్సుప జా, చి దేముడు తుమ్‍క పాసి కెరన, తుమ్‍క సెలవ్ కడన్లి పొది దిలి రితి, తుమ్‍చి ఆత్మల్‍క చెంగిల్ కెరెదె, ");
INSERT INTO key_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","చి తుమ్‍క పూర్గుమ్ తెంతొ సంగ తిలొ రచ్చించుప కెర్తొసొ జతొ క్రీస్తుక తుమ్‍తె తెద్రయెదె. క్రీస్తు కొన్సొ మెలె, యేసు. ");
INSERT INTO key_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","జో క్రీస్తుయి పరలోకుమ్‍తె తంక. కెఁయ్య ఎద జో ఒత్త తంక అస్సె మెలె, పూర్గుమ్ దేముడుచి కబుర్ సంగిలసచి అత్తి సంగిలిసి ఎత్కి నెరవెర్సుప జతె ఎద. ");
INSERT INTO key_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“మోసే పూర్గుమ్‍చొచి అత్తి దేముడు రెగ్డయ్‍లి కోడు ఏక్ కిచ్చొ మెలె; అంచ కబుర్లు సంగు మెన పరలోకుమ్‍చొ ప్రబు జలొ దేముడు అంకయ్ కీసి తెద్రయ్‍లొ గే, దస్సి, తుమ్ యూదుల్‍తె జెర్మితొ ఎక్కిలొక కబుర్ తెద్రయెదె. తుమ్‍క జో కిచ్చొ ఆడ్ర దెయెదె గే, జయ్యి తుమ్ కెర్తె. ");
INSERT INTO key_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","జో కబుర్ జెతొసొక కో సూన్‍తి నాయ్ గె. ‘ఆఁవ్ నిసాన్ల ప్రెజల్‍తె తుమ్ బెదుక విలువ నాయ్’ మెన జోవయింక దేముడు నాసెనుమ్ కెరెదె. ");
INSERT INTO key_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","పడ్తొ, సమూయేలు పూర్గుమ్‍చొ తెంతొ అప్పెచి కాలుమ్ ఎద దేముడు కబుర్ తెద్రయ్‍లసతె కక్క నే పిట్తె, జేఁవ్ ఎత్కిజిన్ ఈంజ కాలుమ్ జర్గు జతిసి, ఆజి జర్గు జతిస్‍చి రిసొ అగ్గె తెంతొ సంగ అస్తి. ");
INSERT INTO key_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","జలె, దేముడుచి కబుర్ సంగ తిల జేఁవ్ పూర్గుల్‌చ పుత్తర్సులు తూమ్. పడ్తొ తుమ్‍చి సెకుమ్‍తె పడ్తొక ఎక్కిలొ జెర్మెదె. జోచి రిసొ ఈంజ లోకుమ్‍చ కుటుంబల్ ఎత్కిక దీవెన దొర్కు జయెదె. జోచి అత్తి అంచి వరుమ్ దెయిందె మెన దేముడు తుమ్‍చొ అబ్రాహామ్ పూర్గుమ్‍చొచి అత్తి తుమ్‍చ పూర్గుల్‍క నే పిట్తి ప్రమానుమ్ కెర సంగిలన్. జా కోడుచి రిసొచి పుత్తర్లు కి తూమ్ జస్తె. ");
INSERT INTO key_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","జలె, ‘దొర్కు జలొ రచ్చించుప కెర్తొసొ’ మెన ప్రబు జోచొ సేవ కెర్తొసొ జలొ యేసుక టీఁవడ. జో మొర్తికయ్ అన్నె జియడ, కత్తె తొలితొ తెద్రవ అస్సె మెలె, తూమ్ యూదుల్‍తెయి. కిచ్చొక మెలె, తుమ్‍క ‘తుమ్‍చి పాపుమ్‍బుద్ది ముల చెంగిల్ జతు’ మెన తుమ్‍కయ్ తొలితొ చి తెద్రవ అస్సె” మెన పేతురు ప్రెజల్‍క బోదన కెర్లన్. ");
INSERT INTO key_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","పేతురు చి యోహాను ప్రెజల్‍క దస్సి బోదన కెర్తె తతికయ్, యూదుల్‍చ పూజర్లు, దేముడుచి గుడిచొ ఎజొమాని, పడ్తొ సద్దూకయ్యులు మెన పండితుల్ జోవయింతె ఉట్ట అయ్‍ల. ");
INSERT INTO key_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","యేసు ‘మొర అన్నె జీవ్ జలొ’ మెన ప్రెజల్‍క పేతురు చి యోహాను సికయ్‍తె తిలి రిసొ, జేఁవ్ వెల్లొ సుదల్ కోపుమ్ జా అస్తి. ");
INSERT INTO key_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","జోవయింక దెర్ల, గని సాంజ్ జలి రిసొ ‘కలిక తీర్పు కెరుమ’ మెన దస్సే జేల్‍తె గలిల. ");
INSERT INTO key_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","జేఁవ్ వెల్లొ సుదల్ దస్సి కెర్లె కి, జేఁవ్ దొగుల కెర్లి బోదన సూన్లస ఒగ్గర్‍జిన్ యేసుక నంపజఁయి గెల. ఇన్నెతెన్, నంపజలస కెత్తిజిన్ జల మెలె, తేర్‍బోదల్, బాలబోదల్‍క పిట్టవ, రమారమి పాఁచ్ వెయిల్‍జిన్ మున్సుబోదల్ తిల. ");
INSERT INTO key_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","అన్నెక్ దీసి కిచ్చొ జర్గు జలి మెలె, సబ కెరుక మెన యూదుల్‍చ అదికారుల్, వెల్లెల మాన్సుల్, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తస ఎత్కిజిన్ యెరూసలేమ్ పట్నుమ్‍తె బెర జా అస్తి. ");
INSERT INTO key_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","జోవయింతె కో కో ముక్కిమ్ జా సబ కెర్తి రిసొ జా అస్తి మెలె, అగ్గె ఎత్కిక వెల్లొ పూజరి జా తిలొ అన్నొస్‍చి జాఁవొసి జలొ తెదొడిచొ ఎత్కిక వెల్లొ పూజరి కయప, ఎత్కిక వెల్లెల పూజర్లు జతసచ కుటుంబల్‍చ మున్సుబోదల్ ఎత్కిజిని. ఇనయింతె దొగుల కొన్స మెలె, యోహానుని అలెక్సంద్రు. ");
INSERT INTO key_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","సబ కెరుక దెర్లి పొది, యోహానుక చి పేతురుక కడ ఆన నెడిమి టీఁవొ కెరన, జేఁవ్ చెంగిల్ కెర్లొ అగ్గె సొట్టొ జా తిలొ మాన్సుక కి టీఁవొ కెర, జేఁవ్ దొగులక పరిచ్చ కెరుక దెర్ల. “ఈంజొ మాన్సుక కీసి ఇండయ్‍లదు? తుమ్‍చి సొంత సెక్తిక నెతుర్సు! కచి సెక్తి, కచి నావ్ తెన్ ఈంజ కామ్ కెర్లదు?” మెన కోపుమ్ తెన్ పరిచ్చ కెర్ల. ");
INSERT INTO key_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","తెదొడి పేతురు దేముడుచి సుద్ది తిలి ఆత్మసెక్తి జోచి పెట్టి బెర సెక్తి దెతికయ్, దయిరిమ్ జా, జేఁవ్ వెల్లెల మాన్సుల్‍క ఇసి మెన జబాబ్ దిలన్; “యూదుల్‍చ అదికారుల్, వెల్లెల మాన్సుల్, తుమ్‍క ఆమ్ కిచ్చొ సంగుక? ");
INSERT INTO key_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","అమ్ సొట్టొ మాన్సు ఎక్కిలొక చెంగిల్ కెర్లి రిసొ ఆజి తుమ్ అమ్‍క పరిచ్చ కెర్తసు జలె, ");
INSERT INTO key_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","నజరేతు గఁవ్విచొ యేసుక్రీస్తుచి నావ్ తెన్ని తుమ్‍చి నెడిమి టీఁవొ జలొ ఈంజొ మాన్సు చెంగిల్ జా అస్సె. జో యేసుక్రీస్తు తుమి సిలివ గల మార్లదు, గని దేముడు జోక అన్నె జియడ్లన్, చి జొయ్యి ఈంజొ మాన్సుక చెంగిల్ కెర అస్సె మెన తుమ్‍క చి అమ్‍చి ఇస్రాయేలులు ఎత్కిజిన్‍క ఆఁవ్ కచితుమ్ సంగితసి. ");
INSERT INTO key_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","“గేరు బంద మాన్సుల్ నెస కెర ములిల పత్తుర్, గేర్ బందత బోడిపత్తుర్ జయెదె. తుమ్ జోక నెసిలె కి, పరలోకుమ్‍చి రాజిమ్‍క జొయ్యి వెల్లొ జా అస్సె. ");
INSERT INTO key_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","పాపుమ్ తెంతొ విడ్దల్ జా పరలోకుమ్‍తె గెతి రచ్చన కచితె దొర్కు జతయ్ మెలె, యేసుతెయి అన్నె కత్తెయ్ నాయ్. కిచ్చొక మెలె, ఈంజ ఒండి లోకుమ్‍తె అన్నె కచి నావ్ తెన్ రచ్చించుప జంక కో కి నెతిర్తి” మెన పేతురు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","పేతురుక చి యోహానుక, “ఈంజేఁవ్ ఒగ్గర్ సదు కెర్ల మాన్సుల్ నెంజితి రిత జాలర్లు ఈంజేఁవ్, వెల్లెల మాన్సుల్ నెంజితి, గని తెద్ది దయిరిమ్ తెన్ అమ్‍క బుద్ది సంగితతి” మెన, జేఁవ్ వెల్లెల మాన్సుల్ ఆచారిమ్ జల. అన్నె, యేసు తెన్ జేఁవ్ బుల్తె తిలి రిసొయ్ ఇసి తెలివి తెన్ దయిరిమ్ జా అస్తి మెన వెల్లెల మాన్సుల్ చినిల. ");
INSERT INTO key_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","పడ్తొ, అగ్గె సొట్టొ జా తిలొ మాన్సు అప్పె చెంగిల్ జా జోవయించి నెడిమి టీఁవొజ అస్సె మెన దెక కెర, జేఁవ్ అన్నె కిచ్చొ నింద సంగుక నెతిర్ల. ");
INSERT INTO key_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","అన్నె కిచ్చొ సంగుక నెత్ర కెర, యోహానుక చి పేతురుక సబ తెంతొ బార్ కెర, వెల్లెల మాన్సుల్ లట్టబన్ల. ");
INSERT INTO key_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“ఈంజేఁవ్ దొగుల మాన్సుల్‍చి రిసొ అమ్ కిచ్చొ కెర్లె జయెదె? కిచ్చొ సిచ్చ కెరుక నెత్రుమ్, కిచ్చొగె. కిచ్చొక మెలె, తెద్ది వెల్లి కామ్ ఇన్నెచి అత్తి జర్గు జా అస్సె మెన ఈంజ యెరూసలేమ్‍తెచ మాన్సుల్ ఎత్కిజిన్ జాన్‍తి. ఆమ్ కి దెక అస్సుమ్, చి కిచ్చొ వేర సంగుక నెంజె. ");
INSERT INTO key_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","గని, ఈంజ ఎత్కిచి రిసొ అన్నె కో సూన్‍త నాయ్ మెన, ఈంజేఁవ్ దొగుల జోచి నావ్ తెన్ అన్నె కక్క కిచ్చొ నే సంగిత్ రితి బియఁడ ఆడ్ర దెమ” మెన తీర్పు సంగిల. ");
INSERT INTO key_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","తెదొడి, జేఁవ్ దొగులక అన్నె బుకారా కెర, “తుమ్ జో యేసుచి నావ్ దెరుక నాయ్. జోచి నావ్ తెన్ అన్నె కక్క బోదన కెరుక నాయ్” మెన పేతురుకచి యోహానులుక ఆడ్ర దిల. ");
INSERT INTO key_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","జేఁవ్ వెల్లెల మాన్సుల్ దస్సి సంగిలక, పేతురు, యోహాను, నే బితె దయిరిమ్ తెన్ కిచ్చొ సంగిల మెలె, “దేముడు సంగిలి కోడు అమ్ కెర్లె చెంగిల్ గే, తుమ్ మాన్సుల్ సంగిలి కోడు అమ్ కెర్లె చెంగిల్ గే, తూమ్ సరిగా ఉచర. జేఁవ్ దొన్నిచి రిసొ జో దేముడు సొంత కిచ్చొ మెనెదె గే ఉచర. ");
INSERT INTO key_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","అమ్ దెకిలిసి సూన్లిసి, ఆమ్ మాన్సుల్‍క నే సంగితె తంక నెత్రుమ్, నేన” మెన జేఁవ్ దొగుల యేసుచ బారికుల్ సంగిల. ");
INSERT INTO key_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","‘యేసుచి అదికారుమ్‍చి తెడి జో సొట్టొ మాన్సు చెంగిల్ జలొ’ మెన ప్రెజల్ ఎత్కిజిన్ దేముడుచి గవురుమ్ సంగితె తిల. జేఁవ్‍చి రిసొ, ‘జేఁవ్ దొగులక అమ్ సిచ్చ కెర్లె ప్రెజల్ అమ్‍క అల్లర్ కెరుల’ మెన కిచ్చొ సిచ్చ కెరుక నెత్ర కెర, ఎక్కి కోడ్‍కయ్ జోవయింక అన్నె బియఁడ కెర, వెల్లెల మాన్సుల్ జోవయింక విడ్దల్ కెర్ల. ");
INSERT INTO key_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ప్రెజల్ కిచ్చొక దేముడుచి గవురుమ్ ఒగ్గర్ నముకుమ్ తెన్ సంగితె తిల మెలె, జోవయించి గవురుమ్‌క రుజ్జు దెకయ్‍లి జా వెల్లి కామ్ జర్గు కెర్లిసి కక్క చెంగిల్ కెర్లిసి జయెదె మెలె, దొన్ని విసొ వెర్సుల్ జలొ సొట్టొ జెర్మిలొ మాన్సుక. ");
INSERT INTO key_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","పేతురుక యోహానుక వెల్లెల మాన్సుల్ ముల్తికయ్, జోవయించ గోతుసుదల్‍తె జేఁవ్ దొగుల గెచ్చ, ఎత్కిక వెల్లెల పూజర్లు చి వెల్లెల మాన్సుల్ జోవయింక సంగిలిసి ఎత్కి సంగ దిల. ");
INSERT INTO key_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","జేఁవ్ సూన కెర, జేఁవ్ ఎత్కిజిన్ ఎక్కి మెన్సు తెన్ బెద దేముడుక ఇసి మెన గట్టిఙ అవాడ్ తెన్ ప్రార్దన కెరుక దెర్ల: “ఎత్కిచి కంట వెల్లొ తిలొ అమ్‍చొ దేముడు ప్రబువ, పరలోకుమ్ బూలోకుమ్, సముద్రుమ్, జేఁవ్ ఎత్కితె తతిసి కిచ్చొ నే పిట్తె జెర్మయ్‍లొసొ తూయి. ");
INSERT INTO key_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","తుమ్‍చి సుద్ది తిలి ఆత్మ లట్టబ్తికయ్, తుచొ సేవ కెర్తొసొ జలొ అమ్‍చొ పూర్గుమ్‍చొ దావీదుచి చోండివాట్ తూయి సంగిలిసి కిచ్చొ మెలె, దేముడుక నేన్ల దేసిమ్‍లుచ మాన్సుల్ కిచ్చొక జోవయింక నిస్కారుమ్ ఉచర వెల్లెల మాన్సుల్ మెనన్ల? అమ్‍చయ్ ప్రెజల్ కి జోవయింక నేన్ల రిత జా, కిచ్చొక కామ్‍క నెంజిల కుట్రల్ జోవయించి రిసొ ఉచర్ల? ");
INSERT INTO key_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ఒండి లోకుమ్‍చ రానలు, అదికారుల్, కుట్ర కెర్లి రితి ఎక్కితె బెద, దేముడుక కి, జో ఏలుప కెరయ్‍తొ క్రీస్తుక కి యుద్దుమ్ కెర్లి రితి జల మెన దావీదుచి అత్తి రెగ్డ అస్సె. ");
INSERT INTO key_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","నిజుమి, ఈంజయి పట్నుమ్‍తె హేరోదు రానొ, పొంతి పిలాతు అదికారి, యూదుల్ నెంజిలస ఇస్రాయేలులు మెల అమ్‍చ యూదుల్, ఎత్కిజిని, దేముడుచి సుద్ది తిలొ తూయి ఏలుప కెరయ్‍లొ సేవ కెర్తొసొ జలొ యేసుక కుట్ర కెర, జోవయించి ఉప్పిరి యుద్దుమ్ కెర్లి రితి జల. ");
INSERT INTO key_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","‘జర్గు జవుస్’ మెన తూయి అగ్గె తెంతొ తుచి అదికారుమ్‍క సెలవ్ దా తిలిసి ఎత్కి, జోవయించి పెట్టిచి విస్సుమ్‍క జేఁవ్ జర్గు కెర్ల. ");
INSERT INTO key_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","అప్పె కి, ప్రబుచ, ఈంజేఁవ్ తుచ సేవ కెర్తసక బియడ్తతి. గని ఇన్నెక కన్కారుమ్ దెక, ");
INSERT INTO key_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","జొర్జొ తిల మాన్సుల్‍క ఇన్నెచి అత్తి చెంగిల్ కెర్తె తా, సుద్ది తిలొ తుచొ సేవ కెర్తొసొ యేసుచి నావ్ తెన్ జోచి అదికారుమ్‍క గుర్తు జత వెల్లొ కమొ కెరవ కెరవ, ఈంజేఁవ్ పూర్తి దయిరిమ్ తెన్ తుచి సుబుమ్ కబుర్ సంగితి రితి ఇన్నెక తోడు తా, మెన ప్రార్దన కెర్తసుమ్” మెన, బెర తిలస ఎత్కిజిన్ ఎక్కి మెన్సు తెన్ ప్రార్దన కెర్ల. ");
INSERT INTO key_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","దస్సి ప్రార్దన కెర కేడయ్‍లి బేగి, కిచ్చొ జర్గు జలి మెలె, జేఁవ్ సబ కెర్తె తిలి గేరు కదుల్ జంక దెర్లి, చి దేముడుచి సుద్ది తిలి ఆత్మ జోవయించి పెట్టి బెర పూర్తి సెక్తి దెతికయ్, పూర్తి దయిరిమ్ తెన్ దేముడు దిలి బోదన కెర్లిసి ఎత్కి సంగుక దెర్ల. ");
INSERT INTO key_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","జేఁవ్ పొదులె, యేసుప్రబుక నంపతిలస ఎత్కిజిని, ఎక్కి ఆత్మ, మెన్సు, ప్రేమ తెన్ తిల. “అంచయ్” మెన, జోవయింక కలుగు జల ఆస్తుల్‍చి రిసొ జోవయింతె కో కి పోటి సంగితి నాయ్, గని జోవయింక కలుగు జలిస్‍క ‘అమ్ ఎత్కిజిన్‍చి’ మెన, సర్ద తెన్ ఎక్కిలొక ఎక్కిలొ తోడు కెర్తె తిల. ");
INSERT INTO key_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","పడ్తొ, దేముడు యేసుచి ఆత్మసెక్తి జోవయించి పెట్టి తిలి రిసొ, జేఁవ్ బారజిన్ జోవయించ బారికుల్ పూర్తి దయిరిమ్ తెన్ యేసుప్రబు మొర అన్నె జిలిసిచి రిసొ సాచి సంగితె తిల. జో ప్రబుచి దయచి ప్రేమ జేఁవ్ నంపజలస ఎత్కిజిన్‍చి పెట్టి బెర కామ్ కెర్తె తిలి. ");
INSERT INTO key_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","జోవయింతె కక్క కి కొత్కు నాయ్. కిచ్చొక మెలె. జోవయింతె కక్క ఒగ్గర్ బుఁయి గే గెరల్ గే తయెదె గే, జో విక గెలెదె, చి జా వికిలి డబ్బిల్ ఆన కెర, ");
INSERT INTO key_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","యేసుచ బారికుల్‍చి చట్టె తివుల. ‘నెంజిలసక దొర్కు జవుస్’ మెన, నెంజిలసక వంట దెవుల. జాచి రిసొ కక్క కి కొత్కు జయె నాయ్. ");
INSERT INTO key_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","యోసేపు మెలొ ఎక్కిలొ జోవయింతె తిలొ. ‘దయిరిమ్ కెర్తొసొ’ మెలి అర్దుమ్ తెన్ జోక ‘బర్నబా’ మెన, బారజిన్ బారికుల్ ఆసిమ్ నావ్ తిఁయ తిల. జో, యూదుడు జలొ లేవీ మెలొ పూర్గుమ్‍చొచి సెకుమ్‍చొ జయెదె. జో జెర్మిలి దేసిమ్ కేన్ మెలె, కుప్ర మెలి దీవి దేసిమ్. ");
INSERT INTO key_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","జో కిచ్చొ కెర్లొ మెలె, జోక కలుగు జలి ఏక్ బాటి జో విక కెర, జా వికిలి డబ్బుల్ దెరన, జేఁవ్ బారజిన్ బారికుల్‍క చటె తిలన్. ");
INSERT INTO key_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","అననీయ మెలొ ఎక్కిలొ, మాన్సు, సప్పీరా మెలి తేర్సి తెన్, దొగుల బెద జోవయించి బుఁయి ఏక్ విక కెర, ");
INSERT INTO key_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","తేర్సి కి జాన్‍తె, జా బుఁయి వికిలి డబ్బుల్ సగుమ్ తియన కెర, ఎక్కి వాట యేసుచ బారికుల్‍తె అననీయ ఆన దిలన్. ");
INSERT INTO key_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ఆన్‍తికయ్, పేతురు జోక, “సయ్‍తాన్ తుచి పెట్టి సికడ అస్సె, చి దేముడుచి సుద్ది తిలి ఆత్మచి మొక్మె తుయి అబద్దుమ్ జా, జా బుఁయి వికిలి డబ్బుల్‍చి ఏక్ వాట తియన కెర, కిచ్చొక సయ్‍తానుక సూన జా పాపుమ్ కెర్లది? ");
INSERT INTO key_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","జా బుఁయి నే వికితె అగ్గె, జా పూర్తి తుచి ఆస్తి జా తిలి. జా వికిలి పడ్తొ కి, జా డబ్బుల్‍క సత్తిమ్ కెరుక పూర్తి తుచి పూచి. తుయి అప్పె ఉచర్లి మోసిమ్ కిచ్చొక? తుయి కెర్లిస్‍చి అర్దుమ్ పూర్తి ఉచరు. తుయి కెర్లిసి మాన్సుక అబద్దుమ్ సంగిలిసి, గని అన్నె ముక్కిమ్‍క కిచ్చొ పాపుమ్ జలది మెలె, తుయి దస్సి కెర, దేముడుకయ్ అబద్దుమ్ సంగ అస్సిసి” మెన, అననీయక పేతురు తీర్పు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ఈంజేఁవ్ కొడొ సూన్లి బేగి, అననీయ బుఁయ్యె సేడ మొర గెలన్. జో తప్పు కెర మొర్లిస్‍చి రిసొ సూన్లస ఎత్కిజిన్ బియఁ గెల. ");
INSERT INTO key_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","తెదొడి ఒత్త తిల ఉబెడల్ బట్ట తెన్ జోచి పీనుమ్ డంక, ఉక్కుల వయన, మెస్నె రోవ గెల. ");
INSERT INTO key_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","రమారమి తిన్ని గంటల్ గెతికయ్, అననీయచి తేర్సి జేఁవ్ బారికుల్ తిలిస్‍తె అయ్‍లి. మున్సుస్‍క జర్గు జలిసి జా నేనె. ");
INSERT INTO key_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","జెతికయ్, పేతురు జాక పసుల, జా బుఁయి వికిలి డబ్బుల్‍చి రిసొ జాక పుసిలన్. అననీయ దిలి ఎదిలి డబ్బుల్‍చి రిసొ సంగ, “తెద్దిలికయ్ జా బుఁయి వికిలదు గె?” మెన పుసితికయ్, జా “తెద్దిలికయ్” మెన సంగిలి. ");
INSERT INTO key_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","పేతురు జాక, “తుమ్ దొగుతెర కుట్ర కెర అబద్దుమ్ సంగిలిసి, ప్రబుచి ఆత్మక కొంకడ్లి రితి జతయ్ మెన బిస్సు నాయ్ గె? ఆదె! సూను! తుచొ మున్సుద్‍క రోవిలస అన్నె ఉట్ట జెతికయ్ అవాడ్ జెతయ్. అయ్‍లె, తుచి పీనుమ్ ఉక్కుల వయన తుక కి మెస్నె రోవుక గెచ్చుల” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","సంగిల్ బేగి, జా కి జోచి చట్టె సేడ మొర గెలి. ఉబెడల్ గేర్ తెడి జా కెర, జాక, ‘జా కి మొర అస్సె’ మెన దెక కెర, జాక ఉక్కుల వయన మెస్నె గెచ్చ, మున్సుస్‍చి సొడి జాక రోవిల. ");
INSERT INTO key_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","జా దీసి జర్గు జలిస్‍చి రిసొ, యేసుక నంపజలసచి సంగుమ్‍చ ఎత్కిజిని, సూన్ల అన్నె మాన్సుల్ ఎత్కిజిని, దేముడు యేసుచి ఆత్మసెక్తిచి రిసొ బియఁ గెల. ");
INSERT INTO key_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","జేఁవ్ బారజిన్ జోచ బారికుల్‍చి అత్తి ప్రబు ఒగ్గర్ ఒగ్గర్ వెల్లెల కమొ జర్గు కెరయ్‍లన్. జేఁవ్ పొదులె, జేఁవ్ రోజుక దేముడుచి గుడితె పూర్గుమ్‍చొచి సొలొమోను నావ్ తిలి పేడె సబ కెరుక అలవాట్ జా తిల. ");
INSERT INTO key_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","వేర మాన్సుల్ జోవయింతెన్ ఒత్త బెదుక బియఁ గెల, గని ప్రెజల్ ఎత్కిజిన్ జోవయింక ఒగ్గర్ గవురుమ్ దెకిత్ తిల. ");
INSERT INTO key_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","అగ్గెచి కంట, అన్నె మున్సుబోదల్ ఒగ్గర్‍జిన్, తేర్‍బోదల్ ఒగ్గర్‍జిన్, ఒగ్గర్‍జిన్ మాన్సుల్ ప్రబుక పూర్తి నంపజా గెల. ");
INSERT INTO key_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ప్రెజల్ అన్నె కిచ్చొ కెర్ల మెలె, పేతురు జోవయించి వాటు జవుస్ అయ్‍లె, “ఎక్కి జోవయించి నీడ అమ్‍క సగుమ్‍జిన్‍క లయుస్, జవుస్” మెన, జొర్జొ తిల జోవయించ మాన్సుల్‍క వయన, మంచల్‍తె జవుస్, అంతుర్నొతె జవుస్, వాటులె నిజవ దిల. ");
INSERT INTO key_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","యెరూసలేమ్ పట్నుమ్‍చి సుట్టునంతచ గఁవ్విలె తెంతొ కి ఒగ్గర్‍జిన్ జాఁ కెర, జోవయించ జొర్జొ తిల మాన్సుల్‍క, బూతుమ్ దెర్ల మాన్సుల్‍క, కడ ఆన్ల, చి జేఁవ్ ఎత్కిజిన్ కి చెంగిల్ జల. ");
INSERT INTO key_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ఎత్కిక వెల్లొ పూజరి, మాత్రుమ్, జోవయింతెన్ తిలస ఎత్కిజిని, సద్దూకయ్యులు మెల పండితుల్; యేసుచ బారికుల్‍చి ఉప్పిరి పూర్తి గోస జా బార్ జా, ");
INSERT INTO key_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","జోవయింక దెర, మాములుమ్ జేల్‍తె గలిల. ");
INSERT INTO key_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","గని, జా రాతి, ప్రబుచొ దూత ఎక్కిలొ జేల్‍తెచ కెవ్డివొ ఉగుడ కెర, బారికుల్‍క విడ్దల్ కెర బార్ కెర్లన్. చి జోవయింక, ");
INSERT INTO key_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“తుమ్ దేముడుచి గుడితె గెచ్చ పెస, నెడిమి టీఁవొజ, ప్రబుతె దొర్కు జతి పరలోకుమ్‍తె బెదితి ఆత్మతె జెర్మున్ జా జితి రచ్చనచి రిసొచి సుబుమ్ కబుర్ ప్రెజల్‍క పూర్తి బోదన కెర” మెన, దేముడుచ దూత ఆడ్ర దా సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","దూతచి కోడు సూన కెర, జేఁవ్ పెందలె ఉజిడి జలి పొది, దేముడుచి గుడితె పెస, బోదన కెరుక దెర్ల. దేముడుచి గుడితె బారికుల్ పెస బోదన కెర్తె తిలి మదెనె, ఎత్కిక వెల్లొ పూజరి, జోవయింతెన్ బెదిలస, జోవయింక ‘విడ్దల్ జా అస్తి’ మెన నేన కెర, ‘సబ కెరుమ’ మెన ఇస్రాయేలుల సబతె వెసితస ఎత్కిజిన్‍క బుకారా కెర, బారికుల్‍క కడ ఆన్‍తి రిసొ, జోవయించ జమాన్లుక జేల్‍తె తెద్రయ్‍ల. ");
INSERT INTO key_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","జేఁవ్ జేలితె పాఁవిలె, కెవ్డివొ ఉగిడ్లె, జేఁవ్ బారికుల్ ఒత్త నాయ్, చి వెల్లెల మాన్సుల్‍తె అన్నె బుల జా సంగిల. ");
INSERT INTO key_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“అమ్ జేల్‍తె గెలమ్, చి ఒత్త పాఁవిలె, జేల్‍తెచ కెవ్డివొ సంజె తెంతొ డిట్టుమ్ డంక అస్తి. చి అమ్‍చ జమాన్లు కెవ్డివొ సరిగా రకితె తిల, గని అమ్ కెవ్డివొ ఉగిడ్లె, తెడి కోయి నాయ్” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","సంగిలె, దేముడుచి గుడిచొ ఎజొమానిచి వెల్లెల పూజర్లు సూన, పూర్తి ఆచారిమ్ జా, “ఇన్నెచి అర్దుమ్ కిచ్చొ? అప్పె అన్నె కిచ్చొ జర్గు జయెదె?” మెన, బమ్మ జల. ");
INSERT INTO key_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","తెదొడి కో గే జేఁవ్ వెల్లొ మాన్సుల్‍తె జాఁ కెర, “తుమ్ జేల్‍తె గలిలస దేముడుచి గుడితె టీఁవొజ ప్రెజల్‍క సికడ్తతి” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","సంగితికయ్, దేముడుచి గుడిచ జమాన్లుచ ఎజొమాని, జోవయించ జమాన్లు తెన్ గెచ్చ, బారికుల్‍క దేముడుచి గుడి తెంతొ బార్ కెర్ల. గని జోవయింక కిచ్చొ దెబ్బల్ పెట్తి నాయ్, అల్లర్ కెరుక మెన చడిత్ కి నాయ్. కిచ్చొక మెలె, ‘జోవయింక అల్లర్ కెర్లె ప్రెజల్ అమ్‍క పత్రల్ గల మార గెలుల’ మెన బియఁ గెల. ");
INSERT INTO key_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","జలె, బారికుల్‍క దేముడుచి గుడి తెంతొ బార్ కెర, జోవయించి సబ కెర్తి గేర్‍తె కడన, సబ కెర్తసచి మొక్మె టీఁవొ కెలచి ఎత్కిక వెల్లొ పూజరి జేఁవ్‍క పరిచ్చ కెర్లొ. ");
INSERT INTO key_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“ఈంజ జోచి నావ్ తెన్ తుమ్ ప్రెజల్‍క సికడుక జయె నాయ్, మెన తుమ్‍క ఆడ్ర దిలమ్, గని ఒండి ఈంజ యెరూసలేమ్‍తెచ మాన్సుల్ ఎత్కిజిన్‍క తుమ్ సికడ అస్సుస్. అన్నె, అమ్‍క, ‘తుమి జోవయింక మార్లదు’ మెన, జో మాన్సుచి రిసొ అమ్‍కయ్ నింద కెర, అమ్‌కయి జా పాపుమ్ వయడుక ఉచర్తసు” మెన బారికుల్‍క తీర్పు సంగిల. ");
INSERT INTO key_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","పేతురు, బారికుల్ ఎత్కిచి రిసొ కిచ్చొ జబాబ్ దిలన్ మెలె, ఆమ్ కచి కోడు ముక్కిమ్‍క సూన కెరుక మెలె, మాన్సుచి కోడు నాయ్, గని దేముడుచి కోడు. ");
INSERT INTO key_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","తూమ్ యేసుక సిలువతె టీఁవడ మార్లదు, గని అమ్‍చ పూర్గుల్‌చొ దేముడు ప్రబు జోక అన్నె జియడ్లొ. ");
INSERT INTO key_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","“జలె, యేసుక అన్నె జియడ, అమ్‍చొ దేముడు కిచ్చొ కెర్లొ మెలె, జోక జోచి ఉజెతొ పక్క వెసడ, ఇస్రాయేలుల్ మెల యూదుల్‍క, ‘జేఁవ్ కెర్ల పాపల్‍క పెట్టి దుకుమ్ జా ముల జోక నంపజా, జోవయించి పాపుమ్ పుంచి జవుస్’ మెన, యేసుక, రచ్చించుప కెర్తొసొ, ఏలుప కెర్సు మెన, జోక గవురుమ్ కెర అస్సె. ");
INSERT INTO key_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ఈంజ ఎత్కిచి రిసొ ఆమ్ సాచుల్ జా అస్సుమ్. జోచి కోడు రితి కెర్తసక దేముడు దిలి జోచి సుద్ది తిలి ఆత్మ కి సాచి జతయ్.”, మెన పేతురు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","జేఁవ్ వెల్లెల మాన్సుల్ సూన ఒగ్గర్ కోపుమ్ జా, జేఁవ్ బారికుల్‍క మారుక కోర్‍ప జల. ");
INSERT INTO key_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","గమలీయేల్ మెలొ పరిసయ్యుడు ఎక్కిలొ ఒత్త జేఁవ్ వెల్లెల మాన్సుల్‍తె తిలొ. జో మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తొసొ జయెదె. జోక ఎత్కిజిని, ‘చెంగిల్ మాన్సు’ మెన గవురుమ్ కెరుల. జో మాన్సు టీఁవ, దేముడుచి గుడిచ జమాన్లుక, ‘ఈంజేఁవ్ మాన్సుల్‍క గడియ బార్ కెర తా’ మెన ఆడ్ర దిలస్. ");
INSERT INTO key_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","బారికుల్‍క బార్ కెరవ, బెర తిల వెల్లెల మాన్సుల్‍క గమలీయేల్ ఇసి మెన సంగిలన్: “అమ్‍చ ఇస్రాయేలులుచ ఓ తుమ్ వెల్లెల మాన్సుల్, జేఁవ్ మాన్సుల్‍క తుమ్ కిచ్చొ కెరుక ఉచర్తె గే, జాగర్త తా. ");
INSERT INTO key_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","జా సుట్టు జర్గు జలిస్‍చి రిసొ ఏద కెర. జేఁవ్ పొదులె దూదా మెలొ ఎక్కిలొ ‘ఆఁవ్ వెల్లొ’ మెన సొంత గవురుమ్ సంగుక బుల్తె తిలొ, చి రమారమి చెత్తర్ పుంజొజిన్ మాన్సుల్ జోవయింతెన్ బెదిల. గని మాన్సు జోక మార్తికయ్, జోచ సిస్సుల్ చెదుర్ప జల, చి జా ఎత్కి ఆరి పాడ్ జా గెలి. ");
INSERT INTO key_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","జాచి పడ్తొ, ప్రెజల్ లెక్క కెర్తె తిల పొదులె, గలిలయ ప్రాంతుమ్‍చొ యూదా మెలొ ఎక్కిలొ కి వెల్లొ మెనన, సగుమ్‍జిన్‍క సికడ సిస్సుల్ కెరన్లొ. గని జో కి మొర గెలొ, చి జోచ సిస్సుల్ కి చెదుర్ప జా గెల. ");
INSERT INTO key_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“జాకయ్, తుమ్ అప్పె దెర్ల మాన్సుల్‍చ రిసొ ఆఁవ్ కిచ్చొ మెంతసి మెలె, ఈంజేఁవ్ మాన్సుల్‍క ముల. తుక్లె తా. కిచ్చొక మెలె, ఈంజేఁవ్ కెర్తిసి, మాన్సుల్ ఉచర్లిసి రిత జలె, జాచి ఇస్టుమ్‍క పాడ్ జయెదె, చి ఆమ్ పిట్టవుక మెన కిచ్చొ కెరుక నాయ్. ");
INSERT INTO key_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","గని ఏక్ వేల ఈంజేఁవ్ కెర్తిసి, దేముడు తియార్లిసి జలె, తుమ్ కెద్ది సిచ్చ కెర్లె కి, పిట్టవుక నెతుర్సు. జాగర్త తా. ఈంజేఁవ్ కెర్తిసి దేముడు తియార్లిసి జలె, తూమ్ అల్లర్ కెర్లె, జో దేముడుక విరోదుమ్ సుదల్ కి జస్తె” మెన, జాగర్త సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","జో గమలీయేల్ దస్సి సంగితికయ్, వెల్లెల మాన్సుల్ సూన్ల, చి బారికుల్‍క అన్నె బుకారా కెర, కొర్డల్ తెన్ పెట, “తుమ్ యేసుచి నావ్ తెన్ కక్క కిచ్చొ సికడుక జయె నాయ్” మెన ఆడ్ర దా, విడ్దల్ కెర్ల. ");
INSERT INTO key_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","బారికుల్, జలె, కిచ్చొ బుద్ది తెన్ జా సబ కెర్లిస్ తెంతొ బార్ జల మెలె, ‘యేసుప్రబుచి నావ్‌క గవురుమ్ కెర్తి రిసొ జోచి గవురుమ్ దెకయ్‍లి రిసొ, అమ్ నిస్కారుమ్ జంక జలెకి, జొయ్యి అమ్‍క నిసాన విలువ రితి దెక అస్సె మెన అమ్‍క పూర్తి సర్ద’ మెన, సర్ద సేంతుమ్ తెన్ తిల. ");
INSERT INTO key_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","అన్నె, దేముడుచి గుడితె కి, గెరి కి, యేసుక, ‘జొయ్యి దొర్కు జలొ క్రీస్తు రచ్చించుప కెర్తొసొ’ మెన, ప్రెజల్‍క రోజుక సికడుక ములితి నాయ్. ");
INSERT INTO key_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","జా పొదులె, ఒగ్గర్‍జిన్ మాన్సుల్ యేసుక నంపజా, జోచ సిస్సుల్ జా గెతె తిల. జోవయింతె తిల బీద సుదల్ ఎత్కిజిన్‍క అన్నిమ్, కిచ్చొ కిచ్చొ తోడు దెంక ఇస్టుమ్ జలెకి, ఎతివాట్‍జిన్ జా తిల, చి దొర్కు జలిసి ఎత్కిజిన్‍క వంటుక నెతిర్ల, చి “ఎబ్రీ బాస లట్టబ్తె రండెల్ మాన్సుల్‍క సరిపుచుప జతిసి దెతతి గని అమ్‍చక నాయ్” మెన, గ్రీకు బాస లట్టబ్తస గోస కెర్ల. ");
INSERT INTO key_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","జాకయ్, తెదొడి జేఁవ్ బారజిన్ యేసుచ బారికుల్ కిచ్చొ కెర్ల మెలె, యేసుక నిదానుమ్ నంపజలస ఎత్కిజిన్‍క బుకారా కెర, “ఆము కెద్దొడి తెదొడి బీద సుదల్‍క అన్నిమ్ వంటితె తంక జలె, ప్రబుచి సుబుమ్ కబుర్ బోదన కెర్తిసి పిట్ట గెచ్చెదె. పిట్లె చెంగిల్ నాయ్. ");
INSERT INTO key_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","జాక కిచ్చొ కెరుక మెలె, ‘బీద సుదల్‍క దెకుత్’ మెన, తుమ్‍చి తెంతొ సత్తుజిన్‍క నిసాన, కీస మాన్సుల్ జేఁవ్ సత్తుజిన్ తంక మెలె, ‘సరిగా మాన్సుల్ జేఁవ్’ మెన, ఎత్కిజిన్‍క జాన్లస జా తంక, చి ప్రబుచి ఆత్మ జోవయించి పెట్టి జేఁవ్‍చి కామ్ పూర్తి కెర్తి బుద్ది తిలస జేఁవ్ తంక; బుద్ది సుదల్ జేఁవ్ తంక. దస్స మాన్సుల్‍క తుమ్ నిసాన, చి జా సేవచి రిసొ అమ్ జోవయింక అదికారుమ్ దెమ్‍దె. ");
INSERT INTO key_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","“ఆమ్, కిచ్చొ కెరుక అస్సె మెలె, ఆము ప్రార్దన కెర్తె తంక, ప్రబుచి సుబుమ్ కబుర్ బోదన కెర్తె తంక” మెన బారజిన్ సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","మొత్తుమ్ నంపజల మాన్సుల్ జా కోడుక సర్ద జల, చి బీద సుదల్‍క దెకుక మెన కక్క నిసాన్ల మెలె, స్తెపను మెలొ ఎక్కిలొక; జో బలే నముకుమ్‍చొ, జోచి పెట్టి దేముడుచి సుద్ది తిలి ఆత్మ పూర్తి కామ్ కెర్తి బుద్ది జోక తయెదె. అన్నె దస మాన్సుల్‍తె కక్క నిసాన్ల మెలె, పిలిప్, ప్రొకొరుక, నీకానోరుక, తీమోనుక, పర్మెనాస్‍క, నీకానొరు, జలె, జెర్మున్‍క యూదుడు నెంజె, గని దేముడుక నంపజా, యూదుల్‍చి అలవాట్‍తె బెద మార్సుప కెరన తిలొ. జో దూరి తిలి అంతియొకయ పట్నుమ్‍చొ మాన్సు. ");
INSERT INTO key_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ప్రెజల్ జేఁవ్ సత్తుజిన్‍క నిసాన బారికుల్‍తె కడ ఆన్‍తికయ్, జేఁవ్ ప్రార్దన కెర జోవయించ బోడివొ చడ అదికారుమ్ దిల. ");
INSERT INTO key_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","జేఁవ్ పొదులె, ఒగ్గర్ ఒగ్గర్‍జిన్ మాన్సుల్ దేముడు దిలి యేసుచి రిసొచి సుబుమ్ కబుర్ సూన నంపజల. జా యెరూసలేమ్ పట్నుమ్‍తె ప్రెజల్ ఒగ్గర్‍జిన్ నంపజల, చి దేముడుచ పూజర్లు కి ఒగ్గర్‍జిన్ నంపజా నిదానుమ్ జల. ");
INSERT INTO key_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","పడ్తొ స్తెపను, ప్రబుచి ఆత్మ జోచి పెట్టి తిలి ఒగ్గర్ ప్రేమ సెక్తిచి రిసొ, ప్రెజల్ తిలిస్‍తె యేసుచి అదికారుమ్ దెకయ్‍తి గుర్తుచ ఒగ్గర్ ఒగ్గర్ వెల్లొ కమొ కెర్లన్. ");
INSERT INTO key_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","గని యూదుల్‍తెచ సగుమ్‍జిన్ ‘విడ్దల్ జలస’ మెన నావ్ తియన్లి గుంపుచ జవుల. జోవయింక సొంత సబగేర్ తయెదె. జేఁవ్, పడ్తొ లిబియ దేసిమ్‍చి కురేనియు పట్నుమ్‍చ, ఐగుప్తు దేసిమ్‍చి అలెక్సంద్రియ పట్నుమ్‍చ, కిలికియ ప్రదేసిమ్‍చ, ఆసియా ప్రదేసిమ్‍చ తెన్, కోపుమ్ జా, “తుచి బోదన తప్పుచి కిచ్చొగె” మెన, స్తెపనుక ఆరి నింద కెర్ల. ");
INSERT INTO key_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","గని ప్రబుచి ఆత్మ స్తెపనుచి పెట్టి సికడ్తికయ్, జో బోదన కెర్తిస్‍తె బుద్ది గ్యానుమ్ ఒగ్గరి. చి జేఁవ్ కోపుమ్ జలస జీనుక నెత్ర లాజ్ జల. ");
INSERT INTO key_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","జాకయ్ జేఁవ్ జోవయించి లాజ్‍చి రిసొచి గోసక గుట్టు తెన్ కిచ్చొ కెర్ల మెలె, వేర మాన్సుల్‍క తోడు దెరన, “‘మోసే పూర్గుమ్‍చొచి అత్తి దేముడు దిలి ఆగ్నల్‍చి రిసొ, చి దేముడుచి రిసొ ప్రెజల్‍క కిచ్చొ కిచ్చొ సికడ, ఈంజొ స్తెపను మోసేక, దేముడుక, దూసుప కెర అస్సె. ఆమ్ సొంత సూన్లమ్’ మెన తుమ్ సంగ” మెన జేఁవ్ తోడు దెరన్ల మాన్సుల్‍క అబద్దుమ్ సాచి సికడ్ల. ");
INSERT INTO key_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","జేఁవ్ కోపుమ్‍చ మాన్సుల్ దస్సి ప్రెజల్‍క, వెల్లెల మాన్సుల్‍క, మోసే తెన్ దేముడు దిలి ఆగ్నల్ సికడ్తొసొ సికడ్తస, సికడ్తికయ్, జేఁవ్ స్తెపనుతె జా కెర, జోక దెర, సబ వెసితసతె కడ ఆన, ");
INSERT INTO key_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","అబద్దుమ్ సాచి సంగితసక టీఁవొ కెల. “ఈంజొ మాన్సు కెద్దొడ్ తెదొడి ఈంజ దేముడుచి గుడిచి రిసొ, మోసే పూర్గుమ్‍చొ రెగిడ్లి ఆగ్నల్‍చి రిసొ, అబద్దుమ్ సికడ్తె తత్తయ్. ");
INSERT INTO key_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ఈంజొ సంగిలిన్ కిచ్చొ ఆఁవ్ సూన అస్సుమ్ మెలె, ‘నజరేతు గఁవ్విచొ యేసు, ఈంజ దేముడుచి గుడిక పాడ్ కెర, మోసేచి అత్తి దిల అమ్‍చ అలవాట్లు మార్సుప కెరు’ మెన ఈంజొ సంగితె తత్తయ్” మెన జేఁవ్ మాన్సుల్ అబద్దుమ్ సాచి సంగిల. ");
INSERT INTO key_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","గని ఒత్త సబతె వెసిలస ఎత్కిజిన్ స్తెపనుక చెంగిల్ దెకిలె, జోచి మొకొమ్ కీసి జా అస్సె మెలె, పరలోకుమ్‍చొ దూతచి మొకొమ్‍చి రితి డీసిలి. ");
INSERT INTO key_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","తెదొడి, “జేఁవ్ సంగిలి సాచి సత్తిమ్ గె?” మెన ఎత్కిక వెల్లొ పూజరి స్తెపనుక పుసిలన్. ");
INSERT INTO key_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","స్తెపను కిచ్చొ జబాబ్ దిలన్ మెలె, “ఓ బావుడ్లు, ఓ వెల్లెల మాన్సుల్, అంచి సాచి తుమ్ సూన. పూర్గుమ్, అమ్‍చొ అబ్రాహామ్ పూర్గుమ్‍చొ హారానుతె నే ఉట్ట గెతె అగ్గె, జో మెసొపొతమియతె జితె తిలి పొది, గవురుమ్ తిలొ అమ్‍చొ దేముడు జోక డీస కెర, ");
INSERT INTO key_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘తుయి ఈంజ తుచి దేసిమ్ ముల, తుమ్‍చ సొంత మాన్సుల్‍క ముల, వేర దేసిమి ఉట్ట గో. జా దేసిమి పాఁవితె ఎదక వాటు దెకయ్‍తె తయిందె’ మెన సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","అమ్‍చొ అబ్రాహామ్ మెసొపొతమియ తిలి జా కల్దీయుచి దేసిమ్ ముల దా ఉట్ట గెచ్చ, హారాను దేసిమి గెచ్చ జితె తిలొ. జో అబ్రాహామ్‍చొ అబ్బొసి మొర గెతికయ్, దేముడు జోక ఒత్త తెంతొ తెద్రయ్‍తికయ్, తూమ్ అప్పె జితి దేసిమి ఉట్ట అయ్‍లొ. ");
INSERT INTO key_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","గని జో ఇన్నె జితె తిలి పొది, ఏక్ అడుగుచి ఎదిలి టాన్‌క సొంత మెనంతి రితి, జోక ప్రబు సెలవ్ దెయె నాయ్. గని, అబ్రాహామ్‍క సంతానుమ్ తెదొడి నెంజిలె కి, దేముడు జోక, పడ్తొక ఈంజ దేసిమ్‍చి బుఁయి తుచి సొంత ఆస్తి తుకయ్ దా గెలిందె. తుకయ్, చి తుచి పెట్టి జెర్మితసక; తుచి సెకుమ్‍చక; కెఁయఁక తెఁయఁక తతి రితి దా గెలిందె మెన జో ప్రబు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","“దేముడు జోవయింక అన్నె కిచ్చొ సంగిలన్ మెలె, తుమ్‍చి సెకుమ్‍తె పడ్తొక జెర్మితస ఏక్ కాలుమ్‍క, చెత్తర్ పుంజొ వెర్సులు వేరె దేసిమి స్రెమ తెన్ జితె తవుల, ఒత్త గొతిమాన్సుల్ జా జివుల. ");
INSERT INTO key_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","గని జా కాలుమ్‍క జేఁవ్‍క ఏలుప కెర్తి దేసిమ్‍చక ఆఁవ్ సిచ్చ కెరిందె. చి సిచ్చ కెర్లె, తుమ్‍చి సెకుమ్‍చక ఒత్త తెంతొ విడ్దల్ జా, బార్ జా ఇత్తల్ ఉట్ట జా, జిఁయ అంక బక్తి కెర్తె తవుల మెన ప్రబు వరుమ్ దా, ");
INSERT INTO key_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","అబ్రాహామ్‌చి సెకుమ్‍చ మున్సుబోదల్ ఎత్కిజిన్ జో దేముడుచ మాన్సుల్ జతి గుర్తుచి సున్నతి కెరనుక మెన అన్నెక్ ప్రమానుమ్ దిలొ. జాకయ్, అబ్రాహామ్ ఇస్సాకు జెర్మ అట్టు పొదుల్‍క జా గుర్తు కెర్తి సున్నతి కెర దిలొ. పడ్తొ ఇస్సాకు యాకోబుక పాయిలన్, చి యాకోబు పుత్తర్సుల్‍క పాయిలన్. జేఁవ్ బారజిన్ జలె, అమ్‍చి సెకుమ్‍క తొలితొచ వెల్లెల మాన్సుల్ జల. ");
INSERT INTO key_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“జలె, జేఁవ్ బారజిన్‍తె దెస్సుజిన్ అన్నసీంసి యోసేపు మెలొ జోవయించొ బావొస్‍క గోస జా, జా వాట్ అయ్‍లచి ఐగుప్తు దేసిమ్‍చొ మాన్సు ఎక్కిలొతె విక గెల. గని దేముడు జోక తోడు తా, ");
INSERT INTO key_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","జో సేడ్ల స్రెమల్ ఎత్కి తెంతొ రచ్చించుప కెర్లన్. చి ఐగుప్తు దేసిమ్‍చొ పరో రానొ, యోసేపుక దెక, చెంగిలొ మాన్సు, బుద్ది తిలొసొ ఈంజొ” మెన, జోక మెన్సిలన్, చి జోచి గెర్‍తె ఎత్కిచి ఉప్పిరి, ఒండి రాజిమ్‍చి ఉప్పిరి కి, ‘ఏలుప కెర్సు’ మెన జోక వెల్లొ కెర్లొ. ఒత్త రానొక పిట్టవ యోసేపుక కో వెల్లొ జతి నాయ్. ");
INSERT INTO key_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“జలె, యోసేపు ఒత్త ఏలుప కెర్తె తతికయ్, ఒండి ఐగుప్తు దేసిమి, జోచ అన్నసీంసి తిలి కనాను దేసిమి కి కరు అయ్‍లి. చి ఎత్కిజిన్ గొప్ప స్రెమల్ జల, చి అమ్‍చ పూర్గుల్‍క కతిసి కేన్ కి దొర్కు జయె నాయ్. ");
INSERT INTO key_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","గని, ‘ఒత్త ఐగుప్తు దేసిమి దాన్ తిఁయ అస్తి’ మెన అమ్‍చొ యాకోబు పూర్గుమ్‍చొ సూన తా, దాన్ గెన్న ఆన్‍తు మెన, పుత్తర్లు జల అమ్‍చ పూర్గుల్‍క ఒత్త తెద్రయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","దొయ్యెరి తెద్రయ్‍తికయ్, ఆఁవ్ తుమ్‍చొ బావొది మెన యోసేపు జోవయింక సంగిలన్. చి జా దీసి తెంతొ యోసేపుచి కుటుంబుమ్‍చ మాన్సుల్ రానొ జలొ పరో రానొ తెన్ అలవాట్ జల, ");
INSERT INTO key_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","చి అబ్బొసి జలొ యాకోబుక, జోచి కుటుంబుమ్‍చ ఎత్కిక, గెర్‍చ ఎత్కిక, ‘ఇత్తల్ జా కతు. జితు!’ మెన, యోసేపు సంగ తెద్రయ్‍లన్. యాకోబుచి కుటుంబుమ్‍చ, గెర్‍చ, కెత్తిజిన్ జవుల మెలె, డబ్బయ్ పాఁచ్‍జిన్. ");
INSERT INTO key_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","జలె, యాకోబు జోచ మాన్సుల్ ఎత్కిజిన్ తెన్ ఐగుప్తు దేసిమి ఉట్ట గెల. యాకోబు ఒత్త జిఁయ, ఒత్త మొర్లన్. జోచ పుత్తర్లు కి ఒత్త జిఁయ మొర్ల, చి ");
INSERT INTO key_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","జోవయింతె కో మొర్లె, కనాను దేసిమ్‍చి ‘సెకెము’ మెలి జేఁవ్ అగ్గె జితె తిలి బయిలు దేసిమ్‍తె పీనుమ్ వయన, రోవిల. కేన్ మెస్నె రోవిల మెలె, జా సుట్టు వెండి కాసుల్‍క ‘హమోరు’ మెలొ ఒత్తచొ మాన్సుతె అబ్రాహామ్ మెస్సున్ గెన తిలొ. జయ్యి మెస్నె రోవిల. ");
INSERT INTO key_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“జలె, జేఁవ్ ఐగుప్తు దేసిమి బస జా రమారమి చెత్తర్ పుంజొ వెర్సుల్ జలి పొది, ‘ఐగుప్తుతె జేఁవ్ నే ఉట్ట గెతె అగ్గె అబ్రాహామ్‍క సంగ తిలి దేసిమి అన్నె ఉట్ట గెతి సమయుమ్ జా అస్సె’ మెన దేముడు దెకిలన్. జా సమయుమ్ జా అయ్‍లి పొది, అమ్‍చి సెకుమ్‍చ జేఁవ్ బారజిన్ పుత్తర్సుల్‍చ మాన్సుల్ కెత్తిజిన్ జా తిల మెలె, ఒగ్గర్‍జిన్ జా జెర్మ అస్తి. ");
INSERT INTO key_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","జేఁవ్ దస్సి ఒగ్గర్ ఒగ్గర్‍జిన్ జా గెతికయ్, అగ్గెచ పరో మెల రానల్ మొర్తికయ్, నొవొ పరో ఏలుప కెర్తయ్. జో యోసేపుక నేన్లొసొ, జోచ మాన్సుల్‍క విరోదుమ్ జలొసొ. ");
INSERT INTO key_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","జో అమ్‍చ పూర్గుల్‍క మోసిమ్ కెర్లన్. కీసి మెలె, ‘జేఁవ్ జిలె ఒగ్గర్‍జిన్ జా అమ్‍క జీనుల’ మెన, ఎత్కిక మారుక మెన, జోవయించ నొవర్ జెర్మిల బోదల్‍క ‘దెర్ను సేడ్తు’ మెన, అబ్బదింసిచి అత్తి పరో స్రెమ కెర దిలన్. ");
INSERT INTO key_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“జేఁవ్ పొదులె మోసే జెర్మిలన్. దేముడు జోక ఒగ్గర్ ప్రేమ దెకిలన్, చి తిన్ని జొన్నొ ఎద జోవయించ అబ్బదింసి కీసి గే గెరి లుంకడ పోసిల. ");
INSERT INTO key_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","గని పడ్తొ, జోక అన్నె లుంకడుక నెత్ర కెర, అబ్బదింసి బార్ కెర్తికయ్, పరోచి దువిసి జోక ఉక్కుల గెరి నా, ‘సొంత పూత్తు’ మెలి రితి దెక, జోక పోసిలి. ");
INSERT INTO key_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","జా పోస, ఐగుప్తు దేసిమ్‍చ గ్యానుమ్ ఎత్కి పండితుల్‍చి అత్తి సికడ్లి, చి వడ్డిలె, జో ఒగ్గర్ తెలివి తెన్ లట్టబెదె, కేన్ కామ్ కెర్లె కి, తెలివి నిదానుమ్ కెరెదె. ");
INSERT INTO key_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“జలె, మోసేక దొన్ని విసొ వెర్సుల్ జలి పొది, ‘అంచ బావుడ్లు జల అమ్‍చ ఇస్రాయేలుల్‍తె గెచ్చ దెకిన్‍దె’ మెన ఉచర్లన్. ");
INSERT INTO key_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","జో గెలన్, అన్నె, జోవయింతె ఎక్కిలొక ఐగుప్తు దేసిమ్‍చొ ఎక్కిలొ పెట్లిసి దెకిలన్. దెక, జో దెబ్బల్ కయ్‍లొసొక తోడు గెచ్చ, దెబ్బల్ పెట్లొసొక పెట మార్లన్. ");
INSERT INTO key_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","దస్సి కెర కిచ్చొ ఉచర్లొ మెలె, అంక లోకుమ్ కెర్లొ అమ్‍చొ దేముడు జోచి అత్తి అమ్‍క రచ్చించుప కెరెదె” మెన అమ్‍చ ఇస్రాయేలులు అర్దుమ్ కెరనుల, మెన ఉచర్లొ, గని దస్సి ఉచర్తి నాయ్. ");
INSERT INTO key_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","అన్నెక్ దీసి, మోసే జా వాటు అయ్‍లె, ఇస్రాయేలులు దొగుల పెట్టపుట్టి జా అస్తి మెన దెక కెర, “సేంతుమ్ కెరయిందె” మెన ఉచర పాసి జా, కిచ్చొ మెలొ మెలె, “బావుడ్లు, తుమ్ ఎక్కి సెకుమ్‍చ మాన్సుల్, తుమ్ కిచ్చొక ఎక్కిలొ తెన్ ఎక్కిలొ జట్టి జా అస్సుస్?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","పుసితికయ్, తప్పు కెర్లొసొ మోసేక సొడి పెలవ దా కిచ్చొ మెలన్ మెలె, తుయి కొన్సొ? అమ్‍చి ఉప్పిరి తుక అదికారుమ్ నాయ్, అమ్‍క తీర్పు కెరుక తుక సెక్తి నాయ్. ");
INSERT INTO key_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","కాలి జో ఐగుప్తుచొ మాన్సుక తుయి పెట మార్ల దెబ్బల్ అంకయ్ ఆజి పెట్తె గె? మెన గగ్గొల్ జలొ. ");
INSERT INTO key_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","దస్సి సంగితికయ్, ‘అంక మారుల’ మెన, జా ఐగుప్తు దేసిమి తంక బియఁ కెర, మోసే ఉట్ట నిగ, దూరి తిలి బయిలు తిలి మిద్యాను మెలి దేసిమి ఉట్ట గెచ్చ, ఒత్త జితె తిలన్. ఒత్త తా, పెండ్లి జా దొగుల పుత్తర్సుల్‍క పాయిలన్. ");
INSERT INTO key_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“అన్నెక్ దొన్ని విసొ వెర్సుల్ గెతికయ్, ఏక్ దీసి, మోసే జా బయిలు టాన్‍చి సీనాయి డొంగ్రె తతికయ్, ఒత్త మాములుమ్ కంటొ రూకు అస్సె, రుక్కి ఆగి లగుక దెర్లి. ఆగి లగితొ జా రూకు తెడి, దేముడుచ దూత రితొ జా మోసేక డీసిలన్. ");
INSERT INTO key_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","మోసే దెక, ఆచారిమ్ జలొ. సరిగా దెకుక మెన ఇదిల్ పాసి గెచ్చుక దెర్లె, కిచ్చొ సూన్లొ మెలె, ");
INSERT INTO key_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘ఆఁవ్ తుచ పూర్గుల్‌చొ దేముడు. ఆఁవ్, అబ్రాహామ్‌చి, ఇస్సాకుచి, పడ్తొ యాకోబుచి, దేముడు.’ మెన సంగ, దేముడుచి అవాడ్ అయ్‍లి. దస్సి జతికయ్, మోసే బియఁ, అద్దుర్ జా, దెకుక దయిరిమ్ జలొ నాయ్. ");
INSERT INTO key_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","తెదొడి, ప్రబు జోక, ‘తుచ జోడ్లు కడను. తుయి టీఁవొ జలి టాన్ ఒగ్గర్ సుద్ది అస్సె. ");
INSERT INTO key_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","జేఁవ్ ఐగుప్తు దేసిమ్‍చ అంచ ప్రెజల్‍క కెర్త అల్లర్ స్రెమల్ ఆఁవ్ దెక అస్సి. జేఁవ్ ఏడ్తిసి సూన అస్సి, చి జోవయింక విడ్దల్ కెర బార్ కెరయిందె మెన, ఆఁవ్ ఉత్ర జా అస్సి. అప్పె, జే! జా కామ్‍చి రిసొ ఐగుప్తు దేసిమి తుక అన్నె తెద్రయిందె.’ మెన ప్రబు జలొ దేముడు మోసేక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“జో మోసేక జోవయించ మాన్సుల్, ‘అమ్‍చి ఉప్పిరి తుక అదికారుమ్ నాయ్. అమ్‍క తీర్పు కెరుక తుక సెక్తి నాయ్’ మెన అగ్గె సంగ తిల, గెద. గని జోవయింక ఏలుప కెరుక కి, జోవయింక విడ్దల్ కెర బార్ కెరుక కి మెన, రూక్‍తె డీసిలొ దూత పోలిక జలొసొచి అత్తి దేముడు జోకయి ఆడ్ర దా తెద్రయ్‍లొ. ");
INSERT INTO key_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ప్రబుచి అదికారుమ్ తెడి జోవయింక విడ్దల్ కెర, బార్ కెర, వాట్ దెకయ్‍తె తిలి పొది, ప్రబుచి సెక్తి తెన్ ప్రబు సంగిల కిచ్చొ కిచ్చొ వెల్లొ కమొ మోసే కెర్లన్. ఐగుప్తు దేసిమ్‍క నే ముల్తె అగ్గె కి, పడ్తొ ‘ఎరన’ సముద్రుమ్‍తె, పడ్తొ జేఁవ్ ప్రెజల్ ఎత్కిజిన్ తెన్ జేఁవ్ దొన్ని విసొ వెర్సుల్ జా బయిలు దేసిమి బుల్తె తిలి పొది కి. ");
INSERT INTO key_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“జలె, దేముడు అంకయ్ కీసి తెద్రయ్‍లన్ గే, జోచ కబుర్లు సూనయ్‍తి రిసొ, జోచి కామ్ జర్గు కెర్తి రిసొ, తుమ్‍చ ఇస్రాయేలుల్‍తెచొ అన్నెక్లొక పడ్తొక తెద్రవ టీఁవొ కెరెదె” మెన అమ్‍చ పూర్గుల్‍క సంగ తిలొసొ జో మోసేయి. ");
INSERT INTO key_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","అమ్‍చ పూర్గుల్ జల ప్రెజల్ ఎత్కి జట్టు తెన్ జా బయిలు దేసిమి బుల్తె తిలి పొది, దేముడుచొ దూత సీనాయి డొంగ్రె అన్నె డీస, మోసే తెన్ లట్టబ్లన్. చి దూతక చి అమ్‍చ పూర్గుల్‍క జో మోసే మదెనె జా, అమ్‍క దెంక మెన దేముడు సొంత రెగిడ్ల ఆగ్నల్, జీవ్ దెత ఆగ్నల్, జోతె నఙన్లన్. ");
INSERT INTO key_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“గని అమ్‍చ పూర్గుమ్‍చ, జో సంగిలి కోడు సూనుక నెస కెర, జోక దూరి కెర్లి రితి జా, జేఁవ్ ముల దిలి ఐగుప్తు దేసిమి తిలిస్‍క అన్నె కోర్‍ప జల, ");
INSERT INTO key_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","అన్నె, మోసే డొంగ్రె తెంతొ నే ఉత్ర జెతె అగ్గె, అహరోను మెలొ మోసేచొ అన్నొస్‍తె గెచ్చ కెర, అమ్‍క దేముడ్లు జా అమ్‍చి పుర్రెతొ గెచ్చ అమ్‍క వాటు దెకయ్‍తి రిసొ, అమ్‍క బొమ్మల్ తెయార్ కెరు. అమ్‍క ఐగుప్తు తెంతొ కడ ఆన్లొ జో మోసే కేనె ఉట్ట గెచ్చ అస్సె గే, ఆమ్ నేనుమ్ మెన ప్రెజల్ సంగిల. ");
INSERT INTO key_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","జేఁవ్ పొదులె కిచ్చొ కెర్ల మెలె, వస్సొ పిల్లచి రితిచి బొమ్మ ఏక్ తెయార్ కెర, జా బొమ్మక జొకర బలి దిల, చి జేఁవ్ కెర్లిస్‍చి రిసొ సర్ద కెరన్ల. ");
INSERT INTO key_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","జాచి రిసొ, జేఁవ్ పొద్దుక, జోనుక, సుక్కల్‍క జొకర్తి ఇస్టుమ్ తిలె, దస్సచక జొకర్తు! మెన దేముడు జోవయింక ముల, సిచ్చ దిలన్. దస్సి జలిస్‍చి రిసొ, జోవయించ కబుర్లు రెగిడ్లి దేముడుచి కొడొతె రెగ్డవ అస్సె. ఓ ఇస్రాయేలుచి సెకుమ్‍చ, తుమ్ బయిలు దేసిమి బుల్తె తిలి పొది, అంకయి గొర్రెల్ గట్ర కండ బలి దెతె తిలదు గె? ");
INSERT INTO key_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","నాయ్. ‘దేముడ్లు’ మెన వేరచక జొకరుక కోర్‍ప జా, ‘మొల్లొక’ దేముడు మెన, గుడి బంద జొకర్లదు. సుక్కొ గుర్తు తిలొ రొంపాయను మెలొసొక దేముడు మెన జొకర్లదు. దస్సచచ బొమ్మల్ కెర జొకర్లదు. తుమ్ దస్సి కెర్లి రిసొ, బబులోను దేసిమి ఒత్తల్‍తొ తుమ్ సర్ద నెంతె తతి రితి, తుమ్‍క ఒత్తచ మాన్సుల్ ఏలుప కెర్తు మెన, జేఁవ్ కడ నెత్తు, మెన సిచ్చ దెయిందె” మెన దేముడు రెగ్డ సిచ్చ దిలన్. ");
INSERT INTO key_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“జలె, జా బయిలు దేసిమి అమ్‍చ పూర్గుమ్‍చ బుల్తె తిలి పొది ఇదిలిసి దేముడుచి గుడి తిలి రితి, టంబుగుడ్డక తెయార్ కెర్లి దేముడుచి గుడి ముక్కిమ్‍క జోవయింతెన్ తిలి. ఇసి తెయార్ కెర” మెన దేముడు మోసేక కిచ్చొ సంగిలన్ గే, జో సంగిలి పోలిక, జో సంగిల సామన్లుక తెయార్ కెర్ల. ");
INSERT INTO key_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ఒత్త తెంతొ, మోసే మొర యెహోసువ మెలొసొ వెల్లొ జలి పొది, అమ్‍చ పూర్గుమ్‍చ బయిలు దేసిమ్‍క జీన ఈంజ దేసిమి ఉట్ట అయ్‍ల. దేముడు తోడు తతికయ్, ఒత్త జితె తిల వేర వేర సెకుమ్‍లుచ మాన్సుల్‍క అమ్‍చ పూర్గుమ్‍చ యుద్దుమ్ కెర ఉదడ గెల. తెదొడి కి, అమ్‍చ పూర్గుమ్‍చ జా గుడి వయ ఆన్ల. ఒత్త తెంతొ, అమ్‍చొ పూర్గుమ్‍చొ దావీదు రానొ తిలి ఎదక కి జయ్యి గుడితె దేముడుక బక్తి కెర్తె తిల. ");
INSERT INTO key_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","జో దావీదుక దేముడు ప్రబు ప్రేమ తిలొ, చి యాకోబు బక్తి కెర్తె తిలొ దేముడు ప్రబు కెఁయఁక తెఁయఁక తతి రితి దేముడుచి గుడి ఆఁవ్ జవుస్ బందిందె మెన దావీదు ఆస జా ఉచర తిలొ. ");
INSERT INTO key_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","దసొచొ బందుక మెన జో ప్రబు సెలవ్ దెయె నాయ్, చి దావీదుచొ పుత్తుసి సొలొమోను రానొ జలి పొది, జొయ్యి బందిలొ. ");
INSERT INTO key_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“గని, ఎత్కిచి కంట వెల్లొ తిలొ అమ్‍చొ దేముడు ప్రబు కేనె జితయ్ మెలె, మాన్సు తెయార్ కెర్ల గుడితె తయె నాయ్. జోచి కబుర్లు సంగిలొ పూర్గుమ్‍చొచి అత్తి రెగిడ్లి రితి; ");
INSERT INTO key_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","పరలోకుమ్ అంచి సిఙాసనుమ్. బూలోకుమ్ అంచ చట్టొ సుఁదితి పొద్రొ. జాకయ్, అంచి విలువచి దేముడుచి గుడి తూమ్ కీసి బందితె? అంచి రిసొ గేర్ బందిలె, ఎక్కి ఒత్త తయిందె గె? ");
INSERT INTO key_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","పరలోకుమ్ బూలోకుమ్ ఎత్కి అఁవ్వి జెర్మయ్‍లయ్, మెన, ఎత్కిచి కంట వెల్లొ తిలొ అమ్‍చొ ప్రబు రెగ్డ అస్సె.” మెన జోవయింక పరిచ్చ కెర్ల వెల్లెల మాన్సుల్‍క స్తెపను బుద్ది సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“పడ్తొ జోక పరిచ్చ కెర్త జేఁవ్ వెల్లెల మాన్సుల్‍క స్తెపను, తుమ్ రాడ్ జీవ్‌చ మాన్సుల్, దేముడు సంగిలి సుద్ది గుర్తుచి సున్నతి అమ్ కెరన అస్సుమ్ మెన తుమ్ సంగితసు, గని జా ఎత్కి తుమ్‍క కామ్‍క నెంజె. కిచ్చొక మెలె, తుమ్‍చి పెట్టి సుద్ది జసు నాయ్, తుమ్‍చ కానొ సూనుక నెసితి, చి దేముడుచి సుద్ది తిలి ఆత్మ సికడ్తిసి తుమ్ ఒప్పుస్ నాయ్. తుమ్‍చ పూర్గుమ్‍చ కీసి పాపుమ్ కెర్ల గే, తూమ్ కి దస్సి. ");
INSERT INTO key_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","జేఁవ్ పొదులె, దేముడు కచి కచి అత్తి కబుర్లు తెద్రయ్‍లె, తుమ్‍చ పూర్గుమ్‍చ జోవయింక అల్లర్ కెరుక, జో తెద్రయ్‍లసతె కక్క నే పిట్తె. పడ్తొ, ‘పరలోకుమ్‍చి పున్నిమ్ తిలొ క్రీస్తు రచ్చించుప కెర్తొసొ జెంక అస్సె’ మెన జోవయింతె కో సంగిల గే, జేఁవ్ తుమ్‍చ పూర్గుమ్‍చ జోక మారుక. దస్సి కి, జో క్రీస్తు జెతికయ్, తుమి జోక నెస, గోస కెర, జోక మార గెలదు. ");
INSERT INTO key_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","‘ప్రెజల్‍క సికడ్తు’ మెన దేముడు దూతల్‍చి అత్తి తుమ్‍కయ్ జోచ ఆగ్నల్ దిలన్, గని జోచ ఆగ్నల్ రితి తుమ్ ఇండుక నెస, దస్సి కెర్లదు” మెన అన్నె సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","జేఁవ్ వెల్లెల మాన్సుల్ ఈంజేఁవ్ కొడొ సూన, స్తెపనుచి ఉప్పిర్‍చి జేఁవ్‍చి కోపుమ్‌క రకుక నెత్ర కెర, దంతొ చప్లన్ల. ");
INSERT INTO key_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","జో, మాత్రుమ్, జోచి పెట్టి దేముడుచి సుద్ది తిలి ఆత్మ బెర తతికయ్, ఆగాసుమ్ పక్క చెంగిల్ దెక, కిచ్చొ దెకిలన్ మెలె, దేముడుచి ఉజిడి దెకిలన్, చి జో దేముడుచి ఉజెతొ పక్క యేసు టీఁవొజ దెకిలన్. ");
INSERT INTO key_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","జా దెక స్తెపను, “ఆదె, పరలోకుమ్ ఉగ్డి జలి రితి దెకితసి మెలె, మాన్సు జా జెర్మున్ అయ్‍లొ క్రీస్తు రచ్చించుప కెర్తొసొ దేముడుచి ఉజెతొ పక్క టీఁవొజ అస్సె.” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","జో దస్సి సంగితికయ్, జోవయించి కోపుమ్‍చి ఒర్స దా, జేఁవ్‍చి కంగ్డొ డంకన, జట్టు తెన్ జోచి ఉప్పిరి నిగ జా జోక దెర్ల. ");
INSERT INTO key_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","జోక పట్నుమ్ తెంతొ పెలవ దా బార్ కెర, జోక పత్రల్ గల మారుక దెర్ల. సాచి సంగ తిలస జోక పత్రల్ గలిలిస్‍తె బెదిల. పత్రల్ గలుక మెన, జేఁవ్‍చ ఉప్పిర్‍చ పాలల్ కడన కెర, సావులు మెలొ ఉబెడొ ఎక్కిలొచి చట్టె తిల. ");
INSERT INTO key_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","జేఁవ్ మాన్సుల్ పత్రల్ గల మార్తె తతికయ్, స్తెపను ఇసి మెన ప్రార్దన కెర్లన్. “ప్రబు జలొ ఓ యేసు, అంచి జీవు తూయి తుచితె కడ నే” మెన కెర, ");
INSERT INTO key_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","మొగ్రల్ టెక, గట్టిఙ అవాడ్ తెన్ ఒర్స దా అన్నె, “ప్రబువ, ఈంజేఁవ్ అప్పె కెర్తి పాపుమ్ ఇన్నెయింక చెమించుప కెరు!” మెన ప్రార్దన కెర మొర గెలన్. ");
INSERT INTO key_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","స్తెపను మొర్లిస్‍తె సావులు తిలన్. ‘మొర్సు’ మెన జో కి ఒప్పన తిలొ. జలె, జా దీసి తెంతొ, యెరూసలేమ్ పట్నుమ్‍తె యేసుక నంపజలస మొత్తుమ్‍క నంపనెంజిల యూదుల్ ఒగ్గర్ ఒగ్గర్ అల్లర్ కెరుక దెర్ల. అల్లర్ కెర జోవయింక ఉదడ్తికయ్, నంపజలసతె ఒగ్గర్‍జిన్ చెదుర్ప జల. చెదుర్ప జా ఒండి యూదయ ప్రదేసిమి చి సమరయ ప్రదేసిమి గెల. యేసుచ బారికుల్, మాత్రుమ్, యెరూసలేమ్‍తె తాఁ గెల. ");
INSERT INTO key_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","జా మదెనె, ప్రబుక సత్తిమ్ తిల యూదుల్ సగుమ్‍జిన్ స్తెపనుక రోవిల, ఏడుకులు జా ఒగ్గర్ దుకుమ్ తెన్ రోవిల. ");
INSERT INTO key_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","సావులు, మాత్రుమ్, యెరూసలేమ్‍తె క్రీస్తుక నంపజలసచి సంగుమ్‍క పాడ్ కెరుక ఉచర, జోవయింక ఒగ్గర్ ఒగ్గర్ అల్లర్ కెరుక దెర్లన్. జోవయించ గెరల్ ఎత్కితె గెచ్చ, పెస, జోవయించ మున్సుబోదల్‍క తేర్‍బోదల్‍క, ఎత్కిక దెర, జేల్‍తె గలయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","చెదుర్ప జల యేసుప్రబుక నంపజలస, జలె, కిచ్చొ కెర్తె తిల మెలె, జోచి రిసొచి సుబుమ్ కబుర్ సూనయ్‍తె తా బుల్తె తిల. ");
INSERT INTO key_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","తెదొడి బారజిన్ బారికుల్‍తె తిలొ పిలిప్ మెలొసొ, సమరయ ప్రదేసిమ్‍చి పట్నుమ్ ఏక్‍తె గెచ్చ, యేసుక్రీస్తు, ‘దొర్కు జలొ రచ్చించుప కెర్తొసొ జొయ్యి’ మెన ప్రెజల్‍క బోదన కెర్తె తిలన్. ");
INSERT INTO key_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ఒత్తచ ప్రెజల్ జోచి బోదన సూన్ల, అన్నె, జోచి అత్తి జర్గు జల యేసుప్రబుచి నావ్ తెన్ వెల్లొ కమొ దెక, ఒగ్గర్‍జిన్ ప్రెజల్ ఎక్కి ప్రేమ జా, జో సంగిలి బోదనక నంప కెర, యేసుక నంపజా గెల. ");
INSERT INTO key_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","కీస కమొ పిలిప్‍చి అత్తి జర్గు జల మెలె, బూతల్‍క ప్రబుచి నావ్ తెన్ ఉదడ్లె, జేఁవ్ బూతల్ ఓర్సుప జంక నెత్ర కెర, గట్టిఙ ఒర్స దా, పూర్తి ఉట్ట గెల. పడ్తొ ఉట్టుక నెతిర్ల మాన్సుల్, సొట్ట మాన్సుల్, చెంగిల్ జల. ");
INSERT INTO key_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","జాకయ్ జా ఒండి పట్నుమ్‍తె ఎత్కిజిన్ సర్ద జల. ");
INSERT INTO key_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ఏక్ పట్నుమ్‍తె సీమోను నావ్ తిలొ మాన్సు జా. జో అగ్గె, జా పట్నుమ్‍తె, మంత్రుమ్ కెర్తస కిచ్చొ కిచ్చొ మాయచ గారెడ్లు కెర్తె తిలన్. కిచ్చొ కిచ్చొ వెల్లొ కమొ కెర, ‘ఆఁవ్ వెల్లొ’ మెనన, సమరయ ప్రదేసిమ్‍చ ఎత్కిజిన్‍క ఆచారిమ్ కెరెదె. ");
INSERT INTO key_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","జోచ కమొ దెక, “దేముడుచి వెల్లి సెక్తి తిలొసొ ఈంజొ” మెన, బాల వెల్లొ జా ప్రాంతుమ్‍చ ఎత్కిజిన్ జోక నంపజా తిల. ");
INSERT INTO key_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","కిచ్చొక జోక దస్సి నంపజా మోసిమ్ జా తిల మెలె, జో ఒగ్గర్ వెర్సులు సయ్‍తాన్‍చ దస కమొ కెర కెర జోవయింక ఆచారిమ్ కెర్తె తిలన్. ");
INSERT INTO key_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","గని, దేముడుచి రాజిమ్‍చి రిసొ, యేసుక్రీస్తుచి అదికారుమ్‍చి రిసొ, పిలిప్ ప్రెజల్‍క బోదన కెర్తె తతికయ్, జోచ కొడొక నంపజా గెచ్చ కెర, తేర్‍బోదల్ కి మున్సుబోదల్ కి, బాప్తిసుమ్ నఙన్ల. ");
INSERT INTO key_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","సయ్‍తాన్‍చ కమొ కెర్తొ జో సీమోను కి నంపజా, బాప్తిసుమ్ నఙన, పిలిప్‍చి పట్టి బులుక దెర్లన్, అన్నె, యేసుప్రబుచి అదికారుమ్ తెన్ కెర్ల వెల్లొ కమొ, జొర్జొల్ బాదల్ జల మాన్సుల్ చెంగిల్ జలిసి దెక దెక, జో కి బలే ఆచారిమ్ జలొ. ");
INSERT INTO key_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","జలె, సమరయచ మాన్సుల్ దేముడు దిలి యేసుప్రబుచి రిసొచి సుబుమ్ కబుర్ సూన నంపజా అస్తి మెన యెరూసలేమ్‍తెచ బారజిన్ బారికుల్ సూన కెర, ‘జోవయింతె గెచ్చ దెకుత్’ మెన, పేతురుక చి యోహానుక తెద్రయ్‍ల. ");
INSERT INTO key_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","జేఁవ్ దొగుల ఒత్త పాఁవ కెర, నంపజలసక ‘దేముడుచి సుద్ది తిలి ఆత్మ జేఁవ్‍చి పెట్టి దొర్కు జవుస్’ మెన ప్రార్దన కెర్ల. ");
INSERT INTO key_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","కిచ్చొక మెలె, తెదొడి ఎద ఎక్కి యేసుప్రబుచి నావ్ తెన్ పానితె బాప్తిసుమ్ నఙన తిల. జోచి ఆత్మచి నావ్ తెన్ నేతయ్, చి ఆత్మసెక్తి జేఁవ్‍క దొర్కు జంక నేతయ్. ");
INSERT INTO key_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","జలె, తెదొడి పేతురు చి యోహాను జేఁవ్ నంపజల ప్రెజల్ ఎత్కిజిన్ ఎక్కెక్లక బోడి చడిల, చి దేముడుచి సుద్ది తిలి ఆత్మసెక్తి జోవయింక దొర్కు జలి. ");
INSERT INTO key_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","జలె, ‘యేసుచ బారికుల్ బోడి చడ్లెగిన, నంపజల మాన్సుల్‍క దేముడుచి సుద్ది తిలి ఆత్మ దొర్కు జతయ్’ మెన మంత్రుమ్ కెర్తె తిలొ సీమోను దెక కెర, ");
INSERT INTO key_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“అంక కి జా సెక్తి దా, డబ్బుల్ దెయిందె. ఆఁవ్ కి కక్క బోడి చడిందె గే, జోక కి దేముడుచి సుద్ది తిలి ఆత్మసెక్తి దొర్కు జలి రితి, జా సెక్తి అంక దా” మెన పేతురుక చి యోహానుక సీమోను సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","సంగితికయ్, పేతురు, జోక “‘డబ్బుల్ దిలె దేముడు దెతి జోచి సుద్ది తిలి ఆత్మసెక్తి వరుమ్ గెనుక జయెదె’ మెన తుయి ఉచర్లి రిసొ, తుచి డబ్బుల్ తుచి తెన్ నాసెనుమ్‍తె గెస్సు! ");
INSERT INTO key_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","తుచి పెట్టి దేముడు తెన్ సత్తిమ్ జంక నాయ్, చి జోచి ఈంజ కామ్‍తె తుయి బెదుక జయె నాయ్. ");
INSERT INTO key_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","తుయి ఉచర్లి వెల్లి ఈంజ పాపుమ్ చెమించుప జంక తుయి కోర్‍ప జతసి జలె, జోచి దయ తిలె తుక రచ్చించుప కెర్సు మెన, తుయి కెర్లి గార్ కామ్ ముల దా, పెట్టి పూర్తి దుకుమ్ జా జోక ప్రార్దన కెర సంగు. జో కిచ్చొ కెరెదె గే జోచి దయ. ");
INSERT INTO key_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","సయ్‍తాన్‍చ పాపుమ్‍బుద్ది అప్పెక తుచి పెట్టి ఏలుప కెర్తయ్, అప్పెక తుచి పెట్టి ఆసల్ గోసల్ అస్తి మెన ఆఁవ్ దెకితసి” మెన పేతురు సీమోనుక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","జలె, సీమోను బియఁ గెచ్చ కిచ్చొ మెన బతిమాల్ప జా సంగిలన్ మెలె, “తుయి సంగిలి సిచ్చ అంచి ఉప్పీర్ నే జెతు మెన తుమి ప్రబుక ప్రార్దన కెరు.” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","పేతురు, యోహాను, జలె, యేసుప్రబుచి రిసొ సాచి సంగ, జోచి సుబుమ్ కబుర్ సూనవ కెర, ఒత్త తెంతొ అన్నె బార్ జా, సమరయచ ఒగ్గర్ ఒగ్గర్ గఁవ్విలె గెచ్చ, బుల బుల, ప్రబుచి సుబుమ్ కబుర్ సంగ బోదన కెర్తె తా, యెరూసలేమ్‍తె అన్నె పాఁవ అయ్‍ల. ");
INSERT INTO key_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","మదెనె, ప్రబుచొ దూత ఎక్కిలొ పిలిప్‍తె జా కెర, “తుయి ఉట్ట ఇన్నె తెంతొ బార్ జా, దచ్చెన పక్కచి వట్టె, మెలె యెరూసలేమ్ తెంతొ గాజా పట్నుమ్ ఎద పాఁవితి వట్టె గో” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","పిలిప్ సూన, బార్ జా, జా వట్టె గెలన్. జా వట్టె గెతె తతికయ్, ఐతియొపీయు దేసిమ్‍చొ ఆండెరొ జా వాట్ జెతె అస్సె. జో ఐతియొపీయు దేసిమ్‍చి ‘కందాకె’ మెలి రానిచొ ఆదికారి, డబ్బుల్ దెకితొ ఆదికారి జా అస్సె. దేముడుక బక్తి కెరుక మెన, జో యెరూసలేమ్‍తె జా తిలొ. ");
INSERT INTO key_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","అప్పె అన్నె జోచి సొంత దేసిమి ఉట్ట గెతె అస్సె. జోచి రదుమ్‍తె వెస తా, దేముడుచ కబుర్లు సంగిలొ యెసయా పూర్గుమ్‍చొచి అత్తి రెగిడ్లి పుస్తకుమ్ సదు కెర్తె అస్సె. ");
INSERT INTO key_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","జలె, ప్రబుచి ఆత్మ పిలిప్‍చి ఆత్మతె, “తుయి దెకితి రదుమ్‍క పాసి గెచ్చ దెకు” మెన సంగితికయ్, ");
INSERT INTO key_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","పిలిప్ జా రదుమ్‍తెచొ నిగ గెచ్చ, యెసయా పూర్గుమ్‍చొచి అత్తి రెగిడ్లిసి పుస్తకుమ్ జో సదు కెర్తిసి సూన కెర, జోక, “తుయి సదు కెర్తిసి తుక అర్దుమ్ జెతయ్ గె?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","“కో జవుస్ అంక అర్దుమ్ సంగిలెకయ్ అంక కీస్ అర్దుమ్ జయెదె?” మెన జో సంగిలన్, చి ‘అర్దుమ్ సంగుస్’ మెన, రదుమ్‍తె పిలిప్‍క వెగడ వెసడ్లన్. ");
INSERT INTO key_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","దేముడుచి కేన్ కోడు జో సదు కెర్తె తిలొ మెలె, “మెండక కండ బలి కెర్తి రిసొ ఉదడ నెత్తి రితి జోక ఆన్ల, నెంజిలె రోమల్ కత్రయ్‍తి మొక్మె మెండపిల్ల కీసి జమ్‍న తయెదె గె దస్సి ఈంజొ కి చోండి డంకన తుక్లె తయెదె. ");
INSERT INTO key_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ఇన్నెచి విలువ కడ్ల, చి ఇన్నెచి రిసొ సరిగా తీర్పు జతి రితి ఒప్పితి నాయ్. ఇన్నెక ‘బోదల్ పాయ్‍లన్’ మెన కీసి సంగుక జయెదె? ఇన్నెక ఈంజ బూలోకుమ్‍తె జేఁవ్ మార్ల!” ");
INSERT INTO key_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","జో ఆండెరొ, పిలిప్‍క కిచ్చొ మెన పుసిలన్ మెలె, “దేముడు ప్రబుచ కబుర్లు సంగితొ జో పూర్గుమ్‍చొ కచి రిసొ ఇసి సంగితయ్? జోచి సొంతచి రిసొ గే, కేన్ జవుస్ వేర మాన్సుచి రిసొ గె?” మెన పుసితికయ్, ");
INSERT INTO key_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","పిలిప్ చోండి పుట్టవ, జో ఆండెరొ సదు కెర్తె తిలి కోడుచి అర్దుమ్ తొలితొ సంగ, యేసుచి రిసొచి సుబుమ్ కబుర్ ఎత్కి జోక బోదన కెర్లన్. ");
INSERT INTO key_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","తెదొడి, జేఁవ్ దొగుల వట్టె గెతె తా పాని గాడు ఏక్ దెకిల. దెక, “ఆదె, పాని! ఆఁవ్ బాప్తిసుమ్ నఙనుక కిచ్చొ అడ్డు కిచ్చొగె, నాయ్ గద?” మెన జో ఆండెరొ సర్ద జా సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","పిలిప్ జోక “తుయి యేసుప్రబుక పెట్టి పూర్తి నంపజలది మెలె, బాప్తిసుమ్ నఙనుక జయెదె.” మెన సంగితికయ్, “యేసుక్రీస్తు దేముడు ప్రబుచొ పుత్తుసి, జలొ దొర్కు జలొ రచ్చించుప కెర్తొసొ జయెదె మెన ఆఁవ్ నంపజతసి.” మెన ఆండెరొ సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","తెదొడి రదుమ్‍క జో టీఁవొ కెర, పిలిప్ ఆండెరొ దొగుల ఉత్ర పానితె ఉతిర్ల, చి జో ఆండెరొక పిలిప్ బాప్తిసుమ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","తెదొడి, జేఁవ్ పానితె తెంతొ అన్నె బార్ జతికయ్, ప్రబుచి ఆత్మ పిలిప్‍క దెర నిలన్, చి ఆండెరొ జోక అన్నె నే దెకిలన్. జో ఒగ్గర్ సర్దసంతోసుమ్ తెన్ సొంత దేసిమి ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","పిలిప్ ఒత్త తెంతొ అజోతు మెలి పట్నుమ్‍తె డీసిలన్. ఒత్త డీస కెర బార్ జా, ఉత్తర పక్క గెతి వట్టె గెచ్చ గెచ్చ, ఎత్కి పట్నలె గఁవ్విలె ప్రబుచి సుబుమ్ కబుర్ సూనవ సూనవ, కైసరియ పట్నుమ్‍తె పాఁవిలన్. ");
INSERT INTO key_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","స్తెపనుక మార్లిస్‍తె తెదొడి బెద తిలొ సావులు, ఈంజ మదెనె కిచ్చొ కెర్తె తిలొ మెలె, యేసుప్రబుక నంపజా జోవయించ సిస్సుల్ జలసక ‘మారిందె’ మెన బియడ్తె తిలొ. జలె, కిచ్చొ కెర్లొ మెలె, యెరూసలేమ్‍తె ఎత్కిక వెల్లొ పూజరితె గెచ్చ కెర, ");
INSERT INTO key_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","“దమస్కు పట్నుమ్‍తెచ అమ్‍చ యూదుల్‍చ సబ గెరల్‍చ అదికారుల్‍క ఆఁవ్ దెకయ్‍తి రిసొ అంక ఉత్రల్ దె, చి ఆఁవ్ ఒత్త గెచ్చ, ‘రచ్చన వాటు యేసుయి’ మెన జోవయింక నంపజలసక చజిలె, జేఁవ్ తేర్‍బోదల్ జలెకి, మున్సుబోదల్ జలెకి, జోవయింక దెర బంద, ఇత్తల్ అమ్‍చి యెరూసలేమ్‍తె సిచ్చ కెరుక మెన కడ ఆనిందె” మెన సెలవ్ సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","జలె, సావులు ప్రయానుమ్ గెతె తా దమస్కు పట్నుమ్‍క పాసి అయ్‍లి పొది, ఓదె, ఆగాసుమ్ తెంతొ అంకి అందర్ కెర ఉజిడి జోచి సుట్టునంత జా అడ్డు కెర్లి. ");
INSERT INTO key_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","చి జో బుఁయ్యె సేడ నిజ తిలి పొది ఏక్ అవాడ్, “ఓ సావులు, సావులు, అంక కిచ్చొక సిచ్చల్ అల్లర్ కెర్తసి?” మెన సంగిలిసి సూన్లన్. ");
INSERT INTO key_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","బియఁ గెచ్చ, “తుయి కో, ప్రబు?” మెన జో పుసిలన్, చి “తుయి గోస కెర్తొ యేసు, ఆఁవ్. ");
INSERT INTO key_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","అల్లె, తుయ్ ఉట్ట ఈంజ పట్నుమ్‍తె గెచ్చ పెసు, చి ఒత్త తెంతొ తుయి కిచ్చొ కెరుక అస్సె గే, తుక సూనయిందె” మెన యేసు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","సావుల్ తెన్ బెద ప్రయానుమ్ కెర్తె తిల మాన్సుల్, జలె, జా అవాడ్ సూన్ల, గని కక్క నే దెక, కిచ్చొ మెనుక నెత్ర కెర, టక్కున జా తిల. ");
INSERT INTO key_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","సావులు, మాత్రుమ్, బుఁయి తెంతొ ఉట్ట, టీఁవొజ, అంకివొ ఉగిడ్లె, కిచ్చొ దెకుక నెతిర్లొ. జాకయ్ జేఁవ్ జోక ఆతు దెర, దమస్కు పట్నుమ్ తెడి ఇండవ నిల. ");
INSERT INTO key_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ఒత్త తిర్రతి, కిచ్చొ నే కతె, కిచ్చొ నే పితె చువ్వె తా గుడ్డి జా తిలొ. ");
INSERT INTO key_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","జలె, జా దమస్కు పట్నుమ్‍తె యేసుక నంపజలొ నిదానుమ్ తిలొ సిస్సుడు ఎక్కిలొ తిలొ. జోచి నావ్ అననీయ. జలె, యేసు సివ్నతె జోక డీస కెర, జోచి నావ్ దెర్తికయ్, జో “అస్సి, ప్రబు” మెన జబాబ్ దిలన్, ");
INSERT INTO key_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ప్రబు జోక, “తుయి ఉట్ట, సోగ మెలి వీది గో, చి యూదా మెలొ ఎక్కిలొచి గెరి గెచ్చ, ‘తార్సు పట్నుమ్‍తె జెర్మిలొ సావులు మెలొసొ తెన్ దస్సుల్ జయిందె’ మెన సంగు. జో జా గెరి తా ప్రార్దన కెర్తె అస్సె. ");
INSERT INTO key_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","జో ప్రార్దన కెర్తె తతికయ్, జోక కిచ్చొ సివ్న దెకవ అస్సి మెలె, అననీయ మెలొ ఎక్కిలొ జో సావులు తిలి గెరి జా కెర, పెస, జోక ‘అన్నె దెకుస్’ మెన జోచి బోడి చడెదె మెన, ఆఁవ్ సావుల్‍క సివ్న దెకవ అస్సి” మెన ప్రబు జో అననీయక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","గని అననీయ బియఁ కెర, “జో మాన్సుచి రిసొ ఒగ్గర్‍జిన్ సంగ అస్తి, యెరూసలేమ్‍తె తిల తుచయ్ సుద్ది తిల మాన్సుల్‍క జో ఎదివాట్ అల్లర్ కెర అస్సె. ");
INSERT INTO key_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","జో ఇత్తల్ అయ్‍లె, తుచి నావ్ దెర్తస ఎత్కిక దెర, బందుక మెన ఎత్కిక వెల్లెల పూజర్లు జోక సెలవ్ దా అస్తి” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","గని ప్రబు జోక, “ఒత్త గో, ‘యూదుల్ నెంజిల వేర దేసిమ్‍చ మాన్సుల్‍క, రానల్‍క, ఇస్రాయేలుల్‍క కి, అంచి నావ్ తెన్ అంచి రిసొ సాచి జవుస్’ మెన ఆఁవ్ జోక నిసాన అస్సి. ");
INSERT INTO key_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","జో కి అంచి నావ్ అంచి కామ్‍చి రిసొ ఎత్తివాట్ అల్లర్ బాదల్ సేడెదె. జోక జా ఎత్కి దెకయిందె” మెన ప్రబు జబాబ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ప్రబు దస్సి సంగితికయ్, అననీయ బార్ జా గెచ్చ, ప్రబు సంగిలొ గెరి పెస, సావుల్‍క బోడి చడ, “ఓ సావులు బావొ, తుయి వట్టె జెతె తతికయ్ తుక డీసిలొ యేసు తుక ‘దెకుస్’ మెన, దేముడుచి సుద్ది తిలి ఆత్మ తుచి పెట్టి తతి వరుమ్ తుక దొర్కు జవుస్ మెన అంక ఇన్నె తెద్రవ అస్సె” మెన అననీయ సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","సంగిల్ బేగి, సావుల్‍చ అంకివొ తెంతొ పొరల్ రితస కుసిడ్ల, చి జోచ అంకివొ అన్నె డీసిల. తెదొడి జో ఉట్ట, బాప్తిసుమ్ నఙన, ");
INSERT INTO key_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","అన్నిమ్ కెర, అన్నె సత్తు జలొ. ఒత్త తెంతొ, సావులు జా దమస్కు పట్నుమ్‍తె యేసుక నంపజల సిస్సుల్ తెన్ సగుమ్ దీసల్ తాఁ గెలొ, ");
INSERT INTO key_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","చి బేగి జోవయించ సబ గెరలె యేసుచి రిసొ కిచ్చొ సాచి సంగితె తిలన్ మెలె, “నిజుమి, అమ్‍చొ దేముడుచొ ఎక్కిలొ పుత్తుస్ దొర్కు జలొ రచ్చించుప కెర్తొసొ, జో” మెన సాచి సంగిత్ తిలన్. ");
INSERT INTO key_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","సావులుక, ‘జో ఇసి సాచి సంగితయ్’ మెన సూన, ఎత్కిజిన్ ఆచారిమ్ జా, “యెరూసలేమ్ పట్నుమ్‍తె ప్రబుచి నావ్ దెర్తస ఎత్కిజిన్‍క అగ్గె అల్లర్ కెర్తె తిలొసొ ఈంజొ, నెంజె గే? ఇన్నెచ నంపజలసక ఎత్కిక వెల్లెల పూజర్లుచి తీర్పు కెర సిచ్చ కెరవుక మెన దెర బందుక ఉచర, ఇత్తల్ అయ్‍లొ” మెన కిచ్చొ ఉచరుక గే నేన గెల. ");
INSERT INTO key_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","జలె, సావుల్‍క రోజుక ప్రబు అన్నె సెక్తి దిలొ, చి దమస్కుతె జితె తిల యూదుల్‍చ సబతె జో బోదన కెర కెర, యేసుక, ‘నిజుమి దొర్కు జలొ క్రీస్తు రచ్చించుప కెర్తొసొ జో’ మెన తెలివి తెన్ రుజ్జుల్ బెదయ్‍తె తిలొ, చి నంపనెంజిల యూదుల్ కిచ్చొ జబాబ్ దెంక గే నేన గెల. ");
INSERT INTO key_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ఒగ్గర్ దీసల్ గెతికయ్, సావుల్‍క మారుక మెన యూదుల్‍చ వెల్లెల మాన్సుల్ కుట్ర ఉచర్ల, ");
INSERT INTO key_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","గని జేఁవ్ కుట్ర ఉచర్లిస్‍చి రిసొ సావులు సూన్లొ. జోక మారుక మెన రోజుక అందరె మెద్దెనె పట్నుమ్‍చ గుమ్మలె మాన్సుల్ రకితె తవుల, చి రిసొ, ");
INSERT INTO key_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","జోచ సిస్సుల్ కిచ్చొ కెర్ల మెలె, ఏక్ దీసి అందరె జోక బొడొవ దా, పట్నుమ్‍చి డోంక్ తిలి కోటతెచి గదితె వెగడ దా, ఏక్ గంపతె వెసడ దా, కిట్కివాట్ వాలివొ తెన్ కోట ఒత్తల్‍తొ ఉత్రవ దిల, చి ఉట్ట నిగిలొ. ");
INSERT INTO key_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","జలె, సావులు, యెరూసలేమ్ పట్నుమ్‍తె పాఁవ జా, ప్రబుచ ఒత్తచ సిస్సుల్ తెన్ బెదుక ఉచర్లొ, గని జోవయింక “నిజుమి, మార్సుప జా ప్రబుచొ సిస్సుడు జా అస్సె” మెన నంప కెర్తి నాయ్, చి బియఁ గెల. ");
INSERT INTO key_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","గని బర్నబా మెలొసొ సావుల్‍క తోడు జా, బారికుల్‍తె కడ ఆన కెర, సావులు వట్టె గెతె తిలి పొది ప్రబుక దెకిలిసి, ప్రబు జో తెన్ లట్టబ్లిసి, పడ్తొ దమస్కుతె సావులు దయిరిమ్ తెన్ యేసుచి నావ్ తెన్ బోదన కెర్లిసి ఎత్కిచి రిసొ బర్నబా బారికుల్‍క సాచి సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","జాకయ్ జా దీసి తెంతొ యెరూసలేమ్‍తెచ ప్రబుచ జేఁవ్ బారికుల్ జోక సర్ద తెన్ బెదవన్ల, చి జోవయింతెన్ తా, రోజుక ");
INSERT INTO key_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ప్రబుచి నావ్ తెన్ దయిరిమ్ తెన్ బోదన కెర్తె తిలన్. పడ్తొ, యేసుక నే నంపజల గ్రీకు బాస లట్టబ్తె యూదుల్‍క ప్రబుచి సాచి సావులు సంగితె తిలన్. రుజ్జుల్ బెదయ్‍తె తిలన్, గని జేఁవ్ జోక మారుక కోర్‍ప జా తిల. ");
INSERT INTO key_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","జోక జేఁవ్ మారుక కోర్‍ప జలిస్‍చి రిసొ సిస్సుల్ మెన కెర, జోక కైసరియ పట్నుమ్ ఎదక బొడొవ దాఁ కెర, ఓడతె వెగడ, జో జెర్మిలి తార్సు పట్నుమ్‍తె తెద్రవ దిల. ");
INSERT INTO key_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","జలె, సావులు నంపజా మార్సుప జలిస్‍చి రిసొ, జేఁవ్ పొదులె, ఒండి యూదయ ప్రదేసిమి, గలిలయ ప్రాంతుమ్‍తె చి సమరయ ప్రదేసిమ్‍తె యేసుక నంపజలసక కో అల్లర్ కెర్తి నాయ్, చి అన్నె డిట్టుమ్ జల. ప్రబుక బియఁ సత్తిమ్ ఇండితె తిల, చి దేముడుచి సుద్ది తిలి ఆత్మ జోవయింక దయిరిమ్ కెర్తె తిలి, చి అన్నె ఒగ్గర్‍జిన్ నంపజా, జోవయింతెన్ బెదిల. ");
INSERT INTO key_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","జేఁవ్ పొదులె, పేతురు ఒండి బుల్తె తా, నంపజలస ఎత్కిజిన్‍క దెకితె తిలొ, చి లుద్ద మెలి ఏక్ పట్నుమ్‍తె ప్రబుచయ్ జల మాన్సుల్ జితె తిలిస్‍తె జో తెన్ అయ్‍లొ. ");
INSERT INTO key_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ఐనెయ మెలొ ఎక్కిలొ అస్సె. జో ఉట్టుక, కదుల్ జంక నెత్ర కెర, అట్టు వెర్సుల్ అంతుర్నొతె ఎంగ్డ అస్సె. ");
INSERT INTO key_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","పేతురు, జలె, జోక దెక, “ఓ ఐనెయ, యేసుక్రీస్తు తుక చెంగిల్ కెర్తయ్. ఉట్ట, తుచి అంతుర్నొ చెంగిల్ కెరను” మెన సంగిలన్. సంగిలి బేగి, జో చెంగిల్ జా ఉట్లొ. ");
INSERT INTO key_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","జో చెంగిల్ జలిసి, లుద్ద పట్నుమ్‍చ జా సారోను ప్రాంతుమ్‍చ ఎత్కిజిన్ దెక, జోవయింతె ఒగ్గర్‍జిన్ ప్రబుక నంపజా మార్సుప జల. ");
INSERT INTO key_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","జలె, యొప్పే మెలి పట్నుమ్‍తె తబితా, నెంజిలె దొర్కా మెలి నావ్‌చి తేర్‍బోద యేసుక సిస్సుడ్ని జా అస్సె. జా కీసి మాన్సు మెలె, మాన్సుల్‍క ఒగ్గర్ ప్రేమ దెకితె తయెదె, బీద సుదల్‍క ఒగ్గర్ తోడు కెర్తె తయెదె. ");
INSERT INTO key_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ఏక్ దీసి, జొర్జొ సేడ మొర గెలి. జాక దోవ కెర సుబ్రుమ్ కెర, గెర్‍చి అంతస్తుమ్‍చి గదితె పీనుమ్ నిజడ దిల. ");
INSERT INTO key_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","యొప్పే మెలి జా మాన్సు మొర్లి పట్నుమ్‍క పేతురు తిలి లుద్ద పట్నుమ్ దూరి నాయ్, చి పేతురుక ‘ఒత్త అస్సె’ మెన సిస్సుల్ సూన తా, “బే బేగి జె” మెన దొగులచి అత్తి సంగ తెద్రయ్‍ల. ");
INSERT INTO key_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","పేతురు బేగి ఉట్ట, జోవయింతెన్ గెలన్. జా గెరి జో పాఁవిలె, జోక జా ఉప్పిరిచి గదితె బొడొవ దిల. ఒత్త జా పట్నుమ్‍చ రండెల్ మాన్సుల్ బెర అస్తి. జేఁవ్ పేతురుచి సుట్టునంత టీఁవ ఏడ ఏడ, జా మొర గెలి దొర్కా చెంగిల్ తిలి పొది ‘బీద సుదల్’ మెన, జోవయింక తున తిల పాలల్ ఎత్కి పేతురుక దెకయ్‍ల. ");
INSERT INTO key_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","పేతురు, జలె, జేఁవ్ ఎత్కిజిన్‍క బార్ కెరవ దా, మొగ్రల్ టెక ప్రబుక ప్రార్దన కెర్లన్. తెదొడి, పీనుమ్‍క దెకిత్ రితి పసుల, “ఓ తబితా, ఉట్టు!” మెన జాక సంగిలన్. సంగితికయ్, అంకివొ ఉగిడ్లి, చి పేతురుక దెక, వెసిలి. ");
INSERT INTO key_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","పేతురు జాక ఆతు దెర టీఁవడ్లొ, చి రండెల్ మాన్సుల్‍క చి ప్రబుచయ్ జల ఒత్త తిల అన్నె మాన్సుల్‍క బుకారా కెర, ‘జీవ్ జా అస్సె’ మెన దెకయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","జా ఒండి యొప్పే ప్రాంతుమ్‍తెచ మాన్సుల్ జేఁవ్‍చి రిసొ సూన్ల, చి జోవయింతె ఒగ్గర్‍జిన్ ప్రబుక నంపజల. ");
INSERT INTO key_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","పడ్తొ పేతురు ఒత్త చమొ పికయ్‍తొ సీమోను మెలొ ఎక్కిలొచి గెరి ఒగ్గర్ దీసల్ తా గెలన్. ");
INSERT INTO key_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","కైసరియ పట్నుమ్‍తె కొర్నేలీ మెలొ మాన్సు ఎక్కిలొ తిలొ. రోమ్ దేసిమ్‍చి జమాన్లుతెచి ఇటలీ మెలి జటుచొ పుంజెక్‍జీన్ జమాన్లుక వెల్లొ, జో. ");
INSERT INTO key_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","కీసొ మాన్సు మెలె, జో యూదుడు నెంజిలె కి, దేముడుక బియఁ, నిదానుమ్ తెన్ ఎక్కి జోకయి బక్తి కెర్తె తిలొ. జోకయి ప్రార్దన కెర్తె తిలొ చి యూదుల్‍చ బీద సుదల్‍క చెంగిల్ దెక దర్ముమ్ దెతె తయెదె. జోచి గెర్‍చ మాన్సుల్ ఎత్కిజిన్ కి దస్సి తిల. ");
INSERT INTO key_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ఏక్ దీసి, రమారమి తిన్ని గంటల్ మెద్దెనె, ప్రబు దెకయ్‍లి సివ్న ఏక్ దెకిలన్. కిచ్చొ మెన జా సివ్నతె సొస్టుమ్ దెకిలన్ మెలె, దేముడుచొ దూత ఎక్కిలొ జా గెరి పెస, జోక, “ఓ కొర్నేలీ” మెన బుకార్తికయ్, ");
INSERT INTO key_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","కొర్నేలీ అద్దుర్ జా దెక, “ప్రబువ, ఈంజ కిచ్చొ?” మెన పుసిలన్, చి దూత జోక “తుచ ప్రార్దనల్ సూన, బీద సుదల్‍క తుయి దర్ముమ్ దిలిస్ దేముడు దెక, సర్ద జా అస్సె. ");
INSERT INTO key_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","తుయి అప్పె కిచ్చొ కెరుక అస్సె మెలె, యొప్పే పట్నుమ్‍తె మాన్సుల్‍క కబుర్ తెద్రవు, చి పేతురు మెలొ సీమోనుక ఇత్తల్ కడ ఆను. ");
INSERT INTO key_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","జోక ఒత్త కేనె చజుక మెలె, చమొ పికయ్‍తొ సీమోను మెలొ ఎక్కిలొతె తయెదె. జోచొ గేరు సముద్రుమ్ సొడి తయెదె” మెన దూత సంగ ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","కబుర్ సంగిలొ జో దూత ఉట్ట గెతికయ్, కొర్నేలీ దొగుల జోచ గోతు మాన్సుల్‍క, చి దేముడుక నిదానుమ్‍చొ జోచి తెడి తిలొ జమాను సుదొ ఎక్కిలొక బుకారా కెర, ");
INSERT INTO key_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","దూత డీసిలిసి సంగిలిసి ఎత్కి జోవయింక సంగ కెర, యొప్పేతె జోవయింక కబుర్ తెద్రయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","అన్నెక్ దీసి, జేఁవ్ మాన్సుల్ కొర్నేలీ తెంతొ ప్రయానుమ్ జెతె తా యొప్పేక పాసి జా గెతికయ్, పేతురు ఒత్త గెరి తా, ప్రార్దన కెరుక మెన, రమారమి మెద్దెనె ఒర్నె వెగిలొ. ");
INSERT INTO key_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ఒత్త ప్రార్దన కెర్తె తిలె, జోక చూ కెర్లి. ‘కిచ్చొగె కతిసి కావలె’ మెన కబుర్ తెద్రయ్‍తికయ్, ఎట్టొచ మాన్సుల్ తెయార్ కెర్తె తతికయ్, ప్రబుతె పేతురుచి మెన్సు పూర్తి తా, ప్రబు దెకయ్‍లి సివ్న ఏక్ పేతురు దెకిలన్. ");
INSERT INTO key_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","కిచ్చొ దెకిలొ మెలె, పరలోకుమ్ ఉగ్డి జలి, చి ఏక్ వెల్లి తెర జాచ చెత్తర్ కోనల్‍తె దెరయ్ జా, బుఁయ్యె ఉత్ర జెతె అస్సె. ");
INSERT INTO key_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","జా తెరచి ఉప్పిరి కిచ్చొ బెర అస్సె మెలె, బూలోకుమ్‍చ ఎత్కి రకల్ జంతువుల్, సొమ్ముల్, అయివొ, ఆగాసుమ్‍చ పిట్టలు. ");
INSERT INTO key_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","అన్నె, “ఓ పేతురు, ఉట్ట, కండ, పోడు కా” మెన ఏక్ అవాడ్ అయ్‍లిసి పేతురు సూన్లొ. ");
INSERT INTO key_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","గని జో, “నాయ్, ప్రబు. నెంజె. ఆఁవ్ జెర్మిల్ తెంతొ కిచ్చొ గార్‍చి ఆఁవ్ కెఁయ్య కయి నాయ్” మెన ప్రబుక సంగిలన్, ");
INSERT INTO key_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","జలె, అన్నెక్ సుట్టు ప్రబుచి జా అవాడ్‍చి జోచి తెన్ ఉంక్రయిలన్. కిచ్చొ మెన సంగిలన్ మెలె, “‘సుద్ది అస్సె. కంక జయెదె’ మెన కిచ్చొచి రిసొ దేముడు సంగ అస్సె గే, జాక తూయి ‘గారు’ మెన సంగు నాయ్” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","తివ్వెరి ఇసి జలి, చి పరలోకుమ్‍తె జా ఎత్కి అన్నె ఉక్కిల్ జలి. ");
INSERT INTO key_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","జలె, “ఆఁవ్ దెకిలి సివ్నచి అర్దుమ్ కిచ్చొ?” మెన, పేతురు కిచ్చొ. ఉచరుక గే నేన తతికయ్, ఏదె, కొర్నేలీ తెద్రయ్‍ల మాన్సుల్, “సీమోనుచొ గేరు కేన్ గేరు?” మెన పుస సూన తా, ఒత్త గుమ్ముమె టీఁవొజ తిల. ");
INSERT INTO key_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","“పేతురు మెలొ సీమోను ఇన్నె జితె అస్సె గె?” మెన కేక్ గల. ");
INSERT INTO key_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","పేతురు, జలె, ‘సివ్నచి అర్దుమ్ కిచ్చొ?’ మెన ఉచర్తె తతికయ్, ప్రబుచి ఆత్మ జోక, “ఈందె, తీగ్ల మాన్సుల్ తుక చజితతి. ");
INSERT INTO key_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","తుయి ఉట్ట ఉత్ర గో, చి తుక కేనె కడ నెవుల గే, అన్మానుమ్ నెంతె జోవయింతెన్ బెద గో. ఆఁవ్వి జోవయింక తెద్రవ అస్సి” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","జాకయ్ పేతురు జేఁవ్ మాన్సుల్‍తె ఉత్ర జా, “తుమ్ చజితొసొ అఁవ్వి. కిచ్చొక జా అస్సుస్?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","జేఁవ్, “కొర్నేలీ మెలొ పుంజెక్‍జీన్ జమాన్లుక వెల్లొ మాన్సు అమ్‍క తెద్రవ అస్సె. జో దేముడుక బితొసొ, సత్తిమ్ తిలొసొ. తుమ్‍చ యూదుల్ ఎత్కిజిన్ జోక, చెంగిలొ మాన్సు జో, మెన సంగితతి. జోక, జలె, దేముడుచొ దూత ఎక్కిలొ డీస కెర, పేతురుక బుకారవన్, చి జో కిచ్చొ సంగెదె గే తుయి సూను, మెన సంగితికయ్, తుక కడ నెతి రిసొ అమ్‍క జో తెద్రవ అస్సె” మెన జేఁవ్ తీగ్ల పేతురుక సంగిల. తెదొడి “అన్నిమ్ కా కెర, అజిక ఇన్నె నిద్ర తా” మెన పేతురు గెరి బుకారా, జేఁవ్‍క మరియాద కెర్లన్. ");
INSERT INTO key_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","అన్నెక్ దీసి పెందలె ఉట్ట, పేతురు, జేఁవ్ తీగ్ల తెన్, చి యొప్పేతెచ ప్రబుక నంపజల అన్నె సొవ్వుజీన్ తెన్, కొర్నేలీతె గెచ్చుక బార్ జల. ");
INSERT INTO key_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","అన్నెక్ దీసి కైసరియ పట్నుమ్‍తె పాఁవ, పట్నుమ్‍తె పెసిలె, కొర్నేలీ జోవయింక రకితె తా. ‘పేతురు కిచ్చొ మెనెదె గే సూన్‍తు’ మెన, జోవయించ మాన్సుల్‍క, జోచ గోతుల్ ఎత్కిక బుకారా కెర తెయార్ జా అస్తి. ");
INSERT INTO key_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","జలె, పేతురు జోచి గెరి పాఁవితికయ్, కొర్నేలీ దస్సుల్ జా జోచి చట్టె సెర్ను సేడ జొకర్లన్. ");
INSERT INTO key_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","గని పేతురు జోక ఉట్టవ కెర, “తుయి టీఁవొజ, ఆఁవ్ కి తుచి రితొ మాన్సు” మెన, జో తెన్ అన్నె లట్టబ్తె తా, ");
INSERT INTO key_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","గేర్ తెడి పెసిలె, ఒగ్గర్‍జిన్ జనాబ్ ఒత్త బెర అస్తి. ");
INSERT INTO key_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","జలె, పేతురు జోవయింక తెదొడి, “ఆమ్ యూదుల్, జలె, యూదుల్ నెంజిలసచ గెరలె పెసుక జలె, యూదుల్ నెంజిలస తెన్ బెదుక జలె, అమ్‍క గారు మెన తుమ్ జాన్సు. గని, ఆఁవ్ కిచ్చొ గారు మెనుక జయె నాయ్, కక్క నిస్కారుమ్ దెకుక జయె నాయ్, మెన దేముడు అంక అప్పె దెకవ అస్సె. ");
INSERT INTO key_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","జాక, తుమ్ సంగ తెద్రయ్‍తికయ్, కిచ్చొ అన్మానుమ్ నెంతె అయ్‍లయ్. జలె, కిచ్చొచి రిసొ అంక బుకారా అస్సుస్?” మెన పుసిలన్. ");
INSERT INTO key_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","కొర్నేలీ కిచ్చొ జబాబ్ దిలన్ మెలె, “ఎదిలి వేలయ్, అప్పెక చెత్తర్ పొదుల్ జయెదె, ఆఁవ్ తిన్ని గంటల్ మెద్దెనె గెరి ప్రార్దన కెర్తె తతికయ్, చొక్కిల ఉజిడ్ తిల పాలల్ గలన తిలొ ఎక్కిలొ అంచి పుర్రె టీఁవొజ, అంక, ");
INSERT INTO key_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‘ఓ కొర్నేలీ, తుయి ప్రార్దన కెర్తె తతిసి దేముడు సూన అస్సె. తుయి బీద సుదల్‍క దర్ముమ్ దెతె తతిసి దెక అస్సె. ");
INSERT INTO key_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","జాకయ్, యొప్పే పట్నుమ్‍తె, చమొ పికయ్‍తొ సీమోను మెలొ ఎక్కిలొ సముద్రుమ్ సొడి జితయ్. జోచి గెరి గెచ్చ, ఒత్త తిలొ పేతురు మెలొ సీమోనుచి రిసొ పుసుతు మెన మాన్సుల్‍క కబుర్ తెద్రవు.’ మెన అంక జో దేముడుచొ దూత సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","సంగిల్ బేగి, తుచితె కబుర్ తెద్రయ్‍లయ్, చి తుయి తుచి దయక అయ్‍లది. అల్లె, సంగు మెన ప్రబు తుక కిచ్చొ ఆడ్ర దాఁ అస్సె గే, జా సూనుక మెన అమ్ ఎత్కిజిన్ దేముడుచి నావ్ తెన్ బెర అస్సుమ్”. ");
INSERT INTO key_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","పేతురు చోండి పుట్టవ కిచ్చొ మెన తెదొడి బోదన కెర్లన్ మెలె, “దేముడు తేడల్ దెకె నాయ్ మెన ఆఁవ్ అప్పె సిక అస్సి. ");
INSERT INTO key_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","కేన్ దేసిమి కో జోక బితతి, జోచి కోడ్ రితి కెర్తతి గే, జోవయింక తేడల్ నే దెకితె, జో ‘అంచయ్ మాన్సుల్’ మెన చెంగిల్ దెకితయ్ మెన అప్పె దెక అస్సి. ");
INSERT INTO key_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","“జలె, ఇస్రాయేలులు మెల ఆమ్ యూదుల్‍తె దేముడు తెద్రయ్‍లి కబుర్ తుమ్ జాన్సు. యేసుక్రీస్తుచి తెడి పాపుమ్ గెతి వాటు దొర్కు జలి, చి దేముడుక మాన్సుల్‍క అడ్డు నాయ్ గే, చి సేంతుమ్ దొర్కు జలి మెలి కబుర్ జా, జో యేసుయి ఎత్కిక ప్రబుయి. ");
INSERT INTO key_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","జలె, తుమ్ కెర్ల పాపల్‍క పెట్టి దుకుమ్ జా బాప్తిసుమ్ నఙన, మెన యోహాను బోదన కెర కెర పాపుమ్ గెతి గుర్తుక బాప్తిసుమ్ దెతె తిలి తెంతొ, గలిలయ ప్రాంతుమ్‍తె మొదొల్ జా అమ్ యూదుల్‍చి ఒండి యూదయ ప్రదేసిమి జా సుబుమ్ కబుర్ సూనయ్ జా అస్సె. ");
INSERT INTO key_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","మెలె, నజరేతు గఁవ్వి వడ్డ తిలొ యేసుక ‘ఈంజొయి అమ్‍చొ ప్రేమ తిలొ పుత్తు, ఈంజొయి దొర్కు జలొ రచ్చించుప కెర్తొసొ’ మెన దేముడు జోచి సుద్ది తిలి ఆత్మచి గుర్తు దెకవ సెక్తి అదికారుమ్ దిలిసి జాన్సు. పడ్తొ, దేముడు జోవయించి పెట్టి తిలి రిసొ, మాన్సుల్‍క చెంగిల్ దెకితె తా, సయ్‍తాన్ అల్లర్ కెర్లస ఎత్కిజిన్‍క చెంగిల్ కెర్తె తా యేసు బుల్తె తిలిసి తుమ్ జాన్సు. ");
INSERT INTO key_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“అమ్ యూదుల్‍చి ఒండి దేసిమ్ కి, అమ్‍చి యెరూసలేమ్ పట్నుమ్‍తె కి, జో యేసు కెర్లిసి ఎత్కిక అమ్ సాచి జా అస్సుమ్. గని జోక సిలువతె టీఁవొ కెర మార్ల. ");
INSERT INTO key_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","దేముడు అబ్బొసి తిర్రత్‍క జోక అన్నె జియడ, జో అన్నె జిలిస్‍క మాన్సుల్ రుజ్జు దెకిత్ రితి డీసయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","కక్క డీసిలొ మెలె, ఎత్కిజిన్ ప్రెజల్‍క నాయ్, గని జో దేముడు నిసాన్ల ఆమ్ సాచుల్‍కయి డీసిలన్. జో జీవ్ జా ఉట్లి పడ్తొ, జో తెన్ సగుమ్ సుట్లు అన్నిమ్ కయ్‍లమ్. ");
INSERT INTO key_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","జలె, అమ్‍క డీస కెర, ప్రెజల్ ఎత్కిక అంచి రిసొ బోదన కెర, జితసక మొర్లసక ఆకర్ దీసిక అఁవ్వి తీర్పు కెరుక మెన దేముడు అబ్బొ అదికారుమ్ దా అస్సె. సంగ మెన, జోచి రిసొ ఆమ్ సాచి జంక మెన, జో యేసుయి అమ్‍క ఆడ్ర దాఁ అస్సె. ");
INSERT INTO key_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","జోచి రిసొ కో జోక నంపజవుల గే, జోచి నావ్ తెన్ జోవయించ పాపల్ కచితుమ్ చెమించుప జవుల మెన కబుర్ తెద్రయ్‍లస ఎత్కిజిన్ సాచి జతతి” మెన పేతురు బోదన కెర్లన్. ");
INSERT INTO key_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","పేతురు దస్సి బోదన కెర్తె తతికయ్, దేముడుచి సుద్ది తిలి ఆత్మ జా కోడు సూన్లస ఎత్కిజిన్‍చి పెట్టి బెర్లి. ");
INSERT INTO key_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","పడ్తొ యూదుల్‍చి గుర్తు తిలి సున్నతి కెరంతి ఆగ్న నంప కెర్త, పేతురు తెన్ జా తిల, ప్రబుక నంపజల మాన్సుల్ ఆచారిమ్ జల. యూదుల్ నెంజిల జేఁవ్ అన్నె మాన్సుల్‍చి పెట్టి కి దేముడుచి సుద్ది తిలి ఆత్మ ప్రబు సువ దిలిస్‍చి రిసొ. ");
INSERT INTO key_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","జా సువ దిలిస్‍క కిచ్చొ గుర్తు దెకిల మెలె, జేఁవ్ మాన్సుల్ జేఁవ్ నే సికిల బాసల్ తెన్ లట్టబ, దేముడుచి గవురుమ్ సంగితె తిల. దస్సి జతికయ్, పేతురు, ");
INSERT INTO key_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“అమ్‍క జా సుట్టు జర్గు జలి రితి, ఇన్నెచి పెట్టి కి దేముడుచి సుద్ది తిలి ఆత్మ దొర్కు జా అస్సె. జాకయ్ ఇన్నెక అమ్ బాప్తిసుమ్ దెంక కిచ్చొ అడ్డు నాయ్. కో ‘పోని’ మెనుక బెదె నాయ్” మెన సంగ, ");
INSERT INTO key_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","“జేఁవ్ ఎత్కిజిన్ యేసుక్రీస్తుచి నావ్ తెన్ బాప్తిసుమ్ నఙన్‍తు” మెన ఆడ్ర దిలన్. ఒత్త తెంతొ “సగుమ్ దీసల్ ఇన్నె తా” మెన పేతురుక బతిమాల్ప జా సంగిల. ");
INSERT INTO key_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","యూదుల్ నెంజిల మాన్సుల్ కి యేసుచి రిసొచి సుబుమ్ కబుర్ సూన నంపజా మార్సుప జా అస్తి మెన, సిస్సుల్ తెన్ యూదయ ప్రదేసిమ్‍చి నంపజలస ఎత్కిజిన్ సూన్ల. ");
INSERT INTO key_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","జలె, సగుమ్ దీసల్ గెతికయ్, పేతురు యెరూసలేమ్‍తె ఉట్ట అయ్‍లన్. యేసుక నంపజల ఒత్తచ మాన్సుల్, యూదుల్ పేతురుక జేఁవ్ గోల కెర్ల. ");
INSERT INTO key_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“ఆమ్ యూదుల్‍చి గుర్తుచి సున్నతి నే కెరన్లసచ గెరలె కిచ్చొక గెలది? జోవయింతెన్ కిచ్చొక అన్నిమ్ కయ్‍లది?” మెన గోల కెర్ల. ");
INSERT INTO key_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","గోల కెర్తికయ్, జర్గు జలిసి ఎత్కి వర్స తెన్ పేతురు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“ఆఁవ్ యొప్పే పట్నుమ్‍తె తా ప్రార్దన కెర్తె తిలయ్. ప్రార్దన కెర్తె తా, ప్రబుతె అంచి మెన్సు పూర్తి తతికయ్, ప్రబు దెకయ్‍లి సివ్న ఏక్ దెకిలయ్. జా సివ్నతె, వెల్లి తెర రితిసి జేఁవ్‍చ చెత్తర్ కోనల్‍తె దెరయ్ జా, పరలోకుమ్ తెంతొ ఉత్ర జెతె అస్సె. అంచి పాసి ఉత్ర అయ్‍లి. ");
INSERT INTO key_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ఆఁవ్ సరిగా దెకిలయ్, పోస్త మంద, డొంగుర్‍చ జంతువుల్, అయివొ గట్ర, ఆగాసుమ్‍చ పిట్టల్ జా తెరచి ఉప్పిరి అస్తి. ");
INSERT INTO key_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","“పడ్తొ ఏక్ అవాడ్ సంగిలిసి సూన్లయ్, ‘ఓ పేతురు, ఉట్ట, కండ పోడ కా.’ మెన సంగిలిసి సూన్లయ్. ");
INSERT INTO key_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","గని, ‘నెంజె, ప్రబు. ఆఁవ్ జెర్మిలి తెంతొ కిచ్చొ గార్‍చి ఆఁవ్ కెఁయ్య కయి నాయ్’ మెన సంగిలయ్. ");
INSERT INTO key_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","సంగితికయ్, పరలోకుమ్ తెంతొ జా అవాడ్ అన్నెక్ సుట్టు లట్టబ, కిచ్చొ మెన జబాబ్ దిలన్ మెలె, ‘సుద్ది అస్సె. కంక జయెదె’ మెన, కిచ్చొచి రిసొ దేముడు సంగెదె గే, జాక తూయి గారు మెనుక జయె నాయ్ మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","తివ్వెర్ ఇసి జలి, చి పరలోకుమ్‍తె జా ఎత్కి అన్నె ఉక్కిల్ జలి. ");
INSERT INTO key_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ఉక్కిల్ జలి బేగి, కైసరియ పట్నుమ్ తెంతొ అయ్‍ల మున్సుబోదల్ తీగ్ల ఆమ్ తిలి గెరి పాఁవ అయ్‍ల. ");
INSERT INTO key_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","“జోవయింతెన్ బెద గో మెన ప్రబుచి ఆత్మ అంక ఆడ్ర దెతికయ్, జోవయింక తేడ నే దెకితె, బెద గెలయ్. అమ్‍చి తెన్ బెద అయ్‍ల సొవ్వుజీన్ ప్రబుక నంపజలస కి, అంచి తెన్ గెల, చి యూదుడు నెంజిలొ జో కొర్నేలీచొ గెరి పెసిలమ్. ");
INSERT INTO key_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ప్రబుచొ దూత జా దీసి జోచి గెరి టీఁవ సంగ తిలిసి అమ్‍క కొర్నేలీ సంగిలన్. దూత సంగ తిలిసి కిచ్చొ మెలె, ‘జెవుసు’ మెన సీమోను పేతురుక కబుర్ తెద్రవు. జో యొప్పేతె అస్సె. ");
INSERT INTO key_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","జో అయ్‍లె, అంచి ఏక్ కబుర్ తుమ్‍క సూనఎదె. జా కోడు సూన నంపజలె, తూయి, తుమ్‍చి గేర్‍చ మాన్సుల్, సేవ కెర్తస, ఎత్కిజిన్, పాపుమ్ తెంతొ రచ్చించుప జస్తె, మెన జోక దూత సంగ తిలన్. ");
INSERT INTO key_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“ప్రబుచి సుబుమ్ కబుర్ ఆఁవ్ సంగుక దెర్తికయ్, ఆమ్ సిస్సుల్‍క చి అమ్‍చి తెన్ నంపజల యూదుల్‍క జా సుట్టు జర్గు జలి రితి, జా గేర్‍చక కి జర్గు జలి. దేముడుచి సుద్ది తిలి ఆత్మ జోవయించి పెట్టి అయ్‍లి. ");
INSERT INTO key_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","దస్సి జర్గు జతికయ్, ప్రబు అగ్గె సంగ తిలి ఏక్ కోడు ఏదస్ట కెర్లయ్. ‘యోహాను, పాని తెన్ బాప్తిసుమ్ దెతె తిలొ, గని పడ్తొక దేముడుచి సుద్ది తిలి ఆత్మ తెన్ తుమ్‍క బాప్తిసుమ్ దెమ్‍దె’ మెన యేసు సంగిలిసి ఏద కెర, ‘ఒహొ, ఇన్నెతెన్ నెరవెర్సుప జలి’ మెన చినిలయ్. ");
INSERT INTO key_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","“జలె, ఆమ్ యేసు క్రీస్తు ప్రబుక నంపజతికయ్ దేముడు అమ్‍చి పెట్టి జోచి ఆత్మ తతి వరుమ్ కీసి దిలన్ గే, జో అప్పె జేఁవ్ యూదుల్ నెంజిలసక కి దస్సి వరుమ్ దిలన్ మెలె, ఆఁవ్ మాన్సు, ప్రబుక, తుచి ఇస్టుమ్ పోని మెనుక బెదెదె గె? బెదె నాయ్!” మెన పేతురు సాచి సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ఈంజ సాచి సూన తా జేఁవ్ గోల కెర తిల బారికుల్, చి ప్రబుక అన్నె నంపజలస, అన్మానుమ్ తంక నెతిర్ల, చి “దస్సి జలె, యూదుల్ నెంజిల మాన్సుల్ కి పాపుమ్‍బుద్ది ముల దా ప్రబుక నంపజలె, జేఁవ్ కి జోచి నావ్ తెన్ రచ్చించుప జవుల” మెన సర్ద తెన్ దేముడుక గవురుమ్ కెర్ల. ");
INSERT INTO key_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","స్తెపను బోదన కెర్తె తిలి తెంతొ గోస జల మాన్సుల్ అల్లర్ కెర్లి రిసొ చెదుర్ప జా తిల యేసుక నంపజలస, ఈంజ మదెనె, ఉత్తర పక్క గెచ్చ, సముద్రుమ్‍చి పాసి తిలి పేనీకే ప్రాంతుమ్ ఎద పడ్తొ సముద్రుమ్ ఒత్తల్‍తొచి కుప్ర, డిబ్బ దేసిమ్ ఎద, పడ్తొ సిరియ ప్రదేసిమ్‍చి అంతియొకయ పట్నుమ్ పక్క బుల బుల, తెదొడి ఎద ఎక్కి యూదుల్‍కయ్ ప్రబుచి సుబుమ్ కబుర్ సికడ్తె తిల. ");
INSERT INTO key_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","గని అన్నె సగుమ్‍జిన్, కుప్ర డిబ్బ దేసిమ్‍చ, అన్నె జాక దచ్చెన పక్క తిలి సముద్రుమ్ ఒత్తల్‍తొ తిలి కురేనియు పట్నుమ్‍చ, జా అంతియొకయ పట్నుమ్‍తె జాఁ కెర, గ్రీకు బాస లట్టబ్తె యూదుల్ నెంజిలసక కి యేసుప్రబుచి రిసొచి సుబుమ్ కబుర్ బోదన కెర్ల. ");
INSERT INTO key_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","జేఁవ్ బోదన కెర్లసక ప్రబు తోడు తతికయ్, జేఁవ్ గ్రీసు దేసిమ్‍చ సుదల్‍తె ఒగ్గర్‍జిన్ ప్రబుక నంపజా మార్సుప జల. ");
INSERT INTO key_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","‘ఒత్తచ యూదుల్ నెంజిలస కి ప్రబుక నంపజా మార్సుప జా అస్తి’ మెన యెరూసలేమ్ పట్నుమ్‍చి సంగుమ్‍చ నంపజల యూదుల్ సూన కెర, బర్నబాక ఒత్త జా సిరియ ప్రదేసిమ్‍చి అంతియొకయతె తెద్రయ్‍ల. ");
INSERT INTO key_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","జో ఒత్త పాఁవ కెర, ‘జోచి దయచి రిసొ దేముడు జేఁవ్ యూదుల్ నెంజిలసక వరుమ్ దా ఈంజ ఎత్కి జర్గు కెర అస్సె’ మెన రుజ్జుల్ దెక, సర్ద జలొ, అన్నె, “తుమ్ ప్రబుక ఏక్ మెన్సు నిదానుమ్ తా” మెన జోవయింక దయిరిమ్ సంగ బోదన కెర్లన్. ");
INSERT INTO key_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","జో బర్నబా చెంగిలొ మాన్సు. జోచి పెట్టి దేముడుచి సుద్ది తిలి ఆత్మ పూర్తి కామ్ కెర్తి బుద్ది, ప్రబుచి ఉప్పిర్‍చి నముకుమ్, బెర తిలి. బర్నబా సగుమ్ దీసల్ ఒత్త తా బోదన కెర్తికయ్, అన్నె ఒగ్గర్‍జిన్ మాన్సుల్ ప్రబుక నంపజా మార్సుప జల. ");
INSERT INTO key_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","‘తోడు జెవుస్’ మెన సావుల్‍క సంగుక మెన, బర్నబా తార్సు పట్నుమ్‍తె ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","జోక అంతియొకయ పట్నుమ్‍తె కడ ఆన్లన్, చి వెర్సెక్ పూర్తి ఒత్త తా, ప్రబుక నంపజలసచి ఒత్తచి సంగుమ్‍తె బెదితె తా, ఒగ్గర్ ఒగ్గర్‍జిన్ మాన్సుల్‍క సరిగా బోదన కెర్ల. ఒత్త, యేసుక నంపజా సిస్సుల్ జలసక తొలితొ అంతియొకయతెయి ‘నంపజలస’ మెన సంగయ్ జల. ");
INSERT INTO key_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","జేఁవ్ పొదులె, అన్నె కిచ్చొ జర్గు జలి మెలె, ప్రబుచ కబుర్లు సంగిత నంపజలస సగుమ్‍జిన్ అంతియొకయతె అయ్‍ల. ");
INSERT INTO key_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","జోవయింతె ఎక్కిలొ, అగబు. జో జలె, సబతె టీఁవ, ప్రబుచి సెక్తిచి రిసొ ప్రబుచి కిచ్చొ కబుర్ సంగిలన్ మెలె, ‘పలాన్ సమయుమ్‍క ఒండి లోకుమ్‍తె ఒగ్గర్ కరువు జెయదె’ మెన కబుర్ సంగిలన్. కేన్ కాలుమ్ జో సంగిలి కరువు జర్గు జలి మెలె, క్లౌదియ రానొ ఏలుప కెర్తె తిల పొదులె జర్గు జలి. ");
INSERT INTO key_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","అంతియొకయతె తిల ప్రబుచ సిస్సుల్, జలె, జా కరుచి రిసొ సూన కెర, సబ కెర కిచ్చొ ఉచర్ల మెలె, “కచి సెక్తి తిలి ఎది, జేఁవ్ డబ్బుల్ ఉక్కుల్‍మ, చి యూదయ ప్రదేసిమి తిల అమ్‍చ నంపజలస బావుడ్లుక తోడు తెద్రవుమ్‍దె” మెన, ");
INSERT INTO key_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","డబ్బుల్ ఉక్కుల, యెరూసలేమ్‍చి సంగుమ్‍చ వెల్లెల మాన్సుల్‍క అంట దెతు మెన, బర్నబా చి సావుల్‍చి అత్తి ఒత్త యెరూసలేమ్‍తె తెద్రయ్‍ల. ");
INSERT INTO key_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","జా కరువు నే జతె అగ్గె, హేరోదు రానొ యెరూసలేమ్ పట్నుమ్‍చి సంగుమ్‍చ నంపజలస సగుమ్‍జిన్‍క అల్లర్ కెరుక దెర్లన్. ");
INSERT INTO key_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","జోవయింతె ఏక్ దీసి జేఁవ్ యేసుచ బారికుల్‍తె ఎక్కిలొక కండ మార్లన్. యోహానుచొ యాకోబు మెలొ అన్నొస్‍క. ");
INSERT INTO key_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","‘యాకోబుక మార్లి రిసొ మాములుమ్ యూదుల్‍చ వెల్లెల మాన్సుల్ సర్ద జల’ మెన రానొ దెక, “పేతురుక కి మారిందె” మెన ఉచర, జోక కి జేలి కెర్లొ. గని, నే పులయ్‍ల పోడియొ కతి యూదుల్‍చి పస్కా పండుగు జా తిలి రిసొ ‘అప్పె మారుక నెంజె’ మెన, ");
INSERT INTO key_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","పేతురుక దెర జేలి కెర, ‘పండుగు కేడ్లె, ప్రెజల్ సాచి జతి రితి సబ కెర మారిందె’ మెన, ఉచర, ‘ఎక్కె దడి చెత్తర్‍జిన్ జమాన్లు జోక రకుత్’ మెన సోడ జిన్ జమాన్లుక నిసాన్లన్. చెత్తర్‍జిన్ సొవ్వు గంటల్ రకిలె అన్నెక్ చెత్తర్‍జిని సొవ్వు గంటల్ రకుక. ");
INSERT INTO key_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","దస్సి పేతురుక జేల్‍తె రకితె తిల, గని జా యెరూసలేమ్‍తెచి సంగుమ్ సుదల్ పేతురుచి రిసొ దేముడుక ప్రార్దన కెరుక ములితి నాయ్. జేఁవ్ దస్సి ప్రార్దన కెర్తె తతికయ్, ");
INSERT INTO key_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","కలిక జోవయింక బార్ కెర తీర్పు కెర మారిందె, మెన పండుగు కేడ్తికయ్ హేరోదు ఉచర్లన్. మదెనె పేతురుక కీసి అస్సె మెలె, జా రాతి, జోక ఏక్ పక్కయ్ ఎక్కిలొక, అన్నెక్ పక్కయ్ ఎక్కిలొక తా, దస్సి దొగుల జమాన్లుచి నెడిమి జో నిజయి అస్సె. పేతురుచ అత్తిలె గొల్సుల్ బందయ్ తిల. పడ్తొ జేల్ చి కెవ్డితె దొగుల జమాన్లు రకితె అస్తి. ");
INSERT INTO key_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","జలె, పేతురు దస్సి జేలితె తతికయ్, ప్రబుచొ దూత ఎక్కిలొ జాఁ కెర, జోచి పాసి టీఁవొ జలన్, చి జా ఒండి గదితె వెల్లి ఉజిడి లగిలి. తెదొడి పేతురుక పక్కయ్ పెట, ఉట్టవ, “బేగి ఉట్టు” మెన సంగిలన్. బేగి, జోచ అత్తిచ గొల్సుల్ కుస్డ గెల. ");
INSERT INTO key_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","పడ్తొ, “తెయార్ జా జోడ్లు గలన” మెన దూత సంగిలన్. జో సంగిలి రితి పేతురు కెర్లన్, చి “తుచి డుప్పటి పంగుర్‍చి అంచి పట్టి జె” మెన దూత సంగితికయ్, సంగిల్ రితి పేతురు కెర్లన్. ");
INSERT INTO key_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","దూతచి పట్టి ఇండ బార్ జా గెలన్, గని దూతచి అత్తి జర్గు జలిస్‍క ‘నిజుమి జర్గు జతయ్’ మెన నేనె. ‘ఈంజ సివ్న దెకితసి’ మెన జో ఉచర్తయ్. ");
INSERT INTO key_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","జలె, రకితొసొ ఎక్కిలొక ఒత్తల్‍తొ జీన, అన్నెక్లొక ఒత్తల్‍తొ కి జీన, పట్నుమ్‍తె ఉత్తిర్తి గుమ్ముమ్‍చి ఇనుముచి టట్టతె పాఁవ అయ్‍లె, కిచ్చొ జర్గు జలి మెలె, జాచి ఇస్టుమ్‍క జా ఇనుము టట్ట ఉగ్డి జలి, చి పేతురు దూతతెన్ బార్ జా ఏక్ వీది జీన్లె, బేగి దూత జోక ములిలన్. ");
INSERT INTO key_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","‘సివ్న నెంజె, నిజుమి జర్గు జలి’ మెన పేతురు అప్పె పూర్తి అర్దుమ్ కెరన్లన్, చి “హేరోదు జేలి కెర్లిసి తెంతొ, గోస జల యూదుల్ ఉచర్లిసి ఎత్కి తెంతొ, ఆఁవ్ విడ్దల్ జతి రిసొ ప్రబు జోచొ దూతక తెద్రయ్‍లొ మెన, అప్పె కచితుమ్ జాని” మెన చెంగిల్ ఉచర. ");
INSERT INTO key_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ఉచర, వట్టె గెచ్చ, మార్కు మెన అన్నెక్ నావ్ తిలొ యోహాను మెలొసొచి అయ్యస్ మరియచి గెరి పాఁవిలన్. ఒత్త ఒగ్గర్‍జిన్ మాన్సుల్ బెర, జోచి రిసొ ప్రార్దన కెర్తె అస్తి. ");
INSERT INTO key_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","గుమ్ముమ్‍చి కెవ్డితె జో పెట అవాడ్ కెర్లె, రొదే మెలి తేర్‍బోద దాక్ నాడి కెవ్డి ఉగుడుక అయ్‍లి. ");
INSERT INTO key_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","పేతురుచి అవాడ్ సూన, జాచి ఒగ్గర్ సర్ద సంతోసుమ్‍క ఉగుడుక పఁవ్స కెర, గెరి నిగ గెచ్చ, పేతురు కెవ్డి పాసి టీఁవిలిసి మెన సంగిలి. ");
INSERT INTO key_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","“తుయి వెర్రి జా అస్సిస్” మెన, ఎత్కిజిన్ జాక సంగిల. గని, “నాయ్, నిజుమి, జో జాఁ అస్సె” మెన, జా దయిరిమ్ తెన్ సంగితికయ్, “జోచొ దూత కిచ్చొగె జా తయెదె” మెల. ");
INSERT INTO key_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","గని పేతురు కెవ్‍డిక పెట అవాడ్ కెరుక ములె నాయ్, చి సూన, ఉగుడ, జోక దెక ఆచారిమ్ జల. ");
INSERT INTO key_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","జో, జలె, ‘తుక్లె తా’ మెల సయ్‍గ కెర, జో జేలితె తిలె, జేల్‍తె తెంతొ ప్రబు విడ్దల్ కెర్లిసి ఎత్కి కీసి జర్గు జలి గే పూర్తి సంగ కెర, “యేసుచొ బావొసి జలొ యాకోబుక చి బావుడ్లు జల నంపజలస ఎత్కిక ఈంజ ఎత్కి తుమ్ సూనవ” మెన సంగ, పేతురు వేరతె ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","పెందలె, పేతురుక ‘విడ్దల్ జాఁ అస్సె’ మెన జాన్‍తికయ్, జమాన్లు బమ్మ జా ఒగ్గర్ అల్లర్ జల. ");
INSERT INTO key_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","“పేతురుక జేల్‍తె తెంతొ బార్ కెర ఆన్‍తు” మెన హేరోదు ఆడ్ర దిలన్, గని ‘డీసె నాయ్’ మెన సూన, రకితసక పరిచ్చ కెర, జోవయింక మొర్తి సిచ్చ దా, జా యూదయ ప్రదేసిమ్‍చి యెరూసలేమ్ పట్నుమ్ ముల దా సముద్రుమ్ పక్కచి జా ప్రదేసిమ్‍చి కైసరియ పట్నుమ్‍తె గెచ్చ, ఒత్త తెంతొ ఏలుప కెర్తె తిలొ. ");
INSERT INTO key_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ఉత్తర పక్కచ తూరు పట్నుమ్‍చ, సీదోను పట్నుమ్‍చచి రిసొ హేరోదు ఒగ్గర్ పెట్టపెట్టి జలొ. జాకయ్ జేఁవ్ పట్నుమ్‍చ ఒగ్గర్‍జిన్ బెద జా, హేరోదుచి మేడతె జాఁ కెర, రానొచొ గేర్‍క దెకితొ మంత్రి జలొ బ్లాస్తు మెలొసొ తెన్ సినేతుమ్ కెరన, ‘రానొ అమ్‍క సేంతుమ్ దెకుస్’ మెన జోవయించి అత్తి సంగ తెద్రయ్‍ల. జోవయించి పేనీకే ప్రాంతుమ్‍తె కరువు తతికయ్, జో రానొ ఏలుప కెర్తి గలిలయ ప్రాంతుమ్‍తెచ దాన్ జేఁవ్ కా కా జితతి. జేఁవ్ జా కంక జో రానొ నే ఒప్పిలెగిన, చూఁక మొరుల. ");
INSERT INTO key_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","జాకయ్, జో సంగిలి ఏక్ దీసి, హేరోదు, రానొ జలి గుర్తు దెకయ్‍త జోవయించ చెంగిల పాలల్ ఎత్కి గలన, సింగాసనుమ్‍తె వెస, జోవయింక జొయ్యి గవురుమ్ ఆనన్‍తి రితి, బెర తిల జేఁవ్ మాన్సుల్‍క తెలివి తెన్ బోదన కెర్లన్. ");
INSERT INTO key_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","దస్సి జతికయ్, ప్రెజల్, “ఇన్నెక మాన్సు మెలమ్, గని మాన్సు నెంజె. ఈంజొ లట్టబ్లె, దేముడు లట్టబ్లి రితి జతయ్!” మెన కేకుల్ గల పులయ్‍ల. ");
INSERT INTO key_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","‘దేముడు’ మెన పులయ్‍లె, జో ‘నెంజి’ మెనె నాయ్, ‘జొయ్యి దేముడు’ మెన దేముడుక గవురుమ్ కెరె నాయ్, చి బేగి, దేముడుదూత ఎక్కిలొచి అత్తి జోక మొర్తి సిచ్చ దిలన్, చి జో జితె తస్తె, కిఁవ్వొ జోచి ఆఁగ్ కాఁ గెల, చి మొర గెలన్. ");
INSERT INTO key_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","గని ప్రబుచ సిస్సుల్ జోచి సుబుమ్ కబుర్ బోదన కెర్తె తిల, చి అన్నె ఒగ్గర్‍జిన్ ప్రబుక నంపజా మార్సుప జల. ");
INSERT INTO key_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","హేరోదు రానొ మొర గెచ్చ సగుమ్ దీసల్ గెలి పడ్తొ, క్లొవుదియ రానొ ఏలుప కెర్తె తిల పొదులె, బర్నబా సావులు యెరూసలేమ్‍తె గెచ్చ, ‘కరువుక అల్లర్ జల మాన్సుల్‍క దెంక’ మెన, అంతియొకయతెచ నంపజలొస ఉక్కిలి డబ్బుల్ న దా జోవయించి కామ్ కేడవ కెర, బర్నబాచొ సల్లొసి జలొ మార్కు మెలొ యోహానుక దెరన, యెరూసలేమ్ తెంతొ ఉట్ట అయ్‍ల. ");
INSERT INTO key_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","అంతియొకయతెచ సంగుమ్‍తె ప్రబుచ కబుర్లు సంగితస సగుమ్‍జిన్‍చి, ప్రబుచి రిసొ బోదన కెర్తస సగుమ్‍జిన్ తిల. జోవయింతె, బర్నబా, పడ్తొ ‘నీడొన్లొ’ మెలొ సుమెయోను, పడ్తొ కురేనియు పట్నుమ్‍చొ లూకియ, చెత్తర్ ప్రాంతుమ్‍లు ఏలుప కెర్తొ హేరోదు మెలొ రానొచి జతతె వడ్డిలొ మనయేను, పడ్తొ సావులు. ");
INSERT INTO key_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ఏక్ దీసి జేఁవ్ ఎత్కిజిన్ ఎక్కితె తా చువ్వె తా ప్రబుక ప్రార్దన కెర్తె తతికయ్, జోవయింక దేముడుచి సుద్ది తిలి ఆత్మ ఇసి సంగిలన్, “‘అంచి ఏక్ వెల్లి కామ్ కెర్తు’ మెన, బర్నబాక చి సావుల్‍క ఆఁవ్ నిసాన అస్సి. జా కామ్‍చి రిసొ అంచి అత్తి ఇన్నెక తుమ్ సొర్ప కెర దెతి గుర్తు కెర” మెన సంగిలన్, చి ");
INSERT INTO key_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","అన్నె చువ్వె తా ప్రార్దన కెర జేఁవ్ దొగులక బోడి చడ తెద్రవ దిల. ");
INSERT INTO key_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","దేముడుచి సుద్ది తిలి ఆత్మ దస్సి తెద్రయ్‍తికయ్, బర్నబా చి సావులు, సముద్రుమ్‍చి ఒడ్డుతెచి సెలూకయ పట్నుమ్‍తె ఉట్ట గెచ్చ, ఓడతె వెగ, సముద్రుమ్ జీన, సయ్‍ప్రస్ కుప్ర దేసిమి ఉట్ట అయ్‍ల. ");
INSERT INTO key_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","తొలితొ జా దేసిమ్‍చి సలమీ పట్నుమ్‍తె గెచ్చ, యూదుల్‍చ సబ గెరలె యేసుచి రిసొచి సుబుమ్ కబుర్ సూనవ, సాచి సంగిల. మార్కు మెలొ యోహాను జోవయింతెన్ తోడు అయ్‍లొ. ");
INSERT INTO key_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ఒత్త తెంతొ జా సయ్‍ప్రస్ దేసిమ్‍చి ఒత్తల్‍తొ పక్కచి పాపు మెలి వెల్లి పట్నుమ్‍తె గెలె, దీసరి జా గార్‍డేల్ మాయల్ కెర్తొ ఎక్కిలొ అస్సె. ‘యేసుచొ పుత్తుసి’ మెలి అర్దుమ్ తెన్, ‘బర్‍యేసు’ మెలి నావ్ జో తియన అస్సె. జో యూదుడు జెర్మిలొసొ, గని ఆరిక, ‘దేముడుచి కబుర్ ఈంజ’ మెన, సయ్‍తాన్ సికడ్లి కోడు జో సంగెదె. ");
INSERT INTO key_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","జా దేసిమి ఏలుప కెర్తొ అదికారితె తయెదె. జో అదికారిచి నావ్ కిచ్చొ మెలె, ‘సెర్గి పవులు’. జో తెలివి మాన్సు జయెదె. జో కిచ్చొ కెర్లొ మెలె, దేముడు దిలి సుబుమ్ కబుర్ సూనుక ఇస్టుమ్ జా, బర్నబాక చి సావుల్‍క బుకార్లన్. ");
INSERT INTO key_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","జలె, ఎలుమ మెన నావ్ తియన్లొ దీసరిక సంగుల. జా నావ్‌చి అర్దుమ్, దీసరి. జో అప్పె, ‘అదికారి క్రీస్తుక నంపజా మార్సుప జవుస్ నాయ్’ మెన, సావుల్‍క చి బర్నబాక అడ్డు కెరుక గెలొ. ");
INSERT INTO key_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","రోమ దేసిమ్‍చి బాస తెన్ ‘పవులు’ మెన అన్నెక్ నావ్ తిలొ జో సావులు, దేముడుచి సుద్ది తిలి ఆత్మచి సెక్తి జోవయించి పెట్టి బెర్తికయ్, జో ఎలుమక చెంగిల్ దెక, ");
INSERT INTO key_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“సయ్‍తాన్‍చొ పుత్తుసి జస్తె, తుయి. తుచి పెట్టి మాయబుద్ది, ఒగ్గర్ గార్‍చి, పాపుమ్ తెన్ అస్సిస్. సత్తిమ్ ఎత్కిక విరోదుమ్ జస్తె, తుయి, సోగ తిల ప్రబుచ వట్టొ వంకడ కెర్తొ మాయల్ కెఁయఁక ములితె? ");
INSERT INTO key_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ఈందె, ప్రబు తుక అప్పె సిచ్చ దెతయ్. తుయి గుడ్డి జా అప్పెచి మట్టుక పొద్దుక కి దెకిస్ నాయ్” పవులు సంగిలన్. సంగిల్ బేగి, జో మాన్సుక అంకివొతె గాందు డంకిలి రితి జా, పూర్తి గుడ్డి జలొ, చి జోక ఎత్కి అందర్ జలి. ఒత్త తెంతొ, అంక ఆతు దెర కో జలెకు అంక వాటు దెకయ్‍తు ఎక్కిలొ ఇండుక నెత్ర కెర బతిమాల్ప జా ఏడ్తె తిలన్. ");
INSERT INTO key_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","అదికారి, మాత్రుమ్, జర్గు జలిసి దెక కెర, ప్రబుచి చి సెక్తిచి రిసొ జలె ఆచారిమ్ జా ప్రబుక నంపజలన్. ");
INSERT INTO key_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","తెదొడి పవులు, జోవయింతెన్ తిలస, పాపు పట్నుమ్ ముల దా, ఓడతె వెగ సముద్రుమ్ జీన, అన్నె ఇండ గెచ్చ, పంపూలియా ప్రదేసిమ్‍చి పెర్గే పట్నుమ్‍తె అయ్‍ల. జేఁవ్ ఒత్త తిలి పొది, మార్కు మెలొ యోహాను జోవయింక ముల దా, యెరూసలేమ్‍తె అన్నె ఉట్ట గెలన్. ");
INSERT INTO key_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","పావులీంసి, మాత్రుమ్, ఇండ గెచ్చ పెర్గేక జీన, గలతీయ ప్రదేసిమ్‍చి పిసిదియ ప్రాంతుమ్‍చి అంతియొకయ మెలి పట్నుమ్‍తె పాఁవిల. బక్తి కెర్తి సెలవ్ కడన్లి దీసి, యూదుల్‍చి సబగేరి పెస, వెసిల. ");
INSERT INTO key_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","మోసే పూర్గుమ్‍చొచి అత్తి దేముడు రెగ్డయ్‍ల ఆగ్నల్ జలెకు, పూర్గుల్‍చి అత్తి సంగిల దేముడుచ కబుర్లుచి ఏక్ వాట కో గే వెల్లొ మాన్సు సదు కెర్తికయ్, “ఓ బావుడ్లు, ప్రెజల్‍క కిచ్చొ బోదన సంగితె గే సంగ” మెన పావులీంసిక జా సబగేర్‍చ అదికారుల్ పుర్రె బుకార్ల. ");
INSERT INTO key_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","జాకయ్, పవులు ఉట్ట, ప్రెజల్‍క ‘సూన్‍తు’ మెలి గుర్తుక ఆతు తెన్ సయ్‍న కెర, “ఓ ఇస్రాయేలులు మెల అమ్‍చ యూదుల్, పడ్తొ అమ్‍చొ దేముడుక బిత తుమ్ యూదుల్ నెంజిలస, సూన. ");
INSERT INTO key_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ఇస్రాయేలులు మెల అమ్‍చ పూర్గుల్‍క ‘అంచయి మాన్సుల్ జతు’ మెన పరలోకుమ్ తిలొ అమ్‍చొ దేముడు నిసాన్లన్. సగుమ్ దీసల్ గెతికయ్, జేఁవ్ ఐగుప్తు దేసిమి ఉట్ట గెచ్చ ఒత్త అల్లర్ తెన్ తతికయ్, జోవయింక చెంగిల్ దెక, జో ప్రబు, జోవయించి సెక్తిక, జోవయింక ఒత్త తెంతొ విడ్దల్ కెర బార్ కెర్లన్. ");
INSERT INTO key_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","జేఁవ్ దొన్ని విసొ వెర్సులు బయిలు దేసిమి బుల్తె తిలి పొది, జోవయించ సిద్డు ఓర్సుప జా, జోవయింక నిదానుమ్ దెకితె తిలన్. ");
INSERT INTO key_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ఒత్త తెంతొ, కనాను దేసిమ్‍తె సత్తు జాతివొచ మాన్సుల్‍క యుద్దుమ్‍తె అమ్‍చ పూర్గుమ్‍చ జీన్‍తి రితి జో జర్గు కెర, ‘ఈంజ దేసిమి ఈంజేఁవ్ జితు, ఇన్నెచి సొంత టాన్ జవుస్’ మెన జోవయింక దొర్కు కెర్లన్. ");
INSERT INTO key_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","“పడ్తొ, రమారమి చెత్తర్ పుంజొ యాబయ్ వెర్సుల్ గెతికయ్, జోవయించ కబుర్లు సంగితొ సమూయేలు మెలొ పూర్గుమ్‍చొచి కాలుమ్ ఎద, ‘ఇన్నెక ఏలుప కెర్తు’ మెన, నాయిమ్ వాట్ దెకయ్‍త ఎక్కిలొచి పడ్తొ అన్నెక్లొ తీర్పు కెర్తస రితసక జో దేముడు అదికారుమ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","“పడ్తొ, ‘అమ్‍క రానొ కావలె’ మెన అమ్‍చ పూర్గుమ్‍చ బతిమాల్ప జా సంగితికయ్, రానొక జో ప్రబు టీఁవడ్లన్. కొన్సొ తొలితొ జోవయింక రానొ జలొ గే తుమ్ జాన్సు. బెన్యామీను చి వంసుమ్‍చొ కీషు మెలొసొచొ సావులు మెలొ పుత్తుసి అమ్‍చొ తొలితొచొ రానొ జలొ. జో దొన్ని విసొ వెర్సుల్ ఏలుప కెర్లన్. ");
INSERT INTO key_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","“పడ్తొ సావుల్‍క దూర్ కెర కెర, ‘రానొ జవుస్’ మెన దావీదుక నిసాన జో ప్రబు అదికారుమ్ దిలన్. జో దావీదుచి రిసొ ఇసి సంగిలన్ ‘యెస్సయిచొ పుత్తుస్ దావీదుక ఆఁవ్ నిసాన అస్సి. జోచి రిసొ అంక సర్ద, అంచి పెట్టిచి ఇస్టుమ్ రితి జో నిదానుమ్ కెరెదె.’ ");
INSERT INTO key_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“‘అమ్‍చ ఇస్రాయేలులుతె జెర్మ పాపుమ్ గెచ్చయ్‍తొ రచ్చించుప కెర్తొసొ జవుస్’ మెన పూర్గుమ్ తెంతొ ప్రమానుమ్ సంగిల్ రితి జర్గు కెర, జో అమ్‍చొ దేముడు ఈంజొ దావీదుచి సెకుమ్‍తె యేసుకయ్ జెర్మవ టీఁవడ అస్సె. ");
INSERT INTO key_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","జో నే బార్ జతె అగ్గె, అమ్‍చి ఒండి ఇస్రాయేలు ప్రెజల్‍క, ‘తుమ్ కెర్ల పాపల్‍క పెట్టి పూర్తి దుకుమ్ జా బుద్ది జా, జా గుర్తుక బాప్తిసుమ్ నఙన’ మెన బోదన కెర యోహాను బుల్తె తిలన్. ");
INSERT INTO key_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","యోహాను జోచి కామ్ కెర కేడయ్‍తె తిల పొదులె, జోక ‘ఈంజొయి ఏక్ వేల అమ్‍చొ దేముడు పూర్గుమ్ సంగ తిలొ రచ్చించుప కెర్తొసొ జయెదె’ మెన సగుమ్‍జిన్ మాన్సుల్ ఉచర్తికయ్, అంక కో మెన ఉచర్తసు? దొర్కు జలొ జో రచ్చించుప కెర్తొసొ ఆఁవ్ నెంజి. గని అంచి పడ్తొ ఎక్కిలొ జెయెదె. జో గలన్ల జోడ్లుచ వాలివొ యిప కడుక కి అంక విలువ నాయ్, మెన యేసుచి రిసొ యోహాను సాచి సంగిలన్” మెన పవులు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","పడ్తొ పవులు అన్నె ఇసి సంగిలన్, “ఓ అమ్‍చొ పూర్గుమ్‍చొ అబ్రాహామ్‌చి సెకుమ్‍చ అమ్‍చ బావుడ్లు, అమ్‍చొ దేముడుక బిత తుమ్ అన్నె మాన్సుల్, ఈంజ రచ్చనచి రిసొ ‘దొర్కు జలి’ మెన జో అమ్‍క కబుర్ తెద్రవ అస్సె. ");
INSERT INTO key_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","యేసుక ‘దేముడు తెద్రయ్‍లొ రచ్చించుప కెర్తొసొ జొయ్యి’ మెన యెరూసలేమ్‍తెచ యూదుల్, జోవయించ అదికారుల్ తెన్ చినితి నాయ్. జోవయించి రిసొ పూర్గుమ్ దేముడు సంగ రెగ్డయ్‍ల కొడొ అమ్‍చ యూదుల్ ఎత్కి సెలవ్ కడన్లి దీసి సదు కెర్తతి, గని అర్దుమ్ నే కెరన, ‘జోక మొర్తి సిచ్చ దెమ’ మెన తీర్పు కెర, జా దేముడుచ కొడొతె రెగిడ్లిసి నెరవెర్సుప కెర్ల. ");
INSERT INTO key_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","మొర్తి సిచ్చ జతి కేన్ తప్పు జో నే కెర తిలె కి, జోవయింక జేఁవ్ పాపుమ్ వయడుక నెతిర్లె కి, ‘మొర్సు’ మెన పిలాతు అదికారిక బలవంతుమ్ కెర, మొరవ. ");
INSERT INTO key_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","జోచి రిసొ పూర్గుమ్ రెగిడ్లిసి ఎత్కి జేఁవ్ నెరవెర్సుప కెర, సిలువ తెంతొ జోచి పీనుమ్ ఉత్రవ కెర, మెస్నె ఎంగ్డవ దిల. ");
INSERT INTO key_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","జేఁవ్ దస్సి మార్లె కి, అమ్‍చొ దేముడు జోక అన్నె జియడ్లొ. ");
INSERT INTO key_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","జలె, యేసు నే మొర్తె అగ్గె, గలిలయ ప్రాంతుమ్ తెంతొ యెరూసలేమ్ ఎద జోచ సిస్సుల్ జో తెన్ బెద జా తిల. జో జీవ్ జా ఉట్ట, ఒగ్గర్ దీసల్ జోక డీస్తె తిలొ. జాకయ్ జేఁవ్ సిస్సుల్ జోచి రిసొ ప్రెజల్ ఎత్కిక సూనయ్‍త సాచుల్ జా అస్తి. ");
INSERT INTO key_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ఆము కి, ‘దేముడు అమ్‍చ పూర్గుల్‍క ప్రమానుమ్ సంగిలిసి జెయిమ్ జా అస్సె’, సుబుమ్ కబుర్ సూనయ్‍తి రిసొ ఇత్తల్ జాఁ అస్సుమ్. ");
INSERT INTO key_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","జో ప్రబు పూర్గుమ్ ప్రమానుమ్ సంగిలిసి అమ్‍చ పూర్గుల్‌చ బోదల్ జల ఆమ్ యూదుల్‍క వరుమ్ దెతి రితి జో కీసి జర్గు కెర అస్సె మెలె, యేసుక అన్నె జియడ అస్సె. దొన్ని కీర్తనుమ్‍తె అమ్‍చొ జో ప్రబు కిచ్చొ మెన యేసుచి రిసొ రెగ్డయ్‍లొ, ‘తూయి అంచొ పుత్తు, తుకయ్ ఆజి పాయిలయ్.’, మెన రెగ్డయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","‘క్రీస్తుక మారుల, గని మొర్నుతె తయె నాయ్. జియడిందె. మొర్నుతె అన్నె గెచ్చె నాయ్’ మెలి అర్దుమ్ తెన్ జో అన్నె కిచ్చొ సంగ రెగ్డయ్‍లన్ మెలె, దావీద్‍క అఁవ్ సఙిలి రితి, తుక కచితుమ్ జేఁవ్ సుద్ది తిలి వరల్ దెయిందె” మెన సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","జాకయ్, అన్నెక్ కీర్తనుమ్‍తె రెగిడ్లి రితి, పరలోకుమ్‍చి సుద్ది తిలొ ఆఁవ్ పుత్తుచి మొర్నుతె తతి రితి అంచి ఆఁగు కువుక తుయి ఒప్పిసి నాయ్, మెన దావీదు రెగిడ్లన్. ");
INSERT INTO key_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“దావీదు, జలె, జోచి కాలుమ్ దేముడు జోక దిలి కామ్ కెర కేడవ మొర్తికయ్, జోచ పూర్గుల్‍క రోవిలి రితి జోక కి రోవిల, చి మొర్నుతె తాఁ గెలన్. ");
INSERT INTO key_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","గని, దేముడు అన్నె జియడ్లొసొ, జలె, ఎద్గరె నే కువితె, మొర్నుతె తత్తి రితి గెచ్చె నాయ్. ");
INSERT INTO key_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“జాకయ్, బావుడ్లు, తుమ్‍క కిచ్చొ మెన ఆఁవ్ కచితుమ్ సూనయ్‍తసి మెలె, పాపుమ్ చెమించుప కెర్తి రచ్చన కత్తెయ్ దొర్కు జతయ్ మెలె, మాన్సు జలొ యేసుతెయి. ");
INSERT INTO key_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","అగ్గె తెంతొ అప్పె ఎద, ‘అమ్‍చి పాపుమ్ గెస్సు’ మెన, మోసే పూర్గుమ్‍చొచి అత్తి రెగిడ్లి దేముడుచ ఆగ్నల్ రితి కెర, జో సికడ్ల ఆగ్నల్ బియఁ అమ్‍చ యూదుల్ కెర్తి రితి తుమ్ కెర్తసు. గని కెద్ది కెర్లె కి, పాపుమ్ గెచ్చె నాయ్, గని యేసుక కో పూర్తి నంపజా తత్తతి గే, పాపుమ్ తెంతొ విడ్దల్ జతి వరుమ్ జోవయింకయి దొర్కు జా అస్సె. ");
INSERT INTO key_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","జాకయ్, తుమ్ జాగర్త తా, నెంజిలె, పూర్గుల్‍చి అత్తి అమ్‍చొ దేముడు సంగిలి కబుర్ తిలిసి తుమ్‍క లయెదె. ");
INSERT INTO key_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","ఆదె, తుమ్ నంప నెంజ ఆఁస్తస తా, తుమ్ దెక బమ్మ జా తుమ్‍చి పాపుమ్ తెన్ని మొర. తుమ్‍చి కాలుమ్‍క ఏక్ వెల్లి కామ్ అఁవ్ జర్గు కెరిందె. కెర్లె కి, సాచుల్ తుమ్‍క జా సంగతి సూనయ్‍లె కి, తుమ్ కెఁయఁక కి నంప కెర్సు నాయ్, మెన రెగిడ్లిసి” మెన పవులు బోదన కెర కేడయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","పవులుచి బర్నబా ఒత్త తెంతొ బార్ జతె తతికయ్, అన్నెక్ సెలవ్ కడన్లి దీసి అమ్‍క ఇసి బోదన సంగ మెన ప్రెజల్ బతిమాల్ప జా సంగిల. ");
INSERT INTO key_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","జా సబ కుట్టితికయ్, ఒగ్గర్‍జిన్ యూదుల్, పడ్తొ దేముడుక నంపజా మార్సుప కెరన నిదానుమ్ తిల జోవయించ అన్నె బక్తుల్ కి, పవులుచి బర్నబాచి పట్టి గెల. జేఁవ్ దొగుల జలె, దేముడు కెర్లి దయచి తెడి తా, మెన బతిమాల్ప జా బోదన కెర్ల. ");
INSERT INTO key_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","అన్నెక్ సెలవ్ కడన్లి దీసి అయ్‍లి, జలె, యేసుచి రిసొచి సుబుమ్ కబుర్ పావులీంసిచి అత్తి సూనుక మెన, ఒండి పట్నుమ్‍చ సబతె బెర అయ్‍ల. ");
INSERT INTO key_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","జలె ఒత్త బెర అయ్‍ల జనాబ్‍క దెక, యూదుల్‍చ వెల్లెల మాన్సుల్ ఒగ్గర్ కోపుమ్ తెన్ గోస జా, పవులు సంగిలిన్ ఎత్కిక ‘అబద్దుమ్’ మెన వేర సంగ, జోక దూసుప కెర్ల. ");
INSERT INTO key_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","తెదొడి పవులు బర్నబా తెన్ దయిరిమ్ తెన్ ఇసి సంగిలన్, “దేముడు దిలి సుబుమ్ కబుర్ తుమ్ యూదుల్‍కయ్ తొల్లితొ సూనవుక తిలి, గని ‘సత్తిమ్’ మెన తుమ్ ఒప్పనుక నెస కెర వెంట గెలి రితి కెర ‘దేముడుచి రాజిమ్‍తె బెద పరలోకుమ్‍తె గెతి జీవ్ దెతి వరుమ్ ఆమ్ నఙనుక విలువ నాయ్’ మెలి రితి తుమ్ పిట్టవన్‍తిస్‍క రుజ్జు జతయ్, చి రిసొ యూదుల్ నెంజిలసక సుబుమ్ కబుర్ సూనవుక దెర్తసుమ్. ");
INSERT INTO key_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ప్రబు అమ్‍క కిచ్చొ మెన ఆడ్ర దా అస్సె మెలె, ఒండి లోకుమ్‍చక ‘రచ్చించుప జతు’ మెన, అమ్‍చి ఉజిడి దెకయ్‍తి రితి జతి రితి, యూదుల్ నెంజిల మాన్సుల్‍క సుబుమ్ కబుర్ సూనయ్‍తి రిసొ తుమ్‍క తెద్రవ అస్సి, మెన ప్రబు సంగ అస్సె”. ");
INSERT INTO key_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","యూదుల్ నెంజిలస, జలె, ఈంజ కోడు సూన, సర్ద జా, దేముడు దిలి జా సుబుమ్ కబుర్‍క గవురుమ్ కెర్ల, చి ‘పరలోకుమ్‍చి రాజిమ్‍తె బెదుత్’ మెన జోవయింతె కక్క ప్రబు నిసాన తిలొ గే, జెఁవ్వి నంపజల. ");
INSERT INTO key_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","జా ఒండి ప్రాంతుమ్‍తె కి ప్రబుచి సుబుమ్ కబుర్ సూనయ్ జలి. ");
INSERT INTO key_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","యూదుల్‍చ వెల్లెల మాన్సుల్, పట్నుమ్‍చ వెల్లెల తెర్‍బోదల్‍తె మున్సుబోదల్‍తె గెచ్చ సికడ, జోవయించి అత్తి పవులుక చి బర్నబాక అల్లర్ కెర, జా పిసిదియ ప్రాంతుమ్ తెంతొ ఉదడ గెల. ");
INSERT INTO key_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","జేఁవ్ దొగుల, ‘ప్రబుచి సుబుమ్ కబుర్ సూనుక, జేఁవ్ యూదుల్ అవ్‍కాసుమ్ పిట్టవన అస్తి’ మెలి గుర్తుక, జేఁవ్‍చ చట్టొతెచి దూడి పంప్డ గెల కెర, ఒత్త తెంతొ తూర్పు పక్క తిలి ఈకొనియ పట్నుమ్‍తె ఉట్ట గెల. ");
INSERT INTO key_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","జా అంతియొకయ పట్నుమ్‍తెచ ప్రబుక నంపజా జోవయించ సిస్సుల్ జలస మాలఙ్ జతి నాయ్. దేముడుచి సుద్ది తిలి ఆత్మ జోవయించి పెట్టి బెర తతికయ్, సర్దసంతోసుమ్ జా, నిదానుమ్‍తె తిల. ");
INSERT INTO key_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ఈకొనియతె పవులు బర్నబా తా కెర, జా అన్నెక్ పట్నుమ్‍తె కెర్లి రితి, యూదుల్‍చి సబగేరి పెస, బోదన కెర్ల. ప్రబుచి ఆత్మసెక్తి తెన్ బోదన కెర్తికయ్, ఒగ్గర్ ఒగ్గర్‍జిన్, యూదుల్ కి, గ్రీసు దేసిమ్‍చ కి, నంపజల. ");
INSERT INTO key_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","గని నంప నే కెర్ల యూదుల్‍చ వెల్లెల మాన్సుల్, నంపజల బావుడ్లుచి రిసొ యూదుల్ నెంజిలసక గోస సికడ అల్లర్ కెరయ్‍ల. ");
INSERT INTO key_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","దస్స అల్లర్ తిలె కి, దయిరిమ్ తెన్ ప్రబుచి సుబుమ్ కబుర్ సూనవ, పావులీంసి ఒగ్గర్ దీసల్ ఒత్త తా గెల, ప్రబు జేఁవ్‍చి అత్తి వెల్లెల అద్బుతుమ్ కమొ కెర, జోచి దయచి రచ్చనచి రిసొ సుబుమ్ కబుర్‍క ‘సత్తిమ్’ మెలి గుర్తుక రుజ్జుల్ దెకయ్‍లన్. ");
INSERT INTO key_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","గని జా ఈకొనియ పట్నుమ్‍చ మాన్సుల్ దొన్ని జట్లు జల. జోవయింతె సగుమ్‍జిన్ యూదుల్‍చ వెల్లొ మాన్సుల్‍చి పచ్చెన జల, సగుమ్‍జిన్ పవులుచి బర్నబాచి పచ్చెన జల. ");
INSERT INTO key_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","యూదుల్ నెంజిలస సగుమ్‍జిన్, యూదుల్ జలస సగుమ్‍జిన్, జోవయించ వెల్లెల మాన్సుల్ కి, ‘జోవయింక దెర, పత్రల్ గల మారుమ’ మెన కుట్ర ఉచర్ల. ");
INSERT INTO key_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","గని దస్సి కుట్ర ఉచర అస్తి మెన జేఁవ్ దొగుల జాన్లి పొదిక, బే బేగి ఉట్ట గెచ్చ లుకయొనియ ప్రాంతుమ్‍చి లుస్త్ర, పడ్తొ దెర్బే మెంత పట్నలె, చి సుట్టునంతచ గఁవ్విలె గెచ్చ, ");
INSERT INTO key_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ఒత్తయ్ సుబుమ్ కబుర్ సూనయ్‍తె తిల. ");
INSERT INTO key_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","జలె, పవులు లుస్త్రతె ఏక్ సుట్టు బోదన కెర్తె తతికయ్, చట్టొ కదుల్ కెరుక నెతిర్లొ మాన్సు ఎక్కిలొ వెస తిలొ. జెర్మిల్ తెంతొ సొట్టొ జా అస్సె. చట్టొ లంబ అస్తి. ");
INSERT INTO key_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","పవులు బోదన కెర్లిసి జో సూన్‍తె తతికయ్, పవులు జోక చెంగిల్ దెక, ‘చెంగిల్ జతి నముకుమ్ జోక అస్సె’ మెన చిన కెర, ");
INSERT INTO key_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","అవాడ్ కెరన, “తుయి ఉట్ట సోగ జా టీఁవొజ” మెన సంగితికయ్, చట్కున ఉట్ట ఇండుక దెర్లొ. ");
INSERT INTO key_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","పవులుచి అత్తి కెర్లిసి జనాబ్ దెక కెర, జా లుకయొనియ ప్రాంతుమ్‍చి బాస తెన్, “దేముడ్లు మాన్సుల్‍చి రితి జా అమ్‍తె ఉత్ర జా అస్తి” మెన కేకుల్ గల. ");
INSERT INTO key_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","బర్నబాక “ద్యుపతి జయెదె” మెన సంగిల, అన్నె జేఁవ్ దొగులతె పవులు ఒగ్గర్ సంగితయ్‍చి రిసొ, జోక “హెర్మే జయెదె” మెన సంగిల. ");
INSERT INTO key_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ద్యుపతి, జలె, పట్నుమ్‍చి పుర్రెతొ గుడి తయెదె. జో పూజరి, జలె, పోతుల్‍క ఉదడ ఆన, పుల్లొ బంతివొ దెరన, పట్నుమ్‍చి గుమ్ముమె జా కెర, ప్రెజల్ తెన్ జేఁవ్ దొగులక బలి దెంక ఉచర్ల. ");
INSERT INTO key_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","దస్సి ఉచర అస్తి మెన ప్రబుచ బారికుల్ జల బర్నబా చి పవులు సూన కెర, దుకుమ్‍క సొక్కల్ చిరన, జనాబ్ తిలిస్‍తె నిగ జా, ");
INSERT INTO key_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“తుమ్ మాన్సుల్ కిచ్చొక ఇసి జతసు? ఆమ్ కి తుమ్‍చ రితయ్ మాన్సులి. తుమ్‍క ‘ఇస వెర్రి కమొ ముల పరలోకుమ్ బూలోకుమ్ సముద్రుమ్, జాతె తిలిసి ఎత్కి జెర్మయిలొ, జీవ్ తిలొ దేముడుకయ్ నంపజా చెంగిల్ జతు’ మెనయ్, సుబుమ్ కబుర్ సూనవుక అయ్‍లమ్” మెన పవులుచి బర్నబా కేక్ గల. ");
INSERT INTO key_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","“అగ్గెచ ఉగుమ్‍తె తిల మాన్సుల్ ఇస్టుమ్ అయ్‍ల రితి కెర జింక జో పరలోకుమ్‍చొ ప్రబు సెలవ్ దా తిలె కి, ");
INSERT INTO key_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","జోచి అదికారుమ్‍చ, జోచి ప్రేమచ గుర్తులు దెకవుక జో ములె నాయ్. మెలె, చెంగిల కమొ కెర్తె తిలన్, కెర్తె తత్తయ్. కీసచ మెలె, తుమ్‍క ‘సరిపుచుప జతి అన్నిమ్ దొర్కు జవుస్, తుమ్‍క పెట్టితె సర్ద తెన్ జితు కతు’ మెన, ఆగాసుమ్ తెంతొ పాని పెటవ, బుఁయిచి పలితుమ్ దెరయ్‍తయ్” మెన సికడ్ల. ");
INSERT INTO key_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","గని ఇసి బోదన కెర్లె కి, జేఁవ్ మాన్సుల్ బలి దెంక ఉచర్తిసి కస్టనె పిట్టయ్‍ల. ");
INSERT INTO key_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","తెదొడి పిసిదియ ప్రాంతుమ్‍చ అంతియొకయ చి ఈకొనియ పట్నల్ తెంతొ యూదుల్ సగుమ్‍జిన్ జా కెర, ప్రెజల్‍క సికడ్తికయ్, పవులుక పత్రల్ గల మార్ల మొర గెలన్ మెన కెర, జోక ‘మొరయి అస్సె’ మెన ఉచర, పట్నుమ్ తెంతొ ఒర్గొడ నా ములిల. ");
INSERT INTO key_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","గని ప్రబుచ సిస్సుల్ జలస అయ్‍ల అన్నె, జోచి సుట్టునంత బెర్తికయ్, జో చెంగిల్ జా ఉట్ట పట్నుమ్ తెడి అన్నె పెసిలన్. అన్నెక్ దీసి బర్నబా తెన్ బార్ జా, దెర్బే పట్నుమ్‍తె ఉట్ట గెల. ");
INSERT INTO key_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","జా పట్నుమ్‍తె గెచ్చ సుబుమ్ కబుర్ సూనయ్‍తికయ్, ఒగ్గర్‍జిన్ మాన్సుల్ నంపజా ప్రబుచ సిస్సుల్ జల, చి ఈంజేఁవ్ దొగుల బుల జా లుస్త్రతె, ఈకొనియతె, చి అంతియొకయతె ");
INSERT INTO key_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","అన్నె బోదన కెర, “తుమ్ నిదానుమ్ తా. దేముడుచి రాజిమ్‍తె బెదితి వరుమ్ ప్రబు తుమ్‍క అమ్‍క దిలెకి, కస్టల్ నెంతె పాఁవుమ్ నాయ్. కస్టల్ సేడ్తె తమ్‍దె, గని దయిరిమ్ తెన్ తా” మెన, ప్రబుక నంపజల సిస్సుల్ జలసచి ఆత్మ డిట్టుమ్ కెర్ల. ");
INSERT INTO key_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","పడ్తొ చువ్వె తా ప్రార్దన కెర, సికడ్తె తత్తు మెన, ఎత్కి సంగుమ్‍క దెకిత వెల్లెల మాన్సుల్ జతు మెన మాన్సుల్‍క నిసాన, జేఁవ్ నంపజలొ యేసుప్రబుచి కామ్ జేఁవ్ కెర్తి రితి జేఁవ్‍చి అత్తి సొర్ప కెర్ల. ");
INSERT INTO key_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","అన్నె ఒత్త తెంతొ పావులీంసి పిసిదియ ప్రదేసిమ్ వాట్ గెచ్చ, పంపూలియా ప్రదేసిమ్‍తె జాఁ కెర, ");
INSERT INTO key_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","పెర్గే పట్నుమ్‍తె సుబుమ్ కబుర్ సూనవ, అత్తాలియ పట్నుమ్‍తె పాఁవ కెర, ");
INSERT INTO key_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ఒత్త తెంతొ ఓడతె వెగ, సముద్రుమ్ జీన, సిరియ ప్రదేసిమ్‍చి అంతియొకయతె అయ్‍ల. ఒత్త అగ్గె, చువ్వె తా ప్రార్దన కెర, ప్రబుచి సుబుమ్ కబుర్ కామ్ ఈంజేఁవ్ దొగుల కెర్తి రిసొ ఇన్నెక దేముడుచి అత్తి సొర్ప కెర దా బార్ కెర తిల. జా కామ్ అప్పె జెయిమ్ జా అస్సె మెన రుజ్జు దెకయ్‍తి రిసొ, ");
INSERT INTO key_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","అప్పె ఉట్ట జా ఒత్త పాఁవ కెర, ఎత్కిజిన్‍క ఎక్కితె బుకారా కెర, దేముడు జోవయించి అత్తి జర్గు కెర్లిసి ఎత్కిచి రిసొ, పడ్తొ యూదుల్ నెంజిలస కి నంపజా రచ్చించుప జతి కోడు ప్రబు దిలిస్‍చి రిసొ సాచి సంగిల. ");
INSERT INTO key_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ఒత్త తెంతొ, ప్రబుచ ఒత్తచ సిస్సుల్ తెన్ ఒగ్గర్ దీసల్ తా గెల. ");
INSERT INTO key_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","పవులు బర్నబా దస్సి సిరియ ప్రదేసిమ్‍చి అంతియొకయతె తిలి పొది, యెరూసలేమ్ పట్నుమ్ తిలి యూదయ ప్రదేసిమ్ తెంతొ సగుమ్‍జిన్ నంపజల యూదుల్ జా కెర, యూదుల్ నెంజిలసొ, “అమ్‍చొ మోసే పూర్గుమ్‍చొచి అలవాట్ కెర యూదుల్ జతి గుర్తుచి సున్నతి కెరన్లెకయ్ పరలోకుమ్‍తె గెతి రచ్చన తుమ్‍క దొర్కు జయెదె” మెన సికడ్ల. ");
INSERT INTO key_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","“జేఁవ్ నంపజలి పొది కీసి జా సున్నతి నెంతె తిల, దస్సే తత్తు జా సున్నతి నెంతె కి రచ్చించుప జవుల” మెన, పవులుచి బర్నబా జేఁవ్ మాన్సుల్‍క జబాబ్ దిల. జేఁవ్ మాన్సుల్ సికడ్లిసిచి రిసొ సగుమ్ దీసల్ బాద సేడ లట్టబ్తె తిలె కి, జా తగు కుట్టె నాయ్. ప్రబుక నంపజలస “బారికుల్‍తె చి ఒత్తచి అమ్‍చి సంగుమ్‍చ అన్నె వెల్లెల మాన్సుల్‍తె గెచ్చ, ఈంజ తగుచి రిసొ పుస సూన్‍తు” మెన, పవులుక చి బర్నబాక చి జేఁవ్ నిసాన అన్నె సగుమ్‍జిన్‍క యెరూసలేమ్‍తె తెద్రయ్‍ల. ");
INSERT INTO key_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","జా కామ్‍చి రిసొ జా అంతియొకయ పట్నుమ్‍చి సంగుమ్‍తెచ మాన్సుల్ పావులీంసిక ప్రబుచి అత్తి సొర్ప కెర దా తెద్రయ్‍తికయ్, పేనేకే ప్రదేసిమ్ వాట్ చి సమరయ ప్రదేసిమ్ వాట్ గెచ్చ గెచ్చ, యూదుల్ నెంజిలస యేసుక నంపజా మార్సుప జలిస్‍చి రిసొ సూనయ్‍తె తిల చి, ఒత్తచ నంపజలస ఎత్కిజిన్ ఒగ్గర్ సర్దసంతోసుమ్ జల. ");
INSERT INTO key_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","జేఁవ్ యెరూసలేమ్‍తె ఉట్ట జా పాఁవిలి పొది, ఎత్కిజిన్ జోవయించ వెల్లెల మాన్సుల్ తెన్ చి, బారికుల్ తెన్, దస్సుల్ జా జోవయింక మరియాద కెల చి, దేముడు జోవయించి అత్తి జర్గు కెర్లిసి, జోవయింక తోడు దిలిసి ఎత్కి సంగిలిసి. ");
INSERT INTO key_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","గని యేసుప్రబుక నంపజల ఒత్తచ మాన్సుల్ సగుమ్‍జిన్, అగ్గె తెంతొ పరిసయ్యుల్ మెంత పండితుల్‍చి జట్టుతె అస్తి, “యూదుల్ నెంజిల జేఁవ్ మాన్సుల్‍క అమ్‍చి గుర్తుచి సున్నతి కెరుక అస్సె చి, అమ్‍చొ మోసే పూర్గుమ్‍చొచి అత్తి దేముడు దిల ఆగ్నల్ రితి జేఁవ్ కెరుక అస్సె” మెన, బలవంతుమ్ కెర్ల. ");
INSERT INTO key_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ఈంజ తగుచి రిసొ సరిగా లట్టబ తీర్పు కెరుక మెన, బారికుల్, వెల్లెల మాన్సుల్ తెన్ వెసిల. ");
INSERT INTO key_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","జా తగు సరిగా సూన ఉచర కేడయ్‍లి పొది, పేతురు టీఁవొజ, ఇసి మెన జోవయింక సంగిలన్. “ఓ బావుడ్లు, అమ్‍క ప్రబు జోచి ఆత్మసెక్తి దిలి తొలితొ చి దొరతి, ‘యూదుల్ నెంజిలస కి సుబుమ్ కబుర్ సూన నంపజతు’ మెన, అంచి అత్తి సూనయ్‍తి రిసొ తుమ్ అమ్‍చొ దేముడు అంకయి నిసాన్లన్, మెన తుమ్ జాన్సు. ");
INSERT INTO key_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","జలె, మాన్సుచి పెట్టి తిలిసి జాన్లొ దేముడు మెన. నిజుమి, జేఁవ్ కి నంపజా రచ్చించుప జా అస్తి మెన సాచి జా రుజ్జు దెకవ అస్సె. అమ్‍చి పెట్టి దిలి రితి, జోవయించి పెట్టి కి జోచి సుద్ది తిలి ఆత్మ దిలన్. ");
INSERT INTO key_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","అమ్‍క జోవయింక తేడ నే దెకితె, జోవయించి నముకుమ్‍చి రిసొ, జోవయించి పెట్టి జోవయింక కి సుద్ది కెర్లన్. ");
INSERT INTO key_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","జలె, దేముడుక సికడుక ఉచర్తసు గే, జోచ సిస్సుల్ రిత జల జేఁవ్ యూదుల్ నెంజిల మాన్సుల్‍క దస్సి జాడు వయడుక మెన కిచ్చొక ఉచర్తసు? జేఁవ్ ఆగ్నల్ వయితి పూచి అమ్‍చ పూర్గుల్ కి, ఆమ్ కి, ఓర్సుప జంక, నెరవెర్సుప కెరుక, నెతిర్లమ్. ");
INSERT INTO key_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","‘ఎక్కి అమ్‍చొ ప్రబు యేసుచి దయచి రిసొ జేఁవ్ కి ఆమ్ కి రచ్చించుప జా పరలోకుమ్‍తె గెచ్చుమ్‍దే’ మెన అమ్ నంపజా దయిరిమ్ జా అస్సుమ్” మెన, పేతురు సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","పేతురు దస్సి సంగితికయ్, బెర తిల ప్రెజల్ తుక్లె తా, యూదుల్ నెంజిలసతె పావులీంసి గెతికయ్ జేఁవ్ యూదుల్ నెంజిలసచి రిసొ ప్రబు జోవయించి అత్తి కెర్ల వెల్లెల అద్బుతుమ్ కమొ గుర్తులు ఎత్కిచి రిసొ బర్నబా చి పవులు సాచి సంగిలిసి సూన్ల. ");
INSERT INTO key_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","జేఁవ్ సాచి సంగ కేడయ్‍లి పడ్తొ, యాకోబు, జేఁవ్ సబ వెస ఉచర్లిసి బెదవ తీర్పు సంగిలన్. “ఓ బావుడ్లు, సూన, ");
INSERT INTO key_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","దేముడు యూదుల్ నెంజిలసక ప్రేమ దెక ‘అంచి నావ్‌చి గవురుమ్ దెకయ్‍తి రితి, అమ్‍చ ప్రెజల్ జేఁవ్ కి జతు’ మెన జేఁవ్‍చి తెంతొ సగుమ్‍జిన్‍క నిసానుక దెర్లిస్‍చి రిసొ, సీమోను పేతురు సాచి సంగ అస్సె. ");
INSERT INTO key_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","దేముడు ప్రబుచ కబుర్లు పూర్గుమ్ రెగిడ్లసచ కొడొ కి జా సాచి తెన్ బెదితయ్. ");
INSERT INTO key_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘పడ్తొక ఆఁవ్ అన్నె జెయిందె, చి దావీదు పూర్గుమ్‍చొచి సేడ తిలి టంబుగేరు అన్నె బందిందె. జా పాడ్ జలిసి అన్నె నొవర్ కెర బందిందె. ");
INSERT INTO key_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","లోకుమ్‍చ అన్నె మాన్సుల్, అన్నె, యూదుల్ నెంజిలసతె కో అంచి నావ్ తెడి తవుల గే, ప్రబుక చజ నంపజతు’ మెన, ");
INSERT INTO key_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","పూర్గుమ్ తెంతొ ఈంజ కబుర్ సూనయ్‍లొ దేముడు సంగ అస్సె” ");
INSERT INTO key_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","జాకయ్ ఆఁవ్ కిచ్చొ తీర్పు సంగితసి మెలె, దేముడుక నంపజా మార్సుప జల, అమ్‍చ యూదుల్ నెంజిలసక అమ్ బాద సేడవుక బెదె నాయ్. ");
INSERT INTO key_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","గని అమ్ కిచ్చొ కెర్లె చెంగిల్ మెన ఆఁవ్ ఉచర్తసి మెలె, ‘దేముడ్లు’ మెన బొమ్మల్ గట్రక దిలిసి కతు నాయ్, లంజెకమొ కెర్తు నాయ్, టొట్రొ మోడ మార్లి సిద్ర కతు నాయ్, లొఁయిఁ కతు నాయ్ మెన ఉత్రుమ్ రెగ్డవ తెద్రవుమ. ");
INSERT INTO key_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","కేన్ పట్నుమ్‍తె కి, అగ్గెయి తెంతొ మోసే పూర్గుమ్‍చొచి అత్తి రెగిడ్లి దేముడుచ ఆగ్నల్ సూనయ్‍తతి, ఎత్కి సెలవ్ కడన్లి దీసి అమ్‍చ సబ గెరలె సదు కెర్తతి, చి ఈంజేఁవ్ ఆగ్నల్‍చి రిసొ సూన తవుల. ");
INSERT INTO key_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","తెదొడి, బారికుల్‍క చి యెరూసలేమ్ పట్నుమ్‍చ సంగుమ్‍చ అన్నె వెల్లెల మాన్సుల్‍క, జా సంగుమ్‍చ మొత్తుమ్‍క కిచ్చొ అజ్జ అయ్‍లి మెలె, ‘పవులు చి బర్నబా తెన్ అమ్‍తె సగుమ్‍జిన్ అంతియొకయతె గెలె చెంగిలి’ మెన, బర్సబా మెలొ యూదాక చి సీలయుక నిసాన. ఒత్తచ నంపజల సుదల్‍తె ఈంజెఁవు ముక్కిమ్ మాన్సుల్ జవుల. ");
INSERT INTO key_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ఇన్నెచి అత్తి తెద్రయ్‍తి ఉత్రుమ్‍తె ఇసి రెగిడ్ల. “అంతియొకయతె, జా ఒండి సిరియ ప్రదేసిమి, చి కిలికియ ప్రదేసిమ్‍తె తిల యూదుల్ నెంజిల నంపజలస్‍క, బారికుల్, యెరూసలేమ్‍చి సంగుమ్‍చ వెల్లెల మాన్సుల్ జల తుమ్‍చ బావుడ్లు రెగిడ్లి ఉత్రుమ్. తుమ్‍క ‘చెంగిల్ తంక’ మెన ప్రబుక రోజుక ఉచర్తసుమ్. ");
INSERT INTO key_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","కిచ్చొచి రిసొ ఈంజ ఉత్రుమ్ రెగిడ్తసుమ్ మెలె, అమ్‍చితె తెంతొ సగుమ్‍జిన్ బార్ జా తుమ్‍తె గెచ్చ కొడొ సంగ తుమ్‍క మెన్సుతె బాద సేడవ, సిక్కు కెర అస్తి మెన సూన అస్సుమ్, అమ్‍చి సెలవ్ నెంతె దస్సి కెర అస్తి. ");
INSERT INTO key_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","జాకయ్ ఆమ్ సబ కెర్లమ్, అన్నె ఎక్కి కట్టు తెన్ ఉచర్లె, ‘చెంగిల్’ మెన అమ్‍క కిచ్చొ అజ్జ అయ్‍లి మెలె, ‘అమ్‍చ ప్రేమ తిల బర్నబాచి పవులు తెన్ కబుర్ గెతు’ మెన సగుమ్‍జిన్‍క నిసాన తుమ్‍తె తెద్రయ్‍లె చెంగిలి మెన అజ్జ అయ్‍లి. ");
INSERT INTO key_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","యేసుక్రీస్తు ప్రబుచి సుబుమ్ కబుర్ సూనయ్‍తి రిసొ ఈంజేఁవ్ దొగుల ఎదివాట్ స్రెమల్ సేడ అస్తి. ");
INSERT INTO key_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","యూదాక చి సీలయుక ఇనయింతెన్ తెద్రవ అస్సుమ్. ఇన్నె రెగిడ్లి రితి జేఁవ్ సొంత సంగుల. ");
INSERT INTO key_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","“దేముడుచి సుద్ది తిలి ఆత్మ అమ్‍క కిచ్చొ బుద్ది సంగితయ్ మెలె, అమ్‍క కి కిచ్చొ చెంగిల్ డీస్తయ్ మెలె, తుమ్‍క, ‘కిచ్చొ కిచ్చొ అమ్‍చ ఆగ్నల్ అలవాట్ కెర్తు’ మెన అమ్ జాడు వయడ్లి రితి కెరుక బెదె నాయ్. ‘ఎక్కి ముక్కిమ్‍క కెర్తు’ మెన తుమ్‍క ఉచర్తసుమ్. ");
INSERT INTO key_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","బొమ్మల్‍క గట్ర దిలిసి కా నాయ్, లొఁయి కా నాయ్, టొట్రొ మోడ లొఁయి నే గెచ్చయ్‍లి సిద్ర కా నాయ్, చి లంజెకమొ కెర నాయ్. ఈంజేఁవ్ అలవాట్ కెర్లదు మెలె, తుమ్‍క చెంగిలి. చెంగిల్ తెన్ తా”, మెన రెగ్డ తెద్రయ్‍ల. ");
INSERT INTO key_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","జేఁవ్ తెద్రయ్‍తికయ్, జేఁవ్ అంతియొకయతె ఉట్ట గెల, ఒత్త పాఁవ కెర, నంపజలస్‍క ఎక్కితె బుకారా కెర, జా ఉత్రుమ్ దిల. ");
INSERT INTO key_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","జేఁవ్ యూదుల్ నెంజిలస సదు కెర, బుద్ది సంగితి దయిరిమ్ కెర్తి జా కబుర్‌చి రిసొ సర్దసంతోసుమ్ జల. ");
INSERT INTO key_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","యూదా చి సీలయు, జలె, ప్రబుచి ఆత్మ సికయ్‍త కబుర్లు సంగితస జవుల, చి ఒత్తచ నంపజలస్‍క ఒగ్గర్ బోదన కెర, బుద్ది సంగ, దయిరిమ్ కెర్ల. ");
INSERT INTO key_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","సగుమ్ దీసల్ ఒత్త తా, ప్రబుచ కొడొ సంగ సంగ, దయిరిమ్ కెర కెర, జోవయించి ఒత్తచి కామ్ కేడయ్‍తికయ్, ‘జోవయింక తెద్రయ్‍లసతె అన్నె ఉట్ట గెతు’ మెన, జా పట్నుమ్‍చ జోవయింక “సేంతుమ్ తెన్ గెచ్చ” మెన, సర్ద తెన్ యెరూసలేమ్‍తె అన్నె తెద్రయ్‍ల. ");
INSERT INTO key_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","సీలయు మాత్రుమ్, ఒత్త తంక చెంగిల్ మెన ఉచర్లొ. ");
INSERT INTO key_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","మదెనె, పవులు చి బర్నబా అంతియొకయతె తా, అన్నె ఒగ్గర్‍జిన్ తెన్ కి, ప్రబుచి సుబుమ్ కబుర్ సూనయ్‍తె తిల. ");
INSERT INTO key_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","సగుమ్ దీసల్ గెలి పడ్తొ, “జొమ్మ, ప్రబుచి సుబుమ్ కబుర్ సంగ ఆమ్ అగ్గె బోదన కెర్ల ఎత్కి పట్నలె అన్నె గెచ్చ, నంపజలస్‍తె గెచ్చ, జోవయింక ‘కీసి అస్తి గే’ దెకుమ” మెన, పవులు బర్నబాక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","బర్నబా, మాత్రుమ్, “మార్కు మెలొ యోహానుక జేఁవ్‍చి తెన్ కడ నెమ” మెన ఇస్టుమ్ జలన్. ");
INSERT INTO key_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","గని, జా అగ్గెచి సుట్టు మార్కు జేఁవ్‍చి తెన్ బార్ జా తిలె కి, జా కామ్‍తె సరిగా నే బెదితె, జోక ముల దా అన్నె ఉట్ట గెచ్చ తిలన్, చి ‘అప్పె కడ నిలె, దస్సి అన్నె ములె దిలె కీసి’ మెన, పవులు సంగిలొ. ");
INSERT INTO key_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","జాచి రిసొ దొగుల దొన్ని మెన్సుల్ జా జట్టి జల చి, దొగుల దొన్ని పక్కలె ఉట్ట గెల. బర్నబా మార్కుక కడన, ఓడతె వెగ, సముద్రుమ్ జీన, కుప్ర, డిబ్బ దేసిమి ఉట్ట గెల. ");
INSERT INTO key_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","గని ‘అంచి తెన్ ఈంజొ జెవుస్’ మెన, పవులు సీలక నిసాన్లన్. అన్నె, ఒత్తచ నంపజలస ప్రార్దన కెర, చి కామ్‍చి రిసొ జోవయింక ప్రబుచి అత్తి సొర్ప కెర దెతికయ్, జేఁవ్ ఉట్ట గెల. ");
INSERT INTO key_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ఒండి సిరియ ప్రదేసిమి, చి ఒండి కిలికియ ప్రదేసిమ్‍త గెచ్చ కేనె నంపజలసచ సంగుమ్‍లుతె గెచ్చ బోదన కెర డిట్టుమ్ కెర్తె తిల. ");
INSERT INTO key_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ఒత్త తెంతొ, గలతీయ ప్రదేసిమ్‍చ లుస్త్ర చి దెర్బే మెల పట్నుమ్‍లుతె పవులు చి సీలయు గెల. తిమోతి మెలొ సిస్సుడు తిలన్. జో యూదుడుయి జలి అయ్యస్ తెన్, జోచి పట్నుమ్‍తె పవులు అగ్గె జా తిలిసి తెంతొ ప్రబుక నంపజా అస్తి. తిమోతిచొ అబ్బొసి, మాత్రుమ్, యూదుడు నెంజె, గ్రీకు దేసిమ్‍చొ, జో. ");
INSERT INTO key_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","జో తిమోతి చి రిసొ, “నిదానుమ్ తిలొసొ” మెన లుస్త్ర చి ఈకొనియ పట్నల్‍తెచ బావుడ్లు ఎత్కిజిన్ సంగితె తిల. ");
INSERT INTO key_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","జాకయ్, “జో కి అమ్‍చి తెన్ చి కామ్‍తె బెదుస్” మెన పవులు సంగిలొ. జో నాడుచొ అబ్బొస్ ‘యూదుడు నెంజె! గ్రీకు దేసిమ్‍చొ మాన్సు జయెదె’ మెన, జో ‘పుత్తుస్‍క యూదుల్‍చి గుర్తుచి సున్నతి కెర తయె నాయ్’ మెన, ఎత్కిజిన్ జాన్‍తి రిసొ ‘జా సున్నతి తిమోతి నే కెరన తిలె, ఆమ్ గెతిస్‍తెచ యూదుల్ నిస్కారుమ్ దెకుల’ మెన, జోక పవులు జా సున్నతి కెర దిలన్. ");
INSERT INTO key_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","జలె, ఒత్తచ పట్నల్ ఎత్కితె గెచ్చ గెచ్చ, యెరూసలేమ్‍తెచ బారికుల్‍చి ఒత్తచి సంగుమ్‍చ వెల్లెల మాన్సుల్ ఎత్కి సంగిలి తీర్పు నెరవెర్సుప కెర, మెన జేఁవ్ తీగ్ల సూనయ్‍ల. ");
INSERT INTO key_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","జా ఒండి ప్రాంతుమ్‍తెచ సంగుమ్‍లుచ సుదల్ జలె, ప్రబుచి ఉప్పిర్‍చి నముకుమ్‍క అన్నె డిట్టుమ్ జల, చి రోజుక అన్నె మాన్సుల్ ప్రబుక నంపజా మార్సుప జా జోవయింతెన్ బెదిల. ");
INSERT INTO key_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ఒత్త తెంతొ పవులు సీలయు చి తిమోతి, గలతీయ ప్రదేసిమ్ వాట్ చి ప్రుగియ ప్రాంతుమ్ వాట్ గెల. “ఆసియా ప్రదేసిమ్‍తె సుబుమ్ కబుర్ సూనవుక పోన” మెన దేముడుచి సుద్ది తిలి ఆత్మ సంగ తిలన్, ");
INSERT INTO key_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","చి ఉత్తర పక్కచి వాటు గెచ్చ, ముసియ ప్రాంతుమ్‍తె పాఁవిలె, బితునియ ప్రదేసిమి గెచ్చుక ఉచర్ల, గని జేఁవ్ ఒత్త గెచ్చుక కి యేసుచి ఆత్మ ఒప్పె నాయ్. ");
INSERT INTO key_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","జాకయ్, ముసియ ప్రాంతుమ్ జీన, సముద్రుమ్ సొడిచి త్రోయ పట్నుమ్‍తె అయ్‍ల. ");
INSERT INTO key_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","జేఁవ్ త్రోయతె నిద్ర తిలె, అందరె, ప్రబు దెకయ్‍లి సివ్న పవులు దెకిలన్. మాసిదోనియ ప్రదేసిమ్‍చొ మాన్సు ఎక్కిలొ టీఁవొజ, “అమ్‍చి మాసిదోనియ దేసిమి ఉట్ట జే, చి అమ్‍క రచ్చించుప కెరు” మెన బతిమాల్ప జా బుకార్లన్. ");
INSERT INTO key_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","పవులు జా సివ్న దెకిల్ బేగి, జేఁవ్‍తె జర్గు జలిసి అమ్‍క సంగితికయ్, ఒత్తచ మాన్సుల్‍క సుబుమ్ కబుర్ సూనయ్‍తి రిసొ ప్రబు అమ్‍క మాసిదోనియతె తెద్రయ్‍తయ్ మెన అమ్ చిన కెర, బేగి పెందలె మాసిదోనియతె గెచ్చుక బార్ జలమ్. ");
INSERT INTO key_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","జా పెందలె, త్రోయతె ఓడతె వెగ సముద్రుమ్ జీన, సమొత్రాకె మెలి డిబ్బ దేసిమి పాఁవ నిద్ర తా, అన్నెక్ దీసి సముద్రుమ్ అన్నె జీన, మాసిదోనియ ప్రదేసిమ్‍చి నెయపొలి రేవుతె పాఁవ ఉత్తిర్లమ్. ");
INSERT INTO key_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ఒత్త తెంతొ మాసిదోనియక వెల్లి పట్నుమ్ జలి పిలిప్పితె ఇండ గెచ్చ, ఒత్త సగుమ్ దీసల్ తా గెలమ్. ముక్కిమ్‍క రోమ దేసిమ్‍చి ఒగ్గర్‍జిన్ తతె తిల. ");
INSERT INTO key_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","జలె, యూదుల్‍చి సెలవ్ కడన్లి దీసి, ‘ఒత్త ప్రార్దన కెర్తతి’ మెన, పట్నుమ్‍చి గుమ్ముమ్ ఒత్తల్‍తొ బార్ జా, గాడు సొడి తిలిస్‍తె గెలమ్. గెలె, ప్రార్దన కెరుక మెన, తేర్‍బోదల్ సగుమ్‍జిన్ జా అస్తి. జేఁవ్ తిలిస్‍తె వెస, బోదన కెరుక దెర్లమ్. ");
INSERT INTO key_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ప్రార్దన కెరుక గెల జేఁవ్ తెర్‍బోదల్‍తె లూదియ మెలి ఎక్లి తిలి. జా సుది బట్టల్ గట్రచి రిసొచి ఊద రంగుచి బియ్యారి కెరెదె. ఆసియా ప్రదేసిమ్‍చి తుయత్తెర పట్నుమ్‍చి తేర్‍బోద, జా. జా అగ్గె తెంతొ దేముడుక నిదానుమ్ జా జోక బక్తి కెర్తిసి. సూన్‍తి బుద్ది తిలిస్‍చి పెట్టి ప్రబు దెతికయ్, పవులు సంగిలి బోదన సూన, జా నంపజలి. ");
INSERT INTO key_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","నంపజా, జేఁవ్‍చి గెర్‍చ ఎత్కిజిన్ తెన్ బాప్తిసుమ్ నఙన్ల. “అంక ‘ప్రబుక నిజుమి నిదానుమ్ జా అస్సె’ తుమ్‍క రుజ్జు అయ్‍లి జలె, ఇన్నె బోదన కెర్తె తిలె ఎదిలి సేంపుక అమ్‍తె తా” మెన అమ్‍క బలవంతుమ్ కెర్లి. ");
INSERT INTO key_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","జలె, ఏక్ దీసి, ప్రార్దన కెర్తిసితె అమ్ గెతె తతికయ్, గొతిమాన్సు జతి ఉబెడి ఎక్లి దస్సుల్ జలి. జా గుర్మయ్‍ని జా సివ్వల్ జంక అలవాట్ జలిస్. జాచి జా బుద్దిచి రిసొ, జాచ ఎజొమాన్లుక ఒగ్గర్ డబ్బుల్ లాబుమ్ దొర్కు జతె తయెదె. ");
INSERT INTO key_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","జా పవులీంసిచి పట్టి జెంక దెర, కిచ్చొ మెన కేకుల్ గల, జా తేర్‍బోద కిచ్చొ మెన సంగిలి మెలె, “ఈంజేఁవ్, ఎత్కిచి కంట వెల్లొ దేముడుచ సేవ కెర్తస. పరలోకుమ్‍తె గెతి రచ్చన దొర్కు జతి వాట్‍చి రిసొ తుమ్‍క సూనవుక జా అస్తి” మెన కేకుల్ గల్తె తిలి. ");
INSERT INTO key_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ఒగ్గర్ దీసల్ దస్సి పట్టి జా కేకుల్ గల్తె తతికయ్, పవులు, జోచి పెట్టి ఒగ్గర్ దుకుమ్ జా, జాచి పక్క పసుల, జాక దెర్లి బూతుమ్ తెన్, “ఇన్నెచి పెట్టి తెంతొ బార్ జా, ఇన్నెక ములు, యేసుక్రీస్తుచి నావ్ తెన్ తుక సంగితసి” మెన పవులు జా బూతుమ్‍క ఉదడ గెలన్. చి జయ్యి తెదొడి బూతుమ్ బార్ జా ముల దా గెలన్. ");
INSERT INTO key_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","‘జా తేర్‍బోద గుర్మయ్‍ని జతి తిలి పొది అమ్ దొర్కు కెరంతి డబ్బుల్ లాబుమ్ అప్పె తెంతొ నాయ్’ మెన జాచి ఎజొమాన్లు దెక కెర, పవులుక చి సీలక దెర, సంతవీది వెసిత పట్నుమ్‍చ అదికారుల్‍తె ఒర్గొడ నిల. ");
INSERT INTO key_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","“ఈంజేఁవ్ మాన్సుల్, యూదుల్, అమ్‍చి పట్నుమ్‍తె జా కెర ఒగ్గర్ అల్లర్ కెర్తతి. ");
INSERT INTO key_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","అమ్ రోమియుల్ జా అలవాట్ కెరుక కమొ నాయిమ్ నాయ్ మెలె కి, జోవయించ రితిచ అలవాట్ సికడ్తతి” మెన ఆరిచి నింద గలిల. ");
INSERT INTO key_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","జనాబ్ ఎత్కి పవులీంసిచి ఉప్పిరి కోపుమ్ జల, చి అదికారుల్ జేఁవ్ దొగులచ పాలల్ దెర కడ, జమాన్లు సుదల్ జోవయింక డండల్ తెన్ పెటుక మెన ఆడ్ర దిల. ");
INSERT INTO key_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","జోవయింక దస్సి ఒగ్గర్ దెబ్బల్ పెట్తికయ్, అదికారుల్ జేల్‍తె గల, “జేఁవ్‍క జాగర్త దెక” మెన, రకితసక ఆడ్ర దిల. ");
INSERT INTO key_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","రకితస జోవయింక తెడిచి గదితె గల కెర, జేఁవ్ నే విడ్దల్ జతి రితి, జోవయించ చట్టొక జాడు తిల బల్లల్‍క బెదితె డిట్టుమ్ బందిల. ");
INSERT INTO key_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","జలె నెడుమ్ అందరె, పవులు చి సీలయు ప్రార్దన కెర కెర, దేముడుక గనుమ్ గాయితె తతికయ్, అన్నె జేలి జలస ఎత్కిజిన్ సూన్‍తె తిల. ");
INSERT INTO key_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","తెదొడి బుఁయి కదుల్ జలి, చి పునాది తెంతొ ఒండి జేల్ కదుల్ జలి. బేగి కెవ్డివొ ఎత్కి ఉగ్డి జల, చి జేలి తిలస ఎత్కిజిన్‍క బందిల గొల్సుల్ యిపి జల. ");
INSERT INTO key_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","రకితొసొ, జలె, చెద్దొయ్ జా, కెవ్డివొ ఉగ్డి జలిసి దెక కెర, ‘జేలి జలస ఎత్కిజిన్ ఉట్ట నిగ గెచ్చ తవుల’ మెన బియఁ కెర, జోచి కత్తి కడన, జోక జొయ్యి అత్య కెరన్‍క తయార్ జలొ. ");
INSERT INTO key_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","గని “తుయి తుక కిచ్చొ అల్లర్ కెరను నాయ్. ఆమ్ ఎత్కిజిన్ ఇన్నె అస్సుమ్” మెన, పవులు కేక్ గల్తికయ్, ");
INSERT INTO key_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","జో రకితొసొ, దివ్వొ లంబడ ఆన కెర, బమ్మ తెన్ జేఁవ్ తిలి గదితె పెస, బియఁ అద్దుర్ జా, పవులుచి సీలచి చట్టె సెర్ను సేడ, జొకర, ");
INSERT INTO key_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","తిల జేలి తిలసక అన్నె డిట్టుమ్ బంద, పవులుక చి సీలక బార్ కెర, “బాబు ఇసి, ఆఁవ్ రచ్చించుప జా జతి రిసొ ఆఁవ్ కిచ్చొ కెరుక?” మెన బతిమాల్ప జా పుసిలన్. ");
INSERT INTO key_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","తెదొడి పావులీంసి, “ప్రబు జలొ యేసుక్రీస్తుచి ఉప్పిరి తూయి నముకుమ్ తియ, తుయి తుచి గెర్‍చ ఎత్కిజిని, రచ్చించుప జస్తె” మెన, ");
INSERT INTO key_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ప్రబుచి సుబుమ్ కబుర్ జోవయింక బోదన కెర్ల. జోవయింక, పడ్తొ ఒండి జోవయించి గేర్‍చక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","జేఁవ్ దొగులక జయి తెదొడి కడన, దెబ్బల్ పెట్లిస్‍చ గావ్వో ఎత్కి దోవ సుబ్రుమ్ కెర్లి బేగి, జో, జోచి గేర్‍చ ఎత్కిజిన్ బాప్తిసుమ్ నఙన్ల. ");
INSERT INTO key_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","జోచి గెరి కడన, జోవయింక అన్నిమ్ దా కెర, జేఁవ్ ఎత్కిజిని, దేముడుచి ఉప్పిరి నముకుమ్ తిల చి ఒగ్గర్ సర్దసంతోసుమ్ జల. ");
INSERT INTO key_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","అన్నెక్ దీసి పెందలె, “జేఁవ్ మాన్సుల్‍క విడ్దల్ కెర” మెన, దెబ్బల్ పెట్ల జమాన్లుక సంగ, అదికారుల్ జేల్‍తె తెద్రయ్‍ల. ");
INSERT INTO key_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","అదికారుల్ సంగిలిసి సూన, “తుమ్‍క ‘విడ్దల్ జా గెతు’ మెన అదికారుల్ సంగ తెద్రవ అస్తి. జాకయ్, బార్ జా, అల్లర్ నెంతె సేంతుమ్ తెన్ గెచ్చ”, రకితొసొ పవులుక సంగిలన్. ");
INSERT INTO key_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","గని పవులు జమాన్లుక, “ఎత్కిజిన్‍చి మొక్మె, రుజ్జుల్ నే సూన్‍తె, తీర్పు నే సంగితె, అమ్‍క పెట, జేల్‍తె గల అస్తి. ఆమ్ కి రోమియుల్ జా అస్సుమ్‍చి రిసొ అమ్‍క దస్సి, తీర్పు నే కెర్తె, సిచ్చ కెరుక నాయిమ్ నాయ్. అప్పె, కోయి సాచి నే జతె అమ్‍క విడ్దల్ కెరుక ఉచర్తసు, నెంజె. జేఁవ్ అదికారుల్ పూచి తెన్ సొంత జా కెర విడ్దల్ కెర బార్ కెర్తు” మెన, పవులు జబాబ్ దిలన్. ");
INSERT INTO key_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","జమాన్లు, జలె, అదికారుల్‍తె అన్నె గెచ్చ, ఈంజేఁవ్ కొడొ ఎత్కి సంగ దిల, చి జేఁవ్ దొగులక, ‘జేఁవ్ కి రోమియుల్ జవుల’ మెన సూన కెర, “తప్పు కెర్లమ్” మెన బియఁ గెచ్చ, ");
INSERT INTO key_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","అదికారుల్ జేల్‍తె జాఁ కెర, తప్పు ఒప్పన, జోవయింక బార్ కెర, “అమ్‍చి పట్నుమ్ ముల ఉట్ట గెచ్చ” మెన బతిమాల్ప జా సంగిల. ");
INSERT INTO key_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","జేఁవ్ పవులుచి సీలయు, జలె, జేల్ తెంతొ బార్ జా, లూదియచి గెరి గెచ్చ, బెర తిల బావుడ్లుక దస్సుల్ జాఁ, బుద్దిచి దయిరిమ్ సంగ కెర, ఉట్ట గెల. ");
INSERT INTO key_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","పవులు, సీలయు, అంపిపొలి పట్నుమ్ వాట్ గెచ్చ, అపొల్లోసియ పట్నుమ్‍తె గెచ్చ, అన్నె బార్ జా, ఒండి మాసిదోనియ ప్రదేసిమ్‍క వెల్లి జలి దెస్సలొనీక పట్నుమ్‍తె ఉట్ట అయ్‍ల. ఒత్త, యూదుల్‍చి సబగేరు ఏక్ అస్సె. ");
INSERT INTO key_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","పవులు, కేన్ పట్నుమ్‍తె అయ్‍లె, యూదుల్‍చి సబగేరి గెచ్చుక అలవాట్ కెరన అస్సె. చి ఒత్త కి, తిన్ని సెలవ్ కడన్లి దీసల్ వర్స తెన్ సబతె గెచ్చ, దేముడుచి కొడొతె తిలిసి రు