﻿USE sofia;
DROP TABLE IF EXISTS sofia.kew_vpl;
CREATE TABLE kew_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kew_vpl WRITE;
INSERT INTO kew_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Adaa Aa-me Abram-para lalo: Nena kantri-para nena onaa-para nena apaa amenu page gimoa. Neme watoade supara paina. ");
INSERT INTO kew_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Neme nemadare ruru adapu ma-ralalua. Goa pua ne ma-epealua. Nena biri ma-adaayalua. Ne madaare onaa adaapu ma-epealua. ");
INSERT INTO kew_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ne epea paliminuri nimu page epea palua. Ne waea paliminuri nimu page waea palua. Ne madaare go suna onaa rayo ma-epealua. ");
INSERT INTO kew_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Abrame-me Adaa Aa-na agaa pagoa ame-na si Lot rapu pisipi. Nipu mali 75 patinaloa Aran su gimoa pisa. ");
INSERT INTO kew_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Nipu-na ore Sera-para ame-na si Lot-para nipuna kogono onaa para oyae rayo-para Aran su-para kabisimi oyae rayo page mea pisimi. Gore nimu mo Kenan supara polalo pisimi. Goa pua nimu pua opapaisimi. ");
INSERT INTO kew_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abrame mo Sekem su-para ipua More adaa repena oak regepea pisa. Go raburi Kenan onaare go su-para asimi. ");
INSERT INTO kew_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Adaa Aa Abram piri ipua lalo: Go suri nena madu ma-ralalide onaa katoa. Go pare Adaa Aa nipu piri ipisa rabu aana reke meda wariasa. ");
INSERT INTO kew_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Go pare aemeare nipu nare ipula nane rudu Betel regepea pua sele ada go pare pisa. Betel nare pabala nane asa. Aire nare opala nane asa. Goa pua Adaa Aa-na aana reke meda warimea Adaa Aa-na bi loa lotu sa. ");
INSERT INTO kew_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Go pare awa Abram nipu puamama pua Negep opapasa. ");
INSERT INTO kew_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Go raburi go su-para reae adaa pabisada, Abram no Isip ata pisa. Gore mo reae ora adaa pabisa pulu. ");
INSERT INTO kew_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Nipu Isip regepea ipisipi raburi, ore Sarai-para lalo: Nere ora epe ona meda yade. ");
INSERT INTO kew_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Isip onaame ne adoa goa teme gore nipuna ore teme. Goa pua niri talimi pare nere pa ma-aalimi. ");
INSERT INTO kew_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Goa peaga na baani lape. Go rabu nimumi ni waru surubalimi. Neme goa te rabu ni rabameali. ");
INSERT INTO kew_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abram Isip ipisa raburi Isip onaame mo ona epe ona meda adisimi. ");
INSERT INTO kew_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Go raburi Pero-na kogono surube aanumi adoa, nimumi epe ona meda adoa ipulumalo Pero pua lakisimi. Gore nipu Perome mo ona pua meatepa loa nipuna ada-para aainasa ");
INSERT INTO kew_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Abram-re Serana baani kone isapulu Abram waru surubisa. Go rabu Abram nipu mena sipisipi-para doki mena para gawanu meme menanuna ru wai lapona page, kemele menanu-para kogono onaa page kasa. ");
INSERT INTO kew_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Goa pisa pare Adaa Aa-me yaina igi wae meda Pero-para nipuna onaa piri popenasa. Gore Pero-me Abram-na ore misa-pulu goa pisa. ");
INSERT INTO kew_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Go rabu Pero-me Abram-para ipuloa lalo: Na ore yade lore akolo nalae pae? ");
INSERT INTO kew_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Akepeada na baani epa laeya? Goane ni meawadega abiare nena ona wala mea. Goa pua mea pu. ");
INSERT INTO kew_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Go rabu Pero-me nipu-na kogono aanu-para loa apo repaya-para nipuna oye rayo page nipuna epapenane wala pena pua rapatepa sa. ");
INSERT INTO kew_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Go rabu Abram Isip awa wala Negep pisa. Ore-para nipuna oyae rayo page mea pisa. Lot page nipu rapu pisa. ");
INSERT INTO kew_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Go raburi Abram-re gawana page gol silpa lapona page amonaki meda asa. ");
INSERT INTO kew_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Oropere Negep gimoa Abram nipu sumeda-para puamama pua Betel epa opapasa. Nipumi abaripia sele ada Betel-para Ai lapona rikirana pisaya. ");
INSERT INTO kew_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Go parere aana reke meda ririnane warisade pare. Gore Abram-me go pare Adaa Aa-na bi loa lotu sa. ");
INSERT INTO kew_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot nipuna ruru-para nipuna kogono onaanu page Abram rapu pamisimi. Nipumi page gawa sipisipi meme menanu page adapu punisa. ");
INSERT INTO kew_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Su regepesa pulu nipu lapo padane-para ape awi naisa. ");
INSERT INTO kew_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Go su-parare Kenan ruru-para Peris ruru page asimi. Go rabu Abram-para Lot lapona mena surube aanumi ratu yawala-pasimi. ");
INSERT INTO kew_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Go rabu Abram-me Lot-para lalo: Sana rikirana ratu nayawapana, sare aaraya yapulu sana kogono aanumi page ratu nayawena. ");
INSERT INTO kew_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Suri dina apo iyada, abia sare apupapana rana-paliade nanere meania. Medane ne palidare gore medanere ni pono. ");
INSERT INTO kew_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot-me adamonisa pare mo Jordan suri paune ipa segene su epe meda isa. Adaa Aa-na maapumi adesa. Go suri Soar regepea isapulu Isip sumi adesa. Go raburi Adaa Aa-me Sodom Gomora lapo ambi natiaina. ");
INSERT INTO kew_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Mo aa lapo apupaisipi pulu Lot-re nare ipulanane isa Jordan awaro paune suna pisa. ");
INSERT INTO kew_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram Kenan su-para aisa raburi Lot-re Sodom ada kagure regepea nipuna sele ada mo Sodom awaro paune suna pisa. ");
INSERT INTO kew_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Go rabu Sodom onaanumi waeanu waru pisimi, goa pua Adaa Aa-para page waea waru pisimi. ");
INSERT INTO kew_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot aba penaloa Adaa Aa-me Abram-para lalo: Apo ayepare awa iniminipa, goa pua nare opea nane page, pabea nane page sula popea lapona page ada. ");
INSERT INTO kew_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Apo adae su rayo, ne para nena madu maralalide ruru repara gudiayato. ");
INSERT INTO kew_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Neme nena maralalide onaare, dorupa maralalua. Goa pua dipiaperupa page maralimi. ");
INSERT INTO kew_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Apo surayo abi pua ada, go nepamuae su rayo ne gialo. ");
INSERT INTO kew_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Gore Abram-me nipuna sele ada yokoria Hebron pua, mo Mamre repena oak puti regepea pua pisa. Goa pua Adaa Aa-na aana reke meda warisa. ");
INSERT INTO kew_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Go raburi Amrapel Sina-na aamudu-para, Ariok Elasa-na aamudu-para, Kedolaoma Elam-na aamudu-para, Tidal Goim-na aamudu alare, ");
INSERT INTO kew_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","nimumi Bera Sodom-na aamudu-para, Bisa Gomora-na aamudu-para, Sinap Adma-na aamudu-para, Semeber Seboim-na aamudu-para, Bela (abiare Soar teme) gona aamudu-para go ruru ala rapu yada pula pisimi. ");
INSERT INTO kew_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Go adare supuna yadapi aanuri, Sidim awaro paune suna kiritasimi. Go parere abiare Aipa Ipa teme. ");
INSERT INTO kew_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Yada abi napi aware Kedolaoma-na rolopara mali 12 pirisimi. Wala malinare nimumi agaa napagesimi. ");
INSERT INTO kew_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Wala mali meda popenalomea Kedolaoma rapu ralasimi aa mudunumi yada pua pumea go ruru wini pisimi. Repaim ruru Estorot Kanaim aisimi-para, Susi ruru Am adare-para pati page, mo Em ruru awaro paune su Kiriataim pati page, ");
INSERT INTO kew_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","mo Or ruru so Seir rudu pati page, ora pua mo kapune suna rugi Elparan pua pabo tu kiritisimi. ");
INSERT INTO kew_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Goa pua nimumi wala pereketua En Mispat pisimi (go suri abiare Kedes teme). Goa pua aamudu malapu-na rurumi Ameleke-na su ada luabu pabotu rubisimi. Nimumi mo Asason Tama su-para pati Amori ruru page pabo rubisimi. ");
INSERT INTO kew_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Go rabu Sodom Gomora lapo-para, Adma-para, Siboim-para, Bela nipuna bi meda Soa-para, go aamudununa yadapi aanumi, yada roborobo maga-ari ipua, Sidim awaro paune pare kiratawa, ");
INSERT INTO kew_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Kedolaoma Elamana aamudu-para, Tidal Goimana aamudu-para, Amrapel Sinana aamudu-para, Ariok Elasana aamudu aala rapu yada pisimi. Gore nimu aamudu malapu rapu aamudu supu rapu yada pisimi. ");
INSERT INTO kew_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Go raburi mo su Sidimire awaro paune kolta mi naaku adapu isa. Sodom Gomora lapona yadapi aanu-para nimuna aamudunu page pogola pisimi. Medalomare mo kolta mi naaku para lopisimi. Medalomare so rudu rudu pogola pisimi. ");
INSERT INTO kew_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Mo aa mudu mala-na yadapi aanumi Sodom Gomora lapona oyae rayo mea pisimi. ");
INSERT INTO kew_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Abram-na amena si Lot page go Sodom su-para aisa pulu, nipu para nipuna oyae rayo page mea pisimi. ");
INSERT INTO kew_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Aa meda pogola pisa aamere, Hibru aa Abram apo remaa rayo epa lakesa. Go raburi Amorait aa meda Mamri-na repena puti para Abram rapu epa asa. Mamri para nipuna ame Esko-para Ane lapo, nimu Abram rapu upasimi. ");
INSERT INTO kew_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Go rabu amena si Lot iyanumi mea puamelo pagisa raburi, nipumi nipuna ruru para asimi yada pape aanu para madini aanu page 318 yasa. Goa pua mo iyanu nimu Dan adare pua ratu kiritisimi. ");
INSERT INTO kew_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Go ribare Abram-me nipuna aanu epa rumasa. Goa pua yadaa isimi. Go yada wini pua Damaskas regepea ae adare Oba regepea pua ratu kiritisimi. ");
INSERT INTO kew_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Abram-me apo mea pisimide oyae rayo-para Amena si Lot-para ona-repa para pa onaanu page rayo wala mea ipisa. ");
INSERT INTO kew_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abram-me mo Kedolaoma rapu ralasimi ruru pabo ruboa ipisa raburi, Sodom-na aamudumi Abram mo Save awaro paune pare madaata ipisa. Abiare go parere Aamuduna Awaro Paune su teme. ");
INSERT INTO kew_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Gote Adaa Aa mudu-na miru irae aa pris Melkisadek-me bret wain lapo mea ipisa. Nipuri Salem-na aamudu. ");
INSERT INTO kew_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Nipumi Abram maepeata-awa goa sa: Su yaa lapo warini Gote Adaa Aa Mudu-me ne ora maepeaina. ");
INSERT INTO kew_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Nena iyanu nena kipara mea giaa Gote Adaa Aa Mudu ora so mada pena. Go rabu Abram-me mo mea ipisa yaenu rayona 10 ap Melkisedek kasa. ");
INSERT INTO kew_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Mo Sodom-na aa mudumi Abram para lalo: Oyae rayore nena meainaga niri onaa komea giaina. ");
INSERT INTO kew_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Gore Abram-me mo Sodom-na aa mudu para lalo: Neme Adaa Aa, Gote Adaa Aa Mudu, su yalapo warisa Gote-para ora lalo: ");
INSERT INTO kew_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","nena nonapi yaere neme ogeda page namealua gore neme lalo: Abram ma-ama yaisu tepulu. ");
INSERT INTO kew_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ni yae meda na-mealua pare na aanumi aba nameya yaenu komea meano, go page nirapu puame aa repo Ane-para Eskol-para Mamre aalana komea nina iyanu rapu yada pamega go repare kalaina. ");
INSERT INTO kew_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Goanu aba pinaloare, adea-podena Gote-na agaa gupa ipisa: Abram, pala naomape. Niri nena ralubi yade, Neme nere oyae waru gialua. ");
INSERT INTO kew_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Gore Abram-me lalo: O Adaa Aa mudu neme niri ake gialiya? Niri naki meda namadu idega, Ninaa oyae rayore Eliesa gode Damaskas aame mealia. ");
INSERT INTO kew_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Gorabu Abram-me lalo: Niri nogo-naki meda nagenede, goa pea pulu nina oyae rayore nina kogono aame rayo mealia. ");
INSERT INTO kew_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Gorabu Adaa Aa-na agaa gupa ipisa: Nena oyae go aame namealia, pare nena madilide nakimi, nena oyae rayo mealia. ");
INSERT INTO kew_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Nipu amanane mea pua goa sa: So yaa-para adasa, mada dipialiri so ubakedonu dipia. Gorabu goa sa: Neme maralalide onaare gorupa ralalimi. ");
INSERT INTO kew_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram-me Adaa Aa-na sa agaa kone rulasa. Gorabu, Adaa Aa nipu redepone aa sa. ");
INSERT INTO kew_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Wala Adaa Aa-me nipu-para goa sa: Niri ora Adaa Aa, neme ne Kaldia suna Ur piri mea epawadere, go su ora ne gudiyatalo pawade. ");
INSERT INTO kew_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Gorabu Abram-me lalo: O Adaa Aa mudu, neme go su na yaadelore akepu mada makualuaya? ");
INSERT INTO kew_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Gore Adaa Aa-me nipupara lalo: Ni piri mena gawa meda para meme mena wai-para, sipisipi yadapu meda page rayo mali repo pati mea ipu, yaa puluma lapo page mea ipu. ");
INSERT INTO kew_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abram-me mo yaenu rayo Gote piri mea ipua, lapolapolo loralapata pua rikirana pora masawa amupisa. Yalapo komea goa napi pa isa. ");
INSERT INTO kew_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Gorabu yaa itayamame nolalo riya ipisimi pare, Abram-me ratu rubebe pisa. ");
INSERT INTO kew_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Nare pabola popesa raburi, Abram nipu u adaa meda patisa. Gorabu nipu adaa riba medame rigitaniasa rabu pala omesa. ");
INSERT INTO kew_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Gorabu Adaa Aa-me nipu para lalo: Neme go piare waru makuape, neme maralalide onaare ada medanini kimisu onaanurupa awalimi, goapua nimuri go alimide su ada onaana slav kogono pae onaa alimi. Go onaana kogonore mali 400 rupara radapi kogono pualimi. ");
INSERT INTO kew_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Goa palimide su adarenuri neme page nimu keda waru katoa, wala orope nimu gima epalimi raburi, nimumi oyae adapu mea epalimi. ");
INSERT INTO kew_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Go yapare nere lo kumana rupara awa omali. ");
INSERT INTO kew_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Nena ruru onaare go su-para abi naepalimi. Akoloya Amor onaame waea pa palaeme. Nimuna waea waru palaina loare pane ratu rubalua. Go rabu nena rururi kaara maala popenaloa nimu wala epalimi. ");
INSERT INTO kew_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Nare paboa riba saraburi, miru yawapalae repenagaa sosopene-para paa meda page pata paa rupa roriaa ipua mena paaki lapona rikirana popesa. ");
INSERT INTO kew_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Goyapinare Gote-me Abram rapu agaa rogasa. Goapua lalo: Nena rururi go su kalalo, go ipa Isip pua mo ipa Yupritis rupara ");
INSERT INTO kew_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","abia go suri Keni onaa-para, Kenis onaa-para, Kadmon onaa-para, ");
INSERT INTO kew_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Et onaa-para, Peris onaa-para, Repaa onaa-para, ");
INSERT INTO kew_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amori onaa-para, Kenan onaa-para, Gigasi onaa-para, Sebus onaa-para, gonu pimi suri ne gialo. ");
INSERT INTO kew_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abram-na ore Sera nogo-naaki na madiasa. Yapare nipuna kogono pae, Isip nogo Ega asimi. ");
INSERT INTO kew_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Gore Sera-me Abram para lalo: Adaa Aa-me ni nogo-naaki na geadega na kogono nogo rapu patalipina. Nipu mada nina ruru madaa maopaina. Abram-me Sera-na sa agaa ratisa. ");
INSERT INTO kew_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Abram-me nipu Kenan mali 10 awa ore Sera-me nipuna kogono pae Isip nogo Ega mua aani ore ma-aulainalo kasa. ");
INSERT INTO kew_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram Ega rapu patisa, goa pua naaki pada pirisa. Nipu naaki pada pirisa makuawa nipuna surube onana rolo para napiri agaa napagisa. ");
INSERT INTO kew_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Gore Sera-me Abram-para lalo: Go adalo kedare neme adape keda rialo. Nina kogono nogore nena kina sawade, goa pua abiare nipu naki pada pilo makuawa nina agaa na pagea. Adaa Aa-me ne-sana rikirana rumaina. ");
INSERT INTO kew_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram-me lalo: Nena kogono nogore nena kina iya. Nena kone-para paliare pape, gore Sera-me Ega udipa pisa pulu nipu pogola pisa. ");
INSERT INTO kew_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Adaa Aa-na Ensol-me Ega mo ipa repaa-para su kapune pare adesa. Go ipare mo Sur pora paginane popea. ");
INSERT INTO kew_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Gore Ensol-me lalo: Ega, Serana kogono nogo, apara awa, wala apara polalo pi? Nina surube ona Sera pogola pulu. ");
INSERT INTO kew_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Gore Adaa Aa-na Ensol-me nipu goa lakesa: Nena surube ona Sera piri wala pua, nipuna agaa pagape. ");
INSERT INTO kew_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ensol-me lalo: Nena rururi ma-adayalua, goa pua dipiape rupa page maralimi. ");
INSERT INTO kew_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Adaa Aa-na Ensol-me wala lalo: Nere naki pada-pi pulu naki madiali. Nipuna biri Ismael lape, akoloya, Adaa Aa-me nena re-e pagade. ");
INSERT INTO kew_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Nipuri kira mena raa yana rupa alia. Nipu onaa rayo rapu yada-kepealia rabu onaa rayome nipu yada-kepealimi, goa pua nipuna onaa rayo gimua agurapo alia. ");
INSERT INTO kew_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ega-me Adaa Aa go bi kasa: Akoloya ni Ade Gote. Nipumi lalo: Abiare ni adea Gote-re adalo. ");
INSERT INTO kew_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Go ipa-na biri, Bia La Roi teme, abia page go ipare Kades para Bered lapona rikirana popea. ");
INSERT INTO kew_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ega-me Abram-na naki madiasa, goa pua Abram-me, Ega-me madiasa nakina biri Ismail sa. ");
INSERT INTO kew_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram-na mali 86 patinaloa Ega-me naki madiasa. ");
INSERT INTO kew_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abram-na mali 99 patinaloa, Adaa Aa nipu piri ipua lalo: Ni Gote purina-re yapulu oroyalo nina rolo-para pirape. Goa pua epeanu pape. ");
INSERT INTO kew_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Nina rogae agaa nerapu ora palua, goa pua nena onaa maadayalua. ");
INSERT INTO kew_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Go rabu Abram nipu suna adaneawa kubuniasa, go rabu Gote-me nipu-para lalo: ");
INSERT INTO kew_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Go rogatepa agaana papeare go lapatoda nere ruru adapuna aara pirali. ");
INSERT INTO kew_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Nere abiare Abram pida wala nateme, nena biri abiare Abraham teme, akoloya nere abia onaa adapuna aara maapiralua. ");
INSERT INTO kew_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ne madare ini adapu etalia. Goa pua ruru adapu pitimi pare medalomare aa mudu pitimi. ");
INSERT INTO kew_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Go rogatepa agaare oroyalo salia. Goa pua ne sana rikirana page, gome madu saliade nogo nakinuna rikirana page, nimina Gote pitua. ");
INSERT INTO kew_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Go Kenan onaana su ne abia go kimisu ipua epaa ayere, neme nepara nena orope madusalide nogo naki walo diayawa, niri nimina Gote pitua. ");
INSERT INTO kew_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Goa pua Gote-me Abraham-para lalo: Nere neme goapa toadare waru ratape nepara nena ruru orope epaliminu page, neme go rogatepa agaa waru pagoa ratalepape. ");
INSERT INTO kew_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Nerapu agaa gupa rogato. Nena ruru orope epaliminu page, Nimi goa pipape. Aa naki rayona yogane puduri rugutapape. ");
INSERT INTO kew_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ora rayona yogane puduri rugutapape. Go robore sana roga i-agaana robo. ");
INSERT INTO kew_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Naki rayore yapi 8 popenaloare, yogane puduri rugulatepape, orope maralalimide rayona page komea goa pipape. Pa ruru para kaboria epe onaana sinuna page kogono aanuna sinu page. ");
INSERT INTO kew_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Nena adare-para madininu page kaboria epenuna page go rayona yogane puduri ora rugulatepape. Go robomere nina, nimi rapu rogae agaare (pa sama lama palia). ");
INSERT INTO kew_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Yogane na ruguteade aanakinuri nina ruruda diaga ratu rubape, gore nina rogae agaa ruguta. ");
INSERT INTO kew_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Gote-me Abram para wala lalo: Nena ore Saraina, bi rado ma-ato, abiare nipuna biri Sarah lape. ");
INSERT INTO kew_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Nipu neme maepealua, goa pua nena naki mada madialia. Nipu neme maepealua pulu nipu mada ruru adapu epalimi. Aa mudunu page nipu mada opalimi. ");
INSERT INTO kew_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Go rabu Abram-me kubuniawa, Gote adaa bi kasa, nipume giri-loa kone gupa isa. Gorupa mali 100 pope yomagae-na naki madiata pae? Sarah page mali 90 yadega naki mada madialia pae? ");
INSERT INTO kew_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Gore Abram-me Gote para lalo: Nena lae-are Ismael mada na palipae? ");
INSERT INTO kew_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Go rabu Gote-me lalo: E, yapare, nena ore Sarah-me nena naki mada madialia, goa paliaga, nipuna biri Aisak lape. Nina rogae agare nipurapu palua, go rogalipade aagare orope maralaliade ruru rapu page pa sama lama palia. ");
INSERT INTO kew_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Nena si Ismail-para page, nena laedea pagawade. Nipu page neme epea palua. Nipu nogo-naki page adapu katoa, neme ne madare ruru adapu page maralaina toa. Nimu aamudu 12 page piralimi, goa pua neme nipuna rururi puri waru pabenatoa. ");
INSERT INTO kew_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Go yapare nina rogae aagare Aisak rapu rogalua, mo mali medana Saraha-me madialiade naki rapu. ");
INSERT INTO kew_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Gote-me Abraham rapu aaga lo kirituare nipu pisa. ");
INSERT INTO kew_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ora go yapinare Abraham-me nipuna si Ismael para, nipuna adarupara madini naki rayo para moneme kaboria epe-naki rayo page nipuna adarepara asimi aanaki rayona yogaene puduri rugulaisa. Gote-me lakisade rupa. ");
INSERT INTO kew_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham nipuri mali 99 patina loa, yogane pudu rugusa raburi, ");
INSERT INTO kew_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","si Ismael-re mali 13 patina loa. ");
INSERT INTO kew_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abraham para si Ismael lapore meda rabu go yapina yogane pudu rugusipi. ");
INSERT INTO kew_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Go raburi Abraham-na su-ada para asimi aa naki rayopara pa su medapara kaboria ipisa aa nakinuna page rayo nipu rapu yogane rugusimi. ");
INSERT INTO kew_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Adaa Aa Abraham piri wala ipisa, mo Mamre-na adaa repena puti regepea narepame riripu waru pisa pulu Abraham nipuna sele ada poragape para pirisa. ");
INSERT INTO kew_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abraham-me adasaisa pare aa repo pa go pare reka aina adisa. Nipumi nimu adoare sele ada gimoa aloma madari pua alu pua kubunaisa. ");
INSERT INTO kew_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Nipumi lalo: Naa adaa aanu, epea pamega, nimi nina ada nagimoa pulupape. Ni nimina kogono aa. ");
INSERT INTO kew_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ipa aba mea gula epono, goa puare nimina age aba radepeano go ada repena repara kitu piramina. ");
INSERT INTO kew_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Neme nimina nape eta meata pono, goa puare puri mua nimina polalo pame nane palimina. Nimi naa adanane epamenada rana piaga nimina eta managolano. Nimumi lalo: Mada, nena laeare paina. ");
INSERT INTO kew_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Gore aipapulu Abraham nipu Sarah piri sele adapara pisa. Nipumi goa-pua sa: Aipapulu plawa 20 kg ora epede waru adaapu managola, pereke-yoa bret waria ira. ");
INSERT INTO kew_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Wala aipapulu nipuna gawa menanu aisimi para aloma pisa, goa pua epe pena apa ae yandapu mena meda pua mua nipuna kogono aa epa kaloa aipapulu managolatepa sa. ");
INSERT INTO kew_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Mo gawa mena aba risa raburi gawana midi para gawana adu ipame warini eta-para mo gawana adu ipa medaloma mea ipisa. Goa pua mo kimisu aa repo epa kasa. Go eta nala pirinare, nipu repena repara suruba adoaisa. ");
INSERT INTO kew_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Nimumi lalo: Nena ore Sarah akepa? No sele adapara no piada-sa. ");
INSERT INTO kew_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Go rabu mo aa medame lalo: Ora go-dina ne piri para wala malina epalua, nena ore Sarah-me naki meda madu saba piralia. Gore Sarah-re nimuna masanane sele ada poragape para pirua pagaba pirisa. ");
INSERT INTO kew_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham para Sarah lapore onagae yomagae lapo pirina. Sarah nogo-naki page madiape ai nai rabu. ");
INSERT INTO kew_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sarah-me nipuna agurapo pirua giri loa, goa kone isa. Niri aba ora onagaesi yade, nina adaa aa page ora yomagaesi yande pare ni mada go padane para patape rana salia pae? ");
INSERT INTO kew_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Go rabu Adaa Aa-me Abraham-para lalo: Neme lalo agaanare Sarah-me giri akolo tapae: Niri onagae yadega neme naki meda madialua yapae? ");
INSERT INTO kew_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Yae meda Gote-me papeare mada napaliaya? Wala malina apo epalua lawade raburi Sarah-me naki mada madu saba-piralia. ");
INSERT INTO kew_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sarah palame omisa pulu yagaa loa: Giri nalawadesa. Nipume lalo: Giri laedega yagaa nalapesa. ");
INSERT INTO kew_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Mo aa repo polalo rekesimi rabure nimumi Sodom adaniasimi. Goa pua Abraham-me nimu pulumi rupa adoa rapatalo nimu rapu puamama pisa. ");
INSERT INTO kew_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Go rabu Adaa Aa-me lalo: Neme pulalo pi-are Abraham-re kudiri palua pae? ");
INSERT INTO kew_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abraham-me maralaliade rururi adayoa puri komeada pabalimi, goa pua nipu madare go suada rayo epeama palia. ");
INSERT INTO kew_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Neme nipu aba mada-misu pulu nipumi nipuna nogonaki-para nipuna adare para aeme onaa rayo mana tea. Neme katoa agaa ratinaloa nimumi epea pua ni epe kone gina. Goa pua Adaa Aa-me Abraham-me maralaliade rurunu page palua siade aonuri ora palia. ");
INSERT INTO kew_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Gore Adaa Aa-me lalo: Sodom Gomora supara pimi onaame peme wae-yaenuna, agaa ora adapu epeada. ");
INSERT INTO kew_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ni gopara pulu, nimuna peme waea adola, goa pua ora yapalo nabipa adaluame. ");
INSERT INTO kew_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Gore aa lapo Abraham gimoa Sodom adarena poranini pisipi. Adaa Aa-re Abraham aisa pare pa aisa. ");
INSERT INTO kew_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Go rabu Abraham nipu Adaa Aa regepea ipua lalo: Neme epe onaa para wae onaa rayo taliya? ");
INSERT INTO kew_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Go adare para epe onaa 50 pitimire, neme nimu page wae onaa rapu pa taliya? Neme mogo epe onaa 50 niminawa go adare pa inateya? ");
INSERT INTO kew_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Nemere epe onaa-re, wae onaa tala-arare nataliya? Mo wae onaa me pemea madaa, epe onaa rada nanena, neme goa napaina. Nere onaa rayo rumae aa yade pulu; epea ora paina. ");
INSERT INTO kew_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Adaa Aa-me lalo: Epe onaa 50 piralimi-dare gore pana bina natalua. ");
INSERT INTO kew_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Gore Abraham-me nipu wala lorapisa: Adaa Aa, neme wala rana lapopa agaa mealo. Niri taaga para do lapo rupa yade. ");
INSERT INTO kew_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Goa peaga 45 epe onaa piralimiri mo 50 ma-epapena supu diayaliare pa taliya? Neme 45 adaluare, gore nataluasa. ");
INSERT INTO kew_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Rana repopa wala Adaa Aa para goa sa: Gore 40 ama yaliare, gopage pa taliya? Adaa Aa-me lalo: 40 piralimi-dare gimalua. ");
INSERT INTO kew_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abraham-me lalo: Adaa Aa neme ratu na yawape, wala agaa meano, gore 30 yaliare, ake paliya? Adaa Aa-me lalo: Neme yada na palua 30 piralimi da page. ");
INSERT INTO kew_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abram-me lalo: Ratu na yawape neme ne wala apo agaa mealoga. Pa 20 komea yalia-dare ake paliya? Nipumi lalo: 20 komea piralimi page natalua. ");
INSERT INTO kew_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abraham-me wala lalo: Adaa Aa neme ni ratu na yawape, pare neme ne rana-komea wala agaa mealo. Gore pa 10 ama yaliare ake paliya? Nipumi gorupa abusa: Ora 10 ama yalia page na talua. ");
INSERT INTO kew_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Gore Adaa Aa-me Abraham rapu agaa lo kirituare nipu pisa, go rabu Abraham nipu page ada pisa. ");
INSERT INTO kew_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Aebore mo Ensol lapo Sodom pua opapaisipi. Gore Lot-re adarena kerepo para pirisaya. Nipumi nimu adoare, rekataboa nimu madata pisa, goa pua iniaga su kaloa ma kubunaisa. ");
INSERT INTO kew_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Na adaa aa lapo, nipumi lalo: Nipina kogono aana adapara kitumu, age radepe, patalipina. Goa pua ribarekore nipina palipina. Dia nipumi lalo: Mo onaa kiritaemede amaa patalipa. ");
INSERT INTO kew_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Lot-me ora dia loa puri pabisa pulu nipuna adapara pisimi. Nipumi eta managolaisa, bret page ist nai irua nisimi. ");
INSERT INTO kew_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Nimu u pena patulalo pala pirinare Sodom adare para asimi aa rayo, oge adaa rayome ada epa kutapu sabasimi. ");
INSERT INTO kew_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Nimumi Lot yasimi: Go riba epapede aa lapore ake pape? Amaa nia piri mea ipu, niame nipu pake namona. ");
INSERT INTO kew_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot nimu adolalo amaa pulawa poragape waru moganiasa. ");
INSERT INTO kew_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Goa pua lalo: Dia na adami aanu go wae-yaere na palimina. ");
INSERT INTO kew_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Adalepa, niri nogo lapo, aa rapu abi napati madu ide. Nipu amaa mea epono goa pua nimina rana ratalimina. Go aa lapore yae meda na palimina. Nina ada epape pulu neme nipu ora rabamealua. ");
INSERT INTO kew_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Nimumi talo: Pane popa a. Goa pua nimumi lalo: Apo aare pa epa ae aa yade, goa pua abiare nipumi nia surubaluame pana. Aa lapo mada pulaa-pamaare, ne madaa ora waea waru pumuna. Nimumi Lot pane orolo paisimi, goa pua pora gape atubitua rupara odobatalo pisimi. ");
INSERT INTO kew_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","No rupara pirisipide aa lapome Lot yolorua pora-gape agolaeme garula sasipi. ");
INSERT INTO kew_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Goa pua nipume mo pora-gape para asimide aanu, oge adaa lapo ratana ini ma-rubu paama pisipi. Goa pisa pulu nimumi pora gape adape rupa marisimi. ");
INSERT INTO kew_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Mo aa lapome Lot-para lalo: Go para nena onaare meda aeme? Nena siwanenu page, gonuna siwanenu page, o pa nena onaanu page go ada kagure-para meda aeme? Aipapulu pua lamu-mua, pane pogola pulupa. ");
INSERT INTO kew_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Ake peada ya, go su adare apo pabo tu rubalepada. Go adare-para aeme onaame peme waeare ora adata pulu, Adaa Aa-me go adare pabotu rubaponalo sa mea reparia. ");
INSERT INTO kew_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Go rabu Lote-me wane lapo mulalo pi akua lapo laketa pisa. Nipumi pua lalo: Go su aipapulu gimoa pane pogola baini sa, Adaa Aa-me go ada kagure pabo rubolalo pia! Gore akua lapome pa makirata kone isipi. ");
INSERT INTO kew_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Riba rekore mo Ensol lapome, Lot aipapulu ma rekaisipi. Nipumi goa sipi: Aipapu tapa! Go aeme nena ore para wane lapo page. Gore go ada kagure talawa nimi talia. ");
INSERT INTO kew_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lot-me aipapu na sa raburi, mo Ensol lapome kimina misipi, ore wane lapona ki mina mua aipapulu adarena amanane mea pisipi, gore Adaa Aa-me nimu odome omesa. ");
INSERT INTO kew_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Nimu ama mea ipuare, mo aa medame goa sa: Pogola pulupa! Goa puare wala napereketua adalepape. Mo paune pare palimi rabu page kitu na piralepape! Nimi omalimiga so rudu rudu pogola pulupa. ");
INSERT INTO kew_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Naa Adaa Aa-laapo, sogo rudu rudure ora dia. ");
INSERT INTO kew_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Niri aba raba meape-de, go page ni epe kone sua raba meapede pulu, rana sogo rudu rudure pope-ai nasala, pena pulano apo yaeme ni mealia pulu, ni omalua. ");
INSERT INTO kew_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Mogo ayaa oge adare parare mada palua. Ni pogola go para pono, gore ora oge adaresiya? Goa palua rabu ni mada epealia. ");
INSERT INTO kew_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Nipumi lalo: Madaga apo lae adarere natalipa. ");
INSERT INTO kew_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Goa peaga mogo para aipapulu pogola pulupa, nimi go para abi nape alimina yada napalua. Goane go adarena biri Soa teme. ");
INSERT INTO kew_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lot Soa opapaisa raburi nare aba raa ipisa. ");
INSERT INTO kew_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Go raburi Adaa Aa-me yapara pirumea repena sula yai rupa Sodom Gomora lapona mea repaisa. ");
INSERT INTO kew_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Nipumi go awaro paunena asa su ada luabu rayo iru rubisa, go adare para asimi onaa rayo para emaapu page iru rubisa. ");
INSERT INTO kew_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Lot-na ore pereketua adamonesa rabu nipu aipaa ana ausa. ");
INSERT INTO kew_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Wala yapipure Abraham aba ribareko rekataboa mode pare pisa, aba Adaa Aa rapu agaa sade pare. ");
INSERT INTO kew_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Nipumi Sodom Gomora lapo adaneasa pare apode awaro paune su rayo page miru kapukapu ropatisada adisa, go mirure adaa repena ropati rupana adisa. ");
INSERT INTO kew_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Gote-me mo ada kagure iru rubala-awa nipumi Abraham-me sa agaa niminasa. Goa pua nipumi Lot pane mupawa nipu ae adare luabu iru rubisa. ");
INSERT INTO kew_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot-para nipuna wane lapo Soa gimua so pore-para pua asimi. Nipu Soa ape pala omisa pulu, nipuna wane lapo rapu ana apeda meda para asimi. ");
INSERT INTO kew_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Yapi medame, mupa nogome nipuna aki para lalo: Sana aapare yomagaesi, goa pua saa rumape aa page meda dia. Gore ona rumapeare abade su rayona pia yapulu. ");
INSERT INTO kew_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Goa pea pulu sana aapare ipa waini nena lapana, goa pua sa nipu rapu patapana, goa pua niana ruru same aapa-rapu maralapana. ");
INSERT INTO kew_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Go ribare nipuna aapa ipa waini nenasipi, goa pua mupa nogo araa rapu pua patisa. Nipuna wane nipu rapu epa patua reka pisare namakuasa. ");
INSERT INTO kew_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Wala yapi medame mupa nogome orope nogo para lalo: Ni abala ribare apa rapu patawade. Abia ribare nipu ipa waini wala nena lapana, goa pua ne aaparapu patalipina, goa puare niana ruru, sana aaparapu wala maralapana. ");
INSERT INTO kew_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Go ribare nipuna araa ipa waini wala nena loa wane orope nogo araa rapu pua patisa. Nipuna wane orope nogo epa patua reka pisa page namakuasa. ");
INSERT INTO kew_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Lote-na wane laporata aara rapu awa naki pada pirisipi. ");
INSERT INTO kew_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Mo mupa nogome naki madua nipuna bire Moab sa. Nipuri abia Moab ruru-na ara pia. ");
INSERT INTO kew_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Wala orope nogome page naki madisa, goa pua Ben-Ammi lo bi maaisa. Nipu page Amonite ruru-na aara pia. ");
INSERT INTO kew_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham-me Mamre su gimoa Negep supara pisa. Nipu Kedes para Sar lapona rikirana pua asa, goa pua nipu Gera ogesi pua awa. ");
INSERT INTO kew_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ore Sarah-re, nina bani yade sa. Gera-na aa mudu Abimalek-me Sarah pua meatepa loa nipu misa. ");
INSERT INTO kew_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Rana meda riba Abimalek piri Gote epana ipumea nipu para lalo: Nere omali. Gore apo meaede onare aa aba pe ona yade. ");
INSERT INTO kew_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimalek nipu mo ona piripara abi na pisa, goa pua nipumi lalo: Adaa Aa waea napi onaare pa taliya? ");
INSERT INTO kew_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Nipuna bipa ni laagiade: Sarah-re nina bani lade. Oname page nina bani lade. Neme waea kone nasawa, epea pikone sawa. ");
INSERT INTO kew_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Gore Gote-me wala epana ipua goa sa: E, gore pa epea pi kone saede, pare ne mo onarapu naa pataedere, ni repara waea palilo neme ma-parude. Goane mo ona naa oraina-laawade. ");
INSERT INTO kew_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Abiare apo ona nipuna ani wala kalape, gore nipuri nina agaa lae aa yade, goa pua nipumi nena beten lalia, goa palia rabu ne epe rupa ali. Go yapare nipu na katedare, ora ria-lalo ne page nena onaa page rayo omalimi. ");
INSERT INTO kew_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Wala yapipu aba ribarekore Abimalek-me nipuna kogono aanu yasa, mo nipuna adisade yae luabu lakelo kiritisa raburi, nimumi pala waru omisimi. ");
INSERT INTO kew_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Go rabu Abimalek-me Abraham-para ipuloa lalo: Nemere niare akepae pae? Neme neparare waea meda napawade, gore neme kedare nipara naa onanu piri apo mea epaena? Neme nipara paenare napapea paena. ");
INSERT INTO kew_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimalek-me Abraham agaamisa: Goare nemere akena rena pae? ");
INSERT INTO kew_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham-me lalo: Nina bipa goa lawa, Go adare para Gote pala na-omeme ada kone sawa. Onaame nina ore nimu mulalo niri talimi kone sawa. ");
INSERT INTO kew_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ora riare nipuri nina bani page yade, sana-aapare komea yapare amare rado rado; goyapare nipuri abiare nina ore yade. ");
INSERT INTO kew_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Go raburi Gote-me nena aapana su anda gimapu saraburi, neme nipu-para goa su: Nena lo-pu robare ni gupa giape, palipade suluabu parare, niri na bani yade lape. ");
INSERT INTO kew_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Go rabu Abimalek-me sipisipi para gawa para kogono aa onanu page Abraham epa kasia, goa pua nipuna ore Sarah page wala nipuna kasa. ");
INSERT INTO kew_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimalek-me lalo: Na suri ogepu apo naiyada, nena rana paliapara ape. ");
INSERT INTO kew_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Sarah parare goa sa: Nena baniri neme mone ini (tausen) kina go kalaloda. Go piamere nepara nena rurunu rapuri agaa meda na salia lalo, nerapuri agaa ora ogesida page ora na salia. ");
INSERT INTO kew_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Gote-me Abimalek-na rurupara ona nogo rayore nogo naki na madinasa. Akoloya, Abimalek-me Abraham-na ore Sarah nipu misada. Gore Abraham-me Gote repara beten paisa. Go rabu Gote-me Abimalek-maepeasa, ore para nipuna kogono nogonu page, goa pua nimumi nogo naki wala madisimi. ");
INSERT INTO kew_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Abiare Adaa Aa-na rana Sarah-repara nipuna sarupa wala pisa, ora mo Adaa Aa nipuna palua sia rupa ora goa pisa. ");
INSERT INTO kew_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sarah-me naki pada pirua Abraham-na naki yomagae dina madiaisa, gore ora mo Gote-me madiali sa dina madisa. ");
INSERT INTO kew_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham-me nipuna Sarah-me madiaisa nakina biri Aisak lo bi ma asa. ");
INSERT INTO kew_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Aisak nipu yapidi (8) popisa raburi Abraham-me yogane mo Gote-me pipape sarupa ruguta pisa. ");
INSERT INTO kew_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham nipu mali 100 popenaloa nipuna si Aisak madisa. ");
INSERT INTO kew_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sarah-me lalo: Gote-me ni giri malasa, go rabu onaa rayome page go rema pagoa giri nirapu teme. ");
INSERT INTO kew_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Nipumi wala lalo: Apimi Abraham-na naki madiawa adu katea sa pae? Goyapare nipuna naki yomagae rana apo madiarude. ");
INSERT INTO kew_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Aisak adayoa agina adu adawasa, go rabu adu adawaisa yapinare Abraham-me adaa eta meda iraisa. ");
INSERT INTO kew_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Goyapare Sarah-me adisapare Ega mo Isip oname Abraham-na madiasa nakimi giri giri lala pirisa, ");
INSERT INTO kew_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","go rabu Sarah-me Abraham para lalo: Apo ona-re pakogono ona yadega si-rapu pane raturuba, go kogono onana si-mi naa oyae rayore na si Aisak rapu mada na rumalipiga. ");
INSERT INTO kew_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Go agaa-mere Abraham lokeda waru risa, gore nipuna si mada kone mapirasa pulu. ");
INSERT INTO kew_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Yapare Gote-me nipupara lalo: Neme go naki para apo slav kogono ona lapopara lo-keda ogepu rubape. Goa peaga Sarah-me tea pagape. Apo ma ralali sude rururi gore Aisak mada para sude. ");
INSERT INTO kew_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Neme mo kogono onana si madare ruru adapu warialua, akoloya nena si yada. ");
INSERT INTO kew_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Wala riba-rekore Abraham-me eta-para ipa lapo noria pua Ega na pasana mariasa. Goa pua naki agiaya rapasa. Nipu aagiaya pua Besiba su kapune-pare opopawa pua pamudipiasipi. ");
INSERT INTO kew_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","No madisipi ipa diasa-raburi, mo naki repena-re meda-para ma-pirasa. ");
INSERT INTO kew_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Goa pua ogeda mo-pare nenepu pua pirisa, mo naki omaala adape yada, gimoa pua re lala pirisa. ");
INSERT INTO kew_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Gote-me mo nakina re lalaina pagesa. Gote-na Ensol-me yaa-para awa Ega yasaa: Ega, akepeada lae? Neme pala naomape, Gote-me nena sina re pagade. ");
INSERT INTO kew_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Nena naaki pua mua kimi mea ipu. Gore ne madare neme onaa adaapu maralama pena toa. ");
INSERT INTO kew_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Gorabu Gote-me agina ini rupaina sa rabu nipumi ipa naaku meda adesa. Gore nipumi mo ipa meme mena yogane pe-para norua naki-mi nenalo pua kasa. ");
INSERT INTO kew_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Gote nipu go naki-rapu pirisa-pulu adayabisa. Nipu mo su kapuni-pare aware yaa-yapa piapena makuae aa aisa. ");
INSERT INTO kew_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Nipu mo Paran-su kapune pare aisa raburi, nipuna aagi-mi Isip ona meda yoto kasa. ");
INSERT INTO kew_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Go yapinare Abimelek-para, yadapi aanuna Surube aa Pikol lapome Abraham-para lalo: Gote-re nena oyae meda pulalope-para ne rapu pia. ");
INSERT INTO kew_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Abiare ni Gote-na ini-agaana goa napalualo lapawa ni-na makirape, o nina nogo-nakinu page, o gonumi madialimide page. Neme ne epea pawadeane epaa-aye adare page, epea paluaga neme ni ora epea pape. ");
INSERT INTO kew_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham-me lalo: Neme ora palua-sa. ");
INSERT INTO kew_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Gore Abraham-me nipuna ipa-naaku Abimelek-na Kogono aame misa rabu Abimelek rapu agaa lalapasipi. ");
INSERT INTO kew_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Gore Abimelek-me lalo: Goa panare apimi panapalo marea-sa. Ni aba nalagiaede pare, wala abia go pogolasatoda. ");
INSERT INTO kew_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Gore Abraham-me mena sipisipi-para, mena gawa-para, meapua Abimelek pua kasa rabu, nipu lapo upasipi ");
INSERT INTO kew_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraham-me sipisipi mena wai 7 kuta meda-para meamaisa. ");
INSERT INTO kew_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Go rabu Abimelek-me Abraham gupa agaa-misa: Apo mena sipisipi 7 kuta rado para ainalaere, akolo-pi? ");
INSERT INTO kew_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Nipumi lalo: Go mena sipisipi neme meainalo pi, goa pali rabu mo ipa-naku neme awesade kone ina. ");
INSERT INTO kew_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Goa-peada go suri Besiba teme, akoloya go-pare nipu lapona agaa aba rogaeisipi. ");
INSERT INTO kew_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Abimelek-para yadapi aanuna aa mudu Pikol lapo nipu Wala Pilistia-nuna Su-para pisipi. ");
INSERT INTO kew_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham-me Tamariks repena-wai Besiba poaisa. Go pare-re nipumi Adaa Aa-na bi loa lotu Sa, go Gote-re oroyalo kagaa pia-loa. ");
INSERT INTO kew_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Goa pua Abraham mo Pilistia aanuna Su-para adalupu pa awaisa. ");
INSERT INTO kew_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Yapi medaloma popena loa, Gote-me Abraham kotisa. Gote-me nipu-para lalo: Abraham! Abraham-me lalo: Ni go ayoda. ");
INSERT INTO kew_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Go rabu Gote-me lalo: Nena si, nena si komea, Aisak, neme kone mapiranedere mo Moria su-para pulupa. Neme watoade pore medana iru madiayae miru pua irape. ");
INSERT INTO kew_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ribarekore Abraham rekataboa nipuna donki mena managolaisa. Nipumi Aisak-para, nipuna kogono aalaapo lamuripinisa. Nipumi iru madia yape miru irape repena mada rekepuare, nipu Gote-me pope sade-para pisa. ");
INSERT INTO kew_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Repopa yapinare Abraham-me, mo polalo pisade su pua ada monesa. ");
INSERT INTO kew_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Nipuna kogono aalaapo-para lalo: Donki mena-rapu ado atepape, naki sare mogo pare popona. Gote adaa-bi pua kaloa wala epopona. ");
INSERT INTO kew_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham-me iru madia yae miru irape repena kapuri, si Aisak mariawa, repena ega-para, rai napi lapore nipuna ki-para ripinisa. Goa pua nipu komeapara puamama pisipi. ");
INSERT INTO kew_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Aisak-me araa Abraham-para lalo: Apa? Abraham-me lalo: Na si akeya? Aisak-me lalo: Mo repena ega-para repena kapu lapore go ripinitipa ga, mo iru madiayae miru irape mena sipisipi ra? ");
INSERT INTO kew_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham-me lalo: Naa si, apo iru madiayape miru irape mena sipisipiri, Gote-me managolalia. Goa pua nipu padane-para pisipi. ");
INSERT INTO kew_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Gote-me lakesade-para ipisipi raburi, Abraham-me ana reke meda go-para waria, repena kapu ana rekena isa. Goa puare sina ki alapo rogawa, so ana rekena musawa repena kapu mada saniasa isa. ");
INSERT INTO kew_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Goa pua, nipuna ki ridulawa, rai napi mua si awolalo pisa. ");
INSERT INTO kew_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Go rabu Adaa Aa-na Ensol-me soyapara awa yasa: Abraham! Abraham! Nipumi lalo: Go ayoda. ");
INSERT INTO kew_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Apo naki mada ki napirape. Nipu mada yae meda napape, abiare makuato, ni Gote mada kone mapirarina, gore nena si padane yade kone nasaede. Ni pagulalo paede. ");
INSERT INTO kew_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abraham-me adasaisa pare sipisipi mena meda repena pala ubura ipara ima mapalaga tabaisa. Nipumi mo sipisipi pua mua si polo-para iru madiayae miru mea irisa. ");
INSERT INTO kew_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Go rabu Abraham-me go suri: Adaa Aa-me Managolae sa. Gore abia page go pore-re Adaa Aa-me managola-walialo gupa pateme. ");
INSERT INTO kew_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Adaa Aa-na Ensel-me soyapara awaa rana laapopa Abraham yaloa lalo: ");
INSERT INTO kew_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Adaa Aa-me lalara nerapu agaa rogato, akepeadaya gore neme goa padeane, nena si ora naa loma naki padane pida nalade. ");
INSERT INTO kew_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Neme ne ora maepeawa, nena maralalide rururi, uba kedonu yaapara ayade rupa page, ipa mu rupa page maralalua. Go maralalide rurumiri iyanu pabo-tu rubua, nimuna adarenu page nimu minabalimi. ");
INSERT INTO kew_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Nena maralalide onaa madare, go su rayona onaa rayo maepealua. Gore neme na agaa pagaede pulu. ");
INSERT INTO kew_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Abraham nipu wala nipuna kogono aa laapo asipi pare wala ipua Besiba nimuna padane para pisimi. Goa pua Abraham Besiba pua asa. ");
INSERT INTO kew_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Agaa Pagoa rumaae aanumi Israel su surubisimi raburi reae ada meda pabisa. Betlem aa medare nipu Juda aa-ga pa ogepu yapina Moap supara aata pisa. Go aa-re nipuna ore-para si lapo page pisimi. ");
INSERT INTO kew_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Go aana biri Elimalek pare orena biri Naomi yade. Si lapona biri Malon-para Kilion lapo. Pirisimi nimuri Eprata ruru gore Juda ruruna Betlem supara aawoa pisimi. Nimu Moap aata pisimi. ");
INSERT INTO kew_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Go yapare Elimalek omesa raburi Naomi nipu si lapo raapu pirisa. ");
INSERT INTO kew_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Orope naaki lapome Moap ona lapo misipi. Go ona lapona biri Opa-para Rut lapo pirisipi. ");
INSERT INTO kew_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Gore Malon-para Kilion lapo page omesipi. Abiare Naomina aani-para si lapo page omesipi-pulu agurapo aasa. ");
INSERT INTO kew_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Naomi-mi remaa gupa pagesa: Adaa Aa-me nape eta nipuna onaa kaloa epe raana kalalo pagesa. Go rabu nipuna aaya lapo raapu Moap su gima polalo managolasimi. ");
INSERT INTO kew_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","MoJudanuna su-para Naomi-para aaya lapo page pisimi pare pora pa pulawa. ");
INSERT INTO kew_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Naomi-mi nipu goa lakesa: Nipi wala nipina ada pua nipina ama lapo raapu pua aatepape. Nipimi ni page na si lapo aba omapede page epea pisipide-pulu Adaa Aa-me page nipi epea mada palia. ");
INSERT INTO kew_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Adaa Aa-me nipi rabamealia rabu nipi page aa pua epe-rupa mada aalipi. Naomi mi ona lapo para patalepape sa rabu nipumi re ora waru sipi ");
INSERT INTO kew_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","pare nipumi gipia loa nena onaana ada baina sipi. ");
INSERT INTO kew_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Yapare Naomi-mi lalo: Diaga nipina ada palipina sa. Akepeada nipimi ni ratamea epalipiya? Dia. ");
INSERT INTO kew_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Niri onagae yade. Ni aa meda wala mada na-palua. Nipina adaa wala palipina. Go page neme abia go ribaa aa meda pua naaki madialua rabu ");
INSERT INTO kew_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","nipimi surubaawa go aa mada napalipi. Gore nasurubalipi nipi pa aanu meda palipina. Adaa Aa-me ni waea pisa-pulu, nipi page odo waru pia. ");
INSERT INTO kew_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Rut Opa lapo upia re wala sipi. Opa-me Naomi patape loa pisa pare Rut-ri Naomi raapu pa aisa. ");
INSERT INTO kew_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Go rabu Naomi-mi Rut goa lakesa: Ada, nena akini nipuna onaanuna ada pua nimuna makirae gote-nuya wala mo pulada. Ne page wala pulupa. ");
INSERT INTO kew_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Gore Rut-me agaa gupa abusa: Ni ne minarepaawa ora pulo rutu natape. Ne palide suparare ni page pamuapana. Ne aali-parare ni page aawapana. Nena onaare nina onaa page yalia. Nena Gote-re nina Gote page yalia. ");
INSERT INTO kew_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Ne omali-parare ni page omaluada rogaalimi. Yae medame saa naruguna lapana. Neraapu go rogaato agaada mabebola taluadare Adaa Aa-me ni mabebola talia. Omape yaeme ne saa rugulala paina. ");
INSERT INTO kew_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Rut nipu Naomi raapu polalo agu rapesa-pulu nipu agaa wala meda nasa. ");
INSERT INTO kew_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Goa pua nipu lapo Betlem pua pelapasipi. Naomi nipu Betlem pua opopasipi rabu go ada repara piri onaa reko oyasimi. Go rabu go ada piri ona medame goa sa: Gore Naomi ya? ");
INSERT INTO kew_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Go rabu nipumi nimu goa lakesa: Nimimi nipara Naomi bi wala natapape. Ni-para bi Mara tapape. Akoloya? Gote puri rayona reme ni waea pisada lalo. Goa peaga ni kone wae mi ona-yapulu niparare Mara-ya tapape. ");
INSERT INTO kew_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Ni go supara pa aaru raburi oyae adaapu waru oraaru pare Ada Aame ni wala mea epaa raburi oyae meda wala nasaayo. Ni kedaa ma-adasa rabu ni radaa ne. ");
INSERT INTO kew_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Go remaare Naomi Moap su gimoa epena remaa yade. Rut Moap ona raapu nipuna ayaa ona pua nipu Betlem opopasipi. Gore rais bali ini napeyoa kereape yapi dina ipisipi. ");
INSERT INTO kew_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Boas-re Elimalek-na ruru-para ada aa pirisa. Nipuri Naomi-na abana aanina ruru aa. ");
INSERT INTO kew_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Yapi medame Rut-mi Naomi-para goa sa: Niri maapu-para aanumi ponatu amu peme rais balina ini kereta pulu. Kogono aanumida mada temedare gore nimu raapu aawa rais madiaa palua. ");
INSERT INTO kew_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Gore Rut maapu-para mo kogono aanu ratamea pua rais bali-na ini pua makiroatasa. Go maapuri Elimelek-na ame Boas-na maapu kone na-isa. Boas-me Rut epea pisa. ");
INSERT INTO kew_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Boas-me Betlem su gimoa nipuna kogono aanu piri epa pelapaawa go-rupa epe naarepa sa. Adaa Aa nimi raapu pirina sa. Gore nimumi nipuna agaa gorupa abusimi: Adaa Aa-me ne maepeaina. ");
INSERT INTO kew_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Go rabu Boas-me surube aa gupa agaa misa: Go ona inumakua-re ane ruru nogo ya? ");
INSERT INTO kew_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Surube aame go-rupa abusa: Naomi raapu epape ya pare pa ruru nogo meda yade. Nipu Mopa gimoa epape-ya. ");
INSERT INTO kew_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Nipumi ni agaamea apo aanu raapu pamua bali ini kiratano la. Nipu ora ribaa reko ripima kogono pua kitu ogesi go epa mealada. ");
INSERT INTO kew_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Go rabu Boas-me Rut gupa lakesa: Go nogo, naa agaa paga. Ne wala maapu meda-para napope. Dia pa go maapuna balina ini keraina. Nena kogono ona-repa raapu kogono paina. ");
INSERT INTO kew_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Kogono pimi-rupa adoa nimu raapu aape. Nina kogono aanu aba lakeloa ne waru surubalepapelo lakelawa. Ipa nala paliare apo no imiga nola pope. ");
INSERT INTO kew_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Rut-me rumu pegepua suna kubuniaawa Boas-para goa lakesa: Niri pa ada meda ona yadega akepeada neme ni adoa epea pi? ");
INSERT INTO kew_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Boas-me agaa gupa abusa: Nena aani omenaloa nena aaya-para paeyade-a rayo aba pagawa. Ni makuaayo. Nena ama aapanu-para nena adare page gimaeyade. Goa pua nina onaanu raapu epa aaye. ");
INSERT INTO kew_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Ne Gote piri epaena Israel-na Adaa Aa nipumi ne surubenalo. Gore nipumi nena pae epe aunu aba ada-pulu ne epe yoto gina. ");
INSERT INTO kew_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Gore Rut-me Boas-na agaa gupa abusa: Neme ni ora epea waru pi. Niri nena epe kogono onanu nonapida dia pare neme ni epe agaa kuma pi lage rabu go-me nina pu robaa ne piri mea epea. ");
INSERT INTO kew_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Eta nape raburi Boas-me Rut wala goa lakesa: Ne go-pare ipua bret meda epa mua wain-para pataawa naa. Go rabu Rut nipu kogono ona meda raapu pirisa. Go rabu Boas-me repena egaana irini bali medaloma kasa. Mea nisa rabu Rut-na robaa rubisada medaloma pa isa. ");
INSERT INTO kew_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Rut-me eta no kiritua balina ini medaloma kirata isa. Go rabu Boas-me nipuna kogono aanupara goa sa: Nimi apo radala pira ia balina iniri Rut-me mea kirata ina tapape. Nimimi nipu ratu nayawalepape. ");
INSERT INTO kew_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Nimimi balina rogorogo medaloma ma lopatepape. Nipumi mea kirataina nimimi nipu naratu rubalepape. ");
INSERT INTO kew_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Rut-me rais balina ini amaa kirita amu pala pirina naare pabola popesa. Makiraata suare ini rada rada malaawa napere kirita isa. Nape iniri ten kilo popesa. ");
INSERT INTO kew_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Rut-me adare-para mea pua aaya pua wasa. Naare-palu nisade etana purapina page aaya pua kasa. ");
INSERT INTO kew_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Go rabu Naomi-mi Rut gupa agaa misa: Abiare balire aapara meae? Nere kogono akepiane aana maapu-para pae? Ne adoa kone saana aare Adaa Aa-me nipu epea pina. Go rabu Rut-me agaa gupa abusa: Abiare ni Boas-ne aa-na maapu kogono pawa sa. ");
INSERT INTO kew_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Gore Naomi-mi lalo: Adaa Aa-me go aa ora ma-epeaina sa Adaa Aa nipuna palua ne-are aba omeme onaa page pa pimi onaa mada page ora pea: Naomi-mi wala goa sa: Go aare niana yapi mada ora niana ruru yade. ");
INSERT INTO kew_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Gore Rut-me goa sa: Boas-me nipara wala goa la. Nere nipuna kogono onanu raapu kogono pua bali kirata sape kogono dia yalia rabu pua gimaina la. ");
INSERT INTO kew_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Naomi-mi lalo: Ora lae Aaya. Gore neme aa medana maapu-para kogono pali raburi go aa-na kogono aa-numi ne wae-anu palimi. Goa peaga Boas-na kogono onanu raapu kogono paina. ");
INSERT INTO kew_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Rut-me Boas-na kogono onanu raapu kogono paama pua bali-para wit lapo po kiritisa. Goa pua Rut nipu aaya raapu pa aasa. ");
INSERT INTO kew_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Naomi-mi Rut gupa lakesa: Aaya pagae. Neme ne surubape aa meda asapano pae? Ne suruboa waru ado aata pea-rupa. ");
INSERT INTO kew_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Abiare paga go aa Boas nipuna kogono onanu raapu kogono paayadere ora nina yapi ria yade. Abia go ribaare rais balina yo kininu waritimi-para kogono palia. ");
INSERT INTO kew_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Gore ne pua wel sada-nupara epe maninanu maraaawa nena yogane ipaa pua radepeape. Goa pua nipuna kogono palia-para pope. Gore nipuna ini aga-nare napope. Dia pare nipu eta ipanu aba no kiritina-lape. ");
INSERT INTO kew_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Nipu u patula paliare pua patala-para waru adape. Pua nipuna aa-nane blaket pua musaawa age regepea pua patape. Orope neme goa papelo lagialia. ");
INSERT INTO kew_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Rut-me agaa gupa abusa: Epeta. Neme nena agaa rayo ratalua. ");
INSERT INTO kew_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Gore Rut-me Naomi-mi mo sade-rupa balina ini yo ada warini-para rekoa pisa. ");
INSERT INTO kew_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Boas-me eta ipanu mada noare nipuna lo robaa epesa. Nipu u patala pisa-pulu rais-bali ubura i regepea pua patisa. Gore Rut pawa pua blaket pua musaawa Boas-na age regepea pua patisa. ");
INSERT INTO kew_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Riba Boas nipu pereke tisa pare ona meda nipuna age regepea go epaa patisa rabu nipu pogolasaasa. ");
INSERT INTO kew_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Go rabu nere api-ya palo agaa misa. Rut-me lalo: Ni Rut nena kogono ona meda yade. Nere Elimelek-na yapiga neme ni raba mua surubape. ");
INSERT INTO kew_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Boas-me pagoa Rut-para agaa go-rupa abusa: Na wane Adaa Aa-me ne ora epea pina. Abia neme go piare nena aaya-para paeyade epea rayo page rabuaniate. Ogegeaa-re adapu aeme pare medalomare oyae imi medalomare na imi. Go yapare neme goanu meda palua kone nasaena. ");
INSERT INTO kew_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Abiare naa wane pala naomape. Neme nena teare rayo palua. Ora lae. Niri nena aanina yapi medaa yapulu ne surubape kogono palua. Onaa rayome nere epe ona yana kone salimi. ");
INSERT INTO kew_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","E abiare ora lae. Niri nena aanina yapi meda yapulu neme ne mada surubalua. Go yapare aba ririnane aya aame go kogono rayo palia. ");
INSERT INTO kew_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Abiare ne go-pare aape. Ekeraa yapipuri go aa-na kone adola palua. Ne surubalua teadare mada pare dia teare gore neme ne surubalua. Neme ora lalo Adaa Aa-me makuaaya. Abiare wala abi pata. ");
INSERT INTO kew_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Gore Boas-me wala goa sa: Onanumi ne go-para epaenalo namakuaaena. Gore Rut wala Boas-na age rolopara wala patisa. Gore yapi abi naneaina pisa-pulu oname na-adesimi. ");
INSERT INTO kew_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Wala Boas-me Rut-para lalo: Laplap meda mea ipua suaama epaa rabola sa. Rut-me goa pisa rabu Boas-me bali medaloma koyaasa. Bali-na kedare 20 kilo popisa. Boas-me minasaawa ma-riasa rabu Rut-me ria pisa. Boas nipu wala adare-para pisa. ");
INSERT INTO kew_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Rut ada pua opapasa rabu aayame lalo: Aaya apore ora neya? Go rabu Rut-me Boas-me goa palo rayo lakesa. ");
INSERT INTO kew_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Rut-me lalo: Boas-me lalaara nena aaya piri pa napainalo bali medaloma rumaawa mea gia. ");
INSERT INTO kew_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Gore Naomi-mi lalo: Aaya ogeda pa adoa. Apo aare pa napiralia. Diaagaa pamu maredepo yalaara pia. Paliare saa na-adepa. ");
INSERT INTO kew_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Oropere Boas adare-na poragape-nane onaa kiritae-pare pua pirisa. Mo aba lade aa Elimelek-na medapara pati repera ipasa. Boas-me adami Aa ya loa go pare ipua epa pira. Nin go pare pua pirisa. ");
INSERT INTO kew_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Boas-me aa mudunu (10) mua gupa lakesa: Nimi epa piralepa. Gore nimu epa pirisimi. ");
INSERT INTO kew_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Nipumi nipuna yapi medagupa lakesa: Naomi-ri Moap gimoa wala epade pare sana yapi Elimalek-na sudere medame kabenalo rapata. ");
INSERT INTO kew_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Goa lagialua-me lawade. Neme kabali-dare gore go aa mudunu-para pa aanu medaloma go epa pimi-nuna ini agaana kabaina. Nere ora aba repara yapi yade pulu neme kabainalo lawade. Nakabaliri gore ni lagi. Gore mo aame lalo: Kabalua sa. ");
INSERT INTO kew_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Boas lakesa apo Naomi-para Rut lapona su kabalidare apo Moap ona Rut page meape nena ore pirina. Goa pua go suri mo omesade aana ruru repara ina. ");
INSERT INTO kew_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Mo aa nipumi lalo: Gore apo yaere na yapare naa naakinu raapu page pa naki meda raapu nina yaenu pa narumalua. Ni apo su na kabalua pare goa peaga abiare nena iya. ");
INSERT INTO kew_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","(Abare Israel ruruna oyae meda kabapenare go page oyae ropo ropo papenare gore goa pala pisimi. Aa medame nipuna age ada koyo rua meda kalala pisimi. Israel onaame agaa rogaa penare goa pala pisimi.) ");
INSERT INTO kew_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Go rabu mode aame Boas gupa lakesa: Go suri nena kabaina. Goa loa nipuna age ada koya paawa Boas kasa. ");
INSERT INTO kew_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Oropere Boas-me aa mudunu-para pa onaa medaloma-para goa sa: Nimi rayome adalepa Abare Naomi-para Elimelek-para Kilion-para Malon aalana oyae rayo sarude. Go yapare abiare go oyae raayome neme apo kabaloda. ");
INSERT INTO kew_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Agaa meda wala lano. Rut page na ore pirinalo go mealoda. Rut-re mo Moap ona Malon-me mua pirina omesade. Rut mealua rabu Malon-na su ruginiri nipuna ruru-para ina. Gore go ome aana onamere nipuna bi pa oroyala niminaina. Abia nimi apo piare royome apo adalemeda. ");
INSERT INTO kew_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Onaa rayome talo: E Goa rayo apo adoa makuatema-da. Aa mudunu-mi lalo: Go onare abia nena ada-para epena gore Adaa Aa-me nipu ma-epeaina. Goa pua Resel-para Lea lapo-rupa ma-epaina. Niaa Israel ruruna aaya lapo rupa pirina. Nere Eprata ruruna adaa aa pirua Betlem suna adaa bi ina. ");
INSERT INTO kew_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Adaa Aa-me nipi nogo naaki adaapu gialia. Goa pua Peres ruru-para Juda-para Tama-na sinu rupa alimi. ");
INSERT INTO kew_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Gore Boas-me Rut misa-pulu Adaa Aame nipu epea pisa. Rut naaki pada pirua naaki meda madisa. ");
INSERT INTO kew_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Gore onanumi Naomi gupa lakesimi: Adaa Aa-na bi minasaamina. Abiare ne naaki meda apo giade. Go naakiri nena aaya naki yapulu nipumi ne mada surubalia. Nipumi go Israel ruruna adaa bi mada mealia. ");
INSERT INTO kew_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Aaya neme raana omae-pulu neme page nipu raaname waru ome. Gore neme naaki seven (7) madu i lae pare go nena aaya ona raana ome-rupa mada raana na omola pae. Go abia madu sae naakimiri ne waru suruboa onagae pirali rabu epe-rupa surubalia. ");
INSERT INTO kew_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Gore Naomi-mi naaki mua repara mea saba pirisa. ");
INSERT INTO kew_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Go ada onanumi goa simi: Naomi-ri naaki saba pia simi. Mo naakina biri Obet lo bi ma-asimi. Oropere Jesina aaraa pirisa. Jesi-ri Devit-na Aara pirisa. ");
INSERT INTO kew_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Gore Peres na ruru pua Devit mada lo kirutu: Peres-re Esron-na aaraa pirisa. ");
INSERT INTO kew_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Esron-re Ram-na aaraa pirisa. Ram-re Aminadap-na aaraa pirisa. ");
INSERT INTO kew_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadap-re Nason-na aaraa pirisa. Nason-re Salmon-na aaraa pirisa. ");
INSERT INTO kew_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmon-re Boas-na aaraa pirisa. Boas-re Obet-na aaraa pirisa. ");
INSERT INTO kew_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obet-re Jesina aaraa pirisa. Jesi-re Devit-na aaraa pirisa. ");
INSERT INTO kew_vpl VALUES ("PR1_1","021_1_1","PRO","1","1","1","Go buk madaare Devit-na si Israel onaana aa mudu king Solomon-me go epe agaa tu isa. Goa pua onaa epe-rupa pirinalo tu isa. ");
INSERT INTO kew_vpl VALUES ("PR1_2","021_1_2","PRO","1","2","2","Go Epe agaa-me niaa epe kone gua niaa maredepo yalia. Go agaa rayo waru adalima rabu niaa epe kone sua epe pora ratape-rupa mogealia. ");
INSERT INTO kew_vpl VALUES ("PR1_3","021_1_3","PRO","1","3","3","Go buk madaa iya agaa pagoa adoa ratalima rabu onaa rayome peme-rupa epe kone mua ratalima. ");
INSERT INTO kew_vpl VALUES ("PR1_4","021_1_4","PRO","1","4","4","Go yapare aa medaloma kone rudu yalia rabu go buku madaa kone mua nimu epe kone mada mealimi. Goa pua ogegeaa medaloma epe kone mealimi-pulu epe pora mada pamualimi. ");
INSERT INTO kew_vpl VALUES ("PR1_5","021_1_5","PRO","1","5","6","Go buk madaare aa medalomame epe kone ratinalo makuae yae mogealia-pulu epe-rupa makuaalimi. Go buk-miri niaa saa agaa page, mada-mi agaa page paga-i agaa page lagialia rabu makuae aanu-na epe pora adoa makuaalima. ");
INSERT INTO kew_vpl VALUES ("PR1_7","021_1_7","PRO","1","7","7","Go yapare neme epe makuae yae meda mulalo paliri neme Adaa Aa madaa kone aba rulape. Aa medaloma epe kone naimiri nimu epe makuae yae meape gimeme. ");
INSERT INTO kew_vpl VALUES ("PR1_8","021_1_8","PRO","1","8","8","Nogo naaki nimimi-ri nimina ama aapa laapo-na agaa waru pagoa ratalepape. ");
INSERT INTO kew_vpl VALUES ("PR1_9","021_1_9","PRO","1","9","9","Nimuna agaame ne epe aa ma-aulalia. Gore epe raguna adipemede-rupa mada adipali. ");
INSERT INTO kew_vpl VALUES ("PR1_10","021_1_10","PRO","1","10","10","Nogo naaki-nu paake pupitagi ne aanumi nimi omeme pua wae-para mea palimi waru adalepape. ");
INSERT INTO kew_vpl VALUES ("PR1_11","021_1_11","PRO","1","11","11","Go piaene wae aanumi gupa teme: Go naaki ne aipapulu ipu. Abia niaame aa meda tamina. Niaame pora-nini suruboa aanu medaloma tu-maomamina. Nimu epe aanu epalimi page, pina pa tu maomamina. Gore niaana kone-me niminaalima yae rayo pa pamina. ");
INSERT INTO kew_vpl VALUES ("PR1_12","021_1_12","PRO","1","12","12","Niaame nimu ora aipapulu tu-maomawa. Onaa omeme robona tu maomaina. Goa palima rabu mo onaa rogaaeme tapa-para rogaaeme-rupa pamina teme. ");
INSERT INTO kew_vpl VALUES ("PR1_13","021_1_13","PRO","1","13","13","Go aanuna oyae luabu muare niana ada rubitabena samina. ");
INSERT INTO kew_vpl VALUES ("PR1_14","021_1_14","PRO","1","14","14","Ne niaa raapu goanu pamina lo epaliri oyaenu adaapu mua nena ada-para rubina saina teme. ");
INSERT INTO kew_vpl VALUES ("PR1_15","021_1_15","PRO","1","15","15","Go naaki pupitagi ne aanumi ne-para goa temere, nimuna agaa napage gimape. Nimuna go waea kone naratamea pope. ");
INSERT INTO kew_vpl VALUES ("PR1_16","021_1_16","PRO","1","16","16","Aanuri nimu waeagu peme. Goa pua oroyalo nimumi pa onaanu agu tu-rubebe pape kone imi. ");
INSERT INTO kew_vpl VALUES ("PR1_17","021_1_17","PRO","1","17","18","Onaame oroyalo pupitagi noalimiri nimu wae yoto mealimi. Gore yapa lokeme nipuna maa-para ope poga marayade-rupa nimuna bipa ope neme. Yaanuri ini rua, poga imi rabu adoa nimu mo poga mada naroaeme. ");
INSERT INTO kew_vpl VALUES ("PR1_19","021_1_19","PRO","1","19","19","Go yapare mo pupitagi neme aanumiri, go kone na-i ope nape kone sua pupitagi pa noaeme. Gore nimu paake meme oyaenumi, nimu ma-oyatalia. ");
INSERT INTO kew_vpl VALUES ("PR1_20","021_1_20","PRO","1","20","20","Epe konena porare ona meda-me pora-nini aawa page maket-nini aawa page onaa yaloaaya-rupare epe kone go-rupa epea. ");
INSERT INTO kew_vpl VALUES ("PR1_21","021_1_21","PRO","1","21","21","Nipu adaa ada kagurena pora kerepo-para aawa page onaa adaapu kiritae-pare awa page yaloa agaa ta-rupa mada pea. ");
INSERT INTO kew_vpl VALUES ("PR1_22","021_1_22","PRO","1","22","22","Nimi kone rudu ta onaa page, oroyalo gupa agu mada piralimi ya? Nimi maeyae onaanumi epe kone namealimiri pa ero agaa agu teme. Arabu nimimi go wae kone gimalimi ya? ");
INSERT INTO kew_vpl VALUES ("PR1_23","021_1_23","PRO","1","23","23","Nimina wae yaenu gimaliminalo neme agaa puri pane lagialo. Naa agaa pagalimiri neme epe kone epe pora watoa rabu nimi epealimi. ");
INSERT INTO kew_vpl VALUES ("PR1_24","021_1_24","PRO","1","24","24","Neme ni piri ipulupa loa yaato pare nimimi oroyalo gimoa naepeme. ");
INSERT INTO kew_vpl VALUES ("PR1_25","021_1_25","PRO","1","25","25","Nimimi na epe agaa pagoa nina kone ratalepa to pare agaa rasua epe agaa gimeme. ");
INSERT INTO kew_vpl VALUES ("PR1_26","021_1_26","PRO","1","26","26","Go peapulu kedaa adaa medaa nimi madaa epaliare neme page nimimi peme-rupa adoa gimalua. Nimi wae-rupa piralimi page neme giri laawa gimalua. ");
INSERT INTO kew_vpl VALUES ("PR1_27","021_1_27","PRO","1","27","27","Nimi madaare kedaa adaa poripu puri pane epeade-rupa epalia. Kedaa page radaa pi yaenu epalia raburi adaa poripu magomawae-rupa epalia-ga adalimina. ");
INSERT INTO kew_vpl VALUES ("PR1_28","021_1_28","PRO","1","28","28","Kedaa epalia raburi ni ipu loa yateme pare ni mada naepalua. Goa pua nimimi ni asapu piralimi pare nimimi ni mada na-adalimi. ");
INSERT INTO kew_vpl VALUES ("PR1_29","021_1_29","PRO","1","29","29","Nimimi Adaa Aa-na epe kone rolo-para pirape gimeme-pulu nimi gimalua. ");
INSERT INTO kew_vpl VALUES ("PR1_30","021_1_30","PRO","1","30","30","Nimi naa epe agaa rasua neme nimi ma-redepo yatalo-pe rabu agaa rasua gimeme. ");
INSERT INTO kew_vpl VALUES ("PR1_31","021_1_31","PRO","1","31","31","Goa pea-pulu abiare nimina peme waea luabuna yotore nimina bipa mada mealimina. ");
INSERT INTO kew_vpl VALUES ("PR1_32","021_1_32","PRO","1","32","32","Epe kone na-imi onaame ni maasa rilaeme. Goa peme-pulu nimu alupalimi. Goa pua nimuna bipa maeyaawa waea rayo nimumi makuaema kone imi. Go koneme nimuna bipa oyalimi. ");
INSERT INTO kew_vpl VALUES ("PR1_33","021_1_33","PRO","1","33","33","Go yapare onaa medaloma naa agaa pagoa ratalimiri nimu epe-rupa piralimi. Goa palimiri nimu madaa wae kedaa epalia rabu nimu epe-rupa pirua mogo wae yaenu madaa na-adalimi. ");
INSERT INTO kew_vpl VALUES ("PR2_1","021_2_1","PRO","2","1","1","Nogo naakinu nimimi naa agaa waru pago ratua, nimina kone-para waru niminaatepape. ");
INSERT INTO kew_vpl VALUES ("PR2_2","021_2_2","PRO","2","2","2","Epe makuae-yae waru mua teme agaa rayo waru ratua epe naaki nogo mada piralimina. ");
INSERT INTO kew_vpl VALUES ("PR2_3","021_2_3","PRO","2","3","3","Epe konena agaa ne madaa epena go agaa meape. Gore onaa yateme rabu pimide rupa mada piralimina. ");
INSERT INTO kew_vpl VALUES ("PR2_4","021_2_4","PRO","2","4","4","Aa medame kalai-pu kogono pua no su runane pagaa i gol aana mulalo kogono radaa pina pea-rupa epe kone mulalo-re radaa pina kogono go-rupa pape. ");
INSERT INTO kew_vpl VALUES ("PR2_5","021_2_5","PRO","2","5","5","Neme goa rayo pali-dare neme Adaa Aa-na kone rayo mada adasali. Goa paliri neme Gote page nipu kone waru rulaaye. ");
INSERT INTO kew_vpl VALUES ("PR2_6","021_2_6","PRO","2","6","6","Gore akolo ya? Aa adaa nipuri ora oyae rayona re yade. Nipumi epe kone gua makuae yae page oyae rayo nipumi niaa guaaya. ");
INSERT INTO kew_vpl VALUES ("PR2_7","021_2_7","PRO","2","7","7","Adaa Aa nipuna agaa pagoa rateme onaanuri wae yae epe yaenu page adoa rumaeme. Goa peme-pulu Adaa Aa-me nimu waru suruboa wae-para nalopena epe-rupa pirina tea. ");
INSERT INTO kew_vpl VALUES ("PR2_8","021_2_8","PRO","2","8","8","Gote-me nipuna agaa pogoa rateme onaanuri nipuna surube kuta runane mapiraaya. ");
INSERT INTO kew_vpl VALUES ("PR2_9","021_2_9","PRO","2","9","9","Nogo naaki nimi epe kone adoa ratalimi-dare epe pora luabu adoa pamualimi. Epe agaa rateme aanu medaloma page epe kone rumaawa epe pora mada mea watea. ");
INSERT INTO kew_vpl VALUES ("PR2_10","021_2_10","PRO","2","10","10","Goa pua epe kone adaapu nena robaa-para rubialia rabu raana-me omali. ");
INSERT INTO kew_vpl VALUES ("PR2_11","021_2_11","PRO","2","11","11","Epe kone ratali raburi epea luabumi ne raana gua ne madaa rubia kuma gialia. ");
INSERT INTO kew_vpl VALUES ("PR2_12","021_2_12","PRO","2","12","12","Goa pua waea peme aanu-para agaa wae-rupa teme aa-nu raapu medaa-para napirape. ");
INSERT INTO kew_vpl VALUES ("PR2_13","021_2_13","PRO","2","13","13","Go aanu nimu epe pora gimoa wae ribaane pora ratua waea puaeme. ");
INSERT INTO kew_vpl VALUES ("PR2_14","021_2_14","PRO","2","14","14","Gore nimu wae pora ratulalo pedo pu rana omoaeme. ");
INSERT INTO kew_vpl VALUES ("PR2_15","021_2_15","PRO","2","15","15","Go aanuna konere pugu pua bebolo maeya tea. ");
INSERT INTO kew_vpl VALUES ("PR2_16","021_2_16","PRO","2","16","16","Gore aa medana oreme omeme pua paake nape kone salia-dare epe kone aba go agaa-para epalia. Goa palia raburi neme mogo onana kone adoa mada gimali. ");
INSERT INTO kew_vpl VALUES ("PR2_17","021_2_17","PRO","2","17","17","Go piaene onamere abade ona inumakua pirua aani raapu ki mua pirisipide-agaa gimoa waea pape kone mualia. Gore Gote-na ini agaa madaa ora lalo loa misipide agaa page gimea. ");
INSERT INTO kew_vpl VALUES ("PR2_18","021_2_18","PRO","2","18","18","Go rabu neme go ona rata mea pali-daare neme aba ome onaa ratamea pe. ");
INSERT INTO kew_vpl VALUES ("PR2_19","021_2_19","PRO","2","19","19","Go ona adola peme aanu nimu oro yalo epe-rupa pirape pora gimoa wae pora ratulalo peme-pulu epe pora narateme. ");
INSERT INTO kew_vpl VALUES ("PR2_20","021_2_20","PRO","2","20","20","Epe pora ratamea pope kone salidare neme epe pora ratua mada niminaali. ");
INSERT INTO kew_vpl VALUES ("PR2_21","021_2_21","PRO","2","21","21","Epe aanuri go su-ama oro yalo epe pora ratua pa piralimi. ");
INSERT INTO kew_vpl VALUES ("PR2_22","021_2_22","PRO","2","22","22","Go yapare Gote-me waea pi aanu nimu ratu talia. Gore onaame nimuna maapu-para etaa wae mea rasu rubeme-rupa nimu mea rasu rubalia. ");
INSERT INTO kew_vpl VALUES ("PR3_1","021_3_1","PRO","3","1","1","Go naaki neme ne agaa mana lagialo-ga waru pagape. Kone narugulape pare oro yalo neme go agaa waru pagoa ratape. ");
INSERT INTO kew_vpl VALUES ("PR3_2","021_3_2","PRO","3","2","2","Neme go agaa mana pagoa ratali raburi ne go suamaa oro yalo eperupa pirali. Goa pua ne redepone porana aawali. ");
INSERT INTO kew_vpl VALUES ("PR3_3","021_3_3","PRO","3","3","3","Neme aa meda raapu adapua aawape page aa meda lorobaa kalape kone page waru sua aape. Go agaa luabu nena kone-para mea sua nena maa-para epe kulubu oyae ma-imi-rupa madaa masaape. ");
INSERT INTO kew_vpl VALUES ("PR3_4","021_3_4","PRO","3","4","4","Neme goa pali-daare onaa luabumi ne raana omoa nena palide kogono epeta teme. Goa palimi rabu Gote-me page ne raaname omalia. ");
INSERT INTO kew_vpl VALUES ("PR3_5","021_3_5","PRO","3","5","5","Neme Aapa Gote madaa kone ora waru rulaawa eperupa piraina. Neme nina bipa makuae yae madaa epe-rupa aalua kone nasape. ");
INSERT INTO kew_vpl VALUES ("PR3_6","021_3_6","PRO","3","6","6","Neme oyae luabu pulalo paliri Adaa Aa madaa kone aba rulaawa pape. Go rabu nipumi ne epe redepone pora mea watea. ");
INSERT INTO kew_vpl VALUES ("PR3_7","021_3_7","PRO","3","7","7","Neme nina makuae yaere ora warua-da pe kone nasape. Neme Adaa Aa madaa kone rulaawa nipuna rolo-para pirua waea napape. ");
INSERT INTO kew_vpl VALUES ("PR3_8","021_3_8","PRO","3","8","8","Neme goa pali-daare ora epealia. Neme yaina omoa marasini nemede rabu to yogaene raba mealade-rupa mada go epe pora ratali rabu ne epe-rupa mada aali. ");
INSERT INTO kew_vpl VALUES ("PR3_9","021_3_9","PRO","3","9","9","Nena maapu-para eta meda napeyoa poralia raburi mua Adaa Aa nipu re-para orapi-lo kalape. Goa pali-daare go madaa Adaa Aa nipu adaa bi mada mealia. ");
INSERT INTO kew_vpl VALUES ("PR3_10","021_3_10","PRO","3","10","10","Orapi-loa pa kate rabu Adaa Aa-me nena maapu-para eta nape yae ora waru ma-opaalia. Goa pua nena ada-para eta oyae luabu rulatabalia. Goa pua nena waini-pe page rubia koya-pape palia. ");
INSERT INTO kew_vpl VALUES ("PR3_11","021_3_11","PRO","3","11","11","Go naaki, Adaa Aa-me ne raba mulalo oyae meda palia-dare, neme ratu nayawe nena lo-robaa maepeape. ");
INSERT INTO kew_vpl VALUES ("PR3_12","021_3_12","PRO","3","12","12","Gore akoloya? Adaa Aa nipumi raaname omea onaa-re maredepo yaaya. Niaana aapanumi nimuna nogo naakinu kone rulaawa suruboa maredepo yaeme-rupa mada pea. ");
INSERT INTO kew_vpl VALUES ("PR3_13","021_3_13","PRO","3","13","13","Aa medame go epe kone-para makuae yae lapo mealia-daare nipu pedo pinawa. ");
INSERT INTO kew_vpl VALUES ("PR3_14","021_3_14","PRO","3","14","14","Gore akolo ya? Ora epede silva gol page epe kone-me rabuaniaaya. ");
INSERT INTO kew_vpl VALUES ("PR3_15","021_3_15","PRO","3","15","15","Mone yoto adaa pea aana gol page, pa oyae medaloma neme ora epeta kone sua raaname ome yaenu page rabuniaaya. ");
INSERT INTO kew_vpl VALUES ("PR3_16","021_3_16","PRO","3","16","16","Epe kone agu suali-dare ne epe kone oro yalo sua oyae page adaapu sua go su-amaa adaalu-pu mada piruaawa onaanumi nena bi minasaalimi. ");
INSERT INTO kew_vpl VALUES ("PR3_17","021_3_17","PRO","3","17","17","Epe koneme nena pu robaa-para raana waru gua go su-amaa adaalu-pu pirape yae page ora ma-epeaalia. ");
INSERT INTO kew_vpl VALUES ("PR3_18","021_3_18","PRO","3","18","18","Epe koneme-re onaa epe-rupa piraama pope kone mea gialia. Gore oro-yalo kagaa piraama laama popena paa kato nona piane repena-rupa aalimi. ");
INSERT INTO kew_vpl VALUES ("PR3_19","021_3_19","PRO","3","19","20","Adaa Aa nipuna epe kone sua go su-yaa laapo ripima warisa. Nipumi su-para ipa raku-inaloa moae kobere yaa madaa masaawa yai malopaaya. ");
INSERT INTO kew_vpl VALUES ("PR3_21","021_3_21","PRO","3","21","21","Naa si neme gimali-ga waru adoa epe kone-para makua yae lapo waru irulu saabape. ");
INSERT INTO kew_vpl VALUES ("PR3_22","021_3_22","PRO","3","22","22","Goa pea epe kone-para epe makuae yae laapomere ne oro yalo piraama laama pope kone gua epe pepena-rupa pua aawali. ");
INSERT INTO kew_vpl VALUES ("PR3_23","021_3_23","PRO","3","23","23","Goa pua ne epe pora pamuali rabu oyae medame nena àà mada na-aawalia. ");
INSERT INTO kew_vpl VALUES ("PR3_24","021_3_24","PRO","3","24","24","Ne u-patulalo pali rabu ne oyae meda pala na-omali. ");
INSERT INTO kew_vpl VALUES ("PR3_25","021_3_25","PRO","3","25","26","Gore neme Adaa Aa madaa kone waru puri paboa rulali-dare iaa-numi ne tulalo yada salimi page nimuna agona-para ne mada na-odobali. Wae yapi-di meda waea palimide aanu madaa opopalia rabu ne napogola sali. Go piaene yapi-di nimu madaa yai-poripu laapo epea-rupa mada epea. ");
INSERT INTO kew_vpl VALUES ("PR3_27","021_3_27","PRO","3","27","27","Aa meda oyae rudu yaliada agaa mealiare oyae adaapu saina kalape. Dia yaliare nakalape. ");
INSERT INTO kew_vpl VALUES ("PR3_28","021_3_28","PRO","3","28","28","Nena adami aame oyae agaa mealia rabu katalo paliri, pa ogesi-da puaa adoaa nalape. Ekera wala epali rabu gialua-ga lo gorupa nalape. ");
INSERT INTO kew_vpl VALUES ("PR3_29","021_3_29","PRO","3","29","29","Nena adami aanu ne raapu re-para pimiri, ne nimuna adami aa kone imi-ga nimuna kone nama-oyaape. ");
INSERT INTO kew_vpl VALUES ("PR3_30","021_3_30","PRO","3","30","30","Aa medame ne-para waea napalia-dare go aa nipu raapu yada-yada napipape. ");
INSERT INTO kew_vpl VALUES ("PR3_31","021_3_31","PRO","3","31","31","Nena kone mo yada pi aanuna pea-rupa maeyaawa nimumi go peme-a luabu naratape. Goa pua nimumi pamualimi pora rayo gimape. ");
INSERT INTO kew_vpl VALUES ("PR3_32","021_3_32","PRO","3","32","32","Adaa Aa-me wae kone imi aanuri gimea-daa lalo. Goa pea pare Adaa Aa nipumi epe pora ratua epe kone imi aanu page nipuna epe pu-robaa kata. Goa pua nimu waru surubea. ");
INSERT INTO kew_vpl VALUES ("PR3_33","021_3_33","PRO","3","33","33","Adaa Aa-me gupa ta: waea peme aanu luabu nimuri, nimuna ona nogo naaki luabu raapu alupalimi ta. Go yapare Adaa Aa-me epe redepone onaare nipuna ona nogo naaki oyae luabu epe-rupa suruboa raba mealia rabu epe-rupa piralimi ta. ");
INSERT INTO kew_vpl VALUES ("PR3_34","021_3_34","PRO","3","34","34","Aa medame aa yagonu-para ero agaa teme-daare, Gote-me go aa nipu page ero agaa tea. Pare aanu medaloma epe kone-sua ae aanuri Gote-me nipuna epe kone luabu abutea. ");
INSERT INTO kew_vpl VALUES ("PR3_35","021_3_35","PRO","3","35","35","Epe kone imi aanu-ri onaa luabumi epe bi kateme. Go yapare kone wae-imi aanuri nimuna bipa nimuna bi ma-oyatalo peme. ");
INSERT INTO kew_vpl VALUES ("PR4_1","021_4_1","PRO","4","1","1","Go nogo naaki nimimi nina agaa waru pagalepa. Ni nimina aapa-ga, nimimi ni madaa epe kone mealepape. ");
INSERT INTO kew_vpl VALUES ("PR4_2","021_4_2","PRO","4","2","2","Agaa neme go lagialo-re epeta-ga, nimimi narubalepape. Pa yae kone sua rubalimi raburi nimi omalimi. ");
INSERT INTO kew_vpl VALUES ("PR4_3","021_4_3","PRO","4","3","3","Nina amame naaki meda abi namadini ni komea madu isa-pulu, nipumi ni madaa raana omea. ");
INSERT INTO kew_vpl VALUES ("PR4_4","021_4_4","PRO","4","4","4","Gore ni oge naaki pirano aapa nipumi ni agaa mana gupa lagisa. Nina agaa nena kone-para waru mea sua go agaa ratape sa. Goa pali rabu ne ora epe-rupa piru diayali sa. ");
INSERT INTO kew_vpl VALUES ("PR4_5","021_4_5","PRO","4","5","5","Neme epe kone mua kone-para mea rubina lape. Neme naa agaa mea rubebe pua kone narugulape. ");
INSERT INTO kew_vpl VALUES ("PR4_6","021_4_6","PRO","4","6","6","Dia neme epe kone nagimape. Go agaame ne epe-rupa surubalia rabu ne ora epe aa pirali. ");
INSERT INTO kew_vpl VALUES ("PR4_7","021_4_7","PRO","4","7","7","Gore neme aba ripia mealiare epe kone ora riri-nane meape. Neme oyae medaloma meaayo kone saliri epe yaere epe kone yade. ");
INSERT INTO kew_vpl VALUES ("PR4_8","021_4_8","PRO","4","8","8","Neme epe kone raaname omoa irulu sabaali raburi, go epe kone-me ne adaa bi gialia. Go rabu ne ora epe aa pirali. ");
INSERT INTO kew_vpl VALUES ("PR4_9","021_4_9","PRO","4","9","9","Goa pua nena aalu mada king aa mudu medana raguna nona piene adipua aali. ");
INSERT INTO kew_vpl VALUES ("PR4_10","021_4_10","PRO","4","10","10","Go naaki neme nina agaa pagoa ratali rabu ne go su-amaa oro yalo adaalu-pu piruali. ");
INSERT INTO kew_vpl VALUES ("PR4_11","021_4_11","PRO","4","11","11","Neme ne epe pora mea waloa epe pora-nini painalo maredepo yaayo. ");
INSERT INTO kew_vpl VALUES ("PR4_12","021_4_12","PRO","4","12","12","Gore ne go pora ratua paali rabu oyae medame mada nama-oyaalia. ");
INSERT INTO kew_vpl VALUES ("PR4_13","021_4_13","PRO","4","13","13","Ne oroyalo pirama lama pope agaa-re, nina agaa ya-pulu ratali rabu go-para ia agaame ne waru surubalia. ");
INSERT INTO kew_vpl VALUES ("PR4_14","021_4_14","PRO","4","14","14","Neme wae aanuna agaa gimoa nimuna pulalo palimide-anu page gimape. ");
INSERT INTO kew_vpl VALUES ("PR4_15","021_4_15","PRO","4","15","15","Neme go pora gimoa pogola pua su-adaalu meda-nane pope. ");
INSERT INTO kew_vpl VALUES ("PR4_16","021_4_16","PRO","4","16","16","Gore mo waea puaeme aanumi waea meda napalimiri, nimu u-mada napatalimi. Nimumi waea palimi-daare, nimu u mada patalimi. ");
INSERT INTO kew_vpl VALUES ("PR4_17","021_4_17","PRO","4","17","17","Wae kone-para wae pora ratua aa yagonu ma-oyapere pupitagi ne aanu nimuna eta-ne yae-rupa noaeme. ");
INSERT INTO kew_vpl VALUES ("PR4_18","021_4_18","PRO","4","18","19","Wae aa luabu nimuna ini-para ribaa waru ta-pulu, nimuna àà koyatimi awolalo palia page mada na-adalimi. Go yapare epe-rupa redepoya piri aanuna porare nimu naare yapi-pu roa paa putalade nona piane-pare piralimi. ");
INSERT INTO kew_vpl VALUES ("PR4_20","021_4_20","PRO","4","20","20","Go naaki nina agaa nena aane-para penaloa waru pagape. ");
INSERT INTO kew_vpl VALUES ("PR4_21","021_4_21","PRO","4","21","21","Neme go agaa puri paloa kone-para mea sua waru irulu makuabape. Go agaa kone rugulaliri ne oyali. ");
INSERT INTO kew_vpl VALUES ("PR4_22","021_4_22","PRO","4","22","22","Neme naa agaa pagoa ratali rabu go agaame ne epe-rupa pirama pope pora mea gialia. Goa pua go agaa-me ne ora epe redepoya mapiraalia. ");
INSERT INTO kew_vpl VALUES ("PR4_23","021_4_23","PRO","4","23","23","Epe koneme ne maredepo yatalo nena kone-para epaliare, ipa naaku-para yokoa epeade-rupa epea. Oroyalo nena pora pamuape page nena kone wasupa luabu waru maredepo yaawa pamuape. ");
INSERT INTO kew_vpl VALUES ("PR4_24","021_4_24","PRO","4","24","24","Neme yaa agaa na-lo wae yaenu page ora gimape. ");
INSERT INTO kew_vpl VALUES ("PR4_25","021_4_25","PRO","4","25","25","Neme inimini na-pi mo ne palide pora waru adoa go pora ratape. ");
INSERT INTO kew_vpl VALUES ("PR4_26","021_4_26","PRO","4","26","26","Nena kone ora epe-rupa redepo yaaina nena pora epe-rupa adoa ratua pamuape. ");
INSERT INTO kew_vpl VALUES ("PR4_27","021_4_27","PRO","4","27","27","Neme mo epe pora pamuaaridere na-kone rugulape. Dia-ga ne popoke-nane puala wala koya-nane epala napape. Goa pua neme wae yae luabu gimapena pora adoa ratape. ");
INSERT INTO kew_vpl VALUES ("PR5_1","021_5_1","PRO","5","1","1","Naa si neme ne ora epe agaa gua ne makuae yaenu page gua epe pora mea watalo pi. ");
INSERT INTO kew_vpl VALUES ("PR5_2","021_5_2","PRO","5","2","2","Nena te agaa page epe-rupa te rabu nena te agaa luabu makuae aa-me ne nona-piane pagalimi. ");
INSERT INTO kew_vpl VALUES ("PR5_3","021_5_3","PRO","5","3","3","Neme goa paliri akolo yapae? Ona medame aani gimoa ne ogeyaliari epe omeme pua rede-pi agaa medaloma lagialia-re nipu yolainalo goa palia. ");
INSERT INTO kew_vpl VALUES ("PR5_4","021_5_4","PRO","5","4","4","Go rabu neme nipuna agaa pagoa nipu yote-daare orope go yaere wae yae yaana kone sali. Goa paliri etaame onaa imu apetabalade-rupa page wae rero pi marasini mea noa pirimi adalia. ");
INSERT INTO kew_vpl VALUES ("PR5_5","021_5_5","PRO","5","5","5","Go piaene oname ne wae onaa omeme sunane mea palia. ");
INSERT INTO kew_vpl VALUES ("PR5_6","021_5_6","PRO","5","6","6","Go piane ona nipuri epe pirama-lama pope supara pope kone naniminaaya. Dia nipu go wae pora yade kone page na-ia. Nipu pa wae pora kuruape mada pamuaya. Goa pua nipu pa bebolaaya. ");
INSERT INTO kew_vpl VALUES ("PR5_7","021_5_7","PRO","5","7","7","Go naaki neme go agaa nagimi waru pagoa ratape. ");
INSERT INTO kew_vpl VALUES ("PR5_8","021_5_8","PRO","5","8","8","Go piane ona nipuna ada poragape-para page nape. Nipu pakeaawa ne yolamonea aape. Goa pua nipu ora gimape. ");
INSERT INTO kew_vpl VALUES ("PR5_9","021_5_9","PRO","5","9","9","Neme go onana kone adoa ratali raburi nena epe bi gimali. Nipuna aanimi ne lo-robaa mada nagialia. Dia ne pena ogegeaa aina tumaomalia. ");
INSERT INTO kew_vpl VALUES ("PR5_10","021_5_10","PRO","5","10","10","Ne epe-yae meda mealua loa kalai-pu kogono pu su piralide yae, wala aa medame nipu mealia. ");
INSERT INTO kew_vpl VALUES ("PR5_11","021_5_11","PRO","5","11","11","Ne yaina adaa omoa uni kebo-agitua re loa ada-para suaawa omali. ");
INSERT INTO kew_vpl VALUES ("PR5_12","021_5_12","PRO","5","12","12","Go rabu neme gupa te: ni ora maeyaarude-ga akolo pawa pae te? Aa medalomame ni maredepo yaawa agaa wariaina lapede pawaaya te. ");
INSERT INTO kew_vpl VALUES ("PR5_13","021_5_13","PRO","5","13","13","Neme nina mogeriae aanuna agaa rasua napagawa-rupa loali. ");
INSERT INTO kew_vpl VALUES ("PR5_14","021_5_14","PRO","5","14","14","Abia ni onaa luabuna ini agaa madaa oyoa yala polalo te. ");
INSERT INTO kew_vpl VALUES ("PR5_15","021_5_15","PRO","5","15","15","Nere nena ona raapu waru epe-rupa pirua pa aa medana ipa naaku-para napua nape. Goa pua nena ona raapu agu-patape. Aa meda nipuna ipa raana-para agu raapo nea-rupa nena agu raapo gupa nape. ");
INSERT INTO kew_vpl VALUES ("PR5_16","021_5_16","PRO","5","16","16","Neme go onanu raapu nogo naakinu pa madua minarepali-dare, orope go nogo naakinumi ne mada naraba mealimi. Goa palimi-ga nena ona padaneme nena nogo naaki ora nena madu saina lape. ");
INSERT INTO kew_vpl VALUES ("PR5_17","021_5_17","PRO","5","17","17","Neme paake naaki madu rubebe pualiri oyalia. Goa pua nena nogo naaki luabu pa onaanu raapu bebolo pitimi. ");
INSERT INTO kew_vpl VALUES ("PR5_18","021_5_18","PRO","5","18","18","Nena ona-re nena ipa naaku rubita-rupa ya-pulu, Gote-me nena ona raaname omoa nipi raita epe agaa mana salia rabu epe-rupa pitipi. ");
INSERT INTO kew_vpl VALUES ("PR5_19","021_5_19","PRO","5","19","19","Gore ora epe nape nanea ya-pulu oro yalo yalo ne rana gua nipuna epea luabu madaa ne ora raaname omalia. Goa pua rana waru omoa oro yalo nipuna adu mada page rana waru omape. ");
INSERT INTO kew_vpl VALUES ("PR5_20","021_5_20","PRO","5","20","20","Go naaki neme oro yalo kone adaapu sua aa medana ona paake yolape mada kone penaloa nipuna adu oraape madaa ali-ga waru adape. ");
INSERT INTO kew_vpl VALUES ("PR5_21","021_5_21","PRO","5","21","21","Adaa Aa-me niaame pema yae luabu page niaana ima kone luabu page aba adea-ga makuaawa aape. ");
INSERT INTO kew_vpl VALUES ("PR5_22","021_5_22","PRO","5","22","22","Aa nipuna pea wae pupitagi luabumi nipuna maa-para ope poga sua maraaya. Nipuna go pupitagi-mi nipu mea adia konaa mada roaawa wae-rupa omolalo pea. ");
INSERT INTO kew_vpl VALUES ("PR5_23","021_5_23","PRO","5","23","23","Go piaene aa nipuna bipa nipuna raana narabuaniaawa nipuna pea wae yaeme nipu adia maeyane aa-rupa pia. Goa puaaya-pulu nipuna bipa go pea pupitagimi nipu tumaomalia. ");
INSERT INTO kew_vpl VALUES ("PR6_1","021_6_1","PRO","6","1","1","Go naaki aa medame pa aa medana rudu mua, nipuna bipa abula-peawi nasalia rabu neme na-abulaliri go kone epe-da dia. ");
INSERT INTO kew_vpl VALUES ("PR6_2","021_6_2","PRO","6","2","2","Go koneme nena bipa ope poga sua nena maa-para ope aawa adibaya. Goa pea-pulu ne go rudu palia agaame ne adialia. ");
INSERT INTO kew_vpl VALUES ("PR6_3","021_6_3","PRO","6","3","3","Go naaki ne wae yaeme adini rolo-para pirali-daare go wae yae luaburi abi gimape. Ne mogo wae aa-na pupitagi-na rolo-para napirape. Neme mogo rudu te agaa madaa yala poloa nagime. Ne pua mo palua te agaa lapaina yala napone abi pua agaa pua mupape. Goare ora aipapulu pape. ");
INSERT INTO kew_vpl VALUES ("PR6_4","021_6_4","PRO","6","4","4","Ne u-ogeapu patu-piruae aipapu-loa abi pope. ");
INSERT INTO kew_vpl VALUES ("PR6_5","021_6_5","PRO","6","5","5","Nena maa-para aba aaya ope poga aipapulu esepe rubape. Gore yaa-maitame nipu poga i-para pakeaawa naroalade-rupa pakeape. ");
INSERT INTO kew_vpl VALUES ("PR6_6","021_6_6","PRO","6","6","6","Nimi ki-aa rakepea gi madini aanu nimiri neme agaa gupa lagialo. Nimi mo ini rubu-pi aame rakutanu-me pea aba adoa kone makuae aa-rupa piralepa. ");
INSERT INTO kew_vpl VALUES ("PR6_7","021_6_7","PRO","6","7","7","Rakutanu nimuna aa mudu page nimuna surube aa page meda napimi. ");
INSERT INTO kew_vpl VALUES ("PR6_8","021_6_8","PRO","6","8","8","Go yapare nimuna eta adaapu suaaya raburi eta diayalia rabu mea nolalo pa mea kirita suaeme. ");
INSERT INTO kew_vpl VALUES ("PR6_9","021_6_9","PRO","6","9","9","Goa peme-ga nimi ki-aa rakepene aanu nimiri pa u-patu pirape mada raana waru pea pae? Nimi go ki-aa rakepene aanuri aa-rabu u rekataboa aalimi yapae? ");
INSERT INTO kew_vpl VALUES ("PR6_10","021_6_10","PRO","6","10","10","Nimimi goa teme: niaa u ogesida pataluame pima pare wala ogesida kitu mua rekalima teme. ");
INSERT INTO kew_vpl VALUES ("PR6_11","021_6_11","PRO","6","11","11","Nimimi goa palimi-daare nimina oyaenu aipapulu diyalia rabu aa naara piralimi. Paake ne aanumi nimina oyae paake meme rabu diatade-rupa pa alia. ");
INSERT INTO kew_vpl VALUES ("PR6_12","021_6_12","PRO","6","12","12","Wae aanu nimimi yaa agaa ora waru temede. ");
INSERT INTO kew_vpl VALUES ("PR6_13","021_6_13","PRO","6","13","13","Nimuna wae aa yagonumi adenalo gupa peme. Ne makirate rabu kimi page àà-me page inimi robo page sua nimuna waea pape agu mea wateme. ");
INSERT INTO kew_vpl VALUES ("PR6_14","021_6_14","PRO","6","14","14","Oro yalo nimumi waea pape madaa kone rulaawa aanu medaloma kone wae ma-saaeme. ");
INSERT INTO kew_vpl VALUES ("PR6_15","021_6_15","PRO","6","15","15","Goa peme raburi nimu kedaa adaa aipapulu meme rabu go kedaa wala ma-epeape-rupa kalai pua omalimi. ");
INSERT INTO kew_vpl VALUES ("PR6_16","021_6_16","PRO","6","16","16","Adaa Aa-me pupitagi ne kone ipa kerepopu (7) peme-a luabu madaa-re nipumi raana na-omea. ");
INSERT INTO kew_vpl VALUES ("PR6_17","021_6_17","PRO","6","17","19","Wae pupitagi ne-para aa yago meda adoa go aare pinawa kone imiapara, yaa agaa temena. Go page re-para aa yago meda re-nai madaa pama tumaomaeme. Nimumi waea pape madaa agu kone mapiraeme-para, waea pape-para pupitagi neme. Wae pupitagi pape madaa kone mapiraeme-para koso madaa yaa agaa adaapu teme. Go page nimuna amenu rapu agaa rado rado loa wae-kone masaeme. ");
INSERT INTO kew_vpl VALUES ("PR6_20","021_6_20","PRO","6","20","20","Go naaki neme nena ama aapa laapo-na agaa pagoa ratape. Nipumi tepe agaa narasalepape. ");
INSERT INTO kew_vpl VALUES ("PR6_21","021_6_21","PRO","6","21","21","Neme nipuna agaa kone-para mea sua oro yalo ratape. Go konere nena maa-para maasape kulubu-rupa masua pirali rabu ora epealia. ");
INSERT INTO kew_vpl VALUES ("PR6_22","021_6_22","PRO","6","22","22","Ne pora pamulalo pali rabu go agaa-me epe pora mea watea. Ne u-patali rabu page go agaa-me ne surubalia. Ne u-patua rekali rabu page go agaame epe kone wasupa gua surubalia. ");
INSERT INTO kew_vpl VALUES ("PR6_23","021_6_23","PRO","6","23","23","Nena ama aapana agaare laba paame pora mea watade-rupa mada ne pora mea watea. Nena ama aapa lapome ne go agaa lagialipi rabu go su-amaa epe-rupa aawape pora mea watepe. ");
INSERT INTO kew_vpl VALUES ("PR6_24","021_6_24","PRO","6","24","24","Nipuna agaa-me ne rabamealipi rabu, ona wae-me ne kotulalo mada na-epalia. Aa medana oreme epe redepi agaa lagialia page napagape. ");
INSERT INTO kew_vpl VALUES ("PR6_25","021_6_25","PRO","6","25","25","Neme go onana epenape-nane to madaa epaame naomape. Go rabu nipumi paake nalipinalo ne adoba saliaga nipu aae repara napope. ");
INSERT INTO kew_vpl VALUES ("PR6_26","021_6_26","PRO","6","26","26","Gore aa medame paake aa rume ona raapu paake nalia-dare adaa yoto nakaloa pea. Gore pa oge etana yotosi peade-rupa mada kata. Gupa yapare aa medana ona raapu paake pupitagi no patalipi-daare adaa yoto waru rubalia. Goa pua nipuna bipa nipuna kone wasupa page tumaomalia. ");
INSERT INTO kew_vpl VALUES ("PR6_27","021_6_27","PRO","6","27","27","Gore neme repena egaa ako-para mea pagali raburi nena ma-raalide seti mada naralia ya? ");
INSERT INTO kew_vpl VALUES ("PR6_28","021_6_28","PRO","6","28","28","Go page repena egaa ralaina àà-me rabua talimi raburi nimina àà page mada naralia ya? ");
INSERT INTO kew_vpl VALUES ("PR6_29","021_6_29","PRO","6","29","29","Padane go-rupa aguri ne aa medana ore raapu paake pupitagi no patalipi-daare neme adaina kone ianu palimi. ");
INSERT INTO kew_vpl VALUES ("PR6_30","021_6_30","PRO","6","30","30","Gore aa medame page nipu reaeme omoa aa medanuna maapu paake-nea raburi, go maapure onaa-me go aa nipu abi natemede. ");
INSERT INTO kew_vpl VALUES ("PR6_31","021_6_31","PRO","6","31","31","Go yapare nimumi go paake-ne adasalimi rabu nipu koso laawa adialimi rabu oyae adaapumi abutea. Gore nipuna ada-para i oyae luabu ma-diayape-rupa madame abutea. ");
INSERT INTO kew_vpl VALUES ("PR6_32","021_6_32","PRO","6","32","32","Go yapare aa medame mo aa medana ore raapu patua nipumi paake yotea-dare go aa nipu waea adaape pea. Aa medame pupitagi nalia-dare nipuna bipa nipu ma-oyaaya. ");
INSERT INTO kew_vpl VALUES ("PR6_33","021_6_33","PRO","6","33","33","Gore aanumi nipu tua yala mapolaawa aape teme rabu oroyalo yala pola aalia. ");
INSERT INTO kew_vpl VALUES ("PR6_34","021_6_34","PRO","6","34","34","Aa medame aa medana orenu raapu paake no pataliare onaa luabumi go aa ratu yawalimi. Go-rupa aguri mo aani nipumi go aa nipu radaa nena tua waea palia. Go aa nipu ogesi-da odome omape-re ora mada dia. ");
INSERT INTO kew_vpl VALUES ("PR6_35","021_6_35","PRO","6","35","35","Goa pua rono lorenalo mone adaapu aani kate-pare mada namealia. ");
INSERT INTO kew_vpl VALUES ("PR7_1","021_7_1","PRO","7","1","1","Go naaki neme nina agaa waru pago ratua nena kone-para mea saape. ");
INSERT INTO kew_vpl VALUES ("PR7_2","021_7_2","PRO","7","2","2","Nina agaa pagoa ratali rabu ne oroyalo epe-rupa mada piruali. Nina agaa-re nena ini surube-rupa waru surubape. ");
INSERT INTO kew_vpl VALUES ("PR7_3","021_7_3","PRO","7","3","3","Nina agaa nena kone-para oroyalo waru inaloa aape. Oroyalo kiaalo nena-ki madaa mapiraae-rupa mada pirinalape. ");
INSERT INTO kew_vpl VALUES ("PR7_4","021_7_4","PRO","7","4","4","Epe kone-para epe makuae yae lapo rata nena kone-para inaloa aape. Gore nena baani-para epe aa yago raapu aatede-rupa mada aape. ");
INSERT INTO kew_vpl VALUES ("PR7_5","021_7_5","PRO","7","5","5","Aa medana ore-me ne ogeyoa nipu raapu paake napana tea raburi epe kone ne raapu oro yalo piralia-pulu ne goa mada napali. Goa pea-pulu neme go onana agaa mada gimali. ");
INSERT INTO kew_vpl VALUES ("PR7_6","021_7_6","PRO","7","6","7","Yapi medame nina ada-para pirua widua-para ini penaato pare no pora-nini ogegeaanu pamuaeme. Gore nimu epe kone page makuae yae page yada ora na-i madaa pama pamuaeme. Goa peme pare aa padane-ma nipu ora maeyaaya. ");
INSERT INTO kew_vpl VALUES ("PR7_8","021_7_8","PRO","7","8","8","Ogegeaa nipuri ona ora wae piri medana ada pera-pera pamea. ");
INSERT INTO kew_vpl VALUES ("PR7_9","021_7_9","PRO","7","9","9","Gore naare pabola penaloa ribaa yolalo popea. ");
INSERT INTO kew_vpl VALUES ("PR7_10","021_7_10","PRO","7","10","10","Mo ona nipuri pora pami onanumi pemede-rupa pepena pua nipumi mo ogege aame adena kone ia. Goa pua mo-aa puaa mada lamu mea. ");
INSERT INTO kew_vpl VALUES ("PR7_11","021_7_11","PRO","7","11","11","Go onare nipu ora wae pupitagi ne ona yalo nipuna ada-para page epe-rupa napia. ");
INSERT INTO kew_vpl VALUES ("PR7_12","021_7_12","PRO","7","12","12","Oro yalo nipu makete-nini page pora-nini pamualaina pua nipuna ada-para page epe-rupa napia. Aa agu asapala pirina pea. ");
INSERT INTO kew_vpl VALUES ("PR7_13","021_7_13","PRO","7","13","13","Neme adesu pare go ogege aa i rulu ripinaawa nipumi nunu lalaina adesu. Goa pua mo oname nipuna ini agaa-para adabaa sua goa sa. ");
INSERT INTO kew_vpl VALUES ("PR7_14","021_7_14","PRO","7","14","14","Abiare nina ada-para agu raapo pirua opa kalape yaere meda iya-daa sa. ");
INSERT INTO kew_vpl VALUES ("PR7_15","021_7_15","PRO","7","15","15","Goaene nina ada gimoa ne asapula epawa. Goa pawa-pulu abia ne go epa adalo-da. ");
INSERT INTO kew_vpl VALUES ("PR7_16","021_7_16","PRO","7","16","16","Goa pua ne patape yapara page aba rabolo saayo. Go yapara rabolo saayo pare nena adipu patape yakopi laplap page epe pepena pubae saayo. Go epe u-patape yaenuri mo Isipi supara mea-epe yaenu saayo. ");
INSERT INTO kew_vpl VALUES ("PR7_17","021_7_17","PRO","7","17","17","Neme go nena u-patape epe bet madaare paura epe kaapi yae luabu koyoa saayo. ");
INSERT INTO kew_vpl VALUES ("PR7_18","021_7_18","PRO","7","18","18","Goa pea-ga abiare saana bana. Goa puare raapa palaawa rabialo tu patua yapi malaapana. Goa pua raana adaape meapana. ");
INSERT INTO kew_vpl VALUES ("PR7_19","021_7_19","PRO","7","19","19","Ninaa aaniri pala naomape. Nipu su adaalu meda-para naepope-rupa pisa. ");
INSERT INTO kew_vpl VALUES ("PR7_20","021_7_20","PRO","7","20","20","Gore akoloya nipumi mone ora adaapupe mea pisa-pulu sarara laapo popenaloa orope epalia. Goa pua abia go akua epola pola raapu raapu-para epalia. ");
INSERT INTO kew_vpl VALUES ("PR7_21","021_7_21","PRO","7","21","21","Go oname epe rede pi agaa luabu loa mo ogege aa nipuna lo-robaa ora waru marekaaya. ");
INSERT INTO kew_vpl VALUES ("PR7_22","021_7_22","PRO","7","22","22","Mo aa nipumi mo omeme agaa pagoa mo onana ada-para ratamea pea. Gore mo mena gawa ti ada-para mea pemede-rupa mada mea pea. Go page maeyae aa opeada patinalo mea pemede-rupa mada mea pea. ");
INSERT INTO kew_vpl VALUES ("PR7_23","021_7_23","PRO","7","23","23","Go aa nipuri koyati pua sua nipu aawalia kone na-i. Pa yaa-madaa biya pua mo poga madaa puaa roayade-rupa mada pea. Gore yaa nipu poga sabae-para roalua kone na-i. Pa biyaa pea-rupa mada pea. ");
INSERT INTO kew_vpl VALUES ("PR7_24","021_7_24","PRO","7","24","24","Go naaki nina agaa madaa-re aane waru lobapa-inaloa waru pagalepape. ");
INSERT INTO kew_vpl VALUES ("PR7_25","021_7_25","PRO","7","25","25","Nimimi go piaene ona rata mea popere nimina lo-robaa ora aipapulu narekena tapape. Goa pua nipuna kone gimape. ");
INSERT INTO kew_vpl VALUES ("PR7_26","021_7_26","PRO","7","26","26","Gore akolo ya? Aa adaapu go onana kone ratua luabu taala-pupa yabeme. ");
INSERT INTO kew_vpl VALUES ("PR7_27","021_7_27","PRO","7","27","27","Go ona nipuna ada-para pope porare, aa tapa-para pemede pora-rupa ia. Go yapare nimi go pora ratalimiri nimi aipapulu aba omeme onaanuna su-para palimi. ");
INSERT INTO kew_vpl VALUES ("PR8_1","021_8_1","PRO","8","1","1","Epe redepone konere ona meda rekaawa onaa yaata-rupa madaa. ");
INSERT INTO kew_vpl VALUES ("PR8_2","021_8_2","PRO","8","2","2","Nipu so pore madaa pora kepaa-kepaa pea pare aawa yolaaya. ");
INSERT INTO kew_vpl VALUES ("PR8_3","021_8_3","PRO","8","3","3","Gore nipu adaa ada kagure-na pora kerepo-nane aawa nipumi gupa yaloa lala aaya. ");
INSERT INTO kew_vpl VALUES ("PR8_4","021_8_4","PRO","8","4","5","Neme onaa nimi luabu yalalo: Nimi kone na-i onaa luabu kone waru kegena mealimina. Nimi aanu kone waru na-imiri ipua kone waru epaa mealepa. ");
INSERT INTO kew_vpl VALUES ("PR8_6","021_8_6","PRO","8","6","6","Neme epe redepi agaa go lagialo madaa-re, aane waru lobapa ina pirua pagalepape. ");
INSERT INTO kew_vpl VALUES ("PR8_7","021_8_7","PRO","8","7","7","Neme wae agaa luaburi gi waru pea-pulu neme oro yalo ora agaa riaa laguaayo. ");
INSERT INTO kew_vpl VALUES ("PR8_8","021_8_8","PRO","8","8","8","Neme yaa-agaa natopare go to agaa luabu ora epe agaa riaa lagialo. ");
INSERT INTO kew_vpl VALUES ("PR8_9","021_8_9","PRO","8","9","9","Epe kone sua makuae yae waru meme aanumiri neme to agaa-na re-re waru makuaeme. Goa pea-ga go agaa ora riae yade kone sua waru makuatepape. ");
INSERT INTO kew_vpl VALUES ("PR8_10","021_8_10","PRO","8","10","10","Nina agaa-me mone mena sekere puri pane yae luabu rabuaaya-pulu neme epe kone luabu nimi mogeano waru pago piralepa. ");
INSERT INTO kew_vpl VALUES ("PR8_11","021_8_11","PRO","8","11","11","Nina bipa niri ora epe kone epe yae luaburi ni yade. Neme gol mone oyae luabu page nimimi raana omeme yae luabu page rabuaawa ora puri na-ia tode. ");
INSERT INTO kew_vpl VALUES ("PR8_12","021_8_12","PRO","8","12","12","Ni epe konena pora pamuape-rupa waru makuaayo. Goa pua ora epe pora pamuape page ni yade. ");
INSERT INTO kew_vpl VALUES ("PR8_13","021_8_13","PRO","8","13","13","Aa meda nipu Adaa Aa-na agaa pagoa rataliare wae yaenu pape gime-omea. Neme gimi ome yae-re, aa medame nimuna bi minasaawa waea pea kone luabu-ri gime ome. Waeanu adaapu pua yaa agaa teme aanu page ora gipea. ");
INSERT INTO kew_vpl VALUES ("PR8_14","021_8_14","PRO","8","14","14","Onaanu epe kone kaloa epe kogono papena kone page luabu neme mada gialua. Nina bipa niri epe kone yade. Goa pua adaa puri luabuna aaraa page ni yade. ");
INSERT INTO kew_vpl VALUES ("PR8_15","021_8_15","PRO","8","15","16","Adaa ada kaguare luabu surubenalo aa mudu luabu page king-nu page neme mapiraayo. Goa pua lo waria go onaa luabu epe-rupa surubenalo epe kone neme kaato. ");
INSERT INTO kew_vpl VALUES ("PR8_17","021_8_17","PRO","8","17","17","Onaa medame ni adalua kone saliare ni mada adalia. Onaa medalomame ni raaname omalimiri neme page nimu raaname waru omalua. ");
INSERT INTO kew_vpl VALUES ("PR8_18","021_8_18","PRO","8","18","18","Neme onaa adaa bi kaloa oyaenu page ora adaapu kaato. Mone oyae luabu waru kaloa epe kone pora luabu kurinaloa onaanu luabu waru raba mealua. ");
INSERT INTO kew_vpl VALUES ("PR8_19","021_8_19","PRO","8","19","19","Neme kaato yaemere epe puri pane gol aana page aana silipa page ora rabuaniaaya. ");
INSERT INTO kew_vpl VALUES ("PR8_20","021_8_20","PRO","8","20","20","Oro yalo neme epe redepone kone luabu ratu-aayo. ");
INSERT INTO kew_vpl VALUES ("PR8_21","021_8_21","PRO","8","21","21","Ni raana omeme onaana yaere adaa stua-para kago imi-rupa kirita saayo. Goa pua mo akore kirita i ada-para rulatabena saayo. ");
INSERT INTO kew_vpl VALUES ("PR8_22","021_8_22","PRO","8","22","22","Ora abade Adaa Aa-me oyae luabu warisa raburi ririnane ni aba mapiraasa. Goa pua wala oropere oyae luabu warisa. ");
INSERT INTO kew_vpl VALUES ("PR8_23","021_8_23","PRO","8","23","23","Ora abade Adaa Aa-me su yaa lapo page oyae rayo abi nawarini aawa ni aba waria mapiraasa rabu ni aba pirisu. ");
INSERT INTO kew_vpl VALUES ("PR8_24","021_8_24","PRO","8","24","24","Adaa Aa-me ipa ogenu page adaa ipa solowaranu page abi nawarini rabu ni aba pirisu. ");
INSERT INTO kew_vpl VALUES ("PR8_25","021_8_25","PRO","8","25","25","Adaa porenu page oge porenu page abi nawarini rabu ni aba pirisu. ");
INSERT INTO kew_vpl VALUES ("PR8_26","021_8_26","PRO","8","26","26","Go rabu ni pirano-re Adaa Aa-me su page abi nawarisa. Oyae luabu page abi na-opena e maapu nape yaenu page abi na-isa. ");
INSERT INTO kew_vpl VALUES ("PR8_27","021_8_27","PRO","8","27","27","Yaa-me ipa solowara mea kutapu isa rabu page Ni aba pirisipa. ");
INSERT INTO kew_vpl VALUES ("PR8_28","021_8_28","PRO","8","28","28","So yaa madaa moae yaakoya page, su-para ipa marakupitabasa rabu page, ipa pa go su madaa adaapu mapopaawa solowara mapiraasa rabu page ni aba pirisu. ");
INSERT INTO kew_vpl VALUES ("PR8_29","021_8_29","PRO","8","29","29","Nipumi suna-re warisa rabu pirisu. Goa pua mo ipa solowara repa-repa warisa rabu page ni pirisu. Goa pua ipa solwara neme go su nakabulape loa agaa mana lakesa rabu page, ipa neme go salo robo nakabulape sa rabu page ni pirisipa. ");
INSERT INTO kew_vpl VALUES ("PR8_30","021_8_30","PRO","8","30","31","Adaa Aa-me go yae luabu warisa rabu niri go kogono rayo surubanolo makuae aa mada mua mapirasa. Nipumi warisa oyae luabu adoa raana waru pisa-da neme nipu page raana omenalo kogono pisu. Neme go-su adoa onaa pimi su madaa page pedo waru pisu. Goa pisa-da neme Adaa Aa-na ini agaa-na oroyalo raaname omo aayo. ");
INSERT INTO kew_vpl VALUES ("PR8_32","021_8_32","PRO","8","32","32","Epea-para epe kone lapo-me agaa mone mone go-rupa ta. Go nogo naakinu nimimi naa agaa waru pagoa nina kone luabu waru ratalepape. Nimimi goa palimiri epe raaname rubini onaa piralimina. ");
INSERT INTO kew_vpl VALUES ("PR8_33","021_8_33","PRO","8","33","33","Nimiri neme epe kone gianoloa waru makuae yaeme rubini onaa piralimina. Nimimi go agaa madaa masaa narilatepape. ");
INSERT INTO kew_vpl VALUES ("PR8_34","021_8_34","PRO","8","34","34","Nina agaa pagoa ratalimi onaare nimi madaa raaname rubialia. Oroyalo nimi naa ada pora-gape para surubeme rabu neme epe kone epe pora mea waato. Nina poragape-para epeme rabu neme epe agaa lage. ");
INSERT INTO kew_vpl VALUES ("PR8_35","021_8_35","PRO","8","35","35","Onaame ni mealimi-daare nimu kagaa pirape kone wasupa mealimi. Goa pua Adaa Aa-me nimu repara epe lo-robaa katea. ");
INSERT INTO kew_vpl VALUES ("PR8_36","021_8_36","PRO","8","36","36","Goa peme pare aanu medalomame ni namealimiri nimuna bipa nimu bebo teme. Onaa-me ni raaname naomalimiri, nimu omape madaa kone mapiraawa peme. ");
INSERT INTO kew_vpl VALUES ("PR9_1","021_9_1","PRO","9","1","1","Epe koneme epe pora waatalo ada pigi kerepo (7) pua ponoa awea. Gore nipumi epe kone sua go ada pigi eto napape-rupa awea. Go ada pigimi puri paloa ainalo pisa. ");
INSERT INTO kew_vpl VALUES ("PR9_2","021_9_2","PRO","9","2","2","Yaa-yapa mena tua ipa waini rede waru-pi managola sua eta nape reke page aba managola-isa. ");
INSERT INTO kew_vpl VALUES ("PR9_3","021_9_3","PRO","9","3","3","Nipuna kogono onanu ada kagure-nini penaloa agaa puri palo pua lalaatepa sa. ");
INSERT INTO kew_vpl VALUES ("PR9_4","021_9_4","PRO","9","4","4","Nimumi gupa teme: Nimi mayae wae kone i aanu luabu ipulupa. Nimi epe kone mua epe redepone pora adalimina ipulupa loa mo kogono onanumi yalaala aaeme. ");
INSERT INTO kew_vpl VALUES ("PR9_5","021_9_5","PRO","9","5","5","Eta page ipa waini epe rede-pi aba managala ia-ga ipua epa nalepa. ");
INSERT INTO kew_vpl VALUES ("PR9_6","021_9_6","PRO","9","6","6","Nimina maeyae wae kone luabu gimoa epe kone-para epe pora ratalimina ipulupa simi. ");
INSERT INTO kew_vpl VALUES ("PR9_7","021_9_7","PRO","9","7","7","Gore neme aa meda maredepo yaatalo pali rabu nipumi nepara aakone sua ero agaa-me abutea. Go page neme aa wae meda epe agaa loa maredepo-yaatalo pali-rabu, go aame ne tua nena yogaene ma-oyaalia. ");
INSERT INTO kew_vpl VALUES ("PR9_8","021_9_8","PRO","9","8","8","Goa palia-ga wae agaa ne aa maredepo yaawa epe agaa lakelapere gimape. Goa pua ne ora iaa aulalia. Neme epe aa meda agaa mana laketalo pali-rabu go aame ne raaname waru omalia. ");
INSERT INTO kew_vpl VALUES ("PR9_9","021_9_9","PRO","9","9","9","Neme epe kone i aa meda agaa lakeloa epe agaa talo palipi-dare go aame ne raana omalia. Goa pua nipuna kone page raaname rubialia. Neme epe-aa kone kate rabu nipuna makuae-yae page adaa-yalia. ");
INSERT INTO kew_vpl VALUES ("PR9_10","021_9_10","PRO","9","10","10","Go yapare neme epe kone sua epe-rupa pitua kone sali-daare, neme Adaa Aa-na agaa aba meape. Gote nipu ora epe redepo-yoti aa yade. Gore neme epe makuae yae mealua kone sali-daare, Gote nipu ora aba riri-nane kone mapiraawa aba makuaape. ");
INSERT INTO kew_vpl VALUES ("PR9_11","021_9_11","PRO","9","11","11","Epe kone-me ne go su-amaa ora adaalupu mapiraalia rabu kris-maali adaapu mada pirali. ");
INSERT INTO kew_vpl VALUES ("PR9_12","021_9_12","PRO","9","12","12","Gore ne epe kone meali-rabu nena bipa ne ma-epeaali. Go yapare ne-da wae kone sua waea-pi aa yaliare, nena bipa ne go ma-oyaawa mabebolateda. ");
INSERT INTO kew_vpl VALUES ("PR9_13","021_9_13","PRO","9","13","13","Ona meda nipu epe kone na-ia-pulu nipu maeyaawa puri palo wae agaa loa aa rumaape madaa yaaloaaya. ");
INSERT INTO kew_vpl VALUES ("PR9_14","021_9_14","PRO","9","14","14","Nipuna ada mo adare rupara aaya-pulu go adare-na adaa pora kerepo-para aawa yaloa wae agaa loaaya. ");
INSERT INTO kew_vpl VALUES ("PR9_15","021_9_15","PRO","9","15","15","Onaa adaapu kogono pa pulalo popeme raburi nimi ni piri-para ipulupa loa yalala-aya. ");
INSERT INTO kew_vpl VALUES ("PR9_16","021_9_16","PRO","9","16","16","Nimi aa luabu epe kone naimi-ga, nimi maeyae aanu nina ada-para ipulupa. ");
INSERT INTO kew_vpl VALUES ("PR9_17","021_9_17","PRO","9","17","17","Gore neme ipa meda paake mua nali rabu go ipa kogaroa redepi ipa nali. Eta meda page pake mua nali rabu, go eta page rede waru palia. ");
INSERT INTO kew_vpl VALUES ("PR9_18","021_9_18","PRO","9","18","18","Mo nipuna ada-para ipulupa ta aanu-ri, nipuna ada-re matmat nonapi ada yapare mo aanumi waru na-ademe. Nimu kone waru na-imi-pulu ora epe ona yaana kone imi. Go onana ada-para peme aanuri nimu aba omoa nimu ome aanu-rupa pimi pare pa aaema kone sua nimumi waru na-ademe. ");
INSERT INTO kew_vpl VALUES ("PR10_1","021_10_1","PRO","10","1","1","Solomon nipumi epe-rupa pirape agaa rudu-rudu medaloma tusua gupa-sa. Nogo naaki medalomame epe kone sua nimumi epe kone ratalimi-rabu agi aaraanumi raana ora waru omalimi. Go yapare nogo naakinumi wae pora ratua pupitagi noalimiri, agi aaraa-me page lo-robaa kedaa adaa ruaalimi. ");
INSERT INTO kew_vpl VALUES ("PR10_2","021_10_2","PRO","10","2","2","Ne mone paake noa ama-aalidare, nena go moneme ne epe-rupa naraba mealia rabu ne epe-rupa mada na-aali. Go yapare neme epe pora ratua amaa yali-dare ne na-rudute. ");
INSERT INTO kew_vpl VALUES ("PR10_3","021_10_3","PRO","10","3","3","Adaa Aa-me nipu madaa kone rulaawa pimi onaa, eta nape oyae luabu asa pina kone na-ia. Goa pea pare mo waeya peme onaa-re nimu ama-yape, eta asapeme yaenu asapinalo pora poaaya. ");
INSERT INTO kew_vpl VALUES ("PR10_4","021_10_4","PRO","10","4","4","Ki-aa raakepea kogono napaliri, reaeme omoa aa naara pirali pare neme puri paloa kogono waru pali-dare, ne eta page amo yape page ne oyae meda na-rudu tea-pulu epe-rupa aali. ");
INSERT INTO kew_vpl VALUES ("PR10_5","021_10_5","PRO","10","5","5","Kone waru i aamere eta napeta rabu mea kirita suaaya. Go yapare ki-aa rakepea kogono waru napaliari nimina ona nogo naaki reaeme omoa yaala polo aalimi. ");
INSERT INTO kew_vpl VALUES ("PR10_6","021_10_6","PRO","10","6","6","Gote-me epe aanuri nipumi nimu waru rabamuaaya. Goa pea pare wae aa-me nipuna kudiri agaa teme rabu onaanu medaloman kone mabebola tea. ");
INSERT INTO kew_vpl VALUES ("PR10_7","021_10_7","PRO","10","7","7","Gore aa epe meda omea raburi onaame go aa-na epe kone niminaawa goa-da pisade loa pedo waru peme. Go yapare wae aanu meda omeme raburi mo onaa luabumi go aa naniminae aipapulu kone rugulaeme. ");
INSERT INTO kew_vpl VALUES ("PR10_8","021_10_8","PRO","10","8","8","Epe kone-i aanumiri pa aa medame epa-ta agaa page waru aina madu pageme. Pare yaa-agaa loa agaa ipa rukini ritimi aanuri nimu ora pa-rupa oteme. ");
INSERT INTO kew_vpl VALUES ("PR10_9","021_10_9","PRO","10","9","9","Epe kone sua epe-rupa piri onaare redepone-rupa pirualimi. Go yapare onaa waea palimidere, nimuna peme wae yaenu kudiri-pu na-i pename salia. ");
INSERT INTO kew_vpl VALUES ("PR10_10","021_10_10","PRO","10","10","10","Yaa agaa ne aanumi pupitagi adaapu neme pare pupitagi ne aanu nimu yaa agaa adaapu loa waea peme-pulu nimu bebolo talia. Go pea pare aa medame agaa pename loa onaa mada raba muaya. ");
INSERT INTO kew_vpl VALUES ("PR10_11","021_10_11","PRO","10","11","11","Epe redepone aanuna agaa-re ora epe ipa laipi kata ipa-rupa yade. Go yapare wae aanuna kone pa kudiripu sabaawa onaa mabebola teme. ");
INSERT INTO kew_vpl VALUES ("PR10_12","021_10_12","PRO","10","12","12","Lo-robaa wae-imi raburi wae-yae maepaaya. Goa pea pare aa yago meda raana omea aamere wae yae luabu pename ma-opaaya. ");
INSERT INTO kew_vpl VALUES ("PR10_13","021_10_13","PRO","10","13","13","Redepone kone i aamere nipuna epe redepone kone agu lapepedepeta. Goa pea pare wae kone imi aanu aipuya-me mea kudu teme. ");
INSERT INTO kew_vpl VALUES ("PR10_14","021_10_14","PRO","10","14","14","Epe pora ratua epe kone imi aanuri makuae yae waru mua aipapulu nalapaeme. Aa medame yaa-agaa teadare, wae yae aipapulu gopara opapaaya. ");
INSERT INTO kew_vpl VALUES ("PR10_15","021_10_15","PRO","10","15","15","Gore ada kagure kepo pua imi-rupare amone aanu nimuna yaenumi nimu kuta pua ora epe-rupa pimi. Goa peme pare aa naara luaburi nimu oyae ruduta-pulu nimu aipapulu beboloa oyalimi. ");
INSERT INTO kew_vpl VALUES ("PR10_16","021_10_16","PRO","10","16","16","Redepone aa-me nipuna yoto-rupare, oro yalo pirama-lama palia. Go yapare wae aa-numiri waea adaapu peme. ");
INSERT INTO kew_vpl VALUES ("PR10_17","021_10_17","PRO","10","17","17","Go yapare aa medame nipu maredepo yaina kone saliadare, kagaa pirape supara palia. Go yapare aa meda nipu namaredepo-yaeme rabu rada-pia pea aare go epe pora gimea. ");
INSERT INTO kew_vpl VALUES ("PR10_18","021_10_18","PRO","10","18","18","Aa medame aa yago meda wae kone saliadare, nipumi yaa agaa loa oro yalo waea-pu rabuae aa pename go aaya-da. Go yapare aa medame aa yagona ma-agaa paliare go aa nipu ora maeya aa aaya. ");
INSERT INTO kew_vpl VALUES ("PR10_19","021_10_19","PRO","10","19","19","Aa medame agaa adaapu loaalia-daare, go aa nipuna agaame page wae-yae yolo rialia. Go yapare aa medame agaa adaapu natea-dare, go aa nipu ora epe kone su ayaa. ");
INSERT INTO kew_vpl VALUES ("PR10_20","021_10_20","PRO","10","20","20","Epe redepone aana agaa-re epe aana silipa-me adea. Go yapare wae aanuna kone-re bebolo-tea. ");
INSERT INTO kew_vpl VALUES ("PR10_21","021_10_21","PRO","10","21","21","Epe redepone aa-na agaa-mere onaa adaapu waru rabamea. Goa pea pare onaa epe kone nasalimi-daare go onaa nimu ora omalimi. Akolo ya? Nimuna kone ora oyotea-pulu nimu omalimi. ");
INSERT INTO kew_vpl VALUES ("PR10_22","021_10_22","PRO","10","22","22","Go yapare Adaa Aa-me niaa oyaenu pama gea. Kedaa kogono-me oyaenu nagialia. ");
INSERT INTO kew_vpl VALUES ("PR10_23","021_10_23","PRO","10","23","23","Epe kone naimi aanu nimu waea pape mada raana waru omoa pupitagi neme. Go yapare epe kone imi aanuri, nimu epea papena raana omoa epea peme. ");
INSERT INTO kew_vpl VALUES ("PR10_24","021_10_24","PRO","10","24","24","Wae aanuri oyae luabu madaa paalame omalimi rabu go wae yae luabu nimu piri popalia. Go pea pare epe kone rulae aamere oyae luabu mada mealimi. ");
INSERT INTO kew_vpl VALUES ("PR10_25","021_10_25","PRO","10","25","25","Gore wae yapi-di meda go wae onaa repara popolalo palia raburi, gome nimu ora madiayaalia. Gore ipa roa oyae luabu kadepe ritade-rupa goa palia. Go yapare epe-rupa piri onaa-re nimu puri palo eto napi piralimi. ");
INSERT INTO kew_vpl VALUES ("PR10_26","021_10_26","PRO","10","26","26","Gore nena kogono pape aare kiaa rakepene aa nameape. Neme go kogono gi madini aa adali rabu ne marasini ne rabu nena agaa-para rero piade-rupa palia rabu ne gimapalia. Go page nena ini para miru pea rabu poke poke yalade rupa palia. ");
INSERT INTO kew_vpl VALUES ("PR10_27","021_10_27","PRO","10","27","27","Neme Adaa Aa-na pora kurua oro yalo nipuna rolo-para pirali-dare, ne go su-amaaa adaalupu pirali. Go yapare wae aanuri go su-amaa adaalupu napiri ora aipapulu aba omalimi. ");
INSERT INTO kew_vpl VALUES ("PR10_28","021_10_28","PRO","10","28","28","Adaa Aa-na agaa pagoa rati onaamere, Adaa Aa nipuna pea kogono ado-kiritua raaname ora waru omalimi. Go yapare wae aanuri pama surubama pua, nimumi epe yapi di meda mada na-adalimi. ");
INSERT INTO kew_vpl VALUES ("PR10_29","021_10_29","PRO","10","29","29","Adaa Aa-me epe redepone onaare waru surubea. Go yapare nipumi, wae onaare maoyalia. ");
INSERT INTO kew_vpl VALUES ("PR10_30","021_10_30","PRO","10","30","30","Epe redepone aanuri nimuna ada kagure-para epe-rupa piruaeme. Go yapare wae pupitagi ne onaare nimu go rupa napiruaeme. ");
INSERT INTO kew_vpl VALUES ("PR10_31","021_10_31","PRO","10","31","31","Epe aanu nimu oro yalo epe kone sua epe pora rateme-pulu, nimu onaa luabu epe agaa lakelo-aeme. Goa pea pare wae agaa teme aa luaburi nimu oyalimi. ");
INSERT INTO kew_vpl VALUES ("PR10_32","021_10_32","PRO","10","32","32","Redepone aa-na agaare onaana aane-para rede warupea, pare wae aa-na agaamere onaanuna lo robaa-para rero mapaeme. ");
INSERT INTO kew_vpl VALUES ("PR11_1","021_11_1","PRO","11","1","1","Adaa Aa nipuna i robo kabula riri peme aanuri oyae waea-rupa rumaawa oyae yolateme. Goa pea pare epea peme onaare raname omoa rumaape epe-rupa popenalo pea. ");
INSERT INTO kew_vpl VALUES ("PR11_2","021_11_2","PRO","11","2","2","Nimuna bi minasaeme aanuri yala waru poteme. Nimuna bi rabuaniaeme aanuri epe kone imi. ");
INSERT INTO kew_vpl VALUES ("PR11_3","021_11_3","PRO","11","3","3","Ora epe aanuri nimu epe pora ora rateme. Pare yaa agaa ne aanuri nimu yaa agaa adaapu teme rabu nimuna go yaa agaame wae yoto mea katea rabu nimu oyalimi. ");
INSERT INTO kew_vpl VALUES ("PR11_4","021_11_4","PRO","11","4","4","Epe mone oyae adapu salipare go oyaeme ne omali rabu mada naraba mealia. Go yapare neme epe kone sua epe pora ratu aali-dare ne go su-amaa page adaalupu pirua epe su page meali. ");
INSERT INTO kew_vpl VALUES ("PR11_5","021_11_5","PRO","11","5","5","Epe kone imi aanu nimuna epe koneme epe pora mea wata rabu nimu epe-rupa pirua nimu epe kone sua epeanu peme. Goa pea pare waea peme aanu nimuna peme wae yaenumi nimu malopaaya rabu nimu lopeme. ");
INSERT INTO kew_vpl VALUES ("PR11_6","021_11_6","PRO","11","6","6","Epe redepone aanu nimuri nimuna epe kone maredepoyaya rabu nimu epe-rupa pimi. Go yapare aanu oyae madaa omeme-pi kone sua wae pora ratulalo peme aanu nimu lopoa wae-rupa pimi. ");
INSERT INTO kew_vpl VALUES ("PR11_7","021_11_7","PRO","11","7","7","Wae aanu nimuna purimi oyae luabu pa mealima kone suaaeme. Pare orope nimu omalimi rabu nimumi epe yae meda mada namealimi. ");
INSERT INTO kew_vpl VALUES ("PR11_8","021_11_8","PRO","11","8","8","Gore epe aanu madaa kedaa page wae yaenu meda epolalo palia-dare Adaa Aa-me nimu raba mealia-pulu nimu madaa wae yaenu mada naepalia. Goa palia-pulu go wae yae luabu mo pupitagi noaaeme aanu madaa popena tea. ");
INSERT INTO kew_vpl VALUES ("PR11_9","021_11_9","PRO","11","9","9","Go page mo wae aanu agaa teme rabu nimuna agaame onaa luabu maoyaatalo peme. Goa palimi pare mo epe aanu nimuna peme-ame nimu rabamealia rabu nimu epe-rupa piralimi. ");
INSERT INTO kew_vpl VALUES ("PR11_10","021_11_10","PRO","11","10","10","Epe aanu nimuna pirape yae puaa redepota raburi onaa nimu luabu ora raana omoa epe-rupa piruaeme. Go yapare aa padaneme oroyalo waea puawa nipu omea rabu onaa luabumi epe ta kone sua raana omeme. ");
INSERT INTO kew_vpl VALUES ("PR11_11","021_11_11","PRO","11","11","11","Epe redepone aanumi nimuna ada kagure-para epea peme rabu nimuna ada kagure page ora epe-rupa surubeme rabu epe-rupa aaya. Go yapare wae pupitagine aanu mi waea pulalo peme rabu go teme agaame mo ada kagure page ma-oyaaeme. ");
INSERT INTO kew_vpl VALUES ("PR11_12","021_11_12","PRO","11","12","12","Aa medame aa medana pi-lawa ero agaa tea-daare go aa nipu maeyae aa-rupa pia. Pa pirua agaa adaapu nalainalo ora epeta. ");
INSERT INTO kew_vpl VALUES ("PR11_13","021_11_13","PRO","11","13","13","Aanu medalomame maa agaa adaapu teme-pulu nimuna adami aanuna i kone page pa lapedepeteme. Goa peme pare ora agaa ne aanumi nimuna adami aanu kudiripu i kone nalapedepe teme. ");
INSERT INTO kew_vpl VALUES ("PR11_14","021_11_14","PRO","11","14","14","Gore mo gavman pimi aa mudunumi onaa luabu epe-rupa maredepoyawa nasurubaliare go onaa rayo oyoa mo kantri page oyalia. Go yapare aanu adaapumi go aanu epe kone epe agaa laketeme rabu epe-rupa maredepo yawa epealia rabu mo onaanuna kantri page epe-rupa aalia. ");
INSERT INTO kew_vpl VALUES ("PR11_15","021_11_15","PRO","11","15","15","Aa medame yano mua na-abutea rabu neme abulalua te pare wala neme na-abulali-daare ne orope kedaa epalia. Goa palia-ga ne ora epe-rupa pirano kone sali-dare neme mogo yaenu luabu masa rilaawa gimape. ");
INSERT INTO kew_vpl VALUES ("PR11_16","021_11_16","PRO","11","16","16","Onaame medaloma nimu ora epe ona loa adaa bi kana kone sua gupa peme. Yapare pa pora pame ona onaa medaloma mayala peme. Kiaa rakepene aame mone mada namealia pare kokono waru pe aame oyae adaapu mealia. ");
INSERT INTO kew_vpl VALUES ("PR11_17","021_11_17","PRO","11","17","17","Gore neme aa meda odome omoa nipu rabamealiri go palideare nena bipa ne-para wala pe. Pare neme aa meda waea pali-daare goame nena bipa ne page go maoyaaye yade. ");
INSERT INTO kew_vpl VALUES ("PR11_18","021_11_18","PRO","11","18","18","Waea pi aanumi oyae meda mulalo palimi-daare go yaeme nimu ora mada naraba mealia rabu waru yae-da nona napalia. Go yapare aanu medaloma epeanu palimi-daare nimu epe yoto mealimi. ");
INSERT INTO kew_vpl VALUES ("PR11_19","021_11_19","PRO","11","19","19","Aanu medalomame puri paboa epe kone ratalimiri gore nimu oro-yalo piraama laama pope kone wasupa mealimi. Go yapare waea papena puri pabeme aanuri nimu omalimi. ");
INSERT INTO kew_vpl VALUES ("PR11_20","021_11_20","PRO","11","20","20","Adaa Aa-me oro yalo wae kone imi onaare ora waru gipia. Go yapare epe-rupa aaeme onaare raaname omea. ");
INSERT INTO kew_vpl VALUES ("PR11_21","021_11_21","PRO","11","21","21","Gore ora ria wae onaare wae yoto mealimi pare epe onaare mada wadialimi. ");
INSERT INTO kew_vpl VALUES ("PR11_22","021_11_22","PRO","11","22","22","Gore ona meda ora epe pepena pualia pare nipu kone wae sua pora pamu agaa tea-daare nipumi pama tona pepena paaya. Gore mena ini-kadu madaa mere mudiaawa pepena paawa punitimi mena nonapi pia. ");
INSERT INTO kew_vpl VALUES ("PR11_23","021_11_23","PRO","11","23","23","Adaa Aa-me onaa luabuna imi kone-para pameme pora go rayo aba ado kiritea. Epe redepone aanu madaare epe kone luabu rubita. Go pea pare waea peme onaanumi epe oyaenu mealimi rabu onaa medalomame nimu madaa wae kone imi. ");
INSERT INTO kew_vpl VALUES ("PR11_24","021_11_24","PRO","11","24","24","Aa medaloma nimuna mone oyaenu page aa medaloma raba mulalo kateme. Pare nimuna bipa mo peme kogonona yoto ora adaapu meme. Wala aa medalomame onaa rabameape kone niminawa yapare wala gimeme. Nimuna mone oyae waru adaapu pagaa imi pare wala oropere go oyae luabu rudu ta rabu nimu wala naara aanu-rupa aeme. ");
INSERT INTO kew_vpl VALUES ("PR11_25","021_11_25","PRO","11","25","25","Aa medame oyaenu pa onaa kalawe kone sua oyae ruma kata pare nipuna bipa ora adaapu saayo kone sua pama pea. Go yapare neme pa aanu medaloma rabameli-dare nimumi ne page rabamealimi. ");
INSERT INTO kew_vpl VALUES ("PR11_26","021_11_26","PRO","11","26","26","Reaa pabea rabu onaame eta kabolalo agaa mealimi pare dia tea-dare go aa nipu wae kone suaeme. Go yapare aa medame nipuna eta onaame kabena tea-dare mo onaame go aa nipu ora raaname omalimi. ");
INSERT INTO kew_vpl VALUES ("PR11_27","021_11_27","PRO","11","27","27","Aa medame epe kone sua ora epe pora ratualia-dare onaa rayome nipu raaname waru omalimi. Go yapare wae aa-me agu pualiare go wae kedaa nipu madaa popalia. ");
INSERT INTO kew_vpl VALUES ("PR11_28","021_11_28","PRO","11","28","28","Gore aame nina mone oyaeme ni waru rabamealia kone saliare go aa nipu repena yo kaapu-rupa ora alupalia. Pare nipu epe redepone-rupa aawaliare nipu kagaa repena maa pula saayade-rupa opoa epe-rupa piralia. ");
INSERT INTO kew_vpl VALUES ("PR11_29","021_11_29","PRO","11","29","29","Go yapare aa meda nipuna ona naaki ruruna oyae waru nasurubaliare nipuna oyae luabu ora dia yalia. Goa pua ora alupalia. Goa palimi-ga epe kone imi aanu kogono pa palimina. ");
INSERT INTO kew_vpl VALUES ("PR11_30","021_11_30","PRO","11","30","30","Epe aana kone-re epe repena kagaa laama pope repena aaya-rupa aalia. Aa meda nipu ora epe kone sua makuae aa pia raburi pa aanu medaloma nipu raapu epa piruaina kone ia. ");
INSERT INTO kew_vpl VALUES ("PR11_31","021_11_31","PRO","11","31","31","Gore niaame aba adema. Epe-rupa pimi aanuna pemeare nimu go su-amaa pirua oyae adaapu epe yoto-rupa mua pimi. Goa pea pare wae aanu nimuna wae yoto ora mealimi-ga nimu ora pakealimi kone nasamina. Dia Adaa Aa-me nimuna wae yaena yoto ora katea. ");
INSERT INTO kew_vpl VALUES ("PR12_1","021_12_1","PRO","12","1","1","Aa medaloma nimu ora epe kone madaa raaname omoa pa aa medame maredepo agaame madaa page epealia kone imi. Go yapare aa medame nipuna pea wae yae namaredepo yaena kone aamere nipu ora maeyae aa-rupa pirua pea. ");
INSERT INTO kew_vpl VALUES ("PR12_2","021_12_2","PRO","12","2","2","Gore aame epe pora ratua epe kone suayare Adaa Aa-me go aa nipu epe lo robaa kata. Go yapare aa medame onaa para waea paliare go aa nipuri Adaa Aa-me alupainata. ");
INSERT INTO kew_vpl VALUES ("PR12_3","021_12_3","PRO","12","3","3","Gore aa meda waea pua epe-rupa napiralia raburi go peame nipu mada naraba mealia-pulu epe-rupa napitia. Nipu puri pabo page napiralia. Goa pea pare aa meda nipu ora epe pora ratua piraliare repena pitaa su runane pea-rupa mada yapulu aa medame nipu mada narasu lopalia. ");
INSERT INTO kew_vpl VALUES ("PR12_4","021_12_4","PRO","12","4","4","Aa medana oreme epeanu paliare mo aani go pea kogono-me epe bi kata. Go yapare mo aa nipuna oreme waea rado rado adaapu pua aani page yala mea kata. Go pua mo ona nipumi peame wae yaina ipua mo aanina uni rodaipa-para odobaawa yaina-rupa mea kata. ");
INSERT INTO kew_vpl VALUES ("PR12_5","021_12_5","PRO","12","5","5","Epe redepo ne aa-mere oro yalo epea pape madaa raaname waru omea. Go yapare wae kone sua waea pea aamere oro yalo yala poloa onaana kone mabebola pena wae pora mea watalo pea. ");
INSERT INTO kew_vpl VALUES ("PR12_6","021_12_6","PRO","12","6","6","Wae aanuna agaa-re aa medalomame kudiripu yada sua aa yago tulalo pemede-rupa kone imi. Go yapare epe redepone aanuna agaa-me onaa medaloma kedaa rua yaina omeme rabameapena kone sua agaa teme. Epe-rupa pirina kone sua agaa teme. ");
INSERT INTO kew_vpl VALUES ("PR12_7","021_12_7","PRO","12","7","7","Aa medame waea pualiare nipu oyoa ora alupalia. Goa palia pare epe redepone aanu-nimuri epe-rupa oro yalo pa piralimi. ");
INSERT INTO kew_vpl VALUES ("PR12_8","021_12_8","PRO","12","8","8","Aa meda nipu epe kone su aaliare onaame go aa nipuna bi minasalimi. Go yapare aa meda nipu wae bebone kone saliare onaame go aa nipuna bi mabebo laeme. ");
INSERT INTO kew_vpl VALUES ("PR12_9","021_12_9","PRO","12","9","9","Aa meda bi waru na-i aa yapare kogono aa meda nipuna ada-para ma-aaliare epe ta. Pare aa medame nipu adaa aa kone sua naara aanu rabuaatalo kone ia-pulu nipu naepeta rabu eta nape yaenu page rudu neme pama pea. ");
INSERT INTO kew_vpl VALUES ("PR12_10","021_12_10","PRO","12","10","10","Epe redepone aanumi nimuna mena oyae luabu madaa odome waru omoa epe-rupa surubeme. Go yapare wae aanu nimuna mena oyaenu page waru epe-rupa nasurubeme. ");
INSERT INTO kew_vpl VALUES ("PR12_11","021_12_11","PRO","12","11","11","Aa medame nipuna e maapu waru surubaliare gore nipuna eta nape yae waru salia. Go yapare aa medaloma epe kone naimiri nimu pama kalai pua kogono pu sua epe ini meda namealia. ");
INSERT INTO kew_vpl VALUES ("PR12_12","021_12_12","PRO","12","12","12","Wae aanu pupitagi noa oyae adaapu wae-rupa meme. Goa pua nimumi oyaenu madaa epame waru omeme. Epe redepone aanu nimuna meme yaenuri nimuna mo peme epe konena ini raloa meme. Goa pua nimumi oyae ora adaapu imi. ");
INSERT INTO kew_vpl VALUES ("PR12_13","021_12_13","PRO","12","13","13","Wae aa nimuna teme wae agaa-me nimuna bipa nimu adita. Goa yapare kedaa wae meda epe redepone aanu madaa popeare nimuna epe koneme nimu wala epe-rupa rabamea. ");
INSERT INTO kew_vpl VALUES ("PR12_14","021_12_14","PRO","12","14","14","Neme tede epe agaa-para nena epe pamualide porame ne maepealia. Goa pua ne epe-rupa piruali. ");
INSERT INTO kew_vpl VALUES ("PR12_15","021_12_15","PRO","12","15","15","Kone epe-rupa na-imi aanumiri nimuna pema oyae rayo ora epe ta kone imi. Go yapare epe kone imi onaa agaa mana laketeme rabu ora epeta kone imi. ");
INSERT INTO kew_vpl VALUES ("PR12_16","021_12_16","PRO","12","16","16","Epe kone naimi aanumi waea meda pulalo peme raburi nimumi go madaa ratu aipapulu yaweme. Go yapare epe kone i aa meda ero agaa teme raburi go aa nipu epe kone ia-pulu pinawa kone sua gimalia. ");
INSERT INTO kew_vpl VALUES ("PR12_17","021_12_17","PRO","12","17","17","Koso rabami aa epe yaliare agaa waru eperupa tea. Go yapare nipu agaa waerupa ne aa yaliare nipumi koso ma-oyalia. ");
INSERT INTO kew_vpl VALUES ("PR12_18","021_12_18","PRO","12","18","18","Aa medame kone waru nasua tea agaa-me epe aa medana robaa-para maoyalia. Goa palia pare epe redepone kone i aa-me agaa tea-daare mo aana lo robaapara epe kumaa waru katea. ");
INSERT INTO kew_vpl VALUES ("PR12_19","021_12_19","PRO","12","19","19","Yaa teme agaa luaburi pa rudupu yapina ia rabu aanumi kone rugulaawa gimeme. Goa pea pare ora ne agaa luaburi oro yalo-yalo pa suaalia. ");
INSERT INTO kew_vpl VALUES ("PR12_20","021_12_20","PRO","12","20","20","Aanumi waea peme rabu go pemeame nimuna bipa nimu makiraeme. Goa peme pare aa medame epe kone sua onaa rabameano kone sua epea palia-daare nipu page epealia. ");
INSERT INTO kew_vpl VALUES ("PR12_21","021_12_21","PRO","12","21","21","Redepone aanumi pupitagi page ora nanoa epe oyae mealimi. Goa peme pare waea peme aanumiri nimumi wae pupitagi rado-rado adaapu neme. ");
INSERT INTO kew_vpl VALUES ("PR12_22","021_12_22","PRO","12","22","22","Yaa-agaa teme aanu luaburi Adaa aa-me nimu ratu waru yawoa gimea. Goa pea pare epe kone sua epea peme aanu madaare raana omoa epe ta kone ia. ");
INSERT INTO kew_vpl VALUES ("PR12_23","021_12_23","PRO","12","23","23","Aa meda nipumi epe aanu puayare nipuna epe kone epea luabu aipapulu ratea. Goa pea pare aa meda nipu epe kone-nai pa wae-kone rubitabe aa nipumi yaa agaa adaapupe madu koyoata. Goa pea pare onaa luabumi nipuna agaa pagoa go aa-re maeyae aa-rupa pia teme. ");
INSERT INTO kew_vpl VALUES ("PR12_24","021_12_24","PRO","12","24","24","Kogono radaa pina paliade aare nipu puri mua mada pitea. Goa palia pare kiaa rakepene aanuri pama kogono aanu pitimi. ");
INSERT INTO kew_vpl VALUES ("PR12_25","021_12_25","PRO","12","25","25","Go page aa medame oro yalo kone adaapu su aalia-dare nipuna kone oyo tua maeyae aa-rupa pitia. Goa palia pare wae aa nipuna adami aa-me epe agaa redepone laketea-dare mo nipuna adami aa-me epe kone lo robaa waru katea. ");
INSERT INTO kew_vpl VALUES ("PR12_26","021_12_26","PRO","12","26","26","Epe redepone kone i aanumi nimuna adami aanu epe pora mea wateme. Go yapare mo wae aanu nimuna adami aanu epe pora gimoa wae pora para mea peme. ");
INSERT INTO kew_vpl VALUES ("PR12_27","021_12_27","PRO","12","27","27","Kiaa rakepene aame yapa asa nola palia pare mo yapa mada natalia. Pare kalai pua kogono raadapi peme aanuri epe-rupa riri-nane epope aanu go yade. ");
INSERT INTO kew_vpl VALUES ("PR12_28","021_12_28","PRO","12","28","28","Aa neme epe pora ratua aawaliri ne ora epe-rupa oro yalo pirape yada mua ne epe-rupa pirali. Gore niaame go epe pora ratalimare niaa omape yaeme page nami epe-rupa oro yalo piralima. ");
INSERT INTO kew_vpl VALUES ("PR13_1","021_13_1","PRO","13","1","1","Gore naaki medame epe kone saliare nipuna aapana agaa waru pagea. Agaa rasini naaki-mere pa aanumi nipu maredepo-yaina kone na-ia. ");
INSERT INTO kew_vpl VALUES ("PR13_2","021_13_2","PRO","13","2","2","Epe agaa ne aamere nipumi epe oyaenu mualia. Go yapare yaa agaa ne aanuri nimumi rogaawa i agaa rasitimi. Goa pua onaa luabu ma-oyape madaa raaname waru omeme. ");
INSERT INTO kew_vpl VALUES ("PR13_3","021_13_3","PRO","13","3","3","Aa medame nipu agaa abulu waru suruboa epe agaa loa aaliare nipu mada na-oyalia. Go yapare wae agaa loaeme aanu nimu oyoa beboteme. ");
INSERT INTO kew_vpl VALUES ("PR13_4","021_13_4","PRO","13","4","4","Kiaa rakepene aanumi oyae adaapu meawe kone sua aaeme pare nimume go yae mada nameme. Go yapare radaa noa kalaipu kogono peme aanumi oyae adaapu meme. Gore oyae adaapu nimuna raana omeme-rupa meme. ");
INSERT INTO kew_vpl VALUES ("PR13_5","021_13_5","PRO","13","5","5","Epe redepone aanu nimumi yaa agaa loa makirape madaare gimi omeme. Go yapare wae aanumi yala pia agu pulalo peme pare nimu madaa yala paala an-ia. ");
INSERT INTO kew_vpl VALUES ("PR13_6","021_13_6","PRO","13","6","6","Aa-me epea agu paliare nipuna go peame nipu surubea rabu epe-rupa piruaaya. Goa pea pare wae-pupitagi neme aanu nimu go wae yaena yoto mua wae-rupa piralimi. ");
INSERT INTO kew_vpl VALUES ("PR13_7","021_13_7","PRO","13","7","7","Aa riabo naara aa medalomame nimu mone oyae adaapu sawe kone madaa makirae kone suaeme. Amope mone oyae ora adaapu i aanumi page go-rupa mo aa naaranumi imi kone sua aeme. ");
INSERT INTO kew_vpl VALUES ("PR13_8","021_13_8","PRO","13","8","8","Gore wae aanumi amone aa tulalo palimiri nipumi mone oyae adaapu mogo aanu kaloa epe-rupa piralia. Go yapare aa riabo naara nimuri oyae page naimi-pulu wae aanumi nimu nabebolaeme. ");
INSERT INTO kew_vpl VALUES ("PR13_9","021_13_9","PRO","13","9","9","Epe redepo aanu nimuri laba paa roaya-rupa mada pimi. Pare wae aanuri mo laba oyoa uduna repe-repe piade piaene pimi. ");
INSERT INTO kew_vpl VALUES ("PR13_10","021_13_10","PRO","13","10","10","Pupitagi nape konemere go aa kone wae madaa yada ratu runane mea pea. Go yapare aa yago medame nipu maredepo yaina kone ia aare epe kone sua waru makuaya. ");
INSERT INTO kew_vpl VALUES ("PR13_11","021_13_11","PRO","13","11","11","Aa medame kogono napi pama awa ode mone mualiare go mone ora dia yalia. Go yapare aa medame kogono pua mone pawa oge-ogepu mea kirita samama pua ma-adaa yalia-dare go mone ora adaa yalia. ");
INSERT INTO kew_vpl VALUES ("PR13_12","021_13_12","PRO","13","12","12","Aa medame oyaenu meda mealua kone sua adaalupu suruboa namealiare nipu lo robaa kedaame omalia. Goa palia pare nipumi go oyae mu minuare nipuna kone pu robaa-para page epe ta kone sua raaname omea. ");
INSERT INTO kew_vpl VALUES ("PR13_13","021_13_13","PRO","13","13","13","Aa yago medame aa meda epe agaa epe pora waloa agaa mana laketalo palia rabu nipumi gimalia-daare go aa nipu oyalia. Go yapare aa medame agaa maana teade waru pagalia-daare go aa nipu epe-rupa pirualia. ");
INSERT INTO kew_vpl VALUES ("PR13_14","021_13_14","PRO","13","14","14","Epe redepone aa-na agaa ora epe ta-pulu ipa laipi epe-rupa oro yalo pirama lama pope ipa-rupa pia. Go agaa-me aa rabamealia rabu epe-rupa pirua wae yae madaa pakealimi. ");
INSERT INTO kew_vpl VALUES ("PR13_15","021_13_15","PRO","13","15","15","Gore aa medaloma epe kone saliamiri onaa medalomame nimu bi minasalimi. Go yapare rogaa i agaa rasini aanu nimu wae pora ratua pamueme. ");
INSERT INTO kew_vpl VALUES ("PR13_16","021_13_16","PRO","13","16","16","Aanu epe pora ratua epe kone salimiri epe kone aba sua oyae peme. Go yapare wae-rupa agaa lo wae pora rateme aanu nimuna pemeanu luabu pename amaa mea watea. Goa pua nimuna maeyae kone pename amaa ia. ");
INSERT INTO kew_vpl VALUES ("PR13_17","021_13_17","PRO","13","17","17","Gore agaa yaa loa makirae agaa pereke-pereke teme aanu nimu wae kedaa mea epope kone sua aeme. Go yapare aame agaa mea ipua go agaa redepone onaa lakeloa epe-rupa rabamealia-dare epe-rupa pitimi. ");
INSERT INTO kew_vpl VALUES ("PR13_18","021_13_18","PRO","13","18","18","Aa meda aa yagome nipu maredepo-yaina kone na-i nipuna bipa nipu kone-kone sua aaliare nipu oyoa aa naara pirua ora wae-rupa piralia. Goa pua nipu yala polo aalia. Goa palia pare aa meda nipu pa onaame maredepo yaina kone sua maredepo yaina teare go aa nipu onaa luabumi epe bi kateme rabu ada bi mealia. ");
INSERT INTO kew_vpl VALUES ("PR13_19","021_13_19","PRO","13","19","19","Aa medame whose friend oyae meda mealua kone sua orope mealiare nipuna lo robaa-para raana adaa omoa pedo pedo adaa pua aalia. Go yapare wae aanu nimumi nimuna wae yae gimae kone na-i pa pu aaeme. ");
INSERT INTO kew_vpl VALUES ("PR13_20","021_13_20","PRO","13","20","20","Go yapare go aa nipu epe kone i aa raapu pora pamualiare go aa nipu page go aa-na kone mua nipu epe kone raapu pamualia. Go yapare aa meda nipu wae kone i aa raapu pamualiare go aa nipu wae yaeme nipu mealia-pulu wae pupitagi-na rolo-para piralia. ");
INSERT INTO kew_vpl VALUES ("PR13_21","021_13_21","PRO","13","21","21","Wae yaeme pupitagi ne aa nimu ora mulalo rapea. Pare epe redepone aanu nimuri nimuna meme epe yaere nimuna yoto-rupa meme. ");
INSERT INTO kew_vpl VALUES ("PR13_22","021_13_22","PRO","13","22","22","Epe aa meda nipu omea raburi nipuna sinu page nipuna oyae luabu nimu meme. Go yapare wae aanumi oyae adaapu mea kirita imi yaenuri orope epe aanumi mealimi. ");
INSERT INTO kew_vpl VALUES ("PR13_23","021_13_23","PRO","13","23","23","Naara pimi aanuna e-maapu-para eta nape oyae adaapu inalo pare adaa aa mudunumi makirawa go eta nimu muaaeme. ");
INSERT INTO kew_vpl VALUES ("PR13_24","021_13_24","PRO","13","24","24","Aaraame nipuna naaki pupitagi nalia rabu nipu ki paarame nataliare gore nipumi go naaki mana nata-pulu go naaki raname na-omea. Go yapare araame nipuna naaki agaa mana lakeloa maredepo yayaa-re ora nipuna si kone ia. ");
INSERT INTO kew_vpl VALUES ("PR13_25","021_13_25","PRO","13","25","25","Epe redepone aanuna eta ora adaapu rulatabena imi. Pare wae pupitagi neme aanu nimu oro yalo reaeme omo-aaeme. ");
INSERT INTO kew_vpl VALUES ("PR14_1","021_14_1","PRO","14","1","1","Epe kone ia oname nipuna ada-para page epe kogono pea. Go koneme nipuna nogo naaki onaa luabu raapu puri mapabawa epe-rupa pimi. Go yapare ona meda nipu epe kone nasaliare nipuna bipa nipuna nogo naaki ada oyae luabu ma-oyaawa wae-rupa pitimi. ");
INSERT INTO kew_vpl VALUES ("PR14_2","021_14_2","PRO","14","2","2","Epe konena pora ratua pia aamere Adaa Aa-na surube rolo-para pia. Go yapare yaa agaa ratamea pe aanumiri Adaa Aa-re ora epe yae-da dia kone imi. ");
INSERT INTO kew_vpl VALUES ("PR14_3","021_14_3","PRO","14","3","3","Epe kone na-imi aanuna agaa teme raburi onaana ini agaana nimumi nimuna bi minasae agaa oraa teme. Epe kone i aa-na agaa ta rabu ora epe ta-pulu nipu rabamea rabu epe-rupa aaya. ");
INSERT INTO kew_vpl VALUES ("PR14_4","021_14_4","PRO","14","4","4","Mena gawa su awoa e poape meda diayalia raburi mo eta kirita i ada pa pupaa salia. Pare mo mena gawame e poalia raburi e-maapu para eta ora adaapu sualia. ");
INSERT INTO kew_vpl VALUES ("PR14_5","021_14_5","PRO","14","5","5","Koso raba mi aa-me koso ada-para epe redepone agaa tea rabu mo kosome ora ne agaa pagalia. Go yapare nipu yaa-agaa ne aamere mo ta agaa luabu yaa agaa tea. ");
INSERT INTO kew_vpl VALUES ("PR14_6","021_14_6","PRO","14","6","6","Wae aakone ne aanu nimu epe kone mulalo palimi-daare nimu epe kone mada namealimi. Go yapare aa nipuna kone epealiare mo epe kone meape madaa kalai napi pawa kumapi-rupa aipapulu mealia. ");
INSERT INTO kew_vpl VALUES ("PR14_7","021_14_7","PRO","14","7","7","Ne mo wae kone imi aanu raapu meda-para napiri ne ora mopare yola-moneape. Gore nimumi ne epe kone meda mada nagialimi. ");
INSERT INTO kew_vpl VALUES ("PR14_8","021_14_8","PRO","14","8","8","Aa nipu epe kone sua nipuna eta no pora pamea yae luabu ora epeta. Go yapare aa meda nipu epe kone na-iare nipuna bipa nipu makiraaya. Gore akolo ya? Nipuna kone waru na-ia-pulu nipu maeyae aa pia. ");
INSERT INTO kew_vpl VALUES ("PR14_9","021_14_9","PRO","14","9","9","Epe kone na-imi aanu nimuna pulalo peme yae rayo pa kone padane agu sua peme. Goa peme pare epe aanu nimuna bipa epea agu peme. Goa pua nimu lo robaa padane-para sua peme. ");
INSERT INTO kew_vpl VALUES ("PR14_10","021_14_10","PRO","14","10","10","Aa nipuna bipa nipuna lo robaa-para ia kedaa page raana page nipuna bipa makuaya. Goa pua wala aa yago meda mada namea watea. ");
INSERT INTO kew_vpl VALUES ("PR14_11","021_14_11","PRO","14","11","11","Wae aa nipuna ruru ona nogo naaki luabu ora oyoa luabu dia yalimi. Go yapare mo epe redepone aa-na ruru ora puri waru mua nimu ora epe ruru piralimi. ");
INSERT INTO kew_vpl VALUES ("PR14_12","021_14_12","PRO","14","12","12","Aa medalomame gupa kone imi: Nimuna pema yae rayo epe ta kone sua peme. Go yapare nimumi pama pama pua omalimi. ");
INSERT INTO kew_vpl VALUES ("PR14_13","021_14_13","PRO","14","13","13","Niaame giri lo aalima page wae lo robaa kedaa niaa mada nagimalia. Raana omo pirape yapi-di rabu page lo robaa kedaa ora mada na-dia yalia. ");
INSERT INTO kew_vpl VALUES ("PR14_14","021_14_14","PRO","14","14","14","Wae aanu nimuna peme wae yae madaa ini noa raana waru omeme. Go yapare epea peme aanu nimu pedo raana waru peme. ");
INSERT INTO kew_vpl VALUES ("PR14_15","021_14_15","PRO","14","15","15","Aanu nimu makuae yae ogesi i aanumi agaa ia-rupa luabu kone waru rulaeme. Goa pea pare kone epe-rupa ia aame nipuna lape agaa rayo waru kone makuaawa ta. ");
INSERT INTO kew_vpl VALUES ("PR14_16","021_14_16","PRO","14","16","16","Epe kone i aa nipumi nipuna kone waru suruboa nipu madaa wae yae ora naepena kone ia. Wae aame re oyae rayo pa epeta kione sua rayo pa palua kone sua pa pama pea. Nipu wae aa yade kone page na-ia. ");
INSERT INTO kew_vpl VALUES ("PR14_17","021_14_17","PRO","14","17","17","Ratu yawe aanumi maeyawa ratu ora aipapulu yaweme. Onaa luabumi aa meda oro yalo nipuna raana ratuaaya madaare gimi omeme. ");
INSERT INTO kew_vpl VALUES ("PR14_18","021_14_18","PRO","14","18","18","Aa medaloma ogesi makuawa nimu mo maeyae aanuna kone rateme. Go yapare epe aanu nimuna makuae yaere nimuna alu-para epe pepena peme raguname adea. Go aa nipuna ia kone-re epe aaluna pepena yade. ");
INSERT INTO kew_vpl VALUES ("PR14_19","021_14_19","PRO","14","19","19","Wae pupitagi aanu nimu mo epe aanu pitimi-para pirua nimu rabamu eta epe yaenu kanalo agaa lo piralimi. Nimu odome omena kone sua pitimi. ");
INSERT INTO kew_vpl VALUES ("PR14_20","021_14_20","PRO","14","20","20","Aa medaloma oyae rudu teme adape-re gime omeme. Nimuna aapa ame yalia page ora gimeme. Amone aanu nimuna adami aanu adaapu aawaeme. ");
INSERT INTO kew_vpl VALUES ("PR14_21","021_14_21","PRO","14","21","21","Aa medame aa yago meda naara mapiralia-re go aa nipu maeyawa naarame pama pea. Go yapare aa medame oyae ruduta aanu madaa odome omoa titi omalia-daare go aa nipu epe raana mealia. ");
INSERT INTO kew_vpl VALUES ("PR14_22","021_14_22","PRO","14","22","22","Aanumi wae yae oro yalo pumuna kone sua pualimiri nimuna kone ota. Go yapare aa medame epea peme mada rana omoa onaame epe pora ratina kone salia-dare epe kone go aa waru kata. ");
INSERT INTO kew_vpl VALUES ("PR14_23","021_14_23","PRO","14","23","23","Neme kogono waru radaa pina pali-dare ne ora epe yoto meali. Go yapare ne pa pirua agaa wariba pirali-dare ne wae naarame omali. ");
INSERT INTO kew_vpl VALUES ("PR14_24","021_14_24","PRO","14","24","24","Epe kone ia aa-na konere nimuna mone yade. Go yapare aa medaloma epe kone na-imire nimu maeyae kone agu su aaeme. ");
INSERT INTO kew_vpl VALUES ("PR14_25","021_14_25","PRO","14","25","25","Gore aa medame koso raba mu agaa epe-rupa teare mo kosome aa tumaomaarina-re waea pana tea. Go yapare mo koso raba meape agaa epe-rupa nateare go aa nipu makira agaa ne aa. ");
INSERT INTO kew_vpl VALUES ("PR14_26","021_14_26","PRO","14","26","26","Aa meda nipu Adaa Aa-na agaa ratua kumapi-rupa piraliare nipu oyae meda palame na-omalia. Goa pua nipuna nogo naakinu page nimu luabu epe-rupa piralimi. ");
INSERT INTO kew_vpl VALUES ("PR14_27","021_14_27","PRO","14","27","27","Adaa Aa-na agaa pagoa nipu ratapena konere ipa laipi kagaa piraama lama popena re yade. Go kone i aanu madaa wae yaenu naepalia. Go pua mo wae yaenu epolalo palia page mada mapakealia. ");
INSERT INTO kew_vpl VALUES ("PR14_28","021_14_28","PRO","14","28","28","Aa mudu king medame onaanu adaapu surubaliare nipu adaa bi mea kateme. Go yapare mo aa mudu king nipumi onaa ogepusi surubalia raburi nipu adaa bi nasalia. ");
INSERT INTO kew_vpl VALUES ("PR14_29","021_14_29","PRO","14","29","29","Aa meda nipu ratu aipapulu nayaweare go aa nipu ora epe kone waru ia. Go yapare ratu yawe aa maeyae kone ora epe ta kone ia. ");
INSERT INTO kew_vpl VALUES ("PR14_30","021_14_30","PRO","14","30","30","Aa meda nipu pu robaa kumapu pawa ina pirualiare nipuna to yogaene page epealia. Go yapare aa meda nipumi wae agaa loa oro yalo oyae epame omape kone sualiare wae yaina go aa nipu madaa pupua nipuna uni luabu mada maopaya. ");
INSERT INTO kew_vpl VALUES ("PR14_31","021_14_31","PRO","14","31","31","Gote nipumi onaa raayo warisa-pulu aa medame go aa nere ora aa naare wae te-dare neme Gote page wae gote yade te. Go yapare Gote adaa bi katere naaranu page epea pali. ");
INSERT INTO kew_vpl VALUES ("PR14_32","021_14_32","PRO","14","32","32","Wae aanu nimuri nimuna peme wae yaenumi nimu maoyaeme. Goa peme pare epe-rupa pimi aanu nimuri oyae meda page ake palua pae kone na-i epe rupa aeme. Nimu madaa omape yaeme mealia rabu page kone rulae yae mada puri paboa aalimi. ");
INSERT INTO kew_vpl VALUES ("PR14_33","021_14_33","PRO","14","33","33","Kone epe waru na-imi aanu nimuna bipa aba makuaeme. Makuae yae-para epe kone lapore nimumi minalo suruba pia pare nameme. Go yapare epe kone imi aanu nimuna minalo epe kone epe pora ratua oro yalo muaeme. ");
INSERT INTO kew_vpl VALUES ("PR14_34","021_14_34","PRO","14","34","34","Gore onaa luabumi epe kone sua epe agaa ratalimiri go kantri epealia. Go yapare nimumi wae-yaenu pa pala pitimiri nimu yala adaa poteme. ");
INSERT INTO kew_vpl VALUES ("PR14_35","021_14_35","PRO","14","35","35","Aa mudu king nimuna kogono aanumi epe kogono peme raburi nimu madaa raana waru omea. Kogono aanumi wae kogono peme raburi mo aa mudu king nipu yala mapaeme. Goa peme rabu king nipumi nimu ratu yawalia. ");
INSERT INTO kew_vpl VALUES ("PR15_1","021_15_1","PRO","15","1","1","Aa medame ne-para ronopi agaa meda tea-dare nipuna agaa kumapimi abulape. Goa pali rabu nipuna ratu yawe kone dia yalia. Go yapare neme aa meda-para ero agaa loa yala mapaliri mo aame ratu adaa yawoa ne-para ratu waru yawalia. ");
INSERT INTO kew_vpl VALUES ("PR15_2","021_15_2","PRO","15","2","2","Aa medame epe kone sua epe agaa teare nimumi go aa-na kone makuae yae ora epeta loa raana omalimi. Go yapare aa meda epe kone na-imi agaa tea-dare go agaa re nai agaa ta. ");
INSERT INTO kew_vpl VALUES ("PR15_3","021_15_3","PRO","15","3","3","Adaa Aa-me su luabu-para pea yae rayo ada makuaaya. Nipumi epe aa wae aa luabu ado kiritea. ");
INSERT INTO kew_vpl VALUES ("PR15_4","021_15_4","PRO","15","4","4","Aa medame epe agaa onaa luabu laketa rabu go agaa pageme onaa luabu nimu laipi kalape repena nonapina agaa pagalimi. Go yapare aa medame onaa-para wae agaa-teare onaa luabuna kone ma-oyalia. ");
INSERT INTO kew_vpl VALUES ("PR15_5","021_15_5","PRO","15","5","5","Aa meda nipu epe kone na-saliare nipuna aapana agaa rasita. Goa pea pare pa aa medame nipu agaa loa maredepo yaina gimaliare go aa nipu ora epe kone mealia. ");
INSERT INTO kew_vpl VALUES ("PR15_6","021_15_6","PRO","15","6","6","Epe aanu nimu luabuna ada-para oyae ora adaapu imi. Wae aanu nimuna mone-me nimu kedaa ora adaapu mea kata. ");
INSERT INTO kew_vpl VALUES ("PR15_7","021_15_7","PRO","15","7","7","Epe kone imi aanumi onaa luabu epe kone kateme. Go yapare epe kone rudu teme aanumiri goa page napeme. ");
INSERT INTO kew_vpl VALUES ("PR15_8","021_15_8","PRO","15","8","8","Adaa Aa-me waea peme aanuna opa kateme yae luaburi ora gimea. Pare epe redepone aanumi teme betene raana omoa pagea. ");
INSERT INTO kew_vpl VALUES ("PR15_9","021_15_9","PRO","15","9","9","Adaa Aa-me wae aanumi peme yae luaburi ora raaname naomea. Epe aanu nimumi agaa ratua peme rabu raaname omea. ");
INSERT INTO kew_vpl VALUES ("PR15_10","021_15_10","PRO","15","10","10","Aa medame epe pora minarepaliare wae yoto mealia. Aa meda nipu maredepo-yaina lape gimaliare nipu omalia. ");
INSERT INTO kew_vpl VALUES ("PR15_11","021_15_11","PRO","15","11","11","Adaa Aa-me aba ome onaa luabu pimi-para ado kiritea. Go su amaa onaa niaana ima kone page luabu ora waru aba ado kiritea. ");
INSERT INTO kew_vpl VALUES ("PR15_12","021_15_12","PRO","15","12","12","Aakone i aamere pa aa medame nipu maredepo yaina kone ora na-ia. Goa pea-pulu aa meda-para nipu epe kone gialepa natea. ");
INSERT INTO kew_vpl VALUES ("PR15_13","021_15_13","PRO","15","13","13","Gore aa medana robaa-para epe kone saliare nipuna ini agaa-para epealia. Go yapare aa meda nipuna ini agaa-para roke rialiare nipuna robaa-para ota. ");
INSERT INTO kew_vpl VALUES ("PR15_14","021_15_14","PRO","15","14","14","Epe kone ia aamere puri palo kogono waru pua oyae meape madaa page makuae yae meape mada page kogono pea. Go yapare wae kone i aamere maeyae agaa talo agu pea. ");
INSERT INTO kew_vpl VALUES ("PR15_15","021_15_15","PRO","15","15","15","Aa meda nipu oyae rudu ta raburi oro yalo kone adaapu sua nipu wae-rupa piruaya. Epe kone sua raana raana-me oroyalo ome aare epe eta nolalo peme rana mada omea. ");
INSERT INTO kew_vpl VALUES ("PR15_16","021_15_16","PRO","15","16","16","Gore neme oge oyaesinu saa pirua Adaa Aa-na agaa pago ratua nipuna rolo-para piti-daare gore ne epe-rupa pirua kedaa riawa yaeme mone adapu i amope page rabuaniaaya. ");
INSERT INTO kew_vpl VALUES ("PR15_17","021_15_17","PRO","15","17","17","Aa yago raana ome kone-re ririnane agaa go yade. Nena adami aanu raapu meda-para pirua padi raani no piralimiri gore epeta. Go yapare raana naome aanu raapu gawa midi no pimidi rabuaaye. Gore nimu raapu mena no piri nona palia. ");
INSERT INTO kew_vpl VALUES ("PR15_18","021_15_18","PRO","15","18","18","Ratu yawea aamere mo aa meda page ratu mayawaya. Go yapare epe lo robaa kumapu i aame aanu medaloma-na kone lo rabaa pawa ma-epeaya. Goa pua nimu lo robaa padane-para sua mapiraya. ");
INSERT INTO kew_vpl VALUES ("PR15_19","021_15_19","PRO","15","19","19","Kiaa rakepene aamere nipu epe kumapi-rupa pirape yaere ota kone ia. Goa peapulu nipu pa raa rugulua pamuaya. Redepoya pia aa nipu oro yalo kagaa pirape yae epe ta kone ia. Gore epe poranini pamema-rupa madaa. ");
INSERT INTO kew_vpl VALUES ("PR15_20","021_15_20","PRO","15","20","20","Epe kone i naakiri agi aarame raaname omepe. Go yapare naakimi epe pora naratalia-re go naakimi agi aaraa gimaaya. ");
INSERT INTO kew_vpl VALUES ("PR15_21","021_15_21","PRO","15","21","21","Epe kone na-i onaa-me maeyae kone ratape page pedo waru peme. Go yapare epe kone ia aamere nipu oro yalo epe kone ratua epea pu aaya. ");
INSERT INTO kew_vpl VALUES ("PR15_22","021_15_22","PRO","15","22","22","Neme kogono meda pulalo pali-dare aanu adaapuna kone aba meape. Goa pali raburi mo nena palide kogono luabu ora epealia. Go yapare neme aa medana kone namealiri nena kogono ini namadialia rabu pama kalaipu kogono pusali. ");
INSERT INTO kew_vpl VALUES ("PR15_23","021_15_23","PRO","15","23","23","Aa medalomame agaa lo pitimi rabu riaa lo kiritina loa neme epe agaa meda te-daare go rabu ne page raana palia. ");
INSERT INTO kew_vpl VALUES ("PR15_24","021_15_24","PRO","15","24","24","Epe kone i aare so madaa porana opasari pea-pulu nipu epe-rupa pirape pada puaa mealia. Goa pea-pulu nipu no rolopara-ia poranini pua ome onaana pada wala napua mealia. ");
INSERT INTO kew_vpl VALUES ("PR15_25","021_15_25","PRO","15","25","25","Aa meda nipuna bipa nipuna bi minasalia rabu Adaa Aa-me nipuna ado bebo malalia. Go yapare ona wasa aani aba omere rabamealia. Aa medame go onana su mada namealimi. ");
INSERT INTO kew_vpl VALUES ("PR15_26","021_15_26","PRO","15","26","26","Wae kone luaburi Adaa Aa-na ini agaa madaa pugu waru pea. Goa pea pare epe redepoyoa rolo ti agaa madaare nipuna ini agaa madaa epetada raana waru omea. ");
INSERT INTO kew_vpl VALUES ("PR15_27","021_15_27","PRO","15","27","27","Aa medame mone adaapu orayo kone sua wae pora ratua mealiadare nipuna ona nogo naaki-na rikirane wae keda mea epea. Aa medame nipu mone kanalo omeme pi kone wae narataliare nipu epe-rupa piralia. ");
INSERT INTO kew_vpl VALUES ("PR15_28","021_15_28","PRO","15","28","28","Epe redepone aame kone aba waru niminaawa aa medana agaa orope abuta. Go yapare wae aa-me agaa aipapulu talo pea raburi nipuna agaa wae luabu pa ta. ");
INSERT INTO kew_vpl VALUES ("PR15_29","021_15_29","PRO","15","29","29","Waeanu peme aanu nimuri Adaa Aa raapu repara nae mopare yolamonea aeme. Goa pua nipumi mo epe redepone aanuna betene teme rubu aane lobapaina pirua waru pagea. ");
INSERT INTO kew_vpl VALUES ("PR15_30","021_15_30","PRO","15","30","30","Neme aa meda adali rabu ini agaa-para esepea raaname omalia-dare epe kone go ida. Epe agaa remaa meda pagali rabu go remaame nena to yogane ora puri mapalalia. ");
INSERT INTO kew_vpl VALUES ("PR15_31","021_15_31","PRO","15","31","31","Aa medame nipu maredepo yatalo palia rabu aane luyapa ina pirua pagaliri nipu epe kone sua makuaali. ");
INSERT INTO kew_vpl VALUES ("PR15_32","021_15_32","PRO","15","32","32","Epe-rupa pirape madaa maredepo-yatalo palimi rabu agaa rasua gimaliare nipuna bipa nipu ma-oyaaya. Goa pea pare aa medame nipu maredepo yatalo pea aana agaa pagoa rataliare gore nipu epealia. Goa pua nipuna kone page lobataboa nipuna makuae yae page epealia. ");
INSERT INTO kew_vpl VALUES ("PR15_33","021_15_33","PRO","15","33","33","Adaa Aa-na rolo-para awalidare epe kone meape porana re go iada. Nena bipa ne narabuniaawa epe pora narataliri gore ne adaa bi mada nameali. ");
INSERT INTO kew_vpl VALUES ("PR16_1","021_16_1","PRO","16","1","1","Niaame oyae meda palima kone ima yaere Adaa Aa-me epe ta-ga pipa tea-da pamina. ");
INSERT INTO kew_vpl VALUES ("PR16_2","021_16_2","PRO","16","2","2","Niaana pema oyae luaburi Gote-na ini agaa mada redepo ta kone ima. Go yapare Adaa Aa nipumi niana kone waru mea ruma adoa rekepua makuaaya. ");
INSERT INTO kew_vpl VALUES ("PR16_3","021_16_3","PRO","16","3","3","Neme yae meda pulalo pali-daare Adaa Aa nipuna ki-nane aba saape. Goa pali rabu nipumi go yaenu luabu ora ma-epealia. ");
INSERT INTO kew_vpl VALUES ("PR16_4","021_16_4","PRO","16","4","4","Adaa Aa-me oyae luabu waria kogono padane padane laatapu kata. Go-rupa agu Adaa Aa-me waea peme aanu page nipumi warisa. Goa pua orope su yaa diayalia rabu nimu koso loa alupaina tea. ");
INSERT INTO kew_vpl VALUES ("PR16_5","021_16_5","PRO","16","5","5","Adaa Aa-me waea pua nimuna bi minasaeme aanu adape ora gime omea. Adaa Aa-me nimi pa pupulupa pi-da natea-ga waru adamina. Dia nimu kedaa waru mea katea. ");
INSERT INTO kew_vpl VALUES ("PR16_6","021_16_6","PRO","16","6","6","Aa medame Adaa Aa mada raana waru omo nipu raapu pogatu piralipiri gore Adaa Aa nipumi go aana wae yae luabu mea rubalia. Aa medame Adaa Aa-na agaa ratua piralia raburi Adaa Aa-me pupitagi naape kone namasalia. Goa pua nipumi oyae luabu kone rugulalia. ");
INSERT INTO kew_vpl VALUES ("PR16_7","021_16_7","PRO","16","7","7","Gore aame mo Adaa Aa nipuna raana omea kone luabu ratua nipuna iaanu raapu epe kone sua piralia-rabu Adaa Aa-me rabamua epe onaa raapu mapiraalia. ");
INSERT INTO kew_vpl VALUES ("PR16_8","021_16_8","PRO","16","8","8","Neme oyae ogesi sa awa Adaa Aa ratulalo pali-ri mo mone akore i mi onaa page rabuawa wae pupitagi no aaya aa page rabunialia. ");
INSERT INTO kew_vpl VALUES ("PR16_9","021_16_9","PRO","16","9","9","Niaana pape yaenu mada kone penaloa pulalo pema pare Adaa Aa nipumi niana pamulalo pema yae adoa maredepo yaaya. ");
INSERT INTO kew_vpl VALUES ("PR16_10","021_16_10","PRO","16","10","10","King pia aa mudumi Adaa Aa-me laketa agaa onaame pagenalo laketa rabu pageme. Koso pagoa mo agaa mea rumape raburi ora epe redepone koso pagoa mea rumaalia. ");
INSERT INTO kew_vpl VALUES ("PR16_11","021_16_11","PRO","16","11","11","Adaa Aa-me oyae waru mua epe-rupa redepoya rumainalo kone raapu kata. Goa pua nimumi onaanu makirari napinalo pea. ");
INSERT INTO kew_vpl VALUES ("PR16_12","021_16_12","PRO","16","12","12","Aa mudu king piame wae pupitagi kone luabu gimoa epe redeponea pinalo peme. Gore mo gavman pimi aanumi epea palimi raburi nimu puri mua epe-rupa pitimi. ");
INSERT INTO kew_vpl VALUES ("PR16_13","021_16_13","PRO","16","13","13","King nipumi ora agaa ria-teme onaa raaname omea. ");
INSERT INTO kew_vpl VALUES ("PR16_14","021_16_14","PRO","16","14","14","King nipumi aa meda raatu yawaliare go aa nipu tumaomalia. Go yapare aa meda nipu epe kone i yaliare mo king nipu epe kone mealia rabu lo robaa maepealia. ");
INSERT INTO kew_vpl VALUES ("PR16_15","021_16_15","PRO","16","15","15","Gore king nipumi aa meda epe lo rabaa kaloa epea palia-re nipumi epe kone sua go aa epe-rupa mapiraalia. King-na peare yaa madaa i yai lopoa suamaa ope-yaenu eta kata-rupa mada pea. ");
INSERT INTO kew_vpl VALUES ("PR16_16","021_16_16","PRO","16","16","16","Neme epe kone makuae yae luabu mealiri gol-para silva go yaenu luabu ora rabuaniaye. ");
INSERT INTO kew_vpl VALUES ("PR16_17","021_16_17","PRO","16","17","17","Epe onaanumi wae yae ratape gimoa waru adoa pameme. Aa medame nipuna pora waru adoa epe-rupa pamualiare nipu ora epe-rupa piralia. ");
INSERT INTO kew_vpl VALUES ("PR16_18","021_16_18","PRO","16","18","18","Wae pupitagi noa nena bi minasaawa ne apiyapa te-daare ne wae-rupa malopaalia. ");
INSERT INTO kew_vpl VALUES ("PR16_19","021_16_19","PRO","16","19","19","Gore aa meda nipuna bipa nipu naara kone sua nipuna bi rabuaniaawa pitiare pupitagi ne aanuna raana meme kone page rabuaaya. ");
INSERT INTO kew_vpl VALUES ("PR16_20","021_16_20","PRO","16","20","20","Aa medame ne mana-teade agaa waru aina madu pagoa piraliare ne epe-rupa pirali. Aa medame Adaa Aa madaa kone rulaliare nipu raana adaa mealia. ");
INSERT INTO kew_vpl VALUES ("PR16_21","021_16_21","PRO","16","21","21","Aa numi makuaeme. Aa meda nipumi epe kone waru makuaalia-re mo teme agaa waru ruma adalia. Gore nipumi epe kone sua agaa epe-rupa ne aa yaliare aanu luabumi nipuna agaa pagolalo raana waru omalimi. ");
INSERT INTO kew_vpl VALUES ("PR16_22","021_16_22","PRO","16","22","22","Gore aa meda nipu epe kone i yaliare go aa nipu ipa laipi kagaa pirape yae mua piri aa-rupa piralia. Wae kone imi aanu-ri nimuna go pemeame wae maeyae aa piralia. Goa pua nipuna bipa nipu ma-oyaalia. ");
INSERT INTO kew_vpl VALUES ("PR16_23","021_16_23","PRO","16","23","23","Epe kone i aa nipumi kone aba rumaawa epe kumapi agaa orope teme. Goa pea-pulu nipuna agaa pagolalo raana waru omoa pageme. ");
INSERT INTO kew_vpl VALUES ("PR16_24","021_16_24","PRO","16","24","24","Epe agaa-re ora epe redepi alubi apaa-para mena midi-lapome adea. Nipu ora rede waru pua onaa luabu puri kata. ");
INSERT INTO kew_vpl VALUES ("PR16_25","021_16_25","PRO","16","25","25","Aa medalomame nimuna pema yae luabu epeta kone sua pora pameme pare ota. Goa pama-pama puare orope nimu omalimi. ");
INSERT INTO kew_vpl VALUES ("PR16_26","021_16_26","PRO","16","26","26","Kogono peme nakinumi makuaeme. Nimu kogono waru na palimare nimu eta diayalia kone sua kogono waru peme. ");
INSERT INTO kew_vpl VALUES ("PR16_27","021_16_27","PRO","16","27","27","Wae au peme onaa luabu maoya tulalo pora rado rado asapeme. Nipuna agaare repena sulaa ralae nona pua mo onaa luabu ma-oyaawa rabea. ");
INSERT INTO kew_vpl VALUES ("PR16_28","021_16_28","PRO","16","28","28","Waea pi aame-re onaana rikiraane wae bomo agaa mea lopawa nimu yada-yada waru mapaya. Makirae agaa-ta aame nipuna adami aanu raapu yada makepeaawa rugulala paya. ");
INSERT INTO kew_vpl VALUES ("PR16_29","021_16_29","PRO","16","29","29","Yadapi aa-mere nipuna adapi aa omeme pua wae pora-para yola pea. ");
INSERT INTO kew_vpl VALUES ("PR16_30","021_16_30","PRO","16","30","30","Aa medame aa meda-para ini adupi adupi paliare neme mada makuali mo aa nipumi waea pulalo pea. Aa meda nipu agaa na-teare nipumi waea pulalo pea. Gore mo nipuna ratu yawe kone muboa waea pulalo pea. ");
INSERT INTO kew_vpl VALUES ("PR16_31","021_16_31","PRO","16","31","31","Yomagae nimuna kama iri adoa nimumi aba makuaeme. Go yomagae aanu nimumi ora epe kone su epe pora rateme-pulu go kone mada kamaa aya kone-imi. Goa kone imi rabu nimu adaa bi meme. ");
INSERT INTO kew_vpl VALUES ("PR16_32","021_16_32","PRO","16","32","32","Ratu ora aipapulu nayawea aamere nipu epe kone sua pea. Go konere puri paloa yada wini peme-rupa mada. Aa medame nipuna bipa nipu waru surubaliare ada kagure meda yada naminabaeme-rupa mada pea. ");
INSERT INTO kew_vpl VALUES ("PR16_33","021_16_33","PRO","16","33","33","Kaasa saadu teme aanu-miri akea palua pae loa kone aba meme. Go yapare Adaa Aa nipumi nimuna kaasa saadu pemeare nimuna imi kone-rupa abuta. ");
INSERT INTO kew_vpl VALUES ("PR17_1","021_17_1","PRO","17","1","1","Aa medame nipuna ona naaki nogonu raapu lo-robaa padane sua piralimiri nimumi eta ragota page pa salimi. Go-me mo adaa eta yawo neme onaa-me pemea page rabuniaya. ");
INSERT INTO kew_vpl VALUES ("PR17_2","021_17_2","PRO","17","2","2","Gore kogono naaki medame epe kone sua kogono palia rabu nipuna surube aana si-rupa piralia. Mo surube-aana wae naaki nipu mo kogono naaki-na rolo-para piralia. Goa pua mo surube aa omalia rabu oyae nipuna nogo naaki ruru raapu rumaalimi. ");
INSERT INTO kew_vpl VALUES ("PR17_3","021_17_3","PRO","17","3","3","Adaa Aa-me niaa wae aa yapae epe aa yapae loa rumaa adolalo pea. Gore golo silva yapame adolalo repena egaa-para iritimide-rupa niaa epeta pae ota pae lo adolalo pea. ");
INSERT INTO kew_vpl VALUES ("PR17_4","021_17_4","PRO","17","4","4","Wae agaa lo ipa awaalae agaa teme aanu nimumi mo nimuna wae agaa lape mada aane luyapainaloa waru pageme. ");
INSERT INTO kew_vpl VALUES ("PR17_5","021_17_5","PRO","17","5","5","Gote-me onaa raayo warisa. Aa medalomame naara aanu-para ero loa wae agaa temere nimumi Gote-para teme. Aa medame aa yago medana kedaa rialia rabu raname omalia-dare go paliade pedome nipuna bipa nipu wae yoto mealia. ");
INSERT INTO kew_vpl VALUES ("PR17_6","021_17_6","PRO","17","6","6","Aa meda nipu ogae yalia pare nipuna akuaa naaki-nu piralimiri raana waru omalia. Gore akolo ya? Gomere nimu adaa bi kata rabu nogo naakimi nimuna agi aaraanu raname omeme. ");
INSERT INTO kew_vpl VALUES ("PR17_7","021_17_7","PRO","17","7","7","Epe kone sua agaa temere kone na-i aanuna agaa-rupada nateme. Ora agaa riaare yaa agaa teme aanuna agaada dia. ");
INSERT INTO kew_vpl VALUES ("PR17_8","021_17_8","PRO","17","8","8","Omeme pua waea pape madaa aa medalomame mone oyae meme pare nipumi aba adea. Go monere ona rakia nonapiane meapa yana kone sua nipuna raana epea-rupa ratea. ");
INSERT INTO kew_vpl VALUES ("PR17_9","021_17_9","PRO","17","9","9","Aa medame nipuna adami aanu raapu epe-rupa pirano kone saliare nipumi aba pisade pupitagi pename namea salia. Aa medame aba pisade wae yaenu madaa agaa pamu teare mo aa nipu ratu yawalia. ");
INSERT INTO kew_vpl VALUES ("PR17_10","021_17_10","PRO","17","10","10","Neme epe kone i aa meda raapu agaa maredo yaatalo palipiri agaa rana padane te rabu nipumi makuae yae aipapulu mealia. Go yapare neme wae kone i aa maredepo yatalo pali-dare nipu kalaipu ma-epeali. Goa pali pare nipuna kone aipapulu na-epealia. ");
INSERT INTO kew_vpl VALUES ("PR17_11","021_17_11","PRO","17","11","11","Waea pi aame-re yada papena agaa agu marekaaya. Goa pea rabu wae aa meda ipua nipu radaa waru pina talia. ");
INSERT INTO kew_vpl VALUES ("PR17_12","021_17_12","PRO","17","12","12","Neme mena-beana si ripina mua mea epali rabu kiraa mena nipu poraania madaaliri ne epaa tu naalia-rabu adaa radaa nali. Goa palia pare aa meda epe kone nasua waea pulalo pea aa poraa adali rabu ne tu-nalia. ");
INSERT INTO kew_vpl VALUES ("PR17_13","021_17_13","PRO","17","13","13","Gore nimumi aa meda epea pulalo paliri go aame wala wae yaeme abutea rabu oro yalo nipuna onaa nogo naaki luabu wae-rupa pirualimi. ");
INSERT INTO kew_vpl VALUES ("PR17_14","021_17_14","PRO","17","14","14","Aa medame ratu yawe kone marekaliare ipa naaku robo sua ipa popenaloa poaya-rupa mada. Goa palia-dare nipu gimoa waea naepalia rabu epealia. ");
INSERT INTO kew_vpl VALUES ("PR17_15","021_17_15","PRO","17","15","15","Adaa Aa-me go kone laapo gimi omea. Pupitagi ne aa pa pirina teme page waeanu napi aa madaa pama kedaa mea kateme page gimea. ");
INSERT INTO kew_vpl VALUES ("PR17_16","021_17_16","PRO","17","16","16","Naaki meda epe kone nasaliare nipuna aalu waeame regepe ta-pulu nipu makuae yae mada namealia. Gore mo aana alu regepetaga sukulu kabape mone wala akolo mea epenaya? ");
INSERT INTO kew_vpl VALUES ("PR17_17","021_17_17","PRO","17","17","17","Niaana adami aanumi oro yalo niaa raaname omeme. Goa pua kedaa ritima rabu niaana kedaa rabamu ritalo nimumi managola pimi. ");
INSERT INTO kew_vpl VALUES ("PR17_18","021_17_18","PRO","17","18","18","Kone waru na-i aanumi aa medana yago nimumi abulalima loa nimumi mada na-abulape yapare pama yaa agaa teme. ");
INSERT INTO kew_vpl VALUES ("PR17_19","021_17_19","PRO","17","19","19","Waea pape madaa raaname omea aamere wala yada pape madaa raana omo yada marekaaya. Go page aa medame nipuna bi minasaaliare go aa nipuna bipa nipu omape yae asapea. ");
INSERT INTO kew_vpl VALUES ("PR17_20","021_17_20","PRO","17","20","20","Aa medame oro yalo wae kone su wae agaa agu teare nipu oro yalo epe-rupa mada napitia. Dia nipu wae-rupa agu pirualia. ");
INSERT INTO kew_vpl VALUES ("PR17_21","021_17_21","PRO","17","21","21","Aa medana simi epe kone nasaliare oro yalo aaraa nipu lo-robaa keda mu aalia. ");
INSERT INTO kew_vpl VALUES ("PR17_22","021_17_22","PRO","17","22","22","Lo robaa kuma pua raana piamere marasini noa epe-rupa pimi-rupa mada pia. Go yapare aa meda nipuna kone oyaliare wae yainame mo aa nipu ripinalia rabu uni-para yaina aawa maadapalia. ");
INSERT INTO kew_vpl VALUES ("PR17_23","021_17_23","PRO","17","23","23","Waea pi aa nipu koso pagape yapidi medame pa laga taliare omeme pua kabe reke mua koso maoyaalia. Goa pua nipumi mo koso ma-oyaatalo mone mua raaname waru omalia. ");
INSERT INTO kew_vpl VALUES ("PR17_24","021_17_24","PRO","17","24","24","Waru makuae aamere epe kone page epe pora waru ratea-pulu nipumi makuaya. Go yapare waea aame epe kone naia-pulu oyae rado rado luabu pamu yota. ");
INSERT INTO kew_vpl VALUES ("PR17_25","021_17_25","PRO","17","25","25","Aame wae maeyae kone rataliare go naakina agi aaraame lo robaa kedaa adaa mua nimuna kone-para oyalia. ");
INSERT INTO kew_vpl VALUES ("PR17_26","021_17_26","PRO","17","26","26","Koso epe-rupa ta aa-para koso kabena temere gore naepeta. Aa mudunumi epea palaina nimu wala aipuyaame talimiri gore naepeta. ");
INSERT INTO kew_vpl VALUES ("PR17_27","021_17_27","PRO","17","27","27","Makuae yae waru mea aamere nipu agaa bebo nata. Epe kone i aamere aipapulu ratu yawape page gimea. ");
INSERT INTO kew_vpl VALUES ("PR17_28","021_17_28","PRO","17","28","28","Epe kone na-i aamere agaa loralia. Go rabu onaame go aare epe kone waru-i aa-yana kone salimi. ");
INSERT INTO kew_vpl VALUES ("PR18_1","021_18_1","PRO","18","1","1","Aa padane nipu ode aawaliare nipuna bipa nipuna agu raapo kone-sua awalia. Aa medaloma nimu epe redepone kone imi page pinawa kone ia. ");
INSERT INTO kew_vpl VALUES ("PR18_2","021_18_2","PRO","18","2","2","Epe kone nasu epea napea aamere mo epe pora epe kone meapere gimi omea. Goa pua nipumi wae pupitagi pape pora ratuaya. ");
INSERT INTO kew_vpl VALUES ("PR18_3","021_18_3","PRO","18","3","3","Waea puaaya aamere aa yago medalomare naepe ta-ga pinawa kone ia. Goa pua nimuna bi ma-oyaawa nimu yalaa waru ma-paaya. ");
INSERT INTO kew_vpl VALUES ("PR18_4","021_18_4","PRO","18","4","4","Epe kone i aame agaa tea rabu nipuna-ta agaa mada epe kone mealimiri go agaa epeta-da pageme. Gore ipa naaku-para rubini popaa koyapape peade-rupa mada pea. ");
INSERT INTO kew_vpl VALUES ("PR18_5","021_18_5","PRO","18","5","5","Aa meda wae pupitagi noa koso madaa aaliare go aana koso rabamu laata ne napope. Gore mo aa nipu koso mada nawini pina rabuaatape. ");
INSERT INTO kew_vpl VALUES ("PR18_6","021_18_6","PRO","18","6","6","Epe kone na-i aamere pa onaa raapu yada agu pulalo pea. Goa pua nipuna agaa pageme rabu otada nipu page tulalo peme. ");
INSERT INTO kew_vpl VALUES ("PR18_7","021_18_7","PRO","18","7","7","Kone waru na-i aa medame agaa tea-dare nipuna go agaame nipu ma-oyaaya. Gore nipuna maa-para yapa-lokena pogaa mada sua maraawa nipu omalia. ");
INSERT INTO kew_vpl VALUES ("PR18_8","021_18_8","PRO","18","8","8","Aa medana maa agaa paema rabu go agaa pagape madaa raaname waru omeme. Go agaare epe redepi-rupa meda yapulu aipapulu pagoa eta mada mea neme. ");
INSERT INTO kew_vpl VALUES ("PR18_9","021_18_9","PRO","18","9","9","Wae kiaa rakepene aare nimuna bipa nipu ma-oyaya. Goa pua nimu kiaa rakepea wae-rupa pimi. ");
INSERT INTO kew_vpl VALUES ("PR18_10","021_18_10","PRO","18","10","10","Adaa Aa-re puri pabe ada-rupa aaya. Epe redepone aanu nimu go adapara aloma puaa gopara pua piruaeme. ");
INSERT INTO kew_vpl VALUES ("PR18_11","021_18_11","PRO","18","11","11","Amone aanu nimuna moneme nimu kutapua ora epe-rupa surubalia kone imi. Mo ada kagure puri-palo aya-rupa mada kone imi. ");
INSERT INTO kew_vpl VALUES ("PR18_12","021_18_12","PRO","18","12","12","Gore aa meda nipu pupitagi noa nipuna bi minasaliare orope nipu oyalia. Nena bipa ne rabu aniawa epe pora narataliri ne epe adaa bi mada nameali. ");
INSERT INTO kew_vpl VALUES ("PR18_13","021_18_13","PRO","18","13","13","Aane waru lobapaina pirua agaa aba waru pagoa orope agaa abulape. Neme goa napaliri wae maeyae kone sua pe-pulu orope ne yala pote. ");
INSERT INTO kew_vpl VALUES ("PR18_14","021_18_14","PRO","18","14","14","Aa meda nipu yaina omoa yapare kone puri paboa piraliare go yaina mada perekealia. Mo aa nipuna kone oyaliare go aa nipuna kone wala akepua ma-epeaalia pae? ");
INSERT INTO kew_vpl VALUES ("PR18_15","021_18_15","PRO","18","15","15","Aa meda nipumi epe kone sua nipumi oyae rado rado waru makuaatalo pea yae luabu waru makuaaya. Go page aa medame agaa mana teme rabu nipumi aane lobapa ina pirua mogo agaa rayo waru pagea. ");
INSERT INTO kew_vpl VALUES ("PR18_16","021_18_16","PRO","18","16","16","Gore neme adaa aa meda raapu agaa talo pali-daare neme nipu pa ode kalape yae meda aba ripinape. Goa pali raburi neme nipu mada adali. ");
INSERT INTO kew_vpl VALUES ("PR18_17","021_18_17","PRO","18","17","17","Aa meda nipu kosona ini-agaa madaa aawa agaa teare nipu koso wini pape nonapiaene agaa tea. Go yapare pa aa meda agaa waru maredepo yainalo agaa mealia-dare go koso apimi wini palia palo marea. ");
INSERT INTO kew_vpl VALUES ("PR18_18","021_18_18","PRO","18","18","18","Aa laapona rikiraane koso aapimi ora wini palialo abi nalapaeme raburi apimi wini palia pala marea teme. ");
INSERT INTO kew_vpl VALUES ("PR18_19","021_18_19","PRO","18","19","19","Nena ame meda wae kone saliri nipumi go kone mea rogasua ne raaname na-omalia. Gore onaa medalome mo ada kagurena pora gape poaeme-rupa mada nimu runane pope-rupa maralimi. Gore mo aa lapo nipu yada pape agaa loa ki namealipi. Nipuna lo robaa padane-para mada nasalipi. Adaa poragape garulaawa aana kerepo pora rugutade-rupa mada. Goa palipi-pulu nipu ada runane mada napalia. ");
INSERT INTO kew_vpl VALUES ("PR18_20","021_18_20","PRO","18","20","20","Neme agaa epe-rupa loa redepone-rupa te rabu nena lo robaa-para raana waru palia. ");
INSERT INTO kew_vpl VALUES ("PR18_21","021_18_21","PRO","18","21","21","Nena tede agaame onaa epe-rupa mapiraali. Nena agaame agu onaa ma-oyaawa onaa maepeaalia. Goa pe-pulu neme epe agaa lape madaa raname omalimi ne epe-rupa mada pirali. ");
INSERT INTO kew_vpl VALUES ("PR18_22","021_18_22","PRO","18","22","22","Neme ona meda rumali-daare gore ora epealia. Goa paliri Gote-me page lo robaa gua epeta kone salia. ");
INSERT INTO kew_vpl VALUES ("PR18_23","021_18_23","PRO","18","23","23","Naraame amope oyae pawa agaa mea. Go yapare aamaame agaa puri palo loa abuta. ");
INSERT INTO kew_vpl VALUES ("PR18_24","021_18_24","PRO","18","24","24","Gore aa meda nipuna adami aa adaapu aaliare go aa nipu oyalia. Go yapare aa meda nipuna adami aa ora epe rado piaene meda alipiri go aa lapo nipu lo rabaa waru sua nipu lapo ameaya-rupa alipi. ");
INSERT INTO kew_vpl VALUES ("PR19_1","021_19_1","PRO","19","1","1","Aa meda nipu oyae rudu yaliare nipu redepone aa yapulu yaa agaa loa wae pora pami aa rabuaniaaya. ");
INSERT INTO kew_vpl VALUES ("PR19_2","021_19_2","PRO","19","2","2","Aa meda nipumi papea namakuaawa yapare pama kalaipu kogono paliare ini namadiaalia. Aa medame kogono aipapulu palia pare go kogono ora epe-rupa mada napalia. ");
INSERT INTO kew_vpl VALUES ("PR19_3","021_19_3","PRO","19","3","3","Gore onaa luabumi nimuna bipa waea pua nimumi Adaa Aa kedaa kaloa wala ratu yaweme. ");
INSERT INTO kew_vpl VALUES ("PR19_4","021_19_4","PRO","19","4","4","Aa meda nipu mone adaapu saliare nipuna adami aa page adaapu aalimi. Go yapare aa meda nipu mone nasaliare mo nipuna adami aanu adapu napitimi. ");
INSERT INTO kew_vpl VALUES ("PR19_5","021_19_5","PRO","19","5","5","Gore aa medame yaa agaa loa koso teare nipumi wae yoto mealia. Goa palia rabu nipu mada napogla palia. ");
INSERT INTO kew_vpl VALUES ("PR19_6","021_19_6","PRO","19","6","6","Gore aa adaapumi aa mudu pimi aanu omeme waru peme. Goa pua nipumi nimu raana omenalo. Oyae pama kane aanu raana omoa go aa nipuna adami aa kone imi. ");
INSERT INTO kew_vpl VALUES ("PR19_7","021_19_7","PRO","19","7","7","Gore aa medaa nipu oyae diayalia rabu nipuna amenume page go aa gimeme. Goa peme rabu nipuna adami aanumi page mo aa maasa rilaawa gimeme. Nipu repara omeme-pi agaa-ta pare nipuna agaa ini namadini pa rasatapa ia. ");
INSERT INTO kew_vpl VALUES ("PR19_8","021_19_8","PRO","19","8","8","Aame nipuna bipa epe-rupa piralua kone suare epe pora-para makuae yae mulalo puri waru paloa epe kone meape madaa kogono palia. Aame makuae yae mua epe konena pora rataliare nipuna epe-rupa pirape yae mua epe-rupa piralia. ");
INSERT INTO kew_vpl VALUES ("PR19_9","021_19_9","PRO","19","9","9","Go yapare aa medame koso loa yaa agaa tea-daare nipuna tea yaa agaa mada wae yoto ora mealia. Go piaene yaa agaa ne aare tumaomalimi. ");
INSERT INTO kew_vpl VALUES ("PR19_10","021_19_10","PRO","19","10","10","Epe kone na-ia aa nipumi mone oyaenu adaapu su aayare na-epeta. Naara piri kogono naakimi mo aa mudu wala surubea page ora rado yade. ");
INSERT INTO kew_vpl VALUES ("PR19_11","021_19_11","PRO","19","11","11","Epe kone i aa nipumi kone gupa ia. Nipu epe kone ia-pulu ratu ratu yawape kone aipapulu naia. Goa pua aa medame nipu-para waea pea page gimea. ");
INSERT INTO kew_vpl VALUES ("PR19_12","021_19_12","PRO","19","12","12","Gore mena kiraa-me e waru loa aa mudu king pia aa ratu waru yawea. Go yapare ratu yawe onaa rabamulalo paliare yai ipua maapu-para eta naape yae ma-opaaya-rupa mada palia. ");
INSERT INTO kew_vpl VALUES ("PR19_13","021_19_13","PRO","19","13","13","Naaki meda nipu epe kone nasaliare go naakimi nipuna aaraa kedaa waru mea kata. Gore aa medana oreme ratu yawoa agaa adaapu loaliare nipuna ada runane itipata pabea-rupa tea. ");
INSERT INTO kew_vpl VALUES ("PR19_14","021_19_14","PRO","19","14","14","Niaana aama aapanumi mone oyaenu rumaa gialimi pare Gote nipumi epe kone i ona mea gialia. ");
INSERT INTO kew_vpl VALUES ("PR19_15","021_19_15","PRO","19","15","15","Kiaa rakepene aanu nimu oro yalo pama piruaawa reaeme omoa u keme waru loa patala pu aaeme. ");
INSERT INTO kew_vpl VALUES ("PR19_16","021_19_16","PRO","19","16","16","Aame Gote-na pora ratua epe-rupa pitiare naoyalia pare nipu ora epe-rupa piralia. Go yapare aame Gote-na epe kone madaa masa rilaawa waea-nu paliare nipu omalia. ");
INSERT INTO kew_vpl VALUES ("PR19_17","021_19_17","PRO","19","17","17","Gore neme aa naara meda odome-omoa oyae katalo pali-daare mo Adaa Aame ne madaa rudu ainalo pe. Goa pali-daare orope Adaa Aa-me nena rudu go abutea. ");
INSERT INTO kew_vpl VALUES ("PR19_18","021_19_18","PRO","19","18","18","Gore nena naakimi waea pua pupitagi naliare neme nena naaki mana lape. Mana te raburi nipumi epe pora ratalia. Go yapare neme mana lake pupitagi pa nalaaina gimaliri gore nena naaki riaa omenawa kone sua pe. ");
INSERT INTO kew_vpl VALUES ("PR19_19","021_19_19","PRO","19","19","19","Gore aa medame rono omoa nipumi waea paliare nipuna go wae yaena yoto mulalo pea. Go yapare neme nipu rabamua nipuna kedaa mea riali-dare wala orope page nipu rabameaina kone agu sua palia. ");
INSERT INTO kew_vpl VALUES ("PR19_20","021_19_20","PRO","19","20","20","Go yapare aa medame ne maredepo yawoa epe kone gina kone sali-dare orope ne epe kone waru meali. ");
INSERT INTO kew_vpl VALUES ("PR19_21","021_19_21","PRO","19","21","21","Aame kone adaa pua sua oyae adaapu palua kone ia pare Adaa Aa-me pina kone ia-rupa luabu mada palia. ");
INSERT INTO kew_vpl VALUES ("PR19_22","021_19_22","PRO","19","22","22","Aanumi goa loa lo rogaa i agaa madaa puri palo aaeme. Gore naraa aa apere ota pare pa epeta. Go aa epe-yaliare mo yaa agaa ne aa ora rabuniaaya. ");
INSERT INTO kew_vpl VALUES ("PR19_23","021_19_23","PRO","19","23","23","Ne Adaa Aa-na rolo-para piralidare ne epe-rupa pirape yae mea gialia. Goa palia rabu ne madaa wae yae meda na-epalia rabu ne oro yalo epe-rupa mada pirali. ");
INSERT INTO kew_vpl VALUES ("PR19_24","021_19_24","PRO","19","24","24","Kiaa raakepene aa nipu ki arota-para pagoa pa pirualiare mo eta yawo i meape yala potea. Go page kimi musaawa eta mea nape page yala potea. ");
INSERT INTO kew_vpl VALUES ("PR19_25","021_19_25","PRO","19","25","25","Wae pupitagi ne aa aipuyame tali-daare kone waru na-i aame adoa mada makuaalia. Goa palimi rabu epe kone aba ratua palia. Go yapare neme epe kone sua aae aanu maredepo yali rabu nimuna makuae yae ora madaa popalia. ");
INSERT INTO kew_vpl VALUES ("PR19_26","021_19_26","PRO","19","26","26","Naakimi aara ratu yawoa nipuna agi ada-para pane rata saliare mo nipuna onaa nogo naaki rayo yala mea kataa. ");
INSERT INTO kew_vpl VALUES ("PR19_27","021_19_27","PRO","19","27","27","Naaki neme epe agaa waru gimaliri kone nai pa maeyae aanuna kone ratua ali. ");
INSERT INTO kew_vpl VALUES ("PR19_28","021_19_28","PRO","19","28","28","Waea-pi aame koso witnes pulalo epaliri go aa nipumi mo koso ma-oyapena epea. Go aa nipu mada waea luabu rubita. ");
INSERT INTO kew_vpl VALUES ("PR19_29","021_19_29","PRO","19","29","29","Wae agaa lo wae pora pameme aanuri nimu wae yoto mealimi. Goa pua wae pora ratua pupitagi neme aanu nimu aipayame kudu talia. ");
INSERT INTO kew_vpl VALUES ("PR20_1","021_20_1","PRO","20","1","1","Aa-me ipa bia adaapu noa wae agaa adaapu lo yada marekaawa agaa adaapu tea. Goa pua mo ipa biame nipu surubena teare epe kone nasalia. ");
INSERT INTO kew_vpl VALUES ("PR20_2","021_20_2","PRO","20","2","2","Aa mudu king nipumi ratu yawoa puri pane agaa ta rabu onaa paala ma-saaya. Gore mo kiraa mena laiyono-me buai ta-rupa mada king-mi goa pea. King nipu raatu mayawaaliri nena kagaa piraama lama pope kone wasupa alupalia. ");
INSERT INTO kew_vpl VALUES ("PR20_3","021_20_3","PRO","20","3","3","Aa medame yada pape kone gimaliare nipu epe bi mealia. Go yapare epe kone na-i aamere oro-yalo yada pape agaa agu loaalia. ");
INSERT INTO kew_vpl VALUES ("PR20_4","021_20_4","PRO","20","4","4","Kiaa rakepene aame eta wai poape yapi di rabu maapu su naweare kiaa rakepe pea. Eta naape yapidi rabu naape awolalo pea pare nipu e napoae aame maapu-para pama asapula pea. ");
INSERT INTO kew_vpl VALUES ("PR20_5","021_20_5","PRO","20","5","5","Aa-na konere ipa ini adaa naaku piade-rupa mada yade. Aa meda kone waru makuae aa yaliare go kone ora so mada popea. ");
INSERT INTO kew_vpl VALUES ("PR20_6","021_20_6","PRO","20","6","6","Aa adaapumi nimuna adami onaa raaname omema lo gupa teme. Go yapare aa medana adami aanuri padane padane laatapu aalimi. ");
INSERT INTO kew_vpl VALUES ("PR20_7","021_20_7","PRO","20","7","7","Gore aaraa ora epe kone sua epe pora ritua piralia rabu nipuna sinumi raana omalimi. ");
INSERT INTO kew_vpl VALUES ("PR20_8","021_20_8","PRO","20","8","8","Gore aa mudu king nipumi koso pagolalo pea raburi mo kaso ta epeme aanuna kone waru adoa rumaaya. ");
INSERT INTO kew_vpl VALUES ("PR20_9","021_20_9","PRO","20","9","9","Niri Gote-na ini-agaa mada ora epe redepone aa awayolo aapimi mada tea pae? Goa pua neme wae yae meda napawa teme? ");
INSERT INTO kew_vpl VALUES ("PR20_10","021_20_10","PRO","20","10","10","Onaanumi oyae kabenalo pare aa medame makirae agaa tea-daare Adaa Aa-me go kone adoa rumaamina. ");
INSERT INTO kew_vpl VALUES ("PR20_11","021_20_11","PRO","20","11","11","Niaame naakinu aba adoa rumaema nipu epe naaki nipu wae naaki lo. Go rupa agure niaana naakanuri aba adoa makuaema. ");
INSERT INTO kew_vpl VALUES ("PR20_12","021_20_12","PRO","20","12","12","Adaa Aa-me niaana ini mariayare oyae adamonalo pisa aane ma-saare agaa pagomonalo pisa-ga waru adamina. ");
INSERT INTO kew_vpl VALUES ("PR20_13","021_20_13","PRO","20","13","13","Ne oro yalo u-pati aa yaliare mone oyae diayalia rabu naara pirali. Go yapare ne aipapulu rekoa kogono pali-dare nena maapu-para eta oyae adaapu sali. ");
INSERT INTO kew_vpl VALUES ("PR20_14","021_20_14","PRO","20","14","14","Aa meda oyae kabolalo pea pare mo yaena yoto ora adaa pea rabu nipumi agaa adaapu ta. Mo yae aba kaboria pua nipuna adami aanu-para gupa pua ta. Go yaere mone ogesi pe yae meda kaboa mea ipulu ta. ");
INSERT INTO kew_vpl VALUES ("PR20_15","021_20_15","PRO","20","15","15","Epe kone imi onaana agaa teme raburi pa aa medalomana golo rabuaeme. ");
INSERT INTO kew_vpl VALUES ("PR20_16","021_20_16","PRO","20","16","16","Gore aa medana yago nipumi pa aa medana rudu abulalua agaa loa yapare wala na-abuteadaare waea pea. Gore nipumi epea go napea-daa. Gore aa-me go piaene agaa meda teadare neme oyae meda mo rudu abune nona pina ora meape. ");
INSERT INTO kew_vpl VALUES ("PR20_17","021_20_17","PRO","20","17","17","Yaa agaa loa mua ne etanuri rede pi eta meda kone i pare oropere go paake ne etare wae yae yana kone sali. Go mea ne etare nena agaa peto-para ipa mu-rupa kilulu tea. ");
INSERT INTO kew_vpl VALUES ("PR20_18","021_20_18","PRO","20","18","18","Neme epe kone aba mealiri orope nena palide kogono epealia. Nena yada-lore aa raapu yada pulalo pali-daare neme yada akepu palua palo kone waru niminaawa pape. ");
INSERT INTO kew_vpl VALUES ("PR20_19","021_20_19","PRO","20","19","19","Aa meda yago mada maa agaa pawa yaa agaa ne aa raapu ne ada mua naape. Goa pua neme kudiripi agaa meda lakete rabu wala mo aa meda pua lakeloa laame tea. Aa go-rupa teadare gipia. ");
INSERT INTO kew_vpl VALUES ("PR20_20","021_20_20","PRO","20","20","20","Aa medame agi aaraanu wae agaa teare go aa nipu ora omalia. Gore laba ribaane-para udinita-rupa mada palia. ");
INSERT INTO kew_vpl VALUES ("PR20_21","021_20_21","PRO","20","21","21","Aa medame agi aaraa lapo pa pirina nipuna moae luabu aba mealiare go oyae luabu epe-rupa mada nasalia. ");
INSERT INTO kew_vpl VALUES ("PR20_22","021_20_22","PRO","20","22","22","Aa medame ne-para wae paliare neme nipuna wae-yae abi na-abulape. Dia Adaa Aa-me ne raba mealiaga nipu kone rulape. Goa paliri rabu nena kedaa luabu diayalia. ");
INSERT INTO kew_vpl VALUES ("PR20_23","021_20_23","PRO","20","23","23","Aame oyae kabenalo ruma sua yaa agaa tere Adaa Aa-me go mada raaname naomea. ");
INSERT INTO kew_vpl VALUES ("PR20_24","021_20_24","PRO","20","24","24","Adaa Aa-me pora luabu niaa go su-amaa pa piramona aba maredepoya saaya. Go pora-re aapara pea palo niaa akepua mada makualiama yae? ");
INSERT INTO kew_vpl VALUES ("PR20_25","021_20_25","PRO","20","25","25","Adaa Aa nipu Gote opa kalape yaere kone aba maarekawa sape. Neme go opa kaloa aipapu te pare wala orope kone adaapu sali. Neme goa pali-dare nena bipa ne go mabebolaeyae. ");
INSERT INTO kew_vpl VALUES ("PR20_26","021_20_26","PRO","20","26","26","Epe aa mudu king-mi waea peme onaana koso pagoa nimuna wae-yae adoa rumalia. Goa pua nimu keda waru katea. ");
INSERT INTO kew_vpl VALUES ("PR20_27","021_20_27","PRO","20","27","27","Niana kone wasupa Adaa Aa-me gisare wae oyae waru adoa rumaawa piramonalo laba paa-rupa niaa madaa mapirasa. Gore epe yae gore wae yae lo mada rumawa ado kiritalima. ");
INSERT INTO kew_vpl VALUES ("PR20_28","021_20_28","PRO","20","28","28","Go yapare king nipumi nipuna onaanu madaa epea agu pua odome omea. Go paliadaare king nipu epe-rupa pirua nipu ora adaalupu pirualia. ");
INSERT INTO kew_vpl VALUES ("PR20_29","021_20_29","PRO","20","29","29","Niaame ogegeaanuna puri ado epeta kone ima. Goa page yomagaenu kama iri adoa nimu adaa bi kateme. ");
INSERT INTO kew_vpl VALUES ("PR20_30","021_20_30","PRO","20","30","30","Aa medame wae palia rabu neme nipu aipuyame kudu tali rabu nipuna wae yae mada gimalia. Goa pua nipu ora epe aa piralia. ");
INSERT INTO kew_vpl VALUES ("PR21_1","021_21_1","PRO","21","1","1","Adaa Aa-me aa mudu king-na kone maredepo yaaya rabu king aa mudu nipumi Adaa Aa-na raana ratea. Go rabu nipuna epe konere kuba rupara ipa-rupa popea. ");
INSERT INTO kew_vpl VALUES ("PR21_2","021_21_2","PRO","21","2","2","Niaana pema yae luabu ora epeta kone ima pare Adaa Aa nipumi niaana ima kone luabu aba rumaa adea. Goa pua nipumi niaana ima kone raayona re ado-kiritea. ");
INSERT INTO kew_vpl VALUES ("PR21_3","021_21_3","PRO","21","3","3","Niaame epe redepone kone agu ratua Gote nipuna ini agaa madaa epe-rupa piruamina. Goa palima-daare niaame opa katema yaenu page rabuaniaaya. ");
INSERT INTO kew_vpl VALUES ("PR21_4","021_21_4","PRO","21","4","4","Waea peme aanumi aakone sua oro yalo wae pupitagi agu noa waeanu agu pulalo peme. Oro yalo nimuna pirape yae oyoa wae yae rubini onaa pimi. ");
INSERT INTO kew_vpl VALUES ("PR21_5","021_21_5","PRO","21","5","5","Kogono peme aanu nimumi epe kone waru sua kogono peme rabu oyaenu waru adaapu imi. Go yapare kone waru nasua pa aipapulu bebo teme aanu nimu oyae diata yalia rabu wae-rupa pitimi. ");
INSERT INTO kew_vpl VALUES ("PR21_6","021_21_6","PRO","21","6","6","Aa medame yaa agaa loa nipumi mone yoloa mu-aaliare gore nipu omape pora-para go pu aaya-da. Go aa-na saliade oyaere moae aipapulu sua wala esepe tade-rupa mada yalia. ");
INSERT INTO kew_vpl VALUES ("PR21_7","021_21_7","PRO","21","7","7","Waea pi aanu nimumi wala epea meda napeme. Go peme waeame nimu luabu dia yalimi. ");
INSERT INTO kew_vpl VALUES ("PR21_8","021_21_8","PRO","21","8","8","Wae kone i aamere wae pora agu ratea. Go yapare aa medaloma epe kone imi-numiri waea napeme. ");
INSERT INTO kew_vpl VALUES ("PR21_9","021_21_9","PRO","21","9","9","Aa meda nipuna ada gaa-para pawa pirua ona-nogo naki raapu pawa piralia-daare epe ta. Pare nipu agaa wae adaapu ne ona raapu piraliare oyalia. ");
INSERT INTO kew_vpl VALUES ("PR21_10","021_21_10","PRO","21","10","10","Waea pape madaare reaeme omema-rupa mada pea-pulu waea adaapu pape mada aa meda odome naomeme. ");
INSERT INTO kew_vpl VALUES ("PR21_11","021_21_11","PRO","21","11","11","Epe kone naimi aanumi adenalo mo waea pupitagi ne aanu tu adialimiri mo rudu kone sua pimi aanumi adoa epe kone mealimi. Goa pua nimuna makuae yae ora adaa yalia. ");
INSERT INTO kew_vpl VALUES ("PR21_12","021_21_12","PRO","21","12","12","Adaa Aa-na kone ora redepone kone ia. Goa pea-pulu aanumi nimuna ada-para waea peme luabu Adaa Aa nipumi waru adoa makuaaya. Goa peapulu Adaa Aa-me go aanu nimu luabu maoya-talia. ");
INSERT INTO kew_vpl VALUES ("PR21_13","021_21_13","PRO","21","13","13","Naraame-ome aanumi nimu rabaminalo yatemede agaa napagali-miri orope ne yatede agaa mada napagalimi. ");
INSERT INTO kew_vpl VALUES ("PR21_14","021_21_14","PRO","21","14","14","Gore aa medame ne ratu yawaliare neme oyae ode medaloma go aa nipu kalape. Ne kudiri pua ne naadalimi rabu nipuna ratu mada dia yalia. ");
INSERT INTO kew_vpl VALUES ("PR21_15","021_21_15","PRO","21","15","15","Gore onaanumi epe pora ratua epe kone sua koso eperupa peme raburi epe-rupa piri onaame adoa raaname omoa pedo palimi. Mo waea peme onaame goa adoa nimuna lo robaa-para wae kone meme. ");
INSERT INTO kew_vpl VALUES ("PR21_16","021_21_16","PRO","21","16","16","Aa medame epe kone sape gimoalia pare nipu omoa paliare aba omoa puaa pimi onaa raapu puaa piralia. ");
INSERT INTO kew_vpl VALUES ("PR21_17","021_21_17","PRO","21","17","17","Aa medame epe eta noa oro yalo ipa waene noa raaname omo-aaliare nipuna amo dia yalia. ");
INSERT INTO kew_vpl VALUES ("PR21_18","021_21_18","PRO","21","18","18","Epe aanu madaa keda popolalo palia pare wala pereketua mo pupitagi no aeme aanu madaa alopawa popalia. ");
INSERT INTO kew_vpl VALUES ("PR21_19","021_21_19","PRO","21","19","19","Gore aa meda eta oyaenu waru naope-pare awaliare epeanu luabu rabuaaya. Goamere ona ratu yawo agaa adaapu ne onanuna kone page rabuniaaya. ");
INSERT INTO kew_vpl VALUES ("PR21_20","021_21_20","PRO","21","20","20","Epe kone su epe pora ratua piri aana ada-para oyae ora epe-rupa pa su-aaya. Go yapare wae kone su wae pora pameme aanuna oyae diata rabu pa piru-aaeme. ");
INSERT INTO kew_vpl VALUES ("PR21_21","021_21_21","PRO","21","21","21","Go yapare aa medame aa yago raaname waru omoa epe pora rataliare nipu raana rubia adaa bi kateme-pulu epe-rupa piralia. ");
INSERT INTO kew_vpl VALUES ("PR21_22","021_21_22","PRO","21","22","22","Yada yame pi aanu epe kone katea rabu ada kagure meda mada pabo tua winipu mealimi. Aanu nimuna ada kagure pape ora puri pata-pulu nimuna ada kagurena pape mada narasalimi. Mo yada pi aanu yada pula palimi rabu ada kagure pabo tu rubalimi. ");
INSERT INTO kew_vpl VALUES ("PR21_23","021_21_23","PRO","21","23","23","Gore aa medame nipuna agaa-abulu waru suruboa aaliare go aa nipu madaa kedaa meda mada naepalia. ");
INSERT INTO kew_vpl VALUES ("PR21_24","021_21_24","PRO","21","24","24","Wae pupitagi ne aakone su aame waea pua aa yagonu-para page wae agaa teme. Goa pua oro yalo nipuna bi agu minasaatalo pea. ");
INSERT INTO kew_vpl VALUES ("PR21_25","021_21_25","PRO","21","25","25","Kiaa rakepene aa nipu kogono napi pa oyae meape madaa aaya. Goa peapulu nipuna raana omea koneme nipu tumaomalia. ");
INSERT INTO kew_vpl VALUES ("PR21_26","021_21_26","PRO","21","26","26","Kiaa rakepene aame oro yalo oyae pa meape madaa kone su pia. Pare epe kone i aamere nipuna oyae pa aanu katae. ");
INSERT INTO kew_vpl VALUES ("PR21_27","021_21_27","PRO","21","27","27","Adaa Aa-me pupitagi neme aanumi kateme opa re raaname na-omea. Go yapare makirae konena opa epa katemere gore Adaa Aa-me pugu pia kone ia. ");
INSERT INTO kew_vpl VALUES ("PR21_28","021_21_28","PRO","21","28","28","Gore koso-na yaa agaa tere go aa omalia. Go yapare aa medana agaa waru regena pagoa go pi aanumi go aana agaa pagape madaa raana waru omoa pagalimi. ");
INSERT INTO kew_vpl VALUES ("PR21_29","021_21_29","PRO","21","29","29","Waea adaapu peme aanu nimumi epea pema kone sua waea adaapu peme. Goa pea pare epe redepone kone imi aanu nimuna pora pamuapere epena kone imi. ");
INSERT INTO kew_vpl VALUES ("PR21_30","021_21_30","PRO","21","30","30","Pinawa ne ora epe kone makua yae i page epe pora kurua oyae luabu sali pare gomere ne mada naraba mealia. Adaa Aa madaa kone mapirali-dare pora mada pali. ");
INSERT INTO kew_vpl VALUES ("PR21_31","021_21_31","PRO","21","31","31","Gore mo yada-pi aanu nimuna yada pulalo nimuna ose mena maredepo yaawa maaeme. Pare Adaa Aa nipumi go yada-na puri nakateare yada nawini palimi. ");
INSERT INTO kew_vpl VALUES ("PR22_1","021_22_1","PRO","22","1","1","Gore onaame ne ora epe aa kone sua adaa bi gialimi-daare gomere mone oyae adaapu imi aanu page rabuaniaye. ");
INSERT INTO kew_vpl VALUES ("PR22_2","021_22_2","PRO","22","2","2","Adaa Aa-me amo page naara onaa page luabu nipumi warisa. ");
INSERT INTO kew_vpl VALUES ("PR22_3","021_22_3","PRO","22","3","3","Epe kone sua redepone-rupa piri aame waeanu nipu madaa epea rabu nipumi pakeaaya. Go yapare epe-rupa napimi aanuri nimu pimi-para waeanu epea rabu nimumi go kedaa mua mea ritimi. ");
INSERT INTO kew_vpl VALUES ("PR22_4","021_22_4","PRO","22","4","4","Neme nena bi rabuaniawa ne Adaa Aa-na rolo-para pirali-daare ne mone oyaenu page adaapu sua epe-rupa pirali. ");
INSERT INTO kew_vpl VALUES ("PR22_5","021_22_5","PRO","22","5","5","Aa malopawa ma-oyaya yaere wae pora pamua pea. Aa meda nipu epe-rupa aapena niminaaliare waea pape pora pakeaya. ");
INSERT INTO kew_vpl VALUES ("PR22_6","021_22_6","PRO","22","6","6","Nena nogo naakinu epe pora ratina agaa maana mogeape. Goa paliri nipu go pora rataama pua nipu pua ogae yalia. ");
INSERT INTO kew_vpl VALUES ("PR22_7","021_22_7","PRO","22","7","7","Mone imi aanumi naraame ome aanu nimumi kogono kaloa surubeme. Aa medaloma yago meme-nuri mo yago meme aanuna kogono pama kogono pu saeme. ");
INSERT INTO kew_vpl VALUES ("PR22_8","021_22_8","PRO","22","8","8","Gore aa medame pupitagi noa aa medaloma madaa wae yae nipu madaa epalia rabu nipumi pa aa meda-para wala waea meda mada napalia. ");
INSERT INTO kew_vpl VALUES ("PR22_9","021_22_9","PRO","22","9","9","Adaa Aame mo pa piri aanu rabameme onaare oyae waru kata. Gore akolo ya? Naraa piri aanu rabamua oyae kateme-daa pea. ");
INSERT INTO kew_vpl VALUES ("PR22_10","021_22_10","PRO","22","10","10","Waea pi aakone aanu luabu ratu talimi rabu mo aa nimuna pemeanu rayo dia yalia. ");
INSERT INTO kew_vpl VALUES ("PR22_11","021_22_11","PRO","22","11","11","Aa medame epe agaa loa Gote-na ini agaa madaa epe-rupa aayare gore mo aa mudu king-na adami aa piralia. ");
INSERT INTO kew_vpl VALUES ("PR22_12","021_22_12","PRO","22","12","12","Adaa Aa-me epe makuae kone luabu waru suruboa mo yaa agaa ne aanuna yaa agaa luabu rabuaniaya. ");
INSERT INTO kew_vpl VALUES ("PR22_13","021_22_13","PRO","22","13","13","Kiaa rakepene aa nipuna ada-para pama pirua nipumi gupa ta. Ni amaa palua rabu raa mena laiyonme porania ni tu nalia ta. ");
INSERT INTO kew_vpl VALUES ("PR22_14","021_22_14","PRO","22","14","14","Ona yolape kone saliri naaku-rupa lopo talia. Gore Adaa Aa ratu onaa madaa yawaliare go naakupara mada lopalimi. ");
INSERT INTO kew_vpl VALUES ("PR22_15","021_22_15","PRO","22","15","15","Nogo naakimiri maeyae aanu adaapu peme. Goa palimi pare neme mo nogo naakinu nimu aipuyame tua mana te-daare go palimide waeanu luabu mada gimalimi. ");
INSERT INTO kew_vpl VALUES ("PR22_16","021_22_16","PRO","22","16","16","Aa medame naraanuna oyae mulalo waea palia-dare go page mo amo ne aanu oyae ode kateadare go paliame nipu aa naraa piralia. ");
INSERT INTO kew_vpl VALUES ("PR22_17","021_22_17","PRO","22","17","17","Abiare epe kone imi aanuna epe makuaeyae-para epe redepone yae luabuna agaa lagiano waru pagalepa. ");
INSERT INTO kew_vpl VALUES ("PR22_18","021_22_18","PRO","22","18","18","Gore neme go agaa pagoa nena kone-para rubialia raburi neme mo onaa medaloma lakeloa mogeape. Goa paliri nena lo robaa raana rubialia. ");
INSERT INTO kew_vpl VALUES ("PR22_19","021_22_19","PRO","22","19","19","Nena bipa pagainalo go agaa apo lagialo-daa. Goa pua neme Adaa Aa madaa puri paboa kone waru rulainalo pea. ");
INSERT INTO kew_vpl VALUES ("PR22_20","021_22_20","PRO","22","20","20","Neme go agaa 30-pela epe redepona tisudere ora epe kone gua makuae yae meainalo gisude. ");
INSERT INTO kew_vpl VALUES ("PR22_21","021_22_21","PRO","22","21","21","Goa pea-ga neme ora agaa luabu waru makuaaina. Goa pua aa medalomame ne-para ora redepo ne agaa pua asapa teme-daare mada pua meali-ya? ");
INSERT INTO kew_vpl VALUES ("PR22_22","021_22_22","PRO","22","22","22","Neme go aa naraanu pa ora naraanu yade kone nasape. Goa pua neme nimuna oyaenu page pa yoloa nameape. Goa pua nimu koso talo epalimi rabu nimuna koso maoyaawa namabebolape. ");
INSERT INTO kew_vpl VALUES ("PR22_23","021_22_23","PRO","22","23","23","Gore akolo ya? Adaa Aa-me nimu adabaawa surubalialo lalo. Go page aa medame naraa aanu-para wae palimi-dare Adaa Aa-me nimu-na waea mada abutea. ");
INSERT INTO kew_vpl VALUES ("PR22_24","021_22_24","PRO","22","24","24","Neme ratu repara yawo agaa pa yola piriri pi aanu raapu na ada mu aape. ");
INSERT INTO kew_vpl VALUES ("PR22_25","021_22_25","PRO","22","25","25","Nimuna pemea ne mada palia rabu orope go waeanu-mi ne ma-oyalia. ");
INSERT INTO kew_vpl VALUES ("PR22_26","021_22_26","PRO","22","26","26","Gore aa medame rudu mua nipuna bipa mada na-abutea-daare neme abulalua pi nalape. ");
INSERT INTO kew_vpl VALUES ("PR22_27","021_22_27","PRO","22","27","27","Neme mo-rudu abutoa loa mada naabute-daare nena oyae luabu-para pati reke page madaa epa mealimi. ");
INSERT INTO kew_vpl VALUES ("PR22_28","021_22_28","PRO","22","28","28","Nena akuanumi abade su robo isimi-rupare wala meda neme yola monea nasape. ");
INSERT INTO kew_vpl VALUES ("PR22_29","021_22_29","PRO","22","29","29","Gore aa medame epe kogono paliare nipu aa muduna kogono aa mada piralia. Go piaene aa-re pama bi na-i aa medana kogono mada napalia. ");
INSERT INTO kew_vpl VALUES ("PR23_1","021_23_1","PRO","23","1","1","Ne adaa aa meda raapu pirua eta no pirali-daare ne pa mo gialia eta madaa kone sua pirali. ");
INSERT INTO kew_vpl VALUES ("PR23_2","021_23_2","PRO","23","2","2","Go page ne eta ora adaapu ne aa yaliare nena lo robaa rabuaniaawa gimape. ");
INSERT INTO kew_vpl VALUES ("PR23_3","021_23_3","PRO","23","3","3","Neme mo aa muduna eta madaa ora pea kone nasape. Neme mo eta madaa omeme pali rabu aa adaa nipumi raana naome aanu medaloma palilo lagialo. ");
INSERT INTO kew_vpl VALUES ("PR23_4","021_23_4","PRO","23","4","4","Ne mone orae amo aa mudu pirano kone sua kalai ogeapu pape. Gore ne mada epe kone piralia-dare goanu napape. ");
INSERT INTO kew_vpl VALUES ("PR23_5","021_23_5","PRO","23","5","5","Neme mone adaapupe sali pare go mone ora aipapulu dia yalia. Gore mone nipu yaa-itaa madaa popaa maawa riyaa palia rabu ne ipa ripi ralia. ");
INSERT INTO kew_vpl VALUES ("PR23_6","021_23_6","PRO","23","6","6","Oyaenu narumaae aa raapu eta padane-para nanape. Nipuna gialiade eta agu nolalo kone nasape. ");
INSERT INTO kew_vpl VALUES ("PR23_7","021_23_7","PRO","23","7","7","Go piaene aa raapu eta nali-dare mo aame ne gupa lagialia. Eta ipa oyae luabu apo ia-ga nena raana palia-rupa aipapulu nabape tea. Goa tea pare ora agaa-da nata ne eta nali-rupare aba gupa nalialo nipuna kone-para makuaaya. ");
INSERT INTO kew_vpl VALUES ("PR23_8","021_23_8","PRO","23","8","8","Goa pua neme eta no kiritua aana pea luabu ado kirituare mo mea nalide eta luabu wala maaku ratu rubali-ga mo tede omeme pi agaa page puri napaloa ini namadialia. ");
INSERT INTO kew_vpl VALUES ("PR23_9","021_23_9","PRO","23","9","9","Aa meda kone epe-rupa nasalia raapu neme agaa nalape. Neme epe agaa nipu lakete-dare go agaa pa sa so lalia. ");
INSERT INTO kew_vpl VALUES ("PR23_10","021_23_10","PRO","23","10","10","Ora abade su robo isimidere neme wala yolamonea meda nasape. Neme agi aaraanu aba ome onaana su page nameape. ");
INSERT INTO kew_vpl VALUES ("PR23_11","021_23_11","PRO","23","11","11","Adaa Aa-re amame padane-para madini nona pi aaya-pulu mo nogo naakinu rabamealia. Goa pua nipumi puri adaa mua raba mulalo puri waru paloa koso madaa page rabamulalo pea. ");
INSERT INTO kew_vpl VALUES ("PR23_12","021_23_12","PRO","23","12","12","Gore ne agaa mana lagialoga go agaa mana waru pagoa makuape. Nena aane waru luyapa-ina pagoa go agaa waru makuaaliri epe yae rayo waru makuaali. ");
INSERT INTO kew_vpl VALUES ("PR23_13","021_23_13","PRO","23","13","13","Neme nogo naaki tua kuma mapape madaare paalame naomape. Neme agaa mana loa tali-daare nipu na-omalia. ");
INSERT INTO kew_vpl VALUES ("PR23_14","021_23_14","PRO","23","14","14","Dia neme goa pali raburi maredepo yali-daa nipu ome onaana su-para mada napalia. ");
INSERT INTO kew_vpl VALUES ("PR23_15","021_23_15","PRO","23","15","15","Naakinumi epe kone-para epe makuae yae mealimi rabu nena pu robaa-para page ora epealia. ");
INSERT INTO kew_vpl VALUES ("PR23_16","021_23_16","PRO","23","16","16","Neme nena epe redepone agaa pagape madaare raana ora waru pea. ");
INSERT INTO kew_vpl VALUES ("PR23_17","021_23_17","PRO","23","17","17","Neme waea peme aanuna pemea adoa epame na-omape. Oro yalo neme Adaa Aa madaa raana omo pirua kone sape. ");
INSERT INTO kew_vpl VALUES ("PR23_18","021_23_18","PRO","23","18","18","Neme go pora ratu pirali-dare nena orope pirape yaere ora epeaalia. Goa puare ne page ora aipapulu mada na-omali. ");
INSERT INTO kew_vpl VALUES ("PR23_19","021_23_19","PRO","23","19","19","Naa naakimi naa agaa pagoa epe kone mea. Goa puare nena pora pamuali-rupa pawa adoa pamuape. ");
INSERT INTO kew_vpl VALUES ("PR23_20","021_23_20","PRO","23","20","20","Nere ipa waini-para eta ora adaapu neme aanu raapu padane-para napamuape. ");
INSERT INTO kew_vpl VALUES ("PR23_21","021_23_21","PRO","23","21","21","Ipa bia-para eta adaapu neme aanu nimu ora naraa piralimi. Go yapare aa medalomame pa ipa agu noa u-patu piraliare nimu mamina riripipape pi yamoa piralimi. ");
INSERT INTO kew_vpl VALUES ("PR23_22","021_23_22","PRO","23","22","22","Nena aapame ne maopasa-ga nipuna agaa waru pagape. Nena aama page ogae yalia rabu ne ora waru yae-da kalape. ");
INSERT INTO kew_vpl VALUES ("PR23_23","021_23_23","PRO","23","23","23","Neme ora waru puri paloa epe kone-para epe kogono pape-para epe makuae yae meape madaa puri paloa kogono pape. Neme go epe kone narubape. ");
INSERT INTO kew_vpl VALUES ("PR23_24","021_23_24","PRO","23","24","24","Gore aa medame epe kone sua epe pora ratalia-daare nipuna aaraame go naaki madaa raaname ora waru omea. ");
INSERT INTO kew_vpl VALUES ("PR23_25","021_23_25","PRO","23","25","25","Neme go agaa pagoa epe pora luabu ratali raburi nena aama-aapame ne ora epe ta loa adaa raaname omoa pedo pedo waru palipi. ");
INSERT INTO kew_vpl VALUES ("PR23_26","021_23_26","PRO","23","26","26","Go naaki neme nina kone ora waru adoa naa agaa pago pirali-daare epe yae luabu adaina. ");
INSERT INTO kew_vpl VALUES ("PR23_27","021_23_27","PRO","23","27","27","Wae paake aa rume onare ipa naaku meda-rupa yapulu go-para lopoladere pua omaalimi. ");
INSERT INTO kew_vpl VALUES ("PR23_28","021_23_28","PRO","23","28","28","Go piaene onanuri paake ne aanumi pemede-rupa surubaeme-ga waru adalepape. Nimumi aa adaapu rumeme rabu aaninumi gimeme. ");
INSERT INTO kew_vpl VALUES ("PR23_29","021_23_29","PRO","23","29","29","Aa apimi kedaa naloa nipuna bipa odo omea pae? Aa apimi agaa adaapu loa yada marekaaya pae? Aa apina to madaa rere pia pae? Gore apina inipara ora ka-nea loa ayapae? ");
INSERT INTO kew_vpl VALUES ("PR23_30","021_23_30","PRO","23","30","30","Go aanu luaburi oro yalo ipa bia-para wain lapo noa maeyae aanu yade. ");
INSERT INTO kew_vpl VALUES ("PR23_31","021_23_31","PRO","23","31","31","Mo wain nipu epe pepena pua ranapi yae saliare nena kone-para ora mea gi tea gimape. Nena peto-para page mea nali rabu rede-ora waru palia. ");
INSERT INTO kew_vpl VALUES ("PR23_32","021_23_32","PRO","23","32","32","Wala ekeraa ribareko raburi paaka wae medame onaa nalade-rupa mada palia. ");
INSERT INTO kew_vpl VALUES ("PR23_33","021_23_33","PRO","23","33","33","Gore nena kone luabu ora oyalia rabu neme oyae rado meda ade nona palia. Neme goa pua makirae agaa adaapu te. ");
INSERT INTO kew_vpl VALUES ("PR23_34","021_23_34","PRO","23","34","34","Goa pua ne pate raburi ipa sipi mo solowara mada pulaina so sipina ini kadu madaa piri nona palia. ");
INSERT INTO kew_vpl VALUES ("PR23_35","021_23_35","PRO","23","35","35","Goa pua neme gupa te. Ni tamede pare radaa napea te. Gore akolo ni narekawa ipa meda wala nanowaya? ");
INSERT INTO kew_vpl VALUES ("PR24_1","021_24_1","PRO","24","1","1","Neme waea pi aanuna kone madaa raaname na-omape. Go waea pi aanu raapu pamuape page gimape. ");
INSERT INTO kew_vpl VALUES ("PR24_2","021_24_2","PRO","24","2","2","Nimu waea pape agu niminaaeme. Goa pua nimumi oro yalo wae pupitagi yada papena agaa agu teme. ");
INSERT INTO kew_vpl VALUES ("PR24_3","021_24_3","PRO","24","3","3","Aa meda nipu epe kone su epe makuae yae raapu piraliadare nipu ora epe ada-rupa pu patea. Goa pua nipuna ona nogo naaki raayo puri paloa piralimi. ");
INSERT INTO kew_vpl VALUES ("PR24_4","021_24_4","PRO","24","4","4","Go piaene aa nipumi yoto adaapu pe yaenu kaboa nipuna ada-para marubia salia. ");
INSERT INTO kew_vpl VALUES ("PR24_5","021_24_5","PRO","24","5","5","Aa nipu epe kone sua epe makuae waru rubina aaliare go aa nipu ora puri pabe aa alia. Goa pua nipuna ada kagure page puri waru mapabalia. ");
INSERT INTO kew_vpl VALUES ("PR24_6","021_24_6","PRO","24","6","6","King medame ada kagure medapara piri king meda raapu yada pulalo paliare mo epe kone sua makuae aanu madaa kone aba mealiare goa ora epelia. Goa pua mo yada papena mana page agaa aba waru minaawa yada waru makuae aa adaapu salia-daare mogo pulalo paliade yada ora nipumi mada wini palia. ");
INSERT INTO kew_vpl VALUES ("PR24_7","021_24_7","PRO","24","7","7","Epe kone-para epe makuae yae laapo-re ora madaa ia-pulu epe kone na-i aanuna kone luabu rabuaniaaya. Go yapare aanumi agaa adapu teme rabu agaa kone nasapimi aanuri pa agaa loraawa piruaeme. ");
INSERT INTO kew_vpl VALUES ("PR24_8","021_24_8","PRO","24","8","8","Waea pape mada agu kone niminaalia aare nipu pupikagi nape aa yade teme. ");
INSERT INTO kew_vpl VALUES ("PR24_9","021_24_9","PRO","24","9","9","Wae kone imi aanuni oro yalo nimu wae pupitagi nape kone agu niminawaeme. Go pemea luaburi waeana re luabu yade. Aanumi ademe raburi nimu ora wae aanu-rupa ademe. ");
INSERT INTO kew_vpl VALUES ("PR24_10","021_24_10","PRO","24","10","10","Gore wae yapi-di meda ne alalia rabu nena uni omapaawa ne ora puri ogesi-da page meda ora nasalia. ");
INSERT INTO kew_vpl VALUES ("PR24_11","021_24_11","PRO","24","11","11","Gore koso-me rumaawa aa meda wae napea pare tumaomatalo palimimiri neme go aa wala puaa raba meape. ");
INSERT INTO kew_vpl VALUES ("PR24_12","021_24_12","PRO","24","12","12","Neme apo yaere niaana ya-daa dia pi nalape. Adaa Aa-me ne ora waru suruboa nena oyaenu page waru rumaa gu aaya-ga adape. Goa pua neme go agaana re waru makuape. Gore aanu rayo madaa mo nimuna padane padane laatapu pemeana yoto ruma katea. ");
INSERT INTO kew_vpl VALUES ("PR24_13","021_24_13","PRO","24","13","13","Naa si nere epe redepi alumbi apaa nape. Gore epe eta yapulu agaa-para rede ora waru palia. ");
INSERT INTO kew_vpl VALUES ("PR24_14","021_24_14","PRO","24","14","14","Gorupare neme waru makuaawa adape epe kone-para epe makuae yae lapore rede pi yae meda mua oro yalo pirali. Neme go yaenu mealiri epe-rupa pirua ne abi naomali. ");
INSERT INTO kew_vpl VALUES ("PR24_15","021_24_15","PRO","24","15","15","Ne wae aa yaliare neme kudiripu pirua epe aa medana ada-para nasuruba pirape. Goa puare nipuna oyaenu paake napape. ");
INSERT INTO kew_vpl VALUES ("PR24_16","021_24_16","PRO","24","16","16","Gore epe redepone aa wae yaeme malopaaliare nipu oro yalo wala rekaa pitia. Go yapare wae pupitagi ne aanu lopalimiri nimu bebo teme. ");
INSERT INTO kew_vpl VALUES ("PR24_17","021_24_17","PRO","24","17","17","Nena iaa medame kedaa rialia rabu neme epe pia nalape. Neme oyae meda madaa aa-kidipa pitaawa lopolalo paliare gore neme giri nalape. ");
INSERT INTO kew_vpl VALUES ("PR24_18","021_24_18","PRO","24","18","18","Gore akolo ya? Adaa Aa-me neme go palide-a adalia rabu mo iaa madaa pape ronore wala ne madaa pina tea-ga waru adape? ");
INSERT INTO kew_vpl VALUES ("PR24_19","021_24_19","PRO","24","19","19","Neme mo waea pemea adoa kedaame na-omape. Neme goa pali raburi nena kone mabebolalia. Goa pua mo palimide aanu madaa page kone kedaa nameape. ");
INSERT INTO kew_vpl VALUES ("PR24_20","021_24_20","PRO","24","20","20","Dia go aanu nimu epe yae meda mada na-adasalimi. Nimu ora laba paa udinita-rupa mada aipapulu omalimi. ");
INSERT INTO kew_vpl VALUES ("PR24_21","021_24_21","PRO","24","21","21","Gore na si nere ora Adaa Aa-na rolo-para page piru aa mudu king-na rolo-para page pawa pirape. Go rabu wae aanu rol0-para napimi-pulu nimu raapu napirape. ");
INSERT INTO kew_vpl VALUES ("PR24_22","021_24_22","PRO","24","22","22","Go piaene onaare nimu wae yae repara repara aipapulu mealia. Adaa Aa-para aa mudu king lapo-me go piaene onaa-re ake piaene yoto katea palo niaa namakuaema. ");
INSERT INTO kew_vpl VALUES ("PR24_23","021_24_23","PRO","24","23","23","Epe kone i aanu medalomame go agaa kiritaawa isimi. Gore aa medaloma koso talo peme rabu koso surube aame aa medaloma rabamua medaloma maoyata palimiri otaa. ");
INSERT INTO kew_vpl VALUES ("PR24_24","021_24_24","PRO","24","24","24","Waea pi aa koso mada adialimi pare mo koso pagoa rumae aame nipu na-adini pa penatea. Goa palia raburi ada kagure-nini piri onaame go koso pagoa-rumae aa nipu ero loa marakepeae agaa adaapu teme. ");
INSERT INTO kew_vpl VALUES ("PR24_25","021_24_25","PRO","24","25","25","Go yapare mo koso pagea aame waea pi aanu adialepape teare nipu eperupa pirua epe yaenu mealia. ");
INSERT INTO kew_vpl VALUES ("PR24_26","021_24_26","PRO","24","26","26","Epe redepone agaame abutea-daare go aare nena adami aa. ");
INSERT INTO kew_vpl VALUES ("PR24_27","021_24_27","PRO","24","27","27","Neme aba ripia maapu poa su maredepo yaawoare orope gopare ada paina. ");
INSERT INTO kew_vpl VALUES ("PR24_28","021_24_28","PRO","24","28","28","Gore neme aa medana koso rabamua talo palidare neme pama pupitagi nane aa loa go aa narabameape. ");
INSERT INTO kew_vpl VALUES ("PR24_29","021_24_29","PRO","24","29","29","Go page pa aa meda madaa neme abia nipuna wae yae abutalo pi nalape. Aba ni go aa-me waea pisa-da wala abutalo pi nalape. ");
INSERT INTO kew_vpl VALUES ("PR24_30","021_24_30","PRO","24","30","30","Ni pora pamua epe kone naiwae kiaa rakepene aa medana e maapu pa mu adawa. ");
INSERT INTO kew_vpl VALUES ("PR24_31","021_24_31","PRO","24","31","31","Go maapu ripu wae-para itutu medaloma page opea. E-kepore aana-me pi yapare aba robapapepu lopisana. ");
INSERT INTO kew_vpl VALUES ("PR24_32","021_24_32","PRO","24","32","32","Neme go maapu adoa kone adaapu mua ni makuae yae ora waru meawa. ");
INSERT INTO kew_vpl VALUES ("PR24_33","021_24_33","PRO","24","33","33","Wae kiaa rakepene aame goa teme: Palainawa loa u ogeda pateme. Goa pua ki arota-para pagoa kiaa rakepea pimi. ");
INSERT INTO kew_vpl VALUES ("PR24_34","021_24_34","PRO","24","34","34","Nimumi goa peme rabu oyae luabu aipapulu diayoa naraa onaa pirualimi. Go rabu nimuna oyae luabu paake ne aanumi mube nona palia. ");
INSERT INTO kew_vpl VALUES ("PR25_1","021_25_1","PRO","25","1","1","Gore Solomon-na agaa rudu rudu medaloma go ia. Hesikia mo Juda aanuna aa mudu pirisa rabu nipuna pipaa ti aanumi go pipaa tu isimi. ");
INSERT INTO kew_vpl VALUES ("PR25_2","021_25_2","PRO","25","2","2","Adaa Aa-me oyae-yae luabu nipuna kone-para pagaa su pia. Goa pea nipu adaa bi katema. Goa pea pare aa mudu king-mi oyae luabu kudiripu ia-da nipumi adesaatalo kogono kalai adaapu pea. Go page niaame king-an bi minasaatalo pema. ");
INSERT INTO kew_vpl VALUES ("PR25_3","021_25_3","PRO","25","3","3","Niaame king-na ia kone luabu mada na-ado kiritalima. Gore go-rupa madaa niaame oyae luabu so yaa-para ia page no ipa solowara runane ia yaenu page mada na-adema. ");
INSERT INTO kew_vpl VALUES ("PR25_4","021_25_4","PRO","25","4","4","Aanumi aana silva irua ora ria mealimi. Goa pua ora epe pelete mada warialia. ");
INSERT INTO kew_vpl VALUES ("PR25_5","021_25_5","PRO","25","5","5","Go-rupa agu waea peme aanu ratu rubalimi raburi nimu mo king raapu mada napiraalimi. King-mi epea palia raburi mo ora epe ada kagure puri paloa aalia. ");
INSERT INTO kew_vpl VALUES ("PR25_6","021_25_6","PRO","25","6","6","Ne mo aa mudu king raapu aalidare ni page aa adaa yade kone sua neme aakone nai pawa aape. ");
INSERT INTO kew_vpl VALUES ("PR25_7","021_25_7","PRO","25","7","7","Ne adaa aa piritalo palidare orope nipu ipua ne epa ratalia rabu wae-para pali. Goa palia-ga ne pa aa naraanu raapu pirua orope ne mo adaa aa-rupa pua pira teme rabu pirita paina. ");
INSERT INTO kew_vpl VALUES ("PR25_8","021_25_8","PRO","25","8","8","Neme waea paedelo aipapulu yaa agaa mariaawa koso nalata pope. Gore aa medamene adoa makirae koso ne aa yade teare neme ake pali yapae? ");
INSERT INTO kew_vpl VALUES ("PR25_9","021_25_9","PRO","25","9","9","Nena adami aa raapu yae meda madaa agaa talo pali-daare ne mo nipuna ada-para pua agaa maredepoya tapape. Pare neme agaa kudiripi meda aba pagaliri nalapedepeape. ");
INSERT INTO kew_vpl VALUES ("PR25_10","021_25_10","PRO","25","10","10","Wala orope go agaa kudiripi lapedepeali rabu go aame agaa pame lapedepe ta teme rabu ne yala mapolalimi. Goa pua ne madaa oro yalo wae kone-su aalimi. ");
INSERT INTO kew_vpl VALUES ("PR25_11","021_25_11","PRO","25","11","11","Go yapare aa medame agaa ora epe-rupa meda lapedepealia raburi go aa nipuna agaare golome warini piksa-rupa madaa goa pua pepenare silpa-na pepena pae nona palia. ");
INSERT INTO kew_vpl VALUES ("PR25_12","021_25_12","PRO","25","12","12","Epe kone i aamere nipuna adami aa maredepo yaya. Goa pua mo nipuna adami aame nipuna aa-na agaa epeta kone saliadare nipumi golome warini epe yae meata-rupa la. ");
INSERT INTO kew_vpl VALUES ("PR25_13","021_25_13","PRO","25","13","13","Go yapare agaa lama epaliade aame nipuna surube aame tea agaa redepona lama epalia-daare nipumi nimu raaname epe-rupa omena tea. Gore aanumi nimuna maapu-para ipa kogaare nemede-rupa mada mealimi. ");
INSERT INTO kew_vpl VALUES ("PR25_14","021_25_14","PRO","25","14","14","Onaa medalomame oyae ode meda katema loa wala nakatemere yai naepe pa poripu-para moae epeade-rupa mada agaa teme. ");
INSERT INTO kew_vpl VALUES ("PR25_15","021_25_15","PRO","25","15","15","Gore neme agaa pawa kumupu loa nena agaa napagolalo pi onaame page wala pereketua raana omoa nena agaa mada pagalimi. Goa pali rabu aa adaanu page nimuna kone mada perekealimi. ");
INSERT INTO kew_vpl VALUES ("PR25_16","021_25_16","PRO","25","16","16","Gore neme alubi apaa medaloma repena apaa-para ina adaliri nena etaa ne robo-para nape. Neme ora adaapu nano kone sua adaapu nali raburi nena robaa rubia maaku ratali. ");
INSERT INTO kew_vpl VALUES ("PR25_17","021_25_17","PRO","25","17","17","Go page nena adami aa-na ada-para oro yalo napope. Nena adami aame ne gime omalia. ");
INSERT INTO kew_vpl VALUES ("PR25_18","021_25_18","PRO","25","18","18","Aa medame nipuna adami aa-para pa mariaa agaa teare etaa page rai page repename temede-rupa nipuna adami aa go tea. ");
INSERT INTO kew_vpl VALUES ("PR25_19","021_25_19","PRO","25","19","19","Neme yaa agaa ne aa meda adalidare wae yapi di rabu ni rabamina kone salidare ne agaa odonalo pi aame eta neade nonapi aa yalia. Go page ke odonalo pi aame pora pameme-rupa mada yalia. ");
INSERT INTO kew_vpl VALUES ("PR25_20","021_25_20","PRO","25","20","20","Neme aa medana lo robaa kedaa ina piru aalia rabu go aa rabamealua kone sua neme rupa-yasa te pare mo aa mada narabameali. Go piaene aa-re poripu epea rabu seti kolo rabua aipame rere madaa kiraawa peme-rupa mada yade. ");
INSERT INTO kew_vpl VALUES ("PR25_21","021_25_21","PRO","25","21","21","Nena iaa meda reaeme omalia-daare eta kalape. Ipa nalame omalia page neme ora kalape. ");
INSERT INTO kew_vpl VALUES ("PR25_22","021_25_22","PRO","25","22","22","Neme goa pali-daare nipuna pea wae yae mada yala mapolaeye goa pe-pulu Adaa Aa-me ne epea palia. ");
INSERT INTO kew_vpl VALUES ("PR25_23","021_25_23","PRO","25","23","23","Po ripumi yai mea epeade-rupa mada maa agaa paeme koneme aa ratu mayawaawa ini agaa-para oke rita. ");
INSERT INTO kew_vpl VALUES ("PR25_24","021_25_24","PRO","25","24","24","Aa medana pa konemere ada masaa pirita pea rabu nipuna onana wae ratu yawe kone page rabuaaya. ");
INSERT INTO kew_vpl VALUES ("PR25_25","021_25_25","PRO","25","25","25","Aa medame epe agaa su adaalu-para mea epalia-daare go aa nipu ipa kogare noa lo-roba kumapu-rupa tea. ");
INSERT INTO kew_vpl VALUES ("PR25_26","021_25_26","PRO","25","26","26","Wae aa medame epe-rupa piri aa epaa yolo bebolaalia-daare nipumi ipa karerene-para wala emaagu piade-rupa mada pea. ");
INSERT INTO kew_vpl VALUES ("PR25_27","021_25_27","PRO","25","27","27","Gore aa meda alubi apaa adaapu no mamalia-dare naepealia. Aa medame nipu adaa bi kana kone sua kalaipu kogono pualia-dare naepeta. ");
INSERT INTO kew_vpl VALUES ("PR25_28","021_25_28","PRO","25","28","28","Aa meda nipuna ratu yawea kone naminabaliare gore aa medame nipu rabunialia. Gopiane aare adarena pape yokapa ia-rupa mada aa yade. ");
INSERT INTO kew_vpl VALUES ("PR26_1","021_26_1","PRO","26","1","1","Epe kone na-i aa meda adaa bi katare gore na-epe ta. Gore yai radaki raapu nare palu loapeade-rupa mada yade. Eta napeta rabu yai radaaki apaa lopea-rupa mada yade. ");
INSERT INTO kew_vpl VALUES ("PR26_2","021_26_2","PRO","26","2","2","Aa medame pupitagi nanalia pare Gote-me go aa pa tina agaa tea-daare go agaana ini mada namadiaalia. Nimuna agaare yaanumi repena palaa madaa napiralia pare pa biyaa pamea-rupa mada yade. Goa pea-pulu ini namadini agaa teme. ");
INSERT INTO kew_vpl VALUES ("PR26_3","021_26_3","PRO","26","3","3","Aanumi ose-mena aipapulu penalo aipuya unimi teme-rupa mada yade. Gore dogi-menana agaa-para aeyane-me pora epe-rupa ma-puaeme-rupa peme. Wae maeyae peme onaa goa napape loa teme-rupa mada yade. ");
INSERT INTO kew_vpl VALUES ("PR26_4","021_26_4","PRO","26","4","4","Aa meda nipu epe redepone kone nasalia-daare nepara epe agaa meda natea. Goa palia-ga neme nipuna agaa na-abulape: Neme nipuna agaa abute raburi wala nipumi pea pali. ");
INSERT INTO kew_vpl VALUES ("PR26_5","021_26_5","PRO","26","5","5","Epe kone nai aame ne-para wae agaa tea-daare nipuna agaa abulape. Na-abute raburi nipumi makua kone ora epeta kone salia. ");
INSERT INTO kew_vpl VALUES ("PR26_6","021_26_6","PRO","26","6","6","Kone waru na-i aa meda-para go agaa laketa pu loa penatedare gore nena ne bipa ne maoyaayawa nena ke mea kepe rube nona palia. ");
INSERT INTO kew_vpl VALUES ("PR26_7","021_26_7","PRO","26","7","7","Epe kone napiri aame epe agaa meda lano kone sua tea-daare mogo tea agaa epe-rupa mada natea. Go agaare ke wae aa-na pora pamea-rupa rado yade. ");
INSERT INTO kew_vpl VALUES ("PR26_8","021_26_8","PRO","26","8","8","Epe kone nai aa meda aa mudu bi kateme-daare nipumi etaa madaa aana mapagaawa pitalo peme-rupa mada peme. ");
INSERT INTO kew_vpl VALUES ("PR26_9","021_26_9","PRO","26","9","9","Aa meda epe kone nasua nipumi epe agaa meda pa lano kone sua tea-daare ipa bia neme aanumi ope etolo etolo-ae kimi ripinaae nona-palia. ");
INSERT INTO kew_vpl VALUES ("PR26_10","021_26_10","PRO","26","10","10","Surube aame kone waru na-i aanu kogono katalo paliare onaa adaapu ae-para etaa mada pi moneaya. ");
INSERT INTO kew_vpl VALUES ("PR26_11","021_26_11","PRO","26","11","11","Kone waru na-i aamere nipuna abade maeyae-rupa wala maeyaaya. Go peare yana-me maaku ratu ruboa wala mea neade-rupa mada pea. ");
INSERT INTO kew_vpl VALUES ("PR26_12","021_26_12","PRO","26","12","12","Aa meda epe kone nasaliadare niaame nipu mada rabamua epe kone mogealima pae? Maria. Pare go aa nipumi oyae luabu makuaayo kone salia-dare niaame go aa agaa mana loa rabameape-rupa mada dia. ");
INSERT INTO kew_vpl VALUES ("PR26_13","021_26_13","PRO","26","13","13","Kiaa rakepene aa nipuna adapara pa piruaawa nipumi gupa ta. Mo pora mena laiyono aaya kone sua pala omoa napea. ");
INSERT INTO kew_vpl VALUES ("PR26_14","021_26_14","PRO","26","14","14","Kiaa rakepene aa nipumi nipuna ada runane patua pereke pereke tupia ada dua warini inisisi lego lego malaawa runane piruaaya. ");
INSERT INTO kew_vpl VALUES ("PR26_15","021_26_15","PRO","26","15","15","Kiaa rakepene aame eta aipapulu mea nolalo nipuna ki pelete madaa ia. Goa pea pare nipu mo eta minasaawa agaa-para mea nape-rupare puri na-ia. ");
INSERT INTO kew_vpl VALUES ("PR26_16","021_26_16","PRO","26","16","16","Kiaa rakepene aame epe kone i aa (7) kerepopu na kone rabuaayo kone ia. Goa kone sua nipumi aakone waru ia. ");
INSERT INTO kew_vpl VALUES ("PR26_17","021_26_17","PRO","26","17","17","Gore aa laapome yada yada pua ratu yawalipi rabu aa medame nipu pua rabamealia-dare go aa nipu yana pupulaina aane pua ripinae nona pia pea. ");
INSERT INTO kew_vpl VALUES ("PR26_18","021_26_18","PRO","26","18","19","Aa medame nipuna adami aa makiratalo puare wala orope gupa tea. Neme pa raapa agaa lawade ta. Gore maeyae aame repena agaa lusu ruboa etaane rubebe mada pea. ");
INSERT INTO kew_vpl VALUES ("PR26_20","021_26_20","PRO","26","20","20","Repena kaapu repena ralae-para na-iralimi raburi gore repena naralia. Go page aanumi maa agaa natemere go yaweme ratu dia yalia. ");
INSERT INTO kew_vpl VALUES ("PR26_21","021_26_21","PRO","26","21","21","Repena kaapu waru iritimi rabu repena ora waru reade. Gorupare ada pi agaa ta aamere yada agaa ora ma-adaayaya. ");
INSERT INTO kew_vpl VALUES ("PR26_22","021_26_22","PRO","26","22","22","Niaame aa yago medana maa agaa pame rabu go agaa pagape madaare raname waru omema. Go teme agaa-re epe ta kone sua epe eta-rupa mea neme. ");
INSERT INTO kew_vpl VALUES ("PR26_23","021_26_23","PRO","26","23","23","Aa medame epe-rupa awape agaa puri paloa tea-daare ora yapare mo konena rere waea papena ta. Gore sumi warini sosopen-rupa yapare wala silipa golme warini nona mapaaeme. ");
INSERT INTO kew_vpl VALUES ("PR26_24","021_26_24","PRO","26","24","24","Gore aa medame aa yaago meda raname na-omaliare pa agaame makirae kone sua nimu rana omana kone inalo pea. Nipu makinae kone sua pea. ");
INSERT INTO kew_vpl VALUES ("PR26_25","021_26_25","PRO","26","25","25","Go piaene aanuna agaare nena aaneme pagape mada ora rede waru palia pare neme nipuna agaa madaa kone narulape. Gore akolo ya? Nipuna kone pu robaa-para wae kone luabu pa rubitabea. ");
INSERT INTO kew_vpl VALUES ("PR26_26","021_26_26","PRO","26","26","26","Nipuna pu lo robaa-para ia wae kone raayo pagaa salia pare onaa luabumi nipuna wae kone adoa makualimi. ");
INSERT INTO kew_vpl VALUES ("PR26_27","021_26_27","PRO","26","27","27","Aa medame nipuna bipa nipu wae yaenu pa pu aano kone sua paliare nipuna bipa nipu otaa. Gore aa medame koyati pa onaa awena kone sua ia pare wala nipuna bipa mo koyati patemede-rupa mada pea. Gore aana agaare rudu madaa sone mea pea pare wala perene ipua nipu epa tea-rupa mada yade. ");
INSERT INTO kew_vpl VALUES ("PR26_28","021_26_28","PRO","26","28","28","Aa medame aa yago meda yaa agaa medaloma laketea-daare nipumi yaa agaa loa onaa ma-oyape mada pea. Aa medame oro yalo omeme pi agaa teare gore aa yago ma-oyaatalo pea. ");
INSERT INTO kew_vpl VALUES ("PR27_1","021_27_1","PRO","27","1","1","Neme aakone sua ekeraa goa palua loa agaa meda narogaa sape. Goa loa piraina abia paliare ne-daa namakuae. ");
INSERT INTO kew_vpl VALUES ("PR27_2","021_27_2","PRO","27","2","2","Gore aa medame nena bi minasaaliare ora epeta pare nena bipa nena bi naminasape. ");
INSERT INTO kew_vpl VALUES ("PR27_3","021_27_3","PRO","27","3","3","Maeyae aanuna kone epe-rupa naimi-pulu go imi koneme niaa kedaa adaa meda geme. Go epea kedaare ipa muna kedaa-para adaa aana lapome adea. ");
INSERT INTO kew_vpl VALUES ("PR27_4","021_27_4","PRO","27","4","4","Aa medaloma ratu yawoa wae pemenumi onaa yago kedaa adaapu pa mea kateme. Goa pea pare oyae epame omoa kone wae imi konemere ratu yawoa aa meda-para wae kone imi kone luabu rabuaaya. ");
INSERT INTO kew_vpl VALUES ("PR27_5","021_27_5","PRO","27","5","5","Waea pi aa meda maredepo rabu ne yago-rupa raana ome kone page kalo aaye. ");
INSERT INTO kew_vpl VALUES ("PR27_6","021_27_6","PRO","27","6","6","Nena adami aanumi nimu raba meainalo radaa ora waru mea geme palo peme. Pare mo nena yada-lore aanumi epea pua ne makira teme. ");
INSERT INTO kew_vpl VALUES ("PR27_7","021_27_7","PRO","27","7","7","Aa medame eta luabu noa pua nipuna robaa-para rubita raburi alubi apaa ora ota pare reame ome aame rero pi eta nea rabu ora mada nalia. ");
INSERT INTO kew_vpl VALUES ("PR27_8","021_27_8","PRO","27","8","8","Gore aa medame nipuna su ada gimoa pa pora pamu aaliare yaame nipuna piri-para gimoa pa riyaa pamuaya-rupa mada pamea. ");
INSERT INTO kew_vpl VALUES ("PR27_9","021_27_9","PRO","27","9","9","Waele-sada page ora epe wabala waele luabu pema raburi niaa mada ora epe ta kone sua pedo waru pema. Go page niaana adami aanumi niaa raana masaawa niaa rabameape kone imi epe agaa loa epea pemede-rupa mada yade. ");
INSERT INTO kew_vpl VALUES ("PR27_10","021_27_10","PRO","27","10","10","Nena ona nogo naakinu-para nena adami aanu masaa narilape. Go page wae yae medame ne epaa mulalo paliare gore ne rabamina nena ame na-adola pope. Aa meda ne raapu repara pirali-daare go ame su adaalu-para aaya page rabuniaaya. ");
INSERT INTO kew_vpl VALUES ("PR27_11","021_27_11","PRO","27","11","11","Naa naaki neme epe kone luabu mua epe pora luabu ratali-dare ne madaa epe kone salua. Goa pua aa medame nipara pa mariae agaa teadare neme nipuna agaa mada abutoa. ");
INSERT INTO kew_vpl VALUES ("PR27_12","021_27_12","PRO","27","12","12","Epe kone i aamere gore nipumi ora go-rupa makuaaya. Kedaa nipu mada epolalo palia-daare gore nipumi aipapulu mapakeaalia. Goa pea pare epe kone na-i aare gore mo pora wae i-para pea rabu page go wae yaeme nipu ora mea rabu ora aipapulu kedaa mu aaya. ");
INSERT INTO kew_vpl VALUES ("PR27_13","021_27_13","PRO","27","13","13","Aa medame mo aa yagona rudu neme abulalua loa wala naabutea-daare gore nipu wea aa yade. Go yapare mo nepara yaa agaa robali aame nepara rudu meda giaina tea rabu nipuna ta yaa agaa aba ade-ga neme mo rudu abuna kone sua oyae meda puri paboa meape. ");
INSERT INTO kew_vpl VALUES ("PR27_14","021_27_14","PRO","27","14","14","Gore neme rui puri pabo loa nena adami aa-para ribaa reko te-dare nipu-para wae agaa temede-rupa mada te. ");
INSERT INTO kew_vpl VALUES ("PR27_15","021_27_15","PRO","27","15","15","Aa medana ore agaa rado rado adaapu ne ona yaliare gore ada runane yai itipa-ta pogo pogo loatade-rupa mada pea. ");
INSERT INTO kew_vpl VALUES ("PR27_16","021_27_16","PRO","27","16","16","Goa pea-pulu nipuna aanimi go agaa kone luabu magimaape-rupa mada dia. Goa peare aame poripu page wabala pepenini page ripinaalua kone sua pemedea-pea. ");
INSERT INTO kew_vpl VALUES ("PR27_17","021_27_17","PRO","27","17","17","Nimumi puri pane aeyane nepo papere wala aeyane yagome nepo peme. Go peme-rupare aa yago medame mo aa yago rabamua epe kone masaaya. ");
INSERT INTO kew_vpl VALUES ("PR27_18","021_27_18","PRO","27","18","18","Aa medame repenana ini etalia rabu go repenana ini raloa nalua kone salia-dare go repena ora waru surubalia. Aa medame nipuna surube aa ora waru surubalia-daare go surube aame mo aa nipuna bi ora waru minasaalia. ");
INSERT INTO kew_vpl VALUES ("PR27_19","021_27_19","PRO","27","19","19","Aa medame mo ipa ini-para adainaalia raburi nipuna ini agaa nipuna bipa adea. Go-rupa aa medame nipuna pea rayo waru adoa rumaliare nipu gopiane aa yadelo makualia. ");
INSERT INTO kew_vpl VALUES ("PR27_20","021_27_20","PRO","27","20","20","Gore aa adaapu omalimi page pinawa. Mo aa tapa luabu mada narulatabalia. Go-rupa mada nipuna kone-para ia yae luabu mada napu kiritalia. ");
INSERT INTO kew_vpl VALUES ("PR27_21","021_27_21","PRO","27","21","21","Repena sulaame silipa golonu roa rakepeta. Go rupa mada go aa-re epe aa yade wae aa yade lo aba ademe. Epe aa yaliare nipuna bi minasaeme. ");
INSERT INTO kew_vpl VALUES ("PR27_22","021_27_22","PRO","27","22","22","Gore neme epe kone nai aa puri palo tali-dare omolalo palia-rabu nipuna maeyae kone mada nagimalia. ");
INSERT INTO kew_vpl VALUES ("PR27_23","021_27_23","PRO","27","23","23","Goa palia-ga nena mena sipsip-para meme mena luabu waru surubape. ");
INSERT INTO kew_vpl VALUES ("PR27_24","021_27_24","PRO","27","24","24","Gore akolo ya? Nena mone-re ne raapu oro yalo mada nasapiti. Mo aa mudu pia king-na ruru page oroyalo mada napitimi. ");
INSERT INTO kew_vpl VALUES ("PR27_25","021_27_25","PRO","27","25","25","Nena maapu-para ripu adaalu opalia-dare ponoa nena menanu nena mea sape. Goa pali rabu wala ripu kagaa opalia. ");
INSERT INTO kew_vpl VALUES ("PR27_26","021_27_26","PRO","27","26","26","Goa pua orope nena meme mena mada yoto mua su kabaina. Goa pua mo sipisipi mena iri pudi mua marape yae wariaina. ");
INSERT INTO kew_vpl VALUES ("PR27_27","021_27_27","PRO","27","27","27","Goa puare nena mo meme mena adu ipaa muare nena nogo naaki ona raapu nape ipaa meaina. Goa puare nena kagono onanu page mada kate. ");
INSERT INTO kew_vpl VALUES ("PR28_1","021_28_1","PRO","28","1","1","Waea pi aanuri pama paala omo nimu pagola peme. Goa peme pare epe kone i aanuri mena laiyano aaya-rupa puri aaeme. ");
INSERT INTO kew_vpl VALUES ("PR28_2","021_28_2","PRO","28","2","2","Kantri meda-para piri onaame nimuna gavman senisi pulalo yada palimi rabu kagaa alopape aa mudu rado re-para alopatalo peme. Go yapare aa mudu epeme surubolalo paliare ada kantri epe-rupa pa aalia. ");
INSERT INTO kew_vpl VALUES ("PR28_3","021_28_3","PRO","28","3","3","Aa medame naraame ome aanu rabuniaatalo palia-dare gore yai adaa ipua e maapu marateade-rupa mada pea. ");
INSERT INTO kew_vpl VALUES ("PR28_4","021_28_4","PRO","28","4","4","Rekena i agaa rasitemere wae yae peme aanuna bi minasaeme. Rekena agaa ratua pimi aanumiri waea peme aanu rabuaniaaeme. ");
INSERT INTO kew_vpl VALUES ("PR28_5","021_28_5","PRO","28","5","5","Waea peme aanumiri epe porare ake piaene yapalo nimu ora na-ademe. Goa peme pare aa medaloma Adaa Aa ratulalo peme onaare epe pora ademe. ");
INSERT INTO kew_vpl VALUES ("PR28_6","021_28_6","PRO","28","6","6","Aa meda nipu oyae dia yaliare epe aa yaliare amo ne aame pea luabu rabuaaya. ");
INSERT INTO kew_vpl VALUES ("PR28_7","021_28_7","PRO","28","7","7","Ogege-aame rekena i yaenu luabu ratua palia-dare epe kone ia. Pupitagi noa yada yada pi aanu raapu aalia-daare nipuna agi aaraanu yala polo pitimi. ");
INSERT INTO kew_vpl VALUES ("PR28_8","021_28_8","PRO","28","8","8","Aa medame mone rudu minaloa onaa repara poropete adaapu waria mealia pare mada nasaalia. Dia, pare araanu rabameme aana kinane palia. ");
INSERT INTO kew_vpl VALUES ("PR28_9","021_28_9","PRO","28","9","9","Aa medame rekena i agaa narataliadare Gote-me go aana beten napagalia. Gote-me go betene pageare pugu waru pugu pea-pulu mada napagalia. ");
INSERT INTO kew_vpl VALUES ("PR28_10","021_28_10","PRO","28","10","10","Aa medame epe aa meda makiraatalo paliare nipuna paliade waeame nipu wala mapiraalia. Go yapare aa meda nipu wae yae napi pawa aaliade-daare Gote-me go aa nipu epe epe yaenu mada katea. ");
INSERT INTO kew_vpl VALUES ("PR28_11","021_28_11","PRO","28","11","11","Oyae adaapu i aanu nimu ora makuae yae ima kone imi pare naraanu kone waru sua amope aanuna kone makuaaeme. ");
INSERT INTO kew_vpl VALUES ("PR28_12","021_28_12","PRO","28","12","12","Epe redepone aanumi nimuna kantri surubolalo peme raburi onaa luabumi go aa madaa ranaame waru omeme. Wae aanumi mo kantri surubeme raburi onaame palaa omoa nipu kaledeme. ");
INSERT INTO kew_vpl VALUES ("PR28_13","021_28_13","PRO","28","13","13","Aa medame nipuna wae yae pawa kudiripu pa ina kone sua piraliare go aame epea napea. Go yapare aa medame nipuna wae-yae luabu lapedepealia-dare Gote-me go aa nipu odome omoa raba mealia. ");
INSERT INTO kew_vpl VALUES ("PR28_14","021_28_14","PRO","28","14","14","Gore aa medame Adaa Aa madaa kone rulaawa piraliare nipu raana waru omoa pirina. Go yapare nipumi Adaa Aa-na agaa rasua waeanu pu piraliare nipumi waea kedaa mu-aalia. ");
INSERT INTO kew_vpl VALUES ("PR28_15","021_28_15","PRO","28","15","15","Gore kantri surube aame waea pua naaranu rabuaniatalo paliare nipu ota. Gore mo mena laion nipumi e-adaa puri palo ta-rupa para mena beame eta asapea-rupa mada ta. ");
INSERT INTO kew_vpl VALUES ("PR28_16","021_28_16","PRO","28","16","16","Gore mo kantri-na surube aa nipu epe kone na-i yaliare onaa luabu pa rabua tua ma-oyatalia. Go yapare adare surube aame onaa luabuna oyae nayotea pare ma-oyaape madaa gime omaliare nipu adaalupu epe-rupa pa piralia. ");
INSERT INTO kew_vpl VALUES ("PR28_17","021_28_17","PRO","28","17","17","Aa medame aa yago tumaomalia-dare go aa nipuna tapa poaawa kedaa mealia. Goa pua nipu ora epe-rupa napiri omalia. ");
INSERT INTO kew_vpl VALUES ("PR28_18","021_28_18","PRO","28","18","18","Gore aa medame epe kone epe pora ratua aaliare nipu epe redepoya piruaalia. Pare waenupu aalia aare aipapulu oyo tua alupalia. ");
INSERT INTO kew_vpl VALUES ("PR28_19","021_28_19","PRO","28","19","19","E-poae aa yaliare nipuna maapu-para eta ora adaapu su aalia. Kogono radore waru na-i mada pama to tu ruboa pu aaliare nipu wae-rupa naraa pirualia. ");
INSERT INTO kew_vpl VALUES ("PR28_20","021_28_20","PRO","28","20","20","Aa medame redeponea rataliare Gote-me go aa nipu epea palia. Aa meda nipu mone adaapu aipapulu sano kone saliare Adaa Aa-me go amope nipu epena kone na-ia. Dia mo amope aa nipu kedaa waru katea. ");
INSERT INTO kew_vpl VALUES ("PR28_21","021_28_21","PRO","28","21","21","Na-epeta koso madaa aa meda rabamua aa meda wala malopaliare gore ora na-epe ta. Goa pea pare aa medaloma waeanu pulalo managola pimi pare mo nimu omeme pua rabameape mone ogesi kateme rabu epe-rupa giala kone na-imi. ");
INSERT INTO kew_vpl VALUES ("PR28_22","021_28_22","PRO","28","22","22","Aa meda nipuna yaenu o waru yoa aalia-daare aipapulu amope alia. Pare nipu orope aa naraa piralua kone naia. ");
INSERT INTO kew_vpl VALUES ("PR28_23","021_28_23","PRO","28","23","23","Gore neme aa meda maredepoyali nipumi ranaame waru omalia. Go palipide-a luabumi mo omeme kone luabu rabuaniaaya. ");
INSERT INTO kew_vpl VALUES ("PR28_24","021_28_24","PRO","28","24","24","Gore aa medame agi araana oyaenu paake noa gupa ta. Neme go oyaenu nameawa ta. Paake nameawa ta agaare gupa aa medalomame oyaenu ma-oyaame-rupa mada yade. ");
INSERT INTO kew_vpl VALUES ("PR28_25","021_28_25","PRO","28","25","25","Aa meda nipu oyae yoloa salua kone saliare aa adapumi go madaa ratu yawalimi. Go yapare aa medame Adaa Aa madaa kone rulaliadare go aa nipumi epe-rupa pirua oyae adaapupe salia. ");
INSERT INTO kew_vpl VALUES ("PR28_26","021_28_26","PRO","28","26","26","Aame nina makuae oyaeme nipuna bipa madaa raba mealia kone ia pare mada dia. Go yapare aa medame epe redepone kone ratu aliare go aa nipu epe-rupa piralia. ");
INSERT INTO kew_vpl VALUES ("PR28_27","021_28_27","PRO","28","27","27","Aa medame aa naraanu oyae pa ode kateare go aa nipu oyae mada narudutea. Go yapare aa medame mo naraa onaa adoa oyaenu naruma kateare aa nipu ota teme. ");
INSERT INTO kew_vpl VALUES ("PR28_28","021_28_28","PRO","28","28","28","Wae agaa lo wae pora rati aanumi kantri surubalimi-dare onaa nimu kalodoa piralimi. Pare go wae aa mudunu omalimi raburi epe kone su epe pora rateme onaa nimu epe-rupa pirua surubeme. ");
INSERT INTO kew_vpl VALUES ("PR29_1","021_29_1","PRO","29","1","1","Gore aa meda maredepo yatalo palimi pare nipu wala pa pala pitia raburi gore nipu ora aipapulu raba meape pora nasalia. ");
INSERT INTO kew_vpl VALUES ("PR29_2","021_29_2","PRO","29","2","2","Epe redepone aa mudumi kantri surubeme raburi onaa luabumi raaname omeme. Goa peme pare wae aanumi kantri surubeme raburi onaa luabuna lo robaa-para kedaa rua re teme. ");
INSERT INTO kew_vpl VALUES ("PR29_3","021_29_3","PRO","29","3","3","Aa medame epe kone mulalo palia-daare nipuna aapa aba epe kone masaalia. Go yapare aa meda nipu ona pake nama palia raburi nipuna mone oyaenu gopara pua rubea. ");
INSERT INTO kew_vpl VALUES ("PR29_4","021_29_4","PRO","29","4","4","King-mi mo kantri epe-rupa surubaliare go kantri epe-rupa pa alia. Aa mudu king nipumi onaa luabuna mone oyaenu luabu nipu gina kone sua surubalia-dare kantri maoyaalia. ");
INSERT INTO kew_vpl VALUES ("PR29_5","021_29_5","PRO","29","5","5","Aa medame nipuna adami aa omeme pi agaa tea-dare nipuna bipa nipu raape kona ma-aya. ");
INSERT INTO kew_vpl VALUES ("PR29_6","021_29_6","PRO","29","6","6","Gore aa medame ni oyae pa gina kone salia-daare nipuna bipa nipu roape kona maaya. Go yapare aa medaloma epea peme aanu nimu raana raapu aawa yasa lo aalimi. ");
INSERT INTO kew_vpl VALUES ("PR29_7","021_29_7","PRO","29","7","7","Epe redepone aanumi mo aa naaranuna kedaa ritimi adoa go madaa kone waru sua raba mu aaeme. Epe yae wae yae lo waea peme onaame re ora waru namakuaawa pa puaeme. ");
INSERT INTO kew_vpl VALUES ("PR29_8","021_29_8","PRO","29","8","8","Paake pupitagi ne aanumi mo taun-para piri onaa waea peme rabu lo robaa-para radaa mapaaeme. Goa peme rabu mo epe kone redepoya imi aanumi nimu epe kone kateme rabu nimu lo robaa kuma mua epe-rupa pimi. ");
INSERT INTO kew_vpl VALUES ("PR29_9","021_29_9","PRO","29","9","9","Gore epe kone i aame aa meda kone wae i aa koso latalo palia-daare go aa nipu ora epe kone naia. Go aa nipuri pa ratu yawe kone agu sua nipumi wae agaa loa wae pora pamuape kone padane ia. ");
INSERT INTO kew_vpl VALUES ("PR29_10","021_29_10","PRO","29","10","10","Aa yagonu tumaomaeme aanumiri epe redepoya pimi aanu adoa rana na omeme. Go yapare mo epe redepoya pimi aanumi nimuna epe-rupa redepoya pimi aanu epe-rupa pirina kone imi. ");
INSERT INTO kew_vpl VALUES ("PR29_11","021_29_11","PRO","29","11","11","Kone redepone na-imi aanu nimuna ratu yawe kone sua agaa teme rabu pename ta. Go yapare epe kone imi aanumiri nimuna ratu yawe kone pa nimuna lo robaa-para ina nalapedepene gimeme. ");
INSERT INTO kew_vpl VALUES ("PR29_12","021_29_12","PRO","29","12","12","Yaa agaa ne aanumi mo kantri surube aa muduna kogono paliare mo yaa agaa ne aanu kantri-na ofisa kogono go wae aa luabumi palimi. ");
INSERT INTO kew_vpl VALUES ("PR29_13","021_29_13","PRO","29","13","13","Aa adaame onaa luabu ini maria aya nimumi oyae adenalo pea. Adaa Aa nipumi mo naraa aanu page kaloa nimu rabuniaaae aa medaloma page kata. ");
INSERT INTO kew_vpl VALUES ("PR29_14","021_29_14","PRO","29","14","14","Gore aa mudu king piraliade aame aa naraanuna epe redepone koso pagalia-dare oro yalo go ruruna king pa piruaalia. ");
INSERT INTO kew_vpl VALUES ("PR29_15","021_29_15","PRO","29","15","15","Neme nena nogo naaki tua epe mana te-daare nipumi epe kone mua epe makuae yae page mealia. Go yapare nogo naakimi oro yalo nipuna raana ratua aaliare nimuna agira yala polo ma-pitia. ");
INSERT INTO kew_vpl VALUES ("PR29_16","021_29_16","PRO","29","16","16","Waea pi aanumi kantri surubalimi rabu mo palimide wae yaenu ora adaa yalia. Go palimi rabu kantri surubalimi aanu nimu adaalupu napiralimi gore redepone aanumi adalimi gore ora peboteme. ");
INSERT INTO kew_vpl VALUES ("PR29_17","021_29_17","PRO","29","17","17","Gore neme nena naaki epe agaa lakeloa pirali rabu nipumi nena agaa pagoa epe-rupa pitia-dare epe kone sua pirali. ");
INSERT INTO kew_vpl VALUES ("PR29_18","021_29_18","PRO","29","18","18","Adaa Aa-me onaa epe agaa nakata pisa yalore nimu kone rado rado sua pirita peme. Go yapare aame Gote-na agaa ratua piralimiri raana raapu piralia. ");
INSERT INTO kew_vpl VALUES ("PR29_19","021_29_19","PRO","29","19","19","Go yapare nena kogono aa-para agu agaa te-dare neme nipu mada nama epeali. Pinawa neme agaa lakete pare nena agaa mada naratalia. ");
INSERT INTO kew_vpl VALUES ("PR29_20","021_29_20","PRO","29","20","20","Aa meda nipu epe redepone kone nasaliare gore nipu epe kone minalo marede yamina palo adamina. Go yapare aa meda epe agaa naloa pa mabebola teare gore wala maredepo yalape-rupa maralia. ");
INSERT INTO kew_vpl VALUES ("PR29_21","021_29_21","PRO","29","21","21","Nena kogono naaki ogesi rabu nipuna kone meape yae kalamama pua yali-daare oropere aa nona palia rabu nena oyae rayo mealia. ");
INSERT INTO kew_vpl VALUES ("PR29_22","021_29_22","PRO","29","22","22","Ratu ora aipapulu yawe aamere onaa aa radonu page ratu mayawaya. Goa pua mo ratu yawe aa nipu wae yae adaapu pea. ");
INSERT INTO kew_vpl VALUES ("PR29_23","021_29_23","PRO","29","23","23","Aa medame nipu ora aa ayo loa nipuna aako tua bi minasaliare nipuna bi mada rabuanialimi. Aa medame nipuna bi rabuniaawa aliare orope go aa nipu adaa bi mealia. ");
INSERT INTO kew_vpl VALUES ("PR29_24","021_29_24","PRO","29","24","24","Aa medame paake ne aa rabamealiare go aa nipu page paake ne aa nona palia. Go paliade yae amaa mea salia raburi nipu koso loa mada adialimi. Go yapare nipumi paga saliare Gote-me nipu ma-oyalia. ");
INSERT INTO kew_vpl VALUES ("PR29_25","021_29_25","PRO","29","25","25","Aa medame aa yagonu pala omaliare go pala re ena agona-para nipu pua piri nona pea. Go yapare aa medame Adaa Aa mada kone rulaliare nipu epe-rupa mada piralia. ");
INSERT INTO kew_vpl VALUES ("PR29_26","021_29_26","PRO","29","26","26","Aa adaapumi kantri rupara aa mudu pimi aanu omeme pulalo pemere nimu raana omena lo peme. Goa peme pare Adaa Aa-me niaana kone adoa niaana pemanu ora epe-rupa rumaawa niaa rabamea. ");
INSERT INTO kew_vpl VALUES ("PR29_27","021_29_27","PRO","29","27","27","Epe kone rulae aanumi waea peme aanuna kone adoa raana na-omeme. Go yapare mo waea peme aanumi epe pora rateme aanu adape page raana na-omeme. ");
INSERT INTO kew_vpl VALUES ("PR30_1","021_30_1","PRO","30","1","1","Go agaare Jakina si Agu-me Itele-para Ukal page lakesimi agaa remaa yade. ");
INSERT INTO kew_vpl VALUES ("PR30_2","021_30_2","PRO","30","2","2","Agu-me Gote ni raapu an pirua niri aa-da dia yade sa. Goa loa niri kone-daa waru na-isa. Nina konere ora wae sa. ");
INSERT INTO kew_vpl VALUES ("PR30_3","021_30_3","PRO","30","3","3","Ni epe kone nasu ora ni oto pare Gote nipu ora epe redepone aa yade. Pare neme nipu na-ade. ");
INSERT INTO kew_vpl VALUES ("PR30_4","021_30_4","PRO","30","4","4","So yaa-para aapi pua su-amaa wala ipisa pae? Go page po-ripu aapina kimi ripinaa misa pae? Go page so moae madaa aapimi ipa mapiraasa? Goa pua laplap mada oyae sua aapimi keapunisa? Abia go ia su luabu apimi puri mapalaawa robo ma-sasa? Nipuna biri aapiya? Nipuna si-ri aapi ya? Go yaenuri nere makuae pae? ");
INSERT INTO kew_vpl VALUES ("PR30_5","021_30_5","PRO","30","5","5","Oyae luaburi Gote nipuna saa rabu opesa. Gote-na Agaare ora ria yade. Goa pua nipu piri peme onaare nipumi kepopu runane yawa surubea. Gore mo etane epa aalialo ralubi maditema-rupa mada nipuna agaa-me niaa rigitaniaawa. ");
INSERT INTO kew_vpl VALUES ("PR30_6","021_30_6","PRO","30","6","6","Nena agaa meda loare gore Gote-na agaa yade pi nalape. Gote-me orope ne koso lalia rabu go aa-re waea pi aa yade teme. ");
INSERT INTO kew_vpl VALUES ("PR30_7","021_30_7","PRO","30","7","8","Gote nere oyae laapo agaa mulalo pi-ga neme go yae lapo giaina. Oro yalo ni go su-amaa pirualua raburi yaa agaa-para makirae kone luabu gimanowa. Neme niri amope-para aa naraa page namapirainalo-pi. Dia nina nape eta robo-para giape. ");
INSERT INTO kew_vpl VALUES ("PR30_9","021_30_9","PRO","30","9","9","Neme oyae ora adaapu salua rabu ne masaa rilawa. Adaa Aa-nere aapi yapae toa? Ni naraa piralua raburi neme paake pupitagi noa waenu pualua rabu nina Gote Adaa nena bi ma-oyaluada go aaene lalo. ");
INSERT INTO kew_vpl VALUES ("PR30_10","021_30_10","PRO","30","10","10","Neme surube aa piri pua kogono naakina bi napua ma-oyaape. Nipuna kogono aana bi ma-oyaali rabu Gote lorapalia rabu nipuna Gote-me ne talialo lalo. ");
INSERT INTO kew_vpl VALUES ("PR30_11","021_30_11","PRO","30","11","11","Onaa medalome goa teme: Gote-me nimina ama aapanu ma-bebolatina teme. ");
INSERT INTO kew_vpl VALUES ("PR30_12","021_30_12","PRO","30","12","13","Onaa madalomame nimu waea meda napema teme pare nimu amulu papubaaya-pulu Gote-na ini agaa madaa nimuna pupitagi wae ia-daa adea. Onaa medalomame nimu ora epe ta kone sua pa onaa meda otaa kone imi. ");
INSERT INTO kew_vpl VALUES ("PR30_14","021_30_14","PRO","30","14","14","Onaa medalomame naraa onaanu-para waea agu pulalo peme. Gore nimuna agaa abulu-para rai napi eke aae ayaa-pulu nimumi mo naraa onaana oya mulalo peme. ");
INSERT INTO kew_vpl VALUES ("PR30_15","021_30_15","PRO","30","15","15","Yaapi nea paakana oge nogo laapo pia. Nipuna biri gupa teme: Ni gi ni gi teme. Oyae maala-me nimuna raana mada na-pora poalia. ");
INSERT INTO kew_vpl VALUES ("PR30_16","021_30_16","PRO","30","16","16","Pandanere aba ome aanuna tapa-para aeme. Laapore ore aani raapu patea pare naaki padaa napia. Repore sumi ipa adaapu mea pare ipa waru name. Maalare kone ia repena sulaame oyae luabu rea pare naare nona pea. Go yaere ora luabu madaa naniminaata. ");
INSERT INTO kew_vpl VALUES ("PR30_17","021_30_17","PRO","30","17","17","Gore aa medame orena ama page aaraa lapona agaa rasini omalia rabu go lapome nipu mada narogaalipi. Go rabu yaa itaa-para yaa aroka roka ipua ini epa rasu nabalipi. ");
INSERT INTO kew_vpl VALUES ("PR30_18","021_30_18","PRO","30","18","18","Oyae ipa maala ora rado pi aaene yae yapulu neme ora mada na-makuaato. ");
INSERT INTO kew_vpl VALUES ("PR30_19","021_30_19","PRO","30","19","19","Pandanere yaa ita nipu so yaa madaa awaya. Laapore paakare nipu aana madaa pamea. Repore ipa sipi-ri adaa ipa solowara madaa pameade. Maalare aa-me ona raname omemede-rupa pipi. ");
INSERT INTO kew_vpl VALUES ("PR30_20","021_30_20","PRO","30","20","20","Oname nipuna aa gimoa rado raapu patia raburi nipumi ipa mea radepe rubua goa ta. Neme yae meda napawade ta. ");
INSERT INTO kew_vpl VALUES ("PR30_21","021_30_21","PRO","30","21","21","Go su-amaare yae maala wae kone ia-pulu go sumi go kone adoa gime waru omea pururu ora waru omea. ");
INSERT INTO kew_vpl VALUES ("PR30_22","021_30_22","PRO","30","22","22","Go pemeare go-rupa: Kogono naaki naara yapare wala king kogono pea. Aa medame kone nasua eta ora adaapu nea. ");
INSERT INTO kew_vpl VALUES ("PR30_23","021_30_23","PRO","30","23","23","Ona meda nipu aa nape pa piruaawa aba ripia aame gime ona yapare orope rumaeme. Ona nipuna surube onana kogono nipumi mulalo oyo moyo ari piralipi. ");
INSERT INTO kew_vpl VALUES ("PR30_24","021_30_24","PRO","30","24","24","Go su-amaa yae maala raa-para pia pare nimuna kone ora epeta: ");
INSERT INTO kew_vpl VALUES ("PR30_25","021_30_25","PRO","30","25","25","Raguta puri na-ia pare eta dia yalia rabu nape eta waru amupu imi. ");
INSERT INTO kew_vpl VALUES ("PR30_26","021_30_26","PRO","30","26","26","Yapa wamea page aana-para pimi pare nimu puri na-ia. Goa peme pare nimuna adare aana rulalo peme. ");
INSERT INTO kew_vpl VALUES ("PR30_27","021_30_27","PRO","30","27","27","Oboro nipuna aa muduri napia pare nimu uliri pua pameme. ");
INSERT INTO kew_vpl VALUES ("PR30_28","021_30_28","PRO","30","28","28","Oge kaau niaame kimi ripinaawa mealimare ora yapare nimu aa mudu king-na adapara pimi. ");
INSERT INTO kew_vpl VALUES ("PR30_29","021_30_29","PRO","30","29","29","Oyae malare padane-para wata tina pameme: ");
INSERT INTO kew_vpl VALUES ("PR30_30","021_30_30","PRO","30","30","30","Kira mena me puri pabea-pulu pa kira anune yaenu medaloma rabuaaya. Nimu pora pameme raburi oyae meda madaa paala meme. ");
INSERT INTO kew_vpl VALUES ("PR30_31","021_30_31","PRO","30","31","31","Yaa kuta kosapeame nipuna aalu musaawa pora pamea. Lione mena ora aari oyae meda madaa palame naomoa pare ora nipuna puri rado aaya. Meme mena yadaapunu page king medame nimu mada natalimi. ");
INSERT INTO kew_vpl VALUES ("PR30_32","021_30_32","PRO","30","32","32","Gore neme maeyae kone sua waeanu pulalo paliri nena bi naminaasape pare agaa gimoa yalame omape. ");
INSERT INTO kew_vpl VALUES ("PR30_33","021_30_33","PRO","30","33","33","Gore neme mena gawana adu mua mea pereke pereke te rabu bata mada autea. Aa medana ini kadu mataliri ratu yawalia. Gore yada rekalia. ");
INSERT INTO kew_vpl VALUES ("PR31_1","021_31_1","PRO","31","1","1","Go agaa-re King Lemuel-na agaa. Agime agaa mana loa epe kone minalo lakesa. ");
INSERT INTO kew_vpl VALUES ("PR31_2","021_31_2","PRO","31","2","2","Nina naaki nere nina madiawa-pulu neme ne raaname waru ome. Neme Gote agaa misu rabu ni gisa-da madisu. Neme ake lano ya? ");
INSERT INTO kew_vpl VALUES ("PR31_3","021_31_3","PRO","31","3","3","Neme ona meda nayoloa money page nakaloa nena puri dia yalia. Gore akoloya king-nu ma-oyaeme-daa go agaa lagialo. ");
INSERT INTO kew_vpl VALUES ("PR31_4","021_31_4","PRO","31","4","4","Lemuel-yo king nimi ipa waini na-nape. Nimumi bia nape kone nasalepape. ");
INSERT INTO kew_vpl VALUES ("PR31_5","021_31_5","PRO","31","5","5","Gore nimimi ipa agu nalimi raburi rekana agaa ruguloa mo aa naraanu-para epea meda mada napalimi. ");
INSERT INTO kew_vpl VALUES ("PR31_6","021_31_6","PRO","31","6","6","Pa bia-para waene lapo-re omape onaa-para kedaa adaapu rini onaana nape eta yade. ");
INSERT INTO kew_vpl VALUES ("PR31_7","021_31_7","PRO","31","7","7","Go piane onaare ipa nalame omalimiri pa nalimina. Yapare nimu naraa pimi onaa oyae rudu yoa kedaa riapere kone rugulaawa nalimina. ");
INSERT INTO kew_vpl VALUES ("PR31_8","021_31_8","PRO","31","8","8","Kedaa madaa nariape kepele pi onaare rabameape agaa lape. Goa pua mo naraanumi koso teme rabu raba meape-na puri waru pabape. ");
INSERT INTO kew_vpl VALUES ("PR31_9","021_31_9","PRO","31","9","9","Neme koso te rabu mogo onaanu epe-rupa redepoya pagape. Goa pua neme mo naaranu raba mua surubape. ");
INSERT INTO kew_vpl VALUES ("PR31_10","021_31_10","PRO","31","10","10","Go yapare aame ona epe kone-i rumaatalo pe? Ora yapare kalai pua asa palia. Go piaene ona-na yotore gol-na yoto pea-rupa mada yade. ");
INSERT INTO kew_vpl VALUES ("PR31_11","021_31_11","PRO","31","11","11","Go piaene ona nipuna aanimi mo onana pea luabu epea peada aba adea. Goa pea-pulu ona-me nipu raba mealia rabu mo aa nipu oyae ora adaapu salia. ");
INSERT INTO kew_vpl VALUES ("PR31_12","021_31_12","PRO","31","12","12","Go ona-me aani-para oro yalo epea agu pea. ");
INSERT INTO kew_vpl VALUES ("PR31_13","021_31_13","PRO","31","13","13","Nipumi laplap wariape ope adaapu page pusua laplap adaapu wari pea. ");
INSERT INTO kew_vpl VALUES ("PR31_14","021_31_14","PRO","31","14","14","Nimu luabumi eta ora adaapu waru imi. Gore akolo-ya? Go oname eta ora su adaalu-para mea epea. Gore mo adaa sipi-numi eta madita pemede-rupa mada mea epea. ");
INSERT INTO kew_vpl VALUES ("PR31_15","021_31_15","PRO","31","15","15","Epe onamere yapi abi nane aina eta nipuna onaa raapu nape aba yawea. Goa puare nipuna kogono onana pape kogono robo su kata. ");
INSERT INTO kew_vpl VALUES ("PR31_16","021_31_16","PRO","31","16","16","Mo puri pane oname su kabolalore su ora waru adoa kabea. Goa pua orope mone muare repena waene maapu kaboa poaaya. ");
INSERT INTO kew_vpl VALUES ("PR31_17","021_31_17","PRO","31","17","17","Nipu oro meda gime naomea oro yalo puri paloa kogono puaaya. ");
INSERT INTO kew_vpl VALUES ("PR31_18","021_31_18","PRO","31","18","18","Nipuna labana wiki ora waele waru rubia epeta rabu laba waru roaaya. Go laba roaina ribaa ruma rumane nipuna pea bisinisi raayo pua epe ta-daa adea. ");
INSERT INTO kew_vpl VALUES ("PR31_19","021_31_19","PRO","31","19","19","Go piaaene oname ope waria nipuna bipa laplap rabuta. ");
INSERT INTO kew_vpl VALUES ("PR31_20","021_31_20","PRO","31","20","20","Gore nipumi mo naraa onaa adoa oyaenu rudu teme rabulu kata. ");
INSERT INTO kew_vpl VALUES ("PR31_21","021_31_21","PRO","31","21","21","Gore yai radaki adaa lopea rabu page nipuna aani nogo naaki yada dia kone ia. Gore akolo ya? Nipumi mo laplap ora epe pepena pi yae rabuta-pulu yada dia kone ia. ");
INSERT INTO kew_vpl VALUES ("PR31_22","021_31_22","PRO","31","22","22","Goa pua nipuna ada-para sape balaket oyae page nipuna bipa rabuta-pulu nimuna ada-para epeta. Goa pua laplap kane-para yakopi lapo rata mua nipuna yamape oyae warita. ");
INSERT INTO kew_vpl VALUES ("PR31_23","021_31_23","PRO","31","23","23","Gore mo adare-para piri aa mudunumi nipu adaa bi kateme. Nipuna aani page mo aa mudu meda yapulu goa peme. ");
INSERT INTO kew_vpl VALUES ("PR31_24","021_31_24","PRO","31","24","24","Oro yalo mo oname epe mamina waria aako lete page waru warita. Goa pea-pulu mo bisinisi peme onaame epa kabeme. ");
INSERT INTO kew_vpl VALUES ("PR31_25","021_31_25","PRO","31","25","25","Nipuna mogo pea kogono madaa mo ona ora epeta kone sua mo ona kone mapiraawa go piane ona yade teme. Go orope epaliade yaere nipu palame naomea. ");
INSERT INTO kew_vpl VALUES ("PR31_26","021_31_26","PRO","31","26","26","Nipumi onaa kogono mogeatalo palia-dare pawasi agaa loa pea. Nipuna ta agaa luaburi epe kone-para makuae yae lapo ora waru rubita. ");
INSERT INTO kew_vpl VALUES ("PR31_27","021_31_27","PRO","31","27","27","Nipuna ada-para oyae surubolalo palia raburi gime na-omea. Goa pua epe puri pane kogono pea. ");
INSERT INTO kew_vpl VALUES ("PR31_28","021_31_28","PRO","31","28","28","Ora epeta ora epeta gore niaana ama teme. Mo ona nipuna nogo naakimi goa teme. Nipuna animi ona-na bi ora waru minasaawa goa ta. ");
INSERT INTO kew_vpl VALUES ("PR31_29","021_31_29","PRO","31","29","29","Niaana taun-para page niana oge adarenu-nini page go piane ona adaapu pimi: Pare neme go ona luabu rabuaye teme. ");
INSERT INTO kew_vpl VALUES ("PR31_30","021_31_30","PRO","31","30","30","Ona padaneme niaa epe rede pi agaa lagialia pare nipuna peare rado piane. Ona ora epe yalia page pinawa. Nipu oro yalo gorupa mada napitia. Goa pea-ga niaame Adaa Aa-na rolo-para pia onana bi minasamina. ");
INSERT INTO kew_vpl VALUES ("PR31_31","021_31_31","PRO","31","31","31","Niame ona nipuna epe kogono adoa nipuna epe kone page rumaawa nipuna bi minasaeme. ");
INSERT INTO kew_vpl VALUES ("EC1_1","022_1_1","ECC","1","1","1","King Devit-na si Jerusalem su aa mudu makuae aa pirua nipumi go buku madaa remaa tu isa. ");
INSERT INTO kew_vpl VALUES ("EC1_2","022_1_2","ECC","1","2","2","Go makuae aame gupa sa: Oyae luaburi re naiapulu waru yaeda dia. ");
INSERT INTO kew_vpl VALUES ("EC1_3","022_1_3","ECC","1","3","3","Niaame maali yalo kalaipua kogono pema yaena abulu ake mema pae? Kogono kalaipu pema rabu go-na ini ake mema pae sa? ");
INSERT INTO kew_vpl VALUES ("EC1_4","022_1_4","ECC","1","4","4","Onaa omeme rabu kagaa nogo-naaki ma-aditimi mo omeme onaana pada gonumi meme sa. Go yapare go su-re pa gorupa agu pa suaya. ");
INSERT INTO kew_vpl VALUES ("EC1_5","022_1_5","ECC","1","5","5","Naare raa ipua wala pabola popea gore wala ekeraa-nane wala epaa opeaa. Oro yalo naare epaa rala wala puala pua komome omea. ");
INSERT INTO kew_vpl VALUES ("EC1_6","022_1_6","ECC","1","6","6","Poripu mo relapo rayo nane maowa maowa pua wala pereke tua epea-nane pea. ");
INSERT INTO kew_vpl VALUES ("EC1_7","022_1_7","ECC","1","7","7","Ipa luaburi mo solowara madaa puaa rubita pare ipa solowara abi narubita. Gore mo ipa nipu yokoa epea-para wala pua go ipa nipu wala solowara madaa wala epea. ");
INSERT INTO kew_vpl VALUES ("EC1_8","022_1_8","ECC","1","8","8","Niaame go su-amaa ia yaenu mada kone mapiraawa yapare gime ora wala omema. Go maditima gi-re nalapedepetema. Niaame oyae luabu ado pa agaa luabu pa pagema. Pare go pema luabumi niaa mada narabamealia. ");
INSERT INTO kew_vpl VALUES ("EC1_9","022_1_9","ECC","1","9","9","Ora abade oyae medaloma opesa yaenuri wala orope page wala opalia. Abade aanu mi oyae medaloma pisimiri wala orope page palimi. Go su-amaa-re kagaa yae meda wala naopalia. ");
INSERT INTO kew_vpl VALUES ("EC1_10","022_1_10","ECC","1","10","10","Aa medalomame go yaere niaa naade kagaa yaelo gupa teme. Goyapare yae ora abade isa yae pa ina na-adoa gupa teme. Go yaere niaana amame niaa abi namadini rabu go yae isa. ");
INSERT INTO kew_vpl VALUES ("EC1_11","022_1_11","ECC","1","11","11","Aa medalomame aba niaana akuanu pirisimi rabu isa yaenu madaa kone na-niminaeme. Oyae luaburi abia niaa go piramona epea pare go kone rumaa niminape page mareme. ");
INSERT INTO kew_vpl VALUES ("EC1_12","022_1_12","ECC","1","12","12","Niri waru makuae aa yapulu ni Israel onaana aa mudu king pirua neme nimu surube. ");
INSERT INTO kew_vpl VALUES ("EC1_13","022_1_13","ECC","1","13","13","Gore neme go su-amaa ia yae luabu adoa waru makualua kone sua re adesatalo pua adaa radaapi kogono pe. Gopea pare Gote-me go geaa kogonore ora adaa kedapi kogono yade. ");
INSERT INTO kew_vpl VALUES ("EC1_14","022_1_14","ECC","1","14","14","Neme go su-amaa ia yae luaburi ora aba ado kirite pare go oyae luaburi ora re naia. Aa medame poripu ratua ripinaatalo pea-rupa mada. ");
INSERT INTO kew_vpl VALUES ("EC1_15","022_1_15","ECC","1","15","15","Oyae paaki paliare niaame wala ma-redepo yape-rupa madadia. Oyae meda nasaliare gore niaame mada nadipialima. ");
INSERT INTO kew_vpl VALUES ("EC1_16","022_1_16","ECC","1","16","16","Ni adayoa makuae yae waru meawa-na kone sua mo Jerusalem supara pirisimi aa mudunu luabu rabuayo kone gorupa i. Ni makuae yae waru mua epe kone page waru i. ");
INSERT INTO kew_vpl VALUES ("EC1_17","022_1_17","ECC","1","17","17","Neme ora abade epe kone-na re para maeyae kone para, eyaa kone para makuaeyae para nimuna peme kone rado rado mea makuatalo kalai pe. Pare neme poripu ratamea pe rupa mada. ");
INSERT INTO kew_vpl VALUES ("EC1_18","022_1_18","ECC","1","18","18","Gore ora agaa riaa aa meda nipu amaa-yo makuae yae waru iare nipu madaa wae kone adaapumi ripinita. Goa puaa nipuna makuae yae ora adaa yalia raburi gore nipuna lo robaa kedaa page ora adaa yalia. ");
INSERT INTO kew_vpl VALUES ("EC2_1","022_2_1","ECC","2","1","1","Neme epe kone sua pora pamuape madaa kalai waru pe. Nina koneme niminae yae luabu pu kiritalua kone sua pisu pare go pea re waru nai madaa pe. ");
INSERT INTO kew_vpl VALUES ("EC2_2","022_2_2","ECC","2","2","2","Giri ne agaa-re maeyae kone meda madaa epeta kone sua pama pisuya. Goa pua epe pedo pi koneme niaa narabamea. ");
INSERT INTO kew_vpl VALUES ("EC2_3","022_2_3","ECC","2","3","3","Epe kone-na re asapulalo neme kalai waru pe. Goa peada neme ipa waene noa epe kone mulalo kalai waru pe. Oge rudupu yapidi-na onaanu su-amaa pimi rabu epe-rupa pirina kone sua asapuayo. Nimu ora epe pora mea walawe kone sua pe. ");
INSERT INTO kew_vpl VALUES ("EC2_4","022_2_4","ECC","2","4","4","Neme adaa ada adaapu pua kogono adaapu pisude. Waene maapu page sasude. ");
INSERT INTO kew_vpl VALUES ("EC2_5","022_2_5","ECC","2","5","5","Neme e-maapu adaapu sawa epe redepi repena ini medaloma wai poayo. ");
INSERT INTO kew_vpl VALUES ("EC2_6","022_2_6","ECC","2","6","6","Neme go repena wai mada koyape ipa naaku page medaloma robo i. ");
INSERT INTO kew_vpl VALUES ("EC2_7","022_2_7","ECC","2","7","7","Neme kogono onaa adaapu kabamua, naa kogono painalo mua kogono pina-to. Go kogono pae onaana si wanenu page luabu nina kogono onaa pina-to. Jerusalem supara pateme aanumi mena gawa sipisipi go neme punitu-rupa adaapu meda napunitimi. ");
INSERT INTO kew_vpl VALUES ("EC2_8","022_2_8","ECC","2","8","8","Neme silpa golo page nina ada kagure luabu-nini mua pa kantri luabu-para page me. Mo ada kagurena king rado rado pimi aanuna silpa golo-nu page luabu neme me. Mo onaanu page neme raana omanalo yasa lape adaapu teme. Raana omapena ona page adaapu rumaayo. ");
INSERT INTO kew_vpl VALUES ("EC2_9","022_2_9","ECC","2","9","9","Neme go yaenu luabu mea suare ni adaa aa mudu pi. Abade mo Jerusalem supara aa mudu pirisimi aanu nimumi oyae go neme i-rupa meda na-isimi. Ni ora makuae aa go pirissu-rupa pa pi. ");
INSERT INTO kew_vpl VALUES ("EC2_10","022_2_10","ECC","2","10","10","Nina konepara epea yaenu rayo nagimede dia. Neme oyae meda epame ome yaenuri gore ora meda. Neme aba pama pisude kogono madare raana waru omoa go ome raanare mo pe kogono-na yoto go yade. ");
INSERT INTO kew_vpl VALUES ("EC2_11","022_2_11","ECC","2","11","11","Go yapare neme mo kalai waru pua pe kogono aba adano. Mo puayo kogono luaburi waru yaeda diayapulu re naiya. Gore aa medame poripu ratu ripinatalo pe nona pea. ");
INSERT INTO kew_vpl VALUES ("EC2_12","022_2_12","ECC","2","12","12","Neme yae luabu pukirite-ga aa medame ni alopawa aa mudu king pitia-daare nipumi pa i kogono-re ake palia pae? Oyae meda neme napia meda mada napalia. Goa pea-daa neme epe konena pora page wae kone-na pora page adolalo pora asapuayo. ");
INSERT INTO kew_vpl VALUES ("EC2_13","022_2_13","ECC","2","13","13","Neme kone go luabu aba ado kiritua goa kone i. Epe kone epeta, wae kone, bebo kone paa-me riba rabuaniaya. ");
INSERT INTO kew_vpl VALUES ("EC2_14","022_2_14","ECC","2","14","14","Makuae aanumi pora waru adoa gore epeta gore ota loa waru adoa makuaeme. Goyapare maeyae aanumi ribaane pora waru rateme. Neme oyae meda ade, gore gupa: mo makuae aa nipuna kogono pu kiritea raburi maeyae aa-na kone-para makuae aana kone lapo padane pea. ");
INSERT INTO kew_vpl VALUES ("EC2_15","022_2_15","ECC","2","15","15","Maeyae aanu madaa popea konere ni madaa page gorupa epolalo pia kone i. Goa pea-ga nina makuae yae-me niri akea pua rabamealia pae? Go madare kone wala gorupa niminaayo. Go i kone luabu waepara pawana kone i. ");
INSERT INTO kew_vpl VALUES ("EC2_16","022_2_16","ECC","2","16","16","Oropere onaa luabumi niaa kone rugulaawa gimalimi. Niaa maeyae aanu page makuae aanu page kone rugulaawa gimalimi. Omalimi rabu maeyae aa para makuae aa-laapo mada omalipi yade. ");
INSERT INTO kew_vpl VALUES ("EC2_17","022_2_17","ECC","2","17","17","Goa pea-pulu go su-amaa ia yae luabumi ni kedaa waru mea geapulu nina kone wasupa-me gi waru pea. Aame poripu ratu ripinatalo pea-rupa mada yapulu su-amaa pema yae luabu re meda naiya. ");
INSERT INTO kew_vpl VALUES ("EC2_18","022_2_18","ECC","2","18","18","Neme go kalai pua pama epawade yae rayo gimaluame aba makuaayo. Gore ni alopaliade aame go yaenu rayo nipumi mealia. Goa peapulu go yae luabu mada ni gi ora waru pea. ");
INSERT INTO kew_vpl VALUES ("EC2_19","022_2_19","ECC","2","19","19","Nina pada mealia aa-re makuae aame mealia pae maeyae aame mealia palo ni waru namakuaayo. Goyapare neme kalaipua radaa pina misude yaenu surbalia. Pare go kone luabuna re page ora meda naia. ");
INSERT INTO kew_vpl VALUES ("EC2_20","022_2_20","ECC","2","20","20","Goyapare neme go kalapi kogono madaa lo robaa kedaa waru me. ");
INSERT INTO kew_vpl VALUES ("EC2_21","022_2_21","ECC","2","21","21","Neme kogono pulalore nina epe kone para nina makuayae para kogono pape kina purimi mua salimi oyae-re, kogono napeme onaa katea. Gore remeda naiya pulu gore wae yae ria. ");
INSERT INTO kew_vpl VALUES ("EC2_22","022_2_22","ECC","2","22","22","Oroyalo niaame kone ora adaapu ima pare gome niaa epe yae meda meagea pae? ");
INSERT INTO kew_vpl VALUES ("EC2_23","022_2_23","ECC","2","23","23","Niaame go su-amaa aema raburi niaa oyae madaa lo robaa kedaa adaapu mea gea. Goame ribaa niaa u patema rabu aalu kada-para kone kone adaapu mema. Go kone page ora re waru naia. ");
INSERT INTO kew_vpl VALUES ("EC2_24","022_2_24","ECC","2","24","24","Niaame eta ipa noa niana pema kogonona rana omema. Go page neme ade rabu Goteme gea. ");
INSERT INTO kew_vpl VALUES ("EC2_25","022_2_25","ECC","2","25","25","Gote-me niaa eta nagulapea-daare akea pula pema pae? ");
INSERT INTO kew_vpl VALUES ("EC2_26","022_2_26","ECC","2","26","26","Onaa medaloma Gote raaname omeme onaare nipumi epe kone kalo makuayae kalo rana kata, goyapare wae yae peme onaare Goteme oyae kiritawa inaloa Gote para epea peme onaa kanata. Gore re meda naiya poripu ripinatalo ratamea pe rupa mada. ");
INSERT INTO kew_vpl VALUES ("EC3_1","022_3_1","ECC","3","1","1","Oyae luabu go su-amaa opeare nipuna opape yapidina opea. ");
INSERT INTO kew_vpl VALUES ("EC3_2","022_3_2","ECC","3","2","2","Gote-me niaa onaa go su-amaa madiape di gua wala omape di page gea. Eta wai poape yapidi page gua eta naape awape yapidi page gea. ");
INSERT INTO kew_vpl VALUES ("EC3_3","022_3_3","ECC","3","3","3","Gote-me onaa yaina maetape page aa tumaope yapidi page luabu nipumi saaya. Nipumi oyae maoyaatua wala maepeape yapidi page nipumi ama pea. ");
INSERT INTO kew_vpl VALUES ("EC3_4","022_3_4","ECC","3","4","4","Nipumi re lape yapi di page giri lape yapidi page nipumi ama saaya. Odo omape di page yasa pawa lape di page saaya. ");
INSERT INTO kew_vpl VALUES ("EC3_5","022_3_5","ECC","3","5","5","Nipumi onaa rapu patape yapidi page saaya rekena sua gimape yapidi page saaya. Ona ripinape page ona naorape yapidi page saaya. ");
INSERT INTO kew_vpl VALUES ("EC3_6","022_3_6","ECC","3","6","6","Oyaenu alupae asapape yapidi page oyae alupape yapidi page saaya. Oyae waru amagepu sape di page saya oyaenu yolo rubape di page saaya. ");
INSERT INTO kew_vpl VALUES ("EC3_7","022_3_7","ECC","3","7","7","Laplap marae riripia wala rabulape di page saaya. Agaa lorape yapidi page agaa lape di page saaya. ");
INSERT INTO kew_vpl VALUES ("EC3_8","022_3_8","ECC","3","8","8","Di mo robaa kalape ao para di mo ratu yawape ao saaya. Yada pape page gimape yapidi page saaya. ");
INSERT INTO kew_vpl VALUES ("EC3_9","022_3_9","ECC","3","9","9","Kalaipu kogono peme aanu nimuna meape epe yaere ake meme pae? ");
INSERT INTO kew_vpl VALUES ("EC3_10","022_3_10","ECC","3","10","10","Gote-me niaa repara epenata kedaare neme aba ade. ");
INSERT INTO kew_vpl VALUES ("EC3_11","022_3_11","ECC","3","11","11","Gote-me oyae luabu ora epe rupa openata. Nipumi niana kone marekaawa oyae raayo page abia opea yae abade opesa yaenu luabu makua adamonalo kone gea. Goyapare Gote nipuna pea luaburi abade page abia page niaame na-adape-rupa pisa. ");
INSERT INTO kew_vpl VALUES ("EC3_12","022_3_12","ECC","3","12","12","Neme go mada kone padane sua epe redepota adoa pe. Go epeta konere gupa. Niaame go su-amaa pima raburi kone padane sua pedo waru pua piramina. ");
INSERT INTO kew_vpl VALUES ("EC3_13","022_3_13","ECC","3","13","13","Eta ipa nalima raburi raana rapu awa namina. Goa palimadare Gote nipumi pa ode gi yae meda madaa rana ora waru omoa namina. ");
INSERT INTO kew_vpl VALUES ("EC3_14","022_3_14","ECC","3","14","14","Gote nipuna peanu senisi napea-daa neme waru makuaayo. Dia go piane aure oroyalo pa su-aalia. Gote nipumi pulalo peare aa medame makibumawa mada napalia. Gote nipuna pea rayore medame na-alopalimi. Gote-me go pisare onaa luabu nipuna rolo-para pirinalo pisa. ");
INSERT INTO kew_vpl VALUES ("EC3_15","022_3_15","ECC","3","15","15","Abia go peayaenuri abade page opesa. Yaenu orope paliade-nu page abade pesa yaenu. Gote-me abade pisa yaenu diana kone naia. Dia go yaenu wala opena kone ia. ");
INSERT INTO kew_vpl VALUES ("EC3_16","022_3_16","ECC","3","16","16","Neme ade rabu go su-amaa yae meda gupa iya. Onaame epe kone epe pora ratua apere gimeme. Dia nimumi wae pora ora rateme. ");
INSERT INTO kew_vpl VALUES ("EC3_17","022_3_17","ECC","3","17","17","Goteme onaanu koso latalo palia raburi neme gupa kone saayo. Epea pi waea pi onaa raayo ado kiritua rumalia kone i yapi medame. ");
INSERT INTO kew_vpl VALUES ("EC3_18","022_3_18","ECC","3","18","18","Gore Gote nipumi niaa ko tulalo pea kone i. Niaa aanu-ri pa yaa yapanu rupa yade. ");
INSERT INTO kew_vpl VALUES ("EC3_19","022_3_19","ECC","3","19","19","Niaa aanuna diayape pora-re yaa yapana di iya-rupa mada yade. Yaa yapanu page omeme raburi niaa onaa-rupa mada omeme. Yaa yapanu page mena oyaenu komo meme-rupa niaa onaanu page komo mema. Go yaenu luabu mada kagaa pirape kone wasupa pia. Yaa yapa aarina kone wasupa-me onaana kone wasupa narabua niaya. Nipuna kone wasupa lapo rata pa yae meda rupa yade. ");
INSERT INTO kew_vpl VALUES ("EC3_20","022_3_20","ECC","3","20","20","Gote-me su mua warisa-pulu nipu omalipi raburi gore nipu rata wala su autepe. ");
INSERT INTO kew_vpl VALUES ("EC3_21","022_3_21","ECC","3","21","21","Aa medalomame gupa kone imi. Onaana wasare so yaapara pea raa yaa yapa mena aarinuna wasare no su-para pea kone gupa imi. Go yaena re luaburi aapimi makuaaya? ");
INSERT INTO kew_vpl VALUES ("EC3_22","022_3_22","ECC","3","22","22","Neme ade pare aame nipuna pea kogono rana omape pora padane gore waru yae. Goamere ora rabuaya. Niaa omalima rabu orope ake palia lo medame mada lagialiaya? ");
INSERT INTO kew_vpl VALUES ("EC4_1","022_4_1","ECC","4","1","1","Neme wala ade pare go yaana rolopara pimi onaada wae aurime surubea. Waeya pame onaa na re ipa adawa. Goa pea pare nimu rabameape aa page meda dia. Puripane gavman-me page nimu narabamea. Mo gavmanme wae aanu rabamua epe onaa gimea. ");
INSERT INTO kew_vpl VALUES ("EC4_2","022_4_2","ECC","4","2","2","Neme onaa aba omeme-re epeta kone go-rupa i. Akoloya niaa go abi naome pa pima onaa-re keda radorado-na rolo para pa pima-daa laalo. ");
INSERT INTO kew_vpl VALUES ("EC4_3","022_4_3","ECC","4","3","3","Onaa medaloma go su-amaa abi namaditimi nuri nimu wini pina. Nimu go su-amaa peme wae yaenu luabu abi naademe-pulu ora epeta. ");
INSERT INTO kew_vpl VALUES ("EC4_4","022_4_4","ECC","4","4","4","Onaame kalaipu kogono pua oyae medaloma waritimi neme ade. Gona rere nimuna adami aanumi oyae adaapu imi kone sua go kone mada peme. Goa pua nimuna adami aanumi adoa padanepara eperupa piramona kone sua maeyae kone mada peme. Gore aa medame poripu ripinatalo peme-rupa mada. ");
INSERT INTO kew_vpl VALUES ("EC4_5","022_4_5","ECC","4","5","5","Kiaarakepea pimi aanupara gupa teme. Nipu maeyae aa pirua puri diayalia rabu omalia teme. ");
INSERT INTO kew_vpl VALUES ("EC4_6","022_4_6","ECC","4","6","6","Pina-ga oyae ogesi mada page kone perekea lo robaa padanepara sua kogono pamina. Aame poripu ratu ripinatalo pea rupa pama kogono palialo lalo. ");
INSERT INTO kew_vpl VALUES ("EC4_7","022_4_7","ECC","4","7","7","Neme re waru nai kone meda adesude-re gore gupa. ");
INSERT INTO kew_vpl VALUES ("EC4_8","022_4_8","ECC","4","8","8","Aa meda nipu ame-aaraa page na-piri nipu padane awaya. Nipuna si page napia pare oro yalo kogono agu pala pirina pea. Nipu oyae ora adaapu ia pare ogesi page namea. Nipumi mogo oyae mada kone sua oroyalo kogono puri paloa pea. Neme epe raana omape di page meda naia-ga akeaene kalae pe pae kone iya. Nipuna go oyaenuri apimi mealia loa pea. Go piaene aana kone oyoa nipuna pulalo pea oyae luabu ini namadini oyalia. ");
INSERT INTO kew_vpl VALUES ("EC4_9","022_4_9","ECC","4","9","9","Aa laapo piralipiri ora yapare aa padane agurapo piraliare ota. Aa laapo-me upayoa kogono palipiri nipuna kogono ora epealia. ");
INSERT INTO kew_vpl VALUES ("EC4_10","022_4_10","ECC","4","10","10","Aa nipuna yago meda lopaliadare mo nipuna yago medame mada rabamealia. Pare aguraapo-ae aa madaa odo ora waru palia. Nipu rabameape aa meda diayalia. ");
INSERT INTO kew_vpl VALUES ("EC4_11","022_4_11","ECC","4","11","11","Nipu upame omalipiri, padanepara patalipi-pulu nipu kekapu palia. Go yapare aa nipu agurapo pirualia raburi nipuna topara kekapu mada paliaya? ");
INSERT INTO kew_vpl VALUES ("EC4_12","022_4_12","ECC","4","12","12","Aa padaneme iaa rapu yada mada pu patalia pae? Aa laapo raapure yada mada palipi. Pare aa padane rapu mada dia. Opeamape ipa repo kopatawa yoteme raburi puri adaape salia pulu go ope mada narugutea. ");
INSERT INTO kew_vpl VALUES ("EC4_13","022_4_13","ECC","4","13","13","Epe aa naara meda king pitiadare pare epe kone meda nami kogono palia dare wae king pia. ");
INSERT INTO kew_vpl VALUES ("EC4_14","022_4_14","ECC","4","14","14","Naaki nipu kalabus amanane ipua king epaa pia. Nipu naara naki madini yapare nipuna epe koneme mada surubalia. ");
INSERT INTO kew_vpl VALUES ("EC4_15","022_4_15","ECC","4","15","15","Neme adalo pare king ogaeyoa omalia rabu ogege aa medame pada mua king piralia. Go suna pimi onaa luabumi go king-na rolopara pirua nipuna agaa pagoa ratalimi. ");
INSERT INTO kew_vpl VALUES ("EC4_16","022_4_16","ECC","4","16","16","Go su-para pimi onaa luabu nipuna rolopara pitimi. Go onaa luaburi aa medame mada nadipi kiritalimi. Nipu omalia rabu orope piralimi onaame nipumi pisade kogono naniminaalimi. Go madaa page re meda naiya. Gore aa medame poripu ratu ripinatalo pea-rupa mada. ");
INSERT INTO kew_vpl VALUES ("EC5_1","022_5_1","ECC","5","1","1","Gote nipuna ada-para polalo pali raburi mo nena peaa luabu aba waru adoa pope. Nena kone abi waru naade pa pali rabu mo opa katalo pali yaenu puri napatea. Gore kone waru nai aanumi peme-rupa mada pali. Go piaene aanumi Gote-na ini agaa madaa gore wae yae yade kone waru naimi. ");
INSERT INTO kew_vpl VALUES ("EC5_2","022_5_2","ECC","5","2","2","Neme kone waru aba mua orope agaa laape. Neme Gote raapu agaa talo palidaare agaa waru makuawa lape. Gore akoloya Gote so yaapara pia aa-re puri adaa iya niaare puri nai onaa pima. Goa pea-ga neme Gote raapu agaa adaapu nalape. ");
INSERT INTO kew_vpl VALUES ("EC5_3","022_5_3","ECC","5","3","3","Neme oyae mada kone adaapu mealidare epaa page palia. Goa pua neme pama agaa te raburi maeyae aanumi teme rupa agaa natapape. ");
INSERT INTO kew_vpl VALUES ("EC5_4","022_5_4","ECC","5","4","4","Neme Gotepara ora goa palua loa agaa meda tedaare neme mo palide aure adalupu nasurubape. Mo agaa lo rogalipide yae madaa oyae meda napalire ne maeyae aa meda. Gote-me go piaene aanu raaname naomea-ga Gote rapu palua tede agaa-na ini ora mamadiape. ");
INSERT INTO kew_vpl VALUES ("EC5_5","022_5_5","ECC","5","5","5","Neme Gote-para goa palua loa mo tedea napalidaare go peare naepeta. Gore nena tede agaa ratua ora palua kone nasalidaare neme goa palualo abi nalape. ");
INSERT INTO kew_vpl VALUES ("EC5_6","022_5_6","ECC","5","6","6","Neme pama goa palua loa napali rabu ne sini meali. Neme Gotena kogono aa meda-para goa palua tedaare gore mo miru irini aapara agaa aba ne kone aba waru nasua lawayade nalape. Gore Gote-me ne ratu akolo yawoa nena kalaipu-pe kogono luabu maoyatina ya? ");
INSERT INTO kew_vpl VALUES ("EC5_7","022_5_7","ECC","5","7","7","Ne epaa adaapu pi aa yalia page pama re nai kogono pu i aa yalia page ne agaa ora adaapu ne aa yalia page ne Gote nipuna rolopara oro yalo waru piruape. ");
INSERT INTO kew_vpl VALUES ("EC5_8","022_5_8","ECC","5","8","8","Gavman aanumi naraa aanu kedaa mea gialia rabu ne nareko-oyape. Nimuna koso epe redepoya napagoa nimu epe rupa pirape pora namea wateme-daare go konena rere gupa: Pepa tea aana pea kogono adoa nimuna peme yae madaa rumawa kedaa kateme. Go opisa pimi aanu nimuna surube aa so madaa piame adoa padane rupa keda katea. ");
INSERT INTO kew_vpl VALUES ("EC5_9","022_5_9","ECC","5","9","9","Onaa su yoto meme yae, mo opisa pimi aanu-mi nimu page meme. Mone oyae opisa nimu mua mea rumawa nimu paake meme. Mo king pia aame page onaana mone oyae paake mea iya. ");
INSERT INTO kew_vpl VALUES ("EC5_10","022_5_10","ECC","5","10","10","Gore aa medame mone adaapu sawe kone saliadaare nipu oroyalo mone rudune pitia. Mone rana omalia aare mone adapu nasalia. Mone adapu sali page eperupa mada napiti. Go page renaiya. ");
INSERT INTO kew_vpl VALUES ("EC5_11","022_5_11","ECC","5","11","11","Aa medana oyaeyae mada mealiadaare nipuna adami onaa epaa rulatabalia. Goa pea rabu mo aa nipuna adami onaana inimi nipu ama adabapitimi. ");
INSERT INTO kew_vpl VALUES ("EC5_12","022_5_12","ECC","5","12","12","Kogono aana u-re kumapu patea, nipu kogono kalai puae sua page, eta adapu nanoa page. Goyapare Amane aare oyaeyae adapu kone salapirinia u napatamea. ");
INSERT INTO kew_vpl VALUES ("EC5_13","022_5_13","ECC","5","13","13","Neme go su-amaa waeyae meda ia-da ade yae-re gupa. Aa medame nipuna raana rabuaawa oyae nakabea. Dia nipuna mone oyae waru surubea. ");
INSERT INTO kew_vpl VALUES ("EC5_14","022_5_14","ECC","5","14","14","Orope nipuna oyaeyae luabu pua diayatabea. Goa pua nipuna naakina oyae page ora diata. ");
INSERT INTO kew_vpl VALUES ("EC5_15","022_5_15","ECC","5","15","15","Niaana amanumi niaa madisimi raburi oyae page namea epe pa ipisima. Go-rupa agu niaa omalima rabu oyae meda namea pe pamaa palima. ");
INSERT INTO kew_vpl VALUES ("EC5_16","022_5_16","ECC","5","16","16","Gore adaa odopi a pupima. Niaa go su-amaa oyae meda namea epe pa epema-pulu wala omoa pope page pa go rupa palima. Go su-amaa pirua kalaipu pima kogonore aa medame poripu ratu ripinaya-rupa mada. ");
INSERT INTO kew_vpl VALUES ("EC5_17","022_5_17","ECC","5","17","17","Go su-amaa pimaa raburi ribana rupara piriua aipapulu yaina omo, keda mu, raturatu yawo go na rupara pima. ");
INSERT INTO kew_vpl VALUES ("EC5_18","022_5_18","ECC","5","18","18","Neme abia makuatoyaere, onaame nimuna poaeme yaenu napena pedo palimiri epeta. Nimuna radapina peme kogono nare ado kaga pimi rabu. Goteme nipumi kane oyaenu. ");
INSERT INTO kew_vpl VALUES ("EC5_19","022_5_19","ECC","5","19","19","Aa meda Gote-me mone oyaeyae adaapupe katea rabu nimu pedo rana omoa minalo kata. Nipuna kogono pedopu rana rapu minalo, go oyaeyae nuri Gotena manayaina sawa gea. ");
INSERT INTO kew_vpl VALUES ("EC5_20","022_5_20","ECC","5","20","20","Gote-me go aa nipuna pirape yae madaa raana waru kata-pulu nipu ora epe-rupa pia. Goapeapare go aame nipu go suna rudupu pirape yana kone naniminaaya. ");
INSERT INTO kew_vpl VALUES ("EC6_1","022_6_1","ECC","6","1","1","Neme ade pare go su-amaa pimi onaame wae kedaa ritimidaa ade. Go kedare adape ritimi. ");
INSERT INTO kew_vpl VALUES ("EC6_2","022_6_2","ECC","6","2","2","Gote-me Aa mone mena e maapu oyaeyae adaapu waru kata. Gorabu nipu oyae meda naruduta. Go yapare Gote-me aa nipuna oyae madaa pedopu rana naomena teaa. Wala orope-re aa ruru rado medame nipuna go oyaenu mua pedo palia. Gore remeda naiya ora wae aa meda. ");
INSERT INTO kew_vpl VALUES ("EC6_3","022_6_3","ECC","6","3","3","Gore aa meda nipuna naaki 100 maadu sua adalupu pirua, nipuna oyae mada pedo palia, nipu omalia rabu eperupa na-rogalimiri oyalia. Gore naaki meda agina robaa rupara omaliare gome rabuaniaaya. ");
INSERT INTO kew_vpl VALUES ("EC6_4","022_6_4","ECC","6","4","4","Go piaene naaki nipuna bi meda naiya. Nipuna onaame page omea rabu kone rugulaeme. ");
INSERT INTO kew_vpl VALUES ("EC6_5","022_6_5","ECC","6","5","5","Go naaki nipuri naarena paa page abi naadea. Nipu oyae page meda naade yapare nipu rogaeme rabu tapa-para kitu waru mua pia. Goa pea-pulu oge naaki agina robaa-para omea-me oyae adaapu sua omea aana bi rabuaniaaya. ");
INSERT INTO kew_vpl VALUES ("EC6_6","022_6_6","ECC","6","6","6","Goa pea-pulu nipuna oyae madaa raaname naomea. Aa nipu maali adaapu 1000 o 2000 maali pirua omea pare mo agi-na robaapara omea naaki-me rabuaya. Niaa raayo omalima pare padane matmat-para palima. ");
INSERT INTO kew_vpl VALUES ("EC6_7","022_6_7","ECC","6","7","7","Niaame eta napena kogono waru pema. Goa pema pare mo mema etame niana mada dia. ");
INSERT INTO kew_vpl VALUES ("EC6_8","022_6_8","ECC","6","8","8","Mo makuae aame mo namaku-ae aare akeapua wini pea? Gore naara aa medame onaa luabuna ini agaa epea palia raburi gome nipu akepu rabamealia pae? ");
INSERT INTO kew_vpl VALUES ("EC6_9","022_6_9","ECC","6","9","9","Niaame oro yalo meawe kone sua kone adaapu suaema yaenuri pinawa. Go ima kone page re meda naiya-ga gimamina. Aame po ripu ripinatalo aloma pea rupa mada. Go yapare niaame aba mema yaenu madaa raana waru omamina. ");
INSERT INTO kew_vpl VALUES ("EC6_10","022_6_10","ECC","6","10","10","Oyae luabu pama ode-da naopea. Gote nipumi oyae luabu opena saa agaa ratua opea. Gote nipumi niaa aanuna ima kone luabu aba ado kiritea. Niaame Gote raapu udinona agaa mada natema. Gote nipuna purimi niaana puri luabu rabuaya-ga niaa pawa nipuna rolopara piramina. ");
INSERT INTO kew_vpl VALUES ("EC6_11","022_6_11","ECC","6","11","11","Niaame agaa adalupu lo yoloalima pare goame niaa mada nawini palima. Niaame re nai agaa tema-pulu go agaa-me niaa narabamealia. ");
INSERT INTO kew_vpl VALUES ("EC6_12","022_6_12","ECC","6","12","12","Niaa go su-amaa rudupu yapina pima. Gore naare ipua pabola popea rabu repena wasame rigitea-rupa mada pima. Goa pea-ga niaa go suna pirapere re ora waru naia. Niaame pora pamu eta no awape-rupare aapimi waru makuaya? Niaa omalima rabu go su-amaa paliade yae rayo aapimi makuaaya? ");
INSERT INTO kew_vpl VALUES ("EC7_1","022_7_1","ECC","7","1","1","Aa medalomame ne ora epeta teme-daare gore ora waru epeta wele sada adaa yoto pea yae page rabuaniaaya. Niaa omema raburi amame niaa madita yapi di page rabuaniaaya. ");
INSERT INTO kew_vpl VALUES ("EC7_2","022_7_2","ECC","7","2","2","Onaa omalimi rabu o-madaa piri-para palimi-mere gore eta adaa yawe para pema-rupa page rabuaniaaya. Akolo ya niaa luabu ora omalima. Goa pea-ga niaa go su-amaa pa pima raburi kone waru sua piramina. ");
INSERT INTO kew_vpl VALUES ("EC7_3","022_7_3","ECC","7","3","3","Niaame oyae meda madaa lo robaa keda mealimare giri tema page rabuaniaaya. Gore niaana lo robaa kedaa mema raburi ini-agaa-para ribaa aba waru ta. Goa peamere go suamaa ima kone maredepo yapena epe pora mea wata. ");
INSERT INTO kew_vpl VALUES ("EC7_4","022_7_4","ECC","7","4","4","Ne epe kone saliri onaa omeme rabu omadaa pirapere epe kone rapu mada pirali. Go yapare aa medaloma epe kone na-i aa omadaa gimoa, nimu ranarana ipara aanu rapu peme. ");
INSERT INTO kew_vpl VALUES ("EC7_5","022_7_5","ECC","7","5","5","Epe kone-i aanumi ratu yawalimiri ne maredepo-yatalo peme. Gore epea meda, pedopua rana omeme onaana udinona kone page rabuaniaaya. ");
INSERT INTO kew_vpl VALUES ("EC7_6","022_7_6","ECC","7","6","6","Epe kone na-i aame girilalia daare go teme girina re naia. Gore gupa ititu repena ralaaya pare somada yawe eta naralia. ");
INSERT INTO kew_vpl VALUES ("EC7_7","022_7_7","ECC","7","7","7","Aa meda nipu epe kone salia pare aa medana oyaenu pamu yoloa mealia-daare nipu maeyane aa-rupa meda. Goa pua aa nipumi omeme pua mone oyae pamu mealiadare nipuna sabariade epe kone maoeya teapulu oyalia. ");
INSERT INTO kew_vpl VALUES ("EC7_8","022_7_8","ECC","7","8","8","Aa medame kogono marekaa pulalo paliare gore epeta. Go yapare nipumi go kogono luabu pukiritaliare epeare go peadaa. ");
INSERT INTO kew_vpl VALUES ("EC7_9","022_7_9","ECC","7","9","9","Neme aa meda-para ora aba aipapulu ratu nayawape. Mogo ratu yaweme konere kone waru nai aanuna kone. ");
INSERT INTO kew_vpl VALUES ("EC7_10","022_7_10","ECC","7","10","10","Neme gupa nalape. Abade yapi diri ora epe yade pare abia go yapi diri otapi nalape. Neme gopiaene agaa te-daare ne epe makuaeyae naiya. ");
INSERT INTO kew_vpl VALUES ("EC7_11","022_7_11","ECC","7","11","11","Go su-amaa piruaeme onaa luabumi epe kone salimiri epeta. Aaraanu omoa moae yae rumageme-rupa mada. ");
INSERT INTO kew_vpl VALUES ("EC7_12","022_7_12","ECC","7","12","12","Epe kone-re mone-rupa ya-pulu niaa wae yapidi rabu page rabamea. Epe kone page makuae yaeme go mone-na puri rabuaya. Go epe kone makuae yaeme niaa ora waru raba mea. ");
INSERT INTO kew_vpl VALUES ("EC7_13","022_7_13","ECC","7","13","13","Gote-me pisana oyae luabu madaa kone ora aba waru sape. Gote-me oyae meda paakipi-rupa warialo pisa-daare aapimi wala epe-rupa wariali pae? ");
INSERT INTO kew_vpl VALUES ("EC7_14","022_7_14","ECC","7","14","14","Nena epe-rupa piti-daare gore epe-rupa pedopu piruape. Go yapare wae keda yapi di medame ne epaa mealia raburi gupa kone niminape. Goteme epe yapi di page wae yapi di page gea kone sape. Goa pea-ga wala orope epaliade yaenuri niaada namakuaema. ");
INSERT INTO kew_vpl VALUES ("EC7_15","022_7_15","ECC","7","15","15","Nina laipiri waru yae-daa dia yapare ni go su-amaa pima raburi neme oyae rado rado adaapu ade. Aa medaloma epe pora rateme pare nimu page omeme. Aa medaloma wae pupitagi noaeme pare nimu go su-amaa adalupa pa piruaeme. ");
INSERT INTO kew_vpl VALUES ("EC7_16","022_7_16","ECC","7","16","16","Goa pea-ga niaame go su-amaa epe redepone-aure ratua epe kone agu sape mada kone adaapu nasamina. Goa agu palima raburi niaana bipa niaa maoyaalima. ");
INSERT INTO kew_vpl VALUES ("EC7_17","022_7_17","ECC","7","17","17","Gore niaa-me wae kone, wae pora ratape madaa, puripane kone ogeapu samina. Goa palima-daare niaana omape yae page marudu yaema. ");
INSERT INTO kew_vpl VALUES ("EC7_18","022_7_18","ECC","7","18","18","Ne go kone laapo waru ruma adoa pora pamuape. Aa medame Gote-na surube yaena rolo-para pirinatedaare ora epealia. ");
INSERT INTO kew_vpl VALUES ("EC7_19","022_7_19","ECC","7","19","19","Ada-re meda para aa ki laapo pegepu pirua go siti surubo alimiri go siti puri paloa aalia. Goa palia pare epe konena purimiri go ada kagure surubalimina puri page rabaualia. ");
INSERT INTO kew_vpl VALUES ("EC7_20","022_7_20","ECC","7","20","20","Go suna epe aa meda naaya. Dia aa medaloma nimumi wae sini peme. ");
INSERT INTO kew_vpl VALUES ("EC7_21","022_7_21","ECC","7","21","21","Neme onaa luabuna agaa napagape. Neme mo onaame teme agaa luabu pagalidare kogono naakimi nepara wae agaa tea. ");
INSERT INTO kew_vpl VALUES ("EC7_22","022_7_22","ECC","7","22","22","Gore nena aba makuae, neme mo onaa medaloma-para wae agaa aba tede. ");
INSERT INTO kew_vpl VALUES ("EC7_23","022_7_23","ECC","7","23","23","Neme oyae raayona re adesaato pame kalai pere ni makuae aa opolalo pe. Nina kone ruduta-pulu mada diasa. ");
INSERT INTO kew_vpl VALUES ("EC7_24","022_7_24","ECC","7","24","24","Oyae luabu opeana re adasaatalo pua kalai waru pe. Gore niaa-me oyae mo-para ina page no rolo-para ina asapimide-rupa pe. Gore apimi mada adesaliya? ");
INSERT INTO kew_vpl VALUES ("EC7_25","022_7_25","ECC","7","25","25","Goa pua nina uni radaa-pinaloa makuae kone rado rado adesatalo kalae waru pe. Go page neme wae pupitagi kone page maeyae kone adolalo page kogono radaa-pinaloa pe. ");
INSERT INTO kew_vpl VALUES ("EC7_26","022_7_26","ECC","7","26","26","Asapua adawa raburi onanumi niaa kedaa waru mea geme-daa ade. Onaanumi niaa maroape kona yada waru ade. Nimuna ki-ri niaa adiape ope sene-me ade aaeme. Goa peme pare aa meda nipumi Gote madaa kone waru rulaliare go sene-me aditalo pea page yolaa-pa ina mada pogola palia. Go sene-me mo pupitagi neme aanu adialia napogola palimi. ");
INSERT INTO kew_vpl VALUES ("EC7_27","022_7_27","ECC","7","27","27","Makuaae aa-me goa ta. Neme wae yae epe yae laapona re waru adolalo pawa kogono pe. Goa pe pare abiare re ona madaa asaa-daa waru adawa. ");
INSERT INTO kew_vpl VALUES ("EC7_28","022_7_28","ECC","7","28","28","Neme ona epe asapawade pare meda ora naadawade. Aa ora adaapu papu papu pimi pare padane padane aanu medaloma epe pimi. Go yapare ona-re luabu ora wae pimi. ");
INSERT INTO kew_vpl VALUES ("EC7_29","022_7_29","ECC","7","29","29","Gote-me onaa luabuna epe pora aba managolasaya-pulu nimumi kalai mada napalimi. Goa pea pare nimuna bipa peamea raayome nimu pope rupa radaa mapaeme. ");
INSERT INTO kew_vpl VALUES ("EC8_1","022_8_1","ECC","8","1","1","Makuae aame oyae luabuna re waru makuaya. Goa peme-ga mo makuae aanu-ri aapimi mada rabualimi? Aa medana ini ribaa yalia-daare, epe paa pi kone sali aana ini agaa-para paa palia. ");
INSERT INTO kew_vpl VALUES ("EC8_2","022_8_2","ECC","8","2","2","Neme aa king-na agaa pagoa ratape. Neme mo Gote mada makuasua side agaa rataliri king-na agaa pagoa regenaape. ");
INSERT INTO kew_vpl VALUES ("EC8_3","022_8_3","ECC","8","3","3","Ne king raapu pirali-daare nipu ora nagimape. Neme king raapu yada pu agaa te-daare gore neme puri waru paloa nalape. Gore king nipuna bipa rana ratua palialo lalo. ");
INSERT INTO kew_vpl VALUES ("EC8_4","022_8_4","ECC","8","4","4","King nipumi aanu luabumi nipuna agaa pagoa ratalepa te-daare gore waru ratalepape. Neme go piare akolo pae lo mada na-agaa mealimi? ");
INSERT INTO kew_vpl VALUES ("EC8_5","022_8_5","ECC","8","5","5","Aa medame king-na agaa pagoa rataliare go aa nipu ora epe-rupa pitia. Aa nipu wale puti piraliare nipumi papea luabu-para nare inimi pea kogono page waru makuaaya. ");
INSERT INTO kew_vpl VALUES ("EC8_6","022_8_6","ECC","8","6","6","Niaa aanuna keda medaloma salia page pinawa, oyae rayo papena pora para nareini page iya. ");
INSERT INTO kew_vpl VALUES ("EC8_7","022_8_7","ECC","8","7","7","Orope paliade yae luabu makuapere marea. Go paliade oyae luabu lagiape aa meda naaya. ");
INSERT INTO kew_vpl VALUES ("EC8_8","022_8_8","ECC","8","8","8","Niaa omolalo pema rabu niaana wasaa-me niaa gimoa polalo pea raburi medame mada napora-poaliaa. Niaana omape yapi di epalia page medame mada napora-poalimi. Yada peme raburi mo yada surube aame wala gimoa pupu-lo mada namea rapalia. Wae pupitagi nea aame nipuna waea aba pea-pulu nagimalia. ");
INSERT INTO kew_vpl VALUES ("EC8_9","022_8_9","ECC","8","9","9","Neme go ade yae rayore go suna pemeda na koneme makuayo. Yapidi medamere, aa-yago rabuaniawa, waea-peme aanu rogaemeda ade. ");
INSERT INTO kew_vpl VALUES ("EC8_10","022_8_10","ECC","8","10","10","Waeapi aa page rogaemeda ade. Wala ada pulawa mo siti para mo wae aa nipuna bi wala minasaere epeme. Gore remeda naiya da ade. ");
INSERT INTO kew_vpl VALUES ("EC8_11","022_8_11","ECC","8","11","11","Waeapi aana rema amaa abi na epea raburi, mo onaame nimuna peme waea mada yala-poteme. ");
INSERT INTO kew_vpl VALUES ("EC8_12","022_8_12","ECC","8","12","12","Waeapi onaa page sini peme onaa page abi naome adalupu pa aeme. Ni makuato Gote pala omeme onaa eperupa pitimi. Gore akoloya nimu Gote pala omeme pulu. ");
INSERT INTO kew_vpl VALUES ("EC8_13","022_8_13","ECC","8","13","13","Gore akoloya, waea-pi aame Gote pala naomeapulu, nipu rapu mada napitimi. Gore nipu Gote-na surubena rolo-para napia-pulu nipu adalupu go su-amaa mada napiralia. ");
INSERT INTO kew_vpl VALUES ("EC8_14","022_8_14","ECC","8","14","14","Go suna agaa medaloma teme pare re waru naiya. Oro medare mo epe redepoya piri aanumi wae yoto meme. Gore epe aanumi meape epe yoto wala wae aanumi meme-re neme lalo re meda naia peme. ");
INSERT INTO kew_vpl VALUES ("EC8_15","022_8_15","ECC","8","15","15","Goa peme-daa neme epe kone epe ratapere epeta kone i. Niaame ratape epe pora meda naia. Goa pea-ga niaame ipa, etano pa epe raana raana pi-rupa awamina. Niaana pape kogono radaa pea pare niaa go su-amaa Gote-me mea gea yapi di raburi pawa epe-rupa pedopu piramina. ");
INSERT INTO kew_vpl VALUES ("EC8_16","022_8_16","ECC","8","16","16","Neme aanumi ribaa page paa-para page puaemea adolalo kalaipu kogono pe. ");
INSERT INTO kew_vpl VALUES ("EC8_17","022_8_17","ECC","8","17","17","Oyae raayo Gote-me pisaaya neme ado kirite pare niaame go su-amaa ia yae luabu-na re mada naado kiritema. Gore pinawa mo makuae aanumi go yae luabuna re ora aba ado kiritama teme page gore ora agaa-daa nateme. Nimumi go yaenuna re ora mada na-adasalimi. ");
INSERT INTO kew_vpl VALUES ("EC9_1","022_9_1","ECC","9","1","1","Neme oyaenu madaa kone sua ade raburi gupa makuaayo. Gote-me mo epe aanu madaa pape aure page redepone aanu page pa aanu medaloma madaa papea page luabu aba adea. Nipu-mi oyae raana omape page raana naomape yapi di page Gote nipuna mada mea. Oyae medaloma orope ake paliare nia namakuaema. ");
INSERT INTO kew_vpl VALUES ("EC9_2","022_9_2","ECC","9","2","2","Go yapare niaa raayo madaa epa-pe yae meda ora ia. Gore niaa Gotena ini agaa mada epea palima page ora epe redepone aa palima page ora suku suku puti aa yalia page niaa waea pi aanu yalia page o Gote nipu repara epekaapi miru irini aa yalia page niaa epe miru nairini aa luabu yalia page epe wae aa luabu yalia page Gote madaa ora yadamakua loa agaa tea-de aa mada page yadamakua natea aa madaa page epalia. ");
INSERT INTO kew_vpl VALUES ("EC9_3","022_9_3","ECC","9","3","3","Niaa go su-amaa pima onaa luabu mada gopiane yae rayo niaa piripara ora epea. Onaa luabu go su-amaa pima raburi wae yae niaa repara ora epea. Gore gupa wae kone-para maeyae kone luabu nimina robaapara rulatabea. Goa pea pulu nimu omeme. ");
INSERT INTO kew_vpl VALUES ("EC9_4","022_9_4","ECC","9","4","4","Raa mena laion-aba omea-mere papia yaname rabuniaya. Padane go-rupare mo papimi aanumi aba omeme aanu page rabuniaeme. Gore mo papimi aanumi nimu aba makuaawa niaare omalima kone imi. ");
INSERT INTO kew_vpl VALUES ("EC9_5","022_9_5","ECC","9","5","5","Goa pea pare mo aba omeme aanu nimu oyae meda goa palia kone nasaapimi. Onaanumi nimu aba kone rugulaeme pare go onaa nimumi epe oyae meape mada pimi. ");
INSERT INTO kew_vpl VALUES ("EC9_6","022_9_6","ECC","9","6","6","Onaa omeme raburi nimuna pupitagi epame omape kone page wae kone imi page oyae luabu omeme rabu diata. Goa pea-pulu go omeme onaa luabuna kogono go su-amaa meda naia. ");
INSERT INTO kew_vpl VALUES ("EC9_7","022_9_7","ECC","9","7","7","Ne aipapulu ipa waine no lo robapara kuma pinaloa eta no raana aba meaina. Gote-me goa papere epeta loa aba ee lade. ");
INSERT INTO kew_vpl VALUES ("EC9_8","022_9_8","ECC","9","8","8","Oroyalo neme pepena waru pua raana omoape. ");
INSERT INTO kew_vpl VALUES ("EC9_9","022_9_9","ECC","9","9","9","Nena ore raapu rana omo eperupa piru pate page go suna re naiya. Ne go suna ape page re naiya. Goteme go suna apena yapidi geada pa goa pe. ");
INSERT INTO kew_vpl VALUES ("EC9_10","022_9_10","ECC","9","10","10","Neme kogono meda pali-daare puri waru paloa go kogono ora pape. Gore akoloya ne omali raburi kogono pape page epe kone sape page ne makuaaeyae meape page ora mada nameali. ");
INSERT INTO kew_vpl VALUES ("EC9_11","022_9_11","ECC","9","11","11","Neme go su-amaa oyae meda gupa ade. Aa meda alomaa pea pare oyae namea. Yada pi aanumi page nawinipeme. Epe kone sua makuae yae waru meme aanu page mone adapu nameme. Kogono radorado pu makuae aanu nimu adaa kogono nameme. Goa pua wae yapidi nimu madaa epea. ");
INSERT INTO kew_vpl VALUES ("EC9_12","022_9_12","ECC","9","12","12","Adaa keda niaa madaa epolalo peare nadema. Kona maema rabu ya-yapa roalade rupa wae yapidimi niaa aipapulu ripinatalo agu rapea. ");
INSERT INTO kew_vpl VALUES ("EC9_13","022_9_13","ECC","9","13","13","Neme yae meda peada ade. Go peare epe kone i aame pape kepele pia. Mo ade yaere go-rupa. ");
INSERT INTO kew_vpl VALUES ("EC9_14","022_9_14","ECC","9","14","14","Oge siti meda aaya pare goparare onaa ora adaapu napimi. Gopara king meda nipu-na yada pi aanu rapu ipisimi. Gore mo yada pi aanumi mo oge siti kutapubasimi. ");
INSERT INTO kew_vpl VALUES ("EC9_15","022_9_15","ECC","9","15","15","Goa peme pare mo oge siti-para aa naraa meda pirisa. Go aa nipu epe kone sua makuae yae page waru makuaya. Nipuna epe kone mada go oge siti paaya. Goa pisa rabu orope onaame mode aa naara-re wala kone rugulasimi. ");
INSERT INTO kew_vpl VALUES ("EC9_16","022_9_16","ECC","9","16","16","Go konere niaa gupa go mea wata-daa. Epe konemere adaa puri page rabuaniaya. Go yapare onaa luabume gupa kone imi. Naara aa nipuna makuae-para epe kone page ora epe-daa dia teme. Goa loa mo aa naara-na agaa napageme. ");
INSERT INTO kew_vpl VALUES ("EC9_17","022_9_17","ECC","9","17","17","Epe kone i aana agaa pagalima-daare epeta kone samina. Go piaene aana agaa-me rui loayaa aana agaa page rabuaniaya. ");
INSERT INTO kew_vpl VALUES ("EC9_18","022_9_18","ECC","9","18","18","Epe koneme mo yada pape yaenu rabuaniaya. Go yapare aa padane-me waea meda pulalo paliadare nipumi oyae luabu maoyaatalia. ");
INSERT INTO kew_vpl VALUES ("EC10_1","022_10_1","ECC","10","1","1","Puna mo wabola pabo i pe runane pua puaa omalia-dare wabola pugu waru palia. Goa pea rupare oge kone wae odabaawa epe kone i aana kone luabu maoyaatalia. ");
INSERT INTO kew_vpl VALUES ("EC10_2","022_10_2","ECC","10","2","2","Epe kone i aame epea pulalo rapea. Go wae kone ia aa madaare epe kone meda napatea. ");
INSERT INTO kew_vpl VALUES ("EC10_3","022_10_3","ECC","10","3","3","Mo aa nipu poranini pamea rabu page mo aa nipu aba ademe-pulu onaame go aa nipu waeyaede kone makualimi. ");
INSERT INTO kew_vpl VALUES ("EC10_4","022_10_4","ECC","10","4","4","Nena surube aame ne ratu yawalia-daare nena kogono nagimape. Neme waea adaape pua page pawa odo pabena ali-daare nena aa mudumi nena waeyae mearuba-alia. ");
INSERT INTO kew_vpl VALUES ("EC10_5","022_10_5","ECC","10","5","5","Aa medalomame waea adaapu peme-daa neme adoa gime. Go pemea wae yaenuri aa mudunumi peme. ");
INSERT INTO kew_vpl VALUES ("EC10_6","022_10_6","ECC","10","6","6","Mo aa mudunumi kone epe-rupa nai aanu kogono pama kateme. Mone adaapu sua amo teme aanumi peme kogono ora naepeta. ");
INSERT INTO kew_vpl VALUES ("EC10_7","022_10_7","ECC","10","7","7","Naraa piri kogono naakimi mena ose madaa pirua pupulaina ade. Pare pa kogono aanu pamuape rupare wala mo adaa aa mudu nimu pamualaina ade. ");
INSERT INTO kew_vpl VALUES ("EC10_8","022_10_8","ECC","10","8","8","Aa meda nipumi su naaku adaape roboa saliare nipuna bipa go naaku-para pabalia. Aa medame ana kepo rugutea-daare paakame nipu nalia. ");
INSERT INTO kew_vpl VALUES ("EC10_9","022_10_9","ECC","10","9","9","Aa medame ana polatua pereke-aliare aana-me nipu mada nalia. Aame repena kobealiare go repename nipu talia. ");
INSERT INTO kew_vpl VALUES ("EC10_10","022_10_10","ECC","10","10","10","Aa meda nipuna raigapi nepo-napi pa saliare gore nipumi rai-eke naaya-pulu mo poalia repena waru nanalia. Go yapare epe kone-i aame kogono epe-rupa pea. ");
INSERT INTO kew_vpl VALUES ("EC10_11","022_10_11","ECC","10","11","11","Aame paaka pawa epe-rupa mapirape kone sua aliare epeta. Go yapare paaka-me nipu wala nalia-daare go makuae-yae naepeta. ");
INSERT INTO kew_vpl VALUES ("EC10_12","022_10_12","ECC","10","12","12","Epe kone-i aame agaa ora epe-rupa tedare ne epe bi meali. Ne onaa raapu wae ero agaa tedare nena bipa mabebolaali. ");
INSERT INTO kew_vpl VALUES ("EC10_13","022_10_13","ECC","10","13","13","Go aa nipumi agaa ripima talo pea raburi nipuna talo pea agaa luabu ota. Nipuna agaa lo diayatalo pea raburi go agaa maeyaane aame ne nona pea. ");
INSERT INTO kew_vpl VALUES ("EC10_14","022_10_14","ECC","10","14","14","Epe kone nai aamere agaa pa tea. Gore orope paliade yaenu naniminae pa agaa teme. Niaa omalima rabu palia page namakuaema. ");
INSERT INTO kew_vpl VALUES ("EC10_15","022_10_15","ECC","10","15","15","Kone nai maeyae aa nipuna ada pope pora namakuawa kalai pama pea. ");
INSERT INTO kew_vpl VALUES ("EC10_16","022_10_16","ECC","10","16","16","King meda pena naaki yalia pare nipuna rurumi ribaa rekoa eta yawalimidare ada kagure para kedaa adaa salia. ");
INSERT INTO kew_vpl VALUES ("EC10_17","022_10_17","ECC","10","17","17","Go yapare king medana simi king piralia-daare go ada kagure-para piri aa mudumi nimu eta yawalia page kepele palia. Gore nimu maeyatalo-da napeme pare pa tona puri mulalo peme. ");
INSERT INTO kew_vpl VALUES ("EC10_18","022_10_18","ECC","10","18","18","Aa meda nipu gi madua nipuna ada waru narigitaliare gore nipuna ada itipatame pabo talia. ");
INSERT INTO kew_vpl VALUES ("EC10_19","022_10_19","ECC","10","19","19","Eta nape oyaenuri onaa, raana masape mada peme. Ipa waini neme rabu onaa lo robaa-para ora sae loa epeta kone inalo peme. Goa peme pare mone-re kogono raayo pape yae-para pema. ");
INSERT INTO kew_vpl VALUES ("EC10_20","022_10_20","ECC","10","20","20","Nena pati ada robene-para pirua king-para ero agaa nalape. Neme nimu-para wae kone page nasape. Neme goa palide adoa yaanumi mo aa pua laketea. ");
INSERT INTO kew_vpl VALUES ("EC11_1","022_11_1","ECC","11","1","1","Neme su adapu-para kogono waru pape orope ne epe yoto adaapu meaina. ");
INSERT INTO kew_vpl VALUES ("EC11_2","022_11_2","ECC","11","2","2","Go suamaa wae yapidi medaloma epalia. Nena mone bisinisi adapu para saina 7-pela 8-pela bisinisi pape-para mea paga sape. ");
INSERT INTO kew_vpl VALUES ("EC11_3","022_11_3","ECC","11","3","3","So yaa madaa moae popa rubita raburi go su-amaa yai lopea. Gore repena naare pabala-nane robalia page naare ipula-nane robalia page pa roba salia. ");
INSERT INTO kew_vpl VALUES ("EC11_4","022_11_4","ECC","11","4","4","Ne e po sua, poripu yai epena kone surubali pare eta epe rupa nameali. ");
INSERT INTO kew_vpl VALUES ("EC11_5","022_11_5","ECC","11","5","5","Gote nipumi oyae luabu warisa. Goa pea pulu agina robaa-para naaki akepu inagi tea palo niaa namakuaaema. Go-rupa agu Gote-me pea yae luaburi niaame mada naado kiritema. ");
INSERT INTO kew_vpl VALUES ("EC11_6","022_11_6","ECC","11","6","6","Neme eta wai polalo paliri gore medaloma aebo poa medaloma yapipu poape. Go pea pare aebo poaede waru opea palo yapipu poaede waru opala palo waru naade. Gorupare yapipu poae-para aebo poae lapo rata waru opalia. ");
INSERT INTO kew_vpl VALUES ("EC11_7","022_11_7","ECC","11","7","7","Paa ora epeta pulu niaa naarena paa adema raburi raana waru omema. ");
INSERT INTO kew_vpl VALUES ("EC11_8","022_11_8","ECC","11","8","8","Niaame maali yalo go su-amaa piruaema madaa raana ora waru omamina. Niaa maali adaapuna go su-amaa piralima page go madaa kone ora narugulamina. Niaa aba ome onaana tapa-para ora maali adaapuna pirualima. Oyae luabu orope opaliade page waru yaeda dia. ");
INSERT INTO kew_vpl VALUES ("EC11_9","022_11_9","ECC","11","9","9","Nimi ona inumakuaa, aa ogegeaa-nuri nimi pena ona inumakuaa aa ogegeaa aaeme rabu pedopu raana omo aatepape. Nimina rana ratua alimina yapare, Gote-me nimi-na pemea luabu madaa koso laliaga kone waru sua atepape. ");
INSERT INTO kew_vpl VALUES ("EC11_10","022_11_10","ECC","11","10","10","Nimi ona inumakuaa aa ogegeaa pirape yapi diri adaalupu-da naiya. Goa pea-ga nimi kedaa mea gea yaere gimalepape. Nimina to yogaene madaa kedaa mea gea yaenu page gimalepape. ");
INSERT INTO kew_vpl VALUES ("EC12_1","022_12_1","ECC","12","1","1","Gote-me niaa luabu warisa. Goa pea-ga nimi pena ona inumakua aa ogegeaa a-wa Gote nipu madaa kone rutalepape. Nimu kone rugulaawa alimi rabu kone perekeape-rupa maralimi. Goa pua nimi padane padane latapumi gupa teme. Nina kone wasupame raana napia teme. ");
INSERT INTO kew_vpl VALUES ("EC12_2","022_12_2","ECC","12","2","2","Go yapi dinare nimina ini-para riba tea rabu gupa teme. Akua naare uba kedonu page waru narea pare yai epope moae page waru nasala teme. ");
INSERT INTO kew_vpl VALUES ("EC12_3","022_12_3","ECC","12","3","3","Go yapinare nimina ki page omapaawa puri nasalia rabu pururu yata aalia. Nimina ke page omapa-wa puri nasalia rabu pulu-pulu tala-alia. Go rabu agaa imaa padane padane-si aalia. Goa pua nimimi eta puri paloti mada nanalimi. Nimina ini page ribaa yalia rabu oyae waru naadalimi. ");
INSERT INTO kew_vpl VALUES ("EC12_4","022_12_4","ECC","12","4","4","Nimina ane page poalia rabu adaalu pare awa temede agaa mada napagali. Goa pua gigau loalia page mada napagalimi. Goa pea pare nimi patalimi raburi yaa-agaa tea padane mada pagali. ");
INSERT INTO kew_vpl VALUES ("EC12_5","022_12_5","ECC","12","5","5","Go raburi nimi pora-nini pamuape page so madaa pirape page palame omalimi. Nimina iri page kama-iri opalia rabu pora pamuape-rupa maralimi. Oyaeme page nimina lo robaa mada namarekaalia. Goa pua nimi omali-mi rabu oroyalo piruape supara palimi. Go rabu nimina adare-para piri onaa-me odome omoa re yasa loalimi. ");
INSERT INTO kew_vpl VALUES ("EC12_6","022_12_6","ECC","12","6","6","Goa palimi-ga nimi abi naome pa pirua Gote madaa kone rulatepape. Gore nimi laba paa udinitade rupa mada omalimi. Go page niaame ipa-no ritalo peme rabu sosopene-na igu apetaboa ipa pupubeade-rupa mada palia. ");
INSERT INTO kew_vpl VALUES ("EC12_7","022_12_7","ECC","12","7","7","Nimina tore go su autea. Kone popo Gote nipuna gisa-pulu kone wasupare Gote nipu piri-para wala palia. ");
INSERT INTO kew_vpl VALUES ("EC12_8","022_12_8","ECC","12","8","8","Makuae aame nipumi oyae luabu waru yaeda dia loare ogeda page naia ta. ");
INSERT INTO kew_vpl VALUES ("EC12_9","022_12_9","ECC","12","9","9","Makuae aa nipu epe koneme rulatabisa-pulu onaa luabu go epe kone mogealia. Nipumi ora agaa ria-para saa-agaa page rumawa epere luabu buku-para mea tu isa. ");
INSERT INTO kew_vpl VALUES ("EC12_10","022_12_10","ECC","12","10","10","Onaana anepara pagoa redeme omalimi loa buku-para popena sa. Goa pua ora agaa riaa uni mada polabaina loa tu isa. ");
INSERT INTO kew_vpl VALUES ("EC12_11","022_12_11","ECC","12","11","11","Go makuae aanuna agaa-re rigi eke waru aayade-rupa mada. Gore mena pulubaene maredepo yaemade-rupa mada. Makuae aame go agaa buku-para mea kiritaawa tu saliare go agaa ora adaalupu suaalia. Gore nili tema rabu ripinaya-de rupa mada. Gote-re niaana surube aa pulu nipumi go agaa niaa luabu lagiala. ");
INSERT INTO kew_vpl VALUES ("EC12_12","022_12_12","ECC","12","12","12","Nina naaki neme yae meda lagiano. Aanumi buku temere go kogono ora diayape kogono-da napeme. Neme go buku oroyalo ado pirali raburi nena to yogaene gi-palia. Goa palia-ga neme go gi-madini kone-re waru adape. ");
INSERT INTO kew_vpl VALUES ("EC12_13","022_12_13","ECC","12","13","13","Agaa luabu madiaaya neme gupa talo pi. Niaa aanuna riri-nane palimare go-rupa: Niaame Gote padanemana rolo-para pirua nipuna pora ia-rupa luabu ratua pawa epe-rupa piramina. ");
INSERT INTO kew_vpl VALUES ("EC12_14","022_12_14","ECC","12","14","14","Niaana puaema oyae luabu madaa Gote-me niaa adialia. Gore niaame kudiripi kone page wae kone page ima pupitagi oyae luabu pema yae mada niaa koso madaa Gote-me adialia. ");
INSERT INTO kew_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Go remaa madaare Yesu Krais-na akuanuna bi aba gupa teme. Aba ripiare Yesuna akua Devit pirisa. Devit-na akua medare Abraham pirisa. ");
INSERT INTO kew_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham-re Aisak-na aaraa pirisa. Aisak-re Jekop-na aaraa pirisa. Jekop-re Juda-para nipuna amenu-para nimuna aaraa pirisa. ");
INSERT INTO kew_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda-re Peres-para Sera lapona aaraa pirisa. Nipuna amare Tamar pirisa. Peres-re Hesron-na aaraa pirisa. Hesron-re Ram-na aaraa pirisa. ");
INSERT INTO kew_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram-re Aminadap-na aaraa pirisa. Aminadap-re Nason-na aaraa pirisa. Nason-re Salmon-na aaraa pirisa. ");
INSERT INTO kew_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon-re Boas-na aaraa pirisa. (Nipuna agiri Rehap.) Boas nipuri Obet-na aaraa pirisa. (Nipuna agiri Rut.) Obet-re Jesi-na aaraa pirisa. ");
INSERT INTO kew_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi nipuri King Devit-na aaraa pirisa. Devit-ri Solomon-na aaraa pirisa. Nipuna agiri abade Uria ona pirisa. ");
INSERT INTO kew_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon-re Rehoboam-na aaraa pirisa. Rehoboam-re Abiya-na aaraa pirisa. Abiya-re Asa-na aaraa pirisa. ");
INSERT INTO kew_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa-re Jehosafat-na aaraa pirisa. Jehosafat-re Jehoram-na aaraa pirisa. Jehoram-re Usia-na aaraa pirisa. ");
INSERT INTO kew_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia-re Jotam-na aaraa pirisa. Jotam-re Ahas-na aaraa pirisa. Ahas-re Hesekia-na aaraa pirisa. ");
INSERT INTO kew_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia-re Manase-na aaraa pirisa. Manase-re Emon-na aaraa pirisa. Emon Josaia-na aaraa pirisa. ");
INSERT INTO kew_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia-re Jehoiakin-para nipuna amenu medaloma nimuna aaraa pirisa. Go raburi mo Israel onaanu nimu Babilon su-para kalabus ada mapataasimi. ");
INSERT INTO kew_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nimu Babilon su-para kalabus patisimi raburi akuanuna bi gupa maasimi: Jehoiakin-re gore Sealtiel-na aaraa pirisa. Sealtiel-re Serubabel-na aaraa pirisa. ");
INSERT INTO kew_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel-re Abiut-na aaraa pirisa. Abiut-ri Eliakim-na aaraa pirisa. Eliakim-ri Asor-na aaraa pirisa. ");
INSERT INTO kew_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aso-re Sadok-na aaraa pirisa. Sadok nipuri Akim-na aaraa pirisa. Akim-ri Eliut-na aaraa pirisa. ");
INSERT INTO kew_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut-ri Eleasar-na aaraa pirisa. Eleasar-re Matan-na aaraa pirisa. Matan-re Jekop-na aaraa pirisa. ");
INSERT INTO kew_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop-re Josep-na aaraa pirisa. Josep-re Maria-na aani pirisa. Maria-re Yesuna agi pirisa. Yesu nipuna biri Gote-na Mea Repae Aa (Mesaia) maasimi. ");
INSERT INTO kew_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Gore abare Abraham-na ruru go pirisimi onaana epa-mama pua Devit madaare akuanuna ruru 14-pela pirisimi. Abade Devit pirisa rabu epa-mama puare nimu Babilon kalabus ada mapataasimi raburi akuanuna ruru 14-pela pirisimi. Gore mapataasimi onaana epa-mama puare Gote-na Mea Repae Aa madisa rabu go madaare akuana ruru 14-pela pa pirisimi. ");
INSERT INTO kew_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Krais nipu madisa-na remaare go-rupa: Nipuna agi Maria-re aba Josep-na rumaainalo mada misimi. Goa pisimi pare Josep nipumi abi narumaasa rabu Maria-me nipu madaa Holi Spirit-mi naaki padaa pa maraasa. ");
INSERT INTO kew_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Go ona nipuna polalo pi aare Josep yapare nipu ora epe aa ya-pulu nipumi Maria yala namapolaano kone isa. Goa pisa-pulu nipumi kudiri pi kone sua pawasi gimalua kone isa. ");
INSERT INTO kew_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josep nipumi go kone pa niminaaba pirina upaame Gote-na ensel meda adesa. Go ensel-me nipu-para lalo: Josep nere Devit-na si. Nena ona Maria meape paalame naomape. Paga, mo robaa-para pia naakiri Holi Spirit-mi mapiraariade. ");
INSERT INTO kew_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nipumi naaki madialia rabu nipuna biri Yesu lape. Gore nipumi onaa rayona wae yaenu mea raakepe ruboa nimu epe-rupa raba mua mapiraalia sa. ");
INSERT INTO kew_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Gore Aa Mudu Gote-na agaa lakene aa meda agaa lakesa-pulu go oyae rayo apo-rupa ora pisa. Go agaa lakene aame abade gupa sa: ");
INSERT INTO kew_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Pagelepa, ona inumakua meda aa raapu napatimi naaki padaa pirua naaki meda madialia pare go naaki nipuna biri Emanuel lamina sa. Go bina re-re gupa: Gote-re niaa raapu piruaaya. ");
INSERT INTO kew_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josep nipu u patua rekesa rabu mo Aa Mudu-na ensel-me lakesa agaa pagoa nipumi go ona nipuna ore-rupa misa. ");
INSERT INTO kew_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pare nipuna oname naaki padaa pa pirina nipu raapu u napatasipi. Go naaki madisa rabu Josep-me bi Yesu lo lakesa. ");
INSERT INTO kew_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maria-me Yesu Betlehem adaare-para madisa. Go suri Judia su ru-nane aasa. Go naaki nipu madisa raburi Herot nipu aa mudu pirisa. Gore aba madinaloa uba kedo madaa kone makuaae aanu medaloma mo naare opa ipula-nane pirua Jerusalem su-para ipisimi. ");
INSERT INTO kew_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Epa opopaawa agaa gupa misimi: Go kagaa naaki nipu Juda onaanuna aa mudu pirape aare aa-para madia ya? Niaana su-para pirua nipu madini su waala uba kedo adoa epa amaa. Nipuna bi minasaatalo. ");
INSERT INTO kew_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Gore aa mudu Herot-me go remaa pagoa pogolasaasa. Goa pua Jerusalem su-para piri onaa rayo kone adaapu isimi. ");
INSERT INTO kew_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Goa pua Herot-me Gote-na miru irae aa mudunu-para rekena agaa maalape aanu-para makiritaasa. Nimu kiritasimi rabu Herot-me agaa gupa misa: Gote-na Mea Repae Aare aapina su-para madia ya? ");
INSERT INTO kew_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Gore nipu gupa lakesimi: Judia su ru-nane Betlehem adaare-para madiaaya simi. Gote-na agaa lakene aame pepa madaa gupa tu isa-ga pagape simi: ");
INSERT INTO kew_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Nimi Betlehem adaare-para piri onaanuri Juda su robo ru-nane pimi. Gore Juda suna aa mudununa kone madaa ora epe-rupa pimi. Goa pea-ga nimina su-parare aa mudu meda piralia. Go aamere nimi-para Israel su-para piri onaanu-para surubalia. ");
INSERT INTO kew_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Go tu isa agaa pagoare Herot nipumi pawasi kaledoa mo naare ipula-nane piri makuaae aanu ipulupa lo lakesa. Goa pua go uba kedo opapariaade diri aa-rabu yaalo agaa misa. ");
INSERT INTO kew_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Go agaa mua sana nipumi go makuaae aanu Betlehem adaare-para wala rapaawa agaa gupa lakesa: Nimi puare puri paloa go naaki waru asapula pulupa. Nimimi aba adasaalimiri ni piri wala epa lagialepape. Goa palimiri neme page nipuna bi minasaata palua sa. ");
INSERT INTO kew_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Mo aa muduna agaa aba pagoare nimu pisimi. Go adoa ipisimi uba kedo wala epa opoa puaa-mama puare mo naaki madu saapiri ada masaa madaa pua aasa. ");
INSERT INTO kew_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Mo uba kedo wala adoare nimuna pu robaa-para raaname ora waru omesimi. ");
INSERT INTO kew_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nimu ru-nane pua odobaawa simina mo naaki Maria agiaaya pua adesimi. Go rabu nimumi su adoa rumu koba pua mo naakina bi minasaasimi. Nimuna paus loboa epe kaa pi oyae medaloma pa epa kasimi. Nimumi abu pi gol aana-me warini epe yae-para paura epe kaa pi yaenu-para epe kaa pi wabola nona piane yae medaloma page epa kasimi. ");
INSERT INTO kew_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Gore upaame Gote-me nimu gupa lakesa-pulu nimu Herot piri wala napisimina nimuna pora rado meda mada pua nimuna ada wala pisimi. ");
INSERT INTO kew_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nimu aba penaaloa Gote-na ensel-me ipua upaame Josep gupa epa lakesa: Nena naaki agiaaya mea pu no Isip su-para pogola pulupa. Ne go su-para piraina wala orope go su gimape yapi di epa lagialua. Abiare Herot-me go naaki asapua tulalo pia. ");
INSERT INTO kew_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Gore Josep go agaa pagoa sana nipu ruma rumane rekoa nipuna naaki agiaaya mo Isip su-para mea pisa. ");
INSERT INTO kew_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Josep nipu mo Isip su-para pirina Herot omesa. Josep nipu go su-para pisare Gote-na agaa lakene aanu lakesa-pulu pa pisa. Buk madaa Gote-na agaa lakene aa nipumi gupa tisaa-ya: Nina naaki Isip su-para pirisa pare neme yaasude tu isaya. ");
INSERT INTO kew_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Gore abade mo naare ipula-nane piri aanumi Yesu madini su Herot nalakeloa pogola pisimi-pulu Herot-me nimu ratu yawesa. Herot nipumi mo kimisu aanu-para agaa misa rabu go aanumi mo uba kedo opasade di lakesimi-pulu Herot-me mo naaki madini di niminaawa tu maomaatalo pisa. Go raburi nipumi Betlehem su-para pirua maali laapo abi napati naaki rayo tu maomaaina sa. ");
INSERT INTO kew_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Go kone madaare abade Gote-na agaa lakene aa meda Jeremaia-me abade saa agaame gupa lakesa: ");
INSERT INTO kew_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Rama su adaare-parare agaa meda pagoaeme. Go agaare nimumiri re lo pirua odome omoaeme. Go rabu ona Resel-me nipuna nogo naakinu madaa re loaaya. Go rabu onaanumi go onaana pu robaa namakuma paeme. Dia-ga nipuna nogo naaki omesimi-pulu nipu re lo piruaaya. ");
INSERT INTO kew_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Orope Herot aba omenaloa Aa Mudu-na ensel medame Isip su-para ipua Josep nipu upaame gupa epa lakesa: ");
INSERT INTO kew_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ne rekoa nena naaki agiaaya mea pu nimina su Israel su-para wala pulupa. Mo naaki tulalo paade aare aba omaade. ");
INSERT INTO kew_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Gore Josep nipu rekoa nipuna naaki agiya mea pua Israel su-para wala pisimi. ");
INSERT INTO kew_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Gore Arkelaus-me nipuna aaraa Herot alopaawa nipu Judia suna aa mudu pirisa. Gore Josep-me go remaa aba pagesa-pulu nipu go su-para pope paalame omesa. Pare Gote-me Josep upaame agaa gupa epa lakesa. Go nimu Galili su ru-nane wala pisimi. ");
INSERT INTO kew_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nipu pua Nasaret adaare-para pua pirisimi. Gore abade Gote-na agaa lakene aanumi ora agaa gupa lo mapataasimi: Nipuri Nasaret su-para piri aa simi. ");
INSERT INTO kew_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Jon Batais ipua sana Judia su onaa napiri rina su-nane epa aawa Gote-na agaa lakelo aasa. ");
INSERT INTO kew_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Gore nipumi lalo: Gote-na Surube Suri aba re-para go epea-ga nimina pupitagi nape kone gimalepa sa. ");
INSERT INTO kew_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Abade Gote-na agaa lakene aa Aisaia-me Jon madaa agaa gupa sa: Aa medame onaa napiri su-para aawa agaa gupa yaatea: Aa Mudu nipuna poranu waru wari salepape. Nipuna pamuape pora maredepo yatepape sa. ");
INSERT INTO kew_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon nipumi abade kamel menana iri maraawa mena yoganeme warini aako let-me rabuniaawa yamesa. Goa puare nipumi mata-para alubi aapa-para asapu no pirisa. ");
INSERT INTO kew_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Go rabu mo Jerusalem su-para Judia su rayo-para piri onaanumi ipa Jordan repaa-para piri onaanu page Jon nipu piri-para ipisimi. ");
INSERT INTO kew_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ipuare nimuna waeanu lapedepe ne agaa lakesimi rabu Jon-me ipa Jordan-para baptais kasa. ");
INSERT INTO kew_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yapare Jon nipumi Farisi aanu-para Sadyusi aanu-para nimu baptais minalo adesa. Goa pua nipumi nimu gupa lakesa: Nimiri wae paakame madini aanu pimi. Aapimi nimi gupa lagia ya? Gote-na orope ratu yawape konere nimimi adobaawa piralimi. Go ratu yawe konere nimimi madaa pogola palimi ya? ");
INSERT INTO kew_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nimimi epe kogono pipape. Nimimi goa pua kone rulalimi-daare ora kone rulae onaanu pitapape. ");
INSERT INTO kew_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nimina robaa-parare Abraham-re niaana Aapa kone nasalepape. Neme nimi lagialo: Go ia aana-re Gote-me Abraham-na sinu mada ma-aulaalia. ");
INSERT INTO kew_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Rai gaapiri repena re-para aba apo ia-daa ini waru namadialiade repenare pitaa poa repena sulaa-para mea iralia. ");
INSERT INTO kew_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nemere nimi kone perekealiminalo pa amaa baptais gialo. Pare orope epaliade aa medamere Holi Spirit-na purimi repena sulaa nona piane yae raapu baptais gialia. Niri raba mi aa ya-pulu neme go aa-na aariti esepea kege radepetalo palua pare mada dia. ");
INSERT INTO kew_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nipuna lama saapia nipuna kimi ripinua aaya. Goa pua mo wit-na ini raapu ripu raloa go epe ininu agu mua nipuna kiritape ada-para sulalo palia. Gore wae ripuri aipapulu nauduni repena sulaa-para mea iralia rabu pa roalia sa. ");
INSERT INTO kew_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Go raburi Yesu nipumi su Galili gimoa ipa Jordan-nane ipisa. Nipu Jon piri pua Jon-me baptais kanalo pisa. ");
INSERT INTO kew_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Goa pisa pare Jon-me Yesu gupa lakesa: Neme ni baptais gialiri epe ta-ga akeane neme baptais gialua pae? ");
INSERT INTO kew_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Gore Yesumi nipu agaa gupa abusa: Palaina abiare neme toade-a pape. Niaame goa palimi-daare Gote-me pamina ta rayo palima. Goa sa-pulu Jon-me nipuna agaa ratisa. ");
INSERT INTO kew_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesu nipu baptais aba mua aipapulu nipumi ipa Jordan gimoa so repaa-nane ipisa. Goa pua Yesumi gupa adesa: Yaa-para pora gaape lobesa rabu Gote-na Holi Spirit yaa puluma nona piane biyaa ipua nipu madaa epaa pirisa. ");
INSERT INTO kew_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Go rabu agaa meda yaa-para gupa laniaasa: Gore nina si-ga neme nipu madaa ora pedo waru pisa. ");
INSERT INTO kew_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Go raburi Holi Spirit-mi Yesu nipu onaa napiri su-para mea pisa. Go rabu Satan-me nipu kone adolalo ko tisa. ");
INSERT INTO kew_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesu nipu raa-para yapi 40-pela pirua eta nanisa-pulu reame omesa. ");
INSERT INTO kew_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Go rabu Satan-me ipua sana Yesu-para goa sa: Nere ora Gote-na Si yaliare neme te rabu go aana-me bret aunialoa mea na sa. ");
INSERT INTO kew_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Go raburi Yesu nipumi agaa gupa lakesa: Gote-na buk madaa agaa gupa ia: Onaanumi bret agu noa epe-rupa napirualimi pare Gote-na lagi agaa rayo waru pagoare oro yaalo epe-rupa pitimi sa. ");
INSERT INTO kew_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Go raburi Satan-me Yesu nipu wala so epe Jerusalem siti-para lamua pisa. Gore nipu ora so lotu adaa masaa madaa lamu pua goa lakesa: ");
INSERT INTO kew_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Nere ora Gote-na Si yalia-daare gore ne go lotu ada masaana aawa su amaa epa pogolape. Gore Gote-na buk madaa agaa gupa ia: Gote-me ne madaa nipuna ensel-nu lakeloa ripinaatepa tea rabu ne waru suruboa kimi ripinaabalimi. Goa pea-ga pogolali-daare aana-me page nena aa mada natalia sa. ");
INSERT INTO kew_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Gore Yesumi nipu goa lakesa: Gote-na agaa i buk madaare agaa meda gupa ia: Neme nena Mudu Gote-re kone adolalo nakotape ta. ");
INSERT INTO kew_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Satan-me Yesu wala mea puare ora so pore medana eke madaa pua aaware su rayona i yaenu Yesu walabesa. ");
INSERT INTO kew_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Gore nipumi Yesu gupa lakesa: Neme ni madaa rumu koba pua nina bi minasaali-daare go su amaa ia yae rayo ne gialua sa. ");
INSERT INTO kew_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Go rabu Yesumi nipu goa lakesa: Satan nere pane pu. Gote-na buk-mi agaa gupa ta: Nena Mudu Gote padane pia-ga nipu padanena bi minasaawa nipu padanena kogono pape. ");
INSERT INTO kew_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Go raburi Satan-me Yesu nipu gimenaloa Gote-na ensel-numi nipu raba mula ipisimi. ");
INSERT INTO kew_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesumi Jon kalabus ada mapataarimi remaa pagesa-pulu nipu Galili su-para pisa. ");
INSERT INTO kew_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Gore nipu Nasaret su-para napirisa pare Kaperneam su-para pua pirisa. Kaperneam suri ipa Galili ini repaa-para aasa. Go Kaperneam adaare-re Sebulun-para Naptali su lapona robo rikiraana aasa. ");
INSERT INTO kew_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Gore aba Gote-na agaa lakene aa meda Aisaia-me laama ipisa agaa ratua pa amaa ipisa. ");
INSERT INTO kew_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Sebulun su-para Naptali su lapo-para piri onaanuri nimina su lapona porare mo ipa repaa-nane pua ipa Jordan-na mone pane aina. Go su laapo-parare ora Galili su robo ru-nane aasa pare ruru rado onaa adaapu pirisimi. ");
INSERT INTO kew_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Go su ribaane-para pirisimi onaanu nimumi epe adaa paa adalimi. Onaa rayore omape su ribaane-para piri onaanu nimi pimi-para paa ora epalia. ");
INSERT INTO kew_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Go raburi Yesumi nipuna epe agaa ripima lakesa: Gote-na Surube Su ora re-para go ipula-ga nimimi wae kone gimoa lo robaa perekealepape sa. ");
INSERT INTO kew_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu nipu ipa Galili ini repaa-nane pamuala aasa rabu nipumi ameaya lapo adesa. Go ameaya lapore Saimon Pita-para ame Andru lapome ena meape kogono pua agona pa amaa pisipi. ");
INSERT INTO kew_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Gore Yesu nipumi lalo: Nipiri ni raapu baina. Go ena meapena-rupa nipimi onaa mealipinalo mogealua-ga ipulupa sa. ");
INSERT INTO kew_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Gore nipu lapome aipapulu mo ena agona gimoa nipu raapu pisipi. ");
INSERT INTO kew_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nipumi wala ogesi-daa pua ameaya lapo meda adesa. Nipu lapore Sebedi-na si Jems-para Jon ameaya pirisipi. Nipuna aaraa Sebedi raapu ipunu madaa pirua nimuna ena agona rabu lala pirisipi. Yesumi nipu lapo ipulupa sa. ");
INSERT INTO kew_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Gore nipuna Aapa page mo ipunu page gimoa Yesu rata mea pisipi. ");
INSERT INTO kew_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nipu Galili su rayona pora pamula pisa. Goa puare nipumi Juda aanuna lotu adanu-para onaanu Gote-na surube suna agaa pamu mogeasa. Gore nipumi Gote-na Surube Su madaa epe agaa pamu lakeloa sana mo onaanu nimuna yaina rado rado maperekeaawa nimuna yogane maepeaasa. ");
INSERT INTO kew_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Goa pisa-pulu nipuna bi so Siria su robo rayona piri onaanumi pago kiritisimi. Go onaanumi pago kiritaawa nimuna yaina rado rado-para radaame ome onaa page mea ria ipisimi. Nimuna yainare wae remo nimu madaa pirua maeya ne onaanu page pirua uni rayo oma pae page nimu mea ipisimi. Yesu nipumi nimu rayo maperekeaa kiritisa. ");
INSERT INTO kew_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Go rabu ora onaa adaapumi Yesu rata mea pisimi. Nimuna suri Galili-para adaare Dikapolis-para Jerusalem su-para Judia su robo ru-nanepara ipa Jordan-na mone pane piri onaanu-para ora rayore agaa pagoa rata mea pisimi. ");
INSERT INTO kew_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu nipumi mogo onaa adaapu adoa nipu so rudu madaa opasaawa pua pirisa. Go rabu nipuna disaipel onaanu padane-para epa pirisimi. ");
INSERT INTO kew_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Go rabu Yesumi nimu agaa gupa lakesa: ");
INSERT INTO kew_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Nimi rayona robaa-para epe kone mulalo pirua niminaalimi-daare raana omo piralimina. Gote-na Surube Su nimimi ora mealimina. ");
INSERT INTO kew_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nimi rayome re lo pi-daare pedo pu piramina. Gore Gote-me nimina robaa-para kuma mapainaalo goa palimina. ");
INSERT INTO kew_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nimi rayome nimina bi rabuaniaalimiri gore pedo pu piramina. Gore nimiri Gote-me su rayo gialia. ");
INSERT INTO kew_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nimi rayome Gote-na epe kone padane mulalo palimi-daare nimiri Gote-me eta rulatabenalo gialia. Goa pea-ga nimi pedo pu piralimina. ");
INSERT INTO kew_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nimi rayome onaanu odome omalimiri pedo pu piralimina. Gore nimi madaare Gote-me page odome omalia. ");
INSERT INTO kew_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nimi rayona robaa-para epeaaliare pedo pu piralepape. Nimimi Gote mada adalimi. ");
INSERT INTO kew_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nimi rayome yada mapataalo palimi-daare Gote-me nimi ora naa onaanu tea. ");
INSERT INTO kew_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nimi rayome Gote-na pora kurua kedaa rialimi-daare pedo pu piralimina. Nimiri Gote-na Surube Su adalimi. ");
INSERT INTO kew_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Gore nimimi naa ruru piritalo rata mea epalimide rabu nimumi adoa nimi-para ero agaa lo wae kedaa pi kone sua yaa agaa medaloma teme-daare nimimi pa raaname omalepape. ");
INSERT INTO kew_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nimina kone-para page raana waru omoa pedo waru palimina. Goa pea-ga nimi so yaa-para i yoto epe adaapu gialia. Go wae konere nimumi aba Gote-na agaa lakene aanu riri-nane aba mea kasimi. ");
INSERT INTO kew_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Nimi kone rulae onaanuri go su amaa piri onaanuna rikiraane aipa-rupa pimi. Goa pea pare mogo aipa-na rede aba dia yaliare gore niaame ake palima rabu aipa wala ma-rede palima ya? Go piane aipare nipuna rede napea-pulu onaanumi mea ruboa nipuna aame rabuaatalimi. ");
INSERT INTO kew_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Nimiri go su amaa piri onaanuna paa-rupa pimi. Goa pua adaare so rudu madaa waritimi rabu onaa rayome go adaarena paa waru ademe. ");
INSERT INTO kew_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Go page onaanumiri lam meda ewoa baket rolo-para nasalimi. Dia, pare ora ada-para mudialimi gomere ada ru-nane piri onaa rayo paa epe-rupa mealimi. ");
INSERT INTO kew_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Goa pea-ga nimina epe paame pa onaanuna ini agaa madaa roalia-daare nimumi nimina epe palimide kogono adoa nimina Aapana bi minasaalimi. ");
INSERT INTO kew_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Nimimiri neme Gote-na agaa lakene aanuna agaa-para rekena agaa-para gimaliminalo ipisude kone nasalepape. Dia, neme go yaenu mea rubolalo naipisu pare apo rekena agaana re waatalo ipisu. ");
INSERT INTO kew_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Neme ora nimi lagialo: Go su yaa lapo ora dia yaliade rabu page Gote-na rekena agaana oge tu saabae pepasinu page alupalia. Go rekena agaare ora pa saabaina Gote-me oyae rayo kiritalia. ");
INSERT INTO kew_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Goa pea-ga onaa medalomame go rekena agaare oge agaa meda kone sua onaanumi gimalimi-daare mogo rekena agaa ogeme-ga Gote-na Surube Su-para nimu page oge onaanu mapiraalia. Pare onaa rayome mo rekena agaa waru pagoa onaa medaloma pagenalo mogealimi-daare gore so Gote-na Surube Su-para page bi adaape salia. ");
INSERT INTO kew_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Neme nimi lagialo: Gore nimimi Gote-na agaa pagoa nimina epe koneme kogono palimiri mo rekena agaa tisaanu-para mo Farisi aanu-para nimuna kogono maoge yalimi. Goa napalimiri nimimi Gote-na Surube Su madaa na-adalimi. ");
INSERT INTO kew_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Niaana akuanumi abade pagesimi yaade agaare gupa pagesimi: Aa meda natu maomape tade. Pare aa meda tu maomaliri koso pagape aa piri-para mea palimi. ");
INSERT INTO kew_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pare neme abia nimi lagialo: Aa medame nipuna ame-para ratu yawaliare nipu koso pagape aa piri-para mea palimi. Go page aa medame nipuna ame-para agaa wae tea-daare kaunsil piri-para koso talo lamua palimi. Gore aa medame ame-para ne ora maeya ne aa yana tea-daare nipu mo wae repena sulaa-para mea lo palia. ");
INSERT INTO kew_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Goa puare neme Gote-para ora pi lape eta mea yawo sua aana reke alta madaa mea epali rabu neme nena ameme ne madaa wae kone inare go kone aba maepeaape: ");
INSERT INTO kew_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Gore nena mo rialide ofa mo aana alta madaa pa yawo sape. Goa pua nena ame piri wala pua mode agaa wae wala pua maredepo yatepape. Go agaa aba wari kirituare orope Gote mo eta mea pua ora pi ta paina. ");
INSERT INTO kew_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Gore aa medame ne raapu koso loa agaa unini salia-daare pena pora-nia palipi rabu epe kone sua agaa maredepo yaawa pulupape. Goa napaliri go aame ne aipapulu koso pagape aa piri-para mea palia. Goa puare mo aame ne plisman-nu mea katea. Goa puare nimumi ne mea pua kalabus ada mapataalia. ");
INSERT INTO kew_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Neme ora ne lagialo: Nena koso kabape mone rayo mada na-abulu kiritaliri gore neme mo kalabus ada mada nagimali. ");
INSERT INTO kew_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Yesumi goa sa nimimi go agaare aba pagesimide sa: Neme ona paake nayolape. Neme aa paake narumaape temede sa. ");
INSERT INTO kew_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Go agaa aba pagesimide pare neme nimi wala gupa lagialo: Gore aa medame ona meda adalia pare nipumi go ona paake lamualua kone salia-daare go konemere mo ona aba paake yota. ");
INSERT INTO kew_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Go pea-ga nena ini popo ki-naneme wae yaenu adoa pulalo paliare neme go ini rasua rubape. Goa pua nena ini padane rasu rubali rabu nena to yogane rayo wae su-para namea lopalia. ");
INSERT INTO kew_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Go page nena popo ki-naneme ne wae yae mulalo paliare go kiri kepe rubape. Goa pua nena ki padane aaware nena to yogane rayo su wae-para namea lopalia. ");
INSERT INTO kew_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Yesumi wala goa sa: Abade go agaa madaare akuanumi gupa simi: Aa medame nipuna ore gimalia-daare nipumi ona rugulape pepa meda ore kalape simi. ");
INSERT INTO kew_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Goa simide pare neme nimi lagialo: Aa rayome ona nagimalepape. Go ona paake rumea loa pa amaa nagimalepape. Goa pea pare neme agaa loa ona nagimape. Gimaliare ne page repaayana pora rugiti. Go page pa aa medame gimi ona rumaalia-daare neme page ona paake yone aa piralia. Goa pua repaaya maoyaali. ");
INSERT INTO kew_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Yesumi agaa meda ora mone yola moneaawa gupa sa: Agaa medare abana akuanumi gupa simi-daa aba pagemede agaare gupa: Nimi yaa madaa makuaa agaa meda Gote-na ini agaa madaa talo palimi-daare go agaa madaa kone waru sua pipape simi. ");
INSERT INTO kew_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Goa simi pare neme nimi lagialo: Nimimi yaa madaa makuaa pi natapape. Yaa madaare Gote nipuna pirape reke yaade. Go pea-daa yaa madaa makuaa loa nimina agaa puri namapalaatepape. ");
INSERT INTO kew_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Go page nimimi yaa madaa makuaa agaa meda go suna bimi puri namapalaatepape. Dia, go suri Gote nipuna aa lopae su yaade. Go page nimimi Jerusalem sumiri su yaa lapo makuaa agaa meda natapape. Dia, Jerusalem sumiri Aa Mudumi mea wasade su yaade. ");
INSERT INTO kew_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Gore nimimi nimina aalu iri wala yaako pi kobere-daa mada namea ma-alimi-pulu nimina aalu madaa yaa madaa makuaa agaa page natepape. ");
INSERT INTO kew_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Gore nimimi agaa teme rabu e-para dia lapo agaa agu tapape. Agaa mariripu temere Satan-me malaaya. ");
INSERT INTO kew_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Nimimi agaa abade gupa pagesimide: Aa meda nena ini apeminaliare nipuna ini page apeminape. Aa medame nena agaa kimi oda taliare nipuna agaa page abuloa oda tape simide. ");
INSERT INTO kew_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Goa simi pare neme nimi lagialo: Aa medame nimi-para waea paliade raburi nipu ratu nayawalepape. Dia, pare aa medame nena peae ki paarame rola taliare gore perekea tua peae meda-nane rola tina waalape. ");
INSERT INTO kew_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Gupa wala aa medame nena mamina mua ne koso madaa aditalo paliare gore nena mamina meda page nipu wala kalape. ");
INSERT INTO kew_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Gore bali medame nipuna oyaenu su ogesi-daa adaalu-para mea ria tea-daare gore neme wala ogesi-daa su rado meda adaalu nona piane-para page mea riape. ");
INSERT INTO kew_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Go page aa medame ne-para oyae gi tea-daare neme nipu kalape. Gore aa medame ne-para yoto meda gi tea-daare neme masaa nariaalape. ");
INSERT INTO kew_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Yesumi agaa meda wala gupa sa: Akuanumi abade simide agaa gupa simi: Nimina adami onaa-para epe pedo pi kone salepape. Nimina iaanu-para wae kone salepape simi. ");
INSERT INTO kew_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Goa simi pare neme nimi lagialo: Nimina iaanu-para epe pedo pi kone waru salepape. Goa page nimi-para waea palimiri go wae kone mea rubainalo Gote yaaloa beten tapape. ");
INSERT INTO kew_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Goa palimiri nimiri so yaa-para pia Aapana onaanu piralimi. Gote-me onaa wae epe lapo rata madaa naare apo marasaana-daa. Go page nipumi yai page aa wae epe lapo rata madaa apo epena sana-daa. ");
INSERT INTO kew_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Go pea-ga mo onaa medalomame nimi raana omalimide madaa nimu raana omalimiri go madaare epe yoto mealimina? Dia, mo takis meape aanumi page goa peme. ");
INSERT INTO kew_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Go page nimina amenu-para abi patalepape temere mo onare akea teme pae? Gore baptais abi nami pa pimi onaame page goa peme. ");
INSERT INTO kew_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Gore nimi ora waru epe-rupa piralepape. Nimina Aapa so yaa-para epe-rupa pia-rupa nimi page epe-rupa mapiraalia. ");
INSERT INTO kew_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesumi goa sa: Nimimi waru adalepape. Nimimi lotu kogono pulalo peme rabu onaanumi nimi adena kone sua napipape. Nimimi niaana epe kogonore onaame adena kone salimiri nimina so yaa-para piri Aapame nimina epe yoto meda na-abutea. ");
INSERT INTO kew_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Go page nimimi naraame ome onaanu nimu oyaeyae raba mu katemere gore nimimi penaame go yae mealepa loa yalaari napulupape. Goa palimiri nimimi yaa agaa ne onaanuna kone padane mogeaaeme. Nimuri lotu ada-para mo pora-nia page pamua oyae kateme. Gore mo pi onaanumiri nina bi padane minasaaina kone imi. Nina agaa pagalepa. Goa pemere nimuna yoto oyaenu aba penaame go muaeme-daa. ");
INSERT INTO kew_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pare nimimi mo onaa naraanu raba mulalo palimiri oraa ki-naneme palide-a podo ki-naneme namakuaaina lape. Nena adami aa page agaa napagena lape. ");
INSERT INTO kew_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Dia, pare kudiri pi kone sua epe bi mulalo kogono pipape. Goa palimiri nimina Aapamere nimina epe kudiri pi kogono adoa nimi epe yotome abutea. ");
INSERT INTO kew_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Yesumi agaa meda gupa sa: Nimimi beten temede raburi yaa agaa ne onaa-rupa natapape. Nimimi lotu ada ru-nane aawa beten tapape. Go page nimumi adaa pora aane-nane page onaanumi niaa adena kone sua beten natapape. Goa pea-ga nina agaa pagalepa. Gote-me nimuna yoto oyaenuri aba kasa. ");
INSERT INTO kew_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Go yapare nimi beten ripima talo palimide raburi nimina ada rum-para pua pora poa nimi na-ademe Aapa madaa beten tapape. Goa puare nimina Aapame apo epe kaledoa teme beten adoa nipumi nimi-para page abutea. ");
INSERT INTO kew_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Go page nimimi beten temede raburi pa agaa meda yoloa nane gimalepape. Mo baptais nami onaanumi beten lo yoloa adaapu teme rabu waru pagalia kone imi. Go-rupa natapape. ");
INSERT INTO kew_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nimi nimuna kone naratalepape. Dia, nimimi beten talo koneme aba managolaeme raburi nimina Aapa Gote-me nimi madaa rudu ta oyae rayo aba adoa makuaaya. ");
INSERT INTO kew_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Gore nimimi beten gupa tapape: Niaana Aapa, nere yaa-para pi. Nena biri oro yaalo epe-rupa ina. ");
INSERT INTO kew_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nena Surube Su epena. Nena konemere so yaa-para peme-rupa su amaa niaame page goa palima. ");
INSERT INTO kew_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Abia go yapi padane madaare neme niaana eta rumaaina. ");
INSERT INTO kew_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Neme niaana wae yaenu mea rubaina-ga niaame page wae kone saapi onaanuna kone mea rubalima. ");
INSERT INTO kew_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Neme niaare wae kedaa pi yaeme ko nataina pare Satan-me niaa natinalo surubape. ");
INSERT INTO kew_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Pagalepa. Nimimi onaa medalomana wae yaenu mea raakepe rubalimiri gore nimina so yaa-para pia Aapame nimina wae yaenu page mea rubalia. ");
INSERT INTO kew_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pare nimimi pa onaa medalomana wae yaenu namea raakepe rubalimiri nimina Aapa nipumi page nimina wae yaenu mada namea rubalia. ");
INSERT INTO kew_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yesumi agaa meda wala gupa sa: Nimimi lotu kone sua eta gimalimi rabu yaa agaa ne onaa-rupa napipape. Nimuna ini agaa-para roke piralimina. Goa pua nimi reame ome onaa kone inalo peme. Pagalepa. Nimuna yoto oyaere aba muaeme. ");
INSERT INTO kew_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pare nimimi nape yae madaa niti pua gimalimi rabu nimina aalu-para wel mea puare nimina ini agaa-para waswas talepape. ");
INSERT INTO kew_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Goa palimi raburi nimimi eta gimalimi onaanumi mada namakuaalimi. Nimumi mada na-adalimi pare nimina na-adape Aapame apo kudiri pu i epe konere nipumi mada adalia. Goa puare nena epe yoto mada abutea. ");
INSERT INTO kew_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Nimimi epe yaenu go su amaa nakirita salepape. Go su amaare go epe yaere daalinumi noa pa ramualia. Go su-para page paake ne aanumi kepo aguloa meme. ");
INSERT INTO kew_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nimina epe yaenu rayore go su amaa nakirita salepape pare go yaenu so yaa-para kirita salepape. So yaa-parare daalinumi nano mada naramualia. Goa pua paake ne aanumi page so yaa-para yaere namealimi-ga so yaa-para oyae epe-rupa pa saabalia. ");
INSERT INTO kew_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Gore epe yae kirita sali-parare nena kone page go-para pa saabalia. ");
INSERT INTO kew_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Niaana iniri niaana tona lam paa-rupa roaaya. Ini epeaaliare gore nena to rayo page epeaalia. ");
INSERT INTO kew_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pare ini o yaliare gore nena to rayo-para ribaa yoa o yalia. Goa pea rabu nena robaa-para roalia paa wala udinalia. Goa pua nena yogane-para ribaa yoa ne ora maoyaalia. ");
INSERT INTO kew_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Bosboi laapona kogonore aa padaneme mada napalia. Goa palia raburi aa meda madaare epe kone sua aa meda madaare wae kone sua aalia. Goa pea-ga aa padane madaa ora raaname omoa aa meda-parare nipu ratu yawalia. Go page nimimi Gote-na kogono pala mone kogono pala mada napalimi. ");
INSERT INTO kew_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Yesumi agaa meda wala gupa sa: Neme nimi lagialo: Niaa epe-rupa piramina kone adaapu nasalepape. Gore niaame ipa eta lapo ake nalima pae lo niaana yogane madaa ake maraalima pae loa kone adaapu nasalepape. Gore epe-rupa pirape konemere pa nape eta kone rabuaniaaya. Go page yoganeme pa mamina maraape kone rabuaniaaya. ");
INSERT INTO kew_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nimimi so biyaa pameme yaanu adalepape. Nimuna nape repena ini maapu napoa nimuna etare ada-para nakirita peme. Goa napeme pare nimina so yaa-para pia Aapame nimu eta kata. Pare Aapame nimi madaa ia koneme go yaanu rabuniaaya. ");
INSERT INTO kew_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nimimi go su amaa i yae madaa kone adaapu salimiri go konemere nimina pirape maali ogesi-daa adaalu mada namayola salia. ");
INSERT INTO kew_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Goa pea-ga nimina konere akeane mamina oyae madaa penaateme? Nimimi oge repena ini so amaa-nane opena adalepape. Gore nipu opea rabu nipumi kogono napua mamina page nawarita. ");
INSERT INTO kew_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Goa pea pare neme nimi lagialo: Abadere King Solomon nipuna pepena mamina epe epe yae agu yamesa rabu mo plaua ini madaa pea-rupa nipumi pepena go-rupa pisa pare plaua-me nipuna pepena rabuniaaya. ");
INSERT INTO kew_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Abia e-para ripu puti ia pare ekeraare wala tua repena sulaa-para iralimi. Pa ripumiri Gote-me pa suna pepena paaya. Goa pea nimi onaanuri ni madaa kone ogepusi rulaeme. Nimina Gote-me nimi page waru surubalia. ");
INSERT INTO kew_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Goa pea-ga nimimi kone adaapu gupa nasalepape: Niaame eta ipa lapore ake nalima palo mamina ake maraalima palo kone nasalepape. ");
INSERT INTO kew_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Go kone rayore su amaa kone narula pa piri onaanumi nimuna meape kone yaade. Pare nimina so yaa-para pia Aapa nipumi nimi adoa oyae gialia. ");
INSERT INTO kew_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Go kone nasalepape pare kone pereke sua Gote-na Surube Su madaa page nipuna pape kogono page go lapo madaa kone aba saapiralepape. Goa palimi-daare nipumi oyae radonu page mada nimi gialia. ");
INSERT INTO kew_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Goa pea-ga ekeraa-nane akea palua pae kone nasalepape. Dia, ekeraa-nane pape kone sape yaenu pa epalia. Gore yapi meda madaa kedaa pa nariaalepape. Gore pa kedaanu ya-pulu nipuna pa epalia. ");
INSERT INTO kew_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yesumi agaa meda wala gupa sa: Nimimi onaa medaloma pa amaa namariaawa koso laawa namea rumaatepape sa. Goa pua Gote-me nimi page go-rupa mada mea rumaalia. ");
INSERT INTO kew_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nimimi onaa meda pa amaa mariaawa koso teme-daare gore Gote-me nimi madaa goa padane-rupa abutea. Nimimi go-rupa rumaalua kone salemede-rupa go rumaape kone madaa-ga Gote-me nimi padane-rupa abutea. ");
INSERT INTO kew_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Gore nimina amena ini-para oge ini mare aba adema teme. Goa pea pare nimina ini-para i repena rekene na-ademe. ");
INSERT INTO kew_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Gore nimina ini-para repena rekene nona piane wala ia-ga akeane gupa teme: Naa ame, nena ini-para ia oge ini mare mea rubano teme. ");
INSERT INTO kew_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Go aa nere yaa agaa ne aa yaade. Aba ripiare nena ini-para ia repena rekene mea rubape. Goa pua oropere inimini waru pua nena amena ini-para aaya loma epe-rupa mada rasamina. ");
INSERT INTO kew_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Nimimi Gote-na yaere yananu nakatapape. Goa puare wala nimumi kaulataboa ne nolalo palia. Go page nimi kulubunu epe epe yaenu menana maa-nane namudiatepape. Goa puare nimimi mogo epe kulubunu rugulabebe palimi. ");
INSERT INTO kew_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yesumi goa sa: Nimimi Gote-para beten teme-daare nipumi mada gialia. Nimimi oyae asapalimiri nimimi mada adasaalimi. Nimimi pora gaape pua tata palimiri Gote-me nimi-para pora gaape mada lobalia. ");
INSERT INTO kew_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Onaa rayome Gote-para beten temere gore nimumi oyaenu mada mealimi. Onaa rayome oyaenu asapalimi-daare mada ada salimi. Gore aame pora gaape talia-daare Gote-me pora mada lobalia. ");
INSERT INTO kew_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Gore nimina naakinumi Aapa yaaloa bret meda gi tea-daare nipumi aana meda mea katea ya? Dia. ");
INSERT INTO kew_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Go page mo naakimi Aapa yaaloa ena page meda gi tea raburi wae paaka meda katea ya? Go page mada nakata. ");
INSERT INTO kew_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Goa pea-ga nimi aanumi nimina naaki nogonu epe yaenu pa kateme-ga nimina so yaa-para pia Aapamere nipu madaa beten teme-daare nipumi epe oyae page pa mea gialia-ga beten loa agaa mealepape. ");
INSERT INTO kew_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Pa onaanumi epe kone mua ni padane goa meda pina kone satemade-rupare neme page goa pape. Gore apo kone madaare Moses-na rekena agaa-para Gote-na agaa lakene aana agaa rayo go-para ia. ");
INSERT INTO kew_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Yesumi agaa gupa sa: Nimiri oge pora gaape-para ora pua puaa odobatepape sa. Pora medare mo wae su-para pope pora gaape adaape mada lobapa ia. Onaa adaapuri go pora-para polalo peme. ");
INSERT INTO kew_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Goa pea pare oro yaalo kagaa pirape pora gaapere ora ogesi ya-pulu kalai waru palimi. Goa pea onaa padane padane laatapumi go pora-para mada palimi. ");
INSERT INTO kew_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yesumi agaa meda gupa sa: Gote-na bi madaa yaa agaa ne aanuri waru adalepape. Nimi piri-para epalimi rabu nimumi epe sipsip menana yogane aako yameme pare nimuna robaa-para raa yana maeyae-na kone sua nimi nolalo peme. ");
INSERT INTO kew_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Go yaa agaa ne aanu epalimi rabu nimumi kogono palimi waru adoa niminaatepape. Repena etolo etolo aere epe repena wain-na ini mada namadialia. Go page repena fik-na epe iniri mo ripu wae pepo pi puti-para mada naratemade ora dia. ");
INSERT INTO kew_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Goa pea-ga ipa waru piri repena rayo madaa ini epe-rupa madita. Pare wae kaapu ne repena rayo ini wae-rupa madita. ");
INSERT INTO kew_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Epe repenamere repena ini wae-daa mada namadialia. Go-rupa agu repena waeme epe repena ini meda namadialia. ");
INSERT INTO kew_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Repena rayo ini epe-rupa namaditare poa repena sulaa-para mea iralia. ");
INSERT INTO kew_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Goa pea-ga mo Gote-na bi madaa yaa agaa loa makirae aanumiri kogono peme rabu nimuna madialimi ini adalimina. ");
INSERT INTO kew_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Gore onaa rayome ni-para Aa Mudu teme pare nimimi Gote-na Surube Su-para madaa na-adalimi. Dia, pare onaa rayome niaana aapa so yaa-para piana kone ratalimiri Gote-na Surube Su-para mada adalimi. ");
INSERT INTO kew_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Apo yapi di epaliade rabu onaa adaapumi gupa teme: Aa Mudu, neme abade nena bi onaa lakelo epe agaa mogeasima teme. Nena bi lakeloa abade niaame onaana wae remonu mea ruboa napi kogono adaapu pasima teme. ");
INSERT INTO kew_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Go raburi neme nimu-para gupa laketoa: Neme nimina ini-para waru na-adesude-ga nimiri wae onaanu-ga ni piri-para paneaatepa toa. ");
INSERT INTO kew_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yesumi agaa meda gupa sa: Onaa rayome nina go agaa pago ratalimi-daare nimuna epe konere gupa imi: Aa medame ada pua aana-me puri mapalaasa. ");
INSERT INTO kew_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Goa puare yai ipisa raburi ipa roa rubisaawa puri pane po ripumi ipua go ada walu walu malaasa. Go pisa pare mo ada ora aana-me puri waru mapalaawa pea-pulu mada narobesa. ");
INSERT INTO kew_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Yapare onaa rayome nina agaa pagoa naratalimiri nimuna kone gupa imi: Go onaanuna konere ada pigi puri namapaalae pa mabaawa peme. ");
INSERT INTO kew_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Goa puare yai ipua ipa roa rubisaawa puri pane po ripu page ipua mo ada epa marobaasa. Gore mo ada lopesa rabu ora e waru sa. ");
INSERT INTO kew_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesumi go agaa lo kiritisa rabu pirisimi onaa rayome pogolasaasimi. ");
INSERT INTO kew_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Gore nipumi agaa lakesa rabu nimuna rekena agaana tisaanu-rupa nalakesa. Dia, pare nipumi puri pane aa-na agaa lakesa. ");
INSERT INTO kew_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu so rudu gimoa kilipia ipisa pare onaa rayome wala nipu rata mea ipisimi. ");
INSERT INTO kew_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Go rabu yakimi ti aa meda Yesu piri-para epa rumu koba pua pirua nipumi lalo: Aa Adaa, neme nina yaina mada maperekeaina kone salo sa. ");
INSERT INTO kew_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesumi nipuna yogane madaa ki oraawa lalo: Goa palua-ga abi kaapuaina. Goa sa rabu aipapulu mo rere rayo kaapu yabesa. ");
INSERT INTO kew_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesumi nipu-para lalo: Nere adoaape. Neme onaa medaloma nalakelape. Nena yoganere Gote-na miru irae aame adena pope. Goa puare Moses-me sa-rupa eta yawape. Goa pali raburi nena yainare aba go dia yanalo onaanumi mada adalimi. ");
INSERT INTO kew_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu nipu Kaperneam su-para pisa rabu soldia aanuna Aa Mudumi Yesu nipu-para agaame gupa ogesa: ");
INSERT INTO kew_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Aa Adaa, nina kogono naakiri yaina omoa ada saabaaya. Nipuna uni rayo omapaawa radaa ora adaape pea. ");
INSERT INTO kew_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Gore Yesumi lalo: Neme nipu maperekeaata palua. ");
INSERT INTO kew_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Yapare mo soldia aanuna Aa Mudumi Yesu nipu agaa gupa lakesa: Aa Adaa, niri epe aa-daa dia-ga nere nina ada-para mada naepali. Goa pea-ga neme pa agaame te rabu nina naaki mada perekealia. ");
INSERT INTO kew_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ni page naa soldia aa mudunumi ni surubeme. Neme soldia aanu page surube. Goa pea-ga neme soldia aa padane-para ne pu tore nipu mada palia. Aa meda ne ipu to raburi gore nipu mada epalia. Gore mo nina kogono naaki-para go kogono pa tore gore nipumi mada palia. ");
INSERT INTO kew_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesumi go agaa pagoa kone adaapu isa-pulu mo nipu raapu ipisimi onaanu-para gupa lakesa: Neme ora nimi lagialo. Israel su-para aa gupa kone rulae aa meda abade page napirisa. ");
INSERT INTO kew_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Gore agaa pagalepa: Onaa adaapu mo naare opala-nane page pabala-nane page epalimi. Gore nimumi Abraham-para Aisak-para Jekop-para so Gote-me Surube Su-para pirua akuanu raapu eta no piralimi. ");
INSERT INTO kew_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Goa palimi pare onaa medaloma so Gote-na Surube Su adolalo peme onaare nimu ribaaene-para wala mea ratu talia. Go-parare re waru loa nimuna abulu regepe no radaa nalimi. ");
INSERT INTO kew_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesumi mo soldia aanuna aa mudu goa lakesa: Nere abi pu. Neme kone rulaye-pulu nena kone sae-rupa ora palia. Goa sa-pulu nipuna kogono naakiri ora go rabu-ga maepeaasa. ");
INSERT INTO kew_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu nipu Pita-na ada-para pua odobaawa Pita-na aayaa kekapu yaina omoa patae ina pua adesa. ");
INSERT INTO kew_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Gore Yesumi nipuna ki mina misa rabu mo kekapu yaina aba aipapulu perekesa. Go rabu nipumi rekoare Yesuna eta iraasa. ");
INSERT INTO kew_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Gore aebore onaa medalomame wae remo piri onaa Yesu piri-para mea ipisimi. Nipumi agaame loa go wae remo rayo raakepe rubisa. Goa pua nimuna yaina rayo page maepeaasa. ");
INSERT INTO kew_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Go-rupa pisare abade Gote-me agaa meda Aisaia-na buk-para gupa sa: Nipumi niaana yaina rayore aba mea ruboa niaana yaina rado rado page maepeaasa. ");
INSERT INTO kew_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Gore onaa adaapumi Yesu kutapu ma-aawasimi rabu nipumi lalo: Niaare ipa mone pane kenaa moneaawa baina sa. ");
INSERT INTO kew_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Go rabu rekena agaana tisaa meda ipua sana Yesu goa epa lakesa: Tisaa, su rayona pamuali rabu ni ne raapu pamuapana. ");
INSERT INTO kew_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Gore Yesumi nipu lakesa: Raa yana pati-parare su-para naaku ia. Yaanu page ada waritimi pare ni Onaa Raapu Pirape Aa-na Siri nina kitu pirua patape ada dia yaade. ");
INSERT INTO kew_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Goa sa rabu nipuna disaipel aa medame nipu goa lakesa: Aa Adaa, ora lae pare nina Aapa aba rogaata pono. ");
INSERT INTO kew_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Pare Yesumi nipu goa lakesa: Gore ome onaanumi nimuna ome onaanu yago rogaalimi. Nere saana bana sa. ");
INSERT INTO kew_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu nipu ipunu madaa pirua sana nipuna disaipel aanu nipu raapu pisimi. ");
INSERT INTO kew_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Go rabu mo ipa adaape poripumi ipua ipunu maugitaalo pisa. Goa pisa pare Yesu nipu pa u patae isa. ");
INSERT INTO kew_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Goa pisa rabu mo aanumi Yesu nipu pua marekaawa lalo: Aa Adaa, neme niaa raba mea. Niaare go ipa noa ugialema-daa simi. ");
INSERT INTO kew_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Gore nipumi nimu lakesa: Akeane nimimi paala omeme ya? Nimiri naa agaa ogepusi robaa-para mua kone rulaeme. Gore nipu rekoa po ripu-para ipa lapo puri pane agaa lakesa. Go rabu po ripu loraawa ipa eto ogesi-daa napisa. ");
INSERT INTO kew_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Go rabu nimumi pogolasaawa lalo: Go aare ake piane aa ya simi? Go ipa-para po ripu laapome nipuna agaa pagea simi. ");
INSERT INTO kew_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu nipu ipa mone pane pua mo Gerasa ruruna su-para opapasa. Go-parare wae remo pabo piri aa lapome matmat aana apedaa gimoa Yesu nipu piri-para ipisipi. Nipuri ora raa-para maeya ne aa lapo ya-pulu onaa rayo pala omoa go nipu ae pora-nia napamisimi. ");
INSERT INTO kew_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Gore nipu lapome puri paloa gupa yaasipi: Nere Gote-na Si-ga neme niaa piri-parare ake pulalo epae? Gore goanu pape di abia dia-ga neme niaa radaa mea gulalo akolo epae pae simi? ");
INSERT INTO kew_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Go rabu menanu adaapupe mo-pare aawa eta nala aasimi ");
INSERT INTO kew_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Mo wae remome Yesu-para gupa ogesimi: Neme niaa ratu tulalo pali-daare niaa mogo menanuna robaa-para ratutape simi. ");
INSERT INTO kew_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Gore Yesumi mo remo-para nimi pulupa sa-pulu nimumi mo aa lapo gimoa remo nimu mo menana robaa-para pua odobasimi. Go mena rayo aloma pua mo rata madaa lopoa ipa ini-para pua ipa noa omabasimi. ");
INSERT INTO kew_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Go rabu mo mena surube aanu nimu pogola pisimi. Nimu adaare-para pua go remaa onaa rayo-para pua lakesimi. Lakesimi rabu mo wae remo pabo piri aa lapo madaa pianu rayo remaa pua simi. ");
INSERT INTO kew_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Go rabu mo adaare-para piri onaa rayome Yesu nipu madaama ipisimi. Goa pua nimumi nipu epa adoa gupa lakesimi: Go su gimoa nena su rado-para pu simi. ");
INSERT INTO kew_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu nipu ipunu madaa pirua ipa mone pane pua nipu adaare meda-para pua opapasa. ");
INSERT INTO kew_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Go rabu yaina ome aa meda Yesu piri-para ria ipisimi. Goa pisimi pare nipuna uniri rayo oma paawa reke madaa saabaasa. Yesumi nipuna kone rulae adoa mo yaina ome aa goa lakesa: Go naaki, paala naomape. Nena waeanu raakepe rubaato. ");
INSERT INTO kew_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Gore rekena agaa tisaanu medalomame go agaa pagoa nimuna kone-para gupa isimi: Go aamere Gote-para ero ta, kone isimi. ");
INSERT INTO kew_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesumi mo nimuna kone-para adokaru mua nimu-para lalo: Akeane nimina kone-para gupa saleme? ");
INSERT INTO kew_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Akea pua kuma pi agaa toa ya? Nena wae yaenu mea rubano kedaa pia? Ne rekoa pora pu lano kedaa pia? ");
INSERT INTO kew_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pare ni Onaa Raapu Pirape Aa-na Siri go su amaa onaanuna pupitagi neme kone mea raakepe rubalua-ga puri adalimina. Goa pua nipumi mo uni oma pae aa-para lalo: Ne rekoa nena u pati yaenu mea ripinua nena ada-para pu sa. ");
INSERT INTO kew_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Goa sa rabu nipu rekoa nipuna ada-para pisa. ");
INSERT INTO kew_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Onaa rayome go adoa simina paalame omesimi. Gore Gote-me go piane pinalo puri kasa-pulu nimumi nipuna bi minasaasimi. ");
INSERT INTO kew_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu nipu go su gimoa pore pamisa rabu aa meda Matyu nipu mone takis mi ada-para pirina adesa. Goa pua Yesumi nipu-para lalo: Nere saana bana. Goa sa rabu nipu rekoa rata mea pisa. ");
INSERT INTO kew_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesu go aa-na ada-para eta nala pirisa. Go rabu mone takis mi aanu-para naraa onaanu medaloma-para Yesu page nipuna disaipel aanu raapu pirua eta padane-para nisimi. ");
INSERT INTO kew_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Goa pisimi rabu Farisi aa medalomame go kone adoa nipuna disaipel aanu lakesimi: Nimina tisaa mo takis mi aanu-para naraa onaanu raapu pia-ga akeane go-rupa eta no pira ya simi? ");
INSERT INTO kew_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu nipumi go agaa pagoa nipumi lalo: Yaina naome onaanu nimuri dokta piri-para pemede. Dia, yaina ome aanu nimu dokta piri-para peme. ");
INSERT INTO kew_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nimimi Gote nipuna buk-para lagisade agaa aba pua niminaatepa: Ofa sape kone madaare neme raana napea pare neme raba meape kone madaa pedo pi. Yesumi wala lalo: Neme ora epe onaanu agu raba mulalo naipisu. Dia, pare naraa onaanu page raba mulalo ipisu sa. ");
INSERT INTO kew_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Go raburi Jon-na disaipel aanu Yesu piri-para ipua nimumi nipu-para lalo: Farisi aanu niaa page eta niti pua ado aema. Goa pema pare akeane nena disaipel aanumi eta pa nena te ya? ");
INSERT INTO kew_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Gore Yesumi nimu goa lakesa: Ona rumaatalo pe aare nipuna rurunu raapu pa piralia rabu nimuna kone-para kedaa napalia. Pare oropere go ona rumaatalo pea aare wala gimalia-ga go rabu mo nipuna rurunumi odome omoa eta nape madaa niti pua pa piralimi. ");
INSERT INTO kew_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Aa medame kagaa mamina rugini nipuna abana mamina podopene-para narabutea. Dia, pare nipumi go-rupa rugulua rabutea-daare mo mamina wala mariripiaa-mama pua adaapu riripi tabalia. ");
INSERT INTO kew_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Go page abana meme mena yogane-para aa medame kagaa ipa wain mada nanorialia. Goa pali-daare mo kagaa ipame meme mena yogane mariripiaawa mo ipa su amaa koyalia. Goa puare mo meme mena yogane page mapodopealia. Gore kagaa ipa wain-ri ora kagaa meme mena yogane-para no rialimiri lapo rata epeaalia. ");
INSERT INTO kew_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesumi nimu-para go agaa pa pena lakelala aina aa mudu meda Yesu piri-para ipua rumu epa koba pua gupa sa: Nina nogore abia ora ini adupia pare neme epa ki sali rabu mada rekalia sa. ");
INSERT INTO kew_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Goa sa rabu Yesu nipu mo aa mudu raapu polalo pisa rabu nipuna disaipel aanu page pisimi. ");
INSERT INTO kew_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Pora-nia pisimi rabu ona medare nipuna yaapi pupulae yainare maali 12-pela patisa. Go ona nipu Yesuna masaa-nane ipua nipuna mamina aane-nane kimi oraasa. ");
INSERT INTO kew_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Go ona nipuna robaa-para kone gupa isa: Neme nipuna mamina madaa ki oraaluare nina yaina mada dia yalia kone isa. ");
INSERT INTO kew_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Goa puare Yesumi nipu wala pereke tua adoa lalo: Go nogo. Neme ni madaa kone rulaate-pulu nena yaina abia madia yaato. Ora go rabu-ga go yaina epeasa. ");
INSERT INTO kew_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Gore Yesu nipu mo aa muduna ada-para pua opapaasa. Go-parare onaanumi emaa loa re adaa lo pirisimi. ");
INSERT INTO kew_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Gore Yesumi lalo: Nimi pane piralepa. Go nogore pa u patana. Ora ini na-adupiana. Go rabu nimumi nipu giri laasimi. ");
INSERT INTO kew_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mo onaa rayo pane pula pira loare Yesu nipumi mo nogona ada rum ru-nane pua ki mina mua nipu marekaasa. ");
INSERT INTO kew_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Goa pisa rabu go remaa su rayo-para pago kiritisimi. Yesumi ini rabuni aa lapo-para agaa maarea aanu page pua maepeaasa. ");
INSERT INTO kew_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu nipu go ada gimoa pora pamisa rabu ini rubu pi aa laapome nipu rata mea ipua gupa yaasipi: Nere Devit-na si-ga saa raba mea sipi. ");
INSERT INTO kew_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Gore Yesu ada ru-nane penaaloa mo ini rubu pi aa lapo nipu piri-para ipisipi rabu Yesumi nipu-para lalo: Go kogono mada palua-ga nipimi ni madaa kone rulalipi ya? Nipumi lalo: E, Aa Adaa mada palipa sipi. ");
INSERT INTO kew_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Goa sipi rabu Yesumi nipuna ini kimi oraawa lalo: Nipimi ni madaa kone rulaaripi-daare nipina ini madaa epeaalia. ");
INSERT INTO kew_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Goa puare nipuna ini wala epe sa. Goa puare Yesumi nipu-para puri pane agaa gupa lakesa: Nipimi waru kudiri pipape. Onaa medaloma nalaketapape. ");
INSERT INTO kew_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pare nipu gimoa pisa rabu go su rayona Yesuna remaa pamisa. ");
INSERT INTO kew_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Goa palaina onaa medalomame agaa maare wae remo pabo piri aa meda Yesu piri-para mea ipisimi. ");
INSERT INTO kew_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Gore Yesumi mo wae remo mea rakepeaasa rabu nipu laapome agaa lopaasipi. Gore onaa rayome kone adaapu sua gupa simi: Go Israel su-para napi kogono go pamu pia-daa simi. ");
INSERT INTO kew_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pare Farisi aanumi lalo: Wae remonuna aa mudumi nipu puri kanaloa go pia simi. ");
INSERT INTO kew_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu nipu su adaare rayo-nini pamua sana nimuna lotu ada-para agaa pamu mogeasa. Go rabu nipumi Gote-na Surube Su madaa epe agaame loa sana onaanuna yainanu maperekeaasa. ");
INSERT INTO kew_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nipumi mo onaa rayo odome omesa. Gore nimuna kone mabebola tua wae-rupa pirisimi-pulu nipumi odome omesa. Mo sipsip-nuna punini aaraa napirisa rabu go onaanu kalae-rupa pirisimi. ");
INSERT INTO kew_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Goa pisimi-pulu Yesumi nipuna disaipel aanu lakesa: Eta adaapu mo maapu-para poro aaya pare kogono pape aanu adaapu napimi. ");
INSERT INTO kew_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Goa pea-ga nimimi go maapuna aaraa-para eta ini mea kirita sula epena beten tapape sa. ");
INSERT INTO kew_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu nipuna aposel kogono aa 12-pela yaaloa nimu kogono papena puri mapalaasa. Gore nimimi wae remo rakepeaminalo yaina rayo maperekeaaminalo onaa raba minalo puri gialua sa. ");
INSERT INTO kew_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Mo aa 12-pela nimuna biri gupa: Saimon-re aba ripia Yesumi nipu aba mapiraasa. Nipuna bi medare Pita. Nipuna amere Andru page mapiraasa. Goa pua Sebedi-na si Jems-para nipuna ame Jon lapo page mapiraasa. ");
INSERT INTO kew_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Gore Filip-para Bartolomyu lapo mapiraasa. Medalomare Tomas-para takis mi aa Matyu lapo mapiraasa. Goa pua Jems-re Alfius-na si Tadius lapo mapiraasa. ");
INSERT INTO kew_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Goa pua Saimon Selot-para Judas Iskariot page mapiraasa. Go aamere pirua Yesu tapena kabereke misa. ");
INSERT INTO kew_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu nipumi mo aposel kogono aa 12-pela agaa mana gupa lakesa: Nimi aa ruru radonu piri-para napulupape. Goa pua nimi Samaria adaare-para page napulupape. ");
INSERT INTO kew_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Dia, pare nimiri Israel su-para piri onaanuri ora alupae sipsip-rupa pimi-ga nimu piri-para pulupape. ");
INSERT INTO kew_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nimimiri Gote-na Surube Su abia ora re-para epa ialo pua laketapape sa. ");
INSERT INTO kew_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nimimi yaina ome onaanu maepeaatepape. Ora ini adupini onaanu marekatapape. Mo yakimi ti onaanu maepeaatepape. Wae remo mea raakepe rubatepape. Gore nimimi go puri mealeme-pulu mo onaanuna yaina madaa yoto nami mada pa maepeaatepape sa. ");
INSERT INTO kew_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nimimi mone yo-para mone ini-para ora mone padane-para nimina oge nusi-para namadialepape. ");
INSERT INTO kew_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Go page nimimi palimi rabu rokanu namadia pulupape. Go page alopape mamina meda-para aa ada-para pora pamuape rimaapu page namea pulupape. Dia-ga aame pa palimi-daare nimumi eta oyae mada gialimi. ");
INSERT INTO kew_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Gore nimi adaare page su rado-para palimiri nimimi aba waru adalepape. Nimimi epe amenu medaloma aba waru adoa go aa raapu piraama puare nimi meape onaa dia yaliare puaa-mama pipape sa. ");
INSERT INTO kew_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Gore nimimi ada meda-para palimi rabu go ada-para piri onaa-para epe-rupa piralepape tapape. ");
INSERT INTO kew_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Gore mogo ada-para piri onaa-daa epe onaa yalia-daare gore nimina epe kone nimu madaa pa salepape. Pare nimumi abi piralepape agaa na-abutimi-daare nimina epe konere wala mua go ada gimalepape. ");
INSERT INTO kew_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Gore aa medame nimina agaa pagolalo nipuna ada-para nalamua palia-daare gore go adaare gimoa pulupape. Go rabu nimumi nimuna wae kone adenalo nimina aa madaa ae kege kunu sua pulupape. ");
INSERT INTO kew_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Pagalepa. Orope Gote-me onaanu yoto mea rumaa katea di raburi wae adaare Sodom Gomora su lapo-para pirisimide onaanu-para kedaa kasade. Goa pisade pare go kedaamere go su-para misimide kedaa rabuniaa mealimi sa. ");
INSERT INTO kew_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yesumi goa sa: Pagalepa. Neme nimiri maeyae yananuna rikiraana sipsip mena si-rupa mea rapaato. Goa pea-ga nimimi ora pawa pua paakanumi umu yoloa pameme-rupa pamualepape. Go page nimimi epe kone sua so yaa-para pirape kone mealimina pamualepape. ");
INSERT INTO kew_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Nimimi mo aanu waru adalepape. Nimumi nimi aditalo kaunsil-na ada mea pua nimuna lotu ada-para aipuyame nimi talimi. ");
INSERT INTO kew_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nimumi nimi koso laatalo mo aa mudu kadipinu piri-para mea palimi. Goa pua nimimi nina kogono pua nimu-para pa ruru radonu-para page epe agaa laketeme. ");
INSERT INTO kew_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Gore nimumi nimi koso lape agaa temede raburi niaa ake tema pae kone adaapu nasalepape. Dia, Gote-me go rabu laketemenalo agaa gialia. ");
INSERT INTO kew_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Go rabu nimimi agu raapo koso lape agaa nateme. Dia, Holi Spirit nimina robaa-para piralia rabu nimina Aapame agaa lagialia. ");
INSERT INTO kew_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Go rabu aanu nipuna amenu wala kosome mariaawa nipuna ame tu maomalimi. Gore aaraanumi page nipuna si-para waea palia. Sinumi page agi aaraanu-para agaa rasua koso lape agaa loa tu maomalimi. ");
INSERT INTO kew_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Go raburi nimimi nina pora ratalimi-pulu onaa rayome nimi ronome omalimi. Pare onaa rayome puri paboa ni nagi-mama palimiri orope go su yaa lapo dia yalia rabu go onaanu oro yaalo kagaa piraama laama palimi. ");
INSERT INTO kew_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Gore nimi adaare meda-para nimi kedaa gialimiri gore adaare rado meda-para pogola pulupape. Neme ora nimi lagialo: Israel adaare rayo-para kogono mada napu kiritalimi pare Onaa Raapu Pirape Aa-na Si aba epalia. ");
INSERT INTO kew_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Skul teme naaki nogo nimiri nimina tisaanu narabuaniaaeme. Go-rupa agu kogono pape aanumiri nimuna surube aa mada narabuaniaaeme. ");
INSERT INTO kew_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Goa pea-ga skul nogo naakimi nimuna tisaa-rupa piralimi-daare epe teme. Go page kogono pape aame nipuna aa mudu raapu nona pi piraliare epe teme. Goa pua ada padane surube aa-para wae bi Belsebul teme-daare nipuna ada raapu pimi-nu ora wae binu page katea. ");
INSERT INTO kew_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Goa pea-ga nimimi pa onaanu paalame naomalepape. Dia, abiare oyaeyae rayo rigitabaaya pare orope penaame sua kudiri pi kone rayo page onaanumi mada adoa penaame amaa pagalimi. ");
INSERT INTO kew_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Neme go ribaaene-para lagialo agaare nimimi naare paalu laketapape. Nimimi pawasi pagaleme agaare su rudu madaa rekaawa laketapape. ");
INSERT INTO kew_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Aa medalomame onaanuna to yogane mada tu maomalimi pare kone wasupa mada natu maomalimi. Goa pea-ga nimimi nimu madaa paala naomalepape. Yapare Gote-me yogane-para wasupa lapo repena sulaa-para mada mea iralia-ga nipu madaa paala omalepape. ");
INSERT INTO kew_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Nimimi oge yaasi laapore mone kane oge padaneme kabeme. Goa pea pare nimuna Aapame nalaketea-daare oge yaa padane su amaa mada nalopalia. ");
INSERT INTO kew_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Gore nimina aalu iri rayo Gote-me aba dipita. ");
INSERT INTO kew_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Goa pea-ga nimimi paala naomalepape. Nimimi mo ogege yaana kabape yoto ora maoge yateme sa. ");
INSERT INTO kew_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Yesumi agaa meda goa sa: Onaa rayome pa onaanuna ini agaana niaa Yesuna onaanu pima laketemere neme so yaa-para pia Aapa-para go onaanuna bi page laketoa sa. ");
INSERT INTO kew_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pare onaa rayome pa onaanuna ini agaana ni masaa rilalimiri so yaa-para pia Aapana ini agaa madaa neme nimu page gimalua sa. ");
INSERT INTO kew_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Nimimi niri go su amaa epe-rupa pirape kone mea ipisade kone nasalepape. Dia, pare neme rai kutu nona piane agaa mea ipisu. ");
INSERT INTO kew_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Naa ipisude kogono madaare yada pape kone adaapu gupa salimi. Aanu medaloma nimuna Aapanu-para iaa aulalimi nogonumi nimuna aginu-para iaa aulalimi orenumi aayaanu-para iaa aulaliminalo ipisude. ");
INSERT INTO kew_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Goa puare aa medana wae iaare nipuna ada padane-para piri onaanu re-para aulaawa ronome omalimi. ");
INSERT INTO kew_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Onaa rayome nimuna Aapa ama madaa pedo pu raana meme-rupa ni madaa raana waru naomalimiri gore go onaanu ni raapu mada napiralimi. Go page onaa rayome nimuna nogo naakinu pedo pu raaname omoa ni madaa raaname waru naomalimiri go page ni raapu mada napiralimi. ");
INSERT INTO kew_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Onaa rayome nina repena polopeana kedaa narua nina pora nakurialimiri ora ni raapu mada napiralimi. ");
INSERT INTO kew_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Gore onaa rayome nimuna yogane madaa kogono agu pu piralimiri nimuna wasupanu pa alupalimi. Goa pea pare onaa rayome ni madaa kone rulaawa nimuna yogane madaa kone narumalimiri nimuna wasupanu epe-rupa oro yaalo kagaa piraama laama palimi. ");
INSERT INTO kew_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Onaa rayome nimi mealimi-daare gore ni page mealimi. Gore onaa rayome ni madaa kone rulaawa epe-rupa mealimi-daare Gote-me ni mea epenasa-daa nimumi nipu madaa page kone rulaawa mealimi. ");
INSERT INTO kew_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Onaa rayome Gote-na agaa lakene aa epe-rupa raba mealimi-daare Gote-me epe yoto gialia rabu waru mealimi. Mo agaa lakene aa onaanu yoto mealimi-rupa go padane-rupa rumaalia. Onaa rayome ora epe aa meda epalia rabu go aa adoa neme go aa raba mealua kone salimi-daare go nimu raba meae aa-para padane-rupa epe yoto mealimi. Go agaa pagalepa. ");
INSERT INTO kew_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Onaa medalomame nina disaipel onaa meda ipa kogore nape pe meda kateme-daare go epe kone madaa epe yoto mealimi. ");
INSERT INTO kew_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesumi go agaare nipuna aposel kogono aa 12-pela lakesa. Go agaa lakelo kirituare nipu go adaare gimo mo-nane adaare medaloma-para puare go onaanu-para epe agaa lakeloa moge riaasa. ");
INSERT INTO kew_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jon-me nipu kalabus ada pirua Yesuna remaa pagesa. Go rabu nipuna disaipel aa medaloma Yesu piri-para mea rapaasa. ");
INSERT INTO kew_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Go aanu nimumi Yesu agaa gupa pua misimi: Nere Jon-me aba epalia lo lagisade aa yapae? Pa aa meda orope epaliade ado pima? ");
INSERT INTO kew_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Gore Yesumi nimu gupa lakesa: Nimimi pua kogono adamede rayo ora yaade lo Jon pua laketapape. ");
INSERT INTO kew_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Abia ini rabuni onaanumi oyae waru adaleme. Aa wae onaanu pora pamualeme. Yakimi ti onaanuna rere kaapu yaa. Aane poae onaanumiri abia aane lobaawa pagame. Aba ome onaanu page wala reka pimi. Go onaa naraanumi page Gote-na epe agaa pagaleme. Go remaa rayore Jon pua laketapape. ");
INSERT INTO kew_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Onaa rayome ni madaa kone laapo nasu puri paloa kone rulalimi-daare go onaanu pedo pua waru piralimi. ");
INSERT INTO kew_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Mo Jon-na disaipel aanu pulaina Yesumi mo Jon-re go piane aa yaade lo onaanu waru lakesa: Abade nimi mo onaa napiri su-para puare ake adolalo pisimi ya? Gore nimimi po ripumi kabe ragualae adola pisimi ya? ");
INSERT INTO kew_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nimi puare ake adola pisimi ya? Epe mamina maarae aanu adola pisimi ya? Dia, aa mudu nimuna epe mamina maraawa epe ada-para piruaeme. ");
INSERT INTO kew_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Gore ake adola pisimi ya? Gote-na agaa lakene aa meda adola puame ya? E, gore neme nimi lagialo: Go aamere Gote-na agaa lakene aa medalomare nipumi rabuniaaya. ");
INSERT INTO kew_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Go aa madaare Gote-na buk madaa agaa gupa ia: Gote-me lalo: Pagalepa. Neme nina agaa lape aa aba epenatoa. Go aamere nimina pu robaa konena pora maredepo yaato tea. ");
INSERT INTO kew_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yesumi lalo: Pagalepa. Jon Baptais-ri go su amaa madini onaa rayo rabuniaawa nipu ora epe ta sa. Pare Gote-na Surube Su-para polalo nogo naaki-rupa pimiri Jon page rabuniaame. ");
INSERT INTO kew_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Abade Jon agaa mogea aa pirisa rabu page abia onaanumi Gote-na Surube Su-na agaa ratu rubulalo pirisimi. Go page wae puri pane aanumi nimu ripinaatalo peme. ");
INSERT INTO kew_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Gote-na agaa lakene aa rayome page Moses-na rekena agaame agaa lakela-mama ipuare Jon-me page Gote-na Surube Su-na agaa laketa-rupa mogea kone rulaeme. ");
INSERT INTO kew_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Gore nimimi nimuna agaa pagamona kone salimi-daare gore Jon-re Gote-na agaa lakene aa Elaija-rupa aba epalia simide. ");
INSERT INTO kew_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Onaa rayome go agaana re niminaaba piralimiri waru pagalepa sa. ");
INSERT INTO kew_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Go rabu go onaanu nimiri ake madaa saa pi agaa lagialua ya? Nimimiri kone gupa meme. Nogo naakinu-rupa maket su-para pimi. Goa puare go nogo naaki rado medanu-para gupa yaateme: ");
INSERT INTO kew_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Niaame nimi-para emaa pe tema pare nimimi mata napabeme. Niaame odome omoa nimi-para rupa yaasa tema pare nimimi re-daa nateme sa. ");
INSERT INTO kew_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jon nipu ipua ipa wain-para eta medaloma-para nanisa pare nimimi nipu maeyae aa simi. ");
INSERT INTO kew_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Gore Onaa Raapu Pirape Aa-na Si ni ipua go etanu epa no ipa no pe-pulu onaanumi lalo: Adalepa. Go aamere eta adaapupe noa ipa wain page adaapu nea teme. Go aare mone takis mi aanu-para naraa onaanu raapu pia teme. Goa peme pare onaanumi ora Gote pia kone sua kone rulalimina-ga Gote-na makuaae kone mada adalimina. ");
INSERT INTO kew_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Goa puare su adaare adaapu-para Yesu nipumi napiaa kogono waru pisa pare go pirisimi onaanumi kone naperekesimi. Gore Yesumi nimu ratu yawoa nimu-para ape sa. ");
INSERT INTO kew_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Gore nipumi lalo: Korasin su-para mo Betsaida su lapo-para piri onaanu madaa neme odo waru pia. Gore neme Tair Saidon su lapo-para napiaa kogono go-rupa pula pisu yaalore go Tair Saidon su-para pimi onaamere kone pereketa pisimi. Goa pula pisimi yaalore nimuna odo waatalore tagame pepeminua mamina yamola pisimi. ");
INSERT INTO kew_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pagalepa. Gore onaanuna yoto rumaape yapi di raburi Gote-me Tair Saidon su lapo piri onaanu kedaa katea. Goa palia pare nimimi wae kedaa ora waru rialimi. ");
INSERT INTO kew_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nimi Kaperneam su-para piri onaanu nimimiri yaa-para polalo peme? Gore nimi wae su-para palimi. Mo napiaa kogono pawade-rupare Sodom su-para pula peme yaalore gore abia go raburi mo Sodom su-para aata pea. ");
INSERT INTO kew_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pagalepa. Gote-me onaanu yoto rumaape di raburi nimina kedaamere mo Sodom su-para piri onaanuna kedaa rabuniaa mealimi. ");
INSERT INTO kew_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Go raburi Yesumi Gote beten gupa sa: O Aapa, nere su yaa lapona Mudu pi. Gore abadere neme kone makuaae onaanu-para kone waru i onaanu-para nena kone kudiri pua nogo naakinu-rupa mea waaside. Go madaa ora pi lalo. ");
INSERT INTO kew_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Gore Aapa nena raana ratua go-rupa ne peme. ");
INSERT INTO kew_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nina Aapamere oyae rayo neme surubanolo gisa. Goa pisa pare pa onaa medame nena Sina ni na-ademe pare ne Aapa padane mamere ade. Aa medame Aapa na-adea pare Simi padane-ma mere adea. Mo Simi onaanu Aapa waata-daare nimumi Aapa ademe. ");
INSERT INTO kew_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nimi onaanumiri kalai pu kogono pua kedaa ria epemere ni piri ipulupape. Goa epalimiri nimi kitu mapiraalua. ");
INSERT INTO kew_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Goa puare nina pasaa madaa ia repenare gore nimimi mua nimina pasaa madaa mea riaalepape. Gore neme epe kone su pawa pi-pulu nimimi nina kone adoa adaapu mogeatepape. Goa palimiri nimimi kitu epa mua piralimina. ");
INSERT INTO kew_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Gore nina oyae riape repenare kedaa napea. Nimina pasaa-para riape yae salua-ga yapa pinalo riaalepape sa. ");
INSERT INTO kew_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kitu Pirape Yapi di medare Yesu nipu wit maapu pamisa. Goa puare nipuna disaipel aanu nimu reame omesimi-pulu mo wit-na ini keroa sana mea nisimi. ");
INSERT INTO kew_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Gore mo Farisi aanumi go adoa Yesu nipu gupa lakesimi: Adaina. Kitu Pirape Yapi di madaare rekena agaame kogono dia ta pare nena aanumi agaa rasua pa peme. ");
INSERT INTO kew_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesumi nimu gupa lakesa: Gore nimimi Devit-para nipuna aanu page reame omoa pisa yaade remaare nadipitimi ya? ");
INSERT INTO kew_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Gore nipu Gote-na ada ru-nane pua odobaawa mo Gote-na sape bret mea nisimi. Go bret-re Gote-na miru irae aanumi agu nisimi pare mo aanumi rekena agaa rasaasimi. ");
INSERT INTO kew_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Pare nimimi abade Moses-na rekena agaa-para go remaa nadipiasimi ya? Gore lotu ada-parare Gote-na miru irae aanumi kogono pua Kitu Pirape yapi orona rekena agaa rasitimi. Goa pisimi pare nimumi pa wae yae meda napisimi. ");
INSERT INTO kew_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Gore neme nimi lagialo. Oyae go-para ia yaemere lotu ada rabuaniaaya. ");
INSERT INTO kew_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Pare nimimi Gote-na agaa meda pagola peme yaalore waea napeme onaanu-para agaa mada nalaketa peme. Nipuna agaa go ia-daa: Ofa sape kone madaare neme raaname naome pare epe raba meape kone madaa pedo pi. ");
INSERT INTO kew_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Onaa Raapu Pirape Aa-na Siri Kitu Pirape Yapi Di-na Aa Mudu yaade. ");
INSERT INTO kew_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesumi go su-nane gimoa nimuna lotu ada meda-para pisa. ");
INSERT INTO kew_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Goa pisa rabu aa meda nipuna ki rudu ae aa meda pirisa. Gore aa medalomame Yesu-para koso lape agaa loa nipu-para agaa gupa simi: Gore niaana rekena agaa madaare yaina ome onaare Sabat piri yapi di rabu maperekeaamina yapae dia yapae simi. ");
INSERT INTO kew_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Gore Yesumi nimu-para lalo: Nimina rikiraana aa padanemere mena sipsip punalia rabu medare Kitu Pirape Yapi di rabu kuba-para lopalia. Gore nimimi sipsip menare mogo yapina amaa-nane nayola salimi ya? ");
INSERT INTO kew_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Gore onaare sipsip mena-rupadaa dia. Kitu Pirape Yapi Di-na page niaame onaa raba mealimare rekena agaa narasitima. ");
INSERT INTO kew_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Gore nipumi mo ki rudu ae aa-para lalo: Nena ki ridula. Goa pisa rabu go aa-na ki epe sa-pulu wala epe ki meda nona pisa. ");
INSERT INTO kew_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Go raburi Farisi aanu nimu reka puare Yesu nipu tu maomaatalo yada robesimi. ");
INSERT INTO kew_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Gore Yesu nipumi go agaa pagoa sana go su gimoa pisa pare onaa adaapu nipu rata mea pisimi. Goa puare nipumi yaina ome onaa rayo maepeaasa. ");
INSERT INTO kew_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Goa puare Yesumi nimu-para agaa puri paloa lakesa: Nina kogono pawade-rupa onaa medanu napua laketapape sa. ");
INSERT INTO kew_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Goa lakesa agaa madaare Gote-na agaa lakene aa Aisaia-me agaa gupa sa: ");
INSERT INTO kew_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Gote-me goa sa: Go aare nina mada mi aa ya-pulu neme nipu madaa raaname waru omoa nipu madaa pedo waru pe. Neme nina Holi Spirit kaato raburi nipumi su rado-para piri onaa nina yoto rumaape yapi di lakena. ");
INSERT INTO kew_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Gore nipumi agaa puri palo naloa ratu nayawalia. Goa pua nipu pora-nia pamualaara pamualia. ");
INSERT INTO kew_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Gore nipumi kogono pa amaa pua nipumi onaa rayo ora epe kone inalo raba mealia. Goa pua nipumi kabe meda ugitabolalo po ripumi rialaayare mada narugula tabalia. Goa page lam meda uduna repe repe paliare nipumi mada namaudinalia. ");
INSERT INTO kew_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Goa palia rabu ruru rado onaa rayome nipu madaa kone rulaawa nipu ado piralimi. ");
INSERT INTO kew_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Go raburi ini rubuni aa meda nipu madaa remo pirisa-pulu nipuna agaa maaresa. Go aare nimumi Yesu nipu piri-para mea ipisimi. Go rabu Yesumi go aa maepeaasa rabu mo aame agaa lapaawa oyae page waru adesa. ");
INSERT INTO kew_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Gore onaa rayo nimu pogolasaawa lalo: Go aare nipu Devit-na si yapae dia yapae simi? ");
INSERT INTO kew_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Gore mo Farisi aanumi onaanuna agaa pagoa goa simi: Wae remona aa mudu Belsebul-mi go aa puri kata rabu nipumi go remo raapu pirua pia simi. ");
INSERT INTO kew_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Gore Yesumi nimuna kone adokaru mua nimu gupa lakesa: Adaare meda-para piri onaanumi nimu rumaa yada palimi-daare gore rekepu paawa piralimi. Go adaare-para aaraalu nimumi rugulala palimiri go ruru lapore mada nakibu ma-aalimi. ");
INSERT INTO kew_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Goa pea-ga Satan-na su-parare ruru padaneme wala yada pua meda ratu rubaliare wala mada nakiritalipi pare nipuna ruru rugulala pa pipi. Go raburi nimuna su ora o yalia. ");
INSERT INTO kew_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Gore nimumi gupa lamede: Belsebul-mi ne raba mea rabu neme wae remo mea rubaaede. Goa pea-ga nimina disaipel aanuri aapimi raba minalo nimumi wae remo mea rubaeme ya? Nimumi goa peme-pulu nimina koso lape agaa rabuaniaaeme. ");
INSERT INTO kew_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pare Gote-na Holi Spirit-mi ni raba mu puri gea-pulu neme go wae remonu mea rubaayo. Goa pea-ga Gote-na Surube Su nimi piri-para aba epaade. ");
INSERT INTO kew_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Gore aa medame puri pane aa medana ada-para pua odobaawa nipuna oyaeyaenu paake mulalo palia-daare gore nipu opeme aba rogaalimi. Nipumi goa puare nipuna ada-para i yaenu rayo mada mealia. ");
INSERT INTO kew_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Aa medame ni raapu napiraliare gore nina iaa pia. Aa medame naa sipsip mena namea kirata mapiraaliare gore nipumi mo sipsip-nu pane mea ratu rubalia. ");
INSERT INTO kew_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Goa pea-ga neme nimi lagialo: Gote-me onaanuna wae yaenu-para wae ero agaanu rayo mea rubalia pare onaa rayome Holi Spirit-para ero agaa teme-daare go wae yaere Gote-me mada namea rubalia. ");
INSERT INTO kew_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Onaa rayome Onaa Raapu Pirape Aa-na Si-para wae agaa temere Gote-me go wae yaenu mea rubalia. Pare onaa rayome Holi Spirit-para wae agaa temere Gote-me go wae yae mada namea rubalia. Gore abia page orope page ora mada namea rubalia. ");
INSERT INTO kew_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Gore repena ini epere epe repena mada aba etalia. Wae repena opalia-daare wae ininu madialia. Goa pea-ga ini aba madita rabu go repenare epe ta palo o ta palo mada makuaaema. ");
INSERT INTO kew_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nimiri wae paakame madini onaanu-ga nimimi epe agaare akepu teme ya? Nimiri waeanu peme-pulu nimina robaa-para rulatabea agaare penaame waatea. ");
INSERT INTO kew_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Aa epe medare nipuna robaa-para epe kone patea-pulu nipumi epe kone sua epe agaa tea. Aa wae-mere nipuna wae kone robaa-para rulatabea-pulu nipumi wae agaa tea. ");
INSERT INTO kew_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Go agaa lagialo: Gote-me orope onaana yoto mea rumaaliade rabu nimuna pianu rado rado ado kiritua Gote-me yoto rumaa katea. ");
INSERT INTO kew_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nina to agaa madaare Gote-me nimi koso lape agaa tea. Go teme agaa madaare Gote-me nimi epe onaa lo wae onaa lo pagoa mea rumaalia. ");
INSERT INTO kew_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Go raburi rekena agaana tisaa aa medalomame Farisi aa medaloma-para gupa simi: Tisaa-ya, niaame nena napiaa meda paina adamona simi. ");
INSERT INTO kew_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Go raburi nipumi nimu gupa lakesa: Go abia pimi onaanumi waea pua Gote gimeme-ga akolo napiaa kogono adolalo peme. Pare nimumi nipuna kogono meda na-adalimi. Pare neme aa Jona-na pisade kogono padanere palua rabu adalimina. ");
INSERT INTO kew_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Abade Jona nipu adaa enana robaa-parare yapi repome pirisa. Goa pisana-rupare Onaa Raapu Pirape Aa-na Siri matmat-para yapi repome pirua wala rekalua sa. ");
INSERT INTO kew_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Pare Gote-me onaana yoto mea rumaape yapi di epalia rabu Ninive pirisimide onaanu rekoa nimu kosona ini-agaana palimi sa. Gore Jona-na agaa lakesa rabu nimumi pagoa wae yaenu gimoa nimuna kone robaa perekesimi. Goa pisimi pare abia go pima yapi dimi Jona-na kogono maoge yaeme sa. ");
INSERT INTO kew_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Gore Gote-me onaanuna yoto mea rumaape yapi di rabu no re-nane piri Ona Mudu meda rekoa nimina wae yae rayo madaa koso tea. Go onana bi Mudu Shiba teme. Gore go ona nipu Solomon-na epe agaa pagola pisa-pulu nipu su rayona aane-nane pamisa. Goa pea pare aa go nimina rikiraana piamere Solomon-na kogono page rabuaaya. ");
INSERT INTO kew_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","44","Gore wae remome aa meda aba gima paliare gore nipu su kaapu meda asapula pea. Go remo nipu pamea pare epe su ora asapua na-adalia-daare nipumi wala gupa tea: Nina aba pirua epawade ada-para wala palua tea. Wala pua puaa adea pare adede ada-parare puluma kia pepena pua waria sabaaya. ");
INSERT INTO kew_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Goa pisa raburi nipumi ora wae remo 7-pela wala pua lamu mua sana nipu raapu ipuare mo ada ru-nane odobaawa pirisimi. Apo 7-pela nimumi remona wae kone maoge yaawa aba ripiare go aa wae-rupa pirisa pare abiare ora wae-rupa pia. ");
INSERT INTO kew_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu nipu mo onaanu raapu agaa pa lala pirina agi amenu amaa-nane epa aasimi. Nimumi nipu raapu agaa talo pisimi. ");
INSERT INTO kew_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Gore aa medame nipu goa lakesa: Nena ama-para nena amenu so amaa epa aeme. Gore ne raapu agaa talo pimi. ");
INSERT INTO kew_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pare nipumi mo onaa-para lalo: Nina ama amenuri aapi ya? ");
INSERT INTO kew_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Goa loare nipuna ki maalame nipuna disaipel onaanu-para wakia lalo: Adalepa. Nina ama-para amenuri nimi yaade. ");
INSERT INTO kew_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Onaa rayome nina so yaa-para piri Aapana agaa waru pago rateme-daare gore go onaa nina ame-para baani-para ama-rupa piralimi sa. ");
INSERT INTO kew_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Go raburi Yesumi mo ada gima pua ipa ini repaa-nane pua pirisa. Go rabu nipumi onaanu agaa moge riasa. ");
INSERT INTO kew_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Go raburi ora onaa adaapu nipu piri-para ipua pirisimi-pulu nipu ipunu meda madaa pirisa. Goa pisa raburi onaa rayo ipa ini repaa-nane pa pirisimi. ");
INSERT INTO kew_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Go rabu nipumi oyae adaapu mogeawa saa agaame agaa gupa lakesa: Aa medame nipuna maapu-para kibita wai radata pisa. ");
INSERT INTO kew_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Gore mo maapu-para radata pisa raburi kibita ini medaloma mo pora-nia pa lopesa rabu yaanumi mea nisimi. ");
INSERT INTO kew_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Gore polalo mea pisa rabu medaloma aana rote madaa lopesa. Gore go-para kobere su ogepusi madaa isa-pulu go ini ora aipapulu opesa. ");
INSERT INTO kew_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pare naare epa roa radaa pea raburi su kelelo loa pitaa napua kaapu ta. ");
INSERT INTO kew_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mo wit-na ini medaloma itutuae-para lopesa rabu repena opoa adaa yo pua maregepeasa. ");
INSERT INTO kew_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pare kibita ini medaloma epe ipa piri su-para lopoa sana ini waru epe-rupa etesa. Goa pua opesa rabu medalomame ini 100-pela madiala medaloma 60-pela madisa. Goa pea pare medaloma pa padane padane laata pu 30-pela madiala pisa. ");
INSERT INTO kew_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Onaa rayome go agaana re niminaaba pirua waru pagalepape sa. ");
INSERT INTO kew_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Go rabu nipuna disaipel aanu Yesu nipu piri-para ipua gupa epa agaa misimi: Akeane oro yaalo neme niaa saa pi agaame agu lage pae? ");
INSERT INTO kew_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesumi lalo: Gote-na Surube Su madaa kudiri pu i agaa ia pare nimimi aba pageme. Goa pea pare nimimi wala napageme. ");
INSERT INTO kew_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Gore ona rayome oyae adaapu aba saapitimi-daare Gote-me wala adaapu medaloma page sania katea. Goa pua nipumi oyae adaapu salia. Pare onaa rayome kone ogepusi saapiru oyae meda nasaapiralimi. Go ogepusi page ora mea palua sa. ");
INSERT INTO kew_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Neme nimi-para saa agaa agu tona re-re gupa: Nimuna inimi oyae pa ademe pare nimimi oyaena re waru na-ademe. Nimina aaneme pageme pare nimimi kone-para waru naimi. ");
INSERT INTO kew_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Go onaanu madaare Gote-na agaa lakene aa meda Aisaia-me agaa ora go-rupa saaya: Nimumi agaa pago piralimi pare re-re waru naniminaalimi. Nimina inimi pa adapaba piralimi pare oyae waru na-adalimi. ");
INSERT INTO kew_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Go onaanuna kone waru nasua pimi. Nimimi nimuna aane pora poabaaya. Nimuna ini rigiteme. Goa napula pisimi yaalore inimi oyae mada adola pisimi. Nimuna robaa-para paa mada epe ta pisa. Agaa pago mada niminaalimina. Gote-me lalo: Nimina kone perekea ni piri-para epenatepape. Go rabu neme nimi maepeaalua. ");
INSERT INTO kew_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Pare nimimi ora epe-rupa pimi-daare pedo pipape. Nimina inimi oyae ado aaneme agaa pago pimi-ga ora epe ta. ");
INSERT INTO kew_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Go agaa pagalepa. Abade Gote-na agaa lakene aanu-para Gote-na onaa medaloma page abia nimimi go adaleme yae adolalo raaname omesimi. Pare nimumi abade na-adesimi. Abia nimi lagialo agaa pagola pisimi yaalore raaname omala pisimi pare go agaa napagesimi. ");
INSERT INTO kew_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Gore aa medame nipuna maapu-para wit-na ini poasa remaana re-re gupa pagalepa. ");
INSERT INTO kew_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Onaa medalomame Gote-na Surube Su madaa agaa pagoa yapare naniminaaeme. Go onaanuri apo pora-nia lope wit ini-rupa pimi pare robaa-para i agaare Satan ipua epa mabebola tea. ");
INSERT INTO kew_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Gore mo kibita ini aana madaa lopesanare onaa medalomame Gote-na agaa aipapulu pagoa raaname omoa rata mea peme-rupa yapare go agaare nimuna robaa ru-nane pitaa waru napea. Goa pea-pulu nipuna pitaa ogepusi pea. Goa pea-ga epe agaa madaa kedaa marialimi-daare nimimi Gote-na agaa aipapulu gimoa lopalimi. ");
INSERT INTO kew_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mogo repena ini etoto-aepara lopesana-rupare nimimi agaa pageme pare mone kogono-para wae kone adaapu i su-para pimi-pulu go wae kone rayome Gote-na agaa marabuniaaya. Goa pea-pulu ini waru namadita. ");
INSERT INTO kew_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mogo ini epe su-para lopesare gore onaa medalomame Gote-na agaa pagoa robaa-para mea sua kone rulaeme. Goa pua nimuna ini page waru adaapu 100-pela wakia ini-rupa madita. Gore medalomana ini 60-pela madita. Gore medaloma padane padane laata pina 30-pela madita. ");
INSERT INTO kew_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesumi nimu-para saa agaa meda wala gupa sa: Gote-na Surube Su nona pianere aa medame epe repena ini nipuna maapu-para poaaya. ");
INSERT INTO kew_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ribaa onaa u patala peme raburi iaa medame ipua wae ripu mo maapu-para epe ini raapu radata. ");
INSERT INTO kew_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Orope go ini etolalo pea rabu mo wae ripu raapu aaya. ");
INSERT INTO kew_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Goa puare kogono naakimi mo maapuna aaraa piri-para ipua lalo: Aa adaa, niaame abade nena maapu-para epe ini poasima kone sama pare akeane wae ripu opa ya? ");
INSERT INTO kew_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Gore aa adaame nimu goa lakesa: iaa medame pea. Gore mo kogono naakinumi lalo: Aa adaa, nena konemere niaame wae ripu mea rasu rubola pomona kone sae? ");
INSERT INTO kew_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Gore nipumi lalo: Dia, nimimi mo wae ripu rasu rubala aawa mo epe kibita ini rasalimi-ga pa laainawa. ");
INSERT INTO kew_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Gore pa ainaloa mo epe ini ratemade rabu go kogono naakinu-para gupa laketoa: Go ripu waenuri aba raloa rogaawa iralimina toa ripu epenuri padane ada-para rogaa kirita salepape-lo laketoa. ");
INSERT INTO kew_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Yesumi nimu saa agaa meda gupa lakesa: Gote-na Surube Suri gupiane: Repena yamo ini mua aa meda nipuna maapu-para poaaya. Gore opea raburi wala adaa yoa pa repena medaloma rabuaaya. Gore nipu repena nona piane aaliade raburi yaa medaloma ipua go repena palaa madaa ada waria pitimi. ");
INSERT INTO kew_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Gore Yesumi saa agaa meda gupa lakesa: Gote-na Surube Suri bret adaa nalo yaape yis-rupa yaade sa. Ona medame go bret ma-adaa yaape yis-para plaua ipa repo raapu sua moropesa. Wariaa-mama puare oropere go yae rayo ora adaa yalia. Gote-na Surube Suri go-rupa adaa yalia. ");
INSERT INTO kew_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesumi go onaa adaapu saa agaame agu lakesa. Yesumi nipumi agaa medana kudiri pi waru lakesa. ");
INSERT INTO kew_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Gore abade Gote-na agaa lakene aa-na agaana re adaliminalo gupa lagisade: Gote-na agaa lakene aame gupa sa: Neme agaa puri paloa toa-daare saa agaa mada agu toa. Abade su yaa wariasade rabu piaanu rayo laama ipua abia pia page toa. ");
INSERT INTO kew_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Gore Yesu nipu mo onaanu nimuna pirina nipuna ada-para pisa. Go raburi mo nipuna disaipel aanu ipua go wae ripu maapu-para opeana saa agaa ake-para teme-lo epa agaa misimi. ");
INSERT INTO kew_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesumi lalo: Aa medame maapu-para epe etana ini radata gore Onaa Raapu Pirape Aa-na Sina agaa radata. ");
INSERT INTO kew_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Maapuri onaana lo robaa lawade. Epe iniri gore Gote-na onaanu-para lawade. Go ripu waenuri gore Satan-na onaanu-para lawade. ");
INSERT INTO kew_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mo iaame wae ripu mea poana lawadere gore Satan-para lawade. Eta ralape di raburi gore go su amaa onaa mea rumaatalo epaliade yapi di-para lawade. Maapu-para kogono naakinuri ensel-nupara lawade. ");
INSERT INTO kew_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nimumi ripu wae rayo mea rogaa sua repena sulaa-para iralimi-rupare orope go su amaa onaa mea rumaata epaliade rabu palia-para lawade. ");
INSERT INTO kew_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Go rabu Onaa Raapu Pirape Aa-na Simi nipuna ensel-nu mea rapalia. Goa pua go ensel-numi pupitagi ne onaa page wae onaanu page kirita salimi. ");
INSERT INTO kew_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Goa puare go onaanuri repena sulaa-para mea rubalimi. Go adaa repena sulaa-parare re ora adaape loa radaa waru noa agaa abulu regepe no piralimi. ");
INSERT INTO kew_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Goa puare Gote-na onaanuri Aapana Surube Su-para naare rea-rupa pedo pu piralimi. Aa medame go agaana re niminaaba piralimiri waru pagalepape. ");
INSERT INTO kew_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Gote-na Surube Suri go-rupa: Abade aa medame epe yaenu su-para pua paga isa. Goa pea pare aa medame go yae adesa. Go rabu nipumi su-para wala rado mea pagaa isa. Goa adesa rado-pulu nipumi raaname waru omoa sana nipu pua onaa medalomame nipuna oyae kabeme. Goa pua nipu go mone-me go su kabola pea. ");
INSERT INTO kew_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Gote-na Surube Su-ri go-rupa: Aa medame sekere madini asapua rome pea. ");
INSERT INTO kew_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nipumi ora sekere yaba adea-pulu nipuna oyae rayo kabenaloa nipumi mode mone-me mo sekere ropea. ");
INSERT INTO kew_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Gote-na Surube Su page medare gupa pea sa: Ena agona no ipa-para pua suare ena rado rado piane adaapu meme. ");
INSERT INTO kew_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Mo agona-parare ena epa piru kiritinaloare ena meape aanumi agona mea yola peme. Goa pua nimumi epe ena yapatua pane mea sua wae yapatuare ipa-para wala mea rubea. ");
INSERT INTO kew_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Go konere orope yapi di epaliade-rupa: Go rabu ensel-nu su amaa ipua onaa mea rumaalimi-ga onaana rikiraana wae onaa piralimi-daare go onaa epa mea kiritalimi. ");
INSERT INTO kew_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Go raburi nimi epa muare mo wae repena sulaa-para epa mea rubalimi. Go repena sulaa-parare re ora adaape loa radaa waru noa agaa abulu regepe no piralimi. ");
INSERT INTO kew_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Gore Yesumi nimu agaa misa: Go agaana re-re nimi rayo pago kiriteme ya? Gore nimumi lalo: E, rayo pago kiritema simi. ");
INSERT INTO kew_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Gore nipumi nimu lakesa: Rekena agaana tisaa aa rayome Gote-na Surube Su-na agaare aba makuaasimi pare ada ru-para nipuna i abana wae yaenu-para epe kagaa yaenu pua mua amaa-nane mea epalia-rupa mada sa. ");
INSERT INTO kew_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu nipumi go saa agaa aba lo kirituare nipumi go su gimoa pisa. ");
INSERT INTO kew_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Gore nipuna adaare-para ipuare nipuna ruru onaa lotu ada-para Gote-na agaa moge riaasa. Mo onaanumi nipuna agaa pagoa pogolasaasimi. Goa pua nimumi lalo: Go epe makuaae kone rayo page go epe napiaa page gonuri aa-para mea ya? ");
INSERT INTO kew_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Go aa-na aaraare kamda kogono pi aa kone ima. Go page nipuna agiri Maria kone ima. Jems-para Josep-para Saimon-para Judas-para gonu nipuna amenu kone ima simi. ");
INSERT INTO kew_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Gore nipuna baaninu page rayo niaa raapu padane-para go pima. Goa pea-ga go kone rayore aa-para mea ya? ");
INSERT INTO kew_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Goa loa nipu-para ratu yawesimi aanu adoa Yesumi nimu-para lalo: Gote-na agaa lakene aanuri su rayona epe bi minasaaeme pare ora nipuna adaare padane-para epe bi naminasaaeme sa. ");
INSERT INTO kew_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nimumi kone narulasimi-pulu nipumi adenalo napiaa adaapu meda napisa. ");
INSERT INTO kew_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Go raburi gavman-na aa mudu Herot Antipas-me Yesu madaa remaa pagesa. Go rabu nipumi Galili su rayo surubisa. ");
INSERT INTO kew_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Gore nipuna kogono aanu gupa lakesa: Go Jon Baptais-ri matmat-para wala rekaana kone salo sa. Goa pea-pulu nipumi go puri mua napiaa kogono go-rupa mada pia sa. ");
INSERT INTO kew_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Gore go-rupa abade Herot-me Jon nipu koso agaa laawa sana adia kalabus ada-para mapatasa. Gore Herot-me nipuna ame Filip-na ore Herodias yotalo pisa. ");
INSERT INTO kew_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Goa pisa pare Jon Baptais-mi Herot goa lakesa: Rekena agaa gupa ia sa. Nena amena ore nayolo rumaape tade kone isa. ");
INSERT INTO kew_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herot-me Jon tu maomaatalo pisa pare nipumi Juda onaa rayo paalame omesa. Go onaanuna konemere Jon Gote-na agaa lakene aa meda kone isimi. ");
INSERT INTO kew_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Gore agimi Herot nipu madini di wala ipisa rabu onaa adaapu nipu raapu patipu kirita pirisimi. Go raburi Herodias-na waneme nimuna rikiraana aawa mat pabesa. Goa pisa rabu Herot-me raaname ora waru omesa. ");
INSERT INTO kew_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Goa pisa-daa nipumi wane-para yaa madaa makuaa loa agaa gupa lakesa: Neme ni-para oyae medaloma gi tere mada gialua sa. ");
INSERT INTO kew_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mo onana agimi kone kasa rabu nipumi lalo: Neme Jon Baptais-na aalu plet madaa sua ni giape sa. ");
INSERT INTO kew_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Goa sa raburi mo aa muduna kone-para kedaa pisa. Goa pisa pare abade nipumi mo nipu raapu eta no piri onaanu-para yaa madaa makuaa agaa lakesa. Go kone isa-pulu nipumi lalo: Go yae mea katoa kone isa. ");
INSERT INTO kew_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nipumi oda aanu medaloma mo kalabus ada-para penaaloa Jon-na aalu ruguta penaasa. ");
INSERT INTO kew_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Goa puare mo Jon nipuna aaluri plet meda madaa sua mo ona inumakua epa kasimi. Gore nipuna agi piri mea pisa. ");
INSERT INTO kew_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Goa puare mo Jon nipuna disaipel aanu ipua nipuna ro ria pua aana apedaa-para pua rogaasimi. Nimumi aba rogaabaawa siminare Yesu pua lakesimi. ");
INSERT INTO kew_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu nipu go agaa pagoare ipunu meda madaa pirua onaa napiri su-para pirapalae pisa. Nipu padane-ma agu raapo pisa pare onaa rayome go remaa pagesimi. Goa pua adaare gimoa pisa rabu onaanumi nipu rata mea pisimi. ");
INSERT INTO kew_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Orope Yesu nipuna ipunu mo ipa repaa-nane pua suare onaa adaapupe adoare odome omoa nimuna yainanu page maepeaasa. ");
INSERT INTO kew_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Gore ribaa sa raburi nipuna disaipel aanu ipua lalo: Go su-parare onaa napiri su-para epa amaade-ga neme onaa rayo mea rapaawa eta mo adaarenu-para kabola penaala simi. ");
INSERT INTO kew_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesumi lalo: Akeane nimu penaalamina ya? Nimina eta katapa sa. ");
INSERT INTO kew_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Gore nimumi lalo: Niaare eta adaapu nasaema. Pa bret ipa supu-para ena ipa lapo ima simi. ");
INSERT INTO kew_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesumi gore mea ipulupa sa. ");
INSERT INTO kew_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mo onaare ripu madaa piralepa loare mo ena lapo-para mo bret supu-para misa. Goa pua nipumi yaa-para adasaawa sana Gote-para ora pi loa bret mea piribia nipuna aanu kasa. Goa pua go aanumiri mo onaa rayo rumaa kasimi. ");
INSERT INTO kew_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Gore nimu rayome eta mada no kirituare eta ebomere basket-nu 12-pela madu isimi. ");
INSERT INTO kew_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mo eta nisimi onaare ora adaapupe pirisimi. Aa 5,000 pirisimi pare nimumi ona nogo naakinuri nadipisimi. ");
INSERT INTO kew_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yesumi nipuna disaipel aanu lakesa-daa nimu ipa ini mone pane aba pisimi. Go rabu nipu mo onaa mea rapatalo pisa. ");
INSERT INTO kew_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nipumi mo onaa rayo aba penaaloa nipu padane beten talo so rudu madaa pisa. Ribaa nipu padane-ma so rudu madaa pirisa. ");
INSERT INTO kew_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Gore mo ipunu aba mo ipa rikiraana penaaloa po ripumi nimu polalo pisimi-nane ipisa-pulu nimu ipa masaana pa pirisimi. ");
INSERT INTO kew_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Yapi pode lapaasa pare ribaa ogesi-daa pa yabaina Yesu nipu ipa masaa madaa ipua nipuna aanu piri-para epa opapasa. ");
INSERT INTO kew_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Gore disaipel aanumi nipu mo ipa masaana ipisa adoa pogolasaawa lalo: Gore masalai meda epea kone sua pogolasaawa paalame omoa puri palo yaasimi. ");
INSERT INTO kew_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Go raburi aipapulu Yesumi nimu goa lakesa: Puri mealepape. Ni epawade-ga nimimi paalame naomalepape. ");
INSERT INTO kew_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Go rabu Pita-me lalo: Aa Mudu, ora ne yalia-daare ni page apo ipa madaa, ipu lo lagi. ");
INSERT INTO kew_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesumi lalo: Ne ipu sa. Pita mo ipunu gimoare ipa masaa-nini pua Yesu nipu aasa-para adolalo pisa. ");
INSERT INTO kew_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pare nipumi po ripu adoa paalame omoa ipa ini ru-nane odobatalo pisa. Goa pisa-daa nipumi lalo: Aa Mudu, neme ni raba meape. ");
INSERT INTO kew_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Go raburi aipapulu Yesu nipu kimi ripinaasa. Goa pua nipu lakesa: Akeane neme ni kone ogepusi rulaari ya? Neme kone lapore akolo sae ya? ");
INSERT INTO kew_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Goa puare nipu lapo so ipunu madaa opasaawa pirisipi raburi po ripu dia sa. ");
INSERT INTO kew_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Gore ipunu madaa pirisimide aanumi Yesu-para beten loa nimumi lalo: Nere ora Gote-na si yana simi. ");
INSERT INTO kew_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yesu-para nipuna moge riaae aanu-para nimu ipa Genesaret rugulaama pua mone pane pua opopasimi. ");
INSERT INTO kew_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Go su-para piri onaamere Yesuna ini agaa adesimi-pulu go su rayo-para pirisimi onaa lakeloa yaina ome onaa rayo Yesu piri-para lamua ipisimi. ");
INSERT INTO kew_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Yesu nipu agaa mua nena mamina rugi-nane yaina ome onaanumi oraa mo inaloa ogesimi. Onaa rayome nipuna mamina madaa kimi oraawa simina nimuna yaina rayo epeaanasimi. ");
INSERT INTO kew_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Go raburi Farisi aanu-para rekena agaana tisaanu-para Jerusalem su gimoa Yesu nipu piri-para ipua simina nimumi lalo: ");
INSERT INTO kew_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Akolo nena disaipel aanumi niaana akuanuna abana rekena agaa rasitimi? Nimu eta nolalore rekena agaa rasua nimuna ki oto pua naradepeteme simi. ");
INSERT INTO kew_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Gore Yesumi nimu-para lalo: Nimimi akeane abana kone pa saapiruaeme? Goa pua nimimi Gote-na rekena agaa rasamena. ");
INSERT INTO kew_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Gore Gote-me gupa ta: Neme nena ama aapa lapona agaa narasape ta. Aa medame nipuna ama aapa-para wae agaa teme onaare tu omalia ta. ");
INSERT INTO kew_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Goa ta pare nimimi gupa teme: Aa meda nipuna Aapa ama raba meape oyae medaloma sua yapare wala Gote katoa tea. ");
INSERT INTO kew_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Goa pua go rabu nipuna ama aapa raba meapere palaina tea. Go kone sua nimimi Gote-na agaa rasua nimina abana kone waru suaeme. ");
INSERT INTO kew_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nimiri ora yaa agaa ne onaanu pimi. Gote-na agaa lakene aa Aisaia-me nimi madaa agaa waru sade. Nipumi lalo: ");
INSERT INTO kew_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Gote-me goa ta sa: Go onaanuri nimuna agaame nina bi minasaaeme sa. Pare nimuna lo robaa-para i koneme ni gimoa re-para napimi. ");
INSERT INTO kew_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Go onaanumi pa nimuna rekena agaa mogeaawa ora Gote-na agaa lagema teme. Goa teme pare nimumi nina bi pa amaa minasaaeme ta. ");
INSERT INTO kew_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Go rabu Yesumi onaa nipu piri-para ipulupa loa nimu gupa lakesa: Nimimi pagoa kone waru salepape. ");
INSERT INTO kew_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Aa medame eta agaa-para mea neme rabu go yaeme nimu amulu namapaaya. Dia, pare onaana robaa-para i kone amaa-nane popalia-daare gome onaanu maoyaalia. ");
INSERT INTO kew_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Go raburi nipuna disaipel aanumi nipu-para lalo: Farisi aanumi nena remaa pagoa nimuna pu robaa o talamede? ");
INSERT INTO kew_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Gore Yesumi lalo: Nina Aapa yaa-para pia nipuna maapu-para napoae yaae meda opalia-daare pitaa apalae rasalia. ");
INSERT INTO kew_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mogo Farisi aanu madaa nimina kone narubalepape. Gore nimu ini rubu pi aa-rupa pimi pare ini rubu pi yago pora mada nawatea. Dia, nipu lapo rata naaku-para lopalipi. ");
INSERT INTO kew_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita-me Yesu nipu gupa lakesa: Neme go agaana re waru lapa sa. Niaame waru makuaamona. ");
INSERT INTO kew_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Gore Yesumi lalo: Nimi page kone naimi-ga apo aanuna yago pimi pae? ");
INSERT INTO kew_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ora pagalepape. Gore oyae rayo agaa-para neme yaenuri robaa ru-nane pea raburi oge ada-para rubemede. ");
INSERT INTO kew_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pare oyae meda robaa ru-nane pirua agaa-para epea yaere gore kone raapu epea-pulu onaanu amulu mapaalia. ");
INSERT INTO kew_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Gore onaana robaa-parare wae kone gupa imi. Onaa tu maomape kone-para ona rasini meape kone-para ona paake yolape kone-para paake nape kone-para yaa agaa lape-para onaa medalomana bi rabuaniaape kone-para go kone rayo robaa-para sua peme. ");
INSERT INTO kew_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Go yae rayomere onaa amulu mapaaya. Goa pea pare nimuna kone ratua ki radepea eta nalimiri go konemere onaanu amulu namapaalia. Ora dia. ");
INSERT INTO kew_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu nipu go su gimoa nipu mo Tair Saidon su-para pisa. ");
INSERT INTO kew_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Goa pisa rabu Kenan su-para piri ona medare go su-para pirisa-pulu nipu ipua goa sa: Aa Adaa, nere Devit-na si yaade. Neme ni odome omape. Wae remome nina wane ora wae-rupa tea sa. ");
INSERT INTO kew_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Gore Yesu nipumi agaa meda nalakesa raburi nipuna kogono aanumi goa simi: Go onamere e laama laama puaawa ne rata mea ipula-ga neme wala penaala simi. ");
INSERT INTO kew_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Gore Yesumi nimu agaa gupa lakesa: Gote-me ni mea rapaasadere neme go Israel su-para etapae sipsip menanu raba meanolo mea rapaasa-daa ipisude sa. ");
INSERT INTO kew_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Go rabu mo ona nipu ipua Yesuna kibu re-para lopoa sana nipumi lalo: Aa adaa, neme ni raba meape. ");
INSERT INTO kew_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Gore Yesumi nipu agaa gupa lakesa: Niaame nogo naakinuna eta mua pa yananu agaa-para mea lopalimare epe ta. ");
INSERT INTO kew_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Gore mo oname lalo: Aa Adaa, neme ora lae pare mo yananumiri nimuna Aapanuna eta ebo mea nemede. ");
INSERT INTO kew_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nipumi goa sa rabu Yesumi nipu-para agaa gupa lakesa: Go ona nena kone rulae ora adaape saena-ga ne madaa pina kone saena palia sa Go agaa lakesa rabu mo nogo aipapulu rekaasa. ");
INSERT INTO kew_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu nipu go su gimoa ipa ini Galili repaa-para pisa. Goa pua nipu so rudu madaa-nane pua pirisa. ");
INSERT INTO kew_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Onaa adaapupe nipu piri-para epa kiritaawa ke wae ini wae aane poae agaa maare yaina rado rado ome rayo lamua ipua kiritasimi. Goa pisimi rabu nimuna yaina rayo maperekeaasa. ");
INSERT INTO kew_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Go raburi onaanumi mo agaa maare onaanumi agaa lamina ke wae onaame pora pamua to igipi igipini onaa epe-rupa pirina adesimi. Goa pisa rabu go Israel su-para piri onaame Gote-na bi minasaasimi. ");
INSERT INTO kew_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesumi nipuna disaipel aanu-para ipulupa loa gupa lakesa: Neme go onaanu odome omalo. Yapi repo ni raapu pirama-pulu nimu reaeme omoa pimi. Gore neme nimuna ada penaatoa. Nimu pua pora-nia pa lopalimi. ");
INSERT INTO kew_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Gore nipuna aanumi nipu goa lakesimi: Go su-parare onaa adaapupe pimide-ga bret akea pua mua go aanu adaapu mada rumaalima yapae simi. ");
INSERT INTO kew_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Gore Yesumi nimu agaa gupa misa: Nimina bret-re akepu raapo saapimi? Gore nimumi lalo: 7-pela saapima. Enare padane padane oge enasi saapima simi. ");
INSERT INTO kew_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Gore Yesumi mo onaa rayo-para su amaa piralepa sa. ");
INSERT INTO kew_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Goa pua nipumi mo 7-pela bret-para mo ena oge oge-para mua sana Gote-para ora pi loa piribisa. Goa pua nipuna disaipel aanu kanaloa mo aanumi onaa rayo rumaa kasimi. ");
INSERT INTO kew_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Goa pua mogo aa rayome mo eta no kiritua simina disaipel aanumi eta ebo basket 7-pela madu isimi. ");
INSERT INTO kew_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Gore aanuri ora adaapupe 4,000 pirisimi pare onaa nogo naakinuri nadipisimi. ");
INSERT INTO kew_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesumi mo onaa rayo nimuna ada penaaloa nipuri ipunu madaa pirua Magadan su robo-para pisa. ");
INSERT INTO kew_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisi aanu-para Sadyusi aanu-para ipua Yesu epa ko tisimi. Gore nimumi lalo: Puri pane napia kogono meda paina niaame adamona simi. Goa pali rabu Gote-na puri mua nipuna kogono paari ria lamona. ");
INSERT INTO kew_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Gore nipumi lalo: Naare pabalaina nimimi so yaa madaa moae kane ademe raburi nimimi abiare pani palia teme. ");
INSERT INTO kew_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Gore ribaa reko rabu page yaa-para koborea raburi po ripu ipua yai ipu palia temede. Gore nimimi so yaa-para adoare gupa temede-ga abia go di raburi nimimi oyae adoa yapare mada na-adalimi? ");
INSERT INTO kew_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Abia go yapi di madaa piri onaanu nimiri wae pupitagi nape onaa pirua Gote madaa kone narulaeme. Neme napiaa kogono panolo teme pare neme mada namea waatoa. Nimiri Jona-na pisade kogono padanere adalimina. Goa loa nimu gimoa pisa. ");
INSERT INTO kew_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Gore Yesuna disaipel aanu nimu ipa kenaawa mone pane pisimi pare bret medaloma namea ipisimi. ");
INSERT INTO kew_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Gore Yesumi nimu-para lalo: Nimimi waru adalepape. Mo Farisi aanu-para Sayusi aanuna bret ma-adaape yis madaare waru adalepape. ");
INSERT INTO kew_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Gore nimuna bipa goa simi: Niaame bret namea epa amaade madaa ta pae kone isimi. ");
INSERT INTO kew_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Gore Yesumi nimu-para lalo: Nimi kone waru narulaeme-ga akeane niaare bret naima lame? ");
INSERT INTO kew_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Gore nimimi abi na-ademe? Gore nimimi go bret aa 5,000 onaame nisimi remaa aba kone rugulaarimi? Goa pisu rabu nimimi eta ebome nu akepu raapo madu isimi ya? ");
INSERT INTO kew_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Gore neme bret 7-pela mo aanu 4,000 mea kasudere go madaa naniminaaeme? Goa pua nimimi mo ebonuri nu akepu raapo madu isimi ya? ");
INSERT INTO kew_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Neme nimi-para pa bret madaa nalawade-ga akeane nimimi naniminaarimi? Gore nimimi mo Farisi aanu-para Satyusi aanu-para nimuna bret ma-adaa yaape yis-ri waru adalepape lawade sa. ");
INSERT INTO kew_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Goa wala sa-pulu go rabu nipuna disaipel aanumi bret ma-adaa yaape yis-na agaa-daa nalaade kone isimi. Dia, pare nipumi Farisi aanu-para Satyusi aanuna agaa ta kone isimi. ");
INSERT INTO kew_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu nipu mo Sisaria Filipai adaare-para pisa raburi nipumi nipuna disaipel aanu gupa lakesa: Onaanu nimi Raapu Pirape Aare aapi teme pae? ");
INSERT INTO kew_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nimumi lalo: Gore onaa medalomame nere Jon Baptais teme. Medalomamere nere Elaija teme. Medalomamere ne Jeremaia yapalo Gote-na agaa lakene aa yapalo gupa teme. ");
INSERT INTO kew_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Gore Yesu nipumi lalo: Nimimiri ni aapi teme ya? ");
INSERT INTO kew_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Gore Saimon Pita-me gupa sa: Nere Onaa Raapu Pirape Aa-na Si ya-pulu ne Gote-na Si yaade sa. ");
INSERT INTO kew_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Gore Yesu nipumi lalo: Jon-na si Saimon nere raaname waru omape. Go su amaa piri onaa medame neme go lae agaa nateme pare nina so yaa-para pia Aapame ne go agaa lagiaana. ");
INSERT INTO kew_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Gore neme ne lagialo: Ne Pita-re ne puri pane aana nona piane-ga ne madaa nina ruru pirinalo onaa warialua. Goa palua-pulu Satan-na omape purimi go ruru onaa mada narabuaniaalia. ");
INSERT INTO kew_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Gore so yaa-para ia surube suna pora gaape lobape ki neme ne gialua. Oyae meda neme go su amaa pa saapiraliri gore Gote-me so yaa-para page pa saabalia. Go page neme go su amaa yae esepealiri so yaa-para page Gote-me maesepeaalia. ");
INSERT INTO kew_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yesu nipumi agaa puri paloa disaipel aanu-para gupa lakesa: Nina bi Krais yaade-ga onaa meda nalaketapape sa. ");
INSERT INTO kew_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Go raburi Yesumi nipuna disaipel aanu-para orope epaliade yapi di rabu ni mada goa palimilo lapaasa. Nipumi nimu-para gupa sa: Ni Jerusalem su-para palua rabu makuaae aanu-para aa mudunu-para Gote-na Miru Irae Aa mudunu-para rekena agaa tisaanu-para nimumi ni radaa adaa manaawa tu maomaawa rogaalimi. Goa palimi pare yapi repome matmat-para pirua wala rekalua sa. ");
INSERT INTO kew_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Gore Pita-me nipu mo nebo-nane lamua pua sana nipu gupa lakesa: Aa Mudu, nere ora goa napina. Go wae yaenu ne madaa naepena ");
INSERT INTO kew_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Gore Yesumi wala pereke tua adoa lalo: Nere Satan yaana. Nere nina masaa-nane gimoa pupu. Nemere Gote-na kone na-adoa nina kone mea pereketalo lae? Dia, pare su amaa piri aa-na kone meaena. ");
INSERT INTO kew_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Go raburi Yesumi nipuna kogono aanu gupa lakesa: Gore onaa rayome nina kone mua ni ratalimi-daare nimuna kone rabuaniaawa nena repena polopea mea rua ni rata mea epape. ");
INSERT INTO kew_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Gore pa aa meda nipuna yogane pa irulu saapitia-daare gore nipuna wasupa page etapalia. Pare onaa rayome ni madaa kone rulaawa epe-rupa mapiraape kone mealimi. ");
INSERT INTO kew_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Gore pa aa padaneme su amaa oyae rayo saapiralia-daare nipuna kone wasupa etapalea. Go rabu go oyae rayome nipu akepu aba mealia ya? Onaana kone wasupa etapali-daare ora wala na-adasaalia. ");
INSERT INTO kew_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Abiare Onaa Raapu Pirape Aa-na Siri nipuna Aapana epe paana purimi nipuna ensel-nu raapu epalia. Go raburi onaa rayo nimuna kogono peme-rupa mada yoto katea. ");
INSERT INTO kew_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Pagalepape. Onaa medaloma go pimiri abi naomalimi pare nimumi Onaa Raapu Pirape Aa-na Sina puri mea epalia rabu adalimi. ");
INSERT INTO kew_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yapi di oraapu aba penaloa Yesumi Pita-para nipuna ame Jems Jon laapo page nimu mua sana so rudu medana ora so madaa lamua opapasa. Goa pua nimu agu raapo pua pirisimi. ");
INSERT INTO kew_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Gore go aa repona ini agaana nipu adobaina Yesuna to perekea rado nona piane aawa pirisa. Nipuna ini agaa-parare naare ipulae-para ade nona pisa. Nipuna mamina oyaere yaako pu tua lepo lepo atasa. ");
INSERT INTO kew_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Goa pua Moses-para Elaija lapo ipua Yesu raapu agaa lalaina adesimi. ");
INSERT INTO kew_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita-me goa adoa Yesu gupa lakesa: Aa Mudu, niaa go-para pima pare ora epe ta. Gore neme pokaalo ada repo go-para pano. Medare nena medare Moses-na medare Elija-na warialua. ");
INSERT INTO kew_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nipumi go agaa pena lala pirina paa pu kipiae moae medame nimu rigitisa. Go moaena ru-nanere agaa meda gupa sa: Go naakiri ora nina epe Si. Neme nipu madaa pedo waru pe. Goa pe-ga nipuna agaa pagalepape sa. ");
INSERT INTO kew_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Gore mo aanumi go agaa pagoa simina pururumi omoa paalame omesimi. ");
INSERT INTO kew_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Gore Yesu nipu nimu piri-para ipua nimu gupa epa lakesa: Nimi paalame naomalepape. Nimi rekalepa. ");
INSERT INTO kew_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Goa sa raburi nimumi adasaawa aanu meda napirina Yesu nipu padane-mare adesimi. ");
INSERT INTO kew_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nimu so rudu gimoa ora kilipita pulaina Yesumi nimu-para puri paloa gupa lakesa: Nimimi abia go adamede yaere onaa meda ora napua laketapape. Ora nalapae piraliminare ni Onaa Raapu Pirape Aa-na Siri matmat-para wala rekalua sa. ");
INSERT INTO kew_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Gore nipuna aanumi nipu gupa lakesimi: Akeane mo rekena agaa tisaanumi mo Elaija aba epenalo teme? ");
INSERT INTO kew_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Gore Yesu nipumi gupa lakesa: Elaija ora aba ipuare nipumi oyae rayo managola salia sa. ");
INSERT INTO kew_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pare neme nimi lagialo: Elija-re aba ipisa pare onaanumi nipu na-ademe pare nimumi wae kone sua Elaija-para pisimi. Apo waea pisimide konere Onaa raapu Pirape Aa radaa manaalimi sa. ");
INSERT INTO kew_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yesumi goa sa rabu nipuna disaipel aanumi Jon Baptais-para lakesa-daa niminaasimi. ");
INSERT INTO kew_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nimu onaa rayo piri-para pua opapasimi raburi aa meda ipua Yesu madaa rumu koba pua agaa gupa misa: ");
INSERT INTO kew_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Aa Adaa, nemere nina naaki madaa odome omape. Nipu oro yaalo maeyaawa repena sulaa-para page ipa-para agu atapia. ");
INSERT INTO kew_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Neme nena disaipel aanu piri-para lamua pe pare nimumi mada namaperekeaeme. ");
INSERT INTO kew_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Gore Yesumi nipu lakesa: Go onaa nimiri kone narulaawa pimi. Nimina robaa-parare o ta. Nimi raapuri ni rana akepu raapo piralua ya? Nimina kedaare neme rana akepu raapo rialua ya? Gore mo naaki ni piri mea ipulupa sa. ");
INSERT INTO kew_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesumi mo wae remo-para puri pane agaa loa sana mo naaki nipuna wae remo mea rubaasa raburi go naaki ora aipapulu rekesa. ");
INSERT INTO kew_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Go raburi Yesu agu raapo pirina nipuna disaipel aanumi ipua gupa epa lakesimi: Ake pua niaame go wae remo mada namea rubema? ");
INSERT INTO kew_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Gore Yesumi nimu-para lalo: Nimimi nina agaa robaa-para waru namea imi. Pagalepa. Nimimi Gote-na agaa mo repena kamana oge ini nona piane robaa-para mea salimiri nimimi go su rudu madaare ne lusu rua mogo-nane pu teme raburi mada palia. Goa ogesi-daa kone rulalimiri nimimi kogono rado meda rayo mada pu kiritalimi. ");
INSERT INTO kew_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Go-rupa wae remo mea rubapere pora padane ia-daa nimimi beten lo eta madaa niti pua go remo mada mea rubalimi. ");
INSERT INTO kew_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Gore Yesuna disaipel aa rayo Galili su-para epa pirisimi rabu Yesumi nimu-para lalo: Onaa Raapu Pirape Aa-na Siri nimumi iaanu mea kateme. ");
INSERT INTO kew_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Goa puare nimumi nipu tu maomaawa mea rogaalimi. Goa palimi pare wala yapi repome matmat-para wala rekalua. Go raburi mo onaanuna kone-parare ora kedaame waru omesimi. ");
INSERT INTO kew_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Wala orope Yesu-para nipuna disaipel onaanu-para Kaperneam su-para pisimi. Go raburi no lotu adana mone takis mi aanumi Pita-para gupa epa lakesimi: Gore nimina tisaa-mere lotu adana takis mone-re lopata ya? ");
INSERT INTO kew_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Gore Pita nipumi e loa sana no ada ru-nane pua odobasa rabu Yesumi nipuna agaa aba loa Pita agaa gupa misa: Saimon, nemere ake kone sae ya? Go su amaa aa mudunu-parare aapimi mone takis lopateme ya? Gore nimuna ruru onaame lopateme pae pa kimisu aa ruru radonumi lopateme ya? ");
INSERT INTO kew_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Gore Pita-me lalo: Pa kimisu aa ruru radonumi lopateme. Gore Yesumi lalo: Nimumi goa peme-pulu nimuna rurumi takis nalopaina. ");
INSERT INTO kew_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Goa peme pare neme nimuna kone namaoyaalua-pulu ne mo ipa ini-para pua ena agona pua sa. Ena ora aba mealiri nipuna agaa olape. Goa puare ena gona agaa-para mone salia rabu mua saa lapo ratana lotu adana mone takis mea kalape sa. ");
INSERT INTO kew_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Go raburi disaipel aanumi Yesu piri-para ipua lalo: Gote-na Surube Su-parare aapi aa mudu pitia ya simi. ");
INSERT INTO kew_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Gore Yesumi naaki oge meda ipu loare nimuna rikiraana mapiraasa. ");
INSERT INTO kew_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Goa pua nipumi lalo: Pagalepa. Nimina kone perekea oge nogo naaki-rupa piralimiri Gote-na surube su-para mada adalimi. ");
INSERT INTO kew_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Onaa rayome oge nogo naaki-rupa piralia-daare go onaanumiri Gote-na Surbe Su-para aa mudu piralimi. ");
INSERT INTO kew_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Gore onaa rayome nina bi loa oge nogo naakinu-rupa epe kone su raba mealimi-daare gore ni-para page goa palimi. ");
INSERT INTO kew_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Go oge nogo naakinuri ni madaa kone rulaeme. Goa pea-ga onaa medame nimuna kone rulae yae maoyaaliiare gore nipu mua adaa aana-me maa-para opeme adibaawa ipa ini-para mea rubalimiri ora epe ta. ");
INSERT INTO kew_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Go su amaa onaanuri oro yaalo wae yaenumi nimuna kone rulae yae maoyaata-pulu odo ora waru pea. Gore oro yaalo wae yae epea pare go wae yae mea epea onaanuri odo ora waru pea. ");
INSERT INTO kew_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Gore nena kimi page aame page ne pupitagi manaali-daare gore ki aanu kepea rubalepape. Gore nena ki aa padane-ma aaware ne oro yaalo epe-rupa piraliri ora epe tea. Pare nena ki aa lapo rata pa aawa pirua wae yae paliri naudini repena sulaa-para mea rubalimi-pulu ora o tea. ");
INSERT INTO kew_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Go page nimina inimi wae yae meda adalimiri nena ini rasu rubalepape. Gore nena ini padane-ma aaware epe-rupa ora yaalo pirali-pulu ora epe tea. Pare nena ini lapo rata pa riaawa pupitagi naliri ne repena sulaa-para mea lopalimi-pulu ora o tea. ");
INSERT INTO kew_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Nimimi waru adoa go oge onaanu narabuaniaatepape. Dia, gore neme nimi lagialo: Nina so yaa-para pi Aapana ensel-numi nogo naakinu waru adoaawa surubea. ");
INSERT INTO kew_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Gore Onaa Raapu Pirape Aa-na Siri su amaa ipua wae-rupa etapae onaanu raba mulalo ipisu. ");
INSERT INTO kew_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Nimimi ake kone salimi ya? Aa medame sipsip 100-pela punalia pare mena sipsip padane etapalia raburi mada naesapalia ya? Gore nipumi mo 99-pela mena sipsip medaloma pa ainaloa nipumi go mena sipsip padane asapula palia. ");
INSERT INTO kew_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Neme ora nimi lagialo: Mo sipsip etapaaliade pare asapua adasaawa muare mo aa nipumi raaname omalia. Goa puare mo mena medaloma pa aemenuri nimu madaa go-rupa raaname naomalia. ");
INSERT INTO kew_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Gore nimina so yaa-para pia Aapamere go oge nogo naakinu-rupa etapalimina kone naia. ");
INSERT INTO kew_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Gore nena ameme ne-para waea paliare ne pua nipi lapo meda-para pirua nena amena wae yaenu mea waalape. Gore nena agaa pagaliare gore nena ame wala epe-rupa piralipi. ");
INSERT INTO kew_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Go page nena agaa napagaliare neme agaa pagaliade aa medalomana aba lamua pua tapape. Goa pua nimi repore mo aa laketa pulupape. ");
INSERT INTO kew_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Pare nena agaa napagaliare gore neme lotu ada-para piri onaa lakelape. Go lotu ada-para piri onaana agaa page napagalia gore nipuna agu raapo pora pamina gimalepape. Go rabu nipu Gote-na agaa napage aa-para takis wae-rupa mi aa-para go-rupa nona piane pitia. ");
INSERT INTO kew_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Gore neme nimi lagialo: Oyae rayo go su amaa rogaa salimiri Gote-me so yaa-para page rogaa salia. Pare go su amaa esepe salimiri Gote-me so yaa-para page esepesaalia. ");
INSERT INTO kew_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Gore neme ora nimi lagialo: Nimina rikiraana piri onaa laapome kone padane sua oyae meda mulalo beten tepere gore nina so yaa-para pia Aapame nipi mada gialia. ");
INSERT INTO kew_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Gore onaa repome page lapome page nina bi madaa kone rulaawa ada padane-para kirita piralimiri nimu raapu piralua. ");
INSERT INTO kew_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Go raburi Pita nipu Yesu piri-para ipua agaa gupa misa: Aa Mudu, nina ameme ni-para waea pina neme nipuna wae kone rana akepu raapo mea rubalua ya? Rana 7-pela pina gimalua ya? ");
INSERT INTO kew_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Gore Yesumi nipu lakesa: Neme rana 7-pela pina gimape pi-daa nalawade. Dia, pare 70-pela taims 7-pela nipuna waea mea rubape. ");
INSERT INTO kew_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Go madaare Gote-na Surube Suri go-rupa yaade: Aa mudu king meda pirua nipumi yago mi kogono naakinu maredepo yatalo pea sa. ");
INSERT INTO kew_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nipumi yago maredepo yainaloa ripima pisa rabu kogono aa meda lamua ipisimi. Nipuna yagore ora adaapupe, niaame mada nadipialima. Ora adaapu foti milion kina-rupa teme. ");
INSERT INTO kew_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pare mo aame mogo mone yago mada na-abutea-pulu nipuna aa adaame gupa lakesa: Go aa nere ora kogonome adini aa-rupa piraina. Go rabu nipuna ona-para nipuna nogo naaki-para oyae rayo-para kabalimina. Goa pua go mone-re mo yago medaloma abutea. ");
INSERT INTO kew_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Goa sa rabu mo kogono naaki nipu mo aa adaana kibu-para rumu koba pua adaniaa pirua lalo: Neme ni odome omape. Go yago rayore neme mada abutua. ");
INSERT INTO kew_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Go kogono naakina aa adaame nipu madaa odome omoa nipu pirina gimisa. Goa pua nipuna yago mone page gimisa. ");
INSERT INTO kew_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Go rabu go kogono naaki nipu amaa puare nipuna padane kogono pi naaki yago pua adesa. Go aare nipuna yago mone ogesi 40 kina go aa madaa isa. Go aa adesa-pulu nipumi mo aa-na maa regepeminua lalo: Neme nina yago rayo abulape. ");
INSERT INTO kew_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Goa pisa-pulu nipuna kogono padane pi aa nipu rumu koba pua agaame gupa ogesa: Neme ni odome omoa ni ado pirape. Neme yago mada abutua. ");
INSERT INTO kew_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pare nipumi gimi omoa kalabus ada mapataasa. Goa pua nipuna yago abunalo mada esepeaalia. ");
INSERT INTO kew_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Gore mo kogono padane pisimi aanumi go kone adoa nipuna robaa-para o sa. Goa pua rayo nimuna aa adaa piri pua puaa lakesimi. ");
INSERT INTO kew_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Go raburi aa adaame mo kogono naaki ipu loa gupa lakesa: Nere kogonome adini naaki wae yana. Abade neme ni piri ipua re epa lae-daa nina yano rayo gimawade. ");
INSERT INTO kew_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Neme abade ne padane odome omesude-ga akeane nena kogono padane pi naaki odome naomae ya? ");
INSERT INTO kew_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Gore nipuna aa adaame nipu-para ratu yawoa nipu kalabus ada-para mea rapaasa. Goa pua nipu radaa manaawa nipuna yago rayo abunaloa mada esepealimi. ");
INSERT INTO kew_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Go rabu Yesumi lalo: Nimi rayona koneme nimina amena wae yae namea rakepealimiri nina so yaa-para pia Aapame page nimi-para goa palia. ");
INSERT INTO kew_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesumi go agaa aba lo kiritua Galili su gimoa mo ipa Jordan-na mone pane pua Judia su ru-nane pisa. ");
INSERT INTO kew_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Go raburi onaa adaapumi nipu rata mea ipisimi rabu nipumi yaina ome onaa go su-para maepeaasa. ");
INSERT INTO kew_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Gore mo Farisi aanumi Yesu ko tulalo ipua lalo: Gore niaana rekena agaa madaare aa medame nipuna ore pa amaa mada gimalia ya? ");
INSERT INTO kew_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesumi lalo: Gore nimi abade go agaa buk-para gupa nadipisimi ya? Aba ripiare Gote-me oyae rayo waria sana ona aa lapo aba warisa. ");
INSERT INTO kew_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Goa pisa-ga aa medame nipuna Aapa ama gimoa nipuna ona raapu padane-para piralipi. Go rabu nipu lapore ora padane piralipi. ");
INSERT INTO kew_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Goa pisa-pulu nipu lapo padane-rupa piralipi. Gore Gote-me aba nipu lapo makibuma lapaasa-pulu wala repaaya mada narugulalipi sa. ");
INSERT INTO kew_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Gore mo Farisi aanumi nipu gupa lakesimi: Goa lae pare Moses-na rekena agaamere aa medame nipuna ona rasini pepa tua kaloa nipu penaalape taasa. Akeane gupa sa ya? ");
INSERT INTO kew_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Gore Yesumi nimu lakesa: Nimimi agaa napagoa wae kone imi-daa Moses-me nimina ona rasini pora mea waasa. Pare ora abade Gote-me oyae warisa rabu go pora naisa. ");
INSERT INTO kew_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Neme nimi gupa lagialo: Gore aa rayona orenumi aa paake nanalia pare aanimi pa mea ratua ona rado meda mealimi-daare go aanu nimumi ona paake yone aa-rupa piralimi. ");
INSERT INTO kew_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Gore Yesuna disaipel aanumi nipu lakesimi: Gore aa nipu mo ona raapu agu aawalipiri ora epe ta simi. ");
INSERT INTO kew_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Gore nipumi nimu gupa lakesa: Onaa rayome go agaa mada napago kiritalimi. Gote-me abade nimu puri pane agaa lagisade. ");
INSERT INTO kew_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Paga, aa medalomame kone rado rado salimiri nimumi ona mada nayoteme. Medaloma nimuna amanumi madisimi rabu abe aa aeme. Aa medalomamere abade nimuna ru mu pasimi-pulu nimumi ona mada narumaasimi. Aa medalomamere Gote-na Surube Su madaa kone sua ona narumaasimi. Aa meda go agaa pago kiritaliare nipumi mada palia. ");
INSERT INTO kew_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Go raburi Yesu piri-para oge nogo naaki medaloma lamua ipisimi. Gore nipumi nimuna aalu madaa ki sua beten lainalo mea ipisimi. Goa pisimi pare nipuna aanumi mo onaanu-para ratu yawesimi. ");
INSERT INTO kew_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Go rabu Yesu nipumi lalo: Goa natapape. Go nogo naakinuri ni piri-para epenaatapape. Gote-na Surube Suri go nogo naaki go piane-me mada mealimi. ");
INSERT INTO kew_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Goa loa sana nipuna kimi aalu madaa su kiritua nipu go su-para gimoa pisa. ");
INSERT INTO kew_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Aa meda Yesu piri ipua goa epa sa: Tisaa, neme akea pua ni epe-rupa oro yaalo piralua ya? ");
INSERT INTO kew_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Gore Yesumi nipu agaa misa: Akeane neme ni-para epe yae madaa agaa epa meae? Aa padane-ma epe ta. Gore ne ora epe-rupa piralua kone saliri neme Gote-na rekena agaa rayo waru ratape. ");
INSERT INTO kew_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Gore mo aame nipu gupa agaa misa: Go rekena agaare ake ya? Gore Yesumi lalo: Neme aa meda natu maomape. Neme ona paake nayolape. Neme paake nanape. Onaa meda-para yaa agaa nalape. ");
INSERT INTO kew_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Nena ama aapanu raapu pawa pirua nimuna bi minasaape agaa pagape. Nena ada lapa piri onaanu raana ome-rupa nena yago meda raana omape. ");
INSERT INTO kew_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Go rabu mo aame Yesu gupa lakesa: Mo rekena agaa rayore aba pago kirite. Goa pawa-ga meda abiare ake palua ya? ");
INSERT INTO kew_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Gore Yesumi nipu lakesa: Neme ora epe-rupa pitua kone saliri nena oyae rayo madaa mone mua onaa naraanu kalape. Goa paliri nena epe yoto so yaa-para salia. Goa pua ni rata mea epape. ");
INSERT INTO kew_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Go raburi mo ogege aame go agaa rayo pagoa kedaame omo pirisa. Gore nipumi oyae adaapu isa-pulu go yae rumape kedaame omesa. ");
INSERT INTO kew_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesumi nipuna disaipel aanu-para lalo: Amo ne oyae adaapu i onaanuri Gote-na Surube Su-para popere kalai peme sa. ");
INSERT INTO kew_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Agaa meda lagialo: Kamel mename noae kego-para pola pea pare ora kalai pula pea. Goa pea pare amope aare so Gote-na Surube Su-para polalore apo mename noae kego-para kalai mada pua palia. ");
INSERT INTO kew_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Gore nipuna aanumi go agaa pagoa nimu waru pogolasaawa nimumi lalo: Goa pea-ga oro yaalo kagaa pirape konere aapimi mealia ya? ");
INSERT INTO kew_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Gore Yesumi nimu waru adaaba sua lalo: Onaanumiri oyae mada napalimi pare Gote-me oyaeyae rayo mada palia. ");
INSERT INTO kew_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nipumi goa sa raburi Pita-me nipu-para gupa sa: Pagape, niaame niaana oyae rayo gimoa ne rata mea epa amaade. Goa pa amaade-ga niaamere ake mealima ya? ");
INSERT INTO kew_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Gore Yesumi nimi ora lagialo loa gupa lakesa: Orope kagaa yapi di opaliade raburi Onaa Raapu Pirape Aa-na Siri epe king siaa madaa piralua. Go raburi nimi ni rata mea ipua nimi page epe king siaa 12-pela madaa pirua Israel onaana ruru 12-pela madaa koso lape agaa pagalimina sa. ");
INSERT INTO kew_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Go rabu onaa rayome abade ni madaa kone rulaawa nimumi nimuna ama aapa nogo naaki ame baaninu page maapu oyae rayo gimisimi-pulu nimumi apo oyaeyae nona piane yoto ora waru mealimi. Goa pua nimu oro yaalo epe-rupa kagaa piralimi. ");
INSERT INTO kew_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Abia onaa adaapu riri-nane pimi pare wala orope masaa-nane pimi onaa aba ripia epalimi. Goa pua nimu riri-nane epalimi. ");
INSERT INTO kew_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Gore Gote-na Surube Su-na agaa gupa ia sa: Aa medame nipuna wain maapu surubisa. Goa pua nipu ora abasade yapipu wain maapu kogono pinalo onaanu mula pisa. ");
INSERT INTO kew_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Gore nipumi mo kogono naakinu raapu kone padane suare go yapi padanemere ten kina meama palimi sa. Goa loare nimu mo wain maapu-para kogono pula penalo mea rapaasa. ");
INSERT INTO kew_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Goa puare naare rapataina nipu kiritae su-para pua sana aa medaloma pa aina adesa. ");
INSERT INTO kew_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Gore nipumi go aanu gupa lakesa: Nimi page neme epe mone mada gialua-ga wain maapu kogono pula pulupa sa. ");
INSERT INTO kew_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Goa loa nimu pisimi. Gore naare pabola pulaina page aa medaloma wala agu mea rapaasa. ");
INSERT INTO kew_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Gore ora aebo ribaa talo palaina maket-para pua aa medaloma pa aina adesa. Go rabu nipumi lalo: Nimi go naare raama puaina ake ado piaeme ya? ");
INSERT INTO kew_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Gore nimumi lalo: Niaa kogono giape aa meda dia yaade simi. Gore nimi page mo wain maapu-para kogono pua pipa. ");
INSERT INTO kew_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ora ribaa sa raburi mo wain maapuna aaraame surube aa gupa lakesa: Neme kogono naakinu yaaloa nimuna mone kalape. Orope epamede kogono naakinu kalaama kalaama pua aba ripia epamede kalo kiritape. ");
INSERT INTO kew_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Gore aebo 5 klok raburi kogono epa pisimide aanumiri ten kina agu kasa. ");
INSERT INTO kew_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Gupa misimi pare ora abade epa pisimide aanumiri nimu mone ora adaapupe mealima kone isimi. Pare dia nimu page 10 kina agu meama pisimi. ");
INSERT INTO kew_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nimumi muare mo maapuna aaraa ratu yawesimi. ");
INSERT INTO kew_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Gore nimumi gupa simi: Go aanuri pena go epaade pare nimu kogono ogepusi pamede pare nimu mone niaa giaede-rupa agu mealeme. Niaamere naare paalu kogono radaa pi pa amaa sima. ");
INSERT INTO kew_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Nimumi goa simi raburi mo maapuna aaraame nimuna aa padane-mare gupa lakesa: Adami aa, neme ni namakiraate. Gore abade saa agaa lapade rabu neme ten kina gialua laede. ");
INSERT INTO kew_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Gore nena mone mua pu. Abade neme ne gisude-rupa orope meawade aanu page gode-rupa katoa. ");
INSERT INTO kew_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Gore nina go mone-me page nina yada pulalo paluare gore mada dia? Neme epe kone sawade pare nena pu-para udipa kone sae ya? ");
INSERT INTO kew_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Go rabu Yesumi lalo: Goa pea pare orope epeme onaanuri nimu aba riri-nane popalimi. Yapare aba ripia epeme onaanuri wala orope epamede. ");
INSERT INTO kew_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu nipu Jerusalem su-para polalore nipuna disaipel aa 12-pela mea pisa. Nimu pora-nia pulaawa disaipel aanu agu raapo-para gupa lakesa: ");
INSERT INTO kew_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Pagalepa. Abia niaa Jerusalem su-para baina. Go-parare Onaa Raapu Pirape Aa-na Siri miru irae aa mudunu-para rekena agaa tisaanu mea kateme. Go rabu nimumi koso lape agaa loa tu maomalimi sa. ");
INSERT INTO kew_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Gore nimumi muare onaa ruru radonu mea kanaloare nimumi wae ero agaa loa repena unimi tuare repena polopea-para tu maomalimi. Goa pua rogaalimi pare yapi repome matmat gimoa wala rekalua sa. ");
INSERT INTO kew_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Go raburi Sebedi-na oremere nipuna naaki lapo Yesu piri-para lamua ipisa. Gore go ona nipumi rumu koba pua su adaniaawa oyae meda madaa Yesu-para ogesa. ");
INSERT INTO kew_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Gore Yesumi nipu agaa misa: Nere ake raana pea? Go oname lalo: Ne aa mudu pirali rabu naa naaki laapore meda nena popo ki-nane pirina meda koya ki-nane pirina sa. ");
INSERT INTO kew_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Gore Yesumi nipu lakesa: Mo reke mulalo paape yaere nipumi waru na-adepe. Gore nipimiri go neme ipa naluade kap madaare radaa pi ipa mada nalipi ya? Gore nipumi lalo: Saa mada nalipa sipi. ");
INSERT INTO kew_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Gore Yesumi nipu lakesa: Nina kap mada nalipiri gore epe ta pare nina popo ki-nanepara koya ki-nane lapore aapi piralia palo go agaare neme-daa namakuaayo sa. Apo pirape siaanuri Aapa nipuna managola saaya. ");
INSERT INTO kew_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Mo 10-pela disaipel nimumi go remaa pagoa mo ameaya ratu yawesimi. ");
INSERT INTO kew_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Goa pisimi pare Yesu nipumi nimu ipulupa loa sana nimu-para lalo: Nimimiri ademe. Ruru radona aa mudunumi onaa rayo rabuniaawa nimi puri waru paboa nimuna agaa ora pagalepape teme sa. ");
INSERT INTO kew_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Aa mudu medaloma goa peme pare go konere nimi rikiraana nasaapiralepape. Dia, pare aa meda nimina rikiraana aa mudu piritalo paliare gore nimi raba meape kogono aa aba piralia. ");
INSERT INTO kew_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Aa medame ni mudu piralua kone salia-daare gore nimi raba mi aa-rupa aba pirina sa. ");
INSERT INTO kew_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Onaa Raapu Pirape Aare nipu raba mua nipuna kogono paminalo-daa naipisa. Dia, pare onaa adaapu raba mua nimu madaa epa omalalo ipisade. Goa pua nipuna kone wasupa nimu raba meapena katalo ipisa. ");
INSERT INTO kew_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Gore nimu Jeriko su gimoa pisimi raburi onaa adaapumi Yesu nipu rata mea pisimi. ");
INSERT INTO kew_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Gore mo ini rubu pi aa lapo mo pora aane-nane pirisipi. Nipumi Yesu epea remaa aba pagoa nipumi puri paloa nipumi gupa yaasipi: Nere Devit-na si neme saa laapo madaa odome omape. ");
INSERT INTO kew_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Goa sipi rabu onaa rayome nipina agaa loraatepa loa nipu-para ape simi. Yapare nipumi go agaa rasua wala ora puri palo yaasipi: Aa Adaa, nere Devit-na si-ga neme saa madaa odome omape sipi. ");
INSERT INTO kew_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Gore Yesu nipu pua rekaawa nipu yaaloa lalo: Neme nipiri ake pano ya? ");
INSERT INTO kew_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Gore nipumi gupa sipi: Aa Adaa, neme saana ini maepeaaina kone salepa. ");
INSERT INTO kew_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Gore Yesumi odome omoa nipuna ini maepeaasa. Ora go raburi nipuna inimi oyae waru adoa simina nipu page Yesu rata mea pisipi. ");
INSERT INTO kew_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nimu Jerusalem su-para re-para pua opapasimi rabu Rudu Oliv re-para epa pirisimi. Go-parare Betfage su adaare meda aasa. Go rabu Yesumi nipuna disaipel aa lapo mea rapaasa. ");
INSERT INTO kew_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Nipumi go aa lapo gupa lakesa: Mogo adaare-para pulupa. Puare donki mena si agiaaya lapo apo opeme adiba aaya-ga pua adalepape. Nipimi pua koloa mea ipulupape. ");
INSERT INTO kew_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Gore aa medame nipi-para agaa meda epa teare nipimi nipu gupa laketapape: Aa Adaa nipu kogono go donki mena madaa ia-pulu nipu saa mea palipa. Goa tepe rabu aa medame donki mena mea rapalia. ");
INSERT INTO kew_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Go pisipina kogonore abade Gote-na agaa lakene aame gupa sa: ");
INSERT INTO kew_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Abia Saion su-para piri onaanu gupa laketapape: Aa mudu abia nimi piri apo ipula-daa. Nipu kone pawa sua donki mena masaana pirua no epea-daa. Nipumi mo oge donki mena si onaa meda abi napiri madaa pia sa. ");
INSERT INTO kew_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Gore mo disaipel aa lapomere mo Yesumi lakesa-rupa goa pua pisipi. ");
INSERT INTO kew_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nipumi mo donki mena adibae yare pua mua nipuna adaa mamina-nu donki mena masaa mada sua ipisipi. Goa puare Yesu nipu so donki mena masaana pirisa. ");
INSERT INTO kew_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nipu pirua ipisa rabu onaa adaapupeme so pora repaa repaa rekasimi. Go rabu medalomame nimuna mamina-nu pora-nia mea saapisimi. Medalomamere repena alanu yado saapisimi. Gore Yesumi rabuama epenalo pisimi. ");
INSERT INTO kew_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Go rabu onaa adaapu medaloma aba riri-nane pisimi medaloma pa aapu-nane ipua gupa yaasimi: King Devit-na siri ipula-daa. Nipuna bi minasaamina. Aa Mudu-na bi mea ipula-daa nipuna bi minasaamina yaasimi. Gote ora sone pia adaa aa-na bi kalamina yalaama pua mea ipisimi. ");
INSERT INTO kew_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu nipu Jerusalem su-para pisa raburi mogo adaare-para piri onaa rayo pogolasaawa simina go aare aapi ya simi. ");
INSERT INTO kew_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Gore mo nipu raapu pisimi onaame lalo: Gote-na agaa lakene aa Yesu simi. Nipu Galili su robo-para adaare Nasaret-para piri aa yaade simi. ");
INSERT INTO kew_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu nipu mo lotu ada ru-nane pua odobaawa nipumi lotu ada-para pisa rabu mone oyae ropo pi aanu amaa-nane ratu tisa. Nipumi pua mone ini ropo pi aanuna reke lakepe rubebe pua yaanu kabe aanuna rekenu lakepe tisa. ");
INSERT INTO kew_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Goa puare nipumi agaa gupa lakesa: Gote-na agaa i buk madaare nipumi gupa ta: Nina adaare beten lape ada lo bi ma-alimi pare nimi paake ne aanuna kaledape ada-rupa perekea ma-arimina sa. ");
INSERT INTO kew_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yesu nipu lotu ada-para pirina ini wae onaanu-para aa wae onaa medaloma nipu piri-para ipisimi. Goa pisimi rabu nipumi nimu maepeaasa. ");
INSERT INTO kew_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Goa pisa pare Gote-na miru irae aa mudunu-para mo rekena agaa tisaa aanu-para nimumi mo Yesumi napiaa kogono pina adesimi. Gore mo nogo naakinumi lotu ada-para pirua gupa simi: King Devit-na sina bi minasaamina. Goa simi rabu nimumi ronome omesimi. ");
INSERT INTO kew_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Goa pua nimumi Yesu-para lalo: Neme mogo lamede agaare pagae? Gore nipumi lalo: E, go agaare pagalo pare abade nimimi agaa gupa nadipisimi kone salo: nimimi abade nogo naakinu-para madu saapiri rupame agaa mana waru pagesimi-pulu nimumi bi minasaatalo pimi. Go agaa napageme ya? ");
INSERT INTO kew_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Gore nimu pirina Yesu adaare Betani su-para ribaa pua puaa patisa. ");
INSERT INTO kew_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Gore ekeraa-nane yapi lapaasa rabu Yesu nipu so adaare-para pisa rabu reame pua omesa. ");
INSERT INTO kew_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Gore nipumi repena fik ini pora-nia adoa go-para pisa. Pua adesa pare ini padane-daa page naetasa pa amaa yope agu aasaaya. Gore Yesumi mo repena fik lakesa: Nere ini wala meda ora namadiape. Goa sa rabu ora aipapulu mogo repena fik kaapu sa. ");
INSERT INTO kew_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Gore disaipel aanumi goa adoa paalame omesimi. Go repena fik akea pua aipapulu kaapu yala kone isimi. ");
INSERT INTO kew_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesumi lalo: Pagalepa. Nimimi kone waru rulaawa kone lapo nasalimiri go repena fik madaa pawade-rupa nimi page goa agu mada palua. Go-rupa madare nimimi mogo aaya rudu ne lusu rua no ipa solwara-para pua pogola teme raburi mada pagalia. ");
INSERT INTO kew_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Gore nimimi ora kone rulaawa beten teme-daare gore oyaeyae rayo beten loa mada mealimi. ");
INSERT INTO kew_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Gore Yesu nipu lotu ada ru-nane pirua onaa rayo epe agaa moge riaasa. Go rabu Gote-na Miru Irae Aa mudunu-para Israel aa mudunu-para ipua Yesu-para epa lalo: Nere go kogonore aapina puri mua pi simi. Nere abade go kogonore aapimi pape laa-daa pi simi. Nere go kogono painalo puriri aapimi gia simi. ");
INSERT INTO kew_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Gore Yesumi nimu gupa lakesa: Neme page agaa padane gupa nimi agaa mealuame pi. Gore nimimi nina agaa-daa yago talimiri neme page nimi nina kogono go aame gisalo nimi lagialua. ");
INSERT INTO kew_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jon-me abade onaana baptais mea saayaade kogonore Gote-me kasa pae pa onaanumi kasimi ya? Go agaa pagoa nimuna agaa lalaawa gupa simi: Gore niaa Gote-me kasa tema-daare gore nipumi niaa gupa lagialia: Akeane nimimi Jon madaa kone narulasimi palo lagialia. ");
INSERT INTO kew_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Gore niaame pa onaanumi kasimi tema-daare niaana onaanu madaa paalame omalima. Gore onaa rayome Jon-re Gote-na agaa lakene aa kone imi temare niaa talimi. ");
INSERT INTO kew_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Go rabu Yesuna agaa gupa abuloa lakesimi: Niaare na-adema simi rabu Yesumi lalo: Goa teme-daare aapimi ni puri gua kogono gea aare nimi page mada nalagialua sa. ");
INSERT INTO kew_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesumi adaa aa mudunu-para gupa lakesa: Aa padaneme naaki lapo madu isa. Go remaare pagalepape. Gore aaraame mupaa naaki lakeloa nere wain maapu kogono pula pu sa. ");
INSERT INTO kew_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Gore go naakimi gipia loa-ga wala orope kone perekea wala kogono pula pea. ");
INSERT INTO kew_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Gore aaraame wala mo naaki meda piri pua padane goa pua sa. Gore go naakimi lalo: Aapa, ni palua loaaya pare napisa. ");
INSERT INTO kew_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","32","Go rabu Yesumi lalo: Gore go naaki laapo madaare aapimi aaraana kone misipi? Gore nimumi lalo: Mupaa naakimi simi. Gore Yesumi nimu-para lalo: Abade Jon nimi piri-para ipua nipumi epe pora madaa epe agaa mogeasa pare nimimi kone narulasimi. Dia, pare mo takis mi aanu-para aa paake rume onanuri orope nimumi Jon-na agaa madaa kone rulasimi. Goa pea-ga takis mi aanu-para aa paake rume onanu-para nimuri Gote-na surube su-para aba riri-ne adalimi. Goa pisimi pare nipu aba adoa simina kone naperekene nipu madaa kone narulasimi. ");
INSERT INTO kew_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Nimi saa agaa meda pagalepa. Aa medame nipuna su adaape saawa wain maapu adaape poasa. Nipumi kepo pu mawaawa go-para ini igipini yae warisa. Goa puare nipumi maapu surubape ada adaalupe maasa. Goa puare nipumi mone yoto meape aanumi surubainaloa nipu kimisu pisa. ");
INSERT INTO kew_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nipu pua aawa orope mo wain maapu ini kereape di rudu sa rabu maapu surube aanu piri-para kogono aa medaloma penasa. Gore nipumi mo surube aanu mo wain pore nape medaloma gina kone sua pisa. ");
INSERT INTO kew_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Go kone isa pare mo maapu surubae aanumi nipuna kogono naaki meda aana-me tuare tu rubebe pisimi. ");
INSERT INTO kew_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Gore mo wain maapuna aaraame wala kogono naaki medaloma mea rapaasa. Pare aba mo maapu surubae aanumi pisimi-rupa tisimi. ");
INSERT INTO kew_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Wala oropere nipuna si mea rapaasa. Aaraame nina naakina agaa pagalimi kone sua mea rapaasa. ");
INSERT INTO kew_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pare mo maapu surubae aanu nimumi naaki adoa nimumi goa simi: Go ipula aamere aaraana moae yae rayo mealia-ga niaame nipu aipapulu tu maomaawa go maapuri niaa ora meamina simi. ");
INSERT INTO kew_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Goa loa nipu to maomaawa mua so kepo rarane mea rubisimi. ");
INSERT INTO kew_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesumi agaa gupa sa: Orope mo wain maapuna aaraa ipuare mo wain maapu surubae aanu-parare ake palia kone imi? ");
INSERT INTO kew_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nimumi lalo: Go aa wae rayore waru talia. Goa pua mo wain maapu wala aa ruru rado mea katea. Go aanumi surubenaloa ini etaliade rabure raloa nipu epe kateme. ");
INSERT INTO kew_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Gore Yesumi lalo: Nimimi Gote-na agaa i buk madaa iade agaare pagamina: Abade kamda kogono pi aanumi mea rubesimi yaade aana-re abiare ora epe-daa ada palimi. Aa Mudumi abade goa pisa ya-pulu niaame go aana-mere epe rado piane ada maopaalia sa. ");
INSERT INTO kew_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Goa pea-ga neme nimi ora lagialo: Gote-na Surube Su-na eta maopaeme onaa mea katea-daa adalimi sa. ");
INSERT INTO kew_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Onaa rayome go aana madaa magatabalimiri nimu asa tabebe palia. Go aana-me onaa meda taliare gore go onaa aasatua rugulala palia. ");
INSERT INTO kew_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Gote-na miru irae aa mudunu-para Farisi aanumi Yesuna saa agaa pagesimi rabu niaa-para ta kone sua niminaasimi. ");
INSERT INTO kew_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Goa sa raburi nipu ripinaatalo pisimi pare onaa paalame omesimi. Onaame Yesu Gote-na agaa lakene aa kone isimi-pulu go aanumi paalame omesimi. ");
INSERT INTO kew_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Gore Yesumi nimu-para saa agaa meda wala gupa lakesa: ");
INSERT INTO kew_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Gote-na Surube Suri gupiane: Aa mudu medame nipuna naakina ona rumaasa rabure ogere adaape meda yawesa. ");
INSERT INTO kew_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Goa puare nipumi ona rumaatalo yawe ogere nola ipulupape loa nipuna kogono naakinu agaa mea penaasa. Laketa pisimi pare onaanumi mo ogere gimoa naipisimi. ");
INSERT INTO kew_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Gore naipisimi rabu aa mudumi wala kogono aa medaloma mea rapaawa gupa lakesa: Nimi puare epape onaanu-para gupa pua laketapape sa: Pagalepa, nina ogere aba lusua gawa mena yadapunu-para sinu page aba tu yawo ima tapape sa. Eta rayo aba managola sama-ga nimi ona rumaape eta nola ipulupape lo tapape. ");
INSERT INTO kew_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Mo kogono naakinumi go agaa pua lakesimi pare eta nape onaanumi go agaa gimoa nimuna kogono pisimi. Medare nipuna maapu e pola pisa. Medare nipuna bisnis kogono pula pisa. ");
INSERT INTO kew_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Goa pisimi pare aa medalomamere aa muduna kogono naakinu ripinaawa tu maomasimi. ");
INSERT INTO kew_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Gore aa mudu ratu yawoa nipuna soldia aanu mea rapaasa. Nimumi mo kogono naaki aanu tu maomaawa nimuna ada rayo irabasimi. ");
INSERT INTO kew_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Goa puare aa mudumi nipuna kogono naakinu gupa lakesa: Ona rumaatalo yawe etare aba managola sawade pare mo neme yalawade onaana konere o ta sa. ");
INSERT INTO kew_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Goa pea-ga nimi mo pora-nia pua go adalimide onaa rayore eta yawe nola epena laketapape sa. ");
INSERT INTO kew_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nipumi goa sa raburi pora kepaa-nini puare epe onaa-para wae onaa rayo makirita-mama pua adesa. Nimu rayo ipua mo onaa rumaae aana ada epa marulatabasimi. ");
INSERT INTO kew_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Mo onaa epa kirita pirisimi raburi aa mudu nipu mo kiritae onaanu adolalo epa odobaawa adesa. Pare aa padane-mame ona rumaae rabu kalae mamina namaraasa. ");
INSERT INTO kew_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Gore aa mudumi mo aa-para lalo: Adami aa, nere epe mamina na-ayamaina-ga akolo yapae sa pare agaa na-abusa. ");
INSERT INTO kew_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Go raburi aa mudumi kogono aanu gupa lakesa: Nimimi nipuna ki aa rogaawa so amaa mea lopalimi rabu nipu su ribaane-para pirina sa. Go ribaane-para piruare nipu re lo nipuna kidipaa rugulalo piralia sa. ");
INSERT INTO kew_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesumi agaa gupa lo kiritisa: Gore Gote-me onaa adaapu yaata pare nipumi adoa aa padane padane laatapu mua ru-nane mea pea sa. ");
INSERT INTO kew_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Gore Farisi aanumi Yesuna kone adolalo ko tisimi. ");
INSERT INTO kew_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nimuna disaipel aanu-para Herot-na aanu-para meda rabu Yesu piri mea rapasimi. Nimumi gupa pua simi: Tisaa, niaame nere ora agaa lape aa-rupa adema. Ora agaamere onaanu madaa rumaalia. Goa pe pare onaanu rayo kone padane-rupa ade. Dia, neme onaa rayo agaa rado piane lakete. ");
INSERT INTO kew_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Goa pede-ga neme abia yada kone saliri niaa lagi simi: Gore niaame Rom aa mudu Sisar-para takis mone kalamano yapae dia yapae agaa misimi. Niaana rekena agaame ake ta pae simi. ");
INSERT INTO kew_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Gore Yesu nipumi nimuna wae kone aba adoa nimu-para lalo: Nimiri yaa agaa ne aanu. Akeane nimimi ni-para yaa agaa loa ni ko taleme? ");
INSERT INTO kew_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nimimi mo takis kalape mone meda mea waatapa sa. Goa sa rabu nimumi mone meda mea ipua waasimi. ");
INSERT INTO kew_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Go rabu Yesumi nimu agaa misa: Go mone-na bi-para piksa-parare aapina ya? Gore nimumi Sisar-na simi. ");
INSERT INTO kew_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Goa simi rabu Yesumi nimu gupa lakesa: Gore Sisar-na yaere wala nipu pua katapape pare Gote-na oyaere Gote nipuna katapape sa. ");
INSERT INTO kew_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nimumi go agaa pagoa pogolasaawa Yesu gimoa pisisi. ");
INSERT INTO kew_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Go raburi Sadyusi aanu nimu Yesu piri-para ipisimi. Go aanu nimumiri ome onaanu wala narekalimi teme-daa goane Yesu epa agaa misimi. ");
INSERT INTO kew_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Nimu ipua lalo: Tisaa, Moses-me agaa gupa mogeasa: Aa meda nogo naaki napirina omaliare nipuna ona wasaa ameme nogo naaki madinalo mada rumaalia sa. ");
INSERT INTO kew_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Gore abade nimu amealu 7-pela pirisimi. Pare aa mupaare ona rumaawa omesa pare nipuna nogo naaki napirisa. Goa pisa-pulu nipuna masaa-nane ameme go ona wasaa nipu rumaasa. ");
INSERT INTO kew_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Wala ame laapo pa repo pa page nogo naaki napirina omaamapa amaa pisimi. Goa pu kiritua 7-pela amealu rayo pa omesimi. ");
INSERT INTO kew_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Mo amealu rayo omabasimi raburi orope mo ona page omesa. ");
INSERT INTO kew_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Gore neme mo ome onaa wala rekalimi rabu mo ona wasaare mogo aa 7-pela wala rekalimi-daa aapina ore ora piralia ya? Neme makuaaye nimu rayome mogo onana aaniri aapi ora piralia ya? ");
INSERT INTO kew_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Gore Yesumi nimu gupa lakesa: Nimiri Gote-na agaa napago nipuna puri page na-ademe-pulu nimimi agaa pa-rupa teme sa. ");
INSERT INTO kew_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Gore ome onaa wala rekalimide raburi mo ona wala narumaalimi. Dia, so yaa-parare ensel-rupa piralimi. ");
INSERT INTO kew_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pare go ome onaa wala rekape agaare neme nimi agaa mealo: Gore abade Gote-me gupa sa: ");
INSERT INTO kew_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Niri Abraham-para Aisak-para Jekop-para nimuna Gote pi sa. Goa pea-daa Gote-re aba ome onaanuna Gote-daa dia, pare nipu kagaa piraama laama pope onaanuna Gote yaade. ");
INSERT INTO kew_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Onaa rayome Yesuna agaa pagoa akepu tapae kone isimi. ");
INSERT INTO kew_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Gore Yesumi Farisi Sadyusi aanuna agaa pora poasa rabu Farisi aanumi go agaa pagoa nipu adola ipisimi. ");
INSERT INTO kew_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Nimu go epa kirita pirisimi raburi nimuna rekena agaana tisaa padane pirabasa-pulu nipumi Yesu ko tulalo goa sa: ");
INSERT INTO kew_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Tisaa, mo rekena agaa rayo ora epe ta-ga ora aba mudu rekena agaare aaya pae simi. ");
INSERT INTO kew_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Gore Yesu nipumi gupa lakesa: Nena Mudu Gote-re pu robaame page kone wasupame page puri-para rayome raana-me omoa pedo pu piralepape sa. ");
INSERT INTO kew_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Go rekena agaare ora aba mudu agaa lagialo sa. ");
INSERT INTO kew_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Gore rekena agaana lapo pa padane go-rupa lagialo: Nimina yogane madaa raana omo pedo pi kone imi-rupare pa onaa meda page padane-rupa raana omape sa. ");
INSERT INTO kew_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Go rekena agaa lapomere Moses-na rekena agaa rayo-para Gote-na agaa lakene aanu agaa rayo go agaa rolo-para epea. ");
INSERT INTO kew_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisi aanu nimu pa kiritaba pirina Yesumi nimu agaa gupa misa: ");
INSERT INTO kew_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Nimimiri Krais madaare ake kone imi? Nipuri aapina si ya? Gore nimumi Devit-na si simi. ");
INSERT INTO kew_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Goa simi rabu nipumi nimu gupa lakesa: Holi Spirit-mi akeane Devit-na kone marekaasa-daa nipu akeane nina aa mudu sana ya? Gore Devit-mi lalo: ");
INSERT INTO kew_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Gote-me nina Aa Mudu gupa lakesa: Nere nina popo ki-nane aa mudu piraina. Oropere nena iaanuri nina aa rolo-para mapiraalua sa. ");
INSERT INTO kew_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Gore Onaa Raapu Pirape Aa-na Siri nipu Devit-na si yaade-ga akeane Devit-mi bi nina Aa Mudu lakesa ya? ");
INSERT INTO kew_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Gore aa medame mo Yesu nipuna agaa meda na-abusimi. Gore nipu paalame omesimi-pulu wala go rabu page orope page nipu-para agaa meda nasimi. ");
INSERT INTO kew_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Orope Yesu nipumi nipuna disaipel aanu-para onaa rayo-para agaa gupa lakesa: ");
INSERT INTO kew_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Mo rekena agaa tisaanu-para Farisi aanu-para nimu Moses-na agaa moge riaata pirisimi. ");
INSERT INTO kew_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Goa pea-ga agaa rayo nimi lagialimiri nimimi pagoa waru mogealepape. Goa palimi pare kone meda nimumi nimi mogealimiri napagalepape. Goa pea pare go agaa napagoa rateme. ");
INSERT INTO kew_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Gore nimumi oyae adaapu rogaawa aanuna pasaa madaa mariaaeme. Goa peme pare nimuna kimi mo onaa naraba meape naniminaeme. ");
INSERT INTO kew_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kogono rayo nimumi pemere pa onaanumi nimu adena kone sua peme. Adalepa. Nimuna beten ta polalo peme raburi rogope madu imi. Go nu amaare madua ropaa-para enon yapa aapu-rupa ritimi. Go page nimuna mamina aanenu madaa oyaeyae pepena yaenu awo kilipiala peme. ");
INSERT INTO kew_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Eta yawo saeme raburi nimumi mo riri-nane pirape siaa go agu raaname omeme. Goa puare no lotu ada-para pimide-rupa riri-nane i reke madaa raaname omeme. ");
INSERT INTO kew_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Go page nimu mo maket-para peme rabu nimimi abi piralepape loa niaana tisaa teme rabu nimumi pedo peme. ");
INSERT INTO kew_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pare onaanumi nimi-para tisaa pi-daa wala nateme. Dia, nimu rayo amealu piralimi rabu tisaa padane piralia. ");
INSERT INTO kew_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Go page su amaa onaa medare niaana Aapa go pi-daa natapape. Nimina Aapa padane-mare so yaa-para pia. ");
INSERT INTO kew_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Goa pea-ga nimi-para nimumi Aa Adaa go pi-daa natapape. Dia, nimina aa muduri padane-ma pirua nipu Krais pia. ");
INSERT INTO kew_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Goa puare nimi aa mudu piritalo palimiri nimi onaa rayome raba meape aa-rupa aba pirina. ");
INSERT INTO kew_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Aa medame nipuna bipa aa mudu piritalo nipu bi minasaaliare nipuna bi rolo-para palia. Pare aa medame nipuna bi rabuaniaaliare gore nipu aa mudu mapiraalia. ");
INSERT INTO kew_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Nimi rekena agaana tisaanu-para Farisi aanu nimiri waru adalepape. Nimiri maeyae aanu pimi. Nimimi onaanuna ini agaa madaa Gote-na Surube Su-na pora gaape poaemede. Goa peme pare nimina bipare naodobaeme. Go page onaa medaloma ru-nane pua odobatalo peme pare nimimi rutu teme. ");
INSERT INTO kew_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Nimi rekena agaa tisaanu-para Farisi aanu nimiri waru adalepape. Nimiri maeyae aanu adaapu pimi. Nimimi ona wasaanuna ada-para oyae rayo paake nolalo peme. Goa pua nimimi go pupitagi nape kone rabuainaloa beten adaalu pa teme. Goa peme-pulu nimiri ora wae yoto mealimi. ");
INSERT INTO kew_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Rekena agaana tisaanu-para Farisi aanu nimi waru adalepape. Nimi ipunu madaa pirua ipa solwara rayona pamua su rayona onaa rayo nimina disaipel aa-rupa pirinalo pamuaeme. Nimina disaipel aanu mapiraaeme rabu nimu wala wae naaku-para go-rupa mapiraaeme. Gore nimi wae naaku-para ora palimi pare nipu nimimi naaku-para penaateme. ");
INSERT INTO kew_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Nimi ini rabuni onaame onaa pora mea waatalo peme. Gore nimi aba waru adalepape. Nimimi gupa temede: Aa medana lotu adana bi madaa yaa madaa makuaa tea-daare go agaare waru yae-daa dia. Pare so yaa-para aaya lotu adana gol aana-me warini oyae-daa temere gore epe ta teme. ");
INSERT INTO kew_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nimiri ini rubu pi aanu maeyae-rupa pimi. Ake madaa kone sua teme? Gore aana-me warini mone mudu yapae mo aana-me warini mone i epe lotu ada mudu yapae? ");
INSERT INTO kew_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Gore nimimi gupa teme: Aa meda aana reke madaa yaa madaa makuaa tea-daare go agaa mada gimalia teme. Goa pea pare nipumi miru irua mo aana reke madaa sua yaa madaa makuaa tea-daare go agaa mada nagimalia teme. ");
INSERT INTO kew_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nimi ora ini rubu pi onaa pimi. Gote-re ake kate ya? Gote-na miru irae epea palo Gote-na aana reke madaa miru irini ora epea ya? ");
INSERT INTO kew_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Gore aa medame aana rekena bi madaa yada makuaa tea-daare nipuna agaare so reke madaa i yae raapu tea. ");
INSERT INTO kew_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Gore aa medame lotu adana bi madaa yaa madaa makuaa tea-daare Gote go ada-para pia-ga Gote-na bi madaa page nipu agaa tea. ");
INSERT INTO kew_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Gore aa medame so yaa madaa makuaa loa tea-daare gore Gote so-para pirua nipu pia reke-para tepe. ");
INSERT INTO kew_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Nimi rekena agaana tisaanu-para Farisi aanu nimiri waru adalepape. Nimiri ora maeyae aanu pimi. Nimiri pa yabia meda-para rakia-para padi raani medaloma-para ogegepu pamu rugulu imi openalo goa pua Gote medaloma pa kateme. Goa peme pare nimimi adaa rekena agaa rayore aba gimeme. Go agaare epe kone i onaa rayo mea rumaawa odo omape kona mea sua kone waru rulaatepa. Rekena agaa saapirua Gote adalima konere nasalepape. ");
INSERT INTO kew_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nimimi onaa medaloma pora waatalo peme pare nimi aba ini rubu pi aa pimi. Nimimi oge puna meda ipa-para adobaawa pia rabu mena kamel ipa-para peme laapo rata mea noa yolaniaaya. ");
INSERT INTO kew_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Rekena agaana tisaanu nimi-para Farisi aanu nimiri maeyae aanu-ga nimimi waru adalepape. Nimimiri pa kap-para plet lapona amaa-nane yogane radepeteme pare ru-nane pea amulu pa puaaya. ");
INSERT INTO kew_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nimi Farisi aanuri ini rubu pi aanu pimi. Aba ripiare mo kap-na ru-nane radepealimiri yogane page epeaalia. ");
INSERT INTO kew_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Nimi rekena agaa tisaanu-para Farisi aanu nimiri waru adalepape. Nimiri maeyae aa-rupa pimi. Nimiri matmat-na pepena amaa-nane yaako pi pepeminua pimi. Nimimi amaa-nane pepenare epe-rupa peme pare no ru-nanere aa uni-para wae pugu pi oyaeyae adaapu ia-rupa pimi. ");
INSERT INTO kew_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nimiri apo matmat nona piane pirua amaa-nane nimi epe-rupa pimi. Pa onaanumi nimina yogane ademe raburi nimiri epe aa kone imi pare nimina robaa-para ora agaa rasape kone page rulatabea. ");
INSERT INTO kew_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Nimi rekena agaana tisaanu-para Farisi aanu nimiri waru adalepape. Nimiri agaa laapo ne aa-rupa pimi. Nimimi mo Gote-na agaa lakene aanuna matmat apedaa epe-rupa wariaawa amaa-nane pepena waru paeme. ");
INSERT INTO kew_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Goa pua nimimi gupa teme: Abade niaana akuanu raapu pirisima-rupa yaalo niaame mo Gote-na agaa lakene aanu natu maomaawa nimu naraba misima teme. ");
INSERT INTO kew_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Go agaa teme rabu nimi Gote-na agaa lakene aanu tu maomape aanuna ruru pimi-daa teme. ");
INSERT INTO kew_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Gore nimimi nimina akuanuna kone mua aba pisimi-a wala peme. ");
INSERT INTO kew_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nimiri wae paakame madini sinu pimi. Gote-me koso agaa tea raburi nimimi akea pua mada gimoa wae naaku-para mada napiralimi ya? Dia, wae yoto mu piralimi. ");
INSERT INTO kew_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Goa pea-ga nimimi pagalepape. Neme Gote-na agaa lakene aanu-para kone makuaae aanu-para Gote-na agaa lakene tisaanu-para rayo nimi piri-para mea rapalua. Goa palua pare medalomare nimimi tu maomalimi. Medalomare repena polopea mada nil-mi talimi. Medaloma mo nimina lotu ada-para repena unimi talimi. Medalomare nimimi adaare meda-para rata moneaawa adaare rado-para rata mea palimi. ");
INSERT INTO kew_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Goa palimi-pulu epe-rupa pirape onaanuri nimumi tu maomasimide-ga to madaare wae yoto rayo mealimina. E, gore epe aa Abel pirisa rabu tu maomaniaama ipuare Berekia-na si Sekaraia-me epe tu maoma kiritisimide madaare wae yoto mealimina. Go aa-na siri aba lotu ada-para pirua aana reke madaa re-para pirua nimina piaanu epa rumaalia. ");
INSERT INTO kew_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Gore neme nimi ora lagialo: Apo tu maomaasimide onaanu page abia go rabu pimi onaa nimuna wae kedaa rialimi sa. ");
INSERT INTO kew_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerusalem onaanu-ya. Nimimi Gote-na agaa lakene aanu tu maomaeme Gote-na Mea Rapae Aanu page aana-me teme. Ora rana adaapu neme nena sinu mea kirita sua upitalo pe. Gupa yaa kutame nipuna sinu nipuna popa-para mea kirita mapiraatade-rupa pe. Goa pe pare nimimi ni gimamede. ");
INSERT INTO kew_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nimimi pagalepa. Abiare nimina adaare pa ainalo gimalua. ");
INSERT INTO kew_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","E, gore neme nimi gupa lagialo: Gore nimimi ni wala na-adalimi pare nimimi orope gupa teme: Gote-na Aa Mudu-na bi meape aare nipu ora epe ta teme sa. ");
INSERT INTO kew_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu nipu lotu ada-para pirua amaa-nane pisa raburi nipuna disaipel aanu nipu mo lotu robene-rupa mea waatalo pisimi. ");
INSERT INTO kew_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Go rabu nipumi nimu agaa gupa lakesa: Nimimi go epe lotu ada waru adalimina. Neme nimi ora lagialo: Aana gome pubaa yaadare ora padane napubaalia pare rayo kilipi rubalimi sa. ");
INSERT INTO kew_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu nipu so Rudu Oliv madaa pirina disaipel aanu nimu padane pawa ipua gupa epa simi: Go kedaare aa-rabu epalia yapae lo agaa misimi. Ora aba ripiare ake aba epalia-daa niaame adalima pae? Go adalima raburi nena epape di-para su yaa lapo mea perekealia rabu niminaalima simi. ");
INSERT INTO kew_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Gore Yesu nipumi nimu gupa lakesa: Pa aa medame nimi makiraalia nimimi nipu aba waru adalepape. ");
INSERT INTO kew_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Aa adaapupe ipua nina bi madaa nimumi gupa teme: Niri Gote-na Mea Rapae Aa i-pulu loa onaa adaapu ora makiralimi. ");
INSERT INTO kew_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Go raburi nimimi eaea marekaape agaa-para yada ora pape remaa pagalimi pare wala makirape agaa adaapu natapape. Go yaenu rayore aba epalia pare su yaa perekeape yapi diri go rabu abi naepalia. ");
INSERT INTO kew_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Goa puare ruru medamere ruru rado radonu raapu yada palimi. Go page gavman-na adaa su rado radonu raapu yada palimi. Go rabu su rayo-parare reae adaa paboa su eto palia. ");
INSERT INTO kew_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Go oyae rayo aba ripia epalia pare oname naaki maditalo masaa nalade-rupa palia. ");
INSERT INTO kew_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Go raburi nimumi nimi aditalo mua kedaa gua radaa manaawa nimi tu maomalimi. Go raburi nina agaa waru page onaa rayo nimiri kone wae salimi. ");
INSERT INTO kew_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Go raburi onaa adaapumi nimuna epe kone rulae yae gimoa wala nimuna amenu ratu yawoa iaanu ta pea aa wala piralimi. ");
INSERT INTO kew_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Go rabu makirae Gote-na agaa lakene aa adaapu iti ralapae aa-rupa ipua onaa adaapu makiralimi. ");
INSERT INTO kew_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Go raburi wae yaenu adaapu su rayo-para opaama epalia-pulu onaa adaapu nimuna epe raana omape kone mada gimalimi. ");
INSERT INTO kew_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Goa paliade raburi aa medame puri paboa kone rulaawa waru piraliare gore su yaa lapo dia yalia rabu epe-rupa kagaa piraama laama palimi. ");
INSERT INTO kew_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Goa pea pare Gote-na Epe Agaare su rayo-para lakelo kiritalimi. Mo onaa rayome pago kiritinaloa go rabu su yaa lapo dia yalia. ");
INSERT INTO kew_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Gore orope wae pugu pi yaeme epe lotu ada-para rekaina adalimi. Abade Gote-na agaa lakene aa Daniel-me saa-rupare epa rekalia. Aa medame go agaana re pagali-daare waru pagape. ");
INSERT INTO kew_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Go raburi Judia su-para piri onaa rayore so rudu aana apedaa-paranu pogola pulupape. ");
INSERT INTO kew_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Gore onaanu nimuna ada gaa-nani piralimi pare nimuna ada ru-nane i yaere namula pulupape. ");
INSERT INTO kew_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Go page onaanuri maapu-para pitimiri nimina mamina wala namula pulupape. ");
INSERT INTO kew_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Go raburi ona nogo naaki adu nala pirinu-para naaki padaa piri onanu-para gore nimu madaa ora odo waru palia. ");
INSERT INTO kew_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Yapare Kitu Pirape Yapi diri wae kogore yai rabu nimi mada naepalia-ga nimimi Gote yaaloa beten waru tapape. ");
INSERT INTO kew_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Go raburi kedaa ora adaape opalia. Gore su kagaa warisa rabu epa-mama pua abia page kedaa gupiane meda naepea. ");
INSERT INTO kew_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Goa pea pare Gote-me abade go di rudupu namea sula pisa yaalore onaa rayo ora omola pisimi. Pare Gote-me nipuna kone mapiraae onaa nimu wae kone mealimi-pulu go yapi di marudu yaalia. ");
INSERT INTO kew_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Go raburi aa medame nimi go agaa lagialiare adalepa: Gote-na Mea Rapae Aa go pia tea page mogo-nane epa pia tea page nimimi nipuna agaa madaa kone narulaatepape ");
INSERT INTO kew_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Go rabu yaa agaa lape aa Gote-me mea rapaaria loa adaapu opapalimi. Go rabu nimumi page napiaa-nu kogono pua oyae epape-rupa rado rado adaapu palimi. Goanu nimumi mada palimi pare Gote-me nipuna mapiraae onaa makiralimi. Goa yapare mada dia. ");
INSERT INTO kew_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Gore neme nimi aba lagede-ga waru pagalepa. ");
INSERT INTO kew_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Goa pea-pulu pa onaanumi nimi gupa lagialimi: Mo onaa napiri su-para aaya-ga teme-daare go su-para napulupape. Goa page nimumi mogo kaleda yaa teme-daare nimuna agaa napagalepape. ");
INSERT INTO kew_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Di, Gote-me Onaa Raapu Pirape Aa-na Si epenatea rabu ari-yapa naare ipula-nane pabola-nane popea-rupa aipapulu epalia. ");
INSERT INTO kew_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Gore aba ome onaana yogane i-parare yaa itaayamanu epa kiritalimi. ");
INSERT INTO kew_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Go rabu adaa kedaa aba pupu kiritinaloa aipapulu naare udunua ribaa yabalia. Goa pua akua mada naraalia. Goa pua ubanu page yaa-para gimoa lopalia. Goa puare yaa-para ae puri pane oyaenu page mada eto eto palia. ");
INSERT INTO kew_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Go raburi Onaa Raapu Pirape Aa-na Si epape diri so yaa madaa oyae adenalo palia. Goa pua makuaamonalo. Go raburi go su amaa onaa ruru rayome re waru teme pare Onaa Raapu Pirape Aa-na Siri so yaa moae yaako yaa madaa awoa ipua nipu adaa puri paa raapu epalia. ");
INSERT INTO kew_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Goa pua biugel berona agaa pagenaloa nipuna ensel-nu mea rapalia. Goa palia raburi nipuna mada mi onaanu mea kiritalimi sa. Kiritalimi rabu su yaa lapo yarua aawaaya-nane pamua nipuna ruru onaanu epa mea kiritalimi. ");
INSERT INTO kew_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Nimimi repena fik ini madaa kone mealepape. Nipuna palaa-para ipaa rubia yo kagaa pulu rubea raburi gore abia pani palia kone imide. ");
INSERT INTO kew_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Go raburi oropere apo oyae rayo adalimi rabu epaliade yapi di ora re-para managolaawa aaya sa. ");
INSERT INTO kew_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Gore nimi waru pagalepa. Go pima onaare abi naomalimi pare go oyae rayo openaloa nimimi adalimi. ");
INSERT INTO kew_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Go su yaa lapore mada dia yalia pare nina agaare oro yaalo kagaa pa salia sa. ");
INSERT INTO kew_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Aa medame page go Kitu Pirape Yapi di page namakuaaeme. Yaa-para pimi ensel-numi page ni page go yapi di na-adema. Dia, niaana Aapa padane nipumi agu raapo go di saapia. ");
INSERT INTO kew_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Abade Noa nipu raapu pisimi onaanumi risimi kedaare nona piane wala Onaa Raapu Pirape Aa-na Si su amaa epaluade rabu go-rupa opalia. ");
INSERT INTO kew_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Abade go aa Noa pirisa rabu ipa abi narubisa rabu nimumi ogere waima yawo ipa no ona rumaa goa paa-mama pisimi. Go page Noa nipu ipa ipunu ru-nane odobaawa pirina goa pa pala pirisimi. ");
INSERT INTO kew_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Goa puare nimu naniminae pirina ipa roa onaa rayo tabesa. Go-rupa Onaa Raapu Pirape Aa-na Si epaluade rabu page goa palia. ");
INSERT INTO kew_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Epalua raburi aa lapo maapu-para kogono pala pirina pare Gote-me meda mua medare gimalia. ");
INSERT INTO kew_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ona lapome page bret wariala piralipi Gote-me meda gimoa meda mealia. ");
INSERT INTO kew_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Goa pea-ga nimimi kone waru su piralepape. Nimimi nimina Aa Mudu-na epaliade yapi di naniminaaeme-ga waru suruba piralepape. ");
INSERT INTO kew_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nimimiri go agaa madaa kone mealepape. Gore nimimi paake ne aa epape yapi di niminaawa suruba pimi gore nimimi u napati rabu page mada suruba piralimi? Goa puare mo paake ne aame go aana ada ru-nane mada naodabalia. ");
INSERT INTO kew_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Goa pea-ga nimimi page Onaa Raapu Pirape Aa-na Siri aa-rabu epalia palo maarea-ga nimimi page waru surubalepape. Gore nimimi namakuaae rabu epalua. ");
INSERT INTO kew_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Gore epe kogono pi aamere epe kogono agu pea? Go piane aare nipuna adaa aame nipuri nipuna kogono naakinu rado surubenaloa nipu surube aa mapiraaya. Goa puare nipumi nimuna eta nape yapi di rabu eta rumaainalo mapiraasa. ");
INSERT INTO kew_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Orope mo aa wala epalia rabu mo nipuna kogono naakimi mo kasade kogono agaa-para aalia rabu raaname waru omalia sa. ");
INSERT INTO kew_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Gore neme ora nimi lagialo: Mo aa adaame go kogono naaki oyae rayo surubenalo aa mudu mapiraalia ");
INSERT INTO kew_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pare mo kogono naakimi wae kogono pu piralia rabu aa adaare abi aipapulu naepalia kone ia. ");
INSERT INTO kew_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Go kone sua nipumi nipuna kogono naaki yagonu pamu tua nipumi puri pane ipa pamu noa aanu raapu aasa. ");
INSERT INTO kew_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Goa puare kogono naakimi nipu naniminae pa aaina epa opopalia. Goa palaina nipuna aa adaa ora meda aipapulu epalia. ");
INSERT INTO kew_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Epalia rabu aa adaame go kogono naaki raimi tua teana mo makirae aanu raapu mapiraalia Go-nane piruare nimuna kidipaa regepe no re lo wae-rupa piralimi. ");
INSERT INTO kew_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Orope Gote-na Surubae Suri gupiane epalia: Ona inumakua 10-pela pirisimi raburi aa meda ona pena rumaatalo epalia remaa pagesimi. Gore pagesimi-pulu mo onaanumi 10-pela lam-nu mua nipu rumaape eta yawe-para epolalo pora-nia madaari pisimi. ");
INSERT INTO kew_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Goa pisimi pare mo ona supuri nimu maeyae pirisimi pare ona supuri epe kone isimi. ");
INSERT INTO kew_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Gore mo maeyae onanumi lam-re mea ipisimi yapare alopape wel namea ipisimiya. ");
INSERT INTO kew_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pare mo nimu kone waru saapirisimi onanuri nimuna lam-para alopape wel raapu managolaawa mea ipisimi. ");
INSERT INTO kew_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Mo ona rumaape aa abi aipapulu naipisa-daa ado pirua nimuna ini-para u ipisa-daa umi kole male lapirae sua u patisimi. ");
INSERT INTO kew_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Go rabu ribaare ruma rumane pirisimi raburi mo 10-pela oname gupa pagesimi: Mo ona rumaape aa go epea-ga mo pora repaa-nini madaama pulupa simi. ");
INSERT INTO kew_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Gore mo ona inumakua rayo rekoa nimuna lam managola sua pirisimi. ");
INSERT INTO kew_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Goa pua mo kone waru na i onanumi mo kone waru i onanu-para lalo: Niaana lam udinitalo pia-ga nimina wel meda gialepa simi. ");
INSERT INTO kew_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Gore mo kone pa sae onanumi nimu agaa gupa lakesimi: Dia, go wel-re nimi page niaa page mada dia simi. Goa pea-ga nimina stua-para pua puaa kabalepa simi. ");
INSERT INTO kew_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Gore mo onanu nimu mo stua-para wabola kabola isimi raburi mo ona rumaape aa ipisa. Gore mo ona medaloma managola pirisimi rayore mo aa raapu ona rumaatalo yawe ogere nola pua pora gaape garulabaawa pirisimi. ");
INSERT INTO kew_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Orope mo ona inumakua medaloma wala pora gaape epa tua lalo: Aa adaa, niaa epomona pora loba simi. ");
INSERT INTO kew_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Gore nipumi nimu gupa lakesa: Nimiri aa-para pirua epame? Neme nimi ora na-ade maarea sa. ");
INSERT INTO kew_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Go remaa lakeloa Yesumi onaanu-para lalo: Goa pea-ga nimimi waru surubalepape sa. Nina aba epape diri ribaa epalia paalo aebo epalua paalo ni na-ade sa. ");
INSERT INTO kew_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Gore Gote-na Surube Suri gupiane yaade lo remaa lagialo: Aa meda su rado-para pora pamula polalo palia pare nipuna kogono naakinu-para ipulupa loa sana oyae rayore nimimi surubalepape lo laketea. ");
INSERT INTO kew_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Gore nipumi mo naakinuna puri ado kone ado pua nipumi nimu oyae rumaa katea. Gore aa medare mone 20,000 kina rumaa kasa. Goa pua aa meda 8,000 kina kasa. Wala aa medare mone 4,000 kina rumaawa kasa. Nipumi nimu mone go-rupa kaloa nipu pisa. ");
INSERT INTO kew_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Gore mo mone 20,000 kina misade aame kogono aipapulu pa amaa puare wala nipumi ode mone 20,000 kina meda sania saaba pirisa. ");
INSERT INTO kew_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mo aa meda 8,000 kina misade aame kogono pa amaa pua ode mone 8,000 kina meda misa. ");
INSERT INTO kew_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pare mo aa meda nipumi mone 4,000 kina misade aa adaa mone mua su naaku roboa pua paga isa. ");
INSERT INTO kew_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Gore mo adaa aa nipu adaalu pirua sana nipuna kogono naakinu mone adaapu kasa-pulu nipu raapu agaa maredepoya laa-mama pulalo kone sua ipisa. ");
INSERT INTO kew_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Gore abade mone 20,000 kina misade aa ipuare nipumi ode mone 2,000 kina mua nipumi epa lalo: Aa adaa, abade neme ni mone 20,000 kina giside pare neme mone yoto kogono pua wala go mone-na yago ode meda 20,000 kina apo meawa sa. ");
INSERT INTO kew_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Gore nipuna aa adaame nipu gupa lakesa: Epe ta-ga nere ora nina epe kogono naaki-ga neme epe kogono paena sa. Neme abade oge oyaesinu page waru surubaena-daa neme nere oyae adaapu surubainalo pi sa. Ne ipu saa ni raapu pedo pu pirapana. ");
INSERT INTO kew_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Gore mone 8,000 kina kasade aa page ipua goa epa sa: Aa adaa, neme page bisnis kogono pa amaa pua ode mone 8,000 kina profet meawa sa. ");
INSERT INTO kew_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Gore nipuna aa adaa me nipu gupa lakesa: Epe ta-ga nere ora epe kogono naaki yana sa. Neme abade epea pua kogono waru surubisina. Neme abade oge oyaeyaesi waru surubaena-daa abia neme oyaeyae adaapu surubaina kone salo. Goa pea-ga ipu saa lapo pedo pu pirapana. ");
INSERT INTO kew_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Gore mo mone 4,000 kina misade aa page ipua gupa sa: Aa adaa, neme nere aba makuaayo. Nere puri pane aa yaade. Aa meda nipuna sae maapu-para neme eta wai aawa nisi. Go page su rugi meda-nane aa medana poae etare neme madua nisi. ");
INSERT INTO kew_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Goa pea-daa neme paala omoa nena mone su naaku roboa paga isu. Abiare nena mone go ada sa. ");
INSERT INTO kew_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Gore nipuna aa adaame nipu-para lalo: Nere kogono naaki wae yaana. Nere ki aa raakepene aa yaana. Gore ora abade neme aa medame poae e maapu-para eta awesude lae ya? Go page aa medame nape eta neme madia yarina sa. ");
INSERT INTO kew_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Gore nena mone-re mo benk ada-para akeane namea epae ya? Goa pula pisi yaalore ni wala ne piri ipua mone ode medaloma raapu mone wala gula pae. ");
INSERT INTO kew_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Gore nimimi mone adaapu gisude aanu wala mua mo mone 40,000 kina mi aa pua kala sa. ");
INSERT INTO kew_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Gore onaa medalomame oyae saapitimi-daare gore neme wala medaloma sania katoa sa. Go page onaa medalomame oyae ogepusi saapiralimiri nina wala rayo epa mealua sa. ");
INSERT INTO kew_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Go kogono naaki waere ora su ribaane-para pena ratasaatepa sa. Gore nipuna kidipaa regepe no re lo piralia sa. ");
INSERT INTO kew_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Oropere Onaa Raapu Pirape Aa-na Simi ensel-nu raapu epalia raburi epe paa mea ipua king siaa madaa pirua epalia. ");
INSERT INTO kew_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Go raburi su amaa piri onaa rayo epe makiritaawa robo lapo rumaalua. Go rumaaliade konere sipsip meme menanu mo surube aanumi robo lapo rumaawa meda-nane meda-nane palia. ");
INSERT INTO kew_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Goa puare nipumi sipsip menanuri nipuna ora ki-nane mea mapiraaware mo meme menanuri koya ki-nane mea ma-aalia. ");
INSERT INTO kew_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Goa palia-pulu mo aa mudu nipuna popo ki-nane pitimide onaanu-parare gupa tea: Nimiri nina Aapana epe raba meape kone aba meamena-ga ipulupa tea. Abade su yaa lapo pena warisa rabu Aapame nimina Surube Su mea sasa-ga nimimi epa mealepa tea. ");
INSERT INTO kew_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Gore abade ni ipa eta nalame omesu rabu eta ipa gisimide toa. Niri kimisu pisude rabu nimina ada-para lamua pisimide toa. ");
INSERT INTO kew_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ni mamina dia sade raburi nimimi mamina gisimide toa. Ni yaina omisude raburi nimimi ni raba misimide toa. Ni kalabus ada patisu rabu ni adola ipisimide toa. Nimimi goa pisimi-pulu nina Surube Su mealimina toa. ");
INSERT INTO kew_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Go raburi mo epe kone i onaanumi gupa teme: Aa Mudu, aa-rabu ne reame omesi rabu niaame ne eta gisima ya? Ne aa-rabu ipa nalame omesi-daa niaame ipa no gimisima ya teme? ");
INSERT INTO kew_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Gore aa-rabu ne pora kimisu-para pamiside rabu ne niaana ada-para lamua napamisima ya? Go page ne aa-rabu mamina dia yaade rabu niaame mamina gisima ya? ");
INSERT INTO kew_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ne yaina omesi rabu page ne kalabus ada patisi rabu page niaame aa-rabu adola ipisima ya? ");
INSERT INTO kew_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Go rabu aa mudu king-mi agaa gupa abutea: Neme nimi ora ria lagialo. Gore nimimi nina Aapa amenu-para pisimide aanuri gore nina ame ogenu-para pisimide. ");
INSERT INTO kew_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Goa lo kirituare neme mo koya ki-nane piralimidenu gupa laketoa: Nimiri alupape onaanu nimi neme na-ade-ga pane pulupa toa sa. Goa pua repena naudini-para palimana. Go repena sulaare Gote-me Satan-para nipuna enselnu-parana managola saaya. ");
INSERT INTO kew_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Gore abade nimimi ni reame oma pirano eta ipa oyaeyae nagisimide toa. ");
INSERT INTO kew_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ni pora kimisu piri aa ipisude rabu nimimi ni nimina ada-para nalamua pisimide toa. Ni mamina dia sa raburi ni naraba misimide toa. Ni yaina omesu rabu page kalabus ada patisu rabu ni nasurubesimide toa. ");
INSERT INTO kew_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Go raburi nimumi page nipu-para gupa laketeme: Aa Mudu, aa-rabu ne reame oma piraina adesima pae teme. Ne eta ipa nalame omesi page mamina dia sa page yaina omesi rabu page kalabus ada patisi page niaame aa-rabu naraba misima ya? ");
INSERT INTO kew_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Go raburi Aa Mudumi agaa gupa abutua: Gore neme ora nimi lagialo toa. Nimimi abade rolo rolo piramede ame baaninu naraba misimide-ga go raburi nimimi abade ni page naraba misimide toa. ");
INSERT INTO kew_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Goa pe-pulu go onaa rayore repena sulaa-para pua pirua oro yaalo radaa no piralimina. Pare mo epe ona rayore oro yaalo epe-rupa piralimi toa sa. ");
INSERT INTO kew_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Go raburi Yesu nipumi go agaa rayo lo kiritua sana nipumi nipuna disaipel aanu-para gupa lakesa: ");
INSERT INTO kew_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Gore nimimi niminaaeme. Go Pasova yawe nape diri wala yapi laapo dia yalia rabu salia sa. Go rabu Onaa Raapu Pirape Aa-na Siri repena polopea madaa talimi rabu omalia pare wala rekalia sa. ");
INSERT INTO kew_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Go raburi Gote-na miru irae aa mudunu-para mo Juda aanuna aa mudu-para nimu Gote-na miru irae aa Kaiafas-na ada-para pua kiritasimi. ");
INSERT INTO kew_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Goa puare nimumi kudiri pu Yesu nipu ripinaawa tu maomaatalo yada robesimi. ");
INSERT INTO kew_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pare wala nimumi lalo: Gore Pasova yawe yapi di rabu niaa go napamina-ga mo onaanumi niaa raapu yada marekalimi simi. ");
INSERT INTO kew_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu nipu Betani su-para pua yakimi ti yaina maperekeae aa Saimon-na ada-para pua pirisa. ");
INSERT INTO kew_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Go raburi Yesu eta nala pirisa pare ona meda nipu piri-para ipisa. Go onamere aana-me warini botol-para kaapu ti wabola pira palae meda mea ipisa. Go wabolana yotore ora oyae adaapupeme kabeme. Yesu nipu reke madaa eta no pirisa raburi go oname Yesuna aaluna madaa koyasa. ");
INSERT INTO kew_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Go raburi disaipel aanumi ratu waru yawoa nimumi lalo: Go wabolare akeane pa koyaate pae? Mo nipuna yotore ora adaape yaade-ga ake pea-daa mone rubeta? ");
INSERT INTO kew_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Pare niaame go wabola yoto mealima raburi ora oyae adaapupe mua medaloma onaa riabo naraanu rumaa katema simi. ");
INSERT INTO kew_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesumi nimu adoa nimu gupa lakesa: Gore akeane go ona ratu yawaleme? Nipumi abade ni madaa ora epe kogono pisade. ");
INSERT INTO kew_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Oro yaalo onaa naraanu raapu padane-para pitimi pare niri nimi raapu-daa oro yaalo napitima. ");
INSERT INTO kew_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Go oname ni mada wabola koyaariaadere gore nipumi nina ro matmat-para rogaalimi managolaasade sa. ");
INSERT INTO kew_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Waru pagalepa. Ora su rayo-para epe agaa laketa palimi raburi go oname ni madaa pia page teme-ga nipu madaa kone meamina. ");
INSERT INTO kew_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Go rabu disaipel aa 12-pela aa-na meda nipuna biri Judas Iskariot nipu Gote-na miru irae aanu piri-para pisa. ");
INSERT INTO kew_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Goa pua nipumi nimu-para pua lalo: Neme Yesu nimi mea gialua-ga nimimiri ni ake gialimi pae sa. Go agaa lakesa rabu nimumi mone silva ini 30 kasimi. ");
INSERT INTO kew_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Goa puare Judas nipumi Yesu adi katalo pua nipumi inimini pisa. ");
INSERT INTO kew_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Gore Bret Kaapuni Nape yapi di raburi disaipel aanumi Yesu nipu piri-para ipu lalo: Niaame Pasova nape etare aa-para mea managola salima ya? ");
INSERT INTO kew_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Go rabu nipumi lalo: Nimi mo ada re-para pua aa meda piraliade-para gupa laketapape: Tisaa-me lalo: Nina eta nape diri aba rudu yaana. Goa pea-ga nena ada-para eta Pasova nola epalualo pua lakelatepape. ");
INSERT INTO kew_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Gore disaipel aanumi Yesuna agaa pagoa Pasova nape eta mo ada-para aba managola sasimi. ");
INSERT INTO kew_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Gore ora aebore mo disaipel aa 12-pela Yesu raapu reke madaa eta nolalo pirisimi. ");
INSERT INTO kew_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nimu eta nalalo pirina Yesumi lalo: Neme nimi ora ria lagialo: Nimina rikiraana pia aa medame ni mua iaanuna kina mea katea sa. ");
INSERT INTO kew_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Goa sa rabu disaipel aanuna kone-para kedaa waru pisa-pulu nimu padane padaneme goa simi: Aa Mudu, ora ne madaa agaa lae palo loa nipu agaa gupa misimi. ");
INSERT INTO kew_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Pare nipumi go-rupa lakesa: Aa meda ni raapu plet madaa-para ki salipa. Go aamere ni madaa kawae madua ni tape aa piralia sa. ");
INSERT INTO kew_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Gore Onaa Raapu Pirape Aa-na Siri Gote-na agaa i buk-mi ta-rupa ratua yawalimi sa. Goa palimi pare Onaa Raapu Pirape Aa tinalo kawae madini aa padanere ora odo waru pea sa. Go aare nipuna agimi aba namadita pisa yaalore ora epe ta pisa sa. ");
INSERT INTO kew_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Gore kawae madini aa Judas nipumi gupa lakesa Tisaa-ya, Ni-para lae? Yesumi lalo: Nena lae sa. ");
INSERT INTO kew_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nimu eta nala pirina Yesu nipumi bret mua piribia Gote-para ora pi loa sana nipuna disaipel aanu kasa: Goa pua nipumi lalo: Gore nina to-ga mea nalepa. ");
INSERT INTO kew_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nimumi nala pirina ipa wain kap-para pira palae mua sana Gote-para ora pi loa sana nimu kaloa lalo: Nimi rayome mea nalepa. ");
INSERT INTO kew_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Gore nina yaapimi Gote raapu meda-para pogatu pirapena wae yaenu mea rubenalo koyaato. ");
INSERT INTO kew_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Abia neme nimi lagialo: Wain ipare abia wala nanalima pare nina Aapana surube su-para nimi raapu kagaa wain namina. ");
INSERT INTO kew_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Goa loare nimumi yaasa meda aba loa simina amaa pua su Rudu Oliv-nane pisimi. ");
INSERT INTO kew_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yesumi nimu-para lalo: Abia go ribaa nimi rayome ni gimoa pogola palimi sa. Go kone madaare Gote-na agaa i buk-mi gupa tu ia: Gote-na sipsip menasi surube aa tu maomalia rabu sipsip rayo pu pa yabalimi sa. ");
INSERT INTO kew_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pare Gote-me ni matmat-para wala marekaalia rabu Galili su-para ni aba riri-nane popalua sa. ");
INSERT INTO kew_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Gore Pita-me Yesu agaa gupa lakesa: Go aa rayome ne mada palia adoa gimalimi pare ni padaneme nena gimalua sa. ");
INSERT INTO kew_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Gore Yesumi nipu-para lalo: Neme abia go ribaa yaa kuta agaa abi narekaina neme ni na-ade rana repo te. ");
INSERT INTO kew_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Gore Pita nipu-para lalo: Niri ne raapu padane-para omalipa pare neme ne nagimalua. Goa sa raburi disaipel aa rayo ni goa agu simi. ");
INSERT INTO kew_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesu nipuna disaipel aanu raapu nipu Getsemani maapu-para pisimi. Goa pua nipuna disaipel aanu-para pawa piralepape sa. Ni mogo-para pua beten ta pulu sa. ");
INSERT INTO kew_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Gore nipu raapuri Pita-para Sebedi-na si lapo-para nimu pisimi. Go raburi nipuna robaa-para kedaa pua nipu ora waru odome omesa. ");
INSERT INTO kew_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Gore Yesumi nimu lakesa: Nina kone-parare ora kedaa waru pua ni ora omape yaata-ga nimi go-pare pirua ni adaba pitapape. ");
INSERT INTO kew_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Gore nipu ogesi-daa pua nimuna ini agaa madaa pua lopoa beten gupa sa: O, nina Aapa, neme ni mada raba mealia-daare neme go kedaa pi kap meape. Pare nena kone ratua pape. Nena koneme pea pape. ");
INSERT INTO kew_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Gore nipu wala mo disaipel aa 12-pela piri puare nimu aba patisimi ya. Go rabu Pita goa lakesa: Nimimi niri naare ini ogesi-daa mada na-ado pitimi ya? ");
INSERT INTO kew_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Gore ni wae yaeme ko tinalo epalia-ga beten loa nimi waru adoba piralepape. Nimina konemere raaname omeme pare yoganemere gimi omea. ");
INSERT INTO kew_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nipu wala rana laapo pua beten gupa pua sa: Nina Aapa, go kedaa meape kap mea pu kone salo pare neme nape tedere nena raaname palia agu paina. ");
INSERT INTO kew_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nipu wala ipuna disaipel aanu epa adesa pare nimuna robaa-para kedaa pisa-daa wala pa pata isimi. ");
INSERT INTO kew_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nimu pa u patae ina pua beten rana repo wala pua sa ");
INSERT INTO kew_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Goa pua nipuna disaipel aanu piri-para wala ipua lalo: Nimiri abade ora pa pirua kitu meme? Adalepa. Abiare Onaa Raapu Pirape Aa-na Si nimumi wae aanuna ki-nane mea kateme. ");
INSERT INTO kew_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Baina nimi rekalepa. Yada lore aanu ni re-para mea katalo go epea-daa. ");
INSERT INTO kew_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu nipu agaa pa lala pirina disaipel aanu 12-pela nimuna aa padane Judas nipu ipisa. Go ipisa rabu onaa adaapu nipu raapu ipua simina nimumi rai kutu-para repena uninu-para rulubaawa ipisimi. Gore nipuri Gote-na miru irae aa mudunu-para Juda aanuna aa mudunu-para page nimumi mea penaasimi. ");
INSERT INTO kew_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Go kawae madini aa nipumi mo iaanu-para gupa palua-ga adalepape lo kudiri pi kone gupa lakesa: Neme aa meda-para nunu toare gore Yesu nipu-ga ripinaatepape sa. ");
INSERT INTO kew_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Goa loare nipu aipapulu aloma pua sana: Tisaa, epe-rupa piraina epa loare nipuna ini agaa-para pua nunu sa. ");
INSERT INTO kew_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Gore Yesumi nipu gupa lakesa: Adami aa, mo nena pulalo epae kogonore abi aipapulu pape. Go raburi nimu ipuare Yesu nipu epa ripinaasimi. ");
INSERT INTO kew_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Aa meda Yesu nipu raapu pirisipi aamere nipuna kimi rai kutu yolo risa. Goa pua nipumi mo Gote-na miru irae aa-na kogono naakina aane pona tisa. ");
INSERT INTO kew_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Goa pisa raburi Yesumi nipu goa lakesa: Neme go naaki nena rai kutu wala abi nipuna ada-para madia sa. Aa rayome rai kutu raapu yada palimiri gore rai kutumi aa rayo nabalia sa. ");
INSERT INTO kew_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Gore nimi naniminaaeme. Neme nina Aapa yaatoade rabu nipumi yada pape ensel-nu gupa 12-pela ruru rabuniaae epenala toare mada pagola pea. ");
INSERT INTO kew_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pare neme goa paluade raburi Gote-na buk madaa ti agaana re mada naepalia. ");
INSERT INTO kew_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Go rabu Yesumi onaa adaapu gupa lakesa: Nimi ni mula ipuare nimina rai kutu-para repena uni ripinuare nimimi paake ne aa meda mula epame? Oro yaalo ni lotu ada-para pirua neme onaanu agaa mogeaarude pare go rabu nimimi ni naepa misimide. ");
INSERT INTO kew_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Goa pea pare mo Gote-na agaa lakene aanumi buk madaa aba tisimi-rupa ora epenalo mada palimi. Go rabu disaipel aa rayome Yesu gimoa nimu pogola pisimi. ");
INSERT INTO kew_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yesu nipu epa ripinaawa mea ipisimi aanumiri Gote-na Miru Irae Aa mudunumi Kaiafas-na ada-para mea pisimi. Go ada-parare rekena agaana tisaanu-para kone makuaa aa medaloma-para nimu padane kiritaba pirisimi. ");
INSERT INTO kew_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita nipu Yesu rata mea pisa pare ogesi-daa mo-pare puare Gote-na miru irini aa-na epe pokaalo ada ru-nane pua pirisa. Nipu pua odobaawa mo surube plisman-nu raapu pua pirua mo nimuna pimi-a adolalo pirisa. ");
INSERT INTO kew_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Go rabu Gote-na Miru Irae Aa mudunu-para kaunsil rayo-para nimumi Yesu madaa pa amaa makirae agaa mulalo Yesu nipu orope tu maomaatalo pisimi. ");
INSERT INTO kew_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Goa pisimi rabu aa adaapu epa kiritaawa makirae agaa epa simi. Goa pisimi pare nipu tu maomape agaa meda nasimi. Goa pisa pare orope aa lapo ipisipi. ");
INSERT INTO kew_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Gore nipumi epa lalo: Go aamere Gote-na epe lotu ada lakepe ruboa wala yapi repome wala palua laasimi. ");
INSERT INTO kew_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Gore Gote-na Miru Irae Aa mudu nipu reka awoa Yesu nipu agaa misa: Ne madaare agaa adaapu lo aaeme-ga nemere agaa meda mada nate ya? ");
INSERT INTO kew_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Goa sa pare Yesu nipumi agaa meda nasa-pulu Gote-na miru irini aame gupa lakesa: Neme oro yaalo pirape Gote-na bimi yaa madaa makuaa agaa mealo-ga neme agaa meda niaa lagi. Nere Onaa Raapu Pirape Aa-na Si ya? Nere Gote-na Si ora ria ya? ");
INSERT INTO kew_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Gore Yesumi lalo: Neme aba apo laede pare neme wala lagiano: Abia page orope page Onaa Raapu Pirape Aa-na Si oro yaalo Gote-na popo ki-nane pirano adalimi. Gore so yaa madaa moae raapu pirua epalua rabu adalimi. ");
INSERT INTO kew_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yesumi goa sa rabu Gote-na miru irini aame nipuna mamina riripia lalo: Gore nipumi Gote madaa ero agaa ta-ga nipuna adasae aa medana agaa napagamina simi. Dia, go aare Gote madaa ero agaa ta-ga napagalepape simi. ");
INSERT INTO kew_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Gore nimimiri ake kone saleme? Go raburi nimumi gupa simi: Gore nipu ora wae aa ya-pulu nipu ora tu maomamina simi. ");
INSERT INTO kew_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Goa loare Yesu nipuna ini agaa-para sope rapiaawa tisimi. Nimumi nipu ki paarame tua nere Gote-na agaa lakene aa ya-pulu lagi. Nere aapimi tala pae simi? ");
INSERT INTO kew_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Go rabu Pita nipu ada peraana kepo ru-para pirisa pare Gote-na miru irape aa muduna kogono ona medame Pita aa piri-para ipua lalo: Ne page abade Yesu raapu so Galili su-para piraede sa. ");
INSERT INTO kew_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Goa sa pare Pita nipumi onaa rayona ini agaa madaa ni-daa dia yaade loa goa sa: Neme go lae agaare ni maarea. ");
INSERT INTO kew_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Goa loa sana nipu pua so kepona pora gaape-nane pua pirisa. Go rabu kogono ona medame nipu adoa go padane pirisimi aanu gupa lakesa: Go aare abade Yesu raapu no Nasaret su-para pirisipi. ");
INSERT INTO kew_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Gore Pita-me makirae agaa wala gupa sa: Ora yada makuaa neme go aa na-ade sa. ");
INSERT INTO kew_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Orope ogesi-daa pirua go re-para aasimi aa medalomame Pita-para gupa lakesimi: Gore nere Yesu nipuna ruru pirua nipuna adaa agaa-rupa te simi. ");
INSERT INTO kew_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Go rabu Pita-me yada madua agaa puri palo lalo: Ni ora agaa nalagialore Gote-me ni talia lalo. Go aare ni na-ade. Nipumi go agaa lo kiritinaloa yaa gulame gagara agaa sa. ");
INSERT INTO kew_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Go rabu Pita-me abade Yesumi lakesade agaa wala niminaasa: Yaa kuta agaa abi narekaina neme rana repome ni gimali lo lakelaa. Go rabu Pita nipu so amaa-nane pua re waru lo pirisa. ");
INSERT INTO kew_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Yapi lapaasa raburi Gote-na miru irae aa mudunu-para kone makuaae Juda aa mudunu-para nimumi mo Yesu tu maomaatalo yada robesimi. ");
INSERT INTO kew_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nipu puri pane opeme adia so namba wan gavman Pailat piri-para lamua pisimi. ");
INSERT INTO kew_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Gore mo kawae madini aa Judas nipumi Yesu tinalo koso loa nipu ora tu maomatainaloa adesa. Gupa adesa-pulu nipumi wala kone pereke sua mo mone silva ini 30-pela wala mo Gote-na miru irae aa mudunu-para kone waru i Juda aa mudunu piri wala mea pisa. ");
INSERT INTO kew_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Goa pua nipumi lalo: Neme aba waea pua ora epe aa tabena kabereke aba meawade pare nipu waea meda napia. Gore nimumi nipu-para lalo: Gore niaana yada dia yapare nena kogono aba paede simi. ");
INSERT INTO kew_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Goa simi rabu Judas nipumi mo mone silva ini 30-pela no epe lotu ada ru-nane ruboa sana nipu pua ope pua nisa. ");
INSERT INTO kew_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Gore mo Gote-na miru irae aa mudunumi go mone muare gupa simi: Gore aa tu maomaatalo yoto kane mone simi. Gore rekena ia-ga lotu ada-para i mone raapuri go mone nasamina simi. ");
INSERT INTO kew_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Go mone madaa agaa meda gupa robo suare go mone-mere sospen warini aanuna su kabamina simi. Go su-parare pora kimisu onaana matmat wariamina simi. ");
INSERT INTO kew_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Goa pisimi-pulu go suna bi aa yaapi koyae bi maasimi. Go suri abia page pa ia. ");
INSERT INTO kew_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Go-rupa abade agaa meda Gote-na agaa lakene aa Jeremaia-me sade agaana re-re ora go ipisa. Gore nipumi lalo: Nimumi go mone silva ini 30-pela misimi. Go mone-re mo Israel su-para piri onaanumi aa tapena kabereke mi mone sa. ");
INSERT INTO kew_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Go mone mua simina Aa Mudumi lakesa-rupa nimumi sospen warini aanuna su kabasimi. Go agaare Gote-na agaa lakene aa Jeremaia-me tu isa. ");
INSERT INTO kew_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Go rabu Yesu ora aa mudu gavman-na ini agaana rekainaloa mo gavman-na aa mudumi agaa gupa misa: Nere Juda aanuna aa mudu ya? Yesu nipumi lalo: Nena go laede sa. ");
INSERT INTO kew_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Goa sa pare Gote-na Miru Irae Aa mudunu-para kone makuaae Juda aa mudunumi pa amaa mariaawa koso lape agaa simi. Goa pisimi pare Yesu nipumi agaa meda na-abusa. ");
INSERT INTO kew_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Goa pisa-pulu aa mudu gavman Pailat-me lalo: Aa Adaa, mogo ne-para koso lape agaa go temere pagae ya? ");
INSERT INTO kew_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Goa sa pare Yesu nipumi agaa meda na-abusa rabu gavman-na aa mudu Pailat nipumi kone adaapu isa. ");
INSERT INTO kew_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Gore oro maali yaalore Pasova Ne yapi di rabu mo gavman Pailat-me kalabus ada-para pati aanu padane pane penaalala pisa. Mo amaa-nane piri onaanumi niaana go aa penaalape simi rabu go raana ratua penaalala pisimi. ");
INSERT INTO kew_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Go rabu ora aa wae meda Jisas Barabas mo kalabus ada-para pirisa. ");
INSERT INTO kew_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Onaa rayo kiritaawa pirisimi raburi gavman-na aa mudu Pailat-me lalo: Nimimi neme aapi penaalano kone saleme pa sa. Gore Jisas Barabas giano yapae Yesu nipuna bi meda Krais giano ya sa. ");
INSERT INTO kew_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Goa sa pare nipumi nimuna kone makuaa misa. Nimumi Yesu madaa udipa kone sua nipu mea kasimi. ");
INSERT INTO kew_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailat nipu koso pagape siaa madaa pirina nipuna oreme wai agaa gupa lo o ta sa: Apo epe aa madaare neme yada nalape. Neme abia ribaa upaa pua kedaa mea-daa adawa sa. ");
INSERT INTO kew_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Go rabu Gote-na Miru Irae Aa mudunu-para kone makuaae Juda aanuna aa mudunu mi onaa rayona kone makiraawa goa simi: Barabas esepea Yesu ora tu maomamina tapape lakesimi. ");
INSERT INTO kew_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pare mo namba wan gavman aa Pailat-me nimu-para lalo: Go aa lapore nimina konemere aapi penaalano ya sa? Gore nimumi lalo: Jisas Barabas simi. ");
INSERT INTO kew_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Gore gavman aa Pailat nipumi lalo: Yesu nipuna bi meda Krais-re ake pano ya? Goa sa pare nimumi puri paloa lalo: Nipu ora repena polopea mada omena tamina simi. ");
INSERT INTO kew_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pare gavman-na aa Pailat-me lalo: Akeane ya? Nipumi wae yae meda napana sa. Goa sa pare nimumi puri paloa lalo: Nipu ora repena polopea mada tamina simi. ");
INSERT INTO kew_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Gore mo Pailat nipumi mo onaanumi nipuna agaa mada napagalimi kone adesa. Nipuna konere nimumi yada marekaalimi kone isa. Goa pea-daa nipuna ki ipa-para pataawa mo onaanumi adenalo kunisa. Goa pua nipumi mo onaanu-para lalo: Go aa tu maomapere ni-daa dia sa yapare ora nimina kogono. ");
INSERT INTO kew_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Goa sa rabu onaa rayome agaa gupa simi: Go tu maomape aare niaa-para niaana nogo naakinu madaa kedaa epenawa simi. ");
INSERT INTO kew_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Gore go rabu gavman-me Jisas Barabas wala nimuna ada penaalo esepesa. Goa pua nipumi Yesu repena unimi tua repena polopeane nil-mi tinalo kasa. ");
INSERT INTO kew_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Go rabu mo gavman-na soldia aanumi Yesu nipu mua mo gavman-na surube ada-para mea pisimi. Goa puare soldia aa rayo nipu epa kutapu ma-aawasimi. ");
INSERT INTO kew_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Goa pua nipuna mamina mea kolo ruboa kane mamina mea maara laasimi. ");
INSERT INTO kew_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Goa pua ititumi raguna nipuna aalu madaa maadipaasimi. Goa pua nipuna popo ki-nane rama meda mea maripinaasimi. Goa pua nipu re-para epa pirua rumu koba pua ero agaa gupa simi: Nere Juda aanuna aa mudu yaade-ga oro yaalo epe-rupa pirape simi. ");
INSERT INTO kew_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Goa pua nimumi sope roa nipuna rimaapu mua nipuna aalu tisimi. ");
INSERT INTO kew_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nipu-para ero agaa aba loare mode kane mamina wala kolo ruboa nipuna abana mamina-nu wala mea maraasimi. Goa puare nipu repena polopeane nil-mi tula pisimi. ");
INSERT INTO kew_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nimumi Yesu lamua pisimi rabu Sairini su-para piri aa meda Saimon pora-nia madaasimi. Goa pua nimumi go aa-para Yesuna repena polopea mea raba mu riaainalo mariaasimi. ");
INSERT INTO kew_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Gore nimu puare su meda-para opapasimi. Go suri Golgo ta simi. Go bina re-re gupa: Aana aalu uni rogaae su maasimi. ");
INSERT INTO kew_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Nimumi Yesu ipa wain wae rero pi marasin raapu kasimi pare nipumi mea nadoa-ga gimisa. ");
INSERT INTO kew_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Gore nimumi nipu repena polopea madaa tuare nipuna mamina oyaeyae rumaatalo satu-rupa pu tisimi. ");
INSERT INTO kew_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Goa puare nimumi pirua Yesu adaba pirisimi. ");
INSERT INTO kew_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","So repena polopeana rugi-nanere nipuna aalu sone abade nipu-para koso lape agaa simide-rupa pepa madaa gupa tisimi: Go aare Juda aanuna aa mudu yaade tu tisimi. ");
INSERT INTO kew_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Go raburi paake ne aa laapo Yesu nipu raapu nil-mi tisimi. Goa pua paake ne aa padane popo ki-nane tua meda koya-nane tu mudiaasimi. ");
INSERT INTO kew_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Gore onaa rayo one lobasa apone lobasa pimisimi onaanumiri aalu wage wage pua ero agaa lama lobasa pala pisimi. ");
INSERT INTO kew_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Goa pua nimumi lalo: Nere lotu ada kilipia wala yapi repome ma-alua side. Nere Gote-na Si yaliare nena go-rupa raba meape. Nere ora Gote-na Si yaliare apo repena polopea mada kilipia su amaa ipu isimi. ");
INSERT INTO kew_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Goa simi rabu Gote-na miru irae aa mudunu-para rekena agaa tisaanu kone makuaae Juda aa mudunu-parame ero agaa gupa simi: ");
INSERT INTO kew_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Gore nipumi aba onaa medaloma raba mua oro yaalo epe-rupa mapiraasa-pulu nipumi nipuna bipa raba mua oro yaalo piralia. Gore nipuri Israel onaanuna mudu ya? Gore nipumi repena polopea gimoa su amaa kilipialia-daare niaame nipu madaa kone rulamina simi. ");
INSERT INTO kew_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Gore nipumi Gote madaa kone rulaawa niri Gote-na Si tea-daare Gote-me nipu abia raba meala pame adamina simi. ");
INSERT INTO kew_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Goa puare mo Yesu raapu nil-mi tisimide aa wae lapome page ero agaa simi-rupa sipi. ");
INSERT INTO kew_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Gore naare rikiraana aasa rabu ribaame rigitaama pua orope naare nogo-nane pabola pupulaina yapi wala lapaasa. ");
INSERT INTO kew_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Naare mogo-nane popa aaina aebo 3 klok rabu Yesu nipumi puri paloa gupa sa: Eli, eli, lama sabaktani sa. Go agaana re-re gupa: O, naa Aapa Gote, neme ni akolo gimae ya sa. ");
INSERT INTO kew_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Gore mo re-para rekasimi onaanumi go agaa pagoa nimumi lalo: Go aamere Elaija yaata simi. ");
INSERT INTO kew_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Go raburi aa padaneme aba aloma pua lubi nona piane yae misa. Goa puare rero pi wain ipa paba palae repena uni rugi-nane rogaa palaawa Yesu nipu nenalo kasa. ");
INSERT INTO kew_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Goa pisa pare onaa medalomame lalo: Aba adamina go ipa abi nakatapape simi. Elaija-me nipu raba mula ipula pame adamina simi. ");
INSERT INTO kew_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Go rabu Yesu nipumi wala puri paloa yaaloa nipuna pu imu udunasa. ");
INSERT INTO kew_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Go rabu mo lotu ada-para mudiabasimi mamina so rugi-nane riripi taboa none rigi-nane pua riripi kiritisa. Goa puare su eto pua aana adaapu lusatabebe pisa. ");
INSERT INTO kew_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Go rabu page matmat loba tabama pua Gote-na ruru onaare aba omesimi pare wala go rabu marekaasa. ");
INSERT INTO kew_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Gore nimumi matmat ora gimoa rekesimi. Wala orope Yesu rekesa rabu nimu epe adaare Jerusalem su-para pisimi. Go raburi aa adaapumi nimu adesimi. ");
INSERT INTO kew_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Soldia aa mudu-para nipuna soldia medanu-para su eto-para oyae rayo mo pisa-daa adesimi-pulu nimumi paala waru omesimi. Go rabu nimumi gupa simi: Go aare ora Gote-na Si yaana simi. ");
INSERT INTO kew_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Go rabu Galili su gimoa Yesu nipu rata mea ipua nipu raba mulalo ipisimide ona medaloma pirisimi. Nimu ogesi-daa mo-pare aawa nipu adesimi. ");
INSERT INTO kew_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Gore nimuna rikiraanare go onanu pirisimi: Makdala su-para piri ona Maria-para ame Jems-para Josep lapona agi Maria-para Sebedi-na si lapona agi-para nimu pirisimi. ");
INSERT INTO kew_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Gore ribaa yabaasa raburi amope aa meda Josep nipu Arimatea su-para pirua ipisa. Go aa nipuri abade Yesuna disaipel aa pirisa. ");
INSERT INTO kew_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nipu mo gavman-na opis-para ipua Yesu nipuna ro ria ponoloa epa agaa misa. Go rabu gavman-me nipu lakeloa go aa Josep mea katapa sa. ");
INSERT INTO kew_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Goa puare mo aa Josep-me Yesu nipuna ro mea rua epe kagaa mamina yaako pimi rogaawa ria pisa. ");
INSERT INTO kew_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Goa puare nipumi mo Yesu nipuna ro ria puare nipuna abade warini aana apedaa matmat-para pua rogaasa. Goa puare nipumi aana apedaa pora gaape-para aana adaape medame garulaniaawa pisa. ");
INSERT INTO kew_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Makdala-para Maria rado-para nipu lapo pirisipi. Nipu mo aana apedaa re-para pirua nipumi adapaba pirisipi. ");
INSERT INTO kew_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Gore ekeraa-nanere Kitu Pirape Yapi di aba ipisa. Goa pisa-pulu Gote-na Miru Irae Aa mudu-para Farisi aanu-para mo Pailat raapu epa kiritasimi. ");
INSERT INTO kew_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Goa pua nimumi lalo: Adaa aa-ya, gode yaa agaa ne aamere nipu kagaa pirua goa sade: Gore yapi repo pa no matmat-para pirua wala rekalua sa. ");
INSERT INTO kew_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Goa sa-ga yapi repo nimumi go matmat surubalepa lo agaa lakela. Gore nipuna disaipel aanumi nipuna ro paake epa mua onaanu-para nipu aba rekaaya loa niaa makiralimi-ga soldia aanumi surubalimina sa. Orope temede yaa agaare aba simide niaa makiralimi simi. ");
INSERT INTO kew_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Gore Pailat-me lalo: Nimimi surubape aa medaloma lamua pua mo matmat ora puri pane aanumi pua surubatepa sa. ");
INSERT INTO kew_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Goa sa-pulu nimumi mo matmat rigitulalo aana-me garulasimi. Goa pua nimumi mo aana rekena mea sua nimumi soldia aa medaloma surubaina simi. ");
INSERT INTO kew_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Gore Kitu Pirape Yapi di aba dia naloare adaa oro rabu naare rapasa. Go rabu Makdala su-para piri ona Maria-para Maria meda nipu lapome matmat-para adola ipisipi. ");
INSERT INTO kew_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Pulaina aipapulu su eto pisa rabu yaa-para piri ensel meda ipisa. Gore nipumi aana apedaana pora gaape mea pereke tua isa-daa nipu go madaa pirina adesipi. ");
INSERT INTO kew_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nipuna ini agaare so yaa madaa piri paa nona pisa. Nipuna mamina-ri ora moae yaa yaako nona pisa. ");
INSERT INTO kew_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Go ensel ipisa-pulu mo soldia aanu nimumi goa adoa paalame ora waru omesimi. Goa pua nimu pururu pisa-daa aba ome onaa nona piane pirisimi. ");
INSERT INTO kew_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Pare mo ensel-me mo ona laapo gupa lakesa: Gore nipimi paala naomalepape sa. Nimimi repena polopea-para tu maomaarimide Yesu asapula epamena-daa niminaato sa. ");
INSERT INTO kew_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nipu go-para napia. Nipu abade sade-rupa wala rekaa pua. Nipiri nipu rogaarimide-para epa adalepa. ");
INSERT INTO kew_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Gore nipi aipapulu wala pua nipuna disaipel aanu pua laketapape: Nipu aana apedaa matmat-para wala aba rekaade tapape sa. Nipu Galili su-para aba riri-nane nimumi go-para adalimi lo laketapape. Abiare neme lagiawade agaare koneme niminaatepape sa. ");
INSERT INTO kew_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Go agaa pagesipi rabu mo ona lapo nipu paalame omoa raaname waru omesipi. Goa pisipi-pulu nipu lapome aipapulu mo aana apedaa matmat gimoa disaipel aanu laketalo aloma pisipi. ");
INSERT INTO kew_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Pare ora go rabu Yesu nipumi aipapulu nipu laapo mo pora madaawa lalo: Epe-rupa piralepa sa. Go raburi nipumi nipuna kibu re-para pua ripinaa palae sua nipuna bi minasaasipi. ");
INSERT INTO kew_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Gore Yesumi nipu gupa lakesa: Nipimi paala naomalepape. Nipimi nina amenu mo Galili su-para popena pua laketapape sa. Go Galili su-parare ni mada adalimi. ");
INSERT INTO kew_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mo ona lapo pena pora-nia pulaina mo matmat surube soldia aa medaloma mo adaare-para aipapulu pisimi. Goa puare Gote-na miru irae aa mudunu-para mo adesimi yaena remaa pua lakesimi. ");
INSERT INTO kew_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Agaa pagesimi-pulu Gote-na miru irae aa mudunu nimu rayo-para kone waru i Juda aa mudunu-para nimu kirita pirua nimu agaa robesimi. Goa pua soldia aanu mone adaapu kasimi. ");
INSERT INTO kew_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Gore nimimi agaa gupa tapape simi: Ribaa niaa patala puaama rabu nipuna disaipel aanumi mea pua meaaya tapape simi. Goa pua nipuna ro paake mea puamede tapape lo robesimi. ");
INSERT INTO kew_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Gore mo namba wan gavman-me go remaa pagalia-daare niaame agaa medaloma wala lakelamina. Niaa goa palima rabu wae yae nasalia simi. ");
INSERT INTO kew_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Go raburi soldia aanumi mone muare mo aanumi simi-rupa pua pisimi. Go agaa rayore Judia su-para lama lama puare abia page pa lala pimi. ");
INSERT INTO kew_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Disaipel aa 12-pela so Galili su rudu madaa pisimi. Gore abade Yesumi pulupape sa-rupa pisimi. ");
INSERT INTO kew_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nimumi Yesu nipu adoa bi minasaasimi pare aa medalomame kone lapo isimi, ");
INSERT INTO kew_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Goa pua Yesu nipu ora re-para ipua gupa epa lakesa: Gote-me su yaa lapona puri rayo ni gia. ");
INSERT INTO kew_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Goa pea-ga nimimi su rayo-para pua nina disaipel onaanu-rupa mapiraatepape. Goa pua nimimi nimu Gote-na bi-para Sina bi-para Holi Spirit-na bimi baptais katapape. ");
INSERT INTO kew_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Goa pua neme abade agaa mana nimi mogesude-rupa onaa rayo pua laketapape. Pagalepa. Niri nimi raapu piraama puare go su yaa lapo dia yalia rabu page nimi raapu piralua sa. ");
INSERT INTO kew_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Gote-na si Yesu Krais pirisa. Go buk madaare nipuna Epe Agaa ia. ");
INSERT INTO kew_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ripiare Aisaia-me buk madaa agaa gupa tisa: Gote-me lalo: Pagalepape. Neme nina agaa lakelape aa aba epenatoa. Nimina pu robaa-para pora-rupa maredepo yatepape. ");
INSERT INTO kew_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mo aare nipu onaa napiri su-para aawa gupa yaasa: Aa Mudu epalia-ga nipuna poranu epe-rupa managola su piralepape lo lakesa. ");
INSERT INTO kew_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Aisaia-me gupa tisa-pulu Jon Baptais onaa napiri su-para aba ipua gupa lakesa: Onaanuna wae kone perekealimi-daare baptais mealimina. Gote-me nimina pupitagi mea raakepe rubalia sa. ");
INSERT INTO kew_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Gore Judia su robo ru-nane piri onaanu-para Jerusalem su-para piri onaanu page nimumi Jon-na agaa pagola pisimi. Nimu rayona waea lapedepe agaa lakeloa ipa Jordan-para baptais misimi. ");
INSERT INTO kew_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon-me kamel menana yogane maraawa sana mena yogane aako yamesa. Go aare onaa napiri su-para pirisa-pulu nipumi mata-para alubi Aapa asapu no pirisa. ");
INSERT INTO kew_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jon-me kiritaawa pirisimi onaanu-para gupa sa: Naa masaa-nane aa meda epalia. Niri wae aa ya-pulu nipuna aariti esepea kege-daa mada naradepealua sa. ");
INSERT INTO kew_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Neme nimi pa ipame baptais meaato pare Yesumiri ora Holi Spirit-na puri madaa baptais mealia sa. ");
INSERT INTO kew_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Gore orope Yesu nipu Galili su robo ru-nane go adaare Nasaret su gimoa Jon piri-para pisa. ");
INSERT INTO kew_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu nipu ipa repaa-nane aainaloa yaa pora gaape lobesa-daa adesimi. Lobesa rabu Holi Spirit yaa nona piane biyaa ipua sana Yesuna masaana epa pirisa. ");
INSERT INTO kew_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Biyaalaina yaa-para i agaa meda gupa sa: Nere ora nina si naaki-ga neme ne madaa pedo pi sa. ");
INSERT INTO kew_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Go rabu Gote-na Siri Holi Spirit-mi onaa napiri su-para mea penaasa. ");
INSERT INTO kew_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Go-para nipu yapi 40-pela pua pirina Satan-me Yesu pupitagi manataalo ko tisa. Go-para pirisa rabu kira menanu yaa yapanu Yesu raapu pirisimi pare ensel-numi nipu suruba pirisimi. ");
INSERT INTO kew_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Gore Jon kalabus ada-para mapataasimi raburi Yesumi Galili su-para ipua sana Gote-na kagaa agaa pamu lakesa. ");
INSERT INTO kew_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Lakesa raburi gupa sa: Gote-na Surube Su rudupu epalia-ga wae kone perekea kagaa agaa madaa kone rulaatepape sa. ");
INSERT INTO kew_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu ipa Galili ini repaa-nane pamisa rabu nipumi aa laapo adesa. Nipumi Saimon Andru ameaya lapo ipa ini-para ena agona sala pirina adesa. Go aa lapona kogonore ena meape aa laapo pirisipi. ");
INSERT INTO kew_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesumi nipu lapo-para lalo: Ni rata mea ipua nina kone ratalipina. Goa pua ena mepede-rupa onaanu page go-rupa mada mealepape. ");
INSERT INTO kew_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Goa sa rabu go aa lapome ena agona aipapulu gimoa Yesu raapu pisimi. ");
INSERT INTO kew_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesu ipa mone pane ogesi-daa pua Sebedi-na si laapo adesa. Go aa laapona biri Jems-para Jon lapo. Go ameaya ipunu madaa pirua ena agona rabulala pirisipi. ");
INSERT INTO kew_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesumi go aa lapo adoa ipulupa sa. Goa sa rabu go aa laapome nipuna aaraa-para kogono aanu-para gimoa Yesu raapu padane-para pisimi. ");
INSERT INTO kew_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Goa pua nimu Kaperneam su-para pisimi. Go Kitu Pirape Yapi rabu Yesumi Juda aanuna lotu ada-para agaa mogeasa. ");
INSERT INTO kew_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mogeasa rabu onaanumi ki wage pua raaname omenaloa rekena agaana tisaanu-rupa namogeaasa. Dia, pare nipuna purimi rado-rupa agaa lakesa. ");
INSERT INTO kew_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Go agaa mogeasa rabu wae remome maeyae aa ipua sana agaa puri palo rui gupa sa: ");
INSERT INTO kew_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Go Nasaret su-para piri aa Yesu ya. Neme niaa madaa ake pulalo epae ya? Nemere ne ade-ga niaa tulalo epaena? ");
INSERT INTO kew_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Goa sa rabu Yesumi remo-para agaa mana lalo: Agaa loraawa go aa gimape. ");
INSERT INTO kew_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Yesumi goa sa raburi wae remome maeyae aa pururu mapaawa agaa puri pane loare gimoa pane popesa. ");
INSERT INTO kew_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Gore rakepea pisa raburi onaa rayome kidipaa ragi tua meda lakelala pu pirisimi: Go aare ake piane aa ya? Mogo aa-na agaare ora rado meda yaade. Nipuna purimi wae remo agaa mana ta-daa nimumi pageme simi. ");
INSERT INTO kew_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Goa pisa-pulu Yesuna bi Galili su-para mone mone laama pisimi. ");
INSERT INTO kew_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Goa pisa raburi Yesu Juda aanuna lotu ada gimoa Saimon-para ame Andru lapona ada-para pisa. Jems page Jon page medaa rabu pisimi. ");
INSERT INTO kew_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Gore Saimon-na aaya kekapu pi yaina omesa-daa nimumi Yesu epa lakesimi. ");
INSERT INTO kew_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Lakesimi raburi Yesu ipua sana go onana ki ripinaawa marekaawa kekapu pi yaina maepeaasa. Nipuna yaina dia sa rabu nipumi nimu eta kasa. ");
INSERT INTO kew_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Naare pabola pisa raburi onaanu yaina omesimi page masaa-nane remo piri onaanu page Yesu piri-para mea ipisimi. ");
INSERT INTO kew_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mea ipisimi raburi su rayo-para piri onaanu page Yesu adolalo ipua pora gaape-para kirita pirisimi. ");
INSERT INTO kew_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Pirisimi rabu Yesumi onaa adaapuna yaina maepeaawa sana wae remonu page marakepeaasa. Wae remonumi Yesu aba adesimi-pulu Yesumi onaanu-para go agaa natapape sa. ");
INSERT INTO kew_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Gore wala yapi pena lapatalo palaina Yesu rekoa sana onaa napiri su amaa-nane pua Gote-para beten ta pisa. ");
INSERT INTO kew_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Go raburi Saimon-para go adami aa medaloma page Yesu rata mea pisimi. ");
INSERT INTO kew_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Yesu adesimi rabu gupa simi: Onaa rayome ne asapu pimi. ");
INSERT INTO kew_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesumi lalo: Wala pa su meda-nane laketa baina loa neme nimu epe agaa mogeaalua. ");
INSERT INTO kew_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Goa puare nipu Galili su robo ru-nane su rado rado pamua Juda aanuna lotu ada-para page lakeloa wae remonu page raakepe rubisa. ");
INSERT INTO kew_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Goa pisa raburi yakimi ti aa medame ipua rumu koba pua pirua Yesu gupa ogesa: Neme ni kone sali-daare naa rere makaapu yape sa ");
INSERT INTO kew_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Gupa ogesa raburi Yesu nipumi odome omoa nipuna ki ridulaawa go aana yogane oraawa lalo: Goa pea-ga abia kaapu yape sa. ");
INSERT INTO kew_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Goa pisa raburi mogo yakimi ti aa-na yoganena rere kaapu yoa wala epe-rupa pirisa. ");
INSERT INTO kew_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesumi mo aa aipapulu repaawa puri paloa gupa sa: ");
INSERT INTO kew_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Waru pagape. Onaa rayo nalakelape pare Gote-na Miru Irae Aa piri-para nena yogane mea waalape. Moses-me Gote-para miru irua kalape aba sa-pulu gupa paina. Go pali raburi onaanumi nena rere kaapu ta-daa mada adalimi sa. ");
INSERT INTO kew_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yesumi goa sa pare rere kaapu ne aamere agaa adaapu one mone pamu lakesa. Goa pisa rabu Yesu adaare meda-para kaledoa pisa. Nipu onaa napiri pa su meda-para pirina onaanumi nipu piri-para agaa pagolalo kiritata ipisimi. ");
INSERT INTO kew_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Gore orope yapi medame Yesu nipu mo Kaperneam su-para epa pia remaa pagesimi. ");
INSERT INTO kew_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Pagesimi-pulu onaa adaapu kiritaawa ru-nane pora gaape-para page rulatabesa. Goa pu pirisimi raburi Yesumi Epe Agaa mogeasa. ");
INSERT INTO kew_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mogeasa rabu yaina omo pora napami aare aa maalame ria ipisimi. ");
INSERT INTO kew_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Gore onaa adaapumi mo pora gaape-para rulatabesimi-pulu Yesu piri-para mada naria ipisimi. Goa pisa rabu mo yaina ome aa ada masaana ria pisimi. Goa pua ada pira kegepe minala paawa reke opeme rogaabaawa apalae ru-nane pawa lopaniaasimi. ");
INSERT INTO kew_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Goa puare Yesumi nimuna kone mua pora napami aa-para lalo: Ne naa naaki-ga nena pupitagi ne kone mea rubaato. ");
INSERT INTO kew_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Goa sa raburi rekena agaa tisaanu pirua nimuna robaa-para kone gupa isimi: ");
INSERT INTO kew_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Mo aamere akeane ta pae simi. Nipumi Gote madaa ero agaa ta paaya. Nipumi pupitagi ne kone mada mea rubalia ya? Gote nipu padaneme mada mea rubalia kone isimi. ");
INSERT INTO kew_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Go kone isimi raburi Yesumi nimuna robaa-para kone mua lalo: Nimimi go piane konere akeane imi pae? ");
INSERT INTO kew_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ake kogono puri mapalaatalo palua ya? Ni pora napami aa-na pupitagi ne kone mea rubaluare go kogono puri patea ya? Nipu pora mapamuaaware go kogono ora puri patea ya? ");
INSERT INTO kew_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ni Gote-na Si padanemere su amaa piri onaanuna pupitagi mada mea rubalua-ga adalepa. Go rabu yaina ome aa-para lalo: ");
INSERT INTO kew_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Yapara page u pati yae mea ripinua rekoa adaa pu. ");
INSERT INTO kew_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Goa sa raburi yaina ome aa aipapulu rekoa yapara mea ripinua pora pamisa. Pamisa raburi onaanumi paalame omoa Gote-na bi minasaawa gupa simi: Niaame oyae go piane na-adema simi. ");
INSERT INTO kew_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu ipa ini pagi-nane wala pisa rabu onaa rayo Yesu piri-para epenaloa Yesumi agaa moge riaasa. ");
INSERT INTO kew_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Yesu pora pamisa rabu Alfius-na si Livai-ri takis mi ada-para pirisa. Yesumi go aa adoa lalo: Ni rata mea ipu. Goa sa raburi Livai nipu rekoa Yesu rata mea pisa. ");
INSERT INTO kew_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Goa pisa rabu orope Yesu Livai-na ada-para eta nolalo pisa. Takis mi aanu-para pa riabo aanu-para Yesuna disaipel aanu-para nimu rayo ada ru-nane padane-para epa kiritaawa pirisimi. Gore onaanumi Yesu rata mea ipisimi-pulu ora adaapu pirisimi. ");
INSERT INTO kew_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Go raapu pirisimi pare Yesu nipu pupitagi ne aanu-para takis mi aanu-para pirina Farisi aanuna pepa tape aanumi nimu adesimi. Adesimi rabu nimumi disaipel aanu agaa gupa misimi: Akeane Yesu takis mi aanu-para pupitagi ne aanu raapu pirua eta nala pae simi. ");
INSERT INTO kew_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Pepa tape aanumi goa simi rabu Yesumi nimuna agaa pagoa lalo: Yaina naome onaanuri dokta-na ada napeme pare yaina ome onaanu pemede. Go-rupa neme page epe kone i aa agu raba mula-daa naipisu pare onaa naraanu raba mulalo ipisu sa. ");
INSERT INTO kew_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Rana medare Jon-na disaipel aanu page Farisi aanu page Juda aanuna agaa mogeaawa eta madaa niti pua pa pirisimi. Go rabu onaa medalomame Yesu piri-para agaa mula ipisimi: Gore akeane Jon-na disaipel aanu page Farisi aanu page eta nano pimi pare nena disaipel aanu eta pa neme simi. ");
INSERT INTO kew_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Goa simi rabu Yesumi saa agaa gupa sa: Aa medame ona rumaatalo pia rabu nipuna adami aanumi eta kateme ya? E, kateme. Gore ona rumaape aa pia-pulu eta mada kateme. ");
INSERT INTO kew_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Oropere ona rumaape aa lamua palia rabu adami aanumi eta nape yae madaa niti pua piralimi. ");
INSERT INTO kew_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yesumi kagaa oyaeyae lapo madaa saa agaa gupa lakesa: Aa medame mamina rugini kagaa mua abana mamina madaa rabulalia ya? Dia, gupa rabulaalia rabu kagaa rabuni mamina-mere abana mamina mariripiaawa rugula tabalia. ");
INSERT INTO kew_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Go page aa medame kagaa ipa wain-mi abana yapa yogane pe-para yupialia ya? Dia, goa palia-daa yogane podepe taboa kagaa ipa wain popalia. Gore kagaa wain-ri kagaa yapa yogane pe-para yupiape. Goa pea-ga abana kone-para kagaa kone lapo padane-para nasalepape sa. ");
INSERT INTO kew_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Wala Kitu Pirape Yapi rabu Yesu-para nipuna disaipel aanu-para wit maapu-para pamisimi. Gupa pamualaawa disaipel aanumi wit-na ini keresimi. ");
INSERT INTO kew_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Gore keresimi rabu Farisi aanumi Yesu-para agaa gupa lakesimi: Ada. Akeane Kitu Pirape Yapi rabu nena disaipel aanumi rekena agaa rasua kogono peme? ");
INSERT INTO kew_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesumi lalo: Devit-mi tisade remaare nadipisimi? Devit aa medaloma raapu eta dia yoa reame omesimi. ");
INSERT INTO kew_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Reame omesimi raburi aa meda Abaiata-re nipu Gote-na Miru Irae Aa pirisa. Go aa mudu pirisa rabu Devit-miri lotu ada-para bret pua mua noa aa medaloma page kasa. Go bret-re Gote-na kalape bret ya-pulu Gote-na miru irini aanumi agu nisimi. Nimimi go agaana re niminaaeme ya? ");
INSERT INTO kew_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesumi lalo: Gote-me Kitu Pirape Yapi robo isare onaa raba minalo pisa. Gote-na Kitu Pirape Yapi madaa onaa nawarisa. ");
INSERT INTO kew_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ni Onaa Raapu Pirape Aa ya-pulu niri Kitu Pirape yapina Aa Mudu pi sa. ");
INSERT INTO kew_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Wala orope Yesu Juda aanuna lotu ada-para pisa rabu ki rudu-ae aa meda pirisa. ");
INSERT INTO kew_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Goa pisare Kitu Pirape Yapi ya-pulu Farisi aanumi Yesu koso lape agaa ta polalo pirisimi. Gore Yesumi ki rudu-ae aa wala maepeaaliare koso laalima kone sua pirisimi. ");
INSERT INTO kew_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Goa pisa rabu Yesumi ki rudu-ae aa-para lalo: Rekoa ipu. ");
INSERT INTO kew_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Goa sa raburi nipumi Farisi aa-repaa agaa misa: Kogonore ake epe ta? Gore neme onaa raba mua epe-rupa mapiraano epe ta pae onaa tu maomalimi epe ta pae? Kitu Pirape Yapi diri ake kogono mada pamina? Go agaa misa pare Farisi aanumi agaa na-abusimi. ");
INSERT INTO kew_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nimumi agaa pa yola mua pu-para rero pia pisimi-daa Yesumi ratu yawesa pare-ga wala odome omesa. Odo omesa rabu ki rudu-ae aa-para lalo: Ki ridula. Mo aame nipuna ki ridulasa rabu Yesumi ki maepeaasa. ");
INSERT INTO kew_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Goa pisa raburi Farisi aanumi aa mudu Herot-na adami aanu piri-para pua Yesu tu maomaatalo yada robo pirisimi. ");
INSERT INTO kew_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Goa pisa rabu Yesumi nipuna disaipel aanu gimoa wala ipa repaa-nane pisimi. Goa pisimi raburi su Galili-nane piri onaame orope rata mea ipisimi. ");
INSERT INTO kew_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Go page su Jerusalem su-para onaanu page su Idumea onaanu page ipa Jordan-na mo-nanena onaanu page Tair Saidon su lapona piri onaanu page go su rayona piri onaanumi Yesuna epe remaa pagolalo nipu piri-para kiritaawa ipisimi. ");
INSERT INTO kew_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kiritasimi rabu Yesumi nipuna disaipel aanu-para lalo: Onaanumi niaa epa minabalimi-ga ipunu managola salepape sa. ");
INSERT INTO kew_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yesumi onaa adaapuna yaina aba maepeaasa-pulu onaa medalomame Yesuna to yogane oraatalo kiritasimi. ");
INSERT INTO kew_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Goa pisa rabu wae remo pabo piri aanumi Yesu adoare yala poloa pogola pisimi. Aiya, ne ora Gote-na Si simi. ");
INSERT INTO kew_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Goa simi raburi Yesumi lalo: Naa bi natapape sa. ");
INSERT INTO kew_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Goa pua wala go rabu Yesumi su rudune pua nipuna kone sua aa medaloma-para ipulupa sa. ");
INSERT INTO kew_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Goa pua Yesumi nipuna disaipel aa 12-pela mada mua lalo: Ni raapu kogono pu epe kagaa agaa laketemena repaalua. ");
INSERT INTO kew_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Nimimi goa palimi rabu nina purimi wae remo pabo piri aanu marakepealimi. ");
INSERT INTO kew_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nipuna aposel 12-pela nimuna bi gupa maasa: Saimon yapare Yesumi Pita loa bi maasa. ");
INSERT INTO kew_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Medalomare Sebedi-na si Jems-para Jon lapo misa. Yesumi go ameala Boanerges lo bi maasa. Go bi adaa agaa madaare yai ari tala naaki lapo teme sa. ");
INSERT INTO kew_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Yesumi aa medaloma gupa mada misa: Andru-para Filip-para Batolomyu-para Matyu-para Tomas-para Alfius-na si Jems-para Tadius-para Saimon nipu Selot ruru pirisa. ");
INSERT INTO kew_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Gore namba 12 aare Judas nipu Iskariot su-para pirisa pare go aamere orope Yesu tulalo kawe madini aa pirisa. Go aa rayo Yesumi nipuna disaipel aanu mapiraawa ada pisa. ");
INSERT INTO kew_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Goa pisa rabu onaa ora adaapu wala kiritasimi-pulu Yesu nipuna disaipel aanu page eta nanisimi. ");
INSERT INTO kew_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Eta nanisa remaa pagesimi rabu Yesuna adami aanumi nipu mula ipisimi. Gore Yesu kone maeyaawa eta nano piruaaya kone sua nipu mula ipisimi. ");
INSERT INTO kew_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Goa pisa rabu rekena agaa tisaanumi nimuna Jerusalem su-para gimoa epa lalo: Yesuna masaana Belsebul pia-pulu go remonuna purimi remo medaloma mada magimaalia simi. ");
INSERT INTO kew_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Goa simi rabu Yesumi nimu yaaloa saa agaa lakesa: Satan-me nipu pua gimape re mada tea ya? Dia, onaana robaa-para piralia-pulu mada natea. ");
INSERT INTO kew_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Gore pa su meda-parare ruru padane pirua rugulala paliare go suna puri ora mada dia yoa o yalia. ");
INSERT INTO kew_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Go page ada meda aaraalu rugulala paawa yada palimiri go aaraaluna puri ora dia yalia. ");
INSERT INTO kew_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Go page Satan-me nipuna surube onaanu rugulala palia yaalore epe-rupa mada napiralimi pare puri ora dia yalia. ");
INSERT INTO kew_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Yesumi Satan madaa saa agaa meda gupa lakesa: Neme puri pane aa opeme aba rogaaliri nipuna ada-para oyaeyae mada paake noa maoyaali. ");
INSERT INTO kew_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Go agaa pagalepape. Gote-me onaana pupitagi mada mea rubalia. Go page onaanumi ero agaa rana adaapu temere nipumi mada rabuaniaalia. ");
INSERT INTO kew_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Goa pea pare onaanumi Holi Spirit madaa ero teme-daare Gote-me go wae konere namea rubalia. Go wae konere ora adaape ya-pulu mo aa-na go wae kone oro yaalo pa saapiralia. ");
INSERT INTO kew_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Onaa medalomame Yesuna masaame remo pia aba simi-pulu Yesumi apo agaa lakesa. ");
INSERT INTO kew_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Goa pisa raburi Yesuna agi amenu ipua ada gaa-nane pirua Yesu adola ipisimi-daa agaa lo moneasimi. ");
INSERT INTO kew_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Agaa o taasimi rabu onaanumi Yesu piri-para kiritaawa simi: Nena agi amenu ada gaa-nane pimi simi. Ne lamua polalo epa yalame simi. ");
INSERT INTO kew_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Goa simi rabu Yesumi lalo: Nina ama ame baaninuri aapi ya? ");
INSERT INTO kew_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Go rabu nipu pereke tua onaanu adoa agaa gupa lakesa: Go onaanuri naa ama naa ame baaninu pimi sa. ");
INSERT INTO kew_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Onaa rayome Gote-na kone ratalimi-daare go onaanu naa ame baani ama aapa pimi sa. ");
INSERT INTO kew_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Wala oro meda Yesumi ipa ini repaa-nane pua agaa pamu moge riasa. Mogeasa rabu onaa adaapu kiritisimi-pulu nipumi ipunu madaa pirua ipa repaa-nane pua agaa lakesa. ");
INSERT INTO kew_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Onaa kiritasimi rabu Yesumi saa agaame gupa lakesa: ");
INSERT INTO kew_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Gore wit-na ini poae aame ini pola pisa. ");
INSERT INTO kew_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Pua poasa rabu wit-na ini medaloma pora-nia madaa lopesa. Go rabu yaanumi epa mea nisimi. ");
INSERT INTO kew_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ini medalomare no aana rote madaa lopesa. Goa pisa rabu rote madaa-nane oge su kobere isa-pulu inimi aipapulu opesa. ");
INSERT INTO kew_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Aipapulu opesa pare naareme adesa rabu pita napua kaapu sa. ");
INSERT INTO kew_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ini medalomare repena eto ae-para lopesa pare adaa sa raburi etoto putimi maregepeaawa wit-na ini naetisa. ");
INSERT INTO kew_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ini medalomare epe su kobere madaa lopesa-pulu opoa sana ini epe-rupa etisa. Wit-na ini etisa rabu medalomare 30-pela etisa. Ini medalomare rikiraana sone pua ini 60-pela etisa. Medalomare ini rubi kiritua ora 100-pela etisa. ");
INSERT INTO kew_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Goa pua Yesumi lalo: Onaa rayome go agaana re niminaalimiri waru pagalepape sa. ");
INSERT INTO kew_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Goa pua agu raapo pirisa rabu nipuna disaipel aanu raapu onaa medaloma ipua saa agaana re epa agaa misimi. ");
INSERT INTO kew_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Gupa agaa misimi rabu Yesumi lalo: Nimimiri Gote-na Surube Su madaa kudiri agaa pageme. Goa pea pare kepo rarane piri onaanu saa agaa laketalo pi. ");
INSERT INTO kew_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Go agaana re adalimi pare nimumi yada namakualimi: Onaanumi ado pimi pare naniminaalimi. Pagalimi pare namakuaalimi. Gore niminaawa pupitagi ne kone gimalimiri Gote-me waea yae mea rubalia. ");
INSERT INTO kew_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesumi nimu-para lalo: Go saa agaana re mada namakuaa pimi? Napagalimiri saana agaare akolo makuaalimi ya? ");
INSERT INTO kew_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Saa agaana re gupa sa: Wit-na ini pua poae aamere nipu Gote-na kagaa agaa poaaya. ");
INSERT INTO kew_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Gore pora uni madaa lope wit-ri onaanumi kagaa agaa pagaminalo Satan-me aipapulu epa mabebolaalia. ");
INSERT INTO kew_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Go aana rote madaa lope wit-ri onaanumi kagaa agaa pagoa raana omo pimi. ");
INSERT INTO kew_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Raana omeme pare nimuna robaa-para pita napua pa ogesi pea. Oge yapi di pirua kagaa agaa pageme pare wae yaeme nimu talia rabu Gote gimoa aipapulu lopeme. ");
INSERT INTO kew_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Repena eto-para lopea wit-ri go onaanumi kagaa agaa pagoa pare nimuna koneme abia ake palua pae kone imi. ");
INSERT INTO kew_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Goa pua nimu sekere menanu raana omoa oyaeyae mulalo peme. Goa pea-pulu nimumi Gote-na kagaa agaa robaa-para ia pare go koneme maregepaawa maoyaalia. ");
INSERT INTO kew_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Epe su kobere-para lopesa wit-ri onaanumi kagaa agaa pagoa ini epe-rupa maditimi. Go raburi medalomana iniri 30-pela etea. Medalomanare ini 60-pela etea pare medalomana ini rubi kiritina gupa 100-pela etea sa. ");
INSERT INTO kew_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesumi nimu agaa gupa misa: Onaanumiri lam ewoa reke rolo-para imi ya? Reke rolo-para suare so madaa namudialimi ya? Dia, ora mudiaemede. ");
INSERT INTO kew_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Gore oyaeyae pagaa suare orope mea wanalo peme. Oyaeyae kudiri pu salimiri orope Gote-na paame ada salia. ");
INSERT INTO kew_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nimimi go agaana re niminaaba piralimiri waru pagalepape. ");
INSERT INTO kew_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yesumi nimu-para wala lalo: Pageme agaare waru surubape. Nimimi agaa mogeteme-daare Gote-me mogo kogonona yago wala abutea. Goa pua medaloma page gialia. ");
INSERT INTO kew_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Onaa medalomame oyae adaapu su pitimi-daare Gote-me medaloma page mea gialia. Pare onaa rayome ogepu oyae su pitimiri oge abuna ora mu pa aalia. ");
INSERT INTO kew_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Goa pisa rabu Yesumi wala lalo: Gote-na Surube Suri go piane lo lagialo: Pa aa medame ini su madaa radasa. ");
INSERT INTO kew_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nipu u patua rekoa kogono pula pea rabu mo kibita ini opoa adaa yalia. Goa pea pare go aame go ini opea-rupa naniminaaya. ");
INSERT INTO kew_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Sumi nipuna ini madita. Goa pua aba ripiare yosi opoa walare uni aawa walare nape yae etalia. ");
INSERT INTO kew_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Goa pua go ini etea rabu mo aame rai kutu mua aipapulu warita palia. Gote-na Surube Su onaanuri apo maapu madaa oyae opea-rupa adaapu piralimi. ");
INSERT INTO kew_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Goa pisa raburi nipumi wala lalo: Gote-na Surube Suri ake nona piane ya? Gote-na Surube Suri ake madaa lano ya? ");
INSERT INTO kew_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Gote-na Surube Su gupa ia: Repena yamo mastet-me ini su amaa radata rabu nipuna ini ora ogege yaesi. ");
INSERT INTO kew_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ogege yaesi yapare opoare repena rayo minabaaya. Go repena palaa adaa yalia-pulu yaanumi ipua palaana ru-para ada peme. Gote-na Surube Su madaa piri onaanuri aba ogepu pirua orope adaapu piralimi. ");
INSERT INTO kew_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesumi saa agaa go-rupa lakesa. Nimumi agaana re niminaainalo mogeaata pisa. ");
INSERT INTO kew_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Pare Yesumi nimu-para oro yaalo saa agaame agu mogeasa. Goa pisa pare nipumi disaipel aanu-para saa agaana re lakesa. ");
INSERT INTO kew_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Go yapi padanena aebo raburi Yesumi nimu-para lalo: Abiare ipa ini mone pane bai. ");
INSERT INTO kew_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Goa sa raburi Yesu ipunu ru-nane aba pirina disaipel aanu page epa pirisimi. Nimu pirisimi rabu ipunu medaloma page go-para isimi. ");
INSERT INTO kew_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Goa pua ipa ini madaa aba penaaloare po ripu ipua ipa kai tisa rabu ipunu-para ipa epa pabolalo pisa. ");
INSERT INTO kew_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Go rabu Yesumi ipunu masaa-nane pirua kada sua u patisa. U patisa raburi nimumi nipu marekaawa simina: Aya Tisaa, niaa omalima-ga kone nasae ya? ");
INSERT INTO kew_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Goa simi rabu Yesumi rekoa po ripu-para ipa lapo agaa gupa lakesa: Mada-ga gima. Goa sa rabu po ripu loraawa ipa eto napi pa pirisa. ");
INSERT INTO kew_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Goa pisa raburi Yesumi nimu-para lalo: Akeane paala omeme? Abia page epe agaare nimina robaa-para waru nasame ya? ");
INSERT INTO kew_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Goa sa raburi nimu paala omoa simina agaa lo pirisimi: Go aare aapi yapae lo pirisimi. Go aa-na agaare po ripu-para ipa ini laapome pagea simi. ");
INSERT INTO kew_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Goa pisa raburi nimu ipa ini Gerasa-repaa mone pane pisimi. ");
INSERT INTO kew_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Mone pane opapasimi raburi Yesu ipunu gimoa popesa. Go rabu wae remo pabo piri aa meda matmat apedaa gimoa Yesu aipapulu madaama ipisa. ");
INSERT INTO kew_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Go remo pabo piri aa nipu matmat-na u patisa rabu onaanumi nipu puri pane opeme page mada na-adisimi. ");
INSERT INTO kew_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Go aa nipu oro yaalo hankap ope laapo rugulu rubebe pala pisa-pulu mada na-adisimi. Goa pisa-pulu nimumi nipu mada kuma namapaeme. ");
INSERT INTO kew_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Oro yaalo mo aa matmat amaa-para pore laapona pamisa. Pamisa raburi nipu rui loa aana-me nipuna to mea tala pisa. ");
INSERT INTO kew_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nipumi Yesu adesa rabu Yesu piri-para aipapulu ipisa. Go rabu mo aame Yesu madaa paala omoa rumu koba pua epa pirisa. ");
INSERT INTO kew_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Rumu koba pisa rabu puri paloa gupa yaasa: Ne ora Mudu Gote-na Si Yesu yaade. Neme ni-para ake pali ya? Gote-na bi madaa lalo-pulu neme ni gimoa pu. ");
INSERT INTO kew_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Gore Yesu aba nipu wae remonu nipu gimoa pope lo lakesa-pulu apo agaa sa. ");
INSERT INTO kew_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Goa sa raburi Yesumi nipu-para wala lalo: Nena biri aapi ya loa agaa misa. Wae remo aaya aame lakesa: Remo adaapu ni-para odobaeme-pulu nina biri riri yaade. ");
INSERT INTO kew_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Go rabu mo aame Yesu-para puri paloa ogesa: Niaa rayo pora kimisu-para na-ratu ta sa. ");
INSERT INTO kew_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Goa pisa raburi menanumi rudu-nini e poalaasimi. ");
INSERT INTO kew_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Wae remonumi Yesu-para lalo: Niaa mogo menanu-para mea repaa. Goa pua nimuna robaa-para pomona gupa ogesimi. ");
INSERT INTO kew_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Gupa ogesimi raburi Yesumi nimu mea rapaasa. Mea rapaasa rabu wae remonu mo aa gimoa menana robaa-para pua odobasimi. Go rabu mena-repaame rata-para kilipia ipa-para pua omesimi. Menanuri ora 2000-rupa omesimi. ");
INSERT INTO kew_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Gore mena puni aanumi go yae adoa adaare-para pa su meda-nane pogola pua puaa lakesimi. Lakesimi raburi onaa rayo ipua epa adesimi. ");
INSERT INTO kew_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Nimu Yesu piri-para ipua aba wae remo piri aa epa adesimi. Remo pirisade aare nipu pirua mamina yamoa epe kone isa. Mo aa adesimi rabu paala omesimi. ");
INSERT INTO kew_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Goa pua onaanumi wae remo mena madaa pua odobataina adesimi-pulu remaa pamu simi. ");
INSERT INTO kew_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Goa pisa rabu nimumi Yesu-para lalo: Niaana su gimoa su meda-para pope simi. ");
INSERT INTO kew_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu ipunu madaa piritalo pisa rabu mo remo piri aame ni page pirapana sa. ");
INSERT INTO kew_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Goa sa pare Yesumi dia loa nena ruru piri-para pua ni madaa Aa Mudumi epe kogono paa lo pua lakelape sa. Gote-me ni odome omalo pua lakelape sa. ");
INSERT INTO kew_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Goa pisa raburi aba remo piri aame Dekapolis su-para pua Yesuna kogono painalo lakesa. Onaa rayome pagoa ora pogolasaasimi. ");
INSERT INTO kew_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesumi ipunu madaa pirua ipa mone pane wala kenaasa rabu onaa kiritasimi. Kiritasimi rabu Yesu ipa ini repaa-nane pirisa. ");
INSERT INTO kew_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Goa pisa rabu aa meda nipuna bi Jairasi go aame Yesu piri-para ipisa. Nipu mo Juda aanuna lotu adana aa mudu pirisa. Nipu Yesu adesa raburi Yesuna kibu re-para ipua rumu koba pua agaa mulalo pisa. ");
INSERT INTO kew_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Rumu koba pua nipumi lalo: Naa oge nogo ora ini adupialia. Gore ne epape. Nipuna to madaa kimi oraali rabu nipuna yaina perekealia. ");
INSERT INTO kew_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Goa sa raburi Yesu nipu raapu pisipi. Onaa adaapumi nipu rata mea pisimi rabu Yesu pope pora rulatabesa. ");
INSERT INTO kew_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Pora pisimi raburi ona meda nipuna yaapi pupulae yaina maali ru repo patisa. ");
INSERT INTO kew_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mo oname dokta-nuna ada pua nipuna to mada radaa pina pisa pare namaperekeaasimi. Dia, pare go onana yaina adaa ya-mama pisa. ");
INSERT INTO kew_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Go ona Yesuna bi pagesa-pulu onaa pabo kiritasimi-para ipua Yesuna masaa-nane mamina oraata ipisa. ");
INSERT INTO kew_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Oname mamina oraawa kone gupa misa: Go aa-na mamina oraalua rabu ni mada maperekealia kone isa. ");
INSERT INTO kew_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Goa pua oraasa raburi nipuna yaapi kaapu sa rabu nipuna robaa-para epea pi kone isa. ");
INSERT INTO kew_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Mo oname oraasa raburi Yesuna puri medaloma ma-puaasa-daa koneme adesa. Nipu pereke tua onaanu agaa gupa misa: Nina mamina aapimi oraaria ya? ");
INSERT INTO kew_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Go agaa mulalo pisa raburi Yesuna disaipel aanumi gupa simi: Gore onaa adaapu reko piramede-ga naa mamina aapimi oraaria pae piri ake pea-daa le? ");
INSERT INTO kew_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pare Yesumi pereke tua adobasa. ");
INSERT INTO kew_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Goa pisa rabu onana kone-para paalame omesa. Paala omoa pururu pua Yesuna kibu-para epa adaniaa pirisa. Go oname yala omoa neme pawade-ga neme ni maepeaainalo pawa sa. ");
INSERT INTO kew_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Goa pisa raburi Yesumi mo ona gupa lakesa: Aina, neme Gote madaa kone rulaari-pulu ne epea pi-ga abia pawa pope. Nena yaina puade sa. ");
INSERT INTO kew_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesumi goa lalaina Jairas-na mea repaae aa medaloma go Juda aa muduna ada gimoa ipua lalo: Nena wane ini adupiaade. Nere akeane tisaa mea epali ya? ");
INSERT INTO kew_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Goa simi pare Yesumi apo agaa gimoa Juda aanuna aa mudu-para gupa sa: Paala naomape. Dia, kone rulape. ");
INSERT INTO kew_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Goa pisa raburi Yesumi Pita-para Jems-para nipuna ame Jon-para medaa-para baina sa. Pisimi raburi Yesumi lalo: Onaa medaloma ada-para naipulupape lo lakesa. ");
INSERT INTO kew_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nimu apo Aa Mudu-na ada re-para ipisimi rabu Yesumi onaa rayo puri paloa re lala pirina adesa. ");
INSERT INTO kew_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesu ada-para pisa raburi onaa lakeloa lalo: Akeane re lo pimi? Go nogo na-ini adupita pare pa u patana sa. ");
INSERT INTO kew_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Goa sa raburi nimumi nogo ini adupisa-daa niminaasimi-pulu giri laasimi. Giri laasimi raburi onaanu amaa ratu tisa. Yesu-para mo nogona agi aaraa lapo-para disaipel aanu-para nimu rayo nogona ro isa ru-nane pisimi. ");
INSERT INTO kew_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesumi oge nogona ki mua Talita Kumi sa. Go agaare gupa sa: Oge nogo abi reka sa. ");
INSERT INTO kew_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Goa sa raburi go nogo aipapulu rekoa pamisa. Go nogona maali 12-pela pirisa. Mo nogo pamisa raburi onaanumi paala omoa kidipaa ragi tu pirisimi. ");
INSERT INTO kew_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesumi nimu-para lalo: Onaa medaloma napua laketapa. Go nogo eta katapape sa. ");
INSERT INTO kew_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu go su gimoa nipuna adaare-para pisa. Pisa rabu nipuna disaipel aanumi nipu rata mea pisimi. ");
INSERT INTO kew_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Goa pisa raburi Yesu Kitu Pirape Yapi di rabu nipumi Juda aanuna lotu ada-para agaa mogeaata pisa. Mogeasa rabu onaame pagoa pogolasaawa gupa simi: Go aa-na kone aa-para misa? Akea pua go adaa puri misa? Puri pane kogono medaloma nipuna purimi wariala. ");
INSERT INTO kew_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Go aare kamda kogono pi aa pirua nipuri Maria-na si yaade. Go page Jems-para Josep-para Juda-para Saimon-para go aanu nipuna amenu yaade. Nipuna baaninu niaa padane-para pima simi. Goa loa nimimi Yesu madaa robaa-para wae kone isimi. Goa pua nimumi Yesu gimisimi. ");
INSERT INTO kew_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Goa pisimi rabu Yesumi nimu-para lalo: Gote-na agaa lakene aare su rayo-para onaame nipuna bi minasaaeme pare nipuna adaare-para nipuna ruru-para nipuna aaraalu-para nimumi nipuna bi naminasaaeme. ");
INSERT INTO kew_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Goa pisimi rabu Yesumi puri pane kogono go-para mada nawarisa pare nipumi onaana yaina padane padane laatapu maperekeaasa. ");
INSERT INTO kew_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yesu onaanuna pu robaa-para kone waru narulasimi-pulu Yesu ora paalame omesa. Goa pua Yesu adaare rayo-para epe agaa mogeatalo pamisa. ");
INSERT INTO kew_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Goa pisa raburi Yesumi aposel kogono aa 12-pela rapaasa. ");
INSERT INTO kew_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Goa pisa rabu laapo laapo laatapu mua mea rapaasa. Yesumi nipuna disaipel aanu puri kaloa wae remo mea rubaainalo pisa. Yesumi agaa gupa lakesa: Pora kimisu-para palimi rabu oyae namealepape pare rimaapu ripinua pora pamula pulupape. Sapi-para nu-para mone pabe paus-para rayo namea pulupape lo lakesa. ");
INSERT INTO kew_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nimimi aariti sua palimi pare mamina padane yamalepape. ");
INSERT INTO kew_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Yesumi page nimu-para gupa lakesa: Adaa adaare-para pua kogono palimi raburi ada padane-para pirua eta nalepape. Adaare rado-para palimi rabu go ada nagimalepape. ");
INSERT INTO kew_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Adaa adaare-para palimi rabu go onaanumi nimi gimoa epe agaa napagalimi-daare nimuna wae yae niminaaina nimina aa madaa ae kege nimuna ada-para kunu satepape. ");
INSERT INTO kew_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Goa sa raburi disaipel aanumi pua onaanu lakeloa lalo: Wae kone rabuaatepape simi. ");
INSERT INTO kew_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Disaipel aanumi wae remo pabo piri aa maepeaawa yaina ome onaana aalu madaa wabola sua maperekeaasimi. ");
INSERT INTO kew_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Goa pisimi rabu gavman-na aa mudu Herot-me disaipel aanuna kogono madaa remaa pagesa. Yesuna bi sogo-nane puala nogo-nane puala pisa-pulu pagesa. Goa pisa raburi onaa medalomame lalo: Jon Baptais-ri matmat gimoa wala rekesa-pulu go puri mua apo kogono pamu puaaya simi. ");
INSERT INTO kew_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Goa simi pare onaa medalomame lalo: Go aare nipuna bi Elaija simi. Medalomame page lalo: Nipuri Gote-na agaa lakene aa abade pirisa yaade simi. ");
INSERT INTO kew_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Goa simi pare Herot-me pagoa gupa sa: Neme Jon-na aalu kepesu pare wala rekaade kone salo sa. ");
INSERT INTO kew_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Abadere Herot-me nipuna ore Herodias-na agaa pagoa Jon opeme adia kalabus ada mapatasa. Go aa mudumiri nipuna ame Filip-na ore Herodias paake yolo pirisa. ");
INSERT INTO kew_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Go kone isa-pulu Jon-me oro yaalo Herot gupa lakesa: Rekena ia-ga nena amena ore nayola pe sa. ");
INSERT INTO kew_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Goa sa raburi Herot-na oreme Jon-para wae kone sua tulalo pisa pare mada dia. ");
INSERT INTO kew_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Goa pisa pare Jon epe kone su redepo ne aa pirisa-pulu Herot-me nipu madaa paala omoa kalabus ada epe-rupa surubisa. Herot-me Jon-na agaa pagesa rabu nipu kone laapo isa. ");
INSERT INTO kew_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Goa pisa pare ore Herodias-me kone meda isa. Nipuna aani Herot-na agimi nipu madini di ipisa rabu eta yawo kiritasimi. Ora nipuna gavman aanu-para soldia aanu-para Galili suna aa mudunu rayo epa kiritasimi. ");
INSERT INTO kew_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Goa pisa raburi Herodias-na wane ipua Herot-na yaane aanu-para epa pirina yaasa pabesa rabu raana omesimi. Goa pisa rabu Herot aa mudu ya-pulu nogo-para lalo: Nena kone ake ya? Agaa meali yae madaa gialua. ");
INSERT INTO kew_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Goa pisa rabu Herot-me nogo-para makuaa loa gupa lakesa: Neme agaa meali rabu ake yae gialua. Nina adaa su rikiraana rumaawa oyaeyae adaapu gialua sa. ");
INSERT INTO kew_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Goa sa raburi nogome agi piri pua lalo: Ake lano ya? Agimi nogo lakeloa lalo: Jon-re baptais mi aa yaade nipuna aalu kepea meaina. ");
INSERT INTO kew_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Goa pisa rabu nogome aa mudu piri-para aipapulu pua agaa mulalo gupa sa: Neme Jon-na aalu plet madaa sua giaina. ");
INSERT INTO kew_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Goa sa raburi aa mudumi Jon odome omesa. Yapare ada makuaa agaa lo lakesa-pulu nipuna wamo pi aanu pirua adesimi-pulu neme nagimalua kone isa. ");
INSERT INTO kew_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Goa pisa raburi aa mudumi soldia-para lalo: Jon-na aalu pua kepea sa. Gore mo polis nipu kalabus ada-para pua Jon-na aalu kepisa. ");
INSERT INTO kew_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kepisa rabu plet madaa sua wane kasa rabu wanemere nipuna agi kasa. ");
INSERT INTO kew_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Goa pisa raburi disaipel aanumi pagoa ipua Jon-na ro ria pua rogaasimi. ");
INSERT INTO kew_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Goa puare disaipel aanumi Yesu piri-para wala ipua Herot-na kogono pisa-rupa agaa epa lakesimi. ");
INSERT INTO kew_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Go rabu onaa adaapu epala puala pisimi-pulu Yesu-para disaipel aanu page eta nanisimi. Goa pea-ga Yesumi nipuna disaipel aa-para lalo: Go su gimoa onaa napiri su-para pua kitu mada piramina sa. ");
INSERT INTO kew_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Goa pisa rabu nimu ipunu madaa pirua onaa napiri su-para pisimi. ");
INSERT INTO kew_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Yapare pisimi raburi onaa adaapumi nimu waru adesimi. Goa pua onaanumi adaarenu gimoa pora-nia pisimi. Goa pua go onaanumi Yesu ipunu madaa abi napenaloa nimuna piri-para aba epa kiritasimi. ");
INSERT INTO kew_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Goa pisa raburi Yesumi ipunu gimoa onaa adaapu adesa rabu nipuna pu robaa-para odome omesa. Go onaanu ora sipsip mena-rupa pa pirina yapare nimuna puni aanu napimi-daa odome omesa. Goa pua go rabu nipumi agaa adaapu mogeasa. ");
INSERT INTO kew_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Gore ora aebo rabu Yesuna disaipel aanumi ipua nipu-para lalo: Go su-para onaa ora dia ta. ");
INSERT INTO kew_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Abia ribaa tea-ga onaanu ada o taape. Goa pua nimuna eta kabola penaalo o taape. ");
INSERT INTO kew_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Goa simi pare Yesumi lalo: Nimina nimu eta katapape. Goa sa pare nimumi Yesu-para lalo: Niaame bret kabolalo palimare mone minare maali padane kogono pua mada kaboa mea katema ya? ");
INSERT INTO kew_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Goa simi rabu Yesumi nimu-para lalo: Nimina bret akepu raapo ya? Pua adalepa. Nimumi adoa gupa simi: Bret ipa supu-para ena ipa laapo ia simi. ");
INSERT INTO kew_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Goa pisimi rabu Yesumi lalo: Nimu go-pare ripu yamala madaa mapiraatepape. ");
INSERT INTO kew_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Yesumi gupa sa raburi go-para ona 100-pela kiritaawa pirala meda-para onaa gupa 50-pela kiritaawa piraa-mama pu pirisimi. Gore rado rado rayo gupa pirisimi. ");
INSERT INTO kew_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Goa pisa rabu Yesumi bret supu-para ena laapo mua yaa-para adasaawa Gote-para ora pi sa. Goa loa bret piribia disaipel aanumi onaanu rumaainalo kasa. Go ena laapo page Yesumi onaa rumaainalo kasa. ");
INSERT INTO kew_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Goa pisa rabu nimumi ora eta mada no pirisimi. ");
INSERT INTO kew_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","No kiritinaloa disaipel aanumi eta ebo yarepea basket 12-pela madu isimi. ");
INSERT INTO kew_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Goa pisa rabu aa adaapu gupa 5,000-pela eta nisimi. ");
INSERT INTO kew_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Goa pisa raburi Yesumi nipuna disaipel aa-para lalo: Ipunu madaa piralepape. Nimi ipa mone pane Betsaida su aba pulupape. Gore disaipel aanu nimu penaaloa Yesumi onaa rayo mea repaatalo pisa. ");
INSERT INTO kew_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yesumi onaa pawa pulupape lo lakeloa so rudu madaa beten ta pisa. ");
INSERT INTO kew_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Goa pua ora ribaa yabaasa raburi ipunu ipa ini madaa saabaina Yesu agu raapo so rudune pirisa. ");
INSERT INTO kew_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Go raburi disaipel aanumi ipunu yola mua ipa apea kitu pirisimi rabu Yesumi nimu adesa. Po ripu nimu polalo pisimi-nane ipisa-pulu kitu pirisimi. Gore yapi pode talo pisa raburi Yesu nimu piri-para ipa masaana ipisa. Yesuna konere nimuna ipunu gimoa mogo-nane pa pisa. ");
INSERT INTO kew_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Goa pisa pare ipa masaa-nane pamualaina nimumi Yesu ora pa remo meda kone sua pogolasaawa yaasimi. ");
INSERT INTO kew_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Yaasimi rabu nimumi adoa paala omesimi. Paala omesimi-pulu nipumi nimu-para lalo: Paala naomalepape. Ni Yesu yaade sa. ");
INSERT INTO kew_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Goa pisa raburi Yesu nimuna ipunu ru-nane pirina po ripu loraasa. Goa pisa raburi nimu pogolasaawa paalame omesimi. ");
INSERT INTO kew_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Gore disaipel aanumi bret-na kogonona re naniminaasimi. Dia, nimuna robaa-para go konena re ora namakuaasimi. ");
INSERT INTO kew_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Goa pisa raburi nimu ipa mone pane pua Genesaret su opapaawa ipunu adibasimi. ");
INSERT INTO kew_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nimumi ipunu gimisimi rabu onaanumi Yesuna ini agaa waru adesimi. ");
INSERT INTO kew_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Go rabu nimu su rayona aipapulu pisimi. Wala ipisimi raburi Yesu piri-para yaina ome onaanu reke madaa ria ipisimi. ");
INSERT INTO kew_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Goa pua orope Yesu ora oge su-paranu adaare-paranu emaapu-paranu go su rayo-para pamisa rabu onaanumi yaina ome onaa kiritae maket amaa ria ipisimi. Goa pua nimumi Yesuna mamina aane madaa oraamonalo ogesimi. Gupa oraainaloa nimuna yaina rayo maepeaasa. ");
INSERT INTO kew_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Goa pisa raburi Farisi aanu rekena agaa tisaanu page Jerusalem su-para gimoa Yesu piri kiritasimi. ");
INSERT INTO kew_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Kiritasimi raburi disaipel aa medaloma eta nolalo pirua nimuna ki amulu pimi nisimi-daa kiritae aanumi ado pirisimi. ");
INSERT INTO kew_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Gore Farisi aanu page Juda aanu page eta nolalore ki aba radepisimi. Nimuna akuana kone mogeaatalo ki radepeteme. ");
INSERT INTO kew_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Go page go Farisi aanumi maket-para kabeme eta aba radepeteme. Goa pua nimuna pora meda rado rado page ratisimi. Kone medare nimumi kopo-nupara plet-nupara kap-nupara rayo radepeteme. ");
INSERT INTO kew_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Goa pea-ga Farisi aa page rekena agaa tisaanu page Yesu agaa mulalo pisimi: Akeane nena disaipel aanumi nimumi akuana kone namogeteme pae? Nimuna kina oto pi yae naradepeaawa amulu pimi eta neme simi. ");
INSERT INTO kew_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesumi nimu-para lalo: Nimi ora makirae aanu pimi. Go madaare Gote-na agaa lakene aa Aisaia-me pepa madaa gupa tisa: Go onaanuna agaamere nina bi minasaaeme pare nimuna robaa-para ni madaa kone naimi. ");
INSERT INTO kew_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Go onaanumi pa aanuna kone mogeteme pare ora Gote-na rekena agaa page pa teme. Goa teme-pulu nimumi naa bi mada naminasaaeme. Yesumi Aisaia-na agaa gupa lakesa. ");
INSERT INTO kew_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Goa pua Yesumi nimu-para lalo: Nimi Gote-na rekena agaa gimoa yapare akuana kone mogeteme. ");
INSERT INTO kew_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesumi nimu-para lalo: Nimina kone ratulalo peme rabu kudiri kone sua Gote-na rekena agaa gimeme. ");
INSERT INTO kew_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses-me aba gupa sa: Nimina agi aaraa lapona agaa pagoa bi minasaatepape sa. Onaa rayome agi aaraa-para wae agaa teme-daare nimu ora tu maomalimi sa. ");
INSERT INTO kew_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Moses-me gupa sa pare nimimi gupa simi: Onaa rayome agi aaraanu-para lalo: mone neme saayore Gote madaa imaa niti pua saato. Goa pea-ga ama aapa naraba mealua teme. ");
INSERT INTO kew_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Goa peme-ga nimimi nimina akuanuna agaa pagoa rateme raburi Gote-na agaa rasitimi. Goa puare nimimi kogono go-rupa adaapu pa peme sa. ");
INSERT INTO kew_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Goa pisa rabu Yesumi onaa adaapu wala yaaloa saa agaame lalo: Nimi rayo pagalepape. ");
INSERT INTO kew_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nimimi epe eta nalimi rabu go etame nimi-daa mada nabebolalia. Dia, pare nimina robaa-para i koneme nimi maoyaalia. ");
INSERT INTO kew_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Onaa rayome go agaana re niminaaba piralimiri waru pagalepape. ");
INSERT INTO kew_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Goa pisa raburi Yesumi onaa gimoa ada-para epenaloa disaipel aanumi saa agaana re madaa agaa mulalo pisimi. ");
INSERT INTO kew_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Goa pua Yesumi nimu-para lalo: Nimimi nimu-rupa pirua kone naimi. Nimi ora pagalepape. Onaanumi eta nalimi-daare go nape yaeme nimu mada namaoyaalia. ");
INSERT INTO kew_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Dia-ga go etare onaana kone-para nasalia pare robaa-para pua i tapa-para pea sa. Yesumi goa sare nape eta rayore ora epe ta loa sa. ");
INSERT INTO kew_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yesumi wala lalo: Onaanuna robaa-para i koneme pupitagi manaalia. ");
INSERT INTO kew_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Gore onaanuna robaa-para i kone sua gupa peme: ona paake yolape-para paake nape kone-para aa tu maomape kone sua peme. ");
INSERT INTO kew_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Go page aanumi ona rasini meape kone-para oyae madaa epame omape kone-para waea pape kone rayo peme. Go page makirae kone-para wae yalame omape kone-para wae udipa kone-para onaanuna bi rabuaniaape kone-para aa tape kone-para pa maeyae kone page ora go rayo robaa-para kone imi. ");
INSERT INTO kew_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Go wae kone rayore kone-para sua onaa maoyaaya. Yapare eta nape yaeme gupa-daa napea sa. ");
INSERT INTO kew_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Goa pua Yesu go su gimoa kimisu Tair adaare-para pisa. Goa pisa raburi nipu ada meda-para odobaawa yapare onaanu nalakesa. Nalakesa pare nimuna pa makuaasimi. ");
INSERT INTO kew_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Gore wae remo piri nogo medana agimi Yesu pia remaa pagesa. Goa pua nipu Yesuna kibu re-para ipua rumu koba pua pirisa. ");
INSERT INTO kew_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mogo nogona agiri Siria adaare Fonisia oname madisa. Gore nipu Yesumi mo nogo-para pia remo rakepeainalo ogesa. ");
INSERT INTO kew_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Goa pisa raburi Yesumi Juda aanuna pora madaa kone sua saa agaame gupa sa: Gore aba niaame nogo naaki eta kalamina. Nogo naakina eta mua yana katemare epe kone-daa dia sa. ");
INSERT INTO kew_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Yapare mo oname Yesu gupa lakesa: Aa Mudu, ora lae pare reke rolo-para piri yananumi nogo naakina eta ebo neme. ");
INSERT INTO kew_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesumi nipu-para lalo: Gupa lae-ga nena ada-para wala pu. Wae remore nena nogo gimoa puade sa. ");
INSERT INTO kew_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Goa pua no agimi ada pua ru-nane odobaawa nipuna nogo reke madaa epe-rupa pirina adesa. Go nogo piri wae remo rakepea pane pisa. ");
INSERT INTO kew_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Goa pisa raburi Yesu Tair su-nane gimoa ipa Galili su-para wala pisa. Pamisa rabu nipu adaa su robo Saidon ru-nane pamua adaare Dekapolis-para page pisa. ");
INSERT INTO kew_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Goa pisa raburi onaa medalomame aane poa agaa maare aa Yesu piri-para mea ipisimi. Mea ipua Yesumi go yaina ae aa-na to madaa oraainalo ogesimi. ");
INSERT INTO kew_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesumi mo aa mua onaa napiri su-para mea pua kimi aane-para sua sope roa mo aa-na eke oraasa. ");
INSERT INTO kew_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Oraasa rabu Yesu yaa-para adasaawa sana odome omoa komo misa. Go rabu mo aa-para lalo: Lobape sa. Yapare Yesuna adaa agaame: Efata sa. ");
INSERT INTO kew_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Goa sa raburi mo aa-na aane malobaawa eke maepeaawa agaa epe-rupa malaasa. ");
INSERT INTO kew_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Goa pisa raburi Yesumi onaanu-para agaa natapape sa. Yapare natapape lo lakesa raburi nimumi puri paboa lakesimi. ");
INSERT INTO kew_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Apo remaa pagesimi onaanumi Yesumi goa pisa-daa ora paalame omoa kidipaa ragi tua lalo: Mogo aame oyae rayo epe-rupa pea. Aane poae aa page agaa maare aa page nipumi epe-rupa maperekeaaya simi. ");
INSERT INTO kew_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Gore orope onaa adaapu epa kiritasimi. Orope nimuna eta dia sa rabu Yesumi nipuna disaipel aanu-para yaaloa lalo: ");
INSERT INTO kew_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Go onaanu yapi repome ni raapu piraama pare eta naname-pulu ni odome omalo. ");
INSERT INTO kew_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Neme nimuna adaa penaatoare reae pua pora-nia lopalimi. Onaa medalomare pora adaalu-para epame. ");
INSERT INTO kew_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nipuna disaipel aanumi nipu-para lalo: Gore go suri onaa napimi-ga niaa aa-para pua bret kaboa nimu rumaalima ya? ");
INSERT INTO kew_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesumi nimu-para lalo: Nimina bret akepu raapo ia? Nimumi lalo: 7-pela ia simi. ");
INSERT INTO kew_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Go rabu Yesumi onaa rayo su madaa mapiraasa. Goa pua Yesumi bret 7-pela mua Gote-para ora pi loa sana piribia nipuna disaipel aanu kasa. Yesumi kanaloa nimumi muare onaa rumaawa kata pisimi. Goa pua disaipel aanumi rumaasimi. ");
INSERT INTO kew_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Goa pisimi raburi disaipel aanuna ena ogepusi page madu isimi. Go page Yesumi mua sana ora pi loa onaa-para rumaatepape. ");
INSERT INTO kew_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Goa pisa raburi nimu eta ora waru no pirisimi. Eta nabenaloa ebore basket 7-pela yarepea madu isimi. ");
INSERT INTO kew_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Go raburi onaanuri 4,000 pirisimi. ");
INSERT INTO kew_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Goa pua orope Yesumi nimu rapaasa. Pisimi raburi Yesu page nipuna disaipel aanu page ipunu madaa pirua Dalmanuta su robo ru-nane pisimi. ");
INSERT INTO kew_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Go-para pirina Farisi aanu medalomame Yesu piri-para ipua arere pisimi. Nimumi Yesu ko tulalo ipua napiaa kogono mada pali yapalo lakesimi. Go adalimare Gote-me puri ne guaaya-daa niminaalima simi. ");
INSERT INTO kew_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Goa simi pare Yesumi nipuna pu robaame komo mu rubua gupa sa: Akeane go padane rabu onaanumi napiaa kogono asapeme pae? Ni ora lalo: Nimimi ora mada na-adalimina sa. ");
INSERT INTO kew_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Goa pua nipumi go onaanu gimoa ipunu madaa pirua disaipel aanu raapu ipa mone pane kenaasimi. ");
INSERT INTO kew_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Gore ipa mone pane pisimi pare disaipel aanumi kone rugulaawa bret namea isimi. Go kone rugulaawa nimumi bret ipa padane agu ipunu-para mea isimi. ");
INSERT INTO kew_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Go rabu Yesumi saa agaame nimu-para lalo: Pagalepape. Farisi aanu-para Herot-para nimuna bret ma-adaa yaape yis waru adalepape. ");
INSERT INTO kew_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Yesumi goa sa raburi nimumi gupa lala pirisimi: Niaa bret naima simi. ");
INSERT INTO kew_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Goa pisa raburi Yesumi nimu adoa mua nimu-para lalo: Niaa bret naima teme-ga akolo teme pae? Nimi abi naniminaaeme? Nimi kone naimi? ");
INSERT INTO kew_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nimina inimiri na-ademe? Nimina aaneme agaa napageme? Gore nimimi kone rugulaeme pae? ");
INSERT INTO kew_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Neme bret supu piribia onaa adaapu gupa 5,000-pela giawade raburi nu eta ebonu akepu raapo yarepea madu isimi ya? Nimumi 12-pela simi. ");
INSERT INTO kew_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Goa simi rabu Yesumi wala lalo: Go page onaa adaapu gupa 4,000-pela bret 7-pela giawade raburi nu akepu raapo yare pea madu isimi ya? Go rabu nimumi 7-pela madu isima simi. ");
INSERT INTO kew_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Goa simi raburi Yesumi nimu lakesa: Goa pawade pare abiare naniminaaeme? ");
INSERT INTO kew_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Goa pua nimu Betsaida su-para pisimi. Go rabu onaa medalomame ini rubu pi aa Yesu piri-para mea ipua lalo: Go aa oraape lo ogesimi. ");
INSERT INTO kew_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Goa pua Yesumi ini rubu pi aa-na ki mua ada gaa-nane lamua pisa. Goa pisa raburi Yesumi mo aa-na ini-para sope rapiaawa ki tone oraawa agaa misa: Ne oyae ade pae? ");
INSERT INTO kew_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Goa sa raburi mo aame adoa lalo: Neme aa adalo pare nimu pamualeme raburi repena nona pea. ");
INSERT INTO kew_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Goa sa rabu Yesumi nipuna ini wala oraainaloa waru perekea adesa. Adesa raburi mo aame oyae rayo pa epe-rupa adesa. ");
INSERT INTO kew_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Goa pua Yesumi mo aa penalo repaawa lalo: Nena ada puare adaare-para wala napope sa. ");
INSERT INTO kew_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Goa pua Yesu nipuna disaipel aanu raapu Sisaria Filipai su lapo-nane pamisimi. Pamisimi raburi Yesumi nipuna disaipel aanu-para agaa gupa misa: Onaanumi ni aapi teme? ");
INSERT INTO kew_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nimumi nipu-para lalo: Gore onaa medalomame nere Jon Baptais teme. Medalomame nere Gote-na agaa lakene aa Elaija teme. Medalomame nere Gote-na agaa lakene aa meda teme. ");
INSERT INTO kew_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Goa pua Yesumi nimu-para wala lalo: Ora lae pare nimimi ni aapi kone imi? Pita-me nipu-para lalo: Ne ora Onaa Raapu Pirape Aa-na Si Krais yaade sa. ");
INSERT INTO kew_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Goa sa raburi Yesumi nimu-para onaa rayo nalaketapape sa. ");
INSERT INTO kew_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Goa pisa raburi Yesumi nimu gupa mogeasa: Ni Onaa Raapu Pirape Aa-na Si radaa waru no piralua. Gore kone makuaae aanumi page Gote-na miru irape aa mudunu page rekena agaa tisaanu page nimu rayome ni gimalimi. Nimumi ni Yesu tu maomalimi pare yapi repo dia naloa wala rekalua. Yesumi agaa gupa mogeasa. ");
INSERT INTO kew_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesumi nimu-para apo agaana re waru lakesa. Goa sa rabu Pita-me Yesu-para lalo: Ne talimi agaa gupa nalape sa. ");
INSERT INTO kew_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Goa sa pare Yesumi pereke tua nipuna disaipel aanu adesa rabu Pita-para ratu yawoa lalo: Ne Satan-na kone ia-ga nemere ni gimape. Ne Gote-na kone nai pare ne su amaanuna kone i sa. ");
INSERT INTO kew_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Goa puare Yesumi onaanu page disaipel aanu page yaaloa lakesa: Oropere onaa rayome ni rata mea epalimi-daare repena polopeana kedaa rua nimuna kone gimoa ni rata mea ipulupape sa. ");
INSERT INTO kew_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Onaa rayome nimuna yogane surubalimi-daare oro yaalo alupalimi. Pare onaa rayome ni madaa page epe agaa madaa nimuna kone gimalimi-daare oro yaalo piralimi. ");
INSERT INTO kew_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Pa aa medame su rayona mone yoto mealia pare nipuna kone wasupa gimaliare go kone epe ta? Dia sa. ");
INSERT INTO kew_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Goa pua go aame kone wasupa ora wala mada mealia ya? Mada dia sa. ");
INSERT INTO kew_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Goa pea-ga abia go pupitagi no Gote gimape di rabu onaa rayome ni-para epe agaa lapo masaa rilalimi-daare neme nimu page gimalua. Oropere ni onaa Raapu Pirape Aare epe ensel-nupara Aapana epe puri raapu epalua-ga go rabu gimalua sa. ");
INSERT INTO kew_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Goa pua Yesumi nipuna disaipel aanu-para onaanu medaloma-para page lalo: Neme nimi-para ora lalo: Go-para pimi onaa medaloma naomalimi pare nimumi aba Gote-na Surube Su-na puri mea epaliade adalimi sa. ");
INSERT INTO kew_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Wala yapi oraapu dia naloa Yesu-para Pita-para Jems-para Jon-para nimu padane-para so rudu madaa pisimi. Gore Yesumi to rado aawa pisa-daa adesimi. ");
INSERT INTO kew_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Goa pisimi raburi nipuna mamina-nu yaako pua lepo lepo atasa. Go yaako pu tisa rabu mamina rayo yaako pisa-rupare aa meda mada napia-rupa pisa. ");
INSERT INTO kew_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Goa pisa rabu Elaija page Moses page ipua sipina Yesu raapu agaa epa sipi. ");
INSERT INTO kew_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Goa pua Pita-me Yesu-para lalo: Tisaa, niaa go-para pimare epe ta. Pokaalo ada repo pamina. Medare nena medare Moses-na medare Elija-na wariamina. ");
INSERT INTO kew_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Gore Pita nimu page paala omoa ake teme pae kone isimi-pulu apo agaa sa. ");
INSERT INTO kew_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Go rabu moae medame naare maudinae ru-para pirisimi. Go yaa-para moae raapu agaa gupa pagesimi: Gore ora nina epe Si. Neme nipu madaa pedo pi. Nipuna agaa pagalepape sa. ");
INSERT INTO kew_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Goa sa raburi disaipel aanumi aipapulu pereke tua adesimi pare Yesu padane adesimi. ");
INSERT INTO kew_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nimu pore kilipisimi raburi Yesumi nimu-para lalo: Onaa meda-para nimimi abia adamede yaere remaa natapape. Ni Onaa Raapu Pirape Aana Siri aba matmat-para madaa rekalua. ");
INSERT INTO kew_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nimumi nipuna agaa pagesimi pare nimuna agaa gupa lo pirisimi: Go agaa ni matmat-para rekalua agaare ake agaa ya? ");
INSERT INTO kew_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Goa pua nimumi Yesu-para lalo: Rekena agaa tisaanumi gupa teme: Elija-me oyae managola sua aba epena teme. Go agaana re ake ya? ");
INSERT INTO kew_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Goa simi raburi Yesumi nimu-para lalo: Elija-re oyae rayo amege pulalo aba epalia. Goa pea pare Gote-na buk madaare Onaa Raapu Pirape Aa-na Si niri radaa aba waru no piralua. Goa pua onaanumi ni gimalimi. Go agaana re niminaaeme? ");
INSERT INTO kew_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Yapare neme nimi lagialo: Elaija aba ipisa pare go rabu onaanumi nimuna wae kone sua pirisimide sa. Gote-na buk madaare Elaija tulalo peme lagisa. ");
INSERT INTO kew_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Gore Yesu-para disaipel aanu ipa repo wala disaipel aa medaloma raapu kiritaawa onaa adaapu adesimi. Go rabu disaipel aa medalomame rekena agaa tisaanu-para agaa lape arere pisimi. ");
INSERT INTO kew_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Go pirisimi onaanumi Yesu adoa paala omoare aipapulu ipua ki kasimi. ");
INSERT INTO kew_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Kasimi raburi Yesumi nimu-para agaa gupa misa: Ake madaa arere pu pimi? ");
INSERT INTO kew_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Go agaa misa rabu go onaa adaapuna rikiraana pirisa aame lalo: Tisaa, nina naaki ne piri-para mea epawa. Go naaki madaa remo pia-pulu agaa maarea. ");
INSERT INTO kew_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Remome naaki yolo ria pea rabu malopaawa agaa yarua rako sope madu to puri pata sa. Neme disaipel aa-para maepeaape lawade pare nimu mada dia lamede. ");
INSERT INTO kew_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Goa sa raburi Yesumi onaanu-para lalo: Nimiri epe agaa rasini onaa pimi. Ni nimi-para oro di akepu raapo pa piralua ya? Neme nimi-para rana akepu raapo kogono waatoa ya? Go naaki mea ipu. ");
INSERT INTO kew_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Go lakenaloa naaki Yesu piri mea ipisimi. Remome Yesu adesa raburi naaki mapururu mapaawa naaki su amaa malopaasa. Goa pua pereke pereke lalaawa rako sope madisa. ");
INSERT INTO kew_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Go pisa raburi Yesumi go naakina aaraa-para lalo: Go yaina maali akepu raapo ia? Aaraame lalo: Oge naaki pirisa rabu pisa. ");
INSERT INTO kew_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Remome go naaki tulalore repena sulaa-para page ipa-para page mea malopaawa yogane maoyaatalo pea. Goa pea pare neme niaa madaa odome omoa raba meali palo maarea. ");
INSERT INTO kew_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Goa sa rabu Yesumi lalo: Neme mada palua palo maarea lae ya? Aa medame naa agaa robaa-para madiaalimiri oyae rayo ora mada palua. ");
INSERT INTO kew_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Goa sa raburi aaraame aipapulu yaaloa robaa-para agaa namaditu-ga ni raba meape sa. ");
INSERT INTO kew_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Gore Yesu onaa rayome nipu epa kiritaawa kuta pubasimi adesa-pulu wae remo-para puri pane agaa gupa sa: Ne aane poae agaa maare ne wae remore neme puri pane agaa lagialo: Mo aa nipu rakepea nipu-para wala naepa pirape sa. ");
INSERT INTO kew_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Goa sa raburi mo remome e loa naaki mapururu pawa pisa. Goa pisa raburi mo naakina to kogore sa-daa onaa medalomame lalo: Nipu ini adupiaade simi. ");
INSERT INTO kew_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yapare Yesumi nipuna ki mua marekaasa. Goa pisa raburi rekatabisa. ");
INSERT INTO kew_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu ada-para wala pisa raburi disaipel aanumi onaa napimi rabu agaa mulalo pisimi: Akeane niaana aba mada nama-rakepeaarima pae simi. ");
INSERT INTO kew_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesumi nimu-para lalo: Remo gupianere beten-me agu mada marakepaalia. Kone oyae medalomame mada dia sa. ");
INSERT INTO kew_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nimumi go su gimoa Galili su robo ru-nane pamisimi. Pamisimi pare onaanumi nipu wala mada na-adalimilo Yesumi nimu nalakesa. ");
INSERT INTO kew_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Nipumi disaipel aanu agaa rado mogeasa-pulu kaleda pirisimi. Nipumi gupa mogeasa: Ni Onaa Raapu Pirape Aa-na Siri orope iaanumi tinalo mea kateme sa. Tinaloa wala yapi repo dia naloa rekalua sa. ");
INSERT INTO kew_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Goa sa pare disaipel aanumi nipuna agaana re naniminaasimi. Goa pisimi pare paala omesimi-pulu agaa meda namisimi. ");
INSERT INTO kew_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Go rabu nimu su Kapaneam-para pisimi. Go rabu Yesumi ada pua pirua nimu-para agaa gupa misa: Niaa pora puamade raburi ake madaa arere pame ya? ");
INSERT INTO kew_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Goa sa pare nimumi agaa meda nasimi-para pora-nia pulaawa aapi ora aa mudu pirua yapae arere pisimi. ");
INSERT INTO kew_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Go rabu Yesu nipu pirua disaipel aa 12-pela ipulupa sa. Nipumi nimu-para lalo: Aa medame ni riri-nane aba piralua kone saliare gore nena kone gimoa onaa rayo raba meape aa aba pirape. ");
INSERT INTO kew_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Go sa raburi Yesumi naaki meda ipu loare nimu piri rikiraana mea mapiraasa. Go rabu nipumi go naaki upia sana nimu-para lalo: ");
INSERT INTO kew_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Onaa rayome go nogo naakinu padane epe-rupa mua raba mealimi-daare ni page go kone salimi. Onaa rayome ni epe-rupa mua mealimi-daare nimumi ni mea o taae Aapa page mealimi sa. ");
INSERT INTO kew_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon-me Yesu-para lalo: Tisaa, aa medame nena bimi aa medana wae remo pane mea rakepeaaria. Goa paa pare niaa raapu napima-ga niaame goa napape lama. ");
INSERT INTO kew_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Goa sa pare Yesumi lalo: Nipu namagimaape. Aa medame naa bi-para napiaa palia-daare orope nipumi ni madaa wae agaa mada natea. ");
INSERT INTO kew_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Gore onaa rayome niaa madaa iaa na-aulaliare gore niaana adami aa pitimi. ");
INSERT INTO kew_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Pagalepa. Onaa rayome nimi ni Krais-na nogo naakinu adoa epe nape ipa gialimi-daare nimuna epe yoto waru mealimi sa. ");
INSERT INTO kew_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Go oge nogo naaki meda ni madaa kone rulalimi-daare onaa medame nimuna kone rulae bebolaliare ora o ta. Bebolalia-daare go onaana maa-para adaa aana madu mudiaawa ipa-para lopaliare ora epe ta. ");
INSERT INTO kew_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Yesumi saa agaa gupa sa: Gore nena kimi ne pupitagi manaaliare mea kepe poape. Ki kepene aa-rupa pirali-daare epe ta pare epe ki lapo paina wae repena sulaa-para piraliri ora o ta sa. ");
INSERT INTO kew_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Go adaa repena sulaa-parare onaana eteto piri yaenu naomea mo repena sulaa pa ralaina. ");
INSERT INTO kew_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Nena aame ne pupitagi manaaliare go page nena aa kepe poape. Go sune aa ruguloa piraliri gore epe ta. Goa pea-ga epe aa lapo rata paina pirua wala repena sulaa-para piraliri ora o ta. ");
INSERT INTO kew_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Go adaa repena sulaa-para onaana eteto piri yaenu repena sulaa-para ralalia. ");
INSERT INTO kew_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Go page nena inimi ne pupitagi manaaliare rasu rubape. Gore ini kalae rubu pi aa-rupa pirua Gote-na Surube Su pua adali-daare epe ta. Goa pea pare epe ini laapo pa apalae pirina repena sulaa-para mea rubalimiri ora o yalia. ");
INSERT INTO kew_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Go adaa repena sulaa-parare onaana eteto piri yaenu naomalia pare repena sulaa pa roalia. ");
INSERT INTO kew_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Gore onaanumi pagalepa: Repena sulaare ora puri ia-rupa page aipa puri ia-rupa page nimimi Gote-na puri pane agaa pagoa waea pape kone rabuaniaatepape. ");
INSERT INTO kew_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sol-re ora epe ta pare nipuna rede dia yalia rabu wala ake palima ya? Nimina aipa-rupa rede masaawa robaa-para kuma mapaawa onaa raapu epe-rupa piralepape sa. ");
INSERT INTO kew_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu go su gimoa Judia su robo ru-nane pua ipa Jordan mone pane kenaawa pisa. Go rabu onaa adaapumi nipu piri-para wala epa kiritasimi. Goa pisimi raburi nipuna pisa-rupa onaanu wala lakesa. ");
INSERT INTO kew_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Goa pisa raburi Farisi aanumi Yesu ko tulalo ipua makirae agaa gupa lakesimi: Gore niaana rekena agaa madaare aa medame ore gimalia-daare go kone epe ta simi. ");
INSERT INTO kew_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Goa simi raburi Yesumi nimu agaa gupa misa: Moses-me nimi-para ake lagisa ya? ");
INSERT INTO kew_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Yesumi goa sa rabu nimumi lalo: Aa medame ona gimalia-daare Moses-me go aame pepa mada rugutepe lakesa. ");
INSERT INTO kew_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Goa simi pare Yesumi agaa gupa misa: Nimimi agaa waru napageme-ga Moses-me pepa madaa agaa mana go-rupa gisa. ");
INSERT INTO kew_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pare aba su yaa laapo warisa raburi Gote-me ona aa laapo warisa. ");
INSERT INTO kew_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Goa pisa-pulu aa medame nipuna aaraa agi gimoa nipuna ore raapu ora padane-rupa piralepape. ");
INSERT INTO kew_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Goa pua nipu laapo dia yapare ora padane piralipina. ");
INSERT INTO kew_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Goa pua Gote-me repaaya padane mapiraasa-pulu aa medame mada narugulatepape sa. ");
INSERT INTO kew_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Gore nimu ada-para wala pua disaipel aanumi Yesu mo ona rasini madaa wala agaa misimi. ");
INSERT INTO kew_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Goa pua Yesumi nimu-para lalo: Aa medame nipuna ore gimoa ona rado meda rumaalia-daare go aame ona paake lami ona mapiraalia. ");
INSERT INTO kew_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Go page oname aani gimoa aa meda palia-daare go oname page nipuna aa paake rume kone sua palia sa. ");
INSERT INTO kew_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Onaa medaloma Yesumi nogo naaki kimi oraainalo nipu piri-para mea ipisimi. Yapare nipuna disaipel aanumi mo onaanu-para ape simi. ");
INSERT INTO kew_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesumi nipuna disaipel aanuna kone adoa nipumi ratu yawoa nimu-para lalo: Nogo naaki ni piri-para mea epenawa. Gote-na Surube Su-parare nogo naaki-rupa piralimi-daa mealimina. ");
INSERT INTO kew_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Pagalepa. Onaa rayome Gote-na Surube Su adolalo pimiri nimu aba nogo naakina kone mada mua adalimi sa. ");
INSERT INTO kew_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Goa sa raburi Yesumi no go naaki upiaawa kimi oraawa epe raba mi agaa lakesa. ");
INSERT INTO kew_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu pora wala polalo pisa rabu aa meda aipapulu ipua Yesu madaa rumu koba pua agaa mulalo: Epe Tisaa, ni oro yaalo kagaa piraama laama pope kone mulalore ake palua pae? ");
INSERT INTO kew_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Goa sa raburi Yesumi nipu-para lalo: Gote nipu padane ora epe ta-ga akeane ni epe aa lae ya? ");
INSERT INTO kew_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ne Gote-na rekena i agaa napage? Go-rupa ia: Neme onaa meda natu maomape. Ona meda paake nayolape. Neme paake nanape. Onaa-para yaa agaa nalape. Onaa medana oyae mulalo makirae agaa nalape. Nena ama aapa laapona bi minasaawa agaa waru pagalepape. ");
INSERT INTO kew_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Go raburi nipumi Yesu-para lalo: Tisaa, go rekena agaa rayore ni oge naaki rabu page abia page pago mogeto sa. ");
INSERT INTO kew_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Go rabu Yesumi nipu-para raana omoa adoba sua gupa sa: Ne kone padane nai. Nena oyaenu pua mua mone yoto mua onaa naraanu kala. Go rabu so yaa-para epe yae meaina-ga ni rata mea epape. ");
INSERT INTO kew_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yesumi goa sa raburi go aa-na oyaeyae adaapu isa-pulu nipuna ini agaa adaniaawa kedaame omoa pisa. ");
INSERT INTO kew_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Goa pisa raburi Yesu pereke tua nipuna disaipel aanu adoa nimu-para lalo: Aa amopere Gote-na Surube Su polalore ora kalai peme. ");
INSERT INTO kew_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Goa sa-pulu disaipel aanumi paalame omesimi. Yapare Yesumi nimu-para saa agaame wala lalo: Naa naakinu-ga waru pagalepape. Onaa rayome Gote-na Surube Su adolalo peme pare kedaa waru pea sa. ");
INSERT INTO kew_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Gore kamel menare noi kego-para palia yaalore kalai napea. Yapare aa amope Gote-na Surube Su-para polalore kamel menana kalai maoge yaalia. ");
INSERT INTO kew_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Goa sa raburi disaipel aanumi pogolasaawa gupa lala pirisimi: Gore aapimi mada oro yaalo kagaa piraama laama palia ya? ");
INSERT INTO kew_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesumi nimu waru adabaawa lalo: Onaanumiri yae medaloma mada napalimi. Yapare Gote-mere onaa raba meape kogono rayo mada pea. ");
INSERT INTO kew_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Go rabu Pita-me Yesu-para lalo: Ada, niaame oyae rayo gimoa ne rata mea epame. ");
INSERT INTO kew_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Yesumi nimu lakesa: Ni ora lae-daa pagalo. Onaa rayomere nimuna ada page ame page baani page ama aapa page nogo naaki page su page ni-para epe agaa-para ratulalo gimalia-daare nipu yago tu yoto waru mealimi. Goa pua abiare nimumi ora adanu page amenu page baaninu page amanu page nogo naakinu page yoto rado rulatabena mealimi. Goa pea pare kedaa raapu mealimi sa. Goa pua orope kagaa su-para oro yaalo piralimi sa. ");
INSERT INTO kew_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Onaa adaapu abia riri-nane pimi pare go onaanuri orope masaa-nane piralimi. Goa pua abia orope piri onaanuri aba riri-nane piralimi. ");
INSERT INTO kew_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nimu so Jerusalem su-para pora pamisimi. Goa pua Yesu aba pisa rabu disaipel aanumi paala omesimi. Go onaa medaloma nimu raapu pamisimi rabu nimu page paala omesimi. Go rabu nipumi disaipel aa 12-pela mo-nane ogesi pua nimu-para orope epaliade yae madaa agaa lakesa. ");
INSERT INTO kew_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Yesumi nimu-para lalo: Gore niaa so Jerusalem su-para baina. Go-parare pa onaanumi Gote-na Miru Irae Aa mudunu page Gote-na agaa ne tisaanu page nimumi ni Onaa Raapu Pirape Aa-na Siri lamu mealimi. Go rabu go aanumi tu maomape koso agaa laketeme rabu ruru radome lamu mealimi. ");
INSERT INTO kew_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Go raburi nimumi ni-para ero loa sope rapiaawa repena unimi tu maomalimi sa. Go palimi pare yapi repo dia naloa wala rekalua sa. ");
INSERT INTO kew_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Go rabu Sebedi-na si Jems Jon lapo Yesu piri-para ipua lalo. Tisaa, saame ne agaa mulalo pipa yaere neme ora painalo sipi. ");
INSERT INTO kew_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Goa sipi raburi Yesumi nipu-para lalo: Gore nipina kone-para neme ake palua ya? ");
INSERT INTO kew_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nipumi Yesu-para lalo: Goa pape. Nere nena epe pirape siaa king madaa pirua surube aa pirali rabu saa page pirapana. Meda nena popo ki-nane pirina meda nena koya ki-nane pirina sipi. ");
INSERT INTO kew_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yapare Yesumi nipu-para lalo: Nipi go siaa mulalo pape yaere nipi namakuaaepe. Naa ipa naluade pe ipa-rupa radaa raapu mada nalipi ya? Niri baptais mealua-rupa nipiri go-rupa baptais mada mealipi ya? ");
INSERT INTO kew_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nipu laapome nipu-para lalo: Saa mada sipi. Yesumi nipu-para lalo: Neme nalua ipa pere go-rupa mada nalipi. Go page nina mealua baptais go-rupa mada mealipi. ");
INSERT INTO kew_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Go mada palipi pare nina popo ki-nane page koya ki-nane mapiraape konere neme agaa mada nalagialua. Go-para pirapere Aapa padaneme nipuna tea sa. ");
INSERT INTO kew_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Gore disaipel aa medalomame go agaa pagoare mo ameaya Jems Jon laapo-para ratu yawesimi. ");
INSERT INTO kew_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Goa pisimi-pulu Yesumi nimu rayo yaaloa lalo: Ruru radona aa mudunumi nimuna onaanu madaa puri paloa nimuna koneme peme. Nimumi go onaanu waru surubaeme. ");
INSERT INTO kew_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Goa peme pare nimuna kone agaa namogealepape. Nimina padaneme aa mudu pirano kone salia-daare go aare nipu nimi aba raba mealia. ");
INSERT INTO kew_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Go page nimina padane aba riri-nane polalore nipu aba kogono aa-rupa piralia. ");
INSERT INTO kew_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ni Onaa Raapu Pirape Aa-na Siri onaanumi nina kogono paminalo naipisu pare onaa raba mulalo ipisude. Nina kone wasupame onaanuna wae kone mea rubatalo ipisude. ");
INSERT INTO kew_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nimu Jeriko su-para ipisimi. Gore Yesu page nipuna disaipel aanu page onaanu page Jeriko su gimisimi raburi aa meda Bartimeus-miri pora aane-nane pirisa. Go aare ini rubu pi aa pirua mone ogetalo pirisa. Nipuna aaraare Timias yaade. ");
INSERT INTO kew_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Gore mo aare nipu Nasaret su-para piri aa Yesu epaa remaa pagesa-pulu nipumi gupa yaasa: Yesu-ya, Devit-na si-ya. Ni odome omape. ");
INSERT INTO kew_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Goa sa raburi onaa medalomame nipu ratu yawoa agaa nalape simi. Goa simi pare nipu ora puri paloa wala yaasa: Devit-na si ni odome omape. ");
INSERT INTO kew_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Go rabu Yesumi pa aawa onaanu-para lalo: Go aa mea ipu lo lakesa. Nimimi ini rubu pi aa-para yaaloa lalo: Paala naomape. Ne yaata-ga reka pu simi. ");
INSERT INTO kew_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Goa simi raburi mo aa mamina kolo rubua aipapulu rekoa Yesu piri pisa. ");
INSERT INTO kew_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Goa pua Yesumi nipu-para lalo: Nena konere neme ne-para ake palua ya? Ini rubu pi aame nipu-para lalo: Epe Tisaa, nina ini maepeaaina oyae adaluame pi. ");
INSERT INTO kew_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesumi nipu-para lalo: Abi pu. Nina agaa robaa-para maodaawa kone rulaari-pulu nena inimi oyae mada adali. Ora goa sa raburi mo aa-na ini epe sa rabu nipu Yesu rata mea pisa. ");
INSERT INTO kew_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Goa pua nimu Rudu Oliv-na pora-nia ipua su Jerusalem su-na oge adaare su Betfasi-para su Betani laapo re-para ipisimi. Ipisimi rabu Yesumi nipuna disaipel aa laapo mea rapaasa. ");
INSERT INTO kew_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Go rabu nipumi nipu-para lalo: Mogo-nane su adaare-para pulupa. Go-parare donki mena meda adibaliare koloa mea ipulupape. Go donki menare nipuna masaana onaanu abi napiri. ");
INSERT INTO kew_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Onaa medalomame ne-para go donki mena akeane mea pali pa temere goa tapape: Adaa Aame go menana kogono saliare wala gialia la tapape sa. ");
INSERT INTO kew_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Goa sa raburi nimu pora pua donki mena meda adesimi. Go donki mena aba medana pora gaape uni-para aina repaasimi. ");
INSERT INTO kew_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Go rabu go-para reko aasimi onaanumi nimu-para lalo: Akeane go mena iti kote ya? ");
INSERT INTO kew_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Goa simi raburi Yesuna sade agaa lakesimi. Goa pua nimumi pina mea pulupape simi. ");
INSERT INTO kew_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Goa pua nimumi donki mena Yesu piri mea ipua nimuna mamina-nu mena masaana inaloa Yesu pirisa. ");
INSERT INTO kew_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Goa pisa raburi onaame mamina-nu pora-nia rabolasimi. Medalomame maapu-nini repena palaa yo laapo poa pora-nia rabolabaama ipisimi. ");
INSERT INTO kew_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Goa pua riri-nane onaanu-para aapu-nane ipisimide onaanumi page gupa yaasimi: Gote-na bi minasaamina. Go aare Gote-na bi madaa ipula-ga Gote-na adaa bi kalamina loa yaasimi: ");
INSERT INTO kew_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Niaana akua Devit-na Surube Su epalia Gote-me puri kalaina. Gote-na bi minasaamina simi. ");
INSERT INTO kew_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Goa pua Yesu Jerusalem su-para pua Juda aanuna epe lotu ada-para oyae adola pisa. Nipumi oyae adabaawa ribaa sa rabu nipu aa 12-pela raapu Betani su-para pisimi. ");
INSERT INTO kew_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Goa pua wala ekeraa-nane Betani su-para aawa ipisimi raburi Yesu reame omesa. ");
INSERT INTO kew_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Reame omesa raburi nipumi mo-para aaya repena fik-na yo adoare ini etea palo adola pisa. Go ini ratalo pisa raburi nipumi ini naetisa yo agu aasa adesa. ");
INSERT INTO kew_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Goa adesa-pulu Yesumi repena-para agaa gupa lakesa: Nena ini meda ora mada namadiali. Goa sa raburi disaipel aanumi go agaa pagesimi. ");
INSERT INTO kew_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nimu Jerusalem su-para opapasimi rabu Yesu epe lotu ada ru-nane odobasa. Goa pua nipumi lotu ada-para bisnis rome pi aanu mea ratisa. Go rabu nipumi mone ropo pi aanuna reke lakepe rubebe pua oyae rome pi aanuna reke page pua lakepe rubebe pisa. ");
INSERT INTO kew_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Goa puare onaanumi lotu ada ru-para oyae ritalo ipisimi rabu Yesumi rekena isa. ");
INSERT INTO kew_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Goa pisa raburi nipumi nimu-para agaa moge riaawa lalo: Gote-na pepa madaa gupa tu isa: Su rayona piri onaanumi naa ada ora Gote-para beten lape ada tu isa. Yapare nimimi paake ne aanuna kaledape ada-rupa perekea ma-arimina sa. ");
INSERT INTO kew_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Goa sa raburi Gote-na miru irae aa mudunumi page rekena tisaanumi page pagoa nimumi Yesu tu maomalima kone isimi. Goa pisimi pare onaa rayome Yesuna epe agaa madaa raana omoa pogolasaasimi-pulu go aanumi Yesu mada natisimi. ");
INSERT INTO kew_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ribaa Yesuna disaipel aanu raapu go adaare gimisimi. ");
INSERT INTO kew_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Goa pua wala ekeraa-nane yapipu nimu pora-nia pisimi rabu nimumi mode repena fik aasa adesimi. Go adesimi raburi repena page no repena pitaa page aba kaapu saaya. ");
INSERT INTO kew_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Goa pisa raburi Pita-me abade sade kone saapirua Yesu-para lalo: Tisaa ada, go yaina ape laede go repena fik ora kaapu ta. ");
INSERT INTO kew_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Yesumi nimu-para agaa lakesa: Pagalepape. Gote-na agaa robaa-para kone rulaatepape. Nimimi mogo pore-para ne rekaawa ipa-para pua pogola teme-daare goa mada palia. Yapare agaa gupa teme rabu robaa-para kone laapo sua kone waru narulalimi-daare goa mada napalia. ");
INSERT INTO kew_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Goa pea-ga neme nimi-para lalo: Nimimi oyae mulalo beten teme rabu ora mealima kone rulalimi-daare oyae ora mada mealimi. ");
INSERT INTO kew_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Go page nimi beten talore nimimi onaa meda madaa wae kone imiri mea rubatepape. Goa pua nimina so yaa-para pia Aapa nipumi page nimina pupitagi mea rubalia. ");
INSERT INTO kew_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Yapare onaa medalomana pupitagi namea rubalimiri yaa-para pia Aapame abuna nimina pupitagi namea rubalia sa. ");
INSERT INTO kew_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Goa pisa raburi nimu Jerusalem su-para wala pisimi. Yesu lotu ada-para pamualaina Gote-na miru irae aa mudunu page Gote-na agaa lae tisaanu page makuaae aanu page Yesu piri-para ipua lalo: ");
INSERT INTO kew_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Gore aapina puri mua neme kogono pe simi. Go kogono pe-ga aapimi puri guaaya? ");
INSERT INTO kew_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesumi nimu-para lalo: Neme page nimi-para agaa padane agaa mealuame pi. Agaa yago talimi rabu neme kogono pape puri aapimi gisare nimi madaa lagialua. ");
INSERT INTO kew_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Agaa abutapa. Jon-re baptais meape lo puriri Gote-me kasa pae onaanumi kasimi pae? Go agaa abutapa. ");
INSERT INTO kew_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Goa sa raburi nimuna arere pisimi. Gore niaame Gote tema-daare nipumi akeane Jon-na agaa madaa kone narulaeme pae tea. ");
INSERT INTO kew_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Yapare niaa aanumi puri kasa tema page mada dia. Goa simiri nimumi onaanu madaa paalame omoa simi. Gore onaa rayome Jon ora Gote-na agaa lakene aa pirisa-daa kone rulaeme-pulu mo aanu paalame omesimi. ");
INSERT INTO kew_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Goa pua nimumi Yesu-para agaa gupa lakesimi: Niaa maarea simi. Goa simi-pulu Yesumi nimu-para lalo: Gupa teme-ga aapina puri mua kogono pere nimi page nalagialua sa. ");
INSERT INTO kew_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Go raburi Yesumi nimu-para saa agaa meda gupa sa: Aa medame nipuna wain ini maapu poasa. Go rabu nipumi kepo waru pua naaku pu sua ini igipi sape warisa. Goa puare nipumi surubape ada meda warisa. Goa pua nipumi mone yoto meape aanumi surubenalo pora kimisu pisa. ");
INSERT INTO kew_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Gore wala ini etesa raburi go maapuna aaraame kogono aa meda mo maapu surubape aanu piri-para mea rapaasa. Maapuna aaraana mone yoto meainalo kogono aa mea rapaasa. ");
INSERT INTO kew_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Goa pisa pare maapu surubape aanumi kogono aa ripinaawa tua repaasimi. Repaasimi pare mone yoto nakasimi. ");
INSERT INTO kew_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Goa pisa raburi kogono aa rado meda mea rapaasa. Nipumi mone yoto mula pisa rabu nimumi go aa-na aalu tua wae yae pisimi. ");
INSERT INTO kew_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Goa pua maapuna aaraame kogono aa meda mea rapaasa rabu tu maomasimi. Goa pua nimumi aa medaloma page tua aa medaloma page ora tu maomasimi. ");
INSERT INTO kew_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Goa pua maapuna aaraare nipuna si padane pirisa yapare ora nipuna epe naaki pirisa. Goa pua kogono aa medaloma dia sa-daa nipuna si page wala repaawa kone gupa isa: Nina si ya-pulu nipu madaa epe kone sua agaa pagena kone isa. ");
INSERT INTO kew_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Goa pisa-para maapu surubape aanumi yada roboa gupa simi: Go naakimi maapu nipu oro mealia-ga tamina simi. Go maapu niaa mada mealima simi goa palimare. ");
INSERT INTO kew_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Goa loa go naaki ripinaawa tu maomaawa maapu kepo rarane tu rubisimi. ");
INSERT INTO kew_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesumi go remaa madaa lalo: Gore go ini maapuna aaraamere ake palia ya? Gore nipu pua maapu surubape aanu tu maomaawa aa medaloma maapu surubenalo katea. ");
INSERT INTO kew_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Gore nimimi Gote-na buk madaa gupa dipitimi: Aana medare kamda kogono aanumi gimoa yapare abia ora mupaa aana aaya sa. ");
INSERT INTO kew_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Go kogonore Gote-me piae-ga niaame ora epe rado yae adema sa. ");
INSERT INTO kew_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yesumi go saa agaa sa rabu Juda aa mudunumi nipu aditalo pisimi. Yesuna saa agaare niaa madaa ta kone isimi. Yapare nimumi onaa adaapu madaa paalame omesimi-pulu Yesu gimoa pisimi. ");
INSERT INTO kew_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Go raburi nimumi Farisi aanu page Herot-na adaami aanu page Yesu piri-para repaasimi. Nimumi Yesu agaa mua ko tisimi. ");
INSERT INTO kew_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Goa pua mo aanumi lalo: Tisaa, niaame ne adema-ga ne onaa madaa paala naome pare Gote-na kone madaa ora agaa mogeaate. Gore nena konemere aa mudu aa riabo lapo madaa kone padane su pirua Gote-na redepo ne pora waru mogete. Goa pea-ga neme niaa lagiape: Rom gavman aa mudu Sisar-na opis-para takis mone lopaemare go epe ta pae o ta? ");
INSERT INTO kew_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Go takis mone-re lopamina yapae dia yapae simi. Goa simi rabu Yesumi nimuna kone adoa mua makirae agaa madaa kone isa-pulu nimu-para lalo: Akeane nimimi ni go agaame ko tulalo pimi pae? Gore mone ini padane adano mea ipulupa. ");
INSERT INTO kew_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Goa sa raburi ini padane mea kasimi. Yesumi nimu-para lalo: Go mone madaare aapina bi-para piksa-para ia pae? Nimumi nipu-para lalo: Sisar-na piksa nona piane simi. ");
INSERT INTO kew_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Goa simi raburi Yesumi nimu-para lalo: Gore Sisar-na oyae Sisar pa katapape pare Gote-na oyaenu Gote-para pa katapape. Go sa raburi nimu pogolasaawa paalame omesimi. ");
INSERT INTO kew_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Goa pisa raburi Sadyusi aa medaloma Yesu piri-para ipisimi. Nimuna konere ome onaanu matmat-para wala narekalimi kone isimi. Nimumi agaa gupa mulalo pisimi: ");
INSERT INTO kew_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Tisaa, Moses-me niaa-para pepa gupa tisa simi: Aa medana ame omenaloa ore pia pare nogo naaki napiraliare go ona nipuna amena ore rumaawa nogo naaki madiaalia. ");
INSERT INTO kew_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Sadyusi aanumi wala simi: Gore amealu 7-pela pirisimi. Mupaare ona rumaawa omesa raburi nogo naaki namadisa. ");
INSERT INTO kew_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Gore ame laapome go aa-na ona wasaa rumaawa omesa pare nogo naaki dia sa. Ame repome page goa pisa. ");
INSERT INTO kew_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Goa puaa-mama puare ame naba seven nipumi mo ona rumaawa omesa pare go oname nogo naaki namadesa. Oropere go aa-na ona wasaa page omesa. ");
INSERT INTO kew_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Gore wala Gote-me onaa marekaama paliare go onare aapina ona piralia ya? Go ame 7-pela nimumi ona misimi-ga simi. ");
INSERT INTO kew_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesumi nimu-para lalo: Gore nimimi Gote-na puri-para nipuna buk madaa i agaa-para ora na-ademe-pulu apo agaa waea teme. ");
INSERT INTO kew_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Orope matmat-para onaa rekalimi rabu yaa-para piri ensel-nurupa piralimi. Goa pea-ga onaare go rabu abi narumaalimi. ");
INSERT INTO kew_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Go page ome aanu rekalimi rabu go madaa Moses-na buk madaa i agaa gupa nadipisimi ya? Go buk-ri repena raane remaa agaare Gote-me Moses-para agaa gupa lakesa: Ni Abraham-para Aisak-para Jekop-para nimu rayona Gote pi sa. ");
INSERT INTO kew_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Go agaana re-re Gote-me ora kone wasupa suaeme onaanuna mudu pia. Nipu pa ome onaanuna Gote-daa dia. Nimina agaare lo maoyaateme sa. ");
INSERT INTO kew_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Go agaa lakesa raburi rekena agaana tisaa meda pirua onaanuna agaa pagesa. Go aame Yesu nimu-para agaa epe-rupa abusa-pulu nipumi Yesu-para agaa gupa mulalo pisa: Rekena agaa meda ora mudu ya-pulu medaloma minaabata ya? ");
INSERT INTO kew_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesumi lalo: Mupaa rekena agaa gupa sa: Israel onaa pagalepape. Niaana Mudu Gote-re niaana ora mudu padane pia. ");
INSERT INTO kew_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nimimi Mudu Gote madaa pedo pu raaname omalimiri nimuna pu robaa rayo-para kone wasupa rayo-para go rayore Gote madaa raaname omoa pedo pu piralepape. ");
INSERT INTO kew_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Rekena agaa laapona mudu agaa gupa sa: Nimina yogane surubeme-rupare nimimi pa onaanu madaa raaname omoa pedo pu piralepape. Go rekena agaa laapore pa medame narabuaniaaya. ");
INSERT INTO kew_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Goa lanoloa mo rekena agaa tisaa-me Yesu-para Ialo: Tisaa loa neme ora waru lae. Gote nipu ora Aa Mudu padane pia lae. Go page Gote pia-rupare pa gotenu medaloma napimi. ");
INSERT INTO kew_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Goa pea-ga onaanumi Gote madaa raana omoa pedo pu piralimi-daare nimina pu robaa rayo-para kone wasupa rayo-para puri rayo-parame pamina. Go page nimina yogane surubeme-rupa nimina ame madaa raaname omoa pedo pu piralimina. Go konere ora epe ta-ga go konemere miru irae page oyae tu yawape kone page maoge yaaya. ");
INSERT INTO kew_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesumi go aa-na epe makuaae kone adoa lalo: Ne Gote-na Surube Su i-para polalo pi. Goa sa raburi onaanumi nipu agaa namisimi pare paala omoa pirisimi. ");
INSERT INTO kew_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Gore orope Yesumi Juda aanuna epe lotu ada ru-para aawa agaa mogeawa lalo: Ake pua rekena agaa madaa tisaanumi gupa teme: Onaa Raapu Pirape Aa-na Siri nipu Devit-na si piralia teme. ");
INSERT INTO kew_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Holi Spirit-mi Devit kone kasa-pulu Devit-mi gupa sa: Gote-me nina Aa Mudu-para gupa lakesa: Nina popo ki-nane aa mudu piraina-ga iaanu nena aa rolo-para marabuaniaalua sa. ");
INSERT INTO kew_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Gore Devit-mi nipuna Aa Mudu sa-ga akea pua Onaa Raapu Pirape Aa-na Si wala Devit-na si mada piralia ya? Onaa adaapu pirua Yesuna agaa pagape raaname waru omesimi. ");
INSERT INTO kew_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesuna disaipel aa-para agaa gupa lakesa: Rekena agaa tisaanuna kone waru adalepape. Nimumi mamina pepena pi adaalu yamoa su amaa pua onaanumi abi piralepape teme rabu raana omeme. ");
INSERT INTO kew_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Go aanuna konere Juda aanuna lotu ada-para odobaawa riri-nane reke madaa piritalo pedo peme. Go page eta adaa yaweme raburi rikiraa madaa piritalo pedo peme sa. ");
INSERT INTO kew_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Go piane aanumi kone medare nimu ona wasaana oyae paake neme. Goa pua beten adaalu yoteme rabu onaanu makiraalimi. Goa peme-pulu orope di salia raburi nimuna wae yoto ora adaape mealimi sa. ");
INSERT INTO kew_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesumi lotu mone kiritasimi re-para pirua onaa adaapumi mone lopasimi-daa adesa. Goa pua amope aanumi mone adaapu lopasimi. ");
INSERT INTO kew_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Goa pua ona wasaa meda ipua mone oge kane laapo epa lopasa. Go mone-re ora ogesi lopasa. ");
INSERT INTO kew_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Goa pisa raburi Yesumi nipuna disaipel aanu meda-para maepaawa agaa lalo: Nimi-para neme ora lalo. Go ona wasaana mone-re ora aa medaloma nimuna kateme maoge yaaya sa. ");
INSERT INTO kew_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nimumi kateme rabu mone adaapu imi pare go ona nipuna kata rabu eta kabape mone rayo kasa. Nipuna mone rayo dia yaade sa. ");
INSERT INTO kew_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Goa pua Yesu Juda aanuna lotu ada gimoa pisa. Go raburi disaipel aa padaneme nipu-para lalo: Tisaa, go adanu-para aana-nu page ora epe ta-ga ada sa. ");
INSERT INTO kew_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesumi nipu-para lalo: Go adaa adanu waru adae? Gore go kiritasimi aana-nu ora padane-daa na-aritalia pare rayo lakepea rubebe palimi. ");
INSERT INTO kew_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Gore oro meda Yesu Rudu Oliv-ne pirua mo Juda aanuna epe lotu ada mone adesa. Pirisa raburi Jems-para Jon-para Edaru-para nimumi Yesu piri-para ipua padane-para pirisimi rabu agaa gupa misimi: ");
INSERT INTO kew_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Nena laede-rupa aa-rabu palia? Abia lagiape. Niaame ake adalimare gore go yae epalia lo mada niminaalima pae? ");
INSERT INTO kew_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesumi nimu-para agaa abuloa lakesa: Aa medalomame ne makirae agaa mea lagialimiri waru adalepape. ");
INSERT INTO kew_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Orope aa medaloma ipua nina bi Yesu teme-ga onaa adaapu epe pora makiralimi. ");
INSERT INTO kew_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Go page nimimi yada marekaape agaa-para ora yada pape remaa-para pagalimi rabu paala naomalepape. Goanu aba palia pare su yaa perekeape diri go rabu-daa dia. ");
INSERT INTO kew_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Goa puare ruru medalomame ruru rado-para yada palimi. Go page gavman adaa su medalomame gavman su rado radonu raapu ada palimi. Go page su rado rado-para suminini palia. Go page su rado rado-para reae adaa pabalia. Goa palia pare go yaenuri naaki masaa nala-rupa mada epalia. Oyae medaloma page orope epalia. ");
INSERT INTO kew_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Yapare nimi wae onaanu raapu piralimi rabu nimimi nina pora mea waateme. Nimumi nimi aditalo kaunsil-na ada-para mea pua koso teme. Go page nimumi nimi Juda aanuna lotu ada-para tua nimi kadipinu piri-para maawa aa mudunu piri page maawalimi. ");
INSERT INTO kew_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Goa palia pare epe agaare onaa piri su rayona aba lakelo kiritalimi. Goa pua oropere go yapi di dia yalia. ");
INSERT INTO kew_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nimumi nimi mapataawa koso-para mea palimi raburi ni ake lano yapae kone robaa-para namapiratepape. Go raburi Holi Spirit-mi agaa lagialia-pulu nimimi agaa mada laketeme. ");
INSERT INTO kew_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Go raburi ame baaninumi nimuna ame baani medaloma onaanu-para taminalo mea kateme. Aaraanumi nogo naaki onaanu-para mea tainalo kateme. Nogo naakinumi agi aaraa-para ratu yawoa taliminalo mea kateme. ");
INSERT INTO kew_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nimiri nina si ya-pulu onaa rayome nimi ratu yawoa gimalimi. Goa palimi pare onaa rayome ni nagi-mama palimiri orope go su yaa dia yalia rabu page oro yaalo kagaa piraama laama palimi. ");
INSERT INTO kew_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Gore nimimi mabebolaawa pugu pi oyae adalimi rabu go oyae epe ada-para rekalia-pulu go rabu su yaa lapo dia yalia. Go rabu su Judia piri onaame rudu apedaa-para pogola pulupape. Gore buk Daniel-me tisa-daa onaanumi go agaana re aba ademe-pulu mada niminaalimi. ");
INSERT INTO kew_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Go rabu onaanuri ada gaa-nane piralimiri ru-nane i oyaenu namula pulupape. ");
INSERT INTO kew_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Go rabu page onaa medaloma maapu-para piralimiri nimuna mamina ura laapo namea yamola pulupape. ");
INSERT INTO kew_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Go page ona medame nipuna nogo naaki padaa pia page adu nalae onaanu page pawa pogola palimi rabu ni odo palia. ");
INSERT INTO kew_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Yapare go piane wae kogono epea rabu naepenalo beten tapape. ");
INSERT INTO kew_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Go rabu epaliade yaere onaanumi kedaa gupa ora meda na-ademe. Gote-me su yaa laapo wariaa-mama ipua abia page radaa adaape go-rupa naepea. ");
INSERT INTO kew_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Gote-me go wae yae epaliade yapi di namarudu yaliare onaa rayo ora omalimi. Yapare Gote-me nipuna mapiraae onaa madaa kone salia-daa nipumi go di marudu yaalia. ");
INSERT INTO kew_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Go raburi onaa medalomame goa teme: Mea Repae Aare go-para pia mogo-para pia teme-daare go agaa napagalepape. ");
INSERT INTO kew_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Gore makirae Krais-nu page makirae agaa lakene aanu page opapalimi. Go rabu nimumi napiaa kogono pua oyae epape di radonu pinaloa adalimi. Goa pua nimumi nimi Gote-na mapiraae onaanu makiratalo epalimi. ");
INSERT INTO kew_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Goa palimi pare waru adalepape. Go epaliade yae rayo madaa agaa aba laguaayo. ");
INSERT INTO kew_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Goa pua onaa madaa apo radaa aba nenaloare naare udunoa akua naraalia. ");
INSERT INTO kew_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Uba kedome yaa gimoa lopalia rabu yaa-para piri oyaenuna puri page maeto eto palia. ");
INSERT INTO kew_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Goa palia raburi Onaa Raapu Pirape Aa-na Si adalimi. Nipumi yaa-para ipua nipuna puri ora mea epalia. ");
INSERT INTO kew_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Go raburi nipumi ensel-nu repaawa su rayona abade mapiraae onaare makiritaalia. Kiritalia rabu su yaa ruma aaya-nane pua re lapu lapu yarara yarara pu mea kiritalimi sa. ");
INSERT INTO kew_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Kama fik repenana kone waru mealepape. Nipuna palaa-para ipa rubia yo kagaa opea raburi go yae adoa pani palia kone su niminaamina. ");
INSERT INTO kew_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Go page apo wae yae epalia raburi kedaa meape di ora re-para epalia-ga niminaamina. ");
INSERT INTO kew_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Go agaa pagalepa. Go pimi onaa abi naomalimi pare go yaenu aba epenalo adalimi. ");
INSERT INTO kew_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Su yaa laapo aba dia yalia pare nina agaa oro yaalo pa saabalia. ");
INSERT INTO kew_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yapare go epaliade diri onaa medame page naniminaaeme. Yaa-para piri ensel page Gote-na Simi page namakuaaeme pare Aapa Gote-me agu raapo go di adoa niminaaya. ");
INSERT INTO kew_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Go epaliade yapi di rabu naniminaaeme-ga waru ado piralepape. ");
INSERT INTO kew_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Go yapi Di-na remaare gupa lagialo: Pa aa meda pora kimisu polalo pisa. Go rabu nipuna ada gimoa nipuna kogono aanu aba kogono rumaawa pisa. Go rabu pora gaape surubape aa-para waru adoaape loa pisa. ");
INSERT INTO kew_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Gore adoaatepape sa. Adana aaraare aa-rabu epalia palo naniminaaeme. Ribaa epalia yapae ruma rumane epalia yapae yaa kuta agaa piade rabu yapae yapipu epalia yapae maarea. Goa pea-ga ora waru adoaatepape. ");
INSERT INTO kew_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mogo adana aaraa epalia rabu nimi patalimiri ora o yalia. ");
INSERT INTO kew_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Gore neme nimi-para lagialo-rupare onaa rayo-para ora ado piralepape lano sa. ");
INSERT INTO kew_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Goa pua orope wala yapi laapome Pasova yawe Di epalia. Go rabu page Bret Nama-Adaa Yaape yapi di ya-pulu onaanu epa kiritasimi. Go raburi Gote-na Miru Irae Aa mudunumi page rekena agaana tisaanumi page Yesu tu maomaatalo pisimi-pulu nipu aditalo pisimi. ");
INSERT INTO kew_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Goa pisimi rabu nimumi lalo: Onaanumi wae-rupa pogolasaalimi-pulu go Pasova Yawena yapi di rabu mada na-adiatamina simi. ");
INSERT INTO kew_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Gore Yesu Betani su-para ipua yakimi tisa pare maepeaae aa Saimon-na ada-para pirisa. Pirisa raburi ona medame aana pe mua epe kaa pu ti wabola pirapalae mea ipisa. Go ipare yoto ora adaape inalo oname go pe loboa Yesuna aalu madaa koyasa. ");
INSERT INTO kew_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Koyasa rabu go piri onaa medalomame ratu yawoa gupa lo pirisimi: Akeane go epe ipa pa rubala? ");
INSERT INTO kew_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Go ipa kabola peme raburi mone yo adaapu gupa 1200 kina mada mua riabo naraanu pa kata pema. Goa loa nimu mo ona-para ape simi. ");
INSERT INTO kew_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Goa pisa raburi Yesumi lalo: Go agaa gimalepa. Akeane nipu madaa wae kone imi pae? Nipumi ora epe kone sua pia. ");
INSERT INTO kew_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Riabo naraanuri oro yaalo nimi raapu piralimi-pulu nimu madaa raba meape kone salimi-daare go rabu pipape. Yapare neme nimi raapu oro yaalo napiralua. ");
INSERT INTO kew_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Go onana kone epe ta-ga palainawa. Naa ro rogaaliminalo naa tone go epe ipame aba koyaata. ");
INSERT INTO kew_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Pagalepa. Gore epe agaa su rayona laketeme rabu onaanumi go onana bi pagenalo nipumi ni madaa ipa koyasa kone salimina. ");
INSERT INTO kew_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Go rabu disaipel 12-pela aa-na bi medare Judas Iskariot pirisa. Go aare Gote-na miru irape aa mudunu piri-para pua Yesu tulalo yada robesa. ");
INSERT INTO kew_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Go aa mudunumi Judas-na agaa pagoa raaname omoa mone gialima simi. Goa simi-pulu Judas-me Yesu ora tinalo mea katoa kone isa. ");
INSERT INTO kew_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Go Bret Yis Nasape yapi di raburi disaipel aanumi Yesu-para agaa gupa misimi: Niaa aa-rabu pua nena Pasova eta managola salima ya? Go rabu Pasova-na sipsip tisimi-pulu goa simi. ");
INSERT INTO kew_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Go raburi Yesumi nipuna disaipel aa laapo mea repaawa lalo: Su yada-para palipi raburi ipa noria ipulae aa meda madaalipi. Nipu rata mea pulupape. ");
INSERT INTO kew_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nipu ada-para odobalia rabu go adana aaraa-para gupa laketapape. Tisaa-me lalo: Ni-para nina disaipel aanu-para niaa Pasova eta nalima-pulu go ada rum meda ia palo laketapape sa. ");
INSERT INTO kew_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Go tepe raburi mo aame nipi so-nane mea pua epe pepena pi ada rum mea waatea. Go rabu nipumi niaana eta nape yaenu mea managola salepape. ");
INSERT INTO kew_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Goa sa-pulu disaipel aanumi adaare-para pua Yesumi lakesade-rupa adesimi. Goa pua nimumi Pasova eta managola saasimi. ");
INSERT INTO kew_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Wala aebo raburi Yesu-para disaipel aa 12-pela padane-para pirisimi. ");
INSERT INTO kew_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Goa puare nimu reke madaa eta no pirisimi rabu Yesumi lalo: Pagalepa. Nimina aa padanere ora kawae madini aa pia pare abia nipumi ni raapu eta pa no pia. ");
INSERT INTO kew_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Goa sa raburi nimu odome omoa disaipel aa 12-pela aame padane padane nipu-para pua agaa gupa misimi: Gore ni ora yapae lo gupa simi. ");
INSERT INTO kew_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesumi nimu-para lalo Aposel aa 12-pelana padane abia saa laapo plet-para bret madaa ki sapalae no pipa. ");
INSERT INTO kew_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Gote-na buk madaa ta-rupa Onaa Raapu Pirape Aa-na Si omalua sa. Goa pea pare go raburi nipuna kawae madini aare wae yae epaliana odome omalo. Go aare nipuna agimi aba namadita pisa yaalore ora epe ta sa. ");
INSERT INTO kew_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Eta nisimi raburi Yesu nipu bret mua Gote-para ora pi loa ruki ruki pua nipuna disaipel aanu kasa. Kalalaawa gupa sa: Mealepa. Go bret-re nina yogane gialo-ga mua nalepa. ");
INSERT INTO kew_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Goa pua Yesumi kap mua Gote-para ora pi loare kasa. Kasa rabu nimumi rayo nisimi. ");
INSERT INTO kew_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Go rabu Yesumi nimu-para lalo: Go ipa wain-ri nina yaapi-ga onaanu madaa koyaato. Nina yaapi-miri Gote-na onaa ora agaame mapogasaalia. ");
INSERT INTO kew_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nimi-para ora lalo: Neme go ipa wain wala mada nanalua pare aba Gote-na surube su-para pirua nalua sa. ");
INSERT INTO kew_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Goa pisa raburi nimumi ora pi yaasa loare su Rudu Oliv-nane pisimi. ");
INSERT INTO kew_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Pamisimi raburi Yesumi nimu-para lalo: Nimi rayome ni gimalimi. Gote-na buk madaa gupa tu suaaya sa: Gote-me sipsip punini aa talia rabu sipsip yola minabalia sa. ");
INSERT INTO kew_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Yapare ni wala rekoa nimi Galili su-para palimi rabu ni aba riri-nane palua sa. ");
INSERT INTO kew_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Goa sa raburi Pita-me nipu-para lalo: Nimu rayome ne gimalimi pare neme mada nagimalua sa. ");
INSERT INTO kew_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesumi nipu-para lalo: Waru pagalepa. Go ribaare yaa kutame e rana laapo talo palia pare aba rana repo neme ni Yesu na-ade te. ");
INSERT INTO kew_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Goa sa raburi Pita-me puri palo yaaloa gupa sa: Saa rana padane omalipa pare neme ne nagimalua sa. Go disaipel aa rayome agaa padane gupa simi. ");
INSERT INTO kew_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Gore nimu su medana bi Getsemani-para pisimi. Go-para Yesumi nipuna disaipel aanu-para lalo: Go-para nimi piralimina neme beten ta pulu sa. ");
INSERT INTO kew_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Goa pua Yesumi Pita-para Jems-para Jon-para lamua pisa. Go rabu Yesuna pu imu-para ora radaa pua kedaame omesa. ");
INSERT INTO kew_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nipumi nimu-para lalo: Nina robaa-para kedaa pua ni omalua sa. Go-nane adaba pitapape. ");
INSERT INTO kew_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Goa loa Yesu pora-nia wala ogesi pua suna lopesa. Lopoa Gote-para beten gupa sa: Aapa, ni madaa ora kone saliri go radaa ni mada naepena magimaape. ");
INSERT INTO kew_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Goa loa wala lalo: Aapa, ne oyae rayo mada pali-ga ni radaa nape gimano kap pane meape. Yapare neme kone salo-rupa napape. Dia, nena koneme niminaawa pape. ");
INSERT INTO kew_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Goa loa wala ipisa pare nipuna disaipel aa repo u pa patisimi. Go rabu Yesumi adoa Pita-para lalo: Saimon-ya, ne u patae ya? Ne go oge yapi rabu mada na-adobali? ");
INSERT INTO kew_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Gore wae yae-para lopalimi-ga beten loa adaaba piralepape. Nimina konere puri pata pare nimina yogane oma paaya. ");
INSERT INTO kew_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Goa loa nipu wala pua beten agaa aba sa-rupa wala sa. ");
INSERT INTO kew_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nipu disaipel aanu piri-para wala ipisa rabu nimu pa u patisimi. Nimuna ini-para u wala ipisa-daa u patisimi. Nimumi rekoa nipu-para agaa wala meda na-abusimi. ");
INSERT INTO kew_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Goa pua wala rana repo Yesu ipua nimu-para lalo: Nimi penaa u patua piralimi ya? Gore mada. Abiare nimumi Onaa Raapu Pirape Aa-na Si pupitagi ne onaanu lamu kateme. ");
INSERT INTO kew_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Rekoa baina. Ada, ni tapena kabereke meade aare aba go epea-daa sa. ");
INSERT INTO kew_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesumi agaa lalaina go aposel-na rikiraanare aa Judas page onaa adaapu page medaloma ipisimi. Nimumi nimuna repena uninu nimuna rai kutunu mea ipisimi. Gote-na miru irae aa mudunumi page rekena agaa tisaanu page aa mudunumi repaasimi-pulu ipisimi. ");
INSERT INTO kew_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Gupa ipisimi rabu kawae madini aa Judas-mere nimu-para kudiri pi kone kaloa lalo: Neme go aa pua nunu toa rabu go aa mealepape. Nipu adia waru suruboa mea pulupape sa. ");
INSERT INTO kew_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Gore Judas ipisa raburi nipumi Yesu piri aipapulu pua puaa lalo: Aa Mudu sa. Goa loa nipumi Yesu nunu sa. ");
INSERT INTO kew_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Go rabu nimumi Yesu aditalo waru ripinaawa misimi. ");
INSERT INTO kew_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Yapare aa meda re-para piri aame rai kutu mua Gote-na aa mudu nipuna raba mi aa tulalo pisa pare aane pona tisa. ");
INSERT INTO kew_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Goa pua Yesumi nimu-para lalo: Akeane nimimi rai kutu-para repena uni-para mua ni talimi ya? Ni paake ne aa ya? ");
INSERT INTO kew_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ni oro yaalo nimi raapu lotu ada-para pirua agaa mogeaaru pare go rabu ni aditalo naipisimide. Yapare Gote-na buk madaa ia-pulu mada palimi. ");
INSERT INTO kew_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Go sa raburi disaipel aanumi nipu gimoa pogola pisimi. ");
INSERT INTO kew_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Go rabu ogege aa medame Yesu rata mea pisa. Go naakina to madaare mamina yaako pi agu yamesa. Go rabu aa medalomame nipu epa ripinaabasimi. ");
INSERT INTO kew_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Yapare nipu mamina malopaawa pogola pisa. ");
INSERT INTO kew_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Go raburi nimumi Yesu Gote-na aa mudunu piri-para mea pisimi. Go raburi Gote-na miru irae aa mudunumiri kone makuaae aanu-para rekena agaana tisaanu-para nimu padane-para kiritasimi. ");
INSERT INTO kew_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Go raburi Pita-me Yesu rata mea ipisa pare re-para naipisa. Nipu Gote-na miru irae aa mudununa epe pokaalo ada ru-nane pua pirisa. Nipu plisman-nu raapu padane-para piru repena adala pirisa. ");
INSERT INTO kew_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Go raburi Gote-na miru irae aa mudunu page kaunsil aanumi page nimu rayome Yesu tu maomaatalo pisimi-pulu pa amaa makirae agaa mulalo pisimi. Goa pisimi pare nimumi wae yae ora padane-daa na-adesimi. ");
INSERT INTO kew_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Onaa adaapumi Yesu madaa makirae agaa lo pirisimi pare agaa rado rado simi. ");
INSERT INTO kew_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Goa pisa-pulu aa medaloma rekoa Yesu madaa makiraawa lalo: ");
INSERT INTO kew_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Nipumi go epe lotu ada kimi wariniri kilipialua sa raburi niaame pagesima simi. Wala yapi repome lotu ada rado wariabalua sa pare kimi namaalua sa. Go sa raburi niaame pagesima simi. ");
INSERT INTO kew_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nimumi remaa lakesimi pare agaa rado rado lakesimi. ");
INSERT INTO kew_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Go rabu Gote-na miru irae aa mudumi nimu piri-para rekoa Yesu agaa gupa misa: Nimumi ne madaa go agaa tame-ga agaa mada na-abulali ya? ");
INSERT INTO kew_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Goa sa raburi Yesu pa pirua agaa nasa. Gote-na miru irae aa mudumi agaa wala gupa misa: Nere Onaa Raapu Pirape Aa-na Si ya? Nere epe puri i Gote-na Si ya? ");
INSERT INTO kew_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesumi lalo: E, ni Onaa Raapu Pirape Aa-na Si ya-pulu Gote-na ora ki-nane piralua nipuna puri mada adalimi. Ni yaa moae raapu madaa pirua epalua-daa adalimina. ");
INSERT INTO kew_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Goa sa raburi Gote-na miru irae aa mudumi Yesu ero agaa ta kone sua nipuna mamina mea riripia lalo: Akeane adasae aa medana agaa pagamona ya? ");
INSERT INTO kew_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nimimi nipuna ero agaa pagamede. Nimina kone ake ya? Goa sa rabu onaanumi nipu tu maomape simi. ");
INSERT INTO kew_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Goa pisa raburi onaanumi Yesuna yogane madaa sope rapiaawa nipuna ini rigitua gupa simi: Aapimi ne ta? Abi la. Goa simi raburi plisman-numi page nipuna to yogane tisimi. ");
INSERT INTO kew_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Go tisimi raburi Pita-me Aa Mudu-na ada kepo ru-nane pa pirisa. Go rabu Gote-na miru irae aa muduna kogono ona meda ipisa. ");
INSERT INTO kew_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Epenaloa Pita-me adaasa-pulu go oname nipu waru adaba sua lalo: Ne page go Nasaret su-para piri aa Yesu raapu piriside. ");
INSERT INTO kew_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Yapare Pita-me dia loa gupa sa: Nena agaare neme napagoa naniminaato sa. Go raburi ada peraa-nane pua pora gaape-nane pisa. Go-para pulaina yaa kutame agaa sa. ");
INSERT INTO kew_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Go-nane pisa raburi kogono pape oname Pita adoa pa piri onaanu-para lakesa: Go aare nipu Yesuna disaipel aa yaade sa. ");
INSERT INTO kew_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Goa sa pare Pita-me wala dia sa. Wala orope ogesi-daa pa pirua onaanumi Pita-para gupa lakesimi: Nere ora disaipel aa yaade. Ya agaa nalape. Ne ora Galili su piri aa yaade simi. ");
INSERT INTO kew_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Go rabu Pita-me nimu-para ora yaa madaa makuaa puri paloa lalo: Niri go tame aa maarea ni ora dia yaade sa. ");
INSERT INTO kew_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Goa sa rabu yaa kuta wala rana laapo agaa sa. Go rabu Pita-me Yesuna agaa wala niminaasa. Yesumi aba gupa lakesa: Yaa kuta agaa rana laapo tea raburi neme nina bi rana repo gimali sa. Go agaa niminaasa-pulu nipumi odome omoa re waru lo pirisa. ");
INSERT INTO kew_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Gore wala yapi lapaasa rabu Gote-na miru irae aa mudunu page kone makuaae aanu page rekena agaana tisaanu page kaunsel-nu page nimu rayome yada robesimi. Goa pisa raburi nimumi Yesu opeme adia Pailat piri-para mea pisimi. ");
INSERT INTO kew_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Goa pisimi raburi Pailat-me Yesu nipu agaa misa: Ne Juda aanuna ora aa mudu ya sa. Nipumi Pailat-para lalo: Ne ora lae sa. ");
INSERT INTO kew_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Goa sa raburi Gote-na miru irae aa mudunumi Yesu madaa wae yae pinalo agaa adaapu lakesimi. ");
INSERT INTO kew_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Goa simi rabu Pailat-me Yesu-para agaa wala gupa misa: Ne agaa mada nate ya? Nimumi ne wae yae pape kone adaapu madaa agaa tame-ga neme napagae ya sa. ");
INSERT INTO kew_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Goa sa pare Yesu agaa meda yago natisa rabu Pailat-me kone adaapu kibu pisa. ");
INSERT INTO kew_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Gore oro yaalo Pasova yapina di raburi onaanumi kalabus ada-para pati aa padane esepeape kone isa-pulu Pailat-me goa pulalo pisa. ");
INSERT INTO kew_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Go raburi kalabus ada-parare gavman-na iaanu pirisimi. Nimuna rikiraanare onaa tu maomaasade aa meda Barabas pirisa. ");
INSERT INTO kew_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Go raburi onaa adaapumi Pailat-para ipua lalo: Ne Pasova-na maali di madaare aa meda esepeape simi. ");
INSERT INTO kew_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Goa simi rabu Pailat-me nimu-para agaa gupa misa: Nimina kone akepu saleme? Neme Juda aanuna aa mudu esepealua ya? ");
INSERT INTO kew_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Goa sa pare Pailat-me nimuna kone aba adesa. Nipumi Gote-na miru irape aa mudunumi Yesu madaa udipa kone sua aditalo ipisimi-daa adesa. ");
INSERT INTO kew_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Yapare Gote-na miru irae aa mudunumi onaanu mapogolasaasimi rabu nimumi Pailat-para Barabas maesepeaape agaa lakesimi. ");
INSERT INTO kew_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Goa simi raburi Pailat-me nimu agaa wala misa: Gore nimina Juda aa muduri nipu madaa ake palua ya sa. ");
INSERT INTO kew_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nimumi nipu-para wala yaasimi: Repena polopea madaa tu maomape simi. ");
INSERT INTO kew_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Goa simi raburi Pailat-me nimu-para lalo: Akeane ya? Nipu madaa wae yae meda naia sa. Yapare nimumi puri paloa gupa simi: Repena polopea madaa tamina simi. ");
INSERT INTO kew_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Goa simi raburi Pailat-me onaanu madaa pedo pisa-pulu nipumi Barabas esepeasa. Goa pua Pailat-me Yesu repena unimi tua onaanumi repena polopea madaa tinalo mea kasa. ");
INSERT INTO kew_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Goa pua soldia aanumi Yesu gavman-na koso lape ada ru-nane mea pua soldia aanu medaloma page yaasimi. ");
INSERT INTO kew_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Go raburi go aanumi Yesu madaa epe kane mamina mayamaawa aalu madaa ope etolo etolo ae mua raguna wariaawa maadipaasimi. ");
INSERT INTO kew_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Goa pisimi raburi nimumi nipu madaa marakepeae agaa gupa simi: Ne Juda onaanuna aa mudu-ga oro yaalo epe-rupa pirape simi. ");
INSERT INTO kew_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Goa loa nimumi Yesuna aalu repena unimi tua sope rapiaawa rumu koba pua adaniaawa mapiraasimi. ");
INSERT INTO kew_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Gore nimumi nipu madaa giri laasimi raburi nipuna epe kane mamina koloa ora nipuna mamina mayamaasimi. Goa pisimi raburi repena polopeane tulalo mea pisimi. ");
INSERT INTO kew_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Goa pisimi raburi pa aa medana biri Saimon nipuna su Sairini gimoa pa ipisa rabu nimumi go aa repena polopea pasaane mariaasimi. Go aare nipu Aleksanda-para Rufus-para go naaki lapona aaraa nipu Sairini su-para pirisa. ");
INSERT INTO kew_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Go raburi nimumi Yesu Golgo ta su-nane lamua pisimi. Go Golgo ta su biri adaa agaa madaare aalu uni rogaae su teme. ");
INSERT INTO kew_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Mea pisimi raburi nimumi nipu wae rero pi ipa katalo pisimi pare gimisa. Go ipare wain-para rero pi yae meda raapu moropea kasimi. ");
INSERT INTO kew_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Goa puare nimumi Yesu repena polopea madaa tisimi. Goa puare nimumi nipuna mamina-nu padane padane lo mua satu-rupa tu pirisimi. ");
INSERT INTO kew_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Gore go naare pena opalaina Yesu repena polopea madaa tisimi. ");
INSERT INTO kew_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Go tisimi raburi nimumi koso lape agaa pepa madaa gupa tisimi: Go aare Juda aanuna aa mudu yaade lo tu isimi. ");
INSERT INTO kew_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Goa pisimi rabu Yesu paake ne aa laapona rikiraana tua aa meda ora ki-nane tu aa meda koya ki-nane tala pasimi. ");
INSERT INTO kew_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Goa pisimide konere Gote-na buk madaa aba gupa tu isa: Nipu wae paake ne aa raapu mapiraasimi. ");
INSERT INTO kew_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Goa pisa rabu pora one lobasa apone lobasa pi onaanumiri nimuna aalu ma-wage wage pua ero agaa gupa simi: Neme lotu ada kilipia yapi repome wala maaulua aba side. ");
INSERT INTO kew_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Nena bipa ne raba mea. Abiare repena polopea gimoa su amaa ipu simi. ");
INSERT INTO kew_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Gote-na miru irae aa mudunu page rekena agaa tisaanu page nimumi Yesu-para ero agaa gupa lo pirisimi: Nipumi onaa medaloma raba mua oro yaalo mapiraasa-ga nipuna bipa nipu raba mua oro yaalo pirinalo adamina simi. ");
INSERT INTO kew_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Go aare onaa Raapu Pirape Aa page Israel aa mudu page nipu go-rupa pia-pulu go repena polopea gimalia-daare niaame nipu madaa kone rulamina simi. Go repena polopea meda madaa mudiasimi aa laapome page Yesu-para ape sipi. ");
INSERT INTO kew_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Gore naare rikiraana aasa rabu go su rayo ribaa yabaasa. Goa pua su rayo rigitaama pua naare nogo-nane pabola pupulaina yapi wala lapaasa. ");
INSERT INTO kew_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Go naare pabola popesa raburi Yesumi puri paloa gupa yaasa: Eli Eli lama sapaktani sa. Go adaa agaamere gupa sa: Naa Aapa Gote neme ni akolo gimae pae sa. ");
INSERT INTO kew_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Pa piri onaa medalomanu pagoa gupa simi: Gore nipumi Elija yalaade simi. ");
INSERT INTO kew_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Goa sa raburi aa padane aipapulu ipua lubi nona piane yaeme rero pi ipa paba palae repena rugi-nane aguta palaawa nenalo kasa. Yesu kaloa gupa sa: Adoaape. Elija-mere nipu repena polopea madaa esepeaalia yapae niaame adamona sa. ");
INSERT INTO kew_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Goa sa raburi Yesu agaa puri palo yaa loa pu imu udunasa rabu omesa. ");
INSERT INTO kew_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Goa pisa raburi lotu ada-para mudiabae mamina so rugi-nane riripi taboa none rugi-nane pua riripi kiritisa. ");
INSERT INTO kew_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Goa pisa raburi mo soldia aa mudumi Yesu ini adupisa adesa-pulu gupa simi: Go aare Gote-na Si ora ria yaade sa. ");
INSERT INTO kew_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Goa pisa rabu ona adaapu mo-para pirua adesimi. Ona medare Maria nipuna adaare Makdala su-para pirisa. Ona medare Maria nipuna si Jems-para Josep-para nimu raapu pirisimi. Ona meda Salomi page pirisa. ");
INSERT INTO kew_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Aba Yesu Galili su-para pirisa raburi mo onaanumi nipu rata mea pua nipu raba misimi. Ona medalomanuri Yesumi Jerusalem su-para gimoa ipisa rabu nimu raapu meda ipisimi onaanu pirisimi. ");
INSERT INTO kew_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Gore riba yolalo palaina Arimatea su-para piri aa Josep ipisa. Go aare ora epe kaunsil aa pirisa. Nipumi Gote-na Surube Su epenalo adolalo pirisa. Nipu ipisa rabu ekeraa-nanere Kitu Pirape Yapi ya-pulu nipumi Pailat piri-para pua Yesuna ro rogaata ponolo pua ogesa. ");
INSERT INTO kew_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Gore ogesa raburi Pailat-me Yesu aba ini adupisa lo napagesa. Goa pisa-daa nipumi soldia-na surube aa meda yaaloa gupa lakesa: Mo aa ini adupia pae loa agaa misa. ");
INSERT INTO kew_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Gore yada pape surube aame e sa, ora omaade sa-daa Pailat-me Josep gupa lakesa: Yesuna ro mada mula pope sa. ");
INSERT INTO kew_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Goa sa raburi Josep-me yaako pi mamina mua ro rogaawa aana apedaa matmat-para rogaasa. Nipumi rogaabaawa pora gaape-nane aana-me garulaniaasa. ");
INSERT INTO kew_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Goa pisa raburi Makdala su-para piri Maria-me page Josep-na agi Maria-me page Yesuna ro mo mea rogaasa-para adesipi. ");
INSERT INTO kew_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Gore Kitu Pirape Yapi dia naloa Makdala su-para piri Maria-para Jems-na agi Maria-para Salomi-para epe kaa pi wabala meda kabesimi. Nimumi Yesuna ro madaa sula pisimi. ");
INSERT INTO kew_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Gore adaa orona yapipu rabu go onanu aana apedaa matmat-para adola pisimi. ");
INSERT INTO kew_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Goa pisimi raburi nimumi agaa gupa laarisimi: Aapimi pora gaape aana mea lusu rubalia pae simi. ");
INSERT INTO kew_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Goa simi raburi nimumi adasaawa adesimi pare aana lusu rube adesimi. Go aana-re ora adaape. ");
INSERT INTO kew_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Gore nimumi aana apedaa matmat-para odobatalo pua nimuna popoke-nane ogege aa meda adesimi. Nipuna yaako pi mamina yamoa pirisa. Adesimi raburi ora paala omoa pogolasaasimi. ");
INSERT INTO kew_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Goa pisa pare mo naakimi nimu-para lalo: Paala naomalepape. Nimimiri Nasaret su-para piri Yesu asapula epamede niminaato. Go aare repena polopea madaa tamade. Yapare nipu aba laade-rupa rekaa pua go-para napia. Adalepa, go-para aba rogaarimide. ");
INSERT INTO kew_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yapare nimi abi pua nipuna disaipel aanu-para Pita-para nipu Galili su-para aba pua pirina laketapape. Nipumi nimi aba lakesa-rupa go su-para mada adalimi sa. ");
INSERT INTO kew_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Goa sa raburi nimumi aana apedaa matmat gimoa aipapulu pisimi. Pisimi rabu ora pururu aawa paalame omesimi. Nimu paalame omesimi-pulu onaanu abi napua lakesimi. ");
INSERT INTO kew_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Goa pisa raburi Yesu adaa orona yapipu rekesa. Rekesa raburi Makdala su-para piri Maria-me Yesu aba adesa. Go ona madaare Yesumi wae remo 7-pela aba marakepeaasa. ");
INSERT INTO kew_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Go onamere nipu pua Yesuna adaami onaanu-para lakesa. Nimumi odo omoa re lo pirisimi rabu lakesa. ");
INSERT INTO kew_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Yapare oname neme Yesu adaawa pa pia lakesa rabu nimumi kone narulasimi. ");
INSERT INTO kew_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Oropere Yesuna disaipel aa laapo pulaawa ipisa raburi nipuna to rado piane nona pi pirisa. Go rabu go aa laapore su amaa pora-nia pisipi. ");
INSERT INTO kew_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Goa pua go aa laapome onaa medaloma-para pua lakesipi pare nimumi go agaa madaa kone narulasimi. ");
INSERT INTO kew_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Wala oropere disaipel aa 11-pela reke madaa eta no pirina Yesu ipisa. Gore aba onaa medalomame nimu-para Yesu pa pia epa lakesimi pare kone narulasimi go agaa robaa-para naodabasimi-pulu nipumi nimu mo lagiame agaa madaa kone narulaarimi paloa ape sa. ");
INSERT INTO kew_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Go raburi Yesumi nimu-para lalo: Su ada rayo-nini pua onaa rayo-para epe agaa pua lakelatepape sa. ");
INSERT INTO kew_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Onaa rayome go agaa madaa kone rulaawa baptais muare oro yaalo kagaa piraama laama palimi. Pare onaa rayome go epe agaa madaa kone narulalimi-daare pupitagi ne kone madaa wae yoto mealimi sa. ");
INSERT INTO kew_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kone rulae onaanumi puri mua gupa palimi: Na bi loa wae remo marakepealimi. Nimumi aba napage adaa agaa radonu page teme. ");
INSERT INTO kew_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Nimumi paaka ripinaalimi rabu naomalimi. Nimumi romo maalu nona piane ipa nalimiri ora naomalimi. Nimumi yaina ome onaanu aaluna kimi oraalimi rabu perekealimi sa. ");
INSERT INTO kew_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Gore Aa Mudu Yesumi nimu-para agaa gupa lakenaloa so yaa-para mea pisa. Goa puare Gote-na popo ki-nane pirisa. ");
INSERT INTO kew_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Goa pisa raburi disaipel aanumi su rayone pua epe agaa mogeasimi. Goa pisimi raburi Aa Mudumi nimu raba mua puri kasa. Puri kasa rabu nipumi disaipel aanumi agaa pamu lo napiaa page pamu pua nipuna agaa puri mapalaasimi. Go yaade. ");
INSERT INTO kew_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Yesa Tiofilus: Abadere aa adaapumi niaana rikiraana Gote-me maopasaade yaenu pepa madaa tisimi. ");
INSERT INTO kew_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Gore ora ripia rabu go oyae adoa epe agaa lakesimi onaanuna agaa pagesimi. Nimumi niaa lagisimi agaare aa adaapumi pepa madaa tisimi. ");
INSERT INTO kew_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Goa pea-pulu aa mudu Tiofilus-re neme page go remaa rayo pepa madaa tua ne piri-para repaalua kone sawa. Go remaana re rayo madaa kone waru niminaawa epe-rupa taato. ");
INSERT INTO kew_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Gupa taato-ga neme apo agaa rayona re niminaawa kone re lainalo pepa tu repaato. ");
INSERT INTO kew_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herot Judia su-para aa mudu pirisa rabu Gote-na miru irae aa meda Sekaraia pirisa. Nipuri Gote-na miru irae aa meda Abaisa ruruna rikiraana pirisa. Sekaraia-na orena biri Elisabet. Go ona page Gote-na miru irae aa ruruna ru-nane pirua madisa. ");
INSERT INTO kew_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Go repaayare Gote-na ini agaana epe-rupa pirua rekena agaa rayo pagoa epe-rupa pirisipi. Nipu lapome Aa Mudu-na agaa waru pagoa epe-rupa ora pirisipi. ");
INSERT INTO kew_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pare Elisabet-re onagae pirisa-pulu nipu nogo naaki namadisa. Goa pua nipu ora onagae yomagae lapo pirisipi. ");
INSERT INTO kew_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Oro medare Sekaraia nipuna ruru aanu epa kiritaawa Gote-na kogono pulalo ipisimi. ");
INSERT INTO kew_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Go rabu miru irae aanuri nimumi oyae kasa-rupa tuare aana reke madaa miru iritalo pisimi. ");
INSERT INTO kew_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sekaraia-me Gote-na lotu ada ru-nane miru iratalo pirina onaa adaapu ada gaa-nane beten pua lala pirisimi. ");
INSERT INTO kew_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sekeraia ru-nane pisa rabu Aa Mudu-na ensel meda so miru irae aana reke popo ke-nane epa rekasa. ");
INSERT INTO kew_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Gore Sekaraia nipumi mo ensel adoa ora paalame waru omoa pogolasaasa. ");
INSERT INTO kew_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Go raburi ensel-me lalo: Sekaraia, neme paala naomape. Gote-me nena beten aba pagaa. Nena oname naaki madialia. Nemere go naakina bi Jon ma-ape. ");
INSERT INTO kew_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Go raburi ne pedo pua raana waru omali. Nipu madiali raburi onaa adaapumi nipu madaa pedo palimi. ");
INSERT INTO kew_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Gore nipuri Aa Mudu-na ora aa mudu piralia. Nipumi ipa wain-para puri pane ipa bia nanalia. Nipuna agina robaa-para piralaina Gote-na Holi Spirit nipu madaa rulatabalia. ");
INSERT INTO kew_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mo Gote-na ruru Israel su-para piri onaa adaapumi kone perekea nimuna Mudu Gote madaa kone rulaliminalo Jon-me agaa laketea sa. ");
INSERT INTO kew_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nipumi Elija-na kone mogeawa puri waru paboa aa adaa pirua Gote-na agaa laketea. Goa puare Jon-me agi aaraanumi nimuna nogo naaki epe-rupa mapiraaina tea. Nipumi agaa rasini onaanuna kone maepeaawa Aa Mudu-na epaliade yapi di madaa kone sua ado pirinalo laketea sa. ");
INSERT INTO kew_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Go raburi Sekaraia-me ensel gupa lakesa: Neme go agaare akea pua ora lae kone salua ya? Ni page nina onagae sa laapo aba ogaetepa sa. ");
INSERT INTO kew_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Goa sa rabu ensel-me Sekaraia-para gupa lakesa: Niri Gebriel. Neme Gote-na ini agaa madaa rekaayo. Goa pe-pulu Gote nipumi ni mea rapariaa-daa neme ne go epe agaa lagialuame epa pi. ");
INSERT INTO kew_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Gore go agaana re ora palia pare neme go agaa kone narulaate-pulu nena agaa rabutea. Nena agaare maara palae puare ora lagiawade agaana re opaliade raburi nena agaa lapali sa. ");
INSERT INTO kew_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sekaraia ada ru-nane adaalupu pirisa-pulu onaa rayome kone adaapu sua adoaasimi. ");
INSERT INTO kew_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Gore nipu orope amaa-nane ipisa pare mo onaanu agaa mada nalakesa-pulu nipumi nimu adenalo pa ki maalame robo isa. Nipu agaa maare aa pirisa-pulu onaanumi nipu lotu ada ru-nane upaa-rupa adesa-pulu niminaasimi. ");
INSERT INTO kew_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Wala oropere Sekaraia nipuna miru irae kogono pi di dia sa raburi nipuna adaa wala pisa. ");
INSERT INTO kew_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Orope nipuna ona Elisabet naaki akua supumi padaa pirua kaledesa. Go rabu nipumi lalo: ");
INSERT INTO kew_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Abiare Aa Mudumi ni madaa odome omoa ni-para goa pea. Gore abade naaki napirisa rabu onanuna ini agaa madaa yala posu pare abia epe ta sa. ");
INSERT INTO kew_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Akualu 6-pela popesa rabu Elisabet naaki padaa aba pirina Gote-me ensel Gebriel mo Galili su robo ru-nane adaare Nasaret-para penaasa. ");
INSERT INTO kew_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nipumi ona inumakua meda piri-para pisa. Abade go onare aa meda Josep-me rumaatalo oyae kalabaasa. Go aare akua Devit-na rurumi madini aa pirisa. Ona inumakuana biri Maria. ");
INSERT INTO kew_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Go rabu ensel mo ona Maria piri puare go ona epe-rupa pirape sa. Aa Mudumi nere odome omoa ne raapu padane-para pia sa. ");
INSERT INTO kew_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ona Maria-me go ensel-na agaa pagoa kone adaapu isa. Go aa-na agaare akepu ta pae kone sua kedaa waru omesa. ");
INSERT INTO kew_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Go raburi ensel-me Maria lakesa: Neme paala naomape. Gote-na konemere ne puri meainalo pi sa. ");
INSERT INTO kew_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Waru paga. Neme naaki padaa pirua naaki meda madiali. Nipuna biri Yesu ma-ape. ");
INSERT INTO kew_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Go naaki nipu aa adaa piralia rabu onaanumi nipu so yaa madaa pia Gote-na Si teme. Gore Gote-me nipu akua Devit-na ruruna ora aa mudu mapiraalia. ");
INSERT INTO kew_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nipuri Jekop-na ruruna aa mudu page oro yaalo piralia. Goa pua nipuna Surube Su ora namadia yaalia sa. ");
INSERT INTO kew_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Goa sa rabu Maria-me mo ensel agaa misa: Go naakiri akea pua madialua ya? Neme aa page meda abi nape-ga. ");
INSERT INTO kew_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Go raburi ensel-me gupa lakesa: Holi Spirit-mi ne madaa ipua Gote-na puri ora so madaame ne waru surubalia. Goa palia-pulu orope go naaki neme madiali. Gore onaanumi go epe naaki nipu epe aa loa Gote-na Si teme. ");
INSERT INTO kew_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Gore paga. Nena aai Elisabet aba onagae yapare nipuna robaa-para naaki meda pia. Abare onaanumi gupa simi: Nipumi nogo naaki mada namadialia simide pare abia nipuna akualu 6-pela popea sa. ");
INSERT INTO kew_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Gore Gote-me napape yaere meda ora naia sa. ");
INSERT INTO kew_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Gore Maria-me lalo: Pagape. Niri Aa Mudu-na kogono ona ya-pulu neme go lae yaenu pa pinawa sa. Goa sa raburi ensel-me pagoa wala pisa. ");
INSERT INTO kew_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Gore orope Maria nipu rekoa aipapulu so rudu-nane ae adaare meda Judia pisa. ");
INSERT INTO kew_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nipu pua no Sekaraia-na ada-para pua odobaawa Elisabet-para epe naare pa lo agaa pua lakesa. ");
INSERT INTO kew_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabet-me Maria-na agaa pagesa raburi mo Elisabet-na robaa-para piri naaki pogosa. Go rabu Elisabet madaa Holi Spirit rulatabesa. ");
INSERT INTO kew_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Go rabu Elisabet-me Maria-para puri paloa gupa sa: Robaa-para pirana page nipu epe puri mealia. ");
INSERT INTO kew_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Gore neme epe kogono napede pare nina Aa Mudu-na agimi ni adola epaa. ");
INSERT INTO kew_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Pagape. Nena agaa pagawade rabu no robaa-para piri naakimiri pedo pua popa pogolaade. ");
INSERT INTO kew_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Aa Mudumi abade ne lagisade agaare neme go ora adolalo pi sa. Goa pe-ga neme raaname omape. Elisabet-me apo agaa gupa sa. ");
INSERT INTO kew_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Gore Maria-me lalo: Nina konemere Aa Mudu-na bi minasaayo. ");
INSERT INTO kew_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Goa pua nina Raba Mi Aa Gote madaa pedo waru pe. ");
INSERT INTO kew_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Niri nipuna kogono ona madaare nipumi ni odome omoa raba muaaya. Gote-me puri pane epe oyae medaloma ni madaa mea epea-pulu abia page orope page go puri pane Gote-me ni raba mualia. Go pea-pulu onaa rayome ni ora epe ona teme. ");
INSERT INTO kew_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Goa pea-ga nipuna biri oro yaalo epe aalia. ");
INSERT INTO kew_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Onaa rayome nipuna agaa waru pagoa paala omemere nipumi oro yaalo epe raba mi kone katalo pia. Goa pea rabu oro yaalo madini onaanu madaa go kone ia. ");
INSERT INTO kew_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nipumiri abade napiaa kogono pisaaya. Go rabu nipumi kone pogati onaa medaloma ratu tisaaya. ");
INSERT INTO kew_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nipumi su amaa aa mudu puri pane aanu rabuaniaawa onaa naraanuna bi minasaasaya. ");
INSERT INTO kew_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Onaame nipuna agaa pagolalo kone imi onaare nipumi oyae waru mea kaloaaya. Pare nipumi amope onaanu gimoa oyae nakasa. ");
INSERT INTO kew_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Niaana akuanu-para aana oraawa lakesa agaa nagimisa. Nipumi niaa Israel su-para piri kogono onaanu raba mulalo ipisa. ");
INSERT INTO kew_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Go-rupare nipumi Abraham-para nipuna orope madini naakinu-para oro yaalo odome omoa raba muaaya sa. ");
INSERT INTO kew_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Elisabet raapu Maria nipu akualu repo pirisa pare orope wala nipuna ada pisa. ");
INSERT INTO kew_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet-na naaki madiape di raname sa raburi mo naaki Jon madisa. ");
INSERT INTO kew_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Elisabet nipuna rurunu-para nipuna adaare padane-para piri onaanumiri Elisabet naaki madiaade remaa pagesimi. Gore Aa Mudumi nipu odome omoa raba misa-pulu nimu Elisabet raapu pedo pu pirisimi. ");
INSERT INTO kew_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Gore yapi 8-pela pa piruare mo naakina yogane ruguta pisimi. Nipuna biri aaraana bi-rupa Sekaraia talo pisimi. ");
INSERT INTO kew_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Go simi pare mo naakina agimi dia sa. Nipuna biri Jon lamina sa. ");
INSERT INTO kew_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Go rabu nimumi lalo: Nena ai Aapa page nena ruru page go-rupa bi ma-ae meda dia yaade simi. ");
INSERT INTO kew_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Go rabu nimumi aaraa agaa mulalo pa kimi robo sua agaa misimi. Nipumi mo naakina biri akepu bi ma-aalia pae kone sua agaa misimi. ");
INSERT INTO kew_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sekaraia-me pepa tape yae meda mea gialepa loa gupa pepa madaa tisa: Go naakina biri Jon lo tisa. Goa tisa raburi mogo pirisimi onaame kone adaapu isimi. ");
INSERT INTO kew_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Go kone adaapu saapirinare mo Sekaraia-na agaa lapaasa. Go rabu nipuna agaa namaarea sa raburi nipumi agaa lapaawa Gote-na bi minasaasa. ");
INSERT INTO kew_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Go raburi mo nimuna adaare padane-para pirisimi onaamere paalame omesimi. Go remaare Judia su rayona pagesimi. ");
INSERT INTO kew_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Onaa rayome go agaa kone-para su kiritua nimu kone adaapu isimi. Nimumi gupa simi: Oropere go naakimiri akea palia pae? Gore mo naaki madaa Aa Mudumi puri kasa adesimi-pulu goa simi. ");
INSERT INTO kew_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Go rabu Holi Spirit aaraa Sekaraia madaa rulatabenaloa nipumi Gote-na lakene agaa gupa lakesa: ");
INSERT INTO kew_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Niaamere Israel su-para piri Gote ora Aa Mudu-na bi minasaamina. Nipu ipua nipuna onaa raba mula epea. Goa pua niaa esepeasa. ");
INSERT INTO kew_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nipumi nipuna kogono aa Devit-na ruru-para naaki mapiraasa. Nipumi go puri pane Raba Mi Aa mapiraasa. ");
INSERT INTO kew_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ora abade go agaare Gote-me nipuna agaa lakene aanu gupa lakesa: ");
INSERT INTO kew_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nipumi niaana iaanumi natinalo raba mealua sa. Gore onaa rayome ratu yawoa niaa talimiri nimuna puri mada mea esepealua sa. ");
INSERT INTO kew_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nipumi niaana akuanu madaa odome omoa raba mealua sa. Gote-me Abraham agaa lakesa waru makuaawa niminaasa. ");
INSERT INTO kew_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Go rabu Gote-me yaa madaa makuaa loa akua Abraham-para agaa gupa lakesa: ");
INSERT INTO kew_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Nimina iaanuna puri madaa wae-rupa pitimiri esepealua sa. Goa puare paala naomalimi pare kogono waru palimilo lakesa. ");
INSERT INTO kew_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Goa pea-ga oro yaalo niaa piralima rabu nipuna ini agaa madaa kogono waru pu epe kone su piralima. ");
INSERT INTO kew_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Go naaki nere oropere so yaa-para pia Gote-na agaa ne aa piraina teme. Ne Aa Muduna ririna pua nipuna pora managola saina. ");
INSERT INTO kew_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Go rabu nipumi onaanuna pupitagi ne kone mea ruboa oro yaalo kagaa pirape kone meaminalo laketea. ");
INSERT INTO kew_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Gore niaana Gote-re pawa pirua odome omoa raba meape kogono pea. Goa pea-ga nipumi so yaa-para i paa niaa madaa epena tea. Go epe paare naare opea-rupa niaana robaa-para maepalia. ");
INSERT INTO kew_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Goa pua so yaa-para i paare omape kone su wae-rupa piri onaanu madaa mea katea. Goa pua niaa epe-rupa pirape pora pamuaminalo paa gialia. ");
INSERT INTO kew_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Oropere go naaki Jon adaa yoa nipuna kone waru puri paboa pirisa. Go rabu nipu onaa napiri su-para pua pirisa. Orope Israel su-para piri onaanumi adalimide di rabu nipu go su gimoa opapaasa. ");
INSERT INTO kew_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Go raburi Rom su-para piri aa mudu Sisar Ogastus-mi puri pane lo meda isa. Nipuna surube onaa rayona bi pepa madaa talepape sa. ");
INSERT INTO kew_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Gore pena ripima bi pepa madaa tisimi raburi Kwirinius-ri nipu Siria suna namba wan gavman aa pirisa. ");
INSERT INTO kew_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Goa puare onaa rayona bi pepa madaa mea sulalore nimuna adaare-para pisimi. ");
INSERT INTO kew_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep-re nipu Nasaret su-para pirisa. Nipu aa mudu Devit-na ruru pirisa-pulu nipu Galili su robo ru-nane pua adaare Nasaret gimoa su Yutia-para pisa. Go su-parare akua Devit-na adaare Betlehem-para pisa. ");
INSERT INTO kew_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nipuna ona Maria raapu bi pepa madaa mea tu sulalo pisipi. Go raburi Josep-me Maria pena rumaasa pare nipu naaki padaa aba pirisa. ");
INSERT INTO kew_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nipu go su Betlehem-para pa pirina Maria-na naaki madiape di rudu sa. ");
INSERT INTO kew_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Go rabu nipuna naaki mupaa madua pa mamina-me mea rigitua isa. Goa pua gawana eta nape wako madaa mea madu isa. Mo kimisu onaa patuladede pi ada aba rulatabesa-pulu gawana ada-para epa pirua madisa. ");
INSERT INTO kew_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Go raburi go su-parare mena sipsip puni aanu medaloma adaare-para amaa aasimi. Gore nimumi ribaane-para nimuna sipsip mena surubisimi. ");
INSERT INTO kew_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Gore Aa Mudu-na ensel meda nimu pirisimi-para ipisa-pulu nimumi adesimi. Go rabu Aa Mudu nipuna epe paana purimi nimu pirisimide-para epaa roasa. Roasa rabu nimumi paalame omo pirisimi. ");
INSERT INTO kew_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Paala omesimi pare ensel-me nimu gupa lakesa: Nimimi paala naomalepape. Pagalepa. Neme nimi piri-para epe agaa mea i-pulu. Go agaa madaare onaa rayome raaname omalimi. ");
INSERT INTO kew_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Abia go ribaare Devit-na adaare-para ona padaneme nimi Raba meape Aa madiaade sa. Go aare ora Aa Mudu Krais yaade. ");
INSERT INTO kew_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nimimi nipuri gupa adoa niminaalimi sa: Nimimi puare naaki meda mamina-me rogaae adalepape. Nipu gawana eta ne kopo madaa apo mapataeme-daa sa. ");
INSERT INTO kew_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ensel-me goa sa raburi ora aipapulu so yaa-para ensel-nu ora adaapu nipu raapu epa pabo aawa Gote-na bi gupa minasaasimi: ");
INSERT INTO kew_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","So yaa-para piri Gote-na biri ora minasaamina simi. Go su amaa onaanuri Gote-me pedo pea-ga epe-rupa pirina simi. ");
INSERT INTO kew_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ensel-numi mo aanu gimoa so yaa-para penaaloa mo mena puni aanu nimumi gupa lala pirisimi: Abia Aa Mudumi niaa aba lagiade-ga aipapulu go naaki madiana-para adamina bai simi. ");
INSERT INTO kew_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nimu aipapulu pua Maria Josep nipu lapo asapua adesimi. Go rabu mo naakiri gawana eta ne wako madaa madu saabaena adesimi. ");
INSERT INTO kew_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nimumi pua adoa aba so ensel-numi mo naaki madaa lakesimide remaa lakesimi. ");
INSERT INTO kew_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mo onaa rayome sipsip puni aanuna remaa pagoa kone adaapu isimi. ");
INSERT INTO kew_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Yapare Maria-me mogo agaa rayo nipuna kone-para mea sua kone adaapu su pirisa. ");
INSERT INTO kew_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mo sipsip puni aanu nimu wala pisimi rabu nimumi pagoa adame oyae madaa Gote-na bi minasaawa yaasa simi. Go remaare mo ensel-numi lakesimide-rupa adesimi. ");
INSERT INTO kew_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Orope yapi ru laapo penaloa mo naakina yogane kepeata pisimi. Go rabu nipuna bi Yesu maasimi. Go biri agimi mo naaki nipu madaa napirina ensel-me go bi lakesa. ");
INSERT INTO kew_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Oropere Josep Maria lapome Moses-na rekena agaa mogeawa to yogane kepeata pisipi. Go rabu page nipu lapome naaki so Jerusalem su-para madia pua Aa Mudu katalo lamua pisipi. ");
INSERT INTO kew_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Go kone madaare Aa Mudu-na rekena agaa madaa go-rupa tisa: Onaanumi naaki mupaa madu sama palimiri go naakinuri Aa Mudu-na kogono pinalo mea kalape. ");
INSERT INTO kew_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Mo Aa Mudu-na rekena agaa meda page mogeaatalo pisipi. Gore to yogane kepene rekena agaa gupa isa: Miru iritalo yaa puluma ipa lapo pa epe yaa lapo pua mea irape isa. ");
INSERT INTO kew_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Go raburi aa meda Simeon Jerusalem su-para pirisa. Go aare ora Gote-na pora kurua epe aa pirisa. Nipumi Israel su-para piri onaanu raba mu mapiraape di ado pirisa. Simeon-re Holi Spirit-mi rulatabesa. ");
INSERT INTO kew_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Holi Spirit-mi nipu-para agaa gupa lakesa: Nere abi naomali pare Gote-me nipuna agaa garulae aa Mea Repae Aa aba adainalo lakesa. ");
INSERT INTO kew_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Gore Holi Spirit-mi Simeon go kone kasa-pulu nipu epe adaa lotu ada-para odobasa. Goa pua agi aaraame rekena agaa mada mogeawa mo naaki Yesu adaa lotu ada-para mea ipisipi. ");
INSERT INTO kew_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ipisipi rabu Simeon-me mo naaki Yesu nipuna kimi upia Gote-na bi minasaawa gupa sa: ");
INSERT INTO kew_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","O Aa Mudu, neme madaa kone sua agaa garulae. Goa pea-ga ni nena kogono aa omano laa. ");
INSERT INTO kew_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Neme niaa raba mulalo paenare nina inimi go adalo. ");
INSERT INTO kew_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Neme onaa rayona ini agaa madaa go managola sua pae. ");
INSERT INTO kew_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Go epe paa padanemere ruru rado-para nena pora mea waatea. Goa puare niaa nena ruru Israel onaanu madaare onaa medalomame epe kone salimi. ");
INSERT INTO kew_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeon-me mo naaki-para agaa lakesa rabu agi aaraa lapo nipu kone adaapu isipi. ");
INSERT INTO kew_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Gore Simeon-me nimu epe puri pane agaa lakelalaawa mo naakina agi Maria gupa lakesa: Pagape. Gote-me go naaki mapiraasa-pulu nipumi Israel su-para piri onaanu adaapu maoyaalia. Goa pea pare medaloma page oro yaalo mapiraalia Gote-me nipu rado piane aa mapiraalia rabu onaa adaapumi nipu madaa waea teme. ");
INSERT INTO kew_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Goa teme raburi go onaanumiri nimuna kudiri pi kone mea waateme. Pare nena pu robaa-para odo omape konere rai napimi-rupa awalia sa. ");
INSERT INTO kew_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Gote-na agaa lakene ona meda Ana pirisa. Nipu Fanuel-na wane-ga Aser-na ruru-para pirisa. Nipuna aani raapu maali 7-pela pirisa. ");
INSERT INTO kew_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Orope nipuna piruasa. Nipumi oro yaalo lotu ada nagimisa pare Gote-na kogonore ribaane-para page naare paalu page ora pu pirisa. Go rabu nipumi eta madaa imaa niti pua beten agu lala pirisa. ");
INSERT INTO kew_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Yesu Gote-para kasimi rabu Gote-para ora pi sa. Goa pua nipumi mo naaki madaa remaa lakesa. Gore onaa rayore Gote-me Jerusalem su-para piri onaa maesepeainalo ado piruaeme-para remaa lakesa. ");
INSERT INTO kew_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Agi aaraa lapome mo Aa Mudu-na rekena agaa rayo lo kiritua so Galili su robo ru-nane pua nipuna adaare Nasaret su pisipi. ");
INSERT INTO kew_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mo naaki nipu aba adaa yoa puri pasa. Go rabu nipu kone ora waru mealaina Gote-me puri page waru kasa. ");
INSERT INTO kew_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Mo Yesuna agi aaraa lapo nipuri oro yaalo maali patinaloa nipu so Jerusalem su-para puala pisipi. Go rabu Juda aanuna olode meda Pasova di adola pisipi. ");
INSERT INTO kew_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Go raburi Yesu nipu maali 12-pela patisa. Go raburi mo olode rudu sa rabu so Jerusalem su-para pisimi. ");
INSERT INTO kew_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Orope so Jerusalem su-para pua kiritaaware mo olode dia naloa adaa reko pisimi. Pare mo ogege aa naaki Yesu nipu Jerusalem su-para pa pirisa. Pirisa pare nipuna agi aaraa lapomere na-adesipi. ");
INSERT INTO kew_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Agi aaraa lapo nipuna konere aba onaa medaloma raapu puana kone sua nipu pisipi. Pulaina yapi meda dia sa pare naaki na-adesipi-pulu nipuna ruru-para adami aanu medaloma adola pisipi. ");
INSERT INTO kew_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nipumi asapu pirisipi pare ora penaame napirisa. Go raburi nipu lapo wala Jerusalem su-para asapula pisipi. ");
INSERT INTO kew_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nipumi asapala pirina yapi repo pa popesa. Go rabu mo lotu ada ru-nane wala asapa amaa ipua epa adasaasipi. Nipu Juda tisaanu raapu pirisaaya. Nipumi nimuna agaa pago nipumi agaa medaloma agaa mulalo pirisaaya. ");
INSERT INTO kew_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Mo nipuna agaa pagesimi ona aanumiri go naakiri kone adaa waru sana loa nimu pogolasaasimi. ");
INSERT INTO kew_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Agi aaraa laapome nipu pua adoa pogolasaawa agimi lalo: Go naaki. Akeane neme saa gimae ya? Nena aaraa saa lapona robaa-parare kedaa ora waru pea. Saame ne asapu pirapa sa. ");
INSERT INTO kew_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nipumi agi aaraa lapo gupa lakesa: Nipimi niri akeane asapape pae? Nipiri naa Aapana ada-para piritalo pawa kone nasapena pae? ");
INSERT INTO kew_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nipumi saa agaa sa pare go agaana re naniminaasipi. ");
INSERT INTO kew_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Gore nipu agi aaraa lapo raapu pua Nasaret su-para pua pirisimi. Go Nasaret ada pua pirua agi aaraa lapona agaa epe-rupa pagoa pirisa. Nipuna agimi mode agaa rayo kone-para mea su pirisa. ");
INSERT INTO kew_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Gore Yesu nipu adaa sa raburi nipuna to yogane-para page kone page ora adaa sa. Goa pua nipu Gote-para su amaa piri onaanu-para nimuna kone-para ora epe naaki kone isimi. ");
INSERT INTO kew_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Aa mudu Sisar Taiberias-re nipuna Surube Su maali 15-pela popesa. Go rabu Pontius Pailat-re so Judia su robo-para namba wan gavman pirisa. Go raburi Herot-re Galili su-para adaa gavman pirua nipuna ame Filip-ri Ituria-para Trakonitis su lapone aa mudu pirisa. Go rabu page Lisanias-re Abilini su-para adaa gavman aa pirisa. ");
INSERT INTO kew_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Go rabu page Anas-para Kaiafas lapore Gote-na miru irae aa mudu lapo pirisipi. Go rabu Sekaraia-na si Jon nipu onaa napiri su-para pirina Gote-me nipu agaa lakesa. ");
INSERT INTO kew_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Go agaa pagoa nipu ipa Jordan popea-para go su rayona agaa pamu lakesa. Pamisa rabu go onaa nimimi kone perekea baptais mealepa lo lakesa. Goa palimi-daare Gote-me nimina pupitagi nape kone mea rubalia sa. ");
INSERT INTO kew_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Go madaare Gote-na agaa lakene aa Aisaia-me pepa madaa gupa tisa: Onaa abuna napiri su-parare aa medame agaa gupa yaatea sa: Aa Mudu-na pora managola salepape. Nipuna pami poranu maredepo yatepape. ");
INSERT INTO kew_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Su awaro rayo-parare su awo pabalepape. Rudu-para pore rayo kadolo rubalepape. Mawae pora rayo maepeaatepape. Pora rayo madaa aana iare mea rubalepape. ");
INSERT INTO kew_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Goa puare onaa rayome Gote-na oro yaalo mapiraape kone mada adalimi. ");
INSERT INTO kew_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Onaa adaapuri Jon-me baptais kanalo ipisimi. Ipisimi raburi nimu gupa lakesa: Nimiri wae paakame madini onaanu pimi. Gote-me nipuna ratu yawape kone epalia-ga nimimi gimalepape lo aapimi laguaaya pa sa? ");
INSERT INTO kew_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nimina wae kone perekealimi-daa adena epe kogono pipape. Nimina pa agaame marekaawa gupa natapape: Abraham-re ora niaana akua pirisa-ga kone naperekealima lo natapape. Pagalepa. Gote-me go aaya aana-re ora Abraham-na sinu mada ma-aulaalia. ");
INSERT INTO kew_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Rai gaapi aba no repena re-para apo ia-daa epe repena ini waru namadialiare po rua repena sulaa-para mea iralia sa. ");
INSERT INTO kew_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nipumi goa sa rabu onaa adaapumi nipu agaa misimi: naamere ake palima ya? ");
INSERT INTO kew_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Gore nimu-para agaa gupa lakesa: Aa medame mamina laapo saliare aa meda mamina nasaliade aa kalape. Eta nape yae salia aame page go-rupa rumaape sa. ");
INSERT INTO kew_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Mone takis mi aa medaloma page nimu baptais mulalo ipisimi. Goa pua nipu agaa misimi: Tisaa, niaame ake palima ya? ");
INSERT INTO kew_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nipumi nimu lakesa: mone-re so gavman-me ta-rupa mealepape. Nimina kone sua meda pa namealepape sa. ");
INSERT INTO kew_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Soldia aa medalomame page Jon nipu agaa misimi: Niaame ake palima ya? Gore nimu gupa lakesa: Nimimi paama koso natapape. Go page makirae agaa naloa onaanuna mone paake namealepape. Ora nimina kogono madaa mone mi-rupa agu mealepape sa. ");
INSERT INTO kew_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Go epe agaa adaapu lakesa-pulu onaanumi kone puri paloa sua gupa simi: Go Jon-re Gote-na Mea Repae Aa yapae dia yapae kone isimi. ");
INSERT INTO kew_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kone gupa isimi raburi Jon-me nimu gupa lakesa: Neme nimi madaa pa ipame baptais meaato pare orope aa meda epaliare nipuna purimi ni maoge yaalia. Nipu ora epe ta-pulu neme nipuna aariti esepea kege radepetalo palua. Pare nipumi baptais epa mealia rabu Holi Spirit-na puri repena sulaa nona piane nimi baptais gialia. ");
INSERT INTO kew_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nipuna lama sapara nipuna kimi ripinua epalia. Nipuna wit-na ini ripu raapu raloa epe yaenu kiritae ada-para sulalo palia sa. Pare mo wit-na ini o yaliadenuri naudinape repena sulaa-para mea lopalia rabu pa roalia sa. ");
INSERT INTO kew_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon-me nimuna kone maredepo yatalo epe agaa rado rado lakeloa mogeasa. ");
INSERT INTO kew_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Go agaa lakesa pare Jon-me aa mudu Herot-para nena amena ore Herodias nayolo rumaape lo lakesa. Go page Herot-me pisa waea rayo madaa agaa lakesa. ");
INSERT INTO kew_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Goa pisa-pulu Herot-me go agaa madaa yaala poloa kalabus ada-para mapataasa. ");
INSERT INTO kew_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Onaanu rayo baptais misimi rabu Yesu nipu page baptais misa. Nipu baptais mua beten lala pirina yaa pora lobesa. ");
INSERT INTO kew_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Goa pua Holi Spirit yaa puluma nona piane so yaa gimoa ipisa. Gore Yesu madaa ipisa raburi so yaa-para agaa meda gupa pagisimi: Nere ora nina epe Si. Neme ne madaa ora pedo pi sa. ");
INSERT INTO kew_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu nipuna kogono mea ripima pisa raburi nipuna maali 30-pela pirisa. Onaa rayomere nipu Josep-na si niminaasimi. Gore Josep-na aaraare Heli. ");
INSERT INTO kew_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli nipuna aaraare Matat pirisa. Matat nipuna aaraare Livai pirisa. Livai nipuna aaraare Melki pirisa. Melki nipuna aaraare Janai pirisa. Janai nipuna aaraare Josep meda pirisa. ");
INSERT INTO kew_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep nipuna aaraare Matatias pirisa. Matatias nipuna aaraare Amos pirisa. Amos nipuna aaraare Nahum pirisa. Nahum nipuna aaraare Esli pirisa. Esli nipuna aaraare Nagai pirisa. ");
INSERT INTO kew_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai nipuna aaraare Mat pirisa. Mat nipuna aaraare Matatias meda pirisa. Matatias nipuna aaraare Semen pirisa. Semen nipuna aaraare Josek pirisa. Josek nipuna aaraare Joda pirisa. ");
INSERT INTO kew_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda nipuna aaraare Joanan pirisa. Joanan nipuna aaraare Resa pirisa. Resa nipuna aaraare Serubabel pirisa. Serubabel nipuna aaraare Sealtiel pirisa. Sealtiel nipuna aaraare Neri pirisa. ");
INSERT INTO kew_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri nipuna aaraare Melki pirisa. Melki nipuna aaraare Adi pirisa. Adi nipuna aaraare Kosam pirisa. Kosam nipuna aaraare Elmadam pirisa. Elmadam nipuna aaraare Er pirisa. ");
INSERT INTO kew_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er nipuna aaraare Josua pirisa. Josua nipuna aaraare Elieser pirisa. Elieser nipuna aaraare Jorim pirisa. Jorim nipuna aaraare Matat meda pirisa. Matat nipuna aaraare Livai meda pirisa. ");
INSERT INTO kew_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai nipuna aaraare Simeon pirisa. Simeon nipuna aaraare Juda pirisa. Juda nipuna aaraare Josep meda pirisa. Josep nipuna aaraare Jonam pirisa. Jonam nipuna aaraare Eliakim pirisa. ");
INSERT INTO kew_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim nipuna aaraare Melea pirisa. Melea nipuna aaraare Mena pirisa. Mena nipuna aaraare Matata pirisa. Matata nipuna aaraare Netan pirisa. Netan nipuna aaraare Devit pirisa. ");
INSERT INTO kew_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit nipuna aaraare Jesi pirisa. Jesi nipuna aaraare Obet pirisa. Obet nipuna aaraare Boas pirisa. Boas nipuna aaraare Salmon pirisa. Salmon nipuna aaraare Nason pirisa. ");
INSERT INTO kew_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason nipuna aaraare Aminadap pirisa. Aminadap nipuna aaraare Atmin pirisa. Atmin nipuna aaraare Arni pirisa. Arni nipuna aaraare Hesron pirisa. Hesron nipuna aaraare Peres pirisa. Peres nipuna aaraare Juda meda pirisa. ");
INSERT INTO kew_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda nipuna aaraare Jekop pirisa. Jekop nipuna aaraare Aisak pirisa. Aisak nipuna aaraare Abraham pirisa. Abraham nipuna aaraare Tera pirisa. Tera nipuna aaraare Nahor pirisa. ");
INSERT INTO kew_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor nipuna aaraare Seruk pirisa. Seruk nipuna aaraare Reu pirisa. Reu nipuna aaraare Pelek pirisa. Pelek nipuna aaraare Eber pirisa. Eber nipuna aaraare Sela pirisa. ");
INSERT INTO kew_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela nipuna aaraare Kainan pirisa. Kainan nipuna aaraare Arpaksat pirisa. Arpaksat nipuna aaraare Siem pirisa. Siem nipuna aaraare Noa pirisa. Noa nipuna aaraare Lamek pirisa. ");
INSERT INTO kew_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek nipuna aaraare Metusela pirisa. Metusela nipuna aaraare Enok pirisa. Enok nipuna aaraare Jaret pirisa. Jaret nipuna aaraare Mahalalel pirisa. Mahalalel nipuna aaraare Kenan meda pirisa. ");
INSERT INTO kew_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan nipuna aaraare Enos pirisa. Enos nipuna aaraare Set pirisa. Set nipuna aaraare Adam pirisa. Adam nipuna aaraare Gote pirisa. ");
INSERT INTO kew_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Holi Spirit Yesu nipu madaa rulatabenaloa Yesu nipu ipa Jordan-na gimoa pisa. Go rabu Holi Spirit-mi onaa napiri su-para mea pisa. ");
INSERT INTO kew_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Mo onaa napiri su-para Yesu nipu yapi 40-pela pirina Satan-me pupitagi manatalo ko tisa. Go raburi Yesu nipu eta ora nanisa-pulu go yapi rayo dia naloa Yesu nipu reame omesa. ");
INSERT INTO kew_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Gore Satan-me Yesu-para lalo: Nere Gote-na Si yaalore go aana-nu bret ma-aulaawa mea na sa. ");
INSERT INTO kew_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Go rabu Yesumi Satan nipu-para gupa lakesa: Gote-na agaa i buk madaa gupa ia sa: Onaa bret agu nanalepape. Dia, pare Gote-na agaa rayo pagoa oro yaalo pitimi sa. ");
INSERT INTO kew_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Go rabu Satan-me Yesu upaa nona piane mapaawa sone lamua pua aipapulu su amaa piri onaa rayo ma-adasa. ");
INSERT INTO kew_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Goa puare Satan-me Yesu nipu lakesa: Go su amaa piri onaanuri go puri rayo-para nimuna epe oyae rayo neme ne mada gialua. Go yaenu rayore ni misude-pulu neme aa meda katalo paluare mada palua sa. ");
INSERT INTO kew_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Gore go ada yaenuri ni madaa rumu pege pua beten te-daare rayo ne gialua sa. ");
INSERT INTO kew_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesumi lalo: Gote-na agaa i buk madaare gupa ia: Nimimi Mudu Gote padanena bi minasaawa nipuna kogono padane pipape sa. ");
INSERT INTO kew_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Wala Satan-me Yesu nipu so Jerusalem su-para lotu ada madaa mea pua puaa mapiraasa. Go-para mapiraasa rabu Yesu-para lalo: Nere ora Gote-na Si yaliare go-pare aawa no su amaa pogola. ");
INSERT INTO kew_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Go madaare Gote-na agaa i buk-mi gupa ta: Nipuna ensel-nu laketea raburi nimumi ne waru surubalimi sa. ");
INSERT INTO kew_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Gote-na buk-mi page gupa ta: Goa puare nimuna kimi ripinaalimi-pulu aana eke medame nena aa mada natalia sa. ");
INSERT INTO kew_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Go raburi Yesumi agaa gupa lakesa: Gote-na buk madaa agaa meda gupa ia: Nena Mudu Gote-na kone adolalo ko natape sa. ");
INSERT INTO kew_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satan-me Yesu oyae rayo mea mapatalo ko tisa pare wala ko nati Yesu gima pisa. ");
INSERT INTO kew_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Goa pisa rabu Yesu Holi Spirit-na puri waru misa. Go rabu nipu Galili su-para wala pisa. Nipuna remaare go su rayona aba pago kiritisimi. ");
INSERT INTO kew_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Go rabu nimuna lotu adanu-para pua onaa agaa mogeasa. Mogeasa raburi nimumi nipuna bi minasaasimi. ");
INSERT INTO kew_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Goa puare Yesu nipuna Nasaret su-para puaa-mama pu pisa. Go adaare-para nipu oge naaki rabu pirua adaa sa. Goa pisa raburi Kitu Pirape yapiri nipumi abade pala pisa-rupa lotu ada-para pua Gote-na agaa dipiala aasa. ");
INSERT INTO kew_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Go rabu nimumi Gote-na agaa lakenalo Aisaia-na buk Yesu nipu mea kasimi. No buk loboa agaa meda asapuare gupa dipisa: ");
INSERT INTO kew_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Aa Mudu-na Holi Spirit-ri ni madaa epa pia. Nipumi ni mudu aa mapiraawa onaa naraa nipuna epe agaa lakelanolo pisa. Nipumi ni mea epenasa-daa wae adini onaanu epe agaa laketalo ipisu. Nimu ini wae onaanu wala maepeaatalo ipisu. Nimu wae-rupa piri onaa rayo maesepeaatalo ipisu. ");
INSERT INTO kew_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Aa Mudu nipuna onaanu epe-rupa mapiraape di laketo. Go kogono madaare nipumi ni mea epenasa. ");
INSERT INTO kew_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesumi apo agaa pepa madaa dipi kiritua buk rogaawa mo buk surubae aa kaloare nipu agaa laketalo pirisa. Goa puare mo lotu ada-para pirisimi onaamere nipu padane odoba isimi. ");
INSERT INTO kew_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Gore nimu agaa ripimaawa lakesa: Abiare go agaa dipiawa rabu pagamedere Gote-na agaana re-re ora gupa epaade. ");
INSERT INTO kew_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Go raburi onaanumi nipu madaa epe kone sua nipuna ora epe lakene agaa madaa ora raaname omesimi. Goa pisimi pare nimumi lalo: Go aare Josep-na side kone salema. ");
INSERT INTO kew_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Go rabu nipumi nimu-para lalo: Nimimi saa pi agaa pagalimi kone salo. Gore dokta nena bipa nena yaina aba maepeaa teme kone salo. Goa teme kone salo: Neme Kaperneam su-para napiaa pawade remaa pageme. Goa pea-ga neme go niaana adaare-para page abi pape teme kone salo sa. ");
INSERT INTO kew_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Pagalepa. Gote-na agaa lakene aare nipuna adaare-para go onaanumi nipu epe-rupa nasurubeme sa. ");
INSERT INTO kew_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Goa pea-ga nina agaa waru pagalepa: Elaija pirisade raburi ona wasaa adaapu Israel su-para pirisimi. Go raburi maali repo-para akua 6-pela popesa pare yai naipisa. Goa puare su rayona reae adaape pabesa. ");
INSERT INTO kew_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Goa pisa pare Gote-me Elaija mo Israel ona wasaanu piri-para namea rapaasa. Dia, pare nipumi no Saidon su-para Sarefat adaare piri ona wasaa-para mea rapaasa. ");
INSERT INTO kew_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Go puare Gote-na agaa lakene aa Elisa pirisa Raburi Israel su-para yakimi ti onaa adaapu pirisimi. Goa pisa pare nimuna rikiraana padane-daa namakaapu yaawa epeasa. Dia, pare Siria su-para piri aa Neman-na padanere maepeaasa. ");
INSERT INTO kew_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yesumi agaa gupa sa rabu mo lotu ada-para pirisimi onaanumi go agaa pagoa nimuna pu robaa-para ratu yawesimi. ");
INSERT INTO kew_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nimumi ratu yawoa Yesu ripinaawa nipu so adaare-nane mea ratu tisimi. Go adaarere rudu meda madaa warisimi rabu go pore rata mea pua nipu lopatalo pisimi. ");
INSERT INTO kew_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Goa pisimi pare nipu onaa rayona rikiraana pua wala pisa. ");
INSERT INTO kew_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesu nipu adaa su robo Galili-na adaare Kapaneam-para pisa. Go Kitu Pirape Yapi rabu nipumi onaa rayo Gote-na agaa mogeasa. ");
INSERT INTO kew_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mogeasa rabu ora puri pane agaa lakesa-pulu onaanumi ora paalame omoa ki kidipaa ragi tu pirisimi. ");
INSERT INTO kew_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Go rabu mogo lotu ada-para aa meda pirisa. Go aa madaare wae remo meda pirua nipumi go aa ora puri paloa rui gupa malasa: ");
INSERT INTO kew_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Aya, go Nasaret su-para piri aa Yesu-ya. Nere niaa madaa ake pulalo epae pae? Nemere ne adaede-ga neme niaa tulalo epae pae? Nere ora Gote-na epe agaa lagiape aa yaade sa. ");
INSERT INTO kew_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Goa sa rabu Yesumi remo-para agaa mana lalo: Neme agaa loraawa go aa gimoa pu sa. Goa pua mo wae remome mo aa tua gona rikiraana malopaawa go aa gimisa. Goa pua mo wae remome mo aa tua malopaawa go aa gimisa. Goa pisa rabu go aa wala namaeyasa. ");
INSERT INTO kew_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Go rabu onaa rayome ki kidipaa ragi tua nimumi lakelala pu pirisimi. Ora pua agaa gupa simi: Go agaare ake agaa ya? Go aame nipuna mo wae remo madaa agaa mana lakenaloa nimumi agaa pagoare mo aa gimoa pula simi. ");
INSERT INTO kew_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Goa pisa raburi Yesu nipuna remaa go su rayona mone mone laama pisimi. ");
INSERT INTO kew_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu nipu rekoa go lotu ada gimoa puare Saimon Pita-na ada-para pua odobasa. Mo Saimon Pita-na orena agiri kekapu yaina ora wae meda omesa-pulu Yesumi raba minalo lakesimi. ");
INSERT INTO kew_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu nipu mo yaina ome onana reke re-para pua mo yaina-para rakepea lo agaa lakesa. Go rabu-ga mo onana yaina perekea pora pamua nimuna eta oyae managola sasa. ");
INSERT INTO kew_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Naare pabola pupulaina onaa medalomana adami aanu yaina omesimi-pulu go aanu Yesu piri-para lamua ipisimi. Yesu nipuna ki mo onaa rayona aalu madaa sama pisa. Goa puare nimuna yaina rayo maepeaama pisa. ");
INSERT INTO kew_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mo wae remonumi onaa adaapu gimisimi rabu gupa yaasimi: Nere Gote-na Si simi. Gore remonumi Yesu nipu ora Gote-na Mea Repae Aa niminaasimi-pulu nipumi nimu-para agaa nalaketepape loa agaa maloraasa. ");
INSERT INTO kew_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ora abasade yapi lapaasa rabu Yesu go adaare gimoa onaa napiri su-para pisa. Goa pisa pare onaa rayome nipu asapua piri-para ipisimi. Go rabu nipuna pena-ga pa piramona kone isimi. ");
INSERT INTO kew_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Goa simi pare nipumi nimu gupa lakesa: Ni adaare medaloma-para pua Gote-na Surube Su madaa Epe Agaa laketoa. Gote-me ni mea rapaasare go kogono pamu panolo pisa. ");
INSERT INTO kew_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Gore nipumi Gote-na Epe Agaa Judia su robona lotu adanu-para mogeasa. ");
INSERT INTO kew_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Oro medare Yesu ipa Genesaret ini repaa-nane aasa. Go rabu onaanu Gote-na agaa pagolalo maregepea-mama pua nipu piri ipisimi. ");
INSERT INTO kew_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Go rabu ipa ini repaa-nane oge ipunu lapo mea adibasimi-daa Yesumi adesa. Go ena meape aanumi mo ipunu gimoa ena agona radepeala pirisimi. ");
INSERT INTO kew_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu nipu Saimon-na ipunu madaa pua pirisa. Goa pua nipumi Saimon-para lalo: Ipa repaa-nane gimoa ipunu ogesi-daa yola pua bana sa. Go rabu Yesu ipunu madaa piruare onaa adaapu agaa mogeasa. ");
INSERT INTO kew_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Mo onaa agaa aba lakelo kirituare orope Saimon gupa lakesa. Ipunu madaa mo ipa rikiraana bana sa. Go ipa rikiraana puare ena agona lopaniaawa ena mealepape sa. ");
INSERT INTO kew_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimon-me gupa sa: Aa Mudu, abia go ribaare niaa rayome kalai adaa pa amaa pare niaame ena meda abuna nameama. Yapare neme apo lae-daa neme ena agona lopaniaato-daa sa. ");
INSERT INTO kew_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nimumi goa puare ena ora adaapupe misimi. Ora adaapu waru misimi-pulu agona kurupu tabolalo pisa. ");
INSERT INTO kew_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Goa pisa raburi mo nimuna yagonu medaloma ipunu rado madaa pirua raba minalo ki wage pisimi. Gore nimu ipuare mo ipunu lapo madaa mo ena mea marulatabasimi. Go raburi mo ipunu lapore ena kedaamere ugitalo pisa. ");
INSERT INTO kew_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon Pita-me go adoa Yesuna kibu-para rumu koba pua gupa sa: Aa Mudu, neme ni gimoa ne pu. Niri epe aa-daa dia yapare ora wae aa pi sa. ");
INSERT INTO kew_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Pita-para aa medaloma nipu raapu aasimi aanumiri mogo ena adoa paalame omesimi. ");
INSERT INTO kew_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saimon nipuna yago lapore Sebedi-na si Jems-para Jon lapore nipu page pogolasaasipi. Gore Yesumi Saimon lakesa: Neme paala naomape. Oropere go ena meae-rupare onaa mealepape sa. ");
INSERT INTO kew_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Go raburi ena mi aanumi nimuna ipunu ipa repaa-nane yolasa suare ena oyae rayo gimoa Yesu nipu raapu pisimi. ");
INSERT INTO kew_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Rana medare Yesu su adaare meda-para pirisa rabu aa meda yakimi tua kikiaa rayo rugula mimi pi aa pirisa. Go aa nipumi Yesu adoare su amaa lopoa nipuna ini agaa adaniaawa gupa sa: Aa Adaa, nena koneme ni maepeaano kone sali-daare Gote-me ni maepealia. ");
INSERT INTO kew_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Go rabu Yesumi nipu madaa ki salaawa lalo: Neme nena rerenu kaapu na kone salo sa. Pena goa lalaina-ga go yakimi ti aa-na rere aba dia sa. ");
INSERT INTO kew_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Goa pisa rabu Yesumi nipu-para agaa puri pane gupa sa: Neme wala aa meda nalakelape. Nena to yoganere Gote-na miru irae aame adena abi pu. Goa puare Moses-me sa-rupa miru irae yae iraina. Goa pali raburi onaanumi mo nena yaina dia yana-rupa mada adalimi sa. ");
INSERT INTO kew_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Goa sa pare mo Yesuna pisade kogonore su ada rayona pago kiritisimi. Goa pisa raburi onaa adaapumi nipuna agaa pagolalo ipisimi. Go page nimuna yaina rayo rakepeainalo ipisimi. ");
INSERT INTO kew_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Goa pisimi raburi nipu oro yaalo onaa napiri su-para puare nipumi beten pua lo pirala pisa. ");
INSERT INTO kew_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Oro medare Yesu nipumi Gote-na agaa onaa rayo mogeaata pirisa. Go rabu Farisi aanu-para rekena agaana tisaanu-para pirisimi. Nimuri Galili su robo-para Judia su robo-para Jerusalem su robo-para go su rayona adaare-para epa-mama pua ipisimi. Go rabu Aa Mudumi Yesu nipu puri kasa-pulu yaina ome onaa adaapu maepeaasa. ");
INSERT INTO kew_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Go rabu aa medalomame reke madaa aa meda riaa ipisimi. Go aa-na kikiaa uni rayo omapasa. Nipu ada ru-nane riaa odobaawa Yesu nipu piri re-para pua ru sulalo pisimi. ");
INSERT INTO kew_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Goa pisimi pare ada rulatabesa-pulu mo aa mada naria ipisimi. Mo ada rulatabesa raburi mo yaina ome aa wala so ada masaa-nane riaa opasasimi. Riaa puare ada pira kegepemina lapaawa mo onaa pirisimi rikiraa madaa lopaniaawa Yesu re-para masaasimi. ");
INSERT INTO kew_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesumi mo aanu nimu waru kone rulasimi-pulu nipumi go aa adoa lalo: Nena pupitaginu mea rubaato sa. ");
INSERT INTO kew_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Goa sa raburi rekena agaa tisaanu-para Farisi aanu-para nimuna bipa agaa adaapu gupa simi: Go aare aapi ya? Nipumi Gote-para ero agaa ta. Pupitaginu mea rubape aare go su amaa meda dia yaade. Go kogonore Gote-me padane mada palia simi. ");
INSERT INTO kew_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesumi nimuna kone-para aba adokaru misa-pulu nimu-para agaa gupa lakesa: Nimina kone adaapuri akolo imi ya? ");
INSERT INTO kew_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Akepu toa-daa epeaalia yapae? Pupitaginu mea rubaayo toa rabu epeaalia yapae? Neme ne rekoa pu toa puri patea yapae? ");
INSERT INTO kew_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yapare neme agaa laketoa rabu Gote-na Mea Rapae Aare neme go su amaa puri mua kogono mada palua-daa adalimina. Goa pua wae yaenu neme mea rubaato. Go rabu mo uni oma pae aa-para agaa gupa lakesa: Neme go lalo-ga nena u pati yainu mea ripinua nena ada pu sa. ");
INSERT INTO kew_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Pena goa lalaina go pirisimi onaana ini agaa madaa aipapulu rekesa. Mo aa nipuna u pati yaenu mea ripinua ada pisa. Nipu pua re Gote-na bi minasaama pisa. ");
INSERT INTO kew_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Go raburi onaa rayo ora pogolasaasimi. Nimumi paala omoa pora rado meda adoa Gote-na bi minasaasima ");
INSERT INTO kew_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yesu nipu puare mone takis mi aa Livai nipuna ada-para pirina adesa. Go aare Yesumi gupa lakesa: Ni rata mea epape sa. ");
INSERT INTO kew_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Gore mo aa nipuna oyaenu rayo gimoa Yesu rata mea pisa. ");
INSERT INTO kew_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Goa puare Livai-mi Yesu eta adaa yawesimi. Yawesimi rabu takis mi aa adaapu page pa onaa adaapu page nimu padane nipuna ada-para eta no pirisimi. ");
INSERT INTO kew_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Go rabu Farisi aa medaloma-para nimuna rekena agaa tisaanu nimumi Yesuna disaipel aanu-para agaa adaapu simi. Gore nimumi gupa simi: Nimiri go takis mi aanu-para wae riabo aanu raapu go etare akolo neme pae? ");
INSERT INTO kew_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Go rabu Yesumi agaa gupa lakesa: Yaina naome onaare dokta piri-para napeme pare yaina ome onaare dokta piri-para pemede. ");
INSERT INTO kew_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Neme ora epe kone i onaanu-para kone perekealiminalo agaa nalaketa ipisu. Dia, pare wae riabo onaa rayome kone perekealiminalo su amaa ipisu sa. ");
INSERT INTO kew_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Onaa medalomame Yesu agaa gupa lakesimi: Jon-na disaipel aanumiri rana adaapu eta niti pua go eta gimoa beten teme. Farisi aanuna disaipel aanumi page goa peme. Yapare nena disaipel aanumi eta pa no ipa oyaeyae pa apo neme-daa simi. ");
INSERT INTO kew_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Goa simi rabu Yesumi nimu lakesa: Ona rumaatalo aa meda nipuna adami onaa raapu piralia-daare go adami onaanu eta gimoa pa piralimi ya? Dia gupa napemede. ");
INSERT INTO kew_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Dia, pare go ona rumaatalo pea aare orope nimumi nipuna adami onaanu raapu mea palimi. Go di raburi eta madaa niti pua pa piralimi sa. ");
INSERT INTO kew_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesumi nimu-para saa agaa page meda gupa sa: Aa medame kagaa mamina meda mea riripia abana mamina narabutemede. Pare aa medame goa palimi-daare nipuna kagaa mamina maoyaawa mo kagaa rugini mamina-re mogo abana mamina rado-rupa aalia. ");
INSERT INTO kew_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Go page aa medame abana meme mena yogane-para kagaa ipa wain nano pabalia. Yapare aa medame goa paliare mo kagaa wain ipame abana meme mena yogane rugula tabalia. Goa pua mo ipa wain su madaa koyoa mo meme mena yogane page mada o yalia. ");
INSERT INTO kew_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Gupa peme-ga kagaa ipa wain-ri kagaa meme mena yogane-para mea koyo pabalepape. Goa pali rabu ipa wain no pabape yogane laapo epeaalia. ");
INSERT INTO kew_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Yapare pa aa medame abana ipa wain aba noare nipumi kagaa wain madaa kone naia. Dia-ga nipumi lalo: Abana wain-ri ora epe ta tea sa. ");
INSERT INTO kew_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Orope Kitu Pirape Yapi di meda rabu Yesu nipu wit-na ini maapu pamisa. Go rabu nipuna disaipel aanumi mo wit-na ini medaloma keresimi. Goa puare nimuna kimi rakepea nisimi. ");
INSERT INTO kew_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Go kogono pisimi rabu Farisi aanu medalomame nimu-para lalo: Go pemeare Kitu Pirape Yapi di raburi rekena ia-ga akolo naratua kogono peme pae? ");
INSERT INTO kew_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Go raburi Yesumi nimu-para agaa gupa lakesa: Nimimi Devit-para nipuna adami aanu-para nimumi reame omoa pisimiyaade remaa nadipisimi ya? ");
INSERT INTO kew_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Reame omesimi rabu nipumi Gote-na ada ru-nane pua odobasa. Goa pua miru irae aame Gote kane bret misa. Devit-mi noare nipuna adami aanu page kasa. Goa pisa pare niaana rekena i agaa madaare Gote-na miru irae aanu padanemere go bret mada nalimi simi. ");
INSERT INTO kew_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesumi nimu gupa lakesa: Onaa Raapu Pirape Siri Kitu Pirape Yapi diri nipuna surubea sa. ");
INSERT INTO kew_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Orope Kitu Pirape Yapi di meda raburi Yesu lotu ada-para pua onaanu agaa pamu lakesa. Go ada-parare aa meda pirua nipuna popoke kiri ora o sa. ");
INSERT INTO kew_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Go rabu Farisi aanu-para rekena agaa tisa aanumiri Yesu madaa koso lape agaa talo pirisimi. Goa pisimi-pulu nimumi waru adolalo mo yaina ome onaa Kitu Pirape Yapi di rabu Yesumi onaa maperekeaata palo kone mulalo adaba pirisimi. ");
INSERT INTO kew_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Goa pisimi pare Yesumi nimuna kone adesa-pulu mo ki rudu ae aa gupa lakesa: Ne rekoa go-pare ipu. Goa sa rabu nipu rekoa pua aasa. ");
INSERT INTO kew_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Gore Yesumi nimu-para lalo: naamere Kitu Pirape Yapi di raburi rekena agaamere ake ta pae? Niaame epe kogono pamina yapae maoyaape kogono pamina ya? Niaame onaanu raba meamina yapae niaame onaanu tu maomamina ya? ");
INSERT INTO kew_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Go rabu Yesumi aa rayo adabaina sana go aa goa lakesa: Nena ki epe-rupa ridula sa. Mo aame nipuna ki ridulasa rabu nipuna kide ora epe sa. ");
INSERT INTO kew_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Go rabu nimumi Yesu-para ratu waru yawoa nimumi Yesu madaa niaame ake pamina yapae simi? ");
INSERT INTO kew_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Go raburi Yesu nipumi beten talo rudu meda madaa pisa. Go rabu Gote re-para beten lala pirina yapi paa lapaasa. ");
INSERT INTO kew_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Naare rapasa raburi nipuna disaipel aanu-para ipulupa loa yaasa. Goa pua nimuna rikiraana piri aa ru repona bi loa sana ora aposel kogono aanu mapiraasa. Nimuna bi gupa sa: ");
INSERT INTO kew_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Saimon wala Yesumi bi Pita maasa. Nipuna ame Andru-para meda Jems-para Jon-para Filip-para Batolomyu-para ");
INSERT INTO kew_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu-para Alfius-na si Jems-para Saimon nipuna ruru bi Selot nipu-para ");
INSERT INTO kew_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jems-na si Judas-para Judas Iskariot-para go aa rayore Yesumi mapiraasa. Judas Iskariot-re nipu orope Yesu iaana kina mea isade aa yaade. ");
INSERT INTO kew_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Gore Yesu nimu raapu meda rabu rudu madaa kilipia ipuare su paluapae-para nipuna disaipel aanu raapu epa rekasimi. Go rabu onaa adaapu pirisimi. Nimuri Judia su rayo-para Jerusalem su-para nabisi adaare Tair Saidon lapo-para piri onaanu epa kiritasimi. ");
INSERT INTO kew_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nimu rayo ipuare nipuna agaa pagoa nimuna yaina maepeainalo ipisimi. Go page onaa adaapu wae remome tinu epenaloa Yesumi maepeaasa. ");
INSERT INTO kew_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Go raburi onaa rayome nipu kimi oraatalo pisimi. Nipuna purimi mo yaina ome onaa rayo maperekeasa-pulu goa pisimi. ");
INSERT INTO kew_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesumi nipuna aposel kogono aanu waru adaba sua lalo: Nimi naraa aanu raaname waru omalimina. Gote-na Surube Su rayo mada adalimina. ");
INSERT INTO kew_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nimi onaanuri abia reame apo omeme-ga raaname omalimina. Nimina robaa rulatabenalo eta adaapu nalimina. Abia nimimi re apo lo pimiri oropere giri lo epe-rupa pirua raaname omalimina. ");
INSERT INTO kew_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ni Onaa Raapu Pirape Aa-na Sina agaa pagalimi rabu pa onaanumi nimi adoa rono omoa nimi masaa rilalimi. Goa pua nimumi ero agaa loa nimi wae bi gialimi pare go kone madaare pa raaname omalepape. ");
INSERT INTO kew_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nimumi nimi-para goa palimi-daare nimimi raana ora waru omoa pedo pipape. Pagalepa. Aba nimina akuanumi apo kone mogeawa agaa lakene aanu-para page go-rupa pisimi. Gore nimina so yaa-para i yago tape yaere ora epe adaape mealimina. ");
INSERT INTO kew_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pare nimi abia amo ne onaanuri waru adalepape. Nimina pa epe-rupa pirape kone aba muaeme. ");
INSERT INTO kew_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Abia go onaanu nimiri eta noa nimina robaa-para rubita-ga oropere reame waru omalimina. Abia giri teme onaanuri nimimi waru adalepape. Oropere nimi re ora waru lo pitimi. ");
INSERT INTO kew_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Go page onaa rayome nimi madaa pedo palimiri nimimi waru adalepape. Nimuna akuanumi yaa agaa ne aanu-para page aba gupa pisimi. ");
INSERT INTO kew_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yapare nina agaa pageme onaanu nimi lagialo: Nimina iaanu madaa pedo pi kone salepape. Onaa medalomame nimi-para wae ratu yawape kone salimiri ora pi loa epe kone sua raba meape. ");
INSERT INTO kew_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Onaa medalomame nimi-para wae agaa temere beten loa maepeaatepape. Onaa medalomame nimi maoyaatalo palimiri go page beten loa raba mealepape. ");
INSERT INTO kew_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Gore onaa medame nena pea-para paarame rola taliare perekea tua medane tina lape. Go page onaa medame nena seket mea paliare gore nena siot meda page kalape. ");
INSERT INTO kew_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Aa medame oyae rome teare gore kalape. Go page onaa medame nena oyae mua saapiralimiri wala abi aipapulu gi pi natapape. ");
INSERT INTO kew_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Onaanumi raana pi kone sulalo palimi-daare nimi page kone padane go-rupa salepape. ");
INSERT INTO kew_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Gore nimimi onaa meda madaa pedo pi kone salimi-daare nimumi nimi madaa pedo pi kone salimi. Go pea-ga go kone madaare puri mada namealimi. Dia-ga pupitagi nape onaa medalomame page nimu madaa pedo pi kone salimi-daare nimumi go page kone padane-rupa salimina. ");
INSERT INTO kew_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Go page nimi-para epe kone salimide onaanuri nimimi page nimu-para epe kone salimiri go madaare epe puri namealimi. Dia-ga pupitagi ne onanumi page goa peme. ");
INSERT INTO kew_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Go page nimimi onaa medaloma yaenu kaloa wala aba gi kone salimiri go kone madaare epe puri namealimi. Dia-ga pupitagi ne onaanumi page waea peme onaanu oyae kateme. Gore yago mada abuteme kone sua kateme. ");
INSERT INTO kew_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pare nimimi go kone namogeatepa. Nimimi iaanu pedo pua raba mealepape. Go page oyaenu kaloa raba mealimi raburi gore niaa madaa epe yae mada abuteme kone nasalepape. Gote-me ora pi nateme-nu page pupitagi neme onaanu page nimu madaa epe kone sua odome omea. Go epea palimiri nimi so yaa-para pia Gote-na si wanenu pitimi. ");
INSERT INTO kew_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nimimi onaanu odome omalimiri Aapa yaa madaa piame page odome omalia. ");
INSERT INTO kew_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Nimimi onaa medaloma madaa epe onaa wae onaa kone nasua natapape. Goa palimiri Gote-me page nimi madaa koso lape agaa-rupa namea rumaalia. Go page onaa medaloma madaa kedaa pi kone narumaatepape. Goa palimiri Gote-me page nimina kedaa narumaalia. Nimimi onaa medana waeanu mea rubalimiri Gote-me page nimina waeanu mada mea rubalia. ");
INSERT INTO kew_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nimimi oyae pa onaanu pa katemere Gote-me page nimi go kone madaa oyaenu pa gialia. Gialia rabu nimina ki-para waru rubalia rabu rulaniaawa marubiaawa koyaalia. Nimimi oyae rumaawa onaanu katemede-rupare Gote-me go kateme-rupa rayo abuloa saniaalia. ");
INSERT INTO kew_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesumi nimu-para saa agaa meda wala gupa sa: Ini rubu pi aa medame nipuna ini rubu pi yago pora mada mea waatea ya? Dia-ga nipu lapo rata naaku-para lopalipi. ");
INSERT INTO kew_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Go page skul teme nogo naakinuri nimuna tisaa-rupa mudu mada piralimi ya? Dia, pare nimu aba skul waru loare nimu page wala mo tisaa nona palimi. ");
INSERT INTO kew_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Gore mo nena amena ini-para ini mare apo ia te pare nena ini-para adaape mo ia aba mea. ");
INSERT INTO kew_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Akea pua nimina ame gupa madaa laketeme ya? Ameya, nena ini-parare ini mare ia. Goa teme pare adaa repena rekepene nimina ini-para aayare ora na-ademe. Nimina kone namaredepo yawa pimi-pulu ora maeyae onaa pimi. Aba ripiare nimina ini-para aaya repena rekena aba rasalepape. Oropere nimina ini waru ria pirua mo nimina amena ini-para aaya oge loma mada rasalimina sa. ");
INSERT INTO kew_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesumi wala gupa sa: repena epemere ini wae-daa namadita. Go page wae repename epe ini namadita. ");
INSERT INTO kew_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Onaanumiri repena ini aba etea adoare go ini epe talo o talo aba niminaaeme. Onaanumi repena eto madaa pa repena fik ini nakereteme. Go page ope meda madaa wain ini nakereteme. ");
INSERT INTO kew_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Epe onaanumi nimuna robaa-para epe kone adaapu sua epeaanu adaapu peme. Wae aame wain maapu pua nipuna kikiaame page waea agu pea. Gore nimuna robaa-para ia konere nimuna agaa-para teme. ");
INSERT INTO kew_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Akeane nimimi ni-para Aa Mudu loa nina agaa wala napageme? ");
INSERT INTO kew_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Onaa nimi ni piri-para ipua nina agaa pagoa kone rulaawa ratalimi-daare ora epe-rupa pimi. Nimuna kone madaa remaa lagialo. ");
INSERT INTO kew_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Go agaa page aare aa medame ada pulalo pea. Aba ripiare naaku ora no-para pua robo suare ada pigi mea paboare aana mua ruluaawa puri mapalaaya. Goa puare orope ipa roa go ada marobaatalo pea pare mada dia. Mo aa nipumi abade go ada waru pisa-pulu ora puri paloa aasa. ");
INSERT INTO kew_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pare aa medame nina agaa pagoa naratalia. Go aare nipuna ada gupa pisa: Nipumi no su ru-nane ada pigi puri namapalae pa amaa awesa. Oropere go adaare ipa roa tisa rabu ora aipapulu robesa. Gore lopesa rabu ora kalalu waru sa. ");
INSERT INTO kew_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesumi onaanu agaa lakelo kiritua Kaperneam su-para pisa. ");
INSERT INTO kew_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Gore soldia aanuna surube aa meda pirisa. Go aana kogono naaki yaina adaa mua ini adupitalo pisa. ");
INSERT INTO kew_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mo soldia aa mudumi Yesu pia remaa pagesa rabu nipumi kone makuaae Juda medalomame mo Yesu adola penaasa. Nipumi mo naakina yaina epa maepeaaina kone isa. ");
INSERT INTO kew_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nimu Yesu piri-para pua agaa puri paloa gupa pua ogesimi: Apo soldia aare epe aa ya-pulu neme raba meaina. ");
INSERT INTO kew_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Nipumi niaa Juda onaanu madaa pedo pi kone sua nipumi niaana lotu ada meda wariasa simi. ");
INSERT INTO kew_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Gore Yesu nimu raapu pisa. Nimu ada regepea aba pua opapasimi rabu mo aa mudumi adami aa medaloma Yesu-para agaa gupa rapaasa: Aa Adaa, neme kalai napape. Ni epe aa dia ya-pulu na ada-para naepape sa. ");
INSERT INTO kew_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Go page ni epe aa-daa dia ya-pulu ne piri-para page mada naepalua. Pare neme abia pa agaame te rabu nina kogono naakina yaina perekena sa. ");
INSERT INTO kew_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Gore ni page soldia aa mudunumi agaa lagialimi rabu pagalua. Gore ni page soldia aanu pawa surube. Gore neme soldia aa meda pu toare mada palia. Goa pua neme soldia aa meda ipu toare mada epalia. Goa pua nina kogono naaki-para kogono pa lo laketoare gore nipumi mada palia. ");
INSERT INTO kew_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesumi go agaa pagoa mo aa madaa kone adaapu sua aasa. Nipumi wala pereke tua mo nipu rata mea ipisimide onaa gupa lakesa: Gore pagalepa. Israel su-parare naa agaa pagae onaa meda go-rupa na-ade. ");
INSERT INTO kew_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Go rabu mo agaa mea ipisimi aanuri adaa wala puare mo kogono naaki aba perekesa-daa adesimi. ");
INSERT INTO kew_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Orope ogesi pirua Yesu nipu wala adaare Nain pisa. Nipuna disaipel aanu-para onaa adaapupe nipu raapu pisimi. ");
INSERT INTO kew_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Go adaare-na pora kerepo-nane odobatalo ipisimi rabu onaanumi aaro meda go ria ipisimi. Mo ome naakiri ona wasaana naaki padane pirisa. Go adaare-para piri onaa rayore mo ona raapu re lama ipisimi. ");
INSERT INTO kew_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Aa Mudumi go ona adoa nipumi odome ora waru omesa. Go rabu nipumi mo ona-para gupa lakesa: Neme re nalape. ");
INSERT INTO kew_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Goa loa nipu re-para pua mo aaro isa-para ipua kimi oraasa. Goa pisa rabu mo aaro risimi aanuri pa reko aasimi. Yesumi lalo: Go ogege aa neme lalo-ga ne reka. ");
INSERT INTO kew_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mo aare ora ini adupisa pare rekaa pirua agaa lo pirisa. Goa pisa rabu Yesumi go naaki nipuna agi wala kasa. ");
INSERT INTO kew_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Goa pisa raburi onaa rayome paalame omoa Gote-na bi minasaataawa lalo: Gote-na agaa lakene aa mudu meda niaana rikiraana abia go epa pia. Goa loa nimumi lalo: Gote su amaa ipua nipuna onaa oro yaalo mapiraatalo epaana simi. ");
INSERT INTO kew_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Gore Yesuna remaare onaanumi Judia su rayona pago kiritisimi. ");
INSERT INTO kew_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Jon-na disaipel aanumi go remaa Jon lakenaloare nipumi disaipel aa lapo-para ipulupa sa. Go aa lapore Aa Mudu piri-para pua agaa mealepa lakesa. Gupa tapape sa: Nere Jon-me aba aa meda epalialo lagisa aa yapae pa aa meda ado piralima yapae tapape sa. ");
INSERT INTO kew_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Go aa lapore Yesu piri-para aba pua nipumi lalo: Nere abade epalia simide aa yapae pa rado aa meda ado piralima yapae sipi? ");
INSERT INTO kew_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Go raburi Yesumi onaa yaina rado rado ome onaa adaapu maepeaawa wae remo nimu madaa piri rayo mea rubisa. Nipumi ini rubu pi onaa adaapu page maepeaasa. ");
INSERT INTO kew_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yesumi nipu agaa gupa pua laketapape sa: Nipimi abia go adoa pagapede remaa Jon piri-para pua laketapape sa: Ini rubu pi onaanumi oyae wala waru adame. Aa wae onaa page pora epe-rupa pamuame. Yakimi ti onaanuna rere page kaapu yaade. Aane poae onaanumi page aane lobenaloa agaa pageme. Ome onaanu page wala reka pimi. Onaa naraanumi page epe agaa waru pagalaeme. Go yae rayo madaa remaa pua tapape sa. ");
INSERT INTO kew_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Aa medame ni madaa kone laapo nasua puri paloa kone rulaliare go onaare pedo waru pu piralia sa. ");
INSERT INTO kew_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jon-na agaa mea rapae aa lapore wala pisipi. Go rabu Yesumi Jon madaa onaa rayo-para remaa gupa lakesa: Aba Jon onaa napiri su-para pirina nimi go su-para puare ake adola pisimi pae? Nimimi po ripumi kabe ragualae adola puame ya? ");
INSERT INTO kew_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nimi puare ake adola puame pae? Nimi puare aa medalomame epe epe set maarae adola puame pae? Dia-ga epe epe set maarae go piane aanuri aa mudununa ada-para piralemede. ");
INSERT INTO kew_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Gore nimi puare ake adola puame pae? Nimimi Gote-na agaa lakene aa mudu adola puame. Gore ora pagalepape. Go aa Gote-na agaa lakene aa yapare ora Gote-na agaa lakene aanu medalomare nipumi maoge yaaya. ");
INSERT INTO kew_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Goa pea-ga Jon madaare Gote-na agaa i buk-mi gupa ta: Gote-me lalo: Go aare nina agaa lakelape aa neme nipu aba mea penaatoa. Go aamere nimina pu robaa maredepo yaata epalia sa. ");
INSERT INTO kew_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Pagalepa. Jon-mere go su amaa madini onaa rayo maoge yaalia pare Gote-na Surube Su-para piri pa aa medame Jon page maoge yaalia sa. ");
INSERT INTO kew_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Goa sa rabu takis mi aanu-para onaa rayome pago kiritisimi. Nimumi Gote-na epe agaa mana pagenaloa abade Jon-me baptais kasa. ");
INSERT INTO kew_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Goa pisimi pare Farisi aanu-para rekena agaana tisaanuri Jon-na baptais gimisimi. Goa pua nimumi Gote-na epe pora gimisimi. ");
INSERT INTO kew_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesumi lalo: Gore abia reko pimi onaanuri ake piane onaanu-rupa piralimi lano yapae? Nimuna kone-para ake kone saa pimi agaa lano yapae? ");
INSERT INTO kew_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nimuri gupa lano: Nogo naakinu maket amaa pirua nogo naaki radonu-para gupa teme: Niaame nimi madaa emaa tema pare nimimi yaasa napabeme. Niaame odo ome yaasa tema rabu nimimi re nateme. ");
INSERT INTO kew_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yesumi wala gupa sa: Gore Jon-me baptais ipua bret nanoa ipa wain page nanisa. Goa pisa pare nimimi nipu maeyae aa simi. ");
INSERT INTO kew_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Abiare Onaa Raapu Pirape Aa-na Si ni ipua eta ipa no pi. Goa pe pare nimimi lalo: Adalepa. Go aare eta adaapu noa ipa wain adaapu ne aa teme sa. Go aare mo takis mi aanu-para naraa onaanu-para nimuna adami aa raapu piruaaya teme. ");
INSERT INTO kew_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nimimi goa teme pare onaanumi Gote-na kone memere niaa nimuna makuaae yae-daa go-rupa waateme. ");
INSERT INTO kew_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisi aa medame Yesu nipuna ada-para eta nola epape sa. Yesu mo Farisi aa-na ada-para pua eta nala pirisa. ");
INSERT INTO kew_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Gore ona wae medame Yesu mo Farisi aa-na ada-para eta nala pia remaa pagesa. Go remaa pagoa mo ona nipumi epe kaapu ti wabola aana pe-para pirapalae Yesu piri-para mea ipisa. Go wabolana yotore ora adaapu madaa ora adaape. ");
INSERT INTO kew_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Mea ipuare Yesuna masaa-nane pua aa regepeaasa. Goa pua nipu re lala pirisa. Nipumi re loa go ipa Yesuna aa madaa pogo sa. Goa puare re ipare nipuna aalu irimi kunua makaapu yaasa. Mo oname Yesuna aa madaa nunu loa aa madaa epe kaa pi wabola pepeminasa. ");
INSERT INTO kew_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mo Farisi aame adoa nipumi gupa kone isa: Go aare ora Gote-na agaa lakene aa yaalore nipu orae ona mada niminaata pea. Go oname wae pupitagi ne ona-ga mada adalia kone isa. ");
INSERT INTO kew_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Go rabu Yesumi mo aa-na kone adoa lalo: Saimon, neme ne remaa meda lagialo. Saimon-me lalo: Tisaa, nena agaa la. ");
INSERT INTO kew_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Gore Yesumi lalo: Aa lapona yago aa padane madaa aaya. Aa medana yagore 2,000 kina misa. Aa medana yago 200 kina misa. ");
INSERT INTO kew_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Mo aa lapome go yago abulape-rupa komome omesipi. Go raburi mo yago kane aame mo aa lapo yago na-abulapape sa. Goa pisa raburi mo aa lapomere aapimi pedo waru pisa pae? ");
INSERT INTO kew_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimon-me agaa gupa lakesa: Neme gupa kone salo. Aa medame nipuna yago adaapu mu rugulua na-abuni aare raaname omesa kone salo. Gore Yesumi lalo: Gupa ora lae sa. ");
INSERT INTO kew_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Goa sa rabu nipumi go ona piri-para pereke tua Saimon-para neme go ona ada sa. Ni nena ada ru-nane epawade pare nina aa radepeape ipa nagiaede. Yapare go ona nipuna re ipame nina aa radepeaawa nipuna aalu irimi makaapu yariaade. ");
INSERT INTO kew_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nena ada ru-nane epawade rabu nunu nalaede pare go onamere nina aa madaa nunu laade. ");
INSERT INTO kew_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Neme nina aalu-para wabola napaaride pare go oname nina aa madaa wabola pariaade. ");
INSERT INTO kew_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Goa pea-ga ne lagialo: Nipumi ni madaa raaname omoa ora nipuna waeanu adaapupe Gote-me mea rubata. Pare Gote-me onaa medana waeanu ogepusi mea rubaliare go onaare ogepu raaname omalimi. ");
INSERT INTO kew_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Gore Yesumi mo ona lakesa: Neme nena waeanu mea rubaato sa. ");
INSERT INTO kew_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Goa sa rabu aa medaloma nipu raapu reke madaa pirua eta nala pirisimi aanuri agaa makibumaawa goa simi: Go aare aapimi waeanu mada mea rubalia ya? ");
INSERT INTO kew_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Goa simi pare Yesumi go ona lakesa: Nena kone rulaeme ne maepeaawa ne Gote raapu mapiraata. Abia pua nena pu robaa epe-rupa ina sa. ");
INSERT INTO kew_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Orope Yesu nipu su rayo-para mo pora-nia pamisa. Nipumi Gote-na Surube Su-na Epe Agaa laketalo mogeasa. Go rabu disaipel aa 12-pela nipu raapu pamisimi. ");
INSERT INTO kew_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Yesumi ona medaloma nimuna wae remonu marakepeawa nimuna yainanu rayo maepeaasa. Go onanu nipu raapu pora pamisimi. Go onanuna bi gupa: Makdala adaare piri Maria-re abade Yesumi wae remo 7-pela mea rubaasa. ");
INSERT INTO kew_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ona medana bi Joana-re nipu aa mudu Herot-na ada surube aa Susa-na ore pirisa. Ona medalomare Susana-para ona rado adaapu page nipu raapu pamisimi. Go onanumiri mo disaipel aanu-para Yesu-para nimuna oyaeyae raba meaa-mama pulalo pisimi. ");
INSERT INTO kew_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ora adaare rado rado-para piri onaa adaapumi Yesu piri-para epa kiritasimi. Goa pisimi rabu nipumi nimu-para saa agaa meda gupa lakesa: ");
INSERT INTO kew_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Aa medame wit-na ini maapu-para pola pisa. Nipumi ini maapu-para polalo pisa rabu medaloma pora-nia lopesa. Go iniri onaanumi rabuatua yaanumi page nisimi. ");
INSERT INTO kew_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Pare go aame wit ini medaloma poasa rabu aana madaa lopesa. Go aana madaa lopesa rabu suri aana madaa ogepusi isa-pulu rayo kaapu yabesa. ");
INSERT INTO kew_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Wit-na ini medalomare repena eto ae-para lopesa. Go-para opesa pare mo opeme adaa yoa minabaasa. ");
INSERT INTO kew_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Wit-na ini medalomare epe su-para lopoa opea. Gore waru opoare wit-na ini etesa rabu ini 100-pela madisa. Go saa agaa loare Yesumi gupa sa: Onaa rayo nimi aane aalia-daare waru pagalepape sa. ");
INSERT INTO kew_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Go raburi nipuna disaipel aanumi go saa agaana re agaa misimi. ");
INSERT INTO kew_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Goa puare nipumi lalo: Gote-na Surube Su-na kudiri pi agaana re nimimi aba ademe-daa lagialo. Yapare pa onaa medalomamere go Surube Su madaare pa saa agaa pageme. Goa pua nimuna inimi ademe pare oyae meda na-adalimi. Nimumi agaa pageme pare go agaana re-re mada naniminaalimi. ");
INSERT INTO kew_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Go saa agaana re-re gupa sa: Go wit-na iniri Gote-na agaa yaade. ");
INSERT INTO kew_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Pora-nia lopea iniri go-rupare onaanumi agaa pa pageme pare orope Satan ipua mogo agaa nimuna robaa-para wala paake mea. Nimumi kone rulaawa oro yaalo kagaa piraama laama palimi kone sua Satan-me paake muaaya. ");
INSERT INTO kew_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Aana i su-para lope iniri go onaanumi epe agaa pagoare pedo waru peme. Yapare ora robaa ru-nane pitaa napua odobaaya-pulu nimumi kone ogepusi rulaeme. Orope Satan-me epa ko tulalo pea-daa wala Gote-na agaa gimeme. ");
INSERT INTO kew_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Etolo etolo aaya su-para lope iniri go onaanumi agaa pageme pare go su amaana kedaanu page amaa yape page go pedo pape kone rayome nimu minabaaya. Goa pea-pulu regepe minaawa ini waru naetea. ");
INSERT INTO kew_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Su epe-para lopea iniri go onaanumi epe agaa pagoa robaa-para waru irulu saapiruaeme. Nimu pawa pirua pageme-pulu nimumi ini waru maditimi sa. ");
INSERT INTO kew_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesumi wala lalo: Aa medame lam ewoare baket rolo-para page reke rolo-para napagaa salia. Dia, pare onaanu ada ru-nane pirua lam-na paa minalo mudialimi sa. ");
INSERT INTO kew_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Gore oyaeyae adaapu kuduripu imi yaenuri gore rayo penaame paana mea salia. Goa pua rigiteme yae rayore orope penaame mea salia-daa mada adalimi sa. ");
INSERT INTO kew_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Nimina pageme agaare waru surubalepape. Onaa rayome kone waru su piralimi-daare Gote-me kone oyae medaloma wala gialia. Pare onaa rayome kone oyae waru nasu piralimi-daare gore nipuna saapia yae rayo aba mu paaya. ");
INSERT INTO kew_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesu nipuna agi-para amenu nipu piri-para ipisimi. Go rabu onaa adaapu kiritisimi-pulu nipu pirisa re-para pirape ae naisa. ");
INSERT INTO kew_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Go raburi onaa medame nipu lakesa: Nena agi-para nena amenuri nimumi ne adola ipua amaa-nane epa aeme sa. ");
INSERT INTO kew_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Go raburi Yesumi agaa gupa lakesa: Onaanumi Gote-na agaa pagoa kone rulaawa ratalimi-daare go onaare nina ama-para nina amenu-para pimi sa. ");
INSERT INTO kew_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Oro meda Yesu nipuna disaipel aanu raapu ipunu madaa pirisimi. Gore nipumi nimu lakesa: Nimi mo ipa ini mone pane kenaama baina sa. Go rabu nimu polalo pisimi. ");
INSERT INTO kew_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ipunu madaa pirua pisimi rabu Yesu nipu u patisa. Go rabu po ripu adaa meda awaro kanapu-nane ipisa. Goa pua mo ipunu madaa ipa epa rubitalo pisa-pulu nimu paala omoa pirisimi. ");
INSERT INTO kew_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Go rabu disaipel aanumi Yesu pua marekaawa lalo: Adaa Aa, Abiare niaa ora apo tala-daa simi. Yesu nipu rekoa sana mo poripu-para mo adaa ipa lapo-para puri pane agaa lakesa. Go agaa lakesa rabu po ripu ipa lapo rata loraawa ipame eto eto wala napisa. ");
INSERT INTO kew_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Go raburi nipumi disaipel aanu-para agaa misa: Naa agaa robaa-para mea imi pae? Goa sa rabu nimumi pogolasaawa paala omoa agaa lala pirua gupa simi: Go aare aapi ya? Po ripu-para ipa lapo rata agaa laketa rabu nipuna agaa pagepe simi. ");
INSERT INTO kew_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Goa pua Yesu-para nipuna disaipel-nu ipunu madaa pirua Gerasa su-para pisimi. Go suri ipa Galili mone pane aasa. ");
INSERT INTO kew_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu nipu ipunu gimisa rabu mo aa madaata ipisa. Go aare wae remo medaloma nipu madaa pirisa. Go aa ora abasade nipu mamina nayamoa ada-para napirisa pare onaa rogaae aana apedaa-para pirala pisa. ");
INSERT INTO kew_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Go aame Yesu adoa puri pane agaa loa Yesuna kibu-para epa lopesa. Nipumi ora rui loa gupa yaasa: Yesu, nere so yaa madaa pia Gote-na Si yaade. Neme niri ake pali ya? Goa pua go aame agaa gupa misa: Neme ni radaa manape yae nagiape sa. ");
INSERT INTO kew_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yesumi mo wae remo pane pu sa rabu mo wae remome agaa puri palo yaaloa gimoa pane pisa. Onaanumi oro yaalo puri pane opeme go aana ki aa lapo rogaawa nipu adisimi pare go wae remonu nipu madaa epa pirisimi. Goa pisimi-pulu nipumi go puri pane openu rugulu rubebe pala pisa. Go rabu wae remome mo onaa napiri su-para go aa mea puala pisimi. ");
INSERT INTO kew_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Gore Yesumi nipu agaa gupa misa: Nena biri aapi ya sa? Nipumi lalo: Paapu sa. Gore wae remo adaapu nipuna yogane-para pua odobasa-pulu go bi paapu lakesa. ");
INSERT INTO kew_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Go wae remonumi puri paloa Yesu-para gupa yaasimi: Neme niaa wae su naaku-para namea mapiraape simi. ");
INSERT INTO kew_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Go rabu mena adaapupeme oge rudu meda re-para eta epa nala aasimi. Goa pea-pulu mo remo wae nimumi Yesu-para puri paloa gupa simi: Neme niaa pawa go mena madaa odobamona lape simi. Goa simi rabu Yesumi nimu penaasa rabu nimu go mena-para pisimi. ");
INSERT INTO kew_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Goa sa-pulu gode wae remo rayomere mode aare gimoa rayo mode mena madaa pua odobasimi. Goa pisimi rabu mena rayore oge rudu kilipia ipa ini repaa-nane awaro-para lopoa omabesimi. ");
INSERT INTO kew_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Gore mo mena puni aanumi goa adoa simina pogolasaasimi. Goa pisimi rabu go agaa remaare adaare-para page pua lakeloa su rayona pago kiritisimi. ");
INSERT INTO kew_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Pagesimi rabu onaa rayome go remaana re adola ipisimi. Nimu Yesu piri-para ipua aa epa adesimi pare wae remome mode aa aba gima pisaaya. Mo aa nipu mamina yamoa nipuna kone waru isa. Go aa nipu Yesuna aa re-para adaniaaba pirisaaya. Mo onaa rayome goa adoare paalame omesimi. ");
INSERT INTO kew_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Onaanu medalomame aba go pisade adesimi-pulu nimumi onaanu-para gode aare goa palo remaa laama pisimi. ");
INSERT INTO kew_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Go remaa pagesimi rabu mo Gerasa su robo ru-nane piri onaa rayomere Yesu nipu epa lakesimi: Nere pa pi-ga niaa gimoa pane pu simi. Nimumi ora paalame waru omoa simi. Go rabu Yesu nipu ipunu madaa pirua wala pisa. ");
INSERT INTO kew_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Go rabu mo wae remome aba gimisade aame Yesu-para gupa ogesa: Niri ne raapu bana sa. ");
INSERT INTO kew_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Nena adaare-para wala pua Gote-me ne-para paade remaa rayore onanu pua lakelape sa. Go rabu mo aa nipu pua mo nipuna adaare-para piri onaanu-para Yesumi nipu-para pisade remaa rayo pua lakesa. ");
INSERT INTO kew_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu nipu ipa ini one pane wala ipisa raburi onaa rayome nipu ado pirisimi. Goa pua nipu adoa simina raaname omesimi. ");
INSERT INTO kew_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Go raburi aa meda nipuna biri Jairus ipisa. Go aare lotu adana surube aa mudu pirisa. Nipu Yesuna aa re-para epa lopoa agaa puri paloa gupa ogesa: Nere nina ada-para epape sa. ");
INSERT INTO kew_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Nipuna nogo padane-ma madu isa. Go nogona maaliri 12-pela yapare nipu ini adupitalo pisa. Go raburi onaanumi Yesu marege paa-mama pisimi. ");
INSERT INTO kew_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Go rabu ona meda nipu onaa rayo raapu pamisa. Go onare yaapi pupulae yainare maali 12-pela patisa. Gore go ona nipumi mone oyaenu yaina maepeaainalo dokta-nu kasa pare nipuna yaina mada namaepeaasimi. ");
INSERT INTO kew_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Go onare Yesuna masaa-nane resi-para ipuare Yesu oraawa mode yaapi kaapu yoa wala napopesa. ");
INSERT INTO kew_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Go rabu Yesumi lalo: Niri onaa medame oraaria kone salo sa. Nimu rayome ni dia ni dia agu simi. Go rabu Pita-me lalo: Aa Adaa, onaa adaapumi kuta pua ne maregepeaarimide. ");
INSERT INTO kew_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Goa sa rabu Yesumi lalo: Aa medame ni oraaria rabu nina puri aba yola meade sa. ");
INSERT INTO kew_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mode onare nipu mada nakalesa-pulu nipu pururu pua Yesuna kibu re-para epa adaniaa pirisa. Goa pisa rabu onaa adaapuna ini agaana lakesa: Neme oraaru rabu nina yaapi ora mogo aipapulu kaapu yaade sa. ");
INSERT INTO kew_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Gore Yesumi nipu lakesa: Go nogo, nena kone rulaeme nena yaina maepeaaria-ga epe pu robaa raapu pu sa. ");
INSERT INTO kew_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nipumi mo agaa pena lakelalaina mo adaare aa muduna agaa mea o taape aa meda ipisa. Nipumi aa mudu Jairus-para yaaloa lakesa: Nena nogo aba ini adupiaade sa. Apo tisaa-para nena kogono namapaape sa. ");
INSERT INTO kew_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesumi go agaa pagoa nipumi Jairus-para gupa lakesa: Neme paala naomape pare kone waru rulape. Nena nogo wala epeaalia sa. ");
INSERT INTO kew_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Gore Yesu nipu go aa muduna ada-para puare ada ru-nane onaa rayo napulupape lo lakesa. Dia, pare Pita-para Jon-para Jems-para mo agi aaraa lapo-para go-rupare Yesu nipu raapu ru-nane pisimi. ");
INSERT INTO kew_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Onaa rayo mo nogo madaa re lala pirisimi. Go rabu Yesumi lalo: Nipu naomaana-ga re natapape. Nipu pa u pata sana sa. ");
INSERT INTO kew_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Goa sa rabu mo nogo ora aba omesa adesimi-pulu Yesu madaa giri laasimi. ");
INSERT INTO kew_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Gore Yesumi nogona ki mina mua gupa yaasa: Go nogo, ne reka sa. ");
INSERT INTO kew_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Goa sa rabu mo nogona wasupa wala epa odobaawa nipu aipapulu rekasa. Goa puare Yesumi nimu lakesa: Nimimi eta medaloma katapa sa. ");
INSERT INTO kew_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Mo nogona agi aaraa nipu lapore ora paalame omesipi pare Yesumi nipu-para agaa puri paloa gupa sa: Go remaare onaa meda nalaketapape sa. ");
INSERT INTO kew_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesumi disaipel aa 12-pela yaaloa nipumi puri-para suruboa paade kogono lapo kalaama pisa. Nimumi wae remonu rakepeainalo yaina maepeaainalo page puri kasa. ");
INSERT INTO kew_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Goa pisare nimumi Gote-na Surube Su-na agaa mogeawa yaina ome onaanu medaloma maepeaainalo mea rapaasa. ");
INSERT INTO kew_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Go pua nimu lakesa: Nimimi pora pamualimi rabu oyae namea pulupape sa. Nimimi rimaapu-para roka nu-para sapi-para mone-nu page namea pulupape sa. Nimimi go page mamina lapo namealepape. ");
INSERT INTO kew_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nimumi nimi ada ru-nane epe-rupa lamua palimiri gore nimi go ada padane-para pawa pua piralepape sa. Oropere nimina kogono dia naloa go adaare gimoa pulupape. ");
INSERT INTO kew_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Yapare nimumi nimi ada-para nalamua palimiri gore nimimi go adaare gimalepape sa. Goa pua nimina aa madaa kege kunua salepape sa. Go kunua salimi rabu go onaame nimuna wae kone mada niminaalimi sa. ");
INSERT INTO kew_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Goa sa-pulu nimi pua su adaare rado rado-para pu pa yabesimi. Goa pua Gote-na Epe Agaa remaa pamu lakeloa yaina ome onaana yaina maepeaasimi. ");
INSERT INTO kew_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Galili adaarena aa mudu Herot-me go remaa rayo aba pago kiritisa-pulu nipumi aapi-para tame pae loa kone adaapu isa. Gore onaa medalomame Jon matmat-para wala rekasimi-pulu nipumi go aa kone isa. ");
INSERT INTO kew_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Gore onaa medalomame Elaija wala epa pia simi. Medalomame Gote-na ora abade agaa lakene aa padane wala rekaana simi. ");
INSERT INTO kew_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Go agaa madaare Herot-me lalo: Jon-na maare aba kepesude sa. Go remaa pagalo aare aapi yapae? Goa loa nipumi Yesu adolalo pisa. ");
INSERT INTO kew_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Disaipel aanu nimu wala ipua niaa kogono gupa pa amaa lo Yesu nipu epa lakesimi. Go rabu nipumi nimu mea pua onaa gimoa adaare meda Betsaida-para agu raapo pisimi. ");
INSERT INTO kew_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Orope onaanumiri nimu puame lo remaa pagesimi-pulu nipu rata mea pisimi. Nimu nipu piri-para ipisimi raburi nipumi piralepa loa sana nipumi nimu Gote-na Surube Su madaa agaa lakesa. Go rabu page nipumi yaina ome onaanu page medaloma maepeaasa. ");
INSERT INTO kew_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Gore naare pabalaina mo aa 12-pela nipu piri-para ipua lalo: Neme go onaanuri nimuna ada penaala simi. Go-parare onaa adaapu napimi. Goa pea-ga mo adaare-nane eta kabo u patape ada page asapua kabena penaala simi. ");
INSERT INTO kew_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pare Yesumi nimu lakesa: Nimimi eta katapa sa. Nimumi lalo: Niaana etare gupa: bret ipa supu-para ena laapo ima. Nemere go onaa rayona eta kabamona kone sae ya? ");
INSERT INTO kew_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Gore aanu 5,000 pabo pirisimi. Go rabu Yesumi nipuna disaipel aanu lakesa: Nimimi mo onaanu 50, 50 laatapu mapiraatepa sa. ");
INSERT INTO kew_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Goa pua disaipel aanumi onaa rayo mapira kiritasimi. ");
INSERT INTO kew_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu nipumi mo bret supu-para mo ena mua yaa-para adaba sua Gote-para ora pi sa. Goa puare nipumi bret piribia disaipel aanu kanaloa nimumi onaanu rumaasimi. ");
INSERT INTO kew_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Gore nimu rayome ora mada nisimi. No kirituare eta ebo nu 12-pela madu isimi. ");
INSERT INTO kew_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Oro meda Yesu nipu padane beten lala pirina nipuna disaipel aanuri nipu piri-para ipisimi. Go rabu nipumi nimu agaa misa: Onaanumiri niri aapi teme pae? ");
INSERT INTO kew_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Gore nimumi agaa gupa lakesimi: Medalomamere nere Jon Baptais teme Medalomamere ne Elaija teme. Medalomare ne abade Gote-na agaa lakene aa meda wala rekaana teme. ");
INSERT INTO kew_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Gore nipumi nimu lakesa: Nimimiri ni aapi teme ya? Gore Pita-me gupa sa: Nere Onaa Raapu Pirape Aa-na Si yaade sa. ");
INSERT INTO kew_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Goa loare Yesumi nimu ora puri paloa agaa mana lakesa: Go agaare pa onaa nalaketapape. ");
INSERT INTO kew_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Gore nipumi lalo: Ni Onaa Raapu Pirape Aa-na Siri kedaa adaape riaalua. Goa pua kone makuaae Juda aanu page Gote-na miru irae aa mudunu page rekena agaa tisaa aanu page go aa rayome ni masaa rilalimi. Goa pua ni tu maomalimi pare wala yapi repo dia naloa wala matmat-para rekalua sa. ");
INSERT INTO kew_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Gore nipumi onaa rayo lakesa: Gore onaa rayome ni madaa kone rulaawa palimi-daare nimuna kone rabuaniaawa repena polopeana kedaa oro yaalo rua nina pora kuralimina sa. ");
INSERT INTO kew_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Gore aa medame nipuna kone wasupa pa irulu saapitiare gore nipuna wasupa page alupalia. Pare aa medame ni madaa kone sua nipuna bipa yogane madaa kone nasaliare nipuna wasupare gore oro yaalo piraama laama palia. ");
INSERT INTO kew_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Pare aa medame mone oyae waru mua su amaa oyaenu page rayo waru saliare nipuna kone wasupa go yaenumi akepu raba mealia ya? ");
INSERT INTO kew_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Gore onaa rayome ni-para nina epe agaa-para masaa rilalimi-daare ni Onaa Raapu Pirape Aamere go onaa masaa rilalua. Wala epalua rabu naa puri page Aapana epe paana puri page epe ensel-nuna page mea epalua. ");
INSERT INTO kew_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Pagalepa. Onaa medaloma go-para pimiri abi naomalimi. Dia, pare aba nimumi Gote-na Surube Su epenalo adalimi sa. ");
INSERT INTO kew_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesumi apo agaa aba loare sarara padane aba dia sa. Go rabu nipumi Pita-para Jon-para Jems-para lamua pua rudu medane beten talo pisimi. ");
INSERT INTO kew_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nipumi beten lala pirina nipuna ini agaa aba rado perekea sana nipuna mamina page yaako pu tua lepo lepo atasa. ");
INSERT INTO kew_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Goa puare aipapulu aa lapome nipu raapu agaa lala pirisipi. Go aa laapore Moses-para Elaija laapo Yesu raapu agaa sipi. ");
INSERT INTO kew_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nipuri yaa madaana epe paana puri raapu ipisipi. Nipu lapome Yesu-para orope Gote-na kogono pu kiritainalo Jerusalem su-para omali agaa lala pirisimi. ");
INSERT INTO kew_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Go rabu Pita-para mo adami aanu-para u waru patisimi. Gore nimumi rekoa pua Yesuna epe paana puri-para mo rekasipide aa lapo page adesimi. ");
INSERT INTO kew_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Gore mo aa lapome Yesu gimoa polalo pisipi rabu Pita-me Yesu gupa lakesa: Aa adaa, niaa go-para pimare ora epe ta. Gore niaana pokaalo ada ipa repo paminaapa. Medare nena meda Moses-na medare Elija-na pamina sa. Pita nipumi go agaa lakesa pare go agaana re naniminaasa. ");
INSERT INTO kew_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nipumi go agaa pa lalaina moae medame nimu aba rigitisa. Moaeme nimu rabuaniaasa rabu nimumi paala omesimi. ");
INSERT INTO kew_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Go moae-parare agaa meda gupa lakesa: Gore ora nina epe naaki-ga neme nipu aba mapiraasu. Nimimi nipuna agaa pagalepape. ");
INSERT INTO kew_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Gote-me agaa lakenaloa Yesu nipu padane pirina adesimi. Gore disaipel aanu nimumi agaa loraawa go adesimide yaenu madaa remaa nasimi. ");
INSERT INTO kew_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ekeraare so rudu gimoa kilipisimi rabu onaa adaapumi Yesu nipu pora-nia madaata ipisimi. ");
INSERT INTO kew_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Go onaana rikiraana ae aa medame gupa yaaloa ogesa: Tisaa, neme nina naaki odome omoa adape. Go naakiri ora naa padane-ma naaki yaade. ");
INSERT INTO kew_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Wae remo medame nipu irulu ripinaaya. Goa pea raburi mo wae remome nipu orolopaawa maeyaatea. Goa pua nipuna agaa-para rako sope madita. Go rabu nipuna yogane maoyaaya. Goa pua go remome naa naaki abi naminarepaaya. ");
INSERT INTO kew_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Neme abade nena disaipel aanumi go wae remo mea rakepealepa lo ogesude pare nimumi mada narakepeasimi. ");
INSERT INTO kew_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesumi go kirita pirisimi onaanu-para gupa lakesa: Nimiri kone waru narulaawa nimina robaa-para page ora o ta. Nimi raapu ni rana akepu raapo piralua pae? Nimina wae kedaanu akepu raapo rialua pae? Goa loare go aa-para lakesa: Nena naaki lamua ipu sa. ");
INSERT INTO kew_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nipuna naakiri pena ipulaina mo wae remome oro lopaawa maeyaesa. Go rabu Yesumi go remo-para puri pane agaa lakeloa mo naaki maepeaasa. Goa pua nipuna aaraa mea kasa. ");
INSERT INTO kew_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","44","Onaa rayome Gote-na adaa puri adesimi-pulu nimu ora pogolasaasimi Go rabu Yesumi nipuna disaipel aanu-para gupa sa: Neme agaa lagialua-ga nimimi go agaa waru pago piralepape. Ni Onaa Raapu Pirape Aa-na Siri aa medalomame wae aanu mea kateme sa. ");
INSERT INTO kew_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pare nimumi go saa agaana re naniminaasimi-pulu nimu paalame omoa nipu agaa namisimi. ");
INSERT INTO kew_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Gore disaipel aanumi arere pua niaana rikiraanare riri-nane aape aare aapi yapae lo agaa lala pirisimi. ");
INSERT INTO kew_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Gore Yesumi nimuna kone adoa nipumi naaki oge meda nipu raapu mea mapiraasa. ");
INSERT INTO kew_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Goa puare nipumi nimu lakesa: Onaa rayo naa bi loa go oge naaki raba mealimi-daare nimimi ni page raba meme sa. Onaa rayo kogono pua naaki ora oge gupiane raba mealimi-daare onaa mudu pitimi sa. ");
INSERT INTO kew_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Go rabu Jon-me agaa gupa abusa: Aa Adaa, aa medame nena bi loa wae remo mea rakepea-daa adama sa. Goa pea pare go aame niaana rikiraana disaipel aa napia-pulu nipu gimape lo lakelama. ");
INSERT INTO kew_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Go rabu Yesumi nipuna disaipel aa medaloma gupa lakesa: Nimimi nipu gimoa natapape sa. Onaa rayo nimi-para iaa na-aulalimi-daare gore nimina adami onaa pitimi sa. ");
INSERT INTO kew_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Gote-me Yesu so yaa-para mea pope di rudu sa. Goa pisa raburi Yesu nipu Jerusalem palua kone sua pisa. ");
INSERT INTO kew_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Go raburi aa medaloma-para wai agaa aba lo rapaasa. Go aanu nimu puare Samaria adaare meda-para odobaawa nipuna yaenu managolo satalo pisimi. ");
INSERT INTO kew_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Goa pisimi pare go su-para piri onaanumi Yesu nimuna adaare-para lamua pope gimisimi. Gore Yesuri nimuna iaana su Jerusalem su-para penaalo adesimi. ");
INSERT INTO kew_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Disaipel aa Jon Jems lapome go kone adoa nipu laapome wala pua Yesu-para lalo: Aa Mudu, niaame so yaa-para ia repena sulaame go onaanu rabenalo mea repaamina ya? ");
INSERT INTO kew_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Goa simi pare Yesumi wala pereke tua nipu-para ora dia sa. ");
INSERT INTO kew_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Goa pua nimu su rado-para pisimi. ");
INSERT INTO kew_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nimu pora-nia pisimi rabu aa medame Yesu goa lakesa: Ne su rayona pali-parare ni go-para rata mea epalua sa. ");
INSERT INTO kew_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Goa sa rabu Yesumi nipu gupa lakesa: Raa kira aune yana nimuna aana apedaa raa-para pati ada aaya. Go page yaanuri nimuna ada aaya pare Ni Onaanu Raapu Pirape Aana Siri patape ada meda na-aaya sa. ");
INSERT INTO kew_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nipumi aa rado meda gupa lakesa: Neme ni rata mea ipu sa. Goa sa pare go aa nipumi lalo: Neme nina Aapa aba rogaata pono laa sa. ");
INSERT INTO kew_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesumi nipu lakesa: Dia, nimuna wasupa ome onaanuri ora nimuna ome yagonumi rogaaina lape. Ne pua Gote-na Surube Su madaa agaa pua lakelape sa. ");
INSERT INTO kew_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Aa medame gupa sa: Aa Adaa, neme ne raapu banalo pi pare neme nina onaanu nimu-repaa abi piralepape ta pono laa sa. ");
INSERT INTO kew_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Gore Yesumi nipu goa lakesa: Aa medame nipuna aalumi masaa-nane wala adaa-mama paliare Gote-na Surube Su-para mada napua piralia sa. ");
INSERT INTO kew_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Orope Aa Mudumi aa 72-pela meda muare laapo laapo lo mea rapaasa. Gore Yesu orope penaalo adaare-para su rayo-parare nimumi aba agaa laketa pisimi. ");
INSERT INTO kew_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Goa pua nipumi nimu gupa lakesa: Eta adaapu apo maapunu-para ia pare kogono aa adaapu napimi. Goa pea-ga nimimi apo maapuna aaraa-para beten tapape. Goa pua aaraame aa medaloma mo etanu mea kirita inalo beten tapape. ");
INSERT INTO kew_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Pulupa. Nimiri sipsip mena-rupa mo maeyae yanana rikiraana apo mea rapaato. ");
INSERT INTO kew_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nimina mone paus-para roka nu-para aariti go yaenu namea pulupape. Goa pua pora-nia ae onaa-para abi piralepape pi natapape sa. ");
INSERT INTO kew_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Gore nimimi ada meda-para pua odobalimi-daare aba nipu gupa tapape: Go ada-para piri onaare epe-rupa piralepa tapape. Gore epe kone i aa meda go ada-para pitia-daare nipumi nena epe kone mua abutea. ");
INSERT INTO kew_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Pare aa meda gupa napitia-daare nimina epe konere nimina wala mealimina. ");
INSERT INTO kew_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nimi ada meda-para pua piralimina gialimide nape eta oyaenuri nalepape. Goa pua-ga kogono aare nipu agaa abulape oyae mada mealia. Pare nimuna ada rado radonu-para oyae namula pulupape. ");
INSERT INTO kew_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nimi adaare meda-para palimi rabu nimuna ada-para epe-rupa mea odobalimiri gore eta nimumi gialimide nalepape. ");
INSERT INTO kew_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Go adaare-para yaina ome onaanu maepeaatepape. Goa puare nimimi nimu gupa laketapape: Gote-na Surube Su nimi piri re-para epea tapape. ");
INSERT INTO kew_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Goa pua nimi adaare meda-para puare nimi nimuna ada-para nalamua palimiri go adaare pora-nane pua aawa gupa tapape: ");
INSERT INTO kew_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Nimina adaare-na kegere niaana aa madaa ina apo kunu satema-daa tapape. Pare Gote-na Surube Su abia go re-para epaade tapape. ");
INSERT INTO kew_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Neme nimi lagialo: Sodom adaare-para wae onaanu pirisimi-pulu kedaa adaa meda kasa. Goa pisa pare go adaare-para epe agaa gimalimiri kedaa ora waru katea sa. ");
INSERT INTO kew_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yesumi wala lalo: Korasin su-para mo Betsaida go lapo piri onaanu-para page ora odo waru pia. Nimina su-para napiaa kogono pisude-rupa Tair su-para Saidon su lapopare go-rupa pula pisu yaalore go su lapone piri onaanumi pupitagi gimoa kone pereketa peme. Goa pula pisimi yaalore nimumi mamina kobere yamoa repena egaa taga irita pisimi. ");
INSERT INTO kew_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Gore Gote-me onaa wae yoto katea raburi go wae su lapo Tair Saidon lapo-para odome omoa kedaa katea. Goa palia pare go adaare-para pirua kone narulae onaanuri nimi ora adaa kedaa meda mealimi sa. ");
INSERT INTO kew_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nimi Kaperneam su-para piri onaanuri nimina so yaa-para polalo peme pae? Dia nimi wae repena sulaa-para mea lopalia sa. ");
INSERT INTO kew_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Goa loa nipuna disaipel aanu lakesa: Onaa rayome nimina agaa pagalimiri gore nina agaa page pageme. Pare onaa rayome ni masaa rilalimi-daare gore ni page masaa rilaeme. Gore ni masaa rilalimiri abade nimumi ni rapaasade Aapa page masaa rilalimi sa. ");
INSERT INTO kew_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Orope mo epe kogono aa 72-pela wala ipua raaname omoasimi. Gore nimumi lalo: Aa Mudu, niaame abade nena bi lakelaama pisima rabu wae remonu page niaana agaa pagaame simi. ");
INSERT INTO kew_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Go rabu Yesumi nimu goa lakesa: Go rabu yaa madaare Satan so repena sulaa-rupa aipapulu lopesa-daa adesu. ");
INSERT INTO kew_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Pagalepa. Neme nimi puri aba gisude-pulu nimimi paaka-para supi kalainuna agaa mada rogaalimi sa. Goa puare nimimi Satan-na puri rayo rabuaniaalimi rabu oyae medame nimi mada namaoyaalia sa. ");
INSERT INTO kew_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pare wae remome nimina agaa pa pageme-pulu go padane madaa raaname naomalepape. Dia, pare nimina bi so yaa-para aba tisade-ga go madaa pedo pipape sa. ");
INSERT INTO kew_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Go raburi Holi Spirit-mi Yesuna robaa-para raana omape kone kasa rabu rulatabesa. Go rabu Yesumi lalo: O Aapa, nere su amaa page yaa-para page ora Aa Mudu pi. Abia neme kone adaapu i onaanu-para makuaae onaanu-para nena kone kudiri pua skul-nane onaanu mea waalaede sa. Ora gore Aapa, nena raanana ratua gupa pede-ga ora pi. ");
INSERT INTO kew_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nina Aapame kone-para oyae rayo neme surubanolo gisa. Pare onaa rayome Sina kone na-ademe. Dia, pare Aapa padanemere adea. Go page onaa rayome Aapana kone na-ademe pare Simi padanemere aapa adea. Goa pea pare Simi onaanu Aapana kone waatalo palia-daare nimumi page Aapa mada adalimi. ");
INSERT INTO kew_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Go rabu Yesumi pereke tua disaipel aanu-para lalo: Nimimi go adaleme yae madaare nimi pedo pu piralimina. ");
INSERT INTO kew_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Neme nimi lagialo: Abade aa mudunu page Gote-na agaa lakene aanumi page abia nimi ademe yae adolalo pisimi. Pare nimumi go oyae na-adesimi. Go page abia nimimi go pageme agaa pagolalo pisimi pare napagesimiya sa. ");
INSERT INTO kew_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Gore rekena agaana tisaa meda Yesu piri-para ipua Yesu ko tulalo pisa. Tisaa-ya, neme akea pua oro yaalo kagaa pirape kone wasupa mealua ya? ");
INSERT INTO kew_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Gore Yesumi nipu goa lakesa: Gote-na buk-parare akepu ia? Neme akepu dipiti pae? ");
INSERT INTO kew_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Gore nipumi agaa gupa abusa: Nena Mudu Gote madaare pu robaa rayome page kone wasupa rayome page puri rayome page pedo pu raana omalepape ta. Go page nimina bipa nimi raana omeme-rupare nimina yagonu page padane go-rupa pipape sa. ");
INSERT INTO kew_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Gore Yesumi nipu goa lakesa: Gore neme agaa waru abulae. Neme goa paliri ne oro yaalo epe-rupa kagaa pirali sa. ");
INSERT INTO kew_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Yapare go rekena agaa tisaa-mere nipuna bi padane waru epena kone isa-pulu nipumi Yesu wala lakesa: Gore rekena agaame nina ada lapa piri onaanuri aapi-para ta pae? ");
INSERT INTO kew_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Gore Yesu nipumi remaa gupa lakesa: Aa medame nipuna Jerusalem su-para gimoa Jeriko su-nane pisa. Go rabu wae paake ne aanu nimu pora madaasimi rabu tua nipuna mamina-nu koloa nipuna oyaenu misimi. Goa puare nipu waru tua pora-nia pa ini adupitalo palaina gima pisimi. ");
INSERT INTO kew_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Go raburi Gote-na Miru Irae Aa meda go pora kura mea pisa. Gore nipumi go aa adaa pare gimoa mo pora nebo-nane puaa-mama pua pisa. ");
INSERT INTO kew_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Goa pisa rabu aa meda nipu Livai-repaa ruru piri aa nipu ipisa. Nipu pora nebo-nane ipua mode aa tapaina adoare mo pora aane-nane pakeawa gima pisa. ");
INSERT INTO kew_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Goa pisa pare Samaria kimi su-para piri aa padanere mo pora-nia ipua go aa tapaina adoa sana nipuna pu-para ora odome omesa. ");
INSERT INTO kew_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Goa pisa-pulu nipu re-para pua minasaawa marasin wel-para ipa wain koyo paboa mo nipuna rere rogaasa. Mo rere rogaa kiritua mo aa marekaawa nipuna donki mena masaana mea mapiraasa. Goa puare nipumi pora kimisu aanu patape ada meda-para pua waru pua surubesa. ");
INSERT INTO kew_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ekeraa-nanere go aame kimisu aanu patape ada surube adana aaraa mone 100 kina-rupa pua kasa. Go pua nipumi gupa lakesa: Neme go aa waru surubape. Gore nena mone medaloma mogo aa madaa palia-rupa wala ipua epa abutua. ");
INSERT INTO kew_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Goa loa sana Yesumi wala lalo: Gore abia neme ake kone sae pae? Aa repo pora-nia epame pare mode tapasade aana adami aare aapi ya? ");
INSERT INTO kew_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Go rabu mo rekena agaana tisaa-me lalo: Go kimisu aare odome omoa raba meade aa sa. Go rabu Yesumi nipu lakesa: Ne puare neme goa pua pape sa. ");
INSERT INTO kew_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu nipuna disaipel aanu raapu adaare meda-para pisimi. Go-parare ona meda nipuna biri Marta go oname Yesu nipuna ada-para epe-rupa lamua pisa. ");
INSERT INTO kew_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta nipuna aaki meda nipuna biri Maria pirisa. Maria nipu Aa Mudu-na aa re-para epa pirua nipuna agaa pagesa. ");
INSERT INTO kew_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Goa pisa pare Marta-re kogono adaapu pua nimuna nape eta managolata pirisa. Goa pisa rabu Marta nipu Yesu piri-para pua agaa misa: Aa Mudu, nina aakimi ni gimaade-ga neme padane eta iru pi-ga go kone madaare ake kone sali pae? Ni epa raba mina neme lakela sa. ");
INSERT INTO kew_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Goa sa pare Aa Mudumi nipu-para agaa gupa lakesa: Marta, ni odo pia. Neme kone adaapu sua nena robaa-para ari-yapa pea. Nere oyae rayo madaa kone sae. ");
INSERT INTO kew_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Goa pea pare neme kone padane sape. Go nena aki Maria-me mulalo pia yaere niaame rutu nalamina sa. ");
INSERT INTO kew_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yapi medame Yesu nipu su meda-nane beten lala pirisa. Orope beten aba lo kiritinaloare nipuna disaipel aa medame nipu goa lakesa: Aa Mudu, neme niaare beten lape-rupa mogeape. Abade Jon-me nipuna disaipel aanu mogeasaya-rupa neme page niaa mogeape sa. ");
INSERT INTO kew_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Gore nipumi nimu gupa lakesa: Beten lape agaa teme raburi nimimi gupa tapape sa: O Aapa, Nena biri oro yaalo ora epe-rupa ina. Nena Surube Su epena. ");
INSERT INTO kew_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Abia go yapi padane madaare niaana eta giaina. ");
INSERT INTO kew_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Niaana wae yaenu mea rubaina-ga niaame page aba wae kone saapiraina onaanuna kone mea rubalima. Neme niaa kedaame omape yae ko natina. ");
INSERT INTO kew_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesumi goa loa sana nipuna disaipel aanu gupa lakesa: Gore nimi medamere ribaa ruma rumana pua nimina adami aa agaa gupa mealimi: Adami aa, neme ni bret ipa repo giaina pua te. ");
INSERT INTO kew_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Nina adami aa meda pora kimisu pamua reame omoa nina ada-para epa pia. Goa pea pare neme kalape eta dia ya te. ");
INSERT INTO kew_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Goa te raburi mo ada ru-nane pia adami aame gupa tea: Neme ni radaa pi kogono nagiape. Pora gaape ora poa loko aba tua nina nogo naakinu raapu aba patawa tea. Neme rekoa oyae mada nagialua tea. ");
INSERT INTO kew_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Goa tea rabu neme ake pali ya? Neme nimi lagialo: Gore mo aame ne nipuna adami onaanu bret nagialia-daare ne yala napote pare ne pirua agaa lakete. Agaa pa amaa yaate-pulu nipu rekoa nena ia yaenu gialia. ");
INSERT INTO kew_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Go remaana re neme nimi lagialo: Gore nimimi Gote-para beten go-rupa tapape. Goa palimiri nipumi nimi oyae su gialia. Nimimi oyae asapalimiri nimimi mada adasaalimi. Nimimi pora gaape tu piralimiri Gote-me pora gaape mada epa lobalia. ");
INSERT INTO kew_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Onaanumi Gote-para beten temere gore oyae mada mealimi. Onaanu oyae asapalimiri nimumi oyae mada adasaalimi. Onaanumi pora gaape talimiri gore Gote-me nimu-para pora ora lobalia. ");
INSERT INTO kew_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Gore nimina naaki nogonumi nimi-para ena meda gialepa teme-daare paaka wae meda mea kateme ya? ");
INSERT INTO kew_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Dia-ga mo naakimi yaa Aapa meda gi tea-daare betamu meda mea kateme ya? Dia, mada nakateme. ");
INSERT INTO kew_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Gore nimi wae aanu pimi pare nimina naaki-para epe yaenu katemede. Goa pemede-ga waru pagalepa. Niaana so yaa-para pia Aapamere onaanumi beten teme-daare Holi Spirit gialua sa. ");
INSERT INTO kew_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Wae remome aa medana agaa mamaraasa rabu Yesumi go remo mea rubisa. Go rabu go aa-na agaa lapaasa. Goa pua onaa rayome kone adaapu sua pogolasaasimi. ");
INSERT INTO kew_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Goa pisa rabu onaa medalomame lalo: Wae remonuna aa mudu Belsebul-mi Yesu puri kata rabu mea rubaaya simi. ");
INSERT INTO kew_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Goa simi rabu aa medalomame Yesu ko tulalo pisimi-pulu Yesumi napiaa kogono meda pinaloa adamona simi. ");
INSERT INTO kew_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pare Yesumi nimuna kone adokaru mua nimu gupa lakesa: Adaa kagure meda-para piri onaanu rugulala paawa yada palimiri go adaa rururi ora o yalimi. Go page ada medana aaraalu rugulala paliare go aaraalu mada nakibuma piralimi. ");
INSERT INTO kew_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Gore Satan-me nipuna surube onaanuri marugulala paalia yaalore nipuna puri page akea pua epe-rupa salia ya? Mada Dia, pare nimimi wae remonuna mudu Belsebul-na purimi mea rubaayo teme. ");
INSERT INTO kew_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Neme go purimi mea rubaayo teme-daare gore nimina naakinu madaare akea pua neme nimuna remonu mea rubaayo pae? Nimina naakinuna wae remo radonu mea rubaayo pare nimimi ora agaa nalaeme. ");
INSERT INTO kew_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Dia-ga Gote-na purimi ni puri gisa-pulu go wae remonu mea rubaayo. Goa pe-pulu Gote-na Surube Su nimi piri-para aba epaade sa. ");
INSERT INTO kew_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Gore puri pane aa medame etaa ripinua nipuna ada-para surubaliare gore nipuna oyae rayo epe-rupa pa salia. ");
INSERT INTO kew_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Goa palia pare puri waru pane aa rado apo aana ada-para ipua tuare maoyaalia. Goa puare apo aana etaa-para rai napi-para go surubape yae paake noa tema aa medalomanu-para surubape yae ruma katea sa. ");
INSERT INTO kew_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Onaa rayo nina adami onaa napitimi-daare gore nina iaa pimi. Onaa rayome ni raapu oyae nakiritemere gore nimumi raa-para mea ratu rubalimi sa. ");
INSERT INTO kew_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Gore wae remome aa meda gimaliare gore nipu su kaapu ne-para kitu pirape su asapulalo pea. Gore nipumi go su epe meda na-adoare nipumi lalo: Abade nina pirisude ada-para wala palua tea. ");
INSERT INTO kew_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Goa pea-daa nipu pua nipuna abana ada-para wala pua adea rabu nimumi puluma kia pepena pua waria piralimi. ");
INSERT INTO kew_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Goa adea raburi wala ora wae remo 7-pela medaloma pua lamu misa. Goa puare nimu rayo mo ada ru-nane pua odobaawa pimi. Goa peme rabu abade mo aa nipuri wae-rupa pirisa pare wala abia rayo piruaeme-pulu go aa abia ora wae-rupa meda pia sa. ");
INSERT INTO kew_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesumi onaa adaapu kirata pirinaloa agaa gupa lakesa: Go rabu nimina rikiraana piri ona padaneme agaa gupa sa: Gore abade ne madua adu gisade ona nipu padanemere pedo waru pina sa. ");
INSERT INTO kew_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Goa sa pare Yesumi gupa sa: Ora lae pare onaame Gote-na epe agaa wala pagoa ratalimi onaanumiri gore ora pedo pina sa. ");
INSERT INTO kew_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Onaa adaapu pa epa kiritaba pirina nimu gupa lakesa: Abia go yapi di rabu pimi onaanuri ora wae onaa pimi. Nimumi napiaa kogono meda adamona teme pare neme go-rupa kogono meda nawatoa. Dia, pare Jona nipuna napiaa kogono pisade go padane mea waatoa sa. ");
INSERT INTO kew_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Abade Jona Gote-na agaa lakene aa pirina mo Ninive su-para piri onaanumi Gote-na puri pane kogono adesimi. Abia go rabu page ni Onaa Raapu Pirape Aa-na Si Gote-me go onaanumi adenalo napiaa kogono palia rabu adalimi sa. ");
INSERT INTO kew_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Oropere Gote-me onaanuna koso lape di madaare no re-nane ona mudu padaneme rekoa abia piri onaanu nimuna wae yae madaa koso lape agaa lagialia. Gore go oname abade Solomon-na epe agaa mana pagola pisa-pulu nipu su rayona aane-nane pamisa. Goa pisa pare nimina rikiraana pia yaeme apo Solomon-na kone ora maoge yaaya. Goa pea pare onaanumi nipuna agaa napageme. ");
INSERT INTO kew_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Gote-me onaanuna koso lape agaa di madaare gore Ninive su onaanumi rekoa go abia piri onaanumiri Joname agaa lakesa-daa nimumi kone perekeasimi. Goa pisimi-pulu nimi madaa koso lape agaa mada lagialimi. Goa palia pare abia nimina rikiraana piri aame Jona maoge yaaya sa. ");
INSERT INTO kew_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesumi wala lalo: Onaanumi lam ewoa go lam baket rolo-para nasalemede sa. Dia, pare nipumi mudianaloa onaanumi go paa adoa ada ru-nane epa odobalimi. ");
INSERT INTO kew_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nena iniri nena yoganena paa lam-rupa roaaya. Gore nena ini epeaaliare gore nena to yogane rayo paa rulatabea. Pare nena ini o yaliare gore nena to yogane rayo ribaa yabalia sa. ");
INSERT INTO kew_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Gore nena robaa-para ia paa wala ribaa yalia waru adalepape. ");
INSERT INTO kew_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Gore nena to rayo-para paa paliare kalae-nanedaa page ribaa nayaabalia. Go rabu lam-na paa ne madaa pirata ipulade-rupa nena to yogane-para paa gupa rulatabalia sa. ");
INSERT INTO kew_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesumi go agaa aba naloa Farisi aa medame nipuna ada-para eta nola ipu sa. Goa sa rabu mo aa nipuna ada-para pua eta nala pirisa. ");
INSERT INTO kew_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Gore Yesumi eta nolalo ki naradepea-pulu mo Farisi aame adoa nipumi kone adaapu isa. ");
INSERT INTO kew_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Goa pisa rabu Aa Mudumi nipu gupa lakesa: Gore nimi Farisi aanuri nimimi plet kap-nuna yogane radepeteme. Goa pea pare nimimi plet kap-nuna ru-parare naradepeteme. Goa pea pare nimina robaa-para oyae adaapu saapirape kone su pupitagi nape kone page apo rulatabea-daa sa. ");
INSERT INTO kew_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nimiri maeyae aanu pimi. Gote-me onaana to yogane waria nipuna robaare nawarisa pae? ");
INSERT INTO kew_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pare nimina plet kap-nupara saapiri yaenu medalomame naraa onaanu katapape. Goa palimi rabu nimi epe-rupa piralimi sa. ");
INSERT INTO kew_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Pare Farisi aanu nimi waru adalepape. Nimi yabia meda-para rakia-para padi raani medaloma-para warea go oge yae page Gote medaloma kateme. Goa peme pare nimimi epe-rupa sape kone-para Gote madaa kone rulape kone-para gimeme. Pare nimimi go kone sua mogea nagimalimiri gore epeaalia. ");
INSERT INTO kew_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Nimi Farisi aanu nimimi waru adalepape. Nimi lotu ada ru-nane pua riri-nane pirape siaa madaa raaname apo omeme-daa. Go page nimi kiritae maket ada-para pua onaanumi nimi-para abi piralepape teme-daa raaname omeme. ");
INSERT INTO kew_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Nimiri waru adalepape. Nimina kone gupa: Nimi pa matmat-rupaga gore pa onaanumi na-adoare rekena lusua rabuaemede. ");
INSERT INTO kew_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Go rabu rekena agaana tisaa medame gupa sa: Tisaa, neme goa loa niaa-para ero agaa niaa mariaaye. ");
INSERT INTO kew_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesumi lalo: Nimi rekena agaana tisaanuri waru adalepape. Nimimi kedaa pi yae onaanuna masaa-nane mea mariaaeme. Goa peme pare nimu riape-rupa maarea pare go kedaa pi yae rinalo nimimi raba meape kone naimi. ");
INSERT INTO kew_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Nimimiri waru adalepape. Nimina akuanumiri Gote-na agaa lakene aanu tisimiya. Goa pisimi pare nimimi go akuanuna rogaape apedaa wariaawa pepena epe-rupa paeme. ");
INSERT INTO kew_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Goa peme rabu nimimi nimina akuanuna wae pisimide kone niminaawa raaname omeme. Nimina akuanumi Gote-na agaa lakene aanu tu maomaawa rogaasimi-para nimimi nimuna matmat wariaawa pepena paeme. ");
INSERT INTO kew_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Go madaare Gote-me epe makuaae kone sua lalo: Neme nina agaa lakene aanu page aposel kogono aanu page nimu piri-para penaato. Goa palua pare nimumi go aa medaloma tu maomaawa medaloma kedaa pi yae kateme. ");
INSERT INTO kew_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Goa sa-pulu go pimi onaanuri abade mo Gote-na agaa lakene aanu tu maomasimi madaa abia page ora kedaa adaape mealimi. ");
INSERT INTO kew_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Aba Gote-me su yaa warinaloa mo aa Abel tu mao-mama ipua Sekaraia epe tu maomasimi rabu page kedaa adaape mealimi. Go aare Gote-na ada ru-nane pirisa rabu aana reke-para Gote-na epe pirape ada lapona rikiraana tu maomasimi. Gore neme nimi lagialo: Abade Gote-na aanu tisimide kogonona kedaare abia go piri onaanu nimimi rialimi. ");
INSERT INTO kew_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Nimiri rekena agaa tisaanu-ga nimimi waru adalepape. Nimimi kone makuaae meapena pora lobape ki nimimi riti peme. Goa peme pare nimina odobatalo pora gaape nalobeme. Go page onaa meda odobainalo page kone naimi pare nimimi pora gaape garulaeme. ");
INSERT INTO kew_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesumi go su gimisa rabu mo rekena agaa tisaanu-para Farisi aanu-para Yesu madaa wae ero agaa loa nipu madaa agaa rado rado misimi. ");
INSERT INTO kew_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Nimumi agaa loa nipu ko tulalo pisimi-pulu nipu agaa adaapu agaa misimi. Nipumi pa yada tea-daare nimumi nipu koso madaa mea aditalo pisimi. ");
INSERT INTO kew_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Onaanu ora adaapupe kiritaawa rulatabaawa medana aa madaa ata pisimi rabu Yesumi nipuna disaipel aanu-para agaa aba gupa sa: Nimi go Farisi aanuna bret ma-adaa yaape yis-ri waru adalepape. Neme nimuna makirae agaa madaa lalo. ");
INSERT INTO kew_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Oyae rayo rigitabaaya yaere oropere amaa salia. Go page oyae rayo kudiri pu iare oropere penaame waatea. ");
INSERT INTO kew_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Goa pea-pulu agaa rayo ribaane-para simiyaade agaare onaanumi epe paa-para pirua pagalimi. Gore agaa medaloma pawasi ru-para pirua simiyaadere so rudu madaa aawa lamonealimi sa. ");
INSERT INTO kew_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nina adami onaanu nimiri gupa lagiano: Onaanumi to yogane talimi-daare paalame naomalepape. Goa puare orope nimumi yada meda mada napalimi. ");
INSERT INTO kew_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nimi paala omape onaa nimi lagiano. Gote madaa paala waru omalepape. Nipumi onaa tu maomaawa orope repena sulaa-para mada mea lopalia. Gore neme nimi lagialo. Go aa padane madaa paalame omalepape. ");
INSERT INTO kew_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Nimimi ademe mone 2 toea-rupa yaa magata supu kabeme. Pare Gote-me yaa oge go-rupa madaare kone narugulaaya. ");
INSERT INTO kew_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nipumi nimina aalu iri rayo aba dipita. Gore nimimi paala naomeme-ga nimimi ogege kabape yaa-rupana yoto maoge yaeme. ");
INSERT INTO kew_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Gore neme nimi lagialo. Onaa rayo pa onaanuna ini agaa madaa nina bi laketemere gore ni Onaa Raapu Pirape Aa-na Si neme page Gote-na ensel-nuna ini agaa madaa go onaanuna bi laketoa. ");
INSERT INTO kew_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Goa palua pare onaa rayome onaana ini agaa madaa ni masaa rilalimiri gore Gote-na ensel-na ini agaa madaa Onaa Raapu Pirape Aa-na Si neme nimu masaa rilalua. ");
INSERT INTO kew_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Onaa rayome Onaa Raapu Pirape Aa-na Si madaa wae agaa teme-daare gore Gote-me go onaana wae yae mada mea rubalia. Goa palia pare onaa rayome Holi Spirit madaa ero agaa teme-daare Gote-me go onaana wae yae namea rubalia. ");
INSERT INTO kew_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Gore nimumi nimi lotu ada-para mea pua namba wan gavman page adaare aa mudunumi page koso pagenalo mea palimi. Go rabu nimimi paalame naomoa kone adaapu nasalepape. Gore niaame agaa akepu abutema yapae niaame agaa akepu laketema yapae kone nasalepape. ");
INSERT INTO kew_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Gore nimimi lape agaare Holi Spirit-mi nimina kone-para mapiraalia. ");
INSERT INTO kew_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Go rabu go pirisimi onaana rikiraana piri aa medame gupa sa: Tisaa-ya, Aapana moae yaenu mo ameame rumaawa gina. Neme rumaawa ni gina neme lakela sa. ");
INSERT INTO kew_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Goa sa pare Yesumi nipu goa lakesa: Ake ya? Ni nimina koso pagape aa-para nimina oyae rumaape aa-para ni-daa dia. ");
INSERT INTO kew_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Gore nipumi nimu gupa lakesa: Nimimi waru adoa surubalepape. Nimimi epame omape kone gimalepa. Aa medame nipu oyae adaapu salia-daare nipumi go yaenu madaa epe pirape kone mada namealia. ");
INSERT INTO kew_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Go rabu Yesumi nimu-para saa agaa meda gupa sa: Amope medana epe su adaapu i-para maapu eta oyae adaapu opoa nape ta. ");
INSERT INTO kew_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Go raburi go amo ne aa nipuna kone-para gupa isa: Abiare mo eta medaloma kirita sape adaare dia yaade-ga neme ake palua pae kone isa. ");
INSERT INTO kew_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Gore nipumi kone gupa isa: Neme goa palua. Neme nina eta sape adanu kilipia ada ora adaape medaloma palua. Goa puare nina wit-na ini-para mo eta rayo go adanu-para mea kirita salua sa. ");
INSERT INTO kew_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Goa palua kone salo: Go aa nipuna epe yae rayore saapirano maali adaapumi popalia pare epe-rupa piralua. Goa pea-ga abiare neme kitu pirua eta ipa nala puare pedo pu piralua kone isa: ");
INSERT INTO kew_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Go kone isa pare Gote-me nipu lakesa: Nere maeyae aa sa. Abia go ribaa ne omali-ga abade nena mea kiritae saede oyaenuri aapimi meali ya? ");
INSERT INTO kew_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Go rabu Yesumi agaa gupa lo kiritisa: Onaanumi epe oyae adaapu salimiri apo maeyae aa-na kone mogeteme. Goa palimi pare nimu Gote-na ini agaa-para naraa onaa pimi sa. ");
INSERT INTO kew_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Go rabu Yesumi nipuna disaipel aanu gupa lakesa: Go remaa madaa kone mealepa. Niaame ake nalima palo epe-rupa piralima palo kone adaapu nasalepape. Go page nimimi niaare yogane madaa ake maraalima palo kone adaapu nasalepape. ");
INSERT INTO kew_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Gore epe-rupa pirua yogane surubalima eta nape yae-para mamina maraape-para go madaa kone adaapu nasalepape. ");
INSERT INTO kew_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nimimi yaanuri adalepape. Nimumi onaana kone namogeaawa nape repena ini napoa eta namea kiriteme. Nimuna eta kiritape ada page na-aaya. Dia, pare Gote-me nimu raba mua eta kata. Gore nimi onaamere mo yaanu ora rabuaniaaeme. ");
INSERT INTO kew_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nimina onaa medame go oyae madaa kone adaapu salia-daare gore nipuna maali ogesi-daa wala adaalupu mada yolo pitia yapae? ");
INSERT INTO kew_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Dia-ga gore nimimi oge eta yaenu nasurubeme-ga nimimi pa yae medaloma madaa kone adaapu nasalepape. ");
INSERT INTO kew_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Nimimi plaua ini adalepape. Nimumiri mamina waritalo kalaipu kogono napeme. Dia, pare pagalepa. Abade mo amope Solomon-mere nipuna pepena rayo pisa pare mo plaua ininumi nipuna pepena maoge yaaya. ");
INSERT INTO kew_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Gore Gote-me mo su amaa ripu maopaawa nipuna pepena paaya. Goa pea pare go ripunu ekeraa-nanere nimumi poa repena sulaa-para iralimi. Goa pua nimimi go ripu maoge yateme-pulu Gote-me nimina maraape mamina gua nimi waru surubalia. Go kone adaapu saleme rabu nimina kone rulapere ora ogepu saapiruaeme. ");
INSERT INTO kew_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Goa pea-ga nimimi nape yae madaa kone adaapu nasalepape. Go page niaa ake nalima palo kone nasalepape. ");
INSERT INTO kew_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Gore go su amaa pirua kone narulae onaanumi go yaenu rayo asapeme. Pare Aapame nimina kone gupa imilo aba makuaaya. ");
INSERT INTO kew_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nimimi Gote-na Surube Su madaa kone rulaatepape. Goa palimi rabu mo oyaenu page mada gialia sa. ");
INSERT INTO kew_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Nimi oge sipsip menasinu nimimi paala naomalepape. Nimina Aapame nipuna Surube Su gulalo pedo pu pia. ");
INSERT INTO kew_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Goa pea-ga nimina oyae rayore nimumi kabenaloa mone-re mo onaa naraanu katapape. Goa palimiri nimina mone paus ora puri pane sua so yaa-para epe yaenu mada kirita salimina. Goa pua so yaa-para i yaere naetapalia. Go page so yaa-parare paake ne aame page namealia. Go page so yaa-parare alurai-para daalinu-para nimumi page go yae nanalimi. ");
INSERT INTO kew_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Gore nimimi epe yaenu kiritaeme-parare nimina kone page go-para agu pea sa. ");
INSERT INTO kew_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Nimina mamina aako leteme marudu yatapape. Goa pua lam wadunua managolaawa piralepape. ");
INSERT INTO kew_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Nimi go-rupa piralepape sa: Kogono naakinuri nimuna aa adaa ado piralemede-rupa piralepape. Go surube aare nipu mo ona rumaatalo eta yaweme-para adola palia. Goa pea-ga mo kogono naakinu ado pimi. Nipu ipua pora gaape epa taliare kogono naakinumi pora gaape aipapulu mada lobalimi. ");
INSERT INTO kew_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Go adaa aame epa adalia rabu nipuna kogono naakinumi u napatua adaba pitimi. Go rabu go kogono naakinuri pedo pu pitimi. Pagalepa. Go aa adaame raaname omoa mamina aako leteme marudu yawa nimu reke madaa mapiraalia Goa puare nipuna eta epa katea. ");
INSERT INTO kew_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Gore nipu ora ruma rumana epalia palo yaa kuta mupaa rekalade rabu epalia palo marea pare nimi u napatalimi. Goa pea-pulu nipumi go kogono naakinu madaa ora pedo waru palia. ");
INSERT INTO kew_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nimi go agaa pagalepa. Gore adana aaraame paake ne aa nipuna ada opalialo kone sua napataalia pare pa pitia. Go rabu mo paake ne aa epalia mada naodobalia. ");
INSERT INTO kew_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Gore Onaa Raapu Pirape Aa-na Si nimimi naniminaawa pa piralimi rabu epalia. Goa pea-ga nimimi page waru ado pitapape sa. ");
INSERT INTO kew_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Go rabu Pita-me goa sa: Aa Mudu, neme go lae agaare niaa-para agu lae pae pa onaanu rayo-para lae ya? ");
INSERT INTO kew_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Gore Aa Mudumi lalo: Gore epe kogono pua epe kone i naakiri aapi ya? Go naakiri nipuna aa adaame ada piri onaanu surubenalo kogono katea. Go naakimiri onaa medaloma nimuna eta rumaainalo mapiraalia ");
INSERT INTO kew_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Orope aa adaa ada-para wala ipua mo kogono naakimi lakesa-rupa kogono pina adaliare nipu madaa raaname omalia. ");
INSERT INTO kew_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Neme nimi ora lagialo. Go rabu aa adaame nipu oyae rayo su surubenalo aa mudu mapiraalia ");
INSERT INTO kew_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Yapare mo kogono naakimi kone gupa mada salia: Nina aa adaare abi aipapulu naepalia kone salo. Goa kone sua nipumi kogono naaki nogo medaloma tua eta no ipa bia noa nipu maeyaalia. ");
INSERT INTO kew_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Kogono naakimi goa pu pirua aa adaa abi naepea kone su epe-rupa nasuruba pitia. Goa palia rabu nipuna aa adaa oro meda aipapulu epalia. Ipuare rai mua mo kogono naaki nipu waru tua nipu kogono waru nasurube naakinu raapu mea rubalia. ");
INSERT INTO kew_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Mo kogono naakimiri mo nipuna aa adaana kone adea pare nipumi aa adaana kogono napaliare aa adaame ora puri waru paboa aipuyame talia. ");
INSERT INTO kew_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pare mo kogono naakimi nipuna aa adaana kone na-adoa yapare wae kedaa kogono pinaloa aa adaame ogepusi aipuyame talia. Gore onaanu kone oyae adaapu palimiri nimumi page oyae adaapu wala mada abuteme. Goa pea-ga onaanu ora kone oyae adaapu muaemere nimumi ora oyae adaapu medaloma page abuteme sa. ");
INSERT INTO kew_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Neme go su amaa ipisuri repena marata ipisu. Goa pea-ga go repenare abi rena kone salo sa. ");
INSERT INTO kew_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Neme kedaa pi baptais rado nona pi mealua pare nina robaa-para kedaa waru pia. ");
INSERT INTO kew_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Gore nimimiri niri go su amaa piri onaa epe-rupa mapiraatalo ipisu kone imi pae? Neme go su amaa epe-rupa pirape kone namea ipisu. Dia, pare onaana rurunu marugulata ipisu. ");
INSERT INTO kew_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Abia page orope page onaa supu padane ada-para pitimiri nimu rugulala paawa piralimi. Goa pua aa repomere mo aa laapo-para iaa aulalimi. Goa pua mo aa laapomere mo aa repo-para iaa aulalipi. ");
INSERT INTO kew_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Go rabu aaraame nipuna naakinu raapu yada kepeaalia. Goa pua naakinumi nimuna aaraa-para iaa aulalimi. Go page agimiri nipuna wanenu raapu yada kepealipi-pulu wanenumi nimuna aginu madaa iaa aulalimi. Ayaa medalomame nipuna naakina ore madaa yada kepealia-pulu go orenumi nimuna aayaanu madaa iaa aulalimi sa. ");
INSERT INTO kew_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesumi go onaanu-para page lakesa: Nimi naare pabala aaya-nane moae meda rekalaina ademe rabu aipapulu nimimi yai epolalo pia teme. Gore ora teme rabu yai ora mada epea. ");
INSERT INTO kew_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Go page no re-nane puri pane po ripu epea rabu ademere abia pani pia teme. Gore ora teme rabu naare reade. ");
INSERT INTO kew_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nimiri makirae onaanu pimi. Nimimi yaa-para su lapona robore waru ado kiriteme. Goa peme pare nimimi abia go di rabu palia yaere na-amakuaaeme sa. ");
INSERT INTO kew_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Gore nimimi oyae ademe rabu nimimi akolo waru na-ado reke peme? ");
INSERT INTO kew_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Aa medame ne koso laawa aditalo palia-daare nipi pena pora-nia pulaawa nipina agaa maredepo yaawa pulupape. Goa napaliri nipumi ne mo koso page aa piri-para mea palia. Gore koso pagape aamere etaa rini aanu mea katea. Go rabu etaa rini aanumiri mo kalabus ada-para mea mapatalimi. ");
INSERT INTO kew_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Goa pea-ga neme ne lagialo: Ne mo kalabus ada-para aipapulu mada naesepealimi pare aba ripia oge yago aba abulaina sa. ");
INSERT INTO kew_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Go raburi onaa medaloma pirua Yesu-para Galili su-para piri aanu madaa remaa lakesimi. Go aanumiri nimumi Gote madaa mena yaapi oyae raapu aana reke madaa irisimi rabu Pailat-me nimu tu maomasa. ");
INSERT INTO kew_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Gore Yesumi nimu-para agaa gupa lakesa: Nipumi Galili aanu gupa tu maomasa-pulu nimimi Galili su-para piri onaa medalomana pupitagi nape kone maoge yasimi kone imi pae? ");
INSERT INTO kew_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Neme ora nimi lagialo. Ora dia-ga nimi rayo pupitagi nape kone naperekealimiri nimu omesimi-rupa agu omalimi. ");
INSERT INTO kew_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Gore abade Siloam su-para piri aa 18-pela nimuna remaa napageme pae? Nimu kogono pua aana-me warini adaalu ada meda nimu madaa lopoa tu maomasa. Goa pisa-pulu nimumi mo Jerusalem su-para piri onaa medalomana pupitagi nape kone maoge yaasimi kone imi pae? ");
INSERT INTO kew_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Dia-ga nimi waru lagialo. Nimina pupitagi nape kone nagimoa kone naperekealimiri nimi rayo go-rupa wae su-para agu palimi sa. ");
INSERT INTO kew_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Gore Yesumi saa agaa meda gupa sa: Aa medame nipuna wain maapu rikiraana repena fik poasa. Orope nipu nape ini medaloma etea pame adama ipisa pare naetesa. ");
INSERT INTO kew_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Goa pisa raburi nipumi mo maapu surube aa gupa lakesa: Abiare maali repome go maapu-para repena ini etana pame asapula epawa pare naetana. Go repena po rubape. Go repename mo suna ipa pa noa maoyariana sa. ");
INSERT INTO kew_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mo maapu surube aame agaa gupa lakesa: Aa adaa, abia go maali pandanere pa aainawa. Gore nipuna pitaa re-para aawa piriri pua gawa menana i mea awo pabalua. ");
INSERT INTO kew_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Wala go ma-alimi ini madialiare epe tea pare namadialiare gore po rubaina sa. ");
INSERT INTO kew_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Kitu Pirape Yapi di meda rabu Yesumi lotu ada ru-nane aawa agaa mogeasa. ");
INSERT INTO kew_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Go-para ona meda pirisa ona nipu madaa wae remo meda pirisa. Gore romome mo ona nipuri yaina maali 18-pela patisa rabu mo upege pi oname nipuna masaa mada namaridulaasa. ");
INSERT INTO kew_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesumi go ona adoare gupa yaasa: Go ona, nena yainare aba mea rubaarude. ");
INSERT INTO kew_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nipumi mo onana aalu madaa ki isa rabu aipapulu mode oname masaa maridulawa reka aasa. Go rabu oname Gote-na bi minasaasa. ");
INSERT INTO kew_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Go raburi Kitu Pirape Yapi di yaade. Goa pea-ga Yesumi go onana yaina maepeaainaloa mo lotu ada surube aa mudumi ratu yawesa. Goa pisa rabu aa mudumi onaanu gupa lakesa: Gore kogono pape diri yapi 6-pela ia. Nimimi yaina maperekeaina kone salimi-daare kogono pape di rabu ipulupape. Pare go kone salimiri Kitu Pirape Yapi rabu napulupape. ");
INSERT INTO kew_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Go raburi Aa Mudumi nipu gupa abusa: Nere makirae agaa ne aa yaade. Nimiri Kitu Pirape Yapi rabu nimina gawa mena-para donki mena-para gonumi ipa nenalo ada-para pua esepeatalo peme. ");
INSERT INTO kew_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Goa peme pare go onare nipu akua Abraham-na wane pia pare Satan-me maali 18-pela ru-para nipu rogaasa. Goa pea-pulu Kitu Pirape Yapi orome nipuna yaina naesepealua yapae? ");
INSERT INTO kew_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nipumi goa sa rabu nipuna iaanumi yala posimi. Goa pea pare onaanumi nipuna epe yae rayo madaa raaname waru omesimi. ");
INSERT INTO kew_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesumi gupa lakesa: Gote-na Surube Suri ake madaa meano ya? Ake madaa mealua-daa epeaalia ya? ");
INSERT INTO kew_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Go piane lano: Oge repena mastet ini-rupaga aa medame go ini mua nipuna maapu-para poasa. Gore orope opoa sana adaa repena nona piane opalia. Go rabu yaanuri go repenana palaa madaa nimu ada waria piralimi. ");
INSERT INTO kew_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Gore Yesumi wala sa: Neme Gote-na Surube Su madaare ake lagiano ya? ");
INSERT INTO kew_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Gupa lagiano: Gore bret ma-adaa yaape yis-rupa ona medame go yis mua palaawa ipa repo raapu adaa pe-para mea morope sa. Go palaawa ora adaa yalia. Go-rupare Gote-na Surube Su adaa yalia rabu onaanu adaapu pitimi sa. ");
INSERT INTO kew_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesumi adaa adaare-para page oge adaare-nini page pamisa. Go rabu nipumi onaa medaloma agaa mogeaa-mama pua nipu Jerusalem su-para polalo pisa. ");
INSERT INTO kew_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Go rabu aa medame nipu agaa misa: Aa adaaya, gore Gote-me onaa ogepusi oro yaalo kagaa piraama laama mapuaalia ya? Go rabu Yesumi nimu goa lakesa: ");
INSERT INTO kew_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Abia nimimi oge pora gaape-para ora odobata polalo pulupape. Neme nimi lagialo. Onaa adaapu go pora gaape-para odobatalo palimi pare mada dia. ");
INSERT INTO kew_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Orope mo ada surube aame rekoa ada pora gaape po salia. Goa palia rabu nimi amaa-nane epa rekaawa pora gaape tua gupa teme: Aa adaa, niaa epomona pora loba teme. Go rabu nipumi nimi-para gupa lagialia: Nimi na-adawade-ga aa-para pirua epame palo ni maarea tea. ");
INSERT INTO kew_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Go rabu nimimi nipu gupa laketeme: Niaare abade ne raapu ipa no eta namade teme. Neme abade niaana adaare-para ipua niaa agaa page lagiade. ");
INSERT INTO kew_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pare nipumi nimi gupa lagialia: Nimiri aa-para pirua epame palo gore ni maarea tea. Nimi rayo pupitagi noae onaanu pimi-ga nimi rayo ni piri gimoa pulupa tea. ");
INSERT INTO kew_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Gore Abraham-para Aisak-para Jekop-para Gote-na agaa lakene aa rayo-para nimumiri Gote-na Surube Su-para pitimi. Goa pua nimimi nimu adalimi pare nimi amaa-nane mapiraalia Go rabu nimimi abulu regepe noa re lo piralimi. ");
INSERT INTO kew_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Go rabu onaanuri naare opala-nane page naare pabala-nane page re lapone page epalimi. Go rayore Gote-na reke madaa eta no piralimi. ");
INSERT INTO kew_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Go rabu abia aapu-nane pimi onaa medaloma riri-nane pua aba mudu piralimi. Go page abia mudu onaa medaloma pimiri go rabu nimu ora orope aapu-nane piralimi sa. ");
INSERT INTO kew_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Oge-daa pirua Farisi aanu medaloma Yesu piri-para ipua agaa lakesimi: Aa mudu Herot-me ne tu maomaatalo pia-ga neme go su gimoa su rado-para pu simi. ");
INSERT INTO kew_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Gore Yesumi nimu goa lakesa: Nimimi go kira yanana si-para gupa pua laketapape: Abia-para ekeraa lapore neme go wae remonu mea ruboa yaina ome onaanu maperekeyatalo pi. Goa pua kogono repome nina kogono dia yalia-ga pua laketapape sa. ");
INSERT INTO kew_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Go rabu Yesumi nimu agaa gupa lakesa: Pare abia ekeraa rudane ni pamualua. Goa pua Jerusalem su-para padane-para nimumi Gote-na agaa lakene aa mada tu maomalimina. ");
INSERT INTO kew_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Go rabu Yesumi lalo: Jerusalem su-para piri onaanu-ya. Nimimi Gote-na agaa lakene aanu tu maomaeme. Gote-me mea rapae onaanu page aana-me temede. Ora rana adaapu go su-para piri onaa rayo nina kimi mea kiritaawa upitalo pe. Gore yaa kuta kebome nipuna sinu popaa rolo-para mea kirita mapiraatade-rupa upiaatalo pe pare nimimi ni gimemede. ");
INSERT INTO kew_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Pagalepa. Gote-me nimina su Jerusalem su-para aba gimoaaya. Nimimi ni abia na-adalimi pare orope ni mada adalimi. Nimimi mada adalimi pare aba gupa teme: Aa Mudu-na bi mea ipisana aare nipu ora puri mina teme sa. ");
INSERT INTO kew_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Kitu Pirape Yapi di meda rabu Yesu nipu Farisi aanuna aa mudu medana ada-para eta nola pisa. Goa pisa raburi onaanumi nipu ora waru adaba pirisimi. ");
INSERT INTO kew_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Go rabu ki aa lapo pabopae aa medare nipu mo Yesu piri-para ipisa. ");
INSERT INTO kew_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesumi go aa odoa sana mo rekena agaa tisaanu-para mo Farisi aanu-para agaa gupa misa: Niaana rekena agaa madaare Kitu Pirape Yapi di rabu yaina ome aa mada maperekeaina yapae dia yapae? ");
INSERT INTO kew_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Goa sa pare nimu agaa nane pa pirisimi. Goa pisimi raburi Yesumi mo aa mua nipuna yaina maepeaawa nipuna adaa penaasa. ");
INSERT INTO kew_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Goa puare nipumi nimu lakesa: Aa padanemere nipuna mena gawa ipa naaku-para lopaliare nimimi Kitu Pirape Yapi di rabu amaa-nane nayola salimi ya? ");
INSERT INTO kew_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Goa sa pare nimumi go agaa mada na-abusimi. ");
INSERT INTO kew_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesumi eta nala pirisa rabu aa medaloma aba riri-nane reke madaa agu piritalo pisimi rabu Yesumi goa adesa-pulu nipumi saa agaame nimu gupa lakesa: ");
INSERT INTO kew_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Gore aa medame nimi ona rumaape eta yawe-para yaateare aba riri-nane i reke madaa napua piralepape. Dia-ga mo ne yaateade aame adaa bi ia page aa mudu meda go-pare epa pira tea rabu pua pirua agaa pagaina. ");
INSERT INTO kew_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Go rabu mo ne yaateade aame gupa epa lagialia: Neme go riri-nane ia rekere mo aa mudu kala tea. Go rabu ne ora yala adaape poloa nipuna reke minarepaawa masaa-nane popali. ");
INSERT INTO kew_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Goa pea pare aa medame eta nola epape tea raburi reke masaa-nane pua piralepape. Go raburi mo ne yaata aame ne epa adoa gupa lagialia: Adami aaya tea. Nere go riri-nane epa pira tea. Go rabu mo ne raapu eta no piralimi aanumi ne adaa bi gialimi. ");
INSERT INTO kew_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Gore onaa rayome nimuna bi minasaatalo palimiri orope nipu yala poloa oge aa pitia. Goa pea pare onaa rayome nimuna kone rabuaniaalimiri go onaare nimuna bi minasaalia. ");
INSERT INTO kew_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Go rabu Yesumi nipu eta nola epapa laade aa gupa lakesa: Neme eta waima yawali raburi nena adami onaanu-para amenu-para rurunu-para nena su medanu mone adaapu imi onaanu-para rayo nayaalape. Dia-ga nimumi ne yaateme rabu nimuna ada-para eta nainaloare nena eta abuteme. ");
INSERT INTO kew_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Dia, pare neme eta waima yawaliri gore onaa naraanu-para ke wae onaanu-para ini rabuni onaanu-para eta nenalo yaatapape. ");
INSERT INTO kew_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Go onaanumiri nena eta mada na-abuteme pare nimu puri waru mealimi. Orope Gote-me epe onaanu matmat-para marekaliade di rabu Gote-me abutea sa. ");
INSERT INTO kew_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yesu go agaa lakesa rabu reke madaa pirua eta nisade aa medame Yesu gupa lakesa: Onaanumi Gote-na Surube Su-para ru-nane pua nipuna reke madaa pirua eta nalimi-daare nimuri pedo pedo pu piralimi sa. ");
INSERT INTO kew_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Pare nipumi saa agaa gupa lakesa: Aa medame eta adaape yawolalo pisa rabu onaa adaapupe-para eta nola ipulupape lo lakesa. ");
INSERT INTO kew_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Gore eta nape di rudu sa rabu nipumi kogono naakinu mearepaawa mo eta nenalo yaasade aanu ipulupa lo pua laketapa sa. Eta rayo aba managola kiritaarima tapape sa. ");
INSERT INTO kew_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pare mo onaa padane padane laatapu nimumi pa agaa loa mada napalima simi. Aa medame agaa gupa sa: Nina emaapu meda kabawa-ga ni go adola palua sa. Goa pe-pulu ni ora odo pia abia mada napalima. ");
INSERT INTO kew_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Gore aa medame agaa gupa lakesa: Nina mena gawa 10-pela kabawa-pulu adia kuta-para mea pulu. Go kogono abia ia-daa odo pia sa. ");
INSERT INTO kew_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Gore aa medame agaa gupa lakesa: Abia ni ona pena go rumaato-pulu ni mada napalipa sa. ");
INSERT INTO kew_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Go raburi mo kogono naaki nipu wala pua nipu aa mudu laketa pisa. Go rabu mo aa adaame ratu yawoa nipuna kogono naaki goa lakesa: Mogo adaare-para pua pora-nia page aipapulu pua onaanu mealepa sa. Goa puare neme naraanu-para ke wae onaanu-para ini rabuni onaanu-para nimu rayo nina ada ru-nane lamua epape sa. ");
INSERT INTO kew_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Orope go kogono naakimi ipua lalo: Aa adaa, nena agaa aba pamu lawade pare reke medaloma pa pu pa ia sa. ");
INSERT INTO kew_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Go rabu aa mudumi kogono naaki gupa lakesa: Ne pua adaa pora kepaa-nini pua mo maapu pora kepaa-nini page puare nina ada ora rulatabena onaa rayo ora lamua epape sa. ");
INSERT INTO kew_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Neme ne lagialo. Abade onaa rayo neme yalawade onaanumiri naa eta ora ogesi page mada nanalimi sa. ");
INSERT INTO kew_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Onaa adaapupe Yesu raapu pamisimi rabu nipu pereke tua nimu agaa gupa lakesa: ");
INSERT INTO kew_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Gore onaa rayo ni rata mea epalimiri gore nimumi nimuna ama aapanu-para ore-para nogo naakinu-para ame baaninu-para nipuna kone-para ora gimoa epalimi. Goa pua nimu naa disaipel onaanu piralimi. ");
INSERT INTO kew_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Onaa rayome repena polopea waru mea rua ni rata mea epaliami-daare gore ora nina disaipel onaa piralimi. ");
INSERT INTO kew_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nimina onaa medame ada adaalupe meda palua kone saliare nipu pirua go ada mada pu kiritalua palo waru pirua koneme niminaalia. ");
INSERT INTO kew_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Goa napalia-daare nipumi ada pa pua napu kiritalia rabu onaame nipu giri laalimi. Akolo ya? Kone waru nasua ada pame pea-pulu giri laalimi. ");
INSERT INTO kew_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Go rabu nimumi lalo: Go aamere mopo ada pea pare nipumi go ada mada napu kiritalia teme. ");
INSERT INTO kew_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Gore aa mudu medame aa mudu rado meda raapu yada pula polalo palia-daare nipumi kone waru niminaa piralia. Gore nipuna yada pape aanuri 10,000-pela pimi pare mo aa meda nipuna yada pape aanu 20,000-pela mea epalia. Goa pea-pulu nipu mada ratalia kone sua gimalia. ");
INSERT INTO kew_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Gore mo aa mudu nipumi mada naratalua kone salia-daare gore nipumi agaa lo maayaape aanu aa mudu meda piri-para mea penaatea. Goa pua niaa yada gimoa epe-rupa pirapana laketa penaatea. ");
INSERT INTO kew_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Apo remaana re madaare Yesumi gupa lakesa: Nimina rikiraana onaa medame epe kogono pape kone nasua nipuna oyae rayo-para masaa narilaliare go aare nina disaipel onaa-rupa mada napiralimi sa. ");
INSERT INTO kew_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Apo epe kogono napu piralimiri ora wae aipa sol-rupa piralimi. Aipare ora epe yae aaya pare mo aipa-na rede dia yalia rabu niaame ake pua nipuna epe rede wala mapalima pae? ");
INSERT INTO kew_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Go piane aipare maapu-para poae yae page mada namaopaalia. Goa pua mena gawana i re-para mea imi page madaa namaopaalia. Onaa rayome go agaana re niminaaba piralimiri waru pagalepape sa. ");
INSERT INTO kew_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Oro medare takis mi aa adaapu-para riabo onaanu medaloma Yesuna agaa pagolalo epa kiritaawa pirisimi. ");
INSERT INTO kew_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pirisimi rabu Farisi aanu-para rekena agaana tisaanu-parame ratu yawe agaa gupa simi: Go aamere wae aanu raapu pirua eta nala simi. ");
INSERT INTO kew_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Goa simi raburi Yesumi nimu-para saa agaa meda gupa lakesa: ");
INSERT INTO kew_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Gore nimina rikiraana aa medame sipsip 100-pela punalia pare go sipsip mena padane alupalia. Goa palia raburi mo 99-pela su meda-para eta nalaina punini aame mo padane alupariaade asapa amaa puare mada pua mealia. ");
INSERT INTO kew_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Gore nipumi ora pua adasaawa muare nipuna pasaa madaa mea rua pedo pua ria epalia. ");
INSERT INTO kew_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Goa pua nipuna ada-para epa opapalia rabu nipuna adami aanu-para nipuna ada padane-para ae aanu-para ipulupa tea. Nimu epa kirita pirinaloa nipumi nimu goa laketea: Nimiri ni raapu pedo pu piramin aapa tea. Nina sipsip meda alupaaria pare neme asapaa-mama pua adasaawa meawa tea. ");
INSERT INTO kew_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Neme go saa agaana re wala nimi lagialo: Onaa adaapumi gupa 99-pela ora epe-rupa pirua wala kone pu robaa wala meda mada naperekealimi-pulu so yaa-para nimumi raaname omeme. Goa peme pare wae aa padane-mame kone perekealia rabu so yaa-para raana pia ora waru palimi sa. ");
INSERT INTO kew_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Gore ona medame mone ini 10-pela salia pare padane ma-alupalia rabu nipu ake pali ya? Gore nipumi lam wadunua ada-para waru aasa asapa amaa pua adaasa mealia. ");
INSERT INTO kew_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nipumi aba adasaawa muare nipuna adami onaanu-para ada padane-para ae onaanu-para ipulupa tea. Nimu epa kirita pirinaloa nimu gupa laketea: Nimiri ni raapu pedo pedo pamin aapa tea. Nina mone-re padane alupaaria pare neme wala asapua meawa tea. ");
INSERT INTO kew_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Neme nimi-para go remaana re lagialo: Gote-na ensel-numi wae aa padane kone perekealia rabu pedo waru palimi sa. ");
INSERT INTO kew_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesumi wala lalo: Aa medame naaki lapo madu ia. ");
INSERT INTO kew_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Gore laapo pa naakimi Aapa yaaloa lalo: Nena moae oyaenuri rumaawa nina giali-rupare abi gi sa. Go raburi aaraame oyae rayo rumaawa mo nipuna naaki laapo kasa. ");
INSERT INTO kew_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Gore mo naaki nipuna rumaa kane oyaeyaede rayo kabenaloa mone mubisa. Goa puare su adaalu-para pisa. Goa puare nipu su adaalu meda-para pua pirisa. Goa pua nipuna monedere nipuna pupitagi noa aba yolo rubebe pisa rabu dia sa. ");
INSERT INTO kew_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Goa puare nipuna mone oyaeyaede rayo pa rubebe pisa raburi orope go su-para reae ada meda pabesa. Go rabu nipu oyae ogesi-daa abuna meda naisa. ");
INSERT INTO kew_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Goa pisa raburi nipu go su-para ae aa meda piri-para kogono asapula pisa. Go aame kogono muare mena surubainalo go kogono mea kasa. ");
INSERT INTO kew_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mo menanu nimuri besaa abu nisimi rabu robaa mataalo go naakimi menana eta nalua kone isa. Goa pisa pare pa aa medame page eta nakasimi. ");
INSERT INTO kew_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Goa pisa raburi nipuna kone aba niminaawa gupa kone isa: Nina Aapana kogono naaki rayona eta adaapu suaayaade kone isa. Gore ni go ada su-para aaware ora reame ni go omalo-daa kone isa. ");
INSERT INTO kew_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Neme go su gimoa nina Aapa piri wala palua kone isa. Gore neme Aapa yaaloa gupa pua toa kone isa: Gote-na ini agaa madaa page nena ini agaa madaa page neme pupitagi no pirisude toa kone isa. ");
INSERT INTO kew_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Abiare ni epe naaki-daa dia-ga nina si pi nalape toa kone isa. Niri pa nena kogono naaki-rupa mapiraaina toa kone isa. ");
INSERT INTO kew_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Goa kone suare nipu rekoa aaraa piri wala polalo pisa. Goa pisa pare nipu su adaalu-para pena ipulaina aaraame aba adesa. Go rabu aaraa nipuna robaa-para odo ora waru omesa. Goa pua aaraa nipu aloma puare mo si pua upipalae sua nunu sipi. ");
INSERT INTO kew_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Go rabu mo naakimi Aapa yaaloa neme Gote madaa page ne-para page pupitagi nape aa-rupa pirawade. Niri neme nena si pi-daa nalape. Niri epe naaki-daa dia. ");
INSERT INTO kew_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Goa sa pare aaraame nipuna kogono naaki yaaloa goa lakesa: Nimimi ora epede set adaalu mea ipua epa yamatepa. Goa pua nipuna ki madaa rini meda mea mapiraatepa. Goa pua aariti page mea maraatepa. ");
INSERT INTO kew_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Goa pua epe midi waru ae gawa menana si mea ipua tu yawatepa. Gore niaame eta yawoa noa epe kone sua pedo pedo waru pamin aapa. ");
INSERT INTO kew_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Gore nina naakiri aba omana kone isude pare wala epa pia. Abare ora alupariaade pare wala go adasaato-daa. Go rabu nimumi pedo waru pu pirua eta no pirisimi. ");
INSERT INTO kew_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Goa pisa pare nipuna mupaa naakiri maapu-nane pirisa. Orope nipu wala adaa ipua re-para opapaawa rabialo-para mata-para pagesa. ");
INSERT INTO kew_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Pagesa rabu nipumi kogono naaki meda yaaloa agaa misa: Apo ada-parare nimu ake peme pae? ");
INSERT INTO kew_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mo kogono naakimi nipu lakesa: Nena ame ada wala epa yaade rabu nena Aapame gawa waru aayaade tu yawea. Gore mo naaki aba alupasade wala nena ada-para epe-rupa epa pia-daa pedo peme. ");
INSERT INTO kew_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Goa sa raburi mo naaki mupaa nipu ratu yawoa nipu ru-nane napua odobasa. Goa pisa raburi nipuna aaraa amaa-nane epenaloa saa ora ru-nane banalo ogesa. ");
INSERT INTO kew_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Goa sa pare mupaame aaraa gupa lakesa: Paga. Maali adaapumiri ni nena kogono adini naaki-rupa pirua nena kogono pasude. Neme nena agaa rana padane-daa narasisude. Goa pede pare neme ake giae ya? Gore neme pa meme menasi meda gula pisi yaalore naa adami aanu raapu pedo pu pirua mada yawo nola pisima pare goa napiside. ");
INSERT INTO kew_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pare go nena naakimiri nena yaenu rayo wae onanu madaa apo rubebe pisa. Wala epaana rabu page nipu odome omoa gawa epe yae apo tu yawaaride sa. ");
INSERT INTO kew_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Go rabu aaraame nipu-para agaa gupa lakesa: Go naaki-ya. Oro yaalo yaalo nere saana apo pipa-daa. Goa pea-ga naa oyae rayore ora nena yaade. ");
INSERT INTO kew_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Goa pea pare abia niaame eta yawoa pedo pamin aapa. Go nena amere aba omana kone ide-ga abiare wala go epe-rupa go epaana-daa. Gore ora alupasade pare abiare wala epaana-daa sa. ");
INSERT INTO kew_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesumi nipuna disaipel aanu gupa lakesa: Aa mudu meda nipuna mone oyae surubape aa meda mapirisa. Go rabu aa medaloma mo aa mudu piri ipua agaa meda gupa epa lakesimi: Nena mone oyae surubape aamere nena oyaeyae mea mabebolaria simi. ");
INSERT INTO kew_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Go raburi mo oyae surube aa nipu-para ipu loa lakesa: Nemere yada paena tame-ga ake pae? Nemere nina oyae rayo surubeaede-ga oyae pua dipia sa. Goa puare nere nina oyae wala nasurubaina sa. ");
INSERT INTO kew_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Gore mo kogono aa nipuna konere gupa: nemere ake palua pae kone isa. Aa adaame abia ni ratulalo pia. Goa pea-ga neme su awape kogono wala meda papere neme pa onaanu meda-para eta oyae gialepa lapere yalame omalua kone isa. ");
INSERT INTO kew_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Pare neme ora goa palua kone isa: Goa paluare nina kogono mada mea rataliade rabu adami onaanumi nimuna ada-para epe-rupa mada palua kone isa. ");
INSERT INTO kew_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Pirua kone gupa isa mo surubape aame nipuna aa mudu yago i onaanuri padane padane lo yaasa. Go raburi nipu piri ipisimi. Gore aa padanere nipu aba epenaloa mo mone surube aame nipu agaa misa: Nina aa muduna yagore neme akepu mea ya? ");
INSERT INTO kew_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Gore nipumi lalo: Wabala repenare 100 dram misude sa. Go rabu surube aame nipu gupa lakesa: Neme go yago tape pepare abia meano ne pa aipapulu pirua yago 50 dram abulape sa. ");
INSERT INTO kew_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Orope aa meda epenaloa mo oyae surubape aame nipu agaa misa: Nena yagore akepu raapo ya? Gore nipumi lalo: Neme wit-na iniri bek 100 misu sa. Go rabu nipu goa lakesa: Neme go yagona pepare i-ga gore neme medaloma gimoa 80 bek abulape sa. ");
INSERT INTO kew_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Gore go surube aame su amaa kone sua go-rupa kogono pisa. Goa pisa-pulu oropere mo aa mudumi makirae surube aa-na bi minasaasa. Gore pa su amaa piri onaanu nimumi yago madaa kogono puare aakone sua peme. Goa pua nimumi epe paa-para piri onaanu makiraawa nimuna kogono peme-rupa maoge yaeme sa. ");
INSERT INTO kew_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Go rabu Yesumi wala goa sa: Gore neme nimi lagialo. Go suna mone mu surube aanuri nimina adami onaanu raapu piralepape. Goa pua mone dia yalia raburi nimi oro yaalo pirape ada-para epe-rupa mada piralimi. ");
INSERT INTO kew_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Oge oyaesinu kanaloa onaa rayome waru epe-rupa surubalimi-daare gore adaa oyaenu page nimumi waru surubalimi. Go-rupa page onaa rayome oge oyaenu epea napaliare oyae adaa page epeana palia ");
INSERT INTO kew_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nimimi go su amaa pirua go su amaa ia yae waru nasurubaemere nimimi ora adaa yae mada nasurubalimi. ");
INSERT INTO kew_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Go page nimimi onaa medana oyae waru nasurubalimiri aapimi nimina meape oyae mada gialia ya? ");
INSERT INTO kew_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kogono naaki meda nipumi aa laapona kogono mada napalia. Dia-ga nipumi aa meda epe kone masalaawa meda ratu yaawa nipumi meda madaare ora raaname omoa-ga medare gimape kone salia. Nimimiri Gote-para mone kogono lapo rata raana raapu mada napalimi. ");
INSERT INTO kew_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mo Farisi aanuri ora mone madaa raaname omoa Yesuna agaa rayo pagesimi rabu nipu-para ero agaa simi. ");
INSERT INTO kew_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Goa simi raburi Yesumi nimu gupa lakesa: Nimina kogono pa pua onaanuna ini agaa madaa epe-rupa piritalo makiraeme. Nimimi goa peme pare Gote-me nimina robaa-para adea. Onaanumi pa oyae madaa pedo peme pare Gote-na ini agaa madaare go yae ora ramea sa. ");
INSERT INTO kew_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Gore Gote-na agaa lakene aanuna agaa-para Moses-na rekena agaa-para go lapore Jon namadisa rabu page pagesimi. Pare mo Jon madita yapina ipuare abia page Gote-na Surube Su madaa Epe Agaa su rayo-para aba pageme. Goa peme-pulu onaanu rayo Gote-na kepo ru-nane odobatalo peme. ");
INSERT INTO kew_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Gore su yaa lapo ora aipapulu mada dia yalia pare rekena agaana rugisi-daa page ora mada nadia yaalia sa. ");
INSERT INTO kew_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Aa rayome ore gimoa rado rumaalimi-daare ona paake yone aa pitimi. Go page aa rayome rasini ona rumaalimi-daare nimu ona paake yone aa-rupa pitimi sa. ");
INSERT INTO kew_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Abade amo ne aa meda pirua nipumi oro yaalo epe kane mamina agu maraawa epe mamina page yamoa epe epe eta agu no aasa. ");
INSERT INTO kew_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Gore nipuna ada pora gaape resi-para aa naraa meda Lasarus nimumi ria ipisimi. Go aa-na to madaare rere putipe pirisa. ");
INSERT INTO kew_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Gore Lasarus nipumi mo amo ne aana ada reke rolo-para lope oyae eta ebo asapu nolalo pirisa. Goa pisa rabu yana medaloma ipua mo nipuna rere epa pete pete pua sala pisimi. ");
INSERT INTO kew_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Gore orope mo Lasara nipu omenaloa yaa madaa ensel-numi go aa-na wasupa mea ria pua Abraham raapu so yaa-para mapiraasimi. Orope mode amope nipu page omesa rabu rogaasimi. ");
INSERT INTO kew_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Gore nipu wae naaku-para pua pirua nipu radaa adaape nisa. Goa pisa rabu nipumi ora so-pare Abraham adasaasa rabu Lasarus raapu pirisa. ");
INSERT INTO kew_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Go adasaasa rabu mo amo ne aame gupa yaasa: Aapa Abraham. Neme ni odome omape sa. Neme Lasarus wala epenaloa nipuna ki maalame ipa pataawa nina eke madaa epa saina. Goa pua nina eke madaa ogesi kogorena sa. Neme go repena sulaa-para radaa ora adaape nalo sa. ");
INSERT INTO kew_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Goa sa rabu Abraham-me gupa sa: Nina naaki. Neme kone narugulape. Abade su amaare ne epe-rupa pirua epe epe yaenu agu meade pare Lasarus-ri no su amaa pirua wae yaenu mu pirisa. Goa pisade pare abia go-para nipu epe-rupa pirina ne wala wae-rupa apo piruaye-daa sa. ");
INSERT INTO kew_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Gore yae meda page gupa apo ia-daa sa: Apone pimi aanu-para one pima aanuna rikiraanare Gote-me adaa kuba meda apo isana-daa sa. Goa pisana-pulu niaa-para nimi-para padane-para mada nakibu mapiralima sa. ");
INSERT INTO kew_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Go rabu mo amope aame gupa ogesa: Aapa, neme Lasarus su amaa wala penaaloa nina Aapana ada-para laketa penaala sa. ");
INSERT INTO kew_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Nina ame supu pimi-ga Lasaaraame nimu puri pane agaa laketa penaaloa nimu page go radaa no piruape su-para mada epalimilo lalo sa. ");
INSERT INTO kew_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Go raburi Abraham-me lalo: Nena amenuri Moses-na agaa remaa-para Gote-na agaa lakene aanuna agaa pagenawa sa. ");
INSERT INTO kew_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Go rabu mo amope aame Abraham-para lalo: Aapa Abraham dia. Go-rupare mada napagalimi pare aba ome aa meda wala matmat madaa rekoa pua laketeare gore mada pagalimi. Go raburi paala omoa kone mada perekealimi sa. ");
INSERT INTO kew_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Goa sa pare Abraham-me nipu lakesa: Gore Moses-na agaa-para Gote-na agaa lakene aanuna agaa napagalimiri aa meda matmat madaa wala rekoa penaaloa go aame pua tea agaa madaa kone narulalimi sa. ");
INSERT INTO kew_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Go raburi Yesumi nipuna disaipel aanu gupa lakesa: Pa epaliade oyaeyae wae yae rayomere onaanu pupitagi manaalia. Goa palia pare onaa medame go pupitagi nape yae palia-daare nipu madaa odo waru pea sa. ");
INSERT INTO kew_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Gore onaa medame oge nogo naakinuna kone rulae yae mabebolalia-daare gore waru adalepape. Goa palimi-daare nimuna maa-para adaa aana madu mudiaawa ipa ini-para mea lopalimiri ora o ta sa. ");
INSERT INTO kew_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Go kone namogealimi-daare nimi waru adoa piralepape lalo sa. ");
INSERT INTO kew_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Gore yapi padane madaare nipumi ne-para rana 7-pela waea palia pare nipu wala ipua ne-para ni odo pia loare kone perekealia. Goa tea-daare nipuna wae yae rana 7-pela mea rubape sa. ");
INSERT INTO kew_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Aposel aanumi Aa Mudu gupa lakesimi: Neme niaana kone rulaere ora waru ma-adaa yape simi. ");
INSERT INTO kew_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Go rabu Aa Mudumi nimu gupa lakesa: Gore nimina kone rulae konere go oge yamo ini-rupa yalia go repena gupa mada laketeme: Nena pita rasua no ipa solwara masaana pua aape te-daare go repename nena agaa pagoa goa mada palia sa. ");
INSERT INTO kew_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yesumi wala lalo: Gore nimi padanemere nimina kogono naaki medame maapu-para su awoa page mena sipsip punita teme. Goa pua nipu kogono gimoa ada-para epalia raburi neme go naaki aipapulu nena eta mea naa te ya? ");
INSERT INTO kew_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Gore dia-ga neme nipu gupa lakete: Naa eta aba mea rumaa te. Goa puare nena mamina marudupu yamoa neme eta aba no pirano pa ado pira te. Ni aba no kiritanoloa orope ne naina te. ");
INSERT INTO kew_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Gore nena kogono naakimiri nena agaa pagalia-daa ora pi mada te ya? Mada dia nipu kogono napua eta page nanaade. ");
INSERT INTO kew_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Goa palia-ga nimimi page Gote-me lagi yaenu rayo pu kiritua gupa tapape: Niaare pa kogono naakinu pima. Goa pua niaame oyae pemare ora niaana kogono pema tapape sa. ");
INSERT INTO kew_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu nipu Jerusalem su-para pora-nia puare Samaria Galili su lapona robo rikiraana pamisa. ");
INSERT INTO kew_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Nipu oge adaare meda-para pamisa rabu yakimi ti aa 10-pela nimu pora madaasimi. Go rabu nimu ogesi-daa mo-para rekoa puri paloa gupa yaasimi: Yesu, ne aa adaa-ga niaa madaa odome omape simi. ");
INSERT INTO kew_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Gore Yesumi nimu adoa gupa lakesa: Nimina yoganere mo Gote-na miru irae aanu pua mea waatapa. Goa sa-pulu nimu pisimi rabu nimuna rerenu kaapu yoa ora rayo epe simi. ");
INSERT INTO kew_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Go rabu aa padane nipuna yogane wala epe sa adesa-pulu nipu Yesu piri-para wala puare Gote-na bi minasaasa. ");
INSERT INTO kew_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yesu piri-para pua Yesuna kibu re-para aipapulu lopoa nipu-para ora pi sa. Go aare nipu Samaria adaare-para pirisa. ");
INSERT INTO kew_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu nipumi go aa adoa gupa sa: Nemere aa 10-pelana yaina maperekeaaru-ga aa 9-pelare aa-para puame pae? ");
INSERT INTO kew_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Go pora kimisu aa padanere wala Gote-para ora pi lo laketa epaana. Go aa medaloma aa-para pimi pae? ");
INSERT INTO kew_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Go rabu Yesumi nipu gupa lakesa: Nere abade kone rulaari-pulu nena yaina epeade-ga rekoa adaa pu sa. ");
INSERT INTO kew_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Gore Farisi aanumi Yesu gupa agaa misimi: Gote-na Surube Su-na di aa-rabu epalia yapae simi? Go raburi Yesumi nimu gupa lakesa: Gote-na Surube Su epaliade di raburi nimina pa oyaenu mada na-adalimi. ");
INSERT INTO kew_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Onaanumi Gote-na Surube Su-na diri mogo-nane ia-ga adalepa pi-daa mada nateme pare Gote-na Surube yaere aba epa ia. ");
INSERT INTO kew_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Go rabu Yesumi nipuna disaipel aanu lakesa: Orope epaliade di rabu nimimi kone gupa salimi: Onaa Raapu Pirape Aa-na Siri yapi padanere niaame aipapulu abi adamona teme. Pare nimimi mada na-adalimi. ");
INSERT INTO kew_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Gore nimina rikiraana pimi onaa medalomame nimi gupa lagialimi: Adalepa. Mo-nane nipu mo aaya-daa. Go-rupa lagialimi pare nimuna agaa naratalepape. ");
INSERT INTO kew_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","So yaa-para ari-yapa pili pili popeade-rupa Onaa Raapu Pirape Aa-na Sina di aipapulu go-rupa epalia. ");
INSERT INTO kew_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Goa palua pare neme kedaa adaapu aba rialua rabu go abia go pimi onaanumi ni madaa masaa rilalimi sa. ");
INSERT INTO kew_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Gore abade mo Noa pirina pirisimide-rupa abia ni Onaa Raapu Pirape Aa-na Si madaa page gupa palimi: ");
INSERT INTO kew_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noa pirisa rabu onaanu pirua nimumi eta ipa bia nama pu ona rumaama pu pua mo Noa nipu ipunu-para pua odobasa rabu page paa-mama pu pirisimi. Go rabu ipa adaape roa sana onaa rayo tabesa. ");
INSERT INTO kew_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lot pirisa rabu page padane-rupa pisimi. Nipu pirisa rabu onaanumi ipa no eta no oyae kaboa rumaama puaawa emaapu poa ada wari goa pisimi. ");
INSERT INTO kew_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pare go aa Lot-me Sodom su gimoa pisa raburi ora go yapimi so yaa-para i repena sulaa page aana meda pugu pi yae lapore yai nona piane su amaa madu lopesa. Goa pua go su ada onaa rayo rabisa. ");
INSERT INTO kew_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Apo pisade-rupare Onaa Raapu Pirape Aa-na Si nina di penaame waatoa raburi gupa wala pu piralimi sa. ");
INSERT INTO kew_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Go di raburi onaanu nimina ada amaa-nane piralimiri gore nimina oyaenu ada ru-nane ina mada namula palimi. Go page onaanu nimuna maapu-para pitimiri gore nimu ada-para oyae wala namula palimi. ");
INSERT INTO kew_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nimimi Lot-na oreme pereke tua oyae adesade remaa waru niminaatepape. ");
INSERT INTO kew_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Gore onaa rayome nimuna yogane surubolalo palimiri nimuna wasupa page alupalia. Goa palia pare onaa rayome nimuna yogane gimoare nimu oro yaalo pa pitimi. ");
INSERT INTO kew_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Neme nimi lagialo: Go ribaare aa laapo padane reke madaa patalipi pare Gote-me medare mua medare pa pata ina gimalia. ");
INSERT INTO kew_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Go rabu ona laapome eta wariape kogono palipi pare Gote-me meda mua medare pa pirina gimalia. ");
INSERT INTO kew_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Gore aa laapo maapu-para kogono palipi pare Gote-me aa medare mua aa meda gimalia sa. ");
INSERT INTO kew_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Go rabu disaipel aanumi agaa gupa misimi: Aa Mudu-ya. Goare aa-para palia yapae simi. Gore Yesumi nimu gupa lakesa: Paga, mo ome onaana ro pa rogaabaayare yaa itaayama epa kiritaawa ruaeme-pare sa. ");
INSERT INTO kew_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Go rabu Yesumi nimu saa agaa meda mogeasa. Go agaana re-re beten nagimalepape lo lakesa. Yesumi lalo: ");
INSERT INTO kew_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Taun meda-parare koso page aa meda pirisa. Go koso page aamere Gote madaa paalame naomoa onaanu madaa page kone waru namapiraasa. ");
INSERT INTO kew_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Gore ona wasaa medare go adaare-para pirua oro yaalo koso page aa piri-para ipua gupa epa lakelala pisa: Nina iaame ni madaa waea pea-ga koso pagali rabu ni raba meape sa. ");
INSERT INTO kew_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Aba ripia go koso page aame naraba mulalo pisa pare orope nipuna robaa-para gupa kone isa: Nemere Gote page paala napea onaanu page paalame naome. ");
INSERT INTO kew_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Goa pea pare go ona wasaame ni komo mapaaya-ga nipu koso madaa raba mealua kone isa. Gore goa-daa napaluare nipu oro yaalo koso madaa agu epalia rabu orope ni ora waru komo palia kone isa. ");
INSERT INTO kew_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Go rabu Aa Mudumi gupa sa: Nimimi go koso page wae aana konere waru adalepa sa. ");
INSERT INTO kew_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Gore Gote nipuna onaanumiri nipu-para oro yaalo ribaa aebo page nipu yaaloa re lo pimi. Goa pea pare Gote-me nimuna koso madaa epe-rupa naraba mealia ya? Nipumi ado piraama piraama pua abi naraba mealia yapae? ");
INSERT INTO kew_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nipumi nimi aipapulu epe-rupa raba mua beten pagalia. Goa pea pare oropere ni Onaa Raapu Pirape Aa-na Si epalua rabu su amaa piralimide onaanumi kone rulalimi yapae? ");
INSERT INTO kew_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","10","Gore onaa medaloma ora wae onaanu kone isimi. Goa pisimi-pulu Yesumi saa agaa gupa lakesa: Aa laapome beten talo lotu ada-para pisipi. Aa medare Farisi aa yaade. Aa medare mone takis mi aa yaade. ");
INSERT INTO kew_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisi aare nipu agu raapo rekaawa beten gupa sa: O Gote, niri pa aa radonu-rupa napi-daa neme ne-para ora pi lalo. Nimumi oyae paake no ona rasini mu goa peme pare niri nimu-rupa napi. Go page abia mo mone takis mi aa go aaya-daa niri nipu-rupa napi-daa ora pi lalo. ");
INSERT INTO kew_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Gore sarara rayona ru-para yapi laapome eta madaa niti pua gimede. Gore neme oyae rayo medalomare rugulua ne ode gede. ");
INSERT INTO kew_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Goa sa pare mo mone takis mi aare mo-para yola moneaawa nipumi beten sa rabu yala po sa-pulu na-adasaasa. Dia, pare nipuna aako rupitua beten gupa sa: O Gote, niri ora wae aa ya-pulu neme ni madaa odome omape sa. ");
INSERT INTO kew_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesumi lalo: Neme nimi lagialo. Go takis mi aare nipuna ada-para wala pisa rabu Gote-na ini agaana nipu redepo ne aa-rupa pirisa. Pare mo Farisi aare pisa rabu redepo ne aa-rupa napirisa. Onaa rayome nimuna bi minasaalimi-daare Gote-me go onaa rabuaniaalia. Pare onaa rayome Gote-na ini agaana nimuna bi rabuaniaalimi-daare go onaana biri Gote-me minasaalia sa. ");
INSERT INTO kew_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Go rabu onaa medaloma nimuna yonu-para i nogo naaki nimu Yesu piri lamua ipisimi. Yesumi nipuna kimi aalu madaa oraainalo mea ipisimi. Goa pisimi pare disaipel aanumi go kone adesimi rabu nimu-para ape simi. ");
INSERT INTO kew_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Goa simi pare Yesumi mo nogo naakinu re-para ipulupa loa lalo: Nimimi apo nogo naakinuri ni piri epenatapa. Gote-na Surube Su-para go piane nogo naaki adalimi. ");
INSERT INTO kew_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Pagalepa. Onaa rayome Gote-na Surube Su go oge nogo naaki-rupa namu piralimiri ora mada na-adalimi sa. ");
INSERT INTO kew_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Juda aa mudu medame Yesu agaa gupa misa: Epe tisaa-ya. Neme oro yaalo kagaa piraama laama pope konere ake pua mealua yapae? ");
INSERT INTO kew_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Gore Yesumi nipu agaa gupa misa: Niri akeane epe aa lae ya? Gote padanere ora epe ta. ");
INSERT INTO kew_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nimiri rekena agaa aba pagemede. Neme ona paake nayolape. Onaa meda natu maomape. Neme paake nanape. Neme aa meda-para yaa agaa nalape. Nena ama Aapana bi minasaa agaa waru pagape sa. ");
INSERT INTO kew_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Gore aa mudumi lalo: Aba ni oge naaki rabu page abia go rabu page neme rekena agaa rayo waru pagoa rate sa. ");
INSERT INTO kew_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesumi go agaa pagoa nipu goa lakesa: Ora lae pare ne apo agaana pora padane nakuriti: Nena oyae madaa me mone-re onaa naraanu pua rumaa kalape. Goa pali raburi so yaa-para nena epe yoto rado ora pua meali. Goa puare ni rata mea ipu sa. ");
INSERT INTO kew_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Gore mo aa mudumi go agaa pagoa nipuna robaa-para kedaame ora waru omesa. Akolo ya? Nipu oyae adaapu isa-pulu. ");
INSERT INTO kew_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesumi nipuna kedaa pi kone adoa lalo: Amope onaanuri oyae adaapu imi-pulu Gote-na Surube Su-para polalore kalai peme. ");
INSERT INTO kew_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Gore mena kamel-me noi kego nona piane-para palia-daare kalai waru palia. Gore ora kalai kogono yapare amopenu Gote-na Surube Su adola polalore apo agaare maoge yaaya. ");
INSERT INTO kew_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Onaanumi go agaa pagoa nimumi lalo: Go laede oro yaalo kagaa pirape kone wasupare aapimi mada mealia yapae simi. ");
INSERT INTO kew_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesumi lalo: Go-rupa piralimi-daare onaanumi mada napalia kone i yaere Gote-me mada palia sa. ");
INSERT INTO kew_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Gore Pita-me lalo: Paga. Niaame ne rata mea epolalo niaana oyaenu-para adanu-para aba gima epa amaa sa. ");
INSERT INTO kew_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Yesumi nimu goa lakesa: E, yapare nimi lagialo: Onaa rayome Gote-na Surube Su kone madaa rulaawa nimuna su adaarenu-para onaanu-para amenu-para ama aapa lapo nu-para nogo naakinu-para gimoa epalimi-daare gore abia gore yoto waru mealimi. Goa pua orope kagaa di rabu page Gote-me oro yaalo kagaa pirape kone kalo abutea sa. ");
INSERT INTO kew_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesumi nipuna 12-pela disaipel aanu mo-para agu raapo mea puare nipumi lalo: Abiare niaa Jerusalem su-para baina. Go su-parare abade Gote-na agaa lakene aanumi Onaa Raapu Pirape Aa-na Si madaa lakeloa pepa madaa tisimide agaare gore ora yaluame pia. ");
INSERT INTO kew_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Go su-parare nimumi ni pa ruru radonu lamu kateme. Goa pua nimumi ni madaa giri laawa ero agaa loa sope rapialimi. ");
INSERT INTO kew_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Goa pua nimumi ni repena unimi kudu tuare mada tu maomalimi. Goa palimi pare wala yapi repo dia naloa wala rekalua sa. ");
INSERT INTO kew_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Go agaa lakesa pare disaipel aanu nimumi go saa agaana re naniminaasimi. ");
INSERT INTO kew_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu Jeriko su-para pisa rabu ini rabuni aa meda pora aane-nane pirua onaanu-para mone ogeyo pirala pisa. ");
INSERT INTO kew_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Gore nipumi onaa adaapupe epeme remaa pagesa-pulu nipumi onaa medaloma agaa gupa misa: Gore apo onaanumi ake teme pae? ");
INSERT INTO kew_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Gore nipu goa lakesimi: Nasaret ada-para aede Yesu epea tame simi. ");
INSERT INTO kew_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Gore nipumi puri paloa gupa yaasa: Yesu, nere Devit-na si yaade. Neme ni madaa odome omape sa. ");
INSERT INTO kew_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Gupa yaasa rabu aba riri-nane pisimide onaanumi nipu-para ape gupa simi: Nena agaa loraa simi. Pare nipumi agaa wala ora puri paloa yaasa: Nere Devit-na si-ga neme ni odome omape sa. ");
INSERT INTO kew_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Go rabu Yesu nipu pa aawa nimu lakesa: Apo aare ni piri lamua ipulupa sa. Nipu re-para ipisa raburi Yesumi nipu agaa misa: ");
INSERT INTO kew_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Neme nere ake pano kone sae? Nipumi lalo: Aa Adaa, nina ini maepeaape sa. ");
INSERT INTO kew_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Go rabu Yesumi nipu gupa lakesa: Nena inimi oyae ada. Neme kone rulaari-pulu nena ini maepeaato sa. ");
INSERT INTO kew_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Goa sa rabu aipapulu nipuna inimi oyae adesa. Goa pua nipumi Yesu rata mea pua Gote-na bi minasaasa. Onaanumi page goa adoa Gote-na bi minasaasimi. ");
INSERT INTO kew_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","2","Yesu nipu Jeriko su-nane pisa rabu aa meda nipuna biri Sakius nipu go-para pirisa. Go aare takis mi aanuna aa mudu pirua nipu mone adaapu isa. ");
INSERT INTO kew_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Go aamere Yesuri aapi yapae kone sua waru adolalo pisa. Goa pisa pare onaa adaapupe rekaawa maebesimi-pulu nipu ora rudu aasi yaa-pulu Yesu adaape-rupa maaresa. ");
INSERT INTO kew_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Gore nipu aipapulu riri-nane aba pua Yesu adolalo repena meda pua rumisa. Yesu go pora-nane epalia kone sua ruma pirisa. ");
INSERT INTO kew_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Gore Yesu nipumi mo pora-nia pua so Sakius pirisade-para adasaawa gupa lakesa: Sakius, ne aipapulu kilipia ipu. Abiare nena ada-para pirapana sa. ");
INSERT INTO kew_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Goa sa rabu nipu aipapulu kilipia pedo pua nipuna ada-para lamua pisa. ");
INSERT INTO kew_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Goa pisa pare onaa rayome go kone adoare ratu yawoa gupa simi: Nipuri aa wae medana ada-para patula pula simi. ");
INSERT INTO kew_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Go rabu Sakius nipu rekaawa Aa Mudu gupa lakesa: Aa Adaa pagape, abiare nina oyae rayo rikiraana rumaawa medalomare onaa naraanu kalano. Go page abade neme makiraawa onaa medana oyae paake meala pere go yagore rana maala ode abutua sa. ");
INSERT INTO kew_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesumi nipu gupa lakesa: Abiare go nena ada-para piri onaanu oro yaalo kagaa pirape kone mealimi. Ne go aa page Abraham-na ruruna si piraena. ");
INSERT INTO kew_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ni Onaa Raapu Pirape Aa-na Siri neme alupae onaanu asapua raba mulalo ipisu sa. ");
INSERT INTO kew_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nimu go agaa pago pirisimi onaanuri Yesumi saa agaa rado meda lakesa. Go rabu nipu Jerusalem su re-para pisa-pulu nimumi Gote-na Surube Su-na di aba epena kone isimi. ");
INSERT INTO kew_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Go kone isimi rabu Yesumi nimu gupa lakesa: Epe aa mudu meda su adaalu-para polalo pisa. Go su-parare nimumi nipu aa mudu mapiraainaloa orope wala nipuna onaanu pua surubalia. ");
INSERT INTO kew_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Gore nipu polalo pisa rabu nipuna kogono naaki 10-pela yaloare nipumi 800 kina padane padane lo rumaa kasa. Goa pua nimu gupa lakesa: Ni apo su-para piralua rabu go mone-re rome pa amaa pa amaa pu piralepape sa. ");
INSERT INTO kew_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pare mo nipuna ada padane-para piri onaanumi nipu gimolalo ratu waru yawesimi. Goa puare nipu aba penaaloare aa medaloma wala orope mea penaasimi. Gonu nimumi mo mudu mapiraape aanu-para go aa niaana aa mudu mada napiralia simi. ");
INSERT INTO kew_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pare apo su-para nipu aa mudu mapiraainaloa nipuna adaa re-para wala orope ipisa. Go rabu nipumi abade mone kasade kogono naaki repaa-para aipapulu ni piri-para ipulupape lo agaa rapaasa. Nipumi nimuna ode mone-me akepu raapo saapiruaeme palo adano kone isa. ");
INSERT INTO kew_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Gore aa medame aba ripia mone misade aare nipu ipua sa: Aa adaaya. Neme gode 800 kina giside pare neme rome pa amaa puare wala mone ode 8,000 kina meda page meawa sa. ");
INSERT INTO kew_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Gore aa mudumi nipu gupa lakesa: Nere ora epe kogono pape naaki. Neme nina oge yaenu page waru surubaena-pulu abia neme adaare 10-pela mada surubaina sa. ");
INSERT INTO kew_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Gore naaki laapo ipua epa lalo: Aa adaa, neme nena 800 kina rome pa amaa pisu pare wala 4,000 kina meda pa ode mea sawa sa. ");
INSERT INTO kew_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Gore aa mudumi lalo: Epe ta-ga nere adaare supu mada surubaina sa. ");
INSERT INTO kew_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Gore mo naaki meda ipua epa lalo: Aa adaa, nena dola padanere go-para ia-ga neme abade hankisip-mi rogaawa paga isu sa. ");
INSERT INTO kew_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nere ora puri pane aa ya-pulu oyae waru muaayede-daa ni paala omoa nena mone pagaa saaru. Neme onaa radonuna oyae mu pa onaa radome eta poaemedere gore neme aawa me tede sa. ");
INSERT INTO kew_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Gore mo aa mudumi go kogono naakiri gupa lakesa. Nere ora kogono naaki wae yana. Neme go laede agaa madaa koso lape. Niri ora puri pabe aa lore neme ade pae? Pa oyae pa onaa radome saapiri gore neme mealode lae? Eta pa onaa radome poaere awalode lae? ");
INSERT INTO kew_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Goa paena-ga neme nina mone-re abade mo mone kiritape ada-para nasaari pae? Goa pula pisi yaalore ni wala ipuare ode medaloma raapu epa mula pawa-ga akeane gupa napaari pae? ");
INSERT INTO kew_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Go rabu nipumi mo epa rekasimide onaanu-para gupa lakesa: Nimimi go saapirana mone 800 kina-re mua mo 4,000 kina saapimi naaki mea kata pa tea. ");
INSERT INTO kew_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Goa sa rabu mo onaame nipu lakesimi: Aa adaa, nipuri 8,000 kina ode aba go sana-daa simi. ");
INSERT INTO kew_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Gore nipumi lalo: Pagalepa. Onaa rayome oyae saapitimi-daare neme medaloma wala katoa sa. Yapare onaa medalomame oyae waru nasaapitimi-daare go nimuna saapimi oge yaenu page wala mealua sa. ");
INSERT INTO kew_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Pare nina iaanuri ni nimuna aa mudu napirina kone imi-ga go onaanuri go-pare mea ipua nina ini agaa mada epa tu maomatepape sa. ");
INSERT INTO kew_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu nipumi go agaa loare Jerusalem su-para pora-nia aba pisa. ");
INSERT INTO kew_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nipu Betepasi su robo ru-nane puare Betani adaare-para pisa rabu nipu Rudu Oliv re-para pisa. Goa puare nipuna disaipel aa laapo aba penaasa. ");
INSERT INTO kew_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Go aa lapo-para gupa lakesa: Nipiri mogo adaare mo-nane aaya-para pulupape. Go-para puare mena donki mena si-daa aa meda nipuna masaana abi napirina ope pua koloa mea ipulupape. ");
INSERT INTO kew_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Gore aa medame go mena donki akeane nipimi iti esepealepa teare nipimi agaa gupa laketapape: Aa Adaana kogono ia-daa mula pulupape la tapape sa. ");
INSERT INTO kew_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Yesumi nipu lapo mea rapaasa raburi mo nipumi lakesa-rupa oyae rayo gupa adesipi. ");
INSERT INTO kew_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nipumi mo donki mena ope kolala pirina mo donki menana aaraanumi nipu gupa lakesimi: Ake pea-daa nipimi go donki mena si kolapatepe pae simi. ");
INSERT INTO kew_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nipumi lalo: Aa Adaana kogono ia-daa pipa sipi. ");
INSERT INTO kew_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Gore nipumi mo donki mena si Yesu piri mea ipisipi rabu nimuna mamina meda mo donki mena madaa madu isipi. Goa pua Yesu nipu mo mena donki mena masaana mapiraasipi. ");
INSERT INTO kew_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Gore nipu mo donki mena masaana piraama pisa rabu onaa rayo nimuna mamina-nu pora-nia saapisimi. ");
INSERT INTO kew_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nipu Oliv Rudu-nane pe pora rugulaniaawa re-para ipisa rabu nipuna disaipel onaa adaapumi pedo pisimi. Nimumi abade mo napiaa kogono adesimi-pulu nimumi puri paloa Gote-para ora pi loa nipuna bi minasaama pu yaasa laa-mama pu pisimi. ");
INSERT INTO kew_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Go rabu nimumi gupa yaasimi: Aa Mudu-na bi mea epe aa muduna bi minasaamina simi. Gote so yaa madaa epe-rupa piana adaa bi kalamina simi. ");
INSERT INTO kew_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Go rabu Farisi aanu medalomare mo onaanu raapu pisimi. Go aanumi Yesu-para gupa lakesimi: Tisaa-ya, nena disaipel-nu agaa loraatepa lo lakela simi. ");
INSERT INTO kew_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Gore Yesumi agaa gupa lakesa: Pagalepa. Nimuna agaa loraata peme yaalore gore mo aana-me Gote-na bi minasaalimi sa. ");
INSERT INTO kew_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu nipu Jerusalem su re-para pisa rabu nipumi adoa re sa. ");
INSERT INTO kew_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Re sa rabu nipumi lalo: Go su-para piri onaanu-ya, abia go yapi di madaa nimimi epe-rupa pirape kone mada namealimi. Goa pea pare nimimi na-ademe. ");
INSERT INTO kew_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Orope yapi medame iaanumi ipua yada kepo epa kutapuba piralimi. Goa puare nimi mada napogola palimi. ");
INSERT INTO kew_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Go rabu nimumi go nimina adaare Jerusalem su-para aana kepo padane padane lakepe rubalimi. Nimimi raba meape di na-ademe-pulu go kepo ru-nane piralimi onaa rayo tu maomalimi sa. ");
INSERT INTO kew_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Goa pua Yesu nipu lotu ada-para pua odobaawa mo rome pape kogono pi aanu pua ratu tisa. ");
INSERT INTO kew_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Go rabu nipumi nimu goa lakesa: Gote nipuna buk madaa gupa tu isa: Nina adaare beten lape ada aayaade lo tisana. Goa pea pare nimimi go epe kone gimoa paake ne aanuna kaledape ada-rupa wariamena sa. ");
INSERT INTO kew_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Goa pua Yesu oro yaalo lotu ada-para onaa agaa mogeasa. Goa pisa-pulu Gote-na miru irae aa mudunu-para rekena agaana tisaanu-para onaanuna aa mudu-para nimu rayo kiritaawa Yesu tu maomaatalo yada robesimi. ");
INSERT INTO kew_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Goa pisimi pare onaa rayome Yesuna agaa waru pago pirisimi-pulu aa mudunumi go rabu mada natisimi. ");
INSERT INTO kew_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Oro meda Yesumi lotu ada ru-nane onaanu Epe Agaa mogeasa rabu Gote-na miru irae aanu-para rekena agaana tisaanu-para kone makuaae aanu-para nimu rayo Yesu nipu piri-para ipisimi. ");
INSERT INTO kew_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ipisimi rabu nipu gupa lakesimi: Neme niaa lagi. Nena go kogonore aapimi mogeaaria-daa neme go kogono pamu pe pae? ");
INSERT INTO kew_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Gore Yesumi nimu-para agaa gupa lakesa: Neme page nimi agaa meda agaa mealua-ga nimimi ni lagialimina sa: ");
INSERT INTO kew_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jon baptais me kogonore Gote-me kasa pae pa onaanumi kasimi pae? ");
INSERT INTO kew_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Gore nimuna kiritaawa agaa gupa simi: Niaame ake tema pae? Gore niaame Gote-me kasa tema-daare nipumi gupa tea: Nimimiri akeane Jon madaa kone narulaeme pae lagialia. ");
INSERT INTO kew_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Gore niaame pa onaanumi kasimi tema-daare go pimi onaa rayome aana-me niaa talimi. Go pimi onaanumi Jon-re ora Gote-na agaa lakene aa kone waru rulaeme. Goa pea-ga pa onaanumi Jon kogono kasimide mada natema simi. ");
INSERT INTO kew_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nimumi Yesuna agaa abusimi rabu niaare Jon-na baptais kogonore aapimi kasa pae maarea simi. ");
INSERT INTO kew_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Go rabu Yesumi nimu goa lakesa: Gore nimimi maarea lamede-ga neme go kogonore aapimi puri ni guaaya-daa pe palo nalagialua sa. ");
INSERT INTO kew_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Go rabu Yesumi onaanu-para saa agaa meda gupa lakesa: Aa medame nipu wain maapu poasa. Goa puare nipuna maapuri yoto meape aanumi surubenaloa nipu pora kimisu adaalu-para pisa. ");
INSERT INTO kew_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Gore ora epe ini etesa raburi nipumi kogono aa meda maapu surubape aanu maapu-para eta ininu meaata penaasa. Goa pisa pare maapu surubape aanumi go aa ripinaawa tua wala penaasimi pare oyae nakasimi. ");
INSERT INTO kew_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Goa pisimi-pulu mo maapuna aaraame kogono naaki meda penaasa. Goa pisa pare mo aanumi nipu page ero agaa loa nipu tua oyae nakasimi. ");
INSERT INTO kew_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Goa puare mo aame kogono aa repo mea rapaasa. Gore maapu surubape aanumi go naaki nipu page radaa kaloa kepo amaa-nane pua tu rubisimi. ");
INSERT INTO kew_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Goa pisimi raburi mo wain maapuna aaraame lalo: Neme ake palua ya? Gore nina epe naaki padane mea rapaluare nipuna agaa mada pagalimi kone salo sa. Goa pua nipuna si mea repasa. ");
INSERT INTO kew_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Goa pisa pare mo maapu surubape aanumi mo nipuna naaki ipisa adesimi rabu nimumi gupa simi: Go naakimiri orope aaraana moae oyaenu mealia-ga niaame tu maomaamina simi. Goa puare go maapu niaana mada surubamina simi. ");
INSERT INTO kew_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Gore mo naaki kepo ru-nane epenaloa nimumi tu maomaawa amaa-nane pua rubisimi. Goa pua go maapuna aaraa nipumi ake palia pae? ");
INSERT INTO kew_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nipumi gupa palia lo lagialo: Nipumi ipua mo maapu surubape aanu epa tu maomaawa go wain maapuri pa aanu medalomame surubenalo mea katea sa. Gore go onaanumi go Yesuna agaa pagoa nimumi lalo: Dia, nipumi goa napalia simi. ");
INSERT INTO kew_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Goa simi rabu Yesumi nimu adaba sua lalo: Dia tame pare Gote-na buk-mi iade agaana re madaa ake teme ya? Pagalepa sa: Kamda kogono pi aanumi aana meda mea rubisimide. Pare go aana-re ora epe Aa Mudu-na aaya sa. ");
INSERT INTO kew_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Onaa rayome go aana madaa magatabalimiri nimu ogegepu rugula tabebe palia. Go aana-me onaa meda magataboa lopaliare go aare aasatua rugula palia sa. ");
INSERT INTO kew_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yesumi go saa agaa lakesa rabu rekena agaana tisaanu-para Gote-na miru irae aa mudunu-para nimumi niaa madaa agaa ta kone isimi. Ora go raburi nimumi nipu ripinaatalo pisimi. Goa pisimi pare onaanu madaa paala omoa gimisimi. ");
INSERT INTO kew_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Goa puare nimumi nipu ripinaatalo waru adapaba aasimi. Goa pua go aanumi pa aa medalomana mone kanaloa makirae kone sua Yesu piri penaasimi. Nimumi Yesu agaa mulalo pisimi. Goa pua nipu ko tisimi. Goa puare mo namba wan gavman-na purimi koso pagenalo pisimi. ");
INSERT INTO kew_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Go makirae aanumi Yesu agaa gupa lakesimi: Tisaa, nena agaare ora epe ta. Neme onaa rayo epe agaa mogeaate. Neme Gote-na pora madaa ora agaa agu mogeaaye rabu aa mudununa biri paalame naome. ");
INSERT INTO kew_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Goa pe-ga nemere ake kone sae pae? Niaana rekena agaa madaare niaame Rom suna aa mudu Sisar-para takis kalamina yapae dia yapae simi. ");
INSERT INTO kew_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pare Yesumi nimuna makirae agaa madaare adokaru misa-pulu nipumi nimu lakesa: ");
INSERT INTO kew_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","mone meda ni mea waatapa. Go mone madaa pia piksa-para bi lapore aapina yapae? ");
INSERT INTO kew_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Gore nimumi lalo: Sisar-na simi. Goa simi-pulu Yesumi nimu-para gupa lakesa: Sisar-na yaere nipuna katapape pare Gote-na yaere Gote nipuna katapape sa. ");
INSERT INTO kew_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Gore makirae aanumi onaanuna ini agaa madaa Yesu namakiraeme-pulu nimu agaa loraawa pa pirisimi. Go page nipuna agaa madaa kone adaapu isimi-pulu agaa nalo pa aasimi. ");
INSERT INTO kew_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadyusi aanu medaloma Yesu nipu piri ipisimi. Mo Sadyusi aanu nimuna konere ome onaanuri wala mada narekalimi kone isimi. ");
INSERT INTO kew_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Gore nipu agaa misimi: Tisaa-ya, Moses-me agaa meda niaa-para gupa tisana: Aa meda ona rumaawa omalia pare nogo naaki meda namadu salia. Goa puare go ona wasaame ome aa-na nogo naaki namadialia-daare go ome aa-na ameme go ona mada rumaalia ya? Moses-me gupa tisana simi. ");
INSERT INTO kew_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Gore amealu 7-pela pirisimi. Aba mupaamere ona rumaasa pare nipuna nogo naaki namadiaawa nipu omesa. ");
INSERT INTO kew_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Gore laapopa aame mo ona wasaa nipu misa. ");
INSERT INTO kew_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Wala go aana masaa-nane aame repome page goa pisa. Goa paa-mama puare mo amealu 7-pela nimumi mo ona padane misimi pare nimu nogo naaki namadiaawa pa omesimi. ");
INSERT INTO kew_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Oropere go ona page omesa. ");
INSERT INTO kew_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Gore aba ome onaa wala rekalimide raburi go ona padanere aapina ore ora pitia ya? Mo aa 7-pelame go ona aba padane rumaasimide simi. ");
INSERT INTO kew_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Gore Yesumi nimu goa lakesa: Abia go rabu su amaa pimi onaamere repaya pitimi. ");
INSERT INTO kew_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pare orope ome onaa wala rekoa piralimide onaanumiri nimu repaaya aulape kone nasalia. ");
INSERT INTO kew_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Nimu Gote-na akero-rupa piralimi-pulu nimu wala mada naomalimi. Gote-me nimu matmat-para marekaalia-pulu nimu Gote-na si wane-rupa oro yaalo piralimi. ");
INSERT INTO kew_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ome onaa matmat-para wala rekapere Moses-me page aba tisaaya. Go buk-ri repena rabe remaa lakesa rabu nipu Aa Mudu Abraham-para Jekop-para Aisak go repona Gote pa pia-daa tisa. ");
INSERT INTO kew_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Go agaana re gupa sa: Gote-re ome onaanuna Gote-daa Dia, pare nipu kagaa piraama laama pope onaanuna Gote yaade. Onaa rayo wala rekalimilo go agaa lakesa. ");
INSERT INTO kew_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nipumi goa sa raburi rekena agaa tisaanumi gupa simi: Tisaa, neme ora waru lae simi. ");
INSERT INTO kew_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Goa simi pare nipu wala agaa meape paalame omesimi-pulu pa ora lae simi. ");
INSERT INTO kew_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesumi nimu goa lakesa: Gore nimumi Onaa Raapu Pirape Aa-na Siri nipu Devit-na si piralia teme. Go agaana re ake ya? ");
INSERT INTO kew_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Buk Sam madaare Devit nipuna agaa gupa sa: Gote-me nina Aa Mudu-para gupa lakesa: Nina popeke ki-nane aa mudu mapiraalia sa. ");
INSERT INTO kew_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Oropere neme iaanu nena aa rolo-para marabuaniaalua sa. ");
INSERT INTO kew_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Gore Devit-mi Aa Mudu nipu lakesa. Goa lakesa-pulu Onaa Raapu Pirape Aa-na Siri Devit-na si-daa napiralia sa. ");
INSERT INTO kew_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Go onaa rayome pa pirua Yesuna agaa pago pirisimi rabu Yesumi nipuna disaipel aanu gupa lakesa: ");
INSERT INTO kew_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Rekena agaa tisaanuna kone waru adalepape. Nimumi mamina epe yamoa maket-na pua onaanumi abi piralepape teme rabu raaname omeme. Go aanumiri Juda aanuna lotu ada-para page eta yawaeme-para page reke riri-nane aba pua pimi. ");
INSERT INTO kew_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Go aanumiri ona wasaana oyae paake no peme. Goa pua nimumi beten adaalupu yoloa teme rabu onaanu makiraeme. Goa peme-pulu orope Gote-me koso salia rabu nimuna wae yoto ora adaape mealimi sa. ");
INSERT INTO kew_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesumi adesa rabu amo ne aanumi lotu ada-para mone i pe-para mone epa lopasimi. ");
INSERT INTO kew_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Go rabu naraa piri ona wasaa meda nipuna oge mone ipa laapo epa lopasa. Go mone-re ora ogesi gupa 2 toea yaade. ");
INSERT INTO kew_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Goa pisa pare Yesumi lalo: Neme nimi lagialo. Go naraa piri ona wasaame mone lopata rabu nipumi onaa medalomana mone maoge yaawa rabuniaaya. ");
INSERT INTO kew_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Medalomamere mone adaapu imi-pulu pa ode meda mua go mone epa lopasimi pare mo ona naraamere nipuna eta kabape mone rayo epa lopasa. ");
INSERT INTO kew_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Onaa medalomame lotu ada madaa agaa lala pirisimi. Nimumi go lotu adana aana pepena-para page Gote-me oyae pa katade-para ora epe ta simi. Go rabu Yesumi lalo: ");
INSERT INTO kew_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Abia nimimi go adaleme yaenuri orope yapi di epaliade rabu go adaa lakepe rubalimi-pulu aana padanede page na-aritalia sa. ");
INSERT INTO kew_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Gore nimumi Yesu nipu agaa gupa misimi: Tisaa, nena laede yaenuri aa-rabu epalia ya? Niaame ake adalima rabu go yaena yapi di epalia mada niminaawa makuaalimaa ya simi. ");
INSERT INTO kew_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesumi lalo: Nimimi waru adalepape. Makirae aa adaapu ipua nina bina gupa lagialimi: Niri Onaa Raapu Pirape Aa-na Si yaade teme. Medalomamere go epaliade yapi di abia go epaana-daa teme. Pare nimu narata mea pulupape. ");
INSERT INTO kew_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Oropere nimimi yada pape remaa-para wae-rupa pogolasaape remaa pagalimiri paalame naoma piralepape. Go yaenu aba palia pare su yaa perekene diri go-daa dia. ");
INSERT INTO kew_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yesumi agaa meda wala gupa sa: Go raburi ruru rado radonu yada palimi. Go-rupa gavman adaa su robo rado radonu page yada palimi. ");
INSERT INTO kew_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Go raburi su rado rado-para suminini eto eto adaa paa-mama pua reae adaa paboa wae yainanu page epalia. Go raburi so yaa-parare paala piae adaapu pua wae oyae epape di page epalia. ");
INSERT INTO kew_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pare go oyae rayo abi naepalia. Dia aba nimumi nimi ripinaaba pirua wae kedaanu gialimi. Nimi mo lotu adanu ru-nane mea pua koso loa kalabus ada mapatalimi. Goa puare nimumi nina kogono onaa rabuaniaatalo palimi rabu nimiri kadipinu-para adaa aa mudunu nimuna ini agaa madaa mea palimi. ");
INSERT INTO kew_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Go rabu nimimi nina Epe Agaa laketeme-daa goa palimi. ");
INSERT INTO kew_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nimumi nimi kosona mea palimi raburi ni ake lano yapae kone aba namasatepape. ");
INSERT INTO kew_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Dia-ga neme agaa-para epe kone-para lagialua rabu nimina iaa rayome nimina agaa mada rasalimi. ");
INSERT INTO kew_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Go rabu nimina ama aapanu-para ame baaninu-para nena ruru-para adami aanu-para nimumi iaanu mea kateme. Goa pua nimumi nimi medaloma tu maomalimi. ");
INSERT INTO kew_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nimi nina agaa rateme-pulu onaa rayome nimi-para ora ratu yawo gimalimi. ");
INSERT INTO kew_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Goa palimi pare nimina aalu-para ae iri meda mada ora napudia lopalia. ");
INSERT INTO kew_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nimimi puri paloa ado piralimiri oro yaalo kagaa piraama laama palimi sa. ");
INSERT INTO kew_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Gore nimimi soldia aanu so Jerusalem su epa kuta pina adalimiri go su go adaare pabo tape yapi di go opapa yada. ");
INSERT INTO kew_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Go rabu Judia piri onaanu nimiri ora rudu-nini aana apedaa-para pogola pulupape. Onaa medaloma ada-para piralimiri pogola pulupape. Go page pa su rarane ae onaanu wala adaare-para naepa odobatepape. ");
INSERT INTO kew_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Gore Gote-na buk madaa i agaa rayore ora yalia go raburi Gote-na raturi go onaanu madaa koyaalia rabu wae yoto yapi di mea salia. ");
INSERT INTO kew_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Go raburi nogo naaki padaa piri onanu-para adu nalae-para aipapulu napalimi-ga ora odo pea. Go su madaare ora adaa kedaape meda epalia-ga Gote-me go su amaa piri onaanu madaa ora ratu waru yawalia. ");
INSERT INTO kew_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Go rabu nimumi onaa medalomanu rai kutumi tua medaloma iaanumi adi rulubaawa ruru radona rikiraana pua mapiraalimi. Go rabu page pa onaa ruru rado medame Jerusalem mabebola-mama puare orope go wae di dia yalia. ");
INSERT INTO kew_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Go raburi naare akua ubanuri rado rado aalimi. Go su amaa onaanu rayona robaa-parare adaa kedaa mu piralimi. Go ipa solwarame agaa loa ralia-daa paalame waru omalimi. ");
INSERT INTO kew_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Onaa adaapumi go su-para oyae meda ipula kone sua pu robaa-para paala waru omalimi pare ini-para page emelalu mapalia. Gore so yaa-para uba kedo oyae eto eto palia-daa paalame waru omalimi. ");
INSERT INTO kew_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Goa pinaloa Onaa Raapu Pirape Aa-na Siri yaa moae raapu ipulaina puri adaape adalimi. ");
INSERT INTO kew_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Gore orope gode yaenu ripima epalia rabu aipapulu rekoa nimina aalumi waru adalepape. Go raburi Gote-me nimina oro yaalo kagaa Pirape Yapi diri go mea epea-daa sa. ");
INSERT INTO kew_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Go rabu Yesumi nimu saa agaa meda gupa lakesa: Nimimi repena fik page pa repena medanu page adalepape. ");
INSERT INTO kew_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kagaa ma-apulu saawa yo aalia-daare gore pani pua naare ralia kone salemede. ");
INSERT INTO kew_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Gupiane yaenu adalimi-daare gore Gote-na Surube Su-na di aba re-para go epaana-daa kone salepape. ");
INSERT INTO kew_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Go agaa pagalepa: Abia go pimi onaa naomalimi pare go yaenu aba epenalo adalimi. ");
INSERT INTO kew_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Su yaa rayona yaere aba dia yalia pare nina agaa oro yaalo pa salia sa. ");
INSERT INTO kew_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Gore nimimi waru adalepape. Nimimi oro yaalo eta adaapu nayawo ipa bia noa maeyae ne aa-rupa napiralepape. Go page go su amaa yoganena yaenu madaa kone adaapu nasalepape. ");
INSERT INTO kew_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Go yapi diri nimi piri ora aipapulu epalia-ga gupa napiralepape. Go yapi di epalia rabu kona-rupa onaanu madaa perekea taboa ripinalia. ");
INSERT INTO kew_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Goa palia-pulu nimi oro yaalo ado piralepape. Goa pua Gote-me nimi puri gina ora yaalo beten tapape. Goa palimiri wae yaenumi nimi piri epalia pare nimimi puri mua Onaa Raapu Pirape Aa-na Si raapu epe-rupa mada piralimi sa. ");
INSERT INTO kew_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Oro yaalo Yesumi onaa lotu ada-para pua mogeasa. Goa pua ribaane-para nipu mo Oliv Rudu madaa patulalo puare lotu ada-para wala yapipu epala pisa. ");
INSERT INTO kew_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Goa pisa rabu onaame Yesuna agaa pagolalo ipisimi. ");
INSERT INTO kew_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Bret-para yis nasua yawo ne Pasova yapi Diri aba rudu sa. ");
INSERT INTO kew_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Gote-na miru irae aa mudunu-para rekena agaana tisaanu-para nimumi Yesu tulalo pisimi. Goa pisimi pare onaanu madaa paalame omoa kudiri pi kone su pirisimi. ");
INSERT INTO kew_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Go raburi Satan-me Judas aanuna robaa-para pua odobasa. Mo Judas aanuna bi medare Iskariot teme. Go aa nipu mo 12-pela disaipel aa ru-nane pirisa. ");
INSERT INTO kew_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Satan nipuna robaa-para odobasa-pulu Judas nipu pua Gote-na miru irae aa mudunu-para mo lotu ada surube aanu-para agaa nimu raapu pua lo pirisimi. Nipumi Yesu nimumi tinalo yada robesa. ");
INSERT INTO kew_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Go raburi nimu pedo pedo waru puare nipu kalape mone medaloma kirita su pirisimi. ");
INSERT INTO kew_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Gore Judas aanumi nimuna agaa pagoa epe ta simi. Goa puare nipuri akea pua mada mea waatoa pae kone sua kone kone adaapu mu pirisa. Nipumi rana meda onaa adaapu raapu napitimide rabu nimu waatoa kone isa. ");
INSERT INTO kew_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Olode rabu bret-para yis nasape di rudu sa raburi Pasova eta irape sipsip mena si meda tulalo pisimi. ");
INSERT INTO kew_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Go rabu Pita-para Jon lapo Yesu nipumi repaawa agaa gupa lakesa: Nipimi niaana Pasova eta namina oyae pua managola salepape sa. ");
INSERT INTO kew_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Gore nipumi agaa gupa misipi: Niaame aa-para pua managola sua namina yapae sipi. ");
INSERT INTO kew_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Gore Yesumi nipu gupa lakesa: Pagalepa. Nipimi adaare-para palipi rabu ipa norini aa meda madaalipi. Go aa nipu rata mea pulupape. Goa pua odobaliade ada-para pulupape. ");
INSERT INTO kew_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Goa puare nipimi go adana aaraa gupa laketapepe sa: Tisaa-me ne agaa meape laa: Nipuna disaipel aanu raapu Pasova eta nalima-pulu neme go eta managolape ada rum meda waalape lo pua agaa meape sa. ");
INSERT INTO kew_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Goa tepe raburi mo aame nipi adaa so madaa-nane mea pua epe pepena pi ada rum ae-para mea waatea. Go-parare reke madaa oyae managola salepape sa. ");
INSERT INTO kew_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Go agaa lakenaloa mo aa lapo pua nipumi lakesade-rupa adesipi. Go rabu nipu lapome Pasova eta managola sasipi. ");
INSERT INTO kew_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Eta nape di raburi Yesu nipuna disaipel aanu raapu reke madaa pirisa. ");
INSERT INTO kew_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Gore nipumi nimu gupa lakesa: Neme go etare nimi raapu nolalo ora raaname waru omalo. Gupa noa oropere neme kedaa pi yaenu rialua sa. ");
INSERT INTO kew_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Neme nimi lagialo: Neme eta wala meda nimi raapu nanalua pare Gote-na Surube Su rabu etana re adalimina sa. ");
INSERT INTO kew_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Go rabu nipumi kap madaa pirapalae wain mua Gote-para ora pi loa nimu-para kalalaawa lalo: Nimimi go kap-para mua rumaawa nalepa. ");
INSERT INTO kew_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Neme nimi lagialo: Abia neme nimi raapu wain ipare wala nanalua. Dia, pare Gote-na Surube Su madaa go yaena re adoa nalua sa. ");
INSERT INTO kew_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Goa puare nipumi bret mua Gote-para ora pi loa piribisa. Goa pua nimu kalalaawa lalo: Go bret-re nina yogane-ga nimi raba minalo gialo. Nimimi ni madaa kone sua nalepape sa. ");
INSERT INTO kew_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Goa puare orope aba no kiritinaloa ipa wain pirapalae mua kalalaawa lalo: Go kap-para piri wain-ri nina yaapi kupame nimi raba minalo koyaato. Gore Gote raapu pogatu pirapena nimi madaa omalua sa. ");
INSERT INTO kew_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Yapare adalepa. Ni yada lore aanu mea kalape aare abia ni raapu go reke madaa padane-para eta go no piralepa-daa sa. ");
INSERT INTO kew_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Onaa Raapu Pirape Aa-na Siri Gote-na agaa ratua omalua sa. Goa pea pare mo ni iaanuna ki-nane mea kateade aare ora kedaa waru mealia-daa odome omalo sa. ");
INSERT INTO kew_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nipumi goa sa raburi nimumi aapimi palia yapae lala pisimi. ");
INSERT INTO kew_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Disaipel aanumi arere pua nimuna rikiraanare aa muduri aapi ora yapae simi. ");
INSERT INTO kew_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Gore Yesumi nimu gupa lakesa: Ruru radona aa mudunu nimumi puri paloa nimuna ruru onaanu surubeme. Goa puare mo surube onaanumi bi onaanuna raba mi aanu lo bi ma-aeme. ");
INSERT INTO kew_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pare nimi gupa napiralepape. Dia-ga aa meda nimina rikiraana aa mudu aba piralia-daare gore nipu pora poa madini aa-rupa aba piralia. Nimina mudu pirape aare aba kogono pua nimina raba mi aa-rupa piralia. ");
INSERT INTO kew_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Gore aa medame eta pa nolalo piruaaya pare aa medame kogono pua eta rumaaya. Gore mo eta aba nolalo pia aare nipu aa mudu yana. Pare ni nimina rikiraana piruaayo rabu nimi raba muaayo. ");
INSERT INTO kew_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Neme kedaa ruaayo rabu nimi ni raapu pirua nagimisimide. ");
INSERT INTO kew_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Gore neme su rayo surubanolo Aapame nipuna puri gisa. Goa pea-ga neme page nimi surube kogono gialua. ");
INSERT INTO kew_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Gore nina Surube Su-para pirua nimi naa reke madaa pirua eta namina. Goa pua nimi epe reke madaa pirua Israel su-para piri ruru 12-pela onaana koso agaa pagolalo piralimi. ");
INSERT INTO kew_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ora Saimon, neme pagape. Gore wit poape aamere nipuna etare epe ta palo o ta palo eta waru adalia. Go-rupare neme puri kasu-pulu Satan-me nimi ko tulalo epalia. ");
INSERT INTO kew_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Yapare Saimon neme kone rulae yae nagimainalo neme ne raba mulalo beten to. Orope neme ni madaa kone wala pereke sua nena amenu puri kalape sa. ");
INSERT INTO kew_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Gore Pita-me goa sa: Aa Mudu, niri ne raapu abia banalo kalabus ada-para page ni ne raapu mada omalua kone salo sa. ");
INSERT INTO kew_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Gore Yesumi lalo: Pita ne lagialo. Abia go ribaare yaa kutame e talo palia rabu neme Yesu ni na-ade rana repo te sa. ");
INSERT INTO kew_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Go rabu Yesumi nimu gupa lakesa: Nimiri abade mea rapasude raburi nimina mone paus-para rokanu-para aariti go yaenu namea pisimide. Goa pisimide-ga nimi oyae meda rudu sa pae? Gore nimumi lalo: Niaa muaema simi. ");
INSERT INTO kew_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Gore nimu gupa lakesa: Abiare onaa rayome mone paus-para rokanu-para saapitimiri mea pulupape. Onaa rayome nipu adaalu rai kutu nasalimiri nimina mamina madaa mone mua rai kutu kabalepape. ");
INSERT INTO kew_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Gore nimi lagialo: Gote-na buk madaa ni-para gupa sa: Nipu onaa waenu raapu page mapiraaeme lo tisana. Go agaana re-re orope ni madaa epalia-ga adalimina sa. ");
INSERT INTO kew_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Go rabu disaipel aanumi lalo: Aa Mudu, neme ade. Niaame adaalu rai kutu laapo go saapima simi. Gore nipumi lalo: Apo saapimi mada sa. ");
INSERT INTO kew_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nipu amaa pua sana nipuna oro yaalo puala pia-rupa Oliv Rudu madaa pua pisa. Go rabu nipuna disaipel aanumiri nipu raapu pisimi. ");
INSERT INTO kew_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Mo Oliv Ruduna puare nipuna disaipel aanu gupa lakesa: Wae yaeme nimi nako tina beten tapape sa. ");
INSERT INTO kew_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Goa loare nimu gimoa ogesi-daa puare rumu koba pua beten sa. Nipu pisade-rupare aana mea lopatema-rupa mada pisa. ");
INSERT INTO kew_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Go rabu nipumi lalo: Aapa, neme kone saliri ni radaa nape pe kap mea pu. Yapare nina kone gimoa nena raana ratano lape. ");
INSERT INTO kew_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Go rabu yaa-para piri ensel meda nipu piri-para ipua nipu epa puri mapalaasa. ");
INSERT INTO kew_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesu nipu madaa kedaa adaape rinalo pisa-pulu nipumi beten puri paboa wala sa. Goa puare nipuna pudu ekatare yaapi kupa nona piane kilipia su amaa popesa. ");
INSERT INTO kew_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nipumi beten aba loa sana rekaawa nipuna disaipel aanu piri-para pisa. Nipumi pua adesa pare nimuna robaa-para kedaa waru pisa-daa u patisimi. ");
INSERT INTO kew_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Gore nimu gupa pua lakesa: Nimiri akeane u patu pimi? Nimi madaa wae yaeme nako tinalo beten lo piralepape sa. ");
INSERT INTO kew_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu nipumi agaa pa lakelalaina onaanu adaapupe meda ipisimi. Gore Judas riri-nane epena onaanu nipu rata mea ipisimi. Go aare disaipel aanuna ru-para pirisa. Nipu re-para ipua Yesu-para nunu talo ipisa. ");
INSERT INTO kew_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Goa pisa pare Yesumi Judas gupa lakesa: Neme Onaa Raapu Pirape Aa-na Si nunu loa mea waaloa yada lore aanu katalo pae? ");
INSERT INTO kew_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Gore disaipel aanu nipu raapu pirisimi aanu mo ipisimide adoa nimumi lalo: Aa Mudu, niaame nimuri go adaalu rai kutumi tamona ya? ");
INSERT INTO kew_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Go rabu disaipel aa medame kogonome adini naaki meda rai kutumi tisa. Go naakiri Gote-na miru irae aa-na kogono pisa. Tisa rabu mo popo ki-nane aane pona taboa lopesa. ");
INSERT INTO kew_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Goa pisa pare Yesu nipumi goa adoa lalo: Go yada gimalepa. Nipuna kimi mua mo aane wala mea maasa. ");
INSERT INTO kew_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Goa puare mo aanumi Yesu ripinaatalo ipisimi. Gore Gote-na miru irae aa mudunu-para lotu ada surube surube aanu-para aa mudu medalomanu-para ipisimi. Ipisimi rabu nipumi lalo: Nimina rai kutunu-para repena uninu mea epamena-ga gore nimimi ni paake ne aa kone sua tulalo epame pae? ");
INSERT INTO kew_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Oro yaalo niri nimi raapu lotu ada-para pimade pare nimimi ni talima kone naimide. Goa pemede pare abia go yapi di raburi ora nimina puri-para ribaana purimi rabuaata sa. ");
INSERT INTO kew_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Goa puare nimumi Yesu epa adia Gote-na miru irae aa muduna ada-para mea pisimi. Goa pisimi raburi Pita nipumi nimu rata mea pisa pare nipu ogesi-daa mo-pare pua pirisa. ");
INSERT INTO kew_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Go rabu aa medalomame epe pokaalo ada ru-nane repena adala pirisimi-pulu Pita nipu page nimu raapu pua pirisa. ");
INSERT INTO kew_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Gore kogono ona medame Pita repena re-para pirina adesa rabu go oname Pita nipu-para goa sa: Go aa page abade Yesu raapu pirisa sa. ");
INSERT INTO kew_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pare Pita-me lalo: Go ona ni-daa dia-ga go aa-daa ni na-ade sa. ");
INSERT INTO kew_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Pare wala ogesi-daa pirua aa medame wala nipu adoa lalo: Ne page Yesu raapu piriside sa. Gore Pita nipumi lalo: Go aa ni-daa ora dia sa. ");
INSERT INTO kew_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Orope ogesi-daa adaalupu pirua aa medame agaa ora puri paloa gupa sa: Go aa nipuna adaare Galili ya-pulu nipu abade Yesu raapu pirisa. ");
INSERT INTO kew_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Goa sa pare Pita-me lalo: Nemere go lae aa ora ni na-ade sa. Nipumi goa pa lalaina yaa kutame aba aipapulu rekoa agaa sa. ");
INSERT INTO kew_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Go rabu Aa Mudumi pereke tua Pita ada moneasa. Goa pisa rabu Pita-me Aa Mudumi abade nipu-para lakalaade agaa wala niminaasa. Aba Yesumi gupa lakesade: Go rabu yaa kuta abia rekoa agaa tea pare neme ni rana repo gimali lakesade. ");
INSERT INTO kew_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Go raburi Pita nipu so amaa-nane pua re puri palo lala pirisa. ");
INSERT INTO kew_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Go rabu Yesu surube aanu nimumi nipu epa ripinaabawa ero agaa loa nipu tisimi. ");
INSERT INTO kew_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nipuna ini mamina-me rigitua nipu agaa gupa misimi: Nere aapimi tala paa simi. Nere Gote-na agaa lakene aa-ga agaa la simi. ");
INSERT INTO kew_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Goa puare nimumi ero agaa rado rado lakesimi. ");
INSERT INTO kew_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Orope yapi lapaasa raburi Israel onaana aa mudunu-para Gote-na miru irae aanu-para mo rekena agaa tisaanu page epa kiritasimi. Goa puare Yesu nipu kaunsil piri mea pua agaa gupa misimi: ");
INSERT INTO kew_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Nere Onaa Wala Meape Aa-na Si yapae dia pae simi. Gore nipumi nimu lakesa: Gore mada lagialua pare nimimi ni kone narulalimi. ");
INSERT INTO kew_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Go page neme nimi agaa medaloma mealuare nimimi agaa mada na-abuteme. ");
INSERT INTO kew_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Abia page orope page ni Onaa Raapu Pirape Aa-na Siri so yaa-para puri pane Gote-na popoke ki madaa oro yaalo pitua sa. ");
INSERT INTO kew_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Go raburi nimu rayome lalo: Gore nere ora Gote-na Si yapae simi. Nipumi nimu goa lakesa: Nimina bipa go tame yaade sa. ");
INSERT INTO kew_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Gore nimumi lalo: Niaame ake wala tema ya? Niaame nipuna agaa go pagalema-pulu pa adasae aanuna agaa medaloma gimalima simi. ");
INSERT INTO kew_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Go rabu kaunsil rayo aipapulu rekoa Yesu aa mudu Pailat piri mea pisimi. ");
INSERT INTO kew_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Goa puare nimumi koso gupa laa simi: Go aamere niaana kone rado mogea Sisar-para mone takis nakatapape laa simi. Go page niri ora aa mudu Krais ta simi. ");
INSERT INTO kew_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Go rabu Pailat-me nipu agaa misa: Nere Juda onaanuna Aa Mudu yapae sa. Yesumi lalo: Nena go lae-daa sa. ");
INSERT INTO kew_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Go rabu Pailat-me Gote-na miru irae aa mudunu-para onaa rayo-para gupa lakesa: Neme apo aa-na wae kone meda penaame na-adalo-ga akolo wae yoto katoa pae sa. ");
INSERT INTO kew_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Goa sa pare nimumi agaa puri paloa gupa simi: Nipumi onaanu-para agaa mogeaaya rabu nimu wae-rupa pogolasaasimi. Go kogonore pa amaa pua Galili su-para pua Judia su-para pua abia go su-para page epa pia simi. ");
INSERT INTO kew_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailat-me go agaa pagoa nipumi agaa gupa sa: Go aa nipuna suri Galili ya? ");
INSERT INTO kew_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Gore nimumi e simi-pulu Pailat-me Yesu Herot piri-para mea penaasa. Gore Herot-mere Yesu madini su surubesa-pulu goa pisa. Go rabu Herot nipu page Jerusalem-para pirisa. ");
INSERT INTO kew_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herot-me Yesu adoa raaname waru omesa. Yesu madaa remaa abade pagesa-pulu nipumi Yesu adolalo pisa. Herot nipuna konere Yesumi napiaa kogono palia rabu adalua kone isa. ");
INSERT INTO kew_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Go rabu Herot nipumi Yesu nipu agaa rado rado misa pare Yesu nipumi agaa meda na-abusa. ");
INSERT INTO kew_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Go rabu Gote-na miru irae aa mudunu-para rekena agaana tisaanu-para nimumi rekaawa Yesu madaa puri pane koso agaa lo pisimi. ");
INSERT INTO kew_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Go rabu Herot-para nipuna soldia aanumi Yesu-para makiraawa ero agaa waru simi. Nimumi ora pepena epe-rupa pi adaalu mamina meda mua Yesu madaa yamasimi. Goa pua Pailat piri lamua pisimi. ");
INSERT INTO kew_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Abadere Herot nipumi Pailat raapu iaa-rupa pirisa pare wala go rabu kone padane sua adami aa-rupa wala pirisipi. ");
INSERT INTO kew_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Go rabu Pailat-me Gote-na miru irae aa mudunu-para Juda aanuna aa mudu medalomanu-para onaa rayo page yaaloa makiritasa. ");
INSERT INTO kew_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Go rabu nimu gupa lakesa: Nimimi abade go aa ni piri lamua epame yaade. Nipumi wae pora rado onaanu mea waata lamede. Go agaa madaare nimina ini agaa madaa nipu apo agaa meawade pare nimimi mo nipu koso laatalo pimi pare go aa nipumiri go waea meda napana kone salo sa. ");
INSERT INTO kew_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herot-me page go aa-na waea meda na-adesa. Pare na-adea-ga wala niaa piri-para go epenalana. Pagalepa. Go aamere abade nipumi waea meda napana-daa niaame nipu madaa natu maomalimina. ");
INSERT INTO kew_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Goa pea-ga neme repena unimi nipu mea kudu tuare nipu mea repaano sa. ");
INSERT INTO kew_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Gore oro yaalo eta yawe nape Pasova yapi di rabu Pailat-me kalabus ada piri aa padane maesepeaata pisa. ");
INSERT INTO kew_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Go rabu mo piri onaa rayome puri paloa gupa yaasimi: Apo aare tu maomamina. Go aa Jisas Barabas-re niaana wala esepea epenala simi. ");
INSERT INTO kew_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Jisas Barabas-me abade go adaare-para yada meda marekaawa aa meda tu maomaa nipu kalabus ada-para mapataasimi aa-para simi. ");
INSERT INTO kew_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Gore Pailat-me Yesu wala maesepeaatalo kone sua onaanu-para agaa wala yaasa. ");
INSERT INTO kew_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Goa pisa pare nimumi ora puri paloa gupa simi: Repena polopea madaa mea taminapa. Repena polopea madaa tamin aapa simi. ");
INSERT INTO kew_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Goa simi pare Pailat-me wala rana repo gupa lakesa: Go aamere nipuna wae yae meda ake pana? Neme wae yae meda ora na-adawade. Goa pea-pulu neme repena unimi mea tua esepealua sa. ");
INSERT INTO kew_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Goa sa pare nimumi ora puri paloa Yesu repena polopea madaa tu maomamina simi. Goa pua nimumi Pailat-na agaa rabuaniaasimi. ");
INSERT INTO kew_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Goa pua Pailat-me Yesu talepa loa nimuna agaa ratisa. ");
INSERT INTO kew_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nimuna wae aa Barabas mea esepeasa. Go aamere aba onaa wae-rupa mapogolasaawa aa meda tu maomasa rabu nipu kalabus ada-para mapataasimi. Goa pisa pare mo onaanumi go aa wala esepea lo simi rabu nimuna agaa pagoa Pailat-me Yesu nimuna pinalo mea kasa. ");
INSERT INTO kew_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nimumi Yesu nipu mea pisimi rabu pa aa meda madaasimi. Go aa-na biri Saimon nipuna su Sairini gimoa ipua no adaare-para polalo pisa. Go rabu nimumi repena polopea nipuna pasaane mariaasimi. Nipumi mea ruare Yesuna masaa-nane rata mea pisa. ");
INSERT INTO kew_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Goa puare ora onaa adaapumi Yesu rata mea pisimi. Nimuna rikiraanare ona medalomame re loa yaasa odo pi laa-mama pisimi. ");
INSERT INTO kew_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pare Yesu nipumi wala pereke tua nimu gupa lakesa: Nimiri Jerusalem onanu-ya. Ni madaa re natapape pare nimi madaa page nimina nogo naaki madaa re lo piralapape sa. ");
INSERT INTO kew_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Pagalepa. Orope kedaa meape di epalia rabu nogo naaki namadua adu nakane onanuri aipapulu mada pogola palimiri ora epe ta teme sa. ");
INSERT INTO kew_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Go di raburi onaanumi mo rudunu-para gupa laketeme: Niaana masaa-nane lopoa niaa tu maomape teme. Gore wala oge rudunu-para gupa laketeme: Niaa makaledaape teme. ");
INSERT INTO kew_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Abiare ora pani pia-daa go kedaa pia peme-ga orope wae yai epalia rabu ake kedaa ora omalimi ya? ");
INSERT INTO kew_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Go rabu nimumi pupitagi ne aa lapo page lamua pua Yesu raapu nil tulalo pisimi. ");
INSERT INTO kew_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nimu pua su meda Aalu Rogaae su temede go-para pua aasimi. Go-para Yesu repena polopea madaa nil tisimi. Mo wae aa laapo page nil-mi tua medare Yesuna popo ki-nane tua medare koya-nane tisimi. ");
INSERT INTO kew_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Gore Yesumi lalo: Aapa, nimumi kone nasua pimi-ga nimuna wae yae mea rakepeape sa. Go pimi aare nimumi go yaena re na-adoa pimi sa. Go rabu go aanu nimumi Yesu nipuna mamina koyo mua satu tu pirisimi. ");
INSERT INTO kew_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Go rabu pa onaanumi pa rekaawa adapaba pirisimi. Goa pisimi pare mo Juda aa mudunumi Yesu-para ero gupa simi: Nipumi abade onaa medaloma raba meaaria-ga nipuna bipa nipu raba mea simi. Gore Gote-me nipu Mea Rapae Aa ya-pulu mada palia simi. ");
INSERT INTO kew_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldia aanumi page nipu-para ero agaa simi. Nimumi Yesu re-para ipua rero pi ipa wain epa katalo pisimi. ");
INSERT INTO kew_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Gore nimumi gupa simi: Nere ora Juda aanuna aa mudu yalia-daare gore nena bipa raba mua no suna ipu simi. ");
INSERT INTO kew_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Pepa meda so repena polopea rugi madaa tu saabaasimi: Go aare Juda aanuna Aa Mudu yaade lo simi. ");
INSERT INTO kew_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mo aa wae lapo abade tu mudiasimide medame Yesu-para ero agaa gupa sa: Ni Onaa Raapu Pirape Aa-na Si laede-ga neme saa page raba mea sa. ");
INSERT INTO kew_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Go rabu mode mudiasimide aa medame aa-para gupa ape sa: Niaame kedaa padane-rupa meamade-ga nere Gote paala napea pae sa. ");
INSERT INTO kew_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Saana kedaare saana papade aena ora mada gialeme. Pare abia go aare nipumi abade waea meda napisa sa. ");
INSERT INTO kew_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Goa pua nipumi Yesu-para lalo: Yesu nere aa mudu pirali raburi ni madaa kone saina sa. ");
INSERT INTO kew_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Gore Yesu nipumi nipu gupa lakesa: Neme ora ne lagialo. Abiare nere ni raapu so Gote-na epe maapu-para pirapana sa. ");
INSERT INTO kew_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Go naare paalu rabu naare udunua ribaa yoa su rayo rigitaama pua naare nogo-nane pabola popesa. ");
INSERT INTO kew_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Goa pisa raburi mo lotu ada ru-nane mudiabae adaa mamina so rugi-nane riripitaboa none rugi-nane pua riripi kiritisa. ");
INSERT INTO kew_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu nipumi puri paloa gupa sa: Aapa, nina wasupare nena ki-nane apo salo-daa sa. Nipumi goa sa rabu pu imu udunasa. ");
INSERT INTO kew_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Mo soldia aanuna aa mudumi go adesa-pulu nipumi Gote-na bi minasaawa lalo: ora yaana go aare ora epe aa yana sa. ");
INSERT INTO kew_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Onaa adaapumi nipu pia adolalo epa ado pirisimi pare nimuna aako rupitua ada wala pisimi. ");
INSERT INTO kew_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yesuna adami aanu rayo-para onanu medaloma aba so Galili su-para pirua Yesu nipu rata mea ipisimi. Nimu ogesi-daa mo-para rekaawa mo oyae rayo ado kiritisimi. ");
INSERT INTO kew_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Aa meda nipuna biri Josep pirisa. Nipuri Juda aanuna adaare meda biri Arimatea su-para pirua nipu ora epe aa pirua Gote-na Surube Su epenalo adolalo pirisa. Gore nipumi kaunsil raapu pirisa pare Yesu tu maomamina simi rabu nipumi dia sa. ");
INSERT INTO kew_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Go aa nipu Pailat piri pua Yesuna rore nina mea ria pono sa. ");
INSERT INTO kew_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Goa pua nipuna ro mea ruare mamina yaako pimi rogaa palae mea pisa. Goa pua nipu aana apedaa meda-para pua rogaasa. Go-parare abade aa meda abi narogaasimi. ");
INSERT INTO kew_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Go yapi diri Kitu Pirape Yapi rudu sa-pulu go adaa oro rabu nape etanu maredepo yaasimi. ");
INSERT INTO kew_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Onaanu abade Yesu nipu Galili su gimisa rabu nimumi nipu rata mea ipisimi. Nimumi Josep raapu pua mo aana apedaa matmat-para Josep-me rogaasa-rupa adesimi. ");
INSERT INTO kew_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Goa pua nimumi adoa nimuna ada wala pua epe kaa pi yaenu Yesuna ro madaa sainalo managolata pisimi. ");
INSERT INTO kew_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Gore adaa oro rabu kogono mupaa yapi di rabu mo onaanu matmat-para pisimi. Nimumi mode kaa pide yaenu-para aba managola sua mea madisimi. ");
INSERT INTO kew_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Matmat-para ipisimi rabu mode pora gaape aana aba mea lusu rubenaloa adesimi. ");
INSERT INTO kew_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Goa pua nimumi no matmat apedaa-para pua adesimi pare Aa Mudu Yesu nipuna rode nasabasaaya. ");
INSERT INTO kew_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Goa pua nimu pa rekaawa kone adaapu su pirisimi rabu aa lapo nimu re-para aipapulu opapasipi. Go aa lapore nipuna mamina-nu ora yaako pu ti maraasipi. ");
INSERT INTO kew_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Onanu nimuri paalame omoa su adaniaawa pirina aa lapome nimu gupa lakesipi: Nimimiri akeane matmat-para go aa asapeme pae? Go aa ora pa pia-pulu go-para mada na-adalimi sipi. ");
INSERT INTO kew_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nipuri go-paradaa napia nipu aba rekaade. Abade nipu so Galili su-para pa pirua nimi lagisade agaa wala niminaatepa. Aba gupa lagisa: ");
INSERT INTO kew_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Onaana Si Mea Rapae Aare wae onaanuna ki madaa mea kateme rabu nipu repena polopea madaa tu maomalimi. Goa pea pare wala yapi repo dia naloa wala rekalua lo lagisade sipi. ");
INSERT INTO kew_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Go rabu onanumi Yesu nipuna abade lakesade agaa niminaasimi. ");
INSERT INTO kew_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Go rabu nimumi mo matmat apedaa gimoa wala pisimi. Go rabu nimumi pa onaa medaloma-para disaipel aa 11-pela rayo piri-para pua mo nimumi adesimi yaenu rayo pua lakesimi. ");
INSERT INTO kew_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Matmat-para pua adesimide onanuna biri gupa: Maria nipuna su Magadala-para Jon-para Jems-na agi Maria-para go onanu nimumi go yae adesimi. Go onanu-para pa ona medaloma-para mo agaare moge riaae aanu lakesimi. ");
INSERT INTO kew_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Lakesimi pare aposel kogono aanumi mo onanu pa amaa po ripu agaa pa tame kone isimi-pulu nimuna agaa madaa kone narulasimi. ");
INSERT INTO kew_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pare Pita nipu rekoa matmat-para wala aloma adola pisa. Nipumi no aana apedaa matmat-para pua adaniaawa mamina padane adesa. Nipu wala ada pua kone adaapu sua gore ake pana pae kone isa. ");
INSERT INTO kew_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Go raburi mo disaipel aanu ipa laapo Emeus su-para polalo pisipi. Nipu Jerusalem su gimoa Emeasa pora-nia ogesi-daa adaalu pu pisipi. ");
INSERT INTO kew_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nipu go pora-nia pulaaware mo abade adesipide remaa la-mama pisipi. ");
INSERT INTO kew_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nipu laapome agaa la-mama pula pirina Yesu nipu ipua nipu raapu pisimi. ");
INSERT INTO kew_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Go nipu laapome nipu adesipi pare ora Yesu-rupa naniminaasipi. ");
INSERT INTO kew_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Go rabu Yesumi nipu lapo lakesa: Nipimiri ake laa-mama pula pipi? Nipumi goa sa rabu nipu laapo pa rekabaawa nipuna kone pu robaa-para kedaa pua ini agaa-para odo pina aasipi. ");
INSERT INTO kew_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Go aa meda nipuna biri Kliopas go aame agaa gupa misa: Jerusalem su-para pamede aanu-para lapade pare onaanu-para kimisu onaanu-para nimumi ademe-ga ne padane-mare abade gona remaa napage aa-para pirua lae pae? ");
INSERT INTO kew_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesu nipumi nipu agaa gupa misa: Ake-para tape pae? Nipumi nipu gupa lakesipi: Nasaret Yesuna remaa-para lapade. Go aare ora Gote-na agaa lakene aa pirua Gote-na ini agaa-para ona rayona ini agaa-para ora puri pane agaa madaa kogono laapo pea. ");
INSERT INTO kew_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pare niaana miru irae aa mudunu-para niaana aa mudu medalomanu-parame kaunsil mea kalamede sipi. Gore nimumi nipu tu maomatepape lakenaloa nipu repena polopea madaa tamede sipi. ");
INSERT INTO kew_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Gore abade niaame go aamere Israel onaanu niaa wala minalo mea rapae aa kone sama. Gonu rayo pame raburi abiare yapi repo aba go popaade. ");
INSERT INTO kew_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Abiare niaana ruru ona medalomame niaa mapogolasaarimi. Ora abade yapipu nimu matmat aana apedaa-para adola puame ya. ");
INSERT INTO kew_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Pare Yesu nipuna ro na-adame ya. Goa pua nimu wala ipua niaame ensel medaloma adama lo lagiame. Gore ensel-numi Yesuri aba rekoa epe-rupa pia lo lagiame lame. ");
INSERT INTO kew_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Niaana ruru aa medalomame matmat-para pua mo onanumi epa lagiamede-rupa pua adame pare nipu na-adameya sipi. ");
INSERT INTO kew_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Go rabu Yesumi nipu gupa lakesa: Gore nipiri kone nasua tepe. Nipina robaa-parare mo Gote-na agaa lakene aanumi lagisimide remaa madaa kone ora ogepusi rulaaripina. ");
INSERT INTO kew_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nipi naniminaaepe? Gote-na onaanu wala minalo Mea Repae Aame aba ripia radaa noa epe paana puri mealialo napagapena? ");
INSERT INTO kew_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Gore Yesumi Moses-na agaa madaa mea ripimaawa Gote-na agaa lakene aanuna remaa rayo lakeloa Gote-na buk madaa i agaame nipu madaa ta-rupa go rayo lakesa. ");
INSERT INTO kew_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nimu agaa laa-mama pua mo aa lapo nipuna polalo pisipi adaare re-para opapasimi. Go rabu Yesu nipuna raaname ogesi-daa adaalu pu pisa. ");
INSERT INTO kew_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Goa pua mo aa lapome nipu-para lalo: Adoaa. Ogesi-daa pa piramina. Naare pabola pea-ga nere saa raapu piramina sipi. Go rabu nipu ada ru-nane pua nipu raapu padane-para pirisimi. ");
INSERT INTO kew_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Gore eta nolalore Yesu nipu raapu reke madaa pirisipi. Go rabu nipumi bret mua Gote-para ora pi loa piribia mo aa laapo kasa. ");
INSERT INTO kew_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nipumi goa pisa rabu nipu lapome ini rupaawa robaa-para paa ipisa rabu waru adesipi. Goa pisipi pare go rabu Yesu pa aipapulu pisa-pulu wala na-adesipi. ");
INSERT INTO kew_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Gore go aa lapome lalo: Saa aba pora-nia epapade rabu nipumi saa Gote-na agaa mogeaaria-daa saana pu robaa-para rekatabea sipi. ");
INSERT INTO kew_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nipu lapome goa loare aipapulu rekoa wala Jerusalem su-para pisipi. Nipumi mo aposel kogono aa 11-pela page pa adami aa medaloma page nimu kiritaba pirina adesipi. ");
INSERT INTO kew_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Gore mo aanumi nipu gupa lakesimi: Aa Mudu ora rekaa yaade simi. Saimon-me nipu ora adaa yaade sipi. ");
INSERT INTO kew_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Go raburi go aa lapome mo onaanu-para mo pora-nia pisade remaa lakesipi. Goa pua Aa Mudu nipumi bret mea piribiaawa niaa gia rabu saame waru ada pa sipi. ");
INSERT INTO kew_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nimumi go agaa lala pirina Yesu aipapulu nimuna rikiraana epa rekasa. Go rabu nipumi nimu-para lalo: Nimina robaa-para epe kuma pi kone su piralepa sa. ");
INSERT INTO kew_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pare nimumi remo meda kone isimi-pulu nimumi paalame omesimi. ");
INSERT INTO kew_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Gore nipumi nimu gupa lakesa: Nimiri akeane pogolasaarimi ya? Nimina robaa-para kone adaapuri akeane saleme pae? ");
INSERT INTO kew_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Gore ora ni yaade-ga nina ki aanu adalepa. Nimina kimi naa yogane uni lapo-para oraatepa. Remore gupa-daa dia yaade sa. ");
INSERT INTO kew_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nipumi goa loare nipuna ki aa lapo nimumi adenalo mea waasa. ");
INSERT INTO kew_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nimumi pedo ora waru pua kone adaapu isimi-pulu nimumi kone narulasimi. Go raburi nipumi nimu agaa misa: Nimiri eta medaloma saapimi pae sa. ");
INSERT INTO kew_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Nimumi aba irabae ena piribini mea kasimi. ");
INSERT INTO kew_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Gore nimumi adabaina nipumi mua nisa. ");
INSERT INTO kew_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nipumi nimu goa lakesa: Abade ni nimi raapu pa pirisude rabu nimi go yae madaa aba lagisude. Gore mo Moses-na rekena agaame page Gote-na agaa lakene aanumi page buk Sam-para page ni madaa loa tisimi yaade. Go remaana re ora adalimina lagiawade sa. ");
INSERT INTO kew_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Go rabu nipumi nimuna robaa-para paa maepasa-pulu nimumi mo Gote-na agaa waru adesimi. ");
INSERT INTO kew_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Go rabu nipumi Gote-me onaanu wala minalo Mea Repae aamere kedaa adaa meda rua matmat-para pirua yapi repo dia naloa ome su gimoa rekalialo i yaade sa. ");
INSERT INTO kew_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Nipuna bina purimi su rayona piri onaanumi kone perekeaminalo agaa lakelatepape sa. Goa puare Gote-me onaanuna wae yae mea rubalia-ga agaa laketepape sa. Go kogonore so Jerusalem-para ripima pua su rayona pinalo lakelatepa. ");
INSERT INTO kew_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Yesumi apo agaa lo kiritua nimu-para wala lalo: Nimimi go adalemade yaenu madaa remaa laketapape. ");
INSERT INTO kew_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Abade Gote-me puri gialua lo lagisa-pulu neme ora mea repaalua. Pare nimimi so yaa-para i puri nimi madaa epenalo Jerusalem siti-para adoaatepape sa. ");
INSERT INTO kew_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Go rabu nimu go adaare gimoa Betani su-para lamua pisa. Go-parare nipuna ki minasaawa nimu-para epe puri minalo agaa lakesa. ");
INSERT INTO kew_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nimu-para lakelaama pua nimu piri-para gimisa. Goa pua Gote-me nipu yaa-para mea pisa. ");
INSERT INTO kew_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Gore nimumi nipuna bi minasaawa Jerusalem su-para wala pisimi. Pisimi rabu pedo waru pua raaname omoa pisimi. ");
INSERT INTO kew_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Goa puare oro yaalo nimu lotu ada-para pirua Gote-para ora pi lo pirisimi. ");
INSERT INTO kew_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Abade su yaa lapo nawarini rabu Gote-na Agaa aba pirisa. Go Agaare nipuna bipa nipu Gote-rupa pirisa. ");
INSERT INTO kew_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Aba ripiare go Agaa nipu Gote raapu pirisipi. ");
INSERT INTO kew_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Gote-me oyaeyae rayo go Agaame warisa-pulu wariape yae meda pa-rupa naopapasa. ");
INSERT INTO kew_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Go pirisa Agaare nipuna kagaa piraama laama pope kone isa-pulu nipumi go kone su amaa mea ipua onaanuna robaa-para paa mea kasa. ");
INSERT INTO kew_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Go paare ora ribaane-para roasa-pulu ribaana wae yaenumi go paa namaudunaaya. ");
INSERT INTO kew_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Gote-me aa medana bi Jon temenalo mea rapaasa. ");
INSERT INTO kew_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Go aamere go epe paa madaa agaa laketalo ipisa. Laketalo ipisa pare onaanumi go agaa pagoa Yesu madaa kone rulaminalo ipisa. ");
INSERT INTO kew_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Go aare nipu go paa meape aa-daa dia yapare nipumi mo paa madaa agaa laketalo ipisa. ");
INSERT INTO kew_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ora go epe paare su amaa madisa rabu onaa rayona robaa-para makuaa adenalo paa katalo ipisa. ");
INSERT INTO kew_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Go Agaare su amaa ipisa. Gote-me warisa yaere go Agaame warisa. Nipu epa Agaa pirisa pare onaanumi go Agaa waru na-adesimi. ");
INSERT INTO kew_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Go Agaare nipuna adaare-para epa pirisa pare nipuna onaanumi nipuna agaa gimoa napagesimi. ");
INSERT INTO kew_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Go rabu onaa medalomame nipuna pora kurua nipu madaa kone rulaeme. Goa peme-pulu Gote-me nimu ora nipuna nogo naaki-rupa mapiraaya. ");
INSERT INTO kew_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nimu Gote-na nogo naaki-rupa piruaeme agi aaraa lapome madini nogo naaki napiruaeme. Dia, nimuna aaraare Gote padaneme madisa-pulu rado-rupa piruaeme. ");
INSERT INTO kew_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Go Agaare nipu yogane maawa sana aa-rupa piruare niaana rikiraana epa pirisa. Nipuri nipuna Aapana Si padane ya-pulu Aaraana puri paa mu pirina adema. Niaana rikiraana pirisa rabu ora agaa-para raba meape kone page nipuna robaa-para rulatabesa. ");
INSERT INTO kew_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon-me nipu madaa gupa lakesa: Go aa madaare neme abade agaa gupa sude: Nipuri nina masaa-nane epalia pare nipuna purimi ni maoge yaalia. Nipu aa mudu piralia pare ni abi namadini raburi nipu aba pa pirisa lagesude. ");
INSERT INTO kew_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nipuna epe raba meape kone-para titame omea-para rulatabena nipumi niaa padane padane laatapu epe raba meapa kone page titame omea page gisa. ");
INSERT INTO kew_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Gore Gote-me rekena agaa kasa rabu Moses-me mea ipisa. Goa pisa pare epe kone-para ora agaa-parare Yesu Krais-me mea ipisa. ");
INSERT INTO kew_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Aa medame Gote ora na-ademe. Ora dia. Mo nipuna naaki nipu padane Gote raapu medaa-rupa pipi. Go naakimi nipuna Aapana agaa niaa piri-para mea ipua waata. ");
INSERT INTO kew_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalem su-para piri Juda aanumi Gote-na miru irae aanu-para Livai aa-para nimu rayo Jon piri-para mea repaasimi. Goa pua nimumi Jon agaa gupa misimi: Nere aapi ya? ");
INSERT INTO kew_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Go rabu Jon-me agaana kudiri pi redepo ne agaa gupa lakesa: Niri Krais-daa dia sa. ");
INSERT INTO kew_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Go rabu nimumi lalo: Gore nere Krais-daa dia yaana-ga nere Elaija yapae simi. Dia sa. Gore ne Gote-na agaa lakene aa ya? Dia sa. ");
INSERT INTO kew_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Go rabu nimumi wala lapopa Jon-para lalo: Gore nere aapi yapae simi. Niaame mo niaa mea repaarimi aanu-para agaa waru ipua laketema-pulu ne-parare niaame ake teme ya? ");
INSERT INTO kew_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Go rabu Jon-me Aisaia-na agaa mogeawa lakesa: Niri gupa pulalo pi: Neme onaa napiri su-para agaame yalano: Aa Mudu-na pamuape pora maredepo yaatapape to sa. ");
INSERT INTO kew_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Go agaa mulalo pisimi aanuri Farisi aanuna rurumi o taasimi. ");
INSERT INTO kew_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Nimumi Jon agaa meda wala agaa gupa misimi. Gore nere Krais-daa dia laede. Go page nere Gote-na agaa lakene aa-daa dia laede. Go page ni Elaija dia laede. Goa pea-ga neme onaana baptais-ri akolo kate pae simi. ");
INSERT INTO kew_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Goa simi rabu Jon-me gupa sa: Neme pa ipame baptais meaayo pare nimina rikiraana aa meda rekaaya pare naniminaaeme. ");
INSERT INTO kew_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Go aare nina masaa-nane epalia pare nipu ora epe aa ya-pulu nipuna aariti esepea kege radepeta palua sa. ");
INSERT INTO kew_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Apo agaare Betani su-para pisa. Go suri ipa Jordan-na mone pane go su-para Jon-me baptais kalaama pirua sa. ");
INSERT INTO kew_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ekeraa-nanere Jon-me Yesu ipisa rabu adoa lalo: Adalepa. Gote-na sipsip si-rupa ya-pulu nipumi su amaa piri onaa rayona pupitagi ne kone wae rayo mea rubaalia. ");
INSERT INTO kew_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Go aa madaare abade neme gupa sude: Nina masaa-nane aa meda epalia pare nipu ni namadini rabu nipu aba pirisa-pulu nipu adaape pia. ");
INSERT INTO kew_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Neme abade nipu na-adesu pare Juda onaanumi nipu adenalo baptais meaata ipisude sa. ");
INSERT INTO kew_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jon agaa gupa lakesa: Neme aba Holi Spirit yaa nona piane biyaa ipua Yesuna aaluna epa pirisa rabu adesu. ");
INSERT INTO kew_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Go raburi niri Yesu yapae lo waru naniminaasu pare Gote-me ni gupa lagisa: Holi Spirit yaa nona piane biyaa ipua aa meda madaa epa piraliade aamere Holi Spirit-na baptais meala epalia sa. ");
INSERT INTO kew_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Jon-me wala lalo: neme ora adawa pare nipu Gote-na Si ria yaade sa. ");
INSERT INTO kew_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ekeraa-nane Jon nipuna disaipel aa laapo raapu pirisimi. ");
INSERT INTO kew_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Go rabu Yesu pamualaina adoa nipumi lalo: Nipu adalepa. Go aare Gote-na sipsip mena si yaade sa. ");
INSERT INTO kew_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Mo disaipel aa laapome go agaa pagoa Yesu rata mea pisipi. ");
INSERT INTO kew_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Rata mea pisipi rabu Yesumi pereke tua nipu adesa-pulu agaa gupa misa: Gore nipiri ake asapipi? Nipu lapome lalo: Rabai, nere aapina ada-para pi? Go bi Rapaina re-re tisaa teme. ");
INSERT INTO kew_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Go rabu nipumi lalo: Epa adalepa. Goa sa-pulu nipu raapu pua nipu piri ada-para pua pirisimi. Go yapi rayo nipu raapu pirisimi. Ada-para pirina naare nogo-nane pabola popesa. ");
INSERT INTO kew_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Gore aa laapome Yesuna agaa pagesipi go aa medare Yesu raapu pisipi. Go aa-na biri Andru nipu Saimon Pita-na ame pirisa. ");
INSERT INTO kew_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Go rabu Andru-mi ame Saimon adasaawa agaa gupa lakesa: Niaame Mea Repae Aa aba adama sa. Mea Repae bina re gupa Mesaia Krais teme. ");
INSERT INTO kew_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Go rabu Andru-mi ame Yesu piri-para mea ipisa. Yesumi go ame adoa lalo: Nere Jon-na si Saimon yapare oropere nena bi Sifas teme sa. Go bi perekeaere Pita temena pare go bina re-re aana yaade. ");
INSERT INTO kew_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ekeraa-nane Yesu nipu Galili su-para polalo pisa-pulu nipumi Filip adasaawa lalo: Saa bana sa. ");
INSERT INTO kew_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip-ri nipu madini suri Betsaida. Go adaare-re Andru Pita lapona adaare-para pirisipi. ");
INSERT INTO kew_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Gore Filip-mi Nataniel asapuare gupa lakesa: Moses-me abade rekena agaa madaa remaa tisade aare niaame aba adasaarima. Gote-na agaa lakene aanumi page go aa epalialo pepa madaa tu isimide. Goa aare Nasaret su-para piri Josep-na si yaade sa. ");
INSERT INTO kew_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Goa sa-pulu Nataniel-me agaa gupa misa: Gore epe yaenuri Nasaret su-para mada epena ya? Filip-mi agaa go-rupa sa: Adola bana sa. ");
INSERT INTO kew_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Gore Yesumi Nataniel nipu piri ipisa rabu nipu agaa gupa lakesa: Go aare nipu ora Israel aa meda yaade. Nipumi yaa agaa nane aa yaade sa. ");
INSERT INTO kew_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Go rabu Nataniel-me nipu-para agaa gupa misa: Niri aa-rabu makuaari ya? Gore Yesumi lalo: Abade Filip nipi repena fik re-para piralaina adawade. ");
INSERT INTO kew_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Goa sa rabu Nataniel-me lalo: Tisaa, ne ora Gote-na Si yaade. Ne ora Israel onaana aa mudu pi sa. ");
INSERT INTO kew_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Goa sa rabu Yesumi lalo: Neme nere mo repena fik re-para pirae lawade-ga go madaa kone rulaari ya? Orope adali yaena purimi go abia adae yaenu maoge yaalia sa. Orope yae medalomame nina puri waru mea waatea. ");
INSERT INTO kew_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yesumi nimu-para lalo: Neme ora ria lagialo. Oropere yaa-para pora lobenaloa Gote-na ensel-nu ni nipuna Onaanu Raapu Pirape Aa madaa epala puala palia-daa adalimina sa. ");
INSERT INTO kew_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Wala yapi laapo dia naloa aa medame Galili su ru-nane pirua Kana adaare-para ona rumaasa. Nipumi ona rumaasa-pulu Yesuna agi-para nipuna disaipel aanu-para yaasimi rabu adola ipisimi. ");
INSERT INTO kew_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nimumi yawe eta aba noa oropere wain ipa dia sa rabu Yesuna agimi nipu-para lalo: Nimuna ipa wain dia yaade sa. ");
INSERT INTO kew_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Gore Yesumi lalo: Go ona, nina kogono aa neme agaa meda abi nakelape. Nina kogono pape yapi diri abi naepea. ");
INSERT INTO kew_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Goa pisa rabu Yesuna agimi disaipel aanu gupa lakesa: Nipumi gupa pipape teare nimimi goa ora pipape sa. ");
INSERT INTO kew_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Go ada aana-me warini ipa pe oraapu isa. Go aana pe padanere wabola piralade pe dila nona piane isa. Juda aanu nimuna rekena kone isimi-pulu oro yaalo nimuna waswas tape ipa pe mea isimi. ");
INSERT INTO kew_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesumi nipuna disaipel aanu-para lalo: Mogo aana pe madaa ipa nalepa sa. Goa sa-pulu nimumi no rubia palala pua isimi. ");
INSERT INTO kew_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","9","Go rabu Yesumi nimu-para lalo: Abia go ipa meda noria pua mo eta surube aa pua katapa. Nimu mo ipa mea pua kasimi rabu mo aame mo ipa rede pea pame mea nadesa. Go yaere abade pa ipa pirisa pare abia ipa wain-ga go eta surube aame ipa aa-para mea pae loa namakuaasa. Yapare ipa no pabe kogono aanu nimumi adesimi. Goa pea-pulu mo eta surube aame mo ona rumaatalo pi aa-para lakeloa ipu sa. ");
INSERT INTO kew_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Go rabu nipumi lalo: Aa medalomame epe ipa wain aba rumaainaloa onaanumi adaapu nenaloare wala orope wae wain rumaasimi. Goa peme pare neme epe wain orope mea rumaariaa sa. ");
INSERT INTO kew_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Go puri pane kogonore Yesumi Galili su robo ru-nane aaya Kana adaare-para aba ripima pisa. Go adaare-parare Yesumi nipuna epe paana puri wanaloa nipuna disaipel aanumi nipu madaa kone rulasimi. ");
INSERT INTO kew_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Goa puare Yesu-para nipuna agi-para amenu-para disaipel aanu-para mo Kaperneam adaare-para pua pirisimi. ");
INSERT INTO kew_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Gore Juda aanuna Pasova yawe ne adaa yapi di rudu sa-pulu Yesu Jerusalem su-para pisa. ");
INSERT INTO kew_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Lotu ada ru-nanere aanumi maket pua gawa sipsip yaa madaa yoto mealaina Yesumi adesa. Goa pua mone sens pape aanu reke madaa pirina adesa. ");
INSERT INTO kew_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yesumi ope mua ote meda waria apo mena-para mena puni aanu-para lotu ada amaa-nane ratu tisa. Go page mo mone misimi aanuna reke musaawa mone lakepe rubebe pisa. ");
INSERT INTO kew_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Go rabu mo yaa madaa yoto mealae aanu-para Yesumi lalo: Go yaanu amaa mea pulupa. Nina Aapana lotu ada namabebolatepa. Dia nimina stua ada-rupa namula tapape sa. ");
INSERT INTO kew_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Goa sa rabu nipuna disaipel aanumi Gote-na agaa i buk madaa kone wala rulasimi. Mo buk madaa agaa gupa isa: Gote, nena lotu ada madaare neme kone mapiraae-pulu nina pu robaa ora rekoaaya. ");
INSERT INTO kew_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Go rabu Juda aanu Yesu agaa gupa misimi: Niaame nena puri waru adamona-ga ake piane napiaa kogono pali-daa adalima pae simi. ");
INSERT INTO kew_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesumi nimu agaa gupa lakesa: Nimi go Gote-na ada kilipialimi rabu neme yapi repona ru-para wala wariabalua. ");
INSERT INTO kew_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Goa sa rabu nimumi pogolasaawa Yesu-para agaa wala gupa lakesimi. Neme go ada yapi repona ru-para mada wariali ya? Go lotu ada warisima diri maali 46-pela ru-para wariasima simi. ");
INSERT INTO kew_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Yapare Yesumi lotu ada warialua agaa lakesa rabu nipuna to yogane goa palia lo lakesa. ");
INSERT INTO kew_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Gore orope Gote-me Yesu matmat madaa marekainaloa nipuna disaipel aanumi mo sade agaa wala niminaasimi. Go rabu nimumi Yesuna agaa-para Gote-na buk madaa i agaa-para kone rulasimi. ");
INSERT INTO kew_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","So Jerusalem su-para Pasova yawe ne adaa yapi di isimi rabu Yesu page pisa. Go rabu Yesumi napiaa kogono pisa-pulu onaa adaapumi nipu madaa kone rulasimi. ");
INSERT INTO kew_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pare Yesumi onaa rayona kone adesa-pulu pa onaanu raapu piruapena kone narulasa. ");
INSERT INTO kew_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nipumi onaa rayona robaa-para adokaru misa-pulu pa onaa medame nipu kone makuaae meda nalakesimi. ");
INSERT INTO kew_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Farisi ruruna aa medana biri Nikodemus nipu Juda aanuna aa mudu pirisa. ");
INSERT INTO kew_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Go aame yapi meda ribaa Yesu piri-para ipua gupa sa: Tisaa, nere Gote-na agaa mogeainalo mea rapaasa. Go konere niaame makuaaema pare Gote ne raapu pia-pulu neme napiaa kogono epe-rupa pe sa. ");
INSERT INTO kew_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesumi saa pi agaa gupa sa: Neme ne ora lagialo. Aa medame agina robaa-para wala napiralia-daare Gote-na Surube Su mada na-adalia sa. ");
INSERT INTO kew_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Go rabu Nikodemus-mi lalo: Akea pua aa meda robaa-para wala mea madialia ya? Aa meda agina robaa-para wala piralia rabu rana laapo mada namadialia. ");
INSERT INTO kew_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Goa sa rabu Yesumi lalo: Neme ora lagialo. Aa medamere nipu ipa-para Holi Spirit-para namua piraliare Gote-na Surube Su mada na-adalia. ");
INSERT INTO kew_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Onaana yoganeme madini onaare yogane pa ia. Go page Holi Spirit-mi madini onaare Holi Spirit raapu pia. ");
INSERT INTO kew_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Goa pea pare ne kagaa opainalo remaa lagiawade-ga kone adaapu nasape. ");
INSERT INTO kew_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Po ripu nipuri aa-para popea palo mada na-ade. Niaame nipuna kete-daa pagema raburi aa-para epea pae aa-para pea palo niaame na-adema. Holi Spirit-mi madini onaamere po ripu-rupa go yaena re mada ademe. ");
INSERT INTO kew_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Goa sa rabu Nikodemus-mi lalo: Go lae agaa madaare akea pua kagaa palua ya? ");
INSERT INTO kew_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesumi lalo: Nere ora Israel onaanuna profet ya-pulu neme go agaa naniminaate? ");
INSERT INTO kew_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Neme ne lagialo. Niaame agaa tema rabu niaana ade yae-para page agaa tema pare nimi rayome go agaa gimaleme. ");
INSERT INTO kew_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Neme go su amaa yaenuna re lagialo rabu kone narulaeme. Goa pea-pulu orope yaa madaa yaenuna re lagialua rabu page kone ora narulalimi. ");
INSERT INTO kew_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Gore pa onaa meda yaa-para abi napeme. Onaanu Raapu Pirape Aana Siri ni padane yaa-para pirua su amaa ipisude sa. ");
INSERT INTO kew_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Abadere Moses-me onaa napiri su-para pua repena rugi madaa paka rogaawa minasaasa. Go-rupare orope nimumi Onaanu Raapu Pirape Aana Si mea tua pitalimi. ");
INSERT INTO kew_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Goa pea-pulu onaa rayome ni madaa kone rulalimiri go onaa rayo oro yaalo kagaa piraama laama palimi. ");
INSERT INTO kew_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Gore Gote-me su amaa piri onaa rayo madaa pedo pu raaname omesa-pulu ora nipuna Si padane mea repasa. Goa pea-ga onaa rayome ni madaa kone mapiraalimiri nimu ora naomalimi pare oro yaalo kagaa piraama laama palimi. ");
INSERT INTO kew_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Goa pea-pulu Gote-me ni nipuna Si su amaa koso agaa pagenalo namea rapaasa. Dia, pare onaa epe pora mea wanalo mea rapaasa. ");
INSERT INTO kew_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Onaa rayome ni madaa kone rulalimiri nipu koso agaa natea. Yapare onaa medalomame ni madaa kone narulalimiri nimu koso madaa aba popalimi. Go onaanuri ni Gote-na Si padane madaa kone narulaeme-pulu koso madaa wae yoto mulalo pimi. ");
INSERT INTO kew_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Go koso lapena re-re gupa: Epe paa go su amaa aba ipisa pare onaanumi waeanu pu pimi. Nimumi go epe paa gimoa ribaa madaa raana omoa pimi. ");
INSERT INTO kew_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Go waea peme onaanuri epe paame nimuna wae yaenu penaame waatea lo go paa masaa-nane mea roto tu ruboa pimi. Goa pua nimu epe paa roaaya-para naepeme. ");
INSERT INTO kew_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Goa pea pare epea peme onaanuri Gote-na agaa pago pimi-pulu paa-para peme epe kogono wanalo epeme sa. ");
INSERT INTO kew_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Orope Yesu nipuna disaipel aanu raapu Judia su robona ru-nane pisimi. Go su-parare Yesu nimu raapu pirua baptais kasa. ");
INSERT INTO kew_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Go rabu Jon-me Ainon su-para ipa adaapu popesa-pulu baptais go-para pua kasa. Haran suri Salim su re-para aasa. Onaanu nipu pirisa-para epenaloa baptais kasa. ");
INSERT INTO kew_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Go raburi Herot-me Jon kalabus ada abi namapaatisa. ");
INSERT INTO kew_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Go rabu Jon-na disaipel aa medalomame Juda aa meda-para ipame radepene rekena agaa madaa ape simi. ");
INSERT INTO kew_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ape simi rabu nimu Jon piri ipua lalo: Tisaa, aa meda abade ne raapu ipa Jordan-na mone pane pisipide kone niminaate? Go aa madaa agaa aba lagisi. Go aare abia baptais kane aa ya-pulu onaa rayo nipu piri-para pua baptais meme sa. ");
INSERT INTO kew_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Go rabu Jon-me lalo: Gote-me onaanu oyae nakateare nimumi mada namealimi. ");
INSERT INTO kew_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nimimi nina agaa aba pagesimi rabu neme agaa gupa sude: Niri ora Gote-na Mea Repae Aa-daa dia yapare Gote-me ni aba mea epenasade. ");
INSERT INTO kew_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Aa medame nipuna ona rumaatalo paliare go ona ora nipuna ore piralia. Go rabu go aa-na adami aanumi pago piralimi. Go adami aame ona rumaatalo aa-na agaa pagalia rabu raaname omalia. Go konere nina raaname omape kone go-rupa ora epeaalia. ");
INSERT INTO kew_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Gore Yesuna biri ora sone minasaamina pare nina biri su amaa pa rabuaniaalimina. ");
INSERT INTO kew_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","So yaa-para piruaaya epe aare niaa rayona aa mudu pia. Su amaa madini onaare ora su amaa onaa ya-pulu su amaa agaa madaa laketeme. Goa pea pare so yaa-para pirua none epe i aare oyae rayona aa mudu pia. ");
INSERT INTO kew_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nipumi adoa pagea yae madaa agaa laketa pare onaanumi nipuna agaa madaa kone narulaeme. ");
INSERT INTO kew_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Goa pea pare onaa rayome nipuna agaa madaa kone rulaeme-pulu Gote-re ora agaa ne aa yaade. ");
INSERT INTO kew_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Gote-me epenasa aare Gote-na Holi Spirit robaa-para marulatabaaya-pulu go aamere Gote-na agaa laketa. ");
INSERT INTO kew_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Gore Aapame nipuna naaki madaa pedo pu raaname omoa nipuna puri kanaloa oyae rayo surubea. ");
INSERT INTO kew_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Goa pea-pulu onaa rayome Gote-na Si madaa kone rulalimi-daare oro yaalo kagaa piraama laama palimi. Yapare onaa rayome Gote-na Sina agaa rasalimiri oro yaalo napiralimi. Dia, pare Gote-na ratu yawe konere go onaanumi oro yaalo mealimi. ");
INSERT INTO kew_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farisi aanumiri Yesumi nipuna disaipel aa adaapu mua baptais katalo pagesimi. Goa pisa-pulu Yesuna disaipel onaanumiri Jon-na disaipel onaa maoge yaasa-daa pagesimi. ");
INSERT INTO kew_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Yapare Yesumi baptais nakasa pare nipuna disaipel aanumi agu baptais kasimi. ");
INSERT INTO kew_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesumi go agaa pagoa Judia su gimoa Galili su-para wala pisa. ");
INSERT INTO kew_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Gore Judia su gimoa Galili su puaa-mama puare Samaria su-para pua opopasa. ");
INSERT INTO kew_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Mo Samaria suna adaarena bi medare Sikar simi. Go adaare-re abade Jekop-me nipuna si Josep rumaa kasade su maapuri go adaare re-para aasa. ");
INSERT INTO kew_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Go su-parare abade Jekop-me ipa nape naaku awesade. Yesu nipu pora pua paalame omesa-pulu mo ipa naaku re-para pua kitu pirisa. Goa pua pirisa naare iniri 12 klok rabu pirisa. ");
INSERT INTO kew_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Go rabu Samaria ona meda ipa nola ipisa rabu Yesumi nipu-para lalo: Ipa meda no gi sa. ");
INSERT INTO kew_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Go raburi nipuna disaipel aanuri aba mo adaare-para eta kabolalo pisimi. ");
INSERT INTO kew_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Goa sa rabu Samaria oname Yesu-para lalo: Nere Juda aa yapare niri Samaria ona ya-pulu akeane ni-para ipa nano gi lae ya? Gore Juda aanuri Samaria onaa raapu eta medaa-para nanisimi. ");
INSERT INTO kew_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu nipumi mo ona-para agaa gupa lakesa: Neme Gote-me pa giape yae niminaawa go ipa nano gi ta aa-na bi pagola pae-daare gore ni agaa mula pae yaalore ora ipa yokea-rupa epe agaa mada lagula pawa. ");
INSERT INTO kew_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mo oname lalo: Aa adaaya, nena ipa nape pe nasana. Go ipa naaku ora no-para pia-ga go epe ipa yokea-rupa aa-para meali ya? ");
INSERT INTO kew_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Niaana akua Jekop-me go ipa nape naaku wari gisa. Gore nipumi page sinumi page mena gawa sipsip-numi page go ipa no aema. Goa pea-ga nere Jekop rabuniaawa pi ya? ");
INSERT INTO kew_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu nipumi lalo: Onaa rayome go ipa nalimi-daare orope nimuna peto kaapu yaalia rabu wala nolalo epalimi. ");
INSERT INTO kew_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Yapare onaame nina gulalo pi ipa nalimi-daare ora mada teme. Nina ipare onaana robaa-para ipa yokea-rupa mapiraalua-pulu pa ipa meda nane go ipame oro yaalo kagaa piraama laama palimi. ");
INSERT INTO kew_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Goa sa-pulu oname lalo: Aa adaa, go laede ipa giaina ni orope go ipa naaku-para wala nanola epalua. ");
INSERT INTO kew_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Goa sa rabu Yesumi nipu-para lalo: Nena aani aba pua yaaloa one ipulupape. ");
INSERT INTO kew_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Oname lalo: Ni aa meda napia sa. Yesumi lalo: Nena aani napia laere gore ora lae. ");
INSERT INTO kew_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Nere aa supu piside pare go abia ne raapu pipi aare ora nena aani-daa dia. Go nena agaare ora lae. ");
INSERT INTO kew_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Goa sa rabu oname lalo: Aa adaaya, abia neme nere adalo pare ne Gote-na agaa lakene aa yaana. ");
INSERT INTO kew_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Niaana Samaria akuanumi go rudu madaa rumua kiritaawa Gote-na bi minasaasimi. Goa pisimi pare nimi Juda aanumiri no Jerusalem su-para Gote-na bi minasaamina teme sa. ");
INSERT INTO kew_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesumi nipu-para lalo: Ona, naa agaa waru paga. Orope epaliade yapi di rabu onaanumi go rudu madaa page Jerusalem su-para page Gote-na bi naminasalimi. ");
INSERT INTO kew_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nimi Samaria onaanuri nimi kone nasua bi minasaaeme pare niaa Juda onaanumiri bi niminaawa minasaaema. Oro yaalo pirape konere Juda aanumi mea ipisimi. ");
INSERT INTO kew_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pare abia page orope epaliade yapi di rabu page onaanumi Aapana bi padane epe-rupa minasaalimi. Nipuna bi epe-rupa minasaaeme onaanuri Aapame raaname omea. ");
INSERT INTO kew_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Gote-re nipu ora Holi Spirit pia-pulu onaanumi nipuna bi minasaalimi-daare nimuna kone wasupame-para ora agaame lotu loa bi minasaamina. ");
INSERT INTO kew_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Go rabu oname Yesu-para lalo: Gote-na Mea Repae Aa nipuna bi meda Krais-re nipu epalia simi-daa niminaato sa. Go aa epalia rabu niaa oyae rayona re lagialia sa. ");
INSERT INTO kew_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesumi lalo: Go aare ni yaade. Abia ne raapu agaa go tapa-daa sa. ");
INSERT INTO kew_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Goa lalaina Yesuna disaipel aanu ipua Yesu pa ona meda raapu agaa lakeloaaya-ga kone adaapu isimi. Pare disaipel aanumi paala omoa nalakesimi: Neme ake pua go ona lakelae pa simi. ");
INSERT INTO kew_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Go rabu go oname nipuna ipa pe gimoa mo adaare-para pua onaanu-para gupa pua lakesa: ");
INSERT INTO kew_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Go aa meda epa adalepa. Nipumi nina pisude-anu rayo epa lagia-pulu nipu Gote-me Mea Repae Aa yapae sa. ");
INSERT INTO kew_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Goa sa rabu nimu su adaare gimoa Yesu piri-para adola ipisimi. ");
INSERT INTO kew_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Go ipisimi raburi mo disaipel aanumi nipu-para lalo: Tisaa, ne eta na simi. ");
INSERT INTO kew_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pare Yesu nipumi lalo: Nina eta medaloma ina nimimi na-ademe. ");
INSERT INTO kew_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Goa sa-pulu disaipel aanumi nimuna lala pirua gupa simi: Aa medame nipuna eta epa kalame ya? ");
INSERT INTO kew_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesumi nimu-para lalo: Nipumi ni mea epenasadere nipuna agaa pagoa kogono pu kiritaayo. Go kogonore nina eta yaade. ");
INSERT INTO kew_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nimina saa pi agaa gupa teme: Akua 12-pela piruare eta nape awalimi. Nina saa agaa pagalepa. Mo maapu-para adalepape. Mo maapu-para pore nape eta adaapu etea-ga keralimina. ");
INSERT INTO kew_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Maapuna eta kiritape aare yoto aba mea-pulu etamere oro yaalo kagaa piraama laama mapuaalia. Goa pea-pulu eta pone onaa-para eta aawae onaa-para nimu raapu raaname omalimina. ");
INSERT INTO kew_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Saa agaa meda gupa teme: Aa padaneme maapu-para eta wai poaaya pare aa medame eta awoa nalia teme. ");
INSERT INTO kew_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Apo saa agaana re gupa sa: Nimi go maapu-para e napoaeme pare awalimina. Onaa medalomame go maapu eta poasimi-pulu nimimi nipuna kogono madaare eta mealimina. ");
INSERT INTO kew_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Gore mo adaare-para Samaria onaa adaapumi mo onana agaa pagesimi-pulu Yesuna agaa madaa kone rulasimi. Mo oname aba gupa sa: Nina abade pisude wae yae rayo lagiaa sa. ");
INSERT INTO kew_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Gore Samaria onaanumi Yesu piri-para ipua lalo: Niaana adaare-para pa piramina. Goa simi rabu Yesu nipu yapi laapome go su-para pirisimi. ");
INSERT INTO kew_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Yesumi epe agaa lakesa-pulu onaa adaapumi nipu madaa kone rulasimi. ");
INSERT INTO kew_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Goa pisimi rabu mo ona-para gupa lakesimi: Abia kone rulatema pare nena agaa agu-daa padane madaa kone narulatema. Dia, pare nipuna agaa pagemade-pulu onaa rayona Raba Meape Aa yaanaloa kone rulaema simi. ");
INSERT INTO kew_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesu yapi laapo dia naloa Galili su-para pua pirisa. ");
INSERT INTO kew_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Goa pua Yesumi gupa sa: Gote-na agaa lakene aare nipuna madini su-parare nipuna bi naminasaaeme sa. ");
INSERT INTO kew_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Goa pea-pulu go su-para gimoa Galili su-para pisa raburi onaanumi nipuna ki mua raaname omesimi. Abare nimumi Juda aanuna eta yawe ne adaa yapi di rabu Jerusalem su-para Yesu pisa-daa adesimi. ");
INSERT INTO kew_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Gore Yesu Kana adaare-para wala ipisa. Go adaare Galili su ru-nane aaya pare nipumi go su-para kagaa ipa wain aba warisaaya. Go su-parare gavman surube aa meda pirisa. Nipu Kaperneam su-para piri naakiri yaina omesa. ");
INSERT INTO kew_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Gore go aamere Yesu Judia su gimoa Galili epaade remaa pagesa-pulu Yesu piri ipisa. Pisa rabu nipuna naaki ini adupitalo pisa-pulu Yesu Kaperneam su-para ipua nipuna naakina yaina maepeaainalo agaa misa. ");
INSERT INTO kew_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesumi nipu-para lalo: Nimumi napiaa kogono rado rado na-adalimi-daare ni madaa kone narulaeme. ");
INSERT INTO kew_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Bosboi-mi Yesu-para lalo: Aa adaa, nina naaki aba ini adupita-ga aipapulu bana sa. ");
INSERT INTO kew_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesumi nipu-para lalo: Ne pu, nena naakiri aba rekoa pia sa. Goa sa rabu mo aame Yesuna agaa madaa kone rulaawa ada pisa. ");
INSERT INTO kew_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nipu pora-nia pulaina nipuna kogono naakinumi pora madaawa lalo: Nena naakiri aba rekoa pa pia simi. ");
INSERT INTO kew_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Goa simi raburi nipumi nimu agaa gupa misa: Aa-rabu yaina perekea ya? Nimumi lalo: Abala aebo bero raburi perekea nipuna kekapu dia yaade simi. ");
INSERT INTO kew_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Goa simi raburi mo naakina aaraame ora go rabu Yesumi nena naaki pa pia lakelaa-daa niminaasa. Go agaa niminaaya-pulu go aame page nipuna ona nogo naakinu page Yesu madaa kone rulasimi. ");
INSERT INTO kew_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yesumi Judia su gimoa Galili su-para pisa rabu go piane kogonore nipumi napiaa rana laapo pisa. ");
INSERT INTO kew_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Gore apo napiaa kogono dia sa raburi oropere Juda aanuna eta nape olode yapi di rudu sa rabu Yesu Jerusalem su-para pisa. ");
INSERT INTO kew_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","So Jerusalem su-para adaarena kepo rikiraana pora gaape meda isa. Go pora gaapena biri sipsip menana pora gaape simi. Go pora gaapena re-parare oge ipa ini meda isa. Go ipa inina repaa-parare pokaalo ada supu aasa. Juda aanuna adaa agaa madaare go ipa ini biri Betesda teme. ");
INSERT INTO kew_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Go pokaalo ada ru-nanere yaina ome onaa adaapu epa pirisimi. Nimuna yainare ini rubu pi onaanu page aa wae onaanu page pora napami onaanu page epa pirisimi. Nimu mo ipame etoto pia-rupa adolalo pirisimi. ");
INSERT INTO kew_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Goa pua Gote-na ensel medame no ipa ini-para pua odobaawa mo ipa maeto eto mapaasa. Goa palia rabu aa padaneme aba no eto piade ipa ini-para odobaliare nipuna yaina dia yalia. ");
INSERT INTO kew_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Gore aa meda mo pokaalo ada-para nipu yaina pa inare maali 38-pela patisa. ");
INSERT INTO kew_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesumi mo aa-na yaina maali adaapu patisa adesa-pulu nipu-para lalo: Nena konemere yaina maperekealua kone i? ");
INSERT INTO kew_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Yaina ome aame lalo: Aa adaa, mogo ipame eto palaina ni no ipa-para maodobape aare meda dia ya. Nina ipa-para odobatalo pe rabu pa aa meda aba ipa-para pua odobaaya sa. ");
INSERT INTO kew_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesumi nipu-para lalo: Ne rekoa nena yapara mea rua pora pamua sa. ");
INSERT INTO kew_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Goa sa rabu mo aa-na yaina aipapulu perekea nipuna yapara mea rua pora pamisa. Mo aa-na yaina perekesa raburi Kitu Pirape Yapi di pisa. ");
INSERT INTO kew_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Goa raburi Juda aanumi mo maperekeae aa-para lalo: Abiare Kitu Pirape Yapi di yaade. Nena yapara rini kogonore niaana rekena agaa rasaede simi. ");
INSERT INTO kew_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Go aame lalo: Mo nina yaina maperekeae aame ni-para lalo: Nena yapara mea rua pora pamua lade sa. ");
INSERT INTO kew_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Goa sa rabu nimumi nipu-para lalo: Gore nena yapara mea rua pora pamualore aapimi lagiaa ya? ");
INSERT INTO kew_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Goa simi pare yaina maperekeae aame Yesu inimi waru na-adesa. Go pokaalo ada ru-nane onaa adaapu aba pirisimi-pulu Yesu pisa rabu mo aame waru na-adesa. ");
INSERT INTO kew_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Orope Yesumi mo aa Juda aanuna lotu ada-para adesa. Go raburi Yesumi lalo: Paga, abia nena yoganere epe-rupa aaya. Goa pea-ga ora adaa waeape meda ne mada epalia-ga nena pupitagi ne kone gimape sa. ");
INSERT INTO kew_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Go rabu mo Juda aa piri-para pua Yesumi ni maperekeaaria lo remaa pua lakesa. ");
INSERT INTO kew_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Goa sa rabu Yesumi Kitu Pirape Yapi di madaa go aa maperekeasa rabu Juda aanumi waea pua Yesu kedaa katalo pirisimi. ");
INSERT INTO kew_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Goa pisa-daa Yesumi nimu lakesa: Nina Aapame oro yaalo kogono pala pia-ga neme page go pora ratua pe. ");
INSERT INTO kew_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Goa sa rabu Juda aanumi nipu ora talima kone isimi. Nimuna konere Yesumi Kitu Pirape Yapi di orona rekena agaa rasa. Go page Yesumi Gote-re nina Aapa sa-pulu nipuri Gote nona piane pia-daa Juda aanumi tu maomaatalo pisimi. ");
INSERT INTO kew_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Go kone isimi rabu Yesumi nimu-para lalo: Gore neme ora lagialo. Nina kogono pa amaa nape. Ni Aapana Si ora ria yaalo Aapana kogono pe. Nina Aapame kogono pea-rupa adoa pe. Aapame pea-rupa adoa mogeaayo. ");
INSERT INTO kew_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Goa pea-ga nina Aapame ni nipuna naaki madaa pedo pu raaname omoa nipuna pape kogono ni waatea. ");
INSERT INTO kew_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Goa pea-pulu Aapame ome onaa marekaawa oro yaalo mapiraalia-rupa go kone mogeawa nina kone sua onaanu oro yaalo kagaa piraama laama mapualua. ");
INSERT INTO kew_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Go page Aapame koso lape agaa onaa madaa natea pare ni nipuna naaki go puri gisa-daa neme palua. ");
INSERT INTO kew_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Goa palua-pulu onaanumi Aapana bi minasaaeme-rupa nina bi page minasaalimina. Yapare onaanumi nina bi naminasalimiri ni mea rapaasa Aapana bi page naminasaaeme. ");
INSERT INTO kew_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Neme ora lagialo: Onaa rayome nina agaa pagoa ni mea epenasa aapa madaa kone rulalimiri oro yaalo kagaa piraama laama palimi. Go onaa madaare koso lape agaa natoa pare nimu omape kone aba gimoa oro yaalo kagaa piraama laama palimi. ");
INSERT INTO kew_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Neme ora lagialo sa: Abia go di rabu page orope epaliade di rabu page ome onaanumi Gote-na Si nina agaa pagalimi. Pagalimi-pulu oro yaalo kagaa piraama laama palimi. ");
INSERT INTO kew_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Gore Aapare oro yaalo kagaa pirape konena re pia-pulu nipumi nipuna naaki ni page go mapiraape re gisa. ");
INSERT INTO kew_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Niri Onaanu Raapu Pirape Aana Si ya-pulu Aapame ni koso lape agaana puri gisa. ");
INSERT INTO kew_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Go agaa madaare kone adaapu nasalepape. Gore yapi di meda epalia rabu matmat-para rogaae onaanumi nimu yaatea rabu pagalimi. ");
INSERT INTO kew_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Pagalimi-pulu nimu matmat su gimoa amaa epalimi. Goa pea-ga onaa medaloma epea palimi-nuri marekaawa oro yaalo kagaa piraama laama mapuaalia. Pare onaa medalomame waea palimiri marekaawa koso lape agaa loa wae yoto katoa sa. ");
INSERT INTO kew_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Go yaere neme agu raapo napalua pare Gote-me lagi koso lape agaa toa. Goa pea-ga nina bipa nina kone namogeto pare ni mea rapaasa Aapana kone rate. Goa pea-pulu nina koso lape agaare ora redepone yaade. ");
INSERT INTO kew_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Pare neme nina agaa lagere yaa agaa to kone saleme. ");
INSERT INTO kew_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Yapare aa medame ni madaa agaa laketa rabu ora ta kone salimi. ");
INSERT INTO kew_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Gore nimimi Jon piri aa medaloma agaa mea o taainalo penaasimi rabu nipu ora agaa madaa lakesa. ");
INSERT INTO kew_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Gore neme onaa medana agaa madaa kone namapiraayo pare Gote-me onaa raba minalo go agaa nimi lagialo. ");
INSERT INTO kew_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon-re epe paata nona pi ipua nipuna roasa paa onaanu kasa-pulu nimi Juda aanumi nipuna paa adoa pedo pu pirisimi. ");
INSERT INTO kew_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Jon-me ni madaa puri pane agaa lakesa pare nina Aapame gisa kogono pe rabu Jon-na agaa maoge yaato. Go kogono palua rabu Aapame ni mea epenasa-daa madaa adamina. ");
INSERT INTO kew_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Gore Aapame ni mea rapaasa-daa neme lagula ipisu. Nimimi nipuna agaa napagoa nipuna ini agaa na-ademe. ");
INSERT INTO kew_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Nipumi ni mea repaawa nipuna agaa robaa-para naimi-pulu ni madaa kone narulaeme. ");
INSERT INTO kew_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nimumi oro yaalo kagaa piraama laama polalo kone imi-ga Gote-na buk dipiaeme. ");
INSERT INTO kew_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Goa peme pare nimi ni piri oro yaalo kagaa pirape kone-daa namula epeme. ");
INSERT INTO kew_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Niri onaanu pedo pua agaa pagoa raana omenalo na-aato. ");
INSERT INTO kew_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Goa pea pare nimina kone ade. Nimina robaa-para Gote madaa kone narulaeme. ");
INSERT INTO kew_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ni ipisude rabu Aapame mea repaawa puri gisa pare nimimi ni ora gimeme. Goa pea pare aa meda nipuna puri mea epalia-daare nimimi nipu madaa epe kone sua mealimi. ");
INSERT INTO kew_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nimina konere pa pedo pedo pala pimi. Yapare Gote-na pedo pi agaare kone naimi-pulu akeane kone rulalimi ya? ");
INSERT INTO kew_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Pare nimina koso lape agaa Aapa laketoa kone nasalepape. Dia, nimimi Moses madaa kone rulasimi-pulu nipumi nimi koso lape agaa madaa tea. ");
INSERT INTO kew_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Pare nimimi Moses-na agaa madaa kone waru rulasimi-daare Moses-me ni madaa pepa tisa-ga ni madaa page kone mada rulasimina. ");
INSERT INTO kew_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pare nipuna tisade agaa madaa kone narulaeme-pulu nina agaa madaa page kone mada narulalimi sa. ");
INSERT INTO kew_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Go agaa lakeloa Yesu nipu Galili ipa ini mone pane wala pisa. Go ipa inina bi medare ipa Taiberias teme. ");
INSERT INTO kew_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Go raburi onaa adaapumi Yesuna puri pane kogonome yaina ome onaa maperekeasa-daa adesimi-pulu nimumi nipu rata mea pisimi. ");
INSERT INTO kew_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Go rabu Yesu-para nipuna disaipel aanu-para nimu rudu meda rumua pisimi. ");
INSERT INTO kew_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Go rabu Juda onaanuna Pasova yawe ne adaa yapi di rudu sa. ");
INSERT INTO kew_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Go rabu Yesumi onaa adaapu nipu piri epenalo adesa-pulu nipumi Filip-para lalo: Gore mo onaa adaapu epa pimi-ga nimuna nape etare aa-para kabalima ya? ");
INSERT INTO kew_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Nipumi Filip-na kone adolalo go agaa sa pare Yesu nipuna pape kone aba niminaasa. ");
INSERT INTO kew_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Go agaa sa rabu Filip-mi lalo: Go onaa rayome eta ogepusi nalimi sa. Niaame bret kabape mone ora adaapu ruboa kabalimare sa. ");
INSERT INTO kew_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Gore Saimon Pita-na ame Andru-mi lalo: ");
INSERT INTO kew_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Naaki ogesi meda go pia-ga nipuna bret ipa supu-para ena laapo-para saapia. Goa pea pare go onaa adaapu pimi-pulu mada nanalima sa. ");
INSERT INTO kew_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesumi nipuna disaipel aanu-para lalo: Go onaanu mapiraatepa sa. Go suna ripu adaapupe aasa. Go ripu aasa-para onaa rayo pirisimi. Goa pua nimu 5,000-rupa pirisimi. ");
INSERT INTO kew_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Go rabu Yesumi bret mua Gote-para ora pi loa ripu madaa piri onaanu ena mea rumaasa. Mo ena oge laapo page goa pinaloa onaanumi mo eta raapu nisimi. ");
INSERT INTO kew_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Eta noa ebo rubisimi rabu Yesumi nipuna disaipel aanu-para lalo: Nimimi eta ebonu rayore makiritaatepa. Medaloma narubalimina dia. ");
INSERT INTO kew_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Goa sa-pulu bret supuna ebore basket 12-pela madu isimi. ");
INSERT INTO kew_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Onaanumiri Yesuna napiaa kogono adesimi-pulu gupa simi: Go aare Gote-na agaa lakene aa su amaa epa yaade aa simi. ");
INSERT INTO kew_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Goa simi rabu mo onaanumi Yesu nipu aa mudu mapiraatalo pisimi. Pare Yesumi go kone adesa-pulu nipu wala so rudu madaa agu raapo pua pisa. ");
INSERT INTO kew_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Ora aebo raburi nipuna disaipel aanu mo ipa ini mone pane Kaperneam su-para polalo ipunu madaa pirua pisimi. Goa pua ribaa yabaasa pare Yesu nimu piri-para abi naipisa. ");
INSERT INTO kew_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Go raburi po ripu adaape ipua ipa ini madaare morope morope laama ipisa. ");
INSERT INTO kew_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Gore mo disaipel aanumi ipunu madaa pirua ipa oge-daa adaalu-para modo kepaa nona piane yaeme ipa apeaawa pisimi. Gupa polalo pisimi rabu Yesu ipa masaana pamisa-daa nimumi nipu adoa paalame omesimi. ");
INSERT INTO kew_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Go rabu Yesumi nimu-para lalo: Nimimi paala naomalepape. Gore ni yaade. ");
INSERT INTO kew_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Goa sa rabu nimumi nipu ipunu madaa epa pirina kone isimi. Goa pua go ipunu polalo pisimide su-para aipapulu mea pisa. ");
INSERT INTO kew_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ekeraa-nanere ipa ini mone pane pirisimi onaanumi ipunu padane aba ina adesimi. Gore Yesu nipuna disaipel aanu raapu ipunu madaa napirina disaipel aanu nimuna pisimi-daa onaanumi niminaasimi. ");
INSERT INTO kew_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Goa pea pare ipunu medaloma Taberias su gimoa ipa ini repaa-nane isa. Go ipa repaananere Yesumi abala-rupa bret madaa ora pi loa rumaainaloa onaanu adaapu nisimi. ");
INSERT INTO kew_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Gore onaanumi Yesu-para nipuna disaipel aanu-para nimu raapu napirina adesimi. Goa pua nimimi mo Taiberias su polalo pi ipunu madaa pirua Kaperneam su-para Yesu asapula pisimi. ");
INSERT INTO kew_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Gore onaanumi Yesu ipa ini mone pane pua adoare agaa gupa misimi: Tisaa, go-parare aa-rabu epae ya? ");
INSERT INTO kew_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesumi lalo: Neme nimi ora lagialo. Neme napiaa kogono pawade rabu nimimi ni asapula epame ya? Dia, pare nimimi bret abala noa robaa rulataba-daa nimimi ni asapula epamena. ");
INSERT INTO kew_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Go etare ramualia-ga nimimi go eta madaa kogono napipape. Dia, pare oro yaalo noa kagaa pirape eta madaa kogono pipape. Eta go-rupare ni Onaanu Raapu Pirape Aana Si yaade pare Gote nina Aapame ni madaa pedo pua mea repasa-pulu neme go eta gialua sa. ");
INSERT INTO kew_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Go rabu nimumi nipu-para agaa gupa misimi: Niaame akea pua Gote-na kogono madaa palima ya? ");
INSERT INTO kew_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesumi agaa gupa abusa: Gote-na kogonore gupa ia sa: Niri nipumi mea epenasa-ga ni madaa kone rulaatepape sa. ");
INSERT INTO kew_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nimumi lalo: Niaame na-adema yae meda mada pali ya? Gore ake kogono pali ya? Niaame nena napiaa kogono adalima-daa ne madaa kone rulalima. ");
INSERT INTO kew_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Niaana akuanumi onaa napiri su-para eta nisimi. Go madaare Gote-na buk madaa agaa gupa ia simi: Nipumi yaa-para isade bret eta kasa-pulu nisimi. ");
INSERT INTO kew_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesumi wala lalo. Neme nimi ora lagialo: Moses-na bret nisimidere ora yaa-para i bret-daa dia sa. Dia, nina Aapame ora yaa-para iade bret guaaya. ");
INSERT INTO kew_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nina Aapame guaaya bret-re neme yaa madaa gimoa su amaa ipua nimi onaanu oro yaalo mapiraape kone raapu gialua. ");
INSERT INTO kew_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nimumi nipu-para gupa simi: Adaa Aa, go oro yaalo kagaa mapiraape bret niaa ora giape simi. ");
INSERT INTO kew_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesumi nimu-para lalo: Niri oro yaalo kagaa piruae bret yaade. Onaa rayo ni piri-para epalimiri oro yaalo reaeme naomalimi. Onaa rayome ni madaa kone rulalimiri nimuna robaa-para ipa mada roalia. ");
INSERT INTO kew_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Gore nimi aba lagiawade. Nimimi ni aa ademe pare kone narulaeme. ");
INSERT INTO kew_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Naa Aapame onaa rayo ni gea-pulu ni piri-para epalimi. Goa pua onaa ni piri-para epalimiri nagimalua. ");
INSERT INTO kew_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Naa Aapame ni su amaa mea epenasare nina kogono panolo namea epenasa. Ora dia yapare nipuna gisade kogono palua. ");
INSERT INTO kew_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nipumi ni kogono gua mea pusa kogono gupa palua. Nipuna giape onaanuri ora na alupalimina pare orope epaliade yapi di rabu nimu rayo matmat-para marekaawa oro yaalo mapiraalua. ");
INSERT INTO kew_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nina Aapana kone gupa ia. Onaa rayome niri Aapana Si adoare ni madaa kone rulalimiri oro yaalo epe-rupa kagaa piraama laama palimi. Goa pea pare orope porapo yape di madaare neme nimu marekaalua sa. ");
INSERT INTO kew_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yesu nipu yaa-para i bret epawa sa rabu Juda aanumi mumu agaa loa ape simi. ");
INSERT INTO kew_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Go raburi nimumi lalo: Go aa Yesuri ora Josep-na si yaade. Niaame nipuna agi aaraa lapo page ademade. Gore akeane yaa-para gimoa ipisu laa ya? ");
INSERT INTO kew_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesumi agaa gupa abusa: Nimimi mumu agaa nalala piralepape. ");
INSERT INTO kew_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Onaa meda ni piri-para pa mada naepalimi. Dia, Aapame onaa meda mea epena kone saliare mada epealimi. Go Aapamere ni page epenasa. Goa pea-pulu orope go di epalia raburi neme nimu matmat-para marekaalua. ");
INSERT INTO kew_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Aba Gote-na agaa lakene aanumi buk madaa agaa gupa tisimide: Onaa rayore Gote-me nimu mogeaatalo pea agaa gupa tisimide. Onaa rayore nina Aapana agaa pagoa nipu kone mapiraalimiri ni piri-para mada epalimi. ");
INSERT INTO kew_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Go agaa lagialo pare onaa padaneme page Aapa abi na-ademe. Dia, ni Gote raapu pirua ipisude-pulu neme agu raapo Aapa ade sa. ");
INSERT INTO kew_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Neme nimi ora lagialo. Onaa rayome ni madaa kone rulalimiri oro yaalo epe-rupa kagaa piraama laama palimi. ");
INSERT INTO kew_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nemere onaanu oro yaalo kagaa mapiraawa nape bret yaade. ");
INSERT INTO kew_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nimina akuanumi yaa-para i bret eta onaa napiri su-para nisimi pare nimu a