﻿USE sofia;
DROP TABLE IF EXISTS sofia.kenNT_vpl;
CREATE TABLE kenNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kenNT_vpl WRITE;
INSERT INTO kenNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Nɛ́ chi manyɛ́n bachǐmbɨ Yesu Kristo, ɛbhárɛ́mɔ Mfɔ Debhít nɛ Ábraham. ");
INSERT INTO kenNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ábraham achí nyaka chi Áisek, Áisek abhak chi Jekɔ́p, Jekɔ́p abhak chi Júda nɛ bɔ̌mayi. ");
INSERT INTO kenNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Júda achí nyaka chi Pɛ́res nɛ mɔ́mayi Sɛrá. Máyap aka nnyɛ́n bɛ Táma. Pɛ́res abhak chi Hɛ́srɔn, Hɛ́srɔn abhak chi Rám. ");
INSERT INTO kenNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Rám achí nyaka chi Amínadap, Amínadap abhak chi Náshɔn, Náshɔn abhak chi Sálmɔn. ");
INSERT INTO kenNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sálmɔn achí nyaka chi Bóas. Nnɔ Bóas aka nnyɛ́n bɛ Ráhab. Bóas abhak chi Óbɛd. Nnɔ Óbɛd aka nnyɛ́n bɛ Rút. Óbɛd abhak chi Jése, ");
INSERT INTO kenNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jése abhak chi Mfɔ Debhít. Debhít achí nyaka chi Sólomon. Nnɔ Sólomon ayambɨ abháy Uria, kɛ ǎbhay Debhít. ");
INSERT INTO kenNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sólomon achí nyaka chi Rehóboam, Rehóboam abhak chi Abíja, Abíja abhak chi Ása. ");
INSERT INTO kenNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ása achí nyaka chi Jɛhósafat, Jɛhósafat abhak chi Jóram, Jóram abhak chi Úsia. ");
INSERT INTO kenNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Úsia achí nyaka chi Jótam, Jótam abhak chi Áhas, Áhas abhak chi Hesékia. ");
INSERT INTO kenNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesékia achí nyaka chi Manáse, Manáse abhak chi Ɛ́mɔs, Ɛ́mɔs abhak chi Josáya. ");
INSERT INTO kenNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josáya achí nyaka chi Jɛkonáya nɛ bɔ̌mayi. Mpok yɔ kɛ̌ bápɔ́kɔ́ bo Israɛl bɛ mandɔk manchɔkɔ ɛtɔk Bábilɔn. ");
INSERT INTO kenNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Mpok anɛ bo Israɛl bárɔ́ Bábilɔn bápɛ̀tnsɛm ɛtɔk ɛyap, Jɛkonáya achí nyaka chi Síltiɛl, Síltiɛl abhak chi Sɛrúbabɛl. ");
INSERT INTO kenNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sɛrúbabɛl achí nyaka chi Ábiud, Ábiud abhak chi Ɛliákim, Ɛliákim abhak chi Ásɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ásɔ achí nyaka chi Sádɔk, Sádɔk abhak chi Ákim, Ákim abhak chi Ɛ́liud. ");
INSERT INTO kenNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ɛ́liud achí nyaka chi Ɛliása, Ɛliása abhak chi Mátan, Mátan abhak chi Jekɔ́p. ");
INSERT INTO kenNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekɔ́p achí nyaka chi Josɛ́f nnɛ́m María, María anɛ ábhé Yesu mmu achi Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò. ");
INSERT INTO kenNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Bɛ́bhó amʉɛ́t Ábraham bɛghaka amʉɛt Debhít, mkpák bachǐmbɨ Kristo ɛ́chí yɛ nyaka byo nɛ ɛnwi. Bɛ́bhó amʉɛt Debhít bɛghaka mpok bápɔ́kɔ́ bo Israɛl bɛ mándɔ́k mánchɔ́kɔ́ ɛtɔk Bábilɔn, ɛ́bhák byo nɛ ɛnwi. Bɛ́bhó mpok bo Israɛl bárɔ́ Bábilɔn bápɛtnsɛm ɛtɔk ɛyap, bɛ́chúɔp mpok Kristo, Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò, mkpák bachǐmbɨ Yesu ɛbhak byo nɛ ɛnwi. ");
INSERT INTO kenNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ɛnyu ɛ́fákárí nyaka kɛ bábhé Yesu Kristo: María achí nyaka nnɔ Yesu. Mpok yɔ Josɛ́f atɨ bɛ́bhay yi. Kɛ bápɛ́rɛ rɨŋɨ batɨ, ɛ́fákari bɛ María achi nɛ mɛniɛ. Apɔkɔ mɛniɛ bhɔ chí ndǔ bɛtaŋ Ɛfóŋó Bɛdyɛrɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josɛ́f abhak chak bɛsí Mandɛm. Ɛ́kʉ́ yí kɛyáŋ bɛchyɛ María ntíánwɔ́p. Akʉ yɛ ntɨ bɛway nɛbhay nɛ María ansɛm ansɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kɛ ɛnɛ́ Josɛ́f ákàysi ndak anɛ, Mandɛm ató ángɛl ywi amɔt ntá Josɛ́f ndǔ kɛnɔ́. Ángɛl wu aghati yi bɛ, “Josɛ́f, ɛbhárɛ́mɔ Debhít, kɛ́chay bɛsɔt María ndǔ nɛbhay, apɔ́kɔ́ mɛniɛ chi ndǔ bɛtaŋ Ɛfóŋó Bɛdyɛrɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nɛ chɔŋ ambé mɔ́mbakanɛm. Nnyɛ́n ɛni nɛ́mbak bɛ Yesu, mbɔnyunɛ chɔŋ yí ampɛmɛ bɔ̌bhi ndǔ ntɛmsi bɛbʉ́ bhap.” ");
INSERT INTO kenNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Mɛnyɨŋ ɛbhɛn mɛnkɛm bɛ́fákárí bɛ ɛnyɨŋ ɛnɛ Mandɛm ághátí ndɛmɛkɛpɨ̌ntɨ andɛm, ɛmfu tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Arɛm nyaka bɛ, “Chɔŋ Ngɔsɔ́ŋ anɛ ábhɨ́kɨ́ re rɨŋɨ mbakanɛm ampɔkɔ mɛniɛ ambé mɔ́mbakanɛm, nnyɛ́n ɛni nɛmbak bɛ Ɛmánuɛl”, nɔ́ chí bɛ, “Mandɛm achi nɛ bhɛsɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josɛ́f áŋɛ́mɛ́ nɔ́kɔ́ ndǔ kɛnɔ́, akʉ nkúbhɛ́ mbɔ ɛnyǔ ángɛl Mandɛm aghati yi. Asɔt María ndǔ nɛbhay. ");
INSERT INTO kenNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Yɛ̌ nɔ́, bɔ́ kɛrɨŋɨ batɨ kpátɛ María abhe Mɔ́ywi. Ábhé nɔ́kɔ́, Josɛ́f arɛm bɛ nnyɛ́n mmɔ́ chi Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Bábhé Yesu ɛtɔk Bɛ́tlɛhɛm atú Judɛ́ya. Mpok yɔ, Hɛ́rɔd abhak Mfɔ atú wu. Nɛbhé bábhé Yesu, bo abhɛn bárɨŋɨ ɛ̌ti mambe báfú atú mmok áfù batwɔ Yerúsalɛm, mámbɛbhɛ nɔkɔ bɛ, ");
INSERT INTO kenNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Mmɔ anɛ bábhé bɛ́ ámbák Mfɔ bo Israɛl achí fá? Sɛ́bhɛ̀p mbɔnyunɛ sɛ́ghɔ̀ nɛmbe ɛnɛ́n nɛ́rɛ̀m ɛ̌ti nɛbhe ɛni awu atú mmok áfù, nɛ sɛ́twɔ bɛchyɛ yi kɛnókó.” ");
INSERT INTO kenNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mfɔ Hɛ́rɔd ághókó nɔ́kɔ́ ɛnyɨŋ ɛnɛ bǒbhɔ bárɛ́mɛ́, ntí átáka yi amɛm. Ɛ́bhák ɛnyumɔ́t nɛ bǒ mankɛm amɛm ɛtɔk Yerúsalɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Hɛ́rɔd abhɨŋɨ bǒbatí bachiǎkap Mandɛm nɛ batɔŋ ɛbhé Mandɛm ndǔ nɛbhʉɛt amɔt. Abhɛ́p bhɔ bɛ, “Bábhɔŋ bɛbhe Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò fá?” ");
INSERT INTO kenNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Bágháti yi bɛ, “Bábhɔŋ bɛbhe yi ɛtɔk Bɛ́tlɛhɛm, fá atú Judɛ́ya, mbɔnyunɛ ɛchi amɛm ɛkáti ndɛmɛkɛpɨ̌ntɨ bɛ, ");
INSERT INTO kenNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Mandɛm arɛm bɛ, ‘Wɔ Bɛ́tlɛhɛm ndǔ mmɨk Júda, puyɛ̌ wɔ kɛ ɔ́chí ansɛm ndǔ bɛtɔk Júda mɛnkɛm, mbɔnyunɛ ntá yɛ kɛ̌ Mfɔ áfù. Mfɔ anɛ ákɛ̀m bǒbha, bo Israɛl, mbɔ ɛrɨ́tɨ́ mbabhɛri bághɔ́ŋɔmɛ́n ákɛ̀m bághɔ́ŋɔmɛ́n yi.’” ");
INSERT INTO kenNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Hɛ́rɔd ághókó nɔ́kɔ́ nɔ́, abhɨŋɨ mankɔ bhɔ, abhɔ́ŋ kɛpɨ nɛ bhɔ ansɛm ansɛm, abhɛ́p bhɔ bɛ́ mángátí yi mpok anɛ bɔ baghɔ nɛmbe ɛnɔ atú ɛtɔk yap. ");
INSERT INTO kenNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Aghati yɛ bhɔ bɛ, “Dɔ́k ká Bɛ́tlɛhɛm, mǎmbɛp sayri nɛbhʉɛt anɛ mɔ́wu achi. Mǎnáŋ mǎngɔ́ yi, pɛt ká nsɛm mǎngati mɛ, bɛ́ mɛ nkwɔ́ ndɔ́k nchyɛ́ yi kɛnókó.” ");
INSERT INTO kenNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Mankɔ̌ bhɔ bághókó nɔ́kɔ́ ɛnyɨŋ ɛnɛ Mfɔ Hɛ́rɔd árɛ́mɛ́, báfá bare rɔŋ. Ndǔ bárɔ̀ŋ, bághɔ́ nkúbhɛ́ nɛmbe ɛnɛ́n báyámbɨ baghɔ atú ɛtɔk ɛyap nɛ nɔ́ nɛ́rɔ́ŋ nɔ́kɔ́ ambɨ, bɔ́ mánkoŋo nɔkɔ ansɛm. Báchwɔ́bhɛ́ nɔ́kɔ́ Bɛ́tlɛhɛm, nɛmbe ɛnɔ nɛ́te amfay nɛbu, tɛ́bhɛ́ tɛ́bhɛ́ nɛ ɛkɛt ɛnɛ́ mɔ́wu áchí arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nɛghɔ́ bághɔ́ nɛmbe ɛnɔ, maŋák amap aya acha. ");
INSERT INTO kenNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bághɔ́ ɛkɛt ɛnɛ nɔ́ nɛ́té arɛ tɛbhɛ tɛbhɛ, barɔk bachwe amɛm, baghɔ mmɔ́ nɛ máyi María. Bátɛ́p mánɛ́n amɨk bare chyɛ yi kɛnókó. Mánɛ́nɛ bɛbha bhap bafɛrɛ mɛnyɨŋ ɛbhɛn bɛ́yá nkáp báchyɛ́ mbɔ awap akap ntá yi. Ɛ́mɔt ɛbhak pú, ɛ́chák ɛ́bhák ɛnyǔ sɛrwɔ́ ɛsɛn bádùrɛ sɛ́nchyɛ nɔkɔ ɛrɨ́tí ɛriɛp. Ɛnɛ́fú ɛ́bhák ɛnyɨŋ ɛnɛ́ básɔ̀t bɛghoko ngú bɛ ákɛ́ chɔŋti. ");
INSERT INTO kenNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mankɔ bhɔ bápɛ́rɛ́ gurɛ, Mandɛm asɛmti bhɔ ndǔ kɛnɔ́ bɛ́ bákɛ́ pɛtnsɛm ntá Mfɔ Hɛ́rɔd. Báfʉɛ́t chí ndǔ mbi achak kɛ bágurɛ ɛtɔk ɛyap. ");
INSERT INTO kenNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Bǒ bhɔ nɔ́ batwɔ bɛghɔ Yesu bagurɛ nɔkɔ, ángɛl Mandɛm abhesi ntá Josɛ́f ndǔ kɛnɔ́ ɛkɛ́n yi aghɔ aghati yi bɛ, “Josɛ́f, Hɛ́rɔd ǎyàŋ mbi bɛway mɔ́nɛ. Faté yɛ́, sɔt mmɔ́ nɛ máyi, bʉɛ́ dɔ́k ɛtɔk Íjip. Dɔ́k, ɔ́mbák árɛ́ kpátɛ ngati wɔ ɔ́mpɛ́tnsɛm.” ");
INSERT INTO kenNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josɛ́f aŋɛmɛ, asɔt mmɔ́ nɛ máyi, afa, arɔk ɛtɔk Íjip nɛ bhɔ nkúbhɛ́ bɛti ɛbhɔ mbɔ ɛnyǔ ángɛl Mandɛm aghati yi. ");
INSERT INTO kenNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ágháká nɔ́kɔ́ arɛ́, abhak arɛ kpátɛ Mfɔ Hɛ́rɔd agú. Mɛnyɨŋ bɛ́fákárí nyaka ɛnyu ɛyɔ bɛ́ ɛnyɨŋ ɛnɛ Mandɛm ághátí ndɛmɛkɛpɨ̌ntɨ andɛm, ɛmfu tɛtɛp bɛ, “Mbɨ́ŋɨ́ mɔ́wa bɛ ámfá ɛtɔk Íjip”. ");
INSERT INTO kenNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hɛ́rɔd ághɔ́ nɔ́kɔ́ bɛ mankɔ̌ bhɔ bárwɔ yi ndǔ yi ánóŋó bhɔ kɛghɔ́, ntɨ nɛ́nɛn yi amɛm. Achyɛ ɛyɔŋ bɛ mángwáy bɔ̌babhakanɛm mankɛm abhɛn bábhɨ́kɨ́ cha mamiɛ́ apay ndǔ ɛtɔk Bɛ́tlɛhɛm nɛ ndǔ bɛtɔk ɛbhɛn bɛchi kɛkwɔt. Hɛ́rɔd atɨk bɛ́ ɛ́náŋ ɛ́chí mamiɛ́ apay bɛ́bhó mpok mankɔ bhɔ báyámbɨ baghɔ nɛmbe mpok bábhé Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ɛ́kʉ́ ɛnyɨŋ ɛnɛ ndɛmɛkɛpɨ̌ntɨ Jeremáya árɛ́mɛ́ bɛ́ chɔŋ ɛ́mfakari, ɛmfu tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Arɛm nyaka bɛ, “Ɛyɔŋɔ́ kɛbhɔ ɛ́fù ɛtɔk Ráma. Kɛbhɔ kɛ́yá nɛ bása. Ráshɛl ǎdì bɔ̌bhi. Mánɨ̀k yi mmʉɛt bɛ ambɔt kɛbhɔ kɛ apú ka mbɔnyunɛ bágu barɔ yi.” ");
INSERT INTO kenNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Hɛ́rɔd ágú nɔ́kɔ́, ángɛl Mandɛm abhesi ntá Josɛ́f ndǔ kɛnɔ́ amɛm ɛtɔk Íjip, ");
INSERT INTO kenNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","aghati yi bɛ, “Josɛ́f, faté sɔt mmɔ́ nɛ máyi pɛtnsɛm ndǔ mmɨk Israɛl. Bo abhɛn báyàŋ nyaka bɛway mmɔ́ manaŋ bagu.” ");
INSERT INTO kenNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Josɛ́f aŋɛmɛ, asɔt nnɔ nɛ mmɔ́ apɛtnsɛm ɛtɔk Israɛl. ");
INSERT INTO kenNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kɛ Josɛ́f ághókó nɔ́kɔ́ bɛ́ Akɛlos asɔt ɛpok ɛtayi mbɔ Mfɔ atú ɛtɔk Judɛ́ya, acháy bɛrɔŋ arɛ́. Ndǔ kɛnɔ́ kɛ́chák, ángɛl Mandɛm ayɛp Josɛ́f batú bɛ yi ándɔ́k chí atú Gálili. ");
INSERT INTO kenNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Josɛ́f arɔk, achɔkɔ amɛm ɛtɔk Gálili ɛnɛ́ bábhɨ̀ŋɨ bɛ Násárɛt, mbɔnyunɛ ɛ́chí amɛm ɛkáti ndɛmɛkɛpɨ̌ntɨ bɛ Mandɛm arɛm ɛ̌ti Kristo bɛ, “Chɔŋ bo mámbɨŋɨ yi bɛ ‘Mmu Násárɛt’”. ");
INSERT INTO kenNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mpok yɔ, Jɔ̌n Njwiti abho bɛ́gháti bho amɛm baso atú Judɛ́ya bɛ, ");
INSERT INTO kenNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Yɛ̌ntɨkɨ mmu ywɛka abhɔŋ bɛtɨknsɛm ndǔ bɛbʉ́ bhi mbɔnyunɛ mpok Mandɛm ábhák nɛ bo mbɔ Mfɔ wap arɔp chi kɛkwɔt.” ");
INSERT INTO kenNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jɔ̌n Njwiti kɛ̌ Aisáya ndɛmɛkɛpɨ̌ntɨ Mandɛm árɛ̀mɛ nyaka ɛ̌ti yi bɛ, “Mmu achi amɛm baso ǎbɨ̀k nɛ ɛyɔŋ amfay andɛmɛ nɔkɔ bɛ, ‘Toŋtí ká mbi anɛ Acha áfʉɛ̀t arɛ. Kʉ́ ka mbǐ ywi ambak chak.’” ");
INSERT INTO kenNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nkú Jɔ̌n abhak chi ɛnyɨŋ ɛnɛ baghoko nɛ babyɔk mpɔŋɔ baso. Mgbat anɛ yi ágwɔ̀t ɛbho abhak nkwɔbhɛ́nya, nɛ nɛnyíɛ́ ɛni nɛ́bhak ngɛ́mtáy nɛ bawɛrɛ́ bɛtu ámɛ́n yi ághɔ̀ amɛm baso. ");
INSERT INTO kenNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Bɛyǎ bho báfú, bárɔ́k ntá Jɔ̌n ndu bɛghok ɛnyɨŋ ɛnɛ yi árɛ̀m. Báfú ɛtɔk Yerúsalɛm, nɛ atú Judɛ́ya ankɛm, nɛ bɛtɔk mɛnkɛm ɛbhɛn bɛchi kɛkwɔt nɛ Nnyɛ́n Jɔ́dan. ");
INSERT INTO kenNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Báré su bɛbʉ́ bhap, Jɔ̌n anjwiti nɔkɔ bhɔ amɛm Nnyɛ́n Jɔ́dan. ");
INSERT INTO kenNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kɛ Jɔ̌n ághɔ́ nɔ́kɔ́ ndǔ bɛyǎ bǒnkwɔ Fárisi nɛ bǒnkwɔ Sádusi bátwɔ̀ bɛ yi anjwiti bhɔ, abho bɛ́rɛm ntá yap bɛ, “Bě bɛfé! Agha áyɛ́bhɛ́ be batú bɛ mǎnjaŋ mbi bɛbʉɛ ntɛmsi Mandɛm anɛ átwɔ̀? ");
INSERT INTO kenNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Bǎbhɔŋ bɛkʉ mɛnyɨŋ ɛbhɛn bɛ́tɔ̀ŋ bɛ mǎnáŋ bǎtɨknsɛm ndǔ bɛbʉ́ ɛbhɛka tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Bǎkɛ́ chɔkɔ mǎnkáysi bɛ bǎchí bɛbhárɛ́bhɔ Ábraham nɛ yɛ̌nyɨŋ ɛpu kway bɛkʉ bhe. Dɨŋɨ́ ká bɛ Mandɛm ǎkwáy bɛsɔt batay anɛ ankʉ yɔ́ ámbak bɛbhárɛ́bhɔ Ábraham. ");
INSERT INTO kenNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Yɛ̌ chí nɛ́nɛ, sɛtɨ sɛ́chí bhʉɛrɛ́, nɛ bákway bɛkpɔt yɛ̌ntɨkɨ ɛnɔk ɛnɛ ɛpu nyu bɛrɨ́tɨ́ kɛpɛm tɛ ndǔ bakaŋ, mangʉɛp angó.” ");
INSERT INTO kenNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Mɛ̌jwìti bhe nɛ manyiɛp bɛtɔŋ bɛ́ bǎtɨknsɛm ndǔ bɛbʉ́ ɛbhɛka. Kɛ mmǔ anɛ átwɔ̀ mɛ ansɛm achá mɛ ɛnyunɛ mbɨ́kɨ́ kway mmu anɛ nchí kaŋari nkwɔbhánya bɛkak ɛbhi. Ántwɔ́, chɔŋ anjwiti bhe nɛ Ɛfóŋó Bɛdyɛrɛ nɛ ngó. ");
INSERT INTO kenNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ǎtwɔ̀ nɛ nchán myákátí awɔ bɛ́chák nkway ndǔ bɛ́fáp ɛnɛ ɛ́rɨ́ nɛ bɛkpáfu. Ánáŋ ánkʉ́ nɔ́, ǎsɔt mbwɔt antɛn ndǔ nkpánɛ́, anyɔ mmɨk, ansɔt bɛkwɔp ɛbhi amfyɛ ndǔ ngo anɛ apu nɛmɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ɛ́bhɨ́kí tat, Yesu afú atú Gálili arɔk ndǔ Nnyɛ́n Jɔ́dan bɛ Jɔ̌n anjwiti yi. ");
INSERT INTO kenNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kɛ Jɔ̌n kɛyaŋ bɛjwiti Yesu. Are yáŋ bɛkʉ Yesu anjibhiri nkaysi yi. Arɛm bɛ, “Ɔtwɔ bɛ njwítí wɔ, ɛnɛ́ mɛ kɛ mbɔ́ŋɔ́ bɛ́twɔ ntá yɛ bɛ ɔ́njwítí mɛ́?” ");
INSERT INTO kenNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yɛ̌ nɔ́, Yesu akɛmɛ yi chi bɛ, “Dɔ̌ ɛ́mbák mbɔ ɛnyǔ ngátí wɔ́, mbɔnyunɛ ɛrɨ bɛ sɛnkʉ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ Mandɛm áyàŋ.” Jɔ̌n aka yɛ, ajwiti Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nɛjwiti Jɔ̌n ájwítí yi, Yesu afú anyɛ́n. Nɛbu nɛ́nɛ́nɛ, aghɔ ndǔ Ɛfóŋó Mandɛm áfú amfay, asɔt mkpá ɛbhóŋó are sɛp kpát ate yi amʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ɛyɔŋ ɛ́fú yɛ amfay ɛ́ré rɛm bɛ, “Nɛ́ chí Mɔ́wa. Nkɔŋ yi tontó. Ǎchyɛ̀ mɛ bɛyǎ maŋák.” ");
INSERT INTO kenNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ɛ́fʉɛ́rɛ́ nɔ́kɔ́ nɔ́, Ɛfóŋó Bɛdyɛrɛ akʉ Yesu arɔk amɛm baso bɛ Satan amɔ yi. ");
INSERT INTO kenNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Arɛ́ amɛm baso, Yesu abhak ndǔ nɛtarɛ́nsay bɛti nɛ ngósí ndǔ manywɔp bɛsa bɛpay. Nsay akɛ́m yi. ");
INSERT INTO kenNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Satan arɔk ntá yi, arɛm bɛ, “Mbák ɔ́chí Mmɔ Mandɛm tɛtɛp, chyɛ ɛyɔŋ bɛ batay anɛ anjibhiri andɔp bɛkpɔkɔ́ brɛt.” ");
INSERT INTO kenNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kɛ Yesu akɛmɛ yi bɛ, “Ɛ́chí amɛm Ɛkáti Mandɛm bɛ, ‘Puyɛ̌ nɛnyíɛ́ nɔ́nɔ́ kɛ nɛ́kɛ̀m nɛpɛ́m. Yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ Mandɛm árɛ̀m kɛ̌ ɛ́bhɔ́ŋ bɛtaŋ bɛkɛm nɛpɛ́m mmu.’” ");
INSERT INTO kenNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Satan asɔt yi barɔk Yerúsalɛm, ɛtɔk Mandɛm, bákó ndǔ nɛbhʉɛt anɛ áchí tɛ amfay ndǔ ɛkɛrákap Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Arɛ́, arɛm ntá Yesu bɛ, “Mbák ɔchí Mmɔ Mandɛm, dók, tɛ̌ndu ɛchi amɛm Ɛkáti Mandɛm bɛ, ‘Chɔŋ Mandɛm anchyɛ ɛyɔŋ bɔángɛl bhi mántwɔ́ manchyɛ wɔ nɛkwak. Ɛkáti Mandɛm ɛ́pɛt ɛ́rɛ̀m bɛ, chɔŋ mánkpʉɛp wɔ nɛ amɔ́ yap bɛ́ ɔ́kɛ́ tɛm ɛkak ndǔ ntay.’” ");
INSERT INTO kenNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu akɛmɛ yi bɛ, “Ɛkáti Mandɛm ɛ́pɛt ɛ́rɛ̀m bɛ, ‘Kɛ́mɔ Mandɛm Acha ywɛ.’” ");
INSERT INTO kenNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Bɛ́fú afɔ, Satan asɔt Yesu ndǔ njiɛ anɛ áré sáp amfay, atɔ́ŋ yi bɛtɔkɔ́ mmɨk mɛnkɛm nɛ kɛfɔ ɛkɛn kɛ́chí arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Arɛm yɛ ntá Yesu bɛ, “Chɔŋ nchyɛ́ wɔ mɛnyɨŋ ɛbhɛn mɛnkɛm mbák ɔ́ntɛ́p mánɛ́n bɛsí bha, ɔnchyɛ mɛ kɛnókó.” ");
INSERT INTO kenNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kɛ Yesu aghati yi bɛ, “Fǎ mɛ bɛsí, wɔ Satan! Ɛkáti Mandɛm ɛ́rɛ̀m bɛ ‘Mmu abhɔŋ bɛchyɛ kɛnókó chi ntá Mandɛm Acha, antók chí yi aywǐnti.’” ");
INSERT INTO kenNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Satan arɔ yɛ Yesu arɔk, bɔángɛl Mandɛm barɔk bachyɛ Yesu nɛkwak. ");
INSERT INTO kenNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Mpok Yesu aghoko bɛ bákɛ́m Jɔ̌n Njwiti báfyɛ ɛkɛrɛ́kɛnɔŋ, afa atú Judɛ́ya apɛtnsɛm atú Gálili. ");
INSERT INTO kenNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kɛ yí kɛrɔ́ŋ Násárɛt. Arɔk achɔkɔ Kapɛ̌naum. Ɛtɔk Kapɛ̌naum ɛ́bhák nɛpak manyu Gálili, atú Sɛ́bulɔn nɛ Náftali. ");
INSERT INTO kenNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ɛ́fákárí nyaka ɛnyu yɔ bɛ ɛnyɨŋ ɛnɛ Mandɛm ághátí ndɛmɛkɛpɨ̌ntɨ Aisáya andɛm ɛ́mfú tɛtɛp. Aisáya arɛm nyaka bɛ: ");
INSERT INTO kenNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Mmɨk Sɛ́bulɔn nɛ Náftali, mmɨk anɛ bo báfʉɛ̀t arɛ bɛrɔŋ ndǔ ɛ̌ntɨ́ŋnyɛn ɛnɛ́ bábhɨ̀ŋɨ bɛ Manyu Gálili, mmɨk anɛ áchí ɛbhěnyɛn nɛgho Jɔ́dan, atú Gálili anɛ bɛyǎ bo abhɛn bápú bo Israɛl bachi arɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bǒ abhɛn báchí amɛm ɛjuri, bághɔ bɛyǎ bɛdiɛ́rɛ́. Bǒ abhɛn báchí ndǔ mmɨk ndɨ́kándǐ nɛwu, mbaŋ ǎghɔ ɛtɔk ɛyap nɛ́nɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nɛbho mpok yɔ, Yesu abho bɛ́gháti bho bɛ, “Yɛ̌ntɨkɨ mmu abhɔŋ bɛ́tɨknsɛm ndǔ bɛbʉ́ bhi mbɔnyunɛ mpok anɛ Mandɛm ábhák nɛ bho mbɔ Mfɔ wap arɔp chi kɛkwɔt.” ");
INSERT INTO kenNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ɛwak ɛ́mɔt, ɛnɛ́ Yesu ákɔ̀ nɛpak manyu Gálili, aghɔ́ bo bati apay, bɔ̌ nnɔ amɔt chi amɔt. Amɔt aka nnyɛ́n bɛ Símun. Nnyɛ́n ɛni nɛ́chák nɛ́bhák bɛ Píta. Manɔ́ ywi aka nnyɛ́n bɛ Andru. Bɔ bati apay bare gʉɛp bɛyǎ nkáp anyɛ́n ndu bɛway nsi mbɔnyunɛ bachi nyaka bawǎnsi. ");
INSERT INTO kenNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu arɛm ntá yap bɛ, “Twɔ́ ká bhák bakoŋo bha, nɛ chɔŋ ntɔŋ be ɛnyǔ bǎkʉ bɛ́ bo bachak mámbák bakoŋo bha.” ");
INSERT INTO kenNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tɛ́mté wu, Símun nɛ manɔ́ barɔ bɛyǎ nkáp yap, bakoŋo Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesu átɛ́n nɔ́kɔ́ mmʉɛt ambɨ mandú, aghɔ́ bɔ̌ nnɔ amɔt chi amɔt bachak bati apay, nɔ chi, Jems nɛ Jɔ̌n, bɔ̌ Sɛbɛdi. Bábhák amɛm áchwí chɔkɔ nɛ ɛtayap Sɛbɛdi, mángoko nɔkɔ bɛyǎ nkáp yap. Yesu abhɨŋɨ bhɔ nkwɔ bɛ mámbák bakoŋo bhi. ");
INSERT INTO kenNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tɛ́mté wu, bárɔ́ áchwí wap nɛ ɛtayap, bákoŋo yi. ");
INSERT INTO kenNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu abho bɛkɔ atú Gálili ankɛm antɔŋ nɔkɔ bho Ɛyɔŋ Mandɛm amɛm bɛkɛrɛ́ nɛnɨkɨ́mʉɛt bo Israɛl, angati nɔkɔ bhɔ nkwɔ Mbok Ndɨ́ndɨ́ anɛ árɛ̀m ɛnyǔ Mandɛm ábhák nɛ bhɔ mbɔ Mfɔ wap. Nɛ ambu nɔkɔ yɛ̌ntɨkɨ ɛnyǔ nɛme ɛnɛn bo babhɔŋɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ɛ́kʉ́ nnyɛ́n Yesu nɛ́táka kpát nɛ́gháka atú Síria ankɛm. Bo báré pɔkɔ́ bǒ abhɛn bábhɔ́ŋɔ́ mame mɛnyu nɛ mɛnyu mándɔk nɔkɔ ntá Yesu bɛ ámbú bhɔ. Mbɔk yap bábhák bo abhɛn bɛfóŋó bɛbʉ́bɛbʉ bɛ́sɔ̀ŋɔri bhɔ, báchák bábhák bǒ abhɛn bákwɛ̀n ntímɛn, abhɛ́nɛ́fú babhak bǒ abhɛn bachi bhʉrɛ́. Yesu abú bhɔ mankɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Bɛyǎ bhó bare fú mbaŋ nɛ mbaŋ mánkoŋo nɔkɔ Yesu yɛ̌ntɨkɨ ɛbhak ɛnɛ yi árɔ̀ŋ. Mbɔk ɛyap báfú atú Gálili, báchák báfú Dikápolis, nɔ chi atú bɛtɔk byo, báchák báfú Yerúsalɛm, báchák báfú atú Judɛ́ya, nɛ abhɛ́nɛ́fú báfú ɛbhěnyɛ́n nɛgho ɛnɛn babhɨŋɨ bɛ Jɔ́dan. ");
INSERT INTO kenNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ɛwak ɛ́mɔt, bo báré twɔ ntá Yesu ndǔ bakwɔ́. Aghɔ́ nɔ́kɔ́ bhɔ́, arɔk achɔkɔ ambɨ njiɛ. Bakoŋo bhi bákó bátɛ́mɛ́ri yi, bachɔkɔ nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Abho bɛtɔŋ bhɔ mɛnyɨ. ");
INSERT INTO kenNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Are tɔ́ŋ andɛm nɔkɔ bɛ, “Ɛ́rɨ ɛcha ntá yɛ̌ntɨkɨ mmu anɛ ághɔ́ bɛ bɛsí Mandɛm, yi apu yɛ̌nyɨŋ, mbɔnyunɛ Mandɛm achi Mfɔ ywi! ");
INSERT INTO kenNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ɛ́rɨ ɛcha ntá bǒ abhɛn báchí ndǔ nɛdǐ kɛbhɔ nɛ́nɛ; mbɔnyunɛ chɔŋ mánchyɛ bhɔ́ nɛpɔptí ntɨ! ");
INSERT INTO kenNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ɛ́rɨ ɛcha ntá bǒ abhɛn bábhɔ́ŋɔ́ nɛsɛptǐmʉɛt nɛ bápú tɔŋ bɛtaŋ, mbɔnyunɛ chɔŋ yí anchyɛ bhɔ áfɔ́k ankɛm anɛ yi afyɛ́ bariɛp bɛchyɛ bhɔ́! ");
INSERT INTO kenNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ɛ́rɨ ɛcha ntá bǒ abhɛn bábhɔ́ŋɔ́ nsay nɛ ɛkwak bɛkʉ mɛnyɨŋ ɛbhɛn bɛchi chak bɛsí Mandɛm, mbɔnyunɛ chɔŋ yi anchyɛ bhɔ mɛnyɨŋ ɛbhɛn bábhɔ́ŋɔ́ ɛkwak bɛbhɔŋ! ");
INSERT INTO kenNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ɛ́rɨ ɛcha ntá yɛ̌ntɨkɨ mmu anɛ ághɔ̀ bho ntínso, mbɔnyunɛ chɔŋ Mandɛm angɔ́ yi ntínso! ");
INSERT INTO kenNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ɛ́rɨ ɛcha ntá bǒ abhɛn batɨ yap áchí amɛm pɛ́pɛ́p, mbɔnyunɛ chɔŋ Mandɛm ankʉ bɔ́ mángɔ́ yi! ");
INSERT INTO kenNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ɛ́rɨ ɛcha ntá bǒ abhɛn mánù bɛ bo mámbák ɛyɔŋ ɛ́mɔt nɛ batɨ; mbɔnyunɛ chɔŋ Mandɛm ankʉ bɔ mámbak bɔ̌bhi! ");
INSERT INTO kenNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ɛ́rɨ ɛcha ntá yɛ̌ntɨkɨ mmu anɛ bo báchyɛ̀ ɛsɔŋɔri ndǔ ákʉ̀ mɛnyɨŋ ɛbhɛn bɛchi chak bɛsí Mandɛm. Ǎyɛt yi mbɔnyunɛ achí Mfɔ ywi! ");
INSERT INTO kenNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ɛ́rɨ ɛcha ntá yɛka mpok bo básɔ̀kɔti bhe nɛ mpok anɛ báchyɛ̀ bhe ɛsɔŋɔri, mámbarɛ nɔkɔ bhe barak amʉɛt ndɛ́ndɛm ɛ̌ti ya. ");
INSERT INTO kenNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ŋák ká nɛ mǎmbɔ́ŋ maŋák mbɔnyunɛ Mandɛm abhʉ́rɛ́ bhe ɛrɛm akap awu amfay. Nɛ bǎkɛ́ ghɔkɔntɨk bɛ báchyɛ̀ nyaka barɛmɛ́ kɛpɨ̌ntɨ abhɛn tɛsáy ɛsɔŋɔri nkwɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Bǎchí mbɔ ngáŋ ntá bǒ mmɨk mankɛm. Kɛ mbák ngáŋ ábhɨ́kɨ́ pɛrɛ bhɔ́ŋ manyɨŋti mi, ná bákway bɛkʉ wu ampɛt ambak ɛrɨ́tí ngáŋ? Bápú pɛrɛ kway bɛkʉ yɛ̌nyɨŋ nɛ wu. Árɔp chi ɛnyɨŋ bɛto nɛfí ɛbhak ɛnɛ bo báfʉɛ̀t mánjati nɔkɔ wu. ");
INSERT INTO kenNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Bǎchí ɛrɔ́ŋɔ́ ntá bǒ mmɨk. Ɛtɔk ɛnɛ́ ɛ́chí amfǎy njiɛ ɛ́pú bhɛsɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nɛ bápú durɛ ɛrɔ́ŋɔ́ mánsɔt ɛnyɨŋ mánkuti. Bádurɛ ɛrɔ́ŋɔ́ mánte chi ɛbhak ɛnɛ bábhɔ́ŋɔ́ bɛte yɔ bɛ́ mbaŋ ángɔ ntá yɛ̌ntɨkɨ mmu anɛ achi anywɔ́p. ");
INSERT INTO kenNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Dɔ̌ yɛ́ ka ɛpɨŋ ɛyɛka ɛ́ngɔ́ mbɔ ɛrɔ́ŋɔ́. Ɛpɨŋ ɛyɛka ɛ́bhɔŋ bɛbhak mbɔ ɛrɔ́ŋɔ́ bɛ́ bo mángɔ́, mámbɨti Ɛtayɛka mmu achi amfay.” ");
INSERT INTO kenNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Bǎkɛ́ kaysi bɛ́ ntwɔ bɛ́fɛ́rɛ bɛbhé Moses. Bǎkɛ́ kaysi bɛ́ ntwɔ chí bɛfɛrɛ basɨŋɨ́ barɛmɛ́ kɛpɨ̌ntɨ. Mbɨ́kɨ́ twɔ́ bɛ́fɛ́rɛ mɔ́, ntwɔ chí bɛkʉ bɛ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ bɔ básɨ́ŋɨ́ ɛ́mfú tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tɛtɛp, nchí ghati bhe bɛ tɛ mfǎy ámfʉɛt, mmɨk amfʉɛt, bápú kwáy bɛfɛrɛ yɛ̌ mandú ɛnyɨŋ ndǔ basɨŋ amɛn wáwák. Basɨ́ŋ amɛn ǎbhák kpátɛ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ básɨ́ŋɨ́ ɛ́mfu tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Yɛ̌ agha anɛ ápú bhʉɛrɛ yɛ̌ chí mɔ́bhé amɔt, antɔŋ nɔkɔ bo bachak bɛ mánkʉ́ ɛnyumɔt mbɔ yi, chɔŋ ambak ansɛm ndǔ nkwɔ bhó mankɛm abhɛn Mandɛm achi Mfɔ wap. Kɛ mmu anɛ ábhʉ̀rɛ bɛbhé Mandɛm mɛnkɛm, antɔŋ nɔkɔ bo bɛ mankʉ nkwɔ mbɔ yi, ǎbhák mǔngo ndǔ nkwɔ bho abhɛn Mandɛm achi Mfɔ wap. ");
INSERT INTO kenNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nchí ghati yɛ be bɛ, mbák mɛnyɨŋ ɛbhɛn bǎkʉ̀ bɛbhɨkɨ cha ɛbhɛ́n batɔŋ ɛbhé Mandɛm nɛ ɛbhɛn bǒnkwɔ Fárisi, bǎpú bhák bo abhɛn Mandɛm achi Mfɔ wap.” ");
INSERT INTO kenNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Bǎrɨŋɨ ndǔ ɛbhé Moses ɛ́ghàti nyaka bachǐmbɨ bhɛka bɛ mmu ákɛ́ wáy ntɨ, nɛ yɛ̌ agha anɛ áway mmu, bákʉ̀ manyé nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kɛ ɛnyɨŋ ɛnɛ nchí ghati bhe chi bɛ, yɛ̌ agha anɛ ábèntɨ nɛ mɔ́mayi Mandɛm ǎtaŋ yi. Yɛ̌ agha anɛ ásɔ̀kɔti mɔ́mayi mbɔ bɛrɛm bɛ, ‘Wɔ ɔchí agha?’ Básɔ̀t yi bɛsi acha manyɛ́. Nɛ yɛ̌ agha anɛ árɛ̀m ntá mɔ́mayi bɛ, ‘Wɔ ɛchɨŋtímu’ chí mmu anɛ bábhɔ́ŋɔ́ mɛmɛsɛ amɛm nɛpǐngo. ");
INSERT INTO kenNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Mbák ɔ̌rɔ̀ŋ yɛ bɛchyɛ akap ntá Mandɛm kɛ ɔ́ntɨk bɛ ntɨ manɔ́ ǎbè ntɨ ɛ̌ti ɛnyɨŋ ɛnɛ́ ɔ́kʉ́ yi, ");
INSERT INTO kenNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","dɔ̌ akap aywɛ ndǔ nɛbhʉɛt anɛ bo báchyɛ̀ akap, dɔ́k kpɨ́k kʉ mǎmbák ɛyɔŋ ɛ́mɔt nɛ yi kɛ ɔ́mpɛtnsɛm ɔnchyɛ akabhɛ ywɛ ntá Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Mbák mmu abhɔŋ ndak nɛ wɔ, antí wɔ, dɔ́k tɛmɛrí yi ayak mǎnsokori ndak wu, mǎmbak ɛyɔŋ ɛ́mɔt. Mbák ɔ́bhɨ́kɨ́ kʉ nɔ, mpok ámfʉɛ́t, yi andɔk ntá ntaŋá manyé nɛ wɔ, afyɛ́ wɔ amɔ yi, nɛ yi anchyɛ wɔ ntá bo mbɨ̌ŋ nkú, nɛ bɔ́ mámfyɛ wɔ ɛkɛrɛ́kɛnɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Dɨŋɨ́ bɛ mbák ɛ́mfákárí ɛnyu ɛyɔ, ɔpú fu wawak kpátɛ ɔnchyɛ ákwɔ́ ywɛ ankɛm, yɛ̌nyɨŋ kɛrɔp.” ");
INSERT INTO kenNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Bǎrɨ́ŋɨ́ ndǔ ɛbhé Moses ɛ́rɛ̀m bɛ, ‘Mmu abhɨ́kɨ́ bhɔŋ bɛkwɛn bɛrwɔp.’ ");
INSERT INTO kenNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kɛ nchí ghati bhe bɛ, yɛ̌ agha anɛ afyɛ́ amɨ́k amʉɛt ngɔrɛ́, ambɔ́ŋ nkaysi bɛbhʉɛrɛ nɛ yi, anáŋ akwɛn bɛrwɔp nɛ ngɔrɛ́ wu ndǔ ntɨ ɛni. ");
INSERT INTO kenNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Mbák nyɛ́sɛ́ ɛnɛ nɛmɔt nɛ́tò wɔ ndǔ bɛbʉ́, fɛrɛ́ nɔ gʉɛp. Ɛ́rɨ bɛ ɔ́nɛ́m ɛpókómʉɛt ɛyɛ ɛ́mɔt ɛcha wɔ bɛrɔŋ ambɨ bɛkʉ bɛbʉ́, mánsɔt mmʉɛt ɛyɛ nkɛm mámɛsɛ amɛm nɛpǐngo. ");
INSERT INTO kenNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nɛ mbák awɔ́nɛm ywɛ átò wɔ ndǔ bɛbʉ́, kpɔ́t wú gʉɛ́p. Ɛ́rɨ bɛ ɔ́nɛ́m ɛpókómʉɛt ɛyɛ ɛ́mɔt ɛcha wɔ bɛrɔŋ ambɨ bɛkʉ bɛbʉ́, mánsɔt mmʉɛt ɛyɛ nkɛm mámɛsɛ amɛm nɛpǐngo.” ");
INSERT INTO kenNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ɛbhé Moses ɛpɛt ɛ́rɛ̀m bɛ, ‘Yɛ̌ agha anɛ árɔ ngɔrɛ́ ywi ndǔ nɛbhay, abhɔŋ bɛchyɛ yi ɛkáti ndu bɛtɔŋ bɛ awǎy nɛbhay.’ ");
INSERT INTO kenNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kɛ ɛnyɨŋ ɛnɛ nchí ghati bhe chi bɛ, yɛ̌ntɨkɨ mmu anɛ árɔ̀ ngɔrɛ́ ywi ndǔ nɛbhay ɛnɛ́ ngɔrɛ́ ábhɨ́kɨ́ kwɛn bɛrwɔp, akʉ ngɔrɛ́ akwɛn bɛrwɔp, nɛ yɛ̌ntɨkɨ mbakanɛm anɛ ábháy ngɔrɛ́ anɛ ápɛ́t apu ɛkɛrɛ́nɛbhay, akwɛn nkwɔ bɛrwɔp.” ");
INSERT INTO kenNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Bǎrɨŋɨ ndǔ ɛbhé Moses ɛ́pɛ́t ɛ́ghàti nyaka bachǐmbɨ bhɛka bɛ, ‘Kɛ́ fyɛ́ bariɛp bɛkʉ ɛnyɨŋ ɛnɛ́ ɔ́bhɨ́kɨ́ bhɔŋ ntɨ bɛkʉ yɔ. Mmu abhɔŋ bɛkʉ ɛnyɨŋ ɛnɛ yi áyɨ́kɨ́ bɛkʉ ndǔ nnyɛ́n Mandɛm.’ ");
INSERT INTO kenNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kɛ nchí ghati bhe bɛ mmu abhɨkɨ bhɔŋ bɛyɨkɨ wáwák. Mmu abhɨkɨ bhɔŋ bɛyɨkɨ ambɨŋɨ mfay, mbɔnyunɛ mfay chi bɛchɔ́kɔ́ Kɛfɔ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mmu abhɨkɨ bhɔŋ bɛyɨkɨ ambɨŋɨ mmɨk mbɔnyunɛ mmɨkɨ nɛ achi mbɔ ɛnɔk ɛnɛ Mandɛm ásɨ̀kɨ bɛkak arɛ. Nɛ mmu abhɨkɨ bhɔŋ bɛyɨkɨ ambɨŋɨ Yerúsalɛm, mbɔnyunɛ chi ɛtɔk ɛrɛmɛ́ Mfɔ ywɛsɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kɛ́ yɨkɨ ɔmbɨŋɨ ntí ywɛ mbɔnyunɛ ɔbhɨ́kɨ́ bhɔŋ bɛtaŋ bɛkʉ ɛkaká ɛmɛnɛ ɛ́mbák pɛ́pɛ́p, nɛ ɔbhɨkɨ bhɔŋ bɛtaŋ bɛkʉ yɔ ɛmbak pyɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mbák ɔ́nká bɛkʉ ɛnyɨŋ, dɛm bɛ, ‘Ɛɛ’. Mbák ɔbhɨ́kɨ́ ka bɛkʉ ɛnyɨŋ, dɛm bɛ, ‘Ǎe’. Yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ ɛcha ɛyɔ, ɛ́fù chi ntá mbʉ́mbʉ.” ");
INSERT INTO kenNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Bǎrɨŋɨ bɛ ɛbhé Moses ɛ́rɛ̀m bɛ, ‘Mbák mmu achɔ́ŋtí nyɛ́sɛ́ ntɨ mánchɔ́ŋtí ɛni nkwɔ. Nɛ mbák mmu áfɛ́rɛ́ nɛ́nyɛ́n ntɨ, bábhɔŋ bɛfɛrɛ ɛni nkwɔ.’ ");
INSERT INTO kenNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kɛ nchí ghati bhe bɛ, mbák mmu akʉ wɔ bɛbʉ́, ɔ́kɛ́ kɛmɛ yi. Mbák mmu adɛp wɔ atá ndǔ ɛbhe awɔ́nɛm, tɔ́ŋ yi ɛbhe ɛ́chák nkwɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mbák mmu ǎyàŋ bɛkʉ manyé nɛ wɔ bɛ ánsɔ́t nkú yɛ, kpɨk chyɛ̌ yi ndɛ yɛ nkwɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nɛ mbák ntɛmɛ́ nɛnu anyɛ́rɛ́ wɔ́ bɛ ɔmpɔkɔ ntu ywi ɔndɔk nɛ yi nɛkɔ̌ ntay nɛmɔt, dɔ́k nɛ yi nɛkɔ̌ batay apay. ");
INSERT INTO kenNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mbák mmu anɨ́ŋɨ́ wɔ ɛnyɨŋ ɛnɛ ɔ́bhɔ́ŋɔ́, chyɛ̌ yi yɔ. Nɛ mbák mmu atwɔ ntá yɛ bɛ ɔ́mpúɔ yi ɛnyɨŋ ɔ́kɛ́ nisi bɛkʉ nɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Bǎrɨ́ŋɨ́ ndǔ ɛbhé Moses ɛ́rɛ̀m bɛ, ‘Ɔ́bhɔ́ŋ bɛ́kɔŋ mmǔ ɛtɔk ɛyɛ, ɔ́mpap mmu anɛ ápábhɛ́ wɔ.’ ");
INSERT INTO kenNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kɛ nchí ghati bhe bɛ, kɔŋ ka bǒmpap abhɛka, mǎnɨk nɔkɔ mmʉɛt bɛ Mandɛm ankwak bǒ abhɛn báchyɛ̀ bhe ɛsɔŋɔri. ");
INSERT INTO kenNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mbák bǎkʉ̀ nɔ, bo bághɔ bɛ bǎchí bɔ̌ ɛtayɛka mmu achi amfay. Bǎkɛ́ ghɔkɔntɨk bɛ yi ǎto mmok ntá yɛ̌ntɨkɨ mmǔ bɛbʉ́ nɛ yɛ̌ntɨkɨ mmǔ ndɨ́ndɨ́. Mandɛm ǎto manyiɛp ntá yɛ̌ntɨkɨ mmu anɛ ákʉ̀ ɛnyɨŋ ɛnɛ yi áyàŋ nɛ mmu anɛ ápú kʉ ɛnyɨŋ ɛnɛ yi áyàŋ mmu wu ankʉ. ");
INSERT INTO kenNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mbák bǎkɔŋ chi bǒ abhɛn bákɔ́ŋɔ́ bhe, ntɨkɨ nsáy bǎbhɔŋ? Yɛ̌ chí bakʉ̌ bɛbʉ́ mbɔ babhɛbhɛ́ nkábhɛ́nti bakɔŋ bǒ abhɛn bákɔ́ŋɔ́ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nɛ mbák bǎkaka chi bǒ abhɛn mǎnyìɛ nɛ bhɔ, nɔ́ bǎkʉ yi? Yɛ̌ chí bǒ abhɛn bápú bo Israɛl bákʉ̀ nɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Bǎbhɔŋ yɛ bɛbhak chak ndǔ babhi ankɛm nkúbhɛ́ mbɔ ɛnyǔ Ɛtayɛka Mandɛm mfay achi chak ndǔ babhi ankɛm!” ");
INSERT INTO kenNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesu arɔk ambɨ bɛrɛm bɛ, “Sɔt ká mpok bɛ yɛ̌ mmu ywɛka ákɛ́ kʉ bɛrɨ ɛbhɛn Mandɛm áyàŋ yi ankʉ bɛsi bho ndu bɛtɔŋ mmʉɛt. Mbák mmu ankʉ nɔ, apú bhɔŋ nsáy anɛ Ɛtayɛka Mandɛm mfay áchyɛ̀. ");
INSERT INTO kenNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Yɛ̌ntɨkɨ mpok anɛ ɔ́chyɛ̀ ɛnyɨŋ ntá mmu anɛ ɛyi ɛ́pú, kɛ́ dɛp akánkáŋ mbɔ bǒ abhɛn bákʉ̀ mɛnyɨŋ chi bɛ mángɔ́ bhɔ. Bákʉ nɔ amɛm bɛkɛrɛ́ nɛnɨkɨ́mʉɛt nɛ ndu mántɨ́tɔk bɛ bo mámbɨti bhɔ. Dɨŋɨ́ ká bɛ nɛbɨti anɛ bo bábɨti bhɔ chi awap akap ankɛm anɛ́ bɔ mǎnáŋ bábhɔ́ŋɔ́. ");
INSERT INTO kenNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Mbák ɔ̌chyɛ̀ mmu ɛnyɨŋ mbɔnyunɛ ɛyi ɛ́pú, kʉ nɔ́ ɛnyunɛ yɛ̌ mmu apu rɨŋɨ ɛnyɨŋ ɛnɛ ɔ́kʉ̀. ");
INSERT INTO kenNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ɛ́rɨ bɛ ɔ́nkʉ́ bɛrɨ bhɛ́sɛ́ bhɛ́sɛ́ nɛ chɔŋ Ɛtayɛ Mandɛm mmu ághɔ̀ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ mmu ákʉ́ bhɛ́sɛ́ bhɛ́sɛ́ ankap wɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Yɛ̌ntɨkɨ mpok anɛ mǎnɨkmʉɛt, bǎkɛ́ kʉ mbɔ bǒ abhɛn bákʉ̀ mɛnyɨŋ chi bɛ mángɔ́ bhɔ́. Bákɔŋ bɛte amɛm bɛkɛrɛ́ nɛnɨkɨ́mʉɛt nɛ ndǔ manyé mbi kɛ manɨkmʉɛt bɛ́ mángɔ́ bhɔ. Dɨŋɨ́ ká bɛ, nɛghɔ́ anɛ bo bághɔ̀ bɛ bɔ mǎnɨkmʉɛt, chi awap akap anɛ mǎnáŋ bábhɔ́ŋɔ́. ");
INSERT INTO kenNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mpok anɛ mmǔ ywɛka áyàŋ mɛnɨkmʉɛt, ánchwé anywɔ́p, ɛbhak ɛnɛ yi ábhak aywǐnti, antíɛ́p mbǐnywɔp anɨkmʉɛt ntá Mandɛm Ɛta yɛka mmǔ bápú ghɔ nɛ amɨ́k. Mbák mmu akʉ nɔ, chɔŋ Ɛtayɛka mmu ághɔ̀ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ mmu ákʉ̀ bhɛ́sɛ́ bhɛ́sɛ́ ankap yi. ");
INSERT INTO kenNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Mpok mmu ywɛka ánɨ̀kmʉɛt, ákɛ́ rɛm bɛyǎ mɛnyɨŋ ɛbhɛn bɛ́bhɨ́kɨ́ bhɔŋ ntí nɛ nnɛt, mbɔ bǒ abhɛn bápú bo Israɛl bákʉ̀. Bákʉ̀ nɔ mbɔnyunɛ bákaysi bɛ bɛyǎ kɛpɨ kɛ kɛ́kʉ̀ Mandɛm angok nɛnɨkɨ́mʉɛt ɛnap. ");
INSERT INTO kenNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Bǎkɛ́ bhak mbɔ bhɔ́. Bǎpɛrɛ nɨkmʉɛt, Mandɛm Ɛtayɛka anaŋ arɨŋɨ ɛnyɨŋ ɛnɛ bǎyaŋ. ");
INSERT INTO kenNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ɛnyu ɛnɛ kɛ̌ bǎbhɔ́ŋɔ́ mɛnɨkmʉɛt: ‘Ɛtayɛsɛ, wɔ mmu ɔ́chí amfay: Kʉ bo mánchyɛ́ nnyɛ́n ɛna kɛnókó; ");
INSERT INTO kenNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","kʉ bɛ́ mandɔ wɔ ɔmbak Mfɔ wap; nɛ bɛ mánkʉ́ nɔ́kɔ́ chí mɛnyɨŋ ɛbhɛn ɔ́yaŋ bo mankʉ fá amɨk, mbɔ ɛnyǔ ɛchi awu amfay. ");
INSERT INTO kenNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Chiɛ́ bhɛsɛ nɛnyíɛ́ ɛnɛn ɛchɔŋ; ");
INSERT INTO kenNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ɔ́mfoŋori bɛbʉ́ bhɛsɛ, mbɔ ɛnyu sɛ́fóŋórí bo abhɛn bákʉ́ bhɛsɛ bɛbʉ́. ");
INSERT INTO kenNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nɛ ɔ́kɛ́ ka sɛ́nchwe ndǔ nɛmɔ ɛnɛn nɛ́kʉ sɛ́nkwɛ́n ndǔ bɛbʉ́, kɛ fɛrɛ́ bhɛsɛ ndu amɔ mbʉ́mbʉ.’ ");
INSERT INTO kenNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Mbák ɔ́mfóŋórí bo abhɛn bákʉ̀ wɔ bɛbʉ́, chɔŋ Ɛtayɛ Mandɛm mmu áchí amfay nkwɔ amfoŋori wɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kɛ mbák ɔpú foŋori bo abhɛn bákʉ̀ wɔ bɛbʉ́, Ɛtayɛ Mandɛm Mmu achi amfay apú foŋori wɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Yɛ̌ntɨkɨ mpok anɛ bǎtàt nsay ndu mɛnɨkmʉɛt ntá Mandɛm, bɛsí ɛbhɛka bɛ́kɛ́ bhak mbɔ bǒ abhɛn ɛnyɨŋ ɛ́sɔ̀ŋɔri bhɔ. Bǎkɛ́ bhak mbɔ bǒ bɛtábhá. Bágwɔt bɛsí bhap chi bɛ bo mángɔ́ bɛ bɔ bachi ndǔ nɛtarɛ́nsay. Dɨŋɨ́ ká bɛ, nɛghɔ́ anɛ bo bághɔ̀ bɛ bɔ bátàt nsay, chí awap akap anɛ mǎnáŋ bábhɔ́ŋɔ́. ");
INSERT INTO kenNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kɛ mpok ɔ́bhak ndǔ nɛtarɛ́nsay, sǒ bɛsí bhɛ watí, ɔ́mpák ntí. ");
INSERT INTO kenNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Mbák ɔ́nkʉ́ nɔ, bo bápú rɨŋɨ bɛ ɔchí ndǔ nɛtarɛ́nsay, kɛ Ɛtayɛ mmu bápú ghɔ́ nɛ amɨ́k ǎrɨŋɨ. Nɛ chɔŋ Ɛtayɛ mmu ághɔ̀ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ mmu ákʉ̀ bhɛ́sɛ́ bhɛ́sɛ́ ankap wɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Bǎkɛ́ sɔt kɛfɔ̌ nkáp nɛ kɛfɔ̌ mɛnyɨŋ bɛchak mǎmbʉrɛ fá amɨk. Fá amɨk, kɛngɔk nɛ mfárɛ́káŋ báchɔ̀ŋti, nɛ baghɛ́p báwày ɛkɛt mámpɔkɔ yɛ̌ntɨkɨ ɛnyɨŋ. ");
INSERT INTO kenNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ɛnyɨŋ ɛnɛ yɛ̌ntɨkɨ mmu ywɛka ábhɔ́ŋɔ́ bɛkʉ chi bɛ, ansɔt kɛfɔ̌ nkáp ɛki nɛ kɛfɔ̌ mɛnyɨŋ bɛchak ambʉrɛ amfay ntá Mandɛm. Arɛ́, kɛngɔk nɛ mfárɛ́káŋ bápú kway bɛchɔŋti bhɔ nɛ baghɛ́p bápú kway bɛdak ɛkɛt mángɛ́p wú. ");
INSERT INTO kenNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ɛbhak ɛnɛ́ nkáp aywɛ áchí, arɛ́ kɛ̌ ntɨ ɛnɛ nkwɔ nɛ́bhak.” ");
INSERT INTO kenNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Amɨ́k áchí ɛrɔ́ŋɔ́ ɛnɛ ɛ́kʉ̀ mmu ángɔ mbaŋ. Mbák mmu abhɔŋ amɨ́k arɨarɨ, ǎghɔ andɨŋɨ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ yi ákʉ̀. ");
INSERT INTO kenNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kɛ mbák ápú arɨarɨ, mmʉɛt yɛ nkɛm ǎbhák chi amɛm ɛjuri. Kɛ mbák ɛrɔ́ŋɔ́ ɛyɛ ɛ́girigíri, nɔ́ ɛjuri ɛnɛ ɔchí arɛ ɛya ɛcha.” ");
INSERT INTO kenNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Yɛ̌ mmu apu kwáy bɛtok bachi bati apay ndɔŋ amɔt. Mbák ámbɔ́ŋ bachi bapay, ǎkɔŋ amɔt ancha anɛfú, mbák ɛ́pú nɔ́, ǎchyɛ kɛnókó ntá amɔt, ambyák anɛfu. Mmu apu kwáy bɛtok Mandɛm antok nɔkɔ mɛnyɨŋ mmɨk. ");
INSERT INTO kenNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Nɔ́ kɛ̌ nchí ghati bhe bɛ, mmu ákɛ́ bhɔŋ basɛ́mɛ́ ɛ̌ti nɛpɛ́m ɛni andɛm bɛ́, ‘Chɔŋ nyíɛ yi? Chɔŋ nyú yi? Chɔŋ mfyɛ́ yi?’ Nɛpɛ́m nkwǎ nɛ́bhɨ́kɨ́ cha nɛnyíɛ́? Nɛpɛ́m nkwǎ nɛ́bhɨ́kɨ́ cha ndɛnɛ́? ");
INSERT INTO kenNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Yɨŋɨ́ ká kɛnɛn. Kɛ́pú kwaŋ nɛnyíɛ́ nɛ kɛ́pú fɛrɛ mbwɔt ɛbhɨ kɛmbay ndǔ bɛtɛm. Yɛ̌ nɔ, Ɛtayɛka mmu achi amfay ǎchyɛ kɔ nɛnyíɛ́. Bǎbhɨ́kɨ́ rɨŋɨ bɛ bǎchá kɛnɛn-ɛ? ");
INSERT INTO kenNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nɛ ntɨkɨ mmu ywɛka basɛ́mɛ́ ákway bɛkʉ nɛpɛ́m ɛni nɛ́nsap yɛ̌ chi mandú nɨŋɨnɨŋɨ, nɛncha ɛnyu nɛbhɔŋɔ bɛbhak? ");
INSERT INTO kenNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Nɛ ndaká yí bǎbhɔŋ basɛ́mɛ́ ɛ̌ti ndɛn ɛnɛ bɛ́fyɛ́ amʉɛt? Yɨŋɨ́ ká ɛnyǔ bɔchuchu abhɛn bachi ɛbhɨ bágò. Bápú kʉ bɛtɨk nɛ bapu ghoko ndɛn. ");
INSERT INTO kenNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kɛ nchí ghati bhe bɛ, yɛ̌ chí Mfɔ Sólomon mmu ábhɔ́ŋɔ́ nyaka bɛyǎ kɛnɛ́m, abhɨ́kɨ́ bhɔŋ nyaka ndɛn ɛnɛ ɛrɨ mbɔ yɛ̌ chuchu amɔt. ");
INSERT INTO kenNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Mandɛm kɛ̌ ághókó tákɔ nɛ bɛrɨ ɛbhi, tákɔ anɛ ákway bɛbhak ɛchɔŋ, mbúrɛ́ angwɔsi, mámfyɛ́ angó. Bǎkáysí bɛ́ be kɛ̌ Mandɛm apu kwáy bɛ́kwák mǎmbɔ́ŋ ndɛn bɛ́fyɛ́ amʉɛt kɛ? Nɛka ɛnɛká nɛ Mandɛm nɛ́gʉ́psi nɛcha! ");
INSERT INTO kenNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Bǎkɛ́ bhɔ́ŋ yɛ basɛ́mɛ́, mǎndɛmɛ nɔkɔ bɛ, ‘Chɔŋ sɛ́nyiɛ yi? Chɔŋ sɛ́nyú yi? Chɔŋ sɛ́mfyɛ́ yi?’ ");
INSERT INTO kenNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mɛnyɨŋ ɛbhɛn mɛnkɛm kɛ̌ bǒ abhɛn bápú bo Israɛl básɨ́kɨ́ ntɨ arɛ. Kɛ Ɛtayɛka mmu áchí amfay arɨ́ŋɨ́ bɛ bǎbhɔŋ bɛ́bhɔ́ŋ mɛnyɨŋ ɛbhɛn mɛnkɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yǎ yɛ́ ka mbɨ bɛfyɛ ntí bɛrɔ Mandɛm ámbák Mfɔ ywɛka, mǎmfyɛ́ ntí bɛkʉ chi yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ yi áyàŋ bo mankʉ, nɛ chɔŋ yi anchyɛ bhe mɛnyɨŋ ɛbhɛn mɛnkɛm nkwɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Bǎkɛ́ bhɔŋ yɛ basɛ́mɛ́ ɛ̌ti nywɔp ɛnɛn mbúrɛ́. Chɔŋ mbúrɛ́ antwɔ nɛ ayi barak anɛ mmu afyɛ́ ntí arɛ. Bǎkɛ́ sɔt bɛsɔŋɔri bɛchak mǎmáká ndǔ ɛbhɛn ɛchɔŋ.” ");
INSERT INTO kenNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Bǎkɛ́ táŋ batɨ kɛ́ká mántáŋ be nkwɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mmu ákɛ́ táŋ ntɨ mbɔnyunɛ, ɛnyu ɛnɛ́ ɔ́tàŋ ntɨ ɛnyu yɔ kɛ Mandɛm átàŋ wɔ. Ɛnyǔ ɔ́yɛ̀nti ɔ́nchyɛ ntɨ, nkúbhɛ́ ɛnyu yɔ kɛ báyɛ̀nti mánchyɛ wɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ndaká yí ɔ́yɨ̀ŋɨ mɔ́ɛ̌nyɨŋɨ anɛ achi anyɛsɛ ntɨ, ɛnɛ́ ɔ́pú fyɛ ntí ndǔ nkɔkɔ́nɔk anɛ achi wɔ anyɛsɛ? ");
INSERT INTO kenNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ná ɔ́ghàti ntɨ bɛ, ‘Manɔ́, dɔ̌ mɛ mfɛ́rɛ́ mɔ́ɛ̌nyɨ́ŋɨ́ anɛ achi wɔ anyɛ́sɛ́,’ ɛnɛ́ nkɔkɔ́nɔk achi wɔmbɔŋ anyɛsɛ? ");
INSERT INTO kenNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wɔ mmǔ bɛtábhá, fɛrɛ́ kpɨ́k nkɔkɔ́nɔk anɛ achi wɔmbɔ̌ŋ anyɛsɛ, kɛ ɔ́ngɔ mbaŋ sayri bɛfɛrɛ mɔ́ɛ̌nyɨ́ŋɨ́ anɛ achi amɛm nyɛ́sɛ́ manɔ́ywɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Bǎkɛ́ sɔt mɛnyɨŋ Mandɛm mǎnchyɛ ntá bǒ abhɛn bábhɨ́kɨ́ bhɔŋ mpok nɛ yi. Báchí mbɔ mmú. Mmu ákɛ́ sɔt mɛnyɨŋ Mandɛm ánchyɛ́ ntá bo abhɛn bábyak bhɔ. Báchí mbɔ bakók. Mbák mánchyɛ bakók ɛnyɨŋɨ́ nkáp, básɔ̀t mányɔp chi ndǔ ntɔp. Nɛ mbák mǎnchyɛ mmú mɛnyɨŋ Mandɛm, ǎyibhiri mmʉɛt antoko bhe anɛt.” ");
INSERT INTO kenNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Nɨk mmʉɛt ɛ̌ti ɛnyɨŋ ɛnɛ ɔ́yàŋ, chɔŋ Mandɛm anchyɛ wɔ. Yáŋ, chɔŋ ɔ́ngɔ. Dɛp nɛkok, chɔŋ mánɛnɛ ntá yɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kʉ nɔ mbɔnyunɛ yɛ̌ntɨkɨ mmu anɛ ánɨkmʉɛt ɛ̌ti ɛnyɨŋ ɛnɛ yi áyàŋ, Mandɛm ǎchyɛ yi. Yɛ̌ntɨkɨ mmu anɛ áyàŋ ɛnyɨŋ, ǎghɔ yɔ. Yɛ̌ntɨkɨ mmu anɛ ádɛ́bhɛ́ nɛkok, mánɛnɛ ntá yi. ");
INSERT INTO kenNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Bě bachǐbhɔ, mmu ywɛka anɛ mbák mɔ́ywi ámbɛ́p yi brɛt, ansɔt chi ntay anchyɛ yi, chi agha? ");
INSERT INTO kenNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Mbák ámbɛ́p wɔ tansi, ɔ̌chyɛ yi nnyɔ́ kɛ? ");
INSERT INTO kenNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mbák be bǒ bɛbʉ́, bǎbhɔŋ ntɨ bɛchyɛ bɛrɨ́tɨ́ mɛnyɨŋ ntá bɔ̌bhɛka, bǎkáysí bɛ Ɛtayɛka mmu achi amfay kɛ anɔk bɛbhɔŋ bɛyǎ ɛkɔŋ ndu bɛchyɛ bɛrɨ́tɨ́ mɛnyɨŋ ntá bǒ abhɛn mǎnɨ̀kmʉɛt kɛ? ");
INSERT INTO kenNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Yɛ̌ntɨkɨ mmu ywɛka ánkʉ́ yɛ nɛ batɨ mbɔ ɛnyǔ yi ákway bɛyaŋ bɛ bo mankʉ ntá yi. Mbák mǎnkʉ́ nɔ, ɛ́tɔ̀ŋ bɛ bǎkʉ̀ mɛnyɨŋ ɛbhɛn Moses nɛ barɛmɛ́ kɛpɨ̌ntɨ bághàti bhɛsɛ amɛm basɨŋɨ́ amap. ");
INSERT INTO kenNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Nyǔbhá anɛ́ mmu áfʉɛ̀t arɛ́ bɛchwe ndǔ Kɛfɔ Mandɛm áchí mábhɛ́rí. Nyǔbhá anɛ́ mmu áfʉɛt arɛ andɔk anchwe ndǔ mbǐ nɛwú ánɛ́nɛ́ mmʉɛt nɛ mbi wu áchɨk, nɛ ɛ́chí wɨkɨrɨk bɛfʉɛt arɛ. Ɛ́kʉ bo abhɛn báfʉɛ̀t arɛ baya. Fʉɛ́t yɛ́ ka chi ndǔ nyǔbhá anɛ achi mábhɛ́rí. ");
INSERT INTO kenNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Fʉɛ́t yɛ́ ka ndǔ nyǔbhá anɛ achi mábhɛ́rí mbɔnyunɛ wú kɛ̌ mmu áfʉɛt arɛ́ anchwe ndǔ mbǐ nɛpɛ́m. Mbi wu ábè mmʉɛt bɛfʉɛt arɛ́, nɛ bǒ abhɛn báfʉɛ̀t arɛ babhɨkɨ ya.” ");
INSERT INTO kenNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Sɔt ka mpok nɛ bǒ-nsé abhɛn bárɛ̀m bɛ báchí barɛmɛ́ kɛpɨ̌ntɨ Mandɛm. Bákɔ̀t ngɛpti bɛ báchí bághɔ́ŋɔmɛ́n, kɛ sayri sayri, báchí chí nkwɔ ɛnɛ nsay ánu yɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Chɔŋ mǎndɨŋɨ ɛnyǔ bɔ́ báchí ndǔ bɛpɨŋ ɛbhap, nkúbhɛ́ mbɔ ɛnyǔ mmu árɨŋɨ ɛnɔk ndǔ kɛpɛm ɛki. Bápú rɔŋ ndǔ támfáŋ mánkɔ́k nɛpɨ. Nɛ bápú rɔŋ ndǔ nnɛt áróŋóri mánkɔ́k bakwa. ");
INSERT INTO kenNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ɛnyu yɔ kɛ ɛ́chí nɛ ɛrɨ́tí ɛnɔk. Ɛ́nyu chi bɛrɨ́tí kɛpɛm, ɛpu kway mɛnyu bɛbɛ́ptí kɛpɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nɛ ɛbɛ́ptí ɛnɔk ɛ́nyu chi bɛbɛ́ptí kɛpɛm, ɛ́pú kwáy mɛ́nyú bɛrɨ́tí kɛpɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Bákɔt yɛ̌ntɨkɨ ɛnɔk ɛnɛ ɛ́pú nyu bɛrɨ́tí kɛpɛm, mámkpɔti, mansɔŋ ango. ");
INSERT INTO kenNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Barɛmɛ́ kɛpɨ̌ntɨ nsé bachi mbɔ mɛnɔk ɛbhɛn bɛpu nyu bɛrɨ́tí kɛpɛm. Bǎrɨŋɨ bhɔ chi ndǔ bɛpɨŋ ɛbhap.” ");
INSERT INTO kenNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Puyɛ̌ yɛ̌ntɨkɨ mmu anɛ ábhɨ̀ŋɨ mɛ bɛ, ‘Acha, Acha’ kɛ̌ áchwè ndǔ Kɛfɔ̌ mfáy. Mǔnɛ ákʉ̀ ɛnyɨŋ Ɛtaya mmu achi amfay áyaŋ kɛ áchwe arɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ndǔ nywɔbhɛ́ manyé, chɔŋ bɛyǎ bho mándɛm ntá ya bɛ, ‘Acha, Acha, pú sɛ́ghàti nyaka bho Ɛyɔŋ ɛyɛ ndǔ nnyɛ́n ɛna? Pú sɛ́bòk nyaka bɛfóŋó bɛbʉ́bɛbʉ ndǔ nnyɛ́n ɛna? Nɛ sɛ́kʉ̀ nyaka mɛnyɨŋɨ́ maknkay ndǔ nnyɛ́n ɛna!’ ");
INSERT INTO kenNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kɛ ndǔ nywɔp ɛnɔ chɔŋ ngati bhɔ bhɛ, ‘Mbɨ́kɨ́ rɨŋɨ be wáwák. Fǎ ká mɛ bɛsí, be bakʉ̌ bɛbʉ́.’” ");
INSERT INTO kenNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yɛ̌ntɨkɨ mmu anɛ ághòk mɛnyɨŋ ɛbhɛn mɛ̌rɛ̀m, ankʉ mbɔ ɛnyǔ ndɛ́mɛ́, achí mbɔ ndɨŋɨndak anɛ até ɛkɛt ndǔ sɛtárɛ́bhɛ́. ");
INSERT INTO kenNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ɛ̌ti yɔ, yɛ̌ndu manyiɛp ákwɛ́nɛ́ tontó, nɛ manyɛ́n ájwí, agboko, babhʉɛ́p ataŋataŋ anu, ɛkɛt ɛyɔ ɛ́kɛ kwɛn. Ɛ́kɛ kwɛn mbɔnyunɛ mbɔŋɔ́kɛt até yɔ́ ndǔ sɛtárɛ́bhɛ́. ");
INSERT INTO kenNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kɛ mmu anɛ ǎghok mɛnyɨŋ ɛbhɛn mɛ̌rɛ̀m, yi kɛ kʉ mbɔ ɛnyǔ ndɛ́mɛ́, achí mbɔ ɛchɨŋtímu anɛ áté ɛkɛt ndǔ ɛ̌siɛ́p. ");
INSERT INTO kenNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ɛso ɛ́twɔ́ nɔ́kɔ́, manyiɛp akwɛn tontó, ajwi, ataka ɛbhɨ, babhʉɛ́p ataŋataŋ ánú, ɛkɛt ɛyɔ ɛ́báy mmʉɛt amɨk juu! ");
INSERT INTO kenNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu ánáŋá nɔ́kɔ́ bɛrɛm mɛnyɨŋ ɛbhɛn yi átɔ̀ŋ, bǒ mankɛm abhɛn báchí arɛ bábhák maknkay tontó ɛ̌ti ɛyi ɛnyǔ ɛnɛ yi átɔ̀ŋ. ");
INSERT INTO kenNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ǎtɔ̀ŋ nyaka mbɔ mmu anɛ árɛ̀m ɛmay, puyɛ̌ mbɔ batɔŋ ɛbhé Moses. ");
INSERT INTO kenNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu ánáŋá nɔ́kɔ́ mɛnyɨŋ ɛbhɛn yi átɔ̀ŋ, arɔ njiɛ asɛp amɨk. Bɛyǎ bo bábhó bɛkoŋo yi. ");
INSERT INTO kenNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Bápɛ́rɛ yiŋɨ́, mmu ɛbhaŋákwa amɔt atwɔ akwɛn yí bɛkak abho bɛrɛm bɛ, “Acha, mbák ɔkɔŋ, ɔ̌kway bɛkʉ mɛ ntaŋ.” ");
INSERT INTO kenNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu anyabhɛ awɔ atɔk yi arɛm bɛ, “Nkɔŋ bɛkʉ wɔ ɔ́ntáŋ, nɛme ɛnɛ nɛ́máy.” Tɛ́mté wu, ataŋ. ");
INSERT INTO kenNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesu arɛm ntá yi bɛ, “Kɛ́ ghati yɛ̌ mmu ɛnyɨŋ ɛnɛ ɛ́fákárí, kɛ dɔ́k ntá nchiakap Mandɛm bɛ yi angɔ bɛ ɛbhaŋákwa yɛ ɛ́may. Ánáŋ ámbyó wɔ, ɔ́ndɔk, ɔnchyɛ yɛ akap ntá Mandɛm bɛ́kóŋo ɛbhé Moses. Chɔŋ ɛyɔ ɛ́mbak ɛnyɨŋ ɛnɛ ɛ́tɔ̀ŋ bo bɛ ɛbhaŋákwa yɛ ɛmay.” ");
INSERT INTO kenNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu afa are rɔ́ŋ Kapɛ̌naum. Ágháká nɔ́kɔ́ arɛ́, mmu amɔt anɛ áchí mǔnti ɛká batɛmɛ́ nɛnu Rom bɛsa bɛtay arɔk ntá Yesu, abho mɛnɨkmʉɛt ntá yi, ");
INSERT INTO kenNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","andɛmɛ nɔkɔ bɛ, “Acha, mmɔ̌bɛtok awa achí anywɔ́p bɨ́ŋɨ́rí nɛ bɛyǎ bɛbe.” ");
INSERT INTO kenNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu akɛmɛ yi bɛ, “Chɔŋ ntwɔ nkʉ yi antaŋ.” ");
INSERT INTO kenNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kɛ mǔnti batɛmɛ́ nɛnu wu arɛm bɛ, “Acha, mbɨ́kɨ́ kway mmu anɛ ɔ́twɔ́ ɛkɛt ɛyi. Chiɛ́ chí ɛyɔŋ, chɔŋ mmɔ̌bɛtok wa antaŋ. ");
INSERT INTO kenNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nchí rɛm nɔ mbɔnyunɛ mɛnkwɔ́ mbɔ̌ŋ bǒ abhɛn, mbák mángátí mɛ nkʉ ɛnyɨŋ, mbɔ̌ŋ bɛghok bhɔ. Nɛ mbɔ̌ŋ nkwɔ́ batɛmɛ́ nɛnu antɛnɛ ya abhɛn mbák ngati bhɔ ɛnyɨŋ, bábhɔŋ bɛghok mɛ́. Yɛ̌ntɨkɨ mmu wap anɛ ndɛ́mɛ́ bɛ, ‘Dɔ́k’, ǎrɔ́ŋ, nɛ yɛ̌ agha anɛ ndɛ́mɛ́ bɛ, ‘Twɔ́’, ǎtwɔ. Nɛ mbák ngátí mmɔ̌bɛtok awa bɛ, ‘Kʉ ɛnyɨŋ ɛnɛ’, abhɔŋ bɛkʉ yɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu ághókó nɔkɔ nɔ, abhak maknkay tontó. Ayibhiri mmʉɛt, arɛm ntá bǒ abhɛn bákòŋo yi bɛ, “Dɨŋɨ́ ká bɛ mbɨ́kɨ́ re ghɔ yɛ̌ mmu Israɛl amɔt anɛ ábhɔ́ŋɔ́ nɛka nɛ mɛ ɛnyu ɛnɛ́. ");
INSERT INTO kenNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Dɨŋɨ́ ká bɛ bɛyǎ bo báfù chɔŋ bɛbhě mɛnkɛm mántwɔ manchɔkɔ nɛ Ábraham nɛ Áisek nɛ Jekɔ́p ndǔ mɛnyiɛ ɛpǎ ndǔ nɛbhʉɛrɛ kɛfɔ mfay. ");
INSERT INTO kenNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kɛ chɔŋ mántɛn bo abhɛn bábhɔ́ŋɔ́ nyaka bɛbhak ndǔ nɛbhʉɛrɛ Kɛfɔ Mandɛm nɛfí ndǔ ɛjuri. Arɛ́, mámbak ndǔ kɛbhɔ nɛ nɛnyiɛ ámɛ́n.” ");
INSERT INTO kenNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesu ayibhiri yɛ mmʉɛt arɛm ntá mǔnti batɛmɛ́ nɛnu bɛ, “Pɛtnsɛm anywɔ́p, yɛ̌ntɨkɨ ɛnyɨŋ ɛchi mbɔ ɛnyu ɔ́nókó.” Nkúbhɛ́ mpok anɛ Yesu árɛ̀m nɔ, mmɔ̌bɛtok wu ataŋ. ");
INSERT INTO kenNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu arɔk achwe ɛkɛt Píta, aghɔ́ nnɔ ngɔrɛ́ ywi bhʉ́rɛ́ nɛ mbʉ́ɛ́p amʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Arɔk yi nɛ́kúmʉɛt atɔk yi ndǔ awɔ. Mbʉ́ɛ́p wu ámay. Afate akʉ nɛnyíɛ́ abho mɛne Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ɛ́gháká nɔ́kɔ́ beku, bo báré sɔt bɛyǎ bo abhɛn bɛfóŋó bɛbʉ́bɛbʉ bɛ́sɔ̀ŋɔri bhɔ mándɔk nɔkɔ ntá Yesu nɛ bhɔ. Yesu are sɔt chí ɛyɔŋɔ́nyu ɛyi amboko nɔkɔ bɛfóŋó bɛbʉ́bɛbʉ bɛ mɛ́ndɔ́ bho, nɛ ambu nɔkɔ bǒmame. ");
INSERT INTO kenNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yesu akʉ mɛnyɨŋ ɛbhɛn ntá bho bɛ ɛnyɨŋ ɛnɛ ndɛmɛkɛpɨ̌ntɨ Aisáya árɛ́mɛ́ nyaka ɛ̌ti yi ɛ́mfú tɛtɛp. Aisáya arɛm nyaka bɛ, “Asɔt mame ayɛsɛ nɛ apɔkɔ bɛsɔŋɔri ɛbhɛsɛ́.” ");
INSERT INTO kenNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu ághɔ́ nɔ́kɔ́ bɛyǎ bo ndǔ bátwɔ́ bákábhɛ́ yi, aghati baghɔk abhi bɛ, “Sɛ́mpé ɛbhě manyu ɛ́nɛ awu.” ");
INSERT INTO kenNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ntɔŋ ɛbhé Mandɛm amɔt arɔk yɛ ntá Yesu arɛm bɛ, “Ntɔŋ, chɔŋ nkoŋo wɔ yɛ̌ntɨkɨ ɛbhak ɛnɛ ɔ́rɔ̀ŋ.” ");
INSERT INTO kenNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu akɛmɛ yi nɛ nɛkay bɛ, “Bɛsɔp bɛbhɔŋ babhok, kɛnɛn kɛ́bhɔ́ŋ manyay, kɛ Mɛ Mmu mfú ntá Mandɛm mbɨ́kɨ́ bhɔŋ ɛbhak bɛsoŋ ntí.” ");
INSERT INTO kenNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nkoŋo Yesu achak arɔk ntá yi arɛm bɛ, “Acha, dɔ̌ kpɨ́k ndɔ́k mbɛ́mɛ́ Ɛtaya.” ");
INSERT INTO kenNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Kɛ Yesu akɛmɛ yi bɛ, “Koŋó mɛ. Dɔ̌ bawú mámbɛ́mɛ́ ngú wap.” ");
INSERT INTO kenNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu arɔk achwe amɛm áchwí nɛ bakoŋo bhi ndu bɛ́pe bɛrɔŋ ɛbhě manyu ɛchak. ");
INSERT INTO kenNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ndǔ bárɔ̀ŋ, bápɛ́rɛ ghɔ́ mbʉ́ɛ́p ataŋataŋ ábhó mɛnu, mpɛ́rɛ́nyɛn ɛbho bɛdɛp áchwí, manyiɛp anchwe nɔkɔ amɛm. Yesu abhak ndǔ kɛnɔ́. ");
INSERT INTO kenNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Bakoŋo bhi bárɔ́k maŋɛmɛ yi barɛm bɛ, “Acha, pɛmɛ́ bhɛsɛ, sɛ́twɔ̀ gu anyɛ́n!” ");
INSERT INTO kenNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu arɛm bɛ, “Bǎcháy yi? Nɛka ɛnɛka nɛ́gʉpsi nɛcha!” Afate yɛ asáy mbʉ́ɛ́p nɛ mpɛ́rɛ́nyɛn, nnyɛ́n nɛkwɛn tɨɨɨ. ");
INSERT INTO kenNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Bábhák maknkay tontó, babho bɛrɛm bɛ, “Ntɨkɨ ɛnyǔ mmu nɛ́? Yɛ̌ chí mbʉ́ɛ́p ághòk yi, mpɛ́rɛ́nyɛn ɛ́ngok yí!” ");
INSERT INTO kenNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu arɔk aghaka atú mmɨk bǒ Gɛrása ɛbhě manyu ɛchak. Bǒ bati apay abhɛn bɛfóŋó bɛbʉ́bɛbʉ bɛ́sɔ̀ŋɔri bhɔ, báfú ndǔ nɛbhʉɛ́rɛ́ manɛm anɛ́ bɔ́ báchɔ̀kɔ arɛ, bátɛ́mɛri yi. Bághɔ̀ nyaka bo, mántoko bhɔ anɛt. Ɛ́kʉ́ bo kɛpɛrɛ fʉɛ́t atú wu. ");
INSERT INTO kenNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nɛghɔ́ anɛ bághɔ́ Yesu, babho bɛbɨk mándɛmɛ nɔkɔ bɛ, “Mmɔ Mandɛm, ɔbhɔ̌ŋ ntɨkɨ ndak nɛ bhɛsɛ́? Ɔ́twɔ́ bɛchyɛ bhɛsɛ ntɛmsi ɛnɛ́ mpok abhɨkɨ re kway?” ");
INSERT INTO kenNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ɛrɛmɛ nkwɔ́ bakók ányìɛ nyaka kɛkwɔt nɛ nɛbhʉɛ́t wu. ");
INSERT INTO kenNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Bɛfóŋó bɛbʉ́bɛbʉ ɛbhɛn bɛ́sɔ̀ŋɔri bhɔ bɛ́bhó mɛnɨk Yesu mmʉɛt bɛ, “Mbák ɔ̌bòk bhɛsɛ, tó bhɛsɛ chi ndǔ nkwɔ bakók wu.” ");
INSERT INTO kenNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu aghati bɛfóŋó bɛbʉ́bɛbʉ bhɔ bɛ, “Dɔ́k ká.” Bɛ́fú bǒbhɔ amʉɛt, bɛrɔk, bɛchwe ndǔ nkwɔ bakók. Bakók ankɛm bárókóri básɛp ndǔ nkoko-njiɛ dúgúdúgúdúgú bágúrɛ anyɛ́n. ");
INSERT INTO kenNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bǒ abhɛn bábhàbhɛri bakók, bághɔ́ nɔ́kɔ́ nɔ, bábʉɛ́, bárɔk ndǔ ɛtɔk ɛnɛ ɛchi kɛkwɔt, baghati bho yɛ̌ntɨkɨ ɛnyɨŋ nɛ ɛnyǔ ɛ́fákárí nɛ bǒ abhɛn bɛfóŋó bɛbʉ́bɛbʉ bɛ́sɔ̀ŋɔri nyaka bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ɛtɔk ɛnkɛm ɛ́móko tɛ́mté ɛrɔk ɛ́tɛ́mɛri Yesu. Mánɨk yi mmʉɛt bɛ ándɔ́ atú ɛtɔk ɛyap. ");
INSERT INTO kenNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu áfá nɔ́kɔ́ atú Gɛrása, arɔk, asɔt áchwí apé nnyɛ́n, apɛtnsɛm Kapɛ̌naum, ɛtɔk ɛnɛ yi áchɔ̀kɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Bǒfú bátwɔ́ nɛ mbɛ́ntí amɔt anɛ bápɔ́kɔ́ ndǔ bɛkpaka ntá yi. Yesu ághɔ́ nɔ́kɔ́ ɛnyǔ nɛka ɛnɛ́n bábhɔ́ŋɔ́ nɛ yi bɛ abhɔŋ bɛtaŋ bɛbu mmu wu, arɛm ntá yi bɛ, “Mɔ́wa, ɔ́kɛ́ chay, mfóŋórí bɛbʉ́ ɛbhɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ɛkʉ mbɔk batɔŋ ɛbhé Mandɛm abhɛn bachi arɛ bábho bɛrɛm nɛ mmʉɛ́t ɛyap bɛ, “Ǎrɛm kpát mbɔ bhɛ́ achi Mandɛm! Mandɛm aywǐnti kɛ̌ ákway bɛ́fóŋóri bɛbʉ́ mmu!” ");
INSERT INTO kenNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu arɨŋɨ nkaysi yap, abhɛ́p bhɔ bɛ, “Ndaká yí bǎkàysi bɛbɛ́ptí mɛnyɨŋ? ");
INSERT INTO kenNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ɛnyɨŋ ɛnɛ ɛ́chí wɨkɨrɨk chí ɛnɛ? Bɛrɛm bɛ, ‘Mfóŋórí bɛbʉ́ bhɛ,’ kɛ chi bɛrɛm bɛ, ‘Faté kɔ?’ ");
INSERT INTO kenNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kɛ chɔŋ nkʉ mǎndɨŋɨ bɛ, Mɛ Mmu mfú ntá Mandɛm mbɔ̌ŋ bɛtaŋ fá amɨk bɛfoŋori bɛbʉ́ bho.” Arɛm ntá mbɛ́ntí wu bɛ, “Faté, pɔkɔ́ bɛkpaka bhɛ gurɛ!” ");
INSERT INTO kenNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mbɛ́ntí wu afate kpɛrɛp, agurɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Bo bághɔ́ nɔ́kɔ́ ɛnyɨŋ ɛnɛ ɛfakari, bábhak maknkay tontó, babho bɛbɨti Mandɛm mmú áchyɛ́ nkwǎ ɛnyǔ bɛtaŋ ɛbhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ɛnɛ́ Yesu árɔ́ ɛbhak ɛnɛ yi ábú mbɛ́ntí ákɔ̀, árɔ̀ŋ, aghɔ́ mbɛbhɛ́ nkabhɛ́nti amɔt chɔkɔ amɛm ɛkɛrɛ́bɛtɨk ɛyi. Aka nnyɛ́n bɛ Mátio. Abhɨŋɨ yí, arɛm bɛ, “Twɔ́, bhák nkoŋo wa.” Mátio afate, abho bɛkoŋo Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ɛ́tárɛ́ nɔ́kɔ́, Mátio abhɨŋɨ Yesu ɛkɛt ɛyi. Anak mamʉɛrɛ bhi nɛ babhɛbhɛ́ nkábhɛ́nti bachak, nɛ bakʉ̌ bɛbʉ́ bachak. Yesu, achɔkɔ anyiɛ nɔkɔ nɛnyíɛ́ nɛ bhɔ, nɛ bakoŋo bhi nkwɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Bǒnkwɔ Fárisi bághɔ́ nɔ́kɔ́ ndǔ Yesu ányìɛ nɛnyíɛ́ nɛ bhɔ́, bábhó bɛbhɛp bakoŋo Yesu bɛ, “Ndaká yí ntɔŋ ywɛka ányìɛ nɛnyíɛ́ nɛ mɛnyǔ bǒbhɛn?” ");
INSERT INTO kenNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu ághók ɛnyɨŋ ɛnɛ bárɛ̀m, akɛmɛ bhɔ nɛ nɛkay bɛ, “Bǒ abhɛn bápú me, bápú yaŋ ngaŋ. Bǒ mame kɛ báyàŋ ngaŋ.” ");
INSERT INTO kenNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Árɛ́mɛ́ nɔ́kɔ́ nɔ́, arɔk ambɨ bɛrɛm bɛ, “Dɔ́k ká, mǎnu bɛrɨŋɨ ɛnyɨŋ ɛnɛ Mandɛm árɛ́mɛ́. Arɛm bɛ básɨŋ bɛ, ‘Ɛnyɨŋ ɛnɛ mɛ̌yáŋ chi bɛ bo mángɔ́ ntínso nɛ batɨ, puyɛ̌ chi akabhɛ́nya.’ Mbɨ́kɨ́ twɔ bɛbhɨŋɨ bǒ abhɛn bakaysi bɛ bachi chak bɛsí Mandɛm bɛ mámbák bakoŋo bha, ntwɔ bɛ́bhɨ́ŋɨ chi bo babʉ́babʉ́.” ");
INSERT INTO kenNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Mbɔk bakoŋo Jɔ̌n Njwiti bárɔ́k ntá Yesu bábhɛ́p yi bɛ, “Ndaká yí bɛsɛ́ nɛ bǒnkwɔ Fárisi sɛ́tarɛ nɔkɔ nsay ndu mɛnɨkmʉɛt ntá Mandɛm, kɛ bakoŋo bhɛ bápú kʉ nɔ?” ");
INSERT INTO kenNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu akɛmɛ bhɔ́ bɛ, “Bǎkáysí bɛ́ bo bákwày bɛchɔkɔ nsónso ndǔ ɛpǎ nɛbhay ɛnɛ́ mbǎyngɔrɛ́ abhʉɛ́t nɛ bhɔ? Nsé! Kɛ mpok ǎtwɔ̀ anɛ báfɛrɛ chɔŋ mbǎyngɔrɛ́ ntá yap. Nɛ chɔŋ mǎntarɛ nsay mpok yɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Yesu arɔk ambɨ bɛrɛm bɛ, “Yɛ̌ mmu apú kway bɛsɔt ɛbhɔ́kɔ́ndɛn nkɔ anchók mbok ndǔ ɛsɨ́ ndɛn? Mbák mmu ankʉ nɔ, ɛbhɔ́kɔ́ndɛn nkɔ ɛ́ŋàti, ɛnkʉ mbokó ndɛn ánchɨk ancha ɛsɨ́ mbok. ");
INSERT INTO kenNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nɛ ntá bo abhɛn báfyɛ mmɛ́m ndǔ bɛbhǎ nkwɔbhanya, bápú fyɛ mmɛ̌m bakɔ amɛm ɛbhǎ nkwɔbhɛnya ɛnɛ ɛsɨ. Mbák mánkʉ́ nɔ, ɛbha ɛ́sɛn, ɛnchɔŋɔ, nɛ mmɛm andɔk amɨk. Báfyɛ mmɛm bakɔ chi ndǔ ɛbhǎ nkwɔbhɛnya ɛnɛ ɛkɔ. Mbák mánkʉ nɔ, mmɛm ápú rɔŋ amɨk nɛ ɛbha ɛpu sɛn ɛnchɔŋɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ɛnɛ́ Yesu abhʉɛt bɛghati bhɔ mɛnyɨŋ ɛbhɛn, bápɛ́rɛ ghɔ mǔnti bo Israɛl amɔt arɔk akwɛ́n yi bɛkak, abho bɛrɛm bɛ, “Ɛta, mɔ́wa agu nɛ́nɛ. Chí mɔ́ngɔrɛ́. Nnɨkmʉɛt, twɔ́ nyaŋá amɔ yi amʉɛt, nɛ chɔŋ ampɛtnsɛm ndǔ nɛpɛ́m.” ");
INSERT INTO kenNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu afate nɛ bakoŋo bhi bábho bɛrɔŋ nɛ mǔnti wu. ");
INSERT INTO kenNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ɛnɛ́ bárɔ̀ŋ, ngɔrɛ́ amɔt afú Yesu ansɛm, arɔk pɛtii, atɔk nkokoŋ nkú yi. Ngɔrɛ́ wu ǎfɛ̀rɛ nyaka manoŋ ndǔ mamiɛ́ byo nɛ apay. ");
INSERT INTO kenNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Akʉ nɔ́ mbɔnyunɛ arɛm nyaka nɛ mmʉɛt yi bɛ, “Mbák ntɔk yɛ̌ chi nkokoŋ ndɛn Yesu, chɔŋ ntaŋ.” ");
INSERT INTO kenNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu ayibhiri mmʉɛt aghɔ́ yi, aghati yi bɛ, “Mɔ́wa, kɛ́chay. Nɛka ɛnɛ nɛ mɛ nɛ́kʉ ɔtaŋ.” Tɛ́mté wu ngɔrɛ́ wu ataŋ. ");
INSERT INTO kenNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu afʉɛ́t yɛ are rɔŋ ndǔ ɛkɛt ɛnɛ mǔnti bo Israɛl wu. Ágháká nɔ́kɔ́ arɛ́, achwe anywɔ́p, aghɔ́ bafě babhaŋ nɛ ngɛ́mtay bho ndǔ bádì kɛbhɔ nɛ bɛyǎ ɛwat. ");
INSERT INTO kenNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Aghati bɔ́ mankɛm bɛ, “Fú ká kpɨ́k, mɔ́nɛ abhɨ́kɨ́ gú. Ǎbhʉrɛ chí kɛnɔ́.” Bɔ́ mankɛm báré way Yesu way. ");
INSERT INTO kenNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Bǒ nnɛrɛ́kɛt bátɛ́n nɔ́kɔ́ bhɔ nɛfí, Yesu arɔk kɛkwɔt nɛ ngú wu, ákɛ́m yi ndǔ awɔ́, mɔ́wu apɛtnsɛm ndǔ nɛpɛ́m, afate. ");
INSERT INTO kenNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mbok ɛ̌ti ndak anɛ ataka atú ɛtɔk wu ankɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ɛnɛ́ Yesu árɔ́ nɛbhʉɛt wu árɔ̀ŋ ambɨ, manɛ́mámɨk bati apay babho bɛkoŋo yi mámbɨk nɔkɔ bɛ, “Mmɔ̌ Mfɔ Debhít, ghɔ́ bhɛsɛ ntínso!” ");
INSERT INTO kenNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Mpok Yesu achwe anywɔ́p, manɛ́mɛ́ amɨ́k bhɔ bákóŋo yi arɛ́. Abhɛ́p bhɔ bɛ́ “Mǎnókó bɛ mɛ̌kwáy bɛkʉ mǎngɔ́ mbaŋ?” Bákɛ́mɛ bɛ, “Acha, sɛ́noko.” ");
INSERT INTO kenNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yesu atɔk yɛ amɨ́k ayap arɛm bɛ, “Ɛ́mbák nɛ bhe mbɔ ɛnyǔ mǎnókó.” ");
INSERT INTO kenNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Amɨ́k ánɛ́nɛ bhɔ tɛ́mté, bapɛt babho bɛghɔ mbaŋ. Yesu asɛmti bhɔ bɛ, “Bǎkɛ́ ghati yɛ̌ mmu ɛnyɨŋ ɛnɛ ɛfakari.” ");
INSERT INTO kenNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Yɛ̌ nɔ́, bárɔ́ŋ nɔ́kɔ́, mángati nɔkɔ bho ndǔ atú ɛtɔk wu ankɛm ɛnyɨŋ ɛnɛ Yesu ákʉ́ ntá yap. ");
INSERT INTO kenNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Bǒ-bhɔ bati apay bárɔ́ nɔ́kɔ́ Yesu, bǒfu basɔt mbók bárɔ́k ntá Yesu nɛ yi. Ɛfóŋó ɛbʉ́bʉ kɛ ɛ́kʉ́ nyaka yi ákwɛ́nɛ́ kɛbhok. ");
INSERT INTO kenNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesu abók ɛfóŋó ɛbʉ́bʉ yɔ. Ɛ́rɔ́ mmu wu, abho bɛrɛm kɛpɨ tɛ́mté. Bɛyǎ bo abhɛn bachi arɛ́, babhak maknkay, bábhó bɛrɛm bɛ, “Sɛ́bhɨ́kɨ́ re ghɔ́ ɛnɛ ɛnyu fá amɛm ɛtɔk Israɛl.” ");
INSERT INTO kenNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kɛ bǒnkwɔ Fárisi báré rɛm chi bɛ, “Chí mfɔ bɛfóŋó bɛbʉ́bɛbʉ kɛ̌ áchyɛ́ Yesu bɛtaŋ bɛ́bok bɛfóŋó bɛbʉ́bɛbʉ.” ");
INSERT INTO kenNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu ǎkɔ̀ nyaka amɛm bɛtɔk bɛgho nɛ ndǔ bɔ̌bɛtɔk, antɔŋ nɔkɔ bho amɛm bɛkɛrɛ́ nɛnɨkɨ́mʉɛt bo Israɛl. Nɛ angati nɔkɔ bho Mbok Ndɨ́ndɨ́ ɛ̌ti Kɛfɔ Mandɛm. Ǎbù nyaka bo abhɛn bárɔ̀ŋ ntá yi nɛ mame mɛnyu nɛ mɛnyu. ");
INSERT INTO kenNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesu ághɔ́ nɔ́kɔ́ ndǔ ngɛ́mtay bho bátwɔ̀ ntá yi, aghɔ́ bhɔ ntínso mbɔnyunɛ báchi ndǔ ɛsɔŋɔri, kɛbhɔ́ŋ nkwak, mbɔ bághɔ́ŋɔmɛ́n anɛ ábhɨ́kɨ́ bhɔŋ mbabhɛri. ");
INSERT INTO kenNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yesu arɛm ntá bakoŋo bhi bɛ, “Mbuɔt bɛ́fɛ́rɛ ɛbhɨ aya, kɛ bakʉ̌ bɛtɨk bábhɨkɨ ya. ");
INSERT INTO kenNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nɨk yɛ ka mmʉɛt ntá Mandɛm mmu achi mbɔŋɔ́nkɨ bɛ́ ántó bakʉ̌ bɛtɨk mamfɛrɛ mbwɔt ɛbhɨ.” ");
INSERT INTO kenNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ɛwak ɛ́mɔt, Yesu abhɨŋɨ bakoŋo bhi bati byo nɛ apay, achyɛ bhɔ bɛtaŋ bɛ́bók bɛfóŋó bɛbʉ́bɛbʉ nɛ ndǔ bɛ́bú mame mɛnyu nɛ mɛnyu. ");
INSERT INTO kenNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Manyɛ́n bǒnto Yesu bhɔ bati byo nɛ apay achi bɛ: Anɛ mbɨ abhak Símun. Nnyɛ́n ɛni nɛ́chák nɛ́bhak bɛ Píta. Achák abhak Andru, manɔ́ Píta. Nɛ Jems nɛ mɔ̌máyi Jɔ̌n, bɔ̌ Sɛbɛdi. ");
INSERT INTO kenNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Báchák bábhák Fílip nɛ Batolómyo, nɛ Tɔmás, nɛ Mátio mbɛbhɛ́ nkabhɛ́nti, nɛ Jems mmɔ̌ Alfeyɔs, nɛ Tadiɔs. ");
INSERT INTO kenNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Nɛ Símun, mfyɛ̌-bɛtaŋ ndǔ barakátɔk, nɛ Júdas Iskariɔt mmu átí nyaka Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu abhɨŋɨ bǒbhɔ bati byo nɛ apay aghati bhɔ bɛ, “Mɛ̌tò bhe nɛfí ndǔ bɛtɨk. Kɛ bǎkɛ́ rɔŋ ntá bo abhɛn bápú bo Israɛl, nɛ bǎkɛ́ chwe ndǔ yɛ̌ ɛtɔk Samária ɛ́mɔt. ");
INSERT INTO kenNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Dɔ́k ká chi ntá bo Israɛl abhɛn bachi mbɔ ághɔ́ŋɔmɛn anɛ́ ánɛ́mɛ́ ɛbhɨ. ");
INSERT INTO kenNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Dɔ́k ká mǎngati nɔkɔ bhɔ bɛ, ‘Mpok arɔp kɛkwɔt anɛ Mandɛm abhak nɛ bho mbɔ Mfɔ wap.’ ");
INSERT INTO kenNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Bú ká bǒmame, ŋɛmɛ́ ká bawú, mǎmbu bǒ ɛbhaŋákwa nkwɔ. Bók ká bɛfóŋó bɛbʉ́bɛbʉ bɛ mɛ́ndɔ́ bho. Nchyɛ́ bhe bɛtaŋ ndu bɛkʉ mɛnyɨŋ ɛbhɛn nkɛ sɔt nkáp. Dɔ́k yɛ́ ka kʉ bhɔ ntá bho kɛbhɛ́p bhɔ nkáp. ");
INSERT INTO kenNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mmu ákɛ́ pɔkɔ́ yɛ̌ntɨkɨ ɛnyǔ nkáp amʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mmu ákɛ́ pɔkɔ́ ɛbhǎ nɛkɔ, nɛ yɛ̌ chí nkú áchák, nɛ yɛ̌ chí nkwɔbhánya ɛ́chák, nɛ yɛ̌ chí ntɛ́m. Bo bábhɔŋ bɛ́chíɛ nkʉbɛtɨk ɛnyɨŋ ɛnɛ yi ábhɔ́ŋɔ́ bɛ́bhɔ́ŋ. ");
INSERT INTO kenNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Yɛ̌ntɨkɨ ɛtɔk ɛnɛ́ bǎchuɔ́bhɛ́ arɛ́, yáŋ ká ɛsáyrí mmu anɛ ábhɔ́ŋɔ́ ɛkɔŋ bɛsyɛpti bhe ɛkɛt ɛyi, mǎnchɔkɔ nɛ yi kpátɛ mpok anɛ bǎrɔ ɛtɔk ɛyɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nɛchwe anɛ bǎchwe anywɔ́p, kaká ka bǒ abhɛn bachi arɛ mǎndɛm bɛ, ‘Áfɔ́k Mandɛm ámbák nɛ bhe.’ ");
INSERT INTO kenNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nɛ mbák básɔt bhe nɛ ɛkɔŋ, nɨk ka mmʉɛt bɛ áfɔ́k Mandɛm ámbák nɛ bhɔ. Kɛ mbák bábhɨ́kɨ́ sɔt bhe nɛ ɛkɔŋ, nɨk ka mmʉɛt bɛ Mandɛm ánkɛ́m áfɔ́k ywi, kɛchyɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nɛ mbák bábhɨkɨ syɛpti bhe ndǔ yɛ̌ ɛkɛt nɛ yɛ̌ chi ɛtɔk, kwɛt ka mfok anɛ áchí bhe bɛkak, mǎmfa arɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nchí ghati bhe bɛ, ɛwak ɛnɛ Mandɛm átàŋ bǒ mmɨk, chɔŋ angɔ́ ntínso nɛ bǒ ɛtɔk Sódom nɛ abhɛn Gomóra ɛncha bǒ ɛtɔk ɛnɛ́ bábhɨ́kɨ́ sɔt bhe nɛ ɛkɔŋ.” ");
INSERT INTO kenNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ghók ká, Nchí to bhe ntá bǒ mmɨk mbɔ bághɔ́ŋɔmɛ́n nɛntɨ nkwɔ. Bák yɛ́ ka bǒ kɛ́ŋwáŋ mbɔ nnyɔ́, mǎmbɔ́ŋ batɨ pɛ́pɛ́p mbɔ bɛbhóŋó. ");
INSERT INTO kenNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Sɔt ka mpok mbɔnyunɛ bo bákɛ̀m chɔŋ bhe mámfyɛ amɔ bǒ batí ɛtɔk, mándɛp manɛt ayɛka amɛm bɛkɛrɛ́ nɛnɨkɨ́mʉɛt ɛbhap. ");
INSERT INTO kenNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Chɔŋ bo mánja bhe gbaka gbaka gbaka ntá bɔgɔ́bhanɔ nɛ bafɔ ɛ̌ti ya. Nɛ chɔŋ ɛyɔ ɛ́nchyɛ bhe mbi bɛghati bhɔ nɛ bǒ abhɛn bápú bo Israɛl Mbok Ndɨ́ndɨ́ ɛ̌ti ya. ");
INSERT INTO kenNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mpok básɔ́rɛ́ bhe ambɨ ndu bɛ́táŋ be, bǎkɛ́ sɛmɛ bɛ, ‘Chɔŋ sɛ́ndɛm bɛ yi nɛ yɛ̌ chí bɛ chɔŋ sɛ́ndɛm ná?’ Bǎkɛ́ sɔŋɔri mmʉɛt mbɔnyunɛ mpok ánkwáy, Mandɛm ǎghati bhe ɛnyɨŋ ɛnɛ bǎbhɔ́ŋɔ́ bɛrɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nchí ghati bhe ɛnyɨŋ ɛnɛ mbɔnyunɛ mpok yɔ, mɛnyɨŋ ɛbhɛn bǎrɛ̀m bɛ́pú fu be antɨ. Ɛfóŋó mmu Mandɛm ɛtayɛka átò kɛ̌ ághàti bhe ɛnyɨŋ ɛnɛ bǎbhɔ́ŋɔ́ bɛrɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Chɔŋ manɔ́ anchyɛ ntɨ manɔ́ ntá bǒbati bɛ mángwáy. Chɔŋ mbɔk bachi mánkʉ ɛnyumɔt nɛ bɔ̌bhap. Chɔŋ mbɔk bhɔ mánte nɛnu nɛ bachi nɛ manɔ, mánkʉ bɛ mángwáy bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Chɔŋ mɛnyǔ bho mɛnkɛm mámpap be ɛ̌ti ya. Kɛ Mandɛm ǎpɛmɛ yɛ̌ntɨkɨ mmu anɛ áté kpirí tɛ ndǔ ngwɛnti. ");
INSERT INTO kenNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ɛtɔk ɛnɛ bo báchyɛ̀ be ɛsɔŋɔri, fá ká arɛ́ áyák mǎndɔk ɛtɔk ɛ́chák. Dɨŋɨ́ ká bɛ bǎpú kway bɛkɔ ndǔ bɛtɔk Israɛl mɛnkɛm bɛkʉ bɛtɨk ɛbha ɛnɛ́ Mɛ Mmu mfú ntá Mandɛm mbɨ́kɨ́ re pɛtnsɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Mmɔ̌káti apu kway bɛrɨ̀ŋɨ ɛnyɨŋ ancha ntɔ̌ŋ ywi. Nɛ mǔbɛtok apú cha chi-bɛtok ywi. ");
INSERT INTO kenNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ɛ́chí ɛnyɨŋɨ́ maŋák bɛ mánkʉ nɛ mmɔ̌ ɛkáti mbɔ ɛnyu bákʉ́ nɛ ntɔŋ aywi. Nɛ ɛ́chí ɛnyɨŋɨ́ maŋák bɛ mɔ̌bɛtok ámbák mbɔ chi-bɛtok ywi. Mbák bo bákway bɛ́chɨk ntɨ kpát mámbɨŋɨ mɛ mǔnti nnɛrɛ́kɛt bɛ Bɛlsɛbul, ná nɛ be bǒnɛrɛ́kɛt? Chɔŋ mánchyɛ bhe manyɛ́n anɛ́ ábɛ́bhɛ́ áchá ɛnɔ!” ");
INSERT INTO kenNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Bǎkɛ́ chay yɛ̌ mmu anɛ ápàbhe. Yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ bákútí, chɔŋ mánɛnɛ. Nɛ ɛnɛ́ ɛchi bhɛ́sɛ́ bhɛ́sɛ́, chɔŋ mánkʉ bɛ bo mándɨŋɨ yɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ ngátí bhe ansɛm ansɛm, ghatí ká bho kpóŋóróŋ. Ɛnɛ́ bǎghókó ansɛm ansɛm, kó ka amfǎy bɛkɛt mǎndɛm bɛ mmɨk nkɛm ángók. ");
INSERT INTO kenNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Bǎkɛ́ cháy bǒ mmɨk. Bákway bɛway chi mmʉɛt nkwǎ. Bábhɨ́kɨ́ bhɔŋ bɛtaŋ bɛkʉ yɛ̌nyɨŋ ndu Ɛfóŋó mmu. Mandɛm kɛ̌ bǎbhɔ́ŋɔ́ bɛ́cháy. Yí kɛ ábhɔ́ŋɔ́ bɛtaŋ bɛchyɛ mmʉɛt mmu nɛ ɛfóŋó mmu ɛsɔŋɔri amɛm nɛpǐngo. ");
INSERT INTO kenNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Pú mmu ǎkwáy bɛku bɔ̌kɛnɛn bapay nɛ nkáp anɛ apu yɛ̌nyɨŋ? Yɛ̌ nɔ́, yɛ̌ mɔ́sɛnɛn amɔt apú kway bɛkwɛn amɨk ɛnɛ́ Ɛtayɛka mmu achi amfay abhɨkɨ rɨŋɨ. ");
INSERT INTO kenNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ɛnyu yɔ kɛ ɛ́chí nɛ bhe. Mandɛm arɨ́ŋɨ́ yɛ̌ chí mpǎy bɛkaká ɛmɛnɛ ɛbhɛn bɛ́chí yɛ̌ntɨkɨ mmu ywɛka anti. ");
INSERT INTO kenNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Bǎkɛ́ chay yɛ yɛ̌nyɨŋ ɛnɛ́ bo bakway bɛkʉ bhe. Bɛsí Mandɛm, yɛ̌ntɨkɨ mmu ywɛka abhɔŋ mɛnwɔp tontó achá ngɛ́mtáy kɛnɛn.” ");
INSERT INTO kenNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Yɛ̌ntɨkɨ mmu anɛ árɛ̀m kpoŋoroŋ bɛsí bǒ mmɨk bɛ yi achi mmu wa, chɔŋ mɛnkwɔ́ ndɛm bɛsí Ɛtaya mmu achi amfay ndǔ nywɔp manyé, bɛ mmu wu achi awa. ");
INSERT INTO kenNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kɛ mmu anɛ átáŋá bɛsí bho bɛ yi apu mmu wa, chɔŋ mɛnkwɔ́ ntaŋa bɛsí Ɛtaya mmu achi amfay bɛ yi apu mmu wa.” ");
INSERT INTO kenNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Bǎkɛ́ kaysi bɛ ntwɔ fá amɨk chi bɛkʉ bo mámbák ndu kpák nɛ batɨ. Ǎe. Ntwɔ chi bɛ bo mánú nɛ batɨ. ");
INSERT INTO kenNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ntwɔ bɛkʉ bɔ̌ abhɛn babhakanɛm mánú nɛ bachi bhap, abhɛ́n baghɔrɛ́ mánú nɛ manɔ nɛ baghɔrɛ́ mánú nɛ manɔ̌ manɛ́m abhap. ");
INSERT INTO kenNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Bǒmpap báfù chi ɛkɛt mbɔ̌ŋ mmu. ");
INSERT INTO kenNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Mbák ɔkɔŋ ɛtayɛ, nɛ yɛ̌ chí máyɛ ɔchá mɛ, nɔ́ ɔbhɨ́kɨ́ kway bɛbhak nkoŋo wa. Nɛ mbák ɔkɔŋ mɔ́ywɛ ɔcha mɛ, nɔ́ ɔbhɨ́kɨ́ kway bɛbhak nkoŋo wa. ");
INSERT INTO kenNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mmu anɛ ábhɨ́kɨ́ ka bɛpɔkɔ ɛkotákátí ɛyi ankoŋo ndǔ bayarɛ́kak aya, abhɨ́kɨ́ kway bɛbhak nkoŋo wa. ");
INSERT INTO kenNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mmu anɛ arɛmɛ bɛ abhɨ́kɨ́ rɨŋɨ mɛ ndǔ áyàŋ bɛ ámpɛ́mɛ́ mmʉɛt yi, apú bhɔŋ nɛpɛ́m ɛnɛn tɛtɛp. Kɛ mmu anɛ áká bɛ́gu ɛ̌ti ya, ǎbhɔŋ nɛpɛ́m ɛnɛn tɛtɛp.” ");
INSERT INTO kenNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Yɛ̌ agha anɛ ásɔ̀t bhe sayri, ǎsɔt chi mɛ. Nɛ yɛ̌ agha anɛ ásɔ̀t mɛ sayri, ǎsɔt chi Ɛta mmu átó mɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mbák ɔsɔt mmu sayri mbɔnyunɛ ɔrɨ́ŋɨ́ bɛ yi achi ndɛmɛkɛpɨ̌ntɨ wa, chɔŋ Mandɛm anchyɛ wɔ nkúbhɛ́ akap anɛ yi áchyɛ ntá ndɛmɛkɛpɨ̌ntɨ ywi. Nɛ mbák ɔsɔt mmu sayri mbɔnyunɛ ɔrɨ́ŋɨ́ bɛ ǎkʉ̀ chi ɛnyɨŋ ɛnɛ Mandɛm áyàŋ bo mankʉ, chɔŋ Mandɛm anchyɛ wɔ akap mbɔ mmu anɛ ákʉ̀ ɛnyɨŋ ɛnɛ Mandɛm áyàŋ bo mankʉ. ");
INSERT INTO kenNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Dɨŋɨ́ ká bɛ yɛ̌ agha anɛ áchyɛ́ yɛ̌ chí manyiɛp bakwɛn ntá yɛ̌ mmu amɔt ndǔ nkwɔ bɔ̌bha bhɛn mbɔnyunɛ achí nkoŋo wa, dɨŋɨ́ bɛ Mandɛm abhɔŋ bɛchyɛ yi akap.” ");
INSERT INTO kenNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu ánáŋá nɔ́kɔ́ bɛghati baghɔk abhi bati byo nɛ apay ɛnyɨŋ ɛnɛ bɔ bábhɔ́ŋɔ́ bɛkʉ, afa nɛbhʉɛt yi achi nɛ bhɔ arɔk ndǔ bɛtɔk Israɛl bɛ́chák ndu bɛghati bo Mbok Ndɨ́ndɨ́. ");
INSERT INTO kenNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Mpok yɔ, Jɔ̌n Njwiti abhak ɛkɛrɛ́kɛnɔŋ. Ághókó nɔ́kɔ́ mɛnyɨŋ ɛbhɛn Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò ákʉ̀, ató mbɔk bakoŋo bhi bɛ mándɔ́k mámbɛ́p Yesu bɛ, ");
INSERT INTO kenNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Wɔ kɛ ɔ́chí Mpɛmɛ anɛ Jɔ̌n árɛ́mɛ́ bɛ ǎtwɔ, kɛ chi bɛ sɛ́bhɔŋ mɛnoŋ mmu achak?” ");
INSERT INTO kenNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu akɛmɛ bhɔ bɛ, “Pɛt ka nsɛm ghatí Jɔ̌n mɛnyɨŋ ɛbhɛn bǎghókó bo bárɛ̀m, nɛ ɛbhɛn be babhɔŋ bǎghɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Bǎghok nɛ bǎghɔ bɛ manɛ́mámɨk bághɔ̀ mbaŋ nɛ́nɛnɛ, nɛ bakɛm báfáté bákɔ̀. Bǒ ɛbhaŋákwa bátáŋ nɛ bachókó batú bághòk mbaŋ. Bawú bápɛtnsɛm ndǔ nɛpɛ́m nɛ bo bághàti bachɛ́bhɛ́bho Mbok Ndɨ́ndɨ́. ");
INSERT INTO kenNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ɛ́rɨ ɛcha ntá mmǔ anɛ ápú kwɛ́n ndǔ bɛbʉ́ ɛ̌ti mɛnyɨŋ ɛbhɛn mɛ̌kʉ̀.” ");
INSERT INTO kenNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ɛnɛ́ bakoŋo Jɔ̌n bárɔ́ bárɔ̀ŋ, Yesu abho bɛrɛm ntá bɛyǎ bo abhɛn bátwɔ̀ nɛbhʉɛt anɛ yi achi ɛ̌ti Jɔ̌n bɛ, “Mpok bǎrɔ̀ŋ nyaka awu amɛm baso, bǎrɔ́k bɛghɔ ntɨkɨ ɛnyǔ mmʉ? Bǎrɔk bɛghɔ mmu anɛ achi mbɔ ɛ̌nsɔ́manyiɛp ɛnɛ babhʉɛ́p áfòk ɛ́nkwɛ́n ɛnɛ ɛbhe, ámfok ɛnkwɛn ɛbhe ɛ́chák kɛ? ");
INSERT INTO kenNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Bǎrɔŋ nyaka amɛm baso bɛghɔ yi? Mmu anɛ afyɛ́ bɛrɨ́tí ndɛn amʉɛt kɛ? Bǒ abhɛn báfyɛ̀ mɛnyǔ ndɛn ɛbhɔ báchɔ̀kɔ chi amɛm bɛkírí-bafɔ! ");
INSERT INTO kenNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ghatí ká mɛ. Bǎrɔŋ nyaka amɛm baso bɛ́ghɔ ntɨkɨ ɛnyʉ̌ mmu? Ndɛmɛkɛpɨ̌ntɨ? Ɛ́chi tɛtɛp. Kɛ dɨŋɨ ka bɛ mmu anɛ bǎghɔ́ achá ndɛmɛkɛpɨ̌ntɨ. Bě bǎrɔ́k yɛ bɛghɔ kpɨk yi? Bǎrɨŋɨ bɛ bǎrɔ́ŋ nyaka chi bɛghɔ ndɛmɛkɛpɨ̌ntɨ? Kɛ dɨŋɨ́ ka bɛ, Jɔ̌n acha barɛmɛ́ kɛpɨ̌ntɨ báchák. ");
INSERT INTO kenNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jɔ̌n kɛ̌ achi mmu anɛ Ɛkáti Mandɛm ɛ́rɛ̀m ɛ̌ti yi bɛ, ‘Mandɛm arɛm nyaka bɛ, Yɨŋɨ́, chɔŋ ntó mpɔkɔntó wa wɔ ambɨ, bɛ ángókó mbi ywɛ kɛ ɔ́ntwɔ.’” ");
INSERT INTO kenNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yesu arɔk ambɨ bɛrɛm bɛ, “Nchí ghati bhe bɛ Jɔ̌n Njwiti acha yɛ̌ntɨkɨ mmu achak, ndǔ bo abhɛn bágú nɛ abhɛn bachi nɛpɛ́m. Yɛ̌ nɔ́, yɛ̌ chí mmu anɛ apu yɛ̌nyɨŋ ndǔ mpáy bo abhɛn mányìɛ̀ Kɛfɔ̌ mfáy acha yi. ");
INSERT INTO kenNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Bɛ́bhó ndǔ mpok anɛ Jɔ̌n Njwiti ághàti nyaka bho Ɛyɔŋ Mandɛm bɛghaka ɛchɔŋ, Kɛfɔ̌ mfáy kɛ́gò nɛ bɛtaŋ nɛ mbɔk bho mánù bɛ́chwe arɛ nɛ bɛtaŋ. ");
INSERT INTO kenNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Jɔ̌n ápɛ́rɛ tó bǒ bɛtɨk bhi, basɨŋ amɛn Moses nɛ amɛn barɛmɛ́ kɛpɨ̌ntɨ ǎrɛm nyaka ɛ̌ti Mpɛmɛ Mandɛm afyɛ́ bariɛp bɛ ǎto. ");
INSERT INTO kenNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Mbák bǎbhɔŋ ntɨ mɛnoko ɛnyɨŋ ɛnɛ mɛ̌rɛm, dɨŋɨ́ ká bɛ sayri sayri mpok anɛ barɛmɛ́ kɛpɨ̌ntɨ bárɛ́mɛ́ bɛ Ɛláija ǎtwɔ̀, bárɛ̀m nyaka chi ɛ̌ti Jɔ̌n. ");
INSERT INTO kenNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Yɛ̌ agha anɛ áyàŋ bɛghok ɛnyɨŋ ɛnɛ mɛ́rɛ̀m, ántá batú ángók sayri. ");
INSERT INTO kenNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Chɔŋ njɛnti mkpáká bho abhɛn ɛchɔŋ nɛ yi? Báchí mbɔ bɔ̌ abhɛn báchɔ́kɔ́ nɛfísiɛ bákʉ̀ ntok. Ɛka ɛ́mɔt barɛm ntá abhɛn ɛka ɛchak bɛ, ");
INSERT INTO kenNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Sɛ́kwáy bakwáy nɛbhay bɛ mǎmbɛn nɛbhɛ́n kɛ bǎbhɨkɨ bhɛn. Sɛ́kwáy bakwáy nɛwú, kɛbhɔ bě kɛdi!’ ");
INSERT INTO kenNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jɔ̌n Njwiti atwɔ nyaka antarɛ nɔkɔ nsay ndu mɛnɨkmʉɛt nɛ mmɛm yi kɛ nyu. Yɛ̌ntɨkɨ mmu are rɛm bɛ, ‘Ɛfóŋó ɛbʉ́bʉ ɛchi nɛ yi!’ ");
INSERT INTO kenNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mpok Mɛ Mmu mfú ntá Mandɛm ntwɔ́, nde nyiɛ, nnyú nɔkɔ nɛ bhe. Yɛ̌ntɨkɨ mmu arɛm bɛ, ‘Yɨŋɨ́ nyiɛ̌ mɛnyɨŋɨ́nyíɛ́ nɛ nyǔmɛ́m wu. Mamʉrɛ bhi chi babhɛbhɛ́ nkábhɛ́nti nɛ bakʉ̌ bɛbʉ́ bachak!’ Kɛ dɨŋɨ́ ká bɛ mɛnyɨŋ ɛbhɛn mmu anɛ ákòŋo mbi Mandɛm ákʉ̀ kɛ bɛ́tɔ̀ŋ bɛ nɛrɨŋɨ́ndak ɛnɛn nɛ́fú ntá Mandɛm nɛchi tɛtɛp.” ");
INSERT INTO kenNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Bǒ abhɛn báchí nyaka amɛm bɛtɔk ɛbhɛn Yesu ákʉ́ bɛyǎ mɛnyɨŋɨ́ maknkay, bábhɨ́kɨ́ tɨ́k nyaka nsɛm ndǔ bɛbʉ́ bhap. Ɛ́kʉ Yesu abho bɛji bhɔ andɛmɛ nɔkɔ bɛ, ");
INSERT INTO kenNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Bě bo Korasín, chɔŋ ɛ́mbɛ́p ntá yɛka ɛncha! Bě bo Bɛtsáida, chɔŋ ɛ́mbɛ́p ntá yɛka nkwɔ ɛncha! Mbɔ chí amɛm bɛtɔk Táya nɛ Sídɔn kɛ nkʉ́ mɛnyɨŋɨ́ maknkay ɛbhɛn-nɛ nkʉ ntá yɛka, mbʉ́ báfyɛ́ ndɛn pyɔ, mánto batwɔ́p anti tɛsáy, bɛtɔŋ bɛ bátɨ̀knsɛm ndǔ bɛbʉ́ bhap! ");
INSERT INTO kenNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nchí ghati bhe bɛ, ɛwak ɛnɛ Mandɛm átàŋ bǒ mmɨk, chɔŋ angɔ́ ntínso nɛ bǒ Táya nɛ Sídɔn ɛncha bhe! ");
INSERT INTO kenNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nɛ bě bho Kapɛ̌naum, bǎkaysi bɛ bǎkway bɛyoŋ mmʉɛt, mǎnkó kpát mǎntɔk nɛbu? Nsé! Chɔŋ Mandɛm amɛsɛ bhe amɛm ɛtɔkɔ́ bawú! Mbɔ amɛm ɛtɔk Sídɔn kɛ nkʉ́ mɛnyɨŋɨ́ maknkay ɛbhɛn-nɛ nkʉ ntá yɛka, mbʉ yɔ ɛbhʉɛt téé tɛ̌ ɛchɔŋ! ");
INSERT INTO kenNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Dɨŋɨ́ yɛ́ ka bɛ, ɛwak ɛnɛ Mandɛm átàŋ bǒ mmɨk, chɔŋ angɔ́ ntínso nɛ bǒ ɛtɔk Sódom ancha bhe.” ");
INSERT INTO kenNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ndǔ mpok yɔ, Yesu ánɨkmʉɛt bɛ, “Ɛta, wɔ mmu ɔ́bhɔ́ŋɔ́ mfay nɛ mmɨk! Nchí chyɛ wɔ bakak ndǔ ɔ́rɔ́ mɛnyɨŋ ɛbhɛn mɛ́mbák bhɛ́sɛ́ bhɛ́sɛ́ ntá barɨŋɨ́ndak nɛ ntá bo abhɛn bárɨ́ŋɨ́ bɛyǎ mɛnyɨŋ. Ɔnɛ́nɛ́ bhɔ ɔtɔŋ kpoŋoroŋ ntá bo abhɛn bábhɨ́kɨ́ rɨŋɨ yɛ̌nyɨŋ mbɔ mǎmbɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ɛta, ɛnyu yɔ kɛ̌ wɔmbɔŋ ɔ́yáŋá bɛ ɛmbak.” ");
INSERT INTO kenNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yesu apɛt abho bɛghati bho bɛ, “Ɛtaya achyɛ́ mɛ mɛnyɨŋ mɛnkɛm. Yɛ̌ mmu abhɨ́kɨ́ rɨŋɨ mmu anɛ Mmɔ áchí ɛ́bhɨ́kɨ́ fʉɛt chí Ɛtayi. Nɛ yɛ̌ mmu abhɨkɨ rɨŋɨ mmu Ɛta áchí ɛ́bhɨ́kɨ́ fʉɛt chí Mɔ́ywi nɛ bǒ abhɛn yi áyábhɛ́ ndu bɛkʉ bɔ mándɨ́ŋɨ́ Ɛtayi. ");
INSERT INTO kenNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Twɔ́ ká ntá ya, bě mankɛm abhɛn bǎpɔ́kɔ́ mɛnwɔ́ptí batǔ bɛsɔŋɔri nɛ bǎpɔp, chɔŋ nsɛbhɛ yɔ amɨk, nchyɛ́ bhe nɛywɛ̌mʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Sɔt ka bɛtɨk ɛbhɛn nchyɛ́ bhe, mǎngɔ́k mɛnyɨŋ ɛbhɛn mɛ̌tɔ̀ŋ bhe mbɔnyunɛ nchí kpák ndǔ ɛpɨŋ ɛya nɛ nɛyoŋómʉɛt nɛ́pú mɛ antɨ. Kʉ ka nɔ́ chɔŋ mǎmbɔŋ nɛywɛ̌mʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Twɔ́ ká ntá ya mbɔnyunɛ ntu ánɛ mɛ̌chyɛ bhe achi fuyak.” ");
INSERT INTO kenNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ɛ́bhɨ́kɨ́ tat, Yesu nɛ baghɔk abhi báré kɔ mámfʉɛt nɔkɔ amɛm nkɨ̌ nchwifú ndǔ nywɔbhɛ́ nɛywěmʉɛt bo Israɛl. Nsay are nu baghɔk abhi. Ɛ́kʉ bábho bɛ́kʉɛp ɛnyǔ nchwi yɔ, mányiɛ nɔkɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mbɔk bǒnkwɔ Fárisi bághɔ́ nɔ́kɔ́ nɔ, bárɛ́m ntá Yesu bɛ, “Yɨŋɨ́, baghɔkɔ́ bhɛ bákʉ̀ ɛnyɨŋ ɛnɛ ɛ́pú chak bɛkoŋo ɛbhé yɛsɛ. Bákʉɛ̀p nchwi ndǔ nywɔbhɛ́ nɛywěmʉɛt!” ");
INSERT INTO kenNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Kɛ Yesu akɛmɛ bɛ, “Bǎbhɨ́kɨ́ re pay amɛm Ɛkáti Mandɛm ɛnyɨŋ ɛnɛ Mfɔ Debhít ákʉ́ nyaka nɛ bǒ abhɛn báchí nɛ yi mpok nsay ákɛ́mɛ́ bhɔ́? ");
INSERT INTO kenNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Achwe nyaka amɛm ɛkɛrɛ́ Mandɛm, yi nɛ bǒbhi, mányíɛ́ nɛnyíɛ́ ɛnɛn báchyɛ́ ntá Mandɛm. Bɛ́kóŋo ɛbhé, ɛpú nyaka chak bɛ yi nɛ bǒbhi mányiɛ nɛnyíɛ́ ɛnɔ. Ndiɛrɛ bachiǎkap Mandɛm kɛ bábhɔ́ŋɔ́ nyaka ngǎngaŋ mɛnyiɛ nɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nɛ bɛ́rɔ́ŋ ambɨ, bǎbhɨ́kɨ́ re pay amɛm ɛkáti Moses bɛ bachiǎkap bákʉ̀ bɛtɨk amɛm ɛkɛrákap Mandɛm ndǔ nywɔbhɛ́ nɛywěmʉɛt kɛ? Ɛyɔ ɛ́kʉ bɛ bɔ́ mánkwɛ́n ɛbhé ɛnɛ ɛ́rɛ̀m bɛ mmu ákɛ́ kʉ bɛtɨk ndǔ nywɔbhɛ́ nɛywɛ̌mʉɛt kɛ? Bábhɨ́kɨ́ rɛm bɛ bɔ bákʉ bɛbʉ́. ");
INSERT INTO kenNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nchí ghati bhe bɛ, mmu achí fá anɛ áchá ɛkɛrákap Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mandɛm ághàti bhɛsɛ mbɔ ɛnyu ɛ́chí amɛm ɛkáti yi bɛ, yi ǎrɛ̀m bɛ, ‘Ɛnyɨŋ ɛnɛ mɛ̌yáŋ chi bɛ bo mángɔ́ ntínso nɛ batɨ, puyɛ̌ chi akabhɛ́nya. Mbɔ bě bǎrɨŋɨ ntí bɛyɔŋ ɛbhɛn, mbʉ bǎbhɨ́kɨ́ ji bǒ abhɛn bɛ́kwɛ́nɛ́ bɛ́pú nɛ bhɔ.’ ");
INSERT INTO kenNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Dɨŋɨ́ yɛ́ ka bɛ Mɛ Mmu mfú ntá Mandɛm kɛ̌ mbɔ́ŋɔ́ bɛrɛm ɛnyǔ mmu ábhɔ́ŋɔ́ bɛkʉ nɛ ɛbhé ɛnɛ ɛ́yɨ́ŋɨ́ nywɔbhɛ́ nɛywěmʉɛt.” ");
INSERT INTO kenNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu arɔk ɛtɔk ɛ́chák achwe amɛm ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí ɛyap. ");
INSERT INTO kenNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mmu amɔt abhak amɛm ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí ɛyɔ anɛ awɔ ywi ágú. Mbɔk bo bábhák arɛ́ abhɛn báyàŋ mbi bɛ́rɛ́m bɛ bɛkwɛ́nɛ́ bɛ́chí nɛ Yesu. Bábhɛ́p Yesu bɛ, “Ɛbhé yɛsɛ ɛ́rɛ̀m bɛ ɛ́pu chak bɛbu mmu ndǔ nywɔbhɛ́ nɛywěmʉɛt kɛ?” ");
INSERT INTO kenNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu akɛmɛ bhɔ bɛ, “Ntɨkɨ mmu ywɛká anɛ, mbák abhɔŋ ághɔ́ŋɔmɛn amɔt, ákwɛ́n nɔ́kɔ́ amɛm nɛpi ndǔ nywɔbhɛ́ nɛywěmʉɛt, andɔ, kɛfɛrɛ wu? ");
INSERT INTO kenNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ná nɛ nkwǎŋwaŋ mmu áchá ághɔ́ŋɔmɛn tontó? Ɛyɔ ɛ́tɔ̀ŋ bɛ ɛbhé ɛyɛsɛ ɛ́pú káŋ mmu bɛkwak ntɨ ndǔ nywɔbhɛ́ nɛywěmʉɛt.” ");
INSERT INTO kenNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yesu arɛm ntá mmu anɛ awɔ ágú bɛ, “Nyabhɛ́ awɔ́ ywɛ.” Anyabhɛ, awɔ́ wu ápɛt ataŋ, abhak mbɔ áchák. ");
INSERT INTO kenNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Bǒnkwɔ Fárisi abhɛn bachi arɛ́ baghɔ nɔkɔ nɔ, báfú, bárɔ́k. Báte ɛyu, batɨ bɛway Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu arɨŋɨ bɛ báte ɛyu ndu bɛway yi. Afa, arɔk ɛbhak ɛ́chák. Bɛyǎ bho bákóŋo yi, abú bo mankɛm abhɛn mámè. ");
INSERT INTO kenNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Yesu asɛmti bhɔ bɛ bákɛ́ ghati bo bachak ɛnyɨŋ ɛ̌ti yi. ");
INSERT INTO kenNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ɛ́fákárí ɛnyu yɔ bɛ ɛnyɨŋ ɛnɛ ndɛmɛkɛpɨ̌ntɨ Aisáya árɛ́mɛ́ nyaka ɛ́mfú tɛtɛp. Mandɛm aghátí nyaka Aisáya andɛm ɛ̌ti yi bɛ, ");
INSERT INTO kenNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ghɔ́ ka mɔ̌bɛtok wa anɛ njábhɛ́. Chi Mɔ̌ntɨ wa nɛ mbɔ̌ŋ maŋák nɛ yi tontó. Chɔŋ nkʉ Ɛfóŋó ya ɛ́mbák nɛ yi. Nɛ chɔŋ yí ankʉ mǎngati manɛrɛ́kɛt bǒ mmɨk ankɛm bɛ chɔŋ yí ampɛmɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Apú bhak mbɔ mmu anɛ ánù bɛ bo mángók yi. Apú bhak mbɔ mmu anɛ bághok ɛyɔŋ ɛyi nɛfí. ");
INSERT INTO kenNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Yí ápú syɛp nkɔ́rɛ́-tákɔ́ anɛ abho bɛwɔsi, arɔp chi bɛ́gu. Nɛ apú nɛmɛ ɛrɔ́ŋɔ́ ɛnɛ bawɛt amay amɛm, ɛ́rɔ́p chi mandú mɛ́nɛ́mɛ. Ɛnyu yɔ kɛ̌ yi arɔŋ ambɨ bɛghɔ bhɔ ntínso, kpátɛ yi ankʉ nkaysi anɛ achi tɛtɛp ansɔt awɔ́nɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nɛ chɔŋ bǒ bɛtɔkɔ́ mmɨk mɛnkɛm mámbaka ntɨ chi nɛ yi bɛ ampɛmɛ bhɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ɛ́tárɛ́ nɔ́kɔ́, bǒfú básɔt mbók bárɔ́k ntá Yesu nɛ yi. Ɛfóŋó ɛbʉ́bʉ kɛ ɛ́kʉ́ nyaka amɨ́k anɛ́mɛ́ yi nɛ akwɛ́n kɛbhok. Yesu abú yí, abho bɛrɛm kɛpɨ, nɛ abho bɛghɔ mbaŋ. ");
INSERT INTO kenNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Bǒ mankɛm abhɛn bachi arɛ babhak maknkay tontó, bábho bɛbhɛp batɨ, mándɛmɛ nɔkɔ bɛ, “Ɛbhárɛ́mɔ Debhít nɛ́ kɛ?” ");
INSERT INTO kenNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kɛ bǒnkwɔ Fárisi bághókó nɔ́kɔ́ nɔ́, babho bɛrɛm bɛ, “Chí Bɛlsɛbul, mfɔ bɛfóŋó bɛbʉ́bɛbʉ kɛ áchyɛ́ Yesu bɛtaŋ bɛ́bók bɛfóŋó bɛbʉ́bɛbʉ bɛ mɛ́mfú, mɛ́ndɔ́, bho.” Mmǔ achák apú! ");
INSERT INTO kenNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu arɨŋɨ nkaysi yap. Arɛm ntá yap bɛ, “Yɛ̌ntɨkɨ ɛtɔk ɛnɛ ákɔ́rɛ́ áchí arɛ nɛ bǒbati mánu nɔkɔ nɛ batɨ, ɛ́bhɔ́ŋ chi mɛ́nɛ́mɛ́. Nnɛrɛ́kɛt anɛ ákɔ́rɛ́ achi arɛ ákwɛnɛ kwɛn. ");
INSERT INTO kenNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ɛnyu yɔ kɛ ɛchi nɛ kɛfɔ Satan. Mbák Satan ǎbók Satan, ná kɛfɔ ɛki kɛ́tee? ");
INSERT INTO kenNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nɛ mbák nchí bók bɛfóŋó bɛbʉ́bɛbʉ chi ndǔ bɛtaŋ Bɛlsɛbul, bǒ bhɛka básɔ̀t bɛtaŋ ághá bɛ́bók bhɔ mɛ́ndɔ́ bhó? Ɛ̌ti yɔ chɔŋ bɔ́ mántaŋ be. ");
INSERT INTO kenNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kɛ mbák, sayri sayri, mɛ̌bòk bɛfóŋó bɛbʉ́bɛbʉ chi ndǔ bɛtaŋ Ɛfóŋó Mandɛm, nɔ́ Mandɛm anaŋ achi nɛntɨ ɛnɛka mbɔ Mfɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Yɛ̌ mmu apu kway bɛchwe amɛm ɛkɛt ɛnɛ mmǔ ntantaŋ angɛ́p ɛnyɨŋ, ampɔkɔ, andɔk nɛ yɔ́, mbák abhɨ́kɨ́ yambɨ ankɛm yi angwɔt. ");
INSERT INTO kenNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Yɛ̌ agha anɛ ápú nɛ mɛ, achí chí mǔmpap awa. Nɛ yɛ agha anɛ ápú kwak mɛ mɛnyokoti bho, ǎtàkátak. ");
INSERT INTO kenNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Dɨŋɨ́ yɛ́ ka bɛ, Mandɛm ǎfoŋori bɛbʉ́ ɛbhɛn bo bákʉ̀ nɛ bɛbɛ́ptí mɛnyɨŋ ɛbhɛn bɔ bárɛ̀m. Kɛ apú foŋori mmu anɛ árɛ̀m bɛbɛ́ptí mɛnyɨŋ ɛ̌ti Ɛfóŋó Bɛdyɛrɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mandɛm ǎfoŋori yɛ̌ agha anɛ árɛ̀m ɛbɛ́ptí ɛnyɨŋ ɛ̌ti nnyɛ́n ɛna, Mɛ Mmu mfú ntá Mandɛm, kɛ apú foŋori mmu anɛ árɛ̀m ɛbʉ́bʉ ɛ̌ti Ɛfóŋó Bɛdyɛrɛ. Mandɛm apú foŋori yi, yɛ̌ ndǔ mmɨkɨ nɛ, nɛ yɛ̌ ndǔ mmɨk nkɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yesu arɔk ambɨ bɛrɛm bɛ, “Mbák ɛnɔk ɛ́rɨ, kɛpɛm ɛki nkwɔ kɛ́rɨ́. Mbák ɛnɔk ɛbhɔ̌ŋ nɛme, kɛpɛm ɛki nkwɔ́ kɛ́bhɔ́ŋ nɛme. Mmu ǎrɨŋɨ ɛnɔk chí ndǔ kɛpɛm ɛki. ");
INSERT INTO kenNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Bě bɛfé, nɔ́ kɛ ɛ́chí nɛ bhe. Ná bɛrɨ́tí kɛpɨ kɛkwáy yɛ bɛ́fú be anyu ɛnɛ́ bǎchí bǒ bɛbʉ́? Ɛnyɨŋ ɛnɛ́ ɛ́jwí mmu antɨ, yɔ́ kɛ ɛ́fù yi anyu. ");
INSERT INTO kenNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nkúbhɛ́ mbɔ ɛnyǔ mɛnyɨŋ nkáp bɛ́jwi amɛm mɔ́kɛrɛ nkáp, nɔ́ kɛ̌ nkaysi ndɨ́ndɨ́ ájwì antɨ mmu ndɨ́ndɨ́, nɛ bɛrɨ kɛ bɛ́fu arɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Dɨŋɨ́ ká bɛ, ɛwak ɛnɛ Mandɛm átàŋ bǒ mankɛm, yɛ̌ntɨkɨ mmu ǎghati yí ɛnyɨŋ ɛnɛ ɛ́kʉ́ kɛ yɛ̌ntɨkɨ ɛpɔ̌ ɛyɔŋ ɛ́fú yi anyu. ");
INSERT INTO kenNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kɛpɨ ɛkɛn kɛ́fù wɔ anyu kɛ̌ yi ásɔt antáŋ wɔ ɛwak ɛ́mɔt. Mbák bɛrɨ́tɨ́ kɛpɨ kɛ kɛ́fù wɔ anyu, ɛwak ɛyɔ, yi ǎrɛm bɛ ɔbhɨ́kɨ́ bhɔŋ manyé. Kɛ mbák bɛbɛ́ptí kɛpɨ kɛ kɛ́fù wɔ anyu, ɛwak ɛyɔ, Mandɛm ǎrɛm bɛ ɔ́kwɛ̌n manyé.” ");
INSERT INTO kenNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Mbɔk batɔŋ ɛbhé Mandɛm nɛ bǒnkwɔ Fárisi bárɛ́m ntá Yesu bɛ, “Ntɔŋ, tɔ́ŋ ɛrɨŋɨ́ maknkay ɛnɛ ɛ́kway bɛtɔŋ bɛ bɛtaŋ ɛbhɛ bɛ́fú ntá Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu akɛmɛ bhɔ bɛ, “Bɛbʉ́ ná nɛ mkpáká bho anɛ ɛchɔŋ! Bápú kʉ mbɔ ɛnyǔ Mandɛm áyàŋ. Báyàŋ bɛghɔ chi ɛrɨŋɨ́ maknkay! Kɛ yɛ̌ ɛ́mɔt mpú tɔŋ be, ɛ́bhɨ́kɨ́ fʉɛt chi ɛnɛ Jóna, ndɛmɛkɛpɨ̌ntɨ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nkúbhɛ́ mbɔ ɛnyǔ Jóna achi nyaka amɛm mɛniɛ̌ nsǐ-ngo ndǔ manywɔp arat, nɔ́ kɛ bábhɛmɛ chɔŋ Mɛ Mmu mfú ntá Mandɛm, mbak amɛm nnɛm ndǔ manywɔp arat. ");
INSERT INTO kenNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ɛwak ɛnɛ Mandɛm átàŋ bǒ mmɨk, bǒ ɛtɔk Ninivɛ báfate mángati bhe bɛ bǎkʉ bɛbʉ́. Ɛwak ɛyɔ, bɔ́ bárɛm nɔ ntá yɛka mbɔnyunɛ bɔ bátɨk nyaka nsɛm ndǔ bɛbʉ́ bhap mpok Jóna ághátí bhɔ Ɛyɔŋ Mandɛm. Nɛ́nɛ, mmu achí fá nɛ́ntɨ́ ɛnɛka anɛ áchá Jóna; yɛ̌ nɔ, bǎpu ka bɛtɨknsɛm ndǔ bɛbʉ́ ɛbhɛka. ");
INSERT INTO kenNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ɛwak Mandɛm átàŋ bǒ mmɨk, mfɔ ngɔrɛ́ anɛ áchí nyaka ɛtɔk Shɛ́ba ǎfate andɛm bɛ bǎkʉ bɛbʉ́. Ǎrɛm bɛ bǎkʉ́ bɛbʉ́ mbɔnyunɛ yi afu nyaka nɛkɔ nɛsiɛ arɔk bɛghok mɛnyɨŋ ɛbhɛn Mfɔ Sólomon átɔ̀ŋ bho nɛ bɛyǎ nɛrɨŋɨ́kɛpɨ. Nɛ nchí ghati bhe bɛ mmu achi fá nɛ́ntɨ́ ɛnɛka anɛ acha Sólomon, Yɛ̌ nɔ́, bǎpú ka bɛghok yi.” ");
INSERT INTO kenNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Bɛ́rɔ́ŋ ambɨ Yesu arɛm bɛ, “Mbák mámbók ɛfóŋó ɛbʉ́bʉ ɛ́ndɔ́ mmu, ɛ́rɔp chí bóŋboŋbóŋ amɛm baso, ɛ́njaŋ nɔkɔ ɛbhak ɛnɛ yɔ ɛ́chwe. Mbák ɛ́bhɨ́kɨ́ ghɔ́ ɛbhak bɛchɔkɔ, ");
INSERT INTO kenNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ɛ́rɛ̀m bɛ, ‘Chɔŋ mpɛtnsɛm ɛbhak ɛnɛ mfú.’ Nɛ ɛ́náŋ ɛ́mpɛ́tnsɛm, ɛ́ngɔ́ bɛ yɛ̌ mmu apu amɛm ɛsɨ́ ɛkɛt ɛyi, nɛ bɛ, mányɔ yɔ, bághókó sayri, ");
INSERT INTO kenNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ɛfóŋó ɛbʉ́bʉ ɛyɔ ɛ́rɔ̀ŋ yɛ, ɛ́nsɔt bɛfóŋó bɛbʉ́bɛbʉ bɛ́chák tándrámɔt ɛbhɛn bɛ́bɛ́bhɛ́ bɛcha yɔ. Bɔ́ mɛnkɛm mɛndɔk, mɛnchwe mmu wu amʉɛt, mɛ́mbak nɛ yi, nté yi ambɛ́p ancha anɛ mbɨ. Nɔ, kɛ̌ ɛ́bhɔ́ŋɔ́ bɛ́fákari nɛ be bo bɛbʉ́ abhɛn mkpák anɛ ɛchɔŋ.” ");
INSERT INTO kenNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ɛnɛ́ Yesu árɔ̀ŋ ambɨ bɛrɛm mɛnyɨŋ ɛbhɛn yi ághàti bho, máyi nɛ bɔ̌mayi bátwɔ́ bátee nɛfí, mánjaŋ nɔkɔ bɛrɛm kɛpɨ nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mmǔ amɔt aghati Yesu bɛ, “Máyɛ nɛ bɔ̌mayɛ báchí nɛfí téé, báyàŋ bɛrɛm kɛpɨ nɛ wɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Kɛ Yesu akɛmɛ mmu wu bɛ, “Sayri sayri, máya chí agha? Nɛ ntɨkɨ bho bachi bɔ̌maya?” ");
INSERT INTO kenNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Yesu asá awɔ ntá bakoŋo bhi, arɛm bɛ, “Máya chí bǒbhɛn, nɛ bɔ̌maya chí bǒbhɛn. ");
INSERT INTO kenNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Bǒ abhɛn bákʉ̀ ɛnyɨŋ ɛnɛ Ɛtaya mmu achi amfay áyàŋ bɔ́ mankʉ, kɛ báchí maya, nɛ bɔ̌maya.” ");
INSERT INTO kenNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nkúbhɛ́ nywɔp ɛnɔ, Yesu afú amɛm ɛkɛt ɛnɛ yi achi arɛ, arɔk achɔkɔ nɛku manyu. ");
INSERT INTO kenNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Bɛyǎ bo bákóŋo yi arɛ́. Yesu arɔ bho tété, arɔk achwe, achɔkɔ amɛm áchwí ɛnɛ́ bɛyǎ bǒbhɔ báté angɔkɔnyɛ́n. ");
INSERT INTO kenNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Abho bɛghati bhɔ bɛyǎ mɛnyɨŋ ndǔ bakay bɛ, “Ɛwak ɛ́mɔt, nkwaŋankɨ amɔt arɔk bɛtak ɛnyǔ nchwifú amɛm nkɨ ywi. ");
INSERT INTO kenNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ɛnɛ́ yi átàk árɔ̀ŋ, mbɔk akwɛnti ndǔ mɔ́mbi anɛ áchí amɛm nkɨ. Kɛnɛn kɛ́twɔ́ kɛ́bwɔ́pti nchwi yɔ nkɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Achák akwɛnti ndǔ mmɨk sɛtárɛ́bhɛ́ anɛ ntɔp abhɨkɨ ya arɛ. Awakari achak. ");
INSERT INTO kenNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kɛ mpok mmok áfú, ásɔ́ŋ yɔ ndǔ bakaŋ ayi ábhɨ́kɨ́ kway bɛchwe amɨk sayri. Anɨŋti, awɔsi. ");
INSERT INTO kenNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Anɛfú akwɛnti ndǔ mmɨk anɛ tákɔ nsěnse ágò arɛ. Achak are gó, kɛ tákɔ nsěnse agó áchɛt yɔ kpát agú. ");
INSERT INTO kenNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Nchwi áchák akwɛnti ndǔ mmɨk ndɨ́ndɨ́, achak, agó, achyɛ bɛyǎ nchwi. Nchwi ayá acha anɛ bápɨ́ ndɔŋ bɛsa bɛtay, achák ndɔŋ bɛsa bɛrat, anɛfu ndɔŋ ɛsa nsɛm byo.” ");
INSERT INTO kenNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ndǔ ngwɛnti, Yesu arɛm bɛ, “Mmu anɛ áyàŋ bɛghok, ántá batú ángók sayri.” ");
INSERT INTO kenNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yesu ánáŋá nɔ́kɔ́ bɛtɛm nɛkǎy nkwaŋankɨ, baghɔk abhi bárɔ́k ntá yi bábhɛ́p yi bɛ, “Ndaká yí ɔ́ghàti bho mɛnyɨŋ ndǔ bakay?” ");
INSERT INTO kenNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu akɛmɛ bhɔ bɛ, “Mandɛm akʉ mǎndɨŋɨ tɛtɛp anɛ áchí bhɛ́sɛ́ bhɛ́sɛ́, nɛ ɛyɔ ɛ́kwak bǎrɨŋɨ ɛnyǔ yi ábhák nɛ bho mbɔ Mfɔ wap. Kɛ abhɨ́kɨ́ kʉ nɔ nɛ bo bachak. ");
INSERT INTO kenNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mmu anɛ afyɛ́ ntí bɛghok mɛnyɨŋ ɛbhɛn mɛ́tɔ̀ŋ ǎjwimɛm. Mɛ̌kʉ yi andɨŋɨ bɛyǎ mɛnyɨŋ bɛchak. Kɛ mmǔ anɛ apu fyɛ ntí, yɛ̌ chi mandú ɛnyɨŋ anɛ yi arɨŋɨ básɔt ntá yi. ");
INSERT INTO kenNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ntí anɛ nchí ghati bhɔ mɛnyɨŋ ndǔ bakay achi bɛ, báyɨ̀ŋɨ kɛ bápú ghɔ, nɛ bághok mɛnyɨŋ mbɔ bɛ bápú ghok, nɛ bápú jwimɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Bǒbhɛn, bákʉ̀ ɛnyɨŋ ɛnɛ ndɛmɛkɛpɨ̌ntɨ Aisáya árɛ́mɛ́ nyaka ɛ́mfú tɛtɛp. Mandɛm akʉ nyaka Aisáya andɛm bɛ, ‘Chɔŋ mǎngoko ghok bɛyɔŋ ɛbha kɛ bǎpú jwimɛm wáwák; chɔŋ mǎnjɨŋɨ yɨŋɨ kɛ bǎpú ghɔ, ");
INSERT INTO kenNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ɛ́chí ɛnyu yɔ mbɔnyunɛ batɨ̌ bǒbhɛn ákʉ bárɔp bɛchɨŋtǐ bho, báchí mbɔ bǒ abhɛn batú ábé bhɔ nɛ bapu pɛrɛ yáŋ bɛghok yɛ̌nyɨŋ, báchí mbɔ bo abhɛn bákútí amɨ́k bɛ bákɛ́ ghɔ́ mbaŋ, nɛ bɛ́ batú yap ákɛ́ ghók yɛ̌nyɨŋ, nɛ bɛ bákɛ́ jwimɛm, mantwɔ ntá ya, mbú bhɔ.’” ");
INSERT INTO kenNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yesu arɔk ambɨ bɛrɛm bɛ, “Kɛ mbák chí bhe, ɛ́rɨ ntá yɛka ɛcha, mbɔnyunɛ amɨ́k ayɛka ághɔ̀ mbaŋ, nɛ batú yɛká ághòk mbaŋ. ");
INSERT INTO kenNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nchí ghati bhe bɛ, bɛyǎ barɛmɛ́ kɛpɨ̌ntɨ nɛ bǒ abhɛn báchí chak bɛsí Mandɛm bábhɔ́ŋ nyaka ɛkwak bɛghɔ mɛnyɨŋ ɛbhɛn bǎghɔ̀ kɛ bɔ kɛghɔ bhɔ. Bábhɔ́ŋ ɛkwak bɛghok mɛnyɨŋ ɛbhɛn bǎghòk, kɛ bábhɨ́kɨ́ ghok bhɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yesu arɔk ambɨ bɛrɛm bɛ, “Ghók yɛ́ ka ɛnyɨŋ ɛnɛ nɛkǎy mmu anɛ ataka mbwɔt nɛ́tɔ̀ŋ. ");
INSERT INTO kenNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Mbuɔt anɛ ákwɛ́ntí ndǔ mɔ́mbi anɛ achi amɛm nkɨ, até ndǔ mmu anɛ ághókó Mbok Ndɨ́ndɨ́ ɛ̌ti ɛnyu Mandɛm ábhak Mfɔ ywi, kɛ yi kɛjwimɛm, Satan atwɔ́ yɛ afɔŋɔ mbok anɛ Mandɛm ápɨ́ amɛm ntɨ ɛni. ");
INSERT INTO kenNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mbuɔt anɛ ákwɛ́ntí ndǔ mmɨk sɛtárɛ́bhɛ́ até ndǔ mmu anɛ ághòk Ɛyɔŋ Mandɛm, anoko tɛ́mté nɛ bɛyǎ maŋák. ");
INSERT INTO kenNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kɛ yi kɛbhɔ́ŋ bakaŋ amɨk. Ante kákáti ndu mɔ́mbɨŋɨ mpok. Kɛ mpok ɛsɔŋɔri ɛ́twɔ́ nɛ bo mámbo mɛnyok yi ɛ̌ti Ɛyɔŋ Mandɛm ɛnɛ yi anoko, amfɛrɛ amɔ tɛ́mté. ");
INSERT INTO kenNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nɛ mbwɔt anɛ ákwɛ́ntí ndǔ mmɨk tákɔ nsěnse, até ndǔ mmu anɛ ághòk Ɛyɔŋ Mandɛm, kɛ básɛ́mɛ́ ɛ̌ti mɛnyɨŋ mmɨk atwɔ́ nɔ́kɔ́ yi antɨ, nɛ ngoŋó nkáp, angɔkɔntɨk Ɛyɔŋ Mandɛm ɛnɛ ɛchi arɛ, Ɛyɔŋ Mandɛm yɔ kɛkwak yi ndǔ nɛpɛ́m ɛni. ");
INSERT INTO kenNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mbák chi mmu anɛ ághòk Ɛyɔŋ Mandɛm anjwimɛm, ɛ́mbak yi antɨ, achí mbɔ mbwɔt anɛ ákwɛ́ntí ndǔ mmɨk ndɨ́ndɨ́, achak, ágó sayri, achyɛ bɛyǎ mbwɔt nkɔ. Nɛ nsáy Ɛyɔŋ Mandɛm ndǔ nɛpɛ́m mmu achi mbɔ mbwɔt nkɔ anɛ áyá áchá anɛ bápɨ́, ndɔŋ ɛsa nsɛm byo, achák ndɔŋ bɛsa bɛrat, nɛ anɛfu ndɔŋ bɛsa bɛtay.” ");
INSERT INTO kenNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu atɛ́m nɛkay nɛ́chák bɛ, “Mbák Mandɛm ambak nɛ mmu mbɔ ɛnyǔ Mfɔ ábhák nɛ bɔ̌bhi, nɛpɛ́m ɛni nɛ́bhák mbɔ nkɨ anɛ́ mmǔfu ápɨ́ nchwi. ");
INSERT INTO kenNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kɛ mǔmpap arɔk nɛ bɛti ɛnɛ́ bo bábhʉ̀rɛ kɛnɔ́, aták nchaŋ, arɔk ɛbhak ɛyi. ");
INSERT INTO kenNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mpok nchwi ágó, abho mɛnyu kɛpɛm, kɛ bághɔ́ nchaŋ arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Bakʉ̌-bɛtɨk báfá bárɔ́k ntá mbɔŋɔ́nkɨ barɛm bɛ, ‘Ɛta, pú nchwi kɛ sɛ́pɨ́ amɛm nkɨ? Nchaŋ ɛ́fu árɛ́ fá?’ ");
INSERT INTO kenNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Akɛmɛ bhɔ bɛ, ‘Mǔmpap kɛ̌ ápɨ́ nɔ nchaŋ ɛyɔ.’ Bábhɛ́p yi bɛ, ‘Sɛ́ndɔ́k sɛ́mfɛ́rɛ́ yɔ́ ɛ́ndɔp chi nchwi yɔyɔ kɛ?’ ");
INSERT INTO kenNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mbɔŋɔ́nkɨ akɛmɛ bhɔ bɛ, ‘Dɔ̌ ká. Mbák mǎndɔ́k bɛfɛrɛ nchaŋ ɛyɔ, bǎkway bɛ́fɛ́rɛ mbɔk nchwi nkwɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Dɔ̌ ká yɔ ambak, mpok ánáŋ ánkwáy, chɔŋ ndɛm bǒ abhɛn báfɛ̀rɛ nchwi ɛbhɨ mánjámbɨ mamfɛrɛ nchaŋ ɛyɔ mányokoti ndǔ nɛbhʉɛt amɔt, mánsɔ́ŋ. Kɛ mǎmfɛrɛ nchwi mǎmbʉrɛ anywɔ́p.’” ");
INSERT INTO kenNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu atɛ́m nɛkay nɛ́chák bɛ, “Kɛfɔ Mandɛm fá amɨk kɛchi mbɔ sɛpɛm mɔ́nɔk anɛ bábhɨ̀ŋɨ bɛ mɔ́stat, anɛ bápɨ́ amɛm nkɨ. ");
INSERT INTO kenNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Sɛpɛmɛ mɔ́nɔk mɔ́stat sɛ́chí nɨ́ŋɨ́nɨ́ŋɨ́ tontó, kɛ mbák sɛ́nchák, sɛngo, sɛ́bhak nnɛt mɔ́nɔk anɛ áchɨk. Kɛnɛn kɛ́ntwɔ kɛnte manyay ndǔ batabhɛ yi.” ");
INSERT INTO kenNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu atɛ́m bhɔ nɛkay nɛ́chák bɛ, “Kɛfɔ Mandɛm fá amɨk kɛchi mbɔ yís anɛ ngɔrɛ́ ásɔ́rɛ́ achɛmti nɛ nchán fláwa ɛ́rát. Mandu yís wu akʉ fláwa nkɛm amwɔt, kpát ajwi ndǔ ɛnyɨŋ ɛnɛ yi achi arɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu aghati bho mɛnyɨŋ ɛbhɛn mɛnkɛm chi ndǔ bakay. Yi kɛ ghati bhɔ́ yɛ̌nyɨŋ ɛnɛ yi abhɨkɨ tɛ́m nɛkay. ");
INSERT INTO kenNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Atɛ́m bakay bɛtɔŋ bɛ ɛnyɨŋ ɛnɛ ndɛmɛkɛpɨ̌ntɨ Aisáya árɛ́mɛ́ nyaka bɛ chɔŋ ɛmfakari, ɛ́fákárí. Aisáya arɛm nyaka bɛ, “Chɔŋ ngati bhɔ mɛnyɨŋ chi ndǔ bakay, chɔŋ ntɔŋ bɔ mɛnyɨŋ ɛbhɛn Mandɛm ákʉ́ mɛ́mbák bhɛ́sɛ́ bhɛ́sɛ́, tɛ ndǔ nɛbhǒmɨk.” ");
INSERT INTO kenNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu arɔ yɛ bɛyǎ bǒ abhɛn bachi nɛfí, arɔk achwe anywɔ́p nɛ baghɔkɔ́ bhi. Arɛ́, baghɔkɔ́ bhi barɛm ntá yi bɛ, “Ɛta, ghatí bhɛsɛ ntí nɛkǎy nchaŋ.” ");
INSERT INTO kenNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu akɛmɛ bhɔ bɛ, “Mɛ Mmu mfú ntá Mandɛm kɛ̌ nchí mmu anɛ ápɨ́ nchwi amɛm nkɨ. ");
INSERT INTO kenNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nkɨ chí mmɨk nkɛm, nɛ nchwi chi bo abhɛn Mandɛm áchí Mfɔ wap. Nchaŋ chí bǒ Satan. ");
INSERT INTO kenNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mǔmpap anɛ ápɨ́ nchaŋ chi Satan. Mpok anɛ báfɛ̀rɛ mbwɔt ɛbhɨ chi nɛmǎy mmɨk, nɛ bakʉ̌ bɛtɨk abhɛn báfɛ̀rɛ mbwɔt ɛbhɨ chi bɔángɛl Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nkúbhɛ́ mbɔ ɛnyǔ báfɛ́rɛ́ nchaŋ, mányokoti nɛbhʉɛt amɔt básɔ́ŋ, ɛnyu yɔ kɛ ɛ́bhɔ́ŋɔ́ bɛ́fákari mpok mmɨk ámay. ");
INSERT INTO kenNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mpok yɔ, Mɛ Mmu mfú ntá Mandɛm, nchí to bɔángɛl bha mǎmfɛrɛ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ́ ɛ́twɔ̀ nɛ bɛbʉ́, nɛ yɛ̌ntɨkɨ nkʉ bɛbʉ́ ndǔ nkwɔ bo abhɛn mɛ nchí Mfɔ wap. ");
INSERT INTO kenNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Bɔangɛl bha báfɛ̀rɛ bhɔ mámɛsɛ amɛm nɛpǐngo. Arɛ́, bábhàk ndǔ nɛdǐ kɛbhɔ nɛ nɛnyiɛ́ ámɛ́n. ");
INSERT INTO kenNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mpok yɔ, bo abhɛn bachi chak bɛsí Mandɛm bághɔ̀ mbɔ mmok ndǔ nɛbhʉɛt anɛ Ɛtayap achi Mfɔ. Yɛ̌ntɨkɨ mmu anɛ áyàŋ bɛghok ɛnyɨŋ ɛnɛ mɛ̌rɛ̀m, ántá batú ángók sayri!” ");
INSERT INTO kenNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesu atɛ́m nɛkay nɛ́chák bɛ, “Kɛfɔ Mandɛm kɛchi mbɔ ɛnyɨŋ bɛyǎ nkáp ɛnɛ ɛchi bhɛ́sɛ́ bhɛ́sɛ́ amɛm nkɨ. Mmu amɔt ághɔ́ nɔ́kɔ́ yɔ, apɛt abhɛsɛ yɔ sayri, arɔ, arɔk nɛ bɛyǎ maŋák, ati yɛ̌ntɨkɨ ɛnyɨŋ ɛyi, asɔt nkáp, aku nkɨ wu.” ");
INSERT INTO kenNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yesu atɛ́m nɛkay nɛ́chák bɛ, “Kɛfɔ Mandɛm kɛ́chí mbɔ nkɔsíɛ́ anɛ áyàŋ bɛku batay bɛyǎ nkáp. ");
INSERT INTO kenNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ághɔ́ nɔ́kɔ́ nɛ́mɔ́t ɛnɛn nɛyá nkáp tontó, arɔk atí yɛ̌ntɨkɨ ɛnyɨŋ ɛyi, aku ntǎy bɛyǎ nkáp ɛnɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesu apɛt atɛ́m nɛkay nɛ́chák bɛ, “Kɛfɔ Mandɛm kɛchi mbɔ bɛyǎ nkáp anɛ́ bágʉɛ́bhɛ́ anyɛ́n nɛ ákɛ́m nsi mɛnyu nɛ mɛnyu. ");
INSERT INTO kenNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ásɨ ájwí nɔ́kɔ́ nɛ nsi, báya bákó ɛbhɨ, bachɔkɔ amɨk bayap nsi ɛnɛ ɛrɨ, báfyɛ́ ndǔ mɛnyɨŋ. Báto ɛnɛ́ ɛ́bhɨ́kɨ́ rɨ. ");
INSERT INTO kenNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ɛnyu ɛyɔ kɛ ɛ́bhàk chɔŋ mpok mmɨk ámay. Bɔangɛl bátwɔ̀, mámfɛrɛ bakʉ̌ bɛbʉ́ ndǔ nkwɔ bǒ abhɛn bachi chak bɛsí Mandɛm, ");
INSERT INTO kenNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","mámfyɛ́ amɛm nɛpǐngo. Arɛ́, bábhak ndǔ nɛdǐ kɛbhɔ nɛ nɛnyiɛ ámɛ́n.” ");
INSERT INTO kenNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu abhɛ́p baghɔkɔ́ bhi mbák bájwimɛm ndǔ mɛnyɨŋ ɛbhɛn yi ághátí bhɔ mɛnkɛm. Bákɛ́mɛ yi bɛ bajwimɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yesu arɛm bɛ, “Yɛ̌ntɨkɨ ntɔŋ ɛbhé Mandɛm anɛ ághɔ́kɔ́, árɨŋɨ ɛnyǔ Mandɛm ábhák nɛ bho mbɔ Mfɔ wap, achí mbɔ mbɔŋɔ́kɛt anɛ áfɛ̀rɛ mɛnyɨŋ bɛkɔ nɛ ɛbhɛn bɛsɨ amɛm mɔ́kɛt anɛ yi ábhʉ́rɛ́ mɛnyɨŋ.” ");
INSERT INTO kenNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu anaŋa nɔkɔ bɛtɛm bakay yɔ ndu bɛtɔŋ bo mɛnyɨŋ, afa atú ɛtɔk wu. ");
INSERT INTO kenNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Apɛtnsɛm ɛtɔk ɛyi Násárɛt. Ɛnɛ́ yi átɔ̀ŋ Ɛyɔŋ Mandɛm amɛm ɛkɛt ɛnɛ nɛnɨkɨ́mʉɛt ɛyap, bo bábhak maknkay tontó. Bábhó bɛbhɛp batɨ bɛ, “Aré bhɔŋ ɛnɛn ɛnyǔ nɛrɨŋɨ́ndak fá? Aré bhɔŋ bɛtaŋ fá ndu bɛkʉ bɛrɛm mɛnyɨŋɨ́ maknkay ɛnyu ɛnɛ? ");
INSERT INTO kenNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Pú mmɔ̌ nchwě mɛnɔk nɛ́? Pú María kɛ̌ achi máyi? Pú Jems, nɛ Josɛ́f, nɛ Símun, nɛ Júdas, chi bɔ̌mayi abhɛn babhakanɛm? ");
INSERT INTO kenNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Pú bɔ̌mayi abhɛn baghɔrɛ́ báchí fá mankɛm nɛbhʉɛt amɔt nɛ bhɛsɛ? Aré bhɔŋ ɛnyǔ nɛrɨŋɨ́kɛpɨ ɛnɛn, nɛ ɛnyǔ bɛtaŋ ɛbhɛn fá?” ");
INSERT INTO kenNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ɛkʉ bare byak yi byak. Yesu aghati yɛ bhɔ bɛ, “Bo báchyɛ̀ ndɛmɛkɛpɨ̌ntɨ Mandɛm kɛnókó yɛ̌ntɨkɨ ɛbhak. Ndiɛrɛ ɛtɔk ɛyi, nɛ ndǔ nnɛrɛ́kɛt ywi, kɛ bápú chyɛ yi kɛnókó.” ");
INSERT INTO kenNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tɛ̌ndu bɔ́ bábhɨ́kɨ́ bhɔŋ nɛka nɛ Yesu, yi kɛkʉ bɛyǎ mɛnyɨŋɨ́ maknkay amɛm ɛtɔk ɛyi Násárɛt. ");
INSERT INTO kenNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mpok yɔ, Hɛ́rɔd abhak mmu anɛ ákɛ̀m atú Gálili. Ághókó nɔ́kɔ́ ɛ̌ti mɛnyɨŋ ɛbhɛn Yesu ákʉ̀, ");
INSERT INTO kenNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","arɛm ntá bakʉ̌ bɛtɨk abhi atú Gálili ɛ̌ti Yesu bɛ, “Jɔ̌n Njwiti kɛ apɛrɛnsɛm ndǔ nɛpɛ́m. Ɛ̌ti yɔ kɛ̌ yí ábhɔ́ŋɔ́ bɛtaŋ bɛkʉ mɛnyɨŋɨ́ maknkay.” ");
INSERT INTO kenNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Hɛ́rɔd akaysi bɛ Yesu chi Jɔ̌n Njwiti ɛ̌ti ɛnyɨŋ ɛnɛ yi ákʉ́ nyaka ntá Jɔ̌n. Achyɛ́ nyaka ɛyɔŋ, bákɛ́m Jɔ̌n, bagwɔt, nɛ báfyɛ́ yi ɛkɛrɛ́kɛnɔŋ bɛkoŋo ɛnyɨŋ ɛnɛ ngɔrɛ́ ywi Hɛródias áyàŋ. Hɛródias ayámbɨ achi nyaka chi ngɔrɛ́ Fílip, manɔ Hɛ́rɔd, kɛ Hɛ́rɔd ǎsɔt yi ndǔ nɛbhay. ");
INSERT INTO kenNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Hɛ́rɔd ásɔ́rɛ́ nɔ́kɔ́ Hɛródias ndǔ nɛbhay, Jɔ̌n aré ghati yi bɛ, “Ɛbhé ɛyɛsɛ bo Israɛl ɛbhɨkɨ ka bɛ ɔ́mbay Hɛródias ngɔrɛ́ mɔmáyɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hɛ́rɔd ǎyàŋ nyaka bɛrɛm mángwáy Jɔ̌n, kɛ are cháy bǒ abhɛn yi achi mǔnti wap. Bo Israɛl mánoko nyaka bɛ Jɔ̌n achi ndɛmɛkɛpɨ̌ntɨ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Kɛ ɛwak Hɛ́rɔd ánáká ɛpǎ nɛbhe ɛyi, mmɔ̌ Hɛródias anɛ mɔ́ngɔrɛ́ abhɛ́n nɛbhɛ́n sayri bɛsí bo abhɛn bachi ndǔ ɛpǎ yɔ. Nɛbhɛ́n ɛni nɛkʉ Hɛ́rɔd abhɔŋ bɛyǎ maŋák, ");
INSERT INTO kenNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","kpát Hɛ́rɔd ayɨkɨ bɛ, “Chɔŋ nchyɛ́ wɔ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ ɔ́yàŋ nchyɛ́ wɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Bɛ́kóŋo ɛnyɨŋ ɛnɛ máyi aghati yi, arɔk arɛm ntá Hɛ́rɔd bɛ, “Chiɛ́ mɛ ntí Jɔ̌n Njwiti amɛm nchán myákátí-nɛ nɛ́nɛ!” ");
INSERT INTO kenNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mfɔ Hɛ́rɔd apɔp! Ɛ̌ti nɛyɨkɨ anɛ yí áyɨkɨ nyaka bɛsí mankɔ abhi ɛ́chá yi bɛyibhiri ɛyɔŋ ɛyi. Achyɛ yɛ ɛyɔŋ bɛ́ batɛmɛ́ nɛnu mankʉ mbɔ ɛnyǔ mmɔ̌ Hɛródias áyàŋ. ");
INSERT INTO kenNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Akʉ yɛ bárɔ́k ɛkɛrɛ́kɛnɔŋ, bafɛrɛ ntí Jɔ̌n Njwiti, ");
INSERT INTO kenNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","báfyɛ́ amɛm nchán myákátí, bárɔk bachyɛ ntá mmɔ̌ Hɛródias. Asɔt, arɔk achyɛ ntá máyi. ");
INSERT INTO kenNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Bakoŋó Jɔ̌n bárɔ́k, basɔt ɛrɛnɛ́ Jɔ̌n barɔk, babhɛmɛ. Bárɔ́k yɛ baghati Yesu ɛnyɨŋ ɛnɛ́ ɛ́fákárí nɛ Jɔ̌n. ");
INSERT INTO kenNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu ághókó nɔ́kɔ́ mbok nɛwú Jɔ̌n, afa, bárɔk bachwe amɛm áchwí, babho bɛrɔŋ ndǔ nɛbhʉɛt anɛ yɛ̌ mmu achak apu. Ǎyàŋ nyaka bɛ mámbák bɔbhɔ. Kɛ mpok bo bághókó bɛ yi asɔt áchwí ǎrɔ̀ŋ, báfá bɛtɔk ɛbhap, babho bɛkoŋo yi nɛ bɛkak. ");
INSERT INTO kenNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu áfú amɛm áchwí, akó ɛbhɨ. Aghɔ́ bɛyǎ bho, ntínso nɛ́kɛ́m yi nɛ bhɔ́. Abú abhɛn mámè. ");
INSERT INTO kenNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ɛ́gháká nɔ́kɔ́ beku, baghɔkɔ́ bhi bárɔ́k ntá yi barɛm bɛ, “Nywɔp nɛ́naŋ nɛrɔŋ, nɛ nɛbhʉɛt anɛ chi ɛbhɨ. Ghatí bǒbhɛn bɛ mándɔ́k ndǔ bɔ̌bɛtɔk abhɛn báchí fá kɛkwɔt manku ɛnyɨŋ mɛ́nyiɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu aghati baghɔkɔ́ bhi bɛ, “Ntí apu bɛghati bhɔ bɛ mándɔ́k mánjáŋ nɛnyíɛ́. Bě babhɔŋ, chyɛ̌ ká bhɔ nɛnyíɛ́ mányíɛ́.” ");
INSERT INTO kenNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Bákɛ́mɛ yi bɛ, “Sɛ́bhɔŋ chi bɔ̌bɛkpɔkɔ́ brɛt batay nɛ nsi ɛpay. Ɛnyɨŋ ɛchak ɛ́pú”. ");
INSERT INTO kenNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu aghati bhɔ bɛ, “Twɔ́ ká nɛ bhɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Aghati yɛ bɛyǎ bǒbhɔ bɛ manchɔkɔ amɨk ndǔ tákɔ. Asɔt yɛ bɛkpɔkɔ́ brɛt bhɔ bɛ́táy nɛ nsi ɛpay. Ayoŋ amɨk mfay. Achyɛ bakak ntá Mandɛm, abho bɛ́bɔ́kɔ́ti brɛt wu anchyɛ nɔkɔ ntá baghɔkɔ́ bhi bɛ mánkɔ́rɛ́ nɛ nsi ntá bɛyǎ bǒbhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Yɛ̌ntɨkɨ mmu wap anyiɛ́ kpát ajwi. Baghɔk Yesu mányókóti nɛnyíɛ́ ɛnɛn nɛrɔbhɛ. Nɛ́jwí bɛkay byo nɛ bɛpay. ");
INSERT INTO kenNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mpǎy babhakanɛm abhɛn manyíɛ́ brɛt wu nɛ nsi ɛyɔ ábhák mbɔ nka ɛtay, kɛfyɛ́ baghɔrɛ́ nɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ɛ́bhɨ́kɨ́ tat, Yesu aghati baghɔkɔ́ bhi bɛ mándɔ́k mǎnchwe amɛm áchwí, mámpe nnyɛ́n manjambɨ ndǔ ɛbhě manyu ɛchak. Arɔp ansɛm bɛkʉ bɛyǎ bo bhɔ abhɛn bachi arɛ mangurɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ánáŋá nɔ́kɔ́ bɛkʉ nɔ, akó amfǎy njiɛ aywǐntí ndu mɛnɨkmʉɛt. Bɛti bɛgʉ́ bɛ́tɛ́mɛri yi arɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Mpok yɔ, áchwí anɛ ápɔ́kɔ́ baghɔkɔ́ bhi anaŋ arɔŋ nyaka nɛkɔ nɛsiɛ bɛfu angɔkɔnyɛ́n. Mbʉ́ɛ́p ataŋataŋ ɛre fú bhɔ ambɨ. Ɛ́kʉ́ mpɛ́rɛ́nyɛn ɛya ɛ́cha, bɔ mánu nɔkɔ nɛ yɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Bɛfʉɛt nkárɛ́nká ɛ́rát bɛghaka nkárɛ́nká ɛ́tandat betí Yesu abho bɛkɔ amfǎnyɛ́n bɛrɔŋ bɛtɛmɛri bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kɛ bághɔ́ nɔ́kɔ́ ndǔ yi ákɔ̀ amfǎnyɛ́n átwɔ̀, bɛ́cháy bɛ́kɛ́m bhɔ tontó. Bábho bɛbɨk, mándɛmɛ nɔkɔ bɛ, “Chí ɛfóŋó-ngu! Chí ɛfóŋó-ngu!” ");
INSERT INTO kenNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tɛ́mté wu, Yesu afyɛ́ bhɔ ntɨ arɛm bɛ, “Chí mɛ, bǎkɛ́ chay!” ");
INSERT INTO kenNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Píta akɛmɛ yi bɛ, “Acha, mbák chí wɔ, chyɛ̌ ɛyɔŋ bɛ nsɛ́p anyɛ́n, nkɔ, ntɛmɛri wɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu akɛmɛ Píta bɛ, “Sɛp twɔ́.” Píta afú amɛm áchwí asɛp anyɛ́n abho bɛkɔ andɔkɔ nɔkɔ bɛtɛmɛri Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kɛ ághɔ́ nɔ́kɔ́ ndǔ mbʉ́ɛ́p ákʉ̀ mpɛ́rɛ́nyɛn ɛ́kò tɛ amfay kɛ ɛ́nsɛp, abho bɛcháy nɛ abho bɛgurɛ anyɛ́n tɛ́mté. Abɨk yɛ arɛm ntá Yesu bɛ, “Acha, pɛmɛ́ mɛ!” ");
INSERT INTO kenNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesu asá awɔ tɛ́mté akɛm yi arɛm bɛ, “Píta, nɛka ɛnɛ nɛ́gʉpsi nɛcha! Ndaká yí ɔ́mákátí bɛ mɛ̌kwáy bɛkʉ wɔ ɔ́nkɔ amfǎnyɛn?” ");
INSERT INTO kenNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Yesu nɛ Píta bákó nɔ́kɔ́ ndu áchwí, mbʉ́ɛ́p wu ákwɛn. ");
INSERT INTO kenNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Baghɔk Yesu babho yɛ bɛ́kwɛ́n yi bɛkak, ndu bɛchyɛ yi kɛnókó, mándɛmɛ nɔkɔ bɛ, “Tɛtɛp, ɔchí Mmɔ Mandɛm!” ");
INSERT INTO kenNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yesu nɛ baghɔkɔ́ bhi mánáŋá nɔ́kɔ́ bɛpe manyu, bákó ɛbhɨ, atú Gɛnɛ́sarɛt. ");
INSERT INTO kenNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Bo abhɛn bachi atú ɛtɔk ɛyɔ bárɨ́ŋɨ́ bɛ́ Yesu achi arɛ. Bátó ɛyɔŋ mbǎnkɛm bɛkʉ bo mántwɔ́ ntá yi nɛ bǒmame. ");
INSERT INTO kenNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bo abhɛn bárɔ́ŋɔ́ ntá Yesu nɛ bǒmame bhap, mánɨkmʉɛt bɛ́ yi andɔ bǒmame mántɔk yɛ̌ chi nkokoŋ ndɛn ayi. Nɛ yɛ̌ntɨkɨ mmu anɛ ánú átɔ́kɔ́ nkokoŋ ndɛn Yesu, ataŋ. ");
INSERT INTO kenNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ɛ́tárɛ́ nɔ́kɔ́, mbɔk bǒnkwɔ Fárisi nɛ batɔŋ ɛbhé Mandɛm báfú Yerúsalɛm bárɔ́k ntá Yesu bábhɛp yi bɛ, ");
INSERT INTO kenNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ndaká yí baghɔkɔ́ bhɛ bápú koŋo bɛpɨŋ ɛbhɛn bachǐmbɨ bhɛsɛ? Bápú so amɔ kɛ manyíɛ́ nɛnyiɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu akɛmɛ bhɔ bɛ, “Nɛ ndaká yí bǎrɔ̀ bɛbhé Mandɛm, mǎnkoŋo nɔkɔ chi mɛnyɨŋ ɛbhɛn bachǐmbɨ bhɛka batɔŋɔ? ");
INSERT INTO kenNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Mandɛm arɛm bɛ, ‘Chiɛ́ ɛ́táyɛ nɛ máyɛ kɛnókó’ nɛ bɛ ‘Yɛ̌ agha anɛ árɛ̀m ɛbɛ́ptí ɛyɔŋ ntá ɛtayi, yɛ̌ máyi, bábhɔŋ bɛway yi.’ ");
INSERT INTO kenNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kɛ bǎghàti bho bɛ, ‘Mbák mmu ándɛ́m ntá ɛtayi, yɛ̌ máyi bɛ, “Nsɔt ɛnyɨŋ ɛnɛ́ mbɔ́ŋɔ́ mbʉ́ bɛkwak wɔ nɛ yɔ, nchyɛ́ ntá Mandɛm”, nɛ bɛ́ yi abhɨkɨ bhɔŋ bɛchyɛ máyi, yɛ̌ ɛtayi kɛnókó,’ ");
INSERT INTO kenNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","nɔ́ bǎbyak bɛbhé Mandɛm, nɛ bǎbhʉ̀rɛ chi bɛpɨŋɨ́tɔk. ");
INSERT INTO kenNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Bě bǒ bɛtábhá! Ndɛmɛkɛpɨ̌ntɨ Aisáya arɛm nyaka ndak aywi tɛtɛp ɛ̌ti yɛka! Aghátí nyaka bho bɛ Mandɛm arɛm bɛ, ");
INSERT INTO kenNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Bǒbhɛn báchyɛ̀ mɛ kɛnókó chi nɛ bɛyɔŋɔ́nyu bhap, batɨ yap asap nɛkɔ nɛ mɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kɛnókó ɛkɛn báchyɛ̀ mɛ kɛchi chi ndɛ́ndɛm, mbɔnyunɛ bɛbhé ɛbhɛn bakwǎŋwaŋ báfyɛ́, kɛ bɔ bátɔ̀ŋ bho mbɔ bɛ bɛchi Ɛyɔŋ ɛya.’” ");
INSERT INTO kenNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu árɛ́mɛ́ nɔ́kɔ́ nɔ́, abhɨŋɨ bɛyǎ bo abhɛn bachi arɛ́ arɛm bɛ, “Tá ká batú mǎngok ɛnyɨŋ ɛnɛ mbɔ́ŋɔ́ bɛ́rɛ́m, mǎnjwimɛm! ");
INSERT INTO kenNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Puyɛ̌ ɛnyɨŋ ɛnɛ ɛ́chwè anyu kɛ̌ ɛ́kʉ̀ mmu ákɛ́ bhák pɛ́pɛ́p bɛsí Mandɛm. Ɛnyɨŋ ɛnɛ ɛ́fú mmu anyu kɛ ɛ́kʉ̀ mmu ákɛ́ bhák pɛ́pɛ́p bɛsí Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yesu árɛ́mɛ́ nɔ́kɔ́ nɔ́, bakoŋo bhi bákókósi mmʉɛt nɛ yi, barɛm bɛ, “Ɛta, ɔrɨ́ŋɨ́ nɔ́ bɛ ndak anɛ ɔ́rɛ́mɛ́ ákʉ batɨ ábè bǒnkwɔ Fárisi?” ");
INSERT INTO kenNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu akɛmɛ bhɔ bɛ, “Chɔŋ mángwɔp yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ Ɛtaya mmu achi amfay ábhɨ́kɨ́ pɨ, mámfɛrɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Dɔ̌ ká bhɔ awu! Báchí chí manɛ́mámɨk abhɛn báyàŋ bɛya bho mbi. Nɛ mbák nnɛ́mámik ánjá ntɨ nnɛ́mámik mbi, bɔ́ mankɛm bákwɛn amɛm nɛpi.” ");
INSERT INTO kenNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Píta arɛm ntá Yesu bɛ, “Ɛta, ghatí bhɛsɛ ntí nɛkay ɛnɛn.” ");
INSERT INTO kenNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ɛ́kʉ́ Yesu abhɛ́p bhɔ bɛ, “Bě nkwɔ́ bǎbhɨ́kɨ́re jwimɛm ndǔ mɛnyɨŋ ɛbhɛn mɛ́rɛ̀mɛ? ");
INSERT INTO kenNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Bǎbhɨ́kɨ́ rɨŋɨ bɛ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ mmu afyɛ́ anyu, ɛ́nsɛp yí mɛniɛ, ǎjì yɔ amfɛrɛ? ");
INSERT INTO kenNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kɛ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ ɛ́fù mmu anyu, ɛ́fù yi chi antɨ, nɛ yɔ kɛ̌ ɛ́kwày bɛkʉ yi ákɛ́ bhak pɛ́pɛ́p bɛsí Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nɔ chi bɛ amɛm ntɨ mmu kɛ̌ nkaysi mbʉ́mbʉ áfù, antó mmu ndǔ bɛbɛ́ptí mɛnyɨŋ mbɔ bɛway mmu, bɛkwɛn bɛrwɔp, kɛbhʉ́rɛ́ ɛkɛn bǒ abhɛn bábhɨ́kɨ́ bhay batɨ, nɛ aghɛ́p, nɛ bɛ́té ntísiɛ ákwárɛ́, nɛ bɛ́rɛ́m bɛbɛ́ptí mɛnyɨŋ ɛ̌ti mmu ndǔ bɛchɔŋti nnyɛ́n ɛni. ");
INSERT INTO kenNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Mɛnyɨŋ ɛbhɛn kɛ bɛ́kʉ̀ mmu ákɛ́ bhák pɛ́pɛ́p bɛsí Mandɛm. Mɛ́nyiɛ nɛnyíɛ́ kɛso amɔ, apú kʉ bɛ mmu ákɛ́ bhák pɛ́pɛ́p bɛsí Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu afa yɛ atú Gálili nɛ bakoŋo bhi, bárɔk ndǔ atú ɛtɔk anɛ achi kɛkwɔt Táya nɛ Sídɔn. ");
INSERT INTO kenNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ngɔrɛ́ amɔt abhak atú ɛtɔk wu anɛ apu mmu Israɛl, kɛ abhak mmu Kánǎn. Arɔk ntá Yesu, ambɨk nɔkɔ bɛ, “Acha, mmɔ̌ Mfɔ Debhít, ghɔ́ mɛ́ ntínso! Ɛfóŋó ɛbʉ́bʉ ɛ́sɔ̀ŋɔri mɔ́wa tontó.” ");
INSERT INTO kenNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yesu kɛ kɛmɛ yí yɛ̌ ɛyɔŋ. Nɛ bakoŋo Yesu baghati Yesu bɛ, “Bók yi andɔ́k. Ǎchyɛ̀ bhɛsɛ ɛsɔŋɔri.” ");
INSERT INTO kenNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu akɛmɛ bɛ, “Mandɛm ato mɛ́ bɛ ntwɔ nkwak chi bo Israɛl, bághɔ́ŋɔmɛ́n yi anɛ ánɛ́mɛ́ ɛbhɨ.” ");
INSERT INTO kenNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kɛ ngɔrɛ́ wu arɔk akwɛ́n bɛkak Yesu are nɨk yi mmʉɛt andɛmɛ nɔkɔ bɛ, “Acha, kwak mɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu akɛmɛ yi bɛ, “Ɛ́pú chak bɛsɔt nɛnyíɛ́ bhɔ mánchyɛ́ ntá mmú.” ");
INSERT INTO kenNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ngɔrɛ́ wu arɛm bɛ, “Acha, ɛ́chí tɛtɛp, kɛ mpok mmu ányìɛ nɛnyíɛ́, apú káŋ mmú bɛ ɛ́kɛ́ nyiɛ bɛchɔkɔtí ɛbhɛn bákwɛ̀nti amɨk.” ");
INSERT INTO kenNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesu akɛmɛ yɛ yi bɛ, “Ɔchí ngɔrɛ́ anɛ ɔ́bhɔ́ŋɔ́ nɛka nɛ mɛ tɛtɛp, nɛ chɔŋ Mandɛm ankʉ ntá yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ ɔ́yàŋ.” Tɛ́mté wu, mɔ́ywi ataŋ. ");
INSERT INTO kenNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu afa yɛ atú Táya nɛ Sídɔn apɛtnsɛm angɔkɔ manyu Gálili. Akɔ, afʉɛ́t arɛ́, akó achɔkɔ ambɨ njiɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bɛyǎ bho babho bɛrɔŋ ntá yi nɛ bǒmame, nɛ bakɛm, nɛ bo abhɛn bachi bhʉrɛ, nɛ manɛ́mámɨk, nɛ babhók nɛ bǒmame báchák, mámbʉrɛ nɔkɔ bhɔ bɛsí bhi. Abú bhɔ́ mankɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Manyu áchók bǒ abhɛn bachi arɛ ndǔ bághɔ́ bɛ́ babhók bábho bɛrɛm kɛpɨ, nɛ bɛ bǒ abhɛn bachi bhʉrɛ báfàte kpɛrɛp, nɛ bakɛm bábho bɛkɔ, nɛ manɛ́mámík babho bɛghɔ mbaŋ. Bábhó bɛbɨti Mandɛm, Mmu bo Israɛl báchyɛ̀ kɛnókó. ");
INSERT INTO kenNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu abhɨŋɨ yɛ bakoŋo bhi arɛm bɛ, “Ntínso nɛ́kɛ̀m mɛ nɛ bǒbhɛn. Báchí fá nɛ mɛ ndǔ manywɔp arat, nɛ bábhɨ́kɨ́ bhɔ́ŋ yɛ̌nyɨŋ mɛnyiɛ. Mbɨ́kɨ́ yáŋ bɛrɔ bɔ mandɔk kɛnyiɛ nɛnyíɛ́ mbɔnyunɛ bákway bɛgu nsay ambi.” ");
INSERT INTO kenNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Bakoŋo bhi bábhɛ́p yi bɛ, “Ɛtɔk ɛ́pú fá, chɔŋ sɛ́mbɔ́ŋ nɛnyíɛ́ ɛnɛn nɛ́kway bɛyǎ bǒbhɛn fá?” ");
INSERT INTO kenNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu abhɛ́p bhɔ́ bɛ, “Bǎbhɔŋ bɛkpɔkɔ́ brɛt afɔ mɛ́ní?” Bákɛ́mɛ yi bɛ, “Sɛ́bhɔŋ bɛkpɔk tándrámɔt, nɛ bǎru nsi.” ");
INSERT INTO kenNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesu achyɛ yɛ ɛyɔŋ bɛ bɔ́ mankɛm mánchɔ́kɔ́ amɨk. ");
INSERT INTO kenNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Asɔt yɛ bɛkpɔkɔ́ brɛt ɛbhɔ tándrámɔt nɛ nsi. Áchyɛ́ nɔ́kɔ́ bakak ntá Mandɛm, abho bɛ́bɔ́kɔ́ti bhɔ anchyɛ nɔkɔ ntá bakoŋo bhi, bɛ́ mánkɔ́rɛ́ ntá bǒbhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Yɛ̌ntɨkɨ mmu anyiɛ́ anɛ ákwáy yi. Bakɔŋo bhi bábwɔpti nɛnyíɛ́ ɛnɛ́n nɛ́rɔ́bhɛ́. Nɛ́jwí bɛkay tándrámɔt. ");
INSERT INTO kenNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mpǎy babhakanɛm abhɛn mányíɛ́ nɛnyíɛ́ ɛnɔ abhak mbɔ nká ɛnwi kɛfyɛ́ mǎmbɔ nɛ baghɔrɛ́. ");
INSERT INTO kenNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesu aghati yɛ bhɔ́ bɛ́ mángúrɛ́. Bo mankɛm bárɔ́ŋ nɔ́kɔ́, asɛp anyɛ́n nɛ bakoŋo bhi, asɔt áchwí arɔk atú Magádan. ");
INSERT INTO kenNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ɛwak ɛ́mɔ́t, bǒnkwɔ Fárisi nɛ bǒnkwɔ Sádusi bárɔ́k ntá Yesu bárè yaŋ mbi mɛmɔ yi. Bábhɛ́p yi ankʉ ɛnyɨŋɨ́ maknkay ɛnɛ́ ɛ́bhak mbɔ ɛrɨŋ ɛnɛ́ ɛ́tɔŋ bɛ bɛtaŋ ɛbhi bɛ́fú chi ntá Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesu akɛmɛ bhɔ bɛ, “Mbák mmok ánɛ́m beku, nɛbu nɛ́mbak chuuu, be bǎrɛ̀m bɛ, Chɔŋ nywɔp nɛndɨ mborɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nɛ mbák nywɔp nɛ́njí nɛbu nɛ́ngiri, bǎrɛm bɛ, ‘Chɔŋ nywɔp nɛ́mbɛ́p tontó.’ Bǎrɨ́ŋɨ́ bɛ́yɨ́ŋɨ nɛbu mǎndɛm mbák manyiɛp ǎkwɛn chɔŋ, nɛ mbák apu kwɛn. Kɛ bǎghɔ̀ mɛnyɨŋ ɛbhɛn bɛ́fàkari ɛchɔŋ, be kɛrɨŋɨ ntí anɛ bɔ bɛ́fàkari. ");
INSERT INTO kenNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Bɛbʉ́ ná nɛ mkpáká bho anɛ ɛchɔŋ! Bápú kʉ mbɔ ɛnyǔ Mandɛm áyàŋ. Báyàŋ bɛghɔ chi ɛrɨŋɨ́ maknkay! Kɛ yɛ̌ ɛ́mɔt mpú tɔŋ be, ɛ́bhɨ́kɨ́ fʉɛt chi ɛnɛ́ Jóna, ndɛmɛkɛpɨ̌ntɨ Mandɛm.” Yesu árɛ́mɛ́ nɔ́kɔ́ nɔ́, arɔ bhɔ, arɔk. ");
INSERT INTO kenNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Bakoŋo Yesu bápé barɔk ebhě manyu ɛchak, baghɔ bɛ baghɔkɔntɨk bɛpɔkɔ brɛt. ");
INSERT INTO kenNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu aghati bhɔ bɛ, “Sɔt ka mpok nɛ yís anɛ bǒnkwɔ Fárisi, mǎnsɔt mpok nɛ yís anɛ bǒnkwɔ Sádusi.” ");
INSERT INTO kenNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Bábhó bɛrɛm nɛ batɨ bɛ, “Ǎrɛ̀m nɔ chi ndǔ sɛ́bhɨ́kɨ́ twɔ nɛ brɛt.” ");
INSERT INTO kenNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu arɨŋɨ ɛnyɨŋ ɛnɛ́ bɔ́ bárɛ̀m, abhɛ́p bhɔ bɛ, “Ndaká yí bǎrɛ̀m ɛ̌ti brɛt anɛ bǎbhɨ́kɨ́ bhɔ́ŋ? Nɛka ɛnɛka nɛ́gʉpsi nɛcha! ");
INSERT INTO kenNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kpátɛ̌ ɛchɔŋ bǎbhɨ́kɨ́re jwimɛm-ɛ? Bǎghɔ́kɔ́ntɨk ndu ndɨ́kɨ́ nka bho ɛtay nɛ bɛkpɔkɔ́ brɛt bɛtay? Bǎghɔ́kɔ́ntɨk bɛkǎy brɛt anɛ árɔ́bhɛ́? ");
INSERT INTO kenNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ná nɛ anɛ bɛkpok tándrámɔt anɛ nká bho ɛnwi mányíɛ́? Bǎghɔ́kɔ́ntɨk brɛt anɛ árɔ́bhɛ́ mǎnyókóti bǎfyɛ ndǔ bɛkay? ");
INSERT INTO kenNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ndaká yí bǎpú kway bɛghɔ bɛ mpú rɛm mbʉ chi ɛ̌ti brɛt? Sɔt ka mpok nɛ yís anɛ bǒnkwɔ Fárisi, nɛ anɛ bǒnkwɔ Sádusi.” ");
INSERT INTO kenNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Afɔ̌ kɛ̌ bakoŋo Yesu bájwimɛm bɛ Yesu abhɨkɨ sɛmti bhɔ chi ɛ̌ti yís anɛ báfyɛ̀ ndǔ flawa, kɛ ɛ̌ti mɛnyɨŋ ɛbhɛn bǒnkwɔ Fárisi nɛ ɛbhɛn bǒnkwɔ Sádusi bátɔ̀ŋ. ");
INSERT INTO kenNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu arɔk atú Seséria Fílipi nɛ baghɔkɔ́ bhi. Arɛ́, abhɛp bhɔ bɛ, “Bo bárɛ̀m bɛ́ Mɛ Mmu mfú ntá Mandɛm nchí agha?” ");
INSERT INTO kenNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bákɛ́mɛ Yesu bɛ, “Mbɔk bho bárɛ̀m bɛ ɔchí Jɔ̌n Njwiti. Bachak bɛ Ɛláija, abhɛ́nɛ́fú bɛ́ ndɛmɛkɛpɨ̌ntɨ Jeremáya, nɛ bɛ, mbák puyɛ̌ yi, nɔ chi ndɛmɛkɛpɨ̌ntɨ achak.” ");
INSERT INTO kenNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesu abhɛ́p bhɔ bɛ, “Kɛ bě babhɔŋ bǎrɛ̀m bɛ mɛnchí agha?” ");
INSERT INTO kenNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Símun Píta akɛmɛ yi bɛ, “Wɔ kɛ ɔ́chí Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò, wɔ kɛ ɔ́chí Mmɔ Mandɛm anɛ áchí nɛpɛ́m.” ");
INSERT INTO kenNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu akɛmɛ Píta bɛ, “Símun mmɔ̌ Jóna, ɛ́rɨ ntá yɛ ɛcha! Ɛtaya mmu áchí amfay kɛ ákʉ́ ɔ́rɨ́ŋɨ́ ndak anɛ, puyɛ̌ nkwǎ. ");
INSERT INTO kenNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Wɔ, ɔchí sɛtárɛ́bhɛ́, nɛ ndǔ sɛtárɛ́bhɛ́ ɛsɛ́n kɛ nchí te ɛkɛt ɛya. Nɛ yɛ̌ chí bɛtaŋá nɛwú bɛ́pú kway bɛtaŋ mɛncha nkwɔ bo Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nɛ chɔŋ nchyɛ́ wɔ bɛtaŋ amɛm Kɛfɔ Mandɛm. Nɛ ɛnyɨŋ ɛnɛ́ ɔ́gwɔ́rɛ́ fá amɨk, chɔŋ Mandɛm angwɔt yɔ awu amfay. Ɛnɛ́ ɔ́káŋárí, Mandɛm ǎkaŋari awu amfay.” ");
INSERT INTO kenNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yesu árɛ́mɛ́ nɔ́kɔ́ nɔ́, asɛmti yɛ bakoŋo bhi bati byo nɛ apay bɛ bákɛ́ kʉ yɛ̌ mmu andɨŋɨ bɛ yi chí Mpɛmɛ anɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò. ");
INSERT INTO kenNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Bɛ́bhó mpok yɔ, Yesu abho bɛ́gháti bakoŋo bhi mɛnyɨŋ ɛbhɛn bɛbhɔŋɔ bɛfakari nɛ yi. Arɛm bɛ yi abhɔŋ bɛrɔŋ Yerúsalɛm, nɛ arɛ́, bǒbati ɛtɔk, nɛ bǒbati bachiǎkap Mandɛm nɛ batɔŋ ɛbhé Moses mánchyɛ yi bɛyǎ ɛsɔŋɔri, kpát mángwáy yi, kɛ ɛ́ghaka nɔkɔ manywɔp arat, ampɛtnsɛm ndǔ nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kɛ Píta asɔt yi nɛpak, abho bɛji yi bɛ, “Acha, Mandɛm ákɛ́ ka! Awǔ ndak ábhɨ́kɨ́ bhɔŋ bɛfakari nɛ wɔ!” ");
INSERT INTO kenNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Kɛ Yesu ayibhiri mmʉɛt ayɨŋɨ Píta, arɛm bɛ, “Satan, fá mɛ́ bɛsí! Ɔchí ɛrɛm ntá, ntá ya. Nkaysi yɛ chí nkaysi nkwǎŋwaŋ, abhɨ́kɨ́ fu ntá Mandɛm!” ");
INSERT INTO kenNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yesu aghati yɛ baghɔkɔ́ bhi bɛ, “Mbák mmu ǎyàŋ bɛbhak nkoŋo wa, ángɔ́kɔ́ntɨk mmʉɛt yi, ampɔkɔ ɛkotákátí yi, ankoŋo mɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yɛ̌ agha anɛ áyàŋ bɛpɛmɛ mmʉɛt yi ǎnɛm nɛpɛ́m ɛni. Kɛ yɛ̌ agha anɛ áká mɛnɛm nɛpɛ́m ɛni ɛ̌ti ya, ǎbhɔŋ nɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ntɨkɨ nsáy mmu ábhɔŋ mbák abhɔ̌ŋ yɛ̌ntɨkɨ ɛnyɨŋ fá amɨk, kɛ anɛ́m nɛpɛ́m ɛni? Nɛ mbák mmu ánɛ́m nɛpɛ́m ɛni, ntɨkɨ ɛnyɨŋ yí ákwày bɛsɔt anchyɛ bɛ́ yi ampɛt ambɔŋ nɛpɛ́m ɛni? ");
INSERT INTO kenNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nchí ghati bhe mɛnyɨŋ ɛbhɛn mbɔnyunɛ chɔŋ Mɛ Mmu mfú ntá Mandɛm mpɛtnsɛm fá amɨk nɛ bɛtaŋ Ɛtaya. Mbɔŋ bɛ́twɔ nɛ bɔángɛl Mandɛm, nchyɛ́ yɛ̌ntɨkɨ mmu aywi akap, bɛ́kóŋo bɛtɨk ɛbhɛn yi ákʉ́. ");
INSERT INTO kenNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nchí ghati bhe bɛ, mbɔk yɛka báchí fá te abhɛn bápú gu kpátɛ mǎngɔ́ Mɛ Mmu mfú ntá Mandɛm ndu nchí twɔ fá amɨk mbɔ Mfɔ bǒ mankɛm.” ");
INSERT INTO kenNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ɛ́fʉɛ́rɛ́ nɔ́kɔ́ manywɔp atandat, Yesu asɔt Píta, asɔt Jems nkwɔ́ nɛ manɔ ywi Jɔ̌n, akó amfay njiɛ ngo nɛ bhɔ, bábhak arɛ́ bɔ́bhɔ́. ");
INSERT INTO kenNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Bápɛ́rɛ yɨŋɨ, bɛsí Yesu bɛ́yíbhiri bɛrɔbhɛ ghɔɔ ghɔ́ɔ mbɔ mmok. Ndɛn ɛ́yi nkwɔ ɛ́yíbhiri ɛrɔp pɛ́pɛ̌pɛ́p, ɛ́nkɔt nɔkɔ ŋwaŋwǎŋwaŋ. ");
INSERT INTO kenNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tɛ́mchok, Moses nɛ Ɛláija, barɛmɛ́ kɛpɨ̌ntɨ Mandɛm abhɛn tɛsáy bábhési, mándɛmɛ nɔkɔ kɛpɨ nɛ Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Píta abho bɛrɛm ntá Yesu bɛ, “Acha, ɛ́rɨ tontó bɛ sɛchi fá. Mbák ɔkɔŋ, chɔŋ nte bɛtɛm barat. Ɛmɔt ntá yɛ, ɛchak ntá Moses, nɛ ɛnɛ́fú ntá Ɛláija.” ");
INSERT INTO kenNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ɛnɛ́ Píta ábhɨ́kɨ́re naŋa ɛnyɨŋ ɛnɛ yí árɛ̀m ntá Yesu, ɛkpɔkɔ́ nɛbhaŋ ɛnɛn nɛ́ghɔ̀ pɛ́pɛ̌pɛ́p ɛ́kúti bhɔ mankɛm. Ɛyɔŋ ɛ́fú ndǔ nɛbháŋ ɛnɔ ɛ́ré rɛm bɛ, “Nɛ́ chí Mɔ́wa. Nkɔŋ yí tontó. Ghók ka yi!” ");
INSERT INTO kenNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Píta nɛ mamʉɛrɛ bhi bághókó nɔ́kɔ́ ɛyɔŋ ɛyɔ, bɛcháy bɛkɛm bhɔ tontó, nɛ yɛ̌ntɨkɨ mmu wap ákwɛ́n, atɛp bɛsí amɨk. ");
INSERT INTO kenNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Kɛ Yesu arɔk, atɔk bhɔ arɛm bɛ, “Faté ká, bǎkɛ́ cháy.” ");
INSERT INTO kenNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Báyóŋ nɔ́kɔ́ amɨ́k amfay, bɔ́ kɛpɛrɛ ghɔ yɛ̌ mmu. Ɛrɔp chi Yesu aywǐntí. ");
INSERT INTO kenNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nɛ ndǔ Yesu nɛ bɔPíta básɛ̀p njiɛ, Yesu aghati bhɔ bɛ, “Bǎkɛ́ ghati yɛ̌ mmú ɛnyɨŋ ɛnɛ Mandɛm ákʉ́ bǎghɔ́ fá, kpátɛ yi ankʉ Mmu anɛ áfú ntá yi ampɛtnsɛm ndǔ nɛpɛ́m.” ");
INSERT INTO kenNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Píta nɛ mamʉɛrɛ bhi bábhɛ́p Yesu bɛ, “Ndaká yí batɔŋ ɛbhé Moses bárɛ̀m bɛ Ɛláija abhɔŋ bɛpɛtnsɛm fá amɨk kɛ Mpɛmɛ Mandɛm afyɛ́ bariɛp bɛ ǎtó antwɔ́?” ");
INSERT INTO kenNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu akɛmɛ bhɔ bɛ, “Ɛ́chí tɛtɛp bɛ́ Ɛláija abhɔŋ bɛ́yámbɨ antwɔ́, angoko yɛ̌ntɨkɨ ɛnyɨŋ fá amɨk, kɛ Mpɛmɛ antwɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kɛ nchí ghati bhe bɛ, Ɛláija anáŋ atwɔ kɛ bo bábhɨ́kɨ́ rɨŋɨ yi. Bákʉ́ nɛ yi mbɔ ɛnyǔ bákɔ́ŋɔ́. Nɔ́ kɛ̌ Mmu anɛ áfú ntá Mandɛm nkwɔ ábhɔŋ chɔŋ ɛsɔŋɔri amɔ yap.” ");
INSERT INTO kenNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Mpok yɔ kɛ̌ bakoŋo Yesu bárɨ̀ŋɨ sayri sayri bɛ Yesu ǎrɛ̀m chi ɛ̌ti Jɔ̌n Njwiti. ");
INSERT INTO kenNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesu nɛ bakoŋo bhi básɛ́bhɛ́ nɔ́kɔ́ antɛn njiɛ, bátɛ́mɛri bɛyǎ bo abhɛn báchɛ́mɛ́ arɛ́ mánòŋ bhɔ. Mmu amɔt afú ndǔ ɛka yɔ, arɔk, atɛp mánɛ́n bɛsí Yesu, ");
INSERT INTO kenNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","arɛm bɛ, “Acha, ghɔ́ ntínso nɛ mɔ́wa. Ǎkwɛn ntímɛn, nɛ ɛsɔŋɔri ɛ́nɛ́ yí ábhɔ̀ŋ ɛya ɛcha. Bɛyǎ mpok, ǎkwɛn angó, ndɔŋ ɛchak, ǎkwɛn anyɛ́n. ");
INSERT INTO kenNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nsɔt yí ntwɔ́ ntá bakoŋo bhɛ, kɛ bábhɨ́kɨ́ kway bɛbu yi.” ");
INSERT INTO kenNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu arɛm ntá bakoŋo bhi bɛ, “Bě mkpáká bho anɛ́ ábhɨkɨ bhɔŋ nɛka nɛ mɛ, bě bhó bǎyìbhiri tɛtɛp ndǔ ɛnyɨŋ ɛchak, chɔŋ mpɛt ntat nɛ bhe ná? Chɔŋ nkɛ́pntɨ nɛ bhe ngaka fá? Twɔ́ ká nɛ mɔ́wu ntá ya.” ");
INSERT INTO kenNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Bárɔ́ŋɔ́ nɔ́kɔ́ ntá yi nɛ mɔ́wu, Yesu ásáy ɛfóŋó ɛbʉ́bʉ yɔ, bɛ́ ɛ́ndɔ́ yi. Ɛfóŋó ɛbʉ́bʉ ɛ́rɔ́ yi, ataŋ tɛ́mté. ");
INSERT INTO kenNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mpok Yesu árɔ́bhɛ́ chí nɛ bakoŋo bhi, bábhɛ́p yi bɛ, “Ndaká yí sɛ́bhɨ́kɨ́ kway bɛbok ɛfóŋó ɛbʉ́bʉ yɔ?” ");
INSERT INTO kenNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu akɛmɛ bhɔ bɛ, “Chí ɛ̌ti bǎbhɨ́kɨ́ bhɔŋ nɛka nɛ Mandɛm. Nchí ghati bhe bɛ, mbɔ bǎbhɔŋ nɛka nɛ Mandɛm ɛnɛ́n nɛ́chí yɛ̌ chi nɨ́ŋɨ́nɨ́ŋɨ́ mbɔ mɔ́sɛpɛmɛ́nɔk ɛnɛ bábhɨŋɨ bɛ *mɔ́stat, bǎkwáy bɛghati njiɛ bɛ́ ámfá fá andɔk nɛbhʉɛt áchák, ɛ́mfakari ɛnyu yɔ, nɛ yɛ̌nyɨŋ kɛkwɛ́y bɛcha bhe. ");
INSERT INTO kenNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Bo bákwày bɛ́bók ɛnyǔ ɛfóŋó ɛbʉ́bʉ yɔ chí mbák báchí ndǔ nɛtarɛ́nsay nɛ nɛnɨkɨ́mʉɛt” ");
INSERT INTO kenNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ɛwak ɛ́mɔ́t, bakoŋo Yesu mankɛm bati byo nɛ apay bápɛ́t nɔ́kɔ́ nsɛm atú Gálili, Yesu aghati bhɔ́ bɛ, “Bákɛ́m chɔŋ Mmu anɛ áfú ntá Mandɛm mámfyɛ yi amɔ bǒ mmɨk. ");
INSERT INTO kenNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Bǒ-bhɔ mángwáy yi, kɛ ɛ́gháká nɔ́kɔ́ manywɔp arat, Mandɛm ankʉ yi ampɛtnsɛm ndǔ nɛpɛ́m.” Bɛyɔŋ ɛbhɛn bɛkʉ bakoŋo bábhɔŋ bɛyǎ basɛ́mɛ́. ");
INSERT INTO kenNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu nɛ bakoŋo bhi bárɔ́k baghaka Kapɛ̌naum. Ɛnɛ́ bɔ́ báchí arɛ, babhɛbhɛ́ nkábhɛ́nti abhɛn ɛkɛrákap Mandɛm bárɔ́k ntá Píta bábhɛ́p yi bɛ, “Ntɔŋ ywɛka ǎchyɛ̀ nkábhɛ́nti anɛ ɛkɛrákap Mandɛm-ɛ?” ");
INSERT INTO kenNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Píta akɛmɛ bɛ, “Ɛɛ.” Píta apɛtnsɛm anywɔ́p bɛrɛm kɛpɨ nɛ Yesu. Kɛ ápɛ́rɛ rɛm ɛnyɨŋ, Yesu ayambɨ abhɛp yi bɛ, “Píta, ɔkáysí bɛ́ yí? Ntɨ́kɨ́ bhó báchyɛ̀ nkábhɛ́nti ntá bafɔ̌ mmɨk? Chí bɔ̌mɨk kɛ chi mankɔ?” ");
INSERT INTO kenNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Píta akɛmɛ bɛ, “Bafɔ básɔ̀t nkábhɛ́nti ntá mankɔ.” Yesu arɛm yɛ bɛ, “Ɛyɔ ɛ́tɔ̀ŋ bɛ́ babhɔ̌ŋ bɔ̌mɨk bábhɨ́kɨ́ bhɔŋ bɛchyɛ nkábhɛ́nti. ");
INSERT INTO kenNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kɛ tɛ̌ndu sɛ́pú yáŋ bɛkʉ bǒbhɛn mambe ntɨ, sɛp, dɔ́k manyu, gʉɛ́p áwám anyɛ́n. Nsi mbɨ anɛ ɔ́kɛ́mɛ́ nɛnɛ́ nnyu ywi. Chɔŋ ɔ́ngɔ́ nkáp arɛ anɛ akway bɛchyɛ awa nkábhɛ́nti anɛ ɛkɛrákap Mandɛm nɛ aywɛ. Sɔt wu chyɛ bhɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ɛ́bhɨ́kɨ́ tat, bakoŋo Yesu bárɔ́k ntá yi babhɛp yi bɛ, “Ndǔ nkwɔ́ bhó abhɛn Mandɛm achi Mfɔ wap, ághá áchɨ́kɨ́ áchá báchák?” ");
INSERT INTO kenNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu abhɨŋɨ mandú mɔ, akʉ yi ate bɛsí bhap. ");
INSERT INTO kenNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Arɛm bɛ, “Nchí ghati bhe bɛ mbák bǎbhɨ́kɨ́ yibhiri mǎndɔ́p mbɔ mǎmbɔ, bǎpú kway bɛbhak ndǔ mpǎy bho abhɛn Mandɛm achi Mfɔ wap wáwák. ");
INSERT INTO kenNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yɛ̌ agha anɛ ásɛ̀pti mmʉɛt mbɔ mǎmbɔ, yí wu kɛ ákway bɛchwe ndǔ kɛfɔ̌ mfay.” ");
INSERT INTO kenNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Yɛ̌ agha anɛ ásìɛpti mandú mɔ mbɔ anɛ́, ɛ̌ti ya, ǎsìɛpti chí mɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Chɔŋ ɛmbɛp ɛncha ntá mmu anɛ ákʉ̀ mɔ́wa amɔt anɛ abhɔ́ŋɔ́ nɛka nɛ mɛ ánkwɛ́n ndǔ bɛbʉ́. Ɛchi sayri ntá mmu wu, bɛ mánsɔt ntay nɛgho mánsɛt ɛmɨ ɛyi, mámɛsɛ yi amɛm manyu. ");
INSERT INTO kenNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Ɛ́bɛp ntá bǒ mmɨk ɛcha, mbɔnyunɛ bɔ́ bátwɔ̀ nɛ mamɔ anɛ ákʉ̀ bo mankwɛn ndǔ bɛbʉ́! Mamɔ ápú nɔk bɛ́twɔ, kɛ chɔŋ ɛ́mbɛ́p ntá mmu anɛ átwɔ̀ nɛ mamɔ ɛncha! ");
INSERT INTO kenNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ɛ́rɨ yɛ bɛ mbák awɔ ywɛ amɔt, nɛ yɛ̌ chi ɛkak ɛyɛ kɛ̌ ɛ́kʉ̀ ɔnkwɛn ndǔ bɛbʉ́, kpɔ́t awɔ wu, nɛ yɛ̌ chí ɛkak gʉɛp! Ɛ́chí sayri bɛ́ ɔ́mbák nɛ Mandɛm ndǔ nɛpɛ́m ɛnɛn nɛbhɨkɨ bhɔŋ ngwɛnti, yɛ̌ chí nɛ awɔ amɔt, yɛ̌ chí nɛ ɛkak ɛ́mɔt, ɛ́chá bɛ́mɛ́sɛ wɔ amɛm ngó anɛ apu nɛmɛ, nɛ amɔ apay, bɛkak bɛpay. ");
INSERT INTO kenNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nɛ mbák nyɛ́sɛ́ ɛnɛ nɛ́kʉ̀ bɛ́ ɔ́nkwɛ́n ndǔ bɛbʉ́, poŋórí nɔ́ fɛrɛ, ɔ́ngʉɛp. Ɛ́chí sayri bɛ́ ɔ́nchwe ndǔ nɛpɛ́m ɛnɛn nɛbhɨkɨ bhɔŋ ngwɛnti nɛ nyɛ́sɛ́ nɛ́mɔt ɛcha mɛ́mɛ́sɛ wɔ amɛm nɛpǐngo nɛ amɨ́k ayɛ ankɛm apay.” ");
INSERT INTO kenNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yesu arɛm ntá bakoŋo bhi bɛ, “Sɔt ka mpok bɛ́ bǎkɛ́ byak yɛ̌ amɔt ndǔ nkwɔ bǎru bɔ̌bha abhɛn. Yɛ̌ntɨkɨ mmu wap abhɔŋ ángɛl amfay anɛ ákway bɛghati Mandɛm ɛnyɨŋ ɛnɛ ɛ́yɨ́ŋɨ́ yi yɛ̌ntɨkɨ mpok. ");
INSERT INTO kenNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Mɛ Mmu mfú ntá Mandɛm, ntwɔ́ chí bɛpɛmɛ yɛ̌ntɨkɨ mmu anɛ ánɛ́mɛ́ ɛbhɨ ");
INSERT INTO kenNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Bǎkaysi bɛ yi? Mbák mmu abhɔŋ bághɔ́ŋɔmɛ́n bɛsa bɛtay, amɔt anɛm ɛbhɨ, yí ǎkʉ yi? Pú ǎrɔ bághɔ́ŋɔmɛ́n anɛ achi ndǔ nkwɔ́ bɛsa mɛnwi nsɛm nɛku nɛ anwi ambɨ̌-njiɛ, andɔk bɛyaŋ awu amɔt anɛ ánɛ́mɛ́? ");
INSERT INTO kenNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nchí ghati bhe bɛ, mbák ayaŋ wú aghɔ, maŋák ǎyá yi antɨ ɛ̌ti ághɔ́ŋɔmɛn wu amɔt ɛncha maŋák amɛn yi ábhɔŋ bɛ anɛ́ bɛsa mɛnwi nsɛm nɛku nɛ anwi abhɨkɨ taka ɛbhɨ. ");
INSERT INTO kenNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ɛ́chí ɛnyumɔt nɛ Ɛta yɛka mmu achi amfay bɛ apú yaŋ yɛ̌ mandú mɔ́ywi amɔt ánɛ́m ɛbhɨ.” ");
INSERT INTO kenNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Bɛrɔŋ ambɨ Yesu arɛm bɛ, “Mbák ntɨ mǔnkwɔ ánkʉ́ wɔ bɛbʉ́, dɔ́k tɛmɛrí yi, mǎmbák ndiɛrɛ be bati apay. Mbák ɔkʉ yi ángɔ́ bɛkwɛ́nɛ́ bhi mǎnsokori ndakárɛ́, nɔ ɔwɛ́nɛ́ ntɨ mǔnkwɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kɛ mbák abhɨ́kɨ́ ka bɛghok ɛnyɨŋ ɛnɛ ɔ́rɛ̀m, pɛt dɔ́k ghɔ́ yi nɛ manɔ achak amɔt, yɛ̌ bati apay, yɛ̌ arat, bɛ́ bɔ́ mámbák batísiɛ ndǔ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ bárɛ̀m. ");
INSERT INTO kenNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Mbák abhɨ́kɨ́ ka bɛghok bhɔ nkwɔ, kʉ nkwɔ Mandɛm mándɨ́ŋɨ́. Nɛ mbák bo Mandɛm bárɛm kɛ yí ǎchòk chi batú, dɔ̌ yi ambak yɛ̌ mbɔ mmǔ anɛ ápú chyɛ Mandɛm kɛnókó, nɛ mbɔ mbɛbhɛ́ nkabhɛ́nti. ");
INSERT INTO kenNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Dɨŋɨ́ ká bɛ, yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ bǎgwɔ́rɛ́ fá amɨk, Mandɛm ǎgwɔt awu amfay. Nɛ ɛnɛ́ bǎkáŋárí fá amɨk, Mandɛm ǎkaŋari yɔ awu amfay. ");
INSERT INTO kenNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ɛnyɨŋ ɛ́chák ɛnɛ mɛ̌yaŋ mǎndɨŋɨ chi bɛ mbák bo bati apay mánká ɛyɔŋ ɛ́mɔt fá amɨk ndǔ ɛnyɨŋ ɛnɛ bɔ́ báyàŋ nɛ mánɨ́kmʉɛt, Ɛtaya mmu achi amfay, ǎghók nɛnɨkɨ́mʉɛt ɛnap. ");
INSERT INTO kenNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Yɛ̌ntɨkɨ ɛbhak ɛnɛ́ bakoŋo bha bati apay, bati arat, báchɛ́mɛ́ ɛ̌ti ya, nchí arɛ́ nɛ bhɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Píta arɔk yɛ ntá Yesu abhɛp yi bɛ, “Acha, mbák mmu ántóŋórí bɛkʉ mɛ bɛbʉ́, mbɔ̌ŋ bɛ́fóŋóri yi ndɔŋ ɛ́ní? Ndɔŋ tándrámɔt kɛ?” ");
INSERT INTO kenNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu akɛmɛ yi bɛ, “Wáwák! Mbák mmu ántóŋórí bɛkʉ wɔ bɛbʉ́, ɔbhɔŋ bɛ́fóŋóri yi maŋɔk bɛsa bɛrat nsɛm byo, ndɔŋ tándrámɔt.” ");
INSERT INTO kenNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Dɔ̌ ka ngati bhe ɛ̌ti Kɛfɔ Mandɛm. Kɛ́chí mbɔ Mfɔ anɛ ábhɨ́ŋɨ́ bǒ bɛtɨk abhi bɛ́ yɛ̌ntɨkɨ mmǔ wap ánkɛ́mɛ́ nkáp anɛ yi ákɛ̀m yi. ");
INSERT INTO kenNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ábhó nɔ́kɔ́ bɛbhɛp barɛm ami, bátwɔ́ ntá yi nɛ mmu amɔt anɛ ákɛ̀m yi nkáp anɛ aya acha. ");
INSERT INTO kenNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nkʉ bɛtɨk wu kɛkway bɛkɛmɛ bɛyǎ nkáp wu. Chi-bɛtɨk ywi achyɛ ɛyɔŋ bɛ mántí yi nɛ ngɔrɛ́ ywi nɛ bɔ̌bhi, nɛ yɛ̌ntɨkɨ ɛnyɨŋ ɛ́chák ɛnɛ yi ábhɔ́ŋɔ́, bɛ́ nkáp ywi ámfú. ");
INSERT INTO kenNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Mmǔ bɛtɨk wu ághókó nɔ́kɔ́ nɔ́, akwɛ́n bɛkak mfɔ wu abho mɛ́nɨkmʉɛt bɛ, ‘Acha, chyɛ̌ mɛ́ mpok, chɔŋ nkɛmɛ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ mɛ̌kɛm wɔ́.’ ");
INSERT INTO kenNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Chi-bɛtɨk aghɔ́ nkʉbɛtɨk wu ntínso, afoŋori yi, afɛrɛ ntí ndǔ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ yi ákɛ̀m yi, arɔ yí ándɔ́k. ");
INSERT INTO kenNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Kɛ nkúbhɛ́ mmu anɛ mfɔ wu áfóŋórí áfú nɔ́kɔ́, arɔk atɛmɛri ntɨ nkʉbɛtɨk anɛ ákɛ̀m yi manyǔ nkáp anɛ ápú yɛ̌nyɨŋ. Akɛ́m yi angoŋo arɛm bɛ, ‘Kwɔ barɛm amɛn ɔ́kɛ̀m mɛ nɛ́nɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ntɨ nkʉbɛtɨk wu akwɛ́n yi bɛkak abho mɛnɨkmʉɛt bɛ, ‘Chiɛ́ mɛ́ mpok, chɔŋ nchyɛ́ ɛnyɨŋ ɛnɛ mɛ̌kɛ̀m wɔ.’ ");
INSERT INTO kenNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kɛ abhɨ́kɨ́ ghok wáwák. Akʉ bákɛ́m mmʉɛrɛ ywi wu, bárɔk, bafyɛ ɛkɛrɛ́kɛnɔŋ, bɛ mbák abhɨkɨ kwɔ barɛm ami ánáŋá, apú fú arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Batɨ̌ bǒ bɛtɨk bághɔ́ ɛnyɨŋ ɛnɛ yi ákʉ́, batɨ ábé bhɔ tontó. Bárɔ́k bágháti mfɔ wu yɛ̌ntɨkɨ ɛnyɨŋ, ɛnɛ ɛfakari. ");
INSERT INTO kenNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mfɔ achyɛ ɛyɔŋ bɛ́ mándɔ́k mántwɔ́ nɛ yi. Bátwɔ́ nɔ́kɔ́ nɛ yí, arɛm ntá yi bɛ, ‘Wɔ ɛbɛ́ptí nkʉbɛtɨk nɛ! Ɔ́nɨ́kmʉɛt ndɔ́ wɔ́ ɔrɔ̌ŋ nɛ bɛyǎ nkáp anɛ ɔ́kɛ́mɛ́ mɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Wɔ nkwɔ́ ɔpú kwáy bɛghɔ mbʉ ntɨ mǔbɛtɨk ntínso mbɔ ɛnyǔ ngɔ́ wɔ ntínso?’ ");
INSERT INTO kenNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Mfɔ wu achyɛ ɛyɔŋ nɛ bɛyǎ bɛběntɨ́, bɛ mánsɔt yi mǎmɛ́sɛ ɛkɛrɛ́kɛnɔŋ bɛ́ mbák abhɨ́kɨ́ kɛmɛ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ yi ákɛ́mɛ́, apu fú arɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesu ánáŋá nɔ́kɔ́ bɛtɛm nɛkay ɛnɛn, aghati bakoŋo bhi bɛ, “Nɔ́ kɛ̌ Ɛtaya mmu achi amfay ákʉ̀ nɛ yɛ̌ntɨkɨ mmǔ ywɛka anɛ ánísí bɛghɔ ntɨ ntínso, kɛ́ka bɛfoŋori yi nɛ ntɨ nɛnkɛm.” ");
INSERT INTO kenNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Mpok Yesu ánáŋá bɛrɛm mɛnyɨŋ ɛbhɛn atú Gálili, afa, apé Nyɛ́n Jɔ́dan, asɛp, arɔk atú Judɛ́ya. ");
INSERT INTO kenNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Bɛyǎ bhó bákóŋo yi arɛ, abú abhɛn mámè. ");
INSERT INTO kenNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ágháká nɔ́kɔ́ arɛ́, mbɔk bǒnkwɔ Fárisi bárɔ́k mɛmɔ yi, bábhɛp yi bɛ, “Yɛ̌ yí, yɛ̌ yi, ɛbhé ɛyɛsɛ ɛka bɛ mmu ándɔ́ ngɔrɛ́ ywi ndǔ nɛbhay kɛ ɛbhɨkɨ ka?” ");
INSERT INTO kenNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu akɛmɛ bhɔ bɛ, “Bǎbhɨ́kɨ́re pay ɛnyɨŋ ɛnɛ ɛchi amɛm ɛkáti Mandɛm-ɛ? Ɛ́ghàti bhɛsɛ bɛ, tɛ nɛbhǒmɨk, Mandɛm aghókó nyaka mɛnyǔ bo bapay, ngɔrɛ́ nɛ mbakanɛm, ");
INSERT INTO kenNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","arɛm bɛ, ‘Ɛ̌ti yɔ, mbakanɛm abhɔŋ bɛ́rɔ ɛtayi nɛ máyi, ambat mmʉɛt nɛ ngɔrɛ́ ywi, ");
INSERT INTO kenNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","bɔ́ batí apay mándɔp chi mmǔ amɔt.’ Bɔ́ kɛpɛrɛ bhak yɛ bati apay, kɛ mmǔ amɔt. Mmu ákɛ fyɛ yɛ ákɔ́rɛ́ nɛ́ntɨ bo abhɛn Mandɛm áchɛ́mɛ́.” ");
INSERT INTO kenNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Bǒnkwɔ Fárisi bábhɛ́p Yesu bɛ, “Mbák ɛnyu yɔ kɛ ɛ́chí, ndaká yí Moses árɛ́mɛ́ bɛ́ mmu ǎkway bɛrɔ ngɔrɛ́ ywi mbák achyɛ yi ɛkáti awáy nɛbhay?” ");
INSERT INTO kenNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu akɛmɛ bhɔ bɛ, “Chí ɛ̌ti nɛtaŋántɨ ɛnɛka kɛ̌ Moses áká nyaka bɛ bǎkway bɛrɔ baghɔrɛ́ bhɛka ndǔ nɛbhay. Ɛ́pú nyaka ɛnyu yɔ ndǔ nɛbhǒnɛt. ");
INSERT INTO kenNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Dɨŋɨ́ ká bɛ, yɛ̌ agha anɛ árɔ́ ngɔrɛ́ ywi ndǔ nɛbhay, kɛbhák bɛ́ ngɔrɛ́ akwɛn bɛrwɔp, ambáy ngɔrɛ́ achak, akwɛn bɛrwɔp.” ");
INSERT INTO kenNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yesu árɛ́m nɔ́kɔ́ nɔ́, bakoŋo bhi bárɛm bɛ, “Mbák ɛ́chí nɔ́, ntí ápú yɛ́ anɛ mmu abhay ngɔrɛ́.” ");
INSERT INTO kenNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Kɛ Yesu akɛmɛ bhɔ bɛ, “Puyɛ̌ yɛ̌ntɨkɨ mmu kɛ ǎkway bɛka bɛyɔŋ ɛbhɛn. Ndiɛrɛ bo abhɛn Mandɛm achyɛ́ bhɔ ntɨ bɛ́chɔ́kɔ́ nɔ, kɛ̌ bákway bɛka bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Mbɔk bo bachi bagú-bhó tɛ amɛm mɛniɛ. Abhɛ́nɛ́fú báchí bagú-bhó mbɔnyunɛ bo bachak kɛ bákʉ́ bɔ mámbák nɔ. Kɛ báchák bábhɨ́kɨ́ ka nɛbhay ndu báchyɛ́ mmʉɛt bɛkʉ bɛtɨk Kɛfɔ̌ mfáy. Yɛ̌ntɨkɨ mmu anɛ ákwày bɛkoŋo ɛnyɨŋ ɛnɛ ndɛ́mɛ́, ánkóŋó yɔ́.” ");
INSERT INTO kenNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Bofú básɔ́t bɔ̌bhap bárɔ́k ntá Yesu nɛ bhɔ bɛ yi anyaŋa bhɔ amɔ anti, anɨkmʉɛt bɛ Mandɛm anjɛt bhɔ. Bakoŋo bhi bághɔ́ nɔ́kɔ́ nɔ́, bábho bɛsayti bhɔ bɛ bákɛ́ sɔŋɔri Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kɛ Yesu arɛm bɛ, “Dɔ̌ ká mǎmbɔ mantwɔ ntá ya, bǎkɛ́ chyɛt bhɔ mbi mbɔnyunɛ bǒ abhɛn bachi mbɔ bhɔ kɛ̌ Mandɛm ábhak Mfɔ awap.” ");
INSERT INTO kenNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yesu árɛ́m nɔ́kɔ́ nɔ́, asɔt bɔ̌bhɔ anyaŋa bhɔ amɔ anti, ayɛt bhɔ. Ákʉ́ nɔ́kɔ́ nɔ́, arɔ nɛbhʉɛt wu arɔk ɛbhak ɛ́chak. ");
INSERT INTO kenNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ɛ́fákari bɛ mmu amɔt arɔk ntá Yesu, abhɛ́p yi bɛ, “Ntɔŋ, ntɨkɨ ɛrɨ́tí ɛnyɨŋ mɛ̌kwáy bɛkʉ kɛ Mandɛm anchyɛ mɛ nɛpɛ́m ɛnɛn nɛ́bhɨ́kɨ́ bhɔŋ ngwɛnti?” ");
INSERT INTO kenNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu akɛmɛ yi bɛ, “Ndaká yí ɔ́bhɛ̀p mɛ ɛ̌ti ɛrɨ́tí ɛnyɨŋ? Mmǔ amɔt aywǐntí kɛ árɨ́. Mbák ɔ̌yáŋ yi anchyɛ wɔ nɛpɛ́m ɛnɛn nɛ́bhɨ́kɨ́ bhɔŋ ngwɛnti, ɔbhɔŋ bɛ́bhʉ́rɛ́ bɛbhé Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mmǔ wu abhɛp Yesu bɛ, “Ɛbhɛ́n?” Yesu akɛmɛ yi bɛ, “Ɔrɨ́ŋɨ́ bɛbhé Mandɛm. Bɛ́rɛ̀m bɛ, ‘Kɛ́ kwɛn bɛrwɔp. Kɛ́ wáy mmu, Kɛ́ ghɛp aghɛ́p. Kɛ́ te ntísiɛ akwarɛ, ");
INSERT INTO kenNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","chyɛ̌ máyɛ nɛ ɛtayɛ kɛnókó. Nɛ ɔbhɔŋ bɛkɔŋ ntɨ nkwǎ mbɔ ɛnyu ɔ́kɔ́ŋɔ́ mmʉɛt ɛyɛ.’” ");
INSERT INTO kenNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ɛsakámu yɔ arɛm bɛ, “Nnáŋ nchí bhʉɛrɛ bɛbhé ɛbhɛn mɛnkɛm. Ɛnyɨŋ ɛ́chák ɛ́bhʉɛ́t kɛ́?” ");
INSERT INTO kenNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu aghati yi bɛ, “Mbák ɔ̌yáŋ ɔmbak chak ndǔ babhi ankɛm, dɔ́k tí mɛnyɨŋ ɛbhɛ mɛnkɛm, chyɛ̌ nkáp ntá bachɛ́bhɛ́bho. Mbák ɔ́nkʉ́ nɔ, chɔŋ ɔ́mbɔŋ kɛfɔ̌ mɛnyɨŋ amfay. Ɔ́ntwɔ́ yɛ ɔnkoŋo mɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ɛsakámu yɔ ághókó nɔ́kɔ́ nɔ́, arɔbhɛ rɔŋɛrɔŋ nsónso mbɔnyunɛ abhɔ̌ŋ nyaka bɛyǎ mɛnyɨŋ. ");
INSERT INTO kenNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesu ayibhiri mmʉɛt arɛm ntá bakoŋo bhi bɛ, “Nchí ghati bhe bɛ ɛ́bè mmʉɛt tontó bɛ mǔnkáp anka Mandɛm ambak Mfɔ ywi. ");
INSERT INTO kenNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ɛ́chí wɨkɨrɨk bɛ mpɔŋɔ baso ámfʉɛ́t ndǔ mbok mbíábhan ɛ́cha mǔnkáp bɛ́ka Mandɛm ambak Mfɔ ywi.” ");
INSERT INTO kenNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Bakoŋo Yesu bághókó nɔ́kɔ́ nɔ́, bápɔ́p! Babho bɛbhɛp yi bɛ, “Mbák ɛnyu yɔ kɛ̌ ɛchi, ághá yɛ́ ákway bɛbhak mmu anɛ Mandɛm ápɛmɛ?” ");
INSERT INTO kenNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu ayɨŋɨ bhɔ diíí, arɛm bɛ, “Ntá nkwǎŋwaŋ, mbi ápú, kɛ yɛ̌nyɨŋ ɛ́pú cha Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Píta asá ɛyɔŋ arɛm bɛ, “Ná nɛ bhɛsɛ́? Sɛ́rɔ́ yɛ̌ntɨkɨ ɛnyɨŋ sɛ́kòŋo wɔ! Nsáy anɛ sɛ́bhɔ̀ŋ chí yí?” ");
INSERT INTO kenNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu aghati bhɔ bɛ, “Nchí ghati bhe bɛ ndǔ mmɨk nkɔ, mpok Mmu anɛ áfú ntá Mandɛm áchɔ̀kɔ ndǔ ɛnɔkɔ́ kɛfɔ yi nɛ kɛnɛ́m kɛnkɛm, be bakoŋo bha bǎchɔ̀k nkwɔ́ ndǔ mɛnɔkɔ́ kɛfɔ, bɛkɛm manɛrɛ́kɛt Israɛl byo nɛ apay. ");
INSERT INTO kenNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nɛ yɛ̌ agha anɛ árɔ́ yɛ̌ chí bɛkɛt, yɛ̌ chi bɔ̌mayi, yɛ̌ chí ɛ́táyi, yɛ̌ chí máyi, yɛ chí bɔ̌bhi, yɛ̌ chí bakɨ yi ɛ̌ti yí ákòŋo mɛ, chɔŋ ampɛt ambɔ́ŋ mɛnyɨŋ ɛbhɛn mɛnkɛm ndɔŋ bɛsa bɛtay, ambɔ́ŋ nkwɔ́ nɛpɛ́m ɛnɛn nɛbhɨkɨ bhɔŋ ngwɛnti. ");
INSERT INTO kenNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kɛ chɔŋ bɛyǎ bo abhɛn bachi ambɨ nɛ́nɛ, mándɔp ansɛm, nɛ abhɛn bachi ansɛm, mándɔp bayǎmbɨ.” ");
INSERT INTO kenNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesu arɔk ambɨ bɛrɛm bɛ, “Mbák Mandɛm achi nɛ bho mbɔ Mfɔ wap, mɛnyɨŋ bɛ́bhak mbɔ ɛnyu ɛ́chí ndǔ nɛkay ɛnɛn. Nɛkǎy ɛnɛn nɛchi bɛ, mbɔŋɔ́nkɨ̌fú achi nyaka. Ɛwak ɛ́mɔt, afa beti beti arɔk bɛyaŋ bǒ abhɛn bákʉ̀ bɛtɨk amɛm nkɨ ywi. ");
INSERT INTO kenNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Aka nɛ bakʉ̌ bɛtɨk abhɛn yi ayambɨ ásɔ́rɛ́ bɛ chɔŋ yi anchyɛ bhɔ nkáp anɛ́ ákwáy ndǔ bɛtɨk ɛbhɛn nywɔp nɛmɔt. Ató yɛ́ bhɔ bɛ mándɔ́k mánkʉ́ bɛtɨk amɛm nkɨ ywi.” ");
INSERT INTO kenNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ɛ́gháká nɔ́kɔ́ nkárɛ́nká nɛ́nɛnamɔt beti bhɔ, afa arɔk nɛfísiɛ, aghɔ́ bǒfu tété abhɛn babhɨkɨ bhɔŋ yɛ̌nyɨŋ bɛkʉ. ");
INSERT INTO kenNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Aghati bhɔ bɛ, “Dɔ́k ká nkwɔ ndǔ nkɨ wa mankʉ́ bɛtɨk arɛ́. Mǎnáŋ mǎmfáté beku, chɔŋ nchyɛ́ bhe nkáp anɛ ákwáy.” Báfʉɛ́t bárɔ́k. ");
INSERT INTO kenNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ɛ́gháká nɔ́kɔ́ mbɔ nkárɛ́nká byo nɛ ɛpay, nɛ nkarɛnka ɛ́rát ɛnɛ ngósí, mbɔŋɔ́nkɨ wu akʉ ɛnyumɔt. Nɔ́ chí, asɔt bǒ bɛtɨk bachak ató ɛbhɨ. ");
INSERT INTO kenNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Bɛ́rɔ́ŋ nkárɛ́nká ɛtay beku, apɛt afú, arɔk ɛtɔk, aghɔ́ bo báchák tété, ɛnyɨŋ ɛnɛ bákʉ̀ ti. Abhɛ́p bhɔ bɛ, “Ndaká yí bǎchí fá tété, nywɔp nɛnkɛm, ɛnyɨŋ ɛnɛ bǎkʉ ti?” ");
INSERT INTO kenNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Bákɛ́mɛ yi bɛ, “Sɛ́chí fá tété mbɔnyunɛ sɛbhɨkɨ bhɔŋ mmu anɛ ásɔ̀t bhɛsɛ ndǔ bɛtɨk.” Mbɔŋɔ́nkɨ wu aghati bhɔ bɛ, “Dɔ́k ká nkwɔ mǎnkʉ́ bɛtɨk amɛm nkɨ wa.” ");
INSERT INTO kenNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ɛ́gháká nɔ́kɔ́ běku, mpok bakʉ̌ bɛtɨk bápɛtnsɛm anywɔ́p, mbɔŋɔ́nkɨ abhɨŋɨ mmu anɛ áyɨ̀ŋɨ bakʉ̌ bɛtɨk aghati yi bɛ, “Bɨŋɨ́ bakʉ̌ bɛtɨk chyɛ bhɔ bakáp ayap, bɛ́bhó nɛ abhɛn bárɔ́ŋɔ́ ɛbhɨ ndɔbhɛnsɛm, bɛwɛnti nɛ abhɛn báyámbɨ.” ");
INSERT INTO kenNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Abho nɛ abhɛn básɔ́rɛ́ bhɔ ndǔ bɛtɨk nkárɛ́nká ɛtay beku, achyɛ yɛ̌ntɨkɨ mmǔ wap nkáp nywɔp nɛmɔt ankɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ágháká nɔ́kɔ́ ntá bǒ abhɛn báyámbɨ bábhó bɛtɨk beti beti, bákáysi bɛ chɔŋ anchyɛ awap nkáp anja ancha anɛ bǒ abhɛn babho bɛtɨk chi beku. Kɛ achyɛ yɛ̌ntɨkɨ ntí mmu chi ɛnyumɔt, nɔ chi nkáp bɛtɨk ɛbhɛn nywɔp nɛmɔt. ");
INSERT INTO kenNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Básɔ́rɛ́ nɔ́kɔ́ bakap ayap, babho mɛnywinti ɛ̌ti mbɔŋɔ́nkɨ, ");
INSERT INTO kenNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","mándɛmɛ nɔkɔ bɛ, “Bǒ abhɛn bákʉ́ bɛtɨk chi ndǔ nɛŋɔkɔ́ nywɔp nɛmɔt, ɔchyɛ́ bhɔ nkáp ɛnyumɔt nɛ bhɛsɛ́ bhó sɛ́kʉ́ bɛtɨk ndǔ nywɔp nɛnkɛm amɛm ɛsɔ́ŋtí mmok.” ");
INSERT INTO kenNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Kɛ mbɔŋɔ́nkɨ akɛmɛ mmu wap amɔt bɛ, “Nkwǎnɛ, mbɨ́kɨ́ nyiɛ́ be yɛ̌nyɨŋ. Sɛ́ká ɛyɔŋ ɛ́mɔt nɛ bhe bɛ mɛ̌chyɛ yɛ̌ntɨkɨ mmu ywɛka nkáp bɛtɨk ɛbhɛn nywɔp nɛmɔt. Pú nɔ́? ");
INSERT INTO kenNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Sɔt nkáp aywɛ dɔ́k. Mɛmbɔŋ kɛ̌ mbɔ́ŋɔ́ ntɨ bɛchyɛ mmu anɛ abho bɛtɨk ndɔbhɛnsɛm nkáp bɛtɨk ɛbhɛn nywɔp nɛmɔt mbɔ ɛnyǔ nchyɛ́ wɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nkáp chi awa. Mbɨ́kɨ́ bhɔ́ŋ bɛtaŋ bɛkʉ ɛnyǔ nkɔ́ŋɔ́ nɛ wú? Mpabhamɨ́k akʉ ɔ̌béntɨ ndǔ ntɔ́ŋɔ́ bǒbhɛn bɛrɨ̌ntɨ?” ");
INSERT INTO kenNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesu ánáŋá nɔ́kɔ́ bɛ́tɛ́m nɛkay ɛnɛn, arɛm yɛ bɛ, “Ɛnyu ɛyɔ kɛ ɛchi bɛ chɔŋ bɛyǎ bayǎmbɨ mándɔp ansɛm, nɛ bɛyǎ barɔbhɛ́nsɛm mándɔp ambɨ.” ");
INSERT INTO kenNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ɛnɛ́ Yesu ákɔ̀ bɛrɔŋ Yerúsalɛm nɛ bakoŋo bhi bati byo nɛ apay, asɔt bhɔ nɛpak, abho bɛghati bhɔ ɛnyɨŋ ɛnɛ́ ɛ́bhɔ́ŋɔ́ bɛ́fákari nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Arɛm bɛ, “Ghók ká, sɛ́rɔ̀ŋ nɔ chi Yerúsalɛm, nɛ mpok sɛ́gháká arɛ́, chɔŋ mámfyɛ Mmu anɛ áfú ntá Mandɛm amɔ́ bǒbati bachiǎkap Mandɛm nɛ ntá batɔŋ ɛbhé Moses, bɔ́ mándɛm bɛ mángwáy yi. ");
INSERT INTO kenNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nɛ bǒbati mánsɔt yi mamfyɛ amɔ bo abhɛn bápú bo Israɛl, bɛ́ mánjɔ́kɔ́ yi, nɛ bɛ mándɛ́n yí nɛ ɛkpa, nɛ bɛ mángó yi ndǔ ɛkotákátí. Kɛ ɛ́gháká nɔ́kɔ́ manywɔp arat, ampɛtnsɛm ndǔ nɛpɛ́m.” ");
INSERT INTO kenNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ɛ́bhɨ́kɨ́ tat, ngɔrɛ́ Sɛbɛdi asɔt bɔ̌bhi bati apay, arɔk ntá Yesu nɛ bhɔ. Atɛp mánɛ́n bɛsí bhi are bhɛ́p yi bɛ ankwak yi. ");
INSERT INTO kenNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu abhɛ́p yi bɛ, “Ɔ̌yáŋ mɛ̌nkʉ wɔ yi?” Akɛmɛ bɛ, “Ɛta, kʉ bɛ́ mpok ɔ́bhàk Mfɔ, bɔ̌bha abhɛn bati apay, manchɔkɔ nɛ wɔ, amɔt ɛbhe awɔ́nɛm, achák ɛbhe awɔ́ghɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Kɛ Yesu akɛmɛ yi bɛ, “Ɔbhɨ́kɨ́ rɨŋɨ ɛnyɨŋ ɛnɛ ɔ́yàŋ nkʉ ntá yɛ. Bǎkwáy bɛka mɛnyu ɛsɔŋɔri anɛ mbɔ́ŋɔ́ mɛ́nyú?” Bákɛ́mɛ yi bɛ, “Sɛ́kwày bɛkʉ nɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu aghati bhɔ bɛ, “Tɛtɛp, chɔŋ mǎnyú nkɔ́p ɛsɔŋɔri anɛ mbɔ́ŋɔ́ mɛnyu, kɛ mbɨ́kɨ́ bhɔŋ bɛtaŋ bɛyap bo abhɛn babhɔŋɔ bɛchɔkɔ ɛbhe awɔ́nɛm ɛya nɛ abhɛn babhɔŋɔ bɛchɔkɔ ɛbhe awɔghɔ. Bɛbhak ɛbhɔ bɛchi ntá bǒ abhɛn Ɛtaya aghoko bhɔ́ ábhʉ́rɛ́ ntá yap.” ");
INSERT INTO kenNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Bakoŋo Yesu báchák bati byo bághókó nɔ́kɔ́ ɛnyɨŋ ɛnɛ bɔ̌ Sɛbɛdi barɛmɛ, bábhó bɛběntɨ nɛ mamʉɛrɛ bhap nɔ bachi nnɔ amɔt. ");
INSERT INTO kenNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ɛ́kʉ́ Yesu abhɨŋɨ bhɔ mankɛm arɛm bɛ, “Bǎrɨŋɨ bɛ ntá bǒ mmɨk, bafɔ bábhɔŋ bɛyǎ bɛtaŋ amfay bǒbhap, nɛ bǒbati básɔ̀t bɛyǎ bɛtaŋ bɛkʉ bǒbhap mángók bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kɛ ɛ́bhɨ́kɨ́ bhɔŋ bɛbhak ɛnyu yɔ ndǔ nkwɔ ywɛka. Mmu anɛ áyàŋ bɛbhak mǔngo ywɛka, abhɔŋ bɛbhak mǔbɛtok ywɛka, ");
INSERT INTO kenNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","nɛ yɛ̌ntɨkɨ mmu ywɛka anɛ áyàŋ bɛbhak mmǔ mbɨ abhɔŋ bɛbhak nsɛm aywɛka, ");
INSERT INTO kenNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","nkúbhɛ́ mbɔ ɛnyǔ Mɛ Mmu mfú ntá Mandɛm mbɨ́kɨ́ twɔ bɛ bo mántók mɛ. Ntwɔ chi bɛbhak mǔbɛtok, nɛ bɛchyɛ nɛpɛ́m ɛna ndu bɛku bɛyǎ bhó, mfɛ́rɛ́ bhɔ ndǔ kɛsɛmɛ́ bɛbʉ́.” ");
INSERT INTO kenNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu ǎfù nyaka ɛtɔk Jɛríko nɛ bakoŋo bhi. Ngɛ́mtay bho báré koŋo bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Manɛ́mámɨk bati apay babhak nɛpaká mbi chɔkɔ. Bághókó nɔ́kɔ́ bɛ́ Yesu kɛ̌ áfʉɛ̀t, bábho bɛbɨk mandɛmɛ nɔkɔ bɛ, “Ɛta, Mmɔ̌ Mfɔ Debhít! Ghɔ́ bhɛsɛ́ ntínso!” ");
INSERT INTO kenNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Bo abhɛn bachi arɛ bábhó bɛsayti manɛ́mámɨk bhɔ bɛ, “Kusí ká!” Kɛ bákpɨk bare bɨk nɛ ɛyɔŋ amfay bɛ, “Acha, Mmɔ̌ Mfɔ Debhít! Ghɔ́ bhɛsɛ ntínso!” ");
INSERT INTO kenNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu ate, abhɨŋɨ bhɔ, abhɛ́p bhɔ bɛ, “Bǎyàŋ bɛ́ nkʉ bhe yí?” ");
INSERT INTO kenNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bákɛ́mɛ yi bɛ, “Ɛta, sɛ́yàŋ ɔ́nkʉ́ amɨ́k yɛsɛ ánɛ́nɛ́.” ");
INSERT INTO kenNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu aghɔ́ bhɔ ntínso. Atɔk amɨ́k ayap. Tɛ́mté wu, babho bɛghɔ mbaŋ nɛ babho bɛkoŋo Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu nɛ baghɔkɔ́ bhi bákɔ́ baghaka ndǔ bɔ̌bɛtɔk Bɛtfágɛ nɛ Bɛ́tani, ndǔ Njiɛ Mɛnok Ólif, kɛkwɔt nɛ Yerúsalɛm. Aré, ató baghɔkɔ́ bhi bati apay ambɨ. ");
INSERT INTO kenNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ápɛ́rɛ tó bhɔ, aghati bhɔ bɛ, “Dɔ́k ká ndǔ mɔ́tɔk anɛ achi afɔ ambɨ. Nɛchwe bǎchwè ɛtɔk, chɔŋ mǎngɔ́ mpɔŋɔ batu sɛsɛ́t, nɛ mɔ́ywi. Kaŋárí ká, mǎntwɔ fá nɛ yɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mbák yɛ̌ mmu abhɛp be ntí anɛ bǎkàŋari yɔ, ghatí ká yi bɛ, ‘Acha, áyàŋ yɔ.’ Tɛ́mté wu, chɔŋ yi andɔ mǎnsɔt yɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ɛ́fákari nkúbhɛ́ ɛnyu ɛyɔ bɛ́ ɛnyɨŋ ndɛmɛkɛpɨ̌ntɨ árɛ́mɛ́ nyaka ɛ́mfú tɛtɛp. Ndɛmɛkɛpɨ̌ntɨ arɛm nyaka bɛ, ");
INSERT INTO kenNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ghatí bo Síɔn bɛ́ mfɔ wap ǎtwɔ̀. Abhɔŋ nɛsɛptǐmʉɛt, ǎtwɔ chɔkɔ amfǎy mpɔŋɔ batu, amfay mɔ́mpɔŋɔ batu.” ");
INSERT INTO kenNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Bakoŋo Yesu bhɔ bárɔ́k bakʉ mbɔ ɛnyǔ yi aghati bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Básɔ́t mpɔŋɔ batu yɔ nɛ mɔ́ywi, bárɔ́k ntá Yesu nɛ yɔ. Básɔ́t ndɛn mfǎmʉɛt yap basɔbhɛri yɔ, Yesu akó achɔkɔ amfay. ");
INSERT INTO kenNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bɛyǎ bo abhɛn bachi arɛ, báfɛ́rɛ ndɛn mfǎmʉɛt yap baghay ambi. Báchák báré kpɔt bɛ́wɔ́kɛ́ndé mángay nɔkɔ ndǔ mbi anɛ yí áfʉɛ̀t arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Bɛyǎ bho báré rɔŋ ambɨ, bachak mankoŋo nɔkɔ ansɛm. Yesu abhak nɛ́ntɨ́ ɛnap. Bɔ́ mankɛm báré bɨk mándɛmɛ nɔkɔ bɛ, “Sɛ́mbɨ́tí Nyiɛ̌ nɛwú Mfɔ Debhít! Mandɛm ánjɛ́t mmu anɛ átwɔ̀ ndǔ nnyɛ́n Acha! Sɛ́mbɨ́tí Mandɛm mfay!” ");
INSERT INTO kenNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nɛchwe yí áchwé Yerúsalɛm, ɛtɔk ɛnkɛm ɛ́nyɨ́kɨ́si tɨkɨ̌tɨk. Bo bábhó bɛbhɛp batɨ bɛ, “Anɛ mmu átwɔ̀ chi agha?” ");
INSERT INTO kenNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Bo abhɛn bákɔ̀ nɛ yi báré kɛmɛ mandɛmɛ nɔkɔ bɛ, “Chí Yesu, Ndɛmɛkɛpɨ̌ntɨ Mandɛm anɛ áfú Násárɛt, atú Gálili.” ");
INSERT INTO kenNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu áchwé nɔ́kɔ́ ɛtɔk, arɔk amɛm ɛkɛrákap Mandɛm. Abók bakɔ̌siɛ nɛ bo abhɛn bákù mɛnyɨŋ. Atakati bɛ́fɛ́mɛ́ bo abhɛn bákɔ̀ ɛsiɛ bakap bɛwupsi. Atakati nkwɔ́ mɛnɔk bo abhɛn bátì bɛbhóŋó. ");
INSERT INTO kenNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ndǔ Yesu ákʉ̀ nɔ, aghati bhɔ bɛ, Mandɛm arɛm bɛ, “Ɛkɛt ɛya ɛ́bhɔŋ bɛbhak chi ɛkɛrɛ́ nɛnɨkɨ́mʉɛt, kɛ bǎyibhiri yɔ ɛ́rɔp nɛbhʉɛt anɛ baghɛ́p bábhɛ̀sɛ arɛ.” Nɔ́ kɛ̌ básɨ́ŋɨ́ amɛm Ɛkáti Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ɛnɛ́ Yesu ábhʉɛ́t amɛm ɛkɛrákap Mandɛm, bɛyǎ manɛ́mámɨk nɛ bakɛm bárɔ́k ntá yi, abú bhɔ mankɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Bǒbati bachiǎkap Mandɛm nɛ batɔŋ ɛbhé Moses bághɔ́ mɛnyɨŋɨ́ maknkay ɛbhɛn Yesu ákʉ́. Bághɔ́ nkwɔ ndǔ mǎmbɔ bábɨ̀k amɛm ɛkɛrákap mándɛmɛ nɔkɔ bɛ, “Bakak nɛ kɛnókó ámbák nɛ Nyíɛ́-nɛwu Mfɔ Debhít!” Baghɔ nɔ́kɔ́ nɔ, batɨ ábé bhɔ amɛm tontó. ");
INSERT INTO kenNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Bábhɛ́p Yesu bɛ, “Ɔpú ghók nɔ ɛnyɨŋ ɛnɛ bɔ̌bhɛn bárɛ̀m-ɛ?” Yesu arɛm bɛ, “Nchí ghók. Nɔ́ tɛ̌ bǎchí, bǎbhɨ́kɨ́ re ghók wáwák ɛnyɨŋ ɛnɛ basɨŋɨ amɛm Ɛkáti Mandɛm?” Básɨŋ bɛ, “Ɔkʉ mǎmbɔ nɛ abhɛ́n babhʉɛt amɔ mándɨ́ŋɨ́ bɛchyɛ wɔ bakak nɛ kɛnókó?” ");
INSERT INTO kenNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yesu árɔ́ nɔ́kɔ́ bhɔ, afa Yerúsalɛm arɔk Bɛ́tani, abhʉrɛ arɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nɛ́yí nɔ́kɔ́, Yesu afa abho bɛpɛtnsɛm Yerúsalɛm. Nsay akɛ́m yi. ");
INSERT INTO kenNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ndǔ árɔ̀ŋ, aghɔ́ ɛnɔk fig nɛ́kú mbi. Arɔk arɛ́, kɛ yɛ̌ mɔ́sɛpɛmɛ́nɔk akɛ ghɔ́ amfay. Ɛ́bhɨ́kɨ́ fʉɛ́t chí bɛyé bɔbhɔ. Yesu arɛm ntá ɛnɔk ɛyɔ bɛ, “Tɛ̌ mmɨk ámáy, ɔpú pɛrɛ kway mɛnyu kɛpɛm.” Ɛnɔk fig ɛyɔ ɛgu tɛ́mté. ");
INSERT INTO kenNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Baghɔk Yesu bághɔ́ nɔ́kɔ́ ɛnyɨŋ ɛnɛ ɛ́fákárí, bábhák maknkay tontó. Bábhó bɛrɛm nɛ batɨ bɛ, “Yi ɛ́kʉ́ ɛnɔk fig ɛnɛ ɛgu tɛ́mté ɛnyunɛ?” ");
INSERT INTO kenNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu aghati bhɔ bɛ, “Nchí ghati bhe bɛ, mbák mǎmbɔŋ nɛka nɛ Mandɛm tɛtɛp, kɛmakati bɛtaŋ ɛbhɛn yí ábhɔ́ŋɔ́, bǎkwáy bɛkʉ ɛnyɨŋ ɛnɛ nkʉ ɛnɔk fig ɛnɛ. Nɛ bǎkwáy bɛ́gháti yɛ̌ chí njiɛ nɛ bɛ ‘Fǎ fá kwɛ́n awu amɛm manyu,’ ɛ́mfakari ɛnyu yɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nɛ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ́ mǎnɨkmʉɛt bɛ Mandɛm anchyɛ bhe, apú rɔ bɛchyɛ bhe, mbák mǎnókó.” ");
INSERT INTO kenNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu achwe amɛm ɛkɛrákap, abho bɛtɔŋ bho Ɛyɔŋ Mandɛm. Ndǔ yí ákʉ̀ nɔ, bǒbati bachiǎkap nɛ bǒbati ɛtɔk báchák bárɔ́k ntá yi bábhɛ́p yi bɛ, “Ntɨkɨ bɛtaŋ ɔ́bhɔ́ŋɔ́ bɛkʉ mɛnyɨŋ ɛbhɛn nɛ ɔ́kʉ̀? Agha áchyɛ́ wɔ bɛtaŋ ɛbhɔ?” ");
INSERT INTO kenNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu akɛmɛ bhɔ bɛ, “Mɛnkwɔ mbɔ̌ŋ ɛnyɨŋ ɛ́mɔt bɛbhɛp be. Mbák mǎnkɛ́mɛ́ mɛ yɔ, chɔŋ mɛnkwɔ ngati be mmu anɛ áchyɛ́ mɛ bɛtaŋ bɛkʉ mɛnyɨŋ ɛbhɛn mɛ̌kʉ̀.” ");
INSERT INTO kenNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ɛnyɨŋ ɛnɛ mbɔ́ŋɔ́ bɛbhɛp be chi bɛ, “Agha áchyɛ́ nyaka Jɔ̌n Njwiti bɛtaŋ bɛjwiti bho? Mandɛm, kɛ chí bǒ mmɨk?” Báre kɛm ɛpʉ́ítí nɛ batɨ bɛ, “Chɔŋ sɛ́ndɛm bɛ yi? Mbák sɛ́ndɛm bɛ bɛtaŋ ɛbhɛn Jɔ̌n bɛ́fú nyaka ntá Mandɛm, ǎbhɛ́p bhɛsɛ bɛ, ‘Kɛ ndaká yi bǎbhɨ́kɨ́ noko ɛyɔŋ ɛyi?’ ");
INSERT INTO kenNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nɛ mbák sɛ́ndɛ́m bɛ, ‘Bɛ́fǔ nyaka ntá nkwǎ’, nɔ́ sɛ́yàŋ ɛsɔŋɔri nɛ bǒ bhɛsɛ́ mbɔnyunɛ bɔ́ mankɛm mánoko sayri bɛ Jɔ̌n achi nyaka ndɛmɛkɛpɨ̌ntɨ Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Bákɛ́mɛ Yesu chi bɛ, “Sɛ́bhɨ́kɨ́ rɨŋɨ.” Yesu aghati bhɔ bɛ, “Mɛnkwɔ́ mpú ghati yɛ bhe mmu anɛ áchyɛ́ mɛ́ bɛtaŋ bɛkʉ mɛnyɨŋ ɛbhɛn nɛ́ mɛ̌kʉ̀.” ");
INSERT INTO kenNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesu arɛm bɛ, “Bǎrɛm bɛ́ yi ɛ̌ti ndak anɛ? Mmu amɔt achi nyaka nɛ bɔ̌bhi bati apay. Bábhák bɔ̌ babhakanɛm. Ɛwak ɛ́mɔt abhɨŋɨ anɛ mbɨ aghati yi bɛ, ‘Mɔ́wa, dɔ́k kʉ́ bɛtɨk amɛm nkɨ ɛchɔŋ.’” ");
INSERT INTO kenNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Mɔ́wu akɛmɛ bɛ, “Mpú rɔ́ŋ.” Kɛ ansɛm mpok, awupsi ntɨ arɔk. ");
INSERT INTO kenNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Chi afʉɛ́t arɔk ntá mmɔ̌ anɛ mɔ́nkwɛn, aghati yi nkwɔ bɛ, “Mɔ́wa, dɔ́k amɛm nkɨ kʉ bɛtɨk ɛchɔŋ. Mɔ́wu akɛmɛ yi bɛ ‘Ɛta, chɔŋ ndɔk.’ Kɛ akɛrɔ́ŋ. ");
INSERT INTO kenNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ghatí ká mɛ. Ndǔ bɔ̌bhɔ bati apay, anɛ ághókó ɛ́táyi, akʉ ɛnyɨŋ ɛnɛ yi áyàŋ chí anɛ́?” Bǒ mankɛm bakɛmɛ bɛ, “Anɛ nsénsí.” Yesu aghati bǒbati bo Israɛl bhɔ bɛ, “Dɨŋɨ́ ká tɛtɛp bɛ bǒ bɛbʉ́ mbɔ babhɛbhɛ́ nkábhɛ́nti nɛ baghɔrɛ́-nɛkɔ báyámbɨ bɛ́bhɔ́ŋ mbi bɛbhak bǒ abhɛn Mandɛm achi nɛ bhɔ mbɔ Mfɔ wap, ɛnɛ́ bǎrɔ̀p nsɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Nchí rɛm nɔ mbɔnyunɛ Jɔ̌n Njwiti atwɔ́ nyaka ntá yɛka bo Israɛl mankɛm, bɛtɔŋ bé ɛnyǔ mmu ákwáy bɛbhʉrɛ nɛpɛ́m ɛni chak bɛsí Mandɛm, kɛ bǎbhɨ́kɨ́ noko ɛnyɨŋ ɛnɛ yi árɛ̀m. Babhɛbhɛ́ nkabhɛnti nɛ baghɔrɛ́-nɛkɔ kɛ̌ mánókó ɛnyɨŋ ɛnɛ yi árɛ̀m. Yɛ̌ndu bǎghɔ́ bɛ́ babhɛbhɛ́ nkábhɛ́nti nɛ baghɔrɛ́-nɛkɔ mánóko Jɔ̌n, bǎkɛ tɨ́knsɛm bɛ mǎnókó ɛnyɨŋ ɛnɛ yí árɛ̀m.” ");
INSERT INTO kenNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ghok ka nɛkay nɛ́chák, “Mmǔfú abhɔ̌ŋ nyaka nkɨ. Apɨ mɛnɔk vain arɛ. Atɛp ɛbhá ɛnɛ ɛghabhɛri nkɨ ankɛm. Atɛ́m mbok aghoko nɛbhʉɛt anɛ báyàt kɛpɛm váin, bɛ nnok ywi amfu, mánsɔt, máná mmɛ́m. Ate mɔ́kɛrɛ́mfay amɛm nkɨ wu, bɛ́ ámbák nɛbhʉɛt anɛ mmu áchɔ̀kɔ ndu bɛ́bhábhɛ́ri nkɨ. Afyɛ́ yɛ bo arɛ́ bɛ mánkʉ bɛtɨk mánkɔrɛ nsáy nɛ yi. Arɔ, arɔk nɛkɔ ɛtɔk ɛchak. ");
INSERT INTO kenNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Mpok bɛkɔk kɛpɛmɛ́nɔk ákwáy nɔ́kɔ́, mbɔŋɔ́nkɨ ató bakʉ̌ bɛtɨk bhi bachak bɛ mándɔ́k mánsɔ́t aywi ákɔ́rɛ́ mbwɔt. ");
INSERT INTO kenNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kɛ báchwɔ́bhɛ́ nɔ́kɔ́ amɛm nkɨ, bakʉ̌ bɛtɨk ndǔ nkɨ bákɛ́m bhɔ. Bádɛ́n amɔt, báwáy áchák, bátɛ́mtí anɛfú nɛ batay. ");
INSERT INTO kenNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ɛ́bhɨ́kɨ́ tat, mbɔŋɔ́nkɨ wu afɛrɛ bakʉ̌ bɛtɨk abhi báchák ató. Báyá báchá abhɛn mbɨ. Kɛ bakʉ̌ bɛtɨk abhɛn báchí amɛm nkɨ bákɛ́m bhɔ, bákʉ́ ɛnyumɔt nɛ bhɔ́, mbɔ ɛnyǔ bákʉ́ nɛ abhɛn mbɨ. ");
INSERT INTO kenNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ndǔ ngwɛnti, mbɔŋɔ́nkɨ arɛm nɛ mmʉɛt yi bɛ, ‘Chɔŋ ntó mbɔŋ mɔ́wa. Yɛ̌ yí, bábhɔŋ bɛ́chyɛ yi kɛnókó.’ Afɛrɛ yɛ mɔ́ywi ató. ");
INSERT INTO kenNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kɛ nɛghɔ́ anɛ bakʉ̌ bɛtɨk bághɔ́ yi, bábhó bɛrɛm nɛ batɨ bɛ, ‘Yɨŋɨ́ mbɔ̌ŋ mɔ́ywi nɛ́, nɛ yí kɛ̌ ábhɔ́ŋɔ́ mɛ́nyiɛ́ nɛwú ɛtayi. Twɔ́ ká sɛ́nkɛm yi sɛ́ngwáy bɛ́ ɛtayi ánáŋ ángú, mɛnyɨŋ ɛbhi mɛ́ndɔp chi ɛbhɛsɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Bákɛ́m yɛ́ yi, baya, báfú amɛm nkɨ nɛ yi, barɔk baway.” ");
INSERT INTO kenNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesu ánáŋá nɔ́kɔ́ bɛ́tɛ́m nɛkay ɛnɛn, abhɛ́p yɛ bǒbati ɛtɔk Israɛl bɛ, “Bě bǎkáysí bɛ́ mpok mbɔŋɔ́nkɨ wu ápɛ́rɛ́nsɛm nɛkɔ ɛnɛn yí árɔ́ŋɔ́, ǎkʉ yi nɛ bakʉ̌ bɛtɨk bhɔ?” ");
INSERT INTO kenNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bǒbati bhɔ bakɛmɛ Yesu bɛ, “Mpok anɛ mbɔŋɔ́nkɨ wu ápɛ́rɛ́nsɛm, ǎkʉ bɛbɛ́ptí bakʉ̌ bɛtɨk bhɔ mángú ɛbɛ́ptí nɛwú, ansɔt nkɨ wu anchyɛ ntá bakʉ̌ bɛtɨk abhɛn bápú nɔ́k bɛchyɛ yi aywi ákɔ́rɛ́ mbwɔt tɛ́mté, yɛ̌ntɨkɨ mpok anɛ ɛnyɨŋ ɛ́fú ɛbhɨ.” ");
INSERT INTO kenNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu abhɛ́p bhɔ bɛ, “Bǎbhɨ́kɨ́ re pay ɛnyɨŋ ɛnɛ ɛchi amɛm Ɛkáti Mandɛm? Básɨŋ bɛ, ‘Nkúbhɛ́ ntay ɛnɛn batěkɛt bágʉɛ́bhɛ́ bɛ́ nɛ́bhɨ́kɨ́ rɨ, nɔ́ kɛ nɛ́rɔ́bhɛ́ ntay ɛnɛn nɛ́kɛ́mɛ́ ɛkɛt nɛchá batay áchák ankɛm. Mandɛm kɛ ákʉ́ bɛ́ ɛ́mbák ɛnyu yɔ, nɛ ɛchi ndaká maknkay tontó ntá yɛsɛ!’ ");
INSERT INTO kenNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Mɛ̌ghàti yɛ be bɛ, chɔŋ Mandɛm amfɛrɛ áfɔ́k anɛ bǎbhɔ́ŋɔ́ ndǔ yí áchí nɛ bhe mbɔ Mfɔ ywɛka, anchyɛ ntá bo báchák abhɛn bákʉ̀ mɛnyɨŋ ɛbhɛn yi áyàŋ bɔ mankʉ.” ");
INSERT INTO kenNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Yɛ̌ntɨkɨ mmu anɛ akwɛnɛ ndǔ ntay ɛnɛn, ǎsìɛpti ndǔ mbɨŋ, nɛ mmu anɛ ntay ɛnɛn nɛ́kwɛ́nɛ́ yi amʉɛt, nɛ́chɔ̀kɔti yi. ");
INSERT INTO kenNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Bǒbati bachiǎkap Mandɛm nɛ bǒnkwɔ Fárisi bághókó nɔ́kɔ́ bakay yɔ nɔ́ Yesu átɛ́mɛ́, bárɨ́ŋɨ bɛ ǎrɛ̀m nɔ chí ɛ̌ti yap. ");
INSERT INTO kenNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Báre yaŋ bɛkɛm yi, kɛ báchày nyaka bɛyǎ bo abhɛn báchi arɛ, mbɔnyunɛ bárɨ́ŋɨ́ nyaka bɛ bǒbhɔ básɔt Yesu mbɔ ndɛmɛkɛpɨ̌ntɨ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu apɛt abho bɛghati bhɔ mɛnyɨŋ ndǔ bakay. ");
INSERT INTO kenNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Yí bɛ, “Mbák Mandɛm achi nɛ bho mbɔ Mfɔ wap, mɛnyɨŋ bɛ́bhak mbɔ ɛnyu ɛchi ndǔ nɛkay ɛnɛn. Mfɔ amɔt anak nyaka ɛpǎ nɛbhay ntá mɔ́ywi. ");
INSERT INTO kenNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Mpok ɛpa ákwáy nɔ́kɔ́, ató bɔ̌-bɛtok abhi bɛ́ mándɔ́k mángátí bǒ abhɛn yi ánáká bɛ mpok akway. Kɛ yɛ̌ amɔt kɛ twɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Apɛt abhɨŋɨ bɔ̌-bɛtok abhi báchák aghati bhɔ bɛ, ‘Dɔ́k ká ghati bo abhɛn nnáká bɛ́ ngwáy bhɔ bɛsɛnɛ́ mpɔŋ nɛ mǎnáŋ mana nɛnyíɛ́, yɛ̌ntɨkɨ ɛnyɨŋ ɛ́náŋ ɛ́chí téé. Dɔ́k ká ghati bhɔ mántwɔ́.’ ");
INSERT INTO kenNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kɛ ndǔ bo abhɛn yi ánáká mankɛm, yɛ̌ mmu amɔt abhɨ́kɨ́ fyɛ ntí. Mánkʉ nɔkɔ chi ɛbhap mɛnyɨŋ. Amɔt arɔk ɛbhɨ ɛyi, achák arɔk chí ɛkɛrɛ́siɛ ɛyi, ");
INSERT INTO kenNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","abhɛ́nɛ́fú bákɛ́mti bɔ̌-bɛtok abhɛn mfɔ wu átó, bádɛn mbɔ nnya baway. ");
INSERT INTO kenNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mfɔ wu abhɔ́ŋ bɛyǎ bɛběntɨ. Ató batɛmɛ́ nɛnu bhi bárɔ́k báwáy bǒbhɔ, básɔ́ŋ ɛtɔk ɛyap. ");
INSERT INTO kenNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Abhɨŋɨ yɛ bɔ̌-bɛtok abhi arɛm bɛ, ‘Mpok ɛpa akway. Kɛ bǒ abhɛn nnáká bátɔŋ bɛ babhɨkɨ kway bǒ abhɛn bátwɔ̀ ndǔ ɛpǎ ɛya. ");
INSERT INTO kenNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Dɔ́k yɛ́ ká ndǔ yɛ̌ntɨkɨ mbay, mǎnák yɛ̌ntɨkɨ mmu anɛ bǎghɔ́, bɛ́ ántwɔ́ ndǔ ɛpǎ nɛbhay.’ ");
INSERT INTO kenNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Bɔ̌bɛtok bhɔ bárɔ́k bakʉ mbɔ ɛnyǔ yi ághátí bhɔ. Bábhɨ́ŋɨ yɛ̌ntɨkɨ mmu. Mmǔ mbʉ́mbʉ mǎmbɨŋɨ bhɨ́ŋɨ, mmǔ ndɨ́ndɨ́ mǎmbɨŋɨ bhɨŋɨ. Ɛ́kʉ́ ɛkɛt ɛpǎ nɛbhay ɛ́jwí nɛ bo. ");
INSERT INTO kenNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Kɛ mpok mfɔ áchwé anywɔ́p bɛghɔ bǒ abhɛn yi ánáká, aghɔ́ bɛ́ mmu amɔt abhɨkɨ bhɔŋ nkú-nɛbhay amʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Abhɛ́p mmu wu bɛ, ‘Nkwǎnɛ, ɔkʉ́ ná kɛ ɔ̌chwe fá, nkú-nɛbhay wɔ amʉɛt tí?’ Ɛcha mmu wu ɛnyɨŋ bɛrɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Mfɔ achyɛ ɛyɔŋ bɛ mánkɛ́m yi mángwɔ́t amɔ nɛ bɛkak, mámɛsɛ nɛfí ndǔ ɛjuri. Arɛ́, bo bábhak ndǔ nɛdǐ kɛbhɔ nɛ nɛnyiɛ́ ámɛ́n.” ");
INSERT INTO kenNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu ánáŋá nɔ́kɔ́ bɛtɛm nɛkay ɛnɛn, arɛm bɛ, “Mandɛm ǎnak bɛyǎ bho, kɛ ǎyap chí bǎrú.” ");
INSERT INTO kenNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ɛ́bhɨ́kɨ́ tat, mbɔk bǒnkwɔ Fárisi bárɔ́k báté ɛyu, babho bɛyaŋ ɛnyǔ bákway bɛkʉ Yesu ánkwɛ́n anyu, bɛ bɔ mámbɔ́ŋ mbi bɛkɛm yi. ");
INSERT INTO kenNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Báká ɛyɔŋ ɛ́mɔt, bátó mbɔk bakoŋo bhap nɛ mbɔk bo Israɛl abhɛn báté ansɛm Hɛ́rɔd ntá Yesu bɛ mámbɛ́p yi bɛ, “Ntɔŋ, sɛ́rɨ́ŋɨ́ bɛ́ wɔ ɔchí mmu tɛtɛp, nɛ bɛ́ ɔ̌tɔ̀ŋ bho mbi Mandɛm tɛtɛp. Sɛ́rɨ́ŋɨ́ bɛ́ ɔpú yɨŋɨ mmu ndǔ bɛsí ɔ́ncháy yi. ");
INSERT INTO kenNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ghatí yɛ bhɛsɛ, ɛbhé yɛsɛ ɛka bɛ sɛ́nchíɛ nkábhɛ́nti ntá Mfɔ Rom kɛ ɛ́bhɨ́kɨ́ ka?” ");
INSERT INTO kenNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesu arɨŋɨ nkaysi mbʉ́mbʉ yap. Arɛm bɛ, “Bě bho bɛtábhá, ndaká yí mǎmɔ̀ mɛ?” ");
INSERT INTO kenNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Aghati bhɔ bɛ, “Tɔ́ŋ ká mɛ nkáp kpokorok anɛ básɔ̀t bɛchyɛ ndǔ nkábhɛ́nti.” Bátwɔ́ yi nɛ ɛbhɔkɔ nkáp. ");
INSERT INTO kenNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yesu asɔt akɛ́m awɔ, abhɛ́p bhɔ́ bɛ, “Ntí ághá nɛ́ arɛ? Nɛ nnyɛ́n chi ɛnɛn ághá?” ");
INSERT INTO kenNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bákɛ́mɛ yí bɛ, “Chí ntí Sísa, Mfɔ Rom. Nɛ nnyɛ́n, chi ɛni.” Yesu aghati yɛ bhɔ bɛ, “Chiɛ́ yɛ́ ka mfɔ Rom yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ ɛchi ɛyi, mǎnchyɛ Mandɛm yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ ɛchi ɛnɛ Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Bághókó nɔ́kɔ́ ɛnyɨŋ ɛnɛ Yesu arɛmɛ, bápɔ́p! Bárɔ́ yi, barɔk ɛbhak ɛyap. ");
INSERT INTO kenNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nkúbhɛ́ nywɔp ɛnɔ, mbɔk bǒnkwɔ Sádusi bárɔ́k ntá Yesu bɛbhɛp yi ɛnyɨŋ ndu bɛkʉ yi ánkwɛ́n anyu. Bǒnkwɔ Sádusi babhɨkɨ noko nyaka bɛ ɛwak ɛ́mɔt bawú bápɛtnsɛm ndǔ nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Bábhɛ́p Yesu bɛ, “Ntɔŋ, Moses asɨŋ ndǔ ɛbhé ɛyɛsɛ bɛ, mbák mmu ángú ándɔ́ ngɔrɛ́ kɛ bɔ́ kɛbhɔŋ yɛ̌ mmɔ́, mɔ́mayi abhɔŋ bɛsɔt ngɔrɛ́ wu bɛ́ ámbé bɔ nɛ yi ndǔ nnyɛ́n manɔ anɛ ágú. ");
INSERT INTO kenNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Bɔ̌ chi amɔt bati tándrámɔt báchí nyaka fá. Anɛ mbɨ abháy ngɔrɛ́, agú ɛnɛ́ yi abhɨkɨ bhɔŋ yɛ̌ mmɔ́. Anɛ ákòŋo yi, asɔt kɛ́nkwɛ́sɛ́ wu ndǔ nɛbhay. ");
INSERT INTO kenNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Yí nkwɔ agú, kɛbhɔŋ mmɔ́ nɛ kɛ́nkwɛ́sɛ́ wu. Ɛ́fákari ɛnyumɔt nɛ anɛ ájwí bati arat, nɛ bɔ̌mayi bachak nkwɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ndǔ ngwɛnti, ngɔrɛ́ wu nkwɔ agú. ");
INSERT INTO kenNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ndu ɛchi nɔ, mpok Mandɛm ákʉ̀ bawú mámpɛ́tnsɛm ndǔ nɛpɛ́m, ngɔrɛ́ wu ǎbhák anɛ agha? Ndu bɔ́ mankɛm, bati tándrámɔt, yɛ̌ntɨkɨ mmu wap abhay nyaka yi.” ");
INSERT INTO kenNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu akɛmɛ bhɔ bɛ, “Bɛkwɛ́nɛ́ bɛ́chí nɛ bhe tontó! Nti achi bɛ bǎbhɨ́kɨ́ rɨŋɨ yɛ̌ chi mɛnyɨŋ ɛbhɛn bɛchi amɛm Ɛkáti Mandɛm nɛ yɛ̌ chi bɛtaŋ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Mpok Mandɛm ákú bawú mámpɛ́tnsɛm ndǔ nɛpɛ́m, bo bábhak mbɔ bɔángɛl awu amfay. Bápú pɛrɛ bhay nɛbhay. ");
INSERT INTO kenNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kɛ mbák mǎmàkati bɛ bawú bapu kway bɛpɛtnsɛm ndǔ nɛpɛ́m, nɔ bǎrɛm bɛ bǎbhɨ́kɨ́ re pay ndǔ Ɛkáti Mandɛm ɛnyɨŋ ɛnɛ yi ágháti bhe? Ɛ́chí amɛm ɛkáti bɛ́ Mandɛm arɛm bɛ, ");
INSERT INTO kenNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Mɛ nchí Mandɛm Ábraham, Mandɛm Áisek, nɛ Mandɛm Jekɔ́p!’ Mandɛm achí Mandɛm bo abhɛn bachi nɛpɛ́m. Apú Mandɛm bawú.” ");
INSERT INTO kenNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Bɛyǎ bo abhɛn báchí nyaka arɛ bághókó nɔ́kɔ́ ɛnyɨŋ ɛnɛ Yesu árɛ́mɛ́, manyu áchók bhɔ, bɛ́yɨ́ŋɨ ɛnyǔ nɛtɔ́ŋ ɛnɛn Yesu átɔ̀ŋ. ");
INSERT INTO kenNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Bǒnkwɔ Fárisi bághók bɛ ɛnyɨŋ ɛnɛ Yesu ághátí bǒnkwɔ Sádusi ɛ́kʉ́ manyu áchók bhɔ. Báté ɛyu, báyáŋ ɛnyɨŋ ɛ́chák ɛnɛ bábhɛp Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Mmǔ wap amɔt anɛ áchí ɛsáyrí ntɔŋ ɛbhé Moses arɔk mɛmɔ Yesu. Abhɛ́p yi bɛ, ");
INSERT INTO kenNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ntɔŋ, ɛbhé ɛnɛ ɛ́chá bɛbhé Moses bɛ́chák chi ɛ́nɛ́?” ");
INSERT INTO kenNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu akɛmɛ yi bɛ, chí ɛbhé ɛnɛ ɛ́rɛ̀m bɛ, “‘Kɔŋ Mandɛm Acha ywɛ nɛ ntɨ ɛnɛ nɛnkɛm, nɛ ɛfóŋó yɛ ɛnkɛm, nɛ nkaysi yɛ nkɛm’. ");
INSERT INTO kenNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ɛnɛ́ kɛ ɛchi ɛbhé mbɨ, nɛ yɔ́ kɛ ɛ́chá bɛchak mɛnkɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ɛnɛ́ ɛ́jwí bɛpay ɛ́chi mbɔ ɛnɛ́, nɛ ɛ́rɛ̀m bɛ, ‘Kɔ́ŋ ntɨ nkwǎ mbɔ ɛnyu ɔ́kɔ́ŋɔ́ mmʉɛt ɛyɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Bɛbhé ɛbhɛn bɛpay bɛ́kútí yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ Mandɛm áyàŋ bo mándɨ́ŋɨ́, mbɔ ɛnyǔ ɛchi ndǔ mɛnyɨŋ mɛnkɛm ɛbhɛn Moses ásɨ́ŋɨ́, nɛ ɛbhɛn barɛmɛ́ kɛpɨ̌ntɨ Mandɛm básɨ́ŋɨ́.” ");
INSERT INTO kenNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ɛnɛ́ bǒnkwɔ Fárisi babhʉɛt ɛbhak ɛ́mɔt nɛ Yesu, yi abhɛ́p bhɔ bɛ, ");
INSERT INTO kenNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ndǔ nkaysi yɛka, Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò abhɔŋ bɛbhak mmɔ̌ agha?” Bákɛ́mɛ Yesu bɛ, “Abhɔŋ bɛbhak ɛbhárɛ́mɔ Debhít.” ");
INSERT INTO kenNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu arɛm bɛ, “Ná ɛchi yɛ bɛ Ɛfóŋó Mandɛm ákʉ nyaka Mfɔ Debhít ambɨŋɨ yi bɛ ‘Acha?’ Mfɔ Debhít arɛm nyaka bɛ, ");
INSERT INTO kenNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Mandɛm Acha arɛm nyaka ntá Acha wa bɛ, chɔkɔ fá ɛbhě awɔ́nɛm ɛya ndǔ ɛnɔkɔ-kɛnókó, kpatɛ nkʉ bǒmpap abhɛ mándɔp mbɔ ɛnɔk ɛnɛ ɔ́nyàŋa chɔŋ bɛkak arɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Yesu abhɛ́p yɛ bhɔ bɛ, mbák Mfɔ Debhít ǎbhɨ̀ŋɨ nyaka Mpɛmɛ́ rɛ́ bɛ Acha. Ná Achǎ-rɛ áyibhiri ambak ɛbhárɛ́mɔ ywi?” ");
INSERT INTO kenNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yɛ̌ mmu kɛkway bɛkɛmɛ Yesu ɛnyɨŋ ɛnɛ yi ábhɛ́bhɛ́ bǒnkwɔ Fárisi. Nɛ bɛ́bhó mpok ɛyɔ, yɛ̌ mmu kɛpɛrɛ mɔ bɛbhɛp yi yɛ̌nyɨŋ. ");
INSERT INTO kenNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ɛ́bhɨ́kɨ́ tat, Yesu abho bɛghati bakoŋo bhi nɛ bɛyǎ bo abhɛn bachi ɛbhak ɛ́mɔt nɛ yi bɛ, ");
INSERT INTO kenNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Batɔŋ-ɛbhé Mandɛm nɛ bǒnkwɔ Fárisi kɛ bábhɔ́ŋɔ́ bɛtaŋ bɛghati bho mbɔ̌ŋ mɛnyɨŋ ɛbhɛn bɛ́chí amɛm bɛkáti ɛbhɛn Moses asɨ́ŋɨ́. ");
INSERT INTO kenNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Bǎbhɔŋ yɛ bɛkoŋo chi mɛnyɨŋ ɛbhɛn bɔ bárɛ̀m, bǎkɛ́ kʉ mɛnyɨŋ ɛbhɛn bɔ́ bákʉ̀. Nchí rɛm nɔ mbɔnyunɛ bɔ́ babhɔŋ bápú kʉ mɛnyɨŋ ɛbhɛn bɔ́ bághàti bho wáwák. ");
INSERT INTO kenNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bábày bho mɛnwɔ́ptí batu anti bɛ mámpɔ́kɔ́, ndǔ bɛyǎ bɛbhé ɛbhɛn bɔ báfyɛ̀, kɛ bɔ́ babhɔŋ bápú kwak bo mámbʉ́rɛ́ bɛbhé bhɔ yɛ̌ mandú. ");
INSERT INTO kenNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Bákʉ̀ yɛ̌ntɨkɨ ɛnyɨŋ ɛyap chi ndu bɛtɔŋ mmʉɛt. Ɛnyɨŋ ɛ́mɔt ɛchi bɛ, yɛ̌ntɨkɨ mmu wap ǎsɔt Ɛyɔŋ Mandɛm ansɨ́ŋ amfyɛ amɛm bɔ̌mɛnyɨŋ mbɔ nchóŋ ambat nɛfó purɛ́ɛ́, angwɔ́t ɛ́chák ndǔ ɛrɛbháwɔ, kɛ́mbyáká bɛjɛnjɛ̌mɛ́ ndɛn ɛyap nkwɔ bɛ́sàpti mɛ́ncha ɛnyu bɛ́bhɔ́ŋɔ́ bɛbhak. ");
INSERT INTO kenNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bákɔŋ nkwɔ́ bɛ́chɔkɔ ndǔ bɛbhaká kɛnókó amɛm bɛkɛrɛ́ nɛnɨkɨ́mʉɛt nɛ ndǔ bɛpa. ");
INSERT INTO kenNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Bákɔŋ nkwɔ bɛ bo mánkaka nɔ́kɔ́ bhɔ nɛfísiɛ nɛ kɛnókó. Nɛ bákɔŋ bɛ bo mambɨŋɨ nɔkɔ bhɔ bɛ, ‘Ntɔŋ’. ");
INSERT INTO kenNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Yɛ̌ mmu ywɛka ákɛ́ ka mámbɨ́ŋɨ́ yi bɛ, ‘Ntɔŋ! Bǎbhɔŋ chi ntɔŋ amɔt, nɛ be mankɛm bǎchi chi batɨ bǒnkwɔ.’ ");
INSERT INTO kenNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nɛ bǎkɛ́ bhɨŋɨ ntɨ mǔnkwɔ bɛ, ‘Ɛta mbɔnyunɛ bǎbhɔŋ chí chi amɔt, yí mmú áchí amfay.’ ");
INSERT INTO kenNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nɛ mmu ywɛka ákɛ́ ka batɨ mámbɨ́ŋɨ́ yi bɛ, ‘Ntɔŋ’ mbɔnyunɛ bǎbhɔŋ chi amɔt, Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò. ");
INSERT INTO kenNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mmu anɛ áchá báchák abhɔŋ bɛbhak mǔbɛtok ywɛka. ");
INSERT INTO kenNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Yɛ̌ agha anɛ áyòŋ mmʉɛt, Mandɛm ǎsɛpti yi amɨk, nɛ yɛ̌ agha anɛ ásɛ̀pti mmʉɛt amɨk, Mandɛm ǎkosi yi amfay.” ");
INSERT INTO kenNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Yesu abho yɛ bɛrɛm ntá batɔŋ ɛbhé Moses nɛ bǒnkwɔ Fárisi bɛ, “Bě batɔŋ ɛbhé Moses, nɛ be bǒnkwɔ Fárisi, bo bɛtábhá! Chɔŋ ɛ́mbɛp ntá yɛka ɛncha mbɔnyunɛ bǎchyɛ̀t bo mbǐnywɔp bɛ bákɛ́ rɔ Mandɛm ambak Mfɔ wap. Bě babhɔŋ bǎpú ka Mandɛm ambak Mfɔ ywɛká, nɛ bǎchyɛ̀t mbi ntá abhɛn bákway bɛyaŋ bɛchwe arɛ! ");
INSERT INTO kenNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Bě batɔŋ ɛbhé Moses, nɛ be bǒnkwɔ Fárisi, bǒ bɛtábhá! Chɔŋ ɛ́mbɛ́p ntá yɛka ɛncha. Bǎsɔt bɛkɛt mánkwɛ́sɛ́, mǎnkʉ nɔkɔ bɛrɔ́rí nɛnɨkɨ́mʉɛt, bɛrwɔ bho bɛ bǎchi bɛsayri bo Mandɛm. Ɛ̌ti yɔ, chɔŋ ntɛ́msí yɛka ancha anɛ bo bachak. ");
INSERT INTO kenNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Bě batɔŋ ɛbhé Moses, nɛ be bǒnkwɔ Fárisi, bǒ bɛtábhá! Chɔŋ ɛ́mbɛ́p ntá yɛka ɛncha. Bǎkway bɛkɔ mǎnkɨŋɨ bɔmanyu mǎndɔk mbaŋ nɛ mbaŋ mɛ́nú bɛyaŋ yɛ̌ chí mmu amɔt bɛ ámbák mǔnkwɔ ywɛka. Kɛ mpok yi ayibhiri arɔbhɛ mbɔ bhe, nkúbhɛ́ bé kɛ̌ bǎkʉ yi ámbɛ́p ancha be babhɔŋ ndɔŋ ɛpay, ambak mmǔ anɛ árɔ̀ŋ ndǔ nɛpǐngo. ");
INSERT INTO kenNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Bě manɛ́mámɨk abhɛn bǎyà bho mbi, chɔŋ ɛ́mbɛ́p ntá yɛka ɛncha! Bě bǎrɛ̀m bɛ, ‘Mbák mmu ámfyɛ́ bariɛp nɛ Mandɛm bɛkʉ ɛnyɨŋ, anjɨkɨ ndǔ nnyɛ́n ɛkɛrákap Mandɛm bɛtɔŋ bɛ yi abhɔŋ bɛkʉ ɛnyɨŋ ɛyɔ, kɛ yi kɛkʉ yɔ, yɛ̌ ɛsɔŋɔri ɛpu bhak.’ Nɛ bɛ, ‘Mbák mmu ánjɨ́kɨ́ ambɨŋɨ bɛrɨ́tí mɛnyɨŋ ɛbhɛn bɛchi amɛm ɛkɛrákap Mandɛm, abhɔŋ bɛ́bhʉrɛ bariɛp ami.’ ");
INSERT INTO kenNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Bě bɛchɨŋtǐ manɛ́mámɨk! Ɛkɛrákap Mandɛm kɛ̌ ɛ́chá mɛnyɨŋ gol, kɛ mɛnyɨŋ gol kɛ bɛcha ɛkɛrákap ɛnɛ ɛkʉ́ mɛnyɨŋ gol mɛ́mbak nyáŋá? ");
INSERT INTO kenNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nɛ bǎrɛ̀m bɛ mbák mmu ámfyɛ́ bariɛp nɛ Mandɛm bɛkʉ ɛnyɨŋ, anjɨkɨ ambɨŋɨ nnyɛ́n ɛ́fɛ́mɛ́ akap Mandɛm bɛtɔŋ bɛ abhɔŋ bɛkʉ ɛnyɨŋ ɛyɔ kɛ yi kɛkʉ yɔ, yɛ̌ ɛsɔŋɔri ɛ́pú bhak. Bǎrɛm nkwɔ́ bɛ Mbák mmu ánjɨ́kɨ́ ndǔ nnyɛ́n mɛnyɨŋ ɛbhɛn bábhʉ́rɛ́ ndǔ ɛ́fɛ́mɛ́ bɛchyɛ akap ntá Mandɛm, abhɔŋ bɛ́bhʉrɛ bariɛp ami. ");
INSERT INTO kenNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Bě manɛ́mámɨk! Bɛsí Mandɛm, ɛ́fɛ́mɛ́ akap Mandɛm kɛ̌ ɛcha mɛnyɨŋ ɛbhɛn bábhʉrɛ arɛ́ ndu bɛchyɛ akap, kɛ mɛnyɨŋ ɛbhɔ kɛ bɛcha ɛ́fɛ́mɛ́ akap Mandɛm? Pú ɛ́fɛ́mɛ́ yɔ kɛ̌ ɛ́kʉ̀ ɛnyɨŋ ɛnɛ bábhʉ́rɛ́ arɛ ɛmbak nyáŋá? ");
INSERT INTO kenNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ndu ɛ́chí nɔ́, mmu anɛ árɛ̀m ndak, anjɨkɨ ambɨŋɨ nnyɛ́n ɛ́fɛ́mɛ́ akap Mandɛm, abhɔŋ bɛrɨŋɨ bɛ, ayɨ́kɨ́ nɔ nkwɔ ndǔ nnyɛ́n yɛ̌ntɨkɨ akap anɛ achi ndǔ ɛ́fɛ́mɛ́ yɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nɛ mmu anɛ árɛ̀m ɛnyɨŋ, anjɨkɨ ambɨŋɨ nnyɛ́n ɛkɛrákap Mandɛm, abhɔŋ bɛrɨŋɨ bɛ, ayɨ́kɨ́ nɔ́ nkwɔ chi ndǔ nnyɛ́n Mandɛm mmu achi amɛm ɛkɛrákap, ");
INSERT INTO kenNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","nɛ mmu anɛ árɛ̀m ɛnyɨŋ anjɨkɨ, ambɨŋɨ mfay, abhɔŋ bɛrɨŋɨ bɛ ǎyɨkɨ nɔ chi ɛnɔkɔ́ kɛfɔ Mandɛm nɛ Mandɛm mmu áchɔ̀kɔ arɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Yesu arɔk ambɨ bɛrɛm bɛ, “Bě batɔŋ ɛbhé Moses, nɛ bě bǒnkwɔ Fárisi, bǒ bɛtábhá, chɔŋ ɛ́mbɛ́p ntá yɛka ɛncha! Bǎsɔt ndu bɛ́rɨ amɔt ndǔ baru byo mǎnchyɛ ntá Mandɛm, mǎnkʉ ɛnyumɔt nɛ mbwɔ́t achak, kɛ bǎpú fyɛ́ ntí bɛbhak chak nɛ bo mankɛm, bǎpú fyɛ́ ntí bɛghɔ bho ntínso, nɛ bǎpú fyɛ́ ntí bɛbhak tɛtɛp nɛ bo mankɛm. Ɛ́rɨ bɛkʉ mɛnyɨŋ ɛbhɛn ɛcha bɛkɔrɛ mɛnyɨŋ baru byo, mǎnchyɛ ndu amɔt ntá Mandɛm. Ɛ́rɨ nyaka bɛ mǎnkóŋó ɛbhé ɛnɛ bɛkɔrɛ mɛnyɨŋ ndǔ baru byo mǎnchyɛ ndu amɔt ntá Mandɛm, kɛ bǎbhɨkɨ bhɔŋ nyaka bɛghɔkɔntɨk bɛbhé bɛ́chák. ");
INSERT INTO kenNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Bě manɛ́mámɨk abhɛn bǎyà bho mbi, bǎsɔt mpok bɛ́fɛ́rɛ yɛ̌ntɨkɨ mɔ́nya anɛ áchí amɛm ɛnyɨŋ ɛnɛ mǎnyú, kɛ mpɔŋɔ baso mǎmɛnɛmɛ́n ham. ");
INSERT INTO kenNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Bě batɔŋ ɛbhé Moses, nɛ be bǒnkwɔ Fárisi, bǒ bɛtábhá, chɔŋ ɛ́mbɛp ntá yɛka ɛncha! Chɔŋ ɛ́mbɛp ntá yɛka ɛncha mbɔnyunɛ bǎsɔ̀t mpok bɛ́tyɛt nsɛm-ámok nɛ nsɛmɛ́ nchán, kɛ batɨ yɛka ájwí nɛ bɛpɔ̌ nkaysi ndǔ bǎsɔt mɛnyɨŋ bho nɛ bɛtaŋ, nɛ ndǔ bǎchi bo batɨ rakáraka. ");
INSERT INTO kenNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Bě Nkwɔ Fárisi, manɛ́mámɨk! Ya ká mbɨ sǒ mmɛm ámók nɛ mmɛm nchán. Mbák mǎnkʉ nɔ, chɔŋ nsɛm-ámok nɛ nsɛmɛ́ nchán ɛ́ndyɛrɛ pɛ́pɛ̌pɛ́p nkwɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Bě batɔŋ ɛbhé Moses, nɛ be bǒnkwɔ Fárisi, bǒ bɛtábhá! Chɔŋ ɛ́mbɛ́p ntá yɛka ɛncha mbɔnyunɛ, bǎchí mbɔ manɛm anɛ bághókó sayri, bawati nɛ mbɨ pɛ́pɛ́p, ɛnyu ɛnɛ mmu ághɔ̀, ankɔŋ, yɛ̌ndu bɛrɛnɛ́ bawú ɛbhɛn mɛ́náŋ bɛ́chɔ́ŋɔ́ nɛ bɛghɛp kɛ bɛchi amɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ɛnyu yɔ kɛ̌ bǎchi. Mmu ǎghɔ be ankaysi bɛ bǎchi chak nɛ bho, kɛ batɨ yɛka ájwí amɛm nɛ bapu nɛ bɛbʉ́.” ");
INSERT INTO kenNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Yesu arɔk ambɨ bɛrɛm bɛ, “Bě batɔŋ ɛbhé Moses, nɛ be bǒnkwɔ Fárisi, bǒ bɛtábhá, chɔŋ ɛ́mbɛ́p ntá yɛka ɛncha! Bachǐmbɨ bhɛka baway nyaka barɛmɛ́ kɛpɨ̌ntɨ nɛ bo abhɛn bachi chak bɛsí Mandɛm. Bǎtè manɛm ayap nɛ́nɛ, mǎngwati nɔkɔ mbɨ arɛ́ bɛkʉ yɔ ándɨ́ amɨ́k. ");
INSERT INTO kenNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Bǎkʉ̀ mɛnyɨŋ ɛbhɛn mǎndɛmɛ nɔkɔ bɛ, ‘Mbɔ bhɛsɛ sɛchi nyaka mpok bachǐmbɨ bhɛsɛ, mbʉ́ sɛ́bhɨ́kɨ́ ka nɛ bhɔ bɛ mángwáy barɛmɛ́ kɛpɨ̌ntɨ Mandɛm Acha.’ ");
INSERT INTO kenNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nɛrɛm anɛ bárɛ̀m nɔ ǎtɔŋ bɛ bě bǎbhɔŋ bárɛ̀m nɛ manyu yɛka bɛ bǎchi ɛnyumɔt mbɔ bachǐmbɨ bhɛka abhɛn báwáy nyaka barɛmɛ́ kɛpɨ̌ntɨ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Dɔ́k yɛ́ ka ambɨ mǎnáŋá bɛtɨk ɛbhɛn bachǐmbɨ bhɛka bábhó. ");
INSERT INTO kenNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Bě nnyɔ́ ɛnɛ! Bě bho bǎbɛbhɛ bǎchá mbɔ̌ŋ bɛfé! Bǎkáysí bɛ́ bǎkway bɛbhɔŋ mbi bɛbʉɛ bɛ Mandɛm akɛ tɛmsi bhe amɛm nɛpǐngo? ");
INSERT INTO kenNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ghók yɛ́ ka, nchí to be baghatǐ Ɛyɔŋ Mandɛm nɛ yɛ̌ntɨkɨ mmu anɛ áchí ndɨŋɨndak ndu ákòŋo Ɛyɔŋ Mandɛm. Chɔŋ ntó be bátɔ̀ŋ-Ɛyɔŋ Mandɛm nkwɔ́. Chɔŋ mǎngwáy mbɔk ɛyap, mǎngo báchák ndǔ bɛkotakati, nɛ mǎndɛn abhɛ́nɛ́fú nɛ bɛkpa amɛm bɛkɛrɛ́ nɛnɨkɨ́mʉɛt ɛbhɛka, mǎnkoŋo nɔkɔ bɔ́ bɛtɔk nɛ bɛtɔk ndu bɛkɛm bhɔ bɛway. ");
INSERT INTO kenNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Chɔŋ ɛyɔ ɛnkʉ bɛ manoŋ yɛ̌ntɨkɨ mmu anɛ achi chak anɛ bo báwáy, ámbák be anti, bɛ́bho nɛ manoŋ Ábɛl mmu achí nyaka chak bɛsí Mandɛm, bɛghaka ndǔ manoŋ Sakaría mmɔ̌ Barákia, mmu bǎwáy nyaka nɛntɨ ɛkɛrákap Mandɛm nɛ nɛbhʉɛt anɛ báchyɛ̀ akap arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nchí ghati bhe bɛ, chɔŋ Mandɛm antɛmsi be bho mkpák anɛ ɛchɔŋ mankɛm ɛ̌ti bɛbɛ́ptí mɛnyɨŋ ɛbhɛn bě nɛ bachǐmbɨ bhɛka bǎkʉ́.” ");
INSERT INTO kenNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yesu akók arɛm bɛ, “Eé Yerúsalɛm, bǒ Yerusalɛm! Bě bo bǎwày barɛmɛ́ kɛpɨ̌ntɨ Mandɛm, mǎntɛmti nɔkɔ nɛ batay ndu bɛway bo Mandɛm átó bɛ mángátí bhe Ɛyɔŋ ɛyi. Ndǔ bɛyǎ mpok, njáŋ bɛsɔt bhe mfyɛ́ amʉɛt bɛ́ mǎmbak nɛ mɛ mbɔ bɔ̌nkɔk abhɛn nnɔ nkɔk ákútí nɛbhʉɛt amɔt nɛ bɛbhap ɛbhi, kɛ bǎpú ka bɛ nkʉ nɔ! ");
INSERT INTO kenNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nɛ nɛ́nɛ, chɔŋ Mandɛm andɔ ɛkɛt ɛyɛka, ɛ́ndɔp ɛnyu yɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nɛ dɨŋɨ́ ká bɛ, bǎpú pɛrɛ ghɔ́ chɔŋ mɛ wáwák kpatɛ mpok anɛ bǎrɛ̀m bɛ, ‘Sɛ́mbɨ́tí mmu anɛ átwɔ̀ ndǔ nnyɛ́n Mandɛm Acha.’” ");
INSERT INTO kenNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Mpok Yesu árɔ́ ɛkɛrákap Mandɛm árɔ̀ŋ, baghɔkɔ́ bhi bábhɨ́ŋɨ yi, mándɛmɛ nɔkɔ bɛ yi ángɔ́ ndǔ ɛkɛt ɛyɔ ɛrɨ ɛcha! ");
INSERT INTO kenNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Kɛ akɛmɛ bhɔ bɛ, “Pú bǎghɔ̌ mɛnyɨŋ mɛnkɛm ɛbhɛn básɔ́rɛ́ báté bɛkɛt ɛbhɛn bɛchi ndǔ ɛkɛrákap kɛ ɛ́bhak ɛnyunɛ? Nchí ghati bhe bɛ, mpok ǎtwɔ̀ anɛ ɛkɛt ɛnɛ ɛ́rɔ̀ŋ amɨk ɛnkɛm, yɛ̌nyɨŋ kɛrɔp téé.” ");
INSERT INTO kenNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ɛnɛ́ Yesu achi chɔ́kɔ́ ambɨ Njiɛ Mɛnɔk Ólif. Bakoŋo bhi bárɔ́k ntá yi. Yɛ̌ mmu achak kɛbhak nɛ bhɔ. Bárɛ́m bɛ, “Ɛta, ghati bhɛsɛ, chɔŋ ɛ́mfakari nɔ ntɨkɨ mpok, nɛ ntɨkɨ ɛrɨŋ ɛ́bhɔ́ŋɔ́ bɛkʉ bo mándɨŋɨ bɛ mpok anɛ ɔ́twɔ̀ arɔp kɛ́kwɔ́t, nɛ bɛ́ mandú mpok mmɨk ǎmay?” ");
INSERT INTO kenNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu akɛmɛ bhɔ bɛ, “Sɔt ka mpok bɛ́ yɛ̌ mmu ákɛ́ rwɔ́ bhe! ");
INSERT INTO kenNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bɛyǎ bo bátwɔ̀ chɔŋ mánsɔt nnyɛ́n ɛna mántɛn ambɨ, yɛ̌ntɨkɨ mmu wap andɛm nɔkɔ bɛ ‘Yi kɛ achi Mpɛmɛ anɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtó!’ Nɛ mándwɔ bɛyǎ bhó bɛ mánjibhiri batɨ yap. ");
INSERT INTO kenNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Chɔŋ mǎngók nsóŋó nɛnu, mǎngok mbok ɛ̌ti manu anɛ achi nɛkɔ nɛsiɛ nɛ anɛ átwɔ̀ ansɛm. Kɛ bǎkɛ́ chay. Mɛnyǔ mɛnyɨŋ ɛbhɔ bɛ́bhɔŋ bɛfakari, kɛ ɛyɔ ɛpu tɔŋ bɛ ngwɛnti mmɨk aghaka. ");
INSERT INTO kenNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Chɔŋ bɛtɔk mɛ́nu nɛ bɛtɔk bɛ́chák, bafɔ̌ ɛtɔk mánu nɛ batɨ̌ bafɔ̌ ɛtɔk. Chɔŋ nsay ankwɛ́n mbaŋ nɛ mbaŋ, mmɨk anyɨkɨsi ndǔ bɛtɔk nɛ bɛtɔk. ");
INSERT INTO kenNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kɛ mɛnyɨŋ ɛbhɛn mɛnkɛm bɛchi chi mbɔ nɛbhǒnɛt ɛnɛn bɛbe ntá ngɔrɛ́ anɛ ánòŋsi. ");
INSERT INTO kenNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Mpok mɛnyɨŋ ɛbhɛn bɛ́fàkari, chɔŋ mánkɛm be mámfyɛ amɔ́ bǒbati ɛtɔk bɛ mányok bhe sayri, mángwáy bhe. Nɛ chɔŋ bǒ bɛtɔkɔ́ mmɨk mankɛm mámpap bhe ɛ̌ti bǎchí bakoŋo bha. ");
INSERT INTO kenNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nɛ mpok yɔ, chɔŋ bɛyǎ bakoŋo bha mánkɛmɛ mmʉɛt ansɛm, mánti nɔkɔ batɨ ntá bǒbati ɛtɔk, nɛ mámpabhɛ nɔkɔ batɨ. ");
INSERT INTO kenNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mpok yɔ, bɛyǎ bo báfù, mándɛmɛ nɔkɔ bɛ báchí baghatǐ Ɛyɔŋ Mandɛm, ɛnɛ́ bárùɔ bho rwɔ́ bɛ mankoŋo bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Chɔŋ bɛbɛ́ptí mɛnyɨŋ ɛbhɛn bo bákʉ̀ mɛ́nja kpát bo kɛpɛrɛ kɔŋ batɨ. ");
INSERT INTO kenNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kɛ mmǔ anɛ átè kákátí tɛ ndǔ ngwɛnti, Mandɛm ǎpɛmɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nɛ bo bábhɔŋ bɛghati Mbok Ndɨ́ndɨ́ nɛ ɛ̌ti Kɛfɔ Mandɛm ndǔ bɛtɔkɔ́ mmɨk mɛnkɛm, bɛ́ amɛm yɛ̌ntɨkɨ ɛtɔk bo mámbɔ́ŋ mbi bɛghok yɔ, kɛ Mandɛm ankʉ ngwɛnti mmɨk antwɔ́.” ");
INSERT INTO kenNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Chɔŋ mǎngɔ ‘Ɛrɛm ɛnyɨŋ ɛnɛ Mandɛm ápábhɛ́’ téé amɛm Ɛkɛrɛ́ Mandɛm ndu ɛ́nyɔ̀p yɔ mbɔ ɛnyǔ Daniɛl ndɛmɛkɛpɨ̌ntɨ Mandɛm árɛ́mɛ́ tɛsáy bɛ chɔŋ ɛ́mfakari.” Yɛ̌ntɨkɨ mmu anɛ ápay ɛkáti ɛnɛ́ ámfyɛ anti, anjwimɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Mpok yɔ, bǒ abhɛn bachi atú Judɛ́ya mámbʉ́ɛ́, mámbɛ́sɛ́ amfǎy njiɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mpok yɔ, mbák ɛ́fákárí bɛ́ mmu ǎkʉ bɛtɨk amfǎy ɛkɛt ɛyi, ákɛ́ sɔŋɔri mmʉɛt bɛsɛp kpɨk bɛ andɔk amfɛrɛ mɛnyɨŋ anywɔ́p kɛ ambʉɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nɛ mmu anɛ achi ɛbhɨ ákʉ̀ bɛtɨk, ákɛ́ rɔ́ŋ kpɨ́k bɛbuɔp ndɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nɛ chɔŋ ɛ́mbɛ́p ɛncha ntá baghɔrɛ́ abhɛn báchi nɛ mɛniɛ nɛ abhɛn báchí nɛ bɔ amɔ mpok yɔ! ");
INSERT INTO kenNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nɨk nɔ́kɔ́ ka mmʉɛt bɛ mpok bɛbʉɛ ákɛ́ kwɛn yɛ̌ chi mpok mbaŋ ǎkwɛn chaɛɛ, nɛ yɛ̌ chi ndǔ nywɔbhɛ́ nɛywěmʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Bǎkɛ rɔ mɛnɨkmʉɛt, mbɔnyunɛ ɛsɔŋɔri ɛnɛ́ bo bábhɔ̀ŋ mpok yɔ chi ɛnyǔ ɛsɔŋɔri ɛnɛ bábhɨ́kɨ́ re ghɔ wáwák tɛ nɛbhǒmɨk. Nɛ mpok yɔ ánáŋ ámfʉɛ́t, ɛnyǔ ɛsɔŋɔri yɔ ɛpu pɛrɛ bhák wáwák. ");
INSERT INTO kenNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nɛ mbɔ Mandɛm abhɨ́kɨ́ kpɔt manywɔp yɔ bɛ akɛ ya, mbʉ yɛ nkwǎŋwaŋ amɔt apu rɔp nɛpɛ́m. Kɛ Mandɛm akpɔt mpok ɛsɔŋɔri yɔ mbɨŋ ɛ̌ti bo abhɛn yi áyábhɛ́ bɛ mambak abhi. ");
INSERT INTO kenNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Mpok yɔ, mbák mmu ángátí bhe bɛ, ‘Ghɔ́ ká Mpɛmɛ anɛ Mandɛm átó fá’, yɛ̌ chi bɛ, ‘Ghɔ́ yi awu!’ Bǎkɛ́ noko bɛ ɛchi tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Bǎkɛ́ noko bɛ́ ɛ́chí tɛtɛp mbɔnyunɛ chɔŋ bǒ bɛtábhá mantwɔ, yɛ̌ntɨkɨ mmu wap andɛm nɔkɔ bɛ yi kɛ achi Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎto. Chɔŋ barɛmɛ́ kɛpɨ̌ntɨ nsé nkwɔ mantwɔ. Nɛ yɛ̌ntɨkɨ mmu wap ǎtwɔ, ankʉ nɔkɔ bɛrɛmɛ mɛnyɨŋɨ́ maknkay ndu bɛrwɔ bho. Nɛ mándwɔ́ yɛ̌ chí bǒ abhɛn Mandɛm áyábhɛ́ bɛ mámbák abhi, mbák bábhɔŋ mbi bɛkʉ nɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Sɔt yɛ ka mpok! Nnáŋ ngati nɔ bhe mɛnyɨŋ ɛbhɛn ambɨ ambɨ. ");
INSERT INTO kenNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ndǔ ɛchi nɔ, mbák yɛ̌ mmu angati bhe bɛ, ‘Yɨŋɨ́ ka Kristo awu amɛm baso’, bǎkɛ́ noko mǎmfá bɛrɔŋ arɛ. Yɛ̌ mmu andɛm chi bɛ, ‘Yɨŋɨ́ ká Kristo fá amɛm mɔ́kɛt’ bǎkɛ́ noko ɛnyɨŋ ɛnɛ yi árɛ̀m. ");
INSERT INTO kenNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bǎkɛ́ rɔ mmu ándwɔ́ bhe mbɔnyunɛ, mbɔ ɛnyǔ miámiaŋ ákɔ̀t, angɔɔ, bɛfu ɛbhɔ́kɔ́ nɛbu ɛ́mɔt bɛghaka ɛchak, nɔ́ kɛ̌ ɛ́bhɔ́ŋɔ́ bɛbhak mpok Mɛ Mmu mfú ntá Mandɛm nchí twɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Nɛbhʉɛt anɛ ɛgú-nnya ɛchi, arɛ́ kɛ̌ kɛnɛn ɛkɛ́n kɛ́nyìɛ bɛgú nnya kɛ́chɛmti. ");
INSERT INTO kenNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Mbák manywɔp anɛ bɛyǎ ɛsɔŋɔri yɔ ámay, mmok ánɛm tɛ́mté, ntaŋ kɛpɛrɛ ghɔɔ, mambe ámfu amfay ánkwɛnti, nɛ bɛtaŋ mfáy mɛnyɨkɨsi. ");
INSERT INTO kenNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Mpok yɔ kɛ̌ ɛrɨŋ ɛnɛ́ ɛ́tɔ̀ŋ bɛ Mɛ Mmǔ mfú ntá Mandɛm nchí twɔ ɛ́bhesi yɛ amfay, nɛ bǒ yɛ̌ntɨkɨ nnɛrɛ́kɛt fá amɨk mámbo mɛ́miak nɛ amɔ mámbɨkɨ nɔkɔ ndǔ kɛbhɔ áyɔ́mɛ. Nɛ mángɔ nɔkɔ ndǔ Mɛ Mmu mfú ntá Mandɛm nchí sɛp nchí twɔ amɛm nɛbháŋ ɛnɛn mfay nɛ bɛtaŋ, mbaŋ ɛ́nkɛm ɛ́ngɔ nɔkɔ nɛ bɛdiɛ́rɛ́ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nɛ ɛrɛm ɛyɔŋɔ́ mmba ɛ́nkwɛn. Chɔŋ ntó bɔángɛl abha ndǔ mmɨk nkɛm, mánsɔt bo abhɛn Mandɛm áyábhɛ́, bɛbho ndǔ ɛbhɔ́kɔ́mɨk ɛ́mɔt bɛghaka ndu ɛchak, mánchɛm nɛbhʉɛt amɔt. ");
INSERT INTO kenNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ghɔ́k ká ɛnyɨŋ ɛnɛ ɛnɔkárɛm ɛnɛ bábhɨŋɨ bɛ́ ‘Fig’ ɛ́tɔ̀ŋ bhɛsɛ. Ɛ́náŋ ɛ́mbó bɛtɛm bɛtɔ́, bǎrɨŋɨ bɛ́ ɛso ɛ́rɔp chi kɛkwɔt. ");
INSERT INTO kenNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ɛ́chí ɛnyumɔt nɛ nɛtwɔ wa, Mɛ Mmu mfú ntá Mandɛm. Mǎnáŋ mǎngɔ ndǔ mɛnyɨŋ ɛbhɛn mɛnkɛm nɛ ngátí bhe bɛ́fàkari, dɨŋɨ́ ka bɛ mpok nɛtwɔ wa arɔp kɛkwɔt. ");
INSERT INTO kenNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nchí ghati be tɛtɛp bɛ mɛnyɨŋ ɛbhɛn mɛnkɛm bɛ́bhɔŋ bɛfakari, kɛ mkpáká bho abhɛn ɛchɔŋ amfʉɛ́t. ");
INSERT INTO kenNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Chɔŋ mfay amfʉɛt, mmɨk amfʉɛt, kɛ Ɛyɔŋ ɛya ɛ́pú fʉɛt wáwák. ");
INSERT INTO kenNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Kɛ yɛ̌ mmu abhɨkɨ rɨŋɨ mbɔ̌ŋ mpok anɛ mɛnyɨŋ ɛbhɛn bɛ́bhɔ́ŋɔ́ bɛ́fàkari. Bɔangɛl Mandɛm bábhɨ́kɨ́ rɨŋɨ, Yɛ̌ chí Mmɔ Mandɛm abhɨ́kɨ́ rɨŋɨ. Ɛta aywǐntí kɛ̌ arɨŋɨ. ");
INSERT INTO kenNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Mpok anɛ Mɛ Mmu mfú ntá Mandɛm nchí twɔ, mɛnyɨŋ bɛ́bhak mbɔ ɛnyǔ bɛ́chí nyaka mpok Nóa. ");
INSERT INTO kenNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Eghorǐ manyiɛp ɛ́pɛ́rɛ twɔ ndǔ mpok Nóa, bo mányìɛ̀ nyaka mányu nɔkɔ, nɛ mámbay nɔkɔ babhay, nɛ mántoko nɔkɔ bɔ, kpátɛ mpok anɛ Nóa áchwe amɛm ɛrɛmɛ́ áchwí anɛ Mandɛm ághátí nyaka Nóa ángókó. ");
INSERT INTO kenNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Bo bábhɨ́kɨ́ rɨŋɨ nyaka ɛnyɨŋ ɛnɛ ɛ́bhɔ́ŋɔ́ bɛ́fákari, kpátɛ mpok ɛ́ghorǐ manyiɛp ɛ́twɔ. Nɛ mpok ɛ́twɔ ɛ́pɔ́kɔ bɔ mankɛm. Ɛnyu yɔ kɛ̌ nɛtwɔ wa, Mɛ Mmu mfú ntá Mandɛm ábhák chɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mpok yɔ, mbák bǒ bati apay bachi ɛbhɨ bákʉ̀ bɛtɨk, bákway bɛsɔt amɔt mándɔ achak. ");
INSERT INTO kenNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nɛ mbák baghɔrɛ́ bati apay bachi nɛbhʉɛt amɔt bákɔ̀k nchwi, bákway bɛsɔt amɔt mándɔ achák. ");
INSERT INTO kenNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Bák yɛ́ ka pě, mbɔnyunɛ bǎbhɨ́kɨ́ rɨŋɨ nywɔp ɛnɛn Acha yɛka átwɔ̀. ");
INSERT INTO kenNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Bǎbhɔŋ bɛrɨŋɨ bɛ mbák mbɔŋɔ́kɛt arɨ́ŋɨ́ mpok anɛ ngɛ́p átwɔ̀ ɛkɛt ɛyi, apú bhʉɛrɛ kɛnɔ́. Ǎbhak pě, bɛ ngɛ́p akɛ twɔ andak ɛkɛt. ");
INSERT INTO kenNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Bě nkwɔ́ bǎbhɔŋ yɛ bɛbhak pě mpoknkɛm, mbɔnyunɛ, Mɛ Mmu mfú ntá Mandɛm, nchí twɔ́ chí mpok anɛ yɛ̌ mmu apu kway bɛkaysi bɛ mɛ̌twɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ɛ́bhɨ́kɨ́ tat Yesu arɛm bɛ, “Agha yɛ́ áchí mmɔ̌bɛtok tɛtɛp anɛ ábhɔ́ŋɔ́ kɛboŋ nɛ mbɔŋɔ́kɛt ásɨ́kɨ́ntɨ nɛ yí? Chí mmɔ̌bɛtok anɛ mbɔŋɔ́kɛt ákway bɛrɔ ɛkɛt ntá yi, angati yí bɛ ánchyɛ́ nɔ́kɔ́ nɛnyíɛ́ ntá batɨ̌ bɔ̌-bɛtok ndǔ mpok. ");
INSERT INTO kenNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Chɔŋ ɛ́ndɨ ntá mmɔ̌bɛtok wu ɛncha mpok chi-bɛtɨk ywi afu nɛkɔ, apɛtnsɛm, aghɔ́ bɛ́ yi ǎkʉ̀ bɛtɨk ɛbhi sayri. ");
INSERT INTO kenNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Dɨŋɨ́ ká bɛ chi-bɛtɨk apú nɔ́k bɛrɔ yɛ̌ntɨkɨ ɛnyɨŋ ɛyi awɔ́ mmɔ̌bɛtok wu. ");
INSERT INTO kenNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kɛ mbák mmɔ̌bɛtok achi ɛbɛ́ptí mmu, andɛm nɛ mmʉɛt yi bɛ, ‘Mbɨ́kɨ́ kaysi bɛ chɔŋ chi-bɛtɨk awa ampɛtnsɛm ndu nɛkɔ̌ ɛnɛn yi árɔ́ŋɔ́ áyák’, ");
INSERT INTO kenNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ambo bɛdɛn batɨ̌ bɔ̌-bɛtok, anchɛm ɛkakánɛkɔ nɛ manyǔ mmɛ́m, ambo mɛnyiɛ, anyu nɔkɔ nɛ bhɔ, ");
INSERT INTO kenNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","chi-bɛtɨk ywi ǎkway bɛ́twɔ ndǔ nywɔp ɛnɛn yi abhɨkɨ kaysi bɛ yi ǎkway bɛpɛtnsɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nɛ mbák ɛ́mfákárí ɛnyu yɔ, chi-bɛtɨk ǎtɛmsi yi sayri, antɛ́n yi ándɔ́k ámbák nɛ bǒ bɛtábhá, ndǔ nɛbhʉɛ́rɛ́ kɛbhɔ nɛ nɛnyiɛ́ ámɛ́n.” ");
INSERT INTO kenNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesu atɛ́m nɛkay ɛnɛn bɛ, “Nywɔp Mandɛm átwɔ̀ bɛbhak Mfɔ bǒbhi, mɛnyɨŋ bɛ́bhak mbɔ ɛnyǔ ɛchi ndǔ nɛkǎy baghɔsɔ́ŋ bati byo abhɛn básɔ́rɛ́ nyaka bɛrɔ́ŋɔ́ ɛbhap, barɔk bɛtɛmɛri mbǎyngɔrɛ́ amɔt. ");
INSERT INTO kenNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bati atay bábhɔ́ŋ kɛ́ŋwáŋ, báchák bati atay bábhák ɛchɨŋti. ");
INSERT INTO kenNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Abhɛn ɛchɨŋti bápɔ́kɔ bɛrɔ́ŋɔ́ bhap, kɛ bɔ́ kɛpɔkɔ bawɛt mánkɛ́m amʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Kɛ abhɛn kɛ́ŋwáŋ bápɔ́kɔ́ nɔ́kɔ́ ɛbhap bɛrɔ́ŋɔ́, bápɔ́kɔ mɛnyɨŋ bawɛt nkwɔ bákɛ́m amʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ɛ́fákari bɛ mbǎyngɔrɛ́ anɛ bɔ mankɛm mánòŋ abhɨkɨ twɔ́ áyák. Ɛ́kʉ́ bábhó mɛmɔk kɛnɔ́, kpát bákwɛ́n kɛnɔ́. ");
INSERT INTO kenNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ɛ́gháká nɔ́kɔ́ nɛ́ntɨ́bhɛti, mmǔ amɔt abho bɛbɨk andɛm nɔkɔ bɛ, ‘Ghók ká, mbǎyngɔrɛ́ wu atɛwú átwɔ̀! Twɔ́ ká sɛnsyɛpti yi!’ ");
INSERT INTO kenNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Baghɔsɔŋ bhɔ mankɛm bácháyti, maŋɛmɛ, yɛ̌ntɨkɨ mmu wap abho bɛ́kósi nnɨk-ɛrɔ́ŋɔ́ ywi. ");
INSERT INTO kenNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Abhɛn ɛchɨŋti bati atay babho bɛrɛm ntá abhɛn kɛ́ŋwáŋ bɛ, ‘Kwak ka bhɛsɛ nɛ mbɔ bawɛt ɛrɔ́ŋɔ́. Ɛbhɛsɛ́ bɛrɔ́ŋɔ́ bɛ́twɔ̀ nɛmɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Kɛ abhɛn kɛ́ŋwáŋ bákɛ́mɛ bɛ, ‘Ngufú bawɛt amɛn sɛ́bhɔ́ŋɔ́ apu kway chɔŋ bhɛsɛ nɛ bhe. Dɔ́k ká ntá batǐ bawɛt mǎnku amɛka bawɛt.’ ");
INSERT INTO kenNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kɛ bárɔ́ŋ nɔ́kɔ́ bɛku amap bawɛt, mbǎyngɔrɛ́ achwɔp, asɔt abhɛn bati atay, abhɛn ɛbhap bɛrɔ́ŋɔ́ bɛ́dù, achwe amɛm ɛpǎ nɛbhay nɛ bhɔ́. Bakʉ̌-bɛtɨk báya nɛkok batiɛp. ");
INSERT INTO kenNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ɛ́bhɨ́kɨ́ tat, baghɔsɔ́ŋ abhɛn báfú bɛku bawɛt bápɛtnsɛm, báte nɛfí, babho bɛdɛp nɛkok, mándɛmɛ nɔkɔ bɛ, ‘Ɛta, Ɛta, dɛm mánɛ́nɛ́ bhɛsɛ mbǐnywɔp’. ");
INSERT INTO kenNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kɛ mbǎyngɔrɛ́ akɛmɛ bhɔ chi bɛ, ‘Dɨŋɨ́ ká bɛ mbɨ́kɨ́ rɨŋɨ bhe!’” ");
INSERT INTO kenNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesu ánáŋá nɔ́kɔ́ bɛ́tɛ́m nɛkay ɛnɛn, arɛm bɛ, “Bák yɛ ka pě, mbɔnyunɛ bǎbhɨ́kɨ́ rɨŋɨ mpok anɛ Mɛ Mmu mfú ntá Mandɛm nchí twɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesu atɛ́m nɛkay ɛnɛ́nɛ́fú bɛ, “Mpok Mɛ Mmu mfú ntá Mandɛm nchí twɔ, mɛnyɨŋ bɛ́bhak mbɔ ɛnyu ɛ́fákárí nyaka nɛ mmu amɔt nɛ bakʉ̌ bɛtɨk abhi. Nywɔp nɛ́mɔ́t, achyɛ nkáp bɛ mándɔp mánkɔ nɔkɔ ɛsiɛ́ nɛ wu. ");
INSERT INTO kenNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Arɔ bhɔ nkáp bɛkoŋo ɛnyǔ yɛ̌ntɨkɨ mmu wap ákwày bɛkʉ nɛ aywi nkáp. Achyɛ amɔt bɛbhǎ nkáp bɛtay. Achyɛ achák bɛbhǎ nkáp bɛpay. Achyɛ anɛfu ɛbhǎ nkáp ɛ́mɔt. Afa yɛ arɔk nɛkɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Bárɔ́bhɛ́ nɔ́kɔ́, mǔbɛtɨk anɛ yí áchyɛ́ bɛbhǎ nkáp bɛtay abho bɛkɔ ɛsiɛ nɛ wu tɛ́mté. Ɛ́bhɨ́kɨ́ tat, abhɔ́ŋ nsáy bɛbhǎ nkáp bɛ́chák bɛtay. ");
INSERT INTO kenNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Anɛ bɛbhǎ nkáp bɛ́páy akʉ ɛnyumɔt, abhɔ́ŋ nsáy bɛbha bɛpay. ");
INSERT INTO kenNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kɛ nkʉbɛtɨk anɛ ɛbhǎ nkáp ɛ́mɔt, ásɔ́rɛ́ nɔ́kɔ́ aywi nkáp, arɔk atɛ́m chí mbok amɨk abhɛsɛ ɛbhǎ nkáp ɛyɔ arɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Chi-bɛtɨk, átát nɔ́kɔ́ ndǔ nɛkɔ ɛnɛn yi árɔ́ŋɔ́, apɛtnsɛm, abhɨŋɨ bakʉ̌ bɛtɨk bɛ mántwɔ́, yɛ̌ntɨkɨ mmu wap andɛm ɛnyǔ yi akʉ nɛ aywǐ nkáp. ");
INSERT INTO kenNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Anɛ bɛbhǎ nkáp bɛtay atwɔ́ nɛ bɛbha byó, arɛm bɛ, ‘Ɛta, ɔchyɛ́ nyaka mɛ bɛbhǎ nkáp bɛtay bɛ nkɔ ɛsiɛ nɛ wu. Nnu kpát bɛbha bɛ́chák bɛ́tay bɛ́ko amfay.’ ");
INSERT INTO kenNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Chi-bɛtɨk akaka yi tontó arɛm bɛ, ‘Ɔkʉ sayri! Ɔchí ɛrɨ́tí mǔbɛtɨk nɛ ɔchí mmu tɛtɛp. Ɔtɔ̌ŋ ndǔ mandú nkáp bɛ ɔchí mmu tɛtɛp. Nɛ́nɛ, chɔŋ nchyɛ́ wɔ bɛtaŋ amfay bɛyǎ mɛnyɨŋ. Twɔ́ sɛ́nkʉ́ maŋák!’ ");
INSERT INTO kenNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Anɛ bɛbhǎ nkáp bɛpay atwɔ́ nɛ mɛnwi arɛm bɛ, ‘Ɛta, ɔchyɛ́ nyaka mɛ bɛbhǎ nkáp bɛpay. Nnu kpát bɛchak bɛpay bɛko amfay’. ");
INSERT INTO kenNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Chi-bɛtɨk akaka yí tontó arɛm bɛ, ‘Ɔkʉ sayri! Ɔchí ɛrɨ́tí mǔbɛtɨk nɛ ɔchí mmǔ tɛtɛp. Ɔtɔ̌ŋ ndǔ mandú nkáp bɛ́ ɔchí mmǔ tɛtɛp. Nɛ́nɛ, chɔŋ nchyɛ́ wɔ bɛtaŋ amfay bɛyǎ mɛnyɨŋ. Twɔ́ sɛ́nkʉ́ maŋák!’ ");
INSERT INTO kenNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Anɛ ɛbhǎ nkáp atwɔ́ nkwɔ arɛm bɛ, ‘Ɛta, ndɨ́ŋɨ́ bɛ́ ɔchí mmu mbeápak. Ɔkɔŋ bɛghɛm nɛbhʉɛt anɛ ɔ́bhɨ́kɨ́ pɨ, ɔ̌nyokoti nɛbhʉɛt anɛ ɔ́bhɨ́kɨ́ tak mbwɔt arɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mbɔ̌ŋ yɛ̌ bɛcháy bɛ́kɔ́ ɛsiɛ́ nɛ nkáp aywɛ kɛ́ka ánɛ́m mbɔŋ ɛsɔŋɔri nɛ wɔ. Ɛ́kʉ́ ndɔk ntɛ́m mbok amɨk mbɛmɛ wú arɛ́. Yɨŋɨ́ ɛbhǎ nkáp ɛyɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Kɛ chi-bɛtɨk akɛmɛ yi bɛ, ‘Wɔ ɛbɛ́ptí nkʉbɛtɨk! Wɔ mbɔ́t! Ɔrɨ́ŋɨ́ sayri bɛ́ nkɔŋ bɛghɛm nɛbhʉɛt anɛ mbɨ́kɨ́ pɨ, nnyokoti nɛbhʉɛt anɛ mbɨ́kɨ́ ták mbwɔt arɛ, pú nɔ? ");
INSERT INTO kenNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kɛ ndaká yí ɔ́bhɨ́kɨ́ fyɛ nkáp awa amɛm ɛkɛrɛ́nkap bɛ nnáŋ ntwɔ́, mbɔ̌ŋ nsáy arɛ?’ ");
INSERT INTO kenNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Chi-bɛtɨk achyɛ yɛ ɛyɔŋ bɛ mánsɔt ɛbhǎ nkáp mǔbɛtɨk wu manchyɛ ntá anɛ ábhɔ́ŋɔ́ bɛbhǎ nkáp byo. ");
INSERT INTO kenNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","‘Yɛ̌ntɨkɨ mmu anɛ ábhɔ́ŋɔ́ ɛnyɨŋ, mámaka yi bɛ́chák, ambɔ́ŋ mɛ́nja mɛncha. Kɛ yɛ̌ntɨkɨ mmu anɛ ábhɨ́kɨ́ bhɔŋ ɛnyɨŋ, yɛ̌ chí mandú anɛ yi ábhɔ́ŋɔ́, básɔt ntá yi.’ ");
INSERT INTO kenNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kɛ mbák chí nkwɛ̌ndɔŋ mǔbɛtɨk nɛ, bwɔ́p ká yi mǎmɛsɛ nɛfí ndǔ ɛjuri, bɛ́ ámbák awu ndǔ nɛbhʉɛt nɛdǐ kɛbhɔ nɛ nɛnyiɛ́ ámɛ́n.” ");
INSERT INTO kenNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yesu arɔk ambɨ bɛrɛm bɛ, “Mpok Mmu anɛ áfú ntá Mandɛm átwɔ̀ mbɔ Mfɔ nɛ kɛnɛ́m ɛki, bɔángɛl Mandɛm bátwɔ̀ nɛ yi, ambak chɔ́kɔ́ ndǔ ɛnɔkɔ́ kɛfɔ yi nɛ bɛtaŋ ɛbhi mɛnkɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ánáŋ ántwɔ́, bákʉ mkpaká bho bɛtɔkɔ́ mmɨk mɛnkɛm mánchɛm bɛsí bhi, ǎfap bhɔ́ ndǔ bakwɔ́ apay, nkúbhɛ́ mbɔ ɛnyǔ mbabhɛri bághɔ́ŋɔmɛ́n áfàp mmɛ́nɛ́ mbɔŋ nɛ bághɔ́ŋɔmɛ́n, ");
INSERT INTO kenNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","antɛ́n bághɔ́ŋɔmɛ́n ɛbhě awɔ́nɛm ɛyi, antɛn mmɛ́n ɛbhě awɔghɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Mfɔ andɛm yɛ ntá bo abhɛn báchi ɛbhe awɔ́nɛm ywi bɛ, ‘Twɔ́ ká fá, be bhó Ɛtaya áyɛ́rɛ́! Twɔ́ ká mǎmbak nɛbhʉɛt anɛ Mandɛm achí nɛ bo abhɛn yi achi Mfɔ wap. Yí ághókó nɛbhʉɛt wu chi ntá yɛka tɛ nɛbhǒmɨk. ");
INSERT INTO kenNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Twɔ́ ka! Mpǒk nsay ánù mɛ, bǎchyɛ́ mɛ nɛnyíɛ́; mpǒk manyiɛp ákwàk mɛ, bǎchyɛ́ mɛ manyiɛp nnyú; nɛ mpok ntwɔ́ mbɔ kɛnkɔ, bǎsɔ́t mɛ mbɔ mɔmáyɛka. ");
INSERT INTO kenNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Mpok mbɨ́kɨ́ bhɔ́ŋ ndɛn, bǎchyɛ́ mɛ ndɛn; mpok mɛ̌me, bǎkókóri mɛ; mpok nchí ɛkɛrɛ́kɛnɔŋ, bǎré twɔ bɛghɔ mɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Mpok yɔ, chɔŋ bo abhɛn báchí chák bɛsí Mandɛm mankɛmɛ yi bɛ ‘Acha, ntɨkɨ mpok sɛ́ghɔ́ bɛ́ nsay ǎnu wɔ, sɛ́chíɛ wɔ nɛnyíɛ́? Ntɨkɨ mpǒk manyiɛp ákwàk wɔ kɛ sɛ́chíɛ wɔ manyiɛp ɔ́nyú? ");
INSERT INTO kenNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ntɨkɨ mpok ɔ́twɔ́ mbɔ kɛnkɔ, kɛ sɛ́sɔ́t wɔ chí mbɔ mɔ́mayɛsɛ? Ntɨkɨ mpok ɔ́chɛ́bhɛ́ ndɛn, kɛ sɛ́chíɛ wɔ ndɛn? ");
INSERT INTO kenNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ntɨkɨ mpok ɔ́mè, mbák ɛ́pú nɔ, ɔbhak ɛkɛrɛ́kɛnɔŋ, kɛ sɛ́ré twɔ́ bɛghɔ wɔ?’ ");
INSERT INTO kenNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mfɔ akɛmɛ bhɔ bɛ, ‘Dɨŋɨ́ ká bɛ yɛ̌ntɨkɨ mpok anɛ bǎkʉ nyaka bɛrɨ ntá bo abhɛn báchí mbɔ bɔ̌maya, yɛ̌ chí ntá mmu wap amɔt anɛ ápú yɛ̌nyɨŋ, ɛ́chí ɛnyumɔt mbɔ bɛ bákʉ̀ nyaka bɛrɨ ɛbhɔ chi ntá ya.’ ");
INSERT INTO kenNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Mpok yɔ ǎyibhiri mmʉɛt andɛm yɛ ntá bo abhɛn bachi ɛbhe awɔghɔ ywi bɛ, ‘Fǎ ká mɛ bɛsí, bě bho ntɛmsi Mandɛm achi nɛ bhe! Fǎ ká, dɔ́k amɛm ngo anɛ apu nɛmɛ yɛ̌ ɛwak, ngó anɛ́ Mandɛm aghókó ábhʉ́rɛ́ ntá Satan nɛ bɔángɛl abhi. ");
INSERT INTO kenNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Fǎ ká mɛ bɛsí. Mpǒk nsay ánù mɛ, bǎbhɨ́kɨ́ chyɛ mɛ nɛnyíɛ́; mpǒk manyiɛp ákwàk mɛ, bǎbhɨ́kɨ́ chyɛ mɛ manyiɛp mɛnyú. ");
INSERT INTO kenNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mpók nchí kɛnkɔ nɛntɨ ɛnɛka, bǎbhɨ́kɨ́ sɔt mɛ mbɔ ntɨ manɔ́; mpok mbɨ́kɨ́ bhɔ́ŋ ndɛn, bǎbhɨ́kɨ́ chyɛ mɛ ndɛn; mpok mɛ̌me, bǎbhɨ́kɨ́ kokori mɛ, nɛ mpok nchí ɛkɛrɛ́kɛnɔŋ, bǎbhɨ́kɨ́ twɔ bɛghɔ mɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Mpok yɔ, bǒ abhɛn bachi ɛbhe awɔghɔ yi bákɛ́mɛ bɛ, ‘Acha, ntɨkɨ mpok sɛ́ghɔ́ ndǔ nsay ánù wɔ, kɛ sɛ́kɛ chyɛ wɔ nɛnyíɛ́? Ntɨkɨ mpok anɛ manyiɛp ákwàk wɔ kɛ sɛ́kɛ chyɛ wɔ manyiɛp? Ntɨkɨ mpok ɔ́twɔ́ mbɔ kɛnkɔ ntá yɛsɛ kɛ sɛ́kɛ sɔt wɔ mbɔ ntɨ manɔ? Ntɨkɨ mpok ndɛn ɛ́chɛ́bhɛ́ wɔ, kɛ sɛ́kɛ chyɛ wɔ ndɛn? Ntɨkɨ mpok ɔ́mè kɛ sɛ́kɛ kokori wɔ? Nɛ ntɨkɨ mpok ɔ́chí ɛkɛrɛ́kɛnɔŋ kɛ sɛ́kɛ kwak wɔ?’ ");
INSERT INTO kenNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Mfɔ akɛmɛ yɛ bhɔ bɛ ‘Dɨŋɨ́ ká bɛ, yɛ̌ntɨkɨ mpok anɛ mǎnísí nyaka bɛkʉ bɛrɨ ntá yɛ̌ chí mmu amɔt anɛ ápú yɛ̌nyɨŋ, ɛ́chí ɛnyumɔt mbɔ bɛ mɛ kɛ̌ mǎnisi nyaka bɛkwak.’ ");
INSERT INTO kenNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Mpok yɔ, bɔ́ bárɔŋ yɛ ndǔ nɛbhʉɛt ntɛmsi anɛ ábhɨ́kɨ́ bhɔŋ ngwɛnti, kɛ bǒ abhɛn bachi chak bɛsí bhi, mǎnchwe ndǔ nɛpɛ́m ɛnɛn nɛbhɨkɨ bhɔŋ ngwɛnti.” ");
INSERT INTO kenNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu ánáŋá nɔ́kɔ́ bɛtɔŋ mɛnyɨŋ ɛbhɛn mɛnkɛm, arɛm ntá baghɔkɔ́ bhi bɛ, ");
INSERT INTO kenNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Bǎrɨ́ŋɨ́ bɛ́ ndǔ manywɔp apay ɛchɔŋ, Ɛpǎ Nɛkɨŋɨ ɛbho. Chɔŋ mánti Mɛ Mmu mfú ntá Mandɛm ntá bǒmpap abha, mánkɛ́m mɛ mango ndǔ ɛkotákátí.” ");
INSERT INTO kenNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mpok yɔ, bǒbati bachiǎkap Mandɛm nɛ bǒbati ɛtɔk báchɛm amɛm sɛnta Mǔngo bachiǎkap Mandɛm. Mǔngo wu aka nnyɛ́n bɛ Káyfas. ");
INSERT INTO kenNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Báchɛ́m arɛ́ baka ɛyɔŋ ɛ́mɔt bɛ mánkɛ́m Yesu bhɛ́sɛ́ bhɛ́sɛ́ mángwáy. ");
INSERT INTO kenNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kɛ bághɔ́ bɛ́ ɛbhɨkɨ rɨ bɛ mánkɛ́m yi mpok ɛpa. Bárɨ́ŋɨ́ nyaka bɛ́ mbák mánkɛ́m yi mpok ɛpa, bo bágʉɛ́p ɛsɔŋɔri amɛm ɛtɔk. ");
INSERT INTO kenNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Mpok Yesu áchí ɛtɔk Bɛ́tani, abhak amɛm ɛkɛt Símun. Símun wu anáŋ ame nyaka ɛbhaŋákwa. ");
INSERT INTO kenNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ɛnɛ́ Yesu ányìɛ nɛnyíɛ́ arɛ́, ngɔrɛ́ amɔt arɔk ntá yi nɛ bawɛrɛ́riɛp amɛn áré ya nkáp amɛm mɔɛ́nyɨŋɨ́fú. Bághókó nyaka mɔ́kpɛ́mɛ́ wu nɛ ɛnyǔ ntay ɛnɛn bábhɨ̀ŋɨ bɛ alabásta. Ngɔrɛ́ wu atwɔ́ nɛ bawɛrɛ́ mɔ, atɛmti anti Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kɛ baghɔk Yesu bághɔ́ nɔ́kɔ́ nɔ́, batɨ ábé bhɔ amɛm, bábho bɛrɛm nɛ batɨ bɛ, “Ndaká yí ngɔrɛ́ nɛ áré chɔŋti bawɛrɛ́riɛp amɛn ɛnyunɛ́? ");
INSERT INTO kenNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Bákway mbʉ bɛti mɔ ndǔ bɛyǎ nkáp, mánsɔt nkáp wu mánchyɛ ntá bachɛ́bhɛ́bho”. ");
INSERT INTO kenNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu arɨŋɨ ɛnyɨŋ ɛnɛ bɔ bárɛ̀m. Ɛ́kʉ́ arɛm bɛ, “Ndaká yí bǎsɔŋɔri ngɔrɛ́ nɛ? Akʉ ɛrɨ́tí ɛnyɨŋ ntá ya. ");
INSERT INTO kenNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Bachɛ́bhɛ́bho báchí nɛ bhe mpoknkɛm, kɛ mpú bhak chɔŋ nɛ bhe mpoknkɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Atɛ́mtí mɛ́ bawɛrɛ́riɛp amɛn amʉɛt bɛ bákɛ́pɛrɛ fyɛ́ mɛ bawɛt amʉɛt kɛ mámbɛmɛ mɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Dɨŋɨ́ ká bɛ, yɛ̌ntɨkɨ ɛbhak ɛnɛ bo bághàti Mbok Ndɨ́ndɨ́ fá amɨk, chɔŋ mángati ɛnyɨŋ ɛnɛ ngɔrɛ́ nɛ ákʉ́ nkwɔ, nɛ ɛyɔ ɛ́nkʉ bɛ́ bákɛ́ ghɔkɔntɨk yi.” ");
INSERT INTO kenNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ɛ́tárɛ́ nɔ́kɔ́, ngɔk Yesu amɔt anɛ áká nnyɛ́n bɛ Júdas Iskariɔt afʉɛ́t arɔk ntá bǒbati bachiǎkap Mandɛm ");
INSERT INTO kenNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","abhɛ́p bhɔ bɛ, “Chɔŋ mǎnchyɛ mɛ yi mbák nkwák be mǎnkɛ́m yi?” Bápay nkáp silbha bɛbhɔ́k ɛsǎ nsɛm byo bachyɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Bɛ́bhó mpok yɔ, Júdas abho bɛ́yáŋ mbi bɛkwak bɔ mánkɛ́m Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nywɔp Ɛpǎ Brɛt anɛ kɛbhɔŋ yís yɔ, baghɔk Yesu bárɔ́k ntá yi bábhɛ́p yi bɛ, “Ɛta, sɛ́ndɔ́k sɛ́ntóŋtí ɛbhak ɛnɛ ɔ́nyìɛ Ɛpǎ Nɛkɨŋɨ fá?” ");
INSERT INTO kenNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesu arɛm bɛ, “Dɔ́k ká afɔ ɛtɔk ɛgho, chɔŋ mǎngɔ́ mmǔ fú. Nɛghɔ́ bǎghɔ́ yí, ghatí ká yi bɛ Ntɔŋ arɛm bɛ mpok akway, nɛ yi abhɔŋ mɛnyiɛ nɛnyíɛ́ Ɛpǎ Nɛkɨŋɨ amɛm ɛkɛt ɛyɛ nɛ baghɔkɔ́ bhi”. ");
INSERT INTO kenNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Baghɔk Yesu bárɔ́k bakʉ ntoŋti mbɔ ɛnyǔ yi aghati bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ɛ́gháká nɔ́kɔ́ beku, Yesu arɔk achɔkɔ mɛnyiɛ nɛnyíɛ́ nɛ baghɔkɔ́ bhi bati byo nɛ apay. ");
INSERT INTO kenNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ɛnɛ́ mányìɛ̀ nɛnyíɛ́, Yesu arɛm bɛ, “Dɨŋɨ́ ká bɛ, chɔŋ mmu ywɛka amɔt anti mɛ”. ");
INSERT INTO kenNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ɛ́tɔ́k baghɔk Yesu tontó, babho bɛbhɛp yi amɔt amɔt bɛ, “Acha, chi mɛ kɛ?” ");
INSERT INTO kenNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu akɛmɛ bɛ, “Mmǔ ywɛka amɔt anɛ ásɛbhɛ awɔ ywi amɛm ɛkpʉrɛ́ nɛnyiɛ nɛ mɛ ǎti chɔŋ mɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mɛ Mmu mfú ntá Mandɛm, nchí rɔ́ŋɔ́rɔŋ mbɔ ɛnyǔ básɨ́ŋɨ́ ɛ̌ti ya, kɛ chɔŋ ɛ́mbɛ́p ntá mmu anɛ áti mɛ ɛ́ncha! Mbɔ bábhɨ́kɨ́ bhe yi, mbʉ ɛ́rɨ́ ntá yi ɛcha!” ");
INSERT INTO kenNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Júdas mmu abhɔŋɔ bɛti Yesu arɛm bɛ, “Ɛta, chi mɛ kɛ?” Yesu akɛmɛ bɛ, “Ɛ́chí mbɔ ɛnyǔ ɔ́rɛ́mɛ́.” ");
INSERT INTO kenNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ɛnɛ́ mányìɛ̀ nɛnyíɛ́, Yesu asɔt ɛkpɔkɔ́ brɛt, achyɛ bakak ntá Mandɛm. Abho bɛ́bɔ́kɔ́ti anchyɛ nɔkɔ ntá baghɔkɔ́ bhi, andɛmɛ nɔkɔ bɛ, “Sɔt ka, nyiɛ́. Nɛ́ chi mmʉɛ́t ɛya.” ");
INSERT INTO kenNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Asɔt yɛ amokó mmɛm, áchyɛ nɔ́kɔ́ bakak ntá Mandɛm, abho bɛchyɛ ntá yap, andɛm nɔkɔ bɛ, “Sɔt ka nyu, bě mankɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nɛ́ chi manoŋ ma. Ǎkʉ nku anɛ Mandɛm ányú nɛ bǒbhi ántéé. Bákʉ manoŋ ma arɔŋ amɨk bɛ́ Mandɛm ámfóŋórí bɛbʉ́ bɛyǎ bho. ");
INSERT INTO kenNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nchí ghati bhe bɛ mpú pɛrɛ nyu mmɛ́m amɛn, kpátɛ ɛwak ɛnɛ mɛ̌nyú mmɛ̌m bakɔ nɛ bhe ndǔ nɛbhʉɛt bɛchɔkɔ Ɛtaya”. ");
INSERT INTO kenNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ndǔ ngwɛnti, Yesu nɛ baghɔkɔ́ bhi bákwáy nɛkwáy báchyɛ́ Mandɛm bakak. Báfú yɛ bákó amfay Njiɛ Mɛnɔk Ólif. ");
INSERT INTO kenNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Bágháká nɔ́kɔ́ ndǔ Njiɛ Mɛnɔk Ólif, Yesu aghati bhɔ bɛ, “Nkúbhɛ́ bɛti ɛbhɛn ɛchɔŋ, chɔŋ bě mankɛm mǎmfɛrɛ ntí nɛ mɛ mbɔnyunɛ Ɛkáti Mandɛm ɛ́rɛ̀m bɛ, ‘Mandɛm ǎdɛp chɔŋ mbabhɛri bághɔ́ŋɔmɛ́n angʉɛp amɨk, nkwɔ́ bághɔ́ŋɔmɛ́n ántaka ɛbhɨ. ");
INSERT INTO kenNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kɛ Mandɛm ánáŋ ánkʉ́ mpɛ́tnsɛm ndǔ nɛpɛ́m, chɔŋ njambɨ atú Gálili, mǎntɛmɛri mɛ arɛ́.’” ");
INSERT INTO kenNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Píta arɛm bɛ, “Yɛ̌ bǒ mankɛm mámbʉ́ɛ́ wɔ, mɛ, mpú bʉɛ́!” ");
INSERT INTO kenNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu aghati Píta bɛ, “Nchí ghati wɔ bɛ, nkɔk apɛrɛ́ kok nkúbhɛ́ bɛti ɛbhɛn, chɔŋ ɔ́ndɛm ndɔŋ ɛ́rát bɛ ɔbhɨkɨ rɨŋɨ mɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Yɛ̌ nɔ́, Píta arɛm bɛ, “Yɛ̌ chí nɛwú, chɔŋ ngu nɛ wɔ. Mpú bʉɛ wɔ.” Baghɔk Yesu báchák mankɛm bárɛ́m chí ɛnyumɔt. ");
INSERT INTO kenNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesu arɔk yɛ nɛbhʉɛt anɛ bábhɨ̀ŋɨ bɛ Gɛtsɛ́mani nɛ baghɔkɔ́ bhi. Arɛ́, aghati bhɔ bɛ, “Chɔkɔ́ ká fá, mɛ̌tɛn mmʉɛt ambɨ ndu mɛnɨkmʉɛt.” ");
INSERT INTO kenNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Árɛ́m nɔ́kɔ́ nɔ́, asɔt Píta nɛ bɔ̌ Sɛbɛdi bati apay, arɔk nɛ bhɔ. Arɔp nsónso nɛ bɛyǎ basɛ́mɛ́ antɨ. ");
INSERT INTO kenNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Aghati bɔPíta bɛ, “Basɛ́mɛ́ ajwi mɛ antɨ mbɔ bɛ ǎway mɛ way. Chɔkɔ́ ká fá, mǎmbak pě nɛ mɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Arɔ bhɔ atɛ́n mmʉɛt ambɨ mandú. Akwɛn nɛ bɛsí amɨk, abho mɛnɨkmʉɛt bɛ, “Ɛtaya! Kʉ nkɔ́p ɛsɔŋɔri ɛnɛ ámfʉɛ́t mɛ ansɛm ntí, mbák mbi achi bɛkʉ nɔ. Kɛ ɛ́kɛ́ bhák mbɔ ɛnyǔ mɛ̌yáŋ, ɛ́mbák chi mbɔ ɛnyǔ ɔ́yàŋ.” ");
INSERT INTO kenNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Afate yɛ, apɛtnsɛm ntá baghɔkɔ́ bhi abhɛn bati arat. Aghɔ bhɔ ndu bábhʉrɛ kɛnɔ́. Abhɛ́p Píta bɛ, “Bǎpú kwáy bɛ́chɔ́kɔ pě nɛ mɛ ndǔ nɛŋɔkɔ́ nywɔp nɛ́mɔ́t-ɛ? ");
INSERT INTO kenNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Bák ká pě, mǎnɨk nɔkɔ mmʉɛt, bɛ́ nɛmɔ nɛ́kɛ́ dɛp be amɨk. Bǎbhɔŋ ntɨ, kɛ mmʉɛt apu bhe.” ");
INSERT INTO kenNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesu apɛt arɔk are nɨkmʉɛt bɛ, “Ɛtaya! Mbák nkɔ́p ɛsɔŋɔri anɛ apú kway bɛfʉɛt mɛ ansɛm ntí, nká bɛ́ ɛ́mfákárí mbɔ ɛnyu ɔ́yàŋ.” ");
INSERT INTO kenNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yesu apɛtnsɛm ndɔŋ ɛnɛ ɛjwi ɛpay, aghɔ́ baghɔkɔ́ bhi ndǔ bábhʉ̀rɛ kɛnɔ́. Bápú kwáy nyaka bɛ́chɔ́kɔ pě ndǔ kɛnɔ́ kɛ́jwí bɔ amɨ́k. ");
INSERT INTO kenNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Arɔ bhɔ arɔk ndɔŋ anɛ ajwi ɛ́rát are nɨkmʉɛt ɛnyumɔt mbɔ ndɔŋ ɛnɛ́ mbɨ ɛpay. ");
INSERT INTO kenNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Yesu apɛt yɛ nsɛm ntá baghɔkɔ́ bhi bhɔ bati arat, aghɔ́ ndu bábhʉ̀rɛ kɛnɔ́. Abhɛ́p bhɔ́ bɛ, “Bǎbhʉɛ́t bɛbhʉrɛ kɛnɔ́? Bǎbhʉɛ́t bɛ́ywěmʉrɛ? Mpok akway anɛ bátì Mɛ Mmu mfú ntá Mandɛm ntá bǒ bɛbʉ́. ");
INSERT INTO kenNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Faté ká sɛ́ndɔ́k, ghɔ́ ká, mmǔ anɛ áti mɛ ndǔ átwɔ̀.” ");
INSERT INTO kenNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ɛnɛ́ Yesu abhʉɛ́t bɛrɛm nɔ nɛ baghɔkɔ́ bhi, ngɔ̌k aywi amɔt ndǔ abhɛn bati byo nɛ apay anɛ aka nnyɛ́n bɛ Júdas, achwɔp nɛ bɛyǎ bho. Bǒ bhɔ bábhák nɛ bɔ akparɛnja nɛ nkɨ́k amɔ. Bǒbati bachiǎkap nɛ bǒbati ɛtɔk kɛ̌ bátó nyaka bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Júdas anáŋ ayámbɨ achyɛ́ nyaka bhɔ ɛrɨŋ ɛnɛ ɛ́kwák bɔ́ mándɨŋɨ Yesu. Akʉ nɔ́, ndǔ ághátí bhɔ́ bɛ, “Mmu anɛ mɛ̌bhɛnɛ chɔŋ, chí yi. Kɛ́m ká yi!” ");
INSERT INTO kenNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Júdas áchwɔ́bhɛ́ nɔ́kɔ́, afʉɛ́t téé, abhɛnɛ Yesu arɛm bɛ, “Ntɔŋ!” Abhɛnɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu arɛm bɛ, “Mmʉɛrɛ wa, dɔ́k ambɨ, ɛnyɨŋ ɛnɛ ɔ́twɔ́ bɛkʉ, kʉ yɔ́.” Tɛ́mté wu, bǒ abhɛn Júdas átwɔ́ nɛ bhɔ bárɔ́k téé bákɛ́m Yesu bábáyti. ");
INSERT INTO kenNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Bákɛ́m nɔ́kɔ́ Yesu, mmu amɔt anɛ áchí nɛ yi, agwɔp akparɛnja ywi akpɔ́t atú nsɛm Mǔngo bachiǎkap Mandɛm chwát agʉɛp amɨk. ");
INSERT INTO kenNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu aghati mmu ywi wu bɛ, “Kɛmɛ́ akparɛnja ywɛ amɛm kɛ́nkwɔ́p. Mmu anɛ ánù nɛnu nɛ akparɛnja, ǎgu nɛwú akparɛnja. ");
INSERT INTO kenNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ɔbhɨ́kɨ́ rɨŋɨ bɛ́ mɛ̌kwáy mɛnɨkmʉɛt nta Ɛtaya antó mɛ tɛ́mté bɔángɛl mánja máncha nka byo nɛ ɛpay, mántwɔ́ mánu ntá ya? ");
INSERT INTO kenNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kɛ mbák nkʉ nɔ, ná ɛnyɨŋ ɛnɛ ɛchi amɛm Ɛkáti Mandɛm ɛ́fú tɛtɛp?” ");
INSERT INTO kenNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Yesu abhɛ́p yɛ bɛyǎ bǒbhɔ bɛ, “Bǎtwɔ bɛkɛm mɛ nɛ bɔakparɛnja nɛ nkɨ́k mbɔ bɛ nchí ngɛ́bhɛ́ ntantaŋ? Yɛ̌ntɨkɨ ɛwak, nchí chɔkɔ ɛkɛrákap Mandɛm, ntɔŋ nɔkɔ bho mɛnyɨŋ ɛ̌ti Mandɛm, bǎrɔ nyaka kɛkɛ́m mɛ? ");
INSERT INTO kenNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kɛ dɨŋɨ́ ká bɛ mɛnyɨŋ ɛbhɛn mɛnkɛm bɛ́fàkari chi bɛ mɛnyɨŋ ɛbhɛn barɛmɛ́ kɛpɨ̌ntɨ Mandɛm básɨ́ŋɨ́ mɛ́mfú tɛtɛp.” Afɔ̌ kɛ̌ baghɔkɔ́ bhi bárɔ́ yi bábʉɛ́. ");
INSERT INTO kenNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bo abhɛn bákɛ́mɛ́ Yesu, básɔ́t yi barɔk ndǔ ɛkɛt Káyfas, Mǔngo bachiǎkap Mandɛm. Batɔŋ-ɛbhé Mandɛm nɛ bǒbati ɛtɔk báchɛ́mɛ́ nyaka arɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ndu bárɔ̀ŋ arɛ, Píta are koŋo bhɔ tɛ ansɛm, kpát aghaka ndǔ sɛnta Mǔngo bachiǎkap Mandɛm. Achwe arɛ́, arɔk achɔkɔ nɛ bo abhɛn bábhàbhɛri sɛnta wu, anoŋ nɔkɔ bɛghɔ ɛnyɨŋ ɛnɛ bákʉ̀ chɔŋ ntá Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bǒbati bachiǎkap Mandɛm nɛ bǒ ɛchɛmɛ́ bataŋá manyé bachak mankɛm báré yaŋ bǒ abhɛn bákway bɛbhat Yesu barak amʉɛt ɛnyu ɛnɛ́ bɔ́ bábhɔŋ mbi bɛway yi. ");
INSERT INTO kenNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kɛ bákɛ bhɔŋ yɛ̌ mbi. Bɛyǎ bho báfú báré sénse amʉɛt Yesu, kɛ yɛ̌ mmú kɛrɛm ɛnyɨŋ ɛnɛ ɛ́kway bɛkʉ bɛ mángwáy yi. Ɛ́tárɛ́ nɔ́kɔ́, bo bati apay báfú báté bɛsí bataŋá manyé, ");
INSERT INTO kenNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","bárɛm bɛ, “Yí wu arɛm bɛ ǎkwáy mɛmokoti ɛkɛrákap Mandɛm ampɛt ante yɔ́ ndǔ manywɔp arat.” ");
INSERT INTO kenNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mǔngo bachiǎkap afate arɛm ntá Yesu bɛ, “Ɔbhɨ́kɨ́ bhɔ́ŋ yɛ̌nyɨŋ bɛkɛmɛ ndǔ mɛnyɨŋ ɛbhɛn bǒbhɛn bárɛ̀m bɛ ɔkʉ?” ");
INSERT INTO kenNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yɛ̌ nɔ́, Yesu achɔkɔ kpák, akɛ rɛm yɛ̌nyɨŋ. Mǔngo bachiǎkap Mandɛm arɛm bɛ, “Ndǔ nnyɛ́n Mandɛm anɛ achi nɛpɛ́m mpoknkɛm, ghatí bhɛsɛ́ tɛtɛp mbák wɔ kɛ ɔ́chí Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò, Mmɔ Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu akɛmɛ bɛ, “Ɛ́chí mbɔ ɛnyǔ ɔ́rɛ́mɛ́. Kɛ dɨŋɨ́ ká bɛ́ mpok átwɔ̀ anɛ bǎghɔ chɔŋ Mɛ Mmu mfú ntá Mandɛm, chɔkɔ ndǔ ɛnɔkɔ́ kɛfɔ, ɛbhe awɔ́nɛm Mandɛm bɛtaŋ mɛnkɛm. Chɔŋ mǎngɔ ndǔ Mmu anɛ áfú amfay átwɔ̀ amɛm nɛbháŋ.” ");
INSERT INTO kenNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mǔngo bachiǎkap Mandɛm ághókó nɔ́kɔ́ ɛnyɨŋ ɛnɛ Yesu árɛ́mɛ́, akɛ́m nkú yi adak ndu bɛtɔŋ bɛběntɨ bhi. Akók bɛ́, “Akʉ tɛ anáŋá! Ǎyɛnti mmʉɛt nɛ Mandɛm! Sɛ́pɛ́t sɛ́yàŋ batísiɛ́ mántwɔ́ mándɛ́m ɛnyɨŋ ɛnɛ yi ákʉ́ ndaká yí? Bě mankɛm bǎghok ndǔ yí áyɛ̀nti mmʉɛt nɛ Mandɛm! ");
INSERT INTO kenNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Bǎrɛm bɛ yi?” Bákɛ́mɛ bɛ, “Abhɔŋ bɛ́gu!” ");
INSERT INTO kenNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Bábhó bɛ́pa yi batiɛ́ bɛsí, mándɛpti nɔkɔ. Báchák mánchyɛ nɔkɔ yi nsáp. ");
INSERT INTO kenNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Bákʉ́ nɔ́kɔ́ nɔ́, mándɛm nɔkɔ bɛ, “Ndɛmɛ́ kɛpɨ̌ntɨ Mandɛm, Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò, ghati bhɛsɛ ɛnyɨŋ ɛnɛ Mandɛm akʉ wɔ ɔ́rɨ́ŋɨ́. Ghatí bhɛsɛ! Agha ádɛ́bhɛ́ nɔ́ wɔ?” ");
INSERT INTO kenNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Mpok yɔ, Píta abhak nɛfí, amɛm sɛnta chɔ́kɔ́. Ngɔrɛ́ anɛ achi mmɔ̌-bɛtɨk Mǔngo bachiǎkap Mandɛm arɔk ntá yi arɛm bɛ, “Wɔ nkwɔ́ ɔchí nyaka nɛ Yesu mmu Gálili wu.” ");
INSERT INTO kenNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kɛ Píta ataŋa bɛsí bǒ abhɛn bachi arɛ mankɛm bɛ, “Mbɨ́kɨ́ rɨŋɨ mbɔ̌ŋ ɛnyɨŋ ɛnɛ ɔ́rɛ̀m nɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ɛ́tárɛ́ nɔ́kɔ́, áfú arɔk anyǔbhá ɛnɛ́ sɛnta. Arɛ́, mmɔ̌-bɛtɨk Mǔngo bachiǎkap Mandɛm achák, ághɔ́ nɔ́kɔ́ yi arɛm ntá bo abhɛn bachi arɛ́ téé bɛ, “Tánkwǎnɛ achí nyaka nkwɔ nɛ Yesu mmǔ Násárɛt wu.” Mmɔ̌ bɛtɨk anɛfú wu nkwɔ abhak chi ngɔrɛ́. ");
INSERT INTO kenNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Píta apɛt ataŋa, kpát, ayɨkɨ bɛ, “Mandɛm arɨŋɨ, mbɨ́kɨ́ rɨŋɨ mɔ́nkwǎ wu.” ");
INSERT INTO kenNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ɛ́bhɨ́kɨ́ tat, bo abhɛn bachi arɛ téé bákókósi mmʉɛt nɛ Píta barɛm bɛ, “Nsé apu arɛ, wɔ nkwɔ́ ɔchí mmǔ amɔt ndǔ nkwɔ bho Yesu mmǔ atú Gálili wu. Ɛyɔŋɔ́nyu yɛ ɛ́ti wɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ndɔŋ anɛ, Píta arɛm bɛ, “Mandɛm ántɛ́msí mɛ mbák mɛ̌sè chi nsé! Mbɨ́kɨ́ rɨŋɨ mbɔ̌ŋ mmu wu!” Tɛ́mté wu, nnɛ́m nkɔk akók. ");
INSERT INTO kenNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Píta atɨk ɛnyɨŋ ɛnɛ Yesu ághátí nyaka yi bɛ, “Nkɔk apɛrɛ́ kók, chɔŋ ɔ́ndɛm ndɔŋ ɛ́rát bɛ ɔbhɨ́kɨ́ rɨŋɨ mɛ.” Afú nɛfí, adi kɛbhɔ, nɛ bɛyǎ basɛ́mɛ́ antɨ. ");
INSERT INTO kenNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nɛ́yí nɔ́kɔ́, bǒbati bachiǎkap Mandɛm nɛ bǒbati ɛtɔk báchɔ́kɔ betí betí báká ɛyɔŋ ɛ́mɔt ɛnyǔ bábhɔ́ŋɔ́ bɛkʉ bɛ mángwáy Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Báchyɛ́ ɛyɔŋ bɛ mángwɔ́t yi. Bafyɛ́ yi ngɛm amɔ, básɔ́t bárɔ́k ntá Páílet, mmu Rom anɛ achí nyaka gɔ́bhanɔ atú Judɛ́ya mpok yɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Júdas mmu átí Yesu ághók nɔ́kɔ́ bɛ́ bábhɔŋ bɛway Yesu nɛdǐ kɛbhɔ nɛ́jwí yi antɨ ɛ̌ti ɛpɔ̌ndak ɛnɛ yi ákʉ́. Asɔt nkáp silbha bɛbhɔ́k ɛsa nsɛm byo anɛ báchyɛ́ yí antí Yesu arɔk bɛ́kɛ́mɛ ntá bǒbati bachiǎkap Mandɛm nɛ bǒbati ɛtɔk. ");
INSERT INTO kenNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ágháká nɔ́kɔ́ bɛsí ɛbhap arɛm bɛ, “Nkʉ-bɛbʉ́ ndu ntí mmu anɛ ábhɨ́kɨ́ kʉ yɛ̌nyɨŋ, kpatɛ bátwɔ̀ way yi.” Bákɛ́mɛ yí bɛ, “Ɛyɔ ɛ́yɨ́ŋɨ́ bhɛsɛ́ ná? Ɛsɔŋɔri ɛyɛ kɛ ɛ́chí.” ");
INSERT INTO kenNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Júdas aták nkáp wu amɨk amɛm ɛkɛrákap Mandɛm, afú arɔk asuri. ");
INSERT INTO kenNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bǒbati bachiǎkap Mandɛm bárɔ́k bábwɔ́pti nkáp wu, bárɛ́m bɛ, “Nkáp anɛ chí nkáp manoŋ nɛ ɛbhé ɛyɛsɛ ɛ́bhɨ́kɨ́ ka bɛ mánchɛ́m nkáp manoŋ nɛ anɛ́ ɛkɛrákap Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Báká nɔ́kɔ́ ɛyɔŋ ɛ́mɔ́t, básɔt nkáp wu bárɔ́k bákú nɛbhʉɛ́rɛ́mɨk ntá ngoko bɛte ndu bɛ́bhɛ́mɛ nɔkɔ mankɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ɛ̌ti ɛyɔ kɛ̌ bó bábhʉɛ́t bɛ́bhɨ́ŋɨ nɛbhʉ́ɛ́rɛ́mɨk wu bɛ́ Mmɨkɨ́ Manoŋ kpátɛ̌ ɛchɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ɛ́fákárí nɔ́kɔ́ ɛnyu ɛyɔ, ɛnyɨŋ ɛnɛ ndɛmɛkɛpɨ̌ntɨ Mandɛm Jeremáya árɛ́mɛ́ nyaka ɛ́fú tɛtɛp. Jeremáya arɛm nyaka bɛ, “Básɔ́t bɛbhɔ́kɔ́ nkáp ɛsa nsɛm byo, manyǔ nkáp anɛ mbɔk bo Israɛl bághɔ́ bɛ ákway bɛ́chyɛ́ ntá mmu anɛ ati yi. ");
INSERT INTO kenNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Bákú mmɨk ntá ngoko-bɛte nɛ nkáp ɛ́rɛ, nkúbhɛ́ mbɔ ɛnyu Mandɛm ághátí nyaka mɛ nkʉ.” ");
INSERT INTO kenNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Bárɔ́ŋ nɔ́kɔ́ ntá Páílet nɛ Yesu, ate bɛsí bhi. Páílet abhɛ́p yi bɛ, “Wɔ kɛ ɔ́chí nɛ́ Mfɔ bo Israɛl?” Yesu akɛmɛ yi bɛ, “Ɛ́chí mbɔ ɛnyu ɔ́rɛ́mɛ́.” ");
INSERT INTO kenNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Bǒbati bachiǎkap Mandɛm nɛ bǒbati ɛtɔk bábhó bɛ́bhát yí barak amʉɛt, kɛ abhɨ́kɨ́ kɛmɛ yɛ̌ ɛyɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ɛ́kʉ́ Páílet arɛm ntá yi bɛ, “Ɔpú ghók nɔ́ bɛyǎ mɛnyɨŋ ɛbhɛ́n bárɛ̀m bɛ́ ɔkʉ?” ");
INSERT INTO kenNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kɛ Yesu akɛrɛm yɛ̌nyɨŋ. Ɛ́kʉ́ gɔbhánɔ abhak maknkay tontó. ");
INSERT INTO kenNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Gɔ́bhanɔ abhɔ̌ŋ nyaka ɛpɨŋ bɛ yɛ̌ntɨkɨ mmíɛ́, ndǔ mpok Ɛpǎ Nɛkɨŋɨ, ǎfɛrɛ mǔkɛnɔŋ amɔt anɛ bo báyàŋ yí ámfɛ́rɛ́. ");
INSERT INTO kenNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mpok yɔ, mǔkɛnɔŋ amɔt anɛ bo báré rɨŋɨ ɛ̌ti barak anɛ yí áré kʉ, abhak ɛkɛrɛ́kɛnɔŋ. Aka nnyɛ́n bɛ́ Barábas. ");
INSERT INTO kenNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Bɛyǎ bhó báchɛ́mɛ nɔ́kɔ́ ɛkɛt Páílet betí ɛbhɔ, abhɛ́p bɔ́ bɛ, “Agha bǎyáŋ mɛndɔ́ ándɔ́k, Barábas kɛ chí Yesu, anɛ bábhɨ̀ŋɨ bɛ́ Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò?” ");
INSERT INTO kenNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Páílet arɨ́ŋɨ́ nyaka sayri bɛ́ bǒbati bo Israɛl bákɛm Yesu bárɔ̌ŋ ntá yi nɛ yi chi ɛ̌ti mpabhamɨ́k. ");
INSERT INTO kenNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ɛ́fákárí nkwɔ́ bɛ, ɛnɛ́ Páílet áchɔ́kɔ́ bɛ́táŋ Yesu, ngɔrɛ́ ywi ató mmu ntá yi nɛ ɛyɔŋ bɛ, “Dɔ̌ mmu wu ándɔ́k. Achi chak. Ngɔ kɛnɔ́ ɛkɛ́n kɛ́re sɔŋɔri mɛ ɛ̌ti yi ndǔ bɛti ɛbhɛ́n bɛ́fʉɛ́rɛ́.” ");
INSERT INTO kenNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mpok yɔ nɔ, bǒbati bachiǎkap nɛ bǒbati ɛtɔk báré ghati bɛyǎ bhó abhɛn báchí arɛ́ bɛ́ bákɛ́ rɔ bɛbhɛp Páílet ándɔ́ chí Barábas ándɔ́k, anchyɛ bɛtaŋ bɛ mángwáy Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ɛ́kʉ́ Páílet apɛt abhɛ́p bɔ́ bɛ, “Ndǔ bǒbhɛn bati apay, anɛ bǎyáŋ ndɔ́ ándɔ́k chí agha?” Bábɨ́k bɛ, “Barábas!” ");
INSERT INTO kenNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“Nkʉ́ yi nɛ Yesu mmu bábhɨ̀ŋɨ bɛ́ Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò?” Bɔ́ mankɛm bábhó bɛ́bɨ́k bɛ, “Dɛm mángó yi ndǔ ɛkotákátí!” ");
INSERT INTO kenNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kɛ Páílet abhɛ́p bɔ́ bɛ, “Ntɨkɨ ɛbɛ́ptí ndak yi ákʉ́?” Bɔ́ mankɛm bápɛ́t bábhó bɛ́bɨ́k bɛ, “Dɛm mángó yi ndǔ ɛkotákátí!” ");
INSERT INTO kenNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Páílet ághɔ́ nɔ́kɔ́ bɛ́ yí ǎchɔŋti chí mpok nɛ bɛ́ ɛbyɔk ɛ́bho bɛ́kwɛ́n, arɛm mántwɔ́ yí nɛ manyiɛp ndǔ ɛnyɨŋ. Asɔt manyiɛp amɔ aso amɔ amɛm bɛsí bɛyǎ bǒbhɔ andɛm nɔkɔ bɛ, “Mɛ mbɨ́kɨ́ bhɔ́ŋ amɔ ndǔ nɛwú mmu nɛ. Nɛwú ɛni nɛ́yɨ́ŋɨ́ chí bhé!” ");
INSERT INTO kenNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Bɔ́ mankɛm bákɛ́mɛ bɛ, “Dɔ manoŋ ami ámbák bhɛsɛ́ antí, nɛ bɔ̌ bhɛsɛ́!” ");
INSERT INTO kenNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Páílet afɛrɛ yɛ Barábas mmǔ bo Israɛl nɛ bǒbati bhap báyàŋ yi amfɛrɛ. Achyɛ ɛyɔŋ bɛ́ batɛmɛ́ nɛnu mándɛn Yesu nɛ ɛ́kpá, mánsɔt yí, mándɔk, mángó ndǔ ɛkotákátí. ");
INSERT INTO kenNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Batɛmɛ́ nɛnu Páílet básɔ́t Yesu bárɔ́k amɛm áchá ywi nɛ yí, batɛmɛ́ nɛnu báchák mankɛm ndǔ ɛká batɛmɛ́ nɛnu ɛyap bátwɔ́ nkwɔ́ bákáp Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Báyók nkú yi amʉɛt, básɔ́t nkú chu báfyɛ́ yí amʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Básɔ́t bɔ̌batábhɛ́nɔk nsɛ̌nsé mánɨ́ mbɔ ntá kɛfɔ báfyɛ́ yí antí, básɔ́t ɛnɔkɔfú báfyɛ́ awɔ́nɛm aywi. Bábhó bɛ́tɛ́p mánɛ́n bɛsí ɛbhi máŋɔkɔ nɔkɔ yí bɛ, “Acha mfɔ bo Israɛl, kɛnókó kɛ́chí ɛkɛ ɛta!” ");
INSERT INTO kenNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bákʉ́ nɔ́kɔ́ nɔ́, bápáti yí batiɛ́ amʉɛt, báfɔ́ŋɔ ɛnɔk ɛyɔ yi awɔ bákɛ́bhɛ bɛdɛpti yi anti nɛ yɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bápɔbhɛ nɔkɔ bɛyɔkɔ yi, báfɛ́rɛ nkú chu yi amʉɛt, básɔ́t ayi yímbɔŋ bákɛ́mɛ yi amʉɛt. Básɔ́t yɛ yi bárɔ́k bɛgo ndǔ ɛkotákátí. ");
INSERT INTO kenNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ɛnɛ́ báfú ɛkɛt Páílet bárɔ̀ŋ, bátɛ́mɛri mmu ɛtɔk Sírene fú ambi anɛ áká nnyɛ́n bɛ́ Símun. Bájirɛ yí ápɔ́kɔ́ ɛkotákátí Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Bárɔ́k ɛbhak ɛnɛ́ bábhɨ̀ŋɨ bɛ́ Golgóta, nɔ́ chi “Nɛbhʉɛt Ɛnkɔ́nti.” ");
INSERT INTO kenNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Arɛ́, batɛmɛ́ nɛnu básɔ́t ɛnyɨŋ ɛnɛ ɛ́nɛn mbɔ mbʉ̌nya, báfyɛ́ ndǔ mmɛm báchyɛ́ yí ányú. Ághókótí nɔ́kɔ́ mɔ́, akɛ ka mɛ́nyú yɛ̌ ndu báyàŋ nyaka bɛ yi anyu mɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Básɔ́t Yesu bágó ndǔ ɛkotákátí. Batɛmɛ́ nɛnu abhɛn bágó yi ndǔ ɛkotákátí, bágʉɛ́p ɛbháŋá bɛ́rɨ́ŋɨ ɛnyǔ bábhɔ́ŋ bɛ́kɔ́rɛ ndɛn ɛyi bɛ yɛ̌ntɨkɨ mmu wap ambɔŋ amɔt. ");
INSERT INTO kenNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Báchɔ́kɔ yɛ amɨk mámbabhɛri nɔkɔ yí. ");
INSERT INTO kenNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Básɨŋ ɛnyɨŋ ɛnɛ Yesu ákʉ́ kɛ bágò yí ndǔ ɛkotákátí, ndǔ ɛbhɔ́k ɛnɔk. Bágó ɛbhɔ́k ɛnɔk ɛyɔ ndǔ ɛko amfay ntí aywi. Ɛnyɨŋ básɨ́ŋ arɛ́ ɛ́bhák bɛ, “Nɛ́ chí Yesu, Mfɔ bo Israɛl.” ");
INSERT INTO kenNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bágó ngɛ́bhɛ́ ntantaŋ amɔt ndǔ ɛyi ɛkotákátí ɛbhe awɔ́nɛm Yesu. Bákʉ́ ɛnyu ɛ́mɔ́t nɛ achák ɛbhe awɔghɔ yi. ");
INSERT INTO kenNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bo abhɛn báfʉɛrɛ fʉɛt, bághaka nyaka arɛ mánte, mámɔk nɛ bati, mánsɔkɔti yi nɛ mándɛmɛ nɔkɔ bɛ, ");
INSERT INTO kenNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Wɔ mmu ɔ́kway mɛmokoti ɛkɛrákap Mandɛm, nɛ ɔ́nte yɔ́ ndǔ manywɔp arat! Pɛmɛ́ mmʉɛt ɛyɛ mbák ɔchí Mmɔ Mandɛm! Fú ndǔ ɛkotákátí sɛp amɨk sɛ́ngɔ́!” ");
INSERT INTO kenNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bǒbati bachiǎkap Mandɛm nɛ batɔŋ ɛbhé Mandɛm nɛ bǒbati ɛtɔk báré way nkwɔ yi, mándɛmɛ nɔkɔ bɛ, ");
INSERT INTO kenNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ápɛ̀mɛ nyaka bo báchák, kɛ apú kway bɛpɛmɛ mmʉɛt yi! Pú yí achi Mfɔ bo Israɛl? Ámfá ndǔ ɛkotákátí ansɛp amɨk, chɔŋ sɛ́noko yi. ");
INSERT INTO kenNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Asɨ́kɨ́ ntɨ nɛ Mandɛm. Mandɛm ampɛmɛ yi nɛ́nɛ mbák ǎyaŋ bɛpɛmɛ yi, mbɔnyunɛ arɛm bɛ achi Mmu anɛ áfú ntá Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Baghɛ́p abhɛn bágó ndǔ ɛbhap bɛko mbɔ yí, báré so yí nkwɔ́ nɛ nsɔk ɛnyu ɛ́mɔ́t. ");
INSERT INTO kenNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ɛ́gháká nɔ́kɔ́ nkárɛ́nká byo nɛ ɛpay nɛ ngósí, ɛjuri ɛ́kwɛ́n ɛtɔk ɛnkɛm. Ɛbhák kpátɛ nkárɛ́nká ɛ́rát nɛ ngósí. ");
INSERT INTO kenNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ɛ́gháká nɔ́kɔ́ mbɔ nkárɛ́nká ɛyɔ ɛ́rát nɛ ngósí, Yesu abɨk arɛm bɛ, “Ɛli, Ɛli, lama sabatani?” Nɔ́ chi, “Mandɛm wa, Mandɛm wa, ndaká yí ɔ́fɛ́rɛ́ ntí nɛ mɛ?” ");
INSERT INTO kenNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Mbɔk bo abhɛn báté kɛ́kwɔ́t báyɨ̀ŋɨ, bághók nɔ́kɔ́ ndǔ Yesu ábɨ́kɨ́ ɛnyu ɛyɔ, báré rɛm nɛ batɨ bɛ, “Ǎbhɨ̀ŋɨ Ɛláija!” ");
INSERT INTO kenNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ntɛmɛ́ nɛnu amɔt ajɛt tɛ́mté arɔk asɔt ɛkuchá fofok asɛbhɛ ndǔ ɛchyɛ́ mmɛ́m, asɔt akpaŋ anti mɔ́nɔk, asá amfay ntá Yesu, bɛchyɛ yi anyu. ");
INSERT INTO kenNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kɛ abhɛ́nɛ́fú báré rɛm bɛ, “Dɔ̌ yi sɛ́ngɔ́ mbák Ɛláija ǎtwɔ̀ bɛpɛmɛ yi!” ");
INSERT INTO kenNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu abɨk ndɔŋ achak, arɔ ɛfóŋó yi awɔ́ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nkúbhɛ́ mpok yɔ, ɛkát ɛnɛ ɛchi amɛm ɛkɛrákap Mandɛm ɛ́ghárɛ bɛbhɔk bɛpay bɛfu amfay bɛghaka amɨk. Mmɨk anyɨkɨsi, kɛtárábhɛ́ kɛ́rákáti. ");
INSERT INTO kenNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Manɛm ánɛ́nɛ, Mandɛm akʉ bɛyǎ bo Mandɛm abhɛn mǎnáŋ bágú nyaka bapɛtsɛm ndǔ nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Báfú amɛm manɛm ayap, nɛ Yesu ápɛ́rɛ́ nɔ́kɔ́ nsɛm ndǔ nɛpɛ́m, bo Mandɛm bhɔ bárɔ́k Yerúsalɛm. Bɛyǎ bho bághɔ́ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mǔngo batɛmɛ́ nɛnu nɛ batɛmɛ́ nɛnu abhɛn bachi nɛ yi bábhàbhɛri Yesu bághɔ́ nɔ́kɔ́ ndǔ mmɨk ányɨ́kɨ́sí, bághɔ́ mɛnyɨŋ bɛ́chák ɛbhɛn bɛ́fákárí. Bɛchay bɛ́kɛ́m bhɔ tontó. Bábhó bɛrɛm bɛ, “Achí mbʉ Mmɔ Mandɛm tɛtɛp!” ");
INSERT INTO kenNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Bɛyǎ baghɔrɛ́ bábhák arɛ nkwɔ. Abhɛn bákòŋo nyaka Yesu bɛfu tɛ atú Gálili mánkwak nɔkɔ yi, babhak téé, nɛkɔ nɛsiɛ, mámkpɔkɔ nɔkɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mbɔk baghɔrɛ́ bhɔ bábhák María mmɔ̌ ɛtɔk Mágdala, nɛ María nnɔ Jems nɛ Josɛ́f, nɛ María ngɔrɛ́ Sɛbɛdi, nnɔ Jems nɛ Jɔ̌n. ");
INSERT INTO kenNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Mmǔ nkáp amɔt afǔ nyaka ɛtɔk Arimátia. Aka nnyɛ́n bɛ Josɛ́f. Abhak nkoŋo Yesu amɔt. Ɛ́gháká nɔ́kɔ́ beku, ");
INSERT INTO kenNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","arɔk ntá Páílet bɛ anchyɛ bɛtaŋ amfɛrɛ ɛrɛnɛ Yesu ndǔ ɛkotákátí. Páílet achyɛ ɛyɔŋ bɛ́ mámfɛ́rɛ́ Yesu ndǔ ɛkotákátí manchyɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josɛ́f asɔt yɛ Yesu anɛ́p nɛ ɛ́síɛndɛn nkɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Josɛ́f abhɔ̌ŋ nyaka nnɛm nɛkɔ ɛnɛ́n yi átɛ́mɛ́ ndǔ sɛtárɛ́bhɛ́. Arɔk abhɛmɛ Yesu ndǔ nnɛm ɛni nɔ. Abɨŋɨri yɛ ɛrɛm ntay áchók nnyǔ nnɛm, agurɛ. ");
INSERT INTO kenNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","María, mmɔ̌ ɛtɔk Mágdala nɛ María achák, bábhák kɛ́kwɔ́t chɔ́kɔ́ mánjɨŋɨ nɔkɔ nnɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nɛ́yí nɔ́kɔ́, ndǔ nywɔbhɛ́ nɛywěmʉɛt bo Israɛl, bǒbati bachiǎkap Mandɛm nɛ bǒnkwɔ Fárisi bárɔ́k bátɛ́mɛri Páílet. ");
INSERT INTO kenNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Bárɛm bɛ, “Ɛta, sɛ́bhɨ́kɨ́ re ghɔkɔntɨk bɛ mmǔ nsé wu arɛm nyaka bɛ ndǔ manywɔp arat yi ǎpɛtnsɛm ndǔ nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ɛ́rɨ yɛ bɛ ɔ́nchyɛ́ ɛyɔŋ bo mandɔk mambabhɛri nɔkɔ nnɛm ɛni kpátɛ manywɔp arat amfʉɛt. Bakoŋo bhi bákway bɛrɔŋ mángɛp yi mámpɔkɔ, mándɔk, mámbo yɛ bɛghati bho bɛ yi apɛtnsɛm ndǔ nɛpɛ́m. Nɛ mbák ɛ́mfákárí nɔ́, nsé yap yɔ ǎchɔŋti mɛnyɨŋ ancha nsé anɛ mbɨ.” ");
INSERT INTO kenNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Páílet arɛm bɛ, “Yɨŋɨ batɛmɛ́ nɛnu nɔ. Sɔt ka bhɔ́ mándɔ́k mámbábhɛ́rí nɔ́kɔ́ nnɛm mbɔ ɛnyǔ bǎyaŋ.” ");
INSERT INTO kenNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Bárɔ́ yɛ barɔk báfyɛ́ ɛrɨŋ ndǔ ntay, nɛ bárɔ bɔ arɛ bɛ mambabhɛri nɔkɔ nnɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nywɔbhɛ́ nɛywěmʉɛt bo Israɛl nɛ́fʉɛ́rɛ́ nɔ́kɔ́, María mmɔ̌ ɛtɔk Mágdala nɛ María achák, báfú ntɨnywɔp, ɛnɛ́ mbaŋ ábhɨ́kɨ́ re kaŋari ndu bɛrɔŋ bɛyɨŋɨ nnɛm Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ɛ́fákárí bɛ́ ángɛl Mandɛm áfú amfay ásɛ̀p amɨk, abɨŋɨri ntay afɛrɛ anyǔnnɛm, achɔkɔ arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Bɛsí ángɛl Mandɛm wu bɛ́ré ghɔɔ mbɔ miámiaŋ, ndɛn ɛyi ɛ́ndiɛrɛ nɔkɔ pɛ́pɛ̌pɛ́p mbɔ ɛtɔkɔfiɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Babhabhɛrǐ nnɛm báré wɛt nɛ bɛcháy nɛ bárɔp mbɔ bawú. ");
INSERT INTO kenNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kɛ ángɛl arɛm nta baghɔrɛ́ bɛ, “Bǎkɛ́ chay. Ndɨ́ŋɨ́ bɛ́ bǎyàŋ Yesu mmu bágó ndǔ ɛkotákátí. ");
INSERT INTO kenNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Apú fá. Mandɛm akʉ yi apɛtnsɛm ndǔ nɛpɛ́m nkúbhɛ́ mbɔnyu yi arɛmɛ bɛ ɛbhɔŋ bɛfakari. Twɔ́ ká ghɔ nɛbhʉɛt anɛ bábhʉ́rɛ́ yi. ");
INSERT INTO kenNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Dɔ́k yɛ́ ka áyák mǎngátí bakoŋo bhi bɛ apɛtnsɛm ndǔ nɛpɛ́m nɛ achi be ambɨ ǎrɔ̀ŋ atú Gálili. Chɔŋ mǎngɔ́ yi arɛ! Nnáŋ ngati nɔ bhe.” ");
INSERT INTO kenNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Baghɔrɛ bhɔ bárɔ́ nɛbhʉɛt anɛ nnɛm nɛchi ntiɛ́t ntiɛt. Bɛcháy bɛ́kɛ́m bɔ, kɛ maŋák nkwɔ ajwi bhɔ antɨ. Bájɛt barɔk bɛ́yáŋ bakoŋo Yesu bɛ mángátí bhɔ ɛnyɨŋ ɛnɛ ángɛl Mandɛm ághátí bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ndu bárɔ̀ŋ, bápɛ́rɛ ghɔ, Yesu atɛmɛri bhɔ, arɛm bɛ, “Mandɛm ámbák nɛ bhe!” Bárɔ́k bákwɛ́n amɨk bɛsí bhi bábhó bɛkɛm bɛkak ɛbhi mánchyɛ nɔkɔ yi kɛnókó. ");
INSERT INTO kenNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesu aghati bhɔ bɛ, “Bǎkɛ́ cháy. Dɔ́k ká ghati bakoŋo bha. Ghatí ká bhɔ bɛ, mándɔ́k atú Gálili. Chɔŋ mángɔ́ mɛ arɛ́.” ");
INSERT INTO kenNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ɛnɛ́ baghɔrɛ́ bhɔ bárɔ̀ŋ, ɛ́fákari bɛ mbɔk bo abhɛn bábhàbhɛri nnɛm bárɔ́k Yerúsalɛm bágháti bǒbati bachiǎkap Mandɛm yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ ɛfakari mpok ángɛl Mandɛm ásɛ́bhɛ́ átwɔ́ ndǔ nnɛm. ");
INSERT INTO kenNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Bǒbati bachiǎkap Mandɛm báchɔ́kɔ nɛ bǒbati ɛtɔk, báká ɛyɔŋ ɛ́mɔt, báchyɛ́ bhɔ bɛyǎ nkáp ndǔ bɛsɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Bágháti bhɔ bɛ, “Ghatí nɔ́kɔ́ ká bho chi bɛ bakoŋo bhi bátwɔ́ nɛ bɛti, mpok sɛ́kwɛ́nɛ́ kɛnɔ́, bághɛ́p yi, bápɔ́kɔ bárɔk. ");
INSERT INTO kenNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mbák gɔ́bhanɔ ángók ndak anɛ, chɔŋ sɛ́ndɨŋɨ ndǔ sɛ́chòk nnyu ywi bɛ ntɨ nɛndɨ yi amɛm, ɛnyu ɛnɛ́ bǎpu chwe ndǔ ɛsɔŋɔri.” ");
INSERT INTO kenNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Babhabhɛrǐ nnɛm básɔ́t yɛ nkáp bɛsɔŋ wu, bárɔk bákʉ mbɔ ɛnyǔ bǒbati bághátí bhɔ. Nɛ mbok yɔ bɛ́ bakoŋo Yesu bághɛp yi ghɛp kɛ̌ bo Israɛl bábhʉɛ́t bɛghati bo kpatɛ̌ ɛchɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Bakoŋo Yesu abhɛn bati byo nɛ amɔt bárɔ́ yɛ bárɔ́k atú Gálili ndǔ njiɛ anɛ Yesu ághátí nyaka bɔ́ mándɔ́k arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Mpok bághɔ́ yi, bákwɛ́n amɨk babho bɛchyɛ yi kɛnókó. Kɛ mbɔk ayap bare makati mbák, sayri sayri, Yesu kɛ bɔ bághɔ̀ nɔ. ");
INSERT INTO kenNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu akokosi mmʉɛt nɛ bhɔ́, aghati bhɔ bɛsí nɛ bɛsí bɛ, “Ɛtaya achyɛ́ mɛ bɛtaŋ mɛnkɛm amfǎy yɛ̌ntɨkɨ ɛnyɨŋ nɛ yɛ̌ntɨkɨ mmu awu amfay nɛ fá amɨk. ");
INSERT INTO kenNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Dɔ́k yɛ́ ka, mǎnkʉ́ bɛ bǒ bɛtɔk mɛnkɛm mámbak bakoŋo bha, mǎnjwiti bhɔ ndǔ nnyɛ́n Ɛta, nɛ nnyɛ́n Mmɔ, nɛ nnyɛ́n Ɛfóŋó Bɛdyɛrɛ, ");
INSERT INTO kenNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","mǎntɔŋ nɔ́kɔ́ bhɔ bɛ mánkʉ́ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ́ ngátí be mǎnkʉ́ nɔkɔ. Nɛ nchí bhák nɛ bhe mpoknkɛm, tɛ ndǔ ngwɛnti mmɨk.”");
INSERT INTO kenNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Fá chí Mbok Ndɨ́ndɨ́ ɛ̌ti Yesu Kristo Mmɔ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Abho nyaka mbɔ ɛnyǔ ndɛmɛkɛpɨ̌ntɨ Aisáya ásɨ́ŋɨ́ amɛm ɛkáti yi bɛ, Mandɛm arɛm nyaka bɛ, Yɨŋɨ́, chɔŋ ntó mpɔkɔntó wa wɔ ambɨ, bɛ ángókó mbi ywɛ kɛ ɔ́ntwɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Mmǔ achi amɛm baso ǎbɨ̀k andɛmɛ nɔkɔ bɛ́, ‘Toŋtí ká mbi anɛ Acha áfʉɛ̀t arɛ́. Kʉ́ ka mbi ywi ambak chak.’” ");
INSERT INTO kenNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jɔ̌n Njwiti abhésí nyaka amɛm baso angati nɔkɔ bho Ɛyɔŋ Mandɛm bɛ bɔ́ mántɨ́knsɛm ndǔ bɛbʉ́ bhap mánjwítí bhɔ bɛ Mandɛm amfoŋori bɛbʉ́ bhap. ");
INSERT INTO kenNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Bɛyǎ bho báfú atú Judɛ́ya ankɛm, nɛ bǒ Yerúsalɛm mankɛm mándɔk nɔkɔ ntá Jɔ̌n ndu bɛghok ɛnyɨŋ ɛnɛ yi árɛ̀m. Báré su bɛbʉ́ bhap, Jɔ̌n anjwiti nɔkɔ bhɔ amɛm Nnyɛ́n Jɔ́dan. ");
INSERT INTO kenNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nkú Jɔ̌n abhak ɛnyɨŋ ɛnɛ baghoko nɛ babyɔk mpɔŋɔ baso. Mgbat anɛ yi ágwɔ̀t ɛbho abhak nkwɔbhɛ́nya nɛ nɛnyíɛ́ ɛni nɛ́bhak ngɛ́mtáy nɛ bawɛrɛ́ bɛtu amɛn yi ághɔ̀ amɛm baso. ");
INSERT INTO kenNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jɔ̌n ǎrɛ̀m nyaka nkwɔ bɛ, “Mmǔ ǎtwɔ mɛ ansɛm anɛ áchá mɛ. Mbɨ́kɨ́ kwáy yɛ̌ bɛ́chóti yi bɛkak bɛ́ nkáŋárí nkubhanya bɛkak ɛbhi. ");
INSERT INTO kenNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mɛ́jwìti bhe nɛ manyiɛp, kɛ chɔŋ yí anjwiti bhe chí nɛ Ɛfóŋó Bɛdyɛrɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ndǔ mpok yɔ, Yesu afú Násárɛt atú Gálili arɔk Jɔ̌n ajwiti yi ndǔ Nnyɛ́n Jɔ́dan. ");
INSERT INTO kenNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nɛfú Yesu áfú anyɛ́n, aghɔ́ ndǔ nɛbu nɛ́nɛ́nɛ́, nɛ Ɛfóŋó Mandɛm asɔt mkpá ɛbhóŋó asɛp yi amʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ɛyɔŋ ɛ́fú amfay ɛ́ré rɛm bɛ, “Wɔ ɔchí Mɔ́wa. Nkɔŋ wɔ tontó. Ɔ̌chyɛ̀ mɛ bɛyǎ maŋák.” ");
INSERT INTO kenNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tɛ́mté wu, Ɛfóŋó Mandɛm akʉ yí arɔk amɛm baso. ");
INSERT INTO kenNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Abhak arɛ́ ndǔ manywɔp bɛsa bɛpay Satan amɔ nɔkɔ yí. Nnya ɛbébé ɛ́bhák arɛ́ nkwɔ, kɛ bɔángɛl Mandɛm báchyɛ Yesu nɛkwak. ");
INSERT INTO kenNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ɛnɛ́ mánáŋ bákɛ́mɛ́ Jɔ̌n báfyɛ́ ɛkɛrɛ́kɛnɔŋ, Yesu arɔk atú Gálili abho bɛghati bho Mbok Ndɨ́ndɨ́ Mandɛm, ");
INSERT INTO kenNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","andɛmɛ nɔkɔ bɛ, “Mpok anɛ Mandɛm ábhak nɛ bho mbɔ Mfɔ wap arɔp chi kɛkwɔt. Tɨ́k ká nsɛm ndǔ bɛbʉ́ ɛbhɛka, mǎnókó Mbok Ndɨ́ndɨ́!” ");
INSERT INTO kenNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ɛnɛ́ Yesu ákɔ̀ nɛpaká Manyu Gálili, aghɔ́ Símun nɛ mɔ́mayi Andru ndǔ bágʉɛ̀p bɛyǎ nkáp ndu bɛway nsi mbɔnyunɛ báchí nyaka bawǎnsi. ");
INSERT INTO kenNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu arɛm ntá yap bɛ, “Twɔ́ ká mǎmbák bakoŋo bha nɛ chɔŋ ntɔŋ bé ɛnyǔ bǎkʉ bɛ́ bo báchák mambak bakoŋo bha.” ");
INSERT INTO kenNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tɛ́mté wu, bárɔ bɛyǎ nkáp yap bakoŋo Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Átɛ́n nɔ́kɔ́ mmʉɛt ambɨ mandú, aghɔ́ Jems nɛ mɔ́mayi Jɔ̌n, bɔ̌ Sɛbɛdi. Báchí nyaka amɛm áchwí mángoko nɔkɔ bɛyǎ nkáp yap. ");
INSERT INTO kenNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Nɛghɔ́ Yesu aghɔ bhɔ, abhɨŋɨ bhɔ bɛ mankoŋo yi. Bárɔ́ ɛtayap Sɛbɛdi amɛm áchwí nɛ bǒ bɛtɨk, bákóŋo yi. ");
INSERT INTO kenNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu nɛ baghɔkɔ́ bhi bárɔ́k ɛtɔk Kapɛ̌naum. Nɛ́yí nɔ́kɔ́ ndǔ nywɔbhɛ́ nɛywěmʉɛt bo Israɛl, Yesu arɔk téé ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí ɛyap abho bɛtɔŋ Ɛyɔŋ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bo abhɛn bachi arɛ bábhák maknkay tontó ɛ̌ti ɛnyu ɛnɛ yi átɔ̀ŋ. Ǎtɔ̀ŋ nyaka mbɔ mmu anɛ árɛ̀m ɛ́may, puyɛ̌ mbɔ batɔŋ ɛbhé Moses. ");
INSERT INTO kenNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Bápɛ́rɛ ghɔ, mmu anɛ ɛfóŋó ɛbʉ́bʉ ɛ́sɔŋɔri atwɔ́ achwe amɛm ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí are bɨk bɛ́, ");
INSERT INTO kenNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesu, Mmu Násárɛt, ɔbhɔŋ yí bɛkʉ nɛ bhɛsɛ! Ɔtwɔ fá bɛway bhɛsɛ? Ndɨ́ŋɨ́ mmǔ wɔ ɔ́chí. Ɔ́chí Mmu Nyáŋá anɛ Mandɛm átó!” ");
INSERT INTO kenNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu asáy Ɛfóŋó yɔ bɛ, “Kusí! Fú yi amʉɛt!” ");
INSERT INTO kenNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ɛfóŋó ɛbʉ́bʉ ɛ́nyɨkɨsi yi gbogbǒgbok, ɛ́bɨk nɛ bɛtaŋ, ɛ́rɔ́ yi. ");
INSERT INTO kenNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Bǒ mankɛm bábhák maknkay, nɛ bábho bɛbhɛp batɨ bɛ, “Ɛnɛ́ ɛnyu ɛchi ná? Chi ɛnyǔ nɛtɔŋ ɛnɛn nɛkɔ kɛ? Mmǔ-nɛ abhɔ̌ŋ bɛtaŋ ɛbhɛn ásay bɛfɔ́ŋɔ́ bɛbʉ́bɛbʉ nɛ mɛ́ngok yi!” ");
INSERT INTO kenNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Mbok Yesu atɨŋ ataka atú Gálili ankɛm. ");
INSERT INTO kenNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu árɔ́ nɔ́kɔ́ ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí bo Israɛl nɛ baghɔkɔ́ bhi, bárɔk téé ndǔ ɛkɛt Símun nɛ Andru. Jems nɛ Jɔ̌n bábhak nɛ bhɔ́. ");
INSERT INTO kenNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nɛchwe Yesu áchwé anywɔ́p, bágháti yí bɛ nnɔ ngɔrɛ́ Símun achí bhʉ́rɛ́ nɛ mbʉ́ɛ́p amʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu arɔk nɛpakámʉɛt ɛni akɛ́m yí ndu awɔ́ akwak yí afate achɔkɔ chɔ́kɔ́. Mbʉ́ɛ́p wu ámáy. Abho mɛne bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ɛ́gháká nɔ́kɔ́ beku, ɛnɛ́ mmok ánɛ́mɛ́, bo báré sɔt bǒmame mankɛm nɛ abhɛn bɛfóŋó bɛbʉ́bɛbʉ bɛ́sɔ̀ŋɔri mándɔk nɔkɔ ntá Yesu nɛ bhɔ́. ");
INSERT INTO kenNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ɛtɔk ɛnkɛm ɛ́rɔk ɛ́chɛm ambǐnywɔp. ");
INSERT INTO kenNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu abú bɛyǎ bo abhɛn bábhɔ́ŋɔ́ mame mɛnyu nɛ mɛnyu. Abók bɛyǎ bɛfóŋó bɛbʉ́bɛbʉ bɛ́rɔ́ bho. Yí kɛka bɛ bɔ́ mɛ́ndɛm yɛ̌nyɨŋ mbɔnyunɛ bɛ́rɨŋɨ nyaka mmǔ yi achi. ");
INSERT INTO kenNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nɛyí nɔ́kɔ́, Yesu afate kpaŋwák, arɔk nɛbhʉɛt anɛ bo bápú arɛ, are nɨkmʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ɛ́bhɨ́kɨ́ tat, Símun nɛ mamʉɛrɛ bhi báfú báré yaŋ yi. ");
INSERT INTO kenNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Bághɔ́ nɔ́kɔ́ yi, bárɛm ntá yi bɛ, “Yɛ̌ntɨkɨ mmu ǎyàŋ wɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesu akɛmɛ bhɔ bɛ, “Sɛ́bhɔŋ bɛrɔŋ ambɨ ndǔ bɛtɔk bɛchak ɛbhɛn bɛchi fá kɛkwɔt. Mbɔŋ bɛ́gháti Ɛyɔŋ Mandɛm árɛ́ nkwɔ mbɔnyunɛ ɛ̌ti yɔ kɛ ntwɔ́.” ");
INSERT INTO kenNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Yesu abho yɛ bɛkɔ atú Gálili ankɛm angati nɔkɔ bho Mbok Ndɨ́ndɨ́ amɛm bɛkɛrɛ́ nɛnɨkímʉɛt bo Israɛl, ankʉ nɔkɔ bɛfóŋó bɛbʉ́bɛbʉ ɛbhɛn bɛ́sɔ̀ŋɔri bho mɛ́mfu bɔ́ amʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ɛwak ɛ́mɔt, mmu ɛbhaŋákwa amɔt arɔk akwɛ́n yi bɛkak abho bɛrɛm bɛ, “Ɛta, mbák ɔkɔŋ, ɔ̌kway bɛkʉ mɛ ntáŋ.” ");
INSERT INTO kenNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu aghɔ́ yi ntínso. Anyabhɛ awɔ, atɔk yi, arɛm bɛ, “Nkɔŋ, ɛbhaŋákwa yɛ ɛ́may!” ");
INSERT INTO kenNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tɛ́mté wu, ɛbhaŋákwa yi ɛ́may, ataŋ. ");
INSERT INTO kenNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesu aya yí batú ansɛmti nɔkɔ ");
INSERT INTO kenNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","bɛ, “Kɛ́ ghati yɛ̌ mmu ɛnyɨŋ ɛnɛ ɛ́fákárí, kɛ dɔ́k ntá nchiakap Mandɛm bɛ yi ángɔ́ bɛ ɛbhaŋákwa yɛ ɛ́may. Ánáŋ ámbyó wɔ, ɔ́ndɔk, ɔnchyɛ yɛ akap ntá Mandɛm bɛkoŋo ɛbhé Moses. Chɔŋ ɛyɔ ɛ́mbak ɛnyɨŋ ɛnɛ ɛ́tɔ̀ŋ bho bɛ ɛbhaŋákwa yɛ ɛ́may.” ");
INSERT INTO kenNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yɛ̌ nɔ, ndu árɔ̀ŋ, are ghati bho mbǎnkɛm ɛnyɨŋ ɛnɛ ɛfakari. Akʉ Yesu kɛpɛrɛ kwáy bɛchwe ɛtɔk kpoŋoroŋ. Arɔp chi bhɛsɛ́ bhɛsɛ́ ndǔ mbaŋ ɛnɛ bo bápú arɛ́. Yɛ̌ nɔ, bo báré fú mbǎŋ nɛ mbaŋ mándɔk nɔkɔ ntá yi. ");
INSERT INTO kenNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ansɛm mpǎy manywɔp, apɛtnsɛm Kapɛ̌naum nɛ mbok ataka mbǎnkɛm bɛ́ Yesu achí ɛtɔk. ");
INSERT INTO kenNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Bɛyǎ bo bárɔ́k ɛkɛt ɛnɛ́ yi achi arɛ́, ɛnyu ɛnɛ́ ɛpok ɛ́pú nyaka bɛsoŋ ɛkak, yɛ̌ chí nɛfí. Yesu are ghati bhɔ Ɛyɔŋ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ndu árɛ̀m nɔ, bǒ bati anwi bátwɔ́ nɛ mbɛ́ntí amɔt anɛ bápɔ́kɔ́ ndǔ bɛkpaka. ");
INSERT INTO kenNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kɛ bɔ́ kɛbhɔ́ŋ mbi anɛ báfʉɛt mǎnchwe anywɔ́p ɛ̌ti bɛyǎ bho. Báko amfay ɛkɛt mánɛnɛ mbok arɛ́, básɛbhɛ yi bhʉɛrɛ ndǔ bɛkpaka bhi nɛntɨ bho, bɛsí Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu ághɔ́ nɔ́kɔ́ ɛnyǔ nɛka ɛnɛ́n bábhɔ́ŋɔ́ nɛ yi, aghati mbɛ́ntí wu bɛ, “Mɔ́wa, mfóŋórí bɛbʉ́ bhɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mbɔk batɔŋ ɛbhé Moses abhɛn báchí nyaka arɛ́ chɔkɔ báre bhɛp mmʉɛt ɛyap bɛ, ");
INSERT INTO kenNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Agha nɛ́? Ɛnyɨŋ ɛnɛ yi árɛ̀m chi nsɔk ntá Mandɛm! Mandɛm aywǐnti kɛ ákway bɛfoŋori bɛbʉ́ mmu!” ");
INSERT INTO kenNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tɛ́mté wu, Yesu arɨŋɨ nkaysi yap, abhɛp bhɔ bɛ, “Ndaká yí bǎkàysi mɛnyǔ mɛnyɨŋ ɛbhɔ? ");
INSERT INTO kenNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ɛnyɨŋ ɛnɛ ɛchi wɨkɨrɨk bɛrɛm ntá mbɛ́ntí-nɛ chí ɛnɛ́? Bɛrɛm bɛ ‘Mfóŋórí bɛbʉ́ bhɛ’, kɛ chi, ‘Faté pɔkɔ́ bɛkpaka ɛbhɛ kɔ?’ ");
INSERT INTO kenNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kɛ chɔŋ nkʉ mǎndɨŋɨ bɛ, Mɛ Mmu mfú ntá Mandɛm mbɔ̌ŋ bɛtaŋ fá amɨk ndu bɛfoŋori bɛbʉ́ bho.” Arɛm ntá mbɛ́ntí wu bɛ, ");
INSERT INTO kenNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nchí ghati wɔ, faté pɔkɔ́ bɛkpaka bhɛ gurɛ!” ");
INSERT INTO kenNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Bápɛ́rɛ ghɔ, mbɛ́ntí wu afáté kpɛrɛp, apɔkɔ bɛkpaka bhi, afa amɨk. Bɔ́ mankɛm bábhak maknkay tontó bábho bɛbɨti Mandɛm mándɛmɛ nɔkɔ bɛ, “Sɛ́bhɨ́kɨ́ re ghɔ ɛnɛ́ ɛnyu!” ");
INSERT INTO kenNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu apɛt arɔk nɛpaká Manyu Gálili. Ngɛ́mtay bo báre rɔŋ ntá yi, antɔŋ nɔkɔ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ndu ákɔ̀ árɔ̀ŋ, aghɔ́ mbɛbhɛ́ nkabhɛ́nti amɔt chɔkɔ amɛm ɛkɛrɛ́bɛtɨk ɛyi. Aka nnyɛ́n bɛ Lɛ́vi. Abhak mmɔ̌ Álfeɔs. Abhɨŋɨ yi, arɛm bɛ, “Twɔ́ bhák nkoŋo wa.” Lɛ́vi afaté, abho bɛkoŋo Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ɛ́tárɛ́ nɔ́kɔ́ Yesu nɛ bakoŋo bhi báré nyiɛ nɛnyíɛ́ amɛm ɛkɛt Lɛ́vi. Bɛyǎ babhɛbhɛ́ nkábhɛ́nti nɛ bakʉ̌ bɛbʉ́ báchák bákóŋo Yesu, mányiɛ nɔkɔ nɛnyíɛ́ nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mbɔk batɔŋ ɛbhé Mandɛm abhɛn báchí nyaka bǒnkwɔ Fárisi bághɔ́ nɔ́kɔ́ ndu Yesu ányìɛ nɛnyíɛ́ nɛ bǒ bɛbʉ́ nɛ babhɛbhɛ́ nkábhɛ́nti, bábhɛ́p bakoŋo bhi bɛ, “Ndaká yí yi ányìɛ nɛnyíɛ́ nɛ mɛnyǔ bǒbhɛn?” ");
INSERT INTO kenNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu ághók ɛnyɨŋ ɛnɛ bárɛ̀m, akɛmɛ bhɔ bɛ, “Bo abhɛn bapu me, bápú yaŋ ngaŋ. Bǒ mame kɛ báyàŋ ngaŋ. Mbɨ́kɨ́ twɔ bɛbhɨŋɨ bǒ abhɛn bákáysí bɛ bachi chak bɛsí Mandɛm bɛ mámbák bakoŋo bha, ntwɔ bɛbhɨŋɨ chi bǒ bɛbʉ́.” ");
INSERT INTO kenNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Bakoŋó Jɔ̌n Njwiti nɛ abhɛn nkwɔ Fárisi báchí nyaka ndǔ nɛtarɛ́nsay mpokófu. Mbɔk bho bárɔ́k ntá Yesu bábhɛ́p yi bɛ, “Ndaká yí bakoŋó Jɔ̌n Njwiti nɛ abhɛn nkwɔ Fárisi bátarɛ nɔkɔ nsay, kɛ babhɔk abhɛ bápu kʉ nɔ?” ");
INSERT INTO kenNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu akɛmɛ bhɔ bɛ, “Bǎkaysi bɛ mankɔ̌ abhɛn ɛpǎ nɛbhay bákway bɛbhak ndǔ nɛtarɛ́nsay? Nsé! Tɛ̌ndu mbǎyngɔrɛ́ abhʉɛ́t nɛ bhɔ́, bápú kway bɛtat nsay. ");
INSERT INTO kenNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kɛ mpok ǎtwɔ̀ anɛ báfɛrɛ mbǎyngɔrɛ́ ntá yap. Chɔŋ mántarɛ nɔkɔ nsay mpok yɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yesu atɛ́m bɔ́ nɛkay ɛnɛn bɛ, “Yɛ̌ mmu apú kway bɛsɔt ɛbhɔ́kɔ́ndɛn nkɔ bɛchok mbok ndǔ ɛsɨ́ ndɛn, mbɔnyunɛ mbák ánkʉ nɔ ɛbhɔ́kɔ́ndɛn anɛ nkɔ ɛ́ŋati, anɛ nsɨ́ andaka, mbok ámpɛt anchɨk ancha. ");
INSERT INTO kenNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nɛ ntá bo abhɛn báfyɛ̀ mmɛ́m ndǔ bɛbhǎ nkwɔbhɛ́nya, mmǔ apú kway bɛfyɛ mmɛ́m bakɔ amɛm ɛsɨ́ ɛbhǎ nkwɔbhɛnya, mbɔnyunɛ, mbák ánkʉ ɛnyu yɔ, mmɛ́m bakɔ ǎkʉ ɛsɨ́ ɛbha ɛ́nsɛn, ɛnchɔŋɔ, mmɛ́m andɔk amɨk. Báfyɛ mmɛ́m bakɔ chi amɛm ɛbhǎ nkwɔbhɛ́nya ɛnɛ ɛkɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ɛ́fákári bɛ, Yesu nɛ baghɔkɔ́ bhi bákɔ̀ mámfʉɛrɛ nɔkɔ amɛm nkɨ̌ nchwi ndǔ nywɔbhɛ́ nɛywěmʉɛt bo Israɛl. Ɛnɛ́ báfʉɛ́t, baghɔkɔ́ bhi bábho bɛkʉɛp ɛnyǔ nchwi yɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mbɔk bǒ nkwɔ Fárisi bághɔ́ nɔ́kɔ́ nɔ, bárɛm ntá Yesu bɛ, “Yɨŋɨ́, baghɔkɔ́ bhɛ bákʉ̀ ɛnyɨŋ ɛnɛ ɛ́pú chak bɛkʉ ndǔ nywɔbhɛ́ nɛywěmʉɛt!” ");
INSERT INTO kenNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Kɛ Yesu akɛmɛ bhɔ bɛ, “Bǎbhɨ́kɨ́ re pay amɛm Ɛkáti Mandɛm ɛnyɨŋ ɛnɛ Mfɔ Debhít ákú mpok yi áyàŋ ɛnyɨŋ mɛnyiɛ ndǔ nsay ákɛ́mɛ́ yi nɛ bɔ̌bhi? ");
INSERT INTO kenNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Achwe nyáká amɛm ɛkɛrɛ́ Mandɛm anyiɛ́ nɛnyíɛ́ ɛnɛn báchyɛ́ mbɔ akap ntá Mandɛm. Achyɛ ntá bǒbhi nkwɔ, mányíɛ́, ɛnɛ́ ɛbhé ɛ́bhɨ́kɨ́ ka nyaka bɛ mmu achak anyiɛ, ɛbhɨkɨfʉɛt nkʉbɛtɨk amɛm ɛkɛrákap Mandɛm. Ɛ́fákári nɔ ndǔ mpok anɛ Abíata achi mǔngo ndǔ ɛkɛrákap Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Bɛ́rɔŋ ndǔ ngwɛnti, Yesu arɛm ntá yap bɛ, “Dɨŋɨ́ ká bɛ bághoko nywɔbhɛ́ nɛywěmʉɛt ɛ̌ti nkwǎ, bábhɨ́kɨ́ ghoko nkwǎ ɛ̌ti nywɔbhɛ́ nɛywěmʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mɛ Mmu mfú ntá Mandɛm kɛ̌ mbɔ́ŋɔ́ yɛ bɛrɛm ɛnyǔ mmu abhɔŋɔ bɛkʉ nɛ ɛbhé ɛnɛ ɛ́yɨ́ŋɨ́ nywɔbhɛ́ nɛywěmʉɛt.” ");
INSERT INTO kenNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu apɛt achwe amɛm ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí bo Israɛl angati nɔkɔ bho Mbok Ndɨ́ndɨ́. Mmu amɔt abhak amɛm ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí ɛyɔ anɛ awɔ́ ywi ágú. ");
INSERT INTO kenNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Mbɔk bho bábhák arɛ́ abhɛn báyàŋ mbi bɛrɛm bɛ bɛkwɛ́nɛ́ bɛchi nɛ Yesu. Bátɛ́p yɛ yi amɨ́k amʉɛt bɛghɔ mbák chɔŋ Yesu ambú mmǔ wu ndǔ nywɔbhɛ́ nɛywěmʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu arɛm ntá yi bɛ, “Fú, twɔ́ fá ambɨ.” ");
INSERT INTO kenNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Abhɛ́p yɛ bhɔ bɛ, “Ɛbhé yɛsɛ ɛ́rɛ̀m bɛ sɛ́nkʉ yi ndǔ nywɔbhɛ́ nɛywěmʉɛt? Bɛ́ sɛ́nkʉ bɛrɨ kɛ chi bɛbʉ́? Chi bɛ́pɛ́mɛ kɛ chí bɛchɔŋti nɛpɛ́m?” Bárɔp kpákpák. ");
INSERT INTO kenNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ntɨ nɛ́bé Yesu tontó. Abhaŋari ayɨŋɨ bhɔ́ mankɛm nɛ bɛběntɨ bhɔ mbɔnyunɛ bátàŋ batí. Yɛ̌ nɔ, abhɔ́ŋ ntínso nɛ mmu anɛ awɔ́ ágú nɔ́ yi aghati yi bɛ, “Nyabhɛ́ awɔ́ ywɛ.” Anyabhɛ awɔ wu, apɛt ataŋ abhak mbɔ áchák. ");
INSERT INTO kenNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Bǒnkwɔ Fárisi báfú, bárɔ́k. Bátɛmɛri bo Israɛl abhɛn báté ansɛm Hɛ́rɔd, bákɛ́m ɛchɛmɛ, batɨ bɛway Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu nɛ bakoŋo bhi bárɔ bárɔk angɔkɔ Manyu Gálili. Ngɛ́mtay bho báre koŋo yi. Bo báfú atú Gálili, mbɔk atú Judɛ́ya, ");
INSERT INTO kenNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yerúsalɛm nɛ Iduméya. Báchák báfú ɛbhěnyɛn Jɔ́dan, abhɛ́nɛ́fú báfú atú bɛtɔk Táya nɛ Sídɔn. Bo mankɛm abhɛn mámè bárɔ́k ntá Yesu ndu bághókó mɛnyɨŋ ɛbhɛn yi ákʉ̀. ");
INSERT INTO kenNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yesu aghati bakoŋo bhi bɛ́ mántóŋtí áchwí anɛ yi áchwè arɛ ndǔ bo baya bacha, bɛ bákɛ́ nyɨrɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ntí abhak bɛ anáŋ abu nyaka bɛyǎ bǒmame. Bɛyǎ abhɛn bábhʉ́ɛt mɛme báré nu, mányirɛ nɔkɔ batɨ, bɛ mámbɔ́ŋ mbi bɛtɔk yi. ");
INSERT INTO kenNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Yɛ̌ntɨkɨ mpok anɛ bo abhɛn bɛfóŋó bɛbʉ́bɛbʉ bɛ́sɔŋɔri bhɔ bághɔ́ nyaka yi, bákwɛn yi bɛkak mámbɨkɨ nɔkɔ bɛ, “Wɔ kɛ ɔ́chí Mmɔ Mandɛm!” ");
INSERT INTO kenNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kɛ Yesu asɛmti bɛfóŋó bɛbʉ́bɛbʉ bɛ, “Bǎkɛ́ ghati yɛ̌ mmu ɛnyǔ mmu mɛ nchí.” ");
INSERT INTO kenNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ɛ́tárɛ́ nɔ́kɔ́, Yesu akó amfǎy njiɛ, abhɨŋɨ bakoŋo bhi mánkóŋó yi. Bárɔ́ŋ nɔ́kɔ́, ");
INSERT INTO kenNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ayap batí byo nɛ apay, áchyɛ bhɔ́ nnyɛ́n bɛ bǒnto. Aghati bhɔ bɛ, “Njap be bɛ́ mǎmbák nɛ mɛ. Chɔŋ ntó bhe nɛfí ndu bɛghati bho Mbok Ndɨ́ndɨ́ Mandɛm, ");
INSERT INTO kenNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","nɛ chɔŋ nchyɛ́ bhe bɛtaŋ ndu bɛ́bók bɛfóŋó bɛbʉ́bɛbʉ ɛbhɛn bɛ́sɔŋɔri bho.” ");
INSERT INTO kenNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Manyɛ́n bǒnto Yesu bhɔ bati byo nɛ apay achi bɛ, Símun anɛ Yesu áchyɛ́ nnyɛ́n nɛchak bɛ Píta; nɛ ");
INSERT INTO kenNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jems, nɛ mɔ́mayi Jɔ̌n, bɔ̌ Sɛbɛdi Yesu achyɛ bhɔ́ nnyɛ́n nɛ́chák bɛ́ Boanɛjis, nɔ chi bɔ̌nɛfaŋ; nɛ ");
INSERT INTO kenNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ándru, nɛ Fílip, nɛ Batolómio, nɛ Mátio, nɛ Tɔmás, nɛ Jéms mmɔ̌ Alfeyɔs, nɛ Tadiɔs, nɛ Símun, mfyɛ̌-bɛtaŋ ndǔ barakátɔk, ");
INSERT INTO kenNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","nɛ Júdas Iskariɔt anɛ ábhɔ́ŋɔ́ nyaka bɛti Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ɛnɛ́ Yesu nɛ bakoŋo bhi bápɛtnsɛm anywɔ́p, bo abhɛn báchɛ́mɛ́ arɛ́, bápɛt baya bacha, ɛkʉ yí nɛ bakoŋo bhi kɛbhɔ́ŋ yɛ̌ ɛpok ndu mɛ́nyiɛ nɛnyíɛ́. ");
INSERT INTO kenNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Bǒ nnɛrɛ́kɛt ywi bághókó nɔ́kɔ́ nɔ, bábho bɛrɔŋ ndu bɛsɔt yi mbɔnyunɛ bárɛ̀m nyaka bɛ, “Nti átáká yi amɛm!” ");
INSERT INTO kenNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mbɔk batɔŋ ɛbhé Moses abhɛn báfú Yerúsalɛm báre rɛm bɛ, “Bɛlsɛbul, mfɔ bɛfóŋó bɛbʉ́bɛbʉ, kɛ̌ áchyɛ́ Yesu bɛtaŋ bɛbok bɛfóŋó bɛbʉ́bɛbʉ.” ");
INSERT INTO kenNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu abhɨŋɨ bhɔ́ bɛ mantwɔ ntá yi. Bárɔ́ŋɔ́ nɔ́kɔ́, abho bɛghati bhɔ ndǔ bakay bɛ, “Satan ǎkway bɛbok mmʉɛt ná? ");
INSERT INTO kenNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mbák ákɔ́rɛ́ ánkwɛ́n ɛtɔk, bo mánu nɔkɔ nɛ batɨ, ɛtɔk ɛyɔ ɛ́pú te. ");
INSERT INTO kenNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Mbák ákɔ́rɛ́ ánkwɛ́n ndǔ nnɛrɛ́kɛt, bo mánu nɔkɔ nɛ batɨ, nnɛrɛ́kɛt wu ákwɛ̀n. ");
INSERT INTO kenNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ɛnyumɔt kɛ ɛchi bɛ mbák Satan ǎnù nɛ mmʉɛt ɛyi, ákɔ́rɛ́ ákwɛn ndǔ kɛfɔ ɛki, nɛ bɛtaŋ ɛbhi mɛ́may. ");
INSERT INTO kenNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ná mmu ákway bɛchwe amɛm ɛkɛt ɛnɛ́ ntantaŋ angɛ́p mɛnyɨŋ ɛbhi mbák abhɨkɨ yambɨ ánkɛ́m yi angwɔt? Ǎnaŋa kɛ́m yi angwɔ́t, kɛ ánkwáy bɛghɛp mɛnyɨŋ ɛbhi. ");
INSERT INTO kenNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Dɨŋɨ́ ká, nɛ ɛ́chí tɛtɛp bɛ bákway bɛ́fóŋóri bɛbʉ́ bo mankɛm nɛ bɛbɛ́ptí bɛyɔŋ ɛbhɛn bɛ́fù bho anyu. ");
INSERT INTO kenNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kɛ bápú foŋori yɛ̌ agha anɛ árɛ̀m ɛbʉ́bʉ ɛ̌ti Ɛfóŋó Bɛdyɛrɛ. Ɛ́yɔ̌ ɛnyǔ bɛbʉ́ bɛ́tɨŋɨ mmu anti, ngwɛnti ti.” ");
INSERT INTO kenNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu arɛm nɔ, mbɔnyunɛ mbɔk bho bárɛ̀m nyaka bɛ, ɛfóŋó ɛbʉ́bʉ ɛsɔŋɔri yi. ");
INSERT INTO kenNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nnɔ Yesu nɛ bɔ̌mayi bátwɔ́ bátee nɛfí, báto ɛyɔŋ bɛ mámbɨ́ŋɨ́ yi. ");
INSERT INTO kenNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ngɛ́mtay bo abhɛn báchɔ́kɔ́ bákábhɛ́ Yesu bágháti yi bɛ, “Máyɛ nɛ bɔ̌mayɛ báchí nɛfí téé báyàŋ wɔ”. ");
INSERT INTO kenNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Kɛ Yesu akɛmɛ bhɔ́ bɛ, “Sayri sayri, máyá chi agha? Nɛ ntɨkɨ bho bachi bɔ̌maya?” ");
INSERT INTO kenNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ayibhiri mmʉɛt ayɨŋɨ bo abhɛn báchɔkɔ bákábhɛ yi arɛm bɛ, “Máya chi bǒbhɛn, nɛ bɔ̌maya chi bǒbhɛn, ");
INSERT INTO kenNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Bǒ abhɛn bákʉ̀ ɛnyɨŋ ɛnɛ Ɛtaya mmu achi amfay áyàŋ bɔ́ mánkʉ kɛ báchí máya nɛ bɔ̌maya.” ");
INSERT INTO kenNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu apɛt abhɔ bɛtɔŋ bo angɔkɔ manyu Gálili. Bɛyǎ bho bákoŋo yi arɛ́ báté angɔkɔnyɛ́n. Yesu arɔ bhɔ́ tété, arɔk achwe, achɔkɔ amɛm áchwí. ");
INSERT INTO kenNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ɛnɛ́ bɛyǎ bǒbhɔ báté angɔkɔnyɛ́n, abho bɛghati bhɔ bɛyǎ mɛnyɨŋ ndǔ bakay bɛ, ");
INSERT INTO kenNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ɛwak ɛ́mɔt, nkwaŋankɨ amɔt arɔk bɛtak ɛnyǔ nchwifú amɛm nkɨ̌ ywi. ");
INSERT INTO kenNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ɛnɛ́ yi átàk árɔ̀ŋ, mbɔk akwɛnti ndǔ mɔ́mbi anɛ áchí amɛm nkɨ. Kɛnɛn kɛ́twɔ́ kɛ́bwɔ́pti yɔ nkɛm ");
INSERT INTO kenNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mbuɔt áchák akwɛnti ndǔ mmɨk sɛtárɛ́bhɛ́ anɛ ntɔp abhɨkɨ ya arɛ. Awakari achak. ");
INSERT INTO kenNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kɛ mpok anɛ mmok áfú, ásɔ́ŋ yɔ́ ndǔ bakaŋ ayi ábhɨ́kɨ́ kway bɛchwe amɨk sayri. Anɨŋti, awɔsi. ");
INSERT INTO kenNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mbuɔt anɛfu akwɛnti ndǔ mmɨk anɛ tákɔ nsěnse ágò arɛ. Achak are gó, kɛ tákɔ nsěnse agó áchók yɔ. Akɛ fyɛ́. ");
INSERT INTO kenNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nchwi áchák akwɛnti ndǔ mmɨk ndɨ́ndɨ́, achak, agó, achyɛ bɛyǎ nchwi. Nchwi ayá acha anɛ bápɨ́ ndɔŋ ɛsa nsɛm byo, achák ndɔŋ bɛsa bɛrat, anɛfu ndɔŋ bɛsa bɛtay.” ");
INSERT INTO kenNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ndǔ ngwɛnti, Yesu arɛm bɛ, “Mmu anɛ áyàŋ bɛghok, ántá batú angok sayri.” ");
INSERT INTO kenNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mpok Yesu achi aywǐnti, mbɔk bho nɛ baghɔkɔ́ bhi bati byo nɛ apay bábhak arɛ́, bábhɛ́p yi ntí bakay anɛ yi átɛ́mɛ́. ");
INSERT INTO kenNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Akɛmɛ bhɔ́ bɛ, “Ngátí bhé kpoŋoroŋ mɛnyɨŋ ɛbhɛn bɛchi bhɛ́sɛ́ bhɛ́sɛ́ ɛ̌ti Kɛfɔ Mandɛm, kɛ ntá bo báchák, nchí ghati bhɔ mɛnyɨŋ chi ndǔ bakay, ");
INSERT INTO kenNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","nɛ ntí bɛ, ‘Bákwày bɛ́yɨŋɨ nɛ amɨ́k kɛ bápú ghɔ yɛ̌nyɨŋ; mángók nɛ batú, kɛ kɛjwimɛm, bɛ́ bákɛ́ pɛtnsɛm ntá Mandɛm yi ámfoŋori bhɔ.’” ");
INSERT INTO kenNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesu arɛm ntá yap bɛ, “Bǎbhɨkɨ jwimɛm ndǔ nɛkay ɛnɛn, chɔŋ mǎnjwimɛm chí ndǔ bakay anɛ́fu? ");
INSERT INTO kenNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mbuɔt anɛ nkwaŋankɨ átíɛ́, chí Ɛyɔŋ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mbɔk bho báchi mbɔ mbwɔt anɛ ákwɛ́ntí ndǔ mɔ́mbi anɛ achi amɛm nkɨ. Nɛghok anɛ bághókó Mbok Ndɨ́ndɨ́, Satan antɨŋ antwɔ́ amfɛrɛ yɔ́ amɛm batɨ̌ yap. ");
INSERT INTO kenNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bo báchák báchí mbɔ mmɨk sɛtárɛ́bhɛ́ anɛ mbwɔt achak akwɛnti arɛ́. Bághòk Ɛyɔŋ Mandɛm mánsɔt yɔ́ nɛ maŋák tɛ́mté. ");
INSERT INTO kenNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Kɛ ɛnyǔ mú wu kɛbhɔ́ŋ bakaŋ amɨk. Ante kákáti ndu mɔ́mbɨŋɨ́ mpok. Kɛ mpok ɛsɔŋɔri ɛ́twɔ́, bo mámbo mɛnyok yi ɛ̌ti Ɛyɔŋ Mandɛm ɛnɛ yi ánókó, amfɛrɛ amɔ́ tɛ́mté. ");
INSERT INTO kenNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bo abhɛ́nɛ́fú báchí mbɔ mmɨk anɛ ábhɔ́ŋɔ́ tákɔ nsěnse. Bághòk nkwɔ́ Ɛyɔŋ Mandɛm, ");
INSERT INTO kenNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kɛ basɛ́mɛ́ ɛ̌ti mɛnyɨŋ mmɨk atwɔ́ nɔ́kɔ́ yi antɨ, nɛ ngoŋó nkáp, nɛ ɛkwak bɛbhɔŋ mɛnyǔ mɛnyɨŋ bɛchak mɛnkɛm, angɔkɔntɨk Ɛyɔŋ Mandɛm ɛnɛ ɛchi arɛ́, yɔ kɛkwak yi ndǔ nɛpɛ́m ɛni. ");
INSERT INTO kenNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kɛ bo bachak báchí mbɔ mbwɔt anɛ ákwɛ́ntí ndǔ mmɨk ndɨ́ndɨ́. Bághòk Ɛyɔŋ Mandɛm, mányu kɛpɛm ndǔ bapɛ́m ayap. Mbuɔt amɔt anchyɛ mbwɔt nkɔ anɛ aya acha anɛ bapɨ ndɔŋ ɛsa nsɛm byo, achák ndɔŋ bɛsa bɛ́rát, anɛfú ndɔŋ bɛsa bɛtay.” ");
INSERT INTO kenNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu arɔk ambɨ bɛrɛm bɛ, “Bádurɛ ɛrɔ́ŋɔ́ mánsɔt ɛnyɨŋ mankuti kɛ? Bádurɛ ɛrɔ́ŋɔ́ mántɛn antɛnɛ́ bɛkɔk kɛ? Pú bádùrɛ ɛrɔŋɔ mánte chi ndǔ nɛbhʉ́ɛ́t anɛ báte ɛrɔŋɔ? ");
INSERT INTO kenNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Chɔŋ mánkʉ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ́ ɛchi bhɛ́sɛ́ bhɛ́sɛ́ ɛmfu kpoŋoroŋ. Nɛ chɔŋ mánɛnɛ ɛnɛ bákútí. ");
INSERT INTO kenNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mbák mmu abhɔŋ batú bɛ́ghok mbaŋ, ángók sayri!” ");
INSERT INTO kenNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yesu apɛt aghati bhɔ bɛ, “Tá ká batú ndǔ mɛnyɨŋ ɛbhɛn bǎghòk! Ɛnyu ɔ́yɛ̀nti ɔnchyɛ ntɨ, nkúbhɛ́ ɛnyu yɔ̌ kɛ báyɛ̀nti mánchyɛ wɔ. Bápɛrɛ́ chyɛ wɔ, mámaka ɛ́chák arɛ́, ");
INSERT INTO kenNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","mbɔnyunɛ, mmu anɛ ábhɔ́ŋɔ́ ɛnyɨŋ, mámaka yi ɛ́chák. Kɛ mmǔ anɛ ábhɨ́kɨ́ bhɔŋ yɛ̌nyɨŋ, yɛ̌ chí mandú anɛ yi ábhɔ́ŋɔ́, chɔŋ mánsɔt mamfɛrɛ ntá yi.” ");
INSERT INTO kenNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu arɔk ambɨ bɛrɛm bɛ, “Kɛfɔ Mandɛm kɛ́chí mbɔ ɛnyɨŋ ɛnɛ ɛ́fákárí ndǔ mpok anɛ nkwaŋankɨ átìɛ̀ mbwɔt ɛbhɨ. ");
INSERT INTO kenNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Bɛti bɛ́gʉ, ambʉrɛ kɛnɔ́. Nɛ́yi nɔ́kɔ́, amfate, ankɔ, ankʉ nɔkɔ mɛnyɨŋ. Mbuɔt anchak, ango nɔkɔ, kɛ yi kɛrɨŋɨ ndu ɛ́fákári. ");
INSERT INTO kenNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mbuɔt anɛ áchí amɨk ǎchak ndǔ mmʉɛt yi ango nɔkɔ, kpát anchyɛ anɛ nkɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mpok áŋáŋ ánkwáy, ǎtó bǒ bɛtɨk nɛ ngak tɛ́mté, mándɔk mámfɛ́rɛ́ yɔ́ ɛbhɨ.” ");
INSERT INTO kenNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu achɔkɔ abhɛ́p bhɔ bɛ, “Kɛfɔ Mandɛm fá amɨk kɛchi mbɔ yi? Chɔŋ sɛ́nsɔt ntɨkɨ nɛkay bɛtɔŋ ɛnyu kɔ kɛchi? ");
INSERT INTO kenNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kɛ́chí mbɔ mɔ́sɛpɛmɛ́nɔk anɛ bábhɨŋɨ bɛ mɔ́stat. Sɛ́gʉpsi sɛ́cha kɛpɛmɛ́nɔk kɛ́chák kɛnkɛm fá amɨk. ");
INSERT INTO kenNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Yɛ̌ nɔ, mbák mmu ánsɔt sɔ́ ampɨ, sɛ́chàk, sɛ́ngó, ɛnɔk ɛ́nchɨk áncha bɔ̌mɛnɔk báchák mankɛm, nɛ ɛ́ngat batáp ɛnyu ɛnɛ́ kɛnɛn kɛ́twɔ kɛnte manyay ndǔ batábhɛ́ yi.” ");
INSERT INTO kenNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu asɔt bɛyǎ bakay mbɔ ɛnɛn ndu bɛtɔŋ bho mpoknkɛm ɛnyu ɛnɛ́ bákwày bɛjwimɛm. ");
INSERT INTO kenNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Yi kɛ ghati bhɔ yɛ̌nyɨŋ ɛnɛ́ abhɨ́kɨ́ tɛ́m nɛkay. Kɛ mpok anɛ yi ábhák aywǐntí nɛ bakoŋo bhi, anɛnɛ yɛ̌ntɨkɨ ɛnyɨŋ kpoŋoroŋ ntá yap. ");
INSERT INTO kenNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ɛ́gháká nɔ́kɔ́ beku ndǔ nkúbhɛ́ ɛwak ɛyɔ, Yesu arɛm ntá bakoŋo bhi bɛ, “Sɛ́mpé sɛ́ndɔ́k ɛbhě manyu ɛnɛ́ awu.” ");
INSERT INTO kenNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Bárɔ yɛ bɛyǎ bho, bátɛmɛri Yesu amɛm áchwi, bábho bɛ́rɔŋ nɛ yi. Báchwi áchák anɛ́ áchí nyaka arɛ́ áre koŋo bhɔ́. ");
INSERT INTO kenNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Bápɛ́rɛ ghɔ́ mbʉ́ɛ́p ataŋataŋ átwɔ, ákʉ mpɛ́rɛ́nyɛn ɛ́bho bɛdɛp áchwí, manyiɛp anchwe nɔkɔ amɛm, kpát árɔp kɛkwɔt bɛbɛt. ");
INSERT INTO kenNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Kɛ Yesu abhak anɛt áchwí. Anyáŋá nyaka ntí ndǔ ɛnɔkɔ́nti, ambʉɛrɛ nɔkɔ kɛnɔ́. Kɛ baghɔkɔ́ bhi bárɔ́k máŋɛ́mɛ yi bárɛm bɛ, “Ntɔŋ, ɛ́bhɨ́kɨ́ yɨŋɨ wɔ bɛ́ sɛ́twɔ̀ gu anyɛ́n-ɛ́?” ");
INSERT INTO kenNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu afaté asáy mbʉ́ɛ́p arɛm bɛ, “Mbaŋ ánkwɛn!” Aghati nnyɛ́n bɛ, “Kwɛn tɨ̌!” Mbʉ́ɛ́p ámáy, mbǎŋ akwɛn chák. ");
INSERT INTO kenNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesu arɛm yɛ ntá bakoŋo bhi bɛ, “Bǎchay ɛnyunɛ ndaká yí? Bǎbhɨ́kí re bhɔ́ŋ nɛka nɛ mɛ?” ");
INSERT INTO kenNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Bɛcháy bɛ́pɛt bɛkɛm bɔ́ tontó. Bábho bɛbhɛp batɨ bɛ, “Ntɨkɨ ɛnyǔ mmú nɛ? Yɛ̌ chí mbʉ́ɛ́p ághòk yi, mpɛ́rɛ́nyɛn ɛ́ngok yi!” ");
INSERT INTO kenNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu nɛ baghɔkɔ́ bhi mánók yɛ bárɔk ɛbhě manyu Gálili ɛchak, báchwɔp angɔkɔnyɛ́n, kɛkwɔt nɛ atú Gɛrása. ");
INSERT INTO kenNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nɛfú anɛ Yesu áfú amɛm áchwí asɛbhɛ angɔkɔnyɛ́n, mmǔ amɔt anɛ bɛfóŋó bɛbʉ́bɛbʉ bɛ́sɔ̀ŋɔri afú ndǔ nɛbhʉɛ́rɛ́ manɛm arɔk atɛmɛri yi. ");
INSERT INTO kenNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ǎchɔ̀kɔ nyaka chí ndǔ manɛm nɛ yɛ̌ mmu kɛpɛrɛ kwáy bɛgwɔt yi yɛ̌ chí nɛ ngɛm. ");
INSERT INTO kenNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Báfyɛ́ nyaka yi bɛko bɛkak nɛ ngɛm amɔ́. Kɛ ngɛm ɛyɔ ɛ́ré kɨti kɨ́ti nɛ bɛko mɛ́ndakati nɔkɔ. Yɛ̌ mmu kɛbhɔŋ bɛtaŋ ɛbhɛn ákway bɛkɛm yi. ");
INSERT INTO kenNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Bɛti nɛ ngósí, arebɨk, andakati nɔkɔ mmʉɛt nɛ batay ndǔ nɛbhʉɛt manɛm nɛ ndǔ njiɛ. ");
INSERT INTO kenNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ághɔ́ nɔ́kɔ́ Yesu nɛkɔ nɛsiɛ, ajɛt, arɔk atɛp mánɛ́n bɛsí bhi, ");
INSERT INTO kenNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","abho bɛ́bɨk nɛ ɛyɔŋ ɛtaŋataŋ andɛmɛ nɔkɔ bɛ, “Ɛ̌ Yesu, Mmɔ Mandɛm mfay! Ɔ́bhɔ̌ŋ ntɨkɨ ndak nɛ bhɛsɛ́? Yɨkɨ́ Mandɛm bɛ́ ɔpú chyɛ chɔŋ mɛ ɛsɔŋɔrí.” ");
INSERT INTO kenNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Are rɛm nɔ́, mbɔnyunɛ Yesu arɛm bɛ́ ɛfóŋó ɛbʉ́bʉ ɛnɛ́ ɛ́sɔ̀ŋɔri yí ɛ́ndɔ́ yi. ");
INSERT INTO kenNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesu abhɛ́p yi bɛ, “Nnyɛ́n ɛnɛ nɛchi bɛ yi?” Akɛmɛ Yesu bɛ, “Nnyɛ́n ɛna nɛchi bɛ ngɛ́mtáy, mbɔnyunɛ sɛ́yǎ tontó.” ");
INSERT INTO kenNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Arɔk ambɨ mɛnɨk Yesu mmʉɛt bɛ ákɛ́ to bɛfóŋó bɛbʉ́bɛbʉ bhɔ atú ɛtɔk achak. ");
INSERT INTO kenNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ɛrɛmɛ́ nkwɔ́ bakók ányìɛ nyaka ambɨ njiɛ anɛ achi kɛkwɔt. ");
INSERT INTO kenNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Bɛfóŋó bɛbʉ́bɛbʉ bhɔ mɛ́ník Yesu mmʉɛt bɛ andɔ bɔ mándɔk mǎnchwe amʉɛt bakók bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu achyɛ bhɔ mbi. Bɛfóŋó bɛbʉ́bɛbʉ bhɔ bɛ́fú mmǔ wu amʉɛt, bɛrɔk bɛchwe ndǔ nkwɔ́ bakók. Nkwɔ́ bakók ankɛm abhak mbɔ nká ɛpay. Bárókóri básɛp ndǔ nkókónjiɛ dúgúdúgúdúgú kpát bágúrɛ anyɛ́n. ");
INSERT INTO kenNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bo abhɛn bábhàbhɛri bakók bághɔ́ nɔ́kɔ́ nɔ́, bábʉɛ́ ntiɛ́t ntiɛt bárɔ́k ɛtɔk ɛ́gho nɛ amɛm bakɨ mángati nɔkɔ ɛnyɨŋ ɛnɛ ɛ́fákári. Bo báfú báre rɔŋ bɛghɔ nɛ amɨ́k ɛnyɨŋ ɛnɛ́ ɛ́fákárí. ");
INSERT INTO kenNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bágháká nɔ́kɔ́ nɛbhʉɛt anɛ Yesu achi, bághɔ mmu anɛ bɛfóŋó bɛbʉ́bɛbʉ bɛ́fú yi amʉɛt arɛ́ chɔkɔ. Abhak sayri ndǔ nkaysi yi, nɛ ndɛn amʉɛt. Bɛcháy bɛ́kɛ́m bo mankɛm. ");
INSERT INTO kenNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bo abhɛn bághɔ́ ɛnyɨŋ ɛnɛ ɛ́fákárɨ́, báré ghati bǒ abhɛn bárɔŋ arɛ ɛnyɨŋ ɛnɛ ɛ́fákárí ntá mmu anɛ bɛfóŋó bɛbʉ́bɛbʉ bɛ́sɔ̀ŋɔri nyaka nɛ ɛnɛ́ ɛ́fákárí nɛ nkwɔ́ bakók. ");
INSERT INTO kenNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Bábho yɛ mɛ́nɨkmʉɛt ntá Yesu bɛ ándɔ́ atú ɛtɔk ɛyap. ");
INSERT INTO kenNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Nɛchwe anɛ Yesu achwe amɛm áchwi, mmu anɛ bɛfóŋó bɛbʉ́bɛbʉ bɛ́sɔ̀ŋɔri nyaka yi, abho mɛnɨk yi mmʉɛt bɛ́ ándɔ́ yí ándɔ́k nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kɛ Yesu kɛka. Aghati yí chí bɛ, “Pɛtnsɛm ntá bǒbhɛ ghati bhɔ ɛnyɨŋɨ́ maknkay ɛnɛ Mandɛm ákʉ́ ntá yɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Mmǔ wu afa yɛ, arɔk, angati nɔkɔ bho ndǔ bɛtɔk byo mɛnkɛm ɛnyɨŋ ɛnɛ Yesu ákʉ́ ntá yi. Mankɛm abhɛn baghókó bábhák maknkay. ");
INSERT INTO kenNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu apɛtnsɛm ndǔ ɛbhě manyu ɛchak. Ndu yi áchí angɔkɔnyɛ́n téé, bɛyǎ bo bárɔ́k bákáp yi. ");
INSERT INTO kenNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mǔnti anɛ ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí bo Israɛl ndǔ nɛbhʉɛt anɛ yi achi, anɛ áká nnyɛ́n bɛ Jáyrɔs atwɔ́ arɛ nkwɔ, nɛ ághɔ́ nɔ́kɔ́ Yesu, arɔk akwɛ́n yi bɛkak ");
INSERT INTO kenNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","abho mɛ́nɨkmʉɛt ntá yi nɛ ntɨ ɛni nɛnkɛm bɛ, “Mɔ́wa anɛ mɔ́ngɔrɛ́ ǎme tontó. Acha, twɔ́ nyaŋá yi amɔ amʉɛt bɛ ántaŋ, ákɛ́ gu.” ");
INSERT INTO kenNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesu afa, abho bɛrɔŋ nɛ yi. Bɛyǎ bo bákáp yi bɛbhe bɛpay. ");
INSERT INTO kenNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ngɔrɛ́ amɔt abhak arɛ́ anɛ áfɛ̀rɛ manoŋ ndǔ mamiɛ́ byo nɛ apay. ");
INSERT INTO kenNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Anáŋ abhɔ̌ŋ nyaka bɛyǎ ɛsɔŋɔri amɔ bɛyǎ baghaŋ nɛ achɔŋti nkáp ankɛm anɛ yi ábhɔ́ŋɔ́ ndɛ́ndɛm. Nte yi ambɛ́p andɔkɔ nɔkɔ chí ambɨ. ");
INSERT INTO kenNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Aghók ɛ̌ti Yesu. Ɛ́kʉ atɔti amɛm bɛyǎ bho kpát arɔk, atɔk nkokoŋ nkú yi. ");
INSERT INTO kenNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Akʉ́ nɔ́ mbɔnyunɛ ǎrɛ̀m nyaka nɛ mmʉɛt yi bɛ, “Mbák ntɔ́k yɛ̌ chí nkú yi, chɔŋ ntaŋ.” ");
INSERT INTO kenNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nɛtɔk yí átɔ́kɔ́ nkokoŋ nkú Yesu, manoŋ amɛn yi áfɛ̀rɛ nyaka asíɛ́p. Aghók ndǔ mmʉɛt yi bɛ́ nɛme ɛni nɛ́may. ");
INSERT INTO kenNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tɛ́mté wu, Yesu arɨŋɨ bɛ bɛtaŋ bɛ́fú yi amʉɛt. Ayibhiri mmʉɛt, abhɛ́p bɛyǎ bo abhɛn bachi yi ansɛm bɛ, “Agha átɔ́kɔ́ ndɛn ɛya?” ");
INSERT INTO kenNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Bakoŋo bhi bákɛ́mɛ yi bɛ, “Ɔghɔ̌ bɛyǎ bho ndu bákábhɛ́ wɔ, yɛ̌ nɔ, ɔ̌bhɛ́p bɛ, ‘Agha átɔ́kɔ́ mɛ?’” ");
INSERT INTO kenNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Are bhaŋari ndu bɛghɔ mmu anɛ átɔ́kɔ́ yi. ");
INSERT INTO kenNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mɔ́ngɔrɛ́ wu anáŋ árɨ́ŋɨ́ nyaka ɛnyɨŋ ɛnɛ́ ɛ́fákárí nɛ yi. Afú angwɛrɛ nɔkɔ gbagbǎgbak nɛ bɛcháy. Atɛp mánɛ́n bɛsí Yesu aghati yi tɛtɛp nkɛm. ");
INSERT INTO kenNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu arɛm ntá yi bɛ, “Mmá, nɛka ɛnɛ̌ nɛ mɛ nɛ́kʉ ɔtaŋ. Mandɛm áchí nɛ wɔ, dɔ́k sayri, kɛ́pɛrɛ chay.” ");
INSERT INTO kenNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ɛnɛ́ Yesu ábhʉɛ́t bɛrɛm kɛpɨ nɛ ngɔrɛ́ wu, bǒnto abhɛn báfú ɛkɛt Jáyrɔs, bátwɔ́ bágháti yi bɛ, “Mɔ́ywɛ anáŋ águ, ɔbhʉɛt bɛsɔŋɔri Ntɔŋ yi?” ");
INSERT INTO kenNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kɛ Yesu kɛfyɛ́ ntí ndǔ ɛnyɨŋ ɛnɛ́ bárɛ́mɛ́. Aghati yi bɛ, “Ɔ́kɛ́ cháy. Dɔ́kɔ́ rɔŋ ambɨ mɛnoko.” ");
INSERT INTO kenNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesu kɛka yɛ̌ mmu amɔt ánkóŋó yi, ɛ́bhɨ́kɨ́fʉɛt Píta nɛ Jems nɛ mɔ́mayi Jɔ̌n. ");
INSERT INTO kenNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bákɔ, bárɔk, báchwɔp ɛkɛt Jáyrɔs. Yesu aghɔ́ ɛbyɔk ɛnɛ ɛchi arɛ́ ndǔ bo bádì, mámbɨk nɔkɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Achwe, arɛm ntá yap bɛ, “Chí yí nɛ bɛyǎ ɛbyɔk nɛ kɛbhɔ? Mɔ́nɛ abhɨ́kɨ́ gu. Ǎbhʉrɛ chí kɛnɔ́.” ");
INSERT INTO kenNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Báré way Yesu way. Kɛ Yesu abók bɔ́ mankɛm atɛ́n nɛfí. Asɔt chimɔ nɛ nnɔmɔ nɛ bakoŋo bhi bati arat arɔk, achwe ɛbhak ɛnɛ mɔ́wu áchí bhʉrɛ́. ");
INSERT INTO kenNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Akɛ́m yi ndǔ awɔ arɛm bɛ, “Talíta, kum!” Nɔ chi bɛ, “Mɔ́ngɔsɔŋ, faté!” ");
INSERT INTO kenNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tɛ́mté wu, afaté abho bɛkɔ. Achí nyaka mamiɛ́ byo nɛ apay. Manyu áchók bo mankɛm. ");
INSERT INTO kenNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Kɛ Yesu asɛmti bhɔ́ bɛ́, “Bǎkɛ́ ghati yɛ̌ mmu ɛnyɨŋ ɛnɛ ɛ́fákárí.” Achyɛ ɛyɔŋ bɛ mánchyɛ́ Tabíta nɛnyíɛ́ ányíɛ́. ");
INSERT INTO kenNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu afa atú ɛtɔk ɛyɔ apɛtnsɛm ɛtɔk ɛyi Násárɛt. Bakoŋo bhi bárɔ́k nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ɛ́gháká nɔ́kɔ́ ndǔ nywɔbhɛ́ nɛywěmʉɛt bo Israɛl, arɔk ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí, abho bɛtɔŋ bo Ɛyɔŋ Mandɛm. Bɛyǎ bho bábhák arɛ́. Bághókó nɔ́kɔ́ mɛnyɨŋ ɛbhɛn yi átɔ̀ŋ, bɛyǎ bhap bábhak maknkay. Ɛ́kʉ báré bhɛp bɛ, “Aré fú fá nɛ mɛnyɨŋ ɛbhɛn mɛnkɛm? Ntɨkɨ ɛnyǔ nɛrɨŋɨ́ndak nɛ́ báchyɛ́ yi? Ná yi ákʉ̀ mɛnyɨŋɨ́ maknkay ɛbhɛ́n? ");
INSERT INTO kenNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Pú mmɔ̌ nchwɛ̌ mɛnɔk nɛ? Pú mmɔ̌ María nɛ? Pú yi achí manɔ́ Jems, nɛ Júdas nɛ Símun? Pú bɔ̌máyi abhɛn baghɔrɛ́ bachí fá nɛ bhɛsɛ́?” Ɛkʉ́ bare byak yi byak. ");
INSERT INTO kenNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Afɔ̌ kɛ Yesu árɛ́mɛ́ ntá yap bɛ, “Bo báchyɛ̀ ndɛmɛkɛpɨ̌ntɨ Mandɛm kɛnókó yɛ̌ntɨkɨ ɛbhak. Ndiɛrɛ ɛtɔk ɛyi nɛ ndǔ nnɛrɛ́kɛt ywi, kɛ bápú chyɛ yi kɛnókó.” ");
INSERT INTO kenNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ɛkʉ Yesu kɛkʉ mɛnyɨŋɨ́ maknkay arɛ́, ɛ́bhɨ́kɨ́fʉɛt chí nɛnyaŋa anɛ yi ányáŋá amɔ amʉɛt mpǎy bǒmame, abú bhɔ́. ");
INSERT INTO kenNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yesu abhak maknkay mbɔnyunɛ bǒ ɛtɔk ɛyi bábhɨ́kɨ́ bhɔŋ nɛka nɛ yi. Yesu are kɔ ndǔ bɔ̌bɛtɔk abhɛn bachi kɛkwɔt, antɔŋ nɔkɔ bho Ɛyɔŋ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Abhɨŋɨ yɛ bakoŋo bhi bati byo nɛ apay ató nɛfí, bati apay apay. Achyɛ bhɔ́ bɛtaŋ bɛbok bɛfóŋó bɛbʉ́bɛbʉ. ");
INSERT INTO kenNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Asɛmti bhɔ́ bákɛ́ pɔkɔ yɛ̌nyɨŋ ndǔ nɛkɔ ɛnap, ɛ́bhɨ́kɨ́fʉɛt chí ntɛ́m. Yí bákɛ́ pɔkɔ nɛnyíɛ́, nɛ yɛ̌ bɛbhǎ-nɛkɔ, nɛ yɛ̌ chi nkáp. ");
INSERT INTO kenNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Yí mámfyɛ́ nkwɔbhánya kɛ bákɛ́ pɔkɔ ndɛn ɛ́chák. ");
INSERT INTO kenNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nɛ aghati bhɔ bɛ, “Yɛ̌ntɨkɨ ɛtɔk ɛnɛ́ básíɛptí bhe arɛ́, bák ká amɛm ɛkɛt ɛ́mɔt kpátɛ mǎndɔ ɛtɔk ɛyɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nɛ mbák bǎchwɔp ɛtɔk kɛ bo kɛsyɛpti bhe nɛ maŋák nɛ bɔ́ kɛka bɛghok ɛnyɨŋ ɛnɛ bǎghàti bhɔ, fá ká arɛ́. Nɛ bǎpɛrɛ fá arɛ́, kwɛt ka mfok anɛ achi bhe bɛkak. Chɔŋ ɛyɔ ɛ́mbak mbɔ ntísiɛ ndǔ ɛnyɨŋ ɛnɛ́ bɔ́ bákʉ́.” ");
INSERT INTO kenNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Bárɔ́ yɛ bárɔ́k, mángati nɔkɔ bho Ɛyɔŋ Mandɛm bɛ bɔ́ mántɨ́knsɛm ndǔ bɛbʉ́ bhap. ");
INSERT INTO kenNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Báre bok bɛyǎ bɛfóŋó bɛbʉ́bɛbʉ, nɛ mángwati nɔkɔ bɛyǎ bǒmame nɛ bawɛt ólif mámbu nɔkɔ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mfɔ Hɛ́rɔd aghók ɛ̌ti mɛnyɨŋ ɛbhɛn mɛnkɛm, mbɔnyunɛ bo mánáŋ bárɨŋɨ nyaka nnyɛ́n Yesu mbǎnkɛm. Mbɔk bárɛ̀m nyaka bɛ, “Jɔ̌n Njwiti kɛ ápɛ́rɛ́nsɛm ndǔ nɛpɛ́m. Ɛ̌ti yɔ kɛ̌ yi ábhɔ́ŋɔ́ bɛtaŋ bɛkʉ mɛnyɨŋɨ́ maknkay.” ");
INSERT INTO kenNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Kɛ abhɛ́nɛ́fú bɛ, “Chí Ɛláija.” Báchák bárɛ́m bɛ, “Ndɛmɛkɛpɨ̌ntɨ amɔt anɛ tɛ nyaka” ");
INSERT INTO kenNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kɛ mbák chí Hɛ́rɔd, ághókó nɔ́kɔ́ ɛ̌ti Yesu arɛm bɛ, “Chí Jɔ̌n anɛ ndɛ́mɛ́ nyaka bɛ mámkpɔ́t ntí ywi kɛ ápɛ́rɛ́nsɛm ndǔ nɛpɛ́m.” ");
INSERT INTO kenNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ɛfakari nyaka bɛ Hɛ́rɔd achyɛ ɛyɔŋ, bákɛ́m Jɔ̌n, bagwɔt, nɛ báfyɛ́ yi ɛkɛrɛ́kɛnɔŋ ɛ̌ti Hɛródias, ngɔrɛ́ mɔ́mayi Fílip anɛ yí áfɔ́ŋɔ́, ábháy. ");
INSERT INTO kenNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jɔ̌n ǎghati nyaka Hɛ́rɔd bɛ, “Ɛbhé ɛyɛsɛ bo Israɛl ɛ́bhɨ́kɨ́ ka bɛ ɔ́nsɔt ngɔrɛ́ mɔ́mayɛ ɔmbay.” ");
INSERT INTO kenNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ɛ̌ti yɔ, Hɛródias afyɛ́ Jɔ̌n antɨ, nɛ are yaŋ bɛrɛm mángwáy yi, kɛ yi kɛbhɔŋ mbi. ");
INSERT INTO kenNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Hɛ́rɔd are cháy bɛway Jɔ̌n mbɔnyunɛ arɨ́ŋɨ́ nyaka bɛ Jɔ̌n achi chak nɛ nyáŋá bɛsí Mandɛm. Yɛ̌ndu ɛnyɨŋ ɛnɛ Jɔ̌n árɛ̀m ɛ́fyɛ̀ nyaka yi ɛbyɔk antɨ abhɔ̌ŋ maŋák bɛghok Jɔ̌n. ");
INSERT INTO kenNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nywɔp nɛ́mɔt, Hɛródias abhɔ́ŋ mbi. Hɛ́rɔd anak ɛpa ndǔ bɛtɨk nywɔbhɛ́ nɛbhe ɛni. Abhɨŋɨ manɛ́m bǒ ɛtɔk, nɛ bǒ bagho, nɛ batɛmɛ́ nɛnu, nɛ manɛ́m bo Gálili. ");
INSERT INTO kenNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mmɔ̌ Hɛródias anɛ mɔ́ngɔrɛ́ arɔk ndǔ ɛpǎ ɛyɔ, abhɛ́n nɛbhɛ́n ɛnyu ɛnɛ́ Hɛ́rɔd nɛ mankɔ̌ bhi bábhɔ́ŋɔ́ bɛyǎ maŋák. Hɛ́rɔd arɛm ntá mɔ́ngɔsɔ́ŋ wu bɛ, “Ghatí mɛ, yɛ̌ ɔ́yàŋ yi, chɔŋ nchyɛ́ wɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ayɨkɨ bɛyǎ ndɔŋ ntá yi bɛ, “Chɔŋ nchyɛ́ wɔ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ ɔ́yàŋ nchyɛ́ wɔ, yɛ̌ chí ɛbhakátɔk ɛya ɛ́mɔt.” ");
INSERT INTO kenNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ngɔsɔ́ŋ wu arɔk ntá nnɔ, abhɛ́p yi bɛ, “Mma, ndɛ́m mfɔ ánchyɛ mɛ yi?” Nnɔ yi bɛ, “Ntí Jɔ̌n Njwiti.” ");
INSERT INTO kenNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ngɔsɔ́ŋ wu apɛtnsɛm áyák ntá mfɔ arɛm bɛ, “Chiɛ́ mɛ ntí Jɔ̌n Njwiti amɛm nchán myákátí nɛ, nɛ́nɛ!” ");
INSERT INTO kenNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Hɛ́rɔd apɔp! Kɛ ɛ́bé yí mmʉɛt bɛkʉ ɛnyu ɛ́chák ɛ̌ti nɛyɨkɨ anɛ yí áyɨ́kɨ́ bɛsí mankɔ̌ bhi. ");
INSERT INTO kenNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tɛ́mté wu, Hɛ́rɔd ató mbabhɛri ywi amɔt nɛ ɛyɔŋ bɛ́ ándɔk ántwɔ nɛ ntí Jɔ̌n. Arɔk, afɛrɛ ntí ywi amɛm ɛkɛrɛ́kɛnɔŋ, ");
INSERT INTO kenNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","atwɔ́ nɛ wu amɛm nchán myákátí, barɔk bachyɛ ntá mmɔ̌ Hɛródias. Asɔt, arɔk achyɛ ntá máyi. ");
INSERT INTO kenNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Bakoŋó Jɔ̌n bághókó nɔ́kɔ́ ɛnyɨŋ ɛnɛ ɛ́fákári, bárɔk basɔt ɛrɛnɛ́ Jɔ̌n, barɔk babhɛmɛ. ");
INSERT INTO kenNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Bǒnto báfú ndǔ nɛkɔ ɛnɛn Yesu átó bhɔ bápɛtnsɛm ntá yi, bágháti yi ɛ̌ti mɛnyɨŋ ɛbhɛn bɔ́ bákʉ nɛ ɛbhɛn bátɔ́ŋɔ́ bho. ");
INSERT INTO kenNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Bɛyǎ bhó bátwɔ̀ nyaka mándɔk nɔkɔ ɛnyunɛ́ Yesu nɛ baghɔkɔ́ bhi bábhɨ́kɨ́ bhɔŋ yɛ̌ ɛpok mɛnyiɛ nɛnyíɛ́. Ɛ́kʉ arɛm ntá yap bɛ, “Sɛ́ndɔ́k ndǔ nɛbhʉɛt anɛ achi kpák bɛ mǎnjwémʉɛt mandú.” ");
INSERT INTO kenNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Báfa yɛ báre rɔ́ŋ amɛm áchwí ndǔ nɛbhʉɛt anɛ yɛ̌ mmu achak apu. ");
INSERT INTO kenNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Bɛyǎ bhó bághɔ́ ndu bɔ́ bárɔ̀ŋ. Bárɨ́ŋɨ bɛ́ chí Yesu nɛ bǒbhi bhɔ, nɛ bárɨŋɨ nɛbhʉɛt anɛ bárɔ̀ŋ. Bɛyǎ bho báfú ndǔ bɛtɔk nɛ bɛtɔk, báfa nɛ bɛkak, bárɔk ntiɛ́t ntiɛt, báre noŋ bɔ ambɨ. ");
INSERT INTO kenNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Mpok Yesu áfú amɛm áchwi, aghɔ́ ngɛ́mtay bho. Ntínso nɛ́kɛ́m yi nɛ bhɔ mbɔnyunɛ bachi nyaka ndǔ ɛsɔŋɔri, nkwak ti, mbɔ bághɔ́ŋɔmɛ́n anɛ ábhɨ́kɨ́ bhɔŋ mbabhɛri. Abho yɛ bɛ́tɔŋ bhɔ bɛyǎ mɛnyɨŋ. ");
INSERT INTO kenNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ɛnɛ́ mpok áfʉ̀ɛt běku ɛbhɔ, baghɔkɔ́ bhi bárɔ́k ntá yi barɛm bɛ, “Nywɔp nɛ́naŋ nɛrɔŋ nɛ nɛbhʉɛt anɛ sɛchi-nɛ arɛ́ chi ɛbhɨ. ");
INSERT INTO kenNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ghatí bǒbhɛn mándɔ́k ndǔ bakɨ nɛ bɔ̌bɛtɔk abhɛn báchí fá kɛkwɔt manku ɛnyɨŋ mɛnyiɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yesu akɛmɛ bhɔ́ bɛ, “Bě babhɔŋ, chyɛ̌ ká bhɔ nɛnyíɛ́ mányíɛ́.” Kɛ bábhɛ́p yí bɛ, “Ɔ̌yáŋ sɛ́ndɔ́k sɛ́nku nɛnyíɛ́ nɛ nkáp anɛ nkʉ bɛ́tɨk ányìɛ ndǔ bataŋ ánɛn sɛ́chíɛ bǒbhɛn?” ");
INSERT INTO kenNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu abhɛ́p yɛ bhɔ́ bɛ, “Bǎbhɔŋ bɛkpkɔkɔ́ brɛt afɔ mɛ́ní? Dɔ́k ká byo.” Bábyó nɔ́kɔ́, bárɛm bɛ, “Bɛkpɔkɔ́ brɛt bɛ́tay nɛ nsi ɛ́pay.” ");
INSERT INTO kenNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yesu aghati bhɔ bɛ mámfyɛ́ bho ndǔ bakwɔ́, mánkʉ bɔ manchɔkɔ amɨk ndu tákɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Báchɔ́kɔ yɛ amɨk ndǔ barɔ́ŋ, ndǔ bakwɔ́ bɛsa bɛ́tay nɛ bɛsa bɛ́pay nsɛm byo. ");
INSERT INTO kenNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesu asɔt yɛ bɛkpɔkɔ́ brɛt bhɔ bɛtay nɛ nsi ɛpay. Ayoŋ amɨ́k amfay. Achyɛ bakak ntá Mandɛm, abho bɛ́bɔ́kɔ́ti brɛt wu anchyɛ nɔkɔ ntá baghɔkɔ́ bhi bɛ mánkɔ́rɛ́ nɛ nsi ntá bɛyǎ bǒbhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Yɛ̌ntɨkɨ mmǔ wap anyíɛ́ kpát ajwi. ");
INSERT INTO kenNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Baghɔk Yesu mányókóti nɛnyíɛ́ ɛnɛn nɛ́rɔ́bhɛ́. Nɛ́jwí bɛkay byo nɛ bɛpay. ");
INSERT INTO kenNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mpǎy babhakanɛm abhɛn manyíɛ́ brɛt wu nɛ nsi ɛyɔ abhak mbɔ nka ɛtay. ");
INSERT INTO kenNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ɛ́bhɨ́kɨ́ tat, Yesu aghati baghɔkɔ́ bhi bɛ mándɔ́k mǎnchwe amɛm áchwí, mampe nnyɛ́n manjambɨ Bɛtsáida, ndǔ ɛbhě manyu ɛchak. Yímbɔŋ arɔp ansɛm bɛkʉ bɛyǎ bǒbhɔ mángúrɛ́. ");
INSERT INTO kenNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ágháti nɔ́kɔ́ bhɔ bɛ, “Mǎnkɔ sayri”, arɔ akó amfay njiɛ ndu mɛnɨkmʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ɛnɛ́ mpok ánáŋ árɔ́ŋɔ́ beku bhɔ, áchwí ábhak nɛntɨ manyu, Yesu abhak ɛbhɨ aywǐnti. ");
INSERT INTO kenNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yesu aghɔ́ ndu ɛ́bè baghɔkɔ́ bhi mmʉɛt mɛ́nók áchwi ɛ̌ti mbʉ́ɛ́p anɛ áfù bhɔ́ ambɨ. Bɛfʉɛt nkárɛ́nká ɛ́rát bɛghaka nkárɛ́nká ɛtandat betí, abho bɛkɔ amfay manyu ankoŋo nɔkɔ bhɔ. Arɔk kpát ɛrɔp kɛkwɔt bɛfʉɛt bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Bághɔ́ nɔ́kɔ́ ndǔ yi ákɔ̀ anyɛ́n átwɔ̀, bɛ́cháy bɛ́kɛ́m bɔ́ tontó. Bábho bɛbɨk, mándɛmɛ nɔkɔ bɛ, “Chí ɛfóŋó-ngú! Chi ɛfóŋó-ngú!” ");
INSERT INTO kenNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Bɔ́ mankɛm bághɔ nyaka yi, bɛcháy bɛ́kɛm bhɔ. Tɛ́mté wu, Yesu afyɛ́ bhɔ ntɨ arɛm bɛ, “Chi mɛ, bǎkɛ́ chay!” ");
INSERT INTO kenNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Áchwé nɔ́kɔ́ amɛm áchwí, mbʉ́ɛ́p wu ákwɛn. Bɛchay bɛ́kɛ́m bɔ́ tontó. ");
INSERT INTO kenNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Yɛ̌ndu Yesu ádɨ́k nyaka nka bho ɛtay nɛ bɛkpɔkɔ́ brɛt, bɔ kɛjwimɛm ndǔ ɛnyǔ mmu yi achi. Bɔ́ kɛnɛnɛ batɨ̌ yap amɛm. ");
INSERT INTO kenNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yesu nɛ baghɔkɔ́ bhi mánáŋá nɔ́kɔ́ bɛpe manyu, bákó ɛbhɨ, atú Gɛnɛ́sarɛt. Básɛt áchwí wap. ");
INSERT INTO kenNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nɛfú báfú amɛm áchwi, bo bárɨ́ŋɨ bɛ́ Yesu achi arɛ. ");
INSERT INTO kenNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ntiɛt ákwɛ́n atú ɛtɔk ɛyɔ ankɛm ndu bápɔ̀kɔ bǒmame ndǔ bɛ̌sák ɛbhap mándɔk nɔkɔ mbǎŋ ɛnkɛm ɛnɛ bághókó bɛ́ Yesu achí arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yɛ̌ntɨkɨ nɛbhʉɛt anɛ yí áchwɔ́bhɛ́ ndǔ bɔ̌bɛtɔk, nɛ yɛ̌ chi amɛm bɛtɔk bɛgho nɛ amɛm bakɨ, báré pɔkɔ́ bǒmame ndǔ mbaŋ ɛnɛ bo báchɛ̀m mbɔ nɛfísiɛ, mánɨk nɔkɔ mʉɛt bɛ yi andɔ bǒmame mantɔk yɛ̌ chi nkokoŋ ndɛn yi. Nɛ yɛ̌ntɨkɨ mmu anɛ ánú átɔ́kɔ́ nkokoŋ ndɛn Yesu, ataŋ. ");
INSERT INTO kenNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Bǒnkwɔ Fárisi nɛ mbɔk batɔŋ ɛbhé Mandɛm abhɛn báfú Yerúsalɛm, bátwɔ́ nyaka bákáp Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bághɔ bɛ́ mbɔk bakoŋo Yesu mányìɛ̀ nɛnyíɛ́ kɛso amɔ́ mbɔ ɛnyǔ ɛpɨŋɨ́ bǒ bhap ɛ́tɔ̀ŋ. ");
INSERT INTO kenNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Bǒnkwɔ Fárisi nɛ bo Israɛl mankɛm bápú nyiɛ nɛnyíɛ́ kɛ yambɨ bɛso amɔ mbɔ ɛnyǔ ɛpɨŋɨ́ bachǐmbɨ bhap ɛ́tɔ̀ŋ. ");
INSERT INTO kenNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Nɛ bápu nyiɛ ɛnyɨŋ ɛnɛ́ ɛ́fu ɛsiɛ kpátɛ mánso yɔ mbɔ ɛnyǔ ɛpɨŋ ɛyap ɛ́tɔ̀ŋ. Bábhɔŋ bɛpɨŋ bɛ́chak tontó ɛbhɛn bábhʉ̀rɛ mbɔ bɛ́so nkɔ́p, bɛkpʉrɛ, nɛ bɛte árɨk. ");
INSERT INTO kenNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Mbɔk bǒnkwɔ Fárisi nɛ batɔŋ ɛbhé Mandɛm bábhɛ́p Yesu bɛ, “Ndaká yí baghɔkɔ́ bhɛ bápú koŋo bɛpɨŋ ɛbhɛn bachǐmbɨ bhɛsɛ? Ndaká yí mǎnyìɛ nɛnyíɛ́ kɛso amɔ mbɔ ɛnyu ɛ́yàŋ?” ");
INSERT INTO kenNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu akɛmɛ bhɔ́ bɛ, “Ndɛmɛkɛpɨ̌ntɨ Aisáya arɛm nyaka ndaká yí tɛtɛp ɛ̌ti yɛka! Bǎchi bǒ bɛtábhá nkúbhɛ́ mbɔ ɛnyu yi ásɨ́ŋɨ́ bɛ Mandɛm arɛm bɛ, ‘Bǒbhɛn báchyɛ̀ mɛ kɛnókó chi nɛ bɛyɔŋɔ́nyu bhap, batɨ yap ásap nɛkɔ nɛ mɛ. ");
INSERT INTO kenNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kɛnókó ɛkɛn bɔ báchyɛ̀ mɛ kɛchi chi ndɛ́ndɛm, mbɔnyunɛ bɛbhé ɛbhɛn bakwǎŋwaŋ báfyɛ́ kɛ̌ bɔ bátɔ̀ŋ bho mbɔ bɛ bɛchi Ɛyɔŋ Mandɛm.’ ");
INSERT INTO kenNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Bǎrɔ̀ bɛbhé Mandɛm bǎkoŋo chi bɛpɨŋ ɛbhɛn bǒ mmɨk.” ");
INSERT INTO kenNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu arɔk ambɨ aghati bhɔ́ bɛ, “Bǎbhɔŋ ɛrɨ́tí mbi bɛ́rɔ bɛbhé Mandɛm ndu bɛ́koŋo chí mɛnyɨŋ ɛbhɛn bachǐmbɨ bhɛka bátɔ́ŋɔ́! ");
INSERT INTO kenNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses arɛm bɛ, ‘Chiɛ́ ɛ́táyɛ nɛ máyɛ kɛnókó’ nɛ bɛ ‘Yɛ̌ agha anɛ árɛ̀m ɛbɛ́ptí ɛyɔŋ ntá ɛtayi, yɛ̌ máyi, bábhɔŋ bɛway yi.’ ");
INSERT INTO kenNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kɛ bǎghàti bho bɛ mbák mmu ándɛ́m ntá ɛtayi, yɛ̌ máyi bɛ, ‘Nsɔt ɛnyɨŋ ɛnɛ mbɔ́ŋɔ́ mbʉ bɛkwak wɔ nɛ yɔ, nchyɛ́ ntá Mandɛm’, ");
INSERT INTO kenNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","nɔ, bǎchɛt bho mbi bɛ bákɛ́ kwak bachi nɛ manɔ bhap. ");
INSERT INTO kenNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ndǔ bǎkʉ nɔ, bǎsɔt bɛpɨŋ ɛbhɛn bachǐmbɨ bhɛka bɛbyak Ɛyɔŋ Mandɛm. Nɛ bɛyǎ mɛnyɨŋ bɛchak ɛbhɛn bǎkʉ bɛ́chí mbɔ ɛbhɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu árɛ́m nɔ́kɔ́ nɔ́, apɛt abhɨŋɨ bɛyǎ bo abhɛn bachi arɛ́ arɛm bɛ, “Bě mankɛm, tá ká batú mǎngok ɛnyɨŋ ɛnɛ mbɔ́ŋɔ́ bɛrɛm, mǎnjwimɛm! ");
INSERT INTO kenNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Yɛ̌nyɨŋ ɛpu ɛnɛ mmu ányìɛ ɛ́nkʉ bɛ yi akɛ́ bhak pɛ́pɛ́p bɛsí Mandɛm. Ɛnyɨŋ ɛnɛ ɛ́fú mmu anyu kɛ ɛ́kʉ̀ mmu ákɛ́ bhák pɛ́pɛ́p bɛsí Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mmu anɛ ábhɔ́ŋɔ́ batú bɛghok ángók.” ");
INSERT INTO kenNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesu árɔ́ nɔ́kɔ́ bhɔ́, arɔk anywɔ́p. Arɛ́, baghɔkɔ́ bhi bábhɛ́p yi ntí bɛyɔŋ ɛbhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu akɛmɛ bhɔ bɛ, “Bě nkwɔ bǎbhɨ́kɨ́re jwimɛm-ɛ? Bǎbhɨ́kɨ́ rɨŋɨ bɛ ɛnyɨŋ ɛnɛ mmu ányìɛ ɛnchwe yi mɛniɛ ɛ́pú kway bɛkʉ bɛ yi akɛ bhak pɛ́pɛ́p bɛsí Mandɛm? ");
INSERT INTO kenNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ɛnyɨŋ ɛnɛ mmu ányíɛ́, ɛ́pú chwe yi antɨ, ɛ́rɔŋ chi mɛniɛ ɛbhi nɛ ǎji yɔ amfɛrɛ.” Yesu arɛm nɔ, ndu áyàŋ bo mándɨŋɨ bɛ yɛ̌ntɨkɨ nɛnyíɛ́ nɛ́kway mɛnyiɛ. ");
INSERT INTO kenNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Arɔk ambɨ bɛrɛm bɛ, “Ɛnyɨŋ ɛnɛ ɛ́fù mmu antɨ kɛ ɛ́kʉ̀ yi akɛ bhak pɛ́pɛ́p bɛsí Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Chí amɛm ntɨ mmu kɛ̌ nkaysi mbʉ́mbʉ áfù, antɛ́n yi ndǔ ɛpúsí, nɛ bɛway mmu, nɛ bɛkwɛn bɛrwɔp, nɛ ");
INSERT INTO kenNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","bɛ́fyɛ amɨ́k ndǔ mɛnyɨŋ bo bachak, nɛ ɛbɛ́bhɛ́ntɨ, nɛ bɛrwɔ bho, nɛ ɛpɔ̌ ɛpɨŋ ɛnɛ mmu apu kɛm mmʉɛt, nɛ mpap amɨ́k, nɛ bɛchɔŋti nnyɛ́n mmu, nɛ nɛyoŋómʉɛt nɛ ɛchɨŋti. ");
INSERT INTO kenNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Bɛbɛpti mɛnyɨŋ ɛbhɛn mɛnkɛm bɛ́fù mmu chi antɨ nɛ bɔ́ kɛ bɛ́kʉ̀ mmu akɛ bhak pɛ́pɛ́p bɛsí Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu afa yɛ nɛbhʉɛ́t wu are rɔ́ŋ atú ɛtɔk anɛ achi kɛkwɔt Táya nɛ Sídɔn. Arɔk achwe ɛkɛt ɛ́mɔt abhak arɛ́. Akɛ yáŋ mándɨŋɨ bɛ́ yi achi arɛ́. Yɛ̌ nɔ, akɛ rɔp bhɛ́sɛ́ bhɛ́sɛ́. ");
INSERT INTO kenNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ngɔrɛ́ amɔt anɛ ɛfóŋó ɛbʉ́bʉ ɛ́sɔ̀ŋɔri mɔ́ywi anɛ ngɔsɔ́ŋ aghok ɛ̌ti Yesu. Arɔk ntá yi kɛchɔŋti mpok, akwɛ́n bɛkak ɛbhi. ");
INSERT INTO kenNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ngɔrɛ́ wu apú nyaka mmu Israɛl. Bábhe yi chi atú Síria ndǔ nnɛrɛ́kɛt agho anɛ́ bábhɨ̀ŋɨ bɛ Fonísia. Anɨk Yesu mmʉɛt bɛ ambok ɛfóŋó ɛbʉ́bʉ yɔ ɛ́mfu mɔ́ywi amʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Kɛ Yesu arɛm ntá yi bɛ, “Dɔ̌ sɛ́nchíɛ kpɨ́k mǎmbɔ nɛnyíɛ́. Ɛ́pú chak bɛsɔt nɛnyíɛ́ mǎmbɔ mánchyɛ́ ntá mmú.” ");
INSERT INTO kenNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ngɔrɛ́ wu akɛmɛ yi bɛ, “Acha, ɛ́chí tɛtɛp. Kɛ mmú ɛ́nyiɛ nɔkɔ bɛchɔkɔtí ɛbhɛn bɛ́fù ntá mǎmbɔ amfay ɛ́fɛ́mɛ́ nɛnyiɛ mɛ́nkwɛnti amɨk.” ");
INSERT INTO kenNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesu arɛm bɛ, “Ɛ̌ti bɛyɔŋ ɛbhɛ ɛbhɛn, pɛtnsɛm anywɔ́p, ɛfóŋó ɛbʉ́bʉ ɛyɔ ɛ́naŋ ɛ́rɔ mɔ́ywɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Apɛtnsɛm anywɔ́p, aghɔ́ mɔ́ bhʉrɛ ndǔ ndu ɛnɛ́ ɛfóŋó ɛbʉ́bʉ yɔ ɛ́náŋ ɛ́rɔ yi. ");
INSERT INTO kenNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu arɔ atú Táya, afʉɛ́t Sídɔn achwe atú bɛtok byo anɛ bábhɨ̀ŋɨ bɛ Dikápolis, akɔ achwɔp ndǔ Manyu Gálili. ");
INSERT INTO kenNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Básɔ́t mmǔ amɔt bárɔ́k ntá yi nɛ yi. Mbaŋ yi kɛ ghók, kɛpɨ yi kɛrɛm kɔkɔ kɔkɔ. Mánɨk Yesu mmʉɛt bɛ́ ányáŋá yi amɔ anti. ");
INSERT INTO kenNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu aya yí báfá nɛntɨ bho, bárɔk nɛ́kú. Asoŋ yí kɛnɔŋámɔ batú, apá batiɛ́, atɔk nɛ́rɨ ɛni. ");
INSERT INTO kenNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yesu ayɨŋɨ mfay asɔ́k nsɔk arɛm bɛ, “Ɛfáta” nɔ chi, “Nɛnɛ́.” ");
INSERT INTO kenNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tɛ́mté wu, batú yi ánɛ́nɛ, nɛrɨ́ nɛ́káŋári yi anyu abho bɛrɛm kɛpɨ sayri. ");
INSERT INTO kenNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu asɛmti bho bɛ bákɛ́ ghati yɛ̌ mmu ɛnyɨŋ ɛnɛ ɛ́fákári. Yɛ̌ nɔ, ásɛ́mtí nɔ́kɔ́ bhɔ, mángati nɔkɔ ghati bho. ");
INSERT INTO kenNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Bo bábhák maknkay, mándɛmɛ nɔkɔ bɛ, “Yɨŋɨ́, ɛnyɨŋ ɛnɛ yí ákʉ́ ɛ́rɨ ɛcha. Ǎkʉ yɛ̌ chí bo abhɛn batú áchókó mángók mbaŋ, babhók mándɛm kɛpɨ.” ");
INSERT INTO kenNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ɛ́bhɨ́kɨ́ tat, ɛnɛ́ bɛyǎ bho bápɛt báchɛ̀m nɛbhʉɛt amɔt, Yesu abhɨŋɨ bakoŋo bhi arɛm bɛ, ");
INSERT INTO kenNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ntínso nɛ́kɛ̀m mɛ nɛ bǒbhɛn. Báchí fá nɛ mɛ ndǔ manywɔp arat, nɛ bábhɨ́kɨ́ bhɔŋ yɛ̌nyɨŋ mɛnyiɛ. ");
INSERT INTO kenNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mbák ntó bhɔ mámpɛtnsɛm kɛnyiɛ́ nɛnyíɛ́, bákway bɛgu nsay ambi, nɛ bɛyǎ bhap báfú bakɔ asiɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Bakoŋo bhi bábhɛp yi bɛ, “Ɛtɔk ɛ́pú fá, chɔŋ mmu ambɔŋ nɛnyíɛ́ ɛnɛn nɛ́kwày bǒbhɛn mankɛm fá?” ");
INSERT INTO kenNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu abhɛ́p bhɔ bɛ, “Bǎbhɔŋ bɛkpɔkɔ́ brɛt afɔ mɛni?” Bákɛmɛ yi bɛ, “Sɛ́bhɔŋ bɛkpɔk tándrámɔt.” ");
INSERT INTO kenNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesu achyɛ ɛyɔŋ bɛ bɔ́ mankɛm mánchɔ́kɔ́ amɨk. Asɔt yɛ bɛkpɔkɔ́ brɛt bhɔ tándrámɔt. Áchyɛ́ nɔ́kɔ́ bakak ntá Mandɛm, abho bɛbɔkɔti bhɔ anchyɛ nɔkɔ ntá bakoŋo bhi bɛ mánchyɛ́ ntá bo bhɔ. Báré sɔt mánkɔrɛ nɔkɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Bábhɔŋ nyaka bǎrú nsi nkwɔ. Yesu áchyɛ́ nɔkɔ bakak ntá Mandɛm, achyɛ yɔ́ ntá bakoŋo bhi bɛ mánkɔ́rɛ yɔ nkwɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Yɛ̌ntɨkɨ mmu anyíɛ́ ajwi. Baghɔkɔ́ bhi bábwɔ́pti nɛnyíɛ́ ɛnɛn nɛ́rɔ́bhɛ́, nɛ́jwí bɛkay tándrámɔt. ");
INSERT INTO kenNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Mpǎy bho abhak mbɔ nka ɛnwi. ");
INSERT INTO kenNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Yesu aghati bhɔ́ mángúrɛ́. Tɛ́mté wu, Yesu nɛ bakoŋo bhi báchwe amɛm áchwí bárɔ́k atú Dalmanúta. ");
INSERT INTO kenNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mbɔk bǒnkwɔ Fárisi bárɔk ntá Yesu bábho bɛkɛm ɛpʉ́ítí nɛ yi. Báré yaŋ mbi mɛmɔ yi. Bábhɛ́p yi ankʉ ɛnyɨŋɨ́ maknkay ɛnɛ́ ɛ́bhak mbɔ ɛrɨŋ ɛnɛ́ ɛ́tɔŋ bɛ bɛtaŋ ɛbhi bɛ́fú chi ntá Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu asɔ́k nsɔk arɛm bɛ, “Ndaká yí mkpáká bho anɛ́ ɛchɔŋ áyàŋ ɛrɨŋɨ́ maknkay? Tɛtɛp, nchí ghati bhe bɛ yɛ̌ mmu apú tɔŋ bhɔ ɛnyǔ ɛrɨŋɨ́ maknkay ɛnɛ́ bɔ báyàŋ.” ");
INSERT INTO kenNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Arɛm nɔ́kɔ́ nɔ, arɔ bhɔ́ apɛt achwe amɛm áchwi, are pé bɛ́rɔŋ ɛbhě manyu ɛ́chák. ");
INSERT INTO kenNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Bakoŋo Yesu bághɔ́kɔntɨk bɛ́pɔ́kɔ brɛt. Babhɔ̌ŋ nyaka chí mɔ́kpɔkɔ́ brɛt amɔt amɛm áchwí. ");
INSERT INTO kenNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu are sɛmti bhɔ bɛ, “Sɔt ka mpok nɛ yís bǒnkwɔ Fárisi nɛ anɛ Hɛ́rɔd.” ");
INSERT INTO kenNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Bábhó bɛrɛm nɛ batɨ bɛ, “Ǎrɛ̀m nɔ mbɔnyunɛ sɛ́bhɨ́kɨ́ bhɔ́ŋ brɛt.” ");
INSERT INTO kenNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu arɨŋɨ ɛnyɨŋ ɛnɛ bɔ́ bárɛ̀m abhɛ́p bhɔ bɛ, “Ndaká yí bárɛ̀m ɛ̌ti brɛt anɛ bǎhɨ́kɨ́ bhɔŋ? Bǎbhɨ́kɨ́re jwimɛm-ɛ? Batɨ ábhʉɛ́t be amɛm chóchókó? ");
INSERT INTO kenNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Bǎbhɔŋ chí amɨ́k ntíako? Bábhɔŋ chí batú nɛmak-a? ");
INSERT INTO kenNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Bǎghɔ́kɔ́ntɨk ndu ndɨ́kɨ́ nka bho ɛtay nɛ bɛkpɔkɔ́ brɛt bɛtay? Anɛ árɔ́bhɛ́ abhak bɛkay mɛ́ni?” Bákɛ́mɛ yi bɛ, “Bió nɛ bɛpay.” ");
INSERT INTO kenNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesu apɛt abhɛ́p bhɔ bɛ, “Nɛ mpok nkɔ́rɛ́ anɛ bɛkpɔk tándrámɔt nká bho ɛnwi ɛ́nyiɛ́, anɛ árɔ́bhɛ́ mǎnyokoti, abhak bɛkay mɛ́ni?” Bákɛmɛ yi bɛ, “Tándrámɔt.” ");
INSERT INTO kenNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Abhɛ́p bɔ́ bɛ, “Bǎbhɨ́kɨ́re jwimɛm?” ");
INSERT INTO kenNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ɛnɛ́ Yesu nɛ baghɔkɔ́ bhi bágháká Bɛtsáida, bǒfú básɔ́t nnɛ́mámɨ́k bárɔ́k ntá yi, mánɨkmʉɛt bɛ ántɔk yi. ");
INSERT INTO kenNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu akɛ́m yi ndu awɔ, aya bárɔk antí ɛtɔk. Apá yi batíɛ́ amɨ́k, anyaŋa amɔ́ anti ywi abhɛp yi bɛ, “Ɔ̌ghɔ̀ nɔ yɛ̌nyɨŋ?” ");
INSERT INTO kenNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mmu wu ayɨŋɨ mfay arɛm bɛ, “Nchí ghɔ́ bo kɛ bachi chi mbɔ bɛ mɛnɔk kɛ bɛ́kɔ̀.” ");
INSERT INTO kenNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Apɛt atɔk amɨ́k yi. Ndɔŋ yɔ, mmǔ wu ayɨŋɨ dǐǐ, apɛt abho bɛghɔ mbaŋ, nɛ are ghɔ́ yɛ̌ntɨkɨ ɛnyɨŋ sayri. ");
INSERT INTO kenNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu aghati yi bɛ ándɔk ɛkɛt ɛyi, nɛ bɛyɔŋ ɛbhɛn bɛ, “Kɛ́pɛtnsɛm ɛtɔk.” ");
INSERT INTO kenNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu nɛ bakoŋo bhi báfʉɛ́t báré rɔŋ ndǔ bɔ̌bɛtɔk abhɛn bachi kɛkwɔt Seséria Fílipi. Ambi, Yesu abhɛ́p bhɔ bɛ, “Bo bárɛ̀m bɛ mɛ nchí agha?” ");
INSERT INTO kenNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bákɛ́mɛ yi bɛ, “Mbɔk bárɛ̀m bɛ ɔchí Jɔ̌n Njwiti. Bachak bɛ Ɛláija, nɛ abhɛnɛfu bɛ ɔchí ndɛmɛkɛpɨ̌ntɨ amɔt.” ");
INSERT INTO kenNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Kɛ bě babhɔŋ bǎrɛ̀m bɛ mɛ nchí agha?” Símun Píta akɛmɛ yi bɛ, “Wɔ kɛ ɔ́chí Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎto.” ");
INSERT INTO kenNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesu asɛmti bhɔ bɛ bákɛ́ ghati yɛ̌ mmu. ");
INSERT INTO kenNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesu abho bɛghati bhɔ bɛ, “Mɛ Mmu mfú ntá Mandɛm mbɔ̌ŋ bɛghɔ bɛyǎ ɛsɔŋɔri. Bǒbati ɛtɔk, nɛ bǒbati bachiǎkap Mandɛm, nɛ batɔŋ ɛbhé Mandɛm bábyak chɔŋ mɛ nɛ mángwáy mɛ, kɛ ɛ́gháká nɔkɔ manywɔp arat, mpɛtnsɛm ndǔ nɛpɛ́m.” ");
INSERT INTO kenNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu aghati bhɔ nɔ kpoŋoroŋ. Píta asɔt yi nɛpak arɛm bɛ, “Ɛta kɛrɛm awǔ ndak.” ");
INSERT INTO kenNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kɛ ndu Yesu áyíbhírí mmʉɛt aghɔ baghɔkɔ́ bhi, aji Píta bɛ, “Satan, fá mɛ́ bɛsí! Nkaysi yɛ chi anɛ nkwǎŋwaŋ, abhɨ́kɨ́ fu ntá Mandɛm!” ");
INSERT INTO kenNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yesu abhɨŋɨ ngɛ́mtáy bho nɛ bakoŋo bhi arɛm ntá yap bɛ, “Mbák mmu ǎyaŋ bɛ́bhak nkoŋo wa, abhɔŋ bɛ́ghɔ́kɔntɨk mmʉɛt yi, ampɔkɔ ɛkotákátí yi, ankoŋo mɛ. ");
INSERT INTO kenNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yɛ̌ agha anɛ áyàŋ bɛpɛmɛ mmʉɛt yi ǎnɛm nɛpɛ́m ɛni. Kɛ yɛ̌ agha anɛ áká mɛnɛm nɛpɛ́m ɛni ɛ̌ti ya nɛ ɛ̌ti Mbok Ndɨ́ndɨ́, ǎbhɔŋ chɔŋ nɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ntɨkɨ nsáy mmu ábhɔ̀ŋ mbák abhɔŋ yɛ̌ntɨkɨ ɛnyɨŋ fá amɨk, kɛ anɛ́m nɛpɛ́m ɛni? ");
INSERT INTO kenNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nɛ mbák mmu ánɛ́m nɛpɛ́m ɛni, ntɨkɨ ɛnyɨŋ yí ákwày bɛsɔt anchyɛ bɛ yi ampɛt ambɔŋ nɔ́? ");
INSERT INTO kenNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mbák mmu abhɔ̌ŋ ntíánwɔ́p ɛ̌ti ya nɛ ɛ̌ti Ɛyɔŋ ɛya ndǔ mkpáká bho anɛ́ ápú kʉ mbɔ ɛnyu Mandɛm áyàŋ, mkpáká bho bɛbʉ́, chɔŋ Mmɛ Mmu mfú ntá Mandɛm mbɔ̌ŋ ntíánwɔ́p ɛ̌ti yi mpok nchí twɔ nɛ kɛnɛ́m Ɛtaya nɛ bɔángɛl bhi.” ");
INSERT INTO kenNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu arɔk ambɨ bɛghati ngɛ́mtáy bǒbhɔ bɛ, “Nchí ghati bhe bɛ, mbɔk bho báchi fá abhɛn bápú gu kpátɛ mángɔ ndǔ Kɛfɔ Mandɛm kɛ́twɔ̀ nɛ bɛtaŋ.” ");
INSERT INTO kenNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ɛ́fʉɛ́rɛ́ nɔ́kɔ́ manywɔp atandat, Yesu asɔt Píta, nɛ Jems nɛ Jɔ̌n, akó amfay njiɛ ngo nɛ bhɔ. Bábhák arɛ́ bɔ́bhɔ́. Bápɛ́rɛ yɨŋɨ, bɛsí Yesu bɛ́yíbhiri. ");
INSERT INTO kenNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ndɛn ɛyi nkwɔ ɛ́ré diɛrɛ pɛ́pɛ̌pɛ́p ɛnyu ɛnɛ́ yɛ̌ mmu ápú kwáy bɛso ndɛn yɛ̌ chí nɛ babhé ɛ́ndiɛrɛ ɛnyu yɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tɛ́mchok, Moses nɛ Ɛláija, barɛmɛ́ kɛpɨ̌ntɨ Mandɛm abhɛn tɛsáy, bábhési mándɛmɛ nɔkɔ kɛpɨ nɛ Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Píta abho bɛrɛm ntá Yesu bɛ, “Acha, ɛ́rɨ tontó bɛ sɛchi fá. Dɔ̌ sɛ́nté bɛ́tɛ́m barat. Ɛ́mɔt ntá yɛ, ɛ́chák ntá Moses, nɛ ɛnɛ́fú ntá Ɛláija.” ");
INSERT INTO kenNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Píta arɛm nɔ mbɔnyunɛ abhɨ́kɨ́ rɨŋɨ nyaka ɛnyɨŋ ɛchák ɛnɛ yi ábhɔ́ŋɔ́ bɛrɛm ndǔ bɛcháy bɛkɛmɛ bhɔ tontó. ");
INSERT INTO kenNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nɛrɛm anɛ Píta árɛ́mɛ́ ɛnyu yɔ, nɛbháŋ nɛ́sɛp tɛ́mté, nɛbho bɛ́kúti bhɔ. Ɛyɔŋ ɛ́fú amɛm nɛbháŋ ɛ́ndɛmɛ nɔkɔ bɛ, “Nɛ́ chí Mɔ́wa. Nkɔŋ yí tontó. Ghók ká yi!” ");
INSERT INTO kenNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tɛ́mté wu, bɔPíta báyɨ́ŋɨ, kɛ bákɛpɛrɛ ghɔ́ yɛ̌ mmu, ɛbhiki fʉɛt chi Yesu aywǐnti. ");
INSERT INTO kenNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nɛ ndǔ Yesu nɛ bɔPíta básɛ̀p njiɛ, Yesu aghati bhɔ bɛ, “Bǎkɛ́ ghati yɛ̌ mmu ɛnyɨŋ ɛnɛ bǎghɔ́ fá, kpátɛ Mmu anɛ áfú ntá Mandɛm ampɛtnsɛm ndǔ nɛpɛ́m.” ");
INSERT INTO kenNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Bábhʉ́rɛ ɛnyɨŋ ɛnɛ Yesu aghati bhɔ antɨ, bɔ́kɛ ghati yɛ̌ mmu ɛnyɨŋ ɛnɛ bághɔ. Mámbɛbhɛ nɔkɔ chi batɨ bɛ, “Nɛpɛrɛ́nsɛm ndǔ nɛpɛ́m chi yi?” ");
INSERT INTO kenNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bɔ́ bati arat bábhɛp Yesu bɛ, “Ndaká yí batɔŋ ɛbhé Moses bárɛ̀m bɛ Ɛláija abhɔŋ bɛpɛtnsɛm fá amɨk kɛ Mpɛmɛ Mandɛm afyɛ́ bariɛp bɛ ǎtó antwɔ́?” ");
INSERT INTO kenNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu akɛmɛ bhɔ bɛ, “Ɛ́chí tɛtɛp bɛ Ɛláija abhɔŋ bɛyambɨ antwɔ́, anyurɛ mɛnyɨŋ mɛnkɛm ambʉrɛ, kɛ ná básɨ́ŋɨ́ amɛm Ɛkáti Mandɛm bɛ́ Mmǔ anɛ áfú ntá Mandɛm abhɔŋ bɛ́ghɔ ɛsɔŋɔri nɛ bɛ́ bábyak chɔŋ yi? ");
INSERT INTO kenNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kɛ nchí ghati bhe bɛ Ɛláija anáŋ átwɔ nɛ bo bákʉ́ yi bɛbʉ́ mbɔ ɛnyu bákɔ́ŋɔ́ mbɔ ɛnyu básɨ́ŋɨ́ nyaka amɛm Ɛkáti Mandɛm ɛ̌ti yi.” ");
INSERT INTO kenNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ɛnɛ́ Yesu nɛ baghɔkɔ́ bhi bati arat bápɛ̀tnsɛm, bátɛ́mɛ́ri bakoŋo bhi báchák. Bághɔ́ bɛyǎ bho nɛ batɔŋ ɛbhé Moses ndu bákɛ̀m ɛpʉ́ítí nɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tɛ́mté wu, bɛyǎ bo bho mankɛm bághɔ́ nɔ́kɔ́ Yesu, bábhák maknkay tontó. Báre rɔŋ ntiɛ́t ntiɛt bɛkaka yi. ");
INSERT INTO kenNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Abhɛ́p bakoŋo bhi bɛ, “Ntɨkɨ ɛpʉ́ítí nɔ bǎkɛ̀m nɛ bhɔ?” ");
INSERT INTO kenNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Kɛ mmu amɔt amɛm nkwɔ bǒbhɔ akɛmɛ yi bɛ, “Ntɔŋ, ntwɔ̌ nɛ mɔ́wa ntá yɛ. Ɛfóŋó ɛbʉ́bʉ ɛpú ka yi andɛm kɛpɨ, ");
INSERT INTO kenNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","nɛ yɛ̌ntɨkɨ ɛbhak ɛnɛ́ ɛfóŋó yɔ ɛ́kɛ́m yi, ɛ́gʉɛp yi amɨk, bɛfɛn mɛ́mfu nɔkɔ yi anyu. Mpok yɔ, ande nyiɛ amɛn nɛ anɔkɔ. Nnɨk baghɔkɔ́ bhɛ mmʉɛt bɛ́ mámbók yɔ ɛ́ndɔ́ yi, kɛ bábhɨ́kɨ́ kway bɛkʉ nɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu akɛmɛ bhɔ bɛ, “Bě mkpaká bho anɛ ábhɨ́kɨ́ bhɔŋ nɛka nɛ mɛ, bě bho bǎyìbhiri tɛtɛp ndǔ ɛnyɨŋ ɛchak, chɔŋ mpɛt ntat nɛ bhe ná? Chɔŋ nkɛ́pntɨ nɛ bhe ngaka fá?” Kɛ ǎrɛm bɛ, “Twɔ́ ká nɛ mɔ́wu fá ntá ya.” ");
INSERT INTO kenNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Básɔt mɔ̌rɛ bárɔ́k ntá Yesu nɛ yi. Ɛfóŋó ɛbʉ́bʉ yɔ ɛghɔ nɔkɔ Yesu, tɛ́mté wu, ɛ́nyɨ́kɨ́si mɔ́wu gbogbǒgbok, akwɛ́n amɨk are bɨŋɨri, ɛfɛn ɛ́mfu nɔkɔ yi anyu. ");
INSERT INTO kenNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu abhɛ́p chimɔ bɛ, “Ɛfóŋó ɛnɛ ɛ́naŋ ɛtat yi amʉɛt ná?” Chi mɔ́wu akɛmɛ bɛ, “Tɛ kɛmbɔ́ ɛki. ");
INSERT INTO kenNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Bɛyǎ ndɔŋ ɛfóŋó ɛbʉ́bʉ yɔ ɛ́kʉ̀ yi ankwɛ́n ango. Mpokófu ɛ́kʉ yi ankwɛn anyɛ́n ndu bɛway yi. Mbák ɔ̌kway bɛkʉ ɛnyɨŋ, ghɔ bhɛsɛ́ ntínso kwak bhɛsɛ́.” ");
INSERT INTO kenNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu akɛmɛ bɛ, “Wɔ bɛ́ mbák mɛ̌kwáy bɛkʉ ɛnyɨŋɨ́! Yɛ̌ntɨkɨ ɛnyɨŋ ɛ́kway bɛkɔ ntá mmu anɛ ánókó Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tɛ́mté wu, chimɔ arɛm nɛ ɛyɔŋ amfay bɛ, “Nnókó kɛ nɛka ɛná nɛ́bhɨ́kɨ́ taŋ. Kwak mɛ nnókó sayri.” ");
INSERT INTO kenNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu ághɔ́ nɔ́kɔ́ bɛ́ bo bátwɔ̀ chi tontó tontó, ásáy ɛfóŋó ɛbʉ́bʉ yɔ bɛ, “Wɔ ɛfóŋó ɛnɛ́, ɛfóŋó kɛbhók nɛ batú chóchók, ghók. Fú yi amʉɛt, nɛ yɛ̌ ɛwak, ɔ́kɛ́ pɛrɛ twɔ́ yi amʉɛt!” ");
INSERT INTO kenNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Yesu árɛm nɔkɔ nɔ, ɛfóŋó yɔ ɛ́bɨk, ɛ́nyɨkɨsi mɔ́wu gbogbǒgbok, ɛ́fú yi amʉɛt. Arɔp mbɔ ngú. Bo abhɛn báchi arɛ barɛm bɛ, “Ágú.” ");
INSERT INTO kenNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kɛ Yesu akɛ́m yi ndu awɔ, akwak yi afate. ");
INSERT INTO kenNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu ákʉ́ nɔkɔ nɔ, achwe anywɔ́p. Bakoŋo bhi bábhɛ́p yi ansɛm ansɛm bɛ, “Ndaká yí sɛ́bhɨ́kɨ́ kway bɛbok ɛfóŋó ɛbʉ́bʉ yɔ?” ");
INSERT INTO kenNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu akɛmɛ bhɔ́ bɛ, “Ndiɛrɛ nɛ nɛnɨkímʉɛt nɛ nɛtarɛ́nsay kɛ bákway bɛkʉ ɛnyǔ ɛfóŋó ɛbʉ́bʉ ɛnɛ ɛ́mfu mmu amʉɛt.” ");
INSERT INTO kenNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu nɛ baghɔkɔ́ bhi bárɔ báre fʉɛt atú Gálili mándɔk nɔkɔ. Akɛyáŋ mándɨ́ŋɨ́ ɛbhak ɛnɛ yi achi, ");
INSERT INTO kenNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","mbɔnyunɛ, ǎtɔŋ nyaka bakoŋo bhi angati nɔkɔ bhɔ bɛ, “Bákɛ̀m chɔŋ Mmǔ anɛ áfú ntá Mandɛm mámfyɛ yi amɔ́ bǒ mmɨk mángwáy yi, nɛ ɛ́ghaka nɔkɔ manywɔp arat ampɛtnsɛm ndǔ nɛpɛ́m.” ");
INSERT INTO kenNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kɛ bɔ́ kɛjwimɛm ndǔ ɛnyɨŋ ɛnɛ yi árɛmɛ nɛ báre chay bɛbhɛp yi. ");
INSERT INTO kenNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bágháká nɔ́kɔ́ Kapɛ̌naum, báchwe anywɔ́p. Ɛnɛ́ bachi arɛ́, Yesu abhɛ́p bhɔ bɛ, “Bǎkɛ̀m mbʉ ɛpʉ́ítí ambi ɛ̌ti yi?” ");
INSERT INTO kenNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Báchɔ́kɔ kpák, mbɔnyunɛ bákɛ̀m nyaka ɛpʉ́ítí nɛ batɨ ankɔŋɔmbi ndu bɛrɨŋɨ mmǔ wap anɛ áchá báchák. ");
INSERT INTO kenNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu achɔkɔ amɨk, abhɨŋɨ bhɔ bati byo nɛ apay, abho bɛghati bhɔ bɛ, “Mmǔ ywɛka anɛ áyàŋ bɛbhak mǔngo, abhɔŋ bɛsɔt mmʉɛt yi mbɔ bɛ apu yɛ̌nyɨŋ nɛ ambak mǔbɛtok ntá bo bachak mankɛm.” ");
INSERT INTO kenNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Asɔt mandú mmɔ́ ate nɛ́ntɨ́ nap, apɔkɔ yɛ yí amʉɛt, arɛm ntá yap bɛ, ");
INSERT INTO kenNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Yɛ̌ agha anɛ ásɔ́t mmɔ́ mbɔ anɛ sayri ɛ̌ti ya, ǎsɔt chi mɛ, nɛ yɛ̌ agha anɛ ásɔ̀t mɛ sayri, ǎsɔt chi mmu anɛ átó mɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jɔ̌n árɛm ntá yi bɛ, “Ntɔŋ, sɛ́ghɔ mmu anɛ apu ndǔ nkwɔ ywɛsɛ ndu ábòk bɛfóŋó bɛbʉ́bɛbʉ ndǔ nnyɛ́n ɛna. Sɛ́gháti yi bɛ, ákɛ́pɛrɛ kʉ nɔ mbɔnyunɛ apú ndǔ nkwɔ ywɛsɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu akɛmɛ bɛ, “Bǎkɛ́ kaŋ mmu mbɔ awu mbɔnyunɛ yɛ̌ mmu apú anɛ ákʉ ɛnyɨŋɨ́ maknkay ndǔ nnyɛ́n ɛna antɨŋ anjibhiri mmʉɛt andɛm bɛbɛ́ptí mɛnyɨŋ ɛ̌ti ya. ");
INSERT INTO kenNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mmu anɛ apu nu nɛ bhɛsɛ, achí nɛ bhɛsɛ. ");
INSERT INTO kenNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Dɨŋɨ́ ká bɛ yɛ̌ agha anɛ áchyɛ́ be nkɔ́p manyiɛp mǎnyú mbɔnyunɛ bǎchí bakoŋo abhɛn Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò, apu nɔ́k bɛbhɔŋ akap.” ");
INSERT INTO kenNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yesu arɛm bɛ, “Chɔŋ ɛ́mbɛp ɛncha ntá mmu anɛ ákʉ́ mɔ́wa amɔt anɛ abhɔ́ŋɔ́ nɛka nɛ mɛ ánkwɛ́n ndǔ bɛbʉ́. Ɛchi sayri ntá mmu wu, bɛ mánsɔt ntǎy nɛgho mánsɛt ɛmɨ yi, mamɛsɛ amɛm manyu. ");
INSERT INTO kenNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Mbák awɔ ywɛ ákʉ̀ ɔnkwɛn ndǔ bɛbʉ́, kpɔ́t wu fɛrɛ! Ɛ́chí sayri bɛ ɔnchwe ndǔ nɛpɛ́m ɛnɛn nɛbhɨkɨ bhɔŋ ngwɛnti nɛ awɔ amɔt ɛcha mɛmɛsɛ wɔ amɛm nɛpǐngo anɛ apu nɛmɛ nɛ amɔ apay! ");
INSERT INTO kenNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Mbák ɛkak ɛyɛ ɛ́tò wɔ ndǔ bɛbʉ́, kpɔ́t yɔ fɛrɛ́. Ɛ́chí sayri bɛ ɔ́nchwe ndǔ nɛpɛ́m ɛnɛn nɛbhɨkɨ bhɔŋ ngwɛnti nɛ ɛkak ɛ́mɔt ɛcha bɛ́ mámɛ́sɛ wɔ amɛm nɛpǐngo nɛ bɛkak bɛpay. ");
INSERT INTO kenNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nɛ mbák nyɛ́sɛ́ ɛnɛ nɛ́kʉ̀ ɔ́nkwɛ́n ndǔ bɛbʉ́, poŋórí nɔ́ gʉɛ́p. Ɛ́chí sayri bɛ́ ɔ́nchwe ndǔ Kɛfɔ Mandɛm nɛ nyɛ́sɛ́ nɛmɔt ɛcha bɛ mámɛ́sɛ wɔ amɛm nɛpǐngo nɛ amɨ́k apay. ");
INSERT INTO kenNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Amɛm nɛpǐngo ɛnɔ, kɛ́nyɔrɛ ɛkɛn kɛ́nyiɛ bho kɛ́pú gú, nɛ ngó apu nɛmɛ. ");
INSERT INTO kenNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Chɔŋ mángoko yɛ̌ntɨkɨ mmu nɛ ngó nkúbhɛ́ mbɔ ɛnyu báfyɛ̀ ngáŋ ndǔ nɛnyíɛ́ bɛ nɛ́ndɨ́ anyu. ");
INSERT INTO kenNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ngáŋ áchí ɛrɨ́tí ɛnyɨŋ. Kɛ mbák ngáŋ ábhɨ́kɨ́ pɛrɛ bhɔŋ manyɨŋti mi, ná bákway bɛkʉ wu ampɛt ambak ɛrɨ́tɨ́ ngáŋ? Bɔ́ŋ ká ngáŋ amʉɛt, mǎnchɔkɔ ɛyɔŋ ɛ́mɔt nɛ batɨ.” ");
INSERT INTO kenNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu nɛ baghɔkɔ́ bhi bárɔ yɛ Kapɛ̌naum bárɔ́k atú Judɛ́ya. Bákɨ́ŋɨ Manyu Jɔ́dan. Ngɛ́mtay bho, bápɛt báre rɔŋ ntá yi. Are tɔ́ŋ bɔ mbɔ ɛnyǔ yi ákʉ nyaka mpoknkɛm. ");
INSERT INTO kenNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mbɔk bǒnkwɔ Fárisi bátwɔ́ mɛmɔ yi. Bábhɛ́p yi bɛ, “Ɛbhé yɛsɛ ɛ́ká bɛ mmu ándɔ́ ngɔrɛ́ ywi ndǔ nɛbhay?” ");
INSERT INTO kenNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu akɛmɛ bhɔ́ bɛ, “Moses aghati nyaka bhe bɛ yi ɛ̌ti awáy nɛbhay?” ");
INSERT INTO kenNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bákɛ́mɛ bɛ, “Moses arɛm bɛ mmu ǎkwáy bɛrɔ ngɔrɛ́ ywi mbák achyɛ́ yi ɛkáti ɛnɛ́ awáy nɛbhay?” ");
INSERT INTO kenNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu aghati bhɔ bɛ, “Chí ɛ̌ti nɛtaŋántɨ ɛnɛka kɛ Moses áchyɛ́ nyaka bhe ɛbhé ɛnɛ. ");
INSERT INTO kenNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Sayri sayri, tɛ nɛbhǒmɨk, ‘Mandɛm ághókó nyaka bo, ngɔrɛ́ nɛ mbakanɛm.’ ");
INSERT INTO kenNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ɛ̌ti yɔ, ‘Mbakanɛm abhɔŋ bɛ́rɔ́ ɛtayi nɛ máyi, ambat mmʉɛt nɛ ngɔrɛ́ ywi, ");
INSERT INTO kenNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","bɔ́ batí apay mándɔp mbɔ mmǔ amɔt. Bɔ́ kɛpɛrɛ bhak yɛ bati apay, kɛ mmǔ amɔt.’ ");
INSERT INTO kenNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mmu ákɛ́ fyɛ yɛ ákɔ́rɛ́ nɛntɨ bo abhɛn Mandɛm áchɛ́mtí.” ");
INSERT INTO kenNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yesu nɛ baghɔkɔ́ bhi bápɛ́rɛ́ nɔ́kɔ́ nsɛm anywɔ́p, baghɔkɔ́ bhi bápɛt babhɛp yi mɛnyɨŋ ɛ̌ti nkúbhɛ́ ndaka wu. ");
INSERT INTO kenNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Arɛm ntá yap bɛ, “Yɛ̌ agha anɛ árɔ́ ngɔrɛ́ ywi ndǔ nɛbhay, abháy achak, akwɛ̌n bɛrwɔp, ");
INSERT INTO kenNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","nɛ ngɔrɛ́ anɛ árɔ́ nnɛ́m abháy achak, akwɛ̌n bɛrwɔp.” ");
INSERT INTO kenNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bofú básɔ́t bɔ̌bhap bárɔ́k ntá Yesu nɛ bhɔ bɛ yi anyaŋa bhɔ amɔ anti anjɛt bhɔ. Baghɔkɔ́ bhi bábho bɛsáyti bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kɛ Yesu aghɔ nɔkɔ nɔ, ntɨ nɛ́bé yi amɛm, arɛm ntá yap bɛ, “Dɔ̌ ká mǎmbɔ mántwɔ ntá ya, bǎkɛ́ chyɛt bhɔ mbi mbɔnyunɛ bo abhɛn bachi mbɔ bhɔ kɛ̌ Mandɛm abhak Mfɔ wap.” ");
INSERT INTO kenNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","“Nchí ghati bhe bɛ, mbák mmu apú nɛ Mandɛm mbɔ ɛnyǔ mmɔ́ ábhàk nɛ ɛtayi, apú kway bɛbhak ndǔ mpǎy bho abhɛn Mandɛm achi Mfɔ wap wáwák.” ");
INSERT INTO kenNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yesu asɔt yɛ bhɔ́ amɔt amɔt, nɛ yɛntɨkɨ anɛ yi ásɔ́rɛ́ ambat amʉɛt, anyaŋa yi awɔ anti, anjɛt yi. ");
INSERT INTO kenNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ɛnɛ́ Yesu árɔ̀ŋ nɛkɔ, mmǔfú ajiɛt, arɔk, atɛp mánɛ́n bɛsí bhi, abhɛ́p yi bɛ, “Ntɔŋ, wɔ mmǔ ndɨ́ndɨ́, chɔŋ nkʉ yi kɛ mbɔ̌ŋ nɛpɛ́m ɛnɛ́n nɛbhɨkɨ bhɔŋ ngwɛnti?” ");
INSERT INTO kenNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu akɛmɛ yi bɛ “Ndaká yí ɔ́bhɨŋɨ mɛ bɛ mmǔ ndɨ́ndɨ́? Yɛ̌ mmǔ ndɨ́ndɨ́ apú. Mandɛm aywǐnti kɛ achi Ndɨ́ndɨ́. ");
INSERT INTO kenNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ɔrɨ́ŋɨ́ bɛbhé Mandɛm. Bɛ́rɛ̀m bɛ, ‘Kɛ́wáy mmu, Kɛ́kwɛn bɛrwɔp, Kɛ́ghɛ́p aghɛ́p, Kɛ́te ntísiɛ ákwárɛ́, Kɛ́nyiɛ ɛnyɨŋɨ́ mmu ndǔ bapu, Chiɛ̌ máyɛ nɛ ɛtayɛ kɛnókó.’” ");
INSERT INTO kenNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mmu wu arɛm bɛ, “Ntɔŋ, nnáŋ nchí bhʉɛrɛ bɛbhé ɛbhɛn mɛnkɛm tɛ kɛmbɔ́ ɛka.” ");
INSERT INTO kenNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu ayɨŋɨ yi nɛ bɛyǎ ɛkɔŋ arɛm bɛ, “Ɛ́rɔp chi ɛnyɨŋ ɛ́mɔt ɛnɛ́ ɔbhɔŋɔ bɛkʉ. Dɔ́k tí mɛnyɨŋ ɛbhɛ mɛnkɛm chyɛ̌ nkáp ntá bachɛ́bhɛ́bho. Mbák ɔ́nkʉ́ nɔ, chɔŋ ɔ́mbɔŋ kɛfɔ̌ mɛnyɨŋ amfay. Ɔ́ntwɔ́ yɛ ɔnkoŋo mɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ághoko nɔkɔ nɔ, apɔp, arɔbhɛ rɔ́ŋɔ́rɔŋ nɛ basɛ́mɛ́ antɨ mbɔnyunɛ abhɔ̌ŋ nyaka bɛyǎ mɛnyɨŋ ");
INSERT INTO kenNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu ayibhiri mmʉɛt arɛm ntá baghɔkɔ́ bhi bɛ, “Ɛ́be mmʉɛt tontó bɛ mǔnkáp anka Mandɛm ambak Mfɔ ywi!” ");
INSERT INTO kenNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Baghɔkɔ́ bhi bághókó nɔ́kɔ́ nɔ, mmʉɛt agú bhɔ. Kɛ Yesu apɛt arɛm ntá yap bɛ, “Bɔ̌bha, ɛ́be mmʉɛt tontó bɛ mmu anka Mandɛm ambak Mfɔ ywi! ");
INSERT INTO kenNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ɛ́chí wɨkɨrɨk bɛ mpɔŋɔ baso ámfʉɛ́t ndǔ mbok mbíábhan ɛ́cha mǔnkáp bɛka Mandɛm ambak Mfɔ ywi.” ");
INSERT INTO kenNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Bághókó nɔ́kɔ́ nɔ, mmʉɛt agú bhɔ́ tontó, bábhɛ́p yi bɛ, “Agha ákwày yɛ bɛbhɔŋ nɛpɛ́m ɛnɛ́n nɛbhɨkɨ bhɔŋ ngwɛ́nti?” ");
INSERT INTO kenNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu ayɨŋɨ bhɔ dǐǐ arɛm bɛ, “Ntá nkwǎŋwaŋ, mbi ápú, kɛ yɛ̌nyɨŋ ɛ́pú cha Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Píta asá ɛyɔŋ arɛm bɛ, “Ná nɛ bhɛsɛ́? Sɛ́rɔ́ yɛ̌ntɨkɨ ɛnyɨŋ sɛ́kòŋo wɔ!” ");
INSERT INTO kenNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu aghati bhɔ́ bɛ, “Tɛtɛ̌tɛp, mmǔ anɛ árɔ́ yɛ̌ chí ɛkɛt ɛyi, yɛ̌ chí bɔ̌mayi abhɛn babhakanɛm yɛ̌ chí abhɛn baghɔrɛ́, yɛ̌ chí máyi nɛ ɛtayi, yɛ̌ chí bɔ̌bhi, nɛ yɛ̌ chí bakɨ̌ yi ɛ̌ti ya nɛ ɛ̌ti Mbok Ndɨ́ndɨ́, ");
INSERT INTO kenNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","chɔŋ Mandɛm anchyɛ yi bɛyǎ mɛnyɨŋ fá amɨk, nɛ chɔŋ ampɛt ambɔ́ŋ bɛkɛt, bɔ̌nnɔ abhɛn babhakanɛm nɛ abhɛn baghɔrɛ́, nɛ mánɔ́, nɛ bɔ, nɛ bakɨ, ndɔŋ bɛsa bɛtay. Chɔŋ bo mánchyɛ yi bɛyǎ nɛnyok, kɛ ndǔ mmɨk nkɔ Mandɛm anchyɛ yi nɛpɛ́m ɛnɛ́n nɛbhɨ́kɨ́ bhɔŋ ngwɛ́nti. ");
INSERT INTO kenNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kɛ chɔŋ bɛyǎ bo abhɛn bachi ambɨ nɛ́nɛ, mándɔp ansɛm, nɛ abhɛn bachi ansɛm, mandɔp ambɨ.” ");
INSERT INTO kenNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu nɛ baghɔkɔ́ bhi báfa báre ko bɛrɔŋ Yerúsalɛm, yi ambɨ, bɔ́ ansɛm. Mmʉɛt agú baghɔkɔ́ bhi nɛ bɛcháy bɛ́kɛm bo abhɛn bákòŋo bhɔ. Apɛt asɔt baghɔkɔ́ bhi bati byo nɛ apay nɛpak abho bɛghati bhɔ mɛnyɨŋ ɛbhɛn bɛbhɔŋɔ bɛfakari ntá yi bɛ, ");
INSERT INTO kenNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Ghók ká, sɛ́rɔ̀ŋ nɔ chi Yerúsalɛm, nɛ mpok sɛ́gháká arɛ́, chɔŋ mánti Mmu anɛ áfú ntá Mandɛm, mánsɔt yi mamfyɛ amɔ bǒbati bachiǎkap Mandɛm nɛ ntá batɔŋ ɛbhé Moses, mándɛm bɛ mangway yi, mámfyɛ yi amɔ́ bo abhɛn bápú bo Israɛl. ");
INSERT INTO kenNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Chɔŋ mánjɔkɔ yi, mámpati batíɛ́ yi amʉɛt, mándɛn yi nɛ ɛ́kpá nɛ mángwáy yi. Kɛ ɛ́ghaka nɔkɔ manywɔp arat, ampɛtnsɛm ndǔ nɛpɛ́m.” ");
INSERT INTO kenNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jems nɛ Jɔ̌n, bɔ̌ Sɛbɛdi bárɔ́k ntá Yesu bárɛm bɛ, “Ntɔŋ, sɛ́yàŋ bɛ ɔ́nkʉ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ sɛ́nɨkmʉɛt bɛ ɔ́nkʉ ntá yɛsɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu abhɛ́p bhɔ bɛ, “Bǎyaŋ nkʉ be yi?” ");
INSERT INTO kenNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bákɛ́mɛ yi bɛ, “Kʉ ɛnyu ɛnɛ́ bɛsɛ sɛ́chɔkɔ nɛ wɔ, amɔt ɛbhé awɔ́nɛm, achák ɛbhé awɔ́ghɔ mpok ɔ́bhak ndǔ ɛnɔkɔ́ kɛfɔ ɛyɛ nɛ kɛnókó.” ");
INSERT INTO kenNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kɛ Yesu arɛm ntá yap bɛ, “Bǎbhɨ́kɨ́ rɨŋɨ ɛnyɨŋ ɛnɛ bǎyàŋ nkʉ ntá yɛka. Bǎkwáy bɛka mɛnyu nkɔ́p ɛsɔŋɔri anɛ mbɔ́ŋɔ́ mɛ́nyú? Chɔŋ mǎnkwáy bɛká bɛ́gu ɛnyu nɛwú ɛnɛn mbɔ́ŋɔ́ bɛgu?” ");
INSERT INTO kenNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bákɛ́mɛ yi bɛ, “Sɛ́kwày bɛkʉ nɔ.” Yesu arɛm ntá yap bɛ, “Tɛtɛp chɔŋ mǎnka ɛnyǔ ɛsɔŋɔri ɛnɛ mɛ̌ghɔ nɛ mǎngu ɛnyǔ nɛwú ɛnɛn mɛ̌gù, ");
INSERT INTO kenNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","kɛ mbɨ́kɨ́ bhɔŋ bɛtaŋ bɛyap bo abhɛn bábhɔŋɔ bɛchɔkɔ ɛbhé awɔ́nɛm ɛya nɛ abhɛn bábhɔŋɔ bɛchɔkɔ ɛbhé awɔghɔ. Mandɛm kɛ áchyɛ bɛbhak ɛbhɔ ntá bo abhɛn bábhɔ́ŋɔ́ bɛbhak arɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Baghɔk Yesu báchák bati byo bághókó nɔ́kɔ́ ɛnyɨŋ ɛnɛ Jems nɛ Jɔ̌n bárɛ́mɛ́, bábhó bɛběntɨ nɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu abhɨŋɨ bɔ́ mankɛm arɛm bɛ, “Bǎrɨŋɨ bɛ, ntá bǒ mmɨk, bo abhɛn básɔt bɛ báchí bafɔ, bábhɔŋ bɛyǎ bɛtaŋ amfay bǒbhap, nɛ bǒbati básɔ̀t bɛyǎ bɛtaŋ bɛkʉ bǒbhap mangok bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kɛ ɛ́bhɨ́kɨ́ bhɔŋ bɛbhak ɛnyu yɔ ndǔ nkwɔ ywɛka. Mmu anɛ áyàŋ bɛbhak mǔngo ywɛka, abhɔŋ bɛbhak mǔbɛtok ywɛka, ");
INSERT INTO kenNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","nɛ yɛ̌ntɨkɨ mmu ywɛka anɛ áyàŋ bɛbhak mmǔ mbɨ abhɔŋ bɛbhak nsɛm ywɛka, abhɔŋ bɛbhak nsɛm ntá abhɛnɛfu mankɛm. ");
INSERT INTO kenNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Yɛ̌ chi Mɛ Mmu mfú ntá Mandɛm, mbɨ́kɨ́ twɔ bɛ bo mántók mɛ. Ntwɔ chi bɛbhak mǔbɛtok nɛ bɛchyɛ nɛpɛ́m ɛnɛ ndu bɛku bɛyǎ bhó mfɛ́rɛ́ bhɔ ndǔ kɛsɛmɛ́ bɛbʉ́.” ");
INSERT INTO kenNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesu nɛ baghɔkɔ́ bhi báchwɔp Jɛríko. Ɛnɛ́ bɔ́ bárɔ́ Jɛríko bɛ́rɔŋ, ngɛ́mtay bho bare koŋo bhɔ́ ansɛm. Nnɛ́mámɨk amɔt anɛ aka nnyɛ́n bɛ Batímaɔs, mmɔ́ Timáyɔs, abhak nɛpaká mbi chɔ́kɔ́. ");
INSERT INTO kenNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ághókó nɔ́kɔ́ bɛ́ Yesu anɛ Násárɛt kɛ áfʉɛ̀t, abho bɛbɨk bɛ, “Yesu! Mmɔ̌ Mfɔ Debhít! Ghɔ́ mɛ ntínso!” ");
INSERT INTO kenNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bɛyǎ bo báre sayti yi bɛ ánchɔ́kɔ́ kpák. Kɛ akpɨk are bɨk nɛ ɛyɔŋ amfay bɛ, “Mmɔ̌ Mfɔ Debhít, ghɔ́ mɛ ntínso!” ");
INSERT INTO kenNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu ághókó nɔkɔ nɔ, ate arɛm bɛ, “Bɨŋɨ́ ká yi antwɔ́.” Bárɔk babhɨŋɨ yi bárɛm bɛ, “Faté twɔ́, ɔ́kɛ́ chay, ǎbhɨ̀ŋɨ wɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nnɛ́mámɨk wu ayók ndɛ yi amɛsɛ awu, afate, báyá yi arɔk ntá Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu abhɛ́p yi bɛ, “Ɔ̌yáŋ mɛ nkʉ́ wɔ yi?” Nnɛ́mámɨk wu akɛmɛ Yesu bɛ, “Acha, nchí yaŋ bɛ mpɛt ngɔ́ mbaŋ.” ");
INSERT INTO kenNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu arɛm yɛ ntá yi bɛ, “Gurɛ́, nɛka ɛnɛ nɛ́kʉ ɔtaŋ.” Tɛ́mté wu, abho bɛghɔ mbaŋ, nɛ abho bɛ́kóŋo Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesu nɛ baghɔkɔ́ bhi bákɔ́ baghaka ndǔ bɔ̌bɛtɔk Bɛtfágɛ nɛ Bɛ́tani ndǔ Njiɛ Mɛnok Ólif, kɛkwɔt Yerúsalɛm. Ató baghɔkɔ́ bhi bati apay ambɨ. ");
INSERT INTO kenNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Aghati bhɔ bɛ, “Dɔ́k ká ndǔ mɔ́tɔk anɛ achi afɔ ambɨ. Nɛchwe anɛ bǎchwe arɛ́, chɔŋ mǎngɔ mɔ́mpɔŋɔ batu sɛsɛ́t, anɛ yɛ̌ mmu abhɨkɨre kɔ nɛ yɔ́. Kaŋarí ká, twɔ́ nɛ yɔ́. ");
INSERT INTO kenNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mbák mmú ámbɛ́p bhe ntí anɛ bǎkàŋari yɔ́, ghatí ká yí bɛ, ‘Acha kɛ áyàŋ yɔ, nɛ chɔŋ antó mántwɔ mánkɛmɛ yɔ́ tɛ́mté.’” ");
INSERT INTO kenNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Báfa bárɔk, bághɔ mɔ́mpɔŋɔ batu wu sɛsɛ́t nɛfí ɛkɛt, nɛ́kú mbi. Bábho bɛ́kaŋarí yɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ɛ́nɛ́ bákàŋari mɔ́mpɔŋɔ batu wu, bo abhɛn báchí arɛ téé bábhɛ́p bhɔ bɛ, “Ndaká yí bǎkàŋari mɔ́mpɔŋɔ batu wu?” ");
INSERT INTO kenNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Baghɔk Yesu bágháti bhɔ ɛnyɨŋ ɛnɛ Yesu árɛ́mɛ́ mpok yi átó bhɔ. Bárɔ́ yɛ bɔ mándɔk nɛ mɔ́mpɔŋɔ batu. ");
INSERT INTO kenNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Básɔt yɔ bárɔ́k ntá Yesu. Básɔ́t ndɛn mfǎmʉɛt yap básɔbhɛri mɔ́mpɔŋɔ batu wu, Yesu achɔkɔ amfay. ");
INSERT INTO kenNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bo abhɛn bachi arɛ́, báfɛ́rɛ ndɛn mfǎmʉɛt ɛyap baghay ambi. Báchák báré kpɔt bɛ́wuɔ́kɛ́ndé mángay nɔkɔ ndǔ mbi anɛ yí áfʉɛ̀t arɛ. Báchák báré kpɔti kɛfɛ́bhɛ́ ɛkɛn kɛ́bhɔ́ŋɔ́ bɛyé mángay nɔkɔ ambi. ");
INSERT INTO kenNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ndu bárɔ̀ŋ, bo abhɛn báchi ambɨ nɛ abhɛn báchi ansɛm báre bɨk mándɛmɛ nɔkɔ bɛ, “Sɛ́mbɨ́tí Mandɛm mfay! Mandɛm ánjɛ́t mmu anɛ átwɔ̀ ndǔ nnyɛ́n Acha! ");
INSERT INTO kenNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Mandɛm ánjɛ́t kɛfɔ ɛtayɛsɛ Debhít ɛkɛn kɛ́twɔ̀! Sɛ́mbɨ́tí Mandɛm mfay!” ");
INSERT INTO kenNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Nɛchwe yí áchwé Yerúsalɛm, arɔk amɛm ɛkɛrákap Mandɛm, abyo yɛ̌ntɨkɨ ɛnyɨŋ. Ághɔ́ nɔ́kɔ́ bɛ́ mpok ǎfʉɛt, asɔt baghɔkɔ́ bhi bati byo nɛ ápay bárɔk ndu mɔ́tɔk Bɛ́tani. ");
INSERT INTO kenNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nɛ́yi nɔkɔ, ɛnɛ́ Yesu nɛ baghɔkɔ́ bhi bárɔ Bɛ́tani bápɛtnsɛm, nsay akɛ́m Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Aghɔ́ ɛnɔk fig nɛkɔ nɛsiɛ nɛ bɛyé arɛ́ gɛbhɛɛɛ, arɔk bɛyɨŋɨ mbák ǎkway bɛ́ghɔ yɛ̌ sɛpɛmɛ́nɔk arɛ. Aghaka nɔkɔ arɛ́, akɛ ghɔ́ yɛ̌nyɨŋ ɛbhɨkɨ fʉɛt chi bɛyé, mbɔnyunɛ mpok mɛnɔk fig mɛ́nyù kɛpɛm abhɨkɨ re ghaka nyaka. ");
INSERT INTO kenNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yesu arɛm ntá ɛnɔk ɛyɔ bɛ, “Bɛbho ɛchɔŋ, ɔpú pɛrɛ nyu kɛpɛm.” Baghɔk abhi bághok ɛnyɨŋ ɛnɛ yi árɛ́mɛ́. ");
INSERT INTO kenNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Baghaka nɔkɔ Yerúsalɛm, Yesu arɔk achwe amɛm ɛkɛrákap Mandɛm. Abók bakɔ̌siɛ nɛ bo abhɛn bákù mɛnyɨŋ. Atakati bɛ́fɛ́mɛ́ bo abhɛn bákɔ̀ ɛsiɛ bakáp bɛwupsi. Atakati nkwɔ́ mɛnɔk bo abhɛn bátì bɛbhóŋó, ");
INSERT INTO kenNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","nɛ akɛka bɛ́ yɛ̌ mmu ámpɔ́kɔ́ ɛnyɨŋ ámfʉɛt amɛm ɛkɛrákap Mandɛm ndu áyàŋ mbǐ mbɨŋ. ");
INSERT INTO kenNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Are tɔ́ŋ yɛ bho andɛmɛ nɔkɔ bɛ, “Pú basɨ́ŋ Mandɛm arɛm bɛ, ‘Ɛkɛt ɛya ɛ́bhɔŋ bɛbhak chi ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí ntá bo bɛtɔkɔ́ mmɨk mɛnkɛm’, kɛ bǎyíbhírí yɔ́ ɛ́rɔp chi ɛkɛt ɛnɛ́ baghɛ́p bábhɛ̀sɛ arɛ!” ");
INSERT INTO kenNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bǒbati bachiǎkap Mandɛm, nɛ batɔŋ ɛbhé Moses bághok nɔkɔ nɔ, báre yáŋ mbi bɛway yi bhɛ́sɛ́ bhɛ́sɛ́ mbɔnyunɛ báchày nyaka ngɛ́mtay bo abhɛn báchi arɛ, nɛ ntí bɛ́ bǒbhɔ bachi nyaka maknkay tontó ndǔ mɛnyɨŋ ɛbhɛn Yesu átɔ̀ŋ. ");
INSERT INTO kenNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ɛ́gháka nɔkɔ beku, Yesu nɛ baghɔkɔ́ bhi bárɔ́ ɛtɔk ɛgho báfú. ");
INSERT INTO kenNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Běti, ɛnɛ Yesu nɛ baghɔkɔ́ bhi báfʉɛ̀t bɛpɛtnsɛm, bághɔ ɛnɔk fig ɛnɛ́ Yesu arɛmɛ bɛ́ ɛpu pɛrɛ kwáy mɛ́nyu kɛpɛm, ndu ɛ́náŋ ɛ́gú tɛ nɛ bakaŋ. ");
INSERT INTO kenNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Píta atɨ́k nɔkɔ ɛnyɨŋ ɛnɛ́ Yesu árɛ́mɛ́ ntá ɛnɔk fig ɛyɔ, arɛm bɛ, “Acha, yɨŋɨ́! Ɛnɔk ɛnɛ́ ɔ́rɛ́mɛ́ bɛ ɛpu kwáy mɛnyu kɛpɛm ɛ́gu.” ");
INSERT INTO kenNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu akɛmɛ bhɔ́ bɛ, “Bɔ́ŋ ká nɛka nɛ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nchí ghati bhe bɛ, yɛ̌ agha anɛ ághàti njiɛ bɛ, ‘Fǎ fá dɔ́k kwɛ́n awu amɛm manyu,’ nɛ yí kɛ makati ndǔ ntɨ ɛni kɛ anoko bɛ Mandɛm ǎkʉ nɔ ntá yi, Mandɛm ǎkʉ yɔ ntá yi mbɔnyunɛ abhɨ́kɨ́ makati bɛ Mandɛm ǎkʉ ɛnyɨŋ ɛnɛ yi arɛmɛ ɛmfakari. ");
INSERT INTO kenNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nchí ghati yɛ bhe bɛ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ́ mǎnɨkmʉɛt bɛ Mandɛm anchyɛ bhe, nokó ká bɛ mǎnaŋ bǎbhɔŋ yɔ́ nɛ chɔŋ mǎmbɔŋ yɔ tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Yɛ̌ntɨkɨ mpok anɛ mmǔ ywɛka ánɨ̀kmʉɛt, ámfóŋórí yɛ̌ntɨkɨ mmu anɛ ákʉ́ yi bɛbʉ́. Mbák bǎkʉ̀ nɔ, chɔŋ Ɛtayɛka Mmu achi amfay ámfoŋori be nkwɔ́.” ");
INSERT INTO kenNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu nɛ baghɔkɔ́ bhi bápɛtnsɛm Yerúsalɛm. Ɛnɛ́ Yesu ákɔ̀ amɛm ɛkɛrákap Mandɛm, bǒbati bachiǎkap Mandɛm nɛ batɔŋ ɛbhé Moses nɛ bǒbati ɛtɔk bárɔ́k, ");
INSERT INTO kenNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","bábhɛp yi bɛ, “Ntɨkɨ bɛtaŋ ɔ́bhɔ́ŋɔ́ bɛkʉ mɛnyɨŋ ɛbhɛn nɛ ɔ́kʉ̀? Agha áchyɛ́ wɔ bɛtaŋ ɛbhɔ?” ");
INSERT INTO kenNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu akɛmɛ bhɔ bɛ, “Mɛ nkwɔ́ mbɔ̌ŋ ɛnyɨŋ bɛbhɛp be. Mbák mǎnkɛ́mɛ́ mɛ yɔ, chɔŋ mɛ nkwɔ ngati bhe mmu anɛ áchyɛ́ mɛ bɛtaŋ bɛkʉ mɛnyɨŋ ɛbhɛn mɛ̌kʉ̀.” ");
INSERT INTO kenNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ghatí ká mɛ, “Agha áchyɛ́ nyaka Jɔ̌n Njwiti bɛtaŋ bɛjwiti bho? Mandɛm kɛ chí bǒ mmɨk?” ");
INSERT INTO kenNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Báre kɛm ɛpʉ́ítí nɛ batɨ bɛ, “Chɔŋ sɛ́ndɛm bɛ yi? Mbák sɛ́ndɛm bɛ bɛtaŋ ɛbhɛn Jɔ̌n bɛ́fú nyaka ntá Mandɛm, ǎbhɛ́p bhɛsɛ bɛ, ‘Kɛ ndaká yí bǎbhɨ́kɨ́ noko ɛyɔŋ ɛyi?’ ");
INSERT INTO kenNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kɛ chɔŋ sɛ́ndɛm bɛ yi? Sɛ́ndɛ́m bɛ, ‘Bɛ́fǔ nyaka ntá nkwǎ?’ Bápú kway nyaka bɛrɛm ɛnyu ɛyɔ ndu báchày ngɛ́mtáy bo abhɛn báchí arɛ́ mbɔnyunɛ bɔ́ mankɛm mánoko nyaka sayri bɛ Jɔ̌n achi ndɛmɛkɛpɨ̌ntɨ Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ɛkʉ bákɛ́mɛ yi bɛ, “Sɛ́bhɨ́kɨ́ rɨŋɨ.” Yesu aghati bhɔ bɛ, “Mɛ nkwɔ́ mpú ghati yɛ bhe mmu anɛ áchyɛ́ mɛ́ bɛtaŋ bɛkʉ mɛnyɨŋ ɛbhɛn nɛ́ mɛ̌kʉ̀.” ");
INSERT INTO kenNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu abho bɛ́tɛm bɔ́ nɛkay nɛ́chák bɛ, “Mmǔfú achí nyaka. Atɨ́ nkɨ apɨ mɛnɔk vain arɛ́. Atɛp ɛbhá ɛnɛ ɛghabhɛri nkɨ ankɛm. Atɛ́m mbok aghoko nɛbhʉɛt anɛ báyàt kɛpɛm váin, bɛ nnok ywi ámfu, mánsɔt, máná mmɛm. Ate mɔ́kɛrɛ́mfay amɛm nkɨ wu bɛ́ ámbák nɛbhʉɛt anɛ mmu áchɔ̀kɔ ndǔ bɛ́bhábhɛ́ri nkɨ. Afyɛ́ yɛ bo arɛ́ bɛ mánkʉ bɛtɨk mánkɔrɛ nsáy nɛ yi. Arɔ, arɔk nɛkɔ ɛtɔk ɛchak. ");
INSERT INTO kenNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mpok bɛkɔk kɛpɛmɛ́nɔk ákwáy nɔ́kɔ́, mbɔŋɔ́nkɨ ató nkʉbɛtɨk ywi bɛ ándɔ́k ánsɔ́t aywi ákɔ́rɛ́ mbwɔt. ");
INSERT INTO kenNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kɛ bǒ bɛtɨk bhɔ kɛchyɛ. Bákɛ́m yi bádɛ́n, báfɛ́n apɛtnsɛm amɔ́ apay. ");
INSERT INTO kenNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mbɔŋɔ́nkɨ ató mmɔ̌-bɛtɨk achak. Bákɛ́m awu nkwɔ bádɛ́n báfyɛ́ yi bɛfʉɛt anti nɛ báchyɛ yi ntíánwɔ́p. ");
INSERT INTO kenNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ató anɛfu anɛ akʉ́ batí arat. Yí wu, bákɛ́m báwáy. Arɔk ambɨ bɛ́tó bakʉ̌ bɛtɨk abhɛnɛfu. Bákʉ ɛnyumɔt nɛ bhɔ́. Bádɛn mbɔk, báwáy abhɛnɛfu. ");
INSERT INTO kenNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ɛ́rɔp chi njaŋa-mɔ̌ ywi anɛ yi are kɔŋ. Ndǔ ngwɛnti, mbɔŋɔ́nkɨ arɛm nɛ mmʉɛt yi bɛ, ‘Chɔŋ ntó mbɔ̌ŋ mɔ́wa. Yɛ̌ yí, bábhɔŋ bɛ́chyɛ yi kɛnókó.’ Afɛrɛ yɛ mɔ́ywi ató. ");
INSERT INTO kenNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kɛ bǒ bɛtɨk bhɔ bághɔ nɔkɔ yi, bábho bɛrɛm nɛ batɨ bɛ, ‘Yɨŋɨ́ mbɔ̌ŋ mɔ́ywi nɛ́, nɛ yí kɛ ábhɔ́ŋɔ́ mɛnyiɛ nɛwú ɛtayi. Twɔ́ ká sɛ́nkɛm yi sɛngway bɛ́ ɛtayi ánáŋ ángú mɛnyɨŋ ɛbhi mɛ́ndɔp chi ɛbhɛsɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Mɔ́ywi wu áchwé nɔkɔ amɛm nkɨ, bákɛ́m báwáy báfɛ́mɛri ansɛm ɛbhá. ");
INSERT INTO kenNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Bǎkaysi bɛ chɔŋ mbɔŋɔ́nkɨ wu ankʉ yi ntá bo bhɔ? Chɔŋ antwɔ́ angwáy bhɔ anchyɛ nkɨ wu ntá bo bachak. ");
INSERT INTO kenNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Bǎbhɨkɨ re pay ɛnyɨŋ ɛnɛ́ basɨŋɨ ndǔ Ɛkáti Mandɛm bɛ́: ‘Nkúbhɛ́ ntay ɛnɛn batɛ̌kɛt bágʉɛ́bhɛ́ bɛ́ nɛ́bhɨ́kɨ́ rɨ, nɔ́ kɛ nɛ́rɔ́bhɛ́ ntay ɛnɛn nɛ́kɛ́mɛ́ ɛkɛt nɛchá batay áchák ankɛm? ");
INSERT INTO kenNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Chi Mandɛm Acha kɛ akʉ ɛ́mbak nɔ, nɛ chí ɛrɛmɛ́ ɛnyɨŋ ntá yɛsɛ́.’” ");
INSERT INTO kenNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yesu átɛ́m nɔ́kɔ́ nɛkay ɛnɛn, bárɨŋɨ bɛ atɛ̌m nɛkay ɛnɔ chi ɛ̌ti yap. Báre yaŋ bɛkɛm yi, kɛ ndu báchày bɛyǎ bo abhɛn báchi arɛ, bárɔ́ yi bárɔ́k. ");
INSERT INTO kenNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Bátó mbɔk bǒnkwɔ Fárisi nɛ mbɔk bo Israɛl abhɛn báté ansɛm Hɛ́rɔd ntá Yesu ndu bɛbhɛp yi mɛnyɨŋ mbɔ ntá ndu bɛkʉ yi ankwɛn anyu. ");
INSERT INTO kenNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bárɔŋ nɔkɔ ntá Yesu bárɛm bɛ, “Ntɔŋ, sɛ́rɨŋɨ bɛ ɔchí mmu tɛtɛp, nɛ ɔpú tɔŋ kɛ́rɨ́ŋámík. Sɛ́rɨ́ŋɨ́ bɛ́ ɔpú yɨŋɨ mmu ndǔ bɛsí ɔ́ncháy yi, kɛ ɔ̌tɔ̀ŋ tɛtɛp ɛ̌ti mɛnyɨŋ ɛbhɛn Mandɛm áyàŋ bo mánkʉ. Ghatí bhɛsɛ, ɛbhé yɛsɛ ɛ́ka bɛ sɛ́nchíɛ nkábhɛ́nti ntá Mfɔ Rom kɛ ɛ́bhɨ́kɨ́ ka?” ");
INSERT INTO kenNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yesu arɨŋɨ bapu amap, abhɛ́p bhɔ bɛ, “Ndaká yí mǎmɔ̀ mɛ? Tɔ́ŋ ká mɛ ɛbhɔ́kɔ́ nkáp.” ");
INSERT INTO kenNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bátwɔ́ yi nɛ ɛbhɔkɔ nkáp. Abhɛ́p bhɔ bɛ, “Ntí ághá nɛ́ arɛ́? Nɛ nnyɛ́n chi ɛnɛn ághá?” Bákɛ́mɛ yi bɛ, “Chí ntí Sísa, Mfɔ Rom. Nɛ nnyɛ́n, chi ɛni.” ");
INSERT INTO kenNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesu arɛm ntá yap bɛ, “Chiɛ́ yɛ́ ka Mfɔ Rom yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ ɛchi ɛyi, mǎnchyɛ Mandɛm yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ ɛchi ɛnɛ Mandɛm.” Bághókó nɔ́kɔ́ ɛnyɨŋ ɛnɛ Yesu arɛmɛ, bápɔ́p! ");
INSERT INTO kenNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Mbɔk bǒnkwɔ Sádusi bárɔ́k ntá Yesu babhɛp yi ɛ̌ti nɛpɛrɛ́nsɛm ndǔ nɛpɛ́m. Bǒnkwɔ Sádusi bábhɨ́kɨ́ noko nyaka bɛ chɔŋ bawú mámpɛtnsɛm ndǔ nɛpɛ́m. Babhɛp yi bɛ, ");
INSERT INTO kenNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ntɔŋ, Moses asɨŋ ndǔ ɛbhé ɛyɛsɛ bɛ mbák mmu ángú ándɔ́ ngɔrɛ́ kɛbhɔ́ŋ yɛ̌ mmɔ́, mɔ́mayi abhɔŋ bɛsɔt ngɔrɛ́ wu bɛ́ ámbé bɔ nɛ yi ndǔ nnyɛ́n manɔ anɛ ágú. ");
INSERT INTO kenNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Bɔ̌ chi amɔt bati tándrámɔt báchí nyaka. Anɛ mbɨ abháy ngɔrɛ́, agú kɛbhɔ́ŋ yɛ̌ mmɔ́. ");
INSERT INTO kenNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Anɛ ákòŋo asɔt kɛ́nkwɛ́sɛ́ wu ndǔ nɛbhay. Yí nkwɔ agú kɛrɔ mmɔ. Ɛ́fákári ɛnyumɔ́t nɛ anɛ ajwi bati arat. ");
INSERT INTO kenNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ɛnyu yɔ ɛnyu yɔ kpát mankɛm bati tándrámɔt bágú kɛrɔ yɛ̌ mɔ amɔt. Ndǔ ngwɛnti, ngɔrɛ́ wu nkwɔ agú. ");
INSERT INTO kenNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ndu ɛchi nɔ, mpok Mandɛm ákʉ̀ bawú mámpɛ́tnsɛm ndǔ nɛpɛ́m, ngɔrɛ́ wu ǎbhák anɛ agha? Ndu bɔ́ mankɛm, batí tándrámɔt, yɛ̌ntɨkɨ mmǔ wap abhǎy nyaka yi.” ");
INSERT INTO kenNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu akɛmɛ bhɔ bɛ, “Bɛkwɛ́nɛ́ bɛ́chí nɛ bhe mbɔnyunɛ bǎbhɨ́kɨ́ rɨŋɨ yɛ̌ chi Ɛyɔŋ Mandɛm nɛ yɛ̌ chi bɛtaŋ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mpok Mandɛm ákú bawú mámpɛ́tnsɛm ndǔ nɛpɛ́m, bo bábhak mbɔ bɔángɛl awu amfay. Bápú pɛrɛ bháy nɛbhay. ");
INSERT INTO kenNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nɛ bɛyɨŋɨ nɛpɛrɛ́nsɛm ndǔ nɛpɛ́m, bǎbhɨ́kɨ́ re pay amɛm ɛkáti Moses ɛ̌ti mɔ́nɔk anɛ ágò ɛbhɨ ndu ádù nyaka kɛsɔŋɔ? Bǎbhɨ́kɨ́ pay ndu Mandɛm ághátí Moses bɛ, ‘Mɛ nchí Mandɛm Ábraham, Mandɛm Áisek nɛ Mandɛm Jekɔ́p’? ");
INSERT INTO kenNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ndɛm nɔ mbɔnyunɛ yɛ̌ndu Ábraham nɛ Áisek nɛ Jekɔ́p bárɔ mmɨkɨ nɛ, báchí nɛpɛ́m, nɛ Mandɛm achi nɛ bhɔ. Mandɛm achí Mandɛm bo abhɛn bachi nɛpɛ́m. Apú Mandɛm bawú. Bě bo Sádusi bǎchi ndǔ bɛkwɛ́nɛ́ tontó!” ");
INSERT INTO kenNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ntɔŋ ɛbhé Moses amɔt achi nyaka arɛ. Aghók ndu Yesu árɛmɛ nɛ bǒ nkwɔ Sádusi. Nɛ ághókó nɔkɔ ndu Yesu ákɛ́mɛ́ bɛbhɛp ɛbhap nɛ bɛyǎ kɛboŋ abhɛ́p yi bɛ, “Ɛbhé Mandɛm ɛnɛ́ ɛ́chá bɛchak mɛnkɛm chi ɛnɛ́?” ");
INSERT INTO kenNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu akɛmɛ yi bɛ, “Ɛbhé ɛnɛ́ ɛ́chá bɛ́chák mɛnkɛm chi ɛnɛ́ ɛ́rɛ̀m bɛ, ‘Bo Israɛl, ghók ká. Mandɛm Acha anɛ ábhɔ́ŋɔ́ bhɛsɛ́ mankɛm achí amɔt.’ ");
INSERT INTO kenNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","‘Nɛ ɔbhɔŋ bɛkɔŋ Mandɛm Acha ywɛ nɛ ntɨ ɛnɛ nɛnkɛm, nɛ ɛfóŋó ɛyɛ ɛnkɛm, nɛ nkaysi yɛ nkɛm, nɛ bɛtaŋ ɛbhɛ mɛnkɛm.’ ");
INSERT INTO kenNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ɛnɛ́ ɛ́jwí bɛpay ɛ́chí mbɔ ɛyɔ nɛ ɛ́rɛ̀m bɛ, ‘Kɔ́ŋ ntɨ nkwǎ mbɔ ɛnyu ɔ́kɔ́ŋɔ́ mmʉɛt ɛyɛ.’ Ɛbhé ɛnɛ ɛ́cha ɛbhɛn bɛpay ɛpu.” ");
INSERT INTO kenNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ntɔŋ ɛbhé arɛm ntá Yesu bɛ, “Ntɔŋ ɔrɛm sáyri! Ɛ́chi tɛtɛp mbɔnyu ɔ́rɛ́mɛ́ bɛ́ Mandɛm Acha achi amɔt, achák apú. ");
INSERT INTO kenNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nɛ bɛkɔŋ Mandɛm Acha ywɛ nɛ ntɨ ɛnɛ nɛnkɛm, nɛ nkaysi yɛ nkɛm, nɛ bɛtaŋ ɛbhɛ mɛnkɛm, nɛ bɛ́ nkɔŋ ntɨ nkwǎ mbɔ ɛnyu ɔ́kɔ́ŋɔ́ mmʉɛt ɛyɛ arɨ acha. Bɛsí Mandɛm, bɛbhʉrɛ bɛbhé ɛbhɛn bɛpay achá akabhɛ́ nya bɛsɔŋ ankɛm nɛ akap achak anɛ bo báchyɛ̀ ntá yi” ");
INSERT INTO kenNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu aghɔ nɔkɔ bɛ ntɔŋ ɛbhé Mandɛm anɛ akɛmɛ yi sayri nɛ kɛboŋ, arɛm ntá yi bɛ, “Ɛ́rɔp wɔ chí mandú bɛ́rɔ Mandɛm ambak nɛ wɔ mbɔnyu Mfɔ ábhàk nɛ mmu anɛ áchí antɛn ɛyi.” Bɛbho mpok ɛyɔ, yɛ̌ mmu kɛpɛrɛ mɔ bɛbhɛp yi yɛ̌nyɨŋ. ");
INSERT INTO kenNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ɛnɛ́ Yesu átɔ̀ŋ bo Ɛyɔŋ Mandɛm amɛm ɛkɛrákap abhɛ́p bɔ́ bɛ, “Ná batɔŋ ɛbhé Mandɛm bárɛ̀m bɛ Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò chi ɛbhárɛ́mɔ Mfɔ Debhít? ");
INSERT INTO kenNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ɛfóŋó Bɛdyɛrɛ akʉ nyaka mbɔ̌ŋ Mfɔ Debhít arɛm bɛ Mandɛm Acha arɛm nyaka ntá Acha wa bɛ, ‘Chɔkɔ́ fá ɛbhě awɔ́nɛm ɛya ndǔ ɛnɔkɔ́ kɛnókó, kpatɛ nkʉ bǒmpap abhɛ mámbak mbɔ ɛnɔk ɛnɛ ɔ́nyàŋa bɛkak arɛ́.’ ");
INSERT INTO kenNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Sɛ́ghɔ̀ fá bɛ mbɔ̌ŋ Debhít ǎbhɨ̀ŋɨ nyaka Mpɛmɛ́ bɛ Acha. Ná Achǎ-rɛ áyibhiri ambak ɛbhárɛ́mɔ ywi?” Bɛyǎ bo babhɔ̌ŋ maŋák bɛ́ghok mɛnyɨŋ ɛbhɛn Yesu átɔ̀ŋ. ");
INSERT INTO kenNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ɛnɛ́ Yesu átɔ̀ŋ arɛm bɛ, “Sɔt ka mpok nɛ batɔŋ ɛbhé Moses. Bákɔŋ bɛ́ghap, mǎnkó mansɛp nɛ bɛwubhɛ wubhɛ́ ndɛn amʉɛt nɛfísiɛ bɛ bo mánkaka nɔkɔ bhɔ nɛ kɛnókó. ");
INSERT INTO kenNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Bákɔŋ nkwɔ́ bɛchɔkɔ ndǔ bɛbhaká kɛnókó amɛm bɛkɛrɛ́ nɛnɨkɨ́mʉɛt nɛ ndǔ bɛpa. ");
INSERT INTO kenNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nɛ bɔ́ bhɛrɛ kɛ mányìɛ mɛnyɨŋ mánkwɛ́sɛ́ nɛ yɛ̌ chi bɛkɛt ɛbhap ndǔ mangwɔ, mánkʉ nɔkɔ bɛrɔ́rí nɛnɨkɨ́mʉɛt bapu bɛsí bho. Chɔŋ ntɛ́msi yap anjá ancha!” ");
INSERT INTO kenNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu achi nyaka kɛ́kwɔ́t ɛkʉbhɛ́ nkáp amɛm ɛkɛrákap Mandɛm anjɨŋɨ nɔkɔ ndu bo báfyɛ̀ bakáp amɛm. Aghɔ́ ndǔ bɛyǎ bǒ nkáp bátwɔ̀, yɛ̌ntɨkɨ mmu wap amfyɛ nɔkɔ bɛyǎ nkáp amɛm. ");
INSERT INTO kenNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ɛ́tárɛ́ nɔ́kɔ́, aghɔ́ ndu kɛ́nkwɛ́sɛ́-ngɔrɛ anɛ ɛyi ɛ́pú átwɔ́, afyɛ́ bɔ̌bɛbhɔ́kɔ́ nkáp bapay abhɛn bapu yɛ̌nyɨŋ. ");
INSERT INTO kenNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu abhɨŋɨ bakoŋo bhi arɛm bɛ, “Nchí ghati bhe bɛ, akap kɛ́nkwɛ́sɛ́-nɛ ácha anɛ́ yɛ̌ntɨkɨ mmu. ");
INSERT INTO kenNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ndǔ bɛyǎ bakáp kɛ̌ yɛ̌ntɨkɨ mmu wap áfɛ́rɛ́ mandú achyɛ mbɔ akap, kɛ nchɛ́bhɛ ngɔrɛ́ nɛ achyɛ́ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ yi ábhɔ́ŋɔ́.” ");
INSERT INTO kenNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nɛfú Yesu áfú amɛm ɛkɛrákap Mandɛm, nkoŋo ywi amɔt arɛm ntá yi bɛ, “Ntɔŋ, yɨŋɨ. Báte ɛkɛrákap Mandɛm ɛnɛ-o! Batǎy anɛ́ básɔ́rɛ́ báté yɔ́ árɨ ácha!” ");
INSERT INTO kenNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu akɛmɛ yi bɛ, “Ɔghɔ̌ bɛrɛm bɛkɛt ɛbhɛn? Mpok ǎtwɔ̀ anɛ ɛkɛrákap ɛnɛ ɛ́rɔ̀ŋ amɨk ɛnkɛm yɛ̌nyɨŋ kɛrɔp téé.” ");
INSERT INTO kenNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ɛ́tárɛ́ nɔ́kɔ́, ɛnɛ́ Yesu achi chɔ́kɔ́ ɛbhě Njiɛ Mɛnok Ólif ɛnɛ ɛ́yɨŋɨ ɛkɛrákap Mandɛm, Píta nɛ Jems nɛ Jɔ̌n nɛ Andru bárɔ́k ntá yi ansɛm ansɛm. ");
INSERT INTO kenNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Bábhɛp yi bɛ, “Ɛta, ghati bhɛsɛ, chɔŋ ɛ́mfakari nɔ ntɨkɨ mpok, nɛ ntɨkɨ ɛrɨŋ ɛ́bhɔ́ŋɔ́ bɛkʉ bo mándɨŋɨ bɛ mpok anɛ ɔ́twɔ̀ arɔp kɛ́kwɔ́t.” ");
INSERT INTO kenNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu abho bɛ́ghati bhɔ bɛ, “Sɔt ka mpok bɛ́ yɛ̌ mmu ákɛ́ rwɔ́ bhe! ");
INSERT INTO kenNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bɛyǎ bo bátwɔ̀ chɔŋ mánsɔt nnyɛ́n ɛna mántɛn ambɨ, yɛ̌ntɨkɨ mmu wap andɛm nɔkɔ bɛ, ‘Mɛ kɛ nchí Mpɛmɛ anɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtó!’ Nɛ mándwɔ bɛyǎ bho bɛ mánjibhiri batɨ yap. ");
INSERT INTO kenNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nɛ mpok bǎghókó nsóŋó-nɛnu bǎkɛ́ chay. Mɛnyǔ mɛnyɨŋ ɛbhɔ bɛ́bhɔŋ bɛfakari, kɛ ɛyɔ ɛpu tɔŋ bɛ ngwɛnti mmɨk aghaka. ");
INSERT INTO kenNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Chɔŋ bɛtɔk mɛ́nu nɛ bɛtɔk bɛ́chák, bafɔ̌ ɛtɔk mánu nɛ batɨ̌ bafɔ̌ ɛtɔk nɛ chɔŋ mmɨk anyɨkɨsi ndǔ bɛyǎ bɛbhak, nsay ankwɛ́n ɛtɔk. Kɛ mɛnyɨŋ ɛbhɛn mɛnkɛm bɛchi chi mbɔ nɛbhǒnɛt ɛnɛn bɛbe ntá ngɔrɛ́ anɛ ánòŋsi. ");
INSERT INTO kenNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Kɛ sɔt ka mpok! Chɔŋ mánkɛm be mánchyɛ ntá bǒbati ɛtɔk bɔ́ mántaŋ be. Chɔŋ mángwapti bhe amɛm bɛkɛrɛ́ nɛnɨkɨ́mʉɛt. Chɔŋ mǎnte bɛsí bɔgɔ́bhanɔ nɛ bafɔ ɛ̌ti ya bɛ mǎngátí bhɔ Mbok Ndɨ́ndɨ́ ɛ̌ti ya. ");
INSERT INTO kenNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mbok Ndɨ́ndɨ́ abhɔŋ bɛ́gháka bɛtɔkɔ́ mmɨk mɛnkɛm kɛ ngwɛ́nti antwɔ́. ");
INSERT INTO kenNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Yɛ̌ntɨkɨ mpok anɛ bákɛ́mɛ́ bhe ndu bɛtaŋ be, bǎkɛ́ sɛmɛ ambɨ ambɨ bɛ, ‘Chɔŋ sɛ́ndɛm bɛ yi?’ Mpok ánkwáy, dɛm ka yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ́ ɛ́fú be anyu mbɔnyunɛ Ɛfóŋó Bɛdyɛrɛ kɛ ághàti chɔŋ be ɛnyɨŋ ɛnɛ́ bǎbhɔ́ŋɔ́ bɛrɛm. ");
INSERT INTO kenNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Chɔŋ manɔ́ anchyɛ ntɨ manɔ ntá bǒbati bɛ mángwáy. Chɔŋ mbɔk bachi mánkʉ ɛnyumɔt nɛ bɔ̌bhap. Chɔŋ mbɔk bɔ mánte nɛnu nɛ bachi nɛ manɔ bhap, mánkʉ bɛ mángwáy bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Chɔŋ mɛnyǔ bo mɛnkɛm mámpap bhe ɛ̌ti bǎchí bakoŋo bha. Kɛ mmu anɛ átè kákátí tɛ ndǔ ngwɛnti, Mandɛm ǎpɛmɛ yi.” ");
INSERT INTO kenNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesu apɛt arɛm bɛ, “Chɔŋ mǎngɔ ‘Ɛrɛm ɛnyɨŋ ɛnɛ Mandɛm ápábhɛ́’ téé ndǔ nɛbhʉɛt anɛ ɛ́bhɨkɨ bhɔŋ bɛbhak. Mpok yɔ, bo abhɛn bachi atú Judɛ́ya mámbʉ́ɛ́ mámbɛ́sɛ́ amfǎy njiɛ. Yɛ̌ntɨkɨ mmu anɛ ápáy ɛkáti-nɛ ámbʉ́rɛ́ antí, anjwimɛm. ");
INSERT INTO kenNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mpok yɔ, mbák ɛ́fákárí bɛ́ mmu ǎkʉ bɛtɨk amfay ɛkɛt ɛyi, ákɛ́ sɔŋɔri mmʉɛt bɛsɛp kpɨk bɛ andɔk amfɛrɛ mɛnyɨŋ anywɔ́p kɛ ambʉɛ. ");
INSERT INTO kenNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nɛ mmu anɛ achi ɛbhɨ ákʉ̀ bɛtɨk, ákɛ́ rɔ́ŋ kpɨ́k anywɔ́p ndu bɛbwɔp ndɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Nɛ chɔŋ ɛ́mbɛ́p ɛncha ntá baghɔrɛ́ nɛ mɛniɛ nɛ abhɛ́n bábhak nɛ bɔ amɔ mpok yɔ! ");
INSERT INTO kenNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nɨk nɔ́kɔ́ ká mmʉɛt bɛ barak anɛ ákɛ́ fakari nɛ ɛso ndu ɛ́bè mmʉɛt bɛ́bʉɛ mpok yɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Bǎkɛ́ rɔ mɛnɨkmʉɛt, mbɔnyunɛ ɛsɔŋɔri ɛnɛ́ bo bábhɔ̀ŋ mpok yɔ chi ɛnyǔ ɛsɔŋɔri ɛnɛ bábhɨ́kɨ́ re ghɔ wáwák tɛ̌ mmɨk ábhó. Nɛ mpok yɔ ánáŋ ámfʉɛ́t, ɛnyǔ ɛsɔŋɔri yɔ ɛpu pɛrɛ bhák wáwák. ");
INSERT INTO kenNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nɛ mbɔ Acha abhɨ́kɨ́ kpɔt manywɔp yɔ bɛ akɛ ya, mbʉ yɛ̌ nkwǎŋwaŋ amɔt apu rɔp nɛpɛ́m. Kɛ Mandɛm akpɔt mpok ɛsɔŋɔri yɔ mbɨŋ ɛ̌ti bo abhɛn yi áyábhɛ́ bɛ mambak abhi. ");
INSERT INTO kenNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Mpok yɔ, mbák mmu ángátí bhe bɛ, ‘Ghɔ́ ká Mpɛmɛ anɛ Mandɛm átó fá’, yɛ̌ chi bɛ, ‘Ghɔ́ yi awu!’ Bǎkɛ́ noko bɛ ɛchi tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Bǎkɛ́ noko bɛ́ ɛ́chí tɛtɛp mbɔnyunɛ chɔŋ bǒ bɛtábhá mantwɔ, yɛ̌ntɨkɨ mmu wap andɛm nɔkɔ bɛ yi kɛ achi Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò. Chɔŋ barɛmɛ́ kɛpɨ̌ntɨ nsé nkwɔ mántwɔ. Nɛ yɛ̌ntɨkɨ mmu wap ǎtwɔ, ankʉ nɔkɔ mɛnyɨŋɨ́ maknkay ndu bɛrwɔ bho. Nɛ mándwɔ́ yɛ̌ chí bǒ abhɛn Mandɛm áyábhɛ́ bɛ mámbák abhi, mbák bábhɔŋ mbi bɛkʉ nɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Sɔt yɛ ka mpok! Nnáŋ ngati nɔ bhe mɛnyɨŋ ɛbhɛn ambɨ ambɨ. ");
INSERT INTO kenNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Mbák manywɔp anɛ bɛyǎ ɛsɔŋɔri yɔ ámay, mmok ánɛm tɛ́mté, ntaŋ kɛpɛrɛ ghɔɔ, ");
INSERT INTO kenNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","mambe ámfu amfay ánkwɛnti, nɛ bɛtaŋ mfáy mɛ́nyɨkɨsi. ");
INSERT INTO kenNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nɛ chɔŋ Mmǔ anɛ áfú ntá Mandɛm ambesi ande twɔ́ amɛm nɛbháŋ nɛ bɛyǎ bɛtaŋ nɛ kɛnókó. ");
INSERT INTO kenNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Mpok yɔ, chɔŋ ntó bɔángɛl abha, mándɔk ndǔ mmɨk nkɛm, bɛbho ndǔ ɛbhɔ́kɔ́ mmɨk ɛ́mɔt bɛghaka ndu ɛchak, mánsɔt bo abhɛn Mandɛm áyábhɛ́ mánchɛm nɛbhʉɛt amɔt. ");
INSERT INTO kenNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ghɔ́k ká ɛnyɨŋ ɛnɛ ɛnɔkárɛm ɛnɛ bábhɨŋɨ bɛ́, fig ɛ́tɔ̀ŋ bhɛsɛ. Ɛ́náŋ ɛ́mbó bɛtɛm bɛtɔ́, bǎrɨŋɨ bɛ́ ɛso ɛ́rɔp chi kɛ́kwɔ́t. ");
INSERT INTO kenNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ɛ́chí ɛnyumɔt nɛ nɛtwɔ́ wa, Mɛ Mmu mfú ntá Mandɛm. Mǎnáŋ mǎngɔ ndǔ mɛnyɨŋ ɛbhɛn nɛ ngátí bhe bɛ́fàkari, dɨŋɨ́ ká bɛ mpok nɛtwɔ wa arɔp kɛkwɔt. ");
INSERT INTO kenNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nchí ghati bhe tɛtɛp bɛ mɛnyɨŋ ɛbhɛn mɛnkɛm bɛ́bhɔŋ bɛfakari, kɛ mkpáká bho abhɛn ɛchɔŋ ámfʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Chɔŋ mfay amfʉɛt, mmɨk amfʉ́ɛ́t, kɛ Ɛyɔŋ ɛya ɛ́pú fʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Yɛ̌ mmu abhɨ́kɨ́ rɨŋɨ nywɔp nɛ mbɔ̌ŋ mpok anɛ mɛnyɨŋ ɛbhɛn bɛ́fàkari chɔŋ. Bɔángɛl Mandɛm bábhɨkɨ rɨŋɨ, yɛ̌ mɛ Mmu mfú ntá Mandɛm mbɨ́kɨ́ rɨŋɨ. Ɛta Mandɛm aywǐnti kɛ árɨŋɨ. ");
INSERT INTO kenNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Sɔt yɛka mpok, mǎmbak pɛ̌ mbɔnyunɛ yɛ̌ mmu abhɨ́kɨ́ rɨŋɨ mbɔ̌ŋ nywɔp ɛnɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ɛ́chi ɛnyumɔt mbɔ mmǔ anɛ árɔ̀ŋ nɛkɔ, kɛ ápɛ́rɛ́ rɔ ɛkɛt ɛyi, arɔ yɛ̌ntɨkɨ ɛnyɨŋ amɔ bǒ bɛtɨk abhi, achyɛ yɛ̌ntɨkɨ mmu wap ayi ntí bɛtɨk. Aghati yɛ mbabhɛri nyǔbha bɛ́ ámbák pě. ");
INSERT INTO kenNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Bák yɛ́ ka pě! Bǎbhɨ́kɨ́ rɨŋɨ mbɔ̌ŋ mpok anɛ chi ɛkɛt ápɛ̀tnsɛm. Kɛ chí beku-a, kɛ nɛ nɛ́ntɨ bɛti-a, kɛ manɛ́mnkɔk-a, kɛ chi nɛyǐnywɔp-a, yɛ̌ mmu abhɨ́kɨ́ rɨŋɨ. ");
INSERT INTO kenNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ɛ́bhɨ́kɨ́ rɨ bɛ yi ántwɔ́ tɛ́mchok antɛmɛri bhe ndǔ bǎbhʉ̀rɛ kɛŋɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Mbɔ ɛnyu ngáti nɛ́ bhe, kɛ nchí ghati bo mankɛm fá amɨk: Bák ká pɛ̌.” ");
INSERT INTO kenNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ɛ́rɔp manywɔp apay ndu mɛ́nyiɛ Ɛpǎ Nɛkɨŋɨ ndu bɛ́tɨk nɛfɛrɛ Mandɛm áfɛ́rɛ́ bo Israɛl ndǔ kɛsɛm amɛm ɛtɔk Íjip, nɛ Ɛpǎ Brɛt anɛ ábhɨ́kɨ́ bhɔŋ yís. Bo bati bachiǎkap Mandɛm nɛ batɔŋ ɛbhé Moses báre yaŋ mbi bɛkɛm Yesu bhɛ́sɛ́ bhɛ́sɛ́ mangway. ");
INSERT INTO kenNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Báre rɛm bɛ, “Sɛ́kɛ́ kɛm yi mpok ɛpa mbɔnyunɛ bo bákway bɛ́chyɛ ɛsɔŋɔri.” ");
INSERT INTO kenNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu abhak ɛtɔk Bɛ́tani, amɛm ɛkɛt Símun anɛ ánáŋ ámé nyaka ɛbhaŋákwa. Ɛnɛ́ yi ányìɛ nɛnyíɛ́ arɛ́, ngɔrɛ́ amɔt atwɔ́ nɛ ɛsáyrí ɛ́kpɛ́mɛ́ bawɛrɛ́riɛp amɛn áyá nkáp. Mɔ́ngɔrɛ́ wu asiɛ́p ɛmɨ ɛ́kpɛ́mɛ́ bawɛt ɛyɔ, apɨkɨri mɔ anti Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ɛkʉ mbɔk bo abhɛn bachi arɛ chɔkɔ bábéntɨ tontó, mándɛmɛ nɔkɔ nɛ batɨ bɛ, “Mɔ́ngɔrɛ́ nɛ ǎchɔ̀ŋti bawɛrɛ́riɛp amɛn ndaká yí? ");
INSERT INTO kenNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Bákway mbʉ bɛ́ti mɔ anchyɛ nkáp anɛ́ áyá ɛ́chá nkáp anɛ nkʉbɛtɨk ányiɛ ndǔ mmiɛ, mánsɔt nkáp wu mánchyɛ ntá bachɛ́bhɛ́ bho.” Bǒbhɔ bábho bɛji mɔ́ngɔrɛ́ wu. ");
INSERT INTO kenNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kɛ Yesu arɛm bɛ, “Dɔ̌ ká yi. Ndaká yí bǎsɔŋɔri yi? Akʉ mɛ ɛrɨ́tí ɛnyɨŋ. ");
INSERT INTO kenNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Bachɛ́bhɛ́bho báchí nɛ bhe mpoknkɛm. Yɛ̌ntɨkɨ mpok anɛ mmu ákɔ́ŋɔ́, ánkwák bhɔ. Kɛ mpú bhak chɔŋ nɛ bhe mpoknkɛm. ");
INSERT INTO kenNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Akʉ ɛnyɨŋ ɛnɛ́ yi ábhɔ́ŋɔ́ mbi bɛkʉ ntá ya. Awátí mɛ nɛ bawɛrɛ́riɛp kɛ mpok bɛ́bhɛ́mɛ mɛ ankwáy. ");
INSERT INTO kenNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Dɨŋɨ́ ká tɛtɛp bɛ yɛ̌ntɨkɨ ɛbhak ɛnɛ́ bághàti Mbok Ndɨ́ndɨ́ ndǔ mmɨk nkɛm, chɔŋ bo mándɛm ɛ̌ti ɛnyɨŋ ɛnɛ́ mɔ́ngɔrɛ́ anɛ ákʉ́.” Nɛ ndǔ bo bárɛ̀m ɛ̌ti ɛnyɨŋ ɛnɛ́ yi ákʉ́, chɔŋ mántɨ́k nɔkɔ yi. ");
INSERT INTO kenNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Júdas Iskariɔt achi nyaka mmǔ amɔt ndǔ nkwɔ baghɔk Yesu bati byo nɛ apay. Afuɛ́t arɔk ntá bǒbati bachiǎkap ndu bɛti Yesu ntá yap. ");
INSERT INTO kenNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ághátí nɔ́kɔ́ bhɔ́ nkaysi yi, bábhɔ́ŋ maŋák. Báfyɛ́ bariɛp bɛ́chyɛ yi nkáp. Júdas abho bɛyaŋ yɛ mbi ndu bɛti Yesu ntá yap. ");
INSERT INTO kenNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ndǔ nywɔbhɛ́ mbɨ ɛnɛn Ɛpǎ Brɛt anɛ kɛbhɔ́ŋ yis, nɔ chi nywɔp ɛnɛn bɛway mɔ́nkwɔmɛn ndu bɛkʉ nɛnyíɛ́ Ɛpǎ Nɛkɨŋɨ, baghɔk Yesu bábhɛp yi bɛ, “Ɔ̌yaŋ sɛ́ndɔ́k sɛ́nkʉ nɛnyíɛ́ Ɛpǎ Nɛkɨŋɨ ntá yɛ fá?” ");
INSERT INTO kenNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ató baghɔkɔ́ bhi bati apay nɛ ɛyɔŋ bɛ, “Dɔ́k ká afɔ ndǔ ɛtɔk ɛgho. Arɛ́, chɔŋ mǎngɔ́ mmu anɛ ápɔ́kɔ́ ɛjɔ̌ manyiɛp. Koŋó ká yi. ");
INSERT INTO kenNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Chwe ká ndǔ ɛkɛt ɛnɛ́ yi áchwe mǎngati mbɔŋɔ́kɛt bɛ, ‘Ɛtayɛsɛ́ ato bhɛsɛ́ sɛ́mbɛp wɔ bɛ, ɛkɛrɛ́ mankɔ ɛnɛ́ yi ábhɔ́ŋɔ́ mɛ́nyiɛ Ɛpǎ Nɛkɨŋɨ nɛ baghɔkɔ́ bhi arɛ́ ɛ́chi fá?’ ");
INSERT INTO kenNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Chɔŋ antɔ́ŋ yɛ be mɔ́kɛt anɛ áchɨ́kɨ́ amfay, ndǔ ɛkɛrɛ́mfáy. Yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ sɛ́yàŋ ɛ́chí amɛm. Toŋtí ká yɛ̌ntɨkɨ ɛnyɨŋ arɛ́ ntá yɛsɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Baghɔk Yesu bhɔ bati apay bárɔk ɛtɔk ɛgho ɛyɔ. Bághɔ yɛ̌ntɨkɨ ɛnyɨŋ mbɔnyu Yesu ághati bhɔ, bákʉ nɛnyíɛ́ Ɛpǎ Nɛkɨŋɨ bábhʉrɛ. ");
INSERT INTO kenNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ɛ́gháká nɔ́kɔ́ beku, Yesu atwɔ́ nɛ baghɔkɔ́ bhi bati byo nɛ apay báchɔkɔ mɛ́nyiɛ nɛnyíɛ́ ɛpǎ ɛyɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ɛnɛ́ mányìɛ nɛnyíɛ́, Yesu arɛm bɛ, “Dɨŋɨ́ ká tɛtɛp bɛ mmu ywɛka amɔt ǎti chɔŋ mɛ. Yí wu achi fá nɛ mɛ ǎnyiɛ nɛnyíɛ́ ɛnɛn.” ");
INSERT INTO kenNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ndak anɛ ákʉ́ batɨ ábé baghɔkɔ́ bhi amɛm, bábho bɛbhɛp Yesu amɔt amɔt bɛ, “Puyɛ̌ mɛ, pú nɔ?” ");
INSERT INTO kenNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Akɛmɛ bhɔ bɛ, “Chi mmu amɔt ndǔ nkwɔ́ ywɛka batí byo nɛ apay. Yí nkwɔ ǎsɛ̀bhɛ awɔ amɛm nkúbhɛ́ ɛkpʉrɛ́ nɛnyiɛ ɛnɛ ɛ́mɔt nɛ mɛ. ");
INSERT INTO kenNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Chɔŋ Mɛ Mmu mfú ntá Mandɛm ngú mbɔ ɛnyu Ɛkáti Mandɛm ɛ́rɛ̀m. Kɛ chɔŋ ɛ́mbɛp ɛ́ncha ntá mmu anɛ áti mɛ. Ɛ́rɨ nyaka bɛ́ bákɛ́ bhe yi wáwák.” ");
INSERT INTO kenNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ɛnɛ́ Yesu nɛ baghɔkɔ́ bhi mányìɛ nɛnyíɛ́, asɔt ɛkpɔkɔ́ brɛt akɛ́m awɔ́. Achyɛ bakak ntá Mandɛm abho bɛ́bɔ́kɔ́ti anchyɛ nɔkɔ bhɔ́ nɛ bɛyɔŋ ɛbhɛn bɛ, “Sɔt ka nyiɛ́. Nɛ́ chi mmʉɛ́t ɛya.” ");
INSERT INTO kenNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Asɔt yɛ nkɔ́bhɛ́mɛ́m, áchyɛ́ nɔ́kɔ́ bakak ntá Mandɛm, abho bɛchyɛ ntá yap. Básɔ́t. Ntɨ anyǔ anchyɛ ntɨ. ");
INSERT INTO kenNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yesu arɛm yɛ bɛ, “Nɛ́ chi manoŋ ma. Ǎkʉ nku anɛ Mandɛm ányú nɛ bɔ̌bhi ántéé. ");
INSERT INTO kenNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nchí ghati bhe bɛ mpú pɛrɛ nyu mɛ̌mɛn, kpátɛ ɛwak ɛnɛ mɛ̌nyú mmɛ̌m bakɔ amɛm Kɛfɔ Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ndǔ ngwɛnti, Yesu nɛ baghɔkɔ́ bhi bákwáy nɛkwáy báchyɛ́ Mandɛm bakak. Báfú yɛ bákó amfay Njiɛ Mɛnɔk Ólif. ");
INSERT INTO kenNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Bágháká nɔ́kɔ́ ndǔ Njiɛ Mɛnɔk Ólif, Yesu aghati bhɔ bɛ, “Chɔŋ bě mankɛm mǎmfɛrɛ ntí nɛ mɛ mbɔnyunɛ Ɛkáti Mandɛm ɛ́rɛ̀m bɛ, ‘Mandɛm ǎdɛp chɔŋ mbabhɛri bághɔ́ŋɔmɛ́n angʉɛ́p amɨk, nkwɔ́ bághɔ́ŋɔmɛ́n ántaka ɛbhɨ. ");
INSERT INTO kenNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kɛ Mandɛm ánáŋ ánkʉ́ mpɛ́tnsɛm ndǔ nɛpɛ́m, chɔŋ njambɨ atú Gálili, mǎntɛmɛri mɛ arɛ́.’” ");
INSERT INTO kenNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Píta akɛmɛ bɛ, “Yɛ̌ bǒ mankɛm mámbʉ́ɛ́ wɔ, mɛ, mpú bʉɛ́!” ");
INSERT INTO kenNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu aghati Píta bɛ, “Nchí ghati wɔ bɛ, nkɔk apɛrɛ́ kok ndɔŋ ɛpay nkúbhɛ́ bɛti ɛbhɛn, chɔŋ ɔ́ndɛm ndɔŋ ɛ́rát bɛ ɔbhɨkɨ rɨŋɨ mɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Yɛ̌ nɔ, Píta arɛm nɛ ntɨ ɛni nɛnkɛm bɛ, “Yɛ̌ chí nɛwú, chɔŋ ngu nɛ wɔ. Mpú bʉɛ wɔ.” Baghɔk Yesu báchák mankɛm bárɛ́m ɛnyumɔt. ");
INSERT INTO kenNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yesu arɔk yɛ nɛbhʉɛt anɛ bábhɨ̀ŋɨ bɛ Gɛtsɛ́mani nɛ baghɔkɔ́ bhi. Arɛ́, aghati bhɔ bɛ, “Chɔkɔ́ ká fa, mɛ̌tɛn mmʉɛt ambɨ ndu mɛnɨkmʉɛt.” ");
INSERT INTO kenNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Asɔt Píta nɛ Jems nɛ Jɔ̌n arɔk nɛ bhɔ́. Arɔp nsónso nɛ basɛ́mɛ́ antɨ. ");
INSERT INTO kenNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Arɛm ntá yap batí arat bɛ, “Basɛ́mɛ́ ajwí mɛ antɨ mbɔ bɛ ǎway mɛ way. Chɔkɔ́ ká fá, mǎmbak pě nɛ mɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Arɔ bhɔ́ atɛ́n mmʉɛt ambɨ mandú. Akwɛn nɛ bɛsí amɨk, abho mɛnɨkmʉɛt, bɛ́ghɔ mbák ǎkway bɛ́fɛrɛ ɛsɔŋɔri ɛnɛ́ ɛ́chi yi ambɨ. ");
INSERT INTO kenNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ndu nɛnɨkɨ́mʉɛt ɛni arɛm bɛ, “Ɛta, Ɛtaya! Ɛnyɨŋ ɛnɛ́ ɛ́cha wɔ ɛ́pú. Kʉ nkɔ́p ɛsɔŋɔri ɛnɛ ámfʉɛ́t mɛ ansɛm nti. Kɛ ɛ́kɛ́ bhák mbɔ ɛnyǔ mɛ̌yáŋ, ɛ́mbák chi mbɔ ɛnyǔ ɔ́yàŋ.” ");
INSERT INTO kenNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Afate yɛ, apɛtnsɛm ntá baghɔkɔ́ bhi abhɛn bati arat. Aghɔ bhɔ ndu bábhʉ̀rɛ kɛnɔ́. Aŋɛmɛ bhɔ́ abhɛp Píta bɛ, “Símun, bǎbhʉrɛ chi kɛnɔ́? Bǎpú kwáy bɛ́chɔkɔ pě yɛ̌ chí ndǔ nɛŋɔkɔ́ nywɔp nɛ́mɔ́t-ɛ?” ");
INSERT INTO kenNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Aghati yɛ bhɔ bɛ, “Bák ká pě, mǎnɨk nɔkɔ mmʉɛt, bɛ́ nɛmɔ nɛ́kɛ́ dɛp be amɨk. Bǎbhɔŋ ntɨ, kɛ mmʉɛt apu bhe.” ");
INSERT INTO kenNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Apɛt arɔ bhɔ́ arɔk anɨkmʉɛt ntá Mandɛm ɛnyumɔt mbɔ ndɔŋ anɛ mbɨ. ");
INSERT INTO kenNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Apɛtnsɛm, aghɔ́ bhɔ bati arat ndu bápɛt bákwɛ́nɛ́ kɛnɔ́. Bápú kwáy nyaka bɛ́chɔ́kɔ pě ndǔ kɛnɔ́ kɛ́jwí bhɔ amɨ́k. Bɔ́ kɛrɨŋɨ ɛnyɨŋ ɛnɛ bákway bɛghati yi. ");
INSERT INTO kenNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yesu arɔ bhɔ arɔk. Ápɛ́rɛ́ nɔ́kɔ́ nsɛm ndɔŋ anɛ ajwi ɛrat, arɛm ntá yap bɛ, “Bǎbhʉɛ́t bɛbhʉrɛ kɛnɔ́? Bǎbhʉɛ́t bɛ́ywěmʉɛrɛ? Ɛ́kway nɔ! Mpok akway anɛ bákɛm Mɛ Mmu mfú ntá Mandɛm mánchyɛ ntá bǒbɛbʉ́. ");
INSERT INTO kenNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Faté ká, mmu anɛ átí mɛ anáŋ achi kɛ́kwɔ́t. Sɛ́ndɔ́k sɛ́ntɛ́mɛ́rɨ́ yi.” ");
INSERT INTO kenNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ɛnɛ́ Yesu abhʉɛ́t bɛrɛm nɔ nɛ baghɔkɔ́ bhi, ngɔ̌k aywi amɔt ndǔ abhɛn bati byo nɛ apay anɛ aka nnyɛ́n bɛ Júdas, achwɔp nɛ bɛyǎ bho. Bǒ bhɔ bábhák nɛ bɔakparɛnja nɛ nkɨ́k amɔ. Bǒbati bachiǎkap, nɛ batɔŋ ɛbhé Moses, nɛ bǒbati ɛtɔk kɛ̌ bátó nyaka bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Júdas anáŋ achyɛ́ nyaka bhɔ ɛrɨŋ ɛnɛ ɛ́kwák bɔ mándɨŋɨ Yesu. Akʉ nɔ́, ndǔ ághátí bhɔ́ bɛ, “Mmǔ anɛ mɛ̌bhɛnɛ chɔŋ chí yi. Kɛ́m ká yi mǎndɔk nɛ yi bɛ ákɛ́ bʉɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Áchúɔ́bhɛ́ nɔ́kɔ́ ɛbhak ɛnɛ́ Yesu achi, arɔk akaka yi bɛ, “Ntɔŋ!” Abhɛnɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Bǒ bhɔ barɔk *bákɛ́m Yesu bábáyti. ");
INSERT INTO kenNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kɛ mmu amɔt anɛ áchi kɛ́kwɔ́t, agwɔp akparɛnja ywi akpɔ́t atú nsɛm Mǔngo bachiǎkap Mandɛm chwát agʉɛp amɨk. ");
INSERT INTO kenNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu abhɛ́p bo abhɛn bátwɔ bɛkɛm yi bɛ, “Bátwɔ bɛkɛm mɛ nɛ bɔakparɛnja nɛ nkɨ́k mbɔ bɛ nchí ngɛ́bhɛ́ ntantaŋ? ");
INSERT INTO kenNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nchí nyaka nɛ bhe amɛm ɛkɛrákap Mandɛm nɛ́njí nɛnji ntɔŋ nɔkɔ, be kɛkɛ́m mɛ. Kɛ ɛchi ɛnyu ɛnɛ bɛ ɛnyɨŋ ɛnɛ́ básɨ́ŋɨ́ amɛm Ɛkáti Mandɛm ɛ́mfú tɛtɛp.” ");
INSERT INTO kenNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Afɔ̌ kɛ̌ baghɔkɔ́ bhi bárɔ́ yi bábʉɛ́. ");
INSERT INTO kenNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ɛsakámu amɔt abhak arɛ́ anɛ áchi nɛ ndɛn amʉɛt nɛ́nɛ́p. Are koŋo Yesu. Báyaŋ nyaka bɛkɛm yi, ");
INSERT INTO kenNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","kɛ abʉɛ́ ɛbhówɔ, ndɛn ayi arɔp bɔ́ amɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Básɔt Yesu bárɔ́k ntá mǔngo bachiǎkap Mandɛm. Bǒbati bachiǎkap Mandɛm nɛ bo batí ɛtɔk nɛ batɔŋ ɛbhé Moses báchɛm arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Píta ǎkoŋo nyaka bhɔ ansɛm nɛkɔ nɛsiɛ, kpátɛ amɛm sɛnta mǔngo bachiǎkap Mandɛm. Arɛ́, arɔk achɔkɔ nɛ babhabhɛri angɔkɔ ngó angwaka nɔkɔ ngó. ");
INSERT INTO kenNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bǒbati bachiǎkap Mandɛm nɛ bǒ ɛchɛmɛ́ bataŋá manyé bachak mankɛm báré yaŋ bo abhɛn bákway bɛbhat Yesu barak amʉɛt ɛnyu ɛnɛ́ bɔ́ bábhɔŋ mbi bɛway yi, kɛ bákɛ bhɔŋ yɛ̌ mbi. ");
INSERT INTO kenNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bɛyǎ bho bápú barak bábáy yi antí, kɛ mɛnyɨŋ ɛbhɛn bɔ́ bárɛ́mɛ́ kɛbhák ɛnyumɔt mbɔnyunɛ báchi nyaka bɛyɔŋ bɛyɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Báchák báfáte yɛ básé nsé amʉɛt Yesu bɛ, ");
INSERT INTO kenNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Sɛ́ghok ndǔ yi árɛ̀m bɛ, ‘Chɔŋ mmokoti ɛkɛrákap Mandɛm ɛnɛ báté nɛ amɔ, nɛ bɛkʉ manywɔp arat, nte ɛ́chák ɛnɛ́ puyɛ̌ bo kɛ báté.’” ");
INSERT INTO kenNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Yɛ̌ nɔ, bɔ́ nkwɔ́ kɛbhák ɛyɔŋ ɛ́mɔt. ");
INSERT INTO kenNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mǔngo bachiǎkap Mandɛm afaté bɛsí bo ɛchɛmɛ ɛyɔ abhɛ́p Yesu bɛ, “Ɔbhɨ́kɨ́ bhɔ́ŋ yɛ̌nyɨŋ bɛkɛmɛ ndǔ mɛnyɨŋ ɛbhɛn bǒ bhɛn bárɛ̀m bɛ ɔkʉ?” ");
INSERT INTO kenNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yɛ̌ nɔ́, Yesu achɔkɔ kpák, akɛrɛm yɛ̌nyɨŋ. Mǔngo bachiǎkap Mandɛm apɛt abhɛ́p yi bɛ, “Wɔ kɛ ɔ́chí Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò, wɔ kɛ ɔ́chí Mmɔ Mandɛm Mmu sɛ́bhɔ́ŋɔ́ bɛbɨti?” ");
INSERT INTO kenNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu akɛmɛ bɛ, “Chi mɛ, nɛ chɔŋ mǎngɔ Mmu anɛ áfú ntá Mandɛm chɔkɔ ndǔ ɛnɔk kɛnókó ɛbhe awɔ́nɛm Mandɛm bɛtaŋ mɛnkɛm. Chɔŋ mǎngɔ ndǔ Mmu anɛ áfú amfay átwɔ̀ amɛm nɛbháŋ.” ");
INSERT INTO kenNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Yesu akɛmɛ nɔkɔ nɔ, mǔngo bachiǎkap wu akɛ́m ndɛn ɛnɛ́ ɛ́chi yímbɔŋ amʉɛt adak. Arɛm bɛ “Sɛ́pɛ́t sɛ́yàŋ batísiɛ́ mántwɔ́ mándɛ́m ɛnyɨŋ ɛnɛ yi ákʉ́ ndaká yí? ");
INSERT INTO kenNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Bǎghok mɛnyɨŋ ɛbhɛn yi árɛ́mɛ́ ndu bɛ́tɔ̀ŋ bɛ́ ǎyɛnti mmʉɛt nɛ Mandɛm. Bǎkaysi bɛ yi? Báká ɛyɔŋ ɛ́mɔt bɛ mángwáy yi.” ");
INSERT INTO kenNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mbɔk ɛyap bábho bɛ́páti Yesu batiɛ́ amʉɛt. Básɔt ndɛn bágwɔt yi amɨ́k. Báre dɛpti yi mándɛm nɔkɔ bɛ, “Ghatí bhɛsɛ! Agha ádɛ́bhɛ́ nɔ́ wɔ?” Babhabhɛri básɔt yi. Ndu bárɔ̀ŋ, mándɛpti nɔkɔ yi. ");
INSERT INTO kenNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ɛnɛ́ Píta ábhʉɛ́t amɛm sɛnta mǔngo bachiǎkap Mandɛm, ngɔrɛ́ bɛtok aywi amɔt arɔk ɛbhak ɛnɛ Píta achi. ");
INSERT INTO kenNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ághɔ́ nɔ́kɔ́ yi ndǔ áwàk ngó, ayɨŋɨ yi dǐǐ arɛm bɛ, “Wɔ nkwɔ́ ɔchí mbʉ́ nɛ Yesu mmu Násárɛt-nɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Píta ataŋa, arɛm bɛ, “Mbɨ́kɨ́ rɨŋɨ ɛnyɨŋ ɛnɛ ɔ́rɛ̀m. Mbɨ́kɨ́ rɨŋɨ ntí nɛ nnɛt arɛ́.” Arɛm nɔkɔ nɔ, afa arɔk ate ndǔ nyǔbha ɛnɛ sɛnta, nkúbhɛ́ mpok ɛyɔ nnɛ́m nkɔk akók. ");
INSERT INTO kenNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ngɔrɛ́ bɛtok wu aghó yi arɛ́, apɛt abho bɛrɛm ntá bo abhɛn báchi arɛ téé bɛ, “Mmǔnɛ achi mmǔ ywi nkwɔ.” ");
INSERT INTO kenNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Píta apɛt ataŋa. Ɛ́bhɨ́kɨ́ tat, bo abhɛn báté arɛ́ nɛ Píta bárɛm ntá yi bɛ, “Sayri sayri, ɔchí mmǔ ywi amɔt mbɔnyunɛ wɔ nkwɔ́ ɔchí mmu Gálili!” ");
INSERT INTO kenNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ndɔŋ ayɔ, Píta arɛm bɛ, “Mandɛm ántɛ́msí mɛ mbák mɛ̌sɛ̀ chi nsé! Mbɨ́kɨ́ rɨŋɨ mbɔ̌ŋ mmú anɛ bǎrɛ̀m nɔ ɛ̌ti yi!” ");
INSERT INTO kenNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nkúbhɛ́ mpok ayɔ, nnɛ́m nkɔk akók ndɔŋ anɛ́ ajwí ɛ́pay. Píta atɨk ndǔ Yesu ághátí yi bɛ, “Nkɔk apɛrɛ́ kók ndɔŋ ɛpay, chɔŋ ɔ́ndɛm ndɔŋ ɛrat bɛ ɔbhɨ́kɨ́ rɨŋɨ mɛ.” Agbɔkɔ kɛbhɔ, are di. ");
INSERT INTO kenNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Bětí běti, bǒbati bachiǎkap Mandɛm nɛ bǒbati ɛtɔk nɛ batɔŋ ɛbhé Moses báte ɛyu nɛ nkwɔ́ ɛchɛmɛ́ bǒbati ɛtɔk báchák mankɛm. Báfyɛ́ yi ngɛm amɔ́, básɔt barɔk ntá Páílet, mmu Rom anɛ achi nyaka gɔ́bhanɔ atú Judɛ́ya mpok yɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Páílet abhɛ́p yi bɛ, “Wɔ kɛ ɔ́chí nɛ́ Mfɔ bo Israɛl?” Yesu akɛmɛ yi bɛ, “Ɛ́chí mbɔ ɛnyu ɔ́rɛ́mɛ́.” ");
INSERT INTO kenNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Bǒbati bachiǎkap Mandɛm bábhat Yesu bɛyǎ barak amʉɛt bɛsí Páílet. ");
INSERT INTO kenNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Páílet apɛt abhɛ́p yi bɛ, “Ɔ́bhɨ́kɨ́ bhɔ́ŋ yɛ̌nyɨŋ bɛ́kɛ́mɛ? Ghok bɛbɛ́pti mɛnyɨŋ ɛbhɛ́n bárɛ̀m bɛ́ ɔ̌kʉ!” ");
INSERT INTO kenNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kɛ yɛ̌nyɨŋ Yesu kɛrɛm. Páílet abhak maknkay tontó. ");
INSERT INTO kenNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Gɔ́bhanɔ abhɔ̌ŋ nyaka ɛpɨŋ bɛ yɛ̌ntɨkɨ mmíɛ́, ndǔ mpok Ɛpǎ Nɛkɨŋɨ, ǎfɛrɛ mǔkɛnɔŋ amɔt anɛ bo báyàŋ yí ámfɛ́rɛ́. ");
INSERT INTO kenNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mpok ɛyɔ bo bábhák ɛkɛrɛ́kɛnɔŋ. Báfyɛ bhɔ́ kɛnɔŋ ndu bápú noko bǒbati ɛtɔk nɛ ndu bágʉ́ɛ́bhɛ́ ɛbyɔk amɛm ɛtɔk kpát báway bho. Mmǔ wap amɔt aka nnyɛ́n bɛ́ Barábas. ");
INSERT INTO kenNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ɛká bho bárɔk ntá Páílet bɛ́ ámfɛrɛ mǔkɛnɔŋ nkúbhɛ́ mbɔnyu yi ákʉ̀ yɛ̌ntɨkɨ mmíɛ́ mpok Ɛpǎ Nɛkɨŋɨ. ");
INSERT INTO kenNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Páílet abhɛ́p bɔ́ bɛ, “Bǎyaŋ mfɛ́rɛ́ Mfɔ bo Israɛl amɔ bɛ yi andɔkɔ?” ");
INSERT INTO kenNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Páílet arɨ́ŋɨ́ nyaka sayri bɛ bǒbati bachiǎkap bákɛm Yesu bátwɔ ntá yi nɛ yi chi ɛ̌ti mpabhamɨ́k. ");
INSERT INTO kenNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Yɛ̌ nɔ, bǒbati bachiǎkap Mandɛm bákʉ ngɛ́mtáy bǒbhɔ mándɛm Páílet ámfɛrɛ chi Barábas ɛkɛrɛ́kɛnɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Páílet abhɛ́p bɔ́ bɛ, “Bǎyaŋ yɛ bɛ nkʉ yi nɛ mmu anɛ bǎbhɨŋɨ bɛ́ Mfɔ bo Israɛl?” ");
INSERT INTO kenNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Bábho bɛ́bɨk bɛ, “Dɛm mángó yi ndǔ ɛkotákátí.” ");
INSERT INTO kenNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Kɛ Páílet abhɛ́p bɔ́ bɛ, “Ntɨkɨ ɛbɛ́ptí ndak yi ákʉ́?” Kɛ ngɛ́mtáy bǒbhɔ bápɛt báre bɨk nɛ bɛtaŋ bɛ, “Dɛm mángó yi ndǔ ɛkotákátí!” ");
INSERT INTO kenNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ndu Páílet áyàŋ nyaka bɛkʉ mbɔ ɛnyǔ bɛyǎ bǒbhɔ báyàŋ, afɛrɛ Barábas ɛkɛrɛ́kɛnɔŋ. Achyɛ ɛyɔŋ bádɛ́n Yesu nɛ ɛ́kpá. Achyɛ yi ntá yap bɛ́ mángó ndǔ ɛkotákátí. ");
INSERT INTO kenNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Batɛmɛ́ nɛnu básɔt yi bárɔk amɛm áchá gɔ́bhanɔ. Bábhɨŋɨ batɛmɛ́ nɛnu báchák mankɛm nɛbhʉɛt amɔt. ");
INSERT INTO kenNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Báfyɛ́ yi nkú chu amʉɛt anɛ ágháká yi tɛ bɛkak. Básɔt bɔ̌batábhɛ́nɔk abhɛ́n báchí nsěnse mánɨ́ ntá báfyɛ yi anti bɛ chi ayǐ nta kɛfɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bábho bɛway Yesu mándɛm nɔkɔ bɛ, “Acha mfɔ bo Israɛl, kɛnókó kɛ́chí ɛkɛ ɛtá!” ");
INSERT INTO kenNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Báre dɛpti yi anti nɛ mɛnɔk. Mámpati nɔkɔ yí batiɛ́ amʉɛt nɛ mántɛp nɔkɔ mánɛ́n bɛsí bhi mbɔ́ bɛ báchyɛ̀ nɔ yi chi kɛnókó. ");
INSERT INTO kenNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Bápɔ́bhɛ́ nɔ́kɔ́ bɛ́yɔ́kɔ yi, báfɛ́rɛ nkú chu yi amʉɛt, básɔ́t ɛyi yímbɔŋ bákɛ́mɛ yi amʉɛt. Básɔ́t yɛ yi bárɔ́k bɛgo ndǔ ɛkotákátí. ");
INSERT INTO kenNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ɛnɛ́ bárɔ̀ŋ, bátɛmɛri mmǔ ɛtɔk Sírene amɔt anɛ aka nnyɛ́n bɛ́ Símun ndu áfú ɛbhɨ árɔ̀ŋ ɛtɔk. Mányiɛrɛ yi ámpɔ́kɔ́ ɛkotákátí Yesu. Símun achi nyaka chi Aleksánda nɛ Rúfɔs. ");
INSERT INTO kenNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Básɔt Yesu bárɔk ɛbhak ɛnɛ́ bábhɨ̀ŋɨ bɛ́ Golgóta, nɔ́ chi “Nɛbhʉɛt Ɛ̌nkɔ́nti.” ");
INSERT INTO kenNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Báchyɛ yi mmɛ̌m amɛn báchɔ́bhɛ́ nɛ babhé amɛn bábhɨŋɨ bɛ myrrh. Kɛ Yesu kɛnyu mɔ́. ");
INSERT INTO kenNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bágó yi ndǔ ɛkotákátí. Básɔt ndɛn ɛyi bɛkɔ́rɛ. Bágʉɛp ɛbháŋá bɛ́rɨŋɨ anɛ yɛ̌ntɨkɨ mmu wap ábhɔ́ŋɔ́ bɛ́sɔt. ");
INSERT INTO kenNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Bágó yi ndǔ ɛkotákátí mpok nywɔp nɛ́ghaka nkárɛnka nɛ́nɛnamɔt. ");
INSERT INTO kenNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Amfǎy ntí Yesu, ndǔ ɛkotákátí, ɛbhɔk ɛnɔk ɛbhak babhát. Básɨŋ arɛ́ ɛnyɨŋ ɛnɛ́ ɛ́kʉ kɛ báway yi. Básɨŋ bɛ, “Mfɔ bo Israɛl.” ");
INSERT INTO kenNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Bágó nkwɔ ngɛ́bhɛ́ ntantaŋ amɔt ndǔ ɛyi ɛkotákátí ɛbhe awɔ́nɛm Yesu. Bákʉ́ ɛnyumɔt nɛ achák ɛbhe awɔghɔ yi. ");
INSERT INTO kenNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bo abhɛn báfʉɛrɛ́ fʉɛ́t, bágháká nyaka arɛ mántě, mánka nɛ batí, mánsɔkɔti nɔkɔ yi bɛ, “Aha! Wɔ mmu ɔ́kway mɛmokoti ɛkɛrákap Mandɛm, nɛ ɔ́nte yɔ́ ndǔ manywɔp arat! ");
INSERT INTO kenNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Pɛmɛ́ mmʉɛt, nɛ fǎ ndǔ ɛkotákátí sɛp amɨk!” ");
INSERT INTO kenNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bǒbati bachiǎkap Mandɛm nɛ batɔŋ ɛbhé Mandɛm nɛ bǒbati ɛtɔk báré way nkwɔ yi, mándɛmɛ nɔkɔ nɛ batɨ bɛ, “Ápɛ̀mɛ nyaka bo báchák, kɛ apú kway bɛpɛmɛ mmʉɛt yi! ");
INSERT INTO kenNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Dɔ̌ ká sɛ́ngɔ́ ndǔ Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò, Mfɔ bo Israɛl, áfa ndǔ ɛkotákátí ansɛp amɨk. Mbák ánsɛ́p amɨk, chɔŋ sɛ́noko bɛ́ Mandɛm kɛ átó yi.” Baghɛ́p abhɛn bati apay báre sɔkɔti Yesu nkwɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ɛ́gháká nɔ́kɔ́ nkárɛ́nká byo nɛ ɛpay nɛ ngósí, ɛjuri ɛ́kwɛ́n ɛtɔk ɛnkɛm. Ɛ́bhák kpátɛ nkárɛ́nká ɛ́rát nɛ ngósí. ");
INSERT INTO kenNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ɛ́gháká nɔ́kɔ́ mbɔ nkárɛ́nká ɛyɔ ɛ́rát, Yesu abɨk arɛm bɛ, “Ɛli, Ɛli, lama sabátani?” Nɔ́ chi, “Mandɛm wa, Mandɛm wa, ndaká yí ɔ́fɛ́rɛ́ ntí nɛ mɛ?” ");
INSERT INTO kenNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Mbɔk bo abhɛn báté kɛ́kwɔ́t báyɨ̀ŋɨ, bághók nɔ́kɔ́ ndǔ Yesu ábɨ́kɨ́ ɛnyu ɛyɔ, báré rɛm nɛ batɨ bɛ, “Ghók ka, ǎbhɨŋɨ Ɛláija!” ");
INSERT INTO kenNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mmǔ wap amɔt ajiɛt arɔk asɔt ɛkuchá agwɔ́t antí mɔ́nɔk asɛbhɛ yɔ́ amɛm ɛchyɛ́ mmɛ́m. Asá amfay, atɛmɛ Yesu anyu bɛ́ ánsɔ́k. Arɛm bɛ, “Dɔ̌ sɛ́ngɔ́ mbák Ɛláija ǎtwɔ̀ bɛfɛrɛ yi ndǔ ɛkotákátí nɛ.” ");
INSERT INTO kenNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu ábɨ́kɨ́ nɔ́kɔ́, asɛbhɛ. ");
INSERT INTO kenNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nkúbhɛ́ mpok yɔ, ɛkát ɛnɛ ɛchi amɛm ɛkɛrákap Mandɛm ɛ́ghárɛ bɛbhɔk bɛpay bɛfu amfay bɛghaka amɨk. ");
INSERT INTO kenNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mǔnti nkwɔ batɛmɛ́ nɛnu bɛsa bɛtay anɛ áté áyìŋɨ Yesu aghɔ́ ɛnyu yi ágú. Ɛkʉ arɛm bɛ, “Tɛtɛp, mǔnɛ achi mbʉ chi Mmɔ Mandɛm!” ");
INSERT INTO kenNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Baghɔrɛ́ fú báté nɛkɔ nɛsiɛ mánjɨŋɨ nɔkɔ. Mbɔk ɛyap báchi nyaka María anɛ ɛtɔk Magdala, nɛ Salóme nɛ María nnɔ Jems anɛ mɔ́nkwɛn nɛ Jóses. ");
INSERT INTO kenNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Baghɔrɛ́ bhɔ bákòŋo nyaka Yesu mánchyɛ nɔkɔ yi nɛkwak bɛbhó mpok anɛ yi áchi atú Gálili. Bɛyǎ baghɔrɛ́ báchak abhɛn bákóŋó nyaka Yesu Yerúsalɛm bábhak arɛ́ nkwɔ́. ");
INSERT INTO kenNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ɛ́ghaka beku ndǔ Nywɔp Ntoŋtí, ɛnɛ́ bátɔ̀ŋti mmʉɛt bɛ́chwe ndǔ nywɔbhɛ́ nɛywěmʉɛt, ");
INSERT INTO kenNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Josɛ́f mmǔ Arimátia amɔt, afa nɛ nɛtaŋántɨ arɔk ntá Páílet bɛ ánchyɛ́ yi bɛtaŋ ámfɛrɛ Yesu amfay ɛkotákátí. Josɛ́f achi nyaka mmǔ ɛchɛm ɛgho ɛnɛ bǒbati ɛtɔk anɛ abhɔŋɔ kɛnókó bɛsí bho, nɛ ǎnoŋ nyaka mpok anɛ Mandɛm átwɔ̀ ambak Mfɔ ntá bo abhɛn bachi abhi. ");
INSERT INTO kenNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Páílet ághókó nɔ́kɔ́ ɛnyɨŋ ɛnɛ Josɛ́f árɛ́mɛ́, abhak maknkay bɛ́rɨŋɨ bɛ́ Yesu agu. Abhɨŋɨ mǔntí batɛmɛ́ nɛnu anɛ aghɔ ndu Yesu ágù, abhɛ́p yi mbák anáŋ agu tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mǔntí batɛmɛ́ nɛnu wu aka bɛ́ anáŋ agu. Páílet aghati yɛ Josɛ́f bɛ́ ǎkway bɛ́rɔŋ bɛfɛrɛ ɛrɛnɛ Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josɛ́f arɔk aku ɛ́síɛndɛn. Afɛrɛ yi asɛbhɛ amɨk. Anɛ́p nɛ ɛ́síɛndɛn ɛyɔ, arɔk afyɛ́ yi amɛm nnɛm ɛnɛ́n bátɛ́mɛ́ ndǔ sɛtárɛ́bhɛ́. Afú abɨŋɨri yɛ ɛrɛmɛ́ ntay akuti nyǔnɛm. ");
INSERT INTO kenNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María anɛ ɛtɔk Magdala nɛ María nnɔ Jóses bághɔ́ nɛbhʉɛt anɛ bábhʉrɛ Yesu. ");
INSERT INTO kenNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nywɔbhɛ́ nɛywěmʉɛt nɛfʉɛrɛ nɔkɔ, baghɔrɛ́ bati arat báku bawɛrɛ́riɛp ndu bɛrɔŋ bɛwati Yesu amʉɛt. Bábhák María anɛ ɛtɔk Mágdala nɛ María nnɔ Jems nɛ Salome. ");
INSERT INTO kenNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Bětí běti ndǔ nywɔbhɛ́ mbɨ amɛm Sɔ́nde, báfú báre rɔŋ ndǔ nnɛm. Báchwɔp arɛ́ mpok mmok ánáŋ áfúú ");
INSERT INTO kenNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ɛnɛ́ bɔ́ bárɔ̀ŋ, báre rɛm nɛ batɨ bɛ, “Agha ábɨŋɨri chɔŋ ntay amfɛrɛ anyu nnɛm ntá yɛsɛ?” ");
INSERT INTO kenNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Bárɛ̀m nyaka nɔ mbɔnyunɛ ntay ɛnɔ nɛ́chɨk nyaka tontó. Bápɛ́rɛ chwɔp arɛ́, bághɔ́ bɛ́ bábɨŋɨri nɔ nɛ́rɔp chi nɛpak. ");
INSERT INTO kenNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Baghɔrɛ́ bhɔ báchwe amɛm nnɛm, bághɔ ɛsakámu chɔkɔ ɛbhe awɔ́nɛm ɛyap nɛ nkú pɛ́pɛ́p amʉɛt. Bɛcháy bɛ́kɛ́m bɔ́ tontó. ");
INSERT INTO kenNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ɛsakámu ɛyɔ ɛ́ghati bhɔ́ bɛ, “Bǎkɛ́ cháy! Ndɨ́ŋɨ́ bɛ́ bǎyàŋ Yesu anɛ Násárɛt anɛ bágó ndǔ ɛkotákátí. Apú fá. Mandɛm akʉ yi apɛtnsɛm ndǔ nɛpɛ́m nkúbhɛ́ mbɔ ɛnyǔ yi árɛ́mɛ́ nyaka bɛ ɛbhɔŋ bɛfakari. Twɔ́ ká ghɔ nɛbhʉɛt anɛ bábhʉ́rɛ́ yi. ");
INSERT INTO kenNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Dɔ́k yɛ ka ghati bakoŋo bhi, sayri sayri Píta, bɛ́ achi be ambɨ ǎrɔ̀ŋ atú Gálili. Chɔŋ mǎngɔ yi arɛ́, nkúbhɛ́ mbɔnyu yi ágháti nyaka bhe.” ");
INSERT INTO kenNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Baghɔrɛ́ bhɔ báfú ndǔ nnɛm báre rɔ́ŋ ntiɛ́t ntiɛt mángwɛrɛ nɔkɔ nɛ bábhak maknkay tontó. Bɛcháy bɛkʉ bɔ́ kɛrɛm yɛ̌nyɨŋ ntá mmu. ");
INSERT INTO kenNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu áfú nɔkɔ ndǔ nɛwú beti bheti ndǔ nywɔbhɛ́ mbɨ ndǔ sɔ́nde, ayambɨ atɔ́ŋ mmʉɛt ntá María anɛ ɛtɔk Magdala. Yi kɛ achi nyaka ngɔrɛ́ anɛ Yesu ábókó bɛfóŋó bɛbʉ́bɛbʉ tándrámɔt bɛ́rɔ yi. ");
INSERT INTO kenNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","María arɔk aghati ndak anɛ ntá bo abhɛn bákɔ̀ nɔkɔ nyaka nɛ Yesu. Atɛmɛri bɔ́ ndǔ básɛ̀mɛ mándi nɔkɔ. ");
INSERT INTO kenNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kɛ bághoko nɔkɔ bɛ Yesu apɛtnsɛm ndǔ nɛpɛ́m nɛ bɛ́ María aghɔ yi, bákɛ noko bɛ́ ɛchi tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ɛ́tat nɔkɔ, Yesu abhɛsi ɛnyu ɛchak bɛsí bakoŋo bhi bati apay abhɛn báfu ɛtɔk ɛgho bákɔ mándɔkɔ nɔkɔ ndu mɔ́tɔk ɛbhɨ. ");
INSERT INTO kenNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ɛ́tat nɔkɔ, bárɨŋɨ ɛnyu mmu yi áchi. Bápɛtnsɛm ɛtɔk ɛgho bágháti bakoŋo bhi báchák, kɛ yɛ̌ mmu wap kɛ noko bɛ ɛchi tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ansɛm mpok, ɛnɛ́ bakoŋo bhi batí byo nɛ amɔt mányìɛ nɛnyíɛ́, Yesu afú bhɔ bɛsí. Are bé nɛ bhɔ nɛ ntí bɛ bágwɔt batɨ yap nɛ bábhɨ́kɨ́ noko bɛ yi apɛtnsɛm ndǔ nɛpɛ́m mbɔ ɛnyǔ bo abhɛn báyámbɨ baghɔ yi bágháti bhɔ́. ");
INSERT INTO kenNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Aghati yɛ̌ bhɔ bɛ, “Dɔ́k ká ndǔ bɛtɔkɔ́ mmɨk mɛnkɛm ghati nɔkɔ ká Mbok Ndɨ́ndɨ́ ntá bǒ mankɛm. ");
INSERT INTO kenNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Yɛ̌ agha anɛ ánókó Mbok Ndɨ́ndɨ́ nɛ bǎjwíti yi, Mandɛm ǎpɛmɛ yi ndǔ bɛbʉ́ bɛ ámbák mmǔ ywi mpoknkɛm. Kɛ mmu anɛ abhɨkɨ ka mɛnoko, Mandɛm ǎchyɛ yi ntɛmsi ndǔ bɛbʉ́ bhi bɛbhʉɛt nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Chɔŋ bo abhɛn mánókó mámbɔŋ bɛtaŋ bɛ́kʉ mɛnyɨŋɨ́ maknkay. Chɔŋ mámbok bɛfóŋó bɛbʉ́bɛbʉ ndǔ nnyɛ́n ɛna, chɔŋ mándɛm bɛyɔŋɔ́tɔk ɛbhɛn bábhɨkɨ rɨŋɨ ndǔ nnyɛ́n ɛna. ");
INSERT INTO kenNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Mbák mǎnkɛ́m nnyɔ́ nɛ awɔ, apú kʉ bhe yɛ̌nyɨŋ, nɛ mbák mǎnyú ɛnyɨŋ ɛnɛ́ ɛ́wày mmu, ɛ́pú kʉ bhe yɛ̌nyɨŋ. Chɔŋ mǎnyaŋa bǒmame amɔ́ anti mántaŋ.” ");
INSERT INTO kenNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Yesu Acha ánáŋá nɔkɔ bɛ́rɛm kɛpɨ nɛ baghɔkɔ́ bhi, Mandɛm asɔt yi apɛtnsɛm amfay, achɔkɔ ndǔ ɛnɔkɔ́ kɛnókó ndu ɛbhe awɔ́nɛm Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Bakoŋo Yesu bárɔ́bhɛ́ nɔkɔ, báre kɔ mángati nɔkɔ Mbok Ndɨ́ndɨ́ mbǎnkɛm. Yesu Acha abhak nɛ bhɔ, achyɛ bhɔ bɛtaŋ bɛkʉ mɛnyɨŋɨ́ maknkay ndu bɛtɔŋ bɛ Mbok Ndɨ́ndɨ́ anɛ bɔ bághàti bho achi tɛtɛp.");
INSERT INTO kenNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ɛta Tiófilɔs: Ɔrɨ́ŋɨ́ bɛ bɛyǎ mámɔ bɛsɨŋ mɛnyɨŋ ɛbhɛn bɛfakari ndǔ nkwɔ ywɛsɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Básɨŋ ɛ̌ti mɛnyɨŋ ɛbhɛn bo abhɛn bághɔ́ nɛ bágháti bhɛsɛ. Batísyɛ́ bhɔ bághɔ nyaka barak ayɔ tɛ nɛbhǒnɛt, kɛ bábhak bǒ bɛtok ndu bɛ́gháti bho Ɛyɔŋ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ɛta, mbɔ ɛnyǔ mɛmbɔ̌ŋ nkwɔ́ nnáŋ nkóŋó mɛnyɨŋ ɛbhɛn mɛnkɛm sayri ndǔ ɛrɔri mpok, nkáysí bɛ́ ɛrɨ bɛ nsɨŋ ngati wɔ ɛnyɨŋ ɛ́mɔt ɛ́mɔt ɛnyu ɛfakari. ");
INSERT INTO kenNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nchí sɨŋ bɛkʉ ɔndɨŋɨ tɛtɛp anɛ ayɨŋɨ mɛnyɨŋ ɛbhɛn bághátí wɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mpók anɛ Hɛ́rɔd achí mfɔ atú Judɛ́ya, nchiakap Mandɛm abhak anɛ áká nnyɛ́n bɛ́ Sakaría. Ǎkʉ̀ nyaka bɛtɨk Mandɛm nɛ nkwɔ bo abhɛn babhɨŋɨ bɛ Nkwɔ́ Abíja. Nnyɛ́n ngɔrɛ́ ywi nɛbhak bɛ Ɛlísabɛt. Yí nkwɔ afú ndǔ nnɛrɛ́kɛt Arɔn, nnɛrɛ́kɛt bachiǎkap Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakaría nɛ ngɔrɛ́ ywi babhak chak bɛsí Mandɛm. Bábhɔŋ kɛnókó nɛ Mandɛm, mámbʉrɛ nɔkɔ bɛbhé bhi mɛnkɛm bɛkwɛ́nɛ́ ti. ");
INSERT INTO kenNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kɛ bɔ́ kɛbhɔŋ yɛ̌ mmɔ́ mbɔnyunɛ Ɛlísabɛt achí nyaka nkongɔrɛ́, nɛ bɔ́ bati apay mánáŋ nyaka bákɔk. ");
INSERT INTO kenNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ɛwak ɛ́mɔt, nkwɔ́ bachiǎkap anɛ́ Sakaría bábhák ndǔ bɛtɨk. Ɛkʉ Sakaría are kʉ bɛtɨk mbɔ nchiakap bɛsí Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Bɛ́kóŋo ɛpɨŋ ɛnɛ́ bachiǎkap Mandɛm, bágʉɛp nyaka ɛbháŋá ndu bɛyap mmu anɛ árɔ̀ŋ ndǔ mɔ́kɛt anɛ achi tɛ amɛm ɛkɛrákap Acha ndu bɛsɔŋ ɛnyɨŋ ɛnɛ ɛ́chyɛ̀ ɛrɨ́tí ɛriɛp amɛm ɛkɛrákap Mandɛm. Bagʉɛp ɛbháŋá, ɛ́kwɛ́n amʉɛt Sakaría. ");
INSERT INTO kenNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mpok ákwáy nɔkɔ, bo bachɛm nɛfí ɛkɛrákap Mandɛm. Báre nɨkmʉɛt ɛnɛ́ Sakaría achi amɛm ásɔ̀ŋ ɛnyɨŋ ɛrɨ́tí ɛriɛp ɛyɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ángɛl Mandɛm abhesi ntá yi, ate ɛbhe áwɔnɛm, ndǔ nɛbhʉɛt ɛfɛmɛ-akap atú anɛ básɔ̀ŋ ɛnyɨŋ ɛrɨ́tí ɛriɛp ɛyɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Mpok Sakaría ághɔ́ yi achayti, bɛcháy bɛ́kɛ́m yi tontó. ");
INSERT INTO kenNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kɛ ángɛl wu arɛm ntá yi bɛ, “Sakaría, ɔ́kɛ́ cháy! Mandɛm aghok nɛnɨkɨ́mʉɛt ɛnɛ. Nɛ chɔŋ ngɔrɛ́ ywɛ Ɛlísabɛt ampɔkɔ mɛniɛ ambé wɔ mɔ́mbakanɛm, nɛ ɔbhɔŋ bɛ́du yi nnyɛ́n bɛ́ Jɔ̌n. ");
INSERT INTO kenNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nɛ chɔŋ ɔ́mbɔ́ŋ bɛyǎ maŋák; nɛ bɛyǎ bo mámbɔŋ maŋák mpok bábhé yi. ");
INSERT INTO kenNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Chɔŋ ɛ́mbak nɔ mbɔnyunɛ yi ǎbhák chɔŋ ɛrɛmɛ́mu bɛsí Acha. Bápɛrɛ́ bhé yí, chɔŋ Ɛfóŋó Bɛdyɛrɛ ambak nɛ yi tontó. Abhɨ́kɨ́ bhɔŋ mɛ́nyú mmɛ́m amɛn ákɛ̀m mmu, nɛ yɛ̌ chí mmɛm bataŋbataŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Chɔŋ anja bɛyǎ bo Israɛl, mámpɛtnsɛm ntá Mandɛm Acha wap. ");
INSERT INTO kenNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Chɔŋ Mɔ́wu anjambɨ kɛ Acha antwɔ́, nɛ chɔŋ yí ambɔ̌ŋ bɛtaŋ ɛbhɛn Ɛfóŋó mbɔ ndɛmɛkɛpɨ̌ntɨ Ɛláija, bɛ́ yi ankʉ bachǐbhɔ mánkɔŋ bǒbhap, ankʉ bo abhɛn bátàŋti nɛ Mandɛm mámbɔ́ŋ kɛboŋ, mámbak mbɔ bo abhɛn bachi chak bɛsí Mandɛm. Chɔŋ yí ankʉ bo mámbák ndǔ nté anɛ bákway bɛsyɛpti Acha.” ");
INSERT INTO kenNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Kɛ Sakaría abhɛ́p ángɛl bɛ, “Chɔŋ ndɨ́ŋɨ́ bɛ́ anɛ́ ndak achí tɛtɛp ná. Mɛ nɛ ngɔrɛ́ wa sɛ́kɔk tontó.” ");
INSERT INTO kenNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ángɛl akɛmɛ Sakaría bɛ, “Dɨŋɨ́ bɛ́ mɛ nchí Gábriɛl. Nchí téé bɛsí Mandɛm, nɛ yímbɔŋ kɛ átó mɛ bɛ ngati wɔ mbok ndɨ́ndɨ́ nɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kɛ ɔbhɨ́kɨ́ noko ɛnyɨŋ ɛnɛ ngati wɔ, ɛnɛ́ ɛ́bhɔ́ŋɔ́ bɛfu tɛtɛp mbák mpok akway. Tɛ̌ndu ɔ́bhɨ́kɨ́ noko, chɔŋ ɔ́nkwɛ́n kɛbhók ɔkɛpɛrɛ kwáy bɛrɛm kɛpɨ kpátɛ nywɔp ɛnɛ́n bariɛp amɛn áfu tɛtɛp.” ");
INSERT INTO kenNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ndǔ mpok yɔ bo abhɛn báchyɛ̀ Mandɛm bakak nɛfí ɛkɛrákap bare noŋ Sakaría mámakati nɔkɔ ɛnyɨŋ ɛnɛ ɛkʉ yi áre tat amɛm ɛkɛrákap. ");
INSERT INTO kenNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Áfú nɔ́kɔ́, akɛpɛrɛ kwáy bɛrɛm kɛpɨ nɛ bhɔ. Are mak nɛ amɔ́ ntá yap. Bághɔ́ bɛ aghɔ̌ kɛnɔ́ amɨ́k anti fúú amɛm ɛkɛrákap. ");
INSERT INTO kenNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Mpok anɛ Sakaría ábhak ndǔ bɛtɨk áfúɛ́rɛ́ nɔ́kɔ́, agurɛ anywɔ́p. ");
INSERT INTO kenNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ɛ́bhɨ́kɨ́ tat, ngɔrɛ́ ywi Ɛlísabɛt apɔkɔ mɛniɛ. Yí kɛfú nɛfí ndǔ bataŋ átáy andɛm nɔkɔ bɛ, ");
INSERT INTO kenNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Nɛ́nɛ, Ɛta Mandɛm atɔŋ mɛ bɛrɨ̌ndu. Afɛ́rɛ́ ntíánwɔ́p anɛ́ mɛ̌bhɔ̀ŋ nyaka bɛsí bho.” ");
INSERT INTO kenNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mpok mɛniɛ Ɛlísabɛt bɛghaka bataŋ atandat, Mandɛm ató ángɛl Gábriɛl ɛtɔk Násárɛt, atú Gálili. ");
INSERT INTO kenNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ató yi ntá ngɔsɔ́ŋ anɛ aka nnyɛ́n bɛ María. Abhɨ́kɨ́ re rɨŋɨ nyaka mbakanɛm. Mmu anɛ áká nnyɛ́n bɛ Josɛ́f anɛ áfú ndǔ nnɛrɛ́kɛt Mfɔ Debhít atɨ nyaka bɛbhay María. ");
INSERT INTO kenNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ángɛl wu átwɔ́ nɔ́kɔ́ ntá yi arɛm bɛ, “Mmá, nkáká! Mandɛm ayɛt wɔ tontó!” Acha achí nɛ wɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","María aghoko nɔkɔ nɔ, ntí átáka yi amɛm, are bhɛp mmʉɛt ɛyi bɛ́, “Ntɨkɨ ɛnyǔ bakak nɛ!” ");
INSERT INTO kenNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ángɛl arɛm bɛ, “María, ɔ́kɛ́ cháy. Mandɛm atɔŋ wɔ bɛrɨ̌ndu. ");
INSERT INTO kenNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Chɔŋ ɔ́mpɔkɔ mɛniɛ, ɔ́mbe mɔ́mbakanɛm, nɛ ɔbhɔŋ bɛbhɨŋɨ yí bɛ Yesu. ");
INSERT INTO kenNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","“Chɔŋ yi ambak ɛrɛmɛ́mu nɛ chɔŋ nnyɛ́n ɛni nɛmbak bɛ Mmɔ Mandɛm Acha. Chɔŋ Ɛta Mandɛm anchyɛ yí ɛnɔkɔ́ kɛfɔ ɛnɛ́ Debhít mmu yi achi ɛbhárɛ́mɔ ywi. ");
INSERT INTO kenNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nɛ chɔŋ ankɛ́m bo Israɛl mbɔ Mfɔ mpoknkɛm. Kɛfɔ ɛki kɛ́bhɨ́kɨ́ bhɔŋ ngwɛnti!” ");
INSERT INTO kenNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","María abhɛ́p ángɛl wu bɛ, “Chɔŋ anɛ́ ndak ámbak ná, ɛnɛ́ mbɨ́kɨ́ rɨŋɨ mbakanɛm?” ");
INSERT INTO kenNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ángɛl akɛmɛ yi bɛ, “Chɔŋ Ɛfóŋó Bɛdyɛrɛ ántwɔ́ ntá yɛ, nɛ bɛtaŋ Mandɛm Acha mɛ́nkʉ ɔ́mpɔkɔ mɛniɛ. Ɛ̌ti yɔ, mmɔ́ anɛ ɔ́bhe, ǎbhák nyáŋá nɛ mámbɨŋɨ yi bɛ, ‘Mmɔ Mandɛm.’ ");
INSERT INTO kenNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Yɨŋɨ́ Ɛlísabɛt, mánɔ́ ywɛ ndu nnɛrɛkɛt. Yɛ̌ndu yi are kɔ́k nɛ bábhɨ̀ŋɨ yi bɛ́ nkongɔrɛ́, achí nɛ mɛniɛ ndǔ bataŋ átándát nɛ́nɛ, nɛ chɔŋ ambé mɔ́mbakanɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Yɛ̌nyɨŋ ɛpu cha Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","María arɛm bɛ, “Mɛnchí chí mǔbɛtok Mandɛm, ɛ́mfákárí nɛ mɛ mbɔ ɛnyu ɔ́rɛ́mɛ́.” Ángɛl arɔ yɛ yi arɔk. ");
INSERT INTO kenNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ɛ́bhɨ́kɨ́ tat, María afa, arɔk áyák, ndǔ ɛtɔk njiɛ ɛmɔ́t atú Júda. ");
INSERT INTO kenNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Áchwɔ́bhɛ́ nɔ́kɔ́ arɛ́, arɔk achwe ɛkɛt Sakaría, akaka Ɛlísabɛt; ");
INSERT INTO kenNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mpok Ɛlísabɛt aghoko bakak María, mmɔ́ ayoŋ mmʉɛt amɛm mɛniɛ ɛbhi nɛ Ɛfóŋó Bɛdyɛrɛ abhak nɛ yi tontó. ");
INSERT INTO kenNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Abɨk nɛ bɛtaŋ arɛm ntá María bɛ, “Ɔchí anɛ Mandɛm áyɛ́rɛ́ ndǔ nkwɔ baghɔrɛ́, nɛ áfɔ́k ámbák nɛ mmɔ̌ anɛ ɔ́bhe chɔŋ! ");
INSERT INTO kenNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ndé kʉ yi bɛ Mandɛm anchyɛ mɛ ɛnɛ́ ɛnyǔ ɛrɛm áfɔ́k, bɛ́ nnɔ Acha ántwɔ́ ntá ya? ");
INSERT INTO kenNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nɛchwe ɔ́chwé ɔ́káká mɛ, mmɔ́ anɛ achi mɛ mɛniɛ ayoŋ mmʉɛ́t nɛ maŋák. ");
INSERT INTO kenNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ɛ́rɨ ɛcha ntá yɛ́ mbɔnyunɛ ɔnókó bɛ́ chɔŋ Mandɛm ankʉ ntá yɛ mbɔ ɛnyu yí árɛ́mɛ́.” ");
INSERT INTO kenNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","María abho bɛ́bɨti Acha bɛ, “Ntɨ ɛna nɛ́kwày ndu bɛ́káka Mandɛm Acha nɛ maŋák. ");
INSERT INTO kenNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ɛfóŋó ɛya ɛ́ŋàk ɛ̌ti Mandɛm Mpɛmɛ wa. ");
INSERT INTO kenNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Atɔŋ mɛ bɛyǎ bɛrɨ̌ndu yɛ̌ndu nchí chí mmɔ̌bɛtok ywi nɛ mpú yɛ̌nyɨŋ! Nɛbho nɛ́nɛ, chɔŋ mkpáká bho ɛnkɛm mámbɨŋɨ mɛ bɛ, ‘Ngɔrɛ́ anɛ ɛyi ɛrɨ ɛcha!’ ");
INSERT INTO kenNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","mbɔnyunɛ Mandɛm bɛtaŋ mɛnkɛm, akʉ bɛyǎ mɛnyɨŋɨ́ maknkay ntá ya. Nɛ yí achí nyáŋá. ");
INSERT INTO kenNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ǎghɔ̀ ntínso nɛ bǒ abhɛn báchyɛ̀ yi kɛnókó, ndǔ mkpáká bho ɛnkɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Akʉ bɛtaŋtí mɛnyɨŋ nɛ awɔ́ ywi, aták bo abhɛn báyòŋ mmʉɛ́t nɛ nkaysi anɛ achi amɛm batɨ̌ yap. ");
INSERT INTO kenNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Afɛ́rɛ́ bɛrɛmɛ́ bafɔ ndǔ mɛnɔkɔ́ kɛfɔ ɛbhap, ákosi bo abhɛn bápú yɛ̌nyɨŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Achyɛ́ bɛrɨ́tí mɛnyɨŋ ntá bo abhɛn nsay ánù bhɔ, abók abhɛn bábhɔ́ŋɔ́, bárɔk amɔ amɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Mandɛm akwak bo Israɛl, bǒ bɛtok bhi. Abhɨ́kɨ́ ghɔkɔntɨk bariɛp ami ntá bachǐmbɨ bhɛsɛ bɛ chɔŋ angɔ bhɔ ntínso. ");
INSERT INTO kenNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Abhɨ́kɨ́ ghɔkɔntɨk bɛghɔ Ábraham ntínso, nɛ bɛbhárɛ́ bɔ̌bhi mankɛm, mpoknkɛm!” ");
INSERT INTO kenNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María achɔkɔ nɛ Ɛlísabɛt ndǔ bataŋ árát, kɛ ǎpɛtnsɛm ɛkɛt ɛyi. ");
INSERT INTO kenNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mpok anɛ Ɛlísabɛt ábhɔ́ŋɔ́ bɛ́bhé ákwáy nɔkɔ, abhé mɔ́mbakanɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Bakokosi bhi nɛ bǒnɛrɛ́kɛt, bághók nɔ́kɔ́ ɛnyǔ bɛrɨ̌ntɨ ɛbhɛ́n Mandɛm átɔ́ŋɔ́ yí, báré ŋák nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mmɔ ágháká nɔ́kɔ́ manywɔp ánɛn, bo bárɔ́k bɛ́siɛ́p yi. Báre yàŋ bɛdu yi nnyɛ́n bɛ Sakaría mbɔnyunɛ chi nnyɛ́n Ɛtayi. ");
INSERT INTO kenNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kɛ máyi arɛm bɛ, “Nnyɛ́n ɛni nɛbhɔŋ bɛbhak chi Jɔ̌n.” ");
INSERT INTO kenNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Yɛ̌ nɔ, bárɛ́m ntá yi bɛ, “Yɛ̌ mmu apú ndǔ nnɛrɛ́kɛt aywɛka anɛ ábhɔ́ŋɔ́ nnyɛ́n ɛnɔ!” ");
INSERT INTO kenNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Bábhó yɛ mɛmak nɛ amɔ ndu bɛbhɛp chimɔ nnyɛ́n ɛnɛn yi áyàŋ manchyɛ mɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakaría amak nɛ amɔ bɛ́ mánchyɛ́ yi ɛnyɨŋ ɛnɛ́ yi ánsɨŋ arɛ́. Báchyɛ nɔkɔ yi ɛnyɨŋ asɨ́ŋ arɛ́ bɛ, “Nnyɛ́n ɛni chí Jɔ̌n.” Bɔ mankɛm babhak maknkay tontó. ");
INSERT INTO kenNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tɛ́mté wu Sakaría apɛt abho bɛrɛm kɛpɨ ankaka nɔkɔ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Bɛcháy bɛ́kɛ́m bakokosi bhap mankɛm. Nɛ mbok mɛnyɨŋ ɛbhɔ ataka ndǔ bɛtɔkɔ́ njiɛ mɛnkɛm atú Judɛ́ya. ");
INSERT INTO kenNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Yɛ̌ agha anɛ ághókó mbok mɛnyɨŋ ɛbhɛn bɛ́fákárí abhʉɛrɛ bhɔ antɨ, ambɛbhɛ nɔkɔ mmʉɛ́t ɛyi bɛ, “Ntɨkɨ ɛnyǔ mmú yi abhak chɔŋ?” Ɛ́bhak kpoŋoroŋ bɛ bɛtaŋ Mandɛm Acha bɛ́chí nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ɛfóŋó Bɛdyɛrɛ abhak nɛ Sakaría, chi Jɔ̌n. Abho bɛ́rɛm kɛpɨ̌ntɨ bɛ, ");
INSERT INTO kenNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Bakak ámbák nɛ Mandɛm Acha bo Israɛl, mbɔnyunɛ atwɔ ndu bɛkwak bǒbhi, nɛ ndu bɛ́fɛ́rɛ bhɔ ndǔ kɛsɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Áchyɛ́ bhɛsɛ ɛtaŋtí Mpɛmɛ anɛ áfú ndǔ nnɛrɛ́kɛt anɛ́ mǔbɛtok ywi Mfɔ Debhít. ");
INSERT INTO kenNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Mandɛm akʉ nyaka barɛmɛ́ kɛpɨ̌ntɨ bhi abhɛn bachi nyáŋá mandɛm ɛnyu ɛyɔ tɛntɛp, ");
INSERT INTO kenNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","bɛ chɔŋ ampɛmɛ bhɛsɛ ndu amɔ́ bǒmpap abhɛsɛ, nɛ amfɛrɛ bhɛsɛ amɔ bo abhɛn bapabhɛ bhɛsɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Arɛm nyaka bɛ chɔŋ angɔ́ bachǐmbɨ bhɛsɛ ntínso, nɛ ántɨk nku anɛ yi anyu nɛ bǒbhi. ");
INSERT INTO kenNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nɔ chi ɛnyɨŋ ɛnɛ Mandɛm aghati nyaka Ɛtayɛsɛ Ábraham, ayɨkɨ bɛ́ yí ǎkʉ yɔ; ");
INSERT INTO kenNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","nɔ chi, bɛ́fɛ́rɛ bhɛsɛ amɔ bǒmpap abhɛsɛ, ankwak bhɛsɛ bɛ́ sɛ́ntók nɔkɔ chi yi, kɛbhɔŋ bɛcháy, ");
INSERT INTO kenNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","sɛ́mbák nyáŋá nɛ chak bɛsí bhi ndǔ nɛpɛ́m ɛnɛsɛ nɛnkɛm. ndǔ manywɔp yɛsɛ́ fá amɨk ankɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nɛ wɔ mɔ́wa, chɔŋ mámbɨŋɨ wɔ bɛ ndɛmɛkɛpɨ̌ntɨ anɛ Mandɛm Acha, mbɔnyunɛ́ chɔŋ ɔ́njambɨ kɛ Acha antwɔ, bɛ ɔntoŋti mbi ntá yi, ");
INSERT INTO kenNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ɔ́nkʉ bǒbhi mándɨŋɨ bɛ chɔŋ yi amfoŋori bɛbʉ́ bhap, nɛ ampɛmɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Mandɛm ywɛsɛ ǎkʉ̀ nɔ mbɔnyunɛ ǎghɔ̀ bhɛsɛ ntínso tontó. Chí ntínso kɛ nɛ́kʉ yi áto chɔŋ Mpɛmɛ ywɛsɛ́, yí amfú amfay antwɔ mbɔ nyiɛnyíɛ́mok běti. ");
INSERT INTO kenNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ǎtwɔ̀ bɛchyɛ bɛdiɛ́rɛ́ ntá bo abhɛn bachi ndǔ ɛjuri nɛ ndǔ bɛcháy nɛwú, nɛ ndu bɛya bhɛsɛ́ ndǔ mbi anɛ átwɔ̀ bhɛsɛ nɛ kpák.” ");
INSERT INTO kenNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mɔ́wú agó ataŋ ndǔ nkwɔmʉɛt nɛ ndǔ Ɛfóŋó. Bɛchɔ́kɔ́ bhi bɛbhak amɛm baso, anoŋ nɔkɔ nywɔp ɛnɛ́n yi átɔŋ mmʉɛt ntá bo Israɛl. ");
INSERT INTO kenNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mpok ɛyɔ Ɔgɔ́stɔs abhak mfɔ Rom, achyɛ ɛyɔŋ bɛ́ mánsɔt mpáy bho mankɛm abhɛn bachi ndǔ bɛtɔk ɛbhɛn bɛchi antɛn yi. ");
INSERT INTO kenNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nɛpǎy-bho ɛnɔ nɛ́bhak ɛnɛ́n mbɨ mpok Kwiríniɔs achi gɔ́bhanɔ ɛtɔk Síria. ");
INSERT INTO kenNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Yɛ̌ntɨkɨ mmu arɔk ɛyi ɛtɔk ndu bɛsɨŋ nnyɛ́n. ");
INSERT INTO kenNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Josɛ́f nkwɔ afa Násárɛt atú Gálili arɔk Bɛ́tlɛhɛm, atú Judɛ́ya. Bɛ́tlɛhɛm abhak ɛtɔk ɛnɛ babhe Mfɔ Debhít. Josɛ́f arɔk arɛ́ mbɔnyunɛ achi nyaka ɛbhárɛ́mɔ Debhít. Arɔk nɛ María, ngɔrɛ́ anɛ yi atɨ bɛbhay bɛ mánsɨ́ŋ manyɛ́n. Abhak nɛ mɛniɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ɛnɛ́ bɔ bachi Bɛ́tlɛhɛm, mpok nɛbhe ayi akway. ");
INSERT INTO kenNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Abhé mɔ̌mbɨ ywi, abhak mɔ́mbakanɛm. Anɛ́p yi nɛ ndɛn, abhʉrɛ amɛm ɛkwɔbhɛ́ nɛnyiɛ nnya mbɔnyunɛ bábhɨ́kɨ́ bhɔŋ nyaka ɛbhak bɛchɔkɔ amɛm ɛkɛrɛ́ mankɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ndǔ bɛtǐ bhɔ, nkwɔ́ babhabhɛri bághɔ́ŋɔmɛ́n bábhak nɛfí nɛ bághɔ́ŋɔmɛ́n ɛyap ndǔ atú ɛtɔk wu. ");
INSERT INTO kenNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ángɛl Mandɛm abhesi bɔ́ bɛsí, bɛdiɛ́rɛ́ Mandɛm bɛghɔ bhɔ́ amʉɛt nɛ bɛcháy bɛkɛm bɔ́ tontó. ");
INSERT INTO kenNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kɛ ángɛl wu arɛm ntá yap bɛ, “Bǎkɛ́ chay, mbɔnyunɛ ntwɔ bhe nɛ Mbok Ndɨ́ndɨ́ anɛ áchyɛ̀ chɔŋ bo mankɛm bɛyǎ maŋák. ");
INSERT INTO kenNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Bábhe Mpɛmɛ ywɛka ɛchɔŋ ɛtɔk Debhít. Yí kɛ achi mmu anɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò. Yi chi Acha. ");
INSERT INTO kenNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ɛrɨŋ ɛnɛ́ ɛ́tɔŋ chɔŋ be mmɔ̌rɛ chi bɛ bǎghɔ̀ chɔŋ ndǔ mánɛ́bhɛ́ yi nɛ ndɛn, bábhʉrɛ amɛm ɛkwɔbhɛ́ nɛnyiɛ nnya.” ");
INSERT INTO kenNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tɛ́mté wu, ngɛ́mtay bɔángɛl Mandɛm babhesi bare kway mámbɨti nɔkɔ Mandɛm bɛ ");
INSERT INTO kenNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Kɛnókó kɛ́mbák nɛ Mandɛm amfay; kpák ambak fá amɨk nɛ bo abhɛn bɛrɨ̌ndu ɛbhi bɛchi nɛ bhɔ!” ");
INSERT INTO kenNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Bɔangɛl bárɔ bhɔ, bapɛtnsɛm amfay. Babhabhɛri bághɔ́ŋɔmɛ́n babho bɛrɛm nɛ batɨ bɛ, “Sɛ́ndɔ́k ká Bɛ́tlɛhɛm sɛ́ngɔ́ ɛnyɨŋ ɛnɛ ɛfakari, ɛnɛ́ Mandɛm akʉ sɛndɨŋɨ.” ");
INSERT INTO kenNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Báfá, bárɔk ayak bághɔ Josɛ́f nɛ María. Bághɔ́ mmɔ̌rɛ́ nkwɔ́ bhʉ́rɛ́ amɛm ɛkʉbhɛ́ nɛnyiɛ nnya. ");
INSERT INTO kenNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bághɔ́ nɔ́kɔ́ nɔ́, barɛm ɛ̌ti mɛnyɨŋ mɛnkɛm ɛbhɛn ángɛl Mandɛm aghati bhɔ ɛ̌ti mɔ́wu. ");
INSERT INTO kenNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bǒ mankɛm abhɛn baghoko ɛnyɨŋ ɛnɛ bɔ barɛmɛ babhak maknkay. ");
INSERT INTO kenNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Kɛ María abhʉrɛ mɛnyɨŋ ɛbhɔ mɛnkɛm antɨ, ankaysi nɔkɔ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Babhabhɛri bághɔ́ŋɔmɛ́n bápɛtnsɛm. Báre kway mámbɨti nɔkɔ Mandɛm mbɔnyunɛ́ mɛnyɨŋ mɛnkɛm ɛbhɛn bághɔ́ nɛ ɛbhɛn baghoko, bɛchi ɛnyumɔt mbɔnyu ángɛl aghati bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ɛgháká nɔ́kɔ́ manywɔp ánɛn, básyɛp mɔ́, bádu yi nnyɛ́n bɛ, Yesu, nnyɛ́n ɛnɛn ángɛl arɛmɛ nyaka bɛ babhɔŋ bɛchyɛ yi tɛ mpok babhɨkɨ re pɔkɔ́ mɛniɛ ɛbhi. ");
INSERT INTO kenNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mpok ákwáy anɛ Josɛ́f nɛ María barɔŋ bɛkʉ mbɔnyu ɛbhé Moses ɛ́rɛ̀m bɛ mánkʉ ndu bɛbhak pɛ́pɛ́p bɛsí Mandɛm mpok ngɔrɛ́ abhé, bápɔ́kɔ Yesu bárɔk Yerúsalɛm ndu bɛtɔŋ yi ntá Mandɛm Acha, ");
INSERT INTO kenNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","mbɔnyu básɨŋ nyaka ndǔ Ɛbhé Mandɛm bɛ, “Yɛ̌ntɨkɨ mɔ̌mbɨ anɛ achi mbakanɛm, bábhɔŋ bɛchyɛ yi ntá Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Bábhɔ́ŋ nkwɔ bɛchyɛ akap ɛ́bu wu anɛ achi ‘Bɔ̌bɛbhóŋó bɛpay, mbák ɛpu nɔ, bɛbhɛp bɛpay, bɛkoŋo ɛbhé Mandɛm.’” ");
INSERT INTO kenNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Mpok ɛyɔ, mmu abhak Yerúsalɛm anɛ aka nnyɛ́n bɛ Símiɔn. Abhak chak anchyɛ nɔkɔ Mandɛm kɛnókó. Ǎnòŋ nyaka mpok anɛ Mandɛm átwɔ ankwɛnɛ batɨ bo Israɛl. Nɛ Ɛfóŋó Bɛdyɛrɛ abhak nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ɛfóŋó Bɛdyɛrɛ anáŋ akʉ nyaka yi arɨŋɨ bɛ́ apú gu kɛghɔ́ Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò. ");
INSERT INTO kenNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ɛfóŋó Bɛdyɛrɛ akʉ Símiɔn arɔk ndǔ ɛkɛrákap Mandɛm. Nnɔ nɛ chi Yesu báchwe arɛ́ nɛ yi ndu bɛtɔŋ yi ntá Mandɛm bɛkoŋo ɛbhé Moses. ");
INSERT INTO kenNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Símiɔn aghɔ nɔkɔ mɔ̌rɛ́ asɔt yi akɛ́m amɔ abɨti Mandɛm bɛ́: ");
INSERT INTO kenNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Acha, ɔkʉ bariɛp amɛ afǔ tɛtɛp, dɔ yɛ́ mɛ, mmɔ̌bɛtok ywɛ ndɔ́k pɛtii, ");
INSERT INTO kenNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","mbɔnyunɛ nnáŋ ngɔ nɛ amɨ́k mmu anɛ ɔ́tó bɛ ampɛmɛ bhɛsɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Mpɛmɛ anɛ ɔ́tɔ̀ŋti bɛ bǒ mankɛm mángɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Achí ɛrɔŋɔ bɛtɔŋ bo abhɛn bápú bo Israɛl mbi bɛrɨŋɨ wɔ, nɛ bɛ kɛnókó kɛ́ntwɔ́ ntá bǒbhɛ, bo Israɛl.” ");
INSERT INTO kenNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Chi nɛ nnɔ babhak maknkay bɛghok mɛnyɨŋ ɛbhɛn Símiɔn arɛmɛ ɛ̌ti Yesu. ");
INSERT INTO kenNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Símiɔn ayɛ́t bhɔ, arɛm ntá máyi María bɛ, “Mandɛm ayap mɔ́nɛ bɛ ankʉ bɛyǎ bo Israɛl mankwɛn nɛ bɛ ánjoŋ abhɛnɛfu, nɛ bɛ ámbák ɛrɨŋ ɛnɛ́ bo bárɛ̀m bɛ bápú yaŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","“Nɛ chɔŋ ɛnɛ ɛ́nkʉ bɛ nkaysi anɛ achi bo ántɨ ambo bɛfú kpoŋoroŋ, nɛ wɔ ɔ́mbɔŋ bɛyǎ basɛ́mɛ́ ɛ̌ti mɔ́nɛ mbɔ mmu anɛ ɛɛkak ɛ́yɛ́mɛ́ yi antɨ.” ");
INSERT INTO kenNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Mpok ɛyɔ, ngɔrɛ́ anɛ áká nnyɛ́n bɛ Ána abhak Yerúsalɛm. Abhak ndɛmɛkɛpɨ̌ntɨ Mandɛm. Abhak mmɔ̌ Fanuɛl, ɛbhárɛ́mɔ anɛ nnɛrɛ́kɛt Ásha. Akɔk nyaka tontó nɛ anáŋ achi nyaka ɛkɛrɛ́nɛbhay ndǔ mamiɛ́ tándrámɔt kɛ nnɛ́m aywi ǎgu. ");
INSERT INTO kenNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Arɔp kɛ́nkwɛ́sɛ́, tɛ mpok anɛ yi aghaka mamiɛ́ bɛsa mɛnwi nsɛm anwi. Yí kɛrɔ bɛrɔŋ ndǔ ɛkɛrákap Mandɛm ndu bɛchyɛ yi kɛnókó, nɛ are nɨkmʉɛt ambak nɔkɔ ndǔ nɛtarɛ́nsay, bɛti nɛ ngósí. ");
INSERT INTO kenNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nkúbhɛ́ mpok ɛyɔ Josɛ́f nɛ María bárɔk nɛ mmɔ́. Ághɔ́ nɔ́kɔ́ mɔ̌rɛ́, achyɛ bakak ntá Mandɛm andɛmɛ nɔkɔ bɛyǎ mɛnyɨŋ ɛ̌ti mmɔ́, ntá bo abhɛn mánòŋ nyaka bɛ Mandɛm amfɛrɛ bǒ Yerusalɛm ndǔ ɛsɔŋɔri. ");
INSERT INTO kenNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josɛ́f nɛ María manaŋa nɔkɔ bɛkʉ mɛnyɨŋ mɛnkɛm bɛkoŋo ɛbhé Mandɛm, bápɛtnsɛm nɛ mmɔ́ ɛtɔk ɛyap Násárɛt atú Gálili. ");
INSERT INTO kenNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yesu arɔk ambɨ bɛ́go nɛ bɛ́bhɔŋ bɛtaŋ. Abhɔ́ŋ bɛyǎ nɛrɨŋɨ́ndak nɛ áfɔ́k Mandɛm abhak nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yɛ̌ntɨkɨ mmíɛ́, chi nɛ nnɔ Yesu bárɔ̀ŋ nyaka Yerúsalɛm ndǔ *Ɛpǎ Nɛkɨŋɨ. ");
INSERT INTO kenNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Mpok yi aghaka mamiɛ́ byo nɛ apay, bárɔ́k ndǔ ɛpǎ ɛyɔ mbɔ ɛnyu ɛsɨ́. ");
INSERT INTO kenNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ɛpa ɛ́máy nɔ́kɔ́, bare pɛtnsɛm ɛtɔk ɛyap kɛ Yesu arɔp Yerúsalɛm, chi nɛ nnɔ kɛrɨŋɨ. ");
INSERT INTO kenNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bákɔ ndǔ nywɔp nɛnkɛm mánkaysi nɔkɔ bɛ yi achi ndǔ nkwɔ́ wap. Bághɔ́ nɔ́kɔ́ bɛ apú nɛ bhɔ, babho bɛyaŋ yi nɛntɨ mamʉɛrɛ bhap nɛ bǒnɛrɛ́kɛt awap. ");
INSERT INTO kenNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Báyáŋ nɔ́kɔ́ yi kɛghɔ, bápɛtnsɛm Yerúsalɛm ndu bɛyaŋ yí arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ɛgháká nɔkɔ manywɔp árát, bághɔ́ yi amɛm ɛkɛrákap Mandɛm chɔkɔ nɛ batɔŋ ɛbhé, ndu ághòk mɛnyɨŋ ɛbhɛn bɔ bárɛ̀m, nɛ ambɛbhɛ nɔkɔ bɔ́ bɛbhɛp. ");
INSERT INTO kenNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bo mankɛm abhɛn bághòk mɛnyɨŋ ɛbhɛn yi árɛ̀m bábhák maknkay ɛ̌ti mɛnyɨŋ ɛbhɛn yi arɨŋɨ nɛ ɛnyǔ ɛnɛ yi ákɛ̀mɛ bhɔ mɛnyɨŋ ɛbhɛn bábhɛ̀p yi. ");
INSERT INTO kenNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mpok anɛ chi nɛ nnɔ bághɔ́ yi, ɛbhak bhɔ chi ɛnyɨŋ maknkay. Nnɔ abhɛ́p yi bɛ, “Mɔ́wa, mbʉ ɔbhɨkɨ kʉ ɛtayɛ nɛ mɛ ɛnyunɛ!” ");
INSERT INTO kenNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Mmɛ nɛ ɛtayɛ sɛ́kɔ, sɛ́yàŋ wɔ nɛ bɛyǎ bɛcháy antɨ. Yesu akɛmɛ bhɔ bɛ, “Báyàŋ mbʉ mɛ ndaká yí? Bǎbhɨ́kɨ́ rɨŋɨ bɛ mbɔ̌ŋ bɛbhak amɛm ɛkɛt Ɛtaya?” ");
INSERT INTO kenNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kɛ nnɔ nɛ chi kɛjwimɛm ndǔ ɛnyɨŋ ɛnɛ́ yi arɛmɛ ntá yap. ");
INSERT INTO kenNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Apɛt yɛ nsɛm Násárɛt nɛ bhɔ, abhak nɛ bhɔ sayri akɛtaŋntí. Máyi abhʉrɛ mɛnyɨŋ ɛbhɛn mɛnkɛm antɨ. ");
INSERT INTO kenNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Arɔk ambɨ bɛ́go ndǔ nkwɔmʉɛt nɛ ndǔ nɛrɨŋɨ́ndak. Mandɛm abhɔ́ŋ maŋák nɛ yi andɔk nɔkɔ chí ambɨ. Ɛbhak ɛnyumɔt nɛ bo. ");
INSERT INTO kenNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Mpok Jɔ̌n mmɔ̌ Sakaría achi amɛm baso, Mandɛm achyɛ yi mɛnyɨŋ ɛbhɛn yi ábhɔ́ŋɔ́ bɛghati bho. Mpok Tibériɔs achi mfɔ ngo anɛ ɛtɔk Rom ndǔ mamiɛ́ nɛku, Pɔ́ntiɔs Páílet abhak gɔ́bhanɔ atú Judɛ́ya, Hɛ́rɔd abhak mǔnti atú Gálili, mɔmáyi Fílip abhak mǔnti atú Itúria nɛ Trakonítis, nɛ Lisánias abhak mǔnti atú Abilene. Káyfas nɛ Ánas babhak bǒbati bachiǎkap Mandɛm. Mandɛm aghati Jɔ̌n mmɔ̌ Sakaría ɛnyɨŋ mpok yi achi amɛm baso, ");
INSERT INTO kenNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jɔ̌n arɔk yɛ ndǔ bɛtɔk mɛnkɛm ɛbhɛn bɛchi atú Nnyɛ́n Jɔ́dan, angati nɔkɔ bho Ɛyɔŋ Mandɛm bɛ bo mántɨ́knsɛm ndǔ bɛbʉ́ ɛbhap mánjwítí bhɔ́ bɛ Mandɛm amfoŋori bɛbʉ́ ɛbhap. ");
INSERT INTO kenNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ɛbhak mbɔ ɛnyǔ Aisáya ndɛmɛkɛpɨ̌ntɨ Mandɛm asɨŋɨ nyaka amɛm ɛkáti yi bɛ: “Mmǔ achi amɛm baso ǎbɨ̀k nɛ ɛyɔŋ amfay andɛmɛ nɔkɔ bɛ, ‘Toŋtí ká mbi anɛ Acha áfʉɛ̀t arɛ́. Kʉ́ ka mbǐ ywi ambak chak. ");
INSERT INTO kenNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Chók ká yɛ̌ntɨkɨ ɛ́yɛ́mɛ́, mánkʉ yɛ̌ntɨkɨ njiɛ ngo nɛ yɛ̌ntɨkɨ mɔ́njiɛ andɔp mmɨk nɛbhʉɛt. Nyabhɛ́ ká babhi anɛ achi ŋɔ́tí ŋɔ́tí, mǎndansi anɛ́ achi gbokotí gbókótí, ");
INSERT INTO kenNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","nɛ chɔŋ bǒ mankɛm mángɔ ndu Mandɛm ápɛ̀mɛ bho.’” ");
INSERT INTO kenNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jɔ̌n arɛm ntá bɛyǎ bo abhɛn bárɔ̀ŋ ntá yi bɛ́ yi anjwiti bhɔ́ bɛ, “Bě bɛfé! Agha áyɛ́bhɛ́ be batú bɛ mǎnjaŋ mbi ndu bɛbʉɛ ntɛmsi Mandɛm anɛ átwɔ̀? ");
INSERT INTO kenNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Bǎbhɔŋ bɛkʉ mɛnyɨŋ ɛbhɛn bɛ́tɔ̀ŋ bɛ bǎtɨknsɛm ndǔ bɛbʉ́ ɛbhɛka tɛtɛp. Bǎkɛ́ chɔkɔ mǎndɛm bɛ́ bǎchí bɛbhárɛ́bhɔ Ábraham. Dɨŋɨ́ ká bɛ́ Mandɛm ǎkwáy bɛsɔt batay ánɛ ankʉ yɔ́ ámbak bɛbhárɛ́bhɔ Ábraham. ");
INSERT INTO kenNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yɛ̌ chí nɛ́nɛ, sɛtɨ sɛ́chí bhʉ́rɛ́, nɛ bákway bɛkpɔt yɛ̌ntɨkɨ ɛnɔk ɛnɛ ɛpu nyu bɛrɨ́tí kɛpɛm tɛ ndǔ bakaŋ, mángʉɛp angó.” ");
INSERT INTO kenNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Bǒ bhɔ bághókó nɔ́kɔ́ nɔ́ bábhɛp Jɔ̌n bɛ, “Yi sɛ́bhɔ́ŋɔ́ yɛ bɛkʉ?” ");
INSERT INTO kenNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Akɛmɛ bhɔ bɛ, “Mmu anɛ ábhɔ́ŋɔ́ nkú ɛpay ánchyɛ́ amɔt ntá anɛ abhɨkɨ bhɔŋ, nɛ mmu anɛ ábhɔ́ŋɔ́ nɛnyíɛ́ ánkɔ́rɛ́ nɛ anɛ abhɨkɨ bhɔŋ.” ");
INSERT INTO kenNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Babhɛbhɛ́ nkabhɛnti nkwɔ bárɔ́k bɛ yi anjwiti bhɔ. Bábhɛp yi bɛ, “Ntɔŋ, yi sɛ́bhɔ́ŋɔ́ bɛkʉ?” ");
INSERT INTO kenNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Jɔ̌n akɛmɛ bɔ bɛ, “Bǎkɛ́ sɔt nkábhɛ́nti ɛ́ncha anɛ́ bǎbhɔŋɔ bɛsɔt.” ");
INSERT INTO kenNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mbɔk batɛmɛ́ nɛnu nkwɔ́ bábhɛp yi bɛ, “Yí sɛ́bhɔ́ŋɔ́ bɛ́kʉ?” Akɛmɛ bhɔ bɛ, “Bǎkɛ́ sɔt nkáp ntá mmu nɛ bɛtaŋ, bǎkɛ́ bhat mmu ndak amʉɛt; dɔ̌ ká akap anɛ́ báchyɛ̀ bhe ndǔ bɛtɨk ɛbhɛn bǎkʉ̀ ánkway bhe.” ");
INSERT INTO kenNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Bo bábhaka nyaka ntɨ ndǔ mɛnyɨŋ ɛbhɛn Jɔ̌n árɛ̀m nɛ ɛbhɛn yi ákʉ̀. Ɛ́kʉ bábho bɛbhɛp mmʉɛt mbák Jɔ̌n kɛ achi Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò. ");
INSERT INTO kenNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jɔ̌n akɛmɛ bhɔ́ bɛ, “Mɛ̌jwìti bhe nɛ manyiɛp. Kɛ mmu anɛ acha mɛ ǎtwɔ̀. Mbɨ́kɨ́ kwáy mmu anɛ nchí kaŋari nkwɔbhɛ́nya bɛkak ɛbhi. Ánáŋ ántwɔ́, chɔŋ anjwiti bhe nɛ Ɛfóŋó Bɛdyɛrɛ nɛ ngó. ");
INSERT INTO kenNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ǎtwɔ̀ nɛ nchán myákátí awɔ ndu bɛ́chák nkway bɛ amfáp ɛnɛ ɛrɨ nɛ bɛkpáfu. Ánáŋ ánkʉ́ nɔ, ansɔt mbwɔt antɛn ndu nkpánɛ́, anyɔ mmɨk, ansɔt bɛkpáfu amfyɛ amɛm ngó anɛ apu nɛmɛ.” ");
INSERT INTO kenNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jɔ̌n arɛm bɛyǎ mɛnyɨŋ bɛchak ndu bɛfyɛ bhɔ ntɨ ndu ánù bɛkʉ mánóko Mbok Ndɨ́ndɨ́ anɛ yi aghati bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Jɔ̌n aji Mfɔ Hɛ́rɔd bɛ akwɛn ɛbhé Mandɛm ndu ásɔ́rɛ́ Hɛródias ngɔrɛ́ mɔ́máyi ábhay. Aji yí ɛ̌ti barak abʉ́abʉ achak ankɛm anɛ yi ákʉ́. ");
INSERT INTO kenNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nɛ mɛ́máka ndǔ ɛbhɔ̌ mɛnkɛm, Hɛ́rɔd arɛm báfé Jɔ̌n amɛm ɛkɛrɛ́kɛnɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Bápɛ́rɛ fe Jɔ̌n, anáŋ ǎjwìti nyaka bho. Ajwiti Yesu nkwɔ. Nɛ mpok Yesu ánɨ̀kmʉɛt, nɛbu nɛ́nɛ́nɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ɛfóŋó Mandɛm asɔt mkpá ɛbhóŋó asɛp yi amʉɛt. Ɛyɔŋ ɛ́fú amfay ɛrɛm bɛ, “Wɔ ɔchí Mɔ́wa. Nkɔŋ wɔ tontó. Ɔ̌chyɛ̀ mɛ bɛyǎ maŋák” ");
INSERT INTO kenNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Mpok Yesu ábhó bɛtɨk ɛbhi, achi nyaka mbɔ mamiɛ́ ɛsǎ nsɛm byó, bo mándɛm nɔkɔ bɛ Yesu chí mmɔ̌ Josɛ́f mmɔ̌ Héli, ");
INSERT INTO kenNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Héli mmɔ̌ Mátat, Mátat mmɔ̌ Lɛ́vi, Lɛ́vi mmɔ̌ Mɛ́lki, Mɛ́lki mmɔ̌ Jánai, Jánai mmɔ̌ Josɛ́f, ");
INSERT INTO kenNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josɛ́f mmɔ̌ Matátias, Matátias mmɔ̌ Ɛ́mɔs, Ɛ́mɔs mmɔ̌ Náhum, Náhum mmɔ̌ Ɛ́sli, Ɛ́sli mmɔ̌ Nágai, ");
INSERT INTO kenNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nágai mmɔ̌ Máat, Máat mmɔ̌ Matátias, Matátias mmɔ̌ Sémen, Sémen mmɔ̌ Jósɛk, Jósɛk mmɔ̌ Jóda, ");
INSERT INTO kenNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jóda mmɔ̌ Joánan, Joánan mmɔ̌ Résa, Résa mmɔ̌ Sɛrúbabɛl, Sɛrúbabɛl mmɔ̌ Síltiɛl, Síltiɛl mmɔ̌ Nɛri, ");
INSERT INTO kenNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nɛ́ri mmɔ̌ Mɛ́lki, Mɛ́lki mmɔ̌ Ádi, Ádi mmɔ̌ Kósam, Kósam mmɔ̌ Ɛlmádam, Ɛlmádam mmɔ̌ Ɛ́r, ");
INSERT INTO kenNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ɛ́r mmɔ̌ Jóshua, Jóshua mmɔ̌ Ɛliɛ́sa, Ɛliɛ́sa mmɔ̌ Jórim, Jórim mmɔ̌ Mátat, Mátat mmɔ̌ Lɛ́vi, ");
INSERT INTO kenNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lɛ́vi mmɔ̌ Símiɔn, Símiɔn mmɔ̌ Júda, Júda mmɔ̌ Josɛ́f, Josɛ́f mmɔ̌ Jónam, Jónam mmɔ̌ Ɛliákim, ");
INSERT INTO kenNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ɛliákim mmɔ̌ Mɛléa, Mɛléa mmɔ̌ Mɛ́na, Mɛ́na mmɔ̌ Matáta, Matáta mmɔ̌ Nátan, Nátan mmɔ̌ Debhít, ");
INSERT INTO kenNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Debhít mmɔ̌ Jése, Jése mmɔ̌ Óbɛd, Óbɛd mmɔ̌ Bóas, Bóas mmɔ̌ Sálmɔn, Sálmɔn mmɔ̌ Náshɔn, ");
INSERT INTO kenNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Náshɔn mmɔ̌ Amínadap, Amínadap mmɔ̌ Rám, Rám mmɔ̌ Hɛ́rɔn, Hɛ́srɔn mmɔ̌ Pɛ́res, Pɛ́res mmɔ̌ Júda, ");
INSERT INTO kenNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Júda mmɔ̌ Jekɔ́p, Jekɔ́p mmɔ̌ Áisek, Áisek mmɔ̌ Ábraham, Ábraham mmɔ̌ Tɛ́ra, Tɛ́ra mmɔ̌ Náhɔ, ");
INSERT INTO kenNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Náhɔ mmɔ̌ Sɛ́rug, Sɛ́rug mmɔ̌ Réu, Réu mmɔ̌ Pɛ́lɛk, Pɛ́lɛk mmɔ̌ Ɛ́ba, Ɛ́ba mmɔ̌ Shɛ́la, ");
INSERT INTO kenNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shɛ́la mmɔ̌ Kaínan, Kaínan mmɔ̌ Afásad, Afásad mmɔ̌ Shɛ́m, Shɛ́m mmɔ̌ Nóa, Nóa mmɔ̌ Lámɛk, ");
INSERT INTO kenNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lámɛk mmɔ̌ Mɛtúsɛla, Mɛtúsɛla mmɔ̌ Ɛ́nɔk, Ɛ́nɔk mmɔ̌ Járɛt, Járɛt mmɔ̌ Mahálálɛl, Mahálálɛl mmɔ̌ Kánǎn, ");
INSERT INTO kenNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kánǎn mmɔ̌ Ɛ́nɔs, Ɛ́nɔs mmɔ̌ Sét, Sét mmɔ̌ Ádam, Ádam mmɔ̌ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu ápɛ́rɛ fú ndǔ nnyɛ́n Jɔ́dan, ajwi nɛ Ɛfóŋó Bɛdyɛrɛ. Yí akʉ Yesu arɔk amɛm baso, ");
INSERT INTO kenNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","abhak arɛ́ ndǔ manywɔp bɛsa bɛpay Satan amɔ nɔkɔ yi. Yí kɛnyiɛ yɛ̌nyɨŋ ndǔ manywɔp ɛyɔ ankɛm. Ndǔ ngwɛnti manywɔp ɛyɔ nsay akɛ́m yi. ");
INSERT INTO kenNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Satan arɔk arɛm ntá yi bɛ, “Mbák ɔchí Mmɔ Mandɛm, chyɛ̌ ɛyɔŋ bɛ ntǎy ɛnɛn nɛ́njíbhírí nɛ́ndɔp ɛkpɔkɔ́ brɛd.” ");
INSERT INTO kenNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu akɛmɛ yi bɛ, “Ɛ́chí amɛm Ɛkáti Mandɛm bɛ, ‘Puyɛ̌ nɛnyíɛ́ nɔ́nɔ́ kɛ nɛ́kɛ̀m nɛpɛ́mɛ́ mu.’” ");
INSERT INTO kenNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Satan asɔt yi akó ndǔ nɛbhʉɛt anɛ achi tɛ amfay atɔ́ŋ yí bɛtɔkɔ́ mmɨk mɛnkɛm nɛ kɛfɔ ɛkɛn kɛ́chí arɛ́ ndu mɔ́mbɨŋɨ́ mpok. ");
INSERT INTO kenNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Arɛm yɛ ntá yi bɛ, “Báchyɛ́ bɛtaŋ nɛ kɛfɔ̌ mmɨk nkɛm ntá ya, nɛ nchí kway bɛchyɛ kɔ ntá yɛ̌ agha anɛ nkɔ́ŋɔ́. Chɔŋ nchyɛ́ wɔ bǒbhɛn mɛnkɛm nɛ kɛfɔ ɛkap. ");
INSERT INTO kenNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Mbák ɔ́ntɛ́p mánɛ́n amɨk, ɔ́nchyɛ mɛ kɛnókó, mbɔ Mandɛm ywɛ, chɔŋ mɛnyɨŋ ɛbhɛn mɛnkɛm mɛ́nndɔp ɛbhɛ.” ");
INSERT INTO kenNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu akɛmɛ bɛ́, “Ɛkáti Mandɛm ɛ́rɛ̀m bɛ, ‘Mmu abhɔŋ bɛchyɛ kɛnókó chi ntá Mandɛm Acha, antók chí yí aywǐntí.’” ");
INSERT INTO kenNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Satan asɔt yi bárɔ́k Yerúsalɛm, bákó ndǔ nɛbhʉɛt anɛ áchí tɛ amfay ndǔ ɛkɛrákap Mandɛm. Arɛ́, arɛm ntá Yesu bɛ, “Mbák ɔchí Mmɔ Mandɛm, dók, ");
INSERT INTO kenNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","tɛ̌ndu ɛchi amɛm Ɛkáti Mandɛm bɛ, ‘Chɔŋ Mandɛm anchyɛ ɛyɔŋ bɔángɛl bhi mántwɔ́ manchyɛ wɔ nɛkwak.’ ");
INSERT INTO kenNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ɛkáti Mandɛm ɛ́pɛt ɛ́rɛ̀m bɛ, ‘Chɔŋ mánkpʉɛp wɔ nɛ amɔ yap, bɛ́ ɔ́kɛ́ tɛm ɛkak ndǔ ntay.’” ");
INSERT INTO kenNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu akɛmɛ yi bɛ, “Ɛkáti ɛ́rɛ̀m bɛ, ‘Ɔ́kɛ́ mɔ Mandɛm Acha ywɛ.’” ");
INSERT INTO kenNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satan ámɔ́ nɔ́kɔ́ Yesu ndǔ bɛyǎ babhi kɛkɛ́m yi, arɔ kpɨ́k yi. ");
INSERT INTO kenNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu apɛt yɛ nsɛm atú Gálili ndǔ bɛtaŋá Ɛfóŋó Bɛdyɛrɛ. Mbok yi ataka atú Gálili wu ankɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Are tɔ́ŋ bo Ɛyɔŋ Mandɛm amɛm bɛkɛrɛ́ nɛnɨkɨ́mʉɛt bo Israɛl, nɛ bo báré chyɛ yi kɛnókó. ");
INSERT INTO kenNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu afa, arɔk Násárɛt, ɛtɔk ɛnɛ máné yi arɛ́. Mbɔ ɛnyǔ ɛpɨŋ ɛyi ɛchi nyaka, arɔk amɛm ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí ndǔ nywɔbhɛ́ nɛywěmʉɛt bo Israɛl. Ɛ́bhɨ́kɨ́ tat, afate bɛpay Ɛyɔŋ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Báchyɛ́ yi ɛkáti ɛnɛ ndɛmɛkɛpɨ̌ntɨ Aisáya. Anɛnɛ yɔ́, ndǔ nɛbhʉɛt anɛ básɨ́ŋɨ́ bɛ́: ");
INSERT INTO kenNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ɛfóŋó Mandɛm Acha achí nɛ mɛ mbɔnyunɛ, ayap mɛ bɛ́ ngátí Mbok Ndɨ́ndɨ́ ntá bachɛ́bhɛ́bho. Ato mɛ, bɛ ntwɔ́ ngátí bo abhɛn bachi ndǔ yɛ̌ntɨkɨ ɛnyǔ kɛsɛm, bɛ chɔŋ mámfɛrɛ bhɔ arɛ. Nɛ bɛ́ chɔŋ amɨ́k anɛnɛ manɛ́mámɨk, nɛ bɛ chɔŋ mánchyɛ ngǎngaŋ ntá bo abhɛn batɨ̌ bakwǎŋwaŋ mányìɛrɛ bhɔ amɨk. ");
INSERT INTO kenNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ato mɛ bɛ́ mbé ntá bho bɛ mpok anɛ yi átɔŋ bɔ́ bɛrɨ̌ndu bhi akway.” ");
INSERT INTO kenNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu ánáŋá nɔ́kɔ́ bɛ́pay ɛkáti yɔ, akuti yɔ́, akɛmɛ ntá mǔnti arɔk achɔkɔ amɨk. Bǒ mankɛm abhɛn bachi amɛm ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí bátɛp yi amɨ́k amʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Abho yɛ bɛghati bhɔ bɛ, “Ɛchɔŋ, ɛnyɨŋ ɛnɛ basɨŋɨ́ mɛn árɛ̀m ɛ́fákárí mbɔ ɛnyǔ bǎghókó.” ");
INSERT INTO kenNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bǒ abhɛn bachi arɛ́, bárɛ́m bɛrɨ́tí mɛnyɨŋ ɛ̌ti yi, nɛ babhak maknkay ɛ̌ti bɛrɨ́tí kɛpɨ ɛkɛn kɛ́fú yi anyu. Kɛ bábho bɛbhɛp bɛ, “Pú mmɔ̌ Josɛ́f nɛ?” ");
INSERT INTO kenNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu arɛm ntá yap bɛ, “Chɔŋ mǎntɛm mɛ nɛkay ɛnɛn ɛ̌ti ya bɛ, ‘Ngaŋ, bú mmʉɛt ɛyɛ. Mɛnyɨŋ ɛbhɛn sɛghoko bɛ ɔkʉ awu ɛtɔk Kapɛ̌naum, kʉ bhɔ́ fá amɛm ɛtɔk ɛyɛ nkwɔ.’” ");
INSERT INTO kenNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yesu arɛm bɛ, “Nchí ghati bhe bɛ, bápú ka ndɛmɛkɛpɨ̌ntɨ amɛm ɛtɔk yi. ");
INSERT INTO kenNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kɛ nchí ghati bhe bɛ, mánkwɛ́sɛ́ bayǎ nyaka amɛm ɛtɔk Israɛl ndǔ mpok ndɛmɛkɛpɨ̌ntɨ Ɛláija. Mpok yɔ manyiɛp kɛkwɛ́n ndǔ mamiɛ́ arat nɛ ɛbhɔ́k, nɛ ɛrɛmɛ́ nsay ɛ́kwɛ́n ndǔ ɛtɔk Israɛl ɛnkɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Kɛ Mandɛm ábhɨ́kɨ́ tó nyaka Ɛláija ntá yɛ̌ kɛ́nkwɛ́sɛ́ amɔt, ɛbhɨ́kɨ́fʉɛt chi anɛ achi ɛtɔk Sárɛfat, atú Sídɔn, ɛtɔk bo bachak. ");
INSERT INTO kenNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nɛ ndǔ mpok ndɛmɛkɛpɨ̌ntɨ anɛ áká nnyɛ́n bɛ Ɛláisha, bɛyǎ bǒ ɛbhaŋákwa bachi nyaka amɛm ɛtɔk Israɛl. Kɛ yɛ̌ amɔt Ɛláisha ábhɨ́kɨ́ bu, ɛbhɨ́kɨ́fʉɛt chi mmǔ ɛtɔk ɛchak, Náman, mmu Síria.” ");
INSERT INTO kenNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Bo mankɛm abhɛn bachi amɛm ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí, bághókó nɔ́kɔ́ nɔ́, batɨ ábé bhɔ amɛm tontó. ");
INSERT INTO kenNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Báfáte bákɛ́m yi, bafu ɛtɔk nɛ yi. Ndǔ ɛtɔk yap ɛchi amfǎy njiɛ, básɔ́t yi barɔk ndǔ nkókónjiɛ bɛ́ mámpúrí yi ankwɛn arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kɛ ayibhiri mmʉɛ́t, anɔnɛ, afʉɛ́t nɛntɨ nap arɔk ɛbhakayi. ");
INSERT INTO kenNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesu apɛt asɛp arɔk Kapɛ̌naum, ɛtɔk ɛgho, atú Gálili. Arɛ́, are tɔ́ŋ bo amɛm ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí bo Israɛl ndǔ nywɔbhɛ́ nɛywěmʉɛt ɛnap. ");
INSERT INTO kenNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Bábhák maknkay tontó ɛ̌ti ɛnyu ɛnɛ yí átɔ̀ŋ mbɔnyunɛ ǎtɔ̀ŋ nyaka mbɔ mmǔ anɛ árɛ̀m ɛ́may. ");
INSERT INTO kenNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mmu amɔt abhak arɛ́ anɛ ɛfóŋó ɛbʉ́bʉ ɛ́sɔ̀ŋɔri. Are bɨk nɛ ɛyɔŋ ɛtaŋataŋ andɛmɛ nɔkɔ bɛ́, ");
INSERT INTO kenNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ɛ̌! Yesu, Mmu Násárɛt, ɔbhɔŋ yí bɛkʉ nɛ bhɛsɛ! Ɔtwɔ fá bɛway bhɛsɛ? Ndɨ́ŋɨ́ mmu wɔ ɔ́chí. Ɔ́chí Mmu Nyáŋá anɛ Mandɛm átó!” ");
INSERT INTO kenNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu asáy ɛfóŋó yɔ bɛ, “Kusí! Fú yi amʉɛt!” Ɛfóŋó yɔ ɛ́gʉɛp mmǔ wu amɨk bɛsí bhap. Kɛ ɛ́fú yi amʉɛt kɛkʉ yi yɛ̌nyɨŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bǒ mankɛm bábhák maknkay, nɛ babho bɛbhɛp batɨ bɛ, “Ɛyɔŋ ɛnɛ́ mmǔ-nɛ ɛ́chí nɛ́ ná e? Ǎsay bɛfóŋó bɛbʉ́bɛbʉ nɛ bɛtaŋ bɛ́ mɛ́mfu bo amʉɛ́t, nɛ mɛ́mfú.” ");
INSERT INTO kenNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nɛ nsoŋo Yesu akɔ ataka atú ɛtɔk wu ankɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu afa ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí yɔ, arɔk, ndǔ ɛkɛt Símun. Nnɔ ngɔrɛ́ Símun abhɔ̌ŋ mbʉ́ɛ́p ataŋataŋ. Baghɔk Yesu manɨk yi mmʉɛt bɛ ambu yi. ");
INSERT INTO kenNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Arɔk, ate nɛku bɛkɔk ɛbhɛn yi achi arɛ bhʉ́rɛ́. Achyɛ ɛyɔŋ bɛ mbʉ́ɛ́p wu ándɔ́ yí. Ámay. Afaté akʉ nɛnyíɛ́ abho mɛne bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Mpok anɛ mmok ánɛ̀m, bǒ mankɛm abhɛn bábhɔ́ŋɔ́ bǒmame mɛnyu nɛ mɛnyu básɔ́t bhɔ bárɔ́k ntá Yesu. Abho mɛ́nyáŋa amɔ amʉɛt yɛ̌ntɨkɨ mmu wap, kpat abú bhɔ mankɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Bɛyǎ bhap babhɔ̌ŋ nyaka bɛfóŋó bɛbʉ́bɛbʉ. Bɛfóŋó bɛbʉ́bɛbʉ bhɔ bɛ́fú bɛyǎ bho amʉɛt mɛ́mbɨkɨ nɔkɔ bɛ́, “Wɔ ɔchí Mmɔ Mandɛm!” Kɛ Yesu are sáy bhɔ, kɛka mɛ́ndɛm yɛ̌nyɨŋ, mbɔnyunɛ bɛ́rɨŋɨ nyaka bɛ yi achi Mpɛmɛ anɛ Mandɛm átó. ");
INSERT INTO kenNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nɛ́yí nɔkɔ, Yesu afa ɛtɔk, arɔk ndǔ nɛbhʉɛt anɛ bo bápú arɛ́. Bǒ babho bɛyaŋ yi. Bághɔ́ nɔ́kɔ́ yí, babho mɛnɨkmʉɛt bɛ́ ákɛ́ rɔ ɛtɔk ɛyap. ");
INSERT INTO kenNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kɛ yi aghati bhɔ́ bɛ́, “Mbɔŋ bɛ́gháti Mbok Ndɨ́ndɨ́ bɛ Mandɛm achi Mfɔ amɛm bɛtɔk bɛchak nkwɔ, mbɔnyunɛ Mandɛm átó mɛ fá amɨk chi ɛ̌ti yɔ.” ");
INSERT INTO kenNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Arɔ yɛ, are kɔ andɔkɔ nɔkɔ ndǔ bɛtɔk ɛbhɛn bɛchi atú Judɛ́ya angati nɔkɔ bho Mbok Ndɨ́ndɨ́ amɛm bɛkɛrɛ́ nɛnɨkɨ́mʉɛt bo Israɛl ");
INSERT INTO kenNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ɛwak ɛ́mɔt, Yesu abhak téé angɔkɔ Ɛ̌ntɨŋnyɛn Gɛnɛ́sarɛt. Bo báré nu bɛbhak kɛkwɔt nɛ yi bɛ mangok Ɛyɔŋ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Aghɔ́ bachwi apay angɔkɔnyɛ́n. Bawǎnsi abhɛn bábhɔ́ŋɔ́ bachwi yɔ, báfù amɛm mánchaka nɔkɔ basɨ yap. ");
INSERT INTO kenNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu arɔk achwe amɛm áchwí amɔt. Abhak anɛ Símun. Aghati yi bɛ ánók áchwí antɛn anyɛ́n mandú. Yesu achɔkɔ yɛ amɛm áchwí wu, antɔŋ nɔkɔ bo abhɛn bachi angɔkɔnyɛ́n Ɛyɔŋ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ánáŋá nɔ́kɔ́ bɛtɔŋ bo arɛm ntá Símun bɛ, “Tɛ́n áchwí ndǔ ɛɛntɛm mǎngʉɛp basɨ yɛka anyɛ́n bɛ mǎnkɛm nsi.” ");
INSERT INTO kenNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Símun akɛmɛ yi bɛ, “Ɛta, sɛ́dɛn mmʉɛt bɛti mɛnkɛm kɛ yɛ̌nyɨŋ sɛ́bhɨ́kɨ́ kɛm. Kɛ ndu bɛkoŋo ɛyɔŋ ɛyɛ, chɔŋ ngʉɛp básɨ ndǔ ɛɛntɛm.” ");
INSERT INTO kenNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Yí nɛ mamʉɛrɛ bhi bárɔk bagʉɛp bɛyǎ nkáp anyɛ́n, bákɛ́m bɛyǎ nsi. Ɛ́yá kpát bɛyǎ nkáp yap abho bɛrakati. ");
INSERT INTO kenNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Bámák batɨ̌ bawǎnsi abhɛn bachi ndǔ áchwí achak nɛ awɔ bɛ mántwɔ mánkwak bhɔ. Bárɔ́k bachɛm nɛ bhɔ, bafɛrɛ nsi báfyɛ́ amɛm bachwi apay kpát ábhó bɛbɛt. ");
INSERT INTO kenNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Símun anɛ mpɨ́kɨ́rí nnyɛ́n ɛni nɛchi bɛ Píta, ághɔ́ nɔ́kɔ́ ɛnyɨŋɨ́ maknkay yɔ, arɔk atɛp mánɛ́n bɛsí Yesu, arɛm bɛ, “Acha, kɛ́twɔ kɛkwɔt nɛ mɛ, mbɔnyunɛ nchí mmǔ bɛbʉ́.” ");
INSERT INTO kenNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Árɛ́m nɔ, mbɔnyunɛ yi nɛ batɨ bhi bachi nyaka maknkay tontó bɛghɔ bɛyǎ nsi ɛnɛ bakɛmɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Jems nɛ Jɔ̌n, batɨ̌ bawáy nsi, bábhák nkwɔ́ maknkay. Báchí nyaka bɔ̌ Sɛbɛdi. Yesu arɛm ntá Símun bɛ, “Kɛ́cháy. Bɛbho ɛchɔŋ ɔrɔbhɛ ya chí bo bɛ mantwɔ ntá ya.” ");
INSERT INTO kenNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Bɔ Píta bátɛ́mɛ́ nɔ́kɔ́ bachwi yap angɔkɔnyɛ́n, bárɔ́ yɛ̌ntɨkɨ ɛnyɨŋ bakoŋo Yesu. ");
INSERT INTO kenNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Mpok Yesu achi ɛtɔkɔ́fu, mmu ɛbhaŋákwa amɔt arɔk akwɛ́n yí bɛkak abho mɛnɨkmʉɛt ntá yi bɛ́, “Acha, mbák ɔkɔŋ, ɔ̌kway bɛkʉ mɛ ntaŋ.” ");
INSERT INTO kenNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu anyabhɛ awɔ́ atɔk yi arɛm bɛ, “Nkɔŋ bɛkʉ wɔ ɔ́ntáŋ, nɛme ɛnɛ nɛ́máy.” Tɛ́mté wu, ɛbhaŋákwa yi ɛmay. ");
INSERT INTO kenNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu asɛmti yí bɛ, “Kɛ́ ghati yɛ̌ mmu ɛnyɨŋ ɛnɛ ɛ́fákárí, kɛ dɔ́k ntá nchiakap Mandɛm bɛ yi angɔ bɛ ɛbhaŋákwa yɛ ɛmay. Ánáŋ ámbyó wɔ, ɔ́ndɔk, ɔnchyɛ yɛ akap ntá Mandɛm bɛ́kóŋo ɛbhé Moses. Chɔŋ ɛyɔ ɛ́mbak ɛnyɨŋ ɛnɛ ɛ́tɔ̀ŋ bo bɛ ɛbhaŋákwa yɛ ɛ́may.” ");
INSERT INTO kenNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Kɛ yɛ̌ nɔ, mbok Yesu ataka mbǎnkɛm. Ngɛ́mtay bo bárɔ́k ntá yi ndu bɛghók Ɛyɔŋ Mandɛm nɛ bɛ́ yi ambu mame yap. ");
INSERT INTO kenNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kɛ aya mmʉɛt arɔk ndǔ nɛbhʉ́ɛ́rɛ́fu amɛm baso anɨkmʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nywɔp nɛmɔt, Yesu ǎtɔ̀ŋ nyaka bho Ɛyɔŋ Mandɛm, Mandɛm Acha achyɛ yi bɛtaŋ, are bú bǒmame. Bǒnkwɔ Fárisi nɛ batɔŋ ɛbhé Mandɛm babhak arɛ́. Báfú ndǔ bɔ̌bɛtɔk mankɛm atú Gálili, nɛ bachak báfú atú Judɛ́ya, nɛ abhɛnɛfu báfú Yerúsalɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Bǒfú bátwɔ́ nɛ mbɛ́ntí amɔt anɛ bápɔ́kɔ́ ndǔ bɛkpaka. Báré yaŋ mbi bɛchwe anywɔ́p bɛ mambʉrɛ yi bɛsí Yesu. ");
INSERT INTO kenNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kɛ bɔ́ kɛbhɔ́ŋ mbi anɛ báfʉɛt manchwe amɛm ɛ̌ti bɛyǎ bó. Bákó amfǎy ɛkɛt, manɛnɛ mbok arɛ́, basɛbhɛ yi bhʉrɛ ndǔ bɛkpaka bhi, nɛ́ntɨ́ bhó, bɛsí Yesu. ");
INSERT INTO kenNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu ághɔ́ nɔ́kɔ́ ɛnyǔ nɛka ɛnɛ́n bábhɔ́ŋɔ́ nɛ yi, aghati mbɛ́ntí wu bɛ, “Nkwánɛ, mfóŋórí bɛbʉ́ bhɛ.” ");
INSERT INTO kenNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Batɔŋ-ɛbhé Mandɛm nɛ bǒnkwɔ Fárisi bábho bɛbhɛp mmʉɛ́t bɛ, “Agha nɛ́? Ɛnyɨŋ ɛnɛ yi árɛ̀m chi nsɔk ntá Mandɛm! Mandɛm aywǐnti kɛ ákway bɛfoŋori bɛbʉ́ mmu!” ");
INSERT INTO kenNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu arɨŋɨ nkaysi yap. Abhɛ́p bɔ́ bɛ, “Ndaká yí bǎkàysi mɛnyǔ mɛnyɨŋ ɛbhɔ? ");
INSERT INTO kenNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ɛnyɨŋ ɛnɛ ɛ́chí wɨkɨrɨk chí ɛnɛ́? Bɛrɛm bɛ, ‘Mfóŋórí bɛbʉ́ bhɛ’, kɛ chi bɛrɛm bɛ, ‘Faté kɔ’? ");
INSERT INTO kenNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kɛ chɔŋ nkʉ mǎndɨŋɨ bɛ, Mɛ Mmu mfú ntá Mandɛm mbɔ̌ŋ bɛtaŋ fá amɨk bɛfoŋori bɛbʉ́ bho.” Arɛm ntá mbɛ́ntí wu bɛ, “Nchí ghati wɔ, faté, pɔkɔ́ bɛkpaka bhɛ gurɛ!” ");
INSERT INTO kenNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tɛ́mté wu, afate kpɛrɛp bɛsí bhap, apɔkɔ ɛnyɨŋ ɛnɛ yi ábhʉ̀rɛ nyaka arɛ́, abho bɛgurɛ, ambɨti nɔkɔ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Bɛyǎ bɛcháy bɛkɛm bo mankɛm! Bábhák maknkay, babho bɛbɨti Mandɛm, mándɛmɛ nɔkɔ bɛ, “Sɛghɔ̌ baraká maknkay ɛchɔŋ!” ");
INSERT INTO kenNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Awu áfʉ́ɛ́rɛ́ nɔ́kɔ́, Yesu afa nɛbhʉɛ́rɛ́ wu arɔk aghɔ́ mbɛbhɛ́ nkabhɛ́nti anɛ áká nnyɛ́n bɛ Lɛ́vi chɔkɔ amɛm ɛkɛrɛ́bɛtɨk yi. Yesu aghati yi bɛ, “Twɔ́, bhák nkoŋo wa.” ");
INSERT INTO kenNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lɛ́vi afate, arɔ yɛ̌ntɨkɨ ɛnyɨŋ, abho bɛkoŋo Yesu. ");
INSERT INTO kenNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ɛ́bhɨ́kɨ́ tat, Lɛ́vi anak ɛrɛm ɛpa ɛkɛt yi ntá Yesu. Bɛyǎ babhɛbhɛ́ nkábhɛ́nti nɛ bakʉ̌ bɛbʉ́ bachak nkwɔ babhak arɛ́ nɛ Yesu. ");
INSERT INTO kenNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Bǒnkwɔ Fárisi nɛ batɔŋ ɛbhé Mandɛm, báré nywinti, nɛ bábhɛ́p bakoŋo Yesu bɛ, “Ndaká yí mǎnyìɛ mǎnyu nɔkɔ nɛ babhɛbhɛ́ nkabhɛntí nɛ bakʉ̌ bɛbʉ́ bachak?” ");
INSERT INTO kenNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu akɛmɛ bhɔ bɛ, “Bo abhɛn bapu me, bápú yaŋ ngaŋ. Bǒ mame kɛ báyàŋ ngaŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mbɨ́kɨ́ twɔ bɛbhɨŋɨ bo abhɛn bakaysi bɛ bachi chak bɛsí Mandɛm bɛ mántɨ́knsɛm ndǔ bɛbʉ́ bhap, ntwɔ bɛ́bhɨ́ŋɨ chi bo babʉ́babʉ́.” ");
INSERT INTO kenNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bo bárɛ́m ntá Yesu bɛ, “Bakoŋó Jɔ̌n Njwiti bátat nɔkɔ nsay ndu mɛnɨkmʉɛt. Bakoŋó nkwɔ Fárisi bákʉ̀ ɛnyumɔt. Kɛ abhɛ mányiɛ, mányu nɛ bapu tat nsay?” ");
INSERT INTO kenNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu akɛmɛ bhɔ bɛ, “Bǎkaysi bɛ mankɔ̌ abhɛn bachi ndǔ ɛpǎ nɛbhay bakway bɛbhak ndǔ nɛtarɛ́nsay? Nsé! Tɛ̌ndu mbǎyngɔrɛ́ abhʉɛ́t nɛ bhɔ, bápú kway bɛtat nsay. ");
INSERT INTO kenNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kɛ mpok ǎtwɔ̀ anɛ báfɛrɛ chɔŋ mbǎyngɔrɛ́ ntá yap. Nɛ chɔŋ mántarɛ nɔkɔ nsay ndǔ mpok yɔ.” ");
INSERT INTO kenNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu atɛ́m bɔ nɛkay ɛnɛ́n nkwɔ bɛ, “Yɛ̌ mmu apú kway bɛdak ɛbhɔ́kɔ́ndɛn ndǔ nkú anɛ nkɔ anchók mbok ndǔ ɛsɨ́ nku. Mbák mmu ánkʉ́ nɔ́, ǎchɔŋti nkú nkɔ, mbɔnyunɛ ɛbhɔ́kɔ́ndɛn ɛnɛ́ ɛ́fú ndǔ nkú nkɔ ɛ́pú kɔ nɛ ɛsɨ́ ndɛn. ");
INSERT INTO kenNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nɛ ntá bo abhɛn báfyɛ mmɛ́m ndǔ bɛbhǎ nkwɔbhɛnya, bápú fyɛ mmɛ̌m bakɔ amɛm ɛbhǎ nkwɔbhɛnya ɛnɛ́ ɛsɨ. Mbák mánkʉ́ nɔ, ɛbha ɛ́sɛn, ɛnchɔŋɔ, nɛ mmɛ́m andɔk amɨk. ");
INSERT INTO kenNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Bábhɔŋ bɛfyɛ mmɛ̌m bakɔ chi amɛm ɛbhǎ mmɛ́m ɛnɛ́ ɛkɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nɛ bápú nyu ɛsɨ́ mmɛ́m mánjaŋ amɛn bakɔ mbɔnyunɛ bákaysi bɛ ɛsɨ́ mmɛ́m arɨ̌ achá amɛn bakɔ.” ");
INSERT INTO kenNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Yesu nɛ baghɔkɔ́ bhi báré kɔ mámfʉɛt nɔkɔ amɛm nkɨ̌ nchwifú ndǔ nywɔbhɛ́ nɛywěmʉɛt bo Israɛl. Baghɔkɔ́ bhi bábho bɛkʉɛp ɛnyǔ nchwi yɔ, mámfɨkɨri mányiɛ nɔkɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mbɔk bǒnkwɔ Fárisi bábhɛp bɛ, “Ndaká yí bǎkʉ ɛnyɨŋ ɛnɛ ɛbhé yɛsɛ ɛ́pú yaŋ mankʉ ndǔ nywɔbhɛ́ nɛywěmʉɛt?” ");
INSERT INTO kenNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Kɛ Yesu akɛmɛ bhɔ bɛ, “Bǎbhɨ́kɨ́ re pay amɛm Ɛkáti Mandɛm ɛnyɨŋ ɛnɛ Mfɔ Debhít ákʉ́ nyaka nɛ bǒ abhɛn báchí nɛ yi mpok nsay ákɛ́mɛ́ bhɔ́? ");
INSERT INTO kenNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Achwe amɛm ɛkɛt Mandɛm, apɔkɔ nɛnyíɛ́ ɛnɛn báchyɛ́ mbɔ akap ntá Mandɛm akɔrɛ nɛ bɔ̌bhi mányíɛ́. Ɛbhé ɛ́rɛ̀m bɛ ndiɛrɛ bachiǎkap Mandɛm kɛ bákway mɛnyiɛ nɛnyíɛ́ ɛnɔ.” ");
INSERT INTO kenNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesu arɛm yɛ ntá yap bɛ, “Mɛ Mmu mfú ntá Mandɛm kɛ̌ mbɔ́ŋɔ́ bɛrɛm ɛnyǔ mmu ábhɔ́ŋɔ́ bɛkʉ nɛ ɛbhé ɛnɛ ɛ́yɨ́ŋɨ́ nywɔbhɛ́ nɛywěmʉɛt.” ");
INSERT INTO kenNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ndǔ nywɔbhɛ́ nɛywěmʉɛt nɛ́chák, Yesu achwe amɛm ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí bo Israɛl antɔŋ nɔkɔ bo Mbok Ndɨ́ndɨ́. Mmǔ amɔt abhak arɛ́ anɛ awɔ́nɛm aywi ágú. ");
INSERT INTO kenNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mbɔk batɔŋ ɛbhé Mandɛm nɛ bǒnkwɔ Fárisi abhɛn bachi arɛ́, bábháka ntɨ bɛ chɔŋ mámbɔŋ mbi ndu bɛrɛm bɛ yi akʉ ɛbɛ́ptí ndak. Bátɛ́p yɛ yi amɨ́k amʉɛt ndu bɛghɔ mbák chɔŋ Yesu ambú mmǔ wu ndǔ nywɔbhɛ́ nɛywěmʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yesu arɨŋɨ nkaysi yap. Arɛm ntá mmǔ wu bɛ, “Faté, twɔ́ fá ambɨ.” Mmǔ wu afate arɔk ate arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesu arɛm yɛ ntá bǒbhɔ bɛ, “Ɛbhé yɛsɛ́ ɛ́rɛm bɛ́ sɛ́nkʉ yi ndǔ nywɔbhɛ́ nɛywěmʉɛt? Chí bɛ́kʉ bɛrɨ kɛ bɛkʉ bɛbʉ́? Chí bɛ́pɛ́mɛ mmu kɛ chí bɛ́chɔŋti nɛpɛ́m ɛni?” ");
INSERT INTO kenNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesu ayibhiri mmʉɛ́t ayɨŋɨ bɔ́ mankɛm, arɛm ntá yi bɛ, “Nyabhɛ́ awɔ́ ywɛ.” Akʉ nɔ, awɔ́ ywi apɛt ataŋ, ábhák mbɔ ɛnyu ɛsɨ́. ");
INSERT INTO kenNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kɛ batɨ ábé bǒnkwɔ Fárisi nɛ batɔŋ ɛbhé tontó. Bábhó bɛsokori ɛnyɨŋ ɛnɛ́ bákway bɛkʉ Yesu. ");
INSERT INTO kenNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ndǔ manywɔbhɛ́ yɔ, Yesu akó amfǎy njiɛfú ndu mɛnɨkmʉɛt. Anɨkmʉɛt ntá Mandɛm bɛtǐ mɛnkɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nɛ́yí nɔ́kɔ́, abhɨŋɨ bakoŋo bhi bɛ mántwɔ́ ntá yi. Bátwɔ́ nɔ́kɔ́, ayap bhɔ́ batí byo nɛ apay, áchyɛ́ bhɔ́ nnyɛ́n bɛ bǒnto. ");
INSERT INTO kenNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Manyɛ́n yap áchí nyaka bɛ: Símun anɛ Yesu áchyɛ́ nnyɛ́n nɛchak bɛ Píta, nɛ mɔ̌máyi Andru, nɛ Jems nɛ Jɔ̌n, nɛ Fílip nɛ Batolómio, ");
INSERT INTO kenNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","nɛ Mátio, nɛ Tɔmás, nɛ Jems mmɔ̌ Alfeyɔs, nɛ Símun mfyɛ̌-bɛtaŋ ndǔ baraká ɛtɔk, ");
INSERT INTO kenNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","nɛ Júdas mmɔ̌ Jems, nɛ Júdas Iskariɔt anɛ átí nyaka Yesu. ");
INSERT INTO kenNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu asɛp antɛ̌n njiɛ ndǔ mmɨk nɛbhʉɛt nɛ bhɔ́. Ngɛ́mtay bakoŋo bhi bábhák arɛ́ nɛ ngɛ́mtay bo bachak abhɛn báfú Yerúsalɛm nɛ abhɛn báfú atú Judɛ́ya ankɛm. Bo báfú ndǔ bɛtɔk bɛ́páy ɛbhɛn bɛchi kɛkwɔt nɛ manyu ɛbhɛn bábhìŋɨ bɛ Táya nɛ Sídɔn. ");
INSERT INTO kenNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bátwɔ́ bɛghók mɛnyɨŋ ɛbhɛn yi átɔ̀ŋ nɛ bɛ yi ámbu bhɔ. Nɛ bo abhɛn bɛfóŋó bɛbʉ́bɛbʉ bɛ́sɔ̀ŋɔri bhɔ, bataŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Bǒ bhɔ mankɛm bare nu bɛtɔk Yesu, mbɔnyunɛ bɛtaŋ bɛ́fù nyaka yi amʉɛt mɛ́mbu nɔkɔ yɛ̌ ághá anɛ átɔk yi. ");
INSERT INTO kenNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu ayoŋ amɨ́k ayɨŋɨ bakoŋo bhi arɛm bɛ, “Ɛ́rɨ ɛcha ntá yɛka bachɛ́bhɛ́bho; mbɔnyunɛ Mandɛm achi Mfɔ ywɛka. ");
INSERT INTO kenNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ɛ́rɨ ɛcha ntá yɛka bǒ nsay ánù nɛ́nɛ, mbɔnyunɛ chɔŋ yi anchyɛ bhe mɛnyɨŋ ɛbhɛn bǎbhɔ́ŋɔ́ ɛkwak bɛbhɔŋ. Ɛ́rɨ ɛcha ntá yɛka bǒ bǎdì kɛbhɔ nɛ́nɛ, mbɔnyunɛ chɔŋ mǎngway ámɛn! ");
INSERT INTO kenNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Ɛ́rɨ ɛcha ntá yɛka mpok bo bápàp bhe, nɛ mánsɔkɔti nɔkɔ bhe nɛ mándɛm bɛbɛ́pti mɛnyɨŋ ɛ̌ti yɛka, nɛ mándɛm nɔkɔ bɛ bǎchí bɛbɛ́ptí bho ɛ̌ti ya, Mɛ Mmu mfú ntá Mandɛm! ");
INSERT INTO kenNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Bɔ́ŋ ká maŋák yɛ̌ntɨkɨ mpok anɛ ɛ́fákárí nɔ́ nɛ bhe, mbɔnyunɛ Mandɛm abhʉ́rɛ́ ɛrɛm ákap ntá yɛka awu amfay. Nchí ghati bhe mbɔnyunɛ ɛnyu ɛyɔ kɛ bachǐmbɨ bhap bǎchyɛ̀ nyaka barɛmɛ́ kɛpɨ̌ntɨ Mandɛm ɛsɔŋɔri. ");
INSERT INTO kenNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kɛ chɔŋ ɛ́mbɛp ntá yɛka bafɔ̌nkáp ɛncha mbɔnyunɛ, mǎnaŋ bǎbhɔŋ ɛbhɛka bɛrɨ́tí mɛnyɨŋ, nɛ mǎnyiɛ̌ nɛpɛ́m, ndak ámay. ");
INSERT INTO kenNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Chɔŋ ɛ́mbɛp ntá yɛka bǒ mǎnyìɛ mǎnjwi nɛ́nɛ, mbɔnyunɛ chɔŋ nsay anu bhe! Chɔŋ ɛ́mbɛp ntá yɛka bo bǎwày ámɛ́n nɛ́nɛ, mbɔnyunɛ chɔŋ mǎndɔp ndǔ basɛ́mɛ́ nɛ nɛdǐ kɛbhɔ! ");
INSERT INTO kenNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Chɔŋ ɛ́mbɛ́p ntá yɛka, be bho bo bǎrɛ̀m ɛrɨ́rɨ́ ɛ̌ti yɛka, mbɔnyunɛ ɛnyu yɔ kɛ̌ bachǐmbɨ bhap bárɛ̀m nyaka ɛ̌ti barɛmɛ́ kɛpɨ̌ntɨ nsé.” ");
INSERT INTO kenNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yesu arɔk ambɨ bɛtɔŋ. Arɛm bɛ, “Kɛ nchí ghati bhe bho bǎghòk mɛ bɛ, kɔ́ŋ ká bo abhɛn bápábhɛ́ bhe, mǎntɔŋ bɔ́ bɛrɨ. ");
INSERT INTO kenNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nɨk nɔkɔ ká mmʉɛt bɛ Mandɛm ankwak bo abhɛn bárɛ̀m ɛbʉ́bʉ ɛ̌ti yɛka. ");
INSERT INTO kenNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mbák mmu adɛp wɔ atá ndǔ ɛbhe awɔ́nɛm, tɔ́ŋ yi ɛbhe ɛ́chák nkwɔ. Nɛ mbák mmu ásɔt ndɛ́ yɛ, dɔ̌ yi ansɔt yɛ̌ chí nkú yɛ nkwɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mbák mmu anɨ́ŋɨ́ wɔ ɛnyɨŋ ɛnɛ ɔ́bhɔ́ŋɔ́, chyɛ̌ yi. Nɛ mbák mmu asɔt ɛnyɨŋ ɛyɛ, kɛ́ghati yi bɛ ákɛ́mɛ́ yɔ ntá yɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nɛ yɛ̌ntɨkɨ mmu ywɛka ánkʉ́ yɛ nɛ batɨ mbɔ ɛnyǔ yi ákway bɛyaŋ bɛ bo mánkʉ ntá yi. ");
INSERT INTO kenNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Mbák bǎkɔ̀ŋ chi bo abhɛn bakɔŋ be, bakak amɛn bábhɔ́ŋɔ́ bɛ́chyɛ bhe ǎbhák bɛ yi? Yɛ̌ chí bǒ bɛbʉ́ bákɔŋ bo abhɛn bakɔŋɔ bhɔ! ");
INSERT INTO kenNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nɛ mbák bǎkʉ̀ bɛrɨ chi ntá bo abhɛn bákʉ̀ bhe bɛrɨ bakak amɛn bábhɔ́ŋɔ́ bɛchyɛ bhe ǎbhák bɛ yi? Yɛ̌ chí bakʉ̌ bɛbʉ́ bákʉ̀ nɔ! ");
INSERT INTO kenNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nɛ mbák bǎpwɔ̀ mɛnyɨŋ chí ntá bo abhɛn bǎbhaka ntɨ bɛ bakɛmɛ ntá yɛka, bakak amɛn bábhɔ́ŋɔ́ bɛchyɛ bhe achi bɛ yi? Yɛ̌ chí bǒ bɛbʉ́ bápwɔ̀ nkwɔ mɛnyɨŋ ntá batɨ̌ bakʉ̌ bɛbʉ́, ndu bákɛmɛ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ bápwɔ́ ntá yap! ");
INSERT INTO kenNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kɛ bǎbhɔŋ bɛbhak kɛkúrí! Kɔŋ ka bǒmpap abhɛka, nɛ mǎnkʉ bhɔ bɛrɨ. Pwɔ ka bhɔ́, kɛbhaka ntɨ bɛ chɔŋ mánkɛmɛ bhe yɛ̌ntɨkɨ ɛnyɨŋ. Mbák bǎkʉ̀ ɛnyu yɔ, chɔŋ akap aywɛká ánja ancha, nɛ mǎmbak bɔ Mandɛm Acha. Ǎtɔ̀ŋ bɛrɨ̌ntɨ ntá bǒ bɛbʉ́ abhɛn bápú kaka yi nɛ abhɛn máŋɛ̀m mɛŋɛ́mɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ghɔ́ ká batɨ ntínso, nkúbhɛ́ mbɔ ɛnyǔ Mandɛm ághɔ̀ bhe ntínso.” ");
INSERT INTO kenNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yesu yi bɛ, “Bǎkɛ́ táŋ batɨ kɛka mántáŋ be. Bǎkɛ́ rɛm bɛ mánchyɛ́ batɨ ntɛ́msi, nɛ mbák bǎpú rɛm nɔ, bápú rɛm bɛ manchyɛ bhe ntɛmsi. Foŋorí nɔ́kɔ́ ka batɨ nɛ chɔŋ mámfoŋori nɔkɔ bhe. ");
INSERT INTO kenNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Chiɛ́ ntá ntɨ, nɛ chɔŋ Mandɛm anchyɛ wɔ nkwɔ́. Yi apɛrɛ́ chyɛ, ǎyɛnti sayri, angoko kpát ɛ́njwi ɛntakati nɔkɔ amɨk. Ɛnyǔ ɛnɛ́ ɔ́yɛ̀nti ɔnchyɛ ntɨ, nkúbhɛ́ ɛnyuyɔ̌ kɛ báyɛ̀nti manchyɛ wɔ.” ");
INSERT INTO kenNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu atɛ́m bɔ nɛkay nkwɔ bɛ, “Nnɛmámɨ́k apu kway bɛyǎ ntɨ nnɛ́mámɨ́k mbi. Mbák ándɔ́k bɛkʉ nɔ, bɔ́ batí apay bápú kwɛn amɛm nɛpi? ");
INSERT INTO kenNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mmɔ̌káti apu kway bɛrɨŋɨ ɛnyɨŋ ancha ntɔ̌ŋ aywi. Kɛ mpok anɛ bátɔ́ŋ yi kpát ánaŋa nɛghɔ́k ɛni, ǎbhák mbɔ ntɔ̌ŋ aywi. ");
INSERT INTO kenNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ndaká yí ɔ́yɨ̀ŋɨ mɔ́ɛ̌nyɨŋɨ anɛ achi anyɛsɛ ntɨ, ɛnɛ́ ɔ́pú fyɛ nti ndǔ nkɔkɔ́nɔk anɛ achi wɔ anyɛsɛ? ");
INSERT INTO kenNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ná ɔ́ghàti ntɨ bɛ, ‘Manɔ́, dɔ̌ mfɛ́rɛ́ mɔ́ɛ̌nyɨ́ŋɨ́ anɛ achi wɔ anyɛ́sɛ́,’ ɛnɛ́ wɔmbɔŋ ɔpú ghɔ́ nkɔkɔ́nɔk anɛ achi amɛm ɛnɛ nyɛ́sɛ́? Wɔ mmǔ bɛtábhá! Fɛrɛ́ kpɨ́k nkɔkɔ́nɔk anɛ achi wɔmbɔ̌ŋ anyɛsɛ, kɛ ɔ́ngɔ yɛ mbaŋ sayri ndu bɛ́fɛ́rɛ mɔ́ɛ̌nyɨ́ŋɨ́ anɛ achi amɛm nyɛ́sɛ́ manɔ́ywɛ.” ");
INSERT INTO kenNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesu apɛt arɛm bɛ, “Ɛrɨ́tí ɛnɔk ɛ́pú nyu bɛbɛ́ptí kɛpɛm. Nɛ ɛbɛ́ptí ɛnɔk ɛ́pú nyu bɛrɨ́tí kɛpɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Bárɨŋɨ ɛrɨ́tí ɛnɔk chí ndǔ kɛpɛm ɛki. Bápú rɔŋ ndu támfáŋ mánkɔ́k nɛpɨ. ");
INSERT INTO kenNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nkúbhɛ́ mbɔ ɛnyǔ nkáp ájwi amɛm mɔ́kɛrɛ́ nkáp, nɔ́ kɛ̌ nkaysi ndɨ́ndɨ́ ájwì antɨ mmǔ ndɨ́ndɨ́, nɛ bɛrɨ bɔ́bhɔ́ kɛ bɛ́fù arɛ́. Kɛ mbák mmú abhɔ̌ŋ ɛbɛ́ptí ntɨ, barak abʉ́abʉ kɛ áfù yi anyu, mbɔnyunɛ ɛnyɨŋ ɛnɛ́ ɛ́jwí mmu antɨ, yɔ́ kɛ ɛ́fù yi anyu.” ");
INSERT INTO kenNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yesu arɛm bɛ, “Ndaká yí bǎbhɨ̀ŋɨ mɛ bɛ, ‘Acha, Acha’, ɛnɛ́ bǎpú kʉ ɛnyɨŋ ɛnɛ mɛ̌ghàti bhe? ");
INSERT INTO kenNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Chɔŋ ntɔ́ŋ be ɛnyǔ mmǔ anɛ átwɔ́ ntá ya, aghók ɛnyɨŋ ɛnɛ ndɛ́mɛ́, ankʉ mbɔ ɛnyǔ yi ághókó achi. ");
INSERT INTO kenNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Achí mbɔ mmǔ anɛ áyámbɨ átɛ́mɛ́ nɛbhʉ́ɛ́rɛ́kɛt kpát nɛ́chwé nɛ́ghaka ndǔ sɛtárɛ́bhɛ́ kɛ ǎte ɛkɛt. Nɛ mpok nnyɛ́n nɛ́gbókó kpát nɛ́ghaka ndǔ ɛkɛt, ɛ́bhɨ́kɨ́ moko ɛ́nkwɛ́n mbɔnyunɛ até yɔ sayri. ");
INSERT INTO kenNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kɛ mmu anɛ ághok mɛnyɨŋ ɛbhɛn mɛ̌rɛ̀m yi kɛ kʉ mbɔ ɛnyǔ ndɛ́mɛ́, achí mbɔ mmu anɛ áté ɛkɛt, yi kɛ yambɨ bɛghoko nɛbhʉ́ɛ́rɛ́kɛt sayri. Mpok nnyɛ́n nɛgboko nɛ́ghaka ndǔ ɛkɛt, tɛ́mté wu, ɛ́báy mmʉɛt amɨk juu, ɛ́chɔ́ŋɔ ɛnkɛm!” ");
INSERT INTO kenNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu anáŋá nɔ́kɔ́ bɛtɔŋ bo mɛnyɨŋ ɛbhɛn mɛnkɛm, afa apɛtnsɛm ɛtɔk Kapɛ̌naum. ");
INSERT INTO kenNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mǔnti nkwɔ batɛmɛ́ nɛnu bǒ Rom amɔt achi nyaka arɛ́. Mǔbɛtok aywi anɛ yi aré kɔŋ áre me. Arɔp chi kɛkwɔt bɛ́gu. ");
INSERT INTO kenNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mǔnti wu ághókó nɔ́kɔ́ ndǔ bo bárɛ̀m ɛ̌ti Yesu, ató bǒbati bǒ Israɛl bɛ mánɨ́kmʉɛt nta yi bɛ ándɔ́k ámbú mǔbɛtok aywi. ");
INSERT INTO kenNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bárɔ́k ntá Yesu mánɨkmʉɛt nta yi nɛ nɛsɛptímʉɛt mándɛmɛ nɔkɔ bɛ, “Ɛta, dɔ́k kwák mǔnti-nɛ. Achi mmu anɛ ákwáy bɛ́bhɔŋ nɛkwak. ");
INSERT INTO kenNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Akɔŋ bǒ bhɛsɛ nɛ yímbɔŋ kɛ áté ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí ɛyɛsɛ.” ");
INSERT INTO kenNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesu are rɔ́ŋ nɛ bhɔ. Mpok bághaka kɛkwɔt nɛ ɛkɛt, mǔnti wu ató mamʉɛrɛ bhi bɛ́ mángátí Yesu bɛ, “Acha, kɛ́sɔŋɔri mmʉɛt bɛ́twɔ ndǔ ɛkɛt ɛya. Mbɨ́kɨ́ kway mmu anɛ ɔ́twɔ́ ɛkɛt ɛyi. ");
INSERT INTO kenNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yɛ̌ chi mɛmbɔŋ mbɨ́kɨ́ kaysi bɛ nkway bɛ́twɔ ntá yɛ. Chiɛ̌ chí ɛyɔŋ, chɔŋ mǔbɛtok wa antaŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nchí rɛm nɔ mbɔnyunɛ mɛ nkwɔ́ mbɔ̌ŋ bo abhɛn, mbák mángátí mɛ nkʉ ɛnyɨŋ, mbɔ̌ŋ bɛghok bhɔ. Nɛ mbɔ̌ŋ nkwɔ́ batɛmɛ́ nɛnu antɛnɛ ya abhɛn mbák ngátí bhɔ ɛnyɨŋ, bábhɔŋ bɛghok mɛ́. Yɛ̌ntɨkɨ mmu wap anɛ ndɛ́mɛ́ bɛ, ‘Dɔ́k’, ǎrɔŋ, nɛ yɛ̌ agha anɛ ndɛ́mɛ́ bɛ, ‘Twɔ́’, ǎtwɔ. Nɛ mbák ngátí mɔ̌bɛtok awa bɛ, ‘Kʉ ɛnyɨŋ ɛnɛ’, abhɔŋ bɛkʉ yɔ.” ");
INSERT INTO kenNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu ághókó nɔ́kɔ́ nɔ, abhak maknkay tontó. Ayibhiri mmʉɛt arɛm ntá bɛyǎ bo abhɛn bákòŋo yi bɛ, “Dɨŋɨ́ ká tɛtɛp bɛ, mbɨ́kɨ́ re ghɔ mmǔ Israɛl amɔt anɛ ábhɔ́ŋɔ́ nɛka nɛ mɛ mbɔ kɛnkɔ̌-nɛ.” ");
INSERT INTO kenNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Mamʉɛrɛ́ abhɛn mǔnti wu átó bápɛtnsɛm ɛkɛt ɛyi, bághɔ́ bɛ mǔbɛtok ywi anáŋ ataŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ansɛm mpok, Yesu nɛ baghɔkɔ́ bhi báfá báre rɔŋ ɛtɔk Naín. Ngɛ́mtay bo báre rɔŋ nɛ bhɔ́. ");
INSERT INTO kenNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ndu bágháká antítɔk, bághɔ́ ndǔ bo bápɔ́kɔ́ ngú báfù ɛtɔk bɛrɔŋ bɛbhɛmɛ. Ngú wu abhak njaŋamɔ ntá máyi anɛ achí nyaka kɛ́nkwɛ́sɛ́. Tóntó bo ɛtɔk ɛyɔ báré koŋo nkɔ́kɔ́ngu. ");
INSERT INTO kenNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Acha aghɔ́ nɔ́kɔ́ ngɔrɛ́ wu, ntínso nɛ́kɛ́m yi tontó, arɛm ntá yi bɛ, “Kɛ́pɛrɛ di.” ");
INSERT INTO kenNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Arɔk, atɔk nkɔ́k anɛ́ bápɔkɔ ngú arɛ́. Bo abhɛn bápɔ́kɔ́ ngú báte. Yesu aghati ngú wu bɛ, “Ɛsakámu! Nchí ghati wɔ, faté.” ");
INSERT INTO kenNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tɛ́mté wu, afaté achɔkɔ chɔ́kɔ́, abho bɛrɛm kɛpɨ. Yesu asɔt yi achyɛ ntá máyi. ");
INSERT INTO kenNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Bɛcháy bɛ́kɛ́m bo mankɛm abhɛn báchí arɛ́. Bábhó bɛbɨti Mandɛm mándɛmɛ́ nɔkɔ bɛ, “Ɛtaŋtí ndɛmɛkɛpɨ̌ntɨ Mandɛm afú fá ndǔ nkwɔ́ ywɛsɛ! Mandɛm atwɔ bɛ́pɛ́mɛ bǒbhi!” ");
INSERT INTO kenNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Mbok ɛ̌tí yi akɔ aghabhɛri mmɨk bo Judeya nkɛm kpát aghaka ndǔ bɛtɔk bɛchák ɛbhɛn bɛchi kɛkwɔt. ");
INSERT INTO kenNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Mpok anɛ bakoŋó Jɔn Njwiti nkwɔ bághókó mɛnyɨŋ ɛbhɛn bɛ́fàkari bágháti yi bɔ́ mɛnkɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Abhɨŋɨ batí apay, ató ntá Acha bɛ mámbɛ́p yi bɛ, “Wɔ kɛ ɔ́chí Mpɛmɛ anɛ Jɔ̌n árɛ́mɛ́ bɛ ǎtwɔ, kɛ chi bɛ sɛ́bhɔŋ mɛnoŋ mmu achak?” ");
INSERT INTO kenNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bárɔ́k ntá Yesu bárɛm bɛ, “Jɔ̌n Njwiti ató bhɛsɛ́ bɛ sɛ́mbɛp wɔ bɛ, ‘Wɔ kɛ ɔ́chí Mpɛmɛ anɛ Jɔ̌n árɛ́mɛ́ bɛ ǎtwɔ, kɛ chi bɛ sɛ́bhɔŋ mɛnoŋ mmu achak?’” ");
INSERT INTO kenNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Bátwɔ́ nɛ ntó ɛnɔ ntá Yesu mpok yi ábù bɛyǎ bho abhɛn bábhɔ́ŋɔ́ nyaka mame mɛnyu nɛ mɛnyu. Ǎbòk nyaka nkwɔ bɛfóŋó bɛbʉ́bɛbʉ mɛ́ndɔ nɔkɔ bho, ankʉ nɔkɔ manɛ́mámɨk mángɔ mbáŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Akɛmɛ baghɔkɔ́ Jɔ̌n bɛ, “Pɛt ka nsɛm ghati Jɔ̌n mɛnyɨŋ ɛbhɛn bǎghɔ́ nɛ ɛbhɛn bághókó bo bárɛ̀m: Bǎghók nɛ bǎghɔ́ bɛ manɛ́mámɨk bághɔ̀ mbaŋ nɛ́nɛ, nɛ bakɛm báfáté bákɔ̀. Bǒ ɛbhaŋákwa bátáŋ nɛ babhók bághòk mbaŋ. Bawú bápɛtnsɛm ndǔ nɛpɛ́m nɛ bághàti bachɛ́bhɛ́bho Mbok Ndɨ́ndɨ́. ");
INSERT INTO kenNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nɛ ɛ́rɨ ɛcha ntá mmǔ anɛ ápú kwɛ́n ndǔ bɛbʉ́ ɛ̌ti mɛnyɨŋ ɛbhɛn mɛ̌kʉ̀.” ");
INSERT INTO kenNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Bapɔkɔ́ ntó Jɔ̌n bhɔ bápɛ́rɛ́ nɔ́kɔ́ nsɛm, Yesu abho bɛrɛm ntá bɛyǎ bo abhɛn bárɔ́ŋɔ́ nɛbhʉɛt anɛ yi achi ɛ̌ti Jɔ̌n bɛ, “Mpok bǎrɔ̀ŋ nyaka awu amɛm baso, bǎrɔ́k bɛghɔ ntɨkɨ ɛnyǔ mmʉ? Bǎrɔk bɛghɔ mmu anɛ achi mbɔ ɛ̌nsɔ́manyiɛp ɛnɛ babhʉ́ɛ́p áfòk ɛ́nkwɛ́n ɛnɛ ɛbhe, ámfok ɛnkwɛn ɛbhe ɛ́chák kɛ? ");
INSERT INTO kenNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Bǎrɔŋ nyaka amɛm baso bɛghɔ yi? Mmu anɛ afyɛ́ bɛrɨ́tí ndɛn amʉɛt kɛ? Bǒ abhɛn báfyɛ̀ mɛnyǔ ndɛn ɛbhɔ báchɔ̀kɔ chi amɛm bɛkírí-bafɔ! ");
INSERT INTO kenNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ghatí ká mɛ. Bǎrɔŋ nyaka amɛm baso bɛghɔ ntɨkɨ ɛnyʉ̌ mmu? Ndɛmɛkɛpɨ̌ntɨ? Ɛ́chi tɛtɛp. Kɛ dɨŋɨ́ ká bɛ mmu anɛ bǎghɔ́ achá ndɛmɛkɛpɨ̌ntɨ. ");
INSERT INTO kenNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jɔ̌n kɛ achi mǔntó anɛ basɨŋ nyaka amɛm Ɛkáti Mandɛm ɛ̌ti yi bɛ, Mandɛm arɛm bɛ, ‘Yɨŋɨ́, chɔŋ ntó mpɔkɔntó wa wɔ ambɨ, bɛ ángókó mbi ywɛ kɛ ɔ́ntwɔ.’ ");
INSERT INTO kenNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nchí ghati bhe bɛ Jɔ̌n Njwiti achá yɛ̌ntɨkɨ mmu achak ndǔ abhɛn bágú nɛ abhɛn bachi nɛpɛ́m. Yɛ̌ nɔ́, yɛ̌ chí mmu anɛ apu yɛ̌nyɨŋ ndǔ mpǎy bho abhɛn Mandɛm achi nɛ bhɔ mbɔ Mfɔ wap, acha yi.” ");
INSERT INTO kenNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Bo bághókó nɔ́kɔ́ ɛnyu yɔ, bɔ mankɛm nɛ babhɛbhɛ́ nkábhɛ́nti barɛm yɛ bɛ, nkaysi Mandɛm achi tɛtɛp. Barɛm ɛnyu yɔ, mbɔnyunɛ manaŋ baka nyaka nkwɔ bɛ́ Jɔ̌n anjwiti bhɔ́. ");
INSERT INTO kenNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kɛ bǒnkwɔ Fárisi nɛ batɔŋ ɛbhé Mandɛm bábhɨ́kɨ́ ka nyaka bɛ Jɔ̌n anjwiti bhɔ. Ɛnyu ɛyɔ, bábyak nkaysi anɛ Mandɛm abhɔŋɔ nɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu arɔk ambɨ bɛrɛm bɛ, “Chɔŋ njɛnti mkpáká bho abhɛn ɛchɔŋ nɛ yi? Bachi mbɔ yi? ");
INSERT INTO kenNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Báchí mbɔ bɔ̌ abhɛn báchɔ́kɔ́ nɛfí ɛsiɛ́. Kɛ mbɔk mámbɨŋɨ nɔkɔ abhɛnɛfu bɛ, ‘Sɛ́kwǎy bakwáy nɛbhay bɛ mǎmbɛn nɛbhɛ́n, kɛ bǎbhɨ́kɨ́ bhɛn. Sɛ́kwáy bakwáy nɛwú, kɛbhɔ bě kɛdi!’ ");
INSERT INTO kenNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jɔ̌n Njwiti atwɔ nyaka antarɛ nɔkɔ nsay ndu mɛnɨkmʉɛt, nɛ mmɛ́m yi kɛnyu. Bě bǎre rɛm bɛ, ‘Ɛfóŋó ɛbʉ́bʉ ɛchi nɛ yi!’ ");
INSERT INTO kenNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mpok Mɛ Mmu mfú ntá Mandɛm ntwɔ́, nde nyiɛ, nnyú nɔkɔ. Běka bǎre rɛm bɛ, ‘Ghɔ́ ká yi awu, nyiɛ̌ mɛnyɨŋɨ́nyíɛ́ nɛ nyǔmɛm. Mamʉɛrɛ bhi chi babhɛbhɛ́ nkábhɛ́nti nɛ bakʉ̌ bɛbʉ́ bachak!’ ");
INSERT INTO kenNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kɛ dɨŋɨ́ ká bɛ mɛnyɨŋ ɛbhɛn mmu anɛ ákɔ́ŋ mbi Mandɛm ákʉ̀ kɛ bɛ́tɔ̀ŋ bɛ nɛrɨŋɨ́ndak ɛnɛ́n nɛ́fú ntá Mandɛm nɛchi tɛtɛp.” ");
INSERT INTO kenNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ɛ́fákári bɛ mǔnkwɔ Fárisi amɔt abhɨ́ŋɨ́ Yesu bɛ ányíɛ́ nɛnyíɛ́ ɛkɛt yi. Yesu aka, arɔk, achɔkɔ are nyiɛ nɛnyíɛ́ nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ngɔrɛ́ nɛkɔ amɔt anɛ achi nyaka ɛtɔk ɛyɔ, ághók bɛ Yesu ǎnyiɛ nɛnyíɛ́ amɛm ɛkɛt ɛnɛ́ mǔnkwɔ Fárisi wu. Asɔt ɛ́kpɛ́mɛ́ bawɛrɛ́riɛp arɔk arɛ́ nɛ yɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ate kɛ́kwɔ́t nɛ Yesu andi nɔkɔ kɛbhɔ. Babhɛsɛ mi are chɨtí bɛkak Yesu. Atɛp ntí amɨk antɛsɛ nɔkɔ bɛkak Yesu nɛ ɛmɛnɛ́nti yi, angwati nɔkɔ nɛ bawɛrɛ́riɛp. ");
INSERT INTO kenNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mǔnkwɔ Fárisi wu aghɔ nɔ́kɔ́ nɔ́, are kaysi amɛm ntɨ ɛni bɛ, “Mbɔ mmǔ-nɛ achi ndɛmɛkɛpɨ̌ntɨ Mandɛm tɛtɛp, mbʉ arɨ́ŋɨ́ ɛnyǔ mmu anɛ ngɔrɛ́ anɛ átɔ̀k yi achi. Chí ngɔrɛ́ nɛkɔ.” ");
INSERT INTO kenNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Kɛ Yesu abhɨŋɨ mǔnkwɔ Fárisi wu bɛ, “Símun, mbɔ̌ŋ ndak bɛ́ghati wɔ.” Símun akɛmɛ bɛ, “Ntɔŋ, dɔ́k ambɨ.” ");
INSERT INTO kenNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu abho yɛ̌ bɛ́tɛm nɛkay ɛnɛn bɛ, “Mmǔ amɔt apwɔ nyaka nkáp ntá bǒ batí apay. Amɔt akɛ́m yi bɛbhǎ nkáp byo. Anɛfú ɛbhǎ nkáp ɛ́mɔt. ");
INSERT INTO kenNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Mmǔ wu abhɛ́p nkáp anɛ bákɛ̀m yi, kɛ yɛ̌ mmu wap kɛ kway bɛkɛmɛ anɛ́ yi ákɛ̀m. Afɔ̌ kɛ̌ yi afoŋori bhɔ́ mankɛm, afɛrɛ ntɨ ndǔ nkáp wu. Ghatí yɛ́ mɛ, ndǔ bati yap ápay, ntɨkɨ mmu ákway bɛkɔŋ mpwɔnkáp wu ancha anɛfu?” ");
INSERT INTO kenNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Símun akɛmɛ bɛ, nkáysi bɛ, “Chi anɛ barɛm ami áyá.” Yesu arɛm bɛ, “Ɔrɛm tɛtɛp.” ");
INSERT INTO kenNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kɛ Yesu ayibhiri mmʉɛt ayɨŋɨ anɛ ngɔrɛ́ wu, arɛm ntá Símun bɛ, “Yɨŋɨ́ mɔ́ngɔrɛ́-nɛ. Tɛ nchwé ɛkɛt ɛyɛ, ɔbhɨ́kɨ́ chyɛ mɛ manyiɛp nsó bɛkak, kɛ yí asó bɛkak ɛbha nɛ babhɛsɛ mi, atɛsɛ nɛ ɛmɛnɛ́nti yi. ");
INSERT INTO kenNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ɔbhɨ́kɨ́ syɛpti mɛ nɛ kɛnókó mbɔ ɛnyǔ ɔ́bhɔ́ŋɔ́ bɛkʉ, kɛ yi abhʉ́ɛ́t mɛnyɔti bɛkak ɛbha. ");
INSERT INTO kenNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ɔbhɨ́kɨ́ wati mɛ ntí nɛ bawɛt kɛ yí ǎwati mɛ bɛkak nɛ bawɛrɛ́riɛp. ");
INSERT INTO kenNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nchi ghati yɛ́ wɔ bɛ́ mɔ́ngɔrɛ́-nɛ atɔ̌ŋ bɛyǎ ɛkɔŋ bɛtɔŋ bɛ Mandɛm afóŋórí bɛyǎ bɛbʉ́ ɛbhɛn yi ákʉ́. Kɛ mmu anɛ ákáysí bɛ bɛbʉ́ bhi ɛbhɛn Mandɛm ákway bɛfóŋóri bɛ́bhɨ́kɨ́ ya, ǎtɔ̀ŋ chi mandú ɛkɔŋ.” ");
INSERT INTO kenNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yesu arɛm yɛ ntá mɔ́ngɔrɛ́ wu bɛ, “Mfóŋórí bɛbʉ́ ɛbhɛ.” ");
INSERT INTO kenNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Kɛ bǒ abhɛn mányìɛ nɛnyíɛ́ nɛ Yesu bábho mɛnywinti mándɛmɛ nɔkɔ bɛ, “Agha nɛ́, anɛ árɛ̀m tɛ bɛ yi ǎfòŋori bɛbʉ́?” ");
INSERT INTO kenNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesu apɛt arɛm ntá mɔ́ngɔrɛ́ wu bɛ, “Dɔ́k sayri, nɛka ɛnɛ̌ nɛ mɛ nɛ́kʉ ɔtaŋ.” ");
INSERT INTO kenNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ɛ́bhɨ́kɨ́ tat, Yesu are kɔ amɛm bɛtɔk bɛgho nɛ ndǔ bɔ̌bɛtɔk angati nɔkɔ Mbok Ndɨ́ndɨ́ ɛ̌ti ɛnyu ɛnɛ́ Mandɛm ábhak nɛ bho mbɔ Mfɔ wap. Baghɔkɔ́ bhi bati byo nɛ apay bábhák nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Mpáy baghɔrɛ́ bákɔ̀ nyaka nkwɔ nɛ bhɔ. Bábhák baghɔrɛ́ abhɛn Yesu ábú mame yap nɛ mbɔk bábhák abhɛn Yesu ábókó bɛfóŋó bɛbʉ́bɛbʉ ɛbhɛn bɛ́sɔŋɔri nyaka bhɔ. Ngɔrɛ́ amɔt abhak arɛ́ anɛ áká nnyɛ́n bɛ María mmɔ̌ ɛtɔk Mágdala. Yesu anáŋ abok nyaka bɛfóŋó bɛbʉ́bɛbʉ tándrámɔt ɛbhɛn bɛ́sɔ̀ŋɔri yí. ");
INSERT INTO kenNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Anɛfú abhak Joana, ngɔrɛ́ Kusa, mmǔ anɛ achi nkɛ́mfɔ ntá Mfɔ Hɛ́rɔd. Anɛfú abhak Susana. Nɛ bɛyǎ baghɔrɛ́ bachak. Bɔ básɔt nyaka nkáp awap mánkwak nɔkɔ bɛ Yesu nɛ baghɔkɔ́ bhi mámbɔ́ŋ mɛnyɨŋ ɛbhɛn bɛchɛbhɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Bo barɔk ambɨ bɛ́fú ndǔ bɛtɔk nɛ bɛtɔk mántwɔ nɔkɔ ntá Yesu. Ngɛ́mtay bho báchɛ́mɛ́ nɛbhʉɛt amɔt. Yesu atɛ́m bhɔ nɛkay ɛnɛn bɛ́: ");
INSERT INTO kenNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ɛwak ɛ́mɔt, nkwaŋankɨ amɔt arɔ̌ŋ nyaka bɛtak ɛnyǔ nchwifú amɛm nkɨ ywi. Ɛnɛ́ yi átàk árɔ̀ŋ, mbɔk akwɛnti ndǔ mɔ́mbi anɛ áchí amɛm nkɨ. Bo báyáti. Kɛnɛn kɛ́twɔ́ kɛ́bwɔ́pti nchwi yɔ nkɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Achák akwɛnti ndǔ mmɨk sɛtárɛ́bhɛ́ nɛ mpok ácháká, anɨŋti, awɔsi, mbɔnyunɛ nɛbhʉɛ́rɛ́mɨk wu apu kɛm manyiɛp. ");
INSERT INTO kenNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mbuɔt anɛfu akwɛnti ndǔ mmɨk anɛ tákɔ nsěnse ágò arɛ́. Achak are gó, kɛ tákɔ nsěnse agó áchók yɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kɛ nchwi áchák akwɛnti ndǔ mmɨk ndɨ́ndɨ́, agó achyɛ bɛyǎ nchwi. Ayá acha anɛ bápɨ́ ndɔŋ bɛsa bɛtay.” Ndǔ ngwɛnti, Yesu arɛm bɛ, “Mmǔ anɛ áyàŋ bɛghok, ántá batú angok sayri.” ");
INSERT INTO kenNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Baghɔk Yesu bábhɛ́p yi ntí nɛkay ɛnɛn. ");
INSERT INTO kenNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Akɛmɛ bhɔ́ bɛ́ “Mandɛm achyɛ́ mbi bɛ mǎndɨ́ŋɨ́ mɛnyɨŋ ɛbhɛ́n bɛchi bhɛ́sɛ́ bhɛ́sɛ́ ɛ̌ti ɛnyǔ yi ákɛ̀m bǒbhi mbɔ Mfɔ wap. Kɛ mbák chi bo bachak, nchí rɛm kɛpɨ nɛ bhɔ́ chi ndǔ bakay bɛ yɛ̌ndu báyɨ̀ŋɨ bákɛ́ ghɔ, nɛ yɛ̌ndu bághòk bákɛ́ jwimɛm.” ");
INSERT INTO kenNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yesu arɔk ambɨ árɛ́m bɛ nɛkǎy ɛnɛn nɛ́tɔ̀ŋ bɛ, “Mbuɔt chi Ɛyɔŋ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mbuɔt anɛ ákwɛ́ntí ndǔ mɔ́mbi chi bo abhɛn bághókó Ɛyɔŋ Mandɛm. Kɛ Satan antwɔ́ amfɛrɛ yɔ́ ndǔ batɨ yap bɛ bákɛ́ noko Mandɛm yi ampɛmɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mbuɔt anɛ ákwɛ́ntí ndǔ mmɨk sɛtárɛ́bhɛ́ até ndǔ bo abhɛn bághòk Ɛyɔŋ Mandɛm, mánoko tɛ́mté nɛ bɛyǎ maŋák. Kɛ bɔ kɛbhɔ́ŋ bakaŋ amɨk. Mánoko chi ndu mɔ́mbɨŋɨ́ mpok. Nɛmɔ nɛtwɔ nɔkɔ, mánkwɛn ansɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nɛ mbwɔt anɛ ákwɛ́ntí ndǔ mmɨk tákɔ nsěnse, até ndǔ mmu anɛ ághòk Ɛyɔŋ Mandɛm, kɛ bakáysí ɛ̌ti mɛnyɨŋ mmɨk, nɛ bakáp, nɛ nɛpɛ́m mɛ́nyiɛ, akʉ bɔ́ kɛsɛnɛ ndǔ Ɛyɔŋ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mbɔ ɛnyu ɛfakari nɛ mbwɔ́t anɛ ákwɛ́ntí ndǔ mmɨk ndɨ́ndɨ́, nɔ kɛ ɛchi nɛ bo abhɛn bághòk Ɛyɔŋ Mandɛm mánkɛ́m nɛ ntɨ nɛ́mɔ́t mankʉ nɔkɔ mbɔ ɛnyu ɛ́yàŋ, mándɔk nɔkɔ ámbɨ bɛkʉ ɛnyu ɛyɔ nɛ ɛkɛ́bhɛ́ntɨ́.” ");
INSERT INTO kenNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Yɛ̌ mmu apú durɛ ɛrɔ́ŋɔ́ ansɔt ɛnyɨŋ ankuti, mbák ɛ́pú nɔ ante antɛn bɛkɔk. Ǎte yɔ chí nɛbhʉɛt anɛ babhɔŋɔ bɛte yɔ bɛ mbaŋ angɔ́ɔ́ ntá yɛ̌ntɨkɨ mmu anɛ achwe anywɔ́p. ");
INSERT INTO kenNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Dɨŋɨ́ ká bɛ, chɔŋ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ ɛchi bhɛ́sɛ́ bhɛ́sɛ́, ɛ́mfú kpoŋoroŋ, nɛ ɛnɛ́ bábhɛ́sɛ́ ɛ́mfú kpoŋoroŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Sɔt ka mpok bɛghok Ɛyɔŋ Mandɛm sayri ɛnyu ɛnɛ bǎjwimɛm mbɔnyunɛ mmǔ anɛ ábhɔ́ŋɔ́ ɛnyɨŋ, chɔŋ mámaka yi ɛ́chák, kɛ mmǔ anɛ ábhɨ́kɨ́ bhɔŋ yɛ̌nyɨŋ, yɛ̌ chí mandú anɛ yi ákáysí bɛ́ abhɔŋ, chɔŋ mánsɔt yɔ ntá yi.” ");
INSERT INTO kenNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nnɔ Yesu nɛ bɔ̌mayi bárɔk bɛghɔ yi. Kɛ bɔ́ kɛ kwáy bɛrɔŋ kɛkwɔt nɛ yi mbɔnyunɛ bo bayǎ nyaka bacha. ");
INSERT INTO kenNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mǔfu aghati yi bɛ, “Máyɛ nɛ bɔ̌mayɛ báchí nɛfí téé báyàŋ bɛghɔ wɔ.” ");
INSERT INTO kenNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesu akɛmɛ bɛ, “Máya nɛ bɔ̌maya chi bo abhɛn bághòk Ɛyɔŋ Mandɛm nɛ mánkʉ mbɔ ɛnyu yɔ ɛ́rɛ̀m.” ");
INSERT INTO kenNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nywɔp nɛmɔt Yesu arɛm ntá baghɔkɔ́ bhi bɛ, “Sɛ́mpé sɛ́ndɔ́k ɛbhě manyu ɛ́nɛ awu.” Báchwe amɛm áchwí nɛ yi bábhó mɛnok mandɔkɔ nɔkɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ndu mánòk bárɔ̀ŋ, Yesu akwɛ́n kɛnɔ́. Mbʉ́ɛ́p ataŋataŋ abho mɛnu. Nnyɛ́n nɛ́bho bɛdɛp áchwí, manyiɛp anchwe nɔkɔ amɛm. Ɛ́rɔp chi mandú bɛ mámbɛt anyɛ́n. ");
INSERT INTO kenNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Baghɔkɔ bhi barɔk máŋɛ́mɛ́ yi barɛm bɛ, “Ɛta! Ɛta! Sɛ́twɔ gu anyɛ́n!” Yesu aŋɛmɛ asáy mbʉ́ɛ́p nɛ mpɛ́rɛ́nyɛn. Mbʉ́ɛ́p ágú, nɛ nnyɛ́n nɛ́kwɛ́n tɨɨ. ");
INSERT INTO kenNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Abhɛ́p bhɔ bɛ, “Nɛka ɛnɛka nɛ mɛ nɛ́chí fá?” Bɛcháy bɛkɛm bɔ nɛ bábhak maknkay, bábho bɛbhɛp batɨ bɛ, “Ntɨkɨ ɛnyǔ mmu nɛ? Ǎsay yɛ̌ chi mbʉ́ɛ́p nɛ mpɛ́rɛ́nyɛn, nɛ yɔ ɛ́nkʉ mbɔ ɛnyǔ yi arɛmɛ!” ");
INSERT INTO kenNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu nɛ baghɔkɔ́ bhi mánók yɛ, bápe nnyɛ́n, báchwɔ́p ɛtɔk Gɛrása. Gɛrása abhak ɛbhěnyɛn ɛnɛ ɛ́yɨ̀ŋɨ Gálili. ");
INSERT INTO kenNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nɛfú Yesu áfú amɛm áchwí, mǔfu afú ɛtɔk Gɛrása ɛyɔ akwɛsɛ yi. Bɛfóŋó bɛbʉ́bɛbʉ bɛ́sɔ̀ŋɔri nyaka yi. Ndǔ ɛrɔri mpok, mmǔ wu ǎkɔ̀ nyaka chi ɛbhowɔ, yi kɛ chɔkɔ anywɔ́p. Ǎchɔkɔ nyaka ndǔ nɛbhʉ́ɛ́rɛ́ manɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ághɔ́ nɔ́kɔ́ Yesu, abɨk, arɔk akwɛ́n yi bɛkak, arɛm nɛ, ɛyɔŋ ɛtaŋataŋ bɛ, “Yesu Mmɔ Mandɛm Acha! Ɔ́bhɔ̌ŋ ntɨkɨ ndak nɛ mɛ? Nɨkmʉɛt ɔ́kɛ́ chyɛ mɛ ɛsɔŋɔri!” ");
INSERT INTO kenNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Arɛm ɛnyu ɛyɔ mbɔnyunɛ Yesu asay nyaka ɛfóŋó ɛbʉ́bʉ ɛnɛ ɛ́sɔ̀ŋɔri yi bɛ ɛ́ndɔ́ yi. Bɛyǎ mpok, ɛfóŋó yɔ ɛ́fate nyaka yi amʉɛt, nɛ yɛ̌ bákɛm yi báfyɛ ngɛm amɔ nɛ bɛkak, mámbabhɛri nɔkɔ yi, ǎkɨti ngɛm ɛyɔ, ɛfóŋó ɛyɔ ɛ́nkʉ yi ambʉ́ɛ́ anchwe amɛm baso. ");
INSERT INTO kenNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu ásáy nɔ́kɔ́ ɛfóŋó ɛbʉbʉ yɔ, abhɛp mmu wu bɛ, “Nnyɛ́n ɛnɛ bɛ yi?” Akɛmɛ bɛ, “Nnyɛ́n ɛna chi ngɛ́mtáy”; mbɔnyunɛ bɛfóŋó bɛbʉ́bɛbʉ bɛyǎ nyaka yi amʉɛt tontó. ");
INSERT INTO kenNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Bɛfóŋó bɛbʉ́bɛbʉ bhɔ bɛré nɨk Yesu mmʉɛt bɛ́ ákɛ́ tó bhɔ amɛm nɛpi ɛnɛn nɛbhɨkɨ bhɔŋ ngwɛnti. ");
INSERT INTO kenNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ɛrɛmɛ́ nkwɔ́ bakók ányìɛ nyaka ambɨ njiɛ anɛ achi kɛkwɔt. Bɛfóŋó bhɔ mɛ́nɨkmʉɛt ntá Yesu bɛ́ ándɔ́ bɔ́ mándɔ́k mǎnchwe amʉɛt bakok bhɔ. Yesu achyɛ bhɔ mbi. ");
INSERT INTO kenNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Bɛfóŋó bɛbʉ́bɛbʉ bhɔ bɛ́fú amʉɛt mmu wu bɛrɔk bɛchwe amʉɛt nkwɔ́ bakók. Bakók mankɛm bárókóri básɛp ndǔ nkokonjiɛ dúgúdúgúdúgú bágúrɛ anyɛ́n. ");
INSERT INTO kenNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bo abhɛn bábhàbhɛri bakók, bághɔ́ nɔ́kɔ́ ɛnyɨŋ ɛnɛ ɛfakari, bárɔk ɛtɔk ɛgho nɛ mbaŋ ɛnɛ ɛchi kɛkwɔt ntiɛ́t ntiɛt bágháti bho. ");
INSERT INTO kenNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Bo bárɔ́k yɛ bɛghɔ ɛnyɨŋ ɛnɛ ɛfakari. Bágháká nɔ́kɔ́ ntá Yesu, bághɔ́ mmu anɛ bɛfóŋó bɛbʉ́bɛbʉ bɛ́fú yi amʉɛt. Abhak sayri ndǔ nkaysi yi. Bɛcháy bɛ́kɛm bɔ́ mankɛm tontó. ");
INSERT INTO kenNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bǒ abhɛn bághɔ́ ɛnyɨŋ ɛnɛ́ ɛ́fákári, báré ghati abhɛn batwɔ ɛnyɨŋ ɛnɛ ɛ́fákárí kɛ bɛfóŋó bɛbʉ́bɛbʉ bɛ́rɔ́ mmu anɛ bɔ bɛ́sɔ̀ŋɔri nyaka, yi ataŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Bɛcháy bɛ́kɛ́m bǒ atú Gɛrása wu mankɛm. Bágháti Yesu bɛ́ amfu ɛtɔk ɛyap ándɔ́k. Arɔk achwe amɛm áchwí ndu bɛrɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mmǔ anɛ bɛfóŋó bɛbʉ́bɛbʉ bɛ́fú yi amʉɛt are nɨk Yesu mmʉɛt bɛ ándɔ́ yi ankoŋo yi. Kɛ ndu Yesu aghati yi ampɛtnsɛm, arɛm ntá yi bɛ, ");
INSERT INTO kenNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Pɛtnsɛm anywɔ́p ghati bo ɛnyɨŋɨ́ maknkay ɛnɛ Mandɛm ákʉ́ ntá yɛ.” Arɔk yɛ ndǔ ɛtɔk ɛyɔ ɛnkɛm angati nɔkɔ bo ɛnyɨŋ ɛnɛ Yesu akʉ ntá yi. ");
INSERT INTO kenNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu apɛt nɔkɔ nsɛm ɛbhě manyu ɛchak, bǒ abhɛn mánòŋ yi, basyɛpti yi. ");
INSERT INTO kenNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mǔfu anɛ áká nnyɛ́n bɛ Jáyrɔs arɔk ntá Yesu. Achí nyaka mǔnti ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí bo Israɛl ndǔ nɛbhʉɛt anɛ yi achí arɛ. Akwɛ́n Yesu bɛkak anɨkmʉɛt bɛ Yesu andɔk ɛkɛt ɛyi. ");
INSERT INTO kenNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Mɔ́ywi arɔp nyaka kɛkwɔt bɛgu. Nɛ ndiɛrɛ mɔ́wu kɛ yi ábhɔ́ŋɔ́ nyaka. Abhak mɔ́ngɔsɔ́ŋ anɛ achí mamiɛ́ byo nɛ apay. Ndu Yesu árɔ̀ŋ arɛ́ bɛyǎ bo bákáp yi bɛbhe bɛpay. ");
INSERT INTO kenNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ngɔrɛ́ amɔt abhak arɛ́, anɛ áfɛ̀rɛ manoŋ ndǔ mamiɛ́ byo nɛ apay. Anáŋ achɔ́ŋtí nyaka nkáp anɛ́ yí ábhɔ́ŋɔ́ ankɛm kɛ yɛ̌ mmu kɛkwáy bɛbu yi. ");
INSERT INTO kenNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Afú Yesu ansɛm, atɔti amɛm bɛyǎ bhó kpát arɔk atɔk nkokoŋ nkú yi. Tɛ́mté wu, manǒŋ mɔ asiɛ́p. ");
INSERT INTO kenNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu abhɛ́p bɛ, “Agha átɔ́kɔ́ mɛ́?” Bǒ mankɛm bataŋa. Píta arɛm yɛ bɛ, “Ɛ̌tá, bɛyǎ bo bákàp wɔ nɛ mányìɛrɛ wɔ!” ");
INSERT INTO kenNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yɛ̌ nɔ, Yesu arɛm bɛ, “Mmu atɔk mɛ. Ndɨ́ŋɨ́ nɔ mbɔnyunɛ ngók ndǔ bɛtaŋ bɛ́fú mɛ amʉɛt.” ");
INSERT INTO kenNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mɔ́ngɔrɛ́ wu ághɔ́ nɔ́kɔ́ bɛ́ Yesu arɨŋɨ ɛnyɨŋ ɛnɛ ɛfakari, arɔk angwɛrɛ nɔkɔ gbagbǎgbak, ákwɛ́n bɛkak Yesu arɛm bɛsí bo mankɛm ntí anɛ yi átɔ́kɔ́ Yesu nɛ ɛnyǔ yi átáŋ tɛ́mté. ");
INSERT INTO kenNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu arɛm ntá yi bɛ, “Mmá, nɛka ɛnɛ nɛ mɛ nɛ́kʉ ɔtaŋ. Mandɛm achi nɛ wɔ, dɔ́k sayri.” ");
INSERT INTO kenNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ɛnɛ́ Yesu ábhʉɛ́t bɛ́rɛm kɛpɨ nɛ ngɔrɛ́ wu, mǔnto achwɔp anɛ áfú ɛkɛt ɛnɛ Jáyrɔs mǔnti arɛm ntá yí bɛ, “Mɔ́ywɛ agu. Ɔ́kɛ́pɛrɛ sɔŋɔri Ntɔŋ.” ");
INSERT INTO kenNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Kɛ Yesu aghoko nɔkɔ nɔ arɛm ntá Jairɔs bɛ, “Ɔ́kɛ́ cháy. Dɔ́kɔ́ rɔŋ ambɨ mɛnóko, chɔŋ mɔ́ywɛ antaŋ.” ");
INSERT INTO kenNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesu aghaka nɔkɔ ɛkɛt Jairɔs, yi kɛka yɛ̌ mmu ánchwe anywɔ́p nɛ yi, ɛ́bhɨ́kɨ́ fʉɛt Píta, nɛ Jɔ̌n, nɛ Jems nɛ chimɔ nɛ máyi. ");
INSERT INTO kenNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Bǒ mankɛm abhɛn bachi arɛ́ bare di mɔ́wu mámbyaka nɔkɔ amɔ antɨ. Kɛ Yesu arɛm bɛ, “Bɔ́t ká kɛbhɔ. Mɔ́nɛ abhɨkɨ gú. Ǎbhʉ̀rɛ chí kɛnɔ́!” ");
INSERT INTO kenNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Bɔ́ mankɛm báré way Yesu way ndu bárɨ́ŋɨ́ bɛ́ mɔ̌rɛ́ agǔ tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kɛ Yesu arɔk kɛ́kwɔ́t nɛ mɔ́wu, akɛ́m awɔ ywi, abhɨŋɨ yi bɛ, “Mɔ́wa, faté.” ");
INSERT INTO kenNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ɛfóŋó yi ɛ́pɛ́tnsɛm, afate tɛ́mté. Yesu achyɛ ɛyɔŋ bɛ manchyɛ yi nɛnyíɛ́ ányiɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ɛtayi nɛ máyi bábhák maknkay tontó. Kɛ Yesu asɛmti bhɔ bɛ bákɛ́ ghati yɛ̌ mmu ɛnyɨŋ ɛnɛ ɛ́fákárí. ");
INSERT INTO kenNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Nywɔp nɛ́mɔ́t, Yesu abhɨŋɨ baghɔkɔ́ bhi bati byo nɛ apay, achyɛ bhɔ bɛtaŋ ndu bɛ́bók mɛnyǔ bɛfóŋó bɛbʉ́bɛbʉ mɛnkɛm nɛ ndu bɛ́bu mame. ");
INSERT INTO kenNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kɛ ǎtó bhɔ nɛfí bɛ́ mándɔ́k mángátí bho ɛnyu Mandɛm abhak nɛ bo mbɔ Mfɔ wap nɛ bɛ mámbú bǒ mame. ");
INSERT INTO kenNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Apɛt arɛm ntá yap bɛ, “Bǎkɛ́ pɔkɔ́ yɛ̌nyɨŋ ndǔ nɛkɔ ɛnɔ, yɛ̌ ntɛm, yɛ̌ ɛbha, yɛ̌ brɛt, yɛ̌ nkáp, nɛ yɛ̌ chí ndɛn ɛ́chák. ");
INSERT INTO kenNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Yɛ̌ntɨkɨ ɛtɔk ɛnɛ́ basyɛpti bhe arɛ́, bák ká amɛm ɛkɛt ɛ́mɔt kpátɛ mǎndɔ ɛtɔk ɛyɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nɛ yɛ̌ntɨkɨ ɛbhak ɛnɛ́ bǎchuɔ́bhɛ́ kɛ bo kɛ syɛpti bhe, dɔ̌ ká ɛtɔk ɛyɔ nɛ bǎpɛrɛ́ fá arɛ́, kwɛt ka mfok anɛ áchí be bɛkak. Chɔŋ ɛyɔ ɛ́mbak mbɔ ntísiɛ ndǔ ɛnyɨŋ ɛnɛ́ bɔ́ bákʉ́.” ");
INSERT INTO kenNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Báfá báre kɔ bɛtɔk nɛ bɛtɔk mángati nɔkɔ bho Mbok Ndɨ́ndɨ́ nɛ mámbu nɔkɔ bǒmame yɛ̌ntɨkɨ ɛbhak. ");
INSERT INTO kenNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Hɛ́rɔd, gɔ́bhanɔ Gálili, aghók yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ ɛ́fakari. Ntí átáka yi amɛm mbɔnyunɛ mbɔk bo bárɛ̀m nyaka bɛ, “Yesu chí Jɔ̌n Njwiti kɛ ápɛ́rɛ́nsɛm ndǔ nɛpɛ́m.” ");
INSERT INTO kenNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Báchák bɛ, “Ɛláija kɛ ábhésí.” Nɛ abhɛ́nɛ́fú bɛ, “Ndɛmɛkɛpɨ̌ntɨ amɔt anɛ tɛ nyaka kɛ ápɛ́rɛ́nsɛm ndǔ nɛpɛ́m.” ");
INSERT INTO kenNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hɛ́rɔd arɛm nɛ mmʉɛt yi bɛ, “Nchyɛ́ nyaka ɛyɔŋ nɛ bákpɔ́t ntí Jɔ̌n. Kɛ mmǔ anɛ mɛ̌ghòk nɛ mɛnyɨŋɨ́ maknkay ɛbhɛn ɛ̌ti yi chí agha?” Are yáŋ mbi bɛghɔ Yesu. ");
INSERT INTO kenNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Bǒnto Yesu bápɛ́rɛ́ nɔ́kɔ́ nsɛm, bágháti Yesu mɛnyɨŋ ɛbhɛn bɔ́ bákʉ́. Asɔt yɛ bhɔ ansɛm, bárɔ́k ɛtɔk ɛnɛ bábhɨ̀ŋɨ bɛ Bɛtsáida. ");
INSERT INTO kenNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Yɛ̌ nɔ, bɛyǎ bo bághók, bábho bɛkoŋo yi. Asɔt bhɔ sayri, abho bɛghati bhɔ ɛnyu Mandɛm abhak nɛ bho mbɔ Mfɔ wap ámbu nɔkɔ abhɛn báyàŋ yi ambu bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mmok ábhó nɔ́kɔ́ mɛ́nɛ́m, baghɔkɔ́ bhi bárɔ́k ntá yi barɛm bɛ, “Ghatí bǒbhɛn bɛ mándɔ́k ndǔ bɛtɔk ɛbhɛn bɛchi fá kɛkwɔt nɛ ndǔ bakɨ mánjáŋ nɛnyíɛ́ nɛ bɛbhak bɛbhʉrɛ. Ɛtɔk ɛ́pú fá!” ");
INSERT INTO kenNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kɛ Yesu aghati bɔ bɛ, “Bě babhɔŋ, chyɛ̌ ká bhɔ nɛnyíɛ́ mányíɛ́.” Bákɛ́mɛ yi bɛ, “Sɛ́bhɔŋ chi bɔ̌bɛkpɔkɔ́ brɛt batay nɛ nsi ɛpay. Ɛnyɨŋ ɛchak ɛpu. Ɔ̌yáŋ sɛ́ndɔ́k sɛ́nku nɛnyíɛ́ ntá ngɛ́mtáy bǒbhɛn mankɛm kɛ?” ");
INSERT INTO kenNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Mpǎy babhakanɛm abhɛn bachi arɛ abhak mbɔ nká ɛtay. Yesu aghati baghɔkɔ́ bhi bɛ, “Kʉ ka bo mánchɔ́kɔ́ amɨk ndǔ bakwɔ́, yɛ̌ntɨkɨ nkwɔ́ ámbɔ́ŋ bǒbati bɛsa bɛpay nsɛm byo.” ");
INSERT INTO kenNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Baghɔkɔ́ bhi bákʉ mbɔ ɛnyǔ yi árɛ́mɛ́, bǒ mankɛm báchɔ́kɔ amɨk. ");
INSERT INTO kenNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Asɔt bɛkpɔkɔ́ brɛt bhɔ bɛ́táy nɛ nsi ɛpay. Ayoŋ amɨ́k mfay. Achyɛ bakak ntá Mandɛm, abho bɛ́bɔ́kɔ́ti brɛt wu anchyɛ nɔkɔ ntá baghɔkɔ́ bhi bɛ mánkɔ́rɛ́ nɛ nsi ntá bɛyǎ bǒbhɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Yɛ̌ntɨkɨ mmu wap anyiɛ́ kpát ajwi. Baghɔk Yesu mányókóti nɛnyíɛ́ ɛnɛn nɛrɔbhɛ. Nɛ́jwí bɛkay byo nɛ bɛpay. ");
INSERT INTO kenNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nywɔp nɛmɔt, ɛ́fákari bɛ Yesu ǎnɨ̀kmʉɛt aywǐnti nɛ baghɔkɔ́ bhi babhak kɛkwɔt nɛ yi. Ánáŋá nɔ́kɔ́ mɛnɨkmʉɛt abhɛ́p bhɔ bɛ, “Bo bárɛ̀m bɛ́ nchí agha?” ");
INSERT INTO kenNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bɔ́ bákɛ́mɛ yi bɛ, “Mbɔk bárɛ̀m bɛ ɔchí Jɔ̌n Njwiti. Bachak bɛ Ɛláija, nɛ abhɛnɛfu bɛ ɔchí ndɛmɛkɛpɨ̌ntɨ amɔt anɛ tɛ̌ nyaka kɛ ɔpɛtnsɛm ndǔ nɛpɛ́m.” ");
INSERT INTO kenNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Arɛm nta yap bɛ, “Kɛ bě babhɔŋ bǎrɛ̀m bɛ mɛnchí agha?” Símun Píta akɛmɛ yi bɛ, “Wɔ kɛ ɔ́chí Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò.” ");
INSERT INTO kenNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesu asɛmti bhɔ bɛ́ bákɛ́ ghati yɛ̌ mmu bɛ yi achi Mpɛmɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nɛ arɛm bɛ, “Mɛ Mmu mfú ntá Mandɛm mbɔ̌ŋ bɛghɔ bɛyǎ ɛsɔŋɔri. Bǒ-batí ɛtɔk, nɛ bǒbati bachiǎkap Mandɛm, nɛ batɔŋ ɛbhé Mandɛm bábyak chɔŋ mɛ nɛ mángwáy mɛ, kɛ ɛ́ghaka nɔkɔ manywɔp arat, mpɛtnsɛm ndǔ nɛpɛ́m.” ");
INSERT INTO kenNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yesu aghati yɛ bho mankɛm bɛ, “Mbák mmú ǎyàŋ bɛbhak nkoŋo wa, abhɔŋ bɛ́ghɔ́kɔntɨk mmʉɛt yi, ampɔkɔ ɛkotákátí yi yɛ̌ntɨkɨ nywɔp, ankoŋo mɛ, ");
INSERT INTO kenNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","mbɔnyunɛ mmǔ anɛ áyàŋ bɛpɛmɛ mmʉɛt yi ǎnɛ́m nɛpɛ́m ɛni. Kɛ yɛ̌ agha anɛ áká mɛnɛm nɛpɛ́m ɛni ɛ̌ti ya, ǎbhɔŋ chɔŋ nɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ntɨkɨ nsáy mmu ábhɔ́ŋ mbák abhɔŋ mmɨk nkɛm kɛ anɛ́m nɛpɛ́m ɛni? Yɛ̌nyɨŋ ɛ́pú. ");
INSERT INTO kenNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mbák mmu abhɔ̌ŋ ntíánwɔ́p ɛ̌ti ya nɛ ɛ̌ti ɛyɔŋ ɛya, chɔŋ Mɛ Mmu mfú ntá Mandɛm mbɔ̌ŋ ntíánwɔ́p bɛ́sɔ́t yi mbɔ mmǔ wa mpok anɛ mɛ̌twɔ̀ nɛ kɛnɛ́m ɛka ɛkɛn kɛchi kɛnɛ́m Ɛta nɛ ɛkɛn bɔángɛl abhi. ");
INSERT INTO kenNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nchí ghati bhe bɛ, mbɔk bho báchi fá abhɛn bápú gu kpátɛ mángɔ ndǔ Mandɛm abhak nɛ bhɔ mbɔ Mfɔ wap.” ");
INSERT INTO kenNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesu ánáŋá nɔ́kɔ́ bɛrɛm mɛnyɨŋ ɛbhɛn, bɛrɔŋ mbɔ manywɔp ánɛn, asɔt Píta, nɛ Jɔ̌n, nɛ Jems akó amfǎy njiɛ nɛ bhɔ ndu mɛnɨkmʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ndu ánɨ̀kmʉɛt, bɛsí bhi bɛ́bhó bɛyibhiri. Ndɛn ɛ́yi nkwɔ ɛ́yíbhíri ɛ́nkɔt nɔkɔ ŋwaŋwǎŋwaŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tɛ́mchok bǒ bati apay bábhési bare rɛm kɛpɨ nɛ Yesu. Babhak Moses nɛ Ɛláija. ");
INSERT INTO kenNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Báre ghɔ nɛ bɛdiɛ́rɛ́ Mandɛm nɛ mándɛm nɔkɔ kɛpɨ nɛ Yesu ɛ̌ti nɛrɔŋ anɛ yi ábhɔ́ŋɔ́ bɛrɔŋ Yerúsalɛm angu arɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Píta nɛ mamʉɛrɛ bhi bati apay bákwɛ́n kɛnɔ́, kɛ máŋɛ́mɛ́ nɔ́kɔ́ bághɔ́ bɛdiɛ́rɛ́ Yesu nɛ bǒ bati apay abhɛn bachi nyaka téé nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mpok bɔ́ bárɔ̀ Yesu, Píta arɛm ntá yi bɛ, “Ɛta, ɛ́rɨ tontó bɛ sɛchi fá! Dɔ̌ sɛ́nté bɛtɛm bɛrat, Ɛmɔt ntá yɛ, ɛchak ntá Moses, nɛ ɛnɛ́fú ntá Ɛláija.” Píta kɛrɨŋɨ mbɔ̌ŋ ɛnyɨŋ ɛnɛ yi arɛmɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ɛnɛ́ Píta árɛ̀m ɛnyu yɔ, nɛbháŋ nɛ́sɛp nɛkuti bhɔ. Bɛcháy bɛ́kɛ́m baghɔk Yesu bhɔ ndǔ nɛbháŋ nɛ́kùti bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ɛyɔŋ ɛ́fú ndǔ nɛbháŋ ɛ́ndɛmɛ nɔkɔ bɛ, “Nɛ́ chí Mɔ́wa anɛ njábhɛ́. Ghók ká yi!” ");
INSERT INTO kenNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ɛyɔŋ ɛyɔ ɛ́rɛ́mɛ́ nɔ́kɔ́ ɛnyu yɔ, baghɔk Yesu baghɔ bɛ yi arɔp chi aywǐnti. Báchók manyu kɛ ghati yɛ̌ mmu ndǔ manywɔp yɔ mɛnyɨŋɨ́ maknkay ɛbhɛn bɔ baghɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nɛyí nɔ́kɔ́ mpok Yesu nɛ bɔ Píta básɛ́bhɛ́ njiɛ, bɛyǎ bho bárɔk batɛmɛri Yesu. ");
INSERT INTO kenNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mmǔ amɔt ndǔ nkwɔ bo bhɔ abho bɛbɨk andɛmɛ nɔkɔ bɛ, “Ntɔŋ, nnɨkmʉɛt, bú mɔ́wa. Achí mbakanɛm nɛ ndiɛrɛ yí kɛ mbɔ́ŋɔ́! ");
INSERT INTO kenNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ɛfóŋó ɛbʉ́bʉ ɛsɔŋɔri yi. Ɛ́kʉ ǎchɔkɔ ambo bɛbɨk, ɛ́ngʉɛp yi amɨk, ɛ́nkʉ yi ande wɛt ɛ́fɛ́n ɛ́mfu nɔkɔ yí anyu. Nɛ ɛ́taŋ kɛ ɛ́ndɔ yi. Ɛ́dɛ̀n yi, ɛ́mfyɛ yi mɛnɨ amʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nnɨkmʉɛt ntá baghɔkɔ́ bhɛ bɛ́ mámbók yɔ́ kɛ bábhɨ́kɨ́ kway bɛkʉ nɔ.” ");
INSERT INTO kenNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu arɛm bɛ, “Bě mkpáká bho anɛ abhɨkɨ bhɔŋ nɛka nɛ mɛ, bě bhó bǎyìbhiri tɛtɛp ndǔ ɛnyɨŋ ɛchak, chɔŋ mpɛt ntat nɛ bhe ná? Chɔŋ nkɛ́pntɨ nɛ bhe ngaka fá?” Kɛ arɛm ntá chimɔ bɛ, “Twɔ́ nɛ mɔ́ywɛ fá.” ");
INSERT INTO kenNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mpok mɔ́wu árɔ̀ŋ ntá Yesu, ɛfóŋó yɔ ɛpɛt ɛ́gʉɛp yí amɨk, ɛkʉ yi are wɛt. Kɛ Yesu ásáy ɛfóŋó ɛbʉ́bʉ yɔ, bɛ ɛ́ndɔ́ mɔ́wu. Yesu abú yi, akɛmɛ ntá ɛtayi. ");
INSERT INTO kenNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bo mankɛm bábhák maknkay bɛghɔ bɛtaŋ Mandɛm. Bo barɔk ambɨ bɛbhak maknkay ɛ̌ti yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ Yesu ákʉ́. Yesu arɛm ntá baghɔkɔ́ bhi bɛ, ");
INSERT INTO kenNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Nɛnɛ́ ká batú sayri mǎngok ɛnyɨŋ ɛnɛ nchí ghati bhe. Chɔŋ mánti Mmu anɛ áfú ntá Mandɛm, mámfyɛ yi amɔ bǒ mmɨk.” ");
INSERT INTO kenNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kɛ bɔ́ kɛjwimɛm ndǔ ɛnyɨŋ ɛnɛ yi árɛ́mɛ́. Mandɛm abhɛsɛ ntí bɛyɔŋ bhɔ ntá yap bɛ bákɛ́ rɨŋɨ ndak anɛ áchí amɛm. Nɛ báre cháy bɛbhɛp Yesu mbɔ̌ŋ ɛnyɨŋ ɛnɛ yi árɛ́mɛ́. ");
INSERT INTO kenNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Baghɔkɔ́ bhi bábhó bɛkɛm ɛpʉ́ítí nɛ batɨ ndu bɛrɨŋɨ mmu wap anɛ áchá bachak. ");
INSERT INTO kenNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu arɨŋɨ ɛnyɨŋ ɛnɛ bɔ bakaysi. Ɛ́kʉ asɔt mandú mmɔ́, ate nɛpakámʉɛt ɛni. ");
INSERT INTO kenNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Arɛm yɛ ntá yap bɛ, “Yɛ̌ agha anɛ ásyɛpti mandú mmɔ́ mbɔ anɛ nɛ maŋák ndǔ nyɛ́n ɛnɛ, ǎsyɛpti mɛ́; nɛ yɛ̌ agha anɛ ásyɛpti mɛ nɛ maŋák ǎsyɛpti mmu anɛ átó mɛ. Dɨŋɨ́ ká bɛ mmu ywɛká anɛ ásɛ̀pti mmʉɛt ntá abhɛnɛfu, kɛ áchí mǔngo sayri sayri ntá yɛka mankɛm.” ");
INSERT INTO kenNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jɔ̌n arɛm ntá Yesu bɛ, “Ɛta, sɛ́ghɔ mmu anɛ apu ndǔ nkwɔ ywɛsɛ ndu ábòk bɛfóŋó bɛbʉ́bɛbʉ ndǔ nnyɛ́n ɛna, sɛ́gháti yi bɛ, ákɛ́pɛrɛ kʉ nɔ mbɔnyunɛ apú ndǔ nkwɔ ywɛsɛ.” ");
INSERT INTO kenNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesu akɛmɛ bɛ, “Bǎkɛ́ káŋ mmu mbɔ awú, mbɔnyunɛ yɛ̌agha anɛ ápú mǔmpap ywɛka achí mmǔ ywɛka.” ");
INSERT INTO kenNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Mpok ágháká nɔ́kɔ́ kɛ́kwɔ́t anɛ Mandɛm asɔt Yesu amfay, Yesu akʉ ntɨ ɛni bɛrɔŋ Yerúsalɛm nɛ abho bɛrɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ndu árɔ̀ŋ, ató bapɔkɔ́ ntó ambɨ. Bárɔk bachwe amɛm mɔ́tɔk amɔt atú Samária ndu bɛtoŋti mbaŋ ntá yi. ");
INSERT INTO kenNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kɛ bǒ ɛtɔk yɔ kɛ ka yi anchwe arɛ mbɔnyunɛ baghɔ nyaka bɛ yi atɨ bɛrɔŋ chi Yerúsalɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Baghɔk abhi Jems nɛ Jɔ̌n, bághɔ́ nɔ́kɔ́ nɔ́, bárɛm ntá Yesu bɛ, “Acha, ɔ̌yàŋ sɛ́mbɨ́ŋɨ́ ngó ámfú amfay antwɔ ansɔŋ bǒbhɛn-ɛ?” ");
INSERT INTO kenNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kɛ Yesu ayibhiri mmʉɛt aghati bhɔ bɛ ɛnyɨŋ ɛnɛ bárɛmɛ ɛ́pú chak. ");
INSERT INTO kenNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Yí nɛ baghɔkɔ́ bhi báfʉɛ́t bárɔk ndu mɔ́tɔk achak. ");
INSERT INTO kenNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ndu bárɔ̀ŋ, mmǔfú arɛm ntá Yesu bɛ, “Chɔŋ mbak nkoŋo ywɛ yɛ̌ntɨkɨ ɛbhak ɛnɛ ɔ̌rɔ̀ŋ.” ");
INSERT INTO kenNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu akɛmɛ yi bɛ, “Bɛsɔp bɛbhɔŋ babhok, kɛnɛn kɛ́bhɔ́ŋ manyay, kɛ Mɛ Mmu mfú ntá Mandɛm mbɨ́kɨ́ bhɔŋ ɛbhak bɛsoŋ ntí.” ");
INSERT INTO kenNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Arɛm ntá mmu achak bɛ, “Koŋó mɛ́.” Kɛ mmu wu arɛm bɛ, “Acha, dɔ̌ kpɨ́k ndɔ́k mbɛ́mɛ́ Ɛtaya.” ");
INSERT INTO kenNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu aghati yi bɛ, “Dɔ̌ bawú mámbɛ́mɛ́ ngú wap. Kɛ wɔ, dɔ́k ghati bo Mbok Ndɨ́ndɨ́ ɛ̌ti ɛnyu Mandɛm abhak nɛ bho mbɔ Mfɔ wap.” ");
INSERT INTO kenNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mmǔ achak arɛm bɛ, “Acha, chɔŋ nkoŋo wɔ, kɛ dɔ̌ kpɨ́k ndɔ́k anywɔ́p ndyɛ́p bǒbha.” ");
INSERT INTO kenNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu arɛm ntá yi bɛ, “Yɛ̌ agha anɛ ákɛ́mɛ́ ɛnɔ ákwàŋ mbaŋ nɛ anjɨŋɨ nɔkɔ nsɛm, abhɨ́kɨ́ kway bɛbhak mǔbɛtok anɛ Mandɛm achi Mfɔ ywi.” ");
INSERT INTO kenNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Awu áfʉ́ɛ́rɛ́ nɔ́kɔ́, Acha ayap bakoŋo bhi bachak bɛsa bɛrat nsɛm byo nɛ apay ató ambɨ bati apay apay bɛ mándɔ́k ndǔ yɛ̌ntɨkɨ ɛtɔk nɛ nɛbhʉɛt anɛ yí mbɔ̌ŋ áyàŋ nyaka bɛrɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ápɛ́rɛ to bhɔ, aghati bhɔ bɛ, “Mbuɔt bɛ́fɛ́rɛ ɛbhɨ aya, kɛ bakʉ̌ bɛtɨk bábhɨ́kɨ́ ya. Nɨk yɛka mmʉɛt ntá Mandɛm mmu achi mbɔŋɔ́nkɨ bɛ ántó bakʉ̌ bɛtɨk, mámfɛ́rɛ́ mbwɔt ɛbhɨ. ");
INSERT INTO kenNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Dɔ́k ka! Nchí to be ntá bǒ mmɨk mbɔ bághɔ́ŋɔmɛ́n nɛntɨ nkwɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Bǎkɛ́ pɔkɔ́ yɛ̌ mɔ́bha nkáp, yɛ̌ ɛbhǎ nɛkɔ, nɛ yɛ̌ nkwɔbhánya ɛchak. Nɛ bǎkɛ́ kaka yɛ̌ mmu ambi. ");
INSERT INTO kenNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Yɛ̌ntɨkɨ ɛkɛt ɛnɛ́ bǎchwé arɛ́, mǎnjámbɨ mǎndɛm bɛ, ‘Kpák anɛ Mandɛm áchyɛ̀ ámbák fá amɛm ɛkɛt ɛnɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Mbák mmu achi amɛm ɛkɛt ɛyɔ anɛ ákɔ́ŋɔ́ kpák, chɔŋ Mandɛm ankʉ kpák ambak nɛ yí. Kɛ mbák yɛ̌ mmu apú, áfɔ́k wu ǎpɛtnsɛm ntá yɛka. ");
INSERT INTO kenNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Chwé ká mǎmbak chi arɛ. Bǎkɛ́ kɔ bɛkɛt nɛ bɛkɛt. Nyíɛ́ ká, mǎnyú yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ bachyɛ bhe. Ɛchi chak bɛ nkʉbɛtɨk ambɔŋ akap ndǔ bɛtɨk ɛbhi. ");
INSERT INTO kenNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Yɛ̌ntɨkɨ ɛtɔk ɛnɛ bǎchwe arɛ́ nɛ básiɛ́pti be nɛ maŋák, nyiɛ́ ká yɛ̌ntɨkɨ nɛnyíɛ́ ɛnɛn bachyɛ bhe. ");
INSERT INTO kenNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Bú ká bǒmame abhɛn ɛtɔk ɛyɔ, mǎngati bo abhɛn bachi arɛ bɛ, ‘Mpok anɛ Mandɛm abhak nɛ bho mbɔ Mfɔ wap arɔp chi kɛkwɔt.’ ");
INSERT INTO kenNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kɛ yɛ̌ntɨkɨ mpok anɛ bǎchwe ɛtɔk kɛ bo abhɛn bachi arɛ kɛsyɛpti bhe nɛ maŋák, fú ka dɔk ndǔ nkɔŋɔ-mbi ɛnɛ ɛtɔk yɔ, mǎndɛm bɛ, ");
INSERT INTO kenNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Yɛ̌ chí mfok ɛtɔk ɛyɛka anɛ ábátí ndǔ bɛkak ɛbhɛsɛ sɛ́kwɛ̀t sɛ́fɛ̀rɛ mbɔ ntísiɛ ndǔ ɛnyɨŋ ɛnɛ bǎkʉ́. Kɛ dɨŋɨ́ ka bɛ, mpok anɛ Mandɛm abhak nɛ bo mbɔ Mfɔ wap arɔp chi kɛkwɔt.’” ");
INSERT INTO kenNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yesu arɔk ambɨ arɛm bɛ, “Nchí ghati bhe bɛ, ɛwak ɛnɛ Mandɛm átàŋ bǒ mmɨk, chɔŋ angɔ́ ntínso nɛ bǒ ɛtɔk Sódom ɛncha bǒ ɛtɔk ɛyɔ.” ");
INSERT INTO kenNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Bě bo Korasín, chɔŋ ɛ́mbɛ́p ntá yɛka ɛncha! Bě bo Bɛtsáida, chɔŋ ɛ́mbɛ́p ntá yɛka nkwɔ ɛncha! Mbɔ chi amɛm bɛtɔk Táya nɛ Sídɔn kɛ̌ nkʉ́ mɛnyɨŋɨ́ maknkay ɛbhɛn-nɛ nkʉ ntá yɛka, mbʉ́ báfyɛ́ ndɛn pyɔ, mánto batwɔ́p anti tɛsáy, bɛtɔŋ bɛ bátɨknsɛm ndǔ bɛbʉ́ bhap! ");
INSERT INTO kenNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kɛ ɛwak ɛnɛ Mandɛm átàŋ bǒ mmɨk, chɔŋ angɔ́ ntínso nɛ bǒ-Taya nɛ Sídɔn ɛncha bhe. ");
INSERT INTO kenNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nɛ bě bho Kapɛ̌naum, bǎkaysi bɛ bǎkway bɛyoŋ mmʉɛt, mǎnkó kpát mǎntɔk nɛbu? Nsé! Chɔŋ Mandɛm amɛsɛ bhɛ amɛm ɛtɔkɔ́ bawú!” ");
INSERT INTO kenNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu apɛt arɛm ntá bakoŋo bhi bhɔ abhɛn yi ato bɛ, “Yɛ̌ agha anɛ ághók bé ǎghók chi mɛ. Anɛ ábyak be ǎbyak chi mɛ. Mmu nɛ ábyak mɛ, ǎbyak chi mmu anɛ átó mɛ.” ");
INSERT INTO kenNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Abhɛn bati bɛsa bɛrat nsɛm byo nɛ apay bápɛtnsɛm nɛ maŋák, báré ghati Yesu bɛ, “Acha, ndǔ nnyɛ́n ɛna, yɛ chi bɛfóŋó bɛbʉ́bɛbʉ bɛ́sɛ̀pti mmʉɛt ntá yɛsɛ.” ");
INSERT INTO kenNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu akɛmɛ bhɔ bɛ, “Ngɔ̌ ndu Satan áfú amfay akwɛnɛ amɨk mbɔ miámiaŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ghɔ́ ka! Nchyɛ́ bhe bɛtaŋ bɛ bǎkway bɛyat nnyɔ́ nɛ ngá-nɛghay amɨk. Nchyɛ́ be bɛtaŋ amfay bɛtaŋ Satan, mǔmpap, nɛ yɛ̌nyɨŋ ɛpu chyɛ be ɛsɔŋɔri. ");
INSERT INTO kenNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Yɛ̌ nɔ bǎkɛ́ ŋák chi bɛ, bɛfóŋó bɛbʉ́bɛbʉ bɛ́sɛ́pti mmʉɛt ntá yɛka. Ŋák ka chi bɛ Mandɛm asɨŋ manyɛ́n yɛka amɛm ɛkáti ɛnɛ amfay.” ");
INSERT INTO kenNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mpok yɔ, Yesu anɨkmʉɛt bɛ, “Ɛta, wɔ mmu ɔ́bhɔ́ŋɔ́ mfay nɛ mmɨk! Nchí chyɛ wɔ bakak ndǔ ɔ́rɔ́ mɛnyɨŋ ɛbhɛn mɛ́mbák bhɛ́sɛ́ bhɛ́sɛ́ ntá barɨŋɨ́ndak nɛ ntá bo abhɛn bárɨ́ŋɨ́ bɛyǎ mɛnyɨŋ. Ɔnɛ́nɛ́ bhɔ ɔtɔŋ kpoŋoroŋ ntá bo abhɛn bábhɨ́kɨ́ rɨŋɨ yɛ̌nyɨŋ mbɔ mǎmbɔ. Ɛta, ɛnyu yɔ kɛ̌ wɔmbɔŋ ɔ́yáŋá bɛ ɛmbak.” ");
INSERT INTO kenNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yesu apɛt arɛm bɛ, “Ɛtaya achyɛ́ mɛ mɛnyɨŋ mɛnkɛm. Yɛ̌ mmu abhɨ́kɨ́ rɨŋɨ mmu anɛ Mmɔ áchí ɛ́bhɨ́kɨ́ fʉɛt chí Ɛtayi. Nɛ yɛ̌ mmu abhɨkɨ rɨŋɨ mmu Ɛta áchí ɛ́bhɨ́kɨ́ fʉɛt chí Mɔ́ywi nɛ bǒ abhɛn yi áyábhɛ́ ndu bɛkʉ bɔ mándɨ́ŋɨ́ Ɛtayi.” ");
INSERT INTO kenNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ayibhiri yɛ mmʉɛt arɛm ntá baghɔkɔ́ bhi ansɛm ansɛm bɛ, “Ɛ́rɨ ntá yɛka ɛcha bɛ́ bǎghɔ̀ mɛnyɨŋ ɛbhɛn nɛ bǎghɔ̀! ");
INSERT INTO kenNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nchí ghati bhe bɛ, bɛyǎ barɛmɛ́ kɛpɨ̌ntɨ nɛ bafɔ babhɔ̌ŋ nyaka ɛkwak bɛghɔ mɛnyɨŋ ɛbhɛn bǎghɔ̀, kɛ bɔ kɛghɔ bhɔ. Bábhɔ́ŋ ɛkwak bɛghok mɛnyɨŋ ɛbhɛn bǎghòk, kɛ bábhɨkɨ ghok bhɔ.” ");
INSERT INTO kenNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ɛ́fákari bɛ ntɔŋ ɛbhé Moses arɔk mɛmɔ Yesu. Abhɛ́p yi bɛ, “Ntɔŋ, chɔŋ nkʉ yi kɛ mbɔ̌ŋ nɛpɛ́m ɛnɛn nɛ́bhɨ́kɨ́ bhɔŋ ngwɛnti?” ");
INSERT INTO kenNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu arɛm ntá yi bɛ, “Ɛkáti Mandɛm ɛ́rɛ̀m bɛ yi? Ɔ̌pay arɛ́ bɛ yi?” ");
INSERT INTO kenNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Akɛmɛ bɛ, ɛ́rɛ̀m bɛ, “Kɔŋ Mandɛm Acha ywɛ nɛ ntɨ ɛnɛ nɛnkɛm, nɛ ɛfóŋó yɛ ɛnkɛm, nɛ bɛtaŋ ɛbhɛ mɛnkɛm, nɛ nkaysi yɛ nkɛm, nɛ kɔ́ŋ nkokosi yɛ mbɔ ɛnyu ɔ́kɔ́ŋɔ́ mmʉɛt ɛyɛ.” ");
INSERT INTO kenNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu arɛm ntá yi bɛ, “Chi ɛnyu yɔ. Kʉ nɔ́, nɛ chɔŋ ɔ́mbɔ́ŋ nɛpɛ́m.” ");
INSERT INTO kenNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kɛ ndǔ yi áyàŋ bɛtaŋa mmʉɛt, arɛm bɛ, “Kɛ mbɔ̌ŋ nkokosi wa chi agha?” ");
INSERT INTO kenNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu akɛmɛ yi nɛ nɛkay ɛnɛn bɛ, “Mmǔfu afǔ nyaka ɛtɔk Yerúsalɛm ǎsɛ̀p Jɛríko. Ndu árɔ̀ŋ, akwɛ́n amɔ baghɛ́p bataŋataŋ. Báfɛ́rɛ yɛ̌ntɨkɨ ɛnyɨŋ yí amʉɛt, bádɛ́n yí, bárɔ́k, barɔ yi mpok árɔbhɛ kɛkwɔt bɛgu. ");
INSERT INTO kenNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ɛ́fákari bɛ nchiakap Mandɛm amɔt ǎsɛ̀p ndǔ nkúbhɛ́ mbi wu. Ágháká nɔ́kɔ́ arɛ, aghɔ́ yi, apé ɛbhěmbi, arɔk ɛbhak ɛyi. ");
INSERT INTO kenNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ɛ́fákári ɛnyumɔt nɛ nkú bɛtɨk amɛm ɛkɛrákap Mandɛm amɔt anɛ nnɛrɛ́kɛt *Lɛ́vi. Mpok yi aghaka arɛ, aghɔ́ yi, kɛ afʉɛ́t nkwɔ chi ɛbhe ɛchak, arɔk. ");
INSERT INTO kenNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kɛ mmu Samária fú ǎsɛ̀p nyaka nkwɔ ndǔ mbi wu. Ágháká nɔ́kɔ́ nɛbhʉɛt anɛ mmu wu achi, aghɔ́ yi, nɛ abhɔ́ŋ ntínso nɛ yí. ");
INSERT INTO kenNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Arɔk ntá yi, achɨti babhe ndǔ bɛfʉɛt bhi, agwɔ́t. Apɔkɔ yɛ yi anyaŋa amfǎy mpɔŋɔ batu yi, arɔk nɛ yí ndǔ ɛkɛt ɛnɛ́ mankɔ bachyɛ nkáp kɛ mabʉrɛ arɛ́. Akwak yí. ");
INSERT INTO kenNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nɛyí nɔ́kɔ́ afɛrɛ nkáp achyɛ ntá mmu anɛ ayɨŋɨ ɛkɛt ɛyɔ arɛm bɛ ‘Yɨŋɨ́ mɛ́ yi. Nnáŋ mpɛtnsɛm chɔŋ nkɛmɛ yɛ̌ntɨkɨ ɛnyɨŋ ɛchak ɛnɛ ɔ́chɔŋti yi amʉɛt.’” ");
INSERT INTO kenNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesu arɛm nɔkɔ nɔ, abhɛ́p ntɔŋ ɛbhé Mandɛm bɛ, “Ɔkáysí bɛ ndǔ nkwɔ wu bati arat, agha átɔ́ŋɔ́ bɛ́ achi nkokosi ntá anɛ akwɛnɛ amɔ bághɛ́p?” ");
INSERT INTO kenNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Akɛmɛ bɛ, “Chí anɛ ághɔ́ yi ntínso.” Yesu aghati yɛ yi bɛ, “Dɔ́k yɛ́ kʉ mbɔ yí.” ");
INSERT INTO kenNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ɛnɛ́ Yesu nɛ baghɔkɔ́ bhi bákɔ̀ bárɔ̀ŋ báchwɔ́p ndu mɔ́tɔkɔ́fú. Ngɔrɛ́ amɔt anɛ áká nnyɛ́n bɛ Matá abhak arɛ. Asyɛpti Yesu amɔ ápay amɛm ɛkɛt ɛyi. ");
INSERT INTO kenNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Abhɔ́ŋ manɔ anɛ áká nnyɛ́n bɛ María. María arɔk asibhiri ndǔ bɛkak Acha angoko nɔkɔ Ɛyɔŋ Mandɛm ɛnɛ yi átɔ̀ŋ; ");
INSERT INTO kenNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Matá ankʉ nɔkɔ chi bɛtɨk ɛbhɛn nywɔp ndu mɛne Yesu. Ághɔ́ nɔ́kɔ́ bɛ́ bɛtɨk bɛyǎ ntá yi aywǐntí, arɔk ntá Yesu arɛm bɛ, “Acha, ɔbhɨ́kɨ́ ghɔ ndǔ mɔ́maya árɔ́ bɛtɨk mɛnkɛm mɛ awɔ́? Ghatí yi antwɔ ankwak mɛ!” ");
INSERT INTO kenNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Kɛ Acha akɛmɛ yi chi bɛ, “Matá, Matá! Ɔ̌fyɛ́ ntí nɛ ɔ̌dɛ̀n mmʉɛt ɛ̌ti bɛyǎ mɛnyɨŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Dɨŋɨ́ bɛ́ ɛnyɨŋ ɛ́mɔt kɛ ɛrɨ ɛcha. Yɔ́ kɛ̌ María áyábhɛ́, nɛ yɛ̌ mmu apú kway bɛsɔt yɔ ntá yi.” ");
INSERT INTO kenNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ɛwak ɛ́mɔt, Yesu are nɨkmʉɛt nɛbhʉ́ɛ́rɛ́fu. Ánáŋá nɔ́kɔ́, nkoŋo ywi amɔt arɛm ntá yi bɛ, “Acha, tɔ́ŋ bhɛsɛ ɛnyu mánɨkmʉɛt mbɔ ɛnyǔ Jɔ̌n átɔ́ŋ nyaka baghɔk abhi.” ");
INSERT INTO kenNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu aghati baghɔkɔ́ bhi bɛ, “Yɛ̌ntɨkɨ mpok anɛ mǎnɨkmʉɛt, dɛm ka bɛ́: ‘Ɛta, kʉ bo mánchyɛ́ nnyɛ́n ɛnɛ kɛnókó. Kʉ bo mándɔ́ wɔ ɔmbak Mfɔ wap. ");
INSERT INTO kenNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Chiɛ́ bhɛsɛ yɛ̌ntɨkɨ nywɔp, ɛnǐ nɛnyíɛ́. ");
INSERT INTO kenNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Foŋorí bɛbʉ́ bhɛsɛ́, mbɔ ɛnyu sɛ́fòŋori yɛ̌ntɨkɨ mmu anɛ ákʉ́ bhɛsɛ bɛbʉ́. Nɛ kɛ́ka sɛ́nchwe ndǔ nɛmɔ ɛnɛn nɛ́kʉ sɛ́nkwɛ́n ndǔ bɛbʉ́.’” ");
INSERT INTO kenNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesu arɛm yɛ ntá yap bɛ, “Sɛ́nsɔ́t bɛ mmu ywɛka amɔt arɔ̌ŋ ntá mmʉɛrɛ ywi mpok nywɔp nɛ́gháká nɛ́ntɨ́bhɛti, adɛp nɛkok arɛm bɛ, ‘Nkwǎnɛ, nnɨkmʉɛt pwɔ mɛ bɛkpkɔkɔ́ brɛt bɛ́rát. ");
INSERT INTO kenNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Mmʉɛrɛ wa amɔt anɛ achi ambi ndǔ nɛkɔ atwɔ mɛ anywɔ́p nɛ́nɛ, nɛ mbɨ́kɨ́ bhɔŋ nɛnyíɛ́ bɛchyɛ yí anyiɛ!’ ");
INSERT INTO kenNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Mmʉɛrɛ ywɛ wu ankɛmɛ bɛ, ‘Kɛ́pɛrɛ sɔŋɔri mɛ. Nnáŋ mfe mbǐnywɔp nɛ nnáŋ mbʉrɛ nɛ bɔ̌bha. Mpú kway bɛfate bɛ nchyɛ́ wɔ yɛ̌nyɨŋ.’ ");
INSERT INTO kenNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Dɨŋɨ́ ká bɛ, yɛ̌ ndǔ yi ápú kway bɛfate bɛ anchyɛ yi nɛnyíɛ́, ɛ̌ti yi achi mmʉɛrɛ ywi, abhɔŋ bɛ́fáte anchyɛ yi yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ́ yi áyaŋ mbɔnyunɛ atóŋórí bɛ́dɛ́p nɛkok kɛbhɔŋ ntíánwɔ́p. ");
INSERT INTO kenNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nchí ghati yɛ bhe bɛ́: Nɨk ka mmʉɛt ɛ̌ti ɛnyɨŋ ɛnɛ ɔ́yàŋ, chɔŋ Mandɛm anchyɛ wɔ. Yáŋ, chɔŋ ɔngɔ. Dɛp nɛkok, chɔŋ mánɛnɛ ntá yɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kʉ nɔ, mbɔnyunɛ yɛ̌ntɨkɨ mmu anɛ ánɨ̀kmʉɛt ɛ̌ti ɛnyɨŋ ɛnɛ yi áyàŋ, Mandɛm ǎchyɛ yɔ ntá yi. Yɛ̌ntɨkɨ mmu anɛ áyàŋ ɛnyɨŋ, ǎghɔ yɔ. Yɛ̌ntɨkɨ mmu anɛ ádɛ́bhɛ́ nɛkok, mánɛnɛ ntá yi. ");
INSERT INTO kenNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Bě bachǐbhɔ, mmǔ ywɛka anɛ mbák mɔ́ywi abhɛp yi tansi, ansɔt chi nnyɔ́ anchyɛ yi, chi agha? ");
INSERT INTO kenNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Yɛ̌ chí nɛchǐ-nkɔk kɛ̌ mmɔ́ abhɛp wɔ, ɔ̌chyɛ yi ngá-nɛghay? ");
INSERT INTO kenNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mbák be bǒ bɛbʉ́, bǎbhɔŋ ntɨ bɛchyɛ bɛrɨ́tí mɛnyɨŋ ntá bɔ̌bhɛka, bǎkáysí bɛ Ɛta mmu achi amfay, ǎnɔk bɛchyɛ Ɛfóŋó Bɛdyɛrɛ ntá bo abhɛn mánɨ̀kmʉɛt bɛ yi anchyɛ bhɔ Ɛfóŋó Bɛdyɛrɛ kɛ?” ");
INSERT INTO kenNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Mpokófu, Yesu ǎbók ɛfóŋó ɛbʉ́bʉ ɛnɛ ɛ́kʉ́ mmu akwɛnɛ kɛbhok. Ɛ́fú nɔ́kɔ́ mbók wu abho bɛrɛm kɛpɨ. Bo abhɛn bachi arɛ babhak maknkay. ");
INSERT INTO kenNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Kɛ mbɔk yap báré rɛm chi bɛ, “Bɛlsɛbul mfɔ bɛfóŋó bɛbʉ́bɛbʉ kɛ áchyɛ́ yi bɛtaŋ bɛbok bɛfóŋó bɛbʉ́bɛbʉ.” ");
INSERT INTO kenNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bo bárè yaŋ mbi mɛmɔ yi. Bábhɛ́p yi ankʉ ɛnyɨŋɨ́ maknkay ɛnɛ́ ɛ́bhak mbɔ ɛrɨŋ ɛnɛ́ ɛ́tɔŋ bɛ bɛtaŋ ɛbhi bɛ́fú chi ntá Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kɛ ndu Yesu árɨ́ŋɨ́ nkaysi yap, aghati bhɔ́ bɛ, “Yɛ̌ntɨkɨ ɛtɔk ɛnɛ akɔrɛ achi arɛ bo mánù nɔkɔ nɛ batɨ, ɛ́bhɔŋ chi mɛnɛmɛ. Nɛ nnɛrɛ́kɛt anɛ́ ákɔ́rɛ́ áchí arɛ nɛ bo mánù nɔkɔ nɛ batɨ, ákwɛ́nɛ́ kwɛn. ");
INSERT INTO kenNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nɛ mbák Satan ankʉ bɛfóŋó bɛbʉ́bɛbʉ bhi mɛnu nɛ batɨ, ná yi ákway bɛbhak ɛnyǔ mfɔ anɛ yi achi ndǔ ɛrɔri mpok? Nchí bhɛp be mbɔnyunɛ bǎrɛ̀m bɛ ndǔ bɛtaŋ Satan kɛ̌ mɛ̌bòk bɛfóŋó bɛbʉ́bɛbʉ. ");
INSERT INTO kenNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nɛ mbák ndǔ bɛtaŋ Satan kɛ̌ mɛ̌bòk bɛfóŋó bɛbʉ́bɛbʉ, bakoŋo bhɛka bábòk bhɔ ndǔ bɛtaŋ agha? Chɔŋ bakoŋo bhɛka mántaŋ be! ");
INSERT INTO kenNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Kɛ mbák, sayri sayri mɛ̌bòk bɛfóŋó bɛbʉ́bɛbʉ chi ndǔ bɛtaŋ Mandɛm, nɔ chi Mandɛm anáŋ achi nɛntɨ ɛnɛka mbɔ Mfɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Mpok mmǔ ntantaŋ ábhabhɛri ɛkɛt ɛyi nɛ mɛnyɨŋɨ́ nɛnu bhi, yɛ̌ mmu apu kway bɛghɛp mɛnyɨŋ ɛbhi. ");
INSERT INTO kenNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kɛ mbák mmu anɛ átáŋ acha yi atwɔ ǎnu nɛ yí, andɛ́n yi, ansɔt mɛnyɨŋɨ́ nɛnu ɛbhi ɛbhɛn yi asɨkɨ ntɨ arɛ, ampɔkɔ mɛnyɨŋ ɛbhi andɔk ankɔrɛ nɛ bo bachak. ");
INSERT INTO kenNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Mmu anɛ apu nɛ mɛ, achi chi mǔmpap wa. Nɛ mmu anɛ ápú kwak mɛ ndu mɛ̌nyókóti bho, ǎtàkatak.” ");
INSERT INTO kenNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Bɛ́rɔ́ŋ ambɨ Yesu arɛm bɛ, “Mbák mámbók ɛfóŋó ɛbʉ́bʉ ɛ́ndɔ́ mmu, ɛ́rɔp chí bóŋboŋbóŋ amɛm baso, ɛ́njaŋ nɔkɔ ɛbhak ɛnɛ yɔ ɛ́chwe. Mbák ɛ́bhɨ́kɨ́ ghɔ́ ɛbhak bɛchɔkɔ, ");
INSERT INTO kenNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ɛ́rɛ̀m bɛ, ‘Chɔŋ mpɛtnsɛm ɛbhak ɛnɛ mfú.’ Nɛ ɛ́náŋ ɛ́mpɛ́tnsɛm, ɛngɔ bɛ mányɔ ɛsɨ ɛkɛt ɛyi, bághókó sayri, ");
INSERT INTO kenNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ɛfóŋó ɛbʉ́bʉ ɛyɔ ɛ́rɔ̀ŋ yɛ, ɛ́nsɔt bɛfóŋó bɛbʉ́bɛbʉ bɛ́chák tándrámɔt ɛbhɛn bɛ́bɛ́bhɛ́ bɛcha yɔ. Bɔ́ mɛnkɛm mɛndɔk mɛnchwe mmu wu amʉɛt mɛ́mbak nɛ yi, nté yi ambɛp ancha anɛ mbɨ.” ");
INSERT INTO kenNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu árɛ́mɛ́ nɔ́kɔ́ nɔ, ngɔrɛ́ amɔt amɛm ngɛ́mtáy bo abhɛn bachi arɛ arɛm ntá Yesu nɛ ɛyɔŋ amfay bɛ, “Ɛ́rɨ ɛcha ntá ngɔrɛ́ anɛ ábhé wɔ, achyɛ wɔ amɨ!” ");
INSERT INTO kenNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesu akɛmɛ bɛ, “Bo abhɛn ɛyap ɛrɨ ɛcha chi abhɛn bághòk Ɛyɔŋ Mandɛm nɛ mánkʉ nɔkɔ mbɔ ɛnyǔ ɛ́yàŋ!” ");
INSERT INTO kenNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ɛnɛ́ bo báchák báchɛ̀m arɛ́ mándɔk nɔkɔ chi ambɨ, Yesu abho bɛrɛm ntá yap bɛ, “Mkpáká bho anɛ ɛchɔŋ ábɛp acha! Bábhɛ̀p bɛ mántɔ́ŋ bhɔ́ ɛrɨŋɨ́ maknkay. Kɛ yɛ̌ ɛmɔ́t mpu tɔŋ bhɔ, ɛ́bhɨ́kɨ́ fʉɛt ɛnɛ Jóna. ");
INSERT INTO kenNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nkúbhɛ́ mbɔ ɛnyǔ Jóna achi nyaka ɛrɨŋ ntá bo Ninivɛ, ɛnyu yɔ kɛ̌ Mɛ Mmu mfú ntá Mandɛm nchí bhak chɔŋ ɛrɨŋ ntá mkpáká bho abhɛn ɛchɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ɛwak Mandɛm átàŋ bǒ mmɨk, mfɔ ngɔrɛ́ anɛ áchí nyaka ɛtɔk Shɛ́ba ǎfate andɛm bɛ be bo mkpáká mmɨk anɛ ɛchɔŋ bǎkʉ́ bɛbʉ́ mbɔnyunɛ yi afu nyaka nɛkɔ nɛsiɛ arɔk bɛghok mɛnyɨŋ ɛbhɛn Mfɔ Sólomon átɔ̀ŋ bho nɛ bɛyǎ nɛrɨŋɨ́ndak. Nɛ nchí ghati bhe bɛ mmu achi fá nɛ́ntɨ́ ɛnɛka anɛ acha Sólomon, Yɛ̌ nɔ́, bǎpú ka bɛghok yi. ");
INSERT INTO kenNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ndǔ nywɔbhɛ́ manyé, chɔŋ bǒ Ninivɛ mángati be bho mkpáká mmɨk anɛ ɛchɔŋ bɛ́ bɛkwɛ́nɛ́ bɛchi nɛ bhe mbɔnyunɛ mpok bɔ bághókó ɛnyɨŋ ɛnɛ Jóna aghati bhɔ, bátɨ́knsɛm ndǔ bɛbʉ́ bhap. Nchí ghati bhe bɛ mmu achi fá nɛ́nɛ anɛ áchá Jóna, yɛ̌ nɔ, bǎpú ghok yi! ");
INSERT INTO kenNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Yɛ̌ mmu apú durɛ ɛrɔ́ŋɔ́ ansɔt ɛnyɨŋ ankuti. Bádʉrɛ ɛrɔ́ŋɔ́, mánte chi ɛbhak ɛnɛ babhɔŋɔ bɛte yɔ bɛ mbaŋ angɔ́ɔ́ ntá yɛ̌ntɨkɨ mmu anɛ achwe anywɔ́p. ");
INSERT INTO kenNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Amɨ́k ayɛka achi bɛrɔ́ŋɔ́ ɛbhɛn bɛ́kʉ̀ mǎngɔ mbaŋ. Mpok amɨ́k ayɛka achi arɨ́árɨ́, mmʉɛt ɛyɛka ɛnkɛm ɛ́jwi nɛ bɛdiɛ́rɛ́. Kɛ mbák amɨ́k ayɛka ápú arɨarɨ, mmʉɛt ɛyɛka ɛnkɛm ɛ́jwi nɛ ɛjuri. ");
INSERT INTO kenNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Sɔt yɛ ka mpok bɛ bɛdiɛ́rɛ́ ɛbhɛn bǎkaysi bɛ bɛchi be antɨ bɛ́kɛ́ bhak ɛjuri. ");
INSERT INTO kenNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mbák yɛ batɨ yɛka ankɛm ajwi nɛ bɛdiɛ́rɛ́, nɛ yɛ̌ mandú ɛjuri apu arɛ, chɔŋ nɛpɛ́m ɛnɛka nɛnkɛm nɛmbak pɛ́pɛ́p, mbɔ mmu anɛ ábhɔ́ŋɔ́ ɛrɔ́ŋɔ́ nɛ ɛ́ghɔ̀, ɛntɔŋ nɔkɔ yi mbi.” ");
INSERT INTO kenNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu ánáŋá nɔ́kɔ́ bɛrɛm kɛpɨ ɛkɛn, mǔnkwɔ Fárisi amɔt abhɨŋɨ yi ndǔ nɛnyíɛ́ ɛkɛt ɛyi. Yesu arɔk achwe anywɔ́p, achɔkɔ amɨk mɛnyiɛ nɛnyíɛ́. ");
INSERT INTO kenNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mǔnkwɔ Fárisi wu abhak maknkay bɛ́ghɔ bɛ Yesu abhɨkɨ so amɔ mbɔ ɛnyǔ ɛpɨŋ ɛyap ɛ́tɔ́ŋ kɛ anyiɛ nɛnyíɛ́. ");
INSERT INTO kenNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Acha aghati mǔnkwɔ Fárisi wu bɛ, “Bě bǒnkwɔ Fárisi, bǎsɔ̀t mpok bɛ́tyɛ́t nsɛmɛ́ nchán kɛ mɛŋɛ́mɛ́ nɛ bɛbʉ́ bɛjwi be antɨ. ");
INSERT INTO kenNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Bě bɛchɨŋtǐ bho! Mandɛm anɛ aghókó ɛnyɨŋ, pú yi kɛ aghoko mmɛm nɛ nsɛm ɛyi nkwɔ? ");
INSERT INTO kenNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kɛ ɛnyɨŋ ɛnɛ bǎbhɔŋɔ bɛkʉ chi bɛsɔt mɛnyɨŋ ɛbhɛn bɛchi amɛm bɛkpʉrɛ ɛbhɛka mánchyɛ ntá bachɛ́bhɛ́bho nɛ chɔŋ bɛpɨŋ ɛbhɛka mɛnkɛm mɛ́mbak nkwɔ pɛ́pɛ́p. ");
INSERT INTO kenNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Bě bǒnkwɔ Fárisi, chɔŋ ɛmbɛp ntá yɛka ɛncha, mbɔnyunɛ bapú kʉ ɛnyɨŋ ɛnɛ ɛchi chak ntá bho nɛ bǎbhɨkɨ kɔŋ Mandɛm. Bǎsɔt ndu bɛrɨ amɔt ndǔ baru byo mǎnchyɛ ntá Mandɛm, mǎnkʉ ɛnyumɔt nɛ mbwɔt achak. Bǎbhɔŋ bɛkɔŋ Mandɛm nɛ mǎmbak sayri nɛ bho kɛ bǎbhɨkɨ bhɔŋ bɛghɔkɔntɨk bɛbhé bɛ́chák. ");
INSERT INTO kenNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Bě bǒnkwɔ Fárisi, chɔŋ ɛmbɛp ntá yɛka ɛncha! Bǎkɔŋ bɛchɔkɔ ndǔ mɛnɔk kɛnókó amɛm bɛkɛrɛ́ nɛnɨkɨ́mʉɛt bo Israɛl, nɛ bǎkɔ̀ŋ bɛ bo mankaka nɔkɔ bhe nɛ kɛnókó nɛfísiɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Chɔŋ ɛ́mbɛ́p ntá yɛka ɛncha! Bǎchí mbɔ manɛm anɛ mmu ákɔ̀ amfay kɛrɨŋɨ bɛ chi manɛm.” ");
INSERT INTO kenNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ntɔŋ ɛbhé Mandɛm amɔt arɛm ntá Yesu bɛ, “Ntɔŋ, mpok ɔ́rɛ̀m mɛnyɨŋ ɛbhɛn, ɔ́chyɛ bhɛsɛ nkwɔ ntíánwɔ́p!” ");
INSERT INTO kenNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu akɛmɛ bɛ, “Bě batɔŋ ɛbhé Mandɛm, chɔŋ ɛmbɛp ntá yɛka nkwɔ ɛncha! Nti achi bɛ mǎnyìɛ̀rɛ bo mámpɔ́kɔ́ mɛnwɔ́ptí batu anɛ́ be babhɔŋ bǎpú kwak bo mámbʉ́rɛ́ bɛbhé bhɔ yɛ̌ mandú. ");
INSERT INTO kenNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Chɔŋ ɛ́mbɛ́p ntá yɛka ɛncha! Bachǐmbɨ bhɛka báwày nyaka barɛmɛ́ kɛpɨ̌ntɨ. Bǎtè manɛm ayap nɛ́nɛ, mǎngwati mbɨ arɛ́ bɛkʉ yɔ ándɨ́ amɨk. ");
INSERT INTO kenNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Bɛkʉ ɛnyu ɛyɔ, ɛ́tɔ̀ŋ bɛ bǎchi ɛnyumɔt mbɔ bachǐmbɨ bhɛka abhɛn báwáy nyaka barɛmɛ́ kɛpɨ̌ntɨ Mandɛm ndǔ bǎtè bɛrɨ́ti manɛm ntá yap. ");
INSERT INTO kenNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ɛ̌tiyɔ, kɛ Mandɛm, ndǔ nɛrɨŋɨ́ndak ɛni, árɛ́mɛ́ bɛ ‘Chɔŋ ntó barɛmɛ́ kɛpɨ̌ntɨ nɛ bǒnto bha ntá bo Israɛl; nɛ chɔŋ mǎngwáy mbɔk ɛyap, nɛ mánchyɛ abhɛ́nɛ́fú bɛyǎ ɛsɔŋɔri.’ ");
INSERT INTO kenNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Chɔŋ Mandɛm antɛmsi yɛ mkpáká bho abhɛn ɛchɔŋ ɛ̌ti manoŋ barɛmɛ́ kɛpɨ̌ntɨ mankɛm abhɛn bɔ báwáy tɛ nɛbhǒmɨk, ");
INSERT INTO kenNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","bɛbho nɛ Ábɛl kpát bɛghaka amʉɛt Sakaría mu báwáy nɛntɨ ɛ́fɛ́mɛ́ akap nɛ ɛkɛrákap Mandɛm. Nchí ghati bhe bɛ chɔŋ Mandɛm antɛmsi mkpáká bho abhɛn ɛchɔŋ ɛ̌ti bawú yɔ ankɛm! ");
INSERT INTO kenNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Bě batɔŋ ɛbhé Mandɛm, chɔŋ ɛ́mbɛp ntá yɛka ɛncha! Bǎbhɛsɛ ɛfɨŋɨ́ ɛnɛ mánɛ̀nɛ mbǐnywɔp anɛ mmu áfʉɛ̀t arɛ́ kɛ ambɔ́ŋ nɛjwǐmɛm ndǔ barak Mandɛm. Bǎbhɨkɨ chwe arɛ, nɛ bǎchyɛt mbi ntá abhɛn báyàŋ nyaka bɛchwe arɛ!” ");
INSERT INTO kenNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nɛrɔ anɛ Yesu árɔ̀ nɛbhʉɛt wu, batɔŋ ɛbhé Mandɛm nɛ bǒnkwɔ Fárisi babho bɛchiti yi nɛ bɛbhɛ́p, mányɔŋti nɔkɔ yi bɛkʉ yi ankwɛn anyu. ");
INSERT INTO kenNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Nɛ mánɔbhɛri nɔkɔ yí ndu bɛkʉ yi ákwɛ́n ndǔ ɛyɔŋɔ́nyu. ");
INSERT INTO kenNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ɛnɛ Yesu árɛ́m nɔ, bo báre twɔ, kpát báyá báchá, mánjati nɔkɔ batɨ. Yesu ayambɨ arɛm ntá baghɔkɔ́ bhi bɛ, “Sɔt ka mpok nɛ yís bǒnkwɔ Fárisi. Báchi chi bǒ bɛtábhá. ");
INSERT INTO kenNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ bakuti, chɔŋ mánɛnɛ. Nɛ ɛnɛ́ ɛchi bhɛ́sɛ́ bhɛ́sɛ́ chɔŋ mánkʉ bo mandɨŋɨ yɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ndu ɛchi nɔ, yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ bǎrɛ́mɛ́ ansɛm ansɛm, chɔŋ bo mangok yɔ kpoŋoroŋ. Nɛ mɛnyɨŋ ɛbhɛn bǎghati bǎrǔ bho ansɛm ansɛm chɔŋ bo mánte amfay bɛkɛt mámbɨk bɛ bo mángók. ");
INSERT INTO kenNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Mamʉrɛ bha, nchí ghati bhe bɛ, bǎkɛ́ cháy bǒ mmɨk. Bǎkway bɛway chi mmʉɛt nkwǎ kɛ bápu kway bɛku ɛnyɨŋ ɛchak ɛnɛ ɛbɛbhɛ ɛcha ɛyɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ghók ká mmu anɛ bǎbhɔ́ŋɔ́ bɛ́chay. Cháy ka mmu anɛ ákway bɛway mmʉɛt yɛka, nɛ ankwáy mɛmɛsɛ be amɛm nɛpǐngo! ");
INSERT INTO kenNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Pú mmu akway bɛku bɔ̌kɛnɛn batay nɛ nkáp anɛ apu yɛ̌nyɨŋ? Yɛ̌ nɔ, Mandɛm apú ghɔkɔntɨk yɛ̌ amɔt. ");
INSERT INTO kenNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kɛ ná nɛ be? Mandɛm arɨ́ŋɨ́ yɛ̌ chí mpǎy bɛkaká ɛmɛnɛ ɛbhɛn bɛ́chí yɛ̌ntɨkɨ mmu ywɛka anti. Bǎkɛ́ chay yɛ yɛ̌nyɨŋ ɛnɛ́ bo bakway bɛkʉ bhe. Bɛsí Mandɛm, yɛ̌ntɨkɨ mmu ywɛka abhɔŋ mɛnwɔp tontó achá ngɛ́mtáy kɛnɛn. ");
INSERT INTO kenNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nchí ghati yɛ be bɛ, yɛ̌ntɨkɨ mmu anɛ árɛ̀m kpoŋoroŋ bɛsí bǒ mmɨk bɛ yi achi mmu wa, chɔŋ Mɛ Mmu mfú ntá Mandɛm ndɛm bɛsí bɔángɛl Mandɛm ndǔ nywɔp manyé bɛ mmu wu achi awa. ");
INSERT INTO kenNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kɛ mmu anɛ ataŋa kpoŋoroŋ bɛsí bho bɛ apu mmu wa, chɔŋ mɛnkwɔ ntaŋa bɛsí bɔángɛl Mandɛm bɛ yi apu mmu wa. ");
INSERT INTO kenNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Nɛ chɔŋ Mandɛm amfoŋori yɛ̌ntɨkɨ mmu anɛ árɛ̀m ɛbʉ́bʉ ɛ̌ti Mmu anɛ áfú ntá Mandɛm, kɛ apú foŋori mmu anɛ árɛ̀m ɛbʉ́bʉ ɛ̌ti Ɛfóŋó Bɛdyɛrɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Mpok básɔ́rɛ́ bhe ambɨ ndu bɛtaŋ be amɛm bɛkɛrɛ́ nɛnɨkɨ́mʉɛt ɛbhap nɛ bɛsí bǒbati ɛtɔk nɛ bɔgɔ́bhanɔ, bǎkɛ́ sɛmɛ ɛnyǔ bǎkwày bɛtaŋa mmʉɛt nɛ ɛ̌ti ɛnyɨŋ bɛrɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mpok ɛyɔ chɔŋ Ɛfóŋó Bɛdyɛrɛ ántɔ́ŋ be ɛnyɨŋ ɛnɛ bǎbhɔ́ŋɔ́ bɛrɛm.” ");
INSERT INTO kenNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ɛnɛ́ Yesu ǎchyɛ̀ baghɔkɔ́ bhi maniɛ ɛnyu ɛyɔ, mmu amɔt amɛm ngɛ́mtáy bho arɛm ntá Yesu bɛ, “Ntɔŋ, ghatí mɔ́maya ánkɔ́rɛ́ nɛwú ɛtayɛsɛ ánchyɛ́ ɛbha mɛnyɨŋ!” ");
INSERT INTO kenNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu akɛmɛ yi bɛ, “Nkwánɛ, agha ábhʉ́rɛ́ mɛ́ ntaŋá manyé nɛ nkɔ́rɛ mɛnyɨŋɨ́ nɛwú ntá yɛka?” ");
INSERT INTO kenNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kɛ arɔk ambɨ arɛm ntá bo mankɛm bɛ, “Sɔt ka mpok! Kɛ́m ká mmʉɛt bɛ bǎkɛ́ fyɛ ngoŋo ndu bɛbhɔŋ bɛyǎ mɛnyɨŋ. Puyɛ̌ chi bɛyǎ mɛnyɨŋ kɛ bɛ́kɛ̀m nɛpɛ́m nkwǎ.” ");
INSERT INTO kenNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yesu átɛ́m bɔ́ nɛkay bɛ, “Nkɨ mǔnkáp amɔt áchyɛ̀ nyaka yi bɛyǎ mbwɔt. ");
INSERT INTO kenNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ɛkʉ abho bɛ́káysi andɛmɛ nɔkɔ bɛ, ‘Chɔŋ nkʉ yi? Mbɨ́kɨ́ pɛrɛ bhɔŋ nɛbhʉɛt bɛ́bhʉrɛ mbwɔt?’ ");
INSERT INTO kenNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kɛ árɛm nɛ mmʉɛt yi bɛ, ‘Chɔŋ mmokoti bɛ̌tak ɛbha, ngoko ɛbhɛn bɛ́chɨ́kɨ́tí, mfyɛ́ mbwɔt aya nɛ mɛnyɨŋ ɛbha arɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ndɛm yɛ nɛ mmʉɛ́t ɛya bɛ, ‘Ɔnáŋ ɔbhɔ̌ŋ bɛyǎ mɛnyɨŋ ɛbhɛn bɛsɔt bɛyǎ mamiɛ́. Kɛ́pɛrɛ sɔŋɔri mmʉɛt. Nyiɛ́, nyú, ɔ́nkʉ maŋák.’ ");
INSERT INTO kenNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kɛ Mandɛm aghati yi bɛ, ‘Wɔ ɛchɨŋtɨ́mu! Nkúbhɛ́ bɛti ɛbhɛn, nɛpɛ́m ɛnɛ nɛ́may. Kɛ mɛnyɨŋ ɛbhɛ́n ɔ́bhʉ́rɛ́ bɛ́rɔ̀p chɔŋ chi ɛbhɛn bo bachak!’ ");
INSERT INTO kenNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nɔ́ kɛ ɛ́fakari nɛ mmu anɛ ábhʉ́rɛ́ mɛnyɨŋ ntá yímbɔŋ, kɛ yi kɛkʉ mɛnyɨŋ ɛbhɛn bɛ́bhɔ́ŋɔ́ mɛnwɔp bɛsí Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesu aghati yɛ baghɔkɔ́ bhi bɛ, “Nɔ́ kɛ̌ nchí ghati bhe bɛ, mmu ákɛ́ bhɔŋ basɛ́mɛ́ ɛ̌ti nɛpɛ́m ɛni bɛ chɔŋ nyiɛ́ yi, chɔŋ mfyɛ́ yi? ");
INSERT INTO kenNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nɛpɛ́m nkwǎ nɛ́bhɨ́kɨ́ cha nɛnyíɛ́? Nɛpɛ́m nkwǎ nɛ́bhɨ́kɨ́ cha ndɛnɛ́? ");
INSERT INTO kenNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Yɨŋɨ́ ká kɛnɛn. Kɛ́pú kwaŋ nɛnyíɛ́ nɛ kɛ́pú fɛrɛ mbwɔt ɛbhɨ. Kɛ́bhɨ́kɨ́ bhɔŋ bɛkɛt nɛ yɛ̌ chi bɛ̌ták ɛbhɛn bɛ́bhʉ̀rɛ nɛnyíɛ́ arɛ́. Mandɛm kɛ áchyɛ̀ kɔ nɛnyíɛ́, nɛ bɛsí Mandɛm, bǎcha kɛnɛn tontó! ");
INSERT INTO kenNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nɛ ntɨkɨ mmu ywɛka basɛ́mɛ́ ákway bɛkʉ nɛpɛ́m ɛni nɛ́nsap, yɛ chi mandú nɨŋɨnɨŋɨ nɛ́nchá ɛnyu nɛbhɔŋɔ bɛbhak? ");
INSERT INTO kenNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mbák yɛ bapú kway bɛkʉ mandú ɛnyɨŋ mbɔ ɛyɔ, ndaká yi bǎbhɔŋ basɛ́mɛ́ ɛ̌ti mɛnyɨŋ bɛchak? ");
INSERT INTO kenNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Yɨŋɨ́ ká bɔchuchu abhɛn bágò. Bápú kʉ bɛtɨk, nɛ bapu ghoko ndɛn. Kɛ nchí ghati bhe bɛ, yɛ̌ chí Mfɔ Sólomon mmu ábhɔ́ŋɔ́ nyaka bɛyǎ kɛnɛ́m, abhɨ́kɨ́ bhɔŋ nyaka ndɛn ɛnɛ ɛrɨ mbɔ yɛ̌ chuchu amɔt. ");
INSERT INTO kenNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Mandɛm kɛ̌ ághókó tákɔ nɛ bɛrɨ ɛbhi, tákɔ anɛ ákway bɛbhak ɛchɔŋ, mbúrɛ́ angwɔsi, mámfyɛ́ ango. Bǎkáysí bɛ́ be kɛ̌ Mandɛm apu kwáy bɛ́kwák mǎmbɔ́ŋ ndɛn bɛ́fyɛ́ amʉɛt kɛ? Nɛka ɛnɛká nɛ Mandɛm nɛ́gʉ́psi nɛcha! ");
INSERT INTO kenNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Bǎkɛ́ sɔŋɔri yɛ batɨ̌ yɛka bɛbhɛp ɛ̌ti ɛnyɨŋ mɛ́nyiɛ nɛ ɛ̌ti ɛnyɨŋ mɛnyu. ");
INSERT INTO kenNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Bǒ mmɨk bákòŋo mɛnyɨŋ ɛbhɛn kɛ dɨŋɨ́ ka bɛ Ɛtayɛka arɨŋɨ bɛ bǎbhɔŋ bɛbhɔŋ bɔ́. ");
INSERT INTO kenNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Fíɛ́ ká ntí chi bɛ Mandɛm ámbák Mfɔ ywɛka, nɛ chɔŋ yí anchyɛ be mɛnyɨŋ ɛbhɛn mɛnkɛm nkwɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Bɔ̌bha, bǎkɛ́ chay, yɛ̌ndu bǎchi nkwɔ bághɔ́ŋɔmɛ́n anɛ abhɨkɨ ya. Mandɛm abhɔŋ maŋák bɛchyɛ be akɔrɛ ndǔ kɛfɔ ɛki. ");
INSERT INTO kenNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tí ká mɛnyɨŋ ɛbhɛn bǎbhɔ́ŋɔ́ mǎnchyɛ nkáp ntá bachɛ́bhɛ́bho. Bɔ́ŋ ká bɔ̌bɛbhǎ-nkap abhɛn bápú chɔŋɔ bɛ nkáp anɛm. Bʉrɛ́ ká kɛfɔ̌ mɛnyɨŋ ɛkɛka amfay. Arɛ́, kɔ́ kɛ́bhak mpoknkɛm. Yɛ̌ ngɛ́p apu kway bɛghɛp ɛnyɨŋ arɛ, nɛ kɛngɔk apú chwe ánchɔŋti yɛ̌nyɨŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ɛbhak ɛnɛ́ nkáp ywɛ áchí, arɛ́ kɛ̌ ntɨ ɛnɛ nkwɔ nɛ́bhak. ");
INSERT INTO kenNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Toŋtí ká mmʉɛt mǎndurɛ bɛrɔ́ŋɔ́ bhɛka. ");
INSERT INTO kenNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Bák ká mbɔ bɔ̌-bɛtok abhɛn mánòŋ bɛ chi-bɛtɨk awap amfu ndǔ ɛpǎ nɛbhay ɛnɛ yi árɔ́ŋɔ́ arɛ ampɛtnsɛm bɛ mánɛ́nɛ́ mbǐnywɔp ntá yi tɛ́mté, mpok yi átwɔ́ ádɛ́bhɛ́ nɛkok. ");
INSERT INTO kenNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Chɔŋ ɛndɨ ɛncha ntá bo abhɛn bábhak pě mpok ɛtayap átwɔ́! Tɛtɛp nchí ghati bhe bɛ mpok yi atwɔ, ǎghati bhɔ manchɔkɔ amɨk, anchóŋ ndɛn ɛyi, ansɔt nɛnyíɛ́ anchyɛ bhɔ manyíɛ́. ");
INSERT INTO kenNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Yɛ̌ antwɔ́ chí nɛ nɛ́ntɨ́ bhiti, yɛ̌ chí mpok nkɔk ɛ́kòk, kɛ antɛmɛri bhɔ pě, ɛ́rɨ ɛncha ntá bǒ bɛtok bhɔ! ");
INSERT INTO kenNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Dɨŋɨ́ ká bɛ mbɔ mbɔŋɔ́kɛt ǎrɨŋɨ nɛŋɔkɔ́ nywɔp ɛnɛn ngɛ́p átwɔ̀, mbʉ apú rɔ mándak ɛkɛt ɛyi. ");
INSERT INTO kenNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Bě nkwɔ bǎbhɔŋ bɛtoŋti mmʉɛt Mmu anɛ áfú ntá Mandɛm átwɔ̀ chɔŋ chi ndǔ mpok anɛ bábhɨ́kɨ́ kaysi bɛ yi ǎtwɔ̀.” ");
INSERT INTO kenNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Píta abhɛ́p Yesu bɛ, “Acha, ɔtɛ̌m nɛkay ɛnɛn chí ntá yɛsɛ kɛ chi ntá bo mankɛm?” ");
INSERT INTO kenNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Acha akɛmɛ yi bɛ, “Mmǔ bɛtok anɛ achi tɛtɛp nɛ ndɨŋɨndak chí anɛ? Chí anɛ chi-bɛtɨk ywi áchyɛ́ yi bɛtaŋ bɛ anjɨŋɨ nɔkɔ batɨ̌ bakʉ̌ bɛtɨk abhɛn bachi amɛm ɛfo yi, anchyɛ nɔkɔ bhɔ awap ákɔrɛ nɛnyíɛ́ ndǔ mpok. ");
INSERT INTO kenNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Chɔŋ ɛndɨ ɛncha ntá mǔbɛtok wu anɛ chi-bɛtɨk ywi átwɔ antɛmɛri yi ndu ákʉ̀ ɛnyɨŋ ɛnɛ baghati yi ankʉ! ");
INSERT INTO kenNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nchí ghati bhe bɛ, mbák nkʉbɛtɨk wu ákʉ nɔ chi-bɛtɨk ywi ǎchyɛ yi bɛtaŋ amfǎy mɛnyɨŋ ɛbhí mɛnkɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kɛ mbák mǔbɛtok arɛm bɛ, chi-bɛtɨk awa ǎtat bɛ́twɔ, ambo bɛdɛn bɔ̌-bɛtok bachak, abhɛn baghɔrɛ́ nɛ abhɛn babhakanɛm, nɛ ambo mɛ́nyiɛ, anyu nɔkɔ, kpát mmɛm ánkɛm yi, ");
INSERT INTO kenNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","chi-bɛtɨk ywi ǎtwɔ̀ ndǔ nywɔp ɛnɛn mǔbɛtok abhɨkɨ kaysi bɛ yí ǎtwɔ̀ nɛ ndǔ nɛŋɔkɔ́ nywɔp ɛnɛn mǔbɛtok wu abhɨkɨ rɨŋɨ. Antɛmsi yi, amfyɛ yi nɛbhʉɛt anɛ bo abhɛn bábhɨ́kɨ́ noko Mandɛm bachi. ");
INSERT INTO kenNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Nɛ mǔbɛtok anɛ árɨ́ŋɨ́ ɛnyɨŋ ɛnɛ chi-bɛtɨk áyàŋ yi ankʉ, kɛ yi kɛ toŋti mmʉɛt ankʉ mbɔ ɛnyu ɛ́yaŋ, bátɛmsi chɔŋ yi sayri. ");
INSERT INTO kenNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kɛ anɛ ábhɨ́kɨ́ rɨŋɨ ɛnyɨŋ ɛnɛ chi-bɛtɨk áyàŋ yi ankʉ, mbák akʉ ɛnyɨŋ ɛnɛ ɛ́yàŋ mantɛmsi yi, báchyɛ yi chi mandú ntɛmsi. Bábhɛp tontó ntá mmu anɛ báchyɛ́ yi tontó. Nɛ báfyɛ amɨ́k tontó ntá mmu anɛ báfyɛ́ bɛyǎ mɛnyɨŋ amɔ́ yi.” ");
INSERT INTO kenNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesu apɛt arɛm bɛ, “Ntwɔ bɛgʉɛp chi ngó fá amɨk. Mbɔ ánaŋ akɛm, mbʉ nkɔŋ tontó! ");
INSERT INTO kenNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Chɔŋ mámfyɛ́ mɛ ndǔ ɛsɔŋɔri mbɔ mmǔ anɛ báfyɛ́ yi anyɛ́n ndǔ mpok anɛ bájwìti yi. Ntɨ nɛ́pú pɔp mɛ amɛm tɛ ɛsɔŋɔri ɛnɛ ɛ́ntwɔ ɛmfʉɛt! ");
INSERT INTO kenNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Bǎkáysí bɛ́ ntwɔ fá amɨk chi bɛkʉ bo mámbák ndu kpák nɛ batɨ kɛ? Ǎe, ntwɔ chí nɛ akɔrɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Bɛ́bhó nɛ́nɛ, yɛ̌ntɨkɨ ɛkɛt ɛnɛ́ bo bachi arɛ bati atay, chɔŋ ákɔ́rɛ́ ámbak nɛntɨ nap. Bati arat kɛka abhɛn bati apay. Bati apay kɛka abhɛn bati arat. ");
INSERT INTO kenNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ákɔ́rɛ́ ábhak chɔŋ ɛnyunɛ́ chi ápap mɔ́ywi anɛ mbakanɛm, mmɔ̌ anɛ mbakanɛm ampap ɛtayi, nnɔ ampap mɔ́ywi anɛ ngɔrɛ́, mɔ́ywi anɛ ngɔrɛ́ ampap nnɔ. Nnɔnɛ́m ampap ngɔrɛ́ mɔ́ywi, ngɔrɛ́ ampap nnɔnɛ́m ɛ́ywi.” ");
INSERT INTO kenNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu arɛm yɛ ntá ngɛ́mtay bho abhɛn bachi arɛ bɛ, “Mǎnáŋ mǎngɔ́ nɛbu ndǔ nɛ́gírí ndǔ ɛbhě nɛbu ɛnɛ mmok ánɛm arɛ, bǎrɛm bɛ ‘Manyiɛp átwɔ kwɛn’; nɛ ɛ́mbak ɛnyu yɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nɛ mǎnáŋ mǎngɔ nɛbháŋ ndu nɛbho bɛkwɛn, bǎrɛm bɛ, ‘Ɛnɛm ɛ́twɔ̀’; nɛ ɛ́mbak ɛnyu yɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Bě bǒ bɛtabha! Bǎrɨ́ŋɨ́ bɛ́yɨ́ŋɨ nɛbu mǎndɛm mbák manyiɛp ǎkwɛn chɔŋ, nɛ mbák apu kwɛn. Ndaká yí bǎbhɨ́kɨ́ rɨŋɨ mɛnyɨŋ ɛbhɛn Mandɛm ákʉ̀ ndǔ mpokó-nɛ? ");
INSERT INTO kenNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ndak yí bě babhɔŋ bapú kway bɛrɨŋɨ ɛnyɨŋ ɛnɛ ɛchi chak bɛ mmu ankʉ? ");
INSERT INTO kenNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mbák ɔbhɔ̌ŋ ndak nɛ mmu nɛ yi ákʉ́ manyé nɛ wɔ, ɔ̌kʉ yi? Ɔ́bhɔ̌ŋ bɛ́ghɔ bɛ ndaka wu ámay ansɛm ɛnɛ́ bǎbhɨ́kɨ́ rɔŋ ndu acha manyé. Mbák ɔ́nká yi ansɔt wɔ ambɨ ndǔ manyé, ntaŋá manyé ǎchyɛ̀ wɔ ntá bo mbɨ̌ŋ nkú nɛ bɔ mámfe wɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nchí ghati wɔ bɛ, ɔpú fu wawak kpátɛ ɔnchyɛ ákwɔ́ ywɛ ankɛm, yɛ̌nyɨŋ kɛrɔp.” ");
INSERT INTO kenNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nkúbhɛ́ mpok yɔ, mbɔk bho abhɛn bachi arɛ́, bátɛ́mɛ Yesu ɛ̌ti bo Galili abhɛn Páílet akʉ baway mpok báchyɛ̀ akap ntá Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu akɛmɛ bhɔ bɛ, “Bǎkáysí bɛ bo Galili bhɔ bákʉ́ nyaka bɛbʉ́ bacha bǒ ɛtɔk Gálili bachak kɛ? ");
INSERT INTO kenNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nɔ́ bhɔ! Dɔ̌ ngati be bɛ, mbák bǎbhɨkɨ tɨ́knsɛm ndǔ bɛbʉ́ ɛbhɛka, chɔŋ be mankɛm mǎngu mbɔ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ná nɛ bǒ batí nɛku-nɛ-arat abhɛn ɛkɛrɛ́mfáy ɛnɛ ɛchi nɛpak ɛ̌ntɨ́ŋnyɛn Sílom ɛ́kwɛ́nɛ́ ɛ́wáy? Bǎkáysí bɛ́ ɛfákárí nyaka nɛ bhɔ ɛnyu yɔ chí ndu bákʉ́ bɛbʉ́ bacha bo bachak abhɛn bachi ɛtɔk Yerúsalɛm yɔ kɛ? ");
INSERT INTO kenNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nɔ́ bhɔ! Nchí ghati be bɛ, mbák bǎbhɨ́kɨ́ tɨ́knsɛm ndǔ bɛbʉ́ ɛbhɛka, chɔŋ bě mankɛm mǎngu mbɔ bhɔ.” ");
INSERT INTO kenNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesu atɛ́m yɛ bhɔ nɛkay ɛnɛn bɛ, “Mmu amɔt apɨ nyaka ɛnɔk ɛnɛ babhɨŋɨ bɛ́ *fig amɛm nkɨ ywi. Ɛ́gháká nɔ́kɔ́ mɛ́nyu kɛpɛm, are kɔ ambyo nɔkɔ mbák ɛ́nyu kɛpɛm, kɛ akɛ ghɔ́ yɛ̌nyɨŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Aghati mmu anɛ ákʉ̀ bɛtɨk amɛm nkɨ wu bɛ ‘Yɨŋɨ́, ndǔ mamiɛ́ árát nchí twɔ bɛyaŋ kɛpɛm ndǔ ɛnɔk ɛnɛ, kɛ mpu ghɔ yɛ̌nyɨŋ. Kpɔ́t yɔ́ gʉ́ɛ́p amɨk! Ɛ́kʉ̀ kpɨ́k yi fá téé, ɛ́nchɛt nɔkɔ mmɨk ndɛ́ndɛm?’ ");
INSERT INTO kenNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nkʉ bɛtɨk wu akɛmɛ yi bɛ, ‘Ɛta, dɔ̌ ɛ́mpɛ́t ɛmbak ndǔ mmíɛ́ ɛnɛn nkwɔ. Chɔŋ ntɛ́m nnɛt ywi ngabhɛri, mfyɛ́ ntɔbhɛ́-píɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nɛ mbák ɛ́nyu kɛpɛm mmíɛ́ mbúrɛ́ ɛ́ndɨ, kɛ mbák ɛ́bhɨ́kɨ́ nyu kɛpɛm, ɔ̌kwáy bɛghati mɛ mkpɔt yɔ ngʉɛp amɨk.’” ");
INSERT INTO kenNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ɛwak nɛywɛ̌mʉɛt bo Israɛl, Yesu áre tɔŋ bo amɛm ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí ɛyap. ");
INSERT INTO kenNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ngɔrɛ́ amɔt abhak arɛ́ anɛ ɛfóŋó ɛbʉ́bʉ ɛ́kʉ́ yi ápɛ́nɛ́ ndǔ mamiɛ́ nɛku-nɛ-arat, yí kɛpɛrɛ kway bɛkɔ chak. ");
INSERT INTO kenNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu ághɔ́ nɔ́kɔ́ yi, abhɨŋɨ yí arɛm bɛ, “Mmá, nɛme ɛnɛ nɛ́may.” ");
INSERT INTO kenNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Atɔk yi nɛ amɔ. Tɛ́mte wu, anyabhɛ mmʉɛt téé, abho bɛbɨti Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mǔnti ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí ághɔ́ nɔ́kɔ́ bɛ́ Yesu akʉ mɔ́ngɔrɛ́ wu ataŋ ndǔ nywɔbhɛ́ nɛywěmʉɛt ɛnap, abé ntɨ, abho bɛrɛm nɛ ɛyɔŋ ɛtaŋataŋ ntá bo abhɛn bachi arɛ bɛ, “Sɛ́bhɔŋ manywɔp átándat ndǔ bɛ́kʉ bɛtɨk. Mmu ámbɔ́ŋ nɛme, ántwɔ́ chí amɛm manywɔp ayɔ bɛ mámbú yi. Ɛ́kɛ́pɛrɛ bhak chi ndǔ nywɔbhɛ́ nɛywěmʉɛt.” ");
INSERT INTO kenNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yesu Acha akɛmɛ yɛ yi bɛ, “Bě bǒ bɛtabha! Ntɨkɨ mmǔ ywɛka ápú kaŋari yɛ chí mpɔŋ yi, yɛ̌ chi mpɔŋɔ batu yi ándɔ́k anchyɛ yɔ́ manyiɛp ndǔ nywɔbhɛ́ nɛywěmʉɛt? ");
INSERT INTO kenNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ná nɛ ngɔrɛ́ nɛ, mmɔ́ Ábraham anɛ Satan ágwɔ́rɛ́ ndǔ mamiɛ́ nɛku nɛ arat. Ɛ́chí ɛbɛ́ptí ɛnyɨŋ bɛfɛrɛ yi ndǔ ɛsɔŋɔri ndǔ nywɔbhɛ́ nɛywěmʉɛt kɛ?” ");
INSERT INTO kenNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nɛrɛm Yesu árɛ́mɛ́ nɔ, ntíánwɔ́p akɛm bǒmpap abhi mankɛm. Kɛ bɛyǎ bo bábhɔ́ŋ maŋák bɛ yi ǎkʉ̀ mɛnyɨŋɨ́ maknkay bhɔ mɛnkɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ɛ́bhɨ́kɨ́ tat, Yesu arɛm yɛ bɛ, “Kɛfɔ Mandɛm kɛ́chí mbɔ yi? Chɔŋ njɛnti kɔ nɛ yí? ");
INSERT INTO kenNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kɛfɔ Mandɛm fá amɨk kɛ́chi mbɔ mɔ́sɛpɛm anɛ ɛ́nɔk ɛnɛ́ bábhɨŋɨ bɛ mɔ́stat, anɛ bápɨ́ amɛm nkɨ, sɛ́chák, sɛ́gó, sɛ́rɔ́p ɛnɔk ɛnɛ kɛnɛn kɛ́twɔ̀ kɛ́nte manyay ndǔ batáp ayi.” ");
INSERT INTO kenNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu apɛt arɛm bɛ, “Chɔŋ mpɛt njɛnti Kɛfɔ Mandɛm nɛ yi? ");
INSERT INTO kenNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kɛchi mbɔ yís anɛ ngɔrɛ́ ásɔ́rɛ́ achɛm nɛ nchán fláwa ɛ́rát. Mandu yís wu akʉ fláwa nkɛm amwɔt, kpát ajwi amɛm ɛnyɨŋ ɛnɛ́ yi achi arɛ́.” ");
INSERT INTO kenNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ɛnɛ́ Yesu árɔ̀ŋ Yerúsalɛm, are te ndǔ bɛtɔk bɛgho nɛ bɔ̌bɛtɔk antɔŋ nɔkɔ bho Ɛyɔŋ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mmǔ amɔt abhɛp yi bɛ, “Acha, chɔŋ Mandɛm ampɛmɛ chi bǎru bho?” Yesu arɛm ntá yap bɛ, ");
INSERT INTO kenNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Nu ka bɛ́fʉɛ́t ndǔ nyǔbhá anɛ áchí mábhɛ́rí. Nchí ghati bhe bɛ bɛyǎ bho báyàŋ chɔŋ bɛfʉɛt manchwe kɛ bápú bhɔŋ mbi. ");
INSERT INTO kenNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mbɔŋɔ́kɛt ánáŋ chɔŋ amfate antiɛp mbǐnywɔp, bǎte nɛfí mǎndɛp nɔkɔ nɛkok nɛ mǎnɨk nɔkɔ mmʉɛt bɛ, ‘Acha, nɛnɛ́ bhɛsɛ mbǐnywɔp.’ Kɛ mbɔŋɔ́kɛt ankɛmɛ chí bɛ, ‘Mbɨ́kɨ́ rɨŋɨ bhe nɛ yɛ̌ chí ɛbhak ɛnɛ bǎfú.’ ");
INSERT INTO kenNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Mǎmbo yɛ bɛrɛm bɛ, ‘Pú sɛ́chɔkɔ nyaka nɛbhʉɛt amɔt sɛ́nyíɛ́, nɛ sɛnyu nɛ wɔ? Nɛ ɔtɔ́ŋ Ɛyɔŋ Mandɛm amɛm bɛtɔk ɛbhɛsɛ?’ ");
INSERT INTO kenNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kɛ ákɛmɛ bhe chi bɛ, ‘Mbɨ́kɨ́ rɨŋɨ bhe nɛ yɛ̌ chi ɛbhak ɛnɛ bǎfú. Fǎ ká mɛ bɛsí, bě bakʉ̌ bɛbʉ́ mankɛm!’ ");
INSERT INTO kenNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Arɛ́, chɔŋ mǎndi kɛbhɔ nɛ mǎmbak ndǔ nɛnyiɛ ámɛ́n mpok bǎghɔ Ábraham nɛ Áisek nɛ Jekɔ́p nɛ barɛmɛ́ kɛpɨ̌ntɨ mankɛm chɔkɔ ndǔ nɛbhʉɛ́rɛ́ kɛfɔ̌ Mandɛm, ɛnɛ́ bátiɛ́bhɛ́ be nɛfí. ");
INSERT INTO kenNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Chɔŋ bo mámfu mbɨ nɛ nsɛm, ɛbhě awɔ́nɛm nɛ awɔ́ghɔ, mánchɔkɔ mányiɛ ɛpǎ ndǔ nɛbhʉɛ́rɛ́ kɛfɔ̌ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Dɨŋɨ́ ká bɛ, chɔŋ mbɔk bho abhɛn báchí ansɛm nɛ́nɛ mándɔp bǒmbɨ, nɛ abhɛn báchí bǒmbɨ mandɔp ansɛm.” ");
INSERT INTO kenNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ndǔ nkúbhɛ́ mpok ɛyɔ, mbɔk bǒnkwɔ Fárisi bárɔk bágháti Yesu bɛ, “Fǎ fá dɔk ɛbhak ɛ́chák. Mfɔ Hɛ́rɔd ǎyàŋ bɛ́way wɔ!” ");
INSERT INTO kenNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu akɛmɛ bhɔ bɛ, “Dɔ́k ká ghatí Hɛ́rɔd ɛsɔp ɛyɔ bɛ, ‘Chɔŋ ndɔk ambɨ bɛ́bok bɛfóŋó bɛbʉ́bɛbʉ nɛ mbú bho ɛchɔŋ nɛ mbúrɛ́, nɛ ɛ́gháká nɔkɔ manywɔp arat, nnaŋa bɛtɨk ɛbha. ");
INSERT INTO kenNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Yɛ̌ndu ɛ́chí nɔ́, mbɔŋ bɛrɔŋ Yerúsalɛm. Nchí kɔ ɛchɔŋ nɛ mbúrɛ́ nɛ ɛ́ghaka nɔkɔ ndǔ nywɔp ɛnɛn nɛjwi arat ńgaka arɛ́. Amɛm Yerúsalɛm kɛ báway nɔkɔ barɛmɛ́ kɛpɨ̌ntɨ Mandɛm.’ ");
INSERT INTO kenNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yesu akók arɛm bɛ, Eé Yerúsalɛm, bǒ Yerusalɛm! Bě bo bǎwày barɛmɛ́ kɛpɨ̌ntɨ Mandɛm, mǎntɛmti nɔkɔ nɛ batay ndu bɛ́wáy bo Mandɛm átó bɛ mángátí bhe Ɛyɔŋ ɛyi. Ndǔ bɛyǎ mpok, njáŋ bɛsɔt be mfyɛ́ amʉɛt bɛ́ mǎmbak nɛ mɛ mbɔ bɔ̌nkɔk abhɛn nnɔ nkɔk ákútí nɛbhʉɛt amɔt nɛ bɛbhap ɛbhi, kɛ bǎpú ka bɛ nkʉ nɔ! ");
INSERT INTO kenNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nɛ nɛ́nɛ, chɔŋ Mandɛm amfɛrɛ ntí ndǔ ɛkɛt ɛyɛka, ɛ́ndɔp ɛnyu ɛyɔ. Nchí ghati bhe bɛ, bǎpú pɛrɛ ghɔ́ chɔŋ mɛ́, kpátɛ mpok anɛ bǎrɛ̀m chɔŋ bɛ ‘Sɛ́mbɨ́tí mmu anɛ átwɔ̀ ndǔ nnyɛ́n Mandɛm Acha.’” ");
INSERT INTO kenNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ndǔ nywɔbhɛ́ nɛywěmʉɛt bo Israɛl nɛmɔt, Yesu arɔk mɛ́nyiɛ́ nɛnyíɛ́ amɛm ɛkɛt ɛnɛ mǔnti amɔt anɛ achi mǔnkwɔ Fárisi. Bo Fárisi bhɔ bátɛp yi amɨ́k amʉɛt bɛghɔ ndǔ yi ákʉ̀. ");
INSERT INTO kenNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mǔfú abhak bɛsí Yesu anɛ ábhɔ́ŋɔ́ nɛmě afɛmntay. ");
INSERT INTO kenNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu abhɛ́p batɔŋ ɛbhé Mandɛm nɛ bǒnkwɔ Fárisi abhɛn bachi arɛ bɛ, “Ɛbhé ɛyɛsɛ ɛ́ká bɛ mámbú mmu ndǔ nywɔbhɛ́ nɛywěmʉɛt kɛ?” ");
INSERT INTO kenNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kɛ bákɛ rɛm yɛ̌nyɨŋ. Yesu asɔt mmu wu abú yí. Arɔ yɛ yí arɔk. ");
INSERT INTO kenNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Abhɛ́p yɛ́ bhɔ bɛ, “Ntɨkɨ mmǔ ywɛka anɛ mɔ́ywi nɛ yɛ̌ mpɔŋ yi ákwɛn amɛm mbokó manyiɛp ndǔ nywɔbhɛ́ nɛywěmʉɛt kɛ yi kɛya yɛ̌ yi, yɛ̌ yɔ tɛ́mté ámfɛ́rɛ́?” ");
INSERT INTO kenNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Bɔ́ kɛkwáy bɛ́kɛmɛ Yesu yɛ̌nyɨŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ɛnɛ́ Yesu áyɨ̀ŋɨ, aghɔ́ ndǔ bǒ abhɛn mánáká ndǔ ɛpa báre yap bɛbhaká kɛnókó. Achyɛ bhɔ maniɛ bɛ, ");
INSERT INTO kenNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Mpok mánáká wɔ ndǔ ɛpǎ nɛbhay, ɔ́kɛ́ tɨŋɨ yap ɛnɔkɔ́ kɛnókó ɔ́nchɔkɔ arɛ́ mbɔnyunɛ ɛ́kwáy bɛfakari bɛ mának mmǔ anɛ acha wɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nɛ mmu anɛ ánáká bhe antwɔ́ andɛm bɛ, ‘Faté chyɛ ɛpok ɛnɛ ntá mmǔ-nɛ.’ Mbák ɛ́mfákárí ɛnyu yɔ, ɔ̌faté nɛ bɛyǎ ntíánwɔ́p bɛ́rɔŋ bɛchɔkɔ ndǔ nɛbhʉɛt anɛ ábhɨ́kɨ́ bhɔŋ yɛ̌ mandú kɛnókó. ");
INSERT INTO kenNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mpok mánáká wɔ ndǔ ɛpa, yap chi ɛnɔk ɛnɛ ɛ́bhɨ́kɨ́ bhɔŋ yɛ̌ kɛnókó, bɛ mmu anɛ ánáká ɛpa ántwɔ́, ankwáy bɛrɛm ntá yɛ bɛ, ‘Nkwǎnɛ, twɔ́ chɔkɔ ndǔ ɛnɔkɔ́ kɛnókó.’ Bǒ ɛpa bachak mángɔ bɛ mmu anɛ ánáká ɛpa ǎchyɛ̀ wɔ kɛnókó. ");
INSERT INTO kenNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Yɛ̌ agha anɛ áyòŋ mmʉɛt, Mandɛm ǎsɛ̀pti yi amɨk. Nɛ mmu anɛ ásɛ̀pti mmʉɛt amɨk, Mandɛm ǎkòsi yi amfay.” ");
INSERT INTO kenNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesu arɛm yɛ ntá mmu anɛ ábhɨ́ŋɨ́ yí ndǔ ɛpa nkwɔ bɛ, “Mpok ɔ́bhɨ́ŋɨ́ bho ndǔ nɛnyíɛ́, ɔ́kɛ́ bhɨŋɨ chi mamʉɛrɛ bhɛ, nɛ bǒnɛrɛ́kɛt ywɛ, nɛ bǒ nkáp abhɛn bachi kɛkwɔt nɛ wɔ. Mbák ɔ́mbɨ́ŋɨ́ chi mɛnyǔ bo bhɔ, bɔ́ nkwɔ́ bákway bɛbhɨŋɨ wɔ bɛ́ ɔ́nyíɛ́ nɛnyíɛ́ nɛ bhɔ nɛ ɛyɔ ɛ́mbak akap anɛ ɔ́bhɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mbák ɔ̌nàk ɛpa, bɨŋɨ́ bachɛ́bhɛ́bho, nɛ babák, nɛ bakɛm, nɛ manɛmamɨ́k. ");
INSERT INTO kenNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nɛ ɛyɔ ɛ́ndɨ ɛncha mbɔnyunɛ mɛnyǔ bǒbhɔ bápú kway bɛkɛmɛ ɛnyɨŋ ɛnɛ ɔ́kʉ́ ntá yap. Kɛ Mandɛm ǎkap wɔ mpok yi ákʉ̀ bo abhɛn bachi chak bɛsí bhi mámpɛtnsɛm ndǔ nɛpɛ́m.” ");
INSERT INTO kenNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yesu ánáŋá nɔ́kɔ́ bɛ́rɛ́m mɛnyɨŋ ɛbhɛn, mmu amɔt anɛ áchí ndǔ nɛnyíɛ́ nɛ yi, arɛm ntá yi bɛ, “Chɔŋ ɛ́ndɨ ntá yɛ̌ agha anɛ ányíɛ ɛpǎ ɛnɛ ɛ́bhak ndǔ nɛbhʉɛt Kɛfɔ Mandɛm awu amfay!” ");
INSERT INTO kenNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nɛ Yesu aghati yi bɛ, “Mmǔfu anak nyaka ɛrɛm ɛpa, abhɨŋɨ bɛyǎ bho. ");
INSERT INTO kenNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Mpok anɛ ɛpa ɛ́bhɔ́ŋɔ́ bɛbho ákwáy nɔ́kɔ́, ató mɔ̌bɛtok ywi bɛ andɔk angati bo abhɛn yi anaka bɛ, ‘Twɔ́ ká, mánaŋ batoŋti yɛ̌ntɨkɨ ɛnyɨŋ.’ ");
INSERT INTO kenNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Arɔk aghati bhɔ́, kɛ yɛ̌ntɨkɨ mmu wap arɔbhɛ ghati yi chí bɛ ndak akɛm yi. Anɛ mbɨ arɛm bɛ ‘Nku nkɨ nɛ mbɔŋ bɛ́rɔŋ bɛyɨŋɨ wu. Nɨkmʉɛt, ghatí ɛtayɛ bɛ ákɛ́ bentɨ.’ ");
INSERT INTO kenNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Achák arɛm bɛ, ‘Nku mpɔŋ byó ɛnɛ ɛ́kwàŋ bakɨ. Nchí yaŋ ndɔ́k ngɔ́ bɛtɨk ɛbhɛn yɔ ɛ́kwày bɛkʉ. Nɨkmʉɛ́t. Ghatí Ɛtayɛ bɛ́ ákɛ́ bentɨ.’ ");
INSERT INTO kenNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Anɛfú arɛm bɛ, ‘Nɛ́nɛ kɛ mbáy ngɔrɛ́. Mpú kwáy yɛ bɛ́twɔ.’ ");
INSERT INTO kenNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Mmɔ̌ bɛtok wu arɔk aghati ɛtayi mɛnyɨŋ ɛbhɛn bǒbhɔ bárɛmɛ. Mbɔŋɔ́kɛt abéntɨ. Aghati mɔ̌bɛtok yi wu bɛ, ‘Fú, dɔ́k áyák ndǔ yɛ̌ntɨkɨ mbay anɛ áchí ɛtɔk nɛ yɛ̌ntɨkɨ nɛbhʉɛ́t anɛ bo báchí arɛ sɔt bachɛ́bhɛ́bho twɔ ndǔ ɛpa nɛ bhɔ. Twɔ́ nɛ babák nɛ bakɛm nɛ manɛ́mámɨk.’ ");
INSERT INTO kenNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mmɔ̌ bɛtok arɔk atwɔ́, arɛm ntá yi bɛ, ‘Ɛta, nkʉ ɛnyɨŋ ɛnɛ́ ɔ́rɛ́mɛ́ kɛ ɛkɛt ɛ́bhɨ́kɨ́ re jwi.’ ");
INSERT INTO kenNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ɛtayi arɛm bɛ, nɛ́nɛ ‘Fú, dɔ́k, ɛtɔk ndǔ babhǐ agho nɛ ndǔ babhǐ bɛbhɨ. Fíɛ́ bɛtaŋ bɛ́ bo mántwɔ́ bɛ́ ɛkɛt ɛpa ɛ́njwi. ");
INSERT INTO kenNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Dɨŋɨ́ ká bɛ, yɛ̌ mmu amɔt ndǔ bo abhɛn njambɨ kɛ bɔ́ kɛtwɔ́, apú kwáy bɛ́ghókóti ɛnyɨŋ ndǔ ɛpa ɛya-nɛ.’” ");
INSERT INTO kenNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ngɛ́mtay bho báré kɔ nɛ Yesu. Ayibhiri mmʉɛ́t arɛm ntá yap bɛ, ");
INSERT INTO kenNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Mbák mmu áyàŋ bɛ́bhak nɛ mɛ apú kwáy bɛbhák nkoŋo wa mbák abhɨ́kɨ́ kɔŋ mɛ ánchá ɛtayi nɛ máyi, nɛ ngɔrɛ́ ywi, nɛ bɔ̌bhi, nɛ, bɔ̌mayi abhɛn babhakanɛm nɛ abhɛn baghɔrɛ́ nɛ ankɔŋ mɛ ancha yɛ chí mmʉɛrɛ́ yi. ");
INSERT INTO kenNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yɛ̌ agha anɛ ábhɨ́kɨ́ ka bɛpɔkɔ ɛyi ɛko ankoŋo mɛ apú kway bɛbhak nkoŋo wa. ");
INSERT INTO kenNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Mbák mmu ywɛka ǎyàŋ bɛte ɛkɛt ɛgho, pú ǎyambɨ anchɔkɔ amɨk ankay, angɔ mbák nkáp anɛ yi ábhɔ́ŋɔ́ akway anɛ yi áte ɛkɛt anaŋa? ");
INSERT INTO kenNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mbák abhɨ́kɨ́ kʉ nɔ, ǎkwáy bɛghoko nɛbhʉ́ɛ́rɛ́kɛt kɛ yí kɛte ɛkɛt ánáŋá, nɛ bo abhɛn bághɔ́ yɔ mámbo bɛ́wáy yi bɛ, ");
INSERT INTO kenNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Anɛ abho bɛte ɛkɛt kɛ ɛcha yi mɛnaŋa.’ ");
INSERT INTO kenNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Nɛ sɛ́nsɔt bɛ mfɔ amɔt abhɔ̌ŋ batɛmɛ́ nɛnu nka byo (10, 000). Apɛrɛ́ rɔŋ mɛnu nɛ mfɔ anɛ ábhɔ́ŋɔ́ batɛmɛ́ nɛnu nka ɛsa, (20, 000) ǎkʉ yi? Pú ǎyambɨ anchɔkɔ, ankaysi sayri, mbák ǎkway mɛnu nɛ mfɔ wu? ");
INSERT INTO kenNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nɛ mbák ángɔ́ bɛ́ bɛtaŋ ɛbhi bɛ́bhɨ́kɨ́ kway, ǎto bo ntá mfɔ wu mpok batɛmɛ́ nɛnu bhi babhʉɛt nɛkɔ nɛsiɛ bɛ mánsókórí ɛnyu ɛnɛ́ bápú nu nɛ batɨ.” ");
INSERT INTO kenNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yesu arɛm yɛ bɛ, “Ɛ́chí ɛnyumɔt nɛ be mankɛm. Mbák mmu abhɨ́kɨ́ bhɔŋ ntɨ bɛrɔ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ yi ábhɔ́ŋɔ́, apú kway bɛbhak nkoŋo wa.” ");
INSERT INTO kenNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yesu arɛm bɛ, “Ngáŋ áchí ɛrɨ́tí ɛnyɨŋ. Kɛ mbák ngáŋ ábhɨ́kɨ́ pɛrɛ bhɔŋ manyɨŋti mi, ná bákway bɛkʉ wu ampɛt ambak ɛrɨ́tí ngáŋ? ");
INSERT INTO kenNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ɛnyǔ ngáŋ wu ápú pɛrɛ rɨ́ ndǔ yɛ̌nyɨŋ. Ápú rɨ amɨk nɛ apu rɨ yɛ̌ ndu bɛfyɛ ndu ntó-takɔ anɛ báyàŋ ámpɔ́ɔ́ ánchyɛ ntɔbhɛ́-píɔ. Báto wu to. Mmǔ anɛ áyàŋ bɛghok ántá batu angok sayri.” ");
INSERT INTO kenNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Mpokófu, babhɛbhɛ́ nkábhɛ́nti nɛ bakʉ̌ bɛbʉ́ bachak báré kap Yesu ndu bɛghok mɛnyɨŋ ɛbhɛn yí átɔ̀ŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Bǒnkwɔ Fárisi nɛ batɔŋ ɛbhé Mandɛm bábho mɛ́nywínti bɛ, “Mɔ́nkwǎnɛ ǎsyɛpti bǒ bɛbʉ́, nɛ ǎnyiɛ tɛ nɛnyíɛ́ nɛ bhɔ.” ");
INSERT INTO kenNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ɛ́kʉ Yesu atɛ́m bɔ́ nɛkay ɛnɛn bɛ: ");
INSERT INTO kenNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Sɛ́nsɔ́t bɛ mmǔ ywɛka amɔt abhɔŋ bághɔ́ŋɔmɛ́n bɛsa bɛtay. Mbák amɔt anɛm ɛbhɨ, ǎkʉ̀ yi? Pú ǎrɔ̀ anɛ́ bɛsa mɛnwi nsɛm nɛkʉ nɛ anwi, andɔk bɛyaŋ awu ámɔt kpát ambɔŋ wu? ");
INSERT INTO kenNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nɛ mbák aghɔ wu, ǎpɔkɔ anyaŋa mankɨ nɛ maŋák, ");
INSERT INTO kenNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","nɛ mpok anɛ yi ágháká anywɔ́p, ǎbhɨŋɨ mamʉɛrɛ bhi nɛ bakokosi bhi, angati bhɔ bɛ, ‘Ŋák ká nɛ mɛ mbɔnyunɛ́, mbɔ̌ŋ ághɔ́ŋɔmɛn wa anɛ ánɛ́mɛ́ nyaka.’” ");
INSERT INTO kenNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yesu arɛm yɛ bɛ, “Nchí ghati bhe bɛ nkúbhɛ́ ɛnyu yɔ kɛ̌ maŋák ǎbhák amfay ntá Mandɛm nɛ bɔángɛl ɛ̌ti mmǔ bɛbʉ́ amɔt anɛ átɨ́kɨ́nsɛm ndǔ bɛbʉ́ bhi ɛncha bo bɛsa mɛnwi nsɛm nɛku nɛ anwi abhɛn bákáysi bɛ bachi chak bɛsí Mandɛm nɛ ntí apú anɛ bɔ́ bátɨ̀k nsɛm ndǔ bɛbʉ́ bhap.” ");
INSERT INTO kenNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesu apɛt arɛm bɛ, “Sɛ́nsɔ́t bɛ ngɔrɛ́ amɔt abhɔŋ bɛbhɔ́kɔ́ nkáp byó. Mbák ɛbhɔk ɛ́mɔt ɛ́nɛm, ǎkʉ yi? Pú ǎdurɛ ɛrɔ́ŋɔ́, ansɔt kɛtɨ́ŋɨ́ anyɔ ɛkɛt ɛnkɛm, ambyo sayri mbǎnkɛm kpatɛ angɔ́ yɔ́? ");
INSERT INTO kenNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nɛ mpok ághɔ́ yɔ ǎbhɨŋɨ mamʉɛrɛ nɛ bakokosi bhi, angati bhɔ bɛ ‘Ŋák ká nɛ mɛ mbɔnyunɛ ngɔ̌ ɛbhɔ́kɔ́ nkap ɛnɛ ɛnɛmɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yesu arɛm yɛ bɛ nchí ghati bhe bɛ bɔángɛl Mandɛm bábhɔŋ maŋák ɛ̌ti mmǔ bɛbʉ́ amɔt anɛ átɨ́kɨ́nsɛm ndǔ bɛbʉ́ ɛbhi.” ");
INSERT INTO kenNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ndu bɛrɔŋ ambɨ Yesu arɛm bɛ, “Mmǔfú abhɔ̌ŋ nyaka bɔ̌ babhakanɛm bati apay. ");
INSERT INTO kenNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ɛwak ɛ́mɔ́t, anɛ mɔ́nkwɛn arɛm ntá ɛtayi bɛ, ‘Ɛta, chyɛ awa ákɔ́rɛ́ mɛnyɨŋ bɛ́.’ Ɛtayap akɔrɛ mɛnyɨŋ ɛbhi ntá yap bati apay. ");
INSERT INTO kenNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ansɛm mpǎy manywɔp, anɛ mɔ́nkwɛn anyokoti mɛnyɨŋ ɛbhi apɔkɔ arɔk ɛtɔk ɛ́chák nɛkɔ nɛsiɛ. Arɛ́ achɔŋti mɛnyɨŋ ɛbhi mɛnkɛm ndu mɛ́nyiɛ ɛpɔ̌ nɛpɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Áchɔ́ŋtí nɔ́kɔ́ yɛ̌ntɨkɨ ɛnyɨŋ, ɛrɛmɛ́ nsay ɛ́kwɛ́n ɛtɔk ɛyɔ ɛnkɛm, arɔp amɔ apay. ");
INSERT INTO kenNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ɛkʉ arɔk, abhat mmʉɛt nɛ mmǔ ɛtɔk ɛyɔ amɔt. Ató yi bɛ ándɔ́k, áne nɔ́kɔ́ bakók bhi amɛm nkɨ ywi. ");
INSERT INTO kenNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Are yáŋ mɛnyiɛ nɛnyiɛ́ bakók, kɛ yɛ̌ mmu kɛchyɛ yi ɛnyɨŋ mɛnyiɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kɛ ásɔ́rɛ́ nɔ́kɔ́ nkaysi nɛ mmʉɛt yi arɛm bɛ, ‘Ghɔ́ ká mɛ-á, bakʉ̌ bɛtɨk ɛtaya báchí awu mányìɛ̀ nɛnyíɛ́ mmʉɛt ngɔkngɔk, mándɔ nɔkɔ mbɔk, nsay átwɔ way mɛ fá! ");
INSERT INTO kenNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Chɔŋ mfá mpɛtnsɛm ntá Ɛtaya ngati yi bɛ, “Ɛta, nkʉ Mandɛm bɛbʉ́, nɛ nkʉ wɔ bɛbʉ́. ");
INSERT INTO kenNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mbɨ́kɨ́ pɛrɛ kway mmu anɛ bábhɨŋɨ bɛ mɔ́ywɛ. Sɔt mɛ chí mbɔ nkʉbɛtɨk ywɛ̌ amɔt.”’ ");
INSERT INTO kenNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Afate abho bɛpɛtnsɛm ntá ɛtayi. Kɛ ɛnɛ́ yi abhʉɛt nɛkɔ nɛsiɛ, chi aghɔ́ yi ndu átwɔ̀. Ntínso nɛ́kɛ́m yi, afate, ajɛt arɔk akɛ́m yi abhɛnɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mmɔ arɛm ntá yi bɛ, ‘Ɛta, nkʉ Mandɛm bɛbʉ́, nɛ nkʉ wɔ bɛbʉ́, nɛ mbɨ́kɨ́ pɛrɛ kwáy mmu anɛ bábhɨŋɨ bɛ mɔ́ywɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kɛ chi aghati bɔ̌-bɛtok bhi bɛ, ‘Twɔ́ ká ayak nɛ ɛ́wɛt ɛnɛ ɛrɨ́ ɛ́chá mǎnsɔbhɛri yi nɛ yɔ, mǎmfyɛ́ yi sɛnɔŋ ndǔ sɛnɔŋáwɔ, nɛ nkwɔbhánya bɛkak. ");
INSERT INTO kenNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Dɔ́k yɛ ká mǎnkɛm mɔ́sɛnɛ́ mpɔŋ mǎngwáy mǎnkʉ nɛnyíɛ́ bɛ sɛ́nyíɛ́ sɛnkʉ maŋák, ");
INSERT INTO kenNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","mbɔnyunɛ mɔ́wa-nɛ agǔ nyaka, kɛ nɛ̌nɛ apɛt achi nɛpɛ́m. Anɛm nyaka kɛ mpɛt ngɔ yí.’ Afɔ̌ kɛ̌ ɛpa ɛ́bhó. ");
INSERT INTO kenNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Mpǒk yɔ, mɔ́ywi anɛ nsénsí abhak ɛbhɨ. Ágháká nɔ́kɔ́ kɛkwɔ́t nɛ ɛkɛt ndǔ yi afu ɛbhɨ ápɛtnsɛm anywɔ́p, aghók ndǔ nkɛnkwɛt nɛ nɛbhɛ́n nɛ́chí anywɔ́p. ");
INSERT INTO kenNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Abhɨŋɨ mmɔ̌bɛtok amɔt abhɛ́p yí bɛ ‘Ntɨkɨ ndak áchí fá ɛchɔŋ?’ ");
INSERT INTO kenNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mmɔ̌ bɛtok wu aghati yí bɛ ‘Mɔmáyɛ apɛtnsɛm, kɛ ɛtayɛ áway mɔ́sɛnɛ́ mpɔŋ mbɔnyunɛ́ apɛtnsɛm dok.’ ");
INSERT INTO kenNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mɔ̌mbɨ wu abéntɨ, anisi bɛchwe anywɔ́p. Chi afú arɔk are anɨk yí mmʉɛt bɛ anchwe anywɔ́p. ");
INSERT INTO kenNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kɛ akɛmɛ ɛtayi chi bɛ, ‘Yɨŋɨ, bɛyǎ mamiɛ́ anɛ ankɛm, nchí fá nɛ wɔ, nkʉ nɔkɔ bɛtɨk ntá yɛ mbɔ nsɛm. Yɛ̌ ɔrɛm bɛ yi, nkʉ kʉ, nkɛ taŋ ntí. Yɛ̌ nɔ, ɔbhɨ́kɨ́ re chyɛ mɛ yɛ̌ chi mɔ́mɛn bɛ́ nkʉ mǎŋák nɛ mamʉɛrɛ bha. ");
INSERT INTO kenNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kɛ mpok mɔ́ywɛ-nɛ mmu árɔ́ŋɔ́ ányíɛ́ mɛnyɨŋ ɛbhɛ nɛ baghɔrɛ́-nɛkɔ ápɛ́rɛ́nsɛm, ɔwǎy yi ɛsɛnɛ́mpɔŋ!’ ");
INSERT INTO kenNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Chi abhɨŋɨ yɛ yí arɛm bɛ, ‘Mɔ́wa, ɔchí fá nɛ mɛ mpǒk nkɛm, nɛ yɛ̌ntɨkɨ ɛnyɨŋ ɛya, chí ɛyɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ɛ́chí mbʉ ɛrɨ́tí ɛnyɨŋ bɛ sɛnkɛm ɛpa ɛ́nɛ, sɛ́nkʉ́ maŋák, mbɔnyunɛ mɔmáyɛ nɛ agǔ nyaka kɛ nɛ́nɛ achi nɛpɛ́m. Anɛm nyaka kɛ sɛ́pɛt sɛghɔ yi.’” ");
INSERT INTO kenNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu apɛt arɛm ntá bakoŋo bhi bɛ, “Mǔnkáp amɔt achi nyaka. Abhɔ́ŋ mǔbɛtɨk anɛ ákɛm mɛnyɨŋ ɛbhi mɛnkɛm. Bo bágháti yi bɛ, mmʉ̌ bɛtɨk ywí wu ǎchɔŋti nkáp ywi. ");
INSERT INTO kenNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Abhɨŋɨ mǔbɛtɨk wu arɛm bɛ ‘Ntɨkɨ ndak nɛ́ ngoko ɛ̌ti yɛ? Dɔ́k twɔ́ mɛ́ nɛ bɛkáti ɛbhɛn ɔ́sɨ́ŋɨ́ yɛ̌ntɨkɨ ɛnyɨŋ ɛya arɛ́. Ɔbhɨ́kɨ́ pɛrɛ kwáy bɛ́kɛm mɛnyɨŋ ɛbha.’ ");
INSERT INTO kenNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Mmǔ bɛtɨk wu arɛm nɛ mmʉɛt yi bɛ, ‘Chɔŋ nkʉ yi? Mmʉɛt ápú mɛ́ bɛ́kʉ bɛtɨk bɛtaŋ bɛtaŋ, nɛ ntí ánwɔ̀p mɛ mɛnɨŋɨ mɛnɨŋɨ. ");
INSERT INTO kenNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ɛ́bhɨ́kɨ́ tat, arɛm bɛ, nɛ́nɛ ndɨ́ŋɨ́ ɛnyɨŋ ɛnɛ nchí kʉ bɛ́ bo mánsíɛ́ptí mɛ amɛm bɛkɛt ɛbhap mpok báfɛrɛ mɛ ndǔ bɛtɨk.’ ");
INSERT INTO kenNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Abhɨŋɨ bǒ barɛm abhɛn chi-bɛtɨk ywi amɔt amɔt. Abhɛ́p anɛ mbɨ bɛ, ‘Yi ɔ́kɛ̀m chi-bɛtɨk wa?’ ");
INSERT INTO kenNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Akɛmɛ yi bɛ ‘Babhaŋá bawɛt bɛsa bɛtay.’ Mmǔ bɛtɨk wu aghati yi bɛ, ‘Ghɔ́ ɛkati barɛm ɛyɛ, sɔt, wupsi, sɨŋ babhaŋ bɛsa bɛpay nsɛm byo ndǔ ɛnɛ́ ɛkɔ nɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Abhɛ́p yɛ anɛfú bɛ, ‘Ɔ̌kɛ́m ná?’ Akɛmɛ bɛ, ‘Bɛbhǎ nchwi bɛsa bɛtay.’ Mmǔ bɛtɨk wu achyɛ yí ɛkati barɛm arɛm bɛ, ‘Sɔt, wupsí sɨ́ŋ bɛbhǎ nchwi bɛsa mɛnwi ndǔ ɛnɛ ɛkɔ.’ ");
INSERT INTO kenNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Chi-bɛtɨk ywi ághɔ́ nɔ́kɔ́ bɛ́ arwɔ̌ yi ɛnyuyɔ, akaka yí bɛ́ yi abhɔŋ kɛ́ŋwáŋ bɛ́káysi ndak. Ɛchi tɛtɛp bɛ bǒ mmɨkɨ nɛ bákʉ̀ mɛnyɨŋ ɛbhap nɛ kɛŋwaŋ bácha ɛnyǔ bo Mandɛm bákʉ̀ ɛbhap.” ");
INSERT INTO kenNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesu arɛm bɛ, “Kɛfɔ̌ bakáp nɛ mɛnyɨŋɨ́ mmɨk kɛ́kway bɛ́twɔ nɛ bɛbɛ́pti mɛnyɨŋ kɛ nchí ghati bhe bɛ, mǎnsɔ́t kɔ mǎnkʉ bo mámbák mamʉɛrɛ bhɛka bɛ́ mpok kɛ́máy, Mandɛm ánsɔt bhe ndǔ bɛchɔ́kɔ́ bhi ɛbhɛn bɛ́bhɨ́kɨ́ bhɔŋ ngwɛnti. ");
INSERT INTO kenNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mmǔ anɛ ábhʉ̀rɛ bariɛp ndǔ bǎru mɛnyɨŋ, ǎbhʉ̀rɛ bariɛp mi ndǔ bɛyǎ mɛnyɨŋ. Nɛ mmu anɛ ápú bhʉɛrɛ bariɛp ndǔ bǎru mɛnyɨŋ, apú bhʉɛrɛ bariɛp ndǔ bɛyǎ mɛnyɨŋ nkwɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mbák bǎbhɨ́kɨ́ tɔŋ bɛ bǎbhʉ̀rɛ bariɛp ndǔ baraká nkáp nɛ mɛnyɨŋɨ́ mmɨk, agha ákway bɛsɨkɨ ntɨ nɛ be amfyɛ kɛfɔ̌ bakáp ɛkɛn kɛbhɨkɨ bhɔŋ ngwɛnti amɔ yɛka? ");
INSERT INTO kenNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mbák bǎpú bhʉɛrɛ bariɛp ndǔ mɛnyɨŋ ɛbhɛn báfyɛ́ amɔ yɛka, yɛ̌ mmu apú kway bɛchyɛ bhe mɛnyɨŋ ɛbhɛn bɛchi amfay? ");
INSERT INTO kenNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Yɛ̌ mɔbɛtok apu kwáy bɛtok bachi batí apay ndɔŋ amɔt. Mbák ámbɔ́ŋ bachi bapay, ǎkɔŋ amɔt ancha anɛfú, mbák ɛ́pú nɔ́, ǎchyɛ kɛnókó ntá amɔt, ambyak anɛfu. Mmu apu kwáy bɛtok Mandɛm antok nɔkɔ mɛnyɨŋ mmɨk.” ");
INSERT INTO kenNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Yesu árɛ́m nɔ́kɔ́ mɛnyɨŋ ɛbhɛn, nkwɔ Fárisi bo bákɔ́ŋɔ́ nkáp tontó báre way yi. ");
INSERT INTO kenNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesu aghati bɔ bɛ, “Bě bǎchí bo abhɛn bátɔ̀ŋ mmʉɛt bɛ bǎchi chak bɛsí bho. Kɛ Mandɛm arɨŋɨ batɨ yɛka. Ɛnyɨŋ ɛnɛ́ bo báyɨ̀ŋɨ bɛ́ ɛbhɔŋ mɛnwɔp chí ɛnyɨŋ ɛnɛ Mandɛm ápàp.” ");
INSERT INTO kenNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Yesu apɛt arɛm bɛ, “Jɔ̌n Njwiti ápɛ́rɛ twɔ, bo bátɔ̀ŋ nyaka chi mɛnyɨŋ ɛbhɛn bɛchi amɛm basɨŋ Moses nɛ amɛn barɛmɛ́ kɛpɨ̌ntɨ. Basɨŋɨ́ mɔ kɛ̌ bo bákòŋo nyaka. Jɔ̌n átwɔ́ nɔ́kɔ́, bábho bɛghati bho Mbok Ndɨ́ndɨ́ ɛ̌ti Kɛfɔ Mandɛm, nɛ yɛ̌ntɨkɨ mmu are nu bɛchwe arɛ́ nɛ bɛtaŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kɛ ɛchi wɨkɨrɨk bɛ mfay ámfʉ́ɛ́t, mmɨk amfʉɛt, ɛcha bɛ mandú ɛnyɨŋ ndǔ basɨŋ amɛn Moses nɛ amɛn barɛmɛ́ kɛpɨ̌ntɨ ánɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ɛchi yɛ bɛ, yɛ̌ntɨkɨ mmu anɛ árɔ́ ngɔrɛ́ ywi ndǔ nɛbhay, akwɛ̌n bɛrwɔp. Nɛ mmǔ anɛ ábháy ngɔrɛ́ anɛ nnɛ́m árɔ́ ndǔ nɛbhay, akwɛ̌n nkwɔ bɛrwɔp.” ");
INSERT INTO kenNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesu atɛ́m nɛkay ɛnɛ́n bɛ, “Mǔnkáp amɔt achi nyaka anɛ afyɛ́ ndɛn bɛyǎ nkáp, anyiɛ nɔkɔ ɛpa yɛ̌ntɨkɨ nywɔp. ");
INSERT INTO kenNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nchɛ́bhɛ́mu amɔt achí nyaka. Aka nyɛ́n bɛ Lásárɔs. Báre bhʉrɛ yi ndǔ nyǔbha mǔnkáp wu mpoknkɛm. Mmʉɛt yi ajwi nɛ bɛfʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Abhɔ́ŋ ɛkwak mɛnyiɛ yɛ̌ chi bɛchɔkɔti ɛbhɛn bɛ́kwɛ̀nti amɨk mpok mǔnkáp anyiɛ nɛnyiɛ. Ɛnyɨŋ ɛchak abhak bɛ mmú mǔnkáp ɛ́ré rɔŋ ɛ́nɨŋɨ nɔkɔ bɛfʉɛt ɛbhi. ");
INSERT INTO kenNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ansɛm mpok, nchɛ́bhɛ́mú wu agú, bɔángɛl Mandɛm basɔt yi barɔk amfay, bákʉ yi achɔkɔ kɛkwɔt nɛ Ábraham. Mǔnkáp agú nkwɔ, bábhɛ́mɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Arɔk ɛtɔkɔ́ bawú, abhak ndǔ bɛyǎ ɛsɔŋɔri arɛ́. Áyóŋ nɔ́kɔ́ amɨ́k amfay, aghɔ́ Ábraham nɛkɔ nɛsiɛ nɛ Lásárɔs abhak yí nɛpaká mmʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Mǔnkáp wu akók yɛ arɛm bɛ, ‘Ɛta, Ábraham, ghɔ mɛ ntínso. Tó Lásárɔs ántáp sɛnɔŋ awɔ ndǔ manyiɛp antwɔ ankwɛnɛ mɛ ntɨ mandú. Nchí ndǔ bɛyǎ ɛsɔŋɔri amɛm ngó-nɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Kɛ Ábraham akɛmɛ yi chi bɛ, ‘Mɔ́wa, kɛ́ ghɔkɔntɨk bɛ mpok ɔchí awu amɨk, ɔbhɔ̌ŋ nyaka bɛrɨ́tí mɛnyɨŋ ɛnɛ́ Lásárɔs ábhɔ́ŋɔ́ chí bɛbɛ́ptí mɛnyɨŋ. Kɛ nɛ́nɛ yí achí sayri fá ɛnɛ́ wɔ ɔ́chí ndǔ nɛnyíɛ́ ámɛ́n. ");
INSERT INTO kenNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Dɨŋɨ́ nkwɔ bɛ, ɛrɛmɛ́ nɛpi nɛ́kɔrɛ bhɛsɛ ɛnyunɛ́, yɛ̌ mmu apu kway bɛfu fá ampe antwɔ ntá yɛka; nɛ yɛ̌ mmu apú kway bɛrɔ ɛbhě yɛká, ampé ántwɔ́ fá ntá yɛsɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Mǔnkáp wu arɛm bɛ, ‘Ɛta Ábraham, nɨkmʉɛt tó yɛ Lásárɔs ndǔ nnɛrɛ́kɛt ɛtaya. ");
INSERT INTO kenNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Mbɔ̌ŋ bɔ̌maya batí atay. Ghatí yi ándɔ́k ánsɛmti bhɔ bɛ bákɛ́ twɔ nkwɔ́ ndǔ nɛbhʉɛ́t nɛnyiɛ́ ámɛ́n anɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Kɛ Ábraham akɛmɛ yi chí bɛ ‘Bɔ̌mayɛ babhɔŋ basɨŋ Moses nɛ amɛn barɛmɛ́ kɛpɨ̌ntɨ. Mángók mɛnyɨŋ ɛbhɛn basɨŋɨ́ mɔ ághàti bhɔ.’ ");
INSERT INTO kenNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Arɛm ntá Ábraham bɛ, ‘Ǎe Ɛta Ábraham, ɛyɔ ɛ́bhɨ́kɨ́ kway. Mbák mmu amɔt anɛ ánáŋá ágú ámpɛ́tnsɛm angati bhɔ, chɔŋ mántɨknsɛm ndǔ bɛbʉ́ bhap.’ ");
INSERT INTO kenNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ábraham aghati yɛ yi bɛ, ‘Mbák bɔ̌mayɛ babhɨkɨ ka bɛghok mɛnyɨŋ ɛbhɛn bɛchi amɛm basɨŋ Moses nɛ amɛn barɛmɛ́ kɛpɨ̌ntɨ, nɔ bápú kway bɛghok yɛ chi mmu anɛ ánáŋá ágú kɛ ǎpɛtnsɛm ntá yap.’” ");
INSERT INTO kenNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu abho bɛ́gháti bakoŋo bhi bɛ, “Mamɔ anɛ átɛ̀n bo ndǔ bɛbʉ́ ápú nɔ́k bɛ́twɔ. Kɛ chɔŋ ɛ́mbɛp ɛ́ncha ntá mmú anɛ ákʉ̀ mamɔ ántwɔ́ ntá bho! ");
INSERT INTO kenNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ɛ́chí sáyrí ntá mmu wu bɛ mánsɔt ntay nɛgho mánsɛt ɛmɨ ɛyi, mámɛsɛ yí amɛm manyu ɛcha yi bɛbhak nɛpɛ́m ankʉ mmǔ amɔt anɛ ánókó Mandɛm ankwɛn ndǔ bɛbʉ́. ");
INSERT INTO kenNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Sɔt ka mpok! Mbák mɔ́mayɛ ánkʉ wɔ bɛbʉ́, ghatí yi bɛ́ ándɔ́ ɛpɨŋ ɛyɔ. Mbák atɨknsɛm ndǔ bɛbʉ́ bhi, foŋorí yi. ");
INSERT INTO kenNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nɛ mbák akʉ wɔ bɛbʉ́ ndɔŋ tándrámɔt ndǔ ɛwak nɛ yɛ̌ntɨkɨ ndɔŋ antwɔ́, anɨk wɔ mmʉɛt bɛ, ‘Ɛta foŋorí mɛ́,’ ɔbhɔŋ bɛ́fóŋóri yi.” ");
INSERT INTO kenNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Bǒnto Yesu barɛm ntá yi bɛ, “Acha, kwak bɛ́ nɛka ɛnɛsɛ nɛ́ntáŋ nɛndɔk ambɨ.” ");
INSERT INTO kenNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Acha akɛmɛ bhɔ bɛ, “Mbɔ bǎbhɔŋ nɛka nɛ Mandɛm ɛnɛ́n nɛ́chí yɛ̌ chi nɨ́ŋɨ́nɨ́ŋɨ́ mbɔ mɔ́sɛpɛm anɛ ɛnɔk ɛ́nɛ bábhɨŋɨ bɛ *mɔ́stat, mbʉ bǎkway bɛ́ghati ɛnɔk ɛnɛ bɛ, ‘Fǎ fá nɛ bakaŋ dɔ́k tě awu amɛm manyu’, nɛ yɔ́ ɛ́ngok be.” ");
INSERT INTO kenNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yesu arɔk ambɨ bɛtɔŋ. Arɛm bɛ, “Sɛ́nsɔ́t bɛ mmǔ ywɛka amɔt abhɔŋ mǔbɛtɨk anɛ áchí ɛbhɨ ákʉ̀ bɛtɨk, yɛ̌ chí ndu bɛbhábhɛri bághɔ́ŋɔmɛ́n, yɛ̌ chi ndu bɛ́kwáŋ mbaŋ. Mbák afǔ ɛbhɨ apɛtnsɛm anywɔ́p, wɔ chi-bɛtɨk ywi ɔ̌ghati yi bɛ, ‘Twɔ́ chɔkɔ́ amɨk nyiɛ nɛnyíɛ́’? ");
INSERT INTO kenNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Pú ɔ̌ghati yi chi bɛ, ‘Dɔ́k wupsí ndɛn, kʉ nɛnyíɛ́ twɔ nɛ nɔ. Nnáŋ nnyiɛ́ nnáŋá, ɔ́nsɔt ɛnɛ ɔnyiɛ’? ");
INSERT INTO kenNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Mbák akʉ mbɔ ɛnyu ɔ́ghátí yi ɔpú kwáy bɛkaka yi bɛ, ‘Ɔkʉ a’ mbɔnyunɛ akʉ chí bɛtɨk ɛbhɛn yi ábhɔ́ŋɔ́ bɛkʉ. ");
INSERT INTO kenNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ɛ́mbák yɛ ɛnyumɔt nɛ bhe. Mǎnáŋ mǎnkʉ bɛtɨk mɛnkɛm ɛbhɛn báchyɛ́ bhe, bǎbhɔŋ bɛrɛm chi bɛ, ‘Sɛ́chí chí bǒ bɛtok, yɛ̌ ndak áchák ápú. Sɛ́kʉ́ chí ɛnyɨŋ ɛnɛ sɛ́bhɔ́ŋɔ́ bɛ́kʉ.’” ");
INSERT INTO kenNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ndu Yesu ákɔ̀ bɛrɔŋ Yerúsalɛm, are fʉɛ́t ndǔ ndyɛrɛbhɨ Samária nɛ Gálili. ");
INSERT INTO kenNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nɛchwe áchwè amɛm mɔ́tɔk amɔt, bǒ ɛbhaŋákwa bati byo bághɔ́ yi ndu átwɔ̀, báte, kɛrɔ́ŋ kɛ́kwɔ́t nɛ yí. ");
INSERT INTO kenNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Bábho bɛbɨk mándɛmɛ nɔkɔ bɛ́, “Yesu, Ɛta, ghɔ́ bhɛsɛ ntínso.” ");
INSERT INTO kenNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu ághɔ́ nɔ́kɔ́ bhɔ, aghati bhɔ bɛ, “Dɔ́k ká ntá bachiǎkap Mandɛm bɛ mánchák bhe.” Ɛnɛ́ bárɔ̀ŋ, ɛbhaŋákwa yap ɛ́may. ");
INSERT INTO kenNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Mmu wap amɔt ághɔ́ nɔ́kɔ́ bɛ́ ataŋ, abho bɛpɛtnsɛm ntá Yesu ambɨti nɔkɔ Mandɛm nɛ ɛyɔŋ amfay. ");
INSERT INTO kenNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ágháká nɔ́kɔ́ bɛsí Yesu, akwɛ́n yi bɛkak ankaka nɔkɔ yi. Ɛ́fákárí bɛ mmǔ wu achí chi mmu Samária. ");
INSERT INTO kenNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu arɛm yɛ bɛ, “Pú bǒ bati byo kɛ mbúú? Abhɛ́nɛ́fú bati nɛ́nɛ́namɔt báchí fá? ");
INSERT INTO kenNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ndiɛrɛ kɛnkɔ̌ nɛ aywǐntí kɛ ápɛ́rɛ́nsɛm bɛbɨti Mandɛm-ɛ́?” ");
INSERT INTO kenNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yesu aghati yɛ mmu wu bɛ, “Faté, dɔ́k ɛbhak ɛyɛ. Nɛka ɛnɛ́n ɔbhɔŋɔ nɛ mɛ nɛ́kʉ ɔtaŋ.” ");
INSERT INTO kenNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nywɔp nɛ́mɔt, mbɔk bǒnkwɔ Fárisi bábhɛp Yesu bɛ, “Ntɨ́kɨ́ mpok Mandɛm ábhák nɛ bo fá amɨk mbɔ Mfɔ wap?” Akɛmɛ bhɔ bɛ, “Yɛ̌ ɛrɨŋ ɛ́pú ɛnɛ ɛ́tɔ̀ŋ bɛ Mandɛm abho bɛ́kɛm bo mbɔ Mfɔ wap. ");
INSERT INTO kenNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nɛ yɛ̌ mmú apú kwáy bɛrɛm yɛ̌ bɛ, ‘Ghɔ́ ká Mandɛm fa nɛ bho mbɔ Mfɔ wap!’ Dɨŋɨ́ ká bɛ Mandɛm anáŋ achi Mfɔ ndǔ nkwɔ ywɛka.” ");
INSERT INTO kenNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yesu arɛm yɛ ntá bakoŋo bhi bɛ, “Mpok ǎtwɔ̀ anɛ bǎbhɔ̀ŋ chɔŋ ɛkwak bɛbhak nɛ Mɛ Mmu mfú ntá Mandɛm yɛ̌ chi ndǔ nywɔp nɛmɔt kɛ be kɛbhɔŋ mbi. ");
INSERT INTO kenNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mpók yɔ, chɔŋ bo mámbak abhɛn bághàti bhe bɛ, ‘Ghɔ́ ká yi awu!’ Báchák mandɛm bɛ, ‘Ghɔ́ ká yi fá!’ Mbák mǎngók nɔ, bǎkɛ́ rɔŋ, bǎkɛ́ bho bɛ́koŋo bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Mbɔ ɛnyǔ miámiaŋ ákɔ̀t angɔɔ, bɛfu ɛbhɔ́kɔ́ nɛbu ɛ́mɔt bɛghaka ɛ́chák, nɔ́ kɛ̌ ɛ́bhɔ́ŋɔ́ bɛbhak mpok Mɛ Mmu mfú ntá Mandɛm nchí twɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kɛ yí abhɔŋ bɛyambɨ angɔ́ bɛyǎ ɛsɔŋɔri nɛ mkpáká bho abhɛn ɛchɔŋ mámbyak yí, kɛ antwɔ́. ");
INSERT INTO kenNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Mbɔ ɛnyu ɛ́fákárí nyaka mpok Nóa, nɔ́ kɛ̌ ɛ́fàkari chɔŋ kɛ Mmu anɛ áfú ntá Mandɛm ambesi. ");
INSERT INTO kenNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Bo mányìɛ̀ nyaka mányù nɔkɔ, abhɛn bábhày baghɔrɛ́ mámbay nɔkɔ, nɛ abhɛ́n bátòk bhɔ mántoko nɔkɔ kpatɛ nywɔp ɛnɛn Nóa áchwé amɛm áchwí, nɛ manyiɛp átwɔ́ akuti mmɨk awáy bǒ mankɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Chɔŋ ɛ́mbak nkwɔ́ mbɔ ɛnyǔ ɛchi nyaka mpok Lɔt. Bo mányìɛ̀ nyaka nɛ mányu nɔkɔ. Bákù nyaka mɛnyɨŋ nɛ abhɛn bɛ́ti mánti nɔkɔ mɛnyɨŋ ɛbhap. Mbɔk bákwàŋ nyaka nɛnyíɛ́, abhɛ́nɛ́fú mánte nɔkɔ bɛkɛt. ");
INSERT INTO kenNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kɛ ndǔ nkúbhɛ́ nywɔp ɛnɛ́n Lɔt afa ɛtɔk Sódom, Mandɛm akʉ ngó áfú amfay nɛ ɛkɛm mbɔ batay anɛ ádù, anyɛ mbɔ manyiɛp, ásɔ́ŋ bɔ mankɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nɔ́ kɛ ɛ́bhàk chɔŋ nɛ bo mpok Mmu anɛ áfú ntá Mandɛm ábhèsi. ");
INSERT INTO kenNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ɛwak ɛyɔ, ɛ́bhák ɛnyumɔt nɛ mmu anɛ achi amfǎy ɛkɛt. Ákɛ́ rɔ́ŋ kpɨ́k anywɔ́p bɛ ampɔkɔ mɛnyɨŋ kɛ ambʉɛ. Ɛnyumɔt nɛ mmu anɛ achi ɛbhɨ. Ákɛ́ rɛm bɛ́ ǎpɛtnsɛm anywɔ́p ansɔt yɛ̌nyɨŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Bǎkɛ́ ghɔkɔntɨk ɛnyɨŋ ɛnɛ ɛ́fákárí nyaka nɛ ngɔrɛ́ Lɔt. ");
INSERT INTO kenNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mmǔ anɛ áyàŋ bɛpɛmɛ mmʉɛt, chɔŋ anɛ́m nɛpɛ́m ɛni. Kɛ yɛ̌ agha anɛ áká mɛ́nɛm nɛpɛ́m ɛni ɛ̌ti ya, chɔŋ ambɔ́ŋ nɔ́. ");
INSERT INTO kenNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nchí ghati bhe bɛ, ndǔ mpok yɔ anɛ mɛ̌pɛtnsɛm, bǒ bati apay bákway bɛbhʉrɛ ndǔ bɛkɔ́k mɛ́mɔt, mánsɔt amɔt mandɔk nɛ yí, mándɔ anɛfu. ");
INSERT INTO kenNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Baghɔrɛ́ bati ápay bákway bɛbhak ndǔ ntay nɛmɔt mánkɔk nɔkɔ nchwi, mánsɔt amɔt mándɔk nɛ yi, mándɔ anɛfú.” ");
INSERT INTO kenNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Bǒ bati apay bákwày bɛbhak ɛbhɨ, mánsɔt amɔt, mándɔ anɛfú. ");
INSERT INTO kenNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Bakoŋo Yesu bábhɛ́p yi bɛ, “Acha, mɛnyɨŋ ɛbhɛ́n bɛ́fàkari chɔŋ fá?” Yesu arɛm bɛ, “Nɛbhʉɛt anɛ ɛgú-nnya ɛchi, arɛ́ kɛ̌ kɛnɛn ɛkɛn kɛ́nyìɛ̀ bɛgú nnya kɛ́chɛmɛ.” ");
INSERT INTO kenNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesu atɛ́m nɛkay ɛnɛ́nɛ́fú ntá bakoŋo bhi ndu bɛtɔŋ bhɔ bɛ, bábhɔŋ mɛnɨkmʉɛt ntá Mandɛm mpoknkɛm, kɛfɛrɛ ntí arɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Arɛm bɛ, “Ntaŋá-manyé amɔt achi nyaka ɛtɔkɔfú, Mandɛm yi kɛ chyɛ kɛnókó, ntɨ nkwǎ yi kɛbhɔŋ mpok nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kɛ́nkwɛ́sɛ́ amɔt abhak nkwɔ́ ɛtɔk ɛyɔ. Are rɔ́ŋ ntá ntaŋá manyé wu anɨk nɔkɔ yí mmʉɛt bɛ, ‘Ɛta, táŋ manyé ya sayri fɛrɛ mɛ amɔ́ mǔmpap awa.’ ");
INSERT INTO kenNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ndǔ nɛbhǒnɛt, ntaŋá manyé wu kɛfyɛ́ ntí. Kɛ ansɛm mpok, achɔkɔ diíí arɛm nɛ mmʉɛt yi bɛ, ‘Yɛ̌ndu mpú chyɛ Mandɛm kɛnókó, nɛ mbɨ́kɨ́ bhɔŋ mpok nɛ ntɨ nkwǎ, ");
INSERT INTO kenNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","kɛ ndu mɔ́ngɔrɛ́-nɛ árɔ̀ŋ chi ambɨ bɛchyɛ mɛ ɛsɔŋɔri, chɔŋ ntáŋ manyé yi sayri nchyɛ́ yi. Mbák ɛ́pú nɔ́, apú sɛbhɛ mɛ ante amɨk.’” ");
INSERT INTO kenNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Yesu Acha arɛm yɛ bɛ, “Bǎghok nɔ ɛnyɨŋ ɛnɛ ntaŋá manyé anɛ ápú chak árɛ́mɛ́? ");
INSERT INTO kenNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Mbák mmu mbɔ yi ǎkwáy nyaka bɛ́kwak mɔ́ngɔrɛ́ wu, Mandɛm kɛ apu kway bɛkwak bo abhɛn yi áyábhɛ́ mbák bádì kɛbhɔ ntá yi bɛ̌ti nɛ ngósí? Ǎkway bɛ́chɔ́ŋti mpok kɛ ankwak bhɔ? ");
INSERT INTO kenNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nchí ghati bhe bɛ, chɔŋ Mandɛm amkpɔ́t manyé áyák anchyɛ bǒbhi. Kɛ mpok Mmu anɛ áfú ntá Mandɛm ápɛ́rɛ́nsɛm, chɔŋ angɔ́ bo abhɛn bábhɔ́ŋɔ́ nɛka nɛ Mandɛm fá amɨkɨ́?” ");
INSERT INTO kenNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu atɛ́m nɛkay ɛnɛ́nɛ́fú ntá bo abhɛn bakaysi nyaka bɛ bachi chak bɛsí Mandɛm, mámbyaka nɔkɔ bo bachak. ");
INSERT INTO kenNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Yi bɛ, “Bo bati apay bárɔŋ nyaka mɛnɨkmʉɛt amɛm ɛkɛrákap Mandɛm. Amɔt abhak mǔnkwɔ Fárisi, anɛfú abhak mbɛbhɛ́ nkabhɛ́nti. ");
INSERT INTO kenNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mǔnkwɔ Fárisi ate ɛyǐ ɛbhak anɨk mmʉɛt bɛ, ‘Mandɛm, nkáká wɔ́ bɛ mpú mbɔ bo báchák abhɛn bachi baghɛ́p, bakʉ̌ bɛbʉ́, nɛ bakwɛnɛ́ bɛrwɔp. Nkáká wɔ bɛ mpú mbɔ yɛ̌ chí mbɛbhɛ́ nkabhɛ́nti anɛ áté nɔ́ awu. ");
INSERT INTO kenNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nchí bhak ndǔ nɛtarɛ́nsay ndɔŋ ɛ́páy ndu sɔ́nde amɔt. Nɛ ndǔ mɛnyɨŋ ɛbha mɛnkɛm nchí chyɛ ndu amɔt amfay baru byo mbɔ akap ntá yɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Kɛ mbɛbhɛ́ nkabhɛ́nti ate nɛkɔ nɛsiɛ. Ntí, yi kɛ yoŋ amfay, nɛ adɛp awɔ́ antɨ arɛm bɛ, ‘Ɛta Mandɛm, nchí mmǔ bɛbʉ́. Ghɔ́ mɛ ntínso!’ ");
INSERT INTO kenNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nchí ghati bhe bɛ Mandɛm ásɔ́t nyaka bɛ mbɛbhɛ́ nkabhɛ́nti wu achí chak bɛsí bhi. Ɛ́kɛbhák nɔ nɛ mǔnkwɔ Fárisi mbɔnyunɛ́ Mandɛm ǎsɛ̀pti yɛ̌ntɨkɨ mmu anɛ áyòŋ mmʉɛt, kɛ ǎkòsi yɛ̌ agha anɛ ásɛ̀pti mmʉɛt amɨk.” ");
INSERT INTO kenNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bofú básɔ́t bɔ̌bhap bárɔ́k ntá Yesu nɛ bhɔ bɛ yi anyaŋa bɔ amɔ anti anjɛt bhɔ. Baghɔkɔ́ bhi bághɔ́ nɔ́kɔ́ nɔ, bábho bɛsáyti bhɔ bɛ bákɛ́ kʉ nɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kɛ Yesu abhɨŋɨ bǒbhɔ nɛ bɔ̌bhap. Nɛ ntá baghɔkɔ́ bhi arɛm bɛ, “Dɔ̌ ká mǎmbɔ mántwɔ ntá ya, bǎkɛ́ chyɛt bɔ mbi mbɔnyunɛ bǒ abhɛn bachi mbɔ bhɔ́ kɛ̌ Mandɛm abhak Mfɔ wap.” ");
INSERT INTO kenNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Dɨŋɨ́ ká bɛ, mbák mmu abhɨ́kɨ́ rɔ Mandɛm ankɛm yi mbɔ mɔ́nkwɛn apú kway bɛbhak ndǔ mpǎy bo abhɛn Mandɛm achi Mfɔ wap wáwák. ");
INSERT INTO kenNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ɛwak ɛ́mɔt, mǔnti bo Israɛl abhɛ́p Yesu bɛ, “Ntɔŋ, wɔ mmǔ ndɨ́ndɨ́, chɔŋ nkʉ yi kɛ mbɔ̌ŋ nɛpɛ́m ɛnɛ́n nɛbhɨkɨ bhɔŋ ngwɛnti?” ");
INSERT INTO kenNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu akɛmɛ yí bɛ, “Ndaká yí ɔ́bhɨ́ŋɨ́ mɛ bɛ mmǔ ndɨ́ndɨ́? Mmǔ ndɨ́ndɨ́ apú. Mandɛm aywǐnti kɛ achi Mmǔ ndɨ́ndɨ́. ");
INSERT INTO kenNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ɔrɨ́ŋɨ́ bɛbhé Mandɛm. Bɛ́rɛ̀m bɛ, ‘Ɔ́kɛ́ kwɛn bɛrwɔp. Ɔ́kɛ́ wáy mmu. Ɔ́kɛ́ ghɛp. Ɔ́kɛ́ te ntísiɛ ákwárɛ́. Chiɛ̌ máyɛ nɛ ɛtayɛ kɛnókó.’” ");
INSERT INTO kenNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mmǔ wu árɛm bɛ́ “Nnáŋ nchí bhʉɛrɛ bɛbhé ɛbhɛn mɛnkɛm.” ");
INSERT INTO kenNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu ághókó nɔ́kɔ́ nɔ́, arɛm ntá yi bɛ, “Ɛ́rɔp ɛnyɨŋ ɛ́mɔt ɛnɛ́ ɔ́bhɨ́kɨ́ re kʉ. Dɔ́k tí mɛnyɨŋ ɛbhɛ mɛnkɛm, chyɛ̌ nkáp ntá bachɛ́bhɛ́bho. Mbák ɔ́nkʉ́ nɔ, chɔŋ ɔ́mbɔ́ŋ kɛfɔ̌ mɛnyɨŋ amfay. Ɔ́ntwɔ́ yɛ ɔnkoŋo mɛ. Nɛ chɔŋ ɔ́mbɔ́ŋ kɛfɔ̌ mɛnyɨŋ awǔ amfay.” ");
INSERT INTO kenNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ághókó nɔ́kɔ́ nɔ́, apɔp, arɔbhɛ rɔ́ŋɛ́rɔ́ŋ mbɔnyunɛ abhɔ̌ŋ nyaka bɛyǎ mɛnyɨŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu ayɨŋɨ yí, arɛm bɛ, “Ɛ́bèmʉɛt tontó bɛ mǔnkáp anka Mandɛm ambak Mfɔ ywi. ");
INSERT INTO kenNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ɛ́chí wɨkɨrɨk bɛ mpɔŋɔ baso ámfʉɛ́t ndǔ mbok mbíábhan ɛ́cha mǔnkáp bɛ́ka Mandɛm ambak Mfɔ ywi.” ");
INSERT INTO kenNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bo abhɛn baghoko bɛyɔŋ ɛbhɔ bábhɛ́p Yesu bɛ, “Agha ákwày yɛ bɛbhɔŋ nɛpɛ́m ɛnɛn nɛ́bhɨ́kɨ́ bhɔŋ ngwɛnti?” ");
INSERT INTO kenNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu akɛmɛ bhɔ bɛ, “Ɛnyɨŋ ɛnɛ́ ɛ́cha nkwǎŋwaŋ, ɛ́pú cha Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Píta asá ɛyɔŋ arɛm bɛ, “Yɨŋɨ́, sɛ́rɔ́ mɛnyɨŋ mɛnkɛm sɛ́kòŋo wɔ.” ");
INSERT INTO kenNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu aghati bhɔ bɛ, nchí ghati bhe bɛ, “Mmǔ anɛ árɔ́ yɛ̌ ɛkɛt, yɛ̌ ngɔrɛ́, yɛ̌ bɔ̌mayi, yɛ̌ ɛtayi nɛ máyi, nɛ yɛ̌ bɔ̌bhi ɛ̌ti Kɛfɔ Mandɛm, ");
INSERT INTO kenNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Mandɛm ǎchyɛ chɔŋ yi mɛnyɨŋ ɛbhɛn bɛyǎ bɛcha ɛbhɛn yi anɛmɛ fá amɨk. Nɛ chɔŋ ambɔ́ŋ nɛpɛ́m ɛnɛn nɛ́bhɨ́kɨ́ bhɔŋ ngwɛnti ndǔ mmɨk nkɔ.” ");
INSERT INTO kenNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ɛ́tat nɔ́kɔ́, Yesu asɔt baghɔkɔ́ bhi bati byo nɛ apay nɛpak. Abho bɛ́gháti bhɔ bɛ, “Ghók ká! Sɛ́rɔŋ nɔ chí Yerúsalɛm, nɛ arɛ́, chɔŋ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ barɛmɛ́ kɛpɨ̌ntɨ Mandɛm básɨ́ŋɨ́ ɛ̌ti Mmu anɛ áfú ntá Mandɛm ɛ́mfakari. ");
INSERT INTO kenNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Chɔŋ mánkɛ́m yi mámfyɛ amɔ́ bǒbati abhɛn bápú bo Israɛl, mánjɔ́kɔ́ yi, nɛ mánsɔkɔti yí, nɛ mámpati yi batiɛ́ amʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Chɔŋ mándɛ́n yi nɛ ɛkpa, nɛ mángwáy yi. Kɛ ɛ́gháká nɔ́kɔ́ manywɔp arat, ampɛtnsɛm ndǔ nɛpɛ́m.” ");
INSERT INTO kenNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kɛ baghɔk Yesu kɛjwimɛm yɛ̌ chi ndǔ ɛnyɨŋ ɛ́mɔt ndǔ ɛbhɛn yi árɛ́mɛ́. Bɛ́bhak bhɛ́sɛ́ bhɛ́sɛ́ ntá yap nɛ bɔ́ kɛkɛ́m ɛnyɨŋ ɛnɛ yi arɛmɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Mpok Yesu aghaka kɛkwɔt nɛ Jɛríko, nnɛ́mámɨ́k amɔt abhak nɛpak mbi chɔ́kɔ́, anɨŋɨ nɔkɔ mɛnɨ́ŋɨ́. ");
INSERT INTO kenNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ághókó nɔ́kɔ́ ndǔ bɛyǎ bó báfʉɛ̀t, abhɛ́p ɛnyɨŋ ɛnɛ ɛ́fàkari. ");
INSERT INTO kenNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bágháti yi bɛ, “Yesu anɛ Násárɛt kɛ áfʉɛ̀t.” ");
INSERT INTO kenNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Abho yɛ bɛ́bɨ́k bɛ, “Yesu! Mmɔ̌ Mfɔ Debhít! Ghɔ́ mɛ́ ntínso!” ");
INSERT INTO kenNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bo abhɛn bárɔ̀ŋ ambɨ báré sayti yi bɛ ánchɔ́kɔ́ kpák; kɛ akpɨk are bɨk nɛ ɛyɔŋ ɛtaŋɛtaŋ bɛ, “Mmɔ̌ Mfɔ Debhít! Ghɔ́ mɛ́ ntínso!” ");
INSERT INTO kenNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu áte, achyɛ ɛyɔŋ bɛ mántwɔ́ nɛ yi. Bátwɔ́ nɔ́kɔ́ kɛ́kwɔ́t nɛ yi, Yesu abhɛ́p yi bɛ, ");
INSERT INTO kenNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ɔ̌yáŋ mɛ̌nkʉ́ wɔ yi?” Akɛmɛ Yesu bɛ, “Acha, nchí yaŋ mpɛt ngɔ mbaŋ.” ");
INSERT INTO kenNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu arɛm yɛ ntá yi bɛ, “Ghɔ́ mbaŋ. Nɛka ɛnɛ́n ɔbhɔŋɔ nɛ mɛ nɛ́kʉ ɔtaŋ.” ");
INSERT INTO kenNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tɛ́mté wu, abho bɛghɔ mbaŋ! Nɛ abho bɛkoŋo Yesu, ambɨti nɔkɔ Mandɛm. Bo mankɛm bághɔ́ nɔ́kɔ́ nɔ, babhɔ bɛbɨti nkwɔ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu achwe ɛtɔk Jɛríko are kɔ bɛfʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mmu amɔt abhak arɛ́ anɛ aka nnyɛ́n bɛ Sakio. Abhak mǔnti babhɛbhɛ́ nkábhɛ́nti. Abhɔ́ŋ bɛyǎ nkáp. ");
INSERT INTO kenNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Árɨ́ŋɨ́ nɔ́kɔ́ bɛ́ Yesu ǎfʉɛ̀t, abho bɛyaŋ mbi bɛ ángɔ́ ɛnyǔ mmu Yesu achi, kɛ ɛ̌ti kɛmbɨŋ ɛki nɛ bɛyǎ bo, yi kɛkwáy bɛghɔ yi. ");
INSERT INTO kenNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ajɛt arɔk ambɨ, akó amfǎy ɛnɔk ɛnɛ bábhɨŋɨ bɛ Síkámɔ ndǔ mbi anɛ Yesu ákɔ̀ arɛ ndu áyàŋ bɛghɔ yi. ");
INSERT INTO kenNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu ágháká nɔ́kɔ́ arɛ, ayoŋ amɨ́k amfay aghati Sakio bɛ, “Sakio, sɛp twɔ́ áyák. Mbɔŋ bɛ́bhak ɛkɛt ɛyɛ ɛchɔŋ.” ");
INSERT INTO kenNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakio asɛp amɨk áyák, anak Yesu ɛkɛt yi nɛ bɛyǎ maŋák. ");
INSERT INTO kenNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bo bághɔ́ nɔ́kɔ́ ndǔ Yesu árɔ̀ŋ ndǔ ɛkɛt Sakio, báré nywinti mándɛmɛ nɔkɔ bɛ, “Yesu ǎrɔ̀ŋ bɛbhák kɛnkɔ amɛm ɛkɛt nkʉ bɛbʉ́.” ");
INSERT INTO kenNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ɛnɛ́ Yesu nɛ Sakio báchí anywɔ́p, Sakio afate arɛm ntá Yesu bɛ, “Acha, ghók, chɔŋ nkɔ́rɛ mɛnyɨŋ ɛbha ndǔ baru apay, nchyɛ́ ndu amɔt ntá bachɛ́bhɛ́ bho. Nɛ mbák nsɔt ɛnyɨŋɨ́ mmu ndǔ mangwɔ, chɔŋ nkɛmɛ yɔ ndɔŋ ɛnwi.” ");
INSERT INTO kenNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu arɛm ntá yi bɛ, “Ɛchɔŋ, Mandɛm apɛ́mɛ́ wɔ́ nɛ ɛfo ɛyɛ ɛnkɛm mbɔnyunɛ wɔ nkwɔ́ ɔchí ɛbhárɛ́mɔ Ábraham anɛ Mandɛm ábhɔ́ŋ bɛ́pɛ́mɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nɛ Mɛ Mmu mfú ntá Mandɛm ntwɔ bɛ́yáŋ nɛ bɛ́pɛ́mɛ chi bo abhɛn manɛ́mɛ́ ɛbhɨ.” ");
INSERT INTO kenNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ɛnɛ́ bo bághòk mɛnyɨŋ ɛbhɛn Yesu árɛ̀m, arɔk ambɨ bɛtɛm nɛkay nɛchak. Ntí abhak bɛ, anáŋ agháká nyaka kɛkwɔt nɛ Yerúsalɛm, nɛ bo bákàysi nyaka bɛ Kɛfɔ Mandɛm kɛ́twɔ̀ fá amɨk mandú mpok. ");
INSERT INTO kenNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yesu aghati yɛ bhɔ bɛ, “Nnɛ́m mmu amɔt arɔ́ nyaka ɛtɔk yi arɔk ɛtɔk ɛ́chák nɛkɔ nɛsiɛ bɛ́ mánkʉ́ yí mfɔ ntá bǒbhi kɛ ampɛtnsɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ápɛ́rɛ rɔŋ, abhɨŋɨ bakʉ̌ bɛtɨk abhi bati byo. Achyɛ yɛ̌ntɨkɨ mmu wap ɛbhǎ nkáp, arɛm bɛ ‘Kɔ nɔ́kɔ́ ká ɛsiɛ nɛ nkáp wu kpátɛ̌ mpok nɛpɛrɛ́nsɛm ɛná.’ ");
INSERT INTO kenNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Arɔ yɛ are rɔ́ŋ. Kɛ bǒ ɛtɔk yi bápap nyaka yi. Bátó yɛ bo bɛ mándɔ́k mángátí mfɔ ngo bɛ ‘Acha, sɛ́bhɨ́kɨ́ yaŋ mmǔ-nɛ ambák mfɔ ywɛsɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Yɛ̌ nɔ, nɛrɔŋ yi arɔŋɔ bákʉ́ yí mfɔ. Ápɛ́rɛ́ nɔ́kɔ́ nsɛm ɛtɔk yi, abhɨŋɨ bǒ bɛtɨk abhɛn yi achyɛ nyaka nkáp bɛ mántwɔ́ yi angɔ nsay anɛ bábhɔ́ŋɔ́. ");
INSERT INTO kenNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Anɛ mbɨ arɔk aghatí yí bɛ, ‘Acha, mbɔ̌ŋ nsáy bɛbhǎ nkáp byo amfay ɛbha ɛ́mɔt ɛnɛ ɔ́chyɛ́ mɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Mfɔ wu arɛm ntá yi bɛ, ‘Ɔkʉ sayri, ɔchí ɛrɨ́tí nkʉbɛtɨk! Tɛ̌ndu ɔ́tɔ́ŋɔ́ ndǔ mandú ɛnyɨŋ bɛ ɔ̌bhʉ̀rɛ bariɛp, mɛ̌chyɛ̀ wɔ bɛtaŋ bɛkɛm bɛtɔk byo.’ ");
INSERT INTO kenNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Anɛ ájwí bati apay atwɔ́ arɛm bɛ, ‘Acha, mbɔ̌ŋ nsay bɛbhǎ nkáp bɛtay amfay ɛbha ɛ́mɔt ɛnɛ ɔ́chyɛ́ mɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Mfɔ arɛm ntá nkʉbɛtɨk wu bɛ, ‘Mɛ̌chyɛ̀ wɔ bɛtaŋ bɛ́kɛ́m bɛtɔk bɛgho bɛtay.’ ");
INSERT INTO kenNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nkʉ bɛtɨk achák atwɔ arɛm bɛ, ‘Acha, ghɔ́ ɛbhǎ nkáp ɛyɛ. Nnɛp nyaka wu ndǔ ɛbhɔ́kɔ́ndɛn mbɛsɛ. Mbɨ́kɨ́ kʉ ɛnyɨŋ nɛ wu. ");
INSERT INTO kenNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mbɔ̌ŋ nyaka bɛchǎy mbɔnyunɛ ɔchí mmu mbeápak. Ɛnyɨŋ ɛ́pú ɛyɛ, ɔ̌sɔrɛsɔt. Nɛ ɔ̌ghɛ̀m ɛnyɨŋ ɛnɛ́ ɔ́bhɨ́kɨ́ pɨ.’ ");
INSERT INTO kenNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Mfɔ wu aghati yi bɛ ‘Wɔ nkʉbɛtɨk mbʉ́mbʉ, ɛyɔŋɔ́nyu yɛ ɛ́way wɔ! Ɔrɨ́ŋɨ́ bɛ́ nchí mmu mbeápak. Ɔrɨŋɨ bɛ́ nchí sɔt ɛnɛ́ ɛ́pú ɛya, nɛ nchí ghɛm ɛnɛ́ mbɨ́kɨ́ pɨ, pú nɔ́? ");
INSERT INTO kenNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kɛ ndak yi ɔ́bhɨ́kɨ́ fyɛ́ nkáp awa amɛm ɛkɛrɛ́nkap? Mbɔ ɔkʉ nɔ, mbʉ́ ndu ntwɔ́ nɛ́, mbɨ́kɨ́ sɔt wú nɛ nsáy?’ ");
INSERT INTO kenNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Aghátí yɛ bo abhɛn báchí arɛ téé bɛ, ‘Sɔt ka ɛbhǎ nkáp ɛyǐ yɔ mǎnchyɛ ntá mmu anɛ ábhɔ́ŋɔ́ bɛbha byo.’ ");
INSERT INTO kenNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bárɛ́m ntá yi bɛ, ‘Acha, pú yi abhɔŋ bɛbhǎ byo?’ ");
INSERT INTO kenNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Mfɔ wu akɛmɛ bɛ, ‘Nchí ghati bhe bɛ, mmu anɛ ábhɔ́ŋɔ́, báchyɛ yi ɛ́chák. Kɛ anɛ ábhɨ́kɨ́ bhɔŋ, básɔ̀t ntá yi yɛ̌ chí mandú anɛ yi ábhɔ́ŋɔ́. ");
INSERT INTO kenNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Nɛ mbák chí bǒmpap abha bhɛn, abhɛn bábhɨ́kɨ́ yaŋ nyaka bɛ mbák mfɔ wap, twɔ́ ká nɛ bhɔ fá, mǎngwáy bhɔ́ bɛsí bha.’” ");
INSERT INTO kenNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu átɛ́m nɔ́kɔ́ bhɔ́ nɛkay ɛnɛn, arɔk ambɨ bɛ́kɔ bɛrɔŋ Yerúsalɛm, yi abhak ambɨ, bo abhɛn báchi nɛ yi mankoŋo nɔkɔ ansɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ágháká nɔ́kɔ́ kɛ́kwɔ́t bɔ̌bɛtɔk Bɛtfágɛ nɛ Bɛ́tani, ndǔ Njiɛ Mɛnɔk *Ólif, ató baghɔkɔ́ bhi bati apay ambɨ. ");
INSERT INTO kenNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Aghati bhɔ bɛ, “Dɔ́k ká ndǔ mɔ́tɔk anɛ achi afɔ ambɨ. Nɛchwe anɛ báchwe arɛ chɔŋ mǎngɔ mɔ́ mpɔŋɔ batu sɛsɛ́t, anɛ yɛ̌ mmu abhɨkɨ re kɔ nɛ yɔ́. Kaŋarí ká twɔ́ mɛ nɛ yɔ́. ");
INSERT INTO kenNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mbák mmú ámbɛ́p be ntí anɛ bǎkàŋari yɔ́, ghati ka yí bɛ, ‘Acha kɛ áyàŋ yɔ.’” ");
INSERT INTO kenNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Bǒ abhɛn yi átó, bárɔ́k, bághɔ́ yɛ̌ntɨkɨ ɛnyɨŋ mbɔ ɛnyǔ yi aghati bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ɛ́nɛ́ bákàŋari mɔ́mpɔŋɔ batu wu, bǒ abhɛn babhɔŋɔ yɔ, bábhɛ́p bhɔ bɛ, “Ndaká yí bǎkàŋari mɔ́mpɔŋɔ batu wu?” ");
INSERT INTO kenNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bákɛ́mɛ bɛ, “Acha ǎyàŋ yɔ.” ");
INSERT INTO kenNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bárɔ́k yɛ nɛ yɔ ntá Yesu. Básɔ́t ndɛn ɛnɛ́ mfǎymʉɛt ɛyap basɔbhɛri mɔ́mpɔŋɔ batu wu, bákwák yi achɔkɔ amfay. ");
INSERT INTO kenNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nɛ ndǔ yi ákɔ̀ árɔ̀ŋ, bo báré sɔt ndɛnɛ́ mfǎymʉɛt ɛyap mángay nɔkɔ ambi bɛ mɔ́mpɔŋɔ batu wu ankɔ amfay. ");
INSERT INTO kenNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ágháká nɔ́kɔ́ kɛ́kwɔ́t nɛ nɛbhʉɛt anɛ mbi árɔ̀ Njiɛ Mɛnɔk Ólif ásɛ̀p Yerúsalɛm, ngɛ́mtáy bakoŋo bhi bábhó mɛŋák, mámbɨti nɔkɔ Mandɛm nɛ ɛyɔŋ amfay ɛ̌ti mɛnyɨŋɨ́ maknkay mɛnkɛm ɛbhɛn bɔ́ bághɔ́. ");
INSERT INTO kenNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Mándɛmɛ nɔkɔ bɛ, “Mandɛm ánjɛ́t mmu anɛ átwɔ̀ ndǔ nnyɛ́n Acha! Mandɛm Mfay kɛ áchyɛ̀ kpák. Sɛ́nchíɛ yí kɛnókó!” ");
INSERT INTO kenNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mbɔk bǒnkwɔ Fárisi abhɛn báchí ndǔ ngɛ́mtáy bo bhɔ, bárɛ́m ntá Yesu bɛ, “Ntɔŋ, sáy bakoŋo bhɛ mánchɔkɔ kpák.” ");
INSERT INTO kenNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu akɛmɛ bhɔ bɛ, “Nchí ghati bhe bɛ yɛ̌ mbʉ́ mánchɔkɔ chí kpák, batay ábɨk ambɨti Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu ágháká kɛ́kwɔ́t nɛ Yerúsalɛm, aghɔ́ ɛtɔk, adi kɛbhɔ ndǔ ntínso nɛ́kɛm yi nɛ Yerúsalɛm, ");
INSERT INTO kenNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","andɛmɛ nɔkɔ bɛ, “Mbɔ be bǎrɨ́ŋɨ́ yɛ̌ chí ɛchɔŋ, mɛnyɨŋ ɛbhɛn bɛ́kʉ̀ bo mámbɔ́ŋ kpák, mbʉ́ ɛ́rɨ-e! Kɛ nɛ́nɛ, bɛchi bhɛsɛ bhɛsɛ nta yɛka nɛ bǎpú ghɔ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mpok ǎtwɔ̀ anɛ bǒmpap abhɛka bátwɔ̀ mánkap be, mántɛp nkók ankap ɛtɔk yɛka, mánchɛt bhe bɛbhě mɛnkɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nɛ mánchwe mánaŋa bhe nɛ bɔ̌bhɛka mankɛm, mámokoti ɛtɔk ɛnkɛm ɛnyunɛ́ yɛ̌ ntay nɛ́pú rɔp amfǎy ntɨ. Chɔŋ ɛ́mfakari nɔ, mbɔnyunɛ́ bǎbyak Mandɛm mpok yi átwɔ́ bɛ́pɛ́mɛ bhe.” ");
INSERT INTO kenNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu arɔk achwe amɛm ɛkɛrákap Mandɛm abho bɛbok bǒ abhɛn bákɔ̀ ɛsiɛ́ amɛm, ");
INSERT INTO kenNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ambe nɔkɔ nɛ bhɔ bɛ, “Ɛkáti Mandɛm ɛ́rɛ̀m bɛ́ Mandɛm arɛm bɛ, ‘Ɛkɛt ɛya ɛ́bhɔŋ bɛbhak chi ɛkɛrɛ́ nɛnɨkɨ́mʉɛt’, kɛ bǎyíbhírí yɔ́ ɛ́rɔp chi ɛkɛt ɛnɛ́ baghɛ́p bábhɛ̀sɛ arɛ!” ");
INSERT INTO kenNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesu are rɔ́ŋ yɛ antɔŋ nɔkɔ bo amɛm ɛkɛrákap Mandɛm, yɛ̌ntɨkɨ nywɔp. Bǒbati bachiǎkap Mandɛm, nɛ batɔŋ ɛbhé Moses, nɛ bǒbati ɛtɔk bachak báre yáŋ mbi bɛway yi. ");
INSERT INTO kenNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Kɛ bɔ́ kɛbhɔ́ŋ mbi mbɔnyunɛ́ bo mankɛm bábhɔ̌ŋ nyaka ɛkwak bɛ́ghok mɛnyɨŋ mɛnkɛm ɛbhɛn Yesu árɛ̀m. ");
INSERT INTO kenNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ɛwak ɛ́mɔt, ɛnɛ́ Yesu átɔ̀ŋ bo amɛm ɛkɛrákap Mandɛm angati nɔkɔ bhɔ Mbok Ndɨ́ndɨ́, bǒbati bachiǎkap Mandɛm nɛ batɔŋ ɛbhé Mandɛm nɛ bǒbati ɛtɔk bárɔ́k ntá yi, ");
INSERT INTO kenNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","barɛm bɛ, “Ghatí bhɛsɛ, ntɨkɨ bɛtaŋ ɔ́bhɔ́ŋɔ́ bɛkʉ mɛnyɨŋ ɛbhɛn nɛ́ ɔ́kʉ̀? Agha áchyɛ́ wɔ bɛtaŋ ɛbhɔ?” ");
INSERT INTO kenNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu akɛmɛ bhɔ bɛ, “Mɛ nkwɔ mbɔ̌ŋ ɛnyɨŋ bɛbhɛp be. Ghatí ká mɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Bɛtaŋ ɛbhɛn Jɔ̌n ábhɔ́ŋɔ́ nyaka ndu bɛjwiti bho, bɛ́fú chi ntá Mandɛm kɛ ntá nkwǎ?” ");
INSERT INTO kenNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Báre kɛm ɛpʉ́ítí nɛ batɨ bɛ, “Chɔŋ sɛ́ndɛm bɛ yi? Mbák sɛ́ndɛm bɛ bɛtaŋ ɛbhɛn Jɔ̌n bɛ́fú nyaka ntá Mandɛm, ǎbhɛ́p bhɛsɛ bɛ, ‘Kɛ ndaká yi bǎbhɨ́kɨ́ noko ɛyɔŋ ɛyi?’ ");
INSERT INTO kenNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nɛ mbák sɛ́ndɛ́m bɛ, ‘Bɛ́fǔ nyaka ntá nkwǎ’, bǒ mankɛm bátɛmti bhɛsɛ nɛ batay mangway, mbɔnyunɛ bɔ́ mankɛm mánóko sayri bɛ Jɔ̌n achi nyaka ndɛmɛkɛpɨ̌ntɨ Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ɛ́kʉ́ bakɛmɛ Yesu bɛ, “Sɛ́bhɨ́kɨ́ rɨŋɨ.” ");
INSERT INTO kenNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nɛ Yesu aghati bhɔ bɛ, “Mɛnkwɔ́ mpú ghati yɛ be mmu anɛ áchyɛ́ mɛ́ bɛtaŋ bɛkʉ mɛnyɨŋ ɛbhɛn nɛ́ mɛ̌kʉ̀.” ");
INSERT INTO kenNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesu abho yɛ bɛ́tɛm bɔ nɛkay nɛchak bɛ, “Mmǔfú achi nyaka. Atɨ nkɨ apɨ mɛnɔk vain arɛ. Afyɛ́ bo arɛ, bɛ mánkʉ bɛtɨk mankɔrɛ nsáy nɛ yi. Arɔ yɛ arɔk nɛkɔ ɛnɛn yi átàt, ɛtɔk ɛchak. ");
INSERT INTO kenNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Mpok bɛkɔk kɛpɛm ɛ́nɔk ákwáy nɔ́kɔ́, mbɔŋɔ́nkɨ ató bakʉ̌ bɛtɨk abhi bachak bɛ mándɔ́k mánsɔ́t aywi ákɔ́rɛ́ mbwɔt. Kɛ bǒ bɛtɨk bhɔ kɛchyɛ. Bákɛ́m yi badɛn, bábók, apɛtnsɛm amɔ́ amɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mbɔŋɔ́nkɨ ató mǔbɛtok achak. Bákɛ́m awu nkwɔ́ bádɛn, báchyɛ́ yi ntiánwɔ́p, bábók apɛtnsɛm amɔ́ apay. ");
INSERT INTO kenNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ató mmɔ̌bɛtok anɛ ajwi bati arat. Bádɛ́n, báfyɛ́ bɛfʉɛt amʉɛt, bábók, afú arɔk. ");
INSERT INTO kenNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ɛ́kʉ mbɔŋɔ́nkɨ wu arɛm nɛ mmʉɛ́t ɛyi bɛ, ‘Chɔŋ nkʉ ná? Chɔŋ ntó mbɔ̌ŋ mmɔ̌ntɨ wa. Yɛ̌ yí, bábhɔŋ bɛ́chyɛ yi kɛnókó.’ ");
INSERT INTO kenNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kɛ bakʉ̌ bɛtɨk bághɔ́ nɔ́kɔ́ yi, bábhó bɛrɛm nɛ batɨ bɛ, ‘Yɨŋɨ́ mbɔ̌ŋ mɔ́ywi nɛ́, nɛ yí kɛ̌ ábhɔ́ŋɔ́ mɛ́nyiɛ́ nɛwú ɛtayi. Twɔ́ ká sɛnkɛm yi sɛ́ngwáy bɛ́ ɛtayi ánáŋ ángú, mɛnyɨŋ ɛbhi mɛ́ndɔp chi ɛbhɛsɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Mɔ́ywi wu áchwé nɔ́kɔ́ amɛm nkɨ, bákɛ́m yi baya báfú amɛm nkɨ nɛ yi, barɔk baway.” Yesu átɛ́m nɔ́kɔ́ nɛkay ɛnɛn, abhɛ́p bɔ́ bɛ, “Bǎkaysi bɛ chɔŋ mbɔŋɔ́nkɨ wu ankʉ yi ntá bǒbhɔ? ");
INSERT INTO kenNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Chɔŋ antwɔ́ angway bhɔ, anchyɛ nkɨ wu ntá bo bachak.” Bághókó nɔ́kɔ́ nɔ, babho bɛrɛm bɛ, “Mandɛm akɛ ka!” ");
INSERT INTO kenNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesu ayɨŋɨ bhɔ dǐǐ, abhɛp bɛ, “Ntí basɨŋɨ́ amɛn achi bɛ yi? Basɨŋɨ́ amɛn árɛ̀m bɛ: ‘Nkúbhɛ́ ntay ɛnɛn batɛ̌kɛt bágʉɛ́bhɛ́ bɛ́ nɛ́bhɨ́kɨ́ rɨ, nɔ́ kɛ nɛ́rɔ́bhɛ́ ntay ɛnɛn nɛ́kɛ́mɛ́ ɛkɛt nɛchá batay áchák ankɛm.’ ");
INSERT INTO kenNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Yɛ̌ntɨkɨ mmu anɛ akwɛnɛ ndǔ ntay ɛnɛn, ǎsìɛpti ndǔ mbɨŋ, nɛ mmu anɛ ntay ɛnɛn nɛ́kwɛ́nɛ́ yi amʉɛt, nɛ́chɔ̀kɔti yi.” ");
INSERT INTO kenNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yesu atɛm nɔkɔ nɛkay ɛnɛn, batɔŋ ɛbhé Mandɛm nɛ bǒbati bachiǎkap Mandɛm bárɨŋɨ bɛ atɛm nɛkay ɛnɔ chi ɛ̌ti yap. Báre yaŋ bɛkɛm yi, kɛ báchày bo abhɛn báchi arɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Bárɔ́k yɛ ambɨ bɛyaŋ mbi bɛkɛm yi. Bátó baghokotǐ kɛpɨ ntá yi bɛ mánkɔt ngɛpti bɛ bachi bǒ tɛtɛp. Kɛ bárɔ̌ŋ nyaka chi bɛ mámbɛ́bhɛ́ nɔ́kɔ́ yi mɛnyɨŋ kpát ankwɛ́n anyu, ankwɛ́n ndǔ ntǎ yap bɛ mansɔt yi manto ntá Gɔ́bhanɔ Rom mmǔ bɛtaŋ mɛnkɛm bɛchi yi amɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Baghokotǐ kɛpɨ bhɔ bárɔ́ŋɔ́ nɔ́kɔ́ ntá Yesu, babhɛp yi bɛ, “Ntɔŋ, sɛ́rɨ́ŋɨ́ bɛ́ mɛnyɨŋ ɛbhɛn ɔ́rɛ̀m nɛ ɔ́tɔ̀ŋ bɛchi chak. Sɛ́rɨ́ŋɨ́ bɛ́ ɔpú yɨŋɨ mmu ndǔ bɛsí ɔ́ncháy yi, kɛ ɔ̌tɔ̀ŋ tɛtɛp ɛ̌ti mɛnyɨŋ ɛbhɛn Mandɛm áyàŋ bo mánkʉ. ");
INSERT INTO kenNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ghatí bhɛsɛ, ɛbhé yɛsɛ ɛka bɛ sɛ́nchíɛ nkábhɛ́nti ntá Mfɔ Rom kɛ ɛ́bhɨ́kɨ́ ka?” ");
INSERT INTO kenNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yesu arɨŋɨ bapu map, arɛm ntá yap bɛ, ");
INSERT INTO kenNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Tɔ́ŋ ká mɛ ɛbhɔ́kɔ́ nkap.” Bátɔ́ŋ nɔ́kɔ́ yi abhɛ́p bhɔ bɛ, “Ntí ághá nɛ́ arɛ́? Nɛ nnyɛ́n chí ɛnɛn ághá?” Bákɛ́mɛ yi bɛ, “Chí ntí Sísa, Mfɔ Rom. Nɛ nnyɛ́n, chi ɛni.” ");
INSERT INTO kenNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yesu arɛm bɛ, “Chiɛ́ yɛ́ ka nta Mfɔ Rom yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ ɛchi ɛyi, mǎnchyɛ ntá Mandɛm yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ ɛchi ɛnɛ Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bághókó nɔ́kɔ́ ɛnyɨŋ ɛnɛ Yesu arɛmɛ, bápɔ́p! Bɔ́ kɛbhɔŋ yɛ̌nyɨŋ ndǔ ɛnyɨŋ ɛnɛ yi árɛ́mɛ́, ɛnɛ ɛ́kʉ yi ankwɛn anyu bɛ bɔ mánkɛ́m yi bɛsí bho. Bárɔp kpákpǎkpak. ");
INSERT INTO kenNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mbɔk bǒnkwɔ Sádusi bárɔ́k ntá Yesu babhɛp yi ɛ̌ti nɛpɛrɛ́nsɛm ndǔ nɛpɛ́m. Bǒnkwɔ Sádusi bábhɨ́kɨ́ noko nyaka bɛ bawú bápɛ̀t chɔŋ nsɛm ndǔ nɛpɛ́m. Babhɛp yi bɛ, ");
INSERT INTO kenNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Ntɔŋ, Moses asɨŋ ndǔ ɛbhé ɛyɛsɛ bɛ, mbák mmu ángú ándɔ́ ngɔrɛ́ kɛ bɔ́ kɛbhɔŋ yɛ̌ mmɔ́, mɔ́mayi abhɔŋ bɛsɔt ngɔrɛ́ wu bɛ́ ámbé bɔ nɛ yi ndǔ nnyɛ́n manɔ anɛ ágú. ");
INSERT INTO kenNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Bɔ̌ chi amɔt bati tándrámɔt báchí nyaka. Anɛ mbɨ abháy ngɔrɛ́, agú kɛbhɔŋ yɛ̌ mmɔ́. ");
INSERT INTO kenNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Anɛ ákòŋo asɔt kɛ́nkwɛ́sɛ́ wu ndǔ nɛbhay agú kɛbhɔŋ mmɔ́. ");
INSERT INTO kenNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Anɛ ájwí bati arat nkwɔ asɔt yí kɛ agú kɛbhɔ́ŋ mmɔ́ nɛ yi. Ɛ́fákári ɛnyumɔt nɛ bɔ mankɛm bati tándrámɔt. ");
INSERT INTO kenNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ndǔ ngwɛnti, ngɔrɛ́ wu nkwɔ agú. ");
INSERT INTO kenNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ndu ɛchi nɔ, mpok Mandɛm ákʉ̀ bawú mámpɛ́tnsɛm ndǔ nɛpɛ́m, ngɔrɛ́ wu ǎbhák anɛ agha? Ndu bɔ́ mankɛm, bati tándrámɔt, yɛ̌ntɨkɨ mmu wap abhay nyaka yi.” ");
INSERT INTO kenNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu akɛmɛ bhɔ bɛ, “Fá amɨk, baghɔrɛ́ nɛ babhakanɛm bábháy batɨ, ");
INSERT INTO kenNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","kɛ bo abhɛn chɔ́ŋ bápɛtnsɛm ndǔ nɛpɛ́m, mǎnchwe ndǔ mmɨk nkɔ, bápú pɛrɛ bháy nɛbhay ");
INSERT INTO kenNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","mbɔnyunɛ bápú pɛrɛ kway bɛgu. Bábhak mbɔ bɔángɛl Mandɛm, bábhak bɔ̌ Mandɛm abhɛn yi akʉ bápɛtnsɛm ndǔ nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Yɛ̌ chí Moses atɔŋ nyaka kpoŋoroŋ ndǔ mbok ɛnɔk ɛnɛ́ ngó ádù arɛ bɛ bawú bápɛt chɔŋ nsɛm ndǔ nɛpɛ́m. Ndǔ basɨŋɨ́ mi ɛ̌ti mbok ɛyɔ, Moses ǎbhɨ̀ŋɨ Mandɛm mmu achi Acha bɛ, ‘Mandɛm Ábraham, Mandɛm Áisek, Mandɛm Jekɔ́p!’ ");
INSERT INTO kenNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ɛyɔ ɛ́tɔ̀ŋ bɛ Mandɛm achí Mandɛm bo abhɛn bachi nɛpɛ́m. Apú Mandɛm bawú. Ntá Mandɛm, bǒbhɔ mankɛm bachi nɛpɛ́m.” ");
INSERT INTO kenNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Mbɔk batɔŋ ɛbhé Mandɛm báká nɛ yi, barɛm bɛ, “Ntɔŋ, ɔrɛm sayri!” ");
INSERT INTO kenNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Yɛ̌ mmu kɛpɛrɛ mɔ bɛ́bhɛp yi yɛ̌nyɨŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu abhɛ́p bo abhɛn bághòk yi bɛ, “Ná bákwày bɛrɛm bɛ Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò achi ɛbhárɛ́mɔ Mfɔ Debhít? ");
INSERT INTO kenNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Mbɔ̌ŋ Debhít asɨ̌ŋ amɛm Ɛkáti Bakway bɛ: ‘Mandɛm Acha arɛm nyaka ntá Acha wa bɛ, chɔkɔ fá ɛbhě awɔ́nɛm ɛya ndǔ ɛnɔkɔ-kɛnókó, ");
INSERT INTO kenNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kpatɛ nkʉ bǒmpap abhɛ mándɔp mbɔ ɛnɔk ɛnɛ chɔŋ ɔ́nyàŋa bɛkak arɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Debhít ǎbhɨ̀ŋɨ nyaka Mpɛmɛ ɛrɛ bɛ Acha. Ná Achǎ áyibhiri ambak ɛbhárɛ́mɔ ywi?” ");
INSERT INTO kenNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Bɛsí bo mankɛm abhɛn bághòk yɛ̌ntɨkɨ ɛnyɨŋ, Yesu arɛm ntá baghɔkɔ́ bhi bɛ, ");
INSERT INTO kenNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Sɔt ka mpok nɛ batɔŋ ɛbhé Mandɛm. Bákɔŋ bɛghap mánkó mansɛp nɛ bɛwubhɛ wubhɛ́ ndɛn amʉɛt nɛfísiɛ bɛ bo mánkáká nɔ́kɔ́ bhɔ nɛ kɛnókó. Bákɔŋ nkwɔ́ bɛ́chɔkɔ ndǔ bɛbhaká kɛnókó amɛm bɛkɛrɛ́ nɛnɨkɨ́mʉɛt nɛ ndǔ bɛpa. ");
INSERT INTO kenNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nɛ mányìɛ̀ mɛnyɨŋ mánkwɛ́sɛ́ ndǔ mangwɔ, mánkʉ nɔkɔ bɛrɔ́rí nɛnɨkɨ́mʉɛt bɛsí bhó mbɔ bɛ bachi bɛrɨtí bho. Chɔŋ ntɛ́msí yap anjá ancha.” ");
INSERT INTO kenNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ɛnɛ́ Yesu achi amɛm ɛkɛrákap Mandɛm, ayɨŋɨ aghɔ́ ndǔ bǒ bakáp báfyɛ̀ akap amɛm ɛkʉbhɛ́ nkáp. ");
INSERT INTO kenNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Aghɔ́ nkwɔ kɛ́nkwɛ́sɛ́ amɔt anɛ ɛyi ɛ́pú ndu afyɛ́ bɔ̌bɛbhɔ́kɔ́ nkap bapay. ");
INSERT INTO kenNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yesu arɛm bɛ, “Nchí ghati bhe bɛ, akap kɛ́nkwɛ́sɛ́-nɛ ácha anɛ yɛ̌ntɨkɨ mmu. ");
INSERT INTO kenNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ndǔ bɛyǎ bakap kɛ̌ yɛ̌ntɨkɨ mmu wap áfɛ́rɛ́ mandú achyɛ mbɔ akap, kɛ nchɛ́bhɛ́ ngɔrɛ́ nɛ, achyɛ́ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ yi ábhɔ́ŋɔ́.” ");
INSERT INTO kenNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Mbɔk baghɔkɔ́ bhi báré rɛm ɛ̌ti bɛrɨ̌ ɛkɛrákap Mandɛm, mánkak nɔkɔ bɛrɨtí batay anɛ́ básɔ́rɛ́ báté yɔ́ nɛ ɛ̌ti mɛnyɨŋ ɛbhɛn bo báchyɛ́ bɛ mánsɔ́bhɛ́rí ɛkɛt ɛ́rɛ. Kɛ Yesu arɛm ntá yap bɛ, ");
INSERT INTO kenNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Mɛnyɨŋ ɛbhɛn bǎghɔ̀ nɛ mɛnkɛm, mpok ǎtwɔ̀ anɛ ɛkɛt ɛnɛ ɛ́rɔ̀ŋ amɨk ɛnkɛm yɛ̌nyɨŋ kɛrɔp téé.” ");
INSERT INTO kenNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bábhɛ́p yi bɛ, “Ntɔŋ, ntɨkɨ mpok chɔŋ mɛnyɨŋ ɛbhɛn bɛ́fakari, nɛ ntɨkɨ ɛrɨŋ ɛ́bhɔ́ŋɔ́ bɛkʉ bo mandɨŋɨ bɛ mpok anɛ ɔ́twɔ̀ arɔp kɛ́kwɔ́t?” ");
INSERT INTO kenNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu akɛmɛ bhɔ́ bɛ, “Sɔt ka mpok bɛ bákɛ́ rwɔ bhe mǎnjíbhírí batɨ yɛka. Bɛyǎ bo bátwɔ̀ chɔŋ mánsɔt nnyɛ́n ɛna mántɛn ambɨ, yɛ̌ntɨkɨ mmu wap andɛm nɔkɔ bɛ, ‘Mɛ kɛ nchi Mpɛmɛ anɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtó!’ Nɛ bɛ, ‘Mpok akway anɛ Mandɛm ápɛ̀mɛ mmɨk!’ Mbák mǎngók nɔ́ bǎkɛ́ koŋo bhɔ́. ");
INSERT INTO kenNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nɛ mpok bǎghókó nsóŋó-nɛnu nɛ ɛbyɔk, bǎkɛ́ chay. Mɛnyǔ mɛnyɨŋ ɛbhɔ bɛbhɔŋ bɛfakari, kɛ ɛyɔ ɛ́pú tɔŋ bɛ ngwɛnti mmɨk arɔp kɛkwɔt.” ");
INSERT INTO kenNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yesu arɔk ambɨ bɛ́rɛm bɛ, “Chɔŋ bɛtɔk mɛ́nu nɛ bɛtɔk bɛ́chák, bafɔ̌ ɛtɔk mánu nɛ batɨ̌ bafɔ̌ ɛtɔk. ");
INSERT INTO kenNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Chɔŋ bɛtaŋtí nɛnyikisǐ mmɨk nɛ nsay nɛ bɛghorǐ mame mɛ́mbak mbǎŋ nɛ mbaŋ. Nɛ chɔŋ mɛnyɨŋ ɛbhɛn mɛ́ntwɔ nɛ bɛyǎ bɛcháy, nɛ bɛrɨŋɨ́ maknkay mɛ́mfu amfǎy. ");
INSERT INTO kenNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Kɛ mɛnyɨŋ ɛbhɛn mɛnkɛm bɛ́pɛrɛ́ fákári, chɔŋ mánkɛm be, mánchyɛ ɛsɔŋɔri, mánsɔt be mandɔk amɛm bɛkɛrɛ́ nɛnɨkɨ́mʉɛt ɛbhap mántaŋ be arɛ, mamfyɛ́ bhe amɛm bɛkɛrɛ́kɛnɔŋ. Nɛ chɔŋ mámfyɛ be amɔ́ bafɔ nɛ bɔgɔ́bhanɔ bɛ mántáŋ be ɛ̌ti ya. ");
INSERT INTO kenNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Chɔŋ ɛyɔ ɛ́nchyɛ bhe mbi bɛghati bɔ Mbok Ndɨ́ndɨ́ ɛ̌ti ya. ");
INSERT INTO kenNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kʉ yɛka batɨ̌ yɛka bɛ bǎpú sɛmɛ ɛ̌ti ɛnyɨŋ ɛnɛ bǎbhɔŋɔ bɛrɛm ndu bɛtaŋa mmʉɛt, ");
INSERT INTO kenNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","mbɔnyunɛ chɔŋ mɛmbɔŋ nchyɛ́ bhe ɛnyɨŋ ɛnɛ bǎbhɔ́ŋɔ́ bɛrɛm, nchyɛ́ nɛrɨŋɨ́ndak bɛ mǎnchók manyǔ bǒmpap abhɛka. ");
INSERT INTO kenNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Chɔŋ yɛ̌ chí bachi nɛ manɔ bhɛka, nɛ bɔ̌mayɛka, nɛ bǒ nnɛrɛ́kɛt, nɛ mamʉɛrɛ bhɛka mámfyɛ be amɔ́ bǒmpap abhɛka. Nɛ chɔŋ mángwáy mbɔk yɛka. ");
INSERT INTO kenNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Chɔŋ bo mankɛm mámpap be ɛ̌ti bǎchí bakoŋo bha. ");
INSERT INTO kenNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Chɔŋ mɛnyɨŋ ɛ́bhɛn mɛ́nkway bɛfakari nɛ bhe kɛ yɛ̌ ɛkǎk ɛmɛnɛ́nti mmu ywɛka ɛpu nɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mbák mǎnté kákátí, chɔŋ mǎmpɛmɛ mmʉɛt ɛyɛka. ");
INSERT INTO kenNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Mpok bǎghɔ́ bakwɔ́ batɛmɛ́ nɛnu ndu bákábhɛ́ Yerúsalɛm, dɨŋɨ́ yɛ́ ka bɛ mpok bɛchɔŋti Yerúsalɛm akway. ");
INSERT INTO kenNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Mpok yɔ, bǒ abhɛn bachi atú Judɛ́ya mámbʉ́ɛ́, mámbɛ́sɛ́ amfay njiɛ. Abhɛn báchi amɛm ɛtɔk Yerúsalɛm mámbʉ́ɛ́ mándɔ́k. Nɛ abhɛn bachi nɛfí bákɛ́ chwe ɛtɔk, ");
INSERT INTO kenNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","mbɔnyunɛ manywɔp ayɔ chi anɛ ntɛmsi, bɛ́kʉ bɛ, mɛnyɨŋ mɛnkɛm ɛbhɛn bɛchi amɛm Ɛkáti Mandɛm mɛ́mfú tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nɛ chɔŋ ɛ́mbɛ́p ɛncha ntá baghɔrɛ́ nɛ mɛniɛ nɛ abhɛn báchí nɛ bɔ amɔ mpok ayɔ! Chɔŋ bɛyǎ bɛsɔŋɔri mɛ́ntwɔ fá amɨk nɛ Mandɛm ankʉ bǒ Yerúsalɛm mángɔ bɛběntɨ bhi. ");
INSERT INTO kenNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Chɔŋ mángwáy bɛyǎ bhap nɛ bɔakparɛnja, nɛ mánkɛmti bachak mbɔ basɛ́mɛ́ nɛnú ndǔ bɛtɔk nɛ bɛtɔk. Chɔŋ bo abhɛn bábhɨ́kɨ́ rɨŋɨ Mandɛm mánjati Yerúsalɛm kpatɛ mpok ayap amfʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Mpok yɔ, chɔŋ bɛrɨŋɨ́ maknkay mɛ́mbak amfay ndǔ mmok, nɛ ndǔ ntaŋ nɛ ndǔ mambe. Nɛ fá amɨk, chɔŋ bɛtɔk mɛ́mbɔ́ŋ basɛ́mɛ́ nɛ bɛcháy ɛ̌ti bɛrɛmti ɛbhɛ́n bɛ́fù ndǔ mpɛ́rɛ́nyɛn ɛnɛ bɔmanyu. ");
INSERT INTO kenNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Chɔŋ bo mámbɔŋ bɛcháy kpátɛ mbɔk mámfe ndu bárɨŋɨ bɛbɛ́ptí mɛnyɨŋ ɛbhɛn bɛ́bhó bɛfakari fá amɨk. Chɔŋ bɛtaŋ mfáy mɛ́nyɨkɨsi. ");
INSERT INTO kenNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nɛ chɔŋ Mmǔ anɛ áfú ntá Mandɛm ambesi, ande twɔ́ amɛm nɛbháŋ, nɛ bɛyǎ bɛtaŋ nɛ kɛnókó. ");
INSERT INTO kenNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mpok mɛnyɨŋ ɛbhɛn bɛ́bhó bɛfakari, tě ká sɛnɛ́ nɛ nkaysi bɛ mpok anɛ Mandɛm áfɛrɛ bhe ndǔ ɛsɔŋɔri arɔp chi kɛkwɔt.” ");
INSERT INTO kenNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesu atɛ́m bɔ nɛkay ɛnɛ́n bɛ, “Yɨŋɨ́ ká ɛnɔk *fig nɛ mɛnɔk bɛ́chák. ");
INSERT INTO kenNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nɛtɛ́m anɛ bɔ́ bɛ́bho bɛ́tɛm bɛtɔ́, bǎrɨŋɨ bɛ ɛso ɛ́rɔp chi kɛ́kwɔ́t. ");
INSERT INTO kenNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ɛ́chí ɛnyumɔ́t nɛ nɛtwɔ́ wa, Mɛ Mmu mfú ntá Mandɛm. Mǎnáŋ mǎngɔ ndǔ mɛnyɨŋ ɛbhɛ́n-nɛ ngátí bhe bɛ́fàkari, dɨŋɨ́ ká bɛ mpok anɛ Kɛfɔ Mandɛm kɛ́twɔ arɔp kɛkwɔt. ");
INSERT INTO kenNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nchí ghati bhe tɛtɛp bɛ mɛnyɨŋ ɛbhɛn mɛnkɛm bɛ́bhɔŋ bɛfakari, kɛ mkpáká bho abhɛn ɛchɔŋ amfʉɛ́t. ");
INSERT INTO kenNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Chɔŋ mfay amfʉɛt, mmɨk amfʉɛ́t, kɛ ɛyɔŋ ɛya ɛ́pú fʉɛt wáwák. ");
INSERT INTO kenNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Sɔt ka mpok bɛ́ bǎkɛ́ fyɛ ntí ndǔ mɛ́nyiɛ nɛnyíɛ́ tontó, bǎkɛ́ fyɛ ntí ndu mmɛ́m nɛ bǎkɛ́ bhɔŋ basɛ́mɛ́ ɛ̌ti mɛnyɨŋ ɛbhɛn nɛpɛmɛ́ mmɨk ɛnɛn. Mɛnyɨŋ ɛbhɛn bɛ́kway bɛkʉ bɛ nywɔbhɛ́ nɛtwɔ́ ɛna nɛ́mbák tɛ́mchok ntá yɛka ndǔ bǎbhɨ́kɨ́ toŋti mmʉɛ́t, nɛ nɛ́mbayti bhe mbɔ ntá. ");
INSERT INTO kenNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Chɔŋ mɛnyɨŋ ɛbhɛn bɛ́fàkari ndǔ nywɔp ɛnɔ mɛ́njɨŋɨ yɛ̌ntɨkɨ mmu fá amɨk. ");
INSERT INTO kenNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Bák yɛ ka pě mpoknkɛm, mǎnɨk nɔkɔ mmʉɛt bɛ mǎmbɔ́ŋ bɛtaŋ bɛ́bʉɛ mɛnyɨŋ ɛbhɛn bɛbhɔŋɔ bɛfakari, mǎnte bɛsí Mmu anɛ áfú ntá Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yɛ̌ntɨkɨ nywɔp Yesu are tɔ́ŋ bo amɛm ɛkɛrákap Mandɛm. Ɛ́ghaka nɔkɔ běku, ankó andɔk ambʉrɛ amfay njiɛ mɛnɔk Ólif. ");
INSERT INTO kenNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nɛ nɛ́yí nɔ́kɔ́, bo mámpu mandɔk ntá yi amɛm ɛkɛrákap Mandɛm ndu bɛghok mɛnyɨŋ ɛbhɛn yi átɔ̀ŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Mpok anɛ bo Israɛl mányìɛ̀ ɛpǎ Brɛt anɛ kɛbhɔŋ yís arɔp kɛkwɔt. Bábhɨŋɨ ɛpǎ yɔ bɛ, *Nɛkɨŋɨ. ");
INSERT INTO kenNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Bǒ batí bachiǎkap Mandɛm nɛ batɔŋ ɛbhé Mandɛm báré yaŋ mbi bɛway Yesu bhɛ́sɛ́ bhɛ́sɛ́ mbɔnyunɛ báchày nyaka ɛnyɨŋ ɛnɛ bo bakway bɛkʉ. ");
INSERT INTO kenNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Satan akó anti Júdas anɛ mpɨ́kɨ́rí nnyɛ́n ɛni nɛchi bɛ Iskariɔt. Júdas achi nyaka mmu amɔt ndǔ nkwɔ baghɔk Yesu bati byo nɛ apay. ");
INSERT INTO kenNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Arɔk anyiɛ́ bɛti nɛ bǒbati bachiǎkap Mandɛm nɛ bǒbati batɛmɛ́ nɛnu abhɛn bábhàbhɛri ɛkɛrákap Mandɛm, ɛnyu yi ákway bɛti Yesu ntá yap. ");
INSERT INTO kenNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bábhɔ́ŋ maŋák tontó, nɛ báká bɛchyɛ yi nkáp. ");
INSERT INTO kenNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Júdas aka nɛ bhɔ́. Abho bɛyaŋ mbi ndu bɛ́tí Yesu ntá yap ndǔ mpok anɛ ngɛ́mtay bho bapu ghɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nywɔp Brɛt anɛ ábhɨ́kɨ́ bhɔŋ yís nɛ́kwáy. Ndu nywɔp ɛnɔ kɛ̌ báwày nyaka mɔ́nkwɔmɛ́n anɛ Ɛpǎ Nɛkɨŋɨ, ");
INSERT INTO kenNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu ató yɛ Píta nɛ Jɔ̌n nɛ ɛyɔŋ bɛ, “Dɔ́k ká toŋtí mɛnyɨŋ bɛ́ sɛ́nyíɛ́ Ɛpǎ Nɛkɨŋɨ.” ");
INSERT INTO kenNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bábhɛp yi bɛ, “Ɔ̌yàŋ sɛ́ntóŋtí yɔ́ fá?” ");
INSERT INTO kenNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesu akɛmɛ bhɔ bɛ, “Yɨŋɨ́ ká, nɛchwe anɛ bǎchwé ɛtɔk, chɔŋ mǎngɔ́ mmu anɛ ápɔ́kɔ́ ɛjɔ̌ manyiɛp. Koŋó ká yi kpátɛ ɛkɛt ɛnɛ́ yi áchwe, ");
INSERT INTO kenNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","mǎngati mbɔŋɔ́kɛt bɛ, ‘Ntɔŋ ǎto bhɛsɛ bɛ sɛ́mbɛp wɔ bɛ, mɔ́kɛrɛ́ mankɔ anɛ mbɔ́ŋɔ́ mɛ́nyiɛ Ɛpǎ Nɛkɨŋɨ nɛ baghɔk abha achí fá?’ ");
INSERT INTO kenNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Chɔŋ antɔ́ŋ be mɔ́kɛt anɛ achi amfay nɛ achɨk anɛ bǎbhɔ́ŋɔ́ bɛsɔbhɛri. Toŋtí ká yɛ̌ntɨkɨ ɛnyɨŋ arɛ́.” ");
INSERT INTO kenNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bárɔ́k, baghɔ yɛ̌ntɨkɨ ɛnyɨŋ mbɔ ɛnyǔ yi aghati bhɔ. Bátóŋti Ɛpǎ Nɛkɨŋɨ arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Mpok ákwáy nɔ́kɔ́, Yesu achɔkɔ ndu ɛ́fɛ́mɛ́ nɛnyiɛ nɛ bǒnto. ");
INSERT INTO kenNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Aghati bhɔ bɛ, “Nnáŋ njǎŋ mɛnyiɛ Ɛpǎ Nɛkɨŋɨ ɛnɛ́ nɛ bhe tontó kɛ nchwe ndǔ ɛsɔŋɔri. ");
INSERT INTO kenNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nchí ghati bhe bɛ, mpú pɛrɛ nyiɛ́ chɔŋ Ɛpǎ Nɛkɨŋɨ kpátɛ mpok Mandɛm ákʉ̀ bo mándɨŋɨ ntí ɛpǎ ɛnɛ, nɔ́ chi mpok yi ábhák Mfɔ bǒ mankɛm.” ");
INSERT INTO kenNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yesu asɔt yɛ nkɔ́p nɛ mmɛ́m amɛm. Áchyɛ́ nɔ́kɔ́ bakak ntá Mandɛm, achyɛ ntá bǒnto andɛmɛ nɔkɔ bɛ, “Sɔt ka nyú, ntɨ anyǔ anchyɛ ntɨ. ");
INSERT INTO kenNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nchí ghati bhe bɛ, bɛ́bhó ɛchɔŋ, mpú pɛrɛ nyú mmɛ́mɛn kpátɛ mpok anɛ Mandɛm abhak Mfɔ bo mankɛm.” ");
INSERT INTO kenNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Asɔt yɛ ɛkpɔkɔ́ brɛd. Achyɛ bakak ntá Mandɛm. Are bɔkɔti anchyɛ nɔkɔ ntá baghɔkɔ́ bhi, andɛm nɔkɔ bɛ, “Brɛt-nɛ até ndǔ mmʉɛt ɛya anɛ nchí chyɛ mbɔ akap ɛ̌ti yɛka. Mǎndɔp, mǎnkʉ nɔkɔ ɛnyunɛ ndu bɛ́tɨk mɛ.” ");
INSERT INTO kenNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Mánáŋá nɔ́kɔ́ mɛ́nyiɛ́ nɛnyíɛ́, asɔt nkɔ́p nɛ mmɛ́m amɛm, achyɛ bakak ntá Mandɛm nkúbhɛ́ mbɔ ɛnyǔ yí ákʉ́ nɛ nɛnyíɛ́. Arɛm bɛ, “Nɛ́ chí Nku Nkɔ anɛ Mandɛm ányú nɛ bǒ mmɨk ɛ̌ti nɛwú ɛna ndu bɛtɔŋ bɛ chɔŋ ankʉ *Nku Nkɔ anɛ yi ányú nɛ bo ante. ");
INSERT INTO kenNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kɛ mmu anɛ átì mɛ achí fá chɔkɔ ǎnyìɛ nɛnyíɛ́ nɛ mɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nchí rɛm nɔ mbɔnyunɛ chɔŋ Mɛ Mmu mfú ntá Mandɛm ngu mbɔ ɛnyǔ yi árɛ́mɛ́. Kɛ chɔŋ ɛ́mbɛ́p ɛncha ntá mmu wu nɔ átì mɛ ntá bǒmpap abha!” ");
INSERT INTO kenNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Bǒnto bábhó bɛbhɛp batɨ bɛ, “Ntɨkɨ mmǔ ywɛsɛ ákway bɛkʉ anɛ ɛnyǔ ndak ntá yi e?” ");
INSERT INTO kenNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Baghɔkɔ Yesu babho bɛkɛm ɛpʉ́ítí nɛ batɨ ndu bɛ́rɨŋɨ mmu wap anɛ áchá abhɛnɛfu. ");
INSERT INTO kenNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu arɛm ntá yap bɛ, “Bafɔ abhɛn bɛtɔkɔ́ mmɨk babhɔŋ bɛtaŋ amfay bǒbhap nɛ yɛ̌ntɨkɨ mmu anɛ ábhɔ́ŋɔ́ bɛtaŋ amfay bho, ǎyàŋ mámbɨŋɨ yi bɛ, ‘Nkwaka-bho.’ ");
INSERT INTO kenNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kɛ ɛ́kɛ́ bhák nɔ nɛ bhe. Mǔngo ywɛka abhɔŋ bɛbhak mbɔ mɔ́nkwɛn ndǔ nkwɔ ywɛka, mǔnti ambak mbɔ mǔbɛtok. ");
INSERT INTO kenNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Agha áchá ntɨ? Mmǔ anɛ báfʉɛ̀t yi nɛnyíɛ́ kɛ anɛ áfʉɛ̀t nɛnyíɛ́? Pú anɛ áchɔkɔ mámfʉɛt yi nɛnyíɛ́? Kɛ nchí nɛ bhe mbɔ mǔbɛtok. ");
INSERT INTO kenNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Bě kɛ̌ bǎté nɛ mɛ ndǔ bɛsɔŋɔri bha mɛnkɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nɛ nkúbhɛ́ mbɔ ɛnyu Ɛtaya áchyɛ́ mɛ bɛtaŋ mɛnyiɛ kɛfɔ, ɛnyu yɔ kɛ̌ nchí kʉ chɔŋ bɛ be nkwɔ́ manyíɛ́ kɛfɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Chɔŋ mǎnyiɛ nɛ mǎnyú nɛ mɛ nɛbhʉɛt amɔt ndǔ ɛpǎ kɛfɔ ɛya, nɛ mǎnchɔkɔ nkwɔ ndǔ mɛnɔkɔ́ kɛfɔ ndu bɛkɛm manɛrɛ́kɛt Israɛl byo nɛ apay.” ");
INSERT INTO kenNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ɛ́tárɛ́ nɔ́kɔ́, Yesu arɛm ntá Píta bɛ, “Símun, Símun, ghók! Báchyɛ́ Satan bɛtaŋ bɛ́ ámɔ́ bhe, amfap abhɛ́n bárɨ́ nɛ abhɛn babɛbhɛ mbɔ mmǔ ǎnyɨ̀kɨsi kasárá ndu bɛsɔt anɛ yi ághàŋ gari. ");
INSERT INTO kenNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kɛ nnɨkmʉɛt ɛ̌ti yɛ bɛ́ ɔ́kɛ́ rɔ bɛ́bhɔŋ nɛka nɛ mɛ. Nɛ ɔ́náŋ ɔ́mpɛ́tnsɛm ntá ya, ɔ́kɛ́ rɔ bɛfyɛ bɔ̌mayɛ ntɨ.” ");
INSERT INTO kenNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Píta akɛmɛ yi bɛ, “Acha, yɛ̌ báfyɛ̀ wɔ chi ɛkɛrɛ́kɛnɔŋ, yɛ báwày wɔ wáy, mɛ̌gú chi nɛ wɔ.” ");
INSERT INTO kenNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu aghati yí bɛ, “Píta, dɨŋɨ bɛ́ nkɔk apɛrɛ́ kók bɛtǐ ɛbhɛn, chɔŋ ɔ́ndɛm ndɔŋ ɛ́rát bɛ ɔbhɨ́kɨ́ rɨŋɨ mɛ.” ");
INSERT INTO kenNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesu abhɛ́p baghɔkɔ́ bhi bɛ, “Mpok ntó bhe pósá ti, ɛbha ti, nkwɔbhánya bɛkak ti, bǎchɛp nyaka yɛ̌nyɨŋ kɛ?” Bákɛ́mɛ yi bɛ, “Wáwák.” ");
INSERT INTO kenNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Aghati yɛ bhɔ bɛ, “Kɛ nɛ́nɛ, mmǔ anɛ ábhɔ́ŋɔ́ nkáp ankɛm wu amʉɛt. Mmǔ anɛ ábhɔ́ŋɔ́ ɛbhǎ nɛkɔ ánsɔ́t yɔ. Anɛ ábhɨ́kɨ́ bhɔŋ akparɛnja, ántí ndɛ́ yi anku akparɛnja. ");
INSERT INTO kenNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nchí ghati bhe bɛ ɛnyɨŋ ɛnɛ básɨ́ŋɨ́ ndǔ Ɛkáti Mandɛm ɛ̌ti ya, ɛbhɔŋ bɛfu tɛtɛp. Nɔ chi ɛnɛ́ ɛ́rɛ̀m bɛ, ‘Básɔt yi mbɔ nkʉ bɛbʉ́ amɔt.’ Mɛnyɨŋ ɛbhɛn básɨ́ŋɨ́ ɛ̌ti ya bɛ́bhɔŋ bɛfu tɛtɛp.” ");
INSERT INTO kenNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Baghɔkɔ́ bhi barɛm bɛ, “Acha, ghɔ́ bɔakparɛnja bapay fá.” Aghati bhɔ́ bɛ, “Dɔ̌ ká nɔ.” ");
INSERT INTO kenNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu afa yɛ arɔk amfay Njiɛ Mɛnok Ólif mbɔ ɛnyu ɛsɨ́. Baghɔkɔ́ bhi barɔk nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Arɛ́, aghati bhɔ bɛ, “Nɨk nɔ́kɔ́ ká mmʉɛt bɛ mbák nɛmɔ nɛ́twɔ bǎkɛ́ kwɛn.” ");
INSERT INTO kenNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Árɛ́mɛ́ nɔ́kɔ́ nɔ́, arɔ bhɔ, atɛ́n mmʉɛt ambɨ mandú, mbɔ ndǔ nɛbhʉɛt anɛ ɔ́tɛ́m ntay nɛngaka. Atɛp mánɛ́n amɨk, abho mɛnɨkmʉɛt bɛ, ");
INSERT INTO kenNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ɛtaya, mbák ɔkɔŋ, fɛrɛ́ nkɔ́p ɛsɔŋɔri nɛ bɛ́ ámfórí mɛ. Kɛ ɔ́kɛ́ kʉ ɛnyɨŋ ɛnɛ mɛ̌yáŋ, kʉ chi ɛnɛ́ wɔmbɔŋ ɔ́yàŋ.” ");
INSERT INTO kenNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ɛnɛ́ yi ánɨ̀kmʉɛt nɔ, ángɛl Mandɛm abhesi yi bɛsí, afyɛ́ yi ntɨ. ");
INSERT INTO kenNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Nɛ ndǔ bɛyǎ basɛmɛ, are nɨkmʉɛt nɛ ntɨ ɛni nɛnkɛm. Nsɔ́ŋtí anɛ áfú yi amʉɛt are chɨti amɨk mbɔ bakɔŋ manoŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ánáŋá nɔ́kɔ́ mɛnɨkmʉɛt, afate, apɛtnsɛm ndǔ nɛbhʉɛt anɛ yí árɔ́ baghɔkɔ́ bhi. Aghɔ bhɔ ndu bábhʉrɛ kɛnɔ́ ndu mánáŋ bápɔ́bhɛ́ ɛ̌ti bɛyǎ basɛ́mɛ́. ");
INSERT INTO kenNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Yesu abhɛ́p bhɔ́ bɛ, “Ndaká yí bǎbhʉ̀rɛ kɛnɔ́? Faté ká, mǎnɨkmʉɛt bɛ nɛmɔ nɛ́ntwɔ́, bǎkɛ́ kwɛn.” ");
INSERT INTO kenNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ɛnɛ́ Yesu abhʉɛ́t bɛrɛm nɔ nɛ baghɔkɔ́ bhi, ɛká bho ɛ́chwɔ́p. Júdas, mmu amɔt ndǔ nkwɔ baghɔk Yesu batí byó nɛ apay, abhak bɔ ambɨ. Arɔk kɛkwɔt nɛ Yesu ndu bɛ́bhɛ́nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Kɛ Yesu abhɛp yi bɛ, “Júdas, ɔ̌bhɛ̀nɛ Mɛ Mmu mfú ntá Mandɛm ndu bɛti mɛ ntá bǒmpap abha?” ");
INSERT INTO kenNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Baghɔkɔ́ bhi bághɔ́ nɔ́kɔ́ ɛnyɨŋ ɛnɛ ɛ́twɔ̀ fakari, bábhɛ́p yi bɛ, “Acha, sɛ́nsɔ́t bɔakparɛnja bhɛsɛ sɛnu nɛ bǒbhɛn-ɛ?” ");
INSERT INTO kenNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Mmǔ wap amɔt agwɔp akparɛnja ywi. Akpɔ́t atú nsɛ̌m mǔngo bachiǎkap Mandɛm chwát agʉɛ́p amɨk. ");
INSERT INTO kenNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Kɛ Yesu aghati bhɔ bɛ, “Dɔ̌ ká nɔ!” Atɔk yɛ atú mmu wu, abu yi. ");
INSERT INTO kenNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yesu abhɛ́p yɛ bǒbati bachiǎkap Mandɛm nɛ bǒbati batɛmɛ́ nɛnu abhɛn bábhàbhɛri ɛkɛrákap Mandɛm nɛ bǒbati ɛtɔk abhɛn bátwɔ́ bɛkɛm yi bɛ, “Bǎtwɔ bɛkɛm mɛ nɛ bɔakparɛnja nɛ nkɨ́k mbɔ bɛ nchí chí ngɛ́bhɛ ntantaŋ? ");
INSERT INTO kenNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mpok nchí nɛ bhe amɛm ɛkɛrákap Mandɛm nɛ́nji nɛnji, bǎbhɨ́kɨ́ kɛm mɛ. Kɛ mpok yɛka nɛ Satan, mfɔ ɛjuri, akway nɛ́nɛ.” ");
INSERT INTO kenNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Bǒbhɔ bákɛ́m yɛ́ Yesu, bábhó bɛrɔŋ ndǔ ɛkɛt ɛnɛ mǔngo bachiǎkap Mandɛm. Píta are koŋo bhɔ ansɛm nɛkɔ nɛsiɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Bábháyti ngó nɛntɨ sɛnta. Bo báchɔ́kɔ nɛpaká ngó mángwaka nɔkɔ ngo. Píta achɔkɔ arɛ́ nɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ngɔrɛ́ bɛtok amɔt anɛ achi arɛ, aghɔ́ Píta nkwɔ arɛ́ chɔkɔ ndǔ ngo ághɔ̀ yi amʉɛt. Áyɨ́ŋɨ́ yi dǐǐ, arɛm bɛ, “Mɔ́nkwǎnɛ nkwɔ́ achi mbʉ nɛ Yesu.” ");
INSERT INTO kenNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Píta ataŋa, arɛm bɛ, “Mma, mbɨ́kɨ́ rɨŋɨ yi.” ");
INSERT INTO kenNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ɛ́bhɨ́kɨ́ tat, mmǔ achak aghɔ́ Píta arɛm bɛ, “Wɔ nkwɔ ɔchí mmǔ ywi amɔt.” Píta akɛmɛ yi bɛ, “Cháá, mpú nɛ bhɔ” ");
INSERT INTO kenNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ɛ́fʉɛ́rɛ́ nɔkɔ mbɔ nɛŋɔkɔ́ nywɔp nɛmɔt, mmǔ achak arɛm bɛ, “Tɛtɛp, mmǔ-nɛ nkwɔ́ achi mbʉ nɛ Yesu. Yi nkwɔ chi mmu Gálili.” ");
INSERT INTO kenNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Píta aghati yi bɛ, “Nkwǎnɛ, mbɨ́kɨ́ rɨŋɨ ɛnyɨŋ ɛnɛ wɔ ɔ́rɛ̀m!” Tɛ́mté wu, ɛnɛ́ yi ábhʉɛ́t bɛrɛm ɛnyɨŋ ɛnɛ yi árɛ̀m, nkɔk akók. ");
INSERT INTO kenNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Acha ayibhiri mmʉɛ́t ayɨŋɨ Píta. Amɨ́k ayap átɛ́mɛ́ri. Píta atɨk ɛnyɨŋ ɛnɛ Yesu ághátí yi bɛ, “Nkɔk apɛrɛ́ kók bɛti ɛbhɛn, chɔŋ ɔ́ndɛm ndɔŋ ɛrat bɛ ɔbhɨ́kɨ́ rɨŋɨ mɛ.” ");
INSERT INTO kenNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Afú nɛfí, adi kɛbhɔ, nɛ bɛyǎ basɛ́mɛ́ antɨ. ");
INSERT INTO kenNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Batɛmɛ́ nɛnu abhɛn bábhàbhɛri Yesu bábho bɛyɔkɔ yi nɛ mándɛnɛ nɔkɔ yi nɛ ɛ́kpá. ");
INSERT INTO kenNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bágwɔ́t yi amɨ́k nkwɔ, mámbɛbhɛ nɔkɔ yi bɛ, “Wɔ mmu ɔ́chí ndɛmɛkɛpɨ̌ntɨ, ghatí bhɛsɛ! Agha ádɛ́bhɛ́ nɔ́ wɔ?” ");
INSERT INTO kenNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Bárɛ́m bɛyǎ mɛnyɨŋ bɛchak, mánso nɔkɔ yi nɛ nsɔk. ");
INSERT INTO kenNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nɛ́yí nɔ́kɔ́, bǒbati ɛtɔk, bǒ batí bachiǎkap Mandɛm nɛ batɔŋ ɛbhé Mandɛm bákɛ́m ɛchɛmɛ ɛghǒ yap. Básɔ́t Yesu barɔk arɛ́ nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Bábhɛ́p yi bɛ, “Ghatí bhɛsɛ, ɔchí Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò?” Akɛmɛ bhɔ bɛ, “Mbák ngátí bhe bǎpú noko; ");
INSERT INTO kenNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","nɛ mbák mbɛ́p bé ɛnyɨŋ, bapú kɛmɛ mɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kɛ bɛ́bhó ɛchɔŋ, chɔŋ Mandɛm Bɛtaŋ Mɛnkɛm amfyɛ́ Mɛ Mmu mfú amfay nchɔkɔ ndǔ nɛbhʉɛt bɛyǎ kɛnókó, ɛbhě awɔ́nɛm ɛyi.” ");
INSERT INTO kenNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Bɔ́ mankɛm babhɛp yi bɛ, “Nɔ́ ɔchí Mmɔ̌ Mandɛm-ɛ?” Yesu akɛmɛ bhɔ bɛ, “Ɛchi mbɔ ɛnyǔ bǎrɛ́mɛ́.” ");
INSERT INTO kenNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Bɔ́ bárɛ́m bɛ, “Sɛ́pɛ́t sɛ́yàŋ batísiɛ́ mántwɔ́ mándɛ́m ɛnyɨŋ ɛnɛ yi ákʉ́ ndaká yí? Bɛsɛ́ babhɔŋ sɛ́ghok nɛ batú ɛnyɨŋ ɛnɛ ɛ́fú yi anyu.” ");
INSERT INTO kenNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nkwɔ́ bataŋá manyé bárɛ́m nɔ́kɔ́ nɔ́, bɔ̌ mankɛm báfáte, básɔt Yesu báré rɔ́ŋ ntá Páílet nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Bábhó bɛbhat yi barak amʉɛt mándɛmɛ nɔkɔ bɛ, “Sɛghɔ̌, mmǔ-nɛ ndu ákʉ̀ bɛ bǒ bhɛsɛ bákɛ́ bhʉɛrɛ bɛbhé ɛtɔk. Ǎkàŋ nkwɔ bɛ́ bo bákɛ́ chyɛ nkábhɛ́nti ntá Sísa, Mfɔ Rom. Nɛ árɛ̀m bɛ yí achi Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò, nɔ́ chi bɛ achí Mfɔ.” ");
INSERT INTO kenNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Páílet abhɛ́p yɛ Yesu bɛ, “Wɔ kɛ ɔ́chí nɛ́ Mfɔ bo Israɛl?” Akɛmɛ bɛ, “Ɛ́chí mbɔ ɛnyu ɔ́rɛ́mɛ́.” ");
INSERT INTO kenNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Páílet arɛm yɛ ntá bǒbati bachiǎkap Mandɛm nɛ ngɛ́mtay bo abhɛn bachi arɛ bɛ, “Mbɨ́kɨ́ ghɔ yɛ̌ bɛkwɛ́nɛ́ nɛ mmǔ-nɛ.” ");
INSERT INTO kenNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kɛ bárɔ́k ambɨ bɛkɛmɛ bɛ, “Ǎkɔ̀ atú Judɛ́ya ankɛm antɔŋ nɔkɔ bho ndu mɛ́nyɨ́kɨ́si batɨ̌ yap amɛm bɛ mángʉ́ɛ́p ɛsɔŋɔri ɛtɔk. Akʉ nɔ́, bɛbho atú Gálili kpát bɛ́gháka fá Yerúsalɛm.” ");
INSERT INTO kenNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Páílet ághókó nɔ́kɔ́ mɛnyɨŋ ɛbhɛn, abhɛ́p bhɔ mbák Yesu achi mmu atú Gálili. ");
INSERT INTO kenNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Árɨ́ŋɨ́ nɔ́kɔ́ bɛ́ Yesu afǔ atú ɛtɔk ɛnɛ Hɛ́rɔd achi mfɔ arɛ́, achyɛ ɛyɔŋ bɛ mandɔk nɛ yi ntá Hɛ́rɔd. Mbɔŋ Hɛ́rɔd achi nyaka Yerúsalɛm mpok yɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Hɛ́rɔd ághɔ́ nɔ́kɔ́ Yesu, ábhɔ́ŋ maŋák tontó, mbɔnyunɛ anáŋ ǎghòk nyaka ɛ̌ti yi nɛ abhɔ́ŋ ɛkwak tɛntɛp bɛghɔ yi nɛ amɨ́k. Ǎbhàka nyaka ntɨ bɛ chɔŋ Yesu ankʉ ɛnyɨŋɨ́ maknkay yí angɔ́. ");
INSERT INTO kenNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ɛ́kʉ́ Hɛ́rɔd abhɛ́p Yesu bɛyǎ bɛbhɛp kɛ yɛ ɛ́mɔt Yesu ábhɨ́kɨ́ kɛmɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ɛnɛ́ Hɛ́rɔd árɔ̀ŋ ambɨ bɛbhɛp yi bɛbhɛp, bǒbati bachiǎkap Mandɛm nɛ batɔŋ ɛbhé Mandɛm báte kɛkwɔt, mámbat nɔkɔ yi barak amʉɛt nɛ bɛyǎ ɛ̌yu. ");
INSERT INTO kenNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hɛ́rɔd nɛ batɛmɛ́ nɛnu bhi báré byak yi, mámfyɛ nɔkɔ yí ɛtáŋɔk. Mámɛ́sɛ yi nkú kɛfɔ amʉɛt. Arɛm bɛ́ mánsɔ́t yí mámpɛtnsɛm ntá Páílet nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kɛmmʉɛrɛ Hɛ́rɔd nɛ Páílet kɛ́bho ndǔ nkúbhɛ́ nywɔp ɛnɔ. Ndǔ mpok anɛ áfʉɛ́rɛ́ ansɛm bachi nyaka chi ndǔ mpap. ");
INSERT INTO kenNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Bápɛ́rɛ́ nɔ́kɔ́ nsɛm ntá Páílet nɛ Yesu, Páílet ató bábhɨ́ŋɨ bǒbati bachiǎkap Mandɛm nɛ bǒbati ɛtɔk nɛ bǒ ɛtɔk. ");
INSERT INTO kenNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Arɛm ntá yap bɛ, “Bǎtwɔ̀ fá ntá ya nɛ mmǔ-nɛ bɛ ǎkʉ̀ bo bákɛ́ bhʉɛrɛ bɛbhé ɛtɔk. Mbɛ̌p yi mɛnyɨŋ bɛsí bhɛka, nɛ mbɨ́kɨ́ ghɔ́ yɛ̌ bɛkwɛ́nɛ́ ɛbhě yi. ");
INSERT INTO kenNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Mfɔ Hɛ́rɔd nkwɔ́ abhɨ́kɨ́ ghɔ yɛ̌ bɛkwɛ́nɛ́ ɛbhě yi mbɔnyunɛ atǒ yi apɛtnsɛm ntá ya. Nchí ghati bhe bɛ yɛ̌nyɨŋ yi abhɨ́kɨ́ kʉ ɛnɛ́ ɛ́tɔ̀ŋ bɛ mangway yi. ");
INSERT INTO kenNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Chɔŋ nchyɛ́ ɛyɔŋ bɛ mándɛ́n yi, mámfɛrɛ yi amɔ.” ");
INSERT INTO kenNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ɛpɨŋɨ́ bo Israɛl ɛ́chí nyaka bɛ, yɛ̌ntɨkɨ mpok anɛ bɔ́ mányìɛ̀ Ɛpǎ Nɛkɨŋɨ, Páílet abhɔŋ bɛ́fɛ́rɛ mmu amɔt anɛ bǒ Yerusalɛm báyàŋ yi amfɛrɛ ɛkɛrɛ́kɛnɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Bɔ́ mankɛm bábɨ́k mándɛmɛ nɔkɔ bɛ, “Dɔ̌ mángwáy yi. Fɛrɛ́ bhɛsɛ chi Barábas!” ");
INSERT INTO kenNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barábas chi mmu anɛ báfyɛ́ nyaka ɛkɛrɛ́kɛnɔŋ ndǔ barak apay, “Agʉɛbhɛ́ nyaka ɛbyɔk ɛtɔk, nɛ awáy mmu.” ");
INSERT INTO kenNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Páílet apɛt arɛm kɛpɨ ntá yap nɛ nkaysi bɛ́fɛ́rɛ Yesu amɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kɛ bárɔ́k ambɨ bɛbɨk bɛ, “Dɛm mángó yi ndǔ ɛkotákátí! Mángó yi ndǔ ɛkotákátí!” ");
INSERT INTO kenNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ndǔ ndɔŋ anɛ ájwí ɛ́rát Páílet arɛm bɛ, “Ntɨkɨ ɛbɛ́ptí ndak yi ákʉ́? Mbɨ́kɨ́ ghɔ́ yɛ̌ ɛ́bɛ́ptí ɛnyɨŋ ɛnɛ yi ákʉ́ ɛnɛ ɛ́tɔ̀ŋ bɛ́ mángwáy yi. Chɔŋ nchyɛ́ ɛyɔŋ mándɛ́n yi nɛ ɛ́kpá, mámfɛrɛ yi amɔ.” ");
INSERT INTO kenNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kɛ bárɔ́k ambɨ bɛkpɛmɛ, mambɨkɨ nɔkɔ bɛ Páílet andɔ mango yi ndǔ ɛkotákátí. Bǎri map anyiɛrɛ Páílet, awupsi ntɨ. ");
INSERT INTO kenNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Áká yɛ bɛ́ mánkʉ́ nɛ Yesu mbɔ ɛnyu bakɔŋɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Afɛrɛ Barábas mmu ágʉ́ɛbhɛ́ ɛbyɔk ɛtɔk nɛ awáy mmu, ɛkɛrɛ́kɛnɔŋ, mbɔ ɛnyu bɔ báyàŋ. Achyɛ Yesu ntá bo Israɛl bɛ mánkʉ nɛ yi mbɔ ɛnyu bákɔ́ŋɔ́. ");
INSERT INTO kenNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Batɛmɛ́ nɛnu básɔ́t Yesu báre rɔ́ŋ nɛ yi. Ndu bárɔ̀ŋ, bátɛ́mɛri mmǔ ɛtɔk Sírene amɔt anɛ áká nnyɛ́n bɛ Símun. Áfǔ nyaka ɛbhɨ ǎpɛtnsɛm anywɔ́p, Yerúsalɛm. Bákɛ́m yi bábáyti nɛ ɛko Yesu, bákʉ yi apɔkɔ yɔ́ ankoŋo nɔkɔ Yesu. ");
INSERT INTO kenNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ngɛ́mtáy bhó báre koŋo Yesu ansɛm. Mbɔk yap bábhák baghɔrɛ́ abhɛn básɛ̀mɛ nyaka, mándi nɔkɔ yi. ");
INSERT INTO kenNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Kɛ Yesu ayibhiri mmʉɛt arɛm ntá baghɔrɛ́ bhɔ bɛ, “Baghɔrɛ Yerúsalɛm, bǎkɛ́ di mɛ! Dí ká chí mmʉɛt ɛyɛka nɛ bɔ̌bhɛka. ");
INSERT INTO kenNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Nchí ghati bhe bɛ mpok ǎtwɔ̀ anɛ bo bárɛ̀m chɔŋ bɛ, ‘Ɛ́rɨ ntá yɛntɨkɨ nkongɔrɛ́ nɛ yɛ̌ntɨkɨ ngɔrɛ́ anɛ ábhɨ́kɨ́ re bhé!’ ");
INSERT INTO kenNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ndǔ mpok yɔ, chɔŋ bo mándɛm ntá njiɛ ɛgho bɛ, ‘Kwɛ́n ká bay bhɛsɛ́’; nɛ ntá bɔ̌njiɛ bɛ, ‘Kutí ká bhɛsɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Bo bárɛ̀m chɔŋ nɔ́, mbɔnyunɛ, mbák bákwày bɛ́kʉ mɛnyɨŋ ɛbhɛn ntá ya, Mmɛ mmu nchí ɛnɔk ɛbɨk, chɔŋ ɛ́mbak ná nɛ ɛnɛ́ ɛ́gú?” ");
INSERT INTO kenNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ɛnɛ́ bárɔ̀ŋ nɔ, basɔt bakʉ̌ bɛbʉ́ bati apay nkwɔ abhɛn batɛmɛ́ nɛnu bárɔ̀ŋ nyaka bɛway nɛ Yesu. ");
INSERT INTO kenNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Bágháká nɔ́kɔ́ ndǔ njiɛ anɛ bábhɨ̀ŋɨ bɛ *Ɛ̌nkɔ́nti, bágó Yesu ndǔ ɛkotákátí. Bágó nkwɔ́ bakʉ̌ bɛbʉ́ bhɔ bati apay, yɛ̌ntɨkɨ mmu wap ndǔ ɛyi ɛkotákátí, amɔt ɛbhě awɔ́nɛm Yesu, achák ɛbhě awɔ́ghɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Arɛ́, amfǎy ɛkotákátí, Yesu anɨkmʉɛt ntá Mandɛm bɛ, “Ɛta, foŋorí bhɔ́, mbɔnyunɛ bábhɨ́kɨ́ rɨŋɨ ɛnyɨŋ ɛnɛ bákʉ̀.” Batɛmɛ́ nɛnu bágʉɛp ɛbháŋá ndu bɛ́rɨŋɨ ɛnyu bábhɔ́ŋɔ́ bɛ́kɔ́rɛ ndɛn Yesu. ");
INSERT INTO kenNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bo bábhák arɛ́ tee mámkpɔkɔ nɔkɔ ɛnyɨŋ ɛnɛ́ ɛ́fàkari. Kɛ bǒbati báré way yí way mándɛmɛ nɔkɔ bɛ, “Ǎpɛ̀mɛ nyaka bo bachak! Ámpɛ́mɛ́ mmʉɛt ɛyi mbák achi Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò, Mmu Mandɛm Ayabhɛ!” ");
INSERT INTO kenNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Batɛmɛ́ nɛnu nkwɔ báré way Yesu, mándɔkɔ nɔkɔ bɛchyɛ yi mmɛ̌m amɛn ábáká. ");
INSERT INTO kenNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Nɛ mándɛmɛ nɔkɔ bɛ, “Mbák tɛtɛp ɔchí Mfɔ bo Israɛl, pɛmɛ́ mmʉɛt ɛyɛ!” ");
INSERT INTO kenNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Amfay ntí Yesu, ɛbhɔ́kɛnɔk ɛbhak babhát ndǔ ɛko ɛnɛ básɨ́ŋɨ́ arɛ bɛ: “Nɛ́ chi Mfɔ bo Israɛl.” ");
INSERT INTO kenNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nkʉ-bɛbʉ́ amɔt anɛ áchi nkwɔ́ kpaŋkpáŋ ndǔ ɛyǐ ɛkotákátí are way Yesu andɛmɛ nɔkɔ bɛ, “Pú wɔ kɛ ɔ́chí Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò? Pɛmɛ́ mmʉɛt ɛyɛ, ɔ́mpɛmɛ bhɛsɛ́ nkwɔ bhɔ!” ");
INSERT INTO kenNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kɛ mmʉ̌ bɛbʉ́ achák wu are sayti yi bɛ, “Yɛ̌ndu ɔ́gù ndǔ ɛkotákátí mbɔ Yesu, ɔpú cháy Mandɛm-ɛ́? ");
INSERT INTO kenNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Wɔ nɛ mɛ sɛ́gù ɛ̌ti bɛpɔ̌ barak ayɛsɛ, kɛ mmǔ-nɛ abhɨ́kɨ́ kʉ yɛ̌ ɛbɛ́ptí ɛnyɨŋ?” ");
INSERT INTO kenNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Arɛm yɛ bɛ, “Yesu, ghɔ́ mɛ ntínso, mpok ɔ́bhak Mfɔ.” ");
INSERT INTO kenNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu aghati yí bɛ, “Nchí ghati wɔ bɛ, ɛchɔŋ, chɔŋ ɔ́mbak nɛ mɛ ndǔ nɛbhʉɛt maŋák anɛ bábhɨ̀ŋɨ bɛ Párádis.” ");
INSERT INTO kenNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ɛ́gháká nɔ́kɔ́ nkárɛ́nká byo nɛ ɛpay nɛ ngósí, mmok ánɛ́m, ɛjuri ɛ́kwɛn ɛkuti ɛtɔk ɛnkɛm kpátɛ nkárɛ́nká ɛ́rát beku, ");
INSERT INTO kenNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","mbɔnyunɛ mmok ábhɨ́kɨ́ pɛrɛ ghɔɔ. Nɛ ɛkát ɛnɛ ɛchi amɛm ɛkɛrákap Mandɛm ɛ́ghárɛ ndǔ bɛbhɔk bɛpay gbee. ");
INSERT INTO kenNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu abɨk arɛm bɛ, “Ɛtaya, ndɔ́ nɛpɛ́m ɛna amɔ́ yɛ!” Árɛ́m nɔ́kɔ́ nɔ́, asɛbhɛ. ");
INSERT INTO kenNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Mǔnti batɛmɛ́ nɛnu ághɔ́ nɔ́kɔ́ mɛnyɨŋ mɛnkɛm ɛbhɛn bɛfakari, abɨti Mandɛm, andɛmɛ nɔkɔ bɛ, “Tɛtɛp, mmǔ-nɛ achí mbʉ chak bɛsí Mandɛm!” ");
INSERT INTO kenNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ngɛ́mtay bo abhɛn báchɛ́mɛ́ nyaka arɛ ndu bɛghɔ, bághɔ́ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ ɛfakari. Bágúrɛ nɛ basɛ́mɛ́, mámbyaka nɔkɔ amɔ antɨ. ");
INSERT INTO kenNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Bǒ mankɛm abhɛn bárɨ́ŋɨ́ Yesu, nɛ baghɔrɛ́ abhɛn bábhó bɛkoŋo yi tɛ Gálili, báté nɛkɔ nɛsiɛ mángɔ nɔkɔ yɛ̌ntɨkɨ ɛnyɨŋ. ");
INSERT INTO kenNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Mmǔ amɔt achí nyaka Yerúsalɛm mpok yɔ. Aka nnyɛ́n bɛ Josɛ́f. Achi nyaka mmǔ Arimátia, ɛtɔk bo Israɛl. Abhak ndɨ̌ndu nɛ mmǔ chak nɛ ǎnòŋ nyaka mpok anɛ Mandɛm abhak Mfɔ bho. Abhak mmǔ amɔt ndǔ ɛchɛmɛ ɛgho ɛnɛ bǒ batí ɛtɔk. Kɛ ábhɨ́kɨ́ ka nyaka nɛ bhɔ ndǔ nkaysi yap nɛ nɛkʉ wap. ");
INSERT INTO kenNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yí arɔk ntá Páílet bɛ́ ánchyɛ́ yi bɛtaŋ amfɛrɛ Yesu amfǎy ɛkotákátí. Páílet áchyɛ́ nɔ́kɔ́ yi bɛtaŋ, ");
INSERT INTO kenNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","arɔk yɛ asɛbhɛ Yesu amɨk, anɛ́p yi nɛ ɛsyɛ̌ndɛn, arɔk afyɛ́ amɛm nnɛm ɛnɛ́n bátɛ́mɛ́ ndǔ sɛtárɛ́bhɛ́, kɛ kɛre bhɛmɛ yɛ̌ mmu arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ɛ́chí nyaka chi nywɔp ɛnɛn bo bátòŋti mɛnyɨŋ ɛbhɛn Nywɔbhɛ́ nɛywɛ̌mʉɛt, nɛ ɛ́rɔp chi mandú bɛgháká ndǔ mpok anɛ Nywɔbhɛ́ nɛywɛ̌mʉɛt nɛ́bho. ");
INSERT INTO kenNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Baghɔrɛ abhɛn báfú nɛ Yesu tɛ Gálili, bákóŋo, baghɔ nnɛm, nɛ ɛnyǔ bábhʉ́rɛ́ mmʉɛt yi amɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bápɛ́t yɛ nsɛm ndǔ nɛbhʉɛt anɛ báchɔ̀kɔ amɛm Yerúsalɛm. Bátóŋti bawɛt ɛrɨ́tí ɛriɛp amɛn báwati amʉɛt ngu. Nywɔbhɛ́ nɛywɛ̌mʉɛt ɛnap nɛ́gháká nɔ́kɔ́, báywěmʉɛt mbɔ ɛnyǔ ɛbhé Moses ɛ́rɛ̀m. ");
INSERT INTO kenNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nɛ nɛyǐnwyɔp ndǔ Nywɔbhɛ́ nɛywěmʉɛt, baghɔrɛ́ bhɔ básɔ́t bawɛrɛ́riɛp amɛn bɔ bághókó bárɔ́k ndǔ nnɛm Yesu nɛ nɛyǐnwyɔp. ");
INSERT INTO kenNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bághɔ́ bɛ ntay ɛnɛn anyǔ nnɛm nɛ́rɔp chi nɛpaká nnɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Báchwé amɛm nnɛm, kɛ bákɛ ghɔ mmʉɛt yi. ");
INSERT INTO kenNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ɛ́chá bhɔ ɛnyu bákʉ. Tɛ́mté wu, babhakanɛm bati apay nɛ ndɛn amʉɛt ɛnɛ́ ɛ́kɔ̀t ŋwaŋwǎŋwaŋ báté kɛkwɔt nɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Bɛcháy bɛ́kɛ́m baghɔrɛ́ bhɔ tontó. Bátɛ́p bati amɨk. Bǒ-bhɔ bábhɛ́p bhɔ bɛ, “Ndaká yí báyàŋ mmu anɛ achi nɛpɛ́m ndǔ nkwɔ́ bawú? ");
INSERT INTO kenNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Apú fá. Mandɛm akʉ yi apɛtnsɛm ndǔ nɛpɛ́m nkúbhɛ́ mbɔ ɛnyǔ yi árɛ́mɛ́ nyaka bɛ ɛbhɔŋ bɛfakari. Twɔ́ ká ghɔ nɛbhʉɛt anɛ bábhʉ́rɛ́ yi. Tɨ́k ka ndǔ yi ágháti bhe mpok ábhʉɛ́t atú Gálili nɛ bhe. ");
INSERT INTO kenNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Yi arɛm nyaka bɛ, chɔŋ mámfyɛ Mmu anɛ áfú ntá Mandɛm amɔ́ bǒ bɛbʉ́, mángó yi ndǔ ɛkotákátí, nɛ ɛ́ghaka nɔkɔ manywɔp arat, ampɛtnsɛm ndǔ nɛpɛ́m.” ");
INSERT INTO kenNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Baghɔrɛ́ bhɔ bátɨk yɛ bɛyɔŋ Yesu. ");
INSERT INTO kenNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Bápɛ́rɛ́ nɔ́kɔ́ nsɛm, bágháti mɛnyɨŋ ɛbhɛn bɛfakari ntá bǒnto Yesu bati byo nɛ amɔt nɛ bakoŋo bhi abhɛ́nɛ́fú mankɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Baghɔrɛ́ abhɛn bághátí nyaka bǒnto Yesu mbok yɔ chi María anɛ áfú ɛtɔk Mágdala, nɛ Joana, nɛ María nnɔ Jems, nɛ baghɔrɛ́ báchák abhɛn báchi nyaka nɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kɛ bǒnto básɔ́t ɛnyɨŋ ɛnɛ baghɔrɛ́ bhɔ bárɛ́mɛ́ mbɔ ɛráká ndak, bɔ́ kɛnókó wáwák. ");
INSERT INTO kenNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Yɛ̌ nɔ́, Píta afate, ajɛt arɔk ndǔ nnɛm. Ákúrí nɔ́kɔ́, agʉɛp amɨ́k, ayɨŋɨ amɛm nnɛm. Aghɔ́ bɛbhɔ́kɔ́ ndɛn ɛbhɛn mánɛ́bhɛ́ nyaka mmʉɛt Yesu nɛ bhɔ bhʉ́rɛ́. Apɛtnsɛm anywɔ́p, amakati nɔkɔ ɛnyɨŋ ɛ́nɛ́ ɛ́fákárí. ");
INSERT INTO kenNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nkúbhɛ́ ɛwak ɛyɔ, bakoŋo Yesu bati apay báfá Yerúsalɛm bare rɔŋ ndu mɔ́tɔk anɛ bábhìŋɨ bɛ Ɛmayus, nɛkɔ̌ ɛnɛn nɛchi mbɔ bɔkilɔ́mɛta nɛ́nɛnamɔt nɛ ɛbhɔ́k. ");
INSERT INTO kenNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Mándɛmɛ nɔkɔ ɛ̌ti mɛnyɨŋ mɛnkɛm ɛbhɛn bɛ́fákárí. ");
INSERT INTO kenNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ɛnɛ́ bárɛ̀m mánkɛm nɔkɔ ɛpʉ́ítí nɛ batɨ, mbɔŋ Yesu arɔk kɛkwɔt nɛ bhɔ ankɔ nɔkɔ nɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Kɛ ɛ́bhák mbɔ bɛ́ bágwɔt amɨ́k ayap. Bɔ́ kɛrɨŋɨ bɛ́ chí Yesu. ");
INSERT INTO kenNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Abhɛ́p bhɔ́ bɛ, “Ntɨkɨ ndak bǎkɔ̀ mǎndɛmɛ nɔkɔ ɛnyunɛ?” Báté nsónso. ");
INSERT INTO kenNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Mmu wap amɔt anɛ áká nnyɛ́n bɛ Klópas abhɛ́p yɛ yi bɛ, “Ndiɛrɛ wɔ kɛ ɔ́chí kɛnkɔ̌ anɛ átwɔ́ Yerúsalɛm anɛ ábhɨ́kɨ́ rɨŋɨ mɛnyɨŋ ɛbhɛn bɛfakari arɛ́ ndǔ manywɔbhɛ́-nɛ?” ");
INSERT INTO kenNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Abhɛ́p bɛ, “Ntɨkɨ mɛnyɨŋ?” Bákɛ́mɛ yi bɛ, “Mɛnyɨŋ ɛbhɛn bɛ́fákárí nɛ Yesu anɛ Násárɛt. Achi nyaka ndɛmɛkɛpɨ̌ntɨ Mandɛm, nɛ atɔ́ŋ bɛsí bho nɛ bɛsí Mandɛm bɛ bɛtaŋ Mandɛm bɛchi nɛ yi ndǔ mɛnyɨŋ ɛbhɛn yi árɛ̀m nɛ ɛbhɛn yi ákʉ̀. ");
INSERT INTO kenNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kɛ bǒbati bachiǎkap Mandɛm nɛ bǒ batí ɛtɔk abhɛsɛ bákɛ́m yi bachyɛ mangway, nɛ bágó yi ndǔ ɛkotákátí. ");
INSERT INTO kenNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Sɛ́bhaka nyaka ntɨ bɛ yí kɛ ábhɔ́ŋɔ́ bɛ́fɛ́rɛ bo Israɛl ndǔ ɛsɔŋɔri. Ɛ́chí nɛ́nɛ manywɔp arat ɛnɛ́ ndak anɛ́ áfákárí. ");
INSERT INTO kenNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ɛnyɨŋ ɛ́chák ɛ́chí bɛ́ mbɔk baghɔrɛ́ ndǔ nkwɔ ywɛsɛ bákʉ batí átaka bhɛsɛ amɛm. Bárɔ́k ndǔ nnɛm běti bheti, ");
INSERT INTO kenNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","kɛ bákɛ ghɔ Yesu. Bápɛtnsɛm barɛm bɛ bághɔ̌ bo mbɔ bɔángɛl Mandɛm ndǔ kɛnɔ́ amɨ́k antifú abhɛn bághátí bhɔ bɛ Yesu achi nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Mbɔk bo abhɛn báchí nyaka ndǔ nkwɔ́ ywɛsɛ bárɔ́k ndǔ nnɛm bághɔ́ bɛ́ yɛ̌ntɨkɨ ɛnyɨŋ ɛchi nkúbhɛ́ mbɔ ɛnyǔ baghɔrɛ́ bhɔ bárɛ́mɛ́, kɛ bɔ́ kɛghɔ́ mbɔŋ Yesu.” ");
INSERT INTO kenNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Afɔ̌ kɛ Yesu árɛ́mɛ́ ntá yap bɛ, “Bǎchɨŋti bǎcha! Nɛ batɨ̌ yɛka ápú wakari mɛ́nóko mɛnyɨŋ mɛnkɛm ɛbhɛn barɛmɛ́ kɛpɨ̌ntɨ bárɛmɛ! ");
INSERT INTO kenNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Pú Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò, abhɔ̌ŋ nyaka bɛghɔ bɛsɔŋɔri ɛbhɛn mɛnkɛm kɛ anchwe ndǔ kɛfɔ ɛki?” ");
INSERT INTO kenNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yesu abho yɛ mɛnɛnɛ ntá yap bɛ manjwimɛm ndǔ mɛnyɨŋ ɛbhɛn básɨ́ŋɨ́ ɛ̌ti yi amɛm Ɛkáti Mandɛm, bɛ́bho ndǔ Basɨŋɨ Moses bɛrɔ́ŋ bɛghaka ndǔ amɛn barɛmɛ́ kɛpɨ̌ntɨ Mandɛm mankɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Bágháká kɛkwɔt ɛtɔk ɛnɛ bárɔ̀ŋ, Yesu akʉ mbɔ bɛ ǎrɔ̀ bhɔ bɛrɔŋ ambɨ. ");
INSERT INTO kenNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kɛ bájwɛ́ yi, barɛm bɛ, “Bʉrɛ́ nɛ bhɛsɛ. Nywɔp nɛ́rɔŋ nɛ mbaŋ anaŋ ǎgiri.” Arɔk yɛ bɛbhʉrɛ nɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Mpok nɛnyíɛ́ ákwáy nɔ́kɔ́, asɔt ɛkpɔkɔ́ brɛt. Áchyɛ́ bakak ntá Mandɛm. Abho yɛ bɛ́bɔ́kɔ́ti anchyɛ nɔkɔ ntá yap. ");
INSERT INTO kenNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Amɨ́k ánɛ́nɛ bhɔ, bárɨ́ŋɨ yɛ bɛ chi yi. Kɛ anɛmsi bhɔ́ bɛsí. ");
INSERT INTO kenNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Babho bɛrɛm nɛ batɨ bɛ, “Nyakányɛt maŋák achi mbʉ bhɛsɛ antɨ mpok yi árɛ̀m kɛpɨ nɛ bhɛsɛ ambi, anɛnɛ nɔkɔ basɨŋ ntá yɛsɛ!” ");
INSERT INTO kenNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Báfáte tɛ́mté bápɛtnsɛm Yerúsalɛm. Bághɔ́ bǒnto Yesu bati byo nɛ amɔt nɛ bakoŋo bhi abhɛ́nɛ́fú abhɛn báchí nɛ bhɔ́ ndǔ nɛbhʉɛt amɔt. ");
INSERT INTO kenNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Nɛchwe báchwé, bágháti bhɔ bɛ, “Acha apɛtnsɛm ndǔ nɛpɛ́m tɛtɛp! Atɔ̌ŋ mmʉɛt ntá Símun!” ");
INSERT INTO kenNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Bǒbhɔ bati apay bágháti ɛnyɨŋ ɛnɛ ɛfakari ambi, nɛ ɛnyu bɔ́ bárɨ́ŋɨ́ yi mpok yi abɔkɔti brɛt achyɛ bhɔ manyíɛ́. ");
INSERT INTO kenNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ɛnɛ́ bárɛ̀m nɔ ɛ̌ti yi, mbɔŋ Yesu abhesi bɛsí bhap! Arɛm bɛ, “Kpák ámbák nɛ bhe.” ");
INSERT INTO kenNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Bácháyti, nɛ bɛcháy bɛ́kɛ́m bhɔ. Bákáysi bɛ bághɔ̀ nɔ chi ɛfóŋó ngu. ");
INSERT INTO kenNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kɛ abhɛ́p bhɔ́ bɛ, “Bǎcháy yi? Yi mǎmàkati amɛm batɨ yɛka? ");
INSERT INTO kenNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ghɔ́ ká amɔ ya nɛ bɛkak ɛbha, mǎndɨŋɨ bɛ chi mɛ tɛtɛp. Mɔ́ ká mmʉɛ́t ya mǎngɔ bɛ chi mɛ. Ɛfóŋó ɛ́pú bhɔŋ mmʉɛt nɛ bɛghɛp mbɔ ɛnyǔ bǎghɔ́ bɛ mbɔŋ.” ");
INSERT INTO kenNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Arɛm nɔkɔ nɔ, atɔ́ŋ bɔ́ amɔ yi nɛ bɛkak. ");
INSERT INTO kenNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Bábhɔ́ŋ maŋák tontó nɛ babhak maknkay bɛ yi achi nɛpɛ́m. Ɛkʉ bɔ́ kɛnókó bɛ ɛchi tɛtɛp. Yesu abhɛ́p bɔ́ bɛ, “Bǎbhɔŋ yɛ̌nyɨŋ mɛnyiɛ fá?” ");
INSERT INTO kenNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Báchyɛ yi mbɨŋɨ́ nsi anɛ bágwɔ́. ");
INSERT INTO kenNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Asɔt anyiɛ́ bɛsí bhap. ");
INSERT INTO kenNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Aghati yɛ bhɔ́ bɛ, “Mɛnyɨŋ ɛbhɛn bǎghɔ̀-nɛ́, chí nkúbhɛ́ barak anɛ mɛ̌ghàti nyaka bhe mpok mbʉɛt nɛ bhe. Mɛ̌ghàti nyaka be bɛ, mɛnyɨŋ mɛnkɛm ɛbhɛn bɛ́chi amɛm basɨŋɨ́ Moses nɛ amɛn abhɛn bɛchi ndǔ basɨŋɨ́ barɛmɛ́ kɛpɨ̌ntɨ nɛ ɛbhɛn bɛ́chí amɛm Ɛkáti Bakway ɛ̌ti ya, bɛ́bhɔŋ bɛfu tɛtɛp.” ");
INSERT INTO kenNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Anɛnɛ yɛ nkaysi yap bɛ mánjwimɛm ndǔ mɛnyɨŋ ɛbhɛn básɨ́ŋɨ́ amɛm Ɛkáti Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Aghati bhɔ bɛ, “Básɨŋ bɛ, Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò abhɔŋ bɛ́ghɔ ɛsɔŋɔri, angú, nɛ bɛghaka manywɔp árát, ampɛtnsɛm ndǔ nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Nɛ bɛ bábhɔŋ bɛghati bǒ bɛtɔk mɛnkɛm ndǔ nnyɛ́n ɛni bɛbho Yerúsalɛm bɛ Mandɛm ǎfòŋori bo abhɛn bátɨ́knsɛm ndǔ bɛbʉ́ bhap. ");
INSERT INTO kenNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Bǎchí batísiɛ́ ndǔ mɛnyɨŋ ɛbhɛn mɛnkɛm nɛ bǎbhɔŋ bɛ́gháti bo bachak bɔ mɛnkɛm. ");
INSERT INTO kenNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ghɔ́ ka, chɔŋ nto be akap anɛ Ɛtaya afyɛ́ bariɛp bɛ ǎtò ntá yɛka. Kɛ bǎbhɔŋ mɛ́noŋ fá amɛm ɛtɔk kpátɛ bɛtaŋ mɛ́mfu amfay mɛ́mbak nɛ bhe.” ");
INSERT INTO kenNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yesu asɔt yɛ baghɔkɔ́ bhi, afú ɛtɔk nɛ bhɔ. Bárɔ́k bachwɔp ɛtɔk Bɛ́tani. Arɛ́, ayoŋ amɔ amfay, are yɛt bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ɛnɛ́ yi áyɛ̀t bhɔ, arɔ bhɔ́, Mandɛm asɔt yi ámpɛ́tnsɛm amfay. ");
INSERT INTO kenNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nɛ ndǔ yi ákò baghɔkɔ́ bhi báré chyɛ yi kɛnókó. Bápɛ́t yɛ nsɛm Yerúsalɛm nɛ bɛyǎ maŋák. ");
INSERT INTO kenNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Báre rɔ́ŋ ɛkɛrákap mámbɨti nɔkɔ Mandɛm.");
INSERT INTO kenNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Bápɛ́rɛ ghoko mmɨk, mmu anɛ achi Ɛyɔŋ anáŋ achi nyaka. Abhak nɛ Mandɛm, nɛ abhak Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Abhak nɛ Mandɛm tɛ ndǔ nɛbhǒnɛt. ");
INSERT INTO kenNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Mandɛm afʉɛ́t ntá yi kɛ ǎghoko mɛnyɨŋ mɛnkɛm. Mandɛm abhɨ́kɨ́ ghoko yɛ̌nyɨŋ ɛnɛ yi apu nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Nɛpɛ́m nɛ́fù chí ntá yi mmu bábhɨ̀ŋɨ bɛ Ɛyɔŋ. Nɛ nɛpɛ́m ɛnɛn nɛ́bhak ɛrɔ́ŋɔ́ ɛnɛ́ ɛ́kʉ̀ bo mángɔ́ tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ɛrɔ́ŋɔ́ yɔ ɛ́ghɔ̀ ndǔ nɛbhʉɛt anɛ ɛjuri ɛchi, nɛ ɛjuri ɛ́pú kway mɛnɛmɛ yɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Mandɛm atǒ nyaka mmu amɔt anɛ aka nnyɛ́n bɛ Jɔ̌n. ");
INSERT INTO kenNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Atwɔ́ bɛ́gháti bho ɛ̌ti ɛrɔ́ŋɔ́ ɛyɔ bɛ yɛ̌ntɨkɨ mmu anɛ ághókó ɛnyɨŋ ɛnɛ yi árɛ̀m, anoko yɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jɔ̌n apu nyaka ɛrɔ́ŋɔ́ yɔ. Atwɔ́ chí bɛ́gháti bho ɛnyɨŋ ɛnɛ yi arɨŋɨ ɛ̌ti ɛrɔ́ŋɔ́ yɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ɛrɔ́ŋɔ́ ɛnɛ tɛtɛp, ɛnɛ́ ɛ́kʉ̀ yɛ̌ntɨkɨ mmu angɔ mbaŋ ɛ́twɔ́ ntá bǒ mmɨk. ");
INSERT INTO kenNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ɛyɔŋ ɛ́bhak fá amɨk, nɛ báfʉ́ɛ́t ntá yi kɛ bághoko mmɨk. Yɛ̌ nɔ, mpok yi átwɔ́ fá amɨk, bǒ mmɨk kɛrɨŋɨ ɛnyu mmu yi achi. ");
INSERT INTO kenNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Atwɔ́ ntá bǒbhi, kɛ bǒbhi bábhɨ́kɨ́ sɔt yi nɛ maŋák. ");
INSERT INTO kenNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kɛ bo mankɛm abhɛn básɔ́rɛ́ yí nɛ maŋák, básɨ́kɨ ntɨ nɛ yi, ǎchyɛ bhɔ bɛtaŋ bɛ́ mándɔp chí bɔ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Mbɔŋ Mandɛm kɛ ákʉ̀ bɔ mambak bǒbhi. Bábhɨ́kɨ́ fu nyaka yɛ chi amʉɛt nkwǎ, nɛ yɛ̌ chi ndǔ nkaysi nkwǎŋwaŋ. ");
INSERT INTO kenNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ɛyɔŋ, ɛ́yíbhiri nkwǎ, atwɔ́ achɔkɔ nɛ bhɛsɛ. Sɛ́ghɔ́ mɛnwɔp ɛbhi ɛbhɛn bɛjwi nɛ bɛrɨ̌ndu nɛ tɛtɛp. Ɛyɔŋ chi Njaŋamɔ anɛ áfú ntá Ɛta. ");
INSERT INTO kenNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jɔ̌n ǎghàti nyaka bho ɛ̌ti yi ambɨk, andɛmɛ nɔkɔ bɛ, “Nɛ́ chi mmǔ anɛ mɛ́rɛ̀m nyaka ɛ̌ti yi bɛ, ‘Mmǔ anɛ átwɔ̀ mɛ ansɛm achá mɛ. Bápɛ́rɛ bhe mɛ, yí achi.’” ");
INSERT INTO kenNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ɛ̌ti bɛyǎ bɛrɨ̌ndu ɛbhi, achyɛ́ bhɛsɛ áfɔ́k ndɔŋ nɛ ndɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mandɛm afʉɛt nyaka ntá Moses achyɛ bho bɛbhé. Kɛ afʉɛt chi ntá Yesu Kristo kɛ ǎtɔŋ bhɛsɛ bɛrɨ̌ndu bhi nɛ tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Yɛ̌ mmu abhɨ́kɨ́ re ghɔ Mandɛm. Njaŋamɔ ywi mmu achi nɛbhʉɛt amɔt nɛ yi kɛ ákʉ́ bo mandɨŋɨ mmu yi achi. ");
INSERT INTO kenNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ɛwak ɛ́mɔt, bǒbati bo Israɛl abhɛn Yerúsalɛm bátó bachiǎkap Mandɛm nɛ bǒnɛrɛ́kɛt Lɛ́vi ntá Jɔ̌n bɛ mámbɛ́p yi angati bhɔ ɛnyǔ mmu yi achi. Nɛ chi ɛnyɨŋ ɛnɛ ɛ́fú Jɔ̌n anyu mbɔ ntísiɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yi kɛ bhɛsɛ bhɔ yɛ̌nyɨŋ nɛ yi kɛ rɔ bɛkɛmɛ bhɔ. Arɛm bɛ, “Puyɛ̌ mɛ kɛ nchí Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò.” ");
INSERT INTO kenNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Bǒ bhɔ bápɛt bábhɛ́p yi bɛ, “Wɔ ɔchí yɛ́ agha? Ɛláija kɛ?” Jɔ̌n yi bɛ, “Mpú Ɛláija.” Bápɛ́t babhɛp yi bɛ, “Ɔchí ndɛmɛkɛpɨ̌ntɨ anɛ Moses árɛ́mɛ́ nyaka bɛ ǎtwɔ̀?” Akɛmɛ bɛ, “Ǎe.” ");
INSERT INTO kenNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ndɔŋ ɛyɔ bábhɛ́p yi bɛ, “Wɔmbɔ̌ŋ ɔrɛm bɛ ɔchí agha? Ghatí bhɛsɛ mmu wɔ ɔchí bɛ́ sɛ́mpɛ́tnsɛm nɛ ɛyɔŋ ntá bo abhɛn bátó bhɛsɛ. Wɔmbɔ̌ŋ ɔchí agha?” ");
INSERT INTO kenNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jɔ̌n aghati bhɔ mbɔnyǔ ndɛmɛkɛpɨ̌ntɨ Asaya arɛmɛ nyaka bɛ, “Nchí mmǔ anɛ achi amɛm baso ábɨ̀k nɛ ɛyɔŋ amfay andɛmɛ nɔkɔ bɛ, ‘Nyabhɛ́ ká mbi Acha ambak chak.’” ");
INSERT INTO kenNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Bǒnkwɔ Fárisi kɛ bátó nyaka bǒbhɔ ntá Jɔ̌n. ");
INSERT INTO kenNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Bábhɛ́p yi bɛ, “Ɔbhɛ́ ɔpú Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò, ɔbhɛ́ ɔpú Ɛláija, nɛ ɔpú ndɛmɛkɛpɨ̌ntɨ, kɛ ndaká yí ɔ́jwìti bho?” ");
INSERT INTO kenNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jɔ̌n akɛmɛ bhɔ́ bɛ, “Mɛ̌jwìti bho nɛ manyiɛp, kɛ mmu áchí fá téé nɛntɨ ɛnɛka anɛ bǎbhɨ́kɨ́ rɨŋɨ. ");
INSERT INTO kenNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Yi ǎtwɔ̀ mɛ ansɛm. Mbɨ́kɨ́ kway mmu anɛ nchí kaŋari nkwɔbhɛ́nya bɛkak ɛbhi.” ");
INSERT INTO kenNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Mɛnyɨŋ ɛbhɛn bɛ́fákárí chi ɛtɔk Bɛ́tani, ɛbhě Nyɛ́n Jɔ́dan, nɛ ndǔ nɛbhʉɛt anɛ Jɔ̌n ájwìti nyaka bho. ");
INSERT INTO kenNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ntɨ nywɔp, Jɔ̌n aghɔ Yesu ndu átwɔ̀ ntá yi, arɛm bɛ, “Yɨŋɨ́ Mɔ́nkwɔmɛ́n Mandɛm anɛ ápɔ̀kɔ bɛbʉ́ bo mankɛm fá amɨk! ");
INSERT INTO kenNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yí kɛ mɛ̌rɛ̀m nyaka ɛ̌ti yi bɛ, ‘Mmǔ ǎtwɔ̀ mɛ ansɛm anɛ acha mɛ mbɔnyunɛ bápɛrɛ bhe mɛ, yi achi.’ ");
INSERT INTO kenNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yɛ̌ mɛmbɔŋ mbɨ́kɨ́ rɨŋɨ nyaka bɛ chi yí, kɛ ntí anɛ ntwɔ́ njwiti nɔkɔ bho nɛ manyiɛp chí ndu bɛkʉ bo Israɛl mandɨŋɨ mmu yi achi.” ");
INSERT INTO kenNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jɔ̌n abho bɛghati bho ɛnyɨŋ ɛnɛ yi ághɔ́ nɛ amɨ́k ɛ̌ti Yesu. Yí bɛ, “Ngɔ ndǔ Ɛfóŋó Mandɛm áfú amfay asɔt mkpá ɛbhóŋó are sɛp kpát ate yi amʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Kpátɛ mpok ɛyɔ, nkɛ rɨŋɨ bɛ́ chí yí. Kɛ Mandɛm mmu átó mɛ njwiti bho nɛ manyiɛp, anáŋ aghati nyaka mɛ bɛ, ‘Mmu anɛ ɔ́ghɔ́ Ɛfóŋó Mandɛm asɛbhɛ arɔp nɛ yi, yí wu kɛ achi mmu anɛ ájwìti bho nɛ Ɛfóŋó Bɛdyɛrɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Mɛ Jɔ̌n ngɔ nɛ amɨ́k ndǔ mɛnyɨŋ ɛbhɛn bɛ́fákárí, nɛ nchí rɛm mbɔ ntísiɛ bɛ tɛtɛp mmǔ-nɛ chi Mmɔ Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nɛ́yí nɔ́kɔ́, Jɔ̌n apɛt abhak téé nɛ bakoŋo bhi bati apay. ");
INSERT INTO kenNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Aghɔ́ ndǔ Yesu áfʉɛ̀t, arɛm bɛ, “Ghɔ́ Mɔ́nkwɔmɛ́n Mandɛm!” ");
INSERT INTO kenNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Bakoŋó Jɔ̌n bati apay bághók nɔ́kɔ́ ɛnyɨŋ ɛnɛ yi árɛ́mɛ́, bárɔ́ yi bábho bɛkoŋo Yesu. ");
INSERT INTO kenNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu ayibhiri mmʉɛt aghɔ bhɔ ndu bákòŋo yi. Abhɛ́p bhɔ bɛ, “Bǎyàŋ yi?” Bákɛmɛ yi bɛ, “Rábay, ɔ̌chɔkɔ fá?” Rábay chi Ntɔŋ ");
INSERT INTO kenNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Aghati bhɔ bɛ, “Twɔ́ ká ghɔ.” Bárɔ́k nɛ Yesu baghɔ nɛbhʉɛt anɛ yi áchɔ̀kɔ. Mpok yɔ nywɔp nɛ́bhák mbɔ nkárɛ́nká ɛnwi ɛnɛ́ ngósí. Bábhák nɛ yi kpátɛ̌ bɛti bɛgʉ. ");
INSERT INTO kenNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Mmu amɔt ndǔ bǒbhɔ bati apay abhɛn bághoko nyaka ɛnyɨŋ ɛnɛ Jɔ̌n árɛ́mɛ́ ɛ̌ti Yesu, nɛ abho bɛkoŋo yi aka nnyɛ́n bɛ Andru. Abhak manɔ Símun Píta. ");
INSERT INTO kenNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Arɔk tɛ́mté, aghɔ mɔ́mayi Símun, aghati yi bɛ, “Sɛ́ghɔ mmu anɛ bábhɨŋɨ bɛ, ‘Mɛsáya’”, nɔ chi, Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò. ");
INSERT INTO kenNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andru asɔt Símun arɔk ntá Yesu nɛ yi. Yesu ayɨŋɨ yí, arɛm bɛ, “Wɔ ɔchí Símun, mmɔ̌ Jɔ̌n. Chɔŋ nnyɛ́n ɛna nɛ́chák nɛ́mbak bɛ Sɛ́fas” nɔ chí Sɛtárɛ́bhɛ́. ");
INSERT INTO kenNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ntɨ nywɔp, Yesu akʉ ntɨ bɛ́rɔŋ atú Gálili. Arɔk aghɔ́ mmu anɛ áká nnyɛ́n bɛ Fílip. Aghati yi bɛ, “Twɔ́ bhák nkoŋo wa.” ");
INSERT INTO kenNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Fílip abhak mmǔ Bɛtsáida, nkúbhɛ́ ɛtɔk ɛnɛ Andru nɛ Píta báfú arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Fílip arɔk atɛmɛri Natániɛl aghati yi bɛ, “Sɛ́ghɔ̌ mmu anɛ Moses ásɨ́ŋɨ́ nyaka ɛ̌ti yi amɛm Ɛkáti Bɛbhé Mandɛm, nkúbhɛ́ yi mmǔ barɛmɛ́ kɛpɨ̌ntɨ nkwɔ básɨ́ŋɨ́ ɛ̌ti yi. Nɔ chi, Yesu mmu Násárɛt, mmɔ̌ Josɛ́f.” ");
INSERT INTO kenNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natániɛl ághókó nɔ́kɔ́ ɛnyɨŋ ɛnɛ Fílip árɛ́mɛ́ abhɛ́p yi bɛ, “Ntɨkɨ ɛrɨ́tí ɛnyɨŋ ɛ́kway bɛfu Násárɛt?” Fílip aghati yi bɛ, “Wɔmbɔŋ twɔ́ ghɔ́.” ");
INSERT INTO kenNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu ághɔ́ nɔ́kɔ́ ndǔ Natániɛl átwɔ̀ ntá yi, arɛm ɛ̌ti yi bɛ, “Nɛ́, chi mbɔ̌ŋ mmǔ Israɛl tɛ́mɛ́ tɛ́mɛ́. Bapu apú nɛ yi wáwák.” ");
INSERT INTO kenNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natániɛl abhɛ́p Yesu bɛ, “Ɔkʉ ná kɛ ɔ̌rɨŋɨ mɛ?” Yesu akɛmɛ yi bɛ, “Fílip ápɛ́rɛ bhɨŋɨ wɔ ndǔ mpok anɛ ɔ́chí anɛrɛ́nɔk fig, nnáŋ ngɔ wɔ.” ");
INSERT INTO kenNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natániɛl arɛm bɛ, “Ntɔŋ, ɔchí Mmɔ Mandɛm tɛtɛp! Ɔchí Mfɔ bo Israɛl!” ");
INSERT INTO kenNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu ákɛ́mɛ́ yí bɛ, “Ɛ̌ti ndɛ́mɛ́ bɛ́ ngɔ wɔ anɛrɛ́nɔk fig kɛ ɔ́nókó bɛ́ nchí Mmɔ Mandɛm? Chɔŋ ɔ́ngɔ́ mɛnyɨŋ ɛbhɛn bɛcha ɛbhɛn.” ");
INSERT INTO kenNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yesu aghati yi bɛ, “Tɛtɛ̌tɛp, chɔŋ mǎngɔ ndǔ nɛbu nɛ́nɛnɛ gbee, bɔángɛl Mandɛm mánkó amfay mánsɛbhɛ nɔkɔ amɨk bɛtɛmɛri Mɛ Mmu mfú ntá Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ɛ́fʉɛ́rɛ́ nɔ́kɔ́ manywɔp apay, ɛpǎ nɛbhay ɛ́bhák amɛm ɛtɔk Kána, atú Gálili. Nnɔ Yesu abhak arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Mának nyaka Yesu nkwɔ́ nɛ bakoŋo bhi ndǔ ɛpǎ nɛbhay ɛyɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mmɛ́m ámáy nɔ́kɔ́, nnɔ Yesu arɔk aghati yi bɛ, “Mmɛ́m ɛpǎ amay.” ");
INSERT INTO kenNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu akɛmɛ yi bɛ, “Mmá, ndaká yí ɔ́sɔŋɔri mɛ ɛ̌ti mmɛ́m? Mpok aya abhɨ́kɨ́ re kway.” ");
INSERT INTO kenNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Máyi aghati bo abhɛn bákɔ̀rɛ mmɛm bɛ, “Kʉ ka yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ yí ághàti bhe.” ");
INSERT INTO kenNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Bɛjɔ̌ manyiɛp bɛtandat bɛchi nyaka arɛ téé. Yɛ̌ntɨkɨ ɛjɔ ɛ́sɔ̀t nyaka mbɔ líta manyiɛp bɛsǎ byo. Bɛ́kóŋo ɛpɨŋ ɛnɛ́ bo Israɛl, básɔ̀t nyaka manyiɛp ndǔ bɛjɔ ɛbhɔ ndu bɛ́so bɛ́pókó mmʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu aghati bakʉ̌ bɛtɨk bɛ, “Fíɛ́ ká manyiɛp amɛm bɛjɔ ɛbhɔ kpát mɛ́njwi.” Báfyɛ́ manyiɛp amɛm bɛjɔ, bɛ́jwí tɛ anyu. ");
INSERT INTO kenNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Aghati bhɔ bɛ, “Sɔt ka mbɔk mǎnchyɛ́ ntá mǔnti ɛpǎ nɛbhay”. Bákʉ́ nɔ́. ");
INSERT INTO kenNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","mǔnti ɛpǎ nɛbhay ághókótí nɔ́kɔ́, aghɔ́ bɛ́ manyiɛp mɔ arɔp chi mmɛ́m. Yi kɛrɨŋɨ ɛbhak mɔ́ áfú, yɛ̌ndu bakʉ̌ bɛtɨk abhɛn bákò mɔ bárɨ́ŋɨ́ nyaka bɛ manyiɛp kɛ ayibhiri ndǔ mmɛm. Mǔnti ɛpǎ nɛbhay abhɨŋɨ mbǎyngɔrɛ́, ");
INSERT INTO kenNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","arɛm bɛ, “Ndǔ ɛpa, báyambɨ mantwɔ chi nɛ ɛrɨ́tí mmɛ́m. Nɛ bo mǎnáŋ mányú ánchwé bhɔ amʉɛt, kɛ mántwɔ nɛ yɛ̌ntɨkɨ ɛnyǔ mmɛ́m báchák. Kɛ ɔrɔ́ ɛrɨ́tí mmɛ́m ansɛm, nɛ nɛ́nɛ kɛ ɔ́twɔ̀ nɛ mɔ́.” ");
INSERT INTO kenNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu akʉ nyaka ɛnyɨŋɨ́ maknkay ɛnɛ amɛm ɛtɔk Kána, atú Gálili. Ɛ́bhák ɛrɨŋ ɛnɛ́ mbɨ ɛnɛ yi akʉ́ ndu bɛtɔŋ ɛnyǔ bɛtaŋ ɛbhɛn yi ábhɔ́ŋɔ́. Ɛ́kʉ́, bakoŋo bhi mánóko bɛ yi achi Mmɔ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ɛpǎ nɛbhay ɛ́fʉɛ́rɛ́ nɔ́kɔ́, Yesu asɛp arɔk Kapɛ̌naum nɛ máyi nɛ bɔ̌mayi nɛ bakoŋo bhi. Bábhak arɛ́ ndǔ mpay manywɔp. ");
INSERT INTO kenNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ɛpǎ Nɛkɨŋɨ ɛnɛ bo Israɛl ɛ́rɔ́bhɛ́ nɔ́kɔ́ kɛ́kwɔ́t, Yesu akó, arɔk Yerúsalɛm ndu mɛnyiɛ ɛpǎ ɛyɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Arɛ́, arɔk achwe amɛm ɛ́kírí ɛnɛ ɛkɛrákap Mandɛm. Aghɔ́ bo abhɛn bátì mpɔŋ nɛ bághɔ́ŋɔmɛ́n nɛ bɛbhóŋó. Bo básɔ̀t nyaka mɛnyɨŋ ɛbhɔ ndu bɛchyɛ akap. Aghɔ́ bawupsǐ bakap nkwɔ arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Asɔt nnɨk aghoko ɛ́kpá, abho bɛ́bok bho nɛ yɔ, bɛ mámfú amɛm ɛkɛrákap Mandɛm. Akʉ ɛnyumɔt nɛ bághɔ́ŋɔmɛ́n, nɛ mpɔŋ ɛnɛ́ ɛ́chí arɛ́. Atakati bɛ́fɛ́mɛ́ bo abhɛn bákɔ̀ ɛsiɛ́ bakáp bɛwupsi, nɛ atakati bakáp ayap. ");
INSERT INTO kenNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Aghati batǐ bɛbhóŋó bɛ, “Fɛrɛ́ ká mɛnyɨŋ ɛbhɛn fá! Bǎkɛ́ sɔt ɛkɛt Ɛtaya mǎnjibhiri ndǔ ɛkɛrɛ́siɛ!” ");
INSERT INTO kenNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ndak awu ákʉ́ bakoŋo bhi bátɨk bɛ Ɛkáti Mandɛm ɛ́rɛ̀m bɛ, “Chɔŋ ɛkɔŋ ɛnɛ́ mbɔ́ŋɔ́ nɛ ɛkɛt ɛyɛ ɛ́ngway mɛ.” ");
INSERT INTO kenNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Bɛ́kóŋo ɛnyɨŋ ɛnɛ Yesu ákʉ́, bo Israɛl bábhɛ́p yi bɛ, “Ntɨkɨ ɛnyɨŋɨ́ maknkay ɔ́kway bɛkʉ mbɔ ɛrɨŋ ndu bɛtɔŋ bhɛsɛ bɛ ɔbhɔ̌ŋ bɛtaŋ bɛkʉ mɛnyɨŋ ɛbhɛn?” ");
INSERT INTO kenNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu akɛmɛ bhɔ bɛ, “Mbák mǎnchɔ́ŋtí ɛkɛrákap ɛnɛ, chɔŋ mpɛt nte yɔ́ ndǔ manywɔp arat.” ");
INSERT INTO kenNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Bo Israɛl bárɛ́m bɛ, “Cháá, báté ɛkɛt ɛnɛ ndǔ mamiɛ́ bɛsa bɛpay nsɛm atandat, ɔbhɛ́ ɔ̌kway bɛte yɔ ndǔ manywɔp ararɛ?” ");
INSERT INTO kenNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kɛ ɛkɛrákap ɛnɛ́ Yesu árɛ́mɛ́ ɛ́bhak chi mmʉɛt yi. ");
INSERT INTO kenNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Mpok Mandɛm akʉ yi ámpɛtnsɛm ndǔ nɛpɛ́m, kɛ̌ bakoŋo bhi bátɨk bɛ yi arɛm nyaka bɛyɔŋ ɛbhɛn. Ɛ́kʉ́ bɔ mánóko mɛnyɨŋ ɛbhɛn bɛchi amɛm Ɛkáti Mandɛm nɛ ɛbhɛn Yesu árɛ́mɛ́. ");
INSERT INTO kenNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ɛnɛ́ Yesu áchí Yerúsalɛm ndǔ mpok Ɛpǎ Nɛkɨŋɨ, bɛyǎ bo básɨ́kɨntɨ nɛ yi ɛ̌ti mɛnyɨŋɨ́ maknkay ɛbhɛn bághɔ́ yi ákú. ");
INSERT INTO kenNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Kɛ Yesu kɛgʉɛ́p mmʉɛt ntá yap, mbɔnyunɛ, arɨ́ŋɨ́ nyaka ɛnyǔ nkwǎŋwaŋ achi. ");
INSERT INTO kenNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Yɛ̌ mmu kɛghati yi nkaysi bǒbhɔ mbɔnyunɛ yímbɔŋ arɨ́ŋɨ́ nyaka ndǔ ntɨ̌ nkwǎ nɛchi amɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Mǔnti bo Israɛl amɔt achi nyaka. Aka nnyɛ́n bɛ Nikɔdɛ́mɔs. Abhak mǔnkwɔ Fárisi. ");
INSERT INTO kenNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ɛwak ɛ́mɔt arɔk ntá Yesu nɛ bɛti arɛm bɛ, “Ntɔŋ, sɛ́rɨ́ŋɨ́ bɛ́ Mandɛm kɛ̌ átó wɔ bɛ ɔ́ntwɔ́ ɔ́ntɔ́ŋ bo mbɔnyunɛ yɛ̌ mmu apú kway bɛkʉ mɛnyɨŋɨ́ maknkay ɛbhɛn ɔ́kʉ̀ mbák Mandɛm apu nɛ yi.” ");
INSERT INTO kenNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu aghati yi bɛ, “Tɛtɛ̌tɛp, Mandɛm apú kway bɛbhak ntá mmu mbɔ Mfɔ ywi, kpátɛ mámbe yi ndɔŋ achak.” ");
INSERT INTO kenNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikɔdɛ́mɔs abhɛ́p yi bɛ, “Ná bákway bɛbhe mmu anɛ ánáŋ áchɨ́kɨ́? Ǎkway bɛ́pɛ́tnsɛm amɛm mɛniɛ máyi bɛ mámbé yi ndɔŋ achak kɛ?” ");
INSERT INTO kenNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu akɛmɛ yi bɛ, “Tɛtɛ̌tɛp, Mandɛm apú kwáy bɛbhak ntá mmu mbɔ Mfɔ ywi kpátɛ mámbé yi nɛ manyiɛp* nɛ Ɛfóŋó Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nɛbhě ɛnɛn nkwǎ chi nɛbhě nkwɔmʉɛt, kɛ nɛbhě Ɛfóŋó chí ɛnɛn nɛ́fú ntá Ɛfóŋó Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ɔ́kɛ́ bhák maknkay ndu ngátí wɔ bɛ, ‘Bábhɔŋ bɛbhe wɔ ndɔŋ achak.’ ");
INSERT INTO kenNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mbʉ́ɛ́p áfòk, ándɔk ɛbhak ɛnɛ wu ábhɔ́ŋɔ́ bɛ́rɔŋ. Ɔ̌ghok ndu wu áfʉɛ̀t kɛ ɔpú rɨŋɨ ɛbhak wu áfú nɛ ɛbhak ɛnɛ wú árɔ̀ŋ. Ɛ́chí ɛnyumɔt nɛ yɛ̌ntɨkɨ mmu anɛ bábhé yi ndu bɛtaŋ Ɛfóŋó Bɛdyɛrɛ.” ");
INSERT INTO kenNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikɔdɛ́mɔs abhɛ́p yi bɛ, “Ɛyɔ ɛkway bɛ́fàkari ná?” ");
INSERT INTO kenNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu akɛmɛ yi bɛ, “Ɔchí ntɔŋ ntá bo Israɛl anɛ bo bárɨŋɨ sayri, yɛ̌ nɔ ɔbhɨ́kɨ́ rɨŋɨ mɛnyɨŋ ɛbhɛ́n-ɛ? ");
INSERT INTO kenNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Tɛtɛ̌tɛp, sɛ́rɛ̀m mɛnyɨŋ ɛbhɛn sɛ́rɨ́ŋɨ́, nɛ sɛ́ghàti bho chi mɛnyɨŋ ɛbhɛn sɛ́ghɔ́ nɛ amɨ́k, yɛ̌ nɔ bǎpú noko mɛnyɨŋ ɛbhɛn sɛ́ghàti bhe. ");
INSERT INTO kenNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mbák ngátí bhe mɛnyɨŋ ɛ̌ti barak anɛ́ áfàkari fá amɨk be kɛnókó, ná bǎkwáy mɛnoko mbák ngátí bhe mɛnyɨŋ ɛ̌ti barak anɛ áfàkari awu amfay? ");
INSERT INTO kenNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Yɛ̌ mmu amɔt ábhɨ́kɨ́ re ko amfay ɛbhak ɛnɛ Mandɛm achi, ɛ́bhɨ́kɨ́ fʉɛt Mmu anɛ áfú ntá Mandɛm, yi mmu áfú amfay atwɔ amɨk. ");
INSERT INTO kenNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nkúbhɛ́ mbɔ ɛnyǔ Moses ásɔ́rɛ́ nyaka nnyɔ́-sɛnɔŋ abhat ndǔ ɛnɔk, ayoŋ amfay, amɛm baso, ɛnyu ɛyɔ kɛ̌ bábhɔ́ŋɔ́ bɛyoŋ Mmu anɛ áfú ntá Mandɛm nkwɔ amfay. ");
INSERT INTO kenNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Bábhɔŋ bɛkpaŋ yi amfay ɛnɔk bɛ yɛ̌ agha anɛ anoko yi, ámbɔ́ŋ nɛpɛ́m ɛnɛn nɛbhɨkɨ bhɔŋ ngwɛnti. ");
INSERT INTO kenNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Mandɛm akɔŋ nyaka bǒ mmɨk tontó, kpát achyɛ Njaŋá Mɔ́ywi bɛ yɛ̌ agha anɛ ánókó yi, ákɛ́ gu ánɛ́m, kɛ ámbɔ́ŋ nɛpɛ́m ɛnɛn nɛbhɨkɨ bhɔŋ ngwɛ́nti. ");
INSERT INTO kenNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Mandɛm abhɨ́kɨ́ to Mɔ̌ywi fá amɨk bɛ ántwɔ́ ántáŋ bǒ mmɨk andɛm bɛ babhɔŋ bɛkwɛ́nɛ́. Atǒ yí chi bɛ́ ámfʉɛ́t ntá yi, ampɛmɛ bǒ mmɨk. ");
INSERT INTO kenNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Bápú tɛmsi mmu anɛ ánókó yi, kɛ mmu anɛ ábhɨ́kɨ́ ka mɛnoko, bɛkwɛ́nɛ́ bɛchi nɛ yi mbɔnyunɛ ábhɨ́kɨ́ ka mɛnoko Njaŋa-Mɔ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ntí anɛ Mandɛm átàŋ bo abhɛn bábhɨ́kɨ́ noko Mɔ́ywi chi bɛ́ ɛrɔ́ŋɔ́ ɛ́twɔ fá amɨk kɛ bo bákɔŋ ɛjuri bácha ɛrɔ́ŋɔ́, mbɔnyunɛ barak abʉ́abʉ kɛ bɔ bákʉ̀. ");
INSERT INTO kenNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Yɛ̌ntɨkɨ mmu anɛ ákʉ̀ barak abʉ́abʉ ǎpap ɛrɔ́ŋɔ́. Apú rɔŋ ɛbhak ɛnɛ ɛrɔ́ŋɔ́ ɛchi ndǔ ápú yaŋ bo mangɔ mɛnyɨŋ yi ákʉ̀. ");
INSERT INTO kenNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kɛ mmu anɛ ákʉ̀ mɛnyɨŋ ɛbhɛn bɛchi tɛtɛp ǎtwɔ ndǔ ɛrɔ́ŋɔ́ nɛ maŋák, bɛ bo mangɔ bɛ Mandɛm kɛ ákwak yi ankʉ mɛnyɨŋ ɛbhɔ.” ");
INSERT INTO kenNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Yesu ánáŋá nɔ́kɔ́ bɛ́rɛ́m ɛnyɨŋ ɛnɛ́ yi ághàti Nikɔdɛ́mɔs, arɔk bɛbhak bɛchak atú Judɛ́ya nɛ baghɔkɔ́ bhi. Abhak arɛ́ nɛ bhɔ anjwiti nɔkɔ bho. ");
INSERT INTO kenNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Mpok ɛyɔ, Jɔ̌n abhak Áénɔn, kɛkwɔt nɛ Sálim, anjwiti nɔkɔ bho. Abhak arɛ́ mbɔnyunɛ manyiɛp aya nyaka ɛbhak ɛyɔ. Bo báré rɔŋ ntá yi, anjwiti nɔkɔ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Bábhɨ́kɨ́ re kɛm nyaka Jɔ̌n mamfyɛ ɛkɛrɛ́kɛnɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ɛ́bhɨ́kɨ́ tat, ɛpʉ́ítí ɛ́kwɛ́n nɛntɨ bakoŋo Jɔ̌n nɛ mmu Israɛl achak ɛ̌ti ɛnyǔ nɛso ɛnɛn nɛ́kʉ̀ mmu ambak pɛ́pɛ́p bɛsí Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ɛ́kʉ́ bakoŋo Jɔ̌n bárɔ́k ntá yi barɛm bɛ, “Ntɔŋ, mmu anɛ achi nyaka nɛ wɔ ɛbhé Nyɛ́n Jɔ́dan ɛnɛ́ awu ɔ́ngati nɔkɔ bo mɛnyɨŋ ɛ̌ti yi, ǎjwiti bho nɛ yɛ̌ntɨkɨ mmu árɔ̀ŋ ntá yi.” ");
INSERT INTO kenNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jɔ̌n akɛmɛ bhɔ bɛ, “Yɛ̌ mmu apu kway bɛbhɔŋ ɛnyɨŋ kpátɛ Mandɛm anchyɛ yi yɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Bě babhɔŋ bǎchí batísiɛ ndǔ ndɛ́mɛ́ bɛ́ puyɛ̌ mɛ kɛ̌ nchí Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò. Nchí chí mpɔkɔntó anɛ Mandɛm átó bɛ njambɨ kɛ yi antwɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mbǎy-ngɔrɛ kɛ ábhɔ́ŋɔ́ ngɔrɛ́. Mmʉɛrɛ mbǎyngɔrɛ́ anɛ áchí téé ánòŋ bɛ́ghok ɛyɔŋ ɛnɛ mbǎyngɔrɛ́, ǎghok ɛyɔŋ ɛyi, ambɔ́ŋ bɛyǎ maŋák. Ɛnyu yɔ kɛ ɛ́chi nɛ mɛ. Maŋák ama ajwí pɔɔt nɛ́nɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Nsóŋó yí abhɔŋ bɛ́kó nɔ́kɔ́ kó, aya ansɛp nɔkɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Mmu anɛ áfú amfay, achá yɛ̌ntɨkɨ mmu achak. Mmǔ mmɨk afu fá amɨk, nɛ ǎrɛm chi barak anɛ́ mmɨk. Mmu anɛ áfú amfay achá bǒ mmɨk mankɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yí ǎghati bo mɛnyɨŋ ɛbhɛn yi aghɔ nɛ amɨ́k, aghók nɛ batú. Yɛ̌ nɔ, yɛ̌ mmu apú noko ɛnyɨŋ ɛnɛ yi árɛ̀m mbɔ ɛnyɨŋ. ");
INSERT INTO kenNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kɛ mmu anɛ ághókó ɛnyɨŋ ɛnɛ́ yi arɛmɛ anoko, ǎtɔŋ bɛ yi anókó ɛnyɨŋ ɛnɛ Mandɛm árɛ́mɛ́ bɛ ɛ́chí tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ɛchi nɔ mbɔnyunɛ yí mmu Mandɛm átó, árɛ̀m chi Ɛyɔŋ Mandɛm mbɔnyunɛ Mandɛm achyɛ́ yi Ɛfóŋó Bɛdyɛrɛ njɛnti ti. ");
INSERT INTO kenNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ɛta Mandɛm akɔŋ Mɔ́ywi nɛ afyɛ́ mɛnyɨŋ mɛnkɛm yi awɔ. Mandɛm achyɛ́ yi Ɛfóŋó ɛyi njɛnti ti. ");
INSERT INTO kenNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Yɛ̌ntɨkɨ mmu anɛ ánókó Mmu anɛ áfú ntá Mandɛm, ǎbhɔ̀ŋ nɛpɛ́m ɛnɛn nɛbhɨkɨ bhɔŋ ngwɛnti. Mmu anɛ ábhɨ́kɨ́ noko Mmu anɛ áfú ntá Mandɛm apú bhɔŋ nɛpɛ́m. Kɛ bɛběntɨ Mandɛm bɛ́tɨŋɨ nɛ yi.” ");
INSERT INTO kenNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yesu arɨŋɨ bɛ bǒnkwɔ Fárisi bághók bɛ bɛyǎ bo bárɔbhɛ koŋo chi yi nɛ yí anjwiti nɔkɔ bhɔ, nɛ bɛ́ bakoŋo bhi báyá máncha nɔkɔ abhɛn Jɔ̌n. ");
INSERT INTO kenNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Sayri sayri, puyɛ̌ Yesu kɛ ájwìti nyaka bho, chí bakoŋo bhi. ");
INSERT INTO kenNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesu árɨ́ŋɨ́ nɔkɔ nɔ, afa atú Judɛ́ya apɛt atú Gálili. ");
INSERT INTO kenNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Abhɔ̌ŋ nyaka bɛ́fʉɛ́t atú Samária ndu bɛrɔŋ Gálili. ");
INSERT INTO kenNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ɛ́kʉ, akɔ aghaka ɛtɔk Samária ɛnɛ bábhɨŋɨ bɛ́ Síka, kɛ́kwɔ́t nɛ nɛbhʉɛ́rɛ́mɨk anɛ Jekɔ́p áchyɛ tɛntɛp ntá mɔ́ywi Josɛ́f. ");
INSERT INTO kenNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Mbokó manyiɛp anɛ Jekɔ́p ábhák arɛ. Yesu ágháká nɔkɔ arɛ́, ndǔ yi ánáŋ ápɔ́bhɛ́, achɔkɔ nɛpaká mbokó manyiɛp wu. Nywɔp nɛ́bhák mbɔ nkárɛ́nká byo nɛ ɛpay. ");
INSERT INTO kenNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ngɔrɛ́ Samária amɔt atwɔ́ ndu bɛya manyiɛp arɛ́. Yesu aghati yi bɛ, “Mma, chyɛ mɛ manyiɛp nnyú.” ");
INSERT INTO kenNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Mpok ɛyɔ, bakoŋo Yesu bárɔŋ nyaka ɛtɔk ndu bɛ́kú nɛnyíɛ́. ");
INSERT INTO kenNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ngɔrɛ́ Samária wu akɛmɛ Yesu bɛ, “Wɔ, ɔchí mmu Ju, atú Judɛ́ya, mɛ mbák ngɔrɛ́ atú Samária, ɛkɔ ná kɛ ɔ̌rɛm bɛ nchyɛ́ wɔ manyiɛp ɔ́nyú. Bǒ Judeya bábhɨ́kɨ́ bhɔŋ yɛ̌nyɨŋ bɛkʉ nɛ bhɛsɛ bo Samaria!” ");
INSERT INTO kenNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu akɛmɛ yi bɛ, “Mbɔ ɔrɨ́ŋɨ́ akap anɛ Mandɛm áchyɛ̀ bho, nɛ mmu anɛ árɛ́mɛ́ nɔ́ bɛ, ‘Chiɛ mɛ manyiɛp’, mbʉ ɔrɛm mɛ nchyɛ́ wɔ manyiɛp amɛn áchyɛ̀ nɛpɛ́m.” ");
INSERT INTO kenNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ngɔrɛ́ wu arɛm bɛ, “Ɛta, ɔbhɨ́kɨ́ bhɔŋ ɛnyɨŋ ndu bɛ́yǎ manyiɛp nɛ yɔ, nɛ mbokó manyiɛp áchwe, ɔ̌bhɔŋ manyiɛp amɛn áchyɛ̀ nɛpɛ́m fá? ");
INSERT INTO kenNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ɔchá ɛtayɛsɛ Jekɔ́p mmu átɛ́mɛ́ nyaka mbokó manyiɛp anɛ arɔ ntá yɛsɛ? Ná ɔ́kway bɛchyɛ mmu manyiɛp amɛn áchá amɛn yímbɔŋ ányu nyaka, nɛ bɔ̌bhi mányú, mpɔŋ ɛyi ɛ́nyú?” ");
INSERT INTO kenNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu akɛmɛ yi bɛ, “Yɛ̌ agha anɛ ányù manyiɛp amɛn, apú rɔ bɛ́bhɔŋ ɛkwaká manyiɛp. ");
INSERT INTO kenNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Kɛ mmu anɛ ányù manyiɛp amɛn mɛ̌chyɛ̀, apú pɛrɛ bhɔŋ ɛkwaká manyiɛp wáwák. Manyiɛp amɛn mɛ̌chyɛ̀ yi, ǎbhák ntá yi mbɔ ntí mɔ́nyɛn anɛ́ manyiɛp ányày arɛ, anchyɛ nɔkɔ yi nɛpɛ́m ɛnɛn nɛbhɨkɨ bhɔŋ ngwɛnti.” ");
INSERT INTO kenNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ngɔrɛ́ wu arɛm ntá yi bɛ, “Ɛta, chyɛ mɛ manyiɛbhɛ́ mɔ, bɛ́ manyiɛp ákɛ́ pɛrɛ kwak mɛ, nɛ bɛ nkɛ́pɛrɛ twɔ fá ndu bɛya manyiɛp.” ");
INSERT INTO kenNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu aghati yi bɛ, “Dɔ́k bhɨŋɨ nnɛ́m aywɛ, twɔ́ nɛ yí.” ");
INSERT INTO kenNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ngɔrɛ́ wu akɛmɛ yi bɛ, “Mbɨ́kɨ́ bhɔ́ŋ nnɛ́m.” Yesu arɛm bɛ, “Ɔrɛm tɛtɛp bɛ́ ɔbhɨkɨ bhɔŋ nnɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ɔnáŋ ɔbhɔ̌ŋ manɛ́m batay, nɛ mmǔ anɛ ɔ́chí nɛ yi nɛ́nɛ, abhɨkɨ bhay wɔ. Ɔrɛm tɛtɛp!” ");
INSERT INTO kenNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ngɔrɛ́ wu arɛm ntá yi bɛ, “Ɛta, ngɔ nɛ́nɛ bɛ ɔchí ndɛmɛkɛpɨ̌ntɨ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Bɔtayɛsɛ bátwɔ̀ nyaka fá ndǔ njiɛ nɛ mánchyɛ nɔkɔ Mandɛm kɛnókó, kɛ be bǒ Judeya bǎrɛ̀m bɛ Yerúsalɛm kɛ áchi ɛbhak ɛnɛ bo bábhɔ́ŋɔ́ bɛchyɛ Mandɛm kɛnókó arɛ.” ");
INSERT INTO kenNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu arɛm bɛ, “Mmá, nokó ɛnyɨŋ ɛnɛ́ mɛ̌ghàti wɔ. Mpok ǎtwɔ̀ anɛ bo bápú pɛrɛ bhɔŋ bɛchyɛ Ɛta Mandɛm kɛnókó yɛ̌ chi fá ndǔ njiɛ nɛ, yɛ̌ chi Yerúsalɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Bě bo Samaria, bǎchyɛ̀ kɛnókó ntá ɛnyɨŋ ɛnɛ bǎbhɨ́kí rɨŋɨ. Bɛsɛ bo Judeya sɛ́rɨ́ŋɨ́ mmu anɛ sɛ́chyɛ̀ kɛnókó mbɔnyunɛ Mandɛm ǎfʉɛt chí ntá bo Judeya bɛ́pɛ́mɛ bho. ");
INSERT INTO kenNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mpok ǎtwɔ̀, nɛ mpok ɛyɔ anáŋ aghaka anɛ bo abhɛn báchyɛ̀ Ɛta Mandɛm kɛnókó, bákʉ̀ nɔ ɛnyu ɛnɛ́ ɛ́chí tɛtɛp bɛ Ɛfóŋó Mandɛm ǎtɔ̀ŋ bhɔ mbi. Mɛnyǔ bo bhɔ kɛ̌ Mandɛm áyàŋ mánchyɛ́ yi kɛnókó. ");
INSERT INTO kenNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Mandɛm achi Ɛfóŋó, nɛ bǒ abhɛn báchyɛ̀ yi kɛnókó, bábhɔŋ bɛchyɛ yi kɛnókó nɛ ntɨ nɛmɔt ndǔ bɛtaŋ Ɛfóŋó Bɛdyɛrɛ.” ");
INSERT INTO kenNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mɔ́ngɔrɛ́ wu arɛm bɛ, “Ndɨ́ŋɨ́ bɛ́ Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò, yi mmu bábhɨ̀ŋɨ bɛ Kristo átwɔ̀. Ánáŋ ántwɔ́, chɔŋ angati bhɛsɛ barak ankɛm.” ");
INSERT INTO kenNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu aghati yi bɛ, “Mɛ, mmu nchí rɛm nɛ́ kɛpɨ nɛ wɔ, kɛ nchí Mpɛmɛ.” ");
INSERT INTO kenNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nkúbhɛ́ mpok yɔ, bakoŋo Yesu báfú ɛbhak ɛnɛ́ bárɔ́ŋɔ́ bɛku nɛnyíɛ́ bápɛtnsɛm. Bábhák maknkay bɛghɔ bɛ Yesu ǎrɛ̀m kɛpɨ nɛ ngɔrɛ́, kɛ yɛ̌ mmǔ wap kɛbhɛ́p ngɔrɛ́ wu bɛ, “Ɔ̌yàŋ yi?” Nɛ yɛ̌ amɔt kɛbhɛ́p Yesu bɛ, “Ndaká yí ɔ́rɛ̀m kɛpɨ nɛ yi?” ");
INSERT INTO kenNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ngɔrɛ́ wu arɔ ɛtě manyiɛp ɛyi, arɔk ɛtɔk téé, abho bɛ́gháti bho bɛ, ");
INSERT INTO kenNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Twɔ́ ká ghɔ mmǔ anɛ ághátí mɛ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ́ nkʉ́ ndǔ nɛpɛ́m ɛna. Chí Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò kɛ?” ");
INSERT INTO kenNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ɛ́kʉ́ ɛtɔk ɛnkɛm ɛ́móko, bábhó bɛ́rɔŋ ntá Yesu. ");
INSERT INTO kenNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mpok anɛ ngɔrɛ́ wu árɔ́ árɔ́ŋɔ́ ɛtɔk, bakoŋo Yesu báré nɨk yí mmʉɛt bɛ́ “Ntɔŋ, nnyiɛ́ mbɔ nɛnyíɛ́.” ");
INSERT INTO kenNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Kɛ yí aghati bhɔ bɛ, “Mbɔ̌ŋ nɛnyíɛ́ mɛ́nyiɛ ɛnɛ́n bǎbhɨ́kɨ́ rɨŋɨ.” ");
INSERT INTO kenNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ɛ́kʉ́, bábho bɛbhɛp batɨ bɛ, “Mmǔfú atwɔ yi nɛ nɛnyíɛ́ kɛ́?” ");
INSERT INTO kenNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu aghati bhɔ bɛ, “Nɛnyiɛ́ ɛna chi bɛkʉ ɛnyɨŋ ɛnɛ mmu anɛ átó mɛ áyàŋ nkʉ́, nɛ mɛnáŋá bɛtɨk ɛbhi. ");
INSERT INTO kenNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Pú bǎrɛ̀m bɛ, ‘Mbák ɛ́ngáká bataŋ anwi, chɔŋ mámfɛrɛ mbwɔt ɛbhɨ?’ Kɛ nchí ghati bhe bɛ mǎnjoŋ amɨ́k mǎnjɨŋɨ nkɨ, mǎngɔ́ ndǔ mbwɔt ánáŋ ágháká bɛ́fɛ́rɛ ɛbhɨ. ");
INSERT INTO kenNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mmu anɛ áfɛ̀rɛ mbwɔt ɛbhɨ, ǎbhɔŋ akap ndǔ bɛtɨk ɛbhi. Nɛ ǎnyokoti mbwɔt anɛ áchí chí bo abhɛn bábhɔ̀ŋ nɛpɛ́m ɛnɛn nɛbhɨkɨ bhɔŋ ngwɛnti, bɛ mmu anɛ ápɨ̀ mbwɔt nɛ anɛ áfɛ̀rɛ yɔ ɛbhɨ, bɔ́ mankɛm mámbɔ́ŋ maŋák. ");
INSERT INTO kenNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ɛchí tɛtɛp mbɔ ɛnyu bárɛ̀m bɛ, ‘Mmu bɛ́pɨ ǎpɨ, anɛ bɛghɛm angɛm.’ ");
INSERT INTO kenNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ntǒ be bɛ mǎndɔk mǎmfɛrɛ mbwɔt anɛ bǎbhɨkɨ pɨ. Bo bachak bápɨ, be bǎghɛ̀m mbwɔt anɛ bɔ bapɨ.” ");
INSERT INTO kenNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Bɛyǎ bo Samaria abhɛn báfú ɛtɔk mánóko Yesu ɛ̌ti nɛrɛm anɛ ngɔrɛ́ wu arɛmɛ bɛ, “Aghátí mɛ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ nkʉ́ ndǔ nɛpɛ́m ɛna.” ");
INSERT INTO kenNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Mpok bátɛ́mɛ́rí Yesu, mánɨ́k yi mmʉɛt bɛ ámbák nɛ bhɔ, nɛ abhak nɛ bhɔ́ ndǔ manywɔp apay. ");
INSERT INTO kenNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Nɛ bɛyǎ bo báchák mánóko ɛ̌ti mɛnyɨŋ ɛbhɛn Yesu aghati bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ɛ́kʉ bárɛ́m ntá ngɔrɛ́ wu bɛ, “Ɛpɛ́t ɛpu bɛ́ ɛ̌ti mɛnyɨŋ ɛbhɛn ɔ́rɛ́mɛ́ kɛ sɛ́nókó. Bɛsɛ́ babhɔŋ sɛ́ghok nɛ batú bɛyɔŋ ɛbhɛn bɛ́fú yi anyu, nɛ sɛ́rɨŋɨ bɛ nɛ́ chí Mpɛmɛ bǒ mmɨk tɛtɛp.” ");
INSERT INTO kenNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Manywɔp apay anɛ Yesu achi nɛ bo Samária áfʉ́ɛ́rɛ́ nɔ́kɔ́, afa bɛrɔŋ atú Gálili. ");
INSERT INTO kenNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yímbɔŋ arɛm nyaka bɛ, “Bápú chyɛ ndɛmɛkɛpɨ̌ntɨ kɛnókó amɛm ɛtɔk ɛyi.” ");
INSERT INTO kenNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Mpok Yesu áchwɔ́bhɛ́ Gálili, bǒ Galili básɔt yi nɛ maŋák ndu bághɔ́ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ yi ákʉ́ Yerúsalɛm mpok bárɔ́ŋɔ́ arɛ ndǔ Ɛpǎ Nɛkɨŋɨ. Bɔ́ nkwɔ bárɔŋ nyaka ndǔ ɛpǎ yɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesu apɛt arɔk ɛtɔk Kána, atú Gálili, ndǔ nɛbhʉɛt anɛ yi ákú nyaka manyiɛp áyíbhírí mmɛ́m. Mǔnti amɔt abhak Kapɛ̌naum anɛ mɔ́ywi áme. ");
INSERT INTO kenNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ághókó nɔ́kɔ́ bɛ́ Yesu afǔ atú Judɛ́ya átwɔ̀ Gálili, arɔk are nɨk yi mmʉɛt bɛ ándɔ́k Kapɛ̌naum ámbú mɔ́ywi. Mɔ́wu arɔp nyaka chi kɛ́kwɔ́t bɛ́gu. ");
INSERT INTO kenNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu aghati mǔngo wu bɛ, “Bǎpú ka mɛnoko mɛ mbák bǎbhɨ́kɨ́ ghɔ́ bɛrɨŋɨ́ maknkay.” ");
INSERT INTO kenNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mǔngo wu arɛm bɛ, “Ɛta, twɔ́ sɛ́ndɔ́k bɛ mɔ́wa ákɛ́ sɛbhɛ.” ");
INSERT INTO kenNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu akɛmɛ yi bɛ, “Pɛtnsɛm anywɔ́p, mɔ́ywɛ apú gú.” Mǔngo wu anoko ɛnyɨŋ ɛnɛ Yesu árɛ́mɛ́, afa, are gurɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ɛnɛ́ yi ásɛ̀p árɔ̀ŋ, bǒ bɛtok bhi bátɛ́mɛ́ri yi ambi, baghati yi bɛ, “Mɔ́ywɛ achí nɛpɛ́m.” ");
INSERT INTO kenNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Abhɛ́p bhɔ́ bɛ, “Ntɨkɨ mpok yi ábhó bɛ́chɔkɔ sayri?” Bákɛ́mɛ yi bɛ, “Ɛ́yu ndu nkárɛ́nká amɔt nɛ ngósí.” ");
INSERT INTO kenNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Chi mɔ́wu atɨk bɛ́ ndǔ nkúbhɛ́ nɛŋɔkɔ́ nywɔp ɛnɔ kɛ̌ Yesu ághati yi bɛ, “Mɔ́ywɛ apú gú.” Ɛ́kʉ́ mǔngo wu nɛ *ɛfo ɛyi ɛnkɛm mánóko Yesu. ");
INSERT INTO kenNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ɛnyɨŋ ɛnɛ ɛ́bhák ɛrɨŋ ɛnɛ́ ɛ́jwí bɛpay ndǔ mɛnyɨŋɨ́ maknkay ɛbhɛn Yesu ákʉ́ mpok yi áfú atú Judɛ́ya arɔŋɔ atú Gálili. ");
INSERT INTO kenNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ɛ́tárɛ́ nɔ́kɔ́, mpok ɛpǎ bo Israɛl ɛ́chák akwáy. Yesu akó, arɔk Yerúsalɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ɛ̌ntɨ́ŋnyɛ́n ɛbhak Yerúsalɛm, kɛ́kwɔ́t nɛ nyǔ-ɛbhá anɛ bábhɨŋɨ bɛ nyǔbha bághɔ́ŋɔmɛ́n. Bábhɨŋɨ ɛ̌ntɨ́ŋnyɛn ɛyɔ ndǔ ɛyɔŋ ɛnɛ́ bo Israɛl bɛ Bɛtsáta. Bɛ́tɛm bɛtay bɛbhak kɛkwɔt nɛ ɛ̌ntɨŋ ɛyɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Bɛyǎ bǒmame bábhák arɛ́; manɛ́mámɨk, nɛ babhɛ́nti, nɛ abhɛn bachi bhʉrɛ́. Báré noŋ bɛ nnyɛ́n nɛ́mboŋ. ");
INSERT INTO kenNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Mpok nɛ mpok, ángɛl Mandɛm ǎsɛ̀p nyaka amɨk amboŋ ɛ̌ntɨ́ŋnyɛn ɛyɔ. Nɛ mmǔ nɛme anɛ áyámbɨ ásɛ́bhɛ́ amɛm, yɛ̌ntɨkɨ ɛnyǔ nɛme ɛnɛn yi abhɔŋɔ nɛ́may. ");
INSERT INTO kenNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mmǔ amɔt abhak arɛ́ anɛ ánáŋ áchí nyaka amɨk ndǔ nɛme mamiɛ́ ɛsǎ nsɛm nɛku nɛ arat. ");
INSERT INTO kenNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu ágháká nɔ́kɔ́ ndu bɛtɛm ɛbhɔ, aghɔ́ mmu wu bhʉ́rɛ́. Arɨŋɨ bɛ́ yi anáŋ atat arɛ́ ndǔ ɛrɔ́rí mpok. Abhɛ́p yi bɛ, “Ɔ̌yáŋ bɛ́ ɔ́ntáŋ?” ");
INSERT INTO kenNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mmǔ nɛme wu akɛmɛ Yesu bɛ, “Ɛta, mmu apú anɛ ápɔ̀kɔ mɛ nsɛp anyɛ́n ayak mpok nnyɛ́n nɛ́bòŋ. Mpɛrɛ́ nu bɛ́chwɔ́p arɛ́, mmu achák anáŋ áyámbɨ.” ");
INSERT INTO kenNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu aghati yí bɛ, “Faté, pɔkɔ́ ɛ̌sák ɛyɛ kɔ.” ");
INSERT INTO kenNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Tɛ́mté wu, mmu wu ataŋ. Asɔt bɛkpaka bhi abho bɛkɔ. Nywɔp ɛnɔ nɛ́bhak chí nywɔbhɛ́ nɛywěmʉɛt bo Israɛl. ");
INSERT INTO kenNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ɛ́kʉ, bo Israɛl bárɛm ntá mmu anɛ bábú yi bɛ, “Ɛchɔŋ chi nywɔbhɛ́ nɛywěmʉɛt nɛ ɛbhé ɛ́bhɨ́kɨ́ ka bɛ ɔ́mpɔ́kɔ́ ɛ̌sák ɛyɛ.” ");
INSERT INTO kenNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Akɛmɛ bhɔ bɛ, “Mmu anɛ ábú mɛ kɛ ághátí mɛ bɛ, ‘Pɛ́t ɛ̌sák ɛyɛ, faté kɔ.’” ");
INSERT INTO kenNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Bábhɛ́p yi bɛ, “Mmǔrɛ́ ághátí wɔ ɔmpɛt ɛ̌sák ɛyɛ ɔnkɔ chí agha?” ");
INSERT INTO kenNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Kɛ yi kɛ rɨŋɨ mmu wu. Yesu ábú nyaka yi anɔnɛ arɔk mbɔnyunɛ bɛyǎ bo báchí nyaka arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ɛ́bhɨ́kɨ́ tat, Yesu atɛmɛri yi amɛm ɛkɛrákap Mandɛm, aghati yi bɛ, “Yɨŋɨ́, ɔnáŋ ɔtaŋ! Dɔ̌ bɛbʉ́ bɛ ɛsɔŋɔri ɛnɛ́ ɛ́chá ɛyɔ ɛ́kɛ́ tɛmɛri wɔ.” ");
INSERT INTO kenNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mmǔ wu arɔ, arɔk, aghati bǒbati bo Israɛl bɛ Yesu kɛ ábú yi. ");
INSERT INTO kenNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ɛ̌ti yɔ kɛ̌ bo Israɛl bábhó bɛ́chyɛ Yesu nɛnyok, bɛ yi akʉ mmu ataŋ ndǔ nywɔbhɛ́ nɛywěmʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Kɛ Yesu aghati bhɔ́ bɛ, “Ɛtaya ǎkʉ̀ bɛtɨk mpoknkɛm, nɛ mɛnkwɔ́ mbɔŋ bɛkʉ bɛtɨk.” ");
INSERT INTO kenNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ɛ̌ti ɛnyɨŋ ɛnɛ Yesu árɛ́mɛ́, bo Israɛl bápɛ́t báre yaŋ mbi bɛway yi. Ntí abhak bɛ, puyɛ̌ chi ndiɛrɛ bɛ akwɛn ɛbhé nywɔbhɛ́ nɛywěmʉɛt, kɛ ndak anɛ́ akpɨk ábɛ́bhɛ́ áchá ábhák bɛ, yí ǎbhɨ̀ŋɨ Mandɛm bɛ ɛtayi, nɛ bɛ bɛ́kʉ nɔ chi bɛyɛnti mmʉɛt nɛ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu aghati bhɔ bɛ, “Tɛtɛ̌tɛp, Mmɛ Mmɔ Mandɛm mpú kwáy bɛkʉ yɛ̌nyɨŋ ndǔ bɛtaŋ ɛbha. Mɛ́kʉ̀ chí mɛnyɨŋ ɛbhɛn ngɔ́ Ɛtaya ákʉ̀. Yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ́ Ɛtaya ákʉ̀, yɔ́ kɛ Mɛ Mɔ́ywi nchí kʉ nkwɔ́. ");
INSERT INTO kenNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ɛ́chí ɛnyu ɛyɔ mbɔnyunɛ Ɛta akɔŋ Mmɛ Mɔ́ywi, nɛ ǎtɔŋ mɛ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ yímbɔŋ ákʉ̀. Nɛ chɔŋ antɔŋ mɛ mɛnyɨŋɨ́ maknkay ɛbhɛn bɛcha ɛbhɛn, bɛ manyu ánchók bhe. ");
INSERT INTO kenNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Nkúbhɛ́ mbɔ ɛnyǔ Ɛta áŋɛ̀mɛ bawú anchyɛ bhɔ nɛpɛ́m, nɔ́ kɛ̌ Mmɛ Mɔ́ywi nchí chyɛ nɛpɛ́m ntá yɛ̌ agha anɛ mɛ́yàŋ bɛchyɛ nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Yɛ̌ mmu, Ɛta apu taŋ manyé yi. Áchyɛ́ bɛtaŋ mɛnkɛm ntá ya, Mmɛ Mɔ́ywi, bɛ ntáŋ yɛ̌ntɨkɨ mmu. ");
INSERT INTO kenNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ǎkʉ nɔ bɛ bo mankɛm mánchyɛ́ Mmɛ Mɔ́ywi kɛnókó nkúbhɛ́ mbɔ ɛnyǔ báchyɛ̀ yi kɛnókó. Mmǔ anɛ apu chyɛ Mmɛ Mɔ́ywi kɛnókó, apú chyɛ kɛnókó ntá Ɛtaya mmu ato mɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Tɛtɛ̌tɛp, mmǔ anɛ ághókó ɛnyɨŋ ɛnɛ mɛ̌rɛ̀m, anoko mmu anɛ átó mɛ, ǎbhɔ̀ŋ nɛpɛ́m ɛnɛn nɛbhɨkɨ bhɔŋ ngwɛnti. Mandɛm apú rɛm bɛ bɛkwɛ́nɛ́ bɛchi nɛ yi. Afǔ ndǔ nɛwú, achwe ndǔ nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Tɛtɛ̌tɛp, mpok ǎtwɔ̀, nɛ anáŋ akway, anɛ bawú bághòk ɛyɔŋ ɛya, Mmɛ Mmɔ Mandɛm, nɛ abhɛn bághókó mámbɔŋ nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nkúbhɛ́ mbɔ ɛnyǔ Ɛta áchyɛ̀ nɛpɛ́m, nɔ kɛ̌ yi áchyɛ́ Mmɛ Mɔ́ywi nkwɔ bɛtaŋ bɛ́chyɛ bo nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Nɛ achyɛ́ mɛ bɛtaŋ ndu bɛ́táŋ bo, mbɔnyunɛ mɛ kɛ mfú ntá Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Bǎkɛ́ bhak maknkay bɛghok mɛnyɨŋ ɛbhɛn. Mpok ǎtwɔ̀ anɛ bawú mankɛm bághok ɛyɔŋ ɛya amɛm manɛm ayap. ");
INSERT INTO kenNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Nɛ mǎnáŋ mángók ɛyɔŋ ɛya, báfù ndǔ manɛm ayap. Abhɛn bákʉ́ nyaka bɛrɨ ndǔ mmɨk nɛ, máŋɛmɛ, manchwe ndǔ nɛpɛ́m ɛnɛn nɛbhɨkɨ bhɔŋ ngwɛnti, nɛ abhɛn bákʉ́ nyaka bɛbʉ́, máŋɛmɛ mámbɔ́ŋ ntɛmsi.” ");
INSERT INTO kenNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yesu arɔk ambɨ bɛrɛm bɛ, “Mpú kwáy bɛkʉ yɛ̌nyɨŋ ndǔ bɛtaŋ ɛbha. Ɛnɛ́ mɛ̌kʉ̀ nchí kʉ chi ndǔ bɛtaŋ Mandɛm mmu átó mɛ. Mɛ̌tàŋ bo mbɔ ɛnyǔ yi aghati mɛ ntaŋ bo. Nɛ mɛ̌tàŋ bo chí ɛnyu ɛnɛ́ ɛchí chak, mbɔnyunɛ mpú kʉ mɛnyɨŋ ɛbhɛn mɛmbɔŋ nchí yaŋ bɛkʉ. Nchí kʉ chi mɛnyɨŋ ɛbhɛn mmu anɛ átó mɛ áyàŋ nkʉ. ");
INSERT INTO kenNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Mbák ndɛm ɛ̌ti mmʉɛ́t ɛya, mbɔ̌ŋ bo abhɛn bakway bɛ́rɨŋɨ bɛ ɛnyɨŋ ɛnɛ mɛ̌rɛ̀m ɛ́bhɨ́kɨ́ bhɔŋ mɛnwɔp. ");
INSERT INTO kenNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Mmǔ anɛ áté mɛ ntísiɛ achi nyáŋá, nɛ ndɨ́ŋɨ́ bɛ́ ɛnyɨŋ ɛnɛ́ yi árɛ̀m ɛ̌ti ya ɛbhɔŋ mɛnwɔp. ");
INSERT INTO kenNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Bǎtò nyaka bo ntá Jɔ̌n bɛ mámbɛp yi ángati bhe ɛ̌ti ya, nɛ aghati bhe ɛnyɨŋ ɛnɛ́ ɛchi tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Puyɛ̌ chi bɛ nkwǎŋwaŋ kɛ ábhɔ́ŋɔ́ bɛ́té mɛ ntísiɛ, nchí ghati bhe ɛnyɨŋ ɛnɛ Jɔ̌n árɛ́mɛ́ ɛ̌ti ya bɛ Mandɛm ámpɛ́mɛ́ bhe. ");
INSERT INTO kenNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jɔ̌n achi nyaka mbɔ ɛrɔ́ŋɔ́ ɛnɛ ɛ́dù ɛ́ngɔ nɔkɔ ŋwaaŋ, ndu mɔ́mbɨŋɨ mpok, bǎka ɛyɔŋ ɛyi nɛ bǎbhɔ́ŋ maŋák ndu mɔ́mbɨŋɨ mpok. ");
INSERT INTO kenNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Kɛ mɛnyɨŋ bɛ́chí ɛbhɛn bɛ́rɛ̀m ɛ̌ti ya ɛnyu ɛnɛ́ ɛ́chá ɛnyɨŋ ɛnɛ Jɔ̌n árɛ̀m. Nkúbhɛ́ mɛnyɨŋ ɛbhɛn mɛ́kʉ̀, bɛ́tè mɛ ntísiɛ bɛ Ɛta kɛ átó mɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nɛ Ɛta, yímbɔŋ, mmu átó mɛ áté mɛ ntísiɛ. Bǎbhɨ́kɨ́ re ghok ɛyɔŋ ɛyi, bǎbhɨ́kɨ́ re ghɔ́ ɛnyǔ yi achi. ");
INSERT INTO kenNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Nɛ Ɛyɔŋ ɛyi ɛ́pú amɛm batɨ yɛka mbɔnyunɛ bǎbhɨ́kɨ́ noko mmu anɛ yi átó. ");
INSERT INTO kenNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Bǎfyɛ̀ bɛtaŋ bɛpay Ɛyɔŋ Mandɛm mbɔnyunɛ bǎkáysí bɛ ɛ́tɔ̀ŋ be mbi nɛpɛ́m ɛnɛn nɛbhɨkɨ bhɔŋ ngwɛnti nɛ yɔ́ ɛ́rɛ̀m chi ɛ̌ti ya. ");
INSERT INTO kenNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Yɛ̌ nɔ, bǎpú ka bɛ́twɔ ntá ya bɛ mǎmbɔ́ŋ nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Mpú yáŋ nɔ chi kɛnókó ntá nkwǎ. ");
INSERT INTO kenNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nchí rɛm mɛnyɨŋ ɛbhɛn mbɔnyunɛ ndɨ́ŋɨ́ bhe. Ndɨ́ŋɨ́ bɛ́ ɛkɔŋ Mandɛm ɛ́pú amɛm batɨ yɛka. ");
INSERT INTO kenNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ntwɔ̌ ndǔ nnyɛ́n Ɛtaya, nɛ bǎbhɨ́kɨ́ sɔt mɛ mbɔ mmu. Mbɔ mmu achák kɛ átwɔ́ nɔ́ árɛ̀m ɛ̌ti ndu mmʉɛt yi nɛ ndǔ bɛtaŋ ɛbhi mbʉ bǎsɔ́t yi mbɔ mmu ywɛka. ");
INSERT INTO kenNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ná bǎkway mɛnoko ɛnɛ́ báyàŋ chi bakak amɛn bǎchyɛ̀ batɨ, kɛfyɛ́ ntí ndǔ bakak amɛm Mandɛm áchyɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Bǎkɛ́ kaysi bɛ́ chɔŋ ngati Ɛta ɛnyǔ bho bǎchi. Moses kɛ ághati chɔŋ yi, Moses mmu bǎbhaka ntɨ nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mbɔ mǎnókó ɛnyɨŋ ɛnɛ Moses ásɨ́ŋɨ́ tɛtɛp, mbʉ́ mǎnókó ɛnyɨŋ ɛnɛ mɛ̌ghàti bhe. Moses asɨ́ŋɨ́ nyaka chí ɛ̌ti ya. ");
INSERT INTO kenNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mbák bǎbhɨ́kɨ́ noko basɨŋ ami, ná bǎkway mɛ́nóko ɛnyɨŋ ɛnɛ mɛ́rɛ̀m?” ");
INSERT INTO kenNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ɛ́tárɛ́ nɔ́kɔ́, Yesu apé, arɔk ɛbhě Manyu Gálili. Nkúbhɛ́ Manyu wu kɛ bábhɨŋɨ bɛ Manyu Tibérias. ");
INSERT INTO kenNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ngɛ́mtay bo báré koŋo yi mbɔnyunɛ bághɔ̌ nyaka mɛnyɨŋɨ́ maknkay ɛbhɛn yi ákʉ́ ntá bǒmame. ");
INSERT INTO kenNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu akó ambɨ njiɛ, achɔkɔ arɛ́ nɛ bakoŋo bhi. ");
INSERT INTO kenNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ɛpǎ bo Israɛl ɛnɛ́ bábhɨŋɨ bɛ Ɛpǎ Nɛkɨŋɨ ɛ́rɔ́p kɛkwɔt. ");
INSERT INTO kenNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ayibhiri mmʉɛt, ayɨŋɨ, aghɔ́ ndǔ ngɛ́mtay bho bátwɔ̀ ntá yi. Abhɛ́p Fílip bɛ, “Chɔŋ sɛ́mbɔŋ brɛt bɛ́ku fá anɛ ákway bǒbhɛn?” ");
INSERT INTO kenNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu arɛm nɔ ndu mɛmɔ Fílip mbɔnyunɛ yímbɔŋ árɨ́ŋɨ́ nyaka ɛnyɨŋ ɛnɛ yi ábhɔ́ŋɔ́ bɛkʉ. ");
INSERT INTO kenNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Fílip akɛmɛ Yesu bɛ, “Nkáp nkʉbɛtɨk ndǔ manywɔp bɛsǎ byo ápú kway bɛ́ku brɛt anɛ yɛ̌ntɨkɨ mmu wap akway bɛbhɔŋ mandú.” ");
INSERT INTO kenNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Nkoŋo ywi amɔt anɛ achí manɔ Símun Píta anɛ aka nnyɛ́n bɛ́ Andru arɛm ntá yi bɛ, ");
INSERT INTO kenNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Mmɔ̌ amɔt achi fá, anɛ ábhɔ́ŋɔ́ bɛkpɔkɔ́ brɛt bɛtay nɛ nsi ɛpay, kɛ ɛyɔ chi yi ntá bɛyǎ bǒbhɛn?” ");
INSERT INTO kenNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu aghati bhɔ bɛ, “Kʉ ka bo mánchɔ́kɔ́ amɨk.” Tákɔ ayá nɛbhʉɛt ɛ́rɛ. Ɛ́kʉ bo báchɔ́kɔ amɨk. Babhakanɛm bábhák mbɔ nká ɛtay. ");
INSERT INTO kenNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesu asɔt yɛ bɛkpɔkɔ́ brɛt bhɔ. Áchyɛ́ nɔ́kɔ́ bakak ntá Mandɛm, akɔrɛ ntá bo abhɛn báchɔ́kɔ́ amɨk. Akʉ ɛnyumɔ́t nɛ nsi. Yɛ̌ntɨkɨ mmu anyiɛ́ kpát ajwi. ");
INSERT INTO kenNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Yɛ̌ntɨkɨ mmu ányíɛ́ nɔ́kɔ́ ɛnǐ ɛnɛ́n nɛ́kwáy yi, Yesu aghati bakoŋo bhi bɛ, “Nyokotí ká mbwɔ́ptí anɛ árɔ́bhɛ́ bɛ yɛ̌nyɨŋ ɛkɛ chɔŋti ndɛ́ndɛm.” ");
INSERT INTO kenNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Mányókóti yɛ mbwɔpti anɛ bo mányíɛ́, bárɔ́. Ajwi bɛkay byo nɛ bɛpay. ");
INSERT INTO kenNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Bo abhɛn báchi arɛ́, bághɔ́ nɔ́kɔ́ ɛrɨŋɨ́ maknkay ɛyɔ, bárɛ́m bɛ, “Tɛtɛp, nɛ́ chi ndɛmɛkɛpɨ̌ntɨ Mandɛm anɛ ábhɔ́ŋɔ́ nyaka bɛ́twɔ fá amɨk.” ");
INSERT INTO kenNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu aghɔ́ bɛ bo báyàŋ bɛ́kɛm yi nɛ bɛtaŋ bɛ mánkʉ yi Mfɔ, afa, akó njiɛ, abhak arɛ́ aywǐnti. ");
INSERT INTO kenNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Běku bɛ́gháká nɔ́kɔ́, bakoŋo Yesu basɛp, barɔk angɔkɔ manyu, ");
INSERT INTO kenNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","báchwe amɛm áchwi bárè pé nnyɛ́n bɛrɔŋ Kapɛ̌naum. Bɛti mɛ́naŋ bɛ́gʉ nyaka ɛnɛ́ Yesu ábhɨ́kɨ́ re tɛmɛri bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Mbʉ́ɛ́p ataŋataŋ abho mɛnu. Ɛkʉ bɛtaŋtí mpɛ́rɛ́nyɛn ɛya anyɛ́n. ");
INSERT INTO kenNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Bakoŋo bhi mánók mbɔ bɔkilomɛta batay nɛ batandat. Bághɔ́ nɔ́kɔ́ ndǔ yi ákɔ̀ anyɛ́n átwɔ̀ kɛkwɔt nɛ bhɔ, bɛ́cháy bɛ́kɛ́m bhɔ tontó. ");
INSERT INTO kenNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Kɛ Yesu aghati bhɔ bɛ, “Bǎkɛ́ chay. Chi mɛ!” ");
INSERT INTO kenNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Báká yɛ bɛ yi anchwe amɛm áchwí. Nɛchwe yi áchwé, áchwí arɔk atɛmɛ angɔkɔnyɛ́n, ndǔ nɛchyɛ̌nyɛn ɛnɛn bɔ́ bárɔ̀ŋ arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Nɛ́yí nɔ́kɔ́, bo abhɛn bárɔ́bhɛ́ ɛbhěnyɛn ɛnɛ Yesu nɛ bakoŋo bhi báfú arɛ́, bátɨk bɛ ndiɛrɛ áchwí amɔt kɛ áchí nyaka arɛ, nɛ bɛ Yesu abhɨ́kɨ́ chwe amɛm áchwí wu andɔk nɛ baghɔkɔ́ bhi. Bɔ́ bárɔ́ nyaka yi bárɔ́k. ");
INSERT INTO kenNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ɛ́fákári bɛ bachwi achak anɛ áfú Tibérias átwɔ́ kɛkwɔt ndǔ nɛbhʉɛt anɛ bɔ mányíɛ́ nyaka brɛt mpok Acha ánaŋ áchyɛ́ bakak ntá Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Bǒ bhɔ bághɔ́ nɔ́kɔ́ yɛ bɛ Yesu nɛ bakoŋo bhi, bápɛ́t bapu arɛ́, bɔ babhɔŋ báchwé amɛm bachwi yɔ, barɔk Kapɛ̌naum ndu bɛ́yaŋ Yesu. ");
INSERT INTO kenNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Bágháká nɔ́kɔ́ ɛbhě manyu ɛnɛ Yesu árɔ́ŋɔ́ nɛ bakoŋo bhi, bághɔ́ yi arɛ, babhɛp yi bɛ, “Ntɔŋ, ɔpě ɔtwɔ wɛn ntɨkɨ mpok?” ");
INSERT INTO kenNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu akɛmɛ bhɔ bɛ, “Tɛtɛ̌tɛp, bǎpú yaŋ mɛ ɛ̌ti bǎghɔ́ bɛrɨŋɨ́ maknkay, kɛ ɛ̌ti brɛt anɛ mǎnyiɛ́ bǎjwi. ");
INSERT INTO kenNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Bǎkɛ́ fyɛ ntí ndǔ nɛnyíɛ́ ɛnɛn nɛ́chɔ̀ŋti. Fíɛ́ ká ntí chí ndǔ nɛnyíɛ́ ɛnɛn nɛpu chɔŋti, nɛnyíɛ́ ɛnɛn nɛ́chyɛ̀ nɛpɛ́m ɛnɛn nɛbhɨkɨ bhɔŋ ngwɛnti, ɛnɛn Mɛ Mmu mfú ntá Mandɛm nchí chyɛ chɔŋ be. Ɛ̌ti yɔ kɛ Ɛtaya achyɛ ɛrɨŋ bɛtɔŋ bɛ yi kɛ átó mɛ.” ");
INSERT INTO kenNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Bɔ bábhɛ́p yɛ Yesu bɛ, “Bɛtɨk Mandɛm ɛbhɛn sɛ́bhɔ́ŋɔ́ bɛkʉ nɔ́kɔ́ chi yi?” ");
INSERT INTO kenNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu akɛmɛ bhɔ bɛ, “Ɛnyɨŋ ɛnɛ Mandɛm áyàŋ mǎnkʉ chi bɛ mǎnókó mmu anɛ yi átó.” ");
INSERT INTO kenNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ɛ́kʉ bárɛm ntá Yesu bɛ, “Ntɨkɨ ɛrɨŋ ɔ́kwày yɛ bɛkʉ bɛ́ sɛ́ngɔ́, sɛ́noko wɔ? Chɔŋ ɔ́nkʉ yi ntá yɛsɛ? ");
INSERT INTO kenNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Bǎchǐ mbɨ bhɛsɛ́ mányìɛ nyaka mana mpok bákɔ̀ amɛm baso. Ɛnyu ɛyɔ kɛ básɨ́ŋɨ́ amɛm Ɛkáti Mandɛm bɛ, ‘Achyɛ nyaka bhɔ nɛnyíɛ́ ɛnɛn nɛ́fù amfay!’” ");
INSERT INTO kenNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu aghati bhɔ bɛ, “Tɛtɛ̌tɛp, puyɛ̌ Moses kɛ áchyɛ́ nyaka bachǐmbɨ bhɛka nɛnyíɛ́ ɛnɛn nɛ́fú amfay. Ɛtaya kɛ áchyɛ̀ bhe nɛnyíɛ́ ɛnɛn mbɔŋ ɛnɛ́n nɛ́fú amfay. ");
INSERT INTO kenNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nɛnyiɛ Mandɛm chi mmu anɛ áfú amfay atwɔ, nɛ ǎchyɛ nɛpɛ́m ntá bǒ mmɨk.” ");
INSERT INTO kenNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Bárɛm ntá yi bɛ, “Ɛta, chyɛ̌ bhɛsɛ nɛnyíɛ́ ɛnɔ mpoknkɛm.” ");
INSERT INTO kenNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu aghati bhɔ bɛ, “Mɛ kɛ nchí nɛnyíɛ́ ɛnɛn nɛ́chyɛ̀ nɛpɛ́m. Mmu anɛ átwɔ́ ntá ya apu pɛrɛ ghok nsay nɛ mmu anɛ ásɨ̀kɨ ntɨ nɛ mɛ, apú bhɔ́ŋ ɛkwaká manyiɛp wáwák. ");
INSERT INTO kenNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kɛ ngátí bhe bɛ yɛ̌ndu bǎghɔ́ mɛ bǎbhɨ́kɨ́ noko mɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Yɛ̌ nɔ, yɛ̌ntɨkɨ mmu anɛ Ɛta áchyɛ́ mɛ, ǎtwɔ̀ ntá ya. Nɛ yɛ̌ mmu apú twɔ ntá ya mɛ̌mbók yi, ");
INSERT INTO kenNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","mbɔnyunɛ mbɨ́kɨ́ fú amfay ntwɔ́ fá amɨk bɛkʉ ɛnyɨŋ ɛnɛ mɛ̌yáŋ. Ntwɔ bɛkʉ chí ɛnyɨŋ ɛnɛ mmu anɛ átó mɛ áyàŋ mɛ̌nkʉ. ");
INSERT INTO kenNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nɛ ɛnyɨŋ ɛnɛ mmu anɛ átó mɛ áyàŋ nkʉ chi bɛ nkɛ́rɔ yɛ̌ mmu amɔt anɛ yi áchyɛ́ mɛ ánɛ́m, kɛ bɛ́ nkʉ yɛ̌ntɨkɨ mmu wap ámpɛtnsɛm ndǔ nɛpɛ́m ndǔ nywɔp ɛnɛn ngwɛnti. ");
INSERT INTO kenNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ɛnyɨŋ ɛnɛ Ɛta áyàŋ chí bɛ́ yɛ̌ agha anɛ ághɔ́ Mɔ́ywi, asɨkɨ ntɨ nɛ yi, ámbɔ́ŋ nɛpɛ́m ɛnɛn nɛbhɨkɨ bhɔŋ ngwɛnti. Nɛ chɔŋ nkʉ yi ampɛtnsɛm ndǔ nɛpɛ́m ndǔ nywɔp ɛnɛn ngwɛnti.” ");
INSERT INTO kenNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Bo Israɛl bábhó yɛ mɛ́nywinti ɛ̌ti Yesu, ndǔ yi árɛ́mɛ́ bɛ, “Mɛ kɛ nchí nɛnyíɛ́ ɛnɛn nɛ́fú amfay.” ");
INSERT INTO kenNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Báre rɛm bɛ, “Pú Yesu mmɔ̌ Josɛ́f nɛ́? Pú sɛ́rɨ́ŋɨ́ ɛtayi nɛ máyi? Ɛ́kɔ ná kɛ yi arɛm bɛ, ‘Mfu amfay kɛ nchí ntwɔ fá amɨk’?” ");
INSERT INTO kenNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu akɛmɛ bɛ, “Dɔ̌ ká nɛnywíntí ɛnɛká nɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Yɛ̌ mmu apú kwáy bɛ́twɔ ntá ya mbák Ɛtaya mmu átó mɛ abhɨ́kɨ́ ya yi ntá ya. Nɛ mmu anɛ átwɔ́ ntá ya, chɔŋ nkʉ yi ampɛtnsɛm ndǔ nɛpɛ́m ndǔ nywɔp ngwɛnti. ");
INSERT INTO kenNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ɛchí amɛm basɨŋɨ́ barɛmɛ́ kɛpɨ̌ntɨ bɛ, ‘Chɔŋ Mandɛm ántɔ́ŋ bɔ́ mankɛm.’ Yɛ̌ntɨkɨ mmu anɛ ághókó, nɛ aghɔ́k ɛnyɨŋ ɛnɛ Ɛtaya árɛ́mɛ́, ǎtwɔ̀ ntá ya. ");
INSERT INTO kenNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mpú rɛm chi bɛ mmu achi anɛ anaŋ aghɔ Ɛtaya. Mmu anɛ áfú ntá Mandɛm kɛ ánáŋ ághɔ́ yi. ");
INSERT INTO kenNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Tɛtɛ̌tɛp, mmǔ anɛ anoko ǎbhɔŋ nɛpɛ́m ɛnɛn nɛbhɨkɨ bhɔŋ ngwɛnti. ");
INSERT INTO kenNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mɛ kɛ nchí nɛnyíɛ́ ɛnɛ́n nɛ́chyɛ̀ nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Bachǐmbɨ bhɛka mányìɛ nyaka mana amɛm baso, yɛ̌ nɔ, bɔ mankɛm bágú. ");
INSERT INTO kenNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Kɛ nɛ́ chi nɛnyíɛ́ ɛnɛn nɛ́fú amfay, bɛ́ mmǔ anɛ ányíɛ́ nɔ́ ákɛ́ gu. ");
INSERT INTO kenNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mɛ kɛ nchí nɛnyíɛ́ ɛnɛn nɛ́chyɛ̀ nɛpɛ́m ɛnɛn nɛ́fú amfay. Mmu anɛ ányíɛ́ nɛnyíɛ́ ɛnɛn, ǎbhák nɛpɛ́m mpoknkɛm. Nɛnyiɛ́ ɛnɛ́n mɛ̌chyɛ chɔŋ bɛ́ bǒ mmɨk mámbɔ́ŋ nɛpɛ́m, chi nyamwʉɛ́t ɛya.” ");
INSERT INTO kenNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ɛnyɨŋ ɛnɛ Yesu árɛ́mɛ́ ɛ́kʉ́ bo Israɛl bábho bɛkɛm ɛpʉ́ítí nɛ batɨ, mándɛmɛ nɔkɔ bɛ, “Ná mmǔ-nɛ ǎkway bɛchyɛ bhɛsɛ nyamwʉɛ́t ayi bɛ sɛnyiɛ?” ");
INSERT INTO kenNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu aghati bhɔ bɛ, “Tɛtɛ̌tɛp, mbák bǎbhɨ́kɨ́ nyiɛ́ nyamwʉɛ́t Mmu anɛ áfú ntá Mandɛm, mǎnyú manoŋ ami, bǎpú bhɔŋ nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mmǔ anɛ ányíɛ́ nyamwʉɛ́t ya nɛ anyú manoŋ ma, ǎbhɔ́ŋ nɛpɛ́m ɛnɛn nɛbhɨkɨ bhɔŋ ngwɛnti, nɛ chɔŋ nkʉ yi ampɛtnsɛm ndǔ nɛpɛ́m ndǔ nywɔp ɛnɛn ngwɛnti. ");
INSERT INTO kenNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nyamwʉɛ́t ɛya kɛ áchí mbɔ̌ŋ nɛnyíɛ́ mɛnyiɛ, nɛ manoŋ ama kɛ áchí mbɔ̌ŋ mmɛ́m amɛn mɛnyu. ");
INSERT INTO kenNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mmu anɛ ányìɛ nyamwʉɛ́t ya nɛ anyú manoŋ ma, achí babhát nɛ mɛ, nɛ mɛ nkwɔ́ nchí babhat nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ɛta mmu achi nɛpɛ́m kɛ átó mɛ, nɛ ɛ̌ti yi kɛ nchí nɛpɛ́m. Nkúbhɛ́ ɛnyu ɛyɔ kɛ ɛchi bɛ, mmǔ anɛ ányìɛ mɛ ǎbhák nɛpɛ́m ɛ̌ti ya. ");
INSERT INTO kenNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nɛ́ chi nɛnyíɛ́ ɛnɛ́n nɛ́fú amfay nɛ́twɔ́ fá amɨk. Nɛ́pú mbɔ ɛnɛ́n bachǐmbɨ bhɛka mányíɛ́ nyaka, bágú. Mmǔ anɛ ányíɛ́ nɛnyíɛ́ ɛnɛn ǎbhɔŋ nɛpɛ́m ɛnɛn nɛbhɨkɨ bhɔŋ ngwɛnti.” ");
INSERT INTO kenNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu arɛm barak anɛ mpok yi áchí amɛm ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí ɛnɛ ɛtɔk Kapɛ̌naum átɔ̀ŋ bo. ");
INSERT INTO kenNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Bakoŋo Yesu bághókó nɔ́kɔ́ kɛpɨ ɛkɛn yi árɛ̀m, bɛyǎ bhap báré rɛm bɛ, “Anɛ́ ndak ataŋ acha, agha ákwày bɛka wu?” ");
INSERT INTO kenNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu árɨ́ŋɨ́ bɛ́ baghɔkɔ́ bhi mánywìnti ɛ̌ti ndak anɛ. Abhɛ́p bɔ bɛ, “Batɨ ábé bhe ɛ̌ti ndak anɛ ndɛ́mɛ́? ");
INSERT INTO kenNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Mbák mǎngɔ́ yɛ Mɛ Mmu mfú ntá Mandɛm ndu nchí pɛtnsɛm amfay ndǔ nɛbhʉɛt anɛ mfú, bǎrɛm bɛ́ yi? ");
INSERT INTO kenNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ɛfóŋó Mandɛm kɛ áchyɛ̀ nɛpɛ́m. Mmʉɛt nkwǎ apu kʉ yɛ̌nyɨŋ. Bɛyɔŋ ɛbhɛ́n ngátí bhe bɛ́twɔ̀ nɛ Ɛfóŋó Mandɛm nɛ bɛ́chyɛ nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Yɛ̌ nɔ, mbɔk yɛka bábhɨ́kɨ́ noko.” Yesu arɨ́ŋɨ́ bo abhɛn bábhɨkɨ noko yi tɛ ndǔ nɛbhǒnɛt, nɛ arɨ́ŋɨ́ mmu anɛ ábhɔ́ŋɔ́ bɛti yi. ");
INSERT INTO kenNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yesu arɛm yɛ bɛ, “Ɛ̌ti yɔ kɛ ngátí bhé bɛ mmu apú kway bɛ́twɔ ntá ya mbák Ɛta abhɨ́kɨ́ chyɛ yi mbi.” ");
INSERT INTO kenNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nɛbho mpok yɔ, bɛyǎ bakoŋo bhi báya mmʉɛt ansɛm, bɔ́ kɛpɛrɛ koŋo yi. ");
INSERT INTO kenNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ɛ́kʉ́ Yesu abhɛ́p baghɔkɔ́ bhi bati byo nɛ apay bɛ, “Ná nɛ bhe, bǎrɔŋ nkwɔ?” ");
INSERT INTO kenNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Símun Píta akɛmɛ yi bɛ, “Ɛta, ntá agha? Wɔ kɛ ɔ́bhɔ́ŋɔ́ bɛyɔŋ ɛbhɛn bɛ́chyɛ nɛpɛ́m ɛnɛn nɛbhɨkɨ bhɔŋ ngwɛnti. ");
INSERT INTO kenNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Sɛ́noko nɛ sɛ́rɨŋɨ bɛ wɔ kɛ ɔ́chí Mmu Nyáŋá anɛ Mandɛm átó.” ");
INSERT INTO kenNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu akɛmɛ bhɔ́ bɛ, “Pú njap be bati byo nɛ apay? Yɛ̌ nɔ, mmǔ ywɛka amɔt abhɔŋ ɛfóŋó ɛbʉ́bʉ.” ");
INSERT INTO kenNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesu ǎrɛ̀m nyaka nɔ ɛ̌ti Júda, mmɔ̌ Símun Iskariɔt, mbɔnyunɛ Júda, mmu amɔt ndǔ nkwɔ́ baghɔkɔ́ bhi bati byo nɛ apay, abhɔ̌ŋ nyaka nkaysi bɛti yi. ");
INSERT INTO kenNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Barak anɛ áfʉ́ɛ́rɛ́ nɔ́kɔ́, Yesu are kɔ mbǎŋ nɛ mbaŋ, atú Gálili. Yi kɛyáŋ bɛkɔ atú Judɛ́ya mbɔnyunɛ bo Judeya báyàŋ nyaka mbi bɛ́way yi. ");
INSERT INTO kenNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Mpok yɔ, ɛpǎ bo Israɛl ɛnɛ bábhɨŋɨ bɛ Ɛpa Bɛ́tɛm ɛ́rɔp kɛkwɔt. ");
INSERT INTO kenNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ɛkʉ bɔ̌mayi bárɛ́m ntá yi bɛ, “Fǎ fá, dɔ́k atú Judɛ́ya bɛ bakoŋo bhɛ mángɔ́ mɛnyɨŋɨ́ maknkay ɛbhɛn ɔ́kʉ̀. ");
INSERT INTO kenNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Yɛ̌ mmu apú kʉ mɛnyɨŋɨ́ maknkay bhɛ́sɛ́ bhɛ́sɛ́ mbák ǎyàŋ bo mándɨ́ŋɨ́ yi. Tɛ̌ndu ɔ́kʉ̀ mɛnyɨŋɨ́ maknkay, kʉ nɔ́kɔ́ bhɔ kpoŋoroŋ bɛ mmɨk nkɛm ángɔ́.” ");
INSERT INTO kenNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kɛ yɛ̌ chi bɔ̌mayi kɛnoko yí. ");
INSERT INTO kenNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu arɛm ntá yap bɛ, “Mpok aya ábhɨ́kɨ́ re kway, kɛ ntá yɛka yɛ̌ntɨkɨ mpok akway. ");
INSERT INTO kenNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Bǒ mmɨk bápú kwáy bɛpap be. Bápap mɛ mbɔnyunɛ nchí rɛm bɛ mɛnyɨŋ ɛbhɛn bɔ́ bákʉ̀ bɛbɛp. ");
INSERT INTO kenNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Bě babhɔŋ mǎndɔ́k ndǔ ɛpa. Mpú rɔŋ. Mpok aya abhɨ́kɨ́ re kwáy.” ");
INSERT INTO kenNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yesu árɛ́m nɔ́, arɔp atú Gálili. ");
INSERT INTO kenNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ɛnɛ́ bɔ̌mayi mǎnáŋ bárɔ́, bárɔ́ŋɔ́ Yerúsalɛm ndǔ ɛpa ɛyɔ, Yesu arɔk arɛ́ nkwɔ. Kɛ arɔk chi bhɛ́sɛ́ bhɛ́sɛ́, kɛrɔ́ŋ kpoŋoroŋ. ");
INSERT INTO kenNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Bǒbati bo Judeya báré yaŋ yi arɛ́ mándɛmɛ nɔkɔ bɛ, “Yi achí fá?” ");
INSERT INTO kenNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Bo báré rɛm bɛyǎ mɛnyɨŋ ɛ̌ti yi. Mbɔk mándɛmɛ nɔkɔ bɛ, “Yí achi ɛrɨ́tí mmu.” Báchák bɛ, “Nsé, ǎrwɔ̀ bho bɛ mánɛ́m ɛbhɨ!” ");
INSERT INTO kenNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Yɛ̌ nɔ, yɛ̌ mmu amɔt kɛrɛm ɛnyɨŋ kpóŋóróŋ ɛ̌ti yi, mbɔnyunɛ báchày nyaka bǒbati bhap. ");
INSERT INTO kenNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ɛ́gháká nɔ́kɔ́ nɛntɨ ɛpa, Yesu arɔk amɛm ɛkɛrákap Mandɛm abho bɛtɔŋ bo Ɛyɔŋ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Bǒbati bo Judeya bábhák maknkay ndǔ mɛnyɨŋ ɛbhɛn yi átɔ̀ŋ mándɛmɛ nɔkɔ bɛ, “Ná mmǔ-nɛ áré rɨŋɨ ɛnyɨŋ ɛnyu ɛnɛ, ɛnɛ́ yi ábhɨ́kɨ́ ghɔk ɛkáti?” ");
INSERT INTO kenNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu akɛmɛ bhɔ bɛ, “Mɛnyɨŋ ɛbhɛn mɛ̌tɔ̀ŋ bɛ́bhɨ́kɨ́ fu ntá ya. Bɛ́fú chi ntá mmu anɛ átó mɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Yɛ̌ agha anɛ ábhɔ́ŋɔ́ ntɨ bɛkʉ ɛnyɨŋ ɛnɛ Mandɛm áyàŋ, ǎrɨŋɨ bɛ mɛnyɨŋ ɛbhɛ́n mɛ̌tɔ̀ŋ bɛ́fú chi ntá Mandɛm nɛ bɛ puyɛ̌ mɛmbɔŋ kɛ ntɨ́ bɛtɔŋ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mmu anɛ árɛ̀m mɛnyɨŋ ndǔ bɛtaŋ ɛbhi, ǎyaŋ kɛnókó ɛki yímbɔŋ. Mmu anɛ áyàŋ bo mánchyɛ́ kɛnókó chi ntá mmu anɛ átó yi, achí mmǔ tɛtɛp, bapu apú nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses achyɛ́ nyaka bhe bɛbhé, pú nɔ́? Yɛ̌ nɔ́, yɛ̌ mmu ywɛka apú bhʉrɛ́ bhɔ. Ndaká yí bǎyáŋ bɛway mɛ?” ");
INSERT INTO kenNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Bɛyǎ bo abhɛn báchí arɛ bákɛ́mɛ yi bɛ, “Ɛfóŋó ɛbʉ́bʉ ɛ́sɔ̀ŋɔri wɔ! Agha áyàŋ bɛway wɔ?” ");
INSERT INTO kenNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu akɛmɛ bhɔ bɛ, “Nkʉ ɛrɨŋɨ́ maknkay ɛ́mɔt manyu áchok bhe. ");
INSERT INTO kenNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses aghátí nyaka bhe bɛ mǎnsyɛ́bhɛ́ nɔ́kɔ́ bɔ̌bhɛka. Yɛ̌ nɔ, ɛbhé yɔ ɛbhɨkɨ fu nyaka ntá Moses. Ɛ́fú chí ntá bachǐmbɨ abhɛka. Nɛ bǎsìɛp mmu ndǔ nywɔbhɛ́ nɛywěmʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Bě bǎsiɛ̀p bo ndǔ nywɔp nɛywěmʉɛt bɛ bǎkɛ kwɛn ɛbhé Moses. Bǎbentɨ nɛ mɛ mbɔnyunɛ́ nkʉ mmǔ nɛme átáŋ ndǔ nywɔbhɛ́ nɛywěmʉɛt? ");
INSERT INTO kenNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Bǎkɛ́ kpɔ́t manyé mmu bɛkoŋo mɛnyɨŋ ɛbhɛn bǎghɔ́ yi ákʉ̀. Bǎbhɔŋ bɛkpɔt manyé sayri bɛkoŋo tɛtɛp Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Mbɔk bo Yerusalɛm báré rɛm yɛ bɛ, “Pú mmǔ rɛ́ báyàŋ bɛway nɛ? ");
INSERT INTO kenNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Achí fá árɛ̀m kɛpɨ kpoŋoroŋ, nɛ bǎbhɨ́kɨ́ rɛm yɛ̌nyɨŋ ntá yi. Ɛ́kway bɛbhak bɛ bǒbati bárɨŋɨ bɛ yí chí Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò? ");
INSERT INTO kenNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kɛ sɛ́rɨŋɨ ɛbhak ɛnɛ mmǔ-nɛ áfú. Mpok Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò átwɔ́, yɛ̌ mmu apú rɨŋɨ nɛbhʉɛt anɛ yi áfú.” ");
INSERT INTO kenNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ɛ́kʉ́, ndu Yesu átɔ̀ŋ bho amɛm ɛkɛrákap Mandɛm, arɛm nɛ ɛyɔŋ ɛtaŋataŋ bɛ, “Bǎrɨŋɨ mɛ, nɛ bǎrɨŋɨ ɛbhak ɛnɛ mfú? Mbɨ́kɨ́ twɔ ndǔ bɛtaŋ ɛbha. Mmǔ anɛ átó mɛ achí mmǔ tɛtɛp. Bǎbhɨ́kɨ́ rɨŋɨ yi. ");
INSERT INTO kenNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ndɨ́ŋɨ́ yi, mbɔnyunɛ mfú chí ntá yi, nɛ yi kɛ átó mɛ.” ");
INSERT INTO kenNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ɛnyɨŋ Yesu árɛ́mɛ́ ɛ́kʉ́ báré yaŋ bɛkɛm yi, kɛ yɛ̌ mmu abhɨ́kɨ́ tɔk yi awɔ amʉɛt, mbɔnyunɛ mpok ayi abhɨ́kɨ́ re kway nyaka. ");
INSERT INTO kenNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Bɛyǎ bo mánóko yi, mándɛmɛ nɔkɔ bɛ, “Mbák Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò ántwɔ́, chɔŋ ankʉ mɛnyɨŋɨ́ maknkay ɛbhɛn bɛ́chá ɛbhɛn mmǔ-nɛ ákʉ̀?” ");
INSERT INTO kenNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Bǒnkwɔ Fárisi bághókó nɔ́kɔ́ ndǔ bǒ ɛka yɔ bárɛ̀m bɛyǎ mɛnyɨŋ ɛ̌ti Yesu, báchɛm nɛ bǒbati bachiǎkap, bátó babhabhɛrí abhɛn ɛkɛrákap bɛ mankɛm yi. ");
INSERT INTO kenNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu arɛm yɛ ntá yap bɛ, “Mbɔŋ bɛ́pɛt bɛbhak nɛ bhe ndǔ mɔ́mbɨŋɨ mpok kɛ ndɔ́k ntá mmu anɛ átó mɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Chɔŋ mǎnjaŋ mɛ, kɛ bǎpú ghɔ mɛ. Nɛbhʉɛt anɛ mɛ́rɔ̀ŋ bǎpú kwáy bɛ́twɔ arɛ́.” ");
INSERT INTO kenNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Bo Israɛl bábhó bɛrɛm nɛ batɨ bɛ, “Atɨ bɛ́rɔ́ŋ fá, ɛnɛ́ sɛ́pú kway chɔŋ bɛghɔ yi? Atɨ bɛrɔŋ chi ɛtɔkɔ́ mankɔ ɛnɛ́ bǒ bhɛsɛ bátáká bárɔ́ŋɔ́ arɛ́ kɛ? Ǎyàŋ bɛrɔŋ bɛ́tɔŋ bo abhɛn bápú bo Israɛl arɛ́ kɛ? ");
INSERT INTO kenNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Yi bɛ ‘Chɔŋ sɛ́njáŋ yi, kɛ sɛpu ghɔ, nɛ bɛ́ nɛbhʉɛt anɛ yi árɔ̀ŋ, sɛ́pú kway bɛrɔŋ arɛ. Nɔ́ bɛ yi?’” ");
INSERT INTO kenNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ɛ́gháká nɔ́kɔ́ nywɔbhɛ́ ngwɛnti ɛpa, nɔ́ chi, nywɔp nɛgho ɛnɛn ɛpǎ ɛyɔ, Yesu afate arɛm nɛ ɛyɔŋ ɛtaŋataŋ bɛ, “Mmǔ anɛ manyiɛp ákwak yi, ántwɔ́ ntá ya. ");
INSERT INTO kenNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ɛ́chí nkúbhɛ́ mbɔ ɛnyu básɨ́ŋɨ́ amɛm Ɛkáti Mandɛm bɛ, ‘Mmǔ anɛ anókó mɛ, manyiɛp amɛn áchyɛ̀ nɛpɛ́m ǎfu yi antɨ ansɛp nɔkɔ mbɔ nyɛ́n.’” ");
INSERT INTO kenNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu ǎrɛ̀m nyaka nɔ ɛ̌ti Ɛfóŋó Bɛdyɛrɛ ɛnɛ́ bábhɔ́ŋɔ́ bɛchyɛ ntá bo abhɛn mánóko yi. Bábhɨ́kɨ́ re chyɛ nyaka Ɛfóŋó Bɛdyɛrɛ ntá bo abhɛn mánóko mbɔnyunɛ Mandɛm ábhɨ́kɨ́ re sɔt nyaka Yesu amfay, ánchyɛ́ yi kɛnókó. ");
INSERT INTO kenNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Bo bághókó nɔ́kɔ́ bɛyɔŋ ɛbhɛ́n Yesu árɛ́mɛ́, mbɔk bo bábho bɛrɛm bɛ, “Nɛ́, chí ndɛmɛkɛpɨ̌ntɨ Mandɛm anɛ ábhɔ́ŋɔ́ nyaka bɛ́twɔ.” ");
INSERT INTO kenNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Báchák bɛ, “Chi Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò.” Kɛ abhɛ́nɛ́fú bárɛm bɛ, “Yi abhɔŋ bɛfu chi atú Gálili kɛ? ");
INSERT INTO kenNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Pú básɨŋ amɛm ɛkáti bɛ, Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò chi ɛbhárɛ́mɔ Mfɔ Debhít nɛ abhɔŋ bɛ́fu chi Bɛ́tlɛhɛm, ɛtɔk nɛbhe Mfɔ Debhít?” ");
INSERT INTO kenNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ɛ́kʉ́ ákɔ́rɛ́ nɛ bɛtaka bɛkwɛn nɛntɨ nap ɛ̌ti Yesu. ");
INSERT INTO kenNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mbɔk ayap báyàŋ nyaka bɛkɛm yi kɛ yɛ̌ mmu kɛtɔk yi awɔ amʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Babhabhɛri abhɛn ɛkɛrákap Mandɛm bápɛ́t yɛ nsɛm ntá bǒbati bachiǎkap nɛ bǒnkwɔ Fárisi. Bǒbati bábhɛ́p bhɔ́ bɛ, “Ndaká yí bǎbhɨ́kɨ́ twɔ nɛ yi?” ");
INSERT INTO kenNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Babhabhɛri ɛkɛrákap bákɛ́mɛ bhɔ bɛ, “Yɛ̌ mmu abhɨ́kɨ́ re rɛm mɛnyǔ mɛnyɨŋ ɛbhɛn mmǔ wu árɛ̀m!” ");
INSERT INTO kenNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Bǒnkwɔ Fárisi bákɛ́mɛ bhɔ bɛ, “Arwɔ̌ be nkwɔ bǎgúrɛ́ ɛbhɨ? ");
INSERT INTO kenNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Bǎghɔ yɛ̌ mǔnti ɛtɔk amɔt anókó yi? Bǎghɔ yɛ̌ mǔnkwɔ Fárisi anókó yi? ");
INSERT INTO kenNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ndiɛrɛ ndɛ́ndɛmɛbho abhɛn, bábhɨ́kɨ́ rɨŋɨ bɛbhé Moses kɛ mánóko yi. Ntá Mandɛm, bɔ mankɛm bábɛp!” ");
INSERT INTO kenNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikɔdɛ́mɔs, mmǔ wap amɔt anɛ ánáŋ árɔ́ŋɔ́ nyaka ntá Yesu abhɛp bhɔ bɛ, ");
INSERT INTO kenNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ɛbhé ɛyɛsɛ ɛ́ká bɛ mánchyɛ́ mmu ntɛmsi ɛnɛ́ bábhɨ́kɨ́ re taŋ yi, mándɨ́ŋɨ́ sayri sayri ɛnyɨŋ ɛnɛ́ yi ákʉ?” ");
INSERT INTO kenNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Bákɛ́mɛ yi bɛ, “Wɔ nkwɔ́ ɔchí mmǔ Gálili? Yɨŋɨ́ Ɛkáti Mandɛm, chɔŋ ɔ́ngɔ́ bɛ́ yɛ̌ ndɛmɛkɛpɨ̌ntɨ amɔt apú kway bɛfu atú Gálili.” ");
INSERT INTO kenNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Yɛ̌ntɨkɨ mmu árɔ́ yɛ, agurɛ ɛkɛt ɛyi. ");
INSERT INTO kenNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesu arɔk amfay Njiɛ Mɛnɔk Ólif. ");
INSERT INTO kenNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nɛ́yí nɔ́kɔ́, apɛtnsɛm ɛkɛrákap Mandɛm běti běti. Bǒ mankɛm bárɔ́k ntá yi. Achɔkɔ amɨk, abho bɛtɔŋ bhɔ Ɛyɔŋ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Batɔŋ-ɛbhé Mandɛm nɛ bǒnkwɔ Fárisi báyá ngɔrɛ́ anɛ bákɛ́mɛ́ ndǔ akwɛn bɛrwɔp, bátwɔ́ nɛ yi, bátɛp bɛsí bǒ mankɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Bárɛ́m ntá Yesu bɛ, “Ntɔŋ, bákɛ̌m ngɔrɛ́ ndu ákwɛ̀n bɛrwɔp. ");
INSERT INTO kenNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ɛkáti bɛbhé Moses ɛ́ghàti bhɛsɛ bɛ bábhɔŋ bɛ́tɛ́mti ɛnyǔ ngɔrɛ́ nɛ nɛ batay mángwáy. Ɔrɛm bɛ́ yí?” ");
INSERT INTO kenNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bárɛ́m nɔ ndu mɛmɔ yi bɛ mámbɔ́ŋ mbi bɛbhat ndak yi amʉɛt. Yesu atɛp ntí amɨk, ansɨŋɨ nɔkɔ ɛnyɨŋ amɨk nɛ sɛnɔŋ awɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ndu bárɔŋ ambɨ bɛrɛm bɛ yi ánchyɛ́ bhɔ ɛyɔŋ, anyabhɛ mmʉɛt téé, aghati bhɔ bɛ, “Mmǔ ywɛka anɛ ábhɨ́kɨ́ re kʉ bɛbʉ́ ánjámbɨ ámbwɔ́p ntay antɛm yi.” ");
INSERT INTO kenNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Apɛt atɛp ntí amɨk ánsɨ́ŋɨ́ nɔ́kɔ́ ɛnyɨŋ amɨk nɛ sɛnɔŋ awɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Bǒ bhɔ bághókó nɔ́kɔ́ ɛnyɨŋ ɛnɛ Yesu árɛ́mɛ́, bábhó bɛrɔ amɔt amɔt, bɛbho nɛ baseansi. Yesu arɔp aywǐnti nɛ ngɔrɛ́ wu arɛ́ téé, bɛsí bhi. ");
INSERT INTO kenNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu ayoŋ amɨ́k arɛm ntá yi bɛ, “Mma, bɔ́ báchí fá? Yɛ̌ mmu abhɨ́kɨ́ rɛm bɛ mángwáy wɔ?” ");
INSERT INTO kenNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Akɛmɛ Yesu bɛ, “Ɛta, yɛ̌ amɔt.” Yesu arɛm bɛ, “Mɛ nkwɔ́ mbɨ́kɨ́ rɛm bɛ mángwáy wɔ. Dɔ́k, kɛ ɔ́kɛ́ pɛrɛ kʉ bɛbʉ́”. ");
INSERT INTO kenNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu apɛt abho bɛ́gháti bho mɛnyɨŋ. Arɛm bɛ, “Nchí ɛrɔ́ŋɔ́ ɛnɛ ɛ́chyɛ̀ nɛpɛ́m. Mmu anɛ ábhárɛ́ mmʉɛt nɛ mɛ, ǎbhɔŋ bɛdiɛ́rɛ́ ɛbhɛn bɛ́kʉ̀ bo mámbɔ́ŋ nɛpɛ́m, nɛ apú kɔ amɛm ɛjuri.” ");
INSERT INTO kenNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Bǒnkwɔ Fárisi bárɛm yɛ ntá yi bɛ, “Wɔ mbɔŋ ɔ́rɛ̀m ɛ̌ti mmʉɛt yɛ. Ɛnyɨŋ ɛnɛ́ ɔ́rɛ̀m puyɛ̌ ndak.” ");
INSERT INTO kenNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu akɛmɛ bhɔ bɛ, “Yɛ̌ ɛ́mbak bɛ nchí rɛm chi ɛ̌ti mmʉɛ́t ɛya, ɛnyɨŋ ɛnɛ́ mɛ́rɛ̀m chí mbɔŋ ndak, mbɔnyunɛ ndɨ́ŋɨ́ ɛbhak ɛnɛ́ mfú nɛ ɛbhak ɛnɛ́ mɛ́rɔ̀ŋ. Kɛ bǎbhɨ́kɨ́ rɨŋɨ ɛbhak ɛnɛ́ mfú nɛ ɛbhak anɛ mɛ̌rɔ̀ŋ. ");
INSERT INTO kenNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Bǎyɨ̀ŋɨ bho chí nɛ amɨ́k kɛ mǎmkpɔt manyé yap. Mɛmbɔŋ mpú kpɔ́t manyé mmu. ");
INSERT INTO kenNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Yɛ̌ ɛ́mbak chí bɛ́ mɛ́tàŋ bhó, ɛnyu ɛnɛ́ mɛ́tàŋ ɛ́chí ɛrɨ́rɨ́ mbɔnyunɛ puyɛ̌ mɛ awántí kɛ nchí taŋ bo. Mɛ nɛ mmu anɛ átó mɛ kɛ sɛ́rɛ̀m ɛnyǔ mmu áchí. ");
INSERT INTO kenNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Básɨŋ ndǔ ɛkáti bɛbhé ɛyɛka bɛ, batísiɛ bati apay mándɛm ɛnyɨŋ ɛ́mɔt, nɔ́ chí ɛnyɨŋ ɛnɛ bɔ́ bárɛ́mɛ́ ɛ́chí tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mɛmbɔŋ nchí te ntísiɛ bɛ́ ɛnyɨŋ ɛnɛ mɛ́rɛ̀m chí mbɔ̌ŋ ndak, nɛ Ɛtaya mmu átó mɛ ǎtè mɛ ntísiɛ nkwɔ́ bɛ ɛnyɨŋ ɛnɛ mɛ̌rɛ̀m ɛchi tɛtɛp.” ");
INSERT INTO kenNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Bábhɛ́p yɛ yi bɛ, “Ɛtayɛ achí fá?” Yesu akɛmɛ bhɔ bɛ, “Bǎbhɨ́kɨ́ rɨŋɨ mɛ, nɛ yɛ̌ Ɛtaya, bǎbhɨ́kɨ́ rɨŋɨ. Mbɔ bǎrɨ́ŋɨ́ mɛ, mbʉ bǎrɨŋɨ Ɛtaya nkwɔ.” ");
INSERT INTO kenNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Mpok Yesu átɔ̀ŋ bho amɛm ɛkɛrákap Mandɛm kɛ yi árɛ́mɛ́ bɛyɔŋ ɛbhɛn. Achí nyaka kɛ́kwɔ́t nɛ bɛkʉbhɛ akap. Yɛ̌ mmu kɛtɔk yí mbɔnyunɛ mpok yi abhɨ́kɨ́ re kway nyaka. ");
INSERT INTO kenNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu apɛt aghati bhɔ bɛ, “Nchí rɔ bhe, bɛ́rɔŋ. Nnáŋ ndɔ́k, chɔŋ mǎnjaŋ mɛ. Kɛ bǎgu chɔŋ ndǔ bɛbʉ́ ɛbhɛka. Bǎpú kwáy bɛ́twɔ ɛbhak ɛnɛ mɛ́rɔ̀ŋ.” ");
INSERT INTO kenNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Bo Israɛl bábhó yɛ bɛrɛm bɛ, “Yí bɛ ‘Nɛbhʉɛt anɛ mɛ̌rɔ̀ŋ, bǎpú kwáy bɛ́twɔ arɛ,’ ǎyaŋ bɛway mmʉɛt kɛ?” ");
INSERT INTO kenNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu aghati bhɔ bɛ, “Bǎchí bǒ mmɨk. Mfu chi amfay. Bǎchí bǒ mmɨk nɛ, mpú mmǔ mmɨk nɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ɛ̌ti yɔ kɛ ngáti be bɛ́ chɔŋ mǎngú ndǔ bɛbʉ́ ɛbhɛka. Chɔŋ mǎngú ndǔ bɛbʉ́ ɛbhɛka mbák bǎbhɨkɨ noko bɛ́ nchí mmu anɛ nchí.” ");
INSERT INTO kenNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Bábhɛ́p yi bɛ, “Wɔ ɔchí agha?” Yesu ákɛmɛ bhɔ bɛ, “Nchí mmu anɛ ngáti bhe tɛ nɛbhǒnɛt bɛ nchi. ");
INSERT INTO kenNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mbɔ̌ŋ bɛyǎ bɛbɛ́ptí mɛnyɨŋ ɛbhɛn mɛ̌kwáy bɛrɛm ɛ̌ti yɛka nɛ nsɔt bɛtaŋ be. Kɛ mpú kʉ nɔ, mbɔnyunɛ mmu anɛ átó mɛ ǎbhʉɛrɛ bariɛp ami, nɛ ndiɛrɛ mɛnyɨŋ ɛbhɛn yi ághàti mɛ kɛ nchí ghati bǒ mmɨk.” ");
INSERT INTO kenNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ɛnɛ Yesu árɛ̀m nɔ, bɔ́ kɛjwimɛm bɛ́ yi árɛ̀m chí ɛ̌ti Ɛta. ");
INSERT INTO kenNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ɛ́kʉ́ Yesu aghati yɛ bhɔ bɛ, “Mǎnáŋ mǎnjoŋ Mɛ Mmu mfú ntá Mandɛm amfay, chɔŋ mǎndɨŋɨ bɛ́ nchí mmu anɛ nchí, nɛ bɛ́ mpú kʉ yɛ̌nyɨŋ ndǔ bɛtaŋ ɛbha. Nchí rɛm chí ɛnyɨŋ ɛnɛ Ɛta ágháti mɛ ndɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nɛ yí mmú átó mɛ, achi nɛ mɛ. Abhɨ́kɨ́ rɔ mɛ mbak awanti mbɔnyunɛ mɛ́kʉ̀ chi mɛnyɨŋ ɛbhɛn yi ákɔ́ŋɔ́.” ");
INSERT INTO kenNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Bɛyǎ bó abhɛn bághókó bɛyɔŋ ɛbhɛn, mánóko yi. ");
INSERT INTO kenNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu arɛm yɛ ntá bo Israɛl abhɛn mánóko yi bɛ, “Bǎchí bakoŋo bha tɛtɛp mbák mǎndɔ́k ambɨ bɛkoŋo bɛyɔŋ ɛbha, ");
INSERT INTO kenNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","nɛ chɔŋ mǎndɨŋɨ tɛtɛp anɛ Mandɛm, nɛ tɛtɛp wu amfɛrɛ be ndǔ kɛsɛm.” ");
INSERT INTO kenNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bákɛ́mɛ yi bɛ, “Sɛ́chí bɛbhárɛ́bhɔ Ábraham, nɛ yɛ̌ mpok apú anɛ sɛ́chí basɛm ntá mmu. Ndaká yí ɔ́rɛ̀m bɛ chɔŋ sɛ́mfú ndǔ kɛsɛm?” ");
INSERT INTO kenNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu akɛmɛ bhɔ bɛ, “Tɛtɛ̌tɛp, yɛ̌ntɨkɨ mmu anɛ ákʉ̀ bɛbʉ́, achí nsɛmɛ́-bɛbʉ. ");
INSERT INTO kenNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nsɛm apú bhak ndǔ nnɛrɛ́kɛt mpoknkɛm. Mmɔ̌ nnɛrɛ́kɛt kɛ ábhák arɛ mpoknkɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Mbák yɛ mbɔ̌ŋ mmɔ́ amfɛrɛ be ndǔ kɛsɛm, chɔŋ mǎmbak ngǎngaŋ tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ndɨ́ŋɨ́ bɛ́ bǎchí bɛbhárɛ́bhɔ Ábraham. Yɛ̌ nɔ́, bǎyaŋ mbi bɛway mɛ mbɔnyunɛ ɛyɔŋ ɛya ɛ́pú chwe amɛm batɨ yɛka. ");
INSERT INTO kenNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nchí ghati bhe chí mɛnyɨŋ ɛbhɛn ngɔ́ ntá Ɛtaya, kɛ bǎkʉ̀ chí mɛnyɨŋ ɛbhɛn ɛtayɛka ágháti bhe.” ");
INSERT INTO kenNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Bágháti Yesu bɛ, “Ɛtayɛsɛ chi Ábraham.” Yesu arɛm bɛ, “Mbɔ bǎchí bɔ̌ Ábraham tɛtɛp, mbʉ́ bǎkʉ̀ mɛnyɨŋ mbɔ Ábraham ákʉ̀ nyaka. ");
INSERT INTO kenNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kɛ bǎyàŋ mbi bɛway mɛ, mɛ mmu ngátí bhe tɛtɛp anɛ ngókó ntá Mandɛm. Ábraham apú kʉ nyaka nɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Bǎkʉ̀ mɛnyɨŋ mbɔ ɛtayɛka.” Bágháti yi bɛ, “Mandɛm kɛ achi ɛtayɛsɛ, sɛ́pú bɔ̌-ɛnɔŋ.” ");
INSERT INTO kenNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu aghati bhɔ bɛ, “Mbɔ Mandɛm achi ɛtayɛka, mbʉ bǎkɔ̀ŋ mɛ, mbɔnyunɛ mfú chí ntá Mandɛm. Mbɨ́kɨ́ twɔ́ chí ndǔ mmʉɛt ya, yi kɛ átó mɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ndaká yí bǎpú jwimɛm ndǔ mɛnyɨŋ ɛbhɛn mɛ́rɛ̀m? Chi mbɔnyunɛ bǎbhɨ́kɨ́ bhɔŋ ntɨ bɛghok bɛyɔŋ ɛbha. ");
INSERT INTO kenNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Bě bǎchi bɔ̌ ɛtayɛka Satan, nɛ bǎkɔŋ bɛkʉ chi mɛnyɨŋ ɛbhɛn ɛtayɛka áyàŋ mǎnkʉ. Achí ngwayti bho tɛ nɛbhǒnɛt. Abhɨ́kɨ́ kɔŋ tɛtɛp Mandɛm mbɔnyunɛ tɛtɛp apu nɛ yi. Mpok yi ásè nsé, ǎkʉ̀ chí ɛnyɨŋ ɛnɛ ɛ́kɔ́ ndɔ́ŋ ámɔt nɛ ɛpɨŋ ɛyi, mbɔnyunɛ achi nsěnse, nɛ nsé ɛnkɛm ɛ́fù chí ntá yi. ");
INSERT INTO kenNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kɛ tɛ̌ndu mɛ̌ghàti bhe chí tɛtɛp Mandɛm, bǎpú noko ɛnyɨŋ ɛnɛ mɛ̌rɛ̀m. ");
INSERT INTO kenNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ntɨkɨ mmǔ ákwày bɛtɔŋ bɛ nkʉ bɛbʉ́? Mɛ̌rɛ̀m chi tɛtɛp, ndaká yí bǎpú noko mɛ? ");
INSERT INTO kenNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Mmu anɛ Mandɛm áchí ɛtayi, ǎkɔŋ bɛghok ɛyɔŋ ɛyi. Ntí anɛ bǎbhɨ́kɨ́ kɔŋ bɛghok Ɛyɔŋ Mandɛm achí bɛ bǎpú bɔ̌bhi.” ");
INSERT INTO kenNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Bǒbati bo Israɛl bákɛ́mɛ yi bɛ, “Sɛ́bhɨ́kɨ́ kʉ nɛfwɔp bɛrɛm bɛ ɔchí mmu Samária nɛ bɛ́ ɛfóŋó ɛbʉ́bʉ ɛ́sɔ̀ŋɔri wɔ?” ");
INSERT INTO kenNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu akɛmɛ bɛ, “Mbɨ́kɨ́ bhɔŋ ɛfóŋó ɛbʉ́bʉ. Mɛ̌chyɛ̀ Ɛtaya kɛnókó, kɛ bǎchɔŋti nnyɛ́n ɛna. ");
INSERT INTO kenNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mbɨ́kɨ́ bhʉɛrɛ ntɨ bɛ́ bo mánchyɛ́ mɛ kɛnókó. Kɛ mmǔ achí anɛ áyàŋ bɛ́ bo mánchyɛ́ mɛ kɛnókó, nɛ yí kɛ ákway bɛrɛm ɛnyǔ mɛnyɨŋ bɛ́bhɔ́ŋɔ́ bɛ́bhak. ");
INSERT INTO kenNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tɛtɛ̌tɛp, mmu anɛ ábhʉ̀rɛ ɛyɔŋ ɛya, apú gú wáwák.” ");
INSERT INTO kenNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Bo Israɛl bhɔ bárɛm bɛ, “Bɛ́kóŋo bɛyɔŋ ɛbhɛ, sɛ́ghɔ nɛ́nɛ bɛ ɔbhɔŋ ɛfóŋó ɛbʉ́bʉ. Ábraham agǔ nyaka, barɛmɛ́ kɛpɨ̌ntɨ Mandɛm mankɛm bágú nkwɔ, kɛ wɔ, ɔ̌rɛ̀m bɛ, ‘Mbák mmu ámbʉ́rɛ́ bɛyɔŋ ɛbha apú gú wáwák.’ ");
INSERT INTO kenNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Wɔ, ɔchá ɛtayɛsɛ Ábraham mmu ágú nyaka? Barɛmɛ́ kɛpɨ̌ntɨ Mandɛm nkwɔ bágú nyaka! Ɔ̌sɔ̀t mmʉɛt yɛ mbɔ agha?” ");
INSERT INTO kenNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu akɛmɛ bhɔ bɛ, “Mbák mɛ̌chyɛ̀ mmʉɛ́t ɛya kɛnókó, nɔ́ kɛnókó ɛka kɛ́pú yɛ̌nyɨŋ. Ɛtaya kɛ áchyɛ̀ mɛ kɛnókó, nɛ nkúbhɛ́ yi kɛ bǎrɛ̀m bɛ achi Mandɛm aywɛka. ");
INSERT INTO kenNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Kɛ yɛ̌ndu bǎrɛ̀m bɛ yi achi Mandɛm aywɛka, bǎbhɨ́kɨ́ rɨŋɨ yi, mɛ kɛ ndɨ́ŋɨ́ yi. Mbɔ ndɛm bɛ́ mbɨ́kɨ́ rɨŋɨ yi, mbʉ nchí se chi nse mbɔ běka. Ndɨ́ŋɨ́ yi nɛ nchí bhʉɛrɛ ɛyɔŋ ɛyi. ");
INSERT INTO kenNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Chi-mbɨ ywɛka Ábraham, ǎnòŋ nyaka nɛ maŋák bɛ́ghɔ nywɔp nɛtwɔ ɛna. Aghɔ́ nɔ́, ntɨ nɛ́rɨ yi amɛm.” ");
INSERT INTO kenNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Bǒbati bo Israɛl bhɔ bárɛm yɛ ntá yi bɛ, “Ɔbhɨ́kɨ́ re ghaka yɛ̌ mamiɛ́ bɛsa bɛpay nsɛm byo, ɔbhɛ́ ɔnáŋ ɔghɔ Abraham-ɛ?” ");
INSERT INTO kenNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu aghati bhɔ bɛ, “Tɛtɛ̌tɛp, Ábraham ápɛ́rɛ bhák, Mɛ Nchí.” ");
INSERT INTO kenNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ɛ́kʉ bábho bɛbwɔpti batay bɛtɛmti yi nɛ yɔ́ mángwáy, kɛ Yesu abhɛsɛ, tɛ áfú amɛm ɛkɛrákap Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ɛnɛ́ Yesu áfʉɛ̀t árɔ̀ŋ, aghɔ́ mmú anɛ achi nnɛ́mámɨk tɛ ndǔ nɛbhe ɛni. ");
INSERT INTO kenNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Bakoŋo bhi bábhɛ́p yi bɛ, “Ntɔŋ, bɛbʉ́ agha bɛkʉ amɨ́k mmǔ nɛ ánɛ́mɛ́? Ɛbhi yímbɔŋ, kɛ ɛbhɛn chi nɛ nnɔ?” ");
INSERT INTO kenNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu akɛmɛ bhɔ bɛ, “Puyɛ̌ chi bɛ́ mmǔ-nɛ akʉ bɛbʉ́, nɛ puyɛ̌ chí bɛ ɛtayi nɛ máyi bakʉ bɛbʉ́. Amɨ́k ánɛmɛ yi chi bɛ ɛyɔ ɛ́nkwak bo mángɔ ɛnyǔ ɛnyɨŋɨ́ maknkay ɛnɛ Mandɛm aywǐnti ákway bɛkʉ. ");
INSERT INTO kenNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Sɛ́bhɔŋ bɛkʉ bɛtɨk ɛbhɛn mmu anɛ átó mɛ ndǔ mpok anɛ bɛti bɛ́bhɨ́kɨ́ re twɔ. Bɛti bɛ́twɔ̀, nɛ mɛ́náŋ mɛ́ntwɔ́, yɛ̌ mmu apú pɛrɛ kway bɛkʉ bɛtɨk. ");
INSERT INTO kenNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mpoknkɛm anɛ nchí fá amɨk, nchí ɛrɔ́ŋɔ́ ntá bǒ mmɨk.” ");
INSERT INTO kenNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Árɛ́mɛ́ nɔ́kɔ́ nɔ, apá batiɛ́ amɨk, anywɔbhɛri ntɔp nɛ sɛnɔŋ awɔ ndǔ nɛbhʉɛt anɛ yi apá batiɛ́, asɔt ntɔp wu achɔri yi amɨ́k ");
INSERT INTO kenNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","aghati yi bɛ, “Dɔ́k ndǔ ɛ̌ntɨ́ŋnyɛ́n Sílom, sǒ bɛsí arɛ́.” Sílom chi “Bátó”. Mmu wu arɔk, aso bɛsí arɛ nɛ mpok ápɛ̀tnsɛm are ghɔ́ mbaŋ. ");
INSERT INTO kenNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Bakokosi bhi nɛ bǒ mankɛm abhɛn bárɨ́ŋɨ́ nyaka yi mbɔ nnɨŋɨ́ mɛnɨ́ŋɨ́, bábho bɛrɛm bɛ, “Pú mmú nyaka áchɔ̀kɔ anɨŋɨ nɔkɔ mɛnɨ́ŋɨ́ nɛ?” ");
INSERT INTO kenNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Mbɔk bho bárɛ́ rɛm bɛ, “Chí yi.” Báchák bɛ, “Ǎe, kɛ achí mbɔ yi,” kɛ yímbɔŋ arɛm bɛ, “Chí mɛ.” ");
INSERT INTO kenNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Bábhɛ́p yi bɛ, “Ɛ́fákárí ná kɛ ɔbho bɛghɔ mbaŋ?” ");
INSERT INTO kenNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Akɛmɛ bhɔ bɛ, “Mmu anɛ áká nnyɛ́n bɛ Yesu kɛ ányɔ́bhɛ́rí ntɔp, asɔt, achɔri mɛ amɨ́k, arɛm bɛ ndɔ́k ndǔ ɛ̌ntɨ́ŋnyɛ́n Sílom nsó bɛsí arɛ. Ndɔk arɛ́ nso bɛsɨ́, mbo bɛghɔ mbaŋ.” ");
INSERT INTO kenNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bábhɛ́p yi bɛ, “Mmǔ-rɛ́ achí fá?” Akɛmɛ bhɔ bɛ, “Mbɨ́kɨ́ rɨŋɨ.” ");
INSERT INTO kenNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Básɔt nnɛ́mámɨk anɛ Yesu ákʉ́ yi ághɔ̀ mbaŋ bárɔ́k ntá bǒnkwɔ Fárisi. ");
INSERT INTO kenNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ndǔ nywɔbhɛ́ nɛywɛ̌mʉɛt bo Israɛl kɛ Yesu ányɔ́bhɛ́rí nyaka ntɔp awati yi amɨ́k, amɨ́k anɛnɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Bǒnkwɔ Fárisi bápɛt bábhɛp yi ɛnyu ɛ́fákari kɛ yi ághɔ̀ mbaŋ. Aghati bhɔ bɛ, “Awátí ntɔp mɛ amɨ́k, nsó nɔ́kɔ́ bɛsí, mbo bɛghɔ mbaŋ.” ");
INSERT INTO kenNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mbɔk bǒnkwɔ Fárisi bhɔ bárɛm bɛ, “Mmǔ anɛ akʉ ɛnyɨŋ ɛnɛ abhɨ́kɨ́ fú chi ntá Mandɛm mbɔnyunɛ apú noko nywɔbhɛ́ nɛywěmʉɛt ɛnɛsɛ.” Kɛ bachak báré rɛm bɛ, “Ná mmu bɛbʉ́ ákway bɛkʉ mɛnyǔ mɛnyɨŋɨ́ maknkay ɛbhɛn?” Akɔrɛ akwɛn nɛntɨ ɛnap. ");
INSERT INTO kenNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Bǒnkwɔ Fárisi bápɛt bábhɛ́p nnɛ́mámɨk anɛ Yesu ákʉ yi ághɔ̀ mbaŋ bɛ, “Wɔ bɛ́ mmu wu kɛ ákʉ́ ɔ́ghɔ̀ mbaŋ, ɔkáysí bɛ yi achi agha?” Akɛmɛ bhɔ bɛ, “Chí ndɛmɛkɛpɨ̌ntɨ Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Bǒbati bo Israɛl kɛnókó bɛ amɨ́k anaŋ anɛmɛ nyaka yi kɛ apɛt abho bɛghɔ mbaŋ, kpatɛ mpok bábhɨ́ŋɨ́ máyi nɛ ɛtayi, ");
INSERT INTO kenNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","bábhɛ́p bhɔ bɛ, “Mmɔ̌ ywɛka nɛ, bárɛ̀m bɛ́ amɨ́k anɛmɛ yi tɛ̌ndu nɛbhe ɛni? Ɛ́fakari ná kɛ yi ághɔ̀ mbaŋ nɛ́nɛ?” ");
INSERT INTO kenNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nnɔ nɛ chi bákɛmɛ bɛ, “Sɛ́rɨ́ŋɨ́ bɛ́ nɛ chi mmɔ́ ywɛsɛ, nɛ bɛ́ amɨ́k anɛmɛ yi tɛ̌ndu nɛbhe ɛni. ");
INSERT INTO kenNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kɛ sɛ́bhɨ́kɨ́ rɨŋɨ ɛnyu ɛ́fákárí kɛ yi ághɔ̀ mbaŋ nɛ́nɛ. Nɛ sɛ́bhɨ́kɨ́ rɨŋɨ mmǔ anɛ anɛnɛ yi amɨ́k. Bɛ́p ká yi. Apú chí mandú mmɔ́. Chɔŋ yímbɔŋ angati bhe.” ");
INSERT INTO kenNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Chi nɛ nnɔ bákɛ́mɛ ɛnyu ɛyɔ mbɔnyunɛ báchày nyaka bǒbati bo Israɛl nɛ ntí bɛ báká nyaka ɛyɔŋ ɛ́mɔt bɛ mbák mmu ándɛm bɛ Yesu chi Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò, bábòk yi ndǔ ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí ɛyap. ");
INSERT INTO kenNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ɛkʉ yɛ chi nɛ nnɔ bárɛm chi bɛ, “Ápú mandú mmɔ́. Bɛ́p ká yímbɔŋ angati bhe.” ");
INSERT INTO kenNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ndɔŋ ɛnɛ́ ɛ́jwí ɛpay, bábhɨ́ŋɨ nnɛ́mámɨk anɛ Yesu ákʉ yi ághɔ̀ mbaŋ, baghati yi bɛ, “Dɛm tɛtɛp aywɛ bɛsí Mandɛm. Sɛ́rɨ́ŋɨ́ bɛ mmǔ anɛ ɔ́rɛ̀m nɔ bɛ anɛ́nɛ́ wɔ amɨ́k chi mmǔ bɛbʉ́.” ");
INSERT INTO kenNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Akɛmɛ bhɔ bɛ, “Kɛ chí mmǔ bɛbʉ́ kɛ puyɛ̌ mmǔ bɛbʉ̌-a, mbɨ́kɨ́ rɨŋɨ. Ɛnɛ́ ndɨ́ŋɨ́ chi bɛ nchí nyaka nnɛ́mámɨk, kɛ nɛ́nɛ nchí ghɔ mbaŋ.” ");
INSERT INTO kenNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Bábhɛp yi bɛ, “Akʉ́ yi ntá yɛ? Ná yi ákʉ́ kɛ ɔ̌ghɔ mbaŋ?” ");
INSERT INTO kenNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Akɛmɛ bhɔ bɛ, “Nnáŋ ngáti bhe, kɛ bǎbhɨ́kɨ́ noko, ndaká yí bǎpɛt bǎbhɛ̀p mɛ? Bě nkwɔ́ báyàŋ bɛbhak bakoŋo bhi?” ");
INSERT INTO kenNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Bábhó bɛsɔkɔti yi mándɛmɛ nɔkɔ bɛ, “Wɔ kɛ ɔ́chí nkoŋo ywi, bɛsɛ sɛ́chí chí bakoŋo Moses. ");
INSERT INTO kenNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Sɛ́rɨ́ŋɨ́ bɛ́ Mandɛm arɛm nyaka kɛpɨ nɛ Moses, kɛ mmǔ-nɛ, sɛ́bhɨ́kɨ́ rɨŋɨ ɛbhak ɛnɛ yi áfú.” ");
INSERT INTO kenNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Akɛmɛ bhɔ bɛ, “Ɛchí mɛ nɛpɔp tontó bɛ bǎbhɨ́kɨ́ rɨŋɨ ɛbhak ɛnɛ yi áfú, yɛ̌ndu yi ánɛ́nɛ́ mɛ amɨ́k! ");
INSERT INTO kenNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Sɛ́rɨŋɨ bɛ Mandɛm apu ghok bǒ bɛbʉ́. Ǎghok chi mmu anɛ áchyɛ̀ yi kɛnókó, ankʉ nɔkɔ mɛnyɨŋ ɛbhɛn yi Mandɛm áyàŋ. ");
INSERT INTO kenNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tɛ̌ mmɨk ábhó, sɛ́bhɨ́kɨ́ re ghók bɛ mmu akʉ amɨ́k ánɛ́nɛ́ mmu anɛ bábhé yi amɨ́k nɛ́mɛ́nɛ́mɛ́. ");
INSERT INTO kenNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Mbɔ mmǔ nɛ abhɨ́kɨ́ fú chi ntá Mandɛm, mbʉ abhɨkɨ kway bɛ́kʉ ɛnɛ ɛnyɨŋ.” ");
INSERT INTO kenNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Bákɛ́mɛ yi bɛ, “Kwáé, wɔ mmu bábhé ndǔ bɛbʉ́, ɔ́yàŋ bɛtɔŋ bhɛsɛ?” Bapuri yí bátɛ́n nɛfí bɛ ámfú ɛkɛt nɛnɨkímʉɛt ɛyap. ");
INSERT INTO kenNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu aghók bɛ́ bábók mmu anɛ yi ákʉ́ amɨ́k ánɛ́nɛ́ batɛn nɛfí. Abho bɛyaŋ yi. Ághɔ́ nɔkɔ yi, abhɛ́p yi bɛ, “Ɔnókó Mmu anɛ áfú ntá Mandɛm?” ");
INSERT INTO kenNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Yi akɛmɛ Yesu bɛ, “Ɛta, mmu wu chi agha? Ghatí mɛ, bɛ nnókó yi.” ");
INSERT INTO kenNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu aghati yi bɛ, “Ɔnáŋ ɔghɔ̌ yi, nɛ yí kɛ árɛ̀m kɛpɨ nɛ wɔ nɛ́nɛ.” ");
INSERT INTO kenNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Mmǔ wu arɛm bɛ, “Acha, nnókó.” Akwɛ́n Yesu bɛkak, abho bɛ́chyɛ yi kɛnókó. ");
INSERT INTO kenNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu arɛm bɛ, “Ntwɔ fá amɨk bɛ mámkpɔ́t manyé bho. Ntwɔ bɛ́ bo abhɛn bachi amɨ́k nɛ́mɛ́nɛ́mɛ́ mangɔ mbaŋ, nɛ bɛ́ amɨ́k ánɛ́mɛ́ abhɛn bághɔ̀ mbaŋ.” ");
INSERT INTO kenNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mbɔk bǒnkwɔ Fárisi abhɛn bachi nyaka kɛkwɔt bághókó nɔ́kɔ́ ɛnyɨŋ ɛnɛ yi árɛ́mɛ́, bábhɛ́p yi bɛ, “Ɔ̌rɛ̀m nɔ chi bɛ bɛsɛ nkwɔ sɛ́chí amɨ́k nɛ́mɛ́nɛ́mɛ́ kɛ?” ");
INSERT INTO kenNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu akɛmɛ bhɔ bɛ, “Mbɔ bǎchí amɨ́k nɛ́mɛ́nɛ́mɛ́ mbʉ́ bɛbʉ́ bɛ́pú nɛ bhe. Kɛ tɛ̌ndu bǎrɛ̀m bɛ bǎghɔ̀ mbaŋ, bɛbʉ́ ɛbhɛka bɛrɔp nɛ bhe.” ");
INSERT INTO kenNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu arɛm bɛ, “Tɛtɛ̌tɛp, mmǔ anɛ ápú fʉɛ́t ndǔ nnyǔbha ánchwe ndǔ nkwɔ bághɔ́ŋɔmɛ́n, kɛ ǎko chí ɛbhak ɛ́chák anchwe amɛm, chí ngɛ́p. Mbák ɛ́pú nɔ, chí ngɛ́bhɛ́ ntantaŋ. ");
INSERT INTO kenNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kɛ anɛ áfʉɛ̀t ndǔ nyǔbhá, chí mbabhɛri bághɔ́ŋɔmɛ́n. ");
INSERT INTO kenNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mbabhɛri nnyǔbha, ǎnɛ̀nɛ nyǔbhá ntá yi. Bághɔ́ŋɔ́mɛn árɨŋɨ ɛyɔŋ ɛyi. Ǎbhɨŋɨ yɔ́ ndǔ manyɛ́n ayap, ansɔt yɔ́ amfu nɛ yɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nɛ ánáŋ ántɛ́n yɔ́ ankɛm nɛfí, ǎrɔ́ŋ ambɨ, yɔ́ ánkoŋo nɔkɔ ansɛm, mbɔnyunɛ árɨ́ŋɨ́ ɛyɔŋ ɛyi. ");
INSERT INTO kenNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ápú koŋo kɛnkɔ̌ mmu. Ǎbʉɛ̀ yi bʉɛ, mbɔnyunɛ ábhɨ́kɨ́ rɨŋɨ ɛyɔŋ ɛyi.” ");
INSERT INTO kenNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu atɛ́m bo Israɛl nɛkay ɛnɛn, kɛ bɔ́ kɛjwimɛm ndǔ ntí nɛkay. ");
INSERT INTO kenNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ɛkʉ, Yesu apɛt aghati bhɔ bɛ, “Tɛtɛ̌tɛp, mɛ kɛ nchí nyǔbhá bághɔ́ŋɔmɛ́n. ");
INSERT INTO kenNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bǒ mankɛm abhɛn bayambɨ bátwɔ́ kɛ mɛ̌twɔ̀, chí baghɛ́p nɛ baghɛ́p bataŋ bataŋ. Baghɔŋɔmɛn ábhɨ́kɨ́ ghók bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mɛ kɛ nchí mbǐnywɔp. Mmu anɛ áfʉɛ̀t ntá ya kɛ anchwe, ɛnyɨŋ ɛ́pú tɔk yi. Ǎchwè, amfú mbɔ ɛnyǔ yi ákɔ́ŋɔ́, ambɔ́ŋ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ yi áyàŋ. ");
INSERT INTO kenNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ngɛ́p ǎtwɔ̀ chí bɛ́ghɛp aghɛ́p, bɛ́wáy, nɛ bɛ́chɔ́ŋti. Ntwɔ bɛ́ bo mámbɔ́ŋ nɛpɛ́m nɛ bɛ́ mámbɔ́ŋ nɔ nɛ́njwí pɔɔt nɛ áfɔ́k ankɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Mɛ kɛ nchí ɛrɨ́tí mbabhɛri bághɔ́ŋɔmɛ́n. Ɛrɨ́tí mbabhɛri bághɔ́ŋɔmɛ́n ǎchyɛ̀ nɛpɛ́m ɛni ɛ̌ti bághɔ́ŋɔmɛ́n ayi. ");
INSERT INTO kenNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mmǔ anɛ básɔ́rɛ́ ndǔ bɛtɨk bɛ ámbábhɛ́rí nɔ́kɔ́ bághɔ́ŋɔmɛ́n ɛnɛ́ yi ápú mbabhɛri bághɔ́ŋɔmɛ́n nɛ yɔ apu ayi, ǎghɔ nkwɔ ndu átwɔ̀ andɔ bághɔ́ŋɔmɛ́n ambʉɛ́, nkwɔ ankɛ́m mbɔk, nɛ antak achak. ");
INSERT INTO kenNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ǎbʉɛ́ mbɔnyunɛ achí chí mǔbɛtɨk, nɛ ápú fyɛ́ ntí nɛ bághɔ́ŋɔmɛ́n. ");
INSERT INTO kenNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Mmɛ kɛ nchí ɛrɨ́tɨ́ Mbabhɛri bághɔ́ŋɔmɛ́n. Ndɨ́ŋɨ́ bághɔ́ŋɔmɛ́n aya, nɛ bághɔ́ŋɔmɛ́n aya árɨŋɨ mɛ, ");
INSERT INTO kenNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","nkúbhɛ́ mbɔ ɛnyǔ Ɛtaya árɨ́ŋɨ́ mɛ, mɛ ndɨ́ŋɨ́ Ɛtaya. Nɛ nchí chyɛ nɛpɛ́m ɛnɛ ɛ̌ti bághɔ́ŋɔmɛ́n. ");
INSERT INTO kenNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mbɔ̌ŋ bághɔ́ŋɔmɛ́n áchák anɛ́ ápú ndǔ nkwɔ bághɔ́ŋɔmɛ́n anɛ. Mbɔŋ bɛ́sɔt yɔ́ nkwɔ, ntwɔ́ nɛ yɔ, bɛ́ ánchɛ́m mmʉɛt nɛ anɛ́fú. Chɔŋ ánkoŋo ɛyɔŋ ɛya. Ɛnkʉ yɔ́ ankɛm ámbak ndǔ nkwɔ́ ámɔt anɛ́ ábhɔ́ŋɔ́ mbabhɛri bághɔ́ŋɔmɛ́n amɔt. ");
INSERT INTO kenNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ɛtaya akɔŋ mɛ mbɔnyunɛ nchí chyɛ nɛpɛ́m ɛna bɛ mpɛt mbɔŋ nɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Yɛ̌ mmu apú anɛ ásɔ̀t nɛpɛ́m ɛna ntá ya. Mɛmbɔ̌ŋ kɛ nchí chyɛ nɛpɛ́m ɛna. Mbɔ̌ŋ bɛtaŋ bɛ́chyɛ nɔ, nɛ mbɔ̌ŋ bɛtaŋ bɛ́pɛ́t bɛbhɔŋ nɔ. Ɛnɛ, chí ɛnyɨŋ ɛnɛ́ Ɛtaya ághátí mɛ nkʉ.” ");
INSERT INTO kenNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Bɛyɔŋ ɛbhɛn bɛ́kʉ ákɔrɛ ápɛt ákwɛ́n nɛntɨ bo Israɛl. ");
INSERT INTO kenNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bɛyǎ bhap báré rɛm bɛ, “Ɛfóŋó ɛbʉ́bʉ ɛ́sɔ̀ŋɔri yi! Ǎbhokori! Ndaká yí bǎté, bǎghòk ɛnyɨŋ yi árɛ̀m?” ");
INSERT INTO kenNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Kɛ báchák báré rɛm chi bɛ, “Puyɛ̌ mɛnyɨŋ ɛbhɛn mmu anɛ ɛfóŋó ɛbʉ́bʉ ɛ́sɔ̀ŋɔri yi akwáy bɛrɛm nɛ. Ɛfóŋó ɛbʉ́bʉ ɛ́kwày bɛ́kʉ nnɛ́mámɨ́k ángɔ́ mbaŋ-á?” ");
INSERT INTO kenNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Mpok aghaka anɛ bo Israɛl mányìɛ ɛpa ɛnɛ bátɨ̀k ndu mánɨ́kɨ́mʉɛt báfyɛ́ ɛkɛrákap ɛnɛ Yerúsalɛm awɔ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Mbaŋ are kwɛn, Yesu arɔk ɛkɛrákap Mandɛm, are kɔ ndu mɔ́kɛt mambarɛnkók anɛ bábhɨ̀ŋɨ bɛ́ mɔ́kɛt mambarɛnkók Sólomon. ");
INSERT INTO kenNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Bo Israɛl bárɔ́k, bákáp yi, bábhó bɛbhɛp yi bɛ, “Chɔŋ ɔ́ndɔ sɛ́noŋ ɛntat ná kɛ ɔ́ngati bhɛsɛ mbák wɔ kɛ ɔ́chí Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò. Mbák wɔ kɛ ɔchí Mpɛmɛ, ghatí bhɛsɛ́ kpoŋoroŋ.” ");
INSERT INTO kenNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu akɛmɛ bhɔ bɛ, “Nnáŋ ngáti bhe, kɛ bǎbhɨ́kɨ́ noko. Bɛtɨk ɛbhɛn mɛ̌kʉ̀ ndǔ nnyɛ́n Ɛtaya bɛ́tɔ̀ŋ be ɛnyǔ mmu nchí. ");
INSERT INTO kenNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Yɛ̌ nɔ, bǎpú noko mbɔnyunɛ bǎpú ndǔ nkwɔ́ bághɔ́ŋɔmɛ́n aya. ");
INSERT INTO kenNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Bághɔ́ŋɔ́mɛn aya ághòk ɛyɔŋ ɛya. Ndɨ́ŋɨ́ yɔ́, nɛ yɔ ákòŋo mɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nɛ nchí chyɛ yɔ́ nɛpɛ́m ɛnɛn nɛbhɨkɨ bhɔŋ ngwɛnti. Ápú gú ánɛ́m. Mmu apú anɛ ákwày bɛ́fɛrɛ yɔ́ amɔ́ya. ");
INSERT INTO kenNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ɛtaya mmu áchyɛ́ mɛ yɔ, achá bo mankɛm. Nɛ mmu apú kwáy bɛfɛrɛ yɔ ndu amɔ yi. ");
INSERT INTO kenNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Mɛ nɛ Ɛtaya sɛ́chí mmu amɔt.” ");
INSERT INTO kenNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yesu árɛ́mɛ́ nɔ́kɔ́ nɔ́, bo Israɛl bápɛt bábho bɛbwɔpti batay ndu bɛtɛmti yi nɛ yɔ́ mángwáy. ");
INSERT INTO kenNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu arɛm bɛ, “Ntɔ̌ŋ be bɛyǎ bɛrɨ́tí mɛnyɨŋ ɛbhɛn nkʉ́ ndǔ nnyɛ́n Ɛtaya. Ndu mɛnyɨŋ ɛbhɛn mɛnkɛm, ɛnɛ́ ɛ́kʉ́ bǎyaŋ bɛway mɛ nɛ batay chí ɛnɛ́?” ");
INSERT INTO kenNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Bo Israɛl bákɛ́mɛ yi bɛ, “Sɛ́pú yaŋ bɛ́wáy wɔ nɛ batay ɛ̌ti ɛrɨ́tí ɛnyɨŋ ɛnɛ ɔ́kʉ́, kɛ ɛ̌ti ɔ́rɛ̀m bɛ ɔchí Mandɛm yɛ̌ndu ɔ́chí nkwǎŋwaŋ.” ");
INSERT INTO kenNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu akɛmɛ bɔ́ bɛ, “Pú básɨŋ amɛm ɛkáti bɛbhé ɛyɛka bɛ Mandɛm arɛm bɛ, ‘Mɛ ndɛm bɛ́ bǎchí bɔmandɛm’? ");
INSERT INTO kenNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Sɛ́rɨ́ŋɨ́ bɛ́ ɛnyɨŋ Ɛkáti Mandɛm ɛ́rɛ̀m ɛ́pú kway bɛwupsi ɛnyu. Mbák Mandɛm abhɨŋɨ nyaka bo abhɛn bághòk ɛyɔŋ ɛyi bɛ bɔmandɛm, ");
INSERT INTO kenNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ná bǎkway bɛrɛm bɛ mɛ̌rɛ̀m bɛ nchí Mandɛm ndǔ ndɛ́mɛ́ bɛ nchí Mmɔ Mandɛm, mmu yi áyábhɛ́ átó fá amɨk? ");
INSERT INTO kenNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Mbák mpú kʉ chi bɛtɨk Ɛtaya, bǎkɛ́ noko mɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kɛ mbák mɛ̌kʉ̀ chí bɛtɨk Ɛtaya, yɛ̌ndu bǎbhɨ́kɨ́ noko mɛ, nokó ká ɛnyɨŋ ɛnɛ́ bɛtɨk ɛbhɛ́n mɛ́kʉ̀ bɛ́ghàti bhe. Chɔŋ ɛyɔ ɛ́nkwak mǎndɨŋɨ, nɛ mǎnjwimɛm bɛ́ Ɛtaya achi babhat nɛ mɛ, nɛ mɛ nchí babhat nɛ Ɛtaya.” ");
INSERT INTO kenNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Bápɛt babho bɛyaŋ mbi ndu bɛkɛm yi, afori bɔ́ amɔ arɔk ɛbhakayi. ");
INSERT INTO kenNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Apɛtnsɛm ɛbhě manyu Jɔ́dan, ndǔ nɛbhʉɛt anɛ Jɔ̌n ájwìti nyaka bho, abhak arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bɛyǎ bo bárɔ́k ntá yi mándɛmɛ nɔkɔ bɛ, “Jɔ̌n ábhɨ́kɨ́ kʉ yɛ̌nyɨŋɨ́ maknkay ɛ́mɔt, kɛ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ yi árɛ́mɛ́ ɛ̌ti mmǔ anɛ ɛ́chí tɛtɛp.” ");
INSERT INTO kenNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Bɛyǎ bo mánóko Yesu ɛbhak ɛyɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mmǔ amɔt achi nyaka ɛtɔk Bɛ́tani, anɛ áká nnyɛ́n bɛ Lásárɔs. Akwɛ́n nɛme. Bɛ́tani abhak ɛtɔk ɛnɛ María nɛ mɔ́mayi Matá báchɔ̀kɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","María wu, kɛ áwáti nyaka bɛkak Yesu Acha nɛ bawɛrɛ́riɛp, are tɛsɛ nɛ ɛmɛnɛ́ntí yi. Yi kɛ mɔ́mayi Lásárɔs akwɛnɛ nyaka nɛme. ");
INSERT INTO kenNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ɛ́kʉ́ bɔ̌mayi bátó ɛyɔŋ ntá Yesu Acha bɛ, “Acha, mmʉɛrɛ ywɛ anɛ ɔ́kɔ́ŋɔ́ ǎme.” ");
INSERT INTO kenNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu ághókó nɔ́kɔ́ ntó ɛnɛn arɛm bɛ, “Nɛme ɛnɛ́n nɛ́pú nɛmě nɛwú, nɛ́chí chí bɛ́kʉ bo mángɔ́ bɛtaŋ Mandɛm. Nɛ́twɔ chí bɛ nɛ́mbák ɛnyɨŋ ɛnɛ́ ɛ́kʉ̀ bo mángɔ́ bɛ Mmɔ Mandɛm abhɔŋ bɛtaŋ.” ");
INSERT INTO kenNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu akɔŋ nyaka Matá nɛ bɔ̌mayi María nɛ Lásárɔs tontó. ");
INSERT INTO kenNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Yɛ̌ nɔ, mpok yi ághókó bɛ́ Lásárɔs ǎme, achɔkɔ ɛbhak ɛnɛ yi achi ndǔ manywɔp apay. ");
INSERT INTO kenNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Manywɔp yɔ apay áfʉ́ɛ́rɛ́ nɔ́kɔ́, arɛm ntá bakoŋo bhi bɛ, “Sɛ́mpɛ́tnsɛm atú Judɛ́ya.” ");
INSERT INTO kenNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Bakoŋo bhi bárɛm bɛ, “Ntɔŋ, ɛ́bhɨ́kɨ́ re tat ɛnɛ bǒ batí Israɛl báyàŋ bɛ́tɛmti wɔ nɛ batay mángwáy, ɔbhɛ́ ɔ̌pɛtnsɛm arɛ́?” ");
INSERT INTO kenNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu akɛmɛ bhɔ bɛ, “Pú maŋɔkɔ́ nywɔp áchi byo nɛ apay bɛ́bho beti bɛ́gháka beku? Mmu anɛ ákɔ̀ nɛ ngósí, apú chɨŋti nɛkwɛn mbɔnyunɛ ǎghɔ̀ ɛrɔ́ŋɔ́ mmɨk. ");
INSERT INTO kenNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kɛ mmu anɛ ákɔ̀ nɛ bɛti ǎchɨ̀ŋti ankwɛn mbɔnyunɛ mbaŋ apu ghɔ.” ");
INSERT INTO kenNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu átɛ́mɛ́ nɔ́kɔ́ nɛkay ɛnɛn, aghati yɛ bhɔ bɛ, “Mmʉɛrɛ ywɛsɛ Lásárɔs akwɛn kɛnɔ́, kɛ nchí rɔŋ mɛ́ŋɛ́mɛ yi ndǔ kɛnɔ́.” ");
INSERT INTO kenNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Bakoŋo bhi bárɛm bɛ, “Acha, mbák ǎbhʉ̀rɛ kɛnɔ́, chɔŋ aŋɛmɛ, ambak sayri.” ");
INSERT INTO kenNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Kɛnɔ́ ɛkɛn Yesu árɛ́mɛ́ nyaka bɛ Lásárɔs ǎbhʉrɛ kɛbhak chi nɛwú kɛ bákáysi bɛ Yesu arɛm chi bɛ Lásárɔs ábhʉ̀rɛ kɛnɔ́ mbɔ́ŋ. ");
INSERT INTO kenNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ɛ́kʉ́, yɛ Yesu aghati bhɔ kpoŋoroŋ bɛ, “Lásárɔs agu, ");
INSERT INTO kenNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","nɛ ɛ̌ti yɛka, mbɔ̌ŋ maŋák bɛ mpú arɛ́ mbɔnyunɛ ɛfakari chi bɛ be mǎnókó. Sɛ́ndɔ́k sɛ́ngɔ́ yi.” ");
INSERT INTO kenNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tɔmás anɛ bábhɨ̀ŋɨ bɛ Ɛfák, arɛm ntá batɨ bakoŋo Yesu abhɛ́nɛ́fú bɛ, “Sɛ́ndɔ́k ká nkwɔ bɛ Yɛ̌ chí nɛwú, sɛ́ngú nɛ yi.” ");
INSERT INTO kenNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu ágháká nɔ́kɔ́ Bɛ́tani, arɛ́, aghɔ́ bɛ́ mǎnáŋ bábhɛ́mɛ Lásárɔs kpát ɛfʉɛt manywɔp anwi. ");
INSERT INTO kenNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bɛ́fu Bɛ́tani bɛ́gháka Yerúsalɛm achi nyaka mbɔ nɛkɔ̌ bɔkilomɛta babay nɛ ɛbhɔk, ");
INSERT INTO kenNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","nɛ bɛyǎ bo Israɛl bárɔ́k bɛ́wáka nɛ Matá nɛ María ndǔ nɛwú mɔ́mayap. ");
INSERT INTO kenNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Matá ághókó nɔ́kɔ́ bɛ́ Yesu ǎtwɔ̀, afú, arɔk atɛmɛri yi ɛnɛ́ María árɔ́bhɛ́ anywɔ́p. ");
INSERT INTO kenNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Matá ághɔ́ nɔ́kɔ́ Yesu, arɛm bɛ, “Acha, mbɔ ɔchí fá, mbʉ mɔ́maya abhɨkɨ gu! ");
INSERT INTO kenNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Kɛ ndɨ́ŋɨ́ bɛ yɛ̌ chí nɛ́nɛ, yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ ɔ́bhɛ́bhɛ́ Mandɛm ǎchyɛ.” ");
INSERT INTO kenNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu aghati Matá bɛ, “Chɔŋ mɔ́mayɛ ampɛtnsɛm ndǔ nɛpɛ́m.” ");
INSERT INTO kenNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Matá arɛm bɛ, “Ndɨ́ŋɨ́ bɛ́ chɔŋ ampɛtnsɛm ndǔ nɛpɛ́m ɛwak ɛnɛ bawú mankɛm bápɛtnsɛm ndǔ nɛpɛ́m, ndǔ ngwɛnti mmɨk.” ");
INSERT INTO kenNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu arɛm bɛ, “Mɛ kɛ nchí kʉ bawú mampɛtnsɛm ndǔ nɛpɛ́m, mámbak nɛpɛ́m. Mmu anɛ ánókó mɛ, yɛ̌ angú gú, chɔŋ ampɛt ambak nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nɛ yɛ̌ agha anɛ áchí nɛpɛ́m, anoko mɛ, apú gú wáwák. Matá, ɔnókó bɛyɔŋ ɛbhɛn?” ");
INSERT INTO kenNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Matá akɛmɛ bɛ, “Acha, nnókó. Nnókó bɛ́ ɔchí Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò, Mmɔ Mandɛm anɛ ábhɔ́ŋɔ́ nyaka bɛ́twɔ fá amɨk.” ");
INSERT INTO kenNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Matá árɛ́mɛ́ nɔ́kɔ́ nɔ́, arɔk abhɨŋɨ mɔ́mayi María, aghati yí ndǔ ɛyu bɛ, “Ntɔŋ atwɔ, nɛ ǎyáŋ bɛghɔ wɔ́.” ");
INSERT INTO kenNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","María ághókó nɔ́kɔ́ nɔ́, afate, áyák arɔk ntá Yesu. ");
INSERT INTO kenNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu abhɨ́kɨ́ re ghaka nyaka ɛtɔk, abhak chí ndǔ nɛbhʉɛt anɛ Matá atɛmɛri yi. ");
INSERT INTO kenNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Bo Israɛl abhɛn báchí anywɔ́p nɛ María báwaka nɛ yi, bághɔ́ nɔ́kɔ́ ndǔ yi afate áyák áfú nɛfí, bákóŋo yi nɛ nkaysi bɛ ǎrɔ̀ŋ ndǔ nnɛm bɛdi kɛbhɔ arɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","María arɔk nɛbhʉɛt anɛ Yesu achi. Nɛghɔ́ yí ághɔ́ Yesu, akwɛ́n yi bɛkak abho bɛrɛm bɛ, “Acha, mbɔ ɔchí fá, mbʉ́ mɔ́maya abhɨ́kɨ́ gú!” ");
INSERT INTO kenNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu ághɔ́ nɔ́kɔ́ ndǔ María ádì nɛ bo Israɛl abhɛn bátwɔ́ bɛ́wáka nɛ yi bádì nkwɔ, ɛ́tɔ́k yi tɛ antɨ, ntínso nɛ́kɛ́m yi. ");
INSERT INTO kenNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Abhɛ́p bhɔ́ bɛ, “Bábhɛ́mɛ́ yi fá?” Bákɛmɛ yi bɛ, “Acha, twɔ́ ghɔ́.” ");
INSERT INTO kenNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu adi. ");
INSERT INTO kenNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ɛ́kʉ́ bo Israɛl bhɔ bábhó bɛrɛm nɛ batɨ bɛ, “Akɔŋ nyaka Lásárɔs achá! Ghɔ ndu áré di.” ");
INSERT INTO kenNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Kɛ mbɔk ɛyap báré rɛm chi bɛ, “Yi mmu ákʉ́ nnɛ́mámɨ́k ǎghɔ mbaŋ, apú kwáy nyaka bɛkʉ bɛ Lásárɔs ákɛ́ gú?” ");
INSERT INTO kenNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ɛ́pɛ́t ɛtɔk Yesu tontó, afa, arɔk ndǔ nnɛm. Nnɛm ɛnɔ nɛ́bhak chi mbok anɛ achi ndǔ sɛtárɛ́bhɛ́. Mánaŋ básɔt nyaka ntay nɛgho bákúti nyǔnɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu aghati yɛ bo abhɛn bachi arɛ bɛ, “Bɨŋɨrí ká ntay ɛnɔ fɛrɛ́.” Kɛ Matá, manɔ ngú arɛm bɛ, “Acha, ɛriɛp ɛ́ya chɔŋ ɛncha. Ɛ́kʉ manywɔp anwi ɛchɔŋ ɛnɛ́ bábhɛ́mɛ́ yi!” ");
INSERT INTO kenNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu aghati Matá bɛ, “Matá, pú ngátí wɔ́ bɛ mbák ɔnókó, chɔŋ ɔ́ngɔ́ bɛtaŋ Mandɛm?” ");
INSERT INTO kenNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Bábɨ́ŋɨri yɛ ntay ɛnɔ báfɛ́rɛ anyǔ nnɛm. Yesu ayoŋ amɨ́k ayɨŋɨ mfay arɛm bɛ, “Ɛta, nkáká wɔ bɛ́ ɔghok mɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ndɨ́ŋɨ́ bɛ́ ɔ̌ghok mɛ mpoknkɛm, kɛ ndɛm ɛnyɨŋ ɛnɛ chí ɛ̌ti bo abhɛn bachi fá téé bɛ́ mánkwáy mɛnoko bɛ wɔ kɛ ɔ́tó mɛ fá amɨk.” ");
INSERT INTO kenNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesu árɛ́mɛ́ nɔ́kɔ́ nɔ́, abɨk bɛ, “Lásárɔs, fú twɔ́!” ");
INSERT INTO kenNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lásárɔs mmu anɛ ánáŋ ágú nyaka, afú ndǔ nnɛm, nɛ ndɛn ɛnɛ mánɛ́bhɛ́ yí amɔ nɛ bɛkak nɛ bɛsí kɛ bábhɛ́mɛ yi. Yesu aghati bɔ bɛ, “Kaŋarí ká ndɛn ɛyɔ yi amʉɛt, bɛ yi ándɔ́k.” ");
INSERT INTO kenNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Bɛyǎ bo Israɛl abhɛn bakoŋo María bághɔ́ ɛnyɨŋ ɛnɛ Yesu ákʉ́, mánóko yi. ");
INSERT INTO kenNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kɛ mbɔk yap báfá bárɔ́k ntá bǒnkwɔ Fárisi bághati bhɔ ɛnyɨŋ ɛnɛ Yesu akʉ. ");
INSERT INTO kenNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Bǒbati bachiǎkap Mandɛm nɛ bǒnkwɔ Fárisi bábhɨ́ŋɨ bo ndǔ ɛchɛmɛ́ bǒbati Israɛl. Báchɛ́mɛ́ nɔ́kɔ́ nɛbhʉɛt amɔt bárɛm bɛ, “Chɔŋ sɛ́nkʉ ná? Mmǔ-nɛ ǎtɔ̀ŋ bɛyǎ bɛrɨŋɨ́ maknkay. ");
INSERT INTO kenNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Mbák sɛ́ndɔ́ yi andɔk ambɨ bɛkʉ mɛnyɨŋ ɛbhɛn, chɔŋ yɛ̌ntɨkɨ mmu anoko yi. Nɛ mbák ɛ́mfákárí ɛnyu yɔ, bǒ Rom bátwɔ́ mánchɔŋti ɛkɛrákap Mandɛm ɛyɛsɛ nɛ ɛtɔk ɛyɛsɛ.” ");
INSERT INTO kenNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Kɛ mmǔ wap amɔt anɛ áká nnyɛ́n bɛ Káyfas anɛ achí nyaka mǔngo bachiǎkap Mandɛm ndǔ mmíɛ́ ɛnɔ, arɛm ntá yap bɛ, “Bǎbhɨ́kɨ́ rɨŋɨ yɛ̌nyɨŋ! ");
INSERT INTO kenNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Bǎbhɨkɨ rɨŋɨ bɛ ɛrɨ ntá yɛka bɛ mmu amɔt ángú ɛ̌ti bo mankɛm ɛcha bɛ ɛtɔk ɛnkɛm ɛnɛm?” ");
INSERT INTO kenNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Káyfas abhɨ́kɨ́ rɛm nyaka nɔ chi mbɔ ɛnyɨŋ ɛnɛ ɛ́fú ndǔ nkaysi yi. Mandɛm kɛ ákʉ́ nyaka bɛ yi andɛm nɔ mbɔ mǔngo bachiǎkap ndǔ mmíɛ́ ɛnɔ. Arɛm bɛ́ chɔŋ Yesu ángú ɛ̌ti bo Israɛl mankɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Yesu abhɨkɨ bhɔ́ŋ nyaka bɛ́gu chí ndiɛrɛ ɛ̌ti bo Israɛl. Abhɔ̌ŋ nyaka bɛ́gu ɛ̌ti bɔ̌ Mandɛm abhɛn bátáká mmɨk nkɛm bɛ mambak ndǔ nkwɔ́ amɔt. ");
INSERT INTO kenNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Bɛ́bhó ɛwak ɛyɔ, bǒbati bo Israɛl báré yáŋ mbi bɛ́wáy Yesu. ");
INSERT INTO kenNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yesu kɛpɛrɛ kɔ yɛ kpoŋoroŋ atú ɛtɔk bo Israɛl. Afa arɛ́, arɔk atú ɛtɔk ɛnɛ ɛchi kɛkwɔt nɛ baso, amɛm ɛtɔk ɛnɛ bábhɨŋɨ bɛ Ɛfraim, abhak arɛ nɛ bakoŋo bhi. ");
INSERT INTO kenNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Mpok mɛnyiɛ Ɛpǎ Nɛkɨŋɨ bo Israɛl arɔp kɛkwɔt. Bɛyǎ bho báfa ndǔ bɔ̌bɛtɔk bhap bako, barɔk Yerúsalɛm ɛnɛ́ mpok ɛpǎ ɛyɔ ábhɨ́kɨ́ re ghaka, ndu bɛkʉ bɛ mámbák pɛ́pɛ́p bɛsí Mandɛm mbɔ ɛnyu bo Israɛl bákʉ nɔkɔ nyaka. ");
INSERT INTO kenNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Bǒ bhɔ báyàŋ nyaka Yesu, nɛ ndu báchɛ́mɛ́ amɛm ɛkɛrákap Mandɛm báré bhɛ́p batɨ bɛ, “Bǎkáysí bɛ́ yí? Bǎkáysí bɛ́ apu twɔ ndǔ ɛpǎ?” ");
INSERT INTO kenNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Bǒbati bachiǎkap nɛ bǒnkwɔ Fárisi báchyɛ́ nyaka ɛyɔŋ bɛ yɛ̌ agha anɛ árɨŋɨ ɛbhak ɛnɛ Yesu achi, ángátí bhɔ́ bɛ mánkɛ́m yi. ");
INSERT INTO kenNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ɛpǎ Nɛkɨŋɨ ɛ́rɔ́bhɛ́ nɔ́kɔ́ manywɔp atandat, Yesu afa arɔk Bɛ́tani. Bɛ́tani abhak ɛtɔk Lásárɔs anɛ Yesu akʉ yi apɛtnsɛm ndǔ nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Arɛ́, bákʉ́ yi nɛnyíɛ́ běku. Matá kɛ áfʉɛ̀t nyaka nɛnyíɛ́. Lásárɔs abhak mmu amɔt ndǔ bo abhɛn bachɔkɔ mányiɛ nɛnyíɛ́ nɛ Yesu. ");
INSERT INTO kenNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","María asɔt ɛsáyrí ɛ́kpɛ́mɛ́ bawɛrɛ́riɛp amɛn áyá nkáp apɨkɨri bɛkak Yesu, antɛsɛ nɔkɔ nɛ ɛmɛnɛ́ntí yi. Ɛkɛt ɛnkɛm ɛ́jwi nɛ ɛrɨ́tí ɛriɛbhɛ́ bawɛrɛ mɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Júdas Iskariɔt, nkoŋo Yesu amɔt anɛ ábhɔ́ŋɔ́ nyaka bɛti yi arɛm bɛ, ");
INSERT INTO kenNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Bákway mbʉ bɛti bawɛrɛ́riɛp amɛn anchyɛ nkáp anɛ́ nkʉbɛtɨk ányiɛ ndǔ mmíɛ́. Ndaká yí bábhɨ́kɨ́ tí mɔ́ mánsɔt nkáp mánchyɛ ntá bachɛ́bhɛ́bho?” ");
INSERT INTO kenNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Júdas abhɨkɨ rɛm nyaka ɛnyu ɛyɔ chi bɛ ǎghɔ báchɛ́bɛ́ bho ntínso. Arɛm nɔ chi ndu ábhɔ́ŋɔ́ nyaka ntɨ ngɛ́p. Nɛ ndǔ nkwɔ bakoŋo Yesu, yi kɛ áchí nyaka mbʉrɛ nkáp, nɛ ǎsɔ̀t nyaka aywi arɛ́ ansɛm ansɛm anyiɛ nɔkɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesu arɛm bɛ, “Dɔ̌ yí! Ɛ́rɨ yi ambʉrɛ bawɛt amɛn bɛ ámbák ndǔ nywɔp ɛnɛn bábhɛmɛ mɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Bachɛ́bhɛ́bho bachi nɛ bhe mpoknkɛm, kɛ mpú bhak nɛ bhe mpoknkɛm.” ");
INSERT INTO kenNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Bɛyǎ bo Israɛl bághókó nɔ́kɔ́ bɛ́ Yesu achi Bɛ́tani, bárɔ́k arɛ, puyɛ̌ ndiɛrɛ ndu bɛ́ghɔ Yesu kɛ ndu bɛghɔ Lásárɔs nkwɔ mmǔ yi akʉ apɛtnsɛm ndǔ nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ɛ́kʉ́ bǒbati bachiǎkap Mandɛm báté ɛyu bɛ mángwáy Lásárɔs nkwɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Báyàŋ nyaka bɛ mángwáy Lásárɔs nkwɔ mbɔnyunɛ ɛnyɨŋ ɛnɛ ɛfakari nɛ yi ɛ́kʉ́ nyaka batɨ̌ bo Israɛl bábʉɛ̀ bhɔ, mánoko nɔkɔ Yesu. ");
INSERT INTO kenNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nɛ́yí nɔ́kɔ́, bɛyǎ bo abhɛn bátwɔ́ ndǔ Ɛpǎ Nɛkɨŋɨ bághók bɛ́ Yesu ǎtwɔ̀ Yerúsalɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ɛ́kʉ́ bo babho bɛ́kpɔ́ti bɛ́wɔ̌amáŋ mandɔkɔ nɔkɔ bɛtɛmɛri yi, mámbɨk mandɛmɛ nɔkɔ bɛ, “Sɛ́mbɨ́tí Mandɛm mfay! Mandɛm ánjɛ́t mmu anɛ átwɔ̀ ndǔ nnyɛ́n Acha! Sɛ́mbɨ́tɨ́ Mfɔ bo Israɛl!” ");
INSERT INTO kenNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu asɔt mɔ́mpɔŋɔ batu, achɔkɔ yɔ́ ansɛm nkúbhɛ́ mbɔ ɛnyu básɨŋɨ amɛm Ɛkáti Mandɛm bɛ, ");
INSERT INTO kenNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Bǒ ɛtɔk Síɔn, bǎkɛ́ cháy. Ghɔ́ ká, Mfɔ ywɛka ǎtwɔ̀, chɔ́kɔ́, amfay mɔ́mpɔŋɔ batu.” ");
INSERT INTO kenNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Mpok anɛ barak ayɔ áfákárí, baghɔk Yesu kɛjwimɛm bɛ mɛnyɨŋ ɛbhɛn básɨŋɨ ɛ̌ti yi kɛ bɛ́fù nɔ́ tɛtɛp. Kɛ mpok Yesu apɛrɛnsɛm ndǔ nɛpɛ́m nɛ Mandɛm asɔt yi amfay achyɛ yi kɛnókó, bátɨk yɛ bɛ básɨŋ nyaka mɛnyɨŋ ɛbhɔ ɛ̌ti yi. Bátɨk nkwɔ́ ɛnyǔ mɛnyɨŋ ɛbhɔ bɛ́fákári ntá yi. ");
INSERT INTO kenNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Bo abhɛn bachi nɛ Yesu mpok yi ákʉ́ Lásárɔs afu ndǔ nnɛm báre ghati bo ɛnyɨŋ ɛnɛ ɛ́fákárí mbɔ batísiɛ Yesu. ");
INSERT INTO kenNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ntí anɛ bɛyǎ bo bárɔ̀ŋ nyaka bɛghɔ Yesu chí bɛ, bághok bɛ́ yi akʉ ɛrɨŋɨ́ maknkay ɛyɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Bǒnkwɔ Fárisi bághɔ́ nɔ́kɔ́ ndǔ bɛyǎ bo bárɔ̀ŋ ntá Yesu bábho yɛ bɛrɛm nɛ batɨ bɛ, “Sɛ́wày chí mmʉɛt. Yɨ́ŋɨ́, mmɨk nkɛm arɔbhɛ koŋo chi yi.” ");
INSERT INTO kenNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Mbɔk bǒ Grik nkwɔ báchí nyaka ndǔ nkwɔ bho abhɛn bárɔ́ŋɔ́ Yerúsalɛm bɛchyɛ bakak ntá Mandɛm ndǔ mpok Ɛpǎ Nɛkɨŋɨ. ");
INSERT INTO kenNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Bǒ Grik bhɔ bárɔ́k ntá Fílip anɛ áfú nyaka Bɛtsáida, atú Gálili barɛm bɛ, “Ɛta, sɛ́yàŋ bɛ́ghɔ Yesu.” ");
INSERT INTO kenNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Fílip afa, arɔk aghati Andru. Bɔ́ bati apay bárɔ́k baghati Yesu. ");
INSERT INTO kenNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu akɛmɛ bhɔ bɛ, “Mpok akway anɛ Mandɛm ákʉ̀ bo mánchyɛ́ Mmu anɛ áfú ntá yi kɛnókó. ");
INSERT INTO kenNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Tɛtɛ̌tɛp, mbák bábhɨ́kɨ́ pɨ nyɛ́sɛ́ nchwi amɨk nɛ́mpɔ́, nɛ́bhak chi nyɛ́sɛ́ nchwi nɛmɔt. Kɛ mbák mámpɨ́ nyɛ́sɛ́ nchwi amɨk nɛ́mpɔ, nɛ́nchak, nɛ́chyɛ bɛyǎ nchwi nkɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mmǔ anɛ ákɔ́ŋɔ́ nɛpɛ́m ɛni, ǎnɛm nɔ́, kɛ mmu anɛ ápú re fyɛ ntí ndǔ nɛpɛ́m ɛni ɛnɛn fá amɨk apu nɛ́m nɔ́, ǎbhɔŋ nɔ́ kpát anchwe ndǔ nɛpɛ́m ɛnɛn nɛbhɨkɨ bhɔŋ ngwɛnti. ");
INSERT INTO kenNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mmu anɛ áká bɛtok mɛ, abhɔŋ bɛ́kóŋo mɛ. Nɛ nɛbhʉɛt anɛ mɛ̌bhák, arɛ́ kɛ̌ nkʉbɛtɨk awa ábhák nkwɔ. Mbák mmu ántók mɛ, Ɛtaya ǎkʉ yi ambɔŋ kɛnókó.” ");
INSERT INTO kenNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yesu arɛm bɛ, “Nɛ́nɛ, ntɨ ɛna nɛ́pú amɛm kpák. Chɔŋ ndɛm bɛ yi? Chɔŋ ndɛm chí bɛ ‘Ɛta, fɛrɛ́ mɛ ndǔ ɛsɔŋɔri ɛnɛ ɛ́twɔ̀ nɛ́ kɛ?’ Wáwák! Mbɔ̌ŋ ɛ̌ti ɛsɔŋɔri ɛnɛ́ kɛ ntwɔ́ fá amɨk! ");
INSERT INTO kenNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ɛta, kʉ bo mánchyɛ́ nnyɛ́n ɛna kɛnókó.” Yesu árɛ́mɛ́ nɔ́kɔ́ nɔ́, ɛyɔŋ ɛ́fú amfay ɛrɛm bɛ, “Nnáŋ nkʉ nnyɛ́n ɛna nɛ́mbɔ́ŋ kɛnókó nɛ chɔŋ mpɛt nkʉ nɔ.” ");
INSERT INTO kenNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Bɛyǎ bo abhɛn bachi arɛ́ téé bághókó nɔ́kɔ́ ɛyɔŋ ɛyɔ, bare rɛm bɛ, “Nɛfaŋ kɛ ásáy!” Báchák bɛ, “Ángɛl Mandɛm árɛ̀m kɛpɨ nɛ yi.” ");
INSERT INTO kenNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesu aghati bhɔ bɛ, “Ɛyɔŋ ɛnɛ ɛ́twɔ́ ɛ̌ti yɛka. Ɛbhɨkɨ twɔ ɛ̌ti ya. ");
INSERT INTO kenNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Mpok akway anɛ Mandɛm átàŋ mmɨk nɛ, mpok ákway anɛ báfɛ̀rɛ mfɔ mmɨk nɛ ndǔ kɛfɔ ɛki. ");
INSERT INTO kenNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nɛ mǎnáŋ mamkpáŋ mɛ amfay ndǔ ɛkotákátí, chɔŋ nja bǒ mankɛm bɛ mándɔ́ mmɨk mantwɔ ntá ya.” ");
INSERT INTO kenNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu arɛm bɛyɔŋ ɛbhɛn ndu bɛtɔŋ ɛnyǔ nɛwú ɛnɛn yi ábhɔ́ŋɔ́ bɛ́gu. ");
INSERT INTO kenNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Bɛyǎ bo abhɛn báchí arɛ bárɛ́m bɛ, “Ɛkáti Mandɛm ɛ́ghati bhɛsɛ bɛ, ‘Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò apú gú. Ndaká yí ɔ́rɛ̀m bɛ chɔŋ mánsɔt mmu anɛ áfú ntá Mandɛm mango ndǔ ɛkotákátí? Mmu anɛ áfú ntá Mandɛm chi agha?’” ");
INSERT INTO kenNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu aghati bhɔ bɛ, “Ɛrɔ́ŋɔ́ ɛ́bhʉɛ́t nɛ bhe ndu mɔ́mbɨŋɨ mpok. Dɔk yɛ ka ambɨ bɛkɔ ndǔ mpok anɛ ɛrɔ́ŋɔ́ ɛ́bhʉɛ́t nɛ bhe, bɛ ɛjuri ɛkɛ twɔ ɛmfɔkɔri bhe. Mmǔ anɛ ákɔ̀ amɛm ɛjuri, apú rɨŋɨ ɛbhak ɛnɛ yi árɔ̀ŋ. ");
INSERT INTO kenNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Sɨkɨ́ ká ntɨ nɛ mmǔ anɛ áchyɛ bɛdiɛ́rɛ́ nɛ́nɛ, ndǔ yi abhʉɛ́t nɛ bhe, bɛ́ mǎmbák bɔ̌ bɛdyɛrɛ.” Yesu árɛ́mɛ́ nɔ́kɔ́ nɔ́, arɔk abhɛsɛ ɛbhak ɛnɛ́ bo bápú kwáy bɛghɔ yi. ");
INSERT INTO kenNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yɛ̌ndu yi ákʉ́ bɛyǎ mɛnyɨŋɨ́ maknkay bɛsí ɛbhap, bábhɨ́kɨ́ noko yí. ");
INSERT INTO kenNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ɛ́bhak ɛnyu ɛyɔ bɛ́ ɛnyɨŋ ɛnɛ́ ndɛmɛkɛpɨ̌ntɨ Aisáya árɛ́mɛ́ tɛntɛp bɛ́ chɔŋ ɛ́mfakari, ɛ́mfú tɛtɛp. Nɔ chí bɛ, “Ɛta Mandɛm, agha ánókó ɛnyɨŋ ɛnɛ sɛ́gháti bhɔ? Agha ághɔ́ bɛtaŋ ɛbhɛ?” ");
INSERT INTO kenNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Bǒbhɛn bábhɨkɨ kwáy nyaka mɛ́nóko, nkúbhɛ́ mbɔ ɛnyu Aisáya apɛt árɛ́mɛ́ nyaka bɛ ");
INSERT INTO kenNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Mandɛm akʉ bɔ́ mámbák amɨ́k nɛ́mɛ́nɛ́mɛ́, agwɔ́t batɨ ayap, báchí mbɔ bo abhɛn bákútí amɨ́k bɛ bákɛ́ ghɔ́ mbaŋ, nɛ bɛ́ batu yap ákɛ́ ghók yɛ̌nyɨŋ, nɛ bɛ bákɛ́ jwimɛm, mantwɔ ntá ya, mbú bhɔ.” ");
INSERT INTO kenNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisáya arɛm nyaka nɔ mbɔnyunɛ aghɔ nyaka kɛnókó Yesu, nɛ are rɛm ɛ̌ti yi. ");
INSERT INTO kenNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kɛ yɛ̌ndu bɛyǎ bo mánóko nyaka Yesu, bábhɨ́kɨ́ rɛm kpoŋoroŋ bɛ mánóko, ndu báchày bǒnkwɔ Fárisi, bɛ bákɛ́ bók bhɔ ndǔ ɛkɛrɛ́ nɛnɨkímʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Bákɔŋ kɛnókó ɛkɛn bǒ mmɨk báchyɛ̀ bhɔ, ɛcha kɛnókó ɛkɛn Mandɛm áchyɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu arɛm nɛ ɛyɔŋ amfay bɛ, “Mmǔ anɛ ánókó mɛ, abhɨ́kɨ́ noko chí mɛ, anókó mmu anɛ ato mɛ nkwɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nɛ mmǔ anɛ ághɔ́ mɛ, ághɔ̌ mmu anɛ átó mɛ nkwɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ntwɔ fá amɨk mbɔ ɛrɔ́ŋɔ́ bɛ́ yɛ̌ agha anɛ ánókó mɛ, ákɛ́ rɔp amɛm ɛjuri. ");
INSERT INTO kenNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Mmu anɛ ághókó ɛyɔŋ ɛya kɛ yi kɛkʉ mbɔ ɛnyǔ yí ághókó, mpú táŋ yí. Mbɨ́kɨ́ twɔ fá amɨk bɛ́táŋ bo, ntwɔ chi bɛpɛmɛ bho. ");
INSERT INTO kenNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ɛnyɨŋ ɛ́chí ɛnɛ ɛ́taŋ mmu anɛ ábyak mɛ, yi kɛnókó ɛyɔŋ ɛya. Chɔŋ mɛnyɨŋ ɛbhɛn ndɛ́mɛ́ mɛntaŋ yi ndǔ nywɔp ɛnɛn bátaŋ bo. ");
INSERT INTO kenNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ɛbhɔŋ bɛbhak ɛnyu ɛyɔ mbɔnyunɛ mɛnyɨŋ ɛbhɛ́n ndɛ́mɛ́, mbɨ́kɨ́ rɛm chí ndǔ bɛtaŋ ɛbha. Ɛtaya mmu átó mɛ kɛ ághátí mɛ ɛnyɨŋ ɛnɛ mbɔ́ŋɔ́ bɛ́rɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nɛ ndɨ́ŋɨ́ bɛ́ ɛyɔŋ ɛyi ɛnɛ yí áchyɛ́ mbɔ ɛbhé ɛ́twɔ̀ nɛ nɛpɛ́m ɛnɛn nɛbhɨkɨ bhɔŋ ngwɛnti. Ɛnyɨŋ ɛnɛ mɛ̌rɛ̀m yɛ chí ɛnɛ́ Ɛta ágháti mɛ ndɛm.” ");
INSERT INTO kenNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ɛpǎ Nɛkɨŋɨ ɛ́pɛ́rɛ ghaka, Yesu arɨŋɨ bɛ mpok akway anɛ yi árɔ mmɨk, ampɛtnsɛm ntá ɛtayi. Ndǔ yi ákɔ́ŋ nyaka bǒbhi fá amɨk, nɛ́nɛ atɔ́ŋ bɛ́ akɔŋ bɔ acha. ");
INSERT INTO kenNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Mpok Yesu áchɔ́kɔ́, ányìɛ nɛnyíɛ́, běku nɛ baghɔkɔ́ bhi. Satan anáŋ achwe nyaka antí Júdas, mmɔ̌ Símun Iskariɔt, ndu bɛkʉ yi ántí Yesu. ");
INSERT INTO kenNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu arɨ́ŋɨ́ bɛ ɛtayi achyɛ yi bɛtaŋ amfay mɛnyɨŋ mɛnkɛm, nɛ bɛ́ yí afú chí ntá Mandɛm nɛ ǎpɛ̀tnsɛm ntá Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mpok báchɔ́kɔ́ mɛnyiɛ nɛnyíɛ́ ɛnɔ, Yesu afaté, afɛrɛ ɛ́wɛt ɛyi amʉɛt, asɔt táwáy atɛ́m ɛbho. ");
INSERT INTO kenNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Asɔt yɛ manyiɛp afyɛ́ ndǔ ɛnyɨŋ, abho bɛso bɛkak bakoŋo bhi, antɛsɛ nɔkɔ nɛ táwáy anɛ yi átɛ́mɛ́ ɛbho. ");
INSERT INTO kenNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Áchwɔ́bhɛ́ nɔ́kɔ́ ntá Símun Píta, Píta arɛm bɛ, “Acha, ɔ̌yàŋ bɛso bɛkak ɛbha?” ");
INSERT INTO kenNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu akɛmɛ yi bɛ, “Nɛ́nɛ, ɔbhɨ́kɨ́ rɨŋɨ ntí anɛ mɛ̌kʉ̀ ɛnyɨŋ ɛnɛ mɛ̌kʉ̀, kɛ ansɛmpok chɔŋ ɔ́njwimɛm.” ");
INSERT INTO kenNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Píta arɛm bɛ, “Ɔbhɨ́kɨ́ bhɔŋ bɛso mɛ bɛkak wáwák.” Yesu akɛmɛ yi bɛ, “Mbák mbɨ́kɨ́ so bɛkak ɛbhɛ, nɔ mɛmay nɛ wɔ sɛ́may.” ");
INSERT INTO kenNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Píta arɛm ntá Yesu bɛ, “Acha, ɔ́kɛ́ so chi ndiɛrɛ bɛkak ɛbha, sǒ amɔ́ ya nɛ ntí wa nkwɔ!” ");
INSERT INTO kenNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu aghati yi bɛ, “Mmǔ anɛ ánáŋ ásó mmʉɛt, abhɨ́kɨ́ pɛrɛ bhɔŋ bɛso mmʉɛt, ɛbhɨkɨ fʉɛt bɛkak ɛbhi, mbɔnyunɛ mmʉɛt nkɛm achi pɛ́pɛ́p. Nɛ bǎchi pɛ́pɛ́p, kɛ puyɛ̌ yɛ̌ntɨkɨ mmu ywɛka.” ");
INSERT INTO kenNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu anáŋ arɨ́ŋɨ́ nyaka mmu anɛ ábhɔ́ŋɔ́ bɛti yi. Ɛ̌ti yɔ kɛ yi árɛ́mɛ́ bɛ, “Puyɛ̌ be mankɛm kɛ bǎchí pɛ́pɛ́p.” ");
INSERT INTO kenNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ánáŋá nɔ́kɔ́ bɛ́só bɛkak ɛbhap, akɛmɛ nkú amʉɛt, apɛtnsɛm, arɔk, achɔkɔ amɨk. Abhɛ́p bhɔ bɛ, “Bǎjwímɛm ndǔ ɛnyɨŋ ɛnɛ nkʉ́ ntá yɛka? ");
INSERT INTO kenNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Bǎbhɨ̀ŋɨ mɛ bɛ, ‘Ntɔŋ’ nɛ ‘Acha’ nɛ ɛ́chí tɛtɛp. Nchí Ntɔŋ nɛ Acha ntá yɛka. ");
INSERT INTO kenNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mbák mɛ, Acha nɛ Ntɔŋ aywɛka nsó bɛkak ɛbhɛka, be nkwɔ bǎbhɔŋ bɛso bɛkak batɨ! ");
INSERT INTO kenNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ntɔ̌ŋ be chi ɛrɨŋ bɛ be nkwɔ mǎnkʉ́ nɔ́kɔ́ mbɔ ɛnyǔ nkʉ. ");
INSERT INTO kenNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Tɛtɛ̌tɛp, mǔbɛtok apú cha chi-bɛtok aywi, nɛ mǔnto apú cha mmǔ anɛ átó yi. ");
INSERT INTO kenNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nɛ́nɛ, bǎrɨŋɨ mɛnyɨŋ ɛbhɛn. Chɔŋ ɛndɨ ntá yɛka ɛncha mbák bǎkʉ̀ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Mpú rɛm chi ɛ̌ti yɛka mankɛm, ndɨ́ŋɨ́ bo abhɛn njábhɛ́. Ɛnyɨŋ ɛnɛ Ɛkáti Mandɛm ɛ́ghàti bhɛsɛ ɛ́bhɔŋ bɛ́fú kpoŋoroŋ mbɔ ɛnyu basɨŋɨ bɛ, ‘Anɛ ányíɛ́ nɛnyíɛ́ nɛ mɛ ǎti chɔŋ mɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nchí ghati bhe mɛnyɨŋ ɛbhɛn nɛ́nɛ ndu bɛ́bhɨ́kɨ́ re fakari, bɛ́ mɛ́náŋ mɛ́mfákárí, mǎnókó bɛ, ‘Nchí mmu nchí’ mpoknkɛm.” ");
INSERT INTO kenNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Tɛtɛ̌tɛp, “Mmǔ anɛ ásɔ̀t yɛ̌ agha anɛ ntó sayri, ǎsɔt mɛ. Nɛ mmǔ anɛ ásɔ́rɛ́ mɛ́ sayri, ǎsɔt mmǔ anɛ átó mɛ.” ");
INSERT INTO kenNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu árɛ́m nɔ́kɔ́ mɛnyɨŋ ɛbhɛn, ntɨ nɛ́ré sɔŋɔri yi amɛm, arɛm kpoŋoroŋ bɛ, “Tɛtɛ̌tɛp, mmu ywɛka amɔt ǎtí chɔŋ mɛ.” ");
INSERT INTO kenNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Bakoŋo bhi bábhó bɛyɨŋɨ batɨ, kɛrɨŋɨ mmu anɛ Yesu árɛ̀m nɔ ɛ̌ti yi. ");
INSERT INTO kenNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Nkoŋo anɛ Yesu ákɔ́ŋɔ́ tontó abhak chɔ́kɔ́ kɛkwɔt nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Símun Píta amak yi nɛ awɔ arɛm bɛ, “Ghatí bhɛ́sɛ́ mmu anɛ ɔ́rɛ̀m nɔ ɛ̌ti yi.” ");
INSERT INTO kenNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nkoŋo wu akokosi mmʉɛt nɛ Yesu abhɛ́p yi bɛ, “Acha, chí agha?” ");
INSERT INTO kenNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu akɛmɛ yi bɛ, “Chi mmu anɛ mɛ̌tap chɔŋ brɛt anɛ amɛm nchán nnok nchyɛ́ yí.” Yesu asɔt yɛ ɛkpɔkɔ́ brɛt atap ndǔ nnok, achyɛ Júdas, mmɔ̌ Símun Iskariɔt. ");
INSERT INTO kenNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Nɛsɔt Júdas ásɔ́rɛ́ brɛt wu, Satan akó yi anti. Yesu aghati yi bɛ, “Ɔ́kɛ́ chɔŋti mpok bɛkʉ ɛnyɨŋ ɛnɛ ɔ́yàŋ bɛkʉ.” ");
INSERT INTO kenNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Bakoŋo Yesu báchák kɛrɨŋɨ ntí anɛ Yesu árɛ́mɛ́ nɔ ntá Júdas. ");
INSERT INTO kenNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Tɛ̌ndu Júdas kɛ ákɛm nyaka ɛbhǎ nkáp, mbɔk ɛyap báré kaysi bɛ Yesu ǎghàti yi chi bɛ ándɔ́k, ánkú mɛnyɨŋ ɛbhɛn bɔ básɔt mɛnyiɛ Ɛpǎ Nɛkɨŋɨ. Báchák bákáysi bɛ Yesu ato yi ándɔ́k ánchyɛ́ nkáp ntá bachɛ́bhɛ́bho. ");
INSERT INTO kenNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Júdas ásɔ́rɛ́ nɔ́kɔ́ ɛkpɔkɔ́ brɛt ɛyɔ, afú nɛfí tɛ́mté. Nɛ bɛti bɛ́gʉ́. ");
INSERT INTO kenNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Júdas áfú nɔ́kɔ́, Yesu arɛm bɛ, “Nɛ́nɛ, chɔŋ bo mángɔ́ ndu báchyɛ Mmu anɛ áfú ntá Mandɛm kɛnoko, nɛ bɛfʉɛt ntá yi mángɔ ndu bachyɛ Mandɛm kɛnókó. ");
INSERT INTO kenNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Mbák Mmu anɛ áfú ntá Mandɛm ákʉ̀ mánchyɛ Mandɛm kɛnókó, mbɔ̌ŋ Mandɛm ǎkʉ̀ bo mánchyɛ Mmu anɛ áfú ntá yi kɛnókó, nɛ chɔŋ ankʉ nɔ tɛ́mté. ");
INSERT INTO kenNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Bɔ̌bha, mpú pɛrɛ tat nɛ bhe. Chɔŋ mǎnjáŋ mɛ, kɛ ɛnyɨŋ ɛnɛ ngátí nyaka bǒbati bo Israɛl, nchí ghati bhe nɛ́nɛ bɛ, ‘Ɛbhak ɛnɛ́ mɛ̌rɔ̀ŋ, bǎpú kwáy bɛ́twɔ arɛ́’. ");
INSERT INTO kenNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nchí chyɛ be ɛbhé ɛkɔ. Kɔŋ ka batɨ mbɔnyu nkɔ́ŋ be. Ɛnyu ɛyɔ kɛ̌ bǎbhɔ́ŋɔ́ bɛkɔŋ batɨ. ");
INSERT INTO kenNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mbák mǎnkɔ́ŋ batɨ, chɔŋ ɛ́nkʉ bǒ mankɛm mándɨŋɨ bɛ bǎchí bakoŋo bha.” ");
INSERT INTO kenNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Símun Píta abhɛp Yesu bɛ, “Acha, ɔ̌rɔ̀ŋ fá?” Yesu akɛmɛ yi bɛ, “Ɛbhak ɛnɛ́ mɛ̌rɔ̀ŋ, ɔpú kway bɛ́twɔ arɛ́ nɛ́nɛ, kɛ chɔŋ ɔ́nkoŋo mɛ arɛ́ ansɛmpok.” ");
INSERT INTO kenNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Píta arɛm bɛ, “Acha, ndáká yí mpú kwáy bɛ́kóŋo wɔ nɛ́nɛ? Yɛ̌ chí nɛwú, nká bɛ́gu ɛ̌ti yɛ.” ");
INSERT INTO kenNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu arɛm ntá yi bɛ, “Ɔbhɛ́ yɛ̌ chí nɛwú ɔká bɛ́gu ɛ̌ti ya? Tɛtɛ̌tɛp, nkɔk apɛrɛ́ kok nkúbhɛ́ bɛti ɛbhɛn, chɔŋ ɔ́ndɛm ndɔŋ ɛ́rát bɛ ɔbhɨkɨ rɨŋɨ mɛ.” ");
INSERT INTO kenNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu aghati baghɔkɔ́ bhi bɛ, “Bǎkɛ́ rɔ batɨ ánsɔ́ŋɔ́rí be amɛm. Sɨkɨ́ ká ntɨ nɛ Mandɛm, mǎnsɨkɨ ntɨ nɛ mɛnkwɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ɛkɛt Ɛtaya ɛbhɔŋ bɛyǎ bɔ̌bɛkɛt. Mbɔ ɛ́pú nɔ, mbʉ mbɨ́kɨ́ ghati bhe bɛ nchí rɔ́ŋ arɛ́ bɛ́tóŋti ɛbhak ntá yɛka. ");
INSERT INTO kenNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nɛ nnáŋ, ndɔ́k, ngókó ɛbhak mbʉrɛ́, ntá yɛka chɔŋ mpɛtnsɛm, nsɔt be, bɛ́ nɛbhʉɛt anɛ nchí, bě nkwɔ mambák arɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Bǎrɨŋɨ mbi anɛ árɔ̀ŋ ndǔ nɛbhʉɛt anɛ mɛ̌rɔ̀ŋ.” ");
INSERT INTO kenNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tɔmás arɛm ntá Yesu bɛ, “Acha, sɛ́bhɨ́kɨ́ rɨŋɨ nɛbhʉɛt anɛ ɔ́rɔ̀ŋ, ná sɛ́kwày bɛrɨŋɨ mbi?” ");
INSERT INTO kenNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu aghati yi bɛ, “Mɛ kɛ nchí mbi, mɛ kɛ nchí tɛtɛp, mɛ kɛ nchí nɛpɛ́m. Yɛ̌ mmu apu kway bɛ́twɔ ntá Ɛta ɛnɛ́ ábhɨ́kɨ́ fʉɛt ntá ya. ");
INSERT INTO kenNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Mbɔ bǎrɨ́ŋɨ́ mɛ́ tɛtɛp, mbʉ́ bǎrɨ́ŋɨ́ Ɛtaya nkwɔ́. Nɛbho nɛ́nɛ, bǎrɨŋɨ yí nɛ mǎnáŋ bǎghɔ́ yí.” ");
INSERT INTO kenNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Fílip arɛm bɛ, “Acha, tɔ́ŋ bhɛ́sɛ́ mbɔŋ ɛtayɛ. Ɛnyɨŋ ɛ́chák ɛnɛ sɛ́yàŋ ɛ́pú.” ");
INSERT INTO kenNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu akɛmɛ yi bɛ, “Fílip, mpok anɛ nkɛm nchí nɛ bhe, yɛ̌ nɔ, ɔbhɨ́kɨ́ rɨŋɨ mɛ? Mmu ángɔ́ mɛ nɔ́ aghɔ Ɛtaya nkwɔ. Ná ɔ́rɛ̀m yɛ bɛ, ‘Tɔ́ŋ bhɛsɛ́ ɛtayɛ?’ ");
INSERT INTO kenNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ɔbhɨ́kɨ́ noko bɛ nchí babhát nɛ Ɛtaya nɛ Ɛtaya achi babhat nɛ mɛ? Mɛnyɨŋ ɛbhɛn mɛ́ghàti bhe, mpú kʉ nɔ chi ndǔ mmʉɛ́t ɛya. Ɛtaya mmu achí babhat nɛ mɛ ǎkʉ̀ bɛtɨk ɛbhi. ");
INSERT INTO kenNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nokó ka ɛnyɨŋ ɛnɛ ngátí bhe bɛ́ nchí babhat nɛ Ɛtaya nɛ Ɛtaya achi babhat nɛ mɛ. Mbák bápú kway mɛnoko mɛnyɨŋ ɛbhɛn mɛ̌rɛ̀m, nokó ká ɛ̌ti mɛnyɨŋ ɛbhɛn mɛ̌kʉ̀.” ");
INSERT INTO kenNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Tɛtɛ̌tɛp, “Mmu anɛ asɨkɨ ntɨ nɛ mɛ, ǎkway bɛ́kʉ mɛnyɨŋ ɛbhɛn mɛ̌kʉ̀. Ǎkwáy bɛ́kʉ yɛ̌ chí mɛnyɨŋ ɛbhɛn bɛ́chá ɛbhɛn, mbɔnyunɛ mɛ̌rɔ̀ŋ ntá Ɛtaya. ");
INSERT INTO kenNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ bǎbhɛ́bhɛ́ ndǔ nnyɛ́n ɛna, chɔŋ nkʉ yɔ́ bɛ́ bo mángɔ́ mɛnyɨŋ ɛbhɛn mmɔ́ ákʉ̀ nɛ mánchyɛ Ɛta kɛnókó ɛ̌ti Mɔ́ywi. ");
INSERT INTO kenNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ bábhɛ́bhɛ́ ndǔ nnyɛ́n ɛna, chɔŋ nkʉ yɔ nta yɛka.” ");
INSERT INTO kenNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yesu apɛt aghati baghɔkɔ́ bhi bɛ, “Mbák bǎkɔŋ mɛ, bʉrɛ́ ká ɛyɔŋ ɛbha. ");
INSERT INTO kenNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Mbák bǎkʉ̀ nɔ, chɔŋ nnɨk Ɛtaya mmʉɛt, nɛ yi anchyɛ bhe Nkwak achak, yi ambák nɛ bhe mpoknkɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Yí chí Ɛfóŋó ɛnɛ ɛ́kʉ̀ bo mándɨ́ŋɨ́ barak anɛ tɛtɛp. Bǒ mmɨk bápú kway bɛsɔt yi nɛ maŋák mbɔnyunɛ bápú kway bɛghɔ yi, nɛ bapu kway bɛrɨŋɨ yí. Kɛ chɔŋ mǎndɨ̀ŋɨ yi mbɔnyunɛ ǎbhák chɔŋ nɛ bhe, nɛ amɛm batɨ yɛka.” ");
INSERT INTO kenNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Yesu arɔk ambɨ bɛrɛm bɛ, “Nnáŋ ndɔ́k, mpú rɔ mǎmbák mbɔ bɔ̌bɛrǎ. Chɔŋ mpɛtnsɛm ntá yɛka. ");
INSERT INTO kenNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mandú mpok, bǒ mmɨk bápú pɛrɛ ghɔ́ mɛ kɛ bǎghɔ́ chɔŋ mɛ. Nɛ tɛ̌ndu mpɛt nchi bhak chɔŋ nɛpɛ́m, chɔŋ bě nkwɔ mǎmpɛt mǎmbak nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ndǔ nywɔp ɛnɔ, chɔŋ mǎndɨŋɨ bɛ́ nchí babhat nɛ Ɛtaya, nɛ bǎchi babhat nɛ mɛ, nɛ nchí babhat nɛ bhe. ");
INSERT INTO kenNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Mmu anɛ ághòk ɛnyɨŋ mɛ̌rɛ̀m ánkʉ mbɔ ɛnyu yi ághókó, yi kɛ áchí mmu anɛ ákɔ́ŋɔ́ mɛ. Nɛ Ɛtaya akɔŋ mmu anɛ akɔŋ mɛ. Mɛnkwɔ́ nchí kɔŋ bɛ yi ántwɔ́ ntá yi, nkʉ yí ándɨŋɨ mɛ.” ");
INSERT INTO kenNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Júdas, anɛ áchí kɛkúrí nɛ Júdas Iskariɔt abhɛ́p Yesu bɛ, “Acha, ndaká yí ɔ́twɔ̀ chɔŋ chi ntá yɛsɛ bakoŋo bhɛ bɛ́kʉ sɛ́ndɨ́ŋɨ́ wɔ, kɛbhák bɛ́ ɔ̌kʉ nɔ chi ntá bǒ mmɨk bachak?” ");
INSERT INTO kenNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu akɛmɛ yi bɛ, “Mmu anɛ ákɔ́ŋɔ́ mɛ, ǎbhʉ̀rɛ ɛyɔŋ ɛya. Ɛtaya ǎkɔ̀ŋ yi. Nɛ mɛ, nɛ Ɛtaya sɛ́ntwɔ sɛnchɔkɔ nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mmǔ anɛ abhɨ́kɨ́ kɔŋ mɛ, apú bhʉɛrɛ ɛyɔŋ ɛya. Mɛnyɨŋ ɛbhɛ́n bǎghoko mɛ ntɔ́ŋɔ́, bɛ́bhɨ́kɨ́ fu ntá ya. Bɛ́fu chi ntá Ɛtaya mmu átó mɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Ngátí bhe mɛnyɨŋ ɛbhɛn ɛnɛ́ mbʉɛ́t nɛ bhe. ");
INSERT INTO kenNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kɛ Ɛta ǎtò chɔŋ Nkwak ndǔ nnyɛ́n ɛna. Yí wu chi Ɛfóŋó Bɛdyɛrɛ. Ánáŋ ántwɔ́, chɔŋ antɔŋ be yɛ̌ntɨkɨ ɛnyɨŋ, ankwak be mǎntɨk mɛnyɨŋ mɛnkɛm ɛbhɛn ngáti bhe. ");
INSERT INTO kenNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nchí rɔ kpák ámbák nɛ bhe. Nchí chyɛ bhe kpák anɛ áfù ntá ya. Puyɛ̌ ɛnyǔ mmɨk áchyɛ̀ bho kpák kɛ̌ mɛ̌chyɛ. Bǎkɛ rɔ batɨ ánsɔ́ŋɔ́rí bhe amɛm, nɛ bǎkɛ rɔ bɛcháy mɛ́mbak amɛm batɨ yɛka. ");
INSERT INTO kenNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Bǎghok ndu ngátí bhe bɛ, ‘Mɛ̌rɔ̀ŋ, kɛ chɔŋ mpɛtnsɛm ntá yɛká.’ Mbɔ bǎkɔ̀ŋ mɛ mbʉ bǎbhɔŋ maŋák bɛ́ mɛ̌rɔ̀ŋ ntá Ɛtaya, mbɔnyunɛ Ɛtaya acha mɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ngátí nɔ́ bhe mɛnyɨŋ ɛbhɛn nɛ́nɛ ɛnɛ́ bɛ́bhɨ́kɨ́ re fakari, nɛ ntí bɛ mɛ́náŋ mɛ́mfákárí, mǎnókó. ");
INSERT INTO kenNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mpú pɛrɛ ghati bhe bɛyǎ mɛnyɨŋ mbɔnyunɛ mfɔ mmɨk ǎtwɔ̀. Abhɨ́kɨ́ bhɔŋ bɛtaŋ amfay ya. ");
INSERT INTO kenNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Kɛ nchí kʉ chí mbɔ ɛnyǔ Ɛtaya ághátí mɛ, bɛ́ bǒ mmɨk mándɨ́ŋɨ́ bɛ́ nkɔŋ yi. Faté ká sɛ́ndɔ́k.” ");
INSERT INTO kenNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesu arɛm bɛ, “Mɛ kɛ nchí mbɔ̌ŋ nnɛrɛ́nɔk, nɛ Ɛtaya achi nkwaŋankɨ. ");
INSERT INTO kenNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yɛ̌ntɨkɨ ntábhɛ́nɔk awa anɛ́ ápú nyu kɛpɛm, Ɛtaya ǎkpɔt angʉɛp. Nɛ ntábhɛ́nɔk anɛ ányù kɛpɛm, ǎkpɔti batap rɔrɔt amfɛrɛ bɛ́ wú ányú kɛpɛm ancha ɛnyu ɛsɨ́. ");
INSERT INTO kenNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Bɛyɔŋ ɛbhɛ́n ngátí bhe bɛ́kʉ bǎchí pɛ́pɛ́p. ");
INSERT INTO kenNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Bat yɛ ka mmʉɛt nɛ mɛ mpoknkɛm, bɛ́ mɛnkwɔ mbát mmʉɛt nɛ bhe. Mbák ntabhɛ́nɔk ápú babhát ndǔ ɛnɔk, ápú nyu kɛpɛm. Ɛnyu yɔ kɛ ɛchi nɛ bhe. Mbák mmǔ abhɨ́kɨ́ bhat mmʉɛt nɛ mɛ, apú kwáy mɛ́nyú kɛpɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Mɛ kɛ nchí nnɛrɛ́nɔk. Bǎchí batáp. Mmu anɛ achí babhat nɛ mɛ mpoknkɛm, mɛnkwɔ́ mbak babhát nɛ yi, yí wu kɛ ányù bɛyǎ kɛpɛm. Mbák mpú nɛ bhe, bǎpú kway bɛkʉ yɛ̌nyɨŋ. ");
INSERT INTO kenNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mbák mmu apú babhát nɛ mɛ, ǎbhák mbɔ ntábhɛ́nɔk anɛ́ bákpɔ́t báfɛ́rɛ́, ágú. Mányókóti mɛnyǔ batap ayɔ mámɛsɛ ango, ánsɔŋɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mbák mǎndɔk ambɨ bɛbhat mmʉɛt nɛ mɛ, nɛ bɛyɔŋ ɛbha mɛ́mbak amɛm batɨ yɛka, nchí chyɛ bhe yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ babhɛbhɛ mɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ndǔ mǎnyú bɛyǎ kɛpɛm, bǎtɔŋ bɛ bǎchí bakoŋo bha, nɛ ɛyɔ ɛ́kʉ̀ bo mánchyɛ Ɛtaya kɛnókó. ");
INSERT INTO kenNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mbɔ ɛnyu Ɛtaya ákɔ́ŋ mɛ, nɔ́ kɛ nkɔ́ŋɔ́ bhe. Bat ka mmʉɛt nɛ mɛ bɛ́ ɛkɔŋ ɛya ɛ́mbák amɛm batɨ yɛka mpoknkɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mbák mǎndɔk ambɨ bɛbhʉrɛ ɛyɔŋ ɛya, mpú rɔ bɛkɔŋ be nkúbhɛ́ mbɔ ɛnyǔ nchí bhʉɛrɛ Ɛyɔŋ Ɛtaya nɛ yi akɔŋ mɛ mpoknkɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ngátí bhe mɛnyɨŋ ɛbhɛn bɛ maŋák ama ámbák nɛ bhe, nɛ bɛ maŋák amɛka anjwi pɔɔt. ");
INSERT INTO kenNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Ɛnyɨŋ ɛnɛ nchí ghati bhe chi bɛ mankɔ́ŋ batɨ mbɔnyu nkɔ́ŋ be. ");
INSERT INTO kenNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ɛkɔŋ ɛchak ɛ́pú ɛnɛ́ ɛ́chá ɛnɛ ɛ́kʉ́ mmu ánchyɛ́ nɛpɛ́m ɛni ɛ̌ti mamʉɛrɛ bhi. ");
INSERT INTO kenNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Bǎbhak mamʉɛrɛ bha mbák bǎkʉ̀ mɛnyɨŋ ɛbhɛn ngátí bhe. ");
INSERT INTO kenNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mpú pɛrɛ bhɨŋɨ be bɛ́ bɔ̌bɛtok, mbɔnyunɛ mmɔ̌bɛtok apu rɨŋɨ nkaysi chi-bɛtɨk ndǔ ɛnyɨŋ ɛnɛ yi ákʉ̀. Mbɨ́ŋɨ́ bhe bɛ́ mamʉɛrɛ bha mbɔnyunɛ ngátí bé mɛnyɨŋ ɛbhɛ́n ngókó ntá Ɛtaya mɛnkɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Bǎbhɨ́kɨ́ yap mɛ, mɛ kɛ njábhɛ́ bhe ntó bɛ́ mǎndɔ́k mǎnyú kɛpɛm, nɛ bɛ́ kɛpɛm ɛkɛka kɛ́mbák mpoknkɛm. Kʉ ka nɔ́ bɛ Ɛtaya ánchyɛ́ bhe yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ bǎbhɛbhɛ yi ndǔ nnyɛ́n ɛna. ");
INSERT INTO kenNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ɛnɛ kɛ nchí ghati bhe bɛ mǎnkɔ́ŋ batɨ.” ");
INSERT INTO kenNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yesu arɔk ambɨ bɛrɛm bɛ, “Mbák bǒ mmɨk bápap bhe, dɨŋɨ́ ká bɛ báyambɨ bápap mɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Mbɔ bǎchí bǒ mmɨk, mbʉ́ mmɨk akɔŋ be nɛ ntí bɛ́ bǎchí bo bhi. Kɛ ndǔ njábhɛ́ bhe mfɛ́rɛ́ nɛ́ntɨ bǒ mmɨk, ɛ̌ti yɔ kɛ̌ bápábhɛ́ be. ");
INSERT INTO kenNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Bǎkɛ́ ghɔkɔntɨk ɛnyɨŋ ɛnɛ ngátí nyaka bhe bɛ ‘Mmǔ bɛtok apú cha chi-bɛtok aywi.’ Mbák bǒ mmɨk báchyɛ́ mɛ ɛsɔŋɔri, chɔŋ mánchyɛ be nkwɔ́ ɛsɔŋɔri. Mbɔ bábhʉ́rɛ́ ɛnyɨŋ ɛnɛ́ ngátí bhɔ, mbʉ́ chɔŋ mámbʉrɛ ɛnyɨŋ ɛnɛ́ be nkwɔ bǎghàti bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Báchyɛ̀ chɔŋ be bɛsɔŋɔri ɛbhɛn mɛnkɛm ɛ̌ti bǎkoŋo mɛ, mbɔnyunɛ bábhɨ́kɨ́ rɨŋɨ mmu anɛ átó mɛ fá amɨk. ");
INSERT INTO kenNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Mbɔ mbɨ́kɨ́ twɔ́ ngátí bhɔ mɛnyɨŋ, mbʉ bákwáy bɛtaŋa mmʉɛt bɛ bábhɨ́kɨ́ kʉ bɛbʉ́. Kɛ nɛ́nɛ, bápú kway bɛtaŋa bɛ babhɨkɨ kʉ bɛbʉ́. ");
INSERT INTO kenNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Mmu anɛ ápábhɛ́ mɛ, apap Ɛtaya nkwɔ́. ");
INSERT INTO kenNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mbɔ mbɨ́kɨ́ kʉ mɛnyɨŋɨ́ maknkay bɛsí bhap ɛbhɛ́n yɛ̌ mmu áchák ábhɨ́kɨ́ re kʉ, mbʉ́ bákway bɛtaŋa mmʉɛt bɛ bábhɨ́kɨ́ kʉ bɛbʉ́. Kɛ bághɔ mɛnyɨŋ ɛbhɛ́n nkʉ́, yɛ̌ nɔ bápàp mɛ, nɛ bápáp Ɛtaya. ");
INSERT INTO kenNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ɛchi ɛnyu ɛyɔ bɛ́ ɛnyɨŋ ɛnɛ Ɛkáti Mandɛm ɛ́ghàti bhɛsɛ ɛmfu tɛtɛp, nɔ chi bɛyɔŋ ɛbhɛn bɛ ‘Bápap mɛ ntí tí.’ ");
INSERT INTO kenNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Kɛ Nkwak anɛ mɛ̌tò chɔŋ ntá yɛka, ǎfù chi ntá Ɛtaya. Chɔŋ yi angati bhe mɛnyɨŋ ɛ̌ti ya mbɔ ntísiɛ awa. Yi chí Ɛfóŋó mmu ákʉ̀ bo mandɨŋɨ mɛnyɨŋ ɛbhɛn bɛchi tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Bě nkwɔ́ bǎchí batísiɛ́ bha mbɔnyunɛ bachí nɛ mɛ tɛ̌ndu nɛbhǒnɛt.” ");
INSERT INTO kenNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yesu arɔk ambɨ bɛrɛm bɛ, “Ngátí bhe mɛnyɨŋ ɛbhɛn bɛ́ bǎkɛ́ kwɛn ansɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Chɔŋ mámbok bhé ndǔ bɛkɛrɛ́ nɛnɨkɨ́mʉɛt ɛbhap. Mpok ǎtwɔ̀ anɛ yɛ̌ agha anɛ áwày bhe, akaysi bɛ́ ǎkʉ̀ chí ɛnyɨŋ ɛnɛ Mandɛm áyàŋ. ");
INSERT INTO kenNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Báchyɛ̀ chɔŋ be bɛsɔŋɔri ɛbhɛn, mbɔnyunɛ bábhɨ́kɨ́ rɨŋɨ Ɛtaya nɛ bábhɨ́kɨ́ rɨŋɨ mɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kɛ ngáti bhe mɛnyɨŋ ɛbhɛn bɛ́ mpok anaŋ ánkwáy anɛ bɔ bɛ́fàkari, mǎntɨk bɛ nnáŋ ngátí bhe. “Mbɨ́kɨ́ ghati bhe mɛnyɨŋ ɛbhɛn mpok bǎhó bɛkoŋo mɛ mbɔnyunɛ nchí nyaka nɛ bhe. ");
INSERT INTO kenNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Kɛ nɛ́nɛ nchí pɛtnsɛm ntá mmu anɛ átó mɛ, Yɛ̌ nɔ, yɛ̌ mmu ywɛka abhɨ́kɨ́ bhɛp mɛ bɛ, ‘Ɔ̌rɔ̀ŋ fá?’ ");
INSERT INTO kenNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Batɨ ayɛka ájwí nɛ́nɛ nɛ basɛ́mɛ́ mbɔnyunɛ ngátí bhe mɛnyɨŋ ɛbhɛn. ");
INSERT INTO kenNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Yɛ̌ ndu ɛchi nɔ, nchí ghati bhe ɛnyɨŋ ɛnɛ ɛchi tɛtɛp. Ɛ́rɨ ntá yɛka bɛ́ ndɔ́k mbɔnyunɛ mbák mbɨ́kɨ́ rɔŋ, Nkwak apú twɔ́ ntá yɛka. Kɛ mbák ndɔ́k, chɔŋ ntó yi ntá yɛka. ");
INSERT INTO kenNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nɛ ánáŋ ántwɔ́, chɔŋ ankʉ bǒ mmɨk mangɔ bɛ báchí bǒ bɛbʉ́, mángɔ bɛ mɛ nchí chak bɛsí Mandɛm, nɛ mangɔ bɛ bɛkwɛ́nɛ́ bɛchi nɛ bhɔ ndǔ nɛtaŋ anɛ bɔ bátàŋ mɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ǎkʉ bɔ mangɔ bɛ bachi bǒ bɛbʉ́ mbɔnyunɛ bábhɨ́kɨ́ noko mɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ǎkʉ bɔ mangɔ bɛ nchí chak bɛsí Mandɛm mbɔnyunɛ mɛ̌rɔ̀ŋ ntá Ɛtaya nɛ bǎpú pɛrɛ ghɔ́ chɔ́ŋ mɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ǎkʉ mángɔ́ bɛ chɔŋ mántáŋ bǒ bɛbʉ́ ɛwak ɛ́mɔt, tɛ̌ndu Mandɛm átáŋ mfɔ mmɨk, afɛrɛ yi ndǔ kɛfɔ ɛki. ");
INSERT INTO kenNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Mbɔ̌ŋ bɛyǎ mɛnyɨŋ bɛghati bhe, kɛ mbák ngátí bhe bɔ mɛnkɛm nɛ́nɛ, bǎpú kway bɛ́jwimɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ɛfóŋó Bɛdyɛrɛ kɛ ákʉ̀ chɔŋ bo mándɨŋɨ tɛtɛp nkɛm anɛ áyɨ́ŋɨ́ Mandɛm. Anaŋ ántwɔ́ chɔŋ ankʉ mǎndɨŋɨ tɛtɛp nkɛm, mbɔnyunɛ ápú rɛm chi ɛnyɨŋ ɛnɛ ɛ́fú yi antɨ. Ɛnɛ́ yi aghoko kɛ árɛ̀m, nɛ chɔŋ angati bhe mɛnyɨŋ ɛbhɛn bɛ́twɔ̀ ambɨ. ");
INSERT INTO kenNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Chɔŋ anchyɛ mɛ kɛnókó mbɔnyunɛ ǎsɔ̀t chɔŋ mɛnyɨŋ ɛbhɛn bɛ́fú ntá ya, angati bhe. ");
INSERT INTO kenNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Yɛ̌ntɨkɨ ɛnyɨŋ Ɛtaya chi ɛya nkwɔ. Nɔ́ kɛ ngátí bhe bɛ́ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ Ɛfóŋó Bɛdyɛrɛ ághàti chɔŋ bhe, ǎsɔt chi ntá ya.” ");
INSERT INTO kenNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yesu arɔk ambɨ bɛghati baghɔkɔ́ bhi bɛ, “Mandu mpok, bǎpú pɛrɛ ghɔ mɛ. Kɛ mandú mpok, chɔŋ mǎmpɛt mǎngɔ mɛ.” ");
INSERT INTO kenNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Mbɔk baghɔkɔ́ bhi báré rɛm nɛ batɨ bɛ, “Ɛnɛ́ yí árɛ̀m nɔ chí yí. Yí bhɛ mandú mpok, sɛ́pú pɛrɛ ghɔ́ yí, nɛ mandú mpok chɔŋ sɛ́mpɛt sɛ́ngɔ́ yi. Apɛt arɛm bɛ chi mbɔnyunɛ yí ǎrɔŋ ntá ɛtayi. Nɔ́ bɛ́ yí?” ");
INSERT INTO kenNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Bápɛt báré rɛm nɛ batɨ bɛ, “Yi bɛ́ ‘Mandu mpok’, mandú mpok, nɔ bɛ́ yi?” Sɛ́bhɨ́kɨ́ jwimɛm ndǔ ɛnyɨŋ ɛnɛ yi árɛ́mɛ́. ");
INSERT INTO kenNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu arɨŋɨ bɛ baghɔkɔ́ bhi báyàŋ bɛbhɛp yi ɛnyɨŋ ɛ̌ti ndak anɛ. Arɛm yɛ bɛ, “Ngátí bhe bɛ mandú mpok, bǎpú pɛrɛ ghɔ́ mɛ, kɛ mandú mpok chɔŋ mǎmpɛt mǎngɔ́ mɛ. Yɔ́ kɛ ɛ́sɔŋɔri nɛ́ bhe? ");
INSERT INTO kenNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Tɛtɛ̌tɛp, chɔŋ mǎndi babhɛsɛ ansɛp nɔkɔ amɨ́k nɛ mámbɔŋ basɛ́mɛ́, kɛ bǒ mmɨk mámbɔŋ maŋák. Chɔŋ mǎmbɔ́ŋ basɛ́mɛ́ kɛ basɛ́mɛ́ amɛka anjibhiri andɔp chí maŋák. ");
INSERT INTO kenNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mpok ngɔrɛ́ nɛ mɛniɛ ánòŋsi, ǎbhɔ́ŋ basɛ́mɛ́ antɨ mbɔnyunɛ mpok nɛbhe akway. Kɛ ánáŋ ámbé, maŋák ǎbhák nɛ yi bɛ mɔ́nkɔ átwɔ́ fá amɨk. Ɛ́nkʉ angɔkɔntɨk bɛbě nɛbhe. ");
INSERT INTO kenNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nɔ́, kɛ ɛ́chi nɛ be nkwɔ́. Nɛ́nɛ basɛ́mɛ́ ajwí be antɨ, kɛ chɔŋ mpɛt ngɔ́ bhe, nɛ mpok yɔ chɔŋ mǎmbɔ́ŋ bɛyǎ maŋák, nɛ yɛ̌ mmú apu kway bɛfɛrɛ mɔ́ amɛm batɨ ayɛka. ");
INSERT INTO kenNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ndǔ nywɔp ɛnɔ, bapú pɛrɛ bhɛ́p mɛ yɛ̌nyɨŋ. Tɛtɛ̌tɛp, mbák mǎmbɛp Ɛtaya yɛ̌ntɨkɨ ɛnyɨŋ ndǔ nnyɛ́n ɛna, ǎchyɛ bhe. ");
INSERT INTO kenNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kpátɛ̌ ɛchɔŋ, bǎbhɨkɨ re bhɛ́p Ɛtaya yɛ̌nyɨŋ ndǔ nnyɛ́n ɛna. Bɛ́p ká, nɛ chɔŋ anchyɛ be bɛ maŋák amɛka anjwi pɔɔt.” ");
INSERT INTO kenNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yesu arɔk ambɨ bɛrɛm bɛ, “Mpok anɛ nkɛm, ngátí bhe barak anɛ chí ndǔ bakay. Kɛ mpok ǎtwɔ̀ anɛ mpú pɛrɛ ghati be mɛnyɨŋ ndǔ bakay. Mpok yɔ ánkwáy, ndɔbhɛ ghati bhe mɛnyɨŋ ɛ̌ti Ɛtaya chi kpoŋoroŋ. ");
INSERT INTO kenNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Mpok yɔ, chɔŋ mǎmbɛp Ɛtaya mɛnyɨŋ ndǔ nnyɛ́n ɛna. Mbɨ́kɨ́ rɛm bɛ chɔŋ nɨkmʉɛt ntá yi bɛ ánchyɛ́ bhe ɛnyɨŋ. ");
INSERT INTO kenNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Mbɔŋ Ɛta akɔŋ be mbɔnyunɛ bǎkɔŋ mɛ, nɛ mǎnókó bɛ mfu chí ntá yi. ");
INSERT INTO kenNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mfú chí ntá Ɛta kɛ nchí twɔ fá amɨk. Nɛ́nɛ, nchí rɔ mmɨk, nchí pɛtnsɛm ntá Ɛta.” ");
INSERT INTO kenNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Baghɔk abhi barɛm yɛ ntá yi bɛ, “Mhm! Nɛ́nɛ ɔ̌rɛ̀m mɛnyɨŋ kpoŋoroŋ nɛ sɛ́jwimɛm. Ɔpú pɛrɛ rɛm kɛpɨ ndǔ bakay!” ");
INSERT INTO kenNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nɛ́nɛ, sɛ́rɨ́ŋɨ́ bɛ, ɔrɨ́ŋɨ́ yɛ̌ntɨkɨ ɛnyɨŋ. Ɔrɨ́ŋɨ́ yɛ̌ chi mɛnyɨŋ ɛbhɛn bo bábhɔ́ŋɔ́ antɨ bɛbhɛp wɔ. Ɛnɛ ɛ́kʉ sɛ́nókó bɛ́ ɔfu chí ntá Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu akɛmɛ bhɔ bɛ, “Mǎnókó nɛ́nɛ? ");
INSERT INTO kenNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Mpok ǎtwɔ̀, tɛtɛp anáŋ atwɔ, anɛ bǎtaka chɔŋ yɛ̌ntɨkɨ mmu andɔk ɛyi ɛbhak mǎndɔ mɛ awánti. Kɛ sayri sayri, mpú mɛ awánti mbɔnyunɛ, Ɛta achi nɛ mɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ngátí bhe mɛnyɨŋ ɛbhɛn bɛ mǎmbát mmʉɛt nɛ mɛ mǎmbɔ́ŋ kpák amɛm batɨ ayɛka. Chɔŋ mǎmbɔŋ bɛsɔŋɔri fá amɨk, kɛ bɔ́ŋ ká nɛtaŋántɨ́, nnáŋ mfɔ́kɔ́rí mmɨk.” ");
INSERT INTO kenNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu ánáŋá nɔ́kɔ́ bɛrɛm mɛnyɨŋ ɛbhɛn, ayoŋ amɨ́k ayɨŋɨ mfay, arɛm bɛ, “Ɛta, mpok akway. Chiɛ́ Mɔ́ywɛ kɛnɛ́m bɛ ɛ̌ti ya bo mángɔ́ kɛnɛ́m ɛkɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Wɔ kɛ ɔ́chyɛ́ mɛ́ bɛtaŋ amfay bǒ mankɛm bɛ́ nkʉ mankɛm abhɛn ɔ́chɛ́ mɛ mambɔŋ nɛpɛ́m ɛnɛn nɛbhɨkɨ bhɔŋ ngwɛnti. ");
INSERT INTO kenNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nɛ nɛpɛ́m ɛnɛn nɛbhɨkɨ bhɔŋ ngwɛnti, chí bɛ́rɨ́ŋɨ́ wɔ, wɔ mmu ɔ́chí Mandɛm tɛtɛp nɛ achák apu nɛ bɛrɨŋɨ Yesu Kristo mmu ɔ́tó. ");
INSERT INTO kenNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nkʉ bo mángɔ́ kɛnɛ́m ɛkɛ ndu nnáŋá bɛtɨk ɛbhɛn ɔ́chyɛ́ mɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ɛta, nɛ́nɛ sɔt mɛ mbak nɛ wɔ, ɔ́nchyɛ mɛ kɛnɛ́m bɛsí ɛbhɛ, nkúbhɛ́ kɛnɛ́m ɛkɛn mbɔ́ŋɔ́ nyaka nɛ wɔ kɛ ɔ̌ghoko mmɨk. ");
INSERT INTO kenNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nkʉ bo mándɨ́ŋɔ́ wɔ, bo abhɛn ɔ́yábhɛ́ fá amɨk ɔ́chyɛ́ mɛ. Báchí bǒ bhɛ, nɛ wɔ kɛ ɔ́chyɛ́ mɛ bhɔ. Bábhʉ́rɛ́ ɛyɔŋ ɛyɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nɛ́nɛ bárɨŋɨ bɛ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ mbɔ́ŋɔ́, ɛ́fú chí ntá yɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ngátí bhɔ mɛnyɨŋ ɛbhɛn ɔ́chyɛ́ mɛ bɛ ngati bhɔ. Báká nɛ mɛ, nɛ bárɨŋɨ yɛ tɛtɛp bɛ mfu chí ntá yɛ. Mánoko nkwɔ bɛ wɔ kɛ ɔ́tó mɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nchí nɨkmʉɛt ɛ̌ti yap. Mpú nɨkmʉɛt ɛ̌ti mmɨk nkɛm. Nchí nɨkmʉɛt chi ɛ̌ti bo abhɛn ɔ́chyɛ́ mɛ mbɔnyunɛ bɔ́ báchí bǒ bhɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Bǒbha mankɛm chí abhɛ, nɛ abhɛ chí abha. Nɛ bɔ́ kɛ̌ nɛpɛ́m ɛnap nɛ́kù bo mángɔ́ kɛnókó ɛka. ");
INSERT INTO kenNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nɛ́nɛ, mpɛt mpú fá amɨk, kɛ bɔ́ bábhʉɛ́t arɛ. Nchí twɔ ntá yɛ. Ɛta! Wɔmbɔŋ mmú ɔ́chí Nyáŋá, kɛ́m bɔ̌ nɛ bɛtaŋ ɛbhɛ, bɛtaŋ ɛbhɛ́n ɔ́chyɛ́ mɛ bɛ mambak mbɔ mmu amɔt, nkúbhɛ́ mbɔ ɛnyǔ wɔ nɛ mɛ sɛchi mmu amɔt. ");
INSERT INTO kenNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Mpok nchí nɛ bhɔ, nkɛ́m bɔ sayri nɛ bɛtaŋ ɛbhɛn bɛ́chí ndǔ nnyɛ́n ɛna, nnyɛ́n ɛnɛn ɔ́chyɛ́ mɛ. Nkɛm bɔ́, nɛ yɛ̌ mmu wap amɔt abhɨkɨ nɛm ɛbhɨ, ɛ́bhɨ́kɨ́ fʉɛt chí anɛ ábhɔ́ŋɔ́ nyaka mɛ́nɛm, bɛ́ ɛnyɨŋ ɛnɛ básɨ́ŋɨ́ ɛ́mfú tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Nɛ́nɛ, nchí twɔ ntá yɛ, nɛ nchí rɛm mɛnyɨŋ ɛbhɛn ndǔ mpok mbʉɛ́t fá amɨk, bɛ́ maŋák ama ámbák nɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ngátí bhɔ mɛnyɨŋ ɛbhɛn ɔ́chyɛ́ mɛ ngati bhɔ. Ɛ̌ti yɔ, mmɨk apap bhɔ mbɔnyunɛ bápú bǒ mmɨk anɛ, nkúbhɛ́ mbɔ ɛnyǔ mpú mmǔ mmɨk. ");
INSERT INTO kenNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mpú nɨkmʉɛt bɛ́ ɔ́mfɛ́rɛ́ bhɔ fá amɨk, kɛ chí bɛ́ ɔ́nkɛ́m bɔ́ bɛ mbʉ́mbʉ ákɛ́ kʉ bhɔ yɛ̌nyɨŋ. ");
INSERT INTO kenNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Bápú bǒ mmɨk nkúbhɛ́ mbɔ ɛnyǔ mpú mmǔ mmɨk. ");
INSERT INTO kenNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Sɔt tɛtɛp kʉ bɔ́ mámbák nyáŋá. Ɛyɔŋ ɛyɛ ɛchi tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nkúbhɛ́ mbɔ ɛnyǔ ɔ́tó mɛ fá amɨk, nɔ́ kɛ̌ nchí to bhɔ amɨk. ");
INSERT INTO kenNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nɛ ɛ̌ti yap, nchyɛ́ mmʉɛt ntá yɛ bɛbhak nyáŋá bɛ́ bɔ́ nkwɔ́ mankway bɛbhak nyáŋá tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Mpú nɨkmʉɛt chi ɛ̌ti bakoŋo abhɛn bɔ́bhɔ, kɛ ɛ̌ti bo abhɛn bághòk mɛnyɨŋ ɛbhɛn bɔ bátɔ̀ŋ, mánsɨkɨntɨ nɛ mɛ nkwɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nchí nɨkmʉɛt bɛ́ bɔ́ mankɛm mámbák mbɔ mmu amɔt. Ɛtaya, mɛ̌nɨ̀kmʉɛt bɛ nkúbhɛ́ mbɔ ɛnyǔ ɔ́bhárɛ́ mmʉɛt nɛ mɛ nɛ mbát mmʉɛt nɛ wɔ, bɔ́ nkwɔ mámbát mmʉɛt nɛ bhɛsɛ bɛ́ mmɨk ánkwáy mɛ́nóko bɛ wɔ kɛ ɔ́tó mɛ tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nchyɛ́ bhɔ́ nkúbhɛ́ bɛtaŋ ɛbhɛn ɔ́chyɛ́ mɛ, bɛ́ bɔ́ mámbák mmu amɔt, nkúbhɛ́ mbɔ ɛnyǔ wɔ nɛ mɛ sɛchi. ");
INSERT INTO kenNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Chɔŋ mbak nɛ bhɔ nkúbhɛ́ mbɔ ɛnyǔ ɔ́chí nɛ mɛ, bɛ sayri sayri, mándɔp chi mmu amɔt, bɛ́ mmɨk ankway bɛrɨŋɨ bɛ wɔ kɛ ɔ́tó mɛ, nɛ bɛ́ ɔkɔŋ bɔ́ mbɔnyu ɔ́kɔ́ŋ mɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ɛta, mɛ̌yáŋ bɛ bɔ́ nkwɔ, bǒ ɔ́chyɛ́ mɛ mámbák nɛ mɛ ndǔ nɛbhʉɛt anɛ mɛnchí, bɛ́ mángɔ́ kɛnókó ɛkɛn ɔ́chyɛ́ mɛ mbɔnyunɛ ɔkɔŋ mɛ tɛ mpok ɔ́bhɨ́kɨ́ re ghoko mmɨk. ");
INSERT INTO kenNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ɛta, wɔ mmu ɔ́chí chak, bǒ mmɨk bábhɨ́kɨ́ rɨŋɨ wɔ, kɛ ndɨ́ŋɨ́ wɔ, nɛ nkwɔ wa anɛ bárɨŋɨ bɛ́ wɔ kɛ ɔ́tó mɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nkʉ bɔ́ mándɨ́ŋɨ́ wɔ́, nɛ chɔŋ ndɔk ambɨ bɛkʉ nɔ, bɛ bɔ mankɔŋ batɨ nkúbhɛ́ mbɔnyu ɔ́kɔ́ŋ mɛ, nɛ bɛ mɛ́mbák amɛm batɨ ayap.” ");
INSERT INTO kenNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu ánáŋá nɔ́kɔ́ mɛnɨkmʉɛt ɛnyu ɛyɔ, afa nɛ baghɔkɔ́ bhi, bákɨŋɨ mɔ́nyɛn anɛ bábhɨ̀ŋɨ bɛ Kídrɔn. Mɔ́nkɨ áchí nyaka arɛ anɛ yí achwe amɛm nɛ baghɔkɔ́ bhi. ");
INSERT INTO kenNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Júdas mmu átí yi arɨŋɨ nkwɔ ɛbhak ɛyɔ mbɔnyunɛ Yesu nɛ baghɔkɔ́ bhi bátɛmɛri nɔkɔ nyaka arɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Júdas asɔt ɛká batɛmɛ́ nɛnu nɛ mbɔk babhabhɛri abhɛn ɛkɛrákap abhɛn bǒbati bachiǎkap nɛ bǒnkwɔ Fárisi bátó. Bɔ́ mankɛm barɔk arɛ nɛ bɛrɔ́ŋɔ́ nɛ mɛnyɨŋɨ́ nɛnu amɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu arɨŋɨ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ́ ɛ́bhɔ́ŋɔ́ bɛ́fákári nɛ yí. Afú ndǔ nkwɔ́ baghɔkɔ́ bhi, atɛ́n mmʉɛt ambɨ arɛm bɛ, “Agha bǎyáŋ?” ");
INSERT INTO kenNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Bákɛ́mɛ yi bɛ, “Yesu mmu Násárɛt.” Yesu arɛm bɛ, “Ghɔ́ mɛ́ nɛ.” Júdas mmu atí yi abhak arɛ́ téé nɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Mpok Yesu aghati bhɔ bɛ, “Ghɔ́ mɛ́ nɛ”, bárɔ́k nɛ nsɛm nɛ nsɛm bákwɛ́nti amɨk. ");
INSERT INTO kenNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesu apɛt abhɛ́p bhɔ bɛ, “Aghǎ bǎyàŋ?” Bárɛ́m bɛ, “Yesu mmu Násárɛt.” ");
INSERT INTO kenNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu akɛmɛ bhɔ bɛ, “Ngátí bhe bɛ chi mɛ. Mbák yɛ mɛ kɛ bǎyàŋ, dɔ̌ ká bakoŋo bha abhɛn mandɔk.” ");
INSERT INTO kenNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Arɛm nɔ, bɛ́ ɛnyɨŋ ɛnɛ yi árɛ́mɛ́ nyaka bɛ, “Ndu bo abhɛn ɔ́chyɛ́ mɛ mbɨ́kɨ́ nɛm yɛ amɔt,” ɛmfu tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Símun Píta mmu achi nɛ akparɛnja amʉɛt, agwɔp akparɛnja wu ndǔ kɛ́nkwɔ́p, kpɔ́t atú nsɛm Mǔngo bachiǎkap Mandɛm chwát agʉɛp amɨk. Nnyɛ́n nsɛm ɛrɛ nɛ́bhak bɛ Málkɔs. ");
INSERT INTO kenNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu aghati Píta bɛ, “Kɛmɛ́ akparɛnja ywɛ amɛm kɛ́nkwɔ́p. Nkɛ́ nyu nkɔ́p ɛsɔŋɔri anɛ Ɛta áchyɛ́ bɛ mɛ nyu kɛ?” ");
INSERT INTO kenNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Mǔnti batɛmɛ́ nɛnu asɔt ɛká batɛmɛ́ nɛnu ɛyi, bárɔ́k, bákɛ́m Yesu bágwɔ́t. Babhabhɛrǐ ɛkɛrákap Mandɛm bábhák nɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Báyámbɨ bárɔ́k ntá Ánas, chi ngɔrɛ́ Káyfas. Káyfas abhak mǔngo bachiǎkap Mandɛm ndu mmiɛ ɛnɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Yi kɛ áchyɛ́ nyaka maníɛ́ ntá bo Israɛl bɛ, “Ɛ́rɨ bɛ mmu amɔt ángú ɛ̌ti bo mankɛm.” ");
INSERT INTO kenNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Símun Píta nɛ nkoŋo Yesu achák báré koŋo Yesu. Ndǔ nkoŋo Yesu achák wu achí mmǔ anɛ mǔngo bachiǎkap árɨŋɨ sayri, yí akoŋo Yesu kpát arɔk achwe amɛm sɛnta mǔngo bachiǎkap. ");
INSERT INTO kenNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Píta ate nɛfí ndǔ nyǔ-ɛbhá. Ɛ́kʉ́ nkoŋo achák wu, anɛ mǔngo bachiǎkap árɨ́ŋɨ́ apɛtnsɛm nɛfí, arɛm kɛpɨ nɛ ngɔsɔ́ŋ anɛ áchí anyǔbhá. Asɔt yɛ Píta áchwé amɛm nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ngɔsɔ́ŋ wu nɔ ábhàbhɛri nyǔ-ɛbhá abhɛ́p Píta bɛ, “Pú wɔ nkwɔ ɔchí nkoŋo mmǔ-nɛ?” Píta akɛmɛ bɛ, “Mpú nɛ yi.” ");
INSERT INTO kenNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Mbʉ́ɛ́p áchí nyaka mpok yɔ. Ɛ́kʉ́ bakʉ̌ bɛtɨk abhɛn mǔngo bachiǎkap nɛ babhabhɛrǐ ɛkɛrákap báfyɛ́ ngo ndu nntó bakiri, báté bághábhɛri mángwák nɔkɔ ngó wu. Píta nkwɔ arɔk ate nɛ bhɔ angwaka nɔkɔ ngo. ");
INSERT INTO kenNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mǔngo bachiǎkap abhɛ́p Yesu ɛ̌ti bakoŋo bhi nɛ ɛ̌ti mɛnyɨŋ ɛbhɛn yi átɔ̀ŋ bho. ");
INSERT INTO kenNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu akɛmɛ yi bɛ, “Ndɛm mɛnyɨŋ kpoŋoroŋ ntá bo mankɛm. Ntɔ́ŋ bo amɛm bɛkɛrɛ́ nɛnɨkɨ́mʉɛt nɛ amɛm ɛkɛrákap mpoknkɛm ndǔ mbaŋ ɛnɛ bo Israɛl báchɛ̀m arɛ. Mbɨ́kɨ́ rɛm yɛ̌nyɨŋ bhɛ́sɛ́ bhɛ́sɛ́.” ");
INSERT INTO kenNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ndak yí ɔ́bhɛ́p mɛ mɛnyɨŋ? Bɛ́p bo abhɛn bághókó mɛnyɨŋ ɛbhɛn ndɛ́mɛ́. Bɛ́p bɔ́ mángátí wɔ. Bárɨŋɨ mɛnyɨŋ ɛbhɛn ndɛ́mɛ́. ");
INSERT INTO kenNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu árɛ́mɛ́ nɔ́kɔ́ nɔ, mbabhɛri ɛkɛrákap amɔt anɛ áchí arɛ́ téé, adɛp Yesu nɛ awɔ́ arɛm bɛ, “Kwáé, ɛnyu ɛyɔ kɛ ɔ́rɛ̀m kɛpɨ ntá mǔngo bachiǎkap Mandɛm-ɛ?” ");
INSERT INTO kenNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu akɛmɛ yi bɛ, “Mbák ndɛm ɛnyɨŋ ɛnɛ́ ɛ́pú chak, ghatí mɛ yɔ. Kɛ mbák ndɛm ɛnyɨŋ ɛnɛ ɛchi chak, ɔdɛp mɛ ndáká yí?” ");
INSERT INTO kenNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Afɔ̌ kɛ Ánas átó Yesu nɛ ngɛm amɔ ntá Káyfas, mǔngo bachiǎkap. ");
INSERT INTO kenNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Símun Píta abhʉɛ́t nyaka téé, angwaka nɔkɔ ngo. Mbɔk bo abhɛn bachi arɛ bábhɛ́p yi bɛ, “Pú wɔ nkwɔ́ ɔchí nkoŋo ywi?” Píta ataŋa, arɛm bɛ, “Cháá, mpú nɛ yi” ");
INSERT INTO kenNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mmɔ̌ bɛtok amɔt anɛ mǔngo bachiǎkap abhak arɛ́. Atú mɔ́mayi kɛ̌ Píta ákpɔ́rɛ́ nyaka. Yí wu abhɛ́p Píta bɛ, “Pú ngɔ̌ nyaka wɔ amɛm mɔ́nkɨ nɛ yi?” ");
INSERT INTO kenNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Píta apɛt ataŋa. Tɛ́mté wu, nnɛ́m nkɔk akók kɔkɔrɔ́kɔ̌ɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Básɔ́t yɛ Yesu ɛkɛt Káyfas betí beti bárɔk ndǔ sɛnta gɔ́bhanɔ nɛ yi. Gɔ́bhanɔ abhak mmǔ Rom. Babhɔŋɔ́ bo Israɛl kɛchwe ndu áchá gɔ́bhanɔ. Ɛbhé yap ɛ́rɛ̀m nyaka bɛ́ mbák mmu Israɛl ánchwé ɛkɛt mmu anɛ ápú mmu Israɛl, apú bhák pɛ́pɛ́p bɛsí Mandɛm. Ndu báyàŋ nyaka mɛnyiɛ Ɛpǎ Nɛkɨŋɨ, bɔ́ kɛyaŋ bɛ́bhak nɛ bakwap bɛsí Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ɛ́kʉ́ Páílet afú amɛm sɛnta ywi arɔk atɛmɛri bhɔ nɛfí, abhɛ́p bhɔ bɛ, “Ntɨkɨ ɛnyɨŋ mmǔ-nɛ akʉ́?” ");
INSERT INTO kenNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Bákɛ́mɛ yi bɛ, “Mbɔ mmǔ nɛ apú nkʉ bɛbʉ́, mbʉ́ sɛ́bhɨ́kɨ́ twɔ fá ntá yɛ nɛ yi.” ");
INSERT INTO kenNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Páílet aghati bhɔ bɛ, “Sɔt ka yi bɛ bě babhɔŋ mǎntáŋ manyé yi bɛ́kóŋo ɛbhé ɛyɛka.” Bákɛ́mɛ Páílet bɛ, “Ɛbhé ɛ́bhɨ́kɨ́ chyɛ bhɛsɛ bɛtaŋ bɛ́táŋ manyé mmu, kpát sɛ́nchyɛ ɛyɔŋ bɛ mangway yi.” ");
INSERT INTO kenNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ɛ́fákári ɛnyu ɛyɔ bɛ ɛnyɨŋ ɛnɛ Yesu árɛ́mɛ́ nyaka ndu bɛtɔŋ ɛnyǔ nɛwú yi ábhɔ́ŋɔ́ bɛ́gu ɛmfu tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Páílet apɛt achwe amɛm áchá ywi. Abhɨŋɨ Yesu abhɛp yi bɛ, “Wɔ kɛ ɔ́chí Mfɔ bo Israɛl?” ");
INSERT INTO kenNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu akɛmɛ yí bɛ, “Ndak anɛ́ ɔ́bhɛ́bhɛ́ mɛ, áfu chi wɔmbɔ̌ŋ antɨ kɛ bo báchák kɛ̌ bágháti wɔ wu ɛ̌ti ya?” ");
INSERT INTO kenNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Páílet akɛmɛ bɛ, “Ɔkáysí bɛ nchí mmu Israɛl? Bǒ ɛtɔk ɛyɛ nɛ bǒbati bachiǎkap Mandɛm kɛ bákɛ́m wɔ batwɔ ntá ya nɛ wɔ. Mbɔ̌ŋ ɛnyɨŋ ɛnɛ ɔ́kʉ́ chi yi?” ");
INSERT INTO kenNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu akɛmɛ yi bɛ, “Kɛfɔ ɛka kɛ́bhɨ́kɨ́ fu fá amɨk. Mbɔ kɛfɔ ɛka kɛ́fu chi fá amɨk, mbʉ bǒbha mánú bɛ bákɛ́ kɛm mɛ manchyɛ ntá bo Israɛl. Kɛ, kɛfɔ ɛka kɛbhɨkɨ fu ndǔ mmɨkɨ nɛ.” ");
INSERT INTO kenNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Páílet abhɛp yi bɛ, “Nɔ ɔchí mfɔ?” Yesu akɛmɛ yi bɛ, “Ɔrɛm bɛ mɛnchí mfɔ. Ɛ̌ti ɛyɔ kɛ bábhé mɛ, nɛ ɛ̌ti yɔ kɛ ntwɔ fá amɨk bɛghati bho tɛtɛp Mandɛm. Yɛ̌ntɨkɨ mmǔ anɛ ákòŋo tɛtɛp Mandɛm, ǎta batú bɛ́ghok ɛnyɨŋ ɛnɛ mɛ̌rɛ̀m.” ");
INSERT INTO kenNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Páílet abhɛ́p Yesu bɛ, “Tɛtɛp chí yí?” Páílet árɛ́m nɔ́kɔ́ nɔ, arɔ Yesu apɛt afú nɛfí ntá bo Israɛl aghati bhɔ bɛ, “Mbɨ́kɨ́ ghɔ ɛbɛ́ptí ɛnyɨŋ ɛnɛ yi akʉ. ");
INSERT INTO kenNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kɛ ɛpɨŋ ɛyɛka ɛ́tɔ̀ŋ bɛ́ yɛ̌ntɨkɨ mmíɛ́, mpok Ɛpǎ Nɛkɨŋɨ, mbɔŋ bɛrɔ mǔkɛnɔŋ amɔt anɛ bǎyàŋ mandɔ yi andɔk. Bǎyaŋ mámfɛ́rɛ́ Mfɔ bo Israɛl amɔ, yí ándɔ́kɔ́?” ");
INSERT INTO kenNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Bápɛ́t babɨk bɛ, “Puyɛ̌ mmǔ-nɛ, fɛrɛ́ chí Barábas. Barábas achí nyaka ngɛ́bhɛ́ ntantaŋ.” ");
INSERT INTO kenNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Páílet achyɛ yɛ ɛyɔŋ bɛ mánsɔ́t Yesu mandɛn nɛ ɛ́kpá. ");
INSERT INTO kenNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Batɛmɛ́ nɛnu básɔ́t bɔ̌batábhɛ́nɔk abhɛn báchí nsěnse, mánɨ́ ntá bábáy yi anti, barɛm bɛ chi nta kɛfɔ. Básɔ́t nkú chu bafyɛ́ yi amʉɛt, bárɛm bɛ chí ayi nkú kɛfɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bábhó bɛrɔŋ ntá yi máŋɔkɔ nɔkɔ yi bɛ, “Acha mfɔ bo Israɛl, kɛnókó kɛ́chí ɛkɛ ɛta!” Ndu bárɛ̀m nɔ, manchyɛ nɔkɔ yi nsáp bɛsí. ");
INSERT INTO kenNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Páílet apɛt arɔ áchá ywi afú nɛfí ntá bo Israɛl arɛm bɛ, “Ghok ka, nchí ntwɔ́ nɛfí nɛ yi ntá yɛka bɛ mǎndɨŋɨ bɛ́ mbɨ́kɨ́ ghɔ ɛbɛ́ptí ɛnyɨŋ ɛnɛ yi ákʉ́ ɛnɛ́ ɛ́yàŋ bɛ mángwáy yi.” ");
INSERT INTO kenNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yesu afú yɛ, arɔk nɛ ntá kɛfɔ nsěnse yɔ antí, nɛ nkú chú yɔ amʉɛt. Páílet arɛm ntá yap bɛ, “Yɨ́ŋɨ́ mmǔ ywɛka nɔ!” ");
INSERT INTO kenNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Bǒbati bachiǎkap nɛ babhahɛrǐ ɛkɛrákap bághɔ́ nɔ́kɔ́ yí, bábho bɛbɨk mándɛmɛ nɔkɔ bɛ, “Dɛm mángó yi ndǔ ɛkotákátí! Mángó yi ndǔ ɛkotákátí!” Páílet arɛm ntá yap bɛ, “Bě babhɔŋ mǎnsɔt yi mǎngó ndǔ ɛkotákátí, mbɨ́kɨ́ ghɔ ɛbɛ́ptí ɛnyɨŋ ɛnɛ yi ákʉ́ ɛnɛ ɛ́yàŋ mángwáy yi.” ");
INSERT INTO kenNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Bo Israɛl, bákɛ́mɛ yi bɛ, “Sɛ́bhɔ̌ŋ ɛbhé, nɛ bɛkoŋo ɛbhé yɔ, abhɔŋ bɛ́gu mbɔnyunɛ ákʉ́ mmʉɛt yi Mmɔ Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Páílet ághókó nɔ́kɔ́ bɛyɔŋ ɛbhɛn, bɛcháy bɛ́pɛ́t bɛkɛm yi bɛcha. ");
INSERT INTO kenNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Apɛt achwe amɛm áchá abhɛp Yesu bɛ, “Ɛtɔk ɛnɛ ɔ́fú arɛ chi ɛnɛ́?” Kɛ Yesu abhɨkɨ kɛmɛ yɛ ɛyɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Páílet arɛm yɛ ntá yi bɛ, “Ɔpú kɛmɛ mɛ yɛ̌ ɛyɔŋ? Ɔbhɨ́kɨ́ rɨŋɨ bɛ mbɔ̌ŋ bɛtaŋ bɛrɛm bɛ mándɔ́ wɔ mándɔ, nɛ mbák ndɛ́m bɛ mángó wɔ́ ndǔ ɛkotákátí, bágò?” ");
INSERT INTO kenNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu akɛmɛ yi bɛ, “Mandɛm kɛ áchyɛ́ wɔ bɛtaŋ. Mbɔ ɛ́pú nɔ́, mbʉ ɔbhɔ̌ŋ bɛtaŋ amfay ya fá? Nɔ kɛ ɛchi bɛ bɛbʉ́ mmu anɛ ákɛ́mɛ́ mɛ́ áchyɛ́ ntá yɛ, bɛ́chá ɛbhɛ.” ");
INSERT INTO kenNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Páílet ághókó nɔkɔ nɔ, abho bɛyaŋ mbi bɛfɛrɛ Yesu amɔ. Kɛ bo Israɛl bárɔ́k chí ambɨ bɛbɨk bɛ, “Mbák ɔ́ndɔ́ mmǔ-nɛ ándɔ́k, nɔ́ ɔpú mmʉɛ́rɛ Mfɔ Rom! Mmu anɛ ǎrɛ̀m bɛ áchí Mfɔ, chi mmǔ anɛ ánù nɛ Mfɔ Rom bɛ ambak ndǔ mmʉɛt ɛyi!” ");
INSERT INTO kenNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Páílet ághókó nɔ́kɔ́ bɛyɔŋ ɛbhɛn, asɔt Yesu afú nɛ yi, achɔkɔ ndǔ ɛnɔk ntaŋá manyé, nɛbhʉɛt anɛ bábhɨ̀ŋɨ ndu ɛyɔŋ bo Israɛl bɛ́ Gabáta. Nɔ́ chi, nɛbhʉɛt batǎy batay. ");
INSERT INTO kenNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ɛ́gháká nɔ́kɔ́ nkárɛ́nká byo nɛ ɛpay ndǔ nywɔp ɛnɛn bátòŋti mmʉɛt mɛnyiɛ Ɛpǎ Nɛkɨŋɨ, Páílet arɛm ntá bo Israɛl bɛ, “Yɨŋɨ́ ka Mfɔ ywɛka nɛ!” ");
INSERT INTO kenNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Bábhó bɛbɨk mándɛmɛ nɔkɔ bɛ, “Dɔ̌ mángwáy yi! Dɔ̌ mǎngwáy! Dɛm mángó yi ndǔ ɛkotákátí!” Páílet arɛm bɛ, “Ngó Mfɔ ywɛka ndǔ ɛkotákátí?” Bǒbati bachiǎkap bákɛ́mɛ bɛ, “Mfɔ amɔt kɛ sɛ́bhɔ́ŋɔ́, nɛ chí Sísa.” ");
INSERT INTO kenNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Páílet ásɔ́t yɛ Yesu achyɛ ntá yap bɛ mándɔk mángó yi ndǔ ɛkotákátí. ");
INSERT INTO kenNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Básɔ́t ɛkotákátí ɛnɛ́ bábhɔ́ŋɔ́ bɛgo Yesu arɛ báchyɛ́ yímbɔŋ ámpɔ́kɔ́. Apɔkɔ kpát bárɔ́k bágháká ndǔ ɛbhak ɛnɛ́ bábhɨ̀ŋɨ bɛ́ Golgóta, nɔ́ chi “Nɛbhʉɛt Ɛnkɔ́nti.” ");
INSERT INTO kenNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Arɛ́, bágó Yesu ndǔ ɛkotákátí. Bágó bo báchák nkwɔ bati apay, yɛ̌ntɨkɨ mmu wap ndǔ ɛyi ɛkotákátí, amɔt ɛbhe awɔ́nɛm Yesu, achák ɛbhe awɔghɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Páílet nkwɔ arɛm básɨ́ŋ ɛnyɨŋ ndǔ ɛbhɔ́kɔ́nɔk bábhát ndǔ ɛkotákátí, amfay ntí Yesu. Básɨ́ŋ amɔ ábhák bɛ, “Yesu mmu Násárɛt, Mfɔ bo Israɛl.” ");
INSERT INTO kenNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Básɨ́ŋ amɔ achí nyaka ndǔ bɛyɔŋ ɛtɔk bɛrat, ndǔ ɛyɔŋ bo Israɛl, nɛ ndǔ ɛyɔŋɔ Latin, nɛ ndǔ ɛyɔŋɔ́ Grik. Nɛ nɛbhʉɛt anɛ bágó Yesu ndǔ ɛkotákátí abhak kɛ́kwɔ́t nɛ ɛtɔk ɛgho. Ɛ́kʉ́, bɛyǎ bo Israɛl bápáy basɨ̌ŋɨ́ mɔ. ");
INSERT INTO kenNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Bǒbati bachiǎkap bárɔ́k ntá Páílet barɛm bɛ, “Ɔ́kɛ́ sɨ́ŋ bɛ, ‘Mfɔ bo Israɛl.’ Sɨ́ŋ chí bɛ, ‘Mmǔ-nɛ arɛm nyaka bɛ achí Mfɔ bo Israɛl.’” ");
INSERT INTO kenNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Páílet akɛmɛ bɛ, “Ɛnyɨŋ ɛnɛ nsɨ́ŋɨ́ nnáŋ nsɨŋ.” ");
INSERT INTO kenNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Batɛmɛ́ nɛnu bágó nɔ́kɔ́ Yesu ndǔ ɛkotákátí, básɔ́t ndɛn ɛyi bákɔ́rɛ ndǔ baru anwi, yɛ̌ntɨkɨ mmu wap asɔt ndu amɔt. Kɛ ɛ́rɔp nkú amɔt. Nkú yɔ abhak ntěndɛn nɛmɔt ɛnɛn báyɛ́mɛ́ yɛ̌ntɨkɨ nɛku ɛni bɛ́fú amfay bɛ́gháka amɨk, kɛkpɔti yɔ́ yɛ̌ ɛbhak. ");
INSERT INTO kenNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ɛkʉ báré rɛm nɛ batɨ bɛ, “Sɛ́kɛ́ dakati nkú anɛ. Sɛ́ngʉɛ́p chí ɛbháŋá, sɛ́ngɔ́ mmu anɛ ábhɔ́ŋɔ́ bɛsɔt yɔ.” Ɛ́fákárí ɛnyunɛ bɛ ɛnyɨŋ ɛnɛ Ɛkáti Mandɛm ɛ́rɛ́mɛ́ ɛ́mfú tɛtɛp. Nɔ́ chí, basɨ̌ŋ amɛn árɛ̀m bɛ, “Básɔ́t ndɛn aya bákɔ́rɛ́. Bágʉɛ́p ɛbháŋá bɛ́rɨ́ŋɨ mmu anɛ ábhɔ́ŋɔ́ bɛ́sɔt nkú aya.” ");
INSERT INTO kenNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Batɛmɛ́ nɛnu bákʉ nɔ. Nnɔ Yesu abhak téé kɛ́kwɔ́t nɛ ɛkotákátí, nɛ manɔ́ máyi, María, ngɔrɛ́ Klopas, nɛ María mmɔ̌ ɛtɔk Mágdala. ");
INSERT INTO kenNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu ághɔ́ nɔ́kɔ́ máyi nɛ nkoŋo anɛ yi ákɔ́ŋɔ́ téé kɛ́kwɔ́t, arɛm ntá máyi bɛ, “Mmá, ghɔ́ mɔ́ywɛ nɔ!” ");
INSERT INTO kenNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Arɛm yɛ ntá nkoŋo wu bɛ, “Ghɔ́ máyɛ nɔ!” Nɛ bɛbho ɛwak ɛyɔ nkoŋo wu asɔt nnɔ Yesu arɔk ɛkɛt ɛyi nɛ yí. ");
INSERT INTO kenNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Mɛnyɨŋ ɛbhɛn mɛnkɛm bɛ́fʉɛ́rɛ́ nɔ́kɔ́, Yesu arɨŋɨ bɛ bɛtɨk ɛbhi mɛmay. Ndu bɛkʉ bɛ ɛnyɨŋ ɛnɛ ɛchi amɛm Ɛkáti Mandɛm ɛ́mfú tɛtɛp, arɛm bɛ, “Manyiɛp ǎkwak mɛ.” ");
INSERT INTO kenNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ɛjɔ̌ mmɛ́m amɛn ánɛn ɛchí nyaka arɛ téé. Básɔ́t ɛkuchá fofok bágwɔ́t antí ntábhɛ́nɔk ɛnɛ bábhɨŋɨ bɛ haysɔp, bátáp ndǔ mmɛm mɔ básá yi anyu. ");
INSERT INTO kenNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu asɔ́k mmɛ́m mɔ, arɛm bɛ, “Bɛtɨk ɛbha mɛ́may.” Akʉ́ɛ́p ɛmɨ, arɔ nɛpɛ́m ɛni nɛndɔk. ");
INSERT INTO kenNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nywɔp ntóŋtí bo Israɛl nɛ́kwáy. Bɛkʉ yɛ bɛ́ ɛrɛnɛ ngú ɛ́kɛ́ rɔp amfay ɛkotákátí ndǔ nywɔbhɛ́ nɛywěmʉɛt bo Israɛl, bárɔ́k babhɛp Páílet bɛ ánchyɛ́ bɛtaŋ mánsíɛ́ptí bɛkak ɛbhap, mámfɛ́rɛ́ bhɔ ndǔ bɛkotakati. Nywɔp nɛywɛ̌mʉɛt ɛnɔ nɛ́bhak nywɔp nɛgho. ");
INSERT INTO kenNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ɛkʉ́ batɛmɛ́ nɛnu bárɔk, básiɛ́ptí bɛkak mmǔ mbɨ, básiɛ́ptí bɛkak anɛfú. ");
INSERT INTO kenNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Kɛ bágháká nɔ́kɔ́ amʉɛt Yesu, bághɔ́ bɛ́ anáŋ agu, bɔ́ kɛsyɛpti bɛkak ɛbhi. ");
INSERT INTO kenNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kɛ ntɛmɛ́ nɛnu amɔt asɔt nɛkɔŋ ayɛm Yesu ambeápak. Tɛ́mté wu, manoŋ nɛ manyiɛp abho bɛfu. ");
INSERT INTO kenNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mmǔ anɛ ághɔ́ nyaka ndu ɛ́fákárí kɛ̌ ágháti bhɛsɛ nɛ ɛnyɨŋ ɛnɛ yi ǎrɛ̀m ɛchí tɛtɛp. Arɨ́ŋɨ́ bɛ árɛm chi tɛtɛp bɛ be nkwɔ́ mǎnsɨ́kɨ́ntɨ nɛ Yesu. ");
INSERT INTO kenNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ɛ́fákárí ɛnyu ɛyɔ bɛ́ ɛnyɨŋ ɛnɛ́ ɛchí amɛm Ɛkáti Mandɛm ɛ́mfú tɛtɛp. Nɔ́ chí, ɛnyɨŋ ɛnɛ básɨ́ŋɨ́ nyaka bɛ, “Yɛ̌ ɛghɛp ɛyi ɛ́mɔt bápú syɛp.” ");
INSERT INTO kenNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Nɛ Ɛkáti Mandɛm ɛpɛt ɛ́rɛ̀m ndǔ nɛbhʉɛt áchák bɛ, “Chɔŋ bo mámkpɔk yi anɛ báyɛ́mɛ́.” ");
INSERT INTO kenNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ɛ́tárɛ́ nɔ́kɔ́, mmǔ amɔt átwɔ́. Áká nnyɛ́n bɛ Josɛ́f. Abhak mmǔ ɛtɔk Arimátia. Achí nyaka mmu anɛ ákòŋo Yesu. Ǎcháy nyaka bo Israɛl ndu yi achi nkoŋo Yesu. Afʉɛ́t arɔk ntá Páílet bhɛ́sɛ́ bhɛ́sɛ́, anɨkmʉɛt bɛ Páílet andɔ yi ámfɛ́rɛ́ mmʉɛt Yesu ndǔ ɛkotákátí. Páílet achyɛ yi bɛtaŋ bɛkʉ nɔ. Josɛ́f arɔk yɛ, afɛrɛ mmʉɛt Yesu ndǔ ɛkotákátí. ");
INSERT INTO kenNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikɔdɛ́mɔs mmu árɔ́ŋɔ́ nyaka bɛghɔ Yesu nɛ betí ɛwak ɛ́mɔt, abhak nkwɔ nɛ Josɛ́f. Yí, Nikɔdɛ́mɔs arɔk nɛ babhé amɛn bábyɔk amʉɛt ngu bɛ́ ákɛ́ chɔŋɔ. Babhé mɛ́rɛ́ abhak nchɔ́ptí myrrh nɛ álos. Ǎkway nyaka bɛbhak mbɔ kilo bɛsa bɛpay nsɛm byo ndǔ mɛnwɔp ɛbhi. ");
INSERT INTO kenNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Josɛ́f nɛ Nikɔdɛ́mɔs báfɛ́rɛ Yesu ndǔ ɛkotákátí, básɔ́t bɛ́syɛ́ndɛn nɛ babhé amɔ arɛ́, mánɛ́p yi bɛkoŋo ɛpɨŋ bo Israɛl. ");
INSERT INTO kenNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Mɔ́nkɨ áchi nyaka ndǔ nɛbhʉɛt anɛ bágó Yesu ndǔ ɛkotákátí. Nnɛm nɛkɔ nɛ́bhák arɛ ɛnɛn bábhɨ́kɨ́ re bhɛmɛ yɛ̌ ngú amɔt amɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Tɛ̌ndu nywɔp ɛnɔ nɛ́chí nyaka chí nywɔp ɛnɛn bo Israɛl bákʉ̀ ntoŋti bɛ́chwe ndǔ nywɔp nɛywěmʉɛt ɛnap, nɛ mbɔnyunɛ nnɛm ɛnɔ nɛ́bhɨkɨ sap nyaka nɛkɔ, Josɛ́f nɛ Nikɔdɛ́mɔs bárɔ́k bábhɛ́mɛ Yesu arɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Nywɔp nɛywɛ̌mʉɛt bo Israɛl nɛ́fʉɛ́rɛ́ nɔ́kɔ́, María mmɔ̌ ɛtɔk Mágdala afa nɛ nɛyǐnywɔp arɔk ndǔ nnɛm Yesu. Aghɔ́ bɛ́ mǎnáŋ bábɨ́ŋɨ́rí ntay ɛnɛn nɛchi anyǔ nnɛm báfɛrɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","María afa yɛ arɔk ntiɛ́t ntiɛt ntá Símun Píta nɛ nkoŋo Yesu áchák anɛ Yesu ákɔ́ŋɔ́ nyaka, arɛm bɛ, “Báfɛ́rɛ́ Yesu Acha ndǔ nnɛm nɛ sɛ́bhɨ́kɨ́ rɨŋɨ nɛbhʉɛt anɛ bárɔ́ŋ bábhʉ́rɛ́ yi.” ");
INSERT INTO kenNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Píta afú yɛ nɛ nkoŋo anɛfú wu, báfá, báré rɔ́ŋ ndǔ nnɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Báre rɔŋ ntiɛ̌ntiɛt, kɛ nkoŋo anɛfú wu ajɛt acha Píta. Ayambɨ aghaka ndǔ nnɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Akuri amɨk. Asá nɔ́kɔ́ amɨ́k awu amɛm, aghɔ́ bɛbhɔ́k ɛ́síɛndɛn arɛ kɛ akɛ chwe amɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Símun Píta mmu ákòŋo yi ansɛm áchwɔ́bhɛ́ nɔ́kɔ́ ndǔ nnɛm, afʉɛ́t, arɔk amɛm, aghɔ́ bɛbhɔ́k ɛ́síɛndɛn ɛbhɔ arɛ bhʉ́rɛ́. ");
INSERT INTO kenNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Aghɔ́ ndɛn anɛ mánɛ́bhɛ́ nyaka ntí Yesu nɛ yɔ nkwɔ. Nɛ ndɛn ɛyɔ ɛbhak aywi nɛbhʉɛt kɛkúrí nɛnɛp. ");
INSERT INTO kenNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kɛ nkoŋo anɛfú wu anɛ ayambɨ áchwɔ́bhɛ́ ndǔ nnɛm achwe amɛm nkwɔ, aghɔ́ nɛ amɨ́k, anoko. ");
INSERT INTO kenNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Kpátɛ mpok yɔ, bɔ́ bábhɨkɨ re jwi nyaka mmɛm ndǔ ɛnyɨŋ ɛnɛ Ɛkáti Mandɛm ɛ́rɛ́mɛ́ bɛ́ Yesu abhɔŋ bɛpɛtnsɛm ndǔ nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Bakoŋo Yesu bhɔ bápɛtnsɛm ndǔ bɛkɛt ɛbhap. ");
INSERT INTO kenNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Kɛ María ate nɛpaka nnɛm andi nɔkɔ kɛbhɔ, nɛ ɛnɛ́ yí ábhʉɛ́t bɛdi, akuri amɨk, agʉɛ́p amɨ́k awu amɛm nnɛm. ");
INSERT INTO kenNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Aghɔ́ bɔángɛl Mandɛm bati apay chɔ́kɔ́ nɛ ndɛn pɛ́pɛ́p amʉɛt ndǔ nɛbhʉɛt anɛ bábhʉ́rɛ́ nyaka Yesu. Amɔt abhak ndǔ nɛbhʉɛt ntí ywi achi nyaka. Achák ndǔ nɛbhʉɛt bɛkak. ");
INSERT INTO kenNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Bárɛ́m ntá María bɛ, “Mmá, ɔ̌di yi?” María akɛmɛ bhɔ bɛ, “Chi ɛ̌ti báfɛ́rɛ́ Acha bárɔŋ nɛ yi, nɛ mbɨ́kɨ́ rɨŋɨ ɛbhak ɛnɛ bábhʉ́rɛ́ yi.” ");
INSERT INTO kenNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Árɛ́mɛ́ nɔ́kɔ́ nɔ́, ayibhiri mmʉɛt aghɔ́ Yesu téé, kɛ yi kɛrɨŋɨ bɛ chi yi. ");
INSERT INTO kenNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu arɛm ntá yi bɛ, “Mma, ɔ̌di yi? Ɔ̌yàŋ agha?” Ndǔ María ákáysí bɛ́ chí mmu anɛ áyɨ̀ŋɨ nkɨ, arɛm ntá yi bɛ, “Ɛta, mbák ɔ́fɛ́rɛ́ yi, ghatí mɛ́ ɛbhak ɛnɛ ɔ́bhʉ́rɛ́ yi bɛ́ ndɔ́k nsɔt yí.” ");
INSERT INTO kenNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu arɛm bɛ, “María!” María ayibhiri mmʉɛt arɛm ndǔ ɛyɔŋ bo Israɛl bɛ, “Rabóni!” Nɔ chí “Ntɔŋ”. ");
INSERT INTO kenNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu arɛm ntá yi bɛ, “Kɛ́kɛm mɛ, mbɔnyunɛ mbɨ́kɨ́ re rɔŋ amfay ntá Ɛtaya. Kɛ dɔ́k ntá bɔ̌maya ghatí bhɔ bɛ́ mɛ̌pɛtnsɛm ntá Ɛtaya, nɛ ɛtayɛka. Ntá Mandɛm awa, nɛ Mandɛm aywɛka.” ");
INSERT INTO kenNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","María mmɔ̌ ɛtɔk Mágdala arɔk aghati bakoŋo Yesu bɛ, “Ngɔ Yesu Acha.” Nɛ aghati bhɔ mɛnyɨŋ ɛbhɛn Yesu aghati yi. ");
INSERT INTO kenNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ɛ́gháká nɔ́kɔ́ beku ndǔ nkúbhɛ́ nywɔbhɛ́ nɛywěmʉɛt ɛnɔ, bakoŋo Yesu bábhak amɛm ɛkɛt ɛ́mɔt nɛ babhǐnywɔ́p femfé ndu báchay bǒbati bo Israɛl. Yesu arɔk ate bɔ́ bɛsí, arɛm bɛ, “Kpák ámbák nɛ bhe.” ");
INSERT INTO kenNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Árɛ́m nɔ́kɔ́ nɔ, atɔ́ŋ bɔ amɔ yi nɛ mbeápak ɛyi. Bakoŋo abhi bájwí nɛ maŋák ndu bághɔ́ Yesu Acha. ");
INSERT INTO kenNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu apɛt arɛm bɛ, “Kpák ámbák nɛ bhe! Nkúbhɛ́ mbɔ ɛnyǔ Ɛtaya átó mɛ, kɛ nchí tó be.” ");
INSERT INTO kenNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Yesu árɛ́mɛ́ nɔ́kɔ́ nɔ́, afɛ́p bhɔ ɛ̌yú, arɛm bɛ, “Dɔ̌ ka Ɛfóŋó Bɛdyɛrɛ ámbák nɛ bhe. ");
INSERT INTO kenNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mbák mǎmfóŋórí mmu bɛbʉ́ ɛbhi, Mandɛm nkwɔ ǎfoŋori yi. Mbák bǎbhɨkɨ foŋori bɛbʉ́ mmu, bɛ́rɔ̀p yi anti.” ");
INSERT INTO kenNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Nkoŋo Yesu amɔt ndǔ abhɛn bati byo nɛ apay, anɛ áká nnyɛ́n bɛ Tɔmás, nɔ chí ɛfák, apú nyaka nɛ batɨ, mpok Yesu átwɔ́. ");
INSERT INTO kenNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tɔmás átɛ́mɛ́rí nɔ́kɔ́ bhɔ, báré ghati yi bɛ, “Sɛ́ghɔ Yesu Acha.” Kɛ yi akɛmɛ bhɔ bɛ, “Kpátɛ ngɔ́ nɛ amɨ́k bɛbhé-mpi yí amɔ, ntɔk bhɔ́ nɛ sɛnɔŋ awɔ, mbát awɔ́ ndǔ tambe ywi mpú noko.” ");
INSERT INTO kenNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ɛ́fʉɛ́rɛ́ nɔ́kɔ́ manywɔp ánɛn, bakoŋo Yesu bápɛ́t babhak anywɔp ndǔ nɛbhʉɛt amɔt. Tɔmás abhak nɛ bhɔ. Babhǐnywɔp ábhák femfé, Yɛ̌ nɔ, Yesu atwɔ́, ate nɛntɨ ɛnap, arɛm bɛ, “Kpák ámbák nɛ bhe.” ");
INSERT INTO kenNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Arɛm yɛ ntá Tɔmás bɛ, “Tɔ́k bɛrɨŋ ɛbhɛn bɛchi ndu amɔ́ ya nɛ kɛnɔŋámɔ ɛkɛ ghɔ. Sá awɔ́ fá ndǔ tambe wa. Kɛ́pɛrɛ makati. Bák mmu anɛ ánòko!” ");
INSERT INTO kenNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tɔmás akɛmɛ yí bɛ, “Acha nɛ Mandɛm awa!” ");
INSERT INTO kenNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu arɛm ntá yi bɛ, “Ɔnókó mbɔnyunɛ ɔ́ghɔ́ mɛ nɛ amɨ́k? Ɛrɨ ɛcha ntá bo abhɛn mánòko yɛ̌ndu bábhɨ́kɨ́ ghɔ́ nɛ amɨ́k.” ");
INSERT INTO kenNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu akʉ nyaka bɛyǎ mɛnyɨŋɨ́ maknkay bɛ́chák bɛsí bakoŋo bhi, ɛbhɛ́n bábhɨ́kɨ́ sɨŋ amɛm ɛkáti ɛnɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Básɨŋ mɛnyɨŋ ɛbhɛn bɛ́chí amɛm ɛkáti ɛnɛ bɛ mɛnkwak be mǎnókó bɛ Yesu kɛ achi Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò, Mmɔ Mandɛm. Nɛ bɛ́ ndǔ mǎnókó yí, mǎmbɔ́ŋ nɛpɛ́m ndǔ nnyɛ́n ɛni. ");
INSERT INTO kenNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ɛ́tárɛ́ nɔ́kɔ́, Yesu apɛt atɔ́ŋ mmʉɛt ntá bakoŋo bhi. Ndɔŋ yɔ, ɛbhák chi nɛpaka Manyu Tibérias. Sɛ́ngɔ́ ɛnyǔ yi atɔŋ nyaka mmʉɛt ntá yap. ");
INSERT INTO kenNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Símun Píta nɛ Tɔmás anɛ bábhɨ̀ŋɨ bɛ ɛfák, nɛ Natániɛl anɛ áfú Kána atú Gálili, nɛ bɔ̌ Sɛbɛdi bati apay, nɛ bakoŋo Yesu báchák bati apay bachi nyaka ndǔ nɛbhʉɛt amɔt. ");
INSERT INTO kenNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Símun Píta arɛm bɛ, “Mɛ̌rɔ̀ŋ anyɛ́n nɛ ási.” Bakoŋo Yesu báchák bárɛ́m bɛ, “Sɛ́rɔ̀ŋ nɛ wɔ.” Bɔ́ bárɔ́k básɔ́t áchwí, báré gháp anyɛ́n amɛm áchwí wu bɛti mɛnkɛm ndu bɛkɛm nsi, kɛ yɛ̌nyɨŋ bɔ́kɛ kɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ndu mbaŋ ákàŋari, Yesu ate nɛpakányɛ́n. Yɛ̌ nɔ, bakoŋo bhi kɛrɨŋɨ bɛ chi yi. ");
INSERT INTO kenNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesu arɛm ntá yap bɛ, “Bɔ̌bha, bǎkɛm nsi?” Bákɛ́mɛ yi bɛ, “Ǎe.” ");
INSERT INTO kenNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Aghati bhɔ bɛ, “Gʉɛ́p ká asɨ ɛbhe awɔ́nɛm áchwí, chɔŋ mǎnkɛ́m nsi.” Bágʉɛ́p asɨ ɛbhe awɔ́nɛm. Bɛyǎ nsi ɛkwɛn, kpát ɛ́chá bhɔ́ bɛyǎ bɛyǎ nkáp ɛbhɨ. ");
INSERT INTO kenNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nkoŋo anɛ Yesu ákɔ́ŋɔ́ nyaka arɛm ntá Píta bɛ, “Chi Acha!” Píta ághókó nɔ́kɔ́ bɛ chi Yesu Acha, asɔt ndɛn ayi afyɛ́ amʉɛt, adók, akwɛn amɛm manyu. Afɛ́rɛ́ nyaka yɔ amʉɛt ndu bɛkʉ bɛtɨk. ");
INSERT INTO kenNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Kɛ bakoŋo abhɛn bárɔ́bhɛ́ amɛm áchwí báré nok bɛkoŋo yi angɔkɔnyɛ́n, mánja nɔkɔ bɛyǎ nkáp anɛ ajwi nɔ nɛ nsi. Nɛbhʉɛt anɛ báfú bɛ́rɔ́ŋ angɔkɔnyɛ́n kɛ sap. Abhak mbɔ bayat bɛsa bɛtay. ");
INSERT INTO kenNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Bákó nɔ́kɔ́ ɛbhɨ baghɔ ngo anɛ bábháytí nɛ bakiri. Nsi ɛbhak arɛ. Brɛt nkwɔ abhak arɛ. ");
INSERT INTO kenNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu arɛm bɛ, “Twɔ́ ká, nɛ mbɔk nsi ɛyɔ nɔ́ bǎkɛ́mɛ́.” ");
INSERT INTO kenNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Píta arɔk ndu áchwí, aya bɛyǎ nkáp, akó ɛbhɨ nɛ wu. Ájwí nɛ nsi ɛgho ɛbhak bɛsa tándrámɔt nsɛm byo nɛ ɛ́rát. Kɛ yɛ̌ndu nsi ɛyɔ ɛ́yá nɔ́, ásɨ kɛdakati. ");
INSERT INTO kenNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu arɛm ntá yap bɛ, “Twɔ́ nyiɛ́ ká nɛnyíɛ́.” Kɛ yɛ̌ nkoŋo amɔt kɛmɔ bɛbhɛp yi bɛ, “Ɔchí agha?” Bárɨ́ŋɨ́ bɛ chí Yesu Acha. ");
INSERT INTO kenNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu asɔt brɛ́t achyɛ bhɔ. Akʉ ɛnyumɔt nɛ nsi. ");
INSERT INTO kenNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ndɔŋ ayɔ abhak anɛ ajwi ɛrat ɛnɛ́ Yesu átɔ́ŋɔ́ mmʉɛt ntá bakoŋo bhi, bɛbho ndǔ mpok anɛ yi ápɛ́rɛ́nsɛm ndǔ nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Mányiɛ nɔ́kɔ́ nɛnyíɛ́, Yesu arɛm ntá Símun Píta bɛ, “Símun, mmɔ̌ Jɔ̌n, ɔkɔŋ mɛ ɔchá mɛnyɨŋ ɛbhɛn-ɛ?” Símun akɛmɛ bɛ, “Ɛɛ, Acha, ɔrɨ́ŋɨ́ bɛ́ nkɔŋ wɔ.” Yesu arɛm bɛ, “Ne bɔ̌bághɔ́ŋɔmɛ́n ayá.” ");
INSERT INTO kenNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Bɛ́jwí ndɔŋ ɛpay, Yesu arɛm bɛ, “Símun, mmɔ̌ Jɔ̌n, ɔkɔŋ mɛ?” Símun akɛmɛ bɛ, “Ɛɛ, Acha, ɔrɨ́ŋɨ́ bɛ́ nkɔŋ wɔ.” Yesu arɛm bɛ, “Babhɛri nɔkɔ bághɔ́ŋɔmɛ́n aya.” ");
INSERT INTO kenNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Bɛ́jwí ndɔŋ ɛ́rát, Yesu arɛm bɛ, “Símun, mmɔ̌ Jɔ̌n, ɔkɔŋ mɛ?” Píta abé ntɨ mbɔnyunɛ Yesu ábhɛp yi ɛnyɨŋ ɛrɛ ɛ́mɔt ndɔŋ ɛ́rát. Ɛ́kʉ, aghati Yesu bɛ, “Acha, ɔrɨ́ŋɨ́ yɛ̌ntɨkɨ ɛnyɨŋ, ɔrɨ́ŋɨ́ bɛ́ nkɔŋ wɔ.” Yesu arɛm bɛ, “Ne bághɔ́ŋɔmɛ́n aya. ");
INSERT INTO kenNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Tɛtɛ̌tɛp, mpok ɔ́chí ɛsakámu, ɔre gwɔ́t mmʉɛt, ɔ́ndɔk yɛ̌ntɨkɨ ɛbhak ɛnɛ́ ɔ́kɔ́ŋɔ́. Kɛ mpok ɔ́kɔ́kɔ́, chɔŋ ɔ́njoŋ ámɔ́ amfay, mmu achák amfyɛ wɔ́ ndɛn amʉɛt, ansɔt wɔ andɔk ɛbhak ɛnɛ ɔ́bhɨ́kɨ́ kɔŋ bɛrɔŋ.” ");
INSERT INTO kenNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu arɛm nɔ́ bɛtɔŋ ɛnyǔ nɛwú ɛnɛn Píta ábhɔ́ŋɔ́ bɛ́gu ndu bɛchyɛ Mandɛm kɛnókó. Yesu arɛm yɛ ntá Píta bɛ, “Koŋó mɛ́.” ");
INSERT INTO kenNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Píta ayibhiri mmʉɛt aghɔ́ nkoŋo anɛ Yesu ákɔ́ŋɔ́ ndu ákòŋo bhɔ́ ansɛm. Nkoŋo wu kɛ ághɔ́kɔ́ nyaka amʉɛt Yesu mpok mányìɛ̀ nɛnyíɛ́, nɛ yí wu kɛ ábhɛ́bhɛ́ nyaka Yesu bɛ, “Acha, agha áti chɔŋ wɔ?” ");
INSERT INTO kenNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Píta ághɔ́ nɔ́kɔ́ yi, abhɛp Yesu bɛ, “Acha, ná nɛ anɛ?” ");
INSERT INTO kenNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu arɛm bɛ, “Mbák mɛ̌yaŋ bɛ́ yi wu ambak nɛpɛ́m tɛ mpɛtnsɛm, ɛyɔ ɛ́yɨ́ŋɨ́ wɔ́ ná? Koŋó mɛ́!” ");
INSERT INTO kenNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ɛnyɨŋ ɛnɛ Yesu árɛ́mɛ́, ɛ́táká nɛntɨ bǒnkwɔ bɛ nkoŋo Yesu wu abhɨ́kɨ́ bhɔŋ bɛ́gu. Kɛ, sayri sayri, Yesu abhɨ́kɨ́ ghati nyaka Píta bɛ Jɔ̌n apu gú. Arɛm chi bɛ, “Mbák mɛ̌yáŋ bɛ yi ákɛ́ gú tɛ́ mpɛtnsɛm, ɛyɔ ɛ́yɨ́ŋɨ́ wɔ́ ná?” ");
INSERT INTO kenNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nkoŋo Yesu wu kɛ ághàti bhɛsɛ mɛnyɨŋ ɛbhɛn, nɛ yi kɛ ásɨ́ŋɨ́ bhɔ amɨk. Nɛ sɛ́rɨ́ŋɨ́ bɛ́ ɛnyɨŋ ɛnɛ yí árɛ̀m ɛchi tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu akʉ nyaka bɛyǎ mɛnyɨŋ bɛchak. Mbɔ básɨ́ŋ bɔ́ mɛnkɛm amɨk ɛ́mɔt ɛ́mɔt, nkáysí bɛ́ mbʉ mmɨk nkɛm ajwí nɛ bɛkáti, kpátɛ mbɔk andɔp.");
INSERT INTO kenNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ɛta Tiófilɔs, ndǔ ɛkáti ɛya ɛnɛ mbɨ, nsɨŋ ɛ̌ti mɛnyɨŋ mɛnkɛm ɛbhɛ́n Yesu ákʉ́ nɛ ɛbhɛn yi atɔŋɔ bɛbho mpok yi ábhó bɛtɨk ɛbhi fá amɨk, ");
INSERT INTO kenNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","kpát bɛ́gháka nywɔp ɛnɛn Mandɛm ákʉ́ yi akó amfay. Ápɛ́rɛ ko amfay, Ɛfóŋó Bɛdyɛrɛ akʉ yi angati bo abhɛn yi ayabhɛ bɛ mámbák bǒnto bhi mɛnyɨŋ ɛbhɛn bɔ babhɔŋɔ bɛkʉ. ");
INSERT INTO kenNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Mpok yi apɛrɛnsɛm ndǔ nɛpɛ́m, atɔ́ŋ mmʉɛt ntá yap ndǔ bɛyǎ ndɔŋ ndǔ manywɔp bɛsa bɛpay. Bághɔ́ yi kpoŋoroŋ ɛnyu ɛnɛ́ bápú kway mɛmakati bɛ, sayri sayri, apɛtnsɛm ndǔ nɛpɛ́m. Apɛt nyaka nsɛm ndǔ nɛpɛ́m antɔŋ nɔkɔ Ɛyɔŋ Mandɛm bɛkʉ bo mándɨ́ŋɨ́ ɛnyǔ Mandɛm ábhák nɛ bho mbɔ Mfɔ wap. ");
INSERT INTO kenNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Mpok yí ábhʉɛ́t nɛ baghɔkɔ́ bhi aghati bhɔ bɛ, “Bǎkɛ́ fá Yerúsalɛm. Chɔkɔ́ ká noŋ akap anɛ́ Ɛta afyɛ́ bariɛp bɛ́tó mbɔ ɛnyǔ ngátí bhe. ");
INSERT INTO kenNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jɔ̌n ájwìti nyaka bo nɛ manyiɛp, kɛ ndǔ mpǎy manywɔp, chɔŋ Mandɛm anjwiti bhe nɛ Ɛfóŋó Bɛdyɛrɛ.” ");
INSERT INTO kenNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Mpok Yesu achi nɛ bǒnto bábhɛ́p yi bɛ, “Acha, chɔŋ ɔ́nsɔt kɛfɔ Israɛl ɔ́nkɛmɛ ntá yɛsɛ bo Israɛl kɛ?” ");
INSERT INTO kenNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesu akɛmɛ bhɔ bɛ, “Bǎbhɨ́kɨ́ bhɔ́ŋ bɛriŋɨ mpok anɛ Ɛta afyɛ́ bɛ mɛnyɨŋ ɛbhɛn mɛmfakari. Ɛta mmu afyɛ́ mpok ndǔ bɛtaŋ ɛbhi kɛ árɨ́ŋɨ́. ");
INSERT INTO kenNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Chɔŋ Mandɛm anchyɛ bhe bɛtaŋ mpok Ɛfóŋó Bɛdyɛrɛ atwɔ́ ntá yɛka, mǎmbak yɛ batísiɛ bha amɛm Yerúsalɛm, nɛ atú Judɛ́ya ankɛm, nɛ atú Samária, nɛ ndǔ mmɨk nkɛm.” ");
INSERT INTO kenNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yesu árɛ́mɛ́ nɔ́kɔ́ nɔ, Mandɛm asɔt yi apɛtnsɛm amfay. Báte mánjɨŋɨ nɔkɔ yi ndu árɔ̀ŋ. Nɛbháŋ nɛ́kúti yi, bɔ kɛpɛrɛ ghɔ́ yi. ");
INSERT INTO kenNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Báré yɨŋɨ gbɔkɔ́ɔ́ ndǔ yi árɔ̀ŋ amfay. Bápɛ́rɛ ghɔ, bo bati apay nɛ nkú pɛ́pɛ́p amʉɛt báté kɛkwɔt nɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Barɛm bɛ, “Bě bo Galili, ndáká yi bachi afɔ téé mánjɨŋɨ nɔkɔ awu amfay? Chɔŋ Yesu mmu árɔ́ be arɔŋɔ amfay, ampɛtnsɛm nkúbhɛ́ mbɔ ɛnyǔ bǎghɔ́ yi árɔ̀ŋ amfay.” ");
INSERT INTO kenNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Bǒnto Yesu barɔ yɛ Njiɛ Mɛnɔk Ólif bápɛtnsɛm Yerúsalɛm, nɛkɔ ɛnɛ́n nɛchi mbɔ kilómɛta amɔt. ");
INSERT INTO kenNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Báchwɔ́bhɛ́ nɔ́kɔ́ arɛ́, bákó amfay ndu mɔ́kɛt amɔt amɛm ɛkɛrɛ́mfáy anɛ bɔ báchɔ̀kɔ nyaka arɛ. Bǒnto bhɔ babhak Píta, nɛ Jɔ̌n, nɛ Jems, nɛ Andru, nɛ Fílip, nɛ Tɔmás, nɛ Batolómio, nɛ Mátio, nɛ Jems mmɔ́ Alfeyɔs, nɛ Símun anɛ achi nyaka ndǔ nkwɔ bo abhɛn mánù ɛ̌ti ɛtɔk ɛyap, nɛ Júdas mmɔ́ Jems. ");
INSERT INTO kenNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bɔ mankɛm babhak ɛyɔŋ ɛ́mɔt. Báchyɛ́ mmʉɛt ndǔ nɛnɨkɨ́mʉɛt nɛbhʉɛt amɔt chɛchɛm nɛ mbɔk bakoŋo Yesu abhɛn baghɔrɛ́, nɛ María nnɔ Yesu, nɛ bɔ̌máyi abhɛn babhakanɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ɛwak ɛ́mɔ́t ndǔ manywɔp ɛyɔ, bakoŋo Yesu bákɛ́m ɛchɛmɛ. Bábhák batí bɛsa bɛtandat. Arɛ, Píta afate arɛm bɛ, ");
INSERT INTO kenNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Bɔ̌ma, mɛnyɨŋ ɛbhɛn básɨ́ŋɨ́ amɛm Ɛkáti Mandɛm ɛ̌ti Júdas mmu ákwáká bo mankɛm Yesu bɛbhɔŋ nyaka bɛfu tɛtɛp. Nɔ chí mɛnyɨŋ ɛbhɛn Ɛfóŋó Bɛdyɛrɛ ákʉ́ nyaka Mfɔ Debhít ándɨ́ŋɨ́ nɛ arɛm bɛ bɛbhɔŋ bɛfakari. ");
INSERT INTO kenNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yí Júdas achí nyaka ndǔ nkwɔ́ ywɛsɛ́ ndu Yesu áyábhɛ́ yi bɛ ankʉ bɛtɨk nɛ bhɛsɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","“Júdas atí nɔ́kɔ́ Yesu, asɔt nkáp manoŋ anɛ́ báchyɛ́ yi aku ɛkpɔkɔ́ mmɨk. Nɛ ndǔ ɛkpɔ́kɔ́ mmɨk ɛyɔ, yímbɔŋ akwɛ́n kɛ́bhɛri mɛniɛ bɛ́sɛ́n, mántɛp árɔ́ri amɨk, agú. ");
INSERT INTO kenNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Bǒ mankɛm abhɛn báchí amɛm ɛtɔk Yerúsalɛm bághók ndak anɛ áfákárí. Ɛ́kʉ́ bábhó bɛ́bhɨ́ŋɨ nɛbhʉ́ɛ́rɛ́mɨk wu ndǔ ɛyɔŋɔ́tɔk ɛyap bɛ Akɛldáma, nɔ́ chí mmɨkɨ́ manoŋ. ");
INSERT INTO kenNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Ɛchi mbɔ ɛnyǔ Mfɔ Debhít asɨŋɨ amɛm Ɛkáti Bakway bɛ́: ‘Ɛkɛt ɛyi ɛ́ndɔ́p ɛwɔ́, yɛ̌ mmu kɛ́chɔkɔ amɛm.’ Nɛ Debhít apɛt asɨŋ bɛ, ‘Mmu áchák ánsɔ́t ɛ́pɔ́kɔ́ bɛtɨk ɛyi.’ ");
INSERT INTO kenNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Ɛ́rɨ yɛ bɛ́ mmu áchák ánchɛ́m nɛ bhɛsɛ bɛ sɛ́ngátí nɔ́kɔ́ bo mbɔ batísiɛ bɛ Yesu apɛtnsɛm ndǔ nɛpɛ́m. Mmu wu abhɔŋ bɛ́bhak chi mmu anɛ achi nyaka ndǔ nkwɔ ywɛsɛ mpok Yesu Acha achi nɛ bhɛsɛ, bɛ́bho mpok Jɔ̌n ájwítí yí bɛghaka nywɔp ɛnɛn yi arɔŋɔ amfay.” ");
INSERT INTO kenNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nkaysi yap akwɛ́n amʉɛt bo bati apay: Josɛ́f nɛ Matías. Josɛ́f abhɔ́ŋ manyɛ́n áchák ápáy. Nɔ́ chí Jústɔs nɛ Básabas. ");
INSERT INTO kenNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Mánɨ́k yɛ mmʉɛt bɛ́, “Acha, ɔrɨ́ŋɨ́ nkaysi yɛ̌ntɨkɨ mmu. Ndǔ bǒbhɛn batí apay, ntɨkɨ mmu ɔ́yábhɛ́ ");
INSERT INTO kenNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","bɛ́ ambak mǔnto ndu bɛtɨk ɛbhɛn ndu bɛsɔt ɛpók Júdas mmú árɔ́ŋɔ́ ɛbhak ɛnɛ́ ɛ́kwáy nɛ yi? ");
INSERT INTO kenNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Bágʉɛ́p yɛ ɛbhaŋa ɛ̌ti bǒbhɛn batí apay. Ɛ́ká Matías. Básɔ́t yɛ Matías báchɛm nɛ nkwɔ bǒnto Yesu bachak batí byó nɛ amɔt.” ");
INSERT INTO kenNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nywɔp ɛpǎ bo Israɛl ɛnɛ bábhɨ̀ŋɨ bɛ́ *Pɛ́ntɛkɔs ɛghaka nɔkɔ, bakoŋo Yesu mankɛm bábhák nɛbhʉɛt amɔt. ");
INSERT INTO kenNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ɛwat ɛ́fú amfáy tɛ́mchók mbɔ ɛnɛ́ mbʉ́ɛ́p ataŋataŋ ɛ́jwǐ amɛm ɛkɛt ɛnɛ́ bɔ bachi arɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Bághɔ́ mɛnyɨŋ mbɔ bárɨ́ngo. Átáka, ɛnyu ɛnɛ́ yɛ̌ntɨkɨ mmu wap abhɔ́ŋ nɛmɔt ɛnɛn nɛte yi anti. ");
INSERT INTO kenNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Tɛ́mté wu Ɛfóŋó Bɛdyɛrɛ abhak nɛ yɛ̌ntɨkɨ mmu wap tontó. Akʉ́ bábhó bɛ́rɛ́m bɛyɔŋɔ́tɔk ɛbhɛn bɔ babhɨkɨ ghɔk. ");
INSERT INTO kenNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Mpok yɔ, bǒ abhɛn báfyɛ̀ bɛtaŋ bɛbhʉ̀rɛ bɛbhé bo Israɛl babhak Yerúsalɛm. Báfú ndǔ bɛyǎ bɛtɔk. ");
INSERT INTO kenNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Bághókó nɔ́kɔ́ ɛwat ɛyɔ, bárɔk ntiɛ́t ntiɛt bɛ́ghɔ ɛnyɨŋ ɛnɛ ɛ́fàkari. Bábhak maknkay bɛghók ndǔ bakoŋo Yesu bárɛ̀m bɛyɔŋɔ́tɔk nyáŋá nyáŋá ɛnyu ɛnɛ́ yɛ̌ntɨkɨ mmu wap ághòk ndu ɛyi ɛyɔŋɔ́tɔk ɛnyɨŋ ɛnɛ́ bárɛ̀m. ");
INSERT INTO kenNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Bábhák maknkay tontó, bábho bɛrɛm bɛ, “Pú bǒbhɛn mankɛm chi bo Galili? ");
INSERT INTO kenNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ná ɛ́chí bɛ́ yɛ̌ntɨkɨ mmu ywɛsɛ ǎghòk ɛnyɨŋ ɛnɛ́ bɔ́ bárɛ̀m ndǔ ɛyi ɛyɔŋɔ́tɔk? ");
INSERT INTO kenNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Sɛ́fǔ bɛtɔk nyáŋá nyáŋá: Mbɔk báfu Pátia, báchák Mídia, abhɛ́nɛ́fú Ɛ́lam; mbɔk báfú Mɛsopotemia, báchák atú Judéya, abhɛ́nɛ́fú atú Kapadóshiya; mbɔk báfú atú Pɔ́ntɔs, báchák atú Ésia. ");
INSERT INTO kenNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Mbɔk báfú atú Fríjia, báchák atú Pamfília. Mbɔk báfú Íjip, báchák báfú ndǔ batáp ɛtɔk Líbia anɛ achi kɛkwɔt nɛ Sírene. Ndú abhɛn báfú Rom, mbɔk chi bo Israɛl, báchák bǒ abhɛn bákòŋo Mandɛm mbɔ bo Israɛl, ");
INSERT INTO kenNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","báchák báfú Krɛt, abhɛ́nɛ́fú Arébia. Yɛ̌ nɔ, yɛ̌ntɨkɨ mmǔ ywɛsɛ ǎghòk ndu bɔ́ bárɛ̀m mɛnyɨŋɨ́ maknkay ɛbhɛn Mandɛm ákʉ́ ndu ɛyi ɛyɔŋɔ́tɔk.” ");
INSERT INTO kenNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Bɔ́ mankɛm bábhák maknkay, batí átáká bhɔ́, bábhó bɛbhɛp batɨ bɛ, “Anɛ́ ndak-aa?” ");
INSERT INTO kenNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kɛ bachak báré way bakoŋo Yesu mándɛm nɔkɔ bɛ, “Mmɛ́m akɛm bǒbhɛn!” Nɛtwɔ Ɛfóŋó Bɛdyɛrɛ ");
INSERT INTO kenNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Píta afate yɛ nɛ bǒnto báchák batí byó nɛ amɔt, abho bɛrɛm nɛ ɛyɔŋ ɛtaŋataŋ ntá bɛyǎ bǒbhɔ bɛ, “Bǒ Judɛ́ya nɛ be mankɛm abhɛn bǎchi Yerúsalɛm, tá ká batú mǎngók ɛnyɨŋ ɛnɛ mɛ̌rɛ̀m. ");
INSERT INTO kenNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Bǒbhɛn bábhɨ́kɨ́ kwɛ́n chi mmɛ́m mbɔ ɛnyǔ bǎkàysi. Nywɔp nɛchi ndiɛrɛ nkárɛ́nká nɛ́nɛ́namɔt běti. ");
INSERT INTO kenNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nɛ́ chí ɛnyɨŋ ɛnɛ ndɛmɛkɛpɨ̌ntɨ Jóɛl arɛmɛ nyaka bɛ chɔŋ ɛmfakari. Joɛl arɛm nyaka bɛ, ");
INSERT INTO kenNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Mandɛm arɛm bɛ ‘Ndǔ manywɔbhɛ́ ngwɛnti, chɔŋ nkʉ Ɛfóŋó ya antwɔ ntá yɛ̌ntɨkɨ mmu. Bɔ̌bhɛka mángati barak anɛ́ mɛ mfyɛ́ bɔ́ antɨ. Bɛsak ɛbhɛka mángɔ́ kɛnɔ́ amɨ́k antifu, nɛ baseansi bhɛka mángɔ kɛnɔ́. ");
INSERT INTO kenNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ndu manywɔp ɛyɔ, chɔŋ nkʉ Ɛfóŋó ya ɛ́ntwɔ́ ntá bakʉ̌ bɛtɨk abha, abhɛ́n baghɔrɛ́, nɛ abhɛn babhakanɛm, nkʉ bɔ́ mángati barak anɛ́ mfyɛ́ bɔ́ antɨ. ");
INSERT INTO kenNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nɛ chɔŋ nkʉ mɛnyɨŋɨ́ maknkay mɛ́mfakari amfay, nɛ ntɔŋ bɛrɨŋɨ́ maknkay fá amɨk. Chɔŋ manoŋ ambak, ngó ambak, mɔ́ngo ambak. ");
INSERT INTO kenNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Chɔŋ mmok anjibhiri ándɔp ɛjuri, ntaŋ ánjibhiri andɔp manoŋ, kɛ nywɔp nɛgho ɛnɛ́n Acha átwɔ̀ nɛngaka. ");
INSERT INTO kenNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nɛ chɔŋ ɛmbak bɛ yɛ̌ agha anɛ ábhɨ̀ŋɨ Acha bɛ ánkwák yi, Acha ǎpɛmɛ yi.’” ");
INSERT INTO kenNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Píta arɔk ambɨ bɛ́rɛ́m bɛ, “Bo Israɛl, ghók ká bɛyɔŋ ɛbhɛ́n: ‘Yesu mmu Násárɛt chí mmu anɛ Mandɛm áyábhɛ́ nyaka. Atɔ́ŋ kpoŋoroŋ bɛ́ ayap yí ndǔ áchyɛ́ yi bɛtaŋ. Akʉ yɛ mɛnyɨŋɨ́ maknkay. Atɔ́ŋ bɛrɨŋ. Bě babhɔŋ bǎrɨŋɨ nɔ sayri mbɔnyunɛ akʉ nyaka mɛnyɨŋ ɛbhɛn bɛsí ɛbhɛka. ");
INSERT INTO kenNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Mandɛm anáŋ arɨ́ŋɨ́ nyaka ɛnyɨŋ ɛnɛ ɛ́bhɔ́ŋɔ́ bɛfakari nɛ Yesu bɛkoŋo nkaysi yi. Báfyɛ́ yɛ́ yi amɔ yɛká bɛ mǎnchyɛ yi ntá bo bɛbʉ́ bɛ mángó ndǔ ɛkotákátí, mángway. ");
INSERT INTO kenNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Kɛ Mandɛm akʉ yí ampɛtnsɛm ndǔ nɛpɛ́m, afɛrɛ yí ndǔ bɛbě nɛwú mbɔnyunɛ nɛwú nɛpu kway nyaka bɛbhɔŋ bɛtaŋ amfǎy yi.’” ");
INSERT INTO kenNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Mfɔ Debhít asɨŋ nyaka ɛ̌ti yi bɛ, “Nchí ghɔ nyaka Acha mpoknkɛm bɛsí bha, abhak ɛbhe awɔ́nɛm ɛya, bɛ yɛ̌nyɨŋ ɛkɛ nyɨkɨsi mɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ntǐ ɛna nɛ́jwi yɛ nɛ maŋák, nɛ nchí rɛm kɛpɨ nɛ maŋák. Nɛ mbákántɨ chí nɛ Mandɛm, ");
INSERT INTO kenNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Mbɔnyunɛ wɔ Mandɛm ɔpú chɛn chɔŋ mɛ ɔ́ndɔ́ amɛm ɛtɔkɔ́ bawú, ɔpú rɔ chɔŋ Mmu anɛ áchyɛ́ nɛpɛ́m ɛni ntá yɛ ámpɔ́ amɛm nnɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ɔkʉ mɛ ndɨ́ŋɨ́ mbi nɛpɛ́m. Ndǔ ɔ́chí nɛ mɛ mpoknkɛm, chɔŋ ɔ́nkʉ mɛmbɔŋ bɛyǎ maŋák.” ");
INSERT INTO kenNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Píta arɔk ambɨ bɛrɛm bɛ, “Bɔ̌ma, nchí kway bɛghati bhe kpoŋoroŋ ɛ̌ti Mfɔ Debhít, chi mbɨ ywɛsɛ. Agu nyaka, bábhɛ́mɛ yi, nɛ nnɛm ɛni nɛbhʉɛt fá nɛ bhɛsɛ kpatɛ ɛchɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Achí nyaka ndɛmɛkɛpɨ̌ntɨ. Arɨŋɨ bariɛp amɛn Mandɛm áchyɛ́ yi, kpát anyú nku bɛ chɔŋ Mandɛm ankʉ ɛbhárɛ́mɔ ywi anyiɛ ɛnɔkɔ́ kɛfɔ ɛyi. ");
INSERT INTO kenNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Debhít ayambɨ aghɔ́ ɛnyɨŋ ɛnɛ Mandɛm abhɔŋ bɛkʉ ndǔ mpok anɛ átwɔ̀ ambɨ kɛ yɔ ɛmfakari. Aghɔ́ bɛ, chɔŋ Mandɛm ankʉ Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò ampɛtnsɛm ndǔ nɛpɛ́m. Ɛ̌ti yɔ, Debhít arɛm nyaka bɛ, ‘Mandɛm abhɨ́kɨ́ chɛn Mpɛmɛ yí áyábhɛ́ ándɔ́ amɛm ɛtɔkɔ́ bawú nɛ abhɨ́kɨ́ chɛn mmʉɛt yi ámpɔ́ amɛm nnɛm.’ ");
INSERT INTO kenNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Mandɛm akʉ Yesu apɛtnsɛm ndǔ nɛpɛ́m nɛ bɛsɛ́ mankɛm sɛ́ghɔ́ yi nɛ sɛchi batísiɛ bɛ achi nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Mandɛm achyɛ yí bɛyǎ kɛnókó ndu akʉ yi achɔkɔ ɛbhe awɔ́nɛm ɛyi ndǔ ɛnɔkɔ́ kɛfɔ. Ɛta abhʉrɛ bariɛp ami ndu achyɛ yí Ɛfóŋó Bɛdyɛrɛ. Nɛ chí Ɛfóŋó Bɛdyɛrɛ mmu Yesu achyɛ bhɛsɛ kɛ ákʉ̀ mɛnyɨŋ ɛbhɛ́n bɛ́fàkari nɛ mbɔ ɛnyǔ bǎghɔ̀ nɛ bǎghòk. ");
INSERT INTO kenNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Debhít abhɨ́kɨ́ rɔ nyaka ɛtɔkɔ́ bawú ándɔ́k amfay. Kɛ yímbɔŋ arɛm bɛ, ‘Ɛta Mandɛm arɛm nyaka ntá Acha wa bɛ́: “Chɔkɔ́ fá ɛbhe awɔ́nɛm ɛya ndu ɛnɔkɔ́ kɛfɔ, ");
INSERT INTO kenNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kpátɛ nkʉ bǒmpap abhɛ mámbak mbɔ ɛnɔk ɛnɛ ɔ́chɔkɔ ɔ́nyaŋa bɛkak arɛ́.”’ ");
INSERT INTO kenNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Bo Israɛl mankɛm bábhɔŋ bɛ́rɨŋɨ yɛ sayri bɛ, Yesu mmu be bǎgo ndǔ ɛkotákátí kɛ Mandɛm ákʉ́ yi áchi Acha nɛ Mpɛmɛ yi áyábhɛ́.” ");
INSERT INTO kenNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Bághókó nɔ́kɔ́ ɛnyɨŋ ɛnɛ́ Píta arɛmɛ, ɛ́kwɛ́n bɔ́ tɛ antɨ. Babhɛp Píta nɛ bǒnto bachak bɛ, “Bɔ̌ma, chɔŋ sɛ́nkʉ yɛ ná?” ");
INSERT INTO kenNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Píta akɛmɛ bhɔ bɛ, “Yɛ̌ntɨkɨ mmǔ yɛka abhɔŋ bɛ́tɨknsɛm ndǔ bɛbʉ́ bhi nɛ mánjwiti yi ndǔ nnyɛ́n Yesu Kristo bɛ Mandɛm amfoŋori bɛbʉ́ bhi. Mmǔ anɛ ákʉ́ nɔ Mandɛm ǎchyɛ yi Ɛfóŋó Bɛdyɛrɛ mbɔ akap. ");
INSERT INTO kenNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Bariɛp amɛn ayɨ́ŋɨ́ be nɛ bɔ̌bhɛka, nɛ bǒ mankɛm abhɛn bachi nɛkɔ nɛsiɛ. Ayɨ́ŋɨ́ nkwɔ yɛ̌ntɨkɨ mmu anɛ Mandɛm Acha yɛsɛ ábhɨ̀ŋɨ bɛ antwɔ ntá yi.” ");
INSERT INTO kenNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Píta arɔk ambɨ bɛ́rɛm baya mɛnyɨŋ bɛ́chák ansɛmti nɔkɔ bhɔ bɛ́ “Fɛrɛ́ ká mmʉɛt ndǔ ntɛmsi anɛ ábhɔ́ŋɔ́ bɛ́twɔ ntá bǒ bɛbʉ́ abhɛn fá ammɨk.” ");
INSERT INTO kenNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ɛkʉ bo abhɛn mánóko ɛnyɨŋ ɛnɛ Píta arɛmɛ bárɔ́k bájwiti bhɔ. Nɛ bo abhɛn bachɛmɛ nɛ bakoŋo Yesu nywɔp ɛnɔ babhak mbɔ nká ɛ́rát. ");
INSERT INTO kenNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bachyɛ mmʉɛt ndu bɛ́ghɔ́k mɛnyɨŋ ɛbhɛn bǒnto Yesu bátɔ̀ŋ. Bɔ́ mankɛm abhɛn manókó babhak ndu nsoŋ amɔt ndǔ yɛ̌ntɨkɨ ɛnyɨŋ, ndǔ Nɛnyiɛ Acha nɛ ndu nɛnɨkɨ́mʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Bǒnto Yesu bábho bɛkʉ bɛyǎ mɛnyɨŋɨ́ maknkay nɛ bɛrɨŋɨ́ maknkay. Bɛcháy bɛ́kɛ́m bo mankɛm abhɛn bághɔ̀ mɛnyɨŋ ɛbhɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nɛ bo abhɛn mánóko mankɛm babhák ɛyɔŋ ɛ́mɔ́t, mánkɔrɛ nɔkɔ mɛnyɨŋ ɛbhap ndǔ nsoŋ amɔt. ");
INSERT INTO kenNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Mpok nɛ mpok, abhɛn bábhɔ́ŋɔ́ mɛnyɨŋ bátì nyaka mánkɔrɛ nɔkɔ nkáp nɛ abhɛn ɛyap ɛ́pú ɛnyu ɛnɛ́ yɛ̌ntɨkɨ mmu wap abhɔŋ ɛnyɨŋ. ");
INSERT INTO kenNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nɛ yɛ̌ntɨkɨ nywɔp báchɛ̀m nyaka amɛm ɛkɛrákap Mandɛm amɛm Yerúsalɛm ndu mɛ́nɨ́kmʉɛt. Báchɛ̀m nyaka nkwɔ amɛm bɛkɛt ɛbhap ndǔ Nɛnyiɛ Acha nɛ ndǔ mɛnyiɛ́ nɛnyíɛ́ nɛ bɛyǎ maŋák nɛ ntɨ nɛmɔt, ");
INSERT INTO kenNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","mámbɨti nɔkɔ Mandɛm. Bǒ mankɛm bághɔ́ ndǔ bakoŋo Yesu bákʉ̀ nɛ báre bhɔ́ŋ maŋák nɛ bhɔ. Nɛ yɛ̌ntɨkɨ ɛwak Acha ankʉ nɔkɔ bo abhɛn yi ápɛ́mɛ́ mánchɛ́m nɛ bakoŋo bhi. ");
INSERT INTO kenNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ɛwak ɛ́mɔt, Píta nɛ Jɔ̌n bare rɔŋ ɛkɛrákap Mandɛm ndu nkárɛ́nká ɛ́rát nɛ ngósí mpok nɛnɨkɨ́mʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Bágháká nɔ́kɔ́ ndǔ nyǔbha anɛ bábhɨ̀ŋɨ bɛ Ɛrɨ́tí Nyǔbha, bághɔ́ mmu anɛ áchí mbɛ́ntí tɛ nɛbhe ɛni arɛ́ chɔ́kɔ́. Yɛ̌ntɨkɨ ɛwak bo bápɔ̀kɔ nyaka yi mámbʉrɛ ndu nyǔbha wu bɛ́ ánɨ́ŋɨ́ nɔ́kɔ́ nkáp ntá bo abhɛn báfʉɛ̀t bɛrɔŋ amɛm ɛkɛrákap Mandɛm mɛnɨkmʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Mbɛ́ntí wu aghɔ nɔkɔ Píta nɛ Jɔ̌n ndǔ báyaŋ bɛfʉɛt mandɔk ɛkɛrákap, abho mɛ́nɨŋɨ bhɔ nkáp. ");
INSERT INTO kenNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Píta nɛ Jɔ̌n báyɨŋɨ yi diíí. Píta arɛm yɛ bɛ, “Yɨŋɨ́ bhɛsɛ!” ");
INSERT INTO kenNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Atɛp bɔ amɨ́k amʉɛt nɛ nkaysi bɛ́ chɔŋ manchyɛ yi ɛnyɨŋ. ");
INSERT INTO kenNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Kɛ Píta arɛm bɛ, “Mbɨ́kɨ́ bhɔŋ nkáp, kɛ ɛnyɨŋ ɛnɛ mbɔ́ŋɔ́ chɔŋ nchyɛ́ wɔ. Ndǔ nnyɛ́n Yesu Kristo mmu Násárɛt, faté kɔ!” ");
INSERT INTO kenNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Akɛ́m yi ndǔ awɔ́nɛm ayoŋ. Tɛ́mté wu, bɛtaŋ Mandɛm bɛ́chwe ndu bɛkak nɛ mɛmɨ̌ bɛkak ɛbhi. ");
INSERT INTO kenNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Adók ate kpɛrɛp, abho bɛkɔ. Are kɔ andokoti nɔkɔ, nɛ ambɨtɨ nɔkɔ Mandɛm, kpát arɔk achwe amɛm ɛkɛrákap nɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bo mankɛm abhɛn bachi arɛ bághɔ́ yi ndu ákɔ̀ ambɨti nɔkɔ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Bárɨ́ŋɨ bɛ yi kɛ áchɔ̀kɔ nɔ́kɔ́ nyaka ndǔ Ɛrɨ́tí Nyǔbha anɛ ɛkɛrákap Mandɛm anɨŋɨ nɔkɔ nkáp. Ɛkʉ bábhák maknkay, nɛ manyu arɔp bhɔ fúfú bɛghɔ ɛnyɨŋ ɛnɛ ɛfakari. ");
INSERT INTO kenNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mmu wu abhat mmʉɛt nɛ Píta nɛ Jɔ̌n kpát bárɔk baghaka amɛm nɛbhʉɛt ɛkɛrákap Mandɛm anɛ bábhɨ̀ŋɨ bɛ Áchá Sólomon. Bo mankɛm bare rɔŋ arɛ ntiɛ́t ntiɛt bɛghɔ ɛnyɨŋ ɛnɛ ɛ́fàkari. Babhak maknkay tontó. ");
INSERT INTO kenNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Píta aghɔ nɔkɔ ndǔ bǒbhɔ bákàp bhɔ, arɛm ntá yap bɛ, “Bɔ̌ma, bo Israɛl, ndaká yi bǎchí maknkay, mǎmkpɔkɔ nɔkɔ bhɛsɛ ɛnyu ɛyɔ? Bǎkaysi bɛ chi ndǔ bɛtaŋ ɛbhɛsɛ́ kɛ̌ yí ákɔ̀ nɛ́nɛ kɛ? Nɛ puyɛ̌ chi bɛ sɛ́chày Mandɛm tontó. ");
INSERT INTO kenNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Mandɛm bachǐmbɨ bhɛsɛ, Mandɛm Ábraham nɛ Áisek nɛ Jekɔ́p kɛ achyɛ mǔbɛtok ywi Yesu kɛnókó. Achyɛ́ yi kɛnókó yɛ̌ndu be bǎrɛ̀m nyaka bɛ bǎbhɨkɨ bhɔŋ yɛ̌nyɨŋ bɛkʉ nɛ yi mpok Páílet áyàŋ bɛfɛrɛ yi amɔ. Bǎsɔ́t yi bǎchyɛ́ ntá bǒbati Rom bɛ mángwáy. ");
INSERT INTO kenNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yesu achí nyaka nyáŋá nɛ chak bɛsí Mandɛm, Yɛ̌ nɔ be kɛka bɛ Páílet ándɔ́ yi andɔk. Bǎrɛ́m bɛ Páílet ándɔ́ chí ngwayti bho andɔk. ");
INSERT INTO kenNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Bǎkʉ́ báwáy yi mmu áchyɛ̀ nɛpɛ́m. Kɛ Mandɛm akʉ yí apɛtnsɛm ndǔ nɛpɛ́m. Bɛsɛ́ sɛ́ghɔ́ nɛ amɨ́k ɛnyɨŋ ɛnɛ ɛfakari. ");
INSERT INTO kenNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Yesu kɛ ákʉ́ mbɛ́ntí nɛ áfáté. Ɛnyɨŋ ɛnɛ bǎghɔ́ nɛ ɛnɛ́ bǎrɨ́ŋɨ́ bɛ ɛfakari, mɛnkɛm bɛ́chí ɛnyu yɔ mbɔnyunɛ sɛ́sɨ́kɨ́ ntɨ nɛ yi. Chí ndu sɛ́sɨ́kɨ́ ntɨ nɛ yí kɛ ɛ́kʉ mbɛ́ntí nɛ áfáté kpɛrɛp mbɔ ɛnyǔ bě mankɛm bǎghɔ́. ");
INSERT INTO kenNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Bɔ̌ma, nɛ́nɛ ndɨ́ŋɨ́ ká bɛ́ be nɛ bǒ batí bhɛka bǎchí nyaka chi amɛm ɛjuri bɛyɨŋɨ ɛnyɨŋ ɛnɛ bǎkʉ́ ntá Yesu. ");
INSERT INTO kenNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kɛ ɛnyɨŋ ɛnɛ Mandɛm ákʉ́ barɛmɛ́ kɛpɨ̌ntɨ bhi bághátí bo tɛsáy bɛ, Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò, abhɔŋ bɛghɔ ɛsɔŋɔri, Mandɛm akʉ yɔ ɛfu tɛtɛp.” Tɨ́k yɛ́ ka nsɛm ndǔ bɛbʉ́ ɛbhɛka, mámpɛtnsɛm ntá Mandɛm, bɛ yi amfoŋori bɛbʉ́ ɛbhɛka. ");
INSERT INTO kenNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Mbák mǎnkʉ ɛnyu yɔ, Acha ǎkʉ mǎmbɔŋ mpok nɛywɛ̌mʉɛt ndǔ bɛfóŋó ɛbhɛka, ");
INSERT INTO kenNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","antó be Mpɛmɛ yi afyɛ́ nyaka bariɛp bɛ ǎtò bɛ ambak Mpɛmɛ yɛka. ");
INSERT INTO kenNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Yí wu chi Yesu mmu ábhɔ́ŋɔ́ bɛbhak amfay nɛ Mandɛm kpátɛ mpok anɛ yi ákʉ̀ mɛnyɨŋ mɛnkɛm mɛ́njíbhírí mɛ́ndɔp bɛkɔ. Barɛmɛ́ kɛpɨ̌ntɨ Mandɛm mánáŋ bárɛm tɛntɛp bɛ chɔŋ ɛ́mbak ɛnyu yɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses arɛm nyaka bɛ, “Chɔŋ Mandɛm Acha antó be ndɛmɛkɛpɨ̌ntɨ ywi mbɔ ɛnyǔ yi ato mɛ. Nɛ chɔŋ yi ambak mmu ywɛka amɔt nɛ bǎbhɔŋ bɛkʉ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ yi ághàti bhe mǎnkʉ. ");
INSERT INTO kenNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nɛ chɔŋ ɛmbak bɛ yɛ̌ agha anɛ apu ghok ndɛmɛkɛpɨ̌ntɨ wu, báfap yi nɛ bǒ Mandɛm, mangway. ");
INSERT INTO kenNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Samuɛl nɛ barɛmɛ́ kɛpɨ̌ntɨ abhɛn báfú yi ansɛm, mankɛm bárɛm nyaka nkwɔ́ ɛ̌ti mɛnyɨŋɨ́ maknkay ɛbhɛ́n bɛ́fàkari manywɔp anɛ́ ɛchɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Mɛnyɨŋ ɛ́bhɛn barɛmɛ́ kɛpɨ̌ntɨ bárɛ́mɛ́ mɛnkɛm bɛ́yɨŋɨ bhe. Nɛ nku anɛ Mandɛm ányú nyaka nɛ bachǐmbɨ bhɛka, ányu nɛ be nkwɔ́, mbɔnyunɛ arɛm nyaka ntá Ábraham bɛ, ‘Chɔŋ mfʉɛ́t ntá bɛbhárɛ́bhɔ bhɛ ńjɛt manɛrɛ́kɛrɛ́ mmɨk ankɛm.’ ");
INSERT INTO kenNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ɛ̌ti yɔ kɛ ɛchi bɛ Mandɛm ayap nyaka mǔbɛtok ywi, ayambɨ átó yi chi ntá yɛka bɛ́ ánjɛ́t be ndǔ ákʉ̀ be mandɔ́ nɛpɛ́m bɛbʉ́ ɛnɛka.” ");
INSERT INTO kenNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ɛnɛ́ Píta nɛ Jɔ̌n bághàti bo mɛnyɨŋ ɛnyu yɔ, mbɔk bachiǎkap Mandɛm nɛ mǔnti babhabhɛri ɛkɛrákap nɛ mbɔk bǒnkwɔ Sádusi bátwɔ́ ntá yap. ");
INSERT INTO kenNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Batɨ ábé bhɔ mbɔnyunɛ Píta nɛ Jɔ̌n bátɔ̀ŋ mángati nɔkɔ bo bɛ́ Yesu apɛtnsɛm ndǔ nɛpɛ́m bɛtɔŋ bɛ chɔŋ bawú mámpɛtsɛm ndǔ nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Bákɛ́m Píta nɛ Jɔ̌n bárɔ́k báfe, nɛ tɛ̌ndu beku mɛnaŋ bɛ́gháká nyaka, barɔ bhɔ arɛ tɛ ntɨnywɔp. ");
INSERT INTO kenNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Yɛ̌ nɔ, bɛyǎ bo abhɛn bághókó ɛnyɨŋ ɛnɛ Píta nɛ Jɔ̌n bághátí bhɔ, mánóko. Mpǎy bakoŋo Yesu mankɛm akó aghaka mbɔ nká ɛtay. ");
INSERT INTO kenNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Nɛ́yí nɔ́kɔ́, bakɛmɛ́ ɛtɔk nɛ bǒ batí bo Israɛl, nɛ batɔŋ ɛbhé Mandɛm bákɛ́m ɛchɛmɛ amɛm ɛtɔk Yerúsalɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ánas mǔngo bachiǎkap Mandɛm, nɛ Káyfas, nɛ Jɔ̌n, nɛ Aleksánda, nɛ bǒnɛrɛ́kɛt mǔngo bachiǎkap báchɛm nɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Básɔ́t Píta nɛ Jɔ̌n bákʉ bɔ́ báte bɛsí bhap, bábhɛ́p yɛ bhɔ bɛ, “Ndu nnyɛ́n agha bákʉ̀ mɛnyɨŋ ɛbhɛn? Agha áchyɛ́ bhe bɛtaŋ bɛkʉ bhɔ?” ");
INSERT INTO kenNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ndǔ bɛtaŋ Ɛfóŋó Bɛdyɛrɛ, Píta akɛmɛ bhɔ́ bɛ, “Bě bakɛmɛ́ ɛtɔk nɛ bǒ batí ɛtɔk, ");
INSERT INTO kenNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","mbák bábhɛ̀p bhɛsɛ ɛchɔŋ ɛ̌ti bɛrɨ̌ ɛbhɛn sɛ́kʉ́ ntá mbɛ́ntí-nɛ, nɛ ɛnyǔ ɛ́fákárí kɛ yi ǎtaŋ, ");
INSERT INTO kenNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Bě mankɛm nɛ bo Israɛl mankɛm dɨŋɨ́ ká bɛ chí Yesu Kristo mmu Násárɛt kɛ ákʉ́ mmǔ-nɛ ataŋa. Yí mmu bágó ndǔ ɛkotákátí, kɛ̌ Mandɛm akʉ yí apɛtnsɛm ndǔ nɛpɛ́m, ndǔ bɛtaŋ ɛbhi kɛ̌ bǎghɔ́ mmǔ-nɛ áté be bɛsí kpɛrɛp. ");
INSERT INTO kenNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Nkúbhɛ́ Yesu kɛ̌ Ɛkáti Mandɛm ɛ́rɛ̀m ɛ̌ti yi bɛ́: ‘Ntay ɛnɛ́n bě batě bɛkɛt bǎbyáká, nɔ́ kɛ nɛ́rɔ́bhɛ́ ɛkwap ɛnɛ́ ɛ́kɛ́mɛ́ ɛkɛt.’ ");
INSERT INTO kenNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ndiɛrɛ yí kɛ ákway bɛpɛmɛ bhɛsɛ. Mmu achak apú fá amɨk anɛ Mandɛm achyɛ bɛ ampɛmɛ bhɛsɛ.” ");
INSERT INTO kenNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Bo ɛchɛmɛ́ bǒ batí ɛtɔk bághɔ́ nɛtaŋántɨ Píta nɛ Jɔ̌n ndǔ bárɛ̀m kɛpɨ kɛbhɔŋ bɛcháy nɛ ndǔ bághɔ́ nkwɔ bɛ́ bɔPíta báchí chí ndɛ́ndɛmɛ́ bho, nɛ bɛ bɔ bábhɨ́kɨ́ ghɔk ɛkáti, bábhák maknkay. Kɛ bághɔ́ bɛ bɔPíta mánáŋ bákɔ̀ nyaka nɛ Yesu. ");
INSERT INTO kenNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nɛ ndu bághɔ́ mbɛ́ntí anɛ bákʉ́ yi ataŋa nɛpak Píta nɛ Jɔ̌n, manyu áchók bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ɛ́kʉ́ bátɛ́n kpɨ́k bɔ́ nɛfí. Bábho bɛsokori mámbɛbhɛ nɔkɔ batɨ bɛ, ");
INSERT INTO kenNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Chɔŋ sɛ́nkʉ yi nɛ bǒbhɛ́n? Bǒ mankɛm fá ɛtɔk Yerúsalɛm baghɔ ɛrɛmɛ́ ɛnyɨŋɨ́ maknkay ɛnɛ́ bɔ́ bákʉ́ nɛ sɛ́pú kway bɛtaŋa. ");
INSERT INTO kenNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kɛ ndu bɛkʉ bɛ mbok anɛ ákɛ́pɛrɛ taka ɛtɔk, sɛ́bhɔŋ bɛya bǒbhɛn batú bɛ bákɛ́pɛrɛ rɛm yɛ̌nyɨŋ ntá mmu ndǔ nnyɛ́n Yesu.” ");
INSERT INTO kenNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Bábhɨ́ŋɨ yɛ bhɔ bápɛtnsɛm amɛm áchá. Básɛ́mti bhɔ́ bɛ bakɛpɛrɛ rɛm nɛ bakɛpɛrɛ tɔ́ŋ yɛ̌nyɨŋ ndǔ nnyɛ́n Yesu. ");
INSERT INTO kenNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Kɛ Píta nɛ Jɔ̌n bákɛ́mɛ bhɔ bɛ, “Bě babhɔŋ bɛ́p ká mmʉɛt ɛyɛka ndak anɛ. Ɛnyɨŋ ɛnɛ ɛ́chí chak bɛsí Mandɛm chi ɛnɛ́? Bɛ́ghok bhe kɛ chi bɛghok Mandɛm? ");
INSERT INTO kenNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Sɛ́pú kwáy bɛrɔ bɛrɛm ɛ̌ti mɛnyɨŋ ɛbhɛn sɛ́ghɔ́ nɛ amɨ́k nɛ sɛ́ghók nɛ batú.” ");
INSERT INTO kenNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Nkwɔ ɛchɛmɛ bǒbati ɛtɔk bapɛt básɛ́mtí nɔ́kɔ́ bhɔ, báfɛrɛ bhɔ amɔ. Bɔ́ kɛbhɔŋ mbi bɛtɛmsi bɔPíta mbɔnyunɛ bǒ mankɛm bákàka nyaka Mandɛm ndǔ ɛnyɨŋ ɛnɛ ɛfakari. ");
INSERT INTO kenNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Nɛ mamiɛ́ mbɛ́ntí wu acha nyaka bɛsa bɛpay. ");
INSERT INTO kenNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Báfɛ́rɛ́ nɔkɔ Píta nɛ Jɔ̌n amɔ, bápɛtnsɛm ntá batɨ̌ bǒnkwɔ Yesu, baghati bhɔ ɛnyɨŋ ɛnɛ bǒbatí ɛkɛrákap Mandɛm nɛ bǒbati ɛtɔk bárɛ́mɛ́ ntá yap. ");
INSERT INTO kenNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Bakoŋo Yesu bághókó nɔ́kɔ́ nɔ, bɔ́ mankɛm babho mɛnɨkmʉɛt ntá Mandɛm mándɛmɛ nɔkɔ bɛ; “Ɛta, wɔ ɔchí Acha, wɔ kɛ ɔ́ghókó mfay nɛ mmɨk, nɛ manyɛ́n nɛ mɛnyɨŋ mɛnkɛm ɛbhɛn bɛ́chí arɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Wɔ kɛ ɔ́kʉ́ nyaka bɛ mǔbɛtok ywɛ Mfɔ Debhít, chi-mbɨ ywɛsɛ́, ándɛm ndǔ bɛtaŋ Ɛfóŋó Bɛdyɛrɛ bɛ: ‘Ndaká yí bo abhɛn bápú bo Israɛl bábèntɨ nɛ wɔ Mandɛm? Ndaká yí bǒbhɛn bátè bɛyu ɛbhɛn bɛbhɨkɨ bhɔŋ ntí nɛ nnɛt? ");
INSERT INTO kenNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Bafɔ̌ mmɨk bátòŋtí mmʉɛt mɛ́nu nɛnu, bǒbatí ɛtɔk báchɛm nɛbhʉɛt amɔt, báte ɛyu mɛnu nɛ Mandɛm Acha nɛ Mpɛmɛ yí afyɛ́ nyaka bariɛp bɛ ǎtò.’ ");
INSERT INTO kenNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Hɛ́rɔd nɛ Pɔ́ntiɔs Páílet báchɛm nɛ bo Israɛl nɛ mbɔk bo abhɛn bápú bo Israɛl fá amɛm Yerúsalɛm, báte ɛyu antí Yesu mmǔ bɛtok ywɛ anɛ achi nyáŋá. ");
INSERT INTO kenNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Báchɛ́m bɛkʉ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ ɔ́náŋ ɔ́bhʉ́rɛ́ nyaka bɛ chɔŋ ɛ́mfakari. ");
INSERT INTO kenNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Acha, ghɔ́ yɛ ndǔ bápà bhɛsɛ. Kʉ bɛ bhɛsɛ́ bǒ bɛtok abhɛ, sɛ́ngátí nɔ́kɔ́ bho Ɛyɔŋ ɛyɛ nɛ nɛtaŋántɨ nɛnkɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Chiɛ́ bhɛsɛ bɛtaŋ bɛbú bǒmame, nɛ bɛtɔŋ bɛrɨŋɨ́ maknkay nɛ bɛkʉ mɛnyɨŋɨ́ maknkay ndǔ nnyɛ́n mǔbɛtok ywɛ Yesu, mmu achi nyáŋá.” ");
INSERT INTO kenNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Mánáŋá nɔ́kɔ́ mɛnɨkmʉɛt, nɛbhʉɛt anɛ bɔ bachi arɛ anyɨkɨsi. Ɛfóŋó Bɛdyɛrɛ abhak nɛ bhɔ tontó akʉ bábhó bɛghati Ɛyɔŋ Mandɛm kɛbhɔŋ bɛcháy. ");
INSERT INTO kenNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nkwɔ́ bo abhɛn mánókó Yesu bábhɔ́ŋ ntɨ nɛ́mɔt nɛ nkaysi amɔt. Yɛ̌ mmu wap akɛ rɛm bɛ mɛnyɨŋ ɛbhi bɛ́chí chí ndiɛrɛ ntá yi aywǐntí. Ɛnyɨŋ yɛ̌ntɨkɨ mmu ɛbhak ɛnyɨŋ ɛyap mankɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Bǒnto Yesu báré ghati bo nɛ bɛtaŋ ɛbhap mɛnkɛm bɛ Yesu Acha apɛtnsɛm ndǔ nɛpɛ́m, nɛ bɛrɨ̌ndu Mandɛm bɛbhak nɛ bɔ mankɛm tontó. ");
INSERT INTO kenNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Yɛ̌ mmu wap abhɨkɨ chɛ́p nyaka ɛnyɨŋ mbɔnyunɛ abhɛn bábhɔ́ŋɔ́ bakɨ nɛ yɛ̌ chi bɛkɛt, bátì nyaka mɛnyɨŋ ɛbhɔ mántwɔ nɛ nkáp ");
INSERT INTO kenNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","mámbʉrɛ bɛsí bǒnto, nɛ bɔ mánkɔrɛ nkáp wu bɛkoŋo nté anɛ yɛ̌ntɨkɨ mmu wap. ");
INSERT INTO kenNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ɛnyu yɔ kɛ̌ mmǔ anɛ áká nnyɛ́n bɛ Josɛ́f akʉ nyaka. Abhak mmu nnɛrɛ́kɛt Lɛ́vi nɛ mmu ɛtɔk Sáyprɔs. Bǒnto Yesu bádú yí nnyɛ́n bɛ́ Banábas, nɔ́ chí, “Mmǔ anɛ afyɛ́ bo ntɨ.” ");
INSERT INTO kenNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Abhɔ̌ŋ nyaka nkɨ, atí wú, atwɔ́ nɛ nkáp, abhʉrɛ bɛsí bǒnto Yesu. ");
INSERT INTO kenNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kɛ ɛwak ɛmɔt, mmǔ anɛ aka nnyɛ́n bɛ Ananías nɛ ngɔrɛ́ aywi Safíra bátí nɛbhʉ́ɛ́rɛ́mɨk. ");
INSERT INTO kenNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananías abhɛsɛ mbɔk nkáp ansɛm. Ngɔrɛ́ aywi arɨŋɨ bɛ yi akʉ nɔ. Asɔt anɛ́ árɔ́bhɛ́ arɔk abhʉrɛ bɛsí bǒnto Yesu. ");
INSERT INTO kenNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Kɛ Píta abhɛp yi bɛ, “Ananías, ndaká yí ɔ́rɔ́ Satan ánkó wɔ́ antí bɛ ɔ́nsé nsé ntá Ɛfóŋó Bɛdyɛrɛ nɛ ɔrɔ mbɔk nkáp anɛ ɔ́tí mmɨk ansɛm? ");
INSERT INTO kenNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Mpok ɔ́bhɨ́kɨ́ re tí yɔ́, mmɨk achi nyaka chi ayɛ. Nɛ mpok ɔ́tí yɔ́ nkáp abhak chi aywɛ. Ndaká yí ɔkaysi bɛkʉ ɛnɛ ɛnyǔ ɛnyɨŋ? Ɔsensé chi ntá Mandɛm, puyɛ̌ ntá nkwǎ!” ");
INSERT INTO kenNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nɛghók Ananías ághókó bɛyɔŋ ɛbhɛn, akwɛ́n amɨk agú. Bɛyǎ bɛcháy bɛ́kɛm yɛ̌ntɨkɨ mmu anɛ ághoko ndak anɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Bɛsak báchwe, mánɛ́p yi nɛ ndɛn, bápɔ́kɔ, barɔk babhɛmɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ɛ́fʉɛ́rɛ́ nɔ́kɔ́ mbɔ maŋɔk nywɔp arat, ngɔrɛ́ Ananías achwe anywɔ́p, yi kɛrɨŋɨ ɛnyɨŋ ɛnɛ ɛfakari. ");
INSERT INTO kenNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Píta abhɛ́p yi bɛ, “Ghatí mɛ tɛtɛp, nkáp ankɛm anɛ́ wɔ nɛ nnɛ́m aywɛ bǎtí mmɨk nɛ?” Akɛmɛ bɛ, “Ɛɛ, yɨŋɨ wu ankɛm nɔ.” ");
INSERT INTO kenNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Píta arɛm bɛ, “Ná wɔ nɛ nnɛ́m aywɛ bǎká ɛyɔŋ ɛ́mɔt mɛmɔ Ɛfóŋó Mandɛm Acha ɛnyǔ ɛyɔ? Ghok! Bo abhɛn bábhɛ́mɛ́ nnɛ́m aywɛ, báchi afɔ ambǐnywɔp, nɛ chɔŋ mampɔkɔ wɔ nkwɔ.” ");
INSERT INTO kenNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tɛ́mté wu, Safíra akwɛ́n bɛkak Píta agú. Bɛsak báchwé nɔ́kɔ́ bághɔ́ bɛ agu, bápɔkɔ bafu barɔk babhɛmɛ kɛkwɔt nɛ nnɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Bɛyǎ bɛcháy bɛkɛm bǒnkwɔ Yesu mankɛm nɛ yɛ̌ntɨkɨ mmu achak anɛ aghoko ɛnyɨŋ ɛnɛ ɛfakari. ");
INSERT INTO kenNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Bǒnto Yesu báre kʉ bɛyǎ mɛnyɨŋɨ́ maknkay bɛchak bɛsí bo ndǔ bɛtaŋ Mandɛm. Báre chɛm nɛbhʉɛt amɔt amɛm nɛbhʉɛt ɛkɛrákap anɛ bábhɨ̀ŋɨ nyaka bɛ Acha Sólomon. ");
INSERT INTO kenNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Yɛ̌ mmu achak kɛchɛm nɛ bhɔ ɛ̌ti bɛcháy, kɛ bo báre chyɛ̀ bhɔ kɛnókó. ");
INSERT INTO kenNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Nɛ bɛyǎ bo, baghɔrɛ́ nɛ babhakanɛm, báré noko, manchɛm nɔkɔ mmʉɛt nɛ nkwɔ́ Yesu. ");
INSERT INTO kenNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ɛ̌ti mɛnyɨŋɨ́ maknkay ɛbhɛn bǒnto bákʉ̀, bo báré pɔkɔ́ bǒmame mámbʉrɛ nɔkɔ nɛpaká mbi, mbɔk ndu bɛkɔ́k, bachak ndu bɛ̌sak, bɛ́ Píta apɛrɛ́ fʉɛt ndɨkandi ywi ánkwɛ́n mbɔk ayap amʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Bɛyǎ bo bare fu ndǔ bɔ̌bɛtɔk abhɛn bachí kɛkwɔt nɛ Yerúsalɛm, mándɔkɔ nɔkɔ nɛ bǒmame, nɛ abhɛ́n bɛfóŋó bɛbʉ́bɛbʉ bɛ́sɔ̀ŋɔri bhɔ. Bɔ mankɛm bataŋ. ");
INSERT INTO kenNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kɛ mǔngo bachiǎkap nɛ bǒ mankɛm abhɛn bachi nɛ yi, nɔ chi bǒnkwɔ Sádusi, bábhɔ́ŋ bɛyǎ mpap amɨ́k. ");
INSERT INTO kenNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Bákɛ́m bǒnto báfyɛ́ ɛkɛrɛ́kɛnɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Kɛ ángɛl Mandɛm atwɔ́ nɛ bɛti, anɛnɛ babhǐnywɔp ɛkɛrɛ́kɛnɔŋ, asɔt bɔ́ báfú, arɛm bɛ ");
INSERT INTO kenNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Dɔ́k ká amɛm ɛkɛrákap Mandɛm, mǎnte, mǎngati bo yɛ̌ntɨkɨ ɛnyɨŋ ɛ̌ti nɛpɛ́m nɛkɔ ɛnɛn.” ");
INSERT INTO kenNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nɛ́yí nɔ́kɔ́, bárɔ́k bachwe amɛm ɛkɛrákap Mandɛm bábhó bɛtɔŋ bo mbɔ ɛnyǔ ángɛl aghati bhɔ. Mǔngo bachiǎkap nɛ nkwɔ́ ywi bábhɨŋɨ bǒbati ɛtɔk Israɛl mankɛm, bákɛ́m ɛchɛmɛ, bachyɛ ɛyɔŋ bɛ mandɔ́k mamfɛrɛ bǒnto ɛkɛrɛ́kɛnɔŋ mantwɔ nɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Babhabhɛri abhɛn ɛkɛrákap báchwɔ́p arɛ, kɛghɔ bhɔ. Bápɛtnsɛm nɛ ɛyɔŋ bɛ, ");
INSERT INTO kenNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Sɛ́rɔŋ, sɛghɔ babhǐnywɔp femfé, nɛ babhabhɛri nɛfí téé, kɛ sɛ́nɛ́nɛ́ nɔ́kɔ́ babhǐnywɔp, sɛbhɨkɨ ghɔ́ yɛ̌ mmu amɛm.” ");
INSERT INTO kenNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Mǔnti babhabhɛri ɛkɛrákap Mandɛm nɛ bǒ batí bachiǎkap baghoko nɔkɔ nɔ, batí átáka bhɔ amɛm, bare bhɛp mmʉɛt ɛyap ɛnyɨŋ ɛnɛ ɛfakari nɛ bǒnto Yesu. ");
INSERT INTO kenNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ɛbhɨkɨ tat, mmu amɔt achwe aghati bhɔ bɛ, “Ghók ká, bo abhɛn bǎfé ɛkɛrɛ́kɛnɔŋ ɛ́yu, báchí awu amɛm ɛkɛrákap téé bátɔ̀ŋ bo.” ");
INSERT INTO kenNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Mǔnti babhabhɛri ɛkɛrákap nɛ bǒbhi bárɔk basɔt bǒnto, kɛ bákɛ tɔk bɔ́ awɔ amʉɛt ndǔ báchày bɛ bo bákɛ́ tɛmti bɔ́ nɛ batay mangway. ");
INSERT INTO kenNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Bápɛ́rɛ́ nɔ́kɔ́ nɛ bhɔ, bakʉ bɔ baté bɛsí ɛchɛmɛ bǒbati ɛtɔk. Mǔngo bachiǎkap abhɛ́p bɔ́ bɛ ");
INSERT INTO kenNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Sɛ́yɛp be batu bɛ bǎkɛ́ pɛrɛ rɛm yɛ̌nyɨŋ ndǔ nnyɛ́n mmǔ-nɛ? Yɛ̌ nɔ, bǎtàk mbok Yesu amɛm Yerúsalɛm nkɛm nɛ bǎyàŋ bɛkʉ ɛmbak bɛ bɛsɛ́ kɛ sɛ́kʉ́ báwáy yi.” ");
INSERT INTO kenNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Píta nɛ bǒnto Yesu mankɛm bakɛmɛ bɛ, “Sɛ́bhɔŋ bɛghok chi Mandɛm, puyɛ̌ nkwǎŋwaŋ. ");
INSERT INTO kenNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mandɛm bachǐmbɨ bhɛsɛ́ akʉ Yesu mmu báwáy ndu bago yi ndu ɛkotákátí ampɛtnsɛm ndu nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Mandɛm akósí yí amfay, afyɛ́ ndǔ nɛbhʉɛt kɛnókó bɛ ambak Mǔntí nɛ Mpɛmɛ, bɛ́ ánchyɛ́ bo Israɛl mbi bɛtɨknsɛm ndǔ bɛbʉ́ bhap Mandɛm amfoŋori bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Sɛ́ghàti bo mɛnyɨŋ ɛbhɛ́n sɛ́ghɔ́ nɛ amɨ́k mbɔ batísiɛ, nɛ Ɛfóŋó Bɛdyɛrɛ mmu Mandɛm achyɛ́ ntá bo abhɛn bághòk yi achi ntísiɛ nkwɔ.” ");
INSERT INTO kenNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Bǒ ɛchɛmɛ bǒbatí ɛtɔk bághókó nɔ́kɔ́ nɔ, batɨ ábe bhɔ tontó. Bábho bɛyaŋ mbi ndu bɛ́way bǒnto Yesu. ");
INSERT INTO kenNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kɛ mǔnkwɔ Fárisi amɔt, anɛ áká nnyɛ́n bɛ Gamáliɛl, abhak arɛ́. Abhak mmu ɛchɛmɛ́ bǒ batí amɔt nkwɔ́ nɛ ntɔŋ ɛbhé Mandɛm. Bǒ mankɛm báchyɛ̀ nyaka yi kɛnókó. Afate achyɛ ɛyɔŋ bɛ mántɛn kpɨk bǒnto Yesu nɛfí. ");
INSERT INTO kenNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Arɛm yɛ ntá bǒbati ɛtɔk bɛ, “Bo Israɛl, sɔt ka mpok ndǔ ɛnyɨŋ ɛnɛ́ bǎkáysi bɛkʉ nɛ bǒbhɛn. ");
INSERT INTO kenNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Dɨŋɨ́ ká bɛ Tiódas árɛ̀m nyaka bɛ yi achi nnɛ́m mmu. Bǒ mbɔ batí bɛsǎ ɛsa (400) babhak bákoŋo bhi. Báwáy nɔ́kɔ́ yi, bakoŋo bhi bhɔ bátáka, nsóŋó ɛyi amay. ");
INSERT INTO kenNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ɛ́tárɛ́ nɔ́kɔ́, Júdas mmu Gálili nkwɔ afú mpok básɔ̀t mpǎy bho. Aya mbɔk bho báré koŋo yí. Yi nkwɔ agú, nɛ bɛyǎ bo abhɛn bákòŋo nyaka yi bátáka. ");
INSERT INTO kenNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Bɛ́yɨŋɨ yɛ ndak anɛ, nchí ghati beka bɛ mǎndɔ́ bǒbhɛn, bǎkɛ́ kʉ bhɔ́ yɛ̌nyɨŋ. Mbák nkaysi-nɛ, nɛ mɛnyɨŋ ɛbhɛn bɔ batɨ̌ bɛkʉ bɛfu chí ntá nkwǎ, chɔŋ mánkwɛn. ");
INSERT INTO kenNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Kɛ mbák bɛfu chi ntá Mandɛm, bǎpú kway bɛchyɛt bhɔ mbi. Bǎkway mbɔŋ bɛghɔ bɛ mánù chí nɛ Mandɛm!” ");
INSERT INTO kenNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Bábhɨ́ŋɨ́ nɔ́kɔ́ yɛ bǒnto Yesu, badɛn bɔ, básɛ́mti bhɔ bɛ bákɛ́pɛrɛ rɛm yɛ̌nyɨŋ ndu nnyɛ́n Yesu, barɔ bɔ mándɔ́k. ");
INSERT INTO kenNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Bǒnto báfú bárɔ ɛchɛmɛ bǒbati ɛtɔk bárɔ́k nɛ maŋák mbɔnyunɛ Mandɛm aghɔ bɛ bɔ bakway bo abhɛn bábhɔ̀ŋ kɛyɔ́rɛ́ ɛ̌ti nnyɛ́n Yesu. ");
INSERT INTO kenNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Bɔ kɛrɔ bɛtɔŋ nɛ bɛ́gháti bo Mbok Ndɨ́ndɨ́ bɛ Yesu chi Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò. Báre kʉ nɔ yɛ̌ntɨkɨ nywɔp amɛm ɛkɛrákap Mandɛm nɛ amɛm bɛkɛt ɛbhap. ");
INSERT INTO kenNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mpok yɔ, bakoŋo Yesu báre yá mándɔkɔ nɔkɔ chi ambɨ. Bɛ́táŋá bɛ́kwɛ́n. Bo Israɛl abhɛn bárɛ̀m ɛyɔŋ Grik nkwɔ báré nywinti bɛ abhɛn bárɛ̀m chi ndiɛrɛ ɛyɔŋ bo Israɛl bákɔ̀rɛ mɛnyɨŋ yɛ̌ntɨkɨ ɛwak kɛfyɛ́ ntí ndu bɛchyɛ mánkwɛ́sɛ́ bhap. ");
INSERT INTO kenNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ɛkʉ bǒnto Yesu batí byó nɛ apay bábhɨŋɨ nkwɔ bakoŋo Yesu bárɛm bɛ, “Ɛpú chak bɛ sɛndɔ bɛghati bho Ɛyɔŋ Mandɛm, sɛ́ndɔbhɛ taŋ chi baraká nɛnyɛ́. ");
INSERT INTO kenNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Bɔ̌ma, yap yɛ ka bǒbati tándrámɔt. Bábhɔŋ bɛbhak bo abhɛn bo bárɛ̀m ɛrɨ́rɨ́ ɛ̌ti yap, mámbak bo abhɛn Ɛfóŋó Bɛdyɛrɛ achi nɛ bhɔ sayri, nɛ mámbak barɨŋɨ́ndak. Yap ka bhɔ́. Sɛ́kway bɛchyɛ bhɔ bɛtɨk ɛbhɛn. ");
INSERT INTO kenNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Mbák ɛchi nɔ́, chɔŋ sɛ́mbɔ́ŋ mpok bɛchyɛ mmʉɛt ndǔ nɛnɨkɨ́mʉɛt, nɛ ndu bɛ́ghati bho Mbok Ndɨ́ndɨ́ nɛ ndu bɛ́tɔŋ Ɛyɔŋ Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Bǒnkwɔ mankɛm bábhɔ́ŋ maŋák ɛ̌ti ɛnyɨŋ ɛnɛ bǒnto barɛmɛ. Báyáp Stífin mmu amɔt anɛ abhɔŋɔ nɛka nɛ Yesu tontó nɛ Ɛfóŋó Bɛdyɛrɛ achi nyaka nɛ yi mpoknkɛm. Báyap Fílip nkwɔ́, nɛ Prokórɔs, nɛ Nikanɔ́, nɛ Tímɔn, nɛ Pamɛ́nas, nɛ Níkolas, kɛnkɔ anɛ áfú nyaka Antiɔk. Anáŋ áchyɛ̀ nyaka Mandɛm kɛnókó mbɔ ɛnyǔ bo Israɛl bákʉ̀ kɛ ǎnoko Yesu. ");
INSERT INTO kenNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Básɔt bhɔ bɛsí bǒnto Yesu. Bǒnto mánɨkmʉɛt mányáŋa bɔ́ amɔ anti. ");
INSERT INTO kenNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ɛyɔŋ Mandɛm ɛ́re go ɛndɔk nɔkɔ chi ambɨ, nɛ mpǎy bakoŋo Yesu ayá tontó amɛm ɛtɔk Yerúsalɛm. Bɛyǎ bachiǎkap Mandɛm nkwɔ́ báre noko Mbok Ndɨ́ndɨ́. ");
INSERT INTO kenNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stífin chí mmu anɛ Mandɛm átɔ́ŋ bɛyǎ bɛrɨ̌ndu, achyɛ yí bɛyǎ bɛtaŋ. Stífin akʉ bɛrɛm mɛnyɨŋɨ́ maknkay nɛ atɔ́ŋ bɛrɨŋ bɛsí bo. ");
INSERT INTO kenNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Mbɔk bo báfate bábhó bɛkɛm ɛpʉ́ítí nɛ yi. Bábhak bǒ ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí ɛnɛ bo abhɛn báfɛ́rɛ́ ndǔ kɛsɛm. Ɛnyu ɛyɔ kɛ bábhɨŋɨ nyaka yɔ. Bábhák bo Israɛl abhɛn bafu Síren nɛ mmu Aleksánda. Bɔ́bhɔ nɛ bo Israɛl bachak abhɛn bafu atú Silísha nɛ Esia bare kɛm ɛpʉ́ítí nɛ Stífin. ");
INSERT INTO kenNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Kɛ bɔ kɛkwáy bɛkɛmɛ ɛnyɨŋ ɛnɛ yi árɛ́mɛ́ nɛ nɛrɨŋɨ́ndak ɛnɛn Ɛfóŋó Bɛdyɛrɛ achyɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Bákú bo mámpu bɛ bághok ndǔ yi árɛ̀m ɛbʉ́bʉ ɛ̌ti Moses nɛ ɛ̌ti Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ɛnyu yɔ kɛ̌ mányɨkɨsí batɨ̌ bǒ batí ɛtɔk amɛm, nɛ batɨ batɔŋ ɛbhé Mandɛm, nɛ batɨ bǒ mankɛm. Bákɛ́m yɛ Stífin barɔk bɛsí ɛchɛmɛ bǒ batí ɛtɔk nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Bátwɔ́ nɛ batísyɛ ákwárɛ́ abhɛn bárɛ́mɛ́ bɛ, “Mmǔ-nɛ apú rɔ bɛrɛm ɛbʉ́bʉ mpoknkɛm ɛ̌ti ɛkɛrákap Mandɛm ywɛsɛ́ nɛ nɛ ɛ̌ti ɛbhé Moses. ");
INSERT INTO kenNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Sɛ́ghok ndǔ yi árɛ̀m bɛ chɔŋ Yesu Mmǔ Násárɛt wu amokoti ɛkɛrákap Mandɛm ɛnɛ, nɛ angupsi bɛpɨŋ ɛtɔk ɛbhɛn Moses árɔ́ ntá yɛsɛ.” ");
INSERT INTO kenNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Bǒ mankɛm abhɛn báchí amɛm ɛkɛrɛ́ manyé chɔkɔ, batɛp Stífin amɨ́k amʉɛt, bághɔ́ bɛ́ bɛsí bhi bɛ́yibhiri bɛrɔbhɛ ghɔɔ chi mbɔ ɛbhɛ́n ángɛl Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mǔngo bachiǎkap Mandɛm abhɛ́p Stífin bɛ “Ɛchi tɛtɛp bɛ ɔkʉ barak anɛ bárɛ̀m nɔ bɛ ɔkʉ?” ");
INSERT INTO kenNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stífin akɛmɛ bɛ, “Bɔmá nɛ bɔta, ghók ka mɛ! Mandɛm bɛtaŋ mɛnkɛm abhesi nyaka ntá chi-mbɨ aywɛsɛ́ Ábraham mpok yi achi atú Mɛsopotemia kɛ árɔ̀ŋ ɛtɔk Haran, ");
INSERT INTO kenNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","arɛm ntá yi bɛ, ‘Fǎ ɛtɔk ɛyɛ, dɔ̌ nnɛrɛ́kɛt aywɛ dɔ́k atú anɛ mɛ́tɔ̀ŋ chɔŋ wɔ.’ ");
INSERT INTO kenNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ábraham afa yɛ atú bo Cháldia wu, arɔk achɔkɔ ɛtɔk Háran. Ɛtayi ágú nɔ́kɔ́, Mandɛm akʉ yi afa arɛ́ atwɔ́ ndǔ mmɨk anɛ bǎchí arɛ́ ɛchɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ábraham abhak fá, yɛ̌ nɔ, Mandɛm kɛchyɛ yí yɛ̌ chí mɔ́nɛbhʉɛ́rɛ́ mmɨk. Afyɛ́ chí bariɛp bɛ́chyɛ mmɨk ntá yi nɛ ntá bɛbhárɛ́bhɔ bhi yɛ̌ndu yi abhɨkɨ bhɔŋ nyaka mmɔ́. ");
INSERT INTO kenNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Mandɛm arɔk ambɨ bɛ́ghati yi bɛ: ‘Chɔŋ bɛbhárɛ́bhɔ bhɛ mámbak mankɔ amɛm ɛtɔk bǒ bachak. Bǒ bhɔ mambʉrɛ bhɔ ndu kɛsɛm, mánchyɛ nɔkɔ bhɔ bɛyǎ ɛsɔŋɔri ndu mamiɛ́ bɛsǎ ɛsa. ");
INSERT INTO kenNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Kɛ chɔŋ nchyɛ́ ntɛ́msí ntá bǒ ɛtɔk ɛnɛ́ bɔ bátòk. Nɛ ansɛm mpok, chɔŋ mámfa mántwɔ, mánchyɛ̀ nɔkɔ mɛ kɛnókó fá.’ ");
INSERT INTO kenNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Mandɛm anyú yɛ nku nɛ Ábraham. Ɛrɨŋɨ́ nku yɔ ɛbhak nɛsiɛ́p anɛ básiɛ̀p bɔ̌babhakanɛm. Ábraham abhé nɔ́kɔ́ yɛ Áisek, asiɛ́p yi mpok yi ágháká manywɔp ánɛn. Áisek ábhé Jekɔ́p, Jekɔ́p abhak chi ntá bɔ̌ bati byo nɛ apay abhɛn báchí nyaka bachǐmbɨ manɛrɛ́kɛt bo Israɛl. ");
INSERT INTO kenNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Bachǐmbɨ bhɔ bábhɔ́ŋ mpabhamɨ́k nɛ mɔ́máyap Josɛ́f. Bátǐ yi mbɔ nsɛm ntá bakɔ̌siɛ, Bɔ́ bárɔ́k ɛtɔk Íjip nɛ yi. Kɛ Mandɛm abhak nɛ yi, ");
INSERT INTO kenNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","afɛrɛ yí ndǔ bɛsɔŋɔri ɛbhi mɛnkɛm, atɔ́ŋ yi bɛrɨ̌ndu, nɛ achyɛ́ yi nɛrɨŋɨ́ndak bɛsí Mfɔ Íjip. Mfɔ Íjip achyɛ yi bɛtaŋ amfǎy ɛtɔk Íjip ɛnkɛm, nɛ ɛkɛt ɛyi ɛnkɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ansɛm mpok, nsay akwɛ́n ɛtɔk Íjip ɛnkɛm nɛ ɛtɔk Kánǎn. Ɛkʉ ɛsɔŋɔri ɛya ɛcha. Bachǐmbɨ bhɛsɛ kɛkwáy bɛbhɔŋ nɛnyiɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jekɔ́p ághókó nɔ́kɔ́ yɛ bɛ nɛnyíɛ́ nɛchi Íjip, ató bachi bhɛsɛ arɛ́. Ɛbhak ndɔŋ anɛ mbɨ anɛ bɔ́ bárɔ́ŋɔ́ Íjip. ");
INSERT INTO kenNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nɛrɔ́ŋ anɛ bɔ́ bárɔŋɔ arɛ́ ndɔŋ ɛnɛ́ ɛjwi ɛ́páy, Josɛ́f akʉ bɔ̌mayi bárɨŋɨ yí, nɛ Mfɔ Íjip arɨŋɨ nnɛrɛ́kɛt Josɛ́f. ");
INSERT INTO kenNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Josɛ́f ató yɛ bábhɨŋɨ ɛ́táyi Jekɔ́p nɛ bǒnɛrɛ́kɛt ywi mankɛm, batí bɛsa bɛ́rát nsɛm nɛku. ");
INSERT INTO kenNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jekɔ́p arɔk ɛtɔk Íjip nɛ nnɛrɛ́kɛt ywi ankɛm. Abhak arɛ́ tɛ mpok anɛ yi ágú nɛ bɔ̌bhi bo bachi bachǐmbɨ bhɛsɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Bápɔ́kɔ́ yi bápɛtsɛm Shɛ́kɛm, bábhɛ́mɛ ndǔ nnɛm ɛnɛn Ábraham ákú nyaka ntá bɔ Hamɔ amɛm ɛtɔk Shɛ́kɛm nɛ nkáp sílbhá. ");
INSERT INTO kenNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Mpok anɛ Mandɛm abhɔŋɔ bɛkʉ bariɛp amɛm yi afyɛ́ nyaka nɛ Ábraham aghaka nɔkɔ kɛkwɔt, mpǎy bo Israɛl abhɛn bachi Íjip bɛpɛt baya tontó. ");
INSERT INTO kenNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ɛbhak ɛnyu yɔ kpatɛ mmu achak abhak Mfɔ Íjip anɛ abhɨkɨ rɨŋɨ nyaka Josɛ́f. ");
INSERT INTO kenNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mfɔ wú achyɛ bǒ bhɛsɛ bɛyǎ ɛsɔŋɔri, akʉ bɔtayɛsɛ mándɔ́ bɔ̌bhap nɛfí mángú. ");
INSERT INTO kenNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Mpok yɔ kɛ bábhé Moses. Arɨ́ tontó nɛ Mandɛm akɔŋ yi. Máne yí ɛkɛt ɛtayi ndǔ bataŋ árát. ");
INSERT INTO kenNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Bárɔ́ nɔ́kɔ́ yi nɛfí, mmɔ́ Mfɔ Íjip anɛ ngɔrɛ́, asɔt yi mbɔ mɔ́ywi, ane yi. ");
INSERT INTO kenNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Bátɔ́ŋ yí nɛrɨŋɨ́ kɛpɨ bo Íjip nɛnkɛm, ágó abhak ɛrɨ́tí ndɛmɛ kɛpɨ nɛ nnɛ́m mmu ndu mɛnyɨŋ ɛbhɛn yi ákʉ̀. ");
INSERT INTO kenNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Ágháká nɔ́kɔ́ mamiɛ́ bɛsa bɛ́páy, nkaysi atwɔ́ yi antɨ bɛ ándɔ́k ángɔ́ bɔ̌mayi, bo Israɛl. ");
INSERT INTO kenNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ághɔ́ nɔ́kɔ́ ndǔ mmu Íjip ádɛ̀n mmu Israɛl amɔt, arɔk bɛkwak yi. Akɛmɛ kɛ́mbé, kpát awáy mmu Ijip wu. ");
INSERT INTO kenNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses akaysi bɛ bǒbhi bárɨŋɨ bɛ́ Mandɛm kɛ átó yi ámfɛ́rɛ́ bhɔ́ ndǔ ɛsɔŋɔri, kɛ bɔ́ kɛrɨŋɨ ɛnyu ɛyɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Nɛ́yí nɔ́kɔ́, arɔk atɛmɛri ndu bǒbhi, bo Israɛl bati apay mánù. Achwe bɛkʉ bɔ mambak ɛyɔŋ ɛ́mɔt, arɛm bɛ, ‘Ghók ká, bǎchí bǒ mmu amɔt, ndaká yí mánù nɛ batɨ?’ ");
INSERT INTO kenNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Kɛ anɛ áyáŋ ntɨ mpay, apuri Moses, abhɛ́p yí bɛ, ‘Agha ákʉ́ wɔ mfɔ nɛ ntaŋá manyé yɛsɛ́? ");
INSERT INTO kenNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ɔ́yàŋ bɛ́way mɛ mbɔ ɛnyu ɔ́wáy mmu Íjip ɛ́yú?’ ");
INSERT INTO kenNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moses ághókó nɔ́kɔ́ nɔ, abʉɛ́ arɔk achɔkɔ ɛtɔk Mídia. Arɛ́ kɛ yi ábháy ngɔrɛ́ abhɔ́ŋ bɔ̌ babhakanɛm bati apay. ");
INSERT INTO kenNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Ɛ́fʉɛ́rɛ́ nɔ́kɔ́ mamiɛ́ bɛsa bɛpay, ángɛl Mandɛm abhesi ntá yi amɛm baso, kɛkwɔt Njiɛ Sináy. Ángɛl wu abhak amɛm ngó anɛ ádù ndǔ mɔ́nɔk amɔt anɛ ágò ɛbhɨ. ");
INSERT INTO kenNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ɛnyɨŋ ɛnɛ Moses ághɔ́ ɛkʉ yi abhak maknkay. Nɛ nɛrɔŋ yi árɔ̀ŋ kɛkwɔt bɛyɨŋɨ, aghók Ɛyɔŋ Mandɛm Acha ndu ɛ́rɛ̀m bɛ, ");
INSERT INTO kenNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Mmɛ kɛ nchí Mandɛm bachǐmbɨ bhɛka, Mandɛm Ábraham, Mandɛm Áisek, nɛ Mandɛm Jekɔ́p.’ Nɛ́kóŋó nɛ́kɛ́m Moses, afɛrɛ amɨ́k arɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Mandɛm Acha arɛm yɛ ntá yi bɛ, ‘Fɛrɛ́ nkwɔbhánya ɛyɛ bɛkak, mbɔnyunɛ nɛbhʉɛ́rɛ́mɨk anɛ ɛ́té nɔ arɛ achi nyáŋá. ");
INSERT INTO kenNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ngɔ̌ bɛsɔŋɔri ɛbhɛn bǒbha bábhɔ̀ŋ amɛm ɛtɔk Íjip nɛ ngók nɛdǐ kɛbhɔ ɛnap, nɛ nsɛp ntwɔ bɛfɛrɛ bhɔ́ ndǔ ɛsɔŋɔri ɛyɔ. Twɔ́ yɛ́, chɔŋ ntó wɔ Íjip.’ ");
INSERT INTO kenNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Stífin arɔk ambɨ bɛrɛm bɛ, nkúbhɛ́ Moses anɛ bábhɨ́kɨ́ ka nyaka bɛghok yi, nɛ babhɛp yi bɛ, ‘Agha ákʉ́ wɔ mfɔ nɛ ntaŋá manyé ntá yɛsɛ?’ Mandɛm afʉɛt ntá ángɛl anɛ abhesi ntá yi ndu mɔ́nɔk bɛghati yi bɛ ándɔ́k ámbák mǔnti wap nɛ mmu anɛ áfɛrɛ bhɔ ndu ɛsɔŋɔri. ");
INSERT INTO kenNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses akʉ mɛnyɨŋɨ́ maknkay, nɛ atɔ́ŋ bɛrɨŋ ɛbhɛn bɛ́tɔ́ŋɔ́ bɛtaŋ Mandɛm amɛm ɛtɔk Íjip. Afɛrɛ bo Israɛl arɛ́, akʉ báfʉɛ́t ndǔ Manyu Chu, nɛ amɛm baso ndǔ mamiɛ́ bɛsa bɛpay. ");
INSERT INTO kenNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Nkúbhɛ́ Moses-nɛ árɛ́mɛ́ nyaka ntá bo Israɛl bɛ, ‘Chɔŋ Mandɛm anchyɛ bhe ndɛmɛkɛpɨ̌ntɨ achak anɛ áfù ndu nkwɔ yɛka mbɔ ɛnyǔ achyɛ mɛ ntá yɛka.’ ");
INSERT INTO kenNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Yí Moses kɛ achi nyaka nɛ́ntɨ́ bachǐmbɨ bhɛsɛ́ nɛ ángɛl Mandɛm amɛm baso. Mpok yɔ, ángɛl Mandɛm árɛ́m kɛpɨ ntá yi ndu Njiɛ Sináy, akʉ yi arɨŋɨ mɛnyɨŋ ɛbhɛn Mandɛm áyàŋ yí ankʉ sɛndɨŋɨ, nɔ́ chí Ɛyɔŋ Mandɛm ɛnɛ́ ɛ́chí tɛtɛp mpoknkɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Kɛ bachǐmbɨ bhɛsɛ kɛka bɛghok yi. Bápúri yi batɛn nɛpak, kɛ bápɛ́tnsɛm Íjip amɛm batɨ̌-yap. ");
INSERT INTO kenNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ɛ́kʉ́ barɛm ntá Arɔn bɛ, ‘Ghokó bɔmandɛm ntá yɛsɛ, bɛ mandɔkɔ nɔkɔ bhɛsɛ ambɨ. Mbák chi Moses mmu áfɛ́rɛ́ bhɛsɛ ɛtɔk Íjip, sɛbhɨkɨ rɨŋɨ ɛnyɨŋ ɛnɛ ɛfakari nɛ yi.’ ");
INSERT INTO kenNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Bághóko ɛnyɨŋ ɛnɛ ɛchi mbɔ mɔ́mpɔŋ, bare chyɛ yɔ akabhɛ́ nya, nɛ mányíɛ́ ɛpa ɛ̌ti ɛnyɨŋ ɛnɛ baghoko nɛ amɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Kɛ Mandɛm atɨknsɛm ntá yap akpɨk arɔ bɔ mánchyɛ̀ nɔkɔ kɛnókó ntá mmok, nɛ ntaŋ nɛ mambě mfay mbɔ bɔmandɛm abhap, mbɔ ɛnyu ɛchi amɛm bɛkáti barɛmɛ́ kɛpɨ̌ntɨ bɛ, ‘Bo Israɛl! Mpok anɛ bǎkɔ̀ amɛm baso ndǔ mamiɛ́ bɛsa bɛ́páy, ntá yá kɛ̌ báwày nyaka nnya mánchyɛ̀ nɔkɔ akap kɛ? ");
INSERT INTO kenNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Bǎpɔkɔ nyaka ɛ́tɛm ɛnɛ́ mandɛm nsé anɛ áká nyɛ́n bɛ Mɔ́lɔk. Nɛ nɛmbe ɛnɛn mandɛm nsé Ráfan. Nɛ mɛnyɨŋ ɛbhɛn bǎghókó ndu bɛchyɛ bhɔ kɛnókó. Ɛ̌ti yɔ, chɔŋ mfɛ́rɛ́ be ntó ɛtɔk ɛ́chák bɛfʉɛt Bábilɔn.’ ");
INSERT INTO kenNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Stífin arɔk ambɨ bɛ́rɛm bɛ Bachǐmbɨ bhɛsɛ́ babhɔ̌ŋ nyaka ɛ́tɛm amɛm baso ɛnɛ́ ɛ́tɔ́ŋ bɛ́ Mandɛm achí nɛ bhɔ. Moses aghókó nyaka yɔ ɛ́bhák mbɔ ɛnyǔ Mandɛm aghati yi, nɛ nkúbhɛ́ mbɔ ɛnyǔ Mandɛm átɔ́ŋ yi amfay Njiɛ Sináy bɛ ɛbhɔŋ bɛbhak. ");
INSERT INTO kenNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ansɛm mpok, bachǐmbɨ bhɛsɛ́ bárɔ yɔ́ ntá bɔ̌bhap. Bápɔ́kɔ́ yɔ́ mpok bákɔ̀ nɛ Jóshua. Mandɛm abók bo abhɛn báchí arɛ bɛsí bɔtayɛsɛ, basɔt mmɨk. Ɛ́tɛm ɛyɔ ɛ́bhák arɛ́ tɛ mpok anɛ Debhít achi mfɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Mandɛm atɔ́ŋ Debhít bɛrɨ̌ndu. Anɨkmʉɛt ntá Mandɛm Jekɔ́p bɛ andɔ yi anté ɛkɛt ntá yi. ");
INSERT INTO kenNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Sólomon kɛ áté ɛkɛt ɛyɔ ntá Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Yɛ̌ nɔ, Mandɛm Acha apu chɔkɔ ndǔ bɛkɛt ɛbhɛ́n bo bate nɛ amɔ. Ɛ́chí mbɔ ɛnyǔ ndɛmɛkɛpɨ̌ntɨ árɛ́mɛ́ bɛ Mandɛm arɛm bɛ, ");
INSERT INTO kenNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Mfay chí ɛnɔkɔ́ kɛfɔ ɛya, nɛ mmɨk chi ɛrwɔ ɛnɛ mɛ́sɨ̀kɨ bɛkak arɛ. Ntɨkɨ ɛnyǔ ɛkɛt ɔ́kway bɛte ntá ya? nɛbhʉɛ́t anɛ mɛ̌kwáy bɛywemʉɛt achí nɛ fá? ");
INSERT INTO kenNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Pú amɔ́ ya kɛ ághókó mɛnyɨŋ ɛbhɛn mɛnkɛm-ɛ?’ ");
INSERT INTO kenNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Bɛ́rɔŋ ndǔ ngwɛ́nti, Stífin arɛm bɛ, ‘Bě bo nɛtaŋántɨ, bě bo bǎpu noko Mandɛm nɛ bǎpú ghok ɛyɔŋ ɛyi. Bǎchɛt Ɛfóŋó Bɛdyɛrɛ mbi mbɔ bachǐmbɨ bhɛka. ");
INSERT INTO kenNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ntɨkɨ ndɛmɛkɛpɨ̌ntɨ bachǐmbɨ bhɛka bábhɨ́kɨ́ chyɛ ɛsɔŋɔri? Nɛ báwày nyaka barɛmɛ́ kɛpɨ̌ntɨ Mandɛm abhɛn bárɛ́mɛ́ mbɨ mbɨ bɛ, Mmɔ̌ bɛtok anɛ achí chak bɛsí Mandɛm ǎtwɔ̀. Yí wu kɛ bǎtí nɛ bǎwáy. ");
INSERT INTO kenNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Bě kɛ̌ Moses ásɔ́rɛ́ ɛbhé Mandɛm ntá bɔángɛl achyɛ ntá yɛka, yɛ̌ nɔ, bǎbhɨ́kɨ́ bhʉɛrɛ yɔ́.’” ");
INSERT INTO kenNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Bo ɛchɛmɛ bǒ batí ɛtɔk bághókó nɔkɔ mɛnyɨŋ ɛbhɛn Stífin árɛ̀mɛ, batɨ ábé bɔ tontó, amɨ́k apěti anti. ");
INSERT INTO kenNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Kɛ Ɛfóŋó Bɛdyɛrɛ achi nyaka nɛ Stífin tontó. Ayoŋ amɨ́k ayɨŋɨ mfay, aghɔ́ bɛdiɛ́rɛ́ Mandɛm, nɛ Yesu téé ndǔ nɛbhʉɛt kɛnókó Mandɛm, ");
INSERT INTO kenNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Stífin arɛm bɛ, “Ghók ka! Ngɔ ndǔ mánɛ́nɛ́ mbǐnywɔp ɛtɔkɔ́ mfay, Mmu anɛ áfú ntá Mandɛm abhak téé ndǔ nɛbhʉɛt kɛnókó ɛbhe awɔ́nɛm Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kɛ bábhó bɛbɨk ɛ̌ri, báchók batú nɛ amɔ, bádú bárɔ́k bákɛ́m yi. ");
INSERT INTO kenNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Báyá yi báfú ɛtɔk nɛ yí, bátɛ́mti yi nɛ bɛtay bawáy. Batísiɛ bɛtábhá báfɛ́rɛ nkú mfǎmʉɛt ɛyap, barɔ ntá ɛsakámu amɔt bɛ ambabhɛri nɔkɔ. Ɛsakámu wu aka nnyɛ́n bɛ Sɔ̌l. ");
INSERT INTO kenNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Mpok bátɛ̀mti Stífin nɛ batay, anɨkmʉɛt bɛ, “Yesu Acha, sɔt Ɛfóŋó ɛya!” ");
INSERT INTO kenNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Akwɛ́n atɛp mánɛ́n amɨk, arɛm nɛ ɛyɔŋ ɛtaŋataŋ bɛ, “Acha, foŋori bhɔ bɛbʉ́ ɛbhap ɛbhɛn.” Árɛ́mɛ́ nɔ́kɔ́ nɔ, asɛbhɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sɔ̌l abhak arɛ́ téé, aka bɛ́ ɛrɨ mángwáy Stífin. Bɛ́bhó ɛwak ɛyɔ, báré chyɛ nkwɔ Yesu abhɛn báchí Yerúsalɛm bɛyǎ nɛnyok. Ɛkʉ bɔ́ mankɛm bábʉɛ́ bataka atú ɛtɔk Judɛ́ya nɛ átú Samária ankɛm. Ɛrɔp chi bǒnto Yesu bɔ́bhɔ́ amɛm ɛtɔk Yerúsalɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Baway nɔkɔ Stífin, mbɔk bo abhɛn báchyɛ̀ Mandɛm kɛnókó bápɔ́kɔ yi bárɔ́k bábhɛ́mɛ, nɛ bádi yi tontó. ");
INSERT INTO kenNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Mbák chi Sɔ̌l, are yáŋ mbi mɛ́nɛ́mɛ bǒnkwɔ Yesu. Ɛ́kʉ abho bɛ́chwé ɛkɛt nɛ ɛkɛt anja nɔkɔ abhɛn mánókó, baghɔrɛ́ nɛ babhakanɛm, amfyɛ nɔkɔ ɛkɛrɛ́kɛnɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Bakoŋo Yesu abhɛn bábʉɛ̀ bátáka mbankɛm báre kɔ mángati nɔkɔ Mbok Ndɨ́ndɨ́ ɛ̌ti Yesu. ");
INSERT INTO kenNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Anɛ bábhɨŋɨ bɛ Fílip arɔk ɛtɔk ɛ́gho atú Samária angati nɔkɔ mbok ɛ̌ti Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò. ");
INSERT INTO kenNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Akʉ mɛnyɨŋɨ́ maknkay arɛ́. Bo baghɔ nɔkɔ nɔ, bɛyǎ bhap báre tá batú sayri ndu bɛghok mɛnyɨŋ ɛbhɛn yí árɛ̀m. ");
INSERT INTO kenNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Bɛfóŋó bɛbʉ́bɛbʉ ɛbhɛ́n bɛ́sɔ̀ŋɔri bo bɛ́re rɔ bhɔ mɛ́mbɨkɨ nɔkɔ nɛ ɛyɔŋ ɛtaŋataŋ. Bɛyǎ bo abhɛn bachi bhʉrɛ́ nɛ bakɛm bátaŋ nkwɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ɛkʉ bɛyǎ maŋák abhak nɛ bǒ ɛtɔk ɛgho Samária ɛyɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Mmǔfú anɛ áká nnyɛ́n bɛ́ Símun achí nyaka ɛtɔk ɛyɔ nkwɔ. Abhak mǔnjɔ. Anaŋ ákʉ̀ nyaka mɛnyɨŋ ɛbhɔ ndu ɛrɔri mpok, andɛmɛ nɔkɔ bɛ́ yí achí ɛtaŋtí mmu. Bǒ Samária babhak maknkay bɛ́ghɔ mɛnyɨŋ ɛbhɛn yi ákʉ̀. ");
INSERT INTO kenNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Bɔ mankɛm, manɛ́m bo nɛ ndɛ́ndɛ́mɛ́ bho bare tá batú bɛghok mɛnyɨŋ ɛbhɛn yi ághàti bhɔ, mándɛmɛ nɔkɔ bɛ, “Mmǔ-nɛ chi mmu Mandɛm anɛ bábhɨ̀ŋɨ bɛ Ɛtaŋtǐ mʉ.” ");
INSERT INTO kenNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Barak mandɛm nsé anɛ yi ákʉ̀ ndu ɛrɔ́ri mpok, akʉ bo báre ta batú bɛghók mɛnyɨŋ ɛbhɛn yi árɛ̀m. ");
INSERT INTO kenNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Fílip átwɔ́ nɔ́kɔ́ nɛ Mbok Ndɨ́ndɨ́ ɛ̌ti ɛnyu Mandɛm abhak nɛ bǒbhi mbɔ Mfɔ wap nɛ ɛ̌ti Yesu Kristo, baghɔrɛ́ nɛ babhakanɛm bábho mɛ́nóko mándɔkɔ nɔkɔ bɛ mánjwiti bhɔ́. ");
INSERT INTO kenNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Yɛ̌ Símun nkwɔ́ anoko bájwíti yí. Bájwítí nɔ́kɔ́ yí, abhat mmʉɛt nɛ Fílip, ankoŋo nɔkɔ yi yɛ̌ntɨkɨ ɛbhak. Nyu arɔp yi fuu ɛ̌ti bɛrɛmɛ mɛnyɨŋɨ́ maknkay ɛbhɛ́n Fílip ákʉ̀, nɛ ɛ̌ti bɛrɨŋ ɛbhɛ́n Mandɛm áfʉɛ̀t ntá Fílip antɔŋ nɔkɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Bǒnto abhɛn Yerúsalɛm bághoko nɔkɔ bɛ bǒ-Samaria mánoko Ɛyɔŋ Mandɛm, bátó Píta nɛ Jɔ̌n arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","BɔPíta bachwɔp nɔkɔ Samária, bare nɨkmʉɛt bɛ́ Ɛfóŋó Bɛdyɛrɛ ántwɔ ntá bo abhɛn mánóko Yesu. ");
INSERT INTO kenNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ɛfóŋó Bɛdyɛrɛ abhɨkɨ re twɔ nyaka ntá yɛ̌ mmu wap. Yɛ̌ nɔ, manaŋ bajwiti nyaka bhɔ ndǔ nnyɛ́n Yesu Acha. ");
INSERT INTO kenNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Píta nɛ Jɔ̌n mányáŋa amɔ́ antí bǒbhɛn manɨkmʉɛt, Ɛfóŋó Bɛdyɛrɛ atwɔ́ abhak nɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Símun ághɔ́ nɔ́kɔ́ bɛ́ Ɛfóŋó Bɛdyɛrɛ atwɔ achi nɛ bhɔ́ ndǔ bǒnto mányáŋá bɔ amɔ antí, afɛrɛ nkáp bɛ́chyɛ bǒnto, ");
INSERT INTO kenNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","arɛm bɛ, “Kʉ ká mɛnkwɔ́ mbɔ̌ŋ bɛtaŋ bɛ́ yɛ̌ agha anɛ nyáŋá yi amɔ́ anti Ɛfóŋó Bɛdyɛrɛ ántwɔ́ ntá yi.” ");
INSERT INTO kenNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Kɛ Píta akɛmɛ yi bɛ, “Ɛghori ɛ́mpɔ́kɔ́ wɔ́ nɛ nkáp aywɛ! Ɔkáysí bɛ́ ɔ̌kwáy bɛ́ku akap Mandɛm nɛ nkáp na? ");
INSERT INTO kenNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Dɨŋɨ́ bɛ́ ɔbhɨ́kɨ́ bhɔ́ŋ yɛ ɛnyɨŋ ndu bɛtɨk ɛbhɛsɛ́ mbɔnyunɛ ntɨ ɛnɛ nɛ́pú chak bɛsí Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ndu ɛchi nɔ, tɨ́k nsɛm ndǔ nkaysi bɛbʉ́ anɛ achi wɔ antɨ ɔ́nɨkmʉɛt ntá Mandɛm Acha. Ngufú chɔŋ amfoŋori nkaysi anɛ achi wɔ antɨ. ");
INSERT INTO kenNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ngɔ bɛ́ ɔbhɔŋ ɛpɔ̌ mpabhamɨ́k nɛ ɔ́kwɛ̌n nsɛm antɛn bɛbʉ́.” ");
INSERT INTO kenNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Símun aghoko nɔkɔ nɔ, akɛmɛ Píta nɛ Jɔ̌n bɛ, “Bɔta, nɨk ka Mandɛm mmʉɛt ɛ̌ti ya bɛ́ yɛ̌nyɨŋ ɛ́mɔt ɛnɛ bǎrɛ́mɛ́ ɛ́kɛ́ fakari nɛ mɛ.” ");
INSERT INTO kenNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Mánáŋá nɔ́kɔ́ bɛ́ghati bo mbok Yesu nɛ mɛnyɨŋ ɛbhɛn yi akʉ ntá yap, bárɔ́ bare pɛtnsɛm Yerúsalɛm. Báre téé ndǔ bɔ́bɛtɔk Samária mangati nɔkɔ bo Mbok Ndɨ́ndɨ́ ɛ̌ti Yesu. ");
INSERT INTO kenNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Kɛ ángɛl Acha atwɔ́ arɛm ntá Fílip bɛ, “Faté sɛp ndǔ ɛsɨ́ mbi anɛ áfù Yerúsalɛm árɔ̀ŋ Gása”. ");
INSERT INTO kenNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Fílip afate abho bɛ́rɔŋ. Ɛ́fákari bɛ́ mmǔ Ɛtǒpia amɔt anɛ afú Yerúsalɛm ndǔ mɛnɨkmʉɛt ápɛtnsɛm ɛtɔk ɛyi amɛm ɛ́kárɨk ɛnɛ mpɔŋɔ́ndɨ́k ɛ́yà. Abhak mǔngo Ɛtǒpia anɛ baghaka nɛ yi kɛ akɛmɛ nyaka ɛfɨŋɨ́ ɛkɛrɛ́ nkáp mbɔ mmu anɛ baghaka yi apu kway nyaka bɛchɛm nɛ bo abhɛn mfɔ ngɔrɛ́ Mfɔ Ɛtǒpia wu aka nnyɛ́n bɛ Kándas. Ɛnɛ́ yí áchi amɛm ɛkarɨk ɛyi árɔ̀ŋ, are pay ɛkáti ndɛmɛkɛpɨ̌ntɨ Aisáya. ");
INSERT INTO kenNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ɛfóŋó Bɛdyɛrɛ aghati Fílip bɛ, “Dɔ́k awu kɔ nɔ́kɔ́ kɛ́kwɔ́t nɛ ɛkarɨk ɛyɔ.” ");
INSERT INTO kenNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Fílip ajɛt arɔk kɛkwɔt nɛ yɔ́, aghók ndǔ mmu wu ápày ɛkáti ndɛmɛkɛpɨ̌ntɨ Aisáya. Abhɛ́p yí bɛ, “Ɔ̌bhɔŋ nɔ nɛjwǐmɛm ndǔ ɛnyɨŋ ɛnɛ́ ɔ́pày?” ");
INSERT INTO kenNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mǔngo Ɛtǒpia wu akɛmɛ bɛ, “Mɛ̌kwáy bɛjwimɛm ná ɛnɛ́ yɛ̌ mmu ábhɨ́kɨ́ nɛ́nɛ angati mɛ?” Abhɨŋɨ yɛ Fílip ánkó ánchɔ́kɔ́ nɛ yí amɛm ɛ́kárɨ́k. ");
INSERT INTO kenNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","33","Ɛnyɨŋ ɛnɛ yi ápày ndǔ Ɛkáti Mandɛm ɛbhak bɛ́: “Achí nyaka mbɔ ághɔ́ŋɔmɛ́n anɛ bakɛmɛ bárɔŋ bɛway, mbɔ mɔ́nkwɔmɛ́n anɛ báfɛ̀rɛ ɛmɛnɛ ɛyi, yɛ̌ bɛbɨk yɔ kɛbɨk. Akɛ nɛ́nɛ ɛyɔŋ. Báyɔ́rɛ yi, bataŋ yi, bákpɔ́t nyé ɛni, bachyɛ yi ɛsɔŋɔri ndɛ́ndɛm. Agha ákway bɛtɔŋ bɛ, Yɨŋɨ́ mɔ̌wa nɛ́, ɛnɛ́ bákpɔ́rɛ́ nɛpɛ́m ɛni ambɨ ambɨ fá amɨk?” ");
INSERT INTO kenNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Mǔngo wu abhɛ́p Fílip bɛ, “Ɛ̌tá, ghati mɛ́, ndɛmɛkɛpɨ̌ntɨ asɨ̌ŋ ɛnyɨŋ ɛnɛ yi árɛ̀m nɔ́ ɛ̌ti agha? Arɛm nɔ chí ɛ̌ti mmu áchák kɛ ɛ̌ti mmʉɛt ɛyi?” ");
INSERT INTO kenNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Fílip abho ndǔ nɛbhʉɛt ɛkáti Aisáya wu agháti mǔngo Ɛtǒpia Mbok Ndɨ́ndɨ́ Yesu. ");
INSERT INTO kenNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Báre kɔ mándɔkɔ nɔkɔ. Bágháká nɔ́kɔ́ ndǔ nɛbhʉɛt anɛ manyiɛp achi, arɛm ntá Fílip bɛ, “Yɨŋɨ́ manyiɛp. Ntí achí anɛ bábhɨkɨ bhɔ́ŋ bɛ́jwiti mɛ?” ");
INSERT INTO kenNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Fílip akɛmɛ yí bɛ, “Mbák ɔ́sɨ́kɨ́ ntɨ ɛnɛ nɛnkɛm nɛ Yesu, mɛ̌kwáy bɛ́jwiti wɔ.” Mmǔ wu akɛmɛ yí bɛ́ “Nnókó bɛ Yesu Kristo chí Mmɔ Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Mǔngo wu achyɛ yɛ ɛyɔŋ bɛ́ mánkʉ ɛ́kárɨk ɛ́nté. Ɛ́té nɔ́kɔ́, bɔ́ nɛ Fílip básɛp báchwe anyɛ́n, Fílip ajwiti yí. ");
INSERT INTO kenNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Báfú nɔ́kɔ́ anyɛ́n, Ɛfóŋó Bɛdyɛrɛ afɛrɛ Fílip arɛ́, mǔngo Ɛtǒpia wu kɛpɛrɛ ghɔ́ yi. Yɛ̌ nɔ, arɔk ambɨ nɛ nɛkɔ ɛni nɛ maŋák. ");
INSERT INTO kenNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Fílip ápɛ́rɛ yɨŋɨ arɔp chí ɛtɔk Asótus. Abho bɛ́ghati Mbok Ndɨ́ndɨ́ arɛ. Arɔk ambɨ bɛ́kʉ nɔ ndu bɔ̌bɛtɔk mankɛm abhɛn báchi ambi kpátɛ mpok yi aghaka Seséria. ");
INSERT INTO kenNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Mpok ɛyɔ nkɛm, Sɔ̌l arɔk ambɨ bɛpa bɛ yi abhɔŋ bɛway bakoŋo Yesu. Arɔk ntá mǔngo bachiǎkap Mandɛm, ");
INSERT INTO kenNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","aghati yi bɛ anchyɛ yi bɛkáti ɛbhɛ́n bɛ́chyɛ yi bɛtaŋ bɛrɔŋ Damáskɔs ndu bɛkɛrɛ́ nɛnɨkɨ́mʉɛt bo Israɛl bɛ́ mbák ángɔ́ bakoŋo Mbi Yesu arɛ́, ankwáy bɛ́kɛ́mti bhɔ́, baghɔrɛ́ nɛ babhakanɛm, angwɔ́t, andɔk Yerúsalɛm nɛ bhɔ́. ");
INSERT INTO kenNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sɔ̌l afa yɛ are rɔ́ŋ. Agháká nɔ́kɔ́ kɛ́kwɔ́t nɛ Damáskɔs, bɛdíɛ́rɛ́ bɛfú amfay tɛ́mchok bɛsɛp bɛ́káp yi. ");
INSERT INTO kenNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Sɔ̌l akwɛ́n amɨk, aghók ɛyɔŋ ɛnɛ́ ɛ́bhɛ̀p yi bɛ, “Sɔ̌l, Sɔ̌l, ndaká yí ɔ́chyɛ̀ mɛ nɛnyok?” ");
INSERT INTO kenNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sɔ̌l akɛmɛ bɛ, “Acha, chí wɔ agha?” Ɛyɔŋ ɛyɔ ɛ́kɛ́mɛ yí bɛ, “Mmɛ Yesu kɛ ɔ́kòŋo gbɔkɔ́gbɔkɔ ɔnchyɛ nɔkɔ nɛnyok. ");
INSERT INTO kenNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Kɛ faté, dɔ́k amɛm ɛtɔk ɛgho. Chɔŋ mángati wɔ́ arɛ́ ɛnyɨŋ ɛnɛ ɔ́bhɔ́ŋɔ́ bɛ́kʉ.” ");
INSERT INTO kenNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Bǒ abhɛn bákɔ̀ nyaka nɛ Sɔ̌l, bághók ɛyɔŋ ɛyɔ, kɛ bɔ kɛghɔ yɛ̌ mmú. Báte manyu chochok. ");
INSERT INTO kenNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sɔ̌l afate amɨk, anɛnɛ amɨ́k, kɛ yi kɛkwáy bɛghɔ mbaŋ. Bákɛ́m yi ndu awɔ, baya barɔk ɛtɔk Damáskɔs. ");
INSERT INTO kenNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Abhak arɛ́ ndǔ manywɔp árát, yi kɛkwáy bɛghɔ mbaŋ. Mpok yɔ nkɛm yi kɛnyiɛ nɛnyíɛ́, yɛ̌nyɨŋ yi kɛ nyu. ");
INSERT INTO kenNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Nkoŋo Yesu amɔt achi nyaka Damáskɔs anɛ áká nnyɛ́n bɛ́ Ananías. Aghɔ́ kɛnɔ́ amɨ́k ántífú ndu Yesu Acha abhɨŋɨ yí bɛ, “Ananías.” Aka arɛm bɛ, “Acha, ghɔ́ mɛ́ nɛ.” ");
INSERT INTO kenNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Acha aghati yi bɛ, “Faté dɔ́k ndu nkɔngɔ-ɛtɔk anɛ́ bábhɨŋɨ bɛ́ Téé. Ɔ́náŋ ɔ́nchwɔp ndǔ ɛkɛt Júdas bɛ́p mmu Tásɔs anɛ áká nnyɛ́n bɛ́ Sɔ̌l. Achí arɛ́ ǎnɨ̀kmʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Nɛ ndǔ kɛnɔ́ amɨ́k ántí fúú, aghɔ́ mmu anɛ bábhɨŋɨ bɛ́ Ananías, ndu áchwé anywɔ́p. Anyaŋa amɔ anti ywi bɛ́ ámpɛt ankway bɛghɔ mbaŋ.” ");
INSERT INTO kenNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananías akɛmɛ bɛ, “Acha, bɛyǎ bo bághátí mɛ mbok Sɔ̌l wu nɛ bɛbɛ́ptí mɛnyɨŋ ɛbhɛn yi ákú ntá bǒbhɛ awu Yerúsalɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Bǒbatí bachiǎkap Mandɛm báchyɛ́ yí bɛtaŋ, nɛ atwɔ fá chi bɛ́kɛmti bǒbhɛ.” ");
INSERT INTO kenNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Kɛ Yesu Acha aghati yi bɛ, “Dɔ́k mbɔnyunɛ njap yí ámbák mʉ̌bɛtɨk awa, bɛ́ ándɔk ángati bo abhɛn bápú bo Israɛl, nɛ bafɔ bhap, nɛ bo Israɛl ɛ̌ti ɛya. ");
INSERT INTO kenNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Chɔŋ mɛmbɔŋ ntɔŋ yí ɛsɔŋɔri ɛnkɛm ɛnɛ́ yí ábhɔ́ŋɔ́ bɛghɔ ɛ̌ti ya.” ");
INSERT INTO kenNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananías árɔ́ yɛ arɔk áchwé amɛm ɛkɛt ɛnɛ́ Sɔ̌l áchi arɛ. Anyaŋa yí amɔ ántí arɛm bɛ, “Sɔ̌l, manɔ́, mbɔŋ Yesu Acha mmu abhésí ntá yɛ ankɔŋɔmbi mpok ɔ́twɔ̀ fá, kɛ átó mɛ́ nkʉ́ ɔ́mpɛt ɔ́ngɔ́ mbaŋ nɛ bɛ́ Ɛfóŋó Bɛdyɛrɛ ambak nɛ wɔ.” ");
INSERT INTO kenNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Tɛ́mté wu ɛbhak ntá Sɔ̌l mbɔ bɛ mɛnyɨŋ mbɔ bɛfabhɛ́ nsi bɛfu yí amɨ́k bɛkwɛnti. Apɛt abho bɛghɔ mbaŋ. Afate yɛ arɔk bájwíti yi. ");
INSERT INTO kenNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Anyíɛ́ nɛnyíɛ́ bɛtaŋ ɛbhi bɛ́pɛ́tnsɛm. Sɔ̌l abhak Damáskɔs nɛ bakoŋo Yesu ndu mpǎy manywɔp. ");
INSERT INTO kenNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Abho yɛ bɛ́rɔ́ŋ ndǔ bɛkɛrɛ́ nɛnɨkɨ́mʉɛt bo Israɛl tɛ́mté angati nɔkɔ bo ɛ̌ti Yesu bɛ́, “Yesu áchí Mmɔ Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Bǒ mankɛm abhɛn bághókó yi, bábhák maknkay, mámbɛbhɛ nɔkɔ batɨ bɛ, “Pú nkúbhɛ́ mmǔ-nɛ kɛ ákɔ̀ nyaka angʉɛbhɛ nɔkɔ nɛnu nɛ bo abhɛn bábhɨ̀ŋɨ nnyɛ́n Yesu awu Yerúsalɛm nɛ? Atwɔ fá chí bɛ́ ánkɛ́mtí bo Yesu angwɔt, ansɔt ampɛtnsɛm nɛ bhɔ Yerúsalɛm. Atwɔ fá ndu bɛkɛmti bhɔ bɛ ansɔt ampɛtnsɛm nɛ bhɔ́ ntá bǒ batí bachiǎkap Mandɛm.” ");
INSERT INTO kenNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Yɛ̌ nɔ, Sɔ̌l are tɔ́ŋ Mbok Ndɨ́ndɨ́ ɛ̌ti Yesu andɔk nɔkɔ chí ambɨ. Are fʉɛ́t ndu bɛyǎ babhi bɛtɔŋ kpoŋoroŋ bɛ́ Yesu kɛ áchí Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò ɛnyunɛ́ bo Israɛl abhɛn báchí Damáskɔs bábhɨkɨ kwáy bɛkɛm kɛfe nɛ yí. ");
INSERT INTO kenNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ɛfʉɛrɛ nɔkɔ bɛyǎ manywɔp, bǒbati bo Israɛl báté ɛyu bɛway Sɔ̌l. ");
INSERT INTO kenNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Sɔ̌l arɨŋɨ nkaysi yap. Báre noŋ yi bɛti nɛ ngósí ndu manyǔbhá anɛ Damáskɔs bɛ mpok yi áyàŋ bɛfʉɛt, mankɛm yí mangway. ");
INSERT INTO kenNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kɛ bɛti mɛ́mɔt, bakoŋó Sɔl basɔt yi báfyɛ́ amɛm ɛkay bákʉ yi áfʉɛ́t ndǔ mbok anɛ́ áchi ndǔ nkok anɛ ákábhɛ́ ɛtɔk, básɛ́bhɛ yi amɨk ansɛm ɛbhá. Abʉɛ́. ");
INSERT INTO kenNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sɔ̌l apɛtnsɛm Yerúsalɛm are mɔ bɛ́chɛm mmʉɛt nɛ bakoŋo Yesu arɛ́, kɛ bɔ́ kɛnoko bɛ yi achi nkoŋo Yesu. Báre chay mámbʉɛ nɔkɔ yí. ");
INSERT INTO kenNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Kɛ mmu amɔt anɛ aka nnyɛ́n bɛ Banábas asɔt yí arɔk ntá bǒnto Yesu. Aghati bhɔ ɛnyǔ Sɔ̌l aghɔ Yesu Acha ambi mpok yi árɔ̀ŋ Damáskɔs nɛ ɛnyǔ Yesu árɛ́mɛ́ kɛpɨ nɛ yi. Aghati nkwɔ́ bɔ́ ɛnyǔ Sɔ̌l átɔ́ŋ Ɛyɔŋ Mandɛm kpoŋoroŋ ndu nnyɛ́n Yesu awu Damáskɔs kɛbhɔ́ŋ bɛcháy. ");
INSERT INTO kenNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Bɛbho yɛ mpok yɔ, achɛm mmʉɛt nɛ bakoŋo Yesu Acha ndu yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ bɔ bákʉ̀. ");
INSERT INTO kenNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Are tɔŋ Ɛyɔŋ Mandɛm ndu nnyɛ́n Yesu kɛbhɔ́ŋ bɛcháy. Mpók nɛ mpok ándɛm nɔkɔ ɛ̌ti Yesu ntá bo Israɛl abhɛn bárɛ̀m ɛyɔŋɔ Grik, ankɛm nɔkɔ ɛpʉ́ítí nɛ bhɔ́. Ɛkʉ bare yáŋ chí bɛ́wáy yí. ");
INSERT INTO kenNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Batɨ̌ Bǒ nkwɔ́ bárɨ́ŋɨ́ nɔ́kɔ́ nɔ́, básɔt yi barɔk Seséria, bátó yí ándɔ́k Tásɔs. ");
INSERT INTO kenNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ɛ́fákári yɛ bɛ bǒnkwɔ Yesu abhɛn bachi atú Judɛ́ya, nɛ abhɛn atú Gálili, nɛ abhɛn atú Samária nkɛm kɛpɛrɛ bhɔŋ ɛsɔŋɔri. Bakoŋo Yesu bábhʉrɛ nɛpɛ́m ɛnap ɛnyu ɛnɛ́ nɛ́tɔ̀ŋ bɛ́ bɔ báchyɛ̀ Mandɛm kɛnókó. Ɛfóŋó Bɛdyɛrɛ are chyɛ bhɔ nɛpɔptǐntɨ́, anchyɛ nɔkɔ bhɔ bɛtaŋ. Ɛ́kʉ bɛyǎ bo báchák báre noko Yesu mánchɛm nɔkɔ nɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ɛ́fákari bɛ Píta ǎkɔ̀ nyaka mbǎŋ nɛ mbaŋ ndu bɛ́byo bo Mandɛm. Ɛwak ɛ́mɔ́t, arɔk bɛbyo abhɛn bachi ɛtɔk ɛnɛ bábhɨŋɨ bɛ Lída. ");
INSERT INTO kenNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Akwɛsɛ mbɛ́ntí amɔt arɛ́. Báre pɔ̀kɔ yi yɛ̌ntɨkɨ ɛbhak ɛnɛ yi árɔ̀ŋ. Abhak ɛnyu yɔ ndu mamiɛ́ ánɛ̀n. Aka nnyɛ́n bɛ Aénias. ");
INSERT INTO kenNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Píta arɛm ntá yi bɛ, “Aénias, Yesu Kristo ǎkʉ̀ wɔ ɔ́ntáŋ nɛ́nɛ. Faté pɛ́t ɛ̌sák ɛyɛ.” Tɛ́mte wu, atɛ́m afate. ");
INSERT INTO kenNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Bǒ ɛtɔk Lída nɛ Shárɔn babhak arɛ́. Bɔ mankɛm bághɔ́ nɔ́kɔ́ ndu Aénias ákɔ̀, mánókó Yesu Acha. ");
INSERT INTO kenNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ngɔrɛ́ amɔt achi nyaka ɛtɔk Jopa anɛ aka nnyɛ́n bɛ́ Tabíta, Nɔ́ chí Dɔ́kas ndu ɛyɔŋ Grik abhak nkoŋo Yesu. Ǎkʉ nyaka bɛrɨ, ankwak nɔkɔ bachɛ́bhɛ́bho mpoknkɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Mpok yɔ, akwɛ́n nɛme agú. Báso yi bábhʉrɛ amɛm mɔ́kɛrɛ́mfay ndu ɛkɛrɛ́ mfay. ");
INSERT INTO kenNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jopa kɛsap nɛkɔ nɛ Lída. Bakoŋo Yesu abhɛn Jopa bághók bɛ Píta achi Lída. Bátó bo batí apay, ntá yi. Bárɔk manɨk yi mmʉɛt bɛ, “Ɛta, twɔ ghɔ bhɛsɛ́ ayak, kɛ́chɔŋti mpok.” ");
INSERT INTO kenNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Píta afa yɛ are rɔŋ nɛ bhɔ. Ágháká nɔ́kɔ́ arɛ́, basɔt yi bako ndu mɔ́kɛrɛ́mfay. Bɛyǎ mánkwɛ́sɛ́ bábhak arɛ. Bɔ́ mankɛm bakap Píta. Báre di, mántɔŋ nɔkɔ ndɛn ɛnɛ Tabita áyɛ́mɛ́ ntá yap mpok yi achi nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Píta aghati bɔ́ mankɛm mámfu nɛfí. Atɛp mánɛ́n amɨk anɨkmʉɛt ntá Mandɛm. Ayibhiri mmʉɛt ntá ngu arɛm bɛ, “Tabíta, faté!” Tabíta anɛnɛ amɨ́k. Ághɔ́ nɔ́kɔ́ Píta afate achɔkɔ chɔ́kɔ́. ");
INSERT INTO kenNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Píta asá áwɔ́ akɛm yi akwak yi afate. Abhɨŋɨ yɛ bo Mandɛm nɛ mánkwɛ́sɛ́, asɔt Dɔ́kas atɔ́ŋ bɔ́ bɛ mangɔ bɛ́ yi achí nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Mbok Dɔ́kas ataka ɛtɔk Jopa ɛnkɛm. Bɛyǎ bo mánóko, básɨkɨ ntɨ nɛ Yesu Acha. ");
INSERT INTO kenNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Píta arɔk ambɨ bɛchɔkɔ Jopa ndǔ bɛyǎ manywɔp nɛ ngoko nkwɔbhɛ́nya ɛnɛ bághárɛ́ amʉɛt nnya ɛnɛ baway. Nnyɛ́n ɛni nɛ́bhak bɛ Símun. ");
INSERT INTO kenNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Mmufú achí nyaka ɛtɔk Seséria, anɛ aka nnyɛ́n bɛ́ Kɔnéliɔs. Abhak mǔntí ɛ́ká batɛmɛ́ nɛnu Rom bɛsa bɛ́táy. Báré bhɨŋɨ ɛka ɛyɔ bɛ́ Ɛka Itália. ");
INSERT INTO kenNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kɔnéliɔs abhak mmu anɛ ákɔ́ŋɔ́ baraká Mandɛm nɛ ǎchyɛ̀ nyaka Mandɛm kɛnókó nɛ ɛfo ɛyi ɛnkɛm. Abhak mmu anɛ ánɨ̀kmʉɛt ntá Mandɛm mpoknkɛm, anchyɛ nɔkɔ bɛyǎ nɛkwak ntá bo Israɛl abhɛn bachi bachɛ́bhɛ́bho. ");
INSERT INTO kenNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ɛwak ɛ́mɔt, mbɔ nkarɛnka ɛrat nɛ ngósí, aghɔ́ kɛnɔ́ amɨ́k anti fúú. Aghɔ́ sayri ndu ángɛl Mandɛm amɔt átwɔ́ ábhɨ́ŋɨ́ yi bɛ, “Kɔnéliɔs!” ");
INSERT INTO kenNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ayoŋ amɨ́k are yɨŋɨ ángɛl wu nɛ bɛcháy, abhɛp yi bɛ, “Ɛta chí yi?” Ángɛl Mandɛm akɛmɛ bɛ, “Mandɛm aghok nɛnɨkɨ́mʉɛt ɛnɛ, aghɔ́ nɛkwak ɛnɛ́n ɔ́chyɛ́ ntá bachɛ́bhɛ́bho nɛ abhɔŋ maŋák nɛ wɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Tó yɛ bo Jopa bɛ mandɔ́k mámbɨ́ŋɨ́ mmu anɛ ákà nnyɛ́n bɛ́ Símun anɛ nnyɛ́n ɛni nɛchak nɛchi bɛ Píta. ");
INSERT INTO kenNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ǎchɔ̀kɔ nɛ Símun ngoko nkwɔbhɛ́nya. Ɛkɛt Símun wu ɛchi angɔkɔ manyu.” ");
INSERT INTO kenNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ángɛl Mandɛm árɔŋɔ nɔkɔ, Kɔnéliɔs nkwɔ bakʉ̌ bɛtɨk abhi batí apay nɛ ntɛmɛ́ nɛnu amɔt anɛ achi nyaka nɛ yi mpoknkɛm ankwaka nɔkɔ yi. Ntɛmɛ́ nɛnu wu abhak mmu anɛ áchày Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Bátwɔ́ nɔ́kɔ́, aghati bhɔ́ ɛnyɨŋ ɛnɛ ángɛl Mandɛm árɛ́mɛ́. Ató yɛ bɔ́ ɛtɔk Jopa. ");
INSERT INTO kenNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Bárɔ bare rɔŋ, bágháká kɛ́kwɔ́t nɛ ɛtɔk mbɔ nkárɛ́nká byo nɛ ɛpay. Nkúbhɛ́ mpok yɔ, Píta akó amfay ɛkɛt ndu mɛnɨkmʉɛt. Mfay ɛkɛt abhak ransi. ");
INSERT INTO kenNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nsay akɛ́m yi, are yáŋ ɛnyɨŋ mɛ́nyiɛ́ mpok anɛ nɛnyíɛ́ nɛbhʉɛt angó, aghɔ́ kɛnɔ́ amɨ́k ántífú. ");
INSERT INTO kenNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Aghɔ́ bɛ́ nɛbu nɛ́nɛ́nɛ. Ɛnyɨŋɨ́fú ɛ́fú arɛ ɛre sɛp amɨk. Ɛ́bhak mbɔ ntěndɛn nɛgho ɛnɛ́n bákɛ́mɛ́ ndǔ batí yi anwi básɛ̀bhɛ amɨk. ");
INSERT INTO kenNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mɛnyǔ nnya mɛnkɛm bɛ́bhak ndu ɛnyɨŋ ɛyɔ. Nnya ɛnɛ́ bɛkak mɛnwi ɛbhak arɛ́ nɛ ɛnɛ́ ɛ́sù mɛniɛ amɨk nɛ kɛnɛn. ");
INSERT INTO kenNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Aghók ɛyɔŋ ndu ɛ́rɛ̀m bɛ, “Píta, faté, wáy nyìɛ.” ");
INSERT INTO kenNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Kɛ Píta akɛmɛ bɛ, “Cháá! Acha mbɨ́kɨ́ re nyiɛ́ ɛnyɨŋ ɛnɛ ɛpu pɛ́pɛ́p bɛsí Mandɛm wáwák.” ");
INSERT INTO kenNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ɛyɔŋ ɛpɛt ɛtwɔ ntá yí ndɔŋ anɛ ájwí ɛpay bɛ, “Ɛnyɨŋ ɛnɛ Mandɛm akʉ bɛ ɛmbak pɛ́pɛ́p bɛsí bhi, yɛ̌ mmu akɛ rɛm bɛ ɛ́pú pɛ́pɛ́p.” ");
INSERT INTO kenNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ɛ́fákárí nɔ́kɔ́ ɛnyu yɔ ndɔŋ ɛ́rát, ɛnyɨŋ ɛyɔ ɛ́pɛ́tnsɛm amfay. ");
INSERT INTO kenNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ɛnɛ́ Píta abhʉɛ́t bɛyaŋ bɛrɨŋɨ ntí kɛnɔ́ amɨ́k antífú ɛkɔ, bǒ abhɛn Kɔnéliɔs átó, bare bhɛp ɛbhak ɛnɛ Símun áchí. Bárɔ́k kpát báchwɔp ndǔ nyǔbha ɛkɛt ɛnɛ yi achi arɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Básá ɛyɔŋ babhɛp mbák mmu anɛ ákà nnyɛ́n bɛ́ Símun Píta achí arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Nɛ ɛnɛ́ Píta abhʉɛ́t bɛkáysi kɛnɔ́ ɛkɔ, Ɛfóŋó Bɛdyɛrɛ arɛm ntá yí bɛ, “Yɨŋɨ́, bǒ batí árát báyàŋ wɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Faté, sɛp, dɔ́k áyák nɛ bhɔ nɛ ɔ́kɛ́ chɔnti mpok. Mɛ kɛ ntó bɔ.” ");
INSERT INTO kenNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Píta asɛp arɔk ntá bǒbhɔ, arɛm bɛ, “Mɛ kɛ nchí mmu anɛ bǎyàŋ. Bǎtwɔ ndaká yí?” ");
INSERT INTO kenNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bákɛ́mɛ yi bɛ, “Kɔnéliɔs, mǔnti batɛmɛ́ nɛnu bɛsa bɛ́tay, kɛ ato bhɛsɛ́ ntá yɛ. Achí chak bɛsí Mandɛm nɛ ǎchày Mandɛm. Bo Israɛl mankɛm báchyɛ̀ yi kɛnókó tontó. Ángɛl Mandɛm ághátí yi ántó mámbɨŋɨ wɔ, ɔ́ntwɔ ɛkɛt ɛyi, bɛ angok ɛnyɨŋ ɛnɛ ɔ́bhɔ́ŋɔ́ bɛ́gháti yi.” ");
INSERT INTO kenNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Píta asɔt bɔ́ árɔk anywɔ́p nɛ bhɔ. Nɛ́yí nɔ́kɔ́, Píta afa are rɔ́ŋ nɛ bɔ́. Mbɔk bǒ nkwɔ́ Yesu abhɛn Jopa bárɔ́k nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Bákɔ bábhʉrɛ ambi, kɛ nɛ́yí nɔ́kɔ́ báchwɔp Seséria. Kɔnéliɔs anáŋ arɨŋɨ nyaka bɛ́ Píta ǎtwɔ̀. Ató bábhɨŋɨ bǒ nnɛrɛ́kɛt nɛ mamʉɛrɛ bhi. Bɔ́ mankɛm bachɔkɔ mánoŋ nɔkɔ bɔPíta. ");
INSERT INTO kenNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Nɛchwe Píta áchwe anywɔ́p, Kɔnéliɔs akwɛ́n yi bɛkak, abho bɛ́chyɛ yí kɛnókó. ");
INSERT INTO kenNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Kɛ Píta akɛm yí ndu awɔ, bɛ yí amfate, arɛm bɛ, “Mɛ nkwɔ́ nchí chí nkwǎ mbɔ wɔ.” ");
INSERT INTO kenNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Nɛ ndu bárɛ̀m kɛpɨ nɛ Píta, Píta achwe anywɔ́p, aghɔ́ bɛyǎ bo. ");
INSERT INTO kenNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Arɛm ntá yap bɛ, “Bě babhɔŋ bǎrɨŋɨ ndu ɛbhé ɛyɛsɛ ɛ́rɛ̀m bɛ mmu Israɛl abhɨkɨ bhɔ́ŋ bɛfyɛ mmʉɛt nɛ bo abhɛn bápú bo Israɛl nɛ abhɨkɨ bhɔŋ yɛ̌ chi bɛrɔŋ bɛghɔ bhɔ. Kɛ Mandɛm atɔŋ mɛ kpoŋoroŋ bɛ, nkɛ́ yɨŋɨ yɛ̌ mmu mbɔ bɛ abhɨkɨ kway bɛsí bha. ");
INSERT INTO kenNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ngɔ́ nɔ́kɔ́ yɛ bo abhɛn ɔ́tó, mfá nde twɔ́ nkɛkɛ́m ɛpʉ́ítí nɛ mmu. Ghatí yɛ mɛ ntí anɛ ɔ́bhɨŋɨ mɛ́!” ");
INSERT INTO kenNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kɔnéliɔs akɛmɛ yi bɛ, “Ɛ́kʉ manywɔp anwi ɛchɔŋ ɛnɛ́ nchí amɛm ɛkɛt ɛya nchí nɨkmʉɛt. Nkúbhɛ́ mpok mbɔ anɛ, mbɔ nkarɛnka ɛ́rát nɛ ngósí, mmu abhesi mɛ bɛsí nɛ nkú anɛ are ghɔɔ, ");
INSERT INTO kenNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","árɛm bɛ, ‘Kɔnéliɔs, Mandɛm aghok nɛnɨkɨ́mʉɛt ɛnɛ, nɛ aghɔ nɛkwak ɛnɛ́n ɔ́chyɛ̀ bachɛ́bhɛ́ bho. ");
INSERT INTO kenNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Tó yɛ mmu Jopa bɛ andɔk ambɨŋɨ mmu anɛ ákà nnyɛ́n bɛ Símun Píta. Achí kɛnkɔ amɛm ɛkɛt Símun ngoko nkwɔbhɛ́nya nɛ ɛkɛt ɛyi ɛ́chí angɔkɔ manyu!’ ");
INSERT INTO kenNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ntó yɛ bo tɛ́mté bɛ́ mámbɨ́ŋɨ́ wɔ, nɛ ɛ́rɨ ndu ɔ́twɔ́. Bɛsɛ́ mankɛm sɛ́chí fá bɛsí Mandɛm ndu bɛghok yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ́ Acha ágháti wɔ ɔ́ngátí bhɛsɛ́.” ");
INSERT INTO kenNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Píta abho yɛ bɛrɛm bɛ, “Ngɔ sayri bɛ́ Mandɛm apú tɔŋ kɛ́rɨ́ŋámík. ");
INSERT INTO kenNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Kɛ ndu yɛ̌ntɨkɨ ɛtɔk, yɛ agha anɛ áchày Mandɛm ankʉ nɔkɔ mɛnyɨŋ ɛbhɛ́n bɛ́chi chak bɛsí bhi, Mandɛm ǎsɔt yi ambak mmǔ ywi. ");
INSERT INTO kenNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nkáysí bɛ bǎrɨŋɨ ntó ɛnɛn yi ató nyaka ntá yɛsɛ bo Israɛl bɛ chɔŋ ankʉ bo mambak sayri nɛ yi ɛ̌ti ɛnyɨŋ ɛnɛ Yesu Kristo akʉ. Yi Yesu achí Acha amfǎy bo mankɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Bǎrɨŋɨ ɛrɛmɛ́ ndak anɛ́ áfákárí atú Judɛ́ya ankɛm, bɛ́bho atú Gálili, mpok Jɔ̌n ánáŋ ánáŋá nyaka bɛghati bo bɛ mántɨ́knsɛm ndǔ bɛbʉ́ bhap yi anjwiti bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Bǎrɨŋɨ ɛ̌ti Yesu mmu Násárɛt, nɛ ɛnyu Mandɛm achyɛ́ nyaka yi Ɛfóŋó Bɛdyɛrɛ nɛ bɛtaŋ. Akɔ mbǎnkɛm ankʉ nɔkɔ bɛrɨ nɛ ambu nɔkɔ bǒ mankɛm abhɛn Satan áchyɛ̀ bhɔ ɛsɔŋɔri mbɔnyunɛ Mandɛm achi nɛ yí. ");
INSERT INTO kenNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Nɛ sɛ́ghɔ nɛ amɨ́k mɛnyɨŋ mɛnkɛm ɛbhɛn yi ákʉ́ Yerúsalɛm nɛ mbaŋ ɛchak amɛm ɛtɔk bo Israɛl. Bágó yí ndu ɛkotákátí, agú. ");
INSERT INTO kenNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Kɛ ɛ́gháká nɔ́kɔ́ manywɔp árát, Mandɛm akʉ yi apɛtnsɛm ndu nɛpɛ́m, atɔ́ŋ mmʉɛt kpoŋoroŋ ntá bo. ");
INSERT INTO kenNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Kɛ abhɨkɨ tɔ́ŋ mmʉɛt chí ntá bo mankɛm. Atɔ́ŋ mmʉɛt ntá batísiɛ́ abhɛn Mandɛm ánáŋ áyábhɛ́, nɔ́ chí bhɛsɛ́ bo sɛ́nyíɛ́ nɛ sɛ́nyú nɛ yi mpok yi ápɛ́rɛ́nsɛm ndu nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nɛ yi aghátí bhɛsɛ bɛ́ sɛ́kɛ́rɔ bɛghati Mbok Ndɨ́ndɨ́ yɔ ntá bo, nɛ bɛ́ sɛ́nkʉ bo mándɨŋɨ bɛ́ yí kɛ̌ Mandɛm ayabhɛ bɛ ambak mmu nɛ ábhɔ́ŋɔ́ bɛ́táŋ bo abhɛn bachi nɛpɛ́m nɛ abhɛn bágú. ");
INSERT INTO kenNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Barɛmɛ́ kɛpɨ̌ntɨ mankɛm bárɛ̀m nyaka ɛ̌ti yi bɛ, yɛ̌ agha anɛ asɨkɨ ntɨ nɛ Yesu, Mandɛm ǎfoŋori bɛbʉ́ ɛbhi ɛ̌ti yi Yesu.” ");
INSERT INTO kenNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ɛnɛ́ Píta abhʉɛ́t bɛ́rɛm mɛnyɨŋ ɛbhɔ, Ɛfóŋó Bɛdyɛrɛ atwɔ́ abhak nɛ bo mankɛm abhɛn bághòk Ɛyɔŋ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Bǒ nkwɔ́ Yesu abhɛn bachí bo Israɛl, nɔ́ chí abhɛn báfú Jopa nɛ Píta, bábhak maknkay tontó mbɔnyunɛ bághɔ́ bɛ Mandɛm achyɛ́ Ɛfóŋó Bɛdyɛrɛ ntá bo abhɛn bápú bo Israɛl nkwɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Bábhak maknkay mbɔnyunɛ bághók ndu bobhɔ́ bárɛ̀m bɛyɔŋɔ́tɔk bɛ́chák bɛ́chák ɛbhɛ́n bɔ́ bábhɨkɨ ghɔ́k, mándɛmɛ nɔkɔ bɛ, “Mandɛm ataŋ nɛ arɨ achá!” Ɛ́kʉ Píta arɛm bɛ́, ");
INSERT INTO kenNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Mandɛm achyɛ́ bǒbhɛn Ɛfóŋó Bɛdyɛrɛ nkúbhɛ́ mbɔnyu yí áchyɛ́ nyaka bhɛsɛ bo Israɛl. Agha ákwáy yɛ bɛ́káŋ bɛ́ bákɛ́ jwiti bhɔ́?” ");
INSERT INTO kenNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Achyɛ yɛ ɛyɔŋ bɛ́ mánjwiti bhɔ́ ndu nnyɛ́n Yesu Kristo. Bájwítí bhɔ. Bárɛm bɛ Píta anchɔkɔ nɛ bhɔ ndu mpǎy manywɔp. ");
INSERT INTO kenNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Bǒnto nɛ bakoŋo Yesu báchák atú Judɛ́ya ankɛm, bághók bɛ mbɔk bo abhɛn bápú bo Israɛl mánóko Ɛyɔŋ Mandɛm nkwɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Mbɔk bo bachi nyaka ndu nkwɔ́ bakoŋo Yesu abhɛn báte bɛ bábhɔŋ bɛ́siɛ́p yɛ̌ntɨkɨ mmu mbɔ bɔ́ bo Israɛl, kɛ ankwáy bɛ́bhak mmu Mandɛm. Píta ápɛ́rɛ́ nɔ́kɔ́ nsɛm Yerúsalɛm, bǒbhɔ báré ji yí mándɛmɛ nɔkɔ bɛ, ");
INSERT INTO kenNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Yí ɛkʉ ɔ́rɔ́ŋ ɔ́chwé amɛm ɛkɛt bo ɛtɔk ɛ́chák abhɛn bábhɨkɨ syɛp bhɔ kpátɛ ɔ̌nyìɛ nɛnyíɛ́ nɛ bhɔ́?” ");
INSERT INTO kenNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Píta abho yɛ bɛ́ghati bhɔ́ sayri yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ́ ɛ́fákári tɛ ndǔ nɛbhǒnɛt bɛ, ");
INSERT INTO kenNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ɛwak ɛ́mɔt ndu nchí nɨkmʉɛt awu ɛtɔk Jopa, ngɔ́ kɛnɔ́ amɨ́k antífú. Ngɔ́ ndu ɛnyɨŋ ɛ́fú amfay ɛ́sɛ̀p. Ɛbhak mbɔ ntěndɛn nɛgho ɛnɛn bákɛ́mɛ́ bati yi anwi básɛ̀bhɛ amɨk. Ɛgháká nɔ́kɔ́ kɛkwɔ́t nɛ mɛ ɛ́te. ");
INSERT INTO kenNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Njɨŋɨ sayri bɛghɔ ɛnyɨŋ ɛnɛ ɛchi arɛ. Ngɔ́ nnya mɛnyu nɛ mɛnyu. Nnya ɛnɛ anywɔ́p nɛ nnya ɛbebe nɛ nnya ɛnɛ́ ɛ́sù mɛniɛ amɨk nɛ kɛnɛn. ");
INSERT INTO kenNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ngók ɛyɔŋ ndu ɛ́ghàti mɛ bɛ ‘Píta, faté, wáy nyiɛ!’ ");
INSERT INTO kenNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Kɛ nkɛmɛ bɛ ‘Acha wáwák! Mbɨ́kɨ́ re nyiɛ́ ɛnyɨŋ ɛnɛ́ ɛ́pú pɛ́pɛ́p bɛsí ɛbhɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Kɛ ɛyɔŋ ɛpɛt ɛrɛm ndɔŋ anɛ ájwi ɛpay bɛ, ‘Ɛnyɨŋ ɛnɛ Mandɛm akʉ bɛ ɛmbak pɛ́pɛ́p, yɛ̌ mmu ákɛ́ rɛm bɛ ɛpu pɛ́pɛ́p.’ ");
INSERT INTO kenNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ɛ́fákári ɛnyu ɛyɔ ndɔŋ ɛ́rát, ɛnyɨŋ ɛyɔ ɛ́pɛ́tnsɛm amfay. ");
INSERT INTO kenNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Nkúbhɛ́ mpok yɔ, bo batí arat bachwɔp ambǐnywɔp ɛkɛt ɛnɛ́ nchí arɛ́. Báfú Seséria nɛ ntó bɛ́ mánsɔt mɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ɛfóŋó Bɛdyɛrɛ aghati mɛ bɛ, ‘Faté sɛp dɔ́k nɛ bhɔ. Ɔ́kɛ́ fyɛ ntí bɛ́ bápú bo Israɛl.’ Bɔ̌mayɛsɛ abhɛn batí átándát abhɛn Jopa bákóŋo mɛ sɛ́rɔk Seséria, nɛ bɛsɛ mankɛm sɛ́chwe ɛkɛrɛ́ mmu wu Kɔnéliɔs. ");
INSERT INTO kenNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Aghati bhɛsɛ́ ndu yí ághɔ́ ángɛl Mandɛm ɛkɛt ɛyi nɛ ángɛl wu ágháti yi bɛ ántó bo Jopa mámbɨŋɨ mɛ Símun Píta bɛ ");
INSERT INTO kenNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ndɔ́k ngáti yi mbok anɛ ákʉ̀ yi andɨ́ŋɨ́ ɛnyu Mandɛm akway bɛpɛmɛ yi nɛ ɛfo ɛyi ɛnkɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nɛbho mbó bɛ́gháti bhɔ mɛnyɨŋ, Ɛfóŋó Bɛdyɛrɛ atwɔ́ ntá yap nkúbhɛ́ mbɔ ɛnyu ɛ́fákári nyaka nɛ bhɛsɛ ndǔ nɛbhǒnɛt. ");
INSERT INTO kenNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ntɨk yɛ ɛnyɨŋ ɛnɛ Yesu Acha árɛ́mɛ́ nyaka bɛ, ‘Jɔ̌n ǎjwiti bo nɛ manyiɛp, kɛ chɔŋ mánjwiti bhe nɛ Ɛfóŋó Bɛdyɛrɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Be bábhɔŋ, ghɔ́ yɛka! Mandɛm achyɛ́ bǒbhɔ nkúbhɛ́ akap anɛ́ yi achyɛ́ nyaka bhɛsɛ mpok sɛ́nókó Yesu Kristo Acha. Nchí yɛ́ nyaka agha bɛchɛt Mandɛm mbi?” ");
INSERT INTO kenNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Bághókó nɔkɔ mɛnyɨŋ ɛbhɛn Píta árɛ́mɛ́ mɛnkɛm, manyu áchók bhɔ. Báre chyɛ Mandɛm kɛnókó mandɛm nɔkɔ bɛ, “Nɔ Mandɛm achyɛ mbi ntá bo abhɛn bápú bo Israɛl nkwɔ bɛ mankway bɛtɨknsɛm ndǔ bɛbʉ́ ɛbhap, mambɔŋ nɛpɛ́m!” ");
INSERT INTO kenNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Bɛyǎ bakoŋo Yesu báfú nyaka Yerúsalɛm ɛ̌ti ɛsɔŋɔri ɛnɛ ɛbho mpok báwáy Stífin bataka mbaŋ nɛ mbaŋ. Mbɔk bárɔk kpatɛ atú Foníshia, báchák tɛ Sáyprɔs nɛ abhɛnɛfu tɛ Ántiɔk. Bárɔŋ nɔkɔ nɔ, mangati nɔkɔ mbok Yesu ntá bo Israɛl bɔ́bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Kɛ mbɔk abhɛn bachi bo Sáyprɔs nɛ abhɛn bachi bo Sírene bárɔk Ántiɔk bábhó bɛ́gháti Mbok Ndɨ́ndɨ́ Yesu ntá bo abhɛn bápú bo Israɛl nkwɔ́. ");
INSERT INTO kenNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Acha abhak nɛ bhɔ́, akwak bɛyǎ mánoko bábho bɛkoŋo mbi ywi. ");
INSERT INTO kenNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Mbok akɔ aghaka ntá bǒnkwɔ Yesu abhɛn Yerúsalɛm. Bátó Banábas ɛtɔk Ántiɔk. ");
INSERT INTO kenNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Agháká nɔ́kɔ́ árɛ́, aghɔ́ ndu Mandɛm átɔ́ŋɔ́ bǒbhɔ bɛrɨ̌ndu ɛbhi, abhɔ́ŋ bɛyǎ maŋák, abho bɛ́fyɛ́ bhɔ́ ntɨ bɛ mámbak tɛtɛp nɛ Yesu, mánte kpirí mpoknkɛm nɛ ntɨ nɛnkɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banábas achí nyaka ɛrɨ́tí mmu anɛ asɨkɨ ntɨ nɛ Yesu sayri. Ɛfóŋó Bɛdyɛrɛ abhak nɛ yí tontó. Akwak bɛyǎ bo mánoko mbok Yesu, báchɛm mmʉɛt nɛ bakoŋo bhi. ");
INSERT INTO kenNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Banábas arɔk yɛ Tásɔs bɛ́yaŋ Sɔ̌l. ");
INSERT INTO kenNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ághɔ́ nɔ́kɔ́ yi, asɔt yí apɛtnsɛm Antiɔk nɛ yi. Sɔ̌l nɛ yi bábhak arɛ ndǔ mmíɛ́ nɛnkɛm nɛ nkwɔ Yesu, mántɔŋ nɔkɔ bɛyǎ bo Mbok Ndɨ́ndɨ́. Chi Antiɔk kɛ bábhó nyaka bɛbhɨŋɨ bakoŋo Yesu bɛ, “Nkwɔ Kristo.” ");
INSERT INTO kenNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Mpok yɔ, mbɔk barɛmɛ́ kɛpɨ̌ntɨ báfú Yerúsalɛm barɔk Antiɔk. ");
INSERT INTO kenNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Mmu wap amɔt áká nnyɛ́n bɛ́ Ágábɔs. Ndu bɛtaŋ Ɛfóŋó Bɛdyɛrɛ afate arɛm bɛ chɔŋ ɛrɛmɛ nsay ɛ́nkwɛ́n ndǔ bɛtɔk mɛnkɛm ɛbhɛ́n bɛ́chí antɛn Mfɔ Rom. Nsay yɔ akwɛ́n mpok Klaodiɔs áchí Mfɔ Rom. ");
INSERT INTO kenNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Bakoŋo Yesu abhɛn Antiɔk baghoko nɔkɔ ɛnyɨŋ ɛnɛ Ágábɔs árɛ́mɛ́, báká ɛyɔŋ ɛ́mɔt bɛ mánchwɔp nkáp manto ndu bɛkwak batɨ̌ bakoŋo Yesu abhɛn báchi atú Judɛ́ya. Yɛ̌ntɨkɨ mmu wap abhɔ̌ŋ nyaka bɛ́chyɛ mbɔ ɛnyu amɔ yi atɔŋɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bákʉ́ ɛnyu ɛyɔ, bátó Banábas nɛ Sɔ̌l Yerúsalɛm bɛ mándɔk mánchyɛ nkáp wu ntá bǒbati bǒnkwɔ Yesu. ");
INSERT INTO kenNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ndu mpok yɔ, Mfɔ Hɛ́rɔd abho bɛ́chyɛ nɛnyok ntá mbɔk bǒnkwɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Achyɛ ɛyɔŋ bákɛ́m Jems manɔ Jɔ̌n báwáy nɛ akparɛnja. ");
INSERT INTO kenNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ághɔ́ nɔ́kɔ́ bɛ́ ɛnyɨŋ ɛnɛ yí ákʉ́ ɛ́chyɛ̀ bo Israɛl maŋák, arɔk ambɨ nɛ bɛbʉ́ bhi, achyɛ ɛyɔŋ bɛ mánkɛ́m Píta nkwɔ́. Ɛyɔ ɛ́fákárí ndǔ mpok Ɛpǎ brɛt anɛ kɛbhɔŋ yís. ");
INSERT INTO kenNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Bákɛ́m nɔ́kɔ́ Píta, arɛm báfyɛ́ yi ɛkɛrɛ́kɛnɔŋ. Bakwɔ́ batɛmɛ́ nɛnu ábhak anwi ndu bɛbhabhɛri yi mkpák nɛ mkpák. Yɛ̌ntɨkɨ nkwɔ́ wap ábhɔ́ŋ batɛmɛ́ nɛnu manwi. Hɛ́rɔd abhɔ́ŋ nkaysi bɛ Ɛpǎ Nɛkɨŋɨ ɛ́mfʉ́ɛ́t, mámfɛrɛ yi mántáŋ kpoŋoroŋ bɛsí bho. ");
INSERT INTO kenNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kɛ ɛnɛ́ batɛmɛ́ nɛnu bábhàbhɛri Píta ɛkɛrɛ́kɛnɔŋ, bakoŋo Yesu báré nɨkmʉɛt ntá Mandɛm nɛ batɨ yap ankɛm ɛ̌ti yi. ");
INSERT INTO kenNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Nkúbhɛ́ bɛti ɛbhɛ́n Hɛ́rɔd árɔ́bhɛ́ nóŋ chi bɛ nywɔp nɛ́njí mámfɛ́rɛ́ Píta ɛkɛrɛ́kɛnɔŋ mántáŋ yi bɛsí bho, Píta abhak bhʉrɛ nɛ́ntɨ batɛmɛ́ nɛnu bati apay, femfé nɛ ngɛm. Ngɛm amɔt abhat yi nɛ ntɛmɛ́ nɛnu amɔt ndǔ ɛbhěmʉɛt ɛ́mɔt, achák abhat yi nɛ ntɛmɛ́ nɛnu anɛfú ndǔ ɛbhěmʉɛt ɛ́chák. Batɛmɛ́ nɛnu báchák bábhak anyǔbhá mámbabhɛri nɔkɔ ɛkɛrɛ́kɛnɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ángɛl Mandɛm abhesi tɛ́mchók, bɛdiɛrɛ bɛ́kwɛ́n amɛm ɛkɛrɛ́kɛnɔŋ. Ángɛl akɛ́m Píta ndǔ nɛnkɨ anyɨkɨsi, áŋɛ́mɛ́ yí arɛm bɛ, “Faté áyák!” Tɛ́mté wu ngɛm ɛnɛ́ ɛ́chí amɔ́ Píta ɛ́yóko ɛ́kwɛ́n amɨk. ");
INSERT INTO kenNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ángɛl ágháti yɛ Píta bɛ, “Fíɛ́ nkú nɛ nkwɔbánya ɛyɛ.” Píta akʉ nɔ. Apɛt aghatí yi bɛ, “Bhat ndɛ́ yɛ amʉɛt, koŋó mɛ.” ");
INSERT INTO kenNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Píta abho bɛ́koŋo yi. Nɛfú anɛ báfú ɛkɛrɛ́kɛnɔŋ, yí kɛrɨŋɨ bɛ ɛnyɨŋ ɛnɛ ángɛl ákʉ̀ ntá yi chí ndaká tɛtɛp. Are kaysi bɛ́ ághɔ̀ nɔ chi kɛnɔ́ amɨ́k antífú. ");
INSERT INTO kenNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Báfʉɛ́t nɛbhʉɛt anɛ babhabhɛri abhɛn mbɨ nɛ nɛbhʉɛt anɛ abhɛn bákòŋo báchwɔp ndu nyǔbha anɛ́ mmu ǎfʉɛt anchwe ɛtɔk. Nnyǔbha wu ánɛ́nɛ ndu mmʉɛt ɛyi. Báfú bárɔ́k nɛfí, bákɔ baghaka ndʉ́ nkɔngɔ ɛtɔk amɔt. Píta ápɛ́rɛ́ yɨŋɨ ángɛl ánáŋ árɔ́ yi arɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Píta arɨŋɨ yɛ bɛ́ tɛtɛp yí afuu ɛkɛrɛ́kɛnɔŋ, arɛm bɛ, “Nɛ́nɛ, ndɨ́ŋɨ́ tɛtɛp bɛ́ Mandɛm ato ángɛl aywi ántwɔ́ ámfɛ́rɛ́ mɛ́ amɔ Hɛ́rɔd nɛ ndǔ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ́ bo Israɛl batɨ bɛ́kʉ mɛ.” ");
INSERT INTO kenNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Árɨ́ŋɨ́ nɔ́kɔ́ ɛnyɨŋ ɛnɛ́ ɛ́fákárí ntá yi, afʉɛ́t arɔk ɛkɛrɛ́ Maria, nnɔ Jɔ̌n Mák. Bɛyǎ bo báchɛmti nyaka arɛ mánɨk nɔkɔ mmʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Píta abho bɛ́dɛp nɛkok ɛnɛn mbɨ. Ngɔsɔ́ŋ anɛ aka nnyɛ́n bɛ Róda áchí nyaka mmɔ̌ bɛtok anywɔ́p. Arɔk bɛrɨŋɨ mmu anɛ ádɛ̀p nɛkok. ");
INSERT INTO kenNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Aghók bɛ́ chí ɛyɔŋ Píta. Nɛ bɛyǎ maŋák, arɔ mbǐnyɔ́p kɛnɛnɛ apɛtnsɛm aghati bǒ mankɛm bɛ́, “Píta achí ambǐnywɔp téé!” ");
INSERT INTO kenNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Bárɛm bɛ, “Ɔ̌bhokori!” Kɛ arɔk chi ambɨ bɛ́gháti bhɔ bɛ́, “Chí Píta tɛtɛp.” Afɔ̌ kɛ barɛmɛ bɛ, “Chi ángɛl aywi.” ");
INSERT INTO kenNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Mpok yɔ nkɛm, Píta are dɛp nɛkok. Mánɛ́nɛ́ nɔ́kɔ́ mbǐnywɔp, bághɔ́ bɛ chi Píta tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Asá awɔ́ bɛ mánchɔ́kɔ́ kpák. Báchɔkɔ kpák kpák. Abho yɛ bɛ́gháti bhɔ ɛnyǔ Mandɛm afɛrɛ yi ɛkɛrɛ́kɛnɔŋ. Ánáŋá nɔ́kɔ́, aghati bhɔ́ bɛ mángátí Jems nɛ bǒnkwɔ́ bachak ɛnyɨŋ ɛnɛ́ ɛ́fákári. Arɔ yɛ bhɔ́, arɔk ɛbhak ɛchák. ");
INSERT INTO kenNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Nɛ́yí nɔ́kɔ́, ɛbyɔk ɛ́kwɛ́n ɛkɛrɛ́kɛnɔŋ. Batɛmɛ́ nɛnu abhɛn bábhàbhɛri Píta, báré makati mámbɛbhɛ nɔkɔ ɛnyɨŋ ɛnɛ ɛ́fákárí nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Mfɔ Hɛ́rɔd ághókó nɔ́kɔ́ bɛ́ bábhɨkɨ ghɔ́ Píta, achyɛ ɛyɔŋ bɛ́ mánjáŋ yi. Báyáŋ yí kɛ bákɛ ghɔ yi. Hɛ́rɔd abhɨŋɨ batɛmɛ́ nɛnu bhɔ, ábhɛ́bhɛ́ nɔ́kɔ́ bhɔ mɛnyɨŋ, achyɛ ɛyɔŋ bɛ́ mángwáy bhɔ́. Hɛ́rɔd afa atú Judɛ́ya anɛ́ yí áchí arɛ arɔk atú Seséria áchák achɔkɔ arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Hɛ́rɔd ǎbentɨ tontó nɛ bǒ-Taya nɛ abhɛn Sídɔn. Ɛkʉ bɛtɔk ɛbhɔ bɛ́pay bɛyap nkwɔ bho. Bátó bhɔ́ mándɔ́k mángɔ́ Hɛ́rɔd. Báyámbɨ bághɔ́ chí Blastɔs, nkɛ́mfɔ anɛ Hɛ́rɔd. Aka bɛkwak bhɔ mánsókórí nɛ Mfɔ Hɛ́rɔd bɛ ɛsɔŋɔri ɛ́máy nɛ́ntɨ́ bɛtɔk Táya nɛ Sídɔn nɛ ɛyi. Báyàŋ nyaka bɛbhak ɛyɔŋ ɛ́mɔt nɛ Mfɔ Hɛ́rɔd mbɔnyunɛ nɛnyíɛ́ ɛnap nɛ́fù nyaka chi atú ɛtɔk ɛnɛ achi antɛn yi. ");
INSERT INTO kenNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Nywɔp Mfɔ Hɛ́rɔd afyɛ́ ndu bɛrɛm kɛpɨ nɛ bhɔ nɛkwáy nɔ́kɔ́, afyɛ́ ndɛn kɛfɔ yi, achɔkɔ ndu ɛnɔkɔ́ kɛfɔ arɛm kɛpɨ bɛsi bǒbhɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Bǒbhó bare bɨk bɛ, “Chi ɛyɔŋ mandɛm. Puyɛ chi ɛyɔŋ ɛnɛ nkwǎŋwaŋ!” ");
INSERT INTO kenNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tɛ́mté wu, ángɛl Mandɛm aguɛ́p yi nɛme amʉɛt mbɔnyunɛ arɔ́ bo mánchyɛ yi kɛnókó ɛkɛn babhɔŋɔ bɛchyɛ chi ntá Mandɛm. Kɛ́nyoŋo kɛ́nyíɛ́ yi, agú. ");
INSERT INTO kenNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Kɛ, Ɛyɔŋ Mandɛm ɛ́re go ɛ́ndɔkɔ nɔkɔ chi ambɨ. ");
INSERT INTO kenNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banábas nɛ Sɔ̌l, mánáŋá nɔ́kɔ́ bɛkʉ ɛnyɨŋ ɛnɛ́ ɛ́pɔ́kɔ́ bhɔ́ Yerúsalɛm, bápɛtnsɛm Antiɔk. Básɔ́t Jɔ̌n Mák, arɔk nɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Barɛmɛ́ kɛpɨ̌ntɨ nɛ batɔŋ Ɛyɔŋ Mandɛm báchi nyaka ndǔ Nkwɔ Yesu abhɛn Antiɔk. Bábhak Banábas, nɛ Símiɔn anɛ bábhɨ̀ŋɨ bɛ́ Ɛgírímɔ, nɛ Lusiɔs anɛ áfú Sírene, nɛ Manáen anɛ áchí nyaka mmʉɛrɛ kɛmbɔ́ anɛ Mfɔ Hɛ́rɔd Ántipas, nɛ Sɔ̌l. ");
INSERT INTO kenNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ɛwak ɛ́mɔt, ɛnɛ báchí ndǔ nɛtarɛ́nsay nɛ nɛnɨkɨ́mʉɛt mánchyɛ nɔkɔ Mandɛm kɛnókó, Ɛfóŋó Bɛdyɛrɛ arɛm bɛ, “Dɔ̌ ká Banábas nɛ Sɔ̌l, mámbák nyáŋá ndu bɛtɨk ɛbhɛn mbɨŋɨ bɔ mankʉ.” ");
INSERT INTO kenNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Bághókó nɔ́kɔ́ nɔ, bárɔ́k ambɨ nɛ nɛtarɛ́nsay nɛ nɛnɨkɨ́mʉɛt. Mányáŋa yɛ amɔ anti Banábas nɛ Sɔ̌l manɨkmʉɛt, barɔ yɛ bɔ mandɔk. ");
INSERT INTO kenNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Banábas nɛ Sɔ̌l bárɔk mbɔ ɛnyu Ɛfóŋó Bɛdyɛrɛ átó bhɔ. Bárɔ́k Sɛlusia básɔt achwǐnyɛ́n anɛ árɔ̀ŋ ndǔ ɛtɔk nɛ́ntɨ́nyɛn ɛnɛ babhɨŋɨ bɛ Sáyprɔs. ");
INSERT INTO kenNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Báchwɔ́bhɛ́ nɔkɔ arɛ ndu mɔ́tɔk anɛ bábhɨŋɨ bɛ́ Salamis, bárɔ áchwi nɛkunyɛ́n bákó ɛtɔk mángati nɔkɔ Ɛyɔŋ Mandɛm amɛm bɛkɛrɛ́ nɛnɨkɨ́mʉɛt bo Israɛl. Jɔ̌n Mák abhak nɛ bhɔ́, ankwak nɔkɔ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Bárɔ́k ambɨ ɛnyuyɔ ndǔ bɛtɔk nɛ bɛtɔk kpát bákɨŋɨ ɛtɔk nɛntɨnyɛn Sáyprɔs ɛyɔ ɛnkɛm báchwɔp Pafɔs. Bátɛ́mɛri mmu Israɛl arɛ́ anɛ achi mǔnjɔ kɛ ǎpù bapu bɛ́ achí ndɛmɛkɛpɨ̌ntɨ Mandɛm. Aka nnyɛn bɛ́ Ba-Jesus. ");
INSERT INTO kenNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Achí nyaka mpoknkɛm nɛ gɔ́bhanɔ ɛtɔk ɛyɔ anɛ aka nnyɛ́n bɛ Sɛjɔs Paólɔs. Sɛjɔs Paólɔs abhak ndɨŋɨndak. Abhɨŋɨ Banábas nɛ Sɔ̌l mbɔnyunɛ áyàŋ nyaka nkwɔ bɛghok Ɛyɔŋ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Nnyɛ́n Ba-Jesus nɛchak nɛchi nyaka bɛ́ Ɛ́límas nɔ chi mǔnjɔ ndu ɛyɔŋ Grik. Ɛ́límas mǔnjɔ abho bɛ́kɛm ɛpʉ́ítí nɛ bhɔ ndu yi áyàŋ bɛ́kʉ gɔ́bhanɔ ákɛ́ koŋo mbi Yesu. ");
INSERT INTO kenNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Bɛtaŋ Ɛfóŋó Bɛdyɛrɛ bɛbhak nɛ Sɔ̌l anɛ nnyɛ́n ɛni nɛ́chák nɛ́chí nyaka bɛ́ Pɔ̌l. Pɔ̌l atɛp yi amɨ́k amʉɛt, ");
INSERT INTO kenNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","arɛm bɛ, “Wɔ mmɔ̌ Satan! Wɔ mmu ɔ́pábhɛ́ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ ɛchi chak bɛsí Mandɛm. Wɔ mmu bapu ájwí wɔ́ mɛniɛ. Ɔpú rɔ bɛkʉ mbi Mandɛm anɛ achí chak ambak ŋɔ́tíŋɔ́tí?” ");
INSERT INTO kenNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Dɨŋɨ́ bɛ awɔ Mandɛm ákwɛn wɔ amʉɛt nɛ́nɛ. Nɛ chɔŋ amɨ́k ánɛmɛ wɔ, ɔ́kɛ́pɛrɛ kwáy bɛghɔ mbaŋ ndǔ mbɨŋɨ́ mpok. Tɛ́mté wu, nɛbháŋ nɛ́kúti yi amɨ́k ɛjuri ɛ́kwɛ́n yi bɛsí arɔbhɛ nɛmɛri nɛ́mɛ́ri ambɛbhɛ nɔkɔ mbák mmu achí anɛ ákway bɛkɛm yi awɔ ánjá yi mbi. ");
INSERT INTO kenNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gɔ́bhanɔ ághɔ́ nɔ́kɔ́ ɛnyɨŋ ɛnɛ ɛ́fákári, anoko Mbok Ndɨ́ndɨ́ ɛ̌ti Yesu. Ɛ́bhak yi maknkay bɛ́ghok mɛnyɨŋ ɛbhɛn bátɔ̀ŋ ɛ̌ti Yesu Acha. ");
INSERT INTO kenNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pɔ̌l nɛ bo abhɛn bákɔ̀ nɛ yi bachwe ɛtɔk Pafɔs, bákɔ́ anyɛ́n anyɛ́n barɔk bágháka Pɛ́ga atú Pamfília. Jɔ̌n Mák arɔ bhɔ́ arɛ apɛtnsɛm Yerúsalɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Bárɔ Pɛga bárɔk ambɨ kpát báchwɔ́p Antiɔk atú Pisídia. Ɛ́gháká nɔ́kɔ́ nywɔbhɛ́ nɛywěmʉɛt bo Israɛl, bárɔk bachwe ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí báchɔkɔ amɨk. ");
INSERT INTO kenNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Bápáy nɔkɔ Ɛkáti Mandɛm mbɔ ɛnyu Moses asɨ́ŋɨ́ nɛ ɛnɛ ɛ́fú ndǔ basɨŋɨ́ barɛmɛ́ kɛpɨ̌ntɨ, bǒ batí ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí ɛyɔ bátó mmu bɛ ángátí bɔPɔ̌l bɛ, “Bɔ̌ma, mbák bǎbhɔŋ ɛnyɨŋ ɛnɛ́ ɛkway bɛfyɛ bhɛsɛ ntɨ, ghatí ká bhɛsɛ.” ");
INSERT INTO kenNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pɔ̌l afate yɛ asá nɛ awɔ bɛ bo manchɔkɔ kpák. Abho yɛ bɛrɛm bɛ, “Bo Israɛl nɛ bo bɛtɔk bɛ́chák abhɛn báchày Mandɛm, ghók ká! ");
INSERT INTO kenNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Mandɛm bo Israɛl ayap nyaka bachǐmbɨ bhɛsɛ́ akʉ nnɛrɛ́kɛt bǒ bhɛsɛ áchɨk mpok báchí mankɔ amɛm ɛtɔk Íjip. Mandɛm afɛrɛ bhɔ́ ndu kɛsɛm arɛ́ nɛ bɛtaŋ ɛbhi ɛbhɛn bɛyǎ bɛcha. ");
INSERT INTO kenNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ndǔ mamiɛ́ bɛsa bɛpay, abhak nɛ bhɔ́ amɛm baso, abhɔ́ŋ ɛkɛ́bhɛ́ntɨ́ nɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Mpok babhɔŋɔ bɛ́chwe ɛtɔk Kánǎn akʉ mánáŋa manɛrɛ́kɛt bo tándrámɔt anɛ achi arɛ, achyɛ bo Israɛl mmɨk Kánǎn. ");
INSERT INTO kenNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ndǔ mamiɛ́ ankɛm anɛ́ bɔ báchɔ́kɔ́ ɛtɔk Íjip nɛ anɛ́ báchí amɛm baso kɛ báchwe Kánǎn ábhák mbɔ mamiɛ́ bɛsa bɛbay nsɛm byo (450). Achyɛ yɛ bhɔ bataŋá manyé nɛ bɔ babhak kpátɛ ndǔ mpok Samuɛl anɛ achi nyaka ndɛmɛkɛpɨ̌ntɨ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ɛ́gháká nɔ́kɔ́ mpok bábhɛ́bhɛ́ yɛ Samuɛl bɛ ánchyɛ bhɔ mfɔ, Mandɛm ayap Sɔ̌l, mmɔ̌ Kish. Kish afú ndǔ nnɛrɛ́kɛt Bɛnjamin. Sɔ̌l abhak mfɔ wap ndǔ mamiɛ́ bɛsa bɛ́pay. Kish afú nyaka ndu nnɛrɛ́kɛt Bɛnjamin. ");
INSERT INTO kenNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Mandɛm áfɛ́rɛ́ nɔ́kɔ́ yi ndǔ ɛnɔkɔ́ kɛfɔ, ayap Debhít bɛ ambak mfɔ wap. Mandɛm arɛm ɛ̌ti Debhít bɛ, ‘Debhít mmɔ̌ Jése, chí mmu anɛ mbɔ́ŋɔ́ maŋák nɛ yi, mmu anɛ apú nɔ́k bɛkʉ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ ndɛ́mɛ́ yi ankʉ.’ ");
INSERT INTO kenNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Mandɛm akʉ ɛbhárɛ́mɔ Debhít ambák Mpɛmɛ bo Israɛl bɛ́kóŋo bariɛp ami ntá bachǐmbɨ bhap. Mpɛmɛ wu chí Yesu. ");
INSERT INTO kenNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jɔ̌n anáŋ ayambɨ aghátí nyaka bo Israɛl mankɛm bɛ mántɨknsɛm ndǔ bɛbʉ́ bhap mámpɛtnsɛm ntá Mandɛm bɛ yi anjwiti bhɔ́, kɛ Yesu antwɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ɛ́rɔ́bhɛ́ nɔ́kɔ́ kɛ́kwɔ́t bɛ Jɔ̌n ánaŋa bɛtɨk ɛbhi, abhɛ́p bo bɛ, ‘Bǎkáysí bɛ́ mɛ kɛ nchí Mpɛmɛ anɛ ábhɔ́ŋɔ́ bɛ́twɔ kɛ? Chao! Puyɛ̌ mɛ! Ghók ka, yí átwɔ̀ mɛ ansɛm, nɛ mbɨ́kɨ́ kway mbɔ̌ŋ mmu anɛ áchoti, bɛfɛrɛ nkwɔbhánya bɛkak ɛbhi.’” ");
INSERT INTO kenNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Pɔ̌l apɛt arɛm ntá yap bɛ, “Bɔ̌ma, bɛbhárɛ́bhɔ Ábraham, nɛ beká bo bɛtɔk bɛ́chák abhɛn báchày Mandɛm, chi ntá yɛsɛ kɛ Mandɛm átó yɛ ntó ɛnɛ́n nɛ́ghàti bhɛsɛ ɛnyu ɛnɛ́ yi akway bɛpɛmɛ bhɛsɛ! ");
INSERT INTO kenNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Bǒ Yerusalɛm nɛ bǒbatí bhap bábhɨ́kɨ́ sɔt nyaka Yesu mbɔ Mpɛmɛ anɛ Mandɛm átó. Ɛkʉ bátáŋ yi, bakpɔt manyé yi bɛ babhɔŋ bɛway yi. Nɛ ndu bákʉ́ nɔ, ɛnyɨŋ ɛnɛ barɛmɛ́ kɛpɨ̌ntɨ bárɛ́mɛ́ nyaka ɛ̌ti yi ɛ́fú tɛtɛp. Nɛ yɔ kɛ bɔ bápày nyaka yɛ̌ntɨkɨ nywɔbhɛ́ nɛywɛ̌mʉɛt ɛnap. ");
INSERT INTO kenNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Yɛ̌ndu bábhɨ́kɨ́ ghɔ́ ntí anɛ bábhɔ́ŋɔ́ bɛ́rɛm bɛ mangway yi, bárɛm bɛ Páílet andɔ mangway Yesu. ");
INSERT INTO kenNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Nɛ mánáŋá nɔ́kɔ́ bɛ́kʉ yɛ̌ntɨkɨ ɛnyɨŋ mbɔ ɛnyu Ɛkáti Mandɛm ɛ́rɛ́mɛ́ ɛ̌ti yi, báfɛ́rɛ yi amfǎy ɛkotákátí barɔk babhʉrɛ amɛm nnɛm ɛnɛ́n bághókó ndu sɛtárɛ́bhɛ́. ");
INSERT INTO kenNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Yɛ̌ nɔ, Mandɛm akʉ yi apɛtnsɛm ndu nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Nɛ ndu bɛyǎ manywɔp are bhesi bɛsí bo abhɛn bákɔ̀ nyaka nɛ yi bɛbho Gálili kpatɛ Yerúsalɛm. Bɔ́bhɔ kɛ báchí batísiɛ́ bhi ntá bo Israɛl. ");
INSERT INTO kenNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Banábas nɛ mɛ sɛ́twɔ fá bɛ́gháti beka Mbok Ndɨ́ndɨ́ bɛ bariɛp amɛn Mandɛm afyɛ́ nyaka nɛ bachǐmbɨ bhɛsɛ́, ");
INSERT INTO kenNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","akʉ mɔ́ afǔ tɛtɛp ntá yɛsɛ́ bɛbhárɛ́ bhɔ́ bhap, ndu ákʉ́ Yesu apɛrɛnsɛm ndǔ nɛpɛ́m. Mandɛm akʉ bariɛp ɛmɔ afǔ tɛtɛp mbɔ ɛnyu ɛchi amɛm Ɛkáti Bakway, bɛbhɔ́k bɛpay bɛ Mandɛm arɛm bɛ: ‘Wɔ ɔchí Mɔ́wa, nɛ ɛchɔŋ nchí rɛm kpoŋoroŋ bɛ Nchí Ɛtayɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Nɛ bɛ́yɨŋɨ nɛkʉ anɛ Mandɛm akʉ Yesu ámpɛtnsɛm ndǔ nɛpɛ́m ɛnyu ɛnɛ yi ápú pɛrɛ gú, Mandɛm arɛm nyaka bɛ́: ‘Chɔŋ nchyɛ́ bhe áfɔ́k mbɔ ɛnyu mfyɛ́ nyaka bariɛp nɛ Debhít nɛ njɛt yi nɛ ɛ́bhɔŋ bɛbhak ɛnyu ɛyɔ.’ ");
INSERT INTO kenNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Nɛ ndu bɛ́rɔŋ ambɨ, ɛ́chí nɛbhʉɛt achák amɛm Ɛkáti Bakway bɛ Debhít arɛm ntá Mandɛm bɛ, ‘Ɔpú rɔ chɔŋ Mmu anɛ áchyɛ́ nɛpɛ́m ɛni ntá yɛ ámpɔ́ amɛm nnɛm.’ ");
INSERT INTO kenNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Mandɛm abhɨ́kɨ́ rɛm nyaka mɛnyɨŋ ɛbhɛn chi ɛ̌ti Mfɔ Debhít mbɔnyunɛ Debhít ánáŋá nɔ́kɔ́ bɛtɨk Mandɛm áchyɛ́ yi ánkʉ́ fá amɨk ndu ayi mpok, agú akoŋo bachǐmbɨ bhi. Apɔɔ ndǔ nnɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Mandɛm arɛm nyaka chi ɛ̌ti mmu achák, anɛ yi ákʉ́ ápɛ́rɛ́nsɛm ndǔ nɛpɛ́m anɛ mmʉɛt ayi abhɨkɨ pɔɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Bɔ̌ma dɨŋɨ́ yɛ ká bɛ́ chí ɛ̌ti Yesu kɛ Mandɛm áfòŋori bɛbʉ́ mbɔ ɛnyu sɛ́ghàti bhe. ");
INSERT INTO kenNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Dɨŋɨ́ ká bɛ yɛ̌ agha anɛ ánókó Yesu, Mandɛm ǎsɔ̀t bɛ yi achi chak bɛsí bhi. Ɛbhé Moses ɛ́pú kwáy bɛ́kʉ nɔ ntá mmu. ");
INSERT INTO kenNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Sɔt yɛka mpok bɛ́ ɛnyɨŋ ɛnɛ́ barɛmɛ́ kɛpɨ̌ntɨ básɨ́ŋɨ́ ɛ́kɛ́ fakari nɛ bhe. Nɔ́ chi ɛnyɨŋ ɛnɛ́ básɨ́ŋɨ́ bɛ, ");
INSERT INTO kenNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Bě bho bǎbyàk ɛnyɨŋ ɛnɛ Mandɛm árɛ̀m, yɨŋɨ́ ka mbaŋ sayri, mǎmbák maknkay, nɛ mǎngu, nɛ ntí bɛ́ mɛ̌kʉ̀ ɛnyɨŋ ndu manywɔp ayɛka, ɛnɛ yɛ mángátí bhe, bǎpú noko wawak!’” ");
INSERT INTO kenNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ɛnɛ Pɔ̌l nɛ Banábas báfù ndǔ ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí bo Israɛl, bo báre nɨk bɔ́ mmʉɛt bɛ́ mámpɛ́tnsɛm mandɔk ambɨ bɛghati bhɔ mɛnyɨŋ ɛbhɛn ndu nywɔbhɛ́ nɛywɛ̌mʉɛt ɛnɛ́n nɛ́twɔ̀ ambɨ. ");
INSERT INTO kenNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Bo báfú nɔ́kɔ́ ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí, bɛyǎ bo Israɛl nɛ bo abhɛn bápu bo Israɛl kɛ báchày Mandɛm, báré koŋo Pɔ̌l nɛ Banábas. BɔPɔ̌l básɛ́mti bhɔ́ bɛ́ mánté kpirí, mándɔkɔ nɔkɔ chi ambɨ bɛghɔkɔ mmʉɛt ndu bɛrɨ̌ndu Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ɛ́gháká nɔkɔ nywɔbhɛ́ nɛywěmʉɛt ɛnɛn nɛ́kòŋo, ɛtɔk ɛnkɛm ɛ́twɔ́ bɛ́ghok Ɛyɔŋ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Kɛ bo Israɛl bághɔ́ nɔ́kɔ́ ndǔ ngɛ́mtay bo báchɛ̀m arɛ́ ɛnyu ɛyɔ, bábhɔ́ŋ bɛyǎ mpabhamɨ́k nɛ bɔPɔ̌l. Bábhó bɛsɔkɔti Pɔ̌l mánkɛmɛ nɔkɔ ɛpʉ́ítí ndu yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ yi árɛ̀m. ");
INSERT INTO kenNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ɛyɔ ɛ́kʉ́ Pɔ̌l nɛ Banábas bábhó bɛ́rɛm kɛbhɔŋ bɛcháy bɛ, “Bě bo Israɛl kɛ sɛ́bhɔ́ŋɔ́ bɛ́yámbɨ bɛ́gháti Mbok Ndɨ́ndɨ́ anɛ áfú ntá Mandɛm. Kɛ tɛ̌ndu bǎbyàk yɔ́, nɛ bǎyɨ́ŋɨ mmʉɛt ayɛka bɛ́ bǎbhɨ́kɨ́ kwáy bo abhɛn bábhɔ́ŋ nɛpɛ́m ɛnɛn nɛbhɨkɨ bhɔŋ ngwɛ́nti, sɛ́rɔ̀ yɛ be nɛ sɛ́rɔ̀ŋ ntá bo abhɛn bápú bo Israɛl nɛ yɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ɛnyu ɛyɔ kɛ Mandɛm Acha ághátí bhɛsɛ sɛnkʉ, mpok árɛ́mɛ́ bɛ, ‘Nkʉ wɔ ɔ́mbák ɛrɔ́ŋɔ́ ntá bo abhɛn bápú bo Israɛl, bɛ́ ndǔ bɛtaŋ Mandɛm, ɔ́nkwak mmɨk nkɛm ambɔŋ nɛpɛ́m.’” ");
INSERT INTO kenNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Bo abhɛn bápú bo Israɛl bághókó nɔ́kɔ́ nɔ, bábhɔŋ bɛyǎ maŋák, bábhó bɛ́chyɛ bakak ntá Mandɛm ɛ̌ti ɛyɔŋ ɛyi. Nɛ abhɛn Mandɛm áyábhɛ́ bɛ́ mámbɔ́ŋ nɛpɛ́m ɛnɛ́n nɛbhɨkɨ bhɔ́ŋ ngwɛnti, mánoko Mbok Ndɨ́ndɨ́ ɛ̌ti Yesu. ");
INSERT INTO kenNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ɛyɔŋ Mandɛm ɛ́táka atú ɛtɔk wu ankɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Kɛ bo Israɛl abhɛn báchí arɛ́ mányɨ́kɨ́si batɨ bǒbatí ɛtɔk ɛyɔ nɛ manɛ́m baghɔrɛ́ abhɛn mánókó Mandɛm. Bákʉ bo báchyɛ Pɔ̌l nɛ Banábas nɛnyok kpát bábók bhɔ báfá atú ɛtɔk ɛyap. ");
INSERT INTO kenNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pɔ̌l nɛ Banábas bákwɛ́t mfok ɛtɔk ɛyɔ anɛ áchí bhɔ́ bɛkak bɛtɔŋ bɛ́ chɔŋ Mandɛm antáŋ bǒbhɔ ndu ɛnyɨŋ ɛnɛ́ bɔ́ bákʉ́. Báfa báré rɔ́ŋ Ikɔ́niɔm. ");
INSERT INTO kenNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Bakoŋo Yesu abhɛn ɛtɔk Antiɔk, bájwi nɛ maŋák nɛ Ɛfóŋó Bɛdyɛrɛ abhak nɛ bhɔ́ sayri. ");
INSERT INTO kenNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pɔ̌l nɛ Banábas báchwɔ́bhɛ́ nɔ́kɔ́ Ikɔ́niɔm, bárɔk báchwe ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí bo Israɛl baghati Mbok Ndɨ́ndɨ́ Yesu arɛ. Ɛfóŋó Bɛdyɛrɛ abhak nɛ bhɔ. Ɛ́kʉ́ bɛyǎ bo mánóko. Bo abhɛn mánóko bábhák bo Israɛl nɛ bo bɛtɔk bɛchak. ");
INSERT INTO kenNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Kɛ bo Israɛl abhɛn bábhɨkɨ noko mbok Yesu bábho bɛrɛm bɛpɔ̌ mɛnyɨŋ ɛbhɛn mɛ́nyɨkɨsi batɨ bo abhɛn bápú bo Israɛl. Bárɔ́bhɛ bé chí ntɨ nɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pɔ̌l nɛ Banábas babhak Ikɔ́niɔm ndu ɛrɔri mpok mángati nɔkɔ bo mbok Acha kpoŋoroŋ kɛbhɔŋ bɛcháy. Mandɛm are tɔ́ŋ bo Ikɔ́niɔm kpoŋoroŋ bɛ́ mbok anɛ bɔ́ Pɔ̌l bághàti bho ɛ̌ti bɛrɨ̌ndu ɛbhi achí tɛtɛp, akʉ nɔ ndu áchyɛ́ bhɔ́ bɛtaŋ bɛ́kʉ mɛnyɨŋɨ́ maknkay. ");
INSERT INTO kenNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ɛtɔk ɛ́kɔ́rɛ bɛbhe bɛpay, mbɔk bábhak ansɛm bo Israɛl, bo báchák bábhak nɛ bǒnto Yesu. ");
INSERT INTO kenNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Mbɔk bo Israɛl nɛ abhɛn bápú bo Israɛl báchɛ́m nɛ bǒ batí bhap báká ɛyɔŋ ɛ́mɔt bɛ mánchyɛ bǒnto Yesu ɛsɔŋɔri nɛ bɛ mantɛmti bhɔ nɛ batay mángwáy. ");
INSERT INTO kenNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Bǒnto bárɨŋɨ nɔ́kɔ́ nkaysi yap, bábʉɛ́ bárɔk atú Likáonia, ndu bɛtɔk Lístra nɛ Dɛ́be nɛ mbaŋ ɛnɛ ɛchi kɛkwɔt arɛ, ");
INSERT INTO kenNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","mángati nɔkɔ Mbok Ndɨ́ndɨ́ ɛ̌ti Yesu. ");
INSERT INTO kenNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Mmufú achí nyaka ɛtɔk Lístra. Abhak mbɛ́ntí tɛ nɛbhe ɛni. ");
INSERT INTO kenNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ɛwak ɛ́mɔ́t, abhak chɔ́kɔ́ anta nɔkɔ batú ndu ɛnyɨŋ ɛnɛ Pɔ̌l árɛ̀m. Pɔ̌l ayɨŋɨ yi dǐǐ, ághɔ́ bɛ́ yí wu anókó bɛ́ Mandɛm ǎkwáy bɛ́bú yi. ");
INSERT INTO kenNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Pɔ̌l arɛm nɛ ɛyɔŋ ɛtaŋataŋ bɛ, “Faté tě chak!” Afate kpɛrɛp abho bɛ́kɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ngɛ́mtay bo abhɛn bachi arɛ bághɔ́ nɔ́kɔ́ ɛnyɨŋ Pɔ̌l ákʉ́, bábhó bɛ́bɨk ndu ɛyɔŋɔ́tɔk ɛyap, ɛyɔŋ bǒ Likáonia mandɛmɛ nɔkɔ bɛ, “Bɔmandɛm básɔt mmʉɛt bakwǎŋwaŋ bátwɔ fá amɨk ntá yɛsɛ!” ");
INSERT INTO kenNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bárɛ́m bɛ́ Banábas chí mándɛm anɛ áká nnyɛ́n bɛ́ Sús, nɛ bɛ Pɔ̌l chi mándɛm anɛ áká nnyɛ́n bɛ Hɛmes mbɔnyunɛ yí kɛ achi nyaka ndɛmɛ kɛpɨ. ");
INSERT INTO kenNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ɛkɛrákap mandɛm nsé Sús ɛ́chí nyaka nɛfí bɛfʉɛt nkok ɛtɔk. Nchiakap mandɛm nsé Seus asɔt manɛ́m mpɔŋ nɛ bɔchuchu abhɛn mánɨ́ arɔk antí ɛtɔk mbɔnyunɛ yí nɛ ngɛ́mtáy bhó abhɛn báchi arɛ báyàŋ nyaka bɛchyɛ akap ntá Banábas nɛ Pɔ̌l. ");
INSERT INTO kenNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kɛ Banábas nɛ Pɔ̌l, bǒnto Yesu, bághókó nɔ́kɔ́ ɛnyɨŋ ɛnɛ́ bǒbhɔ báyàŋ bɛkʉ, batɨ achɔŋti bhɔ amɛm kpát bádákáti ndɛn ɛ́yap amʉɛt. Bájɛt báchwe amɛm ɛká bo ɛyɔ nɛ bǎrí mándɛmɛ nɔkɔ bɛ, ");
INSERT INTO kenNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Bɔta, ndaká yi bákʉ̀ ɛnyunɛ? Sɛ́chí nkwɔ chi bakwǎŋwaŋ mbɔ bhe! Sɛ́twɔ fá bɛ́gháti bhe Mbok Ndɨ́ndɨ́ ɛ̌ti Yesu bɛ́ mǎntɨk nsɛm ndǔ mɛnyɨŋ ɛbhɛn bɛbhɨkɨ bhɔŋ nsay mǎntwɔ́ ntá Mandɛm mmu áchyɛ̀ nɛpɛ́m. Yí kɛ ághókó mfay nɛ mmɨk nɛ manyɛ́n nɛ mɛnyɨŋ mɛnkɛm ɛbhɛn bɛchi arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ndu mpok anɛ áfʉɛ́rɛ́ ansɛm, arɔ́ nyaka bo bɛtɔkɔ́ mmɨk mankɛm mánkʉ mbɔ ɛnyǔ bákɔ́ŋɔ́. ");
INSERT INTO kenNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Yɛ̌ nɔ, abhɨkɨ rɔ nyaka bɛtɔŋ kpoŋoroŋ bɛ́ yí áchí. Ǎkʉ bɛrɨ́tí mɛnyɨŋ. Yí kɛ ákʉ̀ manyiɛp ámfú amfay nɛ ǎchyɛ̀ mbwɔt ndǔ ayi mpok, anchyɛ bhe nɛnyíɛ́, anchyɛ maŋák.” ");
INSERT INTO kenNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pɔ̌l nɛ mmʉɛrɛ ywi bárɛm mɛnyɨŋ ɛbhɛn bɛ́kʉ̀ bo bhɔ mángɔ́ bɛ́ bɔ́ nkwɔ́ báchí chí bakwǎŋwaŋ. Yɛ̌ nɔ, bábhɨ́kɨ́ kwáy bɛchyɛt bɔ mbi bɛ́ bɛ́kɛ́ chyɛ bhɔ́ akap anɛ́ babhɔŋɔ bɛchyɛ chi ntá Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Kɛ ɛ́bhɨ́kɨ́ tat, mbɔk bo Israɛl báfú Antiɔk anɛ atú Pisídia, báchák báfú Ikɔ́niɔm. Bákʉ́ bɛyǎ bo mánká nɛ bhɔ. Ɛkʉ bátɛ́mti Pɔ̌l nɛ batay, básu bárɔk bárɔ antí ɛtɔk nɛ nkaysi bɛ́ anáŋ agu. ");
INSERT INTO kenNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Kɛ mpok anɛ bakoŋo Yesu bárɔ́ŋɔ́ arɛ bákap yi, afate apɛtnsɛm ɛtɔk Lístra nɛ bhɔ́. Nɛ́yí nɔ́kɔ́, Banábas nɛ yi bárɔ bárɔk Dɛ́be. ");
INSERT INTO kenNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pɔ̌l nɛ Banábas báre ghati bo Mbok Ndɨ́ndɨ́ ɛ̌ti Yesu amɛm ɛtɔk Dɛ́be. Bɛyǎ bo mánoko nɛ bábho bɛ́kóŋo Yesu. Bɔ Pɔ̌l bápɛt yɛ nsɛm Lístra nɛ Ikɔ́niɔm nɛ Antiɔk anɛ Pisídia. ");
INSERT INTO kenNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Báré fyɛ́ bakoŋo Yesu ntɨ mbaŋ ɛyɔ ɛnkɛm mánchyɛ nɔkɔ bhɔ́ maníɛ́ bɛ́ mándɔ́k ambɨ bɛ́te kpirí ndʉ̌ nɛsɨkɨ́ntɨ ɛnap nɛ Yesu. BɔPɔ̌l bágháti bhɔ́ bɛ bábhɔŋ bɛghɔ bɛyǎ ɛsɔŋɔri kɛ mǎnchwe ndǔ nɛpɛ́m ɛnɛ́n Mandɛm ǎbhák Mfɔ wap. ");
INSERT INTO kenNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pɔ̌l nɛ Banábas báyap bǒ batí ndu yɛ̌ntɨkɨ ɛkɛrɛ́ Mandɛm. Báfyɛ́ bhɔ́ amɔ Yesu Acha mmu bɔ́ básɨ́kɨ́ ntɨ nɛ yi ndu nɛnɨkɨ́mʉɛt nɛ nɛtarɛ́nsay. ");
INSERT INTO kenNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Báfʉɛt yɛ atú Pisídia, bárɔk atú Pamfília. ");
INSERT INTO kenNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Arɛ́, bágháti mbok Yesu amɛm ɛtɔk Pɛga. Báfá Pɛga basɛp bárɔk Atália. ");
INSERT INTO kenNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Básɔ́t achwǐnyɛ́n bɛfu Atália bápɛtnsɛm Antiɔk. Amɛm ɛtɔk Antiɔk kɛ̌ bǒnto Yesu mánɨ́kɨ́mʉɛt ɛ̌ti Banábas nɛ Pɔ̌l bɛ bɛrɨ̌ndu Mandɛm mɛ́mbák nɛ bhɔ ndǔ bɛtɨk ɛbhɛn bákʉ́ kɛ bápɛtnsɛm Antiɔk. ");
INSERT INTO kenNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Báchwɔ́bhɛ́ nɔ́kɔ́ Antiɔk, babhɨŋɨ Bǒ nkwɔ́ Yesu báchɛm nɛbhʉɛt amɔt. Bágháti bhɔ́ mɛnyɨŋ mɛnkɛm ɛbhɛn bɔ bákʉ́ ndu bɛtaŋ Mandɛm, nɛ ɛnyu Mandɛm ánɛ́nɛ́ mbi bɛ́ bo abhɛn bápú bo Israɛl mánsɨ́kɨ́ ntɨ nɛ Yesu. ");
INSERT INTO kenNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Babhak arɛ́ nɛ bakoŋo Yesu ndǔ mpǎy bataŋ. ");
INSERT INTO kenNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Bo báfú Judɛ́ya bátwɔ́ Antiɔk bábhó bɛtɔŋ bǒnkwɔ Yesu mándɛmɛ nɔkɔ bɛ, “Mandɛm apú kway bɛ́pɛ́mɛ mmu mbák babhɨkɨ syɛp yí bɛkoŋo ɛbhé Moses.” ");
INSERT INTO kenNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pɔ̌l nɛ Banábas bákɛ́m ɛtaŋtí ɛpʉ́ítí nɛ bhɔ́ ɛ̌ti ndaka wu kɛghɔ́ ntí. Ɛ́kʉ baka ɛyɔŋ ɛ́mɔt bɛ Pɔ̌l nɛ Banábas nɛ mbɔk bakoŋo Yesu abhɛn Antiɔk mándɔ́k Yerúsalɛm, mángɔ́ bǒnto nɛ bǒbati nkwɔ́ Yesu ɛ̌ti ndaka wu. ");
INSERT INTO kenNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Bafa bare rɔŋ mbɔ ɛnyǔ nkwɔ Yesu bátó bhɔ́. Ɛnɛ́ bárɔ̀ŋ atú Foníshia nɛ atú Samária, báre téé ndǔ bɛtɔk ɛbhɛn bɛchi ambi mángati nɔkɔ bǒnkwɔ́ bɛ́ bo abhɛn bápú bo Israɛl mánóko mbok Yesu nkwɔ. Ɛyɔ ɛ́chyɛ bakoŋo Yesu bɛyǎ maŋák. ");
INSERT INTO kenNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Báchwɔ́bhɛ́ nɔ́kɔ́ Yerúsalɛm, bǒnkwɔ, nɛ bǒnto Yesu nɛ bǒbatí ɛtɔk básɔt Pɔ̌l nɛ Banábas nɛ bo bachak nɛ maŋák. Pɔ̌l nɛ Banábas bágháti yɛ bhɔ́ mɛnyɨŋ mɛnkɛm ɛbhɛ́n Mandɛm ákwáká bɔ mankʉ. ");
INSERT INTO kenNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Kɛ mbɔk bakoŋo Yesu abhɛn bachi bǒnkwɔ Fárisi bághókó nɔ́kɔ́ nɔ, báfáte babho bɛ́rɛm bɛ, “Bábhɔŋ bɛsyɛp bɔ, mángati bhɔ bɛ mámbʉrɛ bɛbhé Moses.” ");
INSERT INTO kenNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Bǒnto Yesu nɛ bǒbatí bapɛt bachɔkɔ bɛyɨŋɨ ndaka wu. ");
INSERT INTO kenNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Bátát nɔkɔ arɛ́ ndu bárɛ̀m ndaka wu, Píta afate aghati bhɔ bɛ, “Bɔ̌ma, bǎrɨŋɨ bɛ Mandɛm anáŋ ayap mɛ nɛ́ntɨ ɛnɛka tɛ mpok anɛ áfʉɛ́rɛ́ ansɛm bɛ́ ngati Mbok Ndɨ́ndɨ́ ɛ̌ti Yesu ntá bo abhɛn bápú bo Israɛl bɛ́ bɔ́ nkwɔ́ mangok, mánoko. ");
INSERT INTO kenNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Nɛ Mandɛm mmu arɨŋɨ batɨ bo mankɛm, atɔŋ kpóŋóróŋ bɛ́ bo abhɛn bápú bo Israɛl bákway mɛ́nóko nkwɔ. Akʉ nɔ́ ndu áchyɛ́ bhɔ́ Ɛfóŋó Bɛdyɛrɛ nkúbhɛ́ mbɔ ɛnyu yi achyɛ nyaka bhɛsɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Afoŋori bɛbʉ́ bhap ndu básɨ́kɨ́ ntɨ nɛ Yesu nɛ akɛ tɔ́ŋ bɛ́ bɛsɛ bo Israɛl sɛ́chí kɛkúrí nɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ntí anɛ bǎyàŋ yɛ mɛmɔ Mandɛm, bɛ́ghɔ mbák chɔŋ yi ambé ntɨ achí bɛ́ yí? Ndaká yí bǎchyɛ̀ batu anɛ yɛ̌ chi bachǐmbɨ bhɛsɛ babhɨkɨ kway nyaka bɛpɔkɔ ntá bo abhɛn bachi bakoŋo Yesu? Yɛ̌ chi bɛsɛ nkwɔ sɛ́bhɨkɨ kway bɛpɔkɔ batǔ yɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ɛ́bhɨ́kɨ́ rɨ bɛkʉ nɔ! Sɛ́noko bɛ́ Mandɛm ǎpɛ̀mɛ bhɛsɛ́ chí ɛ̌ti bɛrɨ̌ndu ɛbhɛn Yesu Acha átɔ́ŋɔ́ bhɛsɛ́ nɛ nkúbhɛ́ ɛnyu yɔ kɛ ǎpɛ̀mɛ bɔ nkwɔ.” ");
INSERT INTO kenNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Píta árɛ́m nɔ́kɔ́ nɔ, ɛchɛmɛ ɛnkɛm ɛ́kwɛ́n kpák ndu bɛ́ghok ndu Banábas nɛ Pɔ̌l bághàti bhɔ ɛ̌ti mɛnyɨŋɨ́ maknkay ɛbhɛn Mandɛm áchyɛ́ bhɔ́ bɛtaŋ, bákʉ́ nɛntɨ bo abhɛn bápú bo Israɛl. ");
INSERT INTO kenNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Mánáŋá nɔ́kɔ́ bɛ́rɛm ɛnyɨŋ ɛnɛ bárɛ̀m, Jems afate abho bɛ́rɛm bɛ, “Bɔ̌ma, ghók ká ɛnyɨŋ ɛnɛ mɛ̌rɛ̀m! ");
INSERT INTO kenNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Símiɔn anaŋ ághátí bhɛsɛ ɛnyǔ Mandɛm ábhó bɛtɔŋ bɛ́ akɔŋ bo abhɛn bápú bo Israɛl nkwɔ, nɛ ayap mbɔk ɛyap bɛ mámbák bǒbhi. ");
INSERT INTO kenNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nɛ ɛnyɨŋ ɛnɛ yi árɛ́mɛ́ ɛ́kɔ ndɔŋ amɔt nɛ mɛnyɨŋ ɛbhɛ́n barɛmɛ́ kɛpɨ̌ntɨ bárɛ́mɛ́ mbɔ ɛnyu básɨ́ŋɨ́ bɛ ");
INSERT INTO kenNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Ansɛm mpok, chɔŋ mpɛtnsɛm mpɛt ntee ɛkɛt Debhít ɛnɛ́ ɛ́kwɛ́nɛ́. Chɔŋ njoŋ ɛkɛt ɛnɛ́ ɛ́báy mmʉɛt amɨk nkʉ yɔ ɛmpɛt ɛnte. ");
INSERT INTO kenNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Chɔŋ nkʉ nɔ bɛ bǒbhɔ mankɛm mámbo bɛyaŋ mbi bɛ́twɔ ntá ya, yɛ̌ chi bo abhɛn bápú bo Israɛl, mankɛm abhɛn mbɨ́ŋɨ́ bɛ mámbák bǒbha nkwɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Nɔ kɛ Mandɛm Acha mmu akʉ bo mándɨŋɨ mɛnyɨŋ ɛbhɛn arɛmɛ tɛsáy.’” ");
INSERT INTO kenNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jems arɔk ambɨ bɛ́rɛm bɛ, “Ndu nkaysi aya, sɛ́kɛ́pɛrɛ sɔŋɔri bǒ abhɛn bápú bo Israɛl abhɛn bátwɔ̀ ntá Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Sɛ́nsɨ́ŋ chí ɛkáti sɛ́ngáti bhɔ bɛ bákɛ́ nyiɛ nɛnyíɛ́ nɛ nya anɛ áfú ndǔ akap anɛ báchyɛ́ ntá mandɛm nsé, nɛ bɛ mándɔ ɛpúsí, nɛ bɛ bákɛ́ nyiɛ́ nya ɛnɛ́ manoŋ amap ábhɨ́kɨ́ rɔŋ amɨk, nɛ bɛ bákɛ́ nyiɛ manoŋ. ");
INSERT INTO kenNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Sɛ́nsɨ́ŋ bɔ́ nɔ mbɔnyunɛ bábho bɛ́pay bɛbhé Moses ɛbhɛ́n amɛm bɛkɛrɛ́ nɛnɨkɨ́mʉɛt bo Israɛl tɛntɛp, ndu yɛ̌ntɨkɨ nywɔbhɛ́ nɛywěmʉɛt, nɛ bo yɛ̌ntɨkɨ ɛtɔk bárɨŋɨ bhɔ.” ");
INSERT INTO kenNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Bǒnto Yesu nɛ bǒbatí nɛ bǒnkwɔ́ Yesu mankɛm bághɔ́ bɛ́ chí ɛrɨ́tí nkaysi. Báká ɛyɔŋ ɛ́mɔt bɛ mánjáp bo mánto Antiɔk nɛ Pɔ̌l nɛ Banábas. Báyáp yɛ Sáilas nɛ Júdas anɛ nnyɛ́n ɛni nɛ́chák nɛ́chí bɛ Básabas. Bɔ batí apay bábhak bǒbatí nkwɔ Yesu. ");
INSERT INTO kenNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ɛkáti ɛnɛ́ báchyɛ́ bhɔ́ mándɔ́k nɛ yɔ ɛ́ré rɛm bɛ, “Bɛsɛ́ bǒnto Yesu nɛ bǒbatí nɛ bǒnkwɔ́ Yesu mankɛm sɛ́kàka be bɔ̌máyɛsɛ abhɛn bápú bo Israɛl awu Antiɔk, nɛ abhɛn Síria nɛ abhɛn Silísha. ");
INSERT INTO kenNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Sɛ́ghok bɛ mbɔk bo báfu fá ntá yɛsɛ́ batwɔ awu nɛ nɛtɔ́ŋ ɛnap bɛ́chyɛ bhe ɛsɔŋɔri nɛ bafyɛ bhe ɛbyɔk antɨ ɛnɛ́ sɛ́bhɨ́kɨ́ tó bhɔ́. ");
INSERT INTO kenNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ɛ̌ti yɔ kɛ sɛ́chɔ́kɔ́, sɛkǎ ɛyɔŋ ɛ́mɔt bɛ́ sɛ́njap bo sɛ́nto ntá yɛka nɛ abhɛn ɛkɔŋ abhɛsɛ, Pɔ̌l nɛ Banábas, ");
INSERT INTO kenNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","bo abhɛn báká nɛwú ɛ̌ti Acha ywɛsɛ Yesu Kristo. ");
INSERT INTO kenNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Sɛ́tò yɛ Júdas nɛ Sáilas ntá yɛka. Mǎnaŋ mǎngáká awu chɔŋ mángati bhe bɛsí nɛ bɛsi nkúbhɛ́ mɛnyɨŋ ɛbhɛn sɛ́nsɨ́ŋɨ́ amɛm ɛkáti. ");
INSERT INTO kenNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ɛ́chí bɛ́ sɛ́bhɔŋ nkaysi amɔt nɛ Ɛfóŋó Bɛdyɛrɛ bɛ sɛ́kɛ́ chyɛ bhe batu áchák anɛ acha bɛbhé ɛbhɛn bǎbhɔ́ŋɔ́ bɛbhʉrɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Nɔ chi bɛ bǎkɛ́ nyiɛ́ nɛnyíɛ́ ɛnɛn nɛfǔ ndʉ̌ akap anɛ́ báchíɛ ntá mandɛm nsé, nɛ bǎkɛ́ nyiɛ́ manoŋ, nɛ yɛ̌ chi nnya anɛ manoŋ ami ábhɨ́kɨ́ rɔŋ amɨk. Nɛ bɛ mǎndɔ́ ɛpúsí. Mbák mǎndɔ́ mɛnyɨŋ ɛbhɛn, chɔŋ ɛ́mbak ɛrɨ́rɨ́ nɛ bhe. Mǎnchɔkɔ sayri.” ");
INSERT INTO kenNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Bǒbhɔ bati anwi báfa Yerúsalɛm barɔk Antiɔk. BɔPɔ̌l bábhɨ́ŋɨ nkwɔ́ Yesu báchɛ́m nɛbhʉɛt amɔt bachyɛ bhɔ ɛkáti ɛnɛ bapɔkɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Bápáy nɔkɔ yɔ, maníɛ́ amɛn áchi amɛm ɛ́fyɛ́ bo Antiɔk ntɨ, bábhɔŋ maŋák. ");
INSERT INTO kenNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Júda nɛ Sáilas babhak barɛmɛ́ kɛpɨ̌ntɨ. Bágháti bǒnkwɔ Yesu bɛyǎ mɛnyɨŋ ndu bɛ́fyɛ́ bhɔ́ ntɨ nɛ bɛ́kwák bɔ mántaŋ ndu nɛsɨkɨ́ntɨ ɛnap nɛ Yesu. ");
INSERT INTO kenNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Báchɔ́kɔ́ nɔ́kɔ́ arɛ́ nɛ bhɔ́ ndu mɔ́mbɨŋɨ́ mpok, bǒnkwɔ́ Yesu bátɨ́k bhɔ́, nɛ maŋák bɛ mámpɛ́tnsɛm Yerúsalɛm ntá bo abhɛn bátó bhɔ́. ");
INSERT INTO kenNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Kɛ Sáilas akʉ ntɨ bɛ́rɔp Antiɔk. ");
INSERT INTO kenNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pɔ̌l nɛ Banábas bárɔp Antiɔk. Arɛ́, báre tɔ́ŋ, mángati nɔkɔ bo ɛyɔŋ Acha nɛ bɛyǎ bo báchák nkwɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ɛwak ɛ́mɔt, Pɔ̌l arɛm ntá Banábas bɛ, “Sɛ́mpɛtnsɛm ndu yɛ̌ntɨkɨ ɛtɔk ɛnɛ sɛ́ghátí ɛyɔŋ Acha arɛ sɛ́ngɔ́ ndǔ bǒnkwɔ́ báchí.” ");
INSERT INTO kenNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banábas are yáŋ bɛ́ mánsɔ́t Jɔ̌n Mák yí ándɔ́k nɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Kɛ Pɔ̌l kɛka bɛ́ ɛ́chi sayri bɛ́sɔt yi mbɔnyunɛ arɔ́ nyaka bhɔ ɛtɔk Pamfília ɛnɛ́ bábhɨ́kɨ́rɛ naŋa bɛtɨk ɛbhap. ");
INSERT INTO kenNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ɛ̌ti yɔ, Pɔ̌l nɛ Banábas bákɛ́m bɛyǎ ɛpʉ́ítí kpát akɔrɛ akwɛn nɛntɨ nap. Banábas asɔt Jɔ̌n Mák báchwe achwǐnyɛ́n, bárɔk Sáyprɔs. ");
INSERT INTO kenNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Kɛ Pɔ̌l ayap chi Sáilas. Bǒnkwɔ́ Yesu mánɨkmʉɛt bɛ bɛrɨ̌ndu Acha mɛ́mbak nɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pɔ̌l asɔt Sáilas bárɔk Síria nɛ Silísha ɛnɛ́ yi afyɛ́ ntɨ nta bakwɔ́ Yesu abhɛn báchí arɛ ntɨ. ");
INSERT INTO kenNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pɔ̌l nɛ Sáilas barɔk baghaka Dɛ́be nɛ bafu nɔkɔ arɛ barɔk Lístra. Nkoŋo Yesu amɔt abhak arɛ́ anɛ áká nnyɛ́n bɛ́ Tímɔti. Máyi abhak mmu Israɛl anɛ ánókó Yesu, kɛ aywi chí abhak mmǔ Grik. ");
INSERT INTO kenNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Bǒnkwɔ abhɛn Lístra nɛ Ikɔ́niɔm bárɛ̀m nyaka ɛrɨrɨ ɛ̌ti Tímɔti. ");
INSERT INTO kenNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Ɛ́kʉ́ Pɔ̌l are yaŋ bɛsɔt Tímɔti bɛ andɔk nɛ bhɔ. Akʉ yɛ básyɛ́p yi mbɔnyunɛ bo Israɛl bachi nyaka ndǔ bɛtɔk ɛbhɔ nɛ bárɨ́ŋɨ bɛ chi Tímɔti achi chi mmǔ Grik. ");
INSERT INTO kenNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Arɔk yɛ nɛ Pɔ̌l nɛ Sáilas. Ndu bárɔ̀ŋ, mángati nɔkɔ bo ndu yɛ̌ntɨkɨ ɛtɔk ɛnɛ bachwɔbhɛ arɛ mɛnyɨŋ ɛbhɛn bǒnto nɛ bǒbati ɛtɔk abhɛn bachi Yerúsalɛm bárɛ́mɛ́, nɛ mánsɛmti nɔkɔ bhɔ́ bɛ mámbʉrɛ bɛbhé ɛbhɔ sayri. ");
INSERT INTO kenNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ɛyɔ ɛkʉ bakwɔ Yesu bárɔk ambɨ bɛ́sɨkɨ ntɨ nɛ Yesu, nɛ mpǎy yap anjá andɔkɔ nɔkɔ chi ambɨ. ");
INSERT INTO kenNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pɔ̌l nɛ Sáilas nɛ Tímɔti baghat bafʉɛt atú Frijia nɛ atú Galéshia mbɔnyunɛ Ɛfóŋó Bɛdyɛrɛ abhɨ́kɨ́ ka bɛ mángati bo Ɛyɔŋ Mandɛm atú Esia. ");
INSERT INTO kenNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Bágháká nɔ́kɔ́ kɛ́kwɔ́t nɛ ndiɛrɛ ɛbhɨ Mísia nɛ Bitínia, báré yaŋ bɛrɔŋ atú Bitíni, kɛ Ɛfóŋó Yesu kɛka bɔ́ mándɔ́k. ");
INSERT INTO kenNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ɛ́kʉ́ baghat bafʉɛt atú Misia, bárɔ́k Troas. ");
INSERT INTO kenNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Arɛ́, Pɔ̌l aghɔ́ kɛnɔ́ amɨ́k antifú nɛ bɛti ndǔ mmu Masidónia áté ánɨ̀kmʉɛt andɛm nɔkɔ ntá yi bɛ, “Twɔ́ fá Masidónia kwak bhɛsɛ!” ");
INSERT INTO kenNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pɔ̌l ághɔ́ nɔ́kɔ́ kɛnɔ́ ɛkɔ, sɛ́ká bɛ́ Mandɛm abhɨ́ŋɨ́ bhɛsɛ́ sɛ́ndɔ́k sɛ́ngátí Mbok Ndɨ́ndɨ́ ntá bǒ atú Masidónia. Tɛ́mté wu, Mmɛ Lukas nchɛm nɛ bhɔ sɛ́tóŋti mmʉɛt bɛ́rɔ́ŋ arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Sɛ́chwe áchwi anɛ árɔ̀ŋ Troas. Sɛ́rɔk téé sɛ́gháká Samótras, ɛtɔk ɛnɛ́ nnyɛ́n nɛ́kábhɛ́. Ɛ́gháká nɔ́kɔ́ ntɨnywɔp, sɛ́gháká Neápolis. ");
INSERT INTO kenNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Sɛ́fú nɔkɔ arɛ́, sɛkɔ amɨk sɛ́gháka Fílipi. Fílipi abhak ɛtɔk ɛgho atú Masidónia, nɛ abhak antɛn Mfɔ Rom. Sɛ́bhak Fílipi ndu mpǎy manywɔp. ");
INSERT INTO kenNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ɛ́gháká nɔ́kɔ́ nywɔbhɛ́ nɛywěmʉɛt bo Israɛl, sɛ́fú amɛm ɛtɔk sɛ́rɔk angɔkɔnyɛ́n ndǔ nɛbhʉɛt anɛ sɛ́káysí bɛ́ bo báchɛ̀m arɛ mɛ́nɨkmʉɛt. Sɛ́chɔ́kɔ amɨk sɛ́ndɛm nɔkɔ kɛpɨ nɛ baghɔrɛ́ abhɛn báchɛ́mtí arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ngɔrɛ́ amɔt anɛ aká nnyɛ́n bɛ Lídia afʉ́ ɛtɔk ɛgho ɛnɛ babhɨŋɨ bɛ Tiatíra. Abhak nkɔsíɛ́ ndǔ ndɛn ɛnɛ́ ɛ́chí mmʉɛt chu nɛ ɛ́yá nkáp. Ǎchyɛ nyaka Mandɛm kɛnókó. Mandɛm akʉ yi anɛnɛ ntɨ ɛni aghók sayri nɛ anoko ɛnyɨŋ ɛnɛ Pɔ̌l árɛ̀m. ");
INSERT INTO kenNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Bájwiti yi nɛ *ɛfo ɛyi. Anɨk bhɛsɛ mmʉɛt arɛm bɛ, “Mbák bǎsɔt mɛ mbɔ mmǔ anɛ ánókó Yesu tɛtɛp, twɔ́ ká chɔkɔ́ ɛkɛt ɛyá.” Anyiɛrɛ bhɛsɛ́ ɛnyu ɛyɔ kpát sɛrɔk. ");
INSERT INTO kenNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ɛwak ɛ́mɔ́t, ɛnɛ́ sɛ́rɔ̀ŋ ndǔ nɛbhʉɛt nɛnɨkɨ́mʉɛt, sɛ́tɛ́mɛri mɔ́ngɔsɔ́ŋ anɛ áchi nsɛm. Ɛfóŋó ɛbʉ́ɛbʉ ɛbhak nɛ yi ɛ́kʉ́ are rɛ́m mɛnyɨŋ ɛbhɛn bɛ́bhɔŋɔ bɛfakari. Ɛyɔ ɛ́chyɛ̀ nyaka bo abhɛn bábhɔ́ŋɔ́ yí bɛyǎ nkáp. ");
INSERT INTO kenNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ághɔ́ nɔ́kɔ́ bhɛsɛ nɛ Pɔ̌l, abho bɛkoŋo bhɛsɛ ambɨkɨ nɔkɔ bɛ, “Bǒbhɛn chí bǒ bɛtok Mandɛm mfay! Bághàti bhe ɛnyu Mandɛm ápɛmɛ bho.” ");
INSERT INTO kenNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Arɔk ambɨ bɛkʉ nɔ ndǔ bɛyǎ manywɔp kpát ntɨ nɛ́bé Pɔ̌l, ayibhiri mmʉɛt asáy ɛfóŋó ɛbʉ́bʉ ɛnɛ́ ɛ́chí ngosɔ́ŋ wu amʉɛt bɛ, “Ndǔ nnyɛ́n Yesu Kristo nchí ghati wɔ bɛ ɔ́mfú yí amʉɛt.” Tɛ́mté wu ɛfóŋó ɛbʉ́bʉ yɔ ɛ́rɔ́ ngɔsɔ́ŋ wu. ");
INSERT INTO kenNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ndu ɛ́fákárí nɔ, bo abhɛn bábhɔ́ŋɔ́ yi bághɔ́ bɛ mbǐ wap bɛbhɔŋ nkáp áchɔŋti. Bákɛ́m Pɔ̌l nɛ Sáilas, báya gbaka gbaka gbaka bárɔk nɛfísiɛ, bɛsí bǒbatí ɛtɔk, amɛm ɛkɛrɛ́ manyé. ");
INSERT INTO kenNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Bágháká nɔ́kɔ́ arɛ́ bárɛm bɛ, “Bǒbhɛn chí bo Israɛl nɛ báchyɛ̀ ɛsɔŋɔri amɛm ɛtɔk ɛyɛsɛ́. ");
INSERT INTO kenNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Bátɔ̀ŋ bhɛsɛ bɛpɨŋɨ́tɔk ɛbhɛ́n ɛbhé ɛyɛsɛ́ ɛ́bhɨ́kɨ́ ka bɛ sɛ́nkóŋó. Sɛ́chí bo Rom nɛ sɛ́pú kwáy bɛ́kóŋo bɛpɨŋɨ́tɔk ɛbhap.” ");
INSERT INTO kenNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Bɛyǎ bo abhɛn bachi arɛ bachɛm nɛ bǒ ngɔsɔ́ŋ wu bɛbhat bɔPɔ̌l barak amʉɛt. Bataŋá manyé báchyɛ́ ɛyɔŋ, báyók bɔ́ ndɛn amʉɛt nɛ bádɛ́n bɔ́ nɛ bɛkpa. ");
INSERT INTO kenNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Bádɛ́n nɔ́kɔ́ bhɔ́ sayri, bágʉɛ́p bhɔ́ ɛkɛrɛ́kɛnɔŋ, bágháti mmu anɛ ábhàbhɛri ɛkɛrɛ́kɛnɔŋ bɛ́ ánsɔ́t mpok bɛ́ bákɛ́ bʉɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Mbabhɛri wu ághókó nɔ́kɔ́ nɔ, asɔt bhɔ́, arɔk afyɛ́ ndu mɔ́kɛt anɛ achi tɛ amɛm. Báfyɛ́ bhɔ́ bɛko bɛkak. ");
INSERT INTO kenNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Kɛ ɛ́gháká nɔ́kɔ́ mbɔ nɛ́ntɨ́bhɛti, Pɔ̌l nɛ Sáilas babho mɛnɨkmʉɛt mánkway nɔkɔ bakwáy ndu bɛbɨti Mandɛm, batɨ̌ bǒkɛnɔŋ bachak mángoko nɔkɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Bápɛ́rɛ ghɔ́ nɛnyɨkɨsí mmɨk nɛ́kwɛ́n, kpát mmɨk anɛ báté ɛkɛrɛ́kɛnɔŋ arɛ́ anyɨkɨsi. Babhǐnywɔp ánɛ́nɛ ndǔ mmʉɛt yap tɛ́mté, ngɛm ɛnɛ́ báfé bǒkɛnɔŋ nɛ yɔ ɛ́káŋári ɛnkɛm, ɛ́kwɛ́nti amɨk. ");
INSERT INTO kenNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mbabhɛri ɛkɛrɛ́kɛnɔŋ afate. Ághɔ́ nɔ́kɔ́ babhǐnywɔp fúfú, akaysi bɛ́ bǒkɛnɔŋ mankɛm bábʉɛ. Agwɔp akparɛnja ywi ndu bɛway mmʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Kɛ Pɔ̌l abɨk arɛm bɛ, “Ɔ́kɛ́ way mmʉɛt. Bɛsɛ́ mankɛm sɛ́chí fá!” ");
INSERT INTO kenNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Mbabhɛri wu arɛm bɛ́ mántwɔ́ yí nɛ ɛrɔ́ŋɔ́. Bátwɔ́ nɔ́kɔ́ nɛ yɔ́, arɔk ɛkɛrɛ́kɛnɔŋ ntiɛ́t ntiɛt akwɛ́n ndǔ bɛkak Pɔ̌l nɛ Sáilas angwɛrɛ nɔkɔ nɛ bɛcháy. ");
INSERT INTO kenNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Asɔt yɛ bɔ́ nɛfí abhɛ́p bɔ́ bɛ́, “Bɔtá, chɔŋ nkʉ yi kɛ Mandɛm ampɛmɛ mɛ?” ");
INSERT INTO kenNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Bákɛ́mɛ yí bɛ, “Nokó Yesu Acha nɛ chɔŋ Mandɛm ampɛmɛ wɔ nɛ ɛfo ɛyɛ ɛnkɛm.” ");
INSERT INTO kenNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Bɔ Pɔ̌l bágháti yɛ yí nɛ ɛfo ɛyi Mbok Ndɨ́ndɨ́ ɛ̌ti Yesu Acha. ");
INSERT INTO kenNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Nkúbhɛ́ bɛti ɛbhɔ, asɔt bhɔ́ tɛ́mté aso bɛfʉɛt ɛbhap. Pɔ̌l nɛ Sáilas bájwiti yi nɛ ɛfo ɛyi ɛnkɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Asɔt yɛ bɔ́ ɛkɛt ɛyi achyɛ bhɔ́ nɛnyíɛ́. Yi nɛ ɛfo ɛyi ɛnkɛm bájwi nɛ maŋák bɛ mánóko Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Nɛ́yí nɔ́kɔ́ bǒ batí ɛtɔk bátó bǒ mbɨ̌ŋ nkú ntá mbabhɛri ɛkɛrɛ́kɛnɔŋ nɛ ɛyɔŋ bɛ, “Dɔ̌ bǒbhɔ mándɔk!” ");
INSERT INTO kenNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Mbabhɛri ághókó nɔ́kɔ́ nɔ arɔk aghati bɔPɔ̌l bɛ, “Bǒbatí báto ɛyɔŋ bɛ ndɔ be mǎndɔ́k. Bǎkwáy yɛ bɛrɔŋ. Mǎnkɔ sayri.” ");
INSERT INTO kenNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Kɛ Pɔ̌l arɛm ntá bo mbɨ̌ŋ nkú bɛ, “Báway bhɛsɛ nɛ mantɛm bɛsí bho, mámɛsɛ bhɛsɛ́ ɛkɛrɛ́kɛnɔŋ ɛnɛ́ bábhɨkɨ taŋ bhɛsɛ yɛ̌ndu sɛchi bǒ Rom. Nɛ́nɛ, báyàŋ sɛ́mfú sɛ́ndɔ́k bhɛ́sɛ́ bhɛ́sɛ́? Wáwák! Bɔ́ babhɔŋ bǒbatí bábhɔŋ bɛ́twɔ ndu mmʉɛt ɛyap mámfɛrɛ bhɛsɛ́.” ");
INSERT INTO kenNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Bǒ mbɨ̌ŋ nkú bápɛtnsɛm baghati bǒbatí ɛnyɨŋ ɛnɛ Pɔ̌l arɛmɛ nɛ bághókó nɔ́kɔ́ bɛ́ Pɔ̌l nɛ Sáilas báchí bǒ Rom, bɛcháy bɛkɛm bɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Babhɔ̌ŋ bǒbatí bárɔ́k yɛ mánɨkmʉɛt ntá Pɔ̌l nɛ Sáilas bɛ mǎmfóŋórí bhɔ́. Báfɛ́rɛ yɛ bɔPɔ̌l ɛkɛrɛ́kɛnɔŋ, mánɨ́kmʉɛt ntá yap bɛ mándɔ́ ɛtɔk ɛyap. ");
INSERT INTO kenNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pɔ̌l nɛ Sáilas báfú yɛ ɛkɛrɛ́kɛnɔŋ, bárɔk ɛkɛt Lídia. Bátɛ́mɛri bǒnkwɔ Yesu arɛ báchíɛ bhɔ maníɛ́ nɛ báfyɛ́ bɔ́ ntɨ. Báfá yɛ ɛtɔk ɛyɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","BɔPɔ̌l bárɔk báfʉɛ́t bɛtɔk Amfípolis nɛ Apolónia báchwɔp ɛtɔk Tɛsalónika, nɛbhʉɛt anɛ ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí bo Israɛl ɛchi. ");
INSERT INTO kenNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pɔ̌l arɔk achwe amɛm ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí ɛyɔ. Yɛ̌ntɨkɨ ɛbhak yí árɔ́ŋɔ́, ɛnyu ɛyɔ kɛ yí ákʉ̀ nyaka. Ndǔ bɔsɔnde barat are fyɛ́ mbok nɛ bhɔ ndu bɛkʉ bɔ mámbɔŋ nɛjwǐmɛm ndǔ mɛnyɨŋ ɛbhɛn bɛchi amɛm Ɛkáti Mandɛm, ");
INSERT INTO kenNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","nɛ anɛnɛ nɔkɔ nɛ antɔŋ nɔkɔ bɛ Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò, abhɔ̌ŋ nyaka bɛghɔ ɛsɔŋɔri nɛ angú, kɛ ampɛtnsɛm ndǔ nɛpɛ́m. Pɔ̌l are ghati bhɔ́ bɛ, “Yesu mmu nchí ghati bhe mɛnyɨŋ ɛ̌ti yi kɛ áchí Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò.” ");
INSERT INTO kenNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Mbɔk ɛyap mánóko, báchɛ́m mmʉɛt nɛ Pɔ̌l. Bɛyǎ bǒ Grik abhɛn mánɨ̀kmʉɛt ntá Mandɛm bo Israɛl nɛ bɛyǎ manɛ́m baghɔrɛ́ ɛtɔk ɛyɔ mánóko nkwɔ, báchɛ́m mmʉɛt nɛ bɔPɔ̌l mbɔ bakoŋo Yesu. ");
INSERT INTO kenNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Kɛ mbɔk bo Israɛl bábhɔŋ mpabhamɨ́k nɛ bɔPɔ̌l. Manyokoti bo abhɛn bághabhɛ ghap nɛ bákʉ bo mángʉ́ɛ́p ɛbyɔk ɛtɔk. Bárɔ́k bádákáti babhǐnywɔp báchwe amɛm ɛkɛt ɛnɛ mmu anɛ áká nnyɛ́n bɛ Jáson ndu bɛyaŋ Pɔ̌l nɛ Sáilas bɛ mánsɔt bhɔ mandɔk ndǔ nchɛmti bo abhɛn bachi nɛfí. ");
INSERT INTO kenNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Kɛ ndǔ bábhɨkɨ ghɔ bɔPɔ̌l, báyá Jáson nɛ bǒnkwɔ́ Yesu báchák gbaka gbaka gbaka bárɔ́k ntá bǒbatí ɛtɔk nɛ bhɔ, mambɨkɨ nɔkɔ bɛ, “Bǒ abhɛn bákɔ̀ mbǎnkɛm mánchyɛ nɔkɔ ɛsɔŋɔri bátwɔ fá nkwɔ́ ");
INSERT INTO kenNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","nɛ Jáson asɔt bɔ́ afyɛ́ anywɔ́p. Bɔ́ mankɛm bákʉ̀ mɛnyɨŋ ɛbhɛ́n bɛ́tɔ̀ŋ bɛ́ bápú bhʉɛrɛ bɛbhé mfɔ ngo anɛ Rom mándɛmɛ nɔkɔ bɛ Mfɔ achák áchí anɛ aka nnyɛ́n bɛ Yesu.” ");
INSERT INTO kenNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Bǒbatí nɛ bǒtɔk bághók nɔ́kɔ́ nɔ́, batí átáka bhɔ amɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Bákʉ Jáson nɛ bǒnkwɔ bhɔ bághɔ́kɔ nkáp ndu bɛtɔŋ bɛ bápú pɛrɛ chyɛ ɛsɔŋɔri. Bárɔ́ yɛ bɔ́ mandɔk. ");
INSERT INTO kenNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ɛ́gháká nɔ́kɔ́ nɛ bɛti, bǒnkwɔ́ bátɨ́ŋ bákʉ́ Pɔ̌l nɛ Sáilas bábʉ́ɛ barɔk ɛtɔk Bɛ́roa. Arɛ́, bárɔ́k báchwé ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí bo Israɛl. ");
INSERT INTO kenNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Bo Israɛl abhɛn Bɛ́roa bábhɔ́ŋ ntɨ bɛghok mbok Yesu anɛ́ Pɔ̌l nɛ Sáilas bághàti bhɔ ɛ́cha abhɛn Tɛsalónika, mbɔnyunɛ básìɛpti nyaka Ɛyɔŋ Mandɛm nɛ bɛyǎ ɛkwak. Báre chak Ɛkáti Mandɛm bɛghɔ mbák mɛnyɨŋ ɛbhɛn Pɔ̌l átɔ̀ŋ bɛchi tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ɛ́kʉ bɛyǎ-bhap mánóko Yesu Acha. *Manɛ́m baghɔrɛ́ Grik nɛ bɛyǎ babhakanɛm mánóko nkwɔ́. ");
INSERT INTO kenNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Kɛ bo Israɛl abhɛn Tɛsalónika bághókó nɔ́kɔ́ bɛ Pɔ̌l ǎghati Ɛyɔŋ Mandɛm ɛtɔk Bɛ́roa nkwɔ́, bárɔ́k arɛ́ mányíkɨ́si batɨ̌ bo, bɛ mánchyɛ́ bɔPɔ̌l ɛsɔŋɔri. ");
INSERT INTO kenNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Tɛ́mté wu, batɨ̌ bǒ nkwɔ́ Yesu bátɨ́k Pɔ̌l bɛ andɔk tɛ angɔkɔnyɛ́n, kɛ Sáilas nɛ Tímɔti bárɔ́p Bɛ́roa. ");
INSERT INTO kenNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Bo abhɛn bárɔ́ŋɔ́ nɛ Pɔ̌l, barɔk nɛ yi kpát bágháka Atɛns. Pɔ̌l aghati yɛ bhɔ mpok anɛ bápɛ̀tnsɛm bɛ́ mángátí Sáilas nɛ Tímɔti bɛ mánjáŋ mbi mántɛmɛri yi ayak amɛm ɛtɔk Átɛns. ");
INSERT INTO kenNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ɛnɛ́ Pɔ̌l ánòŋ Tímɔti nɛ Sáilas ɛtɔk Atɛns, ntɨ nɛ́ré sɔŋɔri yi amɛm bɛghɔ bɛ́ ɛtɔk ɛ́jwí nɛ bɛbhó njɔ ɛnɛ bo básɔt mbɔ bɔmandɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ɛ́kʉ́ are rɔŋ ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí bo Israɛl yɛ̌ntɨkɨ nywɔp ankɛm nɔkɔ ɛpʉ́ítí nɛ bhɔ nɛ bǒ Grik abhɛn mánóko nyaka Mandɛm nkwɔ. Ǎrɔŋ nyaka nkwɔ nɛfísiɛ yɛ̌ntɨkɨ nywɔp ankʉ nɔkɔ ɛnyumɔ́t nɛ bo abhɛn bátwɔ̀ árɛ́. ");
INSERT INTO kenNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Bǒfú bábhak abhɛn bátɔ̀ŋ mɛnyɨŋ ɛbhɛn bɛ́kɔ̀ ndɔ́ŋ ámɔ́t nɛ bakoŋo Ɛpikurɔs nɛ bɔ Stɔik, Bɔ́ nkwɔ́ bákɛ̀m nyaka ɛpʉ́ítí nɛ yi. Pɔ̌l ǎghàti nyaka bho mɛnyɨŋ ɛ̌ti Yesu andɛmɛ nɔkɔ bɛ́ chɔŋ bawú mámpɛtnsɛm ndǔ nɛpɛ́m. Ɛ́kʉ́ mbɔk ɛyap báré way Pɔ̌l mandɛmɛ nɔkɔ bɛ́, “Ɛchɨŋtǐ ɛnyɨŋ ɛnɛ nkwɔ́ ǎrɛ̀m nɔ́ mbɔŋ yi?” Báchák bɛ, “Ɛ́chí mbɔ bɛ yi ǎghàti bho chí ɛ̌ti bɔmandɛm abhɛn sɛ́bhɨ́kɨ́ rɨŋɨ fá ɛtɔk ɛnɛ.” ");
INSERT INTO kenNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Básɔt Pɔ̌l barɔk Ariyopagɔs, nɛbhʉɛt anɛ bǒbatí báchɛ̀m nɔkɔ nyaka, bárɛ́m ntá yi bɛ, “Sɛ́kɔŋ bɛ́rɨŋɨ ɛ̌ti mɛnyɨŋ bɛkɔ ɛbhɛ́n ɔ́tɔ̀ŋ. ");
INSERT INTO kenNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Mɛnyɨŋ ɛbhɛ́n ɔ́rɛ̀m bɛchi maknkay ntá yɛsɛ́ nɛ sɛ́yàŋ bɛ́rɨ́ŋɨ mbɔ̌ŋ ɛnyɨŋ ɛnɛ ɔ́rɛ̀m.” ");
INSERT INTO kenNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Báre rɛm ɛnyu ɛyɔ mbɔnyunɛ bo Atɛns nɛ mankɔ mankɛm abhɛn báchí arɛ́ bákɔŋ nyaka bɛ́chɔ́kɔ bɛghok nɛ bɛ́fyɛ mbok ɛ̌ti barak akɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pɔ̌l afate yɛ ate nɛ́ntɨ́ bǒ ɛchɛmɛ́ Areopagɔs yɔ abho bɛ́rɛm bɛ, “Bǒ Atɛns, ngɔ bɛ́ bǎfyɛ́ ntí ndǔ baraká bɔmandɛm tontó. ");
INSERT INTO kenNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ɛnɛ́ nchí kɔ ɛtɔk mfyɛ́ nɔkɔ amɨ́k ndǔ mɛnyɨŋ ɛbhɛn bǎchyɛ kɛnókó mbɔ bɔmandɛm, ndɔk ngaka nɛbhʉɛ́t amɔt anɛ ɛfɛmɛ akap ɛchi, ngɔ́ ndu básɨŋ arɛ́ bɛ, ‘Ntá mandɛm anɛ bo bábhɨkɨ rɨŋɨ.’ Mandɛm anɛ nɔ bé bǎchyɛ̀ kɛnókó yɛ̌ndu bǎbhɨkɨ rɨŋɨ yí kɛ mɛ́ghàti bhe mɛnyɨŋ ɛ̌ti yi. ");
INSERT INTO kenNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Mandɛm mmu ághókó mmɨk nkɛm nɛ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ ɛ́chí arɛ́, yí kɛ áchí Acha anɛ ábhɔ́ŋɔ́ bɛtaŋ mɛnkɛm amfay nɛ fá amɨk. Apú chɔkɔ amɛm bɛkɛt ɛbhɛ́n bakwǎŋwaŋ bághókó. ");
INSERT INTO kenNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Nɛ nkwǎŋwaŋ apú kwáy bɛ́kʉ yɛ̌nyɨŋ ánchyɛ́ yí mbɔnyunɛ yi apu chɛ́p yɛ̌nyɨŋ. Yímbɔŋ kɛ áchyɛ̀ nɛpɛ́m nɛ ɛ̌yú nɛ yɛ̌ntɨkɨ ɛnyɨŋ ɛ́chák ntá yɛ̌ntɨkɨ mmu. ");
INSERT INTO kenNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ayámbɨ aghókó nyaka mmǔ amɔt nɛ amʉɛt mmu wu kɛ̌ manɛrɛ́kɛrɛ́ bho ankɛm fá amɨk áfú. Ápɛ́rɛ ghoko yɛ̌ntɨkɨ nnɛrɛ́kɛt, ayambɨ abhʉrɛ nɛbhʉɛ́t anɛ bǒnɛrɛ́kɛt wu bábhàk nɛ mpok anɛ bɔ́ bábhɔ́ŋɔ́ bɛ́bhak arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Mandɛm akʉ ɛnyu yɔ bɛ́ bɔ́ mánjáŋ yi nɛ ndu báyàŋ yi mbɔ mmǔ anɛ ámɔ̀ nɛ amɔ́ bɛyaŋ ɛnyɨŋ amɛm ɛjuri, mánkwáy bɛrɨŋɨ yi. Kɛ sayri sayri, Mandɛm abhɨ́kɨ́ sap nɛkɔ nɛ yɛ̌ mmu ywɛsɛ amɔt. ");
INSERT INTO kenNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ɛ́chi nkúbhɛ́ mbɔ ɛnyǔ mmǔ ywɛka amɔt árɛ́mɛ́ nyaka bɛ, ‘Nɛpɛ́m ɛnɛsɛ́ nɛ́fù chi ntá yi, nɛ yí kɛ áchyɛ́ bhɛsɛ́ bɛtaŋ sɛ́kɔ̀, nɛ yí kɛ ákʉ́ bɛ sɛmbɔŋ nɛpɛ́m.’ Ɛ́chí mbɔ ɛnyǔ mbɔk batɛmɛ́ bakay bhɛka bárɛ́mɛ́ bɛ, ‘Bɛsɛ́ nkwɔ́ sɛ́chí bɔ̌ abhɛn Mandɛm.’ ");
INSERT INTO kenNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Tɛ̌ndu sɛ́chí yɛ́ bɔ̌ Mandɛm, sɛ́kɛ́ kaysi bɛ́ Mandɛm achí mbɔ ɛnyɨŋ ɛnɛ́ mmu ákwày bɛ́sɔt gol nɛ yɛ̌ chí silbha nɛ yɛ̌ chí ntáy angoko nɛ kɛboŋ ɛki nɛ ɛka ɛyi nkwɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Mandɛm afɛ́rɛ́ ntí ndu mɛnyɨŋ ɛbhɛn bo bákʉ́ ndǔ mpok anɛ bɔ babhɨkɨrɛ rɨŋɨ nkaysi yi. Kɛ nɛ́nɛ, ághàti bo mankɛm mbankɛm bɛ yɛ̌ntɨkɨ mmu antɨknsɛm ndǔ bɛbʉ́ ɛbhi, ");
INSERT INTO kenNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","mbɔnyunɛ abhʉ́rɛ́ nywɔp ɛnɛn yi átàŋ bǒ mankɛm ɛnyu ɛnɛ ɛchi chak. Anáŋ ayap mmu anɛ átàŋ manyé yɔ, nɛ atɔ́ŋ ɛrɨŋ bɛkʉ bǒ mmɨk mankɛm mándɨ́ŋɨ́ mmu wu, ndu ákʉ́ yi ápɛ́rɛ́nsɛm ndǔ nɛpɛ́m.” ");
INSERT INTO kenNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Mpok bághoko ndu Pɔ̌l árɛ̀mɛ ɛ̌ti nɛpɛrɛ́nsɛm ndǔ nɛpɛ́m, mbɔk ɛyap bare yɔkɔ yi, kɛ bachak barɛm bɛ, “Sɛ́kɔŋ bɛ ɔ́mpɛt ɔ́mfʉɛ́t ɔngati bhɛsɛ ɛ̌ti nɛpɛrɛ́nsɛm ndǔ nɛpɛ́m.” ");
INSERT INTO kenNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Pɔ̌l arɔ yɛ bɔ́ afú arɔk. ");
INSERT INTO kenNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Kɛ mbɔk bákóŋo yí. Bɔ́bhɔ mánóko. Dionisiɔs, mmǔ ɛchɛmɛ́ Ariyopagɔs, nɛ ngɔrɛ́ anɛ áká nnyɛ́n bɛ́ Damarís nɛ bo báchák babhak ndǔ nkwɔ bho abhɛn bakoŋo Pɔ̌l. ");
INSERT INTO kenNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pɔ̌l afa Atɛns arɔk ɛtɔk Kɔrint. ");
INSERT INTO kenNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Atɛmɛri mmu Israɛl amɔt arɛ́ anɛ aka nnyɛ́n bɛ Akwíla, mmǔ atú Pɔ́ntɔs. Ɛbhɨkɨre tat nyaka, ɛnɛ́ Akwíla nɛ ngɔrɛ́ ywi Prisíla bárɔ́ ɛtɔk Ítali mbɔnyunɛ Klaudiɔs Mfɔ Rom, achyɛ nyaka ɛyɔŋ bɛ́ bo Ju mankɛm mámfá Rom. Pɔ̌l arɔk bɛghɔ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Babhɔ̌ŋ nyaka awɔ́-bɛtɨk ámɔ́t nɛ Pɔ̌l, nɔ́ chí bɛtɨk bɛ́ghóko bɛ́tɛm nɛ ndɛn. Pɔ̌l achɔkɔ nɛ bhɔ mángoko nɔkɔ bɛ́tɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Pɔ̌l are rɔ́ŋ ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí bo Israɛl ndǔ yɛ̌ntɨkɨ nywɔbhɛ́ nɛywěmʉɛt ɛnap ankɛm nɔkɔ ɛpʉiti nɛ bhɔ nɛ anu nɔkɔ bɛ bo Israɛl nɛ abhɛn Grik mánóko mɛnyɨŋ ɛbhɛn yi ághàti bhɔ ɛ̌ti Yesu. ");
INSERT INTO kenNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Mpok Sáilas nɛ Tímɔti báfú atú Masidónia báchwɔ́bhɛ́ Atɛns, Pɔ̌l arɔ bɛtɨk bɛghoko bɛ́tɛm arɔbhɛ kʉ chi bɛtɨk bɛghati bo Mbok Ndɨ́ndɨ́ ndu mpok nkɛm anɛ yi ábhɔ́ŋɔ́, anu nɔkɔ bɛkʉ bo Israɛl mángɔ́ kpoŋoroŋ bɛ Yesu kɛ achí Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò. ");
INSERT INTO kenNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Kɛ bɔ́ kɛka nɛ yi. Mánsɔkɔti nɔkɔ yi. Akwɛt ndɛn ɛ́nɛ ɛchi yi amʉɛt, arɛm bɛ, “Ntǔ bɛbʉ́ bhɛka arɔp nɛ bhe. Amɔya achi pɛ́pɛ́p. Nɛbho ɛchɔŋ ntɨ̌knsɛm ntá yɛka nɛ ndɔbhɛ rɔ́ŋ chí ntá bo abhɛn bápú bo Israɛl.” ");
INSERT INTO kenNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Afa yɛ arɛ́, arɔk achɔkɔ ɛkɛt mmu amɔt anɛ aka nnyɛ́n bɛ Títiɔs Jɔ́stɔs. Jɔ́stɔs abhak mmǔ anɛ áchyɛ̀ Mandɛm kɛnókó. Ɛkɛrɛ yi ɛ́bhák kɛkwɔt nɛ ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí bo Israɛl. ");
INSERT INTO kenNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Mmǔ amɔt abhak arɛ́ anɛ aka nnyɛ́n bɛ Kríspɔs. Abhak mǔnti ɛkɛrɛ́ nɛnɨkɨ́mʉɛt. Yi anoko Yesu Acha nɛ ɛfo ɛyi ɛnkɛm. Bɛyǎ bǒ Kɔrint bachak abhɛ́n bághòk nyaka mɛnyɨŋ ɛbhɛn Pɔ̌l árɛ̀m mánóko nkwɔ, nɛ bájwíti bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Bɛti mɛ́mɔt, Yesu Acha aghati Pɔ̌l ndǔ kɛnɔ́ amɨk anti fúú bɛ, “Ɔ́kɛ́ cháy. Dɔ́k ambɨ bɛ́gháti bo ɛ̌ti ya. Kɛ́chɔkɔ kpak. ");
INSERT INTO kenNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Nchí nɛ wɔ nɛ yɛ̌ mmu apú kway bɛkʉ wɔ ɛnyɨŋ. Bɛyǎ bo bachi ɛtɔk ɛnɛ abhɛn babhak chɔŋ bǒbha.” ");
INSERT INTO kenNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pɔ̌l arɔk yɛ ambɨ bɛ́chɔ́kɔ ɛtɔk ɛyɔ ndu mmíɛ́ nɛ bataŋ átándát, antɔŋ nɔkɔ Ɛyɔŋ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Bǒ Rom bákʉ́ nɔ́kɔ́ Galío gɔ́bhanɔ atú Gris, bo Israɛl abhɛn bachi arɛ bágwɔ́t nnɛt nɛ bákɛ́m Pɔ̌l bárɔk ndu acha manyɛ́ nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Arɛ́, bágháti Galío bɛ, “Mmǔnɛ ánù bɛkʉ bo mánchyɛ́ nɔ́kɔ́ Mandɛm kɛnókó ɛnyu ɛnɛ́ ɛbhé yɛsɛ́ ɛ́pú yaŋ mmu ankʉ.” ");
INSERT INTO kenNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Kɛ mpok Pɔ̌l áyàŋ bɛrɛm ɛnyɨŋ bɛ́ ántáŋá mmʉɛt, Galio arɛm ntá bo Israɛl bɛ, “Bě bo Israɛl, mbɔ yí akʉ chi ɛbɛ́ptí ɛnyɨŋ nɛ yɛ̌ ndak abʉ́abʉ, mbʉ nkáá nɛ bhe. ");
INSERT INTO kenNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Kɛ tɛ̌ndu ndak anɛ achi chi ɛ̌ti mɛnyɨŋ ɛbhɛn bo bárɛ̀m nɛ manyɛ́n bo nɛ bɛbhé ɛbhɛka, be babhɔŋ mǎndɨ́ŋɨ́ ɛnyǔ bátàŋ wu. Mpú kwáy bɛtáŋ ayɔ barak.” ");
INSERT INTO kenNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Galío árɛ́m nɔ́kɔ́ nɔ, abók bhɔ́ bɛ mámfú amɛm acha manyé. ");
INSERT INTO kenNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Bafu nɔkɔ, bakɛm Sɔstɛ́nes mmu anɛ achi nyaka mǔnti ɛkɛrɛ́ nɛnɨkɨ́mʉɛt ɛyɔ bádɛ́n nɛfí acha manyé. Yɛ̌ nɔ, Galío akɛ fyɛ́ ntí arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pɔ̌l apɛt atat nɛ bǒnkwɔ Yesu abhɛn Kɔrint ndǔ bɛyǎ manywɔp. Arɔ yɛ bhɔ, asɔt achwǐnyɛ́n arɔk atú Síria nɛ Prisíla nɛ Akwíla. Báchwɔ́bhɛ́ nɔ́kɔ́ ɛtɔk Kɛnkreya, Pɔ̌l amu ntí bɛtɔŋ bɛ ǎbhʉ́rɛ́ bariɛp amɛn yi afyɛ́ bɛsí Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Báchwé achwi bárɔk Ɛ́fɛsɔs. Pɔ̌l arɔ Prisíla nɛ Akwíla angɔkɔnyɛ́n arɔk achwe amɛm ɛkɛrɛ́ nɛnɨkɨ́mʉɛt, are kɛ́m ɛpʉ́ítí nɛ bo Israɛl. ");
INSERT INTO kenNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Nkwɔ́ wap abhɛn mánóko bárɛm bɛ Pɔ̌l ántát nɛ bhɔ kɛ yi kɛka. ");
INSERT INTO kenNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Pɔ̌l arɛm chi bɛ, “Mbák chí nkaysi Mandɛm chɔŋ mpɛtnsɛm fá ntá yɛka.” Arɛm nɔkɔ nɔ, arɔ bhɔ achwe áchwí bare rɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ágháká nɔ́kɔ́ Seséria akó ɛtɔk, arɔk akaka nkwɔ́ Yesu abhɛn bachi arɛ́, asɛp arɔk Antiɔk. ");
INSERT INTO kenNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Átát nɔ́kɔ́ arɛ́ mpǎy manywɔp, afa are kɔ bɛtɔk nɛ bɛtɔk atú Galéshia nɛ Fríjia, amfyɛ nɔkɔ bakoŋo Yesu mankɛm ntɨ ndǔ nɛsɨkɨ́ntɨ ɛnap. ");
INSERT INTO kenNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Mmu Israɛl amɔt anɛ áká nnyɛ́n bɛ Apólos atwɔ́ Ɛ́fɛsɔs. Ɛtɔk nɛbhe ɛyi ɛ́bhák Aleksándriya. Yi achí nyaka mmu anɛ árɨ́ŋɨ́ bɛrɛm kɛpɨ nɛ arɨŋɨ Ɛyɔŋ Mandɛm sayri. ");
INSERT INTO kenNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Mánaŋ bátɔŋ nyaka yí mbi Yesu Acha nɛ ághàti nyaka bo mɛnyɨŋ abhɛn bɛ́dù yi antɨ bɛghati bo ɛ̌ti Yesu nkúbhɛ́ mbɔ ɛnyu bɔ bɛchi. Kɛ arɨŋɨ chí nɛjwiti ɛnɛn Jɔ̌n atɔŋɔ bo. ");
INSERT INTO kenNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Amɛm ɛtɔk Ɛ́fɛsɔs, Apólos abho bɛ́gháti bo mɛnyɨŋ ɛ̌ti Yesu amɛm ɛkɛrɛ́ nɛnɨkɨ́mʉɛt kɛbhɔ́ŋ bɛcháy. Prisíla nɛ Akwíla bághókó nɔ́kɔ́ Ɛyɔŋ Mandɛm ɛnɛ yi ághàti bho ɛ̌ti Yesu, básɔ́t yí ɛkɛt ɛyap, mánáŋa batɔŋ yi mɛnyɨŋ ɛbhɛn bɛ́yɨ́ŋɨ́ mbi Mandɛm nkúbhɛ́ mbɔ ɛnyǔ bɛchi. ");
INSERT INTO kenNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apólos ákʉ ntɨ bɛ́rɔ́ŋ Akáiya. Bǒbati bakoŋo Yesu abhɛn Ɛ́fɛsɔs báfyɛ́ yi ntɨ nɛ básɨ́ŋ ɛkáti ntá bakoŋo Yesu abhɛn Akáiya bɛkʉ bɛ mánsyɛpti yi sayri. Aghaka nɔkɔ arɛ́, akwak tontó bo abhɛn Mandɛm atɔŋ bɔ bɛrɨ̌ndu nɛ mánóko. ");
INSERT INTO kenNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Arɛ́, are kɛm ɛpʉ́ítí nɛ bo Israɛl bɛsí bo mankɛm. Adɛbhɛ nɔkɔ bɔ amɨk ndu ɛpʉ́ítí ɛyɔ nɛ are sɔt mɛnyɨŋ ɛbhɛn bɛchi amɛm Ɛkáti Mandɛm bɛtɔŋ kpoŋoroŋ bɛ Yesu kɛ achí Mpɛmɛ anɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò. ");
INSERT INTO kenNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ɛnɛ́ Apólos áchí Kɔrint, Pɔ̌l are kɔ atú Esia. Akɔ kpát aghaka Ɛ́fɛsɔs. Atɛmɛri mpay bakoŋo Yesu arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Abhɛ́p bhɔ́ bɛ, “Ɛfóŋó Bɛdyɛrɛ atwɔ ntá yɛka mpok mǎnókó Yesu?” Bákɛ́mɛ yi bɛ́ “Áe! Yɛ̌ chí bɛghok bɛ Ɛfóŋó Bɛdyɛrɛ achí sɛ́bhɨ́kɨ́ re ghok.” ");
INSERT INTO kenNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pɔ̌l abhɛ́p bhɔ́ bɛ, “Ntí anɛ bájwítí yɛ nyaka bhe achi bɛ yi?” Bákɛ́mɛ yi bɛ, “Chí ɛ̌ti mɛnyɨŋ ɛbhɛn Jɔ̌n ághàti bho kɛ bájwítí bhɛsɛ.” ");
INSERT INTO kenNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pɔ̌l abho yɛ bɛkʉ bɔ́ mánjwímɛm. Arɛm bɛ, “Jɔ̌n ǎjwìti nyaka bo bɛtɔŋ bɛ bátɨknsɛm ndǔ bɛbʉ́ bhap angati nɔkɔ bo Israɛl bɛ́ bábhɔŋ mɛ́nóko mmu anɛ átwɔ̀ yi ansɛm, nɔ chi Yesu.” ");
INSERT INTO kenNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Bǒ Ɛ́fɛsɔs bhɔ bághókó nɔ́kɔ́ nɔ, báka bájwíti bhɔ mbɔ bo abhɛn mánóko Yesu Acha. ");
INSERT INTO kenNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pɔ̌l anyaŋa yɛ bɔ́ amɔ anti. Ɛfóŋó Bɛdyɛrɛ abhak nɛ bhɔ, bábho bɛrɛm bɛyɔŋɔ́tɔk nyáŋá nyáŋá ɛbhɛ́n bɔ́ babhɨkɨ ghɔ́k, mándɛm nɔkɔ mɛnyɨŋ ɛbhɛ́n Mandɛm afyɛ́ bhɔ́ antɨ. ");
INSERT INTO kenNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Bɔ mankɛm babhak mbɔ batí byo nɛ apay. ");
INSERT INTO kenNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pɔ̌l abhak Ɛ́fɛsɔs ndǔ bataŋ árát andɔk nɔkɔ ɛkɛrɛ́ nɛnɨkɨ́mʉɛt bɛghati bhɔ Ɛyɔŋ Mandɛm kɛbhɔŋ bɛcháy ankɛm nɔkɔ ɛpʉ́ítí nɛ bhɔ ndu áyàŋ bɛ bɔ́ mándɨ́ŋɨ́, mánoko, ɛnyǔ Mandɛm áyàŋ bɔ mambak nɛ yi mbɔ Mfɔ wap. ");
INSERT INTO kenNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Kɛ mbɔk ɛyap báchók batú kɛnoko ɛnyɨŋ ɛnɛ Pɔ̌l árɛ̀m. Báré rɛm chí bɛbɛ́ptí mɛnyɨŋ ɛ̌ti mbi Acha bɛsí bo mankɛm. Ndu bákʉ̀ nɔ Pɔ̌l asɔt bo abhɛn mánókó arɔk nɛ bhɔ́, ankɛm nɔkɔ ɛpʉ́ítí nɛ bhɔ ɛ̌ti Ɛyɔŋ Mandɛm amɛm áchá Tiránɔs yɛ̌ntɨkɨ nywɔp. ");
INSERT INTO kenNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Arɔk ambɨ bɛ́kʉ ɛnyuyɔ ndǔ mamiɛ́ ápay. Ɛ́kʉ bo mankɛm abhɛn báchí atú Esia, bághók Mbok Ndɨ́ndɨ́ ɛ̌ti Yesu Acha, nɔ chi bo Israɛl nɛ abhɛn bápú bo Israɛl. ");
INSERT INTO kenNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ndǔ Pɔ̌l átɔ̀ŋ Ɛyɔŋ Mandɛm, Mandɛm achyɛ yí bɛtaŋ bɛ́kʉ mɛnyɨŋɨ́ maknkay ɛbhɛ́n bo bábhɨkɨre ghɔ́. ");
INSERT INTO kenNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ɛ́kʉ́ kpát bo babho bɛsɔt bɛbhɔ́kɔ́ ndɛn ɛbhɛn bɛ́tɛ́sɛ bɛsí nɛ nkú yi, mámbarɛ nɔkɔ amʉɛt bǒmame, nɛ bɔ́ mántaŋ nɔkɔ, nɛ bɛfóŋó bɛbʉ́bɛbʉ mɛ́mfu nɔkɔ bo amʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Mpǎy bo Israɛl babhak arɛ abhɛn bákɔ̀ mánkʉ nɔkɔ bɛfóŋó bɛbʉ́bɛbʉ mɛ́mfú mɛ́ndɔ́ bo abhɛn bɔ bɛsɔŋɔri. Báre mɔ bɛ́bok bɛfóŋó bɛbʉ́bɛbʉ ndu nnyɛ́n Yesu Acha nkwɔ́. Babho yɛ bɛrɛm ntá bɛfóŋó bɛbʉ́bɛbʉ bɛ, “Ndu nnyɛ́n Yesu mmu Pɔ̌l ághàti bo ɛ̌ti yi, fú ka yi amʉɛt.” ");
INSERT INTO kenNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Bɔ̌ Sɛva bati tándrámɔt bare kʉ nɔ. Sɛva achi nyaka mǔngo bachiǎkap Mandɛm amɔt. ");
INSERT INTO kenNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ɛwak ɛ́mɔ́t ɛfóŋó ɛbʉ́bʉ ɛghati bhɔ bɛ, “Ndɨ́ŋɨ́ Yesu, ndɨŋɨ Pɔ̌l, kɛ báchí ntɨkɨ bho?” ");
INSERT INTO kenNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Mmǔ anɛ ɛfóŋó ɛbʉ́bʉ ɛsɔŋɔri yí akwɛ́n bɔ́ amʉɛt arakati ndɛn ɛyap nɛ aták bɔ́ mankɛm kpát bábʉɛ́ báfú bɛbho bɛwɔ nɛ bɛfʉɛt amʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Bo abhɛn báchi Ɛ́fɛsɔs mankɛm, bo Israɛl nɛ abhɛn bápú bo Israɛl bághókó nɔ́kɔ́ ndak anɛ́ áfákárí, bɛcháy bɛ́kɛ́m bɔ́ bábhó bɛchyɛ nnyɛ́n Yesu Acha kɛnókó. ");
INSERT INTO kenNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Bɛyǎ bo abhɛn mánókó babho bɛfu kpoŋoroŋ mánsu nɔkɔ bɛbɛ́ptí mɛnyɨŋ ɛbhɛn bɔ bákʉ̀. ");
INSERT INTO kenNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bɛyǎ bǒ abhɛn bákʉ̀ baraká mandɛm nsé, bátwɔ́ nɛ bɛkátǐ-njɔ ɛbhap mɛnkɛm básɔ́ŋ bhɔ bɛsí bo mankɛm. Nɛ mbɔ báti nyaka bhɔ ti mbʉ bɛchyɛ nkáp anɛ aghaka bɛbhɔk silbha nka bɛsa bɛpay nsɛm byo (50.000). ");
INSERT INTO kenNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ɛ́kʉ Ɛyɔŋ Mandɛm ataka mbaŋ nɛ mbaŋ, ɛndɔk nɔkɔ chi ambɨ nɛ bɛtaŋ. ");
INSERT INTO kenNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Mɛnyɨŋ ɛbhɛn bɛ́fákárí nɔ́kɔ́, Pɔ̌l akʉ ntɨ ɛni bɛ́ yí abhɔŋ bɛ́fʉɛ́t atú Masidónia nɛ atú Akáiya ampɛtnsɛm Yerúsalɛm. Arɛm bɛ, “Nnáŋ ngáká arɛ́, mbɔŋ bɛrɔŋ Rom nkwɔ.” ");
INSERT INTO kenNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ató yɛ bakwak abhi batí ápay, Tímɔti nɛ Ɛrástɔs, bɛ́ mándɔ́k ambɨ atú Masidónia. Yímbɔŋ arɔp ansɛm atú Esia ndu mɔ́mbɨŋɨ́ mpok. ");
INSERT INTO kenNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Mpok yɔ, ɛsɔŋɔri ɛ́bhó ɛtɔk Ɛ́fɛsɔs ɛ̌ti Mbi Yesu Acha. ");
INSERT INTO kenNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ntɛnátɛn achí nyaka arɛ́ anɛ áká nnyɛ́n bɛ Dɛmɛ́triyɔs. Ǎsɔt nyaka Silbha ankʉ nɔkɔ bɔ̌bɛkɛrɛ́ mandɛm nsé anɛ bábhɨ̀ŋɨ bɛ Atɛ́mis. Awɔ́-bɛtɨk ɛbhi áre chyɛ̀ yí nɛ bo báchák abhɛn bákʉ̀ bhɔ bɛyǎ nsay. ");
INSERT INTO kenNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Dɛmɛ́triyɔs abhɨŋɨ bhɔ báchɛ́m nɛbhʉɛt amɔt, arɛm bɛ, “Bɔtá, bǎrɨŋɨ bɛ́ kɛnɛ́m ɛkɛsɛ́ kɛnkɛm kɛ́fù chí ndǔ awɔ́-bɛtɨk anɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Bě babhɔŋ bǎghɔ̀ nɛ bǎghòk ɛnyɨŋ ɛnɛ́ Pɔ̌l ákʉ̀, puyɛ̌ chí ndiɛrɛ fá Ɛ́fɛsɔs, kɛ atú Esia ankɛm. Akʉ bɛyǎ bo báka nɛ yi ndu yi árɛ̀m bɛ, ‘Bɔmandɛm abhɛn bo bághókó nɛ amɔ bápú bo mandɛm wáwák!’ ");
INSERT INTO kenNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ǎkway bɛ́chɔ́ŋti yɛ bɛtɨk ɛbhɛsɛ́ ɛbhɛn mbák sɛ́bhɨ́kɨ́ sɔt mpok. Ǎkway bɛkʉ nkwɔ́ bɛ́ bo bákɛ́pɛrɛ sɔt ɛkɛrákap mandɛm ngɔrɛ́ Atɛ́mis, mbɔ ɛnyɨŋ. Mbák ɛ́mfákárí nɔ, Atɛ́mis mmu áchí mandɛm ngo ywɛsɛ apú pɛrɛ bhak yɛ̌nyɨŋ. Nɛ yí kɛ̌ yɛ̌ntɨkɨ mmu atú Esia nɛ bǒ mmɨk mankɛm báchyɛ̀ kɛnókó!” ");
INSERT INTO kenNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Bɔ bághók nɔ́kɔ́ ɛnyɨŋ nɛ Dɛmɛ́triyɔs arɛmɛ, batí átáka bɔ amɛm, bábho bɛ́bɨk mandɛmɛ nɔkɔ bɛ, “Atɛ́mis, mandɛm bǒ Ɛ́fɛsɔs, chi mandɛm ngo!” ");
INSERT INTO kenNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ɛbyɔk ɛ́kwɛ́n ɛtɔk Ɛ́fɛsɔs ɛnkɛm. Bo barɔk ayak bákɛ́m Gáyɔs nɛ Arístakɔs báyá, bárɔk amɛm acha ɛtɔk nɛ bhɔ́. Gáyɔs nɛ Arístakɔs babhak bǒ Masidónia abhɛn bákɔ̀ nɛ Pɔ̌l. ");
INSERT INTO kenNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pɔ̌l are yáŋ bɛrɔŋ ndǔ nchɛmti-bǒ bhɔ bɛ ádɛm ɛnyɨŋ, kɛ bakoŋo Yesu kɛchyɛ yí mbi bɛ ánkʉ nɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Mbɔk bǒbatí ɛtɔk bábhák mamʉɛrɛ bhi. Bɔ́bhɔ bátó nkwɔ́ ɛyɔŋ mɛnɨk yi mmʉɛt bɛ akɛ sá ɛkak amɛm áchá. ");
INSERT INTO kenNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ɛbyɔk ɛ́kwɛn amɛm áchá mbɔnyunɛ bɛyǎ bho bábhɨ́kɨ́ rɨŋɨ nyaka mbɔ̌ŋ ndak anɛ achi amɨk. Ɛbhak yɛ bɛ mbɔk bábɨ̀k mándɔkɔ nɔkɔ ɛyap ɛbhe, báchák mántaŋ mandɔkɔ nɔkɔ ɛyap. ");
INSERT INTO kenNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Mbɔk ɛyap bághɔ́ nɔ́kɔ́ ndǔ bo Israɛl bátó Aleksánda ambɨ, bákáysi bɛ́ yí kɛ átwɔ́ nɛ ɛsɔŋɔri, ɛ́kʉ́ Aleksánda asá áwɔ́ amfay ndu áyàŋ bɛ́rɛ́m ɛnyɨŋ ndu bɛ́táŋa mmʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Kɛ bárɨŋɨ nɔ́kɔ́ bɛ́ achí mmu Israɛl, bápɛ́t bábho bɛwat mandɛmɛ nɔkɔ bɛ, “Atɛ́mis, mandɛm anɛ bǒ Ɛ́fɛsɔs, chí mandɛm ngo!” Barɔk ambɨ bɛkʉ ɛnyuyɔ ndǔ maŋɔkɔ́ nywɔp ápáy. ");
INSERT INTO kenNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Nsɨŋɨ́-bɛkati anɛ ɛtɔk Ɛ́fɛsɔs anu kpát akʉ mbaŋ akwɛn. Abho yɛ bɛrɛm bɛ, “Bo Ɛ́fɛsɔs! Agha abhɨkɨ rɨŋɨ bɛ ɛtɔk Ɛ́fɛsɔs kɛ ɛ́bhàbhɛri ɛkɛrákap ɛnɛ Atɛ́mis nɛ ntay mandɛm ɛnɛn nɛ́fú amfay nɛ́kwɛ́nɛ́ fá amɨk ntá yɛsɛ? ");
INSERT INTO kenNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Tɛ̌ndu yɛ̌ mmu apú kwáy bɛ́táŋa mɛnyɨŋ ɛbhɛn, bǎbhɔŋ mbʉ bɛ́chɔ́kɔ chí kpák kɛchyɛ ɛsɔŋɔri. ");
INSERT INTO kenNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Bǎsɔt bǒbhɛn bǎtwɔ fá nɛ bhɔ ɛnɛ́ bábhɨ́kɨ́ ghɛp yɛ̌nyɨŋ amɛm ɛkɛrákap ɛyɛsɛ nɛ yɛ̌ ɛbɛ́ptí ɛnyɨŋ bábhɨ́kɨ́ rɛm ɛ̌ti Mandɛm aywɛsɛ ");
INSERT INTO kenNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Sɛ́bhɔ̌ŋ bǒ batí nɛ manywɔp anɛ bátaŋ manyé. Mbák Dɛmɛ́triɔs nɛ bǒ ɛka bábhɔŋ ndak nɛ mmu, mántwɔ́ arɛ́ nɛ wú bɛ mántáŋ. ");
INSERT INTO kenNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Kɛ mbák ndak áchák áchí anɛ́ bǎyàŋ bɛrɨŋɨ, chɔŋ mányurɛ wú amɛm áchá ɛtɔk ndu nywɔp ɛnɛn manyé. ");
INSERT INTO kenNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Nchí rɛm ɛnyunɛ́ nɛ ntí bɛ, bǎkway bɛchyɛ bhɛsɛ́ ɛsɔŋɔri bɛ́ sɛ́twɔ́ nɛ ɛbyɔk ɛtɔk ɛnyu ɛnɛ́, mbák mámbɛ́p bhɛsɛ́, sɛpu bhɔ́ŋ ɛnyɨŋ ɛnɛ́ sɛ́rɛ̀m.” ");
INSERT INTO kenNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Árɛ́mɛ́ nɔ́kɔ́ nɔ́, aghati bhɔ́ bɛ́ mángúrɛ́. Ɛchɛm ɛ́táka. ");
INSERT INTO kenNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ɛbyɔk ɛyɔ ɛ́máy nɔ́kɔ́ Ɛ́fɛsɔs, Pɔ̌l abhɨŋɨ bakoŋo Yesu. Arɛm kɛpɨ nɛ bhɔ́ ndu bɛ́fyɛ́ bɔ́ ntɨ. Arɔ yɛ bhɔ́ abho bɛrɔŋ atú Masidónia. ");
INSERT INTO kenNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ndǔ árɔ̀ŋ, are fyɛ́ bakoŋo Yesu ntɨ amɛm bɛtɔk Masidónia mɛnkɛm, kpát achwɔp ɛtɔk Gris. ");
INSERT INTO kenNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Abhak arɛ́ ndǔ bataŋ árát. Ndu átòŋti mmʉɛt bɛ́sɔt áchwi andɔk Síria, aghók bɛ́ bo Israɛl bápà bɛ́kɛm yi. Ayibhiri ntɨ ɛni arɔbhɛ sɔt chí mbi atú Masidónia bɛ́kɔ́ amɨk ámpɛ́tnsɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Bo abhɛn bákɔ̀ nɛ yi babhak Sopátɛ mmɔ̌ Pírɔs mmu ɛtɔk Bɛ́roa, nɛ bǒ Tɛsalónika bati apay, nɔ chi Arístakɔs nɛ Sɛkúndus, nɛ Gáyɔs mmu ɛtɔk Dɛ́be, nɛ Tímɔti, nɛ bo atú Esia bati apay, nɔ chi Tíkíkɔs nɛ Trofímɔs. ");
INSERT INTO kenNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ɛ́tárɛ́ nɔ́kɔ́, bɔ́ bárɔ́ bhɛsɛ́ bárɔ́k ambɨ mɛnoŋ bhɛsɛ́ ɛtɔk Troas. ");
INSERT INTO kenNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Sɛ́sɔt achwǐnyɛ́n ɛtɔk Fílipi, sɛ́ré koŋo bhɔ, mpok ɛpǎ bo Israɛl ɛnɛ́ brɛt anɛ kɛbhɔŋ yís ɛ́fʉɛ́rɛ́. Sɛ́kɔ́ anyɛ́n anyɛn ndǔ manywɔp átáy sɛ́tɛ́mɛri bhɔ Troas, nɛ sɛ́bhák arɛ́ ndu manywɔp tándrámɔt. ");
INSERT INTO kenNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ndǔ nywɔp ɛnɛ́n mbɨ ndǔ sɔ́nde, sɛ́chɔ́kɔ nɛ bǒnkwɔ́ nɛbhʉɛt amɔt ndǔ Nɛnyiɛ Ɛta. Pɔ̌l abhɔ̌ŋ nyaka bɛ́rɔ́ betí. Ɛkʉ́ arɛm kɛpɨ nɛ bhɔ kpátɛ nɛntɨ bɛti. ");
INSERT INTO kenNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Bɛyǎ bɛrɔ́ŋɔ́ bɛ́bhak ndǔ mɔ́kɛt anɛ áchí amfay anɛ bhɛsɛ́ nɛ bhɔ́ sɛ́chɛ́mɛ́ arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ɛsakámú amɔt anɛ áká nnyɛ́n bɛ Yútikɔs abhak ndǔ ɛchɨ́kɨ́ ɛnɛ nyɛ́sɛ́kɛt chɔ́kɔ́. Mɔ́kɛt anɛ sɛ́chí arɛ abhak ndǔ nɛŋɔk ɛkɛt ɛnɛn nɛjwi arat. Ndǔ Pɔ̌l árɔ̀ŋ ambɨ bɛ́gháti bhɔ mɛnyɨŋ ndǔ ɛrɔri mpok, Yútikɔs abho mɛmɔk kɛnɔ́. Ákwɛ́n nɔ́kɔ́ kɛnɔ́, amok akwɛ́n amɨk nɛfí. Bápɛ́rɛ sɛp bɛ mámpɔ́kɔ́ yi agú. ");
INSERT INTO kenNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pɔ̌l asɛp yɛ amɨk akuri akɛ́m yí nɛ amɔ́ ápáy abhɛnɛ, arɛm bɛ, “Bǎkɛ́ cháy, achí nɛpɛ́m”. ");
INSERT INTO kenNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Pɔ̌l apɛt yɛ nsɛm amfay. Mányiɛ nɔ́kɔ́ Nɛnyiɛ́ Acha, arɛm kɛpɨ nɛ bhɔ ndǔ ɛrɔ́rí mpok tɛ̌ nywɔp nɛ́yí. Arɔ yɛ bɔ́ arɔk. ");
INSERT INTO kenNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Básɔt ɛsakámu wu bápɛtnsɛm anywɔ́p nɛ yí mbɨk nɛ bɛyǎ maŋák antɨ. ");
INSERT INTO kenNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Sɛ́yámbɨ ndu áchwí sɛnok bɛrɔŋ Asɔs. Yímbɔŋ anaŋa atɨ nyaka bɛ́kɔ́ amɨk. Sɛ́ré rɔ́ŋ nɛ́ nkaysí bɛ́ Pɔ̌l arɔbhɛ tɛmɛri bhɛsɛ́ ɛtɔk Asɔs nɛ sɛ́nsɔt yí arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Átɛ́mɛ́rí nɔ́kɔ́ bhɛsɛ Asɔs, achwe nkwɔ́ ndu áchwi anɛ sɛchi amɛm nɛ bɛsɛ́ mankɛm sɛ́rɔ́k Mitilene. ");
INSERT INTO kenNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Nɛ́yí nɔ́kɔ́, sɛ́rɔ́k sɛ́chwɔ́p nɛchyɛ̌nyɛ́n Kios. Nɛ́pɛ́t nɛ́yi nɔ́kɔ́, sɛ́nók sɛ́chwɔ́p Sámɔs, nɛ ndǔ ntɨnywɔp sɛ́gháka Milɛ́tɔs. ");
INSERT INTO kenNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pɔ̌l anáŋ atɨ nyaka bɛ sɛ́mfʉɛt kɛte Ɛ́fɛsɔs, mbɔnyunɛ abhɨkɨ yáŋ nyaka bɛ sɛ́nchɔ́ŋti mpok atú Esia. Are wɛ̀nɛ bɛ mbák Mandɛm ánkwák, yi ánchwɔ́p Yerúsalɛm ndǔ nywɔp Ɛpǎ Pɛntɛkɔs. ");
INSERT INTO kenNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Sɛ́gháká nɔ́kɔ́ Milɛ́tɔs, Pɔ̌l ató ɛyɔŋ bɛ bǒbatí nkwɔ Yesu abhɛn Ɛ́fɛsɔs mántɛ́mɛ́rí yi arɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Bátɛ́mɛ́rí nɔ́kɔ́ yi, aghati bhɔ bɛ, “Bě babhɔŋ bǎrɨŋɨ ndǔ nɛpɛ́m ɛna nɛ́chí mpǒknkɛm anɛ mɛnchí atú Esia bɛ́bhó nywɔp ɛnɛ́n mbɨ bɛ́gháka ɛchɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nchí kʉ nyaka bɛtɨk Yesu Acha nɛ nɛsɛptǐmʉɛt nɛnkɛm, nɛ babhɛsɛ amɨ́k ɛ̌ti mamɔ anɛ ǎtwɔ̀ ntá ya ndǔ bo Israɛl bápà bɛfyɛ mɛ ndǔ ɛsɔŋɔri. ");
INSERT INTO kenNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Bǎrɨŋɨ ndǔ ntwɔ́ ntɔ́ŋ Ɛyɔŋ Mandɛm ntá bɛká bho nɛ nkɔ nɔkɔ bɛkɛt nɛ bɛkɛt nkɛ bhɛsɛ yɛ̌nyɨŋ ɛnɛ́ ɛ́kwáy bɛkwak bhe. ");
INSERT INTO kenNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Nde ya batú bo Israɛl nɛ abhɛn bápú bo Israɛl bɛ́ mántɨknsɛm ndǔ bɛbʉ́ ɛbhap mánkóŋó Mandɛm nɛ bɛ́ mámbɔ́ŋ nɛka nɛ Acha ywɛsɛ Yesu Kristo. ");
INSERT INTO kenNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Nɛ́nɛ, mɛ́rɔ̀ŋ Yerúsalɛm nkúbhɛ́ mbɔ ɛnyǔ Ɛfóŋó Bɛdyɛrɛ ányìɛrɛ mɛ, yɛ̌ndu mbɨ́kɨ́ rɨŋɨ ɛnyɨŋ ɛnɛ́ ɛ́fákari chɔŋ nɛ mɛ arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ndɨ́ŋɨ́ chí bɛ Ɛfóŋó Bɛdyɛrɛ ághàti mɛ bɛ́ yɛ̌ntɨkɨ nɛbhʉɛt anɛ nchwɔ́bhɛ́ chɔŋ bo mámfyɛ́ mɛ ɛkɛrɛ́kɛnɔŋ nɛ mánchyɛ mɛ ɛsɔŋɔri. ");
INSERT INTO kenNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Kɛ mpú sɔt nɛpɛ́m ɛna mbɔ ɛnyɨŋ. Nchí yáŋ chí bɛ njɛt tɛndǔ ngwɛnti, nnáŋá bɛtɨk abhɛn Yesu Acha áchyɛ́ mɛ́ nkʉ. Bɛtɨk ɛbhɔ chí bɛ́gháti Mbok Ndɨ́ndɨ́ ɛ̌ti bɛrɨ̌ndu ɛbhɛn Mandɛm ábhɔ́ŋɔ́ nɛ bo. ");
INSERT INTO kenNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Nnáŋ nkɔ mbáŋ nɛ mbaŋ, ngáti bhe ɛnyǔ Mandɛm ábhàk nɛ bo mbɔ Mfɔ wap, nɛ nɛ́nɛ ndɨ́ŋɨ́ bɛ́ yɛ̌ mmu ywɛka amɔt apú pɛrɛ ghɔ́ mɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Nchí ghati yɛ bhe ɛchɔŋ bɛ́ mbák mmu ywɛka amɔt arɔp ansɛm anɛ́m ɛbhɨ amɔ aya apu arɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ngátí bhé yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ́ ɛ́yɨ́ŋɨ́ nkaysi Mandɛm nɛ yɛ̌ ɛ́mɔ́t mbɨ́kɨ́ bhɛsɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Kɛ́m ká mmʉɛt sayri, mǎnkɛm bǒnkwɔ Mandɛm ankɛm nkwɔ sayri. Bǎkɛ́ ghɔkɔntɨk bɛ Mandɛm asɔt manoŋ Mɔ́ywi akʉ bɔ mámbák bǒbhi. Nɛ ɛ̌ti yap kɛ Ɛfóŋó Bɛdyɛrɛ ákʉ́ mǎmbak bǒ batí bhap. ");
INSERT INTO kenNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ndɨ́ŋɨ́ bɛ́ mpok ndɔ́ bhe, chɔŋ nkwɔ ɛ́nchwe nɛntɨ ɛnɛka, nɛ ɛ́pú rɔ bhe. ");
INSERT INTO kenNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Mpok ǎtwɔ nɛ mpok yɔ ánáŋ ánkwáy, mbɔk bǒnkwɔ báyibhiri tɛtɛp Mandɛm mándɔbhɛ rɛm chi barak anɛ ápɔ̀kɔ bho angʉrɛ ɛbhɨ kpát mánja bakoŋo Yesu bɛ mandɔbhɛ koŋo chi bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Sɔt yɛ ka mpok nɛ bǎkɛ́ ghɔkɔntɨk bɛ nchí ghati nyaka bhe mɛnyɨŋ nɛ babhɛsɛ amɨ́k, njɛp nɔkɔ be batú bɛ̌ti nɛ ngósí ndǔ mamiɛ́ árát. ");
INSERT INTO kenNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Nɛ́nɛ, nchí fyɛ́ bhé amɔ Mandɛm nɛ nchí rɔ bhe Ɛyɔŋ ɛyi ɛnɛ ɛ́tɔ̀ŋ be bɛrɨ̌ndu ɛbhi. Ɛyɔŋ ɛyi ɛ́kwày bɛkʉ mǎngó mǎnsɛ́nɛ́, nɛ ɛkway bɛchyɛ bhe áfɔ́k anɛ́ Mandɛm ábhʉ́rɛ́ ntá bǒ abhɛn yí ákʉ́ mámbák abhi. ");
INSERT INTO kenNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mpok nchí nɛ bhe, mbɨ́kɨ́ fyɛ́ amɨ́k ndǔ nkáp anɛ mmu nɛ yɛ̌ chi ndɛn ɛnɛ mmú. ");
INSERT INTO kenNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Bě babhɔŋ bǎrɨŋɨ bɛ́ nkʉ bɛtɨk nɛ amɔ́ya ndu bɛbhɔŋ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ́ mɛ nɛ bo abhɛn mɛ̌kʉ̀ bɛtɨk Mandɛm nɛ bhɔ sɛ́chɛbhɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ndǔ mɛnyɨŋ mɛnkɛm, ntɔŋ be bɛ sɛ́bhɔŋ bɛkʉ bɛtɨk bɛ sɛ́nkwák bo abhɛn mmʉɛt apu bhɔ, nɛ sɛ́kɛ́ ghɔkɔntɨk ɛnyɨŋ ɛnɛ Yesu Acha árɛ́mɛ́ bɛ, ‘Ɛ́rɨ̌ ntá mmu anɛ áchíɛ ɛcha mmu anɛ ásɔrɛ sɔt.’” ");
INSERT INTO kenNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pɔ̌l ánáŋá nɔ́kɔ́ bɛ́rɛ́m ɛnyɨŋ ɛnɛ yi árɛ̀m, bɔ́ mankɛm bátɛp mánɛ́n amɨk, babho mɛnɨkmʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Mankɛm bábho bɛdi kɛbhɔ mámbɛnɛ nɔkɔ yi nɛ mándiɛbhɛ nɔkɔ yi nɛkɔ bɛ, “Ɔ́nkɔ sayri.” ");
INSERT INTO kenNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ɛnyɨŋ ɛnɛ ɛ́kpɨ́k ɛ́kʉ́ bɔ bádí kɛbhɔ tontó chi ndǔ yi ághátí bhɔ bɛ bápú pɛrɛ ghɔ yi. ");
INSERT INTO kenNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Bɛsɛ́ nɛ Pɔ̌l sɛ́rɔ́ bǒbatí nkwɔ́ Ɛ́fɛsɔs. Achwi ápɔ́kɔ bhɛsɛ́ sɛ́pé sɛrɔk téé sɛ́gháká ndǔ ɛtɔk ɛnɛ nnyɛ́n nɛkabhɛ ɛnɛ bábhɨ̀ŋɨ bɛ Kós. Nɛ́yí nɔkɔ sɛ́rɔ́k sɛ́chwɔ́p Ródes. Sɛ́fú nɔ́kɔ́ árɛ́ sɛ́rɔ́k sɛ́gháka Patara. ");
INSERT INTO kenNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Arɛ́ sɛ́ghɔ́ áchwi áchák anɛ́ árɔ̀ŋ atú Foníshia. Sɛ́chwé sɛ́ré rɔ́ŋ. ");
INSERT INTO kenNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Sɛ́gháká nɔ́kɔ́ nɛbhʉɛt anɛ sɛ́ghɔ̀ Sáyprɔs, sɛ́rɔ́ yɛ Sáyprɔs ɛbhe awɔ́ghɔ, sɛ́fʉɛ́t bɛ́rɔ́ŋ ndǔ mmɨk Síria. Sɛ́rɔ́k sɛ́chwɔ́p Táya, nɛbhʉɛt anɛ bábhɔ́ŋɔ́ nyaka bɛ́fɛ́rɛ batu. ");
INSERT INTO kenNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Sɛ́fú amɛm áchwí sɛ́kó sɛ́rɔ́k ɛtɔk. Sɛ́ghɔ́ mpay bakoŋo Yesu arɛ, sɛ́chɔ́kɔ nɛ bhɔ́ ndǔ manywɔp tándrámɔt. Ɛfóŋó Bɛdyɛrɛ akʉ bɔ baghati Pɔ̌l bɛ ákɛ́mɔ bɛrɔŋ Yerúsalɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Kɛ ndǔ ngwɛnti mpok anɛ sɛchɔkɔ nɛ bhɔ, sɛrɔ bhɔ bɛrɔŋ. Bɔ́ mankɛm, baghɔrɛ́ nɛ babhakanɛm nɛ bɔ bárɔ́k bɛ́tɨk bhɛsɛ́ kpát bágháka angɔkɔnyɛ́n. Bɛsɛ́ mankɛm sɛtɛp manɛ́n amɨk sɛ́nɨkmʉɛt, sɛ́káka batɨ. ");
INSERT INTO kenNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Sɛ́rɔ́k yɛ sɛ́chwé amɛm áchwí, bɔ bápɛtnsɛm bɛkɛt ɛbhap. ");
INSERT INTO kenNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Sɛ́rɔ́ yɛ Táya, áchwí ápɔ́kɔ bhɛsɛ kpát sɛ́gháka Tolemays. Sɛ́rɔ áchwí sɛ́kó ɛtɔk sɛ́káka bakoŋo Yesu abhɛn bachi arɛ, nɛ sɛbhak nɛ bhɔ́ ndǔ nywɔp nɛmɔt. ");
INSERT INTO kenNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Nɛ́yí nɔ́kɔ́, sɛrɔ, sɛrɔk Seséria. Ngati Ɛyɔŋ Mandɛm amɔt abhak arɛ́ anɛ aka nnyɛ́n bɛ Fílip. Abhak mmu amɔt ndǔ nkwɔ́ bo batí tándrámɔt abhɛn báyábhɛ́ nyaka Yerúsalɛm bɛ mánkwak nɔkɔ bǒnto. Sɛ́rɔ́k sɛchɔkɔ ɛkɛt ɛyi. ");
INSERT INTO kenNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Fílip abhɔ́ŋ bɔ̌baghɔsɔ́ŋ batí ánwi. Bɔ́ kɛbháy manɛm. Mandɛm áchyɛ́ nyaka bhɔ akap bɛrɛm mɛnyɨŋ ɛbhɛ́n yí afyɛ́ bɔ́ antɨ. ");
INSERT INTO kenNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ɛnɛ́ sɛ́náŋ sɛ́chí arɛ ndu mpǎy manywɔp, ndɛmɛkɛpɨ̌ntɨ Mandɛm amɔt anɛ aka nnyɛ́n bɛ Ágábɔs afú atú Judɛ́ya atwɔ arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Atwɔ́ ntá yɛsɛ asɔt mgbat anɛ Pɔ̌l agwɔ́t amɔ nɛ bɛkak ɛbhi yímbɔŋ arɛm bɛ, Ɛfóŋó Bɛdyɛrɛ arɛm bɛ, “Ɛnyunɛ́ kɛ̌ bo Israɛl bágwɔt chɔŋ mmu anɛ ábhɔ́ŋɔ́ mgbat anɛ awu Yerúsalɛm mámfyɛ yi amɔ bo abhɛn bápu bo Israɛl.” ");
INSERT INTO kenNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Sɛ́ghókó nɔ́kɔ́ ndak wu, bɛsɛ́ bho sɛ́kɔ̀ nyaka nɛ yi nɛ bǒnkwɔ abhɛn bachi Seséria sɛ́nɨ́k Pɔ̌l mmʉɛt bɛ́ ákɛ́rɔŋ Yerúsalɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Kɛ Pɔ̌l akɛmɛ chi bɛ, “Ndaká yí bǎdì ɛnyunɛ? Bǎyɛ̀m ntɨ ɛna amɛm! Mɛnká bɛ mámfyɛ mɛ ɛkɛrɛ́kɛnɔŋ, nɛ yɛ̌ chí nɛwú nká bɛgu ɛ̌ti Yesu Acha.” ");
INSERT INTO kenNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nɛ ndu sɛ́bhɨ́kɨ́ kwáy bɛkʉ yi anjibhiri ntɨ̌ ɛni, sɛ́rɔ, sɛ́rɛm bɛ, “Ɛ́mbák mbɔ ɛnyǔ mbɔŋ Mandɛm Acha áyàŋ.” ");
INSERT INTO kenNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Manywɔp ayɔ áfʉ́ɛ́rɛ́ nɔ́kɔ́, sɛ́tóŋti mɛnyɨŋ ɛbhɛsɛ, sɛ́fá sɛbho bɛrɔŋ Yerúsalɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Mbɔk bakoŋo Yesu abhɛn Seséria barɔk nɛ bhɛsɛ́ básɔ́t bhɛsɛ́ ɛkɛt Násɔn mmǔ Sáyprɔs anɛ sɛ́bhɔ́ŋɔ́ nyaka bɛ́chɔ́kɔ ɛkɛt ɛyi. Násɔn áchi nyaka mmu amɔt anɛ áyámbɨ bɛbhak nkoŋo Yesu. ");
INSERT INTO kenNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Mpok sɛ́chwɔ́bhɛ́ Yerúsalɛm batɨ bǒnkwɔ abhɛn bachi árɛ́ básɔ́t bhɛsɛ nɛ maŋák. ");
INSERT INTO kenNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Nɛ́yí nɔkɔ Pɔ̌l asɔt bhɛsɛ́ sɛ́rɔk bɛghɔ Jems. Bǒbati bǒnkwɔ bachak abhɛn Yerúsalɛm mankɛm bábhák arɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pɔ̌l akaka bhɔ́ aghati bhɔ́ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ Mandɛm ákʉ́ nɛ́ntɨ bo abhɛn bápú bo Israɛl mpok yí ákʉ̀ bɛtɨk Mandɛm nɛntɨ nap. ");
INSERT INTO kenNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Bághókó nɔ́kɔ́ mɛnyɨŋ ɛbhɛn yi arɛmɛ báchyɛ bakak ntá Mandɛm. Barɛm yɛ ntá Pɔ̌l bɛ, “Manɔ́, wɔmbɔ̌ŋ ɔghɔ ndǔ bɛyǎ nká bo Israɛl mánókó Yesu, nɛ bábhʉɛt bɛfyɛ bɛtaŋ ndu bɛbhʉɛrɛ bɛbhé Moses sayri. ");
INSERT INTO kenNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Bo Israɛl abhɛn fá Yerúsalɛm bárɛm bɛ́ ɔ̌kɔ̀ ɔ́ngati nɔkɔ bo Israɛl mankɛm abhɛn báchí amɛm bɛtɔk bɛchak bɛ mámfɛ́rɛ́ ntí ndǔ bɛbhé Moses nɛ bɛ mándɔ bɛ́syɛ́p bɔ̌bhap, nɛ bɛ mándɔ́ bɛ́kóŋo bɛpɨŋ ɛbhɛn bachǐmbɨ bhap. ");
INSERT INTO kenNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Chɔŋ sɛ́nkʉ yɛ ná? Bɔ bábhɔŋ chɔŋ bɛghok bɛ wɔ ɔtwɔ! ");
INSERT INTO kenNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ɔ́bhɔ̌ŋ yɛ bɛkʉ chi ɛnyɨŋ ɛnɛ sɛ́ghàti wɔ. Bǒ bati anwi mányiɛ mgbá nɛ Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Dɔ́k yɛ nɛ bhɔ amɛm ɛkɛrákap bɛ mǎnsó bɛsí nɛ Mandɛm, bɛtɔŋ bɛ nku yap amay. Wɔmbɔ̌ŋ chyɛ̌ nkáp anɛ bɔ bábhɔ́ŋɔ́ bɛchyɛ kɛ mǎmu bati yap. Chɔŋ ɛyɔ ɛ́nkʉ yɛ̌ntɨkɨ mmu andɨŋɨ bɛ́ mɛnyɨŋ ɛbhɛn bárɛ̀m ɛ̌ti yɛ bɛ́pú tɛtɛp, nɛ bɛ́ ɔ̌bhʉ̀rɛ bɛbhé Moses. ");
INSERT INTO kenNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Mbák chi bakoŋo Yesu abhɛn bápú bo Israɛl, sɛ́to bɔ bɛkáti ndu bɛ́gháti bhɔ́ bɛ́ bákɛ́ nyiɛ́ yɛ̌nyɨŋ ɛnɛ báchyɛ́ ntá mandɛm nsé mbɔ akap. Nɛ bɛ́ bábhɨ́kɨ́ bhɔŋ mɛ́nyiɛ́ manoŋ nɛ nnya anɛ manoŋ ami ábhɨ́kɨ́ rɔŋ amɨk, nɛ bɛ́ bǎkɛ́ fyɛ amɔ ndǔ barak ɛpúsí.” ");
INSERT INTO kenNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Nɛ́yí nɔ́kɔ́, Pɔ̌l asɔt yɛ bǒbhɔ batí anwi, bɔ́ mankɛm básó bɛsí nɛ Mandɛm. Arɔk yɛ amɛm ɛkɛrákap Mandɛm bɛkʉ bǒ batí mándɨ́ŋɨ kpoŋoroŋ nywɔp ɛnɛn nɛsǒ-bɛsí ɛnap nɛ Mandɛm nɛ́may, kɛ mánchyɛ akap ɛ̌ti yɛ̌ntɨkɨ mmu wap ndǔ nkwɔ bho bati anwi. ");
INSERT INTO kenNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Manywɔp tándrámɔt anɛ Pɔ̌l afyɛ́ árɔ́p nɔ́kɔ́ kɛkwɔt mɛmay, mbɔk bo Israɛl abhɛn bafu atú Esia bághɔ́ Pɔ̌l amɛm ɛkɛrákap Mandɛm. Mányɨ́kɨ́si batɨ̌ bo bɛ mánkɛ́m Pɔ̌l, nɛ bákɛ́m yi, ");
INSERT INTO kenNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","mámbɨk nɔkɔ bɛ, “Bo Israɛl, kwak ka bhɛsɛ́! Ghɔ́ ká mmu anɛ ákɔ̀ antɔŋ nɔkɔ bɛbɛ́ptí mɛnyɨŋ ɛ̌ti bo bhɛsɛ́ nɛ bɛbhé Moses nɛ ɛ̌ti ɛkɛrákap Mandɛm ɛnɛ. Akʉ kpát nɛ́nɛ asɔt bǒ abhɛn bápú bo Israɛl achwe fá amɛm ɛkɛrákap ɛnɛ nɛ bhɔ. Anyɔ̌p Ɛkɛt Mandɛm nɛ ɛ́pɛt ɛpu ɛkɛrɛ́ bɛdyɛrɛ!” ");
INSERT INTO kenNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Bárɛ̀m nyaka ɛnyuyɔ mbɔnyunɛ mǎnáŋ nyaka bághɔ̌ Pɔ̌l nɛ Trofimɔs mmu Ɛ́fɛsɔs, amɛm ɛtɔk. Ɛkʉ basɔt bɛ Pɔ̌l achwe amɛm ɛkɛrákap nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ɛbyɔk ɛ́kwɛ́n yɛ ɛtɔk ɛnkɛm nɛ bo babho bɛjɛt mándɔkɔ nɔkɔ ndǔ ɛkɛrákap. Bákɛ́m Pɔ̌l baya gbaka gbaka gbaka báfú nɛ yi batɨŋ batiɛp babhǐnywɔp ɛkɛrákap. ");
INSERT INTO kenNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Nɛ ndu báyàŋ bɛway Pɔ̌l, ɛyɔŋ ɛ́rɔ́k ntá mǔngo batɛmɛ́ nɛnu Rom bɛ, ɛbyɔk ɛ́kwɛn amɛm ɛtɔk Yerúsalɛm ɛnkɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Tɛ́mté wu, asɔt batɛmɛ́ nɛnu nɛ mbɔk bǒbati bhap básɛ́p barɔk arɛ. Bo bághɔ́ nɔ́kɔ́ yí ndǔ átwɔ̀ nɛ batɛmɛ́ nɛnu, bábhɔ́t bɛdɛn Pɔ̌l. ");
INSERT INTO kenNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Mǔngo batɛmɛ́ nɛnu akɛ́m yi nɛ achyɛ ɛyɔŋ bɛ́ mámfé yi nɛ ngɛm ɛpay. Abhɛ́p bhɔ bɛ, “Mmǔ-nɛ chi agha? Akʉ yi?” ");
INSERT INTO kenNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Bǒbhɔ bábho bɛbɨk mandɛm nɔkɔ mɛnyɨŋ kɛkuri kɛkuri ɛnyu ɛnɛ́ mbɔk bárɛ̀m ɛyap ɛnyu, báchák mándɛm nɔkɔ ɛyap. Ɛbyɔk ɛyɔ ɛ́kʉ mǔngo batɛmɛ́ nɛnu kɛ́kɛm ntí nɛ nnɛt ndǔ ndak anɛ áfákárí. Aghati bǒbhi bɛ́ mansɔt Pɔ̌l mandɔk mamfyɛ amɛm ɛbhǎ batɛmɛ́ nɛnu. ");
INSERT INTO kenNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ágháká nɔ́kɔ́ ndu nkɔ́k anɛ bɛ́chwe anywɔ́p, batɛmɛ́ nɛnu bápɔ́kɔ yi ndǔ bághɔ́ bɛ́ bɛyǎ bo abhɛn bachi arɛ babho bɛ́twɔ nɛ baraká bɛtaŋ. ");
INSERT INTO kenNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Bɛyǎ bǒbhɔ báre koŋo yi mándɛm nɔkɔ bɛ, “Wáy ka yi!” ");
INSERT INTO kenNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ndu ɛ́rɔ́bhɛ́ kɛ́kwɔ́t bɛ batɛmɛ́ nɛnu manchwe amɛm ɛbha, Pɔ̌l abhɛ́p mǔngo wu bɛ, “Ɛ́tá, chɔŋ ɔ́nka bɛ́ ngátí wɔ, ndak-a?” Mǔngo wu aghok nɔkɔ ndǔ yi árɛ̀m chi Grik, abhɛ́p yi bɛ, “Ɔrɨ́ŋɨ́ ɛyɔŋɔ́ Grik-ɛ? ");
INSERT INTO kenNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Pú wɔ́ ɔ́chí mmu Íjip? Pú wɔ kɛ ɔkʉ bo bágʉɛ́bhɛ́ ɛsɔŋɔri ɛtɔk nɛ ɔkʉ bawǎy bho nka ɛnwi bárɔ́k nɛ wɔ amɛm baso?” ");
INSERT INTO kenNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pɔ̌l akɛmɛ yi bɛ, “Puyɛ̌ mɛ. Nchí mmu Israɛl, mmɔ̌ ɛtɔk Tásɔs, ɛtɔk ɛgho ɛnɛ ɛbhɔŋɔ mɛnwɔp atú Silísha. Nnɨkmʉɛt, chyɛ mɛ ɛpok ndɛm kɛpɨ ntá bo abhɛn.” ");
INSERT INTO kenNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Mǔngo wu akaa. Pɔ̌l ate yɛ ndǔ nkɔ́k anɛ bɛchwe anywɔ́p asá awɔ amfay bɛ bo mánkwɛn kpák. Bákwɛ́n nɔ́kɔ́ kpák, abho yɛ bɛrɛm kɛpɨ nɛ bhɔ ndǔ Híbru, ɛyɔŋɔ́tɔk ɛyap. ");
INSERT INTO kenNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Pɔ̌l arɛm bɛ, “Bɔtá nɛ bɔmá, Tá ká batú mǎngok ɛnyɨŋ ɛnɛ́ mbɔ́ŋɔ́ bɛrɛm ndu bɛ́táŋa mmʉɛt bɛsí ɛbhɛka.” ");
INSERT INTO kenNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Bɔ́ bághók ndǔ yi árɛ̀m chí ɛyɔŋ bo Israɛl. Mbǎŋ akwɛn chák. Pɔ̌l arɔk yɛ ambɨ bɛrɛm bɛ, ");
INSERT INTO kenNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Mɛ, nchí mmu Israɛl. Nchí mmɔ́ Tásɔs atú Silísha, kɛ ngo chí fá Yerúsalɛm amɔ ntɔŋ ngo ywɛsɛ, Gamáliɛl. Ngɔk ɛkáti chi antɛn ɛyi. Atɔ́ŋ mɛ bɛkoŋo bɛbhé bachǐmbɨ bhɛsɛ́ mbɔ ɛnyǔ ɛ́bhɔ́ŋɔ́ bɛ́bhak nɛ nchyɛ́ mmʉɛt bɛkoŋo Mandɛm mbɔ be mankɛm abhɛn bǎchí fá ɛchɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nchí chyɛ nyaka nɛnyok ntá bo abhɛn bákòŋo Mbi Yesu wu kpát mbɔk mángu nɔkɔ, nɛ ńkɛ́mti nɔkɔ baghɔrɛ́ nɛ babhakanɛm mámfyɛ nɔkɔ bhɔ́ ɛkɛrɛ́kɛnɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Mǔngo bachiǎkap nɛ bǒ ɛchɛmɛ́ bǒ batí ɛtɔk bákwày bɛ́te mɛ ntísiɛ bɛ́ nchí kʉ nyaka ɛnyu yɔ. Ntá yap kɛ nchi nsɔt nyaka bɛkáti ndu bɛrɔŋ ntá batɨ̌ bo Israɛl abhɛn Damáskɔs. Mbɔ̌ŋ bɛtaŋ bɛ́kɛ́mti bakoŋo Yesu arɛ́ bɛ mpɛ́tnsɛm Yerúsalɛm nɛ bhɔ́ mánchyɛ́ bɔ́ ntɛ́msí. ");
INSERT INTO kenNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Ndǔ nchí rɔŋ, ngáká nɔ́kɔ́ kɛ́kwɔ́t ɛtɔk Damáskɔs, mbɔ nkárɛ́nká byó nɛ ɛpay nɛ ngósí, ɛtaŋtí bɛdiɛ́rɛ́ bɛ́fú amfay tɛ́mchok bɛ́kwɛ́n bɛkap mɛ, mbaŋ aghɔ tontó. ");
INSERT INTO kenNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ɛ́kʉ́ nkwɛ́n amɨk ngók ɛyɔŋ ndǔ ɛ́rɛ̀m ntá ya bɛ, ‘Sɔ̌l! Sɔ̌l! Ɔ́chyɛ̀ mɛ nɛnyok ndaká yí?’ ");
INSERT INTO kenNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nkɛmɛ bɛ, ‘Acha chí wɔ agha?’ Ɛyɔŋ ɛ́kɛ́mɛ bɛ, ‘Chí mɛ Yesu Mmu Násárɛt kɛ ɔ́chyɛ̀ nɛnyok.’ ");
INSERT INTO kenNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Bǒ abhɛn nkɔ́ nɛ bhɔ́ bághɔ́ nkwɔ bɛdiɛ́rɛ́ ɛbhɔ kɛ bákɛ ghók ɛyɔŋɔ́ mmu anɛ árɛ̀m kɛpɨ nɛ mɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ngók nɔ́kɔ́ ɛnyɨŋ ɛnɛ́ ɛyɔŋ ɛyɔ ɛ́ghàti mɛ, ndɛm bɛ, ‘Acha, ɔ̌yàŋ mɛ nkʉ yi?’ Acha arɛm ntá yá bɛ, ‘Faté dɔ́k Damáskɔs. Arɛ́, chɔŋ mángátí wɔ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ́ Mandɛm áyábhɛ bɛ ɔbhɔŋ bɛkʉ.’ ");
INSERT INTO kenNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ɛtaŋtí bɛdiɛ́rɛ́ ɛbhɔ bɛ́kʉ́ nkɛpɛrɛ kwáy bɛghɔ mbaŋ. Bǒ nkɔ́ nɛ bhɔ́ bárɔ́bhɛ́ kɛm mɛ chí ndǔ awɔ́ kpátɛ sɛ́gháka Damáskɔs. ");
INSERT INTO kenNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Mmu amɔt abhak Damáskɔs anɛ áká nnyɛ́n bɛ́ Ananías. Abhak mmu anɛ ákòŋo Mandɛm sayri, mmu anɛ ábhʉ̀rɛ bɛbhé ɛbhɛsɛ́ bo Israɛl, nɛ mmu bo Israɛl mankɛm abhɛn báchí arɛ́ báchyɛ̀ kɛnókó. ");
INSERT INTO kenNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ananías atwɔ́ ntá ya, ate mɛ nɛ́kú mmʉɛt arɛm bɛ, ‘Manɔ́ wa Sɔ̌l, pɛt bo bɛghɔ mbaŋ.’ Tɛ́mté wu amɨ́k ánɛ́nɛ mɛ mpɛt mbo bɛ́ghɔ mbaŋ. Ngɔ́ yɛ́ yi. ");
INSERT INTO kenNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Arɛm ntá ya bɛ, ‘Mandɛm bachǐmbɨ bhɛsɛ́ ayap wɔ bɛ́ ɔ́ndɨ́ŋɨ́ ɛnyɨŋ ɛnɛ yi atɨ bɛkʉ. Ayap wɔ bɛ ɔ́ngɔ́ anɛ babhɨŋɨ bɛ Mmu Chak. Ayap wɔ bɛ ɔ́ngɔ́k ɛnyɨŋ ɛnɛ ɛ́fù yi anyu. ");
INSERT INTO kenNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ayap wɔ nɛ ntí bɛ́ chɔŋ ɔ́mbak ntísiɛ aywi ndu bɛ́gháti yɛ̌ntɨkɨ mmu mɛnyɨŋ ɛbhɛ́n ɔ́ghɔ́ nɛ ɛbhɛn ɔghoko. ");
INSERT INTO kenNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ɔ́kɛ́pɛrɛ chɔŋti yɛ mpok. Faté mánjwítí wɔ, ɔ́ndɔ Mandɛm anso bɛbʉ́ bhɛ, ɔmbɨŋɨ nɔkɔ nnyɛ́n Acha.’ ");
INSERT INTO kenNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Mpɛt nɔ́kɔ́ nsɛm Yerúsalɛm, ɛwak ɛ́mɔ́t ndǔ nchí nɨkmʉɛt amɛm ɛkɛrákap, ngɔ́ kɛnɔ́ amɨ́k antifu. ");
INSERT INTO kenNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ngɔ́ Yesu Acha téé ndǔ ághàti mɛ bɛ, ‘Kʉ ayak dɔ̌ Yerúsalɛm. Bǒ abhɛn fá bápú noko chɔŋ ɛnyɨŋ ɛnɛ ɔ́ghàti bhɔ́ ɛ̌ti ya.’ ");
INSERT INTO kenNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nkɛmɛ yi bɛ, ‘Acha, bɔ́ babhɔŋ bárɨ́ŋɨ sayri bɛ nchí rɔ́ŋ nyaka yɛ̌ntɨkɨ ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí bo Israɛl nkʉ nɔkɔ bɛ mánkɛ́mtí bo abhɛn mánóko wɔ, nɛ mandɛn, mámfyɛ nɔkɔ mbɔk yap ɛkɛrɛ́kɛnɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Nɛ mpok báwày Stífin ntísiɛ aywɛ, mbak arɛ́ nkwɔ téé, mbabhɛri nɔkɔ ndɛn bo abhɛn bátɛ́mtí yí nɛ batay baway. Nka bɛ́ mángwáy yi.’ ");
INSERT INTO kenNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Kɛ Acha aghati mɛ bɛ, ‘Fǎ Yerúsalɛm dɔ́k mbɔ ɛnyǔ ngátí wɔ. Dɔ́k mbɔnyunɛ nchí tó wɔ nɛkɔ nɛsiɛ ntá bo abhɛn bápú bo Israɛl.’” ");
INSERT INTO kenNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ndǔ Pɔ̌l árɛ̀m mɛnyɨŋ ɛbhɛn bɛyǎ bo abhɛn bachi arɛ́ bátá batú mángoko nɔkɔ sayri. Kɛ nɛtaka yí átáká bo Israɛl bɛyǎ bǒbhɔ bábho bɛbɨk nɛ ɛyɔŋ ɛtaŋataŋ bɛ, “Naŋá ká yí, apú mmú ábhák nɛpɛ́m.” ");
INSERT INTO kenNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ndǔ bábɨ̀k, bábhó bɛfok ndɛn ɛyap nkwɔ nɛ báre toko mfok mántak nɔkɔ amfay. ");
INSERT INTO kenNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Mmǔ ntí batɛmɛ́ nɛnu Rom ághɔ́ nɔ́kɔ́ nɔ achyɛ ɛyɔŋ bɛ batɛmɛ́ nɛnu mansɔt Pɔ̌l manchwe nɛ yí amɛm ɛbhá ɛyap. Aghati bɔ mandɛn yi nɛ ɛ́kpá bɛkʉ yí ángátí bhɔ́ ɛnyɨŋ ɛnɛ yí akʉ́ kɛ bo Israɛl báré bé ntɨ nɛ yí kpát mámbɨkɨ nɔkɔ ɛnyuyɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Bágwɔ́t nɔ́kɔ́ yí ndu bɛdɛn, Pɔ̌l abhɛ́p mǔnti batɛmɛ́ nɛnu amɔt anɛ achi arɛ tee bɛ, “Ɛbhé ɛ́chyɛ́ wɔ bɛtaŋ bɛ́ ɔ́ndɛ́m mándɛ́n mmu Rom ɛnɛ bábhɨkɨ re yɨŋɨ mbɔ̌ŋ manyé ayi mángɔ́ bɛ́ akʉ ɛnyɨŋɨ́?” ");
INSERT INTO kenNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Mǔnti batɛmɛ́ nɛnu wu ághókó nɔ́kɔ́ nɔ́ afa arɔk ntá mǔngo batɛmɛ́ nɛnu arɛm bɛ, “Ɔ́yàŋ bɛkʉ nɔ yi? Mmǔ-nɛ abhɔŋ bɛtaŋ mbɔ mmu Rom. Ɔbhɛ́ mándɛ́n yí?” ");
INSERT INTO kenNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Mǔngo batɛmɛ́ nɛnu ághókó nɔ́kɔ́ nɔ, arɔk abhɛp Pɔ̌l bɛ, “Ghatí mɛ́, ɔchí mmu Rom tɛtɛbhɛ?” Pɔ̌l aka bɛ, “Nchí mmu Rom.” ");
INSERT INTO kenNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Mǔnti batɛmɛ́ nɛnu wu arɛm ntá Pɔ̌l bɛ, “Nchɔ́ŋtí bɛyǎ nkáp kɛ báchyɛ́ mɛ bɛtaŋ mbɔ mmu Rom”, Pɔ̌l akɛmɛ yí bɛ, “Kɛ mɛ Pɔ̌l nchí mmu Rom tɛ nɛbhě ɛna.” ");
INSERT INTO kenNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ɛ́kʉ́ batɛmɛ́ nɛnu abhɛn bábhɔ́ŋ bɛbhɛp yí mɛnyɨŋ báfɛ́rɛ yi amɔ tɛ́mté, bɔ́ kɛpɛrɛ bhɛ́p yi yɛ̌nyɨŋ. Bɛcháy bɛ́kɛ́m mǔngo batɛmɛ́ nɛnu nkwɔ́ mpok yí árɨ́ŋɨ́ bɛ́ Pɔ̌l mmu yí ákʉ́ bákɛ́mɛ́ báfyɛ́ ngɛm amɔ chí mmu Rom. ");
INSERT INTO kenNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Mǔngo batɛmɛ́ nɛnu are yáŋ bɛ́rɨŋɨ mbɔ̌ŋ ɛnyɨŋ ɛnɛ bo Israɛl bárɛ̀m bɛ́ Pɔ̌l akʉ. Nɛ́yí nɔ́kɔ́, arɛm yɛ bɛ mámfɛ́rɛ́ Pɔ̌l ngɛm amɔ. Achyɛ ɛyɔŋ bɛ́ bǒbatí bachiǎkap nɛ bǒbatí ɛtɔk mankɛm mánchɔ́kɔ́ mánjɨ́ŋɨ́ ndaká Pɔ̌l. Báchɔ́kɔ́ nɔ́kɔ́ achyɛ ɛyɔŋ básɔt Pɔ̌l bakʉ yi ate bɛsí bhap. ");
INSERT INTO kenNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pɔ̌l atɛp bɔ́ amɨ́k amʉɛt arɛm bɛ, “Bɔ̌ma, mpoknkɛm anɛ nchí bɛsí Mandɛm nɛ kpatɛ̌ ɛchɔŋ ntɨ ɛna nɛchi amɛm pɛ́pɛ́p.” ");
INSERT INTO kenNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Mpok yi arɛmɛ nɔ, Ananías mǔngo bachiǎkap Mandɛm, achyɛ ɛyɔŋ bɛ bo abhɛn bachi kɛkwɔt nɛ Pɔ̌l mándɛp nnyu yi. ");
INSERT INTO kenNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pɔ̌l arɛm bɛ, “Wɔ ɛbhɔ́kɔ́rí nkok anɛ bawati nɛ mbɨ pɛ́pɛ́p bɛ bo bǎkɛ́ rɨŋɨ! Chɔŋ Mandɛm andɛp wɔ. Ɔchɔ́kɔ́ afɔ bɛ́sɔt ɛbhé ɔ́ntaŋ mɛ, nɛ ɔ̌rɛ̀m bɛ mándɛp mɛ ɛnɛ́ ɛbhé ɛbhɨkɨ chyɛ wɔ bɛtaŋ ɛbhɔ̌? .” ");
INSERT INTO kenNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Bo abhɛn báté kɛ́kwɔ́t nɛ Pɔ̌l bábhɛp yi bɛ, “Ɔ̌sɔkɔti mǔngo bachiǎkap Mandɛm-ɛ?” ");
INSERT INTO kenNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pɔ̌l akɛmɛ bɛ, “Bɔ̌ma, mbɨ́kɨ́ rɨŋɨ mbʉ bɛ chi mǔngo bachiǎkap. Ɛkáti Mandɛm ɛ́rɛ̀m bɛ, ‘Ɔ́kɛ́rɛm ɛbʉ́bʉ ɛ̌ti mǔnti bǒbhɛ.’” ");
INSERT INTO kenNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pɔ̌l aghɔ nɔkɔ bɛ mbɔk bǒ bati bhɔ bachi chí bǒnkwɔ Sádusi nɛ bɛ báchak babhak bǒnkwɔ Fárisi, abɨk bɛsí bǒ ɛchɛmɛ arɛm bɛ, “Bɔ̌ma, nchí mǔnkwɔ Fárisi nɛ mmɔ̌ bǒnkwɔ Fárisi. Nté fá acha manyé chí ndu nnókó bɛ́ chɔŋ Mandɛm ankʉ bawú mámpɛtnsɛm ndu nɛpɛ́m.” ");
INSERT INTO kenNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Arɛm nɔkɔ nɔ, ɛpʉ́ítí ɛ́kwɛ́n nɛ́ntɨ bǒnkwɔ Fárisi nɛ bǒnkwɔ Sádusi nɛ ɛchɛmɛ ɛ́kɔ́rɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Ɛ́fákárí nyaka ɛnyu yɔ mbɔnyunɛ bǒnkwɔ Sádusi bárɛ̀m bɛ bawú bápú kway bɛpɛtnsɛm ndǔ nɛpɛ́m, nɛ bɛ bɔángɛl bápú, nɛ yɛ̌nyɨŋ ɛpu ɛnɛ bábhɨ̀ŋɨ bɛ bɛfoŋɔ. Kɛ bǒnkwɔ Fárisi mánoko bɛ chɔŋ bawú mámpɛtnsɛm ndǔ nɛpɛ́m, nɛ bɛ bɔángɛl bachi nɛ bɛfóŋó nkwɔ bɛchi. ");
INSERT INTO kenNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ɛrɛmɛ́ ɛbyɔk ɛ́kwɛ́n, mbɔk batɔŋ ɛbhé Mandɛm abhɛn báchí bǒnkwɔ Fárisi báfáte báre rɛm nɛ ɛyɔŋ ɛtaŋataŋ bɛ, “Sɛ́bhɨ́kɨ́ ghɔ́ yɛ̌ ɛbɛ́ptí ɛnyɨŋ ɛnɛ mmǔ-nɛ ákʉ́. Ngufú ɛfóŋó kɛ ɛ́ghátí yi ɛnyɨŋ nɛ ngufu ángɛl kɛ árɛ́mɛ́ kɛpɨ nɛ yi!” ");
INSERT INTO kenNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Bɛ́táŋá bɛ́yá bɛ́chá, ɛrɔp chi bɛ́kɛm batɨ nɛ amɔ. Ɛkʉ mǔngo batɛmɛ́ nɛnu abhɔ́ŋ bɛcháy bɛ bákway bɛdakati Pɔ̌l. Achyɛ yɛ ɛyɔŋ bɛ batɛmɛ́ nɛnu bhi mánsɛp mámfɔ́ŋɔ́ Pɔ̌l ntá bǒbhɔ mándɔk amɛm ɛbhá batɛmɛ́ nɛnu nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ɛ́gháká nɔ́kɔ́ nɛ bɛti Yesu Acha atwɔ́ ate nɛpakámʉɛt Pɔ̌l arɛm ntá yi bɛ, “Ɔ́kɛ́ chay! Nkúbhɛ́ mbɔ ɛnyu ɔ́rɛ́mɛ́ ɛ̌ti ɛya fá Yerúsalɛm, ɔbhɔŋ bɛ́kʉ ɛnyuyɔ amɛm ɛtɔk Rom nkwɔ́.” ");
INSERT INTO kenNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Nɛ́yi nɔ́kɔ́, mbɔk bo Israɛl bákɛ́m ɛchɛmɛ báte ɛyu bɛway Pɔ̌l. Mányú nku bɛ bapu nyiɛ nɛnyiɛ nɛ yɛ̌nyɨŋ bápú nyu kpátɛ mangway yi. ");
INSERT INTO kenNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Mpǎy bo abhɛn mányú nku yɔ báchá bɛsa bɛ́pay. ");
INSERT INTO kenNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Barɔk ntá bǒbatí bachiǎkap Mandɛm nɛ bǒbati ɛtɔk baghati bhɔ bɛ, “Sɛ́nyǔ nku, sɛ́yɨ́kɨ́ mmʉɛt bɛ́ sɛ́pú nyiɛ́ nɛ sɛ́pú nyú yɛ̌nyɨŋ tɛ sɛ́ngway Pɔ̌l. ");
INSERT INTO kenNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Bě nɛ nkwɔ Ɛchɛmɛ́ bǒ batí ɛtɔk tó yɛ ka ɛyɔŋ ntá mǔngo batɛmɛ́ nɛnu bɛ́ ántó Pɔ̌l ntá yɛka mbɔ bɛ bǎyàŋ bɛghok ɛyɔŋɔ́ manyé ɛyi sayri. Mbák ɛ́mfákárí nɔ́, chɔŋ sɛ́ngway yi ambi.” ");
INSERT INTO kenNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Mmǔfu aghók ɛ̌ti nɛkatínɛt ɛnɔ. Abhak mmɔ̌ manɔ Pɔ̌l. Afa arɔk amɛm ɛbhǎ batɛmɛ́ nɛnu aghati Pɔ̌l. ");
INSERT INTO kenNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pɔ̌l abhɨŋɨ mǔnti batɛmɛ́ nɛnu amɔt aghati yí bɛ, “Sɔt ɛsakámu anɛ́ dɔ́k ntá mǔngo nɛ yí. Abhɔŋ ɛnyɨŋ bɛ́gháti yi.” ");
INSERT INTO kenNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Mǔnti wu asɔt yí arɔk ntá mǔngo wap arɛm bɛ, “Pɔ̌l mǔkɛnɔŋ abhɨ́ŋɨ́ mɛ arɛm bɛ́ nsɔt ɛsakámu anɛ́ ntwɔ́ ntá yɛ nɛ yí mbɔnyunɛ abhɔŋ ɛnyɨŋ bɛ́gháti wɔ.” ");
INSERT INTO kenNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Mǔngo batɛmɛ́ nɛnu akɛ́m yí ndu awɔ́ aya bárɔk ansɛm, abhɛ́p yí ansɛm ansɛm bɛ, “Ntɨkɨ ndak ɔ́yàŋ bɛghati mɛ?” ");
INSERT INTO kenNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Akɛmɛ yí bɛ, “Bǒbatí bo Israɛl báte ɛyu bɛ mángáti wɔ ɔ́nsɔt Pɔ̌l ɔnsɛp nɛ yí ndu ɛchɛmɛ́ bataŋá manyé ɛgho mburɛ mbɔ bɛ báyàŋ chí bɛ́rɨŋɨ ndaka ywi sayri. ");
INSERT INTO kenNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Kɛ kɛ́ka nɛ bhɔ́. Bǒ bhap bábhɛ́sɛ́ ambi mánòŋ bɛ mankɛm yí mangway. Bácha batí bɛsa bɛpay. Nɛ mányǔ nku bɛ́ yɛ̌nyɨŋ bápú nyiɛ nɛ yɛ̌nyɨŋ bápú nyú kpátɛ mángwáy yí. Mánaŋ batoŋti mmʉɛt, barɔbhɛ noŋ chí bɛ́ ɔ́ntó Pɔ̌l antwɔ.” ");
INSERT INTO kenNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Mǔngo batɛmɛ́ nɛnu aya yí batú bɛ, “Dɔ́k, kɛ kɛ́kʉ yɛ̌ mmu andɨ́ŋɨ́ bɛ́ ɔghátí mɛ ndak anɛ.” ");
INSERT INTO kenNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Mǔngo batɛmɛ́ nɛnu abhɨŋɨ yɛ bǒ batí batɛmɛ́ nɛnu bhi bapay aghati bhɔ bɛ, “Sɔt ka batɛmɛ́ nɛnu batí bɛsa byo, bǒ batí bɛsa bɛ́rát nsɛm byo abhɛn bákɔ̀ nɛ mpɔŋɔ́ndɨ́k, nɛ batɛmɛ́ bakɔŋ bɛsa byó. Toŋtí ká mmʉɛt bɛ́sɔt Pɔ̌l ndu nkarɛnka nɛ́nɛnamɔt beti ɛbhɛn ɛchɔŋ, mǎndɔ́k Seséria nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Chiɛ̌ mpɔŋɔ́ndɨ́k ɛnɛ Pɔ̌l ákɔ̀ nɛ yɔ́. Nɛ kʉ Pɔ̌l ánchwɔ́p dok ntá gɔ́bhanɔ Fɛ́liks ɛnɛ́ yɛ̌nyɨŋ ɛbhɨkɨ fakari nɛ yi.” ");
INSERT INTO kenNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Árɛ́m nɔ́kɔ́ nɔ́, asɨ́ŋ ɛkáti ɛnɛ́ ɛ́rɛ̀m bɛ, ");
INSERT INTO kenNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Mɛ Klaudiɔs Lísias kɛ nchí sɨŋ ɛkáti ɛnɛ ntá Ɛta yɛsɛ gɔ́bhanɔ Fɛ́liks. Ɛta, nchí to wɔ bakak. ");
INSERT INTO kenNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Bo Israɛl bakɛm mmu wu báre yáŋ bɛway yi. Ngók nɔ́kɔ́ bɛ́ yi abhɔ̌ŋ bɛtaŋ ɛtɔk Rom mbɔ mɔ̌mɨk, nsɔt batɛmɛ́ nɛnu bha ndɔk mfɛ́rɛ́ yi amɔ́ yap. ");
INSERT INTO kenNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nsɔt yí ndɔk ndu áchá manyé agho wap bɛ́rɨŋɨ ndak anɛ yí akʉ. ");
INSERT INTO kenNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Arɛ́, ngɔ́ bɛ́ abhɨkɨ kʉ yɛ̌nyɨŋ ɛnɛ́ ɛ́yàŋ bɛ mángwáy yí, nɛ yɛ̌ chi ɛnɛ ɛ́kʉ̀ mámfyɛ yi amɛm ɛkɛrɛ́kɛnɔŋ. Báre rɛm chi barak anɛ ayɨ́ŋɨ́ bɛbhé bhap. ");
INSERT INTO kenNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Nɛ mmǔfu ághátí nɔ́kɔ́ mɛ ansɛm ansɛm bɛ́ bo Israɛl báte ɛyu bɛway yi, tɛ́mté wu ndɛm bɛ́ mbɔŋ bɛto yi ntá yɛ. Ngátí bo abhɛn bábhárɛ́ yí ndak amʉɛt bɛ mántwɔ́ ntá yɛ mangati wɔ ndak anɛ yi ákʉ́.” ");
INSERT INTO kenNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Batɛmɛ́ nɛnu bákʉ mbɔ ɛnyu mǔngo wap ághátí bhɔ́. Básɔ́t Pɔ̌l bɛtǐ bhɔ bárɔk nɛ yi kpát bágháka Antipatris. ");
INSERT INTO kenNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Nɛ́yí nɔ́kɔ́, batɛmɛ́ nɛnu abhɛn bákɔ́ chi nɛ bɛkak bápɛtnsɛm amɛm ɛbhá. Bárɔ́ abhɛn bákɔ̀ amfay mpɔŋɔ́ndɨ́k mándɔ́k Seséria nɛ Pɔ̌l. ");
INSERT INTO kenNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Bágháká nɔ́kɔ́ Seséria, báchyɛ ɛkáti ntá gɔ́bhanɔ, bárɔ Pɔ̌l amɔ yi. ");
INSERT INTO kenNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ápáy nɔ́kɔ́ ɛkáti yɔ, abhɛp Pɔ̌l bɛ, “Ayɛ̌ atú ɛtɔk chi anɛ?” Pɔ̌l akɛmɛ yí bɛ, “Silísha.” Ághókó nɔ́kɔ́ nɔ, ");
INSERT INTO kenNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","arɛm ntá Pɔ̌l bɛ, “Bo abhɛn bábhɔ́ŋɔ́ ndak nɛ wɔ mǎnáŋ mántwɔ́, chɔŋ ngók nnyé ɛnɛ.” Achyɛ yɛ ɛyɔŋ bɛ́ mámfyɛ́ yi anywɔ́p amɛm áchá anɛ gɔ́bhanɔ, mámbahɛri nɔkɔ yi. Áchá wu chi anɛ Hɛ́rɔd áté nyaka. ");
INSERT INTO kenNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ɛ́fʉɛ́rɛ́ nɔ́kɔ́ manywɔp átay, mǔngo bachiǎkap Mandɛm anɛ áká nnyɛ́n bɛ́ Ananías asɛp arɔk Siséria nɛ mbɔk bǒbatí ɛtɔk, nɛ ntaŋanyu amɔt anɛ áká nnyɛ́n bɛ́ Tɛtúlɔs. Báchwɔ́bhɛ́ nɔ́kɔ́ bɛsí gɔ́bhanɔ Fɛ́liks, babho bɛbhat Pɔ̌l barak amʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Bábhɨ́ŋɨ́ Pɔ̌l, achwe anywɔ́p. Tɛtúlɔs abho bɛ́rɛ́m ɛ̌ti yi ntá gɔ́bhanɔ bɛ, “Ɛta! Ɛ̌ti yɛ kpák achi fá ɛtɔk ɛyɛsɛ ndǔ ɛrɔ́ri mpok, nɛ ɛ̌ti nɛkʉ ywɛ anɛ ndɨ́ndɨ́, ɛgúpsí ɛ́chí ɛtɔk. ");
INSERT INTO kenNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ɛnyu ɛnɛ́ ɔ́kʉ̀ mɛnyɨŋ ɛbhɛn nɛ yɛ̌ntɨkɨ ɛbhak ɛnɛ́ ɔ́kʉ̀ bhɔ́, sɛ́ka bhɔ nɛ sɛ́kàka wɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Mbɨ́kɨ́ yaŋ bɛ́chɔ́ŋti mpok ayɛ tontó, nchí nɨk chi mmʉɛt bɛ ɔ́nsɛ́bhɛ́ ntɨ ɛnɛ́ amɨk ɔ́ngɔ́k mbɨŋɨ́ ndak anɛ́ sɛ́bhɔ́ŋɔ́ bɛghati wɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Sɛ́ghɔ bɛ́ mmǔ-nɛ chí nchyɛ ɛsɔŋɔri anɛ tɔ́ŋ sɛ́ngɔ́ nɛ nyɔŋ-ndak ndǔ nkwɔ bo Israɛl mbaŋ ɛnkɛm. Achí nkwɔ́ mǔnti ndǔ ɛká bho abhɛn bábhɨŋɨ bɛ bo Násárɛt. ");
INSERT INTO kenNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Akʉ kpát are yáŋ bɛgʉɛp ɛbyɔk amɛm ɛkɛrákap awu Yerúsalɛm, kɛ sɛ́kɛ́m nɔ́ yi. Mbʉ́ sɛ́taŋ yi bɛkoŋo ɛbhé, ");
INSERT INTO kenNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","kɛ Lísias mǔngo batɛmɛ́ nɛnu atwɔ́ afɔŋɔ yí amɔ yɛsɛ nɛ bɛtaŋ, ");
INSERT INTO kenNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","yí bɛ́ bo abhɛn bábhɔ́ŋɔ́ ndak nɛ yi mántwɔ́ ntá yɛ. Mbák wɔmbɔŋ ɔ́ndɛ́m kɛpɨ nɛ yi, chɔŋ ɔ́ndɨŋɨ bɛ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ sɛ́rɛ̀m bɛ yi ákʉ́ ɛchí tɛtɛp.” ");
INSERT INTO kenNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Tɛtúlɔs árɛ́m nɔ́kɔ́ nɔ́, bo Israɛl báchɛ́m nɛ yí báká bɛ yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ yi árɛ́mɛ́ bɛ́ Pɔ̌l ákʉ́ ɛchi tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Gɔ́bhanɔ atɔ́ŋ yɛ nɛ awɔ bɛ Pɔ̌l andɛm kɛpɨ. Pɔ̌l abho bɛrɛm bɛ, “Ngɔ bɛ́ ɔnáŋ ɔtaŋ manyé amɛm ɛtɔk ɛnɛ ndǔ bɛyǎ mamiɛ, nɛ mbɔ̌ŋ maŋák bɛ́táŋa mmʉɛ́t bɛsí bhɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Mbák ɔ́mbɛ́p, chɔŋ wɔmbɔŋ ɔ́ndɨŋɨ bɛ ɛbhɨ́kɨ́ cha manywɔp byo nɛ apay ɛnɛ́ ndɔ́ŋɔ́ Yerúsalɛm ndu bɛchyɛ Mandɛm kɛnókó. ");
INSERT INTO kenNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Nɛ bo Israɛl bábhɨkɨ ghɔ́ mɛ ndǔ nchí kɛm ɛpʉ́ítí nɛ yɛ̌ mmu amɛm ɛkɛrákap Mandɛm, bábhɨ́kɨ́ ghɔ mɛ ndǔ nchí nyɨkɨsi batɨ̌-bho bɛ mánchyɛ ɛsɔŋɔri amɛm ɛkɛrɛ́ nɛnɨkɨ́mʉɛtí nɛ yɛ̌ chí ndǔ nɛbhʉɛt achak amɛm ɛtɔk. ");
INSERT INTO kenNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Nɛ bápú kwáy bɛtɔŋ kpoŋoroŋ bɛ́ nkʉ mɛnyɨŋ ɛbhɛ́n bábhàt nɛ́ mɛ amʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Kɛ nká ɛnyɨŋ ɛ́mɔ́t bɛsí bhɛ kpoŋoroŋ. Nchí koŋo Mbi anɛ́ bo Israɛl bárɛ̀m bɛ abhɔŋ bɛkwɛ́nɛ́ ndu nchí nɨkmʉɛt nchyɛ́ nɔkɔ kɛnókó ntá Mandɛm bachǐmbɨ abhɛsɛ. Nɛ nnókó yɛ̌ntɨkɨ ɛnyɨŋ ɛnɛ bɛbhé Moses bɛ́yàŋ sɛnkʉ nɛ yɛ̌ chí ɛbhɛn bɛchi amɛm basɨŋɨ́ barɛmɛ́ kɛpɨ̌ntɨ. ");
INSERT INTO kenNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Mbákántɨ nɛ Mandɛm ɛnyumɔ́t mbɔ bhɔ́, bɛ́ ɛwak ɛ́mɔt chɔŋ yí ankʉ bawú mankɛm abhɛn báchí chak bɛsí bhi nɛ abhɛn bapu mámpɛtnsɛm ndǔ nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ɛ̌ti yɔ kɛ nchí kʉ yɛ̌ntɨkɨ ɛnyɨŋ bɛ́ ntɨ ɛna nɛ́mbák pɛ́pɛ́p nɛ Mandɛm, nɛ́mbak pɛ́pɛ́p nɛ bo. ");
INSERT INTO kenNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Nnáŋ ntat nyaka mpǎy mamiɛ́ kɛrɔ́ŋ Yerúsalɛm. Ndɔk yɛ arɛ́ nɛ nkáp bɛ́chyɛ́ nɛkwak ntá bachɛ́bhɛ́bho ɛtɔk ɛya, nɛ bɛ́chyɛ́ akap ntá Mandɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ɛnɛ́ nchí Yerúsalɛm ndu batí barak ayɔ ápáy kɛ̌ bághɔ́ mɛ amɛm ɛkɛrákap. Bághɔ́ mɛ ndǔ nchí naŋa bɛkʉ mbɔ ɛnyu ɛbhé Moses ɛ́rɛ̀m bɛ́ mmu ankʉ bɛso bɛsí nɛ Mandɛm. Ɛká bho ɛ́pú nyaka arɛ nɛ mɛ, nɛ yɛ̌ chi ɛbyɔk. ");
INSERT INTO kenNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Kɛ mbɔk bo Israɛl abhɛn báfú atú Esia bábhak arɛ́. Bɔ babhɔŋ bɛ́twɔ fá mántɛbhɛ mɛ bɛsí bhɛ mbák bághɔ bɛ nkʉ ɛbɛ́ptí ɛnyɨŋ. ");
INSERT INTO kenNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Mbák ɛ́pú nɔ́, bɛ́p bo abhɛn bachi fá téé, bɛ bɔ babhɔŋ mandɛm bɛkwɛ́nɛ́ ɛbhɛn baghɔ ɛbhe ɛya mpok ntée amɛm ɛchɛmɛ́ bǒbati ɛtɔk. ");
INSERT INTO kenNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Bǎbhɨkɨ bhɔŋ ɛnyɨŋ ɛnɛ bárɛ̀m bɛ nkʉ, ɛbhɨkɨ fʉɛt chi ɛnyɨŋ ɛ́mɔt ɛnɛ mbɨ́kɨ́ ndɛm mpok ntée nɛntɨ ɛnap bɛ, ‘Chɔŋ bawú mámpɛtnsɛm ndǔ nɛpɛ́m.’” ");
INSERT INTO kenNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Fɛ́liks arɨŋɨ nyaka sayri ɛ̌ti Mbi Yesu Acha. Ɛ́kʉ́ ághókó nɔ́kɔ́ ɛnyɨŋ Pɔ̌l arɛmɛ, ábhʉ́rɛ́ manyé, arɛm ntá bo Israɛl bɛ́ Lísias mǔngo batɛmɛ́ nɛnu ántwɔ́ chɔŋ mkpɔ́t nnyé ɛnɛká ɛnɛn. ");
INSERT INTO kenNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Achyɛ yɛ ɛyɔŋ ntá mǔnti batɛmɛ́ nɛnu bɛ́ ámfyɛ́ Pɔ̌l anywɔ́p, mambabhɛri nɔkɔ yi, kɛ ámbɔ́ŋ ngangaŋ mandú. Nɛ bɛ bákɛ́ kaŋ mamʉɛrɛ bhi bɛrɔŋ bɛghɔ yi nɛ bɛchyɛ yi nɛkwak. ");
INSERT INTO kenNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Ɛ́fʉɛ́rɛ́ nɔ́kɔ́ mpǎy manywɔp, Fɛ́liks nɛ ngɔrɛ́ aywi Drusíla batwɔ. Drusíla abhak mmu Israɛl. Báto mmu bɛ ambɨŋɨ Pɔ̌l. Atwɔ nɔkɔ, bátá batu bare ghok ndu yi árɛ̀m ɛnyǔ mmu ákway bɛbhɔŋ nɛka nɛ Yesu Kristo. ");
INSERT INTO kenNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ndǔ Pɔ̌l ákɛ̀m ɛpʉ́ítí andɛmɛ nɔkɔ ɛnyǔ mmu ákwày bɛbhak chak bɛsí Mandɛm nɛ ɛnyǔ mmu ákwày bɛ́kɛ́m mmʉɛt bɛ ákɛ́ kʉ bɛbʉ́, nɛ ɛ̌ti nywɔp ɛnɛn Mandɛm ábhɔ́ŋɔ́ bɛtaŋ yɛ̌ntɨkɨ mmu, bɛcháy bɛ́kɛ́m Fɛ́liks, arɛm bɛ, “Dɔ́k kpɨ́k, nnaŋ mbɔ̌ŋ ɛ́pók chɔŋ mpɛt mbɨŋɨ wɔ.” ");
INSERT INTO kenNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Árɛ́m nɔ́kɔ́ nɔ, abhaka ntɨ bɛ ngufú chɔŋ Pɔ̌l anchyɛ yí bɛsɔŋ. Ɛkʉ are bhɨŋɨ yí mpok nɛ mpok andɛm nɔkɔ kɛpɨ nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Are kʉ ɛnyu ɛyɔ ndǔ mamiɛ́ ápáy kpátɛ̌ Pɔ́síɔ́s Fɛ́stɔs ásɔ́t ɛ́pók ɛyi mbɔ gɔ́bhanɔ. Ndu Fɛ́liks ayaŋ bo Israɛl mámbɔŋ maŋák nɛ yi, arɔ Pɔ̌l ɛkɛrɛ́kɛnɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Fɛstɔs arɔk Seséria bɛ́bhó bɛtɨk mbɔ gɔ́bhanɔ atú Judéya. Ɛfʉɛrɛ nɔkɔ manywɔp arat, afa akó Yerúsalɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Arɛ́, bǒbati bachiǎkap nɛ manɛ́m bo Israɛl barɔk batɛmɛri Fɛstɔs babho bɛbhat Pɔ̌l barak amʉɛt. Nɛ manɨk Fɛstɔs mmʉɛt bɛ, ");
INSERT INTO kenNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ankwak bɔ bɛkʉ manto Pɔ̌l Yerúsalɛm. Mǎnaŋ batɨ nyaka bɛ bo mámbɛ́sɛ́ ambi mankɛm yi mangway. ");
INSERT INTO kenNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Fɛstɔs aghati bhɔ bɛ, “Pɔ̌l achí ɛkɛrɛ́kɛnɔŋ amɛm ɛtɔk Seséria nɛ mbɔ̌ŋ nkaysi bɛrɔŋ arɛ́ mandú mpok. ");
INSERT INTO kenNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Bǒbatí bhɛka mánkóŋó mɛ Seséria nɛ mbák yi abhɔŋ bɛkwɛ́nɛ́ chɔŋ mǎndɛm bɛsí ɛbha arɛ́.” ");
INSERT INTO kenNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fɛstɔs abhak nɛ bhɔ́ mbɔ manywɔp ánɛ̀n nɛ byó. Apɛt yɛ nsɛm Seséria. Nɛ́yi nɔ́kɔ́, achɔkɔ ndǔ ɛnɔkɔ́ manyé ɛyi, achyɛ ɛyɔŋ bɛ́ mánsɔ́t Pɔ̌l mántwɔ́ nɛ yí. ");
INSERT INTO kenNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Bátwɔ́ nɔ́kɔ́ nɛ yí bo Israɛl abhɛn báfú Yerúsalɛm bákáp yí báfyɛ́ nɛ́ntɨ́ mándɛmɛ nɔkɔ bɛ́ Pɔ̌l ákʉ́ bɛyǎ bɛbɛ́ptí mɛnyɨŋ. Yɛ̌ nɔ, bɔ́ kɛkwáy bɛtɔŋ kpoŋoroŋ mɛnyɨŋ ɛbhɛn bɔ́ bárɛ̀m bɛ́ yí akʉ́. ");
INSERT INTO kenNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pɔ̌l abho bɛ́táŋa mmʉɛt andɛm nɔkɔ bɛ, “Bɛkwɛ́nɛ́ bɛ́pú nɛ mɛ wáwák bɛyɨŋɨ ɛbhé bo Israɛl nɛ ɛbhé ɛkɛrákap nɛ yɛ̌chi ɛbhé Mfɔ Rom.” ");
INSERT INTO kenNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Fɛstɔs áyàŋ nyaka bo Israɛl mankɔŋ yi. Ɛ́kʉ́ abhɛp Pɔ̌l bɛ, “Ɔkɔŋ bɛ́ko Yerúsalɛm bɛ́ ntáŋ ndak anɛ arɛ?” ");
INSERT INTO kenNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pɔ̌l akɛmɛ bɛ, “Nchí fá amɛm acha manyé Mfɔ Rom, nɛ fá kɛ bábhɔ́ŋɔ́ bɛ́táŋ nyé ɛnɛn. Wɔmbɔŋ ɔrɨ́ŋɨ́ bɛ mbɨ́kɨ́ kʉ bo Israɛl bɛbʉ́. ");
INSERT INTO kenNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Mbák nkwɛn ɛbhé nɛ nkʉ ɛnyɨŋ ɛnɛ́ ɛ́yàŋ bɛ mángwáy mɛ nká nɛwú. Kɛ tɛ̌ndu barak anɛ́ bɔ́ bábhàt mɛ amʉɛt apú tɛtɛp, yɛ̌ mmú apú kwáy bɛfyɛ mɛ amɔ́ yap. Nyé ɛna nɛ́bhɔŋ bɛ́rɔ́ŋ ntá Mfɔ Rom.” ");
INSERT INTO kenNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Fɛstɔs ághókó nɔ́kɔ́ ɛnyɨŋ Pɔ̌l árɛ́mɛ́, abhɨŋɨ bataŋá manyé abhi bárɛ́m kɛpɨ. Aghati yɛ Pɔ̌l bɛ, “Ɔrɛm bɛ́ nyé ɛnɛ nɛ́ndɔ́k ntá Mfɔ Rom, nɛ chɔŋ ɔ́ndɔk ntá Mfɔ Rom.” ");
INSERT INTO kenNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ɛ́fʉɛ́rɛ́ nɔ́kɔ́ mpǎy manywɔp, Mfɔ Agripa nɛ mɔ́mayi anɛ ngɔrɛ́ Bɛnis bárɔ́k Seséria ndu bɛ́káka Fɛstɔs. ");
INSERT INTO kenNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Bátát nɔ́kɔ́ árɛ́ mpǎy manywɔp, Fɛstɔs aghati Mfɔ Agripa ɛ̌ti nyé Pɔ̌l bɛ, “Mmǔfú achí fá anɛ Fɛ́liks arɔ ɛkɛrɛ́kɛnɔŋ. ");
INSERT INTO kenNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Nɛ mpok nchí Yerúsalɛm, bǒ batí bachiǎkap nɛ bǒ batí ɛtɔk báré bhat yí barak amʉɛt nɛ báré yáŋ bɛ mɛnchyɛ́ ɛyɔŋ mángwáy yi. ");
INSERT INTO kenNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Kɛ nkɛmɛ bhɔ́ bɛ ɛpɨŋɨ́ bǒ Rom ɛ́bhɨ́kɨ́ ka bɛ mángwáy mmu ɛnɛ́ babhɨkɨre taŋ yi. Mmu abhɔŋ bɛ́té bɛsí nɛ bɛsí nɛ bo abhɛn bátí yí anchyɛ ɛyi ɛyɔŋɔ́ manyé. ");
INSERT INTO kenNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Bátwɔ́ nɔ́kɔ́ yɛ fá, mbɨ́kɨ́ chɔŋti mpok. Nɛ́yí, nchyɛ́ ɛyɔŋ bɛ mánsɔ́t mmǔ wu mantwɔ ndu acha manyé nɛ yi. ");
INSERT INTO kenNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Mpok bo abhɛn bábhárɛ́ yi barak amʉɛt báfáté, bɔ́kɛ rɛm yɛ̌ ndak abʉ́abʉ mbɔ anɛ nkaysi bɛ bɔ bakway bɛrɛm bɛ yi akʉ. ");
INSERT INTO kenNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Báré kɛ́m chi ɛpʉ́ítí nɛ yí ɛ̌ti baraká Mandɛm ayap nɛ ɛ̌ti mmu anɛ ákà nnyɛ́n bɛ́ Yesu anɛ ánáŋ ágú, kɛ Pɔ̌l ǎrɛ̀m bɛ́ achi nɛpɛ́m. ");
INSERT INTO kenNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ngɔ́ nɔ́kɔ́ bɛ́ mbɨ́kɨ́ rɨŋɨ ɛnyǔ mɛ̌kwáy bɛkʉ bɛ mbɔŋ nɛjwǐmɛm ndu barak anɛ, mbɛ́p Pɔ̌l mbák yi akɔŋ bɛrɔŋ Yerúsalɛm bɛ mántaŋ nnyé ɛni arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Kɛ Pɔ̌l kɛka. Ate chí bɛ́ mambabhɛri nɔkɔ yi kpatɛ Mfɔ Rom antáŋ nyé ɛni. Nchyɛ́ ɛyɔŋ bɛ mambabhɛri nɔkɔ yi kpatɛ mpok anɛ mɛ́tò yi ntá Mfɔ Rom.” ");
INSERT INTO kenNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Mfɔ Agripa arɛm ntá yi bɛ, “Chɔŋ mɛmbɔŋ nkɔŋ bɛghok nɛ batú ɛnyɨŋ ɛnɛ yi árɛ̀m.” Fɛstɔs akɛmɛ yi bɛ, “Chɔŋ ɔ́ngok yi mbúrɛ́.” ");
INSERT INTO kenNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Nɛ́yí nɔ́kɔ́ yɛ, Mfɔ Agripa nɛ mɔ́mayi Bɛnis bárɔk amɛm áchá-ɛtɔk nɛ bɛyǎ kɛnókó, báchwé nɛ bǒbati batɛmɛ́ nɛnu nɛ manɛm bǒ ɛtɔk. Fɛstɔs achyɛ yɛ ɛyɔŋ bɛ́ batɛmɛ́ nɛnu mánsɔ́t Pɔ̌l mántwɔ́ nɛ yí. ");
INSERT INTO kenNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Bátwɔ́ nɔ́kɔ́ nɛ yí, Fɛstɔs arɛm bɛ, “Mfɔ Agripa nɛ be mankɛm abhɛn báchí fá nɛ bhɛsɛ, ghɔ́ mmǔrɛ́. Bo Israɛl mankɛm abhɛn Yerúsalɛm nɛ abhɛn fá Seséria bátwɔ ntá ya mpoknkɛm, mámbɨk nɔkɔ bɛ, ‘Apú mmu anɛ bárɔ̀ bɛ ámbák nɛpɛ́m.’ ");
INSERT INTO kenNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Kɛ mbɨ́kɨ́ ghɔ́ nyaka ɛnyɨŋ ɛnɛ́ yi ákʉ́ bɛ mangway yi, nɛ tɛ̌ndu yímbɔŋ árɛ́mɛ́ bɛ manyé ayi abhɔŋ bɛ́rɔŋ ntá Mfɔ Rom, nka nɛ yí. ");
INSERT INTO kenNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Yɛ̌ nɔ, mbɨ́kɨ́ bhɔŋ ɛsáyrí ɛnyɨŋ bɛsɨŋ ntá Mfɔ Rom ɛ̌ti yi. Ɛ̌tiyɔ kɛ ntwɔ́ nɛ yí bɛsí ɛbhɛka, nɛ sayri sayri, bɛsí ɛbhɛ, Mfɔ Agripa! Ntwɔ nɛ yi bɛ sɛ́njɨ́ŋɨ́ nyé ɛni ɛnyu ɛnɛ́ nchí kway bɛbhɔŋ ɛnyɨŋ ɛnɛ mɛ́sɨ̀ŋ. ");
INSERT INTO kenNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Mbɨ́kɨ́ kaysi bɛ́ ɛ́chí sayri bɛ́tó mǔkɛnɔŋ ntá Mfɔ Rom nkɛrɛm mbɔ̌ŋ ɛnyɨŋ ɛnɛ yi ákʉ́.” ");
INSERT INTO kenNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Fɛstɔs ánáŋá nɔ́kɔ́ ɛnyɨŋ ɛnɛ yi árɛ̀m, Agripa arɛm bɛ, “Pɔ̌l, mbák ɔbhɔ̌ŋ ɛnyɨŋ bɛ́rɛm ndu bɛ́táŋá mmʉɛt, dɛm sɛ́ngók.” Pɔ̌l abho yɛ bɛ́táŋa mmʉɛt, antɔŋ nɔkɔ nɛ awɔ́ bɛ, ");
INSERT INTO kenNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Mfɔ Agripa, nkáysɨ́ bɛ́ ɛrɨ ɛcha bɛ nté bɛsí ɛbhɛ ɛchɔŋ ndu bɛ́táŋa mmʉɛt ndǔ barak anɛ́ bo Israɛl bábhàt mɛ amʉɛt. ");
INSERT INTO kenNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Ɛ́rɨ sayri bɛ mbɔ̌ŋ mfɔ arɨ́ŋɨ́ bɛpɨŋɨ́ bo Israɛl mɛnkɛm nɛ mɛnyǔ mɛnyɨŋ ɛbhɛn bɛ́twɔ̀ bhɔ nɛ ákɔ́rɛ́. Nchí nɨk yɛ wɔ mmʉɛt bɛ́ ɔ́nkɛ́pntɨ ɔ́ngɔ́k ɛnyɨŋ ɛnɛ mɛ́rɛ̀m. ");
INSERT INTO kenNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Bo Israɛl mankɛm bárɨ́ŋɨ́ mɛ tɛ kɛ̌mbɔ́ ɛka. Ngo chí nɛ bǒbha nɛ amɛm ɛtɔk Yerúsalɛm. ");
INSERT INTO kenNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Bɔ́ bárɨ́ŋɨ́ sayri ndǔ ɛrɔ́rí mpok bɛ́ nchí nyaka ndǔ nkwɔ́ bǒ Farisi abhɛn báfyɛ̀ bɛtaŋ tontó ndǔ baraká Mandɛm. Mbák ɔmbɛ́p bhɔ chɔŋ mángati bhe ɛnyúmɔt mbák báyaŋ bɛrɛm tɛtɛp anɛ bárɨŋɨ. ");
INSERT INTO kenNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Nté fá ɛchɔŋ bǎtàŋ mɛ chí mbɔnyunɛ mbákántɨ ndǔ bariɛp amɛn Mandɛm afyɛ́ nyaka ntá bachǐmbɨ abhɛsɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Chí nkúbhɛ́ bariɛp amɛn manɛrɛ́kɛt yɛsɛ́ byo nɛ apay babhaka ntɨ arɛ́ bɛ́ chɔŋ amfú kpoŋoroŋ ndǔ mánɨ̀kmʉɛt mánchyɛ nɔkɔ Mandɛm kɛnókó bɛti nɛ ngósí. Mfɔ, mbɔ̌ŋ ɛsɔŋɔri nɛ bo Israɛl ɛchɔŋ chi ɛ̌ti mbákántɨ ndǔ bariɛp amɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ndaká yí ɛ́bemʉɛt ntá yɛ̌chi mmǔ ywɛka amɔt mɛnoko bɛ Mandɛm ǎkway bɛkʉ bawú mampɛtnsɛm ndǔ nɛpɛ́m? ");
INSERT INTO kenNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Mɛmbɔŋ ngɔ nyaka bɛ, ɛ́chí ɛpók ɛya bɛkʉ yɛ̌ntɨkɨ ɛnyɨŋ ndu mɛnu nɛ bo abhɛn mánókó nnyɛ́n Yesu mmu Násárɛt. ");
INSERT INTO kenNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Nɛ nkʉ́ nɔ amɛm ɛtɔk Yerúsalɛm. Bǒ-batí bachiǎkap báchyɛ́ mɛ bɛtaŋ bɛ́fyɛ́ bo Mandɛm amɛm ɛkɛrɛ́kɛnɔŋ. Nɛ mpok anɛ bárɛ́mɛ́ bɛ mángwáy bhɔ́, nka bɛ mángwáy. ");
INSERT INTO kenNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Mpok nɛ mpok, nchí rɔŋ nyaka ndǔ bɛkɛrɛ́ nɛnɨkɨ́mʉɛt mɛnkɛm nchyɛ́ nɔkɔ bhɔ ntɛ́msi bɛkʉ bɔ mandɛm ɛbʉ́bʉ ɛ̌ti Yesu. Mbɔ̌ŋ bɛyǎ bɛběntɨ nɛ bhɔ́ kpát ndɔk nɔkɔ bɛtɔk bo báchák ndu bɛ́chyɛ́ bhɔ nɛnyok arɛ́. ");
INSERT INTO kenNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Ɛwak ɛ́mɔ́t, nde rɔ́ŋ Damáskɔs nɛ bɛkáti ɛbhɛ́n nsɔ́rɛ́ nta bǒ batí bachiǎkap bɛchyɛ mɛ bɛtaŋ bɛ ndɔ́k nkɛ́mtí bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Mfɔ, ndu nchí rɔ́ŋ, bɛ́gháka nɛ́ntɨ́ ngósí, bɛdiɛ́rɛ́ ɛbhɛn bɛ́chá ɛbhɛn nnyɔ́mok bɛ́fú amfay bɛ́kwɛ́n bɛkap mɛ nɛ bo abhɛn mɛ́kɔ̀ nɛ bhɔ. ");
INSERT INTO kenNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Bɛsɛ́ mankɛm sɛ́kwɛ́nti amɨk. Tɛ́mté wu, ngók ɛyɔŋ ɛnɛ́ ɛ́rɛ̀m ndǔ ɛyɔŋɔ́tɔk Hibru bɛ, ‘Sɔ̌l, Sɔ̌l, ndaká yí ɔ́chyɛ̀ mɛ nɛnyok? Ɔkáysí bɛ́ ɔ̌kwáy mɛ́nú nɛ mɛ? Mbák ɔ́nsɔ́t ɛkak ɔndɛp sɛtárɛ́bhɛ́ wɔ kɛ ɔ́ghòk bɛbe.’ ");
INSERT INTO kenNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Mbɛ́p bɛ́, ‘Acha chí wɔ́ agha?’ Acha akɛmɛ mɛ bɛ, ‘Mɛ Yesu kɛ̌ ɔ́chyɛ̀ nɔ́ nɛnyok. ");
INSERT INTO kenNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Kɛ faté. Mbésí wɔ bɛsí ndu bɛyap wɔ ɔ́mbák mǔbɛtok awa. Chɔŋ ɔ́mbak ntísiɛ wa, ɔ́ngati nɔkɔ bo mɛnyɨŋ ɛbhɛn ɔ́ghɔ́ fá ambi ɛchɔŋ, nɛ ɛbhɛ́n mɛ́tɔ̀ŋ chɔŋ wɔ ansɛm mpok. ");
INSERT INTO kenNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Chɔŋ mbak ɛkuti ɛyɛ mpoknkɛm, nɛ bǒbhɛ bápú kway bɛkʉ wɔ yɛ̌nyɨŋ, nɛ yɛ̌ chí bo abhɛn bápú bo Israɛl. Nchí to wɔ ntá yap nɛ́nɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Mɛ́tò wɔ ɔndɔk ɔ́nɛ́nɛ́ bɔ́ amɨ́k bɛ mándɔ́ ɛjuri mankoŋo bɛdiɛ́rɛ́, nɛ bɛ mamfu ndu bɛtaŋ Satan, mánkoŋo Mandɛm ɛnyu ɛnɛ Mandɛm áfoŋori bhɔ bɛbʉ́ ɛbhap, ankʉ mámbak ndu nkwɔ bo abhɛn yi ákʉ́ bachi nyáŋá mbɔnyunɛ babhɔŋ nɛka nɛ mɛ.’ ");
INSERT INTO kenNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Mfɔ Agripa, ndǔ Yesu áfú amfay atwɔ ntá ya ndu kɛnɔ́ amɨ́k antifú, mbɔ̌ŋ yɛ nyaka bɛ́kóŋo ɛyɔŋ ɛyi. ");
INSERT INTO kenNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ɛ́kʉ́ mbo bɛ́gháti Ɛyɔŋ Mandɛm ɛtɔk Damáskɔs, nɛ nkɔ ndɔk nɔkɔ Yerúsalɛm, nɛ atú Judɛ́ya ankɛm, kɛ nde rɔ́ŋ ntá abhɛn bápú bo Israɛl nkwɔ, bɛ́ bɔ́ mántɨknsɛm ndǔ bɛbʉ́ bhap mámpɛtnsɛm ntá Mandɛm nɛ mámbo bɛkʉ mɛnyɨŋ ɛbhɛ́n bɛ́tɔ̀ŋ bɛ́ bɔ́ bátɨknsɛm ndǔ bɛbʉ́ bhap. ");
INSERT INTO kenNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ɛ́yɔ kɛ ɛ́kʉ́ bo Israɛl bákɛ́m mɛ amɛm ɛkɛrákap Mandɛm, nɛ báré yaŋ bɛ́wáy mɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Kpátɛ̌ ɛchɔŋ Mandɛm kɛ ákwàk mɛ, nɛ ákʉ́ bɛ́ nté fá ndɛ́m ntá bǒ mankɛm, manɛ́m bho nɛ ndɛ́ndɛ́mɛ́ bho, nkúbhɛ́ ɛnyɨŋ ɛnɛ barɛmɛ́ kɛpɨ̌ntɨ bárɛ́mɛ́ nyaka nɛ Moses árɛ̀m bɛ́ chɔŋ ɛ́mfakari. ");
INSERT INTO kenNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Nɔ chi ɛnyɨŋ bárɛ́mɛ́ bɛ Mpɛmɛ Mandɛm afyɛ́ nyaka bariɛp bɛ ǎtò abhɔŋ bɛghɔ ɛsɔŋɔri angú, nɛ ambak mmǔ mbɨ bɛ́pɛ́tnsɛm ndǔ nɛpɛ́m angati bo Israɛl nɛ abhɛn bápú bo Israɛl ɛ̌ti ɛrɔ́ŋɔ́ ɛnɛ ɛ́chyɛ̀ nɛpɛ́m.” ");
INSERT INTO kenNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Ɛnɛ́ Pɔ̌l ábhʉɛ́t bɛ́táŋa mmʉɛt ɛnyu yɔ, Fɛstɔs abɨk arɛm bɛ, “Pɔ̌l, ɛbhókórí ɛ́kɛm wɔ! Bɛyǎ ɛkáti bɛ́kʉ ɛbhókórí ɛ́kɛm wɔ!” ");
INSERT INTO kenNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Kɛ Pɔ̌l akɛmɛ bɛ, “Ɛta, wo mmu kɛnókó ɛkɛ kɛya kɛcha, mpú bhokori! Mɛnyɨŋ ɛbhɛ́n mɛ́rɛ̀m bɛchi tɛtɛp. ");
INSERT INTO kenNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Mfɔ árɨ́ŋɨ́ mɛnyɨŋ ɛbhɛn mɛnkɛm, ɛ̌ti yɔ kɛ̌ nchí ghati wɔ mɛnyɨŋ ɛbhɛn nkɛbhɔ́ŋ bɛcháy. Ndɨ́ŋɨ́ bɛ́ ndu mɛnyɨŋ ɛbhɛn mɛnkɛm ɛnɛ́ ɛ́bhɛ́sɛ́ wɔ ɛ́pú, mbɔnyunɛ yɛ̌nyɨŋ ɛ́bhɨkɨ fakari bhɛ́sɛ́ bhɛ́sɛ́. ");
INSERT INTO kenNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Mfɔ Agripa, pú ɔnókó ɛnyɨŋ barɛmɛ́ kɛpɨ̌ntɨ básɨ́ŋɨ́? Ndɨ́ŋɨ́ bɛ́ ɔnókó!” ");
INSERT INTO kenNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Mfɔ Agripa akɛmɛ bɛ, “Pɔ̌l, ɔkáysí bɛ́ ndǔ mɔ́mbɨŋɨ mpok anɛ kɛ̌ ɔ́kwày bɛkʉ mɛ mbak mǔnkwɔ Kristo?” ");
INSERT INTO kenNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pɔ̌l akɛmɛ yi bɛ, “Yɛ̌ chí ndǔ mandú mpok yɛ̌ ndǔ ɛrɔ́rí mpok, nɛnɨkɨ́mʉɛt ɛna ntá Mandɛm chí bɛ ɛ́kɛ́bhak chi ndiɛrɛ wɔ, kɛ bɛ yɛ̌ntɨkɨ mmu achák anɛ áchí fá ɛchɔŋ ághòk mɛ, ámbák mbɔ mɛ ɛbhɨkɨfʉɛt chi bɛbhak nɛ ngɛm amɔ́ mbɔ mɛ.” ");
INSERT INTO kenNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Afɔ̌ kɛ Mfɔ Agripa, nɛ gɔ́bhanɔ Fɛstɔs, nɛ Bɛnis manɔ Mfɔ Agripa, nɛ bǒ mankɛm abhɛn báchí chɔ́kɔ́ nɛ bhɔ́ báfáté. ");
INSERT INTO kenNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Báfú nɔ́kɔ́, báré rɛm nɛ batɨ bɛ, “Mmǔ-nɛ abhɨ́kɨ́ kʉ yɛ̌nyɨŋ ɛnɛ́ ɛ́yaŋ bɛ mángwáy yí nɛ yɛ̌ chi bɛfyɛ yi ɛkɛrɛ́kɛnɔŋ.” ");
INSERT INTO kenNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Nɛ Mfɔ Agripa arɛm ntá Fɛstɔs bɛ, “Mbɔ abhɨ́kɨ́ rɛm bɛ mántɛn manyé yi ntá Mfɔ Rom, mbʉ sɛ́rɔ́ yi arɔŋ.” ");
INSERT INTO kenNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Barɛm bɛ sɛnsɔt áchwí sɛndɔk Itali. Básɔt yɛ Pɔ̌l nɛ mbɔk bǒkɛnɔŋ báchyɛ́ ntá Juliɔs mǔnti ɛká batɛmɛ́ nɛnu ɛnɛ babhɨŋɨ bɛ ɛká batɛmɛ́ nɛnu Mfɔ Rom. ");
INSERT INTO kenNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Sɛ́rɔ́k sɛ́chwé áchwí anɛ áfú Adramatium. Abhɔ́ŋ nyaka bɛ́tɛ́mɛ ndǔ yɛ̌ntɨkɨ nɛchyɛ̌nyɛ́n atú Esia. Sɛ́fá sɛ́ré rɔ́ŋ. Arístakɔs mmu Masidónia wu áfú Tɛsalónika abhak nɛ bhɛsɛ́. ");
INSERT INTO kenNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Nɛ́yí nɔ́kɔ́, sɛ́tɛ́mɛ ndǔ nɛchyɛ Sídɔn. Júliɔs atɔ́ŋ Pɔ̌l bɛrɨ̌ntɨ. Arɔ Pɔ̌l ánkó ɛtɔk, ángɔ́ mamʉɛrɛ bhi bɛ mánkwák yí nɛ mɛnyɨŋ ɛbhɛ́n bɛkway bɛ́kwák yi. ");
INSERT INTO kenNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Ɛtarɛ nɔkɔ sɛ́pɛ́t sɛ́chwé áchwí sɛ́ré rɔ́ŋ. Mbʉ́ɛ́p ataŋataŋ ábhó bɛ́fú bhɛsɛ́ ambɨ. Ɛ́kʉ́, sɛ́gháká nɔ́kɔ́ kɛ́kwɔ́t Sáyprɔs, ɛtɔk ɛnɛ́ ɛ́chí nɛ́ntɨ́ nnyɛ́n, sɛ́rɔ́bhɛ nók sɛ́mfʉɛt nɔkɔ chí ɛbhě ɛnɛ́ ɛ́chí tɨɨɨ. ");
INSERT INTO kenNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Sɛ́nók sɛ́pé manyu ndǔ ɛbhe ɛnɛ ɛ́yɨ̀ŋɨ atú Silísha nɛ Pamfília sɛ́tɛ́mɛ ɛtɔk Míra ndǔ atú Lúcia. ");
INSERT INTO kenNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Arɛ́ ndǔ nɛchyɛ Míra, mǔnti batɛmɛ́ nɛnu aghɔ́ áchwí anɛ áfú Aleksándriya, ɛtɔk Íjip, árɔ̀ŋ Itali. Afɛrɛ bhɛsɛ́ ndǔ ayɛsɛ́ áchwí afyɛ́ amɛm awu. ");
INSERT INTO kenNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Sɛ́ré nók sɛ́ndɔkɔ nɔkɔ pɛtii ndǔ mpǎy manywɔp. Sɛ́bhɔ́ŋ bɛyǎ ɛsɔŋɔri kɛ sɛ́chwɔp kɛ́kwɔ́t nɛ Kɨnídɔs. Mbʉ́ɛ́p ataŋataŋ kɛka sɛ́ndɔ́k ámbɨ. Sɛ́mɔ́kɔ́ri sɛ́rɔ́bhɛ́ nók sɛ́mfʉɛrɛ nɔkɔ chi ɛbhě Krɛt ɛnɛ́ nnyɛ́n nɛ́chí tɨ̌í, kɛ́kwɔ́t nɛ njiɛ Salmɔ́nɛ. ");
INSERT INTO kenNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Babhʉɛ́p áchyɛ́ bhɛsɛ bɛyǎ ɛsɔ