﻿USE sofia;
DROP TABLE IF EXISTS sofia.kekNT_vpl;
CREATE TABLE kekNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kekNT_vpl WRITE;
INSERT INTO kekNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Sa' li hu a'in tz'i̱banbil retalil jo' q'uialeb lix xe' xto̱nal li Jesucristo. Li Jesucristo ralal xc'ajol li rey David ut ralal xc'ajol ajcui' laj Abraham. ");
INSERT INTO kekNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Laj Abraham, a'an xyucua' laj Isaac. Laj Isaac, a'an xyucua' laj Jacob. Ut laj Jacob, a'an xyucua' laj Judá jo' eb ajcui' li ras ut li ri̱tz'in. ");
INSERT INTO kekNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ut laj Judá ut lix Tamar, a'aneb xna' xyucua'eb laj Fares ut laj Zara. Laj Fares, a'an xyucua' laj Esrom. Ut laj Esrom, a'an xyucua' laj Aram. ");
INSERT INTO kekNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ut laj Aram, a'an xyucua' laj Aminadab. Ut laj Aminadab, a'an xyucua' laj Naasón. Ut laj Naasón, a'an xyucua' laj Salmón. ");
INSERT INTO kekNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ut laj Salmón ut lix Rahab, a'aneb xna' xyucua' laj Booz. Laj Booz ut lix Rut, a'aneb xna' xyucua' laj Obed. Ut laj Obed, a'an xyucua' laj Isaí. ");
INSERT INTO kekNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ut laj Isaí, a'an xyucua' li rey David. Ut li rey David, a'an lix yucua' laj Salomón riq'uin li ixk li quicuan chok' rixakil laj Urías. ");
INSERT INTO kekNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ut laj Salomón, a'an xyucua' laj Roboam. Ut laj Roboam, a'an xyucua' laj Abías. Ut laj Abías, a'an xyucua' laj Asa. ");
INSERT INTO kekNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ut laj Asa, a'an xyucua' laj Josafat. Ut laj Josafat, a'an xyucua' laj Joram. Ut laj Joram, a'an xyucua' laj Uzías. ");
INSERT INTO kekNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ut laj Uzías, a'an xyucua' laj Jotam. Ut laj Jotam, a'an xyucua' laj Acaz. Ut laj Acaz, a'an xyucua' laj Ezequías. ");
INSERT INTO kekNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ut laj Ezequías, a'an xyucua' laj Manasés. Ut laj Manasés, a'an xyucua' laj Amón. Ut laj Amón, a'an xyucua' laj Josías. ");
INSERT INTO kekNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ut laj Josías, a'an xyucua' laj Jeconías jo' eb ajcui' li ri̱tz'in. Eb a'an que'cuan sa' eb li cutan nak eb laj Israel que'chape' ut que'c'ame' aran Babilonia. ");
INSERT INTO kekNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ut nak ac chapbileb chak xbaneb laj Babilonia, laj Jeconías quicuan li ralal. Ut a'an laj Salatiel. Ut laj Salatiel, a'an xyucua' laj Zorobabel. ");
INSERT INTO kekNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ut laj Zorobabel, a'an xyucua' laj Abiud. Ut laj Abiud, a'an xyucua' laj Eliaquim. Ut laj Eliaquim, a'an xyucua' laj Azor. ");
INSERT INTO kekNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ut laj Azor, a'an xyucua' laj Sadoc. Ut laj Sadoc, a'an xyucua' laj Aquim. Ut laj Aquim, a'an xyucua' laj Eliud. ");
INSERT INTO kekNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ut laj Eliud, a'an xyucua' laj Eleazar. Ut laj Eleazar, a'an xyucua' laj Matán. Ut laj Matán, a'an xyucua' laj Jacob. ");
INSERT INTO kekNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ut laj Jacob, a'an xyucua' laj José, xbe̱lom lix María. Ut lix María, a'an lix na' li Jesús. Ut li Jesús, A'an li Cristo. ");
INSERT INTO kekNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ca̱laju te̱p li ralal xc'ajol laj Abraham quicuan toj nak quiyo'la laj David. Ac cuan ca̱laju te̱p li ralal xc'ajol laj David nak que'c'ame' aran Babilonia. Ut chirix chic a'an, quicuan cui'chic ca̱laju te̱p li ralal xc'ajol chalen toj nak quiyo'la li Cristo. ");
INSERT INTO kekNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ut lix yo'lajic li Jesucristo, jo'ca'in nak quicuan: Lix María lix na' li Jesús ac tz'a̱manbil xban laj José. Toj ma̱ji' neque'xlak'ab rib nak lix María quicana chi yaj aj ixk xban xcuanquil li Santil Musik'ej. ");
INSERT INTO kekNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ut xban nak ti̱c xch'o̱l laj José, li ac xtz'a̱man re, inc'a' quiraj xc'utbal xxuta̱n lix María. Xraj raj xcanabanquil chi mukmu. ");
INSERT INTO kekNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ut yo̱ chixc'oxlanquil a'in laj José nak jun lix ángel li Ka̱cua' quixc'utbesi rib chiru sa' xmatc' ut quixye re: —At José, ralalat li rey David, matc'oxlac chixc'ambal lix María chok' a̱cuixakil. A'an xcana chi yaj aj ixk xban xcuanquil li Santil Musik'ej. ");
INSERT INTO kekNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ta̱cua̱nk jun lix c'ula'al ch'ina te̱lom. Ut Jesús ta̱q'ue chok' xc'aba' xban nak a'an ta̱colok re lix tenamit sa' lix ma̱queb, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Chixjunil a'an quic'ulman re nak ta̱tz'aklok ru li quixye li profeta Isaías jo' nak quiyehe' re xban li Ka̱cua'. ");
INSERT INTO kekNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","A'an a'in li quixye: Jun xka'al toj ma̱ji' cuanjenak riq'uin cui̱nk ta̱cua̱nk lix c'ula'al ch'ina te̱lom. Ut Emanuel ta̱q'uehek' chok' xc'aba'. (Is. 7:14) Chi jalbil ru Emanuel naraj naxye “Li Dios cuan kiq'uin”. ");
INSERT INTO kekNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nak qui-aj ru laj José, quixba̱nu li c'a'ru quiyehe' re xban lix ángel li Ka̱cua' sa' xmatc'. Quixc'am lix María sa' rochoch. ");
INSERT INTO kekNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Abanan inc'a' quicuan riq'uin toj quiyo'la li xbe̱n c'ula'al. Ut Jesús quixq'ue chok' xc'aba'. ");
INSERT INTO kekNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Nak cua̱nk chok' rey laj Herodes, li Jesús quiyo'la aran Belén xcue̱nt Judea. Cuanqueb aj k'e que'chal chak sa' releb sak'e ut que'cuulac Jerusalén. ");
INSERT INTO kekNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Que'patz'oc ut que'xye: —¿Bar cuan lix reyeb laj judío xyo'la? Xochal xban nak xkil chak toj sa' releb sak'e li chahim retalil lix yo'lajic ut xochal chixlok'oninquil, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ut nak quirabi a'an, li rey Herodes quisach xch'o̱l ut qui-oc xc'a'ux jo' ajcui' chixjunileb li cuanqueb Jerusalén. ");
INSERT INTO kekNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ut laj Herodes quixch'utubeb chixjunil li xbe̱nil aj tij jo' eb ajcui' laj tz'i̱b sa' li tenamit ut quixpatz' reheb bar ta̱yo'la̱k li Cristo. ");
INSERT INTO kekNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ut eb a'an que'chak'oc ut que'xye re: —Aran Belén xcue̱nt Judea xban nak jo'can tz'i̱banbil chak xban li profeta. ");
INSERT INTO kekNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Jo'ca'in tz'i̱banbil sa' li Santil Hu: Li tenamit Belén, xch'och'eb laj Judá, moco k'axal ca'ch'in ta lix cuanquil sa' xya̱nkeb li xni̱nkal ru tenamit re Judá xban nak aran ta̱e̱lk jun Acuabej ut a'an ta̱beresi̱nk re lin tenamit Israel. (Mi. 5:2) ");
INSERT INTO kekNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tojo'nak laj Herodes quixbokeb laj k'e sa' mukmu ut quixpatz' reheb jok'e tz'akal quic'utun li chahim. ");
INSERT INTO kekNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ut nak quixtaklaheb Belén quixye reheb: —Ayukex aran Belén ut q'uehomak e̱ch'o̱l chixsic'bal toj retal te̱tau li c'ula'al. Ut nak te̱tau chak, tole̱ye cue re nak tinxic ajcui' la̱in ut toxinlok'oni chak, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ut nak que'rabi li quixye li rey, eb laj k'e que'co̱eb. Ut li chahim li que'ril chak sa' releb sak'e yo̱ chi xic c'amol be chiruheb tojo'nak quixakli sa' xbe̱n li na'ajej cuan cui' li c'ula'al. ");
INSERT INTO kekNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ut c'ajo' nak que'saho' sa' xch'o̱leb chirilbal li chahim nak quixakli sa' xbe̱n li na'ajej a'an. ");
INSERT INTO kekNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ut nak que'oc sa' li cab, que'xtau li c'ula'al rochben lix María li na'bej. Ut que'xcuik'ib rib chiru li Jesús ut que'xlok'oni. Ut que'xte lix c'u̱leba̱leb ut que'xq'ue lix ma̱tan. Ut li ma̱tan li que'xq'ue, a'an li oro, li incienso ut li sununquil ban mirra xc'aba'. ");
INSERT INTO kekNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ut que'c'utbesi̱c chiruheb xban li Dios sa' xmatq'ueb nak inc'a' chic te'suk'i̱k riq'uin laj Herodes. Sa' jalan chic be que'xc'am nak que'suk'i sa' xtenamiteb. ");
INSERT INTO kekNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ut nak ac xco̱eb laj k'e, jun x-ángel li Ka̱cua' quixc'ut rib chiru laj José sa' xmatc' ut quixye re: —Cuaclin, c'am li c'ula'al jo' cui' lix na'. Tex-e̱lk arin ut ayukex sa' li tenamit Egipto. Ut aran texcana̱k toj la̱in toxinyehok a̱cue. Tex-e̱lelik xban nak laj Herodes oc re chixsic'bal li c'ula'al re xcamsinquil.— ");
INSERT INTO kekNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ut laj José qui-aj ru, quicuacli ut quixc'am li c'ula'al jo' cui' lix na' ut sa' ajcui' li k'ojyi̱n a'an que'co̱eb Egipto. ");
INSERT INTO kekNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ut que'cuan aran Egipto toj quicam laj Herodes. A'an quic'ulman jo' quixtz'i̱ba li profeta li quiyehe' re xban li Ka̱cua' nak quixye: Sa' li tenamit Egipto quinbok chak li cualal, chan. (Os. 11:1) ");
INSERT INTO kekNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","A'ut laj Herodes nak quiril nak quibalak'i̱c xbaneb laj k'e, k'axal nak quichal xjosk'il. Ut quixtakla xcamsinquil chixjunileb li coc' te̱lom cuanqueb Belén, jo' cui' sa' eb li na'ajej cuanqueb chixc'atk. Que'camsi̱c chixjunileb li coc' te̱lom li toj c'ula'aleb jun xxiquic aj ca'cab chihab xban nak quixbir rix c'a'ru li cutan quiyo'la cui' li c'ula'al jo' quiyehe' re xbaneb laj k'e. ");
INSERT INTO kekNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jo'can nak quitz'akloc ru li yebil xban li profeta Jeremías nak quixye chi jo'ca'in: ");
INSERT INTO kekNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Qui-abi̱c li ya̱bac sa' li tenamit Ramá xban li nimla rahil ch'o̱lej, ut yot'ba ch'o̱lej li que'xc'ul. A'an eb li ixk aj Israel nak yo̱queb chi ya̱bac chirixeb lix coc'al. Ut inc'a' chic neque'raj xc'ojobanquil xch'o̱leb xban nak ac camenakeb chic lix coc'aleb. (Jer. 31:15) ");
INSERT INTO kekNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ut nak quicam laj Herodes, jun x-ángel li Ka̱cua' quixc'utbesi rib chiru laj José sa' xmatc' aran Egipto. ");
INSERT INTO kekNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ut quixye re: —Cuaclin. C'am li c'ula'al jo' cui' li na'bej ut texxic cui'chic sa' li tenamit Israel xban nak xe'cam li que'ajoc re xcamsinquil li c'ula'al, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ut laj José quicuacli, quixc'am li c'ula'al jo' cui' lix na' ut quichal sa' li tenamit Israel. ");
INSERT INTO kekNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ut nak quirabi resil nak a' laj Arquelao chic li rey aran Judea re̱kaj laj Herodes lix yucua', laj José quixucuac chi xic aran. Ut nak quic'utbesi̱c chiru sa' xmatc', que'co̱eb sa' jun na'ajej xcue̱nt Galilea. ");
INSERT INTO kekNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Que'chal ut que'cuan sa' jun li tenamit Nazaret xc'aba' xcue̱nt Galilea. A'in quic'ulman jo' que'xye li profeta nak que'xye nak aj Nazaret tixc'aba'in. ");
INSERT INTO kekNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mokon chic quicuulac laj Juan laj Cubsihom Ha' sa' li chaki ch'och' cuan Judea. Yo̱ chixch'olobanquil xya̱lal chirix lix nimajcual cuanquilal li Dios. Quixye chi jo'ca'in: ");
INSERT INTO kekNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","—Chiyot'ek' e̱ch'o̱l ut chejal e̱c'a'ux xban nak yo̱ chak chi cha̱lc li ta̱q'uehek' sa' xcuanquil xban li Dios. Ut a'an chic ta̱cua̱nk xcuanquil sa' xbe̱neb li ralal xc'ajol. ");
INSERT INTO kekNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Li profeta Isaías quia̱tinac chirix laj Juan nak quixye chi jo'ca'in: A'an ta̱ch'oloba̱nk xya̱lal chi cau xya̱b xcux sa' li chaki ch'och', ut tixye: Yi̱bomak le̱ yu'am ut yo'on cua̱nkex chixc'ulbal li Ka̱cua' jo' nak neque'xyi̱b li be re xc'ulbal junak li nim xcuanquil, chan. (Is. 40:3) ");
INSERT INTO kekNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Li rak' narocsi laj Juan, a'an yi̱banbil riq'uin rix li xul camello ut lix c'a̱mal xsa' a'an yal tz'u̱m. Aj sa̱c' naxtzaca riq'uin xya'al sak c'au. ");
INSERT INTO kekNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Yalak bar que'chal chak li que'cuulac chirabinquil li c'a'ru yo̱ chixyebal laj Juan. Nabal que'chal Jerusalén. Nabal que'chal chak Judea ut nabal cui'chic que'chal chak nach' riq'uin li nima' Jordán. ");
INSERT INTO kekNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Que'xxo̱to xma̱queb ut laj Juan naxcubsiheb xha' sa' li nima' Jordán. ");
INSERT INTO kekNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nak quiril nabaleb xcomoneb laj fariseo ut xcomoneb laj saduceo yo̱queb chi cuulac yal re nak te'cubsi̱k xha'eb, quixye reheb: —La̱ex chanchanex li ral li c'ambolay. ¿Ani xyehoc e̱re la̱ex nak ta̱ru̱k te̱col e̱rib chiru lix josk'il li Dios li ta̱cha̱lk sa' e̱be̱n? ");
INSERT INTO kekNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Cheba̱nuhak ban li us re nak ta̱c'utu̱nk nak xyot'e' e̱ch'o̱l ut xejal e̱c'a'ux. Chanchanakex li che' cha̱bil li ru naxq'ue. ");
INSERT INTO kekNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Me̱c'oxla nak inc'a' te̱c'ul xjosk'il li Dios yal xban nak la̱ex ralal xc'ajol laj Abraham. La̱in tinye e̱re nak li Dios ta̱ru̱k tixyo'obtesi li pec a'in chok' ralal xc'ajol laj Abraham. ");
INSERT INTO kekNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Q'uehomak retal xban nak cha̱lc re li rakba a̱tin sa' e̱be̱n jo' nak ac cauresinbil li ma̱l re xyoc'bal lix xe' li che'. Ut chixjunil li che' inc'a' cha̱bil li ru naxq'ue, nayoc'man ut naq'ueman sa' xam. ");
INSERT INTO kekNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ya̱l nak la̱in nincubsi e̱ha' riq'uin ha' retalil nak xyot'e' e̱ch'o̱l ut xejal e̱c'a'ux. Abanan cha̱lc re li k'axal nim xcuanquil. Xban nak k'axal nim xcuanquil chicuu la̱in, moco inc'ulub ta nak tincuisi lix xa̱b. A'an tixcubsi e̱ha' riq'uin li Santil Musik'ej ut riq'uin xam. ");
INSERT INTO kekNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ac cuan chak sa' ruk' lix c'anjeleba̱l. Ut ta̱rapu ru chi us li riyajil li trigo ut tixch'utub lix trigo sa' lix c'u̱leba̱l ut li rix tixc'at sa' li xam li ma̱ jaruj nachup, chan laj Juan. ");
INSERT INTO kekNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ut quicuulac xk'ehil nak li Jesús quichal chak Galilea. Quicuulac riq'uin laj Juan re nak ta̱cubsi̱k xha' xban sa' li nima' Jordán. ");
INSERT INTO kekNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Abanan laj Juan inc'a' raj quiraj xcubsinquil xha' ut quixye re: —Ma̱cua' raj la̱in tincubsi̱nk a̱ha'. La̱at raj ban tatcubsi̱nk inha' la̱in, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ut li Jesús quichak'oc ut quixye re: —Us takaba̱nu anakcuan xban nak tento ta̱uxma̱nk chixjunil li c'a'ru naxye li Dios, chan. Tojo'nak quixc'uluban xch'o̱l laj Juan. ");
INSERT INTO kekNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ut nak ac xcubsi̱c xha' li Jesús, qui-el chak sa' li ha'. Ut sa' junpa̱t quiteli li choxa chiru ut quiril li Santil Musik'ej chanchan jun li paloma nak yo̱ chak chi cubec sa' xbe̱n li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ut qui-abi̱c xya̱b xcux li Dios toj sa' choxa nak quixye: —A'an a'in li cualal raro inban. Nasaho' inch'o̱l riq'uin, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tojo'nak li Jesús quic'ame' xban li Santil Musik'ej sa' li chaki ch'och' re ta̱yalek' ra̱lenquil xban laj tza. ");
INSERT INTO kekNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nak ac xba̱nu x-ayu̱n ca'c'a̱l cutan ca'c'a̱l k'ojyi̱n quitz'oca. ");
INSERT INTO kekNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ut laj tza quicuulac riq'uin ut quixye re: —Cui tz'akal ya̱l nak la̱at ralal li Dios, suk'isiheb chok' caxlan cua li pec a'in.— ");
INSERT INTO kekNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Quichak'oc li Jesús ut quixye: —Inc'a' tinba̱nu a'an xban nak tz'i̱banbil retalil sa' li Santil Hu: Ma̱cua' ca'aj cui' riq'uin li naxtzaca yo'yo cui' li cui̱nk; riq'uin ban li a̱tin li naxye li Dios. (Dt. 8:3) ");
INSERT INTO kekNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tojo'nak quic'ame' xban laj tza sa' li santil tenamit Jerusalén; ut coxakaba̱k toj takec' sa' xbe̱n li rochoch li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ut laj tza quixye re: —Cui tz'akal ya̱l nak la̱at ralal li Dios, cut a̱cuib tak'a. Ma̱c'a' ta̱c'ul xban nak jo'ca'in tz'i̱banbil sa' li Santil Hu: Tixtaklaheb lix ángel cha̱cuilbal ut riq'uin ruk'eb tate'xchap re nak inc'a' ta̱toch' la̱ cuok chiru pec. (Sal. 91:11-12) ");
INSERT INTO kekNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ut li Jesús quichak'oc ut quixye re: —Tz'i̱banbil ajcui' sa' li Santil Hu chi jo'ca'in: Ma̱tz'a̱ma xmilagro li Ka̱cua' la̱ Dios yal chi ma̱c'a' rajbal. (Dt. 6:16) ");
INSERT INTO kekNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ut quic'ame' cui'chic xban laj tza sa' xbe̱n jun li tzu̱l k'axal najt xteram. Ut laj tza quixc'ut chak chiru li Jesús chixjunil li tenamit li cuan sa' ruchich'och' jo' ajcui' lix nimal lix lok'al cuan chi sa'. ");
INSERT INTO kekNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ut quixye re li Jesús: —Chixjunil a'in tinq'ue a̱cue cui la̱at ta̱cuik'ib a̱cuib chicuu ut tina̱lok'oni.— ");
INSERT INTO kekNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tojo'nak li Jesús quichak'oc ut quixye re: —Elen chicuu la̱at aj tza, xban nak jo'ca'in tz'i̱banbil sa' li Santil Hu: Li Ka̱cua' la̱ Dios ta̱lok'oni ut ca'aj cui' chiru a'an tatc'anjelak. (Dt. 6:13) ");
INSERT INTO kekNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tojo'nak quicanaba̱c xban laj tza ut eb li ángel que'cuulac ut que'c'anjelac chiru. ");
INSERT INTO kekNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nak li Jesús quirabi resil nak laj Juan cuan chi pre̱xil, co̱ Nazaret xcue̱nt Galilea. ");
INSERT INTO kekNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Qui-el Nazaret ut co̱ Capernaum. Ut aran quicana. Li tenamit a'an cuan chire li palau sa' xch'och'eb laj Zabulón ut eb aj Neftalí. ");
INSERT INTO kekNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","A'in quic'ulman jo' quixye li profeta Isaías nak quixye chi jo'ca'in: ");
INSERT INTO kekNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Aran sa' xch'och' laj Zabulón ut sa' xch'och' laj Neftalí, li cuan chire li be li naxic sa' li palau, aran jun pac'al li nima' Jordán, sa' li na'ajej Galilea bar neque'cuan cui' li ma̱cua'eb aj judío, ");
INSERT INTO kekNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","li tenamit chanchan li cuanqueb sa' k'ojyi̱n xban nak inc'a' neque'xnau lix ya̱lal. Chanchan quicutano' nak que'ril nak que'xtau li colba-ib. Chanchan nak cuanqueb sa' jun na'ajej re ca̱mc xban lix ma̱queb nak quicuulac li cutan sa' xya̱nkeb. (Is. 9:1-2) ");
INSERT INTO kekNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Chalen nak quicuulac aran, li Jesús yo̱ chixch'olobanquil li xya̱lal ut quixye: —Chiyot'ek' e̱ch'o̱l ut jalomak e̱c'a'ux xban nak cuulac re xk'ehil nak tinq'uehek' sa' incuanquil xban li Dios. Ut la̱in chic cua̱nk incuanquil sa' xbe̱neb li cualal inc'ajol.— ");
INSERT INTO kekNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Sa' jun cutan nak coxnumek' li Jesús chire li palau cuan Galilea, quirileb cuib li cui̱nk ri̱tz'ineb rib. Li jun, a'an laj Simón. Aj Pedro nayeman re. Li jun chic aj Andrés xc'aba'. Yo̱queb chixq'uebal lix yoy sa' li palau xban nak a'aneb aj chapol car. ");
INSERT INTO kekNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Li Jesús quixye reheb: —Chine̱ta̱ke. Ma̱cua' chic caribc te̱ba̱nu. E̱ras e̱ri̱tz'in ban chic te̱sic' re te'pa̱ba̱nk, chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ut sa' junpa̱t que'xcanab lix yoy ut que'xta̱ke li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Junpa̱t na chic quibe̱c li Jesús nak quixtauheb cui'chic cuibeb li cui̱nk ri̱tz'ineb rib. A'aneb laj Jacobo ut laj Juan. Cuanqueb sa' lix jucub rochben laj Zebedeo lix yucua'eb. Yo̱queb chixxi̱tinquil lix yoy. Ut li Jesús quixbokeb re nak te'xic chirix. ");
INSERT INTO kekNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ut sa' junpa̱t que'xcanab lix yucua'eb ut que'xcanab li jucub ut que'xta̱ke li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ut li Jesús quixbeni chixjunil li na'ajej Galilea. Yo̱ chixc'utbal lix ya̱lal sa' eb li cab li neque'xch'utub cui' ribeb laj judío. Quixch'olob xya̱lal li cha̱bil esilal chirix lix cuanquilal li Dios. Ut yo̱ chixq'uirtesinquil chixjunil li q'uila pa̱y ru chi yajel ut li raylal. ");
INSERT INTO kekNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Quicuulac resil sa' chixjunil li na'ajej Siria li c'a'ru yo̱ chixba̱nunquil li Jesús aran Galilea. Ut que'xc'am riq'uin chixjunileb li yaj. Q'uila pa̱y ru lix yajeleb ut lix raylaleb. Cuan li toj nak'ehin xyajeleb. Ut cuan li cuanqueb ma̱us aj musik'ej riq'uineb ut cuanqueb ajcui' li sic. Ut li Jesús naxq'uirtesiheb. ");
INSERT INTO kekNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ut quita̱ke̱c xbaneb li q'uila tenamit. Cuan li que'chal chak Galilea. Cuan li que'chal chak Decápolis. Cuan li que'chal chak Jerusalén. Cuan li que'chal chak Judea jo' ajcui' jun pac'al li nima' Jordán. ");
INSERT INTO kekNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ut nak quirileb li q'uila tenamit, li Jesús quitake' sa' xbe̱n jun li tzu̱l. Ut nak quic'ojla, eb li yo̱queb chixta̱kenquil que'xch'utub rib riq'uin. ");
INSERT INTO kekNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Qui-oc chixch'olobanquil li xya̱lal chiruheb ut quixye: ");
INSERT INTO kekNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Us xak reheb li neque'rec'a nak cubenak xcuanquileb xban nak eb a'an cua̱nkeb chic rubel lix nimajcual cuanquilal li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Us xak reheb li neque'ya̱bac xban xrahileb xch'o̱l xban nak eb a'an ta̱c'ojoba̱k xch'o̱leb. ");
INSERT INTO kekNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Us xak reheb li tu̱laneb xban nak eb a'an te'e̱chani̱nk re li na'ajej li yechi'inbil reheb xban li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Us xak reheb li te'raj ru xba̱nunquil li ti̱quilal. Chanchan li te'tz'oca̱k ut te'chakik re. Us xak reheb xban nak li Dios ta̱tenk'a̱nk reheb chixba̱nunquil li us. ");
INSERT INTO kekNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Us xak reheb li neque'uxta̱nan u xban nak eb a'an te'uxta̱na̱k ruheb xban li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Us xak reheb li ti̱queb xch'o̱l xban nak eb a'an te'ril ru li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Us xak reheb li neque'xtenk'a ras ri̱tz'in chi cua̱nc sa' tuktu̱quil usilal xban nak eb a'an ralal xc'ajol li Dios te'yehek' reheb. ");
INSERT INTO kekNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Us xak reheb li neque'rahobtesi̱c sa' xc'aba' li ti̱quilal, xban nak eb a'an cua̱nkeb chic rubel lix cuanquilal li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Us xak e̱re nak texhobek' ut texrahobtesi̱k sa' inc'aba' ut ta̱yehek' e̱re c'a'ak re ru chi ma̱usilal chi yal tic'ti'. ");
INSERT INTO kekNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Miraho' e̱ch'o̱l. Chisahok' ban e̱ch'o̱l riq'uin li c'a'ru ta̱uxk e̱re xban nak k'axal nim le̱ k'ajca̱munquil ta̱q'uehek' e̱re sa' choxa. Moco ca'aj cui' ta la̱ex yo̱quex chi c'uluc re li raylal. Jo'can aj ban cui' que'xc'ul li profeta li que'cuan junxil. ");
INSERT INTO kekNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","La̱ex aj pa̱banel chanchanex li atz'am li nac'anjelac arin sa' ruchich'och'. Cui ta li atz'am ta̱sachk xqui'al, ¿c'a' ta raj chic ru ta̱oc cui'? Ma̱c'a' chic ta̱oc cui'. Yal re tz'ekec' aj chic ut re yek'i̱c. ");
INSERT INTO kekNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","La̱ex aj pa̱banel, la̱ex lix cutan saken li ruchich'och'. Junak tenamit cuan sa' xbe̱n junak tzu̱l ma̱ jaruj naru xmukbal. ");
INSERT INTO kekNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Chi moco nalochman junak candil re xq'uebal rubel junak chacach. Naq'ueman ban sa' xbe̱n xna'aj candil re nak tixcutanobresi sa' li cab li cuanqueb cui' chixjunileb. ");
INSERT INTO kekNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Jo'can ajcui' la̱ex. La̱ex lix cutan saken li ruchich'och'. Chic'utu̱nk bi' le̱ cha̱bilal chiruheb le̱ ras e̱ri̱tz'in re nak eb a'an te'xq'ue retal li us nequeba̱nu ut te'xq'ue xlok'al le̱ Yucua' li cuan sa' choxa. ");
INSERT INTO kekNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Me̱c'oxla nak xinchal chixsachbal xcuanquil li chak'rab li quiq'uehe' re laj Moisés chi moco li ac xole'xye li profeta. Inc'a' xinchal chixsachbal xcuanquil a'an. Xinchal ban re nak ta̱tz'aklok ru a'an. ");
INSERT INTO kekNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Relic chi ya̱l tinye e̱re nak ta̱osok' li choxa, ta̱osok' li ruchich'och', ut yal ta jun xle̱tril chi moco junak retalil li chak'rab ta̱sachk xcuanquil. Toj retal talaje'c'ulma̱nk chixjunil. ");
INSERT INTO kekNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Li ani naxk'et li chak'rab, usta nac'utun nak inc'a' nim xcuanquil chiru a'an, ut cui naxc'ut chiru li ras ri̱tz'in xba̱nunquil chi jo'can, li jun a'an k'axal ca'ch'in lix lok'al ta̱q'uehek' re sa' lix nimajcual cuanquilal li Dios. Abanan li ani naxba̱nu chi tz'akal li naxye li chak'rab, ut tixc'ut chiru li ras ri̱tz'in xba̱nunquil chi jo'can, li jun a'an k'axal nim lix lok'al ta̱q'uehek' re sa' lix nimajcual cuanquilal li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Tinye ajcui' e̱re nak cui lix ti̱quilal le̱ ch'o̱l inc'a' tixk'ax ru xti̱quilal xch'o̱leb laj tz'i̱b ut eb laj fariseo, inc'a' tex-oc rubel lix nimajcual cuanquilal li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","E̱rabiom resil li chak'rab nak yebil reheb li kaxe' kato̱n: Ma̱camsi a̱cuas a̱cui̱tz'in. Li ani ta̱camsi̱nk, toj tixtoj rix sa' rakba a̱tin. ");
INSERT INTO kekNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Aban la̱in tinye e̱re lix ya̱lal a'an. Li ani ta̱josk'ok riq'uin li ras ri̱tz'in ta̱rakek' a̱tin sa' xbe̱n. Ut li ani tixtz'ekta̱na li ras ri̱tz'in cuan xma̱c chiru laj rakol a̱tin. Ut li ani tixye xyaj tiox re li ras ri̱tz'in, ma̱re anchal ta̱xic sa' xxamlel li xbalba. ");
INSERT INTO kekNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Jo'can nak cui sa' xq'uebal la̱ mayej chiru li artal ta̱julticok' a̱cue nak ta̱rec'a sa' xch'o̱l la̱ cuas a̱cui̱tz'in nak cuan a̱ma̱c chiru, ");
INSERT INTO kekNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","canab aran la̱ mayej, ut ayu, c'am chak a̱cuib sa' usilal riq'uin la̱ cuas a̱cui̱tz'in, tojo'nak toxa̱k'axtesi la̱ mayej. ");
INSERT INTO kekNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Cui cuan la̱ ch'a'ajquilal riq'uin la̱ cuas a̱cui̱tz'in, yi̱b ru chi junpa̱t. Cui inc'a' nacac'am a̱cuib sa' usilal chi junpa̱t, ma̱re anchal tatxc'am riq'uin laj rakol a̱tin ut a'an tatxtakla sa' tz'alam. ");
INSERT INTO kekNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ut inc'a' tat-e̱lk aran cui inc'a' ta̱toj chixjunil li jo' q'uial te'xpatz' a̱cue. Relic chi ya̱l ninye a̱cue nak tento ta̱c'am a̱cuib sa' usilal riq'uin la̱ cuas a̱cui̱tz'in. ");
INSERT INTO kekNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","E̱rabiom resil nak quiyeman najter: Matmuxuc caxa̱r. ");
INSERT INTO kekNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ut la̱in tinye e̱re nak yalak ani tixca'ya junak ixk re xrahinquil ru, ac xmux ru lix sumlajic xban xrahinquil ru. ");
INSERT INTO kekNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Le̱ najter na'leb tento te̱canab chi junaj cua. Li c'a'ak re ru ta̱q'uehok e̱re chi ma̱cobc, te̱tz'ekta̱na. Cui li xnak' la̱ cuu li cuan sa' a̱nim naq'uehoc a̱cue chi ma̱cobc, us raj nak ta̱cuisi ut ta̱tz'ek. K'axal us nak ta̱sachk li xnak' a̱cuu chiru nak tatxic la̱at sa' xbalba. ");
INSERT INTO kekNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Cui la̱ nim uk' naq'uehoc a̱cue chi ma̱cobc, us raj cui ta̱yoc' ut ta̱tz'ek. K'axal us nak ta̱sachk la̱ cuuk' chiru nak tatxic la̱at sa' xbalba. ");
INSERT INTO kekNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ut yebil ajcui' chi jo'ca'in: Li ani tixjach rib riq'uin li rixakil, tento nak tixyi̱b li hu re xjachbal rib ut tixq'ue re. ");
INSERT INTO kekNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Abanan la̱in ninye e̱re li xya̱lal a'an. Li ani naxjach rib riq'uin li rixakil chi inc'a' xmux ru xsumlajic li ixakilbej, a' li be̱lomej cuan xma̱c nak li ixk a'an tixmux ru xsumlajic. Ut li ani ta̱c'amok re li ixk, li ac xcanaba̱c xban xbe̱lom, li cui̱nk a'an naxmux ru li sumsu. ");
INSERT INTO kekNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","E̱rabiom resil nak quiyehe' reheb le̱ xe'to̱nil yucua' chi jo'ca'in: Li c'a'ak re ru te̱yechi'i xba̱nunquil riq'uin juramento, tento te̱ba̱nu. ");
INSERT INTO kekNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Abanan la̱in tinye e̱re tento te̱ba̱nu li c'a'ru te̱yechi'i ut me̱ba̱nu li juramento chi ma̱c'a' rajbal. Me̱patz' xc'aba' li choxa xban nak a'an xna'aj li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ut me̱patz' xc'aba' li ruchich'och' xban nak a'an xna'aj li rok. Ut me̱patz' xc'aba' li tenamit Jerusalén xban nak a'an xtenamit li nimajcual Dios, li tz'akal Rey. ");
INSERT INTO kekNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Chi moco te̱ba̱nu li juramento sa' xc'aba' le̱ jolom xban nak la̱ex inc'a' naru te̱sakobresi le̱ rismal chi moco naru te̱k'ekobresi. ");
INSERT INTO kekNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Jo'ca'in ban te̱ba̱nu. Cui te̱ye nak ya̱l, junes ya̱l te̱ye. Ut cui te̱ye nak inc'a', junes inc'a' te̱ye. Cui te̱q'ue xtz'akob li a̱tin a'an, li na'leb a'an riq'uin laj tza nachal. ");
INSERT INTO kekNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","E̱rabiom resil nak quiyehe' chi jo'ca'in najter: Cui ani ta̱risi xnak' a̱cuu, ta̱isi̱k ajcui' li xnak' ru a'an. Cui ani ta̱risi li ruch a̱cue, ta̱isi̱k ajcui' li re a'an. ");
INSERT INTO kekNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Abanan la̱in tinye e̱re: Me̱sume ma̱usilal riq'uin ma̱usilal. Cui junak tixq'ue junak ruk' sa' a̱cuu, q'ue cui'chic chixsac' li jun pac'al. ");
INSERT INTO kekNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Li ani ta̱raj tatxc'am riq'uin laj rakol a̱tin ut ta̱raj xmak'bal la̱ cami̱s, q'ue ajcui' la̱ chaque̱t re. ");
INSERT INTO kekNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Cui ani ta̱minok a̱cuu chixc'ambal li ri̱k jun kilómetro, c'am cuibak kilómetro la̱at. ");
INSERT INTO kekNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Li ani tixtz'a̱ma c'a'ru re a̱cue, q'ue re. Ut li ani ta̱ajok to'oni̱nc a̱cuiq'uin, ma̱k'etk'eti a̱cuib chiru. ");
INSERT INTO kekNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","E̱rabiom resil nak te̱ra li ani narahoc e̱re ut xic' te̱ril li xic' na-iloc e̱re. ");
INSERT INTO kekNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Abanan la̱in tinye e̱re, cherahak li xic' na-iloc e̱re. Chetz'a̱ma usilal sa' xbe̱neb li neque'hoboc e̱re. Cheba̱nuhak li us reheb li xic' neque'iloc e̱re ut chextijok chirix li neque'ba̱nun ma̱usilal e̱re ut neque'rahobtesin e̱re. ");
INSERT INTO kekNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Cui te̱ba̱nu chi jo'can, la̱exak ralal xc'ajol le̱ Yucua' cuan sa' choxa. A'an naq'uehoc chak li sak'e sa' xbe̱neb li useb xna'leb jo' ajcui' li inc'a' useb xna'leb. Ut a'an ajcui' naq'uehoc chak li hab sa' xbe̱neb li ti̱queb xch'o̱l jo' ajcui' li inc'a' ti̱queb xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Cui ca'aj cui' li neque'rahoc e̱re nequera, ¿c'a'ru le̱ k'ajca̱munquil te̱c'ul? ¿Ma inc'a' ta bi' jo'can ajcui' neque'xba̱nu eb laj titz'ol toj, li neque'balak'in? ");
INSERT INTO kekNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ut cui ca'aj cui' le̱ rech tenamitil nequeq'ue xsahil xch'o̱leb, ¿c'a'ru rusil a'an? ¿Ma inc'a' ta bi' jo'can ajcui' neque'xba̱nu li inc'a' neque'xpa̱b li Dios? ");
INSERT INTO kekNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ti̱cak bi' e̱ch'o̱l jo' le̱ Yucua' li cuan sa' li choxa ti̱c xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Cheq'uehak retal c'a'ru nequeba̱nu. Cui la̱ex te̱ba̱nu li usilal yal re nak tex-ilek' jo' neque'xba̱nu eb laj fariseo, ma̱c'a'ak le̱ k'ajca̱munquil riq'uin le̱ Yucua' cuan sa' choxa. ");
INSERT INTO kekNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ut nak ta̱si li c'a'ak re ru re li ani ta̱raj tenk'a̱c, ma̱ba̱nu jo' neque'xba̱nu laj ca'pac'al u. Eb a'an neque'xic sa' li cab li neque'xch'utub cui' ribeb laj judío ut sa' eb li c'ayil chixyebal resil li usilal neque'xba̱nu re nak te'q'uehek' xlok'al xbaneb li cui̱nk. Relic chi ya̱l tinye e̱re nak eb a'an ac xe'xc'ul lix k'ajca̱munquil nak que'q'uehe' xlok'al xbaneb li cui̱nk. ");
INSERT INTO kekNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Li c'a'ru ta̱si re li ma̱c'a' cuan re, ma̱ ani aj e ta̱serak'i li c'a'ru xasi, chi moco ta̱serak'i re li tz'akal a̱cuami̱g. ");
INSERT INTO kekNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Chaba̱nu ban chi mukmu ut la̱ yucua' li naxnau chixjunil li c'a'ak re ru nacaba̱nu, a'an li ta̱k'ajca̱mu̱nk a̱cue. ");
INSERT INTO kekNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ut nak textijok moco jo'cakex ta eb laj ca'pac'al u. Eb a'an neque'xxakab chak ribeb chi tijoc sa' eb li cab li neque'xch'utub cui' ribeb laj judío ut neque'xxakab rib chi tijoc sa' xala̱ be yal re nak te'ilek'. Relic chi ya̱l tinye e̱re nak eb a'an ac xe'xc'ul lix k'ajca̱munquileb nak que'q'uehe' xlok'al xbaneb li cui̱nk. ");
INSERT INTO kekNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ut nak textijok la̱ex, ocankex sa' le̱ rochoch, tz'apomak re li cab, ut tijonkex chiru le̱ Yucua' li inc'a' na-ilman ru. Ut le̱ Yucua' li naril chixjunil li c'a'ru nequeba̱nu, a'an ta̱k'ajca̱mu̱nk e̱re. ");
INSERT INTO kekNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ut nak textijok, me̱ye q'uila a̱tin chi ma̱c'a' rajbal jo' neque'xba̱nu li inc'a' neque'xpa̱b li Dios. Eb a'an neque'xc'oxla nak riq'uin li q'uila a̱tin, te'abi̱k xban li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Me̱juntak'e̱ta bi' e̱rib riq'uin eb a'an xban nak le̱ Yucua' naxnau c'a'ru nac'anjelac e̱re chi toj ma̱ji' nequetz'a̱ma chiru. ");
INSERT INTO kekNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ut la̱ex jo'ca'in nak textijok: At Ka̱cua', cuancat sa' li santil choxa, lok'oninbilak taxak la̱ santil c'aba'. ");
INSERT INTO kekNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Chicha̱lk ta la̱ nimajcual cuanquilal. Chi-uxk ta li nacacuaj, jo' sa' choxa jo' ajcui' sa' ruchich'och'. ");
INSERT INTO kekNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Chaq'ue taxak ke li kacua kuc'a chi cuulaj cuulaj. ");
INSERT INTO kekNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ut chacuy chasach ta li kama̱c jo' nak nakacuyeb xma̱c li neque'ma̱cob chiku. ");
INSERT INTO kekNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ut moa̱q'ue taxak chi a̱le̱c. Choa̱col ban chiru li inc'a' us. A̱cue li nimajcual cuanquil, li lok'oni̱c ut li lok'al chi junelic k'e cutan. Jo'can taxak. ");
INSERT INTO kekNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Cui nequecuy xma̱queb le̱ ras e̱ri̱tz'in, tixcuy ajcui' e̱ma̱c la̱ex le̱ Yucua' cuan sa' choxa. ");
INSERT INTO kekNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Cui inc'a' nequecuy xma̱queb le̱ ras e̱ri̱tz'in, jo'can ajcui' la̱ex inc'a' ta̱cuyek' e̱ma̱c xban le̱ Yucua' cuan sa' choxa. ");
INSERT INTO kekNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ut nak te̱ba̱nu le̱ ayu̱n, me̱ba̱nu jo' neque'xba̱nu laj ca'pac'al u. Eb a'an neque'xba̱nu rib nak raheb sa' xch'o̱l yal re nak ta̱na'ek' nak yo̱queb xba̱nunquil lix ayu̱n. Relic chi ya̱l tinye e̱re nak eb a'an ac xe'xc'ul lix k'ajca̱munquil. ");
INSERT INTO kekNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","A'ut la̱ex nak te̱ba̱nu le̱ ayu̱n, te̱ch'aj le̱ ru ut te̱yi̱b e̱rib chi us, ");
INSERT INTO kekNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","re nak inc'a' ta̱c'utu̱nk chiruheb le̱ ras e̱ri̱tz'in nak yo̱quex chi ayunic. Chic'utu̱nk ban chiru le̱ Yucua' li inc'a' na-ilman ru. Ut le̱ Yucua' li naxnau chixjunil li nequeba̱nu, a'an ta̱k'ajca̱mu̱nk e̱re. ");
INSERT INTO kekNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Me̱q'ue e̱ch'o̱l chixc'u̱lanquil e̱biomal sa' ruchich'och' bar cui' namaxen ut nak'olen ru ut bar cui' neque'oc laj e̱lk' chi elk'ac. ");
INSERT INTO kekNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Q'uehomak ban e̱ch'o̱l chirix le̱ biomal cuan sa' choxa bar cui' inc'a' namaxen chi moco nak'olen ru ut bar cui' inc'a' ta̱elk'a̱k. ");
INSERT INTO kekNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Jo'can nak chenauhak nak bar cuan cui' le̱ biomal, aran ajcui' cua̱nk le̱ c'a'ux. ");
INSERT INTO kekNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Li xnak' e̱ru chanchan jun li lámpara. Xban nak na-iloc li xnak' e̱ru, cuanquex sa' cutan. Chanchan le̱ na'leb. Cui cha̱bil le̱ na'leb, cuanquex sa' cutan saken. ");
INSERT INTO kekNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Cui ut inc'a' saken na-iloc li xnak' e̱ru, cuanquex sa' k'ojyi̱n. Ut jo'can ajcui' le̱ na'leb. Cui inc'a' cha̱bil le̱ na'leb xban nak junes le̱ biomal nequec'oxla, cuanquex sa' xk'ojyi̱nal ru li ma̱c. ");
INSERT INTO kekNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ma̱ ani naru nac'anjelac chiru cuib chi patrón. Naru tixra li jun ut tixtz'ekta̱na li jun chic malaj ut xic' ta̱ril li jun ut tix-oxlok'i li jun chic. Jo'can nak ma̱ jok'e naru te̱c'oxla li Dios cui ca'aj cui' le̱ biomal nequec'oxla. ");
INSERT INTO kekNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jo'can ut nak ninye e̱re: Mixic e̱ch'o̱l chirix le̱ cua e̱ruc'a chi moco chirix chanru te̱tikib e̱rib. ¿Ma inc'a' ta bi' k'axal lok' li kayu'am chiru li c'a'ru takatzaca? ¿Ma inc'a' ta bi' k'axal lok' li kayu'am chiru li kak'? ");
INSERT INTO kekNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Cheq'uehak retal li xul li neque'rupupic chiru choxa. Eb a'an inc'a' neque'au, chi moco neque'k'oloc chi moco neque'xxoc xtzacae̱mk sa' c'u̱leba̱l. Ut le̱ Yucua' cuan sa' choxa, a'an naq'uehoc xcuaheb. ¿Ma inc'a' ta bi' k'axal raro̱quex la̱ex chiruheb a'an? ");
INSERT INTO kekNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Ani e̱re la̱ex ta̱ru̱k tixtik ru lix yu'am usta naxic xch'o̱l xc'oxlanquil? ");
INSERT INTO kekNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿C'a'ut nak naxic e̱ch'o̱l chi c'oxlac chirix le̱ rak'? Q'uehomak retaleb li utz'u'uj sa' pim chanru nak neque'q'ui chi inc'a' neque'c'anjelac chi moco neque'quemoc. ");
INSERT INTO kekNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","A'ut la̱in tinye e̱re, usta c'ajo' xchak'al ru lix tikibanquil laj Salomón, abanan inc'a' quixtau xchak'al ru li utz'u'uj a'in. ");
INSERT INTO kekNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","La̱ex inc'a' nequexpa̱ban chi tz'akal. Ut cui li Dios naxq'ue lix ch'ina'usal li pim li cuan junpa̱t ajcui' ut cuulaj q'uebilak sa' xam, ¿ma toja' ta chic la̱ex inc'a' textikib? ");
INSERT INTO kekNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Jo'can ut nak moco yo̱kex ta chixyebal: ¿C'a'ru takatzaca anakcuan? chi moco, ¿c'a'ru takatikib cui' kib? ");
INSERT INTO kekNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Li inc'a' neque'xpa̱b li Dios neque'xq'ue xch'o̱l xc'oxlanquil a'an. Abanan le̱ Yucua' li cuan sa' choxa naxnau li c'a'ru nequeraj ru. ");
INSERT INTO kekNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Li c'a'ru li te̱sic' xbe̱n cua, a'an lix nimajcual cuanquilal li Dios ut lix ti̱quilal, ut chixjunil li c'a'ak re ru a'in talajq'uehek' e̱re chok' xtz'akob. ");
INSERT INTO kekNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Jo'can ut nak mexc'oxlac chirix li cutan re cuulaj xban nak a'an ta̱c'oxlama̱nk ajcui' cuulaj. Tz'akalak riq'uin li ch'a'ajquilal li naxc'am chak li junju̱nk chi cutan. ");
INSERT INTO kekNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ma̱ ani te̱tz'il a̱tin chirix re nak inc'a' ta̱tz'ilek' a̱tin che̱rix la̱ex. ");
INSERT INTO kekNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Xban nak chanru nak nequextz'iloc a̱tin, jo'can ajcui' ta̱uxk e̱re la̱ex. Ut riq'uin li bisleb li nequexbisoc cui', riq'uin ajcui' a'an texbisek' la̱ex. ");
INSERT INTO kekNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿C'a'ut nak nacaq'ue retal li c'aj che' cuan sa' xnak' ru la̱ cuas a̱cui̱tz'in ut inc'a' nacacuil li tz'amba cuan sa' xnak' a̱cuu la̱at? ");
INSERT INTO kekNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Chanru nak ta̱ye re la̱ cuas a̱cui̱tz'in: “Cuisihak li c'aj che' sa' xnak' a̱cuu”, ut toj cuan li tz'amba sa' xnak' a̱cuu la̱at? ");
INSERT INTO kekNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","At aj ca'pac'al u, xbe̱n cua isi li tz'amba cuan sa' li xnak' a̱cuu, tojo'nak tat-ilok chi tz'akal re risinquil li c'aj che' cuan sa' xnak' ru la̱ cuas a̱cui̱tz'in. ");
INSERT INTO kekNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Me̱q'ue reheb li tz'i' li c'a'ru k'axal lok' xban nak naru neque'chal sa' e̱be̱n ut textiu. Chi moco te̱q'ue li pec li k'axal terto xtz'ak chiruheb li a̱k re te'xyek'i. ");
INSERT INTO kekNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Nak ta̱paltok c'a'ru e̱re, chextz'a̱ma̱nk chiru li Dios ut a'an tixq'ue e̱re; chesic'ak ut te̱tau, chebokak ut li puerta ta̱tehek' che̱ru. ");
INSERT INTO kekNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Cheba̱nu a'an xban nak li ani natz'a̱man chiru li Dios naq'uehe' re. Li ani naxsic', naxtau. Ut li ani nabokoc, li puerta natehe' chiru. ");
INSERT INTO kekNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Ma cuan ta bi' junak yucua'bej sa' e̱ya̱nk tixq'ue junak pec re li ralal nak tixpatz' xcua re? ");
INSERT INTO kekNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ut nak tixpatz' junak xcar re, ¿ma c'anti' ta bi' tixq'ue re? ");
INSERT INTO kekNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Cui la̱ex li moco cha̱bilex ta nequenau xq'uebal li c'a'ru cha̱bil re le̱ ralal e̱c'ajol, ¿ma toja' ta chic le̱ Yucua' li cuan sa' choxa inc'a' tixq'ue li k'axal cha̱bil re li ani tixtz'a̱ma chiru? ");
INSERT INTO kekNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Jo'can nak li c'a'ru nequeraj la̱ex nak te'xba̱nu raj le̱ ras e̱ri̱tz'in, cheba̱nuhak la̱ex reheb a'an, xban nak a'an a'in xya̱lal li chak'rab li quiq'uehe' re laj Moisés, ut a'an ajcui' li xya̱lal lix yehomeb li profeta. ");
INSERT INTO kekNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Chex-oc sa' li oqueba̱l li ca'ch'in ru xban nak nim ru li oqueba̱l ut nim ru li be li naxic sa' li tojba ma̱c ut nabaleb li neque'xic aran. ");
INSERT INTO kekNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Abanan li oqueba̱l ut li be li naxic sa' li junelic yu'am, a'an ca'ch'in ru ut inc'a' q'uiheb li neque'oc aran. ");
INSERT INTO kekNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Chenauhak xcolbal e̱rib chiruheb li profeta aj balak'. Chanchan nak cha̱bileb jo' li carner nak neque'c'utun. Abanan moco ya̱l ta. Chanchaneb li josk' aj xoj nak neque'chal chi balak'i̱nc. ");
INSERT INTO kekNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Yal riq'uin lix na'lebeb te̱nau ruheb. La̱ex nequeq'ue retal nak li q'uix inc'a' naru̱chin li uva ut li tun q'uix inc'a' naru̱chin li higo. ");
INSERT INTO kekNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Jo'can nak li cha̱bil che', cha̱bil ajcui' li ru naxq'ue. Ut li che' li inc'a' us, inc'a' ajcui' us li ru naxq'ue. ");
INSERT INTO kekNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Li cha̱bil che' inc'a' naru naru̱chin li inc'a' us, chi moco li che' inc'a' us naru̱chin li cha̱bil. ");
INSERT INTO kekNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Chixjunil li che' li inc'a' cha̱bil li ru naxq'ue nayoc'man ut naq'ueman sa' xam. ");
INSERT INTO kekNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Jo'can ut nak riq'uin lix na'lebeb li profeta te̱nau ru aniheb. ");
INSERT INTO kekNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Moco chixjunileb ta li neque'yehoc “Ka̱cua', Ka̱cua'” cue, te'oc sa' lix nimajcual cuanquilal li Dios. Aban li neque'ba̱nun re li naraj lin Yucua' cuan sa' choxa, a'aneb li te'oc sa' lix nimajcual cuanquilal li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nabaleb li te'yehok cue sa' xk'ehil li rakba a̱tin, “Ka̱cua', Ka̱cua', ¿ma ma̱cua' ta bi' sa' a̱c'aba' coa̱tinac jo' profeta? ¿Ma ma̱cua' ta bi' sa' a̱c'aba' co-isin ma̱us aj musik'ej? La̱o nabal li milagro quilajkaba̱nu sa' a̱c'aba'”, cha'keb. ");
INSERT INTO kekNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ut la̱in tinye reheb, “La̱ex ma̱cua'ex cualal inc'ajol. La̱in inc'a' ninnau e̱ru. Elenkex chicuu, ex aj ba̱nuhom ma̱usilal.” ");
INSERT INTO kekNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jo'can nak yalak ani ta̱abi̱nk reheb li cua̱tin a'in ut cui tixba̱nu li c'a'ru xinye, li jun a'an tinjuntak'e̱ta riq'uin li cui̱nk cuan xna'leb li quixyi̱b li rochoch sa' xbe̱n pec. ");
INSERT INTO kekNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ut quichal li hab ut quicuan li but'i ha', ut quichal li cak-sut-ik'. Coxsac' rib chiru li cab a'an, ut inc'a' quit'ane' li cab xban nak yi̱banbil chi us sa' xbe̱n pec. ");
INSERT INTO kekNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ut yalak ani ta̱abi̱nk re li cua̱tin ut inc'a' tixba̱nu li c'a'ru xinye, li jun a'an tinjuntak'e̱ta riq'uin li cui̱nk li ma̱c'a' xna'leb. Inc'a' quixyi̱b li rochoch chi cha̱bil. Yal sa' xbe̱n samaib quixq'ue. ");
INSERT INTO kekNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ut quichal li hab, quicuan li but'i ha' ut quichal li cak-sut-ik'. Coxsac' rib chiru ut li cab a'an quit'ane' ut aran qui-oso'. ");
INSERT INTO kekNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ut nak quirake' li Jesús chixyebal li a̱tin a'in, sachso̱queb xch'o̱l que'cana li q'uila tenamit chirabinquil li c'a'ru yo̱ chixyebal. ");
INSERT INTO kekNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Que'sach xch'o̱leb xban nak quixc'ut chi tz'akal li xya̱lal chiruheb riq'uin xcuanquil ut moco jo' ta eb laj tz'i̱b. ");
INSERT INTO kekNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nak quicube chak li Jesús chiru li tzu̱l, quita̱ke̱c xbaneb li q'uila tenamit. ");
INSERT INTO kekNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ut quichal jun li saklep rix ut quixcuik'ib rib chiru li Jesús ut quixye re: —Ka̱cua', la̱in ninnau nak la̱at naru tina̱q'uirtesi. Cui ta̱ba̱nu li usilal, china̱q'uirtesi, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Li Jesús quixye' li ruk', quixch'e' li cui̱nk ut quixye re: —Nacuaj a̱q'uirtesinquil. Anakcuan tatinq'uirtesi, chan. Ut sa' junpa̱t quiq'uira li saklep rix. ");
INSERT INTO kekNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tojo'nak li Jesús quixye re: —Abi li tinye a̱cue. Ma̱ ani aj e ta̱serak'i li xac'ul. Ayu ban ut c'ut a̱cuib chiru laj tij. Ut ta̱q'ue li mayej jo' naxye sa' lix chak'rab laj Moisés re xc'utbal chiruheb nak xatq'uira.— (Lv. 13:49) ");
INSERT INTO kekNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ut nak quicuulac li Jesús aran Capernaum, quichal jun li capitán aj Roma riq'uin. Quixtz'a̱ma usilal chiru ut quixye re: ");
INSERT INTO kekNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Ka̱cua', lin mo̱s t'ant'o sa' cab. Sic ut k'axal ra cuan, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Li Jesús quichak'oc ut quixye re: —Tinxic la̱in ut toxinq'uirtesi.— ");
INSERT INTO kekNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Li capitán quixye re li Jesús: —Ka̱cua', moco inc'ulub ta nak tatxic sa' li cuochoch. Ca'aj cui' nacuaj nak ta̱ye nak ta̱q'uira̱k lin mo̱s ut ninnau nak ta̱q'uira̱k. ");
INSERT INTO kekNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","La̱in ninnau nak naru ta̱ba̱nu a'an xban nak la̱in cuan ani nataklan cue ut cuanqueb lin soldado rubel lin cuanquil. Ut ninye re li jun, “ayu” ut naxic. Ut ninye re li jun chic, “quim”, ut nachal. Ut ninye re lin mo̱s, “ba̱nu a'in”, ut naxba̱nu, chan li capitán. ");
INSERT INTO kekNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ut nak li Jesús quirabi li quixye, quisach xch'o̱l ut quixye reheb li yo̱queb chi ochbeni̱nc re: —Relic chi ya̱l tinye e̱re nak ma̱ jun intauhom chi moco sa' xya̱nkeb laj Israel tz'akal re ru xpa̱ba̱l jo' li jun a'in, usta ma̱cua' aj judío. ");
INSERT INTO kekNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ut la̱in tinye e̱re nak nabaleb li ma̱cua'eb aj judío yalak bar sa' ruchich'och' te'pa̱ba̱nk. Ut eb a'an te'e̱chani̱nk re lix nimajcual cuanquilal li Dios rochbeneb laj Abraham, laj Isaac, ut laj Jacob. ");
INSERT INTO kekNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","A'ut nabaleb laj judío li te'e̱chani̱nk raj re lix nimajcual cuanquilal li Dios, eb a'an chic li te'isi̱k ut te'q'uehek' sa' li k'ojyi̱n. Ut aran ta̱cua̱nk li ya̱bac ut li c'uxuxi̱nc ruch e, chan li Jesús reheb li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tojo'nak li Jesús quixye re li capitán: —Ayu sa' la̱ cuochoch. Chanru nak xapa̱b, jo'can ajcui' nak chi-uxk li c'a'ru xatz'a̱ma, chan. Ut sa' ajcui' li ho̱nal a'an quiq'uira lix mo̱s li capitán. ");
INSERT INTO kekNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ut quicuulac li Jesús sa' rochoch laj Pedro. Ut aran quixtau lix na' li rixakil laj Pedro yocyo sa' xch'a̱t ut yo̱ xtik. ");
INSERT INTO kekNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ut li Jesús quixchap li ruk' ut quinume' lix tik. Ut a'an quicuacli, ut quic'anjelac chiru. ");
INSERT INTO kekNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nak ac oc re li k'ojyi̱n, nabaleb li cristian que'c'ame' chak riq'uin li Jesús. Cuanqueb ma̱us aj musik'ej riq'uineb. Ut yal riq'uin ra̱tin, li Jesús quirisi li ma̱us aj musik'ej riq'uineb, ut quixq'uirtesi chixjunileb li yaj. ");
INSERT INTO kekNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","A'in quic'ulman jo' quixye li profeta Isaías, nak quixye chi jo'ca'in: A'an quic'amoc re li kayajel, ut a'an quic'uluc re li karaylal. (Is. 53:4) ");
INSERT INTO kekNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ut nak quiril li Jesús nak sutsu xbaneb li q'uila tenamit, quixye: —Tento toxic jun pac'al li palau, chan reheb lix tzolom. ");
INSERT INTO kekNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ut sa' li ho̱nal a'an quicuulac riq'uin li Jesús jun aj tz'i̱b ut quixye re: —At tzolonel, tincuaj a̱ta̱kenquil yalak bar tatxic, chan re. ");
INSERT INTO kekNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ut li Jesús quichak'oc ut quixye re: —C'oxla chi us ma ta̱cuy inta̱kenquil. Li yac cuanqueb xjul sa' pec, ut li xul li neque'rupupic chiru choxa cuanqueb xsoc, abanan la̱in li C'ajolbej ma̱c'a' inna'aj bar ta̱ru̱k tinyocob cui' cuib, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ut jun reheb lix tzolom quixye re li Jesús: —Ka̱cua', china̱cuy. Inmukak cuan inyucua' tojo'nak tinxic cha̱cuix, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ut li Jesús quixye re: —Ta̱kehin, canabeb li toj camenakeb sa' li ma̱c xmukakeb cuan lix camenak, chan re. ");
INSERT INTO kekNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ut li Jesús qui-oc sa' li jucub rochbeneb lix tzolom. ");
INSERT INTO kekNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nak ac cuanqueb chiru ha', sa' junpa̱t quichal jun li nimla cak-sut-ik'. Ut yo̱ chi oc lix cau ok li ha' sa' li jucub. Ut li Jesús sa xcuara. ");
INSERT INTO kekNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Eb lix tzolom que'jiloc riq'uin, que'rajsi, ut que'xye re: —Ka̱cua', choa̱col. Osoc' ke, chanqueb re. ");
INSERT INTO kekNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ut li Jesús quichak'oc ut quixye: —La̱ex inc'a' nequexpa̱ban chi tz'akal. Jo'can nak nequexxucuac, chan reheb. Tojo'nak quicuacli, quixk'us li ik', ut li palau, ut sa' junpa̱t quich'ana li ik' ut quitukla ru li ha'. ");
INSERT INTO kekNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ut c'ajo' nak que'sach xch'o̱l lix tzolom nak que'ril li quixba̱nu ut que'xye chi ribileb rib: —¿Chanru nak cuan xcuanquil li cui̱nk a'in nak naxk'us li ik' ut li palau ut neque'abin chiru? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ut nak ac xk'axon li Jesús jun pac'al li palau sa' xch'och'eb laj Gadara, cuib li cui̱nk que'chal chixc'ulbal. Que'chal chak sa' li na'ajej bar neque'muke' cui' li camenak. Cuan ma̱us aj musik'ej riq'uineb. K'axal xiu xiu rilbaleb ut ma̱ ani naru nanume' sa' li be a'an. ");
INSERT INTO kekNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ut eb a'an que'xjap re chixyebal: —¿C'a'ru ta̱cuaj kiq'uin, at Jesús? La̱at ralalat li nimajcual Dios. ¿Ma xatchal arin chikach'i'ch'i'inquil chi toj ma̱ji' xk'ehil li rakba a̱tin? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ut najt ca'ch'in riq'uineb cuan chak jun tu̱b li a̱k, yo̱queb chi ichajibc. ");
INSERT INTO kekNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ut eb li ma̱us aj musik'ej que'xtz'a̱ma chiru li Jesús ut que'xye re: —Cui toa̱cuisi riq'uineb li cui̱nk a'in, choa̱canab chi oc riq'uineb li jun tu̱b chi a̱k li cuanqueb aran. ");
INSERT INTO kekNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ut li Jesús quichak'oc ut quixye reheb: —Ayukex. Ut eb a'an que'el ut co̱eb riq'uineb li jun tu̱b chi a̱k. Ut eb li a̱k que'oc chi a̱linac ut que'xrum chak rib sa' xbe̱n u̱l ut toj sa' li palau coxe'nak ut aran que'oso'. ");
INSERT INTO kekNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ut eb laj ilol a̱k que'xucuac ut que'co̱eb sa' a̱nil sa' li tenamit chixyebal resil chixjunil li c'a'ru quic'ulman. Ut que'xserak'i li c'a'ru quic'ulman riq'uineb li cui̱nk li cuanqueb ma̱us aj musik'ej riq'uineb. ");
INSERT INTO kekNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ut chixjunileb li tenamit que'el chak chixc'ulbal li Jesús. Ut nak que'ril ru, que'xtz'a̱ma chiru nak chie̱lk sa' lix tenamiteb. ");
INSERT INTO kekNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ut li Jesús qui-oc cui'chic sa' jun li jucub ut quik'axon jun pac'al li palau ut quicuulac sa' lix tenamit. ");
INSERT INTO kekNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ut aran que'xc'am riq'uin li Jesús jun li cui̱nk sic li rok ut sic li ruk' yocyo chiru xcuarib. Ut li Jesús quixq'ue retal nak eb li cui̱nk a'an neque'xpa̱b nak naru tixq'uirtesi li yaj. Jo'can nak quixye re li yaj: —At cui̱nk cauhak taxak a̱ch'o̱l. Ac xcuyman xsachman la̱ ma̱c.— ");
INSERT INTO kekNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ut cuanqueb junju̱nk sa' xya̱nkeb laj tz'i̱b yo̱queb chixyebal sa' xch'o̱leb: —Li cui̱nk a'in naxjuntak'e̱ta rib riq'uin li Dios, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Li Jesús ac naxnau li c'a'ru yo̱queb chixc'oxlanquil ut quixye reheb: —¿C'a'ut nak yo̱quex chixc'oxlanquil li inc'a' us? ");
INSERT INTO kekNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Bar cuan li us tinye re li yaj re nak ta̱c'utu̱nk che̱ru nak cuan incuanquil? ¿Ma tinye re, “Cuybil sachbil la̱ ma̱c” malaj ut tinye re, “Cuaclin ut be̱n”? ");
INSERT INTO kekNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","La̱in tinc'ut che̱ru nak la̱in li Cristo li C'ajolbej ut cuan incuanquil sa' ruchich'och' chixcuybal xsachbal li ma̱c, chan. Jo'can nak quixye re li yaj: —Cuaclin, c'am la̱ ch'a̱t ut ayu sa' la̱ cuochoch, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tojo'nak quicuacli li cui̱nk ut co̱ sa' rochoch. ");
INSERT INTO kekNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nak li q'uila tenamit que'ril li quic'ulman, que'xucuac ut que'xq'ue xlok'al li Dios li quiq'uehoc chak xcuanquil li Jesús chi q'uirtesi̱nc ut chi cuyuc ma̱c. ");
INSERT INTO kekNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ut li Jesús qui-el aran Capernaum ut quinume' sa' li na'ajej bar neque'c'uluc cui' toj. Quiril jun li cui̱nk aj Mateo xc'aba'. C'ojc'o aran xban nak a'an aj titz'ol toj. Ut li Jesús quixye re: —China̱ta̱ke.— Ut laj Mateo quicuacli ut quixta̱ke. ");
INSERT INTO kekNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ut chirix a'an li Jesús co̱ sa' li rochoch laj Mateo chi cua'ac. C'ojc'o sa' me̱x rochbeneb lix tzolom nak que'cuulac nabaleb laj titz'ol toj rochbeneb nabaleb chic li rech aj ma̱quil. Ut que'c'ojla sa' me̱x chi cua'ac rochben li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ut nak que'ril a'an, eb laj fariseo que'xye reheb lix tzolom li Jesús: —¿C'a'ut nak nacua'ac laj tzolol e̱re rochbeneb laj titz'ol toj ut rochbeneb laj ma̱c? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nak quirabi li c'a'ru quipatz'e' reheb lix tzolom, li Jesús quixye: —Li cauheb ma̱c'a' na-oc cui' aj banonel reheb. Aban li yajeb, a'aneb li te'raj banec'. ");
INSERT INTO kekNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Cheq'uehak bi' e̱ch'o̱l chixtaubal ru li xya̱lal li a̱tin a'in: “li k'axal lok' chicuu, a'an li uxta̱na̱nc u ut ma̱cua' li mayejac xul”. La̱in inc'a' xinchal chixsic'bal li ti̱queb xch'o̱l. Xinchal ban chixsic'baleb laj ma̱c re nak te'yot'ek' xch'o̱l te'xjal xc'a'ux, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ut que'cuulac lix tzolom laj Juan riq'uin li Jesús ut que'xye re: —La̱o nakaba̱nu ka-ayu̱n rajlal ut eb laj fariseos neque'xba̱nu x-ayu̱n. ¿C'a'ut nak la̱ tzolom inc'a' neque'xba̱nu x-ayu̱n? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ut li Jesús quichak'oc ut quixye reheb li tijleb a'in: —¿Ma naru ta bi' nak rahak sa' xch'o̱leb li neque'boke' riq'uin sumla̱c nak toj cuan li be̱lomej sa' xya̱nkeb? La̱in jo' jun li be̱lomej. Ta̱cuulak xk'ehil nak tin-isi̱k sa' xya̱nkeb tojo'nak te'xba̱nu x-ayu̱n eb lin tzolom, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ma̱ ani naxxi̱ti junak k'el t'icr riq'uin ac' t'icr. Cui ut naxxi̱ti riq'uin ac' t'icr nak tixpuch', ta̱c'osk li ac' t'icr ut naxnimobresi xpejelal li k'el t'icr. ");
INSERT INTO kekNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ut ma̱ ani naq'uehoc ac' vino sa' li k'el bo̱ls tz'u̱m. Cui tixq'ue li ac' vino sa' li k'el bo̱ls tz'u̱m, ta̱puq'uek' li k'el tz'u̱m, ta̱hoyek' li vino, ut ta̱osok' ajcui' li bo̱ls tz'u̱m. Li ac' vino sa' ac' bo̱ls tz'u̱m naq'ueman. Chi jo'can ma̱c'a' nasachman, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nak yo̱ chixyebal li c'a'ak re ru a'in reheb, quicuulac riq'uin jun li cui̱nk xcomoneb li xbe̱nil sa' li cab li neque'xch'utub cui' ribeb laj judío. Quixcuik'ib rib chiru li Jesús ut quixye re: —Lin rabin toje' ta̱ca̱mk. Tatxic taxak ut ta̱q'ue raj la̱ cuuk' sa' xbe̱n, ut ta̱yo'la̱k raj cui'chic, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Quicuacli li Jesús ut co̱ chirix rochbeneb lix tzolom. ");
INSERT INTO kekNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ut cuan jun li ixk cablaju chihab xticlajic xyajel. Junelic yo̱ lix yajel li ixk a'an ut inc'a' chic natz'ap lix quiq'uel. Quijiloc chixc'atk li Jesús nak yo̱ chi xic, ut quixch'e' li rak'. ");
INSERT INTO kekNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Usta ca'aj cui' li rak' tinch'e', tinq'uira̱k, chan sa' xch'o̱l li ixk. ");
INSERT INTO kekNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ut li Jesús quixakli ut qui-iloc chirix. Quiril li ixk ut quixye re: —Kana', cauhak taxak a̱ch'o̱l. Xban nak xapa̱b nak cuan incuanquil cha̱q'uirtesinquil, jo'can nak xatq'uira, chan. Ut sa' ajcui' li ho̱nal a'an, li ixk quiq'uira. ");
INSERT INTO kekNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Chirix chic a'an li Jesús co̱ sa' rochoch laj Jairo. Nak quicuulac sa' li rochoch, quirileb li yo̱queb chixya̱basinquil li xo̱lb ut li japjo̱queb re chi ya̱bac xban xcamic li xka'al. ");
INSERT INTO kekNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ut quixye reheb: —Elenkex arin. Li xka'al a'in yal cua̱rc yo̱. Moco camenak ta, chan reheb. Ut li tenamit que'oc chixse'enquil. ");
INSERT INTO kekNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ut nak ac xrisiheb li tenamit chirix cab, li Jesús qui-oc cuan cui' li xka'al ut quixchap chi ruk' ut li xka'al quicuacli cui'chic chi yo'yo. ");
INSERT INTO kekNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ut li c'a'ru quixba̱nu li Jesús, qui-el resil sa' chixjunil li na'ajej a'an. ");
INSERT INTO kekNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ut nak qui-el aran li Jesús, cuib li mutz' yo̱queb chi ta̱ke̱nc re ut japjo̱queb re chixyebal: —Chacuuxta̱na taxak ku, at ralal xc'ajol li rey David.— ");
INSERT INTO kekNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nak ac x-oc li Jesús sa' li cab, que'oc ajcui' li mutz' riq'uin ut li Jesús quixye: —¿Ma nequepa̱b nak cuan incuanquil che̱q'uirtesinquil? chan reheb. Ut eb a'an que'chak'oc ut que'xye: —Nakapa̱b, Ka̱cua'.— ");
INSERT INTO kekNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tojo'nak li Jesús quixch'e' li xnak' ruheb ut quixye: —Chanru nak xepa̱b, jo'can ajcui' nak chi-uxk li c'a'ru te̱raj.— ");
INSERT INTO kekNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ut que'iloc li xnak' ruheb. Ut li Jesús quixye reheb: —Cherabi chi us li c'a'ru tinye e̱re. Ma̱ ani aj iq'uin te̱serak'i li c'a'ru xec'ul, chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ca'aj cui' tz'akal que'el aran nak que'oc chixserak'inquil resil sa' chixjunil li na'ajej a'an li c'a'ru quixba̱nu li Jesús reheb. ");
INSERT INTO kekNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Toje' ajcui' te'e̱lk eb a'an nak quic'ame' chak riq'uin li Jesús jun li cui̱nk mem. Cuan ma̱us aj musik'ej riq'uin. ");
INSERT INTO kekNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Li Jesús quirisi li ma̱us aj musik'ej riq'uin ut li cui̱nk qui-oc chi a̱tinac. C'ajo' nak que'sach xch'o̱l li tenamit ut que'xye: —Ma̱ jun cua kilom a'in sa' li katenamit Israel.— ");
INSERT INTO kekNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Aban eb laj fariseo que'xye: —Riq'uin xcuanquil laj tza narisiheb li ma̱us aj musik'ej li cui̱nk a'an, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ut li Jesús yo̱ xbeninquil sa' eb li tenamit junju̱nk ut sa' eb ajcui' li c'aleba̱l. Quixc'ut li xya̱lal chiruheb sa' li cab li neque'xch'utub cui' ribeb laj judío ut quixch'olob xya̱lal lix nimajcual cuanquilal li Dios chiruheb. Ut yo̱ chixq'uirtesinquil chixjunil li q'uila pa̱y chi yajel ut li raylal. ");
INSERT INTO kekNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ut nak quirileb li q'uila tenamit, quixtok'obaheb ru xban nak tacuajenakeb ut raheb sa' xch'o̱l. Chanchaneb li carner li ma̱c'a' aj ilol reheb. ");
INSERT INTO kekNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tojo'nak quixye reheb lix tzolom, —Relic chi ya̱l nabaleb li inc'a' neque'xnau li xya̱lal. Abanan moco q'uiheb ta li te'xye li xya̱lal reheb. Chanchaneb li ru li acui̱mk li ma̱c'a' aj sic'ol re. ");
INSERT INTO kekNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Jo'can ut tinye e̱re nak te̱tz'a̱ma chiru li Ka̱cua' re nak a'an tixtaklaheb laj c'anjel chixch'olobanquil li xya̱lal chiruheb, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Sa' jun li cutan li Jesús quixbokeb lix tzolom cablaju riq'uin ut quixq'ueheb xcuanquil chirisinquil li ma̱us aj musik'ej ut quixq'ueheb xcuanquil chixq'uirtesinquileb li yaj, a' yalak c'a'ru chi xyajelil ut raylal. ");
INSERT INTO kekNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","A'an a'in lix c'aba'eb lix tzolom cablaju, li quixxakab chok' x-apóstol: li xbe̱n, a'an laj Simón, Pedro nayeman re; ut laj Andrés li ri̱tz'in; laj Jacobo ut laj Juan li ri̱tz'in. Laj Zebedeo, a'an lix yucua'eb; ");
INSERT INTO kekNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","laj Felipe ut laj Bartolomé; laj Tomás ut laj Mateo laj titz'ol toj; laj Jacobo li ralal laj Alfeo ut laj Lebeo aj Tadeo xcab xc'aba', ");
INSERT INTO kekNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","laj Simón aj Canaán, ut laj Judas Iscariote, a' li quik'axtesin re li Jesús sa' ruk'eb li xic' neque'iloc re. ");
INSERT INTO kekNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Nak quixtaklaheb li cablaju a'in chi c'anjelac, li Jesús quixchak'rabiheb ut quixye reheb: —Mexxic sa' lix tenamiteb li ma̱cua'eb aj judío chi moco tex-oc sa' xtenamiteb aj Samaria. ");
INSERT INTO kekNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Texxic ban riq'uineb laj judío. A'aneb li ralal xc'ajol laj Israel. Chanchaneb li carner li sachenakeb. ");
INSERT INTO kekNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ut nak yo̱kex chi xic, yo̱kex chixch'olobanquil li xya̱lal ut chixyebal, “cuulac re xk'ehil nak ta̱q'uehek' sa' xcuanquil xban li Dios li ta̱cua̱nk xcuanquil sa' xbe̱neb li ralal xc'ajol,” cha'kex. ");
INSERT INTO kekNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Cheq'uirtesiheb li yaj, checuaclesiheb cui'chic chi yo'yo li camenak. Cheq'uirtesiheb li saklep rix ut cherisiheb li ma̱us aj musik'ej. Chi ma̱tan xec'ul le̱ cuanquil ut chi ma̱tan ajcui' te̱ba̱nu li usilal. ");
INSERT INTO kekNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ma̱c'a' c'a'ru te̱c'am che̱rix. Inc'a' te̱c'am li oro chi moco li plata, chi moco li coc' tumin k'an ru. ");
INSERT INTO kekNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Chi moco te̱c'am xna'aj li c'a'ak re ru ta̱c'anjelak e̱re sa' be, chi moco te̱c'am xjalbal le̱ rak', chi moco xjalbal e̱xa̱b, chi moco e̱xuk'. Me̱c'am li c'a'ak re ru a'in xban nak laj c'anjel, a'an tento nak ta̱q'uehek' re lix tzacae̱mk. ");
INSERT INTO kekNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ut yalak bar tenamitil ut c'aleba̱l toxex-ocak cui', patz'omak ani ta̱c'uluk e̱re chi sa sa' xch'o̱l, ut aran texhila̱nk riq'uin toja' ya̱l jok'e texxic. ");
INSERT INTO kekNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ut nak tex-oc sa' li cab, q'uehomak xsahil xch'o̱leb ut te̱tz'a̱ma li tuktu̱quil usilal sa' xbe̱neb li cuanqueb sa' li cab. ");
INSERT INTO kekNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ut cui texc'ulek' sa' usilal, ta̱cana̱k riq'uineb li tuktu̱quil usilal. Ut cui inc'a' texc'ulek' sa' usilal, inc'a' ajcui' ta̱cana̱k riq'uineb li tuktu̱quil usilal. Ta̱suk'i̱k cui'chic e̱riq'uin. ");
INSERT INTO kekNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ut yalak ani inc'a' ta̱c'uluk e̱re chi moco ta̱rabi le̱ ra̱tin, nak tex-e̱lk sa' li cab a'an, malaj ut sa' li tenamit, te̱chik'chik'i li poks cuan che̱rok chok' retalil nak inc'a' chic texc'oxlak chirix li na'ajej a'an. ");
INSERT INTO kekNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Relic chi ya̱l tinye e̱re nak toj cubenak ca'ch'in lix tojbal xma̱queb li tenamit Sodoma ut li tenamit Gomorra chiru lix tojbal xma̱queb li tenamit a'an sa' xk'ehil li rakba a̱tin. ");
INSERT INTO kekNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Chenauhak nak la̱in tintakla̱nk e̱re sa' xya̱nkeb li xic' neque'iloc e̱re. Chanchanakex li carner sa' xya̱nkeb laj xoj. Se̱bak e̱ch'o̱l jo'cakex li c'anti' ut ti̱cak e̱ch'o̱l jo'cakex li paloma. ");
INSERT INTO kekNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Cauhak le̱ ch'o̱l xban nak cuanqueb li te'k'axtesi̱nk e̱re sa' ruk'eb laj rakol a̱tin. Ut chi ma̱c'a' e̱ma̱c texsaq'uek' xbaneb sa' li cab li neque'xch'utub cui' ribeb laj judío. ");
INSERT INTO kekNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ut texc'amek' chiruheb li acuabej ut chiruheb li rey sa' inc'aba' la̱in. Ut te̱ch'olob li xya̱lal chiruheb a'an, jo' ajcui' chiruheb li ma̱cua'eb aj judío. ");
INSERT INTO kekNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ut nak toxexxakaba̱k chiruheb, mexc'oxlac chirix li c'a'ru te̱ye, chi moco texc'oxlak chirix chanru tex-a̱tinak xban nak sa' li ho̱nal a'an ta̱yehek' e̱re c'a'ru te̱ye. ");
INSERT INTO kekNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ma̱cua' la̱ex li tex-a̱tinak. A' ban li Santil Musik'ej ta̱a̱tinak. Yal tixto'oni lix tz'u̱mal e̱re. ");
INSERT INTO kekNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Sa' eb li cutan a'an, cuan li asbej tixk'axtesi li i̱tz'inbej re ta̱camsi̱k ut cuan li i̱tz'inbej tixk'axtesi li asbej. Ut cuan li yucua'bej tixk'axtesi li alalbej. Ut cuan li alalbej xic' te'rileb lix na' xyucua' ut te'xq'ueheb chi camsi̱c. ");
INSERT INTO kekNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ut chixjunileb xic' te'ilok e̱re sa' inc'aba'. Abanan li ani te'cuyuk xc'ulbal li raylal toj sa' roso'jic lix yu'am, eb a'an te'colek'. ");
INSERT INTO kekNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nak texrahobtesi̱k sa' jun li tenamit, texxic sa' jalan chic. Relic chi ya̱l ninye e̱re nak toj ma̱ji' ajcui' nequechoy xbeninquil chixjunileb li tenamit cuanqueb Israel te'xnau nak xoline̱lk la̱in li C'ajolbej. ");
INSERT INTO kekNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Junak li yo̱ chi tzoloc inc'a' naru tixk'ax xcuanquil li yo̱ chi tzoloc re, chi moco li mo̱s naxk'ax xcuanquil lix patrón. ");
INSERT INTO kekNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Chic'ojla̱k xch'o̱l li yo̱ chi tzoloc nak ta̱cuulak jo' laj tzolol re, ut li mo̱s jo'cak lix patrón. Cui aj tza nayehe' re laj e̱chal cab, ¿ma toja' ta chic inc'a' te'yehek' aj tza reheb li ralal xc'ajol? ");
INSERT INTO kekNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jo'can utan mexxucuac chiruheb li xic' neque'iloc e̱re. Ma̱ jun na'leb mukmu anakcuan chi inc'a' ta ta̱tauma̱nk ru mokon, ut ma̱c'a' mukmu anakcuan chi inc'a' ta̱c'utbesi̱k. ");
INSERT INTO kekNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Li c'a'ru xexintzol cui' e̱junes, a'an te̱ye chiruheb chixjunileb, ut li c'a'ru xinye e̱re e̱junes, a'an te̱ye chi cau xya̱b e̱cux chiruheb chixjunileb li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mexxucuac chiruheb laj camsinel xban nak li a̱mej inc'a' naru te'xcamsi. A' li te̱xucua ru, a'an li Ka̱cua' li cuan xcuanquil chixcamsinquil li tibelej ut chixtaklanquil li a̱mej sa' xbalba. ");
INSERT INTO kekNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","¿Ma inc'a' ta bi' nac'ayi̱c cuib chi tzentzeyul chi jun centavo? K'axal cubenak xtz'ak, abanan ma̱ jun li ch'ina tzentzeyul nacam chi inc'a' ta tixnau li Dios le̱ Yucua'. ");
INSERT INTO kekNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Jo'can ajcui' li rismal le̱ jolom ajlanbileb chixjunil xban li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jo'can nak mexxucuac chiruheb li xic' neque'iloc e̱re xban nak la̱ex k'axal terto e̱tz'ak chiruheb nabal chi tzentzeyul. ");
INSERT INTO kekNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Li ani naxye chiruheb li tenamit nak niquinixpa̱b, la̱in tinye chiru lin Yucua' cuan sa' choxa nak a'an li cualal. ");
INSERT INTO kekNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ut li ani ta̱tz'ekta̱na̱nk cue chiruheb li tenamit, la̱in tintz'ekta̱na ajcui' a'an chiru lin Yucua' cuan sa' choxa. ");
INSERT INTO kekNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Me̱c'oxla nak xinchal ta chixq'uebal li tuktu̱quil usilal sa' ruchich'och'. Xinchal ban chixch'olobanquil li xya̱lal; ut xban li xya̱lal li nach'oloba̱c, nacuan li ch'a'ajquilal. ");
INSERT INTO kekNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Xinchal ut chixch'olobanquil li xya̱lal ut li ani ta̱pa̱ba̱nk cue, te'xc'ul li raylal. Li alalbej ta̱cua̱nk sa' ra xi̱c' riq'uin lix yucua', ut li co'bej ta̱cua̱nk sa' ra xi̱c' riq'uin lix na', ut li alibej ta̱cua̱nk sa' ra xi̱c' riq'uin li na'bej sa' inc'aba' la̱in. ");
INSERT INTO kekNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Li cuanqueb sa' jun cabal, xic' te'ril rib sa' inc'aba' la̱in. ");
INSERT INTO kekNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ut ani k'axal naxra xna' xyucua' chicuu la̱in, moco xc'ulub ta nak tinc'ul chok' cualal. Ut ani k'axal naxra li ralal xc'ajol chicuu la̱in, moco xc'ulub ta nak tinc'ul chok' cualal. ");
INSERT INTO kekNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Li ani tixcuy inta̱kenquil usta tixc'ul li camsi̱c sa' inc'aba', li jun a'an xc'ulub nak tinc'ul chok' cualal. Abanan li ani inc'a' tixcuy inta̱kenquil, li jun a'an moco xc'ulub ta nak tinc'ul chok' cualal. ");
INSERT INTO kekNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Li ani naxra lix yu'am arin sa' ruchich'och', a'an tixsach li junelic yu'am. Ut li ani tixsach lix yu'am arin sa' ruchich'och' sa' inc'aba' la̱in, a'an ta̱re̱chani li junelic yu'am. ");
INSERT INTO kekNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Li ani ta̱c'uluk e̱re la̱ex, tinixc'ul ajcui' la̱in. Ut li ani ta̱c'uluk cue, tixc'ul ajcui' li xtaklan chak cue. ");
INSERT INTO kekNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Li ani ta̱c'uluk re junak profeta chi anchal xch'o̱l xban nak a'an naxye ra̱tin li Dios, li jo' q'uial lix k'ajca̱munquil li tixc'ul li profeta, a'an ajcui' li tixc'ul li ta̱c'uluk re. Ut li ani ta̱c'uluk re li ti̱c xch'o̱l xban nak a'an ti̱c xch'o̱l, li jo' q'uial lix k'ajca̱munquil li tixc'ul li ti̱c xch'o̱l, a'an ajcui' li tixc'ul li ta̱c'uluk re. ");
INSERT INTO kekNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Li ani tixq'ue jun sec'ak ruc'a junak reheb lin tzolom usta cubenak xcuanquil, cui tixq'ue li ruc'a xban nak a'an intzolom, relic chi ya̱l ninye e̱re nak li jun a'an tixc'ul lix k'ajca̱munquil. ");
INSERT INTO kekNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nak quirake' li Jesús chixtaklanquileb chi xic chi c'anjelac lix tzolom cablaju, qui-el aran ut co̱ chixch'olobanquil li xya̱lal sa' eb li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ac cuan chi pre̱xil laj Juan laj Cubsihom Ha' nak quirabi resil li c'a'ru yo̱ chixba̱nunquil li Cristo. Laj Juan quixtaklaheb lix tzolom chi a̱tinac riq'uin ut chixpatz'bal re: ");
INSERT INTO kekNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","¿Ma la̱at li Cristo li yechi'inbil, li yo̱co chiroybeninquil? ¿Malaj toj takoybeni chic junak? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Quichak'oc li Jesús ut quixye reheb: —Ayukex ut te̱serak'i re laj Juan li c'a'ru yo̱quin chixba̱nunquil che̱ru ut te̱ye re li c'a'ru yo̱quex chirabinquil chicuix la̱in. ");
INSERT INTO kekNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Yehomak re nak eb li mutz' neque'iloc chic; eb li ye̱k rok neque'be̱c chic; eb li saklep rix xe'q'uirtesi̱c; eb li tz'ap xic neque'abin chic; eb li camenak neque'cuaclesi̱c cui'chic chi yo'yo; ut eb li neba' yo̱queb chirabinquil resil li usilal, cha'kex re. ");
INSERT INTO kekNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Us xak reheb li ani inc'a' ta̱ch'ina̱nk xch'o̱l inban, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ut nak que'el eb a'an, qui-oc chi a̱tinac li Jesús riq'uineb li tenamit chirix laj Juan ut quixye chi jo'ca'in: —¿C'a'ru coxe̱ril chak sa' li chaki ch'och'? ¿Ma junak cui̱nk nacuiban xch'o̱l chanchan li caxlan aj yo̱ rec'asinquil xban ik' coxe̱ril chak? ");
INSERT INTO kekNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿C'a' put ru coxe̱ril chak? ¿Ma junak cui̱nk cha̱bil xtikibanquil coxe̱ril chak? A' li cha̱bileb rak' sa' rochocheb li rey cuanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿C'a'ru coxe̱ril chak? ¿Ma junak profeta coxe̱ril chak? Ya̱l nak a'an jun profeta. Abanan la̱in tinye e̱re nak li jun a'in naxk'ax ru xcuanquil junak profeta. ");
INSERT INTO kekNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Chirix laj Juan tz'i̱banbil sa' li Santil Hu nak naxye chi jo'ca'in: A'ut la̱in tintakla lin takl aj c'amol be cha̱cuu. A'an ta̱ch'oloba̱nk xya̱lal chiruheb li tenamit re nak eb a'an yo'on cua̱nkeb cha̱c'ulbal la̱at. (Mal. 3:1) ");
INSERT INTO kekNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Relic chi ya̱l tinye e̱re nak ma̱ jun reheb li neque'yo'la arin sa' ruchich'och' naxk'ax xcuanquil laj Juan laj Cubsihom Ha'. Aban li k'axal ca'ch'in sa' lix nimajcual cuanquil li Dios, k'axal us chok' re a'an chiru laj Juan (xban nak laj Juan inc'a' quiril lix nimajcual cuanquilal li Dios arin sa' ruchich'och'). ");
INSERT INTO kekNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Chalen chak nak quixtiquib xch'olobanquil xya̱lal laj Juan laj Cubsihom Ha' ut toj anakcuan cuanqueb li neque'xyal xxakabanquil lix nimajcual cuanquilal li Dios, yal xjuneseb, ut que'raj xba̱nunquil sa' junpa̱t usta riq'uin raylal ta̱uxma̱nk. ");
INSERT INTO kekNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Chixjunileb li profeta jo' cui' lix chak'rab laj Moisés, toj riq'uin laj Juan xolrakek' xyebal nak ta̱xakaba̱k lix nimajcual cuanquilal li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ut cui te̱raj xtaubal lix ya̱lal chirix laj Juan, a'an laj Elías li tol-e̱lk. ");
INSERT INTO kekNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Li ani na-abin re li yo̱quin xyebal chixq'uehak retal chi us li cua̱tin xban nak cuan xya̱lal. ");
INSERT INTO kekNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Ani ta cui' aj iq'uin ta̱ru̱k tebinjuntak'e̱ta li cuanqueb sa' ruchich'och' anakcuan? Ma̱c'a' nacuulac chiruheb. Chanchaneb li coc'al li neque'c'ojla chi batz'u̱nc sa' eb li c'ayil ut neque'xjap re chixyebal reheb lix comon: ");
INSERT INTO kekNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Xkaya̱basi li kaxo̱lb ut inc'a' xexxajoc; xobichan chi ra sa' kach'o̱l, ut inc'a' xyot'e' e̱ch'o̱l chi moco xexya̱bac xban”, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Nak quic'ulun laj Juan laj Cubsihom Ha', cuan li inc'a' quixtzaca, ut cuan li inc'a' quiruc', ut eb li tenamit inc'a' que'xc'ul ut que'xye, “Ma̱us aj musik'ej cuan riq'uin”, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ut nak xinc'ulun la̱in li C'ajolbej, nincua'ac ut nin-uc'ac, ut inc'a' ajcui' quine'xc'ul sa' xya̱lal. Eb li tenamit neque'xye chicuix, “Li jun cuan arin, junes cua'ac ut junes uc'ac vino naxba̱nu. A'an rami̱gueb laj ma̱c ut eb laj titz'ol toj”, chanqueb. A'ut li na'leb li q'uebil xban li Dios, xakxo xcuanquil riq'uin li xba̱nu laj Juan ut li c'a'ru xinba̱nu la̱in. ");
INSERT INTO kekNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tojo'nak li Jesús qui-oc chixk'usbaleb li tenamit sa' eb li na'ajej bar quixba̱nu cui' nabal li milagro xban nak inc'a' que'yot'e' xch'o̱leb ut inc'a' que'xjal xc'a'uxeb, ut quixye reheb: ");
INSERT INTO kekNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Raylal cha̱lel sa' e̱be̱n, ex aj Corazín. Raylal cha̱lel sa' e̱be̱n ex aj Betsaida. Cui ta qui-uxman aran Tiro li milagro a'in li xinba̱nu che̱ru ut cui ta qui-uxman aran Sidón, ac najter raj que'xq'ue li cha sa' xjolomeb ut ac que'xq'ue raj li k'es ru t'icr chirixeb chok' retalil nak raheb sa' xch'o̱l ut que'yot'e' raj xch'o̱leb ut que'xjal raj xc'a'uxeb. ");
INSERT INTO kekNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Jo'can ut nak tinye e̱re nak sa' xk'ehil li rakba a̱tin, k'axal cui'chic li raylal li te̱c'ul la̱ex chiru li raylal li te'xc'ul eb laj Tiro ut eb laj Sidón. ");
INSERT INTO kekNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ut la̱ex aj Capernaum, c'ajo' nak nequenimobresi e̱rib. ¿Ma nequec'oxla nak ta̱taksi̱k le̱ cuanquil toj sa' choxa? Ta̱cubsi̱k ban le̱ cuanquil toj sa' xna'ajeb li camenak. Cui ta riq'uineb laj Sodoma quilaj-uxman eb li milagro li x-uxman e̱riq'uin la̱ex, toj cuanqueb raj sa' li cutan anakcuan. ");
INSERT INTO kekNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Jo'can ut nak tinye e̱re nak sa' xk'ehil li rakba a̱tin, k'axal cui'chic nabal lix tojbal e̱ma̱c li te̱c'ul la̱ex chiru li te'xc'ul eb laj Sodoma.— ");
INSERT INTO kekNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Sa' eb li cutan a'an, li Jesús quitijoc ut quixye: —At inYucua', la̱at laj e̱chal re li choxa jo' ajcui' li ruchich'och'. Ninbantioxi cha̱cuu xban nak xamuk li xya̱lal chirix lix nimal la̱ cuanquilal chiruheb li cuanqueb xna'leb nak neque'xye rib, ut xamuk ajcui' chiruheb li tzolbileb. Ut xac'ut li xya̱lal chiruheb li cubenakeb xcuanquil, li chanchaneb coc'al. ");
INSERT INTO kekNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Xaba̱nu chi jo'can xban nak jo'can xcuulac cha̱cuu, chan li Jesús nak quitijoc. ");
INSERT INTO kekNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ut quixye reheb li tenamit: —Chixjunil li c'a'ak re ru xk'axtesi sa' cuuk' lin Yucua'. Ma̱ ani nana'oc cuu la̱in li C'ajolbej, ca'aj cui' li Acuabej Dios. Ma̱ ani nana'oc ru li Acuabej Dios, ca'aj cui' la̱in li C'ajolbej. Ut ta̱na'ek' ajcui' ru xbaneb li ani tinc'ut cui' li xya̱lal, la̱in li C'ajolbej. ");
INSERT INTO kekNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Jo'can ut cha̱lkex cuiq'uin che̱junilex li lublu̱quex ut li tacuajenakex ut la̱in texinq'ue chi hila̱nc. ");
INSERT INTO kekNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","C'ulumak li yugo li tinq'ue sa' e̱be̱n ut tzolomak e̱rib cuiq'uin xban nak tu̱lanin ut k'un inch'o̱l ut te̱tau xc'ojobanquil e̱ch'o̱l, ");
INSERT INTO kekNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","xban nak lin yugo k'un ut se̱b li i̱k li tinq'ue sa' e̱be̱n. ");
INSERT INTO kekNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ut chirix chic a'an sa' jun hiloba̱l cutan, li Jesús yo̱ chi be̱c bar cui' aubil li acui̱mk trigo. Ut eb lix tzolom te'tz'oca̱k ut que'oc chixch'otbal ru li acui̱mk ut yo̱queb chixcua'bal. ");
INSERT INTO kekNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ut nak que'ril eb laj fariseo, que'xye re li Jesús: —Ileb la̱ tzolom. Yo̱queb chixsic'bal ru li acui̱mk. Yo̱queb chixba̱nunquil li c'anjel moco uxc ta naraj sa' li hiloba̱l cutan, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Li Jesús quichak'oc ut quixye reheb: —¿Ma inc'a' ta bi' xeril sa' li Santil Hu c'a'ru quixba̱nu laj David nak a'an ut eb li rochben te'tz'oca̱k? ");
INSERT INTO kekNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Qui-oc sa' li cab bar neque'xlok'oni cui' li Dios ut cuan aran li mayejanbil caxlan cua. Ma̱cua' raj re laj David xcua'bal li caxlan cua a'an, chi moco reheb li rochben. Juneseb laj tij naru neque'xcua' li mayejanbil caxlan cua. Abanan laj David quixcua'. ");
INSERT INTO kekNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ut, ¿ma inc'a' e̱rilom sa' lix chak'rab laj Moisés nak eb laj tij ma̱c'a' xma̱queb nak neque'xk'et li hiloba̱l cutan nak neque'c'anjelac sa' rochoch li Dios? ");
INSERT INTO kekNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","La̱in tinye e̱re nak cuanquin arin la̱in, ut k'axal nim incuanquil chiru li rochoch li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","La̱ex inc'a' nequenau xya̱lal li a̱tin a'in li tz'i̱banbil sa' li Santil Hu: Li nacuulac chicuu la̱in, a'an nak tex-uxta̱na̱nk u ut ma̱cua' nak texmayejak xul. (Os. 6:6) Cui ta xetau ru li na'leb a'in, inc'a' raj xetz'ekta̱naheb li ma̱c'a'eb xma̱c. ");
INSERT INTO kekNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","La̱in li C'ajolbej. La̱in laj e̱chal re li hiloba̱l cutan. Cuan incuanquil chixyebal c'a'ru ta̱uxma̱nk sa' li hiloba̱l cutan, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ut nak qui-el chak aran, quichal sa' li cab li neque'xch'utub cui' ribeb laj judío. ");
INSERT INTO kekNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ut aran cuan jun li cui̱nk sic jun li ruk'. Ut eb laj fariseo que'xpatz' re li Jesús yal re xjitbal: —¿Ma us q'uirtesi̱nc sa' li hiloba̱l cutan? ");
INSERT INTO kekNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ut li Jesús quichak'oc ut quixye reheb: —Cui junak sa' e̱ya̱nk cuan junak lix carner ta̱t'anek' sa' junak jul sa' li hiloba̱l cutan, ¿ma inc'a' raj toxchap ut toxrisi chak sa' li jul? ");
INSERT INTO kekNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿Ma inc'a' ta bi' numtajenak terto xtz'ak junak cui̱nk chiru junak carner? Cui us xcolbal li carner sa' li hiloba̱l cutan, ¿ma inc'a' ta bi' k'axal cui'chic us xtenk'anquil li cui̱nk sa' li hiloba̱l cutan?— ");
INSERT INTO kekNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tojo'nak quixye re li cui̱nk li sic li ruk': —Ye' la̱ cuuk', chan re. Ut li cui̱nk quixye' li ruk' ut sa' junpa̱t quicana chi ma̱c'a' re̱c' jo' li jun chic. ");
INSERT INTO kekNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ut eb laj fariseo que'el aran ut que'oc chixc'u̱banquil chanru nak te'xcamsi li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Li Jesús quixnau nak yo̱queb xc'u̱banquil chanru nak te'xcamsi ut qui-el sa' li na'ajej a'an. Ut nabaleb li tenamit que'ta̱ken re ut naxq'uirtesiheb chixjunileb li yaj. ");
INSERT INTO kekNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ut li Jesús quixye reheb nak ma̱ ani aj e te'xye resil nak a'an li xq'uirtesin reheb. ");
INSERT INTO kekNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","A'in quic'ulman jo' yebil chak xban li profeta Isaías nak quixye chi jo'ca'in: ");
INSERT INTO kekNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","A'an a'in laj c'anjel chicuu, li sic'bil ru inban. A'an ninra ut riq'uin a'an nasaho' lin ch'o̱l. Tinq'ue re lin musik', ut a'an ta̱yehok resil li rakba a̱tin li cha̱lc re sa' xbe̱neb li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Inc'a' ta̱cuech'i̱nk chi moco tixjap re ut ma̱ ani ta̱abi̱nk re lix ya̱b xcux sa' be. ");
INSERT INTO kekNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Inc'a' tixrahobtesiheb li tacuajenakeb. Inc'a' tixchoy xtokbal li caxlan aj li ac tokec' re, chi moco tixchoy xchupbal ru li xam li toj yo̱ chi e̱lc xsibel toj nak tixxakab lix cuanquil ut ta̱rakok a̱tin sa' ti̱quilal. ");
INSERT INTO kekNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ut chixjunileb li tenamit ca'aj cui' riq'uin a'an te'yo'oni̱nk. (Is. 42:2-4) ");
INSERT INTO kekNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ut mokon chic quic'ame' chak riq'uin li Jesús jun li cui̱nk cuan ma̱us aj musik'ej riq'uin. Mutz' ut mem li cui̱nk a'an. Ut li Jesús quixq'uirtesi, ut li cui̱nk li mutz' ut mem nak quicuan, quia̱tinac ut qui-iloc chic. ");
INSERT INTO kekNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ut chixjunileb li tenamit que'sach xch'o̱l ut yo̱queb chixyebal: —¿Malaj a'in ta ut ralal li rey David, li yo̱co chiroybeninquil? ");
INSERT INTO kekNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ut eb laj fariseo nak que'rabi a'an, que'xye: —Li cui̱nk a'in na-isin ma̱us aj musik'ej riq'uin xcuanquil laj Beelsebú, lix yucua'ileb li ma̱us aj musik'ej, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Li Jesús quixnau li c'a'ru yo̱queb chixc'oxlanquil ut quixye reheb: —Cui cuan jun te̱pak chi tenamit xic' te'ril rib chi ribileb rib, li jun te̱p chi tenamit a'an tixsach xcuanquil xjunes rib. Ut cui cuan ta jun cabalak xic' te'ril rib chi ribileb rib, li jun cabal a'an te'xsach xcuanquil lix jun cablal. ");
INSERT INTO kekNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Jo'can ajcui' laj tza cui te'xpleti rib chi ribileb rib, a'an tixsach xcuanquil xjunes rib. ");
INSERT INTO kekNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Cui ut sa' xc'aba' laj tza nacuisiheb li ma̱us aj musik'ej, ¿ani sa' aj c'aba' neque'isin ma̱us aj musik'ej li neque'ta̱ken e̱re? Jo'can nak a'aneb ajcui' te'yehok re nak inc'a' ya̱l li yo̱quex chixyebal. ");
INSERT INTO kekNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Cui ut riq'uin xcuanquil li Dios nacuisiheb li ma̱us aj musik'ej, riq'uin a'an nac'utun nak relic chi ya̱l ac xc'ulun sa' e̱ya̱nk lix nimajcual cuanquilal li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ut chanru nak ta̱oc junak sa' rochoch jun cui̱nk cau rib chixmak'bal li c'a'ru cuan re cui inc'a' ta xbe̱n cua tixbac' li cui̱nk cau rib, tojo'nak ta̱oc chixc'ambal li c'a'ru cuan re. ");
INSERT INTO kekNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Li ani inc'a' na-oquen chicuix, a'an xic' niquinril. Ut ani inc'a' naxococ cuochben, a'an paji̱nc naxba̱nu. ");
INSERT INTO kekNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Relic chi ya̱l ninye e̱re nak ta̱cuyma̱nk ta̱sachma̱nk lix ma̱queb li cristian ut ta̱cuyma̱nk ajcui' xma̱queb li neque'majecuan. Abanan li ani ta̱majecua̱nk re li Santil Musik'ej, inc'a' ta̱cuyek' ta̱sachek' lix ma̱c. ");
INSERT INTO kekNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Li ani ta̱hobok cue la̱in, li C'ajolbej, ta̱cuyek' xma̱c; abanan li ani ta̱hobok re li Santil Musik'ej inc'a' ta̱cuyek' xma̱c chi moco sa' eb li cutan a'in, chi moco sa' eb li cutan cha̱lel. Cua̱nk ban sa' xbe̱n chi junelic lix tojbal rix li nimla ma̱c a'an. ");
INSERT INTO kekNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jo'can ajcui' cui cha̱bil junak che', cha̱bil ajcui' li ru. Cui inc'a' us li che', li ru inc'a' ajcui' us. Ut riq'uin li naru̱chin, nana'li ru li che'. ");
INSERT INTO kekNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡La̱ex chanchanex ral li c'ambolay! ¿Chan ta cui' ru nak tex-a̱tinak cha̱bil a̱tin nak moco usex ta? Jo' chanru lix ch'o̱l junak, jo'can ajcui' naa̱tinac. ");
INSERT INTO kekNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Li cha̱bil cui̱nk naa̱tinac chi cha̱bil xban nak cha̱bil li cuan sa' xch'o̱l. Ut li cui̱nk li inc'a' us lix na'leb, yibru naa̱tinac xban nak inc'a' us li cuan sa' xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","La̱in tinye e̱re nak sa' xk'ehil li rakba a̱tin li junju̱nk tixk'axtesi xcue̱nt chirix chixjunil li jo' ma̱jo'il aj a̱tin quixye. ");
INSERT INTO kekNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Riq'uin le̱ ra̱tin ta̱q'uehek' e̱retal. Riq'uin le̱ ra̱tin ta̱c'utu̱nk nak ma̱c'a' le̱ ma̱c malaj riq'uin le̱ ra̱tin ta̱teneba̱k li tojbal ma̱c sa' e̱be̱n.— ");
INSERT INTO kekNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Cuan xcomoneb laj tz'i̱b ut xcomoneb laj fariseo que'a̱tinac ut que'xye: —At tzolonel, ba̱nu junak milagro chiku. C'ut chiku nak riq'uin li Dios nachal la̱ cuanquil, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ut li Jesús quichak'oc ut quixye reheb: —Li inc'a' useb xna'leb neque'raj nak ta̱c'utbesi̱k junak milagro chiruheb, aban ma̱ jun milagro ta̱c'utbesi̱k chiruheb. Ca'aj cui' li milagro li qui-ux re laj Jonás, li quic'utbesi̱c chiruheb junxil, a'an li ta̱c'utbesima̱nk chiruheb. ");
INSERT INTO kekNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jo' nak laj Jonás oxib cutan ut oxib k'ojyi̱n quicuan chak sa' xsa' li nimla car, jo'can ajcui' nak la̱in li C'ajolbej tincua̱nk oxib cutan ut oxib k'ojyi̱n sa' li mukleba̱l. ");
INSERT INTO kekNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Laj Jonás quixch'olob xya̱lal chiruheb laj Nínive ut que'yot'e' xch'o̱l que'xjal xc'a'ux. Ut la̱in k'axal nim incuanquil chiru laj Jonás ut cuanquin arin sa' e̱ya̱nk, abanan la̱ex inc'a' niquine̱pa̱b. Jo'can nak eb laj Nínive te'cuacli̱k chak sa' xk'ehil li rakba a̱tin e̱rochben ut texjiteb xban nak inc'a' nequexpa̱ban. ");
INSERT INTO kekNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Li ixk li quicuan chok' reina sa' li tenamit li cuan sa' li sur ta̱cuacli̱k chak sa' xk'ehil nak ta̱rakek' a̱tin sa' e̱be̱n ut tixye nak cuan e̱ma̱c xban nak inc'a' nequexpa̱ban. A'an quichal chak toj sa' xmaril li ruchich'och' chirabinquil lix na'leb laj Salomón. Ut la̱in k'axal cui'chic cuan inna'leb chiru laj Salomón ut cuanquin arin sa' e̱ya̱nk. Abanan inc'a' nequepa̱b li cua̱tin. ");
INSERT INTO kekNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Li ma̱us aj musik'ej nak ac x-el riq'uin junak cui̱nk, nalajnume' sa' li chaki na'ajej ut yo̱ chixsic'bal bar ta̱oc chi hila̱nc. Ut ma̱ bar naxtau xna'aj. ");
INSERT INTO kekNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Tojo'nak naxye sa' xch'o̱l: —La̱in tinsuk'i̱k cui'chic riq'uin li cui̱nk bar quin-el cui' chak, chan. Ut nak nocoxtau li cui̱nk, chanchan jun li cab ma̱c'a' chic cuan chi sa', mesunbil ut cauresinbil re oybeni̱nc. ");
INSERT INTO kekNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ut li ma̱us aj musik'ej naxsic' cuukub chic chi ma̱us aj musik'ej k'axal cui'chic numtajenak xma̱usilaleb chiru a'an. Neque'oc chi cua̱nc riq'uin li cui̱nk. Ut lix na'leb li cui̱nk a'an numtajenakak chic xyibal ru chiru nak xcuan chak junxil. Ut jo'can ajcui' te̱c'ul la̱ex li numtajenak le̱ ma̱usilal. ");
INSERT INTO kekNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ut toj yo̱ ajcui' chi a̱tinac li Jesús riq'uineb li tenamit nak quicuulac aran lix na' rochbeneb li ri̱tz'in li Jesús. Cuanqueb chirix cab ut te'raj raj ra̱tinanquileb. ");
INSERT INTO kekNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ut jun quiyehoc chak re li Jesús: —Ka̱cua', la̱ na' ut eb la̱ cui̱tz'in cuanqueb chirix cab. Te'raj a̱cua̱tinanquil. ");
INSERT INTO kekNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ut li Jesús quixye re: —¿Ani lin na' ut aniheb li cui̱tz'in nak nequec'oxla la̱ex?— ");
INSERT INTO kekNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ut quixye' li ruk' cuanqueb cui' lix tzolom ut quixye: —A'ineb lin na' ut a'ineb li cui̱tz'in. ");
INSERT INTO kekNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Chixjunileb li te'ba̱nu̱nk re li naraj lin Yucua' li cuan sa' choxa, a'aneb li cui̱tz'in, a'aneb li cuanab ut a'aneb lin na', chan. ");
INSERT INTO kekNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ut sa' li cutan a'an, li Jesús qui-el sa' li cab ut coxc'ojla̱k chire li palau. ");
INSERT INTO kekNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ut que'cuulac li q'uila tenamit riq'uin chirabinquil. Xban xq'uialeb li tenamit, li Jesús qui-oc sa' jun li jucub cuan sa' li palau ut quic'ojla chi sa'. Ut chixjunileb li tenamit xakxo̱queb chire li ha'. ");
INSERT INTO kekNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ut nabal c'a'ak re ru quixtzoleb cui' riq'uin jaljo̱quil ru a̱tin, ut quixye reheb: —Abihomak li tinye e̱re. Jun aj acuinel co̱ chi a̱uc. ");
INSERT INTO kekNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ut nak yo̱ chixhirbal li iyaj, cuan quinak chire be. Que'chal li xul li neque'xic'an ut que'xcua' li iyaj. ");
INSERT INTO kekNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ut cuan ajcui' li iyaj quinak sa' li pec ru bar ma̱c'a' cui' mas li ch'och'. Sa' junpa̱t quimok, abanan inc'a' quixchap xxe' xban nak jay li ch'och' sa' xbe̱n li pec. ");
INSERT INTO kekNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nak quichal li sak'e quichakic li acui̱mk xban nak inc'a' cham naxic lix xe'. ");
INSERT INTO kekNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ut cuan cui'chic li iyaj quinak sa' xya̱nk li q'uix. Ut nak quichamo' li q'uix sa' xbe̱n, quixnat' li acui̱mk. ");
INSERT INTO kekNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ut cuan cui'chic li iyaj quinak sa' li cha̱bil ch'och'. Quimok ut quiu̱chin. Cuan quixq'ue laje̱tk xca'c'a̱l ru (30). Cuan quixq'ue oxtakc'a̱l ru (60), ut cuan cui'chic quixq'ue o'takc'a̱l ru (100) li junju̱nk. ");
INSERT INTO kekNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tojo'nak li Jesús quixye reheb: —Li ani na-abin, chixq'uehak retal li c'a'ru ninye, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Mokon chic que'cuulac lix tzolom riq'uin li Jesús, ut que'xye re: —¿C'a'ut nak nacacua̱tinaheb sa' jaljo̱quil ru a̱tin?— ");
INSERT INTO kekNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Li Jesús quichak'oc ut quixye reheb: —Q'uebil e̱re la̱ex re nak te̱nau xya̱lal li mukmu̱quil na'leb chirix lix nimajcual cuanquilal li Dios. Aban eb a'an inc'a' q'uebil reheb re te'xnau li na'leb a'an. ");
INSERT INTO kekNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","A' li ani naxtau ru li xya̱lal, k'axal cui'chic nabal ta̱q'uehek' chixnau; a'ut li ani ca'ch'in ajcui' naxnau, ta̱isi̱k chiru li jo' q'uial naxnau. ");
INSERT INTO kekNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jo'can nak nina̱tinac riq'uineb sa' jaljo̱quil ru a̱tin xban nak usta yo̱queb chi iloc, abanan inc'a' te'xq'ue retal. Usta yo̱queb chi abi̱nc, abanan inc'a' te'xtau xya̱lal. ");
INSERT INTO kekNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Chi jo'can natz'akloc ru li quiyehe' xban li profeta Isaías nak quixye chi jo'ca'in: Cuulaj cuulajeb chirabinquil ut inc'a' neque'xtau xya̱lal. Ut cuulaj cuulajeb chirilbal ut inc'a' neque'xq'ue retal li c'a'ru neque'ril. ");
INSERT INTO kekNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Li tenamit a'in xe'a̱lo' lix ch'o̱leb ut chanchan tz'aptz'o lix xiqueb ut chanchaneb li mutz'. Jo'can nak inc'a' neque'xnau li xya̱lal. Cui ta ma̱cua' jo'can, te'ilok raj ut te'xq'ue raj retal li te'ril ut te'abi̱nk raj ut te'xtau raj ru li neque'rabi ut te'yot'ek' raj xch'o̱l ut te'xjal raj xc'a'uxeb ut la̱in tebinq'uirtesi raj. (Is. 6:9-10) ");
INSERT INTO kekNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Us xak e̱re la̱ex xban nak nequex-iloc ut nequeq'ue retal li c'a'ru nequeril. Nequex-abin ut nequetau ru lix ya̱lal. ");
INSERT INTO kekNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Relic chi ya̱l tinye e̱re nak nabaleb li profeta ut nabaleb li ti̱queb xch'o̱l que'raj rilbal li c'a'ru yo̱quex chirilbal ut inc'a' que'ril. Ut que'raj rabinquil li c'a'ru yo̱quex chirabinquil ut inc'a' que'rabi. ");
INSERT INTO kekNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Abihomak lix ya̱lal li jaljo̱quil ru a̱tin a'in chirix laj acuinel. ");
INSERT INTO kekNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Li ani na-abin re li xya̱lal chirix lix nimajcual cuanquilal li Dios ut inc'a' naxtau ru, a'an chanchan li iyaj li quinak chire be. Ut laj tza nachal ut naxmak' chiru li xya̱lal ut sa' junpa̱t nasach sa' xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ut li iyaj li quinak sa' li pec ru li inc'a' quixchap xxe', a'aneb li neque'abin re li ra̱tin li Dios ut sa' junpa̱t neque'xpa̱b chi saheb sa' xch'o̱leb. ");
INSERT INTO kekNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Abanan inc'a' nacana sa' xch'o̱leb. Nak nachal junak raylal, malaj ch'a'ajquilal sa' xbe̱neb xban lix pa̱ba̱leb, inc'a' neque'xcuy xnumsinquil. Sa' junpa̱t neque'ch'inan xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ut li iyaj li quinak sa' xya̱nk li q'uix, a'aneb li neque'abin re li ra̱tin li Dios. Abanan ca'aj cui' li c'a'ak re ru cuan sa' ruchich'och' neque'xc'oxla, jo' li biomal ut xra̱bal ru li c'a'ak chic re ru. Ut a'an li naramoc lix ya̱lal chiruheb. Ma̱c'a' na-oc cui' li ra̱tin li Dios chiruheb. ");
INSERT INTO kekNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ut li iyaj li quinak sa' li cha̱bil ch'och', a'aneb li neque'rabi ut neque'xpa̱b ut neque'xtau ru chi tz'akal li ra̱tin li Dios. Neque'q'ui chi us sa' lix pa̱ba̱leb, jo' li acui̱mk li naru̱chin laje̱tk xca'takc'a̱l (30) ut li naxq'ue oxtakc'a̱l (60), ut li naxq'ue o'takc'a̱l ru (100) li junju̱nk. ");
INSERT INTO kekNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ut quixye jun chic li jaljo̱quil ru a̱tin reheb li tenamit: Lix nimajcual cuanquilal li Dios chanchan jun li cui̱nk quirau li cha̱bil riyajil li trigo sa' lix ch'och'. ");
INSERT INTO kekNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ut nak ac xe'cuar chixjunileb, quicuulac li xic' na-iloc re laj e̱chal re li ch'och' ut sa' xya̱nk li trigo coxrau chak li riyajil li yibru pim chanchan ajcui' li trigo ut co̱. ");
INSERT INTO kekNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ut nak quimok chak li acui̱mk ut quiu̱chin, tojo'nak quic'utun ajcui' li pim. ");
INSERT INTO kekNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Que'cuulac ut eb laj c'anjel riq'uin laj e̱chal re li ch'och' ut que'xye: —Ka̱cua', ¿ma ma̱cua' cha̱bil iyaj li xacuau sa' li ch'och'? ¿Bar put xchal li pim cuan chi sa'?— ");
INSERT INTO kekNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ut a'an quixye reheb: —Jun li cui̱nk xic' na-iloc cue xba̱nun re a'in, chan. Ut eb laj c'anjel que'xye: —¿Ma ta̱cuaj toxic ut toxkamich'?— ");
INSERT INTO kekNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ut laj e̱chal re li ch'och' quixye: —Inc'a'. Ma̱re sa' xmich'bal li pim naru te̱mich' ajcui' li acui̱mk. ");
INSERT INTO kekNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Canabomak chi q'ui̱c chi xcabichaleb toj sa' xk'ehil xsic'bal ru li trigo. Ut sa' xk'ehil li xsic'bal, tinye reheb laj sic'ol re: —Xocomak junxil li pim ut bac'omak chi jo̱b re xc'atbal. A'ut li trigo c'u̱lahomak sa' li rochochil.— ");
INSERT INTO kekNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Li Jesús quixye jun chic li jaljo̱quil ru a̱tin reheb: Lix nimajcual cuanquilal li Dios, a'an chanchan li riyajil li ni̱nki mostaza, li quixc'am jun li cui̱nk ut quirau sa' lix ch'och'. ");
INSERT INTO kekNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Li riyajil li mostaza coc' chiruheb chixjunil li iyaj cuan. Ut nak naq'ui, ni̱nk chi us nacuulac. Naxk'ax xteram li acui̱mk. Chanchan jun to̱n li che' ut eb laj xic'anel xul neque'xyi̱b lix soc sa' eb li ruk'. ");
INSERT INTO kekNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jun chic li jaljo̱quil ru a̱tin quixye: Jun li ixk quixq'ue ca'ch'in lix ch'amal caxlan cua sa' xya̱nk li oxib bisoc li c'aj ut quisi̱po' li k'em xban, ut nabal chic li caxlan cua qui-el. Lix nimajcual cuanquilal li Dios chanchan ajcui' a'an. Nak neque'rabi resil, nabal neque'pa̱ban re. ");
INSERT INTO kekNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Chixjunil a'in sa' jaljo̱quil ru a̱tin quixye li Jesús reheb li q'uila tenamit. Ut ma̱c'a' quixye reheb chi ma̱cua' ta sa' jaljo̱quil ru a̱tin. ");
INSERT INTO kekNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nak quixba̱nu chi jo'can quitz'akloc ru li quixye li profeta nak quixye chi jo'ca'in: Tina̱tinak riq'uineb sa' jaljo̱quil ru a̱tin. Tinch'olob xya̱lal li c'a'ak re ru mukmu chak chalen sa' xticlajic li ruchich'och'. (Sal. 78:2) ");
INSERT INTO kekNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ut nak quixchak'rabiheb li tenamit, li Jesús qui-oc sa' cab. Ut nak que'cuulac eb lix tzolom riq'uin, que'xye re: —Ka̱cua', ch'olob chiku li xya̱lal li jaljo̱quil ru a̱tin chirix li yibru pim sa' li acui̱mk, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Quichak'oc li Jesús ut quixye reheb: —Li na-acuoc re li cha̱bil iyaj, a'an la̱in li C'ajolbej. ");
INSERT INTO kekNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ut li ch'och', a'an li ruchich'och'. Ut li cha̱bil iyaj, a'aneb li cuanqueb rubel xcuanquil li nimajcual Dios. Ut li yibru pim, a'aneb li cuanqueb rubel xcuanquil laj tza. ");
INSERT INTO kekNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ut li xic' na-iloc, a'an li qui-acuoc re li yibru pim. A'an laj tza. Ut lix k'ehil xsic'bal ru li acui̱mk, a'an li roso'jic li ruchich'och'. Ut eb laj sic'ol re, a'aneb lix ángel li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ut jo' ajcui' nak nach'utuba̱c ut nac'ate' sa' xam li pim, jo'can ajcui' nak toxrakek' li ruchich'och' a'in. ");
INSERT INTO kekNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","La̱in li C'ajolbej tintaklaheb chak lin ángel ut eb a'an tole'isi̱nk reheb chixjunileb laj ma̱c sa' xya̱nkeb li cuanqueb rubel xnimajcual cuanquilal li Dios. Ut te'isi̱k ajcui' chixjunileb li neque'q'uehoc re chi ma̱cobc li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ut te'q'uehek' sa' li horno li lochlo cui' li xam. Ut aran ta̱cua̱nk li ya̱bac ut li c'uxuxi̱nc ruch e xban li raylal li te'xc'ul. ");
INSERT INTO kekNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ut li ti̱queb xch'o̱l te'q'uehek' xlok'al. Chanchanakeb li sak'e sa' lix nimajcual cuanquilal li Dios lix Yucua'eb. Li ani na-abin re li yo̱quin chixyebal chixq'uehak retal chi us li ninye. ");
INSERT INTO kekNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Lix nimajcual cuanquilal li choxa, a'an chanchan li tumin mukbil sa' ch'och'. Quitauman xban jun li cui̱nk. Ut li cui̱nk a'an quixmuk cui'chic xca' sut li tumin. K'axal quisaho' sa' xch'o̱l nak coxc'ayi chixjunil li c'a'ru cuan re ut quixlok' li ch'och' li mukmu cui' li tumin. ");
INSERT INTO kekNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ut lix nimajcual cuanquilal li Dios, a'an chanchan ajcui' jun li cui̱nk aj yaconel li naxsic' li terto̱quil pec perla xc'aba'. ");
INSERT INTO kekNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ut nak quixtau jun li perla k'axal cha̱bil, quixc'ayi chixjunil li c'a'ru cuan re ut quixlok' li perla li k'axal terto xtz'ak. ");
INSERT INTO kekNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jo'can ajcui' lix nimajcual cuanquilal li Dios, a'an chanchan li yoy li quiq'ueman sa' li palau ut q'uila pa̱y chi car quirisi chak. ");
INSERT INTO kekNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ut nak quinujac, que'risi chire li ha' ut que'oc chixsic'bal ru li car. Li cha̱bil que'xxoc ut que'xq'ue sa' li chacach ut li inc'a' us que'xtz'ek. ");
INSERT INTO kekNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Jo'can ajcui' ta̱uxma̱nk sa' roso'jic li ruchich'och'. Te'cha̱lk eb li ángel ut a'an tole'isi̱nk reheb li inc'a' useb xna'leb sa' xya̱nkeb li ti̱queb xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ut te'q'uehek' li inc'a' useb xna'leb sa' li horno li lochlo cui' li xam. Ut aran ta̱cua̱nk li ya̱bac ut li c'uxuxi̱nc ruch e xban li raylal li te'xc'ul. ");
INSERT INTO kekNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Li Jesús quixpatz' reheb: —¿Ma xetau xya̱lal chixjunil li jaljo̱quil ru a̱tin a'in?— Eb a'an que'chak'oc ut que'xye re: —Ka̱cua', xkatau xya̱lal, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Li Jesús quixye reheb: —Jo'can nak chixjunileb li neque'xnau c'a'ru naxye sa' li chak'rab ut neque'xtzol rib cuiq'uin, eb a'an chanchaneb laj e̱chal cab li narisi sa' lix c'u̱leba̱l li c'a'ru ac' jo' ajcui' li c'a'ru k'el, chan li Jesús. (Quixye chi jo'can xban nak cuan xlok'al li na'leb q'uebil najter xban li Dios ut cuan ajcui' xlok'al li ac' na'leb q'uebil xban li Jesús.) ");
INSERT INTO kekNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ut nak quirake' xyebal li jaljo̱quil ru a̱tin a'in, li Jesús qui-el sa' li tenamit Capernaum. ");
INSERT INTO kekNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ut nak quicuulac sa' lix tenamit Nazaret, quixtzoleb sa' li cab li neque'xch'utub cui' ribeb laj judío. Ut eb a'an que'sach xch'o̱leb chirabinquil li quixye li Jesús, ut que'xye chi ribileb rib: —¿Bar naxtau lix na'leb li cui̱nk a'in? ¿Chanru nak naru xba̱nunquil li milagro a'in li nalajxba̱nu? ");
INSERT INTO kekNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Ma ma̱cua' ta bi' a'an li ralal laj pech'? ¿Ma ma̱cua' ta bi' lix María lix na'? Ut, ¿ma ma̱cua' ta bi' a'an li raseb laj Jacobo ut laj José, laj Simón ut laj Judas? ");
INSERT INTO kekNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ut, ¿ma ma̱cua' ta bi' sa' kaya̱nk cuanqueb li ranab? ¿Bar ta cui' xtau chixjunil lix na'leb? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ut inc'a' que'raj rabinquil ut que'xtz'ekta̱na. A' ut li Jesús quixye reheb: —Junak profeta q'uebil xlok'al. Abanan sa' lix tenamit ut sa' li rochoch inc'a' q'uebil xlok'al, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ut inc'a' q'ui li milagros li quixba̱nu aran xban nak inc'a' que'raj pa̱ba̱nc li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Sa' eb li cutan a'an laj Herodes li acuabej quirabi resil li c'a'ru yo̱ chixba̱nunquil li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ut a'an quixye reheb laj c'anjel chiru: —A'an tana laj Juan laj Cubsihom Ha'. A'an xcuacli cui'chic chi yo'yo sa' xya̱nkeb li camenak. Jo'can nak cuan xcuanquil chixba̱nunquil li milagros, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ac junxil laj Herodes quixtakla xchapbal laj Juan. Que'xbac' riq'uin cadena ut que'xq'ue sa' tz'alam. Laj Herodes quixba̱nu chi jo'can yal xban nak jo'can quiraj lix Herodías. Lix Herodías a'an li rixakil laj Felipe li ri̱tz'in laj Herodes. Ut laj Herodes quixc'am chok' rixakil. ");
INSERT INTO kekNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Toj ma̱ji' naq'uehe' sa' tz'alam laj Juan laj Cubsihom Ha' nak quixye re laj Herodes chi jo'ca'in: —Nimla ma̱c xaba̱nu nak xac'am chok' a̱cuixakil lix Herodías, chan laj Juan re. ");
INSERT INTO kekNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Jo'can nak laj Herodes quiraj raj xcamsinquil, aban quixucuac chiruheb li q'uila tenamit xban nak laj Juan profeta nak cuan chiruheb a'an. ");
INSERT INTO kekNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ut sa' xnink'einquil lix chihab laj Herodes, lix co' lix Herodías quixajoc chiruheb chixjunileb li ula'. Ut c'ajo' nak quicuulac chiru laj Herodes. ");
INSERT INTO kekNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Jo'can nak laj Herodes quixyechi'i re riq'uin juramento nak tixq'ue re chixjunil li c'a'ru tixpatz'. ");
INSERT INTO kekNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ut li xka'al chi ac tacchi'inbil xban lix na', quixye re laj Herodes: —Q'ue cue arin sa' plato lix jolom laj Juan laj Cubsihom Ha', chan. ");
INSERT INTO kekNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ma̱ ca'ch'in nak quiraho' xch'o̱l laj Herodes chirabinquil li quixye. Aban xban li juramento li ac quixye chiruheb li cuanqueb sa' me̱x rochben, quixtakla xq'uebal re li xka'al li c'a'ru quixpatz'. ");
INSERT INTO kekNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Quixtakla xch'otbal xcux laj Juan aran sa' tz'alam. ");
INSERT INTO kekNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ut que'xc'am chak lix jolom laj Juan sa' jun plato ut quik'axtesi̱c re li xka'al. Ut li xka'al quixq'ue re lix na'. ");
INSERT INTO kekNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nak que'rabi resil lix camic laj Juan, eb lix tzolom que'cuulac chixc'ambal li camenak ut coxe'xmuk. Ut coxe'xye chak resil re li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nak quirabi resil li quic'ulman, li Jesús qui-el aran. Qui-oc sa' jun li jucub ut co̱ sa' jun na'ajej cuan xjunes. Ut nak que'xq'ue retal li tenamit nak co̱, que'el chak sa' lix tenamiteb ut que'co̱eb chi rokeb sa' a̱nil bar co̱ cui' li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ut li Jesús nak qui-el sa' li jucub, quiril li q'uila tenamit li ac que'cuulac xbe̱n cua chiru a'an. Ut quixtok'oba ruheb ut quixq'uirtesiheb li yaj cuanqueb sa' xya̱nkeb. ");
INSERT INTO kekNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ut nak qui-ecuu, que'cuulac lix tzolom riq'uin li Jesús ut que'xye re: —Yo̱ chi ecuu̱c ut ma̱c'a' cuan arin cuanco cui'. Jo'can nak ta̱taklaheb li q'uila tenamit chixlok'bal lix cua sa' eb li coc' tenamit.— ");
INSERT INTO kekNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Li Jesús quixye reheb: —Moco tento ta nak te'xic eb a'an. Q'uehomak xcuaheb la̱ex.— ");
INSERT INTO kekNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ut eb a'an que'xye: —Ma̱c'a' cuan ke la̱o arin, ca'aj cui' o̱b chi caxlan cua ut cuib chi car.— ");
INSERT INTO kekNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Li Jesús quixye reheb: —C'amomak chak cuiq'uin.— ");
INSERT INTO kekNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ut nak ac xtaklaheb li q'uila tenamit chi c'ojla̱c sa' li pach'aya', quixchap li o̱b chi caxlan cua ut li cuib chi car, qui-iloc takec' ut quixbantioxi chiru li Dios. Ut quixjachi ut quixq'ue li caxlan cua reheb lix tzolom ut que'xjeq'ui reheb li q'uila tenamit. ");
INSERT INTO kekNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ut que'cua'ac chixjunileb toj retal que'c'ojla xch'o̱leb. Ut que'xxoc li jo' q'uial qui-ela'an. Cablaju chacach nujenak li rela' qui-ela'an. ");
INSERT INTO kekNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Eb li que'cua'ac cuanqueb o̱b mil chi cui̱nk chi inc'a' q'uebileb sa' ajl li ixk ut eb li coc'al. ");
INSERT INTO kekNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tojo'nak li Jesús quixtaklaheb lix tzolom chi oc sa' li jucub re nak a'aneb xbe̱n cua te'xic jun pac'al li palau roybeninquil nak tixchak'rabiheb li q'uila tenamit. ");
INSERT INTO kekNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ut nak ac xchak'rabiheb li tenamit, yo̱ chi oc li k'ojyi̱n nak li Jesús co̱ chiru tzu̱l chi tijoc. Ut aran cuan xjunes. ");
INSERT INTO kekNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ut li jucub li yo̱queb chi xic cui' lix tzolom ta̱cuulak sa' xyi li palau, ut lix cau ok li palau cau nocoxquet rib chiru li jucub, xban nak chiru yo̱ chak chi cha̱lc li ik'. ");
INSERT INTO kekNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Sake̱uc re nak quicuulac li Jesús bar cuanqueb cui' ut yo̱ chi be̱c chiru li ha'. ");
INSERT INTO kekNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nak que'ril lix tzolom nak cuan jun yo̱ chi be̱c chiru ha', que'xucuac ut que'xjap re ut que'xye: —Anum a'an.— ");
INSERT INTO kekNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","A'ut li Jesús ticto quira̱tinaheb ut quixye reheb: —Mexxucuac. La̱in li yo̱quex chicuilbal. Cacuubresihomak e̱ch'o̱l, chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Quichak'oc laj Pedro ut quixye: —Ka̱cua', cui la̱at, ye nak tinxic ajcui' la̱in a̱cuiq'uin chiru li ha'.— ");
INSERT INTO kekNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Li Jesús quixye re: —Quim.— Ut laj Pedro qui-el chak sa' li jucub ut qui-oc chi be̱c chiru li ha' re ta̱xic riq'uin li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Abanan nak quixq'ue retal li cak-sut-ik', quixucuac, ut qui-oc chi subec' sa' li ha' ut quixjap re ut quixye: —¡Ka̱cua', china̱colak! chan. ");
INSERT INTO kekNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ut li Jesús sa' junpa̱t quixye' li ruk', quixchap ut quixye re: —At cui̱nk, inc'a' nacatpa̱ban chi tz'akal. ¿C'a'ut nak xacuiba a̱ch'o̱l?— ");
INSERT INTO kekNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ut nak que'oc sa' li jucub, quich'ana li ik'. ");
INSERT INTO kekNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ut eb li cuanqueb sa' li jucub que'xcuik'ib rib chiru li Jesús ut que'xlok'oni ut que'xye re: —Relic chi ya̱l nak la̱at li Ralal li Dios, chanqueb re. ");
INSERT INTO kekNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nak quicuulac li Jesús rochbeneb lix tzolom jun pac'al li palau, coxe'el sa' li na'ajej Genesaret. ");
INSERT INTO kekNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Eb li cui̱nk cuanqueb aran ticto que'xq'ue retal nak a'an li Jesús ut que'xye resil sa' chixjunil li na'ajej a'an. Ut quilaje'xc'am li yaj riq'uin re nak tixq'uirtesiheb. ");
INSERT INTO kekNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ut que'xtz'a̱ma chiru nak tixcanabeb li yaj chixch'e'bal li rak'. Ut chixjunileb li que'ch'e'oc re li rak' quilaje'q'uira. ");
INSERT INTO kekNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Jun ch'ol eb aj tz'i̱b rochbeneb laj fariseo que'chal chak Jerusalén. Que'cuulac riq'uin li Jesús ut que'xye re: ");
INSERT INTO kekNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿C'a'ut nak eb la̱ tzolom neque'xk'et li chak'rab li canabanbil xbaneb li kaxe' kato̱n? ¿C'a'ut nak inc'a' neque'xch'aj li ruk'eb nak neque'cua'ac jo' tz'i̱banbil sa' li kachak'rab? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Li Jesús quichak'oc ut quixye reheb: —Ut la̱ex, ¿c'a'ut nak nequek'et li chak'rab q'uebil e̱re xban li Dios riq'uin xba̱nunquil le̱ najter na'leb li c'aynakex chixba̱nunquil? ");
INSERT INTO kekNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Li Dios quixye: —Cha-oxlok'i la̱ na' a̱yucua'. Ut quixye ajcui': —Ani tixhob xna' xyucua', li jun a'an camsinbil nak ta̱osok'. (Ex. 20:12; 21:17) ");
INSERT INTO kekNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","A'ut la̱ex nequeye cui cuan junak inc'a' naraj xtenk'anquil lix na' xyucua', li jun a'an tixye re lix na' xyucua', “ac mayejanbil chiru li Dios li c'a'ru raj ta̱ru̱k tatintenk'a cui'.” Ut inc'a' chic tento tixtenk'a lix na' xyucua', chanquex. ");
INSERT INTO kekNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Jo'can nak la̱ex nequetz'ekta̱na xcuanquil li chak'rab q'uebil xban li Dios ut a' chic le̱ najter na'leb nequeba̱nu. ");
INSERT INTO kekNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","La̱ex aj ca'pac'al u. Ya̱l ajcui' li quixye li profeta Isaías che̱rix la̱ex nak quixtz'i̱ba li c'a'ru quiyehe' re xban li Dios nak quixye: ");
INSERT INTO kekNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Li tenamit a'in niquine'xlok'oni ca'aj cui' riq'uin xtz'u̱mal reheb. Moco neque'xba̱nu ta chi anchal xch'o̱leb. ");
INSERT INTO kekNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ma̱c'a' rajbal nak niquine'xlok'oni xban nak li tijleb li neque'xc'ut a'an yal xchak'rabeb li cui̱nk. (Is. 29:13) ");
INSERT INTO kekNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ut li Jesús quixbokeb li tenamit riq'uin ut quixye reheb: —Abihomak che̱junilex li c'a'ru tinye ut q'uehomak retal re nak te̱tau xya̱lal. ");
INSERT INTO kekNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ma̱cua' li c'a'ru naxtzaca li cui̱nk nama̱co' cui'; aban li c'a'ru inc'a' us naxc'oxla sa' xch'o̱l, a'an li nama̱co' cui'.— ");
INSERT INTO kekNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Que'jiloc lix tzolom riq'uin li Jesús ut que'xye re: —¿Ma xaq'ue retal nak eb laj fariseos ra xe'rec'a nak xe'rabi li a̱tin li xaye?— ");
INSERT INTO kekNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Quichak'oc li Jesús ut quixye reheb: —Chixjunil li acui̱mk inc'a' aubil xban lin Yucua' cuan sa' choxa, a'an ta̱mich'ma̱nk. ");
INSERT INTO kekNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Canabomakeb. A'aneb mutz'eb ut neque'xberesiheb li mutz'. Ut cui li mutz' neque'xberesi li rech mutz'il, chi xcabichaleb te't'anek' sa' jul.— ");
INSERT INTO kekNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","A'ut laj Pedro quichak'oc ut quixye: —Ba̱nu usilal, ch'olob chiku li xya̱lal li jaljo̱quil ru a̱tin a'in.— ");
INSERT INTO kekNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ut li Jesús quixye re: —¿Ma toj ma̱c'a' ajcui' e̱na'leb la̱ex? ");
INSERT INTO kekNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Ma toj ma̱ji' nequetau xya̱lal nak chixjunil li c'a'ru naxtzaca junak, a'an moco sa' xch'o̱l ta naxic? Ti̱c sa' xsa' naxic ut chirix a'an naxtz'ek cui'chic. ");
INSERT INTO kekNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Li inc'a' us na-el sa' xtz'u̱mal re li junju̱nk, a'an sa' lix ch'o̱l nachal. Ut a'an a'in li nama̱co' cui'. ");
INSERT INTO kekNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Sa' lix ch'o̱l junak nachal chak li ma̱us aj na'leb, li camsi̱nc ras ri̱tz'in, li muxuc caxa̱r, li co'be̱tac yumbe̱tac, li elk'ac, li k'aba̱nc ut li majecua̱nc. ");
INSERT INTO kekNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Chixjunil li ma̱us aj na'leb a'in sa' xch'o̱l junak nachal chak, ut a'an li nama̱co' cui' li junju̱nk. Ut li cua'ac chi inc'a' ch'ajbil li uk'ej, ma̱cua' a'an li nama̱co' cui' li cui̱nk, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ut qui-el aran li Jesús ut co̱ sa' eb li na'ajej xcue̱nt Tiro ut xcue̱nt Sidón. ");
INSERT INTO kekNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ut cuan jun li ixk aj Canaán quichal sa' li na'ajej a'an. Japjo re chixyebal: —Ka̱cua', Ralalat laj David, chacuuxta̱na taxak cuu. Lin co' c'ajo' nak yo̱ chi tacuasi̱c xban li ma̱us aj musik'ej, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","A'ut li Jesús ma̱ jun li a̱tin quixye re. Ut eb lix tzolom que'nach'oc riq'uin li Jesús ut que'xye re: —Ka̱cua', ba̱nu li usilal re, re nak tixcanab xjapbal re, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Li Jesús quichak'oc ut quixye: —Ma̱ bar chic taklanbilin chak, ca'aj cui' riq'uineb laj Israel. Chanchaneb li carner sachenak, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ut li ixk quixcuik'ib rib chiru li Jesús ut quixye cui'chic: —Ka̱cua', chacuuxta̱na taxak cuu.— ");
INSERT INTO kekNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Li Jesús quichak'oc ut quixye re: —Inc'a' us xmak'bal xcuaheb li coc'al ut xq'uebal reheb li tz'i', chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ut li ixk quichak'oc ut quixye re: —Ya̱l li nacaye, Ka̱cua', abanan eb li tz'i' neque'xxoc xc'aj xcuaheb li coc'al li nat'ane' rubel li me̱x nak yo̱queb chi cua'ac, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ut li Jesús quixye re: —Kana', la̱at relic chi ya̱l xatau ru li xya̱lal ut chi anchal a̱ch'o̱l xatpa̱ban. Chi-uxk li c'a'ru xatz'a̱ma, chan. Ut sa' ajcui' li ho̱nal a'an quiq'uira lix co'. ");
INSERT INTO kekNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Qui-el chak li Jesús aran, ut quinume' chire li palau Galilea sa' xna'ajeb li ma̱cua'eb aj judío. Tojo'nak quitake' chiru jun li tzu̱l ut aran quic'ojla. ");
INSERT INTO kekNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ut que'cuulac li q'uila tenamit riq'uin. Cuanqueb nabal li yaj li que'c'ame' riq'uin. Cuanqueb li ye̱k rok, cuanqueb li mutz', cuanqueb li mem ut li tokol ruk'eb, ut cuanqueb ajcui' nabaleb li yaj rochbeneb. Ut cole'q'uehek' chiru li Jesús ut a' yal c'a'ru lix yajel li junju̱nk, li Jesús quixq'uirtesiheb. ");
INSERT INTO kekNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jo'can nak que'sach xch'o̱leb li tenamit chirilbal nak li mem neque'a̱tinac chic ut li tokoleb ruk' que'q'uira ut li ye̱keb rokeb neque'be̱c chic ut eb li mutz' ruheb neque'iloc chic. Ut que'xnima xlok'al lix Dioseb laj Israel. ");
INSERT INTO kekNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ut li Jesús quixbokeb lix tzolom riq'uin ut quixye reheb: —Neque'cuil xtok'oba̱l ruheb li tenamit. Ac oxib cutan xchaliqueb chicuix ut ma̱c'a' xcuaheb. Ut inc'a' nacuaj xtaklanquileb sa' rochocheb chi inc'a' te'cua'ak. Naru neque'lub sa' be, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ut eb lix tzolom que'xye re: —¿Bar takatau cua sa' li na'ajej a'in re takaq'ueheb chi cua'ac li q'uila tenamit a'in? Arin ma̱c'a' cuan, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ut li Jesús quixye reheb: —¿Jarub li caxlan cua cuan e̱riq'uin? chan. —Cuukub ajcui' li caxlan cua ut cuib oxib li coc' car, chanqueb re. ");
INSERT INTO kekNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ut li Jesús quixtaklaheb li tenamit chi c'ojla̱c chiru ch'och'. ");
INSERT INTO kekNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ut quixchap li cuukub chi caxlan cua ut eb li car, quixbantioxi chiru li Dios ut quixjachi. Ut quixq'ue reheb lix tzolom re nak te'xjeq'ui reheb li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Que'cua'ac chixjunileb toj retal que'c'ojla xch'o̱leb. Ut que'xc'u̱la li qui-ela'an. Cuukub chacach nujenak li rela' xc'aj li caxlan cua li qui-ela'an. ");
INSERT INTO kekNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ut eb li que'cua'ac, a'aneb ca̱hib mil chi cui̱nk chi ma̱c'a'eb sa' ajl li ixk chi moco li coc'al. ");
INSERT INTO kekNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nak ac quixchak'rabiheb li tenamit, li Jesús qui-oc cui'chic sa' li jucub ut co̱ cui'chic jun pac'al li palau sa' li na'ajej xcue̱nt Magdala. ");
INSERT INTO kekNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Que'cuulac laj fariseo ut eb laj saduceo riq'uin li Jesús. Que'raj xyalbal rix ut que'oc chixtz'a̱manquil chiru nak tixba̱nu junak milagro chiruheb re rilbal ma ya̱l nak riq'uin li Dios nachal lix cuanquil. ");
INSERT INTO kekNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ut li Jesús quichak'oc ut quixye reheb: —Nak na-ecuu nequeye “cha̱bilak li cutan cuulaj xban nak cak ru li choxa.” ");
INSERT INTO kekNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ut ek'ela nequeye “ho̱n naxq'ue hab xban nak cak ru ut k'ojyi̱n ru li choxa.” La̱ex aj ca'pac'al u. Nequenau xq'uebal retal ru li choxa. Abanan, ca'aj cui' a'an nequenau rilbal. Inc'a' nequeq'ue retal c'a'ru xya̱lal li yo̱ chi c'ulma̱nc sa' eb li cutan a'in. ");
INSERT INTO kekNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","La̱ex jun te̱p chi tenamit inc'a' us le̱ na'leb. Nequetz'ekta̱na li Dios ut nequeraj nak ta̱c'utbesi̱k che̱ru junak milagro. Abanan inc'a' ta̱c'utbesi̱k che̱ru, ca'aj cui' li milagro li qui-ux re laj Jonás, chan li Jesús. Tojo'nak quixcanabeb ut co̱. ");
INSERT INTO kekNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nak ac xe'nume' lix tzolom jun pac'al li palau, que'xq'ue retal nak inc'a' que'xc'am xtzacae̱mk. ");
INSERT INTO kekNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ut li Jesús quixye reheb: —Cheq'uehak retal, me̱bon e̱rib riq'uin xch'amal xcaxlan cua eb laj fariseo chi moco riq'uin xch'amal xcaxlan cua eb laj saduceo. ");
INSERT INTO kekNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Eb lix tzolom que'oc chi a̱tinac chi ribileb rib ut que'xye: —Xban nak inc'a' xkac'am chak li caxlan cua, jo'can nak yo̱ chixyebal ke chi jo'can. ");
INSERT INTO kekNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Li Jesús quixnau li c'a'ru yo̱queb chixyebal ut quixye reheb: —La̱ex inc'a' nequexpa̱ban chi tz'akal. ¿C'a'ut nak yo̱quex chi c'oxlac chirix li xinye e̱re? ¿C'a'ut nak yo̱quex chixyebal chiribil e̱rib nak ma̱c'a' le̱ caxlan cua? ");
INSERT INTO kekNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ma toj ma̱ji' nequetau xya̱lal? ¿Ma inc'a' najultico' e̱re nak xinjachi li o̱b chi caxlan cua reheb li o̱b mil chi cui̱nk? Ut, ¿jarub chacach li rela' quexoc? chan. ");
INSERT INTO kekNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","—Ut, ¿ma inc'a' najultico' e̱re nak xinjachi li cuukub chi caxlan cua reheb li ca̱hib mil chi cui̱nk? ut, ¿jarub chacach li rela' quexoc? ");
INSERT INTO kekNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿C'a'ut nak inc'a' nequetau xya̱lal nak ma̱cua' chirix li caxlan cua yo̱quin chi a̱tinac nak xinye e̱re: Me̱bon e̱rib riq'uin li xch'amal xcaxlan cua eb laj fariseo ut eb laj saduceo? chan. ");
INSERT INTO kekNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tojo'nak que'xtau ru nak ma̱cua' chirix xch'amal lix caxlan cua yo̱ chi a̱tinac. Chirix ban lix tijlebeb laj fariseo ut laj saduceo yo̱ chi a̱tinac. ");
INSERT INTO kekNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Chirix chic a'an li Jesús co̱ rochbeneb lix tzolom sa' li na'ajej Cesarea re Filipo. Nak yo̱queb chi xic, quixpatz' reheb lix tzolom: —¿Anihin la̱in nak neque'xye li tenamit?— ");
INSERT INTO kekNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Eb a'an que'chak'oc ut que'xye: —Cuan neque'yehoc nak la̱at laj Juan laj Cubsihom Ha'. Ut cuan neque'yehoc nak la̱at li profeta Elías, ut cuan neque'yehoc nak la̱at li profeta Jeremías. Ut cuan cui'chic neque'yehoc nak la̱at junak chic reheb li profeta. ");
INSERT INTO kekNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ut li Jesús quixye reheb: —Ut la̱ex, ¿Anihin la̱in nak nequeye?— ");
INSERT INTO kekNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Quichak'oc laj Simón Pedro ut quixye: —La̱at li Cristo, li Ralal li yo'yo̱quil Dios.— ");
INSERT INTO kekNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Tojo'nak quichak'oc li Jesús ut quixye re: —Us xak a̱cue, at Simón, ralalat laj Jonás, xban nak moco cui̱nk ta xc'utbesin cha̱cuu li xya̱lal a'in. Lin Yucua' cuan sa' choxa, a'an ban li xc'utbesin cha̱cuu. ");
INSERT INTO kekNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ut la̱in ninye a̱cue nak la̱at laj Pedro. Ut sa' xbe̱n li sako̱nac a'in la̱in tincabla lin iglesia ut laj tza ma̱c'a'ak xcuanquil sa' xbe̱n. ");
INSERT INTO kekNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ut la̱in tinq'ue a̱cuanquil sa' xbe̱neb li ani te'pa̱ba̱nk cue. Ut chixjunil li c'a'ru ta̱c'u̱b ru sa' xya̱lal sa' ruchich'och', li Dios tixc'u̱b ajcui' ru sa' choxa. Li c'a'ru ta̱ye us arin sa' ruchich'och', li Dios tixye ajcui' nak us. Ut li c'a'ru ta̱ye inc'a' us, li Dios tixye ajcui' nak inc'a' us. ");
INSERT INTO kekNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tojo'nak quixye reheb lix tzolom nak ma̱ ani aj e te'xye nak li Jesús, a'an li Cristo, li yechi'inbil xban li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Chalen sa' li cutan a'an li Jesús quixtiquib xch'olobanquil chiruheb lix tzolom nak tento ta̱xic Jerusalén chixc'ulbal nabal li raylal xbaneb li cui̱nk li xakabanbileb chi c'anjelac sa' li templo ut xbaneb li xbe̱nil aj tij jo' eb ajcui' laj tz'i̱b. Quixye reheb nak ta̱camsi̱k ut nak ta̱cuacli̱k cui'chic chi yo'yo sa' rox li cutan. ");
INSERT INTO kekNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ut laj Pedro quirisi xjunes li Jesús ut qui-oc chixk'usbal: —Ka̱cua', chan re, li Dios taxak chicolok a̱cue re nak inc'a' ta̱c'ul chi jo'can, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ut li Jesús quixsuk'isi rib chirilbal laj Pedro ut quixye re: —Elen arin sa' xnak' cuu. La̱at chanchanat laj tza. Mich'inan inch'o̱l a̱ban chixba̱nunquil li c'a'ru tento tinba̱nu. La̱at inc'a' yo̱cat chixc'oxlanquil jo' naxc'oxla li Dios. Yo̱cat ban chixc'oxlanquil jo' naxc'oxla li cui̱nk, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ut li Jesús quixye reheb lix tzolom: —Li ani ta̱raj inpa̱banquil, tento nak tixtz'ekta̱na li c'a'ru naxrahi ru lix ch'o̱l. Tixcuy xnumsinquil li raylal, usta ta̱camsi̱k sa' inc'aba'. Ut chinixta̱kehak. ");
INSERT INTO kekNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Li ani naxra lix yu'am arin sa' ruchich'och', a'an tixsach li junelic yu'am. A'ut li ani naxsach lix yu'am arin sa' ruchich'och' sa' inc'aba', a'an ta̱re̱chani li junelic yu'am. ");
INSERT INTO kekNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿C'a'ru tixra li cui̱nk cui ta̱re̱chani chixjunil xbiomal li ruchich'och' ut tixsach li junelic yu'am xban li biomal? ¿Ma cuan ta bi' c'a'ru tixtoj cui' li yu'am chi junelic? ");
INSERT INTO kekNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","La̱in li C'ajolbej tincha̱lk riq'uin xnimal xlok'al lin Yucua' cuochbeneb lix ángel. Tojo'nak tinq'ue lix k'ajca̱munquil chi xjunju̱nkaleb jo' chanru lix yehom xba̱nuhom. ");
INSERT INTO kekNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Relic chi ya̱l tinye e̱re nak cuanqueb arin sa' e̱ya̱nk li inc'a' te'ca̱mk toj tine'ril chi cha̱lc la̱in li C'ajolbej riq'uin incuanquilal, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Cuakib cutan chic chirix a'an, li Jesús quixc'ameb laj Pedro, laj Jacobo ut laj Juan li ri̱tz'in sa' xbe̱n jun li nimla tzu̱l xjuneseb. ");
INSERT INTO kekNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ut nak cuanqueb aran, quijalano' li riloba̱l li Jesús chiruheb. Ut nalemtz'un li riloba̱l jo' li sak'e ut li rak' saksakpotz'in quic'utun ut nalemtz'un. ");
INSERT INTO kekNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ut xaka̱mileb laj Moisés ut laj Elías chiruheb nak que'ril ut yo̱queb chi a̱tinac riq'uin li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ut quia̱tinac laj Pedro ut quixye re li Jesús: —Ka̱cua', c'ajo' xchak'al ru nak cuanco arin. Cui ta̱cuaj, takayi̱b oxibak muheba̱l arin. Jun a̱cue, jun re laj Moisés ut jun re laj Elías, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Toj yo̱ ajcui' chi a̱tinac a'an nak quichal sa' xbe̱neb jun li chok nalemtz'un. Li Dios quia̱tinac chak sa' li chok, ut quixye: —A'in li cualal raro inban. Riq'uin a'an nasaho' inch'o̱l. Cherabihak li c'a'ru tixye.— ");
INSERT INTO kekNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nak que'rabi a'an, k'axal nak que'xucuac lix tzolom ut que'xcut rib sa' ch'och' ut huphu que'cana. ");
INSERT INTO kekNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tojo'nak li Jesús quijiloc riq'uineb ut quixt'otz't'otz'iheb ut quixye reheb: —Cuaclinkex. Mexxucuac.— ");
INSERT INTO kekNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ut nak que'xtaksi li riloba̱leb, ma̱ ani chic que'ril ru, ca'aj chic li Jesús quicana xjunes. ");
INSERT INTO kekNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nak yo̱queb chak chi cubec sa' li tzu̱l, quixye li Jesús reheb: —Ma̱ ani aj e te̱ye li c'a'ru xeril. Toj mokon naru te̱ye nak la̱in li C'ajolbej ac xincuacli cui'chic chi yo'yo sa' xya̱nkeb li camenak.— ");
INSERT INTO kekNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ut eb lix tzolom que'xpatz' re: —¿C'a'ut nak neque'xye laj tz'i̱b nak xbe̱n cua ta̱c'ulu̱nk laj Elías chiru laj colonel li yechi'inbil xban li Dios?— ");
INSERT INTO kekNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ut nak quichak'oc li Jesús quixye reheb: —Ya̱l ajcui' nak laj Elías xbe̱n cua ta̱cha̱lk chixc'u̱banquil ru chixjunil li c'a'ak re ru. ");
INSERT INTO kekNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Abanan la̱in tinye e̱re nak laj Elías ac xc'ulun ut inc'a' que'xnau ru. C'ajo' li raylal xe'xba̱nu re ut jo'can ajcui' la̱in li C'ajolbej nabal li raylal tinc'ul xbaneb.— ");
INSERT INTO kekNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ut eb lix tzolom que'xtau ru nak chirix laj Juan laj Cubsihom Ha' yo̱ chi a̱tinac li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ut que'cuulac bar cuanqueb cui' nabal li tenamit. Ut jun li cui̱nk colxcuik'ib rib chiru li Jesús ut quixye re: ");
INSERT INTO kekNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Ka̱cua', chan, chacuuxta̱na taxak ru li cualal. Rajlal nac'ul xyajel, ut k'axal ra naxc'ul. Nabal sut nat'ane' sa' xam ut nabal sut nat'ane' sa' ha'. ");
INSERT INTO kekNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ut xinc'am riq'uineb la̱ tzolom re nak te'xq'uirtesi; abanan inc'a' xe'ru xq'uirtesinquil, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Li Jesús quixye: —Ex tenamit, ti̱c inc'a' nequexpa̱ban ut inc'a' us le̱ na'leb. ¿Jo' najtil chic tincua̱nk e̱riq'uin re nak texpa̱ba̱nk? ¿Jo' najtil chic texincuy nak nequec'oxla? C'am chak li al arin cuiq'uin, chan li Jesús nak quichak'oc. ");
INSERT INTO kekNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ut li Jesús quixch'ila li ma̱us aj musik'ej ut qui-el riq'uin li al. Ut sa' ajcui' li ho̱nal a'an li al quiq'uira. ");
INSERT INTO kekNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ut que'cuulac riq'uin li Jesús lix tzolom nak cuan xjunes ut que'xpatz' re: —¿C'a'ut nak inc'a' xoru la̱o chirisinquil li ma̱us aj musik'ej? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ut li Jesús quixye reheb: —Inc'a' xexru xban nak inc'a' nequexpa̱ban chi tz'akal. Relic chi ya̱l tinye e̱re nak cuan taxak ca'ch'inak le̱ pa̱ba̱l chanchan xnimal ru jun ch'ina riyajil mostaza, te̱ye raj re li tzu̱l a'in, “Elen arin, k'axon le'” ut ta̱k'axo̱nk raj. Ut ma̱c'a' raj c'a'ru inc'a' ta̱ru̱k te̱ba̱nu. ");
INSERT INTO kekNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ca'aj cui' riq'uin ayu̱n ut riq'uin tijoc naru risinquil li ma̱us aj musik'ej xcomoneb a'an, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ut nak cuanqueb Galilea, li Jesús quixye reheb: —La̱in li C'ajolbej tink'axtesi̱k sa' ruk'eb li cui̱nk li te'camsi̱nk cue. ");
INSERT INTO kekNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Tine'xcamsi, abanan la̱in tincuacli̱k cui'chic chi yo'yo sa' xya̱nkeb li camenak sa' rox li cutan, chan. Ut c'ajo' nak que'raho' sa' xch'o̱leb lix tzolom chirabinquil li c'a'ru quixye li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ut nak que'cuulac Capernaum li Jesús rochbeneb lix tzolom, que'chal riq'uin laj Pedro li neque'titz'oc toj re li rochoch li Dios ut que'xye re: —¿Ma natojoc laj tzolol e̱re?— ");
INSERT INTO kekNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—¿C'a' nak inc'a'? Natojoc, chan laj Pedro. Ut nak cox-ocak a'an sa' cab, li Jesús xbe̱n cua quia̱tinac ut quixye: —¿C'a'ru nacaye at Simón, eb li acuabej sa' ruchich'och', aniheb aj e neque'xtitz' li toj? ¿Ma reheb li ralal malaj ut reheb li jalaneb xtenamit? chan. ");
INSERT INTO kekNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Laj Pedro quixye re: —Reheb li jalaneb xtenamit.— Ut li Jesús quixye re: —Eb li ralal li acuabej inc'a' neque'tojoc chi jo'canan. ");
INSERT INTO kekNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Usta inc'a' raj tento tintoj la̱in, abanan re nak me'xpo' xch'o̱leb kaban, la̱in tintoj. Ayu sa' a̱nil ut cut la̱ chapleb car sa' li palau. Ut li xbe̱n li car li ta̱chap chak, ta̱te lix tz'u̱mal re. Aran ta̱tau jun li tumin. Ta̱c'am ut riq'uin a'an ta̱toj li cue ut ta̱toj ajcui' la̱ cue, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Sa' li cutan a'an que'cuulac lix tzolom riq'uin li Jesús ut que'xye re: —¿Ani li k'axal nim xcuanquil sa' lix nimajcual cuanquilal li Dios?— ");
INSERT INTO kekNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ut li Jesús quixbok jun li ch'ina al riq'uin ut quixxakab chiruheb. ");
INSERT INTO kekNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ut quixye reheb: —Relic chi ya̱l tinye e̱re cui inc'a' te̱jal e̱na'leb ut cui inc'a' k'unak e̱ch'o̱l jo' li ch'ina al a'in, inc'a' tex-oc sa' lix nimajcual cuanquilal li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Jo'can nak li ani narec'a nak ma̱c'a' xcuanquil jo' li ch'ina al a'in, a'an li k'axal nim xcuanquil sa' lix nimajcual cuanquilal li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ut li ani ta̱c'uluk re junak ch'ina al jo' a'in sa' inc'aba' chanchan ajcui' nak la̱in xinixc'ul. ");
INSERT INTO kekNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ut li ani ta̱po'ok xch'o̱leb li toj k'uneb xch'o̱l li neque'pa̱ban cue, k'axal raj us chok' re a'an nak ta̱cutek' sa' xchamal li palau chi bac'bo junak nimla pec chixcux. ");
INSERT INTO kekNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Tok'ob ruheb li cuanqueb sa' ruchich'och' xban nak cuan c'a' re ru napo'oc re lix ch'o̱leb. Ac ch'olch'o nak cuan li c'a'ru napo'oc ch'o̱lej. Abanan raylal cha̱lel sa' xbe̱n li ani ta̱yo'oba̱nk re li c'a' re ru ta̱po'ok ch'o̱lej. ");
INSERT INTO kekNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Cui la̱ cuok malaj ut la̱ cuuk' ta̱q'uehok a̱cue chixba̱nunquil li c'a'ru inc'a' us, us raj cui ta̱yoc' ut ta̱tz'ek. K'axal us chok' a̱cue nak cua̱nk la̱ yu'am chi junelic riq'uin jun ajcui' la̱ cuok ut la̱ cuuk' chiru nak tatxic chi cuib la̱ cuok chi cuib la̱ cuuk' sa' li xbalba bar cui' inc'a' ta̱chupk li xam. ");
INSERT INTO kekNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Cui li xnak' a̱cuu ta̱q'uehok a̱cue chixba̱nunquil li inc'a' us, us raj cui ta̱cuisi ut ta̱tz'ek. K'axal us nak ta̱cua̱nk la̱ yu'am chi junelic riq'uin jun ajcui' li xnak' a̱cuu chiru nak tatxic riq'uin cuib li xnak' a̱cuu sa' li xam re li xbalba. ");
INSERT INTO kekNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","La̱in ninye e̱re cheq'uehak retal me̱tz'ekta̱na junak reheb li k'uneb xch'o̱l sa' lix pa̱ba̱l xban nak eb a'an c'ac'alenbileb xbaneb li ángel, li cuanqueb riq'uin lin Yucua' cuan sa' choxa. ");
INSERT INTO kekNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","La̱in li C'ajolbej quinc'ulun arin sa' ruchich'och' chixcolbaleb li sachenakeb sa' li ma̱c. ");
INSERT INTO kekNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿C'a'ru nequec'oxla la̱ex chirix li na'leb a'in li oc cue xyebal e̱re? Cuan ta junak li cui̱nk cuan o'c'a̱lak (100) xcarner ut cui ta̱sachk junak reheb, ¿ma inc'a' raj tixcanabeb li bele̱laju ro'c'a̱l (99) chic ut ta̱xic chiruheb li tzu̱l chixsic'bal li jun li xsach? ");
INSERT INTO kekNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Relic chi ya̱l tinye e̱re nak tixtau chak li sachenak, k'axal ta̱sahok' sa' xch'o̱l riq'uin li jun a'an chiruheb li bele̱laju ro'c'a̱l li inc'a' que'sach. ");
INSERT INTO kekNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Jo'can ajcui' le̱ Yucua' cuan sa' choxa inc'a' naraj nak ta̱sachk junak reheb li toj k'uneb xch'o̱l sa' lix pa̱ba̱l. ");
INSERT INTO kekNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Cui junak la̱ cuech aj pa̱banelil ta̱ma̱cobk cha̱cuu, ayu riq'uin ut nak cua̱nkex e̱junes, ta̱ch'olob chiru lix ma̱c. Ut cui ta̱rabi li xna'leb li ta̱q'ue, la̱at xatenk'a la̱ cuech aj pa̱banelil re nak tixc'am rib sa' usilal a̱cuiq'uin. ");
INSERT INTO kekNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Cui ut inc'a' naraj nacatrabi, c'am jun malaj cuib li herma̱n a̱cuochben re nak riq'uin li ra̱tin cuib oxib chi testigo, ta̱ch'ola̱k ru chixjunil li a̱tin. ");
INSERT INTO kekNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ut cui inc'a' naraj ta̱rabiheb a'an, ta̱ye re li iglesia re nak li herma̱n te'xch'olob xya̱lal chiru. Ut cui inc'a' ajcui' naraj abi̱nc chiruheb a'an, a'an chic ta̱cua̱nk che̱ru jo' chanchan li ma̱cua'ak aj pa̱banel ut chanchanak laj titz'ol toj li inc'a' us neque'xba̱nu. ");
INSERT INTO kekNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Relic chi ya̱l tinye e̱re nak chixjunil li c'a'ru te̱c'u̱b ru sa' xya̱lal sa' ruchich'och', li Dios tixc'u̱b ajcui' ru sa' choxa. Li c'a'ru te̱ye us arin sa' ruchich'och', li Dios tixye ajcui' nak us. Ut li c'a'ru te̱ye inc'a' us, li Dios tixye ajcui' nak inc'a' us. ");
INSERT INTO kekNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Tinye e̱re cui cuan cuibak sa' e̱ya̱nk te'xc'u̱b ru sa' cuibal chirix c'a'ru te'tijok cui', ut te'xtz'a̱ma chiru lin Yucua' cuan sa' choxa, li c'a'ru te'xtz'a̱ma ta̱q'uehek' reheb. ");
INSERT INTO kekNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Yalak bar cua̱nkeb cuib oxib ch'utch'u̱keb sa' inc'aba', aran ajcui' cua̱nkin la̱in sa' xya̱nkeb a'an, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ut laj Pedro quia̱tinac ut quixye re li Jesús: —Ka̱cua', ¿jarub sut ta̱ru̱k tincuy xma̱c li ta̱ma̱cobk chicuu? ¿Ma tento nak cuukub sut tincuy xma̱c?— ");
INSERT INTO kekNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ut li Jesús quixye re: —Inc'a' ninye a̱cue nak ca'aj cui' cuukub sut ta̱cuy xma̱c. Tinye ban a̱cue nak ta̱cuy xma̱c cuukub sut chi laje̱tk xca̱c'a̱l sut (70), chan. ");
INSERT INTO kekNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Lix nimajcual cuanquilal li Dios tinjuntak'e̱ta riq'uin jun li rey quixbir rix lix c'aseb laj c'anjel chiru. ");
INSERT INTO kekNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nak quixtiquib xbirbal rix lix c'aseb, quic'ame' chak chiru li rey jun li cui̱nk laje̱b mil chi tumin lix c'as. ");
INSERT INTO kekNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ut xban nak ma̱c'a' c'a'ru cuan re li cui̱nk a'an re tixtoj cui' lix c'as, jo'can nak li rey quixtakla xc'ayinquil a'an rech xxiquic li rixakil, ut li ralal xc'ajol ut chixjunil li c'a'ru cuan re, re xtojbal lix c'as. ");
INSERT INTO kekNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ut laj c'anjel a'an quixcuik'ib rib chiru li rey ut quixpatz' xcuybal chiru ut quixye re: —Ka̱cua', china̱cuy cuan chic ca'ch'inak, ut la̱in tintoj chixjunil lin c'as cha̱cuu.— ");
INSERT INTO kekNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ut li rey quiril xtok'oba̱l ru laj c'anjel chiru. Quirach'ab ut quixsach li retalil lix c'as. ");
INSERT INTO kekNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ut nak qui-el chak laj c'anjel riq'uin li rey, quixc'ul jun li rech aj c'anjelil cuan junmay chi tumin lix c'as riq'uin li cui̱nk a'an. Ut laj c'anjel, li quicuye' xma̱c, quixchap chi xcux li jun li cuan xc'as riq'uin ut qui-oc chixyatz'bal ut quixye re: —Toj la̱ c'as, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ut li rech aj c'anjelil quixcuik'ib rib chiru, quixpatz' xcuybal ut quixye re: —China̱cuy cuan chic ca'ch'inak ut la̱in tintoj ajcui' chixjunil lin c'as, chan re. ");
INSERT INTO kekNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Abanan li jun inc'a' quiraj xcuybal xma̱c. Co̱ ban ut coxq'ue chak sa' tz'alam toj retal quixtoj rix lix c'as. ");
INSERT INTO kekNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nak eb li rech aj c'anjelil que'ril li c'a'ru quixba̱nu, c'ajo' nak que'raho' sa' xch'o̱l. Ut que'chal cole'xch'olob chiru li rey chixjunil li c'a'ru quic'ulman. ");
INSERT INTO kekNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tojo'nak quiboke' cui'chic laj c'anjel li quicuye' xma̱c xban li rey. Ut li rey quixye re: —At tz'ekbe̱tal aj c'anjel, chixjunil la̱ c'as xinsach retalil xban nak xapatz' a̱cuybal chicuu. ");
INSERT INTO kekNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Ma inc'a' raj xru xatok'oba ru la̱ cuech aj c'anjelil jo' nak xintok'oba a̱cuu la̱in? chan. ");
INSERT INTO kekNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","C'ajo' nak quipo' li rey ut quixk'axtesi sa' ruk'eb laj ilol tz'alam toj retal quixtoj chixjunil lix c'as. ");
INSERT INTO kekNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ut jo'ca'in ajcui' tixba̱nu e̱re la̱ex lin Yucua' cuan sa' choxa cui inc'a' te̱cuy xma̱queb le̱ ras e̱ri̱tz'in chi anchal e̱ch'o̱l che̱junju̱nkalex, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ut nak quirake' chixyebal li a̱tin a'in, li Jesús qui-el Galilea ut co̱ jun pac'al li nima' Jordán sa' eb li na'ajej xcue̱nt Judea. ");
INSERT INTO kekNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ut quita̱ke̱c xbaneb li q'uila tenamit ut nabaleb li yaj quixq'uirtesiheb aran. ");
INSERT INTO kekNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Cuanqueb laj fariseo que'cuulac chi patz'oc riq'uin yal re xyalbal rix ut que'xye re: —¿C'a'ru nacaye la̱at? ¿Ma ta̱ru̱k tixjach rib li cui̱nk riq'uin li rixakil yal riq'uin c'a'ak re ru?— ");
INSERT INTO kekNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Quichak'oc li Jesús ut quixye reheb: —¿Ma inc'a' e̱rilom li tz'i̱banbil sa' li Santil Hu nak li Dios quiyo'obtesin chak re li cristian sa' xticlajic, cui̱nk ut ixk nak quixyo'obtesiheb chak? ");
INSERT INTO kekNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Jo'can nak li cui̱nk tixcanab xna' xyucua' ut tixlak'ab rib riq'uin li rixakil. Ut chi xcabichaleb junajakeb aj chic. ");
INSERT INTO kekNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Jo'can nak moco cuibakeb ta chic. Junajakeb aj ban chic. Jo'can ut nak li ani naxlak'ab li Dios, ma̱ ani chic naru najachoc re, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ut que'xye cui'chic re li Jesús: —¿C'a'ut nak quixye laj Moisés nak ta̱ru̱k xyi̱banquil junak li hu re nak tixjach rib li cui̱nk riq'uin li rixakil?— ");
INSERT INTO kekNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Li Jesús quichak'oc ut quixye: —Xban nak k'axal cau e̱ch'o̱l, jo'can nak laj Moisés quixsume che̱ru nak ta̱ru̱k te̱jach e̱rib riq'uin le̱ rixakil. Aban moco jo'can ta chak sa' xticlajic nak li Dios quixyo'obtesiheb li cristian. ");
INSERT INTO kekNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ut la̱in tinye e̱re nak yalak ani tixcanab rixakil chi ma̱cua' xma̱c yumbe̱tac, ut tixc'am jalan chic ixk, li jun a'an tixmux ru lix sumlajic. Ut li ani tixc'am chok' rixakil li ixk li canabanbil, li jun a'an tixmux ajcui' ru lix sumlajic, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ut eb lix tzolom que'xye: —Cui ya̱l nak jo'can ta̱c'ulma̱nk, k'axal us raj nak inc'a' tixsic' rixakil li cui̱nk, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ut li Jesús quixye reheb: —Moco chixjunileb ta neque'xc'ul xch'o̱l li a̱tin a'in, ca'aj cui' li ani q'uebil re xban li Dios re xtaubal ru li xya̱lal a'in. ");
INSERT INTO kekNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Cuanqueb cui̱nk chalen sa' xyo'lajiqueb ac reheb nak inc'a' te'cua̱nk rixakil, ut cuanqueb yal pok'bileb xbaneb li rech cui̱nkilal re inc'a' te'cua̱nk rixakileb, ut cuanqueb cui'chic yal inc'a' neque'xc'ul xch'o̱leb nak te'xc'am rixakil xban nak neque'xk'axtesi rib chi c'anjelac chiru li Dios. Li ani ta̱ru̱k tixtau ru li xya̱lal a'in, chixtauhak ru, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ut chirix chic a'an cuanqueb coc'al que'c'ame' chak riq'uin li Jesús re nak tixq'ue li ruk' sa' xbe̱neb ut ta̱tijok. Ut eb lix tzolom que'xk'us li que'c'amoc chak reheb li coc'al. ");
INSERT INTO kekNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Nak li Jesús quiril li yo̱queb chixba̱nunquil, quixye reheb lix tzolom: —Canabomakeb chi cha̱lc cuiq'uin li coc'al. Me̱ram chiruheb xban nak lix nimajcual cuanquilal li Dios, a'an reheb li k'uneb xch'o̱l jo' li coc'al, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ut li Jesús quixq'ue li ruk' sa' xbe̱neb ut quitijoc. Ut chirix a'an qui-el sa' li na'ajej a'an. ");
INSERT INTO kekNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ut quicuulac jun li cui̱nk riq'uin li Jesús ut quixye re: —At cha̱bil tzolonel, ¿C'a' raj ru us tinba̱nu re nak tincue̱chani li junelic yu'am? chan. ");
INSERT INTO kekNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ut li Jesús quixye re: —¿C'a'ut nak nacaye cha̱bil cue cui inc'a' nacanau anihin? Jun ajcui' li cha̱bil cuan ut a'an li Dios. Cui ta̱cuaj nak ta̱cua̱nk la̱ yu'am chi junelic ba̱nu li c'a'ru naxye li chak'rab.— ");
INSERT INTO kekNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ut li cui̱nk quixye: —¿C'a'ru li chak'rab li nacaye?— Ut li Jesús quixye re: —Ma̱camsi a̱cuas a̱cui̱tz'in. Matmuxuc caxa̱r. Mat-elk'ac. Matk'aban. ");
INSERT INTO kekNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Cha-oxlok'i la̱ na' a̱yucua' ut chara la̱ cuas a̱cui̱tz'in jo' nak nacara a̱cuib la̱at, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ut li cui̱nk quichak'oc ut quixye: —At tzolonel, chixjunil a'in xinba̱nu chalen chak sa' inca'ch'inal. ¿C'a' chic ru ma̱ji' ninba̱nu?— ");
INSERT INTO kekNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Quixye li Jesús re: —Cui ta̱cuaj nak tz'akalak re ru la̱ yu'am, ayu ut c'ayi li c'a'ru cuan a̱cue ut si lix tz'ak li ta̱c'ul reheb li neba'. Ut ta̱cua̱nk a̱biomal sa' choxa. Ut nak ac xaba̱nu a'an tatcha̱lk ut tina̱ta̱ke, chan li Jesús re. ");
INSERT INTO kekNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ut nak quirabi a'an, li cui̱nk co̱ chi ra sa' xch'o̱l xban nak nabal lix biomal cuan. ");
INSERT INTO kekNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tojo'nak quixye li Jesús reheb lix tzolom: —Relic chi ya̱l tinye e̱re, k'axal ch'a'aj chok' re junak biom nak ta̱oc rubel xcuanquil li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Tinye ajcui' e̱re nak inc'a' raj ch'a'aj nak ta̱numek' junak nimla xul camello sa' ru junak cu̱x chiru nak ta̱oc junak biom rubel xcuanquil li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ut eb lix tzolom nak que'rabi a'an, c'ajo' nak que'sach xch'o̱l ut que'xye: —¿Ani put ta̱ru̱k ta̱colek'? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ut li Jesús quixca'yaheb ut quixye reheb: —Chiru junak yal cui̱nk a'an ma̱min ta̱ru̱k, abanan chiru li Dios chixjunil naru xba̱nunquil. ");
INSERT INTO kekNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Quichak'oc laj Pedro ut quixye re: —La̱o xkacanab chixjunil li c'a'ru cuan ke xban a̱ta̱kenquil. ¿C'a'ru ta̱cua̱nk ke?— ");
INSERT INTO kekNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ut li Jesús quixye reheb: —Relic chi ya̱l tinye e̱re nak la̱in li C'ajolbej tinc'ojla̱k sa' lin lok'laj c'ojariba̱l sa' li ac' ruchich'och', la̱ex li xexta̱ken cue, texc'ojla̱k ajcui' sa' li cablaju chi c'ojariba̱l re texrakok a̱tin sa' xbe̱neb li cablaju xte̱paleb laj Israel. ");
INSERT INTO kekNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Li ani naxcanab rochoch, ras ri̱tz'in, xna' xyucua', rixakil, ralal xc'ajol, malaj xch'och' sa' inc'aba' la̱in, li jun a'an k'axal cui'chic nabal li tixc'ul chiru li quixcanab ut ta̱re̱chani li junelic yu'am. ");
INSERT INTO kekNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ut nabaleb li neque'xsic' xcuanquil anakcuan, mokon ma̱c'a'ak chic xcuanquileb. Ut li ani inc'a' neque'xsic' xcuanquil anakcuan, a'aneb chic li te'cua̱nk xcuanquil mokon, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Lix nimajcual cuanquilal li Dios chanchan jun li yucua'bej cuan sa' xjun cablal. Qui-el chak toj ek'ela chixsic'baleb aj c'anjel re te'c'anjelak sa' li racui̱mk. ");
INSERT INTO kekNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ut que'xsume c'anjelac chiru chi jun denario li cutan xtojbaleb. Ut quixtaklaheb sa' li racui̱mk chi c'anjelac. ");
INSERT INTO kekNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ut nak qui-el cui'chic sa' bele̱b o̱r, cuan cui'chic quixtauheb chak sa' c'ayil yal yo̱queb chixbaybal rib. ");
INSERT INTO kekNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ut quixye reheb: —¿Ma inc'a' xeraj c'anjelac sa' li cuacui̱mk ut texintoj chi tz'akal? chan reheb. Ut eb a'an co̱eb chi c'anjelac. ");
INSERT INTO kekNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ca' sut chic co̱ xsic'baleb xtz'akobeb lix mo̱s. Co̱ cua'leb ut co̱ cui'chic sa' oxib o̱r. ");
INSERT INTO kekNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ut nak ta̱nach'ok o̱b o̱r, co̱ cui'chic. Ut cuan cui'chic quixtauheb yo̱queb chixbaybal rib. Ut quixye reheb: —¿C'a'ut nak yo̱quex chixnumsinquil le̱ cutan arin chi ma̱c'a' le̱ trabaj? chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Que'chak'oc li cui̱nk ut que'xye re: —Xban nak ma̱ ani naq'uehoc kac'anjel.— Ut li patrón quixye reheb: —¿Ma inc'a' xeraj c'anjelac la̱ex sa' li cuacui̱mk? chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ut nak qui-ecuu, li patrón quixye re lix merto̱m: —Bokeb laj c'anjel ut ta̱tojeb. Li ta̱tojeb xbe̱n cua, a'aneb li toje' xe'oc, ut nak ac xatrake' xtojbaleb a'an, tojo'nak ta̱tojeb li xe'oc ek'ela.— ");
INSERT INTO kekNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ut nak que'chal, jun denario que'toje' cui' li junju̱nk li que'oc chi c'anjelac sa' o̱b o̱r. ");
INSERT INTO kekNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ut que'toje' ajcui' li que'oc ek'ela. Sa' xch'o̱leb a'an nak terto raj te'xc'ul chiru li que'oc ecuu. Abanan jun denario ajcui' que'xc'ul li junju̱nk. ");
INSERT INTO kekNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ut nak ac xe'xc'ul li tumin, que'oc chixcuech'bal li patrón. ");
INSERT INTO kekNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ut que'xye: —Eb a'in li xe'oc mokon jun o̱r ajcui' xe'c'anjelac. Ut juntak'e̱t lix tojbaleb xaq'ue riq'uin li xkac'ul la̱o. Ut la̱o xoc'anjelac chiru chixjunil li cutan ut xkacuy xtikcual li sak'e ut juntak'e̱t xoa̱toj riq'uineb li jun ch'o̱l chic li toj xe'oc ecuu.— ");
INSERT INTO kekNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ut quichak'oc li patrón ut quixye re jun reheb li que'oc xbe̱n cua: —At cuami̱g, la̱in xatintoj chi tz'akal. ¿Ma inc'a' ta bi' xasume c'anjelac chi jun denario li cutan? ");
INSERT INTO kekNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","C'am la̱ tojbal ut ayu. Li jo' nimal xinq'ue a̱cue la̱at, a'an ajcui' tinq'ue reheb li xe'oc mokon. ");
INSERT INTO kekNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Ma inc'a' ta bi' la̱in yal cue sa' xbe̱n li c'a'ru cue? ¿C'a'ut nak nacatcakalin? ¿Ma xban nak cha̱bilin la̱in riq'uineb? chan li patrón. ");
INSERT INTO kekNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jo'can nak nabaleb li cuanqueb xcuanquil anakcuan te'cana̱k chi ma̱c'a'ak xcuanquil mokon. Ut li ma̱c'a'eb xcuanquileb anakcuan, te'q'uehek' xcuanquileb mokon. Nabaleb li bokbileb, abanan inc'a' q'uiheb li te'xtau ru li xya̱lal. ");
INSERT INTO kekNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ut nak yo̱ chi xic Jerusalén, li Jesús quirisiheb xjunes lix tzolom cablaju ut quixye reheb: ");
INSERT INTO kekNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Q'uehomak retal li c'a'ru ta̱c'ulma̱nk. Anakcuan yo̱co chi xic Jerusalén bar cui' tink'axtesi̱k la̱in li C'ajolbej sa' ruk'eb li xbe̱nil aj tij jo' ajcui' sa' ruk'eb laj tz'i̱b. Eb a'an te'xteneb ca̱mc sa' inbe̱n. ");
INSERT INTO kekNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ut tine'xk'axtesi sa' ruk'eb li ma̱cua'eb aj judío. Ut eb a'an tine'xhob, tine'xsac', ut tine'xcamsi chiru cruz. Abanan sa' rox li cutan tincuacli̱k cui'chic chi yo'yo sa' xya̱nkeb li camenak, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Laj Jacobo ut laj Juan, a'aneb li ralal laj Zebedeo. Que'cuulac riq'uin li Jesús rochben lix na'eb. Ut li na'bej quixcuik'ib rib chiru li Jesús chixtz'a̱manquil jun usilal chiru. ");
INSERT INTO kekNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Li Jesús quixye re: —¿C'a'ru ta̱cuaj tinba̱nu a̱cue?— Ut li ixk quichak'oc ut quixye re: —Ye nak eb lin yum a'in te'c'ojla̱k cha̱c'atk sa' la̱ nimajcual cuanquilal, jun sa' la̱ nim ut jun sa' la̱ tz'e, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ut li Jesús quixye re: —Inc'a' nequenau xya̱lal li c'a'ru yo̱quex chixtz'a̱manquil. ¿Ma te̱cuy xc'ulbal li raylal li oc cue chixc'ulbal la̱in? ¿Ma te̱cuy xnumsinquil li rahobtesi̱c li tinc'ul la̱in?— Eb a'an que'xye: —Takacuy, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ut li Jesús quixye reheb: —Ya̱l ajcui' nak la̱ex te̱c'ul li raylal jo' li tinc'ul la̱in. Ut te̱cuy xnumsinquil li rahobtesi̱c jo' li tincuy xnumsinquil la̱in. Abanan li na'ajej sa' lin nim ut sa' lin tz'e ma̱cua' la̱in tinq'uehok re li na'ajej a'an xban nak ac ch'olch'o chiru lin yucua' ani aj e tixq'ue li na'ajej a'an, chan li Jesús reheb. ");
INSERT INTO kekNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ut nak que'rabi li laje̱b chic lix tzolom li Jesús li c'a'ru que'xtz'a̱ma li ri̱tz'ineb rib, que'po' riq'uineb. ");
INSERT INTO kekNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ut li Jesús quixbokeb riq'uin ut quixye reheb: —La̱ex nequenau nak li neque'taklan sa' li ruchich'och' neque'numta sa' xbe̱neb li tenamit. Li ni̱nkeb xcuanquil, a'aneb li neque'taklan. ");
INSERT INTO kekNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Abanan ma̱cua' jo'can te̱ba̱nu la̱ex. Li ani ta̱raj cua̱nk xcuanquil sa' e̱ya̱nk, tento nak tixcubsi rib ut ta̱c'anjelak che̱ru. ");
INSERT INTO kekNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ut li ani naraj nima̱k xcuanquil sa' e̱ya̱nk, tento nak tixcubsi rib ut ta̱c'anjelak che̱ru. ");
INSERT INTO kekNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","La̱in li C'ajolbej. Abanan inc'a' xinchal re nak te'xc'anjela cuu. Xinchal ban re tinc'anjelak chiruheb chixjunil ut re xq'uebal lin yu'am re xtojbal rix lix ma̱queb chixjunileb.— ");
INSERT INTO kekNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nak yo̱queb chi e̱lc Jericó, nabaleb li tenamit que'ta̱ken re li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ut cuanqueb cuibeb li mutz' chunchu̱queb chire li be. Nak que'rabi nak yo̱ chi cha̱lc li Jesús, que'xjap re chixyebal: —Ka̱cua', Ralalat xc'ajol laj David. ¡Chacuuxta̱na taxak ku!— ");
INSERT INTO kekNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ut eb li tenamit que'xch'ilaheb ut que'xye reheb nak inc'a' te'choki̱nk. A'ut eb a'an k'axal cui'chic cau que'xjap re chixyebal: —¡Ka̱cua', ralalat xc'ajol laj David, chacuuxta̱na taxak ku!— ");
INSERT INTO kekNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Quixakli li Jesús, quixbokeb ut quixye reheb: —¿C'a'ru te̱raj tinba̱nu e̱re? chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ut eb li mutz' que'xye: —Ka̱cua', takaj ta̱ilok li xnak' ku.— ");
INSERT INTO kekNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ut li Jesús quiril xtok'oba̱leb ru, quixch'e' li xnak' ruheb. Ut sa' junpa̱t que'iloc li ruheb ut que'xta̱ke li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nak ac cuulaqueb re Jerusalén, que'cuulac chire li tenamit Betfagé bar cuan cui' li tzu̱l Olivos. Ut li Jesús quixtaklaheb cuibeb lix tzolom ut quixye reheb: ");
INSERT INTO kekNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Ayukex sa' li ch'ina tenamit a'an. Ut nak texcuulak, te̱tau jun li bu̱r bac'bo aran cuan ral. Te̱hit ut te̱c'ameb chak cue. ");
INSERT INTO kekNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ut cui c'a'ru ta̱yehek' chak e̱re, te̱ye re, “Li Ka̱cua' ta̱ajok re li bu̱r ut a' que ajcui' tixtakla chak ho̱n”, cha'akex re. ");
INSERT INTO kekNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ut chixjunil a'in quic'ulman jo' quiyehe' xban li profeta nak quixye chi jo'ca'in: ");
INSERT INTO kekNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ye reheb li tenamit aj Sión: —Cue' chak le̱ Rey xchal e̱riq'uin. Tu̱lan ut c'ojc'o chak chirix jun li bu̱r. Chirix jun ch'ina ral bu̱r xcomon li neque'i̱kan yo̱ chak chi cha̱lc.— (Zac. 9:9; Is. 62:11) ");
INSERT INTO kekNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ut co̱eb lix tzolom ut que'xba̱nu jo' que'yehe' reheb xban li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Que'xc'am chak li bu̱r rochben li ral ut que'xq'ue li rak'eb sa' xbe̱neb. Ut li Jesús quitake' chirix li ch'ina bu̱r. ");
INSERT INTO kekNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ut li q'uila tenamit k'axal nabaleb. Cuan li yo̱queb chixhelbal lix t'icr sa' be bar ta̱numek' cui' li Jesús. Ut cuan li que'xyoc' chak ruk' che' ut que'xq'ue li xak sa' be. ");
INSERT INTO kekNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nak yo̱ chi xic li Jesús cuan yo̱queb chi xic chiru ut cuan yo̱queb chi xic chirix. Japjo̱queb re chixyebal: —Lok'oninbil taxak laj Colol ke, li ralal xc'ajol li rey David. Osobtesinbil taxak li yo̱ chak chi cha̱lc sa' xc'aba' li Ka̱cua' Dios. Aj Colol ke taxak li xchal chak riq'uin li Dios, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ut nak cox-ocak li Jesús sa' li tenamit Jerusalén, que'xtububi rib chixjunil ut nabaleb li tenamit yo̱queb chixyebal: —¿Ani a'in? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ut eb li tenamit li yo̱queb chi xic chirix yo̱queb chixyebal: —A'an a'in li Jesús li profeta, aj Nazaret re Galilea, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ut chirix chic a'an li Jesús qui-oc sa' li rochoch li Dios ut quixyolesiheb li yo̱queb chi c'ayi̱nc ut li yo̱queb chi lok'oc. Quixbalk'usi lix me̱xeb laj jalol ru tumin ut quixbalk'usi ajcui' lix temeb li yo̱queb chi c'ayi̱nc paloma. ");
INSERT INTO kekNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Quixye reheb: —Jo'ca'in tz'i̱banbil sa' li Santil Hu chirix li rochoch li Dios: Li cuochoch a'in re te'tijok cui' li tenamit nak cuan. Abanan la̱ex xeq'ue li rochoch li Dios chok' xna'ajeb laj e̱lk', chan li Jesús reheb. ");
INSERT INTO kekNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ut que'c'ame' riq'uin li Jesús sa' rochoch li Dios li mutz' ut eb li ye̱k rok ut li Jesús quilajxq'uirtesiheb. ");
INSERT INTO kekNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ut eb lix be̱nil aj tij ut eb laj tz'i̱b que'ril li sachba ch'o̱lej li yo̱ chixba̱nunquil. Ut que'ril nak eb li sa̱j al japjo̱queb re chixyebal sa' li rochoch li Dios: —Lok'oninbil taxak laj Colol ke, li ralal xc'ajol li rey David, chanqueb. Ut c'ajo' nak que'po' laj tij ut eb laj tz'i̱b. ");
INSERT INTO kekNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ut que'xye re li Jesús: —¿Ma yo̱cat chirabinquil li yo̱queb chixyebal li sa̱j al?— Ut li Jesús quixye reheb: —Yo̱quin chirabinquil. ¿Ma ma̱ jun cua e̱rilom li tz'i̱banbil sa' li Santil Hu li naxye chi jo'ca'in: “Eb li coc'al ut li toj neque'tu'uc neque'xq'ue xlok'al li Dios chi tz'akal”? (Sal. 8:2) ");
INSERT INTO kekNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ut li Jesús quixcanabeb ut qui-el sa' li tenamit ut co̱ toj Betania bar quihilan cui'. ");
INSERT INTO kekNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ut ek'ela nak yo̱ cui'chic chi xic Jerusalén, quichal xtz'ocajic li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ut quiril jun to̱n li che' higo chire li be. Nak quicuulac cuan cui' li che' quiril nak ma̱c'a' ru. Junes xak cuan. Quixye re li jun to̱n chi higo: —Ma̱ jun cua chic tatu̱chi̱nk, chan. Ut sa' junpa̱t quichakic li che'. ");
INSERT INTO kekNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ut nak que'ril a'an, lix tzolom que'sach xch'o̱l ut que'xye: —¿Chanru nak xchakic sa' junpa̱t lix to̱nal li higo? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Quichak'oc li Jesús ut quixye: —Relic chi ya̱l tinye e̱re nak cui te̱pa̱b chi tz'akal nak li Dios tixba̱nu, ut inc'a' ta̱cuiba̱nk e̱ch'o̱l, ta̱ru̱k ajcui' te̱ba̱nu jo' xinba̱nu la̱in re li che'. Ut moco ca'aj cui' ta raj a'an te̱ba̱nu. Ta̱ru̱k ajcui' te̱ye re li tzu̱l a'in, “Elen ut cut a̱cuib sa' li palau” ut ta̱uxk ajcui' che̱ru. ");
INSERT INTO kekNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ut chixjunil li c'a'ru te̱tz'a̱ma nak textijok, cui te̱pa̱b nak te̱c'ul, ta̱q'uehek' e̱re. ");
INSERT INTO kekNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ut qui-oc cui'chic li Jesús sa' rochoch li Dios. Ut nak yo̱ chixch'olobanquil li xya̱lal chiruheb li tenamit, que'cuulac riq'uineb li xbe̱nil aj tij ut que'cuulac ajcui' eb li xakabanbileb chi c'anjelac sa' li rochoch li Dios. Ut que'xye re: —¿Ani xtaklan chak a̱cue chixba̱nunquil li c'a'ru yo̱cat chixba̱nunquil? Ut, ¿ani xq'uehoc a̱cuanquil?— ");
INSERT INTO kekNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Quichak'oc li Jesús ut quixye reheb: —La̱in tincuaj ajcui' patz'oc e̱re. Cui te̱sume li c'a'ru tinpatz' e̱re, la̱in tinye e̱re ani xq'uehoc lin cuanquil chixba̱nunquil li c'a'ru ninba̱nu. ");
INSERT INTO kekNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Ani quitaklan chak re laj Juan chi cubsi̱nc ha'? ¿Ma li Dios malaj ut cui̱nk quitaklan re? chan reheb. Eb a'an que'xc'oxla ut que'xye chi ribileb rib: —¿C'a'ru takasume cui'? Cui takaye nak a' li Dios xtaklan chak re, a'an tixye ke c'a'ut nak inc'a' xkapa̱b li c'a'ru quixye laj Juan. ");
INSERT INTO kekNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ut cui takaye nak cui̱nk xtaklan chak re, te'pok' li tenamit sa' kabe̱n ut xiu xiu chic cua̱nko xban nak chixjunileb neque'yehoc re nak laj Juan, a'an tz'akal profeta.— ");
INSERT INTO kekNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ut eb a'an que'chak'oc ut que'xye re li Jesús: —La̱o inc'a' nakanau, chanqueb. Ut li Jesús quixye cui'chic reheb: —Chi moco la̱in tinye e̱re ani xq'uehoc lin cuanquil, chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Li Jesús quixye cui'chic reheb: ¿C'a'ru nequec'oxla chirix li oc cue chixyebal? Jun li cui̱nk cuan cuib li ralal. Ut quicuulac riq'uin li xbe̱n ralal ut quixye: —At cualal, tatxic anakcuan chi c'anjelac sa' li cuacui̱mk.— ");
INSERT INTO kekNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Quichak'oc li alalbej ut quixye: —Inc'a' nacuaj xic, chan. Abanan mokon chic quiyot'e' xch'o̱l ut co̱. ");
INSERT INTO kekNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ut li yucua'bej co̱ riq'uin li ralal jun chic ut quixtz'a̱ma chiru a'an nak ta̱xic chi c'anjelac sa' li racui̱mk. Ut li ralal quichak'oc ut quixye: —Cua', la̱in tinxic, chan. Ut inc'a' co̱. ");
INSERT INTO kekNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Ani reheb li cuib a'an xba̱nun re li quiraj lix yucua'? chan. Eb a'an que'chak'oc ut que'xye: —Li xbe̱n.— Ut li Jesús quixye reheb: —Relic chi ya̱l tinye e̱re nak eb laj titz'ol toj ut eb laj yumbe̱t te'oc xbe̱n cua che̱ru sa' lix nimajcual cuanquilal li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Xban nak quic'ulun e̱riq'uin laj Juan laj Cubsihom Ha'. Quixc'ut che̱ru c'a'ru li ti̱quilal ut inc'a' quepa̱b. Ut eb laj titz'ol toj ut eb laj yumbe̱t que'xpa̱b. Ut la̱ex queril a'an ut inc'a' quiyot'e' le̱ ch'o̱l chi moco quejal le̱ c'a'ux re xpa̱banquil, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Abihomak jun chic li jaljo̱quil ru a̱tin li oc cue xyebal: Quicuan jun yucua'bej. Quirau jun si̱r li racui̱mk uvas ut quixsut sa' corral. Quixyi̱b jun xna'aj bar te'xyatz' cui' li uvas ut quixyi̱b ajcui' jun ch'ina cab najt xteram re li ta̱c'ac'ale̱nk re li acui̱mk. Quixsiq'ueb laj ilol re li racui̱mk. Ut laj e̱chal re co̱ chi najt sa' jalan tenamit. ");
INSERT INTO kekNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nak quicuulac xk'ehil xsic'bal ru li acui̱mk, laj e̱chal re quixtaklaheb lix mo̱s riq'uineb laj ilol re li acui̱mk chixc'ulbal li jo' q'uial ru li racui̱mk li ta̱tz'ak a'an. ");
INSERT INTO kekNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Eb li mo̱s que'chape' xbaneb laj ilol re li acui̱mk. Quisaq'ue' li jun, li jun chic quicamsi̱c, ut li jun chic quicuti̱c chi pec. ");
INSERT INTO kekNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Laj e̱chal re li acui̱mk quixtakla cui'chic jun ch'o̱leb lix mo̱s, nabaleb chiru li quixtakla xbe̱n cua. Ut jo'can cui'chic que'xba̱nu reheb. ");
INSERT INTO kekNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ut inc'a' chic quixtakla lix mo̱s. A' chic li ralal quixtakla. “Li cualal te'x-oxlok'i” chan sa' xch'o̱l. Jo'can nak quixtakla li ralal riq'uineb. ");
INSERT INTO kekNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ut nak que'ril li ralal, eb laj ilol re li acui̱mk que'xye chi ribileb rib, “A'an li ralal li ta̱e̱chani̱nk re li na'ajej. Kachapak ut kacamsihak, ut la̱o chic toe̱chani̱nk re.” ");
INSERT INTO kekNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Jo'can nak que'xchap. Ut que'risi sa' li na'ajej ut que'xcamsi. ");
INSERT INTO kekNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ut li Jesús quixpatz' reheb li xbe̱nil aj tij: —Nak ta̱c'ulu̱nk laj e̱chal re li acui̱mk, ¿c'a'ru tixba̱nu riq'uineb laj ilol re li racui̱mk nak nequeye la̱ex?— ");
INSERT INTO kekNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Que'xye re: —Inc'a' ta̱ril xtok'oba̱l ruheb laj ilol re li racui̱mk li inc'a' useb xna'leb. Tixcamsiheb. Jalan chic tixsiq'ueb re te'ilok re li racui̱mk. Ut eb a'an, sa' xk'ehil li sic'oc, te'xk'axtesi chi tz'akal li jo' q'uial li ta̱tz'ak a'an, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Li Jesús quixpatz' reheb: —¿Ma inc'a' xeril sa' li Santil Hu li naxye chi jo'ca'in? Li pec li que'xtz'ekta̱na laj cablanel, a'an li k'axal lok', li quiq'ueman chok' xxuc li cab. Li Ka̱cua', a'an quixq'ue xlok'al li pec. Ut a'an xsachba ch'o̱lej chok' ke la̱o. (Sal. 118:22-23) ");
INSERT INTO kekNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jo'can nak ninye e̱re nak lix nimajcual cuanquilal li Dios ta̱mak'ek' che̱ru ut ta̱q'uehek' re jalanil tenamit ut eb a'an chic li te'pa̱ba̱nk ut te'cua̱nk sa' ti̱quilal. ");
INSERT INTO kekNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Li ani ta̱t'anek' sa' xbe̱n li pec a'in tixtoch'i rib. Ut cui ani sa' aj be̱n ta̱t'anek' li pec a'in, xujinbil ta̱cana̱k, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ut eb lix be̱nil aj tij ut eb laj fariseos que'xtau ru nak chirixeb a'an yo̱ chi a̱tinac nak quixyeheb li jaljo̱quil ru a̱tin a'in. ");
INSERT INTO kekNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ut que'xc'oxla raj xchapbal li Jesús, abanan que'xucuac xbaneb li q'uila tenamit xban nak profeta nak cuan chiruheb. ");
INSERT INTO kekNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Li Jesús quia̱tinac cui'chic riq'uineb sa' jaljo̱quil ru a̱tin. ");
INSERT INTO kekNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Quixye reheb: Lix nimajcual cuanquilal li Dios chanchan jun li rey li quixnink'ei lix sumlajic li ralal. ");
INSERT INTO kekNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Quixtaklaheb lix mo̱s chixc'ambaleb chak li ac bokbileb. A'ut eb a'an inc'a' que'raj cha̱lc. ");
INSERT INTO kekNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Quixtakla cui'chic jalaneb chic lix mo̱s ut quixye reheb: —Yehomak reheb li ac bokbileb, “Ac c'ubc'u li tzacae̱mk, ac xe'camsiman eb li cuacax ut chixjunil li xul li ni̱nk xtibeleb. Ac cauresinbil chixjunil. Cha̱lkex sa' li sumla̱c,” cha'akex reheb. ");
INSERT INTO kekNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ut eb a'an inc'a' que'raj que'rabi ut co̱eb. Cuan co̱eb sa' xc'aleba̱l ut cuan co̱eb sa' xc'ayiba̱leb. ");
INSERT INTO kekNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ut eb li jun ch'ol chic que'xchapeb lix mo̱s li rey, que'xrahobtesiheb ut que'xcamsiheb. ");
INSERT INTO kekNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ut li rey nak quirabi a'an, c'ajo' nak quijosk'o'. Quixtaklaheb lix soldado chixcamsinquil li que'camsin reheb lix mo̱s. Ut quixtakla xc'atbal lix tenamiteb. ");
INSERT INTO kekNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tojo'nak quixye reheb lix mo̱s: —Ya̱l nak li sumla̱c ac cauresinbil. Abanan li bokbileb ma̱cua' ajcui' xc'ulubeb cha̱lc sa' li sumla̱c. ");
INSERT INTO kekNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Anakcuan texxic sa' eb li be bar neque'nume' cui' li cristian. Ut te̱bokeb sa' li nink'e li ani te̱tauheb chak, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ut co̱eb lix mo̱s sa' eb li be ut que'xc'ameb sa' li nink'e li jo' q'uial que'xtau, jun chaliqueb li cha̱bil xna'leb jo' ajcui' li inc'a' useb xna'leb. Ut quinujac li cab xbaneb li ula'. ");
INSERT INTO kekNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ut qui-oc li rey chirilbaleb li rula'. Nak qui-oc, quiril aran jun li cui̱nk moco tikto ta jo' nak tikto̱queb li cuanqueb sa' li sumla̱c. ");
INSERT INTO kekNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Li rey quixye re: —At cuami̱g, ¿c'a'ut nak xat-oc chak arin chi inc'a' tikto̱cat jo' neque'xtikib rib li neque'xic sa' sumla̱c? chan. Ut li cui̱nk inc'a' quichak'oc. ");
INSERT INTO kekNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ut li rey quixye reheb lix mo̱s: —Bac'omak li rok ruk' ut cutumak sa' k'ojyi̱n chirix cab. Aran ut ta̱cua̱nk li ya̱bac ut li c'uxuxi̱nc ruch e. ");
INSERT INTO kekNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nabaleb li bokbileb aban inc'a' q'uiheb li te'xtau ru li xya̱lal. ");
INSERT INTO kekNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ut chirix a'an, co̱eb laj fariseo ut que'xc'u̱b rib re rilbal chan ta na ru nak ta̱ru̱k nak te'xyal rix li Jesús riq'uin junak a̱tin re te'xjit cui'. ");
INSERT INTO kekNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Que'xtaklaheb lix tzolom rochbeneb li neque'oquen chirix laj Herodes re nak te'a̱tinak riq'uin li Jesús yal re xsic'bal c'a'ru ta̱paltok cui' riq'uin li ra̱tin. Ut que'xye re: —At tzolonel, nakanau nak nacara li ya̱l. Ut sa' xya̱lal nacac'ut chiruheb li tenamit c'a'ru naraj li Dios ut ma̱ ani nacaxucua ru ut inc'a' nacasiq'ueb ru li ani nacara. ");
INSERT INTO kekNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ye bi' ke c'a'ru nacac'oxla chirix li na'leb a'in. ¿Ma us xq'uebal li toj re laj César li Acuabej malaj inc'a'? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ut li Jesús quixnau nak moco anchaleb ta xch'o̱l nak yo̱queb chi patz'oc. Quixtau ru lix ma̱usilaleb ut quixye reheb: —Ex aj ca'pac'al u, ¿c'a'ut nak nequeraj xyalbal cuix? ");
INSERT INTO kekNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","C'utumak chicuu li tumin li nequextojoc cui', chan reheb. Ut que'xc'ut chiru jun li tumin. ");
INSERT INTO kekNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ut li Jesús quixpatz' reheb: —¿Ani aj e li jalam u̱ch cuan chiru li tumin a'in? Ut, ¿ani aj c'aba' li tz'i̱banbil chiru? chan. ");
INSERT INTO kekNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ut que'chak'oc ut que'xye re: —Re li Acuabej, chanqueb. Ut li Jesús quixye cui'chic reheb: —Tojomak bi' re li Acuabej li c'a'ru re li Acuabej, ut tojomak re li Dios li c'a'ru re li Dios, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ut que'sach xch'o̱l nak que'rabi li c'a'ru quixye ut que'xcanab li Jesús ut co̱eb. ");
INSERT INTO kekNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sa' li cutan a'an que'cuulac riq'uin li Jesús cuib oxib laj saduceo. Eb a'an inc'a' neque'xpa̱b nak te'cuacli̱k cui'chic chi yo'yo li camenak. ");
INSERT INTO kekNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Que'xye re li Jesús: —At tzolonel, laj Moisés quixtz'i̱ba jun li chak'rab ut quixye chi jo'ca'in: Cui junak cui̱nk ta̱ca̱mk ut tixcanab li rixakil chi ma̱c'a' ralal xc'ajol, ta̱c'amek' li rixakil xban li ri̱tz'in li camenak re nak ta̱cua̱nk ralal xc'ajol sa' xc'aba' li camenak. ");
INSERT INTO kekNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Que'cuan cuukub li cui̱nk ri̱tz'ineb rib sa' kaya̱nk. Li asbej quisumla ut nak quicam ma̱ jun li ralal xc'ajol quicuan. Ut li rixakil quic'ame' xban li ri̱tz'in li camenak re nak ta̱cua̱nk ralal xc'ajol sa' xc'aba' li camenak. ");
INSERT INTO kekNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ut li cui̱nk a'an quicam ajcui' ut ma̱ jun li ralal xc'ajol quicuan. Ut jo'can cui'chic quic'ulman toj retal nak que'cam chixjunileb li cuukub chi cui̱nk ri̱tz'ineb rib. ");
INSERT INTO kekNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ut nak ac xe'cam li cuukub chi cui̱nk, quicam ajcui' li ixk. ");
INSERT INTO kekNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ut sa' xcuaclijiqueb li camenak chi yo'yo, nak te'cuacli̱k eb a'an, ¿ani aj ixakil ta̱cana̱k cui' li ixk a'an, xban nak li cuukub chi cui̱nk que'cuan chok' xbe̱lom? chanqueb re li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nak quichak'oc, li Jesús quixye reheb: —La̱ex yo̱quex chixbalak'inquil e̱rib xban nak inc'a' nequetau ru li c'a'ru naxye sa' li Santil Hu chi moco nequetau ru lix cuanquil li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nak te'cuacli̱k cui'chic chi yo'yo li camenak, chanchanakeb chic li ángel sa' choxa xban nak inc'a' te'sumla̱k chi moco te'sumuba̱nk chic. ");
INSERT INTO kekNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ut chirix lix cuaclijiqueb li camenak chi yo'yo, ¿ma inc'a' e̱rilom sa' li Santil Hu li quixye li Dios e̱re chirix lix cuaclijiqueb li camenak chi yo'yo? Quixye chi jo'ca'in: ");
INSERT INTO kekNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","La̱in lix Dios laj Abraham, lix Dios aj Isaac, ut lix Dios laj Jacob. Li Dios, a'an ma̱cua' xDioseb li camenakeb; xDioseb ban li yo'yo̱queb, chan li Jesús. (Jo'can nak li Dios quixc'ut nak cuan xcuaclijiqueb chi yo'yo li camenak.) ");
INSERT INTO kekNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ut li q'uila tenamit que'sach xch'o̱leb chirabinquil li xya̱lal li yo̱ chixch'olobanquil li Jesús chiruheb. ");
INSERT INTO kekNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ut nak laj fariseo que'xq'ue retal nak inc'a' chic que'ru xsumenquil li Jesús laj saduceo, eb a'an chic que'xch'utub ribeb chixc'u̱banquil chanru te'xba̱nu. ");
INSERT INTO kekNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ut jun reheb, aj tzolol chak'rab, quipatz'oc re li Jesús yal re xyalbal rix. ");
INSERT INTO kekNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—At tzolonel, chan re li Jesús, ¿Bar cuan li chak'rab li k'axal nim xcuanquil?— ");
INSERT INTO kekNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Li Jesús quichak'oc ut quixye re: —Li chak'rab li k'axal nim xcuanquil, a'an a'in: Ta̱ra li Ka̱cua' la̱ Dios chi anchal a̱ch'o̱l ut chi anchal la̱ cua̱m ut chi anchal la̱ c'a'ux. ");
INSERT INTO kekNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","A'an a'in li xbe̱n chak'rab, li k'axal nim xcuanquil sa' xya̱nkeb chixjunil. ");
INSERT INTO kekNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ut li xcab, chanchan ajcui' a'in: Ta̱ra la̱ cuas a̱cui̱tz'in jo' nak nacara a̱cuib la̱at. ");
INSERT INTO kekNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Cui nacaba̱nu li cuib chi chak'rab a'in ac xaba̱nu li naxye sa' chixjunil li chak'rab jo' ajcui' li yebil xbaneb li profeta, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ut nak toj ch'utch'u̱queb laj fariseo, li Jesús quixpatz' reheb: ");
INSERT INTO kekNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿C'a'ru nequec'oxla chirix li Cristo, li yechi'inbil xban li Dios? ¿Ani aj alal aj c'ajol nak nequeye?— Ut que'xye re: —Ralal xc'ajol li rey David.— ");
INSERT INTO kekNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Li Jesús quixye reheb: —¿C'a'ut nak laj David quixye li c'a'ru quirec'a sa' xch'o̱l xban li Santil Musik'ej nak quixye “Ka̱cua'” re li Cristo? Quixye chi jo'ca'in: ");
INSERT INTO kekNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Li Ka̱cua' Dios quixye re li Ka̱cua' laj Colol cue, c'ojlan sa' lin nim uk' toj tinq'ueheb li xic' neque'iloc a̱cue rubel la̱ cuanquil, chan. (Sal. 110:1) ");
INSERT INTO kekNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Li rey David quixye “Ka̱cua'” re, usta a'an xcomoneb li ralal xc'ajol.— ");
INSERT INTO kekNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ut ma̱ jun chic quiru chi sume̱nc re li Jesús. Ut chalen sa' li cutan a'an, ma̱ ani chic quixcacuu xch'o̱l chi patz'oc re li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tojo'nak li Jesús quixch'olob li xya̱lal chiruheb li q'uila tenamit jo'queb ajcui' lix tzolom ut quixye reheb: ");
INSERT INTO kekNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Eb laj tz'i̱b ut eb laj fariseo, q'uebileb xcuanquil chixch'olobanquil xya̱lal li chak'rab li quiq'uehe' re laj Moisés. ");
INSERT INTO kekNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Jo'can nak chixjunil li te'xye e̱re, chec'u̱la sa' e̱ch'o̱l ut cheba̱nu. Abanan me̱ba̱nu jo' neque'xba̱nu eb a'an xban nak yal riq'uin xtz'u̱mal reheb neque'xye ut inc'a' neque'xba̱nu li c'a'ru neque'xye. ");
INSERT INTO kekNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","K'axal a̱l li i̱k neque'xq'ue sa' xbe̱neb li cristian ut k'axal ch'a'aj xc'ambal. A'ut eb a'an chi moco riq'uin ru'uj ruk'eb neque'raj xch'e'bal. ");
INSERT INTO kekNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Chixjunil li c'a'ak re ru neque'xba̱nu, a'an yal re nak te'ilek' xbaneb li cristian. Neque'xyi̱b chi ni̱nk ru li coc' ca̱x filacterias xc'aba' bar nacuan cui' li chak'rab ut neque'xbac' sa' xpe̱quemeb ut sa' xteleb. Ut nacuulac chiruheb li rak'eb chi ni̱nk lix sahob ru chire. ");
INSERT INTO kekNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ut nak neque'xic chi cua'ac sa' eb li nink'e neque'xsic' li cha̱bil na'ajej bar te'q'uehek' xlok'al, ut neque'raj c'ojla̱c sa' li na'ajej k'axal lok' nak cuanqueb sa' li cab bar neque'xch'utub cui' ribeb laj judío. ");
INSERT INTO kekNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Eb a'an neque'raj nak te'oxlok'i̱k ut te'q'uehek' xsahil xch'o̱leb sa' eb li be. Ut neque'raj nak li tenamit te'xye “tzolonel” reheb. ");
INSERT INTO kekNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Abanan la̱ex me̱rahi ru nak li tenamit te'xq'ue e̱lok'al ut te'xye “tzolonel” e̱re xban nak jun ajcui' laj tzolol e̱re cuan. La̱in li Cristo laj tzolol e̱re ut che̱junilex la̱ex e̱ri̱tz'in e̱rib. ");
INSERT INTO kekNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ut ma̱ ani te̱q'ue chok' e̱ka̱cua' sa' ruchich'och', xban nak jun ajcui' li Ka̱cua' cuan. A'an cuan sa' choxa. ");
INSERT INTO kekNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Chi moco chec'aba'in aj c'amol be, xban nak jun ajcui' laj c'amol e̱be. A'an la̱in li Cristo. ");
INSERT INTO kekNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Li ani nac'anjelac che̱ru, a'an li k'axal nim xcuanquil sa' e̱ya̱nk. ");
INSERT INTO kekNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Li ani naxq'ue xcuanquil xjunes rib, li jun a'an ta̱cubsi̱k xcuanquil. Ut li ani naxcubsi rib, li jun a'an ta̱q'uehek' xcuanquil. ");
INSERT INTO kekNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ra cha̱lel sa' e̱be̱n, la̱ex aj tz'i̱b ut la̱ex aj fariseo, ex aj ca'pac'al u. Inc'a' nequec'ut li xya̱lal chiruheb li tenamit ut nequeram chiruheb lix cuanquil li Dios. La̱ex inc'a' nequeraj xk'axtesinquil e̱rib rubel xcuanquil li nimajcual Dios ut inc'a' ajcui' nequecanabeb chixk'axtesinquileb rib li ani neque'raj. ");
INSERT INTO kekNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ra cha̱lel sa' e̱be̱n, la̱ex aj tz'i̱b ut la̱ex aj fariseo, ex aj ca'pac'al u. Nequemak' li rochocheb li xma̱lca'an ut nequeyal xmukbal le̱ ma̱usilal riq'uin nak najt rok nequextijoc. Ut xban a'an k'axal cui'chic ra li tojbal ma̱c li ta̱cha̱lk sa' e̱be̱n. ");
INSERT INTO kekNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ra cha̱lel sa' e̱be̱n la̱ex aj tz'i̱b ut la̱ex aj fariseo, ex aj ca'pac'al u. Nequesuti li ruchich'och' jo' ajcui' li palau re xsic'bal ani ta̱pa̱ba̱nk re le̱ tijleb. Ut nak ac xe'xk'axtesi rib sa' e̱ya̱nk, k'axal cui'chic yibru xna'lebeb che̱ru la̱ex ut e̱ma̱c la̱ex nak te'xic sa' xbalba. ");
INSERT INTO kekNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ra cha̱lel sa' e̱be̱n, la̱ex mutz' aj c'amol be. La̱ex nequeye: —Li ani tixba̱nu xjuramento sa' xc'aba' lix templo li Dios, inc'a' tento tixba̱nu li quixye. Abanan li ani tixba̱nu xjuramento sa' xc'aba' li oro li cuan sa' lix templo li Dios, li jun a'an tento nak tixba̱nu li c'a'ru xye sa' xjuramento, chanquex. ");
INSERT INTO kekNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ma̱c'a' e̱na'leb ut mutz'ex xban nak inc'a' nequetau xya̱lal. ¿Bar cuan li k'axal nim xcuanquil? ¿Ma li oro, malaj a' lix templo li Dios li nasantobresin re li oro? ");
INSERT INTO kekNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ut nequeye ajcui': —Li ani naxba̱nu xjuramento sa' xc'aba' li artal, li jun a'an inc'a' tento tixba̱nu li c'a'ru quixye. Abanan li ani naxba̱nu xjuramento sa' xc'aba' li mayej cuan sa' xbe̱n li artal, tento nak tixba̱nu li c'a'ru quixye sa' lix juramento, chanquex. ");
INSERT INTO kekNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ma̱c'a' e̱na'leb ut mutz'ex xban nak inc'a' nequetau xya̱lal. ¿Bar cuan li k'axal nim xcuanquil? ¿Ma li mayej malaj a' li artal li nasantobresin re li mayej? ");
INSERT INTO kekNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Jo'can nak li ani tixba̱nu xjuramento sa' xc'aba' li artal, naxye xjuramento sa' xc'aba' a'an ut sa' xc'aba' ajcui' chixjunil li c'a'ru cuan sa' xbe̱n. ");
INSERT INTO kekNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ut li ani naxba̱nu lix juramento sa' xc'aba' lix templo li Dios, naxba̱nu sa' xc'aba' lix templo li Dios ut sa' xc'aba' ajcui' li Dios li nacuan chi sa'. ");
INSERT INTO kekNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ut li ani naxba̱nu xjuramento sa' xc'aba' li choxa, naxba̱nu xjuramento sa' xc'aba' lix c'ojariba̱l li Dios ut sa' xc'aba' ajcui' li Dios li c'ojc'o sa' xbe̱n. ");
INSERT INTO kekNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ra cha̱lel sa' e̱be̱n la̱ex aj tz'i̱b ut ex aj fariseo, ex aj ca'pac'al u. Nequemayeja lix laje̱tkil li isqui'ij, li eneldo ut li comino. Ut nequetz'ekta̱na li k'axal cuan xcuanquil sa' li chak'rab. Inc'a' nequeba̱nu li ti̱quilal. Inc'a' nequex-uxta̱nan u ut inc'a' nequexpa̱ban. Us nak nequemayeja lix laje̱tkil abanan inc'a' raj nequecanab xba̱nunquil li k'axal cuan xcuanquil. ");
INSERT INTO kekNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ex mutz' aj c'amol be, nequeyal e̱k'e chixba̱nunquil li c'a'ak re ru li ma̱c'a' xcuanquil, abanan li nim xcuanquil inc'a' nequeba̱nu. Chanchan nak nequetz'il ru le̱ ha' re nak inc'a' te̱nuk' li coc' suk ut a' chic li ni̱nki xul camello nequenuk'. ");
INSERT INTO kekNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ra cha̱lel sa' e̱be̱n la̱ex aj tz'i̱b ut aj fariseo, ex aj ca'pac'al u, xban nak a' chic li rix le̱ sec' ut le̱ plato nequech'aj, aban lix sa' numtajenak chi tz'aj xban le̱ ma̱usilal ut li elk'ac nequeba̱nu. ");
INSERT INTO kekNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ex mutz' aj fariseo, ch'ajomak xbe̱n cua lix sa' le̱ sec' ut le̱ plato re nak ch'ajbilak ajcui' li rix. ");
INSERT INTO kekNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ra cha̱lel sa' e̱be̱n la̱ex aj tz'i̱b ut la̱ex aj fariseo, ex aj ca'pac'al u. Chanchanex li neque'muke' cui' li camenak. Bonbileb rix ut c'ajo' xchak'al eb ru, a'ut chi sa' nujenak chi tz'aj ut chi xbakel camenak. ");
INSERT INTO kekNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Jo'can ajcui' la̱ex. Relic chi ya̱l nak cha̱bil nequexc'utun chiruheb li tenamit. Abanan le̱ ch'o̱l nujenak chi ma̱usilal ut la̱ex aj ca'pac'al u. ");
INSERT INTO kekNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ra cha̱lel sa' e̱be̱n la̱ex aj tz'i̱b ut la̱ex aj fariseo, ex aj ca'pac'al u. Nequeyi̱b li que'muke' cui' li profetas ut nequerutz'u'uji chak ru li que'muke' cui' li ti̱queb xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ut la̱ex nequeye: —Cui ta la̱o ac cuanco chak sa' li cutan nak xe'cuan li kaxe' kato̱n, inc'a' raj xkaba̱nu jo' que'xba̱nu eb a'an. Inc'a' raj xkacamsiheb li profetas, chanquex. ");
INSERT INTO kekNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Abanan riq'uin li ma̱usilal li nequeba̱nu la̱ex, nac'utun nak juntak'e̱tex riq'uineb le̱ xe'to̱nil yucua', li que'camsin reheb li profetas. ");
INSERT INTO kekNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Choyomak bi' xba̱nunquil li inc'a' us li que'xtiquib xba̱nunquil le̱ xe'to̱nil yucua'. ");
INSERT INTO kekNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Chanchanex c'anti', chanchanex ralex c'ambolay, ¿chan ta cui' ru nak texcolek' chiru lix tojba ma̱c sa' xbalba? ");
INSERT INTO kekNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","La̱in tintaklaheb e̱riq'uin li profeta ut li cuanqueb xna'leb ut eb laj tzolonel. Abanan la̱ex inc'a' te̱rabi. Ut sa' xya̱nkeb a'an, cuan te̱camsiheb, cuan te̱q'ueheb chiru cruz, ut cuan cui'chic li te̱rahobtesiheb sa' li cab li nequech'utub cui' e̱rib chixtzolbal ra̱tin li Dios. Ut cuan cui'chic te̱ta̱keheb sa' li junju̱nk chi tenamit re xchapbaleb. ");
INSERT INTO kekNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Xban le̱ ma̱usilal a'an, ta̱t'anek' sa' e̱be̱n lix camiqueb li cha̱bileb xna'leb riq'uin xcamic laj Abel li ti̱c xch'o̱l ut toj riq'uin xcamic li ralal laj Berequías laj Zacarías xc'aba' li quecamsi chiru neba̱l chixc'atk li rochoch li Dios ut li artal. ");
INSERT INTO kekNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Relic chi ya̱l tinye e̱re nak chixjunil li camsi̱nc que'xba̱nu chak junxil, jo' ajcui' li yo̱quex chixba̱nunquil anakcuan, ta̱t'anek' ajcui' sa' e̱be̱n la̱ex li cuanquex anakcuan xban nak yo̱quex chixba̱nunquil jo' que'xba̱nu eb a'an. ");
INSERT INTO kekNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ex aj Jerusalén, ex aj Jerusalén, neque-camsiheb li tz'akal profeta ut nequecuti chi pec eb li neque'takla̱c e̱riq'uin xban li Dios. Nabal sut raj xcuaj e̱colbal jo' nak naxch'utubeb li ral li caxlan rubel lix xic'. Abanan la̱ex inc'a' xeraj. ");
INSERT INTO kekNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ut anakcuan le̱ tenamit jo' ajcui' li templo ta̱cana̱k chi naq'uirnac aj chic ru. ");
INSERT INTO kekNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tinye ut e̱re chalen anakcuan inc'a' chic te̱ril cuu toj nak te̱ye, “Osobtesinbilak a'an li xchal sa' xc'aba' li Ka̱cua'”. Toj aran chic te̱ril cuu, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Qui-el sa' li templo li Jesús, ut nak yo̱ chi xic, que'cuulac lix tzolom riq'uin ut que'xc'ut chiru li ni̱nki cab xcue̱nt li templo. ");
INSERT INTO kekNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Quichak'oc li Jesús ut quixye reheb: —Us ajcui' nak te̱ril chi us chixjunil a'in xban nak ta̱cuulak xk'ehil nak ma̱ jun chic reheb li pec a'an ta̱cana̱k sa' xna'aj chi inc'a' ta ta̱juq'uek', chan. ");
INSERT INTO kekNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ut chirix a'an, co̱ chiru li tzu̱l Olivos ut nak li Jesús quic'ojla aran xjunes, lix tzolom que'cuulac riq'uin ut que'xye re: —Ye ke jok'e ta̱c'ulma̱nk li yo̱cat chixyebal. ¿C'a'ru talajc'ulma̱nk nak ta̱cuulak xk'ehil la̱ c'ulunic? Ut ¿c'a'ru retalil li roso'jiqueb li cutan a'in?— ");
INSERT INTO kekNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Quichak'oc li Jesús ut quixye reheb: —Cheq'uehak retal re nak ma̱ ani chibalak'i̱nk e̱re. ");
INSERT INTO kekNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nabal te'cha̱lk chi balak'i̱nc, ut te'xye nak sa' inc'aba' xe'chal, abanan moco ya̱l ta. Tole'xye, “La̱in li Cristo”, cha'keb. Ut nabal te'balak'i̱k xbaneb. ");
INSERT INTO kekNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nak te̱rabi nak yo̱ li ple̱t ut nak te̱rabi resil nak ticla̱c re li ple̱t yalak bar, mexxucuac xban nak tento nak ta̱c'ulma̱nk chi jo'can. Abanan moco ac a'an ta roso'jiqueb li cutan a'in. ");
INSERT INTO kekNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nabal li tenamit te'pletik chi ribileb rib. Ut eb li acuabej te'xpleti ribeb. Talajcua̱nk li cue'ej ut ta̱cua̱nk li yajel ut ta̱cua̱nk li hi̱c sa' nabal chi na'ajej. ");
INSERT INTO kekNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Abanan chixjunil a'an yal xticlajic li raylal li ta̱cha̱lk. ");
INSERT INTO kekNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Tojo'nak texk'axtesi̱k ut texrahobtesi̱k ut texcamsi̱k. Ut xic' tex-ilek' xbaneb chixjunileb li tenamit sa' inc'aba' la̱in. ");
INSERT INTO kekNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ut sa' eb li cutan a'an nabaleb te'xcanab lix pa̱ba̱leb. Ut a'anakeb chic li te'q'uehok reheb laj pa̱banel sa' raylal. Ut xic' chic te'ril ribeb. ");
INSERT INTO kekNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ut nabaleb li profeta aj balak' te'cha̱lk ut nabaleb te'balak'i̱k xbaneb. ");
INSERT INTO kekNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ut xban nak ta̱numta̱k li ma̱usilal, nabaleb te'xcanab xra̱baleb li ras ri̱tz'in. ");
INSERT INTO kekNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ut li ani tixcuy xnumsinquil li raylal a'in toj sa' roso'jic lix yu'am, a'an ta̱colek'. ");
INSERT INTO kekNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ut li resil lix nimajcual cuanquilal li Dios ta̱yema̱nk yalak bar jun sut rubel choxa re nak chixjunileb li tenamit te'rabi resil li colba-ib. Tojo'nak ta̱cha̱lk li roso'jiqueb li cutan. ");
INSERT INTO kekNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Chetzolak rix chi us li c'a'ru quixye li profeta Daniel re nak te̱tau ru li c'a'ru ta̱c'ulma̱nk. A'an quixye nak eb laj balak' te'rocsi sa' li rochoch li Dios bar ma̱cua' xc'ulub cui' cua̱nc li k'axal yibru ut xucuajel rilbal xban lix ma̱usilal, ut riq'uin a'an te'xmux ru lix templo li Dios. (Dan. 9:27; 12:11) ");
INSERT INTO kekNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Nak te̱ril a'an, la̱ex li cuanquex Judea, chex-e̱lelik sa' junpa̱t ut texxic toj sa' li tzu̱l. ");
INSERT INTO kekNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Li ani cua̱nk chak sa' xbe̱n li rochoch nak ta̱c'ulma̱nk a'an, chi cubec chak ut ti̱c ta̱e̱lelik ut inc'a' chic ta̱oc sa' rochoch chirisinquil li c'a'ru cuan re. ");
INSERT INTO kekNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ut li ani cua̱nk chak sa' xc'aleba̱l inc'a' chic chisuk'i̱k sa' rochoch chixxocbal li rak'. ");
INSERT INTO kekNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Tok'obak ruheb li yaj aj ixk ut li yo̱queb chi tu'resi̱nk sa' eb li cutan a'an xban nak k'axal cui'chic ch'a'aj li e̱lelic chok' reheb. ");
INSERT INTO kekNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Chextijok ut chetz'a̱ma chiru li Dios re nak inc'a' ta̱c'ulma̱nk li raylal a'in sa' habalk'e chi moco sa' li hiloba̱l cutan. ");
INSERT INTO kekNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Sa' eb li cutan a'an ma̱ ca'ch'in li raylal ta̱c'ulma̱nk. Ma̱ jun cua quic'ulman chi jo'can chalen chak sa' xticlajic li ruchich'och', chi moco ta̱c'ulma̱nk junak chic jo'can mokon. ");
INSERT INTO kekNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Cui ta ma̱c'a' sa' xch'o̱l li Ka̱cua' xrakbal ruheb li cutan a'an, ma̱ ani raj ta̱cana̱k chi yo'yo sa' ruchich'och'. Jo'can nak li Ka̱cua' tixse̱ba xrakbal ruheb li cutan a'an sa' xc'aba'eb li sic'bileb ru. ");
INSERT INTO kekNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Jo'can nak cui ani ta̱yehok e̱re, “Cue' li Cristo,” malaj, “le' cuan li Cristo,” me̱pa̱b li c'a'ru tixye. ");
INSERT INTO kekNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Nabaleb aj balak' te'c'ulu̱nk ut te'xye nak a'aneb li Cristo. Ut cuan te'xye nak a'aneb profeta. Nabal li c'a'ak re ru te'xc'utbesi ut sachba ch'o̱lej telaje'xba̱nu re xyalbal xbalak'inquileb li tenamit, jo'queb ajcui' li sic'bileb ru xban li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Abanan cheq'uehak retal. Ac xinye e̱re li c'a'ru talaje'c'ulma̱nk. ");
INSERT INTO kekNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Cui ut neque'xye e̱re, “Le' sa' li chaki ch'och' cuan li Cristo,” mexxic chirilbal. Cui ut neque'xye e̱re, “Arin cuan sa' cab,” me̱pa̱b li c'a'ru te'xye. ");
INSERT INTO kekNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","La̱in li C'ajolbej tinc'ulu̱nk sa' junpa̱t. Chanchan lix repom li ca̱k na-el chak sa' releb sak'e ut naxc'ut rib toj sa' roqueb sak'e. ");
INSERT INTO kekNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ya̱l li neque'xye nak bar cua̱nk junak camenak, aran te'xtu̱b rib li so'sol. ");
INSERT INTO kekNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ut sa' eb li cutan a'an nak acak xrake' li raylal a'an, ta̱k'ojyi̱nok' ru li sak'e ut li po inc'a' chic ta̱cutanok' ru. Ta̱ec'a̱nk chak ru li choxa ut li chahim talaje't'anek' chak. ");
INSERT INTO kekNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tojo'nak ta̱c'utu̱nk sa' choxa li cuetalil la̱in li C'ajolbej. Ut te'yot'ek' ut te'ya̱bak chixjunileb li cuanqueb sa' ruchich'och'. Ut te'ril cuu la̱in li C'ajolbej nak yo̱kin chak chi cha̱lc sa' li chok riq'uin lix nimal incuanquil ut inlok'al. ");
INSERT INTO kekNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ut nak ta̱ec'a̱nk chak chi cau li trompeta, tintaklaheb lin ángel. Ut te'xch'utub li sic'bileb ru inban li cua̱nkeb yalak bar jun sut rubel choxa jun sut sa' ruchich'och'. ");
INSERT INTO kekNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Cheq'uehak retal c'a'ru naxba̱nu li jun to̱n chi higo. Nak nak'unk'ut chak li xak chi e̱lc, riq'uin a'an te̱nau nak yo̱ chak chi nach'oc li sak'ehil. ");
INSERT INTO kekNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jo' nak li higo naxc'utbesi retalil li sak'ehil, jo'can ajcui' chixjunil li c'a'ak re ru a'an talaje'c'ulma̱nk, naxc'utbesi retalil nak yo̱ chi cuulac xk'ehil nak toline̱lk cui'chic la̱in li C'ajolbej. ");
INSERT INTO kekNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Relic chi ya̱l tinye e̱re nak toj talaje'c'ulma̱nk chixjunil li c'a'ak re ru a'in chi toj ma̱ji' neque'oso' li tenamit a'in. ");
INSERT INTO kekNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Li choxa ut li ruchich'och' talaje'osok'. Abanan li cua̱tin inc'a' ta̱cana̱k yal chi jo'can chi inc'a' ta ta̱c'ulma̱nk chixjunil li c'a'ak re ru xinye. ");
INSERT INTO kekNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Abanan ma̱ ani nana'oc re jok'e lix k'ehil ut lix ho̱nal inc'ulunic. Eb li ángel sa' choxa inc'a' neque'xnau chi moco la̱in li C'ajolbej ninna'oc re. Ca'aj cui' li Dios Acuabej nana'oc re jok'e ta̱c'ulma̱nk a'in. ");
INSERT INTO kekNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Jo' quic'ulman sa' xcutan laj Noé, jo'can ajcui' ta̱c'ulma̱nk nak toline̱lk cui'chic la̱in li C'ajolbej. ");
INSERT INTO kekNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Sa' eb li cutan a'an nak toj ma̱ji' quicuan li but'i ha', eb li tenamit yo̱queb chak chi cua'ac ut yo̱queb chi uc'ac, ut yo̱queb chi sumla̱c ut chi sumuba̱nc toj sa' li cutan nak qui-oc laj Noé sa' li jucub cab. ");
INSERT INTO kekNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ut inc'a' que'xtau xya̱lal toj quichal li but'i ha' ut quilaje'c'ame' chixjunileb xban li but'. Chanchan ajcui' a'an nak toline̱lk cui'chic la̱in li C'ajolbej. ");
INSERT INTO kekNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Sa' li cutan a'an cuib li cui̱nk cua̱nkeb sa' c'aleba̱l, jun aj pa̱banel ut jun li ma̱cua' aj pa̱banel. Ut laj pa̱banel, a'an li ta̱c'amek' xban li Dios ut li jun chic li ma̱cua' aj pa̱banel, a'an ta̱canaba̱k. ");
INSERT INTO kekNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ut cuib li ixk yo̱keb chi que'ec sa' jun chi que'leb, jun aj pa̱banel ut jun li ma̱cua' aj pa̱banel. Ut laj pa̱banel, a'an li ta̱c'amek' xban li Dios ut li jun chic li ma̱cua' aj pa̱banel, a'an ta̱canaba̱k. ");
INSERT INTO kekNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Jo'can nak yo'on cua̱nkex xban nak inc'a' nequenau jok'e ho̱nal toline̱lk la̱in li Ka̱cua'. ");
INSERT INTO kekNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Chenauhak a'in: nak cui ta naxnau li yucua'bej sa' li cab jok'e ho̱nal re li k'ojyi̱n tol-e̱lk laj e̱lk', ta̱yo'lek raj ut inc'a' raj tixcanab chi elk'ac xsa' li rochoch. ");
INSERT INTO kekNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jo'can ajcui' la̱ex yo'on cua̱nkex chi oybeni̱nc xban nak inc'a' nequenau jok'e ho̱nal tincuulak la̱in li C'ajolbej. Tincuulak chi ma̱c'a' sa' e̱ch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","¿Ani ut laj c'anjel cha̱bil ut cuan xna'leb? A'an li quiq'uehe' xcuanquil xban lix patrón sa' xbe̱neb li rech mo̱sil ut a'an ta̱q'uehok re xtzacae̱mkeb sa' x-o̱ril. ");
INSERT INTO kekNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Us xak re laj c'anjel a'an li yo̱k chixba̱nunquil chi jo'can nak tol-e̱lk lix patrón. ");
INSERT INTO kekNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Relic chi ya̱l tinye e̱re nak lix patrón tixk'axtesi sa' ruk', chixjunil lix juncablal. ");
INSERT INTO kekNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Aban cui laj c'anjel a'an inc'a' us lix na'leb, tixye sa' xch'o̱l, “Lin patrón ta̱ba̱yk chak chi c'ulu̱nc.” ");
INSERT INTO kekNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ut ta̱oc chixsac'baleb li rech aj c'anjelil, ut ta̱oc chi cua'ac ut chi uc'ac rochbeneb li calajenak. ");
INSERT INTO kekNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ut ma̱c'a'ak sa' xch'o̱l nak tol-e̱lk lix patrón. ");
INSERT INTO kekNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ut ta̱c'ajtesi̱k ru ut ta̱q'uehek' sa' xya̱nkeb laj ca'pac'al u. Ut aran ta̱cua̱nk li ya̱bac ut li c'uxuxi̱nc ruch e. ");
INSERT INTO kekNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Lix nimajcual cuanquilal li Dios, a'an chanchan li quic'ulman sa' jun li sumla̱c. Li laje̱b chi tuk' ix que'xc'am lix candil ut co̱eb sa' jun li sumla̱c chixc'ulbal li be̱lomej. ");
INSERT INTO kekNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","O̱b cuanqueb xna'leb ut li o̱b chic ma̱c'a' xna'lebeb. ");
INSERT INTO kekNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Li o̱beb li ma̱c'a'eb xna'leb inc'a' que'xcauresi rib chi us. Que'xc'am lix candil, abanan inc'a' que'xc'am xya'al lix candil. ");
INSERT INTO kekNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ut li cuanqueb xna'lebeb que'xcauresi rib chi us, que'xc'am lix candil ut que'xc'am ajcui' lix ya'al. ");
INSERT INTO kekNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ut nak quibay chak li be̱lomej, neque'xi̱kan chixjunileb toj retal quicube xcuaraheb. ");
INSERT INTO kekNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ut sa' tuktu k'ojyi̱n, que'rabi nak yo̱queb chixjapbal reheb li tenamit chixyebal: —Cue' chak li be̱lomej. Ayukex, c'ulumak chak, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ut li laje̱b chi tuk' ix que'aj ru ut que'oc xyi̱banquil lix candil. ");
INSERT INTO kekNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ut li o̱b li ma̱c'a'eb xna'leb que'xye reheb li o̱b chic li cuanqueb xna'leb: —Jec'omak bayak xya'al li kaxam xban nak chupc re li kacandil, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Aban li cuanqueb xna'leb que'xye: —Inc'a' naru. Inc'a' ta̱tz'aklok li xya'al li ke cui takaq'ue e̱re la̱ex. Ayukex riq'uineb laj c'ay. Lok'omak chak e̱re, chanqueb reheb. ");
INSERT INTO kekNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ut cuanqueb chak chixlok'bal lix ya'al lix candil nak col-e̱lk li be̱lomej. Ut li o̱b chic li cuanqueb xya'al lix candil que'oc rochben sa' li cab. Ut quitz'ape' li oqueba̱l. ");
INSERT INTO kekNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ut nak que'suk'i chak li o̱b chi tuk' ix chixlok'bal xya'al lix xameb, que'oc chibokoc sa' li oqueba̱l ut que'xye: —Ka̱cua', te li cab chiku, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ut li be̱lomej quichak'oc ut quixye reheb: —Relic chi ya̱l tinye e̱re inc'a' ninnau e̱ru.— ");
INSERT INTO kekNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jo'can nak la̱in ninye e̱re: Yo'on cua̱nkex xban nak inc'a' nequenau li cutan chi moco li ho̱nal jok'e toline̱lk la̱in li C'ajolbej. ");
INSERT INTO kekNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ut lix nimajcual cuanquilal li Dios, a'an chanchan jun li cui̱nk li ac xic re chi najt. Quixbokeb lix mo̱s riq'uin ut quixk'axtesi lix tumin sa' ruk'eb lix mo̱s. ");
INSERT INTO kekNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Quixq'ue o̱b mil pe̱s re li jun, cuib mil re li jun chic ut quixq'ue jun mil re li jun chic. Quixq'ue re li junju̱nk a' yal chanru lix se̱bal xch'o̱l chi rilbal. Tojo'nak co̱ chi najt. ");
INSERT INTO kekNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ut li mo̱s li quic'uluc re li o̱b mil pe̱s, qui-oc chi yacoc chiru ut quire̱chani o̱b mil pe̱s chic sa' xbe̱n li quixc'ul. ");
INSERT INTO kekNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ut jo'can cui'chic quixba̱nu li quic'uluc re li cuib mil pe̱s. Ut quire̱chani cuib mil pe̱s chic sa' xbe̱n li quixc'ul. ");
INSERT INTO kekNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","A'ut li mo̱s li quic'uluc re li jun mil pe̱s, co̱ ut quixbec jun li jul sa' ch'och'. Ut aran quixmuk li jun mil pe̱s li quiq'uehe' re xban lix patrón. ");
INSERT INTO kekNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ut najterak chic, quic'ulun lix patroneb laj c'anjel a'an. Quixbokeb lix mo̱s chixk'axtesinquil xcue̱nteb. ");
INSERT INTO kekNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ut quicuulac li mo̱s li quic'uluc re li o̱b mil pe̱s. Ut quixc'am chak li o̱b mil li quixc'ul ut quixc'am chak ajcui' li o̱b mil chic li xbe̱n li quire̱chani, ut quixye: —Ka̱cua', o̱b mil pe̱s caq'ue cue. Cuaye' la̱ tumin ut o̱b mil chic xcue̱chani chak sa' xbe̱n li caq'ue cue, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ut lix patrón quixye re: —K'axal us xaba̱nu. La̱at cha̱bilat ut tz'akalat aj c'anjel. Sa' xbe̱n li ca'ch'in xink'axtesi a̱cue, cha̱bil xat-el. Anakcuan tink'axtesi chic nabal a̱cue. Chisahok' sa' la̱ ch'o̱l xban nak tattz'ako̱nk ajcui' riq'uin li sahil ch'o̱lejil li cuan cuiq'uin la̱in, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ut li mo̱s li quic'uluc re li cuib mil pe̱s quicuulac ut quixye: —Ka̱cua', caq'ue cue cuib mil pe̱s ut cuib mil pe̱s chic xcue̱chani chak sa' xbe̱n, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ut lix patrón quixye re: —Us xaba̱nu. Cha̱bilat aj c'anjel. Riq'uin li ca'ch'in xinq'ue a̱cue, us xat-el. Anakcuan tink'axtesi a̱cue nabal chic. Chisahok' sa' la̱ ch'o̱l xban nak tattz'ako̱nk ajcui' riq'uin li sahil ch'o̱lejil li cuan cuiq'uin la̱in, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ut quicuulac ajcui' li jun chic li quic'uluc re li jun mil pe̱s ut quixye re lix patrón: —Ka̱cua', ninnau nak josk'at la̱at. Nacatk'oloc bar inc'a' nacat-au cui', ut nacatxococ bar cui' inc'a' nacatpajin iyaj. ");
INSERT INTO kekNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Jo'can nak quinxucuac ut co̱in ut coxinmuk sa' ch'och' li caq'ue cue. Cue' li jun mil pe̱s li caq'ue cue, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ut li patrón quijosk'o' ut quixye re: —Inc'a' us la̱ na'leb. Inc'a' nacacuaj trabajic. Xanau nak nink'oloc bar inc'a' nin-au cui'. Ut xanau nak ninxococ bar inc'a' ninpajin cui' iyaj. ");
INSERT INTO kekNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Jo'can ut tento nak xaq'ue raj lin tumin reheb laj to' tumin. Ut sa' inc'ulunic, xinc'ul raj ral lin tumin rochben raj li xaq'ue chi to', chan. ");
INSERT INTO kekNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ut li patrón quixye reheb lix mo̱s li cuanqueb aran: —Mak'omak chiru li jun mil pe̱s ut q'uehomak re li ani aj iq'uin cuan li laje̱b mil pe̱s. ");
INSERT INTO kekNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Chixjunil li ani cuan nabal reheb, mas cui'chic ta̱q'uema̱nk re ut k'axal cui'chic nabal ta̱cua̱nk re. Ut li ani ca'ch'in ajcui' cuan re, ta̱mak'ma̱nk chiru li jo' q'uial cuan re. ");
INSERT INTO kekNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ut laj c'anjel a'in, ma̱c'a' na-oc cui'. Isihomak arin ut q'uehomak sa' k'ojyi̱n. Aran ta̱cua̱nk li ya̱bac ut li c'uxuxi̱nc ruch e, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Nak tincha̱lk la̱in li C'ajolbej riq'uin xnimal inlok'al cuochbenakeb chak chixjunileb li ángel, tojo'nak toxinc'ojla̱k sa' lin c'ojariba̱l retalil xnimal incuanquil chi rakoc a̱tin. ");
INSERT INTO kekNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ut te'ch'utuba̱k chicuu chixjunil xte̱paleb li tenamit li cuanqueb sa' ruchich'och'. Tojo'nak tinsiq'ueb ru ut tinq'ueheb sa' cuib ch'u̱tal jo' nak li pastor narisiheb lix carner sa' xya̱nkeb li chiba̱t. ");
INSERT INTO kekNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ut tinq'ueheb lin carner sa' lin nim uk' ut eb li chiba̱t tinq'ue sa' intz'e. ");
INSERT INTO kekNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ut la̱in li Rey tinye reheb li cuanqueb sa' lin nim: —Osobtesinbilex xban lin Yucua'. E̱chanihomak li nimajcual cuanquilal cauresinbil chok' e̱re chalen chak sa' xticlajic li ruchich'och'. ");
INSERT INTO kekNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Te̱re̱chani xban nak quintz'oca chak ut quine̱q'ue chi cua'ac. Quichakic cue ut quine̱q'ue chi uc'ac. Quinsic' cuochochnal ut quine̱c'ul e̱riq'uin. ");
INSERT INTO kekNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nak ma̱c'a' cuak', queq'ue cuak'. Nak quinyajer, quine̱tenk'a. Nak quincuan sa' tz'alam, coxine̱ril chak. ");
INSERT INTO kekNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ut eb li ti̱queb xch'o̱l te'xye cue: —Ka̱cua', ¿jok'e ta bi' catkil chi tattz'oca̱k ut jok'e ta bi' catkaq'ue chi cua'ac? ¿Jok'e ta bi' catkil chi ta̱chakik a̱cue ut jok'e ta bi' catkaq'ue chi uc'ac? cha'keb cue. ");
INSERT INTO kekNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Jok'e ta bi' casic' a̱cuochochnal ut catkac'ul ta kiq'uin? ¿Jok'e ta bi' catkil chi ma̱c'a' a̱cuak' ut quikaq'ue ta a̱cuak'? ");
INSERT INTO kekNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Jok'e ta bi' catkil chi yajat ut catkatenk'a ta? ¿Jok'e catcuan sa' tz'alam ut coxatkil ta chak? cha'keb. ");
INSERT INTO kekNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ut la̱in tinchak'ok ut tinye reheb: —Relic chi ya̱l tinye e̱re, cui queba̱nu a'in re junak li neque'pa̱ban cue, usta cubenak xcuanquil, cue ajcui' la̱in queba̱nu chak. ");
INSERT INTO kekNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Tojo'nak la̱in li Rey tinye reheb li cuanqueb sa' lin tz'e: —Elenkex chicuu. Tz'ekta̱nanbilex sa' li xam li ma̱ jok'e ta̱chupk c'u̱banbil chak chok' re laj tza ut reheb ajcui' lix ángel. ");
INSERT INTO kekNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Xban nak la̱in quintz'oca chak ut inc'a' quine̱q'ue chi cua'ac. Quichakic chak cue ut inc'a' quine̱q'ue chi uc'ac. ");
INSERT INTO kekNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Quinsic' li cuochochnal ut inc'a' quine̱c'ul e̱riq'uin. Ma̱c'a' cuak' ut inc'a' queq'ue cuak'. Quinyajer ut inc'a' quine̱tenk'a. Quincuan chi pre̱xil ut inc'a' coxine̱ril chak, cha'kin reheb. ");
INSERT INTO kekNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ut te'chak'ok ut te'xye cue: —Ka̱cua', ¿jok'e ta bi' catkil chi tattz'oca̱k? ¿Jok'e ta bi' catkil chi ta̱chakik a̱cue? ¿Jok'e casic' a̱cuochochnal? ¿Jok'e catkil chi ma̱c'a' la̱ cuak' malaj yajat, malaj cuancat sa' tz'alam ut inc'a' catkatenk'a? cha'keb. ");
INSERT INTO kekNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ut la̱in li Rey tinchak'ok ut tinye reheb: —Relic chi ya̱l tinye e̱re, xban nak inc'a' quetenk'aheb li neque'pa̱ban cue li ma̱c'a'eb xcuanquil, inc'a' ajcui' quine̱tenk'a la̱in, cha'kin reheb. ");
INSERT INTO kekNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ut eb a'an te'xic sa' li tojba ma̱c chi junelic. Abanan li ti̱queb xch'o̱l cua̱nkeb xyu'am chi junelic. ");
INSERT INTO kekNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ut nak quirake' li Jesús chixyebal chixjunil li a̱tin a'in, quixye reheb lix tzolom: ");
INSERT INTO kekNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—La̱ex nequenau nak cuib cutan chic ma̱ nacuulac xk'ehil li pascua re xnink'einquil chanru nak que'cole' ut que'el laj Israel sa' li tenamit Egipto. Ut la̱in li C'ajolbej tink'axtesi̱k re nak tinq'uehek' chiru cruz. ");
INSERT INTO kekNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ut eb lix be̱nil aj tij ut eb laj tz'i̱b ut eb li neque'c'amoc be sa' xya̱nkeb laj judío que'xch'utub ribeb chiru neba̱l re li rochoch lix yucua'ileb laj tij, Caifás xc'aba'. ");
INSERT INTO kekNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ut que'xc'u̱b ribeb re nak te'xchap li Jesús ut re nak te'xyo'ob a̱tin chirix re xcamsinquil. ");
INSERT INTO kekNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ut que'xye chiribileb rib: —Inc'a' takachap li Jesús nak yo̱k li nink'e xban nak te'pok' li tenamit sa' kabe̱n ut te'oc chi pletic kiq'uin, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Li Jesús cuan aran Betania sa' rochoch laj Simón li saklep rix. ");
INSERT INTO kekNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Chunchu sa' me̱x nak quicuulac jun li ixk. Cuan jun ch'ina me̱t yi̱banbil riq'uin li terto̱quil pec alabastro xc'aba'. Cuan li sununquil ban chi sa', k'axal terto xtz'ak. Li ixk quixq'ue li ban sa' xjolom li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nak que'ril a'an, eb lix tzolom que'josk'o' ut que'xye chi ribileb rib: —¿C'a'ut nak xsach li sununquil ban a'in chi ma̱c'a' rajbal? ");
INSERT INTO kekNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Xru raj xc'ayiman chi k'axal terto xtz'ak ut xkajeq'ui raj li tumin reheb li neba', chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Li Jesús quixnau li c'a'ru yo̱queb chixyebal ut quixye reheb: —¿C'a'ut nak yo̱quex chixch'i'ch'i'inquil li ixk a'in? Canabomak xcuech'inquil xban nak us li xba̱nu cue. ");
INSERT INTO kekNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Li neba' junelic cua̱nkeb sa' e̱ya̱nk. Abanan la̱in moco cua̱nkin ta chi junelic e̱riq'uin. ");
INSERT INTO kekNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Li ixk a'in us li xba̱nu cue nak xq'ue li sununquil ban sa' inbe̱n. Ma̱ji' nincam abanan ac xinixban re lin mukbal. ");
INSERT INTO kekNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Relic chi ya̱l tinye e̱re yalak bar ta̱yema̱nk resil li colba-ib sa' chixjunil li ruchich'och', ta̱yema̱nk ajcui' resil li c'a'ru xba̱nu cue li ixk a'in re xjulticanquil a'an, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ut laj Judas Iscariote, jun reheb li cablaju chi xtzolom li Jesús, co̱ riq'uineb lix be̱nil aj tij. ");
INSERT INTO kekNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ut quixye reheb: —¿Jo' nimal te̱q'ue cue cui tink'axtesi li Jesús e̱re? chan reheb. Ut eb a'an que'xc'u̱b nak te'xq'ue laje̱b xca'c'a̱l chi tumin plata re. ");
INSERT INTO kekNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ut chalen sa' li cutan a'an, laj Judas yo̱ chixsic'bal jok'e tixq'ue rib re nak tixk'axtesi li Jesús sa' ruk'eb. ");
INSERT INTO kekNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Sa' li xbe̱n cutan re li nink'e nak neque'xcua' li caxlan cua chi ma̱c'a' xch'amal, que'chal lix tzolom riq'uin li Jesús ut que'xye re: —¿Bar ta̱cuaj takacauresi chak li na'ajej re ta̱tzaca cui' li mayejanbil xul? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ut li Jesús quixye reheb: —Ayukex sa' li tenamit riq'uin li cui̱nk li xinye e̱re, ut te̱ye re, “Chan laj tzolonel nak cuulac re xk'ehil lix camic. Ta̱raj xnumsinquil li nink'e Pascua sa' la̱ cuochoch rochbeneb lix tzolom,” cha'kex re li cui̱nk. ");
INSERT INTO kekNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ut eb lix tzolom que'xba̱nu jo' que'yehe' reheb xban li Jesús ut aran que'xcauresi li nink'e. ");
INSERT INTO kekNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ut nak qui-ecuu sa' li cutan a'an, quic'ojla li Jesús sa' me̱x rochbeneb lix cablaju chi tzolom. ");
INSERT INTO kekNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ut nak yo̱queb chi cua'ac, li Jesús quixye reheb: —Relic chi ya̱l tinye e̱re nak jun e̱re la̱ex ta̱k'axtesi̱nk cue sa' ruk'eb li xic' neque'iloc cue, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ut ma̱c'a' jo' nak que'raho' sa' xch'o̱leb. Ut chi xjunju̱nkaleb que'xpatz' re: —¿Ma la̱in ta bi' tink'axtesi̱nk a̱cue, Ka̱cua'?— ");
INSERT INTO kekNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Quichak'oc li Jesús ut quixye reheb: —Li ta̱k'axtesi̱nk cue, a'an li tixtz'a xcaxlan cua sa' li sec' li tintz'a cui' li cue la̱in. ");
INSERT INTO kekNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Relic chi ya̱l la̱in li C'ajolbej tincamsi̱k jo' tz'i̱banbil retalil chicuix sa' li Santil Hu. Abanan raylal cuan sa' xbe̱n li cui̱nk a'an li ta̱k'axtesi̱nk cue. K'axal us raj chok' re li cui̱nk a'an nak inc'a' raj quiyo'la, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tojo'nak quichak'oc laj Judas li ta̱k'axtesi̱nk re ut quixye: —¿Malaj ut la̱in li yo̱cat chinyebal, at tzolonel? Ut li Jesús quixye re: —La̱at xaye a̱cuib. ");
INSERT INTO kekNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ut nak yo̱queb chi cua'ac, li Jesús quixchap li caxlan cua. Quixbantioxi chiru li Dios, quixjachi, tojo'nak quixjeq'ui reheb lix tzolom. Ut quixye reheb: —C'ulumak, cua'omak. A'an a'in lin tz'ejcual.— ");
INSERT INTO kekNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ut quixchap ajcui' li sec' re uc'ac ut quixbantioxi chiru li Dios ut quixq'ue reheb ut quixye reheb: —Uc'umak li cuan sa' li sec' a'in che̱junilex, ");
INSERT INTO kekNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","xban nak a'an a'in lin quiq'uel li ta̱hoyek' re nak ta̱cuyek' xma̱queb nabal chi tenamit. Ut a'an ta̱xakaba̱nk xcuanquil li Ac' Contrato. ");
INSERT INTO kekNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Relic chi ya̱l tinye e̱re nak chalen anakcuan inc'a' chic tincuuc' lix ya'al ru li uva toj nak ta̱cuulak xk'ehil nak tincuuc' cui'chic cuochbenex sa' lix nimajcual cuanquilal lin Yucua', chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nak ac xe'rake' xbichanquil jun li bich re xlok'oninquil li Dios, que'co̱eb sa' li tzu̱l Olivos. ");
INSERT INTO kekNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ut li Jesús quixye reheb: —Che̱junilex la̱ex ta̱ch'ina̱k le̱ ch'o̱l sa' inc'aba' la̱in ut tine̱canab injunes chiru li k'ojyi̱n a'in jo' tz'i̱banbil retalil sa' li Santil Hu: Tincanab chi camsi̱c laj ilol reheb li carner ut eb li carner te'xcha'cha'i ribeb. (Zac. 13:7) ");
INSERT INTO kekNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ut nak acak xincuacli cui'chic chi yo'yo sa' xya̱nkeb li camenak la̱in xbe̱n cua tinxic che̱ru la̱ex aran Galilea, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ut laj Pedro quichak'oc ut quixye: —Usta chixjunileb tate'xcanab, abanan la̱in inc'a' tatincanab, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ut li Jesús quixye re: —Relic chi ya̱l yo̱quin chixyebal a̱cue nak chiru li k'ojyi̱n a'in toj ma̱ji' naya̱bac laj tzo' xul nak la̱at ac xaye oxib sut nak inc'a' nacanau cuu.— ");
INSERT INTO kekNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ut laj Pedro quixye cui'chic: —Ma̱ jok'e tinye nak inc'a' ninnau a̱cuu, usta tine'xcamsi a̱cuochben, chan. Ut jo'can ajcui' que'xye chixjunileb lix tzolom. ");
INSERT INTO kekNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Li Jesús quicuulac rochbeneb lix tzolom sa' li na'ajej Getsemaní. Ut quixye reheb lix tzolom: —C'ojlankex cuan arin roybeninquil nak tinxic chi tijoc toj le', chan. ");
INSERT INTO kekNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ut quixc'am chirix laj Pedro jo'queb ajcui' li cuib chi ralal laj Zebedeo. Ut li Jesús qui-oc chi rahoc sa' xch'o̱l ut c'ajo' nak ta̱yot'ek' xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ut quixye reheb: —Cuan jun raylal sa' inch'o̱l ut yo̱ chinyot'bal. Inc'a' chic nincuy nak nacuec'a. Cana̱kex arin ut yo'lenkex cuochben, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ut quibe̱c chic ca'ch'in li Jesús ut quixhupub rib sa' ch'och' ut quitijoc. Ut quixye: —At inYucua', cui ta naxq'ue rib, inc'a' raj tinc'ul li raylal a'in. Abanan chi-uxma̱nk li c'a'ru nacacuaj la̱at ut ma̱cua' li nacuaj la̱in.— ");
INSERT INTO kekNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ut nak quisuk'i riq'uineb lix tzolom, quixtauheb chi cua̱rc. Ut quixye re laj Pedro: —¿Ma toj yo̱quex chi cua̱rc? ¿Ma inc'a' xru xexyo'lec jun o̱rak cuochben? ");
INSERT INTO kekNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Chexyo'lek ut chextijok re nak inc'a' te̱q'ue e̱rib chi a̱le̱c. La̱ex nequeraj raj xba̱nunquil li us, abanan e̱junes inc'a' texru̱k, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ut li Jesús co̱ cui'chic xca' sut chi tijoc ut quixye: —At inYucua', cui ta naxq'ue rib nak inc'a' raj tinc'ul li raylal a'in, abanan chi-uxma̱nk li c'a'ru nacacuaj la̱at.— ");
INSERT INTO kekNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ut nak quisuk'i cui'chic li Jesús, quixtauheb cui'chic chi cua̱rc lix tzolom xban nak ma̱ ca'ch'in lix cuaraheb. ");
INSERT INTO kekNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Quixcanabeb ut co̱ cui'chic chi tijoc rox sut ut jo'can cui'chic quixtz'a̱ma chiru li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tojo'nak quichal cui'chic riq'uineb lix tzolom ut quixye reheb: —¿Ma toj yo̱quex chi cua̱rc? Tz'akalak li hila̱nc xeba̱nu. Ac xtau xk'ehil nak la̱in li C'ajolbej tink'axtesi̱k sa' ruk'eb laj ma̱c. ");
INSERT INTO kekNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Cuaclinkex anakcuan, yo'keb; cue' chak li ta̱k'axtesi̱nk cue sa' ruk'eb li xic' neque'iloc cue, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Toj yo̱ ajcui' chi a̱tinac li Jesús nak cox-e̱lk laj Judas. A'an jun reheb li cablaju. Nabal que'chal rochben taklanbileb chak xbaneb li xbe̱nil aj tij ut xbaneb laj c'amol be sa' xya̱nkeb laj judío. Cuanqueb xch'i̱ch' ut cuanqueb xche'. ");
INSERT INTO kekNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Li ta̱k'axtesi̱nk re ac xc'u̱b chak rib riq'uineb c'a'ru li retalil li tixc'ut. Quixye reheb: —Li ani tincuutz' ru, a'an li te̱chap.— ");
INSERT INTO kekNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ut laj Judas co̱ chi junpa̱t riq'uin li Jesús ut quixye re: —¿Chan xacuil, at tzolonel?— ut quirutz' ru. ");
INSERT INTO kekNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ut li Jesús quixye re: —Cuami̱g, ¿c'a'ru a̱cuajom arin?— Tojo'nak que'nach'oc riq'uin li Jesús ut que'xchap. ");
INSERT INTO kekNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ut jun reheb li rochben li Jesús quirisi chak lix ch'i̱ch' ut quixch'ot lix xic lix mo̱s li xbe̱nil aj tij. ");
INSERT INTO kekNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tojo'nak quiyehe' re xban li Jesús: —Q'ue la̱ ch'i̱ch' sa' lix na'aj xban nak chixjunileb li neque'pletic riq'uin ch'i̱ch', riq'uin ch'i̱ch' ajcui' te'osok'. ");
INSERT INTO kekNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Ma inc'a' nacanau nak naru tintz'a̱ma chiru lin Yucua' ut a'an tixtakla raj chak anakcuan anakcuan q'uila ok'ob chi ángel chincolbal? ");
INSERT INTO kekNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Abanan cui tixtakla raj chak eb li ángel, ¿chan raj ru nak ta̱tz'aklok ru li tz'i̱banbil sa' li Santil Hu, li naxye nak jo'ca'in tento ta̱c'ulma̱nk? chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ut sa' li ho̱nal a'an li Jesús quixye reheb li q'uila tenamit, —¿Ma la̱in ta bi' aj e̱lk' nak xexchal chinchapbal riq'uin che' ut riq'uin ch'i̱ch'? Rajlal cutan ninc'ojla sa' e̱ya̱nk che̱tzolbal sa' li rochoch li Dios ut inc'a' quine̱chap aran. ");
INSERT INTO kekNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Abanan chixjunil a'in x-uxman re nak ta̱tz'aklok ru li Santil Hu tz'i̱banbil xbaneb li profeta. Tojo'nak que'e̱lelic chixjunileb lix tzolom ut que'xcanab xjunes li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ut li Jesús quic'ame' riq'uin laj Caifás, lix yucua'ileb laj tij. Aran ch'utch'u̱queb laj tz'i̱b ut eb li neque'c'amoc be sa' xya̱nkeb laj judío. ");
INSERT INTO kekNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ut laj Pedro chi najt yo̱ chak chixta̱kenquil li Jesús ut quicuulac toj chi ru'uj neba̱l sa' rochoch lix yucua'ileb laj tij. Qui-oc aran ut quic'ojla sa' xya̱nkeb laj c'ac'alenel re nak ta̱ril c'a'ru ta̱cana̱k cui'. ");
INSERT INTO kekNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ut eb li xbe̱nil aj tij ut eb li neque'c'amoc be sa' xya̱nkeb laj judío ut chixjunileb li neque'tz'iloc a̱tin yo̱queb chixsic'bal chanru nak te'xyo'ob junak a̱tin chirix li Jesús re nak ta̱ru̱k te'xk'axtesi chi camsi̱c. ");
INSERT INTO kekNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Abanan inc'a' que'xtau usta nabal chi testigo aj tic'ti'eb cuanqueb aran. Toj que'cuulac cuib chic li testigo aj tic'ti'eb, tojo'nak que'xtau chanru te'xjit cui'. ");
INSERT INTO kekNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Li cuib a'an que'xye: —Jo'ca'in quixye li cui̱nk a'in, “La̱in ta̱ru̱k tinjuc' li rochoch li Dios ut chiru oxib cutan tinyi̱b cui'chic”, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ut quixakli lix yucua'ileb laj tij ut quixye re li Jesús: —¿C'a'ru nacaye la̱at? ¿Ma ma̱c'a' nacaye chirix li yo̱queb chixyebal cha̱cuix?— ");
INSERT INTO kekNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ut li Jesús ma̱ jun li a̱tin quixye. Ut li xyucua'ileb aj tij quixye cui'chic re: —Sa' xc'aba' li yo'yo̱quil Dios ta̱ye ke cui la̱at li Cristo, li Ralal li Dios.— ");
INSERT INTO kekNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ut li Jesús quixye re: —Ya̱l li xaye la̱at. Ut tinye ajcui' e̱re nak chalen anakcuan tine̱ril la̱in li C'ajolbej nak c'ojc'o̱kin sa' xnim uk' li nimajcual Dios ut tine̱ril ajcui' nak yo̱kin chak chi cha̱lc cui'chic sa' li chok sa' choxa, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nak quirabi a'an, li xyucua'ileb laj tij quixpej li rak' xban xjosk'il ut quixye: —A'an xjuntak'e̱ta rib riq'uin li Dios. ¿C'a' chic ru aj e nak toj te'xye ke c'a'ru lix ma̱c? Ac xerabi nak xjuntak'e̱ta rib riq'uin li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿C'a'ru nequeye? ¿Ma cuan xma̱c malaj inc'a'? chan. Ut que'chak'oc ut que'xye: —Cuan xma̱c ut xc'ulub nak ta̱camsi̱k.— ");
INSERT INTO kekNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tojo'nak cuan que'chu̱ban re sa' ru. Ut cuan que'sac'oc re ut cuan que'pak'len re chi ruk'eb. ");
INSERT INTO kekNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ut que'xye re: —At Cristo, ye ke ani xsac'oc a̱cue, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Laj Pedro cuan chirix cab c'ojc'o chi ru'uj neba̱l. Quicuulac jun li ixk, xmo̱s li xyucua'ileb laj tij. Quixye re laj Pedro: —La̱at jun reheb li xe'ochbenin re li Jesús aj Galilea.— ");
INSERT INTO kekNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Laj Pedro quitic'ti'ic chiruheb chixjunileb ut quixye: —La̱in inc'a' ninnau ru ani nacaye, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ut jun chic li ixk qui-iloc re nak yo̱ chi e̱lc chire li cab. Ut quixye reheb li cuanqueb aran: —Li cui̱nk a'in, a'an jun qui-ochbenin re li Jesús aj Nazaret. ");
INSERT INTO kekNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ut laj Pedro quitic'ti'ic cui'chic xca' cua. Quixpatz' xc'aba' li Dios ut quixye: —Inc'a' ninnau ru li cui̱nk a'an, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ut junpa̱tak chican, li cuanqueb aran que'jiloc riq'uin laj Pedro ut que'xye re: —Relic chi ya̱l nak la̱at xcomoneb xban nak la̱ cua̱tinoba̱l nac'utuc re nak la̱at aj Galilea.— ");
INSERT INTO kekNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ut laj Pedro qui-oc chi majecua̱nc ut quixye riq'uin juramento: —Inc'a' ninnau ru li cui̱nk a'an, chan. Ut sa' ajcui' li ho̱nal a'an quiya̱bac laj tzo' xul. ");
INSERT INTO kekNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ut sa' junpa̱t quinak sa' xch'o̱l laj Pedro li a̱tin li quiyehe' re xban li Jesús, “Nak toj ma̱ji' naya̱bac laj tzo' xul, la̱at ac xaye oxib sut nak inc'a' nacanau cuu.” Ut laj Pedro ma̱ c'ajo' nak quiyot'e' xch'o̱l. Qui-el chirix cab ut c'ajo' nak quiya̱bac. ");
INSERT INTO kekNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ut nak quisake̱u, que'xch'utub ribeb chixjunileb lix be̱nil aj tij ut eb laj c'amol be sa' xya̱nkeb laj judío. Que'xc'u̱b rib chanru te'xba̱nu re nak ta̱camsi̱k li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Que'xc'am li Jesús chi bac'bo ut que'xk'axtesi sa' ruk' laj Pilato li acuabej. ");
INSERT INTO kekNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ut laj Judas li quik'axtesin re li Jesús, c'ajo' nak quiyot'e' xch'o̱l riq'uin li quixba̱nu nak quiril nak quiteneba̱c ca̱mc sa' xbe̱n li Jesús. Quixk'ajsi li laje̱b xca'c'a̱l chi tumin plata reheb lix be̱nil aj tij ut reheb li neque'c'amoc be sa' xya̱nkeb laj judío. ");
INSERT INTO kekNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Quixye reheb: —Xinma̱cob nak xink'axtesi e̱re li cui̱nk a'in xban nak ma̱c'a' xma̱c, chan. A'ut eb a'an que'xye re: —¿C'a' takaj re la̱o? Il c'a'ru ta̱ba̱nu.— ");
INSERT INTO kekNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ut laj Judas quixcut li tumin sa' rochoch li Dios. Ut co̱ ut quixyatz' rib. ");
INSERT INTO kekNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ut eb lix be̱nil aj tij que'xxoc li tumin ut que'xye: —Inc'a' us xq'uebal li tumin a'in sa' xcaxil lix mayej li rochoch li Dios xban nak xtz'ak xyu'am li cui̱nk.— ");
INSERT INTO kekNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ut que'xc'u̱b ru nak te'xlok' jun li ch'och' re te'mukek' cui' li jalaneb xtenamit. Ut chiru li tumin a'an que'xlok' li na'ajej a'an riq'uin laj pac'onel. ");
INSERT INTO kekNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jo'can nak chalen anakcuan quicana chok' xc'aba' li na'ajej a'an “Lok'bil riq'uin Quic'.” ");
INSERT INTO kekNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ut riq'uin a'in quitz'akloc ru li quixye li profeta Jeremías nak quixye: ");
INSERT INTO kekNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ut que'xchap li laje̱b xca'c'a̱l chi tumin plata, xtz'ak li quik'axtesi̱c. Lix tz'ak a'an li tenebanbil sa' xbe̱n xbaneb laj Israel. Ut chiru li tumin a'an que'xlok' jun li ch'och' riq'uin laj pac'onel, jo' quiyehe' cue xban li Ka̱cua'. (Zac. 11:12-13) ");
INSERT INTO kekNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Que'xc'am li Jesús ut que'xxakab chiru laj Pilato li acuabej. Ut laj Pilato quixpatz' re: —¿Ma la̱at lix Reyeb laj judío?— Li Jesús quichak'oc ut quixye re: —Ya̱l li xaye nak la̱in.— ");
INSERT INTO kekNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ut nak yo̱ xjitbal xbaneb lix be̱nil aj tij ut eb li neque'c'amoc be chiruheb laj judío, chi ti̱c inc'a' quichak'oc. ");
INSERT INTO kekNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ut laj Pilato quixye re: —¿Ma inc'a' nacacuabi jo' q'uial li yo̱queb chixyebal cha̱cuix?— ");
INSERT INTO kekNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Aban li Jesús ma̱ jun li a̱tin quixye re tixcol rib ut riq'uin a'an quisach xch'o̱l laj Pilato. ");
INSERT INTO kekNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Rajlal chihab sa' li nink'e Pascua li acuabej narach'ab junak li pre̱x a' ya̱l ani te'raj li tenamit ta̱ach'aba̱k jo' c'aynakeb xba̱nunquil. ");
INSERT INTO kekNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Sa' eb li cutan a'an cuan sa' tz'alam jun li cui̱nk na'no ru chi us, aj Barrabás xc'aba'. ");
INSERT INTO kekNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ut nak ch'utch'u̱queb li q'uila tenamit, laj Pilato quixpatz' reheb: —¿Ani te̱raj tincuach'ab? ¿Ma laj Barrabás, malaj ut li Jesús li Cristo neque'xye re? chan laj Pilato. ");
INSERT INTO kekNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Laj Pilato naxnau nak xban xcakaleb xch'o̱l li xbe̱nil aj tij nak que'xk'axtesi li Jesús sa' rakleb a̱tin. ");
INSERT INTO kekNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nak laj Pilato c'ojc'o sa' lix na'aj li narakoc cui' a̱tin, li rixakil quixtakla xyebal re: —Ma̱c'a' ta̱ba̱nu re li cui̱nk a'an xban nak ma̱c'a' xma̱c. Sa' xc'aba' a'an nak k'axal ra xinmatq'ue chi k'ek, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ut eb li xbe̱nil aj tij ut eb li neque'c'amoc be sa' xya̱nkeb laj judío que'xtacchi'i li q'uila tenamit re nak te'xye nak a' laj Barrabás li ta̱ach'aba̱k, ut a' li Jesús ta̱camsi̱k. ");
INSERT INTO kekNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ut li acuabej quixpatz' reheb: —¿Bar cuan reheb li cuib a'in te̱raj tincuach'ab?— Ut eb a'an que'xye: —A' laj Barrabás, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Quixye laj Pilato reheb: —Ut, ¿c'a' put ru ta̱ru̱k tinba̱nu la̱in riq'uin li Jesús, li Cristo neque'xye re?— Ut chixjunileb que'xye: —¡Chiq'uehek' chiru cruz!— ");
INSERT INTO kekNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ut li acuabej quixye reheb: —¿C'a'ut? ¿C'a'ru tz'akal xma̱c e̱re?— Ut eb a'an k'axal cau cui'chic que'xjap re chixyebal: —¡Chiq'uehek' chiru cruz!— ");
INSERT INTO kekNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ut laj Pilato quiril nak inc'a' qui-el chi us li quiraj xba̱nunquil ut quixq'ue retal nak k'axal cui'chic nak que'po' xch'o̱l li tenamit. Tojo'nak quixtakla xc'ambal lix ha' re xch'ajbal li ruk' chiruheb li tenamit ut quixye: —Ma̱c'a' inma̱c la̱in riq'uin xcamic li cui̱nk a'in li ma̱c'a' xma̱c. La̱ex chic yal e̱re sa' xbe̱n, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ut chixjunileb li tenamit que'chak'oc ut que'xye: —Sa' kabe̱n la̱o ut sa' xbe̱neb li kalal kac'ajol chicana̱k xtojbal rix lix camic, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tojo'nak laj Pilato quirach'ab laj Barrabás chiruheb li tenamit. Ut quixtakla xsac'bal li Jesús riq'uin tz'u̱m ut quixk'axtesi sa' ruk'eb li soldado re nak te'xq'ue chiru cruz. ");
INSERT INTO kekNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ut eb lix soldado li acuabej que'xc'am li Jesús sa' li po̱pol ut que'xch'utub ribeb chixjunileb li soldado ut que'xsut li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Que'risi li rak' ut que'xq'ue jun caki t'icr chirix jo' neque'rocsi li rey. ");
INSERT INTO kekNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ut que'xtz'ul jun li corona riq'uin q'uix ut que'xq'ue sa' xjolom. Ut sa' xnim uk' que'xq'ue jun li che'. Ut que'xcuik'ib ribeb chiru ut que'retz'u ut que'xye: —Sahak taxak sa' a̱ch'o̱l, at xReyeb laj judío, chanqueb re. ");
INSERT INTO kekNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Quilaje'xchu̱ba, ut que'xchap li che' ut riq'uin a'an que'xsac' sa' xjolom. ");
INSERT INTO kekNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ut nak ac xe'xtacuasi, que'risi li t'icr li cuan chirix. Ut que'xq'ue cui'chic li rak' chirix. Tojo'nak que'xc'am re nak te'xq'ue chiru cruz. ");
INSERT INTO kekNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ut nak yo̱queb chi xic, que'xc'ul jun li cui̱nk aj Simón xc'aba', Cirene xtenamit. Eb li soldado que'xmin ru a'an chixpakonquil lix cruz li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ut que'cuulac sa' li na'ajej Gólgota xc'aba'. Chi jalbil ru naraj naxye: Xna'aj Xbakel Xjolom Camenak. ");
INSERT INTO kekNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ut que'xq'ue vino re li Jesús yubil riq'uin c'ahil ban re xcotzbal li raylal, abanan nak quixyal, inc'a' quiruc'. ");
INSERT INTO kekNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ut mokon nak ac que'xq'ue chiru cruz, eb li soldado que'bu̱lic chirix li rak' re rilbal ani na ta̱e̱chani̱nk re li rak'. Jo'ca'in quitz'akloc ru li yebil xban li profeta nak quixye: Que'xjeq'ui chi ribileb rib li cuak' ut que'bu̱lic chirix lin t'icr. (Sal. 22:18) ");
INSERT INTO kekNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Que'c'ojla aran ut que'oc chixc'ac'alenquil li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Sa' xbe̱n li cruz que'xq'ue jun retalil c'a'ut nak que'xcamsi ut naxye: A'an a'in li Jesús, lix Reyeb laj judío. ");
INSERT INTO kekNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ut cuib aj e̱lk' que'q'uehe' chiru cruz rochben, jun sa' xnim ut jun sa' xtz'e. ");
INSERT INTO kekNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ut eb li tenamit yo̱queb chi numec' aran, que'xhob li Jesús ut neque'rec'asi xjolomeb. ");
INSERT INTO kekNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ut que'xye: —¿Ma ma̱cua' ta bi' la̱at li cat-ajoc re xjuc'bal rochoch li Dios, ut yal chiru oxib cutan raj xayi̱b cui'chic? Xacol raj a̱cuib. Cui ya̱l nak la̱at Ralalat li Dios, cuben chak chiru li cruz, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Jo'can ajcui' eb li xbe̱nil aj tij yo̱queb chixhobbal li Jesús rochbeneb laj tz'i̱b ut eb li neque'c'amoc be sa' xya̱nkeb laj judío. ");
INSERT INTO kekNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Ut que'xye: —Jalan chic xcoleb ut a'an inc'a' naru naxcol rib xjunes. Cui ya̱l nak a'an xReyeb laj judío, chicubek chak chiru li cruz anakcuan ut topa̱ba̱nk chiru. ");
INSERT INTO kekNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Cau xch'o̱l riq'uin li Dios. Chicolek' anakcuan cui narahe' xban li Dios xban nak naxye nak a'an Ralal li Dios, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ut jo'can eb ajcui' laj e̱lk' li que'q'uehe' chiru cruz rochben, yo̱queb chixhobbal. ");
INSERT INTO kekNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tuktu cua'leb nak quik'ojyi̱no' sa' chixjunil li ruchich'och' ut toj sa' oxib o̱r re ecuu quicutano' cui'chic. ");
INSERT INTO kekNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ut ca'ch'in chic ma̱ oxib o̱r nak quia̱tinac li Jesús chi cau xya̱b xcux ut quixye: —Elí, Elí, ¿lama sabactani?— Chi jalbil ru naraj naxye: At inDios, at inDios, ¿c'a'ut nak xina̱canab injunes? ");
INSERT INTO kekNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nak que'rabi li c'a'ru quixye li cuanqueb aran, cuan li que'yehoc: —Abihomak, yo̱ chixbokbal li profeta Elías, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ut jun sa' xya̱nkeb co̱ sa' a̱nil ut coxtz'a chak jun li esponja sa' vinagre ut quixtaksi chi ru'uj jun li che' ut quixq'ue sa' re li Jesús re ta̱ruc'. ");
INSERT INTO kekNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ut li jun ch'o̱l chic que'xye: —Kilak cuan ma ta̱cha̱lk na laj Elías chixcolbal, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","A'ut li Jesús quixjap cui'chic re chi cau ut qui-el xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ut li t'icr li cuan chok' tas sa' li Santil Na'ajej sa' li rochoch li Dios quik'iche' sa' xyi. Quiticla chak takec' ut toj tak'a coxrake' lix k'ichilal. Ca' jachal qui-el. Qui-ec'an li ch'och' ut eb li sako̱nac quilaje'itz'e'. ");
INSERT INTO kekNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Quilaje'teli li que'muke' cui' li camenak ut nabaleb li ti̱queb xch'o̱l que'cuacli cui'chic chi yo'yo. ");
INSERT INTO kekNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ut mokon chic nak li Jesús ac xcuacli cui'chic chi yo'yo, que'el chak sa' lix mukleba̱l ut que'oc sa' li santil tenamit Jerusalén ut nabal chi aj u que'xc'utbesi cui' ribeb. ");
INSERT INTO kekNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ut li capitán rochbeneb li yo̱queb chi c'ac'ale̱nc re li Jesús, que'rec'a li hi̱c ut que'xq'ue retal li c'a'ru yo̱ chi c'ulma̱nc. Ma̱ c'ajo' nak que'xucuac ut que'xye: —Relic chi ya̱l nak li cui̱nk a'in tz'akal Ralal li Dios.— ");
INSERT INTO kekNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ut cuanqueb ajcui' ixk yo̱queb chak chi iloc chi najt. Eb a'an toj Galilea que'xta̱ke chak li Jesús ut que'c'anjelac chiru. ");
INSERT INTO kekNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Sa' xya̱nkeb a'an cuanqueb lix María aj Magdala, ut lix María xna'eb laj Jacobo ut laj José, ut lix na'eb li ralal laj Zebedeo. ");
INSERT INTO kekNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ac yo̱ chi oc k'ojyi̱n nak quicuulac aran bar que'xcamsi cui' li Jesús jun li cui̱nk biom, aj José xc'aba'. Arimatea xtenamit. A'an xtzolom ajcui' li Jesús nak quicuan. ");
INSERT INTO kekNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Li cui̱nk a'in co̱ riq'uin laj Pilato ut quixtz'a̱ma chiru nak ta̱q'uehek' re lix tz'ejcual li Jesús re nak tixmuk. Ut laj Pilato quixtakla xk'axtesinquil re. ");
INSERT INTO kekNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ut laj José quixc'am li camenak ut quixlan sa' jun li ac' t'icr lino. ");
INSERT INTO kekNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ut quixq'ue sa' jun li ac' mukleba̱l. Re raj a'an li mukleba̱l nak quiyi̱ba̱c sa' jun sako̱nac. Ut quixbalk'usi jun nimla pec chire li mukleba̱l ut co̱. ");
INSERT INTO kekNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ut cuanqueb aran lix María aj Magdala ut lix María jun chic. C'ojc'o̱queb aran chi xca'yaba̱l li mukleba̱l. ");
INSERT INTO kekNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jo' cuulajak chic, nak ac xnume' lix cutanquil li cauresi̱nc re li hiloba̱l cutan, que'xch'utub ribeb li xbe̱nil aj tij rochbeneb laj fariseo. Que'co̱eb riq'uin laj Pilato. ");
INSERT INTO kekNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ut que'xye re: —Ka̱cua', xjultico' ke li a̱tin quixye laj balak' nak toj yo'yo̱k. Quixye nak sa' rox li cutan ta̱cuacli̱k cui'chic chi yo'yo. ");
INSERT INTO kekNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Takla xq'uebal retal chi us li mukleba̱l toj ta̱numek' li oxib cutan. Ma̱re te'cha̱lk lix tzolom chi k'ek chirelk'anquil li camenak ut te'xye reheb li tenamit, “Xcuacli cui'chic chi yo'yo sa' xya̱nkeb li camenak.” Ut k'axal cui'chic ch'a'aj toe̱lk la̱o chiru li xkac'ul xbe̱n cua. ");
INSERT INTO kekNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ut laj Pilato quixye reheb: —Cue'queb jun ch'u̱tal chi soldado. Ayukex rochbeneb ut q'uehomak retal nak te'xba̱nu chi us. La̱ex nequenau chanru te̱ba̱nu, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ut co̱eb ut que'xtz'ap chi us li mukleba̱l ut que'xq'ue retalil li pec ut que'xcanab li soldado aran chixc'ac'alenquil li mukleba̱l. ");
INSERT INTO kekNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nak ac xnume' li hiloba̱l cutan, sake̱uc re li xbe̱n cutan re li xama̱n, quicuulac lix María aj Magdala rochben lix María jun chic chirilbal li mukleba̱l. ");
INSERT INTO kekNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Toj ma̱ji' ajcui' neque'cuulac nak quicuan jun nimla hi̱c. Ut jun x-ángel li Ka̱cua' quicube chak sa' choxa ut quixbalk'usi li pec ut quic'ojla sa' xbe̱n. ");
INSERT INTO kekNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Li riloba̱l nalemtz'un chanchan rak' ca̱k ut li rak' sak sak jo' li ratz'am que. ");
INSERT INTO kekNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ut eb li yo̱queb chi c'ac'ale̱nc re li mukleba̱l neque'sicsot xban xxiuheb chirilbal li quic'ulman. Chanchan camenak que'cana. ");
INSERT INTO kekNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ut nak que'cuulac li ixk, li ángel quixye reheb: —Mexxucuac la̱ex. La̱in ninnau nak yo̱quex chixsic'bal li Jesús li quicam chiru cruz. ");
INSERT INTO kekNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ma̱ ani chic arin. Ac xcuacli chi yo'yo jo' quixye e̱re. Quimkex arin. Ilomak lix na'aj bar que'xq'ue cui' li Ka̱cua'. ");
INSERT INTO kekNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ayukex sa' junpa̱t ut yehomak reheb lix tzolom nak ac xcuacli chi yo'yo sa' xya̱nkeb li camenak. Ut anakcuan ta̱xic Galilea ut a'an xbe̱n cua ta̱cuulak che̱ru la̱ex. Aran toxe̱ril ru. Ca'aj cui' a'in li tinye e̱re, chan li ángel. ");
INSERT INTO kekNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Te'xucuak li ixk nak que'el sa' li mukleba̱l. Abanan quisaho' ajcui' sa' xch'o̱leb riq'uin li c'a'ru que'rabi. Ut co̱eb sa' a̱nil chixyebal resil reheb lix tzolom li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Yo̱queb chi xic nak xaka̱mil li Jesús chiruheb ut quixq'ue xsahileb xch'o̱l. Ut eb li ixk que'nach'oc riq'uin ut que'xcuik'ib ribeb chiru. Que'xk'alu li rok ut que'xlok'oni. ");
INSERT INTO kekNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Li Jesús quixye reheb: —Mexxucuac. Ayukex ut yehomak resil reheb lin herma̱n re nak te'xic Galilea. Ut aran te'ril cuu, chan. ");
INSERT INTO kekNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ut nak yo̱queb chi xic li ixk, cuanqueb laj c'ac'alenel que'co̱eb sa' tenamit chixyebal resil reheb lix be̱nil aj tij chixjunil li c'a'ak re ru quic'ulman. ");
INSERT INTO kekNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ut lix be̱nil aj tij que'xch'utub ribeb rochbeneb li neque'c'amoc be sa' xya̱nkeb laj judío ut que'xc'u̱b ribeb nak te'xq'ue nabal li tumin reheb li soldado. ");
INSERT INTO kekNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ut que'xye reheb: —Jo'ca'in te̱ye: “Eb lix tzolom que'cuulac chi k'ek ut que'relk'a li camenak nak yo̱co chi cua̱rc,” cha'kex. ");
INSERT INTO kekNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ut que'xye cui'chic reheb li soldado li que'c'ac'alen re li mukleba̱l: —Cui ta̱rabi resil a'in li acuabej, la̱o to-oque̱nk che̱rix ut texkacol, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ut eb li soldado que'xc'ul li tumin ut que'xba̱nu jo' que'yehe' reheb. Ut li resil a'in quisutun sa' xya̱nkeb laj judío chalen toj sa' li cutan anakcuan. ");
INSERT INTO kekNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ut lix tzolom junlaju co̱eb Galilea sa' xbe̱n li tzu̱l li que'yehe' reheb xban li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ut nak que'ril ru li Jesús, que'xlok'oni. Abanan cuanqueb sa' xya̱nkeb lix tzolom li que'cuiban xch'o̱l chixpa̱banquil. ");
INSERT INTO kekNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Li Jesús quinach'oc riq'uineb ut quixye reheb: —Chixjunil li cuanquil q'uebil cue xban li Dios, jo' sa' choxa jo' sa' ruchich'och'. ");
INSERT INTO kekNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jo'can utan texxic sa' chixjunil li ruchich'och' ut te̱ch'olob li xya̱lal chiruheb chixjunileb li tenamit re nak te'pa̱ba̱nk. Te̱cubsiheb xha' sa' xc'aba' li Dios Acuabej, sa' xc'aba' li Dios C'ajolbej ut sa' xc'aba' li Dios Santil Musik'ej. ");
INSERT INTO kekNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Te̱c'ut chiruheb xpa̱banquil chixjunil li xinye chak e̱re. Chenauhak nak la̱in cua̱nkin e̱riq'uin chixjunil li cutan chalen toj sa' roso'jic li ruchich'och'. Jo'can taxak.");
INSERT INTO kekNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jo'ca'in nak quiticla chak resilal li colba-ib sa' xc'aba' li Jesucristo li Ralal li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Li profeta Isaías quixtz'i̱ba li a̱tin li quixye li Dios re li Ralal: Xbe̱n cua tintakla junak lin takl. A'an ta̱yehok resil la̱ c'ulunic re nak te'xcauresi rib li tenamit re a̱c'ulbal. ");
INSERT INTO kekNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","A'an tixch'olob xya̱lal sa' li chaki ch'och' chi cau xya̱b xcux. Tixye: Yi̱bomak le̱ yu'am ut yo'on cua̱nkex chixc'ulbal li Ka̱cua' jo' nak neque'xyi̱b li be re xc'ulbal junak li nim xcuanquil. (Is. 40:3) ");
INSERT INTO kekNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jo'can nak co̱ laj Juan laj Cubsihom Ha' sa' li chaki ch'och' ut yo̱ chi cubsi̱nc ha' ut yo̱ chixch'olobanquil lix ya̱lal chiruheb ut quixye: —Canabomak li ma̱cobc. Chi yot'ek' e̱ch'o̱l ut chejal e̱c'a'ux ut chec'ul li cubi ha' ut li Dios tixcuy tixsach le̱ ma̱c, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nabaleb laj Judea ut nabaleb ajcui' laj Jerusalén que'cuulac cuan cui' laj Juan chirabinquil li c'a'ru yo̱ chixyebal. Que'xxo̱to xma̱c chiru li Dios ut laj Juan quixcubsi xha'eb sa' li nima' Jordán. ");
INSERT INTO kekNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Li rak' narocsi laj Juan, a'an yi̱banbil riq'uin rix li xul camello ut lix c'a̱mal xsa', a'an tz'u̱m. Ut aj sa̱c' naxtzaca riq'uin xya'al sak c'au. ");
INSERT INTO kekNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Naxjultica li ra̱tin li Dios reheb li tenamit ut naxye: —Cha̱lc re jun chic li k'axal nim xcuanquil chicuu la̱in. Xban nak k'axal nim xcuanquil, moco inc'ulub ta nak tinc'utzub cuib re xhitbal xc'a̱mal lix xa̱b. ");
INSERT INTO kekNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","La̱in xincubsi e̱ha' riq'uin ha'. Aban a'an tixq'ue e̱re li Santil Musik'ej, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Sa' eb li cutan a'an li Jesús qui-el chak Nazaret xcue̱nt Galilea. Quicuulac riq'uin laj Juan ut laj Juan quixcubsi xha' aran sa' li nima' Jordán. ");
INSERT INTO kekNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ut nak qui-el chak li Jesús sa' li ha', quiril nak quiteli li choxa, ut li Santil Musik'ej quicube chak sa' xbe̱n li Jesús. Chanchan jun li paloma nak yo̱ chak chi cubec. ");
INSERT INTO kekNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ut qui-abi̱c xya̱b xcux li Dios toj sa' choxa. Quixye chi jo'ca'in: —La̱at li cualal k'axal raro̱cat inban. Nasaho' inch'o̱l a̱cuiq'uin, chan li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ut chirix a'in, li Jesús qui-ec'asi̱c lix ch'o̱l xban li Santil Musik'ej re nak ta̱xic sa' li chaki ch'och' bar ma̱c'a' cui' cristian. ");
INSERT INTO kekNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ca'c'a̱l cutan quicuan chak xjunes sa' li na'ajej a'an sa' xya̱nkeb li josk' aj xul. Ut chiru li ca'c'a̱l cutan a'an, li Jesús quiyale' ra̱lenquil xban laj tza, aban inc'a' quixq'ue rib chi a̱le̱c. Ut eb lix ángel li Dios que'cuulac chi c'anjelac chiru. ");
INSERT INTO kekNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ac cuan laj Juan laj Cubsihom Ha' sa' tz'alam nak co̱ li Jesús Galilea ut yo̱ chixjulticanquil resil li colba-ib li naxq'ue li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Li Jesús quixye: —Xcuulac xk'ehil lix nimajcual xcuanquilal li Dios. Chiyot'ek' e̱ch'o̱l chejal e̱c'a'ux ut pa̱bomak li Santil Evangelio, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ut nak coxnumek' li Jesús chire li palau cuan Galilea quixtau laj Simón rochben laj Andrés li ri̱tz'in. Yo̱queb chixq'uebal lix yoy sa' li palau xban nak a'aneb aj chapol car. ");
INSERT INTO kekNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Li Jesús quixye reheb, —Chine̱ta̱ke. Ma̱cua' chic caribc te̱ba̱nu. E̱ras e̱ri̱tz'in ban chic te̱sic' re te'pa̱ba̱nk, chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ut sa' junpa̱t que'xcanab lix yoy ut que'xta̱ke li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Junpa̱t chic quibe̱c li Jesús nak coxtauheb li ralal laj Zebedeo. Laj Jacobo ut laj Juan xc'aba'eb. Cuanqueb sa' lix jucub. Yo̱queb chixxitinquil lix yoy. ");
INSERT INTO kekNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Li Jesús quixbokeb ut que'xcanab laj Zebedeo lix yucua'eb sa' li jucub rochbeneb lix mo̱s. Ut que'xta̱ke li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Que'cuulac sa' li tenamit Capernaum. Sa' li hiloba̱l cutan, qui-oc li Jesús sa' li cab li neque'xch'utub cui' ribeb laj judío. Ut qui-oc chixch'olobanquil xya̱lal chiruheb li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Neque'sach xch'o̱leb li tenamit chirabinquil li c'a'ru naxye li Jesús xban nak quixc'ut xya̱lal chiruheb chi cuan xcuanquil ut moco jo' ta que'xba̱nu laj tz'i̱b li neque'c'utuc lix chak'rab li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Sa' li cab ch'utch'u̱queb cui' cuan jun li cui̱nk cuan ma̱us aj musik'ej riq'uin. ");
INSERT INTO kekNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Li cui̱nk a'an quixjap re ut quixye: —¿C'a'ru ta̱cuaj kiq'uin, at Jesús aj Nazaret? ¿Ma chikasachbal xatchal? Ninnau anihat la̱at. La̱at lix Santil Alal li Dios, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Li Jesús quixk'us li ma̱us aj musik'ej ut quixye re: —Matchokin. Elen riq'uin li cui̱nk a'in, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ut li ma̱us aj musik'ej quixch'ikle chi cau li cui̱nk. Quixjap re chi cau ut qui-el riq'uin li cui̱nk. ");
INSERT INTO kekNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Quilaje'sach xch'o̱l chixjunileb li tenamit ut que'xye chiribileb rib: —¿C'a'ru xya̱lal a'in? ¿C'a'ru li ac' tijleb a'in? Li cui̱nk a'in cuan xcuanquil sa' xbe̱neb li ma̱us aj musik'ej ut li c'a'ru naxye, neque'xpa̱b.— ");
INSERT INTO kekNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Sa' junpa̱t que'rabi resil sa' chixjunileb li tenamit xcue̱nt Galilea c'a'ru quixba̱nu li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nak que'el sa' li cab li neque'xch'utub cui' ribeb laj judío, li Jesús rochbeneb laj Jacobo ut laj Juan que'co̱eb sa' rochoch laj Simón ut laj Andrés. ");
INSERT INTO kekNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nak que'cuulac, ticto que'xye re li Jesús nak nim xyajel lix na' li rixakil laj Simón. Yocyo ut yo̱ xtik. ");
INSERT INTO kekNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Tojo'nak li Jesús quijiloc riq'uin li yaj. Quixchap li ruk' ut quixcuaclesi. Sa' junpa̱t quinume' lix tik ut qui-oc chi c'anjelac chiruheb. ");
INSERT INTO kekNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Sa' li ecuu a'an nak ac x-oc li sak'e, que'c'ame' chak riq'uin li Jesús nabaleb li yaj. Ut que'c'ame' ajcui' chak li cuan ma̱us aj musik'ej riq'uineb. ");
INSERT INTO kekNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ut li q'uila tenamit que'chal ut que'xch'utub ribeb chire li cab cuan cui' li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Nabaleb li yaj que'q'uirtesi̱c xban li Jesús. Jalan jala̱nk xyajeleb li junju̱nk. Ut li Jesús quirisiheb nabal chi ma̱us aj musik'ej riq'uineb. Li Jesús inc'a' quixcanabeb chi a̱tinac li ma̱us aj musik'ej xban nak eb a'an que'xnau nak a'an li Cristo. ");
INSERT INTO kekNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Cuulajak chic nak toj ma̱ji' na-iq'ue' li cutan, li Jesús quicuacli ut qui-el sa' li tenamit. Ut co̱ xjunes chi tijoc sa' jun li na'ajej bar ma̱c'a' cui' cristian. ");
INSERT INTO kekNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","A'ut laj Simón jo'queb ajcui' li rochben que'co̱eb chixsic'bal li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nak coxe'xtau que'xye re, —Nabal li tenamit yo̱queb chi sic'oc a̱cue, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Aban li Jesús quichak'oc ut quixye reheb: —Tento nak toxic sa' eb li na'ajej li cuanqueb chi nach' re nak toxinch'olob ajcui' chak resil li colba-ib reheb xban nak a'an aj e nak xinchal, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jo'can nak li Jesús quicuulac sa' eb li na'ajej cuan xcue̱nt Galilea. Yo̱ chixjulticanquil li xya̱lal chiruheb sa' li cab li neque'xch'utub cui' ribeb laj judío, ut quirisi li ma̱us aj musik'ej riq'uineb nabal chi cristian. ");
INSERT INTO kekNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Sa' jun li cutan jun li cui̱nk saklep rix quicuulac riq'uin li Jesús. Quixcuik'ib rib chiru ut quixtz'a̱ma xtenk'anquil. Quixye re: —La̱in ninnau nak la̱at naru tina̱q'uirtesi, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Li Jesús quiril xtok'oba̱l ru li cui̱nk, li saklep rix. Quixye' li ruk' ut quixch'e' li cui̱nk. Quixye: —Nacuaj a̱q'uirtesinquil. Anakcuan tatinq'uirtesi, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ut sa' junpa̱t qui-el li saklep chirix ut quiq'uira. Ma̱c'a' chic xyajel quicana. ");
INSERT INTO kekNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Li Jesús quixchak'rabi chi us ut quixye re: ");
INSERT INTO kekNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Abi li tinye a̱cue. Ma̱ ani aj e ta̱serak'i li xac'ul. Ti̱c tatxic riq'uin laj tij re nak a'an ta̱ril nak xatq'uira. Ut ta̱mayeja junak li xul jo' naxye sa' lix chak'rab laj Moisés. Chaba̱nu a'an chok' retalil chiruheb li tenamit nak xatq'uira, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Co̱ li cui̱nk ut quilajxserak'i reheb chixjunil chanru nak quiq'uira. Riq'uin a'an inc'a' chic naxq'ue rib na-oc li Jesús sa' eb li tenamit xban nak li q'uila tenamit yo̱queb chixsic'bal li Jesús. Quicana ban sa' jun li na'ajej bar ma̱c'a' cui' nabal li cristian ut aran quilaje'cuulac riq'uin li neque'chal chak yalak bar. ");
INSERT INTO kekNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nak ac xnume' cuib oxib cutan chic, li Jesús co̱ cui'chic sa' li tenamit Capernaum. Ut que'rabi resil nak li Jesús cuan sa' li tenamit sa' jun li cab bar nahilan cui'. ");
INSERT INTO kekNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Sa' junpa̱t que'xch'utub rib li cristian sa' li cab cuan cui' li Jesús. Ut xban xq'uial li tenamit, ma̱ ani chic naru na-oc chire li cab xban nak ma̱c'a' chic li na'ajej. Ut li Jesús yo̱ chixch'olobanquil li xya̱lal chiruheb. ");
INSERT INTO kekNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nak yo̱ chi a̱tinac li Jesús, ca̱hibeb li cui̱nk que'xc'am chak chi pakpo jun li cui̱nk sic. Inc'a' nabe̱c. ");
INSERT INTO kekNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Abanan xban li q'uila tenamit, inc'a' naru te'rocsi li yaj cuan cui' li Jesús. Jo'can nak que'take' sa' xbe̱n li cab ut que'xte ca'ch'in xbe̱n li cab ut aran que'xcubsi li yaj yocyo chiru lix cuariba̱l ut coxcana̱c chiru li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Li Jesús quixq'ue retal nak eb li cui̱nk a'an que'xpa̱b nak naru tixq'uirtesi li yaj. Jo'can nak quixye re li yaj: —At cui̱nk, cuybil sachbil chic la̱ ma̱c, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ut chunchu̱queb ajcui' aran laj tz'i̱b li neque'c'utuc xchak'rab li Dios. Yo̱queb chi c'oxlac. ");
INSERT INTO kekNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Ut que'xye sa' xch'o̱leb: —¿C'a'ut nak naa̱tinac chi jo'can li cui̱nk a'in? ¿Ma a'in ta bi' li Dios? Ma̱ ani naru nacuyuc nasachoc ma̱c. Ca'aj cui' li Dios naru nacuyuc nasachoc ma̱c, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ticto quixnau li Jesús c'a'ru yo̱queb chixc'oxlanquil. Quixye reheb: —¿C'a'ut nak nequec'oxla chi jo'can? ");
INSERT INTO kekNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Bar cuan li us tinye re li yaj re nak ta̱c'utu̱nk che̱ru nak cuan incuanquil? ¿Ma tinye re, “Cuybil sachbil la̱ ma̱c”, malaj ut tinye re, “Cuaclin, ayu, ut c'am la̱ cuariba̱l”? ");
INSERT INTO kekNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","La̱in tinc'ut che̱ru nak la̱in li Cristo li C'ajolbej, ut cuan incuanquil sa' ruchich'och' chixcuybal xsachbal li ma̱c, chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Tojo'nak li Jesús quixye re li cui̱nk: —At cui̱nk, la̱in tinye a̱cue, cuaclin, c'am la̱ cuariba̱l ut ayu sa' la̱ cuochoch, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ut li cui̱nk sic nak quicuan ac ta̱cuacli̱k. Quixchap lix cuariba̱l ut ac ta̱e̱lk chiruheb chixjunil li tenamit. Ut riq'uin a'in chixjunileb que'sach xch'o̱l. Que'xq'ue xlok'al li Dios ut que'xye: —Ma̱ jun cua kilom a'in, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ut nak ac xq'uirtesi li cui̱nk sic, li Jesús co̱ chire li palau Galilea. Nabaleb li tenamit que'cuulac riq'uin ut li Jesús qui-oc chixtzolbaleb. ");
INSERT INTO kekNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nak yo̱ chi numec' aran, li Jesús quiril laj Leví li ralal laj Alfeo. Laj Leví c'ojc'o sa' xna'aj ut yo̱ chi titz'oc toj. Li Jesús quixye re: —China̱ta̱ke.— Tojo'nak laj Leví quicuacli ut quixta̱ke li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ut chirix a'an li Jesús co̱ sa' li rochoch laj Leví chi cua'ac. Nabaleb laj titz'ol toj ut nabaleb ajcui' laj ma̱c cuanqueb sa' li me̱x bar cuan cui' li Jesús rochbeneb lix tzolom. Nabaleb xban nak nabal que'ta̱ken re li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ut eb laj tz'i̱b ut eb laj fariseo que'ril nak cuan li Jesús sa' me̱x rochbeneb laj titz'ol toj jo'queb ajcui' laj ma̱c. Ut que'xye reheb lix tzolom li Jesús: —¿C'a'ut nak laj tzolol e̱re nacua'ac sa' xya̱nkeb laj titz'ol toj ut sa' xya̱nkeb laj ma̱c? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Li Jesús quirabi li que'xpatz' ut quixye reheb: —Li cauheb ma̱c'a' na-oc cui' aj banonel reheb. Aban li yajeb, a'aneb li neque'raj banec'. Jo'can nak la̱in inc'a' xinchal chixsic'baleb li ti̱queb xch'o̱l. Xinchal ban chixsic'baleb laj ma̱c, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Sa' eb li cutan a'an eb lix tzolom laj Juan laj Cubsihom Ha' ut eb laj fariseo neque'xba̱nu x-ayu̱n. Li tenamit que'cuulac riq'uin li Jesús ut que'xye re: —Eb lix tzolom laj Juan neque'xba̱nu x-ayu̱n jo'queb ajcui' laj fariseo. ¿C'a'ut nak inc'a' neque'xba̱nu x-ayu̱n eb la̱ tzolom? chanqueb re. ");
INSERT INTO kekNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Tojo'nak quichak'oc li Jesús ut quixye reheb, —La̱in jo' jun be̱lomej nak cuanquin. ¿Ma naru te'ayunik li neque'xic riq'uin sumla̱c nak cuan li be̱lomej riq'uineb? Nak toj cuan li be̱lomej riq'uineb, inc'a' naru neque'xba̱nu x-ayu̱n. ");
INSERT INTO kekNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ut jo'can ajcui' lin tzolom. Ta̱cuulak xk'ehil nak tin-isi̱k sa' xya̱nkeb. Toj sa' li cutan a'an te'xba̱nu x-ayu̱n, chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ma̱ ani naxxi̱ti junak k'el t'icr riq'uin ac' t'icr. Cui ut naxxi̱ti riq'uin ac' t'icr, nak tixpuch' ta̱c'osk li ac' t'icr ut tixnimobresi xpejelal li k'el t'icr. ");
INSERT INTO kekNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ut ma̱ ani naq'uehoc ac' vino sa' li k'el bo̱ls tz'u̱m. Cui tixq'ue li ac' vino sa' li k'el bo̱ls tz'u̱m, ta̱puq'uek' li k'el tz'u̱m, ta̱hoyek' li vino, ut ta̱osok' ajcui' li bo̱ls tz'u̱m. Li ac' vino sa' li ac' bo̱ls tz'u̱m naq'ueman, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sa' jun li hiloba̱l cutan li Jesús rochbeneb lix tzolom yo̱queb chi numec' bar cui' aubil li acui̱mk trigo xc'aba'. Eb lix tzolom que'xch'ot ru li trigo nak yo̱queb chi numec' xban nak te'tz'oca̱k. ");
INSERT INTO kekNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tojo'nak eb laj fariseo que'xye re li Jesús: —Il c'a'ru yo̱queb la̱ tzolom. ¿C'a'ut nak neque'xba̱nu li c'anjel moco uxc ta naraj sa' li hiloba̱l cutan? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Li Jesús quichak'oc ut quixye reheb: —¿Ma inc'a' ta bi' xeril sa' li Santil Hu c'a'ru quixba̱nu laj David nak a'an ut li rochben te'tz'oca̱k? ");
INSERT INTO kekNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nak quicuan laj Abiatar chok' xyucua'ileb aj tij, laj David qui-oc sa' li rochoch li Dios. Cuan aran li mayejanbil caxlan cua. Juneseb laj tij naru neque'xcua' li caxlan cua a'an. Abanan laj David quixcua' li caxlan cua li quiq'uehe' re xban laj tij ut quixq'ue ajcui' reheb li rochben xban nak te'tz'oca̱k, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ut quixye ajcui' reheb: —A' li cui̱nk ut li ixk a'aneb li k'axal lok' chiru li hiloba̱l cutan. Toj ma̱c'a' li hiloba̱l cutan nak ac que'yo'obtesi̱c chak ut li hiloba̱l cutan quiq'uehe' re xtenk'anquileb li cui̱nk ut li ixk. ");
INSERT INTO kekNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Jo'can nak la̱in li C'ajolbej cuan incuanquil chixyebal c'a'ru ta̱uxma̱nk sa' li hiloba̱l cutan, chan li Jesús reheb. ");
INSERT INTO kekNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ut li Jesús co̱ cui'chic sa' li cab li neque'xch'utub cui' ribeb laj judío. Ut aran cuan jun li cui̱nk sic jun li ruk'. ");
INSERT INTO kekNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Eb laj fariseo yo̱queb chixsic'bal chanru nak te'xjit li Jesús. Jo'can nak yo̱queb chirilbal ma tixq'uirtesi tana li cui̱nk a'in sa' li hiloba̱l cutan. ");
INSERT INTO kekNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Li Jesús quixye re li cui̱nk li sic ruk': —Numen chak arin chi ubej, chan re. ");
INSERT INTO kekNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tojo'nak li Jesús quixpatz' reheb laj fariseo: —¿C'a'ru us xba̱nunquil sa' li hiloba̱l cutan? ¿Ma naru xba̱nunquil li us malaj ut li inc'a' us? ¿Ma us xcolbal xyu'am junak malaj ut xsachbal? chan cui'chic reheb. Ut eb a'an mem que'cana. Inc'a' chic que'xtau c'a'ru que'xye. ");
INSERT INTO kekNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Quijosk'o' li Jesús sa' xbe̱neb, abanan quiril cui'chic xtok'oba̱l ruheb xban nak inc'a' que'raj xtaubal xya̱lal. Ut li Jesús quixye re li cui̱nk li sic ruk': —Ye' la̱ cuuk', chan. Ut li cui̱nk quixye' li ruk' ut sa' junpa̱t quiq'uira. ");
INSERT INTO kekNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tojo'nak eb laj fariseo que'el riq'uin li Jesús. Que'co̱eb riq'uineb li neque'oquen chirix laj Herodes. Ut que'oc xc'u̱banquil chanru nak te'xcamsi li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ut chirix a'an li Jesús co̱ chire li palau Galilea rochbeneb lix tzolom. Ut li q'uila tenamit que'xta̱ke li Jesús. Que'chal chak Galilea jo' ajcui' Judea. ");
INSERT INTO kekNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Nak que'rabi resil li xni̱nkal usilal yo̱ chixba̱nunquil li Jesús, quilaje'chal chirilbal. Cuan li que'chal chak Jerusalén ut Idumea. Ut cuan ajcui' que'chal chak jun pac'al li nima' Jordán. Ut que'chal ajcui' chak Tiro ut Sidón chirilbal li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jo'can nak li Jesús quixye reheb lix tzolom nak te'xcauresi junak li jucub. Ac cua̱nk aran re ta̱cua̱nk chi sa' re nak inc'a' ta̱nat'ek' xbaneb li q'uila tenamit. ");
INSERT INTO kekNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Xban nak nabal ac xq'uirtesi, jo'can nak li q'uila tenamit yo̱queb chixtiquisinquil ribeb. Te'raj te'xch'e' li Jesús re nak te'q'uira̱k. ");
INSERT INTO kekNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Li cuan ma̱us aj musik'ej riq'uineb, nak que'ril li Jesús, que'xcuik'ib rib chiru ut que'xjap re chixyebal: —La̱at li Ralal li Dios, chanqueb re. ");
INSERT INTO kekNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ut li Jesús quixk'useb li ma̱us aj musik'ej ut quixye reheb nak inc'a' te'xye resil nak a'an Ralal li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tojo'nak li Jesús quitake' chiru tzu̱l. Quixbokeb li ani quiraj ut eb a'an co̱eb chirix. ");
INSERT INTO kekNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ut li Jesús quixsiq'ueb ru li cablaju chi cui̱nk re nak te'cua̱nk riq'uin ut re nak tixtaklaheb chixjulticanquil li ra̱tin li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ut quixq'ueheb xcuanquil chixq'uirtesinquileb li yaj ut chirisinquil li ma̱us aj musik'ej. ");
INSERT INTO kekNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","A'aneb a'in li cablaju li quixxakabeb li Jesús: laj Simón li quixq'ue aj Pedro chok' xc'aba', ");
INSERT INTO kekNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ut laj Jacobo ut laj Juan. Lix yucua'eb a'an, a'an laj Zebedeo. Aj Boanerges quiq'uehe' chok' xc'aba'eb xban li Jesús. Li c'aba'ej a'an naraj naxye “Ralaleb li Ca̱k”. ");
INSERT INTO kekNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Quixxakabeb ajcui' laj Andrés, laj Felipe, laj Bartolomé, laj Mateo, laj Tomás, laj Jacobo li ralal laj Alfeo, laj Tadeo ut laj Simón. A'an xcomoneb laj Canaán. ");
INSERT INTO kekNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ut quixsic' ajcui' ru laj Judas Iscariote li quik'axtesin re li Jesús sa' ruk'eb li xic' neque'iloc re. ");
INSERT INTO kekNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ut nak ac xsiq'ueb ru lix tzolom li Jesús co̱ sa' jun li cab rochbeneb lix tzolom. Ut que'tubla cui'chic li q'uila tenamit; riq'uin a'an moco naxq'ue ta chic rib nacua'ac li Jesús chi moco eb lix tzolom. ");
INSERT INTO kekNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ut nak que'rabi resil li c'a'ru yo̱ chixba̱nunquil li Jesús, eb li rech'alal que'chal chixc'ambal. Que'xye nak moco tuktu ta chic xna'leb li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ut eb laj tz'i̱b li que'chal chak Jerusalén yo̱queb chixyebal: —Laj Tza cuan riq'uin li Jesús ut sa' xc'aba' laj Tza narisiheb li ma̱us aj musik'ej, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ut li Jesús quixbokeb ut quixpatz' reheb: —¿Chanru nak laj Tza ta̱risi li rech aj tzahil?— Ut quixye ajcui' li jaljo̱quil ru a̱tin a'in: ");
INSERT INTO kekNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","—Cui cuan jun te̱pak chi tenamit xic' te'ril rib chi ribileb rib, li jun te̱p chi tenamit a'an tixsach xcuanquil xjunes rib. ");
INSERT INTO kekNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ut cui cuan ta jun cabalak xic' te'ril rib chi ribileb rib sa' rochocheb, li jun cabal a'an te'xsach xcuanquil lix jun cablal. ");
INSERT INTO kekNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Jo'can ajcui' laj Tza cui te'xpleti rib chi ribileb rib, a'an tixsach xcuanquil xjunes rib. ");
INSERT INTO kekNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ma̱ ani naru ta̱oc sa' rochoch junak cui̱nk cau rib chixmak'bal li c'a'ru cuan re, cui inc'a' ta xbe̱n cua tixbac' li cui̱nk cau rib, tojo'nak ta̱oc chixc'ambal li c'a'ru cuan re. ");
INSERT INTO kekNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Relic chi ya̱l ninye e̱re nak ta̱cuyma̱nk ta̱sachma̱nk lix ma̱queb li cristian ut ta̱cuyma̱nk ajcui' li majecua̱nc neque'xba̱nu. ");
INSERT INTO kekNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Abanan li ta̱majecua̱nk re li Santil Musik'ej, inc'a' ta̱cuyek' ta̱sachek' xma̱c. Cua̱nk ban sa' xbe̱n chi junelic lix tojbal rix li ma̱c a'an.— ");
INSERT INTO kekNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Li Jesús quixye a'in xban nak yo̱queb chixyebal nak cuan ma̱us aj musik'ej riq'uin. ");
INSERT INTO kekNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Quicuulac aran lix na' li Jesús ut que'cuulac ajcui' li ri̱tz'in. Que'cana chirix cab ut que'xtakla xbokbal li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ut nabaleb li tenamit c'ojc'o̱queb chixc'atk li Jesús. Que'xye re: —Ka̱cua', xc'ulun la̱ na' rochbeneb la̱ cui̱tz'in. Cuanqueb chirix cab. Yo̱queb cha̱sic'bal, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Li Jesús quichak'oc ut quixye reheb: —¿Ani ta bi' lin na'? Ut, ¿ani ta bi' li cui̱tz'in nak nequec'oxla la̱ex?— ");
INSERT INTO kekNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Quirileb li c'ojc'o̱queb chixc'atk ut quixye: —A'ineb lin na' ut a'ineb li cui̱tz'in. ");
INSERT INTO kekNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Xban nak li ani naba̱nun re li naraj li Dios, a'an li cui̱tz'in, a'an li cuanab, ut a'an lin na', chan. ");
INSERT INTO kekNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ut qui-oc cui'chic li Jesús chixtzolbaleb li tenamit chire li palau Galilea. K'axal nabal que'xch'utub rib riq'uin chirabinquil. Xban xq'uialeb li tenamit, li Jesús qui-oc sa' jun li jucub cuan sa' li palau ut quic'ojla chi sa'. Ut chixjunileb li tenamit que'cana chire li palau. ");
INSERT INTO kekNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ut nabal c'a'ak re ru quixtzoleb cui' riq'uin jaljo̱quil ru a̱tin. Nak yo̱ chixch'olobanquil li xya̱lal chiruheb, quixye li serak' a'in reheb: ");
INSERT INTO kekNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Abihomak li tinye. Jun aj acuinel co̱ chi a̱uc. ");
INSERT INTO kekNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ut nak yo̱ chixhirbal li iyaj, cuan quinak chire be. Que'chal li xul li neque'xic'an ut que'xcua' li iyaj. ");
INSERT INTO kekNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ut cuan ajcui' li iyaj quinak sa' li pec ru bar ma̱c'a' cui' mas li ch'och'. Sa' junpa̱t quimok, abanan inc'a' quixchap xxe' xban nak jay li ch'och' sa' xbe̱n li pec. ");
INSERT INTO kekNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nak quichal li sak'e quichakic li acui̱mk xban nak inc'a' cham cuan li xe'. ");
INSERT INTO kekNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ut cuan cui'chic li iyaj coxnak sa' xya̱nk li q'uix. Ut nak quichamo' li q'uix sa' xbe̱n, quixnat' li acui̱mk ut inc'a' quiu̱chin. ");
INSERT INTO kekNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ut cuan cui'chic li iyaj coxnak sa' li cha̱bil ch'och'. Quimok ut quiq'ui ut quiu̱chin chi us. Cuan quixq'ue laje̱tk xca'c'a̱l (30) ru. Cuan li quixq'ue oxtakc'a̱l (60) ru ut cuan cui'chic quixq'ue o'takc'a̱l (100) ru li junju̱nk. ");
INSERT INTO kekNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tojo'nak quixye li Jesús reheb: —Li ani na-abin, chixq'uehak retal li c'a'ru ninye, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ut nak que'el lix q'uial li tenamit, li Jesús quicana rochbeneb lix tzolom cablaju. Eb a'an que'xpatz' re ut que'xye: —¿C'a'ru xya̱lal li jaljo̱quil ru a̱tin a'in? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ut li Jesús quixye reheb: —La̱ex q'uebil e̱re xnaubal xya̱lal li mukmu̱quil na'leb chirix lix nimajcual xcuanquilal li Dios. A'ut li jun ch'o̱l chic li inc'a' neque'pa̱ban, riq'uin jaljo̱quil ru a̱tin ta̱yema̱nk reheb. ");
INSERT INTO kekNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Usta yo̱queb chi iloc, abanan inc'a' te'xq'ue retal. Usta yo̱queb chi abi̱nc, abanan inc'a' te'xtau xya̱lal. Ta̱uxma̱nk chi jo'can re nak inc'a' te'xyot' xch'o̱leb ut inc'a' te'xjal xc'a'uxeb ut inc'a' ta̱cuyek' xma̱queb.— ");
INSERT INTO kekNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tojo'nak li Jesús quixpatz' reheb: —¿Ma inc'a' nequetau ru li jaljo̱quil ru a̱tin a'in? Cui inc'a' nequetau xya̱lal a'in, ¿chanru nak te̱tau xya̱lal chixjunil li jaljo̱quil ru a̱tin chi jo'canan? ");
INSERT INTO kekNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","A'an a'in lix ya̱lal. Laj acuinel a'an jo' jun laj yehol ra̱tin li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ut li iyaj li quinak chire be, a'an chanchaneb li neque'abin re li ra̱tin li Dios. Nak ac xe'rabi, sa' junpa̱t nachal laj Tza chirisinquil li a̱tin ut sa' junpa̱t nasach sa' xch'o̱leb. ");
INSERT INTO kekNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ut li iyaj li quinak sa' li pec ru, a'an chanchaneb li neque'abin re li ra̱tin li Dios ut sa' junpa̱t neque'xpa̱b chi saheb sa' xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Abanan inc'a' nacana sa' xch'o̱leb. Nak nachal junak raylal, malaj ch'a'ajquilal sa' xbe̱neb xbaneb lix pa̱ba̱l, inc'a' neque'xcuy xnumsinquil. Sa' junpa̱t neque'ch'inan xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ut li iyaj li quinak sa' xya̱nk li q'uix chanchaneb li neque'abin re li ra̱tin li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Abanan ca'aj cui' li c'a'ak re ru cuan sa' ruchich'och' neque'xc'oxla, jo' li biomal ut xra̱bal ru li c'a'ak chic re ru. Ut a'an li naramoc lix ya̱lal chiruheb. Ma̱c'a' na-oc cui' li ra̱tin li Dios reheb. ");
INSERT INTO kekNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ut li iyaj li quit'ane' sa' cha̱bil ch'och', a'an chanchaneb li neque'rabi ut neque'xpa̱b chi tz'akal li ra̱tin li Dios. Neque'q'ui chi us sa' lix pa̱ba̱leb, jo' li acui̱mk li naru̱chin laje̱tk xca'takc'a̱l (30) ut li naxq'ue oxtakc'a̱l (60) ut li naxq'ue o'takc'a̱l (100) ru li junju̱nk.— ");
INSERT INTO kekNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ut li Jesús quixye ajcui' reheb: —¿Ma naq'ueman ta bi' junak candil rubel junak chacach malaj ut rubel ch'a̱t? Inc'a' naru. Takec' ban naq'ueman sa' xna'aj re nak tixcutanobresi sa' li cab. ");
INSERT INTO kekNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Jo'can ajcui' li tijleb li ninch'olob xya̱lal che̱ru. Ma̱c'a' ta̱cana̱k chi mukmu chi inc'a' ta ta̱c'utbesi̱k mokon. Ut li inc'a' natauman ru anakcuan, ta̱tauma̱nk ru mokon. ");
INSERT INTO kekNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Li ani naraj rabinquil, chixq'uehak retal li ninye. ");
INSERT INTO kekNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Quixye ajcui' reheb: —Cheq'uehak retal li nequerabi ut te̱q'ue e̱ch'o̱l chixba̱nunquil li nequerabi xban nak li ani naxba̱nu li c'a'ru quixtzol cuiq'uin, mas cui'chic lix na'leb ta̱q'uehek' re xban li Dios re nak tixtau ru li cua̱tin. ");
INSERT INTO kekNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Li ani tixq'ue xch'o̱l chixtzolbal li us, k'axal cui'chic li usilal tixc'ul. Li ani inc'a' tixq'ue xch'o̱l chixtzolbal li us, ta̱sachk sa' xch'o̱l li jo' q'uial naxnau. ");
INSERT INTO kekNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ut li Jesús quixye cui'chic reheb: —Lix nimajcual cuanquilal li Dios, chanchan junak aj acuinel. Narau li iyaj sa' ch'och'. ");
INSERT INTO kekNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Li cui̱nk nacuar, nacuacli ut eb li cutan neque'nume'. Ut li iyaj yal xjunes namok chak ut naq'ui ut li cui̱nk inc'a' naxnau chanru nak namok ut naq'ui li acui̱mk. ");
INSERT INTO kekNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Li ch'och' naq'uiresin re li acui̱mk. Naq'ui ut nani̱nkan ut chirix a'an na-oc chi atz'umac ut naxq'ue li ru. ");
INSERT INTO kekNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ut nak nache̱co' li ru nasic'man sa' junpa̱t xban nak ac xcuulac xk'ehil xxocbal li ru. ");
INSERT INTO kekNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","—¿C'a'ru tinjuntak'e̱ta cui' lix nimajcual cuanquil li Dios? chan li Jesús. —Ut ¿c'a'ru chi jaljo̱quil ru a̱tin tinye, re xch'olobanquil xya̱lal lix nimajcual cuanquilal li Dios? ");
INSERT INTO kekNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Lix nimajcual cuanquilal li Dios, a'an chanchan riyajil li ni̱nki mostaza. Li riyajil li mostaza coc' chiru chixjunil li iyaj cuan sa' ruchich'och'. ");
INSERT INTO kekNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nak ac x-auman namok ut naq'ui. Ut ni̱nk chi us nacuulac lix che'el. Naxk'ax xteram chixjunil li acui̱mk. Neque'ni̱nkan li ruk' ut eb laj xic'anel xul neque'xyi̱b lix soc sa' eb li ruk'.— ");
INSERT INTO kekNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ut li Jesús quixch'olob xya̱lal chiruheb li tenamit riq'uin nabal chic chi jaljo̱quil ru a̱tin a' ya̱l bar na cuan te'xtau ru. ");
INSERT INTO kekNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ut ma̱c'a' c'a'ru quixye li Jesús reheb li tenamit chi ma̱cua' ta sa' jaljo̱quil ru a̱tin. Abanan nak ac xjuneseb chic lix tzolom, quixch'olob li xya̱lal chiruheb. ");
INSERT INTO kekNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nak qui-ecuu sa' li cutan a'an li Jesús quixye reheb lix tzolom: —K'axonko jun pac'al li palau, chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ut li Jesús quixchak'rabiheb li q'uila tenamit ut quic'ame' sa' li jucub cuan cui'. Ut cuanqueb ajcui' coc' jucub que'co̱eb chirix. ");
INSERT INTO kekNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ut nak ac cuanqueb sa' xyi li palau quichal jun li nimla ik'. Naxcut lix cau ok li ha' sa' li jucub ut qui-oc chi nujac li ha' chi sa' li jucub. ");
INSERT INTO kekNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Li Jesús cuan chi ixbej sa' li jucub ut yo̱ chi cua̱rc sa' xbe̱n jun lix soc xjolom. Eb lix tzolom que'rajsi ut que'xye re: —At tzolonel, ajsi a̱cuu. ¿Ma inc'a' nacacuil nak osoc' ke? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Quicuacli li Jesús ut quixk'us li ik' ut quixye re li palau: —Matchokin. Canab ec'a̱nc, chan. Ut sa' junpa̱t quich'ana li ik' ut quitukla ru li ha'. ");
INSERT INTO kekNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ut li Jesús quixye reheb lix tzolom: —¿C'a'ut nak c'ajo' nak nequexxucuac? ¿Ma inc'a' nequepa̱b nak li Dios ta̱tenk'a̱nk e̱re? chan. ");
INSERT INTO kekNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ut c'ajo' nak que'sach xch'o̱l lix tzolom ut que'xye chi rilbileb rib: —¿Chanru nak cuan xcuanquil li cui̱nk a'in nak naxk'us li ik' ut li palau, ut neque'abin chiru? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Li Jesús ut eb lix tzolom que'cuulac aran jun pac'al li palau sa' xch'och'eb laj Gadara. ");
INSERT INTO kekNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ut nak qui-el li Jesús sa' li jucub, sa' junpa̱t quichal jun li cui̱nk chi c'uluc re. Quichal chak sa' li na'ajej bar neque'muke' cui' li camenak. Li cui̱nk a'an cuan ma̱us aj musik'ej riq'uin. ");
INSERT INTO kekNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Junes sa' li na'ajej bar neque'muke' cui' li camenak nacuan. Ma̱ ani naru nabac'oc re chi moco riq'uin cadena naru neque'xbac'. ");
INSERT INTO kekNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nabal sut neque'xyal xbac'bal li rok ruk' riq'uin cadena. Abanan sa' junpa̱t naxt'upi li cadena. Ut ma̱ ani naru natu̱lanobresin re li cui̱nk a'an. ");
INSERT INTO kekNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Chi k'ek chi cutan naxbeni rib sa' xbe̱neb li tzu̱l ut sa' xya̱nkeb li mukleba̱l camenak. Junelic yo̱ chixjapbal re ut naxyoq'ui rib riq'uin k'esnal pec. ");
INSERT INTO kekNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Toj najt ajcui' cuan chak li Jesús nak qui-ile' xban li cui̱nk. Li cui̱nk co̱ sa' a̱nil ut coxcuik'ib rib chiru li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Quixjap re chixyebal: —¿C'a'ru ta̱cuaj cuiq'uin, at Jesús? La̱at Ralalat li nimajcual Dios. Sa' xc'aba' li Ka̱cua' Dios, nintz'a̱ma cha̱cuu nak mina̱rahobtesi, chan re. ");
INSERT INTO kekNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Quixye chi jo'can xban nak ac yo̱ li Jesús chixyebal re li ma̱us aj musik'ej: —Elen riq'uin li cui̱nk a'in, at ma̱us aj musik'ej.— ");
INSERT INTO kekNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tojo'nak li Jesús quixpatz' re: —¿Ani a̱c'aba'?— —Cuakib mil (6,000) inc'aba' xban nak nabalo, chan nak quichak'oc. ");
INSERT INTO kekNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ut nabal sut quixtz'a̱ma chiru li Jesús nak inc'a' ta̱risiheb li ma̱us aj musik'ej chi junaj cua sa' li na'ajej a'an. ");
INSERT INTO kekNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Aran cuanqueb jun tu̱b li a̱k yo̱queb chi ichajibc chiru li tzu̱l. ");
INSERT INTO kekNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Eb li ma̱us aj musik'ej que'xtz'a̱ma chiru li Jesús nak tixtaklaheb riq'uineb li a̱k. —Choa̱takla riq'uineb li a̱k. Choa̱canab chi oc riq'uineb, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ut li Jesús quixcanabeb chi xic. Que'el li ma̱us aj musik'ej riq'uin li cui̱nk. Coxe'ocak riq'uineb li a̱k. Ut li a̱k que'oc chi a̱linac ut que'xrum chak rib sa' xbe̱n u̱l ut toj sa' li palau coxe'nak. Cuanqueb na cuib mil chi a̱k que'oso' sa' li palau. ");
INSERT INTO kekNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Eb laj ilol a̱k que'xucuac ut que'e̱lelic ut coxe'xye resil sa' li tenamit jo' ajcui' sa' li c'aleba̱l. Ut nabaleb li tenamit que'co̱eb chirilbal li c'a'ru quic'ulman. ");
INSERT INTO kekNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Que'cuulac cuan cui' li Jesús ut que'ril li cui̱nk li qui-isi̱c nabal chi ma̱us aj musik'ej riq'uin. C'ojc'o aran nak coxe'xtau. Tikto chic ut tuktu chic xjolom. Riq'uin rilbal a'an que'oc xxiuheb li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ut eb li que'iloc re, que'xserak'i reheb li tenamit chanru qui-ux re li cui̱nk li quicuan ma̱us aj musik'ej riq'uin, jo' ajcui' li c'a'ru que'xc'ul li a̱k. ");
INSERT INTO kekNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ut que'xtz'a̱ma chiru li Jesús nak ta̱e̱lk sa' lix tenamiteb. ");
INSERT INTO kekNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ut nak qui-oc cui'chic li Jesús sa' li jucub, li cui̱nk li qui-isi̱c ma̱us aj musik'ej riq'uin quixtz'a̱ma chiru li Jesús nak ta̱xic chirix. ");
INSERT INTO kekNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","A'ut li Jesús inc'a' quiraj nak ta̱xic chirix. Quixye re li cui̱nk: —Ayu sa' la̱ cuochoch ut ta̱serak'i reheb la̱ cuech'alal li usilal xinba̱nu a̱cue. Ta̱ye reheb chanru nak xcuuxta̱na a̱cuu, chan re li cui̱nk. ");
INSERT INTO kekNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Jo'can nak co̱ li cui̱nk sa' eb li tenamit xcue̱nt Decápolis. Qui-oc chixyebal reheb chixjunil li ni̱nki usilal quixba̱nu li Jesús re. Ut chixjunileb li tenamit quilaje'sach xch'o̱l chirabinquil li c'a'ru quixye. ");
INSERT INTO kekNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Qui-oc cui'chic li Jesús sa' li jucub ut quisuk'i cui'chic jun pac'al li palau rochbeneb lix tzolom. Ma̱ ca'ch'in li tenamit coxe'xch'utub rib riq'uin chire li palau. ");
INSERT INTO kekNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ut quichal jun li cui̱nk aj Jairo xc'aba'. A'an xcomoneb li neque'taklan sa' li cab li neque'xch'utub cui' ribeb laj judío. Nak quiril li Jesús, quixcuik'ib rib chiru. ");
INSERT INTO kekNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ut chi anchal xch'o̱l quixtz'a̱ma chiru li Jesús ut quixye re: —At Ka̱cua', k'axal nim xyajel lin ch'ina rabin. Ca̱mc re. Ba̱nu usilal, tatxic sa' cuochoch. Toxa̱q'ue la̱ cuuk' sa' xbe̱n re nak ta̱q'uira̱k ut inc'a' ta̱ca̱mk, chan re li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ut li Jesús co̱ chirix laj Jairo ut nabaleb li tenamit que'ta̱ken re. Xban xq'uial li tenamit yo̱queb chixtiquisinquil ribeb. ");
INSERT INTO kekNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Sa' xya̱nkeb cuan jun li ixk cablaju chihab xticlajic xyajel. Junelic yo̱ lix yajel li ixk a'an ut inc'a' chic natz'ap lix quiq'uel. ");
INSERT INTO kekNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Quixq'ue rib chi banec' riq'uin nabaleb aj banonel ut nabal li raylal quixc'ul. Abanan ma̱ jok'e que'xban. Ca'aj cui' quixsach chixjunil li c'a'ru cuan re, re xtojbaleb. Ut ma̱c'a' qui-oc cui'. Nima̱nc ban chic naxba̱nu lix yajel. ");
INSERT INTO kekNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Quirabi resil nak li Jesús yo̱ chixq'uirtesinquileb li yaj. Riq'uin a'an qui-oc chixta̱kenquil li Jesús rochbeneb li q'uila tenamit. Ut quijiloc chixc'atk re nak tixch'e' li rak'. ");
INSERT INTO kekNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","—Usta ca'aj cui' li rak' tinch'e', riq'uin a'an tinq'uira̱k, chan li ixk sa' xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ut nak quixch'e' li rak' sa' junpa̱t quiq'uira, ut quitz'ap lix quiq'uel. Ut li ixk quirec'a nak ma̱c'a' chic xyajel. ");
INSERT INTO kekNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ut li Jesús quixnau nak cuan li quiq'uira xban lix cuanquil. Quixsuk'isi rib sa' xya̱nkeb li q'uila tenamit ut quixpatz' reheb: —¿Ani xch'e'oc re li cuak'? chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Eb lix tzolom que'chak'oc ut que'xye re: —At Ka̱cua', la̱at nacacuil chanru nak yo̱queb chixtiquisinquil ribeb li q'uila tenamit cha̱cuix. ¿C'a'ut nak nacapatz' ani xch'e'oc re la̱ cuak'? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ut li Jesús quixsuk'isi rib chirilbal ani xch'e'oc re li rak'. ");
INSERT INTO kekNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Li ixk naxnau nak ac xq'uira. Nasicsot xban xxiu. Colxcuik'ib rib chiru li Jesús ut quixye li xya̱lal re. ");
INSERT INTO kekNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Li Jesús quixye re: —Kana', xban nak xapa̱b nak cuan incuanquil cha̱q'uirtesinquil, jo'can nak xatq'uira. Ayu chi sa sa' a̱ch'o̱l ut chi ma̱c'a' chic a̱raylal, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nak toj yo̱ chi a̱tinac li Jesús, que'chal lix comoneb laj Jairo sa' rochoch chixyebal re, —Xcam la̱ rabin. ¿C'a' chic ru aj e nak ta̱ch'i'ch'i'i laj tzolonel? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nak quirabi li Jesús li c'a'ru yo̱queb chixyebal re laj Jairo, quixye re: —Matc'oxlac. Ca'aj cui' ta̱pa̱b nak ta̱q'uira̱k la̱ rabin, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ut inc'a' quiraj nak li tenamit te'xic chirix. Ca'aj cui' laj Pedro ut laj Jacobo ut laj Juan, li ri̱tz'in laj Jacobo, quixc'ameb chirix. ");
INSERT INTO kekNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nak que'cuulac sa' rochoch laj Jairo, li Jesús quiril nak yo̱queb chixpokokinquil ribeb ut japjo̱queb re chi ya̱bac. ");
INSERT INTO kekNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Qui-oc sa' cab riq'uineb ut quixye reheb: —¿C'a'ut nak yo̱quex chixpokokinquil e̱rib? ¿C'a'ut nak yo̱quex chi ya̱bac? Li xka'al moco xcam ta. Cua̱rc yo̱, chan li Jesús reheb. ");
INSERT INTO kekNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Eb a'an que'oc chixse'enquil li c'a'ru quixye, ut li Jesús quirisiheb chirix cab. Ca'aj cui' lix na' ut lix yucua' ut eb li oxib chi xtzolom que'oc rochben li Jesús bar cuan cui' li camenak. ");
INSERT INTO kekNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Quixchap chi ruk' li camenak ut quixye re sa' li ra̱tinoba̱l: —Talita, cumi, chan. Li a̱tin a'an naraj naxye, “At ch'ina xka'al, la̱in tinyehok a̱cue cuaclin”. ");
INSERT INTO kekNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Sa' junpa̱t quicuacli li xka'al ut quibe̱c. Li xka'al a'an cablaju chihab cuan re. Ut eb li cuanqueb aran quilaje'sach xch'o̱l chirilbal li c'a'ru quixba̱nu li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","A'ut li Jesús quixchak'rabiheb chi us nak ma̱ ani aj e te'xye li c'a'ru quic'ulman. Ut quixye reheb nak te'xq'ue chi cua'ac li xka'al. ");
INSERT INTO kekNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Li Jesús qui-el sa' li na'ajej a'an ut co̱ sa' lix tenamit rochbeneb lix tzolom. ");
INSERT INTO kekNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sa' li hiloba̱l cutan co̱ sa' li cab li neque'xch'utub cui' ribeb laj judío. Qui-oc chixtzolbaleb li tenamit. Nabal que'abin re ut quilaje'sach xch'o̱l chirabinquil ut que'xye chi ribileb rib: —¿Bar xtzol lix na'leb? ¿C'a'ru chi na'lebil li naxnau? ¿Chanru nak naxba̱nu li milagro? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","—¿Ma ma̱cua' ta bi' a'in laj pech'? Ut ¿ma̱cua' ta bi' lix María lix na'? ¿Ma ma̱cua' ta bi' laj Jacobo li ri̱tz'in ut laj José, laj Judas ut laj Simón? ¿Ma ma̱cua' ta bi' a'in eb li ri̱tz'in li cuanqueb sa' kaya̱nk? chanqueb. Ut que'chal xjosk'il sa' xbe̱n. ");
INSERT INTO kekNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ut li Jesús quixye: —Junak profeta naq'uehe' xlok'al yalak bar, abanan sa' lix tenamit ut sa' xya̱nkeb li rech'alal ut sa' rochoch inc'a' naq'uehe' xlok'al.— ");
INSERT INTO kekNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ut inc'a' quiru quixba̱nu li milagro sa' lix tenamit xban nak inc'a' que'xpa̱b nak cuan xcuanquil. Cuib oxib ajcui' li yaj quixq'ue li ruk' sa' xbe̱neb re nak te'q'uira̱k. ");
INSERT INTO kekNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ut li Jesús quisach xch'o̱l chirilbaleb nak inc'a' neque'xpa̱b nak cuan xcuanquil. Ut nak qui-el aran, co̱ sa' chixjunil li c'aleba̱l chixtzolbaleb li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tojo'nak quixbokeb lix tzolom cablaju ut quixtaklaheb chi ca'cabil ut quixq'ueheb xcuanquil chirisinquil li ma̱us aj musik'ej. ");
INSERT INTO kekNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ut quixye reheb: —Ma̱c'a' c'a'ru te̱c'am nak texxic, ca'aj cui' le̱ xuk'. Inc'a' te̱c'am e̱tzacae̱mk, chi moco junak bo̱ls, chi moco tumin te̱c'am. ");
INSERT INTO kekNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ca'aj cui' le̱ xa̱b cuan che̱rok te̱c'am ut ca'aj cui' le̱ rak' cuan che̱rix te̱c'am. ");
INSERT INTO kekNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ut quixye ajcui' reheb: —Nak texcuulak sa' junak tenamit, sa' li cab tex-oc cui' chi hila̱nc, aran texcana̱k ut inc'a' yal yo̱kex chixjalbal e̱na'aj. Nak ac xic e̱re sa' jalan chic tenamit, tojo'nak te̱jal le̱ na'aj. ");
INSERT INTO kekNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Cui texcuulak sa' junak na'ajej bar cui' inc'a' texc'ulek' chi moco te'raj rabinquil le̱ ra̱tin, nak tex-e̱lk riq'uineb te̱chik' li poks che̱rok jo' retalil li raylal te'xc'ul. Relic chi ya̱l ninye e̱re nak k'axal cui'chic li raylal te'xc'ul chiruheb laj Sodoma ut laj Gomorra sa' xk'ehil li rakba a̱tin, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jo'can nak que'co̱eb lix tzolom li Jesús ut que'xch'olob xya̱lal chiruheb li tenamit re nak te'xyot' xch'o̱l ut te'xjal xc'a'uxeb. ");
INSERT INTO kekNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Que'risi nabal li ma̱us aj musik'ej riq'uineb ut que'xq'ue li aceite sa' xjolomeb li yaj jo' retalil xcuanquil li Dios ut que'xq'uirtesiheb. ");
INSERT INTO kekNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Li tenamit yo̱queb chixserak'inquil li milagro yo̱ chixba̱nunquil li Jesús. Nak quirabi a'an, li rey Herodes quixye: —A'an laj Juan laj Cubsihom Ha'. Xcuacli cui'chic chi yo'yo sa' xya̱nkeb li camenak. Jo'can nak cuan xcuanquil chixba̱nunquil li milagro, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ut cuan que'yehoc re nak a'an li profeta Elías. Ut cuan ajcui' que'yehoc re nak a'an jun li profeta jo' li profeta que'cuan najter. ");
INSERT INTO kekNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ut nak quirabi a'an, laj Herodes quixye: —A'an laj Juan li quintakla xch'otbal xcux. A'an xcuacli chi yo'yo sa' xya̱nkeb li camenak, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Quixye chi jo'can xban nak a'an quitaklan re xchapbal laj Juan. Que'xbac' ut que'xq'ue sa' tz'alam. Quixba̱nu chi jo'can xban nak jo'can quiraj lix Herodías. Lix Herodías a'an rixakil laj Felipe, ri̱tz'in laj Herodes ut laj Herodes quixc'am chok' rixakil. ");
INSERT INTO kekNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Nak toj ma̱ji' naq'uehe' sa' tz'alam, laj Juan laj Cubsihom Ha' quixye re laj Herodes: —Nimla ma̱c xaba̱nu nak xac'am chok' a̱cuixakil lix Herodías xban nak ac sumsu riq'uin la̱ cui̱tz'in, laj Felipe, chan re. ");
INSERT INTO kekNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Riq'uin a'an ma̱ ca'ch'in nak quijosk'o' lix Herodías sa' xbe̱n laj Juan ut quiraj raj xcamsinquil. Abanan inc'a' naru xban nak laj Herodes inc'a' quixcanab chixcamsinquil. ");
INSERT INTO kekNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Laj Herodes naxnau nak laj Juan ti̱c xch'o̱l ut santil cui̱nk. Jo'can nak naxucuac ut inc'a' naraj nak ta̱camsi̱k. Quicuulac chiru rabinquil li quixye laj Juan usta c'ajo' nak naq'uehe' chi c'oxlac xban li a̱tin nayehe' re. ");
INSERT INTO kekNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Abanan lix Herodías quixtau chanru nak naru xcamsinquil laj Juan. Jo'ca'in quic'ulman. Nak laj Herodes quixnink'ei lix chihab, quixbokeb chi cua'ac li ni̱nkeb xcuanquil sa' li tenamit, ut quixbokeb ajcui' li neque'taklan reheb li soldado ut jo'can ajcui' chixjunileb li xni̱nkal ru cui̱nk re Galilea. ");
INSERT INTO kekNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Lix co' lix Herodías qui-oc bar yo̱queb cui' chi cua'ac li ula' ut qui-oc chi xajoc chiruheb. Laj Herodes quicuulac chiru chanru naxajoc. Ut quicuulac ajcui' chiruheb li ula'. Jo'can nak laj Herodes quixye re li xka'al: —Ta̱tz'a̱ma cue li c'a'ru ta̱cuaj ut la̱in tinq'ue a̱cue, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ut quixye ajcui' re li xka'al: —Sa' xc'aba' li Dios, tinq'ue a̱cue li c'a'ru ta̱patz' cue. Usta yijach lin jun cablal ta̱patz' cue, tinq'ue a̱cue, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ut li xka'al co̱ chixpatz'bal re lix na': —¿C'a'ru us tintz'a̱ma re? chan. Ut lix na' quixye re: —Tz'a̱ma re nak tixq'ue a̱cue lix jolom laj Juan laj Cubsihom Ha', chan. ");
INSERT INTO kekNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Sa' junpa̱t co̱ li xka'al riq'uin laj Herodes ut quixye re: —La̱in tincuaj nak anakcuan ajcui' ta̱q'ue cue sa' junak plato lix jolom laj Juan laj Cubsihom Ha', chan. ");
INSERT INTO kekNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ut laj Herodes c'ajo' nak quiraho' sa' xch'o̱l. Abanan ma̱c'a' chic quiru quixye xban nak chixjunileb li ula' que'abin re nak quixye sa' xc'aba' li Dios tixq'ue re li c'a'ru tixtz'a̱ma. ");
INSERT INTO kekNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Laj Herodes ticto quixtakla jun li soldado chixc'ambal chak lix jolom laj Juan. Li soldado co̱ sa' tz'alam chixch'otbal lix cux laj Juan. ");
INSERT INTO kekNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ut quixc'am chak lix jolom sa' jun li plato. Quixq'ue re li xka'al ut li xka'al quixk'axtesi re lix na'. ");
INSERT INTO kekNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nak que'rabi lix tzolom laj Juan nak que'xcamsi, que'chal chixc'ambal li camenak ut coxe'xmuk. ");
INSERT INTO kekNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ut nak que'suk'i chak lix tzolom li Jesús chixba̱nunquil li c'anjel que'takla̱c cui', cole'xch'utub rib riq'uin li Jesús ut que'xserak'i re c'a'ru quilaje'xba̱nu chak. Ut que'xye ajcui' re chanru nak que'xtzol li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Neque'el neque'oc li q'uila tenamit riq'uin li Jesús. Jo'can ajcui' riq'uineb lix tzolom. Ut riq'uin a'an inc'a' naru neque'hilan chi moco naru te'cua'ak. Jo'can nak quixye li Jesús: —Yo'keb sa' junak na'ajej bar ma̱c'a' cui' tenamit re nak naru tohila̱nk ca'ch'inak kajunes, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ut que'oc sa' jun li jucub ut que'co̱eb sa' jun na'ajej bar cui' te'hila̱nk raj ca'ch'inak xjuneseb. ");
INSERT INTO kekNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Abanan nabaleb que'iloc re nak yo̱queb chi xic ut que'xnau nak a'an li Jesús. Nabal quilaje'el sa' li tenamit junju̱nk. Que'co̱eb chi rokeb sa' a̱nil ut a'aneb xbe̱n cua que'cuulac sa' li na'ajej bar yo̱ cui' chi xic li Jesús rochbeneb lix tzolom. ");
INSERT INTO kekNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ut nak qui-el li Jesús sa' li jucub, quirileb li q'uila tenamit. Quixtok'oba ruheb xban nak chanchaneb li carner ma̱c'a' aj ilol reheb. Ut nabal li c'a'ak re ru quixtzoleb cui'. ");
INSERT INTO kekNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nak que'ril nak yo̱ chi ecuu̱c, que'co̱eb lix tzolom riq'uin li Jesús ut que'xye re: —Yo̱ chi ecuu̱c ut arin ma̱c'a' cuan. ");
INSERT INTO kekNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ma̱c'a' xcuaheb. Taklaheb chixlok'baleb lix cua sa' eb li c'aleba̱l ut sa' eb li coc' tenamit li cuanqueb chi nach', chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ut nak quichak'oc li Jesús quixye reheb: —Q'uehomakeb chi cua'ac la̱ex.— Ut eb a'an que'xye: —¿Ma toxic chixlok'bal cuibak ciento denarios chi caxlan cua chi jo'canan re te'kaq'ue chi cua'ac? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Li Jesús quixye: —¿Jarub li caxlan cua cuan e̱riq'uin? Ayukex, ilomak chak.— Que'co̱eb chi rilbal ut nak que'suk'i que'xye re: —Cuan o̱b li caxlan cua ut cuib li car, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Li Jesús quixtaklaheb lix tzolom chixyebal reheb li tenamit nak te'c'ojla̱k sa' li pach'aya' chi junju̱nk ch'u̱tal. ");
INSERT INTO kekNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ut que'c'ojla chi junju̱nk ch'u̱tal. Cuan que'c'ojla chi jun ciento sa' ju̱nk ch'u̱tal ut cuan cui'chic que'c'ojla chi mero ciento sa' li junju̱nk ch'u̱tal. ");
INSERT INTO kekNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tojo'nak li Jesús quixchap li o̱b chi caxlan cua ut li cuib chi car ut qui-iloc sa' choxa. Quixbantioxi chiru li Dios. Ut quixjachi li caxlan cua ut quixq'ue reheb lix tzolom re nak te'xjeq'ui reheb li q'uila tenamit. Ut que'xjeq'ui ajcui' li car. ");
INSERT INTO kekNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Que'cua'ac chixjunileb toj retal que'c'ojla xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ut qui-ela'an li caxlan cua. Jo'can ajcui' li car. Cablaju chacach li qui-ela'an. ");
INSERT INTO kekNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nabal chi tenamit que'cua'ac. Sa' xya̱nkeb li que'cua'ac cuanqueb o̱b mil junes cui̱nk. ");
INSERT INTO kekNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ut chirix chic a'an, li Jesús quixtaklaheb lix tzolom sa' li jucub ut quixye reheb: —Xbe̱n cua texxic jun pac'al li palau sa' li tenamit Betsaida. La̱in toj tincana̱k chixchak'rabinquileb li tenamit, chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ut nak ac xchak'rabiheb li tenamit, li Jesús co̱ chiru tzu̱l chi tijoc. ");
INSERT INTO kekNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Te'cuulak lix tzolom sa' xyi li palau nak qui-oc li k'ojyi̱n, a'ut li Jesús toj cuan xjunes chire li palau. ");
INSERT INTO kekNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Quiril nak lix tzolom cuanqueb sa' jun ch'a'ajquilal sa' li jucub. Yo̱queb chixtacuasinquil ribeb chixberesinquil li jucub xban nak sa' xbe ik' yo̱queb chixc'ambal. Sake̱uc re nak quicuulac li Jesús bar cuanqueb cui' ut yo̱ chi be̱c chiru ha'. Quixba̱nu jo' li ti̱c ta̱numek'. ");
INSERT INTO kekNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nak que'ril lix tzolom nak cuan jun yo̱ chi be̱c chiru ha', que'xucuac ut que'xjap re. Que'xc'oxla nak anum yo̱queb chirilbal. ");
INSERT INTO kekNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Chixjunileb que'iloc re ut c'ajo' nak que'xucuac. Li Jesús ticto quira̱tinaheb ut quixye reheb: —Mexxucuac. La̱in li yo̱quex chicuilbal. Cacuubresihomak e̱ch'o̱l, chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nak qui-oc sa' li jucub sa' xya̱nkeb, ch'anamil li ik'. Inc'a' chic qui-ec'an. Ut eb lix tzolom quilaje'sach xch'o̱l chirilbal. ");
INSERT INTO kekNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Que'sach xch'o̱l xban nak toj ma̱ji' neque'xtau xya̱lal chirix li milagro quixba̱nu li Jesús riq'uin li caxlan cua. K'axal cauheb xch'o̱l. Jo'can nak inc'a' que'xtau ru. ");
INSERT INTO kekNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nak que'cuulac li Jesús rochbeneb lix tzolom jun pac'al li palau, coxe'e̱lk sa' li tenamit Genesaret. Que'xbac' li jucub chire li ha'. ");
INSERT INTO kekNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nak yo̱queb chi e̱lc sa' li jucub, eb li cuanqueb aran ticto que'xnau nak a'an li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jo'can nak sa' junpa̱t que'co̱eb sa' chixjunil li na'ajej chixc'ambaleb chak lix yaj chiruheb lix cuarib. Nak que'xnau bar cuan li Jesús, quilaje'xc'am li yaj riq'uin. ");
INSERT INTO kekNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yalak bar quinume' li Jesús quilaje'xc'am li yaj riq'uin, jo' sa' tenamit, jo' sa' c'aleba̱l. Que'xq'ueheb li yaj sa' li be bar cui' yo̱ chi numec' li Jesús. Que'xtz'a̱ma chiru: —Ba̱nu usilal, q'ue chikach'e' la̱ cuak', chanqueb re xban nak neque'xnau nak usta ca'aj cui' re li rak' te'xch'e', te'q'uira̱k. Ut chixjunileb li que'ch'e'oc re li rak', que'q'uira. ");
INSERT INTO kekNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Eb laj fariseo que'cuulac riq'uin li Jesús rochbeneb cuib oxib laj tz'i̱b li que'chal chak aran Jerusalén. ");
INSERT INTO kekNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ut eb a'an que'xq'ue retal nak cuan lix tzolom li Jesús que'cua'ac chi inc'a' que'xch'aj li ruk'eb chi tz'akal jo' c'aynakeb chixba̱nunquil laj fariseo. ");
INSERT INTO kekNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Eb laj fariseo ut chixjunileb laj judío inc'a' neque'cua'ac cui inc'a' te'xch'aj li ruk'eb jo' naxye li chak'rab li canabanbil reheb xbaneb lix xe'to̱nil yucua'. ");
INSERT INTO kekNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ut nak neque'suk'i chak sa' c'ayil inc'a' neque'cua'ac cui inc'a' neque'ch'ajoc jo' naxye lix chak'rabeb. Ut cuan cui'chic nabal li na'leb li neque'xba̱nu jo' canabanbil reheb xbaneb li xe'to̱nil yucua', jo' li xch'ajbal lix sec', lix xar, li uc'al ch'i̱ch' ut lix ch'a̱t. ");
INSERT INTO kekNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Eb laj fariseo ut eb laj tz'i̱b que'xpatz' re li Jesús: —¿C'a'ut nak eb la̱ tzolom inc'a' neque'xba̱nu li kachak'rabinquil canabanbil ke xbaneb li kaxe' kato̱n? Eb a'an neque'cua'ac chi inc'a' neque'xch'aj li ruk'eb jo' naxye li kachak'rabinquil, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nak quichak'oc li Jesús quixye reheb: —Ya̱l ajcui' li quixye laj Isaías che̱rix la̱ex aj ca'pac'al u nak quixye chi jo'ca'in: Li tenamit a'in niquine'x-oxlok'i ca'aj cui' riq'uin xtz'u̱maleb re. Moco neque'xba̱nu ta chi anchal xch'o̱leb. ");
INSERT INTO kekNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ma̱c'a' aj e nak niquine'xlok'oni xban nak li tijleb li neque'xc'ut a'an yal xchak'rab eb li cui̱nk. (Is. 29:13) ");
INSERT INTO kekNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","La̱ex nequetz'ekta̱na lix chak'rab li Dios, ut a' chic le̱ najter na'leb nequeba̱nu, jo' riq'uin xch'ajbal li sec' ut li xar ut li c'a'ak ru chi chak'rabil reheb li cui̱nk.— ");
INSERT INTO kekNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Li Jesús quixye ajcui' reheb: —La̱ex nequetz'ekta̱na lix chak'rab li Dios re nak te̱ba̱nu li najter na'leb canabanbil e̱re xbaneb le̱ xe'to̱nil yucua'. ");
INSERT INTO kekNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Laj Moisés quixye, “Cha-oxlok'i la̱ na' la̱ yucua' ut ani tixhob xna' xyucua', ta̱camsi̱k.” ");
INSERT INTO kekNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","A'ut la̱ex nequeye cui cuan junak li cui̱nk inc'a' naraj xtenk'anquil lix na' xyucua', a'an naru tixye, “Corbán”, chirix li c'a'ak re ru tixtenk'a cui' raj lix na' xyucua'. Li a̱tin a'an naraj naxye “yechi'inbil re li Dios”. ");
INSERT INTO kekNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Riq'uin xba̱nunquil a'an li cui̱nk inc'a' chic naru tixtenk'a lix na' xyucua', chanquex. ");
INSERT INTO kekNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ut cuan nabal chic c'a'ak re ru chi na'lebil nalaje̱ba̱nu. Riq'uin xba̱nunquil li najter na'leb canabanbil e̱re, yo̱quex chixtz'ekta̱nanquil lix chak'rab li Dios, chan li Jesús reheb. ");
INSERT INTO kekNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ut li Jesús quixbokeb li tenamit ut quixye reheb: —Abihomak che̱junilex li c'a'ru tinye ut q'uehomak retal re nak te̱tau xya̱lal. ");
INSERT INTO kekNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ma̱cua' li c'a'ru naxtzaca li cui̱nk nama̱co' cui'; aban li c'a'ru inc'a' us naxc'oxla, a'an nama̱co' cui'. ");
INSERT INTO kekNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Li ani naraj rabinquil, chixq'uehak retal li ninye.— ");
INSERT INTO kekNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nak li Jesús qui-el sa' xya̱nkeb li q'uila tenamit, qui-oc sa' cab. Ut eb lix tzolom que'xpatz' re: —¿C'a'ru xya̱lal li a̱tin xaye?— ");
INSERT INTO kekNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ut li Jesús quixye reheb: —¿Ma inc'a' ajcui' xetau ru la̱ex li xinye? ¿Ma inc'a' nequenau nak ma̱cua' li c'a'ru naxtzaca junak nama̱co' cui'? ");
INSERT INTO kekNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Li c'a'ru naxtzaca junak, a'an moco sa' ra̱m ta naxic. Ti̱c sa' xsa' naxic ut chirix a'an naxtz'ek cui'chic, chan. Jo'can nak quixye nak chixjunil li natzacaman moco ma̱c ta xtzacanquil. ");
INSERT INTO kekNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ut quixye ajcui' li Jesús reheb: —Li inc'a' us naxc'oxla sa' xch'o̱l, a'an nama̱cob cui'. ");
INSERT INTO kekNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Sa' xc'a'ux junak nachal chak li ma̱us aj na'leb, li muxuc caxa̱r, li co'be̱tac yumbe̱tac, ut li xcamsinquil ras ri̱tz'in. ");
INSERT INTO kekNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Ut sa' xc'a'ux ajcui' nachal li elk'ac, lix rahinquil ru c'a'ru re ras ri̱tz'in, li ma̱usilal, li balak'i̱nc, li xba̱nunquil li xuta̱nalil na'leb, li cakali̱nc, li majecua̱nc, li k'etk'etil, ut lix majelil na'leb. ");
INSERT INTO kekNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Chixjunil li ma̱us aj na'leb a'in sa' xc'a'ux junak nachal chak ut a'an nama̱cob cui' li junju̱nk.— ");
INSERT INTO kekNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Li Jesús co̱ sa' jalan na'ajej xcue̱nt Tiro ut xcue̱nt Sidón. Cox-oc sa' jun li cab. Inc'a' raj quiraj quinauhe' nak cuan aran. Abanan inc'a' quiru quixmuk rib. ");
INSERT INTO kekNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Sa' junpa̱t qui-abi̱c resil xban jun li ixk nak cuan aran. Li ixk a'an cuan jun lix co' cuan ma̱us aj musik'ej riq'uin. Co̱ riq'uin li Jesús ut quixcuik'ib rib chiru. ");
INSERT INTO kekNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Li ixk a'an ma̱cua' aj judío, a'an aj Sirofenicia. Quixtz'a̱ma chiru li Jesús nak ta̱risi li ma̱us aj musik'ej riq'uin lix co'. ");
INSERT INTO kekNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ut li Jesús quixye re: —Cua'akeb cuan junxil li coc'al. Inc'a' us xmak'bal xcuaheb li coc'al ut xq'uebal reheb li tz'i', chan. ");
INSERT INTO kekNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ut li ixk quichak'oc ut quixye re: —Ya̱l li nacaye, Ka̱cua', abanan eb li tz'i' neque'xxoc xc'aj xcua li coc'al rubel li me̱x nak yo̱queb chi cua'ac, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Li Jesús quixye re li ixk: —Us li xaye. Ayu sa' la̱ cuochoch. Ac x-el li ma̱us aj musik'ej riq'uin la̱ co', chan. ");
INSERT INTO kekNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Co̱ li ixk sa' li rochoch ut coxtau lix co' chi yocyo chiru lix ch'a̱t. Ma̱c'a' chic li ma̱us aj musik'ej riq'uin. ");
INSERT INTO kekNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Nak qui-el li Jesús rochbeneb lix tzolom sa' li na'ajej xcue̱nt Tiro, que'nume' sa' li tenamit Sidón. Ut que'nume' ajcui' sa' li na'ajej xcue̱nt Decápolis, ut que'cuulac cuan cui' li palau Galilea. ");
INSERT INTO kekNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ut quic'ame' chak jun li cui̱nk riq'uin li Jesús tz'ap xic ut tat re. Que'xtz'a̱ma chiru nak tixq'ue li ruk' sa' xbe̱n. ");
INSERT INTO kekNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Li Jesús quirisi li cui̱nk sa' xya̱nkeb li tenamit ut quixc'am xjunes. Quixch'ic li ru'uj ruk' sa' xxic li cui̱nk. Quixt'akresi li ru'uj ruk' riq'uin li xya'al re ut quixch'e' li ru'uj rak' li cui̱nk. ");
INSERT INTO kekNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Qui-iloc sa' choxa, quixjik' xch'o̱l ut quixye: —Efata.— Sa' li ra̱tinoba̱l naraj naxye, “Chiteli̱k la̱ xic ut chat-abi̱nk.” ");
INSERT INTO kekNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Sa' junpa̱t quiteli lix xic ut na-abin chic ut sa chic naa̱tinac. ");
INSERT INTO kekNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ut li Jesús quixye reheb li q'uila tenamit: —Ma̱ ani aj e te̱serak'i li c'a'ru yo̱quin chixba̱nunquil, chan. Quixk'useb chi us. Abanan eb a'an k'axal cui'chic nak que'oc chixserak'inquil. ");
INSERT INTO kekNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","C'ajo' nak que'sach xch'o̱leb chirilbal ut que'xye: —Cha̱bil chixjunil li naxba̱nu. Naxq'ue chi abi̱nc li tz'ap xic ut naxq'ue chi a̱tinac li mem, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Sa' jun chic li cutan que'xch'utub rib nabal li tenamit riq'uin li Jesús. Xban nak ma̱c'a' xcuaheb quixbokeb lix tzolom ut quixye reheb: ");
INSERT INTO kekNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Tok'obeb ru li q'uila tenamit a'in. Ac cuan oxib cutan roquiqueb arin cuiq'uin ut ma̱c'a' chic xcuaheb. ");
INSERT INTO kekNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Cui tebintakla sa' rochocheb chi inc'a' te'cua'ak, naru neque'lub sa' be xban nak cuan najt xe'chal chak.— ");
INSERT INTO kekNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Lix tzolom que'xye re: —¿Bar takatau cua sa' li na'ajej a'in re takaq'ueheb chi cua'ac? Arin ma̱c'a' cuan, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ut li Jesús quixpatz' reheb: —¿Jarub li caxlan cua cuan e̱riq'uin? chan. —Cuukub ajcui', chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tojo'nak quixye reheb li tenamit nak te'chunla̱k chiru ch'och'. Quixchap li cuukub chi caxlan cua. Quixbantioxi chiru li Dios ut quixjachi. Ut quixq'ue reheb lix tzolom re nak te'xjeq'ui reheb li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ut cuan cuib oxib li coc' car riq'uineb. Nak quirosobtesi quixye reheb nak te'xjeq'ui ajcui' reheb li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Que'cua'ac chi us ut que'c'ojla xch'o̱l. Ut cuukub chacach chic li qui-ela'an. ");
INSERT INTO kekNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Cuanqueb na ca̱hibak mil li que'cua'ac ut nak ac xe'cua'ac, que'chak'rabi̱c xban li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ut sa' junpa̱t qui-oc li Jesús sa' li jucub rochbeneb lix tzolom ut que'co̱eb sa' li na'ajej xcue̱nt Dalmanuta. ");
INSERT INTO kekNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Que'cuulac laj fariseo riq'uin li Jesús. Que'oc chixcuech'inquil yal re xyalbal. Que'xye re nak tixba̱nu junak milagro chiruheb re rilbal ma ya̱l na nak riq'uin li Dios nachal lix cuanquil. ");
INSERT INTO kekNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Quixjik' xch'o̱l li Jesús xban nak quititz' xbaneb, ut quixye: —Ca'aj cui' milagro yo̱queb chixpatz'bal eb li tenamit a'in. Relic chi ya̱l tinye e̱re nak ma̱ jun milagro tinba̱nu chiruheb.— ");
INSERT INTO kekNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Qui-el riq'uineb laj fariseo. Qui-oc sa' li jucub rochbeneb lix tzolom. Yo̱queb chi xic jun pac'al li palau. ");
INSERT INTO kekNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ut quisach sa' xch'o̱leb xc'ambal xcuaheb. Ac cuanqueb sa' li jucub nak que'xq'ue retal nak jun ajcui' li caxlan cua cuan riq'uineb. ");
INSERT INTO kekNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Li Jesús quixye reheb: —Cheba̱nu cue̱nt. Micuan xch'amal xcaxlan cuaheb laj fariseo e̱riq'uin chi moco xch'amal xcaxlan cua laj Herodes.— ");
INSERT INTO kekNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Eb lix tzolom que'oc chi a̱tinac chi ribileb rib ut que'xye: —¿C'a'ru xya̱lal a'in? ¿Ma xban nak ma̱c'a' li caxlan cua kiq'uin nak xye ke chi jo'can? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Li Jesús quixnau c'a'ru yo̱queb chixyebal chi ribileb rib ut quixye reheb: —¿C'a'ut nak yo̱quex chixyebal nak ma̱c'a' e̱cua? ¿Ma inc'a' nequetau ru nak ma̱cua' chirix xch'amal li caxlan cua yo̱quin chi a̱tinac? Chirix ban xtijlebeb laj fariseo yo̱quin chi a̱tinac. La̱ex c'ajo' xcacuil e̱ch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Inc'a' nequetau xya̱lal. Cuan xnak' e̱ru ut inc'a' nequex-iloc. Cuan e̱xic ut inc'a' nequex-abin. ");
INSERT INTO kekNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Ma inc'a' najultico' e̱re nak xinjachi li o̱b chi caxlan cua reheb li o̱b mil chi cui̱nk? Ut ¿jarub chacach qui-ela'an? chan reheb. —Cablaju, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—¿Ma inc'a' najultico' e̱re nak xinjachi li cuukub chi caxlan cua reheb li ca̱hib mil. Ut jarub chacach qui-ela'an? chan reheb. —Cuukub chacach, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ut li Jesús quixye reheb: —¿Ma toj ma̱ji' ajcui' nequetau xya̱lal chi jo'canan?— ");
INSERT INTO kekNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Que'cuulac li Jesús rochbeneb lix tzolom aran Betsaida. Quic'ame' chak jun li cui̱nk riq'uin. Mutz' ru li cui̱nk. Que'xtz'a̱ma chiru nak tixq'ue li ruk' sa' xbe̱n re nak ta̱ilok. ");
INSERT INTO kekNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Li Jesús quixchap li ruk' li mutz' ut quixc'am chire li tenamit. Ut quixchu̱ba sa' xnak' ru li mutz'. Quixq'ue li ruk' sa' xbe̱n ut quixpatz' re: —¿Ma nacat-iloc bayak anakcuan? chan re. ");
INSERT INTO kekNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Li mutz' qui-iloc ut quixye: —Nin-iloc ca'ch'in. Nacuileb li cui̱nk chanchaneb li che' nak yo̱queb chi be̱c.— ");
INSERT INTO kekNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tojo'nak li Jesús quixq'ue cui'chic li ruk' sa' li xnak' ru li mutz' ut quiq'uira li ru. Nak qui-iloc li cui̱nk, tz'akal chic naril chixjunil. ");
INSERT INTO kekNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Li Jesús quixtakla li cui̱nk sa' rochoch ut quixye re: —Matxic sa' li tenamit ut ma̱ ani aj e ta̱ye nak xatinq'uirtesi, chan re. ");
INSERT INTO kekNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Chirix a'an co̱ li Jesús rochbeneb lix tzolom sa' li coc' tenamit xcue̱nt Cesarea Filipo. Nak yo̱queb chi xic, quixpatz' reheb lix tzolom: —¿Anihin la̱in nak neque'xye li tenamit? chan. ");
INSERT INTO kekNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Que'xye re: —Cuan neque'yehoc re nak la̱at laj Juan laj Cubsihom Ha' xcuacli cui'chic chi yo'yo. Ut cuan neque'yehoc re nak la̱at li profeta Elías, li quicuan najter. Ut cuan cui'chic neque'yehoc re nak la̱at jun chic li profeta, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—Ut la̱ex ¿anihin la̱in nak nequeye? chan cui'chic reheb. Ut laj Pedro quixye: —La̱at li Cristo.— ");
INSERT INTO kekNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Li Jesús quixye reheb nak ma̱ ani aj e te'xye nak a'an li Cristo. ");
INSERT INTO kekNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Li Jesús quixch'olob xya̱lal chiruheb nak a'an li Alalbej ut nak nabal li raylal cha̱lc re sa' xbe̱n. Quixye reheb nak ta̱tz'ekta̱na̱k xbaneb li xakabanbileb chi c'anjelac sa' li templo. Ta̱tz'ekta̱na̱k ajcui' xbaneb li xbe̱nil aj tij. Jo' ajcui' xbaneb laj tz'i̱b ut quixye ajcui' reheb nak ta̱camsi̱k ut ta̱cuacli̱k cui'chic chi yo'yo sa' rox li cutan. ");
INSERT INTO kekNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Quixye chi tz'akal li c'a'ru tixc'ul. Nak quirabi a'an laj Pedro quirisi xjunes li Jesús ut qui-oc chixk'usbal ut quixye re: —Ma̱ye chi jo'can Ka̱cua'.— ");
INSERT INTO kekNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ut li Jesús quixsuk'isi rib. Quirileb lix tzolom ut quixk'us laj Pedro. Quixye re: —Elen arin sa' xnak' cuu. La̱at chanchanat aj Tza. La̱at inc'a' yo̱cat chixc'oxlanquil jo' naxc'oxla li Dios. La̱at yo̱cat chixc'oxlanquil jo' naxc'oxla li cui̱nk, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tojo'nak quixbokeb li q'uila tenamit rochbeneb lix tzolom ut quixye reheb: —Li ani ta̱raj inpa̱banquil, tento nak tixtz'ekta̱na li c'a'ru naxrahi ru lix ch'o̱l. Tixcuy xnumsinquil li raylal li tixc'ul usta ta̱camsi̱k sa' inc'aba'. Ut chinixta̱kehak. ");
INSERT INTO kekNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Li ani ta̱tz'ekta̱na̱nk cue re xcolbal lix yu'am arin sa' ruchich'och', tixtz'ek li junelic yu'am. A'ut li naxsach lix yu'am sa' inc'aba' la̱in malaj ut sa' xc'aba' li evangelio, a'an ta̱re̱chani li junelic yu'am. ");
INSERT INTO kekNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿C'a'ru tixra junak cui̱nk nak ta̱re̱chani chixjunil lix biomal li ruchich'och' ut tixtz'ekta̱na li junelic yu'am xban li biomal? ");
INSERT INTO kekNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Ma cuan ta bi' li c'a'ru tixtoj cui' li yu'am chi junelic? ");
INSERT INTO kekNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Li ani ta̱xuta̱na̱k chiruheb li tenamit aj ma̱c inban la̱in malaj ut xban li cua̱tin, la̱in li Alalbej tinxuta̱na̱k ajcui' xbaneb nak tincha̱lk chak riq'uin xnimal xlok'al lin Yucua' cuochbeneb li santil ángel.— ");
INSERT INTO kekNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ut li Jesús quixye: —Relic chi ya̱l tinye e̱re nak cuanqueb arin sa' e̱ya̱nk li inc'a' te'ca̱mk toj te'ril lix nimajcual cuanquilal li Dios nak ta̱cha̱lk riq'uin lix xcuanquil.— ");
INSERT INTO kekNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Cuakib cutan chic xyebal a'an xban li Jesús nak quixc'ameb laj Pedro, laj Jacobo, ut laj Juan sa' xbe̱n jun li nimla tzu̱l. Nak cuanqueb aran xjuneseb, quijalano' li riloba̱l li Jesús chiruheb. ");
INSERT INTO kekNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ut li rak' quijalano' rilbal. Nalemtz'un chic li rak'. Saksakpotz'in nac'utun, chanchan li ratz'am que. Ma̱ jun aj puch'unel arin sa' ruchich'och' tixsakobresi junak t'icr jo' nak quisakobresi̱c li rak' li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ac xaka̱mil laj Elías ut laj Moisés chiruheb nak que'ril. Ut yo̱queb chi a̱tinac riq'uin li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Laj Pedro quixye: —Ka̱cua', c'ajo' xchak'al ru nak cuanco arin. Xkayi̱b ta oxibak muheba̱l arin. Jun a̱cue, jun re laj Moisés, ut jun re laj Elías.— ");
INSERT INTO kekNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Quixye chi jo'can xban nak inc'a' chic naxnau c'a'ru tixye xban nak c'ajo' lix xiuheb. ");
INSERT INTO kekNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ut quichal jun nimla chok sa' xbe̱neb. Li Dios quia̱tinac chak sa' li chok, ut quixye: —A'in li cualal, raro inban. Cherabi li c'a'ru tixye.— ");
INSERT INTO kekNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ut nak quiril ac ma̱ aniheb chic laj Elías ut laj Moisés. Ca'aj chic li Jesús quicana xjunes. ");
INSERT INTO kekNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nak yo̱queb chak chi cubec sa' li tzu̱l quixye li Jesús reheb nak ma̱ ani aj e te'xye li c'a'ru que'ril toj ta̱cuacli̱k cui'chic li Alalbej chi yo'yo sa' xya̱nkeb li camenak. ");
INSERT INTO kekNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Eb a'an ma̱ ani aj e que'xye, ca'aj cui' chi ribileb rib que'a̱tinac. Que'xye: —¿C'a'ru xya̱lal a'an nak li Jesús quixye nak ta̱cuacli̱k cui'chic chi yo'yo sa' xya̱nkeb li camenak?— ");
INSERT INTO kekNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Que'xpatz' re li Jesús: —¿C'a'ut nak neque'xye laj tz'i̱b nak xbe̱n cua ta̱cha̱lk laj Elías tojo'nak tol-e̱lk li Cristo? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ut nak quichak'oc li Jesús quixye reheb: —Ya̱l ajcui' tz'i̱banbil retalil nak laj Elías xbe̱n cua ta̱cha̱lk chixc'u̱banquil chixjunil li c'a'ak re ru. Ut tz'i̱banbil ajcui' sa' li Santil Hu chicuix la̱in li Alalbej nak nabal li raylal tinc'ul ut tine'xtz'ekta̱na. ");
INSERT INTO kekNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Abanan tinye e̱re nak laj Elías ac xc'ulun ut c'ajo' li raylal que'xba̱nu re jo' tz'i̱banbil sa' li Santil Hu chanru ta̱c'ulma̱nk.— ");
INSERT INTO kekNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nak coxe'e̱lk cuanqueb cui' li bele̱b chic lix tzolom li Jesús, que'ril nak cuan nabal li tenamit riq'uineb. Ut eb laj tz'i̱b yo̱queb chixcuech'inquil lix tzolom li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ut eb li q'uila tenamit que'sach xch'o̱l chirilbal li Jesús, ut que'co̱eb sa' a̱nil chixc'ulbal ut que'xq'ue xsahil xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Li Jesús quixpatz' reheb: —¿C'a'ru nequecuech'i cui' e̱rib? chan. ");
INSERT INTO kekNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Quichak'oc jun sa' xya̱nkeb li q'uila tenamit ut quixye re: —At Ka̱cua', xinc'am chak jun li cualal arin. Mem ut cuan ma̱us aj musik'ej riq'uin. ");
INSERT INTO kekNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Yalak bar nacute' sa' ch'och' xban li ma̱us aj musik'ej. Na-el cuokx sa' re ut naxc'uxuxi li ruch re ut naxchec' rib. Xintz'a̱ma chiruheb la̱ tzolom nak te'risi li ma̱us aj musik'ej; abanan inc'a' xe'ru chirisinquil.— ");
INSERT INTO kekNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nak li Jesús quichak'oc, quixye reheb: —Ti̱c inc'a' nequexpa̱ban. ¿Jo' najtil chic tincua̱nk e̱riq'uin re nak texpa̱ba̱nk? ¿Jo' najtil chic texincuy nak nequec'oxla? C'am chak li al arin cuiq'uin, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Que'xc'am li al riq'uin ut li ma̱us aj musik'ej nak quiril li Jesús quixch'ikle li al, quixcut sa' ch'och' ut quixtolc'osi ut qui-oc chi e̱lc cuokx sa' re. ");
INSERT INTO kekNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ut li Jesús quixpatz' re lix yucua': —¿Jok'e xticla lix yajel li al a'in? chan. —Toj ca'ch'in nak quixtiquib xc'ulbal chi jo'ca'in, chan lix yucua'. ");
INSERT INTO kekNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","—Nabal sut nacute' sa' xam. Nabal sut nacute' sa' ha' xban li ma̱us aj musik'ej re xcamsinquil. Cui cuan c'a'ru naru ta̱ba̱nu re, ba̱nu usilal, il xtok'oba ku ut choa̱tenk'a, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Li Jesús quixye: —¿C'a'ut nak nacaye “cui naru”? ¿Ma inc'a' nacanau nak cui nacatpa̱ban chixjunil naru xba̱nunquil? chan. ");
INSERT INTO kekNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Sa' junpa̱t quia̱tinac lix yucua' li al ut quixye chi cau, —La̱in ninpa̱b. China̱tenk'a re nak tinpa̱b chi tz'akal.— ");
INSERT INTO kekNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nak li Jesús quiril nak sa' junpa̱t yo̱queb chi ch'utla̱c nabal li tenamit, quixch'ila li ma̱us aj musik'ej. Quixye re: —At ma̱us aj musik'ej, la̱at nacatmemobresin. La̱at nacattz'apoc xic. La̱in tinye a̱cue, elen riq'uin li al a'in ut mat-oc chic riq'uin, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ut li ma̱us aj musik'ej quixjap re ut quixch'ikle chi cau li al. Tojo'nak qui-el riq'uin. Ut li al chanchan camenak quicana. Nabal li tenamit que'yehoc re nak xcam. ");
INSERT INTO kekNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ut li Jesús quixchap chi ruk' li al ut quixcuaclesi ut li al quixakli. ");
INSERT INTO kekNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nak qui-oc li Jesús sa' cab xjunes rochbeneb lix tzolom, que'xpatz' re: —¿C'a'ut nak inc'a' xoru la̱o chirisinquil li ma̱us aj musik'ej? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ut li Jesús quixye reheb: —Ca'aj cui' riq'uin ayu̱n ut riq'uin tijoc naru risinquil li ma̱us aj musik'ej a'in.— ");
INSERT INTO kekNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ut nak que'el aran, que'nume' sa' li na'ajej Galilea. Ut li Jesús inc'a' quiraj nak te'xnau nak cuan aran. ");
INSERT INTO kekNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Yo̱ chixch'olobanquil xya̱lal chiruheb lix tzolom. Quixye reheb: —La̱in li Alalbej, tine'xk'axtesi sa' ruk'eb li cui̱nk li te'camsi̱nk cue. Ut nak ac xine'xcamsi, tincuacli̱k cui'chic chi yo'yo sa' xya̱nkeb li camenak sa' rox li cutan.— ");
INSERT INTO kekNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Aban eb a'an inc'a' que'xtau ru li c'a'ru quixye reheb, ut que'xucuac chixpatz'bal c'a'ru xya̱lal li quixye. ");
INSERT INTO kekNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Que'cuulac sa' li tenamit Capernaum. Nak cuanqueb sa' cab quixpatz' reheb lix tzolom: —¿C'a'ru li yo̱quex chixcuech'inquil rix nak yo̱co chi cha̱lc? chan. ");
INSERT INTO kekNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mem que'cana ut inc'a' chic que'chak'oc xban nak yo̱queb chixcuech'inquil rix ani reheb li nim xcuanquil. ");
INSERT INTO kekNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Li Jesús quic'ojla ut quixbokeb li cablaju chi xtzolom riq'uin ut quixye reheb: —Li ani ta̱raj nak ta̱q'uehek' xcuanquil, chixcubsihak rib ut chic'anjelak chiruheb chixjunileb.— ");
INSERT INTO kekNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Quixchap chi ruk' jun li ch'ina al ut quixq'ue sa' xyiheb. Quixk'alu ut quixye reheb: ");
INSERT INTO kekNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Li ani naxq'ue xlok'al li toj k'un xch'o̱l jo' li ch'ina al a'in sa' inc'aba' la̱in, naxq'ue ajcui' inlok'al la̱in. Ut ma̱cua' ca'aj cui' la̱in naxq'ue inlok'al. Naxq'ue aj ban cui' xlok'al li Dios li quitaklan chak cue.— ");
INSERT INTO kekNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Laj Juan quixye re li Jesús: —At Ka̱cua', jun cui̱nk xkil chak le'. Yo̱ chi isi̱nc ma̱us aj musik'ej sa' a̱c'aba'. Ut la̱o xkaye re nak inc'a' tixba̱nu a'an xban nak moco kacomon ta.— ");
INSERT INTO kekNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ut li Jesús quixye reheb: —Me̱k'us xban nak ma̱ ani ta̱ba̱nu̱nk junak milagro sa' inc'aba' la̱in ut mokon ta̱oc ta chintz'ekta̱nanquil. ");
INSERT INTO kekNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Li ani inc'a' xic' na-iloc ke, a'an na-oquen chikix. ");
INSERT INTO kekNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Li ani ta̱q'uehok jun sec'ak ha' e̱re sa' inc'aba' la̱in xban nak la̱ex cualal inc'ajol, relic chi ya̱l tinye e̱re nak tixc'ul lix k'ajca̱munquil.— ");
INSERT INTO kekNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Li ani ta̱po'ok xch'o̱leb li toj k'uneb xch'o̱l, us raj xcutbal sa' li palau chi bac'bo junak nimla pec chi xcux. ");
INSERT INTO kekNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Cui la̱ cuuk' ta̱q'uehok a̱cue chi ma̱cobc, us raj cui ta̱yoc'. Mas us nak cua̱nk la̱ yu'am chi junelic riq'uin jun ajcui' la̱ cuuk' chiru nak tatxic riq'uin cuib la̱ cuuk' sa' li xbalba, bar cui' inc'a' ta̱chupk li xam. ");
INSERT INTO kekNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Aran inc'a' te'ca̱mk li motzo' chi moco li xam ta̱chupk. ");
INSERT INTO kekNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Cui la̱ cuok ta̱q'uehok a̱cue chi ma̱cobc, us raj cui ta̱yoc'. Mas us nak cua̱nk la̱ yu'am chi junelic riq'uin jun la̱ cuok chiru nak tatxic riq'uin cuib la̱ cuok sa' li xbalba, bar cui' inc'a' ta̱chupk li xam. ");
INSERT INTO kekNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Aran inc'a' te'ca̱mk li motzo' chi moco li xam ta̱chupk. ");
INSERT INTO kekNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Cui li xnak' a̱cuu ta̱q'uehok a̱cue chi ma̱cobc, us raj cui ta̱cuisi. Mas us nak tat-oc sa' xnimajcual cuanquilal li Dios riq'uin jun li xnak' a̱cuu chiru nak tatxic sa' li xbalba riq'uin cuib xnak' a̱cuu. ");
INSERT INTO kekNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Aran inc'a' te'ca̱mk li motzo' chi moco li xam ta̱chupk. ");
INSERT INTO kekNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Jo' nak naq'ueman li atz'am chiru li tib re nak inc'a' nachuho', jo'can ajcui' nak nayale' rix li kapa̱ba̱l. Chanchan riq'uin xam nayale' rix xban li raylal nakac'ul. ");
INSERT INTO kekNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Cha̱bil li atz'am, abanan cui na-oso' lix qui'al ma̱c'a' chic na-oc cui'. Jo'can ajcui' la̱ex chi cua̱nk e̱cha̱bilal ut cua̱nkex sa' usilal chi ribil e̱rib. ");
INSERT INTO kekNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ut qui-el li Jesús Capernaum. Que'co̱eb sa' jun li na'ajej cuan xcue̱nt Judea ut que'co̱eb ajcui' toj jun pac'al li nima' Jordán. ");
INSERT INTO kekNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ut que'cuulac laj fariseo riq'uin chi patz'oc yal re xyalbal rix ut que'xye re: —¿C'a'ru nacaye la̱at? ¿Ma ta̱ru̱k tixjach rib junak cui̱nk riq'uin li rixakil? chanqueb re. ");
INSERT INTO kekNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ut nak quichak'oc li Jesús, quixye reheb: —¿C'a'ru le̱ chak'rabinquil quixcanab e̱re laj Moisés?— ");
INSERT INTO kekNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Eb a'an que'xye: —Laj Moisés quixye nak junak li cui̱nk ta̱ru̱k tixyi̱b lix hu re jachoc ib ut riq'uin a'an naru tixjach rib riq'uin li rixakil.— ");
INSERT INTO kekNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Li Jesús quichak'oc ut quixye: —Xban nak k'axal cau e̱ch'o̱l, jo'can nak quixq'ue li chak'rab chi jo'can. ");
INSERT INTO kekNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Abanan ma̱cua' jo'can sa' xticlajic li ruchich'och'. Nak quixyi̱b li ruchich'och' li Dios, quixyo'obtesi li cui̱nk ut quixyo'obtesi li ixk. ");
INSERT INTO kekNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Jo'can nak li cui̱nk tixcanab xna' xyucua' ut tixlak'ab rib riq'uin li rixakil. ");
INSERT INTO kekNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Li ani te'xlak'ab rib junajeb chic. Moco cuibeb ta chic. ");
INSERT INTO kekNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Li ani naxlak'ab li Dios, ma̱ ani chic naru najachoc re, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ut nak ac cuanqueb sa' cab, lix tzolom li Jesús que'xpatz' cui'chic re chirix li na'leb a'in. ");
INSERT INTO kekNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ut li Jesús quixye reheb: —Li ani tixjach rib riq'uin li rixakil ut tixc'am jalan chic ixk, a'an tixmux ru lix sumlajic. ");
INSERT INTO kekNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ut cui junak ixk tixjach rib riq'uin lix be̱lom, ut ta̱c'amek' xban jalan chic cui̱nk, a'an tixmux ru lix sumlajic.— ");
INSERT INTO kekNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Sa' jun li cutan cuan li coc'al que'c'ame' chak riq'uin li Jesús re nak tixq'ue li ruk' sa' xbe̱neb ut ta̱rosobtesiheb. Ut lix tzolom que'xk'us li que'c'amoc chak reheb li coc'al. ");
INSERT INTO kekNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nak li Jesús quixq'ue retal li yo̱queb chixba̱nunquil, c'ajo' nak quipo' ut quixye reheb lix tzolom: —Canabomakeb li coc'al chi cha̱lc cuiq'uin. Me̱ram chiruheb xban nak lix nimajcual cuanquilal li Dios, a'an reheb li neque'pa̱ban jo' nak neque'pa̱ban li coc'al. ");
INSERT INTO kekNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Relic chi ya̱l tinye e̱re li ani inc'a' napa̱ban jo' li coc'al, a'an inc'a' ta̱re̱chani lix nimajcual cuanquilal li Dios, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ut li Jesús quixk'aluheb li coc'al, quixq'ue li ruk' sa' xbe̱neb, ut quirosobtesiheb. ");
INSERT INTO kekNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nak ac xic re li Jesús sa' jalan chic na'ajej, quichal jun li cui̱nk sa' a̱nil, colxcuik'ib rib chiru ut quixye re: —At cha̱bil tzolonel, ¿c'a'ru ta̱ru̱k tinba̱nu re nak tincue̱chani li yu'am chi junelic?— ");
INSERT INTO kekNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Li Jesús quixye: —¿C'a'ut nak nacaye cha̱bil cue cui inc'a' nacanau anihin la̱in? Jun ajcui' li cha̱bil ut a'an li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","La̱at nacanau c'a'ru naxye li chak'rab: Matmuxuc caxa̱r. Ma̱camsi a̱cuas a̱cui̱tz'in. Mat-elk'ac. Matyo'oban a̱tin chirix a̱cuas a̱cui̱tz'in. Matbalak'ic. Cha-oxlok'i la̱ na' a̱yucua'.— ");
INSERT INTO kekNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nak quichak'oc li cui̱nk quixye: —At tzolonel, chixjunil a'in ac xinba̱nu ajcui' chak chalen sa' inca'ch'inal.— ");
INSERT INTO kekNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Li Jesús c'ajo' nak quixra li cui̱nk. Quixca'ya ut quixye re: —Jun chic toj ma̱ji' nacaba̱nu. Ayu, c'ayi chixjunil li c'a'ru cuan a̱cue ut ta̱si lix tz'ak reheb li neba' re nak ta̱cua̱nk a̱biomal sa' choxa. Nak ac xaba̱nu a'an, tatcha̱lk cuiq'uin ut tina̱ta̱ke usta ca̱mc ta̱c'ul sa' inc'aba', chan. ");
INSERT INTO kekNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nak quirabi a'an, li cui̱nk co̱ chi ra sa' xch'o̱l xban nak nabal lix biomal cuan. ");
INSERT INTO kekNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Li Jesús quirileb lix tzolom ut quixye reheb: —C'ajo' xch'a'ajquil chok' re junak biom re̱chaninquil lix nimajcual cuanquilal li Dios.— ");
INSERT INTO kekNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Lix tzolom que'sach xch'o̱leb nak que'rabi a'an. Aban li Jesús quixye cui'chic reheb: —Ex cualal inc'ajol, c'ajo' xch'a'ajquil nak te'oc sa' xnimajcual cuanquilal li Dios li neque'xic xch'o̱l chirix lix biomal. ");
INSERT INTO kekNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ma̱min ta̱ru̱k ta̱numek' junak nimla xul camello sa' ru junak cu̱x. Jo'can ajcui' eb li biom. Ma̱ jok'e ta̱ru̱k te'oc sa' xnimajcual cuanquilal li Dios cui ca'aj cui' lix biomal neque'xc'oxla.— ");
INSERT INTO kekNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Eb lix tzolom c'ajo' nak que'sach xch'o̱leb ut que'xye: —¿Ani put ta̱ru̱k ta̱colek' chi jo'canan?— ");
INSERT INTO kekNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Li Jesús quirileb ut quixye reheb: —Li cui̱nk inc'a' naru tixba̱nu a'an, aban li Dios ma̱c'a' ch'a'aj chiru. A'an naru tixba̱nu chixjunil.— ");
INSERT INTO kekNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Laj Pedro quixye re li Jesús: —La̱o xkacanab chixjunil li c'a'ru cuan ke xban a̱ta̱kenquil.— ");
INSERT INTO kekNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Li Jesús quixye: —Relic chi ya̱l tinye e̱re, li ani naxcanab c'a'ru re sa' inc'aba' la̱in, tixc'ul re̱kaj. Li ani naxcanab xna' xyucua', li ras ut li ri̱tz'in ut li ralal xc'ajol sa' inc'aba' la̱in malaj ut sa' xc'aba' li evangelio, a'an tixc'ul re̱kaj. Jo'can ajcui' li naxcanab xch'och' ut li rochoch sa' inc'aba' la̱in, tixc'ul ajcui' re̱kaj. ");
INSERT INTO kekNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","A'an tixc'ul o'takc'a̱l (100) chic chok' re̱kaj li c'a'ru re li tixcanab jo' rochoch, jo' li ras, jo' li ri̱tz'in, jo' li ralal xc'ajol, jo' xna' xyucua' ut jo' lix ch'och'. Usta naxc'ul ra xi̱c' arin sa' ruchich'och', abanan ta̱re̱chani li junelic yu'am sa' eb li cutan cha̱lel. ");
INSERT INTO kekNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Li cuanqueb xcuanquil anakcuan, ma̱c'a'ak chic xcuanquileb mokon. Ut li ma̱c'a'eb xcuanquil anakcuan, a'aneb chic li te'cua̱nk xcuanquil mokon,— chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nak yo̱queb chi xic Jerusalén c'amol be li Jesús chiruheb. Nak cuanqueb chiru be sachso̱queb xch'o̱l lix tzolom ut li yo̱queb chi ta̱ke̱nc reheb te'xucuak ajcui'. Tojo'nak li Jesús quixc'ameb cui'chic lix cablaju chi tzolom xjuneseb ut qui-oc chixyebal reheb li c'a'ru tixc'ul. ");
INSERT INTO kekNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Quixye reheb: —Q'uehomak retal. Anakcuan yo̱co chi xic Jerusalén. Aran tink'axtesi̱k la̱in li C'ajolbej sa' ruk'eb lix be̱nil aj tij jo' ajcui' sa' ruk'eb laj tz'i̱b. Eb a'an te'xteneb ca̱mc sa' inbe̱n ut tine'xk'axtesi sa' ruk'eb li ma̱cua'eb aj judío. ");
INSERT INTO kekNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ut tine'xhob, tine'xsac', tine'xchu̱ba ut tine'xcamsi. Aban sa' rox li cutan tincuacli̱k cui'chic chi yo'yo sa' xya̱nkeb li camenak.— ");
INSERT INTO kekNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Laj Jacobo ut laj Juan, eb li ralal laj Zebedeo, que'jiloc chixc'atk li Jesús ut que'xye re: —Ka̱cua', la̱o nakaj nak ta̱ba̱nu li usilal li takatz'a̱ma cha̱cuu.— ");
INSERT INTO kekNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ut li Jesús quixye reheb: —¿C'a'ru li usilal te̱raj tinba̱nu e̱re? chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Que'xye re: —Nak ac xat-oc sa' la̱ lok'al, nakatz'a̱ma cha̱cuu nak jun ke ta̱cua̱nk sa' la̱ nim ut jun ta̱cua̱nk sa' la̱ tz'e.— Que'xye chi jo'can xban nak te'raj oc sa' xcuanquileb. ");
INSERT INTO kekNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ut li Jesús quixye reheb: —La̱ex inc'a' nequenau xya̱lal li yo̱quex chixtz'a̱manquil chicuu. ¿Ma te̱cuy xc'ulbal li raylal li oc cue chixc'ulbal la̱in? Ut, ¿ma te̱cuy xnumsinquil li raylal jo' li tinc'ul la̱in?— ");
INSERT INTO kekNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—¡Takacuy! chanqueb. Ut li Jesús quichak'oc ut quixye: —Ya̱l ajcui' nak la̱ex te̱c'ul li raylal jo' li tinc'ul la̱in. Ut te̱cuy xnumsinquil li raylal jo' li tincuy xnumsinquil la̱in. ");
INSERT INTO kekNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Abanan li na'ajej sa' lin nim ut sa' lin tz'e ma̱cua' la̱in tinq'uehok re li na'ajej a'an, xban nak ac ch'olch'o chiru li Dios ani aj e li na'ajej a'an, chan li Jesús reheb. ");
INSERT INTO kekNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ut nak que'rabi li c'a'ru que'xpatz' laj Jacobo ut laj Juan, li laje̱b chic lix tzolom que'po' riq'uineb. ");
INSERT INTO kekNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ut li Jesús quixbokeb riq'uin ut quixye reheb: —La̱ex nequenau nak li neque'taklan sa' ruchich'och' neque'numta sa' xbe̱n li tenamit. Li ni̱nkeb xcuanquil, a'aneb li neque'taklan. ");
INSERT INTO kekNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Abanan ma̱cua' jo'can te̱ba̱nu la̱ex. Li ani naraj xcuanquil sa' e̱ya̱nk, tento nak tixcubsi rib ut ta̱c'anjelak che̱ru. ");
INSERT INTO kekNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Li ani naraj nima̱k xcuanquil sa' e̱ya̱nk, tento tixcubsi rib ut ta̱c'anjelak chiruheb li ras ri̱tz'in. ");
INSERT INTO kekNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","La̱in li C'ajolbej. Abanan inc'a' xinchal re nak te'c'anjelak chicuu. Xinchal ban re nak tinc'anjelak chiruheb chixjunileb ut chixq'uebal lin yu'am re xtojbal rix lix ma̱queb, chan li Jesús reheb. ");
INSERT INTO kekNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Que'cuulac Jericó ut nak qui-el chak li Jesús sa' li tenamit a'an rochbeneb lix tzolom nabal li tenamit que'ta̱ken re. Ut chunchu jun li mutz' chire be. Yo̱ chi lemoxnic. Lix xc'aba', a'an aj Bartimeo, ralal laj Timeo. ");
INSERT INTO kekNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nak quirabi li mutz' nak yo̱ chi cha̱lc li Jesús aj Nazaret, quixjap re chixyebal: —¡At Jesús, ralalat xc'ajol laj David, chacuuxta̱na taxak cuu! chan. ");
INSERT INTO kekNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ut nabaleb li tenamit que'k'usuc re ut que'xye re, —¡Matchokin! chanqueb re. Ut a'an k'axal cui'chic cau quixjap re ut quixye, —¡At ralalat xc'ajol laj David, chacuuxta̱na taxak cuu!— ");
INSERT INTO kekNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nak quirabi a'an li Jesús quixakli ut quixtakla xbokbal li mutz'. Que'co̱eb chixc'ambal ut que'xye re: —Ma̱ch'ina a̱ch'o̱l. Quim. Yo̱ cha̱bokbal li Ka̱cua'.— ");
INSERT INTO kekNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Li mutz' quirisi lix t'icr lanlo cui'. Quicuacli sa' junpa̱t ut co̱ riq'uin li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Li Jesús quixye re: —¿C'a'ru ta̱cuaj tinba̱nu a̱cue?— Ut li mutz' quixye: —Ka̱cua', tincuaj nak ta̱ilok li xnak' cuu.— ");
INSERT INTO kekNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Li Jesús quixye re: —Anakcuan naru tatxic. Xatq'uira xban nak xapa̱b nak cuan incuanquil cha̱q'uirtesinquil, chan re. Ut sa' junpa̱t qui-iloc li mutz' ut co̱ chirixeb. ");
INSERT INTO kekNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Que'nach'oc Jerusalén bar cuan cui' li cuib chi tenamit Betfagé ut Betania. Cuanqueb chiru li tzu̱l Olivos nak li Jesús quia̱tinac riq'uin cuibeb lix tzolom. ");
INSERT INTO kekNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Quixye reheb: —Ayukex sa' li ch'ina tenamit a'an, ut nak texcuulak, te̱tau jun li ch'ina bu̱r bac'bo. Li ch'ina bu̱r a'an toj ma̱ ani nabe̱c chirix. Te̱hit chak ut te̱c'am chak arin. ");
INSERT INTO kekNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ut cui ani nayehoc e̱re, “¿C'a'ru yo̱quex?”, te̱ye reheb nak li Ka̱cua' ta̱ajok re li ch'ina bu̱r ut a que ajcui' tixtakla chak ho̱n, cha'kex reheb.— ");
INSERT INTO kekNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Que'co̱eb ut que'xtau li ch'ina bu̱r bac'bo sa' be chire puerta. Ut que-oc chixhitbal. ");
INSERT INTO kekNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Eb li cuanqueb aran que'xye: —¿C'a'ru yo̱quex? ¿C'a'ut nak yo̱quex chixhitbal li ch'ina bu̱r?— ");
INSERT INTO kekNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Eb lix tzolom que'xye reheb li c'a'ru quixye li Jesús, ut eb a'an que'canaba̱c re nak te'xc'am li ch'ina bu̱r. ");
INSERT INTO kekNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Que'xc'am riq'uin li Jesús ut que'xq'ue li rak'eb chirix li ch'ina bu̱r ut li Jesús quitake' chirix. ");
INSERT INTO kekNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nabaleb que'xhel li rak'eb sa' be bar ta̱numek' cui' li Jesús. Cuan que'xyoc' chak ruk' che' ut que'xq'ue li xak sa' be. ");
INSERT INTO kekNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nak yo̱ chi xic li Jesús cuan li yo̱queb chi xic chiru ut cuan li yo̱queb chi xic chirix. Japjo̱queb re chixyebal: —¡Aj Colol ke taxak! ¡Osobtesinbil taxak li xchal sa' xc'aba' li Ka̱cua' Dios! ");
INSERT INTO kekNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Osobtesinbil taxak li tenamit ta̱takla̱nk cui' li xchal chok' re̱kaj laj David li kaxe'to̱nil yucua'. Aj Colol ke taxak li xchal chak riq'uin li Dios,— chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Nak quicuulac Jerusalén, li Jesús qui-oc sa' li rochoch li Dios. Quixsuti rilbal chixjunil li c'a'ak re ru cuan aran. Xban nak qui-ecuu co̱ aran Betania rochbeneb lix tzolom cablaju. ");
INSERT INTO kekNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Jo' cuulajak chic nak que'el aran Betania, quichal xtz'ocajic li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Toj najt ajcui' cuan chak nak quiril jun to̱n li che' higo ut co̱ chirilbal ma cuan ru. Nak quicuulac cuan cui' li che' quiril nak ma̱c'a' ru. Junes xak cuan xban nak toj ma̱ji' xk'ehil ta̱u̱chi̱nk. ");
INSERT INTO kekNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ut li Jesús quixye re li jun to̱n chi higo: —Ma̱ ani chic ta̱tzaca̱nk re li nacacuu̱chin xban nak ma̱ jun cua chic tatu̱chi̱nk, chan. Ut eb lix tzolom que'rabi li c'a'ru quixye. ");
INSERT INTO kekNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nak que'cuulac Jerusalén, li Jesús qui-oc sa' li rochoch li Dios. Quiril nak yo̱queb chi c'ayi̱nc ut yo̱queb chi lok'oc aran. Qui-oc chixyolesinquileb. Quixbalk'usi lix me̱xeb laj jalol tumin ut quixbalk'usi ajcui' lix temeb li yo̱queb chi c'ayi̱nc paloma. ");
INSERT INTO kekNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ut inc'a' chic quixcanabeb li tenamit chi numec' sa' rochoch li Dios chi cuan ri̱keb. ");
INSERT INTO kekNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ut qui-oc xch'olobanquil xya̱lal chiruheb ut quixye: —¿Ma inc'a' ta bi' tz'i̱banbil sa' li Santil Hu li c'a'ru quixye li Dios? “Li cuochoch, a'an re te'tijok cui' chixjunileb li tenamit.” Abanan la̱ex xeq'ue li rochoch li Dios chok' xna'ajeb laj e̱lk', chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Eb li xbe̱nil aj tij ut eb laj tz'i̱b nak que'rabi a'an que'oc chixc'u̱banquil chanru nak te'xcamsi li Jesús. C'ajo' nak que'xucuac xban nak que'ril nak sachso̱queb xch'o̱l li q'uila tenamit chirabinquil li tijleb li yo̱ chixyebal li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nak qui-ecuu, qui-el li Jesús sa' li tenamit Jerusalén rochbeneb lix tzolom. ");
INSERT INTO kekNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Jo' cuulajak chic nak que'nume' cuan cui' li xto̱nal li higo, que'ril nak ac xchakic chi junaj cua. ");
INSERT INTO kekNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ut laj Pedro quinak sa' xch'o̱l nak li Jesús quixtz'ekta̱na li che' ut quixye re: —Ka̱cua', il li che' li xatz'ekta̱na. Xchakic chi junaj cua.— ");
INSERT INTO kekNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ut li Jesús quixye reheb: —Chepa̱b nak nim xcuanquil li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Relic chi ya̱l tinye e̱re li ani tixye re junak tzu̱l, “Elen arin ut cut a̱cuib sa' li palau”, ut cui inc'a' tixcuiba xch'o̱l, ut cui tixpa̱b chi tz'akal nak ta̱uxk li tixye, ta̱uxma̱nk li c'a'ru tixye. ");
INSERT INTO kekNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jo'can nak tinye e̱re nak chixjunil li c'a'ru te̱tz'a̱ma chiru li Dios nak yo̱quex chi tijoc, chepa̱b chi tz'akal nak ta̱q'uehek' e̱re ut te̱c'ul li c'a'ru te̱tz'a̱ma. ");
INSERT INTO kekNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nak yo̱kex chi tijoc, checuy xma̱c li ani cuan xma̱c che̱ru re nak li kaYucua' li cuan sa' choxa tixcuy ajcui' e̱ma̱c la̱ex. ");
INSERT INTO kekNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ut cui inc'a' nequecuyeb xma̱c li cuanqueb xma̱c che̱ru, inc'a' ajcui' tixcuy e̱ma̱c la̱ex li kaYucua' li cuan sa' choxa, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Que'suk'i cui'chic aran Jerusalén. Nak yo̱ chi be̱c li Jesús sa' li rochoch li Dios que'cuulac li xbe̱nileb aj tij riq'uin. Ut que'cuulac laj tz'i̱b ut jo'can ajcui' li xakabanbileb chi c'anjelac sa' li rochoch li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Que'xye re li Jesús: —¿Ani xtaklan chak a̱cue chixba̱nunquil li c'a'ru yo̱cat chixba̱nunquil? Ut ¿ani xq'uehoc a̱cuanquil? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Li Jesús quixye: —La̱in tincuaj ajcui' patz'oc e̱re. Cui te̱sume li c'a'ru tinpatz' e̱re, la̱in tinye e̱re ani xq'uehoc incuanquil chixba̱nunquil li c'a'ru ninba̱nu. ");
INSERT INTO kekNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Ani quitaklan chak re laj Juan chi cubsi̱nc ha'? ¿Ma li Dios malaj ut cui̱nk quitaklan chak re? Yehomak cue anakcuan, chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ut que'oc chixyebal chi ribileb rib: —¿C'a'ru takasume cui'? Cui takaye nak li Dios xtaklan chak re, a'an tixye ke c'a'ut nak inc'a' xkapa̱b li c'a'ru quixye laj Juan. ");
INSERT INTO kekNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ut cui takaye nak cui̱nk xtaklan chak re, te'pok' li tenamit sa' kabe̱n, chanqueb. Eb a'an que'xxucua ru li tenamit xban nak chixjunileb neque'xnau nak laj Juan, a'an tz'akal profeta. ");
INSERT INTO kekNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ut eb a'an que'chak'oc ut que'xye re li Jesús: —La̱o inc'a' nakanau, chanqueb. Tojo'nak li Jesús quixye reheb: —Chi moco la̱in tinye e̱re ani quiq'uehoc incuanquil, chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Li Jesús qui-oc chixyebal li jaljo̱quil ru a̱tin reheb ut quixye chi jo'ca'in: Jun li cui̱nk quirau jun si̱r li racui̱mk uvas ut quixsut sa' corral. Quixyi̱b jun xna'aj bar te'xyatz' cui' li uvas ut quixyi̱b ajcui' jun ch'ina cab najt xteram re li ta̱c'ac'ale̱nk re li acui̱mk. Quixsiq'ueb laj ilol re li racui̱mk. Ut laj e̱chal re li acui̱mk co̱ sa' jalanil tenamit. ");
INSERT INTO kekNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nak quicuulac xk'ehil xsic'bal ru li acui̱mk, laj e̱chal re quixtakla jun lix mo̱s riq'uineb laj ilol re chixc'ulbal li ru li racui̱mk li jo' q'uial ta̱tz'ak a'an. ");
INSERT INTO kekNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","A'ut eb laj ilol re li acui̱mk que'xchap li mo̱s ut que'xsac'. Ut que'xtakla chi ma̱c'a' que'xq'ue re. ");
INSERT INTO kekNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Laj e̱chal re li acui̱mk quixtakla jun chic lix mo̱s riq'uineb. Ut que'xjor xjolom chi pec. K'axal ra que'xba̱nu re. ");
INSERT INTO kekNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ut laj e̱chal re quixtakla cui'chic jun lix mo̱s ut li jun a'an que'xcamsi. Ut toj nabal cui'chic lix mo̱s quixtakla riq'uineb laj ilol re li racui̱mk. Cuan yal que'xsac' ut cuan que'xcamsi. ");
INSERT INTO kekNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ca'aj chic li ralal quicana, li k'axal naxra. —Li cualal te'x-oxlok'i, chan sa' xch'o̱l. Jo'can nak quixtakla li ralal riq'uineb. ");
INSERT INTO kekNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nak quicuulac li ralal, eb laj ilol re li acui̱mk que'xye chi ribileb rib, —A'an li ralal li ta̱e̱chani̱nk re li na'ajej. Kacamsihak, chanqueb, ut la̱o chic toe̱chani̱nk re.— ");
INSERT INTO kekNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Jo'can nak que'xchap. Nak ac que'xcamsi que'xcut chak jun pac'al li ch'och'. ");
INSERT INTO kekNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ut li Jesús quixye reheb: —¿C'a'ru tixba̱nu laj e̱chal re li acui̱mk nak nequec'oxla la̱ex? Ta̱cha̱lk ut tixcamsiheb laj ilol re li racui̱mk, ut jalan chic aj e tixq'ue li jun si̱r chi uvas. ");
INSERT INTO kekNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Ma inc'a' xeril sa' li Santil Hu li naxye chi jo'ca'in? Li pec li que'xtz'ekta̱na laj cablanel, a'an li k'axal lok' li quiq'ueman chok' xxuc li cab. ");
INSERT INTO kekNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Li Ka̱cua' a'an quixq'ue xlok'al li pec. Ut a'an xsachba ch'o̱lej chok' ke la̱o.— (Sal. 118:22, 23) ");
INSERT INTO kekNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Eb laj tij ut eb laj tz'i̱b ut eb li xakabanbileb chi c'anjelac sa' rochoch li Dios que'xc'oxla raj xchapbal li Jesús re te'xq'ue sa' tz'alam xban nak que'xtau ru nak chirixeb a'an yo̱ chi a̱tinac nak quixye li jaljo̱quil ru a̱tin a'an. Abanan que'xucuac xbaneb li tenamit. Jo'can nak que'xcanab ut que'el sa' li na'ajej a'an. ");
INSERT INTO kekNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mokon chic que'xtakla riq'uin li Jesús cuib oxibeb laj fariseo rochbeneb cuib oxibeb li neque'oquen chirix laj Herodes re xsic'bil c'a'ru ta̱paltok cui' riq'uin li ra̱tin re nak te'xchap. ");
INSERT INTO kekNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Que'cuulac riq'uin li Jesús ut que'xye re: —At tzolonel, nakanau nak la̱at ya̱l nacat-a̱tinac ut inc'a' nacaxucua ruheb li tenamit. Yalak ani aj e nacaye lix ya̱lal. Ut nacac'ut chiruheb li c'a'ru naraj li Dios. Ye ke, ¿ma us xq'uebal li toj re li acuabej malaj ut inc'a'? ¿Ma takaq'ue malaj ut inc'a'? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Li Jesús naxnau nak aj ca'pac'aleb. Quixye reheb: —¿C'a'ut nak nequeraj xyalbal cuix? C'amomak chak li tumin. Cuilak, chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ut eb a'an que'xc'ut li tumin chiru. Ut li Jesús quixye reheb: —¿Ani aj e li jalam u̱ch li cuan chiru? Ut ¿ani aj c'aba' li tz'i̱banbil chiru?— Eb a'an que'chak'oc ut que'xye: —Re li acuabej, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ut li Jesús quixye reheb: —Tojomak re li acuabej li c'a'ru re li acuabej ut tojomak re li Dios li c'a'ru re li Dios, chan. Ut c'ajo' nak que'sach xch'o̱leb xban li ra̱tin. ");
INSERT INTO kekNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tojo'nak que'cuulac riq'uin li Jesús cuib oxib laj saduceo. Eb a'an inc'a' neque'xpa̱b nak te'cuacli̱k cui'chic chi yo'yo li camenak. Que'xye re li Jesús: ");
INSERT INTO kekNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—At tzolonel, laj Moisés quixtz'i̱ba jun kachak'rabinquil ut quixye chi jo'ca'in: Cui junak cui̱nk ta̱ca̱mk ut tixcanab li rixakil chi ma̱c'a' ralal xc'ajol, tento nak ta̱c'amek' li rixakil xban li ri̱tz'in li camenak re nak ta̱cua̱nk ralal xc'ajol sa' xc'aba' li camenak. ");
INSERT INTO kekNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Que'cuan cuukub li cui̱nk ri̱tz'ineb rib. Li asbej quixc'am rixakil ut quicam chi inc'a' quixcanab ralal xc'ajol. ");
INSERT INTO kekNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ut quic'ame' li ixk xban li i̱tz'inbej. Ut quicam ajcui' a'an chi inc'a' quixcanab ralal xc'ajol. Ut jo'can cui'chic li rox i̱tz'inbej. ");
INSERT INTO kekNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Li ixk a'an quic'ame' xbaneb li cuukub. Ut ma̱ jun reheb quixcanab ralal xc'ajol. Ut quicam ajcui' li ixk. ");
INSERT INTO kekNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Sa' xcuaclijiqueb li camenak chi yo'yo, nak te'cuacli̱k eb a'an, ¿ani aj ixakil ta̱cana̱k cui' li ixk a'an xban nak cuukub lix be̱lom quicuan? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Quichak'oc li Jesús ut quixye reheb: —La̱ex inc'a' nequetau xya̱lal xban nak inc'a' nequetau ru li Santil Hu chi moco lix nimal xcuanquil li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nak te'cuacli̱k chi yo'yo sa' xya̱nkeb li camenak, inc'a' chic te'sumla̱k chi moco te'sumuba̱k chic. Jo'keb ban chic li ángel sa' choxa. ");
INSERT INTO kekNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ut chirix lix cuaclijiqueb li camenak chi yo'yo, ¿ma inc'a' e̱rilom sa' lix hu laj Moisés li c'a'ru quiyehe' re xban li Dios nak quia̱tinac chak sa' li q'uix li yo̱ chi c'atc? Quixye chi jo'ca'in, “La̱in lix Dios laj Abraham, lix Dios laj Isaac ut lix Dios laj Jacob”, chan li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","A'an retalil chok' ke nak toj yo'yo̱queb chiru li Dios usta que'cam. Li Dios moco xDioseb ta li camenakeb; xDioseb ban li yo'yo̱queb. Jo'can nak la̱ex chi ti̱c inc'a' nequetau xya̱lal, chan li Jesús reheb. ");
INSERT INTO kekNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Quicuulac jun reheb laj tz'i̱b. Ut quirabi nak yo̱queb chixcuech'inquil ribeb. Quixq'ue retal nak li Jesús quixchak'beheb chi us, ut quixpatz' re li Jesús: —¿Bar cuan reheb li chak'rab li k'axal nim xcuanquil?— ");
INSERT INTO kekNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Li Jesús quichak'oc ut quixye re: —Li xbe̱n chak'rab, li k'axal nim xcuanquil, a'an a'in: Abihomak la̱ex aj Israel, li Ka̱cua' li kaDios jun ajcui'. ");
INSERT INTO kekNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ta̱ra li Ka̱cua' la̱ Dios chi anchal a̱ch'o̱l ut chi anchal la̱ cua̱m ut chi anchal la̱ c'a'ux ut chi anchal la̱ metz'e̱u. A'an a'in li chak'rab li k'axal nim xcuanquil. ");
INSERT INTO kekNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ut li xcab chanchan ajcui' a'an: Ta̱ra la̱ cuas a̱cui̱tz'in jo' nak nacara a̱cuib la̱at. Ma̱c'a' chic junak chak'rab nim xcuanquil chiruheb li cuib a'in, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Laj tz'i̱b quichak'oc ut quixye re: —Us li xaye at tzolonel. Ya̱l li xaye nak jun ajcui' li Dios cuan ut ma̱c'a' chic junak chirix a'an. ");
INSERT INTO kekNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Tento nak takara li Dios chi anchal li kach'o̱l, chi anchal li kac'a'ux, chi anchal li ka̱m ut chi anchal li kametz'e̱u. Ut takara li kas ki̱tz'in jo' nak nakara kib la̱o. A'an k'axal nim xcuanquil chiruheb chixjunil li c'atbil mayej ut li mayejanbil xul, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Li Jesús quixq'ue retal nak li cui̱nk quixnau xsumenquil ut quixye re: —Yal ca'ch'in aj chic ma̱ nacak'axtesi a̱cuib rubel xcuanquil li Dios, chan. Ut ma̱ jun chic que'raj patz'oc xban nak qui-oc xc'a'uxeb. ");
INSERT INTO kekNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Mokon chic nak cuan sa' rochoch li Dios, li Jesús yo̱ chixch'olobanquil li xya̱lal chiruheb ut quixye: —¿C'a'ut nak eb laj tz'i̱b neque'xye nak li Cristo, a'an xcomoneb li ralal xc'ajol laj David? ");
INSERT INTO kekNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Laj David quixye li c'a'ru quirec'a sa' xch'o̱l xban li Santil Musik'ej ut quixye chi jo'ca'in: Li Ka̱cua' Dios quixye re laj Colol cue, C'ojlan sa' lin nim uk' toj retal tinq'ueheb li xic' neque'iloc a̱cue rubel la̱ cuanquil. (Sal. 110:1) ");
INSERT INTO kekNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Li rey David quixye “aj Colol cue” re li Ka̱cua' usta a'an xcomoneb li ralal xc'ajol, chan li Jesús. Ut li q'uila tenamit que'rabi li ra̱tin chi sa sa' xch'o̱leb. ");
INSERT INTO kekNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Nak yo̱ chixch'olobanquil li xya̱lal chiruheb, li Jesús quixye: —Me̱tzol e̱rib riq'uineb laj tz'i̱b li neque'raj be̱c chi najt rok li rak'eb re xc'utbal nak cuanqueb xcuanquil. Eb a'an neque'cuulac chiruheb nak te'q'uehek' xlok'al sa' eb li be. ");
INSERT INTO kekNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ut nak cuanqueb sa' li cab li neque'xch'utub cui' ribeb laj judío, neque'raj c'ojla̱c sa' li na'ajej k'axal lok' ut neque'raj cua̱nc chi xjolomil li me̱x nak neque'xic chi cua'ac sa' junak nink'e. ");
INSERT INTO kekNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Neque'xmak' li c'a'ru cuan reheb li xma̱lca'an ut re xmukbal li ma̱usilal neque'xba̱nu, najt rok neque'tijoc chiruheb li tenamit. Ut xban a'an k'axal ra cui'chic te'xtoj cui' li ma̱c neque'xba̱nu.— ");
INSERT INTO kekNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Sa' jun cutan quicuulac li Jesús sa' rochoch li Dios. Quic'ojla chixc'atk lix ca̱xil li mayej. Yo̱ chirilbal li tenamit nak yo̱queb chixq'uebal li tumin sa' li ca̱x. Nabaleb li biom nabal lix mayej yo̱queb chixq'uebal. ");
INSERT INTO kekNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Quichal ajcui' jun xma̱lca'an neba'. Ut quixq'ue cuib chi tumin jo' tana li jun centavo. ");
INSERT INTO kekNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tojo'nak li Jesús quixbokeb lix tzolom ut quixye reheb: —Relic chi ya̱l tinye e̱re nak li xma̱lca'an neba' nabal xq'ue chiru li mayej li xe'xq'ue chixjunileb. ");
INSERT INTO kekNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Chixjunileb a'an xe'xq'ue li na-ela'an chiruheb. A'ut li ixk a'in sa' neba'il xq'ue chixjunil li jo' nimal cuan re.— ");
INSERT INTO kekNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nak qui-el chak li Jesús sa' rochoch li Dios, jun reheb lix tzolom quixye re: —At tzolonel, il, ma̱ c'ajo' xchak'al ru li cab a'in ut ma̱ c'ajo' xchak'al ru li pec yi̱banbil cui'.— ");
INSERT INTO kekNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Li Jesús quichak'oc ut quixye re: —Us ajcui' nak te̱ril chi us xban nak ta̱cuulak xk'ehil nak ma̱ jun chic li pec a'an ta̱cana̱k sa' xna'aj chi inc'a' ta ta̱juq'uek', chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Que'co̱eb sa' li tzu̱l Olivos sa' xca'yaba̱l li rochoch li Dios. Li Jesús quic'ojla aran ut nak cuan xjunes quipatz'e' re xbaneb laj Pedro, laj Jacobo, laj Juan ut laj Andrés. ");
INSERT INTO kekNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Ye ke jok'e ta̱c'ulma̱nk li yo̱cat chixyebal chirix li rochoch li Dios ut ¿c'a'ru retalil ta̱cua̱nk nak talajc'ulma̱nk li c'a'ak re ru a'in?— ");
INSERT INTO kekNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Li Jesús quichak'oc ut quixye: —Cheq'ue retal re nak ma̱ ani ta̱balak'i̱nk e̱re. ");
INSERT INTO kekNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nabal te'cha̱lk chi balak'i̱nc ut tole'xye, “La̱in li Cristo”, cha'keb. Ut nabal te'balak'i̱k xbaneb. ");
INSERT INTO kekNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nak te̱rabi nak yo̱ li ple̱t ut nak te̱rabi resil nak ticla̱c re li ple̱t yalak bar, mexxucuac xban nak tento nak ta̱c'ulma̱nk chi jo'can. Abanan moco ac a'an ta roso'jiqueb li cutan. ");
INSERT INTO kekNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nabal li tenamit te'pletik riq'uin jalan chic tenamit. Ut eb li acuabej te'xpleti ribeb. Talajcua̱nk hi̱c sa' nabal chi na'ajej ut ta̱cua̱nk cue'ej. Abanan a'an yal xticlajic li raylal ta̱cha̱lk. ");
INSERT INTO kekNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","A'ut la̱ex cheq'uehak retal li raylal ta̱cha̱lk sa' e̱be̱n. Texk'axtesi̱k chiruheb laj rakol a̱tin ut texsaq'uek' sa' li cab li neque'xch'utub cui' ribeb laj judío. Texc'amek' chiruheb li acuabej ut chiruheb li rey sa' inc'aba' la̱in ut ta̱ru̱k te̱ch'olob xya̱lal li cua̱tin chiruheb. ");
INSERT INTO kekNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tento nak xbe̱n cua ta̱sutu̱nk xch'olobanquil resilal li colba-ib chiruheb chixjunil li tenamit nak toj ma̱ji' na-oso' li ruchich'och'. ");
INSERT INTO kekNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ut nak texchapek' ut texk'axtesi̱k chiruheb li acuabej, mexc'oxlac chirix li c'a'ru te̱ye. Li c'a'ru te̱ye sa' li ho̱nal a'an ma̱cua' c'oxlanbil a̱tin li te̱ye. Aban li tixye e̱re li Santil Musik'ej, a'an li te̱ye. ");
INSERT INTO kekNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Eb li cui̱nk te'xk'axtesi chi camsi̱c li ras ri̱tz'in. Ut li yucua'bej tixk'axtesi li ralal. Ut li alalbej c'ajolbej te'xq'ue chi camsi̱c li na'bej yucua'bej. ");
INSERT INTO kekNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ut xic' tex-ilek' xbaneb chixjunileb sa' inc'aba' la̱in. Ut li tixcuy xnumsinquil li raylal a'in toj sa' roso'jic lix yu'am, a'an ta̱colek' xban li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Chetzolak rix chi us li c'a'ru quixye li profeta Daniel re nak te̱tau ru li c'a'ru ta̱c'ulma̱nk. A'an quixye nak eb laj balak' te'cha̱lk ut tole'xq'ue li k'axal yibru ut xucuajel rilbal sa' li rochoch li Dios li ma̱cua' xc'ulub cui' cua̱nc. Nak te̱ril nak yo̱queb chixmuxbal ru li rochoch li Dios, la̱ex li cuanquex Judea chex-e̱lelik sa' junpa̱t ut texxic toj sa' li tzu̱l. ");
INSERT INTO kekNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Cui cuan chak junak sa' xbe̱n li rochoch nak ta̱c'ulma̱nk a'an, chi cubec chak ut ti̱c ta̱e̱lelik ut inc'a' chic ta̱oc sa' rochoch chirisinquil li c'a'ru cuan re. ");
INSERT INTO kekNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Cui ani cuan chak sa' xc'aleba̱l inc'a' chic ta̱suk'i̱k sa' cab chixxocbal li rak'. ");
INSERT INTO kekNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","K'axal ra cui'chic li e̱lelic chok' reheb li yaj aj ixk ut li yo̱queb chi tu'resi̱nk sa' eb a cutan a'an. ");
INSERT INTO kekNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Chextijok ut chetz'a̱ma chiru li Dios re nak inc'a' ta̱c'ulma̱nk a raylal a'in sa' habalk'e. ");
INSERT INTO kekNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Sa' eb li cutan a'an ma̱ ca'ch'in li raylal ta̱cua̱nk. Ma̱ jun cua quic'ulman chi jo'can chalen chak sa' xticlajic nak li Dios quixyi̱b li ruchich'och', chi moco ta̱c'ulma̱nk chi jo'can mokon. ");
INSERT INTO kekNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Cui ta ma̱c'a' sa' xch'o̱l li Ka̱cua' xrakbaleb li cutan a'an ma̱ ani raj ta̱colek'. Abanan nim xrahom li Ka̱cua' sa' xbe̱neb li sic'bileb ru xban. Jo'can nak cuan sa' xch'o̱l li Ka̱cua' xrakbal eb li cutan a'an re nak te'colek'. ");
INSERT INTO kekNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Jo'can nak ani ta̱yehok e̱re, “Cue' li Cristo”, malaj, “le' cuan li Cristo”, me̱pa̱b li c'a'ru te'xye. ");
INSERT INTO kekNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Nabaleb aj balak' te'c'ulu̱nk ut te'xye nak a'aneb li Cristo. Ut cuan te'xye nak a'aneb li profeta. Nabal li c'a'ak re ru te'xc'utbesi ut sachba ch'o̱lej telaje'xba̱nu re xbalak'inquileb li sic'bileb ru xban li Dios. ");
INSERT INTO kekNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Abanan ac xinye e̱re li c'a'ru ta̱c'ulma̱nk. Jo'can nak me̱q'ue e̱rib chi balak'i̱c. ");
INSERT INTO kekNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ut sa' eb li cutan a'an nak ta̱c'ulma̱nk li raylal, ta̱k'ojyi̱nok' ru li sak'e ut li po inc'a' chic ta̱cutanok' ru. ");
INSERT INTO kekNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ta̱ec'a̱nk ru li choxa ut li chahim telaje't'anek'. ");
INSERT INTO kekNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nak acak x-ec'an ru li choxa, te'ril cuu la̱in li C'ajolbej nak yo̱kin chak chi cha̱lc sa' li chok riq'uin lix nimal incuanquil ut lin lok'al. ");
INSERT INTO kekNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Tojo'nak tintaklaheb lin ángel ut te'xch'utub li sic'bileb ru inban li cua̱nkeb yalak bar sa' chixjunil li ruchich'och'. ");
INSERT INTO kekNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Cheq'uehak retal c'a'ru naxba̱nu li jun to̱n chi higo. Nak nak'unk'ut chak li xak chi e̱lc, riq'uin a'an te̱nau nak yo̱ chak chi nach'oc li sak'ehil. ");
INSERT INTO kekNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Jo' nak li higo naxc'utbesi retalil li sak'ehil, jo'can ajcui' nak li raylal talaje'c'ulma̱nk tixc'utbesi retalil nak yo̱ chi cuulac xk'ehil nak toline̱lk cui'chic la̱in li C'ajolbej. ");
INSERT INTO kekNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Relic chi ya̱l tinye e̱re nak talaje'c'ulma̱nk chixjunil li c'a'ak re ru a'in nak toj ma̱ji' neque'oso' li tenamit a'in. ");
INSERT INTO kekNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Li choxa ut li ruchich'och' talaje'osok'. Abanan li c'a'ru ninye inc'a' ta̱cana̱k yal chi jo'can. Talajc'ulma̱nk ban chixjunil li c'a'ak re ru xinye. ");
INSERT INTO kekNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Abanan ma̱ ani nana'oc re jok'e ta̱cuulak xk'ehil li cutan a'an chi moco li ho̱nal jok'e ta̱c'ulma̱nk. Eb li ángel sa' choxa inc'a' neque'xnau chi moco la̱in li C'ajolbej ninna'oc re. Ca'aj cui' li Dios Acuabej nana'oc re jok'e ta̱c'ulma̱nk a'in. ");
INSERT INTO kekNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Jo'can nak yo'on cua̱nkex. Chexyo'lek ut chextijok xban nak inc'a' nequenau jok'e ta̱cuulak xk'ehil inc'ulunic. ");
INSERT INTO kekNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Chanchan jun li cui̱nk najt co̱ sa' xvia̱j. Toj ma̱ji' naxic nak quixq'ueheb xcuanquileb laj c'anjel chiru. Quixcanab xc'anjel li junju̱nk. Ut quixye re laj ilol cab nak junelic yo'on cua̱nk. ");
INSERT INTO kekNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Jo'can ajcui' la̱ex. Junelic yo'on cua̱nkex xban nak inc'a' nequenau jok'e ho̱nal tinc'ulu̱nk. Ma̱re tincha̱lk ecuu, malaj tuktu k'ojyi̱n, malaj ut nak naya̱bac laj tzo' xul malaj ut ek'ela. ");
INSERT INTO kekNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Yo'on cua̱nkex re nak inc'a' tolexintau chi cua̱rc xban nak inc'a' nequenau jok'e tinc'ulu̱nk. ");
INSERT INTO kekNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ut li c'a'ak re ru ninye e̱re la̱in, a'an ajcui' ninye reheb chixjunileb re nak yo'on cua̱nkeb, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Cuib cutan chic ma̱ nacuulac xk'ehil li nink'e re xjulticanquil li reliqueb laj Israel sa' li tenamit Egipto. Pascua nayeman re li nink'e a'an. A'an ajcui' xk'ehil li nink'e nak neque'xcua' li caxlan cua chi ma̱c'a' xch'amal. Sa' eb li cutan a'an eb lix be̱nil aj tij ut eb laj tz'i̱b yo̱queb chixsic'bal chanru nak te'xyo'ob a̱tin chirix li Jesús re nak te'xq'ue chi camsi̱c. ");
INSERT INTO kekNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ut que'xye chi ribileb rib: —Inc'a' takachap li Jesús nak yo̱k li nink'e xban nak te'pok' li tenamit kiq'uin ut te'oc chi pletic, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Li Jesús cuan aran Betania sa' rochoch laj Simón li saklep rix. Chunchu sa' me̱x nak quichal jun li ixk. Cuan chak jun ch'ina botella sununquil ban riq'uin. Lix na'aj li ban a'an yi̱banbil riq'uin cha̱bil pec alabastro xc'aba' ut li sununquil ban a'an nardo xc'aba' ut k'axal terto xtz'ak. Li ixk quixtok xcux li ch'ina botella ut quixq'ue li ban sa' xjolom li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Cuan li que'josk'o' ut que'xye chi ribileb rib: —¿C'a'ut nak xsach li sununquil ban a'an chi ma̱c'a' rajbal? ");
INSERT INTO kekNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Xru raj xc'ayiman chi numenak oxib ciento denarios (Q150) ut xkajeq'ui raj reheb li neba', chanqueb. Ut que'oc chixcuech'inquil li ixk. ");
INSERT INTO kekNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ut li Jesús quixye reheb: —¿C'a'ut nak yo̱quex chixch'i'ch'i'inquil li ixk? Canabomak xcuech'inquil xban nak us li xba̱nu cue. ");
INSERT INTO kekNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Li neba' junelic cuanqueb sa' e̱ya̱nk. Yalak jok'e naru te̱tenk'aheb. Abanan la̱in moco cua̱nkin ta junelic e̱riq'uin. ");
INSERT INTO kekNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Li ixk a'in xba̱nu li jo' q'uial xru xba̱nunquil. Ma̱ji' nincam abanan ac xinixban re lin mukbal. ");
INSERT INTO kekNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Relic chi ya̱l tinye e̱re nak ta̱yema̱nk resil li colba-ib yalak bar, ta̱yema̱nk ajcui' resil li c'a'ru xba̱nu li ixk a'in re xjulticanquil a'an, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ut laj Judas Iscariote, xcomoneb li cablaju, co̱ riq'uineb lix be̱nil aj tij chixyebal reheb nak tixk'axtesi li Jesús sa' ruk'eb. ");
INSERT INTO kekNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ut eb laj tij nak que'rabi a'an c'ajo' nak que'saho' sa' xch'o̱leb ut que'xyechi'i xtumin. Ut laj Judas quixsic' xya̱lal chanru nak tixk'axtesi li Jesús sa' ruk'eb. ");
INSERT INTO kekNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Sa' li xbe̱n cutan re li nink'e nak neque'xcua' li caxlan cua chi ma̱c'a' xch'amal, neque'xmayeja jun li carner. Li nink'e a'an re xjulticanquil li reliqueb laj Israel sa' li tenamit Egipto. Eb lix tzolom que'xye re li Jesús: —¿Bar ta̱cuaj takacauresi chak li na'ajej re ta̱tzaca cui' li mayejanbil xul? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Li Jesús quixye reheb cuib lix tzolom: —Ayukex sa' li tenamit. Aran te̱c'ul jun li cui̱nk yo̱ chak chixc'ambal jun cuc xha'. Te̱ta̱ke a'an. ");
INSERT INTO kekNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Bar ta̱oc a'an aran ajcui' tex-oc la̱ex. Ut te̱ye re laj e̱chal cab, “Chan laj tzolonel, ¿bar len cuan li na'ajej ta̱cua'ak cui' rochbeneb lix tzolom?” cha'kex re. ");
INSERT INTO kekNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ut a'an tixc'ut che̱ru jun nimla na'ajej takec' sa' xca' tasalil li cab. Ac yi̱banbil li na'ajej. Ut aran toxe̱cauresi li nink'e chok' ke, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Que'co̱eb sa' li tenamit ut qui-uxman jo' quixye li Jesús. Ut aran que'xcauresi li nink'e. ");
INSERT INTO kekNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nak qui-ecuu, quicuulac li Jesús rochbeneb lix tzolom. ");
INSERT INTO kekNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nak ac yo̱queb chi cua'ac sa' li me̱x, li Jesús quixye reheb lix tzolom, —Relic chi ya̱l tinye e̱re nak jun e̱re la̱ex ta̱k'axtesi̱nk cue sa' ruk'eb li xic' neque'iloc cue, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ut eb a'an que'raho' sa' xch'o̱leb ut eb li junju̱nk que'oc chixyebal re li Jesús: —¿Ma la̱in ta bi' tink'axtesi̱nk a̱cue, Ka̱cua'? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ut li Jesús quichak'oc ut quixye reheb: —Li ta̱k'axtesi̱nk cue, a'an jun e̱re la̱ex li yo̱ chixtz'abal lix caxlan cua cuochben sa' li sec'. ");
INSERT INTO kekNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Relic chi ya̱l la̱in li C'ajolbej tinc'ul li c'a'ru tz'i̱banbil chak retalil chicuix. Abanan raylal cuan sa' xbe̱n li cui̱nk li ta̱k'axtesi̱nk cue. K'axal us raj chok' re li cui̱nk a'an nak inc'a' ta quiyo'la.— ");
INSERT INTO kekNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ut nak yo̱queb chi cua'ac, li Jesús quixchap li caxlan cua. Quixbantioxi chiru li Dios, quixjachi, tojo'nak quixjeq'ui reheb lix tzolom. Ut quixye reheb: —Cua'inkex. A'an a'in intz'ejcual.— ");
INSERT INTO kekNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ut quixchap ajcui' li sec' re uc'ac ut quixbantioxi chiru li Dios, tojo'nak quixq'ue reheb ut chixjunileb que'uc'ac. ");
INSERT INTO kekNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ut li Jesús quixye reheb: —A'an a'in lin quiq'uel li ta̱hoyek' sa' xc'aba'eb chixjunileb ut a'an ta̱xakaba̱nk xcuanquil li Ac' Contrato. ");
INSERT INTO kekNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Relic chi ya̱l tinye e̱re nak inc'a' chic tincuuc' lix ya'al ru li uva toj ta̱cuulak xk'ehil nak tincuuc' cui'chic sa' lix nimajcual cuanquilal li Dios, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ut nak ac xe'rake' xbichanquil jun li bich, que'co̱eb sa' li tzu̱l Olivos. ");
INSERT INTO kekNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ut li Jesús quixye reheb: —Che̱junilex la̱ex ta̱ch'ina̱k le̱ ch'o̱l ut tine̱canab injunes chiru a k'ojyi̱n a'in xban nak jo'ca'in tz'i̱banbil retalil xbaneb li profeta: Tincanab chi camsi̱c laj ilol reheb li carner ut eb li carner te'xcha'cha'i ribeb. ");
INSERT INTO kekNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ut nak acak xincuacli cui'chic chi yo'yo sa' xya̱nkeb li camenak, la̱in xbe̱n cua tinxic che̱ru aran Galilea.— ");
INSERT INTO kekNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ut laj Pedro quixye re: —Usta chixjunileb tate'xcanab abanan la̱in inc'a' tatincanab.— ");
INSERT INTO kekNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ut li Jesús quichak'oc ut quixye re: —Relic chi ya̱l tinye a̱cue nak toj ma̱ji' naya̱bac xca' sut li tzo' xul nak la̱at ac xaye oxib sut nak inc'a' nacanau cuu.— ");
INSERT INTO kekNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ut laj Pedro quixye cui'chic chi cau: —Ma̱ jok'e tinye nak inc'a' ninnau a̱cuu usta tine'xcamsi a̱cuochben, chan. Ut jo'can que'xye chixjunileb lix tzolom. ");
INSERT INTO kekNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Li Jesús quicuulac rochbeneb lix tzolom sa' li na'ajej Getsemaní xc'aba'. Li Jesús quixye reheb lix tzolom: —Cana̱kex arin. Xic cue chi tijoc la̱in.— ");
INSERT INTO kekNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ut quixc'am oxib lix tzolom chirix. A'aneb laj Pedro, laj Jacobo ut laj Juan. Ut c'ajo' nak qui-oc chi yot'ec' xch'o̱l li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Quixye reheb lix tzolom: —Cuan jun raylal sa' inch'o̱l yo̱ chinyot'bal. La̱in nacuec'a nak inc'a' chic tincuy. Cana̱kex arin ut yo'lenkex.— ");
INSERT INTO kekNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ut li Jesús quibe̱c chic ca'ch'in ut quixcuik'ib rib sa' ch'och' ut qui-oc chi tijoc ut quixtz'a̱ma re li Ka̱cua' Dios ut quixye: —Cui ta tixq'ue rib, inc'a' raj tinc'ul li raylal a'in.— ");
INSERT INTO kekNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ut quixye ajcui': —At inYucua', la̱in ninnau nak chixjunil naru xba̱nunquil cha̱cuu. Cui ta naru inc'a' raj tinc'ul li raylal a'in. Abanan chi-uxma̱nk li c'a'ru nacacuaj la̱at ut ma̱cua' li nacuaj la̱in.— ");
INSERT INTO kekNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ut nak quisuk'i chak li Jesús, quixtauheb chi cua̱rc lix tzolom. Ut quixye re laj Pedro: —At Simón, ¿ma yo̱quex chi cua̱rc? ¿Ma inc'a' xru xexyo'lec jun o̱rak cuochben? ");
INSERT INTO kekNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Chexyo'lek ut chextijok re nak inc'a' te̱q'ue e̱rib chi a̱le̱c. La̱ex nequeraj raj xba̱nunquil li us, abanan e̱junes inc'a' texru̱k.— ");
INSERT INTO kekNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ut li Jesús co̱ cui'chic chi tijoc ut quixtz'a̱ma cui'chic sa' lix tij nak inc'a' raj tixc'ul li raylal. ");
INSERT INTO kekNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ut nak quisuk'i cui'chic li Jesús quixtauheb cui'chic chi cua̱rc lix tzolom xban nak ma̱ ca'ch'in lix cuaraheb. Ut eb a'an inc'a' chic neque'xtau c'a'ru te'xye. ");
INSERT INTO kekNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ut quisuk'i cui'chic sa' rox sut, coxtauheb cui'chic chi cua̱rc ut quixye reheb: —¿Ma toj yo̱quex ajcui' chi cua̱rc? Tz'akalak li hila̱nc xeba̱nu. Ac xtau xk'ehil nak la̱in li C'ajolbej tink'axtesi̱k sa' ruk'eb laj ma̱c. ");
INSERT INTO kekNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Cuaclinkex anakcuan, ut yo'keb chixc'ulbal li yo̱ chi cha̱lc chi k'axtesi̱nc cue, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Toj yo̱ ajcui' chi a̱tinac li Jesús riq'uineb lix tzolom nak quicuulac laj Judas. A'an jun reheb li cablaju. Nabal que'chal rochben laj Judas taklanbileb chak xbaneb li xbe̱nil aj tij ut xbaneb laj tz'i̱b. Taklanbileb ajcui' xbaneb laj c'amol be sa' li rochoch li Dios. Cuanqueb xch'i̱ch' ut cuanqueb xche'. ");
INSERT INTO kekNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ut laj Judas quixye reheb nak tixq'ue jun retalil chanru nak tixk'axtesi li Jesús. Ac quixye reheb: —Li ani tincuutz' ru, a'an li te̱chap ut te̱c'am.— ");
INSERT INTO kekNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ut nak quicuulac laj Judas quijiloc chixc'atk, ut quixye: —At Ka̱cua',— ut quirutz' ru. ");
INSERT INTO kekNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ut eb a'an que'xchap li Jesús re nak te'xc'am riq'uin laj rakol a̱tin. ");
INSERT INTO kekNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ut jun reheb li rochben li Jesús quirisi chak lix ch'i̱ch' ut quixch'ot lix xic lix mo̱s li xyucua'ileb aj tij. ");
INSERT INTO kekNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ut li Jesús quixye reheb li tenamit: —¿Ma la̱in ta bi' aj e̱lk' nak xexchal chinchapbal riq'uin che' ut riq'uin ch'i̱ch'? ");
INSERT INTO kekNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Rajlal cutan cuanquin sa' e̱ya̱nk che̱tzolbal sa' rochoch li Dios ut inc'a' quine̱chap. Abanan xc'ulman chi jo'ca'in re nak ta̱tz'aklok ru li tz'i̱banbil sa' li Santil Hu,— chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ut chixjunileb lix tzolom que'e̱lelic ut que'xcanab xjunes li Jesús sa' ruk'eb li xic' neque'iloc re. ");
INSERT INTO kekNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jun li al yo̱ chi ta̱ke̱nc re li Jesús lanlo sa' xt'icr. A'an que'xchap raj. ");
INSERT INTO kekNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Abanan a'an quie̱lelic chiruheb. Quicana lix t'icr sa' ruk'eb ut quie̱lelic chi t'ust'u. ");
INSERT INTO kekNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tojo'nak que'xc'am li Jesús riq'uin lix yucua'ileb aj tij ut que'ch'utla chixjunileb lix be̱nil aj tij. Ut que'ch'utla ajcui' eb laj c'amol be sa' rochoch li Dios ut eb laj tz'i̱b. ");
INSERT INTO kekNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ut laj Pedro chi najt yo̱ chixta̱kenquil li Jesús ut quicuulac toj chi ru'uj neba̱l sa' rochoch lix yucua'il eb aj tij ut aran quic'ojla chire xam chi k'ixi̱nc rochbeneb laj c'ac'alenel. ");
INSERT INTO kekNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Eb li xbe̱nil aj tij ut li neque'tz'iloc a̱tin yo̱queb chixsic'bal chanru nak te'xyo'ob junak a̱tin chirix li Jesús re nak te'xq'ue chi camsi̱c. Abanan inc'a' que'xtau. ");
INSERT INTO kekNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nabal li que'yo'oban tic'ti' chirix ut inc'a' natukla ru li ra̱tineb xban nak jalan jala̱nk neque'xye li junju̱nk. ");
INSERT INTO kekNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Cuan li que'xakli chixyebal li yo'obanbil a̱tin chirix. ");
INSERT INTO kekNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Ut que'xye: —La̱o quikabi nak quixye, “La̱in tinjuc' li rochoch li Dios li yi̱banbil xbaneb li cui̱nk, ut la̱in chiru oxib cutan tinyi̱b jun chic, aban ma̱cua' yi̱banbil xbaneb li cui̱nk.” Jo'can quixye li cui̱nk a'in, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Abanan inc'a' nach'ola ru li ra̱tineb xban nak jalan jala̱nk neque'xye li junju̱nk. ");
INSERT INTO kekNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ut li xyucua'ileb aj tij quixakli sa' xya̱nkeb ut quixye re li Jesús, —¿Ma ma̱c'a' nacaye la̱at chirix li yo̱queb chixyebal cha̱cuix?— ");
INSERT INTO kekNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ut li Jesús ma̱ jun a̱tin quixye. Ut li xyucua'ileb aj tij quixpatz' cui'chic re li Jesús ut quixye re: —¿Ma la̱at li Cristo li Ralal li nimajcual Dios? chan re. ");
INSERT INTO kekNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ut li Jesús quixye: —La̱in. Ut sa' jun cutan tine̱ril la̱in li C'ajolbej nak c'ojc'o̱kin sa' xnim uk' li nimajcual Dios ut te̱ril ajcui' nak yo̱kin chak chi cha̱lc sa' li chok sa' choxa, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nak quirabi li quixye li Jesús, li xyucua'il eb aj tij quixpej li rak' xban xjosk'il ut quixye: —¿C'a' chic ru aj e nak toj te'xye ke c'a'ru xma̱c? ");
INSERT INTO kekNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ac xerabi nak xjuntak'e̱ta rib riq'uin li Dios. ¿C'a'ru nequeye? ¿Ma cuan xma̱c malaj ut inc'a'? chan. Ut chixjunileb que'xye nak cuan xma̱c re camsi̱c. ");
INSERT INTO kekNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Cuan li yo̱queb chi chu̱ba̱nc re ut cuan ajcui' que'tz'apoc re li ru li Jesús riq'uin t'icr re nak inc'a' ta̱ilok, ut que'xsac' ut que'xye re: —Ye ke ani xsac'oc a̱cue, chanqueb. Tojo'nak que'xk'axtesi sa' ruk'eb laj c'ac'alenel pre̱x ut eb a'an que'xsac' cui'chic. ");
INSERT INTO kekNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ut nak cuan laj Pedro tak'a chi ru'uj neba̱l, quicuulac jun li ixk, xmo̱s li xyucua'il eb aj tij. ");
INSERT INTO kekNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ut li ixk a'an quiril laj Pedro nak yo̱ chi k'ixi̱nc chire li xam. Quixca'ya ut quixye re: —La̱at xat-ochbenin re li Jesús aj Nazaret, chan re laj Pedro. ");
INSERT INTO kekNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ut nak quichak'oc laj Pedro, quitic'ti'ic ut quixye: —¿Ani nacaye? La̱in inc'a' ninnau ru ani li nacaye.— Ut laj Pedro qui-el chire li oqueba̱l ut li tzo' xul quiya̱bac. ");
INSERT INTO kekNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ut li ixk nak quiril cui'chic laj Pedro, qui-oc chixyebal reheb li cuanqueb aran: —Li cui̱nk a'in, a'an jun reheb lix tzolom li Jesús, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ut laj Pedro quitic'ti'ic cui'chic. Ut ac junpa̱t na chic nak eb li cuanqueb aran que'xye cui'chic re laj Pedro: —Ya̱l. La̱at xcomoneb xban nak la̱ cua̱tinoba̱l nac'utuc re nak la̱at aj Galilea.— ");
INSERT INTO kekNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ut laj Pedro qui-oc chi majecua̱nc ut quixye: —Cutan saken chiru li Dios nak inc'a' ninnau ru li cui̱nk li nequeye. Cui tic'ti' li yo̱quin chixyebal, chinixtz'ekta̱na̱k li Dios, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tojo'nak quiya̱bac cui'chic xca' sut li tzo' xul. Ut quinak sa' xch'o̱l laj Pedro li a̱tin quiyehe' re xban li Jesús, “Nak toj ma̱ji' naya̱bac xca' sut li tzo' xul, la̱at ac xaye oxib sut nak inc'a' nacanau cuu”. Nak quijultico' re laj Pedro li a̱tin a'in, c'ajo' nak quiraho' sa' xch'o̱l ut qui-oc chi ya̱bac. ");
INSERT INTO kekNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nak quisake̱u eb lix be̱nil aj tij que'xch'utub cui'chic rib riq'uineb laj c'amol be sa' rochoch li Dios, ut riq'uineb laj tz'i̱b ut riq'uin chixjunileb laj q'uehol na'leb ut que'xc'u̱b chanru te'xba̱nu. Ut que'xc'am li Jesús chi bac'bo ut que'xk'axtesi sa' ruk' laj Pilato. ");
INSERT INTO kekNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Laj Pilato quixye re li Jesús: —¿Ma la̱at lix reyeb laj judío?— Li Jesús quichak'oc ut quixye re: —Ya̱l li xaye nak la̱in.— ");
INSERT INTO kekNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ut eb lix be̱nil aj tij nabal li c'a'ak re ru yo̱queb cui' chixjitbal. ");
INSERT INTO kekNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ut laj Pilato quixpatz' cui'chic re: —¿Ma inc'a' nacatchak'oc? ¿Ma inc'a' nacacuabi li jo' q'uial yo̱queb chixyebal cha̱cuix? chan laj Pilato re. ");
INSERT INTO kekNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Aban li Jesús ma̱ jun a̱tin quixye re xcolbal rib ut riq'uin a'an quisach xch'o̱l laj Pilato. ");
INSERT INTO kekNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Rajlal chihab sa' li nink'e Pascua laj Pilato narach'ab jun li pre̱x, a' ya̱l bar cuan te'raj li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Jun li cui̱nk aj Barrabás xc'aba' cuan sa' tz'alam rochbeneb lix comon xban li camsi̱nc que'xba̱nu nak yo̱queb chi pletic chirix li acuabej. ");
INSERT INTO kekNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ut que'chal li q'uila tenamit riq'uin laj Pilato chixtz'a̱manquil chiru nak ta̱rach'ab junak pre̱x jo' c'aynakeb xba̱nunquil. ");
INSERT INTO kekNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Laj Pilato quichak'oc ut quixye reheb: —¿Ma te̱raj nak tincuach'ab lix reyeb laj judío?— ");
INSERT INTO kekNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Laj Pilato naxnau nak xban xcakaleb xch'o̱l lix be̱nil aj tij nak que'xk'axtesi li Jesús sa' rakleb a̱tin. ");
INSERT INTO kekNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Aban eb lix be̱nil aj tij que'xtacchi'i li q'uila tenamit re nak a' laj Barrabás li te'xtz'a̱ma re nak ta̱ach'aba̱k. ");
INSERT INTO kekNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ut laj Pilato quixpatz' cui'chic reheb: —¿C'a'ru nequeye? ¿C'a'ru te̱raj tinba̱nu riq'uin lix reyeb laj judío?— ");
INSERT INTO kekNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ut eb li q'uila tenamit que'xjap cui'chic re chixyebal: —¡Q'ue chiru cruz! chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","A'ut laj Pilato quixpatz' cui'chic reheb: —¿C'a'ut? ¿C'a'ru tz'akal xma̱c e̱re? chan. Ut eb a'an k'axal cui'chic cau que'xjap re chixyebal: —¡Q'ue chiru cruz!— ");
INSERT INTO kekNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ut laj Pilato ta̱raj nak sahakeb sa' xch'o̱l li tenamit riq'uin. Jo'can nak quirach'ab laj Barrabás chiruheb. Tojo'nak quixtakla xsac'bal li Jesús riq'uin tz'u̱m ut quixk'axtesi sa' ruk'eb li soldado re nak te'xq'ue chiru cruz. ");
INSERT INTO kekNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ut eb li soldado que'xc'am li Jesús sa' li po̱pol ut que'xch'utub ribeb chixjunileb li soldado. ");
INSERT INTO kekNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Que'xq'ue jun caki ak' chirix li Jesús jo' neque'rocsi li rey. Ut que'xq'ue ajcui' jun tz'ulbil corona q'uix sa' xjolom. ");
INSERT INTO kekNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tojo'nak que'oc chixjapbal reheb chixyebal: —Sahak taxak sa' a̱ch'o̱l, at xReyeb laj judío, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ut yo̱queb chixsaq'uinquil sa' xjolom riq'uin che'. Cuan que'chu̱ban re ut cuan ajcui' que'xcuik'ib ribeb chiru re retz'unquil. ");
INSERT INTO kekNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ut nak ac que'xtacuasi, que'risi li caki ak' chirix ut que'xq'ue cui'chic li rak' chirix. Tojo'nak que'xc'am re te'xq'ue chiru cruz. ");
INSERT INTO kekNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jun li cui̱nk aj Simón xc'aba' yo̱ chi cha̱lc sa' c'aleba̱l. Cirene lix tenamit. Li cui̱nk a'an xyucua' laj Alejandro ut laj Rufo. Eb li soldado que'xmin ru laj Simón chixpakonquil lix cruz li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Que'xc'am li Jesús sa' li na'ajej Gólgota xc'aba'. Chi jalbil ru naraj naxye: Xna'aj Xbakel Xjolom Camenak. ");
INSERT INTO kekNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ut que'xq'ue vino re li Jesús yubil riq'uin c'ahil ban re xc'osbal li raylal aban li Jesús inc'a' quiruc'. ");
INSERT INTO kekNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tojo'nak que'xq'ue chiru cruz. Ut eb li soldado que'bu̱lic chirix li rak' re rilbal ani na ta̱e̱chani̱nk re li junju̱nk. ");
INSERT INTO kekNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Bele̱b o̱r re ek'ela que'xq'ue li Jesús chiru cruz. ");
INSERT INTO kekNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Sa' xbe̱n li cruz que'xq'ue jun retalil c'a'ut nak que'xcamsi ut naxye: A'an a'in lix reyeb laj judío. ");
INSERT INTO kekNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ut cuib laj e̱lk' que'q'uehe' chiru cruz rochben, jun sa' xnim uk' ut jun sa' xtz'e. ");
INSERT INTO kekNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Jo'can nak quitz'akloc ru li naxye sa' li Santil Hu: A'an quiq'uehe' sa' ajl sa' xya̱nkeb laj ma̱c. (Is. 53:12) ");
INSERT INTO kekNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ut eb li tenamit nak que'nume' aran que'xhob li Jesús. Que'rec'asi xjolomeb ut que'xye: —La̱at pe' xatjuc'uc raj re rochoch li Dios, ut yal chiru oxib cutan raj xayi̱b cui'chic. ");
INSERT INTO kekNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Col a̱cuib anakcuan ut cuben chak chiru li cruz, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Jo'can ajcui' que'xba̱nu eb li xbe̱nil aj tij. Que'xhob li Jesús nak que'xye chi ribileb rib rochbeneb laj tz'i̱b: —Jalan chic xcoleb ut a'an inc'a' naru naxcol rib xjunes. ");
INSERT INTO kekNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Chicubek chak chiru li cruz anakcuan li Cristo lix Reyeb laj judío re nak takil ut takapa̱b, chanqueb. Ut eb li que'q'uehe' chiru cruz rochben que'xhob ajcui' li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tuktu li cua'leb nak quik'ojyi̱no' sa' chixjunil li ruchich'och' ut oxib o̱r re ecuu quicutano' cui'chic. ");
INSERT INTO kekNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ut sa' li o̱r a'an li Jesús quia̱tinac chi cau ut quixye: —Eloi, Eloi, ¿lama sabactani?— Chi jalbil ru naraj naxye, “At inDios, at inDios, ¿c'a'ut nak xina̱canab injunes?” ");
INSERT INTO kekNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nak li cuanqueb aran que'rabi li ra̱tin, cuan li que'xye: —Abihomak, yo̱ chixbokbal li profeta Elías,— chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ut jun sa' xya̱nkeb co̱o sa' a̱nil ut coxtz'a chak jun li esponja sa' vinagre ut quixtaksi sa' ru'uj jun che' re xq'uebal chi ruc' li Jesús ut quixye: —Kilak cuan ma ta̱cha̱lk na laj Elías chixcubsinquil, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","A'ut li Jesús quixjap re chi cau ut qui-el xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ut lix t'icrul li rochoch li Dios quik'iche', ut lix pejelal quiticla chak takec' ut toj tak'a coxrake'. Ca' jachal qui-el. ");
INSERT INTO kekNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jun li capitán aj Roma cuan aran xakxo chiru li Jesús. Nak quiril chanru nak quicam, li capitán quixye: —Ya̱l nak li cui̱nk a'in tz'akal Ralal li Dios.— ");
INSERT INTO kekNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Cuanqueb ajcui' ixk yo̱queb chi iloc chi najt. Sa' xya̱nkeb a'an cuan lix María aj Magdala, lix Salomé ut lix María xna'eb laj José ut laj Jacobo li i̱tz'inbej. ");
INSERT INTO kekNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Eb li ixk a'in, a'an li que'ta̱ken re li Jesús nak toj cuan chak Galilea ut que'c'anjelac chiru. Ut cuanqueb nabal chic li ixk cuotz que'cuulac Jerusalén rochben li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nak ac oc re li k'ojyi̱n, ac nach'oc chak re li hiloba̱l cutan. Yo̱queb chixcauresinquil ribeb re li hiloba̱l cutan. ");
INSERT INTO kekNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Quicuan jun li cui̱nk aj José xc'aba' Arimatea xtenamit. A'an jun xnimal ru cui̱nk sa' xya̱nkeb li neque'tz'iloc a̱tin ut yo̱ chixyo'oninquil lix nimal xcuanquil li Dios. Inc'a' quixucuac laj José nak quicuulac chixtz'a̱manquil chiru laj Pilato nak a'an ta̱mukuk re lix tz'ejcual li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Laj Pilato quisach xch'o̱l chirabinquil nak ac xcam li Jesús. Ut quixtakla xbokbal li capitán ut quixpatz' re: —¿Ma ya̱l nak ac xcam li Jesús? chan re. ");
INSERT INTO kekNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Li capitán quixye re nak ac xcam. Tojo'nak laj Pilato quixye re laj José nak naru tixc'am. ");
INSERT INTO kekNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ut laj José quixlok' jun cha̱bil t'icr lino. Quixcubsi chak li camenak chiru li cruz ut quixlan sa' li cha̱bil t'icr. Ut quixq'ue sa' jun mukleba̱l yi̱banbil sa' jun sako̱nac. Ut quixbalk'usi jun nimla pec chire li mukleba̱l. ");
INSERT INTO kekNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ut lix María aj Magdala ut lix María xna' laj José que'ril bar quixmuk. ");
INSERT INTO kekNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nak quinume' li hiloba̱l cutan, lix María aj Magdala ut lix Salomé ut lix María xna' laj Jacobo que'xlok' li sununquil ban re te'xic chixq'uebal sa' xbe̱n li camenak. ");
INSERT INTO kekNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Toj ek'ela que'co̱eb sa' li xbe̱n li cutan re li xama̱n. Ac x-el chak li sak'e nak yo̱queb chi xic sa' li mukleba̱l. ");
INSERT INTO kekNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ut yo̱queb chixyebal chi ribileb rib: —¿Ani ta̱isi̱nk re li pec li cuan chire li mukleba̱l? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ut nak que'cuulac cuan cui' li mukleba̱l, que'ril nak ac isinbil chic li nimla pec chire li mukleba̱l. ");
INSERT INTO kekNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ut nak que'oc sa' li mukleba̱l que'ril jun li sa̱j cui̱nk chunchu chak sa' li mukleba̱l sa' xnim uk'eb. Li sa̱j cui̱nk a'an tikto riq'uin jun saki t'icr nim xbas ut eb li ixk c'ajo' nak que'xucuac chirilbal. ");
INSERT INTO kekNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ut li cui̱nk quixye reheb: —Mexxucuac. La̱in ninnau nak yo̱quex chixsic'bal li Jesús aj Nazaret li que'xcamsi chiru cruz. A'an ma̱ ani chic arin. Ac xcuacli cui'chic chi yo'yo. Ilomak lix na'aj li xcuan cui' li camenak. ");
INSERT INTO kekNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ayukex, yehomak chak reheb lix tzolom, jo' ajcui' re laj Pedro, nak a'an xbe̱n cua ta̱xic Galilea che̱ru la̱ex. Aran toxe̱ril ru jo' quixye e̱re, chan. ");
INSERT INTO kekNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ut eb li ixk que'el aran ut que'co̱eb sa' a̱nil ut neque'sicsot xbaneb xxiu. Ut ma̱ ani aj e que'xye xban nak te'xucuak. ");
INSERT INTO kekNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Toj ek'ela sa' li xbe̱n li cutan re li xama̱n quicuacli li Jesús chi yo'yo sa' xya̱nkeb li camenak. Li xbe̱n li quixc'utbesi cui' rib li Jesús, a'an lix María aj Magdala. A'an li ixk li qui-isi̱c li cuukub chi ma̱us aj musik'ej riq'uin xban li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Li ixk a'an co̱ chixyebal reheb lix tzolom li Jesús. Nak quicuulac riq'uineb, coxtauheb chi ya̱bac xban xrahil xch'o̱leb. ");
INSERT INTO kekNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ut lix María quixserak'i reheb nak yo'yo li Jesús ut nak quiril ru. Abanan eb a'an inc'a' que'xpa̱b li c'a'ru quixye. ");
INSERT INTO kekNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ut chirix a'an, li Jesús quixc'utbesi cui'chic rib chiruheb cuib lix tzolom nak yo̱queb chi xic sa' c'aleba̱l. Jalan chic rilbal nak quixc'utbesi rib chiruheb. ");
INSERT INTO kekNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Eb a'an que'co̱eb ut coxe'xye resil reheb li jun ch'ol chic. Ut chi moco li cuib a'an que'xpa̱b. ");
INSERT INTO kekNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mokon chic eb li junlaju chi xtzolom cuanqueb sa' me̱x nak quixc'utbesi rib li Jesús chiruheb. Ut quixk'useb xban nak inc'a' que'pa̱ban ut xban xcacuil lix ch'o̱leb. Inc'a' que'xpa̱b li c'a'ru que'xye li que'iloc ru li Jesús xbe̱n cua nak ac xcuacli cui'chic chi yo'yo sa' xya̱nkeb li camenak. ");
INSERT INTO kekNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ut li Jesús quixye reheb: —Texxic sa' chixjunil li ruchich'och' ut te̱ch'olob xya̱lal li colba-ib chiruheb chixjunileb li tenamit jun sut rubel choxa. ");
INSERT INTO kekNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Li ani ta̱pa̱ba̱nk ut ta̱cube̱k xha', a'an ta̱colek'; a'ut li ani inc'a' ta̱pa̱ba̱nk, a'an ta̱xic sa' tojba ma̱c. ");
INSERT INTO kekNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","A'an a'in li retalil li talaje'xba̱nu li te'pa̱ba̱nk. Sa' inc'aba' la̱in te'isi̱nk ma̱us aj musik'ej ut te'a̱tinak sa' jalan a̱tinoba̱l. ");
INSERT INTO kekNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Cui te'xchap c'anti' chi ruk'eb, ma̱c'a' te'xc'ul ut cui te'ruc' li c'a'ak re ru nacamsin, ma̱c'a' te'xc'ul. Cui te'xq'ue li ruk' sa' xbe̱neb li yaj, te'q'uira̱k, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nak ac xra̱tinaheb lix tzolom li Ka̱cua' Jesucristo, quic'ame' sa' choxa xban li Dios, ut quic'ojla sa' xnim uk' li Acuabej Dios. ");
INSERT INTO kekNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ut eb lix tzolom que'co̱eb sa' chixjunil li na'ajej chixch'olobanquil xya̱lal li colba-ib. Ut li Ka̱cua' yo̱ chi tenk'a̱nc reheb. Ut q'uebil xcuanquil li ra̱tineb xban li Dios riq'uin li milagro quilaje'xba̱nu chiruheb li tenamit. Jo'can taxak.");
INSERT INTO kekNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nabaleb li que'yaloc re xtz'i̱banquil chi tz'akal re ru chanru lix na'leb li Jesucristo nak quicuan sa' kaya̱nk. ");
INSERT INTO kekNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Li que'c'utuc chak chiku, a'an eb li tz'akal que'iloc chak re riq'uin xnak'eb ru chanru quic'ulman chalen nak quixtiquib chak lix c'anjel ut que'xch'olob li xya̱lal. ");
INSERT INTO kekNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","At Ka̱cua' Teófilo, la̱at cuan a̱cuanquil. Nak ac xintz'ili rix chi us chixjunil li c'a'ru quic'ulman, xinc'oxla nak us tintz'i̱bak a̱cuiq'uin re xyebal a̱cue chi tz'akal re ru chanru tz'akal quic'ulman. ");
INSERT INTO kekNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Yo̱quin chi tz'i̱bac a̱cuiq'uin re nak ta̱q'ue retal chi tz'akal li xya̱lal li xatzol cui' a̱cuib. ");
INSERT INTO kekNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Sa' eb li cutan nak quicuan chok' rey laj Herodes aran Judea, quicuan jun laj tij aj Zacarías xc'aba'. A'an xcomoneb li ralal xc'ajol laj Abías. Li rixakil xElisabet xc'aba'. A'an xcomoneb li ralal xc'ajol laj Aarón. ");
INSERT INTO kekNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Laj Zacarías ut li rixakil, a'an ti̱queb xch'o̱l chiru li Dios. Junelic neque'xq'ue xch'o̱leb chixba̱nunquil chi tz'akal lix chak'rabinquileb ut lix taklanquileb xban li Ka̱cua' Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Abanan ma̱c'a' xcoc'aleb xban nak lix Elisabet inc'a' naq'uiresin ut xban ajcui' nak ac che̱queb chic. ");
INSERT INTO kekNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Sa' jun li cutan laj Zacarías yo̱ chixba̱nunquil lix c'anjel chiru li Dios sa' li templo jo' c'aynakeb xba̱nunquil. ");
INSERT INTO kekNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Quit'ane' sa' xbe̱n laj Zacarías oc sa' li Santil Na'ajej sa' li templo chixc'atbal li incienso. ");
INSERT INTO kekNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nak yo̱ chi c'atc li incienso chixjunileb li tenamit ch'utch'u̱queb chirix cab ut yo̱queb chi tijoc. ");
INSERT INTO kekNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sa' li ho̱nal a'an quixc'utbesi rib chiru laj Zacarías jun x-ángel li Ka̱cua' Dios. Xakxo sa' xnim chixc'atk li artal li nac'atman cui' li incienso. ");
INSERT INTO kekNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","C'ajo' nak quisach xch'o̱l laj Zacarías nak quiril li ángel ut quixucuac. ");
INSERT INTO kekNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ut li ángel quixye: —At Zacarías, matxucuac. Li Dios xrabi li c'a'ru xatz'a̱ma. Lix Elisabet la̱ cuixakil ta̱cua̱nk jun xc'ula'al ut Juan ta̱q'ue chok' xc'aba'. ");
INSERT INTO kekNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nak ta̱yo'la̱k la̱ cualal, c'ajo' nak ta̱sahok' sa' a̱ch'o̱l la̱at ut nabaleb ajcui' li cristian te'sahok' sa' xch'o̱leb. ");
INSERT INTO kekNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","La̱ cualal li ta̱yo'la̱k ta̱q'uehek' xcuanquil xban li Dios. A'an inc'a' ta̱uc'ak vino chi moco li ha' li nacaltesin. Ut ac cua̱nk chak li Santil Musik'ej riq'uin nak toj ma̱ji'ak nayo'la. ");
INSERT INTO kekNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ut sa' xc'aba' a'an nabaleb li ralal xc'ajol laj Israel te'xsic' cui'chic li Ka̱cua' Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","A'an xbe̱n cua ta̱xic chiru li Ka̱cua' chixch'olobanquil li xya̱lal. Cua̱nk li Santil Musik'ej riq'uin ut cua̱nk xcuanquil jo' li cuanquilal li quiq'uehe' re laj Elías xban li Dios. Ut sa' xc'aba' a'an te'xc'am cui'chic rib sa' usilal li yucua'bej riq'uineb li alalbej. Eb laj k'etol a̱tin te'xjal xna'leb ut te'xtzol ribeb riq'uineb li ti̱queb xch'o̱l. Tixcauresi li tenamit chixc'ulbal li Ka̱cua', chan li ángel. ");
INSERT INTO kekNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Quichak'oc laj Zacarías ut quixye: —¿Chanru nak tinnau nak ya̱l li yo̱cat chixyebal cue? La̱in ti̱xin chic. Jo'can ajcui' li cuixakil, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ut li ángel quixye: —La̱in li ángel Gabriel li ninc'anjelac chiru li Dios. Ut a'an xtaklan chak cue xyebal a̱cue li cha̱bil esilal a'in. ");
INSERT INTO kekNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Anakcuan la̱at tatcana̱k chi mem xban nak inc'a' xapa̱b li c'a'ru xinye. Inc'a' tat-a̱tinak toj ta̱cuulak xk'ehil nak ta̱c'ulma̱nk chixjunil a'in, chan li ángel. ");
INSERT INTO kekNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Eb li tenamit cuanqueb chirix cab. Yo̱queb chiroybeninquil laj Zacarías. Yo̱queb chixc'oxlanquil c'a'ru xc'ul nak xbay chak sa' li templo. ");
INSERT INTO kekNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ut nak qui-el chak sa' li templo mem chic laj Zacarías. Inc'a' chic naa̱tinac. Yal ruk' aj chic naxc'ut chiruheb li neque'a̱tinan re. Ticto que'xtau ru nak quic'utbesi̱c chak chiru jun li visión sa' li templo. ");
INSERT INTO kekNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nak ac xrake' xba̱nunquil lix c'anjel sa' li templo, laj Zacarías quisuk'i sa' rochoch. ");
INSERT INTO kekNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ut chirix chic a'an lix Elisabet, li rixakil laj Zacarías, quicana chi yaj aj ixk. Ut chiru o̱b po quicana sa' li rochoch. Ma̱ bar qui-el ut yo̱ chixyebal sa' xch'o̱l: ");
INSERT INTO kekNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","—Jo'ca'in nak xruxta̱na cuu li Ka̱cua'. Xrisi lin xuta̱n chiruheb li tenamit nak xq'ue jun lin c'ula'al, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nak ac yo̱ chic xcuak po xcanajic chi yaj aj ixk lix Elisabet, li ángel Gabriel quitakla̱c xban li Dios sa' jun li tenamit Nazaret xc'aba' li cuan xcue̱nt Galilea. ");
INSERT INTO kekNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Quitakla̱c riq'uin jun li xka'al xMaría xc'aba' toj ma̱ji' cuanjenak riq'uin cui̱nk. Ac tz'a̱manbil xban jun li cui̱nk aj José xc'aba'. Li cui̱nk a'an xcomoneb li ralal xc'ajol li rey David. ");
INSERT INTO kekNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Li ángel quicuulac riq'uin lix María ut quixye re: —Sahak taxak sa' la̱ ch'o̱l xban nak la̱at li sic'bil a̱cuu. Li Ka̱cua' cuan a̱cuiq'uin ut osobtesinbilat sa' xya̱nkeb li ixk, chan li ángel. ");
INSERT INTO kekNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ut lix María quisach xch'o̱l chirabinquil li quixye li ángel. —¿C'a'ru xya̱lal li a̱tin li xye cue? chan sa' xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ut li ángel quixye re: —Matxucuac, María. Li Dios xsic'oc a̱cuu xban nak cha̱bil a̱na'leb. ");
INSERT INTO kekNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Anakcuan tatcana̱k chi yaj aj ixk. Li Dios tixq'ue jun a̱c'ula'al te̱lom ut Jesús lix c'aba' ta̱q'ue. ");
INSERT INTO kekNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nimak xcuanquil nak ta̱cua̱nk ut chixjunileb te'na'ok re nak a'an tz'akal Ralal li Dios. Ut li Ka̱cua' ta̱q'uehok xcuanquil chi takla̱nc jo' nak quicuan chi takla̱nc li rey David lix xe'to̱nil yucua'. ");
INSERT INTO kekNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","A'anak chic li cua̱nk xcuanquil chi takla̱nc sa' xbe̱neb li ralal xc'ajol laj Jacob. Ut lix cuanquilal ta̱cua̱nk chi junelic. Inc'a' ta̱osok', chan li ángel. ");
INSERT INTO kekNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Quichak'oc lix María ut quixye: —¿Chanru nak ta̱cua̱nk inc'ula'al xban nak la̱in moco cuanquin ta riq'uin cui̱nk? chan lix María. ");
INSERT INTO kekNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Li ángel quixye re: —Riq'uin xcuanquil li Santil Musik'ej tatcana̱k chi yaj aj ixk. Lix cuanquil li nimajcual Dios ta̱cua̱nk a̱cuiq'uin. Ut li c'ula'al li ta̱yo'la̱k, a'an santo ut tz'akal ralal li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Jo'can ajcui' lix Elisabet la̱ cuech'alal yaj aj ixk anakcuan. Ac cuakib po chic xcanajic chi yaj aj ixk, usta ac ti̱x chic ut usta chixjunileb que'xye nak a'an inc'a' ta̱cua̱nk xcoc'al. ");
INSERT INTO kekNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Riq'uin a'in nac'utun nak ma̱c'a' ch'a'aj chiru li Dios, chan li ángel. ");
INSERT INTO kekNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ut lix María quixye: —La̱in aj c'anjel chiru li Ka̱cua' Dios. Xba̱nuhak cuiq'uin li c'a'ru xaye, chan. Ut chirix chic a'an, co̱ li ángel. ");
INSERT INTO kekNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ac xnume' chic cuib oxib cutan nak lix María co̱ sa' junpa̱t sa' jun li na'ajej tzu̱l ru cuan sa' xcue̱nt Judea. ");
INSERT INTO kekNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Quicuulac sa' rochoch laj Zacarías ut quixq'ue xsahil xch'o̱l lix Elisabet. ");
INSERT INTO kekNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nak quirabi lix sahil xch'o̱l lix Elisabet li quiq'uehe' xban lix María, quirec'a nak qui-ec'an chak lix c'ula'al. Ut sa' ajcui' li ho̱nal a'an lix Elisabet quinujac chi Santil Musik'ej. ");
INSERT INTO kekNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ut lix Elisabet quixye chi cau xya̱b xcux: —Osobtesinbilat sa' xya̱nkeb chixjunileb li ixk ut osobtesinbil ajcui' la̱ c'ula'al li ta̱yo'la̱k. ");
INSERT INTO kekNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","La̱in moco inc'ulub ta nak tatcha̱lk chicuilbal xban nak la̱at lix na' li Ka̱cua', li ninlok'oni la̱in. ");
INSERT INTO kekNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nak xcuabi lix sahil inch'o̱l xaq'ue, xcuec'a nak lin c'ula'al x-ec'an chak xban xsahil xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Us xak a̱cue xban nak xapa̱b nak ta̱c'ulma̱nk li c'a'ru xye li Ka̱cua', chan lix Elisabet. ");
INSERT INTO kekNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ut lix María quixye: —Chi anchal inch'o̱l ninq'ue xlok'al li Ka̱cua'. ");
INSERT INTO kekNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nasaho' sa' inch'o̱l riq'uin li Dios laj Colol cue, ");
INSERT INTO kekNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","xban nak xruxta̱na cuu la̱in aj c'anjel chiru, usta ma̱c'a' incuanquil. Chalen anakcuan us xak re cha'keb cue chixjunileb li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Lok'oninbil taxak ru li Ka̱cua' li k'axal nim xcuanquil xban nak quixc'utbesi chicuu lix nimal lix cuanquilal. A'an tz'akal santo. ");
INSERT INTO kekNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Li Ka̱cua' junelic na-uxta̱nan u. Naruxta̱na ruheb li neque'xucuan ru. ");
INSERT INTO kekNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Sachba ch'o̱lej li quixba̱nu riq'uin xnimal xcuanquil. Quixpo' ru li yo̱queb chixc'oxlanquil xba̱nunquil li k'etk'eteb, li neque'rec'a sa' xch'o̱leb nak ni̱nkeb xcuanquil. ");
INSERT INTO kekNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Quirisi sa' xna'ajeb li cuanqueb sa' xcuanquil. Ut quixq'ueheb xlok'al li ma̱c'a'eb xcuanquil. ");
INSERT INTO kekNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Li ma̱c'a' cuan reheb naxq'ue chi nabal c'a'ru reheb. Ut eb li biom naxtaklaheb chi ma̱c'a' cuan reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","A'an junelic quixtenk'aheb laj Israel lix tenamit ut inc'a' quisach sa' xch'o̱l ruxta̱nanquil ruheb, ");
INSERT INTO kekNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","xban nak jo'can quixyechi'i reheb li kaxe'to̱nil yucua'. Quixyechi'i re laj Abraham nak ta̱ruxta̱na ruheb li ralal xc'ajol chi junelic, chan lix María. ");
INSERT INTO kekNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ut lix María quicuan oxib po riq'uin lix Elisabet. Ut chirix a'an quisuk'i sa' rochoch. ");
INSERT INTO kekNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Quicuulac xk'ehil nak ta̱yo'la̱k lix c'ula'al lix Elisabet ut quicuan jun lix c'ula'al ch'ina te̱lom. ");
INSERT INTO kekNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nak que'rabi resil li rech cabal jo' cui' eb li rech'alal nak qui-uxta̱na̱c ru lix Elisabet xban li Ka̱cua', que'saho' ajcui' sa' xch'o̱leb a'an. ");
INSERT INTO kekNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ac cuan cuakxakib cutan re li c'ula'al, nak quixc'ul li circuncisión. Aj Zacarías raj que'xq'ue chok' xc'aba' chok' re̱kaj lix yucua'. ");
INSERT INTO kekNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Abanan li na'bej quixye: —Inc'a'. Aj Juan takaq'ue chok' xc'aba', chan. ");
INSERT INTO kekNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Que'chak'oc ut que'xye re: —¿C'a'ut nak ta̱cuaj xq'uebal aj Juan chok' xc'aba'? Ma̱ jun sa' xya̱nkeb la̱ cuech'alal cuan ta xc'aba' jo' a'an, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Que'xc'ut li ruk'eb chiru laj Zacarías re xpatz'bal re c'a'ru c'aba'ej ta̱raj xq'uebal chok' xc'aba' li ralal. ");
INSERT INTO kekNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Laj Zacarías quixpatz' jun xhu reheb re tixtz'i̱ba li c'aba'ej chiru. Ut sa' li hu quixtz'i̱ba “Juan lix c'aba' te̱q'ue”. Nak que'ril li hu, que'sach xch'o̱leb chixjunileb. ");
INSERT INTO kekNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ut sa' ajcui' li ho̱nal a'an laj Zacarías quiru chic chi a̱tinac ut qui-oc chixlok'oninquil li Ka̱cua' Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","C'ajo' nak que'oc xxiuheb chixjunileb li rech cabal ut yalak bar sa' li na'ajej tzu̱l ru li cuan sa' xcue̱nt Judea qui-el resil li c'a'ru quic'ulman. ");
INSERT INTO kekNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ut chixjunileb li que'abin re que'xq'ue sa' xch'o̱leb ut que'xye: —¿C'a'ru anchal tixc'anjela li c'ula'al a'in nak ta̱nima̱nk? Nac'utun nak cuan xcuanquil li Dios riq'uin, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ut laj Zacarías lix yucua' laj Juan quinujac chi Santil Musik'ej. Qui-oc chi a̱tinac ut quixye li c'a'ru quic'utbesi̱c chiru xban li Dios. Ut quixye chi jo'ca'in: ");
INSERT INTO kekNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Lok'oninbil taxak li Ka̱cua' Dios li neque'xlok'oni laj Israel xban nak xril xtok'oba̱l ruheb lix tenamit ut xcoleb. ");
INSERT INTO kekNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Xq'ue jun laj Colol ke k'axal nim xcuanquil. Quixsic' ru sa' xya̱nkeb li ralal xc'ajol li rey David laj c'anjel chiru. ");
INSERT INTO kekNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","A'in quixyechi'i chak junxilaj jo' que'xye ke li santil profetas. ");
INSERT INTO kekNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Quixye reheb nak toxcol chiruheb li xic' neque'iloc ke ut torisi rubeleb xcuanquil. ");
INSERT INTO kekNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Quixye nak ta̱ruxta̱na ruheb li kaxe'to̱nil yucua' xban nak jultic re li quixye sa' li santil contrato. ");
INSERT INTO kekNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Li Ka̱cua' riq'uin juramento quixyechi'i a'an re laj Abraham li kaxe'to̱nil yucua'. ");
INSERT INTO kekNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Quixye re nak a'an ta̱colok ke chiruheb li xic' neque'iloc ke re nak toc'anjelak chiru a'an chi ma̱c'a'ak kaxiu, ");
INSERT INTO kekNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ut re ajcui' nak junelic tocua̱nk sa' santilal ut sa' ti̱quilal chiru li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","At cualal, la̱at xprofeta li nimajcual Dios. La̱at tatxic xbe̱n cua chiru li Ka̱cua' ut ta̱ch'olob li xya̱lal chiruheb li tenamit re nak te'xcauresi ribeb chixc'ulbal li Ka̱cua'. ");
INSERT INTO kekNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ta̱c'ut chiruheb li tenamit chanru nak te'cuyek' te'sachek' lix ma̱queb ut te'colek'. ");
INSERT INTO kekNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Xban nak k'axal nim ruxta̱n li Ka̱cua' Dios, xtakla chak li Jun li ta̱cutanobresi̱nk re li kac'a'ux. ");
INSERT INTO kekNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ut tixcutanobresi xc'a'uxeb li cuanqueb sa' xk'ojyi̱nal ru li ma̱c, li ca̱mqueb re sa' li ma̱usilal. Ut a'an ta̱beresi̱nk ke sa' li tuktu̱quilal, chan laj Zacarías. ");
INSERT INTO kekNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ut li c'ula'al yo̱ chi q'ui̱c ut yo̱ chi cacuu̱c sa' xpa̱ba̱l. Ut quicuan sa' li chaki ch'och' bar inc'a' q'uiheb li tenamit toj quicuulac xk'ehil nak quixtiquib xch'olobanquil li xya̱lal chiruheb laj Israel. ");
INSERT INTO kekNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Sa' eb li cutan a'an li acuabej César Augusto quixq'ue jun li chak'rab re nak chixjunileb li tenamit te'ajla̱k ut te'xq'ue xc'aba'eb chi tz'i̱ba̱c. ");
INSERT INTO kekNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","A'in li xbe̱n sut nak que'xtz'i̱ba xc'aba'eb li tenamit. A'an quic'ulman nak cua̱nk laj Cirenio chi takla̱nc sa' li na'ajej Siria. ");
INSERT INTO kekNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Chixjunileb que'co̱eb xq'uebaleb xc'aba' chi tz'i̱ba̱c. Ac sa' xtenamiteb li junju̱nk que'co̱eb chixtz'i̱banquileb lix c'aba'. ");
INSERT INTO kekNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Laj José qui-el sa' li tenamit Nazaret li cuan sa' xcue̱nt Galilea ut co̱ Belén li cuan xcue̱nt Judea. A'an xtenamit li rey David. Aran co̱ xban nak a'an xcomoneb li ralal xc'ajol laj David. ");
INSERT INTO kekNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Aran quixq'ue xc'aba' chi tz'i̱ba̱c rochben lix María li ac tz'a̱manbil xban. Lix María ac yaj aj ixk. ");
INSERT INTO kekNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nak ac cuanqueb aran Belén quicuulac xk'ehil nak ta̱yo'la̱k lix c'ula'al. ");
INSERT INTO kekNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ut quiyo'la li xbe̱n xc'ula'al, quixlan sa' t'icr ut quixyocob sa' xna'aj xcuaheb li cuacax xban nak ma̱c'a' xna'ajeb sa' eb li ochoch. ");
INSERT INTO kekNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nach' riq'uin li tenamit Belén cuanqueb aj ilol xul yo̱queb chixc'ac'alenquil lix queto̱mk chi k'ek. ");
INSERT INTO kekNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ma̱c'a' sa' xch'o̱leb nak xaka̱mil jun x-ángel li Ka̱cua' chiruheb. Ut quisakeno' chi xjun sutam li cuanqueb cui'. Ut eb laj ilol xul c'ajo' nak que'xucuac. ");
INSERT INTO kekNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Abanan li ángel quixye reheb: —Mexxucuac xban nak la̱in xinchal xyebal e̱re jun cha̱bil esilal. A'in jun sahil ch'o̱lej chok' reheb chixjunileb li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Anakcuan xyo'la jun laj Colol e̱re sa' lix tenamit laj David ut a'an li Cristo li Ka̱cua' li yechi'inbil xban li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Jo'ca'in nak te̱tau. Li c'ula'al lanbil sa' t'icr ut yocyo sa' xbe̱n li q'uim sa' xna'aj xcuaheb li cuacax. A'in li retalil nak a'an li te̱tau, chan li ángel. ");
INSERT INTO kekNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ut sa' junpa̱t que'chal nabaleb chic li ángel sa' choxa. Yo̱queb chixlok'oninquil li Ka̱cua' ut yo̱queb chixyebal: ");
INSERT INTO kekNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—Chinima̱k taxak xlok'al li Ka̱cua' Dios li cuan sa' choxa ut chicua̱nk taxak li tuktu̱quilal sa' xya̱nkeb li cristian li raro̱queb xban li Dios.— ");
INSERT INTO kekNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nak ac xco̱eb li ángel sa' choxa, eb laj ilol xul que'oc chixyebal chi ribileb rib: —Yo̱keb Belén ut takil chak li c'a'ru xc'ulman, li xtakla xyebal ke li Ka̱cua', chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Co̱eb sa' a̱nil ut que'xtau lix María rochben laj José ut li c'ula'al yocyo sa' xna'aj xcuaheb li xul. ");
INSERT INTO kekNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ut nak ac xe'xtau, que'xserak'i reheb li c'a'ru quiyehe' reheb chirix li c'ula'al. ");
INSERT INTO kekNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ut chixjunileb li que'abin re li c'a'ru que'xye laj ilol xul, sachso̱queb xch'o̱l que'cana. ");
INSERT INTO kekNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ut lix María quixc'u̱la sa' xch'o̱l chixjunil li c'a'ru quic'ulman ut yo̱ chixc'oxlanquil rix. ");
INSERT INTO kekNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ut chirix chic a'an eb laj ilol xul que'suk'i sa' lix na'ajeb. Yo̱queb chixlok'oninquil ut yo̱queb chixnimanquil ru li Ka̱cua' riq'uin li c'a'ru que'rabi ut que'ril xban nak chixjunil li que'ril, a'an jo' li quiyehe' reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Cuakxakib cutan cuan re li c'ula'al nak quixc'ul li circuncisión ut Jesús que'xq'ue chok' xc'aba', jo' quiyehe' re lix María xban li ángel nak toj ma̱ji' nacana chi yaj. ");
INSERT INTO kekNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Lix María quixba̱nu jo' naxye sa' lix chak'rab laj Moisés. Nak ac xnume' ca'c'a̱l cutan, lix María rochben laj José que'xc'am li c'ula'al Jerusalén ut que'xk'axtesi chiru li Ka̱cua'. ");
INSERT INTO kekNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Que'xba̱nu chi jo'can xban nak sa' li chak'rab li quiq'uehe' reheb xban li Ka̱cua' naxye nak li xbe̱n alalbej tento ta̱k'axtesi̱k sa' ruk' li Ka̱cua'. ");
INSERT INTO kekNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ut te'xq'ue chok' xmayejeb jun sumalak li mucuy malaj ut cuibak li paloma li toj sa̱jeb, jo' naxye sa' li chak'rab. ");
INSERT INTO kekNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Aran Jerusalén cuan jun li cui̱nk aj Simeón xc'aba'. Li cui̱nk a'an ti̱c xch'o̱l ut naxq'ue xlok'al li Dios. Yo̱ chiroybeninquil nak li Dios ta̱risiheb sa' raylal laj Israel. Ut cuan li Santil Musik'ej riq'uin. ");
INSERT INTO kekNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Li Santil Musik'ej quixc'utbesi chiru laj Simeón nak a'an inc'a' ta̱ca̱mk toj ta̱ril ru li Cristo li Colonel li quixyechi'i li Ka̱cua' Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Li Santil Musik'ej quixc'ut chiru laj Simeón nak ta̱xic sa' li templo xban nak sa' li ho̱nal a'an quic'ame' li Jesús sa' li templo xban laj José ut lix María re nak te'xk'axtesi sa' ruk' li Dios jo' naxye sa' li chak'rab. ");
INSERT INTO kekNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ut laj Simeón quixk'alu li Jesús, quixq'ue xlok'al li Ka̱cua' ut quixye: ");
INSERT INTO kekNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","—At Ka̱cua', anakcuan xaba̱nu jo' xayechi'i cue. Anakcuan naru tinca̱mk chi c'ojc'o inch'o̱l, ");
INSERT INTO kekNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","xban nak riq'uin xnak' cuu xcuil li Colonel li yechi'inbil a̱ban, ");
INSERT INTO kekNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","li xaq'ue chak re xcolbaleb chixjunileb li cuanqueb sa' ruchich'och'. ");
INSERT INTO kekNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","A'an li ta̱cutanobresi̱nk re lix c'a'uxeb li ma̱cua'eb aj Israel ut a'an lix lok'aleb la̱ tenamit Israel, chan laj Simeón. ");
INSERT INTO kekNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Laj José ut li na'bej sachso̱queb xch'o̱l que'cana chirabinquil li yo̱ chixyebal laj Simeón chirix li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ut laj Simeón quixtz'a̱ma rusilal li Dios sa' xbe̱neb ut quixye re lix María li na'bej: —Chacuabi li oc cue xyebal a̱cue. Sa' xc'aba' li c'ula'al a'in, nabaleb laj Israel te'colek' ut sa' xc'aba' ajcui' a'an nabaleb li te'sachk. Ut nabaleb li te'tz'ekta̱na̱nk re. ");
INSERT INTO kekNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Riq'uin li raylal te'xba̱nu re, ta̱c'utu̱nk chi tz'akal li c'a'ru cuan sa' xch'o̱leb li xic' neque'iloc re. Ut c'ajo' nak ta̱rahok' a̱ch'o̱l la̱at xban li raylal te'xba̱nu re. Chanchan nak te'xnumsi jun ch'i̱ch' sa' la̱ cua̱m, chan laj Simeón. ");
INSERT INTO kekNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ut cuan ajcui' jun li xma̱lca'an aran profeta, xAna xc'aba'. A'an xrabin laj Fanuel xcomoneb li ralal xc'ajol laj Aser. Ac ti̱x chic. Toj sa̱j nak quisumla ut cuukub chihab ajcui' quicuan rochben lix be̱lom. ");
INSERT INTO kekNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ac cuan chic ca̱hib ro'c'a̱l chihab (84) xcanajic xjunes. A'an cuan junelic sa' li templo. Yo̱ chi c'anjelac chiru li Ka̱cua' chi k'ek chi cutan. Junelic yo̱ chi tijoc ut yo̱ chixba̱nunquil x-ayu̱n. ");
INSERT INTO kekNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Sa' li ho̱nal a'an quicuulac cuan cui' li Jesús. Yo̱ chixlok'oninquil li Dios ut qui-oc chi a̱tinac chirix li c'ula'al riq'uineb laj Jerusalén li yo̱queb chiroybeninquil lix colbaleb. ");
INSERT INTO kekNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nak ac que'xba̱nu chixjunil li naxye sa' li chak'rab li quixq'ue li Ka̱cua', laj José ut lix María que'suk'i sa' li tenamit Nazaret li cuan sa' xcue̱nt Galilea. ");
INSERT INTO kekNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ut li c'ula'al yo̱ chi q'ui̱c ut yo̱ chi cacuu̱c xch'o̱l. Ut yo̱ chixtaubal xna'leb. Ut li rusilal li Ka̱cua' cuan riq'uin. ");
INSERT INTO kekNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Rajlal chihab neque'xic lix na' xyucua' aran Jerusalén chixnink'einquil li reliqueb Egipto. Pascua neque'xye re li nink'e a'an. ");
INSERT INTO kekNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nak ac cuan cablaju chihab re li Jesús, co̱eb aran Jerusalén sa' li nink'e jo' c'aynakeb xba̱nunquil. ");
INSERT INTO kekNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ut nak ac xrake' li nink'e que'suk'i sa' lix tenamiteb. Ut li Jesús quicana Jerusalén chi inc'a' naxnau laj José chi moco li na'bej. ");
INSERT INTO kekNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Sa' xch'o̱leb a'an nak cuan sa' xya̱nkeb li rochben. Jun cutan ac xe'be̱c nak que'xq'ue retal nak ma̱ ani. Ut que'oc chixsic'bal sa' xya̱nkeb li rech'alal ut sa' xya̱nkeb li neque'na'oc ru. ");
INSERT INTO kekNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Que'ril nak inc'a' que'xtau. Que'suk'i cui'chic Jerusalén chixsic'bal. ");
INSERT INTO kekNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nak ac xnume' chic oxib cutan, que'xtau aran sa' li templo. C'ojc'o sa' xya̱nkeb li neque'xnau chi us li c'a'ru naxye sa' li chak'rab. Yo̱ chirabinquil li yo̱queb chixyebal ut yo̱ ajcui' chi patz'oc reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ut chixjunileb li yo̱queb chi abi̱nc re sachso̱queb xch'o̱l neque'cana xban nak cuan xna'leb ut naxnau xsumenquil li c'a'ru neque'xpatz' re. ");
INSERT INTO kekNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Lix na' xyucua' sachso̱queb xch'o̱l que'cana nak que'ril nak li Jesús yo̱ chi a̱tinac riq'uineb. Ut lix na' quixye re: —At inyum, ¿c'a'ut nak xaba̱nu ke chi jo'ca'in? C'ajo' kac'a'ux cha̱cuix. La̱ yucua' ut la̱in yo̱co cha̱sic'bal, chan lix María. ");
INSERT INTO kekNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Quichak'oc li Jesús ut quixye re: —¿C'a'ut nak yo̱quex chinsic'bal? ¿Ma inc'a' ta bi' nequenau nak tento tinba̱nu lix c'anjel lin Yucua'? chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ut eb a'an inc'a' que'xtau ru c'a'ut nak quixye reheb chi jo'can. ");
INSERT INTO kekNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Li Jesús quisuk'i Jerusalén rochbeneb lix na' xyucua' ut na-abin chiruheb. Ut lix na' quixc'u̱la sa' xch'o̱l chixjunil li quic'ulman. ");
INSERT INTO kekNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Li Jesús yo̱ chi q'ui̱c ut yo̱ ajcui' chixtaubal xna'leb. Quirahe' xban li Dios ut quirahe' ajcui' xbaneb li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Yo̱ o'laju chihab roquic chok' acuabej laj Tiberio César, nak cua̱nk laj Poncio Pilato chi takla̱nc sa' li tenamit Judea. Laj Herodes a'an cua̱nk chi takla̱nc sa' li tenamit Galilea. Ut laj Felipe li ri̱tz'in cua̱nk chi takla̱nc sa' li tenamit Iturea ut sa' li na'ajej Traconite, ut laj Lisanias cua̱nk chi takla̱nc sa' li tenamit Abilinia. ");
INSERT INTO kekNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ut cuanqueb chok' xbe̱nil aj tij laj Anás ut laj Caifás. Sa' eb li cutan a'an laj Juan li ralal laj Zacarías quia̱tina̱c xban li Dios nak cuan chak sa' li chaki ch'och'. ");
INSERT INTO kekNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Laj Juan co̱ sa' li na'ajej cuan cui' li nima' Jordán ut qui-oc chixch'olobanquil li xya̱lal chiruheb li tenamit li cuanqueb aran. Quixye reheb nak tento te'yot'ek' xch'o̱l te'xjal xc'a'ux ut te'xc'ul li cubi ha' re nak li Dios tixcuy tixsach lix ma̱queb. ");
INSERT INTO kekNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Li profeta Isaías quia̱tinac chirix laj Juan nak quixye chi jo'ca'in: A'an ta̱ch'oloba̱nk xya̱lal chi cau xya̱b xcux sa' li chaki ch'och' ut tixye: Yi̱bomak le̱ yu'am ut yo'on cua̱nkex chixc'ulbal li Ka̱cua' jo' nak neque'xyi̱b li be re xc'ulbal junak nim xcuanquil. ");
INSERT INTO kekNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Te't'anek' li tzu̱l ut eb li coc' bol ut te'but'ek' eb li tak'a ruheb. Ta̱ti̱cobresi̱k li be re nak ti̱c ru ta̱cana̱k. ");
INSERT INTO kekNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ut chixjunileb li cuanqueb sa' ruchich'och' te'ril ru laj Colonel li xtakla chak li Dios. (Is. 40:3-5) ");
INSERT INTO kekNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Quiril nak nabaleb li yo̱queb chi cuulac yal re ta̱cubsi̱k xha'eb. Jo'can nak quixye reheb: —La̱ex chanchanex li ral li c'ambolay. ¿Ani xyehoc e̱re nak ta̱ru̱k te̱col e̱rib chiru lix josk'il li Dios li ta̱cha̱lk sa' e̱be̱n? ");
INSERT INTO kekNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Cheba̱nuhak ban li us re nak ta̱c'utu̱nk nak xyot'e' e̱ch'o̱l ut xejal e̱c'a'ux. Chanchanakex li che' cha̱bil li ru naxq'ue. Me̱c'oxla nak inc'a' te̱c'ul xjosk'il li Dios yal xban nak la̱ex li ralal xc'ajol laj Abraham. La̱in tinye e̱re nak li Dios ta̱ru̱k tixyo'obtesi li pec a'in chok' ralal xc'ajol laj Abraham. ");
INSERT INTO kekNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Q'uehomak retal xban nak cha̱lc re li rakba a̱tin sa' e̱be̱n jo' nak ac cauresinbil li ma̱l re xyoc'bal lix xe' li che'. Ut chixjunil li che' inc'a' cha̱bil li ru naxq'ue, nayoc'man ut naq'ueman sa' xam, chan laj Juan. ");
INSERT INTO kekNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ut eb li tenamit yo̱queb chixpatz'bal re: —¿C'a'ru tento takaba̱nu re nak inc'a' ta̱rakek' a̱tin sa' kabe̱n? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Quichak'oc laj Juan ut quixye reheb: —Li ani cuan cuibak sumal rak' chixq'uehak jun sumalak re li ma̱c'a' re. Ut li ani cuan xtzacae̱mk, chixq'uehak re li ma̱c'a' re, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Cuanqueb ajcui' aj titz'ol toj que'chal re te'cubsi̱k xha' xban laj Juan ut que'xye re: —¿C'a'ru takaba̱nu la̱o? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ut a'an quixye reheb: —Me̱patz' xbe̱n li toj li ac yebil reheb nak te'xq'ue, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ut cuanqueb ajcui' soldado que'patz'oc ut que'xye re: —Ut la̱o, ¿c'a'ru takaba̱nu? chanqueb. Quixye reheb: —Ma̱ ani te̱mak' c'a'ru re ut ma̱ ani te̱k'aba chi ma̱c'a' rajbal. Chic'ojla̱k ban e̱ch'o̱l riq'uin li jo' q'uial nequextoje' cui', chan. ");
INSERT INTO kekNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Chixjunileb li tenamit yo̱queb chixc'oxlanquil ut que'xye sa' xch'o̱leb: —¿Ma ma̱cua' ta cui' a'an li Cristo, laj Colonel li yo̱co chiroybeninquil? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Laj Juan quichak'oc ut quixye reheb chixjunileb: —Ya̱l nak la̱in nincubsin ha' riq'uin ha'. Abanan cha̱lc re li k'axal nim xcuanquil. Xban nak k'axal nim xcuanquil chicuu la̱in, moco inc'ulub ta nak tinhit xc'a̱mal lix xa̱b. A'an tixcubsi e̱ha' riq'uin li Santil Musik'ej ut riq'uin xam. ");
INSERT INTO kekNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","A'an chanchan jun aj acuinel ac cuan chak xc'anjeleba̱l sa' ruk'. Ta̱rapu chi us li ru li trigo ut tixxoc lix trigo sa' lix c'u̱leba̱l ut li rix tixc'at sa' li xam. Jo'can ajcui' nak li Dios ta̱risiheb li inc'a' neque'pa̱ban sa' xya̱nkeb li ralal xc'ajol ut tixtaklaheb sa' li xam li inc'a' nachup. Li ralal xc'ajol ta̱cua̱nk xyu'ameb chi junelic, chan laj Juan. ");
INSERT INTO kekNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jo'can nak yo̱ chixch'olobanquil xna'lebeb li tenamit. Naxsic' chanru nak naxch'olob chi tz'akal li cha̱bil esilal chiruheb. ");
INSERT INTO kekNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ut laj Herodes, li nataklan sa' li tenamit Galilea, quik'use' chi cau xban laj Juan xban nak quixc'am chok' rixakil lix Herodías, li rixakil laj Felipe li ri̱tz'in. Ut quik'use' ajcui' riq'uin chixjunil li ma̱usilal naxba̱nu. ");
INSERT INTO kekNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ut k'axal cui'chic numtajenak li ma̱usilal quixba̱nu nak quixq'ue sa' tz'alam laj Juan. ");
INSERT INTO kekNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Sa' jun li cutan nak toj ma̱ji' quiq'uehe' sa' tz'alam laj Juan, yo̱ chixcubsinquil xha'eb nabal li tenamit, ut quixcubsi ajcui' xha' li Jesús. Ut nak yo̱ chi tijoc li Jesús, quiril nak quiteli li choxa chiru. ");
INSERT INTO kekNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Li Santil Musik'ej chanchan jun li paloma nak yo̱ chak chi cubec sa' xbe̱n li Jesús ut qui-abi̱c xya̱b xcux li Dios toj sa' choxa nak quixye: —La̱at li cualal raro̱cat inban. Nasaho' inch'o̱l a̱cuiq'uin, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ac cuan tana laje̱b xca'c'a̱l (30) chihab re li Jesús nak quixtiquib lix c'anjel. Chiruheb chixjunileb, li Jesús a'an ralal laj José, li ralal laj Elí. ");
INSERT INTO kekNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ut laj Elí, a'an li ralal laj Matat. Laj Matat, a'an li ralal laj Leví. Ut laj Leví, a'an li ralal laj Melqui. Ut laj Melqui, a'an li ralal laj Jana. Ut laj Jana, a'an li ralal laj José. ");
INSERT INTO kekNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Laj José, a'an li ralal laj Matatías. Ut laj Matatías, a'an li ralal laj Amós. Ut laj Amós, a'an li ralal laj Nahum. Ut laj Nahum, a'an li ralal laj Esli. Ut laj Esli, a'an li ralal laj Nagai. ");
INSERT INTO kekNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ut laj Nagai, a'an li ralal laj Maat. Ut laj Maat, a'an li ralal laj Matatías. Ut laj Matatías, a'an li ralal laj Semei. Ut laj Semei, a'an li ralal laj José. Ut laj José, a'an li ralal laj Judá. ");
INSERT INTO kekNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Laj Judá, a'an li ralal laj Joana. Ut laj Joana, a'an li ralal laj Resa. Ut laj Resa, a'an li ralal laj Zorobabel. Ut laj Zorobabel, a'an li ralal laj Salatiel. Ut laj Salatiel, a'an li ralal laj Neri. ");
INSERT INTO kekNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ut laj Neri, a'an li ralal laj Melqui. Ut laj Melqui, a'an li ralal laj Adi. Ut laj Adi, a'an li ralal laj Cosam. Ut laj Cosam, a'an li ralal laj Elmodam. Ut laj Elmodam, a'an li ralal laj Er. ");
INSERT INTO kekNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ut laj Er, a'an li ralal laj Josué. Ut laj Josué, a'an li ralal laj Eliezer. Ut laj Eliezer, a'an li ralal laj Jorim. Ut laj Jorim, a'an li ralal laj Matat. ");
INSERT INTO kekNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ut laj Matat, a'an li ralal laj Leví. Ut laj Leví, a'an li ralal laj Simeón. Ut laj Simeón, a'an li ralal laj Judá. Ut laj Judá, a'an li ralal laj José. Ut laj José, a'an li ralal laj Jonán. Ut laj Jonán, a'an li ralal laj Eliaquim. ");
INSERT INTO kekNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ut laj Eliaquim, a'an li ralal laj Melea. Ut laj Melea, a'an li ralal laj Mainán. Ut laj Mainán, a'an li ralal laj Matata. Ut laj Matata, a'an li ralal laj Natán. ");
INSERT INTO kekNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ut laj Natán, a'an li ralal laj David. Ut laj David, a'an li ralal laj Isaí. Ut laj Isaí, a'an li ralal laj Obed. Ut laj Obed, a'an li ralal laj Booz. Ut laj Booz, a'an li ralal laj Salmón. Ut laj Salmón, a'an li ralal laj Naasón. ");
INSERT INTO kekNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ut laj Naasón, a'an li ralal laj Aminadab. Ut laj Aminadab, a'an li ralal laj Aram. Ut laj Aram, a'an li ralal laj Esrom. Ut laj Esrom, a'an li ralal laj Fares. Ut laj Fares, a'an li ralal laj Judá. ");
INSERT INTO kekNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ut laj Judá, a'an li ralal laj Jacob. Ut laj Jacob, a'an li ralal laj Isaac. Ut laj Isaac, a'an li ralal laj Abraham. Ut laj Abraham, a'an li ralal laj Taré. Ut laj Taré, a'an li ralal laj Nacor. ");
INSERT INTO kekNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ut laj Nacor, a'an li ralal laj Serug. Ut laj Serug, a'an li ralal laj Ragau. Ut laj Ragau, a'an li ralal laj Peleg. Ut laj Peleg, a'an li ralal laj Heber. Ut laj Heber, a'an li ralal laj Sala. ");
INSERT INTO kekNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ut laj Sala, a'an li ralal laj Cainán. Ut laj Cainán, a'an li ralal laj Arfaxad. Ut laj Arfaxad, a'an li ralal laj Sem. Ut laj Sem, a'an li ralal laj Noé. Ut laj Noé, a'an li ralal laj Lamec. ");
INSERT INTO kekNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ut laj Lamec, a'an li ralal laj Matusalén. Ut laj Matusalén, a'an li ralal laj Enoc. Ut laj Enoc, a'an li ralal laj Jared. Ut laj Jared, a'an li ralal laj Mahalaleel. Ut laj Mahalaleel, a'an li ralal laj Cainán. ");
INSERT INTO kekNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ut laj Cainán, a'an li ralal laj Enós. Ut laj Enós, a'an li ralal laj Set. Ut laj Set, a'an li ralal laj Adán. Ut laj Adán, a'an li ralal li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Li Jesús nujenak chi Santil Musik'ej nak qui-el sa' li na'ajej cuan cui' li nima' Jordán. Li Santil Musik'ej quixc'ut chiru nak tento ta̱xic sa' li chaki ch'och' bar ma̱c'a' cui' cristian. ");
INSERT INTO kekNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ut aran quicuan ca'c'a̱l cutan. Ut laj tza quixyal ra̱lenquil. Abanan inc'a' quixq'ue rib chi a̱le̱c. Chiruheb li cutan a'an ma̱c'a' naxtzaca ut sa' xrakic li ca'c'a̱l cutan quichal xtz'ocajic. ");
INSERT INTO kekNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Laj tza quixye re: —Cui tz'akal ya̱l nak la̱at Ralal li Dios, suk'isi chok' caxlan cua li pec a'in, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Li Jesús quichak'oc ut quixye: —Tz'i̱banbil sa' li Santil Hu chi jo'ca'in: Ma̱cua' ca'aj cui' riq'uin li naxtzaca yo'yo̱k cui' li cui̱nk, chan. (Dt. 8:3a) ");
INSERT INTO kekNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tojo'nak laj tza quixc'am li Jesús sa' jun li tzu̱l k'axal najt xteram ut sa' li ho̱nal ajcui' a'an quixc'ut chiru chixjunileb li xni̱nkal ru tenamit li cuan sa' ruchich'och'. ");
INSERT INTO kekNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Laj tza quixye re li Jesús: —Tink'axtesi sa' a̱cuuk' li xni̱nkal ru tenamit a'an ut lix lok'al. Eb li tenamit a'an k'axtesinbileb sa' cuuk' la̱in ut naru ninq'ue re li ani tincuaj la̱in. ");
INSERT INTO kekNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Chixjunil a'an tinq'ue a̱cue cui la̱at ta̱cuik'ib a̱cuib chicuu ut tina̱lok'oni, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Quichak'oc li Jesús ut quixye re: —Elen chicuu la̱at aj tza xban nak jo'ca'in tz'i̱banbil sa' li Santil Hu: Li Ka̱cua' la̱ Dios ta̱lok'oni ut ca'aj cui' chiru a'an tatc'anjelak, chan. (Dt. 6:13) ");
INSERT INTO kekNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ut laj tza quixc'am li Jesús sa' li tenamit Jerusalén ut coxxakab toj takec' sa' xbe̱n li templo. Quixye re: —Cui tz'akal ya̱l nak la̱at Ralal li Dios, cut a̱cuib tak'a. ");
INSERT INTO kekNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ma̱c'a' ta̱c'ul xban nak jo'ca'in tz'i̱banbil sa' li Santil Hu: Tixtaklaheb lix ángel cha̱cuilbal. ");
INSERT INTO kekNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ut riq'uin ruk'eb tate'xchap re nak inc'a' ta̱toch' la̱ cuok chiru pec, chan. (Sal. 91:11-12) ");
INSERT INTO kekNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Li Jesús quichak'oc ut quixye re: —Tz'i̱banbil ajcui' sa' li Santil Hu chi jo'ca'in: Ma̱tz'a̱ma xmilagro li Ka̱cua' la̱ Dios yal chi ma̱c'a' rajbal. (Dt. 6:16) ");
INSERT INTO kekNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Quiril laj tza nak inc'a' quiru ra̱lenquil li Jesús, toj quixcanab cuan. ");
INSERT INTO kekNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ut quisuk'i li Jesús Galilea chi cuan xcuanquil li Santil Musik'ej riq'uin. Sa' chixjunil li na'ajej li cuanqueb chi xjun sutam li tenamit Galilea, que'rabi resil li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yo̱ chixch'olobanquil li xya̱lal sa' eb li cab li neque'xch'utub cui' ribeb laj judío. Ut chixjunileb yo̱queb chixq'uebal xlok'al. ");
INSERT INTO kekNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Sa' jun li cutan quicuulac li Jesús sa' li tenamit Nazaret li quiq'ui cui'. Sa' li hiloba̱l cutan co̱ sa' li cab li neque'xch'utub cui' ribeb laj judío jo' c'aynak xba̱nunquil. Ut quixakli chiruheb re ta̱ril xsa' li Santil Hu. ");
INSERT INTO kekNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Quiq'uehe' re li hu li quixtz'i̱ba li profeta Isaías. Nak quixte, quixtau aran li a̱tin li naxye chi jo'ca'in: ");
INSERT INTO kekNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Lix musik' li nimajcual Dios cuan cuiq'uin xban nak li Dios quixsic' cuu chixyebal li cha̱bil esil reheb li cuanqueb sa' neba'il. Quinixtakla chixcolbaleb li cuanqueb sa' raylal ut chixyebal resil nak te'ach'aba̱k li cuanqueb chi pre̱xil ut re ajcui' nak tinq'ueheb chi iloc li mutz' ut te'cuisi ajcui' sa' raylal li rahobtesinbileb. ");
INSERT INTO kekNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Quinixtakla xyebal resil nak ac xcuulac xk'ehil nak li Ka̱cua' tixcoleb lix tenamit. (Is. 61:1-2) ");
INSERT INTO kekNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nak quixbot li hu, quixk'axtesi re li nac'anjelac sa' li cab a'an ut quic'ojla chiruheb. Ut chixjunileb li cuanqueb aran que'cana chirilbal li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Quixye reheb: —Anakcuan xtz'akloc ru che̱ru li c'a'ru tz'i̱banbil chak sa' li Santil Hu a'in, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Chixjunileb li cuanqueb aran cha̱bil yo̱queb chixyebal chirix li Jesús ut sachso̱queb xch'o̱l chirabinquil li cha̱bil a̱tin li yo̱ chixyebal. Ut que'xye: —¿Ma ma̱cua' ta bi' a'in li ralal laj José? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ut li Jesús quixye reheb: —Ma̱re te̱ye cue jun li a̱tin li naxye: “At aj banonel, ban a̱cuib a̱junes. La̱o xkabi resil nak nabal li c'a'ak re ru xaba̱nu Capernaum. ¿C'a'ut nak inc'a' ta̱ba̱nu a'an arin sa' la̱ tenamit?” ma̱re cha'kex cue. ");
INSERT INTO kekNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ut quixye ajcui' reheb: —Chi ya̱l tinye a̱cue ma̱ jun profeta nac'ule' ta chi cha̱bil sa' lix tenamit. ");
INSERT INTO kekNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Relic chi ya̱l nak nabaleb li xma̱lca'an sa' li tenamit Israel nak quicuan laj Elías chok' profeta. Sa' eb li cutan a'an inc'a' quixq'ue hab chiru oxib chihab riq'uin cuakib po. Ut c'ajo' li cue'ej quicuan sa' li tenamit a'an. ");
INSERT INTO kekNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Usta ra que'xc'ul eb a'an, aban inc'a' quitakla̱c li profeta Elías chixtenk'anquileb li xma̱lca'an aj judío. Quitakla̱c ban chixtenk'anquil jun li xma̱lca'an li ma̱cua' aj judío cuan sa' li na'ajej Sarepta li cuan nach' riq'uin li tenamit Sidón. ");
INSERT INTO kekNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Jo'can ajcui' sa' eb li cutan nak cua̱nk chok' profeta laj Eliseo, nabaleb li saklep rixeb aran Israel. Abanan ma̱ jun reheb laj judío quiq'uirtesi̱c. Ca'aj cui' jun li cui̱nk li ma̱cua' aj judío. Li cui̱nk a'an aj Naamán xc'aba'. Siria xtenamit, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nak que'rabi li a̱tin a'in chixjunileb li ch'utch'u̱queb aran, c'ajo' nak que'josk'o'. ");
INSERT INTO kekNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Quilaje'cuacli chixjunileb li cuanqueb aran ut que'risi li Jesús sa' li tenamit ut que'xc'am toj sa' xbe̱n li tzu̱l li c'ojc'o cui' lix tenamiteb re nak te'xcut chak toj tak'a. ");
INSERT INTO kekNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Abanan li Jesús quinume' sa' xya̱nkeb ut co̱. ");
INSERT INTO kekNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Li Jesús co̱ sa' li tenamit Capernaum li cuan sa' xcue̱nt Galilea. Yo̱ chixch'olobanquil li xya̱lal chiruheb li tenamit sa' eb li hiloba̱l cutan sa' li cab li neque'xch'utub cui' ribeb laj judío. ");
INSERT INTO kekNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Naxc'ut li xya̱lal chiruheb chi cuan xcuanquil. Ut chixjunileb li yo̱queb chi abi̱nc re que'sach xch'o̱l chirabinquil li tijleb li yo̱ chixyebal xban nak naxc'ut li xya̱lal chiruheb chi cuan xcuanquil. ");
INSERT INTO kekNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Cuan jun li cui̱nk sa' xya̱nkeb cuan ma̱us aj musik'ej riq'uin. Qui-oc chixjapbal re chi cau ut quixye: ");
INSERT INTO kekNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Canabo kajunes. ¿C'a'ru ta̱cuaj kiq'uin, at Jesús aj Nazaret? ¿Ma xatchal chikasachbal? La̱in ninnau nak la̱at lix Santil Alal li Dios, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Abanan li Jesús quixk'us li ma̱us aj musik'ej ut quixye re: —La̱at ma̱us aj musik'ej, matchokin. Elen riq'uin li cui̱nk a'in, chan li Jesús. Ut li ma̱us aj musik'ej quixt'an li cui̱nk chiruheb a'an, ut qui-el riq'uin ut ma̱c'a' quixba̱nu re. ");
INSERT INTO kekNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Chixjunileb li que'iloc re, c'ajo' nak que'xucuac ut yo̱queb chixyebal chi ribileb rib: —¿C'a'ru xya̱lal a'in? ¿C'a'ru li tijleb a'in? Li cui̱nk a'in cuan xcuanquil sa' xbe̱neb li ma̱us aj musik'ej ut li c'a'ru naxye, a'an neque'xba̱nu, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ut que'rabi resil sa' chixjunileb li tenamit xcue̱nt Galilea c'a'ru quixba̱nu li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Nak qui-el sa' li cab li neque'xch'utub cui' ribeb laj judío, li Jesús co̱ sa' li rochoch laj Simón. Lix na' li rixakil laj Simón yocyo. Yo̱ xtik. Que'xtz'a̱ma chiru li Jesús nak tixq'uirtesi. ");
INSERT INTO kekNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Li Jesús quijiloc riq'uin li yaj ut quixq'uirtesi. Ut sa' ajcui' li ho̱nal a'an quicuacli li ixk ut qui-oc chi c'anjelac chiruheb. ");
INSERT INTO kekNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nak ac yo̱ chi ecuu̱c, chixjunileb li cuanqueb xyaj, a' yal c'a'ru xyajeleb, quilaje'xc'am chak riq'uin li Jesús. Ut a'an quixq'ue li ruk' sa' xbe̱neb ut quixq'uirtesiheb. ");
INSERT INTO kekNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ut nabaleb ajcui' li quirisi ma̱us aj musik'ej riq'uineb. Li ma̱us aj musik'ej nak neque'el riq'uineb, japjo̱queb re chixyebal: —La̱at Ralal li Dios, chanqueb. Abanan li Jesús quixk'useb ut inc'a' quixcanabeb chi a̱tinac xban nak eb a'an que'xnau nak a'an li Cristo, laj Colonel li yechi'inbil xban li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Cuulajak chic nak ac xsake̱u, li Jesús co̱ sa' jun na'ajej bar ma̱c'a' cuan. Ut eb li tenamit yo̱queb chixsic'bal. Que'cuulac toj bar cuan cui' a'an ut que'raj raj nak quicana riq'uineb. Inc'a' raj que'raj nak ta̱xic. ");
INSERT INTO kekNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Abanan li Jesús quixye reheb: —Tento nak tinxic sa' jalan tenamit chixch'olobanquil li cha̱bil esilal chirix lix nimajcual cuanquilal li Dios xban nak a'an aj e nak xintakla̱c chak arin, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ut yo̱ chixch'olobanquil lix ya̱lal sa' eb li cab li neque'xch'utub cui' ribeb laj judío aran Galilea. ");
INSERT INTO kekNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Sa' jun li cutan li Jesús cuan chire li palau Genesaret ut k'axal cui'chic nabal li tenamit que'ch'utla chirabinquil li ra̱tin li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Quiril cuib li jucub cuan chire li palau. Eb laj car ma̱ aniheb chi sa'. Yo̱queb chak chixch'ajbal lix yoy. ");
INSERT INTO kekNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Qui-oc li Jesús sa' jun li jucub. Li jucub a'an re laj Simón. Li Jesús quixtz'a̱ma chiru laj Simón nak tixjil ca'ch'inak li jucub sa' li ha'. Ut quic'ojla sa' li jucub ut qui-oc chixch'olobanquil lix ya̱lal chiruheb li tenamit li cuanqueb chire li palau. ");
INSERT INTO kekNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ut nak ac xrake' chi a̱tinac, quixye re laj Simón: —C'am li jucub sa' xchamal li ha' ut ta̱q'ue la̱ yoy sa' li ha' re nak ta̱chap la̱ car, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Quichak'oc laj Simón ut quixye re: —At tzolonel, chixjunil li k'ojyi̱n xkaq'ue li kayoy sa' li ha' ut ma̱ jun li car xkachap. Abanan xban nak la̱at xatyehoc cue, tinq'ue cui'chic lin yoy sa' li ha', chan. ");
INSERT INTO kekNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nak que'xq'ue lix yoy sa' li ha', k'axal cui'chic nabal li car que'xchap ut yo̱ chi pejec' lix yoyeb. ");
INSERT INTO kekNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ut que'xc'ut ruk'eb chiruheb li rochben li cuanqueb sa' li jucub jun chic re xbokbaleb re nak te'cha̱lk chixtenk'anquil. Ut eb a'an que'chal ut que'xnujtesi xcabichal li jucub ut ca'ch'in chic ma̱ nasubun sa' li ha' xban xq'uial li car. ");
INSERT INTO kekNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nak quiril chixjunil a'in laj Simón Pedro, quixcuik'ib rib chiru li Jesús ut quixye re: —Canabin injunes, at Ka̱cua'. Ma̱cua' inc'ulub nak cua̱nkat cuiq'uin xban nak la̱in jun cui̱nk aj ma̱c, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ut quisach xch'o̱l laj Simón jo'queb ajcui' li cuanqueb rochben xban nak k'axal cui'chic nabal li car que'xchap. ");
INSERT INTO kekNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ut jo'can ajcui' laj Jacobo ut laj Juan, eb li ralal laj Zebedeo. A'an eb li rochben laj Simón. Ut li Jesús quixye re laj Simón: —Matc'oxlac. Chalen anakcuan ma̱cua' chic caribc ta̱ba̱nu. A̱cuas a̱cui̱tz'in ban chic ta̱sic' re te'pa̱ba̱nk, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ut que'xc'am li jucub chire li palau ut aran que'xcanab chixjunil ut que'xta̱ke li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nak cuan li Jesús sa' jun li tenamit, quicuulac jun li cui̱nk riq'uin saklep rix. Nak quiril li Jesús quixxulub rib sa' ch'och', ut quixtz'a̱ma chiru li Jesús ut quixye re: —Ka̱cua', la̱in ninnau nak la̱at naru tina̱q'uirtesi. Cui ta̱ba̱nu li usilal, china̱q'uirtesi, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Li Jesús quixch'e' li cui̱nk riq'uin ruk' ut quixye re: —La̱in tincuaj nak tatq'uira̱k. Anakcuan tatinq'uirtesi, chan. Ut sa' ajcui' li ho̱nal a'an quiq'uira li cui̱nk. ");
INSERT INTO kekNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ut li Jesús quixye re: —Ma̱ ani aj e ta̱serak'i chanru nak xatq'uira. Ayu ban riq'uin laj tij re nak a'an ta̱ril nak xatq'uira. Ut ta̱q'ue la̱ mayej jo' naxye sa' lix chak'rab laj Moisés chok' retalil chiruheb chixjunileb nak xatq'uira, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Abanan yalak bar yo̱ chi abi̱c resil chixjunil li c'a'ru yo̱ chixba̱nunquil li Jesús. Nabaleb li tenamit neque'xch'utub ribeb chirabinquil li c'a'ru naxye ut re ajcui' nak te'q'uirtesi̱k. ");
INSERT INTO kekNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ut li Jesús rajlal naxic xjunes chi tijoc sa' eb li na'ajej bar ma̱c'a' cuan. ");
INSERT INTO kekNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Sa' jun li cutan nak li Jesús yo̱ chixch'olobanquil lix ya̱lal chiruheb li tenamit cuanqueb cuib oxib laj fariseo sa' xya̱nkeb. Ut cuanqueb ajcui' aj tzolol chak'rab. Que'chal chak sa' eb li na'ajej Galilea, Judea ut Jerusalén. Ut li Jesús yo̱ chixq'uirtesinquileb li yaj riq'uin xcuanquil li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Sa' li ho̱nal a'an que'cuulac cuib oxib li cui̱nk ut yo̱queb chixc'ambal jun li cui̱nk sic li rok ut sic li ruk' yocyo chiru lix cuarib. Ut te'raj rocsinquil li cui̱nk cuan cui' li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Abanan que'ril nak inc'a' que'ru chi oc sa' li cab xban li q'uila tenamit. Jo'can nak que'take' sa' xbe̱n li cab. Que'xte ca'ch'in li xbe̱n li cab ut aran que'xcubsi li yaj chi yocyo sa' lix cuarib. Coxe'xq'ue sa' xyiheb li tenamit bar cuan cui' li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Quixq'ue retal li Jesús nak eb li cui̱nk a'an que'xpa̱b nak naru tixq'uirtesi li yaj. Jo'can nak quixye re li yaj: —At cui̱nk, cuybil sachbil chic la̱ ma̱c, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ut eb laj fariseo ut eb laj tzolol chak'rab que'oc chixyebal chi ribileb rib: —¿Ani li cui̱nk a'an nak naxjuntak'e̱ta rib riq'uin li Dios nak naxye chi jo'can? ¿Ma a'an ta bi' li Dios? ¿Ma ma̱cua' ta bi' ca'aj cui' li Dios naru nacuyuc ma̱c? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Quixnau li Jesús c'a'ru yo̱queb chixc'oxlanquil. Quichak'oc ut quixye reheb: —¿C'a'ut nak yo̱quex chixc'oxlanquil chi jo'can? ");
INSERT INTO kekNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Bar cuan li us tinye re li yaj re nak ta̱c'utu̱nk che̱ru nak cuan incuanquil? ¿Ma tinye re, “cuybil sachbil la̱ ma̱c” malaj ut tinye re, “tatinq'uirtesi”? ");
INSERT INTO kekNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","La̱in tinc'ut che̱ru nak la̱in li Cristo li C'ajolbej ut cuan incuanquil sa' ruchich'och' chixcuybal xsachbal li ma̱c, chan reheb. Tojo'nak li Jesús quixye re li yaj, —At cui̱nk, la̱in tinye a̱cue, cuaclin, c'am la̱ cuarib ut ayu sa' la̱ cuochoch, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ut sa' ajcui' li ho̱nal a'an li cui̱nk li yaj nak quicuan quicuacli chiruheb chixjunileb li cuanqueb aran. Quixchap lix cuarib ut yo̱ chixlok'oninquil li Dios nak co̱ sa' rochoch. ");
INSERT INTO kekNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ut chixjunileb li cuanqueb aran sachso̱queb xch'o̱l que'cana chirilbal li quic'ulman. Que'xlok'oni li Dios ut yo̱ xc'a'uxeb nak que'xye: —Sachba ch'o̱lej li xkil anakcuan, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nak qui-el sa' li tenamit a'an, li Jesús quixtau jun li cui̱nk aj titz'ol toj aj Leví xc'aba'. Chunchu cuan cui' li me̱x li neque'c'uluc cui' toj. Li Jesús quixye re: —China̱ta̱ke, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Quicuacli laj Leví. Quixcanab chixjunil ut quixta̱ke li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Quixba̱nu jun li nimla nink'e laj Leví chok' re li Jesús. Cuanqueb nabaleb xcomoneb laj titz'ol toj ut cuanqueb ajcui' nabaleb jalan chic chi cua'ac sa' li me̱x rochbeneb. ");
INSERT INTO kekNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Eb laj fariseo ut eb laj tzolol chak'rab que'oc chixcuech'inquil rixeb lix tzolom li Jesús ut que'xye reheb: —¿C'a'ut nak nequexcua'ac ut nequex-uc'ac rochbeneb laj titz'ol toj ut rochbeneb laj ma̱c? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Li Jesús quixye reheb: —Li cauheb ma̱c'a' na-oc cui' aj banonel reheb. Aban li yajeb, a'aneb li te'raj banec'. ");
INSERT INTO kekNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Jo'can nak la̱in inc'a' xinchal chixsic'bal li ti̱queb xch'o̱l. Xinchal ban chixsic'baleb laj ma̱c re nak te'yot'ek' xch'o̱l ut te'xjal xc'a'uxeb, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ut que'xye cui'chic re li Jesús: —Eb lix tzolom laj Juan rajlal neque'xba̱nu x-ayu̱n ut rajlal neque'tijoc. Jo'can ajcui' neque'xba̱nu lix tzolomeb laj fariseo. Ut eb la̱ tzolom la̱at, ¿c'a'ut nak inc'a' neque'xba̱nu chi jo'can? Eb a'an neque'cua'ac neque'uc'ac chi ma̱c'a'eb xc'a'ux, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Tojo'nak quichak'oc li Jesús ut quixye reheb: —La̱in jo' jun be̱lomej nak cuanquin. ¿Ma naru te'ayunik li neque'xic riq'uin sumla̱c nak cuan li be̱lomej riq'uineb? Nak toj cuan li be̱lomej riq'uineb inc'a' naru neque'xba̱nu x-ayu̱n. ");
INSERT INTO kekNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ut jo'can ajcui' lin tzolom. Ta̱cuulak xk'ehil nak tin-isi̱k sa' xya̱nkeb. Toj sa' li cutan a'an te'xba̱nu x-ayu̱n, chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ut li Jesús quixye cui'chic reheb li jaljo̱quil ru a̱tin a'in: Ma̱ ani naxxi̱ti junak k'el t'icr riq'uin ac' t'icr. Cui ut naxxi̱ti riq'uin ac' t'icr, naxnimobresi xpejelal li k'el t'icr. Ut inc'a' naxc'am rib li ac' t'icr riq'uin li k'el. ");
INSERT INTO kekNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ut ma̱ ani naq'uehoc ac' vino sa' junak k'el bo̱ls tz'u̱m. Cui tixq'ue li ac' vino sa' junak k'el bo̱ls tz'u̱m, ta̱puq'uek' li k'el tz'u̱m ut ta̱hoyek' li vino. Ta̱sachk li vino ut ta̱sachk ajcui' li bo̱ls tz'u̱m. ");
INSERT INTO kekNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Jo'can nak li ac' vino sa' li ac' bo̱ls tz'u̱m naq'ueman re nak ma̱c'a' tixc'ul li vino chi moco li bo̱ls tz'u̱m. ");
INSERT INTO kekNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ut li ani ac xruc' li vino re junxil inc'a' chic ta̱raj ruc'bal li ac' vino, xban nak neque'xc'oxla nak li vino re junxil, a'an li cha̱bil, chan li Jesús reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sa' jun li hiloba̱l cutan li Jesús yo̱ chi numec' sa' jun si̱r li acui̱mk trigo rochbeneb lix tzolom. Eb lix tzolom que'xch'ot ru li trigo nak yo̱queb chi numec' ut que'risi li rix sa' ruk'eb ut que'xcua'. ");
INSERT INTO kekNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Cuanqueb cuib oxib eb laj fariseo que'ril nak yo̱queb chixsic'bal ru li trigo. Que'xye reheb: —¿C'a'ut nak yo̱quex chixsic'bal ru li trigo sa' li hiloba̱l cutan? ¿C'a'ut nak nequeba̱nu li c'anjel moco uxc ta naraj sa' li hiloba̱l cutan? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Li Jesús quichak'oc ut quixye reheb: —¿Ma ma̱ jun cua e̱rilom sa' li Santil Hu li c'a'ru quixba̱nu laj David nak a'an ut eb li rochben te'tz'oca̱k? ");
INSERT INTO kekNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Laj David qui-oc sa' li rochoch li Dios ut quixchap li caxlan cua li ac mayejanbil chiru li Dios. Juneseb raj laj tij naru te'tzaca̱nk re li caxlan cua a'an. Abanan laj David quixcua' ut quixq'ue ajcui' reheb li cuanqueb rochben xban nak te'tz'oca̱k. ");
INSERT INTO kekNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ut li Jesús quixye cui'chic reheb: —Jo'can nak la̱in li C'ajolbej cuan incuanquil chixyebal c'a'ru ta̱uxma̱nk sa' li hiloba̱l cutan, chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sa' jun chic li hiloba̱l cutan qui-oc li Jesús sa' li cab li neque'xch'utub cui' ribeb laj judío ut quixch'olob lix ya̱lal chiruheb li tenamit. Aran cuan jun li cui̱nk sic lix nim uk'. ");
INSERT INTO kekNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Cuanqueb cuib oxib aj fariseo ut aj tzolol chak'rab aran. Yo̱queb chirilbal ma tixq'uirtesi tana li ruk' li cui̱nk a'in sa' li hiloba̱l cutan re nak naru te'xjit li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Li Jesús quixnau c'a'ru yo̱queb chixc'oxlanquil. Jo'can nak quixye re li cui̱nk li sic ruk': —Cuaclin. Xakab a̱cuib chiruheb, chan. Ut li cui̱nk quicuacli ut quixakli chiruheb. ");
INSERT INTO kekNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Li Jesús quixye reheb: —Cuan c'a'ru nacuaj xpatz'bal e̱re. ¿C'a'ru us xba̱nunquil sa' li hiloba̱l cutan? ¿Ma naru xba̱nunquil li us malaj li inc'a' us? ¿Ma us xcolbal xyu'am junak malaj xsachbal? chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Li Jesús quicana chirilbaleb chixju̱nkaleb, ut quixye re li cui̱nk li sic ruk': —Ye' la̱ cuuk', chan. Ut li cui̱nk quixye' li ruk' ut sa' ajcui' li ho̱nal a'an quiq'uira li ruk'. ");
INSERT INTO kekNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","C'ajo' nak que'josk'o' eb laj fariseo ut laj tzolol chak'rab, ut que'oc chixyebal chi ribileb rib chanru nak te'xjit li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Sa' jun li cutan co̱ li Jesús chi tijoc sa' xbe̱n jun li tzu̱l. Quixnumsi li k'ojyi̱n chi tijoc chiru li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nak ac xsake̱u quixbokeb lix tzolom ut quixsic' ruheb li cablaju sa' xya̱nkeb ut quixq'ueheb chok' apóstol. A'aneb a'in li apóstol li quixsic' ruheb: ");
INSERT INTO kekNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","laj Simón li quixq'ue ajcui' Pedro chok' xc'aba'; laj Andrés li ri̱tz'in laj Pedro; laj Jacobo; laj Juan; laj Felipe; laj Bartolomé; ");
INSERT INTO kekNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","laj Mateo; laj Tomás; laj Jacobo li ralal laj Alfeo; laj Simón li neque'xye ajcui' Zelote re; ");
INSERT INTO kekNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","laj Judas li ri̱tz'in laj Jacobo ut laj Judas Iscariote li quik'axtesin re li Jesús mokon sa' ruk'eb li xic' neque'iloc re. ");
INSERT INTO kekNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Li Jesús quicube sa' li tzu̱l rochbeneb lix tzolom ut quicana sa' jun na'ajej tak'a ru rochbeneb lix q'uialeb chic lix tzolom ut li q'uila tenamit li que'chal chak sa' eb li tenamit Judea ut Jerusalén. Ut cuan ajcui' li que'chal sa' eb li tenamit li cuanqueb chire li palau jo' Tiro ut Sidón. Quilaje'chal re nak te'rabi li c'a'ru tixye li Jesús ut re ajcui' nak li Jesús tixq'uirtesiheb li yaj. ");
INSERT INTO kekNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ut quixq'uirtesiheb ajcui' li cuanqueb ma̱us aj musik'ej riq'uineb. ");
INSERT INTO kekNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ut li q'uila tenamit te'raj xch'e'bal li Jesús re nak te'q'uirtesi̱k. A'an naxq'uirtesiheb riq'uin lix cuanquilal. ");
INSERT INTO kekNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ut li Jesús quirileb lix tzolom ut qui-oc chixyebal: —Us xak e̱re la̱ex li neba'ex, xban nak cuanquex chic rubel xcuanquil li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Us xak e̱re la̱ex li textz'oca̱k anakcuan xban nak ta̱c'ojoba̱k e̱ch'o̱l. Us xak e̱re la̱ex li yo̱quex chi ya̱bac anakcuan xban xrahil e̱ch'o̱l xban nak sa' jun cutan texse'ek xban xsahil e̱ch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Us xak e̱re la̱ex nak xic' tex-ilek' sa' inc'aba' la̱in li C'ajolbej. Us xak e̱re la̱ex nak tex-isi̱k sa' xya̱nkeb ut texhobek' sa' inc'aba' la̱in ut ta̱yehek' e̱re nak inc'a' us e̱na'leb. ");
INSERT INTO kekNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Chisahok' sa' e̱ch'o̱l nak te'xba̱nu e̱re chi jo'can. Chic'ojla̱k e̱ch'o̱l xban nak cuan jun le̱ k'ajca̱munquil riq'uin li Dios sa' choxa. Jo'can ajcui' nak que'xtz'ekta̱na eb li profeta junxil eb lix xe'to̱nil xyucua'eb li tenamit a'in. ");
INSERT INTO kekNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Abanan, la̱ex li biomex raylal cha̱lel sa' e̱be̱n xban nak ac xec'ojob e̱ch'o̱l arin sa' ruchich'och'. ");
INSERT INTO kekNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Raylal cha̱lel sa' e̱be̱n la̱ex li cuan nabal c'a'ru e̱re xban nak ta̱cuulak xk'ehil nak ma̱c'a' chic cua̱nk e̱re re textzaca̱nk. Raylal cha̱lel sa' e̱be̱n la̱ex li nequexse'ec anakcuan xban xsahil e̱ch'o̱l xban nak mokon texya̱bak xban xrahil e̱ch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Raylal cha̱lel sa' e̱be̱n la̱ex li naq'uehe' e̱lok'al arin sa' ruchich'och' xbaneb li tenamit. Jo'ca'in ajcui' nak que'q'uehe' xlok'al eb li profeta aj balak' xbaneb le̱ xe'to̱nil yucua'. ");
INSERT INTO kekNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ut la̱ex li yo̱quex chi abi̱nc re li yo̱quin chixyebal, cheq'uehak retal li tinye e̱re. Cherahakeb li xic' neque'iloc e̱re. Ut cheba̱nuhak usilal reheb li neque'tz'ekta̱nan e̱re. ");
INSERT INTO kekNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Chetz'a̱ma̱k rusilal li Dios sa' xbe̱neb li neque'ma̱usilan e̱re. Ut chextijok ajcui' chirixeb li neque'hoboc e̱re. ");
INSERT INTO kekNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Cui ani ta̱sac'ok xnak' a̱cuu, q'ue li jun pac'al re, re tixsac'. Cui ani ta̱raj xmak'bal la̱ chaque̱t, q'ue ajcui' la̱ cami̱s re. ");
INSERT INTO kekNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Li ani tixtz'a̱ma c'a'ru re a̱cue, q'ue re. Ut cui ani tixmak' c'a'ru a̱cue cha̱cuu, ma̱patz' chic re̱kaj re. ");
INSERT INTO kekNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Cui la̱ex te̱raj nak cha̱bilakeb le̱ ras e̱ri̱tz'in e̱riq'uin, cha̱bilakex ajcui' la̱ex riq'uineb a'an. ");
INSERT INTO kekNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Cui ca'aj cui' li ani narahoc e̱re nequera, ma̱c'a' xjalanil li yo̱quex chixba̱nunquil, riq'uin li neque'xba̱nu li ma̱ji' neque'pa̱ban xban nak ca'aj cui' li ani narahoc reheb neque'xra. ");
INSERT INTO kekNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Cui ca'aj cui' li neque'ba̱nun usilal e̱re, nequeba̱nu usilal reheb, ma̱c'a' xjalanil li yo̱quex chixba̱nunquil riq'uin li neque'xba̱nu li ma̱ji' neque'pa̱ban. Xban nak ca'aj cui' li ani naba̱nun usilal reheb neque'xba̱nu usilal re. ");
INSERT INTO kekNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Cui la̱ex nequeto'oni tumin ca'aj cui' reheb li nequenau nak te'xq'ue re̱kaj, ma̱c'a' xjalanil li yo̱quex chixba̱nunquil riq'uin li neque'xba̱nu li toj ma̱ji' neque'pa̱ban xban nak neque'xto'oni tumin ca'aj cui' reheb li neque'xnau nak te'xq'ue re̱kaj. ");
INSERT INTO kekNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Jo'can ut nak cherahakeb li ani xic' neque'iloc e̱re. Cheba̱nuhak usilal reheb. Ut cheq'uehak chi to' re li c'a'ru tixpatz' e̱re chi inc'a' te̱roybeni re̱kaj. Cui te̱ba̱nu a'an, k'axal nim le̱ k'ajca̱munquil li ta̱q'uehek' e̱re ut la̱exak li ralal xc'ajol li nimajcual Dios. A'an k'axal nim xcuyum sa' xbe̱neb li inc'a' useb xna'leb li inc'a' neque'xnau bantioxi̱nc. ");
INSERT INTO kekNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Chex-uxta̱na̱nk bi' u xban nak le̱ yucua' cuan sa' choxa na-uxta̱nan u. ");
INSERT INTO kekNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Mextz'iloc a̱tin chirixeb le̱ ras e̱ri̱tz'in re nak li Dios inc'a' ta̱tz'ilok a̱tin che̱rix la̱ex. Me̱tz'ekta̱na le̱ ras e̱ri̱tz'in re nak li Dios inc'a' textz'ekta̱na la̱ex. Checuyak xma̱queb le̱ ras e̱ri̱tz'in re nak li Dios tixcuy e̱ma̱c la̱ex. ");
INSERT INTO kekNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Chesi c'a'ru re le̱ ras e̱ri̱tz'in ut li Dios tixq'ue re̱kaj e̱re. Tixq'ue re̱kaj e̱re chi nabal chiru li xeq'ue la̱ex. Tixq'ue chi nujenak li bisleb, chi yo̱k chi pajec' xban nak k'axal cui'chic nabal li tixq'ue e̱re. Riq'uin li bisleb li texbisok cui' la̱ex, a'an ajcui' li ta̱bisek' cui' li ta̱q'uehek' e̱re, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Li Jesús quixye li jaljo̱quil ru a̱tin a'in reheb li tenamit ut quixye: —Junak mutz', ¿Ma naru ta bi' tixc'ut xbe junak chic mutz'? ¿Ma inc'a' ta bi' sa' cuibal te't'anek' sa' jul xban nak mutz'eb? ");
INSERT INTO kekNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ma̱ jun aj tzolonel naxk'ax xcuanquil laj tzolol re. Abanan nak acak xtzol rib chi tz'akal, tixtau ajcui' xcuanquil laj tzolol re. ");
INSERT INTO kekNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿C'a'ut nak nacaq'ue retal li c'aj che' cuan sa' xnak' ru la̱ cuas a̱cui̱tz'in ut inc'a' nacaq'ue retal li tz'amba cuan sa' xnak' a̱cuu la̱at? ");
INSERT INTO kekNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Chanru nak ta̱ye re la̱ cuas a̱cui̱tz'in, “Cuisihak li c'aj che' sa' xnak' a̱cuu”, nak toj cuan li tz'amba sa' xnak' a̱cuu la̱at? At aj ca'pac'al u, xbe̱n cua isi li tz'amba cuan sa' li xnak' a̱cuu la̱at, re nak tat-ilok chi tz'akal re risinquil li c'aj che' cuan sa' xnak' ru la̱ cuas a̱cui̱tz'in. ");
INSERT INTO kekNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jo'can ajcui' riq'uin li che'. Cui cha̱bil junak che', cha̱bil ajcui' li ru naru̱chin. Ut cui inc'a' us li che', li ru li naru̱chin inc'a' ajcui' us. Li cha̱bil che' inc'a' naru naru̱chin li inc'a' us, chi moco li che' inc'a' us naru naru̱chin li us. ");
INSERT INTO kekNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ut riq'uin li ru naru̱chin nanauman ru li che'. Li tun q'uix inc'a' naru naru̱chin li higos chi moco li q'uix naru naru̱chin li uvas. ");
INSERT INTO kekNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Jo'can ajcui' riq'uin li cristian. Li ani cha̱bil, cha̱bil ajcui' lix yehom xba̱nuhom xban nak cuan li cha̱bilal riq'uin. Ut li ani inc'a' cha̱bil, inc'a' cha̱bil lix yehom xba̱nuhom xban nak ma̱c'a' li cha̱bilal riq'uin. Riq'uin li ra̱tin li junju̱nk nac'utun chanru li ra̱m. ");
INSERT INTO kekNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿C'a'ut nak nequeye, “Ka̱cua', Ka̱cua'” cue cui inc'a' nequeba̱nu li c'a'ru ninye? ");
INSERT INTO kekNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Jo'can nak li ani na-abin re li cua̱tin ut naxba̱nu li c'a'ru ninye, li jun a'an tinjuntak'e̱ta riq'uin jun li cui̱nk quixyi̱b li rochoch. ");
INSERT INTO kekNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Quixbec chi cham ut quixq'ue li cimiento sa' xbe̱n li pec. Quichal li hab ut quibut'ir li nima'. Coxsac' rib li ha' chiru li cab ut inc'a' quirec'asi li cab sa' xna'aj xban nak yi̱banbil chi us sa' xbe̱n pec. ");
INSERT INTO kekNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ut li ani na-abin re li cua̱tin ut inc'a' naxba̱nu li c'a'ru ninye, li jun a'an tinjuntak'e̱ta riq'uin li cui̱nk li quixyi̱b li rochoch sa' xbe̱n ch'och' ut inc'a' quixbec xna'aj lix cimiento. Nak quibut'ir li nima', li ha' coxsac' rib chiru li cab. Quit'ane' li cab ut quisach chi jun aj cua, chan li Jesús reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nak quirake' xch'olobanquil lix ya̱lal chiruheb li tenamit, li Jesús co̱ Capernaum. ");
INSERT INTO kekNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ut aran cuan jun li capitán aj Roma cuan jun lix mo̱s k'axal naxra. Yaj ut ca̱mc re. ");
INSERT INTO kekNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Li capitán quirabi resil nak cuan li Jesús aran. Quixtaklaheb cuib oxib laj judío xcomoneb li neque'c'amoc be sa' li tenamit re nak te'xtz'a̱ma chiru li Jesús nak ta̱xic sa' rochoch li capitán chixq'uirtesinquil lix mo̱s. ");
INSERT INTO kekNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Que'cuulac riq'uin li Jesús ut que'xtz'a̱ma chiru nak tixba̱nu li yo̱ chixtz'a̱manquil li capitán. Que'xye re li Jesús: —Us cui ta̱ba̱nu li usilal re li capitán, ");
INSERT INTO kekNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","xban nak a'an nocoxra la̱o aj judío ut a'an quitaklan re xyi̱banquil li cab nakach'utub cui' kib, chanqueb re li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ut li Jesús co̱ chirixeb. Nak ac cuulaqueb re cuan cui' li rochoch, li capitán quixtaklaheb li rami̱g chi a̱tinac riq'uin li Jesús ut que'xye re: —Jo'ca'in xye li capitán a̱cue: Ma̱ch'i'ch'i'i a̱cuib chi cha̱lc sa' cuochoch xban nak moco inc'ulub ta nak tatcha̱lk sa' cuochoch. ");
INSERT INTO kekNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Jo'can nak inc'a' xco̱in la̱in chi a̱tinac a̱cuiq'uin. Ninnau nak moco inc'ulub ta nak tincuulak a̱cuiq'uin. Ca'aj cui' nacuaj nak ta̱ye nak ta̱q'uira̱k lin mo̱s ut ninnau nak ta̱q'uira̱k. ");
INSERT INTO kekNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","La̱in cuan ani nataklan cue ut cuanqueb lin soldado rubel incuanquil. Nak ninye re li jun “ayu”, naxic. Ut nak ninye re li jun chic “quim”, nachal. Ut nak ninye re lin mo̱s, “ba̱nu a'in”, naxba̱nu, chan li capitán. ");
INSERT INTO kekNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nak li Jesús quirabi a'in, quisach xch'o̱l ut quixye reheb li cuanqueb rochben: —Relic chi ya̱l tinye e̱re nak ma̱ jun intauhom chi moco sa' xya̱nkeb laj Israel cuan tz'akal xpa̱ba̱l jo' li jun a'in, usta ma̱cua' aj judío, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nak que'cuulac eb li takl sa' rochoch li capitán, ac xq'uira chic lix mo̱s. ");
INSERT INTO kekNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Chirix a'in li Jesús qui-el Capernaum ut co̱ sa' jun chic li tenamit Naín xc'aba' rochbeneb lix tzolom. Ut cuanqueb ajcui' nabaleb li tenamit yo̱queb chi xic chirix. ");
INSERT INTO kekNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nak yo̱ chi cuulac cuan cui' li oqueba̱l re li tenamit quiril nak nabaleb li cristian yo̱queb chi xic chixmukbal jun li camenak. Li camenak a'an xyum jun li xma̱lca'an. Jun ajcui' chiru nak quicuan. ");
INSERT INTO kekNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nak li Ka̱cua' Jesús quiril li xna' li camenak, quiril xtok'oba̱l ru ut quixye re: —Matya̱bac, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Li Jesús quinach'oc riq'uineb ut quixch'e' li tusbil che' li yo̱queb chixpakonquil cui' li camenak. Ut eb li yo̱queb chi c'amoc re li camenak que'xakli ut li Jesús quixye re li camenak: —At sa̱j cui̱nk, la̱in tinye a̱cue, cuaclin, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ut li camenak quicuacli ut quichunla ut qui-oc chi a̱tinac riq'uineb. Ut li Jesús quixk'axtesi re lix na'. ");
INSERT INTO kekNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nak que'ril li c'a'ru quic'ulman chixjunileb li cuanqueb aran, c'ajo' nak que'xucuac ut que'oc chixq'uebal xlok'al li Dios. Ut que'xye: —Jun xnimal ru profeta xc'ulun sa' kaya̱nk.— Ut que'xye ajcui': —Li Dios xchal chixtenk'anquil lix tenamit, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ut qui-abi̱c resil li c'a'ru quixba̱nu li Jesús sa' chixjunil li na'ajej Judea jo' ajcui' sa' eb li na'ajej li cuanqueb chi xjun sutam. ");
INSERT INTO kekNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Lix tzolom laj Juan laj Cubsihom Ha' que'xserak'i re c'a'ru yo̱ chi c'ulma̱nc. Nak ac xrabi a'an, laj Juan quixtakla cuib lix tzolom riq'uin li Jesús chixpatz'bal re: ");
INSERT INTO kekNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","—¿Ma la̱at laj Colonel li yechi'inbil li yo̱co chiroybeninquil? ¿Malaj toj takoybeni junak chic?— ");
INSERT INTO kekNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nak que'cuulac lix tzolom laj Juan riq'uin li Jesús, que'xye re: —Xoxtakla chak laj Juan laj Cubsihom Ha' a̱cuiq'uin chixpatz'bal a̱cue, “¿Ma la̱at laj Colonel li yechi'inbil li yo̱co chiroybeninquil? ¿Malaj ut toj takoybeni junak chic?” chanqueb re li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ut sa' li ho̱nal a'an li Jesús yo̱ chixq'uirtesinquileb nabaleb li cristian li cuanqueb sa' raylal. Cuanqueb li yaj quixq'uirtesiheb. Ut cuanqueb li cuan ma̱us aj musik'ej riq'uin ut li Jesús quirisi li ma̱us aj musik'ej riq'uineb. Ut cuanqueb nabaleb li mutz' li quixq'ueheb chi iloc. ");
INSERT INTO kekNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ut li Jesús quixye reheb: —Ayukex ut te̱serak'i re laj Juan li c'a'ru xeril ut li c'a'ru xerabi. Yehomak re nak eb li mutz' neque'iloc chic; eb li ye̱k rok neque'be̱c chic; eb li saklep rix q'uirtesinbileb chic; eb li tz'ap xic neque'abin chic; eb li camenak xe'cuaclesi̱c cui'chic chi yo'yo ut eb li neba' yo̱queb chirabinquil resil li usilal. ");
INSERT INTO kekNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Us xak reheb li ani inc'a' ta̱ch'ina̱nk xch'o̱l chinpa̱banquil, cha'kex re, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ut nak que'el lix takl laj Juan riq'uin, li Jesús qui-oc chi a̱tinac riq'uineb li tenamit chirix laj Juan ut quixye chi jo'ca'in: —¿C'a'ru queril chak sa' li chaki ch'och' nak co̱ex chirilbal laj Juan? ¿Ma junak cui̱nk nacuiban xch'o̱l chanchan li caxlan aj yo̱ rec'asinquil xban ik' queril chak? ");
INSERT INTO kekNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿C'a'ru queril chak? ¿Ma junak cui̱nk cha̱bil xtikibanquil queril chak? Li cha̱bileb rak' ut li cuanqueb sa' sahil ch'o̱lej, eb a'an sa' rochoch eb li rey cuanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿C'a'ru queril chak? ¿Ma junak profeta queril chak? Ya̱l nak a'an jun profeta. Abanan la̱in tinye e̱re nak li jun a'in naxk'ax ru xcuanquil junak profeta. ");
INSERT INTO kekNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Chirix laj Juan tz'i̱banbil sa' li Santil Hu li naxye chi jo'ca'in: A'ut la̱in tintakla lin takl aj c'amol be cha̱cuu. A'an ta̱ch'oloba̱nk xya̱lal chiruheb li tenamit re nak eb a'an yo'on cua̱nkeb cha̱c'ulbal la̱at. (Mal. 3:1) ");
INSERT INTO kekNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Relic chi ya̱l tinye e̱re nak ma̱ jun reheb li neque'yo'la arin sa' ruchich'och' naxk'ax xcuanquil laj Juan laj Cubsihom Ha'. Aban li k'axal cubenak xcuanquil sa' lix nimajcual cuanquil li Dios, k'axal us chok' re a'an chiru laj Juan, chan li Jesús. (Quixye chi jo'can xban nak laj Juan inc'a' ta̱ril lix nimajcual cuanquilal li Dios arin sa' ruchich'och'). ");
INSERT INTO kekNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Chixjunileb li tenamit ut eb laj titz'ol toj li que'abin re li c'a'ru quixye laj Juan, que'xq'ue retal nak ti̱c xch'o̱l li Dios ut que'xc'ul li cubi ha' riq'uin laj Juan. ");
INSERT INTO kekNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Abanan eb laj fariseo ut eb laj tzolol chak'rab que'xtz'ekta̱na li rusilal li Dios li quixc'oxla xba̱nunquil reheb. Ut inc'a' que'xc'ul li cubi ha' riq'uin laj Juan. ");
INSERT INTO kekNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ut quixye ajcui' li Jesús: —¿Ani aj iq'uin ta̱ru̱k tebinjuntak'e̱ta li cuanqueb sa' ruchich'och' anakcuan? Ma̱c'a' nacuulac chiruheb. ");
INSERT INTO kekNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Chanchaneb li coc'al li neque'c'ojla chi batz'u̱nc sa' eb li c'ayil ut neque'xjap re chixyebal reheb lix comon, “Xkaya̱basi li kaxo̱lb ut inc'a' xexxajoc; xobichan chi ra sa' kach'o̱l ut inc'a' xexya̱bac xban”, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Nak quic'ulun laj Juan laj Cubsihom ha', cuan li tzacae̱mk inc'a' quixtzaca ut cuan li inc'a' quiruc', ut eb li tenamit inc'a' que'xc'ul ut que'xye: “Ma̱us aj musik'ej cuan riq'uin”, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ut nak xinc'ulun la̱in li C'ajolbej inc'a' ajcui' xine'xc'ul sa' xya̱lal usta nincua'ac ut nin-uc'ac. Que'xye ajcui' chicuix, “Li cui̱nk a'an junes cua'ac naxba̱nu ut uc'ac vino. A'an rami̱gueb laj ma̱c ut eb laj titz'ol toj”, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nac'utun nak cha̱bil li na'leb li naxq'ue li Dios xban li cha̱bilal li neque'xba̱nu li ralal xc'ajol, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jun li cui̱nk aj Simón xc'aba' xcomoneb laj fariseo quixbok li Jesús chi cua'ac sa' rochoch. Ut li Jesús co̱ sa' rochoch li cui̱nk a'an ut quichunla sa' me̱x. ");
INSERT INTO kekNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Cuan sa' li tenamit a'an jun li ixk xcomoneb li inc'a' useb xna'leb. Quirabi resil nak li Jesús cuan chi cua'ac sa' li rochoch laj fariseo. Co̱ aran ut quixc'am jun ch'ina botella li sununquil ban. Li ch'ina botella yi̱banbil riq'uin li cha̱bil pec alabastro xc'aba'. ");
INSERT INTO kekNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Li ixk quijiloc riq'uin li Jesús. Qui-oc chi ya̱bac sa' xbe̱n li rok ut riq'uin lix ya'al ru quixch'aj. Ut quixmes riq'uin rismal xjolom. Quirutz' li rok ut quixyul riq'uin li sununquil ban. ");
INSERT INTO kekNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nak quiril a'in laj fariseo li quibokoc re li Jesús chi cua'ac, quixye sa' xch'o̱l: Cui ta tz'akal profeta li cui̱nk a'in tixnau raj chanru lix yu'am li ixk a'in li yo̱ chi ch'e'oc re li rok. Tixnau raj nak li ixk a'in inc'a' us xna'leb. ");
INSERT INTO kekNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ut li Jesús quixye re laj fariseo: —At Simón, cuan c'a'ru nacuaj xyebal a̱cue, chan re. Ut laj Simón quixye re: —Us. Ye cue, at tzolonel.— ");
INSERT INTO kekNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ut li Jesús quixye re: —Cuan jun li cui̱nk quixq'ue chi to' lix tumin reheb cuib chi cui̱nk. Li jun o'c'a̱l pe̱s lix c'as ut li jun chic laje̱b pe̱s. ");
INSERT INTO kekNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ut xban nak inc'a' que'ru xq'uebal re̱kaj li tumin que'xto'oni, laj e̱chal re li tumin quixcuyeb xma̱c xcabichaleb. Anakcuan ye cue, ¿ani reheb a cuib a'in k'axal ta̱rahok re laj e̱chal re li tumin? chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Quichak'oc laj Simón ut quixye re li Jesús: —La̱in ninc'oxla nak li ani nabal xc'as, a'an li k'axal ta̱rahok re, chan. Ut li Jesús quixye cui'chic re: —Ya̱l nak jo'can, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ut li Jesús quiril li ixk ut quixye re laj Simón: —Il a ixk a'in. Nak xinc'ulun sa' la̱ cuochoch, la̱at inc'a' xaq'ue inha' re xch'ajbal li cuok jo' c'aynako xba̱nunquil. Ut li ixk a'in xch'aj li cuok riq'uin xya'al ru ut xmes riq'uin rismal xjolom. ");
INSERT INTO kekNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","La̱at inc'a' xacuutz' li cuu nak xinc'ulun jo' c'aynako xba̱nunquil. Abanan li ixk a'in chalen xc'ulunic arin inc'a' naxcanab rutz'bal li cuok. ");
INSERT INTO kekNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","La̱at inc'a' xaq'ue li aceite sa' lin jolom jo' c'aynako xba̱nunquil, abanan li ixk a'in xyuli li cuok sa' sununquil ban. ");
INSERT INTO kekNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Jo'can nak tinye a̱cue nak li ixk a'in k'axal nabal lix ma̱c. Abanan cuybil sachbil chic. Jo'can nak k'axal cui'chic xinixra. Ut li ani ca'ch'in ajcui' lix ma̱c nacuye', ca'ch'in ajcui' narahoc, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ut li Jesús quixye re li ixk: —Ac cuybil sachbil chic la̱ ma̱c, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ut eb li cuanqueb rochbeneb sa' li me̱x que'oc chixyebal: —¿Ani a cui̱nk a'in nak naxcuy naxsach li ma̱c? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ut li Jesús quixye cui'chic re li ixk: —Xban nak cuan a̱pa̱ba̱l, xatcole'. Jo'can nak ayu chi sa sa' a̱ch'o̱l, chan re. ");
INSERT INTO kekNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Li Jesús co̱ sa' eb li tenamit chixyebal resil li cha̱bil esilal. Ut quilaje'xbeni chixjunileb li tenamit ut li c'aleba̱l rochbeneb lix tzolom cablaju. Yo̱ chixch'olobanquil lix ya̱lal chirix lix nimajcual cuanquilal li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Cuanqueb ajcui' ixk yo̱queb chi ochbeni̱nc reheb. Eb li ixk a'in, a'an eb li que'q'uirtesi̱c xyajeleb ut eb li que'isi̱c ma̱us aj musik'ej riq'uineb xban li Jesús. Sa' xya̱nkeb a'an cuan lix María. Lix Magdalena neque'xye ajcui' re. A'an li ixk li qui-isi̱c cuukub li ma̱us aj musik'ej riq'uin. ");
INSERT INTO kekNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Cuan lix Susana sa' xya̱nkeb. Ut cuan ajcui' lix Juana li rixakil laj Chuza li quicuan chok' merto̱m riq'uin laj Herodes. Ut cuanqueb ajcui' nabaleb chic li ixk rochbeneb. A'an eb li neque'tenk'an reheb riq'uin li c'a'ruheb re. ");
INSERT INTO kekNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nabaleb li tenamit que'ch'utla riq'uin li Jesús. Que'chal chak sa' eb li na'ajej yalak bar. Ut li Jesús qui-oc chixyebal jun li jaljo̱quil ru a̱tin reheb. Ut quixye: ");
INSERT INTO kekNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Jun aj acuinel co̱ chi a̱uc. Ut nak yo̱ chixhirbal li iyaj, cuan li quinak chire be ut quiyek'i̱c. Que'chal li xul li neque'xic'an ut que'xcua' li iyaj. ");
INSERT INTO kekNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ut cuan ajcui' li iyaj quinak sa' xya̱nk li pec. Quimok, abanan sa' junpa̱t quichakic xban nak chaki li ch'och'. ");
INSERT INTO kekNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ut cuan cui'chic li iyaj quinak sa' xya̱nk li q'uix. Ut nak quichamo' li q'uix sa' xbe̱n, quixnat' li acui̱mk. ");
INSERT INTO kekNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ut cuan cui'chic li iyaj quinak sa' li cha̱bil ch'och'. Quimok ut quiq'ui ut quiu̱chin chi us. Quixq'ue o'takc'a̱l (100) ru li junju̱nk chi rok. Ut quixye cui'chic li Jesús, —Li ani ta̱raj rabinquil li c'a'ru yo̱quin chixyebal, chixq'uehak retal li yo̱quin chixyebal, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ut eb lix tzolom que'xpatz' re: —¿C'a'ru xya̱lal li jaljo̱quil ru a̱tin li xaye? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Quichak'oc li Jesús ut quixye reheb: —La̱ex q'uebil e̱re xnaubal xya̱lal li mukmu̱quil na'leb chirix lix nimajcual cuanquilal li Dios. A'ut li jun ch'ol chic li inc'a' neque'pa̱ban, riq'uin jaljo̱quil ru a̱tin ta̱yema̱nk reheb. Usta yo̱queb chi iloc, abanan inc'a' te'xq'ue retal. Usta yo̱queb chi abi̱nc, abanan inc'a' te'xtau xya̱lal. ");
INSERT INTO kekNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","A'an a'in lix ya̱lal li jaljo̱quil ru a̱tin li xinye. Li iyaj, a'an retalil li ra̱tin li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ut li iyaj li quinak chire li be, a'an retalileb li neque'abin re li ra̱tin li Dios. Nak ac xe'rabi li a̱tin, laj tza inc'a' naxcanabeb re te'xtau ru li xya̱lal li ra̱tin li Dios re nak inc'a' te'pa̱ba̱nk ut te'colek'. ");
INSERT INTO kekNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ut li iyaj li quinak sa' xya̱nk li pec, a'an retalileb li neque'abin re li ra̱tin li Dios ut neque'xpa̱b chi saheb sa' xch'o̱l. Abanan inc'a' nacana sa' xch'o̱leb. Nak nayale' rix lix pa̱ba̱leb, inc'a' neque'xcuy xnumsinquil. Nach'inan ban xch'o̱leb. ");
INSERT INTO kekNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ut li iyaj li quinak sa' xya̱nk li q'uix, a'an retalileb li neque'abin re li ra̱tin li Dios. Neque'xpa̱b, abanan inc'a' neque'q'ui sa' xpa̱ba̱leb xban nak ca'aj cui' li c'a'ak re ru cuan sa' ruchich'och' neque'xc'oxla, li biomal ut xra̱bal ru li c'a'ak chic re ru. A'an li naramoc lix ya̱lal chiruheb. ");
INSERT INTO kekNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ut li iyaj li quit'ane' sa' cha̱bil ch'och', a'an retalileb li neque'abin re li ra̱tin li Dios. Neque'xpa̱b li ra̱tin chi anchaleb xch'o̱l ut neque'q'ui sa' xpa̱ba̱leb, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ut li Jesús quixye ajcui' reheb: —Ma̱ ani tixloch junak candil ut tixq'ue ta rubel junak uc'al malaj ut tixq'ue ta rubel ch'a̱t. Tixq'ue ban sa' junak na'ajej najt xteram re nak cua̱nkeb sa' cutan li ani te'oc sa' li cab. ");
INSERT INTO kekNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Jo'can ajcui' ma̱c'a' cuan chi mukmu chi inc'a' ta ta̱nauma̱nk mokon. Ut li inc'a' natauman ru anakcuan, ta̱tauma̱nk ru mokon. ");
INSERT INTO kekNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Jo'can ut cheq'uehak retal li c'a'ru te̱rabi xban nak li ani naxq'ue xch'o̱l chixtaubal ru li xya̱lal, ta̱q'uehek' mas xna'leb. Abanan li inc'a' naxq'ue xch'o̱l chixtaubal ru, ta̱mak'ek' chiru li naxc'oxla nak naxnau, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ut eb li ri̱tz'in li Jesús rochbeneb lix na' que'cuulac chi a̱tinac riq'uin. Abanan inc'a' que'ru chi oc cuan cui' li Jesús xban nak k'axal cui'chic nabaleb li cristian. ");
INSERT INTO kekNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ut quiyehe' resil re li Jesús: —La̱ na' ut eb la̱ cui̱tz'in cuanqueb chirix cab ut te'raj a̱cua̱tinanquil, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Quichak'oc li Jesús ut quixye reheb: —Li ani neque'abin re li ra̱tin li Dios ut neque'xba̱nu li c'a'ru naxye, a'aneb lin na' ut li cui̱tz'in, chan li Jesús reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sa' jun li cutan li Jesús quixye reheb lix tzolom: —K'axonko jun pac'al li palau, chan reheb. Ut qui-oc sa' jun li jucub rochbeneb lix tzolom ut co̱eb. ");
INSERT INTO kekNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nak ac yo̱queb chi xic chiru li palau, li Jesús quicuar. Sa' li ho̱nal a'an quichal jun li ca̱k-sut-ik' ut qui-oc chi nujac li ha' sa' li jucub ut yo̱queb re chi subu̱nc sa' li palau. ");
INSERT INTO kekNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Eb lix tzolom co̱eb cuan cui' li Jesús ut que'rajsi. Ut que'xye re: —At tzolonel, at tzolonel, osoc' ke, chanqueb. Ut li Jesús qui-aj ru ut quixk'us li ik' ut quixk'us li palau ut ch'anamil quicana. Inc'a' chic qui-ec'an. ");
INSERT INTO kekNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ut li Jesús quixye reheb: —¿C'a'ru xec'ul? ¿Ma ma̱c'a' chic e̱pa̱ba̱l? chan. C'ajo' nak qui-oc xc'a'uxeb ut que'xsach xch'o̱l. Que'xye chi ribileb rib, —¿Chanru nak neque'abin li ik' ut li palau chiru li cui̱nk a'in? Ut, ¿chanru nak cuan xcuanquil chixk'usbaleb? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Li Jesús ut eb lix tzolom que'cuulac sa' li na'ajej Gadara li cuan jun pac'al li palau Galilea. ");
INSERT INTO kekNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Toje' ajcui' te'cuulak li Jesús nak quichal jun li cui̱nk li cuan sa' li tenamit a'an chi c'uluc re. Li cui̱nk a'an ac junxil cuan ma̱us aj musik'ej riq'uin. Inc'a' chic nacuan sa' rochoch chi moco naxq'ue chic rak'. Junes sa' li na'ajej li neque'muke' cui' li camenak nacuan. ");
INSERT INTO kekNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nak quiril li Jesús li cui̱nk quixcuik'ib rib chiru. Quixjap re chixyebal: —¿C'a'ru ta̱cuaj cuiq'uin, at Jesús? La̱at li Ralal li nimajcual Dios. Nintz'a̱ma cha̱cuu nak mina̱ch'i'ch'i'i, chan re. ");
INSERT INTO kekNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Quixye chi jo'can xban nak li Jesús ac yo̱ chixyebal re li ma̱us aj musik'ej nak ta̱e̱lk riq'uin li cui̱nk. Nabal sut narahobtesi̱c li cui̱nk xban li ma̱us aj musik'ej. Neque'xbac' riq'uin ch'i̱ch' ut riq'uin cadena. Abanan naxt'upi li cadena ut nac'ame' xban li ma̱us aj musik'ej sa' eb li na'ajej bar ma̱c'a' cuan. ");
INSERT INTO kekNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Li Jesús quixye re: —¿Ani a̱c'aba'? chan re. —Cuakib mil inc'aba' xban nak nabalo, chan nak quichak'oc. ");
INSERT INTO kekNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ut eb li ma̱us aj musik'ej que'xtz'a̱ma chiru li Jesús nak inc'a' tixtaklaheb sa' xbalba. ");
INSERT INTO kekNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Aran cuanqueb jun tu̱b li a̱k yo̱queb chi ichajibc chiru li tzu̱l. Eb li ma̱us aj musik'ej que'xtz'a̱ma chiru li Jesús nak tixtaklaheb chi oc riq'uineb li a̱k. Ut li Jesús quixcanabeb chi oc riq'uineb. ");
INSERT INTO kekNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Que'el li ma̱us aj musik'ej riq'uin li cui̱nk ut que'oc riq'uineb li a̱k. Eb li a̱k que'oc chi a̱linac. Sa' xbe̱n li u̱l que'el chak ut toj sa' li palau coxe'nak ut aran que'cam. ");
INSERT INTO kekNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ut eb li yo̱queb chi iloc reheb li a̱k que'co̱eb sa' a̱nil ut coxe'xye resil sa' li tenamit li c'a'ru quic'ulman jo' ajcui' sa' li c'aleba̱l. ");
INSERT INTO kekNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ut nabaleb li tenamit que'co̱eb chirilbal li c'a'ru quic'ulman. Que'cuulac cuan cui' li Jesús ut que'ril li cui̱nk li qui-isi̱c nabal chi ma̱us aj musik'ej riq'uin. Chunchu chiru li Jesús. Tikto chic ut tuktu chic xjolom. Riq'uin rilbal a'an que'sach xch'o̱leb li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ut eb li que'iloc re li c'a'ru quic'ulman, que'xserak'i reheb li tenamit chanru nak quiq'uira li cui̱nk li quicuan ma̱us aj musik'ej riq'uin. ");
INSERT INTO kekNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","C'ajo' nak que'xucuac chixjunileb li tenamit li cuanqueb sa' eb li na'ajej li cuanqueb sa' xcue̱nt Gadara. Ut que'xtz'a̱ma chiru li Jesús nak ta̱e̱lk sa' lix na'ajeb. Jo'can nak li Jesús qui-oc cui'chic sa' li jucub ut qui-el sa' li na'ajej a'an. ");
INSERT INTO kekNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ut li cui̱nk li qui-isi̱c ma̱us aj musik'ej riq'uin quixye re li Jesús: —Xicakin cha̱cuix, chan re. Abanan li Jesús quixye re: —Inc'a'. Cana̱kat. ");
INSERT INTO kekNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Ayu sa' la̱ cuochoch ut ta̱serak'i reheb chixjunileb chanru nak li Dios xruxta̱na a̱cuu, chan li Jesús. Jo'can nak co̱ li cui̱nk ut quixserak'i reheb chixjunileb li cuanqueb sa' li tenamit chanru nak li Jesús quiruxta̱na ru. ");
INSERT INTO kekNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nak li Jesús quinume' cui'chic jun pac'al li palau, li q'uila tenamit yo̱queb chiroybeninquil chi saheb sa' xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ut sa' li ho̱nal a'an quicuulac jun li cui̱nk aran aj Jairo xc'aba'. A'an li nataklan sa' li cab li neque'xch'utub cui' ribeb laj judío. Nak quiril li Jesús, quixcuik'ib rib chiru ut quixtz'a̱ma chiru nak ta̱xic sa' rochoch xban nak ca̱mc re lix rabin. ");
INSERT INTO kekNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Jun ajcui' lix rabin chiru. Cablaju chihab na cuan re. Ut eb li cristian yo̱queb chixlatz'anquil li Jesús nak yo̱ chi xic. ");
INSERT INTO kekNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Sa' xya̱nkeb cuan jun li ixk cablaju chihab xticlajic xyajel. Junelic yo̱ lix yajel li ixk a'an ut inc'a' chic natz'ap lix quiq'uel. Quixq'ue rib chi banec' riq'uin nabaleb aj banonel ut nabal li tumin quixsach. Abanan ma̱ jun quiru chi banoc re. ");
INSERT INTO kekNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Li ixk a'an quijiloc riq'uin li Jesús ut quixch'e' li rak'. Ut sa' ajcui' li ho̱nal a'an quiq'uira li ixk. ");
INSERT INTO kekNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ut li Jesús quixye: —¿Ani xch'e'oc cue?— Ut chixjunileb que'chak'oc ut que'xye: —La̱o inc'a' yo̱co cha̱ch'e'bal.— Tojo'nak laj Pedro jo'queb ajcui' li cuanqueb rochben que'xye re: —At tzolonel, la̱at nacacuil chanru nak yo̱queb cha̱latz'anquil li tenamit. ¿C'a'ut nak nacapatz' ani xch'e'oc a̱cue? chanqueb re. ");
INSERT INTO kekNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ut li Jesús quixye cui'chic reheb: —La̱in ninnau nak cuan ani xch'e'oc cue xban nak xcuec'a nak cuan ani xq'uira riq'uin incuanquil, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Li ixk quixq'ue retal nak li Jesús naxnau nak xch'e' li rak'. Nasicsot xban xxiu li ixk. Sa' xch'o̱l a'an nak ta̱ch'ila̱k xban li Jesús. Quixcuik'ib rib chiru li Jesús ut quixye re chiruheb chixjunileb li cristian c'a'ut nak quixch'e' li rak'. Ut quixye ajcui' re nak sa' ajcui' li ho̱nal a'an xq'uira. ");
INSERT INTO kekNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Li Jesús quixye re: —Kana', xban nak xapa̱b nak cuan incuanquil cha̱q'uirtesinquil, jo'can nak xatq'uira. Ayu chi sa sa' a̱ch'o̱l, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Toj yo̱ ajcui' chi a̱tinac li Jesús nak quichal jun li cui̱nk sa' rochoch laj Jairo li nataklan sa' li cab li neque'xch'utub cui' ribeb laj judío ut quixye re laj Jairo: —Xcam la̱ rabin. Ma̱ch'i'ch'i'i chic laj tzolonel, chan re. ");
INSERT INTO kekNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Nak quirabi li Jesús li c'a'ru quixye li cui̱nk, quixye re laj Jairo: —Matc'oxlac. Ca'aj cui' ta̱pa̱b ut la̱ rabin ta̱colek', chan. ");
INSERT INTO kekNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nak quicuulac li Jesús, ma̱ ani quixcanab chi oc sa' li cab. Ca'aj cui' laj Pedro, laj Jacobo ut laj Juan rochbeneb lix na' xyucua' li xka'al. ");
INSERT INTO kekNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Chixjunileb li cuanqueb aran japjo̱queb re chi ya̱bac xban nak ac xcam. Ut li Jesús quixye reheb: —Mexya̱bac. Li xka'al a'in moco camenak ta. Cua̱rc yo̱, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Chixjunileb li cuanqueb aran que'xse'e li Jesús xban nak que'xnau nak li xka'al camenak chic. ");
INSERT INTO kekNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Abanan li Jesús quixchap chi ruk' li xka'al, ut quixye re: —At ch'ina xka'al, cuaclin, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Sa' li ho̱nal a'an quicuacli cui'chic chi yo'yo li xka'al. Ut li Jesús quixye reheb nak te'xq'ue chi cua'ac. ");
INSERT INTO kekNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ut eb lix na' xyucua' sachso̱queb xch'o̱l riq'uin li quic'ulman. Abanan li Jesús quixye reheb nak ma̱ ani aj e te'xserak'i li c'a'ru quic'ulman. ");
INSERT INTO kekNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Li Jesús quixch'utubeb lix tzolom cablaju ut quixq'ueheb xcuanquil chirisinquileb li ma̱us aj musik'ej ut quixq'ueheb ajcui' xcuanquil chixq'uirtesinquileb li yaj. ");
INSERT INTO kekNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Quixtaklaheb chixch'olobanquil resil lix nimajcual cuanquilal li Dios ut chixq'uirtesinquileb li yaj. ");
INSERT INTO kekNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Quixye reheb: —Ma̱c'a' te̱c'am e̱re nak texxic. Inc'a' te̱c'am e̱xuk', chi moco e̱bo̱ls, chi moco e̱tzacae̱mk chi moco e̱tumin. Ca'aj cui' le̱ rak' li cuan che̱rix te̱c'am. ");
INSERT INTO kekNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nak texc'ulek' sa' junak cab, aran texcana̱k. Toj ta̱cuulak xk'ehil nak texxic, tex-e̱lk sa' li na'ajej a'an. ");
INSERT INTO kekNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Cui texcuulak sa' junak na'ajej bar cui' inc'a' texc'ulek', tex-e̱lk riq'uineb ut te̱chik' li poks che̱rok jo' retalil li raylal te'xc'ul xban nak inc'a' que'raj rabinquil li ra̱tin li Dios, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Co̱eb ut lix tzolom li Jesús sa' eb li junju̱nk chi na'ajej ut yo̱queb chixch'olobanquil resil li colba-ib. Ut yo̱queb ajcui' chixq'uirtesinquileb li yaj. ");
INSERT INTO kekNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Laj Herodes li nataklan aran Galilea quirabi resil chixjunil li yo̱ chixba̱nunquil li Jesús ut qui-oc xc'a'ux xban nak cuan yo̱queb chi yehoc re nak a'an laj Juan li xcuacli cui'chic chi yo'yo sa' xya̱nkeb li camenak. ");
INSERT INTO kekNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ut cuan ajcui' li yo̱queb chi yehoc re nak a'an li profeta Elías li xchal cui'chic. Ut cuan cui'chic li yo̱queb chi yehoc re nak ma̱re a'an jun xcomoneb li profeta li que'cuan junxil li xcuacli cui'chic chi yo'yo sa' xya̱nkeb li camenak. ");
INSERT INTO kekNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Laj Herodes quixye sa' xch'o̱l: —A'an ma̱cua' laj Juan xban nak la̱in quintaklan re xch'otbal xcux. ¿Ani anchal a'an li yo̱quin chirabinquil resil? chan. Jo'can nak ta̱raj rilbal ru. ");
INSERT INTO kekNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nak que'suk'i chak lix tzolom chixba̱nunquil li c'anjel que'takla̱c cui', que'xserak'i re li Jesús li c'a'ru quilaje'xba̱nu chak. Li Jesús quixc'ameb xjuneseb sa' jun na'ajej bar ma̱c'a' cuan, li cuan xcue̱nt li tenamit Betsaida. ");
INSERT INTO kekNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Abanan li q'uila tenamit que'xq'ue retal nak li Jesús yo̱queb chi xic sa' li na'ajej a'an, ut que'co̱eb chirix. Li Jesús quixc'uleb ut qui-oc chixch'olobanquil xya̱lal chiruheb chirix lix nimajcual cuanquilal li Dios. Ut quixq'uirtesiheb ajcui' li yaj. ");
INSERT INTO kekNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nak ac yo̱ chi ecuu̱c, lix tzolom cablaju que'co̱eb bar cuan cui' li Jesús ut que'xye re: —Chak'rabiheb li tenamit re nak te'xic xsic'bal lix na'ajeb bar te'hila̱nk cui' ut te'xsic' ajcui' lix tzacae̱mk sa' eb li c'aleba̱l ut sa' eb li na'ajej li cuanqueb chi nach', chanqueb re. ");
INSERT INTO kekNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Li Jesús quixye reheb: —Q'uehomak xcuaheb la̱ex. Ut eb a'an que'xye: —Ma̱c'a' tzacae̱mk kiq'uin la̱o. O̱b ajcui' li caxlan cua ut cuib ajcui' li car cuan. ¿Malaj ut yo̱cat chixc'oxlanquil nak la̱o toxic chixlok'bal xtzacae̱mkeb li q'uila tenamit a'in? chanqueb lix tzolom. ");
INSERT INTO kekNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Chixjunileb li cuanqueb aran cuanqueb tana o̱b mil chi cui̱nk. Li Jesús quixye reheb lix tzolom nak te'xchunub ribeb chi ch'u̱tal, chi laje̱tk roxc'a̱l. (50) ");
INSERT INTO kekNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Eb lix tzolom li Jesús que'xba̱nu jo' quiyehe' reheb. Ut li cristian que'chunla chi ch'u̱tal. ");
INSERT INTO kekNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Li Jesús quixchap li o̱b chi caxlan cua ut li cuib chi car. Qui-iloc sa' choxa. Quixbantioxi chiru li Dios. Quixjachi ut quixq'ue reheb lix tzolom re nak te'xjeq'ui reheb li q'uila tenamit. ");
INSERT INTO kekNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Que'cua'ac chixjunileb toj retal que'c'ojla xch'o̱l. Ut cablaju chacach chic li rela' quicana. ");
INSERT INTO kekNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Sa' jun li cutan li Jesús yo̱ chi tijoc xjunes nak que'cuulac lix tzolom riq'uin. Li Jesús quixpatz' reheb lix tzolom ut quixye: —¿Anihin la̱in nak neque'xye li tenamit? chan. ");
INSERT INTO kekNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Eb a'an que'xye re: —Cuan neque'yehoc re nak la̱at laj Juan laj Cubsihom Ha'. Ut cuan ajcui' neque'yehoc re nak la̱at li profeta Elías. Ut cuan cui'chic neque'yehoc re nak la̱at jun reheb li profeta li que'cuan najter li xcuacli cui'chic chi yo'yo, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","—Ut la̱ex, ¿anihin la̱in nak nequec'oxla? chan li Jesús reheb. Quichak'oc laj Pedro ut quixye re: —La̱at li Cristo, laj Colonel li yechi'inbil xban li Dios, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ut li Jesús quixtz'a̱ma chiruheb lix tzolom ut quixye reheb: —Ma̱ ani aj e te̱ye nak la̱in li Cristo, chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ut quixye ajcui' reheb: —La̱in li C'ajolbej. Tento nak tinc'ul nabal li raylal. Tintz'ekta̱na̱k xbaneb li xakabanbileb chi c'anjelac sa' li templo, jo' ajcui' xbaneb li xbe̱nil aj tij, ut xbaneb laj tz'i̱b. Tincamsi̱k, abanan tincuacli̱k cui'chic chi yo'yo sa' rox li cutan, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Li Jesús quixye reheb chixjunileb li cuanqueb aran: —Li ani ta̱raj inpa̱banquil tento nak tixtz'ekta̱na li c'a'ru naxrahi ru lix ch'o̱l. Tixcuy xnumsinquil li raylal li tixc'ul, usta ta̱camsi̱k sa' inc'aba'. Ut chinixta̱kehak. ");
INSERT INTO kekNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Li ani ta̱tz'ekta̱na̱nk cue re xcolbal rix lix yu'am arin sa' ruchich'och', tixtz'ek li junelic yu'am. A'ut li ani naxsach lix yu'am arin sa' ruchich'och' sa' inc'aba' la̱in, a'an ta̱re̱chani li junelic yu'am. ");
INSERT INTO kekNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿C'a'ru tixra junak li cui̱nk cui ta̱re̱chani chixjunil xbiomal li ruchich'och' ut tixtz'ekta̱na li junelic yu'am? ");
INSERT INTO kekNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Li ani ta̱xuta̱na̱k inban malaj ut xban li cua̱tin, la̱in li Alalbej tinxuta̱na̱k ajcui' xbaneb nak tincha̱lk chak riq'uin inlok'al ut riq'uin xlok'al lin Yucua' cuochbeneb li santil ángel, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ut quixye ajcui': —Relic chi ya̱l tinye e̱re nak cuanqueb arin sa' e̱ya̱nk li inc'a' te'ca̱mk toj te'ril lix nimajcual cuanquilal li Dios, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Cuakxakib cutan na chic xyebal eb a a̱tin a'in nak li Jesús co̱ chi tijoc sa' xbe̱n jun li tzu̱l rochbeneb laj Pedro, laj Jacobo ut laj Juan. ");
INSERT INTO kekNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nak yo̱ chi tijoc li Jesús, quijalano' li riloba̱l chiruheb. Ut li rak' sak sak ut nalemtz'un. ");
INSERT INTO kekNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ut que'ril nak cuibeb li cui̱nk yo̱queb chi a̱tinac riq'uin li Jesús. A'aneb laj Moisés ut laj Elías. ");
INSERT INTO kekNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Neque'lemtz'un ut c'ajo' lix lok'aleb nak yo̱queb chi a̱tinac chirix lix camic li Jesús li tenebanbil sa' xbe̱n aran Jerusalén. ");
INSERT INTO kekNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Usta yo̱queb xcuara laj Pedro ut li cuanqueb rochben, abanan inc'a' que'cuar. Yo̱queb ban chirilbal lix lok'al li Jesús jo' ajcui' li cuib chi cui̱nk li cuanqueb rochben. ");
INSERT INTO kekNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nak ac oqueb re xcanabanquil li Jesús li cuib chi cui̱nk, laj Pedro quixye re li Jesús: —Ka̱cua', c'ajo' xchak'al ru nak cuanco arin. Xkayi̱b ta oxibak muheba̱l arin. Jun a̱cue, jun re laj Moisés ut jun re laj Elías, chan. Quixye chi jo'can xban nak inc'a' quixtau ru li xya̱lal li quiril. ");
INSERT INTO kekNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nak toj yo̱ chi a̱tinac laj Pedro, quichal jun li chok sa' xbe̱neb. C'ajo' nak que'xucuac nak que'mukun sa' li chok. ");
INSERT INTO kekNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Que'rabi nak li Dios quia̱tinac sa' li chok ut quixye: —A'in li cualal li sic'bil ru inban. Cherabi li c'a'ru tixye, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nak quicana li a̱tinac, xjunes chic li Jesús quicana. Ut eb a'an ma̱c'a' chic que'xye. Ut chiruheb li cutan a'an ma̱ ani aj e que'xye li c'a'ru que'ril. ");
INSERT INTO kekNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Jo' cuulajak chic nak quicube sa' li tzu̱l, nabaleb li q'uila tenamit que'cuulac chi c'uluc re li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Jun li cui̱nk quia̱tinac chak sa' xya̱nkeb li tenamit ut quixye chi cau xya̱b xcux: —At tzolonel, nintz'a̱ma cha̱cuu nak ta̱cuil li cualal xban nak ca'aj cui' a'an chicuu. ");
INSERT INTO kekNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Cuan ma̱us aj musik'ej riq'uin. Nak naniman xyajel naxjap re ut nach'ikch'iki̱c chi cau xban li ma̱us aj musik'ej ut na-el xcuokx sa' re. Ut inc'a' naraj xcanabanquil li cualal. ");
INSERT INTO kekNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Xintz'a̱ma chiruheb la̱ tzolom nak te'risi li ma̱us aj musik'ej, abanan inc'a' xe'ru chirisinquil, chan li cui̱nk. ");
INSERT INTO kekNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Quichak'oc li Jesús ut quixye reheb: —La̱ex tenamit li cuanquex anakcuan, chi ti̱c inc'a' nequexpa̱ban ut inc'a' us e̱na'leb. ¿Jo' najtil chic tincua̱nk e̱riq'uin re nak texpa̱ba̱nk? ¿Jo' najtil chic texincuy nak nequec'oxla? C'am chak li al arin cuiq'uin, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nak yo̱ chi xic li al riq'uin li Jesús, li ma̱us aj musik'ej quixcut li al sa' ch'och' ut quixch'ikle chi cau. Abanan li Jesús quixk'us li ma̱us aj musik'ej. Quixq'uirtesi li al ut quixk'axtesi re lix yucua'. ");
INSERT INTO kekNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ut chixjunileb li cuanqueb aran sachso̱queb xch'o̱l chirilbal nak k'axal nim xcuanquil li Dios. Nak toj sachso̱queb xch'o̱l li tenamit chi c'oxlac chirix li quic'ulman, li Jesús quixye reheb lix tzolom: ");
INSERT INTO kekNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Cherabihak chi us li tinye e̱re. Tento nak la̱in li C'ajolbej tink'axtesi̱k sa' ruk'eb li cui̱nk li xic' neque'iloc cue, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Abanan eb lix tzolom inc'a' que'xtau ru li c'a'ru quixye, xban nak toj ma̱ji' nacuulac xk'ehil nak te'xtau ru. Ut que'xuta̱nac chixpatz'bal re c'a'ru xya̱lal li quixye li Jesús reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Eb lix tzolom li Jesús que'oc chixcuech'inquil ribeb. Ut yo̱queb chixpatz'bal ani reheb li nimak xcuanquil. ");
INSERT INTO kekNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Nak li Jesús quixq'ue retal li c'a'ru yo̱queb chixc'oxlanquil, quixc'am jun li ch'ina al ut quixxakab chiru. ");
INSERT INTO kekNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ut quixye reheb: —Li ani ta̱c'uluk re junak ch'ina al jo' a'in sa' inc'aba' la̱in, tinixc'ul ajcui' la̱in; ut li ani ta̱c'uluk cue la̱in, tixc'ul ajcui' li ani xtaklan chak cue. Jo'can nak li ani cubenak xcuanquil sa' e̱ya̱nk anakcuan, a'anak chic li nimak xcuanquil. ");
INSERT INTO kekNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Laj Juan quixye re li Jesús: —At Ka̱cua', xkil jun li cui̱nk yo̱ chi isi̱nc ma̱us aj musik'ej sa' a̱c'aba'. Ut la̱o xkaye re nak inc'a' tixba̱nu a'an xban nak moco kacomon ta, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ut li Jesús quichak'oc ut quixye re: —Me̱k'us li cui̱nk a'an xban nak li ani inc'a' xic' na-iloc ke, a'an na-oquen chikix, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nak ac cuulac re xk'ehil nak li Jesús ta̱c'amek' cui'chic xban li Dios sa' choxa, quixcacuubresi xch'o̱l chi xic Jerusalén. ");
INSERT INTO kekNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Li Jesús quixtakla xtakl sa' jun tenamit cuan sa' xcue̱nt Samaria, re nak te'xcauresi xna'aj re ta̱hila̱nk cui'. ");
INSERT INTO kekNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Abanan li cuanqueb sa' li tenamit a'an inc'a' que'raj xc'ulbal li Jesús xban nak que'xq'ue retal nak yo̱ chi xic Jerusalén. ");
INSERT INTO kekNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nak laj Jacobo ut laj Juan que'xq'ue retal nak inc'a' quic'ule' li Jesús sa' li tenamit a'an, que'xye re: —¿Ma ta̱cuaj nak takatz'a̱ma nak ta̱cubek chak xam sa' choxa re nak ta̱c'atek' li tenamit a'an jo' quixba̱nu laj Elías? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Quixsuk'isi rib li Jesús ut quixk'useb. Quixye reheb: —¿C'a'ru musik'ejil cuan e̱riq'uin la̱ex nak inc'a' nequetau ru? ");
INSERT INTO kekNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","La̱in li C'ajolbej inc'a' xinchal chixsachbal ruheb li cristian. Xinchal ban chixcolbaleb, chan li Jesús. Ut chirix a'an, que'co̱eb sa' jalan chic na'ajej. ");
INSERT INTO kekNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nak yo̱queb chi xic li Jesús, jun li cui̱nk quicuulac riq'uin ut quixye re: —At tzolonel, tincuaj a̱ta̱kenquil yalak bar tatxic, chan re. ");
INSERT INTO kekNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Li Jesús quichak'oc ut quixye re: —C'oxla chi us ma ta̱cuy inta̱kenquil. Li yac cuanqueb xjul sa' pec, ut li xul li neque'rupupic chiru choxa cuanqueb xsoc. Abanan la̱in li C'ajolbej ma̱c'a' inna'aj bar ta̱ru̱k tinhila̱nk cui'.— ");
INSERT INTO kekNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Li Jesús quixye re jun chic: —China̱ta̱ke, chan. Quichak'oc li cui̱nk ut quixye: —Ka̱cua', china̱cuy. Inmukak cuan lin yucua' tojo'nak tinxic cha̱cuix, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Li Jesús quixye re: —Canabeb li toj camenakeb sa' li ma̱c xmukakeb cuan lix camenak. Ut la̱at, ayu. Ye chak resil lix nimajcual cuanquilal li Dios, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ut jun chic li cui̱nk quixye: —At Ka̱cua', tatinta̱ke. Abanan inchak'rabihakeb cuan chak li cuanqueb sa' cuochoch, chan re. ");
INSERT INTO kekNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ut li Jesús quixye re: —Li ani naxtiquib c'anjelac chiru li Dios ut cui toj yo̱ chixc'oxlanquil li c'a'ru re, li jun a'an inc'a' us chok' aj c'anjel sa' lix nimajcual cuanquilal li Dios, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ut chirix chic a c'a'ak re ru a'in, li Ka̱cua' quixsiq'ueb ru laje̱b xca̱c'a̱leb (70) chic chi cui̱nk ut quixtaklaheb chi ca'cabil sa' eb li junju̱nk chi tenamit ut sa' eb li na'ajej li bar talaje'numek' cui'. ");
INSERT INTO kekNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ut quixye reheb, —Relic chi ya̱l nabaleb li inc'a' neque'xnau xya̱lal. Abanan moco q'uiheb ta li te'xye li xya̱lal reheb. Chanchaneb li ru li acui̱mk li ma̱c'a' aj sic'ol re. Jo'can ut tinye e̱re nak te̱tz'a̱ma chiru li Ka̱cua' re nak a'an tixtaklaheb laj c'anjel chixch'olobanquil li xya̱lal chiruheb. ");
INSERT INTO kekNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ayukex bi' ut chenauhak nak la̱in yo̱quin chi takla̱nc e̱re sa' xya̱nkeb li xic' neque'iloc e̱re. Chanchanakex li coc' carner sa' xya̱nkeb laj xoj. ");
INSERT INTO kekNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Inc'a' te̱c'am xna'aj li c'a'ak re ru ta̱c'anjelak e̱re sa' be, chi moco e̱tumin, chi moco xjalbal e̱xa̱b. Ut ma̱ ani aj iq'uin texxakli̱k chi serak'ic sa' be. ");
INSERT INTO kekNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nak texcuulak sa' junak cab, te̱q'ue xsahileb xch'o̱l ut te̱ye, “A' taxak li tuktu̱quil usilal chi cua̱nk sa' li cab a'in,” cha'kex. ");
INSERT INTO kekNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Cui cha̱bileb li cuanqueb sa' li cab a'an, ta̱cua̱nk li tuktu̱quil usilal riq'uineb jo' xeye la̱ex. Cui ut inc'a' cha̱bileb, inc'a' ajcui' ta̱cua̱nk li tuktu̱quil usilal riq'uineb. Ca'aj cui' e̱riq'uin ban la̱ex ta̱cana̱k. ");
INSERT INTO kekNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nak tex-oc sa' junak cab, aran texcana̱k. Inc'a' yo̱kex chixbeninquil e̱rib. Ut chetzacahak li c'a'ru ta̱q'uehek' e̱re xban nak laj c'anjel tento tixc'ul lix tojbal. ");
INSERT INTO kekNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nak texc'ulek' sa' junak tenamit, chec'ulak ut chetzaca li c'a'ru ta̱q'uehek' e̱re. ");
INSERT INTO kekNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Te̱q'uirtesiheb li yaj li cuanqueb sa' li tenamit a'an ut te̱ye ajcui' reheb nak yo̱ chak chi nach'oc lix nimajcual cuanquilal li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Abanan cui texcuulak sa' junak tenamit ut inc'a' texc'ulek' sa' xya̱lal, tex-e̱lk sa' be ut tex-oc xyebal, ");
INSERT INTO kekNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Lix poksil le̱ tenamit li xletz chi kok takachik'chik'i chok' retalil nak ta̱cha̱lk raylal sa' e̱be̱n. Julticak e̱re nak lix nimajcual cuanquilal li Dios xc'ulun e̱riq'uin, abanan inc'a' xec'ul”, cha'kex reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Relic chi ya̱l tinye e̱re nak toj cubenak ca'ch'in lix tojbal xma̱queb li tenamit Sodoma chiru lix tojbal xma̱queb li tenamit a'in sa' xk'ehil li rakba a̱tin. ");
INSERT INTO kekNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Raylal cha̱lel sa' e̱be̱n la̱ex li cuanquex sa' li tenamit Corazín. Raylal cha̱lel sa' e̱be̱n la̱ex li cuanquex sa' li tenamit Betsaida. Cui ta quinba̱nu aran Tiro li milagro a'in li xinba̱nu che̱ru ut cui ta quinba̱nu aran Sidón, ac najter raj que'xq'ue li k'es ru t'icr chirixeb ut que'xchunub raj rib sa' cha ut que'yot'e' raj xch'o̱leb ut que'xjal raj xc'a'uxeb. ");
INSERT INTO kekNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Jo'can ut tinye e̱re nak sa' xk'ehil li rakba a̱tin, k'axal cui'chic li raylal li te̱c'ul la̱ex chiru li raylal li te'xc'ul eb laj Tiro ut eb laj Sidón. ");
INSERT INTO kekNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ut la̱ex li cuanquex sa' li tenamit Capernaum, c'ajo' nak nequenimobresi e̱rib. ¿Ma nequec'oxla nak ta̱taksi̱k e̱cuanquil toj sa' choxa? Ta̱cubsi̱k ban e̱cuanquil nak textakla̱k sa' xna'ajeb li camenak. ");
INSERT INTO kekNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Li ani ta̱abi̱nk re le̱ ra̱tin la̱ex, ta̱rabi ajcui' li cua̱tin la̱in. Ut li ani ta̱tz'ekta̱na̱nk e̱re la̱ex, tinixtz'ekta̱na ajcui' la̱in. Ut li ani natz'ekta̱nan cue la̱in, naxtz'ekta̱na ajcui' li quitaklan chak cue, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Que'suk'i chak li laje̱b xca̱c'a̱l chi cui̱nk chi saheb sa' xch'o̱l ut que'xye re li Jesús: —At Ka̱cua', sa' a̱c'aba' la̱at neque'pa̱ban chiku eb li ma̱us aj musik'ej, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Li Jesús quixye reheb: —La̱in quicuil laj tza chanchan rak' ca̱k nak quit'ane' chak sa' choxa. ");
INSERT INTO kekNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","La̱in xinq'ue e̱cuanquil. Usta te̱yek' li c'anti' ut laj xo̱c', ma̱c'a' te̱c'ul. Xinq'ue e̱cuanquil sa' xbe̱n laj tza ut ma̱c'a' ta̱ru̱k tixba̱nu e̱re. ");
INSERT INTO kekNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Misaho' sa' e̱ch'o̱l xban nak cuan e̱cuanquil sa' xbe̱neb li ma̱us aj musik'ej. Chisahok' ban e̱ch'o̱l xban nak tz'i̱banbilak le̱ c'aba' sa' choxa, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Sa' li ho̱nal a'an li Jesús quirec'a xsahil xch'o̱l xban li Santil Musik'ej. Quitijoc ut quixye: —At inYucua', la̱at laj e̱chal re li choxa jo' ajcui' li ruchich'och'. Ninbantioxi cha̱cuu xban nak xamuk li xya̱lal chiruheb li tzolbileb ut li cuanqueb xna'leb. Ut xac'ut li xya̱lal chiruheb li cubenakeb xcuanquil. Chanchaneb coc'al. Xaba̱nu chi jo'can xban nak jo'can xcuulac cha̱cuu la̱at, chan li Jesús nak quitijoc. ");
INSERT INTO kekNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ut quixye reheb li cuanqueb aran: —Chixjunil li c'a'ak re ru xk'axtesi sa' cuuk' lin Yucua'. Ma̱ ani nana'oc cuu la̱in li C'ajolbej, ca'aj cui' li Acuabej Dios. Ma̱ ani nana'oc ru li Acuabej Dios, ca'aj cui' la̱in li C'ajolbej. Ut ta̱na'ek' ajcui' ru xbaneb li ani tinc'ut cui' li xya̱lal, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Quixsuk'isi rib riq'uineb lix tzolom ut quixye reheb xjuneseb: —Us xak e̱re la̱ex xban nak riq'uin xnak' e̱ru yo̱quex chirilbal li c'a'ru yo̱ chi c'ulma̱nc. ");
INSERT INTO kekNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","La̱in tinye e̱re nak nabaleb li profeta ut nabaleb li rey que'raj raj rilbal li c'a'ru yo̱quex chirilbal la̱ex, abanan inc'a' que'ru rilbal. Ut que'raj raj rabinquil li c'a'ru yo̱quex chirabinquil la̱ex, abanan inc'a' que'ru rabinquil, chan li Jesús reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Jun aj tzolol chak'rab quixye re li Jesús yal re xyalbal rix: —At tzolonel: ¿C'a'ru us tinba̱nu re nak tincue̱chani li junelic yu'am? chan. ");
INSERT INTO kekNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Quichak'oc li Jesús ut quixye re: —La̱at nacacuil sa' li Santil Hu. ¿C'a'ru naxye sa' li chak'rab?— ");
INSERT INTO kekNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ut a'an quichak'oc ut quixye: —Chara li Ka̱cua' la̱ Dios chi anchal a̱ch'o̱l, chi anchal a̱cua̱m, chi anchal a̱metz'e̱u ut chi anchal a̱c'a'ux. Ut chara la̱ cuas a̱cui̱tz'in jo' nak nacara a̱cuib la̱at, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ut li Jesús quixye re: —Ya̱l li xaye. Ba̱nu a'in ut ta̱cua̱nk a̱yu'am chi junelic, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","A'an quiraj raj xti̱cobresinquil xch'o̱l xjunes rib. Quixye re li Jesús: —¿Ani tz'akal li cuas cui̱tz'in? chan. ");
INSERT INTO kekNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Li Jesús quichak'oc ut quixye re: —Cuan jun li cui̱nk aj judío qui-el Jerusalén ut yo̱ chi xic Jericó. Quic'ule' xbaneb laj e̱lk'. Que'xmak' chiru chixjunil li c'a'ru cuan re. Que'xtacuasi chi us ut co̱eb. Ca̱mc re li cui̱nk que'xcanab. ");
INSERT INTO kekNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ut sa' li be a'an quinume' jun laj tij. Quiril li cui̱nk t'ant'o aran, aban ti̱c quinume'. ");
INSERT INTO kekNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ut jo'can ajcui' quixba̱nu jun laj levita xcomoneb li neque'tenk'an reheb laj tij. Quinume' chixc'atk li cui̱nk li t'ant'o aran, abanan quinume' chi ti̱c. ");
INSERT INTO kekNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ut quinume' ajcui' jun chic li cui̱nk sa' li be a'an, Samaria xtenamit. Eb laj Samaria xic' neque'ril rib riq'uineb laj judío. Abanan nak yo̱ chi numec' quiril li cui̱nk t'ant'o aran ut quiril xtok'oba̱l ru. ");
INSERT INTO kekNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Quicuulac riq'uin. Quixban lix yoc'olal riq'uin vino ut aceite. Quixbati ru lix toch'olal. Quixq'ue chirix lix cacua̱y ut quixc'am sa' jun li cab ut aran quixq'ue chi hila̱nc ut a'an qui-iloc re. ");
INSERT INTO kekNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Jo' cuulajak chic nak ac xic re li cui̱nk aj Samaria, quixq'ue cuib li tumin plata re laj e̱chal cab ut quixye re: —Chacuil chi us li cui̱nk a'in. Ut chixjunil li jo' q'uial chic ta̱sach, la̱in tintoj a̱cue sa' insuk'ijic, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","¿C'a'ru nacac'oxla la̱at? ¿Bar cuan reheb li oxib li que'nume' li tz'akal ras ri̱tz'in li quit'ane' sa' ruk'eb laj e̱lk'? chan. ");
INSERT INTO kekNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Laj tzolol chak'rab quichak'oc ut quixye: —A' li qui-uxta̱nan ru, chan. Ut li Jesús quixye re: —Ayu ut jo'can ajcui' chaba̱nu la̱at, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ut nak yo̱queb chi xic li Jesús, que'cuulac sa' jun ch'ina tenamit. Aran quihilan li Jesús sa' rochoch jun li ixk xMarta xc'aba'. ");
INSERT INTO kekNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Lix Marta cuan jun li ri̱tz'in xMaría xc'aba'. Lix María quixchunub rib chiru li Jesús chirabinquil li c'a'ru yo̱ chixyebal. ");
INSERT INTO kekNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Abanan lix Marta ca'aj cui' lix q'uila c'anjel yo̱ xc'a'ux chirix. Quichal riq'uin li Jesús ut quixye re: —Ka̱cua', ¿ma inc'a' ch'a'aj nacacuec'a nak li cui̱tz'in niquinixcanab chi c'anjelac injunes? Ye re nak tinixtenk'a, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Li Jesús quichak'oc ut quixye re: —Marta, la̱at naxic a̱c'a'ux chirix la̱ q'uila c'anjel xban nak ca'aj cui' a'an nacac'oxla. ");
INSERT INTO kekNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Abanan jun ajcui' li c'a'ru tento xba̱nunquil ut lix María xsic' ru a'an. Li k'axal us xba̱nunquil, a'an rabinquil li c'a'ru ninye. Ut ma̱ ani ta̱ramok re chiru xba̱nunquil, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Sa' jun li cutan yo̱ chi tijoc li Jesús. Ut nak quirake' chi tijoc, jun reheb lix tzolom quixye re: —Ka̱cua', c'ut chiku li tijoc jo' nak laj Juan quixc'ut li tijoc chiruheb lix tzolom, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ut li Ka̱cua' quixye reheb: —Nak textijok, te̱ye chi jo'ca'in: Ka̱cua', cuancat sa' li santil choxa, lok'oninbil taxak la̱ santil c'aba'. Chicha̱lk ta la̱ nimajcual cuanquilal. Chi-uxk ta li nacacuaj jo' sa' choxa, jo' ta ajcui' sa' ruchich'och'. ");
INSERT INTO kekNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Chaq'ue taxak ke li kacua kuc'a chi cuulaj cuulaj. ");
INSERT INTO kekNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ut chacuy chasach ta li kama̱c jo' nak nakacuyeb xma̱c li neque'ma̱cob chiku. Ut moa̱q'ue chi a̱le̱c. Choa̱col ban chiru li inc'a' us. ");
INSERT INTO kekNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ut quixye ajcui' reheb li Jesús: —Kayehak nak la̱ex cuan ta junak le̱ rami̱g. Ut texxic raj riq'uin tuktu k'ojyi̱n ut te̱ye raj re, “At cuami̱g, ma̱re ta̱to'oni oxibak incua. ");
INSERT INTO kekNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Jun li cuami̱g xchal chak chi najt ut xc'ulun cuiq'uin sa' cab. Ut ma̱c'a' cuan cue re tinq'ue re.” ");
INSERT INTO kekNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ut li jun li cuan chak sa' cab ta̱chak'ok chak ut tixye, “Mina̱ch'i'ch'i'i. Tz'aptz'o chic li cab. La̱in ut eb lin coc'al yo̱co chi hila̱nc. Inc'a' naru nincuacli chixq'uebal a̱cue li c'a'ru ta̱cuaj.” ");
INSERT INTO kekNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Moco xban ta nak rami̱g nak ta̱cuacli̱k chixq'uebal re li c'a'ru ta̱raj ru. Tixq'ue ban re xban nak yo̱k chixpatz'bal ut re nak tixcanab xch'i'ch'i'inquil. ");
INSERT INTO kekNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Jo'can ut nak ninye e̱re: —Nak ta̱paltok c'a'ru e̱re, chextz'a̱ma̱nk chiru li Dios ut a'an tixq'ue e̱re. Chesic'ak ut te̱tau, chebokak ut li puerta ta̱tehek' che̱ru. ");
INSERT INTO kekNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Cheba̱nu a'an xban nak li ani natz'a̱man chiru li Dios naq'uehe' re. Ut li ani naxsic', naxtau. Ut li ani nabokoc, li puerta natehe' chiru. ");
INSERT INTO kekNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","¿Ma cuan ta bi' junak yucua'bej sa' e̱ya̱nk tixq'ue junak pec re li ralal nak tixpatz' xcua re? Ut nak tixpatz' junak xcar re, ¿ma c'anti' ta bi' tixq'ue re? ");
INSERT INTO kekNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ut nak tixpatz' junak xmol, ¿ma aj xo̱c' ta bi' tixq'ue re? ");
INSERT INTO kekNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Cui la̱ex li moco cha̱bilex ta nequenau xq'uebal li c'a'ru cha̱bil re le̱ ralal e̱c'ajol, ¿ma toja' ta chic le̱ yucua' cuan sa' choxa inc'a' tixq'ue li Santil Musik'ej re li ani tixtz'a̱ma chiru? chan li Jesús reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Li Jesús quirisi jun li ma̱us aj musik'ej riq'uin jun li cui̱nk mem. Nak qui-el li ma̱us aj musik'ej riq'uin, naa̱tinac chic li cui̱nk. Ut chixjunileb li cuanqueb aran que'sach xch'o̱l xban li c'a'ru quic'ulman. ");
INSERT INTO kekNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Abanan cuanqueb ajcui' li que'yehoc re: —Li cui̱nk a'in na-isin ma̱us aj musik'ej riq'uin xcuanquil laj Beelzebú lix yucua'ileb li ma̱us aj musik'ej, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ut cuanqueb ajcui' li que'xtz'a̱ma chiru li Jesús nak tixba̱nu junak li milagro yal re xyalbal rix. ");
INSERT INTO kekNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Li Jesús quixnau li c'a'ru yo̱queb chixc'oxlanquil ut quixye reheb: —Cui cuan jun te̱pak chi tenamit xic' te'ril rib chi ribileb rib, li jun te̱p chi tenamit a'an tixsach xcuanquil xjunes rib. Ut cui cuan ta jun cabalak xic' te'ril rib chi ribileb rib, li jun cabal a'an te'xsach xcuanquil lix jun cablaleb. ");
INSERT INTO kekNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Jo'can ajcui' laj tza. Cui xic' neque'ril rib chi ribileb rib, ¿chan ta cui' ru nak xakxo̱k lix cuanquilal? La̱ex nequeye nak riq'uin xcuanquil laj tza nacuisi li ma̱us aj musik'ej. ");
INSERT INTO kekNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Cui la̱in yo̱quin chirisinquil ma̱us aj musik'ej riq'uin xcuanquil laj tza, ¿ani aj cuanquil neque'isin cui' ma̱us aj musik'ej li neque'ta̱ken e̱re la̱ex? Jo'can nak a'an eb ajcui' te'yehok re nak inc'a' ya̱l li yo̱quex chixyebal. ");
INSERT INTO kekNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Cui ut riq'uin xcuanquil li Dios nacuisiheb li ma̱us aj musik'ej, riq'uin a'an nac'utun nak relic chi ya̱l ac xc'ulun sa' e̱ya̱nk lix nimajcual cuanquilal li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Laj tza chanchan jun li cui̱nk cau rib ut cuan sa' ruk' lix ch'i̱ch' re xcolbal rib. Yo̱k chixc'ac'alenquil li rochoch. Ma̱c'a' tixc'ul li c'a'ru re xban nak yo̱k chixc'ac'alenquil. ");
INSERT INTO kekNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Abanan cui ta̱cha̱lk junak k'axal cau rib chiru a'an, a'an chic ta̱numta̱k sa' xbe̱n ut ta̱mak'ek' chiru lix ch'i̱ch' li cau cui' xch'o̱l ut ta̱jeq'ui̱k li c'a'ru re. ");
INSERT INTO kekNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Li ani inc'a' na-oquen chicuix, a'an xic' ninril. Ut ani inc'a' natenk'an cue, narisi xcuanquil li c'a'ru ninba̱nu la̱in, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Nak ac x-el riq'uin junak cui̱nk, li ma̱us aj musik'ej naxic sa' li na'ajej bar ma̱c'a' cuan chixsic'bal bar ta̱oc chi hila̱nc. Naril nak inc'a' naxtau xna'aj. Naxye: —La̱in tinsuk'i̱k cui'chic riq'uin li cui̱nk bar xin-el cui' chak, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ut nak nacuulac riq'uin naxtau li cui̱nk chanchan jun li cab ma̱c'a' chic cuan chi sa'. Mesunbil ut ac cauresinbil roybeninquil li ani ta̱oc chi sa'. ");
INSERT INTO kekNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ut li ma̱us aj musik'ej naxsic' cuukub chic chi ma̱us aj musik'ej k'axal cui'chic numtajenak xma̱usilaleb chiru a'an. Neque'oc chi cua̱nc riq'uin li cui̱nk. Ut lix na'leb li cui̱nk a'an numtajenak chic xyibal ru chiru nak quicuan junxil. ");
INSERT INTO kekNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ut nak yo̱ chixyebal eb li a̱tin a'in li Jesús, jun li ixk quia̱tinac chak chi cau sa' xya̱nkeb li q'uila tenamit, ut quixye: —Us xak re li ixk li x-alan a̱cue ut xtu'resin a̱cue, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Li Jesús quichak'oc ut quixye: —K'axal cui'chic us chok' reheb li neque'abin re li ra̱tin li Dios ut neque'xba̱nu li c'a'ru naxye. ");
INSERT INTO kekNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nak yo̱queb chi ch'utla̱c li q'uila tenamit riq'uin, li Jesús quixye reheb: —Li cristian li cuanqueb sa' eb li cutan a'in inc'a' useb xna'leb. Te'raj ta̱c'utbesi̱k junak milagro chiruheb. Abanan ma̱ jun milagro ta̱c'utbesi̱k chiruheb. Ca'aj cui' li milagro li qui-ux re laj Jonás, li quic'utbesi̱c chiruheb junxil. ");
INSERT INTO kekNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Li milagro li quixc'ul laj Jonás nak quicole', a'an retalil chiruheb li tenamit Nínive nak a'an taklanbil xban li Dios. Jo'can ajcui' la̱in li C'ajolbej. Li milagro li tinc'ul la̱in, a'an jun retalil chiruheb li tenamit sa' eb li cutan a'in nak la̱in taklanbilin xban li Dios, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Li ixk li quicuan chok' reina sa' li tenamit li cuan sa' li sur, ta̱cuacli̱k chak sa' xk'ehil nak ta̱rakek' a̱tin sa' e̱be̱n ut tixye nak cuan e̱ma̱c xban nak inc'a' xerabi li cua̱tin. A'an quichal chak toj sa' xmaril li ruchich'och' chirabinquil li c'a'ru quixye laj Salomón xban nak cuan xna'leb. Ut la̱in k'axal cui'chic inna'leb chiru laj Salomón ut cuanquin arin sa' e̱ya̱nk. Abanan inc'a' nequepa̱b li cua̱tin. ");
INSERT INTO kekNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ut te'cuacli̱k ajcui' eb li que'cuan sa' li tenamit Nínive sa' xk'ehil nak ta̱rakek' a̱tin sa' e̱be̱n la̱ex li cuanquex sa' eb li cutan a'in. Ut te'xye nak cuan e̱ma̱c xban nak eb a'an que'yot'e' xch'o̱l que'xjal xc'a'ux ut que'pa̱ban nak quicuulac laj Jonás chixyebal ra̱tin li Dios reheb. Ut la̱in cuanquin arin sa' e̱ya̱nk ut k'axal nim incuanquil chiru xcuanquil laj Jonás ut la̱ex inc'a' nayot'e' e̱ch'o̱l inc'a' nequejal e̱c'a'ux, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ma̱ ani tixloch junak candil ut tixq'ue ta chi mukmu malaj ut tixq'ue rubel chacach. Naxq'ue ban sa' junak na'ajej najt xteram re nak cua̱nkeb sa' cutan li ani te'oc sa' li cab. ");
INSERT INTO kekNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Li xnak' e̱ru chanchan jun li lámpara. Xban nak na-iloc li xnak' e̱ru cuanquex sa' cutan. Cui ta ma̱c'a' li xnak' e̱ru cuanquex raj sa' k'ojyi̱n. ");
INSERT INTO kekNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Cui inc'a' us li kana'leb, cuanco sa' k'ojyi̱n. Chanchano jun li mutz' li inc'a' na-iloc. Cheba̱nu cue̱nt re nak junelic cua̱nkex sa' cutan saken. ");
INSERT INTO kekNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Jo'can ut cui cuanquex sa' cutan saken, moco cuanquex ta chic sa' k'ojyi̱n. Cha̱bilak ban chic le̱ na'leb. Xban nak cha̱bil le̱ na'leb, chanchanakex chic jun li xam li nacutanobresin, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ut nak li Jesús quirake' chi a̱tinac riq'uineb, jun reheb laj fariseo quixbok li Jesús chi cua'ac sa' rochoch. Qui-oc li Jesús sa' rochoch laj fariseo ut quichunla chi cua'ac sa' me̱x. ");
INSERT INTO kekNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Laj fariseo quisach xch'o̱l chirilbal nak li Jesús inc'a' quich'ajoc jo' c'aynakeb xba̱nunquil eb laj judío. ");
INSERT INTO kekNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Li Jesús quixye re: —La̱ex aj fariseo nequech'aj li rix le̱ sec' ut le̱ plato; abanan tz'aj lix sa'. La̱ex chanchanex li sec' li tz'aj xsa' xban nak numtajenak le̱ ma̱usilal ut li elk'ac nequeba̱nu. ");
INSERT INTO kekNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","La̱ex ma̱c'a' e̱na'leb. ¿Ma inc'a' nequenau nak li ani quiyo'obtesin re li rix, a'an ajcui' li quiyo'obtesin re lix sa'? ");
INSERT INTO kekNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Me̱rahi ru li c'a'ru re jalan. Chesihak ban li c'a'ru cuan e̱re reheb li neba'. Cui te̱ba̱nu chi jo'can cha̱bilakex chic chiru li Dios, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ra cha̱lel sa' e̱be̱n la̱ex aj fariseo. Nequemayeja li junju̱nk sa' xlaje̱tkil li isqui'ij, li ruda ut li c'a'ak re ru chi ichajil li nati'e'. Abanan inc'a' nequera li Dios ut inc'a' nequeba̱nu li ti̱quilal. Us xq'uebal li junju̱nk sa' xlaje̱tkil, abanan k'axal cui'chic tento xra̱bal li Dios ut xba̱nunquil li ti̱quilal. ");
INSERT INTO kekNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ra cha̱lel sa' e̱be̱n la̱ex aj fariseo li nacuulac che̱ru c'ojla̱c sa' li na'ajej k'axal lok' nak nequexxic sa' li cab li nequech'utub cui' e̱rib. Ut nacuulac che̱ru nak ta̱q'uehek' e̱lok'al sa' eb li be. ");
INSERT INTO kekNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ra cha̱lel sa' e̱be̱n la̱ex aj tzolol chak'rab ut la̱ex aj fariseo xban nak inc'a' us le̱ na'leb. La̱ex aj ca'pac'al u. Chanchanex li mukleba̱l li inc'a' nac'utun. Yalak ani nanume' sa' xbe̱n xban nak inc'a' neque'xnau c'a'ru cuan aran, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Quichak'oc jun reheb laj tzolol chak'rab ut quixye re li Jesús: —At tzolonel, riq'uin li c'a'ru yo̱cat chixyebal, yo̱cat chixc'utbal kaxuta̱n la̱o.— ");
INSERT INTO kekNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ut li Jesús quixye: —Ra ajcui' cha̱lel sa' e̱be̱n la̱ex aj tzolol chak'rab. K'axal a̱l li i̱k nequeq'ue sa' xbe̱neb li cristian ut k'axal ch'a'aj xc'ambal. La̱ex nequeye nak tento te'xba̱nu chixjunil li naxye li chak'rab. Abanan chi moco la̱ex nequexru xba̱nunquil. ");
INSERT INTO kekNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ra cha̱lel sa' e̱be̱n la̱ex aj tzolol chak'rab xban nak la̱ex aj ca'pac'al u. Nequerutz'u'uji chak ru li que'muke' cui' li profetas li que'xcamsi le̱ xe'to̱nil yucua'. ");
INSERT INTO kekNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Riq'uin li ma̱usilal nequeba̱nu nac'utun nak juntak'e̱tex riq'uineb le̱ xe'to̱nil yucua'. Eb a'an que'camsin reheb li profeta ut la̱ex nequeyi̱b lix mukleba̱leb. ");
INSERT INTO kekNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Li Dios, a'an cuan xna'leb. Jo'can nak quixye, “La̱in tintaklaheb li profeta ut eb li apóstol riq'uineb. Sa' xya̱nkeb a'an cuan te̱camsiheb, ut cuan ajcui' te̱ta̱keheb re xchapbaleb.” ");
INSERT INTO kekNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ut anakcuan la̱ex chic textojok rix lix camiqueb chixjunileb li profeta chalen chak sa' xticlajic li ruchich'och'. ");
INSERT INTO kekNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ya̱l nak la̱ex textojok rix lix camiqueb a'an. Ta̱ticla̱k riq'uin lix camic laj Abel ut toj riq'uin lix camic laj Zacarías li quicamsi̱c chiru neba̱l chixc'atk li templo ut li artal. ");
INSERT INTO kekNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ra cha̱lel sa' e̱be̱n la̱ex, aj tzolol chak'rab, xban nak nequemuk li xya̱lal chiruheb li tenamit. La̱ex inc'a' nequepa̱b li Dios, chi moco nequecanabeb chi pa̱ba̱nc li neque'raj raj pa̱ba̱nc, chan li Jesús reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ut nak quirake' chixyebal eb li a̱tin a'in, c'ajo' nak que'josk'o' eb laj tzolol chak'rab ut eb laj fariseo. Que'oc chixch'i'ch'i'inquil ut nabal li c'a'ak re ru yo̱queb chixpatz'bal re. ");
INSERT INTO kekNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Yo̱queb chi patz'oc re li Jesús yal re rilbal ma tixye junak a̱tin inc'a' us re nak ta̱ru̱k te'xjit. ");
INSERT INTO kekNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nak yo̱queb chi ch'utla̱c li q'uila mil chi tenamit, yo̱queb chixtiquisinquil ribeb. Li Jesús qui-oc chi a̱tinac riq'uineb lix tzolom xbe̱n cua ut quixye: —Me̱ba̱nu jo' neque'xba̱nu laj fariseo. A'aneb aj ca'pac'al u. ");
INSERT INTO kekNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ma̱c'a' naru na-uxman chi mukmu chi inc'a' ta ta̱c'utu̱nk. Ma̱c'a' cuan chi mukmu chi inc'a' ta ta̱na'ek'. ");
INSERT INTO kekNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ma̱c'a' naru nayeman sa' cab chi mukmu chiru k'ojyi̱n chi inc'a' ta ta̱e̱lk resil chi cutanquil. Ut ma̱c'a' naru nayeman chi hasbanbil sa' cab chi inc'a' ta ta̱abi̱k resil yalak bar. ");
INSERT INTO kekNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ex cuami̱g, la̱in ninye e̱re nak mexxucuac chiruheb li ani te'raj camsi̱nc e̱re xban nak ma̱c'a' naru te'xba̱nu riq'uin le̱ ra̱m. ");
INSERT INTO kekNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","La̱in tinye e̱re ani li tento te̱xucua ru. Chexucua̱k ru li Dios li naru ta̱risi xyu'am li junju̱nk ut cuan xcuanquil chixtaklanquil li a̱mej sa' xbalba. A'an li tento te̱xucua ru. ");
INSERT INTO kekNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","¿Ma inc'a' ta bi' nac'ayi̱c o̱b chi tzentzeyul chi cuib centavo? K'axal cubenak xtz'ak, abanan ma̱ jun reheb a'an nasach sa' xch'o̱l li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Jo'can ajcui' li rismal le̱ jolom ajlanbileb chixjunil xban li Dios. Jo'can nak mexxucuac chiruheb li xic' neque'iloc e̱re xban nak la̱ex k'axal terto e̱tz'ak chiruheb nabal chi tzentzeyul. ");
INSERT INTO kekNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","La̱in tinye e̱re nak li ani naxye chiruheb li tenamit nak niquinixpa̱b, la̱in tinye chiruheb lix ángel li Dios nak a'an cualal inc'ajol. ");
INSERT INTO kekNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ut li ani ta̱tz'ekta̱na̱nk cue chiruheb li tenamit, la̱in tintz'ekta̱na ajcui' a'an chiruheb lix ángel li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Li ani ta̱hobok cue la̱in li C'ajolbej, ta̱cuyek' xma̱c xban li Dios. Abanan li ani ta̱majecua̱nk re li Santil Musik'ej inc'a' ta̱cuyek' xma̱c. ");
INSERT INTO kekNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nak texc'amek' chiruheb li neque'taklan sa' li cab li neque'xch'utub cui' ribeb laj judío, malaj ut chiruheb laj rakol a̱tin ut chiruheb li cuanqueb sa' xcuanquil, inc'a' yo̱kex chixc'oxlanquil li c'a'ru texsume̱nk cui' malaj ut li c'a'ru te̱ye, ");
INSERT INTO kekNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","xban nak li Santil Musik'ej tixc'utbesi che̱ru sa' li ho̱nal a'an chanru texsume̱nk cui', chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jun li cui̱nk quia̱tinac chak sa' xya̱nkeb li q'uila tenamit ut quixye re li Jesús: —At tzolonel, ye re li cuas nak xjachak li jun cablal li quicanaba̱c chok' ke ut xq'uehak cue li jo' q'uial tintz'ak la̱in, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","A'ut li Jesús quixye re: —At cui̱nk, la̱in inc'a' xakabanbilin chi rakoc a̱tin sa' e̱be̱n chi moco xakabanbilin chixjachinquil le̱ jun cablal. ");
INSERT INTO kekNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ut quixye ajcui' reheb chixjunileb li cuanqueb aran: —Q'uehomak retal li c'a'ru te̱ba̱nu. Inc'a' yo̱kex chixrahinquil ru li biomal, xban nak moco riq'uin ta kabiomal yo'yo̱co, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ut quixye ajcui' jun li jaljo̱quil ru a̱tin reheb. Quixye: —Cuan jun li cui̱nk biom. Cuan jun xch'och' cha̱bil ut nabal li acui̱mk na-el chi sa'. ");
INSERT INTO kekNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Qui-oc chixc'oxlanquil ut quixye sa' xch'o̱l, “¿C'a'ru tinba̱nu? Ma̱c'a' chic xna'aj li ru li cuacui̱mk”, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ut quixye, “Ninnau c'a'ru tinba̱nu. Tinpo' li rochochil li ru li cuacui̱mk li cuanqueb. Ut tinyi̱b chic jalan ni̱nk chok' re̱kaj. Ut chi sa' a'an tinxoc chixjunil li ru li cuacui̱mk jo' ajcui' chixjunil li c'a'ru cuan cue.” ");
INSERT INTO kekNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ut tinye: “Us xak cue. Cuan nabal c'a'ru cue xocxo inban re tinnumsi nabal chihab. Anakcuan tinhila̱nk, tincua'ak, tin-uc'ak, ut ta̱sahok' sa' inch'o̱l”, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Abanan li Dios quixye re, “Abi, at jip aj cui̱nk. Chiru a k'ojyi̱n a'in tatca̱mk. Ut chixjunil li xocxo a̱ban, ¿ani aj e ta̱cana̱k cui'?” ");
INSERT INTO kekNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","La̱in ninye e̱re: jo'ca'in naxc'ul li naxc'u̱la xbiomal sa' ruchich'och' ut riq'uin li Dios ma̱c'a' xbiomal, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ut li Jesús quixye reheb lix tzolom: —Mixic e̱ch'o̱l chixc'oxlanquil chanru nak te̱numsi li cutan junju̱nk, chi moco riq'uin li c'a'ru te̱tzaca chi moco riq'uin lix tikibanquil e̱rib. ");
INSERT INTO kekNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Li kayu'am, a'an k'axal lok' chiru li katzacae̱mk. Ut li katibel, a'an k'axal lok' chiru li kak'. ");
INSERT INTO kekNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Cheq'uehak retal li xul li neque'rupupic chiru choxa. Eb a'an inc'a' neque'au, chi moco neque'k'oloc, chi moco neque'xxoc xcuaheb chi moco cuan xc'ulanquil xtzacae̱mkeb. Abanan li Dios naxq'ue xtzacae̱mkeb. ¿Ma toja' ta chic la̱ex inc'a' tixq'ue e̱tzacae̱mk? ");
INSERT INTO kekNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Ani e̱re la̱ex ta̱ru̱k tixtik ru lix yu'am usta naxtacuasi rib xc'oxlanquil? ");
INSERT INTO kekNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Cui inc'a' nequexru xba̱nunquil li c'a'ak re ru a'in, ¿c'a'ut nak nequetacuasi e̱rib chixc'oxlanquil? ");
INSERT INTO kekNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Q'uehomak retal li utz'u'uj chanru nak neque'q'ui chi inc'a' neque'c'anjelac chi moco neque'quemoc. A'ut la̱in tinye e̱re, usta c'ajo' xchak'al ru lix tikibanquil laj Salomón, abanan inc'a' quixtau xchak'al ru li utz'u'uj a'in. ");
INSERT INTO kekNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ut cui li Dios naxq'ue lix ch'ina'usal li pim li cuan junpa̱t ajcui' ut cuulaj q'uebilak sa' xam, ¿ma toja' ta chic la̱ex inc'a' textikib? La̱ex inc'a' nequexpa̱ban chi tz'akal. ");
INSERT INTO kekNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Jo'can ut nak inc'a' yo̱k e̱c'a'ux chirix le̱ cua e̱ruc'a. ");
INSERT INTO kekNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Le̱ yucua' li cuan sa' choxa naxnau li c'a'ru nequeraj ru. Li inc'a' neque'xpa̱b li Dios, ca'aj cui' lix tzacae̱mkeb neque'xc'oxla. ");
INSERT INTO kekNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Abanan la̱ex te̱sic' lix nimajcual cuanquilal li Dios ut chixjunil li c'a'ak re ru a'in talajq'uehek' e̱re chok' xtz'akob. ");
INSERT INTO kekNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Mexxucuac ex cualal inc'ajol. Usta inc'a' q'uihex, abanan le̱ yucua' cuan sa' choxa c'ojc'o xch'o̱l chixq'uebal e̱re lix nimajcual cuanquilal. ");
INSERT INTO kekNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","C'ayihomak li c'a'ru cuan e̱re ut sihomak reheb li ma̱c'a' cuan reheb re nak cua̱nk e̱biomal sa' choxa. Aran inc'a' na-oc laj e̱lk' chi elk'ac chi moco namaxen. Q'uehomak e̱ch'o̱l chirix li biomal li inc'a' na-oso'. ");
INSERT INTO kekNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Jo'can nak chenauhak nak bar cuan cui' le̱ biomal, aran ajcui' cua̱nk le̱ c'a'ux. ");
INSERT INTO kekNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Checauresihak e̱rib. Yo̱kex chiroybeninquil li Ka̱cua'. Chanchanakex li mo̱s li lochlo xxam ut yo̱ chiroybeninquil lix patrón. ");
INSERT INTO kekNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Chanchanakex li mo̱s li yo̱queb chiroybeninquil lix patroneb nak ta̱suk'i̱k chak sa' junak sumla̱c. Nak tixtoch' li puerta, sa' junpa̱t te'xte chiru. ");
INSERT INTO kekNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Us xak reheb li mo̱s li yo̱queb chiroybeninquil lix patroneb. Nak ta̱cuulak li patronej, tixtauheb chi ajo̱queb ru. Relic chi ya̱l ninye e̱re li patronej tixcauresi rib ut tixchunubeb lix mo̱s sa' me̱x ut a'an ajcui' ta̱q'uehok re lix tzacae̱mkeb. ");
INSERT INTO kekNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Us xak reheb li mo̱s li yo̱keb chiroybeninquil lix patrón, usta tuktu k'ojyi̱n malaj ut sake̱uc re ta̱cuulak. ");
INSERT INTO kekNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Cheq'uehak retal a'in: Cui ta naxnau li yucua'bej sa' li cab jok'e ho̱nal re li k'ojyi̱n tol-e̱lk laj e̱lk', ta̱yo'lek raj ut inc'a' raj tixcanab chi elk'ac li c'a'ru cuan sa' li rochoch. ");
INSERT INTO kekNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jo'can ajcui' la̱ex yo'on cua̱nkex chi oybeni̱nc xban nak inc'a' nequenau jok'e ho̱nal tincuulak la̱in li C'ajolbej. Tincuulak chi ma̱c'a' sa' e̱ch'o̱l, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Laj Pedro quixye re li Jesús: —At Ka̱cua', ¿ma ca'aj cui' ke la̱o xaye li jaljo̱quil ru a̱tin a'an, malaj ut reheb ajcui' chixjunileb li tenamit?— ");
INSERT INTO kekNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ut li Ka̱cua' quixye re: —Li mo̱s li cuan xna'leb ut cha̱bil, a'an li ta̱q'uehek' xcuanquil xban lix patrón sa' xbe̱neb li rech mo̱sil. A'an chic ta̱q'uehok re xtzacae̱mkeb sa' x-o̱ril. ");
INSERT INTO kekNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Us xak re li mo̱s li yo̱k chixba̱nunquil lix c'anjel sa' xya̱lal nak ta̱c'ulu̱nk lix patrón. ");
INSERT INTO kekNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Relic chi ya̱l tinye e̱re nak li patrón a'an, tixk'axtesi sa ruk' chixjunil lix jun cablal. ");
INSERT INTO kekNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Abanan cui li mo̱s a'an inc'a' us lix na'leb, tixye sa' xch'o̱l, “Lin patrón ta̱ba̱yk chi c'ulu̱nc”. Ut ta̱oc chixsac'baleb li rech mo̱sil jo' cui̱nk jo' ixk ut ta̱oc chi cua'ac, chi uc'ac ut chi cala̱c. ");
INSERT INTO kekNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ma̱c'a'ak sa' xch'o̱l nak ta̱c'ulu̱nk lix patrón. Ut lix patrón tixq'ue chixtojbal rix lix ma̱c ut tixtakla sa' xya̱nkeb li inc'a' useb xna'leb. ");
INSERT INTO kekNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Li mo̱s li naxnau c'a'ru naraj lix patrón ut chi ti̱c ma̱c'a' naxba̱nu, li jun a'an ta̱saq'uek' chi cau. ");
INSERT INTO kekNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Abanan li mo̱s li inc'a' naxba̱nu li us xban nak inc'a' naxnau c'a'ru naraj lix patrón, li jun a'an tixc'ul ajcui' xtojbal xma̱c. Abanan ca'ch'in ajcui' chiru li tixc'ul li naxnau li c'a'ru naraj lix patrón. Li ani naxnau xya̱lal, mas cui'chic nabal li i̱k cuan sa' xbe̱n. Ut li ani cuan xna'leb chi us, mas cui'chic li i̱k cuan sa' xbe̱n chiru li jun li ma̱c'a' xna'leb, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Li Jesús quixye ajcui': —Chanchan li xinq'ue xam sa' ruchich'och' nak xinchal la̱in xban nak sa' inc'aba' la̱in nabal li ch'a'ajquilal ta̱cua̱nk. Nacuaj ta ac xnume' li ch'a'ajquilal a'in. ");
INSERT INTO kekNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Abanan tento tinc'ul jun li cubi ha' xbe̱n cua. Ut li cubi ha', a'an li nimla raylal li tinc'ul. Ut yo̱kin chiroybeninquil li ho̱nal a'an chi ra sa' inch'o̱l toj ta̱cuulak xk'ehil nak ta̱c'ulma̱nk. ");
INSERT INTO kekNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ma̱re la̱ex nequec'oxla nak junes tuktu̱quil usilal xinc'am chak sa' ruchich'och'. Inc'a'. Ta̱cua̱nk ajcui' nabal li ch'a'ajquilal. ");
INSERT INTO kekNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Chalen anakcuan inc'a' chic sa te'cua̱nk li ju̱nk cabal sa' rochocheb xban nak cuan li te'pa̱ba̱nk cue ut cuan inc'a'. Ma̱re cuan o̱b chi cristian sa' li jun cabal. Oxib xic' te'ril li cuib chic. Ut li cuib xic' te'ril li oxib chic. ");
INSERT INTO kekNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Li yucua'bej xic' ta̱ril li ralal, ut li alalbej xic' ta̱ril lix yucua'. Li na'bej xic' ta̱ril lix co' ut li co'bej xic' ta̱ril lix na'. Ut li na'bej xic' ta̱ril li ralib ut li alibej xic' ta̱ril lix na' lix be̱lom. ");
INSERT INTO kekNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Li Jesús quixye ajcui' reheb li q'uila tenamit: —Nak nequeril nak yo̱ chi cha̱lc li chok bar na-oc cui' li sak'e, nequeye, “Ho̱n naxq'ue hab”, chanquex. Ut ya̱l ajcui' nak naxq'ue li hab. ");
INSERT INTO kekNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ut jo'can ajcui' nak nachal li ik' sa' li sur. Nequeye, “Tik ru li cutan tixq'ue anakcuan,” chanquex. Ut ya̱l ajcui' nak naxq'ue li tik. ");
INSERT INTO kekNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","La̱ex aj ca'pac'al u. Nequenau xq'uebal retal ru li choxa ut li ruchich'och'. Abanan ca'aj cui' a'an nequenau rilbal. Inc'a' nequeq'ue retal li yo̱ chi c'ulma̱nc sa' eb li cutan a'in. ");
INSERT INTO kekNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿C'a'ut nak inc'a' nequeq'ue retal c'a'ru li us te̱ba̱nu? ");
INSERT INTO kekNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nak yo̱quex chi xic riq'uin laj rakol a̱tin, yi̱bomak ru le̱ ch'a'ajquil sa' junpa̱t riq'uin li xic' na-iloc a̱cue nak toj ma̱ji' nequexcuulac. Cui inc'a' nacac'am a̱cuib sa' usilal chi junpa̱t, laj rakol a̱tin tatxtakla sa tz'alam. ");
INSERT INTO kekNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","La̱in ninye a̱cue nak inc'a' tat-e̱lk aran cui inc'a' ta̱toj chixjunil li jo' q'uial te'xpatz' a̱cue, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Sa' li ho̱nal a'an que'cuulac cuib oxibeb li cui̱nk riq'uin li Jesús ut que'xye re chanru nak laj Pilato quixtakla xcamsinquileb li cui̱nk aj Galilea nak yo̱queb chi mayejac sa' li templo. ");
INSERT INTO kekNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ut li Jesús quixye reheb: —¿Ma nequec'oxla la̱ex nak eb li cui̱nk a'an k'axal cui'chic aj ma̱queb chiruheb li rech tenamitil? ¿Ma xban a'an nak que'xc'ul a raylal a'an nak nequeye la̱ex? chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Tinye e̱re nak inc'a'. Cui la̱ex inc'a' te̱yot' e̱ch'o̱l ut te̱jal e̱c'a'ux, tex-osok' ajcui' la̱ex che̱junilex. ");
INSERT INTO kekNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿C'a'ru nequec'oxla chirixeb li cuakxaklaju chi cui̱nk li que'cam nak li torre li cuan Siloé quit'ane' sa' xbe̱neb? ¿Ma xban nak numtajenak lix ma̱queb a'an chiruheb chixjunileb li cuanqueb Jerusalén nak que'xc'ul chi jo'can? ");
INSERT INTO kekNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","La̱in ninye e̱re nak inc'a'. Ut cui la̱ex inc'a' te̱yot' e̱ch'o̱l ut te̱jal e̱c'a'ux, tex-osok' ajcui' la̱ex, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Quixye ajcui' li jaljo̱quil ru a̱tin a'in reheb: Jun li cui̱nk cuan jun to̱n xhigo aubil sa' lix ch'och'. Ut quichal chixsic'bal li ru, abanan ma̱c'a' quixtau. ");
INSERT INTO kekNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Quixye re li cui̱nk li na-iloc re li acui̱mk: —Oxib chihab cuoquic chiroybeninquil ma ta̱u̱chi̱nk li che' a'in, ut inc'a' nau̱chin. Yoc' li che' a'in. ¿C'a'ru aj e nak yo̱k chixlatz'anquil li ch'och' chi inc'a' nau̱chin? chan. ");
INSERT INTO kekNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ut li cui̱nk li na-iloc re li acui̱mk quixye re: —Ka̱cua', cana̱k cuan chic jun chihabak. Ut tinbec li ch'och' sa' xto̱n ut tinq'ue xk'emal li ch'och'. ");
INSERT INTO kekNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ut cui ta̱u̱chi̱nk, us; ut cui inc'a', ta̱yoc' mokon, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sa' jun li hiloba̱l cutan, li Jesús yo̱ chixc'utbal li xya̱lal chiruheb sa' li cab li neque'xch'utub cui' ribeb laj judío. ");
INSERT INTO kekNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ut aran cuan jun li ixk cuan ma̱us aj musik'ej riq'uin. Cuakxaklaju chihab roquic lix yajel. C'utzc'u rix li ixk nak nabe̱c ut inc'a' naru naxakli chi ti̱c. ");
INSERT INTO kekNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nak quiril li ixk li Jesús quixbok riq'uin ut quixye re: —At ixk, anakcuan q'uirtesinbilat chic.— ");
INSERT INTO kekNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ut quixq'ue li ruk' sa' xbe̱n li ixk. Ut sa' ajcui' li ho̱nal a'an li ixk quixakli chi ti̱c ut qui-oc chixlok'oninquil li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","C'ajo' nak quijosk'o' li nataklan sa' li cab li neque'xch'utub cui' ribeb laj judío xban nak li Jesús quixq'uirtesi li ixk sa' li hiloba̱l cutan. Ut quixye reheb li cuanqueb aran: —Cuakib cutan cuan re nak naru texc'anjelak. Chiruheb a cutan a'an naru nequexchal chi banec' ut inc'a' texcha̱lk chi banec' sa' li hiloba̱l cutan, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ut li Ka̱cua' quichak'oc ut quixye re: —¡Ex aj ca'pac'al u! ¿Ma inc'a' ta bi' te̱hit e̱bo̱yx malaj ut e̱bu̱r sa' li hiloba̱l cutan re nak te̱c'ameb chi uc'ac? ");
INSERT INTO kekNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Li ixk a'in, a'an xcomoneb li ralal xc'ajol laj Abraham. Ac cuan cuakxaklaju chihab roquic laj tza xch'i'ch'i'inquil. Cui la̱ex nequehit le̱ bo̱yx sa' li hiloba̱l cutan, ¿ma inc'a' ta bi' ta̱ru̱k tinq'uirtesi li ixk a'in sa' li hiloba̱l cutan? chan. ");
INSERT INTO kekNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ut riq'uin li c'a'ru quixye li Jesús, quixc'ut xxuta̱neb chixjunileb li yo̱queb chixcuech'inquil rix. Abanan li q'uila tenamit que'saho' xch'o̱l xbaneb li milagro li yo̱ chixba̱nunquil li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","—¿C'a'ru ta̱ru̱k tinjuntak'e̱ta cui' lix nimajcual cuanquilal li Dios? chan li Jesús. Ut, ¿c'a'ru chi jaljo̱quil ru a̱tin tinye re xch'olobanquil xya̱lal lix nimajcual cuanquilal li Dios? ");
INSERT INTO kekNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Lix nimajcual cuanquilal li Dios, a'an chanchan riyajil li mostaza, li quixc'am jun li cui̱nk ut quirau sa' lix ch'och'. Ut quimok ut quiniman chi us. Nimla che' quicuulac. Ut laj xic'anel xul neque'xyi̱b xsoqueb sa' eb li ruk'. ");
INSERT INTO kekNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ut quixye cui'chic: ¿C'a'ru ta̱ru̱k tinjuntak'e̱ta cui' lix nimajcual cuanquilal li Dios? ");
INSERT INTO kekNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Lix nimajcual cuanquilal li Dios, a'an chanchan li na-oc chok' xch'amal li caxlan cua. Li ixk quixq'ue ca'ch'in sa' oxib bisoc li c'aj ut quisipo' chixjunil li k'em xban. ");
INSERT INTO kekNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Li Jesús quinume' sa' eb li tenamit ut sa' eb li c'aleba̱l nak yo̱ chi xic Jerusalén ut yo̱ chixch'olobanquil li xya̱lal chiruheb li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Jun reheb li cuanqueb aran quixye re: —At Ka̱cua', ¿ma ya̱l nak inc'a' q'uiheb li te'colek'? chan re. ");
INSERT INTO kekNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Li Jesús quichak'oc ut quixye: —Jo'can nak q'uehomak e̱ch'o̱l chi oc sa' li oqueba̱l li ca'ch'in ru. Nabaleb raj li te'raj oc, abanan inc'a' te'ru̱k chi oc. ");
INSERT INTO kekNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nak acak xtz'ap li oqueba̱l laj e̱chal re li cab, la̱ex texcana̱k chirix cab ut te̱toch' raj chic li puerta ut te̱ye, “Ka̱cua', Ka̱cua', te li puerta chiku”, cha'kex. Abanan a'an ta̱chak'ok ut tixye e̱re, “Inc'a' ninnau e̱ru bar xexchal chak”, cha'ak. ");
INSERT INTO kekNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ut la̱ex te̱ye cui'chic re, “¿C'a'ut nak inc'a' ta̱nau ku? La̱o xocua'ac xo-uc'ac kochbenat. Ut la̱at xatc'utuc li xya̱lal chiku sa' li katenamit”, cha'kex. ");
INSERT INTO kekNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ut laj e̱chal cab tixye cui'chic e̱re, “Ninye e̱re nak inc'a' ninnau bar xexchal chak. Elenkex chicuu, la̱ex aj ba̱nuhom ma̱usilal”, cha'ak. ");
INSERT INTO kekNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Nak te̱ril laj Abraham, laj Isaac, laj Jacob ut chixjunileb li profeta cua̱nkeb sa' lix nimajcual cuanquilal li Dios, ut la̱ex inc'a' tex-ocsi̱k, toj aran texya̱bak ut te̱c'uxuxi li ruch e̱re xban xrahil e̱ch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nabaleb li telaje'cha̱lk chak yalak bar jun sut rubel choxa, ut te'c'ojla̱k chi cua'ac sa' lix nimajcual cuanquilal li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Cuanqueb li inc'a' q'uebileb xlok'al arin sa' ruchich'och' te'q'uehek' xlok'al riq'uin li Dios. Ut cuanqueb ajcui' li q'uebileb xlok'al arin sa' ruchich'och'. Eb a'an inc'a' te'xc'ul xlok'al riq'uin li Dios, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ut sa' ajcui' li ho̱nal a'an cuanqueb aj fariseo que'cuulac riq'uin li Jesús chixyebal re: —Elen arin. Ayu xban nak laj Herodes ta̱raj a̱camsinquil, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Li Jesús quixye reheb: —Ayukex ut yehomak re laj Herodes li chanchan yac nak anakcuan ut cuulaj la̱in yo̱kin chi isi̱nc ma̱us aj musik'ej ut yo̱kin chi q'uirtesi̱nc. Ut sa' rox li cutan tinchoy lin c'anjel. ");
INSERT INTO kekNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Abanan tento nak yo̱kin chi xic anakcuan, cuulaj, ut ca'bej. Tento tincuulak Jerusalén re nak tincamsi̱k aran xban nak inc'a' naru ta̱camsi̱k junak profeta sa' jalan na'ajej. Tento nak aran Jerusalén tincamsi̱k, cha'kex re. ");
INSERT INTO kekNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ex aj Jerusalén, la̱ex nequecamsiheb li profeta ut nequecuti chi pec eb li neque'takla̱c e̱riq'uin xban li Dios. Nabal sut raj xcuaj e̱colbal jo' nak naxch'utubeb li ral li caxlan rubel lix xic'. Abanan la̱ex inc'a' xeraj. ");
INSERT INTO kekNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ut anakcuan le̱ tenamit ta̱cana̱k chi naq'uirnac aj chic ru. Tinye ut e̱re chalen anakcuan inc'a' chic te̱ril cuu toj nak te̱ye, “Osobtesinbil taxak li xchal sa' xc'aba' li Ka̱cua'”, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sa' jun li hiloba̱l cutan li Jesús co̱ chi cua'ac sa' rochoch jun laj fariseo nim xcuanquil. Ut cuanqueb ajcui' cuib oxib laj fariseo yo̱queb chixq'uebal retal li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Aran cuan jun li cui̱nk sip xakxo chiru li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ut li Jesús quixye reheb laj tzolol chak'rab ut reheb laj fariseo: —¿C'a'ru naxye sa' li chak'rab? ¿Ma us q'uirtesi̱nc sa' li hiloba̱l cutan? ¿Malaj ut inc'a' us? chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ut eb a'an ti̱c ma̱c'a' que'xye. Tojo'nak li Jesús quixchap li ruk' li cui̱nk ut quixq'uirtesi ut quixye re nak naru ta̱xic. ");
INSERT INTO kekNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nak quixsuk'isi rib li Jesús, quixye reheb li cuanqueb aran: —¿Ani junak e̱re la̱ex ta̱t'anek' ta junak xbu̱r malaj ut xbo̱yx sa' xjulel ha', ma inc'a' ta bi' ta̱xic sa' junpa̱t chirisinquil usta hiloba̱l cutan? chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ut eb a'an chi ti̱c inc'a' que'xnau xsumenquil. ");
INSERT INTO kekNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Li Jesús quixq'ue retal nak li bokbileb chi cua'ac sa' li cab a'an yo̱queb chixsic'bal ru li na'ajej li neque'q'uehe' cui' li cuanqueb xcuanquil. Jo'can nak quixye jun li jaljo̱quil ru a̱tin reheb. Quixye: ");
INSERT INTO kekNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Nak texbokek' sa' junak sumla̱c, mexc'ojla sa' li na'ajej li naq'uehe' reheb li cuanqueb xcuanquil. Ma̱re ta̱cuulak junak chic mas nim xcuanquil che̱ru la̱ex. ");
INSERT INTO kekNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ut li xbokoc e̱re ta̱cha̱lk ut tixye e̱re, “Q'uehomak li na'ajej a'in re li cui̱nk a'in”, cha'ak e̱re. Yo̱k chic e̱xuta̱n nak texxic chi c'ojla̱c sa' li na'ajej li neque'c'ojla cui' li ma̱c'a'eb xcuanquil. ");
INSERT INTO kekNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Jo'can nak ninye e̱re nak texbokek' sa' junak sumla̱c, chexc'ojla̱k sa' li na'ajej li neque'c'ojla cui' li ma̱c'a'eb xcuanquil. Ut li xbokoc e̱re, ta̱cha̱lk ut tixye e̱re, “Quimkex, c'ojlankex arin sa' li cha̱bil na'ajej”, cha'ak e̱re. Chi jo'can ta̱q'uehek' e̱lok'al chiruheb chixjunileb li c'ojc'o̱queb sa' li me̱x e̱rochben. ");
INSERT INTO kekNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Jo'can nak chixjunileb li neque'xnimobresi ribeb, ta̱cubsi̱k xcuanquileb. Ut chixjunileb li neque'xcubsi ribeb, eb a'an te'q'uehek' xcuanquil, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ut quixye ajcui' li Jesús re laj e̱chal cab: —Nak tatq'uehok chi tzaca̱nc, malaj ut ta̱ba̱nu junak nink'e, moco ca'aj cui' ta la̱ cuami̱g ta̱bokeb, chi moco ca'aj cui' eb la̱ cuas ut eb la̱ cui̱tz'in, chi moco ca'aj cui' la̱ cuech'alal, chi moco ca'aj cui' la̱ cuech cabal li biomeb, xban nak eb a'an naru te'xba̱nu ajcui' jun nink'e ut tate'xbok ut te'xq'ue re̱kaj cha̱cuu. ");
INSERT INTO kekNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nak ta̱ba̱nu junak li nink'e, ta̱bok ajcui' eb li neba' ut eb li tokol rok ruk', ut eb li ye̱k rok ut eb li mutz', ");
INSERT INTO kekNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","xban nak eb a'an inc'a' ta̱ru̱k te'xq'ue re̱kaj a̱cue. Abanan li Dios tatrosobtesi ut tixq'ue re̱kaj a̱cue nak te'cuacli̱k cui'chic chi yo'yo li ti̱queb xch'o̱l, chan li Jesús re. ");
INSERT INTO kekNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jun reheb li chunchu̱queb sa' li me̱x quirabi li c'a'ru quixye li Jesús ut quixye re: —Us xak re li ani ta̱tz'ako̱nk chi cua'ac sa' li nink'e sa' lix nimajcual cuanquilal li Dios, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nak quichak'oc, li Jesús quixye jun li jaljo̱quil ru a̱tin re: Quicuan jun li cui̱nk quixc'u̱b jun nimla nink'e ut nabaleb li quixbokeb chi cua'ac. ");
INSERT INTO kekNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nak quicuulac xk'ehil li nink'e, quixtakla lix mo̱s chixyebal reheb li bokbileb nak te'cha̱lk chi cua'ac xban nak ac xya̱lo' li tzacae̱mk. ");
INSERT INTO kekNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Abanan chixjunileb que'oc xpatz'bal xcuybaleb. Jun quiyehoc: —Xinlok' jun inch'och'. Tento nak tinxic chirilbal. Tintz'a̱ma cha̱cuu nak ta̱cuy inma̱c xban nak inc'a' tinxic, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ut li jun chic quixye: —Xinlok' o̱b sumal inbo̱yx. Xic cue chirilbaleb. Nintz'a̱ma cha̱cuu nak ta̱cuy inma̱c, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ut li jun chic quixye: —Toje' xinsumla ut inc'a' chic naru tinxic, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Li mo̱s quisuk'i riq'uin lix patrón ut quixye re li c'a'ru que'xye li bokbileb. Quichal xjosk'il li patrón ut quixye re lix mo̱s: —Ayu sa' c'ayil ut sa' eb li be ut ta̱bokeb li neba', eb li tokol rok ruk'eb, eb li ye̱k rokeb ut eb li mutz' ut ta̱c'ameb chak arin, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Co̱ li mo̱s ut quixba̱nu jo' quiyehe' re. Nak quisuk'i chak quixye re lix patrón: —Ka̱cua', xinba̱nu jo' xaye cue ut toj cuan nabal li na'ajej, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Li patrón quixye re lix mo̱s: —Tatxic chire li tenamit ut sa' c'aleba̱l ut ta̱cuelaji chak ruheb chi cha̱lc sa' li nink'e re nak ta̱nujak li cuochoch, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","La̱in ninye e̱re nak ma̱ jun reheb li bokbileb xbe̱n cua te'tz'ako̱nk riq'uin li nink'e li xinba̱nu, chan li patrón. ");
INSERT INTO kekNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nak yo̱ chi xic li Jesús nabaleb li tenamit yo̱queb chi ta̱ke̱nc re. Quixsuk'isi rib li Jesús ut quixye reheb: ");
INSERT INTO kekNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Li ani ta̱raj ta̱ke̱nc cue, tento nak tinixra chi tz'akal la̱in chiruheb lix na' xyucua', li rixakil ut eb lix coc'al, ut eb li rech'alal jo' ajcui' lix yu'am. Cui inc'a' tinixra chi tz'akal, li jun a'an moco us ta chok' intzolom. ");
INSERT INTO kekNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Li ani ta̱raj oc chok' intzolom, tento nak tinixta̱ke ut tixcuy xnumsinquil li raylal usta ta̱camsi̱k sa' inc'aba'. ");
INSERT INTO kekNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Cui cuan junak e̱re naraj tixyi̱b junak cab najt xteram, ¿ma inc'a' ta bi' ta̱c'ojla̱k xbe̱n cua chixbirbal rix ma cuan tz'akal lix tumin re tixchoy xyi̱banquil li cab? ");
INSERT INTO kekNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Cui tixq'ue lix cimiento li cab ut inc'a' chic ta̱ru̱k xchoybal, chixjunileb li te'ilok re te'xtiquib xse'enquil. ");
INSERT INTO kekNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ut te'xye, —Li cui̱nk a'in quixtiquib cablac ut inc'a' naru xchoybal, cha'keb. ");
INSERT INTO kekNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","¿Ma cuan ta bi' junak rey ta̱xic chi pletic riq'uin junak chic rey cui inc'a' ta̱c'ojla̱k xbe̱n cua chixc'oxlanquil ma tixcuy pletic rochbeneb laje̱bak mil chi cui̱nk riq'uin li rey jun chic, li yo̱ chi cha̱lc chi pletic rochbeneb junmay mil chi cui̱nk? ");
INSERT INTO kekNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ut cui naxc'oxla nak inc'a' ta̱ru̱k, tixtaklaheb lix takl nak toj cua̱nkeb chi najt chixtz'a̱manquil chiru li rey jun chic re nak te'cana̱k sa' usilal chi ribileb rib. ");
INSERT INTO kekNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jo'can ajcui' la̱ex. Tento te̱c'oxla chi us c'a'ru te̱ba̱nu xban nak li ani inc'a' naraj xcanabanquil li c'a'ru cuan re, li jun a'an moco us ta ta̱oc chok' intzolom. ");
INSERT INTO kekNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Li atz'am, a'an cha̱bil. Abanan cui inc'a' chic qui', ma̱c'a' chic ta̱oc cui'. ");
INSERT INTO kekNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Inc'a' chic ta̱usa̱k chok' re li ch'och', chi moco chok' re li mul. Yal re tz'ekec' aj chic. Li ani ta̱raj rabinquil li cua̱tin, chixq'uehak retal li yo̱quin chixyebal. ");
INSERT INTO kekNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nabaleb laj titz'ol toj ut eb laj ma̱c que'cuulac chirabinquil li c'a'ru yo̱ chixyebal li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Eb laj fariseo ut eb laj tz'i̱b yo̱queb chi cuech'i̱nc ut yo̱queb chixyebal: —Li cui̱nk a'in naxc'am rib sa' usilal riq'uineb laj ma̱c ut nacua'ac rochbeneb, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Li Jesús quixye reheb li jaljo̱quil ru a̱tin a'in: ");
INSERT INTO kekNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","¿Ma cuan junak cui̱nk sa' e̱ya̱nk cua̱nk ta o'c'a̱lak (100) xcarner, cui ta̱sachk junak sa' xya̱nkeb a'an, ma inc'a' raj tixcanab li bele̱laju ro'c'a̱l (99) sa' c'aleba̱l ut ta̱xic chixsic'bal li quisach toj retal tixtau chak? chan. ");
INSERT INTO kekNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ut nak tixtau, ta̱sahok' sa' xch'o̱l ut tixq'ue sa' xbe̱n xtel, ");
INSERT INTO kekNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ut ta̱xic sa' rochoch. Tixch'utubeb li rami̱g ut li rech cabal ut tixye reheb: —Chisahok' sa' kach'o̱l cuochbenex xban nak xintau lin carner li quisach, cha'ak reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","La̱in tinye e̱re nak jo'can ajcui' sa' choxa. Ta̱cua̱nk nimla sahil ch'o̱lej nak junak aj ma̱c tixyot' xch'o̱l tixjal xc'a'ux chiruheb bele̱laju ro'c'a̱l chi cristian li ac xe'pa̱ban ut ti̱queb chic xch'o̱leb. ");
INSERT INTO kekNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ut quixye ajcui' reheb: Kayehak nak junak ixk cuan laje̱bak xtumin. Cui ta̱sachk junak lix tumin, ¿ma inc'a' raj tixloch li xam ut ta̱oc chixmesunquil li cab ut tixsiq'ui toj retal tixtau? ");
INSERT INTO kekNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ut nak tixtau, tixch'utubeb li rami̱g ut eb li rech cabal ut tixye reheb: —Chisahok' sa' kach'o̱l cuochbenex xban nak xintau lin tumin li quisach chicuu, cha'ak. ");
INSERT INTO kekNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","La̱in ninye e̱re nak jo'can ajcui' eb lix ángel li Dios te'sahok' sa' xch'o̱leb nak junak aj ma̱c ta̱yot'ek' xch'o̱l ut tixjal xc'a'ux. ");
INSERT INTO kekNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ut quixye ajcui' reheb li jaljo̱quil ru a̱tin a'in: Jun li cui̱nk quicuan cuib li ralal. ");
INSERT INTO kekNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Li i̱tz'inbej quixye re lix yucua': —At inyucua', q'ue cue anakcuan la̱ jun cablal li jo' q'uial li tintz'ak la̱in, chan. Tojo'nak li yucua'bej quixjeq'ui lix jun cablal reheb li ralal cuib. ");
INSERT INTO kekNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ut ma̱ji' ajcui' najterak nak li i̱tz'inbej quixch'utub chixjunil li c'a'ru cuan re, ut co̱ chi najt sa' jalanil tenamit. Aran quixsach li c'a'ru re nak yo̱ chixk'axbal li cutan chi jo' ma̱jo'. ");
INSERT INTO kekNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ut nak ac xsach chixjunil li c'a'ru cuan re, quicuan jun nimla cue'ej sa' li tenamit a'an. Ut li al yo̱ chixcuybal xtz'ocajic. ");
INSERT INTO kekNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Jo'can nak co̱ riq'uin jun li cui̱nk cuan sa' li tenamit a'an chixpatz'bal xtrabaj. Ut li cui̱nk a'an quixtakla sa' c'aleba̱l chi iloc a̱k. ");
INSERT INTO kekNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Quiraj raj xcua'bal xcuaheb li a̱k xban nak ta̱tz'oca̱k. Abanan inc'a' que'xq'ue ca'ch'inak re. ");
INSERT INTO kekNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Quijultico' re chanru nak quicuan sa' rochoch lix yucua' ut quixye sa' xch'o̱l: —Nabaleb aj c'anjel cuanqueb sa' rochoch lin yucua' ut numtajenak xcuaheb. Ut la̱in arin osoc' cue xban tz'oca̱c. ");
INSERT INTO kekNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Tinxic cui'chic sa' rochoch lin yucua' ut tinye re, “At inyucua', xinma̱cob chiru li Dios jo' ajcui' cha̱cuu la̱at. ");
INSERT INTO kekNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ma̱cua' chic inc'ulub nak tinc'aba'in a̱cualal. China̱c'ul ban jo' junak a̱mo̱s,” cha'akin re, chan sa' xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Sa' junpa̱t quicuacli ut quisuk'i sa' rochoch lix yucua'. Toj cuan ajcui' chak chi najt nak qui-ile' xban lix yucua'. Ut li yucua'bej quiril xtok'oba̱l ru. Co̱ sa' a̱nil chixc'ulbal li ralal. Quixk'alu ut quirutz' ru. ");
INSERT INTO kekNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ut li ralal quixye re: —At inyucua', xinma̱cob chiru li Dios jo' ajcui' cha̱cuu la̱at. Ma̱cua' chic inc'ulub nak tinc'aba'in a̱cualal, chan re lix yucua'. ");
INSERT INTO kekNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","A'ut li yucua'bej quixye reheb lix mo̱s: —Sic'omak chak sa' junpa̱t li cha̱bil t'icr ut q'uehomak chirix. Q'uehomak xmatk'ab chi ru'uj ruk' ut q'uehomak xxa̱b chi rok. ");
INSERT INTO kekNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ut c'amomak chak li ch'ina cuacax, li ch'olaninbil chi us. Camsihomak ut tonink'ei̱k, ");
INSERT INTO kekNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","xban nak li cualal a'in chanchan camenak nak xcuan chak. A'ut anakcuan xsuk'i cui'chic chi yo'yo. Sachenak nak xcuan ut xtauman cui'chic, chan. Ut que'oc chi nink'ei̱c. ");
INSERT INTO kekNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ut li asbej cuan chak sa' c'aleba̱l. Nak yo̱ chi cuulac sa' cab, quirabi li son ut li xajoc. ");
INSERT INTO kekNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Quixbok jun li mo̱s ut quixpatz' re c'a'ru yo̱queb sa' cab. ");
INSERT INTO kekNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Li mo̱s quixye re: —Xsuk'i chak la̱ cui̱tz'in ut la̱ yucua' xtakla xcamsinquil li ral li cuacax li ch'olaninbil chi us, xban nak la̱ cui̱tz'in xsuk'i cui'chic chi cau ut chi sa sa' xch'o̱l, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nak li asbej quirabi li c'a'ru quixye li mo̱s, quichal xjosk'il, ut inc'a' quiraj oc sa' li rochoch. Ut li yucua'bej qui-el chirix cab ut quixtz'a̱ma chiru nak ta̱oc. ");
INSERT INTO kekNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Li asbej quichak'oc ut quixye re lix yucua': —At inyucua', la̱at nacanau nak nabal chihab xinc'anjelac cha̱cuu ut ma̱ jun sut xink'et la̱ cua̱tin. Ut ma̱ jun cua xaq'ue junak inch'ina chiba̱t re nak tinnink'ei̱k cuochbeneb li cuami̱g. ");
INSERT INTO kekNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Abanan anakcuan xc'ulun la̱ cualal a'in li quisachoc re la̱ jun cablal riq'uineb li ixk li neque'xc'ayi rib ut la̱at xatakla xcamsinquil chok' re li ch'ina cuacax li ch'olaninbil chi us, chan li asbej. ");
INSERT INTO kekNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Li yucua'bej quixye re: —At cualal, la̱at junelic cuancat cuiq'uin ut chixjunil li c'a'ru cuan cue, a'an a̱cue ajcui' la̱at. ");
INSERT INTO kekNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Abanan tento nak tonink'ei̱k anakcuan ut ta̱sahok' sa' kach'o̱l xban nak la̱ cui̱tz'in chanchan camenak nak xcuan; abanan xsuk'i cui'chic chi yo'yo. Quisach ut xtauman cui'chic, chan li yucua'bej. ");
INSERT INTO kekNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Li Jesús quixye reheb lix tzolom li jaljo̱quil ru a̱tin a'in: Quicuan jun li cui̱nk k'axal biom ut quicuan jun xmerto̱m. Cuanqueb li que'jitoc chirix li merto̱m chiru li patrón ut que'xye re: —La̱ merto̱m yo̱ chixsachbal la̱ biomal, chanqueb re. ");
INSERT INTO kekNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Jo'can nak quixbok lix merto̱m ut quixye re: —¿C'a'ru xya̱lal li yo̱quin chirabinquil cha̱cuix? Ta̱k'axtesi la̱ cue̱nt nak xatcuan chi c'anjelac xban nak inc'a' chic tatcana̱k chok' inmerto̱m, chan re. ");
INSERT INTO kekNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ut li merto̱m quixye sa' xch'o̱l: —¿C'a'ru tinba̱nu anakcuan xban nak lin patrón tinrisi sa' lin c'anjel? Inc'a' tincuy li cacuil c'anjel ut tinxuta̱na̱k chi xic chixtz'a̱manquil c'a'ru cue chire cablal. ");
INSERT INTO kekNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Anakcuan ninnau c'a'ru tinba̱nu re nak cua̱nkeb li tine'xc'ul sa' rochocheb nak tin-isi̱k chi merto̱mil, chan sa' xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Quixbokeb chak chi xju̱nkaleb li cuanqueb xc'as riq'uin lix patrón. Ut quixye re li xbe̱n: —¿Jo' nimal la̱ c'as riq'uin lin patrón? chan. ");
INSERT INTO kekNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ut li cui̱nk quixye re: —O'c'a̱l (100) barril chi aceite, chan. Ut li merto̱m quixye re: —Cue' li hu li tz'i̱banbil cui' retalil la̱ c'as. Chunlan ut jal sa' junpa̱t. Laje̱b roxc'a̱l (50) aj chic ta̱tz'i̱ba retalil chiru li hu a'in, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ut quixye cui'chic re li jun chic: —Ut la̱at, ¿jo' nimal la̱ c'as? chan. Ut li cui̱nk quixye: —O'c'a̱l (100) bisoc chi trigo, chan. Li merto̱m quixye re: —Cue' li hu li tz'i̱banbil cui' retalil la̱ c'as. Jal ut ca̱c'a̱l (80) bisoc aj chic ta̱tz'i̱ba retalil chiru li hu a'in, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ut li patrón quisach xch'o̱l chirilbal nak k'axal cuan xna'leb li merto̱m li inc'a' us xna'leb. Eb li inc'a' neque'xnau li xya̱lal k'axal se̱beb xch'o̱l chixc'oxlanquil chanru tixtenk'a rib, usta inc'a' us tixba̱nu reheb li ras ri̱tz'in. K'axal se̱beb xch'o̱l chiruheb li ralal xc'ajol li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Cuan li neque'xba̱nu li inc'a' us riq'uin lix biomal. Abanan, la̱in ninye e̱re, cheba̱nu usilal reheb le̱ ras e̱ri̱tz'in riq'uin le̱ biomal sa' ruchich'och'. Ut nak ta̱lajk ta̱osok' le̱ biomal, texc'ulek' sa' li na'ajej li ma̱c'a' roso'jic. ");
INSERT INTO kekNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Li ani ti̱c xch'o̱l chixba̱nunquil li yal ca'ch'in, ti̱cak ajcui' xch'o̱l chixba̱nunquil li nabal. Ut li ani inc'a' ti̱c xch'o̱l chixba̱nunquil li yal ca'ch'in, inc'a' ajcui' ti̱cak xch'o̱l chixba̱nunquil li nabal. ");
INSERT INTO kekNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Cui la̱ex inc'a' nequenau xra̱bal li biomal sa' ruchich'och', ¿chan ta cui' ru nak tixc'ojob xch'o̱l li Dios chixq'uebal e̱re li tz'akal biomal? ");
INSERT INTO kekNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ut cui inc'a' nequenau xra̱bal li c'a'ru re jalan, ¿chan ta cui' ru nak ta̱k'axtesi̱k e̱re la̱ex li c'a'ru tz'akal e̱re? ");
INSERT INTO kekNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ma̱ ani ta̱ru̱k ta̱c'anjelak chiru cuib chi patrón. Ma̱re tixra li jun ut xic' ta̱ril li jun chic, malaj ut xic' ta̱ril li jun ut tixra li jun chic. Inc'a' naru texc'anjelak chiru li Dios cui junes le̱ biomal nequec'oxla. ");
INSERT INTO kekNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Nak eb laj fariseo que'rabi li quixye li Jesús, que'oc chixse'enquil xban nak neque'xra lix biomaleb. ");
INSERT INTO kekNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ut li Jesús quixye reheb: —La̱ex nequeti̱cobresi e̱ch'o̱l e̱junes chiruheb li tenamit. Abanan li Dios naxnau chanru le̱ na'leb. Li c'a'ru k'axal lok' chiruheb li cui̱nk sa' ruchich'och', a'an tz'ekta̱nanbil xban li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Chixjunil li tijleb li que'xc'ut eb li profeta junxil, jo' ajcui' lix chak'rab laj Moisés, quirake' xyebal nak laj Juan laj Cubsihom Ha' quic'ulun chixch'olobanquil resil nak cha̱lc re lix nimajcual cuanquilal li Dios. Ut nabaleb yo̱queb chixyalbal xk'e chi oc rubel lix nimajcual cuanquilal li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Li choxa ut li ruchich'och', a'an moco ch'a'aj ta nak ta̱osok'. Abanan ma̱ jun li a̱tin li tz'i̱banbil sa' li chak'rab, ta̱ru̱k ta̱isi̱k xcuanquil, usta k'axal ca'ch'in. ");
INSERT INTO kekNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Li ani tixjach rib riq'uin li rixakil ut ta̱sumla̱k riq'uin jalan chic ixk, a'an tixmux ru lix sumlajic. Ut li cui̱nk li ta̱sumla̱k riq'uin junak ixk li ac xjach rib riq'uin lix be̱lom, tixmux ru lix sumlajic. ");
INSERT INTO kekNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Quicuan jun li cui̱nk biom. Naxtikib rib riq'uin cha̱bil t'icr k'axal terto xtz'ak ut rajlal cutan nanink'ei̱c. ");
INSERT INTO kekNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Quicuan ajcui' jun li cui̱nk neba' aj Lázaro xc'aba'. Xox rix. Rajlal naxchunub rib chire li oqueba̱l re li rochoch li biom. ");
INSERT INTO kekNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Naxra raj ru xtzacanquil xc'aj li cua li nat'ane' sa' xbe̱n xme̱x li biom. Eb li tz'i' neque'chal riq'uin ut neque'xrek' ru lix xox. ");
INSERT INTO kekNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Quicuulac xk'ehil nak quicam li neba' ut quic'ame' xbaneb li ángel toj sa' choxa bar cuan cui' laj Abraham. Ut quicam ajcui' li biom ut quimuke'. ");
INSERT INTO kekNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nak ac cuan sa' xbalba, yo̱ chixc'ulbal li raylal aran. Qui-iloc takec' ut quiril laj Abraham ut laj Lázaro cuan chixc'atk. ");
INSERT INTO kekNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Quixjap re ut quixye: —Ka̱cua' Abraham, chacuil taxak xtok'oba̱l cuu. Chatakla laj Lázaro chintenk'anquil. Chixt'akresi chak li ru'uj ruk' sa' ha' ut tolxquehobresi li ru'uj cuak' xban nak c'ajo' li raylal yo̱quin chixc'ulbal sa' li xam a'in, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ut laj Abraham quixye re: —At cuas cui̱tz'in, julticak a̱cue nak toj yo'yo̱cat sa' ruchich'och' nabal a̱biomal ut k'axal sa nak xatcuan. Ut laj Lázaro c'ajo' li raylal quixc'ul. Anakcuan c'ojobanbil xch'o̱l laj Lázaro arin ut la̱at k'axal ra cuancat. ");
INSERT INTO kekNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ut cuan jun nimla chamal jul naramoc re li na'ajej cuanco cui'. Ut ma̱ jun ke ta̱ru̱k ta̱numek' re ta̱xic e̱riq'uin, chi moco la̱ex ta̱ru̱k texnumek' chak arin, chan laj Abraham re li biom. ");
INSERT INTO kekNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tojo'nak li biom quixye re: —Tintz'a̱ma cha̱cuu, at Ka̱cua' Abraham, takla laj Lázaro sa' rochoch lin yucua'. ");
INSERT INTO kekNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Aran cuanqueb o̱b li cui̱tz'in. Chatakla xch'olobanquil xya̱lal chiruheb re nak eb a'an inc'a' te'cha̱lk sa' li na'ajej a'in chi c'uluc raylal, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Laj Abraham quixye re: —Cuan riq'uineb li hu li tz'i̱banbil xban laj Moisés, ut eb li profeta. Che'xq'uehak retal li c'a'ru tz'i̱banbil sa' li hu a'an, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Quichak'oc li biom ut quixye: —Inc'a' tz'akal a'an, Ka̱cua' Abraham. Abanan cui junak camenak ta̱cuacli̱k cui'chic chi yo'yo ut ta̱xic riq'uineb, te'yot'ek' raj xch'o̱l ut te'xjal raj xc'a'uxeb, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","A'ut laj Abraham quixye re: —Cui inc'a' neque'rabi li quixye laj Moisés ut eb li profeta, inc'a' ajcui' te'pa̱ba̱nk usta ta̱cuacli̱k cui'chic chi yo'yo junak sa' xya̱nkeb li camenak, chan laj Abraham. ");
INSERT INTO kekNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Li Jesús quixye reheb lix tzolom: —Junelic cuan li po'oc ch'o̱l. Abanan raylal cha̱lel sa' xbe̱n li ani tixpo' xch'o̱l li ras ri̱tz'in. ");
INSERT INTO kekNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","K'axal raj us chok' re a'an nak ta̱cutek' sa' xchamal li palau chi bac'bo junak nimla pec chi xcux chiru nak tixpo' xch'o̱l junak li toj k'un xch'o̱l sa' lix pa̱ba̱l. ");
INSERT INTO kekNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Cheq'uehak retal chanru le̱ na'leb. Cui ta̱ma̱cobk cha̱cuu la̱ cuas a̱cui̱tz'in, chak'usak. Ut cui ta̱yot'ek' xch'o̱l ut tixjal xc'a'ux, chacuyak xma̱c. ");
INSERT INTO kekNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Usta ta̱ma̱cobk cha̱cuu cuukubak sut chiru li jun cutan ut cuukub sut tixpatz' xcuybal cha̱cuu ut tixye nak inc'a' chic tixba̱nu, tento nak ta̱cuy xma̱c, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Eb li apóstol que'xye re li Ka̱cua': —At Ka̱cua', choa̱tenk'a taxak re nak cua̱nk kapa̱ba̱l chi tz'akal, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ut li Ka̱cua' quixye reheb: —Usta ca'ch'in ajcui' le̱ pa̱ba̱l cuan jo' li riyajil li mostaza, ta̱ru̱k raj te̱ye re li che' a'in, “Mich' a̱cuib ut au a̱cuib sa' li palau” ut li che' tixba̱nu raj jo' te̱ye re, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Kayehak nak junak e̱re cuan xmo̱s yo̱k chak chi c'alec malaj ut chi iloc queto̱mk. Nak acak xchoy lix c'anjel lix mo̱s, ta̱suk'i̱k sa' cab. ¿Ma ta̱yehek' ta bi' re xban lix patrón, “Ocan, c'ojlan ut cua'in”? ");
INSERT INTO kekNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Inc'a'. Ta̱yehek' ban re: “Chac'u̱b cuan intzacae̱mk ut chatc'anjelak chicuu. Nak acak xinrake' chi cua'ac, naru tatcua'ak la̱at.” ");
INSERT INTO kekNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Ma tixbantioxi re lix mo̱s nak quixba̱nu li quitakla̱c xba̱nunquil? La̱in ninye nak inc'a'. ");
INSERT INTO kekNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Jo'can ajcui' la̱ex. Nak ac xeba̱nu li xextakla̱c cui', cheyehak: “La̱o aj c'anjel cha̱cuu. Ca'aj cui' li jo' q'uial xoa̱takla cui' xkaba̱nu. Jo'can nak ma̱bantioxi chiku”, cha'akex, chan li Jesús reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Nak yo̱ chi xic Jerusalén, li Jesús quinume' sa' li na'ajej li neque'xc'ul cui' rib li tenamit Samaria ut Galilea. ");
INSERT INTO kekNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nak yo̱ chi cuulac sa' jun li c'aleba̱l, que'chal chixc'ulbal laje̱b li cui̱nk saklep rixeb. Eb a'an najt que'xakli riq'uin li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ut que'xjap reheb chixyebal: —At Jesús, at aj tzolonel, chacuuxta̱na taxak ku, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nak quirilebli Jesús quixye reheb: —Ayukex riq'uineb laj tij ut c'utumak chak e̱rib chiruheb, chan reheb. Ut nak yo̱queb chi xic, que'q'uira. ");
INSERT INTO kekNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jun reheb li cui̱nk quiril nak quiq'uira, quisuk'i riq'uin li Jesús ut yo̱ chixlok'oninquil li Dios chi cau xya̱b xcux. ");
INSERT INTO kekNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Quixcuik'ib rib chiru li Jesús ut quixbantioxi chiru. Li cui̱nk a'an aj Samaria. ");
INSERT INTO kekNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Quixye li Jesús: —¿Ma ma̱cua' ta bi' laje̱b chi cui̱nk li xinq'uirtesi? ¿Bar cuanqueb li bele̱b chic? ");
INSERT INTO kekNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Ma ca'aj cui' li jun a'in li ma̱cua' aj judío xsuk'i chixlok'oninquil li Dios? chan. ");
INSERT INTO kekNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tojo'nak quixye re li cui̱nk: —Xaklin ut tatxic. Xatq'uira xban nak xatpa̱ban, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Eb laj fariseo que'xpatz' re li Jesús jok'e ta̱cha̱lk lix nimajcual cuanquilal li Dios. Li Jesús quichak'oc ut quixye reheb: —Lix cuanquilal li Dios moco cua̱nk ta retalil lix c'ulunic re nak te̱nau jok'e xk'ehil. ");
INSERT INTO kekNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Chi moco te'xye, “cuan arin” chi moco te'xye, “le' cuan”, xban nak lix cuanquilal li Dios ac cuan sa' e̱ya̱nk la̱ex, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ut li Jesús quixye reheb lix tzolom: —Ta̱cuulak xk'ehil nak la̱ex te̱ra ru rilbal lin c'ulunic la̱in li C'ajolbej, abanan inc'a' te̱ril cuu. ");
INSERT INTO kekNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ut te'xye e̱re, “cue' arin” malaj ut “cuan toj le'”. Abanan mexxic chirilbal chi moco te̱ta̱keheb. ");
INSERT INTO kekNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sa' xk'ehil lin c'ulunic la̱in li C'ajolbej chanchanakin li rak' ca̱k nak narepoc chak ut naxcutanobresi chixjunil ru li choxa. La̱in moco chi mukmu ta tinc'ulu̱nk. ");
INSERT INTO kekNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Abanan tento nak la̱in li C'ajolbej tinrahobtesi̱k ut tintz'ekta̱na̱k xbaneb li cuanqueb sa' ruchich'och' sa' eb li cutan a'in. ");
INSERT INTO kekNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Jo' quic'ulman sa' eb li cutan nak toj cua̱nk laj Noé sa' ruchich'och', jo'can ajcui' ta̱c'ulma̱nk nak ta̱cuulak xk'ehil lin c'ulunic la̱in li C'ajolbej. ");
INSERT INTO kekNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Sa' eb li cutan a'an li tenamit yo̱queb chi cua'ac ut yo̱queb chi uc'ac. Yo̱queb chi sumla̱c ut yo̱queb chi sumuba̱nc toj quicuulac xk'ehil nak laj Noé qui-oc sa' li jucub cab. Nak ma̱c'a' sa' xch'o̱leb quichal li but'i ha' ut quilajxsacheb chixjunileb li inc'a' que'oc sa' li jucub cab. ");
INSERT INTO kekNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ta̱c'ulma̱nk jo' quic'ulman sa' eb li cutan nak laj Lot toj cua̱nk sa' ruchich'och'. Chixjunileb yo̱queb chi tzaca̱nc ut yo̱queb chi uc'ac. Yo̱queb chi lok'oc ut yo̱queb chi c'ayi̱nc. Yo̱queb chi a̱uc ut yo̱queb chi cablac. ");
INSERT INTO kekNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Abanan sa' li cutan nak laj Lot qui-el sa' li tenamit Sodoma, nak ma̱c'a' sa' xch'o̱leb, quichal chak sa' choxa xam ut azufre ut quilajxsacheb chixjunileb. ");
INSERT INTO kekNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Jo'can ajcui' ta̱c'ulma̱nk nak tinc'ulu̱nk cui'chic la̱in li C'ajolbej. Ma̱c'a'ak sa' xch'o̱leb li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Sa' li cutan nak tinc'ulu̱nk, li ani cua̱nk chak sa' xbe̱n li rochoch ut li c'a'ru re cua̱nk sa' li cab, micube chak chixxocbal. Jo'can ajcui' li cua̱nk chak sa' c'aleba̱l, inc'a' ta̱suk'i̱k sa' li rochoch. ");
INSERT INTO kekNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Chijulticok' e̱re li c'a'ru quixc'ul li rixakil laj Lot nak quiraj raj suk'i̱c. ");
INSERT INTO kekNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Li ani ta̱raj xcolbal rix lix yu'am arin sa' ruchich'och', ta̱sachk chiru. Ut li ani ta̱sachk lix yu'am chiru, a'an ta̱cua̱nk xyu'am chi junelic. ");
INSERT INTO kekNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ut tinye ajcui' e̱re: Sa' li ho̱nal a'an nak tinc'ulu̱nk, cua̱nkeb cuib yo̱keb chi cua̱rc sa' jun chi cuarib. Jun aj pa̱banel ut jun ma̱cua'. Laj pa̱banel ta̱c'amek' xban li Dios ut li jun chic li ma̱cua' aj pa̱banel, a'an ta̱canaba̱k. ");
INSERT INTO kekNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ut cuib li ixk yo̱keb chi que'ec sa' jun li que'leb, jun aj pa̱banel ut li jun chic ma̱cua' aj pa̱banel. Ut laj pa̱banel ta̱c'amek' xban li Dios ut li jun chic li ma̱cua' aj pa̱banel, a'an ta̱canaba̱k. ");
INSERT INTO kekNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Cua̱nkeb cuib chi cui̱nk sa' li c'aleba̱l, jun aj pa̱banel ut li jun chic ma̱cua' aj pa̱banel. Laj pa̱banel ta̱c'amek' xban li Dios ut li jun chic, li ma̱cua' aj pa̱banel, ta̱canaba̱k, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Eb lix tzolom que'xpatz' re: —¿Bar ta̱c'ulma̱nk li yo̱cat chixyebal? chanqueb. Ut li Jesús quixye reheb: —La̱ex nequenau nak bar cuan cui' junak li camenak, aran ajcui' te'ch'utla̱k eb li so'sol, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Li Jesús quixye li jaljo̱quil ru a̱tin a'in reheb lix tzolom re xc'utbal chiruheb nak tento te'tijok junelic ut inc'a' ta̱ch'ina̱nk xch'o̱leb. ");
INSERT INTO kekNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Quixye reheb: Sa' jun li tenamit quicuan jun aj rakol a̱tin inc'a' naxxucua ru li Dios, chi moco naxq'ue sa' xnak' ru li cristian. ");
INSERT INTO kekNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ut quicuan ajcui' sa' li tenamit a'an jun li xma̱lca'an cuan jun lix ch'a'ajquilal. Rajlal yo̱ chi xic riq'uin laj rakol a̱tin chixtz'a̱manquil lix tenk'anquil ut naxye re: —Ba̱nu usilal, charak a̱tin sa' xbe̱neb li xic' neque'iloc cue, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ut laj rakol a̱tin inc'a' quiraj. Abanan mokon quixye sa' xch'o̱l: —La̱in inc'a' ninxucua ru li Dios chi moco eb li cui̱nk ninq'ueheb sa' xnak' cuu. ");
INSERT INTO kekNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Abanan xban nak yo̱quin chi titz'c chirabinquil li ixk a'in, tinrak a̱tin sa' xbe̱neb li xic' neque'iloc re. Ma̱re yo̱k chinch'i'ch'i'inquil junelic, chan sa' xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ut li Ka̱cua' quixye reheb: —Q'uehomak retal c'a'ru quixye laj rakol a̱tin li inc'a' ti̱c xch'o̱l. Usta inc'a' ti̱c xch'o̱l, laj rakol a̱tin quixtenk'a li xma̱lca'an re nak inc'a' chic ta̱ch'i'ch'i'i̱k xban. ");
INSERT INTO kekNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Ma toja' ta chic li Dios inc'a' tixcoleb li sic'bileb ru xban? ¿Ma ta̱ba̱yk ta bi' chixsumenquil li c'a'ru te'xtz'a̱ma li neque'ya̱ban re lix c'aba' chi k'ek chi cutan? ");
INSERT INTO kekNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","La̱in tinye e̱re nak li Dios tixcoleb chi junpa̱t. Abanan la̱in ninc'oxla, ¿jarub ta cui' li cauhakeb xch'o̱l sa' lix pa̱ba̱l? Ut, ¿jarubeb ta cui' li yo̱keb chi tijoc nak tinc'ulu̱nk cui'chic sa' ruchich'och' la̱in li C'ajolbej? ");
INSERT INTO kekNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ut li Jesús quixye jun chic li jaljo̱quil ru a̱tin reheb li neque'xc'oxla nak cha̱bileb ut neque'xtz'ekta̱naheb li jun ch'ol chic. Quixye reheb: ");
INSERT INTO kekNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Cuib li cui̱nk co̱eb sa' li templo chi tijoc. Li jun, a'an aj fariseo. Ut li jun chic aj titz'ol toj. ");
INSERT INTO kekNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Laj fariseo quixxakab rib ut quitijoc chi cau xya̱b xcux ut quixye: —At inDios, la̱in ninbantioxi cha̱cuu nak ma̱cua'in jo'queb li jun ch'ol chic. A'an eb aj e̱lk'eb, aj ba̱nuhom ma̱usilal, ut aj muxuleb caxa̱r. La̱in ma̱cua'in jo' laj titz'ol toj a'an. ");
INSERT INTO kekNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ca' sut ninba̱nu in-ayu̱n chiru li jun xama̱n. Ut rajlal ninq'ue li junju̱nk sa' xlaje̱tkil re chixjunil li jo' q'uial li ninc'ul, chan laj fariseo sa' lix tij. ");
INSERT INTO kekNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Abanan laj titz'ol toj najt quixq'ue chak rib ut quixxulub lix jolom. Yo̱ chixtenbal li re xch'o̱l chi ruk' xban xrahil xch'o̱l ut quixye: —At inDios, la̱in aj ma̱c. Chacuuxta̱na taxak cuu, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","La̱in ninye e̱re nak laj titz'ol toj, a'an li quisuk'i sa' rochoch chi ti̱cobresinbil chic lix ch'o̱l. Ut laj fariseo inc'a', xban nak li ani naxnimobresi rib, a'an ta̱cubsi̱k xcuanquil. Ut li ani naxcubsi rib, a'an ta̱q'uehek' xcuanquil, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Sa' jun li cutan cuanqueb li que'xc'am chak lix coc'aleb riq'uin li Jesús re nak tixq'ue li ruk' sa' xbe̱neb ut ta̱rosobtesiheb. Ut eb lix tzolom li Jesús que'xq'ue retal nak que'c'ame' chak li coc'al riq'uin ut que'oc chixk'usbaleb lix na' xyucua'eb. ");
INSERT INTO kekNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ut li Jesús quixbokeb lix tzolom riq'uin ut quixye reheb: —Canabomakeb li coc'al chi cha̱lc cuiq'uin. Me̱ram chiruheb xban nak reheb a'an lix nimajcual cuanquilal li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Relic chi ya̱l tinye e̱re li ani inc'a' k'un xch'o̱l chinpa̱banquil jo'queb li coc'al a'in, a'an inc'a' ta̱oc rubel lix nimajcual cuanquilal li Dios, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jun li cui̱nk nim xcuanquil sa' xya̱nkeb laj judío quia̱tinac riq'uin li Jesús ut quixye re: —At cha̱bil tzolonel, ¿c'a'ru ta̱ru̱k tinba̱nu re nak tincue̱chani li yu'am chi junelic? chan. ");
INSERT INTO kekNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Li Jesús quixye re: —¿C'a'ut nak nacaye cha̱bil cue cui inc'a' nacanau anihin la̱in? Jun ajcui' li cha̱bil ut a'an li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","La̱at ac nacanau c'a'ru naxye sa' li chak'rab: Matmuxuc caxa̱r. Ma̱camsi a̱cuas a̱cui̱tz'in. Mat-elk'ac. Matyo'oban tic'ti' chirix a̱cuas a̱cui̱tz'in. Cha-oxlok'i la̱ na' a̱yucua', chan li Jesús re. ");
INSERT INTO kekNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Li cui̱nk quichak'oc ut quixye: —Chixjunil a'in ac yo̱quin ajcui' chak chixba̱nunquil chalen sa' inca'ch'inal, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nak quirabi li c'a'ru quixye li cui̱nk, li Jesús quixye re: —Jun chic toj ma̱ji' nacaba̱nu. C'ayi chixjunil li c'a'ru cuan a̱cue ut ta̱si lix tz'ak reheb li neba' ut ta̱cua̱nk a̱biomal sa' choxa. Nak ac xaba̱nu a'an, tatcha̱lk ut tina̱ta̱ke, chan li Jesús re. ");
INSERT INTO kekNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nak quirabi li quixye li Jesús, c'ajo' nak quiraho' sa' xch'o̱l li cui̱nk xban nak nabal lix biomal cuan. ");
INSERT INTO kekNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Li Jesús quixq'ue retal nak quiraho' sa' xch'o̱l li cui̱nk ut quixye: —C'ajo' xch'a'ajquil chok' re junak biom oc rubel lix nimajcual cuanquilal li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ma̱min ta̱ru̱k ta̱numek' junak nimla xul camello sa' ru junak cu̱x. Jo'can ajcui' li biom. Ma̱ jok'e ta̱ru̱k ta̱oc sa' xnimajcual cuanquilal li Dios cui ca'aj cui' lix biomal naxc'oxla, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Eb li que'abin re li quixye li Jesús, que'chak'oc ut que'xye: —¿Aniheb li ta̱ru̱k te'colek' chi jo'canan? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Li Jesús quixye reheb: —Li c'a'ru ch'a'aj xba̱nunquil chiru li cui̱nk, chiru li Dios moco ch'a'aj ta xba̱nunquil, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Laj Pedro quixye re li Jesús: —La̱o xkacanab chixjunil li c'a'ru ke xban a̱ta̱kenquil, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Li Jesús quixye: —Relic chi ya̱l tinye e̱re, li ani naxcanab li c'a'ru re sa' inc'aba' la̱in, tixc'ul re̱kaj. Li ani naxcanab li rochoch, lix na' xyucua', li ras ri̱tz'in, li rixakil, malaj ut lix coc'al sa' xc'aba' lix nimajcual cuanquilal li Dios, a'an tixc'ul re̱kaj. ");
INSERT INTO kekNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","K'axal nabal cui'chic li re̱kaj tixc'ul sa' li ruchich'och' a'in, jo' ajcui' sa' li choxa tixc'ul li junelic yu'am, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Tojo'nak li Jesús quixc'ameb xjuneseb lix tzolom cablaju ut quixye reheb: —Anakcuan toxic Jerusalén re nak ta̱tz'aklok ru chixjunil li tz'i̱banbil xbaneb li profeta chicuix la̱in li C'ajolbej. ");
INSERT INTO kekNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tink'axtesi̱k sa' ruk'eb li ma̱cua'eb aj judío. Tine'xhob, tine'xsac' ut tine'xchu̱ba. ");
INSERT INTO kekNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ut nak acak xine'xsac' chi us, tine'xcamsi. Abanan sa' rox li cutan tincuacli̱k cui'chic chi yo'yo sa' xya̱nkeb li camenak, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ut eb lix tzolom chi ti̱c inc'a' que'xtau ru li quixye li Jesús xban nak ch'a'aj xtaubal ru chiruheb. ");
INSERT INTO kekNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nak li Jesús yo̱ chi cuulac Jericó, cuan jun li cui̱nk mutz' ru c'ojc'o chire li be. Yo̱ chixtz'a̱manquil c'a'ru re. ");
INSERT INTO kekNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nak quirabi li q'uila tenamit yo̱queb chi numec', li mutz' quixpatz' c'a'ru yo̱ chi c'ulma̱nc. ");
INSERT INTO kekNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Que'xye re nak li Jesús aj Nazaret yo̱ chi numec'. ");
INSERT INTO kekNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Li mutz' quixjap re ut quixye: —¡At Jesús, ralalat xc'ajol laj David, la̱at li yo̱co cha̱cuoybeninquil. Chacuuxta̱na taxak cuu! chan. ");
INSERT INTO kekNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ut eb li tenamit li yo̱queb chi numec' que'oc chixk'usbal ut que'xye re: —Matchokin, chanqueb re. Abanan li mutz' k'axal cui'chic cau quixjap re ut quixye: —At ralalat xc'ajol laj David, chacuuxta̱na cuu, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nak quirabi li quixye li mutz', li Jesús quixakli ut quixtakla xc'ambal li mutz'. ");
INSERT INTO kekNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Nak quic'ame' riq'uin, li Jesús quixye re: —¿C'a'ru ta̱cuaj tinba̱nu a̱cue? chan. Ut li mutz' quixye: —Ka̱cua', tincuaj nak ta̱ilok li xnak' cuu, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Li Jesús quixye re: —Chi-ilok li xnak' a̱cuu. Xatq'uira xban nak xapa̱b nak cuan incuanquil cha̱q'uirtesinquil, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ut sa' junpa̱t qui-iloc li mutz' ut co̱ chirixeb. Yo̱ chixlok'oninquil li Dios. Ut nak que'ril li c'a'ru quic'ulman, chixjunileb li tenamit que'xq'ue xlok'al li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nak quicuulac Jericó, li Jesús yo̱ chi numec' sa' li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Aran cuan jun li cui̱nk biom aj Zaqueo xc'aba'. Li cui̱nk a'an, a'an li nataklan sa' xbe̱neb laj titz'ol toj. ");
INSERT INTO kekNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ta̱raj xnaubal ani li Jesús. Abanan xban nak k'axal nabaleb li tenamit, inc'a' quiru rilbal xban nak ca'ch'in rok. ");
INSERT INTO kekNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Jo'can nak co̱ sa' a̱nil chi ubej ut quitake' sa' ru'uj jun li che' sicómoro xc'aba' re nak ta̱ru̱k ta̱ril li Jesús xban nak aran toxnumek'. ");
INSERT INTO kekNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nak yo̱ chi numec' aran, li Jesús qui-iloc takec'. Quiril laj Zaqueo ut quixye re: —At Zaqueo, cuben chak chi junpa̱t xban nak tento nak tinhila̱nk sa' la̱ cuochoch anakcuan, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ut laj Zaqueo quicube sa' junpa̱t ut quixc'ul li Jesús sa' rochoch chi sa sa' xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nak li q'uila tenamit que'ril nak li Jesús qui-oc sa' rochoch laj Zaqueo, que'po' ut que'xye: —X-oc chi hila̱nc sa' rochoch jun cui̱nk aj ma̱c, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nak yo̱queb chi cua'ac, laj Zaqueo quixakli chiru li Jesús ut quixye re: —Ka̱cua', chalen anakcuan jalan chic tinba̱nu. Yijach lin jun cablal tinsi reheb li neba'. Ut cui cuan anihak xcuelk'a c'a'ru re, ca̱hib cua chic xq'uial li re̱kaj tinq'ue, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ut li Jesús quixye: —Li cui̱nk a'in ralal xc'ajol ajcui' laj Abraham. Anakcuan colbil chic li cui̱nk a'in. ");
INSERT INTO kekNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","La̱in li C'ajolbej xinc'ulun chixsic'bal ut chixcolbal li sachenakeb, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ut li Jesús quixye jun chic li jaljo̱quil ru a̱tin reheb li yo̱queb chi abi̱nc re, xban nak cuulaqueb re Jerusalén. Eb a'an que'xc'oxla nak li Jesús ac oc re chixxakabanquil lix nimajcual cuanquilal li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Li Jesús quixye reheb: Quicuan jun xnimal ru cui̱nk. Li cui̱nk a'an quiboke' sa' jun najtil tenamit re nak ta̱xakaba̱k chok' rey ut ta̱suk'i̱k cui'chic. ");
INSERT INTO kekNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nak ac xic re li cui̱nk quixbokeb laje̱b lix mo̱s. Quixq'ue laje̱b chi tumin re li junju̱nk ut quixye reheb: —Yaconkex chiru li tumin a'in toja' yal jok'e tana tinsuk'i̱k chak la̱in, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Aban xic' na-ile' xbaneb lix tenamit ut nak ac xco̱ li cui̱nk, que'xtakla xtakl riq'uin li ta̱xakaba̱nk re chok' rey chixyebal re: —La̱o inc'a' nakaj nak ta̱oc chok' karey li cui̱nk a'in, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Abanan li cui̱nk quixakaba̱c chok' rey. Ut nak ac x-oc chok' rey, li cui̱nk a'an quisuk'i cui'chic sa' xtenamit ut quixtakla xbokbaleb lix mo̱s li quixq'ueheb xtumin re xnaubal li jo' nimal ac xtau li junju̱nk. ");
INSERT INTO kekNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Quicuulac li xbe̱n ut quixye re: —Ka̱cua', laje̱b chic xrala la̱ tumin li xaq'ue cue, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Li rey quixye re: —La̱at cha̱bil aj c'anjel. Us xaba̱nu. Xban nak ti̱c a̱ch'o̱l riq'uin li ca'ch'in xinq'ue a̱cue, jo'can nak tinq'ue a̱cuanquil sa' xbe̱n laje̱b chi tenamit, chan li rey. ");
INSERT INTO kekNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ut quicuulac li mo̱s jun chic ut quixye: —Ka̱cua', o̱b chic xrala la̱ tumin li xaq'ue cue, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ut li rey quixye re: —Jo'can ajcui' la̱at. Cha̱bil xaba̱nu. Tinq'ue a̱cuanquil sa' xbe̱n o̱b chi tenamit, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ut quicuulac ajcui' li mo̱s jun chic ut quixye: —Ka̱cua', cue' la̱ tumin. Xinc'u̱la sa' jun sut. ");
INSERT INTO kekNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Xinxucuac a̱ban xban nak ninnau nak josk'at. Nacac'ul li tumin li inc'a' nacac'anjela ut nacatk'oloc bar cui' inc'a' nacat-au, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Quichak'oc li rey ut quixye: —La̱at ma̱c'a' nacat-oc cui'. Riq'uin ajcui' li c'a'ru xaye, tinrak a̱tin sa' a̱be̱n. Nacanau nak josk'in ut nacanau nak ninc'ul li tumin li inc'a' ninc'anjela ut nink'oloc bar cui' inc'a' nin-au. ");
INSERT INTO kekNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿C'a'ut nak inc'a' xaq'ue chi to' lin tumin? Ut la̱in nak xinsuk'i, xinc'ul raj lin tumin rochben li ral, chan li rey. ");
INSERT INTO kekNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ut li rey quixye reheb li cuanqueb aran: —Isihomak li tumin chiru ut q'uehomak re li ac cuan laje̱b chi tumin riq'uin, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Eb a'an que'chak'oc ut que'xye: —At Ka̱cua', a'an ac cuan ajcui' laje̱b chi tumin riq'uin, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Li rey quixye reheb: —La̱in ninye e̱re nak li ani cuan nabal c'a'ru re, ta̱q'uehek' cui'chic nabal re; ut li ani ca'ch'in ajcui' c'a'ru re, ta̱isi̱k chiru, usta ca'ch'in ajcui' li c'a'ru re. ");
INSERT INTO kekNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ut c'amomakeb chak li xic' neque'iloc cue li inc'a' neque'raj nak tin-oc chok' xreyeb. Ut chicuu ajcui', te̱camsiheb, chan li rey. ");
INSERT INTO kekNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nak ac xye li jaljo̱quil ru a̱tin a'in, li Jesús qui-oc cui'chic chi xic Jerusalén. ");
INSERT INTO kekNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Cuulaqueb re sa' li cuib chi tenamit Betfagé ut Betania. Nach' cuanqueb riq'uin li tzu̱l Olivos nak li Jesús quixtaklaheb cuib lix tzolom. ");
INSERT INTO kekNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Quixye reheb: —Ayukex sa' li ch'ina tenamit a'an li cuan chi nach'. Ut nak texcuulak te̱tau jun li ch'ina bu̱r bac'bo. Li ch'ina bu̱r a'an toj ma̱ ani nabe̱c chirix. Te̱hit ut te̱c'am chak arin. ");
INSERT INTO kekNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ut cui ani napatz'oc e̱re c'a'ut nak yo̱quex chixhitbal, te̱ye re nak li Ka̱cua' ta̱ajok ru li ch'ina bu̱r, cha'akex, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Que'co̱eb lix tzolom li Jesús cuib ut que'xtau chixjunil jo' quiyehe' reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nak yo̱queb chixhitbal li ch'ina bu̱r, eb laj e̱chal re que'xpatz' reheb: —¿C'a'ut nak yo̱quex chixhitbal li kabu̱r? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Eb lix tzolom li Jesús que'chak'oc ut que'xye: —Li Ka̱cua' ta̱ajok ru li bu̱r, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ut que'xc'am li ch'ina bu̱r riq'uin li Jesús. Que'xq'ue li t'icr chirix ut que'xtenk'a li Jesús chi takec' chirix. ");
INSERT INTO kekNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nak yo̱ chi xic li Jesús, nabaleb li cristian que'xhel lix t'icreb sa' be bar ta̱numek' cui' li Jesús jo' c'aynakeb xba̱nunquil nak nacuulac junak nim xcuanquil. ");
INSERT INTO kekNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Cuulaqueb re Jerusalén. Yo̱queb chak chi cubec sa' li tzu̱l Olivos ut chixjunileb li yo̱queb chixta̱kenquil li Jesús que'oc chixjapbal reheb xban xsahil xch'o̱leb. Ut que'xlok'oni li Dios xbaneb li milagro li quilaje'ril. ");
INSERT INTO kekNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Que'xye: —Osobtesinbil taxak li rey li xchal sa' xc'aba' li Ka̱cua'. Ut cua̱nk taxak li tuktu̱quilal sa' choxa. Lok'oninbil taxak li Ka̱cua' li cuan sa' choxa, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ut cuanqueb laj fariseos sa' xya̱nkeb li q'uila tenamit que'xye re: —At tzolonel k'useb la̱ tzolom, ye reheb nak te'xcanab a̱tinac.— ");
INSERT INTO kekNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Li Jesús quichak'oc ut quixye reheb: —La̱in ninye e̱re nak cui eb lin tzolom te'xcanab xq'uebal inlok'al, a' chic li pec te'xjap re chixq'uebal inlok'al, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nak cuulac re Jerusalén, li Jesús quiya̱bac chirilbal li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ut quixye: —¡Cui ta la̱ex aj Jerusalén nequenau xq'uebal retal ani ta̱ru̱k ta̱q'uehok tuktu̱quil usilal sa' eb li cutan a'in, us raj! Aban anakcuan toj mukmu che̱ru. Jo'can nak inc'a' nequetau xya̱lal. ");
INSERT INTO kekNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ta̱cuulak xk'ehil nak eb li xic' neque'iloc e̱re te'cha̱lk chi pletic e̱riq'uin. Te'xsut rix le̱ tenamit. Te'xq'ue ribeb chi xjun sutam le̱ tenamit ut la̱ex ma̱ bar chic ta̱ru̱k te̱col e̱rib. ");
INSERT INTO kekNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Te'xjuq'ui le̱ tenamit ut te'xt'an, jo'queb ajcui' chixjunileb li cuanqueb aran. Ma̱ jun chic li pec ta̱cana̱k sa' xna'aj. Te̱c'ul chi jo'can xban nak la̱ex inc'a' xeq'ue retal nak li Dios xc'ulun e̱riq'uin che̱colbal, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nak qui-oc sa' li templo, li Jesús qui-oc chixyolesinquileb chirix cab li yo̱queb chi c'ayi̱nc ut li yo̱queb chi lok'oc aran. ");
INSERT INTO kekNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Quixye reheb: —Tz'i̱banbil retalil sa' li Santil Hu chi jo'ca'in: Li cuochoch a'in re te'tijok cui' li tenamit. Abanan la̱ex xeq'ue li templo chok' xna'ajeb laj e̱lk', chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ut rajlal cutan yo̱ chixch'olobanquil xya̱lal sa' li templo. Eb li xbe̱nil aj tij, ut eb laj tz'i̱b ut eb li neque'taklan sa' xya̱nkeb laj judío yo̱queb chixc'u̱banquil chanru nak te'xcamsi. ");
INSERT INTO kekNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Abanan inc'a' que'xtau chanru te'xba̱nu xban nak chixjunileb li tenamit yo̱queb chixq'uebal xch'o̱leb chirabinquil li c'a'ru yo̱ chixyebal li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Sa' jun li cutan li Jesús yo̱ chixch'olobanquil xya̱lal li colba-ib chiruheb li tenamit li cuanqueb sa' li templo, nak que'cuulac riq'uineb li xbe̱nil laj tij ut eb laj tz'i̱b rochbeneb li xakabanbileb chi c'anjelac sa' li templo. ");
INSERT INTO kekNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ut que'xye re: —¿Ani xtaklan a̱cue chixba̱nunquil li c'a'ru yo̱cat chixba̱nunquil? ¿Ani xq'uehoc a̱cuanquil? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Li Jesús quixye reheb: —La̱in tincuaj ajcui' patz'oc e̱re. Te̱sume li tinpatz' e̱re. ");
INSERT INTO kekNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Ani quitaklan chak re laj Juan chi cubsi̱nc ha'? ¿Ma li Dios malaj ut cui̱nk quitaklan chak re? chan li Jesús reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ut que'oc chixyebal chi ribileb rib: —¿C'a'ru takasume cui'? Cui takaye nak li Dios xtaklan chak re, a'an tixye ke c'a'ut nak inc'a' xkapa̱b li c'a'ru quixye laj Juan. ");
INSERT INTO kekNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ut cui takaye nak cui̱nk xtaklan chak re, chixjunileb li tenamit toe'xcamsi chi pec xban nak eb a'an neque'xpa̱b nak laj Juan, a'an tz'akal profeta, chanqueb chi ribileb rib. ");
INSERT INTO kekNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Jo'can nak que'chak'oc ut que'xye re li Jesús: —La̱o inc'a' nakanau ani xtaklan chak re, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ut li Jesús quixye reheb: —Chi moco la̱in tinye e̱re ani xq'uehoc incuanquil chixba̱nunquil li c'a'ru ninba̱nu, chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ut li Jesús qui-oc chixyebal reheb li tenamit li jaljo̱quil ru a̱tin a'in: Jun li cui̱nk quirau jun si̱r li racui̱mk uvas. Quixq'ue chi to' riq'uineb li cui̱nk aj c'alom. Ut co̱ sa' jalan tenamit ut najt quisach. ");
INSERT INTO kekNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nak quicuulac xk'ehil xsic'bal ru li acui̱mk, laj e̱chal re quixtakla jun lix mo̱s riq'uineb li cui̱nk chixc'ulbal li jo' q'uial ru li racui̱mk li ta̱tz'ak a'an. Abanan eb li cui̱nk que'xchap li mo̱s ut que'xsac'. Ut quisuk'i chi ma̱c'a' que'xq'ue re. ");
INSERT INTO kekNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Laj e̱chal re li acui̱mk quixtakla jun chic lix mo̱s riq'uineb. Ut jo'can ajcui' que'xba̱nu re a'an. Que'xhob ut que'xsac' ut quisuk'i a'an chi ma̱c'a' que'xq'ue re. ");
INSERT INTO kekNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ut laj e̱chal re li ch'och' quixtakla cui'chic jun lix mo̱s. Ut eb li cui̱nk k'axal ra que'xba̱nu re ut que'xcut chirix li na'ajej a'an. ");
INSERT INTO kekNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Tojo'nak laj e̱chal re li ch'och' quixye: —¿C'a'ru tinba̱nu anakcuan? Tintakla li cualal li k'axal raro inban. Nak te'ril li cualal, ma̱re te'xc'ul sa' xya̱lal, chan sa' xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Que'ril nak yo̱ chi cuulac li ralal, ut que'xye chi ribileb rib: —A'an li ta̱e̱chani̱nk re li na'ajej. Kacamsihak, chanqueb, re nak la̱o chic toe̱chani̱nk re. ");
INSERT INTO kekNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Que'risi sa' li na'ajej a'an ut que'xcamsi. ¿C'a'ru nequeye la̱ex? ¿C'a'ru tixba̱nu laj e̱chal re li acui̱mk riq'uineb li cui̱nk a'in? La̱in tinye e̱re c'a'ru tixba̱nu. ");
INSERT INTO kekNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ta̱cha̱lk ut tixcamsiheb laj ilol re li racui̱mk ut jalan chic aj e tixq'ue li jun si̱r chi uvas, chan li Jesús. Nak que'rabi li quixye li Jesús, eb a'an que'xye: —Inc'a' taxak chic'ulma̱nk chi jo'can, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Li Jesús quirileb ut quixye reheb: —¿C'a'ru naraj naxye a'in li tz'i̱banbil sa' li Santil Hu, li que'xye li profeta chicuix? Li pec li que'xtz'ekta̱na laj cablanel, a'an li k'axal lok' li quiq'uehe' chok' xxuc li cab. (Sal. 118:22) ");
INSERT INTO kekNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Li ani ta̱t'anek' sa' xbe̱n li pec a'in, tixtoch'i rib. Coc' puc' ta̱cana̱k. Ut ani sa' aj be̱n ta̱t'anek' li pec a'in, xujinbil ta̱cana̱k. ");
INSERT INTO kekNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Eb laj tz'i̱b ut eb li xbe̱nil aj tij que'xtau ru nak reheb a'an quixye li jaljo̱quil ru a̱tin a'in ut que'raj raj xchapbal sa' li ho̱nal a'an. Abanan inc'a' que'ru xban nak que'xucuac chiruheb li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Eb laj tz'i̱b ut eb li xbe̱nil aj tij yo̱queb chixq'uebal retal jok'e tz'akal ta̱ru̱k te'xchap li Jesús. Ut que'xtaklaheb aj q'uehol etal riq'uin. Laj q'uehol etal que'xba̱nu ribeb nak ti̱queb xch'o̱l yal re rilbal cui tixye junak a̱tin re nak ta̱ru̱k te'xchap ut te'xc'am riq'uin li acuabej. ");
INSERT INTO kekNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Xban a'an nak que'xye re chi jo'ca'in: —At tzolonel, nakanau nak la̱at ya̱l nacat-a̱tinac ut sa' xya̱lal nacac'ut li xya̱lal chiruheb li tenamit. Inc'a' nacasic' ru ani nacara. Sa' xya̱lal nacac'ut chiruheb li c'a'ru naraj li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ye ke c'a'ru naxye li chak'rab. ¿Ma us takaq'ue li katoj re laj César li acuabej malaj ut inc'a'? chanqueb re. ");
INSERT INTO kekNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Li Jesús quixnau nak aj balak'eb. Jo'can nak quixye reheb: —¿C'a'ut nak nequeraj xyalbal cuix? ");
INSERT INTO kekNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","C'ut junak li tumin chicuu. ¿Ani aj e li jalam u̱ch li cuan chiru? Ut, ¿ani aj c'aba' li tz'i̱banbil chiru? chan. Eb a'an que'chak'oc ut que'xye: —Re li acuabej. ");
INSERT INTO kekNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ut li Jesús quixye reheb: —Tojomak re li acuabej li c'a'ru re li acuabej, ut tojomak re li Dios li c'a'ru re li Dios, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ut ma̱ jun a̱tin que'xtau re ta̱ru̱k te'xye nak cuan xma̱c. Ut que'sach xch'o̱leb xban li a̱tin li que'sume̱c cui' xban li Jesús. Jo'can nak ma̱c'a' chic que'xye. ");
INSERT INTO kekNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Cuanqueb cuib oxib laj saduceo que'cuulac riq'uin li Jesús. Eb a'an inc'a' neque'xpa̱b nak te'cuacli̱k cui'chic chi yo'yo li camenak. Que'xye re li Jesús: ");
INSERT INTO kekNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—At tzolonel, laj Moisés quixtz'i̱ba jun li chak'rab chok' ke. Naxye chi jo'ca'in: Cui junak cui̱nk ta̱ca̱mk ut ma̱ jun li ralal xc'ajol ta̱cua̱nk, ta̱sumla̱k li ri̱tz'in li camenak riq'uin li xma̱lca'an re nak ta̱cua̱nk ralal xc'ajol sa' xc'aba' li camenak. ");
INSERT INTO kekNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Que'cuan cuukub li cui̱nk ri̱tz'ineb rib. Li asbej quixc'am rixakil ut quicam chi inc'a' quicuan ralal xc'ajol. ");
INSERT INTO kekNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ut quic'ame' li ixk xban li ri̱tz'in li camenak ut quicam ajcui' li cui̱nk a'an ut chi moco a'an quicuan ralal xc'ajol riq'uin li ixk. ");
INSERT INTO kekNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ut jo'can cui'chic li rox i̱tz'inbej. Li ixk quicuan chok' rixakil li cuukub chi cui̱nk ut ma̱ jun reheb quicuan ralal xc'ajol riq'uin li ixk a'an. ");
INSERT INTO kekNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ut quicam ajcui' li ixk. ");
INSERT INTO kekNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Sa' xcuaclijiqueb li camenak chi yo'yo, nak te'cuacli̱k eb a'an, ¿ani aj ixakil ta̱cana̱k cui' li ixk a'an xban nak cuukub lix be̱lom quicuan? chanqueb re li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Quichak'oc li Jesús ut quixye reheb: —Eb li cuanqueb sa' ruchich'och' anakcuan neque'sumla ut neque'sumuba̱c. ");
INSERT INTO kekNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Abanan sa' eb li cutan ta̱cha̱lk, li xc'ulubeb cuacli̱c cui'chic chi yo'yo sa' xya̱nkeb li camenak, inc'a' chic te'sumla̱k chi moco te'sumuba̱k. ");
INSERT INTO kekNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Jo'cakeb ban chic li ángel sa' choxa. Inc'a' chic te'ca̱mk. Te'cuacli̱k cui'chic chi yo'yo sa' xya̱nkeb li camenak, xban nak a'an eb li ralal xc'ajol li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","La̱ex nequeye nak inc'a' te'cuacli̱k cui'chic chi yo'yo li camenak. Abanan laj Moisés quixc'utbesi ajcui' chak junxil nak eb li camenak te'cuacli̱k cui'chic chi yo'yo. Tz'i̱banbil retalil sa' li Santil Hu li quixye nak yo̱ chi c'atc li q'uix. Quixye nak li Dios, a'an lix Dios laj Abraham, lix Dios laj Isaac, ut lix Dios laj Jacob. ");
INSERT INTO kekNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Li Dios, a'an moco xDioseb ta camenak; xDioseb ban li yo'yo̱queb, xban nak toj yo'yo̱queb chiru li Dios usta ac camenakeb, chan li Jesús reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Cuanqueb laj tz'i̱b que'chak'oc ut que'xye re: —At tzolonel, tz'akal re ru li xaye, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ut ma̱ ani chic quiraj patz'oc riq'uin li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Li Jesús quixye reheb: —Neque'xye nak li Cristo laj Colonel a'an xcomoneb li ralal xc'ajol li rey David. ");
INSERT INTO kekNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tz'i̱banbil retalil sa' li Santil Hu sa' li Salmos li quixye li rey David. Quixye: Li Ka̱cua' Dios quixye re li Ka̱cua' laj Colol cue, c'ojlan sa' li nim uk' ");
INSERT INTO kekNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","toj tinq'ueheb li xic' neque'iloc a̱cue rubel la̱ cuanquil. (Sal. 110:1) ");
INSERT INTO kekNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Li rey David quixye “aj Colol cue” re li Ka̱cua', usta a'an xcomoneb li ralal xc'ajol, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Chixjunileb li tenamit yo̱queb chirabinquil nak li Jesús quixye reheb lix tzolom: ");
INSERT INTO kekNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Me̱tzol e̱rib riq'uineb laj tz'i̱b li neque'cuulac chiruheb xq'uebal li rak'eb chirixeb chi najt rok nak neque'be̱c re xc'utbal nak cuanqueb xcuanquil. Eb a'an neque'cuulac chiru nak te'q'uehek' xlok'al sa' eb li be. Ut nak cuanqueb sa' li cab li neque'xch'utub cui' ribeb, neque'cuulac chiruheb c'ojla̱c toj chi ubej. Ut nak neque'boke' sa' junak nink'e, neque'cuulac chiruheb chunla̱c sa' li me̱x li neque'chunla cui' li cuanqueb xcuanquil. ");
INSERT INTO kekNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ut neque'xmak' li c'a'ru cuan reheb li xma̱lca'an. Ut najt rok lix tijeb neque'xba̱nu nak neque'tijoc chiruheb li tenamit re xmukbal li ma̱usilal li neque'xba̱nu. Eb a'an k'axal ra te'xtoj cui' li ma̱c neque'xba̱nu, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Sa' jun li cutan li Jesús cuan sa' li templo ut quiril nak eb li biom yo̱queb chixq'uebal lix mayejeb sa' li ca̱x. ");
INSERT INTO kekNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ut quiril ajcui' nak jun li xma̱lca'an neba' quixq'ue sa' li ca̱x cuib li tumin cobre chok' xmayej. ");
INSERT INTO kekNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ut li Jesús quixye: —Relic chi ya̱l ninye e̱re nak li xma̱lca'an neba' nabal xq'ue chiru li que'xq'ue li biom, ");
INSERT INTO kekNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","xban nak chixjunileb a'an xe'xq'ue li x-ela'an chiruheb. Abanan li ixk a'in, usta neba', xq'ue chixjunil li jo' nimal cuan re, li re raj xnumsinquil li cutan junju̱nk. ");
INSERT INTO kekNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Cuanqueb li yo̱queb chi a̱tinac chirix lix ch'ina'usal li templo. Yo̱queb chixyebal: —C'ajo' xchak'al ru li pec li yi̱banbil cui' li templo jo' ajcui' li mayej li que'xq'ue chok' xsahob ru, chanqueb. Ut li Jesús quixye reheb: ");
INSERT INTO kekNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Ta̱cuulak xk'ehil nak ta̱sachek' ru chixjunil li yo̱quex chirilbal anakcuan. Ma̱ jun reheb li pec a'an ta̱cana̱k sa' xna'aj chi inc'a' ta ta̱juq'ui̱k, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Que'xpatz' re: —At tzolonel, ¿jok'e ta̱c'ulma̱nk li yo̱cat chixyebal? ¿C'a'ru retalil ta̱cua̱nk nak talajc'ulma̱nk li c'a'ak re ru a'in? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Li Jesús quixye reheb: —Cheba̱nu cue̱nt re nak inc'a' texbalak'i̱k xban nak nabal te'cha̱lk chi balak'i̱nc ut te'xye nak sa' inc'aba' la̱in xe'chal. Te'xye, “La̱in li Cristo li yechi'inbil xban li Dios” cha'keb. Ut te'xye, “Anakcuan xcuulac xk'ehil.” cha'keb. Abanan me̱pa̱b li c'a'ru te'xye eb a'an. ");
INSERT INTO kekNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nak te̱rabi nak yo̱ li ple̱t ut li ch'a'ajquilal yalak bar, mexxucuac xban nak tento nak ta̱c'ulma̱nk chi jo'can. Abanan moco ac a'an ta roso'jiqueb li cutan, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ut quixye ajcui': —Nabal li tenamit te'pletik riq'uin jalan chic tenamit. Ut eb li acuabej te'xpleti ribeb. ");
INSERT INTO kekNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Talajcua̱nk hi̱c sa' nabal chi na'ajej ut ta̱cua̱nk cue'ej ut yajel. Ta̱cua̱nk ni̱nki raylal ut xucuajel rilbal li retalil li talajc'utu̱nk sa' choxa. ");
INSERT INTO kekNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Abanan nak toj ma̱ji' nac'ulman chixjunil li c'a'ak re ru a'in, texchapek' ut texrahobtesi̱k. Texc'amek' sa' li cab li neque'xch'utub cui' ribeb laj judío ut texc'amek' sa' tz'alam. Texc'amek' chiruheb li rey ut eb laj rakol a̱tin sa' inc'aba' la̱in. ");
INSERT INTO kekNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ut a'an ta̱c'anjelak e̱re re xch'olobanquil resil li colba-ib. ");
INSERT INTO kekNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Q'uehomak bi' sa' e̱ch'o̱l a'in, nak moco toj yo̱kex ta chixc'oxlanquil chanru texsume̱nk cui' re xcolbal e̱rib, ");
INSERT INTO kekNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","xban nak la̱in tinq'ue e̱na'leb ut tinc'ut che̱ru c'a'ru te̱ye. Ut eb li xic' neque'iloc e̱re inc'a' te'ru̱k chixcuech'bal rix li c'a'ru te̱ye, chi moco te'xnau xsumenquil. ");
INSERT INTO kekNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Texk'axtesi̱k sa' ruk'eb li xic' neque'iloc e̱re xbaneb le̱ na' e̱yucua' ut xbaneb le̱ ras ut le̱ ri̱tz'in ut eb le̱ rech'alal jo' eb ajcui' le̱ rami̱g. Ut cuan li cuanqueb sa' e̱ya̱nk li te'camsi̱k. ");
INSERT INTO kekNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ut xic' tex-ilek' xbaneb chixjunileb li tenamit sa' inc'aba' la̱in. ");
INSERT INTO kekNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Abanan ma̱c'a' te̱c'ul. ");
INSERT INTO kekNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Cui inc'a' nach'inan e̱ch'o̱l sa' le̱ pa̱ba̱l usta yo̱kex chi c'uluc raylal te̱re̱chani li junelic yu'am. ");
INSERT INTO kekNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Nak te̱ril li tenamit Jerusalén sutsu̱k xbaneb li q'uila soldado, la̱ex te̱nau nak ac xcuulac xk'ehil li roso'jic. ");
INSERT INTO kekNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ut eb li cuanqueb sa' li na'ajej Judea che'e̱lelik sa' junpa̱t ut che'xicak sa' eb li tzu̱l. Eb li cuanqueb sa' li tenamit Jerusalén che'e̱lk aran ut eb li cuanqueb sa' c'aleba̱l inc'a' chic te'suk'i̱k sa' li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ut sa' eb li cutan a'an, li Dios tixq'ueheb chixtojbal rix lix ma̱queb li xic' neque'iloc re. Chi jo'can ta̱tz'aklok ru chixjunil li tz'i̱banbil retalil sa' li Santil Hu. ");
INSERT INTO kekNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","K'axal ra cui'chic chok' reheb li yaj aj ixk ut li yo̱queb chi tu'resi̱nk sa' eb li cutan a'an, xban nak ma̱ ca'ch'in li raylal te'xc'ul li tenamit a'an xban nak yo̱k xjosk'il li Dios sa' xbe̱neb. ");
INSERT INTO kekNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Cuan li te'camsi̱k riq'uin ch'i̱ch' ut cuan li te'chapek' ut te'c'amek' chi pre̱xil sa' eb li jalan tenamit. Ut li tenamit Jerusalén ta̱cana̱k rubel xcuanquileb li ma̱cua'eb aj judío toj ta̱cuulak xk'ehil nak li Dios ta̱risiheb lix cuanquileb li ma̱cua'eb aj judío, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ut ta̱cua̱nk retalil chiru li sak'e, li po ut eb li chahim. Ut eb li cuanqueb sa' ruchich'och' te'yot'ek' ut te'sach xch'o̱leb xban lix ya̱b ut lix cau ok li palau. ");
INSERT INTO kekNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Te'lucta̱k li cui̱nk xbaneb xxiu nak yo̱keb chixc'oxlanquil li raylal li ta̱cha̱lk sa' ruchich'och'. Ut ta̱ec'a̱nk sa' xna'aj li choxa. ");
INSERT INTO kekNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Chirix a'an te̱ril nak la̱in li C'ajolbej yo̱kin chak chi cha̱lc sa' choxa riq'uin lix nimal incuanquilal ut inlok'al. ");
INSERT INTO kekNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nak acak xticla xc'ulbal chixjunil li c'a'ak re ru a'in, cacuubresihomak e̱ch'o̱l ut yo'on cua̱nkex. Chisahok' sa' e̱ch'o̱l xban nak cuulac re xk'ehil nak texcolek', chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ut quixye jun chic li jaljo̱quil ru a̱tin reheb. Quixye: Cheq'uehak retal li jun to̱n chi higo ut chixjunileb li che'. ");
INSERT INTO kekNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nak nak'unk'ut chak lix xak li che' chi e̱lc, riq'uin a'an nequeq'ue retal nak yo̱ chak chi nach'oc li sak'ehil. ");
INSERT INTO kekNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Jo'can ajcui' la̱ex nak te̱ril nak yo̱k chi c'ulma̱nc chixjunil li c'a'ak re ru a'in, a'an retalil nak yo̱ chak chi nach'oc lix nimajcual cuanquil li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Relic chi ya̱l ninye e̱re nak inc'a' ta̱osok' li tenamit a'in chi toj ma̱ji'ak nac'ulman chixjunil li c'a'ak re ru a'in. ");
INSERT INTO kekNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Li choxa ut li ruchich'och' talaje'osok'. Abanan li cua̱tin inc'a' ta̱cana̱k yal chi jo'can chi inc'a' ta ta̱c'ulma̱nk li c'a'ru naxye. ");
INSERT INTO kekNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Chenauhak xcolbal e̱rib. Me̱q'ue e̱rib chi a̱le̱c riq'uin li numcua'ac ut li cala̱c, chi moco riq'uin xc'oxlanquil chanru te̱numsi li cutan junju̱nk. Ma̱re anchal ta̱cuulak xk'ehil li cutan a'an chi ma̱c'a' sa' e̱ch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ta̱cha̱lk chi ma̱c'a' sa' e̱ch'o̱l jo' nak naq'ueman junak ra'al chi ma̱ ani nana'oc re. ");
INSERT INTO kekNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Jo'can ut yo'on cua̱nkex ut junelic chextijok re nak cauhak e̱ch'o̱l chixcuybal xnumsinquil li raylal li ta̱cha̱lk sa' e̱be̱n, ut re nak ta̱ru̱k texcuulak cuiq'uin la̱in li C'ajolbej, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Rajlal cutan li Jesús naxch'olob xya̱lal chiruheb sa' li templo ut nak na-ecuu, naxic sa' li tzu̱l Olivos chixnumsinquil li k'ojyi̱n. ");
INSERT INTO kekNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ut chixjunileb li tenamit neque'xxic sa' li templo rajlal ek'ela chirabinquil li c'a'ru naxye li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yo̱ chi cuulac xcutanquil li nink'e nak neque'xcua' li caxlan cua ma̱c'a' xch'amal. Pascua nayeman re li nink'e a'an. ");
INSERT INTO kekNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Eb lix be̱nil aj tij ut eb laj tz'i̱b yo̱queb chixsic'bal chanru nak ta̱ru̱k te'xcamsi li Jesús. Abanan yo̱queb xc'a'ux xban nak inc'a' que'raj xchik'bal xjosk'ileb li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Laj Judas Iscariote jun reheb lix cablaju chi xtzolom li Jesús. A'an quixq'ue rib chi a̱le̱c xban laj tza. ");
INSERT INTO kekNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Co̱ riq'uineb li xbe̱nil aj tij ut riq'uineb li neque'c'ac'alen re li templo chixyebal reheb nak tixk'axtesi li Jesús sa' ruk'eb. ");
INSERT INTO kekNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Que'saho' xch'o̱leb chirabinquil li quixye ut que'xyechi'i xtumin. ");
INSERT INTO kekNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ut quixc'ul xch'o̱l laj Judas li quiyehe' re. Jo'can nak qui-oc xsic'bal jok'e ta̱ru̱k tixk'axtesi li Jesús sa' ruk'eb chi inc'a' te'xnau li q'uila tenamit. ");
INSERT INTO kekNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Quicuulac xk'ehil li nink'e Pascua nak neque'xcua' li caxlan cua ma̱c'a' xch'amal. Sa' li nink'e a'an tento nak te'xcamsi junak li carner. ");
INSERT INTO kekNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Li Jesús quixye reheb laj Pedro ut laj Juan: —Ayukex ut cauresihomak chak li tzacae̱mk re li pascua re totzaca̱nk, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Que'xpatz' re: —¿Bar ta̱cuaj takacauresi chak?— ");
INSERT INTO kekNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Li Jesús quixye reheb: —Nak tex-oc sa' li tenamit, aran te̱tau jun li cui̱nk yo̱ chixc'ambal jun cuc xha'. Te̱ta̱ke a'an toj sa' li cab bar tox-ocak cui'. ");
INSERT INTO kekNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ut te̱ye re laj e̱chal cab, “Chan laj tzolonel, ¿bar cuan li na'ajej li ta̱cua'ak cui' sa' li nink'e Pascua rochbeneb lix tzolom?” cha'akex re. ");
INSERT INTO kekNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ut a'an tixc'ut che̱ru jun nimla na'ajej takec' sa' xca' tasalil li cab. Ac yi̱banbil li na'ajej. Ut aran te̱cauresi li nink'e chok' ke, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Que'co̱eb sa' li tenamit ut qui-uxman jo' quixye li Jesús. Ut aran que'xcauresi li nink'e Pascua. ");
INSERT INTO kekNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nak quicuulac x-o̱ril, li Jesús quic'ojla sa' li me̱x rochbeneb lix tzolom. ");
INSERT INTO kekNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ut quixye reheb: —C'ajo' nak yo̱quin chixrahinquil ru nak tocua'ak cuochbenex sa' li nink'e a'in nak toj ma̱ji' nincam. ");
INSERT INTO kekNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Relic chi ya̱l ninye e̱re nak inc'a' chic tinba̱nu li nink'e Pascua toj ta̱cuulak xk'ehil nak tinba̱nu cui'chic sa' lix nimajcual cuanquilal li Dios, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ut quixchap li sec' re uc'ac. Quixbantioxi chiru li Dios ut quixye: —C'ulumak a'in ut jeq'uihomak sa' e̱ya̱nk li cuan chi sa', ");
INSERT INTO kekNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","xban nak la̱in tinye e̱re nak chalen anakcuan inc'a' chic tincuuc' xya'al li uva toj ta̱cuulak xk'ehil nak tincuuc' cui'chic sa' lix nimajcual cuanquilal li Dios, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ut quixchap li caxlan cua, quixbantioxi chiru li Dios, tojo'nak quixjachi ut quixq'ue reheb lix tzolom ut quixye: —A'an a'in lin tz'ejcual, k'axtesinbil re camsi̱c sa' e̱c'aba' la̱ex. Cheba̱nuhak re xjulticanquil lin camic, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Jo'can ajcui' quixba̱nu nak ac xrake' chi cua'ac. Quixchap li sec' re uc'ac ut quixye: —A'an a'in retalil li ac' contrato li ta̱xakaba̱k xcuanquil riq'uin lin quiq'uel li ta̱hoyek' nak tincamsi̱k sa' e̱c'aba' la̱ex, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ut quixye ajcui' li Jesús: —Nacuaj nak te̱nau nak li cui̱nk li ta̱k'axtesi̱nk cue yo̱ chi cua'ac sa' me̱x cuochben. ");
INSERT INTO kekNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tento nak tincamsi̱k la̱in li C'ajolbej. Abanan raylal cuan sa' xbe̱n li cui̱nk li ta̱k'axtesi̱nk cue, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ut eb a'an que'oc chixpatz'inquil chi ribileb rib ut que'xye: —¿Ani anchal li ta̱k'axtesi̱nk re? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Eb lix tzolom li Jesús que'oc chixcuech'inquil rix chi ribileb rib ani tana sa' xya̱nkeb nimak xcuanquil. ");
INSERT INTO kekNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Li Jesús quixye reheb: —Eb li rey li cuanqueb sa' ruchich'och' cuanqueb xcuanquil sa' xbe̱neb li tenamit. Eb a'an neque'raj nak cha̱bil ta̱yehek' chirixeb. ");
INSERT INTO kekNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Abanan la̱ex inc'a' te̱ba̱nu chi jo'can. Li ani naraj xcuanquil sa' e̱ya̱nk, tento nak tixcubsi rib ut ta̱c'anjelak che̱ru. Li ani ta̱raj c'amoc be sa' e̱ya̱nk, tento nak tixcubsi rib ut ta̱c'anjelak che̱ru. ");
INSERT INTO kekNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Anili k'axal nim xcuanquil nak nequec'oxla la̱ex? ¿Ma li nac'ojla sa' me̱x, malaj ut li nac'anjelac chiru? ¿Ma ma̱cua' ta bi' li ani nac'ojla sa' me̱x? La̱in cuan incuanquil, aban cuanquin sa' e̱ya̱nk jo' jun aj c'anjel che̱ru. ");
INSERT INTO kekNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","La̱ex xecuy cuochbeninquil sa' li ra xi̱c' xinc'ul. ");
INSERT INTO kekNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Jo'can nak tinq'ue e̱cuanquil la̱ex jo' nak xq'ue incuanquil la̱in lin Yucua'. ");
INSERT INTO kekNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","La̱ex texcua'ak ut tex-uc'ak sa' lin me̱x nak cua̱nkin sa' lin cuanquil. Ut la̱ex texc'ojla̱k sa' le̱ c'ojariba̱l ut texrakok a̱tin sa' xbe̱neb li cablaju xte̱paleb laj Israel, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ut quixye li Ka̱cua': —At Simón, laj tza ac xpatz' xlese̱ns re nak tixyal rix le̱ pa̱ba̱l jo' nak nachik'e' ru li trigo re risinquil li rix. ");
INSERT INTO kekNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Abanan la̱in xintijoc cha̱cuix re nak inc'a' ta̱canab la̱ pa̱ba̱l. Ut nak tatsuk'i̱k cui'chic cuiq'uin, ta̱q'ue xcacuilal xch'o̱leb la̱ cuech aj pa̱banelil, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ut laj Pedro quixye re: —At Ka̱cua', la̱in cau inch'o̱l cha̱ta̱kenquil usta tine'xq'ue sa' tz'alam malaj ut tine'xcamsi a̱cuochben, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ut li Jesús quixye re: —At Pedro, la̱in ninye a̱cue, anakcuan ajcui' nak toj ma̱ji' naya̱bac laj tzo' xul, la̱at ac xaye oxib sut nak inc'a' nacanau cuu, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ut quixye cui'chic reheb lix tzolom: —Nak quexintakla chi ma̱c'a' e̱bo̱ls, chi ma̱c'a' xna'aj e̱tumin, chi ma̱c'a' e̱xa̱b, ¿ma cuan ta bi' c'a'ru xpalto' e̱re? Ut eb a'an que'xye: —Ma̱c'a' quipalto' ke. ");
INSERT INTO kekNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Quixye cui'chic li Jesús reheb: —Ut anakcuan li ani cuan xbo̱ls, xc'amak chirix jo' ajcui' xna'aj lix tumin. Ut li ani ma̱c'a' xch'i̱ch', tixc'ayi lix chaque̱t ut xlok'ak xch'i̱ch' chiru li tumin a'an. ");
INSERT INTO kekNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Relic chi ya̱l ninye e̱re nak tento ta̱tz'aklok ru li c'a'ru tz'i̱banbil chicuix sa' li Santil Hu, li naxye chi jo'ca'in: Quiq'uehe' sa' ajl sa' xya̱nkeb li inc'a' useb xna'leb. Tento nak ta̱c'ulma̱nk li c'a'ru tz'i̱banbil retalil chicuix, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Eb a'an que'xye: —Ka̱cua', cuan arin cuib li ch'i̱ch', chanqueb. Ut li Jesús quixye: —Tz'akal li xeye. Mex-a̱tinac chic. ");
INSERT INTO kekNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Li Jesús qui-el aran ut co̱ sa' li tzu̱l Olivos, jo' c'aynak xba̱nunquil. Ut eb lix tzolom que'xta̱ke. ");
INSERT INTO kekNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nak quicuulac sa' li na'ajej a'an, quixye reheb lix tzolom: —Chextijok re nak inc'a' te̱q'ue e̱rib chi a̱le̱c, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ut li Jesús quirisi rib sa' xya̱nkeb jo' na xnajtil nacute' cui' junak pec. Ut aran quixcuik'ib rib chi tijoc. ");
INSERT INTO kekNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Quixye: —At inyucua', cui la̱at ta̱cuaj, inc'a' raj tinc'ul li raylal a'in. Abanan chi-uxma̱nk li c'a'ru nacacuaj la̱at ut ma̱cua' li nacuaj la̱in, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ut quichal jun li ángel sa' choxa ut quixq'ue xcacuil xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Nak yo̱ chi yot'ec' xch'o̱l, quitijoc cui'chic li Jesús chi k'axal anchal xch'o̱l ut lix tikob yo̱ chi tz'ukuc sa' ch'och' chi ni̱nki tz'ukul chanchan quic'. ");
INSERT INTO kekNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nak quirake' chi tijoc, quicuacli ut co̱ riq'uineb lix tzolom. Quiril nak yo̱queb chi cua̱rc xban nak k'axal ra sa' xch'o̱leb. ");
INSERT INTO kekNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ut li Jesús quixye reheb: —¿C'a'ut nak yo̱quex chi cua̱rc? Cuaclinkex ut tijonkex re nak inc'a' te̱q'ue e̱rib chi a̱le̱c, chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Toj yo̱ ajcui' chi a̱tinac li Jesús nak que'cuulac li q'uila tenamit. Laj Judas, a'an yo̱ chi c'amoc be chiruheb. A'an jun reheb lix tzolom cablaju. Quijiloc chixc'atk li Jesús re nak ta̱rutz' ru. ");
INSERT INTO kekNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ut li Jesús quixye re: —At Judas, ¿ma ta̱cuutz' cuu re ink'axtesinquil, la̱in li C'ajolbej? chan re. ");
INSERT INTO kekNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ut li cuanqueb rochben que'ril li c'a'ru yo̱ chixba̱nunquil ut que'xpatz' re: —Ka̱cua', ¿ma takaq'ueheb chi ch'i̱ch'? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ut jun reheb quixyoc' lix xic lix mo̱s li xyucua'il aj tij ut quirisi lix xic li cuan sa' xnim. ");
INSERT INTO kekNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Li Jesús quixye: —Canabomak xba̱nunquil a'an, chan. Ut quixch'e' riq'uin ruk' lix xic li cui̱nk ut quixq'uirtesi. ");
INSERT INTO kekNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ut quixye reheb li xbe̱nil aj tij, ut eb li neque'taklan sa' li templo, jo'queb ajcui' li neque'c'amoc be, li que'chal chixchapbal: —¿Ma la̱in ta bi' aj e̱lk' nak xexchal chinchapbal riq'uin che' ut riq'uin ch'i̱ch'? ");
INSERT INTO kekNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Rajlal cutan cuanquin sa' e̱ya̱nk che̱tzolbal sa' li templo ut inc'a' quine̱chap aran. Abanan anakcuan xcuulac xk'ehil nak te̱ba̱nu li c'a'ru te̱raj la̱ex riq'uin xcuanquil laj tza, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Que'xchap li Jesús ut que'xc'am sa' rochoch li xyucua'il aj tij. Ut laj Pedro yo̱ chixta̱kenquil chi najt. ");
INSERT INTO kekNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Que'xtz'ab jun li xam chiru neba̱l, ut quilaje'c'ojla chire xam, ut quic'ojla ajcui' laj Pedro sa' xya̱nkeb. ");
INSERT INTO kekNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ut jun li mo̱s ixk quiril laj Pedro c'ojc'o chire xam. Quixca'ya ut quixye: —Li cui̱nk a'in, a'an jun reheb li neque'ochbenin re li Jesús, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Abanan laj Pedro quitic'ti'ic ut quixye: —At ixk, la̱in inc'a' ninnau ru ani li nacaye, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Junpa̱t na chic nak jun li cui̱nk qui-iloc re laj Pedro ut quixye: —La̱at jun xcomoneb a'an, chan re. Ut laj Pedro quixye: —At cui̱nk, ma̱cua' la̱in xcomoneb, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ac xnume' na chic jun o̱r, nak jun chic li cui̱nk quixye: —Relic chi ya̱l nak li cui̱nk a'in, a'an jun reheb li que'ochbenin re li Jesús. Li cui̱nk a'in aj Galilea, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ut laj Pedro quixye: —At cui̱nk, inc'a' ninnau c'a'ru yo̱cat chixyebal, chan. Ut toj yo̱ ajcui' chi a̱tinac laj Pedro nak quiya̱bac li tzo' xul. ");
INSERT INTO kekNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ut li Ka̱cua' quixsuk'isi rib ut quixca'ya laj Pedro. Ut quinak sa' xch'o̱l laj Pedro li quiyehe' re xban li Ka̱cua', “Toj ma̱ji' ajcui' naya̱bac li tzo' xul, nak la̱at ac xaye oxib sut nak inc'a' nacanau cuu.” ");
INSERT INTO kekNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Laj Pedro qui-el chirix cab ut c'ajo' nak quiya̱bac xban xrahil xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Eb li cui̱nk li yo̱queb chi c'ac'ale̱nc re li Jesús, que'xhob ut que'xsac'. ");
INSERT INTO kekNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Que'xbac' chi t'icr li xnak' ru re nak inc'a' ta̱ilok, que'xsac' ut que'xye: —K'ehi ani xsac'oc a̱cue, chanqueb re. ");
INSERT INTO kekNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ut nabal chic c'a'ak re ru que'xye re xhobbal li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nak quicutano', que'xch'utub ribeb li neque'c'amoc be sa' xya̱nkeb li tenamit ut eb li xbe̱nil aj tij jo' eb ajcui' laj tz'i̱b. Ut que'xc'am li Jesús riq'uineb li neque'taklan sa' xbe̱neb laj judío. Ut que'xye re: ");
INSERT INTO kekNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Ye ke. ¿Ma la̱at li Cristo, laj Colonel li yechi'inbil xban li Dios? chanqueb. Ut li Jesús quixye reheb: —Cui tinye e̱re nak la̱in, inc'a' ajcui' raj te̱pa̱b, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ut cui tinpatz'ok e̱re, inc'a' aj raj cui' te̱sume li c'a'ru tinpatz', chi moco tine̱rach'ab. ");
INSERT INTO kekNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ut chalen anakcuan la̱in li C'ajolbej tinc'ojla̱k sa' xnim uk' li nimajcual Dios, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ut chixjunileb que'xye re: —¿Ma la̱at li Ralal li Dios chi jo'canan? Ut li Jesús quichak'oc ut quixye: —Ya̱l li xeye nak la̱in, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ut chixjunileb que'xye: —¿C'a' chic ru aj e nak toj te'xye ke c'a'ru xma̱c? Riq'uin kaxic xkabi li c'a'ru xye, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ut chixjunileb li neque'taklan sa' xya̱nkeb laj judío que'xc'am li Jesús riq'uin laj Pilato. ");
INSERT INTO kekNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Que'oc chixjitbal ut que'xye: —Xkaq'ue retal nak li cui̱nk a'in yo̱ chixpo'bal xch'o̱leb li katenamit. Nocoxk'us riq'uin xq'uebal li katoj re li acuabej. Ut naxye nak a'an li Cristo laj Colonel li yechi'inbil xban li Dios. Naxye nak a'an rey, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Laj Pilato quixye re li Jesús: —¿Ma la̱at lix reyeb laj judío? Li Jesús quichak'oc ut quixye: —Ya̱l li xaye nak la̱in, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ut laj Pilato quixye reheb li xbe̱nil aj tij ut eb li q'uila tenamit: —Li cui̱nk a'in ma̱ jun xma̱c nintau, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Abanan eb a'an yalyo̱queb xk'e chixyebal: —Naxpo' xch'o̱leb li katenamit. Yo̱ chixc'utbal lix tijleb chiruheb sa' chixjunil Judea. Quixtiquib chak Galilea ut xc'ulun toj arin, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Nak laj Pilato quirabi nak que'xpatz' Galilea, quixpatz' reheb: —¿Ma Galilea xtenamit li cui̱nk a'in? chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","—Aj Galilea, chanqueb re. Nak laj Pilato quixnau nak li Jesús quichal chak sa' li na'ajej li cuan rubel xtakl laj Herodes, quixtakla riq'uin laj Herodes xban nak sa' eb li cutan a'an laj Herodes cuan aran Jerusalén. ");
INSERT INTO kekNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","C'ajo' nak quisaho' xch'o̱l laj Herodes nak quiril ru li Jesús xban nak ac junxil quiraj raj rilbal ru. Quirabi resil li c'a'ru yo̱ chixba̱nunquil li Jesús ut quiraj rilbal nak tixba̱nu junak milagro chiru. ");
INSERT INTO kekNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nabal li c'a'ak re ru quilajxpatz' re ut li Jesús chi ti̱c inc'a' quichak'oc. ");
INSERT INTO kekNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Cuanqueb aran eb li xbe̱nil aj tij ut eb laj tz'i̱b. C'ajo' lix josk'ileb nak yo̱queb chixjitbal. ");
INSERT INTO kekNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Laj Herodes ut eb li soldado que'xtz'ekta̱na ut que'xhob. Que'retz'u ut que'xq'ue li cha̱bil t'icr chirix jo' neque'rocsi li rey. Ut laj Herodes quixtakla cui'chic riq'uin laj Pilato. ");
INSERT INTO kekNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Junxil xic' que'ril ribeb laj Herodes ut laj Pilato. Abanan sa' eb li cutan a'an que'xc'am cui'chic rib sa' usilal. ");
INSERT INTO kekNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ut laj Pilato quixch'utubeb li xbe̱nil laj tij, ut eb li neque'taklan sa' li tenamit jo'queb ajcui' chixjunileb li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Quixye reheb: —La̱ex xec'am chak li cui̱nk a'in cuiq'uin ut xeye nak naxpo' xch'o̱leb li tenamit. La̱in xinpatz'i re che̱ru ut inc'a' xintau junak xma̱c jo' yo̱quex chixyebal la̱ex. ");
INSERT INTO kekNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Chi moco laj Herodes xtau junak xma̱c. Jo'can nak xtakla cui'chic chak arin cuiq'uin. Anakcuan la̱in ninnau nak ma̱ jun ma̱c xba̱nu xc'ulub cui' ca̱mc. ");
INSERT INTO kekNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Tintakla xq'uebal xlob, tojo'nak tincuach'ab, chan laj Pilato. ");
INSERT INTO kekNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Sa' li nink'e a'an c'aynakeb nak na-ach'aba̱c junak li pre̱x. ");
INSERT INTO kekNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ut chixjunileb li tenamit que'xye chi junajeb xya̱b xcuxeb: —¡Camsi a'an, ut ach'ab laj Barrabás! chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Laj Barrabás cuan sa' tz'alam xban li camsi̱nc quixba̱nu nak yo̱queb chi pletic li tenamit chirix li acuabej. ");
INSERT INTO kekNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Laj Pilato quiraj raj rach'abanquil li Jesús ut quixpatz' cui'chic reheb ma ta̱ru̱k ta̱rach'ab li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Abanan eb li tenamit que'xjap reheb chixyebal: —¡Q'ue chiru cruz! ¡Q'ue chiru cruz! chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ut laj Pilato quia̱tinac cui'chic rox sut riq'uineb ut quixye: —¿C'a'ru tz'akal xma̱c e̱re? Ma̱ jun xma̱c nintau la̱in re nak tintakla chi camsi̱c. La̱in tintakla xsac'bal ut tincuach'ab, chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Abanan eb a'an k'axal cau cui'chic que'xjap re chixyebal: —¡Q'ue chiru cruz!— Japjo̱queb re li tenamit jo' eb ajcui' laj tij toj retal quixba̱nu laj Pilato li c'a'ru que'raj. ");
INSERT INTO kekNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ut laj Pilato quixteneb ca̱mc sa' xbe̱n li Jesús jo' que'raj li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ut quirach'ab laj Barrabás li quiq'uehe' sa' tz'alam xban li pletic ut camsi̱nc quixba̱nu chirix jun li acuabej. Ut quixk'axtesi li Jesús sa' ruk'eb re te'xba̱nu li c'a'ru te'raj riq'uin. ");
INSERT INTO kekNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Eb li tenamit que'xc'am li Jesús ut nak yo̱queb chi xic que'xc'ul jun li cui̱nk aj Simón xc'aba' yo̱ chi cha̱lc sa' c'aleba̱l. Cirene lix tenamit. Ut que'xmin ru chixpakonquil li cruz re xtenk'anquil li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nabaleb li tenamit yo̱queb chi ta̱ke̱nc re. Ut cuanqueb ajcui' ixk k'axal ra sa' xch'o̱leb. Yo̱queb chi ya̱bac xban li c'a'ru yo̱ chixc'ulbal li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ut li Jesús quixsuk'isi rib ut quirileb li ixk. Quixye reheb: —Ex ixk aj Jerusalén, mexya̱bac chicuix la̱in. Chexya̱bak ban che̱rix la̱ex ut chirixeb ajcui' le̱ ralal e̱c'ajol. ");
INSERT INTO kekNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ta̱cuulak xk'ehil nak eb li tenamit a'in te'xye, “Us xak reheb li ixk li inc'a' neque'q'uiresin ut li inc'a' neque'tu'resin.” ");
INSERT INTO kekNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ut te'xye ajcui' reheb li tzu̱l, “T'anekex chak sa' kabe̱n ut choe̱muk taxak”, cha'keb. ");
INSERT INTO kekNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Cui jo'ca'in te'xba̱nu cuiq'uin la̱in li chanchanin jun to̱n chi che' rax rax ru, ¿c'a'ru inc'a' te'xba̱nu e̱re la̱ex li chanchanex chaki che'? chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Que'xc'am ajcui' rochben li Jesús cuibeb li cui̱nk li cuanqueb xma̱c re te'camsi̱k rochben li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ut que'cuulac sa' li na'ajej Gólgota xc'aba'. Chi jalbil ru naraj naxye: Xna'aj Xbakel Xjolom Camenak. Ut aran que'xq'ue chiru cruz li Jesús. Ut que'xq'ue ajcui' chiru cruz li cuib chi cui̱nk li cuanqueb xma̱c. Jun li cruz que'xq'ue sa' xnim uk' li Jesús ut li jun chic que'xq'ue sa' xtz'e. ");
INSERT INTO kekNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ut li Jesús quitijoc ut quixye: —At inYucua', cuy taxak xma̱queb li tenamit a'in xban nak inc'a' neque'xnau c'a'ru yo̱queb chixba̱nunquil, chan. Ut eb li soldado que'bu̱lic chirix li rak' re rilbal ani na ta̱e̱chani̱nk re. ");
INSERT INTO kekNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Eb li tenamit xakxo̱queb aran chi iloc. Ut eb li neque'taklan sa' xbe̱neb li tenamit yo̱queb chixhobbal li Jesús ut que'xye: —Jalan chic quixcoleb. Cui ya̱l nak a'an li Cristo, li sic'bil ru xban li Dios, chixcolak rib xjunes, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ut eb li soldado yo̱queb ajcui' chixhobbal. Que'jiloc chixc'atk ut que'xyechi'i vinagre re. ");
INSERT INTO kekNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ut que'xye re: —Cui ya̱l nak la̱at lix reyeb laj judío, col a̱cuib a̱junes, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Chiru li cruz que'xq'ue jun retalil tz'i̱banbil sa' eb li a̱tinoba̱l griego, hebreo, ut latín, li naxye chi jo'ca'in: A'an a'in lix reyeb laj judío. ");
INSERT INTO kekNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jun reheb laj ma̱c li que'q'uehe' chiru cruz rochben, quixhob ajcui' li Jesús ut quixye: —Cui la̱at li Cristo, col a̱cuib la̱at, ut choa̱col ajcui' la̱o, chan re. ");
INSERT INTO kekNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Abanan li jun chic quichak'oc ut quixk'us ut quixye re: —Chi moco la̱at nacaxucua ru li Dios, usta juntak'e̱t li raylal li yo̱co chixc'ulbal kochben a'an. ");
INSERT INTO kekNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Relic chi ya̱l nak la̱o kac'ulub xc'ulbal li raylal a'in xban nak la̱o cuan kama̱c. Abanan li cui̱nk a'in ma̱c'a' junak ma̱c xba̱nu, chan re. ");
INSERT INTO kekNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ut li cui̱nk a'an quixye ajcui' re li Jesús: —At Ka̱cua', chinjulticok' taxak a̱cue nak tat-oc sa' la̱ nimajcual cuanquilal, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ut li Jesús quixye re: —Relic chi ya̱l tinye a̱cue nak ho̱n ajcui' cua̱nkat cuiq'uin sa' li paraíso, chan re. ");
INSERT INTO kekNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Tuktu cua'leb quik'ojyi̱no' sa' chixjunil li ruchich'och' ut toj sa' oxib o̱r re ecuu quicutano' cui'chic. ");
INSERT INTO kekNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Nak quik'ojyi̱no' ru li sak'e, lix t'icrul li templo quik'iche' sa' xyi. ");
INSERT INTO kekNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Quia̱tinac li Jesús chi cau xya̱b xcux ut quixye: —At inYucua', sa' a̱cuuk' tink'axtesi lin musik', chan. Nak quixye a'an, qui-el xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Li capitán aj Roma quixq'ue retal li quic'ulman. Quixlok'oni li Dios ut quixye: —Relic chi ya̱l nak li cui̱nk a'in ti̱c xch'o̱l, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Chixjunileb li q'uila tenamit li cuanqueb aran chi iloc, que'xq'ue retal li c'a'ru quic'ulman. Que'suk'i sa' rochocheb ut yo̱queb chixtenbal li re xch'o̱l chi ruk'eb nak yo̱queb chi xic xban xrahil xch'o̱leb. ");
INSERT INTO kekNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ut chixjunileb li neque'na'oc ru li Jesús, jo' eb ajcui' li ixk li que'ta̱ken chak re toj Galilea xakxo̱queb chak chi najt ut yo̱queb chirilbal chixjunil li c'a'ak re ru a'in. ");
INSERT INTO kekNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Quicuan jun li cui̱nk aj José xc'aba'. Arimatea xtenamit li cuan sa' xcue̱nt Judea. Laj José, a'an jun xcomoneb li neque'taklan sa' xbe̱neb laj judío. Ti̱c xch'o̱l ut cha̱bil. ");
INSERT INTO kekNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Inc'a' quixc'ul xch'o̱l li c'a'ru que'xc'u̱b ru xba̱nunquil re li Jesús, chi moco quixc'ul xch'o̱l nak que'xcamsi xban nak a'an yo̱ chixyo'oninquil lix nimajcual cuanquilal li Dios. ");
INSERT INTO kekNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Co̱ riq'uin laj Pilato ut quixtz'a̱ma chiru nak tixq'ue re lix tz'ejcual li Jesús re tixmuk. ");
INSERT INTO kekNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Jo'can nak quixcubsi chak li camenak chiru cruz, quixlan sa' li cha̱bil t'icr lino ut quixq'ue sa' jun mukleba̱l yi̱banbil sa' jun sako̱nac. Toj ma̱ jun mukbil aran. ");
INSERT INTO kekNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Chixjunil a'in quic'ulman sa' li cutan nak neque'xcauresi li c'a'ru reheb re li hiloba̱l cutan xban nak ac cuulac re xcutanquil. ");
INSERT INTO kekNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Eb li ixk, li que'ta̱ken chak re li Jesús toj Galilea, que'xta̱ke laj José ut que'ril li mukleba̱l li quimuke' cui' li camenak ut que'ril ajcui' chanru nak quiq'uehe' sa' li jul. ");
INSERT INTO kekNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Que'suk'i sa' rochocheb ut que'xcauresi li sununquil ban re xbanbal li camenak, ut que'hilan sa' li hiloba̱l cutan jo' naxye sa' lix chak'rabeb. ");
INSERT INTO kekNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sa' li xbe̱n li cutan re li xama̱n, toj ek'ela chi us, co̱eb li ixk cuan cui' li mukleba̱l. Que'xc'am li sununquil ban li que'xyi̱b. Ut cuanqueb jalaneb chic ixk rochbeneb. ");
INSERT INTO kekNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nak que'cuulac, que'ril nak ac isinbil chic li nimla pec li natz'apoc re li mukleba̱l. ");
INSERT INTO kekNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ut nak que'oc chi sa' li mukleba̱l, inc'a' que'xtau li camenak. ");
INSERT INTO kekNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Que'sach xch'o̱leb ut inc'a' que'xnau c'a'ru te'xba̱nu. Ut xaka̱mil chiruheb cuib li cui̱nk. Nalemtz'un li rak'eb. ");
INSERT INTO kekNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","C'ajo' nak que'xucuac li ixk. Que'xxulub li riloba̱l. Ut eb li cui̱nk que'xye reheb: —¿C'a'ut nak nequesic' li yo'yo sa' xya̱nkeb li camenak? ");
INSERT INTO kekNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","A'an ma̱ ani chic arin. Ac xcuacli cui'chic chi yo'yo. Chijulticok' e̱re li c'a'ru quixye chak nak toj cua̱nk chak Galilea. ");
INSERT INTO kekNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Quixye nak tento ta̱k'axtesi̱k li C'ajolbej sa' ruk'eb li cui̱nk aj ma̱c. Ta̱q'uehek' chiru cruz ut ta̱camsi̱k. Ut quixye ajcui' nak ta̱cuacli̱k cui'chic chi yo'yo sa' xya̱nkeb li camenak sa' rox li cutan, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Riq'uin a'an quinak sa' xch'o̱leb li ixk li c'a'ru quixye li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Que'el sa' li mukleba̱l ut co̱eb. Cole'xye resil chixjunil li c'a'ak re ru a'in reheb li junlaju ut reheb ajcui' li jun ch'ol chic. ");
INSERT INTO kekNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Eb li ixk li que'yehoc re li esilal a'in reheb li apóstol, a'an eb lix María Magdala xtenamit, lix Juana ut lix María lix na' laj Jacobo rochbeneb li jun ch'ol chic li ixk. ");
INSERT INTO kekNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Abanan eb li junlaju chi apóstol inc'a' que'xpa̱b li c'a'ru que'xye li ixk. Sa' xch'o̱leb a'an nak moco ya̱l ta li yo̱queb chixyebal. ");
INSERT INTO kekNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Abanan laj Pedro co̱ sa' a̱nil sa' li mukleba̱l. Qui-iloc chi sa' ut quiril nak ca'aj chic li t'icr lino cuan aran. Jo'can nak sachso xch'o̱l chi c'oxlac nak quisuk'i sa' rochoch. ");
INSERT INTO kekNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Sa' ajcui' li cutan a'an, cuibeb lix tzolom li Jesús yo̱queb chi xic sa' li ch'ina tenamit Emaús. Li tenamit a'an junlaju kilómetro na xnajtil riq'uin Jerusalén. ");
INSERT INTO kekNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Yo̱queb chi a̱tinac chi rilbileb rib chirix chixjunil li c'a'ak re ru quic'ulman sa' eb li cutan a'an. ");
INSERT INTO kekNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nak yo̱queb chi a̱tinac ut chixtz'ilbal rix chi ribileb rib li c'a'ru quic'ulman, li Jesús quijiloc riq'uineb ut qui-oc chi be̱c rochbeneb. ");
INSERT INTO kekNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Usta que'ril ru, abanan inc'a' que'xnau nak a'an li Jesús xban nak cuan c'a'ru quiramoc re chiruheb. ");
INSERT INTO kekNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ut li Jesús quixye reheb: —¿C'a'ru chi aj ix yo̱quex chi serak'ic chi ribil e̱rib nak yo̱quex chi be̱c? ¿C'a'ut nak ra sa' e̱ch'o̱l? chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jun reheb a'an, aj Cleofas xc'aba', quichak'oc ut quixye: —Jo' li ca'aj cui' la̱at li yo̱cat chi numec' sa' li tenamit Jerusalén li inc'a' nacatna'oc re li c'a'ru xc'ulman sa' eb li cutan a'in, chan. ");
INSERT INTO kekNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ut li Jesús quixye reheb: —¿C'a'ru anchal a'an? chan. Eb a'an que'xye re: —Chirix li Jesús aj Nazaret. A'an profeta nak quicuan. Nim xcuanquil. Cha̱bil quixba̱nu ut cha̱bil quixye chiru li Dios ut chiruheb li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Eb li xbe̱nil aj tij ut eb li neque'taklan sa' kabe̱n que'xk'axtesi chi camsi̱c ut que'xq'ue chiru cruz. ");
INSERT INTO kekNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","A'an raj li ta̱colok re li katenamit Israel sa' kach'o̱l. Abanan anakcuan ac oxib cutan xc'ulbal a'an. ");
INSERT INTO kekNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Xsach kach'o̱l chirabinquil li c'a'ru xe'xye ke li ixk li xe'cuulac sa' li mukleba̱l toj ek'ela. ");
INSERT INTO kekNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Xban nak inc'a' xe'xtau li camenak, xe'suk'i sa' cab ut xe'xye ke nak cuib li ángel xe'xc'utbesi rib chiruheb ut xe'xye reheb nak yo'yo li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ut cuanqueb ajcui' kacomon xe'cuulac chak sa' li mukleba̱l ut xe'ril nak ya̱l li xe'xye li ixk. Abanan inc'a' xe'ril ru li Jesús, chan laj Cleofas. ");
INSERT INTO kekNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ut li Jesús quixye reheb: —¡La̱ex ma̱c'a' e̱na'leb ut a̱l le̱ ch'o̱l chixpa̱banquil chixjunil li c'a'ru que'xye chak li profeta! ");
INSERT INTO kekNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Ma inc'a' ta bi' tento nak tixc'ul chixjunil li raylal a'in li Cristo laj Colonel li yechi'inbil xban li Dios re nak ta̱q'uehek' xlok'al? chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ut quixch'olob xya̱lal chiruheb chirix li c'a'ru quixtz'i̱ba laj Moisés. Quixch'olob ajcui' li xya̱lal li que'xtz'i̱ba chak li profeta chirix li Cristo li yechi'inbil xban li Dios jo' tz'i̱banbil sa' li Santil Hu. ");
INSERT INTO kekNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Que'cuulac sa' li ch'ina tenamit li yo̱queb cui' chi xic. Ut li Jesús quixba̱nu rib nak ti̱c ta̱xic. ");
INSERT INTO kekNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Abanan eb a'an que'relaji ru re ta̱cana̱k riq'uineb. Que'xye re: —Cana̱kat kiq'uin xban nak yo̱ chi ecuu̱c. Oc re li k'ojyi̱n, chanqueb re. Ut li Jesús qui-oc sa' cab ut quicana riq'uineb. ");
INSERT INTO kekNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nak c'ojc'o sa' me̱x rochbeneb, quixchap li caxlan cua, quixbantioxi chiru li Dios, quixjachi ut quixq'ue reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Sa' li ho̱nal a'an que'xq'ue retal nak a'an li Jesús. Ut nak ac xe'xnau nak a'an, nak que'ril ac ma̱ ani chic sa' xya̱nkeb. ");
INSERT INTO kekNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ut eb a'an que'xye chi ribileb rib: —Jo'can pe' nak yo̱co chak rec'anquil jun sahil ch'o̱lej sa' ka̱m nak yo̱ chak chika̱tinanquil sa' be ut nak yo̱ chixch'olobanquil chiku li naxye sa' li Santil Hu, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Sa' ajcui' li ho̱nal a'an que'suk'i Jerusalén. Aran que'xtau li junlaju chi apóstol ch'utch'u̱queb rochbeneb lix comon. ");
INSERT INTO kekNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Yo̱queb chixyebal: —Relic chi ya̱l nak xcuacli cui'chic chi yo'yo li Ka̱cua' xban nak xc'utbesi rib chiru laj Simón, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tojo'nak li cuib chi cui̱nk que'xserak'i reheb li c'a'ru quic'ulman sa' be nak yo̱queb chi xic Emaús. Que'xye reheb chanru nak que'xnau ru li Jesús nak quixjachi li caxlan cua. ");
INSERT INTO kekNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Toj yo̱queb ajcui' xserak'inquil li c'a'ru que'xc'ul nak ac xaka̱mil li Jesús sa' xya̱nkeb ut quixye reheb: —¡Chicua̱nk taxak li tuktu̱quil usilal e̱riq'uin! chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ut eb a'an sachso̱queb xch'o̱l que'cana ut te'xucuak. Sa' xch'o̱leb a'an nak ma̱re junak musik'ej yo̱queb chirilbal. ");
INSERT INTO kekNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ut li Jesús quixye reheb: —¿C'a'ut nak nequexxucuac? Ut, ¿c'a'ut nak na-oc e̱c'a'ux? ");
INSERT INTO kekNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","La̱in li Jesús. Ilomak li cuok ut li cuuk'. Ch'e'omakin re nak te̱q'ue retal nak la̱in tz'akal. Junak musik'ej, a'an ma̱c'a' xbakel, chi moco cuan xtibel. Ilomak. La̱in cuan inbakel ut cuan intibel, chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ut nak yo̱ chixyebal a'in, quixc'ut li rok ut li ruk' chiruheb. ");
INSERT INTO kekNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","C'ajo' nak quisaho' sa' xch'o̱leb. Abanan toj sachso̱queb xch'o̱l. Inc'a' que'xnau ma ya̱l li yo̱queb chirilbal malaj ut inc'a'. Ut li Jesús quixye reheb: —¿Ma cuan ca'ch'inak tzacae̱mk e̱riq'uin? chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ut que'xq'ue re jun jachal li pombil car ut ca'ch'in li xya'al cab. ");
INSERT INTO kekNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Li Jesús quixc'ul ut quixtzaca. ");
INSERT INTO kekNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ut quixye reheb: —Li c'a'ru xinc'ul, a'an ajcui' li quinserak'i chak e̱re nak toj cuanquin chak sa' e̱ya̱nk. Tento nak ta̱tz'aklok ru chixjunil li tz'i̱banbil chak retalil chicuix sa' lix chak'rab laj Moisés, jo' ajcui' sa' lix hu eb li profeta ut sa' ajcui' li Salmos, chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ut quixq'ueheb xna'leb re nak te'xtau ru li tz'i̱banbil sa' li Santil Hu. ");
INSERT INTO kekNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Quixye reheb: —Jo'ca'in tz'i̱banbil chak retalil sa' li Santil Hu chicuix la̱in: tento nak li Cristo tixc'ul li raylal ut sa' rox li cutan ta̱cuacli̱k cui'chic chi yo'yo sa' xya̱nkeb li camenak. ");
INSERT INTO kekNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Tz'i̱banbil ajcui' retalil nak ta̱julticama̱nk chiruheb chixjunileb li tenamit nak tento te'xyot' xch'o̱leb ut te'xjal xc'a'uxeb re ta̱cuyma̱nk ta̱sachma̱nk lix ma̱queb sa' xc'aba' a'an. Ta̱ticla̱k xch'olobanquil arin Jerusalén. ");
INSERT INTO kekNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","La̱ex texyehok resil xban nak la̱ex xex-abin re ut la̱ex xex-iloc re chixjunil li c'a'ak re ru a'in. ");
INSERT INTO kekNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ut la̱in tintakla chak e̱re le̱ ma̱tan li quixyechi'i lin Yucua'. Abanan cana̱kex arin sa' li tenamit Jerusalén toj te̱c'ul le̱ cuanquil li ta̱cha̱lk sa' choxa, chan li Jesús reheb. ");
INSERT INTO kekNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ut li Jesús quixc'ameb toj sa' li tenamit Betania. Quixtaksi li ruk' ut quirosobtesiheb. ");
INSERT INTO kekNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nak yo̱ chirosobtesinquileb, quirisi rib sa' xya̱nkeb ut quic'ame' takec' sa' choxa. ");
INSERT INTO kekNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nak ac xe'xlok'oni li Ka̱cua', eb a'an que'suk'i cui'chic Jerusalén chi c'ajo' xsahil sa' xch'o̱leb. ");
INSERT INTO kekNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ut junelic cuanqueb sa' li templo. Yo̱queb chi bantioxi̱nc ut yo̱queb chixlok'oninquil li Dios. Jo'can taxak.");
INSERT INTO kekNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Chalen chak sa' xticlajic li ruchich'och' ac cuan chak li A̱tin. Li A̱tin cuan chak riq'uin li Dios ut a'an tz'akal Dios. Li A̱tin, a'an li Cristo. ");
INSERT INTO kekNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Li Cristo ac cuan chak sa' xticlajic riq'uin li Dios. ");
INSERT INTO kekNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Chixjunil li c'a'ru cuan, li Dios quixyi̱b sa' xc'aba' li Cristo. Ut ma̱c'a' c'a'ak re ru cuan chi ma̱cua' a'an ta li quiyi̱ban re. ");
INSERT INTO kekNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Li Cristo, a'an li naq'uehoc junelic yu'am. Ut li yu'am li naxq'ue naxcutanobresi lix c'a'uxeb li cristian. ");
INSERT INTO kekNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Li Cristo naxcutanobresi lix c'a'uxeb li toj cuanqueb sa' xk'ojyi̱nal ru li ma̱c. Li ma̱c inc'a' quinumta sa' xbe̱n li Cristo. ");
INSERT INTO kekNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Quicuan jun li cui̱nk aj Juan xc'aba' taklanbil chak xban li Dios. ");
INSERT INTO kekNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Quitakla̱c chak chixch'olobanquil xya̱lal nak li Jesús, a'an li cutan saken re nak chixjunileb li ani te'abi̱nk re, te'pa̱ba̱nk. ");
INSERT INTO kekNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Li Cristo, a'an li tz'akal cutan saken. Ma̱cua' laj Juan. Laj Juan quic'ulun chixch'olobanquil xya̱lal ani li tz'akal cutan saken. ");
INSERT INTO kekNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","A'an li tz'akal cutan saken li quic'ulun sa' ruchich'och' chixcutanobresinquil xc'a'uxeb chixjunileb li cristian. ");
INSERT INTO kekNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Li Cristo quicuan sa' ruchich'och'. Abanan li cuanqueb sa' ruchich'och' inc'a' que'xq'ue retal chi tz'akal nak a'an li Cristo usta sa' xc'aba' a'an quiyi̱ba̱c li ruchich'och'. ");
INSERT INTO kekNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Quic'ulun sa' lix tenamit. Abanan inc'a' quic'ule' sa' xya̱lal xbaneb. ");
INSERT INTO kekNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Abanan chixjunileb li que'c'uluc re ut que'pa̱ban re nak a'an taklanbil chak xban li Dios, a'aneb li quixc'uleb chok' ralal xc'ajol li Dios. ");
INSERT INTO kekNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Que'oc chok' ralal xc'ajol li Dios xban nak jo'can quiraj li Dios. Moco yal xc'a'ux cui̱nk ta. Moco jo' ta nak nayo'la junak cristian arin sa' ruchich'och'. Yo'lajenakeb ban chic sa' musik'ej ut ralal xc'ajoleb chic li Dios. ");
INSERT INTO kekNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Li Jesucristo quitz'ejcualo' ut tz'akal cui̱nk nak quicuan arin sa' kaya̱nk. C'ajo' li rusilal ut a'an naxc'ut li xya̱lal. A'an li Ralal li Dios li junaj chi ribil ut la̱o xkil lix lok'al. ");
INSERT INTO kekNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Laj Juan laj Cubsihom Ha' quixch'olob xya̱lal chi cau xya̱b xcux ut quixye: —A'an a'in li quinch'olob chak xya̱lal che̱ru nak quinye e̱re: Mokon ta̱cha̱lk jun k'axal nim xcuanquil chicuu la̱in xban nak a'an ac cuan ajcui' chak junxil chicuu la̱in, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Xban xnimal rusilal, k'axal numtajenak li kosobtesinquil naxq'ue. ");
INSERT INTO kekNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Li Dios quixq'ue li chak'rab re laj Moisés re nak tixc'ut chiku. Aban li xya̱lal chirix li Dios ut li rusilal quixc'utbesi chiku li Jesucristo. ");
INSERT INTO kekNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ma̱ ani qui-iloc ru li Dios. Ca'aj cui' li Dios C'ajolbej, a'an tz'akal li cuan chi sum a̱tin riq'uin li Dios Acuabej. Ut a'an li quic'utbesin chiku chanru li Dios. ");
INSERT INTO kekNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Eb laj judío li cuanqueb Jerusalén que'xtaklaheb laj tij ut eb laj levita chixpatz'bal re laj Juan, ut que'xye re: —¿Anihat la̱at? ¿Ma la̱at li Cristo li taklanbil chak xban li Dios? chanqueb re. ");
INSERT INTO kekNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Quichak'oc laj Juan ut quixye reheb: —La̱in ma̱cua'in li Cristo, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ut que'xye cui'chic re: —Ye ke anihat la̱at. ¿Ma la̱at laj Elías?— Quichak'oc laj Juan ut quixye: —Moco la̱in ta, chan. —¿Ma la̱at li profeta li ta̱cha̱lk? chanqueb cui'chic re. —Inc'a', chan laj Juan. ");
INSERT INTO kekNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","—Ye ke chi tz'akal anihat re nak ta̱ru̱k takaye reheb li xe'taklan chak ke. Tento nak ta̱ye ke anihat, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Quixye laj Juan: —La̱in li yo̱quin chixch'olobanquil li xya̱lal chiruheb li cristian chi cau xya̱b incux sa' li chaki ch'och' ut ninye resil li quixye li profeta Isaías: Yi̱bomak le̱ yu'am ut yo'on cua̱nkex chixc'ulbal li Ka̱cua' jo' nak neque'xyi̱b li be re xc'ulbal junak li nim xcuanquil. (Is. 40:3) ");
INSERT INTO kekNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Li que'takla̱c chi a̱tinac riq'uin laj Juan, a'an xcomoneb laj fariseo. ");
INSERT INTO kekNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Que'xye cui'chic re laj Juan: —¿C'a'ut nak nacatcubsin ha' cui ma̱cua' la̱at li Cristo, chi moco la̱at laj Elías, chi moco la̱at li profeta? chanqueb re laj Juan. ");
INSERT INTO kekNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Quichak'oc cui'chic laj Juan ut quixye: —La̱in nincubsin ha' riq'uin ha'. Abanan cuan jun sa' e̱ya̱nk la̱ex inc'a' nequenau chi tz'akal ani a'an. ");
INSERT INTO kekNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","A'an li ta̱oc chi c'anjelac mokon. K'axal nim xcuanquil a'an chicuu la̱in. Moco inc'ulub ta xba̱nunquil lix c'anjel a'an xban nak cubenak incuanquil. Jo'can nak moco inc'ulub ta xhitbal xc'a̱mal lix xa̱b, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Chixjunil a c'a'ak re ru a'in quic'ulman sa' li na'ajej Betania li cuan jun pac'al li nima' Jordán, li yo̱ cui' chi cubsi̱nc ha' laj Juan. ");
INSERT INTO kekNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Jo' cuulajak chic laj Juan quiril li Jesús yo̱ chak chi cha̱lc riq'uin ut quixye: —Ilomak. Cue' chak li Cristo, li taklanbil chak xban li Dios. Chanchan jun li carner. Ta̱camsi̱k re xtojbal rix lix ma̱queb li cuanqueb sa' ruchich'och'. ");
INSERT INTO kekNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","A'an a'in li quina̱tinac chak chirix nak quinye e̱re nak ta̱cha̱lk jun cui̱nk k'axal nim xcuanquil chicuu la̱in xban nak a'an ac cuan ajcui' chak junxil chicuu la̱in. ");
INSERT INTO kekNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","La̱in inc'a' ninnau nak a'an li Cristo. Abanan yo̱quin chi cubsi̱nc ha' re nak li Dios tixc'utbesi chiku la̱o aj Israel ani tz'akal li Cristo, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Laj Juan quixch'olob xya̱lal li c'a'ru quiril. Quixye: —Quicuil nak li Santil Musik'ej quicube chak sa' choxa. Chanchan jun li paloma nak quicube ut quihilan sa' xbe̱n li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Inc'a' raj xinnau nak a'an li Cristo cui ta inc'a' quicuil li quic'ulman. Xinnau nak a'an li Cristo xban nak li Dios li quitaklan chak cue chi cubsi̱nc ha' quixye cue, “Nak ta̱cuil li Santil Musik'ej chanchan jun li paloma yo̱k chi cubec ut ta̱hila̱nk sa' xbe̱n jun li cui̱nk, a'an retalil nak a'an li ta̱q'uehok e̱re li Santil Musik'ej”, chan li Dios. ");
INSERT INTO kekNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ut la̱in quicuil nak quicube chak li Santil Musik'ej sa' xbe̱n li Jesús. Jo'can nak ninnau chi tz'akal nak a'an tz'akal Ralal li Dios, chan laj Juan. ");
INSERT INTO kekNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Jo' cuulajak chic laj Juan cuan cui'chic chire li nima' Jordán rochben cuibeb lix tzolom. ");
INSERT INTO kekNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nak quiril li Jesús yo̱ chi numec' nach' cuanqueb cui', laj Juan quixye: —Cue' chak li Cristo, li chanchan Carner q'uebil chak xban li Dios, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ut eb lix tzolom cuib, nak que'rabi li quixye laj Juan, que'xta̱ke li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Li Jesús quixakli ut quixsuk'isi rib. Quiril nak yo̱queb chi xic chirix. Quixye reheb: —¿C'a'ut nak yo̱quex chinta̱kenquil? ¿C'a'ru te̱raj? chan reheb. Que'chak'oc eb a'an ut que'xye: —At tzolonel ¿bar nacathilan? chanqueb re. ");
INSERT INTO kekNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Quichak'oc li Jesús ut quixye reheb: —Yo'keb chicuix re nak te̱nau bar ninhilan, chan li Jesús reheb. Jo'can nak que'co̱eb chirix ut que'ril bar nahilan. Ut que'cana riq'uin xban nak ac ca̱hib o̱r chic re ecuu. ");
INSERT INTO kekNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Laj Andrés li ri̱tz'in laj Simón Pedro, a'an jun reheb li cuib li que'abin re li c'a'ru quixye laj Juan ut que'xta̱ke li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Nak ac x-a̱tinac riq'uin li Jesús, ticto co̱ laj Andrés riq'uin laj Simón ut quixye re: —Anakcuan xkatau li Mesías, chan. (Chi jalbil ru naraj naxye “li Cristo li taklanbil chak xban li Dios”.) ");
INSERT INTO kekNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ut quixc'am laj Simón riq'uin li Jesús. Li Jesús quiril a'an ut quixye re: —La̱at laj Simón li ralal laj Jonás. Anakcuan Pedro chic a̱c'aba'.— (Chi jalbil ru naraj naxye “Pec”.) ");
INSERT INTO kekNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Jo' cuulajak chic li Jesús quiraj xic sa li na'ajej Galilea. Quixtau laj Felipe ut quixye re: —China̱ta̱ke, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Laj Felipe, a'an Betsaida xtenamit. A'an ajcui' xtenamiteb laj Andrés ut laj Pedro. ");
INSERT INTO kekNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Laj Felipe ticto co̱ chixsic'bal laj Natanael ut quixye re: —Xkatau li Mesías li tz'i̱banbil chak retalil sa' li chak'rab xban laj Moisés ut xbaneb li profeta. A'an li Jesús ralal laj José. Nazaret xtenamit, chan laj Felipe. ");
INSERT INTO kekNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Laj Natanael quixye re: —¿Ma cuan ta bi' junak cha̱bil ta̱cha̱lk chak Nazaret? chan. Ut laj Felipe quixye re: —Yo'o rilbal re nak ta̱pa̱b, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Li Jesús quiril nak laj Natanael yo̱ chak chi cha̱lc riq'uin ut quixye: —Cue' chak jun cui̱nk tz'akal aj Israel. Cha̱bil xna'leb. A'an inc'a' nabalak'ic, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Laj Natanael quixye re li Jesús: —¿Chanru nacanau nak cha̱bil inna'leb? chan. Li Jesús quichak'oc ut quixye re: —Xinnau chanru a̱na'leb nak cuancat rubel li jun to̱n chi higo nak toj ma̱ji' nacatxbok laj Felipe, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Quichak'oc laj Natanael ut quixye re: —At tzolonel, la̱at li Ralal li Dios. La̱at lix Reyeb laj Israel, chan re li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Li Jesús quixye re: —Xapa̱b nak la̱in li Cristo xban nak xinye a̱cue nak xinnau chanru la̱ na'leb nak cuancat rubel li jun to̱n chi higo. Abanan toj cuan cui'chic xni̱nkal ru na'leb talaja̱cuil chiru a'in, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ut quixye ajcui' reheb: —Relic chi ya̱l tinye e̱re nak te̱ril li choxa chi teto. Ut eb lix ángel li Dios yo̱keb chi takec' ut yo̱keb chi cubec cuanquin cui' la̱in li C'ajolbej, chan li Jesús reheb. ");
INSERT INTO kekNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Yo̱ chic rox cutan xc'ulbal a c'a'ak re ru a'in nak quicuan jun li sumla̱c sa' li tenamit Caná re Galilea. Cuan lix na' li Jesús aran. ");
INSERT INTO kekNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ut quiboke' sa' li sumla̱c li Jesús rochbeneb lix tzolom. ");
INSERT INTO kekNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nak ac yo̱ li nink'e, qui-oso' li vino. Ut lix na' li Jesús quixye re: —Ma̱c'a' chic li vino, chan re. ");
INSERT INTO kekNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ut li Jesús quixye re: —¿C'a'ut nak nacatchal xyebal cue a'an? Toj ma̱ji' xk'ehil nak tinc'utbesi lin cuanquil, chan re lix na'. ");
INSERT INTO kekNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Lix na' li Jesús quixye reheb li yo̱queb chi c'anjelac: —Cheba̱nuhak li c'a'ru tixye e̱re, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ut aran cuanqueb cuakib li ni̱nki cuc yi̱banbil riq'uin pec. A'an nac'anjelac chok' xna'aj xha'eb laj judío re xch'ajobresinquil ribeb jo' naxye sa' lix chak'rabeb. Li junju̱nk chi cuc a'an naxc'am oxib ni̱nki cuc chi ha'. ");
INSERT INTO kekNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Li Jesús quixye reheb li yo̱queb chi c'anjelac aran nak te'xnujtesi li ni̱nki cuc riq'uin ha'. Ut eb a'an que'xq'ue li ha' sa' li cuc toj retal que'nujac. ");
INSERT INTO kekNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Quixye cui'chic li Jesús reheb: —Lecomak ca'ch'inak ut te̱c'am riq'uin li najolomin re li nink'e, chan. Ut eb a'an que'xba̱nu jo' quiyehe' reheb xban li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Li ha' ac suk'isinbil chok' vino xban li Jesús nak que'xc'am riq'uin li najolomin re li nink'e. A'an inc'a' quixnau bar ta xchal li vino. Ca'aj cui' eb laj c'anjel li que'lecoc chak re que'xnau. Li najolomin re li nink'e quixyal li vino. Tojo'nak quixbok li be̱lomej ut quixye re: ");
INSERT INTO kekNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","—Chixjunileb li neque'nink'ei̱c xbe̱n cua neque'xjec' li cha̱bil vino. Ut nak ac xe'uc'ac chi nabal li ula', neque'xjec' li inc'a' mas cha̱bil. Abanan la̱at xac'u̱la li cha̱bil vino ut toj anakcuan xacuisi chak, chan re. ");
INSERT INTO kekNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","A'an a'in li xbe̱n milagro li quixba̱nu li Jesús nak quixsuk'isi li ha' chok' vino aran Caná re Galilea. Riq'uin li milagro a'in quixc'utbesi nak cuan xcuanquil ut eb lix tzolom que'xpa̱b nak li Jesús a'an li Ralal li Dios. ");
INSERT INTO kekNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Chirix chic a'an co̱ Capernaum li Jesús rochben lix na' ut eb li ri̱tz'in. Que'co̱eb ajcui' lix tzolom ut que'cana aran cuib oxib cutan. ");
INSERT INTO kekNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nak ac yo̱ chi cuulac xk'ehil li Pascua, lix nink'e eb laj judío, li Jesús quicuulac Jerusalén. ");
INSERT INTO kekNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Quicuulac sa' li templo ut aran quixtauheb li yo̱queb chi c'ayi̱nc bo̱yx, carner ut paloma. Chunchu̱queb ajcui' aran laj jalol ru tumin. ");
INSERT INTO kekNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Li Jesús quixyi̱b jun lix tz'u̱m riq'uin c'am ut quixyolesiheb. Quirisiheb chixjunileb chirix cab rochbeneb lix xul. Quixpaji lix tumin eb laj jalol ru tumin ut quixbalk'usi lix me̱xeb. ");
INSERT INTO kekNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Quixye reheb li yo̱queb chi c'ayi̱nc paloma: —Isihomak chixjunil a'in sa' li templo. Me̱suk'isi chok' c'ayil li rochoch lin Yucua', chan li Jesús reheb. ");
INSERT INTO kekNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Tojo'nak quinak sa' xch'o̱leb lix tzolom nak tz'i̱banbil retalil sa' li Santil Hu li naxye chi jo'ca'in: La̱in ninra la̱ cuochoch ut naraho' sa' inch'o̱l nak neque'xba̱nu li inc'a' us sa' la̱ cuochoch. (Sal. 69:9) ");
INSERT INTO kekNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ut eb laj judío que'xye re li Jesús: —¿C'a'ru retalil ta̱c'ut chiku re nak takanau nak cuan a̱cuanquil chirisinquileb sa' li templo? chanqueb re. ");
INSERT INTO kekNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Quichak'oc li Jesús ut quixye reheb: —Juc'umak li templo a'in ut chiru oxib cutan tincuaclesi cui'chic chi ac', chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Eb laj judío que'chak'oc ut que'xye re li Jesús: —Chiru cuakib roxc'a̱l (46) chihab que'cablac re xyi̱banquil li templo a'in. ¿Ma nacac'oxla la̱at nak yal chiru oxib cutan ta̱cuaclesi cui'chic? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Abanan li Jesús inc'a' yo̱ chi a̱tinac chirix li templo. Yo̱ ban chi a̱tinac chirix lix camic ut lix cuaclijic cui'chic chi yo'yo. ");
INSERT INTO kekNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jo'can nak ac xcuacli cui'chic chi yo'yo sa' xya̱nkeb li camenak, que'nak sa' xch'o̱leb lix tzolom li c'a'ru quixye li Jesús nak toj ma̱ji' nacam. Ut que'xpa̱b li c'a'ru tz'i̱banbil chak najter sa' li Santil Hu ut que'xpa̱b ajcui' li c'a'ru quiyehe' reheb xban li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nak li Jesús cuan aran Jerusalén chixnumsinquil li nink'e Pascua, nabaleb que'pa̱ban re xban nak que'ril li milagro li quilajxba̱nu. ");
INSERT INTO kekNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Abanan li Jesús inc'a' quixc'ojob xch'o̱l riq'uineb xban nak naxnau chanru lix c'a'uxeb. ");
INSERT INTO kekNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Inc'a' tento nak ta̱ch'oloba̱k chiru chanru lix c'a'uxeb xban nak ac naxnau chanru lix na'leb li junju̱nk. ");
INSERT INTO kekNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Quicuan jun li cui̱nk aj fariseo aj Nicodemo xc'aba'. A'an xcomoneb li neque'taklan sa' xya̱nkeb laj judío. ");
INSERT INTO kekNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Sa' jun li k'ojyi̱n laj Nicodemo quicuulac chi a̱tinac riq'uin li Jesús ut quixye re: —At tzolonel, la̱o nakanau nak riq'uin li Dios chalenakat chak chok' aj tzolol ke xban nak ma̱ ani ta̱ru̱k tixba̱nu li milagros li nacaba̱nu la̱at cui ta ma̱cua' riq'uin xcuanquil li Dios, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Quichak'oc li Jesús ut quixye re: —Relic chi ya̱l ninye a̱cue, ma̱ ani naru ta̱oc rubel xnimajcual cuanquilal li Dios cui inc'a' ta̱yo'la̱k cui'chic xca' sut, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Laj Nicodemo quixye re: —¿Chan ta cui' ru nak ta̱yo'la̱k cui'chic xca' sut junak cui̱nk? ¿Ma ta̱ru̱k ta bi' ta̱oc cui'chic riq'uin lix na' ut ta̱yo'la̱k cui'chic xca' sut? chan. ");
INSERT INTO kekNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Quichak'oc li Jesús ut quixye re: —Relic chi ya̱l ninye a̱cue nak ani inc'a' ta̱yo'la̱k riq'uin ha' ut riq'uin li Santil Musik'ej moco ta̱ru̱k ta ta̱oc rubel lix nimajcual cuanquilal li Dios. ");
INSERT INTO kekNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Li ani yo'lajenak riq'uin lix na' xyucua' cuan xyu'am sa' ruchich'och'. Abanan li ani yo'lajenak riq'uin li Santil Musik'ej cuan xyu'am chi junelic. ");
INSERT INTO kekNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Misach a̱ch'o̱l xban nak xinye a̱cue nak tento tatyo'la̱k cui'chic xca' sut. ");
INSERT INTO kekNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Li ik' nanume' bar naraj chi inc'a' nacanau bar nachal chak chi moco nacanau bar yo̱ chi xic. Inc'a' nacacuil ru. Ca'aj cui' lix ya̱b nacacuabi nak nanume'. Jo'can ajcui' lix yu'ameb li yo'lajenakeb riq'uin li Santil Musik'ej. Cuan xyu'ameb chi junelic chi inc'a' nacanau chi tz'akal chanru, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Quichak'oc laj Nicodemo ut quixye re: —¿Chanru nak nac'ulman a'in? Inc'a' nintau ru, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Li Jesús quixye re: —La̱at aj tzolol reheb laj Israel ut inc'a' nacatau ru li yo̱quin chixyebal. ");
INSERT INTO kekNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Relic chi ya̱l ninye e̱re: La̱o nocoa̱tinac chirix li nakanau. Ut nakach'olob resil li c'a'ru nakil. Abanan la̱ex inc'a' nequec'u̱luban li c'a'ru nakach'olob xya̱lal che̱ru. ");
INSERT INTO kekNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","La̱at inc'a' nacapa̱b li c'a'ru ninye a̱cue chirix li c'a'ru nac'ulman sa' ruchich'och'. ¿Ma toja' ta chic ta̱pa̱b nak tinye a̱cue li choxahil na'leb? ");
INSERT INTO kekNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ma̱ ani quicuulac sa' choxa. Ca'aj cui' la̱in li C'ajolbej. La̱in xinchal chak sa' choxa. ");
INSERT INTO kekNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nak toj cuanqueb laj judío sa' li chaki ch'och', laj Moisés quixtaksi chiru jun che' jun li c'anti' yi̱banbil riq'uin li ch'i̱ch' bronce. Jo'can ajcui' la̱in li C'ajolbej. Tento nak tintaksi̱k chiru jun li che', ");
INSERT INTO kekNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","re nak chixjunileb li te'pa̱ba̱nk cue la̱in inc'a' te'sachk. Te'cua̱nk ban xyu'am chi junelic. ");
INSERT INTO kekNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Li Dios c'ajo' nak quixraheb li cuanqueb sa' ruchich'och' nak quixq'ue li Ralal junaj chi ribil re nak chixjunileb li ani te'pa̱ba̱nk re inc'a' te'sachk. Ta̱cua̱nk ban xyu'ameb chi junelic. ");
INSERT INTO kekNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Li Dios inc'a' quixtakla chak li Ralal sa' ruchich'och' chixtenebanquil li tojba ma̱c sa' xbe̱neb li cuanqueb sa' ruchich'och'. Quixtakla ban chak re nak sa' xc'aba' a'an te'colek'. ");
INSERT INTO kekNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Li ani napa̱ban re, ma̱c'a' li tojba ma̱c sa' xbe̱n. Abanan li ani inc'a' napa̱ban re, ac cuan li tojba ma̱c sa' xbe̱n xban nak inc'a' xpa̱b li Ralal li Dios, li junaj chi ribil. ");
INSERT INTO kekNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Xban nak inc'a' neque'pa̱ban, cuan li tojba ma̱c sa' xbe̱neb. Li C'ajolbej quic'ulun sa' ruchich'och' chixc'utbal li xya̱lal chiruheb li cuanqueb sa' ruchich'och'. A'an chanchan li cutan. Abanan eb li cuanqueb sa' ruchich'och' k'axal que'raj cua̱nc sa' xk'ojyi̱nal ru li ma̱c ut inc'a' que'raj cua̱nc sa' li cutan xban nak inc'a' us lix na'lebeb. ");
INSERT INTO kekNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Li ani neque'xba̱nu li ma̱usilal, xic' neque'ril li xya̱lal. Inc'a' nacuulac chiruheb cua̱nc sa' xya̱lal xban nak inc'a' neque'raj ta̱c'utu̱nk li ma̱usilal neque'xba̱nu. ");
INSERT INTO kekNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Abanan li ani cuanqueb sa' ti̱quilal, neque'cuulac chiru cua̱nc sa' xya̱lal re nak ta̱c'utu̱nk nak neque'xba̱nu li c'a'ru naraj li Dios, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Chirix chic a'in, li Jesús co̱ sa' li na'ajej Judea rochbeneb lix tzolom. Aran que'cana cuib oxib cutan ut yo̱ chi cubsi̱nc ha'. ");
INSERT INTO kekNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Laj Juan laj Cubsihom Ha' yo̱ ajcui' chi cubsi̱nc ha' sa' li na'ajej Enón li cuan nach' riq'uin li na'ajej Salim xban nak aran cuan nabal li ha'. Ut neque'cuulac li cristian riq'uin ut naxcubsi xha'eb. ");
INSERT INTO kekNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","A'in quic'ulman nak toj ma̱ji' quiq'uehe' sa' tz'alam laj Juan. ");
INSERT INTO kekNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Que'oc chixcuech'inquil ribeb lix tzolom laj Juan riq'uineb laj judío. Que'xcuech'i ribeb chirix li cubi ha' li yo̱queb chixba̱nunquil. ");
INSERT INTO kekNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Que'cuulac lix tzolom laj Juan riq'uin ut que'xye re: —At tzolonel, li cui̱nk li quicuulac a̱cuiq'uin aran jun pac'al li nima' Jordán, li cach'olob chak resil chiku, a'an yo̱ chi cubsi̱nc ha'. Ut chixjunileb li cristian yo̱queb chi cuulac riq'uin, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Quichak'oc laj Juan ut quixye: —Junak cui̱nk ma̱c'a' c'a'ru tixba̱nu chi inc'a' ta q'uebil re xban li Dios. ");
INSERT INTO kekNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","La̱ex querabi ajcui' chak nak quinye nak moco la̱in ta li Cristo. Yal taklanbilin ban chak xbe̱n cua chiru a'an chixch'olobanquil li resilal. ");
INSERT INTO kekNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Junak cui̱nk xic re chi sumla̱c cuan li ixakilbej riq'uin. Ut li rami̱g cuan aran ut nasaho' sa' xch'o̱l chirabinquil li naxye li be̱lomej. Li Cristo, a'an jo' jun li be̱lomej ut la̱in yal jo' jun li rami̱g. La̱in nasaho' sa' inch'o̱l nak yo̱queb chi xic li cristian riq'uin xban nak a'an li tz'akal aj Colonel. ");
INSERT INTO kekNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Tento nak a'an ta̱nima̱nk xcuanquil ut la̱in ta̱cube̱k incuanquil, chan laj Juan. ");
INSERT INTO kekNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ut quixye ajcui' laj Juan: —A'an xchal chak sa' choxa ut k'axal nim xcuanquil sa' xbe̱n chixjunil. La̱in quinyo'la sa' ruchich'och' ut rehin ajcui' li ruchich'och'. Ut nina̱tinac chirix li c'a'ru nac'ulman sa' ruchich'och'. Li jun li xchal chak sa' choxa, a'an li k'axal nim xcuanquil sa' xbe̱n chixjunil. ");
INSERT INTO kekNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ut li c'a'ru quiril ut quirabi, a'an li naxch'olob xya̱lal. Abanan moco q'uiheb ta li neque'pa̱ban re li c'a'ru naxye. ");
INSERT INTO kekNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Abanan li ani naxpa̱b li c'a'ru naxye, riq'uin a'an naxc'ut nak naxpa̱b nak tz'akal ya̱l li c'a'ru yebil xban li Dios. ");
INSERT INTO kekNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Li Jesucristo, a'an taklanbil chak xban li Dios ut naxye li c'a'ru nayehe' re xban li Dios xban nak li Santil Musik'ej cuan riq'uin chi tz'akal. ");
INSERT INTO kekNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Li Acuabej Dios naxra li Ralal ut quixk'axtesi chixjunil sa' ruk' a'an, ut a'an chic yal re sa' xbe̱n. ");
INSERT INTO kekNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Li ani napa̱ban re li C'ajolbej cuan xyu'am chi junelic. Ut li ani inc'a' napa̱ban re li C'ajolbej inc'a' ta̱cua̱nk xyu'am chi junelic. Cuan ban li tojba ma̱c sa' xbe̱n, chan laj Juan. ");
INSERT INTO kekNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Quicuulac resil riq'uineb laj fariseo nak k'axal nabaleb li yo̱queb chi take̱nc re li Jesús chiruheb li yo̱queb chi take̱nc re laj Juan ut yo̱queb chi cubsi̱c xha'eb. ");
INSERT INTO kekNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Abanan ma̱cua' li Jesús li yo̱ chi cubsi̱nc ha'. A'aneb ban lix tzolom li yo̱queb chi cubsi̱nc ha'. ");
INSERT INTO kekNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nak quixnau li c'a'ru yo̱queb chixyebal laj fariseo, li Jesús qui-el Judea ut co̱ cui'chic Galilea. ");
INSERT INTO kekNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Nak yo̱ chi xic Galilea, tento nak ta̱numek' aran Samaria. ");
INSERT INTO kekNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nak yo̱ chi numec' Samaria, quicuulac sa' li tenamit Sicar. Li tenamit a'an nach' cuan riq'uin li na'ajej li quixq'ue laj Jacob re laj José li ralal. ");
INSERT INTO kekNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ut aran cuan jun li becbil ha' li quixtakla xbecbal laj Jacob najter. Cua'leb na chic quicuulac aran li Jesús. Quic'ojla chire li becbil ha' chi hila̱nc xban nak quilub chi be̱c. ");
INSERT INTO kekNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Quicuulac jun li ixk aj Samaria chirisinquil xha'. Ut li Jesús quixye re: —Si bayak cuuc'a, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ut eb lix tzolom li Jesús ac xco̱eb sa' tenamit chixlok'bal lix tzacae̱mkeb. ");
INSERT INTO kekNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Quichak'oc li ixk ut quixye re: —La̱in aj Samaria ut la̱at, la̱at aj judío. ¿C'a'ut nak nacapatz' a̱cuuc'a cue? chan. Quixye re chi jo'can xban nak eb laj judío inc'a' neque'xc'am rib sa' usilal riq'uineb laj Samaria. ");
INSERT INTO kekNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Li Jesús quixye re: —Cui ta nacanau c'a'ru li ma̱tan li naxq'ue li Dios, ut cui ta nacanau anihin la̱in li yo̱quin chixtz'a̱manquil cuuc'a a̱cue, la̱at ta̱tz'a̱ma raj a̱cuuc'a cuiq'uin ut tinq'ue raj a̱cue li ha' li naq'uehoc junelic yu'am, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Quichak'oc li ixk ut quixye re: —Ka̱cua', ¿C'a' ta cui' ru ta̱cuisi cui' li ha'? Cham cuan chak. Ut, ¿chan ta cui' ru nak ta̱q'ue li ha' li naq'uehoc yu'am? ");
INSERT INTO kekNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Laj Jacob li kaxe'to̱nil yucua' quixcanab chok' ke li becbil ha' a'in. Arin qui-uc'ac a'an ut arin ajcui' que'uc'ac li ralal xc'ajol ut lix queto̱mk. ¿Ma la̱at ta bi' k'axal nim a̱cuanquil chiru a'an? chan li ixk. ");
INSERT INTO kekNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Quichak'oc li Jesús ut quixye re: —Chixjunileb li te'uc'ak re li ha' a'in, ta̱chakik cui'chic reheb. ");
INSERT INTO kekNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","A'ut li te'uc'ak re li ha' tinq'ue la̱in, ma̱ jok'e chic ta̱chakik reheb. Li ha' li tinq'ue la̱in jalan cui'. A'an li junelic yu'am. Chanchan jun li yu'am ha' li cuan chi junelic. Ma̱c'a' roso'jic, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Li ixk quixye re: —Ka̱cua', q'ue cue li ha' a'an re nak inc'a' chic ta̱chakik cue, chi moco tincha̱lk chic toj arin chirisinquil inha', chan. ");
INSERT INTO kekNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Li Jesús quixye re: —Ayu. Bok chak la̱ be̱lom ut tatcha̱lk cui'chic arin a̱cuochben, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—Ma̱c'a' inbe̱lom, chan li ixk. Li Jesús quixye re: —Ya̱l li xaye nak ma̱c'a' a̱be̱lom, ");
INSERT INTO kekNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","xban nak o̱b li cui̱nk cuanjenak a̱cuiq'uin. Ut li jun li cuan a̱cuiq'uin anakcuan ma̱cua' ajcui' a̱be̱lom. Ya̱l li xaye nak ma̱c'a' a̱be̱lom, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Quixye li ixk re: —Ka̱cua', jo' li la̱at anchal profeta. ");
INSERT INTO kekNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Eb li kaxe'to̱nil yucua' la̱o aj Samaria que'tijoc chiru li Dios sa' li tzu̱l li cuan arin. Abanan la̱ex aj judío nequeye nak toj aran Jerusalén cuan li tz'akal na'ajej re lok'oni̱nc. Ye cue bar cuan li tz'akal xya̱lal, chan li ixk. ");
INSERT INTO kekNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Quixye li Jesús re: —At ixk, pa̱b li c'a'ru tinye a̱cue. Ta̱cuulak xk'ehil nak moco tento ta chic texxic sa' li tzu̱l li cuan arin, chi moco Jerusalén re textijok chiru li Dios Acuabej. ");
INSERT INTO kekNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","La̱ex aj Samaria inc'a' nequenau chi tz'akal ani nequeq'ue xlok'al. La̱o aj judío nakanau chi tz'akal ani nakaq'ue xlok'al xban nak li colba-ib riq'uineb laj judío xchal chak. ");
INSERT INTO kekNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ta̱cuulak xk'ehil, ut anakcuan ajcui', nak eb li te'xlok'oni li Acuabej Dios chi tz'akal, te'xba̱nu chi anchal xch'o̱leb ut chi ya̱l xban nak li Acuabej Dios naraj nak te'xlok'oni chi tz'akal re ru. ");
INSERT INTO kekNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Li Dios, a'an musik'ej ut li ani ta̱lok'oni̱nk re, tento nak tixba̱nu chi anchal xch'o̱l ut chi tz'akal re ru, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Quichak'oc li ixk ut quixye re: —La̱in ninnau nak ta̱cha̱lk li Mesías li ta̱colok ke. Li Cristo neque'xye re. Nak tol-e̱lk a'an, tixch'olob chiku chixjunil li c'a'ak re ru a'in, chan li ixk. ");
INSERT INTO kekNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Quixye li Jesús re: —La̱in li Cristo li yo̱quin chi a̱tinac a̱cuiq'uin, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Sa' ajcui' li ho̱nal a'an, que'cuulac eb lix tzolom li Jesús. Ut que'sach xch'o̱leb chirilbal nak yo̱ chi a̱tinac riq'uin li ixk aj Samaria. Abanan ma̱ jun quiyehoc re: —¿C'a'ut nak yo̱cat chi a̱tinac riq'uin li ixk a'an?— Chi moco que'xye: —¿C'a'ru yo̱cat chixyebal re?— ");
INSERT INTO kekNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Li ixk quixcanab lix cuc aran ut co̱ sa' li tenamit ut quixye reheb li cuanqueb aran: ");
INSERT INTO kekNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Yo'keb chicuix chirilbal jun li cui̱nk quixye cue chixjunil lin yehom inba̱nuhom. Ma̱re a'an li Cristo li yo̱co chiroybeninquil, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Jo'can nak li cuanqueb sa' li tenamit a'an co̱eb riq'uin li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nak toj ma̱ji' neque'cuulac, eb lix tzolom li Jesús yo̱queb chixtz'a̱manquil chiru nak ta̱cua'ak. Que'xye re: —At tzolonel, cua'in, chanqueb re. ");
INSERT INTO kekNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Li Jesús quixye reheb: —Ma̱cua' tzacae̱mk nasaho' cui' inch'o̱l. La̱in cuan jun xsahil inch'o̱l ut la̱ex inc'a' nequenau c'a'ut, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ut eb lix tzolom que'xye chi ribileb rib: —Ma̱re ani xc'amoc chak xcua, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Li Jesús quixye reheb: —La̱in nasaho' inch'o̱l nak ninba̱nu li c'a'ru naraj li quitaklan chak cue ut tinchoy xba̱nunquil lix c'anjel. A'an ru̱chil li cua chok' cue la̱in, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","La̱ex nequeye, “Toj ta̱numek' ca̱hib po chic tojo'nak to-oc chi k'oloc”, chanquex. Abanan la̱in ninye e̱re us xtiquibanquil anakcuan. Ilomak li q'uila tenamit. Chanchaneb li acui̱mk li ac xk'ano'. Tento nak ta̱ch'oloba̱k li xya̱lal chiruheb. ");
INSERT INTO kekNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Laj k'olonel naxc'ul xtojbal ut nasaho' sa' xch'o̱l rochben laj acuinel. Jo'can ajcui' li ani naxch'olob xya̱lal re nak te'pa̱ba̱nk li cristian. Li jun a'an ta̱cua̱nk lix k'ajca̱munquil xban nak cua̱nkeb li te're̱chani li junelic yu'am sa' xc'aba' a'an. ");
INSERT INTO kekNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Riq'uin a'in na-el chi ya̱l li neque'xye: Jun li na-acuoc re ut jun chic li nak'oloc re. ");
INSERT INTO kekNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","La̱in xexintakla chixk'olbal li moco la̱ex ta xexc'anjelan re. Jalaneb xe'c'anjelan re ut la̱ex chic xexyaloc xsahil lix c'anjeleb, chan li Jesús reheb. ");
INSERT INTO kekNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nabaleb laj Samaria li cuanqueb sa' li tenamit a'an que'xpa̱b nak li Jesús a'an li Cristo, xban nak li ixk quixye reheb: —Li cui̱nk a'an xye cue chixjunil li c'a'ru quilajinba̱nu.— ");
INSERT INTO kekNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nak que'cuulac eb laj Samaria riq'uin li Jesús, que'relaji ru chi cana̱c riq'uineb. Ut a'an quicana cuib cutan riq'uineb. ");
INSERT INTO kekNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ut k'axal cui'chic nabaleb li que'pa̱ban re li Jesús xban nak que'rabi li c'a'ru quixye. ");
INSERT INTO kekNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ut que'xye re li ixk: —Anakcuan nakapa̱b, moco xban ta li c'a'ru xaye ke. La̱o xkabi chi tz'akal li c'a'ru xye ut nakanau nak a'an tz'akal li Cristo laj Colol re li cuanqueb sa' ruchich'och', chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nak ac xnume' li cuib cutan, li Jesús qui-el aran ut co̱ Galilea. ");
INSERT INTO kekNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ut li Jesús quixch'olob xya̱lal ut quixye nak junak profeta inc'a' naq'uehe' xlok'al sa' lix tenamit. ");
INSERT INTO kekNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nak quicuulac li Jesús sa' li tenamit Galilea, quic'ule' sa' xya̱lal xbaneb li que'cuulac aran Jerusalén chixnumsinquil li nink'e Pascua xban nak que'ril chixjunil li quilajxba̱nu li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Li Jesús co̱ cui'chic sa' li tenamit Caná re Galilea li quixsuk'isi cui' li ha' chok' vino. Ut aran Capernaum cuan jun li cui̱nk aj c'anjel chiru li rey. Yaj li ralal. ");
INSERT INTO kekNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Li cui̱nk a'an quirabi resil nak li Jesús ac xsuk'i chak Judea ut cuan aran Galilea. Co̱ riq'uin li Jesús ut quirelaji ru chi xic Capernaum re tixq'uirtesi li ralal. Ca̱mc re xban nak nim xyajel. ");
INSERT INTO kekNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Li Jesús quixye re li cui̱nk: —La̱ex inc'a' nequepa̱b nak li Dios quitaklan chak cue cui inc'a' tinc'ut junak milagro che̱ru retalil nak cuan incuanquil, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ut li cui̱nk quixye cui'chic re li Jesús: —Ka̱cua', ba̱nu usilal cue. Yo'o chi junpa̱t xban nak k'axal nim xyajel li cualal. Ca̱mc re, chan li cui̱nk. ");
INSERT INTO kekNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Li Jesús quixye re li cui̱nk: —Ayu sa' la̱ cuochoch. La̱ cualal inc'a' ta̱ca̱mk. Ta̱q'uira̱k ban, chan. Ut li cui̱nk quixpa̱b li quiyehe' re xban li Jesús ut co̱. ");
INSERT INTO kekNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nak ac cuulac re sa' li rochoch, eb lix mo̱s que'co̱eb chixc'ulbal ut que'xye re: —Yo'yo la̱ cualal. Yo̱ chi usa̱c, chanqueb re. ");
INSERT INTO kekNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ut li cui̱nk quixpatz' reheb jok'e ho̱nal quixtiquib usa̱c. Ut que'xye re: —Ecue̱r sa' jun o̱r re li ecuu quinume' lix tik, chanqueb re. ");
INSERT INTO kekNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ut quinak sa' xch'o̱l li yucua'bej nak sa' ajcui' li ho̱nal a'an quiyehe' re xban li Jesús nak ta̱q'uira̱k li ralal. Ut li cui̱nk a'an quixpa̱b li Jesús jo'queb ajcui' chixjunileb li cuanqueb sa' li rochoch. ");
INSERT INTO kekNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","A'an a'in li xcab milagro li quixba̱nu li Jesús nak qui-el Judea ut co̱ cui'chic Galilea. ");
INSERT INTO kekNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Chirix chic a'in, li Jesús co̱ Jerusalén sa' li nink'e li neque'xba̱nu eb laj judío. ");
INSERT INTO kekNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Sa' li tenamit Jerusalén bar cuan cui' li oqueba̱l li neque'rocsi cui' li carner, cuan jun li ha' Betesda xc'aba' sa' ra̱tinoba̱leb laj hebreo. Aran cuan o̱b li muheba̱l. ");
INSERT INTO kekNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Sa' eb li muheba̱l a'an cuanqueb nabaleb li yaj. Cuanqueb mutz', cuanqueb ye̱k rokeb, ut cuanqueb li sic rokeb ut sic ruk'eb. Yo̱queb chiroybeninquil nak ta̱ec'a̱nk li ha'. ");
INSERT INTO kekNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Jun x-ángel li Ka̱cua' nacube chak sa' choxa yalak jok'e ut narec'asi li ha'. Li ani xbe̱n cua na-oc chi sa' nak ac x-ec'asi̱c li ha', li jun a'an naq'uira a' yal c'a'ru xyajel. ");
INSERT INTO kekNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Cuan jun li cui̱nk aran cuakxaklaju xca'c'a̱l (38) chihab roquic lix yajel. ");
INSERT INTO kekNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nak li Jesús quiril li cui̱nk jiljo aran chire li ha' quixnau nak ac najter roquic lix yajel. Quixye re: —¿Ma ta̱cuaj q'uira̱c? chan re. ");
INSERT INTO kekNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Quixye li cui̱nk: —Ka̱cua', nacuaj raj abanan ma̱ ani na-ocsin cue sa' li ha' nak na-ec'asi̱c. Nak yo̱quin chixyalbal oc, jalan chic na-oc xbe̱n cua chicuu, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Quixye li Jesús re: —Cuaclin, xoc la̱ cuarib ut be̱n, chan re. ");
INSERT INTO kekNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Sa' ajcui' li ho̱nal a'an li cui̱nk quiq'uira. Quixakli, quixxoc lix cuarib ut quibe̱c. A'in quic'ulman sa' li hiloba̱l cutan. ");
INSERT INTO kekNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Que'oc chi cuech'i̱nc li neque'taklan sa' xya̱nkeb laj judío. Que'xye re li cui̱nk li quiq'uira: —Hiloba̱l cutan anakcuan. Yo̱cat chixk'etbal li kachak'rab xban nak yo̱cat chixc'ambal la̱ cuarib chiru li hiloba̱l cutan, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Quichak'oc li cui̱nk ut quixye reheb: —Li cui̱nk li xq'uirtesin cue, xye cue, “c'am la̱ cuarib ut be̱n”, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Que'xpatz' re: —¿Ani li cui̱nk li xyehoc a̱cue nak ta̱xoc la̱ cuarib ut tatbe̱k? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Li cui̱nk li quiq'uirtesi̱c inc'a' naxnau ani ta a'an, xban nak k'axal nabaleb li cuanqueb aran ut li Jesús ac x-el sa' xya̱nkeb. ");
INSERT INTO kekNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mokon chic li Jesús quixtau cui'chic li cui̱nk sa' li templo ut quixye re: —Chaq'uehak retal nak xatq'uira. Canab xba̱nunquil li inc'a' us ma̱re anchal ta̱cha̱lk junak chic nimla raylal sa' a̱be̱n, chan li Jesús re. ");
INSERT INTO kekNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Qui-el li cui̱nk riq'uin li Jesús ut quixye resil reheb li neque'taklan sa' xya̱nkeb laj judío nak li Jesús, a'an li quiq'uirtesin re. ");
INSERT INTO kekNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Eb li neque'taklan sa' xya̱nkeb laj judío xic' que'ril li Jesús xban nak naq'uirtesin sa' li hiloba̱l cutan. Ut que'raj xcamsinquil. ");
INSERT INTO kekNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Li Jesús quixye reheb: —Lin Yucua' toj yo̱ chixtenk'anquileb li cristian ut tento ajcui' nak tintenk'aheb la̱in, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","K'axal cui'chic que'josk'o' laj judío riq'uin a'in. Jo'can nak que'raj xcamsinquil xban nak moco ca'aj ta cui' naxk'et lix chak'rabeb nak naq'uirtesin chiru li hiloba̱l cutan; riq'uin aj ban cui' nak naxjuntak'e̱ta rib riq'uin li Dios nak naxye nak li Dios, a'an lix Yucua'. ");
INSERT INTO kekNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jo'can nak li Jesús quixye reheb: —Relic chi ya̱l tinye e̱re, La̱in li C'ajolbej. Ma̱c'a' naru tinba̱nu injunes. Li c'a'ru naxc'ut chicuu lin Yucua', a'an li ninba̱nu. Chixjunil li naxba̱nu lin Yucua', a'an li ninba̱nu la̱in. ");
INSERT INTO kekNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","La̱in li C'ajolbej. Raro̱quin xban lin Yucua'. A'an naxc'ut chicuu chixjunil li c'a'ak re ru naxba̱nu. Ut toj cuan cui'chic c'a'ak re ru xni̱nkal ru na'leb chiru a'in tixc'ut chicuu xba̱nunquil. Ut la̱ex ta̱sachk e̱ch'o̱l chirilbal. ");
INSERT INTO kekNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Li Yucua'bej naxcuaclesiheb cui'chic chi yo'yo li camenak. Ut jo'can ajcui' la̱in li C'ajolbej. La̱in ninq'ue li junelic yu'am reheb li ani nacuaj. ");
INSERT INTO kekNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Li Yucua'bej ma̱ ani naxrak a̱tin sa' xbe̱n. Quixk'axtesiheb ban sa' cuuk' re nak la̱in chic tinrakok a̱tin sa' xbe̱neb. ");
INSERT INTO kekNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Quixba̱nu chi jo'can re nak chixjunileb te'xq'ue inlok'al jo' nak neque'xq'ue xlok'al li Yucua'bej. Li ani inc'a' naxq'ue inlok'al la̱in li C'ajolbej, inc'a' ajcui' naxq'ue xlok'al li Yucua'bej li quitaklan chak cue. ");
INSERT INTO kekNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Relic chi ya̱l ninye e̱re nak li ani na-abin re li c'a'ru ninye ut naxpa̱b li Dios li quitaklan chak cue, li jun a'an cuan xyu'am chi junelic. Inc'a' ta̱xic sa' tojba ma̱c xban nak inc'a' chic tenebanbil li ca̱mc sa' xbe̱n. Cua̱nk ban chic xyu'am chi junelic. ");
INSERT INTO kekNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Chi ya̱l ninye e̱re ta̱cuulak xk'ehil ut anakcuan ajcui' xcuulac xcutanquil, nak eb li chanchan camenakeb xban li ma̱c te'rabi li cua̱tin la̱in li C'ajolbej. Ut li te'abi̱nk cue te'cua̱nk xyu'am chi junelic. ");
INSERT INTO kekNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Li Yucua'bej cuan xcuanquil chi q'uehoc junelic yu'am ut a'an ajcui' quiq'uehoc cue la̱in li C'ajolbej lin cuanquil chi q'uehoc junelic yu'am. ");
INSERT INTO kekNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ut quixq'ue ajcui' incuanquil chi rakoc a̱tin xban nak la̱in li C'ajolbej. Taklanbilin chak xban li Dios. ");
INSERT INTO kekNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Misach e̱ch'o̱l chirabinquil li yo̱quin chixyebal. Ta̱cuulak xk'ehil nak chixjunileb li camenak te'rabi li c'a'ru tinye. ");
INSERT INTO kekNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Li que'xba̱nu li us te'cuacli̱k cui'chic ut te'cua̱nk xyu'am chi junelic. Ut eb li que'xba̱nu li inc'a' us te'cuacli̱k ajcui' re te'takla̱k sa' li tojba ma̱c. ");
INSERT INTO kekNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","La̱in ma̱c'a' naru ninba̱nu injunes. La̱in ninrakoc a̱tin jo' naxye cue li Yucua'bej. Jo'can nak ninrakoc a̱tin sa' ti̱quilal. Inc'a' ninba̱nu li c'a'ru nacuaj la̱in. Ninba̱nu ban li c'a'ru naraj li Yucua'bej li quitaklan chak cue. ");
INSERT INTO kekNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Cui la̱in tinch'olob xya̱lal che̱ru anihin tz'akal la̱in, la̱ex te̱ye nak inc'a' ya̱l li yo̱quin chixyebal. ");
INSERT INTO kekNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Abanan cuan jun chic li naxch'olob xya̱lal che̱ru anihin tz'akal la̱in ut la̱in ninnau nak ya̱l li yo̱ chixyebal chicuix. ");
INSERT INTO kekNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","La̱ex xetakla xpatz'bal re laj Juan laj Cubsihom Ha' ut a'an quixch'olob li xya̱lal che̱ru ut ya̱l li quixye chicuix. ");
INSERT INTO kekNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Abanan inc'a' tento nak junak cui̱nk tixch'olob xya̱lal anihin. Ninye ban e̱re anihin re nak texcolek'. ");
INSERT INTO kekNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Laj Juan chanchan jun li xam quixcutanobresi e̱be nak quixch'olob li xya̱lal che̱ru. Ut quisaho' jun c'amoc sa' e̱ch'o̱l chirabinquil li quixye. ");
INSERT INTO kekNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Li c'a'ru quixch'olob laj Juan chicuix, a'an ya̱l. Abanan riq'uin li c'a'ru ninba̱nu, k'axal cui'chic naxc'ut chi tz'akal anihin la̱in. La̱in ninba̱nu li c'a'ru quixye cue li Yucua'bej. Li c'a'ru ninba̱nu la̱in, a'an naxc'ut nak taklanbilin xban li Yucua'bej. ");
INSERT INTO kekNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ut li Yucua'bej li quitaklan chak cue, a'an quixch'olob ajcui' li xya̱lal chicuix usta ma̱ jun sut xerabi chi a̱tinac chi moco queril chanru na-iloc. ");
INSERT INTO kekNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","La̱ex inc'a' nequeraj xc'ulbal li ra̱tin xban nak inc'a' niquine̱pa̱b la̱in, li taklanbilin chak xban a'an. ");
INSERT INTO kekNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","La̱ex nequeq'ue e̱ch'o̱l chixtzolbal xsa' li Santil Hu. La̱ex nequec'oxla nak aran te̱tau chanru ta̱cua̱nk le̱ yu'am chi junelic. Abanan inc'a' nequeq'ue retal nak li Santil Hu a'an naxch'olob ajcui' li xya̱lal chicuix la̱in. ");
INSERT INTO kekNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","La̱ex inc'a' nequeraj xpa̱banquil nak la̱in ninq'uehoc e̱re le̱ yu'am chi junelic. ");
INSERT INTO kekNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","La̱in inc'a' nacuaj nak te̱q'ue inlok'al la̱ex, ");
INSERT INTO kekNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","xban nak ninnau chanru le̱ na'leb. Ninnau nak inc'a' nequera li Dios chi anchal e̱ch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","La̱in xinchal sa' xc'aba' lin Yucua'. Abanan inc'a' xeraj inc'ulbal. Cui ut ani ta chic junak ta̱cha̱lk yal naxtakla chak rib xjunes, la̱ex te̱c'ul raj a'an. ");
INSERT INTO kekNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nak nequeq'ue e̱lok'al chi ribil e̱rib, c'ajo' nak nacuulac che̱ru. Abanan inc'a' nequesic' li lok'al li naxq'ue li jun chi Dios. ¿Chan ta cui' ru nak tine̱pa̱b la̱in chi jo'canan? ");
INSERT INTO kekNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Me̱c'oxla nak la̱in tinjitok e̱re chiru lin Yucua'. Cuan jun li ta̱jitok e̱re. A'an li chak'rab li quiq'uehe' re laj Moisés li c'ojc'o cui' e̱ch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Cui ta nequepa̱b li c'a'ru quixye laj Moisés, tine̱pa̱b aj raj cui' la̱in xban nak laj Moisés quixch'olob ajcui' chak xya̱lal chicuix la̱in. ");
INSERT INTO kekNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Cui inc'a' nequepa̱b li c'a'ru quixtz'i̱ba laj Moisés chicuix, ¿chan ta cui' ru nak te̱pa̱b li c'a'ru ninye la̱in? ");
INSERT INTO kekNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Mokon chic li Jesús co̱ cui'chic jun pac'al li palau Galilea. Neque'xye ajcui' Tiberias re li palau a'an. ");
INSERT INTO kekNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Nabaleb yo̱queb chi ta̱ke̱nc re xban nak que'rileb li milagro li yo̱ chixba̱nunquil nak naxq'uirtesiheb li yaj. ");
INSERT INTO kekNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ut quitake' li Jesús chiru jun li tzu̱l ut aran quic'ojla rochbeneb lix tzolom. ");
INSERT INTO kekNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ac cuulac re xk'ehil li nink'e Pascua, li neque'xba̱nu eb laj judío. ");
INSERT INTO kekNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Li Jesús quiril nak nabaleb li yo̱queb chi cuulac riq'uin. Quixye re laj Felipe: —¿Bar ta̱ru̱k takalok' xcuaheb chixjunileb li tenamit a'in? chan. ");
INSERT INTO kekNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Quixye chi jo'can yal re rilbal c'a' na ru tixye laj Felipe xban nak ac cuan sa' xch'o̱l li Jesús nak tixq'ue xcuaheb. ");
INSERT INTO kekNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Quixye laj Felipe: —Ka̱cua', cuib ciento denario chi caxlan cua inc'a' ta̱tz'aklok re te'tz'ak ca'ch'inak chi xju̱nkaleb, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Jun chic reheb lix tzolom aj Andrés xc'aba' ras laj Simón Pedro. Quixye: ");
INSERT INTO kekNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Cuan jun li al arin cuan cuib li car riq'uin ut o̱b li caxlan cua yi̱banbil riq'uin cebada. Abanan a'in ma̱ jok'e ta̱tz'aklok reheb li q'uila tenamit, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ut quixye li Jesús reheb: —Q'uehomakeb chi c'ojla̱c li tenamit.— Nabal li pach'aya' cuan aran. Chixjunileb que'c'ojla sa' li pach'aya'. O̱b mil na chi cui̱nk li cuanqueb aran. ");
INSERT INTO kekNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Tojo'nak li Jesús quixchap li caxlan cua. Quixbantioxi chiru li Dios. Quixjachi li caxlan cua ut quixq'ue reheb lix tzolom re nak te'xjeq'ui reheb li q'uila tenamit li c'ojc'o̱queb aran. Jo'can ajcui' quixba̱nu riq'uin li car. Ut que'cua'ac chixjunileb toj retal que'c'ojla xch'o̱leb. ");
INSERT INTO kekNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nak ac xe'rake' chi cua'ac, li Jesús quixye reheb lix tzolom: —Xocomak li jo' q'uial x-ela'an re nak ma̱c'a' ta̱tz'ekma̱nk, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Que'xxoc cablaju chacach rela' li caxlan cua yi̱banbil riq'uin cebada. A'an li qui-ela'an nak que'rake' chi cua'ac chixjunileb li cuanqueb aran. ");
INSERT INTO kekNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nak que'ril li milagro li quixba̱nu li Jesús, eb li cuanqueb aran que'xye: —Relic chi ya̱l li cui̱nk a'in, a'an li profeta li quiyehe' chak resil junxil nak ta̱cha̱lk sa' ruchich'och', chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Li Jesús quixnau nak te'raj xpuersinquil ru re nak ta̱oc chok' rey. Jo'can nak qui-el sa' xya̱nkeb ut co̱ xjunes sa' li tzu̱l. ");
INSERT INTO kekNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Oc re k'ojyi̱n nak co̱eb lix tzolom li Jesús chire li palau. ");
INSERT INTO kekNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Li Jesús ma̱ji' nacuulac riq'uineb. Que'oc sa' jun li jucub ut yo̱queb chi xic sa' li tenamit Capernaum li cuan jun pac'al li palau. ");
INSERT INTO kekNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ac x-oc li k'ojyi̱n nak quichal jun cacuil ik' ut qui-oc chi ec'a̱nc ru li palau chi cau. ");
INSERT INTO kekNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Cuan na xcab legua ac xe'be̱c chiru li ha' sa' li jucub nak que'ril nak yo̱ chak chi cha̱lc li Jesús. Yo̱ chi be̱c chiru li ha'. Yo̱ chak chi nach'oc chixc'atk li jucub. C'ajo' nak que'xucuac xban nak inc'a' que'xnau ru. ");
INSERT INTO kekNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ut li Jesús quixye reheb: —La̱in. Mexxucuac, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ut c'ajo' xsahil xch'o̱leb nak que'rocsi sa' li jucub. Ut sa' ajcui' li ho̱nal a'an que'cuulac sa' li na'ajej li yo̱queb cui' chi xic. ");
INSERT INTO kekNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Cuulajak chic li q'uila tenamit li cuanqueb chire li palau li que'el cui', que'xq'ue retal nak jun ajcui' li jucub qui-el aran. Ut que'xnau nak li Jesús inc'a' qui-oc chi sa' li jucub a'an rochbeneb lix tzolom. Xjuneseb ban co̱eb. ");
INSERT INTO kekNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ut cuanqueb cui'chic jucub que'el chak Tiberias que'cuulac chixc'atk li na'ajej li que'cua'ac cui' nak ac xbantioxi li Jesús chiru li Dios. ");
INSERT INTO kekNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Li q'uila tenamit que'xq'ue retal nak ma̱ ani chic li Jesús sa' li na'ajej a'an, chi moco cuanqueb lix tzolom. Que'oc sa' eb li jucub li que'chal Tiberias ut co̱eb Capernaum chixsic'bal. ");
INSERT INTO kekNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nak que'xtau li Jesús jun pac'al li palau, que'xye re: —At tzolonel, ¿Jok'e xatchal arin?— ");
INSERT INTO kekNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Quichak'oc li Jesús ut quixye reheb: —Relic chi ya̱l ninye e̱re nak la̱ex yo̱quex chinta̱kenquil xban nak xexinq'ue chi cua'ac toj retal xexnujac. Inc'a' yo̱quex chinta̱kenquil xban nak xeril li milagro li xinba̱nu. ");
INSERT INTO kekNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mixic e̱ch'o̱l ca'aj cui' riq'uin xsic'bal li tzacae̱mk li na-oso'. Cheq'uehak ban e̱ch'o̱l chixsic'bal li tzacae̱mk li inc'a' nalaj na-oso'. A'an li junelic yu'am li ninq'ue la̱in li C'ajolbej. A'an aj e nak quixq'ue incuanquil ut quinixtakla chak li Yucua'bej, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ut que'xye re li Jesús: —¿C'a' raj ru takaba̱nu la̱o re nak ta̱sahok' xch'o̱l li Dios kiq'uin? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Li Jesús quixye reheb: —Li c'a'ru naraj li Dios nak te̱ba̱nu, a'an a'in: nak tine̱pa̱b la̱in xban nak taklanbilin chak xban, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ut que'xye cui'chic re: —Tento ta̱c'ut chiku junak li milagro re nak takapa̱b nak taklanbilat xban li Dios. ¿C'a'ru li retalil ta̱c'ut chiku? ");
INSERT INTO kekNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Eb li kaxe'to̱nil yucua' que'q'uehe' chak li maná chixcua'eb nak yo̱queb chak chi numec' sa' li chaki ch'och' jo' tz'i̱banbil retalil sa' li Santil Hu: Choxahil cua quiq'uehe' chixcua'eb. ");
INSERT INTO kekNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ut li Jesús quixye reheb: —Relic chi ya̱l ninye e̱re, moco a' ta laj Moisés quiq'uehoc reheb li choxahil cua. A' ban lin Yucua', a'an li quiq'uehoc reheb. Ut a'an naq'uehoc li tz'akal choxahil cua. ");
INSERT INTO kekNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Li tz'akal choxahil cua li naxq'ue li Dios, a'an li jun li quichal chak sa' choxa ut naxq'ue li junelic yu'am reheb li cuanqueb sa' ruchich'och', chan. ");
INSERT INTO kekNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Eb a'an que'xye re: —At Ka̱cua', ta̱q'ue ta ke rajlal li cua a'an.— ");
INSERT INTO kekNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Li Jesús quixye reheb: —La̱in li cua a'an. La̱in ninq'uehoc junelic yu'am. Li ani napa̱ban cue ta̱c'ojoba̱k xch'o̱l. Inc'a' chic ta̱tz'oca̱k ut inc'a' chic ta̱chakik re. Chanchan nak ac xrake' chi tzaca̱nc. ");
INSERT INTO kekNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Aban ac xinye e̱re nak usta ac xeril cuu, toj inc'a' ajcui' niquine̱pa̱b. ");
INSERT INTO kekNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Chixjunileb li tixk'axtesi cue li Yucua'bej, tine'xpa̱b. Ut li ani napa̱ban cue, la̱in inc'a' tintz'ekta̱na. ");
INSERT INTO kekNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","La̱in xinchal chak sa' choxa re tinba̱nu li c'a'ru naraj li Dios li quitaklan chak cue. Moco xinchal ta chixba̱nunquil li c'a'ru nacuaj la̱in. ");
INSERT INTO kekNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Li c'a'ru naraj lin Yucua' li quitaklan chak cue, a'an nak ma̱ jun reheb li cualal inc'ajol li xk'axtesi cue ta̱sachk chicuu. Tincuaclesiheb ban chi cua̱nkeb xyu'am sa' roso'jiqueb li cutan. ");
INSERT INTO kekNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Li Yucua'bej li quitaklan chak cue, a'an naraj nak chixjunileb li te'xq'ue retal nak la̱in li C'ajolbej ut tine'xpa̱b ta̱cua̱nk xyu'ameb chi junelic. Ut la̱in tincuaclesiheb ut tinq'ue xyu'ameb sa' roso'jiqueb li cutan, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ut eb laj judío que'oc chixcuech'inquil rix li quixye li Jesús xban nak quixye, “La̱in li cua. La̱in xinchal chak sa' choxa.” ");
INSERT INTO kekNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Que'xye chi ribileb rib: —¿Ma ma̱cua' ta bi' a'in li Jesús li ralal laj José? La̱o nakanau ruheb lix na' xyucua'. ¿C'a'ut nak naxye nak sa' choxa xchal chak? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Quixye li Jesús reheb: —Canabomak xcuech'inquil e̱rib, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ma̱ ani naru ta̱pa̱ba̱nk cue cui inc'a' ta k'axtesinbil cue xban li Yucua'bej li quitaklan chak cue. Li neque'pa̱ban cue, la̱in tincuaclesiheb cui'chic chi yo'yo sa' roso'jiqueb li cutan. ");
INSERT INTO kekNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tz'i̱banbil retalil chi jo'ca'in sa' li Santil Hu xbaneb li profeta: Li Dios tixc'ut li xya̱lal chiruheb chixjunileb. Jo'can nak chixjunileb li neque'abin re ut neque'xtau ru li c'a'ru naxye li Dios, eb a'an tine'xpa̱b ajcui' la̱in. ");
INSERT INTO kekNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","A'in moco naraj ta naxye nak cuan li que'iloc chak ru li Acuabej Dios. Ca'aj cui' la̱in ninna'oc ru xban nak riq'uin quinchal chak. ");
INSERT INTO kekNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Relic chi ya̱l tinye e̱re nak li ani napa̱ban cue, li jun a'an cuan xyu'am chi junelic. ");
INSERT INTO kekNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","La̱in li cua li naq'uehoc yu'am chi junelic. ");
INSERT INTO kekNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Le̱ xe'to̱nil yucua' que'xcua' chak li cua li quichal chak sa' choxa junxil nak yo̱queb chi numec' sa' li chaki ch'och'. Usta que'xcua' li cua li quichal sa' choxa, abanan moco cuanqueb ta xyu'am chi junelic. ");
INSERT INTO kekNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Abanan, la̱in li xinchal chak sa' choxa, la̱in li tz'akal choxahil cua xban nak ninq'uehoc yu'am chi junelic. Li ani napa̱ban cue, a'an inc'a' ta̱ca̱mk. Cua̱nk ban xyu'am chi junelic. ");
INSERT INTO kekNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","La̱in li yo'yo̱quil cua. Quinchal chak sa' choxa. Li ani napa̱ban cue la̱in inc'a' ta̱sachk. Cua̱nk ban xyu'am chi junelic. Li cua li tinq'ue la̱in, a'an lin tibel nak tink'axtesi cuib chi ca̱mc re nak ta̱ru̱k te'cua̱nk xyu'ameb chi junelic li cuanqueb sa' ruchich'och', chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nak que'rabi li c'a'ru quixye, eb laj judío que'oc chixcuech'inquil rix li quixye ut que'xye: —¿Chanru nak tixq'ue lix tibel re takatzaca? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Quixye li Jesús reheb: —Relic chi ya̱l ninye e̱re: Cui inc'a' te̱tzaca lin tibel la̱in li C'ajolbej ut cui inc'a' te̱ruc' lin quiq'uel, inc'a' ta̱cua̱nk le̱ yu'am chi junelic. ");
INSERT INTO kekNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Chixjunileb li neque'xtzaca lin tibel ut neque'ruc' lin quiq'uel, cua̱nk xyu'ameb chi junelic, ut la̱in tincuaclesiheb cui'chic chi yo'yo sa' roso'jiqueb li cutan. ");
INSERT INTO kekNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Lin tibel, a'an li tzacae̱mk li naq'uehoc junelic yu'am. Ut lin quiq'uel, a'an li uc'a li naq'uehoc junelic yu'am. ");
INSERT INTO kekNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Li ani naxtzaca lin tibel ut naruc' lin quiq'uel, li jun a'an cuan chi sum a̱tin cuiq'uin ut la̱in cuanquin chi sum a̱tin riq'uin a'an. ");
INSERT INTO kekNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Li yo'yo̱quil Dios, a'an li quitaklan chak cue. Jo' nak yo'yo chi junelic a'an, jo'can nak yo'yo̱quin ajcui' la̱in chi junelic. Jo'can ajcui' li ani naxtzaca lin tibel, li jun a'an ta̱cua̱nk xyu'am chi junelic sa' inc'aba' la̱in. ");
INSERT INTO kekNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Jo'can nak la̱in li cua li quinchal chak sa' choxa. Moco jo' ta li cua li que'xcua' le̱ xe'to̱nil yucua'. A'an inc'a' quixq'ue xyu'ameb chi junelic. Abanan chixjunileb li te'cua'ok re li cua a'in, eb a'an te'cua̱nk xyu'ameb chi junelic, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Chixjunil li c'a'ak re ru a'in li Jesús quixye reheb nak yo̱ chixc'utbal li xya̱lal chiruheb aran Capernaum sa' li cab li neque'xch'utub cui' ribeb laj judío. ");
INSERT INTO kekNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nak que'rabi li c'a'ru quixye, nabaleb lix tzolom que'oc chi a̱tinac chi ribileb rib, ut que'xye: —C'ajo' xch'a'ajquil xtaubal ru li xye. ¿Ani ta cui' ta̱ta'ok ru? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Li Jesús quixnau nak yo̱queb chixcuech'inquil rix li c'a'ru quixye usta ma̱ ani quiyehoc re. Jo'can nak quixye reheb: —¿Ma inc'a' xcuulac che̱ru li c'a'ru xinye e̱re? ¿Ma te̱canab inta̱kenquil xban? ");
INSERT INTO kekNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Ma ra xerec'a nak xinye e̱re chi jo'can? ¿C'a' raj ru te̱ba̱nu nak te̱ril nak la̱in li C'ajolbej yo̱kin cui'chic chi xic sa' choxa li xincuan cui' chak junxil? ");
INSERT INTO kekNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Li naq'uehoc junelic yu'am, a'an li Santil Musik'ej. A'an ma̱cua' re li tibelej. La̱in xinch'olob xya̱lal che̱ru. Li xinye e̱re yebil cue xban li Santil Musik'ej. Cui te̱pa̱b li c'a'ru xinye, li Santil Musik'ej tixq'ue e̱re li junelic yu'am. ");
INSERT INTO kekNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Abanan toj cuanqueb ajcui' sa' e̱ya̱nk li inc'a' neque'pa̱ban, chan li Jesús. Chalen sa' xticlajic li Jesús quixnau aniheb li inc'a' te'pa̱ba̱nk re. Ut quixnau ajcui' ani li ta̱k'axtesi̱nk re sa' ruk'eb li xic' que'iloc re. ");
INSERT INTO kekNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ut quixye ajcui' li Jesús reheb: —Jo'can nak xinye e̱re nak ma̱ ani ta̱ru̱k ta̱pa̱ba̱nk cue cui inc'a' ta k'axtesinbil cue xban li Yucua'bej, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Chalen sa' li cutan a'an nabaleb lix tzolom que'ch'inan xch'o̱leb ut inc'a' chic que'xta̱ke li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ut li Jesús quixye reheb lix tzolom cablaju: —¿Ma te̱raj ajcui' xic la̱ex? ¿Ma tine̱canab ajcui' la̱ex? chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Quichak'oc laj Simón Pedro ut quixye re: —At Ka̱cua', ¿ani aj iq'uin toxic? La̱at nacaye ke chanru ta̱cua̱nk kayu'am chi junelic. ");
INSERT INTO kekNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","La̱o nakapa̱b li c'a'ru nacaye ut nakanau nak la̱at li Cristo, li Ralal li yo'yo̱quil Dios, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Quixye li Jesús: —¿Ma ma̱cua' ta bi' la̱in xinsic'oc e̱ru la̱ex li cablaju? La̱in xinsic'oc e̱ru ut jun sa' e̱ya̱nk xk'axtesi rib re laj tza, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yo̱ chi a̱tinac chirix laj Judas Iscariote, li ralal laj Simón. Usta a'an jun reheb li cablaju, mokon laj Judas Iscariote quixk'axtesi li Jesús sa' ruk'eb li xic' neque'iloc re. ");
INSERT INTO kekNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Chirix chic a'an, li Jesús yo̱ chixbeninquileb li na'ajej li cuanqueb Galilea. Inc'a' quiraj xic Judea xban nak eb li neque'taklan sa' xya̱nkeb laj judío te'raj xcamsinquil. ");
INSERT INTO kekNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Yo̱ chi cuulac xk'ehil li nink'e nak eb laj judío neque'xyi̱b lix coc' muheba̱l. ");
INSERT INTO kekNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Eb li ri̱tz'in li Jesús que'xye re: —Elen sa' li na'ajej a'in. Ayu Judea re nak eb li neque'ta̱ken a̱cue te'rileb li milagro li nacaba̱nu. ");
INSERT INTO kekNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ma̱ ani junak tixba̱nu lix c'anjel chi mukmu cui naraj nak ta̱na'li̱k ru. Cui ta̱ba̱nu li milagro a'in, c'utbesi la̱ c'anjel chiruheb chixjunileb, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Yal ta eb li ri̱tz'in neque'pa̱ban re nak a'an taklanbil chak xban li Dios. ");
INSERT INTO kekNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Quixye li Jesús reheb: —Toj ma̱ji' nacuulac xk'ehil nak tinxic. La̱ex naru texxic yalak jok'e. ");
INSERT INTO kekNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Eb li cuanqueb sa' ruchich'och' xic' niquine'ril xban nak la̱in ninye reheb nak inc'a' us li yo̱queb chixba̱nunquil. Abanan la̱ex inc'a' xic' nequex-ile' xbaneb. ");
INSERT INTO kekNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ayukex la̱ex sa' li nink'e. La̱in inc'a' tinxic xban nak toj ma̱ji' nacuulac xk'ehil nak tinxic, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nak quixye reheb a'in, li Jesús toj quicana aran Galilea. ");
INSERT INTO kekNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nak ac xco̱eb li ri̱tz'in sa' li nink'e aran Jerusalén, li Jesús co̱ ajcui'. Abanan moco quixye ta rib. Chanchan sa' mukmu co̱. ");
INSERT INTO kekNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Eb li neque'taklan sa' xya̱nkeb laj judío yo̱queb chixsic'bal li Jesús sa' li nink'e. —¿Bar anchal cuan li cui̱nk a'an? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Nabaleb li cuanqueb aran yo̱queb chixcuech'inquil rib chirix li Jesús. Cuan yo̱queb chi yehoc re: —Cha̱bil cui̱nk a'an, chanqueb. Ut cuan cui'chic yo̱queb chi yehoc: —Inc'a'. Li cui̱nk a'an naxbalak'iheb li tenamit, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Abanan ma̱ ani quia̱tinac chi cau xban nak que'xucuac chiruheb li neque'taklan sa' xya̱nkeb laj judío. ");
INSERT INTO kekNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nak ac yo̱ li nink'e li Jesús co̱ sa' li templo ut qui-oc chixch'olobanquil li xya̱lal chiruheb li cuanqueb aran. ");
INSERT INTO kekNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Que'sach xch'o̱leb li neque'taklan sa' xya̱nkeb laj judío chirabinquil li c'a'ru quixye li Jesús. Que'xye: —¿Chanru nak naxnau li cui̱nk a'in chixjunil li c'a'ak re ru a'in? A'an moco tzolbil ta, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Quixye li Jesús reheb: —Li tijleb li yo̱quin chixc'utbal ma̱cua' cue. A' li Dios li quitaklan chak cue, a'an li quic'utuc chicuu li yo̱quin chixyebal, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Li ani ta̱ajok xba̱nunquil li c'a'ru naraj li Dios, a'an tixnau ma re li Dios li tijleb li yo̱quin chixc'utbal malaj ut yal inc'a'ux injunes. ");
INSERT INTO kekNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Cui junak naxch'olob xya̱lal li naxc'oxla xjunes, li jun a'an naraj nak ta̱q'uehek' xlok'al xbaneb li neque'abin re. Abanan li ani naraj nak ta̱q'uehek' xlok'al li quitaklan chak re, li jun a'an ti̱c xch'o̱l ut ma̱c'a' balak'ic riq'uin. ");
INSERT INTO kekNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿Ma inc'a' ta bi' quixq'ue e̱re li chak'rab laj Moisés? ¿C'a'ut nak ma̱ jun sa' e̱ya̱nk naxba̱nu chi tz'akal li c'a'ru naxye li chak'rab? Ut, ¿c'a'ut nak te̱raj incamsinquil? chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Eb a'an que'chak'oc ut que'xye re: —Cuan na li ma̱us aj musik'ej a̱cuiq'uin. ¿Ani ta̱ajok a̱camsinquil? chanqueb re. ");
INSERT INTO kekNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Quixye li Jesús reheb: —La̱in xinba̱nu jun li milagro sa' li hiloba̱l cutan ut sachso e̱ch'o̱l xexcana xban. ");
INSERT INTO kekNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Laj Moisés quixye e̱re nak tento te̱ba̱nu li circuncisión reheb le̱ ralal. (Ma̱cua' laj Moisés li quitiquiban re. A' le̱ xe'to̱nil yucua', a'aneb li que'tiquiban re xba̱nunquil li circuncisión.) Usta hiloba̱l cutan, la̱ex nequeba̱nu li circuncisión. ");
INSERT INTO kekNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Cui la̱ex nequeba̱nu li circuncisión usta hiloba̱l cutan re nak inc'a' te̱k'et li chak'rab li quiq'uehe' re laj Moisés, ¿c'a'ut nak xexjosk'o' cuiq'uin nak xinq'uirtesi jun li cui̱nk sa' li hiloba̱l cutan? ");
INSERT INTO kekNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mexrakoc a̱tin jo' nequeraj la̱ex yal e̱junes. Chexrakok ban a̱tin sa' xya̱lal, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Cuanqueb aj Jerusalén que'xye: —¿Ma ma̱cua' ta bi' a'in li cui̱nk li te'raj xcamsinquil eb li neque'taklan sa' kaya̱nk la̱o aj judío? ");
INSERT INTO kekNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Q'uehomak retal. Cuan arin ut yo̱ chi a̱tinac chiruheb chixjunileb li tenamit ut ma̱c'a' neque'xye re. Ma̱re xe'xnau nak a'an li Cristo. ");
INSERT INTO kekNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","¿Chanru nak a'anak li Cristo? ¿Ma inc'a' ta bi' nakanau bar xtenamit li cui̱nk a'in? Nak ta̱cha̱lk li Cristo, ma̱ ani ta̱na'ok re chi tz'akal bar ta̱cha̱lk chak, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Nak li Jesús yo̱ chixch'olobanquil li xya̱lal sa' li templo, quixye chi cau xya̱b xcux: —Ya̱l nak nequenau cuu. Ut nequenau bar intenamit. Abanan inc'a' nequenau chi tz'akal bar xinchal chak. La̱in inc'a' xintakla chak cuib yal injunes. Li Dios, li ti̱c xch'o̱l, a'an li xtaklan chak cue. La̱ex inc'a' nequenau ru a'an. ");
INSERT INTO kekNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ca'aj cui' la̱in ninna'oc ru xban nak riq'uin a'an xinchal chak. Li Dios, a'an li quitaklan chak cue, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ut que'raj raj xchapbal re nak te'xq'ue sa' tz'alam. Abanan inc'a' ajcui' que'xchap xban nak toj ma̱ji' nacuulac xk'ehil nak ta̱chapek'. ");
INSERT INTO kekNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nabaleb li tenamit que'xpa̱b li Cristo ut que'xye: —La̱o nakanau nak ta̱c'ulu̱nk li Cristo, nabaleb li milagro tixba̱nu. Li cui̱nk a'in nabal li milagro yo̱ chixba̱nunquil. Cui ta ma̱cua' li Cristo, ¿chan ta cui' ru nak tixba̱nu li milagro li yo̱ chixba̱nunquil? ");
INSERT INTO kekNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Eb laj fariseo que'rabi li yo̱queb chixyebal chirix li Jesús. Jo'can nak eb a'an, rochbeneb li xbe̱nil aj tij, que'xtakla li neque'c'ac'alen sa' li templo chixchapbal li Jesús re te'xq'ue sa' tz'alam. ");
INSERT INTO kekNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Li Jesús quixye reheb: —Toj ma̱ji' tine̱chap. Toj tincua̱nk chic ca'ch'inak sa' e̱ya̱nk, tojo'nak tinsuk'i̱k cui'chic riq'uin li quitaklan chak cue. ");
INSERT INTO kekNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Tine̱sic' ut inc'a' tine̱tau xban nak bar cua̱nkin la̱in, la̱ex inc'a' texru̱k chi xic, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ut eb laj judío que'oc chi a̱tinac chi ribileb rib ut que'xye: —¿Bar anchal ta̱xic li cui̱nk a'in nak inc'a' ta̱ru̱k takatau? Ma̱re ta̱xic riq'uineb laj judío li cuanqueb sa' xtenamiteb laj griego. Malaj ta̱oc chixtzolbaleb laj griego. ");
INSERT INTO kekNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","A'an xye, “Tine̱sic' ut inc'a' tine̱tau. Inc'a' naru texxic bar cua̱nkin cui',” chan. ¿C'a'ru xya̱lal a'an? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Li roso'jic li nink'e, a'an li cutan li k'axal lok' chiruheb. Sa' li ho̱nal a'an, li Jesús quixakli chiruheb ut quixye chi cau xya̱b xcux: —Li ani ta̱chakik re, cha̱lk cuiq'uin. La̱in tinq'ue ruc'a. ");
INSERT INTO kekNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Xban nak jo'ca'in tz'i̱banbil retalil sa' li Santil Hu: Chixjunileb li ani te'pa̱ba̱nk cue la̱in, li Santil Musik'ej li naq'uehoc junelic yu'am ta̱cua̱nk riq'uineb. Chanchan jun li yu'am ha' li inc'a' na-oso'.— ");
INSERT INTO kekNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Nak quixye a'in, li Jesús yo̱ chi a̱tinac chirix li Santil Musik'ej li ta̱cua̱nk riq'uineb li te'pa̱ba̱nk re. Sa' li cutan a'an, li Santil Musik'ej toj ma̱ji' nac'ulun xban nak li Jesús toj ma̱ji' naxic sa' choxa chixc'ulbal lix lok'al. ");
INSERT INTO kekNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nak que'rabi li c'a'ru quixye li Jesús, cuan que'yehoc: —Relic chi ya̱l li cui̱nk a'in profeta.— ");
INSERT INTO kekNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ut cuanqueb ajcui' que'xye: —Li cui̱nk a'in, a'an li Cristo.— Abanan cuanqueb cui'chic li que'chak'oc ut que'xye: —¿Ma Galilea ta bi' ta̱cha̱lk li Cristo li yechi'inbil ke? ");
INSERT INTO kekNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tz'i̱banbil retalil sa' li Santil Hu nak li Cristo li Mesías ta̱cha̱lk sa' xya̱nkeb li ralal xc'ajol li rey David. Ta̱cha̱lk aran Belén li quicuan cui' li rey David najter, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jo'can nak li tenamit que'xjachi ribeb xban nak jalan jala̱nk yo̱queb chixc'oxlanquil chirix li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Cuanqueb li que'ajoc xchapbal li Jesús abanan inc'a' ajcui' que'xba̱nu. ");
INSERT INTO kekNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nak que'suk'i li que'takla̱c chixchapbal li Jesús, eb laj fariseo ut eb li xbe̱nil aj tij que'xpatz' reheb: —¿C'a'ut nak inc'a' xec'am chak li cui̱nk a'an? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Eb li neque'c'ac'alen sa' li templo que'chak'oc ut que'xye: —¡Ma̱ jun cua kabiom junak cui̱nk chi a̱tinac jo' naa̱tinac li cui̱nk a'an! Ch'ina'us li c'a'ru naxye, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ut eb laj fariseo que'xye reheb: —¿Ma xeq'ue ajcui' e̱rib la̱ex chixbalak'i li cui̱nk a'an? ");
INSERT INTO kekNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Ma cuan ta bi' junak xcomoneb li neque'taklan sa' kaya̱nk li xpa̱b li c'a'ru naxye a'an? Ut, ¿ma cuan ta bi' junak kacomon la̱o aj fariseo xpa̱ban re? ");
INSERT INTO kekNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Eb li q'uila tenamit a'in inc'a' neque'xnau c'a'ru naxye sa' li chak'rab li quiq'uehe' re laj Moisés. ¿C'a'ru te'oc cui' eb a'an? chanqueb laj fariseo. ");
INSERT INTO kekNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Cuan aran laj Nicodemo li quicuulac riq'uin li Jesús chi k'ek. A'an jun reheb laj fariseo. Quixye reheb: ");
INSERT INTO kekNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Naxye sa' li kachak'rab nak inc'a' naru rakoc a̱tin sa' xbe̱n junak cui̱nk chi toj ma̱ji' naxye ma cuan xma̱c malaj ut inc'a'. Tento takanau chi tz'akal c'a'ru lix ma̱c, chan laj Nicodemo. ");
INSERT INTO kekNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Que'chak'oc ut que'xye re: —¿Ma la̱at ajcui' aj Galilea la̱at? Tzol a̱cuib chi us sa' li Santil Hu re ta̱q'ue retal nak ma̱ jun profeta chalenak chak Galilea, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ut chirix chic a'an, chixjunileb que'co̱eb sa' rochocheb. ");
INSERT INTO kekNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Li Jesús co̱ sa' li tzu̱l Olivos. ");
INSERT INTO kekNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Cuulajak chic nak toj ek'ela co̱ cui'chic sa' li templo. Li q'uila tenamit que'cuulac riq'uin. Ut nak quic'ojla, qui-oc cui'chic chixch'olobanquil li xya̱lal chiruheb. ");
INSERT INTO kekNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Eb laj fariseo ut eb laj tzolol chak'rab que'xc'am riq'uin li Jesús jun li ixk yo̱ chixmuxbal ru xsumlajic nak que'xtau ut coxxe'xxakab chiruheb chixjunileb. ");
INSERT INTO kekNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Que'xye: —At tzolonel, li ixk a'in yo̱ chixmuxbal ru xsumlajic nak xkatau. ");
INSERT INTO kekNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Sa' li chak'rab li quixq'ue ke laj Moisés naxye nak cutbileb chi pec nak te'camsi̱k eb li ixk li neque'xmux ru lix sumlajic jo' xba̱nu li ixk a'in. Ut la̱at, ¿c'a'ru nacaye? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Que'xye re li Jesús chi jo'can yal re rilbal c'a' na ru tixye xban nak yo̱queb chixsic'bal c'a'ru te'xjit cui'. Aban li Jesús quixxulub rib ut qui-oc chi tz'i̱bac chiru ch'och' riq'uin ru'uj ruk'. ");
INSERT INTO kekNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ut xban nak yo̱queb chixpatz'bal, li Jesús quixakli cui'chic ut quixye reheb: —Li ani ma̱c'a' xma̱c sa' e̱ya̱nk, a'an li xbe̱n li tixcut li pec, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ut quixxulub rib ut qui-oc cui'chic chi tz'i̱bac chiru ch'och'. ");
INSERT INTO kekNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nak que'rabi li c'a'ru quixye, que'rec'a rib xban nak cuanqueb xma̱c ut que'oc chi e̱lc chi xju̱nkaleb. Xbe̱n cua que'el li che̱quel cui̱nk ut chirixeb a'an que'el li toj sa̱jeb. Quicana xjunes li Jesús ut li ixk xakxo chiru. ");
INSERT INTO kekNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Li Jesús quixakli cui'chic ut quixye re li ixk: —¿Bar cuanqueb li yo̱queb chi jitoc a̱cue? ¿Ma ma̱ ani xq'uehoc a̱cue chixtojbal a̱ma̱c? chan. ");
INSERT INTO kekNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ut li ixk quixye re: —Ma̱ jun, Ka̱cua'.— Ut li Jesús quixye re: —Chi moco la̱in tatinq'ue chixtojbal a̱ma̱c. Ayu ut matma̱cob chic, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Li Jesús quia̱tinac cui'chic riq'uineb li tenamit ut quixye reheb: —La̱in lix cutan saken li ruchich'och'. Li ani ta̱pa̱ba̱nk cue la̱in, inc'a' chic ta̱cua̱nk sa' xk'ojyi̱nal ru li ma̱c. Ta̱cua̱nk ban sa' cutan saken ut ta̱cua̱nk xyu'am chi junelic, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ut eb laj fariseo que'xye re: —Ma̱c'a' na-oc cui' li c'a'ru yo̱cat chixyebal xban nak cha̱cuix ajcui' la̱at yo̱cat chi a̱tinac, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Li Jesús quixye reheb: —Cuan xcuanquil li ninye usta yo̱quin chi a̱tinac chicuix la̱in xban nak tz'akal ya̱l li ninye. La̱ex inc'a' nequenau bar xinchal chak, chi moco nequenau bar tinxic. Ca'aj cui' la̱in ninna'oc re bar xinchal chak ut bar tinxic. ");
INSERT INTO kekNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","La̱ex nequexrakoc a̱tin jo' nequeraj la̱ex e̱junes. La̱in ma̱ ani sa' aj be̱n yo̱quin chi rakoc a̱tin. ");
INSERT INTO kekNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Abanan cui tinrakok a̱tin, tinba̱nu sa' ti̱quilal xban nak inc'a' ninrakoc a̱tin injunes. Ninba̱nu ban jo' naraj lin Yucua' li quitaklan chak cue. ");
INSERT INTO kekNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Sa' le̱ chak'rab tz'i̱banbil retalil cui cuan cuibeb li cui̱nk junaj lix c'a'uxeb riq'uin li c'a'ru te'xye, tento xpa̱banquil li ra̱tineb. ");
INSERT INTO kekNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","La̱in ninye li ya̱l chicuix ajcui' la̱in. Ut lin Yucua' li quitaklan chak cue, a'an naxch'olob ajcui' li ya̱l chicuix, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Eb laj fariseo que'chak'oc ut que'xye re: —¿Ani la̱ yucua'? chanqueb re. Li Jesús quixye reheb: —La̱ex inc'a' nequenau ani lin Yucua' xban nak inc'a' nequenau cuu la̱in. Cui ta nequenau cuu la̱in, nequenau aj raj cui' ru lin Yucua', chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Chixjunil a'in quixye li Jesús reheb nak yo̱ chixch'olobanquil li xya̱lal chiruheb li cuanqueb sa' li templo sa' li na'ajej bar neque'xq'ue cui' lix mayejeb. Ut ma̱ ani quichapoc re xban nak toj ma̱ji' nacuulac xk'ehil. ");
INSERT INTO kekNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ut li Jesús quixye cui'chic reheb: —La̱in tinxic. Tine̱sic' raj chic abanan inc'a' tine̱tau xban nak inc'a' ta̱ru̱k texxic bar tinxic cui' la̱in. Texca̱mk ban sa' le̱ ma̱c, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ut eb laj judío que'xye: —A'an xye nak inc'a' naru toxic bar ta̱xic cui' a'an. ¿C'a'ut nak xye ke chi jo'can? ¿Ma yo̱ chixc'oxlanquil xcamsinquil rib? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Li Jesús quixye reheb: —La̱ex aj ruchich'och'. Abanan la̱in ma̱cua'in aj ruchich'och'. La̱in sa' choxa xinchal chak. ");
INSERT INTO kekNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Jo'can nak xinye e̱re nak texca̱mk sa' le̱ ma̱c. La̱ex texca̱mk sa' le̱ ma̱c cui inc'a' nequepa̱b nak la̱in ac cuanquin ajcui' chak sa' xticlajic jo' xinye e̱re, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ut eb a'an que'xye re: —Ye ke. ¿Anihat tz'akal la̱at? chanqueb. Li Jesús quixye reheb: —Chalen sa' xticlajic quinye chak e̱re anihin la̱in. ");
INSERT INTO kekNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nabal li c'a'ak re ru naru tinye raj e̱re re xrakbal a̱tin sa' e̱be̱n. Li ani quitaklan chak cue, a'an ti̱c xch'o̱l ut naxye li ya̱l. Li c'a'ru xc'ut chicuu li quitaklan chak cue, a'an li ninye e̱re la̱ex li cuanquex sa' ruchich'och', chan. ");
INSERT INTO kekNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Abanan eb a'an inc'a' que'xtau ru nak li Jesús yo̱ chi a̱tinac chirix li Acuabej Dios. ");
INSERT INTO kekNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ut quixye ajcui' li Jesús reheb: —Nak acak xine̱taksi chiru li cruz re incamsinquil toj aran te̱q'ue retal nak la̱in li taklanbilin chak xban li Dios. Ut te̱nau nak ma̱c'a' ninba̱nu injunes. Li c'a'ru ninye la̱in, a'an li quixc'utbesi chicuu lin Yucua'. ");
INSERT INTO kekNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Li ani quitaklan chak cue, a'an cuan cuiq'uin. A'an inc'a' quinixcanab injunes xban nak la̱in junelic ninba̱nu li c'a'ru naraj a'an, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nabaleb que'pa̱ban re li Jesús nak que'rabi li c'a'ru quixye. ");
INSERT INTO kekNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Li Jesús quia̱tinac riq'uineb laj judío li que'pa̱ban re. Quixye reheb: —Cui la̱ex te̱ba̱nu li c'a'ru ninye e̱re, la̱exak tz'akal intzolom. ");
INSERT INTO kekNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Te̱nau chic li xya̱lal. Ut nak acak xenau chic li xya̱lal, libre chic cua̱nkex, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Eb a'an que'chak'oc ut que'xye: —La̱o ralal xc'ajol laj Abraham. Ma̱ jun cua c'ayinbilo chi c'anjelac chiru anihak. ¿C'a'ut nak nacaye nak libre chic cua̱nko? ");
INSERT INTO kekNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Li Jesús quixye reheb: —Relic chi ya̱l ninye e̱re nak chixjunileb li neque'xba̱nu li ma̱usilal cuanqueb rubel xcuanquil li ma̱c. Chanchan nak c'ayinbileb chi c'anjelac chiru. ");
INSERT INTO kekNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Junak c'ayinbil chi c'anjelac moco ta̱cana̱k ta chi junaj cua sa' rochoch lix patrón. A'ut li alalbej, a'an tento nak ta̱cana̱k sa' rochoch chi junaj cua. ");
INSERT INTO kekNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Jo'can nak cui la̱in li C'ajolbej tincolok e̱re chiru li ma̱c, relic chi ya̱l libre chic cua̱nkex. ");
INSERT INTO kekNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","La̱in ninnau nak la̱ex xcomonex li ralal xc'ajol laj Abraham. Abanan cuan sa' e̱ya̱nk li te'raj incamsinquil xban nak inc'a' nacuulac chiruheb li c'a'ru yo̱quin chixyebal. ");
INSERT INTO kekNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","La̱in ninye li c'a'ru quixc'ut chicuu lin Yucua'. Ut eb a'an neque'xba̱nu li c'a'ru quixye reheb lix yucua'eb a'an, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Eb a'an que'xye re: —Laj Abraham, a'an li kaxe'to̱nil yucua', chanqueb. Li Jesús quixye reheb: —Cui ta la̱ex ralal xc'ajol laj Abraham, te̱ba̱nu raj jo' quixba̱nu laj Abraham. Cha̱bil raj le̱ na'leb jo' xna'leb a'an nak quicuan. ");
INSERT INTO kekNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Abanan la̱ex te̱raj incamsinquil xban nak la̱in xinye e̱re li xya̱lal jo' quic'utbesi̱c chicuu xban li Dios Acuabej. Laj Abraham inc'a' quixba̱nu jo' yo̱quex la̱ex. ");
INSERT INTO kekNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Inc'a' yo̱quex chixba̱nunquil li quixye laj Abraham. Yo̱quex ban chixba̱nunquil li naxye le̱ yucua', chan li Jesús. Eb a'an que'chak'oc ut que'xye re: —Moco la̱o ta ralal xc'ajol laj co'be̱t. Jun ajcui' li kayucua' cuan. A'an li Dios, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Li Jesús quixye reheb: —Cui ta ya̱l nak li Dios e̱yucua', niquine̱ra raj la̱in xban nak riq'uin li Dios quinchal chak. Cuanquin arin sa' e̱ya̱nk. Inc'a' quintakla chak cuib injunes. A' li Dios, a'an li quitaklan chak cue. ");
INSERT INTO kekNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿C'a'ut nak inc'a' nequetau ru li c'a'ru ninye? Inc'a' nequec'ul li cua̱tin xban nak inc'a' nequeraj rabinquil li c'a'ru yo̱quin chixyebal. ");
INSERT INTO kekNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","La̱ex ralal xc'ajol laj tza. A'an li nataklan sa' e̱be̱n. La̱ex nequeba̱nu li c'a'ru naraj a'an xban nak cuanquex rubel xcuanquil. A'an aj camsinel chalen sa' xticlajic. Inc'a' nacuulac chiru li ya̱l xban nak a'an aj tic'ti'. Ac re nak natic'ti'ic. A'an li xyucua'il li tic'ti'. ");
INSERT INTO kekNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","La̱in ninye e̱re li xya̱lal. Jo'can nak inc'a' niquine̱pa̱b. ");
INSERT INTO kekNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Ma cuan junak sa' e̱ya̱nk ta̱ru̱k tixye nak cuan inma̱c la̱in? Cui ninye li ya̱l, ¿c'a'ut nak inc'a' niquine̱pa̱b? ");
INSERT INTO kekNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Cui ta la̱ex ralal xc'ajol li Dios, nequepa̱b raj li c'a'ru naxye. Abanan la̱ex ma̱cua'ex ralal xc'ajol li Dios. Jo'can nak inc'a' nequeraj rabinquil li c'a'ru naxye, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Que'chak'oc eb laj judío ut que'xye re: —Ya̱l ajcui' nacaye. Samaria la̱ tenamit ut cuan ma̱us aj musik'ej a̱cuiq'uin, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Li Jesús quixye reheb: —Ma̱c'a' ma̱us aj musik'ej cuiq'uin. Li c'a'ru yo̱quin chixba̱nunquil la̱in, a'an xq'uebal xlok'al lin Yucua'. Abanan la̱ex niquine̱tz'ekta̱na. ");
INSERT INTO kekNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","La̱in inc'a' ninsic' inlok'al. Abanan cuan jun naraj nak ta̱q'uehek' inlok'al. Ut a'an li ta̱rakok a̱tin sa' e̱be̱n xban nak yo̱quex chintz'ekta̱nanquil. ");
INSERT INTO kekNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Relic chi ya̱l ninye e̱re nak li ani tixba̱nu li c'a'ru ninye, li jun a'an inc'a' ta̱ca̱mk, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Eb laj judío que'chak'oc ut que'xye: —Anakcuan nakanau chi tz'akal nak cuan ma̱us aj musik'ej a̱cuiq'uin. Laj Abraham quicam ut que'cam ajcui' eb li profeta. Abanan la̱at nacaye nak li ani ta̱ba̱nu̱nk re li c'a'ru nacaye inc'a' ta̱ca̱mk. ");
INSERT INTO kekNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Ma k'axal nim ta bi' a̱cuanquil la̱at chiru laj Abraham li kaxe'to̱nil yucua'? A'an quicam ut que'cam ajcui' li profeta. ¿Anihat la̱at nak nacaye chi jo'can? chanqueb re. ");
INSERT INTO kekNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Li Jesús quixye reheb: —Cui la̱in tinq'ue inlok'al injunes, ma̱c'a' na-oc cui' lin lok'al. Li naq'uehoc lin lok'al, a'an lin Yucua' li nequeye la̱ex nak a'an le̱ Dios. ");
INSERT INTO kekNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","La̱ex inc'a' nequenau ru a'an. Abanan la̱in ninnau ru. Cui ut tinye ta nak inc'a' ninnau ru, la̱inak raj aj tic'ti' jo' la̱ex. Aban la̱in ninnau ru ut ninba̱nu li c'a'ru naxye a'an. ");
INSERT INTO kekNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Laj Abraham le̱ xe'to̱nil yucua' quisaho' sa' xch'o̱l nak tincha̱lk sa' ruchich'och'. Quiril nak quinc'ulun ut quisaho' sa' xch'o̱l xban, chan li Jesús reheb. ");
INSERT INTO kekNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Eb a'an que'xye re: —¿Chanru nak xacuil ru laj Abraham? La̱at toj ma̱ji' nacaba̱nu laje̱b roxc'a̱l (50) chihab, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Li Jesús quichak'oc ut quixye reheb: —Relic chi ya̱l tinye e̱re nak chalen chak sa' xticlajic nak toj ma̱ji' nayo'la laj Abraham, ac cuanquin ajcui' chak la̱in, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","C'ajo' nak que'josk'o' ut que'oc raj chixcutinquil chi pec. Abanan li Jesús quixmuk rib chiruheb. Qui-el sa' li templo ut co̱. ");
INSERT INTO kekNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Nak yo̱ chi xic li Jesús, quiril jun li cui̱nk mutz' ru chalen sa' xyo'lajic. ");
INSERT INTO kekNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Eb lix tzolom li Jesús que'xpatz' re: —At tzolonel, ¿c'a'ut nak mutz' ru li cui̱nk a'in? ¿Ani cuan xma̱c? ¿Ma li cui̱nk a'in malaj ut lix na' xyucua'? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Li Jesús quixye: —Ma̱ ani cuan xma̱c. Chi moco a'an, chi moco lix na' xyucua'. A'an xc'ul chi jo'can yal re nak ta̱c'utbesi̱k lix cuanquilal li Dios, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tento nak tinse̱ba cuib chixba̱nunquil li c'a'ru naraj li Dios li xtaklan chak cue. Anakcuan xcutanquil xba̱nunquil xban nak ta̱cuulak xk'ehil nak ma̱ ani chic ta̱ru̱k ta̱c'anjelak. ");
INSERT INTO kekNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nak toj cua̱nkin sa' ruchich'och', la̱in tincutanobresi lix c'a'uxeb li cuanqueb sa' ruchich'och', chan. ");
INSERT INTO kekNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nak ac xye a'in, li Jesús quichu̱bac sa' ch'och'. Riq'uin lix chu̱b quixyi̱b li sulul. Ut quixyul sa' rix ru li mutz'. ");
INSERT INTO kekNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ut quixye re: —Ayu. Ch'aj chak la̱ cuu sa' li ha' Siloé, chan. Siloé naraj naxye “taklanbil chak”. Li mutz' co̱ ut quixch'aj chak li ru ut na-iloc chic nak quisuk'i chak. ");
INSERT INTO kekNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ut eb li rech cabal ut chixjunileb li neque'na'oc nak mutz' ru, que'xye: —¿Ma ma̱cua' ta bi' a'an li nac'ojla chire be chixtz'a̱manquil c'a'ru re? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ut cuan li que'yehoc: —Ya̱l. A'an li cui̱nk, chanqueb. Cuan cui'chic li que'xye: —Chanchan a'an, aban ma̱cua', chanqueb. Ut li cui̱nk quixye: —La̱in li cui̱nk a'an, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ut que'xye re: —Cui la̱at li cui̱nk a'an, ¿chanru nak xtehon li xnak' a̱cuu? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Quichak'oc li cui̱nk ut quixye reheb: —Li cui̱nk Jesús xc'aba', quixyi̱b li sulul. Quixyul sa' rix cuu ut quixye cue nak tinxic chi ch'ajoc sa' li ha' Siloé. Jo'can nak co̱in ut quinch'aj li cuu ut anakcuan nin-iloc chic, chan li cui̱nk. ");
INSERT INTO kekNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ut que'xye re: —¿Bar cuan li cui̱nk a'an? chanqueb. Ut li cui̱nk quixye reheb: —Inc'a' ninnau bar cuan, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ut que'xc'am riq'uineb laj fariseo li cui̱nk li mutz' nak quicuan, ");
INSERT INTO kekNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","xban nak li Jesús quixyi̱b li sulul sa' li hiloba̱l cutan ut quixq'ue chi iloc li mutz'. ");
INSERT INTO kekNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ut eb laj fariseo que'xpatz' cui'chic re li cui̱nk chanru nak quiteli li xnak' ru. Li cui̱nk quixye reheb: —Li Jesús quixq'ue li sulul sa' rix cuu, ut quinch'aj li cuu ut anakcuan nin-iloc chic, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Cuanqueb laj fariseo que'xye: —Li cui̱nk a'an, li Jesús xc'aba', moco taklanbil ta chak xban li Dios xban nak inc'a' naxq'ue xlok'al li hiloba̱l cutan, chanqueb. Ut cuanqueb cui'chic que'yehoc re: —¿Chanru nak tixba̱nu li milagro junak cui̱nk aj ma̱c? chanqueb. Xban nak jalan jala̱nk neque'xc'oxla chirix li Jesús, inc'a' chic junajeb xch'o̱leb. ");
INSERT INTO kekNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Jo'can nak eb laj fariseo que'xpatz' cui'chic re li cui̱nk, li mutz' nak quicuan. Que'xye re: —Ut la̱at, ¿c'a'ru nacaye chirix li cui̱nk a'in li xq'uehoc a̱cue chi iloc? chanqueb re. Ut li cui̱nk quixye reheb: —La̱in ninye nak a'an profeta, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ut eb laj judío li neque'taklan inc'a' que'raj xpa̱banquil nak li cui̱nk mutz' junxil ut na-iloc chic. Jo'can nak que'xtakla xbokbal lix na' xyucua'. ");
INSERT INTO kekNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ut que'xpatz' reheb: —¿Ma a'in le̱ ralal? ¿Ma ya̱l nak mutz' li ru chalen sa' xyo'lajic? ¿Chanru nak na-iloc chic anakcuan? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Que'chak'oc lix na' xyucua' ut que'xye: —La̱o nakanau nak a'an li kalal. Ut nakanau nak a'an mutz' chalen sa' xyo'lajic. ");
INSERT INTO kekNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Abanan inc'a' nakanau ani xtehoc li ru chi moco nakanau chanru nak na-iloc chic. Patz'omak re a'an. Ac cuan xchihab. Tixnau chic xsumenquil a'an, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Que'xye chi jo'can lix na' xyucua' xban nak que'xucuac xbaneb li neque'taklan sa' xya̱nkeb laj judío xban nak ac c'u̱banbil ru xbaneb cui ani tixye nak li Jesús, a'an li Cristo, li jun a'an inc'a' chic ta̱c'ulek' sa' li cab li neque'xch'utub cui' ribeb laj judío. ");
INSERT INTO kekNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Jo'can nak lix na' xyucua' que'xye: —A'an ac cuan xchihab. Patz'omak re a'an.— ");
INSERT INTO kekNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Eb laj fariseo que'xbok cui'chic xca' sut li cui̱nk, li mutz' nak quicuan, ut que'xye re: —Sa' xc'aba' li Dios ta̱ye ke li xya̱lal. La̱o nakanau nak li cui̱nk a'an aj ma̱c, chanqueb re. ");
INSERT INTO kekNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Li cui̱nk, li mutz' nak quicuan, quixye reheb: —La̱in inc'a' ninnau ma aj ma̱c malaj ut inc'a'. Ca'aj cui' li ninnau la̱in nak mutz'in nak xincuan ut anakcuan nin-iloc chic, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ut que'xye cui'chic re: —¿C'a'ru xba̱nu a̱cue? ¿Chanru nak xatxq'ue chi iloc? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Li cui̱nk quixye reheb: —Ac xinye e̱re chanru xba̱nu nak xinixq'ue chi iloc ut inc'a' xeraj xpa̱banquil. ¿C'a'ut nak te̱raj te̱rabi cui'chic? ¿Ma te̱raj ajcui' oc chok' xtzolom la̱ex? chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ut que'xhob li cui̱nk ut que'xye re: —La̱at xtzolom li cui̱nk a'an. La̱o inc'a'. La̱o xtzolom laj Moisés, chanqueb re. ");
INSERT INTO kekNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","—La̱o nakanau nak li Dios quia̱tinac riq'uin laj Moisés; abanan li cui̱nk a'an inc'a' nakanau bar xchal chak, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Li cui̱nk quixye reheb: —La̱ex nequeye nak inc'a' nequenau bar xchal chak li cui̱nk a'an. Nasach inch'o̱l e̱ban xban nak li cui̱nk a'an xq'uehoc cue chi iloc la̱in. ");
INSERT INTO kekNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","La̱o nakanau nak li Dios inc'a' narabi nak neque'tijoc laj ma̱c. Narabi ban lix tijeb li neque'xxucua ru ut neque'xba̱nu li c'a'ru naraj. ");
INSERT INTO kekNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Chalen chak sa' xticlajic li ruchich'och', ma̱ jun sut qui-abiman nak cuan ta junak cui̱nk tixte ta xnak' ru junak mutz' chalen sa' xyo'lajic. ");
INSERT INTO kekNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Cui ta inc'a' taklanbil chak xban li Dios li cui̱nk a'in, ma̱c'a' raj naru naxba̱nu, chan li cui̱nk reheb. ");
INSERT INTO kekNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Eb a'an que'chak'oc ut que'xye re: —La̱at aj ma̱c chalen chak sa' a̱yo'lajic. ¿Ma nacac'oxla nak naru ta̱q'ue kana'leb la̱o? chanqueb. Ut que'risi li cui̱nk sa' xya̱nkeb ut inc'a' chic que'xc'ul. ");
INSERT INTO kekNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Li Jesús quirabi resil li c'a'ru que'xba̱nu. Nak quixtau li cui̱nk li quixq'uirtesi, quixye re: —¿Ma nacapa̱b li Ralal li Dios? chan re. ");
INSERT INTO kekNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Li cui̱nk quixye re: —Ye cue ani a'an, Ka̱cua', re nak ta̱ru̱k tinpa̱b la̱in, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Li Jesús quixye re: —A'an li yo̱cat chirilbal ru anakcuan. Li Ralal li Dios, a'an la̱in li yo̱quin chi a̱tinac a̱cuiq'uin, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Li cui̱nk quixye: —At Ka̱cua', la̱in nacatinpa̱b, chan ut quixcuik'ib rib chiru ut quixlok'oni. ");
INSERT INTO kekNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Li Jesús quixye re: —La̱in xinchal sa' ruchich'och' chi rakoc a̱tin. La̱in tincutanobresi xna'lebeb li inc'a' neque'xtau xya̱lal. Ut tinmuk li xya̱lal chiruheb li neque'xc'oxla nak cuanqueb xna'leb. Chanchan nak tinq'ueheb chi iloc li inc'a' neque'iloc. Ut tinq'ueheb chi mutz'oc' li neque'iloc, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Cuanqueb laj fariseo aran ut yo̱queb chirabinquil li quixye li Jesús. Eb a'an que'xye re li Jesús: —¿Ma mutz'o' ta bi' la̱o nak nacac'oxla la̱at? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Li Jesús quixye reheb: —Chanchanex mutz'. Cui ta la̱ex inc'a' nequenau xya̱lal, ma̱c'a' raj e̱ma̱c. Abanan cuan e̱ma̱c xban nak nequeye nak nequenau xya̱lal, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Relic chi ya̱l tinye e̱re, li ani na-oc sa' xcorraleb li carner chi inc'a' na-oc sa' li tz'akal oqueba̱l re li corral, li jun a'an aj e̱lk'. ");
INSERT INTO kekNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Abanan li ani na-oc sa' li tz'akal oqueba̱l re li corral, li jun a'an aj ilol reheb li carner. ");
INSERT INTO kekNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Li nac'ac'alen re li oqueba̱l naxnau ru a'an ut naxte li oqueba̱l chiru. Ut eb li carner neque'xnau ru li xya̱b xcux nak naxbokeb chi xju̱nkaleb riq'uin lix c'aba'eb ut narisiheb sa' li corral. ");
INSERT INTO kekNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nak ac xrisiheb, naxberesiheb ut eb li carner neque'xta̱ke xban nak neque'xnau ru xya̱b lix cux. ");
INSERT INTO kekNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Abanan junak li inc'a' neque'xnau ru, ma̱ jok'e te'xta̱ke. E̱lelic ban chic te'xba̱nu chiru xban nak inc'a' neque'xnau ru xya̱b lix cux, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","A'an a'in li jaljo̱quil ru a̱tin li quixye li Jesús reheb. Abanan inc'a' que'xtau ru lix ya̱lal. ");
INSERT INTO kekNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jo'can nak li Jesús quixye cui'chic reheb: —Relic chi ya̱l ninye e̱re, La̱in li oqueba̱l reheb li te'pa̱ba̱nk cue. ");
INSERT INTO kekNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Chixjunileb li que'c'ulun xbe̱n cua chicuu la̱in, a'aneb aj e̱lk'eb ut aj balak'eb. Ut eb li neque'pa̱ban cue, inc'a' neque'xpa̱b li c'a'ru neque'xye. ");
INSERT INTO kekNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","La̱in li oqueba̱l. Chixjunileb li neque'pa̱ban cue la̱in, te'colek' ut la̱in tin-ilok reheb. Chanchaneb li carner li neque'oc ut neque'el ut neque'xtau lix cuaheb. ");
INSERT INTO kekNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Laj e̱lk' nachal chi elk'ac ut chi camsi̱nc ut chi sachoc. La̱in xinchal re nak ta̱cua̱nk e̱yu'am chi tz'akal. Ta̱cua̱nk e̱yu'am chi junelic. ");
INSERT INTO kekNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","La̱in chanchanin jun li cha̱bil pastor. Junak cha̱bil pastor naxk'axtesi lix yu'am sa' xc'aba'eb lix carner. ");
INSERT INTO kekNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Junak tojbil mo̱s ma̱cua' tz'akal pastor xban nak ma̱cua' a'an laj e̱chal re li carner. Naril nak yo̱ chi cha̱lc laj xoj, naxcanabeb li carner ut nae̱lelic. Ut laj xoj naxchapeb li carner ut naxcha'cha'i ruheb. ");
INSERT INTO kekNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Li tojbil mo̱s nae̱lelic xban nak yal mo̱s. A'an inc'a' naxq'ue xch'o̱l chixcolbaleb li carner. ");
INSERT INTO kekNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","La̱in chanchanin jun cha̱bil pastor. La̱in ninnau ruheb li cualal inc'ajol. Ut eb a'an neque'xnau cuu la̱in. ");
INSERT INTO kekNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Jo' nak lin yucua' naxnau cuu la̱in, jo'can ajcui' nak ninnau ru lin yucua' ut tink'axtesi cuib chi camsi̱c re xcolbaleb li cualal inc'ajol. ");
INSERT INTO kekNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Cuanqueb ajcui' cualal inc'ajol jalaneb xtenamiteb. Tento nak la̱in tinc'ameb chak. Eb a'an te'rabi ajcui' xya̱b lin cux. Ut junajakeb chic ru nak te'cua̱nk ut junak ajcui' laj ilol reheb. ");
INSERT INTO kekNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ninxra li Yucua'bej xban nak la̱in tink'axtesi cuib chi camsi̱c ut tinc'ul cui'chic lin yu'am. ");
INSERT INTO kekNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ma̱ ani ta̱q'uehok cue chi camsi̱c cui inc'a' nacuaj la̱in. Xban nak la̱in nacuaj, tink'axtesi cuib chi camsi̱c. Cuan incuanquil chixk'axtesinquil lin yu'am. Ut cuan ajcui' incuanquil chixc'ulbal cui'chic lin yu'am. A'an a'in li quixye cue lin Yucua' nak tento tinba̱nu, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ut xban nak jalan jala̱nk yo̱queb chixc'oxlanquil chirix li quixye li Jesús, quicuan cui'chic jachoc ib sa' xya̱nkeb. ");
INSERT INTO kekNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Nabaleb que'yehoc re: —Cuan ma̱us aj musik'ej riq'uin. Inc'a' tuktu xjolom. ¿C'a'ut nak nequerabi li c'a'ru naxye a'an? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ut cuanqueb cui'chic yo̱queb xyebal: —Inc'a' naru ta̱a̱tinak chi jo'can cui cuan ma̱us aj musik'ej riq'uin. ¿Ma ta̱ru̱k ta bi' tixq'ue chi iloc junak mutz' cui cuan ma̱us aj musik'ej riq'uin? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yo̱ li habalk'e aran Jerusalén nak quicuulac xk'ehil li nink'e re xjulticanquil nak que'xk'axtesi li templo sa' ruk' li Ka̱cua' Dios. ");
INSERT INTO kekNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ut li Jesús yo̱ chi be̱c sa' li templo bar cuan cui' li oqueba̱l Salomón xc'aba'. ");
INSERT INTO kekNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Quisute' xbaneb laj judío ut que'xye re: —¿Jok'e ta̱ye ke chi tz'akal anihat? ¿Ma yal yo̱kat chixq'uebal kac'a'ux? ¿Ma la̱at li Mesías, li yechi'inbil xban li Dios? Cui la̱at li Cristo, ye ke chi tz'akal anakcuan, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Li Jesús quixye reheb: —Ac xinye e̱re anihin ut inc'a' niquine̱pa̱b. Li milagros li yo̱quin chixba̱nunquil sa' xc'aba' lin Yucua', a'an naxc'ut chi tz'akal anihin. ");
INSERT INTO kekNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","La̱ex inc'a' niquine̱pa̱b xban nak la̱ex ma̱cua'ex cualal inc'ajol. ");
INSERT INTO kekNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Eb li cualal inc'ajol neque'rabi li c'a'ru ninye. La̱in ninnauheb ru ut eb a'an neque'xba̱nu li c'a'ru ninye. ");
INSERT INTO kekNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","La̱in tinq'ueheb xyu'am chi junelic. Inc'a' te'osok' ut ma̱ ani ta̱ru̱k ta̱mak'ok reheb chicuu. ");
INSERT INTO kekNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Lin Yucua' li k'axal nim xcuanquil chiruheb chixjunil, a'an li quik'axtesin reheb sa' cuuk'. Ma̱ ani naru ta̱mak'ok reheb chiru a'an. ");
INSERT INTO kekNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","La̱in ut li Yucua'bej junajo chi kibil kib, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ut eb laj judío que'xchap xpequeb ut que'raj cui'chic xcutbal chi pec. ");
INSERT INTO kekNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Li Jesús quixye reheb: —Nabal li cha̱bilal xinba̱nu che̱ru jo' quic'utbesi̱c chicuu xban lin Yucua'. ¿Bar cuan reheb li cha̱bil c'anjel a'in li xinba̱nu tine̱cuti cui' chi pec? chan. ");
INSERT INTO kekNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Eb a'an que'chak'oc ut que'xye: —Inc'a' tatkacut chi pec xban li cha̱bilal xaba̱nu. Tatkacut chi pec xban nak nacajuntak'e̱ta a̱cuib riq'uin li Dios. La̱at yal cui̱nkat. Moco Diosat ta jo' yo̱cat chixyebal, chanqueb re li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Li Jesús quixye reheb: —¿Ma inc'a' ta bi' tz'i̱banbil retalil sa' le̱ chak'rab nak li Dios quixye reheb li que'c'uluc re li ra̱tin “diosex la̱ex”? (Sal. 82:6) ");
INSERT INTO kekNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nakanau nak inc'a' naru takaye nak inc'a' ya̱l li tz'i̱banbil sa' li Santil Hu. Li Dios quixye “dios” reheb li quixxakab. ");
INSERT INTO kekNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Li Acuabej Dios xsic'oc cuu ut xinixtakla chak sa' ruchich'och'. ¿C'a'ut nak nequeye la̱ex nak yo̱quin chixmajecuanquil li Dios riq'uin nak ninye nak la̱in li Ralal? ");
INSERT INTO kekNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Cui la̱in inc'a' yo̱quin chixba̱nunquil li c'a'ru naraj lin Yucua', me̱pa̱b nak la̱in li Ralal li Dios. ");
INSERT INTO kekNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Abanan cui yo̱quin chixba̱nunquil li c'a'ru naraj li Dios, usta inc'a' niquine̱pa̱b la̱in, cheq'ue retal li milagro li yo̱quin chixba̱nunquil re nak te̱nau chi tz'akal nak li Dios cuan cuiq'uin ut la̱in cuanquin riq'uin a'an, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ut que'xyal cui'chic xchapbal, abanan li Jesús qui-el chiruheb. ");
INSERT INTO kekNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ut co̱ jun pac'al li nima' Jordán sa' li na'ajej li quicubsin cui' ha' laj Juan junxil. Ut aran quicana. ");
INSERT INTO kekNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nabaleb li tenamit que'cuulac riq'uin. Yo̱queb chixyebal chi ribileb rib: —Laj Juan ma̱ jun milagro quixba̱nu. Abanan ya̱l chixjunil li quixye chirix li cui̱nk a'in, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ut nabaleb li cuanqueb aran que'xpa̱b li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Jun li cui̱nk aj Lázaro xc'aba' quiyajer. Betania xtenamit. Ut aran ajcui' cuanqueb li ranab cuib, lix Marta ut lix María. ");
INSERT INTO kekNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Lix María, a'an li quiq'uehoc re li sununquil ban chiru rok li Jesús ut quixmes riq'uin rismal xjolom.) ");
INSERT INTO kekNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Eb li ranab que'xtakla xyebal re li Jesús: —Ka̱cua', laj Lázaro li nacara yaj. ");
INSERT INTO kekNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Li Jesús quirabi nak yaj laj Lázaro, ut quixye: —Laj Lázaro inc'a' ta̱ca̱mk chi junaj cua xban li yajel a'an. Li yajel a'an yal re nak ta̱q'uehek' xlok'al li Dios ut ta̱q'uehek' ajcui' inlok'al la̱in li Ralal li Dios, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Li Jesús naxraheb lix María ut lix Marta jo' ajcui' laj Lázaro. ");
INSERT INTO kekNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Abanan inc'a' co̱ chirilbal chi junpa̱t, usta quirabi nak nim xyajel laj Lázaro. Toj quicana ban cuib cutan chic sa' li na'ajej li cuan cui'. ");
INSERT INTO kekNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nak ac xnume' li cuib cutan, li Jesús quixye reheb lix tzolom: —Yo'keb cui'chic Judea, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Lix tzolom que'chak'oc ut que'xye: —At tzolonel, nak cuanco aran, eb laj judío li cuanqueb aran que'raj raj a̱camsinquil chi pec. ¿Ma toxic cui'chic aran? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Li Jesús quixye reheb: —¿Ma inc'a' ta bi' cablaju o̱r ru li jun cutan? Li ani nabe̱c chi cutan inc'a' naxtich rib xban nak cutan. ");
INSERT INTO kekNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Abanan li ani nabe̱c chiru k'ojyi̱n, naxtich rib xban nak ma̱c'a' li cutan saken riq'uin. Li ani naxba̱nu jo' naraj li Dios inc'a' te'xcamsi chi toj ma̱ji' nacuulac xk'ehil. ");
INSERT INTO kekNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nak ac xye a'in, li Jesús quixye reheb lix tzolom: —Laj Lázaro li nakara, yo̱ chi cua̱rc. Abanan la̱in xic cue chirajsinquil, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Eb lix tzolom que'xye: —Ka̱cua', cui yo̱ chi cua̱rc, a'an retalil nak ta̱q'uira̱k, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Eb a'an inc'a' que'xtau ru nak li Jesús quixye nak camenak chic laj Lázaro. Sa' xch'o̱leb a'an nak ya̱l nak yal cua̱rc yo̱. ");
INSERT INTO kekNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tojo'nak li Jesús quixye chi tz'akal reheb: —Laj Lázaro camenak chic. ");
INSERT INTO kekNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Abanan nasaho' sa' inch'o̱l nak ma̱ anihin chak aran nak xcam re nak la̱ex te̱pa̱b nak cuan incuanquil. Yo̱keb riq'uin, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Laj Tomás, li neque'xye lut re, quixye reheb li rech aj tzolonelil: —Yo'keb ajcui' la̱o usta tocamsi̱k kochben laj tzolonel, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nak quicuulac li Jesús aran Betania, ac cuan chic ca̱hib cutan xmukbal laj Lázaro. ");
INSERT INTO kekNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Li tenamit Betania nach' cuan riq'uin Jerusalén, mero legua tana xnajtil. ");
INSERT INTO kekNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Nabaleb laj judío que'chal chixc'ojobanquil xch'o̱leb lix María ut lix Marta xban nak ac xcam li raseb. ");
INSERT INTO kekNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Que'rabi nak yo̱ chi cha̱lc li Jesús, ut lix Marta co̱ chixc'ulbal. Abanan lix María quicana sa' cab. ");
INSERT INTO kekNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Lix Marta quixye re li Jesús: —Ka̱cua', cui ta cuancat arin, inc'a' raj xcam li cuas. ");
INSERT INTO kekNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Abanan la̱in ninnau nak chixjunil li c'a'ru ta̱tz'a̱ma chiru li Dios, a'an tixq'ue a̱cue, chan lix Marta. ");
INSERT INTO kekNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Li Jesús quixye re: —La̱ cuas ta̱cuacli̱k cui'chic chi yo'yo, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ut lix Marta quixye: —La̱in ninnau nak ta̱cuacli̱k cui'chic chi yo'yo nak te'cuacli̱k li camenak sa' roso'jiqueb li cutan, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ut li Jesús quixye re: —La̱in li nincuaclesin reheb li camenak chi yo'yo. La̱in li ninq'uehoc junelic yu'am. Li ani napa̱ban cue la̱in ta̱cua̱nk xyu'am chi junelic usta nacam. ");
INSERT INTO kekNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ut li ani cuan xyu'am ut niquinixpa̱b, inc'a' ta̱ca̱mk chi junaj cua. Cua̱nk ban xyu'am chi junelic. ¿Ma nacapa̱b a'in? chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Quichak'oc lix Marta ut quixye: —Ninpa̱b, Ka̱cua'. La̱in ninnau nak la̱at li Cristo li Ralal li Dios li yo̱co chiroybeninquil, chan lix Marta. ");
INSERT INTO kekNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nak ac xye a'in, lix Marta co̱ sa' rochoch chixbokbal lix María li ri̱tz'in. Ut quixye re chi timil re nak inc'a' te'rabi chixjunileb: —Xc'ulun laj tzolonel ut ta̱raj a̱tinac a̱cuiq'uin, chan re. ");
INSERT INTO kekNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nak lix María quirabi nak ac xc'ulun li Jesús, co̱ sa' junpa̱t chixc'ulbal. ");
INSERT INTO kekNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Li Jesús toj ma̱ji' na-oc sa' li tenamit. Toj cuan chak sa' li na'ajej bar quic'ule' cui' xban lix Marta. ");
INSERT INTO kekNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Nabaleb laj judío li cuanqueb sa' li rochoch yo̱queb chixc'ojobanquil xch'o̱l lix María. Que'ril nak co̱ sa' junpa̱t. Que'xta̱ke xban nak eb a'an que'xc'oxla nak lix María co̱ chi ya̱bac sa' li mukleba̱l. ");
INSERT INTO kekNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Lix María quicuulac cuan cui' li Jesús. Nak quiril ru, quixcuik'ib rib chiru ut quixye re: —Ka̱cua', cui ta cuancat arin, inc'a' raj xcam li cuas, chan re. ");
INSERT INTO kekNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Li Jesús quiril nak yo̱ chi ya̱bac ut yo̱queb ajcui' chi ya̱bac li cuanqueb rochben. C'ajo' nak quiyot'e' xch'o̱l chi rilbal. ");
INSERT INTO kekNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ut quixye reheb: —¿Bar xemuk?— Que'xye re: —Yo'o re ta̱cuil bar xkamuk, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ut li Jesús quiya̱bac xban xrahil xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Cuanqueb aran que'xye: —Ilomak c'ajo' nak quixra li camenak, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ut cuanqueb cui'chic li que'xye: —A'an quixq'ue chi iloc li mutz'. ¿Ma inc'a' raj xru quixcol laj Lázaro chiru li ca̱mc? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ut quiyot'e' cui'chic xch'o̱l li Jesús. Co̱ aran cuan cui' li mukleba̱l yi̱banbil sa' jun ochoch pec. Li mukleba̱l tz'aptz'o riq'uin jun nimla pec. ");
INSERT INTO kekNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Quixye li Jesús: —Isihomak li pec.— Lix Marta, li ranab li camenak quixye re: —Ka̱cua', ac xchuho'. Cuan chic ca̱hib cutan xmukbal, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Quixye li Jesús re: —¿Ma inc'a' xinye a̱cue nak cui ta̱pa̱b, ta̱cuil xcuanquilal li Dios? chan. ");
INSERT INTO kekNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ut que'risi li pec chire li mukleba̱l li que'xq'ue cui' li camenak. Li Jesús qui-iloc takec' ut quitijoc. Quixye: —At inYucua', ninbantioxi cha̱cuu nak nacacuabi li c'a'ru nintz'a̱ma cha̱cuu. ");
INSERT INTO kekNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","La̱in ninnau nak junelic niquina̱cuabi. Abanan ninye a̱cue a'in re nak eb li cuanqueb arin te'ril li c'a'ru tinba̱nu ut te'xpa̱b nak la̱at xattaklan chak cue, chan li Jesús nak quitijoc. ");
INSERT INTO kekNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nak quirake' chi tijoc, li Jesús quixye chi cau xya̱b xcux: —At Lázaro, cuaclin chak ut quim arin, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ut laj Lázaro li quicam qui-el chak. Lanlo sa' jun t'icr jo' c'aynakeb chixba̱nunquil reheb li camenak. Li ru lanlo ajcui' sa' t'icr ut bac'bo li rok ut bac'bo li ruk'. Li Jesús quixye reheb: —Hitomak ut canabomak chi be̱c, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ut nabaleb laj judío li cuanqueb rochben lix María que'xpa̱b li Jesús nak que'ril li milagro li quixba̱nu. ");
INSERT INTO kekNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Abanan cuanqueb ajcui' li que'co̱eb riq'uineb laj fariseo ut que'xye reheb chixjunil li quixba̱nu li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ut eb laj fariseo rochbeneb li xbe̱nil aj tij que'xch'utub ribeb riq'uineb li neque'taklan sa' xya̱nkeb laj judío ut que'xye reheb: —¿C'a'ru takaba̱nu? Li cui̱nk a'in nabal li milagro yo̱ chixba̱nunquil. ");
INSERT INTO kekNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Cui takacanab chi jo'can, chixjunileb li tenamit te'pa̱ba̱nk re. Ut te'josk'ok kiq'uin eb laj Roma li neque'taklan sa' kabe̱n. Te'xjuc' li katemplo ut te'xsach li katenamit, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Jun li cui̱nk aj Caifás xc'aba', a'an li xyucua'il aj tij sa' li chihab a'an. Quixye reheb: —La̱ex ma̱c'a' e̱na'leb. ");
INSERT INTO kekNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","¿Ma inc'a' nequec'oxla nak k'axal us raj nak ta̱ca̱mk jun chi cui̱nk sa' xc'aba'eb li tenamit chiru nak ta̱sachek' ku chikajunilo la̱o aj judío xbaneb laj Roma? chan. ");
INSERT INTO kekNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Laj Caifás, a'an li xyucua'il aj tij sa' li chihab a'an. Ut li c'a'ru quixye inc'a' quixye yal xjunes. Quixye ban xban nak li Dios quic'utuc chiru li c'a'ru tixye. Jo'can nak quixye nak li Jesús ta̱ca̱mk sa' xc'aba'eb laj judío. ");
INSERT INTO kekNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ut ma̱cua' ca'aj cui' sa' xc'aba'eb a'an nak ta̱ca̱mk li Jesús. Re aj ban cui' nak junajakeb chic ru chixjunileb li ralal xc'ajol li cuanqueb sa' chixjunil li ruchich'och'. ");
INSERT INTO kekNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ut chalen sa' li cutan a'an, eb li neque'taklan sa' xya̱nkeb laj judío que'oc xc'u̱banquil ru sa' comonil chanru nak te'xcamsi li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Xban nak que'raj xcamsinquil li Jesús, inc'a' chic quiraj xc'utbal rib chiruheb laj judío. Qui-el aran ut co̱ sa' li tenamit Efraín li cuan nach' riq'uin li chaki ch'och'. Ut aran quicana rochbeneb lix tzolom. ");
INSERT INTO kekNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nak yo̱ chi cuulac xk'ehil li nink'e Pascua, nabaleb li cristian co̱eb Jerusalén chixch'ajobresinquil ribeb jo' c'aynakeb chixba̱nunquil re xtz'a̱manquil xcuybal xma̱queb chiru li Dios. Tento te'xba̱nu a'an re nak ta̱ru̱k te'oque̱nk sa' li nink'e. ");
INSERT INTO kekNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Yo̱queb chixsic'bal li Jesús nak que'xch'utub ribeb sa' li templo. Que'xye chi ribileb rib: —¿C'a'ru nequec'oxla la̱ex? ¿Ma ta̱cha̱lk ta cui' sa' li nink'e li cui̱nk a'an?— ");
INSERT INTO kekNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Eb li xbe̱nil aj tij ut eb laj fariseo que'xye reheb li tenamit nak cui ani ta̱abi̱nk resil bar cuan li Jesús, tento te'xye resil, re nak ta̱ru̱k te'xtakla xchapbal. ");
INSERT INTO kekNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Cuakib cutan chic ma̱ nacuulac xk'ehil li nink'e Pascua nak quicuulac li Jesús Betania. A'an xtenamit laj Lázaro, li quicam ut quicuaclesi̱c cui'chic chi yo'yo xban li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Que'xcauresi xtzacae̱mk li Jesús. Laj Lázaro cuan sa' xya̱nkeb li c'ojc'o̱queb sa' me̱x rochben li Jesús. Ut lix Marta yo̱ chixq'uebal li tzacae̱mk sa' li me̱x. ");
INSERT INTO kekNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Lix María quixc'am chak mero botella li sununquil ban terto xtz'ak yi̱banbil riq'uin nardo. Quixq'ue chiru rok li Jesús ut quixmes riq'uin li rismal xjolom. Ut c'ajo' xsununquil sa' li cab quicana xban xbo̱c li sununquil ban. ");
INSERT INTO kekNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Laj Judas Iscariote li ralal laj Simón, a'an jun reheb lix tzolom. A'an li ta̱k'axtesi̱nk re li Jesús sa' ruk'eb li xic' neque'iloc re. ");
INSERT INTO kekNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Quixye: —¿C'a'ut nak inc'a' xc'ayiman li sununquil ban a'in chi oxib ciento denarios ut xq'ueman raj li tumin a'an reheb li neba'? chan. ");
INSERT INTO kekNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ma̱cua' xban nak naxraheb li neba' nak quixye a'an. Quixye chi jo'can xban nak aj e̱lk'. Riq'uin a'an cuan lix bo̱lsil li tumin ut cuan nak naxchap chok' re a'an li tumin cuan chi sa'. ");
INSERT INTO kekNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Li Jesús quixye re: —Me̱cuech' rix li c'a'ru xba̱nu li ixk a'in, xban nak re inmukbal nak xq'ue li ban a'in chiru li cuok. ");
INSERT INTO kekNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Li neba' junelic cua̱nkeb sa' e̱ya̱nk. Yalak jok'e naru te̱tenk'aheb. Abanan la̱in moco cua̱nkin ta chi junelic e̱riq'uin, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Nabaleb laj judío que'rabi resil nak li Jesús cuan aran Betania ut que'cuulac aran. Ma̱cua' ca'aj cui' li Jesús que'cuulac chirilbal. Que'cuulac aj ban cui' chirilbal laj Lázaro li quicuaclesi̱c cui'chic chi yo'yo xban li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ut eb li xbe̱nil aj tij que'xc'u̱b ru nak te'xcamsi ajcui' laj Lázaro, ");
INSERT INTO kekNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","xban nak nabaleb laj judío yo̱queb chi e̱lc sa' xya̱nkeb ut yo̱queb chixpa̱banquil li Jesús xban nak quixcuaclesi cui'chic chi yo'yo laj Lázaro. ");
INSERT INTO kekNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Jo' cuulajak chic li q'uila tenamit que'cuulac sa' li nink'e. Que'rabi resil nak li Jesús cuulac re Jerusalén. ");
INSERT INTO kekNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Quilaje'xc'am chak xxak li moco̱ch ut que'chal chixc'ulbal li Jesús. Japjo̱queb re chixyebal: —Lok'oninbil taxak li Ka̱cua'. Osobtesinbil taxak li xchal sa' xc'aba' li Ka̱cua' Dios. Osobtesinbil taxak li karey, la̱o aj Israel, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Li Jesús quixto'oni jun li ch'ina bu̱r, quitake' chirix ut yo̱ chi xic Jerusalén jo' tz'i̱banbil retalil sa' li Santil Hu: ");
INSERT INTO kekNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Mexxucuac la̱ex li cuanquex Sión xban nak yo̱ chak chi cha̱lc le̱ rey. Chirix jun ral bu̱r yo̱ chak chi cha̱lc. (Zac. 9:9) ");
INSERT INTO kekNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Sa' li ho̱nal a'an nak yo̱ chi c'ulma̱nc li c'a'ak re ru a'in, eb lix tzolom inc'a' que'xtau ru li xya̱lal. Abanan mokon nak ac quicuaclesi̱c cui'chic chi yo'yo sa' xya̱nkeb li camenak ut quiq'uehe' xlok'al, tojo'nak que'xq'ue retal nak quixc'ul jo' tz'i̱banbil chak retalil sa' li Santil Hu chirix. ");
INSERT INTO kekNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Eb li tenamit li cuanqueb rochben li Jesús nak quixcuaclesi cui'chic chi yo'yo laj Lázaro yo̱queb chixyebal resilal yalak bar. ");
INSERT INTO kekNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Li q'uila tenamit que'cuulac chixc'ulbal li Jesús xban nak que'rabi resil li milagro li quixba̱nu. ");
INSERT INTO kekNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Eb laj fariseo que'xye chi ribileb rib: —¿Ma xeq'ue retal nak ma̱c'a' aj e li yo̱co chixba̱nunquil? Q'uehomak retal. Anakcuan chixjunileb li tenamit yo̱queb chi ta̱ke̱nc re li cui̱nk a'an, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Cuanqueb li ma̱cua'eb aj judío que'cuulac Jerusalén chi lok'oni̱nc nak yo̱ li nink'e. ");
INSERT INTO kekNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Que'cuulac riq'uin laj Felipe Betsaida xtenamit xcue̱nt Galilea ut que'xye re: —Ka̱cua', takaj xnaubal ru li Jesús, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Laj Felipe co̱ ut quixye resil re laj Andrés ut co̱eb xcabichaleb chixyebal re li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Li Jesús quixye reheb: —Xcuulac x-o̱ril nak ta̱q'uehek' inlok'al la̱in li C'ajolbej. ");
INSERT INTO kekNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Relic chi ya̱l ninye e̱re nak cui li jun t'orol chi riyajil trigo inc'a' na-auman, jun t'orolak ajcui'. Ut cui na-auman, na-oso' sa' li ch'och'. Jun ajcui' ru li na-oso', abanan nabal li ru naxq'ue nak nau̱chin. ");
INSERT INTO kekNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Li ani k'axal naxra lix yu'am sa' li ruchich'och' a'in, a'an tixsach li junelic yu'am. A'ut li ani inc'a' naxra lix yu'am sa' ruchich'och', a'an ta̱cua̱nk xyu'am chi junelic. ");
INSERT INTO kekNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Li ani ta̱raj c'anjelac chicuu, tento tinixta̱ke ut tixba̱nu li c'a'ru ninye. Bar cua̱nkin la̱in, aran ajcui' ta̱cua̱nk a'an. Ut lin Yucua' ta̱q'uehok xlok'al li ani ta̱c'anjelak chicuu, chan li Jesús reheb. ");
INSERT INTO kekNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Li Jesús quixye ajcui': —Anakcuan k'axal ra sa' inch'o̱l. ¿Ma ta̱ru̱k ta bi' tinye re li Dios, “At inYucua', china̱col chiru li raylal a'in”? La̱in inc'a' tinye chi jo'can xban nak a'an aj e nak xinchal sa' ruchich'och'. ");
INSERT INTO kekNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","At inYucua', chinima̱k taxak la̱ lok'al, chan. Ut li Dios quia̱tinac chak sa' choxa ut quixye: —Ac xnima̱c inlok'al, ut ta̱nima̱k cui'chic, chan li Dios. ");
INSERT INTO kekNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ut li que'abin re nak quia̱tinac li Dios inc'a' que'xnau nak a'an li Dios. Cuan que'xye: —Ca̱k x-ec'an, chanqueb. Ut cuan cui'chic que'yehoc re: —Jun ángel x-a̱tinac riq'uin, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ut li Jesús quixye reheb: —Moco re ta intenk'anquil la̱in nak x-a̱tinac li Dios. Re ban e̱tenk'anquil la̱ex. ");
INSERT INTO kekNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Anakcuan xcuulac xk'ehil nak li Dios ta̱rakok a̱tin sa' xbe̱neb li cuanqueb sa' ruchich'och'. Anakcuan ta̱sachek' xcuanquil laj tza li nataklan sa' ruchich'och'. ");
INSERT INTO kekNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ut nak tinq'uehek' la̱in chiru cruz, nabaleb te'pa̱ba̱nk cue, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Nak quixye chi jo'can, li Jesús yo̱ chixyebal reheb chanru nak ta̱camsi̱k. ");
INSERT INTO kekNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Eb li q'uila tenamit que'xye re: —Sa' li kachak'rab la̱o aj judío tz'i̱banbil retalil nak li Cristo li Mesías ta̱cua̱nk xyu'am chi junelic. ¿C'a'ut nak nacaye la̱at nak li C'ajolbej ta̱q'uehek' chiru cruz? ¿Ani li C'ajolbej li yo̱cat chixyebal? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Quichak'oc li Jesús ut quixye reheb: —La̱in li cutan saken. Xinchal chixch'olobanquil li xya̱lal che̱ru. Toj tincua̱nk chic ca'ch'inak sa' e̱ya̱nk. Jo'can nak q'uehomak e̱ch'o̱l chinpa̱banquil nak toj cuanquin sa' e̱ya̱nk re nak inc'a' texcua̱nk sa' xk'ojyi̱nal ru li ma̱c. Li ani nacuan sa' xk'ojyi̱nal ru li ma̱c inc'a' naxnau bar yo̱ chi xic. ");
INSERT INTO kekNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Chine̱pa̱b la̱in nak toj cuanquin e̱riq'uin re nak la̱exak chic li cualal inc'ajol ut cua̱nkex sa' cutan, chan li Jesús. Nak ac xye li a̱tin a'in, li Jesús qui-el sa' xya̱nkeb ut co̱ sa' jun na'ajej bar inc'a' te'xtau. ");
INSERT INTO kekNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Usta nabal li milagro quixba̱nu li Jesús chiruheb, abanan inc'a' ajcui' que'pa̱ban. ");
INSERT INTO kekNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","A'in quic'ulman re nak ta̱tz'aklok ru li quixye li profeta Isaías nak quixye: Ka̱cua', ¿ani ta bi' ta̱q'uehok xcuanquil li c'a'ru xkaye? Ut, ¿ani ta bi' ta̱q'uehok xcuanquil li milagro li yo̱cat chixc'utbesinquil chiruheb? (Is. 53:1) ");
INSERT INTO kekNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Inc'a' quiru que'pa̱ban xban nak ac tz'i̱banbil chak retalil xban laj Isaías nak jo'can te'xc'ul. ");
INSERT INTO kekNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Chanchaneb li mutz' xban nak que'iloc ut inc'a' que'xtau xya̱lal. Que'cacuubresi̱c lix ch'o̱leb xban li Dios re nak inc'a' te'xtau xya̱lal chi moco te'suk'i̱k riq'uin re nak tixq'uirtesiheb. (Is. 6:10) ");
INSERT INTO kekNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Quixye a'in laj Isaías nak quic'utbesi̱c chiru lix lok'al li Jesús. Jo'can nak quixch'olob li xya̱lal. ");
INSERT INTO kekNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Cuanqueb nabaleb laj judío que'xpa̱b nak li Jesús, a'an li Mesías. Sa' xya̱nkeb a'an cuanqueb junju̱nk li neque'taklan. Abanan inc'a' que'xye resil nak que'pa̱ban xban nak que'xucuac xbaneb laj fariseo. Inc'a' que'raj nak te'isi̱k sa' li cab li neque'xch'utub cui' ribeb laj judío. ");
INSERT INTO kekNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","A' chic li lok'al li neque'xq'ue li tenamit que'xq'ue xcuanquil. Ut inc'a' que'xq'ue xcuanquil li lok'al li naxq'ue li Dios. ");
INSERT INTO kekNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Quixye li Jesús chi cau xya̱b xcux: —Li ani napa̱ban cue la̱in, moco ca'aj cui' ta la̱in niquinixpa̱b. Naxpa̱b aj ban cui' li quitaklan chak cue. ");
INSERT INTO kekNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Li ani nana'oc cuu la̱in, naxnau ajcui' ru li quitaklan chak cue. ");
INSERT INTO kekNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","La̱in xinchal chixq'uebal li cutan saken sa' ruchich'och'. Li ani ta̱pa̱ba̱nk cue la̱in, a'an inc'a' chic ta̱cua̱nk sa' xk'ojyi̱nal ru li ma̱c. ");
INSERT INTO kekNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","La̱in inc'a' xinchal sa' ruchich'och' chixq'uebaleb chixtojbal rix lix ma̱queb li ani neque'abin re li c'a'ru ninye ut inc'a' neque'xba̱nu. Ma̱cua' re xq'uebaleb chixtojbal lix ma̱queb nak xinchal. Xinchal ban chixcolbaleb. ");
INSERT INTO kekNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Tento nak ta̱rakek' a̱tin sa' xbe̱neb li neque'tz'ekta̱nan cue, li inc'a' neque'pa̱ban re li c'a'ru ninye. Li a̱tin li xinye, a'an ajcui' li ta̱q'uehok reheb chixtojbal rix lix ma̱queb sa' roso'jiqueb li cutan. ");
INSERT INTO kekNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Li c'a'ru yo̱quin chixyebal, a'an tz'akal ya̱l xban nak moco injunes ta yo̱quin chi a̱tinac. Li Yucua'bej li quitaklan chak cue, a'an li nayehoc cue c'a'ru tinye. ");
INSERT INTO kekNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","La̱in ninnau nak li c'a'ru naxye cue li Yucua'bej, a'an li naq'uehoc yu'am chi junelic. Ut li c'a'ru ninye la̱in, a'an li naxc'utbesi chicuu li Yucua'bej. ");
INSERT INTO kekNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ac cuulajak naticla li nink'e Pascua. Li Jesús ac naxnau nak cuulac re xk'ehil lix camic re nak ta̱xic cui'chic riq'uin lix Yucua' sa' choxa. Junelic naxraheb li ralal xc'ajol li te'cana̱k sa' ruchich'och' ut nak ac ca̱mc re quixc'utbesi chi tz'akal lix rahom chiruheb. ");
INSERT INTO kekNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Li Jesús yo̱ chi cua'ac rochbeneb lix tzolom. Laj tza ac xq'ue sa' xch'o̱l laj Judas li ralal laj Simón Iscariote nak tixk'axtesi li Jesús sa' ruk'eb li xic' neque'iloc re. ");
INSERT INTO kekNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Li Jesús naxnau nak q'uebil re lix cuanquil xban li Dios ut a'an yal re sa' xbe̱n chixjunil. Naxnau nak riq'uin li Dios quichal chak ut riq'uin ajcui' li Dios ta̱xic. ");
INSERT INTO kekNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Nak yo̱queb chi cua'ac, li Jesús quicuacli. Quirisi lix t'icr li cuan sa' xbe̱n li rak'. Quixchap jun chic li t'icr ut quixbac' chi xsa'. ");
INSERT INTO kekNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Quixq'ue li ha' sa' jun li emel ut qui-oc chixch'ajbal li rokeb lix tzolom. Ut quixmes li rokeb riq'uin li t'icr bac'bo chi xsa'. ");
INSERT INTO kekNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nak qui-oc raj chixch'ajbal li rok laj Simón Pedro, a'an quixye re: —Ka̱cua', ¿ma la̱at tatch'ajok re li cuok la̱in? chan. ");
INSERT INTO kekNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Li Jesús quixye re: —Anakcuan inc'a' nacatau ru li c'a'ru yo̱quin chixba̱nunquil. Abanan mokon ta̱tau ru li xya̱lal, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Laj Pedro quixye re: —Ka̱cua', ma̱ jok'e tinq'ue li cuok re ta̱ch'aj, chan. Li Jesús quixye re: —Cui la̱at inc'a' ta̱q'ue la̱ cuok re tinch'aj, la̱at ma̱cua'at intzolom, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Laj Simón Pedro quixye: —Ka̱cua', ma̱cua' ca'aj cui' li cuok ta̱ch'aj. Ta̱ch'aj aj ban cui' li cuuk' ut lin jolom, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Li Jesús quixye reheb: —Li ani ac x-atin, ca'aj chic xch'ajbal li rok ta̱raj, xban nak ac ch'ajbil. Ac sak chic ru. Jo'can ajcui' la̱ex. La̱ex ac ti̱c e̱ch'o̱l xban nak ac xine̱pa̱b. Abanan moco che̱junilex ta ti̱c e̱ch'o̱l. Cuan jun sa' e̱ya̱nk inc'a' ti̱c xch'o̱l, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Li Jesús ac naxnau ani li ta̱k'axtesi̱nk re sa' ruk'eb li xic' neque'iloc re. Jo'can nak quixye nak cuan jun sa' xya̱nkeb inc'a' ti̱c xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nak ac xrake' xch'ajbal li rokeb, quixq'ue cui'chic li rak' chirix. Quic'ojla cui'chic sa' li me̱x. Ut quixye reheb lix tzolom: —¿Ma nequenau c'a'ru xya̱lal nak xinch'aj le̱ rok? chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","—La̱ex nequeye aj tzolonel cue ut nequeye ajcui' Ka̱cua' cue. Us nak nequeye chi jo'can xban nak ya̱l ajcui' nak la̱in li Ka̱cua' ut la̱in aj tzolol e̱re. ");
INSERT INTO kekNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","La̱in li Ka̱cua' ut la̱in laj tzolol e̱re. Abanan xinch'aj le̱ rok. Jo'can ajcui' te̱ba̱nu la̱ex. Te̱ch'aj le̱ rok che̱ribil e̱rib. ");
INSERT INTO kekNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","La̱in xinc'ut che̱ru chanru te̱ba̱nu. Jo'can nak cheba̱nu jo' xinba̱nu la̱in. ");
INSERT INTO kekNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Relic chi ya̱l ninye e̱re nak ma̱ jun mo̱s tixk'ax ta ru xcuanquil lix patrón ut li ani natakla̱c inc'a' naxk'ax ru lix cuanquil li quitaklan chak re. ");
INSERT INTO kekNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ac nequenau chic xya̱lal. Us xak e̱re cui la̱ex te̱ba̱nu li c'a'ru xetzol cuiq'uin. ");
INSERT INTO kekNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Inc'a' yo̱quin chi a̱tinac che̱rix che̱junilex. La̱in ninnau chanru le̱ na'leb xban nak la̱in xinsic'oc e̱ru. Abanan tento nak ta̱tz'aklok ru li tz'i̱banbil sa' li Santil Hu li naxye chi jo'ca'in: Li jun li nacua'ac cuochben, a'an li ta̱tz'ekta̱na̱nk cue. ");
INSERT INTO kekNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","La̱in ninye e̱re a'in anakcuan nak toj ma̱ji' nac'ulman. Ut nak ta̱c'ulma̱nk, la̱ex te̱nau nak ya̱l li xinye nak la̱in li Cristo li taklanbil chak xban li Dios. ");
INSERT INTO kekNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Relic chi ya̱l tinye e̱re nak ani ta̱c'uluk re li ani tintakla, tinixc'ul ajcui' la̱in. Ut li ani ta̱c'uluk cue la̱in, tixc'ul ajcui' li quitaklan chak cue, chan li Jesús reheb. ");
INSERT INTO kekNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nak ac xye chixjunil li c'a'ak re ru a'in, li Jesús quiyot'e' xch'o̱l. Ut quixye chi tz'akal reheb: —Relic chi ya̱l ninye e̱re nak jun sa' e̱ya̱nk la̱ex ta̱k'axtesi̱nk cue sa' ruk'eb li xic' neque'iloc cue, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ut eb lix tzolom que'oc xc'a'uxeb. Que'xca'ya ribeb chi ribileb rib ut que'xye: —¿Ani anchal naxyehan? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jun reheb lix tzolom, li raro xban, c'ojc'o chixc'atk. ");
INSERT INTO kekNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Laj Simón Pedro quixc'ut li ruk' chiru ut quixye re nak tixpatz' re li Jesús ani li yo̱ chixyebal. ");
INSERT INTO kekNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ut li jun, li c'ojc'o chixc'atk li Jesús, quijiloc riq'uin ut quixpatz' re: —Ka̱cua', ¿ani li yo̱cat chixyebal? chan. ");
INSERT INTO kekNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Li Jesús quixye re: —Li ani tinq'ue cui' li caxlan cua a'in nak acak xintz'a sa' li sec', a'an li cui̱nk li ta̱k'axtesi̱nk cue sa' ruk'eb li xic' neque'iloc cue, chan. Ut li Jesús quixtz'a li caxlan cua sa' li sec' ut quixq'ue re laj Judas li ralal laj Simón Iscariote. ");
INSERT INTO kekNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ut laj Judas quixc'ul li caxlan cua ut sa' ajcui' li ho̱nal a'an quixk'axtesi rib chixba̱nunquil li c'a'ru naraj laj tza. Ut li Jesús quixye re: —Li c'a'ru yo̱cat chixc'oxlanquil xba̱nunquil, ba̱nu chi junpa̱t, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ma̱ jun reheb li cuanqueb sa' li me̱x que'xtau ru li quixye li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Cuan li que'xc'oxla nak li Jesús ta̱raj nak laj Judas ta̱xic chixlok'bal li c'a'ak re ru re li nink'e. Ut cuan ajcui' li que'xc'oxla nak ta̱raj nak laj Judas tixq'ue ca'ch'inak li tumin reheb li neba' xban nak riq'uin laj Judas cuan lix bo̱lsil lix tumineb. ");
INSERT INTO kekNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Nak ac xc'ul li caxlan cua laj Judas, qui-el sa' junpa̱t chirix cab. Ac k'ojyi̱n chic. ");
INSERT INTO kekNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Nak laj Judas ac x-el sa' xya̱nkeb, li Jesús quixye: —Anakcuan xcuulac xk'ehil nak ta̱c'utbesi̱k lin lok'al la̱in li C'ajolbej ut ta̱c'utu̱nk ajcui' lix lok'al li Dios riq'uin li c'a'ru tinc'ul la̱in. ");
INSERT INTO kekNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Cui la̱in tinc'utbesi lix lok'al li Dios, a'an chi se̱b ajcui' tixc'utbesi lin lok'al la̱in li C'ajolbej. ");
INSERT INTO kekNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ex cualal inc'ajol, inc'a' chic najt tincua̱nk e̱riq'uin. La̱ex tine̱sic' raj chic. Abanan la̱in ma̱ anihakin chic. Ninye e̱re jo' quinye reheb laj judío li neque'taklan sa' e̱ya̱nk. Bar tinxic la̱in, la̱ex inc'a' texru̱k chi xic. ");
INSERT INTO kekNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Jun li ac' chak'rab tinq'ue e̱re anakcuan nak cherahak e̱rib che̱ribil e̱rib. Jo' nak nequexinra la̱in, jo'can ajcui' nak te̱ra e̱rib la̱ex che̱ribil e̱rib. ");
INSERT INTO kekNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Cui te̱ra e̱rib che̱ribil e̱rib, chixjunileb te'xnau nak la̱ex intzolom, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Laj Simón Pedro quixpatz' re: —At tzolonel, ¿bar xic a̱cue?— Li Jesús quixye re: —Anakcuan inc'a' naru texxic chicuix bar tinxic cui' la̱in. Abanan mokon naru texxic li bar xic cui' cue, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Laj Pedro quixye cui'chic re: —Ka̱cua', ¿c'a'ut nak inc'a' ta̱ru̱k tinxic cha̱cuix anakcuan? La̱in tatinta̱ke usta tincamsi̱k xban a̱ta̱kenquil, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Li Jesús quixye re: —¿Ma ya̱l nak tina̱ta̱ke usta tatcamsi̱k sa' inc'aba'? Relic chi ya̱l ninye a̱cue nak toj ma̱ji' ajcui' naya̱bac laj tzo' xul nak la̱at ac xaye oxib sut nak inc'a' nacanau cuu, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Misach e̱ch'o̱l chi c'oxlac. Chepa̱b li Dios ut chine̱pa̱b ajcui' la̱in. ");
INSERT INTO kekNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Sa' rochoch lin Yucua' nabal li na'ajej cuan. Cui ta ma̱c'a' li na'ajej, ac xinye raj e̱re. La̱in xic cue chixcauresinquil e̱na'aj. ");
INSERT INTO kekNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nak ac xya̱lo' le̱ na'aj, tincha̱lk cui'chic ut texinc'am cuiq'uin re nak bar cua̱nkin la̱in, aran ajcui' cua̱nkex la̱ex. ");
INSERT INTO kekNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","La̱ex nequenau lix behil li na'ajej li xic cui' cue, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Laj Tomás quixye re: —At Ka̱cua', inc'a' nakanau bar xic a̱cue. ¿Chan ta cui' ru nak takanau li be? chan. ");
INSERT INTO kekNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Li Jesús quixye re: —La̱in aj c'amol be che̱ru. La̱in ninch'olob li xya̱lal li Dios ut la̱in ninq'uehoc junelic yu'am. Ma̱ ani ta̱ru̱k ta̱oc riq'uin lin Yucua' cui inc'a' tinixpa̱b la̱in. ");
INSERT INTO kekNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Li ani naxnau cuu la̱in naxnau ajcui' ru lin Yucua'. Chalen anakcuan nequenau chic ru lin Yucua' ut xeril ru, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Laj Felipe quixye re: —Ka̱cua', c'utbesi chiku li Yucua'bej ut ta̱c'ojla̱k kach'o̱l, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Li Jesús quixye re: —At Felipe, ac junxil nin-oc sa' e̱ya̱nk. ¿Ma toj ma̱ji' nequenau cuu? Li ani nana'oc cuu la̱in, a'an naxnau ajcui' ru li Yucua'bej. ¿C'a'ut nak nacaye cue, “C'ut chiku li Yucua'bej?” ");
INSERT INTO kekNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Felipe, ¿ma inc'a' nacapa̱b nak la̱in ut li Yucua'bej junaj ku chi kibil kib? Li c'a'ru xinye e̱re moco yal injunes ta xinye. Li Yucua'bej cuan cuiq'uin, ut a'an nac'utuc chicuu li c'a'ru ninba̱nu. ");
INSERT INTO kekNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Chepa̱b nak la̱in cuanquin riq'uin li Yucua'bej ut a'an cuan cuiq'uin. Junaj ku chi kibil kib. Cui inc'a' niquine̱pa̱b xban li c'a'ru ninye, chine̱pa̱bak xbaneb li milagro li yo̱quin chixba̱nunquil. ");
INSERT INTO kekNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Relic chi ya̱l ninye e̱re, li ani napa̱ban cue la̱in, a'an tixba̱nu li c'anjel ninba̱nu la̱in. Ut k'axal cui'chic nabal li tixba̱nu chiru li xinba̱nu la̱in xban nak la̱in xic cue riq'uin li Yucua'bej. ");
INSERT INTO kekNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Chixjunil li te̱tz'a̱ma sa' inc'aba', la̱in tinq'ue e̱re re nak ta̱nima̱k xlok'al li Yucua'bej sa' inc'aba' la̱in. ");
INSERT INTO kekNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Jo'can ut nak yalak c'a'ru te̱tz'a̱ma sa' inc'aba', la̱in tinq'ue e̱re. ");
INSERT INTO kekNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Cui niquine̱ra, cheba̱nuhak jo' xexinchak'rabi cui'. ");
INSERT INTO kekNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","La̱in tintz'a̱ma chiru lin Yucua' nak tixq'ue e̱re li Santil Musik'ej. A'an ta̱c'ojoba̱nk e̱ch'o̱l ut a'an ta̱tenk'a̱nk e̱re. A'an ta̱cua̱nk e̱riq'uin chi junelic. ");
INSERT INTO kekNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ut a'an ajcui' li Santil Musik'ej li ta̱c'utuk re li xya̱lal che̱ru chirix li Dios. Li inc'a' niquine'xpa̱b inc'a' naru nacuan li Santil Musik'ej riq'uineb xban nak inc'a' neque'xnau ani a'an, chi moco neque'xq'ue retal li c'a'ru naxba̱nu li Santil Musik'ej. Abanan la̱ex nequenau ani a'an xban nak a'an cuan sa' e̱ya̱nk anakcuan ut ta̱cua̱nk e̱riq'uin chi junelic. ");
INSERT INTO kekNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nak tinxic inc'a' texincanab e̱junes. Tincha̱lk cui'chic e̱riq'uin. ");
INSERT INTO kekNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Cuulac re xk'ehil nak inc'a' chic te'ril cuu li inc'a' neque'pa̱ban cue. Abanan la̱ex te̱ril cuu. Ut xban nak yo'yo̱kin la̱in, yo'yo̱kex ajcui' la̱ex. ");
INSERT INTO kekNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Toj sa' li cutan a'an la̱ex te̱q'ue retal nak li Yucua'bej cuan cuiq'uin ut la̱in cuanquin riq'uin a'an. Junaj ku chi kibil kib. Ut la̱ex cua̱nkex cuiq'uin ut la̱in cua̱nkin e̱riq'uin. ");
INSERT INTO kekNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Li ani naxc'ul lin chak'rab ut naxba̱nu li naxye, a'an li narahoc cue. Li ani narahoc cue narahe' ajcui' xban lin Yucua'. Ut la̱in tinra ajcui' a'an ut tinc'utbesi cuib chiru, chan li Jesús reheb lix tzolom. ");
INSERT INTO kekNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Laj Judas jun chic, li ma̱cua' laj Judas Iscariote, quixye re: —Ka̱cua', ¿chanru nak ta̱c'utbesi a̱cuib chiku la̱o, ut inc'a' ta̱c'utbesi a̱cuib chiruheb li inc'a' neque'pa̱ban a̱cue? chan. ");
INSERT INTO kekNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Quichak'oc li Jesús ut quixye re: —La̱in tinc'utbesi cuib chiruheb li neque'rahoc cue ut neque'xba̱nu li c'a'ru ninye. Eb a'an te'rahek' xban lin Yucua'. La̱in ut lin Yucua' toxic riq'uineb ut tocua̱nk riq'uineb. ");
INSERT INTO kekNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Li ani inc'a' narahoc cue inc'a' naxba̱nu li c'a'ru ninye. Li c'a'ru xinye e̱re, inc'a' xinye yal injunes. Lin Yucua' li quitaklan chak cue, a'an li nac'utuc chicuu c'a'ru tinye. ");
INSERT INTO kekNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Yo̱quin chixyebal e̱re a'in nak toj cuanquin sa' e̱ya̱nk. ");
INSERT INTO kekNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Li Santil Musik'ej li tixtakla chak li Yucua'bej chok' cuu̱chil, a'an ta̱tenk'a̱nk e̱re ut a'an ta̱c'utuk che̱ru chixjunil li c'a'ak re ru li inc'a' nequetau ru. Ut a'an tixjultica e̱re chixjunil li c'a'ru xinye e̱re. ");
INSERT INTO kekNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","La̱in tincanab li tuktu̱quil usilal e̱riq'uin nak tinxic. Li tuktu̱quil usilal li tinq'ue e̱re moco jo' ta li neque'xq'ue li cuanqueb sa' ruchich'och'. La̱in tinq'ue xtuktu̱quilal le̱ ch'o̱l. Mexc'oxlac chi moco texxucuak. ");
INSERT INTO kekNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ac xinye e̱re nak tinxic, ut tincha̱lk cui'chic. Cui ya̱l nak niquine̱ra, ta̱sahok' raj sa' e̱ch'o̱l nak tinxic riq'uin lin Yucua', xban nak a'an k'axal nim xcuanquil chicuu la̱in. ");
INSERT INTO kekNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","La̱in yo̱quin chixyebal e̱re a'in nak toj ma̱ji' nac'ulman. Nak ta̱c'ulma̱nk li c'a'ru xinye, la̱ex te̱pa̱b nak ya̱l li c'a'ru xinye e̱re. ");
INSERT INTO kekNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Inc'a' chic ta̱ru̱k tina̱tinak chi nabal e̱riq'uin xban nak yo̱ chi cha̱lc li nataklan sa' li ruchich'och', usta a'an ma̱c'a' xcuanquil sa' inbe̱n la̱in. ");
INSERT INTO kekNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","La̱in yo̱quin chixba̱nunquil chixjunil li quixye cue lin Yucua' re nak chixjunileb li cuanqueb sa' ruchich'och' te'xq'ue retal nak la̱in ninra li Yucua'bej. Anakcuan yo̱keb. E̱lko sa' li na'ajej a'in, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Li Jesús quixye ajcui' reheb: —La̱in chanchanin li xto̱nal li uvas. Ut lin Yucua' jo' jun li nasabesin re. ");
INSERT INTO kekNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Li ani inc'a' naxba̱nu li c'a'ru naraj lin Yucua', a'an chanchan li ruk' li che' li na-isi̱c xban nak inc'a' nau̱chin. Abanan li ani naxba̱nu li c'a'ru naraj lin Yucua', a'an chanchan li ruk' li che' li nau̱chin. Ut li na-iloc re naxsabesi re nak tixq'ue nabal li ru. ");
INSERT INTO kekNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","La̱ex chanchanex li cha̱bil ruk' li che' li nau̱chin chi nabal xban nak sabesinbil chic ru. La̱ex ac ti̱c chic le̱ yu'am xban li xya̱lal xinch'olob che̱ru. ");
INSERT INTO kekNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Cua̱nkex cuiq'uin ut la̱in cua̱nkin e̱riq'uin. Jo' li ruk' li che', cui inc'a' letzlo riq'uin lix to̱nal, inc'a' naru nau̱chin. Jo'can ajcui' la̱ex. Cui inc'a' cua̱nkex cuiq'uin, inc'a' ta̱ru̱k texq'ui̱k sa' le̱ pa̱ba̱l. ");
INSERT INTO kekNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","La̱in jo' li xto̱nal li uvas ut la̱ex jo' li ruk'. Cui cua̱nkex cuiq'uin ut la̱in cua̱nkin e̱riq'uin, la̱ex texcua̱nk sa' ti̱quilal ut texq'ui̱k sa' le̱ pa̱ba̱l. Yal e̱junes ma̱c'a' naru te̱ba̱nu. ");
INSERT INTO kekNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Li ani inc'a' ta̱cua̱nk cuiq'uin ta̱isi̱k jo' nak nayoq'ue' li ruk' li che' li inc'a' us. Nak nachakic nacute' sa' xam ut nac'at. ");
INSERT INTO kekNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Cui la̱ex cua̱nkex cuiq'uin ut te̱ba̱nu li c'a'ru xinye e̱re, ta̱q'uehek' e̱re chixjunil li c'a'ru te̱tz'a̱ma. ");
INSERT INTO kekNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nequeq'ue xlok'al lin Yucua' riq'uin li cha̱bilal nequeba̱nu. Cui yo̱kex chixba̱nunquil li c'a'ru naraj li Dios, la̱exak tz'akal intzolom. ");
INSERT INTO kekNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","La̱in nequexinra la̱ex jo' nak ninxra lin Yucua' la̱in. Chexcua̱nk cuiq'uin re nak texinra chi junelic. ");
INSERT INTO kekNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Cui te̱ba̱nu li c'a'ru ninye e̱re, la̱in texinra junelic. La̱in xinba̱nu li c'a'ru xye cue lin Yucua' ut a'an junelic niquinixra la̱in. ");
INSERT INTO kekNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","La̱in ninye e̱re a'in re nak textz'ako̱nk riq'uin lix sahil inch'o̱l la̱in. Cui te̱ba̱nu li c'a'ru ninye e̱re, numtajenakak xsahil e̱ch'o̱l la̱ex. ");
INSERT INTO kekNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","A'an a'in li chak'rab li ninq'ue e̱re nak cherahak e̱rib che̱ribil e̱rib jo' nak nequexinra la̱in. ");
INSERT INTO kekNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Li rahoc chi tz'akal a'an nak junak tixk'axtesi lix yu'am sa' xc'aba' li ras ri̱tz'in. ");
INSERT INTO kekNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Cui te̱ba̱nu li c'a'ru ninye e̱re, la̱exak li raro̱kex inban. ");
INSERT INTO kekNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","La̱ex ma̱cua'akex chic yal aj c'anjel xban nak junak laj c'anjel inc'a' naxnau c'a'ru yo̱ lix patrón. Abanan la̱in xinye e̱re chixjunil li naxye cue lin Yucua'. A'an naxc'ut nak raro̱quex inban. ");
INSERT INTO kekNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ma̱cua' la̱ex xexsic'oc cuu la̱in. La̱in ban xinsic'oc e̱ru la̱ex ut xexinxakab chixba̱nunquil li ti̱quilal. Le̱ ti̱quilal inc'a' ta̱osok'. Ta̱cua̱nk ban chi junelic. Ut lin Yucua' tixq'ue e̱re chixjunil li te̱tz'a̱ma sa' inc'aba' la̱in. ");
INSERT INTO kekNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","A'an a'in li yo̱quin chixyebal e̱re nak cherahak e̱rib che̱ribil e̱rib. ");
INSERT INTO kekNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Cui la̱ex xic' nequex-ile' xbaneb li inc'a' neque'pa̱ban, chenauhak nak xbe̱n cua la̱in xic' xine'ril che̱ru la̱ex. ");
INSERT INTO kekNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Cui ta la̱ex inc'a' xine̱pa̱b la̱in, raro̱kex raj xbaneb li inc'a' neque'pa̱ban. Abanan la̱ex ma̱cua'ex chic jun sa' xya̱nkeb xban nak la̱in xinsic'oc e̱ru. Jo'can nak xic' nequex-ile' xbaneb. ");
INSERT INTO kekNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Chijulticok' e̱re nak xinye e̱re nak ma̱ jun aj c'anjel naxk'ax ru xcuanquil lix patrón. Cui xine'xrahobtesi la̱in, texrahobtesi̱k ajcui' la̱ex. Cui ta xe'xba̱nu li c'a'ru xinye la̱in, te'xba̱nu aj raj cui' li c'a'ru te̱ye la̱ex. ");
INSERT INTO kekNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Texrahobtesi̱k xban nak la̱ex cualal inc'ajol. Te'xba̱nu chi jo'can xban nak inc'a' neque'xnau ru li ani quitaklan chak cue. ");
INSERT INTO kekNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ma̱c'a'eb raj xma̱c cui ta la̱in inc'a' xinc'ulun ut cui ta inc'a' xinye reheb li xya̱lal. Abanan ma̱c'a' c'a'ru te'xcol cui' ribeb xban nak cuanqueb xma̱c. ");
INSERT INTO kekNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Li ani xic' na-iloc cue la̱in, xic' ajcui' naril lin Yucua'. ");
INSERT INTO kekNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ma̱c'a'eb raj xma̱c cui ta inc'a' xe'ril li milagros li xinba̱nu chiruheb, li milagros li ma̱ ani chic naru xba̱nunquil. Abanan eb a'an que'ril li xinba̱nu. Jo'can nak xic' niquine'ril la̱in ut xic' ajcui' neque'ril lin Yucua'. ");
INSERT INTO kekNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Jo'ca'in xc'ulman xban nak tz'i̱banbil chak retalil sa' li chak'rab li quiq'uehe' reheb: Ma̱c'a' raj inma̱c, abanan xic' quine'ril. ");
INSERT INTO kekNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Nak ta̱cha̱lk li Santil Musik'ej, laj C'ojobanel Ch'o̱l, e̱riq'uin a'an tixc'ut chi tz'akal li xya̱lal che̱ru chicuix la̱in. La̱in tintakla chak e̱riq'uin li Santil Musik'ej li nachal riq'uin lin Yucua'. ");
INSERT INTO kekNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ut la̱ex te̱ch'olob ajcui' li xya̱lal chicuix xban nak la̱ex cuanquex cuiq'uin chalen nak xintiquib lin c'anjel arin sa' ruchich'och'. ");
INSERT INTO kekNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yo̱quin chixyebal e̱re chixjunil li c'a'ak re ru a'in re nak inc'a' ta̱ch'ina̱nk e̱ch'o̱l sa' le̱ pa̱ba̱l nak ta̱cha̱lk li raylal sa' e̱be̱n. ");
INSERT INTO kekNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tex-isi̱k sa' li cab li neque'xch'utub cui' ribeb laj judío. Ta̱cuulak xk'ehil nak eb li te'camsi̱nk e̱re te'xc'oxla nak yo̱queb chi c'anjelac chiru li Dios nak te'xba̱nu chi jo'can. ");
INSERT INTO kekNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Te'xba̱nu li raylal a'in e̱re xban nak inc'a' neque'xnau ru lin Yucua' chi moco neque'xnau cuu la̱in. ");
INSERT INTO kekNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ac xinye e̱re chixjunil li c'a'ak re ru a'in re nak ta̱julticok' e̱re li c'a'ru xinye e̱re nak yo̱kex chixc'ulbal li raylal. La̱in inc'a' quinye chak e̱re junxil nak quintiquib chak lin c'anjel xban nak cuanquin e̱riq'uin. ");
INSERT INTO kekNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Anakcuan xic cui'chic cue riq'uin li quitaklan chak cue. Ut ma̱ jun e̱re napatz'oc cue bar xic cue. ");
INSERT INTO kekNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Xraho' sa' e̱ch'o̱l xban li c'a'ru xinye e̱re. ");
INSERT INTO kekNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Abanan la̱in xinye li xya̱lal e̱re. K'axal us chok' e̱re nak tinxic xban nak cui inc'a' ninxic, inc'a' ta̱cha̱lk li Santil Musik'ej e̱riq'uin. A'an li ta̱tenk'a̱nk e̱re ut a'an li ta̱c'ojoba̱nk re le̱ ch'o̱l. Nak tinxic, la̱in tintakla chak li Santil Musik'ej e̱riq'uin. ");
INSERT INTO kekNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nak ta̱cha̱lk li Santil Musik'ej, a'an tixc'utbesi chiruheb li cuanqueb sa' ruchich'och' nak inc'a' neque'xtau ru c'a'ru li ma̱c ut c'a'ru li ti̱quilal chi moco neque'xtau ru li rakba a̱tin li tixba̱nu li Dios. ");
INSERT INTO kekNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Inc'a' neque'xtau ru c'a'ru li ma̱c xban nak inc'a' niquine'xpa̱b. ");
INSERT INTO kekNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Inc'a' neque'xtau ru c'a'ru li ti̱quilal. Cui ta que'xtau ru te'xnau raj nak la̱in ti̱c inch'o̱l. Xban nak ti̱c inch'o̱l, tinxic riq'uin li Dios ut inc'a' chic te̱ril cuu. ");
INSERT INTO kekNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Inc'a' neque'xtau ru c'a'ru li rakba a̱tin. Cui ta que'xtau ru, te'xnau raj nak ac tenebanbil li rakba a̱tin sa' xbe̱n laj tza li nataklan sa' ruchich'och'. ");
INSERT INTO kekNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Toj cuan raj nabal chic li tinye e̱re, abanan inc'a' te̱cuy rabinquil anakcuan. ");
INSERT INTO kekNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Abanan nak ta̱cha̱lk li Santil Musik'ej, a'an tixc'ut che̱ru chixjunil li xya̱lal. Inc'a' ta̱a̱tinak yal xjunes. Tixye ban e̱re chixjunil li c'a'ru ta̱rabi riq'uin li Dios ut tixch'olob che̱ru li c'a'ru ta̱cha̱lk mokon. ");
INSERT INTO kekNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Li Santil Musik'ej tixq'ue inlok'al xban nak li c'a'ru tinye re, a'an ajcui' li tixch'olob xya̱lal che̱ru. ");
INSERT INTO kekNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Chixjunil li c'a'ru cuan re lin Yucua', cue ajcui' la̱in. Jo'can nak xinye e̱re nak li c'a'ru tinye e̱re, a'an ajcui' li tixc'utbesi che̱ru li Santil Musik'ej. ");
INSERT INTO kekNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","—Chi se̱b inc'a' chic te̱ril cuu. Abanan mokon chic te̱ril cui'chic cuu, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Cuanqueb lix tzolom yo̱queb chixyebal chi ribileb rib: —¿C'a'ru xya̱lal nak xye ke nak ta̱xic riq'uin lix yucua'? ¿C'a'ut nak xye ke nak chi se̱b inc'a' chic takil ru ut mokon chic takil cui'chic ru? ");
INSERT INTO kekNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿C'a'ut nak xye chi jo'can? Inc'a' nakatau ru c'a'ut nak quixye nak chi se̱b inc'a' chic takil ru, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Li Jesús quixnau nak que'raj xpatz'bal re c'a'ru xya̱lal li yo̱ chixyebal. Jo'can nak quixye reheb: —¿Ma yo̱quex chixpatz'bal che̱ribil e̱rib c'a'ru xya̱lal li xinye? ¿Ma inc'a' xetau ru nak xinye e̱re nak chi se̱b inc'a' chic te̱ril cuu ut mokon chic te̱ril cui'chic cuu? ¿Ma a'an li te̱raj xnaubal? ");
INSERT INTO kekNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Relic chi ya̱l ninye e̱re nak eb li inc'a' neque'pa̱ban cue ta̱sahok' sa' xch'o̱leb nak tinc'ul li raylal. La̱ex ta̱yot'ek' e̱ch'o̱l ut texya̱bak nak tinc'ul chi jo'can. Ta̱rahok' sa' e̱ch'o̱l, abanan mokon ta̱sahok' cui'chic sa' e̱ch'o̱l nak te̱ril cui'chic cuu. ");
INSERT INTO kekNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Junak ixk yo'la̱c re lix c'ula'al narec'a xrahil lix raylal. Abanan nak ac xyo'la lix c'ula'al, nasach sa' xch'o̱l li raylal li quixc'ul ut nasaho' sa' xch'o̱l xban nak ac xyo'la lix c'ula'al. ");
INSERT INTO kekNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Jo'can ajcui' la̱ex. Anakcuan ra sa' e̱ch'o̱l. Abanan nak te̱ril cui'chic cuu, ta̱sahok' sa' e̱ch'o̱l. Ut ma̱ ani ta̱isi̱nk che̱ru lix sahil e̱ch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ta̱cuulak xk'ehil nak ma̱c'a' chic te̱tz'a̱ma cue la̱in. Chiru ban chic lin Yucua' textz'a̱ma̱nk. Relic chi ya̱l tinye e̱re nak chixjunil li te̱tz'a̱ma chiru lin Yucua' sa' inc'aba' la̱in, a'an tixq'ue e̱re. ");
INSERT INTO kekNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Chalen anakcuan toj ma̱c'a' nequetz'a̱ma sa' inc'aba'. Chextz'a̱ma̱nk ut ta̱q'uehek' e̱re re nak k'axal cui'chic ta̱sahok' sa' e̱ch'o̱l, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Chixjunil li c'a'ak re ru a'in xinye e̱re sa' jaljo̱quil ru a̱tin. Abanan ta̱cuulak xk'ehil nak inc'a' chic tinye e̱re chi jaljo ru. Tinye ban e̱re chi tz'akal riq'uin a̱tin inc'a' ch'a'aj xtaubal ru ut tinch'olob che̱ru li xya̱lal chirix lin Yucua'. ");
INSERT INTO kekNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nak ta̱cuulak xk'ehil la̱ex chic textz'a̱ma̱nk chiru li Yucua'bej sa' inc'aba' la̱in. Inc'a' chic tento nak la̱in tintz'a̱ma̱nk chiru li Yucua'bej che̱rix la̱ex. ");
INSERT INTO kekNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Lin Yucua' nequexra la̱ex xban nak la̱ex niquine̱ra la̱in ut xban nak xepa̱b nak riq'uin li Dios xinchal chak. ");
INSERT INTO kekNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","La̱in riq'uin lin Yucua' xinchal chak. Ut anakcuan tincanab li ruchich'och' ut tinxic cui'chic riq'uin lin Yucua', chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ut eb lix tzolom que'xye re: —Anakcuan yo̱cat chi a̱tinac riq'uin a̱tin inc'a' ch'a'aj xtaubal ru. Inc'a' chic xaye ke riq'uin jaljo̱quil ru a̱tin. ");
INSERT INTO kekNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Anakcuan nakaq'ue retal nak la̱at nacanau chixjunil li c'a'ak re ru. Moco toj ta ta̱yehek' a̱cue. Jo'can nak nakapa̱b nak la̱at riq'uin li Dios xatchal chak, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Li Jesús quixye reheb: —¿Ma ya̱l nak niquine̱pa̱b anakcuan? ");
INSERT INTO kekNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Xcuulac xk'ehil, ut anakcuan ajcui', nak ta̱cha'cha'i̱k e̱ru che̱junilex. Ac xbe xbe li junju̱nk tixchap ut tine̱canab injunes. Abanan moco injunes ta xban nak lin Yucua' cua̱nk cuiq'uin. ");
INSERT INTO kekNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Xinye e̱re li c'a'ak re ru a'in re nak texcua̱nk cuiq'uin ut ta̱cua̱nk e̱riq'uin li tuktu̱quilal. Sa' li ruchich'och' te̱c'ul li raylal. Abanan cacuubresihomak le̱ ch'o̱l xban nak la̱in ac xinnumta sa' xbe̱n li nataklan sa' ruchich'och', chan li Jesús reheb lix tzolom. ");
INSERT INTO kekNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nak quirake' xyebal li a̱tin a'in, li Jesús quixtaksi li riloba̱l ut qui-oc chi tijoc. Quixye: —At inYucua', xcuulac xk'ehil nak tincamsi̱k. Ta̱q'ue taxak inlok'al la̱in li C'ajolbej re nak la̱in tinq'ue ajcui' a̱lok'al la̱at. ");
INSERT INTO kekNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","La̱at xatq'uehoc incuanquil sa' xbe̱n chixjunil re nak tinq'ue li junelic yu'am reheb li xak'axtesiheb cue. ");
INSERT INTO kekNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Li junelic yu'am, a'an nak te'xnau a̱cuu la̱at li junajat chi tz'akal Dios ut te'xnau ajcui' cuu la̱in li Jesucristo li quina̱takla chak. ");
INSERT INTO kekNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","La̱in xinq'ue a̱lok'al arin sa' ruchich'och' xban nak xinchoy xba̱nunquil li c'anjel li xaq'ue cue re tinba̱nu. ");
INSERT INTO kekNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","At inYucua', chaq'ue ta cui'chic lin lok'al li quicuan nak toj cuanquin chak a̱cuiq'uin nak toj ma̱ji' naticla chak li ruchich'och'. ");
INSERT INTO kekNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Eb li xasiq'ueb ru sa' ruchich'och' xak'axtesiheb cue. La̱in xinc'ut chiruheb chi tz'akal anihat la̱at ut xinch'olob li xya̱lal chiruheb. Ut eb a'an xe'xba̱nu li c'a'ru xaye reheb. ");
INSERT INTO kekNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Anakcuan neque'xnau nak chixjunil li c'a'ru xinba̱nu, la̱at xatq'uehoc cue chixba̱nunquil. ");
INSERT INTO kekNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","La̱in xinye reheb li c'a'ru xaye cue ut xe'xc'ul li cua̱tin. Xe'xq'ue retal nak relic chi ya̱l a̱cuiq'uin xinchal chak ut xe'xpa̱b nak la̱at xattaklan chak cue. ");
INSERT INTO kekNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","La̱in inc'a' yo̱quin chixtz'a̱manquil a̱cue nak ta̱tenk'aheb li inc'a' xine'xpa̱b. Yo̱quin ban chixtz'a̱manquil cha̱cuu nak ta̱tenk'aheb lin tzolom li xak'axtesiheb cue xban nak a'aneb la̱ cualal a̱c'ajol. ");
INSERT INTO kekNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Chixjunileb li cualal inc'ajol, a̱cualal a̱c'ajol ajcui' la̱at. Ut chixjunileb la̱ cualal a̱c'ajol, cualal inc'ajol ajcui' la̱in. Ut eb a'an neque'xnima inlok'al. ");
INSERT INTO kekNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Anakcuan la̱in tinxic a̱cuiq'uin. Inc'a' chic tincua̱nk sa' ruchich'och'. Abanan eb a'an toj te'cua̱nk sa' ruchich'och'. At inYucua', la̱at Santo. Chacuileb taxak riq'uin lix nimal la̱ cuanquilal li xak'axtesiheb cue re nak junajak ruheb jo' la̱at ut la̱in junaj ku. ");
INSERT INTO kekNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nak cuanquin sa' xya̱nkeb, riq'uin xnimal la̱ cuanquil xincuileb lin tzolom li xak'axtesiheb cue ut ma̱ jun xsach chicuu. Ca'aj cui' li jun xsach li ac q'uebil chak re sachc. A'in xc'ulman re nak ta̱tz'aklok ru li tz'i̱banbil sa' li Santil Hu. ");
INSERT INTO kekNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Anakcuan xic cue a̱cuiq'uin. Abanan yo̱quin chixyebal li c'a'ak re ru a'in nak toj cuanquin sa' ruchich'och' re nak ta̱cua̱nk xsahil xch'o̱leb a'an jo' li xsahil inch'o̱l la̱in. ");
INSERT INTO kekNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","La̱in xinch'olob xya̱lal la̱ cua̱tin chiruheb. Jo'can nak xic' neque'ile' xbaneb li inc'a' neque'pa̱ban. Xic' neque'ile' xban nak moco xcomoneb ta chic ut moco juntak'e̱t ta chic lix na'lebeb. Jo'can ajcui' la̱in. Moco la̱in ta xcomoneb li cuanqueb sa' ruchich'och'. ");
INSERT INTO kekNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Inc'a' yo̱quin chixtz'a̱manquil cha̱cuu nak ta̱cuisiheb lin tzolom sa' ruchich'och'. Ca'aj cui' yo̱quin chixtz'a̱manquil cha̱cuu nak ta̱coleb chiru laj tza. ");
INSERT INTO kekNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","La̱in ma̱cua'in xcomoneb li cuanqueb sa' ruchich'och'. Jo'can ajcui' eb a'an. Ma̱cua'eb chic xcomoneb li inc'a' neque'pa̱ban. ");
INSERT INTO kekNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Chasantobresiheb taxak riq'uin la̱ cua̱tin, xban nak a'an li tz'akal ya̱l. ");
INSERT INTO kekNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Jo' nak xina̱takla chak la̱in sa' ruchich'och' chixch'olobanquil li xya̱lal, jo'can ajcui' nak tintaklaheb chixch'olobanquil li xya̱lal chiruheb li inc'a' neque'pa̱ban. ");
INSERT INTO kekNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Sa' xc'aba' eb a'an xink'axtesi cuib la̱in chixba̱nunquil li c'a'ru xaye cue. Ut sa' xc'aba' li ya̱l li xinye eb a'an te'xk'axtesi ajcui' ribeb chixba̱nunquil li c'a'ru nacacuaj. ");
INSERT INTO kekNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ma̱cua' ca'aj cui' chirixeb lin tzolom yo̱quin chi tz'a̱ma̱nc cha̱cuu. Yo̱quin aj ban cui' chi tz'a̱ma̱nc cha̱cuu chirixeb li te'pa̱ba̱nk mokon nak te'xch'olob li xya̱lal chiruheb. ");
INSERT INTO kekNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","At inYucua', li c'a'ru nintz'a̱ma cha̱cuu, a'an nak junajak taxak ruheb. Che'cua̱nk kiq'uin jo' nak cuanquin la̱in a̱cuiq'uin ut la̱at cuancat cuiq'uin. Junajak taxak ruheb re nak li cuanqueb sa' ruchich'och' te'xpa̱b nak la̱at xattaklan chak cue. ");
INSERT INTO kekNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","La̱in xinq'ueheb lix lok'al jo' nak xaq'ue inlok'al la̱in re nak junajak ruheb jo' nak junaj ku la̱o. ");
INSERT INTO kekNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","La̱in cua̱nkin riq'uineb ut la̱at cua̱nkat cuiq'uin re nak junajak chic ruheb chi tz'akal kiq'uin. Ut xban nak junajak chic ruheb kiq'uin, eb li inc'a' neque'pa̱ban te'xq'ue retal nak la̱at xattaklan chak cue ut te'xq'ue ajcui' retal nak la̱at nacaraheb jo' nak niquina̱ra la̱in. ");
INSERT INTO kekNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","At inYucua', nintz'a̱ma cha̱cuu nak chixjunileb li xak'axtesiheb cue te'cua̱nk cuiq'uin sa' li na'ajej li tincua̱nk cui' la̱in. Nacuaj nak te'ril lin lok'al li caq'ue chak cue nak toj ma̱ji' quiyi̱ba̱c li ruchich'och' xban nak niquina̱ra. ");
INSERT INTO kekNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","At inYucua', la̱at ti̱c a̱ch'o̱l. Eb li inc'a' neque'pa̱ban inc'a' neque'xnau a̱cuu. Abanan la̱in ninnau a̱cuu ut eb lin tzolom neque'xnau chic nak la̱at xattaklan chak cue. ");
INSERT INTO kekNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","La̱in xinc'ut chiruheb anihat la̱at ut toj tinch'olob cui'chic chiruheb re nak te'rahok jo' nak niquina̱ra la̱at, ut la̱in tincua̱nk riq'uineb, chan li Jesús nak quitijoc. ");
INSERT INTO kekNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Nak quirake' chi tijoc li Jesús, qui-el sa' li na'ajej a'an rochbeneb lix tzolom. Co̱eb jun pac'al li ha' Cedrón xc'aba' bar cuan cui' jun si̱r li acui̱mk. ");
INSERT INTO kekNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Laj Judas Iscariote, li ta̱k'axtesi̱nk re li Jesús, naxnau li na'ajej a'an xban nak nabal sut quicuulac li Jesús aran rochbeneb lix tzolom. ");
INSERT INTO kekNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Jo'can nak laj Judas co̱ sa' li na'ajej a'an ut quixc'am chirix jun ch'u̱tal li soldado aj Roma. Ut co̱eb ajcui' chirixeb li neque'c'ac'alen sa' li templo. Taklanbileb xbaneb laj fariseo ut li xbe̱nil aj tij. Cuan cuanqueb xxameb sa' ruk' ut cuan cuanqueb xxameb sa' ru'uj che' ut cuanqueb ajcui' xch'i̱ch'eb. ");
INSERT INTO kekNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Li Jesús ac naxnau chixjunil li c'a'ru tixc'ul. Jo'can nak quichal ut quixakli chiruheb ut quixye: —¿Ani nequesic'? chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Eb a'an que'xye: —Yo̱co chixsic'bal li Jesús laj Nazaret.— Li Jesús quixye: —La̱in li yo̱quex chinsic'bal, chan. Cuan ajcui' sa' xya̱nkeb laj Judas li ta̱k'axtesi̱nk re. ");
INSERT INTO kekNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nak li Jesús quixye reheb, “La̱in li yo̱quex chinsic'bal”, k'a̱jel ix nak que'co̱eb ut jun t'aniqueb nak que't'ane' chi ch'och'. ");
INSERT INTO kekNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ut li Jesús quixye cui'chic reheb: —¿Ani nequesic'? Que'chak'oc ut que'xye re: —Li Jesús laj Nazaret, a'an li yo̱co chixsic'bal.— ");
INSERT INTO kekNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Li Jesús quixye reheb: —Ac xinye e̱re nak la̱in. Cui yo̱quex chinsic'bal la̱in, canabomakeb chi xic li neque'ta̱ken cue, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Quixye chi jo'can re nak ta̱tz'aklok ru li quixye nak quitijoc: At inYucua', ma̱ jun reheb li cak'axtesiheb cue xsach chicuu. ");
INSERT INTO kekNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Laj Simón Pedro cuan xch'i̱ch'. Quirisi chak lix ch'i̱ch' sa' xna'aj. Ut riq'uin lix ch'i̱ch' quirisi lix xic laj Malco lix mo̱s li xyucua'il aj tij. Li xic li quixyoc', a'an li cuan sa' xnim. ");
INSERT INTO kekNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Li Jesús quixye re laj Pedro: —Xoc la̱ ch'i̱ch' sa' xna'aj. ¿Ma inc'a' ta bi' tento nak tinc'ul li raylal a'in? ¿Ma inc'a' ta bi' a'an aj e nak xinixtakla chak lin Yucua'? chan. ");
INSERT INTO kekNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ut eb li soldado aj Roma rochben li nataklan sa' xbe̱neb ut eb laj judío li neque'c'ac'alen sa' li templo, que'xchap li Jesús ut que'xbac'. ");
INSERT INTO kekNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Que'xc'am riq'uin laj Anás lix yucua' li rixakil laj Caifás. Laj Caifás, a'an li xbe̱nil aj tij sa' li chihab a'an. ");
INSERT INTO kekNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Laj Caifás a'an li quiyehoc reheb li neque'taklan sa' xbe̱neb laj judío nak us raj nak ta̱ca̱mk jun chi cui̱nk sa' xc'aba'eb chixjunileb. ");
INSERT INTO kekNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Nak yo̱queb chixc'ambal li Jesús, laj Simón Pedro rochben jun chic lix tzolom li Jesús yo̱queb chixta̱kenquil. Li tzolom a'an nana'e' ru xban li xyucua'il aj tij. Jo'can nak qui-oc rochben li Jesús sa' li neba̱l li cuan chiru li rochoch li xyucua'il aj tij. ");
INSERT INTO kekNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Abanan laj Pedro quicana sa' be chire li oqueba̱l. Ut lix tzolom jun chic qui-el sa' li neba̱l li cuan chiru li cab ut quia̱tinac riq'uin li ixk li nac'ac'alen re li oqueba̱l. Ut quirocsi laj Pedro chi sa'. ");
INSERT INTO kekNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ut li ixk, li nac'ac'alen re li oqueba̱l quixye re laj Pedro, —¿Ma ma̱cua' ta bi' la̱at jun reheb lix tzolom li cui̱nk a'an? chan re. Laj Pedro quichak'oc ut quixye: —Inc'a'. Ma̱cua'in.— ");
INSERT INTO kekNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Eb laj c'anjel ut eb li neque'c'ac'alen sa' li templo que'xtz'ab xxameb xban nak que te'rec'a. Xakxo̱queb chi k'ixi̱nc chire xam. Laj Pedro yo̱ ajcui' chi k'ixi̱nc sa' xya̱nkeb. ");
INSERT INTO kekNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Li xyucua'il aj tij qui-oc chixpatz'bal re li Jesús chirixeb lix tzolom ut chirix ajcui' li tijleb li naxc'ut. ");
INSERT INTO kekNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Li Jesús quixye re: —Junelic xinch'olob li xya̱lal chiruheb li tenamit sa' eb li cab li neque'xch'utub cui' ribeb laj judío ut sa' li templo. Ma̱c'a' xinye reheb chi mukmu. ");
INSERT INTO kekNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿C'a'ut nak nacapatz' cue la̱in? Patz' reheb li neque'abin cue. Eb a'an naru neque'xye e̱re c'a'ru xinye, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Nak quixye a'an, jun reheb li neque'c'ac'alen sa' li templo quixsac' sa' xnak' ru li Jesús ut quixye re: —¿C'a'ut nak nacasume li xyucua'il aj tij chi jo'can? chan re. ");
INSERT INTO kekNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Li Jesús quixye re: —Cui inc'a' us li xinye, ye reheb li cuanqueb arin c'a'ru inc'a' us xinye. Cui ut us li xinye, ¿c'a'ut nak niquina̱sac'? chan re. ");
INSERT INTO kekNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ut laj Anás quixtakla li Jesús chi bac'bo riq'uin laj Caifás li xyucua'il aj tij. ");
INSERT INTO kekNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Laj Pedro toj xakxo chi k'ixi̱nc chire xam. Ut que'xye cui'chic re: —¿Ma ma̱cua' ta bi' la̱at xcomoneb lix tzolom li cui̱nk a'an? Ut laj Pedro quitic'ti'ic ut quixye: —Inc'a'. Ma̱cua'in.— ");
INSERT INTO kekNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Jun lix mo̱s li xyucua'il aj tij rech'alal li cui̱nk li quiyoq'ue' xxic xban laj Pedro, quixye re: —La̱at xcomoneb. ¿Ma inc'a' ta bi' xcuil nak a̱cuochben aran sa' li xna'aj li acui̱mk? chan. ");
INSERT INTO kekNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ut laj Pedro quixye cui'chic re: —Inc'a'. Ma̱cua'in, chan. Toje' ajcui' ta̱rakek' xyebal a'an nak quiya̱bac laj tzo' xul. ");
INSERT INTO kekNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Toj ek'ela chi us que'risi li Jesús riq'uin laj Caifás ut que'xc'am sa' li na'ajej li narakoc cui' a̱tin laj Pilato li acuabej aj Roma. Eb li neque'taklan sa' xbe̱neb laj judío inc'a' que'oc sa' li rochoch laj Pilato xban nak a'an ma̱cua' aj judío. Cui ta que'oc sa' rochoch junak ma̱cua' aj judío, que'xmux raj rib sa' lix pa̱ba̱leb. Xban nak que'raj cua'ac re li nink'e Pascua, inc'a' que'ru chi oc sa' li cab a'an. ");
INSERT INTO kekNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Xban nak inc'a' que'oc sa' li cab, laj Pilato qui-el chirix cab ut quixye reheb: —¿C'a'ru xma̱c li cui̱nk a'in nak xexchal chixjitbal? chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Que'chak'oc ut que'xye re: —Cui ta ma̱c'a' xma̱c, inc'a' raj xkac'am chak a̱cuiq'uin re nak tatrakok a̱tin sa' xbe̱n, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Laj Pilato quixye reheb: —C'amomak la̱ex ut rakomak a̱tin sa' xbe̱n jo' naxye sa' le̱ chak'rab la̱ex, chan. Eb laj judío que'xye re: —Moco q'uebil ta kalese̱ns la̱o aj judío nak takacamsi junak cristian, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Riq'uin a'in quitz'akloc ru li quixye li Jesús chanru nak ta̱camsi̱k. ");
INSERT INTO kekNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Laj Pilato qui-oc cui'chic sa' li na'ajej li narakoc cui' a̱tin. Quixbok li Jesús riq'uin ut quixye re: —¿Ma la̱at lix reyeb laj judío? chan re. ");
INSERT INTO kekNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Li Jesús quixye re: —¿Ma sa' a̱ch'o̱l x-ala li xaye, malaj jalan xyehoc a̱cue li xaye? chan. ");
INSERT INTO kekNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Laj Pilato quixye re: —¿Ma la̱in ta bi' aj judío? Eb la̱ cuech tenamitil rochbeneb li xbe̱nil aj tij, a'aneb li xe'k'axtesin a̱cue sa' cuuk'. Ye cue c'a'ru a̱ma̱c, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Li Jesús quixye re: —Lin cuanquil la̱in ma̱cua' re sa' ruchich'och'. Cui ta la̱in tintakla̱nk arin sa' ruchich'och', eb li neque'ta̱ken cue te'pletik raj re incolbal chiruheb li neque'c'amoc be chiruheb laj judío. Abanan lin cuanquil la̱in ma̱cua' re sa' ruchich'och', chan. ");
INSERT INTO kekNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Laj Pilato quixye re: —La̱at rey chi jo'canan.— Li Jesús quixye re: —Ya̱l li xaye nak la̱in rey. A'an aj e nak quinchal chi yo'la̱c arin sa' ruchich'och' re xch'olobanquil li xya̱lal. Ut chixjunileb li neque'raj xnaubal li xya̱lal, neque'rabi li c'a'ru ninye, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Laj Pilato quixye: —Ut, ¿c'a'ru li xya̱lal?— Ut co̱ cui'chic riq'uineb laj judío ut quixye reheb: —Ma̱ jun xma̱c li cui̱nk a'in nintau. ");
INSERT INTO kekNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","La̱ex c'aynakex nak na-ach'aba̱c junak li pre̱x sa' li nink'e Pascua. ¿Ma te̱raj nak tincuach'ab che̱ru le̱ rey la̱ex aj judío? chan laj Pilato. ");
INSERT INTO kekNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Eb a'an que'xjap re ut que'xye: —Inc'a'. Ma̱cuach'ab li cui̱nk a'an. Ach'ab laj Barrabás, chanqueb. Laj Barrabás, a'an jun aj e̱lk'. ");
INSERT INTO kekNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Laj Pilato quixtakla li Jesús chi saq'uec' riq'uin tz'u̱m. ");
INSERT INTO kekNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Eb li soldado que'xyi̱b jun li corona riq'uin q'uix ut que'xq'ue sa' xjolom li Jesús. Ut que'xq'ue jun li caki t'icr chirix xcomon li neque'rocsi li rey. ");
INSERT INTO kekNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ut que'xye re: —¡Sahak taxak sa' a̱ch'o̱l, at xreyeb laj judío! chanqueb re. Ut que'xsac' riq'uin ruk'eb. ");
INSERT INTO kekNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Laj Pilato co̱ cui'chic riq'uineb laj judío ut quixye reheb: —Xinc'am chak arin chirix cab re nak te̱nau nak ma̱ jun xma̱c xintau, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ut li Jesús qui-el chirix cab. Cuan sa' xjolom li corona li yi̱banbil riq'uin q'uix ut cuan li caki t'icr chirix. Laj Pilato quixye reheb: —Cue' li cui̱nk. Ilomak, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Eb li neque'c'ac'alen sa' li templo ut eb li xbe̱nil aj tij que'ril li Jesús ut que'xjap reheb ut que'xye: —¡Q'ue chiru cruz! ¡Q'ue chiru cruz! chanqueb. Ut laj Pilato quixye reheb: —C'amomak la̱ex ut q'uehomak chiru cruz cui te̱raj. La̱in ma̱ jun lix ma̱c xintau, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Abanan eb laj judío que'xye: —La̱o cuan kachak'rab ut li kachak'rab naxye nak ta̱camsi̱k xban nak a'an quixq'ue rib chok' Ralal li Dios.— ");
INSERT INTO kekNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nak quirabi li que'xye, k'axal cui'chic quixucuac laj Pilato. ");
INSERT INTO kekNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Qui-oc cui'chic sa' cab rochben li Jesús ut quixye re: —Ye cue bar xatchal chak.— Abanan li Jesús ma̱ jun li a̱tin quixye. ");
INSERT INTO kekNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Laj Pilato quixye re: —¿C'a'ut nak inc'a' nacatchak'oc? ¿Ma inc'a' nacanau nak cuan incuanquil cha̱q'uebal chiru cruz ut cuan incuanquil cha̱cuach'abanquil? chan re li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Li Jesús quixye re: —Ma̱c'a' raj a̱cuanquil sa' inbe̱n cui ta inc'a' q'uebil a̱cue xban li Dios. Ut li jun li xk'axtesin cue sa' a̱cuuk' re nak tatrakok a̱tin sa' inbe̱n, a'an k'axal cui'chic nim xma̱c cha̱cuu la̱at, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ut chalen a'an laj Pilato yo̱ chixsic'bal chanru nak ta̱rach'ab li Jesús. Abanan eb laj judío que'xjap reheb ut que'xye: —Cui nacacuach'ab li cui̱nk a'an, la̱at ma̱cua'akat chic rami̱g li Acuabej César. Li ani naraj xq'uebal rib chok' rey, li jun a'an xic' chic naril li Acuabej, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Nak laj Pilato quirabi li que'xye, quixc'am li Jesús chirix cab. Quic'ojla sa' li na'ajej li narakoc cui' a̱tin. Li c'ojleba̱l a'an cuan sa' xbe̱n li tusbil pec. C'ajo' xch'ina'usal. Gabata xc'aba' li na'ajej a'an sa' li a̱tinoba̱l hebreo. ");
INSERT INTO kekNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Cua'leb na re cutan nak quic'ulman a'in. Li tenamit yo̱queb chixcauresinquil li nink'e Pascua, li ta̱ticla̱k sa' li cutan jun chic. Laj Pilato quixye reheb: —Cue' le̱ rey, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Que'xjap cui'chic reheb chixyebal: —¡Q'ueomak chiru cruz! ¡Q'uehomak chiru cruz! Ut laj Pilato quixye reheb: —¿Ma te̱raj nak tinq'ue chiru cruz le̱ rey? chan. Eb li xbe̱nil aj tij que'xye: —Jun ajcui' li karey cuan. A'an li Acuabej César, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Laj Pilato quixk'axtesi li Jesús sa' ruk'eb li soldado re nak ta̱q'uehek' chiru cruz. Ut que'xc'am li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Li Jesús yo̱ chixpakonquil lix cruz nak co̱ sa' li na'ajej Xbakel Xjolom Camenak xc'aba'. Sa' li a̱tinoba̱l hebreo Gólgota xc'aba'. ");
INSERT INTO kekNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ut aran que'xq'ue chiru cruz. Ut que'xq'ue cuib chic li cui̱nk chiru cruz rochben. Jun que'xq'ue sa' xnim uk' ut li jun chic que'xq'ue sa' xtz'e. Li cruz li que'xq'ue cui' li Jesús quicana sa' xyi. ");
INSERT INTO kekNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Laj Pilato quixtz'i̱ba jun li retalil ut que'xq'ue sa' xjolom li cruz li quiq'uehe' cui' li Jesús. Li retalil a'an quixye: Li Jesús aj Nazaret, a'an lix reyeb laj judío. ");
INSERT INTO kekNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Nabaleb laj judío que'ril li retalil li quitz'i̱ba̱c, xban nak li na'ajej li quiq'uehe' cui' chiru cruz li Jesús nach' cuan riq'uin li tenamit. Li retalil tz'i̱banbil sa' eb li a̱tinoba̱l hebreo, griego ut latín. ");
INSERT INTO kekNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Inc'a' quicuulac chiruheb lix xbe̱nil aj tij li quixtz'i̱ba. Que'xye re laj Pilato: —Ma̱tz'i̱ba nak a'an xreyeb laj judío. Tz'i̱ba ban nak a'an xyehoc re, “La̱in xreyeb laj judío”, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ut laj Pilato quixye reheb: —Li c'a'ru xintz'i̱ba, xintz'i̱ba. Inc'a' chic ta̱jalma̱nk, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nak ac xe'xq'ue chiru cruz li Jesús, eb li soldado que'xc'am li rak' chok' reheb. Ca̱hib e̱chal que'risi, jun re li junju̱nk chi soldado. Ut que'xc'am ajcui' li rak' li ma̱c'a' xbojbal. Junaj ru lix quembal. ");
INSERT INTO kekNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Que'xye chi ribileb rib: —Inc'a' takapeji. Us takabu̱li rix re rilbal ani ta̱e̱chani̱nk re, chanqueb. Jo'can que'xba̱nu re nak ta̱tz'aklok ru li tz'i̱banbil sa' li Santil Hu li naxye chi jo'ca'in: Que'xjeq'ui chirixeb lin t'icr ut que'xbu̱li rix li cuak'. (Sal. 22:18) ");
INSERT INTO kekNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Nach' riq'uin li cruz xakxo li xna' li Jesús rochben lix María li ras. A'an li rixakil laj Cleofas. Ut cuan ajcui' aran lix María, Magdala xtenamit. ");
INSERT INTO kekNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Li Jesús quiril lix na' ut quiril ajcui' lix tzolom li raro xban. Li Jesús quixye re lix na': —At inna', li cui̱nk a'in, a'an chic la̱ yum.— ");
INSERT INTO kekNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ut quixye re lix tzolom: —Li ixk a'in, a'an chic la̱ na'.— Ut chalen a'an lix tzolom quixc'ul lix na' li Jesús riq'uin sa' li rochoch. ");
INSERT INTO kekNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Chirix chic a'an quixnau li Jesús nak ac xtz'akloc ru chixjunil. Re nak ta̱tz'aklok ru li tz'i̱banbil sa' li Santil Hu, li Jesús quixye: —Ta̱chakik cue, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Cuan aran jun sec' nujenak chi vinagre. Que'xtz'a sa' li vinagre jun li esponja ut que'xtaksi sa' ru'uj jun li ruk' che' hisopo xc'aba' ut que'xq'ue sa' re. ");
INSERT INTO kekNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Li Jesús quiruc' li vinagre ut quixye: —Anakcuan xtz'akloc ru chixjunil.— Quixxulub lix jolom ut quicam. ");
INSERT INTO kekNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Eb li neque'taklan sa' xya̱nkeb laj judío que'xtz'a̱ma chiru laj Pilato re nak tixtakla xtokbal xbakel li ra'eb li que'q'uehe' chiru cruz re nak te'ca̱mk chi junpa̱t. Que'raj nak te'isi̱k chiru cruz xban nak cuulac re li hiloba̱l cutan. Yo̱queb chixcauresinquil ribeb re li nink'e Pascua xban nak a'an li k'axal lok' chiruheb. ");
INSERT INTO kekNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Que'chal eb li soldado ut que'xtok xbakel li ra'eb li cuib chi cui̱nk li que'q'uehe' chiru cruz rochben li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Abanan nak que'cuulac cuan cui' li Jesús, que'ril nak ac xcam ut inc'a' que'xtok xbakel li ra'. ");
INSERT INTO kekNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Jun li soldado quixhop xc'atk xsa' riq'uin lix ch'i̱ch' ut sa' junpa̱t qui-el li quic' ut qui-el ajcui' li ha'. ");
INSERT INTO kekNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","La̱in quin-iloc re chi tz'akal li c'a'ru quic'ulman ut li c'a'ru yo̱quin xyebal e̱re tz'akal ya̱l. Yo̱quin chixyebal e̱re a'in re nak te̱pa̱b nak tz'akal ya̱l nak quic'ulman chi jo'can. ");
INSERT INTO kekNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Quic'ulman chi jo'can re nak ta̱tz'aklok ru li tz'i̱banbil sa' li Santil Hu: Ma̱ jun lix bakel ta̱tokma̱nk. (Ex. 12:46) ");
INSERT INTO kekNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ut tz'i̱banbil ajcui' sa' li Santil Hu: Eb a'an te'ril li ani quihope' chi ch'i̱ch'. (Zac. 12:10) ");
INSERT INTO kekNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Jun li cui̱nk aj José xc'aba' Arimatea xtenamit quicuulac riq'uin laj Pilato chixtz'a̱manquil chiru nak tixq'ue lix tz'ejcual li Jesús re, re tixmuk. Laj José, a'an jun reheb li neque'pa̱ban re li Jesús. Abanan inc'a' quixye xban nak quixucuac xbaneb li neque'taklan sa' xbe̱neb laj judío. Laj Pilato quixye re nak ta̱ru̱k tixmuk, ut laj José co̱ chixc'ambal li camenak. ");
INSERT INTO kekNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Laj Nicodemo li quicuulac riq'uin li Jesús chi k'ek, co̱ rochben laj José. Quixc'am na o'c'a̱lak (100) libra li sununquil ban yi̱banbil riq'uin mirra ut áloes. ");
INSERT INTO kekNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Li cuib chi cui̱nk que'xc'am lix tz'ejcual li Jesús ut que'xlan riq'uin li cha̱bil t'icr lino ut que'xq'ue li sununquil ban jo' c'aynakeb chi mukuc eb laj judío. ");
INSERT INTO kekNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Sa' li na'ajej li quiq'uehe' cui' li Jesús chiru cruz cuan jun si̱r li acui̱mk. Aran cuan jun li mukleba̱l toj ac'. Toj ma̱ ani mukbil aran. ");
INSERT INTO kekNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Aran que'xmuk li Jesús xban nak nach' cuan li na'ajej a'an ut que'raj ru xmukbal chi junpa̱t xban nak cuulac re li hiloba̱l cutan. ");
INSERT INTO kekNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sa' li xbe̱n li cutan re li xama̱n nak toj ma̱ji' nasake̱u co̱ lix María Magdala xtenamit sa' li mukleba̱l. Nak quicuulac cuan cui' li mukleba̱l, quixq'ue retal nak ac isinbil chic li nimla pec li que'xq'ue chire li mukleba̱l. ");
INSERT INTO kekNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Co̱ sa' a̱nil riq'uin laj Simón Pedro ut riq'uin li jun chic xtzolom li Jesús li raro xban, ut quixye reheb: —Xe'risi li Ka̱cua' sa' li mukleba̱l ut inc'a' nakanau bar ta xe'xq'ue, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Co̱eb sa' li mukleba̱l laj Pedro rochben li jun chic xtzolom li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Co̱eb sa' a̱nil xcabichaleb. Ut lix tzolom jun chic k'axal cau quia̱linac chiru laj Pedro ut a'an xbe̱n cua quicuulac sa' li mukleba̱l. ");
INSERT INTO kekNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Quixc'utzub rib chi iloc chi sa'. Quiril li t'icr li que'xlan cui' li Jesús. Abanan inc'a' qui-oc toj chi sa'. ");
INSERT INTO kekNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Quicuulac laj Pedro toj chi ixbej. Ticto qui-oc chi sa' li mukleba̱l ut quiril li t'icr sok'so aran. ");
INSERT INTO kekNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Cuan ajcui' aran li t'icr li que'xbac' cui' lix jolom li Jesús. Moco cuan ta sa' xya̱nk li t'icr. Jalan basbo cui' xjunes. ");
INSERT INTO kekNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ut qui-oc ajcui' chi sa' li mukleba̱l li tzolom li quicuulac xbe̱n cua. Quiril li t'icr aran ut quixpa̱b nak ac xcuacli cui'chic chi yo'yo li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Toj ma̱ji' que'xtau ru chi tz'akal li tz'i̱banbil sa' li Santil Hu li naxye nak tento ta̱cuacli̱k cui'chic chi yo'yo sa' xya̱nkeb li camenak. ");
INSERT INTO kekNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ut eb lix tzolom que'suk'i cui'chic sa' li cab li cuanqueb cui'. ");
INSERT INTO kekNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Lix María cuan chire li mukleba̱l. Yo̱ chi ya̱bac. Quixc'utzub rib chi iloc chi sa' li mukleba̱l. ");
INSERT INTO kekNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Quiril cuib li ángel sak li rak'eb. C'ojc'o̱queb aran bar quicuan cui' li Jesús. Jun cuan sa' xjolom ut jun cuan chi rok. ");
INSERT INTO kekNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Que'xye re: —At ixk, ¿c'a'ut nak yo̱cat chi ya̱bac?— Lix María quixye reheb: —Yo̱quin chi ya̱bac xban nak xe'risi li Ka̱cua' arin ut inc'a' ninnau bar xe'xq'ue.— ");
INSERT INTO kekNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Sa' li ho̱nal a'an, lix María qui-iloc chirix ut quiril li Jesús xakxo aran, abanan inc'a' quixnau nak a'an ta li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Li Jesús quixye re: —At ixk, ¿c'a'ut nak yo̱cat chi ya̱bac? ¿Ani nacasic'? chan. Sa' xch'o̱l lix María nak a'an aj ilol acui̱mk ut quixye re: —Ka̱cua', cui la̱at xatc'amoc re, ba̱nu usilal, ye cue bar xaq'ue re nak tinc'am, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Li Jesús quixye re: —¡María!— Quixsuk'isi rib lix María ut quixye sa' ra̱tinoba̱l aj hebreo: —Raboni.— (Chi jalbil ru naraj naxye aj tzolonel). ");
INSERT INTO kekNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Li Jesús quixye re: —Mina̱bay. Canabin chi xic. Tento nak tinxic riq'uin lin Yucua'. Ayu ut ye reheb lin herma̱n nak xic cue riq'uin lin Yucua'. A'an ajcui' le̱ yucua' la̱ex. A'an lin Dios ut a'an ajcui' le̱ Dios la̱ex, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Co̱ lix María ut quixye reheb lix tzolom li Jesús nak quiril ru li Ka̱cua' Jesús ut quixye ajcui' reheb chixjunil li quiyehe' re xban. ");
INSERT INTO kekNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Sa' li xbe̱n cutan re li xama̱n, nak ac oc re li k'ojyi̱n, que'xch'utub ribeb lix tzolom li Jesús. Tz'aptz'o chi us lix puertil li cab li ch'utch'u̱queb cui' xban nak que'xucuac xbaneb li neque'taklan sa' xbe̱neb laj judío. Xaka̱mil li Jesús chiruheb ut quixye reheb: —Chicua̱nk taxak li tuktu̱quil usilal e̱riq'uin, chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ut quixc'ut chiruheb li ruk' ut lix c'atk xsa' li quihope'. C'ajo' nak que'saho' sa' xch'o̱leb lix tzolom nak que'ril cui'chic ru li Ka̱cua'. ");
INSERT INTO kekNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Li Jesús quixye cui'chic reheb: —Chicua̱nk taxak li tuktu̱quil usilal e̱riq'uin. Jo' nak xinixtakla chak lin Yucua' la̱in, jo'can ajcui' nak texintakla la̱ex, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ut nak quixye a'an, quirapuheb ut quixye reheb: —C'ulumak li Santil Musik'ej. ");
INSERT INTO kekNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Li ani te̱cuy xma̱c la̱ex, ta̱cuyek' ajcui' xma̱c xban li Dios. Ut li ani inc'a' te̱cuy xma̱c la̱ex, inc'a' ajcui' ta̱cuyek' xma̱c xban li Dios, chan li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Laj Tomás, a'an jun reheb lix tzolom cablaju, li neque'xye ajcui' lut re. A'an ma̱ ani sa' xya̱nkeb nak quixc'utbesi rib li Jesús chiruheb. ");
INSERT INTO kekNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Li rech aj tzolonelil que'xye re: —Xkil ru li Ka̱cua', chanqueb re. Abanan laj Tomás quixye reheb: —Cui inc'a' tincuil li retalil li claux sa' ruk' ut cui inc'a' tinq'ue li ru'uj cuuk' sa' xna'aj li claux ut cui inc'a' tinch'ic li cuuk' sa' xc'atk xsa', la̱in inc'a' tinpa̱b nak xcuacli cui'chic chi yo'yo, chan laj Tomás. ");
INSERT INTO kekNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ac xnume' chic cuukub cutan nak que'xch'utub cui'chic ribeb lix tzolom li Jesús. Laj Tomás cuan sa' xya̱nkeb. Tz'aptz'o̱queb lix puertil li cab chi us. Nak que'ril ac xaka̱mil li Jesús chiruheb ut quixye reheb: —Chicua̱nk taxak li tuktu̱quil usilal e̱riq'uin, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tojo'nak quixye re laj Tomás: —Il chi us li cuuk'. Ch'ic li ru'uj la̱ cuuk' arin sa' xna'aj li claux. Ut ch'ic la̱ cuuk' sa' xc'atk lin sa'. Chatpa̱ba̱nk. ¿C'a'ut nak inc'a' xapa̱b nak xincuacli cui'chic chi yo'yo?— ");
INSERT INTO kekNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ut laj Tomás quixye re: —¡At Ka̱cua', at inDios!— ");
INSERT INTO kekNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Li Jesús quixye re: —La̱at toj xacuil cuu, tojo'nak xina̱pa̱b. Abanan la̱in ninye a̱cue, us xak reheb li neque'pa̱ban cue chi inc'a' xe'ril cuu, chan li Jesús re. ");
INSERT INTO kekNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Nabal chic li milagro quixba̱nu li Jesús chiruheb lix tzolom li inc'a' tz'i̱banbil retalil sa' li hu a'in. ");
INSERT INTO kekNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Abanan li jo' q'uial tz'i̱banbil retalil sa' li hu a'in, quitz'i̱ba̱c re nak te̱pa̱b nak li Jesús, a'an li Cristo. A'an li Ralal li Dios. Quitz'i̱ba̱c re nak riq'uin xpa̱banquil ta̱cua̱nk e̱yu'am chi junelic sa' xc'aba' a'an. ");
INSERT INTO kekNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Mokon chic quixc'utbesi cui'chic rib li Jesús chiruheb lix tzolom chire li palau Tiberias. Jo'ca'in nak quixc'ut rib chiruheb: ");
INSERT INTO kekNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ch'utch'u̱queb laj Simón Pedro ut laj Tomás li nayehe' lut re, ut laj Natanael, Caná xtenamit li cuan sa' xcue̱nt Galilea. Cuanqueb ajcui' aran li ralal laj Zebedeo ut cuibeb chic lix tzolom li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Laj Simón Pedro quixye reheb: —La̱in xic cue chi caribc, chan. —Toxic ajcui' la̱o cha̱cuix, chanqueb re. Ut que'oc sa' jun li jucub ut que'xnumsi li k'ojyi̱n chi caribc. Abanan ma̱ jun li car que'xchap. ");
INSERT INTO kekNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nak ac yo̱ chic chi sake̱uc, li Jesús quixc'utbesi cui'chic rib chiruheb chire li palau. Abanan eb lix tzolom inc'a' que'xnau nak a'an li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Quixye li Jesús reheb: —Ex cualal inc'ajol, ¿ma xechap li car? chan. Eb a'an que'chak'oc ut que'xye: —Ma̱ jun xkachap.— ");
INSERT INTO kekNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Li Jesús quixye reheb: —Cutumak le̱ yoy chixc'atk li jucub, sa' le̱ nim re nak te̱chap li car, chan. Ut que'xcut lix yoy sa' li ha' ut inc'a' chic que'xcuy risinquil xban xq'uial li car li que'xchap. ");
INSERT INTO kekNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ut lix tzolom li Jesús, li raro xban, quixye re laj Pedro: —¡A'an li Ka̱cua'!— Ut laj Pedro, nak quirabi nak a'an li Ka̱cua', quixq'ue cui'chic li rak' chirix xban nak quirisi nak qui-oc chi caribc, ut quixcut rib sa' li ha' re ta̱xic riq'uin li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ut eb lix comon que'chal sa' li jucub. Yo̱queb chixquelonquil lix yoy nujenak chi car. Moco najt ta cuanqueb chire li palau, yal oc'a̱l metro tana. ");
INSERT INTO kekNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nak que'el sa' li jucub que'ril nak cuan jun li xam c'ubc'u. Li Jesús yo̱ chixpombal jun li car sa' xbe̱n li ru xam ut cuan ajcui' caxlan cua riq'uin. ");
INSERT INTO kekNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Li Jesús quixye reheb: —C'amomak chak cuib oxibak li car li xechap.— ");
INSERT INTO kekNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Laj Simón Pedro qui-oc sa' li jucub ut quixquelo li yoy chi ch'och'el nujenak chi ni̱nki car. Jun ciento riq'uin oxlaju roxc'a̱l (153) li car cuan sa' li yoy. Usta k'axal nabaleb li car cuan chi sa', abanan inc'a' quipeje' li yoy. ");
INSERT INTO kekNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Li Jesús quixye reheb: —Quimkex ut cua'inkex.— Ut ma̱ jun reheb lix tzolom quiraj xpatz'bal re ma a'an li Ka̱cua' xban nak ac neque'xnau nak a'an li Ka̱cua'. ");
INSERT INTO kekNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ut li Jesús quixchap li caxlan cua ut quixq'ue reheb. Ut quixq'ue ajcui' li car. ");
INSERT INTO kekNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","A'in li rox sut nak quixc'utbesi cui'chic rib li Jesús chiruheb lix tzolom nak ac xcuacli cui'chic chi yo'yo sa' xya̱nkeb li camenak. ");
INSERT INTO kekNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nak ac xe'cua'ac, li Jesús quixye re laj Simón Pedro: —At Simón, ralalat laj Jonás, ¿ma k'axal niquina̱ra chiruheb a'in?— Laj Pedro quixye re: —Ka̱cua', la̱at nacanau nak nacatinra, chan. Ut li Jesús quixye re: —Chacuilakeb li cualal inc'ajol li toj k'uneb xch'o̱l sa' lix pa̱ba̱leb jo' jun li pastor narileb lix coc' carner.— ");
INSERT INTO kekNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ut li Jesús quixye cui'chic re: —At Simón, ralalat laj Jonás, ¿ma niquina̱ra?— Laj Pedro quixye: —Ka̱cua', la̱at nacanau nak nacatinra.— Ut li Jesús quixye re: —Chacuilakeb li cualal inc'ajol jo' jun li pastor narileb lix carner, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ut li Jesús quixpatz' cui'chic re rox sut: —At Simón, ralalat laj Jonás, ¿ma niquina̱ra?— Ut quiraho' sa' xch'o̱l laj Pedro xban nak li Jesús quixpatz' re rox sut “¿ma niquina̱ra?”. Jo'can nak quixye re li Jesús: —Ka̱cua', la̱at nacanau chixjunil li c'a'ak re ru. ¡La̱at nacanau nak nacatinra!— Ut li Jesús quixye cui'chic re: —Chacuilakeb li cualal inc'ajol jo' jun li pastor narileb lix carner. ");
INSERT INTO kekNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Relic chi ya̱l ninye a̱cue nak toj sa̱jat, nacabac' a̱sa' a̱junes ut nacatxic yalak bar nacacuaj xic. Abanan nak ac ti̱xakat chic, ta̱ye' la̱ cuuk' ut jalan ta̱bac'ok re ut tatxc'am bar inc'a' nacacuaj xic, chan. ");
INSERT INTO kekNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Riq'uin li a̱tin a'in li quixye li Jesús, yo̱ chixyebal chanru nak ta̱camsi̱k laj Pedro. Ut riq'uin xcamic tixq'ue xlok'al li Dios. Nak ac xye a'in, li Jesús quixye re laj Pedro: —China̱ta̱ke, chan re. ");
INSERT INTO kekNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Laj Pedro quixsuk'isi rib ut quiril lix tzolom li Jesús, li raro xban, yo̱ chi xic chirixeb. A'an lix tzolom li quipatz'oc re li Jesús nak yo̱queb chi cua'ac, “¿Ani ta̱k'axtesi̱nk a̱cue, at Ka̱cua'?” ");
INSERT INTO kekNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nak laj Pedro quiril a'an, quixpatz' re li Jesús: —Ut li cui̱nk a'an, Ka̱cua', ¿ma tixc'ul jo' tinc'ul la̱in? chan. ");
INSERT INTO kekNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Li Jesús quixye re: —Cui la̱in tincuaj nak yo'yo̱k a'an toj tinc'ulu̱nk cui'chic, ¿c'a'ru ta̱cuaj re la̱at? La̱at q'ue a̱ch'o̱l chinta̱kenquil, chan li Jesús re laj Pedro. ");
INSERT INTO kekNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jo'can nak qui-el resil sa' xya̱nkeb laj pa̱banel nak li jun a'an inc'a' ta̱ca̱mk. Abanan ma̱cua' jo'can quixye li Jesús. Inc'a' quixye nak inc'a' ta̱ca̱mk. Ca'aj cui' quixye, “Cui la̱in tincuaj nak yo'yo̱k toj tinc'ulu̱nk, ¿c'a'ru ta̱cuaj re la̱at?” ");
INSERT INTO kekNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ut li tzolom a'an, a'an la̱in laj Juan. La̱in quin-iloc re li c'a'ru quic'ulman ut xinch'olob xya̱lal sa' li hu a'in. Ut la̱o nakanau nak tz'akal ya̱l li c'a'ru xintz'i̱ba sa' li hu a'in. ");
INSERT INTO kekNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Toj cuan chic nabal li c'a'ak re ru quilajxba̱nu li Jesús. Cui ta tz'i̱banbil retalil chi xjunju̱nkal, la̱in ninye nak ma̱ jok'e raj ta̱tz'aklok li ruchich'och' chok' xna'aj li hu li ta̱tz'i̱bama̱nk cui' retalil. Jo'can taxak.");
INSERT INTO kekNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Sa' li xbe̱n hu quintz'i̱ba a̱cuiq'uin, at Teófilo, quintz'i̱ba retalil chixjunil li jo' q'uial quixc'ut ut quixba̱nu li Ka̱cua' Jesús chalen nak quixtiquib lix c'anjel sa' ruchich'och' ");
INSERT INTO kekNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","toj sa' li cutan nak quic'ame' sa' choxa. Nak toj ma̱ji' naxic sa' choxa, riq'uin xcuanquil li Santil Musik'ej, quixye reheb c'a'ru tento te'xba̱nu lix apóstol li quixsiq'ueb ru. ");
INSERT INTO kekNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Nak ac xrahobtesi̱c ut ac xcamsi̱c, quicuacli cui'chic chi yo'yo ut quixc'utbesi cui'chic rib chiruheb. Ca'c'a̱l cutan quicuan sa' ruchich'och' ut nabal sut quixc'utbesi rib chiruheb re nak te'xnau chi tz'akal nak quicuacli cui'chic chi yo'yo. Quixch'olob xya̱lal chiruheb chanru nak ta̱cua̱nk xnimal xcuanquilal li Dios sa' xbe̱neb li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nak toj cuan sa' xya̱nkeb li Jesús quixye reheb chi jo'ca'in: —Inc'a' texxic sa' jalan na'ajej. Texcana̱k ban Jerusalén roybeninquil li Santil Musik'ej li yechi'inbil e̱re xban li Dios Acuabej, li ac xinye e̱re la̱in. ");
INSERT INTO kekNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ya̱l nak laj Juan quicubsin ha' riq'uin ha'. Abanan anakcuan a' chic lix cuanquilal li Santil Musik'ej te̱c'ul chi se̱b ut a'an chic ta̱cua̱nk e̱riq'uin, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Eb li apóstol li ch'utch'u̱queb aran que'xpatz' re li Jesús: —At Ka̱cua', ¿ma anakcuan ta̱q'ueheb cui'chic xcuanquileb laj Israel re te'xtakla cui'chic rib xjuneseb? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Quichak'oc li Jesús ut quixye reheb: —Ma̱cua' e̱re la̱ex xnaubal li c'a'ak re ru a'in. Ca'aj cui' li Dios Acuabej nana'oc re jok'e tixba̱nu xban nak ca'aj cui' a'an yal re sa' xbe̱n chixjunil. ");
INSERT INTO kekNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","La̱ex te̱c'ul le̱ cuanquil nak ta̱cha̱lk li Santil Musik'ej e̱riq'uin. La̱ex chic texch'oloba̱nk resilal chicuix la̱in arin Jerusalén, aran Judea ut Samaria. Jo' ajcui' yalak bar jun sut sa' ruchich'och' te̱ch'olob li xya̱lal, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nak quirake' xyebal chixjunil a'in quic'ame' sa' choxa li Jesús xban li Dios. Yo̱queb chirilbal nak quichal jun li chok ut quimukun sa' li chok. Ut inc'a' chic que'ril ru. ");
INSERT INTO kekNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Toj yo̱queb ajcui' chirilbal nak yo̱ chi xic li Jesús sa' choxa nak xaka̱mileb cuibeb li cui̱nk chiruheb. Sakeb li rak'. ");
INSERT INTO kekNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ut que'xye reheb: —Ex cui̱nk aj Galilea, ¿C'a'ut nak yo̱quex chi iloc sa' choxa? Li Jesús li xcuan sa' e̱ya̱nk ut xc'ame' sa' choxa, a'an ta̱cha̱lk cui'chic. Chanru nak xeril chi xic sa' choxa, jo'can cui'chic nak te̱ril nak yo̱k chi cha̱lc, chanqueb reheb. ");
INSERT INTO kekNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Chirix a'an eb li apóstol que'cube chak sa' li tzu̱l Olivos ut que'co̱eb cui'chic Jerusalén. Li tzu̱l a'an nach' cuan riq'uin li tenamit Jerusalén, jun kilómetro tana xnajtil, jo' xnajtil li naru neque'xbeni sa' li hiloba̱l cutan. ");
INSERT INTO kekNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nak que'cuulac Jerusalén que'take' sa' xca' tasal li cab li neque'hilan cui' nak cuanqueb Jerusalén. A'aneb laj Pedro, laj Juan, laj Jacobo, laj Andrés, laj Felipe, laj Tomás, laj Bartolomé, laj Mateo, laj Jacobo li ralal laj Alfeo, laj Simón li na-oquen sa' xya̱nkeb li jun ch'u̱tal Celote neque'xye reheb, ut laj Judas li ralal laj Jacobo. ");
INSERT INTO kekNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Chixjunileb a'an yo̱queb chi tijoc chi junajeb xch'o̱l rochbeneb li ri̱tz'in li Jesús ut lix María lix na'. Ut cuanqueb ajcui' ixk yo̱queb chi tijoc rochbeneb. ");
INSERT INTO kekNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Sa' eb li cutan a'an jun ciento riq'uin junmay chixjunileb laj pa̱banel li ch'utch'u̱queb aran. Laj Pedro quixakli sa' xya̱nkeb ut qui-oc chixyebal reheb: ");
INSERT INTO kekNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Ex inherma̱n, tento nak ta̱uxma̱nk li tz'i̱banbil sa' li Santil Hu li quic'ute' chiru li rey David xban li Santil Musik'ej chirix laj Judas li quik'axtesin re li Jesús reheb li que'chapoc re. ");
INSERT INTO kekNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Laj Judas, a'an raj jun sa' kaya̱nk sa' li c'anjel a'in. ");
INSERT INTO kekNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Riq'uin lix tojbal li quiq'uehe' re xban nak quixba̱nu li ma̱usilal, quilok'e' jun li ch'och'. Quixyatz' rib ut nak quit'ane' chi xulxu, quichire' ut qui-el chak chixjunil sa' lix sa'. ");
INSERT INTO kekNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Qui-el ut resil a'an sa' xya̱nkeb chixjunileb li cuanqueb Jerusalén. Jo'can nak Acéldama neque'xye re li na'ajej a'an sa' li ra̱tinoba̱leb. A'an naraj naxye “Lok'bil riq'uin quic'.” ");
INSERT INTO kekNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Quic'ulman chi jo'can xban nak sa' li hu Salmos tz'i̱banbil retalil li naxye chi jo'ca'in: Chicana̱k ta lix na'aj chi ma̱c'a' chic cuan chiru. Ut ma̱ ani ta chic chi cua̱nk sa' lix muheba̱l. (Sal. 69:5) Ut naxye ajcui': Jalan ta chic chiq'uehek' chok' re̱kaj sa' lix c'anjel. (Sal. 109:8) ");
INSERT INTO kekNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Jo'can nak tento takaxakab junak chok' re̱kaj laj Judas. Cuanqueb cui̱nk sa' kaya̱nk que'ochbenin chak ke nak toj cuan li Jesús sa' kaya̱nk, ");
INSERT INTO kekNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","chalen nak quicubsi̱c chak xha' li Jesús xban laj Juan ut toj chalen nak quic'ame' sa' choxa chiku. Jun reheb li cui̱nk a'an naru takaxakab chok' re̱kaj laj Judas re nak tixch'olob ajcui' xya̱lal nak quicuacli cui'chic chi yo'yo li Jesús sa' xya̱nkeb li camenak, chan laj Pedro. ");
INSERT INTO kekNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Que'xxakab laj José li neque'xye Barsabás re. Aj Justo lix c'aba' jun chic neque'xq'ue. Ut que'xxakab ajcui' laj Matías. ");
INSERT INTO kekNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ut que'oc chi tijoc ut que'xye: —At Ka̱cua', la̱at nacanau chanru li ra̱m li junju̱nk. Jo'can nak nakatz'a̱ma cha̱cuu nak ta̱c'utbesi chiku ani reheb li cuib a'in ta̱sic' ru re ta̱cana̱k chi c'anjelac chok' re̱kaj laj Judas. ");
INSERT INTO kekNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","A'an tixc'ul xcuanquil chi c'anjelac chok' apóstol. Tixba̱nu li c'anjel li quixtz'ekta̱na laj Judas xban li inc'a' us quixba̱nu. Laj Judas co̱ sa' li na'ajej chixtojbal xma̱c bar xc'ulub cui' xic, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Jo'can nak que'xbu̱li rix li ani ta̱cana̱k chi c'anjelac. Ut nak ac xe'bu̱lic, li c'anjel a'an quicana sa' xbe̱n laj Matías. Ut sa' ajcui' li ho̱nal a'an laj Matías qui-oc chok' apóstol sa' xya̱nkeb li junlaju chic. ");
INSERT INTO kekNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Sa' xk'ehil li nink'e re li Pentecostés ch'utch'u̱queb chixjunileb laj pa̱banel sa' jun chi na'ajej ut junajeb xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Que'rabi jun choki̱nc chanchan xya̱b cacuil ik' yo̱ chi cha̱lc sa' choxa. Chixjunileb li cuanqueb sa' li cab que'rabi. ");
INSERT INTO kekNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Que'ril li chanchan rak' xam. Li rak' xam que'xjeq'ui rib ut que'hilan sa' xbe̱neb chi xjunju̱nkaleb. ");
INSERT INTO kekNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Que'xc'ul li xcuanquilal li Santil Musik'ej, ut que'oc chi a̱tinac sa' jalan a̱tinoba̱l a' yal chanru quic'ute' chiruheb xban li Santil Musik'ej. ");
INSERT INTO kekNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Cuanqueb aj judío aran Jerusalén cauheb xch'o̱l sa' xpa̱ba̱leb. Que'chal chak sa' chixjunil li tenamit jun sut rubel choxa. ");
INSERT INTO kekNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nak que'rabi li c'a'ru yo̱queb chixc'ulbal eb a'an, que'xch'utub ribeb li q'uila tenamit. Sachso̱queb xch'o̱l xban nak que'rabi nak yo̱queb chi a̱tinac sa' li ra̱tinoba̱leb li junju̱nk chi tenamit. ");
INSERT INTO kekNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","C'ajo' nak que'xucuac ut sachso̱queb xch'o̱l que'cana ut que'xye chi ribileb rib: —¿Ma ma̱cua'eb ta bi' aj Galilea chixjunileb a'in li yo̱queb chi a̱tinac sa' jalanil a̱tinoba̱l? ");
INSERT INTO kekNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿C'a'ut nak yo̱co chirabinquileb chi a̱tinac sa' li ka̱tinoba̱l chikaju̱nkal? ");
INSERT INTO kekNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Anakcuan eb a'an yo̱queb chi a̱tinac sa' ra̱tinoba̱leb laj Partos, laj Medo, laj elamitas ut chikajunilo la̱o li cuanco Mesopotamia, ut Judea, Capadocia, Ponto ut Asia, ");
INSERT INTO kekNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","jo'queb ajcui' laj Frigia ut laj Panfilia, laj Egipto ut eb li cuanqueb sa' eb li na'ajej xcue̱nt Libia li cuanqueb nach' riq'uin Cirene, jo'queb ajcui' laj Roma. ");
INSERT INTO kekNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Cuanqueb aj judío sa' xyo'lajiqueb ut cuanqueb ajcui' li que'xjal xpa̱ba̱l ut que'oc sa' xya̱nkeb laj judío. Cuanqueb ajcui' li que'chal Creta ut Arabia. Nakabi nak yo̱queb chixyebal sa' ka̱tinoba̱l li c'a'ru yo̱ chixba̱nunquil li Ka̱cua' Dios riq'uin xnimal xcuanquilal, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ut chixjunileb sachso̱queb xch'o̱l ut inc'a' que'xtau ru. Que'xye chiribileb rib: —¿C'a'ru xya̱lal a'in li yo̱co chixc'ulbal? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Cuanqueb ajcui' yo̱queb chi hoboc ut yo̱queb chixyebal: —Ma̱re te'cala̱k, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tojo'nak quixakli laj Pedro rochbeneb li junlaju chic chi apóstol ut qui-oc chi a̱tinac chi cau xya̱b xcux. Quixye reheb li q'uila tenamit: —Ex cuech tenamitil aj judío ut che̱junilex la̱ex li cuanquex Jerusalén, la̱in tinye e̱re c'a'ru xya̱lal a'in. Q'uehomak retal chi us li oc cue xyebal e̱re. ");
INSERT INTO kekNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Li jo' q'uialeb li cuanqueb arin moco te'cala̱k ta jo' yo̱quex chixc'oxlanquil la̱ex. Anakcuan toje' bele̱b o̱r re li cutan cuanco. ");
INSERT INTO kekNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Yo̱co ban chixc'ulbal li quixye chak resil li profeta Joel nak quixye chi jo'ca'in: ");
INSERT INTO kekNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Sa' eb li cutan li telaje'cha̱lk, chan li Dios, la̱in tinq'ue lin musik' chi cua̱nc riq'uineb chixjunileb li tenamit. Eb le̱ ralal e̱c'ajol te'yehok ra̱tin profeta. Ut tinc'ut li xya̱lal chiruheb li ti̱xil cui̱nk sa' xmatq'ueb ut tinc'uteb li visión chiruheb li sa̱j cui̱nk. ");
INSERT INTO kekNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ut tinq'ue ajcui' lin musik' chi cua̱nc riq'uineb lin mo̱s cui̱nk ut lin mo̱s ixk, ut talaje'xye resil li c'a'ru ta̱c'ulma̱nk mokon. ");
INSERT INTO kekNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ut sachba ch'o̱lej tinc'utbesi che̱ru chiru choxa jo' ajcui' sa' ruchich'och' ut te̱ril li quic', li xam ut li sib chanchan li chok. ");
INSERT INTO kekNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ta̱k'ojyi̱nok' ru li sak'e ut li po ta̱cakok' ru chanchan li quic' toj ta̱cuulak xk'ehil li cutan a'an, li k'axal xiu xiu, nak la̱in tinrakok a̱tin, chan li Dios. ");
INSERT INTO kekNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Abanan chixjunileb li neque'ya̱ban re lix c'aba' li Ka̱cua', te'colek'. (Joel 2:28-32) ");
INSERT INTO kekNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ex aj Israel, abihomak li tinye e̱re. La̱ex ac nequenau nak li Jesús aj Nazaret, a'an q'uebil xcuanquil xban li Dios sa' e̱ya̱nk la̱ex riq'uin li sachba ch'o̱lej ut li milagro quilajxba̱nu. La̱ex ac nequenau nak riq'uin xcuanquil li Dios quixba̱nu li sachba ch'o̱lej. ");
INSERT INTO kekNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Li Jesús quik'axtesi̱c sa' e̱ruk' la̱ex xban nak ac jo'can chak sa' xch'o̱l li Dios nak jo'can tixc'ul. Ut la̱ex quechap ut quek'axtesi sa' ruk'eb li cui̱nk li inc'a' useb xna'leb. Ut eb a'an que'xcamsi chiru cruz. ");
INSERT INTO kekNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Abanan li Dios quicuaclesin cui'chic re chi yo'yo sa' xya̱nkeb li camenak. Li Dios quirisi xcuanquil li ca̱mc sa' xbe̱n xban nak li ca̱mc inc'a' naru nanumta sa' xbe̱n. ");
INSERT INTO kekNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Jo'ca'in quixye li rey David chirix li Jesús: La̱in junelic ninc'oxla li Dios. A'an cuan cuiq'uin. Ma̱c'a' c'a'ru ta̱isi̱nk cue riq'uin li Dios. ");
INSERT INTO kekNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Numtajenak li saylal cuan sa' li cua̱m xban nak c'ojc'o inch'o̱l riq'uin li Ka̱cua'. ");
INSERT INTO kekNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","La̱in ninnau nak tina̱cuaclesi cui'chic chi yo'yo sa' xya̱nkeb li camenak. Ut ninnau ajcui' nak inc'a' ta̱canab chi k'a̱c lix tibel la̱ Santil Alal. ");
INSERT INTO kekNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","La̱in ninnau nak la̱at nacatc'utuc chicuu chanru nak tintau li junelic yu'am. Xban nak la̱at cuancat cuiq'uin, junelic sa sa' inch'o̱l. Ut ca'aj cui' a̱cuiq'uin cuan li sahil ch'o̱lejil. (Sal. 16:8-11) ");
INSERT INTO kekNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ex kech tenamitil, la̱in ninye e̱re chi anchal inch'o̱l nak tz'akal ya̱l nak laj David li kaxe'to̱nil yucua' quicam ut quimuke'. La̱o nakanau nak li mukleba̱l li cuan cui' toj cuan ajcui' chalen anakcuan. ");
INSERT INTO kekNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Laj David a'an jun profeta. A'an quixnau nak li Dios quixye riq'uin juramento nak sa' xya̱nkeb li ralal xc'ajol ta̱yo'la̱k li Cristo, ut a'an chic ta̱xakaba̱k chok' rey. ");
INSERT INTO kekNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ut laj David quixnau li c'a'ru ta̱c'ulma̱nk mokon. Jo'can nak quixch'olob xya̱lal nak li Cristo ta̱cuacli̱k cui'chic chi yo'yo sa' xya̱nkeb li camenak. Quixnau nak a'an inc'a' ta̱cana̱k sa' xna'ajeb li camenak chi moco lix tibel ta̱k'a̱k. ");
INSERT INTO kekNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","A'an a'in li Jesús li quicuaclesi̱c cui'chic chi yo'yo xban li Dios. La̱o xkil tz'akal riq'uin xnak' ku. Jo'can nak nakanau nak ya̱l. ");
INSERT INTO kekNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Quic'ame' xban li Dios re nak ta̱c'ojla̱k sa' lix nim uk' ut quiq'uehe' xcuanquil. Ut quiq'uehe' li Santil Musik'ej re xban li Dios. Ut quixq'ue ajcui' ke la̱o li Santil Musik'ej jo' quiyechi'i̱c ke. A'an a'in li yo̱quex chirilbal ut chirabinquil anakcuan. ");
INSERT INTO kekNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Li rey David inc'a' quic'ame' sa' choxa jo' nak quic'ame' li Cristo sa' choxa. Abanan quixye chi jo'ca'in: Li Dios quixye re li Ka̱cua': C'ojlan sa' lin nim uk', ");
INSERT INTO kekNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","toj tinq'ueheb li xic' neque'iloc a̱cue rubel la̱ cuanquil. (Sal. 110:1) ");
INSERT INTO kekNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Chenauhak che̱junilex la̱ex aj Israel nak li Jesús li queq'ue la̱ex chiru cruz, a'an li quiq'uehe' chok' Ka̱cua' ut chok' Cristo xban li Dios, chan laj Pedro. ");
INSERT INTO kekNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nak que'rabi a'an li ch'utch'u̱queb aran, que'yot'e' xch'o̱leb ut que'xye re laj Pedro jo' ajcui' reheb li apóstol li jun ch'ol chic: —Ex kas ki̱tz'in, ¿c'a'ru takaba̱nu? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Laj Pedro quichak'oc ut quixye reheb: —Chiyot'ek' e̱ch'o̱l ut jalomak e̱c'a'ux ut ta̱cubsi̱k e̱ha' chi junju̱nkalex sa' xc'aba' li Jesucristo re nak tixcuy e̱ma̱c li Dios ut tixq'ue e̱re li Santil Musik'ej. ");
INSERT INTO kekNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Yechi'inbil e̱re la̱ex li ma̱tan a'in, ut yechi'inbil ajcui' reheb le̱ ralal e̱c'ajol ut reheb ajcui' li ma̱cua'eb aj judío. Yechi'inbil reheb chixjunileb li jo' q'uialeb te'bokek' xban li Ka̱cua' li kaDios, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ma̱cua' ca'aj cui' a'an li quixye laj Pedro reheb. Quixch'olob ban ajcui' xya̱lal chiruheb riq'uin nabal chi a̱tin ut quixq'ue xna'lebeb. Quixye reheb: —Chenauhak xcolbal e̱rib chiru li tojba ma̱c li ta̱cha̱lk sa' xbe̱neb li inc'a' useb xna'leb, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ut chixjunileb li que'pa̱ban re li ra̱tin que'cubsi̱c xha'. Oxib mil tana li que'pa̱ban sa' li cutan a'an ut que'oc chok' xcomoneb. ");
INSERT INTO kekNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Cauheb xch'o̱l chixpa̱banquil li tijleb li quich'oloba̱c chiruheb xbaneb li apóstol. Junaj xch'o̱leb nak cuanqueb ut sa' comonil que'tijoc ut que'cua'ac re xjulticanquil lix camic li Jesucristo. ");
INSERT INTO kekNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Chixjunileb sachso̱queb xch'o̱l xban li milagro ut li sachba ch'o̱lej li yo̱queb chixba̱nunquil li apóstol. ");
INSERT INTO kekNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ut eb li que'pa̱ban junaj xch'o̱leb ut chixjunil li c'a'ru cuan reheb, reheb sa' comonil. ");
INSERT INTO kekNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Que'xc'ayi lix ch'och'eb ut chixjunil li c'a'ru cuan reheb ut que'xjeq'ui lix tz'ak reheb chixjunileb a' yal chanru ta̱c'anjelak chiruheb li junju̱nk. ");
INSERT INTO kekNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Rajlal cutan que'xch'utub ribeb sa' li templo chi lok'oni̱nc. Ut sa' eb li rochoch que'cua'ac sa' comonil chi sa sa' xch'o̱leb ut chi junaj xch'o̱leb. ");
INSERT INTO kekNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Que'xlok'oni li Ka̱cua' Dios ut que'q'uehe' xcuanquil xbaneb chixjunileb li tenamit. Ut rajlal cutan li Dios quixtenk'aheb chi q'uia̱nc laj pa̱banel. ");
INSERT INTO kekNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Sa' jun li cutan que'co̱eb sa' li templo laj Pedro rochben laj Juan oxib o̱r re ecuu sa' x-o̱ril li tijoc. ");
INSERT INTO kekNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Rajlal cutan nac'ame' jun li cui̱nk inc'a' nabe̱c chalen sa' xyo'lajic ut naq'uehe' chire li oqueba̱l re li templo. Lix c'aba' li oqueba̱l a'an “Ch'ina'us”. Naq'uehe' li yaj aran re tixtz'a̱ma c'a'ru re riq'uineb li neque'oc sa' li templo. ");
INSERT INTO kekNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Li cui̱nk a'in quiril nak yo̱queb chi oc sa' li templo laj Pedro ut laj Juan. Qui-oc chixtz'a̱manquil c'a'ru re reheb. ");
INSERT INTO kekNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Laj Pedro ut laj Juan que'cana chirilbal li yaj ut laj Pedro quixye re: —Ilon chak kiq'uin.— ");
INSERT INTO kekNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nak quirabi li cui̱nk li c'a'ru quixye, qui-oc chiroybeninquil c'a'ru te'xq'ue re. ");
INSERT INTO kekNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Laj Pedro quixye re: —Ma̱c'a' intumin la̱in re tinq'ue a̱cue. Abanan li c'a'ru cuan cuiq'uin tinq'ue a̱cue. Sa' xc'aba' li Ka̱cua' Jesucristo laj Nazaret, ninye a̱cue cuaclin ut be̱n, chan re. ");
INSERT INTO kekNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ut nak quixye a'in, quixchap ut quixcuaclesi riq'uin lix nim uk'. Sa' junpa̱t quicacuu li xbe̱n rak ut li rok li cui̱nk. ");
INSERT INTO kekNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Sa' junpa̱t quixakli ut quibe̱c. Ut qui-oc sa' li templo rochbeneb. Yo̱ chi pisc'oc xban xsahil xch'o̱l ut yo̱ chixlok'oninquil li Dios. ");
INSERT INTO kekNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Chixjunileb li tenamit que'iloc re chi be̱c ut chixlok'oninquil li Dios. ");
INSERT INTO kekNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","C'ajo' nak que'xucuac ut sachso̱queb xch'o̱l chirilbal li cui̱nk a'an, xban nak que'xnau ru nak a'an li nac'ojla chixtz'a̱manquil c'a'ru re chire li oqueba̱l “Ch'ina'us” xc'aba'. ");
INSERT INTO kekNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ut li cui̱nk li quiq'uirtesi̱c inc'a' quiraj xcanabanquil rib riq'uineb laj Pedro ut laj Juan. Yo̱ chi be̱c rochbeneb. Ut chixjunileb sachso̱queb xch'o̱l chirilbal li quic'ulman. Que'co̱eb sa' a̱nil sa' li templo ut que'xch'utub ribeb sa' li oqueba̱l Salomón xc'aba', cuanqueb cui' laj Pedro ut laj Juan. ");
INSERT INTO kekNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nak laj Pedro quirileb, quixye reheb: —La̱ex aj Israel, ¿c'a'ut nak sachso e̱ch'o̱l nequexcana xban li c'a'ru xc'ulman? ¿C'a'ut nak yo̱quex chikilbal? ¿Ma nequec'oxla la̱ex nak la̱o xkaq'uirtesi li cui̱nk a'in kajunes? ¿Ma xban ta bi' kacuanquil ut li kacha̱bilal nak xkaq'ue chi be̱c li cui̱nk a'in? ");
INSERT INTO kekNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Li Dios li que'xlok'oni chak laj Abraham, laj Isaac ut laj Jacob jo'queb ajcui' li kaxe'to̱nil yucua', a'an quiq'uehoc xcuanquil li Jesucristo laj c'anjel chiru. Ut la̱ex quek'axtesi a'an re laj Pilato. Ut nak laj Pilato quiraj raj rach'abanquil, la̱ex inc'a' queraj. ");
INSERT INTO kekNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","La̱ex inc'a' queraj xcolbal rix li santil cui̱nk a'in, li ti̱c xch'o̱l. A' chic laj camsinel queq'ue chi ach'aba̱c. ");
INSERT INTO kekNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","La̱ex queq'ue chi camsi̱c a'an, ut a'an li naq'uehoc yu'am. Abanan quicuaclesi̱c cui'chic chi yo'yo xban li Dios sa' xya̱nkeb li camenak. Ut a'an li nakach'olob xya̱lal la̱o xban nak la̱o xkil chi tz'akal nak quicuacli. ");
INSERT INTO kekNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Li cui̱nk a'in xq'uira sa' xc'aba' li Jesús. Riq'uin xpa̱banquil li Jesús xq'uira chi junaj cua li cui̱nk a'in li nequenau ru ut yo̱quex chirilbal. ");
INSERT INTO kekNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Jo'can ut ex cuas cui̱tz'in, la̱in ninnau nak queq'ue chi camsi̱c li Jesús xban nak inc'a' nequenau xya̱lal jo'queb ajcui' li neque'taklan sa' e̱be̱n. ");
INSERT INTO kekNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Riq'uin a'in quitz'akloc ru li que'xye chak li profeta najter nak que'xye nak tento tixc'ul li rahobtesi̱c li Cristo li Mesías, xban nak jo'can quixye li Dios. ");
INSERT INTO kekNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Jo'can ut nak yot'omak e̱ch'o̱l ut jalomak e̱c'a'ux ut sic'omak li Ka̱cua' re nak a'an tixcuy tixsach le̱ ma̱c. Ut li Ka̱cua' tixq'ue xcacuilal ut xsaylal e̱ch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Li Dios tixtakla cui'chic chak li Jesucristo sa' ruchich'och' xban nak a'an li Mesías li ac xakabanbil chak najter re xcolbaleb chiru li raylal li cuanqueb sa' ruchich'och'. ");
INSERT INTO kekNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Abanan tento nak cua̱nk chak aran sa' choxa toj ta̱cuulak xk'ehil nak ta̱tz'aklok ru chixjunil jo' que'xch'olob xya̱lal li santil profeta junxilaj jo' quiyehe' reheb xban li Dios. ");
INSERT INTO kekNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Laj Moisés quixye reheb li kaxe'to̱nil yucua', “Li Ka̱cua' le̱ Dios tixq'ue junak profeta sa' e̱ya̱nk sic'bil ru xban jo' la̱in. E̱comon ajcui' la̱ex. Cheba̱nu chixjunil li c'a'ru tixye e̱re. ");
INSERT INTO kekNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ut li ani inc'a' tixpa̱b li c'a'ru tixye li profeta a'an, ta̱isi̱k sa' xya̱nkeb lix tenamit li Dios ut ta̱sachek' ru.” (Dt. 18:18-19) ");
INSERT INTO kekNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Chalen nak quicuan li profeta Samuel chixjunileb li profeta que'xye ajcui' resil li c'a'ru ta̱c'ulma̱nk sa' eb li cutan a'in. ");
INSERT INTO kekNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","La̱ex ralal xc'ajol eb li profeta ut la̱ex texc'uluk re li quiyechi'i̱c reheb le̱ xe'to̱nil yucua'. Nak li Dios quixba̱nu li contrato riq'uin laj Abraham, quixye re, “Chixjunileb li cuanqueb sa' ruchich'och' te'osobtesi̱k sa' xc'aba'eb la̱ cualal a̱c'ajol.” ");
INSERT INTO kekNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nak li Dios quixtakla chak li ralal, quixtakla xbe̱n cua e̱riq'uin la̱ex aj judío re e̱rosobtesinquil re nak che̱junju̱nkalex te̱yot' e̱ch'o̱l ut te̱jal e̱c'a'ux ut te̱canab xba̱nunquil li ma̱usilal. ");
INSERT INTO kekNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Toj yo̱queb ajcui' chi a̱tinac laj Pedro ut laj Juan nak que'cuulac laj tij riq'uineb. Rochbeneb laj tij cuan li nataklan sa' xbe̱neb li soldado li neque'c'ac'alen re li templo ut rochbeneb ajcui' laj saduceo. ");
INSERT INTO kekNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Yo̱queb xjosk'il xban nak laj Pedro ut laj Juan yo̱queb chixc'utbal li xya̱lal chiruheb li tenamit ut yo̱queb chixch'olobanquil xya̱lal chiruheb chirix lix cuaclijiqueb li camenak chi yo'yo sa' xc'aba' li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Xbaneb xjosk'il que'xchap laj Pedro ut laj Juan ut que'xq'ue sa' tz'alam toj sa' li cutan jun chic xban nak ac x-ecuu. ");
INSERT INTO kekNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Abanan nabaleb li que'pa̱ban re li a̱tin li yo̱queb chixyebal laj Pedro ut laj Juan. Cuanqueb na o̱bak mil li cui̱nk li que'pa̱ban. ");
INSERT INTO kekNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Sa' li cutan jun chic que'ch'utla Jerusalén eb li xbe̱nil aj tij, ut eb li neque'taklan sa' xbe̱neb laj judío, jo'queb ajcui' laj tz'i̱b. ");
INSERT INTO kekNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Cuanqueb ajcui' aran laj Anás li xyucua'il laj tij, ut laj Caifás, ut laj Juan, ut laj Alejandro jo'queb ajcui' li jun ch'ol chic lix comoneb li xyucua'il aj tij. ");
INSERT INTO kekNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Que'xtakla xc'ambal laj Pedro ut laj Juan. Que'xakaba̱c chiruheb ut que'xye reheb: —¿Ani xq'uehoc e̱cuanquil? Ut, ¿ani sa' aj c'aba' yo̱quex chixba̱nunquil li milagro a'in? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ut laj Pedro qui-oc chi a̱tinac riq'uin xcuanquil li Santil Musik'ej ut quixye reheb: —La̱ex li nequextaklan sa' xbe̱neb laj judío ut la̱ex li nequexc'amoc be chiruheb, abihomak li oc cue xyebal, ");
INSERT INTO kekNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","xban nak yo̱quex chixtz'ilbal a̱tin sa' kabe̱n riq'uin li usilal li xc'ul li cui̱nk a'in. Yo̱quex chixpatz'bal ke chanru nak quiq'uirtesi̱c li cui̱nk a'in. ");
INSERT INTO kekNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Takaye li xya̱lal e̱re re nak te̱nau nak li cui̱nk a'in xq'uira sa' xc'aba' li Jesucristo laj Nazaret li queq'ue la̱ex chi camsi̱c chiru cruz. Ut a'an li quicuaclesi̱c cui'chic chi yo'yo xban li Dios sa' xya̱nkeb li camenak. Sa' xc'aba' a'an xq'uira li cui̱nk a'in li yo̱quex chirilbal arin anakcuan. ");
INSERT INTO kekNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Li Jesús a'an chanchan li cha̱bil pec tz'ekta̱nanbil xbaneb laj cablanel. La̱ex xetz'ekta̱na li Jesús. Chanchanex laj cablanel li que'tz'ekta̱nan re li cha̱bil pec li quiq'uehe' chok' xxuc li cab mokon. ");
INSERT INTO kekNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ut ma̱ ani chic aj iq'uin ta̱ru̱k takatau kacolbal, xban nak ma̱c'a' chic junak c'aba'ej sa' chixjunil li ruchich'och' q'uebil ta ke re ta̱ru̱k tocolek' cui', chan laj Pedro. ");
INSERT INTO kekNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Que'ril nak cauheb xch'o̱l laj Pedro ut laj Juan chi a̱tinac. Que'xq'ue retal nak moco tzolbileb ta ut ma̱c'a'eb xcuanquil. Ut que'xsach xch'o̱leb chirabinquil li c'a'ru que'xye. Ut que'xq'ue retal nak eb li cui̱nk a'in que'be̱c chak rochben li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ut ma̱c'a' chic naru neque'xye xban nak yo̱queb chirilbal li cui̱nk li quiq'uirtesi̱c xakxo chixc'atkeb laj Pedro ut laj Juan. ");
INSERT INTO kekNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Jo'can nak que'xtakla risinquil chirix cab laj Pedro ut laj Juan. Ut que'oc chixc'u̱banquil chi ribileb rib c'a'ru te'xba̱nu riq'uineb. ");
INSERT INTO kekNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ut que'xye: —¿C'a'ru takaba̱nu riq'uineb li cui̱nk a'in? Chixjunileb li tenamit arin Jerusalén neque'xnau nak tz'akal milagro que'xba̱nu re li cui̱nk. La̱o inc'a' naru takaye nak inc'a' ya̱l a'an. ");
INSERT INTO kekNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Takase'besiheb re nak inc'a' chic te'xye resil li na'leb a'in sa' eb li tenamit. Takaye reheb nak chalen anakcuan inc'a' chic te'a̱tinak sa' xc'aba' li Jesús, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ut nak que'boke' cui'chic laj Pedro ut laj Juan, que'xye reheb nak inc'a' chic ta̱ru̱k te'a̱tinak chi moco ta̱ru̱k chic te'xtzoleb li tenamit sa' xc'aba' li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ut que'chak'oc laj Pedro ut laj Juan ut que'xye reheb: —C'oxlahomak chi us bar cuan li us chiru li Dios. ¿Ma us nak texkapa̱b la̱ex malaj ut us nak takapa̱b li Dios? ");
INSERT INTO kekNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","La̱o inc'a' naru takacanab xyebal resil li c'a'ru xkil ut xkabi, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Nak ac xe'xse'besiheb riq'uin cacuil a̱tin, que'rach'abeb. Ma̱c'a' que'ru xba̱nunquil reheb xban nak chixjunileb li tenamit yo̱queb chixlok'oninquil li Dios riq'uin li c'a'ru quic'ulman. ");
INSERT INTO kekNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ac numenak ca'c'a̱l chihab cuan re li cui̱nk li quiq'uirtesi̱c riq'uin milagro. ");
INSERT INTO kekNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ut nak ac xe'ach'aba̱c laj Pedro ut laj Juan, que'co̱eb riq'uineb li rech aj pa̱banelil. Que'xserak'i reheb chixjunil li que'xye eb li xbe̱nil aj tij ut eb li neque'taklan. ");
INSERT INTO kekNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nak que'rabi a'an, chixjunileb laj pa̱banel que'tijoc chiru li Dios sa' comonil ut que'xye: —At Ka̱cua' at nimajcual Dios, la̱at catyi̱ban re li choxa, li ruchich'och', ut li palau. La̱at catyi̱ban re chixjunil li c'a'ru cuan. ");
INSERT INTO kekNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Riq'uin li Santil Musik'ej caye re li rey David laj c'anjel cha̱cuu nak tixye chi jo'ca'in: ¿C'a'ut nak yo̱queb xjosk'il li tenamit li inc'a' neque'xpa̱b li Dios? Ut, ¿c'a'ut nak yo̱queb xc'u̱banquil ribeb chixba̱nunquil li yal ma̱c'a' na-oc cui'? ");
INSERT INTO kekNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Eb li rey que'josk'o' riq'uin li c'a'ru quixba̱nu li Ka̱cua'. Ut que'xch'utub rib chixc'u̱banquil chanru nak te'risi sa' xcuanquil li Mesías li xakabanbil chak xban li Dios. (Sal. 2:1-2) ");
INSERT INTO kekNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","At Ka̱cua', ya̱l ajcui' nak que'xch'utub ribeb sa' li tenamit a'in laj Herodes ut laj Poncio Pilato rochbeneb li tenamit aj Israel jo'queb ajcui' li ma̱cua'eb aj Israel ut que'xc'u̱b ru chanru nak te'xba̱nu raylal re li Jesús la̱ Santil Alal li sic'bil ru a̱ban xban nak xic' que'ril. ");
INSERT INTO kekNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Jo'ca'in que'xba̱nu xban nak ac jo'can chak sa' a̱ch'o̱l la̱at. Ut ac yebil chak a̱ban nak jo'can ta̱c'ulma̱nk. ");
INSERT INTO kekNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ut anakcuan, at Ka̱cua', chaq'ue taxak retal li kase'besinquil yo̱queb, ut choa̱tenk'a la̱o aj c'anjel cha̱cuu re nak takaye la̱ cuesilal chi cau kach'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ut riq'uin taxak xnimal la̱ cuanquil, ta̱q'uirtesiheb li yaj ut chaba̱nu li sachba ch'o̱lej ut milagro sa' xc'aba' li Jesús la̱ Santil Alal, chanqueb sa' lix tijeb. ");
INSERT INTO kekNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nak ac xe'rake' chi tijoc, qui-ec'asi̱c li na'ajej li ch'utch'u̱queb cui'. Ut chixjunileb li cuanqueb aran que'nujac riq'uin li Santil Musik'ej. Ut cauheb xch'o̱l chixyebal li ra̱tin li Dios. ");
INSERT INTO kekNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ut chixjunileb li que'pa̱ban junajeb chic xch'o̱leb ut junajeb chic xc'a'uxeb. Ut ma̱ ani quixye nak junes re a'an li c'a'ru cuan re. Reheb ban sa' comonil chixjunil li c'a'ru cuan reheb. ");
INSERT INTO kekNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Eb li apóstol cauheb xch'o̱l chixch'olobanquil xya̱lal lix cuaclijic cui'chic chi yo'yo li Jesucristo sa' xya̱nkeb li camenak. Ut li Dios quirosobtesiheb chixjunileb chi nabal. ");
INSERT INTO kekNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ma̱ jun sa' xya̱nkeb ma̱c'a' ta cuan re xban nak chixjunileb li cuanqueb xch'och' ut li cuanqueb rochocheb que'xc'ayi ut que'xk'axtesi reheb li apóstol lix tz'ak li que'xc'ayi. ");
INSERT INTO kekNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Coxe'xq'ue li tumin reheb re te'xjeq'ui a' yal jo' q'uial ta̱c'anjelak chiru li junju̱nk. ");
INSERT INTO kekNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Quicuan jun li cui̱nk aj José xc'aba'. Eb li apóstol que'xq'ue Bernabé chok' xcab xc'aba'. Chi jalbil ru naraj naxye “Aj C'ojobanel Ch'o̱lej”. A'an xcomoneb li neque'tenk'an reheb laj tij. Chipre xtenamit. ");
INSERT INTO kekNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Cuan jun xch'och' quixc'ayi. Quixc'am lix tz'ak ut quixq'ue reheb li apóstol. ");
INSERT INTO kekNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Quicuan jun li cui̱nk aj Ananías xc'aba'. Quixc'ayi jun lix ch'och' rochben lix Safira li rixakil. ");
INSERT INTO kekNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ut que'xc'u̱b ru chi ribileb rib nak yijach lix tz'ak li ch'och' ta̱cana̱k chok' reheb. Ut li yijach chic quixc'am laj Ananías riq'uineb li apóstol ut quixye reheb: —A'an a'in chixjunil lix tz'ak li kach'och' li xkac'ayi, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Laj Pedro quixye re: —At Ananías, ¿c'a'ut nak xaq'ue a̱cuib chira̱le laj tza? ¿C'a'ut nak yo̱cat chixbalak'inquil li Santil Musik'ej riq'uin nak yo̱cat chixcanabanquil yijach lix tz'ak li ch'och' chok' a̱cue? ");
INSERT INTO kekNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿C'a'ut nak tat-oc xmukbal xtz'ak la̱ ch'och'? ¿Ma ma̱cua' ta bi' a̱cue? Cui xac'ayi la̱ ch'och', ¿ma inc'a' ta bi' raj xru xcana chok' a̱cue lix tz'ak? Ma̱cua' chiku la̱o yo̱cat chi tic'ti'ic. Chiru ban li Dios, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nak quirabi li a̱tin li quixye laj Pedro, quit'ane' laj Ananías ut camenak quicana. Ut c'ajo' nak qui-oc xxiuheb chixjunileb li que'iloc re jo'queb ajcui' li que'abin resil. ");
INSERT INTO kekNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ut eb li cui̱nk li toj sa̱jeb li cuanqueb aran que'xlan li camenak, que'xpako ut que'xc'am re te'xmuk. ");
INSERT INTO kekNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ac xnume' na chic oxib o̱r nak quicuulac lix Safira li rixakil. Inc'a' naxnau c'a'ru ac xc'ulman. ");
INSERT INTO kekNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Laj Pedro quixye re: —Ye cue. ¿Ma jo' a'in xec'ayi cui' le̱ ch'och'?— Ut lix Safira quixye: —Ya̱l, jo'can xkac'ayi cui', chan. ");
INSERT INTO kekNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ut laj Pedro quixye cui'chic re: —¿C'a'ut nak xec'u̱b che̱ribil e̱rib xyalbal rix li Santil Musik'ej? Cue'queb chak li xe'mukuc chak re la̱ be̱lom ut tate'xc'am ajcui' la̱at, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ut sa' ajcui' li ho̱nal a'an lix Safira quit'ane' chi rok laj Pedro ut camenak quicana. Eb li cui̱nk que'oc sa' cab ut que'ril nak camenak chic. Que'risi ut coxe'xmuk chak chixc'atk lix be̱lom. ");
INSERT INTO kekNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","C'ajo' nak qui-oc xxiuheb chixjunileb laj pa̱banel jo'queb ajcui' chixjunileb li que'abin re li resil a'in. ");
INSERT INTO kekNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Rajlal neque'xch'utub ribeb sa' xmu li templo chixjunileb laj pa̱banel cuan cui' li oqueba̱l Salomón xc'aba'. Nabal li milagro que'xba̱nu eb li apóstol ut nabal li sachba ch'o̱lej. ");
INSERT INTO kekNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Usta eb li tenamit neque'xq'ue xlok'aleb laj pa̱banel, abanan neque'xucuac chi xic sa' xya̱nkeb. ");
INSERT INTO kekNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","C'ajo' nak yo̱queb chi ta̱mc li yo̱queb chi pa̱ba̱nc re li Ka̱cua', jo' cui̱nk jo' ixk. ");
INSERT INTO kekNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ut nabaleb li que'xc'am chak lix yajeb ut que'xyocob sa' lix cuarib malaj chiru lix po̱p chire be. Que'raj nak laj Pedro tixq'uirtesiheb. Eb a'an que'xc'oxla nak usta yal ta̱numek' chiruheb, te'q'uira̱k. ");
INSERT INTO kekNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nabaleb li que'chal chak sa' eb li tenamit li cuanqueb chi nach' riq'uin Jerusalén. Que'xc'am chak li yaj ut eb li cuan ma̱us aj Musik'ej riq'uineb. Ut chixjunileb quilaje'q'uirtesi̱c. ");
INSERT INTO kekNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ut li xyucua'il aj tij ut eb laj saduceo li cuanqueb rochben, c'ajo' nak que'oc xcakalinquileb li apóstol. ");
INSERT INTO kekNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Jo'can nak que'xtakla xchapbaleb ut que'xq'ueheb sa' li tz'alam li neque'q'uehe' cui' yalak ani. ");
INSERT INTO kekNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Abanan chiru li k'ojyi̱n a'an jun lix ángel li Ka̱cua' quixte lix puertil li tz'alam ut quirisiheb sa' tz'alam ut quixye reheb: ");
INSERT INTO kekNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Ayukex sa' li templo ut te̱ch'olob xya̱lal chiruheb li tenamit chirix li ac' yu'am, chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Cuulajak chic nak toj ek'ela que'co̱eb sa' li templo eb li apóstol ut que'oc chixch'olobanquil li xya̱lal chiruheb li tenamit jo' quiyehe' reheb xban li ángel. Sa' ajcui' li ek'ela a'an que'cuulac li xbe̱nil aj tij rochbeneb chixjunileb li neque'tenk'an re, ut que'xbokeb li jun ch'ol chic li neque'c'amoc be chiruheb laj judío jo'queb ajcui' li neque'taklan sa' xbe̱neb. Ut que'xtakla xyebal re laj ilol tz'alam nak te'c'amek' li apóstol riq'uineb. ");
INSERT INTO kekNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Que'cuulac li takl sa' li tz'alam ut inc'a' chic que'ta'e' li apóstol aran. Jo'can nak que'suk'i chixyebal resil ut que'xye: ");
INSERT INTO kekNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Relic chi ya̱l li tz'alam tz'aptz'o chi us nak xkatau. Ut eb laj c'ac'alenel cuanqueb chire li oqueba̱l. Nak xkate li tz'alam, inc'a' chic xkatauheb li cui̱nk chi sa', chanqueb li takl. ");
INSERT INTO kekNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nak que'rabi a'an, eb li xbe̱nil aj tij ut eb li neque'taklan sa' xbe̱neb li soldado li neque'c'ac'alen sa' li templo, que'sach xch'o̱leb ut que'oc chixc'oxlanquil c'a'ru ta̱cana̱k cui' li yo̱ chi c'ulma̱nc. ");
INSERT INTO kekNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Quichal jun ut quixye reheb: —Eb li cui̱nk li que'q'uehe' sa' tz'alam ecue̱r cuanqueb sa' li templo ut yo̱queb chixch'olobanquil li xya̱lal chiruheb li tenamit, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Co̱ ut li jun li nataklan sa' xbe̱neb li soldado rochbeneb lix takl. Ut que'xc'ameb chak li apóstol sa' usilal xban nak que'xucuac. Que'xc'oxla nak ma̱re te'cutek' chi pec xbaneb li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Que'c'ame' laj Pedro ut laj Juan ut que'xakaba̱c chiru li xyucua'il aj tij ut chiruheb li cuanqueb rochben. Ut li xyucua'il aj tij quia̱tinac riq'uineb ut quixye reheb: ");
INSERT INTO kekNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—¿Ma inc'a' ta bi' xkaye e̱re nak inc'a' chic te̱tzoleb li tenamit sa' xc'aba' li cui̱nk a'an? La̱ex yo̱quex chixc'utbal li tijleb a'an sa' chixjunil Jerusalén ut te̱raj xq'uebal sa' kabe̱n lix camic li cui̱nk a'an, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Laj Pedro, jo'queb ajcui' li rech apostolil, que'chak'oc ut que'xye: —¿Ma takak'et li c'a'ru naxye li Dios ut takapa̱b li c'a'ru neque'xye li cui̱nk? Inc'a'. Tento takapa̱b li c'a'ru naxye li Dios. ");
INSERT INTO kekNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Li Dios li que'xlok'oni chak li kaxe'to̱nil yucua', a'an li quicuaclesin cui'chic re li Jesús chi yo'yo sa' xya̱nkeb li camenak, li queq'ue chi camsi̱c chiru cruz la̱ex. ");
INSERT INTO kekNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Li Jesús, a'an li quiq'uehe' xlok'al xban li Dios ut quiq'uehe' chi c'ojla̱c sa' xnim uk' ut quiq'uehe' xcuanquil chi takla̱nc ut chi coloc, re nak laj Israel naru te'yot'ek' xch'o̱leb te'xjal xc'a'ux ut te'cuyek' xma̱queb. ");
INSERT INTO kekNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","La̱o xkil a'an riq'uin ku. Jo'can nak nakach'olob xya̱lal a'in ut li Santil Musik'ej li naxq'ue li Dios reheb li neque'pa̱ban, a'an ajcui' nac'utuc re li xya̱lal a'in, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Li xyucua'il aj tij ut li cuanqueb rochben, c'ajo' nak que'josk'o' nak que'rabi li quixye laj Pedro ut que'raj raj xcamsinquileb li apóstol. ");
INSERT INTO kekNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Abanan sa' xya̱nkeb a'an cuan jun aj fariseo aj Gamaliel xc'aba'. Li cui̱nk a'an aj tzolol chak'rab ut naq'uehe' xcuanquil xbaneb li tenamit. Quixakli chiruheb ut quixtakla risinquileb li apóstol junpa̱t chirix cab. ");
INSERT INTO kekNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ut quixye reheb: —Ex cui̱nk aj Israel, c'oxlahomak chi us c'a'ru te̱ba̱nu riq'uineb li cui̱nk a'in. ");
INSERT INTO kekNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Q'uehomak retal li c'a'ru quixc'ul laj Teudas. A'an quixye nak k'axal nim xcuanquil. Cuan na ca̱hibak ciento chi cui̱nk li neque'ta̱ken re. Aban li jun a'an quicamsi̱c ut chixjunileb li que'ta̱ken re quilaje'xcha'cha'i ribeb ut que'oso' yal chi jo'can. ");
INSERT INTO kekNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ut jo'can ajcui' quixc'ul laj Judas, Galilea xtenamit, nak quic'ulun sa' xk'ehil chixtz'i̱banquil xc'aba'eb li tenamit. Quixbalak'iheb nabaleb li tenamit. Quicam ajcui' a'an ut chixjunileb li que'ta̱ken re que'cha'cha'i̱c. ");
INSERT INTO kekNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Anakcuan la̱in tinye e̱re: Canabomakeb li cui̱nk a'in. Me̱ch'i'ch'i'iheb chic xban nak cui li c'anjel a'in yal xc'a'ux cui̱nk, ta̱osok'. ");
INSERT INTO kekNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Abanan cui ut re li Dios, inc'a' texru̱k chixpo'bal ru. Q'uehomak retal chi us ma̱re anchal yo̱quex chi pletic riq'uin li Dios, chan laj Gamaliel. ");
INSERT INTO kekNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ut que'xc'ul xch'o̱l li quixye. Que'xbokeb li apóstol ut que'xq'ueheb chi saq'uec' ut que'xye reheb nak inc'a' chic te'a̱tinak sa' xc'aba' li Jesús. Ut chirix a'an, que'ach'aba̱c. ");
INSERT INTO kekNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ut eb li apóstol que'el chiruheb chi k'axal sa sa' xch'o̱leb xban nak chiruheb a'an lok' xc'ulbal li raylal sa' xc'aba' li Jesús. ");
INSERT INTO kekNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ut inc'a' que'xcanab xch'olobanquil xya̱lal chiruheb li tenamit sa' li templo ut sa' eb li rochoch ut que'xye resil nak li Jesucristo, a'an laj Colonel li yechi'inbil xban li Dios. ");
INSERT INTO kekNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Sa' eb li cutan a'an c'ajo' nak yo̱queb chi q'uia̱nc eb laj pa̱banel. Ut eb laj judío li neque'a̱tinac sa' griego que'oc chixcuech'inquileb laj judío li neque'a̱tinac sa' hebreo. Que'xye nak inc'a' tz'akal li c'a'ru naq'uehe' rajlal cutan reheb lix ma̱lca'an li cuanqueb sa' xya̱nkeb a'an. ");
INSERT INTO kekNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Jo'can nak li cablaju chi apóstol que'xch'utub chixjunileb laj pa̱banel ut que'xye reheb: —Inc'a' naru takacanab xch'olobanquil ra̱tin li Dios yal re nak tojec'ok tzacae̱mk la̱o. ");
INSERT INTO kekNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ex herma̱n, sic'omak sa' e̱ya̱nk cuukubak chi cui̱nk cha̱bilakeb xna'leb ut nujenakeb chi Santil Musik'ej riq'uineb. Cha̱bilak xyehom xba̱nuhomeb. A'aneb li te'q'uehek' sa' li c'anjel a'in. ");
INSERT INTO kekNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ut la̱o takayal kak'e chi tijoc ut chixjulticanquil li ra̱tin li Dios, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ut que'xc'ul xch'o̱leb chixjunil li cuanqueb aran. Que'xsic' ru laj Esteban li napa̱ban chi tz'akal ut nujenak chi Santil Musik'ej. Ut que'xsic' ajcui' ruheb laj Felipe, laj Prócoro, laj Nicanor, laj Timón, laj Parmenas, ut laj Nicolás aj Antioquía li qui-oc sa' xya̱nkeb laj judío. ");
INSERT INTO kekNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","A'aneb a'in li que'xakaba̱c chi c'anjelac. Ut eb li apóstol que'xq'ue li ruk' sa' xbe̱neb ut que'tijoc. ");
INSERT INTO kekNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Jo'can nak yo̱ chi abi̱c li ra̱tin li Ka̱cua' yalak bar. Ut yo̱queb chi ta̱mc laj pa̱banel aran Jerusalén. Ut nabaleb laj tij que'pa̱ban. ");
INSERT INTO kekNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Laj Esteban a'an jun cui̱nk osobtesinbil xban li Dios ut q'uebil xcuanquil chixba̱nunquil li milagro ut sachba ch'o̱lej sa' xya̱nkeb li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Cuanqueb xcomoneb li neque'tzoloc sa' li cab li neque'xch'utub cui' ribeb laj judío. Aj libertos neque'xye reheb. Sa' xya̱nkeb a'an cuanqueb li neque'chal chak sa' eb li tenamit Cirene, Alejandría, Cilicia ut Asia. Eb a'an yo̱queb chixcuech'inquil laj Esteban. ");
INSERT INTO kekNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Abanan nak quia̱tinac laj Esteban, eb a'an inc'a' chic que'ru xsumenquil xban nak a'an q'uebil xna'leb xban li Santil Musik'ej. ");
INSERT INTO kekNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Aban cuanqueb li que'tumina̱c ru re te'xye tic'ti' chirix laj Esteban. Ut que'xye: —La̱o xkabi nak yo̱ chixmajecuanquil li Dios ut laj Moisés, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ut que'xtacchi'i ajcui' li tenamit, jo'queb ajcui' laj c'amol be ut eb laj tz'i̱b. Que'xchap laj Esteban ut que'xc'am chiruheb li neque'taklan sa' xbe̱neb laj judío. ");
INSERT INTO kekNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ut que'xsic' ani ta̱tic'ti'ik chirix ut que'xk'aba a'an ut que'xye: —Li cui̱nk a'in junelic yo̱ chixsachbal xcuanquil li santil na'ajej a'in ut naxtz'ekta̱na li chak'rab li quiq'uehe' re laj Moisés. ");
INSERT INTO kekNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","La̱o quikabi nak yo̱ chixyebal nak li Jesús laj Nazaret tixjuc' li na'ajej a'in, ut tixjal ru li chak'rab li coxtzol cui' laj Moisés, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ut chixjunileb li neque'taklan sa' xbe̱neb laj judío li c'ojc'o̱queb aran que'ril laj Esteban ut que'xq'ue retal nak nalemtz'un li riloba̱l. Chanchan na-iloc jun li ángel. ");
INSERT INTO kekNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ut li xyucua'il eb laj tij quixpatz' re laj Esteban ma ya̱l li yo̱queb chixyebal. ");
INSERT INTO kekNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Quichak'oc laj Esteban ut quixye: —Ex cuas cui̱tz'in ut la̱ex li nequexc'amoc be, abihomak li oc cue chixyebal. Li Dios li k'axal lok' quixc'utbesi rib chiru laj Abraham li kaxe'to̱nil yucua' nak cuan aran Mesopotamia nak toj ma̱ji' naxic chi cua̱nc sa' li na'ajej Harán. ");
INSERT INTO kekNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Quixye re: —Tat-e̱lk sa' li na'ajej a'in. Ta̱canabeb la̱ cuech'alal ut tatxic sa' jun li na'ajej li tinc'ut cha̱cuu la̱in, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Qui-el ut laj Abraham sa' li na'ajej Caldeo ut co̱ chi cua̱nc sa' li na'ajej Harán. Nak ac cuan sa' li na'ajej a'an quicam lix yucua'. Ut chirix a'an li Dios quixtakla chi cua̱nc sa' li na'ajej li cuanquex cui' la̱ex anakcuan. ");
INSERT INTO kekNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Abanan li Dios inc'a' quixq'ue xch'och' laj Abraham aran. Chi ti̱c ma̱c'a' quixq'ue re. Abanan quixye re nak tixq'ue chok' reheb li ralal xc'ajol li te'cua̱nk mokon usta toj ma̱ jun lix coc'al cuan. ");
INSERT INTO kekNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","A'an a'in li quixye li Dios re laj Abraham: —Eb la̱ cualal a̱c'ajol te'cua̱nk sa' jalan tenamit ma̱cua' xtenamiteb. Ut sa' li tenamit a'an te'cua̱nk chok' rahobtesinbil mo̱s ut xic' te'ilek' chiru ca̱hib ciento chihab. ");
INSERT INTO kekNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ut la̱in tinrakok a̱tin sa' xbe̱n li tenamit a'an li te'rahobtesi̱nk reheb la̱ cualal a̱c'ajol. Ut nak te'e̱lk sa' li tenamit a'an te'c'anjelak chicuu sa' li na'ajej a'in, chan li Dios. ");
INSERT INTO kekNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nak li Dios quixba̱nu li contrato riq'uin laj Abraham quixye re nak tento te'xba̱nu li circuncisión. Jo'can nak laj Abraham quixba̱nu li circuncisión riq'uin laj Isaac li ralal nak ac cuan cuakxakib cutan re. Ut laj Isaac quixba̱nu riq'uin laj Jacob li ralal ut jo'can ajcui' quixba̱nu laj Jacob riq'uineb li ralal cablaju. ");
INSERT INTO kekNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Eb li ralal laj Jacob c'ajo' nak que'xcakali laj José li ri̱tz'ineb. Jo'can nak que'xc'ayi laj José ut quic'ame' aran Egipto. Abanan nak ac cuan aran Egipto, li Dios yo̱ chi tenk'a̱nc re. ");
INSERT INTO kekNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ut a'an quitenk'an re chixcuybal li raylal li quixc'ul. Quirosobtesi ut quixq'ue xna'leb. Ut laj Faraón li acuabej aran Egipto quixq'ue retal nak laj José cuan xna'leb ut quixxakab chi takla̱nc sa' xbe̱n li tenamit ut sa' xbe̱neb ajcui' li cuanqueb sa' li rochoch. ");
INSERT INTO kekNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ut quicuan jun nimla cue'ej ut jun nimla raylal sa' eb li tenamit Egipto ut Canaán. Ut eb li kaxe'to̱nil yucua' inc'a' chic que'xtau xtzacae̱mkeb. ");
INSERT INTO kekNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nak quirabi laj Jacob nak aran Egipto cuan nabal li trigo, quixtaklaheb li ralal aran chixc'ambaleb xtrigo. ");
INSERT INTO kekNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nak que'co̱eb cui'chic xca' sut li ralal aran Egipto, laj José quixye reheb nak a'an laj José li ri̱tz'ineb. Ut sa' ajcui' li cutan a'an laj Faraón quixnau nak laj José, a'an xcomoneb li ralal xc'ajoleb laj judío. ");
INSERT INTO kekNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ut chirix a'an laj José quixtakla xc'ambal lix yucua' jo'queb ajcui' li rech'alal. Chixjunileb li rech'alal cuanqueb o'laju xca̱c'a̱l (75). ");
INSERT INTO kekNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jo'ca'in nak co̱eb aran Egipto laj Jacob li kaxe'to̱nil yucua' ut aran quicam jo'queb ajcui' li ralal. ");
INSERT INTO kekNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Lix bakeleb que'c'ame' Siquem ut que'muke' sa' li na'ajej li quixlok' laj Abraham riq'uineb li ralal xc'ajol laj Hamor. ");
INSERT INTO kekNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","C'ajo' nak yo̱queb chi q'uia̱nc li ralal xc'ajol laj Israel aran Egipto nak ac yo̱ chi cuulac xk'ehil nak te'isi̱k sa' li tenamit a'an jo' quiyechi'i̱c re laj Abraham xban li Dios. ");
INSERT INTO kekNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ut qui-oc jalan chic acuabej ut a'an inc'a' quixnau ru laj José chi moco quixnau chanru lix na'leb nak quicuan. ");
INSERT INTO kekNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Li acuabej a'an quixsic' xya̱lal chanru nak tixba̱nu raylal reheb li kaxe'to̱nil yucua'. Quixrahobtesiheb nak quixtakla xcamsinquileb li coc' te̱lom li te'yo'la̱k re nak inc'a' chic te'ta̱mk li ralal xc'ajoleb. ");
INSERT INTO kekNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Sa' eb li cutan a'an quiyo'la laj Moisés. Li c'ula'al a'an raro xban li Ka̱cua'. Ut oxib po quiq'uiresi̱c xbaneb lix na' xyucua'. ");
INSERT INTO kekNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Abanan quicuulac xk'ehil nak quicanaba̱c chak sa' li nima' ut lix rabin laj Faraón quixococ re, re ta̱ru̱k ta̱colek'. Quixc'am chok' re ut quixq'uiresi jo' tz'akal re. ");
INSERT INTO kekNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Laj Moisés quixtzol rib jo' neque'xtzol ribeb laj Egipto. Ut cuan xna'leb chi a̱tinac ut chixba̱nunquil li cha̱bil na'leb. ");
INSERT INTO kekNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Nak ac xba̱nu li ca'c'a̱l chihab (40), qui-ala sa' xch'o̱l xic chirilbaleb laj Israel li rech tenamitil. ");
INSERT INTO kekNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Nak quiril jun reheb yo̱ chi saq'uec' xban jun aj Egipto, quixcol sa' ruk'. Quixchap laj Egipto ut quixcamsi. Chi jo'ca'in quixq'ue re̱kaj li quixba̱nu re li rech tenamitil. ");
INSERT INTO kekNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Laj Moisés quixc'oxla nak eb li rech tenamitil te'xq'ue retal nak a'an li ta̱c'anjelak chiru li Dios re xcolbaleb. Abanan eb a'an inc'a' que'xq'ue retal. ");
INSERT INTO kekNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Cuulajak chic laj Moisés quixtau cuib laj Israel yo̱queb chi pletic. Quixk'useb re te'xcanab xch'e'bal rib. Quixye reheb: —La̱ex e̱comon e̱rib. ¿C'a'ut nak yo̱quex chixpletinquil e̱rib? chan reheb. ");
INSERT INTO kekNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ut li jun li yo̱ chi sac'oc re li jun chic quixtiquisi laj Moisés ut quixye re: —¿Ani xq'uehoc a̱cue chi takla̱nc ut chi rakoc a̱tin sa' kabe̱n? ");
INSERT INTO kekNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Ma ta̱cuaj tina̱camsi la̱in jo' nak xacamsi laj Egipto ecue̱r? chan re laj Moisés. ");
INSERT INTO kekNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nak quirabi li c'a'ru quixye, laj Moisés quixucuac ut quie̱lelic. Co̱ chi cua̱nc sa' li na'ajej Madian li moco tz'akal xtenamit ta. Nak cuan aran, que'yo'la cuib li ralal. ");
INSERT INTO kekNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ac xnume' chic ca'c'a̱l chihab roquic sa' li chaki ch'och' a'an, nak quiril jun to̱n li q'uix yo̱ xxamlel nach' riq'uin li tzu̱l Sinaí. Ut sa' li xam a'an quixc'utbesi rib jun li ángel chiru. ");
INSERT INTO kekNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ut laj Moisés c'ajo' nak quisach xch'o̱l chirilbal ut quinach'oc riq'uin re ta̱ril chi us. Quirabi xya̱b xcux li Ka̱cua' nak quixye: ");
INSERT INTO kekNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","—La̱in li Ka̱cua' Dios li que'xlok'oni chak la̱ xe'to̱nil yucua'. La̱in li Dios li que'xlok'oni chak laj Abraham, laj Isaac, ut laj Jacob, chan. Ut laj Moisés nasicsot xban xxiu ut inc'a' chic quixcuy rilbal. ");
INSERT INTO kekNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ut quixye li Ka̱cua' re: —Isi la̱ xa̱b cha̱cuok xban nak li na'ajej cuancat cui', a'an santil na'ajej. ");
INSERT INTO kekNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Relic chi ya̱l la̱in yo̱quin chirilbal li raylal li yo̱queb chixc'ulbal lin tenamit li cuanqueb Egipto. Ut yo̱quin ajcui' chirabinquil nak yo̱queb xk'okonquil ribeb xban li raylal. Jo'can nak xinchal chixcolbaleb sa' ruk'eb laj Egipto. Abi li tinye a̱cue. Tatintakla Egipto, chan li Ka̱cua' re laj Moisés. ");
INSERT INTO kekNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Laj Moisés, a'an li que'xtz'ekta̱na laj Israel nak que'xye: —¿Ani xq'uehoc a̱cue chi takla̱nc ut chi rakoc a̱tin? chanqueb. A'an li quitakla̱c chixtenk'anquileb laj Israel ut chixcolbaleb. Quitakla̱c xban li Ka̱cua' nak li ángel quixc'utbesi rib chiru sa' li jun to̱n chi q'uix yo̱ xxamlel. ");
INSERT INTO kekNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Laj Moisés, a'an li qui-isin reheb Egipto. Nabal li milagro ut li sachba ch'o̱lej quixba̱nu aran Egipto ut sa' li Caki Palau. Chiru ca'c'a̱l chihab quic'amoc be chiruheb sa' li chaki ch'och'. ");
INSERT INTO kekNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","A'an laj Moisés li quiyehoc chak re a'in reheb laj Israel: —Li Ka̱cua' le̱ Dios tixq'ue junak profeta sa' e̱ya̱nk sic'bil ru xban jo' la̱in. E̱comon ajcui' la̱ex. Cheba̱nu chixjunil li c'a'ru tixye e̱re, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","A'an li quicuan rochbeneb laj Israel nak que'xch'utub ribeb sa' li chaki ch'och'. Quicuan rochbeneb li kaxe'to̱nil yucua' ut rochben ajcui' li ángel li quia̱tinac riq'uin sa' li tzu̱l Sinaí nak quixye re li ra̱tin li Dios li naq'uehoc yu'am re nak a'an chic ta̱yehok ke la̱o. ");
INSERT INTO kekNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Abanan eb li kaxe'to̱nil yucua' inc'a' que'raj xpa̱banquil li c'a'ru quixye. Que'xtz'ekta̱na ban ut que'raj raj suk'i̱c cui'chic Egipto. ");
INSERT INTO kekNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Que'xye re laj Aarón: —Yi̱b kadios re te'c'amok be chiku. Inc'a' nakanau c'a'ru xc'ul chak laj Moisés li qui-isin chak ke Egipto. ¿C'a'ru aj e nak yo̱ko chiroybeninquil? chanqueb li kaxe'to̱nil yucua'. ");
INSERT INTO kekNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Jo'can nak que'xyi̱b riq'uin oro xjalam u̱ch jun li cuacax ut que'mayejac chiru. C'ajo' nak que'saho' sa' xch'o̱leb chirilbal lix dioseb li que'xyi̱b riq'uin ruk'eb. Ut que'xba̱nu jun li nink'e re xlok'oninquil. ");
INSERT INTO kekNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Jo'can nak li Ka̱cua' Dios quixcanabeb xjuneseb. Quixcanabeb chixlok'oninquil li chahim li cuan chiru choxa. Ut quitz'akloc ru li tz'i̱banbil chak najter xbaneb li profeta nak que'xye: La̱ex aj Israel, ¿ma quexmayejac ta bi' chak chicuu la̱in nak yo̱quex chak chi numec' sa' li chaki ch'och' chiru ca'c'a̱l chihab? ");
INSERT INTO kekNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","¿Ma ma̱cua' ta bi' le̱ yi̱banbil dios Moloc ut Renfán quelok'oni? La̱ex queyi̱b li jalam u̱ch a'in re te̱lok'oni. Jo'can nak texincanab re nak jalan tenamit ta̱numta̱k sa' e̱be̱n ut texc'amek' chi najt sa' jun li na'ajej li cuan jun pac'al li tenamit Babilonia, chan li Ka̱cua'. (Am. 5:25-27) ");
INSERT INTO kekNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Eb li kaxe'to̱nil yucua' que'xyi̱b ajcui' chak li tabernáculo nak yo̱queb chak chi numec' sa' li chaki ch'och' ut aran xocxo li chak'rab. Que'xyi̱b jo' li retalil li quic'ute' chiru laj Moisés xban li Dios. ");
INSERT INTO kekNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Eb li kaxe'to̱nil yucua' que'xc'ul li muheba̱l a'in. Ut nak laj Josué quic'amoc be chiruheb chi pletic, que'xc'am li muheba̱l chirixeb. Ut que're̱chani lix ch'och'eb li ma̱cua'eb aj judío nak li Dios quirisi chiruheb li kaxe'to̱nil yucua' li xic' que'iloc reheb. Li muheba̱l a'an quic'anjelac sa' eb li cutan a'an toj chalen nak quicuan laj David chok' rey. ");
INSERT INTO kekNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Laj David quixba̱nu li c'a'ru quiraj li Dios, ut li Dios quisaho' xch'o̱l riq'uin. Quixtz'a̱ma chiru li Dios nak tixyi̱b li templo bar te'xlok'oni cui' li Dios li quixlok'oni laj Jacob. ");
INSERT INTO kekNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Abanan ma̱cua' laj David quiyi̱ban re li templo. Laj Salomón, a'an li quiyi̱ban re. ");
INSERT INTO kekNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Quixyi̱b li templo usta li nimajcual Dios inc'a' nacuan sa' junak cab yi̱banbil xban cui̱nk jo' quixye chak li profeta Isaías nak quixye chi jo'ca'in: ");
INSERT INTO kekNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Li choxa, a'an li na'ajej li ninc'ojla cui' ut li ruchich'och', a'an xna'aj li cuok. ¿C'a'ru chi ochochil ta̱ru̱k te̱yi̱b chok' cue? Ut, ¿bar cuan lin na'aj li tinhila̱nk cui'? ");
INSERT INTO kekNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Ma ma̱cua' ta bi' la̱in xinyi̱ban re chixjunil li c'a'ru cuan? chan li Ka̱cua'. (Is. 66:1-2) ");
INSERT INTO kekNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","La̱ex inc'a' nequetau xya̱lal. K'axal cau e̱ch'o̱l. Chanchanex li inc'a' neque'pa̱ban re li Dios. Junelic nequek'etk'eti e̱rib chiru li Santil Musik'ej jo' que'xba̱nu le̱ xe'to̱nil yucua'. ");
INSERT INTO kekNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Ma cuan ta bi' junak profeta inc'a' quirahobtesi̱c xbaneb le̱ xe'to̱nil yucua'? ¿Ma inc'a' ta bi' que'xcamsiheb li que'ch'oloban chak resil lix c'ulunic li jun li Ti̱c Xch'o̱l, li quek'axtesi la̱ex chi camsi̱c? ");
INSERT INTO kekNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","La̱ex quec'ul li chak'rab li quixq'ue e̱re li ángel, abanan inc'a' nequeba̱nu li c'a'ru naxye, chan laj Esteban. ");
INSERT INTO kekNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nak que'rabi li c'a'ru yo̱ chixyebal laj Esteban, c'ajo' nak que'josk'o'. Que'xc'uxuxi li ruch re xbaneb xjosk'il. ");
INSERT INTO kekNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ut laj Esteban nujenak chi Santil Musik'ej. Qui-iloc sa' choxa ut quiril lix nimajcual lok'al li Dios ut quiril li Jesús sa' xnim uk' li Dios. ");
INSERT INTO kekNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Quixye: —Ilomak. Teto li choxa nak nacuil ut li C'ajolbej cuan chi xnim uk' li Dios, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ut eb li tenamit xic' que'rabi li quixye ut que'xtz'ap lix xiqueb ut que'xjap reheb chi cau xban xjosk'ileb ut jun xiquiqueb sa' xbe̱n nak que'xchap. ");
INSERT INTO kekNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Que'risi laj Esteban sa' li tenamit. Ut eb li oqueb re chi cutuc re chi pec, que'xcanab li rak'eb chi rok jun li sa̱j cui̱nk aj Saulo xc'aba'. ");
INSERT INTO kekNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nak yo̱queb chixcutbal chi pec, laj Esteban yo̱ chi tijoc ut quixye: —At Ka̱cua' Jesús, c'ul lin musik'.— ");
INSERT INTO kekNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Quixcuik'ib rib, quixjap re chi cau ut quixye: —At Ka̱cua', ma̱q'ue li ma̱c a'in sa' xbe̱neb.— Ut nak quixye a'an, quicam. ");
INSERT INTO kekNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Laj Saulo quixc'ul xch'o̱l nak que'xcamsi laj Esteban. Chalen sa' li cutan a'an que'oc xrahobtesinquileb chixjunileb laj pa̱banel aran Jerusalén ut c'ajo' li raylal que'xc'ul. Ut chixjunileb quilaje'xjeq'ui rib sa' eb li na'ajej Judea ut Samaria. Ca'aj chic eb li apóstol que'cana Jerusalén. ");
INSERT INTO kekNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Cuib oxib laj pa̱banel que'mukuc re laj Esteban ut c'ajo' nak que'raho' xch'o̱leb xban lix camic. ");
INSERT INTO kekNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Aban laj Saulo yalyo xk'e chixrahobtesinquileb laj pa̱banel. Na-oc sa' eb li cab ut narisiheb sa' rochocheb ut naxc'ameb sa' tz'alam, jo' cui̱nk jo' ixk. ");
INSERT INTO kekNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ut chixjunileb li que'xjeq'ui ribeb sa' jalan na'ajej yo̱queb chixyebal resil li evangelio yalak bar. ");
INSERT INTO kekNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Laj Felipe co̱ sa' li tenamit Samaria ut qui-oc chixch'olobanquil resil chiruheb li tenamit nak li Cristo, a'an laj Colonel li yechi'inbil xban li Dios. ");
INSERT INTO kekNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ut chixjunileb que'xq'ue xch'o̱l chirabinquil li a̱tin li quixye laj Felipe xbaneb li milagro quilajxba̱nu. ");
INSERT INTO kekNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Nabaleb li cuan ma̱us aj musik'ej riq'uineb que'q'uirtesi̱c. Japjo̱queb re li ma̱us aj musik'ej nak neque'el riq'uineb. Ut nabaleb li ye̱k rokeb ut li sic rok ruk'eb quilaje'q'uirtesi̱c. ");
INSERT INTO kekNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ut c'ajo' nak que'saho' sa' xch'o̱leb sa' li tenamit a'an. ");
INSERT INTO kekNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Quicuan jun li cui̱nk aj Simón xc'aba'. A'an aj k'e. Ac najter na-oc chixbalak'inquileb li cuanqueb sa' li tenamit Samaria. A'an naxye nak nim xcuanquil. ");
INSERT INTO kekNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ut chixjunileb li tenamit, jo' li cuanqueb xcuanquil jo' ajcui' li ma̱c'a'eb xcuanquil, que'rabi li c'a'ru yo̱ chixyebal laj Simón ut que'xye: —Li cui̱nk a'in, cuan xcuanquil li Dios riq'uin, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ut que'xq'ue xch'o̱l chixba̱nunquil li c'a'ru naxye xban nak ac junxil na-oc chixbalak'inquileb. ");
INSERT INTO kekNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","A'ut laj Felipe yo̱ chixjulticanquil resil xnimal xcuanquilal li Dios ut li Jesucristo. Ut nabaleb que'pa̱ban ut que'cubsi̱c xha', jo' cui̱nk jo' ixk. ");
INSERT INTO kekNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ut quipa̱ban ajcui' laj Simón ut quicubsi̱c xha'. Ut yo̱ chi xic chirix laj Felipe yalak bar. Quisach xch'o̱l chirilbaleb li milagro ut li sachba ch'o̱lej li yo̱ chixba̱nunquil laj Felipe. ");
INSERT INTO kekNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Eb li apóstol li toj cuanqueb Jerusalén que'rabi resil nak eb laj Samaria yo̱queb chixpa̱banquil li Dios. Jo'can nak que'xtakla laj Pedro ut laj Juan aran. ");
INSERT INTO kekNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nak que'cuulac Samaria, que'tijoc sa' xbe̱neb laj pa̱banel re nak te'xc'ul li Santil Musik'ej xban nak toj ma̱ji' que'xc'ul. ");
INSERT INTO kekNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ca'aj cui' que'cubsi̱c xha' sa' xc'aba' li Jesucristo. ");
INSERT INTO kekNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Laj Pedro ut laj Juan que'xq'ue li ruk'eb sa' xbe̱neb ut que'xc'ul li Santil Musik'ej. ");
INSERT INTO kekNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ut quiril laj Simón nak riq'uin xq'uebal li ruk'eb li apóstol sa' xbe̱neb, neque'xc'ul li Santil Musik'ej. Ut quixyechi'i tumin reheb laj Pedro ut laj Juan ut quixye reheb: ");
INSERT INTO kekNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","—Q'ue cue li cuanquil a'an re nak li ani tinq'ue li cuuk' sa' xbe̱n tixc'ul li Santil Musik'ej, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Laj Pedro quixye re: —Chisachk la̱ tumin a̱cuochben xban nak xac'oxla nak ta̱ru̱k ta̱lok' riq'uin tumin li naxq'ue chi ma̱tan li Ka̱cua' Dios, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","La̱at inc'a' ta̱ru̱k ta̱c'ul li ma̱tan a'in xban nak moco ti̱c ta la̱ ch'o̱l chiru li Dios. ");
INSERT INTO kekNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Cui ta̱yot' a̱ch'o̱l ta̱jal a̱c'a'ux ut ta̱canab xba̱nunquil li ma̱usilal a'in ut cui ta̱tz'a̱ma a̱cuybal chiru li Dios, ma̱re chan nak tixcuy a̱ma̱c riq'uin li xac'oxla. ");
INSERT INTO kekNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","La̱at c'ajo' nak nacatcakalin ut junes ma̱usilal nacac'oxla, chan laj Pedro. ");
INSERT INTO kekNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Quichak'oc laj Simón ut quixye: —Chextijok chicuix chiru li Ka̱cua' re nak inc'a' tinc'ul jo' xaye la̱at, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Nak ac xe'xch'olob xya̱lal li ra̱tin li Dios ut que'xye resil li Jesucristo, laj Pedro ut laj Juan que'suk'i cui'chic Jerusalén. Ut que'xch'olob xya̱lal sa' nabal chi tenamit cuanqueb sa' xcue̱nt Samaria. ");
INSERT INTO kekNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ut jun lix ángel li Ka̱cua' quia̱tinac riq'uin laj Felipe ut quixye re: —Tatxic sa' li be li cuan sa' li sur. Li be a'an li nanume' sa' li chaki ch'och' naxic Jerusalén toj Gaza.— ");
INSERT INTO kekNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Laj Felipe co̱. Nak yo̱ chi xic quiril jun li cui̱nk aj Etiopía. A'an jun eunuco q'uebil xcuanquil chi c'anjelac chiru lix Candace li reina li cuan Etiopía. Sa' ruk' li cui̱nk a'an k'axtesinbil chixjunil lix biomal li reina. Li cui̱nk a'an co̱ Jerusalén chixlok'oninquil li Dios. ");
INSERT INTO kekNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Yo̱ chi suk'i̱c sa' rochoch. C'ojc'o sa' lix carruaje ut yo̱ chirilbal xsa' li hu li quixtz'i̱ba li profeta Isaías. ");
INSERT INTO kekNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Li Santil Musik'ej quixye re laj Felipe: —Ayu, jilon chixc'atk li carruaje a'an, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Quijiloc laj Felipe ut quirabi nak li cui̱nk yo̱ chirilbal xsa' li hu li quixtz'i̱ba li profeta Isaías. Laj Felipe quixpatz' re: —¿Ma nacatau ru li yo̱cat chirilbal? chan re. ");
INSERT INTO kekNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ut li cui̱nk quixye: —¿Chanru nak tintau ru cui ma̱ ani junak ta̱c'utuk lix ya̱lal chicuu?— Ut quixtz'a̱ma chiru laj Felipe nak ta̱takek' sa' li carruaje ut ta̱c'ojla̱k chixc'atk. ");
INSERT INTO kekNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ut li hu li yo̱ chirilbal xsa', a'an li quixtz'i̱ba li profeta Isaías. Naxye chi jo'ca'in: Nak yo̱ xrahobtesinquil, quixcubsi rib ut ma̱ jun a̱tin quixye jo' jun carner nak quic'ame' chi camsi̱c. Chanchan nak naxcanab rib li carner chi besec' li rix chiruheb li neque'besoc re, jo'can quixba̱nu a'an. Ut ma̱ jun a̱tin quixye. ");
INSERT INTO kekNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Usta ma̱c'a' xma̱c, quichape' ut quiq'uehe' chi camsi̱c. Ut ma̱ ani qui-oquen chirix re xcolbal. Quicamsi̱c ban. ¿Ani ta̱ru̱k ta̱yehok li resil lix yibal ru xna'lebeb li rech tenamitil? (Is. 53:7-8) ");
INSERT INTO kekNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Li cui̱nk quixye re laj Felipe: —Ye cue, ¿ani chi aj ix naxye a'in li profeta? ¿Ma chirix a'an, malaj ut chirix jalan chic? chan. ");
INSERT INTO kekNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Laj Felipe qui-oc chixch'olobanquil lix ya̱lal chiru. Quixtiquib riq'uin li quixtz'i̱ba li profeta Isaías ut toj quixch'olob xya̱lal chirix li Jesucristo. ");
INSERT INTO kekNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Nak yo̱queb chi xic, que'cuulac cuan cui' jun li ha'. Ut li cui̱nk quixye: —Arin cuan ha'. ¿Ma inc'a' ta̱ru̱k ta̱cube̱k inha' la̱in? chan. ");
INSERT INTO kekNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ut laj Felipe quixye re: —Cui nacapa̱b chi anchal a̱ch'o̱l li Jesucristo, ta̱ru̱k ta̱cube̱k a̱ha', chan. Li cui̱nk quichak'oc ut quixye: —Ninpa̱b nak li Jesucristo, a'an Ralal li Dios, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ut quixxakab li carruaje. Tojo'nak laj Felipe ut li cui̱nk co̱eb sa' li ha' ut laj Felipe quixcubsi xha'. ");
INSERT INTO kekNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nak que'el chak sa' li ha', li Santil Musik'ej quixc'am laj Felipe ut li cui̱nk inc'a' chic quiril ru. Co̱ xjunes chi sa sa' xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ut laj Felipe quic'ame' Azoto ut coxnumek' sa' chixjunileb li tenamit. Yo̱ chixch'olobanquil xya̱lal li evangelio chalen nak quicuulac sa' li tenamit Cesarea. ");
INSERT INTO kekNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Nak yo̱ chi c'ulma̱nc a'in, laj Saulo toj yo̱ chixrahobtesinquileb li neque'pa̱ban re li Ka̱cua' ut yo̱ chixyebal nak toj tixcamsiheb. Jo'can nak co̱ riq'uin li xyucua'il aj tij. ");
INSERT INTO kekNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ut quixtz'a̱ma lix hu chiru re tixk'axtesi sa' eb li cab li neque'xch'utub cui' ribeb laj judío aran Damasco re ta̱ru̱k tixchapeb laj pa̱banel li tixtau aran, jo' cui̱nk jo' ixk. Tixchapeb ut tixc'ameb chi pre̱xil Jerusalén. ");
INSERT INTO kekNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Yo̱ chi xic ut nak ac cuulac re sa' li tenamit Damasco, sa' junpa̱t quisute' xban jun chanchan xam quichal sa' choxa. ");
INSERT INTO kekNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Quit'ane' sa' ch'och' laj Saulo ut quirabi jun xya̱b cux yo̱ chixyebal re: —At Saulo, at Saulo, ¿C'a'ut nak yo̱cat chixba̱nunquil raylal cue?— ");
INSERT INTO kekNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Laj Saulo quixye: —¿Anihat la̱at, at Ka̱cua'?— Ut li yo̱ chi a̱tinac quixye: —La̱in li Jesús li xic' yo̱cat chirilbal. Yo̱cat chixtacuasinquil a̱cuib nak xic' yo̱cat chicuilbal, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Nasicsot xban xxiu laj Saulo nak quixye: —Ka̱cua', ¿c'a'ru ta̱cuaj tinba̱nu? chan. Ut li Ka̱cua' quixye: —Cuaclin ut ayu sa' li tenamit, ut aran ta̱yehek' a̱cue c'a'ru us ta̱ba̱nu, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ut eb li cui̱nk li yo̱queb chi xic rochben sachso̱queb xch'o̱l que'cana. Yo̱queb chirabinquil li yo̱ chi a̱tinac, abanan inc'a' que'ril ru li ani yo̱ chi a̱tinac. ");
INSERT INTO kekNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Quicuacli laj Saulo ut nak quixte li xnak' ru, inc'a' chic qui-iloc. Ch'ilonbil chi ruk' nak quic'ame' sa' li tenamit Damasco. ");
INSERT INTO kekNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Aran quicuan chiru oxib cutan. Inc'a' na-iloc ut inc'a' quicua'ac chi moco qui-uc'ac. ");
INSERT INTO kekNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Aran Damasco cuan jun laj pa̱banel aj Ananías xc'aba'. Li Ka̱cua' quia̱tinac riq'uin sa' visión ut quixye re: —At Ananías.— Quichak'oc ut quixye re: —Cue'quin, Ka̱cua'.— ");
INSERT INTO kekNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ut li Ka̱cua' quixye re: —La̱in tinye a̱cue, ayu sa' rochoch laj Judas li cuan sa' li nim be li Ti̱c neque'xye re. Aran ta̱sic' jun li cui̱nk li xchal chak Tarso. Aj Saulo xc'aba'. A'an yo̱ chi tijoc aran. ");
INSERT INTO kekNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Laj Saulo xril jun li visión. Xat-oc riq'uin nak xril ut xaq'ue la̱ cuuk' sa' xbe̱n re nak ta̱ilok cui'chic, chan li Ka̱cua'. ");
INSERT INTO kekNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Laj Ananías quichak'oc ut quixye: —At Ka̱cua', nabal que'yehoc resil cue nak xic' narileb laj pa̱banel li cui̱nk a'an. C'ajo' li raylal nalajxba̱nu reheb la̱ cualal a̱c'ajol li cuanqueb aran Jerusalén. ");
INSERT INTO kekNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ut jo'can ajcui' arin xq'uehe' xcuanquil xbaneb li xbe̱nil aj tij chixq'uebaleb sa' tz'alam chixjunileb li neque'pa̱ban a̱cue, chan laj Ananías. ");
INSERT INTO kekNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ut li Ka̱cua' quixye re: —Ayu xban nak li cui̱nk a'an sic'bil ru inban re xyebal resil li colba-ib sa' inc'aba' la̱in reheb li cuanqueb sa' xcuanquil ut reheb ajcui' li ma̱cua'eb aj judío jo'queb ajcui' li ralal xc'ajol laj Israel. ");
INSERT INTO kekNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","La̱in tinc'ut chiru jo' q'uial li raylal tento tixc'ul sa' inc'aba' la̱in, chan li Ka̱cua'. ");
INSERT INTO kekNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Co̱ ut laj Ananías ut qui-oc sa' li cab jo' quiyehe' re. Quixq'ue li ruk' sa' xbe̱n laj Saulo ut quixye re: —Hermano Saulo, li Ka̱cua' Jesús, li quixc'utbesi rib cha̱cuu sa' li be nak yo̱cat chi cha̱lc arin, a'an xtaklan chak cue arin re nak ta̱ru̱k tat-ilok cui'chic ut ta̱c'ul li Santil Musik'ej, chan laj Ananías re. ");
INSERT INTO kekNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ut sa' junpa̱t quit'ane' chanchan xpat li ru ut qui-iloc cui'chic. Quixakli ut quicubsi̱c xha'. ");
INSERT INTO kekNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ut nak ac xcua'ac, quicacuu cui'chic. Laj Saulo quicana cuib oxib cutan sa' xya̱nkeb laj pa̱banel li cuanqueb Damasco. ");
INSERT INTO kekNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Laj Saulo ticto qui-oc chixch'olobanquil li xya̱lal chirix li Jesús, chiruheb li tenamit sa' eb li cab li neque'xch'utub cui' ribeb laj judío ut quixye reheb: —Li Jesús, a'an li Cristo li Ralal li Dios, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ut chixjunileb li yo̱queb chi abi̱nc re que'sach xch'o̱leb chirabinquil ut que'xye: —¿Ma ma̱cua' ta bi' a'an li yo̱ chi rahobtesi̱nc reheb laj pa̱banel aran Jerusalén? ¿Ma ma̱cua' ta bi' re xchapbaleb laj pa̱banel nak xchal arin re nak tixc'ameb riq'uineb li xbe̱nil aj tij? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ut laj Saulo k'axal cui'chic quixq'ue xch'o̱l chixch'olobanquil xya̱lal ut que'sach xch'o̱leb laj judío li cuanqueb Damasco xban nak yo̱ chixc'utbal chi tz'akal chiruheb nak li Jesús a'an li Cristo laj Colonel li yechi'inbil xban li Dios. ");
INSERT INTO kekNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ac cuan cutan xc'ulbal a'an nak que'xc'u̱b ru chi ribileb rib laj judío chanru nak te'xcamsi laj Saulo. ");
INSERT INTO kekNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Abanan laj Saulo quirabi resil nak te'raj xcamsinquil. Eb a'an chi k'ek chi cutan yo̱queb chixc'ac'alenquil li oqueba̱l re li tenamit re te'xcamsi. ");
INSERT INTO kekNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ut eb laj pa̱banel que'xq'ue sa' jun nimla chacach ut chiru k'ojyi̱n que'xcubsi chirix li tz'ac. Jo'can nak quicole' laj Saulo chiruheb li que'ajoc re xcamsinquil. ");
INSERT INTO kekNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Nak quicuulac Jerusalén, laj Saulo quiraj oc sa' xya̱nkeb laj pa̱banel. Abanan eb a'an que'xucuac. Inc'a' que'xpa̱b nak a'an aj pa̱banel chic. ");
INSERT INTO kekNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ut laj Bernabé quixc'am laj Saulo riq'uineb li apóstol ut quixserak'i reheb chanru nak quiril ru li Ka̱cua' sa' li be ut quixye ajcui' reheb chanru nak quixch'olob xya̱lal li Jesucristo chi cau xch'o̱l aran Damasco. ");
INSERT INTO kekNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ut laj Saulo quicana riq'uineb laj pa̱banel aran Jerusalén ut co̱ yalak bar chixyebal resil li Jesucristo chi cau xch'o̱l. ");
INSERT INTO kekNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ut quixch'olob li xya̱lal chiruheb laj judío li neque'a̱tinac sa' griego. Eb a'an inc'a' que'raj rabinquil. Que'raj ban xcamsinquil. ");
INSERT INTO kekNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nak eb laj pa̱banel que'rabi resil nak te'raj xcamsinquil, que'xc'am laj Saulo aran Cesarea ut aran chic que'xtakla Tarso. ");
INSERT INTO kekNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ut inc'a' chic que'rahobtesi̱c laj pa̱banel li cuanqueb Judea, Galilea, ut Samaria. Yo̱queb chi q'ui̱c sa' xpa̱ba̱leb. Neque'xxucua ru li Ka̱cua'. Ut li Santil Musik'ej yo̱ chixq'uebal xcacuilal xch'o̱leb. C'ajo' nak yo̱queb chi ta̱mc. ");
INSERT INTO kekNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ut laj Pedro, nak yo̱ chirula'aninquileb chixjunileb laj pa̱banel yalak bar, quicuulac ajcui' riq'uineb laj pa̱banel li cuanqueb Lida. ");
INSERT INTO kekNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Aran quixtau jun li cui̱nk aj Eneas xc'aba'. Cuakxakib chihab roquic lix yajel ut inc'a' chic nacuacli. Sic li rok ruk'. ");
INSERT INTO kekNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ut laj Pedro quixye re: —At Eneas, li Ka̱cua' Jesucristo tatxq'uirtesi anakcuan. Xaklin ut xoc la̱ cuarib, chan. Ut sa' junpa̱t quixakli li cui̱nk. ");
INSERT INTO kekNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ut chixjunileb li cuanqueb Lida ut Sarón que'ril nak quiq'uira li cui̱nk ut que'xpa̱b li Ka̱cua'. ");
INSERT INTO kekNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ut quicuan aran Jope jun li ixk aj pa̱banel xTabita xc'aba'. Chi jalbil ru naraj naxye Dorcas. Junelic yo̱ chixba̱nunquil usilal reheb li ras ri̱tz'in ut naxtenk'aheb li neba'. ");
INSERT INTO kekNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Sa' eb li cutan a'an quiyajer ut quicam. Que'ratesi ut que'xjilib sa' jun li na'ajej li cuan sa xca' tasal li cab. ");
INSERT INTO kekNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Li tenamit Jope nach' cuan riq'uin li tenamit Lida bar cuan cui' laj Pedro. Eb laj pa̱banel que'rabi nak cuan aran. Que'xtakla cuib li cui̱nk chixbokbal. —Cha̱lkat chi junpa̱t kiq'uin, chanqueb re laj Pedro. ");
INSERT INTO kekNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Laj Pedro co̱ rochbeneb. Nak quicuulac, que'xc'am sa' li na'ajej li cuan cui' li camenak. Aran quisute' xbaneb li xma̱lca'an. Yo̱queb chi ya̱bac ut que'xc'ut chiru li t'icr li quixyi̱b lix Dorcas nak toj cuan sa' xya̱nkeb. ");
INSERT INTO kekNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Laj Pedro quirisiheb chirix cab. Quixcuik'ib rib ut qui-oc chi tijoc. Ut quiril li camenak ut quixye re: —Tabita, cuaclin, chan. Ut li ixk quixte li xnak' ru, ut nak quiril ru laj Pedro, quic'ojla. ");
INSERT INTO kekNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Laj Pedro quixchap chi ruk' ut quixcuaclesi. Quixbokeb li xma̱lca'an jo' ajcui' chixjunileb laj pa̱banel ut quixxakab chiruheb chi yo'yo chic. ");
INSERT INTO kekNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Qui-el resil sa' chixjunil li tenamit Jope li c'a'ru quic'ulman. Xban a'an nabaleb que'pa̱ban re li Ka̱cua'. ");
INSERT INTO kekNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Laj Pedro najt quicuan aran Jope. Quihilan sa' rochoch jun li cui̱nk aj yi̱bom tz'u̱m, aj Simón xc'aba'. ");
INSERT INTO kekNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Quicuan jun li cui̱nk aran Cesarea aj Cornelio xc'aba'. A'an li nataklan sa' xbe̱neb jun ch'u̱tal chi soldado aj Italia neque'xye re. ");
INSERT INTO kekNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Li cui̱nk a'an quixxucua ru li Dios jo'queb ajcui' chixjunileb li cuanqueb sa' li rochoch. Cha̱bil xna'leb ut junelic natijoc chiru li Dios ut junelic naxtenk'aheb li neba'. ");
INSERT INTO kekNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Sa' jun li cutan sa' oxib o̱r tana re ecuu laj Cornelio quiril sa' visión nak qui-oc jun li ángel riq'uin ut quixye re: —At Cornelio, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Laj Cornelio ta̱xucuak nak quiril li ángel ut quixye: —C'a'ru ta̱cuaj tinba̱nu, Ka̱cua'.— Li ángel quixye: —Li Dios xrabi la̱ tij. Nacuulac chiru li c'a'ru nacaba̱nu re xtenk'anquileb li neba'. ");
INSERT INTO kekNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Anakcuan tinye a̱cue takla cuib oxibakeb li cui̱nk aran Jope chixc'ambal chak li cui̱nk aj Simón xc'aba'. Aj Pedro nayeman ajcui' re. ");
INSERT INTO kekNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","A'an ta̱yehok a̱cue c'a'ru us ta̱ba̱nu. A'an yo̱ chi hila̱nc sa' rochoch laj Simón laj yi̱bom tz'u̱m. Li rochoch cuan chire li palau, chan li ángel. ");
INSERT INTO kekNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nak ac x-el li ángel riq'uin, laj Cornelio quixbok cuib lix mo̱s cui̱nk ut quixbok ajcui' jun reheb lix soldado li naxxucua ru li Dios. ");
INSERT INTO kekNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Quixserak'i reheb chixjunileb li quiyehe' re xban li ángel ut quixtaklaheb Jope re nak te'xc'am chak laj Pedro. ");
INSERT INTO kekNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Cuulajak chic ac cuulaqueb na re sa' li tenamit Jope nak laj Pedro quitake' sa' xca' tasal li cab chi tijoc. Ca'ch'in na chic ma̱ cua'leb. ");
INSERT INTO kekNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Quichal xtz'ocajic ut quiraj raj ru cua'ac. Abanan toj yo̱queb chixyi̱banquil lix tzacae̱mk. Nak toj yo̱ chiroybeninquil lix tzacae̱mk, quiril jun li visión. ");
INSERT INTO kekNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Quiril nak teto li choxa ut chanchan jun nimla saki t'icr yo̱ chak chi cubec. Pixbil sa' xca̱ pac'alil lix xuc li t'icr ut yo̱ chak chi cubec sa' ruchich'och'. ");
INSERT INTO kekNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Chi sa' li t'icr a'an cuanqueb chak nabal pa̱y ru li xul xcomoneb li neque'cuan sa' ruchich'och'. Cuanqueb cuan cuib rokeb ut cuib ruk', cuanqueb xcomoneb li c'anti' ut cuanqueb xcomoneb li xul li neque'rupupic chiru choxa. ");
INSERT INTO kekNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ut quirabi jun xya̱b cux quixye re: —At Pedro, chap a̱cue li xul a'in. Ta̱camsi ut ta̱tiu, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Laj Pedro quixye: —Inc'a', Ka̱cua'. Ma̱ jun sut xintzaca c'a'ak re ru li naxye sa' li chak'rab nak inc'a' us xtzacanquil, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ut quixye cui'chic li yo̱ chi a̱tinac: —La̱at inc'a' naru nacac'oxla nak inc'a' us ta̱tzaca li c'a'ru xye li Dios nak us ta̱tzaca, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Oxib sut quiyehe' re chi jo'can ut chirix a'an quixoque li nimla t'icr a'an ut quic'ame' cui'chic sa' choxa. ");
INSERT INTO kekNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Laj Pedro toj yo̱ ajcui' chixc'oxlanquil c'a'ru xya̱lal li quic'utbesi̱c chiru nak que'cuulac li cui̱nk li que'takla̱c xban laj Cornelio. Cuanqueb chire li cab ut yo̱queb chixpatz'bal bar cuan li rochoch laj Simón. ");
INSERT INTO kekNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Que'xpatz' ma aran cuan chi hila̱nc laj Simón li neque'xye aj Pedro re. ");
INSERT INTO kekNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Laj Pedro toj yo̱ ajcui' chixc'oxlanquil c'a'ru xya̱lal li visión li quiril nak li Santil Musik'ej quixye re: —Oxib li cui̱nk xe'chal cha̱sic'bal. ");
INSERT INTO kekNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ayu, cuben ut a̱tinaheb chak. Matc'oxlac chi xic chirixeb xban nak la̱in xintaklan chak reheb, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Jo'can nak laj Pedro quicube ut quixye reheb li cui̱nk: —Cue'quin. La̱in laj Simón Pedro li niquine̱sic'. ¿C'a'ru xc'amoc chak e̱re toj arin ut c'a'ru te̱raj cuiq'uin? chan. ");
INSERT INTO kekNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Eb a'an que'xye: —Laj Cornelio li capitán xtaklan chak ke. A'an jun cui̱nk ti̱c xch'o̱l ut naxxucua ru li Dios. Chixjunileb laj judío neque'xq'ue sa' xnak' ruheb. Jun x-ángel li Dios quixc'utbesi rib chiru ut quixye re nak tatxbok sa' rochoch re nak ta̱ru̱k ta̱rabi li c'a'ru ta̱ye re, chanqueb re. ");
INSERT INTO kekNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Laj Pedro quirocsiheb ut que'xnumsi li k'ojyi̱n sa' li cab a'an. Sa' li cutan jun chic laj Pedro co̱ chirixeb. Ut cuib oxib laj pa̱banel re Jope que'co̱eb chirix. ");
INSERT INTO kekNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Jo' cuulajak chic que'cuulac Cesarea ut laj Cornelio yo̱ chiroybeninquileb rochbeneb li rech'alal ut eb li tz'akal rami̱g li quixbok riq'uin. ");
INSERT INTO kekNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Nak laj Pedro quicuulac sa' li rochoch, laj Cornelio qui-el chixc'ulbal. Quixcuik'ib rib chiru re xlok'oninquil. ");
INSERT INTO kekNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Abanan laj Pedro quixye re: —Cuaclin. Mina̱lok'oni la̱in xban nak la̱in yal cui̱nkin jo' la̱at, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Yo̱ chi a̱tinac riq'uin laj Cornelio nak yo̱queb chi oc sa' li cab. Nak que'oc, que'xtau nabaleb ac ch'utch'u̱queb sa' li cab. ");
INSERT INTO kekNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Laj Pedro quixye reheb: —La̱ex nequenau nak lix chak'rabeb laj judío naxye nak inc'a' naru takajunaji kib riq'uineb li ma̱cua'eb aj judío chi moco ta̱ru̱k to-oc sa' rochocheb. Abanan xc'ut chicuu li Ka̱cua' Dios nak ma̱ jun li cristian tintz'ekta̱na chi moco tinye nak inc'a' us a̱tinac riq'uineb. ");
INSERT INTO kekNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Jo'can nak inc'a' xink'etk'eti cuib chi cha̱lc nak xine'xbok chak. Ye cue c'a'ut nak xatakla inbokbal, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Quichak'oc laj Cornelio ut quixye: —Ca̱hib cutan anakcuan jo'ca'in ajcui' ho̱nal nak yo̱quin chi ayunic ut chi tijoc sa' li cuochoch. Oxib o̱r re ecuu quixc'utbesi rib chicuu jun li cui̱nk nalemtz'un li rak'. ");
INSERT INTO kekNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Quixye cue, “At Cornelio, li Dios quirabi la̱ tij. Nacuulac chiru li c'a'ru nacaba̱nu re xtenk'anquileb li neba'. ");
INSERT INTO kekNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Takla xc'ambal laj Simón Pedro li cuan aran Jope. Yo̱ chi hila̱nc sa' li rochoch laj Simón laj yi̱bom tz'u̱m. Li rochoch a'an cuan chire li palau. Nak ta̱c'ulu̱nk laj Pedro, tixch'olob cha̱cuu li xya̱lal,” chan cue li ángel. ");
INSERT INTO kekNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Jo'can nak xintakla a̱c'ambal sa' junpa̱t. Ut la̱at xaba̱nu usilal ke. Xatc'ulun. Anakcuan ut chikajunilo cuanco arin chiru li Dios chirabinquil chixjunil li c'a'ru ta̱ye ke li xye chak a̱cue li Dios, chan laj Cornelio re laj Pedro. ");
INSERT INTO kekNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Quixtiquib a̱tinac laj Pedro ut quixye: —Anakcuan xinq'ue retal chi tz'akal nak li Dios inc'a' naxsic' ru li ani naxra. ");
INSERT INTO kekNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Li ani naxxucua ru li Dios ut naxba̱nu li ti̱quilal a' yal bar xtenamit, li jun a'an narahe' xban li Dios. ");
INSERT INTO kekNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","La̱ex nequenau nak li Dios quixtakla resil li colba-ib reheb laj Israel. Li colba-ib, a'an li naq'uehoc tuktu̱quil usilal sa' xc'aba' li Jesucristo. Ut li Jesucristo, a'an li Ka̱cua', ut nim xcuanquil sa' xbe̱n chixjunil. ");
INSERT INTO kekNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","La̱ex nequenau c'a'ru quic'ulman sa' chixjunil li tenamit Judea. Quiticla aran Galilea nak ac xch'oloba̱c resil li cubi ha' xban laj Juan. ");
INSERT INTO kekNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ac e̱rabiom resil li Jesucristo aj Nazaret. Li Dios quixq'ue li Santil Musik'ej re, ut quixq'ue xcuanquil. A'an quibe̱c yalak bar chixba̱nunquil li usilal ut chixq'uirtesinquileb li tacuasinbileb xban laj tza xban nak li Dios cuan riq'uin. ");
INSERT INTO kekNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","La̱o quikil riq'uin ku chixjunil li c'a'ru quixba̱nu li Jesús aran Judea ut Jerusalén. Abanan eb a'an que'xcamsi chiru cruz. ");
INSERT INTO kekNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ut li Dios quixcuaclesi cui'chic chi yo'yo sa' xya̱nkeb li camenak sa' rox li cutan. Ut mokon li Jesús quixc'utbesi rib chiku. ");
INSERT INTO kekNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Inc'a' quixc'utbesi rib chiruheb chixjunileb. Ca'aj cui' chiruheb li quisiq'ue' ruheb junxil xban li Dios. La̱o cocua'ac ut co-uc'ac riq'uin nak ac xcuacli cui'chic chi yo'yo sa' xya̱nkeb li camenak. ");
INSERT INTO kekNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ut coxtakla chixch'olobanquil xya̱lal ut chixjulticanquil chiruheb li tenamit nak a'an q'uebil xban li Dios chi rakoc a̱tin sa' xbe̱neb chixjunileb, li yo'yo̱queb jo' ajcui' li camenakeb. ");
INSERT INTO kekNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","A'an a'in li Jesús li que'xye chak resil chixjunileb li profeta junxil. Que'xye nak sa' xc'aba' a'an ta̱cuyek' xma̱queb chixjunileb li neque'pa̱ban re. ");
INSERT INTO kekNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Toj yo̱ ajcui' chi a̱tinac laj Pedro nak que'xc'ul li Santil Musik'ej chixjunileb li yo̱queb chi abi̱nc re li ra̱tin li Dios li yo̱ chixyebal. ");
INSERT INTO kekNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Eb laj pa̱banel aj judío, li que'chal chirix laj Pedro, que'sach xch'o̱l chirilbal nak li Dios quixq'ue li Santil Musik'ej reheb li ma̱cua'eb aj judío. Gentiles nayeman ajcui' reheb. ");
INSERT INTO kekNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Que'rabi nak yo̱queb chi a̱tinac sa' jalan a̱tinoba̱l ut yo̱queb chixnimanquil ru li Dios. ");
INSERT INTO kekNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ut laj Pedro quixye: —¿Ma cuan ta bi' junak inc'a' ta̱ajok nak te'cubek' xha'eb a'in li xe'c'uluc re li Santil Musik'ej, jo' nak xkac'ul la̱o? chan. ");
INSERT INTO kekNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ut quixtakla xcubsinquil xha'eb sa' xc'aba' li Ka̱cua' Jesucristo. Ut eb a'an que'xtz'a̱ma chiru laj Pedro nak ta̱cana̱k cuib oxibak cutan chic riq'uineb. ");
INSERT INTO kekNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ut que'rabi resil eb li apóstol ut eb laj pa̱banel li cuanqueb Judea nak eb li ma̱cua'eb aj judío yo̱queb ajcui' chixpa̱banquil li ra̱tin li Dios. ");
INSERT INTO kekNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Nak co̱ Jerusalén laj Pedro, quicuech'i̱c xbaneb laj pa̱banel aj judío li neque'ba̱nun re li circuncisión. ");
INSERT INTO kekNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Que'xye re: —¿C'a'ut nak xacuula'aniheb li ma̱cua'eb aj judío? Ut, ¿c'a'ut nak xatcua'ac rochbeneb? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Tojo'nak laj Pedro qui-oc chixyebal reheb chixjunil li c'a'ru quic'ulman ut quixye reheb: ");
INSERT INTO kekNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Yo̱quin chi tijoc aran Jope nak quicuil jun li visión. Sa' li visión quicuil nak yo̱ chak chi cubec jun nimla t'icr sa' choxa. Pixbil sa' xca̱ pac'alil lix xuc li t'icr. Quichal bar cuanquin cui'. ");
INSERT INTO kekNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Quicuil chi sa' li t'icr ut aran cuanqueb nabal pa̱y ru li xul xcomoneb li neque'cuan sa' ruchich'och'. Cuanqueb li josk' aj xul, cuanqueb xcomoneb li c'anti' ut cuanqueb xcomoneb li xul li neque'rupupic chiru choxa. ");
INSERT INTO kekNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ut quicuabi jun xya̱b cux quixye cue, “At Pedro, chap a̱cue li xul a'in. Ta̱camsi ut ta̱tiu,” chan. ");
INSERT INTO kekNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ut la̱in quinye re, “Inc'a' Ka̱cua'. Ma̱ jun sut xintzaca c'a'ak re ru li naxye sa' li chak'rab nak inc'a' us tintzaca,” chanquin. ");
INSERT INTO kekNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ut quixye cui'chic cue li yo̱ chak chi a̱tinac sa' choxa, “La̱at inc'a' naru nacac'oxla nak inc'a' us ta̱tzaca li c'a'ru xye li Dios nak us ta̱tzaca,” chan. ");
INSERT INTO kekNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Oxib sut quiyehe' cue chi jo'can ut chirix a'an quic'ame' cui'chic sa' choxa li nimla t'icr a'an. ");
INSERT INTO kekNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ut sa' ajcui' li ho̱nal a'an que'cuulac sa' li cab cuanquin cui' oxib li cui̱nk que'chal chak toj Cesarea chinsic'bal. ");
INSERT INTO kekNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ut li Santil Musik'ej quixye cue nak tinxic chirixeb chi ma̱c'a' inc'a'ux. Ut que'co̱eb ajcui' chicuix cuakib li herma̱n. Ut co-oc sa' rochoch jun li cui̱nk. ");
INSERT INTO kekNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Li cui̱nk a'an quixserak'i ke chanru nak quixc'utbesi rib jun li ángel chiru sa' li rochoch. Li ángel quixye re, “Takla xbokbal aran Jope laj Simón li nayehe' ajcui' aj Pedro re. ");
INSERT INTO kekNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","A'an ta̱yehok a̱cue chanru ta̱ru̱k tatcolek' jo'queb ajcui' li cuanqueb sa' la̱ cuochoch, chan cue li ángel,” chan li cui̱nk. ");
INSERT INTO kekNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ut nak quin-oc chi a̱tinac riq'uineb, li Santil Musik'ej quichal sa' xbe̱neb jo' nak quichal sa' kabe̱n la̱o junxil. ");
INSERT INTO kekNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ut quinak sa' inch'o̱l li c'a'ru quixye li Ka̱cua', “Laj Juan relic chi ya̱l quicubsin ha' riq'uin ha', abanan la̱ex te̱c'ul li Santil Musik'ej.” ");
INSERT INTO kekNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Jo'can ut nak cui li Dios quixq'ue li Santil Musik'ej reheb a'an jo' nak quixq'ue ke la̱o li xopa̱ban re li Jesucristo, ¿anihin ta bi' la̱in nak tinram chiru li Dios li c'a'ru ta̱raj xba̱nunquil? chan laj Pedro. ");
INSERT INTO kekNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nak que'rabi li c'a'ru quixye laj Pedro, eb laj c'amol be sa' xya̱nkeb laj pa̱banel aj judío, que'xcanab cuech'i̱nc. Que'xlok'oni li Dios ut que'xye: —Li Ka̱cua' xq'ue ajcui' li junelic yu'am reheb li ma̱cua'eb aj judío xban nak xe'xyot' xch'o̱l ut xe'xjal xc'a'ux, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Chirix lix camic laj Esteban, que'xjeq'ui ribeb laj pa̱banel xban li raylal li yo̱queb chixc'ulbal. Que'cuulac toj Fenicia, Chipre ut Antioquía. Aran que'xch'olob resil li evangelio chiruheb laj judío. Inc'a' que'xye reheb li ma̱cua'eb aj judío. ");
INSERT INTO kekNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Abanan cuanqueb aj pa̱banel aj Chipre ut aj Cirene que'cuulac Antioquía. Eb a'an que'xch'olob xya̱lal chiruheb li neque'a̱tinac sa' griego ut que'xye resil li colba-ib sa' xc'aba' li Jesucristo. ");
INSERT INTO kekNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Li Ka̱cua' Jesús quixtenk'aheb riq'uin xnimal xcuanquil ut nabaleb que'xpa̱b li Ka̱cua' Jesús. ");
INSERT INTO kekNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Nak que'rabi resil eb laj pa̱banel li cuanqueb Jerusalén, que'xtakla laj Bernabé aran Antioquía. ");
INSERT INTO kekNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nak quicuulac laj Bernabé quixq'ue retal nak li Dios yo̱ chirosobtesinquileb laj pa̱banel li cuanqueb aran. Quixq'ue xcacuilal xch'o̱leb ut quixye ajcui' reheb nak che'xq'uehak xch'o̱leb chixpa̱banquil li Ka̱cua'. ");
INSERT INTO kekNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Laj Bernabé, a'an jun cui̱nk cha̱bil ut cuan xpa̱ba̱l. Nujenak chi Santil Musik'ej. Ut chiru a'an nabaleb que'xpa̱b li Ka̱cua'. ");
INSERT INTO kekNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Chirix chic a'an laj Bernabé co̱ Tarso chixsic'bal laj Saulo. Nak quixtau quixc'am Antioquía. ");
INSERT INTO kekNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ut que'cuan aran jun chihab tz'akal riq'uineb ut que'xc'ut li xya̱lal chiruheb nabal. Ut aran Antioquía que'xtiquib xyebal “cristiano” reheb laj pa̱banel. ");
INSERT INTO kekNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Sa' eb li cutan a'an cuanqueb profeta que'el Jerusalén ut que'co̱eb Antioquía. ");
INSERT INTO kekNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Cuan jun sa' xya̱nkeb a'an aj Agabo xc'aba'. Quixye nak ta̱cua̱nk jun nimla cue'ej sa' chixjunil li ruchich'och' xban nak jo'can quic'ute' chiru xban li Santil Musik'ej. Ut li cue'ej a'in quic'ulman sa' eb li cutan nak cua̱nk laj Claudio chok' acuabej. ");
INSERT INTO kekNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ut eb laj pa̱banel li cuanqueb Antioquía que'xc'u̱b ru nak te'xtenk'aheb laj pa̱banel li cuanqueb Judea. Que'xtenk'a a' yal chanru quixq'ue rib chiru li junju̱nk. ");
INSERT INTO kekNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ut jo'can que'xba̱nu. Que'xtakla lix tenk'al chirixeb laj Bernabé ut laj Saulo re nak te'xk'axtesi sa' ruk'eb li neque'c'amoc be sa' xya̱nkeb laj pa̱banel li cuanqueb Judea. ");
INSERT INTO kekNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Sa' eb li cutan a'an laj Herodes quixtiquib xrahobtesinquileb laj pa̱banel. ");
INSERT INTO kekNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Quixtakla xcamsinquil riq'uin ch'i̱ch' laj Jacobo li ras laj Juan. ");
INSERT INTO kekNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Laj Herodes quixq'ue retal nak eb laj judío que'saho' xch'o̱l riq'uin li c'a'ru quixba̱nu. Jo'can nak quixtakla ajcui' xchapbal laj Pedro. Quixba̱nu a'in sa' li nink'e nak neque'xcua' li caxlan cua ma̱c'a' xch'amal. ");
INSERT INTO kekNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Nak ac xchape' laj Pedro, li rey Herodes quixtakla sa' tz'alam ut quixk'axtesi sa' ruk'eb ca̱hib ch'u̱tal chi soldado re te'xc'ac'ale. Ca̱hib chi soldado cuan sa' li junju̱nk ch'u̱tal. Laj Herodes cuan sa' xch'o̱l nak tixc'am chiruheb li tenamit nak ac xrake' li nink'e re te'xrak a̱tin sa' xbe̱n. ");
INSERT INTO kekNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Jo'can nak laj Pedro ilbil chi us xbaneb li soldado re nak inc'a' ta̱e̱lelik. Abanan eb laj pa̱banel cau yo̱queb chi tijoc chirix. ");
INSERT INTO kekNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ac cuulac re xk'ehil nak ta̱c'amek' laj Pedro xban laj Herodes chiruheb li tenamit. Sa' li k'ojyi̱n a'an laj Pedro yo̱ chi cua̱rc sa' xyiheb li cuib chi soldado bac'bo riq'uin cadena. Ut cuanqueb ajcui' laj c'ac'alenel chire li oqueba̱l re li tz'alam. ");
INSERT INTO kekNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ut xaka̱mil jun x-ángel li Dios bar cuan cui' laj Pedro ut quixcutanobresi sa' li tz'alam. Li ángel quixt'otz'otz'i laj Pedro ut quirajsi. Quixye re: —Cuaclin. Se̱ba a̱cuib, chan. Ut sa' junpa̱t quit'ane' li cadena chi ruk'. ");
INSERT INTO kekNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ut li ángel quixye re: —Q'ue la̱ cuak' cha̱cuix ut q'ue la̱ xa̱b cha̱cuok, chan re. Ut laj Pedro quixba̱nu jo' quiyehe' re. Ut li ángel quixye cui'chic re: —Tz'ap a̱cuib sa' la̱ t'icr ut yo'o chicuix, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Laj Pedro co̱ chirix li ángel. Abanan inc'a' naxnau nak tz'akal ya̱l li yo̱ chixba̱nunquil li ángel. Sa' xch'o̱l laj Pedro nak visión li yo̱ chirilbal. ");
INSERT INTO kekNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Que'cuulac cuan cui' li jun ch'u̱tal chi soldado ut que'nume' aran. Ut que'cuulac cui'chic cuanqueb cui' li jun ch'u̱tal chic. Ut que'nume' aran toj que'cuulac cuan cui' li puerta ch'i̱ch' li na-ux cui' oc sa' li tenamit. Ut li puerta a'an quixte rib xjunes chiruheb. Que'el ut que'xk'ax jun li nim be. Aran quicanaba̱c xjunes laj Pedro xban li ángel. ");
INSERT INTO kekNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Laj Pedro quixq'ue retal li c'a'ru quixc'ul ut quixye sa' xch'o̱l: —Anakcuan ninnau chi tz'akal nak li Ka̱cua', a'an li xtaklan chak re li ángel. Xinixcol sa' ruk' laj Herodes. Ut xinixcol ajcui' sa' ruk'eb chixjunileb laj judío li te'raj xba̱nunquil raylal cue, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nak quixtau ru li c'a'ru quixc'ul, laj Pedro co̱ sa' rochoch lix María lix na' laj Juan li nayeman Marcos re. Aran ch'utch'u̱queb nabaleb laj pa̱banel yo̱queb chi tijoc. ");
INSERT INTO kekNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Quixt'och't'och'i li puerta li cuan chiru neba̱l. Ut co̱ jun li xka'al xRode xc'aba' chirabinquil ani cuan aran. ");
INSERT INTO kekNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Quixnau ru xya̱b xcux laj Pedro. Inc'a' quixte li puerta chiru. Xban xsahil xch'o̱l, co̱ sa' a̱nil chixyebal resil reheb li cuanqueb sa' cab nak laj Pedro cuan chire puerta. ");
INSERT INTO kekNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Eb li cuanqueb sa' cab inc'a' que'xpa̱b li quixye. —Xlo̱co' a̱cuu, chanqueb re. Abanan lix Rode quixye cui'chic reheb nak ya̱l nak a'an laj Pedro. Que'chak'oc ut que'xye re: —A'an yal xmuhel, chanqueb re. ");
INSERT INTO kekNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Nak yo̱queb chi a̱tinac, laj Pedro toj yo̱ ajcui' chixtoch'bal li puerta. Nak que'xte li puerta que'ril laj Pedro. Sachso̱queb xch'o̱l que'cana. ");
INSERT INTO kekNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Quixtaksi li ruk' re nak te'xcanab choki̱nc, ut quixserak'i reheb chanru nak qui-isi̱c sa' tz'alam xban li Ka̱cua'. Quixye reheb: —Yehomak resil a'in re laj Jacobo ut reheb chixjunileb laj pa̱banel, chan. Ut chirix a'an co̱ sa' jalan na'ajej. ");
INSERT INTO kekNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Nak quisake̱u que'xq'ue retal nak ma̱ ani chic laj Pedro sa' tz'alam. C'ajo' nak que'sach xch'o̱leb li soldado chirilbal li c'a'ru quic'ulman. Yo̱queb chixyebal chi ribileb rib: —¿C'a'ru xc'ul laj Pedro? ¿Bar xco̱? chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ut laj Herodes quixtakla xsiq'uinquil. Nak inc'a' que'xtau quixq'ue sa' xbe̱neb laj c'ac'alenel ut quixtakla xcamsinquileb. Chirix a'an laj Herodes qui-el Judea ut co̱ chi cua̱nc aran Cesarea. ");
INSERT INTO kekNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Laj Herodes yo̱ xjosk'il sa' xbe̱neb laj Tiro ut laj Sidón. Eb a'an que'chal sa' comonil. Ut que'xk'unbesi laj Blasto li natenk'an re li rey. Que'xtz'a̱ma chiru nak a'an ta̱a̱tinak chirixeb chiru li rey re nak ta̱ru̱k te'xc'am rib sa' usilal riq'uin xban nak sa' xtenamit li rey na-el xtzacae̱mkeb. ");
INSERT INTO kekNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Laj Herodes quixxakab jun li cutan re nak ta̱a̱tinak riq'uineb laj Tiro ut laj Sidón. Quixtikib rib riq'uin cha̱bil ak' c'ajo' xchak'al ru li neque'rocsi li rey. Quic'ojla sa' lix na'aj bar narakoc cui' a̱tin ut qui-oc chi a̱tinac riq'uineb li tenamit. ");
INSERT INTO kekNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ut eb li tenamit que'oc chixyebal chi cau xya̱b xcux: —Li yo̱ chi a̱tinac ma̱cua' cui̱nk. A'an Dios, chanqueb. ");
INSERT INTO kekNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ut sa' ajcui' li ho̱nal a'an, jun x-ángel li Ka̱cua' quixq'ue jun yajel sa' xbe̱n laj Herodes xban nak quixq'ue rib chixlok'oniheb li tenamit ut inc'a' quixq'ue xlok'al li Dios. Quimotzo'in ut a'an quicamsin re. ");
INSERT INTO kekNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Sa' eb li cutan a'an li ra̱tin li Ka̱cua' yo̱ chi abi̱c yalak bar. Ut nabaleb yo̱queb chi pa̱ba̱nc re. ");
INSERT INTO kekNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Que'suk'i chak Jerusalén laj Bernabé ut laj Saulo nak ac que'xba̱nu lix c'anjeleb. Que'xc'am chirixeb laj Juan, li neque'xye ajcui' Marcos re. ");
INSERT INTO kekNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Sa' xya̱nkeb laj pa̱banel aran Antioquía cuanqueb profeta ut cuanqueb aj tzolonel. A'aneb a'in: laj Bernabé, laj Simón li neque'xye Niger re, laj Lucio Cirene xtenamit, laj Manaén li quiq'uiresi̱c riq'uin laj Herodes li acuabej, ut laj Saulo. ");
INSERT INTO kekNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Nak yo̱queb chi tijoc chiru li Dios ut chi ayunic, li Santil Musik'ej quixye reheb: —Q'uehomakeb xjuneseb laj Saulo ut laj Bernabé re nak te'xba̱nu li c'anjel a'in li sic'bileb cui' ru inban, chan. ");
INSERT INTO kekNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Que'xba̱nu lix ayu̱n ut que'tijoc nak que'xq'ue li ruk'eb sa' xbe̱neb laj Saulo ut laj Bernabé. Tojo'nak que'xchak'rabiheb. ");
INSERT INTO kekNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Laj Saulo ut laj Bernabé que'co̱eb Seleucia jo' quiyehe' reheb xban li Santil Musik'ej. Que'el aran ut que'co̱eb chiru ha' toj Chipre. ");
INSERT INTO kekNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ut nak que'cuulac Salamina, que'xch'olob xya̱lal li ra̱tin li Dios sa' eb li cab li neque'xch'utub cui' ribeb laj judío. Ut laj Juan Marcos yo̱ ajcui' chixtenk'anquileb. ");
INSERT INTO kekNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Yo̱queb chixbeninquil chixjunil li na'ajej li sutsu sa' ha'. Que'cuulac sa' li tenamit Pafos. Aran que'xtau jun aj tu̱l aj judío. Barjesús lix c'aba'. Li cui̱nk a'an aj balak'. Naxye nak sa' xc'aba' li Dios naa̱tinac. Abanan moco ya̱l ta. ");
INSERT INTO kekNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Li cui̱nk a'an cuan riq'uin laj Sergio Paulo, li q'uebil xcuanquil chi takla̱nc sa' li na'ajej a'an. Laj Sergio Paulo, li cuan xna'leb, quixtakla xbokbaleb laj Saulo ut laj Bernabé xban nak quiraj rabinquil li ra̱tin li Dios. ");
INSERT INTO kekNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8