﻿USE sofia;
DROP TABLE IF EXISTS sofia.kdl_vpl;
CREATE TABLE kdl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kdl_vpl WRITE;
INSERT INTO kdl_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Magono ma Zuba ma isa̱i Musa a asuvu u Katani ka Ugawunsa, u danai, ");
INSERT INTO kdl_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","<<Tonuko aza a Isaraꞌila kadyanshi ka na: Aꞌayin a ɗa baci uza roku a asuvu a ɗe wa yanka Magono ma Zuba kune, u tuko a asuvu a ushiga u anaka ko u nlala. ");
INSERT INTO kdl_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","<<Kune ku vuma ki uɗara̱kpa u urunukpa u ɗa baci a asuvu a ushiga u anaka, u tuko kagono ka ka lyopoi wa. U ka̱na̱ ta̱ u tuko ka a utsutsu u Katani ka Ugawunsa, tsa̱ra̱ uɗara̱kpa vi u woko ili i uwusha a asu u Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","U ka̱na̱ ta̱ uza ɗa u tukoi uɗara̱kpa vi u taɗangu kukere ku ne a kaci ka manama mi tsa̱ra̱ ma woko ili i uwusha i utakpa u unyushi u cingi u ne. ");
INSERT INTO kdl_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Vuma vi u kiɗa kagono ka madyondyom ki a kapala ka Magono ma Zuba, aku alobo a Haruna aza ɗa aꞌa̱ri aɗara̱kpi a tuko mpasa mi, aku a vishana̱sa n ɗa gba̱ a apashi a nishi a asuɗara̱kpa u ɗa wa̱ri a utsutsu u Katani ka Ugawunsa ki. ");
INSERT INTO kdl_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Vuma vi u minyi manama ma uɗara̱kpa u urunukpa vi, aku u kiɗa̱sa ma agbidi-agbidi. ");
INSERT INTO kdl_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Alobo a Haruna kaɗara̱kpi a ɗa a dari nɗanga a asuɗara̱kpa vi aku a tasuku akina. ");
INSERT INTO kdl_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Alobo yi a dari agbidi a inyama yi kaɓolo n kaci n manivi ma ne a zuba u nɗanga n ɗa ma tasa a asuɗara̱kpa vi. ");
INSERT INTO kdl_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Vuma vi u za̱i ucanga u katsuma̱ n akpete, aku kaɗara̱kpi ki ka runukpa iꞌya gba̱ a asuɗara̱kpa. U tuko uɗara̱kpa u urunukpa, kune ku ilikulya ku magula̱ni ma shinga ka a yain n akina ubana a asu u Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","<<Kune ku vuma ki uɗara̱kpa u urunukpa u ɗa baci asuvu ushiga u aꞌondom ko tani u nryaɗiga, u ka̱na̱ ta̱ u tuko kagono ka ka lyopoi wa. ");
INSERT INTO kdl_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","U kiɗa ma a upashi u gaɗi u asuɗara̱kpa a kapala ka Magono ma Zuba, kpam alobo a Haruna kaɗara̱kpi a vishana̱sa mpasa mi a apashi a nishi a asuɗara̱kpa vi gba̱. ");
INSERT INTO kdl_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","U kiɗa̱sa iꞌya agbidi-agbidi kaɓolo n kaci n manivi, aku kaɗara̱kpi ka dari iꞌya a zuba u nɗanga n ɗa ma̱ri n akina a asuɗara̱kpa vi. ");
INSERT INTO kdl_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","U za̱i ucanga u katsuma̱ vi n akpete yi dem, pini nala, kaɗara̱kpi ka tuko u ɗa aku u runukpa u ɗa a zuba u asuɗara̱kpa vi. Wa woko ta̱ uɗara̱kpa u urunukpa, kune ku ilikulya ku magula̱ni ma shinga ka a yain n akina ubana a asu u Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","<<Kune ku vuma ki ubana a asu u Magono ma Zuba uɗara̱kpa u urunukpa u nnu u ɗa baci, she u tuko aꞌaɗya ko tani ntambara. ");
INSERT INTO kdl_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Kaɗara̱kpi ka tuko manu mi a asuɗara̱kpa, u piyanla udyoku vi u takpa u ɗa aku u runukpa u ɗa a zuba u asuɗara̱kpa vi. U ka̱na̱ ma tyoku ɗa mpasa ma ɗoro a kapashi ka asuɗara̱kpa vi. ");
INSERT INTO kdl_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","U takpa katsa̱ntsa̱n ka udyoku u manu n ilya iꞌya iꞌa̱ri pini asuvu, aku u vuta̱la̱ a upashi u kasana u asuɗara̱kpa a asu u ɗa a tsu tsungusu kakomo. ");
INSERT INTO kdl_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Aku u ɓa̱na̱ ashan a ne u ka̱ri ma, shegai wa pece ma wa. Kaɗara̱kpi ki ka runukpa ma a asuɗara̱kpa a zuba u nɗanga n ɗa ma̱ri a akina a asuɗara̱kpa vi. Wa woko ta̱ uɗara̱kpa u urunukpa, kune ku ilikulya ku magula̱ni ma shinga ka a yain n akina ubana a asu u Magono ma Zuba.>> ");
INSERT INTO kdl_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Magono ma Zuba ma lyai kapala n kadyanshi, <<Aꞌayin a ɗa baci vuma wa tuko kune ku uɗara̱kpa u ilya a kapala ka Magono ma Zuba, uɗara̱kpa vi u woko u kira ku lewu kpam u tsungu manivi n ili i magula̱ni i urunukpa pini a zuba. ");
INSERT INTO kdl_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","U tuko u ɗa asu u alobo a Haruna aza ɗa aꞌa̱ri aɗara̱kpi. Kaɗara̱kpi ka ka yan manyan pini vi ka kene kira ku lewu a kukere ku ne tipi ka vuma vi u tukoi vi, n manivi n ili i magula̱ni yi gba̱. Kaɗara̱kpi ki ka runukpa iꞌya ka woko kunzu ku uciɓusa n asuɗara̱kpa vi. Wa woko ta̱ kune ku ilikulya ku magula̱ni ma shinga ka a yain n akina ubana a asu u Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ili iꞌya ya buwa a asuvu a uɗara̱kpa u ilya vi, i Haruna n alobo a ne iꞌya. Ili i uwulukpi iꞌya cika i kune ku ilikulya ku magula̱ni ma shinga ka a yain n akina ubana a asu u Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","<<Ili iꞌya a zungi a kalele iꞌya baci vuma vi u tukoi kune ku uɗara̱kpa u ilya, she a yain iꞌya n kira ku lewu. A yain burodi u apeteli u ɗa u nambai yisti u ɗa a juɗugi n manivi ko amasa a katali a ɗa a nambai yisti a ɗa a gbara̱kai manivi. ");
INSERT INTO kdl_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Uɗara̱kpa u ilya u vunu a zungu baci u ɗa a mabaluwa ma udatsunku, she a yain u ɗa n kira ku lewu ka ka nambai yisti ka vu juɗugi n manivi. ");
INSERT INTO kdl_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Vu jibusa̱ u ɗa kenu-kenu, vu doku vu tsunku u ɗa manivi; uɗara̱kpa u ilya u ɗa. ");
INSERT INTO kdl_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Uɗara̱kpa u ilya u vunu a kangala baci u ɗa a mabaluwa, she a yain u ɗa n kira ku lewu n manivi. ");
INSERT INTO kdl_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Vu tuko Magono ma Zuba uɗara̱kpa u ilya u ɗa a yain n ili i na yi. Vu na̱ka̱ u ɗa kaɗara̱kpi, eyi kpam u banka u ɗa a asuɗara̱kpa. ");
INSERT INTO kdl_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","U ɗanga̱sa kunzu ku uciɓusa ku kune ku uɗara̱kpa u ilya, aku u runukpa u ɗa a zuba u asuɗara̱kpa, kune ku ilikulya ku magula̱ni ma shinga ka a yain n akina ubana a asu u Magono ma Zuba ka la vi. ");
INSERT INTO kdl_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ili iꞌya ya buwa a asuvu a uɗara̱kpa u ilya vi, i Haruna n alobo a ne iꞌya. Ili i uwulukpi iꞌya cika i kune ku ilikulya ka a yain n akina ubana a asu u Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","<<Uɗara̱kpa u ilya wa̱ la u ɗa ya na̱ka̱ Magono ma Zuba u ɗa a ka tsungu yisti wa, kpaci a ka runukpa yisti ko ishigi a kune ku ilikulya ubana a asu u Magono ma Zuba wa. ");
INSERT INTO kdl_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Ya fuɗa ta̱ i tuko u ɗa kune a ilimaci i kagita̱ ubana a asu u Magono ma Zuba, shegai a ka yan uɗara̱kpa n u ɗa a asuɗara̱kpa u woko kune ku magula̱ni ma shinga wa. ");
INSERT INTO kdl_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","I tsungu mkpaɗi a kune ku uɗara̱kpa u ilya u ɗa baci dem ya yan. Kotsu i kpa̱ɗa̱ utsungu mkpaɗi a uɗara̱kpa u ilya u ɗe wa, kpaci mkpaɗi ma ciɓuga ɗa̱ ta̱ kazuwamgbani ka ɗe n Kashila̱. U ka̱na̱ ta̱ i na̱ka̱ kune ku uɗara̱kpa u ilya u ɗe gba̱ na̱ mkpaɗi. ");
INSERT INTO kdl_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","<<Ya tuko baci uɗara̱kpa u ilya u ilimaci i kagita̱ asu u Magono ma Zuba, she i na̱ka̱ uɗara̱kpa u ilya i savu iꞌya a datsuki kpam a kparai. ");
INSERT INTO kdl_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","I tsunku u ɗa manivi i tsungu ili i magula̱ni; uɗara̱kpa u ilya u ɗa. ");
INSERT INTO kdl_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Aku kaɗara̱kpi ka runukpa kunzu ka uciɓusa u kira ka ilya iꞌya a wiryai vi n manivi, n ili i magula̱ni i urunukpa yi gba̱; kune ku ilikulya ubana a asu u Magono ma Zuba ka la vi.>> ");
INSERT INTO kdl_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Magono ma Zuba ma lyai kapala n kadyanshi, <<Aꞌayin a ɗa baci vuma wa tuko kune ku uɗara̱kpa u ndishi n shinga a asuvu a ushiga u anaka u ne, u tuko Magono ma Zuba kagono ko tani kanuku ka ka lyopoi wa. ");
INSERT INTO kdl_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","U ka̱na̱ ta̱ u taɗangu kukere ku ne a kaci ka manama ma uɗara̱kpa mi, u kiɗa ma a utsutsu u Katani ka Ugawunsa. Aku alobo a Haruna aɗara̱kpi a vishana̱sa mpasa mi a apashi a asuɗara̱kpa vi gba̱. ");
INSERT INTO kdl_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Asuvu uɗara̱kpa u ndishi n shinga vi, ili iꞌya wa yanka kune ku ilikulya ubana a asu u Magono ma Zuba iꞌya na: manivi ma ma palai ucanga u katsuma̱ n ma ma̱ri a zuba u ucanga u katsuma̱ vi gba̱. ");
INSERT INTO kdl_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","U takpa dem nluba n re n manivi ma ma paɗara le n kapashi ka ka lai tsulobo a asu u akaɗa, u ɗa a ka takpa kaɓolo na̱ nluba n re n nala mi. ");
INSERT INTO kdl_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Aku alobo a Haruna aɗara̱kpi a runukpa iꞌya a zuba u asuɗara̱kpa, kaɓolo n uɗara̱kpa u urunukpa u ɗa wa̱ri a nɗanga ma akina; kune ku ilikulya ku magula̱ni ma shinga ka a yain n akina ubana a asu u Magono ma Zuba ka la vi. ");
INSERT INTO kdl_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","<<U ka̱na̱ baci kune ku uɗara̱kpa u ndishi n shinga vi ubana a asu u Magono ma Zuba asuvu a ushiga u nlala u ɗa baci, she u tuko kagono ko tani kanuku ka ka lyopoi wa. ");
INSERT INTO kdl_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Maku ma macon ma baci u tukoi adama a uɗara̱kpa vi, she u tuko ma a kapala ka Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","U ka̱na̱ ta u taɗangu kukere ku ne a kaci ka manama ma uɗara̱kpa mi, u kiɗa ma a utsutsu u Katani ka Ugawunsa. Aku alobo a Haruna a vishana̱sa mpasa mi a apashi a asuɗara̱kpa vi gba̱. ");
INSERT INTO kdl_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Asuvu uɗara̱kpa u ndishi n shinga, ili iꞌya i ka̱na̱i u tuko adama a kune ku ilikulya ubana a asu u Magono ma Zuba iꞌya na: uwunja vi gba̱ n manivi ma ne a kiɗa u ɗa a asu u ɗa a gawunsai n katele ka kucina̱ n manivi ma ma palai ucanga u katsuma̱ n ma ma̱ri a zuba u ucanga u katsuma̱ vi gba̱. ");
INSERT INTO kdl_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","Na̱ nluba n re n manivi ma ma paɗara le n kapashi ka ka lai tsulobo a asu u akaɗa, u ɗa a ka takpa kaɓolo na̱ nluba n re n nala mi. ");
INSERT INTO kdl_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Kaɗara̱kpi ki ka runukpa iꞌya a zuba u asuɗara̱kpa; kune ku ilikulya ubana a asu u Magono ma Zuba ka la vi. ");
INSERT INTO kdl_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","<<Vuma vi u tuko baci maryaɗiga adama a uɗara̱kpa, she u tuko ma a kapala ka Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","U ka̱na̱ ta u taɗangu kukere ku ne a kaci ka manama ma uɗara̱kpa mi, u kiɗa ma a utsutsu u Katani ka Ugawunsa. Aku alobo a Haruna a vishana̱sa mpasa mi a apashi a asuɗara̱kpa vi gba̱. ");
INSERT INTO kdl_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Asuvu uɗara̱kpa vi, ili iꞌya u ka̱na̱i u tuko adama kune ku ilikulya ubana a asu u Magono ma Zuba iꞌya na: manivi ma ma palai ucanga u katsuma̱ n ma ma̱ri a zuba ucanga u katsuma̱ vi gba̱. ");
INSERT INTO kdl_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","Na̱ nluba n re n manivi ma ma paɗara le n kapashi ka ka lai tsulobo a asu u akaɗa, u ɗa a ka takpa kaɓolo na̱ nluba n re n nala mi. ");
INSERT INTO kdl_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Kaɗara̱kpi ki ka runukpa iꞌya a zuba u asuɗara̱kpa; kune ku ilikulya ku magula̱ni ma shinga ka a yain n akina ubana a asu u Magono ma Zuba ka la vi. Gba̱ manivi mi ma Magono ma Zuba ma. ");
INSERT INTO kdl_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","U ka̱na̱ ta̱ ya lya manivi ma nnama ko mpasa wa. Mele ma na mi ma yan ta̱ pini a uyan u ɗe ushani ubana, a asu u ɗa baci dem ya dusuku.>> ");
INSERT INTO kdl_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Magono ma Zuba ma tonukoi Musa: ");
INSERT INTO kdl_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","<<Tonuko aza a Isaraꞌila ili iꞌya a ka yan iꞌya na aꞌayin a ɗa baci uza u yain unyushi u ɗa u revei n u ɗa wa, kpam u koɗoi mele ma te asuvu a mele ma Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Magono ma Aɗara̱kpi ma yan baci unyushi, hal unyushi vi u zuwai ama a wokoi aza a unyushi, she u tuko kagono ka kanaka ka ka lyopoi wa, ka woko uɗara̱kpa u uwulukpe ubana a asu u Magono ma Zuba adama a unyushi u ɗa u yain vi. ");
INSERT INTO kdl_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","U ka̱na̱ ta̱ u tuko kagono ka kanaka ki a utsutsu u Katani ka Ugawunsa a kapala ka Magono ma Zuba, u taɗangu kukere ku ne a kaci ka kanaka ki, u kiɗa ka a kapala ka Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","U kene mpasa n kanaka mi u uka n ɗa a Katani ki. ");
INSERT INTO kdl_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","U doɓongi majubu ma ne a asuvu a mpasa mi u vishana̱sa n ɗa kushindere a kapala ka Magono ma Zuba, a kapala ka kunya ku uba̱ra̱kpa̱ ka ka̱ri a asuvu a Asu u Uwulukpi. ");
INSERT INTO kdl_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Wa kene ta̱ kpam asuvu a mpasa mi u tsungu n ɗa a avana u asuɗara̱kpa u urunukpa u ili i magula̱ni u ɗa wa̱ri asuvu a Katani ka Ugawunsa a kapala ka Magono ma Zuba. Pini nala, mpasa n ɗa n buwai vi, u tsungu n ɗa a kami ka asuɗara̱kpa u uɗara̱kpa u urunukpa u ɗa wa̱ri a utsutsu u Katani ka Ugawunsa. ");
INSERT INTO kdl_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","U takpa gba̱ manivi ma kanaka ka a ka yanka uɗara̱kpa u uwulukpe vi, n manivi ma ma palai ucanga u katsuma̱ n ma ma̱ri a zuba u ucanga u katsuma̱ vi gba̱. ");
INSERT INTO kdl_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","U takpa dem nluba n re n manivi ma ma paɗara le n kapashi ka ka lai tsulobo a asu u akaɗa, u ɗa a ka takpa kaɓolo na̱ nluba n re n nala mi. ");
INSERT INTO kdl_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","U takpa iꞌya dere tyoku ɗa a tsu takpa u kanaka ka a tsu yanka uɗara̱kpa u ndishi n shinga, aku kaɗara̱kpi ka runukpa iꞌya a zuba u asuɗara̱kpa u uɗara̱kpa u urunukpa. ");
INSERT INTO kdl_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Shegai u bidya ukpan u kanaka vi n inyama yi gba̱ n kaci n akpete n ucanga u katsuma̱ n awuyen yi dem, ");
INSERT INTO kdl_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","wata, u bidya gba̱ apashi a ikyamba i kanaka a ɗa a buwai vi u wutukpa̱ a ɗa a uroto u agali a asu u ɗa a wulukpei u ɗa a tsu wotsongusu kakomo, nte wa runukpa a ɗa pini ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","<<Gba̱ kakuma̱ ka aza a Isaraꞌila a yan baci unyushi u ɗa ama ushani a revei n u ɗa wa, kpam a koɗoi mele ma te a asuvu a mele ma Magono ma Zuba, ko a reve baci n unyushi vi wa, nala u zuwa le ta̱ gba̱ a woko aza a unyushi. ");
INSERT INTO kdl_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","A tuwa̱ baci a revei n unyushi vi, gba̱ le she a tuko kagono ka kanaka ka a ka yan uɗara̱kpa u uwulukpe a utsutsu u Katani ka Ugawunsa. ");
INSERT INTO kdl_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Nkoshi n kakuma̱ ka ama n taɗangu akere a le a kanaka ki a kapala ka Magono ma Zuba, aku uza u te u le u kiɗa ka a kapala ka Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Magono ma Aɗara̱kpi ma kene mpasa n kanaka mi u uka a asuvu a Katani ka Ugawunsa. ");
INSERT INTO kdl_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","U ɗoɓongu majubu ma ne asuvu mpasa mi u vishana̱sa n ɗa hal kushindere a kapala ka Magono ma Zuba, a kapala ka kunya ku uba̱ra̱kpa̱ ka ka̱ri a Asu u Uwulukpi. ");
INSERT INTO kdl_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","U kene kpam n ɗa u gbara n ɗa a avana a asuɗara̱kpa u ɗa wa̱ri asu u Katani ka Ugawunsa. N ɗa n buwai vi, u tsungu n ɗa a kami ka asuɗara̱kpa u uɗara̱kpa u urunukpa u ɗa wa̱ri a utsutsu u Katani ka Ugawunsa. ");
INSERT INTO kdl_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","U takpa gba̱ manivi ma kanaka ki aku u runukpa ma a zuba u asuɗara̱kpa. ");
INSERT INTO kdl_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","U yanka kagono ka kanaka ka na ki dere tyoku ɗa u yankai ka a yankai uɗara̱kpa u uwulukpe. Nala kaɗara̱kpi ki ka takpa unyushi u cingi u ama, kpam Kashila̱ ka cimbusuka̱ le ta̱. ");
INSERT INTO kdl_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Aku u wutukpa̱ kanaka ki a uroto u agali u runukpa ka tyoku ɗa u yankai ka kagita̱ ki, kpaci uɗara̱kpa u uwulukpe u ɗa adama a kakuma̱ ka ama ki. ");
INSERT INTO kdl_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","<<Uzapige yan baci unyushi u ɗa u revei n u ɗa wa, hal u koɗoi mele ma te a asuvu a mele ma Magono ma Zuba Kashila̱ ka ne, nala zuwa yi ta̱ u woko uza u unyushi. ");
INSERT INTO kdl_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Aꞌayin a ɗa baci a tonuko yi unyushi u ɗa u yain vi, she u tuko maga̱ji ma ma lyopoi wa, u yain uɗara̱kpa. ");
INSERT INTO kdl_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","U taɗangu kukere ku ne a kaci ka maga̱ji mi, aku u kiɗa ma asu u ɗa a ka kiɗa̱sa nnama adama a uɗara̱kpa u urunukpa a kapala ka Magono ma Zuba. Uɗara̱kpa u uwulukpe u ɗa. ");
INSERT INTO kdl_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Kaɗara̱kpi ka ɗoɓongu majubu ma ne a mpasa mi, aku u gbara n ɗa a avana a asuɗara̱kpa u uɗara̱kpa u urunukpa vi. N ɗa n buwai vi, u tsungu n ɗa a kami ka asuɗara̱kpa u uɗara̱kpa u urunukpa vi. ");
INSERT INTO kdl_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Kaɗara̱kpi ki ka runukpa ta̱ manivi ma maga̱ji mi gba̱ a zuba u asuɗara̱kpa tyoku ɗa a tsu yan n manivi ma uɗara̱kpa u ndishi n shinga, nala kaɗara̱kpi ka takpa unyushi u cingi u uzapige vi adama a unyushi u ne, kpam Kashila̱ ka cimbusuka̱ yi ta̱. ");
INSERT INTO kdl_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","<<Uza roku a asuvu a kakuma̱ ka aza a Isaraꞌila u yan baci unyushi u ɗa u revei n u ɗa wa, hal u koɗoi mele ma te a asuvu a mele ma Magono ma Zuba, nala zuwa yi ta̱ u woko uza u unyushi. ");
INSERT INTO kdl_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Aꞌayin a ɗa baci a tonuko yi unyushi u ɗa u yain vi, u tuko kanuku ka malala ka ka lyopoi wa, u yain uɗara̱kpa adama a unyushi u ɗa u yain vi. ");
INSERT INTO kdl_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","U taɗangu kukere ku ne a kaci ka malala ma uɗara̱kpa u uwulukpe, aku u kiɗa ma asu u ɗa a ka kiɗa̱sa nnama adama a uɗara̱kpa u urunukpa. ");
INSERT INTO kdl_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Kaɗara̱kpi ka ɗoɓongu majubu ma ne a mpasa mi aku u gbara n ɗa a avana a asuɗara̱kpa u uɗara̱kpa u urunukpa. N ɗa n buwai vi, u tsungu n ɗa a kami ka asuɗara̱kpa vi. ");
INSERT INTO kdl_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","U wutukpa̱ manivi mi gba̱ tyoku ɗa a tsu yan n manivi ma uɗara̱kpa u ndishi n shinga, aku u runukpa ma a asuɗara̱kpa. U woko ta̱ uɗara̱kpa u magula̱ni ma shinga ubana a asu u Magono ma Zuba. Nala kaɗara̱kpi ki ka yan uɗara̱kpa u utakpa unyushi u cingi adama a unyushi u cingi u vuma vi, kpam Kashila̱ ka cimbusuka̱ yi ta̱. ");
INSERT INTO kdl_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","<<Shegai u tuko baci maku ma macon adama a uɗara̱kpa u uwulukpe vi, u ka̱na̱ ta̱ u tuko kanuku ka ka lyopoi wa. ");
INSERT INTO kdl_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","U taɗangu kukere ku ne a kaci ka macon ma uɗara̱kpa u uwulukpe vi, aku u kiɗa ma asu u ɗa a ka kiɗa̱sa nnama adama a uɗara̱kpa u urunukpa. ");
INSERT INTO kdl_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Kaɗara̱kpi ka doɓongu majubu ma ne a mpasa mi, aku u gbara n ɗa a avana a asuɗara̱kpa u uɗara̱kpa u urunukpa. N ɗa n buwai vi, u tsungu n ɗa a kami ka asuɗara̱kpa vi. ");
INSERT INTO kdl_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","U wutukpa̱ manivi mi gba̱ tyoku ɗa a tsu yan n manivi ma macon ma uɗara̱kpa u ndishi n shinga, aku u runukpa ma a asuɗara̱kpa a zuba u kune ku ilikulya ubana a asu u Magono ma Zuba. Nala kaɗara̱kpi ki ka yan uɗara̱kpa u utakpa unyushi u cingi adama a unyushi u cingi u vuma vi, kpam Kashila̱ ka cimbusuka̱ yi ta̱.>> ");
INSERT INTO kdl_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Magono ma Zuba ma lyai kapala n kadyanshi, <<A isa̱ vu baci vu yain kadyanshi a kaci ka ili iꞌya vu wenei ko tani vu revei, aku vu ꞌyuwain uyan kadyanshi, vu yan ta̱ unyushi kpam wa̱ ta̱ a kaci ka vunu. ");
INSERT INTO kdl_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Ko tani vuma sawa baci ili iꞌya iꞌa̱ri na̱ nshinda̱ n ureve u ne wa, ko kakushe ka manama ma mete ma nshinda̱ ko kpam ka ma kuwa, ko kakushe ka manama ma nshinda̱ ma ma ka̱bura̱ a iyamba, wa woko ta̱ na̱ nshinda̱ kpam uza u unyushi, ko an u wokoi u reve wa. ");
INSERT INTO kdl_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Vuma sawa baci dem nshinda̱ n ɗa n wuta̱i a ikyamba i vuma bawu u revei n ɗa ma zuwa vuma u woko na̱ nshinda̱, u tuwa̱ u reve baci, wa woko ta̱ uza u unyushi. ");
INSERT INTO kdl_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Vuma yan baci kpam maloko ma utsina bawu u yawunsai, u da wa yan ili i roku i shinga ko i cingi n ureve u ne wa, u tuwa̱ u reve baci, wa woko ta̱ uza u unyushi. ");
INSERT INTO kdl_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Vuma reve baci u yain unyushi u te a asuvu a nala yi, she u dana ucun u unyushi u ɗa u yain vi. ");
INSERT INTO kdl_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","U ka̱na̱ ta̱ u tuko Magono ma Zuba ili i na i woko mavura ma unyushi u ɗa u yain vi: U tuko kanuku ka macon ko kpam kanuku ka malala u woko uɗara̱kpa u uwulukpe, aku kaɗara̱kpi ki ka yain uɗara̱kpa u utakpa u unyushi u cingi adama unyushi u cingi u vuma vi. ");
INSERT INTO kdl_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","<<Vuma vi wa̱ baci n ucira u macon ko maryaɗiga wa, wa fuɗa ta̱ wa tuko aꞌaɗya a re ko kpam mmuku ma ntambara n re ubana a asu u Magono ma Zuba u woko yi katsupi ka unyushi u ɗa u yain vi. U yanka ma te uɗara̱kpa adama unyushi u cingi u ɗa u yain vi, ma te kpam adama a uɗara̱kpa u urunukpa. ");
INSERT INTO kdl_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Wa tuko ta̱ n ɗa a asu u kaɗara̱kpi. Kaɗara̱kpi ka gita̱ uyan uɗara̱kpa uwulukpe, u piyanla udyoku vi shegai wa takpamgbana u ɗa wa. ");
INSERT INTO kdl_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Pini nala, u vishana̱sa mpasa n roku ma uɗara̱kpa u uwulukpe u ɗa u yain vi a apashi a asuɗara̱kpa, u ɗori mpasa n ɗa n buwai vi a kami ka a asuɗara̱kpa vi, kpaci uɗara̱kpa u uwulukpe u ɗa. ");
INSERT INTO kdl_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Manu ma ire mi kaɗara̱kpi ka yanka ma uɗara̱kpa u urunukpa derere tyoku ɗa mele ma danai. Nala kaɗara̱kpi ki ka yan uɗara̱kpa u utakpa unyushi u cingi adama unyushi u cingi u vuma vi, kpam Kashila̱ ka cimbusuka̱ yi ta̱. ");
INSERT INTO kdl_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","<<U ka̱na̱ baci aꞌaɗya yi ko kpam mmuku ma ntambara n re mi n la baci ucira u ne adama u yanka uɗara̱kpa u uwulukpe u ne vi, she u tuko kakundatsu ka kuden ka te a asuvu a kupa ku kira ku lewu tsa̱ra̱ a yanka yi uɗara̱kpa adama unyushi u cingi u ne. Wa tsungu manivi ko kpam ili i magula̱ni asu u kira ki wa, kpaci uɗara̱kpa u uwulukpe u ɗa. ");
INSERT INTO kdl_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Wa tuko ta̱ kaɗara̱kpi kira ki, eyi kpam wa kene ta̱ kira ki a kukere ku ne tipi ku woko kunzu ku uciɓusa. Wa runukpa ta̱ ka a zuba u asuɗara̱kpa tyoku u kune ku ilikulya ubana a asu u Magono ma Zuba, kpaci uɗara̱kpa u uwulukpe u ɗa. ");
INSERT INTO kdl_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Nala kaɗara̱kpi ki ka yan uɗara̱kpa u utakpa unyushi u cingi a asuvu a unyushi u cingi u ɗa baci dem vuma vi u yain, kpam Kashila̱ ka cimbusuka̱ yi ta̱. Kira ka ku buwai vi ka woko ta̱ ku kaɗara̱kpi, tyoku ɗa ku tsu woko ku ne a ka yan baci uɗara̱kpa u ilya.>> ");
INSERT INTO kdl_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Magono ma Zuba ma tonukoi Musa: ");
INSERT INTO kdl_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","<<Vuma yan baci ukuna u cingi, kpam u yain unyushi u ɗa u revei n u ɗa wa, a kaci ka ili i uwulukpi i Magono ma Zuba, she u tuko kondom ka ka lyopoi wa, a asuvu a ushiga ubana a asu u Magono ma Zuba a una̱ katsupi ka ne u woko yi uɗara̱kpa u utsupa unyushi u cingi. A ka yanka ta̱ kondom ki ikebe dere n ikebe i azurufa iꞌya a tsu yanka manyan a kuwa ku uwulukpi. ");
INSERT INTO kdl_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Wa yan ta̱ kpam katsupi adama ili i uwulukpi iꞌya u yain unyushi a kaci ka ne. U na̱ka̱ kpam kunzu ku te a asuvu a kunzu ku tawun a zuba, u na̱ka̱ kaɗara̱kpi uza ɗa wa takpa unyushi u cingi u ɗa u yain a asu u uɗara̱kpa kondom adama a utsupa unyushi u cingi, kpam Kashila̱ ka cimbusuka̱ yi ta̱. ");
INSERT INTO kdl_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","<<Uza u yan baci unyushi kpam u koɗoi mele ma te a asuvu a mele ma Magono ma Zuba ko u kpa̱ɗa̱ baci tani ureve, wa woko ta̱ uza u unyushi kpam unyushi vi wa̱ ta̱ a kaci ka ne. ");
INSERT INTO kdl_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","U ka̱na̱ ta̱ u banka kaɗara̱kpi ki kondom ka ka lyopoi wa, a asuvu u ushiga, u yanka ka ikebe dere n tyoku ɗa kondom ka a tukoi adama a uɗara̱kpa u utsupa unyushi u cingi vi; kaɗara̱kpi kpam ka takpa ta̱ unyushi u cingi u vuma vi adama u unyushi u ɗa u yain u revei n u ɗa wa, kpam Kashila̱ ka cimbusuka̱ yi ta̱. ");
INSERT INTO kdl_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Uɗara̱kpa u utsupa unyushi u cingi u ɗa; mayun, u yanka ta̱ Magono ma Zuba unyushi u cingi.>> ");
INSERT INTO kdl_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Magono ma Zuba ma tonukoi Musa: ");
INSERT INTO kdl_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","<<Vuma yan baci unyushi a ukuna u cingi ara Magono ma Zuba, wata, u yinsa̱i utoku u ne asu u ili iꞌya u na̱ka̱ yi kuzuwa ko u wusa yi ili, ko tani u yanka yi uboku, ko u ryafa yi. ");
INSERT INTO kdl_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Ko kpam a dana vuma tsa̱ra̱ ili iꞌya i puwa̱in aku u yain kaɓan a kaci ka ili iꞌya u tsa̱ra̱i, ko u tsinai utsina u kaɓan a kaci ka ili iꞌya baci dem i tsu zuwa uza u yain unyushi u cingi. ");
INSERT INTO kdl_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Vuma yan baci asuvu a unyushi u nala vi hal a revei n unyushi u ne, she u gonuko ili iꞌya u bokoi vi, ko ili iꞌya u wusai ko ili iꞌya a na̱ka̱ yi kuzuwa ko kpam ili iꞌya i puwa̱in aku u tsa̱ra̱i vi. ");
INSERT INTO kdl_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Ko tani ili iꞌya u yankai utsina u kaɓan a kaci ka ne, wa gonuko ta̱ uza u ili tyoku ɗa iꞌa̱ri yi hal gba̱m u doku yi kunzu ku te asuvu a kunzu ku tawun, kain ka nala ki ka wa yan uɗara̱kpa u utsupa unyushi u cingi u ne, kain ka dem wa gonuko uza vi ili i ne. ");
INSERT INTO kdl_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","U ka̱na̱ ta̱ u banka kaɗara̱kpi kondom ka ka lyopoi wa, a asuvu a ushiga u ncon, tsa̱ra̱ u woko yi katsupi ka unyushi u cingi u ɗa u yain. Kaɗara̱kpi ki ka yanka yi uɗara̱kpa u utsupa unyushi u cingi ubana a asu u Magono ma Zuba. A ka kiɗumkpa ta̱ ka ikebe dere n tyoku kondom ka a tukoi adama u uɗara̱kpa u uwulukpe vi. ");
INSERT INTO kdl_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Kaɗara̱kpi kpam ka takpa ta̱ unyushi u cingi u ɗa u yan vi a kapala ka Magono ma Zuba, kpam Kashila̱ ka cimbusuka̱ yi ta̱ ucun u unyushi u ɗa baci dem u yain.>> ");
INSERT INTO kdl_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Magono ma Zuba ma tonukoi Musa: ");
INSERT INTO kdl_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","<<Na̱ka̱ Haruna n alobo a ne mele a kaci ka uɗara̱kpa u urunukpa, uɗara̱kpa u urunukpa vi wa wansa ta̱ a zuba u asuɗara̱kpa vi, akina a ɗa aꞌa̱ri pini vi a ka wansa ta̱ n a tasi. ");
INSERT INTO kdl_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Aku kain ka wansa baci, kaɗara̱kpi ka uka matogo ma kunya ku linin n magbidi ma ucaku u asuvu u aminya a linin aku u pura̱ kakomo ka uɗara̱kpa u urunukpa u ɗa a yain a zuba u asuɗara̱kpa vi, u tsungu ka a ikengi asuɗara̱kpa vi. ");
INSERT INTO kdl_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Aku u mondo aminya yi u uka a roku, pini nala, u pura̱ kakomo ki u banka a uroto u agali yi, u wotsongu ka a asu u ɗa a wulukpei. ");
INSERT INTO kdl_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Akina a ɗa aꞌa̱ri a zuba u asuɗara̱kpa vi a ka rongo ta̱ utasa, a ka cimbusa̱ a ɗa wa. Usana dem kaɗara̱kpi ka rongo ta̱ ugbatyangusu akina yi, u dari kpam uɗara̱kpa u urunukpa vi a zuba u akina yi, u runukpa dem manivi ma uɗara̱kpusa u ndishi n shinga a zuba u ne. ");
INSERT INTO kdl_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","U ka̱na̱ ta̱ akina yi a rongo u tasa a zuba u asuɗara̱kpa vi maco kotsu a cimba̱ wa. ");
INSERT INTO kdl_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","<<Mele ma uɗara̱kpa u ilya ma na: alobo a Haruna a ka tuko ta̱ u ɗa ubana a asu u Magono ma Zuba a kapala ka asuɗara̱kpa. ");
INSERT INTO kdl_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Kaɗara̱kpi ka te a asuvu a le ka shaɗangu kukere ku ne tipi n kira ku lewu ka uɗara̱kpa u ilya usatari n manivi, n ili magula̱ni iꞌya iꞌa̱ri a zuba u uɗara̱kpa u ilya vi gba̱, aku u runukpa ka ka woko kunzu ku uciɓusa ku magula̱ni ma shinga ubana a asu u Magono ma Zuba a zuba u asuɗara̱kpa vi. ");
INSERT INTO kdl_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Haruna n alobo a ne a lyai kabuwi ka ili iꞌya i buwai a uɗara̱kpa u ilya vi. A lyai ka bawu yisti a asu u uwulukpi, wata, ulanga u Katani ka Ugawunsa. ");
INSERT INTO kdl_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","A yain u ɗa bawu a tsungi yisti, mpa Magono ma Zuba n neke ta̱ ka a una̱ u kunzu ku kune ku ilikulya ka a na̱ka̱ mu. Tyoku u uɗara̱kpa u uwulukpe n uɗara̱kpa u utsupa unyushi u cingi, u ka̱na̱ ta̱ u woko uwulukpi cika. ");
INSERT INTO kdl_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Gba̱ mmuku n tsikaya n Haruna aꞌali a ka fuɗa ta̱ a lyai. U woko ɗe kunzu ku kune ku ilikulya ubana ara Magono ma Zuba. Mele ma na mi ma yan ta̱ pini a uyan u ɗe ushani ubana. Gba̱ uza ɗa baci u sawai uɗara̱kpusa vi u ka̱na̱ ta̱ u pana ikyamba i uwoko uwulukpi.>> ");
INSERT INTO kdl_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Magono ma Zuba ma tonukoi Musa: ");
INSERT INTO kdl_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","<<Kune ka Haruna n alobo a ne a ka tuko Magono ma Zuba ka na, a kain ka a ka tsunku uza u te a asuvu a le manivi ma uneke u woko kaɗara̱kpi: Kunzu ku te asuvu a kunzu kupa ku kakundatsu ka kuden ku kira ku lewu ku kune ku uɗara̱kpa u ilya ku kain dem, a tuko kagbidi n usana kagbidi kpam n kuvuli. ");
INSERT INTO kdl_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","A vura̱ u ɗa aku a kangala u ɗa n manivi a mabaluwa ma udatsunku, pini nala, vu koɗuso u ɗa vu yain uɗara̱kpa u ilya u magula̱ni ma shinga ubana a asu u Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Asuvu a kagali ka Haruna aꞌali, uza ɗa baci dem a tsunki manivi ma uneke a kaci aya wa woko Magono ma Aɗara̱kpi, aya wa yan uɗara̱kpa u nala vi ubana a asu u Magono ma Zuba, a runukpa u ɗa gba̱. U gan ta̱ a toni mele ma nala mi ubana. ");
INSERT INTO kdl_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Uɗara̱kpa u ilya u kaɗara̱kpi dem a ka runukpa ta̱ u ɗa gba̱, u ka̱na̱ ta̱ a ka lya u ɗa wa.>> ");
INSERT INTO kdl_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Magono ma Zuba ma tonukoi Musa: ");
INSERT INTO kdl_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","<<Tonuko Haruna n alobo a ne mele ma uɗara̱kpa u uwulukpe ma na mi: A asu u ɗa a tsu kiɗa manama ma uɗara̱kpa u urunukpa nte dem a ka kiɗa pini manama ma uɗara̱kpa u uwulukpe a kapala ka Magono ma Zuba. Uɗara̱kpa u nala vi wa̱ ta̱ n uwulukpi cika. ");
INSERT INTO kdl_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Kaɗara̱kpi ka ka yain uɗara̱kpa u uwulukpe vi, aya u ka̱na̱i u lyai u ɗa a asu u uwulukpi, wata, ulanga u Katani ka Ugawunsa. ");
INSERT INTO kdl_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Uza ɗa baci dem ko ili iꞌya baci i sawai inyama yi ya pana ta̱ ikyamba i uwoko uwulukpi, mpasa n ne kpam n paɗa baci a matogo u ka̱na̱ ta̱ a za̱i matogo mi a asu u uwulukpi. ");
INSERT INTO kdl_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","A suwan baci inyama yi a magbodo ma cin, u ka̱na̱ ta̱ a ta̱sa̱ ma, shegai a magbodo ma urim ma baci a suwain iꞌya, u ka̱na̱ ta̱ a saɗara ma aku a za̱i ma n mini. ");
INSERT INTO kdl_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Kalobo ka baci dem ka̱ri a kuwa ku aɗara̱kpi ka fuɗa ta̱ ka takuma inyama yi; kpaci ili i uwulukpi iꞌya cika. ");
INSERT INTO kdl_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Shegai a ka takuma inyama i manama ma uɗara̱kpa u uwulukpe ma a kenei mpasa n ne a ukai asuvu a Katani ka Ugawunsa adama utakpa unyushi u cingi a asu u uwulukpi wa, u ka̱na̱ ta̱ a runukpa iꞌya gbende.>> ");
INSERT INTO kdl_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Magono ma Zuba ma lyai kapala n kadyanshi, <<Mele ma uɗara̱kpusa u utsupa unyushi u cingi ma na, ma̱ ta̱ n uwulukpi cika. ");
INSERT INTO kdl_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","A asu u ɗa a tsu kiɗa manama ma uɗara̱kpa u urunukpa nte dem a ka kiɗa pini manama ma uɗara̱kpa u utsupa unyushi u cingi, aku kaɗara̱kpi ka vishana̱sa mpasa mi a apashi a asuɗara̱kpa vi gba̱. ");
INSERT INTO kdl_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Kaɗara̱kpi ki ka yain uɗara̱kpa n manivi mi gba̱ a zuba u asuɗara̱kpa, wata, uwunja vi gba̱ n manivi ma ne n manivi ma ma palai ucanga u katsuma̱, ");
INSERT INTO kdl_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","na̱ nluba n re n manivi ma ma paɗara le n kapashi ka ka lai tsulobo a asu u akaɗa, u ɗa a ka takpa kaɓolo na̱ nluba n re n nala mi. ");
INSERT INTO kdl_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Kaɗara̱kpi ka runukpa iꞌya a asuɗara̱kpa, kune ku ilikulya ka ubana a asu u Magono ma Zuba. Nala uɗara̱kpa u utsupa unyushi u cingi u ɗa. ");
INSERT INTO kdl_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Kalobo ka dem ka̱ri a kuwa ku aɗara̱kpi ka fuɗa ta̱ ka takuma inyama yi, shegai u ka̱na̱ ta̱ a takuma iꞌya a asu u uwulukpi, kpaci ili i uwulukpi iꞌya cika. ");
INSERT INTO kdl_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","<<Mele ma uɗara̱kpa u utsupa unyushi u cingi n uɗara̱kpa u uwulukpe ma te ma. Kaɗara̱kpi ka baci dem ka yain manyan ma utakpa unyushi u cingi vi aya wa bidya inyama i uɗara̱kpa iꞌya i buwai vi. ");
INSERT INTO kdl_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Kaɗara̱kpi ka baci kpam ka yain uɗara̱kpa u urunukpa adama a uza roku, u bidya ukpan u manama ma a yankai uɗara̱kpa vi. ");
INSERT INTO kdl_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Uɗara̱kpa u ilya u ɗa baci dem a zungi a kalele ko a kangalai a mabaluwa ko a mabaluwa ma udatsunku, wa woko ta̱ u kaɗara̱kpi uza ɗa u yain uɗara̱kpa vi. ");
INSERT INTO kdl_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Shegai gba̱ uɗara̱kpa u ilya u ɗa u buwai, u ɗa a juɗugi n manivi ko kpam a kpa̱ɗa̱i ujuɗugu, wa woko ta̱ u alobo a Haruna gba̱ n kagali ka ne, kpam a pecike le dere-dere.>> ");
INSERT INTO kdl_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Magono ma Zuba ma tonukoi Musa: <<Mele ma uɗara̱kpa u ndishi n shinga ma na, u ɗa a ka yanka Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Adama a ucikpa u ɗa baci vuma vi u yain uɗara̱kpa vi, she u yain u ɗa kaɓolo n burodi u apeteli u ɗa u nambai yisti u ɗa a juɗugi n manivi, n amasa a katali a ɗa a nambai yisti a ɗa a gbara̱kai manivi, n burodi u apeteli u ɗa a yain n kira ku lewu ka a juɗugi n manivi. ");
INSERT INTO kdl_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Kaɓolo n uɗara̱kpusa u ndishi n shinga u ucikpa, aku a tuko burodi u apeteli u ɗa a yain n yisti. ");
INSERT INTO kdl_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","U ka̱na̱ ta̱ u tuko burodi u te u te a asuvu uɗara̱kpusa u ɗa u yansai na vi, adama u kune ubana a asu u Magono ma Zuba, nala vi wa woko ta̱ u kaɗara̱kpi uza ɗa u vishana̱sai mpasa adama a uɗara̱kpa u ndishi n shinga vi. ");
INSERT INTO kdl_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","U ka̱na̱ ta̱ a takuma inyama i uɗara̱kpa u ɗa u yain adama uɗara̱kpa u ndishi n shinga u ucikpa a kain ka a yanka yi vi, kotsu a a̱sa̱ka̱ inyama yi i wansa wa. ");
INSERT INTO kdl_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Shegai kune ku ne adama a ushaɗangu u utsina ka baci, ko kpam kune ku uciga u kaci u ne, she a takuma iꞌya a kain ki, iꞌya baci kpam i buwai, a takuma iꞌya kain ka wansa baci. ");
INSERT INTO kdl_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Inyama yi i kotso baci wa ubana a kain ka tatsu, u ka̱na̱ ta̱ a runukpa iꞌya. ");
INSERT INTO kdl_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","A takuma baci inyama i uɗara̱kpa u ɗa a yain adama u uɗara̱kpa u ndishi n shinga asuvu a kain ka tatsu, a ka wushuku n uza ɗa u yain uɗara̱kpa vi wa, kpam a ka na̱ka̱ u ɗa karinga̱ wa. Inyama yi ya woko ta̱ ili i icaɗi, kpam uza ɗa baci dem u takumai iꞌya, mpasa ma unyushi mi ma̱ ta̱ a kaci ka ne. ");
INSERT INTO kdl_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","<<Inyama yi i sawa baci ili iꞌya iꞌa̱ri na̱ nshinda̱, a ka takuma iꞌya wa, a runukpa iꞌya. Inyama i uɗara̱kpa iꞌya baci a wulukpei, uza ɗa baci dem a wulukpei wa fuɗa ta̱ u takuma iꞌya. ");
INSERT INTO kdl_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Shegai uza u nshinda̱ ɗa baci dem u takumai inyama i uɗara̱kpa u ndishi n shinga u ɗa a yain ubana a asu u Magono ma Zuba, a ka pece yi ta̱ n ama a ne. ");
INSERT INTO kdl_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Uza roku u sawu baci ili i nshinda̱ ko uza ɗa baci ko asuvu a nnama n kuwa ko tani gba̱ ili iꞌya iꞌa̱ri n icaɗi, kpam u takumai inyama i uɗara̱kpa u ndishi n shinga u ɗa a yankai Magono ma Zuba. Ucun u vuma u nala vi, a ka pece yi ta̱ n ama a ne.>> ");
INSERT INTO kdl_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Magono ma Zuba ma tonukoi Musa: ");
INSERT INTO kdl_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","<<Tonuko aza a Isaraꞌila vu dana: Kotsu i takuma manivi ma anaka ko ma ncon ko tani ma nryaɗiga wa. ");
INSERT INTO kdl_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Manivi ma manama ma ma kuwa̱i agifa n manivi ma manama ma nnama n mete n wunai, a ka fuɗa ta̱ a yanka ma manyan ma roku, shegai kotsu a takuma ma wa ko kenu. ");
INSERT INTO kdl_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Gba̱ uza ɗa baci u takumai manivi ma manama ma kune ku ilikulya ubana a asu u Magono ma Zuba, a peci yi n ama a ne. ");
INSERT INTO kdl_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Asu u ɗa baci dem i dusuki ya takuma mpasa n manu ko tani ma nnama wa. ");
INSERT INTO kdl_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Gba̱ uza ɗa baci u takumai mpasa, a peci yi n ama a ne.>> ");
INSERT INTO kdl_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Magono ma Zuba ma tonukoi Musa: ");
INSERT INTO kdl_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","<<Tonuko aza a Isaraꞌila: Gba̱ uza ɗa baci dem wa tuko uɗara̱kpa u ndishi n shinga asu u Magono ma Zuba, u na̱ka̱ pini Magono ma Zuba kapashi ka roku kune. ");
INSERT INTO kdl_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","U tuko Magono ma Zuba kune ku ilikulya n kaci ka ne. U tuko kpam manivi ma nnama n akamba a manama yi, aku u yain uɗara̱kpa u ura̱ɗugba̱ a kapala ka Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Kaɗara̱kpi ka runukpa manivi mi a zuba u asuɗara̱kpa, shegai akamba yi a ka woko ta̱ kunzu ku Haruna n alobo a ne. ");
INSERT INTO kdl_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Maguta̱ ma ulyaki ma manama ma a yankai uɗara̱kpa u ndishi n shinga vi, a na̱ka̱ ma kaɗara̱kpi ma woko kune ka vuma vi u tuko yi. ");
INSERT INTO kdl_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Maku ma Haruna ma ma yain uɗara̱kpa u mpasa n manivi ma nnama adama a uɗara̱kpa u ndishi n shinga, maguta̱ ma ulyaki ma woko kunzu ku ne. ");
INSERT INTO kdl_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","A asuvu a uɗara̱kpa u ndishi n shinga u aza a Isaraꞌila, mpa Magono ma Zuba n bidya ta̱ akamba a ɗa a ra̱ɗugba̱i n maguta̱ ma a tukoi vi n na̱ka̱i Haruna kaɗara̱kpi n alobo a ne u woko kunzu ku le a asuvu a uɗara̱kpusa u aza a Isaraꞌila ubana. ");
INSERT INTO kdl_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","<<Nala wa woko ta̱ kunzu ka a zuwukai Haruna n alobo a kagali ka ne a asuvu a kune ku ilikulya ubana a asu u Magono ma Zuba, ili iꞌya i ka̱na̱i kain ka a neke le a wokoi aɗara̱kpi a ɗa ka gbashika Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Magono ma Zuba ma tonukoi aza a Isaraꞌila a na̱ka̱ aɗara̱kpi ili i nala yi, ili iꞌya i ka̱na̱i kain ka u tsunku le manivi ma uneke a woko aɗara̱kpi; nala wa woko ta̱ kunzu ku le a uyan u le ushani ubana.>> ");
INSERT INTO kdl_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Nala mele ma uɗara̱kpa u urunukpa ma n uɗara̱kpa u ilya n uɗara̱kpa u uwulukpe n uɗara̱kpa u utsupa unyushi u cingi n uɗara̱kpa u uwoko kaɗara̱kpi n uɗara̱kpa u ndishi n shinga. ");
INSERT INTO kdl_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Ili i na iꞌya Magono ma Zuba ma tonukoi Musa a Masasa ma Sinai a kakamba, a kain ka u tonukoi aza a Isaraꞌila a tukuso kune a asu u ne. ");
INSERT INTO kdl_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Magono ma Zuba ma tonukoi Musa, ");
INSERT INTO kdl_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","<<Bidya Haruna n alobo a ne n aminya a tsuɗara̱kpi a le n manivi ma uneke n kagono ka kanaka ka uyanka uɗara̱kpa u uwulukpe n aꞌondom a re n mabana ma burodi ma bawu a tsungi yisti. ");
INSERT INTO kdl_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Vu ɓolomgbono gba̱ kakuma̱ ka aza a Isaraꞌila a utsutsu u Katani ka Ugawunsa.>> ");
INSERT INTO kdl_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Musa tani u yain tyoku ɗa Magono ma Zuba ma tonuko yi u yain, aku ama yi a ɓolomgbonoi a utsutsu u Katani ka Ugawunsa. ");
INSERT INTO kdl_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Musa tonukoi gba̱ kakuma̱ ka aza a Isaraꞌila ki, <<Ili iꞌya Magono ma Zuba ma danai a yain iꞌya na.>> ");
INSERT INTO kdl_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Aku u wutukpa̱i Haruna n alobo a ne u sumba̱ le. ");
INSERT INTO kdl_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","U ukunkai Haruna matogo ma asuvu aku u sira̱ka yi kagbawatsu, u ukunka yi matogo ma bululu, n matogo ma ifo ma a sira̱kai kagbawatsu ka shinga ka a cai n akere tsa̱ra̱ u ka̱na̱i mai. ");
INSERT INTO kdl_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Aku Musa zuwuka yi kasolo ka uwulukpi ka makamba, asuvu a kasolo yi u zuwuka yi ta̱ ili iꞌya a tsu isa̱ Yurim n Tumim. ");
INSERT INTO kdl_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Aku u cacika yi funi u kaɗara̱kpi; a kapala ka funi ki a paɗara ta̱ pini maku ma urim ma zinariya ukyawan, wata, funi u uwulukpi, tyoku ɗa Magono ma Zuba ma tonukoi Musa. ");
INSERT INTO kdl_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Aku Musa bidyai manivi ma uneke u vishana̱sai Katani ki n ili iꞌya iꞌa̱ri pini gba̱ a asu vi. Nala u nekei iꞌya i wokoi uwulukpi ubana a asu u Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","U tsa̱ra̱i u vishana̱sai manivi ma roku a asuɗara̱kpa hal kushindere, u nekei a asuɗara̱kpa vi n ucanga u manyan u ne, n mabara ma pige n kacan ka ne dem. ");
INSERT INTO kdl_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Aku Musa tsunki Haruna manivi ma uneke a kaci tsa̱ra̱ u neke yi. ");
INSERT INTO kdl_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Pini nala, u tukoi alobo a Haruna, u ukusa le ntogo ma asuvu n ifuni, u sira̱ka le agbawatsu, tyoku ɗa Magono ma Zuba ma tonuko yi. ");
INSERT INTO kdl_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Aku Musa tukoi kagono ka kanaka ka uɗara̱kpa u uwulukpe. Haruna n alobo a ne a taɗangi akere a le a kaci ka kagono kanaka ki. ");
INSERT INTO kdl_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Aku Musa kiɗai ka. Pini nala, u doɓoi mpasa mi n majubu u gbarai n ɗa a avana a asuɗara̱kpa vi tsa̱ra̱ u wulukpe u ɗa, aku u tsungi mpasa n ɗa n buwai vi a kami ka asuɗara̱kpa vi. Nala u nekei asuɗara̱kpa vi u gonukoi u ɗa uwulukpi adama a utakpa u unyushi u cingi. ");
INSERT INTO kdl_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Musa kpam takpai gba̱ manivi ma ma̱ri a zuba u ucanga u katsuma̱, n kapashi ka ka lai tsulobo ka asu u akaɗa, na̱ nluba n re kaɓolo n manivi ma le, u runukpa iꞌya a zuba u asuɗara̱kpa. ");
INSERT INTO kdl_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Shegai kabuwi ka inyama i kanaka yi n ukpan u ne n inyama i ne n awunyen a ne gba̱ Musa runukpa ta̱ iꞌya a uroto u agali, tyoku ɗa Magono ma Zuba ma tonuko yi. ");
INSERT INTO kdl_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Aku Musa tukoi kondom ka uɗara̱kpa u urunukpa. Haruna n alobo a ne a taɗangi akere a le a kaci ka kondom ki, ");
INSERT INTO kdl_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","pini nala u kiɗai ka u vishana̱sai mpasa mi a apashi a nishi a asuɗara̱kpa vi gba̱. ");
INSERT INTO kdl_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","U kiɗa̱sai kondom ki agbidi-agbidi, aku u runukpai kaci ki n akiɗi a inyama yi kaɓolo n manivi mi. ");
INSERT INTO kdl_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","U za̱i ucanga u katsuma̱ n akpete, aku u runukpai inyama i kondom yi gba̱ a zuba u asuɗara̱kpa. Uɗara̱kpa u urunukpa u ɗa la vi u magula̱ni ma shinga, kune ku ilikulya ubana a asu u Magono ma Zuba, tyoku ɗa Magono ma Zuba ma tonukoi Musa. ");
INSERT INTO kdl_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Aku Musa zuwai a tuko kondom ka ire ki, wata, kondom adama a uneke kaɗara̱kpi. Haruna n alobo a ne a taɗangi akere a le a zuba u kaci ka kondom ki, ");
INSERT INTO kdl_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","aku u kiɗai ka, pini nala, u kenei mpasa mi u gbarai n ɗa a ucoli u kutsuvu ku ulyaki ku Haruna, n majubu ma pige ma ulyaki ma kukere ku ne, n majubu ma pige ma ulyaki ma kune ku ne. ");
INSERT INTO kdl_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Aku Musa tukoi alobo a Haruna, u kenei mpasa mi u gbarai n ɗa a ucoli u atsuvu a ulyaki a le, na̱ njubu n pige ma akere a ulyaki, na̱ njubu n pige ma aꞌene a ulyaki a le. Aku u vishana̱sai mpasa mi a apashi a nishi a asuɗara̱kpa vi gba̱. ");
INSERT INTO kdl_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Aku Musa takpai manivi ma kondom, n uwunja vi gba̱ n manivi ma ne, n manivi ma ma̱ri a zuba u ucanga u katsuma̱ gba̱, n kapashi ka ka lai tsulobo a asu u akaɗa, na̱ nluba n re kaɓolo n manivi ma le, n maguta̱ ma ulyaki. ");
INSERT INTO kdl_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Asuvu a mabana ma burodi u ɗa u nambai yisti ma ma̱ri a kapala ka Magono ma Zuba, u bidyai burodi u apeteli u te u ɗa u nambai yisti, n burodi u apeteli u te u ɗa a juɗugi n manivi, n kamasa ka katali ka te u taɗangi a zuba u manivi ma kondom mi n maguta̱ ma ulyaki. ");
INSERT INTO kdl_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Gba̱ ili i nala yi u zuwai iꞌya a akere a Haruna n alobo a ne. Aku a yankai u ɗa uɗara̱kpa u ura̱ɗugba̱ a kapala ka Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Aku Musa wushai iꞌya a akere a le u runukpai iꞌya a zuba u asuɗara̱kpa kaɓolo n uɗara̱kpa u urunukpa a una̱ u uɗara̱kpa u uneke u kaɗara̱kpi. Kune ku ilikulya ka ku magula̱ni ma shinga ubana a asu u Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Musa kpam u bidyai akamba a kondom yi, a ɗa aꞌa̱ri kunzu ku ne u yankai u ɗa uɗara̱kpa u ura̱ɗugba̱ ubana a asu u Magono ma Zuba, tyoku ɗa Magono ma Zuba ma tuko yi. ");
INSERT INTO kdl_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Musa kpam kenei manivi ma uneke na̱ mpasa n ɗa ma̱ri a asuɗara̱kpa vi u vishana̱sa̱kai Haruna n aminya a ne. U vishana̱sa̱kai kpam alobo a Haruna n aminya a le. Nala u nekei Haruna n aminya a ne n alobo a ne n aminya a le n uwulukpi. ");
INSERT INTO kdl_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Aku Musa tonukoi Haruna n alobo a ne, <<Suwain inyama yi a utsutsu u Katani ka Ugawunsa kpam i takuma iꞌya pini, kaɓolo n iburodi iꞌya iꞌa̱ri asuvu a mabana ma ucanga u uneke u kaɗara̱kpi, tyoku ɗa mpa Magono ma Zuba ma danai, <Haruna n alobo a ne a ɗa a ka takuma iꞌya.> ");
INSERT INTO kdl_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Gba̱ ili iꞌya i buwai asuvu a inyama yi ko tani burodi vi, i runukpa iꞌya. ");
INSERT INTO kdl_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Kotsu i wuta̱ a utsutsu u Katani ka Ugawunsa ki wa hal aꞌayin a shindere, wata, she aꞌayin a uneke u kaɗara̱kpi a shaɗangu, kpaci uneke u ɗe wa bidya ta̱ aꞌayin a shindere. ");
INSERT INTO kdl_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Ili iꞌya a yain ara, a yan ta̱ iꞌya tyoku ɗa Magono ma Zuba ma danai a yain a kaci ka uɗara̱kpa u upala ukuna adama a ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Ya dusuku ta̱ a utsutsu u Katani ka Ugawunsa kaara n kayin hal aꞌayin a shindere n i kirani n udani u Magono ma Zuba, tsa̱ra̱ i kuwa̱ wa, kpaci nala a tonuko mu.>> ");
INSERT INTO kdl_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Aku Haruna n alobo a ne a yain gba̱ ili iꞌya Magono ma Zuba ma danai a una̱ u Musa. ");
INSERT INTO kdl_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","An aꞌayin a shindere a abiki a uneke yi a wurai, a kain ka kulla̱, aku Musa isa̱i Haruna n alobo a ne na̱ nkoshi ma aza a Isaraꞌila. ");
INSERT INTO kdl_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","U tonukoi Haruna, <<Bidya kagono ka madyondyom ma ma lyopoi wa, adama a uɗara̱kpa u uwulukpe, n kondom ka ka lyopoi wa, adama a uɗara̱kpa u urunukpa, vu tuko le a asu u Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Aku vu tonuko aza a Isaraꞌila a bidya maga̱ji adama a uɗara̱kpa u uwulukpe, n madyondyom n macon n kayen ka te ka te n ɗa lyopoi wa, adama a uɗara̱kpa u urunukpa. ");
INSERT INTO kdl_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","A tuko dem kanaka n kondom adama a uɗara̱kpa u ndishi n shinga ubana a asu u Magono ma Zuba, n uɗara̱kpa u ilya a juɗugu n manivi, kpaci ara Magono ma Zuba ma wenike ta̱ kaci ka ne ara ɗe.>> ");
INSERT INTO kdl_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Aku a tukoi ili iꞌya Musa tonuko le a tuko vi a kapala ka Katani ka Ugawunsa, gba̱ kakuma̱ ka ama a raɓai evu a shamgbusai a kapala ka Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Musa kpam u danai, <<Ili iꞌya Magono ma Zuba ma tonuko ɗa̱ i yain iꞌya na, tsa̱ra̱ tsupige tsu Magono ma Zuba tsu wenike kaci ka ne ara ɗe.>> ");
INSERT INTO kdl_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Aku Musa tonukoi Haruna, <<Bana evu n asuɗara̱kpa vu yain uɗara̱kpa u uwulukpe u vunu n uɗara̱kpa u urunukpa, vu takpa unyushi u cingi u vunu n u ama a vunu. Aku vu yain uɗara̱kpa u ɗa ama yi a tukoi adama a utakpa unyushi u cingi u le, tyoku ɗa Magono ma Zuba ma danai.>> ");
INSERT INTO kdl_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Aku Haruna banai evu n asuɗara̱kpa vi u kiɗai kagono ka madyondyom ki, u yain uɗara̱kpa u uwulukpe u kaci u ne. ");
INSERT INTO kdl_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Aku alobo a ne a tuko yi mpasa mi, u doɓongi majubu ma ne asuvu mpasa mi u gbarai n ɗa asu u avana a asuɗara̱kpa vi. Pini nala, u tsungi n ɗa n buwai vi a kami ka asuɗara̱kpa. ");
INSERT INTO kdl_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Shegai u runukpai manivi mi, na̱ nluba mi n kapashi ka ka lai tsulobo a asu u akaɗa adama a uɗara̱kpa u uwulukpe vi a zuba u asuɗara̱kpa, tyoku ɗa Magono ma Zuba ma tonukoi Musa. ");
INSERT INTO kdl_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Shegai inyama n ikpan yi u runukpai iꞌya a uroto u agali. ");
INSERT INTO kdl_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Aku Haruna kiɗai manama ma uɗara̱kpa u urunukpa vi, alobo a ne kpam a na̱ka̱ yi mpasa mi aku u vishana̱sai n ɗa a apashi a nishi a asuɗara̱kpa vi gba̱. ");
INSERT INTO kdl_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","A na̱ka̱ yi kpam kaci n agbidi-agbidi a inyama yi, aku u runukpai iꞌya a zuba u asuɗara̱kpa. ");
INSERT INTO kdl_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","U za̱i ucanga u katsuma̱ n akpete yi, aku u runukpai iꞌya kaɓolo n uɗara̱kpa u urunukpa u ɗa wa̱ri a zuba u asuɗara̱kpa vi. ");
INSERT INTO kdl_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Pini nala, Haruna tukoi kune ku ama ki. U bidyai maga̱ji ma a ka yanka uɗara̱kpa u uwulukpe u ama, u kiɗai ma u yain uɗara̱kpa u uwulukpe tyoku ɗa u gita̱i u yain n uɗara̱kpa u uwulukpe u ne. ");
INSERT INTO kdl_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Aku u tukoi uɗara̱kpa u urunukpa, u yain u ɗa dere tyoku ɗa mele ma danai. ");
INSERT INTO kdl_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","U tukoi kpam uɗara̱kpa u ilya, u shaɗangi kukere ku ne n kira, aku u runukpai ka a zuba u asuɗara̱kpa kaɓolo n uɗara̱kpa u urunukpa u usana vi. ");
INSERT INTO kdl_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Aku Haruna kiɗai kpam kanaka n kondom adama uɗara̱kpa u ndishi n shinga u ama. Aku alobo a ne a na̱ka̱ yi mpasa mi, u vishana̱sai n ɗa a apashi a nishi a asuɗara̱kpa vi gba̱. ");
INSERT INTO kdl_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Aku a takpai manivi ma kanaka n ma kondom mi, n uwunja vi gba̱ n manivi ma ne n manivi ma palai ucanga u katsuma̱, na̱ nluba n ma kapashi ka ka lai tsulobo a asu u akaɗa. ");
INSERT INTO kdl_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Aku a taɗangi manivi mi a zuba u akamba a nnama mi, aku u runukpai manivi mi a asuɗara̱kpa. ");
INSERT INTO kdl_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Shegai u yan ta̱ uɗara̱kpa u ura̱ɗugba̱ n akamba n maguta̱ ma ulyaki ubana a asu u Magono ma Zuba, tyoku ɗa Musa tonuko yi u yain. ");
INSERT INTO kdl_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","An Haruna yansai uɗara̱kpa u uwulukpe n uɗara̱kpa u urunukpa n uɗara̱kpa u ndishi n shinga, aku u ba̱ra̱kpa̱i akere a ne ubana a asu u ama yi u zuwuka le una̱ u shinga. Pini nala, u cipa̱i a zuba u asuɗara̱kpa vi. ");
INSERT INTO kdl_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Aku Musa n Haruna a uwai a Katani ka Ugawunsa. An a wuta̱i aku a zuwukai ama yi una̱ u shinga, aku tsupige tsu Magono ma Zuba tsu wenikei kaci ka ne a asu u ama yi gba̱. ");
INSERT INTO kdl_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Kute-kute akina a wuta̱i a asu u Magono ma Zuba, a runukpai uɗara̱kpa u urunukpa n manivi ma ma̱ri a zuba u asuɗara̱kpa vi. An ama gba̱ a wenei nala, aku a salai n maza̱nga̱ a kuɗa̱ngusi a varai aꞌaci a le a iyamba a lyai kayala. ");
INSERT INTO kdl_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Alobo a Haruna, Nadabu n Abihu ya dem u bidyai ipuruka̱tsu i tsikina a tsungi pini akina n ili i magula̱ni. Pini nala, a nekei Magono ma Zuba akina a ɗa a nambai uwulukpi ucun u ɗa bawu u tonuko le a yain. ");
INSERT INTO kdl_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Kute-kute akina a wuta̱i a asu u Magono ma Zuba a lya le, a kuwa̱i pini a kapala ka Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Musa tonukoi Haruna, <<Ili iꞌya Magono ma Zuba ma danai iꞌya la vi an u danai, <U ka̱na̱ ta̱ gba̱ aza ɗa a ka gbashika mu a na̱ka̱ uwulukpi u va̱ karinga̱. Kpam ma wenike ta̱ tsupige tsu va̱ a asu u ama gba̱.> >> Kpam ko i te Haruna dana wa. ");
INSERT INTO kdl_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Aku Musa isa̱i Mishayel n Iluzafan alobo a Uziyel tatakenu u Haruna. U tonuko le, <<Tuwa̱i na i canga ikyamba i amaci a ɗe a asu u Katani vi ubana a uroto u agali.>> ");
INSERT INTO kdl_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Aku a tuwa̱i a ka̱na̱sa̱i akushe yi a ntogo n le, a canga le a wutukpa̱ le a uroto u agali, tyoku ɗa Musa danai. ");
INSERT INTO kdl_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Aku Musa tonukoi Haruna n alobo a ne a ɗa a buwai vi, wata, Iliyazara n Itama, u danai, <<Kotsu i a̱sa̱ka̱ kenji ka ɗe kayakali wa, kpam kotsu i kara aminya a ɗe wa, kawa ya kuwa̱ ta̱ kpam Magono ma Zuba ma yan ta̱ upan n gba̱ kakuma̱ ka ama. Shegai atoku a ɗe, wata, gba̱ kuwa ku aza a Isaraꞌila a ka fuɗa ta̱ a sa̱i adama aza ɗa akina a Magono ma Zuba a lyai vi. ");
INSERT INTO kdl_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Kotsu i a̱sa̱ka̱ utsutsu u Katani ka Ugawunsa ki wa, kawa ya kuwa̱ ta̱, kpaci a gbara̱ka ɗa̱ ta̱ manivi ma uneke ma Magono ma Zuba.>> Aku a yain tyoku ɗa Musa tonuko le a yain. ");
INSERT INTO kdl_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Magono ma Zuba ma tonukoi Haruna, ");
INSERT INTO kdl_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","<<Avu n alobo a vunu ya so mini ma cinwi ko tani ili iꞌya ya zuwa ugutukpa wa, ya uwa baci a Katani ka Ugawunsa ki, kawa ya kuwa̱ ta̱. Mele ma na mi ma yan ta̱ pini a uyan u ɗe ushani ubana. ");
INSERT INTO kdl_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","U ka̱na̱ ta̱ i takpana ili iꞌya iꞌa̱ri uwulukpi n iꞌya i nambai uwulukpi, i reve kpam dem ili i nshinda̱ n iꞌya a wulukpei. ");
INSERT INTO kdl_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","U ka̱na̱ ta̱ i wenishike aza a Isaraꞌila gba̱ mele ma Magono ma Zuba ma na̱ka̱ le a una̱ u Musa.>> ");
INSERT INTO kdl_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Musa yain kadyanshi n Haruna n alobo a ne a ɗa a buwai, Iliyazara n Itama, u danai, <<Bidyai uɗara̱kpa u ilya u ɗa u buwai vi a asuvu a kune ku ilikulya ubana a asu u Magono ma Zuba, i foɓuso u ɗa bawu i tsungi yisti, i takuma u ɗa a ikengi i asuɗara̱kpa, kpaci uɗara̱kpa u nala vi wa̱ ta̱ n uwulukpi cika. ");
INSERT INTO kdl_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","I takuma u ɗa a asu u ɗa wa̱ri uwulukpi, kpaci kunzu ku vunu ka n alobo a vunu a asuvu a kune ku ilikulya ubana a asu u Magono ma Zuba; kpaci nala Magono ma Zuba ma tonuko mu. ");
INSERT INTO kdl_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Shegai akamba a ɗa a yankai uɗara̱kpa u ura̱ɗugba̱ n maguta̱ ma a yankai kune ɗa ya takuma, avu n alobo a vunu na̱ nkere n vunu a asu u ɗa a wulukpei. Kpaci a na̱ka̱ ɗa̱ ta̱ iꞌya avu n mmuku n vunu, i woko kunzu ku ɗe asuvu a uɗara̱kpa u ndishi n shinga u aza a Isaraꞌila. ");
INSERT INTO kdl_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Maguta̱ ma a tukoi kune n akamba a ɗa yankai uɗara̱kpa u ura̱ɗugba̱ ubana a asu u Magono ma Zuba, kaɓolo n manivi ma nnama ma kune ku ilikulya, tsa̱ra̱ a yain uɗara̱kpa u ura̱ɗugba̱ ubana a asu u Magono ma Zuba. Apashi a na yi a ka woko ta̱ kunzu ku ɗe, avu na̱ mmuku n vunu a ubana, tyoku ɗa Magono ma Zuba ma danai.>> ");
INSERT INTO kdl_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","An Musa vecei tsa̱ra̱ u reve tyoku ɗa a yain n maga̱ji ma uɗara̱kpa u uwulukpe vi, u cinai a runukpa ma ɗe gba̱! Aku u yain upan n Iliyazara n Itama alobo a Haruna a ɗa a buwai. U danai, ");
INSERT INTO kdl_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","<<Ndya i ɓishinka ɗa̱ utakuma inyama i uɗara̱kpa u uwulukpe a asu u ɗa wa̱ri uwulukpi? Uɗara̱kpa u nala vi wa̱ ta̱ n uwulukpi cika; a na̱ka̱ ɗa̱ ta̱ u ɗa tsa̱ra̱ i takpa unyushi u cingi u kakuma̱ ka ama kpam i takpa unyushi u cingi a una̱ u le a kapala ka Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","An u wokoi bawu a uwai na̱ mpasa n manama mi a asuvu a Asu u Uwulukpi, wa̱ri u gan ta̱ i takuma iꞌya a asu u ɗa wa̱ri uwulukpi tyoku ɗa n tonuko ɗa̱.>> ");
INSERT INTO kdl_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Haruna wushunki Musa, <<Ara na ɗa alobo a va̱ a yain uɗara̱kpa u uwulukpe u le n uɗara̱kpa u urunukpa ubana a asu u Magono ma Zuba, kpam ili iꞌya i gita̱i na̱ mpa ɗa na! Wa̱ri wa yankpa wa̱ Magono ma Zuba ma̱ri n takuma baci uɗara̱kpa u uwulukpe vi?>> ");
INSERT INTO kdl_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","An Musa panai nala, aku u wushuki n kadyanshi ki. ");
INSERT INTO kdl_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Magono ma Zuba ma tonukoi Musa n Haruna, ");
INSERT INTO kdl_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","<<Tonukoi aza a Isaraꞌila i dana: Icun i nnama n ɗa ya takuma n ɗa na a asuvu a nnama n ɗa ma̱ri a iyamba: ");
INSERT INTO kdl_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Gba̱ manama ma baci adeshikpetsu a ne aꞌa̱ri uɓatsi, kpam ma tsu takuma ijani n u tenuki, ya fuɗa ta̱ i takuma ma. ");
INSERT INTO kdl_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Shegai a asuvu a nnama n ɗa n tsu takuma ijani n a tenuki ko n ɗa ma̱ri n uɓatsi u adeshikpetsu, n roku n ɗa pini n ɗa u ka̱na̱i bawu ya takuma: Karakuma ili i nshinda̱ iꞌya ara ɗe, ko an u wokoi ka tsu takuma ta̱ ijani n ka tenuki, shegai ka̱ n uɓatsi u adeshikpetsu wa. ");
INSERT INTO kdl_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Kacari ili i nshinda̱ iꞌya ara ɗe, ko an wokoi ka tsu takuma ijani n u tenuki, shegai ka̱ n uɓatsi u adeshikpetsu wa. ");
INSERT INTO kdl_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Nata ili i nshinda̱ iꞌya ara ɗe, ko an u wokoi u tsu takuma ijani n u tenuki, shegai wa̱ n uɓatsi u adeshikpetsu wa. ");
INSERT INTO kdl_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Maburusunu ili i nshinda̱ iꞌya ara ɗe, ko an u wokoi wa̱ ta̱ n uɓatsi u adeshikpetsu, shegai u tsu takuma ijani u tenuku wa. ");
INSERT INTO kdl_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Kotsu i takuma inyama i le ko i sawa akushe a le wa, kpaci ili i nshinda̱ iꞌya ara ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","<<A asuvu a ili i uma iꞌya iꞌa̱ri a mini, iꞌya ya fuɗa ya takuma iꞌya na: Gba̱ ili iꞌya baci iꞌa̱ri n ili yavu ashan n apici a ikyamba, ko iꞌa̱ baci a kushiva̱ ko a aga̱ta̱, ya fuɗa ta̱ i takuma. ");
INSERT INTO kdl_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Shegai kotsu i takuma nnama n ɗa ma̱ri a kushiva̱ n aga̱ta̱ n ɗa nambai ili yavu ashan n apici wa, ko gba̱ nnama n kenu n ɗa ma̱ri a aga̱ta̱ ko kpam gba̱ ili i uma iꞌya iꞌa̱ri a mini, kpaci ili i nshinda̱ iꞌya ara ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","A ka woko ta̱ ili i nshinda̱ ara ɗe. Ya takuma inyama i le ko kpam i sawa akushe a le wa. ");
INSERT INTO kdl_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Gba̱ ili i uma iꞌya iꞌa̱ri a mini iꞌya bawu iꞌa̱ri n ili yavu ashan n apici, ili i nshinda̱ iꞌya ara ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","<<Icun i nnu n ɗa ya bidya ili i icaɗi kpam bawu ya takuma n ɗa na: Kakuri n kakarikili n kasakali ka mashuwan, ");
INSERT INTO kdl_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","n maguri n akarikili icun kau-kau, ");
INSERT INTO kdl_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","n agawun icun kau-kau, ");
INSERT INTO kdl_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","n kameme n kaviwin n makuɓi na̱ nwurabede icun kau-kau. ");
INSERT INTO kdl_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","Kotsu dem i takuma makpa̱tuwa̱ wa, n kuvan n makuɓi ma pige, ");
INSERT INTO kdl_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","n makuɓi ma eri, n kumbadoki, n kasakali, ");
INSERT INTO kdl_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","n makatakau n aboro a mini icun kau-kau, n tsurukpa̱te n agan. ");
INSERT INTO kdl_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","<<Gba̱ ili i kaꞌimkpa iꞌya iꞌa̱ri n ashan kpam n aꞌene, ya woko ta̱ ili i nshinda̱ ara ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Shegai a asuvu a ili i kaꞌimkpa iꞌya iꞌa̱ri n ashan yi kpam n aꞌene, i roku iꞌya pini iꞌya ya fuɗa ya takuma, iꞌya iꞌa̱ri na̱ nguta̱ n ɗa ma fuɗa ma zuwa le a imkpa. ");
INSERT INTO kdl_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","A asuvu a le iꞌya ya takuma iꞌya na: Abaruma icun kau-kau, n ijaun icun kau-kau, n acu icun kau-kau. ");
INSERT INTO kdl_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Shegai gba̱ ili i kaꞌimkpa iꞌya i buwai iꞌya iꞌa̱ri n aꞌene a nishi, i woko ɗa̱ ili i nshinda̱. ");
INSERT INTO kdl_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","<<Nnama n naha mi ma zuwa ɗa̱ ta̱ i woko na̱ nshinda̱. Uza ɗa baci dem u sawai akushe a le wa woko ta̱ na̱ nshinda̱ ubana kuvuli. ");
INSERT INTO kdl_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Uza ɗa baci dem u cangai akushe a le u ka̱na̱ ta̱ u za̱i aminya a ne, kpam wa rongo ta̱ na̱ nshinda̱ ubana kuvuli. ");
INSERT INTO kdl_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Gba̱ nnama n ɗa bawu ma̱ri n uɓatsi u adeshikpetsu, kpam bawu n tsu gonuko ijani iꞌya a takumai a tenuku, ili i nshinda̱ iꞌya ara ɗe; uza ɗa baci dem u sawai akushe a le wa woko ta̱ n icaɗi. ");
INSERT INTO kdl_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","A asuvu a nnama n ɗa ma̱ri n aꞌene a nishi kpam aꞌa̱ri n adeshikpetsu icun i mazoli, ili i nshinda̱ iꞌya ara ɗe. Uza ɗa baci dem u sawai akushe a le wa woko ta̱ na̱ nshinda̱ ubana kuvuli. ");
INSERT INTO kdl_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Uza ɗa baci dem u cangai akushe a le u ka̱na̱ ta̱ u za̱i aminya a ne, kpam wa rongo ta̱ na̱ nshinda̱ ubana kuvuli; kpaci ili i nshinda̱ iꞌya ara ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","<<Naha kpam a asuvu a ili iꞌya ya ka̱bura̱ a iyamba na vi, ya woko ɗa̱ ili i nshinda̱: Kashan n kareun n agaji a pige icun kau-kau, ");
INSERT INTO kdl_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","n mapalyaun n makuna̱ n kabede n kakenwen n kakala. ");
INSERT INTO kdl_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Gba̱ ili i na yi ili i nshinda̱ iꞌya ara ɗe. Uza ɗa baci dem u sawai akushe a le wa woko ta̱ na̱ nshinda̱ ubana kuvuli. ");
INSERT INTO kdl_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Gba̱ ili iꞌya baci dem kakushe ka le ka rukpa̱i a zuba u ne, ya rongo ta̱ na̱ nshinda̱. Ili yi ko n maɗanga ma baci tani a yain iꞌya, ko n kunya, ko n ukpan, ko n kakpakpa. Ko ndya baci tani a tsu yanka iꞌya manyan, u ka̱na̱ ta̱ a uka iꞌya a mini; ya woko ta̱ na̱ nshinda̱ ubana kuvuli, aku a wulukpe iꞌya. ");
INSERT INTO kdl_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Kakushe ki ka rukpa̱ baci a asuvu a magbodo ma cin, ili iꞌya iꞌa̱ri pini vi ya woko ta̱ na̱ nshinda̱, kpam u ka̱na̱ ta̱ a ta̱sa̱ magbodo mi. ");
INSERT INTO kdl_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Ilikulya iꞌya baci dem mini ma magbodo ma nala mi ma sawai, ya woko ta̱ na̱ nshinda̱. Ili i uso iꞌya baci dem iꞌa̱ri pini a icun i magbodo ma nala mi, ya woko ta̱ na̱ nshinda̱. ");
INSERT INTO kdl_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Gba̱ ili iꞌya baci dem kakushe ka le ka sawai, ya woko ta̱ na̱ nshinda̱, ko kalele ka baci ko kpam asu u uzungusu burodi, u ka̱na̱ ta̱ a ta̱sa̱sa̱ le, kpaci a woko ta̱ na̱ nshinda̱. U ka̱na̱ ta̱ u woko ɗa̱ ili i nshinda̱. ");
INSERT INTO kdl_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Shegai kakushe ki ka rukpa̱ baci a kara̱ra̱ ka mini ko a maɗa̱ka̱ ma mini, mini mi ma ka̱na̱ nshinda̱ wa, shegai uza ɗa baci dem u sawai ka, wa woko ta̱ na̱ nshinda̱. ");
INSERT INTO kdl_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Kakushe ki ka rukpa̱ baci a icun, icun yi ya ka̱na̱ nshinda̱ wa. ");
INSERT INTO kdl_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Shegai a vishana̱sa baci mini a icun yi, aku kakushe ki ka rukpa̱i pini, icun yi ya woko ta̱ na̱ nshinda̱. ");
INSERT INTO kdl_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","<<Manama ma a wushunku ɗa̱ i takuma ma kuwa̱ baci, uza ɗa baci dem u sawai kakushe ki wa woko ta̱ na̱ nshinda̱ ubana kuvuli. ");
INSERT INTO kdl_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Uza ɗa baci dem u takumai kakushe ki, u ka̱na̱ ta̱ u za̱i aminya a ne kpam wa rongo ta̱ na̱ nshinda̱ ubana kuvuli. Uza ɗa kpam dem u cangai kakushe ki u ka̱na̱ ta̱ u za̱i aminya a ne, kpam wa woko ta̱ na̱ nshinda̱ ubana kuvuli. ");
INSERT INTO kdl_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","<<Gba̱ nnama n ɗa n tsu ka̱bura̱ a iyamba, ili i nshinda̱ iꞌya ara ɗe; kotsu i takuma le wa. ");
INSERT INTO kdl_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Kotsu i takuma ili iꞌya baci dem ya rono katsuma̱ a iyamba, ko ili iꞌya i tsu wala n aꞌene a nishi ko kpam ili iꞌya iꞌa̱ri n aꞌene ushani wa, kpaci ili i nshinda̱ iꞌya ara ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Kotsu i nangasa kaci ka ɗe n icaɗi a asu u utakuma ili i na yi wa, kpam kotsu i woko na̱ nshinda̱ adama a le wa. ");
INSERT INTO kdl_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Mpa Magono ma Zuba Kashila̱ ka ɗe, u ka̱na̱ ta̱ i woko uwulukpi, kpaci mpa uza u uwulukpi ɗa. Kotsu i woko na̱ nshinda̱ adama a ili iꞌya ya ka̱bura̱ a iyamba wa. ");
INSERT INTO kdl_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Kpaci mpa Magono ma Zuba uza ɗa u wutukpa̱ ɗa̱ a uyamba u Masar tsa̱ra̱ n woko Kashila̱ ka ɗe; adama a nala u ka̱na̱ ta̱ i woko uwulukpi, kpaci mpa uza u uwulukpi ɗa. ");
INSERT INTO kdl_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","<<Mele ma na mi a kaci ka nnama n ɗa ma̱ri a iyamba, na̱ nnu, n ili i uma iꞌya iꞌa̱ri a mini gba̱, n ili i uma iꞌya ya ka̱bura̱ a iyamba gba̱. ");
INSERT INTO kdl_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","U ka̱na̱ ta̱ i takpana n ɗa ma̱ri na̱ nshinda̱ na̱ n ɗa n nambai nshinda̱, n ili i uma iꞌya a ka takuma n iꞌya bawu a ka takuma.>> ");
INSERT INTO kdl_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Magono ma Zuba ma tonukoi Musa, ");
INSERT INTO kdl_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","<<Tonuko aza a Isaraꞌila: Uka yan baci katsuma̱ u matsai maku ma vali, wa woko ta̱ na̱ nshinda̱ hal aꞌayin a shindere, tyoku ɗa u tsu yan aꞌayin a ɗa wa̱ri asuvu a nshinda̱ ma uwoto. ");
INSERT INTO kdl_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Kain ka kulla̱ aku a kiɗa maku mi kacombi. ");
INSERT INTO kdl_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Aku uka vi u doku u yain aꞌayin kamankupa n u tatsu n u takpi nshinda̱ adama a mpasa ma ilimaci mi. A asuvu a aꞌayin a nala yi wa sawa ili i roku iꞌya iꞌa̱ri uwulukpi wa, kpam wa uwa a kuwa ku uwulukpi wa, hal she aꞌayin a ɗa u shaɗangi aꞌayin a uwulukpe a ne. ");
INSERT INTO kdl_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Shegai makere ma baci u matsai, wa woko ta̱ na̱ nshinda̱ hal aꞌayin kupa n u nishi, tyoku ɗa u tsu yan aꞌayin a nshinda̱ ma uwoto. Pini nala, wa doku ta̱ u yain aꞌayin amangatatsu n a teli n u takpi nshinda̱ adama a mpasa ma ilimaci mi. ");
INSERT INTO kdl_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","<<Aꞌayin a uwulukpe a ilimaci i maku ma vali ko maku ma uka a shaɗangi baci, u tuko kaɗara̱kpi macon ma ma yain kayen ka te a utsutsu u Katani ka Ugawunsa, adama a uɗara̱kpa u urunukpa. U tuko dem matambara ko kaɗya adama a uɗara̱kpa u uwulukpe. ");
INSERT INTO kdl_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Kaɗara̱kpi ki ka yan ta̱ uɗara̱kpa vi ubana a asu u Magono ma Zuba adama a upala ukuna u uka vi. Uka vi wa woko ta̱ bawu nshinda̱ a mpasa n ɗa n wotsongi yi vi. Mele ma na mi ma̱ ta̱ a kaci ka uka ɗa u matsai maku ma vali ko maku ma uka. ");
INSERT INTO kdl_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Uka vi wa̱ baci n ucira u maku ma macon mi wa, wa fuɗa ta̱ u tuko mmuku ma ntambara n re ko aꞌaɗya a re, ka te adama a uɗara̱kpa u urunukpa ka te kpam adama a uɗara̱kpa u uwulukpe. Kaɗara̱kpi ki ka yan ta̱ uɗara̱kpa adama a upala ukuna vi tsa̱ra̱ u wulukpe yi kpam wa yan na̱ nshinda̱ wa.>> ");
INSERT INTO kdl_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Magono ma Zuba ma tonukoi Musa n Haruna, ");
INSERT INTO kdl_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","<<Ikyamba i uza i shita baci ko iꞌa̱ri n abuɗu ko kpam iꞌa̱ri n ita̱fulishi hal u woko yi maɓa̱la̱ ma ukpan ma cingi, a banka yi a asu u Haruna kaɗara̱kpi ko kpam a asu u uza u te a asuvu a alobo a kagali ka ne uza ɗa wa̱ri kaɗara̱kpi. ");
INSERT INTO kdl_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Kaɗara̱kpi ki ka takpa ta̱ vuma vi utyoku, u wene baci tsileme tsa tsa̱ri a asu u kutsu ki tsu wa̱ra̱ma̱i kpam kutsu ki ku uwai hal a asuvu a ukpan, maɓa̱la̱ ma ukpan ma cingi ma yi. Pini nala, kaɗara̱kpi ki ka tonuko ama an vuma vi wa̱ri na̱ nshinda̱. ");
INSERT INTO kdl_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Shegai asu u ɗa u ta̱fula̱ yi a ikyamba yi pun ɗa baci wa̱ri, kpam kutsu ki ku uwa baci a asuvu a ukpan wa, kpam tsileme tsu ikyamba tsi tsu wa̱ra̱ma̱ baci wa, kaɗara̱kpi ka wutukpa̱ uza maɓa̱la̱ mi kau hal aꞌayin a shindere. ");
INSERT INTO kdl_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Kain ka shindere ki kaɗara̱kpi ki ka doku ka takpa yi utyoku, asu u ɗa u ta̱fula̱ yi vi wa̱ baci pini tyoku ɗa wa̱ri kpam u lya kapala n utambura a ikyamba wa, kaɗara̱kpi ki ka a̱sa̱ka̱ yi pini kau ne hal aꞌayin a shindere a roku. ");
INSERT INTO kdl_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Kain ka shindere ki kaɗara̱kpi ka doku ka takpa yi utyoku u wene, uta̱fula̱ vi u gita̱ baci uta̱na̱ kpam u lya kapala n utambura a ikyamba wa, aku kaɗara̱kpi ki ka tonuko ama vuma vi wa̱ na̱ nshinda̱ wa, ita̱fulishi iꞌya yi koshi. Pini nala, uza vi u za̱i aminya a ne u woko uza ɗa bawu wa̱ri n icaɗi. ");
INSERT INTO kdl_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Shegai ita̱fulishi yi i tuwa̱ i doku baci i tamburai cina u wenike ɗe kaci ka ne a asu u kaɗara̱kpi, kpam u tonuko yi wa̱ na̱ nshinda̱ wa, u ka̱na̱ ta̱ u doku u gono a asu u kaɗara̱kpi ki. ");
INSERT INTO kdl_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Kaɗara̱kpi ki ka doku ta̱ ka takpa yi utyoku, ita̱fulishi yi i tambura baci a ukpan vi, aku kaɗara̱kpi ki ka tonuko ama an wa̱ri na̱ nshinda̱; maɓa̱la̱ ma ukpan ma cingi ma yi. ");
INSERT INTO kdl_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","<<Maɓa̱la̱ ma ukpan ma cingi ma ka̱na̱ baci uza, a banka yi a asu u kaɗara̱kpi. ");
INSERT INTO kdl_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Kaɗara̱kpi ki ka takpa yi ta̱ utyoku, abuɗu yi a shita baci cika aku a wa̱ra̱ma̱i a zuwai kpam tsileme tsu asu vi tsu wa̱ra̱ma̱i, kpam asu vi u wokoi kutsu, ");
INSERT INTO kdl_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","maɓa̱la̱ ma ukpan ma cingi ma pige ma yi la vi. Kaɗara̱kpi ki ka tonuko ta̱ ama an vuma vi wa̱ri na̱ nshinda̱. Wa wutukpa̱ yi kau wa, kpaci wa̱ ta̱ na̱ nshinda̱. ");
INSERT INTO kdl_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","<<Shegai maɓa̱la̱ mi ma kimba̱ baci ukpan u ikyamba vi gba̱, ili iꞌya i ka̱na̱i a kaci ubana a aꞌene tyoku ɗa kaɗara̱kpi ki ka fuɗa ka wene, ");
INSERT INTO kdl_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","aku kaɗara̱kpi ki ka doku ka takpa yi utyoku mai. Maɓa̱la̱ mi ma kimba̱ baci ikyamba gba̱, kaɗara̱kpi ki ka tonuko ama vuma vi wa̱ na̱ nshinda̱ wa. An u wokoi ikyamba yi gba̱ i wa̱ra̱ma̱i, vuma vi wa̱ na̱ nshinda̱ wa. ");
INSERT INTO kdl_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Shegai kain ka baci dem kutsu ku wuta̱ yi a ikyamba, u woko ɗe la vi uza u nshinda̱. ");
INSERT INTO kdl_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Kaɗara̱kpi ki ka takpa kutsu ki utyoku mai, aku u tonuko ama an vuma vi wa̱ri na̱ nshinda̱. Kutsu ki ili i nshinda̱ iꞌya, kpaci maɓa̱la̱ ma ukpan ma cingi ma. ");
INSERT INTO kdl_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Shegai kutsu ki ku gono baci ka wa̱ra̱ma̱i kpam, she vuma vi u bana a asu u kaɗara̱kpi. ");
INSERT INTO kdl_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Kaɗara̱kpi ki ka takpa yi ta̱ kpam utyoku, mayun ɗa baci maɓa̱la̱ mi ma wa̱ra̱ma̱i, aku kaɗara̱kpi ki ka tonuko ama vuma vi wa̱ na̱ nshinda̱ wa, kpaci a wulukpe yi ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","<<Vuma wa̱ri baci n kamici a ikyamba ka ka ta̱na̱i, ");
INSERT INTO kdl_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","aku a asu u ɗa kamici ki ka̱ri caupa vi u shitai pun, ko kpam asu vi u savaɗai u wokoi san n pun, she u ba u wenike kaɗara̱kpi. ");
INSERT INTO kdl_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Aku kaɗara̱kpi ka takpa asu vi utyoku, maɓa̱la̱ mi ma uwa baci a asuvu a ukpan, kpam tsileme tsu asu vi tsu wa̱ra̱ma̱i, kaɗara̱kpi ki ka tonuko ta̱ ama an vuma vi wa̱ri na̱ nshinda̱. Maɓa̱la̱ ma ukpan ma cingi ma ma wuta̱i a asu u kamici ki. ");
INSERT INTO kdl_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Shegai kaɗara̱kpi ki ka takpa yi baci utyoku, u wene baci tsileme tsu asu u kamici ki tsu wa̱ra̱ma̱ wa, kpam kutsu ki ku uwa a asuvu a ukpan wa, aku ku gita̱i uta̱na̱, kaɗara̱kpi ki ka wutukpa̱ uza u maɓa̱la̱ mi kau n ama hal aꞌayin a shindere. ");
INSERT INTO kdl_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Kamici ki ka tambura baci ko nte wa a ukpan vi, aku kaɗara̱kpi ki ka tonuko ama an vuma vi wa̱ri na̱ nshinda̱. Maɓa̱la̱ ma ukpan ma cingi ma. ");
INSERT INTO kdl_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Shegai kamici ki ka savaɗa baci wa, kpam ka lya kapala n utambura wa, kalani ka kamici ka. Kaɗara̱kpi ki ka tonuko ama vuma vi wa̱ na̱ nshinda̱ wa. ");
INSERT INTO kdl_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","<<Uza u ra̱na baci, aku kutsu ki ku wokoi san n pun ko kpam pun, ");
INSERT INTO kdl_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","she kaɗara̱kpi ka takpa yi utyoku mai. Tsileme tsu asu u ura̱na vi tsu wa̱ra̱ma̱ baci, kpam kutsu ki ku uwai hal a asuvu a ukpan, maɓa̱la̱ ma ukpan ma cingi ma ma wuta̱i pini a asu u ɗa u ra̱nai vi. Kaɗara̱kpi ki ka tonuko ama an vuma vi wa̱ri na̱ nshinda̱; kpaci maken ma̱ la wa, maɓa̱la̱ ma ukpan ma cingi ma yi. ");
INSERT INTO kdl_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Shegai kaɗara̱kpi ki ka takpa baci ka utyoku, u wene baci tsileme tsu asu tsi tsu wa̱ra̱ma̱i wa, kpam kutsu ki ku uwa hal a asuvu a ukpan wa, kpam ku gita̱i uta̱na̱, kaɗara̱kpi ki ka wutukpa̱ yi kau n ama hal aꞌayin a shindere. ");
INSERT INTO kdl_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","A kain ka shindere, kaɗara̱kpi ki ka doku ka takpa yi utyoku, maɓa̱la̱ mi ma tambura baci a ukpan vi, aku kaɗara̱kpi ki ka tonuko ama an wa̱ri na̱ nshinda̱; maɓa̱la̱ ma ukpan ma cingi ma yi. ");
INSERT INTO kdl_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Shegai kutsu ki ku lya baci kapala n utambura a ukpan vi wa, aku ku gita̱i uta̱na̱, ushita u ɗa koshi a asu u ɗa wa̱ri u ra̱nai vi. Kaɗara̱kpi ki ka tonuko ama uza maɓa̱la̱ mi wa̱ na̱ nshinda̱ wa, kpaci kalani ka ura̱na ka yi koshi. ");
INSERT INTO kdl_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","<<Vali ko uka wa̱ baci n kutsu a kaci ko a matsa̱ga̱, ");
INSERT INTO kdl_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","kaɗara̱kpi ki ka takpa yi utyoku, u wene baci kutsu ki ku uwai hal a asuvu a ukpan, kpam tsileme tsa tsa̱ri a asu u kutsu ki tsu woloi tsu wokoi woli-woli n mini ma tsulon; kaɗara̱kpi ki ka tonuko ama an vuma vi wa̱ri na̱ nshinda̱. Kpaci kalyatsuwa ka yi, maɓa̱la̱ ma ukpan ma cingi ma ma kaci ko matsa̱ga̱. ");
INSERT INTO kdl_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Shegai kaɗara̱kpi ki ka takpa baci kalyatsuwa ki utyoku mai, u wene baci ka uwa baci a asuvu a ukpan wa, kpam tsileme tsu da̱n tsa̱ pini a asu u maɓa̱la̱ mi wa, aku kaɗara̱kpi ki ka wutukpa̱ vuma vi kau n ama hal aꞌayin a shindere. ");
INSERT INTO kdl_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","A kain ka shindere, aku kaɗara̱kpi ki ka doku ka takpa kalyatsuwa ki utyoku. Maɓa̱la̱ mi ma tambura baci wa, kpam tsileme tsu mini ma tsulon tsa̱ baci pini wa, kpam dem maɓa̱la̱ mi ma uwa baci a asuvu a ukpan wa, ");
INSERT INTO kdl_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","she u puni kaci ka ne, shegai n a asu u maɓa̱la̱ mi wa. Kaɗara̱kpi ka doku ta̱ ka wutukpa̱ vuma vi kau n ama hal aꞌayin a shindere a roku. ");
INSERT INTO kdl_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","A kain ka shindere ki kaɗara̱kpi ka doku ka takpa kalyatsuwa ki utyoku, ka tambura baci a ukpan wa, kpam ka uwa baci a asuvu a ukpan wa, aku kaɗara̱kpi ki ka tonuko ama an vuma vi bawu wa̱ri na̱ nshinda̱. Pini nala, uza maɓa̱la̱ vi u za̱i aminya a ne u woko bawu icaɗi. ");
INSERT INTO kdl_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Shegai kalyatsuwa ki ka tuwa̱ ka tambura baci a ikyamba, cina tani kaɗara̱kpi ka dana ɗe wa̱ na̱ nshinda̱ wa, ");
INSERT INTO kdl_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","kaɗara̱kpi ki ka doku ka takpa ka utyoku. Ka tambura baci a ukpan vi, kotsu kaɗara̱kpi ki ka zami uwene tsileme tsu mini ma tsulon wa, kpaci vuma vi wa̱ ta̱ na̱ nshinda̱. ");
INSERT INTO kdl_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Shegai kaɗara̱kpi ki ka wene baci kalyatsuwa ki ka ta̱na̱, kpam tsileme tsu da̱n tsa̱ri a uwuta̱ pini, maɓa̱la̱ mi ma ta̱na̱ ɗe la vi, uza maɓa̱la̱ vi wa̱ na̱ nshinda̱ wa. Kaɗara̱kpi ka tonuko ama vuma vi wa̱ na̱ nshinda̱ wa. ");
INSERT INTO kdl_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","<<Vali ko uka wa̱ baci n ikyamba paɗi-paɗi pun, ");
INSERT INTO kdl_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","kaɗara̱kpi ka takpa yi utyoku. Apani yi aꞌa̱ baci kapusuwali, apani a ɗa yi koshi, wa̱ na̱ nshinda̱ wa. ");
INSERT INTO kdl_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","<<Kenji ka vuma ka wolo baci hal kaci ka wokoi n kukpani, vuma vi wa̱ na̱ nshinda̱ wa. ");
INSERT INTO kdl_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Kenji ka kapala ka kaci ka baci ka woloi hal kucen ku ne ku wokoi n kukpani, wa̱ na̱ nshinda̱ wa. ");
INSERT INTO kdl_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Shegai kutsu ka̱ baci pini san n pun a kukpani ki ko kukpani ku kucen ki, maɓa̱la̱ ma ukpan ma cingi ma ma wuta̱i pini a kaci ko kucen ka ka̱ri n kukpani ki. ");
INSERT INTO kdl_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Kaɗara̱kpi ki ka takpa yi utyoku. Ushiti wa̱ baci pini a asu u kutsu ka ka̱ri a kaci ko kucen ku ne ki san n pun, tyoku ɗa maɓa̱la̱ ma ukpan ma cingi ma tsu wuta̱ a ukpan, ");
INSERT INTO kdl_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","maɓa̱la̱ ma ukpan ma cingi ma yi. Wa̱ ta̱ na̱ nshinda̱. U ka̱na̱ ta̱ kaɗara̱kpi ki ka tonuko ama an vuma vi wa̱ri na̱ nshinda̱ adama a kutsu ka ka̱ri a kaci ka ne ki. ");
INSERT INTO kdl_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","<<Uza maɓa̱la̱ vi wa uka ta̱ akashi, u a̱sa̱ka̱ kpam kenji ka ne bawu u za̱ɗa̱i. U pala ajiri a ne n u sala̱si, <Mpa uza u nshinda̱ ɗa! Mpa uza u nshinda̱ ɗa!> ");
INSERT INTO kdl_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Wa woko ta̱ uza u nshinda̱ gba̱ aꞌayin a maɓa̱la̱ yi, kpam wa rongo ta̱ utyoku u ne a uroto u agali. ");
INSERT INTO kdl_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","<<A cina baci aminya a tsileme ko a aminya a linin a pa̱ma̱i, ");
INSERT INTO kdl_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ko upa̱ma̱ vi wa̱ baci a ili iꞌya a cai n tsugbere tsu linin ko n tsileme tsu ncon, ko a ukpan, ko kpam a ili iꞌya a yain n ukpan, maɓa̱la̱ ma cingi ma. ");
INSERT INTO kdl_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","Upa̱ma̱ vi wa̱ baci tyoku u mini ma mete ko kpam san-san a aminya yi ko a ukpan vi ko a ili iꞌya a cai, ko kpam a ili iꞌya a yain n ukpan, maɓa̱la̱ ma cingi ma, kpam u ka̱na̱ ta̱ a wenike kaɗara̱kpi. ");
INSERT INTO kdl_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Kaɗara̱kpi ka takpa upa̱ma̱ vi utyoku mai, pini nala, u wutukpa̱ ili iꞌya iꞌa̱ri n upa̱ma̱ vi kau ubana aꞌayin a shindere. ");
INSERT INTO kdl_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Kain ka shindere ka rawa baci, wa doku ta̱ u takpa upa̱ma̱ vi utyoku. Upa̱ma̱ vi u tambura baci a aminya yi ko a ili iꞌya a cai ko a ukpan, ko kpam gba̱ ili iꞌya baci dem a yain n ukpan, maɓa̱la̱ ma cingi ma; ili yi i woko ta̱ i nshinda̱. ");
INSERT INTO kdl_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","U ka̱na̱ ta̱ kaɗara̱kpi ki ka runukpa aminya yi, ko ili iꞌya a cai n tsileme tsu ncon ko tsugbere tsu linin, ko kpam gba̱ ili iꞌya a yain n ukpan iꞌya maɓa̱la̱ mi ma ka̱na̱i. An u wokoi ili i na yi maɓa̱la̱ ma cingi ma, u ka̱na̱ ta̱ a runukpa iꞌya. ");
INSERT INTO kdl_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Shegai kaɗara̱kpi ki ka takpa baci utyoku mai, u wenei upa̱ma̱ vi u tambura a aminya yi ko a ili iꞌya a cai, ko kpam gba̱ ili iꞌya a yain n ukpan wa, ");
INSERT INTO kdl_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","aku kaɗara̱kpi ki ka zuwa a za̱i ili yi. Pini nala, u doku u wutukpa̱ ili yi kau ubana aꞌayin a shindere a roku. ");
INSERT INTO kdl_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Aku u doku u takpa ili iꞌya a za̱i vi utyoku. Upa̱ma̱ vi u savaɗa baci mini wa, ko an u wokoi u kpa̱ɗa̱i utambura, ili yi iꞌa̱ ta̱ na̱ nshinda̱. A runukpa iꞌya, ko upa̱ma̱ vi wa̱ baci a asuvu ko a kateshe ka ili yi. ");
INSERT INTO kdl_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Shegai kaɗara̱kpi ki ka takpa baci ili yi utyoku, aku u wenei upa̱ma̱ vi u kporo ɗe an a za̱i iꞌya, u kara asu u ɗa upa̱ma̱ vi wa̱ri a aminya yi, ko a ili iꞌya a cai vi, ko kpam gba̱ ili iꞌya a yain n ukpan. ");
INSERT INTO kdl_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Upa̱ma̱ vi u doku baci u wuta̱i a aminya yi ko a ili iꞌya a cai vi, ko kpam gba̱ ili iꞌya a yain n ukpan, maɓa̱la̱ ma utambura ma, u ka̱na̱ ta̱ a runukpa ili yi. ");
INSERT INTO kdl_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Shegai upa̱ma̱ vi u puwa̱n baci gba̱ an a za̱i aminya yi, ko ili iꞌya a cai vi, ko kpam gba̱ ili iꞌya a yain n ukpan, a doku a za̱i iꞌya ya woko ta̱ ili iꞌya iꞌa̱ri na̱ nshinda̱ wa.>> ");
INSERT INTO kdl_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Mele ma na mi a kaci ka upa̱ma̱ u ɗa wa̱ri a aminya a tsileme tsu ncon ko aminya a linin, ko a ɗa a cai ko kpam a ɗa a yain n ukpan, tsa̱ra̱ a reve ko ili yi iꞌa̱ na̱ nshinda̱ ko iꞌa̱ na̱ nshinda̱ wa. ");
INSERT INTO kdl_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Magono ma Zuba ma tonukoi Musa, ");
INSERT INTO kdl_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","<<Mele ma na mi ma̱ ta̱ a kaci ka aza ɗa a ka ciga uwulukpe a mɓa̱la̱ ma ukpan ma cingi: Aza ɗa baci a ta̱na̱i u ka̱na̱ ta̱ a tuko le a asu u kaɗara̱kpi. ");
INSERT INTO kdl_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Kaɗara̱kpi ki ka bana a uroto u agali yi u takpa uza u maɓa̱la̱ mi utyoku. Uza u maɓa̱la̱ vi u ta̱na̱ baci, ");
INSERT INTO kdl_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","kaɗara̱kpi ki ka zuwa a tuko nnu n re ma uma n ɗa bawu ma̱ri na̱ nshinda̱, n katyangi ka maɗanga ma sida, n tsugbere tsu shili, n avuku a kaciluma̱ni adama a uza ɗa a ka wulukpe vi. ");
INSERT INTO kdl_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Kaɗara̱kpi ki ka zuwa a kiɗa manu ma te a magbodo ma cin ma a shaɗangi n mini ma aga̱ta̱ ma shinga. ");
INSERT INTO kdl_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Pini nala, u bidya manu ma ma ma̱ri n uma vi, n macaka ma sida mi n tsugbere tsu shili n avuku a kaciluma̱ni yi, u lyuɓugu pini a asuvu mpasa n manu ma a kiɗai a mini ma aga̱ta̱ ma shinga mi. ");
INSERT INTO kdl_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Aku u vishana̱sa̱ka vuma ɗa a ka wulukpe adama a maɓa̱la̱ ma ukpan ma cingi mi mpasa mi hal kushindere. Pini nala, u tonuko ama yi a wulukpe yi ɗe, aku u a̱sa̱ka̱ manu ma ma̱ri n uma vi ma imkpa. ");
INSERT INTO kdl_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","<<Uza ɗa a ka wulukpe vi u ka̱na̱ ta̱ u za̱i aminya a ne u kuruwa kenji ka ne gba̱ kpam u sumba̱. Wa woko ta̱ uza ɗa u nambai nshinda̱. Pini nala, wa gono ta̱ pini a agali yi, shegai wa dusuku pini a katani ka ne wa hal she aꞌayin a shindere. ");
INSERT INTO kdl_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Kain ka shindere ki ka rawa baci, wa kuruwa ta̱ gba̱ kenji ka ne, n matsa̱ga̱ ma ne, n aga̱la̱ aꞌeshi a ne, n kenji ka ikyamba i ne gba̱. Wa za̱ ta̱ aminya a ne kpam u sumba̱. Aku u woko uza ɗa u nambai nshinda̱. ");
INSERT INTO kdl_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","<<Kain ka kulla̱, wa tuko ta̱ mmuku ma aꞌondom n re n ɗa lyopoi wa, n maku ma macon ma kayen ka te ma ma lyopoi wa, n akundatsu a kuden a teli a kira ku lewu ka a juɗugi n manivi adama a uɗara̱kpa u ilya, na̱ ndele n manivi n tatsu. ");
INSERT INTO kdl_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Kaɗara̱kpi ki ka tuko vuma vi n icanga i nala yi a kapala ka Magono ma Zuba a utsutsu u Katani ka Ugawunsa. ");
INSERT INTO kdl_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Kaɗara̱kpi ki ka bidya maku ma kondom ma te n madele ma manivi mi u yain uɗara̱kpa u utsupa unyushi u cingi, u ra̱ɗugba̱ kpam u ɗa u woko uɗara̱kpa u ura̱ɗugba̱ ubana a asu u Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","U kiɗa macon mi a asu u ɗa a ka kiɗa̱sa nnama ma uɗara̱kpa u uwulukpe n uɗara̱kpa u urunukpa. Tyoku ɗa uɗara̱kpa u uwulukpe wa̱ri u kaɗara̱kpi, nala dem uɗara̱kpa u utsupa unyushi u cingi wa woko u kaɗara̱kpi. Uɗara̱kpa u na vi wa̱ ta̱ uwulukpi cika. ");
INSERT INTO kdl_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Kaɗara̱kpi ki ka kene mpasa ma uɗara̱kpa u utsupa unyushi u cingi vi, u gbara n ɗa a ucoli u kutsuvu ku ulyaki ku uza ɗa a ka wulukpe vi, n majubu ma pige ma kukere ku ulyaki ku ne, n majubu ma pige ma kune ku ulyaki ku ne. ");
INSERT INTO kdl_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Pini nala, kaɗara̱kpi ki ka kene manivi mi a katau ka kukere ku ugula̱ ku ne, ");
INSERT INTO kdl_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","u doɓongusu majubu ma ne ma kukere ku ulyaki pini a manivi ma ma̱ri a katau ka kukere ku ugula̱ ki, u vishana̱sa ma hal kushindere a kapala ka Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Manivi ma ma buwa a katau ka kukere ku ne ki, u doɓongu majubu ma kukere ku ulyaki ku ne, aku u gbara n ɗa a ucoli u kutsuvu ku ulyaki ku uza ɗa a ka wulukpe vi, n majubu ma pige ma kukere ku ulyaki ku ne, n majubu ma pige ma kune ku ulyaki ku ne, a asu u ɗa aꞌa̱ri a gbara̱sai mpasa ma uɗara̱kpa u utsupa unyushi u cingi. ");
INSERT INTO kdl_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Manivi ma ma buwai a katau ka kukere ku kaɗara̱kpi ki, u tsunku vuma vi a kaci. Nala kaɗara̱kpi ka pala ukuna u vuma vi a asu u Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","<<Aku kaɗara̱kpi ki ka yain uɗara̱kpa u uwulukpe tyoku u uɗara̱kpa u upala ukuna adama a vuma ɗa a wulukpei vi an wa̱ri na̱ nshinda̱. Pini nala, kaɗara̱kpi ka kiɗa manama ma uɗara̱kpa u urunukpa. ");
INSERT INTO kdl_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Kaɗara̱kpi ki ka yain uɗara̱kpa u urunukpa n uɗara̱kpa u ilya a zuba u asuɗara̱kpa vi. Tyoku ɗa wa pala̱sa ukuna u vuma u ɗa a wulukpei u ɗa la vi. Vuma vi wa woko nshinda̱ wa. ");
INSERT INTO kdl_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","<<Shegai vuma vi wa̱ baci n ucira u ɗa wa fuɗa wa tuko icanga i na yi wa, u tuko kondom ka te adama a uɗara̱kpa u upala ukuna, a yain uɗara̱kpa u ura̱ɗugba̱ adama a uwulukpe u ne. U tuko dem kakundatsu ka kuden ku te ku kira ku lewu, ka a juɗugi n kunzu ku te asuvu a kunzu ku tatsu ku ma manivi adama a uɗara̱kpa u ilya, n madele ma manivi. ");
INSERT INTO kdl_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","U tuko dem aꞌaɗya a re ko kpam mmuku ma ntambara n re, iꞌya baci dem wa fuɗa wa tuko. Ma te adama a uɗara̱kpa u uwulukpe, ma te kpam adama a uɗara̱kpa u urunukpa. ");
INSERT INTO kdl_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Kain ka kulla̱ vuma vi u tuko le a kapala ka kaɗara̱kpi adama a uwulukpe vi. U tuko le a utsutsu u Katani ka Ugawunsa a asu u Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Kaɗara̱kpi ki ka bidya maku ma kondom ma uɗara̱kpa u utsupa unyushi u cingi kaɓolo n madele ma manivi mi, u ra̱ɗugba̱ iꞌya ubana a asu u Magono ma Zuba u woko uɗara̱kpa u ura̱ɗugba̱. ");
INSERT INTO kdl_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","U kiɗa macon ma uɗara̱kpa u utsupa unyushi u cingi vi, aku u kene mpasa mi u gbara n ɗa a ucoli u kutsuvu ku ulyaki ku uza ɗa a ka wulukpe vi, n majubu ma pige ma kukere ku ulyaki ku ne, n majubu ma pige ma kune ku ulyaki ku ne. ");
INSERT INTO kdl_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Pini nala, kaɗara̱kpi ki ka tsungu manivi mi a katau ka kukere ku ugula̱ ku ne, ");
INSERT INTO kdl_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","u doɓongusu majubu ma ne ma kukere ku ulyaki pini a manivi ma ma̱ri a katau ka kukere ku ugula̱ ki, u vishana̱sa ma kushindere a kapala ka Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Kaɗara̱kpi ki ka gbara̱sa̱ka uza ɗa a ka wulukpe vi manivi ma ma̱ri a katau ka kukere ku ugula̱ ku ne ki, a asu u ɗa a gbara̱sai mpasa ma uɗara̱kpa u utsupa unyushi u cingi, wata, a majubu ma kukere ku ulyaki ku ne, n ucoli u kutsuvu ku ulyaki ku ne, n majubu ma pige ma kukere ku ulyaki ku ne, n majubu ma pige ma kune ku ulyaki ku ne. ");
INSERT INTO kdl_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Manivi ma ma buwai a katau ka kukere ku kaɗara̱kpi ki, u tsunku vuma vi a kaci. Nala kaɗara̱kpi ka pala unyushi u vuma vi a asu u Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Pini nala, kaɗara̱kpi ka ɗara̱kpa aꞌaɗya ko ntambara, iꞌya baci gai dem vuma vi wa fuɗa wa tuko. ");
INSERT INTO kdl_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Ma te adama a uɗara̱kpa u uwulukpe, ma te kpam adama a uɗara̱kpa u urunukpa kaɓolo n uɗara̱kpa u ilya. Tyoku ɗa kaɗara̱kpi ki ka yan uɗara̱kpa u upala ukuna a asu u Magono ma Zuba adama a vuma ɗa a wulukpei vi ɗa la vi. ");
INSERT INTO kdl_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Nala vi mele ma a kaci ka uza ɗa wa̱ri n maɓa̱la̱ ma ukpan ma cingi, uza ɗa wa̱ri n ucira u ɗa wa tuko ucanga u uɗara̱kpa adama a uwulukpe u ne tyoku ɗa a ka ciga wa.>> ");
INSERT INTO kdl_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Magono ma Zuba ma tonukoi Musa n Haruna, ");
INSERT INTO kdl_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","<<Aꞌayin a ɗa baci i uwai a uyamba u Kaꞌana u ɗa ma na̱ka̱ ɗa̱ u woko uyamba u ɗe, mele ma ya tono ma na n zuwa baci upa̱ma̱ u wuta̱i a kuwa ku roku a uyamba vi. ");
INSERT INTO kdl_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Gba̱ uza ɗa baci dem wa̱ri n kuwa ki u ka̱na̱ ta̱ u tuwa̱ u tonuko kaɗara̱kpi, u dana, <N wene ta̱ ili i roku yavu upa̱ma̱ a kuwa ku va̱.> ");
INSERT INTO kdl_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Pini nala, kaɗara̱kpi ki ka zuwa ta̱ a wutukpusa̱ ucanga u kuwa vi gba̱ a ulanga kahu u uwa a kuwa ki u takpa upa̱ma̱ vi utyoku, tsa̱ra̱ gba̱ ili i kuwa yi i woko na̱ nshinda̱ wa. ");
INSERT INTO kdl_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Aku kaɗara̱kpi ka uwa pini u takpa utyoku u upa̱ma̱ u ɗa wa̱ri a kasaga ki, wa̱ baci tyoku u mini ma mete ko kpam san-san n paɗi-paɗi, kpam upa̱ma̱ vi u uwa baci a asuvu a kasaga ki, ");
INSERT INTO kdl_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","aku u wuta̱ pini u gbagirya kuwa ki hal aꞌayin a shindere. ");
INSERT INTO kdl_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","U ka̱na̱ ta̱ kaɗara̱kpi ki ka gono kain ka shindere u takpa kuwa ki utyoku. Upa̱ma̱ vi u tambura baci a asaga yi, ");
INSERT INTO kdl_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","aku kaɗara̱kpi ki ka zuwa a takpusa atali a ɗa aꞌa̱ri n upa̱ma̱ vi a vuta̱la̱sa̱ a ɗa a asu u nshinda̱ a uroto u ilyuci. ");
INSERT INTO kdl_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Pini nala, u zuwa kpam a saɗara gba̱ asaga a asuvu a kuwa ki, aku cin tsa a saɗarai vi a pura̱ tsa a ba a wotsongu a uroto u ilyuci a asu u ɗa wa̱ri na̱ nshinda̱. ");
INSERT INTO kdl_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Pini nala, u zami atali a roku a ukusa a ɗa a asu u ɗa a takpusai a niɗe yi, aku kpam a reku cin tsu savu a gunuwan asaga a kuwa yi. ");
INSERT INTO kdl_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","<<Upa̱ma̱ vi u doki baci u wuta̱i pini a kuwa ki kpam, cina u takpusa ɗe atali yi kpam a saɗara̱sai kuwa ki a lapulai a gunuwain ka, ");
INSERT INTO kdl_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","kaɗara̱kpi ki ka tuwa̱ ka takpa u ɗa utyoku. Upa̱ma̱ vi u tambura baci a kuwa ki, maɓa̱la̱ ma cingi ma. Kuwa ki ka̱ ta̱ na̱ nshinda̱. ");
INSERT INTO kdl_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","She a wa̱sa̱ kuwa ki, n atali yi na̱ nɗanga mi gba̱ n ili iꞌya a gunuwunkai kuwa ki, aku a wutukpa̱ iꞌya a uroto u ilyuci ubana a asu u nshinda̱. ");
INSERT INTO kdl_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Uza ɗa baci dem u uwai a kuwa ki a asuvu a aꞌayin a ɗa kaɗara̱kpi ki ka zuwai a gbagiryai ka, wa woko ta̱ uza u nshinda̱ ubana kuvuli. ");
INSERT INTO kdl_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Uza ɗa baci dem u lavutai ko u lyai ilikulya pini a kuwa ki u ka̱na̱ ta̱ u za̱i aminya a ne. ");
INSERT INTO kdl_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","<<Shegai kaɗara̱kpi ki ka tuwa̱ baci ka takpai kuwa ki utyoku, kpam upa̱ma̱ vi u doku u wuta̱ u tambura pini a kuwa ki wa, aꞌayin a ɗa a gunuwain ka vi, u tonuko ama, kuwa ki ka̱ na̱ nshinda̱ wa, kpaci upa̱ma̱ vi u buwa kpam wa. ");
INSERT INTO kdl_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Kaɗara̱kpi ki ka bidya ta̱ nnu n re, n macaka ma maɗanga ma sida, n tsugbere tsu shili, n avuku a kaciluma̱ni tsa̱ra̱ u utakpa nshinda̱ n kuwa ki. ");
INSERT INTO kdl_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Wa kiɗa ta̱ manu ma te a asuvu a n re mi a zuba u magbodo ma cin ma a shaɗangi n mini ma aga̱ta̱ ma shinga. ");
INSERT INTO kdl_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Pini nala, u bidya macaka ma sida mi, n avuku a kaciluma̱ni yi, n tsugbere tsu shili tsi, n manu ma te ma ma̱ri n uma vi u lyuɓugu pini a mpasa n manu ma a kiɗai a zuba u mini mi, aku u vishana̱sa a kuwa ki hal kushindere. ");
INSERT INTO kdl_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Nala wa takpa nshinda̱ n kuwa ki na̱ mpasa n manu mi, n mini ma aga̱ta̱ ma shinga mi, n manu ma uma, n maɗanga ma sida, n avuku a kaciluma̱ni, n tsugbere tsu shili. ");
INSERT INTO kdl_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Aku u a̱sa̱ka̱ manu ma uma mi ma laza ubana a mete a uroto u ilyuci. Tyoku ɗa wa shaɗangu mele ma utakpa u unyushi u cingi u ɗa la vi, kpam a takpa ɗe la vi nshinda̱ n kuwa mi. ");
INSERT INTO kdl_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","<<Mele ma na mi a kaci ka maɓa̱la̱ ma cingi ma ukpan u ikyamba icun kau-kau ma n maɓa̱la̱ ma kalyatsuwa, ");
INSERT INTO kdl_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","n upa̱ma̱ a matogo n aꞌuwa, ");
INSERT INTO kdl_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","n ushita n abuɗu n ita̱fulishi, ");
INSERT INTO kdl_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","tsa̱ra̱ a reve ko ili iꞌa̱ na̱ nshinda̱ ko iꞌa̱ n iꞌya wa.>> ");
INSERT INTO kdl_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Magono ma Zuba ma tonukoi Musa n Haruna, ");
INSERT INTO kdl_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","<<Tonuko aza a Isaraꞌila vu dana: Vali ɗa baci dem wa̱ri na̱ ncana, ncana mi ma zuwa yi ta̱ u woko na̱ nshinda̱. ");
INSERT INTO kdl_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Mele ma nshinda̱ ma ne ma na adama a ncana n ne: Ko tsalali tsi tsu buwa baci ula̱la̱ ko kpam tsu a̱sa̱ka̱i ula̱la̱, vuma vi wa̱ ta̱ na̱ nshinda̱. ");
INSERT INTO kdl_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","<<Ivamkpatsu iꞌya baci dem vuma vi u vakunki ya woko ta̱ na̱ nshinda̱. Kpam dem gba̱ ili iꞌya u dusunki ya woko ta̱ dem na̱ nshinda̱. ");
INSERT INTO kdl_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Uza ɗa baci dem u sawai ivamkpatsu i ne u ka̱na̱ ta̱ u za̱i aminya a ne aku u sumba̱, kpam wa rongo ta̱ na̱ nshinda̱ ubana kuvuli. ");
INSERT INTO kdl_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Nala dem uza ɗa baci u dusuki a ili i ndishi iꞌya vuma vi u dusunki, u ka̱na̱ ta̱ u za̱i aminya a ne aku u sumba̱, kpam wa rongo ta̱ na̱ nshinda̱ ubana kuvuli. ");
INSERT INTO kdl_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","<<Uza ɗa baci dem u sawai vuma vi u ka̱na̱ ta̱ u za̱i aminya a ne aku kpam u sumba̱, kpam wa rongo ta̱ na̱ nshinda̱ ubana kuvuli. ");
INSERT INTO kdl_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","<<Vuma vi cikpunka̱ baci uza ɗa bawu wa̱ri na̱ nshinda̱ ata̱tsa̱, u ka̱na̱ ta̱ u za̱i aminya a ne aku u sumba̱, kpam wa rongo ta̱ na̱ nshinda̱ ubana kuvuli. ");
INSERT INTO kdl_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","<<Ugalu u ɗa baci dem vuma u yuwa̱i u dusunki, wa woko ta̱ na̱ nshinda̱. ");
INSERT INTO kdl_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Uza ɗa baci dem u sawai ili iꞌya vuma vi u dusunki, wa rongo ta̱ na̱ nshinda̱ ubana kuvuli. Uza ɗa kpam dem u cangai ili iꞌya vuma vi u sawai ko u dusunki, u ka̱na̱ ta̱ u za̱i aminya a ne aku u sumba̱, kpam wa rongo ta̱ na̱ nshinda̱ ubana kuvuli. ");
INSERT INTO kdl_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","<<Uza ɗa baci dem uza u ncana mi u sawai kahu u za̱i akere a ne, u ka̱na̱ ta̱ u za̱i aminya a ne aku u sumba̱, kpam wa rongo ta̱ na̱ nshinda̱ ubana kuvuli. ");
INSERT INTO kdl_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","<<Magbodo ma cin ma baci uza u ncana vi u sawai a ka ta̱sa̱ ta̱ ma, shegai gba̱ icanga i manyan iꞌya a shei a maɗanga iꞌya baci vuma vi u sawai, a za̱i iꞌya. ");
INSERT INTO kdl_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","<<Aꞌayin a ɗa baci uza u ncana vi u ta̱na̱i, u keci aꞌayin a shindere adama a utakpa u nshinda̱ n ne. U ka̱na̱ ta̱ u za̱i aminya a ne aku u sumba̱ n mini ma aga̱ta̱ ma shinga, pini nala, wa woko ta̱ uza ɗa a wulukpei. ");
INSERT INTO kdl_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Kain ka kulla̱, u tuko aꞌaɗya a re ko mmuku ma ntambara n re a asu u Magono ma Zuba a utsutsu u Katani ka Ugawunsa, aku u na̱ka̱ kaɗara̱kpi. ");
INSERT INTO kdl_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Kaɗara̱kpi ki ka yain uɗara̱kpa n ma te adama a uɗara̱kpa u uwulukpe, ma te kpam adama a uɗara̱kpa u urunukpa. Kaɗara̱kpi ki ka yan ta̱ uɗara̱kpa u upala ukuna u ne a kapala ka Magono ma Zuba adama a ncana n ne. ");
INSERT INTO kdl_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","<<Mini ma tsalali ma la̱la̱ baci uza a ikyamba, u ka̱na̱ ta̱ u sumba̱, kpam wa rongo ta̱ na̱ nshinda̱ ubana kuvuli. ");
INSERT INTO kdl_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Gba̱ kunya ko kpam ukpan u ɗa baci dem mini ma tsalali tsi ma sawai, u ka̱na̱ ta̱ a za̱i ka, kpam ka rongo ta̱ na̱ nshinda̱ ubana kuvuli. ");
INSERT INTO kdl_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","<<Vali vaku baci n uka hal mini ma tsalali ma wuta̱i, u ka̱na̱ ta̱ gba̱ le a sumba̱, kpam a ka rongo ta̱ na̱ nshinda̱ ubana kuvuli. ");
INSERT INTO kdl_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","<<Uka wene baci nshinda̱ ma uwoto, wa rongo ta̱ na̱ nshinda̱ hal aꞌayin a shindere, kpam gba̱ uza ɗa baci dem u sawa yi wa rongo ta̱ na̱ nshinda̱ ubana kuvuli. ");
INSERT INTO kdl_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","<<Ili iꞌya baci dem uka vi u vakunki ko kpam u dusunki aꞌayin a ɗa wa̱ri a nshinda̱ ma uwoto mi, ya rongo ta̱ na̱ nshinda̱. ");
INSERT INTO kdl_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Uza ɗa dem u sawai ivamkpatsu i ne, u ka̱na̱ ta̱ u za̱i aminya a ne kpam u sumba̱, kpam wa rongo ta̱ na̱ nshinda̱ ubana kuvuli. ");
INSERT INTO kdl_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Uza ɗa baci dem u sawai ili iꞌya u dusunki, u ka̱na̱ ta̱ u za̱i aminya a ne kpam u sumba̱, kpam wa rongo ta̱ na̱ nshinda̱ ubana kuvuli. ");
INSERT INTO kdl_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Ili iꞌa̱ baci pini a zuba u ivamkpatsu yi ko kpam ili iꞌya u dusunki vi, aꞌayin a ɗa baci uza roku u sawai iꞌya wa rongo ta̱ na̱ nshinda̱ ubana kuvuli. ");
INSERT INTO kdl_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Vali vaku baci n eyi aꞌayin a ɗa wa̱ri na̱ nshinda̱ ma uwoto mi hal mpasa mi n sawa yi, wa rongo ta̱ na̱ nshinda̱ hal aꞌayin a shindere. Gba̱ ivamkpatsu iꞌya baci u vakunki ya woko ta̱ dem na̱ nshinda̱. ");
INSERT INTO kdl_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","<<Uka wa la̱la̱ baci mpasa aꞌayin ushani, bamu n aꞌayin a uwene nshinda̱ ma uwoto n ne, ko kpam uwene u nshinda̱ mi n wura baci aꞌayin, wa rongo ta̱ na̱ nshinda̱ aꞌayin a ɗa wa la̱la̱ vi dere tyoku ɗa u tsu yan wa̱ baci a asuvu a nshinda̱ ma uwoto n ne. ");
INSERT INTO kdl_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Ivamkpatsu iꞌya baci dem u vakunki ko kpam ili iꞌya baci dem u dusunki a aꞌayin yi, ya rongo ta̱ na̱ nshinda̱ dere tyoku u aꞌayin a uwene nshinda̱ ma uwoto n ne. ");
INSERT INTO kdl_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Uza ɗa baci dem u sawai ili i nala yi wa woko ta̱ na̱ nshinda̱. U ka̱na̱ ta̱ u za̱i aminya a ne kpam u sumba̱, kpam wa rongo ta̱ na̱ nshinda̱ ubana kuvuli. ");
INSERT INTO kdl_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","<<Aꞌayin a ɗa baci ula̱la̱ vi u kotsoi, u keci aꞌayin a shindere, nala wura baci, wa woko ta̱ uza ɗa a wulukpei. ");
INSERT INTO kdl_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Kain ka kulla̱, u tuko kaɗara̱kpi aꞌaɗya a re ko kpam mmuku ma ntambara n re a utsutsu u Katani ka Ugawunsa. ");
INSERT INTO kdl_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Aku kaɗara̱kpi ki ka yain uɗara̱kpa n ma te adama a uɗara̱kpa u uwulukpe, ma te kpam adama a uɗara̱kpa u urunukpa. Kaɗara̱kpi ki ka yan ta̱ upala ukuna u ne a kapala ka Magono ma Zuba adama a nshinda̱ ma ula̱la̱ u ne. ");
INSERT INTO kdl_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","<<Tyoku ɗa ya takpa mu aza a Isaraꞌila kau ɗa la vi a asuvu a nshinda̱ n le, tsa̱ra̱ a kuwa̱ adama a nshinda̱ n le a asu u unangasa mu Katani ka Kavasu ka ka̱ri a mere ma le wa. ");
INSERT INTO kdl_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Nala vi mele ma a kaci ka uza ɗa tsalali tsu ne tsa la̱la̱ n uza ɗa wa̱ri na̱ nshinda̱ adama a ula̱la̱ u mini ma tsalali. ");
INSERT INTO kdl_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Nala dem uka u ɗa wa wene nshinda̱ ma uwoto, n vali ko uka ɗa wa la̱la̱, kpam dem n vali ɗa vaki n uka ɗa wa̱ri na̱ nshinda̱ ma uwoto.>> ");
INSERT INTO kdl_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Magono ma Zuba ma dansai n Musa cina alobo a Haruna a re a kuwa̱ ɗe, aza ɗa a tuwa̱i a kapala ka Magono ma Zuba a nekei akina a ɗa bawu aꞌa̱ri uwulukpi ucun u ɗa bawu u tonuko le a yain. ");
INSERT INTO kdl_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","U danai, <<Tonuko utoku u vunu Haruna kotsu u uwa Asu u ɗa u Lakai Uwulukpi a kucina̱ ku kunya ku uba̱ra̱kpa̱ kavama wa, kpaci nte n tsu wenike pini kaci ka va̱ a asuvu a kalishi a zuba u kakimba̱tsu ka utakpa unyushi u cingi, wata, a asu u utakpa u unyushi u cingi. U ꞌyuwan baci upana urono u atsuvu u na vi, wa kuwa̱ ta̱. ");
INSERT INTO kdl_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","<<Shegai tyoku ɗa Haruna wa uwa a Asu u ɗa u Lakai Uwulukpi vi u ɗa na: u tuko ve kagono ka kanaka adama a uɗara̱kpa u uwulukpe n kondom adama a uɗara̱kpa u urunukpa. ");
INSERT INTO kdl_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Kahu u uwa pini, u ka̱na̱ ta̱ u sumba̱ ve aku u uka ntogo ma uwulukpi n ne n aminya a linin, wata, matogo ma kenu n magbidi ma ucaku n kagbawatsu n funi. ");
INSERT INTO kdl_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Gba̱ kaɓolo ka aza a Isaraꞌila a ka na̱ka̱ ta̱ Haruna vi nga̱ji n re adama a uɗara̱kpa u uwulukpe n kondom adama a uɗara̱kpa u urunukpa. ");
INSERT INTO kdl_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","<<Haruna vi wa ɗara̱kpa ta̱ kagono ka kanaka ki adama a uɗara̱kpa u uwulukpe u kaci u ne, aku kpam u takpa unyushi u cingi u ne n u aza a kuwa a ne. ");
INSERT INTO kdl_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","U bidya kpam nga̱ji n re n nala mi u tuko n ɗa a kapala ka Magono ma Zuba a utsutsu u Katani ka Ugawunsa. ");
INSERT INTO kdl_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","U varanku nga̱ji n re mi uruta̱, ma te adama a Magono ma Zuba, ma te kpam adama a Azazel. ");
INSERT INTO kdl_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Ma baci uruta̱ u rukpa̱i a kaci ka ne adama a Magono ma Zuba, she u tuko ma a kapala ka Magono ma Zuba u yain uɗara̱kpa u uwulukpe n ma. ");
INSERT INTO kdl_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Shegai ma uruta̱ u rukpa̱i a kaci ka ne adama a Azazel vi, a ka tuko ta̱ ma n uma a kapala ka Magono ma Zuba, tsa̱ra̱ a yanka ma manyan adama a utakpa u unyushi u cingi a tutsuku ma ubana a Azazel a kakamba. ");
INSERT INTO kdl_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","<<Haruna kpam wa tuko ta̱ kagono ka kanaka a kapala ka va̱ ka woko yi uɗara̱kpa u uwulukpe u ne n utakpa u unyushi u cingi u ne n u aza a kuwa a ne; pini nala, u kiɗa kanaka ki adama a uɗara̱kpa u uwulukpe u ne. ");
INSERT INTO kdl_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Wa bidya ta̱ ipuruka̱tsu i akina i urunukpa ili i magula̱ni ushaɗangi n tsikina a asuɗara̱kpa u ɗa wa̱ri a kapala ka Magono ma Zuba. U shaɗangu kpam akere a re a ne n maluɓa̱ ma ili i magula̱ni, aku u banka iꞌya a kucina̱ ku kunya ku uba̱ra̱kpa̱ ki. ");
INSERT INTO kdl_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Aku u tsungu ili i magula̱ni yi pini a akina a kapala ka Magono ma Zuba, tsa̱ra̱ ka̱nga̱ ka ili i magula̱ni yi ka kimba̱ kakimba̱tsu ka utakpa u unyushi u cingi ka Akpati u Kazuwamgbani ki, tsa̱ra̱ u kuwa̱ wa. ");
INSERT INTO kdl_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Aku u kene mpasa n kagono ka kanaka ki u vishana̱sa n ɗa n majubu ma ne a kapala ka kakimba̱tsu ka utakpa unyushi u cingi vi a kapashi ka kasana. Wa vishana̱sa ta̱ mpasa mi a kapala ka kakimba̱tsu ki n majubu ma ne hal kushindere. ");
INSERT INTO kdl_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","<<Pini nala, u kiɗa malala ma uɗara̱kpa u uwulukpe adama a ama yi, u tuko mpasa mi a kucina̱ ku kunya ku uba̱ra̱kpa̱ ki. Wa yanka ta̱ dem n ɗa tyoku ɗa u yankai mpasa n kagono ka kanaka mi, wata, wa vishana̱sa ta̱ n ɗa a zuba u kakimba̱tsu ka utakpa unyushi u cingi ki n a kapala ka kakimba̱tsu ki dem. ");
INSERT INTO kdl_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Tyoku ɗa wa yan ɗa la vi u takpa unyushi u cingi u Asu u ɗa u Lakai Uwulukpi vi adama a nshinda̱ n uꞌya̱nga̱sa̱ka̱ n unyushi u cingi u aza a Isaraꞌila gba̱. Nala dem wa yanka Katani ka Ugawunsa ka ka̱ri pini a mere ma ili i nshinda̱ i le. ");
INSERT INTO kdl_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Uza wa̱ la wa uwa a Katani ka Ugawunsa ki aꞌayin a ɗa Haruna vi wa uwa pini a Asu u ɗa u Lakai Uwulukpi adama a utakpa u unyushi u cingi u kaci ka ne n aza a kuwa a ne gba̱ n kakuma̱ ka aza a Isaraꞌila vi gba̱ wa, ubana aꞌayin a ɗa wa wuta̱. ");
INSERT INTO kdl_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Pini nala, Haruna vi wa wuta̱ ta̱ u bana a asuɗara̱kpa u ɗa wa̱ri a kapala ka Magono ma Zuba vi u yanka u ɗa uɗara̱kpa u utakpa u unyushi u cingi. Aku u doɓo mpasa n kanaka ki na̱ mpasa n maga̱ji mi u gbara n ɗa a avana a asuɗara̱kpa vi. ");
INSERT INTO kdl_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","U vishana̱sa mpasa mi n majubu ma ne hal kushindere a zuba u asuɗara̱kpa vi. Tyoku ɗa wa takpa nshinda̱ n asuɗara̱kpa u ɗa gai la vi adama a ili i nshinda̱ i aza a Isaraꞌila, kpam u neke iꞌya n uwulukpi ubana a asu u Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","<<Aꞌayin a ɗa baci u kotsoi utakpa u unyushi u cingi u Asu u ɗa u Lakai Uwulukpi n Katani ka Ugawunsa n asuɗara̱kpa vi, aku u tuko maga̱ji ma ma̱ri n uma vi a kapala ka Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","U taɗangu akere a re a ne a kaci ka maga̱ji mi, aku u dansa gba̱ tsicingi tsu aza a Isaraꞌila, n uꞌya̱nga̱sa̱ka̱ u le gba̱, n unyushi u cingi u le gba̱. Nala wa tsunku maga̱ji mi unyushi u cingi u aza a Isaraꞌila. Pini nala, u na̱ka̱ uza u ɗa a ɗanga̱sai u loki maga̱ji mi u tutsuku ma ubana a kakamba. ");
INSERT INTO kdl_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Maga̱ji mi ma canga ta̱ gba̱ unyushi u cingi vi a kaci ka ne ubana a kakamba ka bawu uza wa̱ri; vuma vi wa a̱sa̱ka̱ ta̱ ma ma laza ubana a kakamba. ");
INSERT INTO kdl_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","<<Aku Haruna vi u gono pini a Katani ki u mondo aminya a linin a ɗa u ukai an u uwai a Asu u ɗa u Lakai Uwulukpi vi, aku u a̱sa̱ka̱ a ɗa pini. ");
INSERT INTO kdl_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","U sumba̱ kaci ka ne pini a ulanga u asu u uwulukpi vi, aku u gono u uka aminya a roku a ne a tsuɗara̱kpi. Pini nala, u ba u yain uɗara̱kpa u urunukpa adama a kaci ka ne n uɗara̱kpa u urunukpa adama a ama, n utakpa u unyushi u cingi adama a kaci ka ne n ama. ");
INSERT INTO kdl_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","U runukpa manivi ma nnama ma uɗara̱kpa u uwulukpe vi a asuɗara̱kpa. ");
INSERT INTO kdl_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","<<Uza ɗa a̱sa̱ka̱i maga̱ji ubana a kakamba ka Azazel ki, u ka̱na̱ ta̱ u za̱i aminya a ne kpam u sumba̱. Pini nala, wa fuɗa ta̱ u gono u uwa a asu u ɗa a shigba̱i agali yi. ");
INSERT INTO kdl_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Kagono ka kanaka ki n maga̱ji ma uɗara̱kpusa u uwulukpe, ma a tukoi mpasa n le a Asu u ɗa u Lakai Uwulukpi a yankai uɗara̱kpa u utakpa u unyushi u cingi vi, a ka banka le ta̱ a uroto u agali a runukpa ukpan u le n inyama i le n icanga i katsuma̱ i le n awuyen yi dem. ");
INSERT INTO kdl_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Uza ɗa u runukpai iꞌya vi, she u za̱ ve aminya a ne aku kpam u sumba̱. Pini nala, wa fuɗa ta̱ u gono a asu u ɗa a shigba̱i agali yi. ");
INSERT INTO kdl_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","<<Mele ma na mi ma yan ta̱ pini ara ɗe ubana: Kain ka kupa dem ka uwoto u shindere, ya yan ta̱ kakuli, ya yan manyan wa ko kenu, ko uza u iyamba u ɗa baci tani ko kpam kamoci ka ka̱ri ndishi a asuvu a ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Kain ka nala ki, kaɗara̱kpi ka yan ta̱ uɗara̱kpa u utakpa u unyushi u cingi u ɗe gba̱, tsa̱ra̱ a takpa nshinda̱ n ɗe a kapala ka Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Kain ka nala ki ka woko ɗa̱ ta̱ kain ka Ashibi ka wunvugusa gba̱, u ka̱na̱ ta̱ i yain kakuli. Mele ma na mi ma yan ta̱ pini ara ɗe ubana. ");
INSERT INTO kdl_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Kaɗara̱kpi ka a tsunki manivi ma uneke adama a manyan tsa̱ra̱ u lyai agadu a tata u ne u woko Magono ma Aɗara̱kpi, aya wa yan uɗara̱kpa u utakpa u unyushi u cingi. Aya wa uka aminya a linin, aminya a ɗa aꞌa̱ri uwulukpi, ");
INSERT INTO kdl_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","u yain kpam uɗara̱kpa u utakpa u unyushi u cingi u Asu u ɗa u Lakai Uwulukpi n Katani ka Ugawunsa n asuɗara̱kpa. Wa yanka ta̱ dem aɗara̱kpi n gba̱ kakuma̱ ka aza a Isaraꞌila. ");
INSERT INTO kdl_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","<<Mele ma na mi ma yan ta̱ pini ara ɗe ubana. Uɗara̱kpa u utakpa u unyushi u cingi a ka yansa ta̱ u ɗa kayen dem kuten adama a gba̱ unyushi u cingi u aza a Isaraꞌila.>> Musa yan ta̱ ko ndya wa derere tyoku ɗa Magono ma Zuba ma tonuko yi. ");
INSERT INTO kdl_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Aku Magono ma Zuba ma tonukoi Musa, ");
INSERT INTO kdl_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","<<Tonuko Haruna n alobo a ne n aza a Isaraꞌila gba̱ ili iꞌya Magono ma Zuba ma tonuko le iꞌya naha: ");
INSERT INTO kdl_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Uza ɗa baci dem asuvu a kuwa ku aza a Isaraꞌila u kiɗai kanaka ko macon ko malala asuvu a asu u ɗa a shigba̱i agali ko kpam a uroto u agali vi, ");
INSERT INTO kdl_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","bawu u tukoi ma kune a utsutsu u Katani ka Ugawunsa a kapala ka Katani ka Kavasu ka Magono ma Zuba, vuma nala vi a ka ka̱na̱ yi ta̱ n unyushi u uwotsongu mpasa. U ka̱na̱ ta̱ a peci yi n ama a ne. ");
INSERT INTO kdl_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Kalen ka mele ma nala mi ma, kotsu aza a Isaraꞌila a a̱sa̱ka̱ uɗara̱kpusa kaberikete a asu vi. U ka̱na̱ ta̱ a tuko Magono ma Zuba kune ku le a asu u kaɗara̱kpi a utsutsu u Katani ka Ugawunsa, aku u yanka n ɗa uɗara̱kpa u ndishi n shinga ubana a asu u Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Kaɗara̱kpi ka vishana̱sa ta̱ mpasa mi a asuɗara̱kpa u Magono ma Zuba a utsutsu u Katani ka Ugawunsa, aku u runukpa manivi mi, ma woko ili i magula̱ni ma shinga ubana a asu u Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","A ka doku a ka banka uɗara̱kpa u le a asu u ityonshi iꞌya iꞌa̱ri yavu nlala wa, n ɗa a tsu yansa̱ka tsishankala. Mele ma na mi ma yan ta̱ pini a uyan u le ushani ubana. ");
INSERT INTO kdl_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","<<Vu tonuko le kpam: Gba̱ uza ɗa dem wa̱ri uza u kuwa ku aza a Isaraꞌila, ko kamoci ka ka̱ri ndishi a asuvu a le, uza ɗa u yain uɗara̱kpa u urunukpa ko uɗara̱kpa u roku ");
INSERT INTO kdl_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","aku u kpa̱ɗa̱i utuko ma a utsutsu u Katani ka Ugawunsa kotsu u yain uɗara̱kpa u ne a asu u Magono ma Zuba, a ka pece yi ta̱ n ama a ne. ");
INSERT INTO kdl_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","<<Gba̱ uza ɗa dem wa̱ri uza u kuwa ku aza a Isaraꞌila, ko kamoci ka ka̱ri ndishi a asuvu a le, uza ɗa u takumai inyama iꞌya iꞌa̱ri na̱ mpasa, mpa Magono ma Zuba ma yan ta̱ tsilala n vuma u nala vi n peci yi n ama a ne. ");
INSERT INTO kdl_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Uma u ili i uma dem, wa̱ ta̱ a mpasa, ɗa i zuwai mpa Magono ma Zuba n na̱ka̱ ɗa̱ mpasa n woko ili i utakpa u unyushi u cingi a asuɗara̱kpa adama a uma u ɗe. Kpaci mpasa uma u ɗa, adama nala mpasa n ɗa ma takpa unyushi u cingi. ");
INSERT INTO kdl_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Adama nala ɗa n tonukoi aza a Isaraꞌila: <Ko uza a asuvu a ɗe kotsu u takuma inyama iꞌya iꞌa̱ri na̱ mpasa wa, nala dem amoci a ɗa aꞌa̱ri a ɗe.> ");
INSERT INTO kdl_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","<<Gba̱ uza u Samaꞌila ko kamoci ka ka̱ri a asuvu a le, uza ɗa banai tsutofi aku u wunai manama, ko manu ma a tsu takuma, u ka̱na̱ ta̱ u kiɗa ili iꞌya u wunai vi u wotsongu mpasa mi aku u pala n kayala. ");
INSERT INTO kdl_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Uma u ili i uma dem, wa̱ ta̱ a mpasa, ɗa i zuwai n tonukoi aza a Isaraꞌila kotsu a takuma inyama i ili u uma na̱ mpasa wa, kpaci uma u ili i uma dem wa̱ ta̱ asuvu a mpasa. Gba̱ uza ɗa takumai inyama iꞌya iꞌa̱ri na̱ mpasa, a ka pece yi ta̱ n ama a ne. ");
INSERT INTO kdl_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","<<Gba̱ uza u iyamba ko kamoci uza ɗa baci takumai manama ma ma kuwa̱i agifa, ko ma manama ma mete ma wunai, u ka̱na̱ ta̱ u za̱i aminya a ne kpam u sumba̱. Gba̱ n nala wa rongo ta̱ pini na̱ nshinda̱ ubana kuvuli kahu a wulukpe yi. ");
INSERT INTO kdl_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Shegai u za̱ baci aminya ne wa, ko kpam bawu u sumba̱i, unyushi u ne wa̱ ta̱ a kaci ka ne.>> ");
INSERT INTO kdl_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Magono ma Zuba ma tonukoi Musa, ");
INSERT INTO kdl_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","<<Tonuko aza a Isaraꞌila: Mpa Magono ma Zuba Kashila̱ ka ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Kotsu i yansa tyoku ɗa aza a uyamba u Masar a asu u ɗa i dusuki a yansai wa, ko kpam tyoku u aza a uyamba u Kaꞌana a asu u ɗa ma ciga n banka ɗa̱; kotsu i yansa ili iꞌya a ka yansa wa. ");
INSERT INTO kdl_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Gorimukoi udani u va̱, i kirana kpam n mele ma va̱ i wala n ma mai. Mpa Magono ma Zuba Kashila̱ ka ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","U ka̱na̱ ta̱ i kirana n mele ma va̱ n udani u va̱. Gba̱ uza ɗa baci dem u gorimukoi ma, wa yan ta̱ uma. Mpa Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","<<Kotsu vu vaku n vali ko uka ɗa wa̱ri kumaci ku vunu wa. Mpa Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Kotsu vu nei tata u vunu uwono vu vaku na̱ mma u vunu wa; eyi mma u vunu ɗa, kotsu vu vaku n eyi wa. ");
INSERT INTO kdl_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Kotsu vu vaku n uka tata u vunu wa, eyi uka tata u vunu ɗa. ");
INSERT INTO kdl_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Kotsu vu vaku n utaku u vunu wa, ko kpam maku ma tata u vunu ko maku ma mma u vunu, ko a kuwa ku te ka baci a matsa ɗa̱ ko kpam asu u roku kau. ");
INSERT INTO kdl_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Kotsu vu vaku n matsukaya ma vunu wa. Nala wa tuko ta̱ kugori a asu u vunu. ");
INSERT INTO kdl_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Kotsu vu vaku n maku ma uka u tata u vunu u matsa̱kai uza u roku wa, kpaci eyi utaku u vunu u ɗa. ");
INSERT INTO kdl_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Kotsu vu vaku n utaku u tata vunu wa, kpaci eyi kumaci ku tata u vunu ka. ");
INSERT INTO kdl_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Kotsu vu vaku n uma̱ku ko utaku u mma u vunu wa, kpaci eyi kumaci ku mma u vunu ka. ");
INSERT INTO kdl_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Kotsu vu nei tatapige ko tatakenu u vunu uwono vu vaku n uka u ne wa, wata, va raɓa yi adama ɗa va vaku n eyi wa, kpaci eyi mmakenu u vunu u ɗa. ");
INSERT INTO kdl_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Va vaku n kajene ka vunu wa, kpaci eyi uka u maku ma vunu u ɗa. Adama a nala kotsu vu vaku n eyi wa. ");
INSERT INTO kdl_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Kotsu vu vaku n uka u makoshi ko vangu u vunu wa, nala wa tuko ta̱ kugori a asu u makoshi ko vangu vunu. ");
INSERT INTO kdl_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Kotsu vu vaku n uka aku vu vaku n maku ma ne dem wa; kotsu dem vu vaku n matsukaya ma ne wa, wata, maku ma maku ma vali ko ma uka ma ne ma matsai. Gba̱ kumaci ku ne ka. Nala manyan ma uwono ma cika. ");
INSERT INTO kdl_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Kotsu vu zuwa vangu ko uma̱ku u uka u vunu vu vaku n eyi cina uka u vunu n uma wa. ");
INSERT INTO kdl_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","<<Va vaku n uka aꞌayin a ɗa wa̱ri a nshinda̱ ma uwoto wa, kpaci kotsu nshinda̱ mi n kotso wa. ");
INSERT INTO kdl_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Kotsu vu vaku n uka u utoku u vunu wa, kpaci nala wa zuwa vu ta̱ vu woko na̱ nshinda̱. ");
INSERT INTO kdl_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Kotsu vu neke mmuku n vunu a yain manyan n ele a asu u ulyaka Moleki kameli kayala wa, nala wa tuko ta̱ unangasa u kala ka va̱. Mpa Magono ma Zuba Kashila̱ ka vunu. ");
INSERT INTO kdl_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Kotsu vu yain tsugbani n utuko vunu vali tyoku ɗa a tsu yan n aka wa. Nala ili i icaɗi iꞌya. ");
INSERT INTO kdl_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Kotsu vu yain tsugbani n manama wa, kpaci va woko ta̱ na̱ nshinda̱. Uka kpam kotsu u na̱ka̱ kaci ka ne a asu u manama tsa̱ra̱ ma vaku n eyi wa. Nala manyan ma uwono ma cika. ");
INSERT INTO kdl_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","<<Kotsu i woko na̱ nshinda̱ a asu u uyansa ukuna u gbani u nala vi wa. Kpaci a asu u uyansa ukuna u gbani u nala vi u ɗa ma loko ama ɗa aꞌa̱ri nala a kapala ka ɗe ki. ");
INSERT INTO kdl_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Adama nala iyamba yi i wokoi na̱ nshinda̱, kpam ma yan ta̱ iꞌya mavura adama a unyushi u cingi u ama ɗa aꞌa̱ri pini vi. Ya ꞌyuwan ta̱ ama ɗa aꞌa̱ri pini ndishi a asuvu a ne. ");
INSERT INTO kdl_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Shegai eɗa̱ aza a uyamba n amoci a ɗa aꞌa̱ri a asuvu a ɗe, i gorimuko mele ma va̱ n udani u va̱. Kotsu i yain ko i te a asuvu a ili i icaɗi i nala yi wa. ");
INSERT INTO kdl_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Kpaci ama a ɗa a dusuki a uyamba vi kahu eɗa̱, a yansa ta̱ gba̱ ili i icaɗi i nala yi, ɗa i zuwai uyamba vi u wokoi na̱ nshinda̱. ");
INSERT INTO kdl_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Eɗa̱ dem i zuwa baci uyamba vi u wokoi na̱ nshinda̱ a asu u uyansa ili i gbani i nala yi, uyamba vi wa ꞌyuwan ɗa̱ ta̱, tyoku ɗa u yankai kakuma̱ ka ama ka ka dusuki a uyamba vi kahu eɗa̱. ");
INSERT INTO kdl_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","<<Gba̱ uza ɗa baci u yain icun i ili i icaɗi i nala yi, a ka pece yi ta̱ n ama a ne. ");
INSERT INTO kdl_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Adama a nala, gorimukoi udani u va̱ kpam kotsu i woko na̱ nshinda̱ tyoku ɗa ama a ɗa a dusuki kahu eɗa̱ a yansai wa. Kotsu i woko na̱ nshinda̱ a asu u uyansa ili i nala yi wa. Mpa Magono ma Zuba Kashila̱ ka ɗe.>> ");
INSERT INTO kdl_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Magono ma Zuba ma doki ma tonukoi Musa, ");
INSERT INTO kdl_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","<<Tonuko gba̱ kakuma̱ ka aza a Isaraꞌila: U ka̱na̱ ta̱ i woko uwulukpi, kpaci mpa Magono ma Zuba Kashila̱ ka ɗe ma̱ ta̱ uwulukpi. ");
INSERT INTO kdl_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","<<Ya dem a asuvu a ɗe u gorimuko mma u ne n tata u ne, i kirana kpam n aꞌayin a Ashibi a va̱. Mpa Magono ma Zuba Kashila̱ ka ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Kotsu i kpatala̱ka mu kucina̱ i gbashika ameli a roku wa. Kotsu i dara̱kpa irim i yanka kaci ka ɗe ameli wa. Mpa Magono ma Zuba Kashila̱ ka ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","<<Aꞌayin ɗa baci ya yanka mpa Magono ma Zuba uɗara̱kpa u ndishi n shinga, yanyi u ɗa a ure u ɗa a ka wusha u ɗa adama a ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","I takuma inyama i uɗara̱kpa kain ka a yain uɗara̱kpa vi n kain ka ire. Shegai ili iꞌya baci i rawai kain ka tatsu, i runukpa iꞌya. ");
INSERT INTO kdl_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","I takuma baci iꞌya a kain ka tatsu ki, ya woko ta̱ ili i icaɗi, kpam ma wusha uɗara̱kpa vi wa. ");
INSERT INTO kdl_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Uza ɗa baci dem u takumai iꞌya kain ka tatsu ki, unyushi u ne wa̱ ta̱ a kaci ka ne, kpaci u nangasa ta̱ ili iꞌya iꞌa̱ri uwulukpi i Magono ma Zuba. Vuma u nala vi a ka pece yi ta̱ n ama a ne. ");
INSERT INTO kdl_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","<<Aꞌayin a ɗa baci ya kapa ili i kashina i ɗe, kotsu i kapi ubana a ikengi i kashina wa, kotsu kpam i gono i tonusuko iꞌya i a̱sa̱ka̱sa̱i vi wa. ");
INSERT INTO kdl_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Nala kpam dem ya ta baci cinwi a kashina ka cinwi a ɗe, ya ta ka aku i doku i tonusuko wa. Ya ta̱sa̱ tani iꞌya i rukpusa̱i a iyamba wa; nala vi aza a unambi n amoci a ɗa aꞌa̱ri ndishi kaɓolo n a̱ɗa̱ alya ya a̱sa̱nka̱. Mpa Magono ma Zuba Kashila̱ ka ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","<<Kotsu i boko wa. Kotsu i yinsa̱ uza wa. Kpam kotsu i yamgbana kaɓan wa. ");
INSERT INTO kdl_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Kotsu i tsina utsina u kaɓan n kala ka va̱ wa, nala wa tuko ta̱ unangasa u kala ka va̱. Mpa Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","<<Kotsu i ryafa utoku u ɗe wa, ko kpam i wusa yi ucanga wa. Kotsu i a̱sa̱ka̱ katsupi ka zamalinga she kain ka wansa wa. ");
INSERT INTO kdl_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","<<Kotsu i wisha kagulani wa, kpam kotsu i zuwuka karumba̱ ili iꞌya ya zuwa yi uta̱ɗa̱tsa̱ wa. Shegai kotsu i pana uwonvo u Kashila̱ ka ɗe. Mpa Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","<<Kotsu i yain afada n kuɗyangi wa. Kotsu i wenike aza a unambi kuɗyangi aku i na̱ka̱ aza a utsa̱ri tsupige wa. Shegai i yanka aza a karen a ɗe afada a maci. ");
INSERT INTO kdl_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Kotsu i tamburuka kadyanshi ka kaɓan a kaci ka ama a ɗe wa. Aꞌayin a ɗa baci uza u roku wa̱ri a asuvu a afada tsa̱ra̱ u wauwa uma u ne, kotsu i yain kadyanshi, i reve baci gai kadyanshi ki ka ɓa̱nga̱ yi. Mpa Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","<<Kotsu vu kovi utoku u vunu a katakasuvu ka vunu wa. Uza u yan baci ili iꞌya bawu i gain, vu tonuko yi unyushi u ne, tsa̱ra̱ avu dem vu ronuko kaci ka vunu unyushi wa. ");
INSERT INTO kdl_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Kotsu vu tsupa tsicingi ko kpam vu ka̱na̱ uza u vunu a katakasuvu ka vunu wa, shegai vu cigi uza u vunu tyoku ɗa va ciga kaci ka vunu. Mpa Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","<<Kiranai n mele ma va̱. Kotsu i a̱sa̱ka̱ kuzuwate ku kuwa icun kau-kau a yuwa̱mgba̱na̱sa̱ adama a ilimaci wa. Kotsu i cei icun i re kau-kau a kashina ka te wa. Kotsu i uka aminya a ɗa a cai n icun i tsugbere icun kure wa. ");
INSERT INTO kdl_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","<<Vuma vaku baci n makere ma ma̱ri kagbashi, uza ɗa a ka̱na̱ka̱i tsumana kpam kotsu a tsupai ikebe i uwusa tsugbashi ko a wutukpa̱ yi wa, a veci ve ukuna vi. Shegai a ka wuna le wa, kpaci kotsu a wutukpa̱ yi wa. ");
INSERT INTO kdl_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Vuma nala vi wa tuko ta̱ kondom a utsutsu u Katani ka Ugawunsa, ka woko ka uɗara̱kpa u utsupa unyushi u cingi u ne ubana a asu u Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Kaɗara̱kpi ka yanka yi ta̱ uɗara̱kpa u utakpa u unyushi u cingi, n kondom ka uɗara̱kpa u utsupa unyushi u cingi, a kapala ka Magono ma Zuba adama a unyushi u ɗa u yain. Aku a cimbusuka̱ yi unyushi u cingi u ne. ");
INSERT INTO kdl_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","<<Aꞌayin ɗa baci i uwai a uyamba u Kaꞌana i ceshei icun i nɗanga n ɗa a tsu lya ilimaci i le, kotsu i tai iꞌya wa ubana ayen a tatsu, i bidya iꞌya iꞌa̱ ta̱ na̱ nshinda̱. Kotsu i lyai iꞌya wa. ");
INSERT INTO kdl_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","A kayen ka nishi, gba̱ ilimaci yi ya woko ta̱ ili i uwulukpi iꞌya a nekei i icikpali ubana a asu u Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Shegai a kayen ka tawun, ya fuɗa ta̱ ya lya icun i nɗanga mi. I tono baci ili i na yi gba̱, nɗanga mi ma doku ta̱ n matsa cika. Mpa Magono ma Zuba Kashila̱ ka ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","<<Kotsu i takuma inyama iꞌya iꞌa̱ri na̱ mpasa wa. Kotsu i yansa tsuboci ko kapala ka aꞌeshi wa. ");
INSERT INTO kdl_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Kotsu i puni tsileme tsu agbaguzu ko ntsa̱ga̱ n ɗe wa. ");
INSERT INTO kdl_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Kotsu dem i kiɗa̱sa ikyamba i ɗe adama a unamgbukatsuma̱ u ɗa uza roku u kuwa̱ ɗa̱ wa, ko kpam i gyansa kuɗyani ku aꞌulu a ili roku a ikyamba i ɗe wa. Mpa Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","<<Kotsu i nangasa mmuku ma aka n ɗe i zuwa le a woko ashankala wa, adama a ɗa uyamba vi wa shaɗangu n manyan ma uwono n tsicingi. ");
INSERT INTO kdl_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","U ka̱na̱ ta̱ i kirana n aꞌayin a Ashibi a va̱ kpam i pana uwonvo u kuwa ku uwulukpi ku va̱. Mpa Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","<<Kotsu i bana a asu u uza ɗa wa yan manyan na̱ nkabi ko aboci wa. Kotsu i toni le wa, kpaci ya woko ta̱ na̱ nshinda̱. Mpa Magono ma Zuba Kashila̱ ka ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","<<Na̱ka̱i aza ɗa a la ɗa̱ tsupige, i na̱ka̱ nkoshi karinga̱, kpaci ya pana ta̱ uwonvo u va̱. Mpa Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","<<Kamoci ka̱ baci ndishi n a̱ɗa̱ a uyamba u ɗe, kotsu i sukuta̱ yi wa. ");
INSERT INTO kdl_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Shegai i bidya yi yavu uza u iyamba u ɗa dem. I cigi yi tyoku ɗa ya ciga kaci ka ɗe. Kpaci eɗa̱ dem i yan ta̱ tsumoci a uyamba u Masar. Mpa Magono ma Zuba Kashila̱ ka ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","<<Kotsu i ryafa uza a asu u ura̱tsana̱ka ugaɗi ko ara̱ji ko kpam kakuma̱ ka ili wa. ");
INSERT INTO kdl_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","I yain manyan n ili i ura̱tsana̱ka ara̱ji n kakundatsu ka kuden n madele ma maci. Mpa Magono ma Zuba Kashila̱ ka ɗe uza ɗa wutukpa̱ ɗa̱ a uyamba u Masar. ");
INSERT INTO kdl_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","U ka̱na̱ ta̱ i kirana n mele ma va̱ n udani u va̱ gba̱ i yanka u ɗa manyan. Mpa Magono ma Zuba.>> ");
INSERT INTO kdl_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Magono ma Zuba ma tonukoi Musa, ");
INSERT INTO kdl_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","<<Tonuko aza a Isaraꞌila: Uza ɗa baci dem a asuvu a ɗe ko kamoci ka ka̱ri a asuvu a ɗe u nekei uza u te a asuvu a mmuku n ne ubana a asu u Moleki kameli, u ka̱na̱ ta̱ a wuna yi. Aza a uyamba yi a ka vara̱sa yi ta̱ n atali a wuna. ");
INSERT INTO kdl_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Mpa dem ma yan ta̱ tsilala n eyi n peci yi n ama a va̱; kpaci ili iꞌya u yain nala vi, i zuwa ta̱ kuwa ku uwulukpi ku va̱ ku wokoi na̱ nshinda̱, kpam i zuwai kala ka va̱ ka uwulukpi ka namgbai. ");
INSERT INTO kdl_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Kpam aza a uyamba yi a a̱sa̱ka̱ baci vuma vi a ꞌyuwan yi uwuna, ");
INSERT INTO kdl_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","mpa ma yan ta̱ tsilala n kuwa ku ne. Ma pece yi ta̱ n ama a ne n aza ɗa a ꞌyuwan mu upana̱ka aku a gonoi a ka yan tsishankala n Moleki kameli. ");
INSERT INTO kdl_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","<<Uza bana baci ubolo adooki a asu u aza ɗa a ka yan manyan na̱ nkabi ko aboci wa yansa tsishankala n ele, ma yan ta̱ tsilala n vuma u nala vi n peci yi n ama a ne. ");
INSERT INTO kdl_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","U ka̱na̱ ta̱ i woko uwulukpi, kpaci mpa Magono ma Zuba Kashila̱ ka ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","U ka̱na̱ ta̱ i kirana n mele ma va̱, i yanka ma manyan. Mpa Magono ma Zuba uza ɗa n zuwai i wokoi uwulukpi. ");
INSERT INTO kdl_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Gba̱ uza ɗa baci dem u wishai tata ko mma u ne, u ka̱na̱ ta̱ a wuna yi. Mpasa n ne ma̱ ta̱ a kaci ka ne, kpaci tata u ne ko mma u ne u ɗa u wishai. ");
INSERT INTO kdl_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","<<Uza yan baci tsugbani n uka u utoku u ne, gba̱ ama a re a le uka n vali vi u ka̱na̱ ta̱ a wuna le. ");
INSERT INTO kdl_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Uza u vaku baci n uka u tata u ne, u ne ta̱ tata u ne uwono. U ka̱na̱ ta̱ a wuna le ama a re a le gba̱. Mpasa n le ma̱ ta̱ a kaci ka le. ");
INSERT INTO kdl_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Uza ɗa baci dem u vaki n kajene ka ne, u ka̱na̱ ta̱ a wuna le ama a re a le gba̱. Kpaci a yan ta̱ manyan ma uwono, mpasa n le kpam ma̱ ta̱ a kaci ka le. ");
INSERT INTO kdl_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Uza yan baci tsugbani n utoku u ne vali tyoku ɗa a tsu yan n aka, ama a re a le a yan ta̱ ili i icaɗi. U ka̱na̱ ta̱ a wuna le. Mpasa n le ma̱ ta̱ a kaci ka le. ");
INSERT INTO kdl_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Uza u zuwa baci uka aku u doku u zuwai mma u ne, ili i uwono iꞌya i pige. Gba̱ ama a tatsu a le a ka runukpa le ta̱, kotsu ili i uwono yi i tambura a asuvu a ɗe wa. ");
INSERT INTO kdl_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Uza yan baci tsugbani n manama, a wuna vuma vi kpam u ka̱na̱ ta̱ dem a wuna manama mi. ");
INSERT INTO kdl_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Uka tono baci manama u vaki n eyi, mayun, u ka̱na̱ ta̱ a wuna yi kpam dem a wuna manama mi. Mpasa n le ma̱ ta̱ a kaci ka le. ");
INSERT INTO kdl_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","<<Vuma zuwa baci vangu u ne, ko maku ma tata u ne ko kpam ma mma u ne aku u vaki n eyi, nala ili i uwono iꞌya. U ka̱na̱ ta̱ a peci le n ama a le, ama n a wundi. Kpaci u vaku ta̱ n utaku u ne, mpasa n ne ma̱ ta̱ a kaci ka ne. ");
INSERT INTO kdl_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Vuma vaku baci n uka aꞌayin a ɗa wa̱ri a nshinda̱ ma uwoto n ne, gba̱ ama a re a le a ka pece le ta̱ n ama a le, kpaci gba̱ le a koɗo ta̱ mele ma uwoko uwulukpi. ");
INSERT INTO kdl_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Kotsu vuma vaku n utaku u mma u ne ko utaku u tata u ne wa. Uyan nala wa tuko ta̱ uwono a asu u kumaci ku vunu, kpam mpasa n le ma̱ ta̱ a kaci ka le. ");
INSERT INTO kdl_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Uza u vaku baci n uka u tatapige ko tatakenu u ne, nala wa tuko ta̱ uwono a asu u tata vi. Mpasa n le ma̱ ta̱ a kaci ka le, kpam a ka kuwa̱ ta̱ bawu ilimaci. ");
INSERT INTO kdl_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Uza u vaku baci n uka u makoshi ko vangu u ne eyi n uma, nala ili icaɗi iꞌya. U tuko ta̱ uwono a asu u utoku u vi, kpam a ka tsa̱ra̱ ilimaci wa. ");
INSERT INTO kdl_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","<<U ka̱na̱ ta̱ i kirana n mele ma va̱ n udani u va̱ gba̱ i yanka u ɗa manyan, kotsu iyamba iꞌya ma banka ɗa̱ i ba i dusuku i ꞌyuwan ɗa̱ wa. ");
INSERT INTO kdl_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Kotsu i toni agadu a ama ɗa ma loko a kapala ka ɗe nala vi wa, ma pana ta̱ icaɗi i le, kpaci a tono ta̱ ukuna u nala vi. ");
INSERT INTO kdl_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Shegai n tonuko ɗa̱ ta̱, uyamba u nala vi wa woko ta̱ u ɗe, ma na̱ka̱ ɗa̱ ta̱ u ɗa. Uyamba u ɗa wa̱ri n tsishinda̱ n ilikulya i shinga ushani. Mpa Magono ma Zuba Kashila̱ ka ɗe, uza ɗa u takpana ɗa̱ asuvu a ama a ɗa a buwai. ");
INSERT INTO kdl_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Adama nala u ka̱na̱ ta̱ i takpana nnama n ɗa a wulukpei na̱ n ɗa ma̱ri na̱ nshinda̱. I takpana kpam nnu n ɗa ma̱ri na̱ nshinda̱ na̱ n ɗa a wulukpei. U gan i nangasa kaci ka ɗe n icaɗi a asu u nnama ko nnu ko kpam ili iꞌya ya ka̱bura̱ a iyamba wa, wata, n ɗa n ɗanga̱sai n woko ili i nshinda̱ ara ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","U ka̱na̱ ta̱ i woko n uwulukpi utuwa̱ ara va̱, kpaci mpa Magono ma Zuba ma̱ ta̱ uwulukpi, n wutukpa̱ ɗa̱ ta̱ a asuvu a ama ɗa a buwai tsa̱ra̱ i woko ama a va̱. ");
INSERT INTO kdl_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","<<Vali ko uka ɗa baci u wokoi kaboci ko kpam uza ɗa wa yan manyan na̱ nkabi, u ka̱na̱ ta̱ a vara̱sa yi a wuna. Mpasa n ne ma̱ ta̱ a kaci ka ne.>> ");
INSERT INTO kdl_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Magono ma Zuba ma tonukoi Musa, <<Tonuko aɗara̱kpi, wata, alobo a Haruna, vu dana: Kotsu uza u woko na̱ nshinda̱ a asu u usawa kakushe ka ama a ne wa. ");
INSERT INTO kdl_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Shegai aza a kuwa a ne, wata, mma u ne ko tata u ne ko mmuku ne ko makoshi ma ne ko vangu u ne, ");
INSERT INTO kdl_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ko vangu u ne uza ɗa kotsu u revei vali kpam wa̱ri a kere ku ne, uza ɗa kotsu u yain iyolo wa. Wa fuɗa ta̱ wa woko na̱ nshinda̱ adama a ne. ");
INSERT INTO kdl_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Shegai kotsu u woko na̱ nshinda̱ kpam u nangasa kaci ka ne adama a kumaci ka iyolo ka ka̱ri a mere ma ne n aza a kuwa ku uka u ne wa. ");
INSERT INTO kdl_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Kotsu aɗara̱kpi a puni kaci a buwuka kapashi ka roku wa, kotsu a puni tsileme tsu agbaguzu ko kpam a gyain iɗyani ikyamba i le adama a unamgbukatsuma̱ wa. ");
INSERT INTO kdl_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","U ka̱na̱ ta̱ a woko uwulukpi ubana a asu u Kashila̱ ka le, a ka nangasa kala ka Kashila̱ ka le wa. Kpaci alya a tsu yan kune ku ilikulya ubana a asu u Magono ma Zuba, wata, ilikulya i Kashila̱ ka le. Adama a nala, u ka̱na̱ ta̱ a woko uwulukpi. ");
INSERT INTO kdl_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","A ka zuwa aka a ɗa a nangasai kaci ka le n icaɗi adama a tsishankala wa, ko kpam uza ɗa vali u ne u a̱sa̱ka̱i wa; kpaci aɗara̱kpi aꞌa̱ ta̱ uwulukpi ubana a asu u Kashila̱ ka le. ");
INSERT INTO kdl_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Adama a nala, u ka̱na̱ ta̱ ama a bidya aɗara̱kpi n uwulukpi, kpaci alya a tsu na̱ka̱sa̱ Kashila̱ ka le ilikulya. U ka̱na̱ ta̱ ama a bidya le n uwulukpi, kpaci mpa Magono ma Zuba, uza ɗa n zuwai a woko uwulukpi vi ma̱ ta̱ uwulukpi. ");
INSERT INTO kdl_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Ukere u kaɗara̱kpi u nangasa baci kaci ka ne n tsishankala, u ne ta̱ tata u ne uwono, adama a nala, a ka runukpa yi ta̱ she u kuwa̱. ");
INSERT INTO kdl_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","<<Magono ma Aɗara̱kpi uza ɗa wa̱ri uzapige a asuvu a atoku a ne, wata, uza ɗa a tsunki manivi ma uneke a kaci ka ne tsa̱ra̱ a neke yi n uwulukpi u uka aminya a tsuɗara̱kpi, wa a̱sa̱ka̱ kenji ka kaci ka ne za̱ka̱ka̱ ko kpam u kara̱sa aminya a ne adama a unamgbukatsuma̱ wa. ");
INSERT INTO kdl_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Wa uwa a asu u ɗa kakushe ka̱ri wa, adama a ɗa wa woko na̱ nshinda̱, ko tata u ne ko mma u ne ɗa baci tani. ");
INSERT INTO kdl_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Wa wuta̱ u a̱sa̱ka̱ kuwa ku uwulukpi u bana a asu u ukpa̱ wa. U yan baci nala, eyi n kuwa ku uwulukpi ki a ka woko ta̱ na̱ nshinda̱, kpaci manivi ma uneke ma Kashila̱ ka ne ma̱ ta̱ a kaci ka ne. Mpa Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","U ka̱na̱ ta̱ u zuwa makere ma bawu ma revei vali. ");
INSERT INTO kdl_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Wa zuwa mara̱na̱ wa, ko uka u ɗa vali u ne u a̱sa̱ka̱i wa, ko tani uza ɗa nangasai kaci ka ne n tsishankala wa. Shegai wa zuwa ta̱ makere ma bawu ma revei vali ma ma̱ri a asuvu a ama a ne, ");
INSERT INTO kdl_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","tsa̱ra̱ u nangasa kagali ka ne aza ɗa u gain a woko uwulukpi wa. Kpaci mpa Magono ma Zuba uza ɗa zuwa yi u woko uwulukpi.>> ");
INSERT INTO kdl_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Magono ma Zuba ma tonukoi Musa, ");
INSERT INTO kdl_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","<<Tonuko Haruna, vu dana: Ili iꞌya i ka̱na̱i a uyan u na ubana a uyan u ɗa wa tuwa̱, ko uza wa̱ la asuvu a kagali ka vunu uza ɗa lyopoi wa raɓa evu u na̱ka̱ Kashila̱ ka ne kune ku ilikulya wa. ");
INSERT INTO kdl_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Kpaci uza wa̱ la uza ɗa lyopoi wa raɓa evu u yain uɗara̱kpa wa, ko karumba̱ ka baci ko kawunu. Uza ɗa baci ili i nangasai upetiwaꞌeshi ko kpam uza ɗa apashi a ikyamba a lamgbanai wa yan uɗara̱kpa wa. ");
INSERT INTO kdl_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","Nala dem uza ɗa kune ku ne ko kukere ku koɗoi. ");
INSERT INTO kdl_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","Uza ɗa baci wa̱ri na̱ nkondo, ko makpaturu ma vuma, ko uza ɗa wa̱ri n usa̱n a keshi, ko wa̱ri n kadokpolo, ko maɓa̱la̱ ma ntsutsu, ko uza ɗa asanda a ne a ta̱sa̱i, wa raɓa adama ɗa u yain uɗara̱kpa wa. ");
INSERT INTO kdl_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Uza wa̱ la a kagali ka Haruna kaɗara̱kpi, uza ɗa lyopoi wa raɓa evu n asuɗara̱kpa u na̱ka̱ kune ku ilikulya ubana a asu u Magono ma Zuba wa. An u wokoi u lyopoi, wa raɓa evu n asuɗara̱kpa u na̱ka̱ ilikulya i Kashila̱ ka ne wa. ");
INSERT INTO kdl_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Shegai wa fuɗa ta̱ wa lya ilikulya i uwulukpi ko iꞌya i lakai uwulukpi i Kashila̱ ka ne. ");
INSERT INTO kdl_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Gba̱ n nala, an u wokoi u lyopoi, wa raɓa evu n kunya ku uba̱ra̱kpa̱ ku Asu u ɗa u Lakai Uwulukpi ko a asuɗara̱kpa wa, tsa̱ra̱ kotsu u nangasa kuwa ku uwulukpi ku va̱ n ili iꞌya dem iꞌa̱ri pini wa. Kpaci mpa Magono ma Zuba, uza ɗa zuwai i wokoi uwulukpi.>> ");
INSERT INTO kdl_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Nala tani Musa tonukoi Haruna n alobo a ne n aza a Isaraꞌila gba̱. ");
INSERT INTO kdl_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Magono ma Zuba ma tonukoi Musa ");
INSERT INTO kdl_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","u tonuko Haruna n alobo a ne udani u na vi, <<Kiranai n kune ku uwulukpi ka aza a Isaraꞌila a nekei n uwulukpi utuwa̱ ara va̱, tsa̱ra̱ a nangasa kala ka uwulukpi ka va̱ wa. Mpa Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Tonuko le, <Ili iꞌya i ka̱na̱i a uyan u na ubana u ɗa wa tuwa̱, vali ɗa baci dem a asuvu a kagali ka ɗe, u raɓai evu n ili i uwulukpi iꞌya aza a Isaraꞌila a nekei n uwulukpi ubana a asu u Magono ma Zuba kpam eyi na̱ nshinda̱, vuma nala vi a ka pece yi ta̱ a wutukpa̱ yi a kapala ka va̱. Mpa Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Vali ɗa baci dem a asuvu a kagali ka Haruna wa̱ri n maɓa̱la̱ ma ukpan ko wa̱ri na̱ ncana, wa lya asuvu a kune ku uwulukpi ki wa, she aꞌayin ɗa a wulukpe yi. Uza ɗa baci dem u sawai ili iꞌya i wokoi na̱ nshinda̱ an i sawai kakushe, ko uza ɗa mini ma tsalali ma la̱la̱, ");
INSERT INTO kdl_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ko kpam u sawai ili iꞌya ya ka̱bura̱ iꞌya ya zuwa yi u woko na̱ nshinda̱, ko ucun u vuma ɗa wa zuwa yi u woko na̱ nshinda̱ ko icun i nshinda̱ n eni u ɗa baci wa̱ri na̱ n ɗa, kaɗara̱kpi ki ka woko ta̱ dem na̱ nshinda̱. ");
INSERT INTO kdl_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Uza ɗa baci dem u sawai ili i nshinda̱ i nala yi, wa woko ta̱ na̱ nshinda̱ ubana kuvuli, kpam wa lya ili i uwulukpi iꞌya a nekei vi wa, she aꞌayin a ɗa u sumba̱i. ");
INSERT INTO kdl_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Shegai aꞌayin ɗa kaara ka rukpa̱i, a ka wulukpe yi ta̱, pini nala, wa fuɗa ta̱ wa lya ili i uwulukpi iꞌya a nekei kpaci icun i ilikulya i ne iꞌya. ");
INSERT INTO kdl_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Wa takuma manama ma ma kuwa̱i agifa wa, ko manama ma nnama n mete n wunai wa. Nala wa zuwa yi ta̱ u woko na̱ nshinda̱. Mpa Magono ma Zuba.> ");
INSERT INTO kdl_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","U ka̱na̱ ta̱ aɗara̱kpi a kirana n udani u va̱, tsa̱ra̱ unyushi u le u woko a kaci ka le hal u wuna le a asu u unangasa mele ma uwulukpi ma va̱ wa. Mpa Magono ma Zuba uza ɗa zuwai a wokoi uwulukpi. ");
INSERT INTO kdl_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","<<Uza ɗa baci dem wa̱ri asuvu a kagali ka aɗara̱kpi wa, wa lya asuvu a kune ka uwulukpi ki wa. Kamoci ka baci dem ka tuwa̱i tsumoci a asu u kaɗara̱kpi, ko zamalinga ka ne, wa lya asuvu a kune ka uwulukpi ki wa. ");
INSERT INTO kdl_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Shegai kaɗara̱kpi ka tsila baci kagbashi n ikebe i ne, ko kpam agbashi a ɗa a matsai a kuwa ku ne, a ka fuɗa ta̱ a lyai ilikulya i ne. ");
INSERT INTO kdl_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Ukere u kaɗara̱kpi u bana baci uza ɗa bawu wa̱ri kaɗara̱kpi iyolo, wa lya a asuvu a kune ku uwulukpi ki wa. ");
INSERT INTO kdl_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Shegai maku ma kaɗara̱kpi ma woko baci mara̱na̱ ko kpam vali u ne u a̱sa̱ka̱ yi, kpam bawu wa̱ri n maku, u gono baci a kuwa ku tata u ne tyoku ɗa wa̱ri caupa kahu u bana iyolo, wa fuɗa ta̱ wa lya ilikulya i tata u ne. Amaci a kaɗara̱kpi a ɗa koshi a wushunki a lyai ilikulya i kaɗara̱kpi. ");
INSERT INTO kdl_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Uza u lya baci ilikulya i uwulukpi iꞌya a na̱ka̱i kaɗara̱kpi bawu u revei, u ka̱na̱ ta̱ u tsupa iꞌya, kpam u doku kunzu ku te a asuvu a ku tawun. ");
INSERT INTO kdl_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Kotsu aɗara̱kpi a nangasa kune ku uwulukpi ka aza a Isaraꞌila a tukoi Magono ma Zuba, ");
INSERT INTO kdl_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","a asu u uꞌa̱sa̱ka̱ aza ɗa bawu aꞌa̱ri aɗara̱kpi a lyai ilikulya yi wa. Nala wa tuko ta̱ vuma u nala vi unyushi, kpam wa ronuko yi ta̱ mavura. Mpa Magono ma Zuba mpa n zuwai i wokoi wulukpi.>> ");
INSERT INTO kdl_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Magono ma Zuba ma tonukoi Musa, ");
INSERT INTO kdl_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","<<Tonuko Haruna n alobo a ne n aza a Isaraꞌila gba̱ mele ma na mi: Uza ɗa baci dem a asuvu a kuwa ku aza a Isaraꞌila ko kamoci ka ka̱ri ndishi asuvu a le, uza ɗa wa ciga u yain uɗara̱kpa u urunukpa adama a ushaɗangu u utsina ko kune ku uciga ubana a asu u Magono ma Zuba, ");
INSERT INTO kdl_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","wa ciga baci uɗara̱kpa u nala vi a wushi u ɗa, u ka̱na̱ ta̱ u tuko kagono a asuvu a ushiga u anaka ko ncon ko nryaɗiga ka ka lyopoi wa. ");
INSERT INTO kdl_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Gba̱ manama ma baci ma lyopoi, a ka yanka ma uɗara̱kpa wa, kpaci Magono ma Zuba ma wusha u ɗa wa. ");
INSERT INTO kdl_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Gba̱ uza ɗa baci dem u yain uɗara̱kpa u ndishi n shinga ubana a asu u Magono ma Zuba, tsa̱ra̱ u shaɗangu u utsina u ɗa u tsinai ko kpam kune ku uciga, a asuvu a ushiga u anaka ko u ncon ko u nryaɗiga, u ka̱na̱ ta̱ manama mi ma woko ma ma lyopoi wa, tsa̱ra̱ a wushi uɗara̱kpa vi. ");
INSERT INTO kdl_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","A ka na̱ka̱ Magono ma Zuba karumba̱ ka manama wa, ko ma ma koɗoi, ko kawunu, ko ma̱ri n kagala̱ma, ko ma ma̱ri n maɓa̱la̱ ma ukpan, ko ma ma̱ri n ita̱fulishi. Kotsu i na̱ka̱ icun i nnama n na mi n woko kune ku ilikulya a asuɗara̱kpa u Magono ma Zuba wa. ");
INSERT INTO kdl_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Kagono ka kanaka ko ka macon ka baci apashi a ikyamba a ne a lamgbanai, ya fuɗa ta̱ i yanka a ɗa uɗara̱kpa u uciga. Shegai uɗara̱kpa u ushaɗangu u utsina u ɗa baci, Magono ma Zuba ma wusha u ɗa wa. ");
INSERT INTO kdl_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Manama ma baci dem asanda a ne aꞌa̱ri dere wa, ko kpam a wutukpa̱ yi a ɗa, kotsu i na̱ka̱ ma Magono ma Zuba wa. Kotsu gba̱m i yanka ma uɗara̱kpa a uyamba u ɗe wa. ");
INSERT INTO kdl_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Kotsu i wushi icun i manama ma nala mi a asu u kamoci aku i dana ya na̱ka̱ Kashila̱ u woko yi ilikulya wa. Kpaci ma gan a yanka ma uɗara̱kpa wa, an u lyopoi. Kpaci a ka wusha u ɗa adama a ɗe wa.>> ");
INSERT INTO kdl_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Magono ma Zuba ma lyai kapala n kadyanshi, ");
INSERT INTO kdl_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","<<Aꞌayin ɗa baci kanaka ko macon ko maryaɗiga ma matsai, a ka a̱sa̱ka̱ ta̱ maku mi na̱ mma u ne hal aꞌayin a shindere. Shegai ili iꞌya i bidyai kain ka kulla̱ ubana, a ka fuɗa ta̱ a na̱ka̱ ma ma woko kune ku ilikulya ubana a asu u Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Ya kiɗa kanaka n maku ma ne ko macon n maku ma ne kain ka te wa. ");
INSERT INTO kdl_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Ya yan baci uɗara̱kpa u ucikpa ubana a asu u Magono ma Zuba, u ka̱na̱ ta̱ i yain u ɗa a ure u ɗa a ka wusha u ɗa adama a ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","U ka̱na̱ ta̱ i takuma inyama i uɗara̱kpa yi gba̱ kain ka te, ko i te ya a̱sa̱ka̱ i wansa wa. Mpa Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","<<Nala ya kirana n mele ma va̱, i yanka kpam ma manyan. Mpa Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Eɗa̱ aza a Isaraꞌila, kotsu i nangasa kala ka uwulukpi ka va̱ wa, u ka̱na̱ ta̱ i kirana n ka n uwulukpi. Mpa Magono ma Zuba uza ɗa n zuwai i wokoi uwulukpi, ");
INSERT INTO kdl_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","n wutukpa̱ ɗa̱ ta̱ a uyamba a Masar tsa̱ra̱ n woko Kashila̱ ka ɗe. Mpa Magono ma Zuba.>> ");
INSERT INTO kdl_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Magono ma Zuba ma tonukoi Musa, ");
INSERT INTO kdl_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","<<Tonuko aza a Isaraꞌila, vu dana: Abiki a Magono ma Zuba a ɗa a ɗanga̱sai a ɗa na. Ya dansa ta̱ a ɗa a asu u kaɓolo ka uwulukpi. ");
INSERT INTO kdl_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","<<Asuvu aꞌayin a teli a ɗa ya yan manyan, shegai kain ka shindere kain ka Ashibi ka uwunvugusa gba̱ ka, kain ka kaɓolo ka uwulukpi. Ya yan manyan a asuvu a kain ka nala ki wa ko kenu ko nte baci iꞌa̱ri; kpaci kain ka Ashibi ki ka Magono ma Zuba ka. ");
INSERT INTO kdl_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","<<Abiki a roku a ɗa dem na a asuvu abiki a Magono ma Zuba a ɗa a ɗanga̱sai, i yansa kaɓolo ka uwulukpi ka ya yansa kadyanshi ka le a asuvu a aꞌayin a ɗa a ɗanga̱sai vi. ");
INSERT INTO kdl_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","N kuvuli kahu asu u likpa̱mgba̱na̱ a kain ka kupa n u nishi a uwoto u kagita̱, ɗa a ka gita̱ Abiki a Upasamgbana a Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","N kain ka kupa n u tawun a uwoto u nala vi ka a ka yan Abiki a Burodi u ɗa u Nambai Yisti a Magono ma Zuba; ya yan ta̱ aꞌayin shindere n i lyayi u ɗa. ");
INSERT INTO kdl_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Kain ka kagita̱ ka abiki ki ka ya yan kaɓolo ka uwulukpi. Ya yan manyan ma i cuwana̱kai uyansa wa. ");
INSERT INTO kdl_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Ya yansa ta̱ kune ku ilikulya hal aꞌayin a shindere ubana a asu u Magono ma Zuba. Kain ka shindere ki ka kain ka kaɓolo ka uwulukpi; kotsu i yain manyan ma i cuwana̱kai uyansa wa.>> ");
INSERT INTO kdl_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Magono ma Zuba ma tonukoi Musa, ");
INSERT INTO kdl_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","<<Tonuko aza a Isaraꞌila, vu dana: Aꞌayin a ɗa baci i uwai a uyamba u ɗa ma na̱ka̱ ɗa̱ vi, i kapa baci ilya i ɗe, i bidya madolu ma kagita̱ ma i gita̱i ukapa vi i banka kaɗara̱kpi. ");
INSERT INTO kdl_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Kaɗara̱kpi ki ka yan ta̱ uɗara̱kpa u ura̱ɗugba̱ a kapala ka Magono ma Zuba tsa̱ra̱ a wushi u ɗa adama a ɗe. Kain ka wansa baci Ashibi a wurai, ɗa wa yan nala. ");
INSERT INTO kdl_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Kain ka i yain uɗara̱kpa u ura̱ɗugba̱ n madolu mi, ya yan ta̱ dem uɗara̱kpa u urunukpa ubana a asu u Magono ma Zuba n kondom ka kayen ka te ka ka lyopoi wa. ");
INSERT INTO kdl_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Ya yan ta̱ uɗara̱kpa n kondom ki kaɓolo n kira ku ilya ku lewu ku akundatsu a kuden a re a asuvu a kupa ka a juɗugi n manivi, u woko kune ku ilikulya i magula̱ni ma shinga ubana a asu u Magono ma Zuba; kaɓolo n uɗara̱kpa u ili i uso madele ma te ma mini ma cinwi. ");
INSERT INTO kdl_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Ya takuma burodi u ilya i savu wa, ya takuma tani ilya i uzungi ko i ɓinci wa, she aꞌayin ɗa i tukoi kune ku na ki a asu u Kashila̱ ka ɗe. Mele ma na mi ma yan ta̱ pini a uyan u ɗe ushani ubana, a asu u ɗa baci dem iꞌa̱ri. ");
INSERT INTO kdl_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","<<Ya kece ta̱ aꞌayin a shindere a shindere ubana kushindere, ili iꞌya i bidyai kain ka ka tono kain ka Ashibi, wata, kain ka i tuko mu madolu ma uɗara̱kpa u ura̱ɗugba̱. ");
INSERT INTO kdl_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Ya lya ta̱ kapala n ukece ubana kain ka ka tono Ashibi a shindere yi, wata, aꞌayin amangarenkupa a ɗa la vi, kain ka ya yan uɗara̱kpa u ilya i savu ubana a asu u Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Asu u ɗa baci dem iꞌa̱ri na̱ ndishi, i tuko iburodi i re, u woko uɗara̱kpa u ura̱ɗugba̱ ubana a asu u Magono ma Zuba. Burodi dem, a yain u ɗa n kira ku lewu ka ku rawai akundatsu a kuden a re ka a juɗugi n yisti. A zungu u ɗa a yanka uɗara̱kpa u ilimaci i kagita̱ ubana a asu u Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Gba̱ ɗe ya yan ta̱ uɗara̱kpa u urunukpa na̱ mmuku ma macon n shindere ma ayen a te a te, n kagono ka kanaka ka te, n aꞌondom a re. Gba̱ le a woko aza ɗa a lyopoi wa, kaɓolo n iburodi yi ubana a asu u Magono ma Zuba. Uɗara̱kpa u urunukpa vi, kaɓolo n uɗara̱kpa u ilya, n uɗara̱kpa u ili i uso, ya woko ta̱ kune ku ilikulya ku magula̱ni ma shinga ka a yain n akina ubana a asu u Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","U ka̱na̱ ta̱ i yain uɗara̱kpa n maga̱ji u woko uɗara̱kpa u uwulukpe. I yain kpam uɗara̱kpa na̱ mmuku ma ncon n re ma ayen a te a te n woko uɗara̱kpa u ndishi n shinga. ");
INSERT INTO kdl_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Kaɗara̱kpi ka yan ta̱ uɗara̱kpa u ura̱ɗugba̱ na̱ mmuku ma ncon mi kaɓolo n iburodi i ilimaci i kagita̱ ubana a asu u Magono ma Zuba. A ka neke ta̱ iꞌya n uwulukpi ubana a asu u Magono ma Zuba, tsa̱ra̱ a na̱ka̱ kaɗara̱kpi. ");
INSERT INTO kdl_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","A tonuko ama kain ka nala ki ka woko kain ka kaɓolo ka uwulukpi. Ya yan manyan ma i cuwana̱kai uyansa wa. Mele ma na mi ma yan ta̱ pini a uyan u ɗe ushani ubana, a asu u ɗa baci dem iꞌa̱ri. ");
INSERT INTO kdl_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","<<Aꞌayin a ɗa baci ya kapa ili i kashina i ɗe, kotsu i kapi ubana a ikengi i kashina wa, kotsu kpam i gono i tonusuko iꞌya i a̱sa̱ka̱sa̱i vi wa. Nala, aza a unambi n amoci a ɗa aꞌa̱ri ndishi kaɓolo n a̱ɗa̱ alya ya a̱sa̱nka̱. Mpa Magono ma Zuba Kashila̱ ka ɗe.>> ");
INSERT INTO kdl_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Magono ma Zuba ma tonukoi Musa, ");
INSERT INTO kdl_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","<<Tonuko aza a Isaraꞌila udani u na vi: Kain ka kagita̱ ka uwoto u shindere, ya kirana ta̱ n ka ka woko kain ka uwunvugusa gba̱, kpam kain ka ya rongo uciɓusa n Kashila̱ ka ɗe ka. Ya yan ta̱ kaɓolo ka uwulukpi, aꞌayin a ɗa baci a fula̱i kavana. ");
INSERT INTO kdl_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Ya yan manyan ma i cuwana̱kai uyansa wa, shegai ya yan ta̱ kune ku ilikulya ubana a asu u Magono ma Zuba.>> ");
INSERT INTO kdl_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Magono ma Zuba ma tonukoi Musa, ");
INSERT INTO kdl_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","<<Kain ka kupa ka uwoto u shindere, ka woko ta̱ kain ka Utakpa u Unyushi u Cingi. Ka woko ɗa̱ ta̱ kain ka kaɓolo ka uwulukpi. Ya yan ta̱ kakuli aku i yain kune ku ilikulya ubana a asu u Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Ya yan manyan a asuvu a kain nala ki wa, ko kenu, kpaci Kain ka Utakpa u Unyushi u Cingi ka. A ka takpa ta̱ unyushi u cingi u ɗe a kapala ka Magono ma Zuba Kashila̱ ka ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Uza ɗa baci dem u kpa̱ɗa̱i uyan kakuli kain ki, a ka pece yi ta̱ n ama a ne. ");
INSERT INTO kdl_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Uza ɗa baci dem u yain manyan a kain ki, mpa Magono ma Zuba ma wacinsa yi ta̱ a asuvu a ama a ne. ");
INSERT INTO kdl_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Ya yan manyan ma roku wa, ko kenu. Mele ma na mi ma yan ta̱ pini a uyan u ɗe ushani ubana, a asu u ɗa baci dem iꞌa̱ri. ");
INSERT INTO kdl_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Ili iꞌya i ka̱na̱i urukpa̱ u kaara u kain ka kuci ka uwoto vi, ubana urukpa̱ u kaara u kain ka kupa, ɗa ya wunvugusa gba̱ kpam i yain kakuli.>> ");
INSERT INTO kdl_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Magono ma Zuba ma tonukoi Musa, ");
INSERT INTO kdl_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","<<Tonuko aza a Isaraꞌila udani u na vi: Kain ka kupa n u tawun a uwoto u shindere, ya gita̱ ta̱ Abiki a Atani adama a Magono ma Zuba. I yain abiki yi aꞌayin a shindere. ");
INSERT INTO kdl_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Kain ka kagita̱ ka abiki yi, ya yan ta̱ kaɓolo ka uwulukpi, kpam ya yan manyan ma i cuwana̱kai uyansa wa. ");
INSERT INTO kdl_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Asuvu a aꞌayin a shindere a nala yi, ya rongo ta̱ uyansa kune ku ilikulya ubana a asu u Magono ma Zuba. Kain ka kulla̱ aku i yain kaɓolo ka uwulukpi ka roku, kpam i yain kune ku ilikulya ubana a asu u Magono ma Zuba. Kain ki ka woko ta̱ ka ulya u kayala, adama a nala, ya yan manyan ma i cuwana̱kai uyansa wa. ");
INSERT INTO kdl_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","<<Abiki abiki a Magono ma Zuba a ɗa ɗanga̱sai a ɗa la vi. I dansa a ɗa a asu u kaɓolo ka uwulukpi, tsa̱ra̱ i yain kune ku ilikulya ubana a asu u Magono ma Zuba, wata, uɗara̱kpa u urunukpa, n u ilya n u ili i uso. Uɗara̱kpa dem a ka yan ta̱ u ɗa a asuvu a kain ka a zuwuka yi. ");
INSERT INTO kdl_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Abiki abiki a na yi, a ka woko ta̱ ili iꞌya a doki a zuba u aꞌayin a Ashibi ubana a asu u Magono ma Zuba. Uɗara̱kpusa vi kpam wa woko ta̱ ili iꞌya a doki a zuba u kune ku ɗe, n uɗara̱kpa u ushaɗangu u utsina, n kune ku uciga ka i na̱ka̱i Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","<<Kain ka kupa n u tawun a uwoto u shindere, aꞌayin a ɗa i ɓolongusi ili i ashina i ɗe, i kirana n abiki a Magono ma Zuba yi aꞌayin a shindere. Kain ka gita̱ n kain ka kulla̱ ka abiki yi, ya wunvugusa ta̱ gba̱. ");
INSERT INTO kdl_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Kain ka kagita̱, ya ta ta̱ a asuvu a ilimaci i nɗanga n ɗa n lakai tsulobo, n akere a nshuwan, n atyangi a nɗanga n ɗa ma̱ri n avuku cika, n atyangi a nɗanga n ɗa ma̱ri a ikengi i aga̱ta̱. Aku i rongo uyan maza̱nga̱ a kapala ka Magono ma Zuba Kashila̱ ka ɗe ubana aꞌayin a shindere. ");
INSERT INTO kdl_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Kayen dem i yain abiki a na yi ubana a asu u Magono ma Zuba ubana aꞌayin a shindere. Mele ma na mi ma yan ta̱ pini a uyan u ɗe ushani ubana. ");
INSERT INTO kdl_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","A asuvu aꞌayin a shindere a abiki a na yi, gba̱ aza a uyamba u Samaꞌila a ka rongo ta̱ a asuvu a atani. ");
INSERT INTO kdl_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Nala uyan u ɗe u ɗa wa tuwa̱ a ka reve an n zuwai aza a Isaraꞌila a rongoi a asuvu a atani aꞌayin a ɗa n wutukpa̱ le a uyamba u Masar. Mpa Magono ma Zuba Kashila̱ ka ɗe.>> ");
INSERT INTO kdl_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Nala Musa zuwukai aza a Isaraꞌila abiki abiki a Magono ma Zuba a ɗa a ɗanga̱sai. ");
INSERT INTO kdl_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Magono ma Zuba ma tonukoi Musa, ");
INSERT INTO kdl_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","<<Tonuko aza a Isaraꞌila a tuko manivi ma ma lobonoi cika, ma a foɓusoi adama ncikalu. Ncikalu mi n rongo una̱ka̱ katyashi kain dem. ");
INSERT INTO kdl_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","A ka zuwa ta̱ ma a kapala ka kunya ku uba̱ra̱kpa̱ ka ka ka̱ngi Akpati u Kazuwamgbani a Katani ka Ugawunsa. Kain dem Haruna wa rongo ta̱ ukirana n ma n kuvuli ubana usana a kapala ka Magono ma Zuba. Mele ma na mi ma yan ta̱ pini a uyan u ɗe ushani ubana. ");
INSERT INTO kdl_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Haruna wa rongo ta̱ ukirana na̱ ncikalu n ɗa ma̱ri a kashamkpatsu ka zinariya u de ka ka̱ri a kapala ka Magono ma Zuba maco. ");
INSERT INTO kdl_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","<<Vu bidya kira ku lewu vu zungu iburodi i apeteli kupa n u re. Burodi dem a yain u ɗa n kira ka ku rawai akundatsu a kuden a re. ");
INSERT INTO kdl_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Vu dari iꞌya abaru a re, vu taɗamgbana̱sa iꞌya i teli i teli, a zuba u teburu u ɗa a yain n zinariya u de a kapala ka Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Kabaru dem vu zuwa pini ili i magula̱ni iꞌya i lobonoi cika i woko kunzu ku uciɓusa, kune ku ilikulya ubana a asu u Magono ma Zuba a una̱ u burodi vi. ");
INSERT INTO kdl_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Kain ka Ashibi dem, u ka̱na̱ ta̱ kaɗara̱kpi ka lyai kapala n utaɗamgbana̱sa iꞌya a kapala ka Magono ma Zuba; u nala u ɗa wa woko kazuwamgbani ka aza a Isaraꞌila ubana a asu u Magono ma Zuba a ubana. ");
INSERT INTO kdl_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Iburodi i nala yi ya woko ta̱ u kunzu ku Haruna n alobo a ne, kpam a ka lya ta̱ iꞌya a asu u uwulukpi, kpaci kunzu ka ku lakai uwulukpi ka a asuvu a kune ku ilikulya ubana a asu u Magono ma Zuba. U ka̱na̱ ta̱ a rongo uyansa nala a ubana.>> ");
INSERT INTO kdl_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","A yan ta̱ vuma u roku uza ɗa tata u ne wa̱ri uza u Masar, mma u ne kpam uza u Samaꞌila uza u kala Shelomi, ukere u Dibiri a kagali ka Dan. Pini a asu u ɗa a shigba̱i agali yi, vuma vi u shila̱ka̱na̱i n uza u Samaꞌila u roku u wishai kpam kala ka Magono ma Zuba, aku a banka yi a asu u Musa. ");
INSERT INTO kdl_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","A ka̱na̱ yi ta̱ a gbagiryai, hal n a vani ili iꞌya Magono ma Zuba ma tonuko le. ");
INSERT INTO kdl_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Pini nala, Magono ma Zuba ma tonukoi Musa, ");
INSERT INTO kdl_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","<<Wutukpa̱ uza ɗa wisha mu vi ubana a uroto u agali yi, vu zuwa kpam gba̱ aza ɗa pana̱ka yi a taɗangu akere a le a kaci ka ne. Aku gba̱ kakuma̱ ka ama kpam ka vara̱sa yi n atali u kuwa̱. ");
INSERT INTO kdl_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Tonuko aza a Isaraꞌila: Gba̱ uza ɗa baci u wishai kala ka Kashila̱, u yan ta̱ unyushi kpam unyushi u nala vi wa̱ ta̱ a kaci ka ne. ");
INSERT INTO kdl_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Gba̱ uza ɗa baci dem u wishai kala ka Magono ma Zuba, gba̱ kakuma̱ ka ama ki ka vara̱sa yi ta̱ a wuna. Ko kamoci ka baci ko uza u iyamba, u wisha baci gai kala ka nala ki, u ka̱na̱ ta̱ a wuna yi. ");
INSERT INTO kdl_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","<<Uza ɗa baci u lapai vuma u wunai gbani-gbani, eyi dem u ka̱na̱ ta̱ a wuna yi. ");
INSERT INTO kdl_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Uza ɗa baci u wunai manama ma kuwa ma uza u roku, wa tsupa ta̱ ma n manama ma roku a una̱ u ma u wunai vi. Nala woko ta̱ mele, a tsupa uma n uma. ");
INSERT INTO kdl_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Uza u zumgba̱ baci utoku u ne, tyoku ɗa u yankai uza u ne vi nala dem a ka yanka yi. ");
INSERT INTO kdl_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","U koɗo yi baci katele, eyi dem a ka koɗo yi ta̱ katele. U foɗo yi baci keshi, eyi dem a ka foɗo yi ta̱ keshi. Kanga ka baci u takpa yi ka, eyi dem a ka takpa ta̱ ka ne. Icun i uzumgba̱ u ɗa u yankai uza u ne vi, u ɗa dem a ka yanka yi. ");
INSERT INTO kdl_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Uza ɗa baci dem u wunai manama ma kuwa, wa tsupa ta̱ ma n ma roku. Shegai uza ɗa baci u wunai vuma, eyi dem u ka̱na̱ ta̱ a wuna yi. ");
INSERT INTO kdl_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Ucun u afada a ɗa a ka yanka kamoci, a ɗa dem a ka yanka uza u iyamba, kpaci mpa Magono ma Zuba Kashila̱ ka ɗe.>> ");
INSERT INTO kdl_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","An Musa kotsoi kadyanshi n aza a Isaraꞌila, aku a bidyai vuma ɗa wishai kala ka Kashila̱ ki ubana a uroto u agali a vara̱sa yi she ukpa̱. Aza a Isaraꞌila a yain tyoku ɗa Magono ma Zuba ma tonukoi Musa. ");
INSERT INTO kdl_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Magono ma Zuba ma dansai n Musa a Masasa ma Sinai, u danai, ");
INSERT INTO kdl_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","<<Tonuko aza a Isaraꞌila: Aꞌayin a ɗa baci i uwa a uyamba u ɗa ma na̱ka̱ ɗa̱, u ka̱na̱ ta̱ i a̱sa̱ka̱ uyamba vi u wunvuga a kayen ka shindere dem tsa̱ra̱ a gorimuko Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Ya fuɗa ta̱ ya cimba ashina a ɗe, i kapusa kpam atyaci a cinwi a ɗe kpam i kapi ili iꞌya cei vi a asuvu a ayen a teli. ");
INSERT INTO kdl_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Shegai a kayen ka shindere, i a̱sa̱ka̱ uyamba vi u wunvugusa gba̱. Kayen ka a nekei ubana a asu u Magono ma Zuba ka. Ya cimba ashina a ɗe a asuvu a kayen ki wa, ya kapusa tani atyaci a cinwi a ɗe wa. ");
INSERT INTO kdl_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Ya kapa adende a ɗa a wuta̱i a ashina a ɗe, ko kpam i tai ilimaci i atyaci a cinwi iꞌya bawu i kapusai atyangi a le wa, kpaci kayen ka uyamba vi wa wunvugusa ve gba̱ ka. ");
INSERT INTO kdl_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Ko an u wokoi a cimbai uyamba vi a kayen ka nala ki wa, ya na̱ka̱ ɗa̱ ta̱ ilikulya eɗa̱ n agbashi a ɗe aka n aꞌali, n azamalinga a ɗe n amoci a ɗa a ka rongo n a̱ɗa̱. ");
INSERT INTO kdl_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","A ka a̱sa̱ka̱ ta̱ dem kuzuwate ku kuwa ku ɗe na̱ nnama n mete n lyai a asuvu a ilikulya iꞌya uyamba vi wa na̱ka̱. ");
INSERT INTO kdl_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","<<I keci ayen a uwunvuga a shindere kushindere, wata, kushindere kadoɓo kushindere, u ꞌya̱nga̱ la vi ayen amangare n kuci. ");
INSERT INTO kdl_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","A kain ka kupa a uwoto u shindere, Kain ka Utakpa u Unyushi u Cingi ka la vi. A ka fula̱ ta̱ kavana a kayen ka amangarenkupa, n kavana ka ka̱ri n mawura̱ cika gba̱ a uyamba vi. ");
INSERT INTO kdl_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Kayen ka nala ki, a ka neke ta̱ ka n uwulukpi. A ka yan ta̱ kpam kalamu ka Kayen ka Utsa̱ra̱ u Kaci ubana a asu u ama a ɗa aꞌa̱ri pini ndishi. Ka woko ɗa̱ ta̱ kayen ka utsa̱ra̱ u kaci, ya dem wa gono ta̱ a kuwa ku agadu ku ne, kagbashi dem ka gono ta̱ a asu u amaci a ne. ");
INSERT INTO kdl_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Kayen ka amangarenkupa ki ka woko ɗa̱ ta̱ Kayen ka Utsa̱ra̱ u Kaci. A asuvu a kayen ki, ya ce ili wa, ya kapa tani adende wa, ko i tai ilimaci i cinwi iꞌya i kapai atyangi a le wa. ");
INSERT INTO kdl_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Kayen ka Utsa̱ra̱ u Kaci ka, kpam u ka̱na̱ ta̱ i neke ka n uwulukpi. Ya fuɗa ta̱ i lyai ilimaci i adende yi. ");
INSERT INTO kdl_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","<<A Kayen ka Utsa̱ra̱ u Kaci ki, ya dem wa gono ta̱ a kuwa agadu ku ne. ");
INSERT INTO kdl_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Uza roku u denke baci utoku u ne uza u Samaꞌila uyamba, ko kpam u tsilai uyamba a asu u utoku vi, kotsu i ryafamgbana wa. ");
INSERT INTO kdl_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Va tsila baci uyamba ko kpam va denke utoku u vunu uza u Samaꞌila uyamba, she vu weɓele kakuma̱ ka ayen ka vu yankai uyamba vi manyan kahu Kayen ka Utsa̱ra̱ u Kaci ka kyawan. ");
INSERT INTO kdl_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Ayen a buwa baci ushani kahu Kayen ka Utsa̱ra̱ u Kaci ka kyawan, ikebe i uyamba yi ya yan ta̱ dem ushani. Ayen a ɗa a buwai aꞌa̱ baci ushani wa, nala dem ikebe yi ya yan ushani wa, kpaci uyamba vi denke ɗa a ka denke vu a kaci ka ayen ka va lya utsa̱ri u ne. ");
INSERT INTO kdl_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Adama a nala kotsu i ryafamgbana wa, shegai i pana uwonvo u va̱, kpaci mpa Magono ma Zuba Kashila̱ ka ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","<<Gorimukoi mele ma va̱ kpam i kirana n udani u va̱ i yanka u ɗa manyan, tsa̱ra̱ i dusuku ndishi yaa a uyamba vi. ");
INSERT INTO kdl_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Uyamba vi kpam wa matsa ta̱ ili, ya lya ta̱ i ciwa̱, kpam i dusuku ndishi yaa. ");
INSERT INTO kdl_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Gaawan ya wecike ta̱, i dana, <Ndya tsa lya a kayen ka shindere ki, an u wokoi tsa ce ili ko kpam tsa kapa icanga i kashina wa?> ");
INSERT INTO kdl_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Mpa Magono ma Zuba ma zuwuka ta̱ uyamba vi una̱ u shinga a kayen ka teli ki, tsa̱ra̱ uyamba vi u matsa ili ushani, iꞌya gba̱m ya lyatangu ɗa̱ hal ayen a tatsu. ");
INSERT INTO kdl_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Aꞌayin ɗa baci ya ce a kayen ka kulla̱, ya rongo ta̱ ulya ilikulya iꞌya i buwai i kayen ka teli. Ya rongo ta̱ ulya ilikulya i nala yi hal i savu i wuta̱ i kayen ka kuci. ");
INSERT INTO kdl_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","<<Ya denke uza u roku uyamba aku u ka̱na̱ u woko u ne gba̱ wa, kpaci uyamba vi u va̱ ɗa. Eɗa̱ amoci a ɗa aza a ndishi n tsumoci a asu u va̱. ");
INSERT INTO kdl_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Aꞌayin a ɗa baci dem ya denge uyamba, she i zuwamgbana kadyanshi ka uza u ili wa fuɗa wa wusa ili i ne. ");
INSERT INTO kdl_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","<<Utoku u vunu u woko baci mayali hal u ka̱na̱ yi u yain kazuwamgbani ka akopi n kapashi ka uyamba u ne ka roku, u ka̱na̱ ta̱ kumaci ku evu ku ne u tuwa̱ u wusa uyamba u ɗa u yankai kazuwamgbani ki. ");
INSERT INTO kdl_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Vuma ɗa yain kazuwamgbani ka akopi n uyamba vi wa̱ baci n uza ɗa wa wusuka yi u ɗa wa, aku u tuwa̱i u tsa̱ra̱i ikebe iꞌya wa fuɗa wa wusuka kaci ka ne, ");
INSERT INTO kdl_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","she u keci kakuma̱ ka ayen a ɗa a yain an a yain kazuwamgbani ka akopi n uyamba vi. Aku a keci ikebe yi a kaci ka ayen a ɗa a buwai kahu Kayen ka Utsa̱ra̱ u Kaci ka kyawan. Ikebe iꞌya i buwai vi a gonuko uza ɗa u tsilai uyamba vi, uyamba vi kpam a gonuko uza u ili. ");
INSERT INTO kdl_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ili iꞌya wa̱ri n iꞌya i rawa baci u wusi uyamba vi wa, uyamba vi wa rongo ta̱ a kukere ku uza ɗa u tsilai uyamba vi ubana Kayen ka Utsa̱ra̱ u Kaci. A kayen ka nala ki ka kpam a ka gonuko uza uyamba vi ili i ne. ");
INSERT INTO kdl_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","<<Uza u yan baci kazuwamgbani ka akopi n kuwa a ilyuci i pige iꞌya a kyawain n kasaga, wa fuɗa ta̱ wa wusa kuwa ki kayen ka kyawan baci. Asuvu a kayen ka te wa fuɗa ta̱ wa wusa. ");
INSERT INTO kdl_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Shegai uza u kuwa ka ka̱ri a ilyuci iꞌya a kyawain n kasaga ki u fuɗa baci u wusai kuwa ki asuvu a kayen ka te wa, uza ɗa tsilai kuwa ki ka woko ta̱ ku ne gba̱ ubana uyan u ne u kapala. A ka gonuko kuwa ki a Kayen ka Utsa̱ra̱ u Kaci wa. ");
INSERT INTO kdl_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Shegai aꞌuwa ɗa aꞌa̱ri a ine a ɗa a kyawain n kasaga wa, a ka kece ta̱ a ɗa tyoku ɗa a tsu yan n uyamba u ucimba. Wata, a ka fuɗa ta̱ a ka wusa a ɗa, kpam u ka̱na̱ ta̱ a gonuko a ɗa a asu u aza a ili a Kayen ka Utsa̱ra̱ u Kaci. ");
INSERT INTO kdl_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","<<Shegai ilyuci i pige iꞌya a na̱ka̱i aza a Levi, a ka fuɗa ta̱ a gono a wusa aꞌuwa a le a ɗa aꞌa̱ri ilyuci i le ko nwere ɗa baci. ");
INSERT INTO kdl_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Uza u Levi u denge baci kuwa asuvu a aꞌuwa a ne a ilyuci i pige i Levi, kpam a fuɗa a wusa kuwa ki wa, a ka gonuko ta̱ ka a Kayen ka Utsa̱ra̱ u Kaci, kpaci aꞌuwa a ilyuci i pige a aza a Levi a le a ɗa a asuvu a ama a le a aza a Isaraꞌila. ");
INSERT INTO kdl_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Shegai iyamba i kalina iꞌya i kyawain ilyuci i le yi a ka denge iꞌya wa, kpaci i le iꞌya a ubana. ");
INSERT INTO kdl_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","<<Utoku u vunu u ɗa wa̱ri evu n avu u woko baci mayali kpam u fuɗa u ɓa̱nga̱ kaci ka ne wa, u ka̱na̱ ta̱ vu ɓa̱nga̱ yi tyoku ɗa va ɓa̱nga̱ kamoci, tsa̱ra̱ u lyai kapala na̱ ndishi n avu. ");
INSERT INTO kdl_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Kotsu vu na̱ka̱ yi akopi aku vu cigi kapashani wa, shegai vu pana uwonvo u Kashila̱ ka vunu, vu a̱sa̱ka̱ utoku u vunu u dusuku n avu. ");
INSERT INTO kdl_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Va na̱ka̱ yi akopi a ikebe aku vu zuwa aꞌeshi u na̱ka̱ vu n kapashani wa, ko kpam vu denke yi ilikulya aku vu zami kapashani wa. ");
INSERT INTO kdl_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Mpa Magono ma Zuba Kashila̱ ka ɗe uza ɗa u wutukpa̱ ɗa̱ a uyamba u Masar, tsa̱ra̱ n na̱ka̱ ɗa̱ uyamba Kaꞌana n woko kpam Kashila̱ ka ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","<<Uza u te asuvu a atoku a vunu u woko baci mayali hal u dengei kaci ka ne ara vunu, kotsu vu ma̱tsa̱ yi u yanka vu manyan yavu kagbashi wa. ");
INSERT INTO kdl_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Shegai wa dusuku ta̱ kaɓolo n avu u woko yavu zamalinga u vunu ko kamoci ka vunu, u yansa̱ka vu manyan hal Kayen ka Utsa̱ra̱ u Kaci ka kyawan. ");
INSERT INTO kdl_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Asuvu a aꞌayin nala yi a ɗa eyi n alobo a ne a ka ꞌya̱nga̱ a gono a asu u kumaci ku le, a asu u agadu a ikaya i le. ");
INSERT INTO kdl_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Kpaci aza a Isaraꞌila agbashi a va̱ a ɗa, aza ɗa n wutukpa̱i a uyamba u Masar. A ka denge le tyoku u agbashi wa. ");
INSERT INTO kdl_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Va lya tsugono a kaci ka le n vu yansi le mavura wa, shegai vu pana uwonvo u Kashila̱ ka vunu. ");
INSERT INTO kdl_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","<<Shegai va ciga baci agbashi aꞌali ko aka, va fuɗa ta̱ va tsila le a asu u iyamba iꞌya iꞌa̱ri ukyawin n avu. ");
INSERT INTO kdl_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Va fuɗa ta̱ kpam va tsila agbashi asuvu a amoci a ɗa aꞌa̱ri ndishi kaɓolo n a̱ɗa̱, n aza a kuwa a le a ɗa a matsai a uyamba u ɗe. A ka woko ta̱ utsa̱ri u vunu. ");
INSERT INTO kdl_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Va fuɗa ta̱ va gonuko le ili i agadu a asu u mmuku n vunu, tsa̱ra̱ a woko utsa̱ri u le. A ka woko le ta̱ kpam agbashi gba̱. Shegai ukuna u atoku a ɗe aza a Isaraꞌila, uza u roku wa fuɗa wa lya tsugono a kaci ku uza u roku n u yan yi mavura wa. ");
INSERT INTO kdl_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","<<Kamoci ka ka̱ri asuvu a ɗe u woko baci uza u utsa̱ri, aku utoku u ɗe uza u Samaꞌila u wokoi mayali, hal u dengei kaci ka ne a asu u kamoci ki, ko kpam uza u roku a kuwa ku kamoci ki, ");
INSERT INTO kdl_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","a ka fuɗa ta̱ a wusa vuma u aza a Isaraꞌila vi. Uza u te a asuvu a atoku a ne a evu wa fuɗa ta̱ wa wusa yi, ");
INSERT INTO kdl_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ko tatapige ko tatakenu u ne ko kpam maku ma utoku u tata u ne, ko tani kpam uza roku asuvu a kumaci ku ne ku evu. Eyi n kaci ka ne dem wa fuɗa ta̱ u wusa kaci ne wa̱ baci n ikebe. ");
INSERT INTO kdl_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Eyi n uza ɗa tsila yi vi, ɗa a ka kece ikebe yi. Kakuma̱ ka ikebe ka a ka tsupa adama a utsa̱ra̱ u kaci u ne a ka kece ta̱ kakuma̱ ka ayen ka ka buwai kahu Kayen ka Utsa̱ra̱ u Kaci ka kyawan. A ka kece ta̱ ikebe yi dere tyoku ɗa a tsu tsupa zamalinga. ");
INSERT INTO kdl_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Ayen a ɗa a buwai vi a yan baci ushani, wa tsupa ta̱ ikebe yi evu n kakuma̱ ka ikebe ka u wushai an u dengei kaci ka ne ki. ");
INSERT INTO kdl_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Shegai ayen a ɗa buwai kenu ɗa baci aꞌa̱ri kahu Kayen ka Utsa̱ra̱ u Kaci, wa tsupa ta̱ ikebe i kenu adama a utsa̱ra̱ u kaci u ne. ");
INSERT INTO kdl_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Kamoci ki ka tono ta̱ n uza u Samaꞌila tyoku u zamalinga ɗa u bidyai manyan ma ayen ayen. Kotsu i a̱sa̱ka̱ yi u lyai tsugono a kaci ka utoku u ɗe n u yan yi mavura wa. ");
INSERT INTO kdl_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","<<A fuɗa baci a wusa yi a ire i na yi wa, a ka a̱sa̱ka̱ yi ta̱ u wuta̱ kaɓolo n alobo a ne a Kayen ka Utsa̱ra̱ u Kaci. ");
INSERT INTO kdl_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Kpaci aza a Isaraꞌila agbashi a va̱ a ɗa, ele agbashi a va̱ a ɗa aza ɗa n wutukpa̱i a uyamba u Masar. Mpa Magono ma Zuba Kashila̱ ka ɗe.>> ");
INSERT INTO kdl_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Magono ma Zuba ma danai, <<Kotsu i sheke kaci ka ɗe kameli, ko urotsoni u ili i roku, ko i shigba̱ katali ka ulyaka u kayala, ko tani i shei atali a ulyaka kayala wa, kpaci mpa Magono ma Zuba Kashila̱ ka ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","U ka̱na̱ ta̱ i kirana n aꞌayin a Ashibi a va̱ kpam i pana uwonvo u kuwa ku uwulukpi ku va̱. Mpa Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","<<I tono baci mele ma va̱, ya gorimuko kpam udani u va̱, ");
INSERT INTO kdl_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ma roko ɗa̱ ta̱ mini ma zuba aꞌayin a yan baci, iyamba kpam ya matsa ta̱ ilimaci i shinga, nɗanga kpam ma matsa̱sa ta̱. ");
INSERT INTO kdl_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Ucanga u kashina u ɗe wa yan ta̱ ushani ubana aꞌayin a uta ilimaci i cinwi, ya rongo ta̱ uɓolomgbonuso ilimaci i cinwi she ubana aꞌayin a uce a roku. Ya rongo ta̱ ulyasa ilikulya i ɗe she i ciwa̱, i dusuku kpam a uyamba u ɗe yaa. ");
INSERT INTO kdl_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","<<Ma na̱ka̱ ta̱ uyamba u ɗe ndishi n shinga, ya vaku ta̱ ya pana uwonvo u ili i roku wa. Ma wutukpa̱ ta̱ nnama n mete n cingi asuvu a uyamba u ɗe, kpam ko uza wa doku wa tuko uyamba u ɗe kuvon wa. ");
INSERT INTO kdl_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Ya loko ta̱ atokulalu a ɗe, kpam a ka rukpa̱ ta̱ a kapala ka ɗe n ucira u iburundu. ");
INSERT INTO kdl_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Ama a ɗe a tawun a ka loko ta̱ ama a le amangatawun, ama a ɗe amangatawun a ka loko ta̱ ama a le azu kupa. Atokulalu a ɗe a ka rukpa̱ ta̱ a kapala ka ɗe n ucira u iburundu. ");
INSERT INTO kdl_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","<<Ma wenike ɗa̱ ta̱ uciga, n zuwa ɗa̱ i matsa̱sa cika i yain kakuma̱, kpam ma shaɗangu ta̱ kazuwamgbani ka n yain n a̱ɗa̱. ");
INSERT INTO kdl_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Ucanga u kashina u ɗe wa yan ta̱ kakuma̱, i cina gba̱m pini i kayen ka ka wurai, she i wutukpa̱ i cau yi kahu i tsa̱ra̱ kabala ka ya zuwa i savu. ");
INSERT INTO kdl_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ma rongo ta̱ kaɓolo n a̱ɗa̱ kpam ma pana ɗa̱ icaɗi wa. ");
INSERT INTO kdl_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Ma wala ta̱ kaɓolo n a̱ɗa̱ n woko Kashila̱ ka ɗe, eɗa̱ kpam i woko ama a va̱. ");
INSERT INTO kdl_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Mpa Magono ma Zuba Kashila̱ ka ɗe, uza ɗa wutukpa̱ ɗa̱ a uyamba u Masar, tsa̱ra̱ kotsu i lyai kapala n uwoko agbashi a le wa. N takpai ara̱ji a ɗa aꞌa̱ri a ꞌyanku ɗa̱ vi, n zuwa ɗa̱ ya wala yaa. ");
INSERT INTO kdl_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","<<Shegai i pana̱ka mu baci wa, kpam i kpa̱ɗa̱i utono gba̱ udani u va̱, ");
INSERT INTO kdl_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","i ꞌyuwan baci utono mele ma va̱, i goroi udani u va̱, kpam i ꞌyuwain utono kadyanshi ka va̱, i koɗoi kpam kazuwamgbani ka va̱, ");
INSERT INTO kdl_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","mavura ma ma yan ɗa̱ ma na: Ma sukunku ɗa̱ ta̱ upana u ikyamba u pige, na̱ mɓa̱la̱ icun kau-kau n ɗa bawu ma ta̱na̱, n usuɗugbi u ikyamba u ɗa wa zuwa ɗa̱ i woko arumba̱, aku i rongo uramba. Iceshi i ɗe ya woko ta̱ i gbani, kpaci atokulalu a ɗe a ɗa a ka tuwa̱ a lyai iꞌya. ");
INSERT INTO kdl_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Ma yan ta̱ tsilala n a̱ɗa̱, n zuwa kpam atokulalu a ɗe a lya ɗa̱ n kuvon. Aza ɗa a ka kovo ɗa̱ a ka lya ta̱ tsugono a kaci ka ɗe, ya rongo ta̱ ilyaɗi bawu uza ɗa wa loko ɗa. ");
INSERT INTO kdl_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","<<Shegai gba̱ n nala, i pana̱ka mu baci wa, ma doku ta̱ mavura ma nala mi kadoɓo kushindere adama a unyushi u cingi u ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Ma takpa ta̱ uryagbaji u ɗa wa zuwusa ɗa̱ ara̱ɗi yi, n ɓishinka ɗa̱ mini ma zuba, uyamba u ɗa kpam ya cimba vi wa ekpe ta̱ u woko magbata. ");
INSERT INTO kdl_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Ko niɗa baci i ma̱tsa̱i manyan, ma woko ta̱ ma gbani, kpaci uyamba u ɗe wa matsa kpam ili wa, nɗanga ma uyamba u ɗe dem ma matsa kpam wa. ");
INSERT INTO kdl_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","<<I lya baci kapala n uꞌya̱nga̱sa̱ka̱ mu, i ꞌyuwan mu upana̱ka, ma doku ta̱ upana u ikyamba u ɗe kadoɓo kushindere adama a unyushi u cingi u ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Ma sukunku ɗa̱ ta̱ nnama n mete n cingi n ɗa ma wuna mmuku n ɗe, n wacinsa kuzuwate ku kuwa ku ɗe n zuwa ɗa̱ i woko kenu kpam ire i ɗe ya yan n ama wa. ");
INSERT INTO kdl_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","<<Gba̱ mavura ma na mi, ma kpa̱ɗa̱ ɗa̱ baci uzuwa i gono ara va̱, kpam i lyai kapala n uꞌya̱nga̱sa̱ka̱ mu, ");
INSERT INTO kdl_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","mpa dem ma lya ta̱ kapala n uyan tsilala n a̱ɗa̱, n kaci ka va̱ ka ma yan ɗa̱ mavura she ma la ma cau kadoɓo kushindere adama a unyushi u cingi u ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Ma tuko ɗa̱ ta̱ kuvon n yan ɗa̱ mavura adama a kazuwamgbani ka va̱ ka i koɗoi. I ɓolomgbono baci a asuvu a ilyuci i pige tsa̱ra̱ i kpawan, ma sukunku ɗa̱ ta̱ usaru kpam n zuwa ɗa̱ i na̱ka̱ngu kaci ka ɗe a asu u atokulalu a ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Ma kimba̱ ta̱ ure u utsa̱ra̱ u ilikulya i ɗe, tsa̱ra̱ aka kupa a yain ilikulya i ɗe a kalele ka te, a kenishike ɗa̱ iꞌya ura̱tsana̱sa̱ki; kpam ya lya ya cuwa̱ wa. ");
INSERT INTO kdl_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","<<Gba̱ mavura ma na mi, i ꞌyuwan mu baci ugorimuko, i lyai kpam kapala n uꞌya̱nga̱sa̱ka̱ mu, ");
INSERT INTO kdl_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","mpa dem ma lya ta̱ kapala n uyan tsilala n a̱ɗa̱ n asuvu a shen cika. Mpa n kaci ka va̱ ka ma yan ɗa̱ mavura ma gba̱m ma lai ma cau kadoɓo kushindere adama a unyushi u cingi u ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Ya rongo ta̱ utakuma inyama i mmuku n ɗe adama a kambulu ka pige. ");
INSERT INTO kdl_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","N wa̱sa̱sa̱ a asu u ulyasa̱ka ameli a ɗe kayala, n wacinsa asuɗara̱kpa u urunukpusa ili i magula̱ni u ɗe, n taɗamgbana̱sa akushe a ɗe a zuba u ameli a ɗe a ɗa bawu aꞌa̱ri n uma, n pana ɗa̱ icaɗi. ");
INSERT INTO kdl_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","N wa̱sa̱sa̱ ilyuci i ɗe i woko akpongo, n wacinsa asuɗara̱kpa u ameli a ɗe. Ma doku ma ciga magula̱ni ma shinga ma uɗara̱kpa u ɗe wa. ");
INSERT INTO kdl_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","N wacinsa uyamba u ɗe gba̱, kpam atokulalu a ɗe aza ɗa aꞌa̱ri pini na̱ ndishi a pana uwonvo u uwacinsa u nala vi. ");
INSERT INTO kdl_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","N zuwa a tuko ɗa̱ kuvon, a wacinsa ɗa̱ gba̱ a iyamba kau-kau. N zuwa uyamba u ɗe u woko akpongo, ilyuci i ɗe kpam i namgba. ");
INSERT INTO kdl_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Pini nala ɗa uyamba u ɗe wa tsa̱ra̱ uwunvuga u ɗa u shaɗangi, an u wokoi iꞌa̱ri kpam pini wa, iꞌa̱ri ɗe a asu u tsuwula̱ a iyamba i atokulalu a ɗe. Uyamba vi wa yan ta̱ ayen ayen n u wunvugusi ucun u uwunvuga u ɗa u kpa̱ɗa̱i utsa̱ra̱ aꞌayin a ɗa iꞌa̱ri pini. ");
INSERT INTO kdl_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Uyamba vi u woko baci akpongo, wa wunvugusa ta̱ uwunvuga u ɗa u kpa̱ɗa̱i utsa̱ra̱ aꞌayin a ɗa iꞌa̱ri pini na̱ ndishi. ");
INSERT INTO kdl_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","<<Shegai aza roku a asuvu a ɗe aza ɗa a buwai n uma, ma zuwa ta̱ uwonvo u shaɗangu atakasuvu a ɗe a uyamba u atokulalu a ɗe yi, ijingi i kavuku gba̱m ya zuwa ɗa̱ ta̱ ilyaɗi. Ya rongo ta̱ ilyaɗi n i rukpusi yavu aza ɗa a ka loko n kuvon, ko an u wokoi ko uza wa tono ɗa̱ wa. ");
INSERT INTO kdl_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Ya rongo ta̱ a magamani n i rukpusi yavu aza ɗa a ka tono n kuvon, ko an u wokoi ko uza wa tono ɗa̱ wa. Ya tsa̱ra̱ ucira u ɗa ya shamgba i shila̱ka̱na̱ n atokulalu a ɗe wa. ");
INSERT INTO kdl_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Ya kuwa̱ ta̱ a uyamba kau-kau u tsuwula̱, uyamba u atokulalu a ɗe wa lya ɗa̱ ta̱. ");
INSERT INTO kdl_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Aza a ɗa a buwai asuvu a ɗe yi, a ka rongo ta̱ ukotso sawu a uyamba u atokulalu a ɗe adama a unyushi u cingi u ɗe n unyushi u cingi u ikaya i ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","<<Shegai mmuku n tsikaya n ɗe ma dansa ta̱ unyushi u cingi u le, n unyushi u cingi u ikaya i le aza ɗa a lyai kapala n uꞌya̱nga̱sa̱ka̱ mu, kpam a kpa̱ɗa̱ mu uyanka ukuna u maci. ");
INSERT INTO kdl_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Adama a nala a ɗa i zuwai mpa dem n lyai kapala n uyan tsilala n ele, hal n tutsuku le tsuwula̱ a uyamba u atokulalu a le. A makorishi, mmuku n tsikaya n le n savaɗa baci atakasuvu a uryagbaji a le, a wushuki n mavura ma unyushi u le, ");
INSERT INTO kdl_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ma ciɓa ta̱ n kazuwamgbani ka n yain n Yakubu n Ishaku n Ibirahi, n ciɓa kpam n uyamba vi. ");
INSERT INTO kdl_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Shegai u ka̱na̱ ta̱ uyamba vi u woko akpongo tsa̱ra̱ u wunvuga uwunvuga u maci, kpam a yan le mavura adama a ɗa a goroi udani u va̱ kpam a ꞌyuwain mele ma va̱. ");
INSERT INTO kdl_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Gba̱ n nala, aꞌayin a ɗa iꞌa̱ri a uyamba u tsuwula̱ vi, ma ꞌyuwan ɗa̱ wa, ma pana ɗa̱ tani icaɗi n wacinsa ɗa̱ gba̱ wa. Ma koɗo kazuwamgbani ka va̱ n a̱ɗa̱ wa, kpaci mpa Magono ma Zuba Kashila̱ ka ɗe. ");
INSERT INTO kdl_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Adama a nala, ma ciɓa ta̱ n kazuwamgbani ka n yain n ikaya i ɗe, aza ɗa n wutukpa̱i a uyamba u Masar a kapala ka aletsu a ama ɗa a buwai, tsa̱ra̱ n woko Kashila̱ ka le. Mpa Magono ma Zuba.>> ");
INSERT INTO kdl_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Nala mele ma, n udani, n uwenishike u ɗa Magono ma Zuba ma yain a mere ma ne n aza a Isaraꞌila a una̱ u Musa a Masasa ma Sinai. ");
INSERT INTO kdl_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Magono ma Zuba ma tonukoi Musa, ");
INSERT INTO kdl_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","<<Tonuko aza a Isaraꞌila udani u na vi: Aꞌayin a ɗa baci dem uza u tsinai u neke vuma ubana a asu u Magono ma Zuba, aku u tuwa̱i wa ciga u wusa yi, ");
INSERT INTO kdl_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","tyoku ɗa a ka ra̱tsana̱ka kakuma̱ ka ikebe i azurufa i vuma yi a ili i ura̱tsana̱ka iꞌya a ka yansa̱ka manyan a kuwa ku uwulukpi ɗa na: Vali ɗa baci u yain ayen kamanga ubana ayen amangatatsu, a tsupa ikebe i azurufa amangarenkupa. ");
INSERT INTO kdl_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Uka ɗa baci u yain ayen kamanga ubana amangatatsu, a tsupa ikebe i azurufa kamankupa. ");
INSERT INTO kdl_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Kalobo ka baci ka yain ayen a tawun ubana kamanga, a tsupa ikebe i azurufa kamanga, maku ma uka ma baci, a tsupa ikebe i azurufa kupa. ");
INSERT INTO kdl_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Maku ma vali ma baci ma yain uwoto u te ubana ayen a tawun, a tsupa ikebe i azurufa u tawun, maku ma uka ma baci, a tsupa ikebe i azurufa u tatsu. ");
INSERT INTO kdl_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Vali ɗa baci u lai ayen amangatatsu, a tsupa ikebe i azurufa kupa n u tawun, uka ɗa baci, a tsupa ikebe i azurufa kupa. ");
INSERT INTO kdl_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Vuma vi mayali ma baci cika, kpam u kpa̱ɗa̱i utsupa ili iꞌya a kiɗumkpai, she u banka vuma ɗa u tsinai a kaci ka ne ki a asu u kaɗara̱kpi, kaɗara̱kpi ki ka kiɗumkpa kakuma̱ ka ikebe i vuma yi dere n ucira u vuma ɗa u tsinai vi. ");
INSERT INTO kdl_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","<<Utsina vi u ka̱na̱ baci u manama ma ma gain a na̱ka̱ Magono ma Zuba ma, kune ki ku ka̱na̱ ta̱ ku woko ka uwulukpi. ");
INSERT INTO kdl_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Uza u utsina vi wa shuwandana manama mi ko u savaɗa n ma roku wa, wata, wa shuwandana ma ma lobonoi n ma ma kpa̱ɗa̱i ulobono wa, ko tani ma bawu ma lobonoi n ma ma lobonoi wa. U ka̱na̱ baci u yain nala, gba̱ nnama n re mi she n woko n ɗa ma̱ri uwulukpi. ");
INSERT INTO kdl_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Shegai utsina vi u ka̱na̱ baci manama ma nshinda̱ ma ma gain a na̱ka̱ Magono ma Zuba kune wa, uza vi u ka̱na̱ ta̱ u banka manama mi a asu u kaɗara̱kpi. ");
INSERT INTO kdl_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Kaɗara̱kpi ka ra̱tsana̱ka ta̱ kakuma̱ ka ikebe i manama yi dere tyoku ɗa ikebe i ne ya ka̱na̱, aku u tonuko uza vi ili iꞌya wa tsupa. Ikebe iꞌya baci dem kaɗara̱kpi ki ka kiɗumkpai, i shamgba ta̱. ");
INSERT INTO kdl_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Shegai uza vi wa ciga baci u wusa manama mi, she u doku kunzu ku te a asuvu a kunzu ku tawun ka ili iꞌya a zuwai vi. ");
INSERT INTO kdl_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","<<Uza u neke baci kuwa ku ne n uwulukpi ubana a asu u Magono ma Zuba, u ka̱na̱ ta̱ kaɗara̱kpi ka ra̱tsana̱ka kakuma̱ ka ikebe i kuwa yi, ko ka ku lobonoi ko kpam ka ku lobonoi wa. Ikebe iꞌya baci dem kaɗara̱kpi ki ka kiɗumkpai, i shamgba ta̱. ");
INSERT INTO kdl_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Uza ɗa nekei kuwa ki wa ciga baci u gono u wusa ka, she u doku kunzu ku te a asuvu a kunzu ku tawun ka ikebe iꞌya a kiɗumkpai vi. Aku kuwa ki ku woko ku ne. ");
INSERT INTO kdl_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","<<Uza u neke baci kapashi ka kashina ka agadu ka ne n uwulukpi ubana a asu u Magono ma Zuba, she a kiɗumkpa ikebe i kashina yi a kaci ka kakuma̱ ka icun iꞌya a ka fuɗa a cei pini a kashina ki. A kiɗumkpa ikebe i akundatsu a kuden kamanga i ilya i bale dem ikebe i azurufa kupa. ");
INSERT INTO kdl_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","U neke baci kashina ki a asuvu a Kayen ka Utsa̱ra̱ u Kaci, ikebe iꞌya a tonuko yi vi ya shamgba ta̱. ");
INSERT INTO kdl_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Shegai u neke baci kashina ki cina Kayen ka Utsa̱ra̱ u Kaci vi ka wurai, she kaɗara̱kpi ka kiɗumkpa kakuma̱ ka ikebe ki a kaci a ayen a ɗa a buwai kahu Kayen ka Utsa̱ra̱ u Kaci ka roku ka kyawan. Aku a jebe kakuma̱ ka ikebe yi. ");
INSERT INTO kdl_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Uza ɗa nekei kashina ki wa ciga baci u wusa ka, she u doku kunzu ku te a asuvu a kunzu ku tawun ka ili iꞌya a kiɗumkpai vi, aku kashina ki ka woko ka ne. ");
INSERT INTO kdl_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Shegai u wusa baci kashina ki wa, kpam u denkei ka uza u roku, wa wusa kpam ka wa. ");
INSERT INTO kdl_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","An u wokoi u wusai kashina ki wa, a asuvu a Kayen ka Utsa̱ra̱ u Kaci, kashina ki ka woko ta̱ ili iꞌya a nekei gba̱ n uwulukpi ubana a asu u Magono ma Zuba ka bawu a ka fuɗa a ka wusa ka kpam, aku ka woko kashina ka aɗara̱kpi. ");
INSERT INTO kdl_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","<<Uza u neke baci kashina ka u tsilai n ikebe ka ka̱ri agadu a ne wa, ubana a asu u Magono ma Zuba, ");
INSERT INTO kdl_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","kaɗara̱kpi ka kiɗumkpa ta̱ ikebe i kashina yi a kaci ka ayen a ɗa a buwai kahu Kayen ka Utsa̱ra̱ u Kaci ka roku ka kyawan. Uza vi wa tsupa ta̱ ikebe yi tyoku ɗa a kiɗumkpai iꞌya kain ki. Kune ka uwulukpi ka la vi ubana a asu u Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Asuvu a Kayen ka Utsa̱ra̱ u Kaci ki, kashina ki ka gono ta̱ ka uza ɗa a tsilai ka a kukere ku ne, uza ɗa kashina ki ka̱ri agadu a ne yi. ");
INSERT INTO kdl_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","A ka kiɗumkpa ta̱ gba̱ ikebe iꞌya a ka tsupa vi a kaci ka ili i ura̱tsana̱ka iꞌya a tsu yansa̱ka manyan a kuwa ku uwulukpi. ");
INSERT INTO kdl_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","<<Shegai ilimaci i kagita̱ i manama ma kuwa ma baci, wata, kanaka ko macon i Magono ma Zuba iꞌya, adama a nala va neke iꞌya wa, kpaci i Magono ma Zuba iꞌya a kagita̱. ");
INSERT INTO kdl_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Manama mi ma nshinda̱ ma baci, a ka fuɗa ta̱ a ka wusa ma a kaci ka kakuma̱ ka ikebe ka kaɗara̱kpi ka kiɗumkpai, kaɓolo n kunzu ku te a asuvu a kunzu ku tawun. A wusa baci ma wa, kaɗara̱kpi ka denge ta̱ ma a kakuma̱ ka ikebe ka a kiɗumkpai vi. ");
INSERT INTO kdl_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Ili iꞌya dem vuma nekei gba̱, wata, ko vuma ko manama ko kapashi ka kashina ka ne ubana a asu u Magono ma Zuba, a ka denge kpam iꞌya ko a wusa iꞌya wa, kpaci i woko ɗe i uwulukpi cika a asu u Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","A neke baci vuma gba̱ adama a uwuna, a ka wusa yi wa. U ka̱na̱ ta̱ a wuna yi. ");
INSERT INTO kdl_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","<<Ili i te asuvu a kupa iꞌya baci dem a wutukpa̱i, wata, ilya ko ilimaci i nɗanga, i Magono ma Zuba iꞌya. Gba̱ ili i nala yi iꞌa̱ ta̱ n uwulukpi ubana a asu u Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Uza ɗa baci dem wa ciga u wusa ili i te asuvu a kupa iꞌya u nekei, u ka̱na̱ ta̱ u tsupa ikebe i ili yi aku u doku kunzu ku te a asuvu a kunzu ku tawun. ");
INSERT INTO kdl_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Gba̱ ili i te a asuvu a kupa i ushiga u anaka, ko u ncon ko u nryaɗiga i Magono ma Zuba iꞌya. A ka kece baci nnama, ma baci ma rukpa̱i ma kupa a asu u ukece, ma woko ta̱ ma uwulukpi ubana a asu u Magono ma Zuba. ");
INSERT INTO kdl_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","A ka ɗanga̱sa manama adama a tsulobo tsu ne ko tani a adama a ukpa̱ɗa̱ u tsulobo tsu ne wa, a ka savaɗa tani n ma roku wa. A savaɗa baci manama n ma roku, n re gba̱ ma woko ta̱ n uwulukpi, a ka fuɗa a ka wusa n ɗa wa.>> ");
INSERT INTO kdl_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Mele ma Magono ma Zuba ma na̱ka̱i Musa ubana a asu u aza a Isaraꞌila a Masasa ma Sinai ma la vi.");
INSERT INTO kdl_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Aꞌayin a ɗa aza a afada a ka lya tsugono tsu aza a Isaraꞌila, a yan ta̱ vuma roku uza u kala Elimele, kala ka uka u ne ka Naꞌomi, aꞌa̱ ta̱ kpam na̱ mmuku ma alobo n re, Malo n Kiliyo, gba̱ le a kagali ka aza a Efurata, a ilyuci i Batalami a uyamba u Yahuda. An a ka yan kambulu ka pige a uyamba vi, u ꞌya̱nga̱i ubana a uyamba u Muwabu, eyi n uka u ne na̱ mmuku n ne a ba a dusuki ve ɗe. ");
INSERT INTO kdl_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","An a yain aꞌayin, vali u Naꞌomi vi u tuwa̱i u kuwa̱i, u a̱sa̱ka̱ yi na̱ alobo a re yi. ");
INSERT INTO kdl_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Alobo yi ama a re a le gba̱ a zuwai nkere ma uyamba u Muwabu. Uza u te zuwai uka uza u kala Orfa, uza u ire kpam u zuwai uza u kala Rutu. Shegai ubana ayen kupa ele pini a uyamba vi, ");
INSERT INTO kdl_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","aku Malo n Kiliyo a kuwa̱i. Pini nala, Naꞌomi wokoi utyoku u ne, vali wa̱ la wa kpam dem mmuku ma̱ la wa. ");
INSERT INTO kdl_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Aꞌari pini, Naꞌomi tuwa̱i u panai a da Magono ma Zuba ma ɓa̱nga̱ ɗe ama a ne aza a Isaraꞌila u na̱ka̱ le ilikulya. Adama a nala, u foɓusoi n ajene a ne a a̱sa̱ka̱ Muwabu a gono a kuwa. ");
INSERT INTO kdl_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Eyi n ajene a ne yi a a̱sa̱ka̱i asu u ɗa aꞌa̱ri ndishi vi, a ka̱na̱i ure ugono a Yahuda. ");
INSERT INTO kdl_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Ele pini a nwalu, aku Naꞌomi tonukoi ajene yi, <<Walai i gono aꞌuwa a isheku i ɗe. Magono ma Zuba ma wenike ɗa̱ uciga tyoku ɗa i wenikei aꞌali a ɗe na̱ mpa. ");
INSERT INTO kdl_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Magono ma Zuba kpam ma zuwa i tsa̱ra̱ aꞌali, i tsa̱ra̱ kpam uwunvuga a aꞌuwa a ɗe.>> Aku u woɓo le, u tonuko le, <<U yan tsu ben.>> A gita̱i kushen cika, ");
INSERT INTO kdl_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","a tonuko yi, <<Aꞌa! Tsa bana ta̱ dem a asu u ama a vunu.>> ");
INSERT INTO kdl_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Shegai Naꞌomi danai, <<Mmuku n va̱, gonoi a aꞌuwa a ɗe. Ndya i zuwai ya ciga i bana kaɓolo na̱ mpa? Mpa n buwa kpam ilimaci hal ma fuɗa ma matsa̱ka ɗa̱ aꞌali a ɗa a ka sotuku ɗa̱ wa. ");
INSERT INTO kdl_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Mmuku n va̱, walai i gono, mpa n yan ɗe mamici, n buwa kpam uyan iyolo wa. Ko ma̱ baci gba̱m n maluwa ma iyolo i roku, a dana gba̱m ma tsa̱ra̱ vali n kayin ka na ki, hal n matsa mmuku ma aꞌali, ");
INSERT INTO kdl_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","ya fuɗa ya vana hal a gbonguro? Ya ꞌyuwan uyan iyolo adama a le? Nala wa yan wa, mmuku n va̱, unamgbukatsuma̱ u va̱ u la ta̱ u ɗe cika, kpaci Magono ma Zuba ma ma ronuko mu upana u ikyamba u na vi.>> ");
INSERT INTO kdl_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Aku a doki a gita̱i kushen cika. Pini nala, Orfa woɓoi anuku a ne, u tonuko yi u yan tsu ben, aku u lazai ugono a kuwa. Shegai Rutu gbagbalai Naꞌomi vi u ma̱tsa̱i she u bana kaɓolo n eyi. ");
INSERT INTO kdl_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Aku Naꞌomi tonuko yi, <<Wundya na, utoku u vunu ɗa wa laza ɗe ugono a asu u ama a ne n a asu u ameli a ne. Wala vu tono yi.>> ");
INSERT INTO kdl_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Shegai Rutu danai, <<Kotsu vu folo mu n gono ko n a̱sa̱ka̱ vu utono wa. A asu u ɗa baci dem vu banai, ma bana ta̱. A asu u ɗa baci dem vu dusuki, nte dem ma dusuku pini. Ama a vunu a ka woko ta̱ ama a va̱, Kashila̱ ka vunu kpam ka woko ta̱ Kashila̱ ka va̱. ");
INSERT INTO kdl_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","A asu u ɗa baci vu kuwa̱i, nte ma kuwa̱ pini, kpam nte dem a ka ciɗa̱ngu mu pini. Ili i roku i pece mu n avu, bamu n ukpa̱, n folo ta̱ Magono ma Zuba ma yan mu mavura cika.>> ");
INSERT INTO kdl_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","An Naꞌomi wenei Rutu zuwa ta̱ uma u ne u toni yi, aku u a̱sa̱ka̱ yi utonusuko u gono. ");
INSERT INTO kdl_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Aku a lyai kapala na̱ nwalu, hal a rawai a ilyuci i Batalami. An a uwai, aku gba̱ ama yi a yain maza̱nga̱ cika adama a le. Aka a ilyuci yi a danai, <<Naꞌomi ɗa gba̱m naha vi?>> ");
INSERT INTO kdl_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","U wushunku le, <<Kotsu i doku i isa̱ mu Naꞌomi wa, shegai Mara, kpaci Kashila̱ Uza u Ucira Gba̱ u na̱ka̱ mu ta̱ unamgbukatsuma̱ cika. ");
INSERT INTO kdl_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","An n lazai, ma̱ ta̱ gba̱ n ili iꞌya ma ciga, shegai gogo-na Magono ma Zuba ma gonuko mu ɗe a kuwa akere a de. Niɗa ya isa̱ mu Naꞌomi cina Magono ma Zuba ma kpatala̱ka mu ɗe kucina̱, kpam Uza u Ucira Gba̱ u sukunku mu mada̱ka̱?>> ");
INSERT INTO kdl_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Tyoku ɗa a yain Naꞌomi gonoi a uyamba u ne ɗa la vi, kaɓolo n kajene ka ne Rutu uza u Muwabu. An a rawai a Batalami, cina a gita̱ ɗe manyan ma ilya i bale. ");
INSERT INTO kdl_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","A yan ta̱ vuma u roku vuma u pige kpam uza u utsa̱ri a ilyuci i Batalami uza u kala Boza, kumaci ku vali u Naꞌomi, wata, Elimele. ");
INSERT INTO kdl_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Kain ka te, Rutu uza u Muwabu u tonukoi Naꞌomi, <<A̱sa̱ka̱ n bana kuꞌyaru ku ilya a kashina ka uza ɗa baci dem u wushunku mu n yain.>> Aku Naꞌomi danai, <<Maku ma va̱, wala.>> ");
INSERT INTO kdl_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Pini nala, u banai wa tono aza a manyan yi a kucina̱. Aku u wokoi a kashina ka wa yan kuꞌyaru ki ka Boza ka, kumaci ku Elimele. ");
INSERT INTO kdl_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Aꞌari pini, aku Boza wuta̱i a Batalami u rawai tsa̱ra̱ u dana̱sa azamalinga yi, u danai, <<Magono ma Zuba ma rongo n a̱ɗa̱.>> Azamalinga yi a wushuki, <<Magono ma Zuba ma zuwuka vu dem una̱ u shinga.>> ");
INSERT INTO kdl_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Aku u wecei uzapige u azamalinga yi, <<Ukere u yai u ɗa niɗe vi?>> ");
INSERT INTO kdl_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","U wushunku yi, <<Makere ma aza a Muwabu ma nala mi ma, uza ɗa u tuwa̱i kaɓolo n Naꞌomi. ");
INSERT INTO kdl_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Aya u tonuko tsu, <Yanyi ahankuri a̱sa̱ka̱ numu n yain kuꞌyaru n cira̱ngusu ilya iꞌya aza a manyan ma ukapa yi a ka a̱sa̱ka̱sa̱.> U gita̱ ta̱ manyan mi ili i usana utuwa̱ gogo-na. Gogo-na ɗa u tsa̱ra̱i u dusuki a kulu tsa̱ra̱ u wunvuga kenu.>> ");
INSERT INTO kdl_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Aku Boza raɓai ara ne, u tonuko yi, <<Maku ma va̱, pana̱ka mu! Kotsu vu bana kuꞌyaru a kashina ka roku wa, she a kashina ka na. Vu yansa manyan pini na vu rongo utono kucina̱ ku nkere n ɗa ma yansa̱ka mu manyan. ");
INSERT INTO kdl_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Vu zuwa aꞌeshi a kashina ka baci dem a ka yan manyan, vu tono nkere mi ɗe. Kpaci n tonuko ɗe azamalinga yi kotsu a sawa vu wa. Aꞌayin a ɗa baci dem vu panai kakuli, vu ba vu soi mini a ndele n ɗa azamalinga yi a kenei.>> ");
INSERT INTO kdl_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Rutu kuɗa̱ngi u varai kaci a iyamba, u tonuko yi, <<Mpa kamoci ka, niɗa n tsa̱ra̱i mpasa n shinga ara vunu naha hal vu wenike mu ukuna shinga?>> ");
INSERT INTO kdl_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Boza wushunku yi, <<N pana ta̱ gba̱ ili iꞌya vu yankai anuku a ɗe tun aꞌayin a ɗa vali u vunu u kuwa̱i. N reve ta̱ tyoku ɗa vu a̱sa̱ka̱i tata u vunu, na̱ mma u vunu, n uyamba u vunu, n tyoku ɗa kpam vu tuwa̱i vu dusuki a uyamba u ama ɗa va̱ri vu revei wa. ");
INSERT INTO kdl_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","A̱sa̱ka̱ Magono ma Zuba ma tsupa vu ili iꞌya vu yain. A̱sa̱ka̱ Magono ma Zuba Kashila̱ ka Isaraꞌila uza ɗa vu tuwa̱i ara ne uzama asu u ukpawan u na̱ka̱ vu katsupi!>> ");
INSERT INTO kdl_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","U danai, <<Uzapige, a̱sa̱ka̱ n rongo utsa̱ra̱sa̱ mpasa n shinga ara vunu. Vu yanka ta̱ kagbashi ka vunu kadyanshi ka ugbamatangu asuvu, ko an u wokoi mpa ma̱ a asuvu a nkere n ɗa ma yansa̱ka vu manyan wa.>> ");
INSERT INTO kdl_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Aꞌayin a ulya ilikulya Boza tonuko yi, <<Tuwa̱ vu lyai ilikulya. Daɓusa burodi u vunu a mini ma kalam ma mini ma cinwi.>> Aku u dusuki evu n azamalinga yi, Boza kpam na̱ka̱ yi ilya iꞌya a zungi. U lya ta̱ u cuwa̱i hal gba̱m u lasai i roku. ");
INSERT INTO kdl_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","An u ꞌya̱nga̱i wa gita̱ kuꞌyaru, aku Boza tonukoi azamalinga a ne, <<A̱sa̱ka̱ ni u ꞌyara a asuvu a ndolu n ɗa i cai vi, kotsu i ɓishinka yi wa. ");
INSERT INTO kdl_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Kotsu i tala̱sa a ndolu mi n i varangusi a iyamba tsa̱ra̱ u purusa̱, kotsu i ɓarana yi wa.>> ");
INSERT INTO kdl_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Adama a nala, Rutu yan ta̱ kuꞌyaru a kashina ki hal kuvuli. An u lapai ili iꞌya u tsa̱ra̱i, u tsa̱ ta̱ ilya evu n akundatsu a kuden kamanga. ");
INSERT INTO kdl_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","U cangai u gonoi a ilyuci u ba u wenikei anuku a le ili iꞌya u tsa̱ra̱i. U na̱ka̱i kpam anuku a le kabuwi ka ilikulya ka u lyai u lasai vi. ");
INSERT INTO kdl_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Naꞌomi wece yi, <<Nte vu yain kuꞌyaru ara? Nte vu yain manyan? Kashila̱ ka zuwuka uza ɗa u kiranai n avu una̱ u shinga!>> Pini nala, Rutu tonuko yi ukuna u uza ɗa u yain kuꞌyaru a kashina ka ne ki, u danai, <<Uza ɗa n yain kuꞌyaru a kashina ka ne ara vi kala ka yi Boza.>> ");
INSERT INTO kdl_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Naꞌomi tonukoi Rutu, <<A̱sa̱ka̱ Magono ma Zuba ma zuwuka yi una̱ u shinga. Magono ma Zuba ma a̱sa̱ka̱ uwenishike ukuna u shinga u ne a asu u aza uma n akushe wa.>> U doki u danai, <<Vuma nala vi kumaci ku evu ka tsu, uza u te ɗa a asuvu a aza ɗa aꞌa̱ri malen ma uwusa tsu.>> ");
INSERT INTO kdl_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Aku Rutu uza u Muwabu danai, <<Bamu n nala gba̱m, Boza vi u tonuko mu ta̱ n bansa kuꞌyaru a kashina ka ne n rongo utono kucina̱ ka azamalinga a ne hal she a kotso manyan mi.>> ");
INSERT INTO kdl_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Naꞌomi wushunki Rutu, <<Makere ma va̱, yan tyoku ɗa u danai. U la ta̱ shana vu yain kuꞌyaru a kashina a asu u ɗa nkere n ɗa ma yansa̱ka Boza vi manyan aꞌa̱ri. Vu bana baci a kashina ka roku kau, a ka fuɗa ta̱ a yanka vu ili i gbani ɗe.>> ");
INSERT INTO kdl_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Pini nala, Rutu lyai kapala n kuꞌyaru evu na̱ nkere mi, hal she an a kotsoi manyan ma ilya i bale n ityabi. Gba̱ aꞌayin a nala yi u lya ta̱ kapala na̱ ndishi n anuku a ne Naꞌomi. ");
INSERT INTO kdl_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Kain ka te, Naꞌomi anuku a Rutu a tonuko yi, <<Makere ma va̱, u gan ta̱ n zamuka vu vali vu tsa̱ra̱ kuwa ka va wunvuga. ");
INSERT INTO kdl_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Wundya na, Boza uza ɗa u wushunku vu vu yain kuꞌyaru evu na̱ nkere n ɗa ma yansa̱ka yi manyan vi, kumaci ku tsunu ka ku evu. Pana na, ara n kuvuli wa welikpe ta̱ ilya i bale a asu u ɗa a lapuka yi ilya yi. ");
INSERT INTO kdl_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Yan baci aku vu sumba̱ vu gbara manivi ma magula̱ni, vu uka aminya a vunu a ɗa a lakai tsulobo. Pini nala, vu bana a asu u ɗa a ka lapuka yi ilya yi, shegai kotsu vu a̱sa̱ka̱ u reve an va̱ri pini wa, she u kotso ulya n uso gba̱. ");
INSERT INTO kdl_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Aꞌayin a ɗa baci wa bana nvain, vu zuwa aꞌeshi mai a asu u ɗa wa vaku; aku vu talukpa aꞌene a ne vu vaku pini. Wa tonuko vu ta̱ ili iꞌya va yan.>> ");
INSERT INTO kdl_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Rutu vi danai, <<Ma yan ta̱ gba̱ ili iꞌya vu danai.>> ");
INSERT INTO kdl_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","U lazai ubana a asu u ɗa a ka lapa ilya yi, u yain kpam gba̱ ili iꞌya anuku a ne a tonuko yi. ");
INSERT INTO kdl_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","An Boza kotsoi ulya n uso, wa̱ri a asuvu a upana kayanyan ka ne, aku u zamai asu u vaki evu n kaɓolo ka ilya ka a cira̱ngi vi. Pini nala, Rutu banai sawu a asu u ɗa Boza vaki u talukpai aꞌene a ne u vaki pini. ");
INSERT INTO kdl_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","An kayin ka pecei mere, aku Boza rikpa̱na̱ka̱i ula̱pa̱ni, u kpatalai u wenei uka nvain evu n aꞌene a ne. ");
INSERT INTO kdl_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","U wece yi, <<Yayi?>> U wushuki, <<Mpa Rutu kagbashi ka vunu. An u wokoi aɗa kumaci ku evu ku va̱, aɗa va̱ri n malen ma va wusa mu. Ma folo vu, zuwa mu.>> ");
INSERT INTO kdl_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Aku Boza danai, <<Maku ma va̱, a̱sa̱ka̱ Magono ma Zuba ma zuwuka vu una̱ u shinga. Ukuna u shinga u ɗa vu wenikei aza a kuwa a tsunu gogo-na u la ta̱ gba̱m u ɗa vu gita̱i vu wenikei anuku a vunu. Kpaci vu tono alobo wa, ko uza u utsa̱ri ko mayali. ");
INSERT INTO kdl_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Adama a nala maku ma va̱, kotsu vu dambula wa, ma yanka vu ta̱ gba̱ ili iꞌya va ciga. Gba̱ aza a ilyuci i na a reve ta̱ uma u vunu u lobonoi. ");
INSERT INTO kdl_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Mayun ɗa, mpa kumaci ku evu ka, uza ɗa wa̱ri n malen ma wa wusa vu, shegai uza ɗa lakai uwoko evu ɗa kpam pini. ");
INSERT INTO kdl_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Wansa pini na. Kain ka wansa baci, u wushuku baci u sotuku vu, a̱sa̱ka̱ yi u yain nala. Shegai wa ciga baci u yain nala wa, n tsina ta̱ n kala ka Magono ma Zuba ma sotuku vu ta̱. Vaku pini na she usana.>> ");
INSERT INTO kdl_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Aku Rutu vaki a asu u aꞌene a ne hal usana. Shegai u ꞌya̱nga̱i n kpasani ku de kahu ama a wene yi a reve, kpaci Boza tonuko yi ta̱ kotsu u a̱sa̱ka̱ uza roku reve an uka tuwa̱i a asu u ulapa u ilya vi wa. ");
INSERT INTO kdl_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Aku Boza tonuko yi, <<Tuko kunya ku upala̱ka ku vunu vu polo ka pini na.>> An u poloi, aku u tsunku yi pini akundatsu a ilya i bale kamanga. U canka yi aku u gonoi a ilyuci. ");
INSERT INTO kdl_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","An u gonoi a kuwa, aku anuku a ne a wece yi, <<Niɗa wa̱, maku ma va̱? Aku u tonuko yi gba̱ tyoku ɗa a yain n Boza vi. ");
INSERT INTO kdl_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","U doki u danai, Boza tonuko mu ta̱, <<Ma a̱sa̱ka̱ vu vu gono asu u anuku a vunu akere a de wa, ɗa u na̱ka̱ gba̱ mu ilya i bale i na yi.>> ");
INSERT INTO kdl_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Aku Naꞌomi danai, <<Maku ma va̱, vana vu wene ili iꞌya ya gita̱, kpaci Boza wa wunvuga wa, she u wene ukuna u na u kotso ara.>> ");
INSERT INTO kdl_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Aꞌari pini, aku Boza lazai ubana a asu u ɗa a tsu dusukusu a utsutsu u ilyuci u dusuki ɗe. Aku u wenei vuma ɗa u danai kumaci ka ku lakai evu uza ɗa wa̱ri n malen ma uwusa vi wa wura, u tonuko yi, <<Uza u va̱, tuwa̱ na vu dusuku.>> Aku u ba u dusuki. ");
INSERT INTO kdl_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Boza ɓolomgbonoi nkoshi ma ilyuci ama kupa u tonuko le a dusukusu. Aku a dusukusi. ");
INSERT INTO kdl_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Aku Boza tonukoi kumaci ku ne ku evu ki, u danai, <<Naꞌomi uza ɗa u wuta̱i a uyamba u Muwabu u gonoi vi, wa ciga ta̱ u denge kashina ka Elimele utoku u tsunu. ");
INSERT INTO kdl_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","N wene ta̱ u lobono ta̱ vu reve. Va ciga baci vu wusa ka, she vu wusa ka pini na a kapala ka nkoshi ma ama a va̱ kpam dem n a kapala ka aza ɗa aꞌa̱ri pini na ndishi. Va ciga tani baci wa, she vu dana tsa̱ra̱ n reve iꞌya ma yan. Kpaci uza wa̱ la a kapala ka vunu wa, mpa kpam ma tono vu.>> Aku vuma vi danai, <<Ma wusa ta̱ ka.>> ");
INSERT INTO kdl_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Aku Boza tonuko yi, <<Kain ka baci va tsila kashina ki a kukere ku Naꞌomi, va sotuku ta̱ dem Rutu uza u Muwabu, tsa̱ra̱ kala ka vali u ne u ɗa u kuwa̱i ka rongo pini, ucanga u agadu u ne dem u rongo pini.>> ");
INSERT INTO kdl_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Aku kumaci ku ne ka ka lakai evu vi u danai, <<Nala baci, ma fuɗa kpam ma wusa kashina ki wa. Kpaci n yan baci nala, ma nangasa ta̱ agadu a ɗa ma na̱ka̱ mmuku n va̱. Ma fuɗa ma wusa ka wa, avu wusa ka.>> ");
INSERT INTO kdl_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Caupa ɗe, aza a Isaraꞌila aꞌa̱ ta̱ n agadu, a ɗa gba̱ uza ɗa baci wa na̱ka̱ utoku u ne kabala ka uwusa ili ko kpam utsila, u tsu foɗo ta̱ akpata a ne u na̱ka̱ uza ɗa wa wusa ko wa tsila vi. Nala a tsu shamkpa ukuna vi a kapala ka ama. ");
INSERT INTO kdl_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Adama a nala, aku vuma vi foɗoi akpata a ne u na̱ka̱i Boza u tonuko yi ku te, <<Tsila kashina ki.>> ");
INSERT INTO kdl_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Boza tonukoi nkoshi mi n aza ɗa aꞌa̱ri pini a asu vi, <<Ara eɗa i wenei ukuna u na vi; wata, n tsila ta̱ gba̱ ili iꞌya iꞌa̱ri i Elimele n i mmuku n ne Kiliyo n Malo a kukere ku Naꞌomi. ");
INSERT INTO kdl_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Ma sotuku ta̱ dem Rutu uza u Muwabu uza ɗa wa̱ri wa wolo Malo u woko uka u va̱. Tsa̱ra̱ kala ka vali u ne u ɗa u kuwa̱i ka rongo pini, ucanga u agadu u ne dem u rongo pini. Kpam kala ki ka cimba̱ a asu u aza a kuwa a ne ko kpam aza a ilyuci i ne wa. Eɗa i wenei ukuna u na vi ara.>> ");
INSERT INTO kdl_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Aku gba̱ nkoshi mi n ama a ɗa aꞌa̱ri a utsutsu u ilyuci yi a danai, <<Tsu wene ta̱. A̱sa̱ka̱ Magono ma Zuba ma zuwa uka ɗa wa uwa a kuwa ku vunu ara na vi u woko tyoku u Rahila n Liyatu, aza ɗa a wokoi ikaya i aza a Isaraꞌila. A̱sa̱ka̱ vu yain utsa̱ri a kagali ka Efurata vu yain kpam kala a Batalami. ");
INSERT INTO kdl_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","A̱sa̱ka̱ Magono ma Zuba ma na̱ka̱ vu mmuku a asu u uka u na vi, aza ɗa a ka yan kala tyoku u mmuku ma akaya tsunu Periza maku ma Tama n Yahuda.>> ");
INSERT INTO kdl_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Pini nala, Boza sotuki Rutu u banka yi a kuwa ku ne. Magono ma Zuba ma zuwukai Rutu una̱ u shinga, u yain katsuma̱ u matsai maku ma vali. ");
INSERT INTO kdl_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Aku aka a ilyuci yi a tonukoi Naꞌomi, <<Uza u una̱ u shinga ɗa Magono ma Zuba! Gogo-na u na̱ka̱ vu ɗe matsikaya ma ma̱ri n malen ma ukirana n avu. A̱sa̱ka̱ maku mi ma yain kala a asuvu a Samaꞌila! ");
INSERT INTO kdl_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Wa woko ta̱ uza ɗa wa zuwusa uma u vunu u woko yavu usavu, u kirana kpam n avu vu kutsa baci. Kpaci kajene ka vunu uza ɗa wa ciga vu, uza ɗa u laka vu mmuku ma aꞌali n shindere, aya u matsa yi!>> ");
INSERT INTO kdl_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Naꞌomi canga̱sa ta̱ maku mi u wo yi yavu aya u matsa yi. ");
INSERT INTO kdl_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Aku atoku a ne aka aza a karen a le a danai, <<A matsa̱ka ɗe Naꞌomi maku ma vali.>> A neke yi kala Obida. Obida ɗa tata u Yese, Yese kpam aya tata u Dawuda. ");
INSERT INTO kdl_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Makeci ma kagali ka Periza ma na: Periza ɗa tata u Hezuron, ");
INSERT INTO kdl_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hezuron ɗa tata u Ram, Ram ɗa tata u Aminadabu. ");
INSERT INTO kdl_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadabu ɗa tata u Nashon, Nashon ɗa tata u Salumuna. ");
INSERT INTO kdl_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salumuna ɗa tata u Boza, Boza ɗa tata u Obida. ");
INSERT INTO kdl_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obida ɗa tata u Yese, Yese ɗa tata u Dawuda.");
INSERT INTO kdl_vpl VALUES ("MC1_1","034_1_1","MIC","1","1","1","Kadyanshi ka Magono ma Zuba ka tuwa̱i ara Mika matsumate vuma u Moreshetu a kaci ka kuwene ka u wenei a kaci ka ilyuci i Samariya n Urishelima, a'ayin a ɗa Jotam n Ahazu n Hazakaya a ka lya tsugono tsu Yahuda. ");
INSERT INTO kdl_vpl VALUES ("MC1_2","034_1_2","MIC","1","2","2","Panai na gba̱ ɗe, kakuma̱ ka ama, panai na, gba̱ aza ɗa a'a̱ri a likimba! A̱sa̱ka̱ Magono ma Zuba Uzapige n kaci ne u woko uza ɗa wenei ukuna vi a kaci ka ɗe, panai kadyanshi ka ne ka ka wuta̱ a kuwa ka uwulukpi ka ne. ");
INSERT INTO kdl_vpl VALUES ("MC1_3","034_1_3","MIC","1","3","3","Weɓelei! Magono ma Zuba ma wuta̱ a asu u ndishi n ne wa tuwa̱, wa tuwa̱ ta̱ iyamba u wala a bilibili u nsasa n likimba. ");
INSERT INTO kdl_vpl VALUES ("MC1_4","034_1_4","MIC","1","4","4","Nsasa ma dara̱kpa ta̱ a kere ku ne ara̱ra̱ kpam a ka ɓatsa ta̱ kure. Nsasa kpam ma dara̱kpa ta̱ yavu akawa a ishigi a asuvu a akina, yavu mini ma ma yene a kakonguro ubana a asu u ara̱ra̱. ");
INSERT INTO kdl_vpl VALUES ("MC1_5","034_1_5","MIC","1","5","5","Gba̱ nala vi wa gita̱ ta̱ na̱ mmuku n tsikaya n Yakubu, wata, aza a Isara'ila an a yain unyushi u cingi kpam a 'ya̱nga̱sa̱ka̱i Kashila̱. Ya zuwai Yakubu yain unyushi u cingi? Aza a Samariya a ɗa, ilyuci i pige i ne! Nte ɗa a asu u ulyasa̱ka ameli kayala a Yahuda? Urishelima ɗa n kaci ka ne! ");
INSERT INTO kdl_vpl VALUES ("MC1_6","034_1_6","MIC","1","6","6","Magono ma Zuba ma danai, <<Adama a nala ma wacinsa ta̱ Samariya u woko akpongo hal u woko agbaji, asu u ɗa a ka shigbusa̱ ashina a cinwi. Ma wacinsa ta̱ atali a kuma ki a asuvu a kara̱ra̱, n muɗa̱gbusa̱ kpam atali a kami ka kuma ku ne. ");
INSERT INTO kdl_vpl VALUES ("MC1_7","034_1_7","MIC","1","7","7","Gba̱ ameli a ne a ka ta̱sa̱sa̱ ta̱ a ɗa yuku-yuku; gba̱ kune ka a tukusoi a kuwa ku ameli ku ne a ka runukpa ta̱ ka n akina; ma wacinsa ta̱ gba̱ a'ulu a ne. An u wokoi u ɓolomgbonoi kune ku ne a asu u katsupi ka tsu tsishankala, a asu u tsishankala ɗa kpam ka kotso.>> ");
INSERT INTO kdl_vpl VALUES ("MC1_8","034_1_8","MIC","1","8","8","Adama a nala ma sa̱ ta̱, n yain ndishi ma ulapa una̱; ma foɗo ta̱ aminya n tambi kataɓa kpam bawu akpata. Ma wura̱ ta̱ yavu nshe n kakamba n sa̱i yavu makuɓi. ");
INSERT INTO kdl_vpl VALUES ("MC1_9","034_1_9","MIC","1","9","9","Kpaci usa̱n u Samariya usa̱n u ɗa bawu wa ta̱na̱. U tambura ɗe hal a Yahuda, u rawa ɗe a ilyuci i ama a va̱, wata Urishelima dem. ");
INSERT INTO kdl_vpl VALUES ("MC1_10","034_1_10","MIC","1","10","10","Kotsu i tonuko atokulalu a tsunu a Gatu wa; kotsu kpam i sa̱i wa ko kenu. A Bete-leyafara ɗa ya gandala̱sa a iyamba. ");
INSERT INTO kdl_vpl VALUES ("MC1_11","034_1_11","MIC","1","11","11","Aza a Shafiru, banai tsuwula̱, i wala kataɓa n uwono. Aza a ɗa i'a̱ri ndishi a Za'ana a ka wuta̱ wa. Aza a Bete-ezelu a'a̱ ta̱ a asuvu a ulapa u una̱ kpaci a tsa̱ra̱ u ɓa̱nga̱ a asu u le wa. ");
INSERT INTO kdl_vpl VALUES ("MC1_12","034_1_12","MIC","1","12","12","Aza a ɗa a'a̱ri ndishi a Marotu a ka vana tsa̱ra̱ a tsa̱ra̱ ili i shinga, shegai Magono ma Zuba ma zuwai mada̱ka̱ ma rukpa̱i a utsutsu u Urishelima. ");
INSERT INTO kdl_vpl VALUES ("MC1_13","034_1_13","MIC","1","13","13","Eɗa̱ aza a ɗa i'a̱ri ndishi a Lakishi, foɓusoi nringongo ma adoki n ɗe, tsa̱ra̱ i suma. Kpaci eɗa ilyuci i kagita̱ a Yahuda i tonoi aza a Isara'ila a asu u 'ya̱nga̱sa̱ka̱ u le, i zuwai kpam aza a Sihiyona a yain unyushi u cingi. ");
INSERT INTO kdl_vpl VALUES ("MC1_14","034_1_14","MIC","1","14","14","Adama a nala, aza a Yahuda tonukoi aza a Moreshetu-gatu u yan tsu ben i na̱ka̱ le kune. Ngono ma Isara'ila a ka pityanangu ta̱ n ilyuci i Akiziba shegai a ka tsa̱ra̱ u ɓa̱nga̱ wa. ");
INSERT INTO kdl_vpl VALUES ("MC1_15","034_1_15","MIC","1","15","15","Mpa Magono ma Zuba n danai, eɗa̱ aza ɗa i'a̱ri ndishi a Maresha ma doku ta̱ ma tuko uza ɗa wa lya ɗa̱ n kuvon. Azapige a Isara'ila a ka suma ta̱ ubana a Adulam. ");
INSERT INTO kdl_vpl VALUES ("MC1_16","034_1_16","MIC","1","16","16","Punai a'aci a ɗe asuvu a ulapa u una̱ adama a mmuku n ɗe aza ɗa ya ciga; gonukoi kaci ka ɗe yavu kukpani ka kasakali, kpaci mmuku n ɗe a ka laza ta̱ tsuwula̱. ");
INSERT INTO kdl_vpl VALUES ("MC2_1","034_2_1","MIC","2","1","1","Ter ɗe aza ɗa a tsu foɓuso tsicingi, aza ɗa kpam a tsu foɓuso ukuna u cingi a ivamkpatsu i le! Kain ka wansa baci a tsu yan ta̱ i'ya a foɓusoi vi, kpaci n ucira u le ɗa a tsu fuɗa ta̱ yain i'ya. ");
INSERT INTO kdl_vpl VALUES ("MC2_2","034_2_2","MIC","2","2","2","A tsu yan ta̱ maluwa ma gbani n ashina n ama, a wusa a ɗa. A tsu yan ta̱ kpam maluwa ma gbani n a'uwa a ama, a wusa a ɗa. A tsu ryafa ta̱ ama tsa̱ra̱ a wusa a'uwa a le n iyamba i le. ");
INSERT INTO kdl_vpl VALUES ("MC2_3","034_2_3","MIC","2","3","3","Adama a nala ili i'ya Magono ma Zuba ma danai i'ya na: <<Ma foɓuso ta̱ uwacinsa a kaci ka ama yi, ucun u ɗa bawu ya fuɗa ya wauwa kaci ka ɗe. Ya doku ya wala n i yanyi ara̱ɗi wa, kpaci wa woko ɗa̱ ta̱ a'ayin a mada̱ka̱. ");
INSERT INTO kdl_vpl VALUES ("MC2_4","034_2_4","MIC","2","4","4","A kain ka nala ki, ama a ka yanka ɗa̱ ta̱ majari, a ka yanka ɗa̱ ta̱ majari a shipuka ɗa̱ ushipa u unamgbukatsuma̱, a dana, <A nangasa tsu ɗe gba̱! Magono ma Zuba ma wusa ɗe uyamba u tsunu! U na̱ka̱i ashina a tsunu a asu u aza a ɗa a yinsa̱ tsu.> >> ");
INSERT INTO kdl_vpl VALUES ("MC2_5","034_2_5","MIC","2","5","5","Adama a nala, a'ayin a tuwa̱ baci a ɗa a ka gonuko uyamba vi a asu u ama a Magono ma Zuba, ko uza u te asuvu a ɗe wa̱ri n kapeci pini wa. ");
INSERT INTO kdl_vpl VALUES ("MC2_6","034_2_6","MIC","2","6","6","Ama ushani a danai, <<Kotsu i yain kuɓari wa! A̱sa̱ka̱ uyan kuɓari a kaci ka ili i nala yi, ili i uwono i roku i'a̱ la ya gita̱ n a̱tsu wa.>> ");
INSERT INTO kdl_vpl VALUES ("MC2_7","034_2_7","MIC","2","7","7","Dere ɗa a dana nala, mmuku n tsikaya n Yakubu? Ahankuri a Kulu ku Magono ma Zuba a gusa̱ ɗa? Ko aya u yain ili i nala yi? Kadyanshi ka Magono ma Zuba ka̱ri n kalen a asu u uza ɗa wa tono yi n ukuna u maci wa? ");
INSERT INTO kdl_vpl VALUES ("MC2_8","034_2_8","MIC","2","8","8","Magono ma Zuba ma danai, <<Shegai i tsu 'ya̱nga̱ ta̱ yavu atokulalu a asu u ama a va̱. I tsu foɗo ta̱ ntogo ma aza ɗa a ka wura yaa, aza ɗa a ka gono a asu u kuvon. ");
INSERT INTO kdl_vpl VALUES ("MC2_9","034_2_9","MIC","2","9","9","I tsu loko ta̱ aka a ama va̱ a wuta̱ a a'uwa a shinga a le. I takpa kpam una̱ u shinga u va̱ a asu u mmuku n le ubana. ");
INSERT INTO kdl_vpl VALUES ("MC2_10","034_2_10","MIC","2","10","10","'Ya̱nga̱i, i laza! Asu u na vi asu u uwunvuga u ɗe ɗa wa, kpaci a zuwa ɗe asu vi u wokoi na̱ nshinda̱, i nangasai u ɗa gba̱ gba̱. ");
INSERT INTO kdl_vpl VALUES ("MC2_11","034_2_11","MIC","2","11","11","Uza u kaɓan n uyinsa̱ u tuwa̱ baci u danai, <Ma yan ta̱ kuɓari a kaci ka mini ma cinwi n ili i'ya ya zuwa ugutukpa ushani,> icun i uza u kuɓari u ɗa ama a ka ciga ɗa la vi!>> ");
INSERT INTO kdl_vpl VALUES ("MC2_12","034_2_12","MIC","2","12","12","Magono ma Zuba ma danai, <<Mayun ma ɓolomgbono ɗa̱ ta̱ gba̱ ɗe, mmuku n tsikaya n Yakubu; ma ɓolomgbono ta̱ aza ɗa a buwai a Isara'ila. Ma ɓolomgbono le ta̱ asu u te yavu ncon a asu u ɗa a kanzai, yavu ushiga u ncon a asu u kalina; a woko kaɓolo ka pige ka ama. ");
INSERT INTO kdl_vpl VALUES ("MC2_13","034_2_13","MIC","2","13","13","Uza ɗa wa ɗapa kafon a kasaga, aya wa tono ta̱ n ele; a ka ɓa̱tsa̱ ta̱ a utsutsu a laza. Magono ma le ma uwa ta̱ a kapala ka le, Magono ma Zuba ma ma tono n ele n kaci ka ne.>> ");
INSERT INTO kdl_vpl VALUES ("MC3_1","034_3_1","MIC","3","1","1","Aku n danai, <<Eɗa̱ azapige a mmuku n tsikaya n Yakubu, panai na, aza ɗa ya lya tsugono tsu Isara'ila. U gan ta̱ i reve n afada a a'a̱ri dere, ");
INSERT INTO kdl_vpl VALUES ("MC3_2","034_3_2","MIC","3","2","3","eɗa̱ aza ɗa ya kovo ili i shinga aku ya ciga ukuna u cingi. Ya muna ukpan u ikyamba u ama a va̱ n i kiɗa̱si inyama i ikyamba i le asuvu atele a le. I koɗomgbonusoi kpam atele a le yuku-yuku, i kiɗa̱sa i'ya yavu inyama aku i tsungu i'ya a magbodo i takuma inyama i ama a va̱. ");
INSERT INTO kdl_vpl VALUES ("MC3_4","034_3_4","MIC","3","4","4","Pini nala ya sa̱ka̱ ta̱ Magono ma Zuba tsa̱ra̱ u ɓa̱nga̱ ɗa̱, shegai wa wushunku ɗa̱ wa. A'ayin a nala ɗa wa sokongu upetiwa'eshi a ne a asu ɗe adama ukuna u cingi u ɗa i yain.>> ");
INSERT INTO kdl_vpl VALUES ("MC3_5","034_3_5","MIC","3","5","5","Ili i'ya Magono ma Zuba ma danai i'ya na: <<A kaci ka ntsumate n ɗa ma puwusa̱n ama a va̱, a tsu 'ya̱nga̱sa̱ ta̱ ala̱ga̱tsu a le a dansa <Ukuna u ndishi n shinga,> a'a̱ baci n ilikulya i'ya a ka lya. Shegai a tsu foɓuso ta̱ kuvon a asu a aza ɗa bawu a na̱ka̱ le ili i roku. ");
INSERT INTO kdl_vpl VALUES ("MC3_6","034_3_6","MIC","3","6","6","Adama a nala, kayin ka tuwa̱ ɗa̱ ta̱, bawu kuwene, n karimbi ka aza a ukonduso bawu a ka wene ili. Eɗa̱ ntsumate, a'ayin a ɗe a ka kotsu ta̱ kpaci kaara ka rukpa̱ ɗa̱ ta̱, kaara ka woko ɗa̱ ta̱ karimbi cika. ");
INSERT INTO kdl_vpl VALUES ("MC3_7","034_3_7","MIC","3","7","7","Aza a kuwene a ka yan ta̱ uwono n aza a ukonduso a ka pana ta̱ uwono. A ka kimba̱ ta̱ upetiwa'eshi a le kpaci Kashila̱ ka wushunku le wa.>> ");
INSERT INTO kdl_vpl VALUES ("MC3_8","034_3_8","MIC","3","8","8","Shegai mpa, n ma̱ ta̱ ushaɗangi n ucira, n Kulu ku Magono ma Zuba, u yain afada a maci n ucira. Ma tonuko ta̱ mmuku n tsikaya n Yakubu unyushi u cingi u le, aza a Isara'ila kpam unyushi u le. ");
INSERT INTO kdl_vpl VALUES ("MC3_9","034_3_9","MIC","3","9","9","Panai na, eɗa̱ azapige a mmuku n tsikaya n Yakubu, eɗa̱ aza ɗa ya lya tsugono tsu Isara'ila, aza ɗa i ꞌyuwain afada a maci i gonukoi ili i'ya i'a̱ri dere i wokoi i cingi. ");
INSERT INTO kdl_vpl VALUES ("MC3_10","034_3_10","MIC","3","10","10","I yain uboku n mawunuka i tsa̱ra̱i ikebe i i'ya i mai Sihiyona, i mai kpam Urishelima n ukuna u cingi. ");
INSERT INTO kdl_vpl VALUES ("MC3_11","034_3_11","MIC","3","11","11","Eɗa̱ azapige a Urishelima i tsu wusha ta̱ ukimba̱ u una̱ adama a afada. Eɗa̱ aɗara̱kpi ya wenishike mele ma Kashila̱ adama u zami ikebe, eɗa̱ kpam ntsumate ya konduso ili i'ya ya tuwa̱ ya gita̱ adama ikebe. Gba̱ n nala i pityanangi n Magono ma Zuba wa, i danai, <<Mada̱ka̱ ma tuwa̱ a asu tsunu wa kpaci Magono ma Zuba ma̱ ta̱ kaɓolo n a̱tsu.>> ");
INSERT INTO kdl_vpl VALUES ("MC3_12","034_3_12","MIC","3","12","12","Adama a nala a ka lima ta̱ Sihiyona u woko kashina adama a ɗe, Urishelima wa woko ta̱ akpongo, masasa ma Kuwa ku Kashila̱ ka̱ri ma woko ta̱ kutsu. ");
INSERT INTO kdl_vpl VALUES ("MC4_1","034_4_1","MIC","4","1","1","A a'ayin a ɗa a ka tuwa̱ masasa ma Kuwa ku Kashila̱ ku Magono ma Zuba ma woko ta̱ masasa ma ma lai karinga̱; a ka ra̱ɗugba̱ ta̱ ma ma lai aga̱la̱la̱. Ama a ushani a ka ta̱sa̱ ta̱ ubana pini tyoku u aga̱ta̱ a ɗa a ka yene. ");
INSERT INTO kdl_vpl VALUES ("MC4_2","034_4_2","MIC","4","2","2","Kakuma̱ ka ama ushani a ka tuwa̱ ta̱ a dana, <<Tuwa̱i tsu banai a masasa ma Magono ma Zuba, ubana a Kuwa ku Kashila̱ ku Yakubu. Wa wenishike tsu ta̱ ire i ne, tsu wala kpam a ure u ne.>> Kpaci mele ma wuta̱ ta̱ a Sihiyona, a Urishelima kpam kadyanshi ka Magono ma Zuba ka tambura a ubana a asu u ama. ");
INSERT INTO kdl_vpl VALUES ("MC4_3","034_4_3","MIC","4","3","3","Wa yanka ta̱ ama ushani afada kpam wa tuko ta̱ makorishi ma ibili ma uyamba u ucira u ɗa wa̱ri mɓa̱ri. A gonuko iburundu i le mberu ma ucimba, asovu a le kpam mmuwun ma ugyara nɗanga. Uyamba wa doku wa ra̱ɗugba̱ burundu u ne a uyamba u roku wa, kpam a ka doku a rotsongusu ure u kuvon wa. ");
INSERT INTO kdl_vpl VALUES ("MC4_4","034_4_4","MIC","4","4","4","Ya dem wa dusuku ta̱ yaa u lyai ilimaci i katyaci ka cinwi n maɗanga ma kapopi a kuwa ku ne. Uza wa̱ la wa giruwusa̱ yi wa, kpaci Magono ma Zuba ma Ucira Gba̱ aya u danai nala. ");
INSERT INTO kdl_vpl VALUES ("MC4_5","034_4_5","MIC","4","5","5","Ko an u wokoi gba̱ ama ya dem wa tono ta̱ ameli a ne; shegai a̱tsu tsa tono ta̱ Magono ma Zuba Kashila̱ ka tsunu a ubana. ");
INSERT INTO kdl_vpl VALUES ("MC4_6","034_4_6","MIC","4","6","6","Magono ma Zuba ma danai, <<A kain ka nala ki, ma ɓolomgbono ta̱ awunu, aza ɗa n bankai tsuwula̱, wata, aza ɗa n yain mavura. ");
INSERT INTO kdl_vpl VALUES ("MC4_7","034_4_7","MIC","4","7","7","Ma gonuko ta̱ awunu ama va̱ aza ɗa a buwai, aza ɗa a lokoi kpam a woko kakuma̱ ka ama ka ucira. Magono ma Zuba ma lya ta̱ tsugono a kaci ka le a masasa ma Sihiyona ili i'ya i bidyai a kain kala ki ubana. ");
INSERT INTO kdl_vpl VALUES ("MC4_8","034_4_8","MIC","4","8","8","Avu Urishelima, kunukuzuba ku uza u uwundya ushiga, asu u kpawan u aza a Sihiyona, asu u ɗe ɗa tsugono tsu cau tsa gono, tsugono tsu nala tsi tsu ɗe tsa aza a Urishelima.>> ");
INSERT INTO kdl_vpl VALUES ("MC4_9","034_4_9","MIC","4","9","9","Ndya i zuwai gogo-na ya sa̱ cika, i'a̱ri n magono wa ɗa? Uza u na̱ka̱ adooki u ɗe u kuwa̱ ɗe ɗa? Adama a nala ɗa i'a̱ri a asuvu a upana u ikyamba yavu uka ɗa wa̱ri asuvu mɓa̱la̱ ma ilimaci. ");
INSERT INTO kdl_vpl VALUES ("MC4_10","034_4_10","MIC","4","10","10","Aza a Sihiyona, ikai n ucira, yavu uka u ɗa wa̱ri nkuɗi ma ilimaci, kpaci gogo-na u ka̱na̱ ta̱ i a̱sa̱ka̱ a ilyuci yi, i bana i dusuku a kakura̱. Ya bana ta̱ a Babila, ɗe ɗa a ka wauwa ɗa̱. Ɗe ɗa Magono ma Zuba ma wusa ɗa a kukere ku atokulalu a ɗe. ");
INSERT INTO kdl_vpl VALUES ("MC4_11","034_4_11","MIC","4","11","11","Shegai gogo-na uyamba ushani a ɓolomgbono ɗe a ka yan tsilala n a̱ɗa̱. A dana, <<U ka̱na̱ ta̱ Urishelima u woko n nshinda̱! A̱sa̱ka̱ tsu wene uwono u ilyuci yi.>> ");
INSERT INTO kdl_vpl VALUES ("MC4_12","034_4_12","MIC","4","12","12","Shegai a reve uyanwusa u Magono ma Zuba n afoɓi a ne wa, kpaci u ɓolomgbono le ta̱ yavu ndolu ma ilya, ilya i'ya a bankai asu u ulapa u ilya. ");
INSERT INTO kdl_vpl VALUES ("MC4_13","034_4_13","MIC","4","13","13","Magono ma Zuba ma danai, <<'Ya̱nga̱i i kpatsa uyamba, aza a Sihiyona! Kpaci ma na̱ka̱ ɗa̱ ta̱ avana a urim, a'ene a ɗe kpam a urim u shili, adama ɗa i kpatsa uyamba ushani yuku-yuku. Pini nala utsa̱ri u le u ɗa a bokoi ya neke ta̱ u ɗa gba̱ a asu u Magono ma Zuba, udukuyan u le kpam asu u Uzapige u likimba gba̱.>> ");
INSERT INTO kdl_vpl VALUES ("MC5_1","034_5_1","MIC","5","1","1","Ɓolomgbono asoje a vunu, ilyuci i asoje, kpaci a kyawan tsu ɗe n kuvon. A ka lapa ta̱ tsugono tsa aza a Isara'ila a kagbaguzu ka a ka lapa yi n kalangu. ");
INSERT INTO kdl_vpl VALUES ("MC5_2","034_5_2","MIC","5","2","2","Magono ma Zuba ma danai, <<Batalami Efurata, avu ilyuci i kenu i'ya a asuvu a kumaci ku Yahuda. Ma ɗanga̱sa ta̱ uza u te a asuvu a ama a vunu u lyai tsugono tsu Isara'ila, uza ɗa kagali ka ne ka̱ri tun caupa.>> ");
INSERT INTO kdl_vpl VALUES ("MC5_3","034_5_3","MIC","5","3","3","Adama a nala, Magono ma Zuba ma neke ta̱ aza a Isara'ila a asu u atokulalu a le, hal she a'ayin a ɗa uka ɗa wa̱ri asuvu nkuɗi ma ilimaci u matsai maku ma vali. Aku atoku a ne aza ɗa a buwai a ka gono a asu u aza a Isara'ila. ");
INSERT INTO kdl_vpl VALUES ("MC5_4","034_5_4","MIC","5","4","4","Wa shamgba ta̱ ulina̱ka ushiga u ne, n ucira n kala ka tsupige ka Magono ma Zuba Kashila̱ ka ne. Ama a ne a ka rongo ta̱ mai, kpaci ureve u tsupige tsu ne wa rawa ta̱ hal a makorishi ma likimba. ");
INSERT INTO kdl_vpl VALUES ("MC5_5","034_5_5","MIC","5","5","5","Wa zuwa ta̱ tsu tsa̱ra̱ ndishi n shinga, a'ayin a ɗa baci aza a Asiriya a uwai asuvu a uyamba u tsunu n kuvon, a ka wala ta̱ asu u ukpawan u asaga a pige. Tsa ɗanga̱sa ta̱ azapige a asoje ama shindere hal gba̱m kulla̱ a yain tsilala n ele. ");
INSERT INTO kdl_vpl VALUES ("MC5_6","034_5_6","MIC","5","6","6","A ka lya ta̱ tsugono tsu Asiriya n burundu, uyamba u Nimurodu kpam n iburundu i le ufoɓusi. Wa wauwa tsu ta̱ a asu u aza a Asiriya a'ayin a ɗa baci a pasai karen ka tsunu a tukoi uyamba u tsunu kuvon. ");
INSERT INTO kdl_vpl VALUES ("MC5_7","034_5_7","MIC","5","7","7","Pini nala ama a Yakubu a ɗa buwai a ka dusuku ta̱ asuvu a kakuma̱ ka ama yavu cinza tsa tsu wuta̱i a asu u Magono ma Zuba yavu mini ma zuba ma ma rukpusa̱ a mete, ma bawu ma vana uza ko kpam u pityanangu n vuma. ");
INSERT INTO kdl_vpl VALUES ("MC5_8","034_5_8","MIC","5","8","8","Ama a Yakubu a ɗa buwai a ka dusuku ta̱ a asuvu a kakuma̱ ka ama, a mere ma ama ushani a ka woko ta̱ n ucira yavu gabako a mere ma nnama a kutsu, yavu gabako asuvu a ishiga i nlala, a'ayin a ɗa baci u raɗugi u uwai a mere ma le uza wa̱ la wa wauwa le wa. ");
INSERT INTO kdl_vpl VALUES ("MC5_9","034_5_9","MIC","5","9","9","A ka 'ya̱nga̱sa̱ ta̱ akere a ɗe a kaci ka atokulalu a ɗe. kpam atokulalu a ɗe a ka wacinsa le ta̱. ");
INSERT INTO kdl_vpl VALUES ("MC5_10","034_5_10","MIC","5","10","10","Magono ma Zuba ma danai, <<A kain ka nala ki, ma wacinsa ta̱ adoki a ɗe n nangasa kpam nringongo ma adoki a ɗe. ");
INSERT INTO kdl_vpl VALUES ("MC5_11","034_5_11","MIC","5","11","11","Ma wacinsa ta̱ ilyuci i uyamba u ɗe, n wa̱sa̱sa̱ asaga ɗa a'a̱ri ukyawin n ilyuci i ɗe. ");
INSERT INTO kdl_vpl VALUES ("MC5_12","034_5_12","MIC","5","12","12","Ma tuko ta̱ makorishi ma aza a ada̱bu a uyamba u ɗe, ya doku ya tsa̱ra̱ aza a ukonduso wa. ");
INSERT INTO kdl_vpl VALUES ("MC5_13","034_5_13","MIC","5","13","13","Ma wacinsa ta̱ ameli a ɗe n atali a ulyasa̱ka ameli kayala a ɗe. Ya doku ya kuɗa̱nku ili i'ya i yain n akere a ɗe i lyaka le kayala wa. ");
INSERT INTO kdl_vpl VALUES ("MC5_14","034_5_14","MIC","5","14","14","Ma muɗusa̱ ta̱ ashamkpatsu a ameli a Ashera asuvu a ɗe, n wacinsa kpam ilyuci i ɗe. ");
INSERT INTO kdl_vpl VALUES ("MC5_15","034_5_15","MIC","5","15","15","Ma yan ta̱ katsupi ka va̱ n asuvu a shen n upan a asu u kakuma̱ ka ama a ɗa gba̱ a tsu ꞌyuwain ugorimuko mu.>> ");
INSERT INTO kdl_vpl VALUES ("MC6_1","034_6_1","MIC","6","1","1","Aza a Isara'ila, panai ili i'ya Magono ma Zuba ma danai: <<'Ya̱nga̱i, i dana usapula ɗe a kapala ka nsasa, a̱sa̱ka̱ aga̱la̱la̱ a pana ala̱ga̱tsu a ɗe. ");
INSERT INTO kdl_vpl VALUES ("MC6_2","034_6_2","MIC","6","2","2","Nsasa, panai usapula u Magono ma Zuba a kaci ka Isara'ila; zuwai atsuvu i pana, eɗa̱ kami ka likimba tun caupa. Panai! Kpaci Magono ma Zuba ma sapulai ama a ne, wa̱ ta̱ n kadyanshi n Isara'ila. ");
INSERT INTO kdl_vpl VALUES ("MC6_3","034_6_3","MIC","6","3","3","<<Ama a va̱, ndya n yanka ɗa̱? Niɗa n wokoi kala̱nda̱m a asu u ɗe? Tonuko na̱ mu! ");
INSERT INTO kdl_vpl VALUES ("MC6_4","034_6_4","MIC","6","4","4","N wutukpa̱ ɗa̱ a uyamba u Masar a asuvu a tsugbashi, n wusa ɗa̱ kpam. N suki Musa utuwa̱ u toni n a̱ɗa̱, hal n Haruna n Mariya. ");
INSERT INTO kdl_vpl VALUES ("MC6_5","034_6_5","MIC","6","5","5","Ama a va̱, ciɓai ili i'ya Balaku magono ma Muwabu ma foɓusoi ma yain, ciɓai kpam ili i'ya Bala'am kalobo ka Beyo u wushunki yi. Ciɓai na̱ nwalu n ɗe a Shitim ubana a Giligal, adama i reve manyan ma maci ma Magono ma Zuba.>> ");
INSERT INTO kdl_vpl VALUES ("MC6_6","034_6_6","MIC","6","6","6","Ndya ma tuwa̱ n i'ya a kapala ka Magono ma Zuba n kuɗa̱ngu n lyai kayala a kapala ka Kashila̱ ka zuba? N tuwa̱ a kapala ka ne n uɗara̱kpa u urunukpa na̱ ndyondyom ka kayen ka te ɗa? ");
INSERT INTO kdl_vpl VALUES ("MC6_7","034_6_7","MIC","6","7","7","Magono ma Zuba ma pana kayanyan ka a'ondom azu azu, n ayenete a manivi ma zayitum azu kupa (10,000)? N yain uɗara̱kpa n maku ma kagita̱ ma va̱ adama a unyushi u va̱, mmuku n va̱ kpam adama a unyushi u cingi u va̱? ");
INSERT INTO kdl_vpl VALUES ("MC6_8","034_6_8","MIC","6","8","8","Nala wa, vuma, Magono ma Zuba ma wenike vu ɗe ili i'ya i'a̱ri i shinga, Ili i'ya va yan i'ya na: Vu yain afada a maci n uciga u wenike asuvayali, vu vakunku kpam kaci ka vunu a asu u tono Kashila̱ ka vunu. ");
INSERT INTO kdl_vpl VALUES ("MC6_9","034_6_9","MIC","6","9","9","Zuwai atsuvu i pana, Magono ma Zuba ma isa̱ ama i ilyuci i Urishelima. Kakiri ka, a pana uwonvo u Magono ma Zuba. Magono ma Zuba ma danai, <<Kakuma̱ ka ama n aza a ɗa a ɓolomgbonoi a ilyuci, zuwai atsuvu i pana! ");
INSERT INTO kdl_vpl VALUES ("MC6_10","034_6_10","MIC","6","10","10","Ama a cingi, hal ma a̱sa̱nsa̱ n udukuyan u ɗa i tsa̱ra̱i a ure u cingi? Ko ma a̱sa̱nsa̱ n kakundatsu ka i doi ka n kovoi? ");
INSERT INTO kdl_vpl VALUES ("MC6_11","034_6_11","MIC","6","11","11","Shegai mpa, Magono ma Zuba, ma kpa̱ɗa̱ ɗa̱ uyan mavura wa adama kakundatsu ka kaɓan n maryafuka. ");
INSERT INTO kdl_vpl VALUES ("MC6_12","034_6_12","MIC","6","12","12","Aza a utsa̱ri a ɗe a tsu 'yankusu ta̱ ama; ama a ɗe a ɗa a'a̱ri na̱ ndishi ɗe a tsu yansa kaɓan, n una̱ u le ɗa a tsu yinsa̱ ama. ");
INSERT INTO kdl_vpl VALUES ("MC6_13","034_6_13","MIC","6","13","13","Adama a nala ma lapa ɗa̱ ta̱ na̱ mɓa̱la̱, n wacinsa ɗa̱ adama a unyushi u cingi u ɗe. ");
INSERT INTO kdl_vpl VALUES ("MC6_14","034_6_14","MIC","6","14","14","Ya lya ta̱ ilikulya shegai ya ciwa̱ wa, katsuma̱ ka ɗe ka rongo ta̱ n kambulu. Ya ɓolomgbono ta̱ ucanga u ɗe, shegai ko ili ya zuwa wa, i'ya kpam i zuwai kenu ma wacinsa ta̱ i'ya a asu u kuvon. ");
INSERT INTO kdl_vpl VALUES ("MC6_15","034_6_15","MIC","6","15","15","Ya ce ta̱, shegai ko ili ya kapa wa. Ya pisha ta̱ ilimaci i zayitum shegai ya yan manyan n manivi ma ne wa. Ya pisha ta̱ ilimaci i cinwi, shegai ya so mini ma cinwi mi wa. ");
INSERT INTO kdl_vpl VALUES ("MC6_16","034_6_16","MIC","6","16","16","Kpaci i tono ta̱ mele ma cingi ma Omiri, n gba̱ manyan ma kuwa ku Ahabu; i tonoi afoɓi a cingi a le. Adama a nala ma gonuko ɗa̱ ta̱ akpongo aza ɗa a'a̱ri ndishi ɗe a ka woko ta̱ ili i magori. Nala ya woko, eɗa̱ ama a va̱, ko n te wa a ka goro ɗa̱ ta̱.>> ");
INSERT INTO kdl_vpl VALUES ("MC7_1","034_7_1","MIC","7","1","1","Ter va̱! Kpaci n woko ɗe yavu uza ɗa wa pana kambulu, uza ɗa bawu u tsa̱ra̱i ili an u ɓolomgbonoi ilimaci i kashina. An a 'yarai kashina ka cinwi, ilimaci i cinwi i'a̱ la i'ya ka kasa a lyai wa, kpam bawu ilimaci i kapopi i gewi i'ya ma ciga. ");
INSERT INTO kdl_vpl VALUES ("MC7_2","034_7_2","MIC","7","2","2","Ama a maci a kotsu ɗe a uyamba vi; aza a ukuna u mayun a buwa wa. Ya dem wa putsa̱ utoku u ne tsa̱ra̱ u wuna, ya dem u wanda̱ga ta̱ utoku u ne utyangi. ");
INSERT INTO kdl_vpl VALUES ("MC7_3","034_7_3","MIC","7","3","3","Ya dem wa̱ ta̱ n ureve a asu u uyan ukuna u cingi n akere a ne, azapige a ka ciga a na̱ka̱ le kune, aza a afada kpam a ka wusha ukimba̱ u una̱, uzapige u tsu zuwa ta̱ a yain ili i cingi i'ya katakasuvu ka ne ka ciga, nala a tsu kpatala̱sa ukuna u mayun. ");
INSERT INTO kdl_vpl VALUES ("MC7_4","034_7_4","MIC","7","4","4","Vuma ɗa lai uyansa ili i shinga a asuvu a ɗe, wa̱ ta̱ yavu maɗanga ma kaworo, vuma ɗa lai u ukuna u maci asuvu a le wa̱ ta̱ yavu maɗanga ma kawana. Kain ka mavura ma ɗe ka tuwa̱ ɗe kain ka a ka ɓara ɗa̱ a una̱ u ntsumate, gogo-na ɗa ya dem wa la̱pa̱na̱. ");
INSERT INTO kdl_vpl VALUES ("MC7_5","034_7_5","MIC","7","5","5","Kotsu i pityanangu n aza a karen a ɗe wa, kotsu i wushuku n aje a ɗe wa. Ko aka a ɗe a ɗa ya ciga, i kirana n kadyanshi ka una̱ u ɗe. ");
INSERT INTO kdl_vpl VALUES ("MC7_6","034_7_6","MIC","7","6","6","Kpaci maku ma vali u tsu goro ta̱ tata u ne, maku ma uka kpam u tsu 'ya̱nga̱sa̱ka̱ ta̱ mma u ne, kajene n anuku a ne kpam u tsu yan ta̱ tsilala. Atokulalu a vuma, a'a̱ ta̱ a kuwa ku te. ");
INSERT INTO kdl_vpl VALUES ("MC7_7","034_7_7","MIC","7","7","7","Shegai mpa, ma zuwa ta̱ a'eshi a asu u Magono ma Zuba u ɓa̱nga̱ mu, ma vana ta̱ Kashila̱ ka iwauwi ka va̱; Kashila̱ ka va̱ wa pana̱ka mu ta̱. ");
INSERT INTO kdl_vpl VALUES ("MC7_8","034_7_8","MIC","7","8","8","Atokulalu a va̱, kotsu i yain maza̱nga̱ a kaci ka va̱ wa! Ko n rukpa̱i baci, ma 'ya̱nga̱ ta̱. Ko n dusuku baci a karimbi, Magono ma Zuba ma woko ta̱ katyashi ka va̱. ");
INSERT INTO kdl_vpl VALUES ("MC7_9","034_7_9","MIC","7","9","9","N yan ta̱ unyushi u cingi a asu u Magono ma Zuba adama a nala ma kawunku ta̱ adama upan u ne, shegai a makorishi wa shamkpa mu ta̱, kpaci u pana ta̱ usapula u va̱, u yanka mu afada ɗa a'a̱ri dere. Wa tuko mu ta̱ a asu u katyashi, n wene ukuna u maci u ne. ");
INSERT INTO kdl_vpl VALUES ("MC7_10","034_7_10","MIC","7","10","10","Pini nala ɗa atokulalu a va̱ a ka wene, aku uwono u kimba̱ aza ɗa a tonuko mu, <<Nte Magono ma Zuba Kashila̱ ka vunu?>> A'eshi a va̱ a ka wene ta̱ urukpa̱ u le, gogo-na a ka kpatsa le ta̱ yavu cin a ure. ");
INSERT INTO kdl_vpl VALUES ("MC7_11","034_7_11","MIC","7","11","11","Kain ka a ka lapula a mai asaga a ɗe ka tuwa̱ ta̱, kain ka a ka doku upeti u karen u ɗe. ");
INSERT INTO kdl_vpl VALUES ("MC7_12","034_7_12","MIC","7","12","12","A kain ka nala ki, ama ushani a ka tuwa̱ ta̱ a asu u ɗe, a wuta̱ a Asiriya n ilyuci i Masar, hal gba̱m ili i'ya bidyai a Masar hal Aga̱ta̱ a Yufiriti, n mala ubana a mala n masasa ubana a masasa. ");
INSERT INTO kdl_vpl VALUES ("MC7_13","034_7_13","MIC","7","13","13","Likimba wa woko ta̱ akpongo adama tsicingi tsa aza a ɗa dusuki pini a yansai. ");
INSERT INTO kdl_vpl VALUES ("MC7_14","034_7_14","MIC","7","14","14","Magono ma Zuba, kirana n ama a vunu tyoku ɗa kaliniki ka tsu yan n kalangu ka ne, ushiga u nlala u agadu u vunu, u ɗa wa̱ri ndishi utyoku u ne a kutsu ka ka̱ri n asu u kalina u tsishinda̱. A̱sa̱ka̱ a wuta̱ a lina a kaɓon ka Bashan n kaɓon ka Giliyadu yavu a'ayin a cau. ");
INSERT INTO kdl_vpl VALUES ("MC7_15","034_7_15","MIC","7","15","15","Magono ma Zuba ma danai, <<Ma yanka ɗa̱ ta̱ manyan ma ikunesavu tyoku ɗa n yain an n wutukpa̱ ɗa̱ a asu u tsugbashi a Masar.>> ");
INSERT INTO kdl_vpl VALUES ("MC7_16","034_7_16","MIC","7","16","16","Kakuma̱ ka ama a ka wene ta̱ kpam a pana uwono ko an u wokoi a'a̱ri n ucira. A ka kimba̱ ta̱ una̱ u le a paɗa bini a woko kpam yavu agulani. ");
INSERT INTO kdl_vpl VALUES ("MC7_17","034_7_17","MIC","7","17","17","A ka woko ta̱ yavu ili i'ya ya ka̱bura̱ a iyamba, a ka lya ta̱ kabuta̱ yavu a'ali. A ka wuta̱ ta̱ n a jeki ikyamba, a asu u ukpawunsa u le. A ka giruwa̱ ta̱ a kapala ka vunu Magono ma Zuba Kashila̱ ka tsunu; a ka pana vu ta̱ uwonvo. ");
INSERT INTO kdl_vpl VALUES ("MC7_18","034_7_18","MIC","7","18","18","Kashila̱ ka roku ka̱ la tyoku u vunu wa, uza ɗa u tsu cimbusa̱ unyushi u cingi n unyushi u ama a ne a ɗa a buwai a aza a agadu a vunu. Vu tsu ka̱na̱ upan u vunu hal ubana wa, kpaci vu tsu pana ta̱ kayanyan ka uwenike uciga u vunu u ɗa bawu wa savaɗa. ");
INSERT INTO kdl_vpl VALUES ("MC7_19","034_7_19","MIC","7","19","19","Va doku ta̱ va wenike tsu asuvayali a vunu. Va lya ta̱ kaci ka unyushi u tsunu vu vuta̱la̱ kpam unyushi u cingi u tsunu a mala ma ma̱ri lyungu-lyungu. ");
INSERT INTO kdl_vpl VALUES ("MC7_20","034_7_20","MIC","7","20","20","Va wenike ta̱ ukuna u mayun u vunu n uciga u vunu u ɗa bawu wa savaɗa, a asu u mmuku n tsikaya ma Ibirahi n Yakubu tyoku ɗa vu yain kazuwamgbani n ikaya i tsunu a'ayin a cau.");
INSERT INTO kdl_vpl VALUES ("NM1_1","035_1_1","NAM","1","1","1","Akani a Kashila̱ a kaci ka Niniba. Tagara̱da u kuwene u Nahum uza u Elikoshiya. ");
INSERT INTO kdl_vpl VALUES ("NM1_2","035_1_2","NAM","1","2","2","Magono ma Zuba Kashila̱ uza u malyon ɗa, Magono ma Zuba katsupuki ka n upan cika. Magono ma Zuba u tsu tsupuka ta̱ kaci ka ne a asu u atokulalu a ne u tsu gonuko ta̱ upan u ne a asu u atokulalu a ne. ");
INSERT INTO kdl_vpl VALUES ("NM1_3","035_1_3","NAM","1","3","3","Magono ma Zuba wa̱ri n maloko ma uyan upan wa, shegai wa̱ ta̱ n ucira cika, Magono ma Zuba ma kpa̱ɗa̱ uyanka aza a unyushi mavura wa. Ure u ne wa̱ ta̱ n uwule u pige u kabatara̱kpa n ulima̱, aku alishi a ɗa kabuta̱ ka adeshikpetsu a ne. ");
INSERT INTO kdl_vpl VALUES ("NM1_4","035_1_4","NAM","1","4","4","U tsu ɓarana ta̱ mala n aga̱ta̱ a wumkpa, u tsu zuwa ta̱ a ɗa kpam a ekpe. Mete ma ma̱ri a Bashan n Karumelu ma tsu lumba ta̱ aku apa̱lu a Lebanon a sa̱ka̱ta̱. ");
INSERT INTO kdl_vpl VALUES ("NM1_5","035_1_5","NAM","1","5","5","Nsasa n tsu gba̱ɗa̱ ta̱ a kapala ka ne aga̱la̱la̱ kpam a tsu dara̱kpa ta̱. Uyamba u gba̱ɗa̱ a kapala ka ne, likimba n gba̱ n ili iꞌya iꞌa̱ri pini a asuvu i giruwa̱ ta̱. ");
INSERT INTO kdl_vpl VALUES ("NM1_6","035_1_6","NAM","1","6","6","Ya wa fuɗa wa shamgba a kapala ka ne u yan baci upan? Ya wa fuɗa u kawunku n upan u shen u ne? Upan u ne wa̱ ta̱ shen yavu akina; atali a tsu yuruwa ta̱ a kapala ka ne yuku-yuku. ");
INSERT INTO kdl_vpl VALUES ("NM1_7","035_1_7","NAM","1","7","7","Magono ma Zuba ma̱ ta̱ ukuna u shinga, eyi asu u ukpawan ɗa aꞌayin a upana a ikyamba. U tsu kirana ta̱ n aza ɗa a kpawain a asu u ne. ");
INSERT INTO kdl_vpl VALUES ("NM1_8","035_1_8","NAM","1","8","8","Shegai yavu uwayi u mini ma kushiva̱ ɗa wa tuko makorishi ma Niniba gba̱; wa loko ta̱ atokulalu a ne a ubana a karimbi. ");
INSERT INTO kdl_vpl VALUES ("NM1_9","035_1_9","NAM","1","9","9","Ndya iꞌa̱ri ufoɓuso a kaci ka Magono ma Zuba? Ko ndya baci wa, wa tuko ta̱ iꞌya gba̱ a makorishi; uza u tsu yan tsilala n eyi hal kure wa. ");
INSERT INTO kdl_vpl VALUES ("NM1_10","035_1_10","NAM","1","10","10","Atokulalu a ne aꞌa̱ ta̱ yavu awana a ɗa a ɓolomgbonoi, yavu asoi a ɗa a gutukpai a ka wala n a rukpusi, a ka runukpa le ta̱ gba̱ yavu mete ma ekpi. ");
INSERT INTO kdl_vpl VALUES ("NM1_11","035_1_11","NAM","1","11","11","Asuvu a vunu, Niniba uza roku wa wuta̱ ta̱ uza ɗa u foɓusukoi Magono ma Zuba tsicingi u na̱ka̱ adooki a cingi. ");
INSERT INTO kdl_vpl VALUES ("NM1_12","035_1_12","NAM","1","12","12","Ili iꞌya Magono ma Zuba ma danai iꞌya na: <<Ko an u wokoi aza a Asiriya aꞌa̱ri ushani kpam n ucira, a ka wacinsa le ta̱ kpam a wuna le. Ko an u wokoi n yan vu ta̱ mavura, avu Yahuda, ma doku kpam ma yan vu mavura wa. ");
INSERT INTO kdl_vpl VALUES ("NM1_13","035_1_13","NAM","1","13","13","Gogo-na ma koɗo ta̱ maɗanga ma kulima ma a taɗangi a udyoku u vunu, n kiɗa̱sa kpam ikani iꞌya a sira̱sa vu n iꞌya.>> ");
INSERT INTO kdl_vpl VALUES ("NM1_14","035_1_14","NAM","1","14","14","Ili iꞌya Magono ma Zuba ma danai a kaci ka vunu Niniba iꞌya na: <<Va doku va tsa̱ra̱ mmuku n tsikaya aza ɗa a ka wushuku kala ka vunu wa. Ma wacinsa ta̱ gba̱ ameli a vunu, hal n ameli a urim a ɗa vu dara̱kpusai a ɗa aꞌa̱ri a kunu ka ameli a vunu. Ma foɓusuko vu ta̱ kasaun, kpaci va̱ra̱ n kalen wa.>> ");
INSERT INTO kdl_vpl VALUES ("NM1_15","035_1_15","NAM","1","15","15","Wundya, uza ɗa wa tuko kadyanshi ka shinga ki wa wala a zuba u nsasa, uza u ɗa wa yan kalamu ka ndishi n shinga! Kirana n abiki a vunu Yahuda, kpam vu shaɗangu utsina u vunu. Aza a cingi a ka doku a ka tuko vu kuvon wa; a ka wacinsa le ta̱ gba̱. ");
INSERT INTO kdl_vpl VALUES ("NM2_1","035_2_1","NAM","2","1","1","Utokulalu u vunu u ꞌya̱nga̱sa̱ka̱ vu ɗe, avu Niniba, zuwa awundi a asaga a pige a ilyuci i vunu, awundi ure, foɓuso kaci ka vunu adama a kuvon, ɓolomgbono gba̱ avonshi a vunu! ");
INSERT INTO kdl_vpl VALUES ("NM2_2","035_2_2","NAM","2","2","2","Kpaci Magono ma Zuba ma gonuko ta̱ karinga̱ ka Yahuda yavu ka aza a Isaraꞌila, ko an u wokoi atokulalu a nangasai u ɗa u wokoi bawu kalen kpam a nangasai atyangi a atyaci a le. ");
INSERT INTO kdl_vpl VALUES ("NM2_3","035_2_3","NAM","2","3","3","Nra̱ga̱ ma avonshi a utokulalu yi n shili n ɗa; avonshi a ne aminya a mini ma ma iyen ma a ukai. Nringongo ma urim ma adoki a le ma laɗa kain ka a foɓuso le; aꞌa̱ri ura̱ɗugbusa̱ nsari n le. ");
INSERT INTO kdl_vpl VALUES ("NM2_4","035_2_4","NAM","2","4","4","Adoki a ɗa aꞌa̱ri na̱ nringongo ma adoki aꞌa̱ri ilyaɗi cika a ure, aꞌa̱ri a ubana n agoni ko nte wa a asuvu a akura̱ a ilyuci yi. A ka wakana̱sa yavu akina a macikalu; a ka wurusa yavu ulaɗa. ");
INSERT INTO kdl_vpl VALUES ("NM2_5","035_2_5","NAM","2","5","5","Magono ma Niniba ma isa̱i azapige a asoje a ne, gba̱ n nala a ta̱ɗa̱tsa̱i a ure. Aꞌa̱ri maloko a ubana a asu u asaga a ilyuci yi; a zuwai nra̱ga̱ n ɗa ma ka̱nga̱ le a asu vi. ");
INSERT INTO kdl_vpl VALUES ("NM2_6","035_2_6","NAM","2","6","6","A kara̱kpai ure u mini aku kuwa ku tsugono ku wa̱sa̱i. ");
INSERT INTO kdl_vpl VALUES ("NM2_7","035_2_7","NAM","2","7","7","A foɗoi aminya a uka u magono a lazai n eyi. Nkere n ɗa ma̱ri agbashi a ka yan ulapa u una̱ a ka sa̱ yavu aꞌaɗya a ka lapusa akamba a le adama a unamgba u asuvu. ");
INSERT INTO kdl_vpl VALUES ("NM2_8","035_2_8","NAM","2","8","8","Niniba wa̱ ta̱ yavu kaɗa̱ka̱ ka mini, kpam mini ma ne ma tsu wumkpa ta̱. A ka dansa, <<Shamgba, shamgba!>> shegai ko uza u kpatala kucina̱ wa. ");
INSERT INTO kdl_vpl VALUES ("NM2_9","035_2_9","NAM","2","9","9","Pura̱i azurufa n zinariya a asu u kuvon! Kuwa ku ucanga u le ka̱ri n utyoku wa, aꞌa̱ ta̱ gba̱ n utsa̱ri i icun kau-kau! ");
INSERT INTO kdl_vpl VALUES ("NM2_10","035_2_10","NAM","2","10","10","A wacinsai Niniba, a nangasa u ɗa u wokoi akpongo! Atakasuvu a ama a dara̱kpai, a ka jeke ikyamba, aꞌa̱ kpam n ucira wa upetiwaꞌeshi u le u wa̱ra̱ma̱i. ");
INSERT INTO kdl_vpl VALUES ("NM2_11","035_2_11","NAM","2","11","11","Nte gogo-na kaɗa̱ka̱ ka igabako ka̱ri, a asu u ɗa a ka lina̱ka mmuku n le, a asu u ɗa agono n anuku a igabako a tsu bansa, na̱ mmuku n le, a ka pana kpam uwonvo wa? ");
INSERT INTO kdl_vpl VALUES ("NM2_12","035_2_12","NAM","2","12","12","Gabako u tsu wuna ta̱ ili iꞌya i tsu rawa yi na̱ mmuku n ne u piyanla kpam udyoku u manama mi u wuna, aku u shaɗangu kaaɓuru ka ne n ili iꞌya u wunusai kaɗa̱ka̱ ka ne kpam na̱ nnama n mete n ɗa a wunai. ");
INSERT INTO kdl_vpl VALUES ("NM2_13","035_2_13","NAM","2","13","13","Magono ma Zuba ma Ucira Gba̱ u danai, <<Ma yan ta̱ tsilala n avu. Ma runukpa ta̱ gba̱ nringongo ma adoki a vunu, kpam burundu u kuvon wa wuna ta̱ asoje a vunu. Ma ɓishinka vu ta̱ vu wuna ama a likimba. Ala̱ga̱tsu a asuki a vunu a ka doku a ka pana a ɗa wa.>> ");
INSERT INTO kdl_vpl VALUES ("NM3_1","035_3_1","NAM","3","1","1","Ter vunu ilyuci i uwotsongusu mpasa, u ɗa u shaɗangi n kaɓan n ucanga u ɗa a pura̱i a asu u kuvon! ");
INSERT INTO kdl_vpl VALUES ("NM3_2","035_3_2","NAM","3","2","2","Pana! Mawura̱ ma kajaɓu, n mawura̱ ma nshingi ma nringongo ma adoki, n tyoku ɗa adoki a tsu suma kuzugam-kuzugam n ugba̱ɗa̱ u nringongo ma adoki! ");
INSERT INTO kdl_vpl VALUES ("NM3_3","035_3_3","NAM","3","3","3","Ayuwi adoki aꞌa̱ri a uyan kuvon, iburundu iꞌa̱ri ulaɗa nsari dem ma̱ri a ulaɗa! Aza ɗa a kuwusa̱ alya pini ushani. ikyamba ya akushe, i wura ta̱ ukece, ama aꞌa̱ri a uta̱ɗa̱tsa̱ a ikyamba i akushe. ");
INSERT INTO kdl_vpl VALUES ("NM3_4","035_3_4","NAM","3","4","4","Gba̱ nala gita̱ ta̱ an u wokoi Niniba kashankala, kashankala ka shinga ka nala ka ka revei mayinsa̱ka̱, anuku a tsukunu, uza u ɗa u yinsa̱i kakuma̱ ka ama n tsishankala tsu ne a woko agbashi, ama kpam n tsuboci tsu ne. ");
INSERT INTO kdl_vpl VALUES ("NM3_5","035_3_5","NAM","3","5","5","Magono ma Zuba ma Ucira Gba̱ u danai, <<Ma yan ta̱ tsilala n avu. Ma filikpa̱ ta̱ mafatari ma vunu n pala upetiwaꞌeshi a vunu. Kakuma̱ ka ama a ka wene vu ta̱ kataɓa kpam tsugono tsa wene ta̱ uwono u vunu. ");
INSERT INTO kdl_vpl VALUES ("NM3_6","035_3_6","NAM","3","6","6","Ma tsunku va̱ ta̱ ili i icaɗi, n yan ka vu ili iꞌya bawu i gain, n gonuko vu ili i magori. ");
INSERT INTO kdl_vpl VALUES ("NM3_7","035_3_7","NAM","3","7","7","Gba̱ uza ɗa baci dem u wene vu, wa suma ta̱, aku u dana, <Niniba u woko ɗe kakpongo, ya wa sa̱ka̱ yi?> An te ma tsa̱ra̱ uza ɗa wa ta̱na̱sa̱ vu katakasuvu?>> ");
INSERT INTO kdl_vpl VALUES ("NM3_8","035_3_8","NAM","3","8","8","Avu vu la ilyuci i Tebesu ɗa, u ɗa wa̱ri a ikengi i Aga̱ta̱ a Nilu, u ɗa mini ma kyawain? Aga̱ta̱ a ɗa asu u ka̱ngu u ne, mini kpam kasaga ka ne. ");
INSERT INTO kdl_vpl VALUES ("NM3_9","035_3_9","NAM","3","9","9","Kushu n Masar ɗa ucira u ne u ɗa bawu wa̱ri n utyoku, aku Putu n Libiya alya aɓa̱ngi a ne. ");
INSERT INTO kdl_vpl VALUES ("NM3_10","035_3_10","NAM","3","10","10","Gba̱ n nala a banka yi ta̱ tsuwula̱ a uyamba u tsumoci. Hal gba̱m a gbashangusi mmuku n kenu n ne a nsandu ma ure gba̱. A varanku ta̱ azapige a ne uruta̱, aku a sa̱ra̱sai gba̱ azapige a ne n ikani. ");
INSERT INTO kdl_vpl VALUES ("NM3_11","035_3_11","NAM","3","11","11","Avu dem Niniba va so ta̱ vu gutukpa; va zama ta̱ asu u ɗa va kpawan aku vu boli asu u ɗa va kpawan a asu u utokulalu u vunu. ");
INSERT INTO kdl_vpl VALUES ("NM3_12","035_3_12","NAM","3","12","12","Gba̱ ilyuci i vunu iꞌya a kanzai n asaga a pige aꞌa̱ ta̱ yavu nɗanga n kapopi n ilimaci i kagita̱ i le; aꞌayin a ɗa baci a za̱nga̱ta̱i iꞌya, ilimaci i le i tsu rukpa̱ ta̱ a una̱ a aza ɗa a ka takuma. ");
INSERT INTO kdl_vpl VALUES ("NM3_13","035_3_13","NAM","3","13","13","Weɓele asoje a vunu, a woko ɗe yavu aka! Itsutsu i iyamba i vunu a giduwa̱ ta̱ iꞌya cika adama atokulalu a vunu; akina kpam a ka lya ta̱ nɗanga ma uguramgbana ma itsutsu i vunu. ");
INSERT INTO kdl_vpl VALUES ("NM3_14","035_3_14","NAM","3","14","14","Kene mini kpaci a ka kyawan vu ta̱ n kuvon, yan ucira u ɗa va ka̱ngu kaci ka vunu! Doku ucira u asaga a vunu, deshinku cin tsi vu yain aɓuku, aku vu fuɓuso a ɗa adama a kuma! ");
INSERT INTO kdl_vpl VALUES ("NM3_15","035_3_15","NAM","3","15","15","Gba̱ n nala, akina a ɗa a ka runukpa vu; burundu kpam u wuna vu tyoku u acu u ɗa wa lya vu. Vu doku ta̱ kakuma̱ ka vunu yavu acu, vu yain kpam kakuma̱ yavu abaruma! ");
INSERT INTO kdl_vpl VALUES ("NM3_16","035_3_16","NAM","3","16","16","Vu doku ta̱ kakuma̱ ka aza a tsilaga tsu vunu hal gba̱m a lai atala a zuba, shegai aꞌa̱ ta̱ yavu acu a ɗa a tsu takuma ili gba̱ aku kpam a imkpa a laza. ");
INSERT INTO kdl_vpl VALUES ("NM3_17","035_3_17","NAM","3","17","17","Awundi a vunu aꞌa̱ ta̱ yavu acu, azapige a vunu aꞌa̱ ta̱ yavu kakuma̱ ka acu aza a ɗa a rukpusa̱i a asaga aꞌayin a kuta̱nu, shegai kaara ka wuta̱ baci a tsu imkpa ta̱, kpam vuma reve asu u ɗa a banai wa. ");
INSERT INTO kdl_vpl VALUES ("NM3_18","035_3_18","NAM","3","18","18","Avu magono ma Asiriya, aliniki a vunu a ka gbaɗiga ɗe azapige a vunu a vakusu ɗe a ka wunvugusa. Ama a vunu a wacuwa ɗe a nsasa kpam uza wa̱ la wa ɓolomgbono le wa. ");
INSERT INTO kdl_vpl VALUES ("NM3_19","035_3_19","NAM","3","19","19","Ili iꞌa̱ la ya zuwa usa̱n u vunu u yain shana wa; usa̱n vunu wa ta̱na̱ wa. Gba̱ uza ɗa baci dem u panai ukuna u wacinsa u vunu wa ɓasa ta̱ akere adama a maza̱nga̱, kpaci ya bawu u panai ikyamba a tsicingi tsu vunu tsa bawu tsa̱ri n utyoku?");
INSERT INTO kdl_vpl VALUES ("HK1_1","036_1_1","HAB","1","1","1","Akani a Kashila̱ a ɗa Habaku matsumate u wenei a asuvu a kuwene a ɗa na. ");
INSERT INTO kdl_vpl VALUES ("HK1_2","036_1_2","HAB","1","2","2","Magono ma Zuba, hal ubana n were ɗa ma lya vu kapala n uꞌisa̱ adama a uɓa̱nga̱, kpam vu pana̱ka mu wa? N tuko kushen ku va̱ ara vunu, adama a uꞌya̱nga̱sa̱ka̱, kpam vu wauwa mu wa? ");
INSERT INTO kdl_vpl VALUES ("HK1_3","036_1_3","HAB","1","3","3","Ndya i zuwai vu zuwa mu n wenei ukuna u cingi u na? Ndya i zuwai vu a̱sa̱ka̱i aza a ukuna u cingi? Mawunuka n uꞌya̱nga̱sa̱ka̱ u ɗa na a kapala ka va̱; ama ɗa a kyawan mu aza a uciga kushulu n kananamgbani a ɗa. ");
INSERT INTO kdl_vpl VALUES ("HK1_4","036_1_4","HAB","1","4","4","Adama a nala a ka tono kpam mele wa, afada a ɗa aꞌa̱ri dere a ka yan kpam manyan wa. Tsicingi tsu kyawan ɗe ukuna u maci, adama a nala ɗa a ka kpatala̱sa afada a maci. ");
INSERT INTO kdl_vpl VALUES ("HK1_5","036_1_5","HAB","1","5","5","Magono ma Zuba ma danai, <<Weɓele kakuma̱ ka ama vu wene, va yan ta̱ majiyan cika, kpaci ma yan ta̱ ili i roku aꞌayin a ɗe iꞌya bawu ya wushuku n iꞌya, ko a tonuko ɗa̱ baci. ");
INSERT INTO kdl_vpl VALUES ("HK1_6","036_1_6","HAB","1","6","6","Wundya, ma na̱ka̱ ta̱ aza a Babila ucira, uyamba u ɗa wa̱ri n asuvu a shen n kushulu. Aza a ɗa aꞌa̱ri a kutambu ko nte wa a likimba, tsa̱ra̱ a wususa asu u ndishi ɗa bawu wa̱ri u le. ");
INSERT INTO kdl_vpl VALUES ("HK1_7","036_1_7","HAB","1","7","7","Aza ɗa aꞌa̱ri n u yanki u uwonvo n u giruwuka̱, n a yanyi afada a le tyoku ɗa a ka ciga a yanka kpam kaci ka le tyoku ɗa u gan le. ");
INSERT INTO kdl_vpl VALUES ("HK1_8","036_1_8","HAB","1","8","8","Adoki a le a la ta̱ anama ilyaɗi, asuvu a shen a le a la ta̱ a nleweni n ɗa ma̱ri n kambulu. Adoki a asoje a le a tsu tuwa̱ ta̱ n agoni, asoje a le kpam mɓa̱ri n ɗa a tsu wuta̱. A tsu imkpa ta̱ tyoku maguri n maloko ma ufula̱. ");
INSERT INTO kdl_vpl VALUES ("HK1_9","036_1_9","HAB","1","9","9","Gba̱ le a tsu tuwa̱ ta̱ adama a uꞌya̱nga̱sa̱ka̱, a tsu pana ta̱ uwonvo u le kahu a rawa. A tsu ɓolomgbono ta̱ agbashi ushani yavu kayala. ");
INSERT INTO kdl_vpl VALUES ("HK1_10","036_1_10","HAB","1","10","10","A tsu yanka ta̱ ngono majari, a dosuso kpam nkoshi. A tsu goro ta̱ ilyuci iꞌya a kanzai n asaga, aku a ɓolomgbono kayala a yuwa̱ a lyai iꞌya n kuvon. ");
INSERT INTO kdl_vpl VALUES ("HK1_11","036_1_11","HAB","1","11","11","A tsu wura ta̱ n maloko yavu uwule. Ele aza a unyushi a ɗa, aza ɗa a bidyai ucira u le u woko le kashila̱.>> ");
INSERT INTO kdl_vpl VALUES ("HK1_12","036_1_12","HAB","1","12","12","Magono ma Zuba, a ɗa va̱ri hal a ubana! Magono ma Zuba Kashila̱ ka va̱, ka Uwulukpi u va̱, avu va kuwa̱ wa. Magono ma Zuba, aɗa vu zuwai aza a Babila a yanka tsu afada. Aɗa Katali ka va̱, aɗa vu ɗanga̱sa le a yan tsu mavura. ");
INSERT INTO kdl_vpl VALUES ("HK1_13","036_1_13","HAB","1","13","13","Aꞌeshi a vunu aꞌa̱ ta̱ uwulukpi, vu tsu fuɗa vu weɓele ukuna u cingi wa, kpaci vu tsu ciga ukuna u cingi wa. Ndya i zuwai vu a̱sa̱ka̱i aza a ukuna u cingi n aza a mayinsa̱ka̱? Ndya i zuwai vu paɗai bini, va wundya ama a cingi a ka kaɗuwunsa aza ɗa a la le ukuna u maci? ");
INSERT INTO kdl_vpl VALUES ("HK1_14","036_1_14","HAB","1","14","14","Niɗa va yan n ama tyoku u adan a kushiva̱, ko yavu ili iꞌya ya ka̱bura̱ iꞌya bawu aꞌa̱ri n uzapige? ");
INSERT INTO kdl_vpl VALUES ("HK1_15","036_1_15","HAB","1","15","15","Aza a Babila yi, a tsu ka̱na̱ ta̱ ama tyoku ɗa uza u kuga̱ u tsu ka̱na̱ adan. A rono le n ibilili aku a yain isali i maza̱nga̱ an a ka̱na̱ le. ");
INSERT INTO kdl_vpl VALUES ("HK1_16","036_1_16","HAB","1","16","16","Adama a nala, a tsu lyaka ta̱ ibilili i le kayala hal a yain uɗara̱kpa, kpaci ibilili i le i ka̱na̱ka̱ le ta̱ ili i shinga iꞌya a lakai uciga. ");
INSERT INTO kdl_vpl VALUES ("HK1_17","036_1_17","HAB","1","17","17","Nala va a̱sa̱ka̱ a lyai kapala n uka̱na̱sa̱ u ama n ibilili i le a ubana, tsa̱ra̱ a lyai kapala n uwacinsa kakuma̱ ka ama bawu asuvayali? ");
INSERT INTO kdl_vpl VALUES ("HK2_1","036_2_1","HAB","2","1","1","Ma yuwa̱ ta̱ kunukuzuba ku uza u uwundya n wene, n pana kpam ili iꞌya Magono ma Zuba ma tonuko mu, n tyoku ɗa ma wushuku a kaci ka kushen ku va̱ ki. ");
INSERT INTO kdl_vpl VALUES ("HK2_2","036_2_2","HAB","2","2","2","Aku Magono ma Zuba ma wushunku mu, u danai, <<Korongu kuwene ki kpam ku wuta̱ mai a agbagala a atali, kotsu uza ɗa wa yan ka̱neshi vi u yain u ɗa mai n u wali. ");
INSERT INTO kdl_vpl VALUES ("HK2_3","036_2_3","HAB","2","3","3","Korongu kuwene ki, kpaci aꞌayin a ɗa a ɗanga̱sa̱kai kuwene ki kotsu a yan wa. Shegai aꞌayin a ka tuwa̱ ta̱ n maloko, kpam ili iꞌya n wenike vu vi ya woko ta̱ mayun. Ko aꞌayin yi a tuwa̱ baci n maloko wa, vu vana. Mayun ɗa ukuna vi wa gita̱, kpam wa ɓa̱ra̱kpa̱ wa. ");
INSERT INTO kdl_vpl VALUES ("HK2_4","036_2_4","HAB","2","4","4","<<Akani a ɗa na: <Uza ɗa baci bawu katakasuvu ka ne ka̱ri dere, wa kuwa̱ ta̱, shegai uza ɗa wa yan ukuna u maci wa yan ta̱ uma, kpaci wa yan ta̱ ukuna u mayun n Kashila̱.> >> ");
INSERT INTO kdl_vpl VALUES ("HK2_5","036_2_5","HAB","2","5","5","Mini ma cinwi ma tsu vurusa̱ ta̱ vuma, aꞌa̱ ta̱ n ugbami u kaci n ara̱ɗi bawu a ka wunvuga, wa̱ ta̱ yavu ukpa̱ bawu wa ciwa̱. Adama a nala ɗa a tsu lya uyamba adama a kaci a le. ");
INSERT INTO kdl_vpl VALUES ("HK2_6","036_2_6","HAB","2","6","6","<<Gba̱ ama yi a ka yanka yi ta̱ majari n a dosusi yi n magori, n a dansi, <<Ter vunu, avu uza ɗa va ɓolomgbonusuko kaci ka vunu ili iꞌya bawu iꞌa̱ri i vunu! Hal nwere ɗa va ɓolomgbonusuko kaci ka vunu udukuyan a asu maryafuka?>> ");
INSERT INTO kdl_vpl VALUES ("HK2_7","036_2_7","HAB","2","7","7","Maken ma̱ la wa, aza ɗa a ka tono vu kutan a ka ꞌya̱nga̱sa̱ka̱ vu ta̱ bawu vu revei. Aza ɗa a ka tono vu kutan a ka rikpa̱na̱ka̱ ta̱ a zuwa vu ujeke ikyamba, kpam va woko le ta̱ ucanga u ɗa a pura̱i a asu u kuvon. ");
INSERT INTO kdl_vpl VALUES ("HK2_8","036_2_8","HAB","2","8","8","An u wokoi vu purusa̱i ucanga u ama a uyamba ushani, gba̱ aza ɗa a lai a ka purusa̱ vu ta̱ dem ucanga. Nala wa gita̱ ta̱ kpaci vu wotsongusu ta̱ mpasa ma ama, n kunangasu ka vu yankai iyamba, n ilyuci i pige i pige n aza ɗa aꞌa̱ri pini ndishi gba̱. ");
INSERT INTO kdl_vpl VALUES ("HK2_9","036_2_9","HAB","2","9","9","<<Ter vunu, avu uza ɗa va zamuka kuwa ku vunu utsa̱ri a asu u yan ukuna u cingi, va maka kaci ka vunu kuwa a zuba u masasa, tsa̱ra̱ vu wauwa kaci ka vunu a asu ukuna u cingi! ");
INSERT INTO kdl_vpl VALUES ("HK2_10","036_2_10","HAB","2","10","10","Afoɓi a cingi a vunu a ronuko ta̱ kuwa ku vunu uwono, an u wokoi vu wunusai ama ushani, kpam avu dem a ka wuna vu ta̱. ");
INSERT INTO kdl_vpl VALUES ("HK2_11","036_2_11","HAB","2","11","11","Hal n atali a kuma ku asaga a vunu a ka sa̱ a kaci ka vunu, nɗanga n kusapu dem n wushuki. ");
INSERT INTO kdl_vpl VALUES ("HK2_12","036_2_12","HAB","2","12","12","<<Ter vunu, avu uza ɗa va ma ilyuci na̱ mpasa ma ama, kpam va shigba̱ ilyuci i pige a asu u uyan ukuna u cingi. ");
INSERT INTO kdl_vpl VALUES ("HK2_13","036_2_13","HAB","2","13","13","Panai na, uciga u Magono ma Zuba Uza u Ucira Gba̱ u ɗa ama a yain manyan tsa̱ra̱ akina a lyai gbani wa? Iyamba kpam i wowotongusu kaci ka le gbani wa? ");
INSERT INTO kdl_vpl VALUES ("HK2_14","036_2_14","HAB","2","14","14","Shegai likimba wa shaɗangu ta̱ n ureve u tsupige tsu Magono ma Zuba, tyoku ɗa mini ma shaɗangi mala. ");
INSERT INTO kdl_vpl VALUES ("HK2_15","036_2_15","HAB","2","15","15","<<Ter vunu, avu uza ɗa va zuwa aza a karen a vunu a soi, va tsungusuku le tsukonu a ncuwani n a soyi hal a gutukpa, tsa̱ra̱ vu wundi le kataɓa. ");
INSERT INTO kdl_vpl VALUES ("HK2_16","036_2_16","HAB","2","16","16","A una̱ u karinga̱, va shaɗangu ta̱ n uwono. Gogo-na aɗa va so hal vu gutukpa! Kpaci macuwani ma ma̱ri a kukere ku lyaki ku Magono ma Zuba ma gono ta̱ ara vunu, aku uwono u kimba̱ tsupige tsu vunu. ");
INSERT INTO kdl_vpl VALUES ("HK2_17","036_2_17","HAB","2","17","17","Kunangasu ka vu yain a Lebanon, ka gono ta̱ a kaci ka vunu. Vu wunai nnama n ɗa ma̱ri pini, gogo-na a ka ne vu ta̱ uwonvo. Nala wa gita̱ ta̱ kpaci vu wotsongusu ta̱ mpasa ma ama, n kunangasu ka vu yankai iyamba, n ilyuci i pige i pige n aza ɗa aꞌa̱ri pini ndishi gba̱. ");
INSERT INTO kdl_vpl VALUES ("HK2_18","036_2_18","HAB","2","18","18","<<Nte kalen ka kameli ka vuma rumai, ko kameli ka urim ka ka wenishike kaɓan maco? Kpaci uza ɗa u rumai ka vi u pityanangu ta̱ n ili iꞌya u rumai, u rumai kameli ka bawu ka dansa. ");
INSERT INTO kdl_vpl VALUES ("HK2_19","036_2_19","HAB","2","19","19","Ter vunu, avu uza ɗa wa tonuko kagbukulu, <Rikpa̱na̱ka̱!> Ko kpam u tonuko katali ka bawu ka̱ri n uma, <ꞌYa̱nga̱!> Kameli ka fuɗa ka wenike ili iꞌya iꞌa̱ri usokongi? Wundya, a kumana ta̱ ka n azurufa n zinariya, shegai ka̱ri n kuvi wa. ");
INSERT INTO kdl_vpl VALUES ("HK2_20","036_2_20","HAB","2","20","20","Magono ma Zuba tani ma̱ ta̱ a Kuwa ku ne ku uwulukpi. A̱sa̱ka̱ likimba gba̱ u paɗa bini a kapala ka ne.>> ");
INSERT INTO kdl_vpl VALUES ("HK3_1","036_3_1","HAB","3","1","1","Naha ɗa kavasu ka Habaku matsumate ka u yain n ulingu u Shigiyonotu. ");
INSERT INTO kdl_vpl VALUES ("HK3_2","036_3_2","HAB","3","2","2","Magono ma Zuba, n pana ta̱ alabari a ili iꞌya vu yain, aku uwonvo u ka̱na̱ mu. Gogo-na, doku vu yain ikunesavu yi a aꞌayin a tsunu. Aꞌayin a ɗa baci vu yain upan n a̱tsu, ciɓa, vu pana asuvayali a tsunu. ");
INSERT INTO kdl_vpl VALUES ("HK3_3","036_3_3","HAB","3","3","3","Kashila̱ ka wuta̱ a Teman a uyamba u Edom wa tuwa̱, Uza u Uwulukpi wa wuta̱ a masasa ma Paran wa tuwa̱. Tsupige tsu ne tsu kimba̱ ta̱ zuba; likimba kpam u shaɗangi n icikpali i ne. Sela ");
INSERT INTO kdl_vpl VALUES ("HK3_4","036_3_4","HAB","3","4","4","U tuwa̱ ta̱ n ulaɗa yavu katyashi; katyashi ki ka wakana̱sa a akere a ne, a asu u ɗa ucira u ne wa̱ri ukpawin. ");
INSERT INTO kdl_vpl VALUES ("HK3_5","036_3_5","HAB","3","5","5","U suku ta̱ usaru a kapala ka ne, usaru u ukpa̱ kpam wa tono yi. ");
INSERT INTO kdl_vpl VALUES ("HK3_6","036_3_6","HAB","3","6","6","An u shamgbai, likimba gba̱ɗa̱ ta̱, an u weɓelei, u zuwa ta̱ kakuma̱ ka ama ka giruwa̱i. U ta̱sa̱sa̱i nsasa n aga̱la̱la̱ yuku-yuku n ɗa ma̱ri pini tun caupa. Pini ɗa ire i ne iꞌa̱ri tun caupa. ");
INSERT INTO kdl_vpl VALUES ("HK3_7","036_3_7","HAB","3","7","7","N wene ta̱ ama ɗa aꞌa̱ri ndishi a atani aza a Kushan a asuvu a upana u ikyamba, aza a Midiya a ka jeke ikyamba adama a uwonvo. ");
INSERT INTO kdl_vpl VALUES ("HK3_8","036_3_8","HAB","3","8","8","Magono ma Zuba, va yan upan n aga̱ta̱ ko ayenete a mini ɗa? Va suɗugba asuvu n mala ɗa? An vu yuwa̱i adoki a vunu na̱ nringongo ma adoki a vunu, vu tuwa̱ ta̱ adama a iwauwi. ");
INSERT INTO kdl_vpl VALUES ("HK3_9","036_3_9","HAB","3","9","9","Vu foɓuso ta̱ utaun u vunu, aku vu foɓusoi vu taku aya. Sela An katyashi ka vunu ka wakanai aku iyamba i ɓatsai aga̱ta̱ a wuta̱i. ");
INSERT INTO kdl_vpl VALUES ("HK3_10","036_3_10","HAB","3","10","10","Nsasa n pige n wene vu, aku a ka jeke ikyamba. A ro ta̱ mini ma pige; mala ma̱ri a mawura̱, aku aɓali a ꞌya̱nga̱i ubana a zuba. ");
INSERT INTO kdl_vpl VALUES ("HK3_11","036_3_11","HAB","3","11","11","Kaara n uwoto a shamgba ta̱ asu u te a zuba, aꞌayin a ɗa aya a vunu ka wurusa n a laɗi kaɓolo n katyashi ka masari ka vunu. ");
INSERT INTO kdl_vpl VALUES ("HK3_12","036_3_12","HAB","3","12","12","Asuvu a upan u vunu vu ɓa̱tsa̱mgba̱na̱ ta̱ likimba, n asuvu a shen a vunu kpam vu kpatsa ta̱ kakuma̱ ka ama. ");
INSERT INTO kdl_vpl VALUES ("HK3_13","036_3_13","HAB","3","13","13","Vu tuwa̱ ta̱ adama ɗa vu wauwa ama vunu, vu wauwa uza ɗa vu tsunki manivi. Vu wuna ta̱ uzapige u uyamba u ama a cingi aku vu filikpa̱ yi ili iꞌya i bidyai a kaci hal a ubana a aꞌene. Sela ");
INSERT INTO kdl_vpl VALUES ("HK3_14","036_3_14","HAB","3","14","14","Vu tawa ta̱ kaci ka uza u kuvon n kaya ka ne, aꞌayin a ɗa a tuwa̱i yavu kabatara̱kpa adama a wacinsa tsu. A ka yan maza̱nga̱ yavu aza ɗa a ryafai aza a unambi a usokongi. ");
INSERT INTO kdl_vpl VALUES ("HK3_15","036_3_15","HAB","3","15","15","Va wala n adoki a vunu vu pasai mala, vu gba̱ɗa̱ ta̱ aɓali a mini. ");
INSERT INTO kdl_vpl VALUES ("HK3_16","036_3_16","HAB","3","16","16","An n panai ukuna u nala vi, ikyamba i va̱ i gigira̱ ta̱, ajiri a va̱ a je ta̱ dem adama a uwonvo. Atele a ikyamba a va̱ a kuwa̱ ta̱, mpa pini kushani, aku aꞌene a va̱ a gita̱i udagatsa. Gba̱ n nala, ma shamgba ta̱ shiriri n vana kain ka upana u ikyamba, u ɗa wa rukpa̱ a asu u ama ɗa a ka tukuso tsu kuvon. ");
INSERT INTO kdl_vpl VALUES ("HK3_17","036_3_17","HAB","3","17","17","Ko an u wokoi nɗanga n kapopi n topo wa, kpam atyaci a cinwi a matsa wa, nɗanga n zayitum kpam n na̱ka̱ ilimaci wa, ashina kpam a matsa ilikulya wa, ncon n buwa pini a asu u nkulatsu n le wa, kpam anaka dem aꞌa̱ pini asu u nvain u le wa, ");
INSERT INTO kdl_vpl VALUES ("HK3_18","036_3_18","HAB","3","18","18","gba̱ n nala ma yan ta̱ maza̱nga̱ a asu u Magono ma Zuba, n yain ipeli n Kashila̱ Kawauwi ka va̱. ");
INSERT INTO kdl_vpl VALUES ("HK3_19","036_3_19","HAB","3","19","19","Magono ma Zuba Uzapige aya ucira u va̱; u gonuko ta̱ aꞌene a va̱ a wokoi yavu aꞌene a maren, u zuwa mu n walai yaa a zuba u masasa yavu maren. Udani ubana asu u uzapige u ashipi: A shipi u ɗa n imolo n igogi.");
ALTER TABLE kdl_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
