﻿USE sofia;
DROP TABLE IF EXISTS sofia.kdlNT_vpl;
CREATE TABLE kdlNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kdlNT_vpl WRITE;
INSERT INTO kdlNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu† Kawauwi† u wuta̱ ta̱ a kuwa ku Dawuda† Magono, matsikaya ma Ibirahi.† Makeci ma nkoshi n cau n ne ma na: ");
INSERT INTO kdlNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibirahi ɗa tata u Ishaku.† Ishaku ɗa tata u Yakubu.† Yakubu ɗa tata u Yahuza† na̱ mmuku ma aꞌali n roku. ");
INSERT INTO kdlNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuza ɗa tata u mpeshe n ɗa a ka isa̱ Farisa n Zera. (Mma u le ɗa Tama.) Farisa ɗa tata u Hesuruna. Hesuruna ɗa tata u Aram. ");
INSERT INTO kdlNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ɗa tata u Aminadabu. Aminadabu ɗa tata u Nashon. Nashon ɗa tata u Salumuna. ");
INSERT INTO kdlNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salumuna ɗa tata u Boza. (Mma u ne kpam Raha.)† Boza ɗa tata u Ubida. (Mma u ne kpam Rutu.) Ubida ɗa tata u Yese.† ");
INSERT INTO kdlNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese ɗa tata u Dawuda Magono. Dawuda ɗa tata u Solomo. (Mma u ne kpam Beteshaba ɗa uza ɗa Dawuda bokoi ara Uriya.) ");
INSERT INTO kdlNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomo ɗa tata u Rihobuwam. Rihobuwam kpam tata u Abija. Abija ɗa tata u Asa. ");
INSERT INTO kdlNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ɗa tata u Johoshafa. Johoshafa kpam tata u Joram. Joram ɗa tata u Azariya. ");
INSERT INTO kdlNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Azariya ɗa tata u Jotam. Jotam ɗa tata u Ahazu. Ahazu ɗa tata u Hazikaya. ");
INSERT INTO kdlNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hazikaya ɗa tata u Manase. Manase ɗa tata u Amo. Amo ɗa tata u Josaya. ");
INSERT INTO kdlNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaya ɗa tata u Jakoniya na̱ mmuku ma aꞌali n roku. (Aꞌayin yi a ɗa a ka̱na̱ le ubana a uyamba u Babila.)† ");
INSERT INTO kdlNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","An a bidya le ubana a Babila: Jakoniya ɗa tata u Shayala̱tiya. Shayala̱tiya ɗa tata u Zerubabe. ");
INSERT INTO kdlNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabe ɗa tata u Abihuda. Abihuda ɗa tata u Eliyakim. Eliyakim ɗa tata u Azuro. ");
INSERT INTO kdlNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azuro ɗa tata u Saduku. Saduku ɗa tata u Akimu. Akimu ɗa tata u Aliyuda. ");
INSERT INTO kdlNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Aliyuda ɗa tata u Iliyazara. Iliyazara ɗa tata u Matan. Matan ɗa tata u Yakubu. ");
INSERT INTO kdlNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakubu ɗa tata u Isuhu.† Isuhu ɗa vali u Meri.† Meri kpam aya mma u Yesu uza ɗa ama a ka isa̱ Kirisiti† Kawauwi. ");
INSERT INTO kdlNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Gba̱ aza ɗa a kecei nala vi, akaya a ɗa aꞌa̱ri pini a ɗa; akaya kupa n a nishi ili iꞌya i ka̱na̱i Ibirahi hal ubana aꞌayin a Dawuda Magono, n akaya kupa n a nishi ili iꞌya i ka̱na̱i aꞌayin a Dawuda hal ubana aꞌayin a ɗa a pura̱ le ubana a Babila tsugbashi. N akaya kupa n a nishi ili iꞌya i ka̱na̱i aꞌayin a ɗa a pura̱ le ubana a Babila tsugbashi utuwa̱ aꞌayin a Kawauwi. ");
INSERT INTO kdlNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Tyoku ɗa ilimaci i Yesu Kawauwi iꞌa̱ri ɗa na: Mma u ne u ɗa Meri uza ɗa Isuhu kenei tsumana. Shegai eyi a makere bawu u revei vali, aku u ka̱na̱i katsuma̱ n Kulu Keri.† ");
INSERT INTO kdlNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Isuhu kamana ka Meri, vuma ɗa u tsu rongo uyan ili iꞌya iꞌa̱ri derere, wa ciga u nei Meri vi uwono a aꞌeshi a ama wa, aku u yawunsai u a̱sa̱ka̱ yi usokongi. ");
INSERT INTO kdlNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Aꞌayin a ɗa wa̱ri pini uyawunsa ukuna vi, aku katsumate ka zuba† ka Magono ma Zuba ka wenikei kaci ka ne ara ne a asuvu a alavutanshi, u danai, “Isuhu, matsikaya ma Dawuda, kotsu vu pana uwonvo u ɗa va zuwa kamana ka vunu Meri wa, kpaci Kulu Keri ka ku zuwa yi u ka̱na̱ katsuma̱ ki. ");
INSERT INTO kdlNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Wa matsa ta̱ maku ma vali, aku vu neke yi kala Yesu, kpaci wa wauwa ta̱ ama a asuvu a unyushi u cingi u le.” ");
INSERT INTO kdlNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ukuna u na vi u gita̱ ta̱ tsa̱ra̱ kazuwamgbani ka Magono ma Zuba ka shaɗangu, tyoku ɗa Ishaya† matsumate† u danai caupa, ");
INSERT INTO kdlNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Makere ma bawu ma revei vali ma yan ta̱ katsuma̱, u matsa maku ma vali, aku a isa̱ yi Imanuwe.” Kalen ka kala ki ka, “Kashila̱ ka̱ ta̱ kaɓolo n a̱tsu.” ");
INSERT INTO kdlNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Aꞌayin a ɗa Isuhu rikpa̱na̱ka̱i, aku u yain dere tyoku ɗa katsumate ki ka tonuko yi. U tukoi Meri a kuwa u woko uka u ne. ");
INSERT INTO kdlNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Shegai u vaku n eyi wa hal u matsai maku mi. Aku Isuhu neke yi kala Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","A matsa ta̱ Yesu a ilyuci i Batalami a uyamba u Yahuda, aꞌayin ɗa Hiridu† wa̱ri magono. Ama roku aza ɗa a yain ka̱neshi u ukuna u atala, a wuta̱i a kasana a tuwa̱i a Urishelima† ");
INSERT INTO kdlNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","n a wecishiki, “Nte magono ma aza a Yahuda† ma a matsai vi? Tsu wene ta̱ katala a kasana ka ka wenikei an a matsa yi, kpam tsu tuwa̱i tsu lyaka yi kayala.” ");
INSERT INTO kdlNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","An Hiridu Magono u panai nala, u dambula ta̱ cika, nala dem aza ɗa aꞌa̱ri a Urishelima a rongoi a kadambula. ");
INSERT INTO kdlNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Aku u isa̱i aɗara̱kpi a pige† n awenishiki a Mele† u wece le, “Nte a ka matsa Kawauwi ki?” ");
INSERT INTO kdlNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Aku a wushunku yi, “A ilyuci i Batalami iꞌya a Yahuda. Kpaci ili iꞌya Mika matsumate u korongi iꞌya: ");
INSERT INTO kdlNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ ‘Avu, Batalami u uyamba u Yahuda, va̱ ta̱ n kalen pini a asuvu a ilyuci i pige i pige i Yahuda. A ka matsa ta̱ magono a asuvu a vunu, uza ɗa wa woko yavu kaliniki ka ama a va̱, aza a Isaraꞌila†.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Pini nala, magono mi ma isa̱i amoci a ɗa a wuta̱i a kasana ki a ba a sheshei ukpawunsi, kpam a tonuko yi derere aꞌayin a ɗa katala ki ka wuta̱i. ");
INSERT INTO kdlNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Aku u tonuko le, “ꞌYa̱nga̱i i wala ubana a Batalami vi i boli maku mi mai. I wene yi baci, i gono i tuwa̱ i tonuko mu, tsa̱ra̱ mpa dem n ba n lyaka yi kayala.” ");
INSERT INTO kdlNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Arevi yi an a panai ili iꞌya magono mi ma danai, aku a lazai. Kpam katala ka a wenei a kasana ka lazai a kapala ka le hal ka ba ka shamgbai a asu u ɗa maku mi ma̱ri. ");
INSERT INTO kdlNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","An a wenei katala ki, a yan ta̱ maza̱nga̱! ");
INSERT INTO kdlNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Aꞌayin a ɗa ama yi a uwai pini a kuwa ki, a wene ta̱ maku mi n Meri mma u ne, a kuɗa̱ngi a lyaka yi kayala. A bidyai kune ku le ku zinariya, n ucanga u magula̱ni, n ma̱r† a na̱ka̱ yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Shegai Kashila̱ ka rono le atsuvu a asuvu a alavutanshi, u da a gono a asu u magono vi wa. Aku a gonoi a uyamba u le a ure u roku kau. ");
INSERT INTO kdlNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","An arevi yi a lazai, katsumate ka Magono ma Zuba ka tuwa̱i ara Isuhu a asuvu a alavutanshi, u danai, “ꞌYa̱nga̱ vu dara̱ka vu bidya maku mi na̱ mma u ne ubana a Masar!† Vu shamgba ɗe she aꞌayin a ɗa n tonuko vu vu gono, kpaci magono ma pini ma bolo maku mi tsa̱ra̱ u wuna.” ");
INSERT INTO kdlNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Aku u ꞌya̱nga̱i u bidyai maku mi na̱ mma u ne a lazai n kayin ubana a Masar, ");
INSERT INTO kdlNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","nte a rongoi ɗe hal aꞌayin ɗa magono mi ma kuwa̱i. Ili yi i gita̱ ta̱ kotsu i wenike ili iꞌya Magono ma Zuba ma danai a una̱ u Hosiya matsumate, “N isa̱ ta̱ maku ma va̱ ma wuta̱ a Masar.” ");
INSERT INTO kdlNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Aꞌayin ɗa magono ma wenei arevi yi aꞌene a ɗa a vurusa̱ yi a ɗa, aku u panai upan. U zuwai a wunusa gba̱ mmuku ma aꞌali a Batalami, n ilyuci i kenu i kenu iꞌya iꞌa̱ri evu evu gba̱, aza a ayen a re ubana a iyamba. U reve ta̱ aꞌayin a ɗa a matsai maku mi cinda arevi yi a danai. ");
INSERT INTO kdlNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nala ili iꞌya Kashila̱ ka danai a una̱ u Irimiya† matsumate i wokoi mayun: ");
INSERT INTO kdlNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“A pana ta̱ kala̱ga̱tsu a Rama, uza roku wa sa̱ adama a unamgbukatsuma̱. Rahila† ɗa wa sa̱ adama a mmuku n ne, u ꞌyuwain u a̱sa̱ka̱ uza u ne yi kadyanshi, an u wokoi a kuwa̱ ɗe.” ");
INSERT INTO kdlNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","An Magono mi ma kuwa̱i, katsumate ka Magono ma Zuba ka tuwa̱i ara Isuhu a asuvu a alavutanshi aꞌayin ɗa wa̱ri pini a Masar vi. ");
INSERT INTO kdlNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Katsumate ki ka danai, “ꞌYa̱nga̱ vu bidya maku mi na̱ mma u ne vu gono a uyamba u Isaraꞌila, kpaci aza ɗa a ka ciga a wuna maku mi a kuwa̱ ɗe.” ");
INSERT INTO kdlNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Aku Isuhu ꞌya̱nga̱i u bidyai maku mi na̱ mma u ne a gonoi a Isaraꞌila. ");
INSERT INTO kdlNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Shegai an u revei magono ma savu mi maku ma Hiridu Magono ma; wata, Akilayu, uwonvo u ka̱na̱ yi. Aku u lavutansai kpam, Kashila̱ ka rono yi atsuvu u gono a uyamba u Galili. ");
INSERT INTO kdlNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Pini nala, a ba a dusuki a ilyuci iꞌya a ka isa̱ Nazara. Adama a nala a shaɗangu ta̱ ili iꞌya ntsumate n danai: “A ka isa̱ yi ta̱ uza u Nazara.” ");
INSERT INTO kdlNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","An a yain ayen ushani, Yahaya† Kalyuɓugi gita̱i kuɓari a kakamba ka Yahuda. ");
INSERT INTO kdlNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","U da, “Kpatalai† i a̱sa̱ka̱ tsicingi tsu ɗe, i gono a asu u Kashila̱, kpaci tsugono tsu zuba tsu yan ɗe evu n uyan.” ");
INSERT INTO kdlNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ishaya matsumate u yan ta̱ kadyanshi a kaci ka Yahaya, u da, “Uza roku wa sala̱sa a kakamba, ‘Lapulai ure adama a Asheku, shamkpai u ɗa mai tsa̱ra̱ u wala!’ ” ");
INSERT INTO kdlNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yahaya uka ta̱ aminya a ɗa a cai n tsileme tsu karakuma. U sirai kagbawatsu ka ukpan a cuku tsu ne, kpam ilikulya i ne iꞌya abaruma n ishigi. ");
INSERT INTO kdlNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ama ushani a wuta̱ ta̱ a Urishelima n Yahuda n iyamba iꞌya iꞌa̱ri uɓongu u Aga̱ta̱ a Urudu a tuwa̱i tsa̱ra̱ a pana̱ka yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","An a dansai unyushi u cingi u le, aku u lyuɓugu le pini a Aga̱ta̱ a Urudu yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Afarishi† n aza a Sadusi ushani a tuwa̱ ta̱ dem a asu u ɗa Yahaya wa lyuɓugusu ama yi tsa̱ra̱ a lyuɓugu le. An Yahaya wene le, u danai, “Eɗa̱ aꞌeku a ɗa! Ya rono ɗa̱ atsuvu i suma mavura ma Kashila̱ ka tuko n maloko? ");
INSERT INTO kdlNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Yanyi ili iꞌya ya wenike an i a̱sa̱ka̱i unyushi u ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kotsu i dana ya wura mavura mi an iꞌa̱ri mmuku n tsikaya mi Ibirahi wa. N tonuko ɗa̱, Kashila̱ ka fuɗa ta̱ ka bidya atali a na u gonuko a ɗa mmuku n tsikaya mi Ibirahi! ");
INSERT INTO kdlNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Gogo‑na naha gba̱m, kagovu ka̱ ta̱ ufoɓusi ka kapa nɗanga hal a asuvu a alu a le. Maɗanga ma baci dem bawu ma matsai ilimaci i shinga, a ka kapa ta̱ ma a varangu a asuvu a akina. ");
INSERT INTO kdlNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“N mini ma ma lyuɓugusu ɗa̱ tsa̱ra̱ u wenike an i a̱sa̱ka̱i tsicingi tsu ɗe, shegai uza ɗa wa tuwa̱ a kucina̱ ku va̱, wa lyuɓugu ɗa̱ ta̱ n Kulu Keri n akina. U la mu ta̱ ucira cika, hal gba̱m n ra̱tsa n ɓa̱na̱ akpata a ne wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Wa tuwa̱ ta̱ n kasasu ka uwelimkpe ka ne adama a kuwelikpu. U wutukpa̱ ilya kau a asuvu a kopo. Aku u tsungu ilya i shinga yi a asuvu a mapon ma ne, kopo kpam u runukpa ka n akina a ɗa bawu a ka cimba̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Aꞌayin a nala yi a ɗa Yesu a̱sa̱ka̱i Galili u banai a Aga̱ta̱ a Urudu tsa̱ra̱ Yahaya lyuɓugu yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yahaya wa̱ri wa ciga ta̱ u ꞌyuwan, u danai, “Aɗa u gain vu lyuɓugu mu. Ndya i zuwai vu tuwa̱i ara va̱ tsa̱ra̱ n lyuɓugu vu?” ");
INSERT INTO kdlNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesu wushuki, “N gogo‑na nala u gain u woko, kpaci u ka̱na̱ ta̱ tsu yain gba̱ ili iꞌya Kashila̱ ka ciga tsu tsu yain.” Aku Yahaya wushuki. ");
INSERT INTO kdlNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","An a lyuɓugi Yesu, u wuta̱ ɗe la vi pini a mini mi, aku zuba† u kukpa̱i, u wenei Kulu Keri ku Kashila̱ ku cipa̱ yi yavu kaɗya. ");
INSERT INTO kdlNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","A panai kala̱ga̱tsu a zuba, ka danai, “Maku ma va̱ ma na vi, uza ɗa ma ciga, kpam ma pana ta̱ kayanyan ka ne cika.” ");
INSERT INTO kdlNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kulu Keri ku tonoi n Yesu ubana a kakamba, kotsu Kala̱pa̱nsi† ka kondo yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Aꞌayin amangare kaara n kayin Yesu lya ilikulya wa. An a kotsoi, aku u panai kambulu. ");
INSERT INTO kdlNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Pini nala, Kala̱pa̱nsi ka tuwa̱i ka tonuko yi, “Avu Maku ma Kashila̱† ma baci, gonuko atali a na a woko iburodi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu wushunku yi, “A korongu ta̱ a Tagara̱da u Kashila̱,† “ ‘N burodi ɗa koshi vuma wa yan uma wa, she gba̱ n kadyanshi ka ka wuta̱i a una̱ u Kashila̱.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Aku Kala̱pa̱nsi ka banka yi a Urishelima ilyuci i uwulukpi,† u zuwa yi a bilibili u Kuwa ku Kashila̱.† ");
INSERT INTO kdlNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Aku u danai, “Avu Maku ma Kashila̱ ma baci, raɗugu a ubana a iyamba, kpaci ukorongi u ɗa wa̱ri a Tagara̱da u Kashila̱: “ ‘Kashila̱ ka yanka ta̱ atsumate a ne kadyanshi adama a vunu, kpam a ka kiɓatsa vu ta̱ a akere a le, tsa̱ra̱ vu gbasha kune ku vunu a katali wa.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu wushunku yi, “Tagara̱da u Kashila̱ u dana ta̱ dem, ‘Va kondo Magono ma Zuba Kashila̱ ka vunu wa.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pini nala, Kala̱pa̱nsi ka bidya yi ubana a zuba u masasa ma ugaɗi, u wenike yi gba̱ tsugono tsu likimba kau‑kau n tsupige tsu le. ");
INSERT INTO kdlNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Aku u danai, “Va lyaka mu baci kayala, ma na̱ka̱ vu ta̱ iꞌya gba̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesu wushunku yi, “Wala vu ne mu ure Kanangasi,† Tagara̱da u Kashila̱ u dana ta̱, “ ‘Lyaka Magono ma Zuba kayala, kpam aya koshi va gbashika.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Aku Kala̱pa̱nsi ka lazai ka a̱sa̱ka̱ yi, pini nala, atsumate a zuba a tuwa̱i a kiranai n eyi. ");
INSERT INTO kdlNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","An Yesu panai alabari a ɗa a ukai Yahaya Kalyuɓugi a kuwa ku aꞌali, aku u gonoi a uyamba u Galili. ");
INSERT INTO kdlNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Shegai ɗa wa rongo a ilyuci i Nazara, aku u ba u rongoi a Kafarnahum a ikengi i Kushiva̱ ku Galili a kaɓon ka Zebulun n Nafutali. ");
INSERT INTO kdlNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nala gita̱ ta̱ tsa̱ra̱ ili iꞌya Ishaya matsumate u danai i shaɗangu: ");
INSERT INTO kdlNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“A kaɓon ka Zebulun n Nafutali, a ure ubana a kushiva̱, a kapashi ka Aga̱ta̱ a Urudu, a Galili, a asu u ɗa kakuma̱ ka Awulawa† ka̱ri. ");
INSERT INTO kdlNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ama ɗa a ka rongo a karimbi, a ka wene ta̱ katyashi ka pige. Aꞌa̱ri a ka rongo ta̱ a una̱ u ukpa̱, shegai katyashi ka wantukpa ta̱ ara le.” ");
INSERT INTO kdlNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Pini nala, Yesu gita̱i kuɓari, u danai, “Kpatalai i a̱sa̱ka̱ unyushi u cingi u ɗe, i gono a asu u Kashila̱, kpaci tsugono tsu zuba tsu yan ɗe evu.” ");
INSERT INTO kdlNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kain ka te, tyoku ɗa Yesu wa̱ri nwalu a ikengi i Kushiva̱ ku Galili, aku u wenei ama a re uza n vangu. Uza u te aya Simo, uza ɗa dem a tsu isa̱ Bituru, n Andurawu. Gba̱ le aka̱ni a adan a ɗa, a ka vuta̱la̱sa̱ ibilili i le a kushiva̱ ki. ");
INSERT INTO kdlNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Aku Yesu tonuko le, “Tono numu! Ma wenike ɗa̱ ta̱ tyoku ɗa ya tukuso ama, shegai adan kpam wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kute‑kute a a̱sa̱ka̱i ibilili i le, a tono yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","An a walai kenu, aku a wenei ama a re, uza n vangu u ne, Yakubu n Yahaya mmuku n Zabidi. Ele pini a kpatsu n tata u le n a lapulusi ibilili, aku Yesu isa̱ le. ");
INSERT INTO kdlNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kute‑kute a a̱sa̱ka̱i kpatsu ki n tata u le a tono yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu kyawain uyamba u Galili gba̱ n u wenishiki a agata a Kashila̱, n u yansi kuɓari ku Kadyanshi ka Shinga† ka tsugono tsu zuba, n u ta̱na̱si aza a mɓa̱la̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Alabari a ne a kyawain gba̱ uyamba u Galili, aku a tukusoi aza a mɓa̱la̱, hal gba̱m n ama ɗa aꞌa̱ri a uyamba u Suriya, n aza ɗa a ka pana ikyamba tsa̱ra̱ a ta̱na̱sa̱ le. Aza roku a asuvu a le aꞌa̱ ta̱ n ityoni i cingi,† aza roku ipori, hal gba̱m n awunu. Shegai Yesu ta̱na̱sa̱ le gba̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kakuma̱ ka ama ka ka wuta̱i a Galili, n Dikafoli, n Urishelima, n gba̱ uyamba u Yahuda hal n aza ɗa aꞌa̱ri a Aga̱ta̱ a Urudu a kasana ka tono yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","An Yesu wenei kakuma̱ ka ama, aku u ba u yuwa̱i a masasa u dusuki. Atoni a ne a kyawan yi, ");
INSERT INTO kdlNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","aku u gita̱ le uwenishike: ");
INSERT INTO kdlNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Kashila̱ ka zuwuka ta̱ aza ɗa a revei a ka ciga uɓa̱nga̱ ara ne una̱ u shinga, kpaci tsugono tsu zuba tsu le tsa! ");
INSERT INTO kdlNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kashila̱ ka zuwuka ta̱ aza ɗa aꞌa̱ri n unamgbukatsuma̱ una̱ u shinga, kpaci wa ta̱na̱sa̱ ta̱ atakasuvu a le. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kashila̱ ka zuwuka ta̱ aza ɗa a vakunki kaci ka le una̱ u shinga, kpaci likimba wa woko ta̱ u le. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kashila̱ ka zuwuka ta̱ aza ɗa aꞌa̱ri n maluwa ma uyan ili i maci una̱ u shinga, kpaci wa na̱ka̱ le ta̱ ili iꞌya a ka ciga vi. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kashila̱ ka zuwuka ta̱ aza a asuvayali una̱ u shinga, kpaci wa pana ta̱ dem asuvayali a le. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kashila̱ ka zuwuka ta̱ aza ɗa atakasuvu a le aꞌa̱ri sarara una̱ u shinga, kpaci a ka rongo ta̱ kaɓolo n eyi. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kashila̱ ka zuwuka ta̱ aza ɗa a ka ciga a tuko ndishi n shinga una̱ u shinga, kpaci wa isa̱ le ta̱ mmuku n ne. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kashila̱ ka zuwuka ta̱ aza ɗa a ka yan mavura an a ka yansa ili iꞌya Kashila̱ ka ciga una̱ u shinga, kpaci tsugono tsu zuba tsu le tsa. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kashila̱ ka zuwuka ɗa̱ ta̱ una̱ u shinga, aꞌayin a ɗa baci ama a wisha ɗa̱. Kashila̱ ka zuwuka ɗa̱ ta̱ una̱ u shinga, aꞌayin a ɗa baci ama a ka yan ɗa̱ mavura. Kashila̱ ka zuwuka ɗa̱ ta̱ una̱ u shinga, aꞌayin a ɗa baci ama a takpa ɗa̱ ukuna u cingi adama a va̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ama a ka yanka ɗa̱ ta̱ ili i cingi tyoku ɗa a yankai ntsumate n cau. Yanyi maza̱nga̱ n ipeli, kpaci katsupi ka ɗe ka pige ka vana ɗa̱ ta̱ a zuba.” ");
INSERT INTO kdlNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yesu lyai kapala n kadyanshi, “Eɗa mkpaɗi n likimba. Shegai nte kalen ka mkpaɗi ma̱ baci n kayanyan wa? Niɗa uza wa yankpusa kpam n ɗa? Shegai a wotsongu n ɗa a kpatsa̱sa yavu ili i gbani. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Eɗa katyashi ka likimba. Ilyuci iꞌya a mai a zuba u masasa a ka fuɗa a ka sokongu iꞌya wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","A tsu sapa macikalu a kimba̱ ma n kakotsu wa. Shegai a zuwa ma a kashamkpatsu ka ne, tsa̱ra̱ katyashi ki ka wakana aza ɗa aꞌa̱ri a pini kuwa ki. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nala kpam dem, i woko katyashi a asu u ama, tsa̱ra̱ a wene manyan ma shinga ma ɗe a cikpala Tata u ɗe u ɗa wa̱ri a zuba.” ");
INSERT INTO kdlNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yesu doki u danai, “Kotsu i wene yavu tuwa̱ ɗa n tuwa̱i tsa̱ra̱ n wacinsa Mele ma Musa† ko kpam uwenishike u ntsumate wa. N tuwa̱ n wacinsa iꞌya wa, shegai n tuwa̱ ta̱ tsa̱ra̱ ili iꞌya a danai vi i shaɗangu. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mayun ɗa ma tonuko ɗa̱, ili iꞌa̱ la ya puwa̱n a Mele mi wa, she aꞌayin a ɗa zuba n likimba a kotsoi. Ko uɗyani u kenu ko u kenukulu wa̱ la wa puwa̱n wa, she ili i na yi i shaɗangu. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Adama a nala, gba̱ uza ɗa baci u goroi mele ma kenukulu a asuvu a Mele hal u wenishikei ama a yain dem nala, a ka gonuko yi ta̱ dem uza u kenukulu a tsugono tsu zuba. Shegai uza ɗa baci u tonoi Mele mi mai, u wenishikei ma kpam, wa tsa̱ra̱ ta̱ asu u shinga a tsugono tsu zuba. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","U ka̱na̱ ta̱ utono u Mele ma Kashila̱ u ɗe u lai tyoku ɗa Afarishi n awenishiki a Mele a tsu yan. U la baci nala wa, n tonuko ɗa̱ ya uwa a tsugono tsi wa, ko kenu.” ");
INSERT INTO kdlNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yesu doki u danai, “I pana ta̱ ili iꞌya Mele ma Musa ma danai, ‘Kotsu i wuna uma u vuma gbani wa,’ kpam ‘U ka̱na̱ ta̱ a kiɗa̱ga uza ɗa baci dem u wunai uma u vuma gbani ugana.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Shegai n tonuko ɗa̱, va yan baci upan n uza u vunu, a ka kiɗa̱ga vu ta̱ ugana. Vu isa̱ baci uza u vunu “Katengeshi,” a ka banka vu ta̱ a asu u Asheshi a Pige.† Vu tonuko baci uza u vunu “Va̱ri n kalen wa,” vu yan ta̱ evu n u ɗa a ka banka vu a akina† a ɗa bawu aꞌa̱ri n utyoku. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Va̱ baci kushani a kapala ka a asuɗara̱kpa† a Kuwa ku Kashila̱ va na̱ka̱ Kashila̱ kune, kute‑kute aku vu ciɓai an uza roku wa̱ri n ukuna a kaci ka vunu, ");
INSERT INTO kdlNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","a̱sa̱ka̱ ve kune ki a asuɗara̱kpa vi, vu ba vu foli uza u niɗe vi, aku vu gono vu yain kune ku vunu. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Va̱ baci n ukuna n uza roku hal wa banka vu a asu u afada, dara̱ka vu sheshi n eyi tun iꞌa̱ri a ure kahu i rawa a kuwa ku afada ki. Kawa i rawa baci ɗe, a ka na̱ka̱ngu vu ta̱ a asu u uza u afada. Eyi kpam u na̱ka̱ ada̱ga̱ri a ne a banka vu a kuwa ku aꞌali. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mayun n tonuko vu, va wuta̱ pini a asu vi wa, she aꞌayin a ɗa vu tsupai ili iꞌya a ka tono vu gba̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Yesu lyai kapala n kadyanshi, “I pana ta̱ Mele ma Musa ma danai, ‘Kotsu vu vaku n uka u uza wa.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","N tonuko vu, vu wene baci uka, aku vu bankai uma u vunu n ukuna u gbani, vu yan ɗe la vi tsishankala n eyi a katakasuvu ka vunu. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Keshi ka ulyaki ka vunu ka zuwa vu baci vu yain unyushi u cingi, foɗo ka vu varangu. Wa laka vu ta̱ tsulobo vu namba kapashi ka ikyamba i vunu, n u ɗa a ka varangu ikyamba i vunu gba̱ a asuvu a akina. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kukere ku ulyaki ku zuwa vu baci vu yain unyushi u cingi,† kiɗa ka vu varangu! Wa laka vu ta̱ tsulobo vu namba kapashi ka ikyamba i vunu, n u ɗa ikyamba i vunu gba̱ ya uwa a asuvu a akina.” ");
INSERT INTO kdlNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Yesu doki u danai, “I pana ta̱ Mele ma Musa ma danai, ‘Uza ɗa baci dem wa pece iyolo n uka u ne, u ka̱na̱ ta̱ u na̱ka̱ yi tagara̱da u upece u iyolo.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Shegai n tonuko ɗa̱, kotsu vu pecene n uka u vunu wa, shegai u vaku baci n vali roku. Vu a̱sa̱ka̱ yi baci, va zuwa yi ta̱ u woko kashankala, nala kpam ko ya baci u zuwa yi, wa̱ ta̱ n unyushi u ɗa u bidyai uka u uza roku.” ");
INSERT INTO kdlNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Yesu doki u danai, “I pana ta̱ kpam ili iꞌya Mele ma Musa ma danai, ‘Kotsu vu kpa̱ɗa̱ ushaɗangu kazuwamgbani ka vunu wa. U ka̱na̱ ta̱ vu shaɗangu kazuwamgbani ka vu yain n Magono ma Zuba.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","N tonuko ɗa̱, kotsu vu tsina n ili i roku aꞌayin a ɗa baci ya yan kazuwamgbani wa! Zuba a asu u ɗa Kashila̱ ka̱ri ndishi u ɗa. Adama a nala, kotsu vu tsina n zuba wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Likimba asu u ɗa aꞌene a ne a tsu wunvuga ɗa. Adama a nala, kotsu vu tsina n likimba wa. Urishelima ilyuci i Magono ma Pige iꞌya, adama a nala kotsu vu tsina n iꞌya wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kotsu vu tsina n kaci ka vunu wa, kpaci va fuɗa va gonuko kenji ka te ka vunu pun ko da̱n wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Aꞌayin a ɗa baci ya yan kazuwamgbani, ili iꞌya i gain vu dana iꞌya na koshi, ‘Nala wa̱ri,’ ko tani ‘Nala wa.’ Vu dana baci iꞌya i lai la, a asu u uza u cingi vi ɗa i wuta̱i.” ");
INSERT INTO kdlNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Yesu doki u lyai kapala n kadyanshi, “I pana ta̱ ili iꞌya Mele ma Musa ma danai, ‘Uza u foɗo baci utoku u ne a keshi, ko u takpa yi kanga, eyi dem a ka foɗo yi ta̱ keshi ka ne ko takpa kanga ka ne.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Shegai n tonuko ɗa̱, kotsu i tsupa ukuna u cingi u ɗa uza roku u yanka ɗa̱ n ukuna u cingi wa. Uza u ɓasa vu baci a kagbaguzu ka ulyaki, kpatala̱ka yi ka ire ki dem. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Gaawan uza roku u dana ta̱ vu nusuka yi, aku u tonukoi uza u afada u wushika yi matogo ma vunu, kotsu vu a̱sa̱nka̱ yi dem kunya. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kasoje ka ma̱tsa̱ vu baci vu canka yi ucanga ubana mel u te, canka yi mel u re. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Uza u folo vu baci ili i roku, vu na̱ka̱ yi. Uza roku u bolo baci akopi ara vunu, vu na̱ka̱ yi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Yesu doki u danai, “I pana ta̱ ili iꞌya ama a danai, ‘Ciga uza u karen u vunu, aku vu kovi utokulalu u vunu.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Shegai n tonuko ɗa̱ i cigi atokulalu a ɗe, i yanka uza ɗa baci dem wa yan ɗa̱ mavura gbani‑gbani kavasu. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","I yan baci nala, ya woko ta̱ mmuku n maci† n Tata u ɗe ɗa wa̱ri a zuba. U tsu zuwa ta̱ kaara ka wuta̱ adama a aza a cingi n aza a maci. U tsu ro ta̱ mini a asu u aza ɗa a ka yan ili i shinga n aza ɗa a ka yan ili i cingi. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Niɗa ya ciga Kashila̱ ka na̱ka̱ ɗa̱ katsupi ka malen ma manyan ma ɗe, i ciga baci aza ɗa a ka ciga ɗa̱ koshi? Ko aza a uwusha u utafa dem nala a tsu yansa! ");
INSERT INTO kdlNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Aje a ɗe a ɗa baci ya yansa̱ka ili i shinga koshi, i lamgbana n ama ɗa a buwai wa. Ko aza ɗa bawu a revei Kashila̱ a tsu yan ta̱ dem ili i shinga a asu u aje a le. ");
INSERT INTO kdlNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Adama a nala, u ka̱na̱ ta̱ i woko ushaɗangi, tyoku ɗa Tata u ɗe u zuba wa̱ri ushaɗangi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesu lyai kapala n u wenishiki atoni a ne, “Kiranai aꞌayin a ɗa ya yan ili i shinga, kotsu i yain iꞌya adama a ɗa ama a ka wene iꞌya a cikpala ɗa̱ wa. I yan baci nala, ya tsa̱ra̱ katsupi ka malen ma manyan ma ɗe a asu u Tata u ɗe uza ɗa wa̱ri a zuba wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Va ne baci aza a unambi kune, kotsu vu fula̱ ukakaci tsa̱ra̱ ama a pana a reve iꞌya va yan wa, tyoku ɗa aza a maci a kaɓan a tsu yansa a agata a Kashila̱ n ire tsa̱ra̱ ama a na̱ka̱ le karinga̱.” Mayun n tonuko ɗa̱, aza a maci a kaɓan a nala yi a tsa̱ra̱ ɗe katsupi ka malen ma manyan ma le. ");
INSERT INTO kdlNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Aꞌayin a ɗa baci va ne aza a unambi kune, vu yain ka usokongi, tsa̱ra̱ kukere ku ugula̱ ku reve ili iꞌya kukere ku ulyaki ka yan wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Na̱ka̱ kune ku vunu usokongi, Tata u vunu, uza ɗa u revei ili iꞌya iꞌa̱ri usokongi, wa na̱ka̱ vu ta̱ katsupi ka malen ma manyan ma vunu.” ");
INSERT INTO kdlNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Yesu doki u danai, “Aꞌayin a ɗa baci ya yan kavasu, i woko tyoku u aza a maci a kaɓan wa! A tsu ciga ta̱ a shamgba a agata a Kashila̱ n ire a yain kavasu tsa̱ra̱ ama a wene le. Mayun n tonuko ɗa̱, a tsa̱ ɗe katsupi ka malen ma manyan ma le. ");
INSERT INTO kdlNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Aꞌayin a ɗa baci va yan kavasu, uwa a asuvu a kunu ku vunu vu gida̱ku utsutsu. Vu yain kavasu ubana a asu u Kashila̱ Tata u vunu uza ɗa wa̱ri a asu u usokongi u nala vi. Tata u vunu uza ɗa wa wene ili iꞌya va yan usokongi, wa na̱ka̱ vu ta̱ katsupi ka malen ma manyan ma vunu. ");
INSERT INTO kdlNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Va yan baci kavasu, kotsu vu woko tyoku u ama ɗa bawu a revei Kashila̱ wa. A la ta̱ uyan kadyanshi ka bawu ka̱ri n kalen. N a dani Kashila̱ ka pana̱ka le adama a kakuma̱ ka kadyanshi. ");
INSERT INTO kdlNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kotsu i woko tyoku u le wa. Tata u ɗe u reve ta̱ ili iꞌya ya ciga kahu gba̱m i weci yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Ya yan baci kavasu, i vasi naha: “ ‘Tata u tsunu uza ɗa wa̱ri a zuba. A kirana n kala ka vunu n uwulukpi. ");
INSERT INTO kdlNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Tsugono tsu vunu tsu tuwa̱. A̱sa̱ka̱ a yain ili iꞌya va ciga a yain a likimba, tyoku ɗa a ka yansa iꞌya a zuba. ");
INSERT INTO kdlNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ne tsu ilikulya i ara. ");
INSERT INTO kdlNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Vu cimbusuka̱ tsu unyushi u tsunu, tyoku ɗa tsu tsu cimbusuka̱ aza ɗa a tsu nusuka tsu.  ");
INSERT INTO kdlNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kotsu vu a̱sa̱ka̱ tsu tsu rukpa̱ a ukondo wa, shegai vu wauwa tsu a asu u uza u cingi vi.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Mayun ɗa, vu cimbusuka̱ baci ama unyushi u cingi u le, Tata u vunu u ɗa wa̱ri a zuba wa cimbusuka̱ vu ta̱ dem. ");
INSERT INTO kdlNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Shegai vu cimbusuka̱ baci ama wa, Tata dem wa cimbusuka̱ vu unyushi u cingi u vunu wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yesu doki u danai, “Ya yan baci kakuli, kotsu i wenike kadambula tyoku ɗa aza a maci a kaɓan a tsu yan wa. A tsu ga̱cuwunsa̱ ta̱ aꞌeshi a le tsa̱ra̱ ya dem reve an a ka yan kakuli. Mayun n tonuko ɗa̱, aza a maci a kaɓan a nala yi a tsa̱ ɗe katsupi ka malen ma manyan ma le. ");
INSERT INTO kdlNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Shegai va yan baci kakuli, vu za̱ɗi kenji ka vunu aku vu sawa aꞌeshi. ");
INSERT INTO kdlNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Adama a nala, uza wa̱ la wa reve an va yan kakuli wa, she Tata koshi, uza ɗa bawu tsa wene. U reve ta̱ gba̱ ili iꞌya iꞌa̱ri usokongi, aya kpam wa na̱ka̱ vu katsupi ka malen ma manyan ma vunu.” ");
INSERT INTO kdlNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Yesu doki u danai, “Zuwukai kaci ka ɗe utsa̱ri a likimba wa. Kpaci karan n urumgba̱ wa nangasa ta̱ u ɗa, kpam aboki a ka ta̱sa̱ ta̱ a uwa a yain uboki. ");
INSERT INTO kdlNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Shegai zuwukai kaci ka ɗe utsa̱ri a zuba, a asu u ɗa bawu wa rumgba̱ ko tani karan ka nangasa, kpam aboki a ka fuɗa a ka yan uboki wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Asu u ɗa baci utsa̱ri u ɗe wa̱ri, nte dem katakasuvu ka ɗe ka rongo ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Aꞌeshi aꞌa̱ ta̱ tyoku u macikalu ma ikyamba. Aꞌeshi a vunu a lobono baci, ikyamba i vunu dem ya shaɗangu ta̱ n katyashi. ");
INSERT INTO kdlNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Shegai aꞌeshi a vunu a lobono baci wa, ikyamba i vunu ya shaɗangu ta̱ n karimbi. Katyashi ka ka̱ri a asuvu a vunu ka karimbi ka baci, va̱ ta̱ a asuvu a karimbi ka pige. ");
INSERT INTO kdlNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Vuma wa̱ la wa gbashika azakuwa a re wa. Kpaci wa kovo ta̱ uza u te, aku u cigi uza u te. Ko tani u toni ukuna u uza u te, aku u goro u uza u te. Va fuɗa va gbashika Kashila̱ kaɓolo n utsa̱ri wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Yesu doki u danai, “N tonuko ɗa̱, kotsu i yain kadambula adama a ilikulya n ili iꞌya ya so kotsu i rongo n uma wa. Kotsu i yain kadambula adama a ili iꞌya ya uka a ikyamba i ɗe wa. Uma u la ta̱ ilikulya, ikyamba kpam i la ta̱ aminya. ");
INSERT INTO kdlNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Weɓelei ve nnu n zuba! A tsu ce wa a tsu kapa tani wa. Aꞌa̱ na̱ mpon ko kuzuwate ku ucanga wa. Gba̱ n nala, Tata u zuba u tsu lyatangu le ta̱. I reve i lai nnu kalen cika wa? ");
INSERT INTO kdlNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ya wa fuɗa wa doku kaci ka ne uma a ulapa u uwule u te adama a kadambula? ");
INSERT INTO kdlNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ndya i zuwai iꞌa̱ri kadambula adama a aminya? Weɓelei tyoku ɗa apa̱lu a mete a tsu gbonguro. A tsu yan manyan wa, a tsu jila̱ka̱ kaci ka le aminya wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Shegai n tonuko ɗa̱, ko Solomo n tsupige tsu ne gba̱ u uka aminya a ikali a ɗa a lobonoi tyoku u a le wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kashila̱ ka fuɗa baci ka guɓa apa̱lu a mete a ɗa aꞌa̱ri n uma ara, nakpan a vuta̱la̱ le a akina. Ya fuɗa ta̱ ya wushuku an Kashila̱ ka guɓa ɗa̱. Kotsu i rongo n upityanangu u kenu wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Kotsu i dambula i dana, ‘Ndya tsa lya?’ ko ‘Ndya tsa so?’ ko ‘Ndya tsa uka?’ ");
INSERT INTO kdlNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ama ɗa bawu a revei Kashila̱ alya a tsu dambula n ili i nala yi koshi. Tata u ɗe u zuba u reve ta̱ ya ciga ili i nala yi gba̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ili iꞌya i gain i gita̱ i zami iꞌya tsugono tsu Kashila̱† n ili iꞌya wa ciga. Aku ili iꞌya i buwai dem a ka na̱ka̱ ɗa̱ ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kotsu i dambula adama a nakpan wa, kpaci nakpan wa̱ ta̱ n kadambula ka kaci ka ne. Kain dem ka̱ ta̱ n kadambula ka ne.” ");
INSERT INTO kdlNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yesu lyai kapala n u wenishiki atoni a ne, “Kotsu i yanka uza u afada wa, adama a ɗa Kashila̱ ka yanka ɗa̱ dem. ");
INSERT INTO kdlNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kakundatsu ka i yankai aza a ɗe afada, ka dem a ka yanka manyan tyoku ɗa eɗa̱ dem i yain. ");
INSERT INTO kdlNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Ndya i zuwai vu wenei macuku ma kenukulu ma ma̱ri a keshi ka utoku u vunu, aku bawu vu wenei kagbukulu ka ka̱ri a keshi ka vunu? ");
INSERT INTO kdlNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Niɗa va fuɗa va tonuko yi, ‘Utoku u va̱, a̱sa̱ka̱ n takpa vu macuku ma ma̱ri a keshi ka vunu,’ avu tani vu wene kagbukulu ka ka̱ri a keshi ka vunu wa? ");
INSERT INTO kdlNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Avu uza u maci u kaɓan, gita̱ ve vu takpa kagbukulu ka ka̱ri a keshi ka vunu. Aku vu fuɗa vu wene kpam vu takpa macuku ma ma̱ri a keshi ka utoku u vunu. ");
INSERT INTO kdlNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Kotsu i na̱ka̱ nshe ili iꞌya iꞌa̱ri i Kashila̱ wa. A ka fuɗa ta̱ a yira̱la̱kpa̱ a lumusa ɗa̱. Kotsu i vuta̱la̱ igbegu i ikebe a kapala ka mburusunu wa, kpaci a ka kpatsa ta̱ iꞌya.” ");
INSERT INTO kdlNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yesu doki u danai, “Rongoi ufolo, a ka ne ɗa̱ ta̱ iꞌya i foloi vi. Rongoi ubolo ili iꞌya ya ciga, ya tsa̱ra̱ ta̱. Kuɗusai utsutsu, Kashila̱ ka zuwa ta̱ a giduwuka̱ ɗa̱ utsutsu vi. ");
INSERT INTO kdlNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Adama a nala, gba̱ uza ɗa baci dem u foloi, a ka ne yi ta̱. Uza ɗa baci kpam u boloi, wa tsa̱ra̱ ta̱. Kpam ama a lya baci kapala n ukuɗusa utsutsu, Kashila̱ ka giduwuka̱ le ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Uza wa̱ la a asuvu a ɗe maku ma ne ma folo yi burodi, aku u na̱ka̱ yi katali? ");
INSERT INTO kdlNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ko tani u foli yi kadan, aku u na̱ka̱ yi kali? ");
INSERT INTO kdlNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Eɗa̱ aza a unyushi u cingi, i tsu na̱ka̱ baci mmuku n ɗe ili i shinga, bele Tata u ɗe uza ɗa wa̱ri a zuba uza u shinga, wa na̱ka̱ ta̱ ili i shinga a asu u uza ɗa baci dem u folo yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Yankai ama tyoku ɗa dem ya ciga a yanka ɗa̱. Kalen ka Mele ma Musa n uwenishike u ntsumate u ɗa gai la vi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Yesu danai, “Uwai a tsugono tsu Kashila̱ a utsutsu u kenu. Kpaci utsutsu n ure u ɗa u tsu banka a akina wa̱ ta̱ n upeti cika, kpam u lobono ta̱ nwalu. Ama ushani a ɗa a tsu wala pini. ");
INSERT INTO kdlNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Shegai utsutsu u utsa̱ra̱ uma u kenu u ɗa, ure vi kpam u wuyana ta̱ nwalu. Ama ɗa a ka wala pini aꞌa̱ ushani wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yesu lyai kapala n kadyanshi, “Kiranai na̱ ntsumate n kaɓan. Aza ɗa a tsu tuwa̱ ara ɗe yavu ncon, shegai a asuvu a le aꞌa̱ ta̱ n tsicingi yavu nleweni. ");
INSERT INTO kdlNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ya fuɗa ta̱ ya reve le a icun i manyan ma le, tyoku ɗa i tsu reve maɗanga a ilimaci i ne. A tsu ta ilimaci i kapopi a kawana wa, ko kpam cinwi a kaworo wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Maɗanga ma shinga ma tsu matsa ta̱ ilimaci i shinga, maɗanga ma cingi kpam ma tsu matsa ta̱ ilimaci i cingi. ");
INSERT INTO kdlNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Maɗanga ma shinga ma tsu matsa ilimaci i cingi wa, nala kpam maɗanga ma cingi ma tsu matsa ilimaci i shinga wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ama a tsu kapa ta̱ maɗanga ma ma kpa̱ɗa̱i una̱ka̱ ilimaci i shinga a varangu ma a asuvu a akina. ");
INSERT INTO kdlNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nala kpam dem ya fuɗa ya reve ama a icun i manyan i le.” ");
INSERT INTO kdlNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Yesu doki u danai, “Gba̱ aza ɗa a ka isa̱sa̱ mu Asheku, Asheku ɗa a ka uwa a tsugono tsu zuba wa. Ama ɗa koshi a ka uwa a tsugono tsi alya aza ɗa a ka yansa ili iꞌya Tata u va̱ u zuba wa ciga. ");
INSERT INTO kdlNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kain ka afada, ama a ka isa̱ mu ta̱ Asheku a le, a dana, ‘Tsu yan ta̱ kuɓari a asuvu a kala ka vunu, kpam tsu wutukpusa̱ ta̱ ityoni i cingi n kala ka vunu, tsu yansai kpam ikunesavu ushani.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Aku n wushunku le, ‘N reve ɗa̱ wa ko kenu, banka numu dan, eɗa̱ aza a uyansa ukuna u cingi!’ ” ");
INSERT INTO kdlNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yesu danai, “Uza ɗa baci dem u panai kadyanshi ka va̱ wa yan manyan n ka, wa̱ ta̱ tyoku u kamai ka ka̱ri n ugboji, uza ɗa u taɗangi kuma ku ne a katali ka upeti. ");
INSERT INTO kdlNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","An a roi mini ma pige, aga̱ta̱ a shaɗangusi, uwule kpam u lapai kuwa ki, shegai ka ku rukpa̱ wa, kpaci u ma ta̱ ka a katali ka upeti. ");
INSERT INTO kdlNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Shegai uza ɗa baci dem u panai kadyanshi ka va̱, aku u ꞌyuwain ka uyanka manyan, wa̱ ta̱ tyoku katengeshi ka ka mai kuwa ku ne a kayala. ");
INSERT INTO kdlNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Aꞌayin a ɗa a roi, aga̱ta̱ a shaɗangusi, uwule kpam u lapai kuwa ki, aku ku wa̱sa̱i.” ");
INSERT INTO kdlNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Aꞌayin a ɗa Yesu kotsoi kadyanshi ki gba̱, aku kakuma̱ ka ama ki ka̱ri uyan majiyan ma uwenishike mi. ");
INSERT INTO kdlNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Wa̱ tyoku u awenishiki a Mele wa, shegai u wenishike ta̱ yavu uza ɗa wa̱ri n ucira. ");
INSERT INTO kdlNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Aꞌayin a ɗa Yesu cipa̱i a masasa mi, aku kakuma̱ ka ama ka tono yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kute‑kute vuma roku uza ɗa wa̱ri makutu u tuwa̱i u kuɗa̱ngi a kapala ka ne, u danai, “Asheku, vu wushuku baci, ta̱na̱sa̱ mu.” ");
INSERT INTO kdlNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu ba̱ra̱kpa̱i kukere ku ne u sawa yi, u danai, ‘N wushuku ta̱, ta̱na̱.” Kute‑kute tsukutu tsi tsu a̱sa̱ka̱ yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesu rono yi atsuvu, “Kotsu vu tonuko uza wa, shegai wala vu bana a asu u kaɗara̱kpi† u wene vu, aku vu na̱ka̱ kune ku Mele ma Musa ma danai ama ɗa baci a ta̱na̱i a na̱ka̱. Nala wa wenike ta̱ ama an n ta̱na̱sa̱ vu.” ");
INSERT INTO kdlNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Aku Yesu banai a Kafarnahum. An u uwai a ilyuci yi, katigi† ka asoje a Roma† ka roku ka cina yi u folo yi u ɓa̱nga̱ yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Katigi ki ka danai, “Asheku, ma̱ ta̱ n kagbashi ka ka pana ikyamba, wa̱ ta̱ ɗe a kuwa nvain bawu wa fuɗa wa wala. Maɓa̱la̱ mi ma ma foro yi wa wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu danai, “Ma bana ta̱ n ta̱na̱sa̱ yi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Katigi ki ka wushuki, “Asheku, mpa n rawa vu tuwa̱ a kuwa ku va̱ wa, shegai yan kadyanshi koshi tsa̱ra̱ kagbashi ki ka ta̱na̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Azapige a asoje a ɗa pini aza ɗa a tsu tonuko mu ili iꞌya ma yan, mpa kpam ma̱ ta̱ n asoje a ɗa n tsu tonuko ili iꞌya a ka yan. N tsu tonuko ta̱ uza u na, ‘Wala,’ aku u wala. N tonuko kpam uza u niɗe, ‘Tuwa̱,’ aku u tuwa̱. N tonuko kpam kagbashi, ‘Yan naha,’ aku tani u yain. N reve ta̱ udani u vunu wa̱ ta̱ dem n ucira.” ");
INSERT INTO kdlNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","An Yesu panai nala, aku u yain majiyan. U tonukoi aza ɗa a ka tono yi vi, “Mayun n tonuko ɗa̱, upityanangu u na vi u la ta̱ gba̱ upityanangu u ɗa n wenei a uyamba u Isaraꞌila. ");
INSERT INTO kdlNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ama ushani a ka wuta̱ ta̱ a kasana n kalivi a dusuku a lyai kaɓolo n Ibirahi, n Ishaku, n Yakubu a tsugono tsu zuba. ");
INSERT INTO kdlNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Shegai aza ɗa aꞌa̱ri a gain a yain pini a tsugono tsi, a ka vuta̱la̱ le ta̱ a asuvu a karimbi. Pini ɗa a ka sa̱ n ulumusa u aꞌanga.” ");
INSERT INTO kdlNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Aku Yesu tonukoi katigi ki, “Wala vu bana a kuwa, kagbashi ka vunu ka ta̱na̱ ta̱ tyoku ɗa vu pityanangi vi.” Pini a asuvu a ulapa u uwule u nala vi u ɗa kagbashi ki ka ta̱na̱i. ");
INSERT INTO kdlNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pini nala, Yesu banai a kuwa ku Bituru, aku u wenei mma u uka u Bituru vi nvain n usuɗugbi u ikyamba. ");
INSERT INTO kdlNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Aku u sawa yi kukere, pini nala, maɓa̱la̱ mi ma a̱sa̱ka̱ yi, u ꞌya̱nga̱i u gita̱ yi ufoɓusuko ilikulya. ");
INSERT INTO kdlNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","An kuvuli ku yain, ama a tukusoi Yesu aza a ityoni i cingi. N udani u ɗa koshi u tsu wutukpa̱ ityoni i cingi yi aku i a̱sa̱ka̱ le. U ta̱na̱sa̱i dem gba̱ aza a mɓa̱la̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","U yansa ta̱ ili i na yi tsa̱ra̱ a shaɗangu udani u Ishaya matsumate u ɗa u danai, “U takpai mɓa̱la̱ n tsunu, kpam u takpa tsu upana u ikyamba u tsunu.” ");
INSERT INTO kdlNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","An Yesu wenei kakuma̱ ka ama ka kyawan yi, aku u tonukoi atoni a ne a wala a pasamgbana kushiva̱ ki a gono a upashi u niɗe. ");
INSERT INTO kdlNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kawenishiki ka Mele ka tuwa̱i ara ne, u danai, “Kawenishiki, ma tono vu ta̱ a asu u ɗa dem va bana.” ");
INSERT INTO kdlNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu tonuko yi, “Iryanji iꞌa̱ ta̱ n aꞌele a le, nnu kpam aꞌa̱ ta̱ n ikinda i le. Shegai Mpa Maku ma Vuma ma̱ n kuwa ku kaci ku va̱ wa, kpam ma̱ gba̱m n a asu u uwunvugusa wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Aku uza roku a asuvu a atoni a Yesu, u tonuko yi, “Asheku, a̱sa̱ka̱ ve n ba n ciɗa̱ngu tata u va̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Shegai Yesu tonuko yi, “Tono mu, a̱sa̱ka̱ akushe a ciɗa̱ngu atoku a le akushe.” ");
INSERT INTO kdlNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu uwai a kpatsu kaɓolo n atoni a ne a ka pasa kushiva̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Aku uwule u pige u ꞌya̱nga̱i pini a kushiva̱ ki, aɓali kpam a ka gba̱ɗa̱sa̱ kpatsu ki hal ka ciga ushumbugu. Shegai Yesu pini nvain wa lavuta. ");
INSERT INTO kdlNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Aku atoni yi a banai ara ne a ꞌya̱nga̱sa̱ yi n a sala̱si, “Asheku, wauwa tsu! Tsa shumbugu ɗe!” ");
INSERT INTO kdlNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","U wushunku le, “Ndya i zuwai i panai uwonvo naha? Eɗa̱ aza ɗa upityanangu u ɗe u gusa̱i.” U ꞌya̱nga̱i u ɓaranai uwule n aɓali yi, aku asu vi paɗai kuwin. ");
INSERT INTO kdlNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Atoni yi a gita̱i majiyan n a wecemgbeni, “Ucun u vuma u eni u ɗa na vi, hal uwule n aɓali dem a ka pana̱ka yi?” ");
INSERT INTO kdlNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","An Yesu rawai a upashi u kushiva̱ a kaɓon ka uyamba u aza a Garasa, ama roku ama a re aza ɗa aꞌa̱ri n ityoni i cingi a tuwa̱i ara ne. Ama a na yi a asu u asaun a ɗa a tsu ronguso, kpam uza u tsu fuɗa u wala pini a ure vi wa adama a tsicingi tsu le. ");
INSERT INTO kdlNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Aku a gita̱ yi usala̱sa̱ka n a dansi, “Ndya i zuwai va damgbara̱sa tsu, avu Maku ma Kashila̱? Vu rawa vu zuwa tsu tsu pana ikyamba bawu aꞌayin a ɗa Kashila̱ ka danai a yain wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Evu n asu vi, ushiga u mburusunu u ɗa pini wa lina. ");
INSERT INTO kdlNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ityoni i cingi yi a foloi Yesu, a danai, “Vu wutukpa̱ tsu baci a asuvu a ama a na yi, vu a̱sa̱ka̱ tsu tsu uwa a asuvu a mburusunu n nala mi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Aku u tonuko le, “Walai!” Ityoni i cingi yi a a̱sa̱ka̱i ama yi a ba a uwai a asuvu a mburusunu mi. Pini nala, mburusunu mi gba̱ a sumai a uwai a kushiva̱ a kuwa̱i pini. ");
INSERT INTO kdlNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Aliniki yi a sumai a banai a ilyuci a tonukoi ama ili iꞌya i gita̱i, kaɓolo n ili iꞌya i gita̱i n ama a re aza a ityoni i cingi yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Aku ama a ilyuci yi gba̱ a wuta̱i a ba a cinai Yesu, an a wene yi, a folo yi u a̱sa̱nka̱ le uyamba u le. ");
INSERT INTO kdlNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu uwai a kpatsu, aku u gonoi a ilyuci i ne. ");
INSERT INTO kdlNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","An u rawai pini, ama roku a tuko yi kawunu nvain a kajiba. An u wenei upityanangu u ama ɗa a canga yi vi, aku u tonukoi kawunu ki, “Maku, gbama asuvu, a cimbusuka̱ vu ɗe unyushi u cingi u vunu.” ");
INSERT INTO kdlNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Aku awenishiki a Mele a roku a ka dansa utyoku u le, a danai, “Vuma na wa yan kadyanshi yavu aya Kashila̱!” ");
INSERT INTO kdlNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu tani u reve ta̱ ili iꞌya a ka yawunsa, aku u wece le, “Niɗa ya yan uyawunsa u tsicingi a asuvu a atakasuvu a ɗe? ");
INSERT INTO kdlNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ndya i lai shana ɗa a ka dana, ‘A cimbusuka̱ vu ɗe unyushi u cingi u vunu,’ ko ‘ꞌYa̱nga̱ vu wala’? ");
INSERT INTO kdlNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Shegai ma wenike ɗa̱ ta̱ an Mpa Maku ma Vuma† ma̱ri n ucira a likimba u ɗa ma cimbusa̱ unyushi u cingi.” U tonukoi kawunu ki, “ꞌYa̱nga̱ vu bidya kajiba ka vunu vu wala a kuwa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Aku vuma vi u ꞌya̱nga̱i u lazai a kuwa. ");
INSERT INTO kdlNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","An ama yi a wenei nala, aku a ka yan majiyan kpam a cikpai Kashila̱ an u na̱ka̱i uza roku ucun u ucira u na. ");
INSERT INTO kdlNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","An Yesu a̱sa̱ka̱i asu vi, aku u wenei vuma roku uza u kala Matiyu ndishi a kakinda ka uwusha u utafa. Aku u tonuko yi, “Tono mu.” U ꞌya̱nga̱i u tono yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Pini nala, Yesu n atoni a ne a tuwa̱i a ka lya ilikulya a kuwa ku Matiyu. Awushi a utafa† n aza a unyushi a tuwa̱i a ɓolomgbonoi pini a asu vi ushani. ");
INSERT INTO kdlNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","An Afarishi a wenei nala, aku a wecei atoni a ne, “Ndya i zuwai kawenishiki ka ɗe ka lya kaɓolo n icun i ama a na?” ");
INSERT INTO kdlNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","An Yesu pana̱ka le, aku u wushunku le, “Aza ɗa aꞌa̱ri n alafiya a ka ciga uza u aguma̱ wa, she aza a mɓa̱la̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Walai i ba i rotsongusu kalen ka Tagara̱da u Kashila̱ u ɗa u danai, ‘N u ɗa ya yanka mu uɗara̱kpa, n la ta̱ uciga i woko aza a asuvayali a asu u atoku a ɗe.’ N tuwa̱ adama a ɗa ma isa̱ aza a maci a tono mu wa, shegai aza a unyushi u cingi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kain ka te, atoni a Yahaya Kalyuɓugi a tuwa̱i ara Yesu a wece yi, “Niɗa a̱tsu n Afarishi tsa yansa kakuli, shegai atoni a vunu a ka yansa wa?” ");
INSERT INTO kdlNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","U wushunku le, “Aje a valisavu a ka namgba katsuma̱ aꞌayin a ɗa wa̱ri kaɓolo n ele wa. Shegai aꞌayin aꞌa̱ ta̱ utuwa̱ a ɗa a ka bidya valisavu vi a mere ma le, aꞌayin a nala a ɗa a ka yan kakuli. ");
INSERT INTO kdlNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Vuma wa paɗara kunya ku cau n kakashi ka savu wa. U yan baci nala, kakashi ka savu ki ka pa̱ɗa̱ ta̱ ka zuwa kunya ku cau ki ku doku ku kara. Hal gba̱m u lai ukara u cau vi. ");
INSERT INTO kdlNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Vuma wa tsungu mini ma cinwi† ma savu a kadele ka ukpan ka cau wa. Kpaci ma shita baci ma ta̱sa̱ ta̱ kadele ki, aku mini ma cinwi mi ma wotsongu. Shegai a tsungu mini ma cinwi ma savu a kadele ka savu. Pini nala, gba̱ kadele ki n mini ma cinwi mi a ka lobono ta̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","An Yesu wa̱ri a kadyanshi, aku uzapige u kagata ka Kashila̱ u tuwa̱i ara ne, u kuɗa̱ngi a kapala ka ne u danai, “Maku ma va̱ makere ma kuwa̱ ɗe gogo‑na. Vu tuwa̱ baci vu taɗanku yi kukere wa ꞌya̱nga̱ ta̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Aku Yesu n atoni a ne a ꞌya̱nga̱i a tono yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Uka ɗa wa la̱la̱ mpasa hal ayen kupa n a re u tuwa̱i a kucina̱ ku Yesu, aku u sawai kaletsu ka kunya ku ne. ");
INSERT INTO kdlNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kpaci u yawunsa ta̱ a katakasuvu ka ne, u danai, “Ko kunya ku ne ka baci n sawai koshi, ma ta̱na̱ ta̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","An Yesu kpatalai u wene yi, aku u danai, “Uka, gbama asuvu, upityanangu u vunu u ta̱na̱sa̱ vu ɗe.” Kute‑kute aku uka vi u ta̱na̱i. ");
INSERT INTO kdlNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","An Yesu rawai a kuwa ku uzapige ki, aku u wenei a ka fulusa̱ ugbali u ukpa̱ n ama ushani a ka sa̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Aku u tonuko le, “Ya dem wuta̱. Makere mi ma kuwa̱ wa, alavu a ɗa yi!” Shegai ama yi a ka dosuso yi idyoshi i magori. ");
INSERT INTO kdlNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","An a wutukpa̱i ama yi, aku Yesu banai a asu u ɗa makere mi ma̱ri nvain. U ka̱na̱i kukere ku ne, aku u makere mi ma ꞌya̱nga̱i. ");
INSERT INTO kdlNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Pini nala, alabari a ne a tamburai ko nte wa a asuvu a uyamba vi. ");
INSERT INTO kdlNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","An Yesu a̱sa̱ka̱i asu vi, eyi pini n u wali, aku arumba̱ ama a re a gita̱ yi utono n a sala̱si, “Maku ma Dawuda, pana asuvayali a tsunu!” ");
INSERT INTO kdlNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","An u uwai a kuwa, aku arumba̱ yi a tuwa̱i ara ne. U wece le, “I wushuku ma fuɗa ma zuwa ɗa̱ i fuɗa i wene?” A wushuki, “Eye, Asheku.” ");
INSERT INTO kdlNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Aku u sawai aꞌeshi a le, u danai, “Adama a upityanangu u ɗe, nala wa woko.” ");
INSERT INTO kdlNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kute‑kute aꞌeshi a le a kukpa̱i a wenei asu. Shegai u rono le atsuvu cika u danai, “I tonuko uza ukuna u na vi wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Shegai a tamburai uyamba vi gba̱ n a yanyi alabari a ne. ");
INSERT INTO kdlNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ama a re yi n a lazi, aku ama roku a doku a tukoi Yesu kabebe, uza ɗa ityoni i cingi i ka̱na̱i i ɓishinka yi kadyanshi. ");
INSERT INTO kdlNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","An u wutukpa̱i ityoni i cingi yi, aku vuma vi u yain kadyanshi. Aku kakuma̱ ka ama ki ka yan majiyan, a danai, “Kotsu tsu wene ukuna a Isaraꞌila naha wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Shegai Afarishi a danai, “Magono ma ityoni i cingi ma ma na̱ka̱ yi ucira u uwutukpa̱ le.” ");
INSERT INTO kdlNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu kyawunsa ta̱ gba̱ ilyuci n une n u wenishiki a agata a Kashila̱ n u yanyi kuɓari ku tsugono tsu Kashila̱. U ta̱na̱sa̱ ta̱ dem aza a mɓa̱la̱ icun kau‑kau n aza ɗa a ka pana ikyamba. ");
INSERT INTO kdlNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","An u wenei kakuma̱ ka ama ka̱ri udoku n ka doki, aku katakasuvu ka ne ka shaɗangi n asuvayali, kpaci a dambula ta̱ cika kpam uɓa̱nga̱ wa̱ la wa. Tyoku u ncon n ɗa bawu ma̱ri n kaliniki ɗa aꞌa̱ri. ");
INSERT INTO kdlNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Aku u tonukoi atoni a ne, “Manyan ma ukapa ma̱ ta̱ ushani, shegai ayain a manyan yi kenu ɗa aꞌa̱ri. ");
INSERT INTO kdlNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Adama a nala, foloi Magono ma Zuba uza u manyan ma ukapa mi u tuko aza a ukapa, a yanka yi manyan ma ukapa mi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu isa̱i atoni a ne kupa n ama a re, u na̱ka̱ le ucira u ɗa a ka wutukpa̱ ityoni i cingi a ta̱na̱sa̱ kpam aza a mɓa̱la̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Uza u kagita̱ aya Simo uza ɗa dem a tsu isa̱ Bituru, n Andurawu utoku u ne eyi dem kasuki† ka. Nala dem Yakubu maku ma Zabidi n utoku u ne Yahaya. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","N Filibu, n Batalamawu, n Toma, n Matiyu kawushi ka utafa, n Yakubu maku ma Halfa, n Tadawu ele dem asuki a ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Aza ɗa a buwai vi alya Simo Ziloti, n Yahuza Isikariyoti uza ɗa u tuwa̱i u neke yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","An Yesu suki Kupanamere† vi, u tonuko le ta̱ ili i na yi, “Kotsu i bana a asu u Awulawa ko tani i uwa a ilyuci i Samariya† wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","A asu u aza a Isaraꞌila koshi ɗa ya bana, kpaci tyoku u ushiga u nlala n ɗa n puwa̱in ɗa aꞌa̱ri. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Aꞌayin a nwalu yi, i tonusuko le tsugono tsu zuba tsu yan ɗe evu. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","I ta̱na̱sa̱ aza a mɓa̱la̱, i ꞌya̱nga̱sa̱ akushe, i ta̱na̱sa̱ aza ɗa aꞌa̱ri n tsukutu, kpam i wutukpa̱ ityoni i cingi. Gbani ɗa i wushai, nala kpam dem ya na̱ka̱ bawu a tsupa ɗa̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kotsu i bidya ikebe ko zinariya, ko azurufa ko tani urim u shili wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kotsu i bidya katsa̱n ko matogo ma ire, ko akpata, ko kalangu wa. Ama ɗa ya ɓa̱nga̱ vi a ka na̱ka̱ ɗa̱ ta̱ ili iꞌya ya ciga. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“A ilyuci iꞌya baci dem i uwai, i zami vuma u maci i rongo pini a kuwa ku ne hal ubana aꞌayin a ɗa ya laza. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Aꞌayin a ɗa baci ya uwa a kuwa, i dana, ‘Azakuwa, ndishi n shinga n rongo n a̱ɗa̱.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ama yi a wusha ɗa̱ baci, a̱sa̱ka̱i ndishi n shinga n ɗe n rongo pini. Shegai a wusha ɗa̱ baci wa, a̱sa̱ka̱ ndishi n shinga mi n gono ɗa̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kpam kuwa ko tani ilyuci iꞌya baci i uwai aku a ꞌyuwan ɗa̱ uryabusa ko a ꞌyuwan ɗa̱ upana̱ka, ka̱pa̱tsa̱i kabuta̱ ka aꞌene a ɗe i a̱sa̱ka̱ asu vi. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mayun n tonuko ɗa̱, kain ka afada, Kashila̱ ka pana ta̱ ama a Sodom† n Gomora† asuvayali cika hal a lai tyoku ɗa wa pana ama a ilyuci i nala yi!” ");
INSERT INTO kdlNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yesu lyai kapala n kadyanshi, “Mpa na ma suku ɗa̱ tyoku u ncon a mere ma nleweni. I woko aza a ugboji tyoku u kali, kpam i woko aza ɗa aꞌa̱ri yuwu tyoku u aꞌaɗya. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","She i kirana, kpaci a ka ka̱na̱ ɗa̱ ta̱ a banka ɗa̱ a asu u Asheshi a Pige, a bawan ɗa̱ a asuvu a agata a Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","A rono ɗa̱ ubana a kapala ka igomuna na̱ ngono, kpaci eɗa̱ atoni a va̱ a ɗa. Nala wa woko ta̱ ure u ɗa ya yanka le kadyanshi ka va̱ kpam hal likimba u reve n ka. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Shegai aꞌayin a ɗa baci a ka̱na̱ ɗa̱ vi, kotsu i dambula a ili iꞌya ya dana ko tani tyoku ɗa ya dana iꞌya wa. Aꞌayin a nala yi Kashila̱ ka na̱ka̱ ɗa̱ ta̱ ili iꞌya ya dana. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Shegai kadyanshi ka ya dansa vi ka ɗe ka wa, Kulu ku Tata u ɗe ka ka dansa a asuvu a ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ama a ka neke ta̱ atoku a le a wuna le. Nala dem isheku ya yanka mmuku n le. Mmuku kpam n ꞌya̱nga̱sa̱ka̱ isheku i le hal a zuwa a wuna le. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ama gba̱ a ka ꞌyuwan ɗa̱ ta̱ adama a kala ka va̱. Shegai gba̱ ama ɗa baci dem a pityanangi hal ubana a makorishi, a ka wauwa le ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ilyuci iꞌya baci dem ama a ꞌyuwan ɗa̱, i dara̱ka i bana a ilyuci i roku. Mayun n tonuko ɗa̱, kahu i kyawan ilyuci ilyuci i Isaraꞌila gba̱, Maku ma Vuma ma tuwa̱ ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Karotsongishi ka tsu la kawenishiki ka ne wa, ko tani kagbashi ka lai uzakuwa u ne wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","U rawa ta̱ ɗa karotsongishi ka woko tyoku u kawenishiki ka ne, kagbashi kpam ka woko tyoku u uzakuwa u ne. A isa̱ baci Mpa uza ɗa ma̱ri uzakuwa, ‘Magono ma ityoni i cingi;’ wata, Baꞌalzabu,† eɗa̱ aza a kuwa a va̱ tani ndya a ka isa̱ ɗa̱?” ");
INSERT INTO kdlNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yesu danai, “Panai uwonvo u ama a nala yi wa, kpaci ili iꞌya baci dem iꞌa̱ri usokongi gogo‑na ama a ka tuwa̱ ta̱ a ka reve iꞌya. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","N tonuko ɗa̱ ta̱ ukuna u na vi a karimbi, shegai ma ciga ta̱ i tonuko le iꞌya a katyashi. Ili iꞌya baci ya pana ma dansa n tsubini a atsuvu a ɗe, i dana iꞌya cika a zuba u kukpa̱ ama a pana. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Kotsu i pana uwonvo u aza ɗa a ka wuna ɗa̱ wa. Ikyamba i ɗe iꞌya koshi a ka wuna, shegai a ka sawa uma u ɗe wa. Kashila̱ ka koshi ya pana uwonvo, kpaci aya uza ɗa wa fuɗa wa nangasa gba̱ uma n ikyamba a akina. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Mberikele n re n ɗa a tsu denge kanini ka te, shegai gba̱ n nala, ma te ma̱ la ma kuwa̱ bawu Tata u ɗe u revei n ma wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kashila̱ ka reve ta̱ gba̱ ko kenji ka yain ka ka̱ri a kaci ka vunu. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Adama a nala kotsu i pana uwonvo wa, kpaci tsupige tsu ɗe tsu la ta̱ tsu mberikele ushani. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Uza ɗa baci dem u tonukoi aza roku eyi uza u va̱ u ɗa a kapala ka ama, mpa dem ma tonuko ta̱ Tata u va̱ u zuba uza nala vi katoni† ka va̱ ka. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Shegai vu ꞌyuwan mu baci, mpa kpam ma tonuko ta̱ Tata u va̱ u zuba avu uza u va̱ ɗa wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Yesu lyai kapala n kadyanshi, “Kotsu i bidya a asuvu a atakasuvu a ɗe i dana ndishi n shinga n ɗa n tukoi a likimba wa. N tuwa̱ tsa̱ra̱ n tuko ndishi n shinga wa, shegai kushulu. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","N tuwa̱ ta̱ n ‘zuwa uza u yain tsilala n asheku a ne, makere ma yain tsilala na̱ mma u ne, kajene kpam ka yain tsilala n anuku a le. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Atokulalu a ka yan ta̱ pini a asuvu a kumaci ku ɗe!’ ");
INSERT INTO kdlNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Gba̱ aza ɗa baci a lai uciga asheku n anuku a le kapala na̱ mpa, a ra̱tsa a woko atoni a va̱ wa. Gba̱ aza ɗa baci a ka ciga mmuku n le kapala na̱ mpa, a ra̱tsa a woko atoni a va̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Vu canga baci mawandamgbani† ma vunu vu tono mu wa, vu ra̱tsa vu woko katoni ka va̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Gba̱ uza ɗa baci wa kirana n uma u ne, wa namba ta̱ u ɗa. Uza ɗa tani u nambai uma u ne adama a va̱, wa wauwa ta̱ u ɗa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Yesu danai, “Uza ɗa baci dem u wusha ɗa̱, mpa u wushai. Uza ɗa baci kpam u wusha mu, u wusha ta̱ uza ɗa u suku mu. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Uza ɗa u wushai matsumate adama a ɗa matsumate mi ma yanka yi kadyanshi ka Kashila̱, Kashila̱ ka na̱ka̱ yi ta̱ katsupi ka malen ma manyan ma ne dere n matsumate mi. Uza ɗa baci kpam u wushai vuma u maci adama a ɗa vuma u nala vi wa̱ri uza u maci, a ka na̱ka̱ yi ta̱ katsupi ka malen ma manyan ma ne dere n vuma u maci nala vi. ");
INSERT INTO kdlNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Uza ɗa baci u nei katoni ka kenu ka va̱ mako ma mini adama a ɗa wa̱ri katoni ka va̱, mayun n tonuko ɗa̱, vuma u nala vi wa tsa̱ra̱ ta̱ katsupi ka malen ma manyan ma ne.” ");
INSERT INTO kdlNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","An Yesu kotsoi utonuko Kupanamere yi ukuna u na vi, aku u a̱sa̱ka̱i a asu vi u banai a ilyuci a asuvu a Galili tsa̱ra̱ u wenishike u yain kpam kuɓari. ");
INSERT INTO kdlNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yahaya Kalyuɓugi wa̱ ta̱ a asuvu a kuwa ku aꞌali. An u panai ili iꞌya Kirisiti wa yansa, aku u suki atoni a ne a roku ama a re. ");
INSERT INTO kdlNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","A ba a wece yi, “Aɗa uza ɗa wa tuwa̱ vi, ko tsu vana uza roku?” ");
INSERT INTO kdlNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","U wushunku le, “Walai i tonuko Yahaya ili iꞌya i wenei n ili iꞌya i panai. ");
INSERT INTO kdlNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Arumba̱ a wene ta̱, awunu kpam a wala ta̱, nkutu n ta̱na̱ ta̱, agulani a pana ta̱, akushe kpam a ꞌya̱nga̱i a gonoi n uma. A yanka ta̱ aza a unambi kuɓari ku Kadyanshi ka Shinga. ");
INSERT INTO kdlNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kashila̱ ka zuwuka ta̱ uza ɗa bawu u ꞌyuwan mu adama a ili iꞌya n yain una̱ u shinga.” ");
INSERT INTO kdlNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","An atoni a Yahaya a lazai, aku Yesu gita̱i uyanka ama yi kadyanshi ka Yahaya, u danai, “An i banai a kakamba ki, ucun u vuma u eni u ɗa i banai uwene? Wa̱ tyoku u asomini a ɗa uwule u tsu purusa̱ a asu u ɗa baci dem u lapanai? ");
INSERT INTO kdlNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ucun u vuma u eni u ɗa i banai uwene? Vuma ɗa u ukai aminya a ikali? Aza ɗa a tsu uka aminya a ikali a aꞌeɓile a ngono a ɗa aꞌa̱ri. ");
INSERT INTO kdlNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ya i banai uwene? Matsumate ma? Eye. N tonuko ɗa̱ u la ta̱ matsumate. ");
INSERT INTO kdlNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tagara̱da u Kashila̱ u yan ta̱ kadyanshi a kaci ka ne, “ ‘Ma suku ta̱ katsumate ka va̱ a kapala ka vunu, uza ɗa wa lapuluka vu ure.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Mayun n tonuko ɗa̱, Yahaya Kalyuɓugi u la ta̱ gba̱ uza ɗa baci wa̱ri n uma. Shegai uza u kenukulu gba̱ a asuvu a tsugono tsu zuba u la yi ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ili iꞌya i bidyai aꞌayin a ɗa Yahaya Kalyuɓugi tuwa̱i hal utuwa̱ gogo‑na, tsugono tsu zuba tsa̱ ta̱ udoku ucira, kpam ya dem wa moɗono ta̱ tsa̱ra̱ u uwa tsa. ");
INSERT INTO kdlNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Gba̱ ntsumate n Mele ma Musa a dana ta̱ ukuna u tsugono tsu Kashila̱ hal utuwa̱ aꞌayin a Yahaya. ");
INSERT INTO kdlNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","I wushuku baci n ele, Yahaya vi aya Iliya† matsumate ma ya vana vi. ");
INSERT INTO kdlNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Iꞌa̱ baci n atsuvu, panai! ");
INSERT INTO kdlNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Niɗa ma dansa ukuna u ama a gogo‑na? Ndya a rotsoi? Aꞌa̱ ta̱ tyoku u mmuku n ɗa ma̱ri ndishi a kuden, n a ika̱mgba̱ni, ");
INSERT INTO kdlNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“ ‘Tsu fula̱ka̱ ɗa̱ ta̱ ugbali, shegai i ꞌyuwain kuje! Tsu shipuka ɗa̱ ushipa u ukpa̱, shegai i sa̱ wa!’ ");
INSERT INTO kdlNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“An Yahaya tuwa̱i, u laɓa ulya ilikulya wa, u so tani mini ma cinwi wa, aku i danai, ‘Wa̱ ta̱ n ityoni i cingi!’ ");
INSERT INTO kdlNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Shegai an Mpa Maku ma Vuma ma lya na̱ n soyi, aku i danai, ‘Kalyai ka n kasoi, kpam kaje ka aza a uwusha u utafa n aza a unyushi u cingi ka.’ Ugboji u tsu wenike ta̱ kaci ka ne a asu u manyan ma maci ma u tsu yansa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","A ilyuci iꞌya Yesu yansai ikunesavu i ne cika, ama yi a ꞌyuwan ta̱ ukpatala a gono a asu u Kashila̱. U gita̱ le uɓongo, ");
INSERT INTO kdlNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ter ɗe, aza a Korasinu! Ter ɗe, aza a Besaida! A da baci ikunesavu iꞌya n yain a asuvu a ɗe iꞌya n yain a Taya n Sida, an aꞌa̱ri a kpatala ɗe caupa. A uka ta̱ akashi a rongoi a upoluso kakomo, tsa̱ra̱ a wenike an a kpatalai a a̱sa̱ka̱i unyushi u cingi u le! ");
INSERT INTO kdlNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","N tonuko ɗa̱, kain ka afada, Kashila̱ ka laka ta̱ uyanka ama a Taya n Sida ajebigi kapala n a̱ɗa̱! ");
INSERT INTO kdlNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Eɗa̱ kpam aza a Kafarnahum, ꞌya̱nga̱sa̱ ɗa wa̱ a ka ꞌya̱nga̱sa̱ ɗa̱ a zuba? A ka vuta̱la̱ ɗa̱ ta̱ a asuvu a akina! A da baci ikunesavu iꞌya a yain ara ɗe iꞌya a yain a Sodom, an wa̱ri wa buwa ta̱ pini hal n gogo‑na. ");
INSERT INTO kdlNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","N tonuko ɗa̱, kain ka afada, Kashila̱ ka pana ta̱ iyali i Sodom kapala n a̱ɗa̱!” ");
INSERT INTO kdlNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Aꞌayin a nala yi, Yesu danai, “Tata, Magono ma zuba n likimba, n cikpa vu ta̱, kpaci vu sokongu ta̱ ukuna u na vi a asu u aza a ugboji n arevi, shegai vu wenikei u ɗa a asu u aza ɗa bawu a revei ili. ");
INSERT INTO kdlNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tata, nala vu wenei u gain vu yain! ");
INSERT INTO kdlNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Tata u va̱ u na̱ka̱ mu ta̱ ili yi gba̱. Uza wa̱ la u revei Maku mi wa, she Tata vi. Kpam uza wa̱ la u revei Tata vi wa, she Maku mi n uza ɗa Maku mi ma ɗanga̱sai u tonuko. ");
INSERT INTO kdlNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Tuwa̱i ara va̱, gba̱ ɗe aza ɗa a wowoi n ucanga wa ara̱ji, ma na̱ka̱ ɗa̱ ta̱ uwunvuga. ");
INSERT INTO kdlNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Pana̱ka numu, tsa̱ra̱ i woko ama a va̱. Tuwa̱i i rotsongusu ara va̱, kpaci mpa ma̱ ta̱ n uvakunku kaci kpam ya tsa̱ra̱ ta̱ uwunvuga. ");
INSERT INTO kdlNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Uwenishike u ɗa n danai i wushuku n u ɗa vi, wa̱ ta̱ shana, kpam ucanga u va̱ u ra̱zugba̱ wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kain ka te n kain ka Ashibi,† Yesu n atoni a ne a ka wala a mere ma ashina a ilya. Atoni a ne a ka pana kambulu, aku a gita̱i ukoɗuso aratu a ilya n a yuruwi n a takumi. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","An Afarishi a wenei nala, aku a tonukoi Yesu, “U gan atoni a vunu a yain nala wa! Mele ma kain ka Ashibi ma ɓishinka ta̱ uyan manyan n kain ka Ashibi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu wushuki, “Ma wundya i yan ka̱neshi u ili iꞌya Dawuda n aje a nwalu a ne a yain an a ka pana kambulu vi? ");
INSERT INTO kdlNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","U uwai a Kuwa ku Kashila̱ u takumai iburodi i uwulukpi, ko an u wokoi Mele ma ɓishinka ta̱ a takuma iꞌya. Aɗara̱kpi a ɗa koshi a wushunki a takuma u ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ma wundya i yan ka̱neshi u Mele ma Musa ma ma danai aɗara̱kpi a ɗa koshi a ka yan manyan a Kuwa ku Kashila̱ n kain ka Ashibi ki? Shegai ko uza wa̱ la u danai a nusuka mele ma Ashibi wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","N tonuko ɗa̱, uza ɗa u lai Kuwa ku Kashila̱ aya pini naha. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","A da baci i revei kalen ka Tagara̱da u Kashila̱ u na vi, ‘N la ta̱ uciga i woko aza a asuvayali a asu u atoku a ɗe, n u ɗa ya yanka mu uɗara̱kpa,’† iꞌa̱ri ya kiɗa̱ga ama a na yi aza ɗa bawu aꞌa̱ri n unyushi ugana wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Adama a nala, mpa Maku ma Vuma Asheku a ɗa, hal n a kain ka Ashibi dem.” ");
INSERT INTO kdlNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","An Yesu a̱sa̱ka̱i a asu vi, aku u ba u uwai a kagata ka Kashila̱ ka ka̱ri evu. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","U cina ta̱ pini vuma ɗa ili i soi kukere. Afarishi a zuwuka yi aꞌeshi tsa̱ra̱ a tsa̱ra̱ ili iꞌya a ka sapula yi n iꞌya, aku a wece yi, “Wa̱ dere a ta̱na̱sa̱ vuma n kain ka Ashibi?” ");
INSERT INTO kdlNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","U wushunku le, “Iꞌa̱ baci n macon† aku ma rukpa̱i a ilyukoi n kain ka Ashibi, ya wutukpa̱ ma wa? Mayun tani ya wutukpa̱ ta̱ ma. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ama a la ta̱ ncon kalen, adama a nala, dere ɗa a yain ili i shinga n kain ka Ashibi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yesu tonukoi vuma vi, “Ba̱ra̱kpa̱ kukere ku vunu.” An u ba̱ra̱kpa̱i kukere ki, aku ku gonoi mai tyoku ku ire ki. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pini nala, Afarishi yi a wuta̱i a ka sheshe tyoku ɗa a ka wuna Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu reve ta̱ ili iꞌya Afarishi a ka yawunsa, aku u a̱sa̱ka̱i asu vi. Ama ushani a tono yi, kpam u ta̱na̱sa̱ ta̱ gba̱ aza a mɓa̱la̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Shegai u ronoi ama yi atsuvu kotsu a tonuko uza ko eyi yayi wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","U yan ta̱ ili i na yi tsa̱ra̱ a shaɗangu ili iꞌya Kashila̱ ka danai a una̱ u Ishaya matsumate: ");
INSERT INTO kdlNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Kagbashi ka va̱ ka na, uza ɗa n ɗanga̱sai. Ma ciga yi ta̱, kpam u zuwa mu ta̱ n panai kayanyan cika. Ma na̱ka̱ yi ta̱ Kulu ku va̱, kpam wa tonuko ta̱ gba̱ iyamba an ukuna u va̱ wa̱ri dere. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Wa nanamgbana ko tani u sala̱sa wa, ko kpam u yain kuɓari n isali a ire wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Wa koɗuso asomini a ɗa a ka̱ta̱la̱sa̱i wa, wa cimbusa̱ tani macikalu ma ma ciga ucimba̱ wa. Nala wa rongo uyansa hal she ukuna u ɗa wa̱ri dere u lya kaci ka ukuna u cingi. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Iyamba gba̱ a ka zuwa ta̱ uma u le ara ne.” ");
INSERT INTO kdlNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Aku ama roku a tukoi Yesu karumba̱ kpam kabebe ka, adama a ityoni i cingi. Aku Yesu ta̱na̱sa̱i vuma vi, kute‑kute u gita̱i kadyanshi kpam u wenei asu. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Gba̱ ama yi a yain majiyan, a danai, “Gaawan vuma u na vi Maku ma Dawuda ma, Kirisiti Kawauwi!” ");
INSERT INTO kdlNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","An Afarishi a panai nala, a wushunku le, “U wutukpa̱ ta̱ ityoni i cingi kpaci magono ma le Baꞌalzabu u na̱ka̱ yi ta̱ ucira u ɗa wa yan nala.” ");
INSERT INTO kdlNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu reve ta̱ ili iꞌya a ka yawunsa, aku u tonuko le, “Uyamba u ɗa baci u pecei kaci ka ne n u shila̱ka̱ni, u ɗa wa ɓa̱ra̱kpa̱ wa. Kpam ilyuci ko kuwa ka baci ku pecei n ku shila̱ka̱ni, ka rukpa̱ ta̱! ");
INSERT INTO kdlNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kanangasi ka wutukpa̱ baci Kanangasi, nala u wenike ta̱ tsugono tsu ne tsu pece ta̱ aɓon aɓon, kpam tsa ɓa̱ra̱kpa̱ wa aku tsu rukpa̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","I da n wutukpa̱ ta̱ ityoni i cingi adama a ɗa Baꞌalzabu na̱ka̱ mu ucira u ɗa ma yan nala. Nala baci, ya na̱ka̱i atoni a ɗe ucira u ɗa a ka wutukpa̱ le dem? Ili iꞌya atoni a ɗe a tsu yan i wenike ta̱ an kadyanshi ka i tsu yansa a kaci ka va̱ ka̱ dere wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Shegai mpa ma wutukpusa̱ baci ityoni i cingi n Kulu Keri ku Kashila̱, tsugono tsu Kashila̱ tsa tsu tuwa̱ ɗe la vi a asuvu a ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Uza wa ciga baci u uwa a kuwa ku uza u ucira u yain uboki, she u ma̱tsa̱ u sira ve uza u ucira vi, aku u fuɗa u yain uboki a kuwa ki. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Uza ɗa baci bawu wa̱ri a asu u va̱, tsilala tsa wa yan na̱ mpa, uza ɗa kpam bawu wa ɓa̱nga̱ mu ucira̱ngusu, wacinsa ɗa wa wacinsa. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","N tonuko ɗa̱, Kashila̱ ka cimbusuka̱ ta̱ uza ɗa u nusukai aza roku, hal n uza ɗa wa yan kadyanshi ka cingi† a ukuna u Kashila̱. Shegai Kashila̱ ka cimbusuka̱ uza ɗa wa yanka Kulu Keri kadyanshi ka cingi wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kashila̱ ka cimbusuka̱ ta̱ uza ɗa baci dem u nusukai Mpa Maku ma Vuma n kadyanshi. Shegai Kashila̱ ka cimbusuka̱ uza ɗa wa yanka Kulu Keri kadyanshi ka cingi wa, ili iꞌya i bidyai gogo‑na hal ubana aꞌayin a ɗa a ka tuwa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yesu lyai kapala n kadyanshi, “I tsu reve ta̱ maɗanga a ilimaci i ne. Maɗanga ma shinga ma tsu matsa ta̱ ilimaci i shinga, maɗanga ma cingi kpam ma tsu matsa ta̱ ilimaci i cingi. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Eɗa̱ aꞌeku! Eɗa̱ ama a cingi a ɗa, niɗa ya dana ili i shinga? Una̱ u tsu dana ta̱ ili iꞌya iꞌa̱ri a katakasuvu. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ama a maci aꞌa̱ ta̱ n ili i shinga a atakasuvu a le, kpam iꞌya a tsu dana. Ama a cingi kpam aꞌa̱ ta̱ n ili i cingi a atakasuvu a le, ele dem iꞌya a tsu dana. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","N tonuko ɗa̱, kain ka afada ya wenike ta̱ gba̱ kadyanshi ka gbani ka i dansai caupa vi. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","I shinga iꞌya baci i dansai, Kashila̱ ka dana ta̱ eɗa̱ aza a unyushi a ɗa wa. Shegai i cingi iꞌya baci i dansai, wa dana ta̱ eɗa̱ aza a unyushi a ɗa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Pini nala, awenishiki a Mele n Afarishi a tuwa̱i ara Yesu, a danai, “Kawenishiki, tsa ciga ta̱ tsu wene iryoci tsa̱ra̱ tsu reve an a asu u Kashila̱ ɗa vu wuta̱i.” ");
INSERT INTO kdlNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","U wushunku le, “I ciga ta̱ iryoci kpaci eɗa̱ aza a cingi a ɗa, kpam ya wushuku wa. Shegai iryoci i Inusa† matsumate iꞌya ya tsa̱ra̱ koshi. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Inusa rongo ta̱ a asuvu a katsuma̱ ka kadan ka pige hal gba̱ aꞌayin a tatsu. Nala kpam wa woko, Mpa Maku ma Vuma ma rongo ta̱ a kasaun hal gba̱ aꞌayin a tatsu. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Kain ka afada ama a Niniba† a ka ꞌya̱nga̱ ta̱ a wenike ama unyushi u ɗe. A kpatala ta̱ a asu u Kashila̱ an Inusa yanka le kuɓari. Gogo‑na uza ɗa u lai Inusa aya pini na. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Magono ma Sheba uka, wa ꞌya̱nga̱ ta̱ u wenike ama unyushi u ɗe. U yan ta̱ nwalu ma mɓa̱ri tsa̱ra̱ u tuwa̱ u pana ukuna u ugboji u Solomo n kaci ka ne. Gogo‑na uza ɗa u lai Solomo aya pini na.” ");
INSERT INTO kdlNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yesu lyai kapala n kadyanshi, “Aꞌayin a ɗa baci ityoni i cingi i te i wuta̱i a asuvu a vuma, i tsu bana ta̱ a asu u ekpi ubolo asu u ɗa wa wunvuga, shegai wa tsa̱ra̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Aku u dana, ‘Ma gono ta̱ a kuwa ka n a̱sa̱ka̱i vi!’ An u gonoi, aku u cinai uza wa̱ pini a kuwa ki wa. A wujuma̱ ka ɗe sarara a kalai ka. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Aku ityoni yi i lazai i ba i tukoi ityoni i cingi i shindere i roku aza ɗa a la yi tsicingi, aku a rongo pini. Vuma u nala vi wa kotso ta̱ ndishi n ne n upana u ikyamba u ɗa u lai u caupa vi. Ili iꞌya ya gita̱ n ama a cingi a gogo‑na ɗa la vi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu pini a kadyanshi n ama, aku mma u ne n aꞌangu a ne a rawai. A shamgbai a uwotsu a da a tonuko yi a ka ciga a wene yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Aku uza roku u tonuko yi, “Mma u vunu n aꞌangu a vunu alya pini a uwotsu a ka ciga a wene vu.” ");
INSERT INTO kdlNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","U wushunku yi, “Ya mma u va̱? An ya aꞌangu a va̱?” ");
INSERT INTO kdlNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Aku u sapunki atoni a ne kukere, u danai, “Mma n aꞌangu a va̱ a ɗa na. ");
INSERT INTO kdlNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Uza ɗa baci wa pana̱ka Tata u va̱ u zuba, aya mma u va̱, n vangu u va̱, n utaku u va̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kain ka nala ki, Yesu wuta̱i a kuwa ki u banai a ikengi i kushiva̱ u dusuki wa wenishike. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kakuma̱ ka ama ka kyawan yi cika hal ka zuwa yi u uwai a kpatsu u dusuki, ama yi kpam a shamgbai a kagiɗa. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","U wenishike le ili ushani n agisani, u danai, “A yan ta̱ vuma roku uza ɗa u banai uwacangusu icun a kashina ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Aꞌayin a ɗa wa̱ri a uwacangusu icun yi, aku i roku i rukpa̱i a ure, nnu n ka̱ɗa̱sa̱i iꞌya. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","I roku kpam i rukpa̱i a iyamba i atali a asu u ɗa bawu kayala ka̱ri pini ushani. Icun yi i lazai i binyai, kpaci kayala ka maci ka̱ pini wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","An kaara ka yain, aku ka runukpai iꞌya, kpaci alu a le a gbonguro cika wa, aku i lazai i ekpei. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Icun i roku i rukpa̱i a asu u awana, an i gbonguroi, aku awana yi a sapusai iꞌya. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Icun i roku kpam i rukpa̱i a iyamba i shinga, i wuta̱i i matsai mmuku. Gba̱ icun iꞌya kacimbi ki ka wacangusi vi, i roku i na̱ka̱ ta̱ mmuku amangatawun‑amangatawun, i roku tani amangatatsu‑amangatatsu, i roku kpam kamankupa‑kamankupa. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Uza ɗa baci wa̱ri n atsuvu a upana, u pana.” ");
INSERT INTO kdlNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Aku atoni a ne a wece yi, “Ndya i zuwai vu tsu dansa n ama n agisani?” ");
INSERT INTO kdlNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","U wushunku le, “A ɗanga̱sa ɗa̱ ta̱ i reve ili i tsugono tsu zuba iꞌya iꞌa̱ri usokongi, shegai aza roku a ka reve ili iꞌya iꞌa̱ri usokongi vi wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kashila̱ ka doku ta̱ ka na̱ka̱ uza ɗa wa̱ri n ili cika, shegai ama ɗa a bawu aꞌa̱ri n ili, a ka namba ta̱ hal gba̱m i kenu iꞌya aꞌa̱ri n iꞌya vi. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ili iꞌya i zuwai n tsu dansa n ele n agisani iꞌya: “A ka weɓele ta̱, shegai a ka wene wa, a ka pana ta̱, shegai a ka reve wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kazuwamgbani ka Kashila̱ ka woko ɗe mayun, tyoku ɗa Ishaya matsumate u danai: “ ‘Ya pana̱sa ta̱ kadyanshi ka va̱, shegai ya reve wa. Ya wenishe ta̱ ili iꞌya ma yansa, shegai ya reve kalen ka ne wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kpaci atakasuvu a le a gbama ɗe, atsuvu a le kpam a ka pana wa. A kimba̱ ɗe aꞌeshi a le tsa̱ra̱ a wene wa, kpam tsa̱ra̱ atsuvu a le a pana wa. Kpam atakasuvu a le a ka reve wa, bele a kpatala ara va̱ n ta̱na̱sa̱ le.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Shegai Kashila̱ ka zuwuka ɗa̱ ɗe una̱ u shinga, kpaci aꞌeshi a ɗe a ka wene ta̱, atsuvu a ɗe kpam a ka pana ta̱! ");
INSERT INTO kdlNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mayun n tonuko ɗa̱, ntsumate ushani n ama a maci a ciga ta̱ a vana a wene ili iꞌya i wenei, a pana kpam ili iꞌya i panai, shegai a wene wa, a pana tani wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Panai mai kalen ka agisani ka icun iꞌya a wacangusi vi. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Icun iꞌya i rukpa̱i a ure vi, alya ama ɗa a panai ukuna u tsugono tsu zuba, shegai a reve u ɗa wa. Aku uza u cingi vi u tuwa̱i u fula̱i u ɗa a atakasuvu a le. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Icun iꞌya i rukpa̱i a iyamba i atali tani, alya ama ɗa a panai ukuna vi n maza̱nga̱, kpam a wushai u ɗa mai. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Shegai alu a le a uwa a iyamba cika wa. A ɓa̱ra̱kpa̱ n uwusha ukuna vi wa, an aꞌayin a ukondo a rawai adama a ukuna u tsugono vi, aku a rukpa̱i. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Icun iꞌya i rukpa̱i a asuvu a awana, alya ama ɗa a panai ukuna vi, shegai adama a kadambula ka ili iꞌya uma u nambai, n uciga u utsa̱ri u la̱pa̱na̱ le. Pini nala, kadambula ki ka gbagbala le hal a kpa̱ɗa̱i una̱ka̱ ilimaci. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Icun iꞌya kpam i rukpa̱i a iyamba i shinga, alya ama ɗa a panai ukuna u tsugono vi a revei u ɗa mai. A gbonguro ta̱ hal a matsai mmuku ushani, aza roku amangatawun‑amangatawun, aza roku amangatatsu‑amangatatsu, aza roku kpam kamankupa‑kamankupa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu doki u yanka le agisani a roku, “Tsugono tsu zuba tsa woko ta̱ tyoku u agisani a naha: Vuma roku u ɗa u cei ilya a kashina ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kain ka te n kayin cina ya dem lavuta ɗe, aku utokulalu u ne u tuwa̱i u wacangusi akan pini a asu u ilya vi, aku u lazai. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","An ilya yi i wuta̱i i gita̱i ugbonguro ya matsa, aku akan yi dem a gbonguroi. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Pini nala, agbashi a vuma yi a tuwa̱i ara ne, a danai, ‘Vu ce ta̱ ilya i shinga a kashina ka vunu, shegai nte akan a naha a wuta̱i?’ ");
INSERT INTO kdlNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Vuma vi u wushuki, ‘Utokulalu u va̱ ɗa u cei a ɗa.’ “Aku a wece yi, ‘Va ciga tsu kapusa a ɗa?’ ");
INSERT INTO kdlNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“U danai, ‘A̱sa̱ka̱i a ɗa pini, kpaci i da baci ya kapusa a ɗa, ya kapusa ta̱ dem ilya yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","A̱sa̱ka̱i a ɗa n ilya yi a gbonguro kaɓolo hal ubana aꞌayin a ukapa, aku n tonuko ayain a manyan yi: Gita̱i ve i ɓolomgbono akan yi i sira a ɗa a asu u te, tsa̱ra̱ a tuwa̱ a daɓa a ɗa. Ilya yi kpam i ɓolomgbono iꞌya i tuko iꞌya a mapon ma va̱.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu doki u tonuko le agisani a roku, “Tsugono tsu zuba tsa woko ta̱ tyoku u agisani a naha: Vuma roku ɗa u bidyai ucun u musta u cei a kashina ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ucun u kenu u ɗa gba̱ gba̱ a asuvu a icun, shegai an u gbonguroi, aku u wokoi u pige a asuvu a nwurete gba̱. U wokoi mawurete ma hal nnu n cai pini ikinda a nsaɓu n ne.” ");
INSERT INTO kdlNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu doki kpam u yanka le agisani a roku, “Tsugono tsu zuba tsa woko ta̱ tyoku u agisani a naha: Uka roku ɗa bidyai yisti,† aku u vura̱i u ɗa a akundatsu a pige a tatsu a kira a mabara u vura̱i mai hal ku shitai cika.” ");
INSERT INTO kdlNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu tsu dansa ta̱ n kakuma̱ ka ama n agisani, u tsu tonuko le ili bawu u ɓolomgbonuko le n agisani wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Yan ɗa u tsu yan nala tsa̱ra̱ u shaɗangu udani u ɗa Ishaya matsumate u danai: “Ma dansa ta̱ n a̱ɗa̱ n agisani, n tonuko ɗa̱ ili iꞌya iꞌa̱ri usokongi tun aꞌayin a ɗa Kashila̱ ka yain likimba.” ");
INSERT INTO kdlNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","An Yesu a̱sa̱ka̱i kakuma̱ ka ama ki, u uwai a kuwa. Atoni a ne a tuwa̱i ara ne, a danai, “Tonuko tsu kalen ka agisani a akan a kashina yi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","U wushunku le, “Uza ɗa u cei icun i shinga yi Maku ma Vuma ma. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kashina ki likimba ɗa, icun i shinga yi kpam alya ama ɗa aꞌa̱ri a tsugono. Icun i akan yi kpam alya aza ɗa aꞌa̱ri a asu u uza u cingi vi. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Utokulalu uza ɗa u wacangusi icun i akan yi aya Kala̱pa̱nsi. Aꞌayin a ukapa yi a ɗa aꞌayin a makorishi ma likimba. Ayain a manyan aza ɗa a ka ɓolomgbono ilya yi, alya atsumate a zuba. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Akan a ɗa a ka ɓolomgbono a daɓa. Nala wa woko a aꞌayin a makorishi. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mpa Maku ma Vuma ma suku ta̱ atsumate a va̱, kpam a ka wutukpa̱ ta̱ gba̱ ili iꞌya ya tuko unyushi u cingi hal n aza ɗa a ka yan tsicingi dem a tsugono tsu va̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Atsumate yi a ka vuta̱la̱ le ta̱ a asuvu a kuɗyuku ku akina a asu u ɗa a ka rongo kushen hal n ulumusa u aꞌanga. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Shegai ama a shinga a ka laɗa ta̱ yavu kaara a tsugono tsu Tata u le. Uza ɗa baci wa̱ri n atsuvu a upana, u pana! ");
INSERT INTO kdlNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Tsugono tsu zuba tsa woko ta̱ tyoku u agisani a naha: Vuma roku ɗa u tsa̱ra̱i kuzuwate ku ucanga ka uza roku u sokongi a kashina. U lapulai u sokongi ka, wa yan ipeli u ba u dengei gba̱ ili iꞌya wa̱ri n iꞌya, aku u gonoi u tsilai kashina ki. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Tsugono tsu zuba tsa woko ta̱ tyoku u agisani a naha: Uza u tsilaga u roku ɗa wa bolo igbegu i ikebe i shinga. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","An u tsa̱ra̱i u te u tsulobo cika, u ba u dengei ili iꞌya wa̱ri n iꞌya gba̱, aku u ba u tsilai u ɗa n ikebe yi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesu doki u yanka le agisani a roku u danai, “Tsugono tsu zuba tsa woko ta̱ tyoku u agisani a naha: Aka̱ni a adan a roku a ɗa a vuta̱la̱i ibilili i le a kushiva̱, aku a ka̱na̱sa̱i icun i adan kau‑kau. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","An ibilili yi i shaɗangi, a wutukpa̱i iꞌya a ikengi a dusuki a ka pecene adan yi. A zuwai a shinga yi a asuvu a mabana, aku a wotsongi a ɗa bawu a gain. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nala wa woko a aꞌayin a makorishi. Atsumate a zuba a ka tuwa̱ ta̱ a pecene ama a cingi a asuvu a ama a maci. ");
INSERT INTO kdlNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Atsumate yi a ka vuta̱la̱ ta̱ ama a cingi yi a asuvu a kuɗyuku ku akina, nte a ka rongo pini kushen n ulumusa u aꞌanga.” ");
INSERT INTO kdlNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu wece le, “I reve kalen ka ili i nala yi gba̱?” A wushuki, “Tsu reve ta̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Aku u tonuko le, “Gba̱ kawenishiki ka Mele ka ka wokoi karotsongishi a tsugono tsu zuba, wa̱ ta̱ tyoku u uza u kuwa ɗa u wutukpa̱i kuzuwate ku ucanga ku savu n ku cau a kunu ku kuzuwate ku ucanga.” ");
INSERT INTO kdlNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","An Yesu kotsoi udansa agisani yi, aku u lazai u a̱sa̱ka̱i asu vi ");
INSERT INTO kdlNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","u gonoi a Nazara, a ilyuci i ne. An u wenishikei pini a kagata ka Kashila̱, ya dem u gita̱i majiyan n a dansi, “Nte ɗa u tsa̱ra̱i kakiri ka ne n uyansa ikunesavu naha? ");
INSERT INTO kdlNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Maku ma kashei ma na vi wa? Tsa wundya mma u ne u ɗa Meri vi? Aꞌangu a ne kpam alya an Yakubu, Isuhu, n Simo n Yahuza? ");
INSERT INTO kdlNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ataku a ne kpam aꞌa̱ ta̱ na kaɓolo n a̱tsu. Niɗa wa yansa ili i na yi gba̱?” ");
INSERT INTO kdlNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Adama a nala ama yi a ꞌyuwan yi uwusha. Shegai Yesu tonuko le, “Matsumate ma tsu yan n tsupige a ilyuci i ne n kuwa ku ne wa, she a kateshe.” ");
INSERT INTO kdlNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Adama a nala, u yansa ikunesavu ushani wa, kpaci aꞌa̱ n upityanangu wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Aꞌayin a nala yi, Hiridu Antiba magono ma Galili u pana ta̱ ukuna u Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Aku u tonukoi agbashi a ne, “Yesu vi Yahaya Kalyuɓugi ɗa, uza ɗa u ꞌya̱nga̱i a ukpa̱, ɗa gai i zuwai wa yansa ikunesavu yi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Aꞌayin a ɗa a wurai niɗe, Hiridu ka̱na̱ ta̱ Yahaya, u sira yi u zuwa yi a kuwa ka aꞌali. U yan ta̱ nala adama a Hiridiya, uka u vangu u ne Filibu u ɗa u bokoi u wokoi uka u ne. ");
INSERT INTO kdlNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yahaya Kalyuɓugi tonusuko yi ta̱, “Wa̱ dere vu zuwa Hiridiya wa!” ");
INSERT INTO kdlNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hiridu wa ciga u wuna Yahaya, shegai wa pana ta̱ uwonvo u ama, kpaci a wushuku ta̱ Yahaya matsumate ma. ");
INSERT INTO kdlNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Kain ka te an a ka yan abiki† a uciɓusa n kain ka ilimaci i Hiridu, maku ma makere ma Hiridiya ma u matsa̱kai Filibu u gita̱i kuje a kapala ka Hiridu n amoci a ne, aku u panai kayanyan. ");
INSERT INTO kdlNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Aku u tsinai u da wa na̱ka̱ yi ta̱ gba̱ ili iꞌya baci dem wa ciga. ");
INSERT INTO kdlNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Aku mma u makere vi u tonuko yi u ba u dana, “Ma ciga ta̱ kaci ka Yahaya Kalyuɓugi a mabaluwa gogo‑na!” ");
INSERT INTO kdlNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Magono mi ma pana kayanyan n ili iꞌya u foloi vi wa. Shegai an u wokoi bawu wa ciga u kpa̱ɗa̱ ushaɗangu kazuwamgbani ka u yain a kapala ka amoci a ne yi, aku u tonukoi asoje a ne, ");
INSERT INTO kdlNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","a bana a kuwa ku aꞌali a kiɗa kaci ka Yahaya Kalyuɓugi. ");
INSERT INTO kdlNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","A tukoi ka a mabaluwa a na̱ka̱i makere mi. Aku u bidyai ka u tukoi mma u ne. ");
INSERT INTO kdlNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Pini nala, atoni a Yahaya a tuwa̱i a bidyai ikyamba i ne a ba a ciɗa̱ngi. Aku a ba a tonukoi Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","An Yesu panai alabari a Yahaya, aku u ꞌya̱nga̱i u uwai a kpatsu wa bana a kakamba utyoku u ne. Shegai an kakuma̱ ka ama ka revei, aku a tono yi n a wali a ikengi i kushiva̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","An u rawai kakamba ki, u cinai kakuma̱ ka ama cika ka vana yi. U panai asuvayali a le, u ta̱na̱sa̱i kpam aza ɗa aꞌa̱ri na̱ mɓa̱la̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","An kaara ka yain evu n urukpa̱, atoni a ne a tuwa̱i ara ne a danai, “Kuvuli ku yan ɗe, kpam a kakamba ka tsa̱ri. A̱sa̱ka̱ ama yi a laza a bana a une une a tsila̱ka kaci ka le ilikulya.” ");
INSERT INTO kdlNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Shegai Yesu wushunku le, “U ka̱na̱ she ama yi a laza wa. Eɗa̱ na̱ka̱ le ili i roku a lyai.” ");
INSERT INTO kdlNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Aku a danai, “Iburodi i tawun n adan a re a ɗa tsu koshi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","U danai, “Tuko numu iburodi n adan yi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Aku u tonukoi ama yi a dusukusu a mete mi. U bidyai iburodi i tawun n adan a re yi, u gaɗigbai kaci ka ne a zuba u cikpai Kashila̱ adama a ilikulya yi. U jiba̱mgba̱na̱sa̱i iꞌya, u na̱ka̱i atoni a ne a pecike ama yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Gba̱ ama yi a takuma ta̱ hal a cuwusa̱i. Aku atoni a ne a ɓolomgbonoi abuwi a ɗa buwai vi hal a shaɗangi mbana kupa na̱ n re. ");
INSERT INTO kdlNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Aꞌali a ɗa aꞌa̱ri pini a asu vi a raɓansa ta̱ ama azu a tawun (5,000), bamu gba̱m n aka na̱ mmuku. ");
INSERT INTO kdlNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kute‑kute, Yesu tonukoi atoni a ne a uwa a kpatsu a pasamgbana kushiva̱. Eyi wa shamgba ta̱ ve u a̱sa̱ka̱ ama yi a laza ugono a kuwa. ");
INSERT INTO kdlNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","An u a̱sa̱ka̱ le a lazai, aku u banai a masasa utyoku u ne wa yan kavasu. Cina kayin ka yan ɗe kpam aya wa̱ri pini utyoku u ne. ");
INSERT INTO kdlNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Aꞌayin a nala yi, kpatsu ku atoni a ne ka ka̱ ta̱ a mere ma kushiva̱, aku uwule u pige u ꞌya̱nga̱i, aꞌa̱ri umoɗono n aɓali a pige. ");
INSERT INTO kdlNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","N kpasani ku de, Yesu tuwa̱i ara le n u wali a zuba u mini. ");
INSERT INTO kdlNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","An a wene yi, aku uwonvo u ka̱na̱ le. Aku a salai, a danai, “Kafofu ka!” ");
INSERT INTO kdlNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Shegai Yesu yanka le kadyanshi, “U ra̱tsa ta̱, mpa! Panai uwonvo wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Bituru danai, “Asheku, aɗa baci mayun, tonuko mu n tuwa̱ a mini mi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","U tonuko yi, “Tuwa̱.” Bituru wuta̱i a kpatsu ki u walai a zuba u mini ubana ara ne. ");
INSERT INTO kdlNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Shegai an u wenei uwule n aɓali, aku uwonvo u ka̱na̱ yi, u gita̱i uliɓa. Aku u salai, “Asheku, wauwa mu!” ");
INSERT INTO kdlNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kute‑kute, Yesu ba̱ra̱kpa̱i kukere ku ne u ka̱na̱ yi. U danai, “Upityanangu u vunu u gusa̱ ta̱. Ndya i zuwai va yan mala̱la̱?” ");
INSERT INTO kdlNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","An a uwai a kpatsu, uwule vi kpam u vaki. ");
INSERT INTO kdlNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Aku aza ɗa aꞌa̱ri pini a kpatsu ki a lyakai Yesu kayala, a danai, “Mayun ɗa, avu Maku ma Kashila̱ ma!” ");
INSERT INTO kdlNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","An a pasamgbanai kushiva̱, aku a rawai a uyamba u Janisara. ");
INSERT INTO kdlNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","An ama yi a revei Yesu, aku a tonukoi ama a asu yi gba̱, “Yesu tuwa̱ ta̱.” Aku ama yi a tukusoi aza a mɓa̱la̱ ara ne. ");
INSERT INTO kdlNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","A folo yi u a̱sa̱ka̱ aza a mɓa̱la̱ yi a sawa kaletsu ka kunya ku ne. Gba̱ aza ɗa a sawa yi vi a ta̱na̱ ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Afarishi n awenishiki a Mele a roku a a̱sa̱ka̱i Urishelima a tuwa̱i ara Yesu, a wece yi, ");
INSERT INTO kdlNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ndya i zuwai atoni a vunu bawu a ka gorimuko ili iꞌya nkoshi n cau n tsunu n wenishikei? Kpaci a tsu sawa akere a le kahu a lyai ilikulya wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu wushunku le, “Ndya i zuwai bawu ya gorimuko kadyanshi ka Kashila̱ aku ya tono uwenishike u kaci u ɗe? ");
INSERT INTO kdlNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kashila̱ ka dana ta̱, ‘Na̱ka̱ tata u vunu na̱ mma u vunu tsupige,’ kpam ‘Vu wisha baci tata ko mma u vunu, a ka wuna vu ta̱.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Shegai ya wenishike n i dansi ama aꞌa̱ baci n ili iꞌya a ka ɓa̱nga̱ tata ko mma u le, aku a danai, ‘Ili i na yi i Kashila̱ iꞌya,’ ");
INSERT INTO kdlNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","adama a nala u ka̱na̱ a na̱ka̱ asheku a le wa. I ꞌyuwan ta̱ udani u Kashila̱ adama a agadu a ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Eɗa̱ ama a maci a kaɓan! Ishaya matsumate u korongu ta̱ dere ili iꞌya Kashila̱ ka danai: ");
INSERT INTO kdlNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“ ‘Ama a na yi n una̱ u ɗa a ka na̱ka̱ mu tsupige koshi, shegai a atakasuvu a le a yan ɗe mɓa̱ri na̱ mpa. ");
INSERT INTO kdlNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ugbashika u ɗa a ka gbashika mu vi u gbani u ɗa. Ili iꞌya kpam a ka wenishike udani u vuma u ɗa.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu isa̱i kakuma̱ ka ama ki, u tonuko le, “Panai kpam i reve ili iꞌya ma tonuko ɗa̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ili iꞌya ama a ka lyuku a una̱ u le iꞌya ya nangasa le wa, she ili iꞌya ya wuta̱ a asuvu a una̱ u le iꞌya i tsu nangasa le.” ");
INSERT INTO kdlNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Aku atoni a ne a tuwa̱i a danai, “Vu reve gba̱m an vu nangasai Afarishi katsuma̱ n ili iꞌya vu danai nala vi?” ");
INSERT INTO kdlNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","U wushunku le, “Gba̱ maɗanga ma baci bawu Tata u va̱ u zuba u shigba̱i, wa muɗa̱ ta̱ ma n alu a ne dem. ");
INSERT INTO kdlNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kiranai n Afarishi a nala yi! Aꞌa̱ ta̱ tyoku u arumba̱ a ɗa a ka rono atoku a le arumba̱, kpam gba̱ le a ka rukpa̱ ta̱ a kaɗa̱ka̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Aku Bituru wushuki, “Ndya kalen ka kadyanshi ka vu yain a ukuna u ili iꞌya ya nangasa ama yi?” ");
INSERT INTO kdlNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu danai, “Hal n gogo‑na kotsu i reve wa? ");
INSERT INTO kdlNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mayun i reve ta̱ gai ilikulya iꞌya i uwai a una̱ ya bana ta̱ a katsuma̱ aku i wuta̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Shegai kadyanshi ka cingi ka ka wuta̱i a una̱ ka wuta̱ ta̱ a katakasuvu, kpam ili iꞌya ya nangasa ɗa̱ iꞌya gai la vi. ");
INSERT INTO kdlNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","A katakasuvu ka uyawunsa u cingi n uwuna uma u vuma gbani u tsu wuta̱. Nvain n uka u uza roku n tsishankala a katakasuvu ka dem a tsu wuta̱. Nala kpam dem uboki, n kaɓan, n kadyanshi ka cingi a kaci ka atoku. ");
INSERT INTO kdlNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ili iꞌya ya nangasa ɗa̱ iꞌya la vi. Ulya ilikulya bawu usawa u akere u tsu nangasa ɗa̱ wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu a̱sa̱ka̱i asu nala vi, u lazai ubana a ilyuci i Taya n Sida. ");
INSERT INTO kdlNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","An u rawai, uka u aza a Kaꞌana† roku uza ɗa wa̱ri pini na̱ ndishi u tuwa̱i ara ne n u sala̱si, “Asheku, Maku ma Dawuda, pana asuvayali a va̱! Ityoni i cingi i shaɗangu ɗe makere ma va̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Shegai Yesu dana uka vi ili wa. Aku atoni a ne a tuwa̱i a folo yi, “Tonuko uka vi u laza a asu u na vi. Aya pini wa tono tsu n u sala̱si.” ");
INSERT INTO kdlNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu danai, “Adama a aza a Isaraꞌila ɗa koshi a suku mu. Aꞌa̱ ta̱ tyoku u ushiga u ncon n ɗa n puwa̱in.” ");
INSERT INTO kdlNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Aku uka vi tuwa̱i ara ne u kuɗa̱ngi a kapala ka ne, u danai, “Asheku, ɓa̱nga̱ mu!” ");
INSERT INTO kdlNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","U wushunku yi, “Dere ɗa vuma u bidya ilikulya i mmuku u na̱ka̱ nshe wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Uka vi danai, “Nala wa̱ri Asheku, shegai nshe n tsu lya ta̱ agashi a ilikulya iꞌya i tsu rukpusa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","U wushunki uka vi, “Uka, va̱ ta̱ n upityanangu u pige, ma yanka vu ta̱ ili iꞌya vu danai n yanka vu.” Dere u ulapa u uwule u nala vi u ɗa makere ma ne ma ta̱na̱i. ");
INSERT INTO kdlNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Pini nala, Yesu a̱sa̱ka̱i asu vi u lazai ubana a ikengi i Kushiva̱ ku Galili, u yuwa̱i a kagida̱li ka masasa u dusuki. ");
INSERT INTO kdlNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kakuma̱ ka ama ka tuwa̱i a tuko yi awunu ushani n aza ɗa ikyamba i le i soi. A tukoi dem abebe, n arumba̱, n aza a mɓa̱la̱ icun kau‑kau. A zuwa le a kapala ka ne, aku u ta̱na̱sa̱ le gba̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ya dem wa̱ri a majiyan ma ili iꞌya u wenei n iꞌya u panai. Abebe a fuɗai a dansai. Aza ɗa ikyamba i le i soi, a ta̱na̱i. Awunu a ka wala. Arumba̱ kpam a ka fuɗa a ka wene. Pini nala, ya dem wa̱ri ucikpala̱sa Kashila̱ ka aza a Isaraꞌila. ");
INSERT INTO kdlNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu isa̱i atoni a ne a asu u te, u tonuko le, “Ma pana ta̱ asuvayali i ama a na yi. Aꞌa̱ ta̱ kaɓolo na̱ mpa ara kain tatsu ɗa pa vi, bawu ili i ulya. Ma ciga n a̱sa̱ka̱ le a laza n kambulu wa, kotsu a rukpa̱ a ure aꞌayin a ɗa a ka gono a kuwa wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Atoni a ne a wushuki, “Asu u na vi kakamba ka. Nte tsa tsa̱ra̱ ilikulya iꞌya tsa lyatangu kakuma̱ ka ama ka na ki?” ");
INSERT INTO kdlNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu wece le, “Iburodi i yain iꞌya iꞌa̱ri n iꞌya?” A wushuki, “I shindere iꞌya n adan a shawu kenu.” ");
INSERT INTO kdlNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesu tonukoi ama yi a dusuku a iyamba. ");
INSERT INTO kdlNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Pini nala, u bidyai iburodi i shindere n adan yi, u cikpai Kashila̱. U jiba̱mgba̱na̱sa̱i iꞌya u na̱ka̱i atoni a ne, aku a pecikei ama yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ya dem takuma ta̱ hal u cuwa̱i. Aku atoni yi a cira̱ngi abuwi a ɗa a buwai vi hal a shaɗangi mbana n pige n shindere. ");
INSERT INTO kdlNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Aꞌali azu a nishi (4,000) a ɗa a takumai iburodi yi, bamu gba̱m n aka na̱ mmuku. ");
INSERT INTO kdlNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","An Yesu a̱sa̱ka̱i ama yi a lazai, aku u uwai a kpatsu u pasamgbanai kushiva̱. U tuwa̱i u cipa̱i a iyamba iꞌya iꞌa̱ri evu n ilyuci i Magadan. ");
INSERT INTO kdlNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Afarishi n aza a Sadusi a tuwa̱i ara Yesu a ka ciga a wanda yi n keci, a tonuko yi u yanka le iryoci i roku, tsa̱ra̱ u wenike le an Kashila̱ ka wushuki n eyi. ");
INSERT INTO kdlNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Shegai Yesu wushunku le, “Aꞌayin a ɗa i wenei kaara ka rukpa̱, i tsu dana ta̱ ‘Usana wa lobono ta̱, kpaci i wene ta̱ zuba u shilamgbanai.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","N usana kpam i wene baci zuba u shilamgbanai aku u tuwa̱i u lima̱na̱i, i tsu dana ta̱, “Ara wa ro ta̱.” I wenei iryoci i na a zuba i fuɗai i revei kalen ka le. Nala dem i wenei ili iꞌya ma yansa gogo‑na, shegai i fuɗa i reve kalen ka le wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ama a cingi n aza a ukpa̱ɗa̱ u upityanangu u aꞌayin a na a wecike ta̱ iryoci, shegai a ka na̱ka̱ iryoci wa, she iryoci i Inusa matsumate koshi.” Aku Yesu a̱sa̱ka̱ le u lazai. ");
INSERT INTO kdlNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","An atoni a Yesu a pasamgbanai upashi u kushiva̱, a a̱sa̱nsa̱i a bidya burodi wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu tonuko le, “Kiranai, i yain ugboji n yisti u Afarishi n u aza a Sadusi.”† ");
INSERT INTO kdlNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Atoni yi a ka dansa utyoku u le, “U ka̱na̱ ta̱ u dana nala kpaci tsu tuko burodi wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","An Yesu revei ili iꞌya a ka tono, aku u wece le, “Ndya i zuwai ya dansa utyoku u ɗe a ukuna u ɗa bawu iꞌa̱ri n burodi? Upityanangu u ɗe u gusa̱ ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Hal n gogo‑na kotsu i reve wa? Ciɓai n iburodi i tawun iꞌya n lyatangi ama azu a tawun (5,000), kpam ciɓai hal i cira̱ngi abuwi a ɗa a buwai mbana ushani. ");
INSERT INTO kdlNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Niɗa ukuna u iburodi i shindere iꞌya n lyatangi ama azu a nishi (4,000)? Mbana n yain n ɗa i shaɗangi n abuwi a ɗa a buwai? ");
INSERT INTO kdlNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mpa kadyanshi ka burodi ka ma yanka ɗa̱ wa. Ndya i zuwai i kpa̱ɗa̱i ureve? Tonuko ɗa ma tonuko ɗa̱ i yain ugboji n yisti u Afarishi n u aza a Sadusi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","A makorishi a tuwa̱i a revei an kadyanshi ka yisti n burodi ka wa yan wa, shegai ukuna u uwenishike u kaɓan u Afarishi n aza a Sadusi. ");
INSERT INTO kdlNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu n atoni a ne a ka wala̱ka, an a rawai a kaɓon ka ka̱ri evu n ilyuci i Kasariya Filibi, u wece le, “Ya ama a ka dansa Maku ma Vuma ma̱ri?” ");
INSERT INTO kdlNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Aku a wushuki, “Aza roku a danai avu Yahaya Kalyuɓugi ɗa. Aza roku a danai avu Iliya ɗa, aza roku a danai avu Irimiya ɗa, aza roku kpam a danai avu uza u te ɗa a asuvu a ntsumate n cau.” ");
INSERT INTO kdlNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Aku u wece le, “Eɗa̱ tani, ya ya dansa ma̱ri?” ");
INSERT INTO kdlNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simo Bituru wushuki, “Avu Kawauwi ka, Maku ma Kashila̱ Uza u Uma.” ");
INSERT INTO kdlNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu danai, “Avu uza u una̱ u shinga u ɗa va̱ri, Simo maku ma Inusa, kpaci ko uza u wenishike vu iꞌya wa. Tata u va̱ u zuba u ɗa u wenike vu uza ɗa ma̱ri. ");
INSERT INTO kdlNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Adama a nala, ma isa̱ vu ta̱ Bituru; wata, ‘Katali.’ A katali ka nala ka ma ma kunu ku atoni a va̱, kpam ucira u ukpa̱ wa varangu ka wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ma na̱ka̱ vu ta̱ nkukpunki n tsugono tsu zuba. Ili iꞌya bawu va a̱sa̱ka̱ uza roku u yain a likimba, Kashila̱ dem a zuba wa a̱sa̱ka̱ a yain iꞌya wa. Ili iꞌya va a̱sa̱ka̱ uza roku u yain a likimba, Kashila̱ dem a zuba wa a̱sa̱ka̱ ta̱ a yain iꞌya.” ");
INSERT INTO kdlNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Aku Yesu ronoi atsuvu a atoni a ne kotsu a tonuko uza a dana aya Kawauwi ki wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Pini nala, Yesu gita̱i utonusuko atoni a ne ili iꞌya ya tuwa̱ ya gita̱ n eyi. U danai, “U ka̱na̱ ta̱ n bana a Urishelima a asu u nkoshi, n aɗara̱kpi a pige, n awenishiki a Mele. A ka zuwa mu ta̱ n pana ikyamba cika, kpam a wuna mu, shegai a kain ka tatsu aku n ꞌya̱nga̱ n uma.” ");
INSERT INTO kdlNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Bituru rono yi a ikengi, u tonuko yi, “A̱sa̱ka̱ icun kadyanshi ka nala ki, Asheku, Kashila̱ ka a̱sa̱ka̱ ili i nala yi i gita̱ n avu wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Aku Yesu weɓele yi, u danai, “Kanangasi, ba̱tsa̱ dan na̱ mpa! Va ka̱ngu mu ta̱ uyan ili iꞌya Kashila̱ ka ciga mu n yain, kpaci uyawunsa u vunu tyoku u vuma ɗa wa̱ri, tyoku u Kashila̱ ɗa wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Aku Yesu tonukoi atoni a ne, “Uza ɗa baci wa ciga u woko katoni ka va̱, u ka̱na̱ ta̱ u nani kaci ka ne. U ka̱na̱ ta̱ kpam u canga mawandamgbani ma ne kain dem u tono mu. ");
INSERT INTO kdlNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kpaci uza ɗa baci wa ciga u wauwa uma u ne, wa namba ta̱ u ɗa. Uza ɗa baci u nambai uma u ne adama a va̱, wa tsa̱ra̱ ta̱ u ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nte kalen ka vuma wa tsa̱ra̱ likimba u na gba̱, aku u namba uma u ne? Ndya kpam vuma wa fuɗa wa tsupa tsa̱ra̱ u wauwa uma u ne? ");
INSERT INTO kdlNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kpaci Maku ma Vuma ma tuwa̱ ta̱ n tsupige tsu Tata u ne, n atsumate a zuba a ne, u tsupa ya dem a ili iꞌya u yain. ");
INSERT INTO kdlNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mayun n tonuko ɗa̱, aza roku a ɗa pini a asuvu a ɗe n gogo‑na naha, a ka kuwa̱ wa, she a wene mu utuwa̱ n tsugono tsu va̱ mpa Maku ma Vuma.” ");
INSERT INTO kdlNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","An aꞌayin a teli a wurai, Yesu bidyai Bituru kaɓolo n Yakubu n vangu u ne Yahaya. A yuwa̱i a zuba u masasa ma ugaɗi a rongoi ɗe utyoku u le. ");
INSERT INTO kdlNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ele pini, aku a wenei u yansa̱kai pini a kapala ka le, upetiwaꞌeshi u ne wa laɗa yavu kaara, aminya a ne kpam a wa̱ra̱ma̱i pun yavu katyashi. ");
INSERT INTO kdlNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kute‑kute, Musa n Iliya a wenikei kaci ka le ara Yesu a gita̱i kadyanshi n eyi. ");
INSERT INTO kdlNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Aku Bituru danai, “Asheku, u lobono ta̱ an tsa̱ri pini na! A̱sa̱ka̱ tsu yain atani a tatsu, ka te ka vunu, ka te ka Musa, ka te kpam ka Iliya.” ");
INSERT INTO kdlNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tyoku ɗa wa̱ri a kadyanshi, aku kalishi ka katyashi ka kimba̱ le. A panai kala̱ga̱tsu pini a asuvu a kalishi ki, ka danai, “Maku ma va̱ ma na vi, uza ɗa ma ciga cika, kpam ma pana ta̱ kayanyan n eyi. Pana̱ka ni!” ");
INSERT INTO kdlNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","An atoni a ne a panai kala̱ga̱tsu ki, aku uwonvo u ka̱na̱ le hal a rukpa̱i a varai upetiwaꞌeshi u le a iyamba. ");
INSERT INTO kdlNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Aku Yesu tuwa̱i u sawa le, u danai, “ꞌYa̱nga̱i, kotsu i pana uwonvo wa!” ");
INSERT INTO kdlNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","An a gaɗigbai aꞌaci a le, a wene uza wa, she Yesu koshi. ");
INSERT INTO kdlNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ele n a cipi a masasa mi, aku Yesu tonuko le, “Kotsu i tonuko uza ili iꞌya i wenei na vi wa, she aꞌayin a ɗa mpa, Maku ma Vuma, n ꞌya̱nga̱ a ukpa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Aku atoni yi a wece yi, “Ndya i zuwai awenishiki a Mele a danai u ka̱na̱ ta̱ Iliya tuwa̱ kahu Kawauwi?” ");
INSERT INTO kdlNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Aku u tonuko le, “Mayun ɗa, Iliya wa tuwa̱ ta̱ u foɓuso ili gba̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","N tonuko ɗa̱, eyi u tuwa̱ ɗe, shegai ama a reve yi wa. A yanka yi tyoku ɗa u gan le. Nala dem a ka zuwa Maku ma Vuma ma pana ikyamba.” ");
INSERT INTO kdlNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Pini nala, ɗa atoni yi a revei an Yesu ukuna u Yahaya Kalyuɓugi u ɗa wa dansa n ele. ");
INSERT INTO kdlNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","An Yesu n atoni a ne a rawai a kami ka masasa mi, kakuma̱ ka ama ka̱ri le uvana pini. Vuma roku u tuwa̱i u kuɗa̱ngi a kapala ka ne, ");
INSERT INTO kdlNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","u danai, “Asheku, pana asuvayali a maku ma va̱! Wa̱ ta̱ n ityoni i cingi i ipori i ucira, kpam aꞌayin a roku i tsu varangu yi ta̱ a asuvu a akina ko a mini. ");
INSERT INTO kdlNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","N tuko yi a asu u atoni a vunu tsa̱ra̱ a ta̱na̱sa̱ yi, shegai uza wa̱ la u fuɗai u ta̱na̱sa̱ yi wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu tonuko le, “Eɗa̱ i ryagbaja ta̱, kpam iꞌa̱ n upityanangu wa. Hal ubana nwere ɗa ma rongo n a̱ɗa̱? Kpam hal ubana nwere ɗa ma fuɗa ma kawunku n a̱ɗa̱?” U tonukoi vuma vi, “Tuko maku mi na.” ");
INSERT INTO kdlNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Aku Yesu ɓaranai ityoni yi, aku i a̱sa̱ka̱i maku mi. Kute‑kute, maku mi ma ta̱na̱i. ");
INSERT INTO kdlNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","An Yesu wa̱ri utyoku u ne, aku atoni a ne a tuwa̱i ara ne a wece yi, “Ndya i zuwai a̱tsu tsu kpa̱ɗa̱i uwutukpa̱ ityoni yi?” ");
INSERT INTO kdlNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","U wushunku le, “Upityanangu u ɗe u gusa̱ ta̱. Mayun n tonuko ɗa̱, a da baci iꞌa̱ri n upityanangu ko kenukulu tyoku u ucun u musta, ya fuɗa ta̱ i tonuko masasa ma na, ‘Muɗa̱ pini na vu gono niɗe,’ kpam she ma muɗa̱. Ili iꞌa̱ la ya kpa̱ɗa̱ uyan wa.  ");
INSERT INTO kdlNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Icun i ili i na yi ya wuta̱ wa she n kavasu n kakuli koshi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kain ka te an a gonoi a Galili, Yesu tonuko le, “Uza roku wa neke ta̱ Maku ma Vuma a akere a ama. ");
INSERT INTO kdlNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","A ka wuna yi ta̱, shegai kain ka tatsu wa ꞌya̱nga̱ ta̱ a ukpa̱.” Aku atoni yi a shaɗangi n unamgbukatsuma̱ cika. ");
INSERT INTO kdlNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","An Yesu n atoni a ne a rawai a Kafarnahum, aza roku aza ɗa a ka wushika Kuwa ku Kashila̱ utafa u ikebe i azurufa i re i re a tuwa̱i ara Bituru, a wece yi, “Kawenishiki ka ɗe ka tsu tsupa utafa a Kuwa ku Kashila̱?” ");
INSERT INTO kdlNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Bituru wushunku le, “U tsu tsupa ta̱.” An u gonoi a kuwa, kahu gba̱m u kukpa̱ una̱ u dana ukuna, Yesu tonuko yi, “An ya ngono n tsu kiɗa̱ga utafa, ama a le ko gai amoci?” ");
INSERT INTO kdlNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Aku Bituru danai, “Amoci a ɗa.” Yesu tonuko yi, “U ka̱na̱ la vi ama a le a tsupa utafa wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Shegai tsa ciga tsu nangasa le atakasuvu wa, adama a nala wala vu bana a kushiva̱ vu yain kafula̱. Kadan ka baci dem vu gita̱i uka̱na̱, ka va bidya. Vu kukpa̱ baci una̱ u ne, va wene ta̱ ukebe u azurufa u pige u te pini a asuvu u ɗa u rawai u tsupa utafa u va̱ n u vunu. Aku vu bidya u ɗa vu banka le.” ");
INSERT INTO kdlNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Aꞌayin a nala yi, atoni yi a tuwa̱i ara Yesu a wece yi, “Ya wa laka tsupige a tsugono tsu zuba?” ");
INSERT INTO kdlNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu isa̱i maku ma kenu ma tuwa̱i ma shamgbai a kapala ka le. ");
INSERT INTO kdlNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","U danai, “Mayun n tonuko ɗa̱, u ka̱na̱ ta̱ i savaɗa i woko tyoku u mmuku n kenu, tsa̱ra̱ i uwa a tsugono tsu zuba. ");
INSERT INTO kdlNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Adama a nala, uza ɗa baci dem u vakunki kaci ka ne tyoku u maku ma kenu ma na, aya uzapige a tsugono tsu zuba. ");
INSERT INTO kdlNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Kpam uza ɗa baci dem u wushai maku ma kenu tyoku u naha n kala ka va̱, mpa u wushai.” ");
INSERT INTO kdlNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yesu lyai kapala n kadyanshi, “Uza ɗa baci u zuwai uza u kenu gba̱ a asuvu a atoni a va̱ a na u nusai, vuma u nala vi wa laka yi ta̱ tsulobo a varangu yi a asuvu a kushiva̱ n katali ka kira ka ara̱ji usiri a udyoku u ne. ");
INSERT INTO kdlNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Wa wuyana tani n ni n ama a likimba n ukuna u ɗa wa zuwa le a yain unyushi u cingi. Ukuna u nala wa gita̱ ta̱, shegai ter n uza ɗa wa zuwa u gita̱ vi. ");
INSERT INTO kdlNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kukere ku vunu ko kune ku vunu ku zuwa vu baci unyushi, kiɗamgbana ka vu varangu. Wa laka vu ta̱ shana vu namba kapashi ka ikyamba ka vunu ka te tsa̱ra̱ vu ɓa̱ra̱kpa̱, n u ɗa va yan n akere a re ko aꞌene a re, aku a varangu vu a kuwa ku akina a ɗa bawu a ka kotso. ");
INSERT INTO kdlNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Keshi ka vunu ka zuwa vu baci unyushi, foɗo ka vu varangu. Wa laka vu ta̱ shana vu ɓa̱ra̱kpa̱ n keshi ka te, n u ɗa va yan n aꞌeshi a re aku a varangu vu a kuwa ku akina a ɗa bawu a ka kotso.” ");
INSERT INTO kdlNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yesu doku ta̱ u danai, “Kiranai, kotsu vu goro ko maku ma te a asuvu a mmuku n na mi wa. N tonuko ɗa̱, aꞌa̱ ta̱ n atsumate a zuba a ɗa a ka rongo n Tata u va̱ u zuba.”  ");
INSERT INTO kdlNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kpam mpa Maku ma Vuma n tuwa̱ ta̱ n wauwa iꞌya i puwa̱in. ");
INSERT INTO kdlNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“A dana kaliniki ka̱ na̱ ncon amangatawun, aku ma te ma karai kakamba ma puwa̱in, ndya wa yan? Wa a̱sa̱ka̱ ta̱ amanganishinkupa n kuci n ɗa n buwai vi na̱ n lini a kagida̱li ka masasa u bana ubolo ma te ma ma puwa̱in vi. ");
INSERT INTO kdlNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","U wene baci ma, n tonuko ɗa̱, wa la ta̱ upana kayanyan a kaci ka ma te ma nala mi kapala n amanganishinkupa n kuci n ɗa bawu n puwa̱in vi. ");
INSERT INTO kdlNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nala dem wa̱ri n Tata u ɗe uza ɗa wa̱ri a zuba, wa ciga uza u te a asuvu a mmuku n kenu n na mi u puwa̱n wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesu lyai kapala n kadyanshi, “Utoku u vunu u nusuka vu baci, bana ara ne vu tonuko yi iꞌya u yanka vu vi. Shegai i yain kadyanshi ki utyoku u ɗe ama a re. U wushuku baci, vu gonuko yi ɗe la vi a ure. ");
INSERT INTO kdlNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Shegai u ꞌyuwan baci uwushuku, doku vu bana ara ne n uza roku ko ama a re. Vu yan baci nala vu shaɗangu ta̱ udani u ɗa Tagara̱da u Kashila̱ u danai, ama a re ko ama a tatsu a ɗa a gain a reve n ukuna kahu a bidya uza uza u unyushi. ");
INSERT INTO kdlNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","U ꞌyuwan le baci upana̱ka, aku vu tonuko atoku a Atoni. U ꞌyuwan baci upana̱ka Atoni yi, aku i bidya yi yavu uza ɗa bawu u wushuki n Kashila̱, ko kpam yavu kawushi ka utafa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Yesu doki u danai, “Mayun n tonuko ɗa̱, ili iꞌya bawu va a̱sa̱ka̱ uza roku u yain a likimba, Kashila̱ dem a zuba wa a̱sa̱ka̱ a yain iꞌya wa. Ili iꞌya va a̱sa̱ka̱ a yain a likimba, Kashila̱ dem a zuba wa a̱sa̱ka̱ ta̱ iꞌya. ");
INSERT INTO kdlNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Kpam iꞌya baci ama a re a ɗe a wushuki n iꞌya a likimba hal i yankai iꞌya kavasu, Tata u va̱ uza ɗa wa̱ri a zuba wa yanka ɗa̱ ta̱ iꞌya. ");
INSERT INTO kdlNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kpaci asu u ɗa baci ama a re ko ama a tatsu a ɓolongi a asuvu a kala ka va̱, ma̱ ta̱ pini n ele.” ");
INSERT INTO kdlNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pini nala, Bituru tuwa̱i ara Yesu u wece yi, “Asheku, utoku u va̱ u lya baci kelime n uyansa̱ka mu unyushi, ku yain ka u gain n cimbusuka̱ yi, hal ubana kushindere?” ");
INSERT INTO kdlNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","U wushuki, “Kushindere ka wa, shegai kushindere kadoɓo amangatatsunkupa. ");
INSERT INTO kdlNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Tsugono tsu zuba tsa woko ta̱ tyoku u agisani a naha: A yan ta̱ magono ma roku uza ɗa u yawunsai u wushi ikebe iꞌya wa tono agbashi a ne. ");
INSERT INTO kdlNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tyoku ɗa wa̱ri pini a uwusha ikebe yi, aku a tuko yi kagbashi ka roku uza ɗa magono mi ma tono ikebe i zinariya i pige i pige azu kupa (10,000). ");
INSERT INTO kdlNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kagbashi ki ka̱ n ikebe iꞌya wa fuɗa wa tsupa kutan ku ne ki wa. Pini nala, magono ma danai gba̱ ili iꞌya kagbashi ka̱ri n iꞌya a denge iꞌya, hal n kagbashi ki n uka u ne na̱ mmuku n ne dem. Tsa̱ra̱ a bidya ikebe yi a tsupa magono mi kutan ku ne. ");
INSERT INTO kdlNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Shegai kagbashi ki ka kuɗa̱ngi ka folo yi, ‘Yanka mu ahankuri, ma tsupa vu ta̱ gba̱ iꞌya va tono mu.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Pini nala, magono mi ma panai vuma vi asuvayali. U a̱sa̱ka̱i vuma vi u lazai, kpam u tonuko yi u a̱sa̱ka̱ kotsu u tsupa kpam ikebe yi wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Tyoku ɗa kagbashi ki ka̱ri a nwalu, aku u gawunsai n kagbashi ka roku uza ɗa wa tono ikebe i azurufa amangatawun (100). Pini nala, u gaga yi udyoku, n u tonusuko yi, ‘Tsupa mu iꞌya ma tono vu!’ ");
INSERT INTO kdlNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Aku kagbashi ki ka kuɗa̱ngi ka folo yi, ‘Yanka mu ahankuri, ma tsupa vu ta̱ iꞌya va tono mu vi.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Shegai kagbashi ka kagita̱ ki ka ꞌyuwan yi upana iyali, u zuwai a banka yi a kuwa ku aꞌali hal aꞌayin a ɗa u tsupai kutan ki. ");
INSERT INTO kdlNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","An agbashi a ɗa a buwai vi a panai iꞌya i gita̱i, asuvu a le a namgba ta̱ cika. Pini nala, a banai a asu u magono a tonuko yi iꞌya i gita̱i. ");
INSERT INTO kdlNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Aku magono ma isa̱i kagbashi ka kagita̱ ki u tonuko yi, ‘Avu kagbashi ka gbani, an vu folo mu n a̱sa̱nsa̱ n iꞌya ma tono vu, aku n tonuko vu vu a̱sa̱ka̱ she vu tsupa wa vi. ");
INSERT INTO kdlNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","She va̱ri vu pana dem utoku u vunu kagbashi ki iyali, tyoku ɗa n pana vu iyali.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Magono mi ma yan ta̱ upan cika hal u zuwai a banka yi a kuwa ku aꞌali tsa̱ra̱ a yanka yi mavura cika, hal she aꞌayin a ɗa u fuɗai u tsupai iꞌya magono mi ma tono yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Magono ma nala mi ma yan ta̱ iꞌya Tata u va̱ uza ɗa wa̱ri a zuba wa yanka ɗa̱ i ꞌyuwan baci ucimbusuka̱ atoku a ɗe a asuvu a atakasuvu a ɗe.” ");
INSERT INTO kdlNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","An Yesu kotsoi udansa ili i nala yi, aku u lazai u a̱sa̱ka̱i Galili u banai a uɓongu u Yahuda a upashi u Aga̱ta̱ a Urudu. ");
INSERT INTO kdlNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kakuma̱ ka ama ushani ka tono yi, u ta̱na̱sa̱i aza a mɓa̱la̱ a le. ");
INSERT INTO kdlNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Afarishi a roku a tuwa̱i a ka ciga a wanda yi n keci, a da, “Mele ma wushunku vuma u a̱sa̱ka̱ uka u ne a ukuna u ɗa baci dem u wenei u yanyi?” ");
INSERT INTO kdlNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu wushuki, “I yan ta̱ ka̱neshi a Tagara̱da u Kashila̱ an Kashila̱ ka yain likimba, ‘U yan le ta̱ vali n uka. ");
INSERT INTO kdlNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ili iꞌya i zuwai vali wa a̱sa̱ka̱ tata u ne na̱ mma u ne u paɗara n uka u ne iꞌya gai la vi. Ama a re a le a ka woko ta̱ uza u te.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","A ka yan kpam ama a re wa, shegai uza u te. Adama a nala, ili iꞌya baci Kashila̱ ka gawain, kotsu uza u peci iꞌya wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Afarishi yi a wece yi, “Ndya i zuwai Musa na̱ka̱i Mele u da uza u na̱ka̱ uka u ne tagara̱da u upece iyolo aku u a̱sa̱ka̱ yi u wala?” ");
INSERT INTO kdlNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","U wushuki, “A̱sa̱ka̱ ɗa Musa a̱sa̱ka̱ ɗa̱ i peci n aka a ɗe adama a ɗa i ryagbajai i kpa̱ɗa̱i upana uwenishike u Kashila̱, shegai a kagita̱ Kashila̱ ka wushuku n ukuna u nala wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kpam n tonuko ɗa̱, uza ɗa baci dem u pecei n uka u ne adama a tsishankala a ɗa baci wa, aku u zuwai u roku, tsishankala tsa vuma u nala vi wa yan n eyi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Atoni a ne a tonuko yi, “Nala baci wa̱ri a mere ma vali n uka u ne, wa laka ta̱ la vi uza u rongo bawu u zuwai uka.” ");
INSERT INTO kdlNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","U wushuki, “Uwenishike u na u ka̱na̱ uza dem wa, shegai aza ɗa Kashila̱ ka na̱ka̱i u ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ukuna u ɗa pini u ɗa wa zuwa aza roku a kpa̱ɗa̱ uzuwa aka. Aza roku a matsa le ta̱ a ka fuɗa a ka matsa wa. Aza roku cina a matsa le ɗe, aku aza roku a yanka le. Aza roku kpam a bidiga ta̱ kaci ka le a ka zuwa aka wa adama a tsugono tsu zuba. Shegai uza ɗa baci dem uwenishike vi u ka̱na̱i, she u wushuku n u ɗa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ama roku a tukoi mmuku n le ara Yesu tsa̱ra̱ u taɗanku le akere u yanka le kavasu, aku atoni a ne a ɓaranai ama yi a a̱sa̱ka̱ yi udamgbara̱sa. ");
INSERT INTO kdlNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Shegai u danai, “A̱sa̱ka̱i mmuku n kenu n tuwa̱ ara va̱, kotsu i ɓishinka le wa. Ama ɗa aꞌa̱ri icun i mmuku n na mi alya aza a tsugono tsu zuba.” ");
INSERT INTO kdlNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","An u taɗanki mmuku mi akere, aku u lazai. ");
INSERT INTO kdlNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","An nala u wurai, aku kalobo ka roku ka tuwa̱i ara Yesu u wece yi, “Kawenishiki, icun i ili i shinga i eni iꞌya ma yan aku n tsa̱ra̱ uma u ɗa bawu wa kotso?” ");
INSERT INTO kdlNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu tonuko yi, “Ndya i zuwai va wece mu a kaci ka ili i shinga? Kashila̱ ka koshi uza u shinga. Va ciga baci vu tsa̱ra̱ uma u ɗa bawu wa kotso, u ka̱na̱ ta̱ vu na̱ka̱ mele ma ne tsupige.” ");
INSERT INTO kdlNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Kalobo ki ka wecikei, “Ucun u mele ma eni?” U wushuki, “ ‘Kotsu vu wuna uma u vuma gbani wa. Kotsu vu vaku n uka u ɗa bawu wa̱ri u vunu wa. Kotsu vu boko wa. Kotsu vu sira̱ka kaɓan kaɓetsu wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Na̱ka̱ mma n tata u vunu karinga̱.’ ‘Ciga uza u karen u vunu tyoku ɗa va ciga kaci ka vunu.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kalobo ki ka danai, “Ma yansa ta̱ ili i nala yi gba̱. Ndya kpam i buwai iꞌya i gain n yain?” ");
INSERT INTO kdlNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","U wushuki, “Va ciga baci vu woko uza maci, wala vu ba vu denge gba̱ iꞌya va̱ri n iꞌya, vu ɓa̱nga̱ aza a unambi n ikebe yi, va yan ta̱ n utsa̱ri a zuba. Pini nala, vu tuwa̱ vu woko katoni ka va̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","An kalobo ki ka panai nala, aku u lazai n unamgbukatsuma̱ cika. Kpaci wa̱ ta̱ n utsa̱ri cika. ");
INSERT INTO kdlNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesu tonukoi atoni a ne, “Mayun n tonuko ɗa̱, wa wuyana ta̱ uza u utsa̱ri u uwa a tsugono tsu zuba. ");
INSERT INTO kdlNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","N tonuko ɗa̱, wa laka ta̱ shana karakuma ka wura a kpele ka kujulu, n u ɗa uza u utsa̱ri wa uwa a tsugono tsu Kashila̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","An atoni a ne a panai nala, a yain majiyan cika hal a wecikei, “Ya wa̱ uza ɗa wa tsa̱ra̱ iwauwi?”† ");
INSERT INTO kdlNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","U kondono le u danai, “Ili iꞌya bawu vuma wa fuɗa wa yan iꞌya la vi, shegai Kashila̱ ka fuɗa ta̱ ka yan ko ndya wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Bituru tonuko yi, “Tsu a̱sa̱ka̱ ɗe gba̱ ili iꞌya tsa̱ri n iꞌya tsa̱ra̱ tsu tono vu, ndya wa̱ tsa tsa̱ra̱?” ");
INSERT INTO kdlNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","U tonuko le, “Mayun n tonuko ɗa̱, mpa Maku ma Vuma n dusuku baci a karatsu ka pige ka tsugono a aꞌayin a savu, eɗa̱ aza ɗa i tono mu, ya dusuku ta̱ dem a aratsu kupa n a re, i yanka agali kupa n a re a Isaraꞌila afada. ");
INSERT INTO kdlNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Gba̱ uza ɗa baci u a̱sa̱ka̱i iꞌya wa̱ri n iꞌya adama a va̱; (wata, aꞌuwa, ko tata ko mma, ko atoku aka n aꞌali, ko mmuku, ko ashina), a ka tsupa yi ta̱ iꞌya hal kadoɓo amangatawun (100). Wa tsa̱ra̱ ta̱ kpam uma u ɗa bawu wa kotso. ");
INSERT INTO kdlNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Shegai n gogo‑na ama ushani aza ɗa aꞌa̱ri aza a kagita̱ a ka woko ta̱ aza a makorishi, ama kpam ushani aza ɗa aꞌa̱ri a makorishi a ka woko ta̱ aza a kagita̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","An Yesu wa̱ri a utono tyoku ɗa tsugono tsu zuba tsa̱ri, u da, “A yan ta̱ vuma roku uza ɗa wa̱ri n kashina ka cinwi.† Kain ka te n kpasani, u wuta̱i tsa̱ra̱ u boli azamaninga aza ɗa a ka yanka yi manyan a kashina ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","U wushuku ta̱ wa tsupa le ikebe i uliva̱; wata, ukebe u azurufa u te. Aku u tutsuku le a ba a yanka yi manyan a kashina ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“An kaara ka gaɗigba, aku wa wura a mere ma kuden, pini nala, u wenei ama roku kushani bawu a ka yan ko ili. ");
INSERT INTO kdlNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Aku u bidya le u tonuko le wa tsupa le ta̱ ili iꞌya i gain u tsupa le kaara ka kotso baci. ");
INSERT INTO kdlNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","A lazai a ba a yain manyan a kashina ka ne. “An kaara ka rawai a kaci, n ulapa u uwule u tatsu kpam, u doku ta̱ dem u yain nala. ");
INSERT INTO kdlNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","An ulapa u uwule u te u manyan u wokoi, eyi pini a asuvu a ilyuci yi, aku u wenei ama roku kushani. U wece le, ‘Ndya i zuwai ara ya liva̱ bawu manyan?’ ");
INSERT INTO kdlNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“A wushuki, ‘Tsu tsa̱ra̱ uza ɗa u bidya tsu manyan wa.’ “Vuma vi u tonuko le, ‘Walai i ba i yain manyan a kashina ka va̱.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“An kaara ka kotsoi, aku u tonukoi uzapige u azamaninga vi, ‘Isa̱ azamaninga yi vu tsupa le. Gita̱ vu tsupa aza ɗa n korusoi ubidya ubana a asu u aza a kagita̱.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“An azamaninga aza ɗa a yain manyan ma ulapa u uwule u te koshi a tuwa̱i uwusha ikebe i le, ya dem u wushai ukebe u azurufa u te. ");
INSERT INTO kdlNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","An aza ɗa a gita̱i manyan ili i kpasani a tuwa̱i uwusha i le, ya dem zuwa ta̱ uma u ɗa wa tsa̱ra̱ iꞌya i lai i aza a niɗe. Shegai gba̱ le a na̱ka̱ le dere tyoku u aza a kagita̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","An a na̱ka̱i ya dem i ne, aku a tonukoi uza u kashina vi, ");
INSERT INTO kdlNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Aza ɗa a korusoi utuwa̱ manyan ma ulapa u uwule u te u ɗa koshi a yain. Shegai vu tsupa le dere n a̱tsu. Kpam tsu liva̱ ta̱ a manyan a kaara ka shen.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Uza u kashina vi u wushunki uza u te u le, ‘Uza u va̱, n ryafa ɗa̱ wa. N tsupa ɗa̱ ta̱ dere tyoku ɗa tsu zuwamgbanai. ");
INSERT INTO kdlNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Bidya ukebe u vunu vu wala! Ma ciga ta̱ n tsupa aza ɗa n korusoi ubidya dere tyoku ɗa n tsupa ɗa̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ma yan ta̱ ili iꞌya ma ciga n ikebe i va̱. Malyon ma ya yan an n yankai ama a nala yi ili i shinga?’ ” ");
INSERT INTO kdlNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Aku Yesu danai, “Nala wa̱ri. Uza u kagita̱ wa woko ta̱ a makorishi, uza u makorishi kpam u woko uza u kagita̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","An Yesu wa̱ri nwalu ubana a Urishelima, aku u isa̱i Kupanamere vi paki, u tonuko le, ");
INSERT INTO kdlNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Tsu bana baci a Urishelima, a ka neke ta̱ Maku ma Vuma a akere a aɗara̱kpi a pige n awenishiki a Mele. A ka kiɗa̱ga yi ta̱ ugana u ukpa̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Aku a na̱ka̱ngu yi a akere a Awulawa a yan yi mavura, a bawin yi, aku kpam a wandamgbana yi a mawandamgbani. Shegai wa ꞌya̱nga̱ ta̱ a kain ka tatsu.” ");
INSERT INTO kdlNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Aku mma u mmuku n Zabidi u tuwa̱i ara Yesu na̱ mmuku n ne n re, Yakubu n Yahaya. Aku u kuɗa̱ngi wa folo yi u yanka yi ili i shinga. ");
INSERT INTO kdlNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu wece yi, “Ndya va ciga n yanka vu?” U danai, “Vu uwa baci a tsugono tsu vunu, va a̱sa̱ka̱ mmuku n re n va̱ n dusuku evu n avu, uza u te a ulyaki uza u te kpam a ugula̱ u vunu?” ");
INSERT INTO kdlNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Shegai Yesu wushunku le, “I reve kalen ka ili iꞌya ya wecike vi wa. Ya fuɗa ya so mako ma upana u ikyamba ma ma so?” Alobo yi a wushuki, “Tsa fuɗa ta̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu wushunku le, “Mayun ɗa ya so mako ma upana u ikyamba ma ma so. Shegai ma fuɗa ma ɗanga̱sa uza ɗa wa dusuku a ulyaki u va̱ ko a ugula̱ u va̱ wa. Asu u nala vi u ama ɗa Tata u va̱ u foɓusukoi u ɗa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","An atoni kupa a ɗa a buwai vi a panai nala, aku a ka pana upan u ama a re a nala yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yesu isa̱i atoni yi gba̱ a asu u te, u tonuko le, “I reve ta̱ ngono ma Awulawa a tsu wenike ta̱ ama ucira. Kpam azapige a le a tsu yan ta̱ manyan n tsupige tsu le a kaci ka ama. ");
INSERT INTO kdlNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Shegai ugan nala gita̱ n a̱ɗa̱ wa. Uza ɗa baci dem wa ciga u woko uzapige a mere ma ɗe, u ka̱na̱ ta̱ u woko kagbashi ka ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ko ya baci wa ciga u woko a kapala ka ɗe, u ka̱na̱ ta̱ u gbashika ɗa̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ko mpa gba̱m Maku ma Vuma n tuwa̱ adama a ɗa ama a ka gbashika mu wa, shegai n gbashika ama, kpam n na̱ka̱ uma u ɗa wa wauwa ama ushani a unyushi u cingi u le.” ");
INSERT INTO kdlNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","An Yesu n atoni a ne a ka wuta̱ a Jeriko, kakuma̱ ka ama ushani ka tono le. ");
INSERT INTO kdlNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Arumba̱ ama a re a ɗa aꞌa̱ri ndishi a ikengi i ure a panai a da Yesu ɗa wa wura, aku a gita̱i isali, n a dansi, “Asheku, Maku ma Dawuda! Pana asuvayali a tsunu!” ");
INSERT INTO kdlNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Aku kakuma̱ ki ka tonuko le a paɗa, shegai a doku a salai cika, “Asheku, Maku ma Dawuda! Pana asuvayali a tsunu!” ");
INSERT INTO kdlNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","An Yesu pana̱ka le, aku u shamgbai, u wece le, “Ndya ya ciga mu n yanka ɗa̱?” ");
INSERT INTO kdlNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","A wushuki, “Asheku, tsa ciga ta̱ tsu wene asu!” ");
INSERT INTO kdlNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Aku Yesu pana le asuvayali, u sawai aꞌeshi a le. Kute‑kute a wenei asu, aku a tono yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","An Yesu n atoni a ne a ka rawa evu n Urishelima, aku a uwai a ilyuci i Betafaji a Masasa ma Zayitum.† Aku u tutsuki ama a re a wala a kapala ka le. ");
INSERT INTO kdlNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","U tonuko le, “Walai i bana a une u ɗa wa̱ri a kapala. I rawa baci ɗe, ya cina ta̱ maku ma makparyagi na̱ mma u ne. I tatsukpa n ɗa i tuko. ");
INSERT INTO kdlNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Uza roku u wece ɗa̱ baci ili iꞌya i zuwai ya tatsukpa n ɗa, i tonuko yi, ‘Asheku a ɗa a ka ciga n ɗa.’ Kute‑kute wa a̱sa̱ka̱ ɗa̱ ta̱ i laza na̱ n ɗa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nala u gita̱ ta̱ tsa̱ra̱ a shaɗangu ili iꞌya Zakariya matsumate u danai: ");
INSERT INTO kdlNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Tonukoi aza a Sihiyona:† ‘Magono ma ɗe ma la ma tuwa̱! Uza u uvakunku kaci ɗa, wa wala̱ka makparyagi. Wa̱ri a utuwa̱ a zuba u maku ma makparyagi.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Aku atoni yi a lazai a ba a yain ili iꞌya Yesu tonuko le a yain. ");
INSERT INTO kdlNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","A tukoi maku ma makparyagi mi na̱ mma u ne dem, aku a poloi aminya a le a zuba u le, u yuwa̱i. ");
INSERT INTO kdlNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ama ushani a polusoi aminya a le a ure, aza roku kpam a koɗusoi avuku a nɗanga a polusoi a ure. ");
INSERT INTO kdlNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Aza roku a walai a kapala ka Yesu, aza roku kpam a tono yi a kucina̱ n a sala̱si, “Hosana, cikpalai Maku ma Dawuda!” “Kashila̱ ka zuwuka yi una̱ u shinga, eyi uza ɗa wa̱ri a utuwa̱ n kala ka Magono ma Zuba!” “Hosana, cikpalai Kashila̱!” ");
INSERT INTO kdlNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","An Yesu uwai a Urishelima, gba̱ ama a shaɗangi n ipeli. A wecikei, “Ya kumbu vuma u na vi?” ");
INSERT INTO kdlNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Aku kakuma̱ ka ama ki ka danai, “Vuma u na vi aya Yesu, matsumate uza u ilyuci i Nazara u uyamba u Galili.” ");
INSERT INTO kdlNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu uwai a asuvu a Kuwa ku Kashila̱, aku u lokoi gba̱ aza ɗa a ka yan pini tsilaga. Aku u kpatalai u wacinsai gba̱ iteburu i ama ɗa a ka savaɗa̱sa icun i ikebe kau‑kau. U wacinsai kpam ikirika i aza ɗa a ka dengishe ntambara. ");
INSERT INTO kdlNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","U tonuko le, “A korongu ta̱ a Tagara̱da u Kashila̱ a da, ‘A ka isa̱ ta̱ kuwa ku va̱ kuwa ku kavasu.’ Shegai i gonukoi ka kaɓuru ka aza a maga̱la̱ka̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Arumba̱ n awunu a tuwa̱i ara ne pini a Kuwa ku Kashila̱ ki, aku u ta̱na̱sa̱ le. ");
INSERT INTO kdlNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Aɗara̱kpi a pige n awenishiki a Mele a wene yi wa̱ri uyansa ili i majiyan, a wenei kpam mmuku ma cikpala̱sa yi pini a Kuwa ku Kashila̱ ki, n a dansi, “Hosana, cikpalai Maku ma Dawuda.” Gba̱ ili i nala yi i zuwai aɗara̱kpi a pige n awenishiki a Mele yi a panai upan cika. ");
INSERT INTO kdlNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Aku a wecei Yesu, “Vu pana gba̱m ili iꞌya mmuku n naha mi ma̱ri udansa?” U wushunku le, “N pana ta̱. Kotsu i taɓa uka̱neshi a Tagara̱da u Kashila̱ wa, a asu u ɗa u danai, ‘Kashila̱, vu wenishike ta̱ mmuku n shawu na̱ mmuku n shili a shipi ishipa i icikpali’?” ");
INSERT INTO kdlNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Aku u lazai u a̱sa̱ka̱i ilyuci yi ubana a Batani, nte u wansai ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","N kpasani ku de an Yesu wa gono a ilyuci, aku kambulu ka ka̱na̱ yi cika. ");
INSERT INTO kdlNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","U wenei maɗanga ma kapopi a ikengi i ure, u banai pini, shegai u cina pini ilimaci wa, she avuku koshi. Pini nala, u tonukoi maɗanga mi, “Va doku va matsa ilimaci kpam wa!” Kute‑kute maɗanga mi ma ekpei. ");
INSERT INTO kdlNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","An atoni a ne a wenei nala, a yain majiyan. A wecikei, “Niɗa maɗanga mi ma ekpei gogo?” ");
INSERT INTO kdlNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","U wushunku le, “Mayun n tonuko ɗa̱, iꞌa̱ baci n upityanangu bawu i yain mala̱la̱, ya fuɗa ta̱ dem ya yan ili iꞌya n yankai maɗanga ma na mi hal gba̱m iꞌya i lai la. Ya fuɗa ta̱ i tonuko masasa ma na, ‘Wala ba vu rukpa̱ a mala.’ Iꞌa̱ baci n upityanangu, nala wa woko. ");
INSERT INTO kdlNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","I wushuku baci, ya tsa̱ra̱ ta̱ gba̱ ili iꞌya i wecikei aꞌayin a ɗa baci i yain kavasu.” ");
INSERT INTO kdlNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu gonoi a Kuwa ku Kashila̱ u gita̱i uwenishike. Aku aɗara̱kpi a pige na̱ nkoshi a tuwa̱i ara ne, a wece yi, “Ucira u eni u ɗa va yansa̱ka ili i na yi? Kpam ya na̱ka̱ vu u ɗa?” ");
INSERT INTO kdlNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","U wushunku le, “Ma̱ ta̱ n keci ku te ka ma ciga n yan ɗa̱. I fuɗa baci i wushuki ka, ma tonuko ɗa̱ ta̱ tyoku ɗa n tsa̱ra̱i ucira u ɗa ma yansa̱ka ili i na yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ya na̱ka̱i Yahaya ucira u ulyuɓugusu?† Kashila̱ ka zuba ka ka na̱ka̱ yi u ɗa, ko gai a asu u ama ɗa u wuta̱i?” Aku a dansai utyoku u le, a danai, “Tsu dana baci, ‘A zuba u ɗa u wuta̱i,’ wa dana ta̱, ‘Ndya i zuwai bawu i wushuki n eyi?’ ");
INSERT INTO kdlNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tsu dana baci, ‘A asu u ama ɗa u wuta̱i,’ tsa pana ta̱ uwonvo u ili iꞌya ama yi a ka yanka tsu, kpaci a bidya ta̱ Yahaya matsumate ma.” ");
INSERT INTO kdlNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Aku a wushunku yi, “Tsu reve wa.” U danai, “Mpa dem ma tonuko ɗa̱ uza ɗa u na̱ka̱ mu ucira u ɗa ma yansa ili i na yi wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesu danai, “Ma yanka ɗa̱ ta̱ alabari a vuma roku uza ɗa wa̱ri na̱ mmuku n re, aku i tonuko mu ili iꞌya i yawunsai. Tata u le u banai ara maku ma ne ma pige, u danai, ‘Wala ba vu yain manyan a kashina ka cinwi ara!’ ");
INSERT INTO kdlNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Maku mi ma wushuki, ‘Ma bana wa.’ Shegai u gonoi u banai. ");
INSERT INTO kdlNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Aku tata u le vi u banai a asu u maku ma ire mi, u tonuko yi, ‘Wala ba vu yain manyan a kashina ka cinwi ara.’ Aku maku mi ma wushuki, ‘Ma bana ta̱,’ shegai u bana wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“A asuvu a mmuku n re n na mi, ya na̱ka̱i tata vi karinga̱?” Aku aɗara̱kpi na̱ nkoshi n pige mi a wushuki, “Maku ma kagita̱ ma.” Yesu tonuko le, “Mayun n tonuko ɗa̱, awushi a utafa n ashankala a ka uwa ta̱ a tsugono tsu Kashila̱ kahu eɗa̱ i uwa. ");
INSERT INTO kdlNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yahaya Kalyuɓugi tuwa̱ ta̱ tsa̱ra̱ u wenike ɗa̱ ure u ɗa ya tsa̱ra̱ uma. Shegai i ꞌyuwain uwushuku n eyi, aku awushi a utafa n ashankala a wushuku ta̱. Ko an i wenei ukuna u na vi, i kpa̱ɗa̱i ukpatala i a̱sa̱ka̱ ure u ɗe kpam i wushuku n eyi wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu danai, “Panai alabari a na yi: A yan ta̱ vuma roku uza ɗa wa̱ri n kashina ka cinwi. U kanzai ka n kasaga, aku u ga̱va̱i kaɗa̱ka̱ ka ukpokuso ilimaci i cinwi yi. U mai kpam kunukuzuba ku uza u uwundya kashina ki. Aku u na̱ka̱i acimbi a roku haya, eyi kpam u lazai nwalu. ");
INSERT INTO kdlNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","An aꞌayin a uta ilimaci yi a yain, aku u suki agbashi a ne a ba a wushika yi kapashi ka ne ka ilimaci yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Shegai acimbi yi a ka̱na̱i agbashi yi. Aku a lapai uza u te, a wunai uza u ire, uza u tatsu kpam a vara̱sa yi n atali hal u kuwa̱i. ");
INSERT INTO kdlNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Aku uza u kashina vi u suki agbashi a roku ushani a ba a wushika yi ilimaci yi. Pini nala, a yanka le dere tyoku ɗa a yankai aza a kagita̱ yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Uza u kashina vi u korusoi u suki maku ma ne ubana a asu u ama vi, kpaci u yawunsa ta̱ ko a ka wene karinga̱ ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Shegai an ama yi a wenei maku mi, a dansai utyoku u le, ‘Maku ma na ma lya ta̱ agadu a kashina yi. Tsu wuna yi baci, ka woko ta̱ ka tsunu!’ ");
INSERT INTO kdlNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Aku a ka̱na̱ yi, a rono yi uwuta̱ a kashina ka cinwi ki a wuna yi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesu wecei aɗara̱kpi a pige n Afarishi yi, “Uza u kashina u nala vi u tuwa̱ baci, ndya i wenei wa yanka ama a nala yi?” ");
INSERT INTO kdlNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Aku a wushuki, “Wa wuna le ta̱, aku u na̱ka̱ aza roku kashina ki, aza ɗa a ka na̱ka̱ yi kapashi ka ilimaci i kashina i ne a aꞌayin a ɗa a gain.” ");
INSERT INTO kdlNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu tonuko le, “Nala wa̱ri, i yan ta̱ ka̱neshi u ukuna u na vi a Tagara̱da u Kashila̱, u ɗa u danai: “ ‘Katali ka aza a kuma a ꞌyuwain, ka ka lakai kalen cika a asu u kuma. Magono ma Zuba ma ma yain ili i na yi, kpam ili i majiyan iꞌya ara tsunu.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“N tonuko ɗa̱ ukuna u mayun, a ka bidya ta̱ tsugono tsu Kashila̱ ara ɗe a na̱ka̱ aza ɗa a ka yan ili iꞌya Kashila̱ ka ciga a tsugono tsu ne. ");
INSERT INTO kdlNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Vuma ɗa u rukpa̱i a katali ka na wa koɗuso ta̱, kpam uza ɗa katali ki ka varai, vuma u nala vi wa yuruwa ta̱ yuku‑yuku.” ");
INSERT INTO kdlNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","An aɗara̱kpi a pige n Afarishi a panai alabari a ɗa u yansa̱ka le, aku a revei an n ele ɗa wa yan. ");
INSERT INTO kdlNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","A ka ciga a ka̱na̱ yi, shegai a ka pana ta̱ uwonvo u ama yi, kpaci ama yi a wushuku ta̱ Yesu matsumate ma. ");
INSERT INTO kdlNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu doki u yain manyan n alabari tsa̱ra̱ u wenishike ama, ");
INSERT INTO kdlNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Tsugono tsu zuba tsa woko ta̱ tyoku u agisani a naha: A yan ta̱ magono ma roku uza ɗa u foɓusukoi maku ma ne abiki a iyolo. ");
INSERT INTO kdlNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","U libanai ama roku a asu u abiki vi. An a ka gita̱ abiki yi, aku u suki agbashi a ne a isa̱ ama yi, shegai a ꞌyuwain utuwa̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Aku u doki u suki agbashi a roku, u danai, ‘Tonukoi ama ɗa n libanai vi a foɓuso ɗe abiki yi. A kiɗa ta̱ anaka a shinga a ɗa n lakai uciga a foɓusoi inyama yi. Tuwa̱i a asu u abiki vi.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Shegai aza ɗa u libanai vi a tuwa̱ wa. Aza roku a lazai ubana a ashina, aza roku kpam ubana a kuden. ");
INSERT INTO kdlNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Aza roku kpam a ka̱na̱i agbashi yi a lapa le, a wunai. ");
INSERT INTO kdlNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Pini nala, u yain upan cika, u suki asoje a wuna aza a maga̱la̱ka̱ yi kpam a runukpa ilyuci i le. ");
INSERT INTO kdlNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Aku magono mi ma tonukoi agbashi yi, ‘A kotso ɗe afoɓi a abiki a iyolo yi. N libana ta̱ ama, shegai a ra̱tsa a tuwa̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Adama a nala, walai a ire i ilyuci yi, uza ɗa baci dem i wenei i libana yi u tuwa̱ a asu u abiki vi.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Pini nala, agbashi yi a lazai a ba a ɓolomgbonoi gba̱ aza ɗa a wenei, aza a shinga n aza a cingi. Aku a asu u abiki vi u shaɗangi n amoci. ");
INSERT INTO kdlNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“An magono mi ma tuwa̱i tsa̱ra̱ u wene amoci yi, aku u wenei vuma roku uza ɗa bawu u ukai aminya a shinga. ");
INSERT INTO kdlNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","U wece yi, ‘Avu, niɗa bawu vu ukai aminya a shinga utuwa̱ a asu u abiki vi?’ Vuma vi u fuɗa u dana ko ili wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“U tonukoi agbashi a roku, ‘Sira niyi akere n aꞌene, i vuta̱la̱ yi a asuvu a karimbi, nte ama a ka sa̱ pini n ulumusa u aꞌanga adama a mɓa̱la̱.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Mayun ɗa, a libana ta̱ ama ushani, shegai kenu ɗa a ɗanga̱sai.” ");
INSERT INTO kdlNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Aku Afarishi a ɓolomgbonoi kaci tsa̱ra̱ a wandi Yesu u dana ili i roku kotsu a tsa̱ra̱ ili iꞌya a ka ka̱na̱ yi n iꞌya. ");
INSERT INTO kdlNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Aku a sukunku yi atoni a le a roku n atoni a Hiridu. A danai, “Kawenishiki, tsu reve ta̱ avu vuma u maci u ɗa, kpam va wenishike ta̱ ili i shinga i ure u Kashila̱. Vu bidya ta̱ ya dem una̱ u te, ko ya tani baci wa̱ri. ");
INSERT INTO kdlNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tonuko tsu uyawunsa u vunu. U gan tsu tsupa utafa ara Kaisa† magono ko tsu kpa̱ɗa̱ utsupa?” ");
INSERT INTO kdlNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","U reve ta̱ uyawunsa u cingi u le, aku u tonuko le, “Eɗa̱ aza a maci a kaɓan! Ndya i zuwai ya ciga i wanda mu? ");
INSERT INTO kdlNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Wenike numu ukebe u azurufa u ɗa i tsu tsupa utafa n iꞌya.” Aku ama yi a wenike yi ukebe vi. ");
INSERT INTO kdlNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","U wece le, “Kulu n kala ka yai ka ka̱ri pini?” ");
INSERT INTO kdlNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Aku ama a wushuki, “Ka Kaisa Magono ka.” U tonuko le, “Na̱ka̱i Kaisa ili iꞌya iꞌa̱ri i ne, Kashila̱ kpam i na̱ka̱ yi ili iꞌya iꞌa̱ri i Kashila̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","An a panai nala, a yain majiyan. Aku a lazai a a̱sa̱ka̱ yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Aza a Sadusi a wushuku an ama a ka ꞌya̱nga̱ a ukpa̱ a kuwa̱ baci wa. Kain ka ka nala ki, aza a Sadusi a roku a tuwa̱i ara Yesu a wece yi, ");
INSERT INTO kdlNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Kawenishiki, Musa dana ta̱, ‘Vuma u kuwa̱ baci bawu mmuku, u ka̱na̱ ta̱ utoku u ne u sotuku uka vi tsa̱ra̱ u matsa̱ka yi mmuku.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","A yan ta̱ ama a roku ama a shindere uza n utoku aza ɗa a rongoi pini na. Uza u kagita̱ u zuwai uka, shegai u kuwa̱i bawu maku, aku uza u ire u sotuki mara̱na̱ mi. ");
INSERT INTO kdlNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Eyi dem u kuwa̱i bawu mmuku, aku uza u tatsu u sotuki dem mara̱na̱ mi. Nala a rongoi uyansa hal u bansa le iyolo gba̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","A makorishi, uka vi dem u kuwa̱i. ");
INSERT INTO kdlNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kashila̱ ka ꞌya̱nga̱sa̱ baci akushe, uka u yai u ɗa wa woko? Kpaci u wolo ta̱ ama a shindere a le gba̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","U wushunku le, “Eɗa̱ i reve wa, kpaci i reve ili iꞌya Tagara̱da u Kashila̱ u danai wa, kpam i reve n ucira u Kashila̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Aꞌayin a ɗa baci akushe a ꞌya̱nga̱i, a ka yan iyolo ko kpam a wutukpa̱ iyolo wa. A ka woko ta̱ tyoku u atsumate a zuba. ");
INSERT INTO kdlNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mayun ɗa i yan ta̱ ka̱neshi u ili iꞌya Kashila̱ ka danai a ukuna u uꞌya̱nga̱ u ukpa̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Kashila̱ ka dana ta̱, ‘Mpa Kashila̱ ka Ibirahi, n Kashila̱ ka Ishaku, n Kashila̱ ka Yakubu.’ Kashila̱ aya Kashila̱ ka aza a uma, shegai ka akushe wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","An kakuma̱ ka ama ka panai nala, aku a yain majiyan ma uwenishike u ne. ");
INSERT INTO kdlNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","An Afarishi a panai a da aza a Sadusi a fuɗa a wushuku wa, aku a ɓolomgbonoi. ");
INSERT INTO kdlNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Uza u te a asuvu a le, kawenishiki ka Mele ka, u ma̱tsa̱i wa ciga u wandi Yesu n keci ku na: ");
INSERT INTO kdlNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Kawenishiki, mele ma eni ma ma lai ugbonguro a asuvu a Mele ma Musa?” ");
INSERT INTO kdlNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","U wushuki, “ ‘Ciga Magono ma Zuba Kashila̱ ka vunu n katakasuvu ka vunu gba̱. Vu cigi yi n uma u vunu n kakiri ka vunu gba̱.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mele ma kagita̱ ma la vi ma kpam ma lai ugbonguro. ");
INSERT INTO kdlNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Mele ma ire dem una̱ u te ɗa ma̱ri: ‘Ciga uza u karen u vunu tyoku ɗa va ciga kaci ka vunu.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","A kaci ka Mele ma re ma na ma uwenishike u Musa n u ntsumate wa̱ri.” ");
INSERT INTO kdlNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Afarishi yi pini a asu u te, aku Yesu wece le, ");
INSERT INTO kdlNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Uyawunsa u eni u ɗa iꞌa̱ri uyan a kaci ka Kawauwi? Maku ma tsikaya ma yai ma?” A wushuki, “Ma Dawuda ma.” ");
INSERT INTO kdlNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Aku u tonuko le, “Niɗa Dawuda isa̱ yi ‘Asheku’? Kulu Keri ku zuwa ta̱ Dawuda danai, ");
INSERT INTO kdlNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“ ‘Magono ma Zuba ma tonuko ta̱ Asheku a va̱: Dusuku a ulyaki u va̱ hal n zuwa atokulalu a vunu a kere ka adeshikpetsu a vunu.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“An u wokoi Dawuda isa̱ yi Asheku, niɗa kpam wa woko maku ma ne?” ");
INSERT INTO kdlNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ko uza u fuɗa u wushunku yi wa, kpam ko uza u wuta̱ karara bawu uwonvo u wece yi keci ku roku wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yesu tonukoi kakuma̱ ka ama ki kaɓolo n atoni a ne, ");
INSERT INTO kdlNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Awenishiki a Mele n Afarishi aꞌa̱ ta̱ n ucira u ɗa a ka tonuko ɗa̱ ili iꞌya Mele ma Musa ma danai. ");
INSERT INTO kdlNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Adama a nala, i toni iꞌya a wenishike ɗa̱, shegai kotsu i yain tyoku ɗa ele a ka yansa wa. Kpaci iꞌya a tsu dansa kau ɗa n iꞌya a tsu yansa. ");
INSERT INTO kdlNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","A tsu taɗanku ta̱ ama ucanga u ara̱ji u ɗa bawu a ka fuɗa a ka canga. Kpam a tsu dambula gba̱m a dana a̱sa̱ka̱ a banka majubu a ɓa̱nga̱ le ucanga wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“A tsu yan ta̱ ili i shinga tsa̱ra̱ ama a wene le. Kpam ya dem u tsu sira ta̱ alawu a ɗa aꞌa̱ri n Kadyanshi ka Kashila̱, shegai alawu a Afarishi a la ta̱ ugbonguro. Ikali iꞌya iꞌa̱ri a ikengi i aminya a le i la ta̱ dem ugbonguro. ");
INSERT INTO kdlNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","A la ta̱ uciga a asu u ndishi u shinga a asu u abiki n asu u ndishi u kapala a agata a Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kpam aꞌa̱ baci a kuden, a tsu la ta̱ uciga ama a dana̱sa le n kala ka karinga̱; wata, ‘Kawenishiki.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Shegai eɗa̱ she i a̱sa̱ka̱ uza u isa̱ ɗa̱ ‘Kawenishiki’ wa, kpaci Kawenishiki ka te ka iꞌa̱ri n ka, kpam atoku a ɗa iꞌa̱ri. ");
INSERT INTO kdlNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kpam kotsu i isa̱ uza n kala ka karinga̱ ‘Tata’ a likimba wa, kpaci Tata u te u ɗa iꞌa̱ri n u ɗa uza ɗa wa̱ri a zuba. ");
INSERT INTO kdlNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kotsu i a̱sa̱ka̱ uza u isa̱ ɗa̱ ‘Uzakuwa’ wa, kpaci Uzakuwa u te ɗa; wata, Kawauwi. ");
INSERT INTO kdlNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Uza ɗa baci wa̱ri uzapige, she u woko kagbashi ka atoku. ");
INSERT INTO kdlNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Uza ɗa baci u bidyai kaci ka ne uzapige, a ka gonuko yi ta̱ kenu. Uza ɗa kpam u bidyai kaci ka ne kenu, a ka gonuko yi ta̱ uzapige. ");
INSERT INTO kdlNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ter ɗe awenishiki a Mele n Afarishi, eɗa̱ aza a maci a kaɓan! Kpaci i ka̱ngi ama utsutsu u uꞌuwa a tsugono tsu zuba. Eɗa̱ i uwa a tsugono tsi wa, i a̱sa̱ka̱ tani aza ɗa a ka ciga uwa a uwa wa.  ");
INSERT INTO kdlNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ter ɗe awenishiki a Mele n Afarishi, eɗa̱ aza a maci a kaɓan! Eɗa̱ aza ɗa i tsu lya ucanga u nra̱na̱ n aꞌuwa a le, i yain kpam kavasu ka ugaɗi tsa̱ra̱ ama a wene ɗa̱. A ka yan ɗa̱ ta̱ mavura cika ma ma lai ma aza ɗa a buwai. ");
INSERT INTO kdlNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ter ɗe awenishiki a Mele n Afarishi, eɗa̱ aza a maci a kaɓan! Kpaci i tsu pasamgbana ta̱ mala i bana a iyamba i mɓa̱ri tsa̱ra̱ i zuwa uza u te u woko katoni. Aꞌayin a ɗa baci i tsa̱ra̱ yi aku i gono i zuwa yi u woko uza u akina hal u la ɗa̱ cika. ");
INSERT INTO kdlNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ter ɗe eɗa̱ aza ɗa ya tono n ama, dana arumba̱ a ɗa iꞌa̱ri! I da, ‘Ama a tsina baci n Kuwa ku Kashila̱ aꞌayin a ɗa a ka ya kazuwamgbani, wa̱ n ukuna wa. Shegai a tsina baci n zinariya u ɗa wa̱ri a Kuwa ku Kashila̱ ki, u ka̱na̱ ta̱ a shamkpa kazuwamgbani ki mai.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","“Eɗa̱ arumba̱ a gbani, atengeshi. Ndya wa̱ ve i lakai kalen: zinariya vi ko gai Kuwa ku Kashila̱ ka ku zuwai zinariya vi wa rongo uwulukpi? ");
INSERT INTO kdlNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kpam i danai, ‘Ama a tsina baci n asuɗara̱kpa, wa̱ n ukuna wa. Shegai a tsina baci n kune ku ka̱ri a asuɗara̱kpa vi, u ka̱na̱ ta̱ a shamkpa kazuwamgbani ki.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","“Icun i urumba̱ u eni u ɗa wa̱ la! Ndya wa̱ ve i lakai kalen: kune ki ko gai a asuɗara̱kpa u ɗa u zuwai kune ki ka̱ri uwulukpi? ");
INSERT INTO kdlNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Adama a nala, uza wa tsina baci n asuɗara̱kpa, tsina ɗa la vi wa tsina n u ɗa n kune ku ka̱ri pini a zuba u ne. ");
INSERT INTO kdlNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nala dem uza wa tsina baci n Kuwa ku Kashila̱, tsina ɗa wa tsina n ka hal n Kashila̱ ka ka rongo pini vi. ");
INSERT INTO kdlNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Uza u tsina baci kpam n zuba, u tsina ta̱ dem n karatsu ka tsugono tsu Kashila̱ n uza ɗa u dusuki pini. ");
INSERT INTO kdlNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ter ɗe awenishiki a Mele n Afarishi, eɗa̱ aza a maci a kaɓan! I tsu na̱ka̱ ta̱ Kashila̱ ili i te a asuvu a kupa a ili iꞌya i tsa̱ra̱i, hal gba̱m n icanga i awanli i kusan iꞌya i lakai kenukulu, n icun i kenukulu gba̱. Shegai i varangi iwenishike i Mele i pige; wata, uyanka ama ili iꞌya iꞌa̱ri dere, n upana iyali, n ushamkpa ukuna u Kashila̱ mai. Iꞌya gai i gain i yain iꞌya la vi kaɓolo n i niɗe yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Eɗa̱ arumba̱ a ɗa ya tono n ama, iꞌa̱ ta̱ tyoku u vuma ɗa u sherei mini ma uso ma ne tsa̱ra̱ u takpa maku ma kagushi, aku u gonoi u soɗugi karakuma! ");
INSERT INTO kdlNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ter ɗe awenishiki a Mele n Afarishi, eɗa̱ aza a maci a kaɓan! I tsu za̱ ta̱ kucina̱ ku nko n ɗe n apara a ɗe, shegai asuvu a le aꞌa̱ ta̱ ushaɗangi n ili iꞌya i tsa̱ra̱i a asu u uryafusa ama n iꞌya ya zuwa ɗa̱ i pana kayanyan koshi. ");
INSERT INTO kdlNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Eɗa̱ Afarishi arumba̱ a ɗa! Gita̱i ve i za̱i asuvu a nko yi n apara yi, kateshe ki kpam ka yan ta̱ sarara! ");
INSERT INTO kdlNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ter ɗe awenishiki a Mele n Afarishi, eɗa̱ aza a maci a kaɓan! Tyoku u asaun a ɗa a kalai pun ɗa iꞌa̱ri. A tsu yan ta̱ n tsulobo a kateshe, shegai asuvu a le aꞌa̱ ta̱ ushaɗangi n atele a akushe n ili iꞌya i shamusai. ");
INSERT INTO kdlNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nala dem iꞌa̱ri, i lobono ta̱ uwundya a kateshe, shegai asuvu a ɗe aꞌa̱ ta̱ ushaɗangi n ikuna i maci i kaɓan n tsicingi. ");
INSERT INTO kdlNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ter ɗe awenishiki a Mele n Afarishi, eɗa̱ aza a maci a kaɓan! I tsu yanka ta̱ ntsumate a asu u kaciɗa̱ ka shinga, kpam i tsu kala ta̱ asaun a aza a maci. ");
INSERT INTO kdlNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","I da, ‘A da baci tsa̱ri tsu rongoi aꞌayin a nkoshi n cau n tsunu, tsa̱ra̱ tsa ɓa̱nga̱ le uwuna ntsumate wa.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","“Adama a nala i varangu ta̱ kaci ka ɗe an i danai eɗa̱ mmuku n tsikaya† ma aza ɗa a wunai ntsumate n ɗa iꞌa̱ri. ");
INSERT INTO kdlNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Lyayi kelime i koruso ili iꞌya nkoshi n cau n ɗe n gita̱i vi! ");
INSERT INTO kdlNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Eɗa̱ aꞌeku na̱ mmuku ma aꞌeku! Niɗa ya yan i dana ya wura a uvarangu ɗa̱ a akina? ");
INSERT INTO kdlNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Adama a nala, ntsumate, arevi n awenishiki a ɗa la ma sukunku ɗa̱. Ya wuna ta̱ aza roku a le, ya vara ta̱ aza roku ikusa a mawandamgbani. Aza roku tani ya bawan le ta̱ a agata a Kashila̱ hal i tono le ubana ilyuci ilyuci n i yanki le mavura. ");
INSERT INTO kdlNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Adama a nala, Kashila̱ ka yanka ɗa̱ ta̱ mavura adama mpasa m aza ɗa i wunai bawu unyushi. Eɗa̱ aza a Yahuda i gita̱ ta̱ i wunai Habila† vuma u maci, aku i lyai kelime n uwunusa ama hal ubana aꞌayin a Zakariya maku ma Barikiya uza ɗa i wunai a mere ma Asu u Uwulukpi u Kuwa ku Kashila̱ n asuɗara̱kpa. ");
INSERT INTO kdlNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mayun n tonuko ɗa̱, ukuna u nala vi wa gita̱ ta̱ dem n aza ɗa iꞌa̱ri n uma gogo‑na.” ");
INSERT INTO kdlNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yesu lyai kapala n kadyanshi, “Eɗa̱ aza a Urishelima! Ama a ɗe a wuna ta̱ ntsumate kpam a vara̱sai atsumate a ɗa a sukunku ɗa̱. N tsu ciga ta̱ n ɓolongu ɗa̱ tyoku ɗa matoku ma tsu ɓolongu mmuku n ne a ashan a ne, aku i ꞌyuwain. ");
INSERT INTO kdlNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nala Kashila̱ ka a̱sa̱ka̱ Kuwa ku Kashila̱ ku ɗe, kpam ka woko ta̱ bawu uza pini. ");
INSERT INTO kdlNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","N tonuko ɗa̱, ya doku ya wene mu wa, she aꞌayin a ɗa ya dana, ‘Kashila̱ ka zuwuka uza ɗa wa tuwa̱ n kala ka Magono ma Zuba una̱ u shinga.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu a̱sa̱ka̱i Kuwa ku Kashila̱ ki u ka̱na̱i ure u lazai, aku atoni a ne a tuwa̱i ara ne a wenike yi kuma ku Kuwa ku Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Shegai u tonuko le, “I wene kuma ku na ki? Mayun n tonuko ɗa̱, ko katali ka te a ka a̱sa̱ka̱ ka a zuba u utoku u ne wa. Katali dem a ka wa̱sa̱ ta̱ ka.” ");
INSERT INTO kdlNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Aꞌa̱ri pini, Yesu ndishi a Masasa ma Zayitum, aku atoni a ne a cina yi utyoku u ne, a danai, “Tonuko tsu, nwere ɗa ukuna u nala vi wa gita̱? Kpam ndya ya woko iryoci iꞌya ya wenike an aꞌayin a utuwa̱ u vunu n ukotso u aꞌayin a ɗa a rawai?” ");
INSERT INTO kdlNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","U tonuko le, “Kiranai kotsu i a̱sa̱ka̱ uza u puwunsa̱ ɗa̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ama ushani a ka tuwa̱ ta̱ n kala ka va̱, a dana alya Kawauwi, kpam a ka puwunsa̱ ta̱ ama ushani. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ya pana ta̱ ukuna u kuvon n alabari a kuvon a ɗa a ka tuwa̱, shegai kotsu i pana uwonvo wa. Gba̱ ili i nala yi i ka̱na̱ ta̱ i gita̱ kahu makorishi ma tuwa̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kaletsu ka ama ka ꞌya̱nga̱sa̱ka̱ ta̱ aletsu, tsugono kpam tsa ꞌya̱nga̱sa̱ka̱ ta̱ tsugono. A ka yan ta̱ aꞌayin a kambulu kuten gba̱m wa. Iyamba ya gba̱ɗa̱ ta̱ a asu kau‑kau. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Gba̱ mɓa̱la̱ ma ili i na yi ma̱ ta̱ tyoku u mɓa̱la̱ ma kagita̱ ka ilimaci i maku. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ama a ka ka̱na̱ ɗa̱ ta̱, a ka neke ɗa̱ ta̱ tsa̱ra̱ a yanka ɗa̱ mavura, kpam a ka wuna ɗa̱ ta̱. Gba̱ ama a ka kovo ɗa̱ ta̱ an u wokoi i wushuki na̱ mpa. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kpam ama ushani a ka a̱sa̱ka̱ mu ta̱ utono. A ka kpatala̱ka ta̱ atoku a le kpam a ꞌyuwan atoku a le. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ntsumate n kaɓan ma tuwa̱ ta̱ ushani n la̱pa̱na̱sa̱ ama ushani. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tsicingi tsa tambura ta̱ tsu zuwa ama a ꞌyuwan uciga atoku a le. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Shegai aza ɗa a kawunki hal ubana a makorishi, Kashila̱ ka wauwa le ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Aꞌayin a ɗa baci Kadyanshi ka Shinga ka kyawain gba̱ likimba n iyamba, a tonusukoi kpam gba̱ aletsu, aku makorishi ma tuwa̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Aꞌayin a ka tuwa̱ ta̱ a ɗa ya wene ili iꞌya Daniyan matsumate u danai: ‘Ili i icaɗi iꞌya bawu i gain iꞌya i nangasai Asu u Uwulukpi u Kuwa ku Kashila̱.’ (Eɗa̱ aza ɗa ya yan ka̱neshi i reve ta̱ kalen ka ili i na yi.) ");
INSERT INTO kdlNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","A aꞌayin a nala yi, u ka̱na̱ ta̱ aza a Yahuda a suma ubana a nsasa tsa̱ra̱ a lai. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Uza ɗa wa̱ri a uwotsu u kuwa, kotsu u uwa a asuvu upura̱ ucanga wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Uza ɗa wa̱ri a kashina, kotsu u gono a kuwa uzama u kunya wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","A aꞌayin a nala yi, ter ɗe aka a ɗa aꞌa̱ri n atsuma̱, ko kpam aza ɗa aꞌa̱ri na̱ mmuku n shili! ");
INSERT INTO kdlNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","“Yanyi kavasu a asu u Kashila̱, kotsu i suma n ilyushi ko tani a kain ka Ashibi wa! ");
INSERT INTO kdlNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nala wa woko ta̱ aꞌayin a upana u ikyamba u pige. Tun an a yain likimba, kpam a ka doku a ka yan upana u ikyamba tyoku u nala wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Shegai Kashila̱ ka jebe ɗe kakuma̱ ka aꞌayin ki; a da baci wa̱ri u yain nala wa, uza wa̱ la wa yan uma wa. Shegai Kashila̱ ka jebe ɗe aꞌayin yi adama ama a ne a ɗa u ɗanga̱sai. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","A aꞌayin a nala yi, uza roku wa tonuko ɗa̱ ta̱, ‘Wundyai, Kawauwi ka la!’ Ko kpam uza roku wa dana ta̱, ‘Aya na!’ Kotsu i tono le wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Awauwi a kaɓan na̱ ntsumate n kaɓan a ka tuwa̱ ta̱ a yain iryoci kpam n ikunesavu. A ka zuwa ta̱ ama a tono le, hal gba̱m n ama ɗa Kashila̱ ka ɗanga̱sai, hal gai wa yan baci nala. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Panai, n rono ɗa̱ ta̱ atsuvu ga̱mpa̱ kahu ukuna vi u gita̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Uza roku u tonuko ɗa̱ baci, ‘Wundyai, Kawauwi ka niɗe a kakamba,’ kotsu i bana i kondo wa. Ko kpam, ‘Wundyai, aya la ukpawin,’ kotsu i wushuku wa! ");
INSERT INTO kdlNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Maku ma Vuma ma tuwa̱ baci, ya dem wa wene yi ta̱, tyoku ɗa ulaɗa u tsu wuta̱ a kasana ubana a kalivi. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Asu u ɗa baci kakushe ka̱ri, nte asakali a tsu ɓolomgbono pini. Ili i na iryoci iꞌya ya wenike an makorishi ma yan ɗe evu iꞌya.” ");
INSERT INTO kdlNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Aꞌayin a ɗa baci upana u ikyamba u nala u kotsoi, kute‑kute “ ‘Kaara ka kimba̱ ta̱, kpam uwoto wa doku wa na̱ka̱ katyashi wa. Atala a ka rukpusa̱ ta̱, a ka gba̱ɗa̱ ta̱ kpam ili i pige i pige iꞌya iꞌa̱ri u zuba.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“A aꞌayin a nala yi, iryoci i Maku ma Vuma ya wuta̱ ta̱ a kalishi. Gba̱ ama a likimba a ka sa̱ ta̱ adama a uwonvo. A ka wene ta̱ Maku ma Vuma utuwa̱ a zuba a asuvu a kalishi n ucira u pige n tsupige. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Wa tutsuku ta̱ atsumate a zuba a ne a kapala n mawura̱ ma pige ma ukakaci, a ka ɓolomgbono ta̱ aza ɗa u ɗanga̱sai ili iꞌya i ka̱na̱i a kasana ubana a kalivi n gaɗi ubana a ɗaka; wata, ili iꞌya i bidyai a mɓa̱ri n likimba n naha ubana a n niɗe. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Gogo‑na rotsongusi a iryoci i maɗanga ma kapopi: Aꞌayin a ɗa baci i wenei atyangi a ne a lima̱na̱i, aku a ka topo avuku, ya reve ta̱ an ilyushi i yain evu. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","I wene baci gba̱ ili i na yi ya gita̱sa̱, kotsu i reve an aꞌayin a yan ɗe evu n utuwa̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","N tonuko ɗa̱, gba̱ ili i na yi ya gita̱ ta̱ kahu ama ɗa aꞌa̱ri n uma gogo‑na a kuwusa̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Zuba n likimba wa cimba̱ ta̱, shegai kadyanshi ka va̱ ka yan ta̱ pini bawu utyoku. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Uza wa̱ la u revei kain ka nala ki ko kpam ulapa u uwule vi wa. Ko atsumate a zuba, hal dem n Maku mi dem u reve wa, she Tata vi utyoku u ne. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Aꞌayin a ɗa baci Maku ma Vuma ma gono, ili gba̱ ya woko ta̱ tyoku ɗa iꞌa̱ri a aꞌayin a Nuhu.† ");
INSERT INTO kdlNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Aꞌayin a nala yi kahu mini ma pige ma tuwa̱, ama a rongo ta̱ ulya n a soyi kpam n a yansi iyolo hal ubana kain ka Nuhu uwai a kpatsu. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","A ꞌya̱nga̱ ureve ili iꞌya ya gita̱ wa, she na mini ma pige ma tuwa̱i ma wunai ama gba̱. Nala wa woko aꞌayin a ɗa Maku ma Vuma ma gono. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Aꞌali ama a re a ka yan manyan a kashina. A ka bidya ta̱ uza u te, a a̱sa̱ka̱ uza u te. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Aka ama a re a ka wurya kira a kutali. A ka bidya ta̱ uza u te, aku a a̱sa̱ka̱ uza u te. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Adama a nala, she i rongo ufoɓusi, kpaci i reve aꞌayin a ɗa Asheku a ɗe a ka tuwa̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","A da baci uza u kuwa u revei aꞌayin a ɗa kaboki ka tuwa̱, wa̱ri wa rongo ta̱ ufoɓusi, wa a̱sa̱ka̱ kaboki ki ka uwa yi a kuwa wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Eɗa̱ dem u ka̱na̱ ta̱ i rongo ufoɓusi kain dem. Kpaci Maku ma Vuma ma gono ta̱ aꞌayin a ɗa bawu i zuwai uma. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Kagbashi ka eni ka a wushuki n eyi kpam ka̱ri n ugboji? Aya uza ɗa uzakuwa u ne u zuwa yi u woko uzapige u agbashi a ne u na̱ka̱sa̱ le ilikulya aꞌayin dem. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Uzakuwa u ne u gono baci u cina yi u yain manyan ma maci, wa tsa̱ra̱ ta̱ katsupi ka pige ka malen ma manyan ma ne. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mayun n tonuko ɗa̱, uzakuwa u nala vi wa zuwa yi ta̱ u kirana n utsa̱ri u ne gba̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Shegai kagbashi ka cingi ka baci, wa tonuko ta̱ kaci ka ne uzakuwa u va̱ wa gono gogo wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Aku u gita̱ ulapusa atoku a ne agbashi, n u lyayi n u soyi hal u gutukpa kaɓolo n atoku a ne asoi. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Uzakuwa vi wa tuwa̱ ta̱ a aꞌayin a ɗa bawu u zuwai uma wa tuwa̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Aku uzakuwa vi u ta̱sa̱sa̱ yi ikyamba n kaburu, u wutukpa̱ yi kaɓolo n aza a maci a kaɓan, nte ama a ka sa̱ pini n ulumusa u aꞌanga adama a upana u ikyamba.” ");
INSERT INTO kdlNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesu lai kapala n kadyanshi, u da, “Tsugono tsu zuba tsa woko ta̱ tyoku u agisani a naha: A yan ta̱ nkere n roku ama kupa aza ɗa a bidyai ncikalu n le tsa̱ra̱ a bana a ka̱ngu valisavu. ");
INSERT INTO kdlNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ama a tawun a asuvu a le atengeshi a ɗa, shegai ama a tawun a ɗa a buwai vi aꞌa̱ ta̱ n ugboji. ");
INSERT INTO kdlNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Aza ɗa aꞌa̱ri atengeshi yi a bidyai ncikalu n le, shegai a ɓa̱na̱ manivi ma roku wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Aza ɗa kpam aꞌa̱ri n ugboji vi a bidyai ncikalu n manivi a adele a le. ");
INSERT INTO kdlNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","An valisavu vi u ɓa̱ra̱kpa̱i bawu u rawai go, aku a gita̱i agbaɗigi hal a lavutai. ");
INSERT INTO kdlNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“N kayin ka pige, aku a panai isali, ‘Valisavu u ɗa la utuwa̱! Tuwa̱i tsu ka̱ngu yi!’ ");
INSERT INTO kdlNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Nkere mi gba̱ a ꞌya̱nga̱i a foɓusoi ncikalu n le. ");
INSERT INTO kdlNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Aku aza ɗa aꞌa̱ri atengeshi yi a tonukoi aza a ugboji yi, ‘Ne tsu manivi ma ɗe kenu, kpaci ncikalu n tsunu ma cimba̱ ɗe.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Shegai a wushunku le, ‘Tsa̱ra̱ n ma ma rawa tsu gba̱ tsunu wa. Walai i bana a asu u aza ɗa a ka dengishe i tsila̱ka kaci ka ɗe.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Aꞌayin a ɗa nkere n tawun mi a lazai a ba a tsila manivi mi, aku valisavu vi u rawai. Nkere n ɗa ma̱ri ufoɓusi vi a uwai a asu u abiki a iyolo yi kaɓolo n valisavu vi. Aku a gida̱ki utsutsu. ");
INSERT INTO kdlNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Aꞌa̱ri pini, aku nkere n niɗe mi n rawai, n salai, ‘Uzakuwa! Uzakuwa! Kukpunka̱ tsu utsutsu!’ ");
INSERT INTO kdlNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Shegai valisavu vi u wushuki, ‘Mayun n tonuko ɗa̱, n reve ɗa̱ wa.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Aku u danai, “Rongoi ufoɓusi, kpaci i reve kain ko kpam aꞌayin a ɗa ukuna u na vi wa gita̱ wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Aku Yesu tonuko le agisani a na yi, u da, “Tsugono tsu zuba tsa woko ta̱ tyoku u agisani a naha: Vuma roku u ɗa pini uza ɗa u foɓusoi nwalu ubana a ilyuci i roku. Kahu u laza, aku u isa̱i agbashi a ne u tonuko le, ‘Kotsu i guɓuka mu ucanga u va̱, n laza baci.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Vuma vi u reve ta̱ ili iꞌya kagbashi dem ka yan. Aku u na̱ka̱i uza u kagita̱ ikebe i zinariya i pige i pige i tawun, uza u ire kpam u na̱ka̱ yi i re, uza u tatsu kpam u na̱ka̱ yi i te. Aku u ꞌya̱nga̱i u lazai. ");
INSERT INTO kdlNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","An vuma vi u lazai, kagbashi ka u na̱ka̱i ikebe i tawun yi u yain tsilaga n iꞌya, u tsa̱ra̱i i tawun i roku. ");
INSERT INTO kdlNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Uza ɗa kpam u na̱ka̱i i re yi u yain nala, eyi dem u tsa̱ra̱i i re i roku. ");
INSERT INTO kdlNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Shegai kagbashi ka u na̱ka̱i ukebe u te vi, u ga̱va̱i kpele u sokongi u ɗa pini. ");
INSERT INTO kdlNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“An a ɓa̱ra̱kpa̱i, aku uzakuwa vi u gonoi, u wecei agbashi yi ili iꞌya ya dem yankai ikebe yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kagbashi ka u na̱ka̱i ikebe i tawun yi u tukoi i ne n iꞌya u tsa̱ra̱i vi dem. U danai, ‘Uzakuwa, vu na̱ka̱ mu ta̱ ikebe i zinariya i pige i pige i tawun, kpam n doku ta̱ n tsa̱ra̱i ikebe i tawun n iꞌya.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Uzakuwa vi u wushuki, ‘Vu yan ta̱ mai. Avu kagbashi ka shinga ka, uza ɗa n wushuki n avu. Adama a ɗa vu yain naha n ili i kenu i va̱, ma a̱sa̱ka̱ vu ta̱ vu kirana n ili i pige. Tuwa̱ vu pana kayanyan na̱ mpa.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Aku kagbashi ka u na̱ka̱i i re yi u tuwa̱i u danai, ‘Uzakuwa, vu na̱ka̱ mu ta̱ ikebe i zinariya i pige i pige i re, kpam n doku ta̱ n tsa̱ra̱i i re n iꞌya.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Uzakuwa vi u wushuki, ‘Vu yan ta̱ mai. Avu kagbashi ka shinga ka, uza ɗa n wushuki n avu. Adama a ɗa vu yain naha n ili i kenu i va̱, ma a̱sa̱ka̱ vu ta̱ vu kirana n ili i pige. Tuwa̱ vu pana kayanyan na̱ mpa.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Kagbashi ka u na̱ka̱i u te vi u tuwa̱i, u danai, ‘Uzakuwa, n reve ta̱ va̱ yuwu wa. Vu tsu zuwa ta̱ uma vu kapi ili iꞌya vuma roku u cei. ");
INSERT INTO kdlNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Adama a nala, n pana ta̱ uwonvo aku n bidyai ukebe u zinariya vi n ga̱va̱i kpele n sokongi u ɗa pini. Ukebe u vunu u ɗa na.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Aku uzakuwa vi u wushuki, ‘Avu kagbashi ka cingi ka, kpam kawonvoli. Vu da vu reve ta̱ n tsu kapa a kashina ka uza roku u cei. ");
INSERT INTO kdlNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Wa̱ri u gan ta̱ gba̱m vu zuwa ikebe yi a kuwa ku ikebe tsa̱ra̱ n tsa̱ra̱ ili iꞌya i uwa mu pini.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Aku uzakuwa vi u tonukoi agbashi a ɗa a buwai vi, ‘Wusha niyi ukebe vi i na̱ka̱ kagbashi ka ka̱ri n ikebe kupa vi. ");
INSERT INTO kdlNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Uza u yan baci ili i maci n iꞌya wa̱ri n iꞌya, Kashila̱ ka doku ta̱ ka na̱ka̱ yi, kpam wa tsa̱ra̱ ta̱ iꞌya ushani. Shegai uza ɗa bawu wa̱ri n ili, Kashila̱ ka wusha ta̱ i kenukulu iꞌya wa̱ri n iꞌya vi. ");
INSERT INTO kdlNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Gogo‑na vuta̱la̱i kagbashi ka gbani ka nala ki a asuvu a karimbi a asu u ɗa ama a ka sa̱ n ulumusa u aꞌanga adama a upana u ikyamba.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yesu lyai kapala n uwenishike, “Maku ma Vuma ma tuwa̱ ta̱ a asuvu a tsupige tsu ucira tsu ne, n atsumate a zuba a ne gba̱. Wa woko ta̱ Magono aku u dusuku a karatsu ka pige ka tsugono tsu ne. ");
INSERT INTO kdlNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Gba̱ aletsu a likimba a ka ɓolomgbono ta̱ a kapala ka ne, kpam wa pece le ta̱ aɓolo a re tyoku ɗa kaliniki ka tsu pece ncon na̱ nryaɗiga. ");
INSERT INTO kdlNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","U zuwa ncon a ulyaki u ne, nryaɗiga kpam a ugula̱ u ne. ");
INSERT INTO kdlNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Aku magono mi ma tonuko ama ɗa aꞌa̱ri a ulyaki u ne, ‘Tuwa̱i, Tata u va̱ u zuwuka ɗa̱ ɗe una̱ u shinga u ne. Wushai tsugono tsa Kashila̱ ka foɓusuko ɗa̱ tun aꞌayin a ɗa u yain likimba. ");
INSERT INTO kdlNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Aꞌayin a ɗa ma pana kambulu, i ne mu ta̱ ilikulya n lyai. An ma pana kakuli, i ne mu ta̱ mini n soi. An ma yan tsumoci, i wusha mu ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","An ma̱ri kataɓa, i na̱ka̱ mu ta̱ aminya n ukai. An ma̱ri a maɓa̱la̱, i kirana ta̱ na̱ mpa, kpam an ma̱ri a kuwa ka aꞌali, i konduso mu ta̱.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ama a maci yi a ka wushuku ta̱, ‘Asheku, nwere ɗa tsu wene vu n kambulu, aku tsu ne vu ilikulya? Ko kpam va pana kakuli, aku tsu ne vu mini? ");
INSERT INTO kdlNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nwere ɗa tsu wene vu a tsumoci, aku tsu uka vu a aꞌuwa a tsunu? Nwere ɗa tsu wene vu kataɓa, aku tsu na̱ka̱ vu aminya? ");
INSERT INTO kdlNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nwere ɗa tsu wene vu a maɓa̱la̱ ko kpam a kuwa ka aꞌali, aku tsu kiranai n avu?’ ");
INSERT INTO kdlNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Magono mi ma wushuku ta̱, ‘N tonuko ɗa̱, aꞌayin a ɗa baci i yankai ama a va̱, ko aza ɗa a lakai kenukulu, mpa i yankai.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Aku Magono mi ma tonuko aza ɗa aꞌa̱ri a ugula̱ u ne, ‘Ba̱tsa̱i dan na̱ mpa, eɗa̱ ama ɗa Kashila̱ ka yankai una̱ u cingi. Walai i ba i uwa a akina a ɗa bawu a ka kotso a ɗa a foɓusukoi Kala̱pa̱nsi n atsumate a ne! ");
INSERT INTO kdlNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","An ma pana kambulu, i ne mu ilikulya n lyai wa. An ma pana kakuli, i ne mu mini n soi wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","An ma yan tsumoci, i wusha mu wa. Kpam an ma̱ri kataɓa, i na̱ka̱ mu aminya n uka wa. An ma̱ri a maɓa̱la̱, kpam ma̱ri a kuwa ku aꞌali, i kirana na̱ mpa wa.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ama a nala yi a ka wushuku ta̱, ‘Asheku, nwere ɗa tsu kpa̱ɗa̱ vu uɓa̱nga̱ aꞌayin a ɗa va pana kambulu, ko kakuli, ko va yan tsumoci, ko va̱ri kataɓa, ko kpam va̱ri a kuwa ku aꞌali bawu tsu ɓa̱nga̱ vu?’ ");
INSERT INTO kdlNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Magono mi ma wushuku ta̱, ‘N tonuko ɗa̱, aꞌayin a ɗa baci i kpa̱ɗa̱i uɓa̱nga̱ ama a va̱, ko niɗa tani baci aꞌa̱ri kenukulu, mpa i kpa̱ɗa̱i uɓa̱nga̱.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Ama a nala yi a ka uwa ta̱ a asuvu a mavura ma bawu ma̱ri n utyoku, shegai ama a maci yi a ka yan ta̱ uma bawu utyoku.” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","An Yesu kotsoi udansa ili i na yi, aku u tonukoi atoni a ne, ");
INSERT INTO kdlNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“I reve ta̱ gai aꞌayin a re a ɗa a buwai kotsu a yain Abiki a Upasamgbana,† kpam a ka neke ta̱ mpa Maku ma Vuma a wandamgbana mu.” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Aꞌayin a nala yi, aɗara̱kpi a pige na̱ nkoshi a ba a gawunsai a kuwa ku Magono ma Aɗara̱kpi, uza ɗa a ka isa̱ Kayafa. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","A sheshei tyoku ɗa a ka ka̱na̱ Yesu tsa̱ra̱ a wuna yi usokongi. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Shegai a danai, “U gan tsu yain ukuna u na vi aꞌayin a Abiki a na wa, kawa ama a ka ꞌya̱nga̱sa̱ka̱ tsu ta̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ele n a foɓusi nala, cina Yesu pini a Batani a kuwa ku Simo uza ɗa caupa wa̱ri makutu. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Eyi pini a kuwa ki n u lyayi ilikulya, aku uka roku u tuwa̱i n majuju ushaɗangi n manivi ma magula̱ni ma ikebe cika. U tsunki Yesu a kaci. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","An atoni a ne a wenei nala, a panai upan cika, a danai, “Icun i koli ka ikebe ka eni ka naha! ");
INSERT INTO kdlNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Wa̱ri u gan ta̱ u denge ma n ikebe cika, aku u na̱ka̱ aza a unambi ikebe yi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu kpam reve ta̱ gba̱ iꞌya a ka tono, aku u tonuko le, “Ndya i zuwai ya damgbara̱sa uka u na vi? Ili i shinga n i tsulobo iꞌya u yanka mu. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ya rongo ta̱ kaɓolo n aza a unambi kain dem, shegai mpa ma rongo n a̱ɗa̱ aꞌayin ushani wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tsunku ɗa u tsunku mu ma, tsa̱ra̱ u foɓuso ikyamba i va̱ adama a kaciɗa̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mayun n tonuko ɗa̱, asu u ɗa baci dem a yain Kadyanshi ka Shinga a asuvu a likimba, a ka dana ta̱ ili iꞌya uka u na vi u yain, kpam ama a ka ciɓa ta̱ n eyi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Aku uza u te a asuvu a Kupanamere yi, uza ɗa a ka isa̱ Yahuza Isikariyoti u ba u dansai n aɗara̱kpi a pige, ");
INSERT INTO kdlNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“Ndya ya na̱ka̱ mu n na̱ka̱ ɗa̱ baci Yesu?” Aku a na̱ka̱ yi ikebe i azurufa kamankupa. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Pini nala, u gita̱i uzama tyoku ɗa wa neke yi ara le. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kain ka kagita̱ ka Abiki a Ilikulya iꞌya i Nambai Yisti, Kupanamere yi a tuwa̱i ara Yesu a wece yi, “Nte va ciga tsu ba tsu foɓuso ulya u Ilikulya i Abiki a Upasamgbana?” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","U wushuki, “Walai i bana a asuvu a ilyuci a asu u vuma roku i tonuko yi, ‘Kawenishiki ka danai: Aꞌayin a ɗa a ɗanga̱sa̱ka mu a yan ɗe evu n urawa. Ma ciga ta̱ n lyai ilikulya yi n Kupanamere a kuwa ku vunu.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Aku a yain dere tyoku ɗa u tonuko le, a ba a foɓusoi ilikulya yi pini. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","An kaara ka kotsoi, Yesu n Kupanamere yi a dusuki ulya u ilikulya. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ele pini n a lyayi, aku u tonuko le, “Mayun n tonuko ɗa̱, uza u te a asuvu a ɗe wa neke mu ta̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","A namgba ta̱ katsuma̱ cika, aku a gita̱ yi keci maten‑maten, “Mpa ma neke vu vi, Asheku?” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","U wushuki, “Vuma ɗa u daɓai kusan una̱ u te na̱ mpa a kabelu, aya gai wa neke mu vi. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","U ka̱na̱ ta̱ Mpa Maku ma Vuma n kuwa̱, tyoku ɗa a korongi a kaci ka va̱ aꞌayin ushani a ɗa a wurai. Shegai ter n uza ɗa wa neke mu vi. Aꞌa̱ri a matsa yi baci wa, wa̱ri wa laka yi ta̱ tsulobo.” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yahuza uza ɗa wa neke yi vi u danai, “Kawenishiki, ko mpa ma neke vu vi?” U wushunku yi, “Nala wa̱ri, aɗa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ele pini n a lyayi ilikulya yi, aku Yesu bidyai burodi. U cikpai Kashila̱ aku u jiba̱mgba̱na̱sa̱i u ɗa, u na̱ka̱i atoni a ne u danai, “Wushai burodi na vi i takuma, kpaci ikyamba i va̱ iꞌya.” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Aku u bidyai kpam mako, u cikpai Kashila̱ u na̱ka̱i atoni a ne, u danai, “Ya dem u soi. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kpaci mpasa n va̱ n ɗa, iryoci i kazuwamgbani ka Kashila̱ ka yain n ama a ne, n ɗa a wotsongi adama a ɗa Kashila̱ ka cimbusa̱ unyushi u le. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","N tonuko ɗa̱, ma doku ma so mini ma cinwi wa, she kain ka ma doku ma so ma savu n a̱ɗa̱ a tsugono tsu Tata u va̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Aku a shipai ushipa u icikpali, pini nala, a lazai ubana a Masasa ma Zayitum. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yesu tonukoi atoni a ne, “Ara n kayin ka na gba̱ ɗe ya suma ta̱ i a̱sa̱ka̱ mu utyoku u va̱, tyoku ɗa Zakariya matsumate u korongi, ‘Kashila̱ ka ga̱la̱ ta̱ kaliniki ki, ncon mi kpam ma wacuwa ta̱.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","“Shegai aꞌayin a ɗa baci n ꞌya̱nga̱ a ukpa̱, ma laza ta̱ ubana a Galili n lasa ɗa̱ urawa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Bituru danai, “Ko ama gba̱ a ꞌyuwan vu baci, mpa ma ꞌyuwan vu wa!” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","U tonuko yi, “Mayun n tonuko vu, ara gba̱m kahu kapen ka sala, va nana mu ta̱ vu dana vu reve mu wa hal kutatsu.” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Shegai Bituru danai, “Ma nana vu wa! Ma kuwa̱ ta̱ gba̱m kaɓolo n avu!” Nala dem atoni a ɗa a buwai vi a danai. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesu n atoni a ne a banai a asu u roku u ɗa a ka isa̱ Getisimani, u tonuko le, “Dusuki pini na, ma bana ta̱ niɗe n yain kavasu.” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","U bidyai Bituru na̱ mmuku n Zabidi n re a banai kaɓolo. U namgba ta̱ katsuma̱ kpam u dambula ta̱ cika. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","U tonuko le, “Uma u va̱ wa pana ta̱ ikyamba cika yavu ma kuwa̱. Shamgbai pini na i rongo uma na̱ mpa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","U lazai ubana a kapala kenu, aku u kuɗa̱ngi u varai kaci ka ne a iyamba u vasai, “Tata u va̱, wa̱ri wa yan baci, takpa mu mako ma upana u ikyamba ma na mi. Shegai u la ta̱ tsulobo vu yain ili iꞌya va ciga, shegai bamu n iꞌya mpa ma ciga.” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Aku u gonoi a asu u atoni a tatsu yi u cina le a ka lavuta. U tonukoi Bituru, “Ndya i zuwai ama a tatsu a ɗe gba̱ bawu i fuɗai i rongoi uma a uwundya ko u ulapa uwule u te ɗa baci? ");
INSERT INTO kdlNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kotsu i lavuta wa, yanyi kavasu kotsu i tsa̱ra̱ ucira u ɗa ya shamgba a ukonduso. Kulu ku ciga ta̱ ku yain ili iꞌya i gain, shegai ikyamba iꞌa̱ n ucira wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Aku u a̱sa̱ka̱ le u vasai, “Tata u va̱! Va takpa mu baci mako ma na mi wa, she aꞌayin a ɗa n soi ma, ma yan ta̱ ili iꞌya va ciga.” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","U gonoi u cina le a ka lavuta, a kukpa̱ gba̱m aꞌeshi a le wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Aku Yesu a̱sa̱ka̱ le uꞌa̱sa̱ka̱ utatsu, u ba u yain kavasu tyoku u kavasu ka kagita̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","U gonoi a asu u atoni yi u tonuko le, “Niɗa iꞌa̱ri alavu n i wunvugusi hal n gogo‑na? Aꞌayin a yan ɗe gogo‑na. Mpa Maku ma Vuma ma a ka neke a akere a aza a unyushi u cingi. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ꞌYa̱nga̱i tsu walai. Kondonoi, vuma ɗa u neke mu vi, aya wa tuwa̱ la.” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu pini a kadyanshi, aku Yahuza, uza u te a asuvu a Kupanamere yi, u rawai kaɓolo n kakuma̱ ka ama n iburundu na̱ mkpa̱ukpa̱u. Aɗara̱kpi a pige na̱ nkoshi alya a suki ama a na yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yahuza tonuko le ta̱ kahu a tuwa̱, “Ya reve ta̱ vuma vi aꞌayin a ɗa baci n ba n dana̱sa yi n uwambatsa, i ka̱na̱ yi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","An a rawai, aku Yahuza banai karara she ara Yesu, u dana̱sa yi, u danai, “Uzapige!” Pini nala, u wambatsa yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu wushunku yi, “Kaje ka va̱, yan ili iꞌya vu tuwa̱i uyan.” Aku ama yi a tuwa̱i a ka̱na̱i Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Uza u te a asuvu a atoni a Yesu u talai burundu, u kapamgbanai kutsuvu ku kagbashi ka Magono ma Aɗara̱kpi. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Shegai Yesu tonuko yi, “Gonuko burundu u vunu a ivin i ne. Uza ɗa baci dem u shila̱ka̱na̱i n burundu, n burundu ɗa dem a ka wuna yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mayun i reve ta̱ gai ma fuɗa ma wece Tata u va̱, u na̱ka̱ mu aɓolo a atsumate a zuba kupa n a re a ɗa a ka yanka mu kuvon ma ciga baci. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Shegai u ka̱na̱ ta̱ u woko naha, tsa̱ra̱ a shaɗangu ili iꞌya iꞌa̱ri ukorongi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","U tonukoi kakuma̱ ka ama ki, “I tuwa̱ mu uka̱na̱ n iburundu na̱ mkpa̱ukpa̱u yavu uza u maga̱la̱ka̱ ɗa ma̱ri! Kain dem n tsu dusuku ta̱ a Kuwa ku Kashila̱ uwenishike, kpam i ka̱na̱ mu wa. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Shegai gba̱ ili i na yi i gita̱ ta̱, tsa̱ra̱ ikorongi i ntsumate i shaɗangu.” Aku atoni a ne gba̱ a sumai a a̱sa̱ka̱ yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Aza ɗa a ka̱na̱i Yesu vi a banka yi a kuwa ku Kayafa Magono ma Aɗara̱kpi, a asu u ɗa awenishiki a Mele na̱ nkoshi a ɓolomgbonoi. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Bituru tono le a kucina̱ a mɓa̱ri she pini a kuwa ku Magono ma Aɗara̱kpi mi. Aku u dusuki evu n awundi a kuwa yi tsa̱ra̱ u wene ili iꞌya a ka yan n Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Aɗara̱kpi a pige yi n Asheshi a Pige† a ɗa a buwai vi gba̱ a ka ciga a wuna Yesu. Aku a zamai ama roku aza ɗa a ka dansa kadyanshi ka kaɓan a kaci ka ne pini a kuwa ku asheshi ki. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ama ushani a tuwa̱i a dansai kadyanshi ka kaɓan a kaci ka ne, shegai Asheshi a Pige yi a tsa̱ra̱ yi n unyushi u ɗa u rawai a wuna yi wa. Aku ama a re a tuwa̱i a danai, ");
INSERT INTO kdlNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Vuma u na vi dana ta̱ ‘Ma wa̱sa̱ ta̱ Kuwa ku Kashila̱ aku n gono n mai kpam ka a asuvu a aꞌayin a tatsu.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Magono ma Aɗara̱kpi mi ma ꞌya̱nga̱i u tonukoi Yesu, “Va̱ n ili iꞌya va dana a ukuna u na vi? ");
INSERT INTO kdlNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Shegai u dana ko ili wa. Aku Magono ma Aɗara̱kpi mi ma doku ma tonuko yi, “A asuvu a kala ka Kashila̱ Uza u Uma n zuwa ta̱ vu tsina: Tonuko tsu ko aɗa Kawauwi, Maku ma Kashila̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu wushunku yi, “Nala wa̱ri tyoku ɗa vu danai vi. Shegai n tonuko ɗa̱ gba̱ ɗe: ili iꞌya i bidyai gogo‑na ubana, ya wene ta̱ Maku ma Vuma ndishi a ulyaki u Kashila̱ Uza u Ucira Gba̱ utuwa̱ a asuvu a kalishi a zuba!” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","An Magono ma Aɗara̱kpi ma panai nala, aku u karamgbanai aminya a ne adama a unamgbi u asuvu, u danai, “Vuma u na u yanka ta̱ Kashila̱ kadyanshi ka cingi! Tsa ciga kpam aza ɗa a ka dana ukuna u roku a kaci ka ne wa: eɗa̱ dem i pana ta̱ ili iꞌya u danai. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ndya i wenei a ka yan n eyi?” Aku a wushuki, “U yan ta̱ ili iꞌya i ra̱tsai a wuna yi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Aku a cikpunka̱ yi ata̱tsa̱ a upetiwaꞌeshi, a sugbusa yi. Aza roku kpam a ɓasa̱sa yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","A danai, “Tonuko tsu ili iꞌya ya gita̱, cinda a ɗa Kawauwi! Ya sugba vu?” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Aꞌayin a nala yi, Bituru pini ndishi a kuwa ki a ulanga, aku kagbashi ka ka̱ri makere ka tuwa̱i ka danai, “Avu dem va̱ ta̱ kaɓolo n Yesu uza u Galili.” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pini a kapala ka ama, Bituru danai, “Nala wa! N reve gba̱m ili iꞌya va tono wa!” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","U wuta̱i a utsutsu u ba u shamgbai a uwotsu, makere ma roku ma wene yi, aku u tonukoi ama ɗa aꞌa̱ri pini vi, “Vuma u na vi wa̱ ta̱ dem n Yesu uza u Nazara.” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Bituru doku u nanai, “N tsina ta̱, mpa n reve vuma u na vi wa!” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","An a tsa̱ra̱i a ɓa̱ra̱kpa̱i kenu, aza ɗa aꞌa̱ri pini kushani, a banai ara Bituru a danai, “Mayun ɗa, va̱ ta̱ kaɓolo n ama ɗa a ka tono Yesu. Kpaci tyoku ɗa va dansa ɗa u wenikei ko ya va̱ri.” ");
INSERT INTO kdlNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Bituru danai, “N tsina ta̱, ukuna u mayun u ɗa ma dansa! A̱sa̱ka̱ Kashila̱ ka yan mu mavura n yanka ɗa̱ baci kaɓan! N reve vuma u na vi wa!” Kute‑kute, aku kapen ka salai. ");
INSERT INTO kdlNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Bituru ciɓai n ili iꞌya Yesu tonuko yi: “Kahu kapen ka sala, va nana mu ta̱ vu dana vu reve mu wa hal kutatsu.” Pini nala, u wuta̱i u sa̱i cika n unamgbukatsuma̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kain n ka wansi n kpasani, aku gba̱ aɗara̱kpi a pige na̱ nkoshi a sheshei a kaci ka Yesu tsa̱ra̱ a wuna yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Aku a sira yi a lazai n eyi ubana ara Bilatu† gomuna. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","An Yahuza uza ɗa u nekei Yesu a asu u atokulalu a ne u wenei a kiɗa̱gai Yesu ugana u ukpa̱, aku ukuna vi u gonoi u ɓa̱la̱ yi cika. U bidyai ikebe i azurufa kamankupa vi u gonukoi iꞌya a asu u aɗara̱kpi a pige na̱ nkoshi mi. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","U danai, “Unyushi u ɗa n yain u ɗa na: N na̱ka̱ ɗa̱ vuma ɗa bawu wa̱ri n unyushi u cingi tsa̱ra̱ i wuna yi.” Aku a wushuki, “Ndya i birika tsu? Ukuna u vunu u ɗa nala vi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yahuza wacangi ikebe yi pini a Kuwa ku Kashila̱ ki, aku u lazai u ba u vuruki kaci ka ne a maɗanga hal u kuwa̱i. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Aɗara̱kpi a pige yi a ta̱sa̱i ikebe yi a danai, “U wusha ta̱ ikebe i na yi adama a mpasa n vuma. Mele ma dana ta̱ tsa ɓolomgbono iꞌya n ikebe i Kuwa ku Kashila̱ wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Aku a ba a tsilai uyamba u vuma roku kamai ka mgbodo tsa̱ra̱ a ciɗa̱ngusu amoci a ɗa a ka kuwusa̱ a Urishelima. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ili iꞌya i zuwai a ka isa̱ asu vi “Uyamba u Mpasa” ɗa gai la vi hal utuwa̱ aꞌayin a tagara̱da na vi. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ili iꞌya Irimiya matsumate u danai vi i shaɗangu ta̱: “A bidyai ikebe i azurufa kamankupa, ikebe iꞌya aza a Isaraꞌila a wushuki a ka tsupa yi iꞌya gai la vi. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","A tsilai uyamba u kamai ka mgbodo n ikebe yi, tyoku ɗa Magono ma Zuba ma tonuko mu.” ");
INSERT INTO kdlNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","A aꞌayin a nala yi, Yesu shamgbai a kapala ka Bilatu gomuna, aku gomuna vi u wece yi, “Aɗa magono ma aza a Yahuda mi?” Yesu wushunku yi, “Nala wa̱ri tyoku ɗa vu danai vi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Shegai an aɗara̱kpi a pige na̱ nkoshi aza ɗa a ka zama yi n unyushi vi a ka dansa n eyi, u paɗai bini. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Gomuna vi u tonuko yi, “Avu pana ili iꞌya a ka dansa a kaci ka vunu ki wa?” ");
INSERT INTO kdlNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Shegai Yesu dana ili wa, aku gomuna vi u yain majiyan cika. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kayen dem a aꞌayin a Abiki a Upasamgbana, gomuna vi u tsu a̱sa̱ka̱ ta̱ vuma u te a asuvu a kuwa ku aꞌali, uza ɗa ama yi a ɗanga̱sai. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Aꞌayin a nala yi, vuma roku u ɗa pini a kuwa ku aꞌali ki uza ɗa a ka isa̱ Baraba. Ya dem u reve ta̱ vuma vi vuma u cingi u ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","An kakuma̱ ka ama ki ka ɓolomgbonoi, aku gomuna vi u wece le, “Vuma u eni u ɗa ya ciga a a̱sa̱nka̱ ɗa̱ a asuvu a kuwa ku aꞌali? Ya ciga a a̱sa̱nka̱ ɗa̱ Baraba ɗa, ko gai Yesu uza ɗa a ka isa̱ Kawauwi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Gomuna vi u reve ta̱ ama yi a tuko ta̱ Yesu ara ne adama a malyon. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Gomuna vi pini ndishi a asu u afada, aku uka u ne sukunku yi akani, u danai: “Kotsu vu yanka vuma u nala vi ili wa, kpaci u yan ili i roku i cingi wa. N yan ta̱ alavutanshi a kaci ka ne ara, kpam a ɗa a foro mu ta̱ cika.” ");
INSERT INTO kdlNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Shegai aɗara̱kpi a pige na̱ nkoshi a leshei kakuma̱ ka ama ki a da a dana u a̱sa̱nka̱ le Baraba aku a dana a wuna Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gomuna vi u doku u wecei kakuma̱ ki, “A asuvu a ama a re a na yi, ya ya ciga n a̱sa̱nka̱ ɗa̱?” A wushuki, “Baraba.” ");
INSERT INTO kdlNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","U wece le kpam, “Niɗa ma yan n Yesu, uza ɗa a ka isa̱ Kawauwi ki?” A wushuki, “A wandamgbana yi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","U wecikei, “Ndya i zuwai? Ili i cingi i eni iꞌya u yain?” A worukpoi cika, “Wandamgbana ni.” ");
INSERT INTO kdlNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","An u wenei ili iꞌa̱ la iꞌya wa yan kpam wa, kpam ama a ka ciga ɗe a gita̱ uꞌya̱nga̱sa̱ atakasuvu a ama. Pini nala, u bidyai mini u sawai akere a ne a kapala ka le u danai, “Kabirika mu n uwuna vuma u na wa, eɗa ya yan u ɗa.” ");
INSERT INTO kdlNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ya dem u wushuki, “A̱tsa na̱ mmuku n tsunu a ka ka̱na̱ n unyushi u ukpa̱ u ne.” ");
INSERT INTO kdlNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Aku Bilatu a̱sa̱nka̱ le Baraba. U zuwai asoje a bawin Yesu, aku u na̱ka̱ le n eyi a ba a wandamgbana. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pini nala, asoje a gomuna yi a bankai Yesu a asuvu a keɓile ku tsugono ku gomuna vi, aku a kyawan yi gba̱ le. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","A mondo yi aminya a ne a uka yi kunya ku san kpa̱ya̱ya̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","A yain funi† u awana a ukunka yi a kaci. A zuwuka yi kalangu ka tsugono a kukere ku ulyaki ku ne. A kuɗa̱ngi a kapala ka ne a ka yanka yi majari n dansi, “Tsu na̱ka̱ vu ta̱ tsupige Magono ma aza a Yahuda.” ");
INSERT INTO kdlNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Pini nala, a cikpunka̱ yi ata̱tsa̱. A bidyai kalangu ki a lapusa yi n ka a kaci. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","An a wowo yi uyanka majari, aku a takpa yi kunya ku san ka a uka yi vi a gonoi a uka yi aminya a ne. Pini nala, a wutukpa̱ yi a lazai n eyi ubana a asu u ɗa a ka wandamgbana yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ele n a wuti, aku a gawunsai n vuma u Sirani roku uza u kala Simo. Asoje a ma̱tsa̱ yi u canga mawandamgbani ma Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Gba̱ le a rawai a asu u ɗa a ka isa̱ Golugota;† (wata, Asu u Mako ma Kaci). ");
INSERT INTO kdlNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Asoje yi a na̱ka̱ yi mini ma cinwi ma a satarai n aguma̱ a akoni. An u peɗei ma, aku u ꞌyuwain ma uso. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Aꞌayin a ɗa a kotso yi uwandamgbana, aku asoje yi a yankai aminya a ne uruta. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Asoje a dusuki pini a asu vi a rongo yi a uwundya. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Zuba n kaci ka ne, a zuwa ta̱ iryoci i ili iꞌya i zuwai a wandamgbana yi. Ili iꞌya a korongi iꞌya na: “YESU ƊA NA VI, MAGONO MA AZA A YAHUDA.” ");
INSERT INTO kdlNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Asoje yi a wandamgbana ta̱ dem aza a maga̱la̱ka̱ a roku ama a re, uza u te a kukere ku ulyaki ku ne uza u te tani a ku ugula̱ ku ne. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ama ɗa a ka wura pini a asu vi a rongo yi ucira̱kpusa adama a magori. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","A rongoi udansa, “Vu da va wa̱sa̱ Kuwa ku Kashila̱, aku vu doku vu mai ka a asuvu a aꞌayin a tatsu. Adama a nala, wauwa kaci ka vunu! Avu Maku ma Kashila̱ ma baci, cipa̱ pini a mawandamgbani mi!” ");
INSERT INTO kdlNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Aɗara̱kpi a pige n awenishiki a Mele na̱ nkoshi a yanka yi ta̱ dem majari. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","A da, “U wauwai aza roku, shegai u fuɗa u wauwa kaci ka ne wa! U da aya magono ma aza a Isaraꞌila! Aya baci magono mi, u cipa̱ pini a mawandamgbani mi wa̱ wa, tsa̱ra̱ tsu pityanangu n eyi. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","U pityanangu ta̱ n Kashila̱, adama a nala a̱sa̱ka̱ Kashila̱ ka wauwa yi, wa ciga yi baci. U dana ta̱ dem, ‘Mpa Maku ma Kashila̱ ma.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Aza a maga̱la̱ka̱ a ɗa a wandamgbanai kaɓolo n eyi vi ele dem a yanka yi ta̱ kadyanshi ka gbani. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","An kaara ka rawai a kaci, aku uyamba vi gba̱ u likpa̱mgba̱na̱i n karimbi hal ubana ulapa uwule u tatsu. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Pini nala, Yesu salai, “Eloyi, Eloyi, lama sabaka̱tani?” Wata, “Kashila̱ ka va̱, Kashila̱ ka va̱, ndya i zuwai vu varangu mu?” ");
INSERT INTO kdlNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Aza ɗa aꞌa̱ri pini a asu vi kushani a pana̱ka yi, aku a danai, “Iliya ɗa wa isa̱!” ");
INSERT INTO kdlNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kute‑kute, uza u te u le u sumai u ba u bidyai kashaku, u ukai ka a asuvu a mini ma kalam, aku u sirai ka a kalangu u na̱ka̱i Yesu tsa̱ra̱ u soi. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Shegai aza ɗa a buwai vi a danai, “Shamgba ve tsu wene ko Iliya vi wa tuwa̱ u wauwa yi!” ");
INSERT INTO kdlNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Pini nala, u salai, aku uma u ne u wuta̱i. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kute‑kute, kunya ka a ba̱ra̱kpa̱i a asuvu a Kuwa ku Kashila̱ ku karamgbanai kure, ili iꞌya i bidyai a zuba utuwa̱ a iyamba. Aku likimba u gba̱ɗa̱i, atali a ɓatsa̱sai. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Asaun kpam a kukpusa̱i, ama a Kashila̱ ushani aza ɗa a kuwusa̱i a ꞌya̱nga̱sa̱i. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","A wuta̱i a asaun yi. An Yesu ꞌya̱nga̱i a ukpa̱, a banai a Urishelima ilyuci i uwulukpi, a wenikei kaci ka le a asu u ama ushani. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","An katigi ka asoje n asoje a ɗa aꞌa̱ri kaɓolo n eyi a wenei iyamba i gba̱ɗa̱i n ili iꞌya i gita̱sa̱i, aku a panai uwonvo, a danai, “Mayun ɗa, Vuma u na Maku ma Kashila̱ ma!” ");
INSERT INTO kdlNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Aka ushani aza ɗa a wuta̱i a Galili a tonoi Yesu tsa̱ra̱ a ɓa̱nga̱ yi a shamgbusai mɓa̱ri a ka wundya mawandamgbani mi. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Asuvu a le alya Meri Magadaliya, n Meri (mma u Yakubu n Isuhu), na̱ mma u Yakubu n Yahaya mmuku n Zabidi. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Vuma roku u ɗa pini uza ɗa wa̱ri n utsa̱ri cika uza u kala Isuhu u Arimatiya. Eyi katoni ka Yesu ka. N kuvuli ku nala ki ka u tuwa̱i a Urishelima. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","U banai ara Bilatu u foloi a na̱ka̱ yi ikyamba i Yesu. Bilatu tonukoi asoje a ne a na̱ka̱ yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","U cangai ikyamba yi u ka̱ta̱la̱i iꞌya n kunya ku shinga. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","U ukai ikyamba yi a kasaun ka savu ka ne ka a saɗarai a katali. U gindala̱kpai katali ka pige u kimba̱i utsutsu u kasaun vi, aku u lazai. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Meri Magadaliya n Meri ire vi a dusuki evu n kasaun ki aꞌa̱ri uwundya. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","An kain ka wansai; wata, kain ka Ashibi ka la vi, aɗara̱kpi a pige n Afarishi a banai ara Bilatu. ");
INSERT INTO kdlNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","A danai, “Uzapige, tsu ciɓa ta̱ aꞌayin a ɗa uza u kaɓan u nala vi wa̱ri n uma u dana ta̱, ‘A yan baci aꞌayin a tatsu, ma ꞌya̱nga̱ ta̱ a ukpa̱.’ ");
INSERT INTO kdlNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Tonuko aza a uwundya kasaun yi a wundi ka mai hal aꞌayin a tatsu. A yan baci nala wa, atoni a ne a ka tuwa̱ ta̱ a boko ikyamba yi, aku a tonuko ama u ꞌya̱nga̱ ɗe. Kaɓan ka nala ki tani ka la ta̱ ka kagita̱ ugbonguro.” ");
INSERT INTO kdlNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Bilatu danai, “Bidyai asoje ubana a asu u kasaun vi tyoku ɗa ya fuɗa i zuwa a wundi ka mai.” ");
INSERT INTO kdlNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Aku a lazai a ba a kpadai kasaun ki, a paɗarai pini cira̱kpa̱† tsu iryoci i magono a katali ki, kpam a zuwai asoje yi a wundi ka. ");
INSERT INTO kdlNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kain ka kagita̱ ka aꞌayin a shindere; wata, kain ka Aladi n kpasani, Meri Magadaliya n Meri ire vi a banai a kasaun ki tsa̱ra̱ a wene ka. ");
INSERT INTO kdlNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Aꞌayin a nala yi, iyamba i gba̱ɗa̱i n ucira. Pini nala, katsumate ka Magono ma Zuba ka wuta̱i a zuba, ka banai pini a kasaun ki ka gindala̱kpai katali ka ka̱ri a utsutsu u kasaun vi. U dusuki a zuba u katali vi. ");
INSERT INTO kdlNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Wa laɗa yavu ulaɗa u zuba, aminya a ne kpam pun cika. ");
INSERT INTO kdlNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Asoje a ɗa a ka wundya kasaun ki a giruwa̱ ta̱ cika hal a ka jeke ikyamba adama a uwonvo u katsumate ka zuba ki, hal a wokoi yavu akushe. ");
INSERT INTO kdlNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Katsumate ki ka tonukoi aka yi, “Kotsu i pana uwonvo wa. N reve ta̱ Yesu ɗa a wandamgbanai ɗa ya bolo. ");
INSERT INTO kdlNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wa̱ pini na wa, u ꞌya̱nga̱ ɗe tyoku ɗa u tonuko ɗa̱. Tuwa̱i i wene asu u ɗa aꞌa̱ri a zuwai ikyamba i ne. ");
INSERT INTO kdlNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Walai gogo i ba i tonuko atoni a ne, ‘Yesu ꞌya̱nga̱ ɗe a kukpa̱. U laza ɗe ubana a Galili kpam wa lasa ɗa̱ ta̱ urawa ɗe, nte ya wene yi ɗe.’ Ili iꞌya gai n tuwa̱i n tonuko ɗa̱ iꞌya la vi.” ");
INSERT INTO kdlNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Pini nala, aka yi a a̱sa̱ka̱i kasaun ki n uwonvo gogo, kpam n a yanyi ipeli cika. A sumai tsa̱ra̱ a ba a tonuko atoni yi ili iꞌya i gita̱i. ");
INSERT INTO kdlNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kute‑kute, Yesu gawunsai n ele aku u dana̱sa le. A raɓai evu n eyi, a wambatsa yi a aꞌene a lyaka yi kayala. ");
INSERT INTO kdlNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Aku u danai, “Kotsu i pana uwonvo wa, tonukoi atoni a va̱ a bana a Galili, nte a ka wene mu ɗe.” ");
INSERT INTO kdlNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Aꞌayin a ɗa aka yi a lazai, aku a asoje a roku aza ɗa a ka wundya kasaun ki a gonoi a ilyuci a tonukoi aɗara̱kpi a pige gba̱ ili iꞌya i gita̱i. ");
INSERT INTO kdlNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Aɗara̱kpi a pige a ba a cinai nkoshi a sheshei tyoku ɗa a ka yan. Pini nala, a na̱ka̱i asoje yi ikebe ushani. ");
INSERT INTO kdlNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","A tonuko le, “Tonukoi ama i dana atoni a Yesu a ɗa a tuwa̱i a bokoi ikyamba i ne yi n kayin cina eɗa̱ alavu. ");
INSERT INTO kdlNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Gomuna u pana baci ukuna vi, tsa dansa ta̱ n eyi, tsu wauwa ɗa̱ a upana u ikyamba.” ");
INSERT INTO kdlNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Asoje yi a wushai ikebe yi, aku a yain tyoku ɗa a tonuko le a yain. Kadyanshi ka kyawan ta̱ gba̱ uyamba u Yahuda, kpam hal n gogo‑na a ka a tonusuko ta̱ ama alabari a na yi. ");
INSERT INTO kdlNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","An atoni kupa n uza u te vi a lazai, a bana ta̱ karara she a masasa a Galili a asu u ɗa Yesu tonuko le a bana. ");
INSERT INTO kdlNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","An a rawai a wene yi, aku a lyaka yi kayala, shegai aza roku a le a yan ta̱ mala̱la̱. ");
INSERT INTO kdlNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Pini nala, u banai a asu u ɗa aꞌa̱ri, u danai, “Kashila̱ ka na̱ka̱ mu ɗe gba̱ ucira u ɗa wa̱ri a zuba n likimba. ");
INSERT INTO kdlNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Adama a nala walai i ba i tonuko gba̱ ama a likimba kadyanshi ka va̱ tsa̱ra̱ a woko Atoni a va̱. I lyuɓugu le a asuvu a kala ka Tata, n ka Maku, n ka Kulu Keri. ");
INSERT INTO kdlNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","I wenishike le a yain gba̱ iꞌya n tonuko ɗa̱. Ma rongo ta̱ n a̱ɗa̱ kain dem hal ubana a makorishi ma likimba.” ");
INSERT INTO kdlNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ukuna u Kadyanshi ka Shinga ka Yesu Kirisiti Kawauwi Maku ma Kashila̱ u ɗa na. ");
INSERT INTO kdlNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","U gita̱ ta̱ tyoku ɗa wa̱ri ukorongu a tagara̱da u Ishaya matsumate, “Kashila̱ ka danai, ‘Ma suku ta̱ katsumate ka va̱ a kapala ka vunu, kotsu u lapuluka vu ure.’ ");
INSERT INTO kdlNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Uza roku wa sala̱sa a kakamba, ‘Lapulai ure adama a Asheku, i shamkpa ure vi mai tsa̱ra̱ u wala.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Katsumate ki Yahaya Kalyuɓugi ɗa uza ɗa wa lyuɓugusu ama n mini. Wa rongo a kakamba n u yanyi kuɓari, “Kpatalai i gono a asu u Kashila̱, i a̱sa̱ka̱ tsicingi tsu ɗe. A lyuɓugu ɗa̱, kotsu Kashila̱ ka cimbusa̱ unyushi u ɗe.” ");
INSERT INTO kdlNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kakuma̱ ka ama ushani ka uyamba u Yahuda n aza a Urishelima a wuta̱i a banai ara Yahaya a dansai unyushi u le, aku u lyuɓugusu le a mini ma Aga̱ta̱ a Urudu. ");
INSERT INTO kdlNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yahaya u ukai aminya a tsileme tsu karakuma, u sirai kagbawatsu ka ukpan a cuku tsu ne. Kpam ilikulya i ne iꞌya abaruma n ishigi. ");
INSERT INTO kdlNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","U tonusukoi ama u danai, “Vuma ɗa wa tuwa̱ a kucina̱ ku va̱ u la mu ta̱ cika. Mpa n ra̱tsa n bana n kuɗa̱ngu n surukpa isirikatsu i akpata i a aꞌene a ne wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mpa n mini ma n lyuɓugusu ɗa̱, shegai eyi n Kulu Keri ka wa lyuɓugu ɗa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Aꞌayin a nala yi, Yesu wuta̱i a Nazara u uyamba u Galili u tuwa̱i ara Yahaya. An u rawai a Aga̱ta̱ a Urudu, aku Yahaya lyuɓugu yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu n u wuti a asuvu a mini mi, kute‑kute u wenei zuba u kukpa̱i, aku Kulu Keri ku cipa̱i ara ne yavu kaɗya. ");
INSERT INTO kdlNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Aku a panai kala̱ga̱tsu a zuba, ka danai, “Aɗa Maku ma va̱ ma n lai uciga, n avu ɗa ma pana kayanyan cika.” ");
INSERT INTO kdlNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kute‑kute Kulu Keri ku tonoi n eyi ubana a kakamba, ");
INSERT INTO kdlNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","asu u ɗa u rongoi aꞌayin a amangare, Kanangasi n ka kondusi yi. Nnama n mete n ɗa dem pini asu vi, shegai atsumate a zuba a bana ta̱ n a yanki yi aga̱nda̱. ");
INSERT INTO kdlNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","An nala wurai, a ka̱na̱i Yahaya a ukai a kuwa ku aꞌali. Pini nala, Yesu tuwa̱i a Galili wa dansa Kadyanshi ka Shinga ka Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","U danai, “Aꞌayin yi a shaɗangu ɗe, kpam tsugono tsu Kashila̱ tsu yan ɗe evu. Kpatalai i a̱sa̱ka̱ unyushi u ɗe, aku i wushuku n kadyanshi ka Kashila̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu n u wali a ikengi i Kushiva̱ ku Galili, aku u wenei aka̱ni a adan ama a re, Simo n Andurawu uza n uvangu, n a ka̱na̱si adan n ibilili. ");
INSERT INTO kdlNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu tonuko le, “Tono numu, ma wenike ɗa̱ ta̱ tyoku ɗa ya tukuso ama.” ");
INSERT INTO kdlNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kute‑kute a a̱sa̱ka̱i ibilili i le, a tono yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","An u walai kenu, u wenei uza n u vangu; wata, Yakubu n Yahaya mmuku n Zabidi a kpatsu n a lapulusi ibilili i le. ");
INSERT INTO kdlNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kute‑kute u isa̱ le, aku a a̱sa̱ka̱i tata u le n azamaninga, a tono yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu n atoni a ne a banai a ilyuci i Kafarnahum. Kain ka Ashibi, u uwai a kagata ka Kashila̱, aku u gita̱i uwenishike. ");
INSERT INTO kdlNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ama a yan ta̱ majiyan, kpaci tyoku u uza u ucira u ɗa wa wenishike le, kpam tyoku u awenishiki a Mele ɗa wa̱ri wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Aꞌa̱ri pini asuvu a kagata ka Kashila̱ ka le ki, aku uza u ityoni i cingi u tuwa̱i wa sala̱sa n ucira, ");
INSERT INTO kdlNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Ndya va ciga n a̱tsu, Yesu uza u Nazara? Tuwa̱ ɗa vu tuwa̱i vu wacinsa tsu? N reve ta̱ ko ya va̱ri, Uza u Uwulukpi u Kashila̱ u ɗa.” ");
INSERT INTO kdlNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu ɓaranai ityoni i cingi yi, u danai, “Paɗa! Vu wuta̱ asuvu a ne.” ");
INSERT INTO kdlNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ityoni i cingi yi i gba̱ɗa̱ yi n ucira, aku i wura̱ngi yi n ucira i wuta̱i asuvu a vuma vi. ");
INSERT INTO kdlNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Gba̱ ama a yan ta̱ majiyan, hal a ka̱na̱i uwecemgbenishe, “Ndya naha? Uwenishike u savu u ɗa? U ucira? Hal u tsu ɓarana ityoni i cingi kpam i pana̱ka yi!” ");
INSERT INTO kdlNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kute‑kute kadyanshi ka ne ka tamburai gba̱ uyamba u Galili. ");
INSERT INTO kdlNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu kaɓolo n Yakubu n Yahaya n atoni a ɗa a buwai, a a̱sa̱ka̱i kagata ka Kashila̱ ki a lazai karara she a kuwa ku an Simo n Andurawu. ");
INSERT INTO kdlNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Mma u uka u Simo wa̱ri nvain n usuɗugbi u ikyamba, an Yesu rawai, kute‑kute a laza a tonuko yi ukuna u ne. ");
INSERT INTO kdlNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","U banai ara ne u ka̱na̱ yi kukere u ꞌya̱nga̱sa̱ yi, aku mɓa̱la̱ mi n a̱sa̱ka̱ yi. U gita̱ le upecishike ilikulya. ");
INSERT INTO kdlNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","N kuvuli, an kaara ka rukpa̱i, ama a tukoi Yesu gba̱ aza a mɓa̱la̱ n aza a ityoni i cingi. ");
INSERT INTO kdlNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Gba̱ ama a ilyuci yi a ɓolomgbonoi a utsutsu u kuwa vi. ");
INSERT INTO kdlNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu ta̱na̱sa̱i aza a mɓa̱la̱ icun kau‑kau ushani, kpam u lokoi ityoni i cingi ushani. U a̱sa̱ka̱ ityoni i cingi yi i dana ukuna wa, an a revei uza ɗa wa̱ri. ");
INSERT INTO kdlNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","N kpasani, Yesu ꞌya̱nga̱i u a̱sa̱ka̱i kuwa ki u wuta̱i a ilyuci yi u banai asu u ɗa bawu ama aꞌa̱ri, u yain pini kavasu. ");
INSERT INTO kdlNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simo n aza ɗa aꞌa̱ri n eyi a wuta̱ yi ubolo. ");
INSERT INTO kdlNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","An a wene yi a tonuko yi, “Gba̱ ama ɗa pini a ka bolo vu.” ");
INSERT INTO kdlNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","U wushuki, “A̱sa̱ka̱ tsu banai ilyuci ilyuci i roku iꞌya iꞌa̱ri evu evu, kotsu dem n yanka le kuɓari ki, kpaci ili iꞌya i zuwai n tuwa̱i iꞌya la vi.” ");
INSERT INTO kdlNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","U tambai a Galili gba̱ n u yanki le kuɓari a agata a Kashila̱ a le n u wutukpusi ityoni i cingi. ");
INSERT INTO kdlNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Makutu ma roku ma tuwa̱i ara Yesu. U kuɗa̱ngi u folo yi, u danai, “Vu wushuku baci, va fuɗa ta̱ vu ta̱na̱sa̱ mu.” ");
INSERT INTO kdlNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","U pana yi asuvayali, aku u ba̱ra̱kpa̱i kukere ku ne u sawa yi. U danai, “N wushuku ta̱. Ta̱na̱!” ");
INSERT INTO kdlNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kute‑kute tsukutu tsi tsu a̱sa̱ka̱ yi, aku u ta̱na̱i. ");
INSERT INTO kdlNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Yesu rono yi atsuvu cika, “Kotsu vu tonuko uza wa, shegai wala ba vu wenike kaci ka vunu a asu u kaɗara̱kpi. Vu na̱ka̱ kune ku Musa danai a na̱ka̱ adama a ɗa vu ta̱na̱i, kpam kotsu a reve n u ɗa.” Aku u a̱sa̱ka̱ yi u lazai. ");
INSERT INTO kdlNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Shegai vuma vi u gita̱i uyan kadyanshi ki, hal u rawai asu u ɗa Yesu kpa̱ɗa̱i u uwa asuvu a ilyuci a kateshe. U ba wa rongo a asu u ɗa bawu uza wa̱ri, shegai ko n nala ama a ka wutusa̱ ta̱ a asu kau‑kau n a bansi ara ne. ");
INSERT INTO kdlNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","An a yain aꞌayin a kenu, Yesu doku u gonoi a Kafarnahum. Ama a tsa̱ra̱i alabari a ɗa wa̱ri a kuwa. ");
INSERT INTO kdlNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","A ɓolomgbonoi cika hal a nambai kabala a kunu hal kapala ka utsutsu dem. Aku u yanka le kadyanshi. ");
INSERT INTO kdlNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ama roku, ama a nishi, a cangai kawunu a tuko yi ara ne. (Uza ɗa bawu wa fuɗa wa wala ko u gba̱ɗa̱ aꞌene a ne.) ");
INSERT INTO kdlNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","An a nambai ure u ɗa a ka banka yi ara Yesu adama a kakuma̱ ka ama, a ɗapai kukpa̱ derere a asu u ɗa wa̱ri. Aku a zurala̱kpai kajiba ka kawunu ka̱ri nvain mi. ");
INSERT INTO kdlNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","An Yesu wenei tyoku ɗa a pityanangi n eyi, u tonukoi kawunu ki, “Maku ma va̱, a cimbusuka̱ vu ɗe unyushi u cingi u vunu.” ");
INSERT INTO kdlNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Awenishiki a Mele a ɗa aꞌa̱ri pini ndishi asu vi, a ka yawunsa a atakasuvu a le. ");
INSERT INTO kdlNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ndya i zuwai vuma u na u danai nala? U nusuka ta̱ Kashila̱. Ya wa̱ri n ucira u ɗa wa cimbusa̱ unyushi u cingi bamu n Kashila̱?” ");
INSERT INTO kdlNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kute‑kute katakasuvu ka ne ka wenike yi ili iꞌya a ka yawunsa a atakasuvu a le iꞌya na. U tonuko le, “Ndya i zuwai ya yawunsa nala? ");
INSERT INTO kdlNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ndya i lai shana: Va tonuko kawunu, ‘A cimbusa̱ ɗe unyushi u cingi u vunu.’ Ko gai a dana, ‘ꞌYa̱nga̱ vu shamgba, bidya kajiba ka vunu, vu wala.’? ");
INSERT INTO kdlNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Adama i reve an Maku ma Vuma† ma̱ri n ucira a likimba u ɗa wa cimbusa̱ unyushi u cingi.” U tonukoi kawunu ki, ");
INSERT INTO kdlNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“N tonuko vu, ꞌya̱nga̱ vu shamgba, bidya kajiba ka vunu, vu wala a kuwa.” ");
INSERT INTO kdlNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","U ꞌya̱nga̱i u bidyai kajiba ka ne u wuta̱i u lazai aꞌeshi a le gba̱. Ya dem yan ta̱ majiyan, aku a cikpalai Kashila̱, a danai, “Tsu taɓa uwene ukuna naha wa!” ");
INSERT INTO kdlNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","U doku u wuta̱i u banai una̱ u kushiva̱. Kakuma̱ ka ama ka banai ara ne. Aku u gita̱ le uwenishike. ");
INSERT INTO kdlNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Eyi n u wali, u wenei Levi maku ma Halfa ndishi a kakinda ka uwusha u utafa. Yesu tonuko yi, “Tono mu.” Aku u ꞌya̱nga̱i u tono yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pini nala, Yesu tuwa̱i wa lya ilikulya i kuvuli a kuwa ku Levi.† Awushi a utafa† ushani n aza a unyushi u cingi, a ka lya kaɓolo n eyi, n atoni a ne. Kpaci ama ɗa pini ushani aza ɗa a tono yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","An awenishiki a Mele n Afarishi a wene yi n u lyayi n aza a unyushi u cingi n awushi a utafa, a wecei atoni a ne, “Ndya i zuwai wa lya n awushi a utafa n aza a unyushi u cingi?” ");
INSERT INTO kdlNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","An Yesu panai nala, u tonuko le, “Aza ɗa aꞌa̱ri n alafiya a ka ciga uza u aguma̱ wa, she aza a mɓa̱la̱. N tuwa̱ adama a ɗa ma isa̱ aza a maci wa, she aza a unyushi u cingi.” ");
INSERT INTO kdlNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Atoni a Yahaya gba̱ n a Afarishi a ka yan kakuli. Ama roku a tuwa̱i a wecei Yesu, “Niɗa atoni a Yahaya n atoni a Afarishi a ka yan kakuli, shegai atoni a vunu a ka yan wa?” ");
INSERT INTO kdlNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","U wushuki, “Ya ciga amoci a asu u iyolo a rongo bawu ilikulya? Aꞌa. Wa yan wa! Valisavu wa̱ baci gai n ele a ka yan nala wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kain ka a ka bidya yi a mere ma le ka̱ ta̱ a utuwa̱, kain ka nala ki ka a ka yan kakuli. ");
INSERT INTO kdlNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Vuma wa paɗara kunya ku cau n kakashi ka savu wa. U yan baci nala, kakashi ka savu ki, ka pa̱ɗa̱ ta̱ ka zuwa kunya ku cau ki ku doku ku kara cika. ");
INSERT INTO kdlNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kpam vuma wa tsungu mini ma cinwi† ma savu a kadele ka ukpan ka cau wa. Kpaci ma shita baci ma ta̱sa̱ ta̱ kadele ki, gba̱ kadele ki n mini ma cinwi mi a ka namba le ta̱. Shegai a tsungu mini ma cinwi ma savu a kadele ka savu.” ");
INSERT INTO kdlNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Kain ka te n kain ka Ashibi, Yesu wa wala a mere ma ashina a ilya. Tyoku ɗa atoni a ne a ka wala n eyi a gita̱i ukoɗuso aratu a ilya yi n a yuruwi n a takumi. ");
INSERT INTO kdlNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Afarishi a roku a tonuko yi, “Weɓele, ndya i zuwai a ka yan ili iꞌya i nangasai mele ma tsunu ma Ashibi?” ");
INSERT INTO kdlNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","U wushuki, “I yan ka̱neshi u ili iꞌya Dawuda yain, an eyi n aje a nwalu a ne a nambai, kpam a ka pana kambulu wa? ");
INSERT INTO kdlNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Aꞌayin a Abiyata Magono ma Aɗara̱kpi, Dawuda uwai a Kuwa ku Kashila̱,† u takumai iburodi i uwulukpi iꞌya a na̱ka̱i Kashila̱. Ili iꞌya Magono ma Aɗara̱kpi ma koshi a wushunki u takuma. Kpam u na̱ka̱i aje a nwalu a ne i roku.” ");
INSERT INTO kdlNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Aku u tonuko le, “Kashila̱ ka yan ta̱ Ashibi adama a vuma, shegai vuma adama a Ashibi wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Adama a nala, Maku ma Vuma Asheku a ɗa, hal a kain ka Ashibi dem.” ");
INSERT INTO kdlNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu gonoi a kagata ka Kashila̱, kpam vuma ɗa ili i soi kukere aya pini a asuvu. ");
INSERT INTO kdlNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Aza roku a ɗa pini aza ɗa a ka ciga a tsa̱ra̱ ili iꞌya a ka sapula yi. A zuwuka yi aꞌeshi a wene ko wa ta̱na̱sa̱ vuma vi n kain ka Ashibi. ");
INSERT INTO kdlNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu tonukoi vuma vi, “ꞌYa̱nga̱ vu wuta̱ na a kateshe.” ");
INSERT INTO kdlNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Aku u wece le, “Ndya iꞌa̱ri dere a kain ka Ashibi? Uza u yain ili i shinga ko i cingi? U wauwa uma ko u wuna?” Shegai a paɗai bini. ");
INSERT INTO kdlNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","U lingana le na asuvu a upan, u namgbai asuvu adama a ugbami u asuvu u le. U tonukoi vuma vi, “Ra̱ɗa̱gba̱ kukere ku vunu.” An u ra̱ɗa̱gba̱i ka, aku ku ta̱na̱i. ");
INSERT INTO kdlNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Pini nala, Afarishi a wuta̱i n ama a Hiridu a ka sheshe tyoku ɗa a ka wuna Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu kaɓolo n atoni a ne a a̱sa̱ka̱i ilyuci yi a banai a una̱ u Kushiva̱ ku Galili. Aku kakuma̱ ka pige ka wuta̱i a kaɓon ka Galili, n uyamba u Yahuda ka tono yi, ");
INSERT INTO kdlNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","n Idumiya n ilyuci i Urishelima, n upashi u Urudu hal n ama a kaɓon ka Taya n Sida. Kakuma̱ ka pige ka tuwa̱i ara ne an a panai ili iꞌya wa yansa. ");
INSERT INTO kdlNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Adama a kakuma̱ ki u zuwai atoni a ne a lapuluka yi kpatsu ku kenu, kotsu kakuma̱ ki ka gbaɓaryangu yi wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kpaci u ta̱na̱sa̱ ta̱ ama ushani, aku aza a mɓa̱la̱ a ka raɓa evu n eyi, kotsu a tsa̱ra̱ a sawa yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Aꞌayin a ɗa baci ityoni i cingi i wene yi she i rukpa̱ iyamba, a kapala ka ne, i sala, “Avu Maku ma Kashila̱ ma.” ");
INSERT INTO kdlNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Shegai she u ɓarana le kotsu a tonuko uza ko ya wa̱ri wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu yuwa̱i a zuba u kaga̱la̱la̱, u ɗanga̱sai aza ɗa eyi wa ciga, a tuwa̱i ara ne. ");
INSERT INTO kdlNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","U ɗanga̱sai ama kupa n ama a re, u zuwa le a rongo n eyi, kotsu u suku le a wenishike, ");
INSERT INTO kdlNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","kpam a tsa̱ra̱ ucira u ɗa a ka wutukpa̱ ityoni i cingi. ");
INSERT INTO kdlNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Atoni a ɗa u ɗanga̱sai vi a ɗa: Simo (uza ɗa u na̱ka̱i kala Bituru), ");
INSERT INTO kdlNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakubu maku ma Zabidi n utoku u ne Yahaya (aza ɗa u na̱ka̱i kala Buwanaji; wata, mmuku m makpankashila̱). ");
INSERT INTO kdlNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","U ɗanga̱sai kpam Andurawu, n Filibu, n Batalamawu, n Matiyu, n Toma. U ɗanga̱sa ta̱ dem Yakubu maku ma Halfa, n Tadawu n Simo Ziloti, ");
INSERT INTO kdlNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","n Yahuza Isikariyoti, uza ɗa u tuwa̱i u neke yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu uwai a kuwa, kakuma̱ ka doki ka ɓolomgbonoi, hal eyi n atoni a ne a kpa̱ɗa̱i ulya ilikulya. ");
INSERT INTO kdlNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","An aza a kuwa a ne a panai nala a banai kotsu a ka̱na̱ yi, an a danai aya pini wa gita̱ ufulukpa. ");
INSERT INTO kdlNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Aku awenishiki a Mele a ɗa a wuta̱i a Urishelima a danai, “Wa̱ ta̱ n Baꞌalzabu magono mi ityoni i cingi, kpam n ucira u ne u ɗa wa wutukpusa̱ ityoni i cingi.” ");
INSERT INTO kdlNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu isa̱ le u yain kadyanshi n ele n agisani, “Niɗa Kanangasi ka loko Kanangasi? ");
INSERT INTO kdlNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tsugono tsa baci tsu pecei n tsu shila̱ka̱ni, tsa tsa fuɗa tsa shamgba wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kuwa ka baci ku pecei n ku shila̱ka̱ni, kuwa ku nala ka shamgba wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kanangasi ka kovo baci kaci ka ne, aku u pecei kure, wa fuɗa wa shamgba wa, makorishi ma ne ma la vi. ");
INSERT INTO kdlNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Uza wa̱ la wa fuɗa u bana a kuwa ku uza u ucira u pura̱ yi ucanga wa, she u gita̱ u sira yi ve, aku u pura̱ yi ucanga vi. ");
INSERT INTO kdlNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Mayun n tonuko ɗa̱, gba̱ unyushi u cingi, n unyushi u cingi u pige u ɗa ama a ka yansa, a ka cimbusuka̱ le ta̱ u ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Shegai uza ɗa baci dem u nusukai Kulu Keri a ka taɓa yi ucimbusuka̱ wa, u yan ɗe la vi unyushi u ɗa bawu wa̱ri n utyoku.” ");
INSERT INTO kdlNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Dana ɗa u danai nala, an a ka dansa, “Wa̱ ta̱ n ityoni i cingi.” ");
INSERT INTO kdlNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mma n aꞌangu a Yesu a rawai. A shamgbai a uwotsu, a suki uza roku a asuvu u isa̱ yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Kakuma̱ ka ama ka dusuki ka kyawan yi, aku a tonuko yi, “Mma u vunu n aꞌangu a vunu a ɗa ɗe a kateshe a ka bolo vu.” ");
INSERT INTO kdlNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","U wecikei, “An ya mma u va̱ n aꞌangu a va̱?” ");
INSERT INTO kdlNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Aku u weɓelei aza ɗa a dusuki a kyawan yi vi, u danai, “Mma u va̱ n aꞌangu a va̱ a ɗa na.” ");
INSERT INTO kdlNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Uza ɗa baci dem wa yan ili iꞌya Kashila̱ ka ciga aya utoku u va̱; vangu n utaku na̱ mma u va̱. ");
INSERT INTO kdlNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu doku u gita̱i uwenishike a kaɓon ka kushiva̱. Kakuma̱ ka ka ɓolomgbonoi ka ka kyawan yi ka ka̱ wa wa, hal ka zuwai u uwai a kpatsu u dusuki. Kpatsu ki a ikengi i mini iꞌya ka̱ri, ama yi tani a shamgbai a kagiɗa. ");
INSERT INTO kdlNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","U wenishike le ili ushani n agisani, u danai, ");
INSERT INTO kdlNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Panai. Vuma roku ɗa u banai uwacangusu u icun. ");
INSERT INTO kdlNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tyoku ɗa wa̱ri uwacangusu icun yi, aku i roku i rukpa̱i a ure. Nnu n wuta̱i n ka̱ɗa̱sa̱i iꞌya. ");
INSERT INTO kdlNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","I roku tani i rukpa̱i a iyamba i atali bawu kayala ka maci. I lazai i binyai adama a unambi u kayala ushani. ");
INSERT INTO kdlNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","An kaara ka yain, ka runukpai iꞌya, aku i lazai i ekpei adama a ukpa̱ɗa̱ uꞌuwa u alu a iyamba. ");
INSERT INTO kdlNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","I roku i rukpa̱i a asu u awana, an i gbonguroi, aku awana yi a sapusai iꞌya hal i kpa̱ɗa̱i ilimaci. ");
INSERT INTO kdlNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","I roku tani i rukpa̱i a iyamba i shinga i wuta̱i, i gbonguroi, i matsai cika. I roku iꞌa̱ ta̱ n kamankupa‑kamankupa, i roku amangatatsu‑amangatatsu, i roku tani amangatawun‑amangatawun.” ");
INSERT INTO kdlNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesu korusoi, “Uza ɗa baci wa̱ri n atsuvu a upana, u pana.” ");
INSERT INTO kdlNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","An u wokoi utyoku u ne, ama roku a ɗa aꞌa̱ri pini a asu vi kaɓolo n atoni a ne Kupanamere,† a wece yi u wutumkpa̱ le agisani yi a kateshe. ");
INSERT INTO kdlNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","U tonuko le, “Ili iꞌya a sokongi i tsugono tsu Kashila̱ a wenike ɗa̱ iꞌya ɗe. Shegai aza ɗa bawu aꞌa̱ri a asuvu a ɗe n agisani a ɗa a ka pana ko ndya wa, ");
INSERT INTO kdlNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","adama ‘A uwene n aꞌeshi a ka wene ta̱, shegai a ka reve ili iꞌya a wenei wa. A upana kpam a ka pana ta̱, shegai a ka reve wa, ka wa a ka yira̱la̱kpa̱ ta̱ Kashila̱ ka cimbusuka̱ le unyushi u le.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesu wece le, “I reve agisani a naha yi wa, niɗa ya yansa i reve agisani a roku? ");
INSERT INTO kdlNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kacimbi ka nala ki ukuna u Kashila̱ u ɗa u wacangusi. ");
INSERT INTO kdlNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ama roku tyoku u icun iꞌya iꞌa̱ri a ure a asu u ɗa a cei ukuna vi ɗa aꞌa̱ri. N upana u le, aku Kanangasi ka bidyai ukuna u ɗa a cei a asuvu a le yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aza roku tyoku u icun iꞌya i rukpa̱i a asu u atali ɗa aꞌa̱ri. N upana ukuna vi a wushai u ɗa n ipeli. ");
INSERT INTO kdlNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Shegai u uwa asuvu a le wa, kpam a ɓa̱ra̱kpa̱ wa. An aꞌayin a upana u ikyamba n a mavura adama a ukuna vi a rawai, a laza a rukpa̱i. ");
INSERT INTO kdlNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ama roku tani tyoku u icun iꞌya a wacangusi asu u awana ɗa aꞌa̱ri. Ama a na yi alya aza ɗa a panai ukuna vi. ");
INSERT INTO kdlNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Shegai kadambula ka uma n uciga u udukuyan n maluwa ma ili iꞌya i buwai ma gbagbalai ukuna vi a kpa̱ɗa̱i una̱ka̱ mmuku. ");
INSERT INTO kdlNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Aza ɗa a buwai tyoku u icun iꞌya a wacangusi a iyamba i shinga ɗa aꞌa̱ri. A panai ukuna vi, a wushai u ɗa, aku a na̱ka̱i mmuku. Aza roku a na̱ka̱i kamankupa kamankupa, aza roku kpam amangatatsu amangatatsu, aza roku tani amangatawun amangatawun.” ");
INSERT INTO kdlNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu lyai kapala, u wece le, “Vuma wa̱ la u taɓai u sapa macikalu, aku u kimba̱i ma n kabelu ko u ukai a kere ka ivamkpatsu? A kashamkpatsu ka ne ka wa zuwa ma wa? ");
INSERT INTO kdlNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ko ndya baci a sokongi a ka wutukpa̱ ta̱ iꞌya a kateshe, kpam ko ndya baci a kimba̱i a ka kukpa̱ ta̱ iꞌya. ");
INSERT INTO kdlNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Adama a nala uza ɗa baci wa̱ri n atsuvu a upana, u pana.” ");
INSERT INTO kdlNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","U tonuko le kpam, “Kiranai n ili iꞌya i panai. Ciɓai, kakundatsu ka i kundunki ama ili, ka dem Kashila̱ ka kundunku ɗa̱ ili, hal she u pasa̱ka. ");
INSERT INTO kdlNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Aza ɗa baci aꞌa̱ri n ili, alya a ka na̱ka̱. Aza ɗa baci bawu aꞌa̱ri n ili, i kenu iꞌya aꞌa̱ri n iꞌya vi, a ka wusa le ta̱ iꞌya.” ");
INSERT INTO kdlNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu lyai kapala u danai, “Naha ɗa tsugono tsu Kashila̱ tsa̱ri. Vuma roku ɗa u cei icun a kashina. ");
INSERT INTO kdlNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","U vaki u ꞌya̱nga̱i kaara n kayin, gba̱ n nala icun yi iꞌa̱ri uwuta̱ n i gbonguri, u reve tyoku ɗa ya gbonguro wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Iyamba yi n kaci ka ne i zuwai ilya yi i gbonguroi, aku i na̱ka̱i mmuku. I gita̱i n asungu, aku aratu aku mmuku pini aratu yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","An ilya yi i kuwai u kapai iꞌya, kpaci aꞌayin a ukapa a rawa ɗe.” ");
INSERT INTO kdlNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu wece le, “Niɗa tsa dana tsugono tsu Kashila̱ tsa̱ri? Agisani a eni a ɗa tsa yan tsu ra̱tsana̱ka tyoku ɗa tsa̱ri? ");
INSERT INTO kdlNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Tyoku ucun u musta ɗa tsa̱ri, ucun u kenu gbende u ɗa a tsu ce a iyamba. ");
INSERT INTO kdlNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","A ce baci u ɗa u tsu gbonguro ta̱ u lai gba̱ iceshi. U yain nsaɓu n pige n pige a asu u ɗa nnu n tsu rukpa̱ pini a kulu ku ne.” ");
INSERT INTO kdlNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","N agisani ushani icun i na ɗa Yesu tsu tonusuko ama akani a ne tyoku ɗa a ka reve. ");
INSERT INTO kdlNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","U tsu dansa n ele u bawu agisani wa, shegai u woko baci n atoni a ne koshi, aku u wutumkpa̱ le a ɗa a kateshe. ");
INSERT INTO kdlNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kain ki n kuvuli, Yesu n atoni a ne pini a ikengi i Kushiva̱ ku Galili ki, u tonuko le, “Tsu pasamgbanai tsu gonoi upashi u niɗe.” ");
INSERT INTO kdlNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Atoni a ne a uwai a kpatsu ku wa̱ri, a a̱sa̱ka̱i kakuma̱ ka ama, a lazai n eyi. Aꞌatsu a roku a tono le. ");
INSERT INTO kdlNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","A ɓa̱ra̱kpa̱ wa, uwule u ucira u lapanai, aku aɓali a ka gba̱ɗa̱ kpatsu ki, hal ka ciga ushumbugu. ");
INSERT INTO kdlNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu wa̱ri a kucina̱ ku kpatsu nvain n kaci ka ne a ili i utaɗanku kaci wa lavuta. Atoni a ne a ꞌya̱nga̱sa̱ yi, a danai, “Kawenishiki, tsa shumbugu ɗe, vu dambula wa?” ");
INSERT INTO kdlNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu ꞌya̱nga̱i u ɓaranai uwule vi, “Shamgba!” U tonukoi kpam aɓali yi, “Shamgba shiriri!” Uwule vi u vaki, aku a asu vi u wokoi shiriri. ");
INSERT INTO kdlNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Aku u tonukoi atoni a ne yi, “Ndya i zuwai i giruwa̱i? Hal n ara i pityanangu wa?” ");
INSERT INTO kdlNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Uwonvo u ka̱na̱ le cika, aku a gita̱i uwecemgbene, “Ucun u vuma u eni u ɗa u na vi? Hal uwule n aɓali dem a ka pana̱ka yi.” ");
INSERT INTO kdlNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu n atoni a ne a rawai a upashi u Kushiva̱ ku Galili u uyamba u Garasa. ");
INSERT INTO kdlNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","An Yesu wuta̱i a kpatsu, vuma u ityoni i cingi u wuta̱i a asu u asaun kotsu u cina yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Asu u asaun u ɗa u tsu ronguso. Kpam ko uza wa fuɗa wa sira yi wa, ko n ikani. ");
INSERT INTO kdlNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kpaci a so yi ta̱ usira̱sa akere n aꞌene, shegai u kiɗa̱sai ikani yi u koɗusoi irim iꞌya iꞌa̱ri aꞌene a ne, kpam ko uza wa̱ n ucira u ɗa wa goso yi wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kaara n kayin nte wa genge pini a asu u asaun vi n kaga̱la̱la̱, aku u rongo isali n u kaara̱si ikyamba i ne n atali. ");
INSERT INTO kdlNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Eyi a mɓa̱ri, an u wenei Yesu u sumai u ba u kuɗa̱ngi a kapala ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Aku Yesu tonuko yi, “Wuta̱i pini a asu u vuma vi, ityoni i cingi.” Vuma vi u salai cika, “Yesu, Maku ma Kashila̱ ka pige, ndya va ciga na̱ mpa? Tsina n Kashila̱ an va kpa̱ɗa̱ mu uyan mavura.” ");
INSERT INTO kdlNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Pini nala, Yesu wece yi, “Ndya kala ka vunu?” U danai, “Kala ka va̱ ka Katam, kpaci tsa̱ ta̱ ushani.” ");
INSERT INTO kdlNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","U foloi Yesu cika kotsu u loko le pini a uyamba vi wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ushiga u mburusunu u ɗa pini wa lina a kaga̱la̱la̱ ka masasa ma ma̱ri evu n a asu vi. ");
INSERT INTO kdlNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ityoni i cingi yi i foloi Yesu, “A̱sa̱ka̱ tsu tsu bana a asu u mburusunu, kpam vu a̱sa̱ka̱ tsu tsu uwa le.” ");
INSERT INTO kdlNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","U wushunku le, aku a wuta̱i a ba a uwai a asuvu a mburusunu. Ushiga vi, evu na̱ mburusunu azu a re (2,000) ɗa. A wuranai she a kushiva̱ a uwai pini a shumbugi. ");
INSERT INTO kdlNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Aza ɗa a ka lina̱ka mburusunu mi a sumai a ba danai a ilyuci n une. Aku ama a wuta̱i a wene ili iꞌya i gita̱i. ");
INSERT INTO kdlNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","An a tuwa̱i ara Yesu a wenei vuma ɗa wa̱ri n katam ka ityoni i cingi, ndishi n aminya kpam n ugboji u ne, aku uwonvo u ka̱na̱ le. ");
INSERT INTO kdlNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Aza ɗa a wenei ukuna vi, a tonukoi ama ili iꞌya i gita̱i n vuma ɗa wa̱ri n ityoni i cingi na̱ mburusunu mi dem. ");
INSERT INTO kdlNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Aku a foloi Yesu u a̱sa̱ka̱ uyamba vi. ");
INSERT INTO kdlNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","An Yesu wa uwa a kpatsu uza ɗa wa̱ri n ityoni i cingi caupa vi u foloi kotsu u toni yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesu a̱sa̱ka̱ yi u toni yi wa, shegai u tonuko yi, “Bana a kuwa asu u ama a vunu vu tonuko le tyoku ɗa Asheku a yanka vu, n tyoku ɗa u pana vu asuvayali.” ");
INSERT INTO kdlNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Vuma vi u kyawunsai gba̱ uyamba u Dikafoli, n u tonusuko le ili iꞌya Yesu yanka yi. Aza ɗa a panai vi gba̱ a yan ta̱ majiyan. ");
INSERT INTO kdlNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","An Yesu doki u pasamgbanai a kushiva̱ ki a kpatsu u gonoi upashi u niɗe, kakuma̱ ka ama ka ɓolomgbonoi ka kyawan yi eyi pini a asu u kushiva̱ vi. ");
INSERT INTO kdlNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Uza u te a asuvu a azapige a kagata ka Kashila̱ uza u kala Jayiru u tuwa̱i pini. N u wene Yesu, u kuɗa̱ngi a kapala ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","U folo yi cika u da, “Maku ma va̱ makere ma pini a una̱ u ukpa̱, ka̱na̱ asuvu vu tuwa̱ vu sawa yi kotsu u ta̱na̱ u yain uma.” ");
INSERT INTO kdlNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesu tono yi, kakuma̱ ka ama ushani ka tono yi n ka gbaɓaryangusu yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Uka ɗa pini uza ɗa wa pana ikyamba cika a asu u ula̱la̱ u mpasa hal ayen kupa n a re. ");
INSERT INTO kdlNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","U pana ta̱ ikyamba cika a kukere ku aza a aguma̱ kpam u wunai gba̱ ili iꞌya wa̱ri n iꞌya. Ɗa wa yan yi shana, maɓa̱la̱ mi she kapala ka ma̱ri ulya. ");
INSERT INTO kdlNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","An u panai ukuna u Yesu, u banai a kucina̱ ku ne a asuvu a kakuma̱ ki, aku u sawa yi kunya. ");
INSERT INTO kdlNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Kpaci u yawunsa ta̱ a katakasuvu ka ne, “N sawa baci kunya ku ne koshi ma ta̱na̱ ta̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kute‑kute ula̱la̱ u mpasa u ne u shamgbai kpam u panai a asuvu a ikyamba i ne u ta̱na̱i, ɗa u wunvugai n upana u ikyamba. ");
INSERT INTO kdlNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Aku Yesu lazai u revei an ucira u wuta̱i a asuvu a ikyamba i ne. U kpatalai a asuvu a kakuma̱ ki, u danai, “Ya sawai kunya ku va̱?” ");
INSERT INTO kdlNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Atoni a ne a wushuki, a danai, “Vu wenei dem kakuma̱ ka gbaɓaryangu vu, aku vu dana ya sawa vu?” ");
INSERT INTO kdlNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Shegai Yesu lyai kapala n uweɓelishe ko wa wene uza ɗa u yain nala vi. ");
INSERT INTO kdlNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Uka vi an u revei ili iꞌya i gita̱i n eyi, u wuta̱i u kuɗa̱ngi a kapala ka ne, n uwonvo n u jeki ikyamba. Aku u tonuko yi gba̱ ili iꞌya i gita̱i. ");
INSERT INTO kdlNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","U tonuko yi, “Maku ma va̱, upityanangu u vunu u ta̱na̱sa̱ vu ɗe. Wala ili vunu, kpam upana u ikyamba u nala vi u pecemgbene n avu.” ");
INSERT INTO kdlNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","An Yesu wa̱ri a kadyanshi, ama roku a wuta̱i a kuwa ku Jayiru, uzapige u kagata ka Kashila̱. A danai, “Maku ma vunu ma kuwa̱ ɗe. Ugan kpam vu damgbara̱sa kawenishiki ki wa?” ");
INSERT INTO kdlNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu dambula gba̱m n ili iꞌya a ka tono wa, u tonukoi uzapige vi, “Pana uwonvo wa, avu gai pityanangu.” ");
INSERT INTO kdlNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","U a̱sa̱ka̱ ko uza u toni yi wa, she Bituru, n Yakubu n utoku u ne Yahaya. ");
INSERT INTO kdlNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","An a rawai a kuwa ku uzapige ki, Yesu panai ama aꞌa̱ri kacan, aꞌa̱ri kushen n isali cika. ");
INSERT INTO kdlNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","U uwai a asuvu, u wece le, “Ndya i tukoi kacan n isali naha? Makere mi ma kuwa̱ wa, alavu a ɗa yi.” ");
INSERT INTO kdlNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Shegai a doso yi idyoshi i magori. Pini nala, u wutukpa̱ le gba̱ le, u bidyai tata na̱ mma makere vi n atoni a ne a ɗa aꞌa̱ri n eyi, a uwai ubana a asu u ɗa makere mi ma̱ri. ");
INSERT INTO kdlNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","U ka̱na̱i kukere ku makere ki u tonuko yi n kaletsu ka ne, “Talita kumi.” (“Maku ma makere, n da vu ꞌya̱nga̱.”) ");
INSERT INTO kdlNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kute‑kute makere mi ma ꞌya̱nga̱i ma gita̱i nwalu, kpaci ayen a ne kupa n a re ɗa. N uwene naha aku a yain majiyan cika. ");
INSERT INTO kdlNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","U ɓarana le, kotsu uza u reve ukuna vi wa, aku u tonuko le a nei makere mi ilikulya u lyai. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu n atoni a ne a a̱sa̱ka̱i a asu vi a lazai ubana a ilyuci i ne Nazara. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","An Ashibi a yain u gita̱i uwenishike a kagata ka Kashila̱. Ama ushani a pana̱ka yi aku a yain majiyan. A danai, “Nte vuma u naha tsa̱ra̱i ili i na gba̱? Ucun u kakiri ka eni ka a na̱ka̱ yi naha? Weɓelei ukunosavu† u ɗa aꞌa̱ri a uyansa a akere a ne! ");
INSERT INTO kdlNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kashei ka nala ka naha vi wa, maku ma Meri. Atoku a ne kpam alya an Yakubu, n Isuhu, n Yahuza, n Simo wa? Ataku a ne a ɗa naha kaɓolo n a̱tsu vi wa?” Adama a nala a ꞌyuwan yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","U tonuko le, “Matsumate ma tsu namba tsupige wa, she a ilyuci i ne, n asu u ama a ne, n asuvu a kuwa ku ne.” ");
INSERT INTO kdlNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","U fuɗa u yan ukunosavu wa, shegai u tsa̱ra̱i u sawusai aza a mɓa̱la̱ kenu u ta̱na̱sa̱ le. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","U yain majiyan cika, adama a ukpa̱ɗa̱ u upityanangu u le. Yesu kyawain une, n u wenishiki ama. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","U isa̱i asuki Kupanamere vi u suku le ama a re ama a re, u na̱ka̱ le ucira a kaci ka ityoni i cingi. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","U tonuko le, “Kotsu i bidya ili adama a nwalu mi wa, she kalangu koshi. Kotsu i bidya ilikulya, ko katsa̱n, ko kpam ikebe a ijubu i ɗe wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","I uka akpata a aꞌene, shegai kotsu i uka ntogo n re wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kuwa ka baci dem i uwai, rongoi pini she kain ka ya a̱sa̱ka̱ ilyuci yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Gba̱ ko nte baci a ꞌyuwan ɗa̱ ko a kpa̱ɗa̱ ɗa̱ upana̱ka, ya wuta̱ baci, i ka̱pa̱tsa̱ kabuta̱ ka aꞌene a ɗe, adama a iryoci a mere ma le an i wuta̱i uwule u le.” ");
INSERT INTO kdlNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","A wuta̱i a ba a yankai ama kuɓari ki, a kpatala a gono a asu u Kashila̱ a a̱sa̱ka̱ tsicingi tsu le. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","A wutukpusa̱i ityoni i cingi ushani, a sugburuka̱i aza a mɓa̱la̱ ushani manivi kpam a ta̱na̱sa̱ le. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Hiridu magono u panai kadyanshi ka Yesu, kpaci kala ka ne ka tambura ta̱ ko nte wa. Aza roku a ka dansa Yahaya kalyuɓugi aya u ꞌya̱nga̱i a ukpa̱, ili iꞌya i zuwai wa yansa ukunosavu ɗa la vi. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Aza roku a danai, “Iliya ɗa.” Aza roku tani a danai, “Matsumate ma yavu ntsumate n cau.” ");
INSERT INTO kdlNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Shegai an Hiridu panai nala, u danai, “Yahaya vuma ɗa n kiɗai kaci u ꞌya̱nga̱ ɗe a ukpa̱!” ");
INSERT INTO kdlNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kpaci aya u zuwai a ka̱na̱ yi, aku u zuwai a sira yi, a uka yi a kuwa ku aꞌali. Yan ɗa u yain nala adama a Hiridiya uka u vangu u ne Filibu, u ɗa u zuwai. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","An Yahaya tonuko yi, “U gan vu zuwa uka u vangu u vunu wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Hiridiya tani u ka̱na̱i Yahaya a katsuma̱, hal wa ciga u wuna yi, shegai u reve tyoku ɗa wa yan wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Hiridu wa pana ta̱ uwonvo u Yahaya, an u revei vuma u maci ɗa kpam uza u uwulukpi, ɗa i zuwai wa kirana n eyi. U tsu dambula ta̱ cika wa pana̱ka baci Yahaya, shegai ko n nala u tsu ciga ta̱ u pana̱ka yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","A makorishi, Hiridiya tuwa̱i u gawunkai. An kain ka ilimaci ka Hiridu ka kyawain, u libanai ngono m iyamba, n azapige a asoje, n azapige a Galili abiki yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","An makere ma Hiridiya ma uwai ma jei, Hiridu n amoci a ne a panai kayanyan. Pini nala, magono ma tonukoi makere mi, “Folo mu gba̱ ili iꞌya va ciga, ma na̱ka̱ vu ta̱ iꞌya.” ");
INSERT INTO kdlNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","U tsinai u danai, “Ko ndya baci vu wecikei ma na̱ka̱ vu ta̱, ko kaɓon ka tsugono tsu va̱ tsa baci.” ");
INSERT INTO kdlNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","U wuta̱i u ba u wecei mma u ne, “Ndya ma folo?” Mma u ne danai, “Kaci ka Yahaya kalyuɓugi.” ");
INSERT INTO kdlNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kute‑kute u uwai asu u magono n maloko u danai, “Ma ciga ta̱ vu na̱ka̱ mu gogo‑na‑na kaci ka Yahaya kalyuɓugi a mabaluwa.” ");
INSERT INTO kdlNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Asuvu a magono a namgbai cika, shegai adama a utsina u ɗa u tsinai a kapala ka amoci a ɗa aꞌa̱ri pini vi, wa ciga u ɓishinka yi wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kute‑kute u zuwai kazoli ka ne ka bana a kuwa ku aꞌali u ba u kiɗa kaci ka Yahaya ki. Vuma vi u ba u kiɗa yi kaci ki. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","U tukoi ka a mabaluwa u na̱ka̱i makere mi, makere mi ma bankai mma u ne. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","An atoni a Yahaya a panai nala, a ba bidyai ikyamba yi a ciɗa̱ngi. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Asuki a Yesu yi a gonoi ara ne, a tonuko yi gba̱ ili iꞌya a yain n iꞌya a wenishikei. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","An u wokoi ama a yan le ushani, hal Yesu n asuki a ne a tsa̱ra̱ kabala ka a ka lya ilikulya wa. Pini nala, u tonuko le, “Tuwa̱i tsu banai a asu u ɗa bawu uza wa̱ri tsa̱ra̱ i wunvugusa.” ");
INSERT INTO kdlNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Aku a lazai utyoku u le a asuvu a kpatsu ubana a asu u ɗa bawu uza wa̱ri. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ama ɗa a wene le n a lazi vi a reve le, aku a wuta̱i gba̱ a ilyuci a walai n ilyaɗi a lasa le urawa. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","N ucipa̱ u Yesu a kpatsu u wenei kakuma̱ ka ama, a yanka yi iyali, kpaci tyoku u ncon n ɗa bawu ma̱ri n kaliniki ɗa aꞌa̱ri. U gita̱ le uwenishike ili ushani. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","An kaara ka yain evu n urukpa̱, atoni a ne a banai ara ne, a tonuko yi, “Asu u na ɗa na wa̱ n uza wa, kpam kaara ka na ka yan ɗe evu n urukpa̱. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Tutsuku le ubana ashina n une une iꞌya iꞌa̱ri evu evu a ba a tsila̱ka kaci ka le ilikulya.” ");
INSERT INTO kdlNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","U wushunku le, “Eɗa̱ ne le ilikulya a lyai wa̱wa.” Aku a tonuko yi, “Ciga ɗa va ciga tsu ba tsu bidya ikebe i manyan ma uwoto kulla̱ tsu tsila̱ka ilikulya tsu na̱ka̱ le a lyai?” ");
INSERT INTO kdlNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","U wece le, “Iburodi i yain iꞌya iꞌa̱ri n iꞌya? Walai i ba i kondo.” An a ba a kondoi, a danai, “I tawun iꞌya n adan a re.” ");
INSERT INTO kdlNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Aku u tonuko le a zuwa ama yi dusukusu aɓolo aɓolo a zuba u mete ma ta̱ku. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ama yi a dusuki n a tonomgboni, aza roku amangatawun‑amangatawun, aza roku amangarenkupa‑amangarenkupa. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","An u bidyai iburodi i tawun n adan a re yi, u gaɗigbai kaci ka ne a zuba, u cikpai Kashila̱. Pini nala, u jiba̱mgba̱na̱sa̱i iꞌya n u na̱ki atoni a ne a na̱ka̱sa̱ ama, kpam u pecike le dem adan yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Gba̱ le a lyai hal a cuwa̱i. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Aku atoni yi a cira̱ngi abuwi a iburodi n adan yi hal mbana kupa na̱ n re. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Asuvu a ama ɗa a takumai iburodi yi, aꞌali ama azu a tawun (5,000) a ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","A ɓa̱ra̱kpa̱ wa, aku Yesu tonukoi atoni a ne a uwa a kpatsu a lasa yi upasamgbana ubana a Besaida, hal n u wacinsi kakuma̱ ki. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","An u wacinsa le, u banai a masasa kotsu u yain kavasu. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","An kuvuli ku yain, kpatsu ka̱ri a mere ma kushiva̱, Yesu wa̱ri a kagiɗa utyoku u ne. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","An u wene le aꞌa̱ri umoɗono n uwantika kpatsu, kpaci uwule u ꞌya̱nga̱sa̱ka̱ le. N kpasani cika, u tuwa̱i ara le wa wala a zuba u mini ma kushiva̱. U yain yavu wa wura le. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Shegai an a wene yi wa tuwa̱ a zuba u mini, a bidyai ko kafofu ka, a salai. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Gba̱ uwonvo u ka̱na̱ le an a wene yi vi. Kute‑kute, u yanka le kadyanshi, u danai, “Gbamai asuvu, ko ili iꞌa̱ la wa, mpa. Panai uwonvo wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Aku u uwai a kpatsu ku aꞌa̱ri vi, pini nala, uwule vi u vaki. Atoni yi a yan ta̱ majiyan, ");
INSERT INTO kdlNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","kpaci a reve kalen ka burodi ki wa, an atakasuvu a le a gbamai. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","An a pasamgbanai a rawai a Janisara, a sirai kpatsu ki a una̱ u mini. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","N uwuta̱ u le a kpatsu ama a laza a reve yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","A kotsoi gba̱ kaɓon ki n ilyaɗi, a canga̱sai gba̱ aza a mɓa̱la̱ nvain a ajiba a le ubana a asu u ɗa baci dem a panai wa̱ri. ");
INSERT INTO kdlNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Gba̱ ko nte baci u banai ilyuci ko a une, she a vakunku aza a mɓa̱la̱ a kuden, aku a folo yi u a̱sa̱ka̱ a sawa ko una̱ u kunya ku ne. Aza ɗa a sawa yi a ta̱na̱ ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Afarishi n awenishiki a Mele a roku a ɗa a wuta̱i a Urishelima, a ɓolomgbonoi ara Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","A wenei atoni a ne a roku a ka lya ilikulya bawu a sawai akere a le tyoku ɗa u gain. ");
INSERT INTO kdlNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Kpaci Afarishi n aza a Yahuda a tsu lya ilikulya bawu a sawai akere a le wa, adama a utono u agadu a nkoshi n cau n le. ");
INSERT INTO kdlNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","A wuta̱ baci a kuden, a tsu lya ilikulya wa, she a ɓacangusu ve kaci ka le. Agadu a roku a ɗa pini ushani a ɗa a ka kirana n a ɗa, tyoku u uza̱ u nko, na̱ njuju, n adele a irim.) ");
INSERT INTO kdlNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Afarishi n awenishiki a Mele a wece yi, “Ndya i zuwai bawu atoni a vunu a ka tono agadu a nkoshi n cau, aku a tsu rongo ulya ilikulya bawu a sawai akere a le tyoku ɗa u gain?” ");
INSERT INTO kdlNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","U wushunku le, “Dere ɗa Ishaya matsumate u danai a kaci ka ɗe, ‘Eɗa̱ aza a maci a kaɓan!’ Tyoku ɗa wa̱ri ukorongi, ‘Ama na yi n una̱ u ɗa a ka na̱ka̱ mu tsupige koshi, shegai a atakasuvu a yan ɗe mɓa̱ri na̱ mpa. ");
INSERT INTO kdlNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ugbashika u ɗa a ka gbashika mu vi u gbani u ɗa, kpaci mele ma a ka wenishike udani u vuma u ɗa.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yesu danai, “I varangi udani u Kashila̱, aku ya tono uwenishike u ama.” ");
INSERT INTO kdlNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Aku u tonuko le, “Mayun, i reve ta̱ uvarangu udani u Kashila̱ adama i toni agadu a ɗe! ");
INSERT INTO kdlNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kpaci Musa dana ta̱, ‘Na̱ka̱ tata na̱ mma u vunu tsupige; kpam uza ɗa baci dem u wishai tata u ne ko mma u ne, a ka wuna yi ta̱.’ ");
INSERT INTO kdlNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Shegai i tsu wenishike ta̱ ama a ɗe naha, vuma wa fuɗa ta̱ u bidya ikebe iꞌya i gain u ɓa̱nga̱ tata u ne na̱ mma u ne, aku u tonuko le ikebe i na yi Korba ɗa; (wata, kune ubana asu u Kashila̱). ");
INSERT INTO kdlNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","I buwa yi kpam uꞌa̱sa̱ka̱ u na̱ka̱ tata u ne ko mma u ne ili i roku wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","N ucun u uwenishike u na vi u ɗa i tsu wuna udani u Kashila̱. Kpam ili iꞌya pini icun i na yi ushani iꞌya i tsu yansa.” ");
INSERT INTO kdlNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","U doku u isa̱i ama, u tonuko le, “Pana̱ka numu gba̱ ɗe kpam i reve. ");
INSERT INTO kdlNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ili iꞌa̱ la a kateshe iꞌya ya uwa a asuvu a ikyamba i vuma i nangasa yi wa, she ili iꞌya ya wuta̱ a asuvu a ne iꞌya ya nangasa yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Uza ɗa baci wa̱ri n atsuvu a upana, u pana.” ");
INSERT INTO kdlNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","An u pecenei n kaɓolo ki, u uwai a kuwa. Atoni a ne a wece yi kalen ka agisani ki. ");
INSERT INTO kdlNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","U tonuko le, “Iꞌa̱ n ubidya u ukuna wa? Ili iꞌa̱ la a kateshe ya uwa vuma i nangasa yi wa vi. ");
INSERT INTO kdlNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kpaci i bana a asuvu a katakasuvu ka ne wa, shegai a katsuma̱ ka i banai, aku i wuta̱ yi.” Nala Yesu gonukoi gba̱ ilikulya i woko ili i ulya. ");
INSERT INTO kdlNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","U danai kpam, “Ili iꞌya i tsu wuta̱ a katakasuvu ka uza iꞌya i tsu nangasa yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kpaci a katakasuvu ka ukuna u cingi u tsu wuta̱, tyoku uyawunsa u cingi, n tsishankala, n uboki. Ka tsu tuko ta̱ dem ukuna u mawunuka, na̱ nvain n aka kaberikete. ");
INSERT INTO kdlNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Kurura n tsicingi dem nte a tsu wuta̱ pini. Katakasuvu ka tsu zuwa ta̱ dem ula̱pa̱na̱sa̱ n ukuna u cingi. Malyon dem n kunangasu, n ara̱ɗi n utengeshi a tsu wuta̱ dem pini. ");
INSERT INTO kdlNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Gba̱ ili i cingi i na yi asuvu a ɗa i tsu wuta̱, kpam i tsu nangasa ta̱ vuma.” ");
INSERT INTO kdlNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Pini nala, Yesu ꞌya̱nga̱i u banai evu n Taya n Sida. U uwai a kuwa ku roku, kpam wa ciga ko uza u reve wa, shegai wa̱ri ukpawan wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kute‑kute uka roku, uza ɗa makere ma ne ma̱ri n ityoni i cingi, u panai ukuna u ne, u tuwa̱i u kuɗa̱ngi a kapala ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Uka vi Kawulawa† ka, kagali ka ne kpam Kasurofiniki ka. U foloi Yesu wutukpa̱ maku ma ne mi ityoni yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu tonuko yi, “A̱sa̱ka̱ ve mmuku n cuwa̱. Kpaci ugan a varanku nshe ilikulya yi mmuku wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Shegai u wushunki yi, “Eye nala Asheku, shegai nshe n tsu lya ta̱ agashi a mmuku.” ");
INSERT INTO kdlNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Aku u tonuko yi, “Adama a kadyanshi ka vunu, gono a kuwa. Ityoni yi i pecemgbene ɗe n maku ma vunu.” ");
INSERT INTO kdlNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","U gonoi a kuwa u cinai maku mi nvain. Ityoni yi i wuta̱ ɗe a asuvu a ne mayun. ");
INSERT INTO kdlNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu a̱sa̱ka̱i kaɓon ka Taya, u tonoi a ilyuci i Sida u banai a Kushiva̱ ku Galili ku uyamba u Dikafoli. ");
INSERT INTO kdlNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ama roku a tuko yi kabebe kpam kagulani ka dem, aku a folo yi u taɗanku yi akere. ");
INSERT INTO kdlNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","U bidya yi a banai kapashi ka te dangi n kakuma̱ ki, aku u ukai ajubu a ne a atsuvu a vuma yi, u cikpa̱i ata̱tsa̱, aku u sawai kpam kaletsu ka vuma ki. ");
INSERT INTO kdlNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","U gaɗigbai kaci ka ne a zuba, u tsukpai kuvi ku pige, aku u tonukoi vuma vi, “Ifata!” (Wata, “Kukpa̱!”) ");
INSERT INTO kdlNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kute‑kute atsuvu a ne a kukpa̱i, a surukpa yi ili iꞌya i sira yi kaletsu, u ka̱na̱i kadyanshi mai. ");
INSERT INTO kdlNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Aku Yesu ɓarana le kotsu a tonuko uza ukuna vi wa, shegai uɓarana vi u wokoi yavu kakana ɗa u kakana le a ba a dansa kadyanshi ki. ");
INSERT INTO kdlNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Gba̱ aza ɗa a panai nala, a yain majiyan cika. A danai, “Ko ndya wa u yan ta̱ iꞌya mai! Hal n kagulani ka u zuwai ka panai, kabebe kpam ka yain kadyanshi.” ");
INSERT INTO kdlNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Aꞌayin a nala yi, an kakuma̱ ka doki ka ɓolomgbonoi, aꞌa̱ tani n ilikulya wa. Aku Yesu isa̱i atoni a ne, u tonuko le, ");
INSERT INTO kdlNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ma pana ta̱ asuvayali i kakuma̱ ka na ki, kpaci aꞌayin a le a tatsu a ɗa pa vi kaɓolo na̱ mpa bawu ilikulya. ");
INSERT INTO kdlNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","N wacinsa le baci a gono a kuwa n kambulu, a ka kpa̱ɗa̱ ta̱ a ure, aza roku tani a mɓa̱ri n ɗa a wuta̱i.” ");
INSERT INTO kdlNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Aku atoni a ne a danai, “Nte vuma wa tsa̱ra̱ ilikulya iꞌya wa lyatangu ama a na a kakamba ka na?” ");
INSERT INTO kdlNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","U wece le, “Iburodi i yain iꞌya iꞌa̱ri n iꞌya?” A danai, “I shindere iꞌya.” ");
INSERT INTO kdlNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Aku u zuwai kakuma̱ ki ka dusuki a iyamba. An u bidyai iburodi yi, u cikpai Kashila̱, u jiba̱mgba̱na̱sa̱i n u na̱ka̱si atoni a ne a bansa̱ka le, a bansa̱ka le tani. ");
INSERT INTO kdlNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Aꞌa̱ ta̱ tani n adan a shawu kenu. An u cikpai Kashila̱, u zuwai a bansa̱ka le a ɗa dem. ");
INSERT INTO kdlNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","A lyai, a cuwa̱i hal atoni yi a pura̱i abuwi a iburodi yi mbana n shindere. ");
INSERT INTO kdlNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ama yi tani a ka rawa ta̱ evu n azu a nishi. Aku u wacinsa le. ");
INSERT INTO kdlNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kute‑kute u uwai a kpatsu n atoni a ne a banai uyamba u Dalmanuta. ");
INSERT INTO kdlNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Afarishi a tuwa̱i a gita̱i uwecishe Yesu kotsu a kondo yi, a da u wenike le iryoci i zuba. ");
INSERT INTO kdlNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","U tsukpai kuvi ku pige, u danai, “Ndya i zuwai ama a gogo‑na a lai uciga uwene iryoci? N tonuko ɗa̱, iryoci iꞌa̱ la a ka wenike ama a gogo‑na wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Pini nala, u doku u uwai a kpatsu u pasai upashi u niɗe u a̱sa̱ka̱ le. ");
INSERT INTO kdlNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Atoni a Yesu a ciɓa a bidya burodi wa, she u te u ɗa aꞌa̱ri n u ɗa a kpatsu ki. ");
INSERT INTO kdlNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","U rono le atsuvu u danai, “I kirana n yisti u Afarishi n u Hiridu.” ");
INSERT INTO kdlNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","A yamgbanai kadyanshi utyoku u le, “An bawu tsa̱ri n burodi ɗa u zuwai u danai nala.” ");
INSERT INTO kdlNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","An Yesu revei nala aku u tonuko le, “Ndya i zuwai iꞌa̱ri a kadyanshi iꞌa̱ri n burodi wa? Dana hal n ara i wene wa, kpam i reve wa? Atakasuvu a ɗe ugbami u de ɗa aꞌa̱ri? ");
INSERT INTO kdlNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Eɗa la n aꞌeshi, ya wene wa ɗa? Iꞌa̱ ta̱ n atsuvu, ya pana wa ɗa? Kpam i tsu ciɓa wa ɗa? ");
INSERT INTO kdlNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","An n jiba̱mgba̱na̱sa̱ka̱i ama azu a tawun iburodi i tawun, mbana n yain n ɗa i cira̱ngi tipi tipi n abuwi a iburodi?” A danai, “Kupa na̱ n re.” ");
INSERT INTO kdlNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Iburodi i shindere iꞌya tani n jiba̱mgba̱na̱sa̱ka̱i ama azu a nishi tani, mbana tipi tipi n yain n ɗa i ta̱sa̱i n abuwi a iburodi?” A danai, “N shindere.” ");
INSERT INTO kdlNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Aku u wece le, “Hal n gogo‑na i reve wa ɗa?” ");
INSERT INTO kdlNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","A rawai a ilyuci i Besaida. Ama roku a tukoi Yesu karumba̱, a folo yi u sawa yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","U ka̱na̱i kukere ku karumba̱ ki, u banka yi a uroto u ilyuci. U cikpa̱i ata̱tsa̱ a aꞌeshi a karumba̱ yi, u taɗanki yi akere, aku u wece yi, “Fuɗa vu wene ili?” ");
INSERT INTO kdlNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Karumba̱ ki ka gaɗigbai kaci u danai, “Ma wundya ta̱ ama, shegai tyoku u nɗanga u ɗa ma wundya le a ka tamba.” ");
INSERT INTO kdlNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Aku u doki u taɗanki yi akere a aꞌeshi a ne. Aꞌeshi yi a kukpa̱i u ta̱na̱i, u wenei ko ndya wa mai. ");
INSERT INTO kdlNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu tonuko yi, “Wala vu gono a kuwa, kotsu vu uwa a une wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu n atoni a ne a ꞌya̱nga̱i a uwusai a une une u ilyuci i Kasariya Filibi. A ure u wecei atoni a ne, “Ya ama a ka dansa ma̱ri?” ");
INSERT INTO kdlNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","A tonuko yi, “Aza roku a danai aɗa Yahaya Kalyuɓugi, aza roku tani Iliya, aza roku tani, uza roku asuvu ntsumate.” ");
INSERT INTO kdlNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Aku u wece le, “Eɗa̱ tani ya ya dansa ma̱ri?” Bituru wushunki yi, “Avu Kawauwi ka.” ");
INSERT INTO kdlNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Aku u rono le atsuvu kotsu a tonuko uza ukuna u ne wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesu gita̱ le uwenishike, “U ka̱na̱ ta̱ Maku ma Vuma ma pana ikyamba cika. Nkoshi n aɗara̱kpi a pige n awenishiki a Mele a ꞌyuwan yi, hal a wuna yi. Aꞌayin a tatsu a wura baci, aku u ꞌya̱nga̱ n uma.” ");
INSERT INTO kdlNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","U danai kadyanshi ka nala tani a kateshe. Aku Bituru rono yi a ikengi, u gita̱ yi uɓara. ");
INSERT INTO kdlNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Shegai an Yesu kondonoi u wenei atoni a ne, u gita̱i uɓara Bituru, “Yan mɓa̱ri na̱ mpa, Kanangasi! Vu yan ukuna u Kashila̱ wa, she u ama.” ");
INSERT INTO kdlNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","U isa̱i kakuma̱ ki kaɓolo n atoni a ne, u danai, “Gba̱ uza ɗa baci wa ciga u tono mu she u ꞌyuwan kaci ka ne, u canga mawandamgbani ma ne u tono mu. ");
INSERT INTO kdlNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Gba̱ uza ɗa baci dem wa kirana n uma u ne, wa namba ta̱ u ɗa. Uza ɗa tani baci u nambai uma u ne adama a Kadyanshi ka Shinga ka va̱, wa wauwa ta̱ u ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nte kalen ka vuma wa tsa̱ra̱ likimba gba̱, aku u namba uma u ne? ");
INSERT INTO kdlNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ndya kpam vuma wa fuɗa wa na̱ka̱ a una̱ u uma u ne? ");
INSERT INTO kdlNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ama a gogo‑na aza a unyushi u cingi a ɗa aza ɗa kpatala̱kai Kashila̱ kucina̱. Adama a nala, uza ɗa baci dem wa pana uwono u ɗa wa yan kadyanshi ka va̱ aꞌayin a na, Maku ma Vuma ma pana ta̱ uwono u ne aꞌayin a ɗa baci ma tuwa̱ n tsupige tsu Tata n tsu atsumate a eri.” ");
INSERT INTO kdlNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Aku u tonuko le, “Mayun n tonuko ɗa̱, aza roku a ɗa pini kushani asu naha vi, a ka kuwa̱ wa, she a wene utuwa̱ u tsugono tsu Kashila̱ n ucira.” ");
INSERT INTO kdlNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","An aꞌayin a teli a wurai, Yesu bidyai Bituru, n Yakubu, n Yahaya, kaɓolo n eyi a banai a masasa ma roku ma ugaɗi, utyoku u le. Aku u yansa̱kai a kapala ka le. ");
INSERT INTO kdlNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Aminya a ne a wa̱ra̱ma̱i pun a ka laɗa, kaza̱i ka̱ la a likimba ka ka fuɗa ka zuwa a woko nala wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Aku atoni a ne ama a tatsu yi a wenei Musa n Iliya a tuwa̱i ara Yesu a ka yanka yi kadyanshi. ");
INSERT INTO kdlNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Bituru kukpa̱i una̱ u tonukoi Yesu, “Kawenishiki, u lobono ta̱ tsa̱ri pini na. A̱sa̱ka̱ tsu yain atani a tatsu, ka te ka vunu, ka te ka Musa ka te kpam ka Iliya.” ");
INSERT INTO kdlNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Uwonvo u ɗa u ka̱na̱ le cika, ɗa u nambai ili iꞌya wa dana. ");
INSERT INTO kdlNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Aku kalishi ka roku ka wuta̱i ka kimba̱ le. A panai kpam kala̱ga̱tsu ka wuta̱i pini a kalishi ki ka danai, “Maku ma va̱ ma na vi, uza ɗa ma ciga cika, pana̱ka ni.” ");
INSERT INTO kdlNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kute‑kute a weɓelei n maloko, a doku a wene kpam uza wa, Yesu ɗa a wenei koshi kaɓolo n ele. ");
INSERT INTO kdlNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Aꞌa̱ri ugida̱la̱ a masasa mi, aku Yesu rono le atsuvu u danai, “Kotsu i tonuko uza ili iꞌya i wenei vi wa, she aꞌayin a ɗa mpa Maku ma Vuma n ꞌya̱nga̱i a ukpa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","A a̱sa̱ka̱i ukuna vi a atakasuvu a le, a ka wecemgbene kalen ka uꞌya̱nga̱ a ukpa̱. ");
INSERT INTO kdlNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","A wece yi, “Ndya i zuwai awenishiki a Mele a danai Iliya ɗa wa gita̱ utuwa̱?” ");
INSERT INTO kdlNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Aku u tonuko le, “Mayun ɗa Iliya wa gita̱ utuwa̱ u lapula ili. Ko n nala ndya i zuwai kadyanshi ka Kashila̱ ka danai, Maku ma Vuma ma pana ta̱ ikyamba cika, aku a ꞌyuwan yi? ");
INSERT INTO kdlNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","N tonuko ɗa̱, Iliya tuwa̱ ɗe, kpam a yanka yi ɗe gba̱ ili iꞌya i yan le tyoku ɗa u luwa le, tyoku ɗa wa̱ri ukorongi a tagara̱da u Kashila̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","An a gonoi a asu u atoni a Yesu a ɗa buwai vi, a wenei kakuma̱ ka pige ka kyawan le. Awenishiki a Mele aꞌa̱ri kananamgbani n ele. ");
INSERT INTO kdlNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","N uwene Yesu, kakuma̱ ki gba̱ ka yain majiyan cika, a ɓosoi n ilyaɗi she ara ne, a dana̱sa yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","U wece le, “Kananamgbani ka iyen ka iꞌa̱ri a uyan n ele?” ");
INSERT INTO kdlNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Aku vuma roku a asuvu a kakuma̱ ki u wushunki yi, “Kawenishiki, maku ma va̱ ma n tuko vu, kpaci wa̱ ta̱ n ityoni i cingi i tsubebe. ");
INSERT INTO kdlNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Aꞌayin a ɗa baci dem i yuwa̱ yi she i varangi yi a iyamba, una̱ u ne u rongo kapufu, n u gbori aꞌanga a ne. Kpam she ugbama ko nte wa. N foloi atoni a vunu a wutukpa̱ yi iꞌya, shegai a kpa̱ɗa̱i.” ");
INSERT INTO kdlNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","U wushunku le, “Eɗa̱ niɗa ukpa̱ɗa̱ u upityanangu u ɗe wa̱ri! Hal ubana nwere ɗa ma dusuku n a̱ɗa̱ kahu i wushuku? Kpam hal ubana nwere ɗa ma fuɗa n kawunku n a̱ɗa̱? Tuko numu n eyi.” ");
INSERT INTO kdlNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","A tuko yi maku mi. An ityoni i cingi yi i wene yi, kute‑kute i gbashangi maku mi, ikyamba i ne n i jeyi, u rukpa̱i u rongoi uganda, una̱ u ne wa̱ri kapufu. ");
INSERT INTO kdlNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu wecei tata u maku vi, “Aꞌayin a eni a ɗa ili yi i gita̱ yi?” U danai, “Tun eyi kenu. ");
INSERT INTO kdlNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","I so yi ta̱ uvarangusu a asuvu akina n mini kotsu i wuna yi. Shegai va fuɗa baci, pana asuvayali a tsunu vu ɓa̱nga̱ tsu.” ");
INSERT INTO kdlNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu tonuko yi, “Vu da ma fuɗa baci? Uza ɗa baci dem u wushuki, a ka yanka yi ta̱ ko ndya wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kute‑kute tata u maku vi u ꞌya̱nga̱sa̱i kala̱ga̱tsu, u danai, “N wushuku ta̱. Ɓa̱nga̱ mu n ukpa̱ɗa̱ u uwushuku u va̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","An Yesu wenei kakuma̱ ki ka̱ri utuwa̱ n ilyaɗi a asu vi, u ɓaranai ityoni i cingi yi u tonuko yi, “Avu ityoni i cingi i tsubebe, n tonuko vu pecemgbene n eyi, kotsu vu doku vu uwa yi wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Aku ityoni yi i salai, i gbashangi maku mi cika, ikyamba i ne ya je, pini nala i pecemgbenei n eyi. Maku mi ma wokoi yavu kakushe, hal gba̱m ama ushani a danai, “U kuwa̱ ɗe.” ");
INSERT INTO kdlNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Shegai Yesu ka̱na̱i kukere ku ne u ꞌya̱nga̱sa̱ yi, u ꞌya̱nga̱i tani n kushani. ");
INSERT INTO kdlNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","An Yesu tuwa̱i u uwai a kuwa, atoni a ne a wece yi ukpawunsi, “Ndya i zuwai a̱tsu tsu kpa̱ɗa̱i iꞌya uwutukpa̱?” ");
INSERT INTO kdlNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Aku u tonuko le, “Ucun u nala u tsu wuta̱ wa, she n kavasu.” ");
INSERT INTO kdlNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Pini nala, Yesu n atoni a ne a ꞌya̱nga̱i a ɓa̱tsa̱mgba̱na̱i a uyamba u Galili, wa ciga tani uza u reve wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Kpaci atoni a ne a ɗa wa wenishike, wa tonusuko le, “A ka neke ta̱ Maku ma Vuma akere a ama a wuna yi. A wuna yi baci, aꞌayin a tatsu a wurai, wa ꞌya̱nga̱ ta̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Shegai a reve ili iꞌya kadyanshi ki ka tono wa, kpam a panai uwonvo u ɗa a ka wece yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","A tuwa̱i a Kafarnahum. An u uwai a kuwa, u wece le, “Kananamgbani ka iyen ka iꞌa̱ri uyan a ure?” ");
INSERT INTO kdlNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","A paɗai bini, kpaci a ure vi a nanamgbana ta̱ ko ya uzapige u le. ");
INSERT INTO kdlNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Aku u dusuki u isa̱i Kupanamere vi, u tonuko le, “Uza ɗa baci dem wa ciga u woko uza u kapala, u ka̱na̱ ta̱ she u woko uza u makorishi a asuvu a ama gba̱. Kpam u gbashika ko ya wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Aku u bidyai maku ma kenu u zuwa yi a mere ma le, u woɓo yi u tonuko le, ");
INSERT INTO kdlNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Uza ɗa baci dem u wushai maku ma kenu ucun u na adama a kala ka va̱, mpa u wushai. Uza ɗa kpam u wusha mu, mpa koshi u wushai wa, hal n uza ɗa suku mu ɗa u wushai.” ");
INSERT INTO kdlNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Aku Yahaya tonuko yi, “Kawenishiki, tsu wene ta̱ vuma roku wa wutukpusa̱ ityoni i cingi n kala ka vunu, aku tsu ɓishinka yi kpaci wa̱ a asuvu a tsunu wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Shegai Yesu danai, “Ɓishinka ni wa. Vuma wa̱ la wa yan ukunosavu n kala ka va̱, aku u laza kute‑kute u dana ukuna u gbani kaci ka va̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","“Gba̱ uza ɗa baci dem bawu wa yan tsilala n a̱tsu, uza u tsunu u ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Uza ɗa baci dem u ne ɗa̱ mini ma uso a mako adama a ɗa iꞌa̱ri aza a Kawauwi, n tonuko ɗa̱, maken ma̱ la wa, wa kpa̱ɗa̱ utsa̱ra̱ katsupi ka malen ma manyan ma ne wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yesu lyai kapala n kadyanshi, “Ɗa vuma roku wa zuwa maku ma te a asuvu a mmuku n kenu n na aza ɗa a pityanangi na̱ mpa u nusa, wa laka ta̱ a sira̱ka yi katali ka kira ka pige a udyoku u ne, a varangi yi a asuvu a kushiva̱. ");
INSERT INTO kdlNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kukere ku vunu ka zuwusa vu baci unyushi, kiɗa ka. Wa laka vu ta̱ shana vu tsa̱ra̱ uma n kukere ku te, n u ɗa va uwa akina n akere a re, akina a ɗa bawu aꞌa̱ri ucimba̱. ");
INSERT INTO kdlNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Asu u azun a ɗa a ka takuma a ɗa bawu a ka kuwa̱, kpam a ka cimbusa̱ akina yi wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kune ku vunu ka zuwusa vu baci unyushi, kiɗa ka. Wa laka vu ta̱ shana vu tsa̱ra̱ uma n kune ku te, n u ɗa a ka varangu vu akina n aꞌene a vunu a re. ");
INSERT INTO kdlNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Asu u azun a ɗa a ka takuma a ɗa bawu a ka kuwa̱, kpam a ka cimbusa̱ akina yi wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Keshi ka vunu ka zuwusa vu baci unyushi, foɗo ka. Wa laka vu ta̱ vu uwa a tsugono tsu Kashila̱ n keshi ka te, n u ɗa a ka varangu vu akina n aꞌeshi a re. ");
INSERT INTO kdlNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Asu u azun a ɗa a ka takuma a ɗa bawu a ka kuwa̱, kpam a ka cimbusa̱ akina yi wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“N akina a ɗa a ka wulukpe ya dem, tyoku ɗa a tsu wulukpe uɗara̱kpa na̱ mkpaɗi. ");
INSERT INTO kdlNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Mkpaɗi ili iꞌya i shinga, shegai n namgba baci bawu n yankpai kpam, n iyen iꞌya a ka yankpusa n ɗa? “I rongo tyoku u mkpaɗi a asuvu a ɗe, i dusuku ndishi n shinga n atoku a ɗe.” ");
INSERT INTO kdlNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu ꞌya̱nga̱i pini a asu vi, u banai a uɓongu u Yahuda a upashi u Aga̱ta̱ a Urudu. Aku kakuma̱ ka ama ka doki ka ɓolomgbonoi a asu u ne, u wenishike le tyoku ɗa u cuwana̱kai. ");
INSERT INTO kdlNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Afarishi a roku a tuwa̱i ara ne a ka ciga a wandi yi, a wece yi, “U gan vuma u a̱sa̱ka̱ uka u ne?” ");
INSERT INTO kdlNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","U wushunku le, “Ndya Musa tonuko ɗa̱ i yain?” ");
INSERT INTO kdlNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","A danai, “Musa wushuku ta̱ vali wa fuɗa ta̱ u korongu tagara̱da u upece iyolo u a̱sa̱ka̱ uka u ne.” ");
INSERT INTO kdlNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu wushunku le, “Adama a uryagbaji u ɗe ɗa i zuwai Musa koronku ɗa̱ mele ma nala mi. ");
INSERT INTO kdlNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Shegai a kagita̱ Kashila̱ ka yan le ta̱ vali n uka. ");
INSERT INTO kdlNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Adama a nala, vali u a̱sa̱ka̱ tata u ne na̱ mma u ne, u paɗara n uka u ne. ");
INSERT INTO kdlNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Kpam ama a re a le gba̱ a woko ikyamba i te. A buwa kpam ama a re wa, shegai uza u te. ");
INSERT INTO kdlNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Adama a nala ili iꞌya baci Kashila̱ ka gawain, kotsu vuma u peci iꞌya wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","An a gonoi a kuwa, atoni a ne a doku a wece yi ukuna u nala vi. ");
INSERT INTO kdlNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","U wushunku le, “Uza ɗa baci dem u a̱sa̱ka̱i uka u ne u zuwai u roku, tsishankala tsa wa yan n eyi. ");
INSERT INTO kdlNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Uka u a̱sa̱ka̱ baci tani vali u ne, aku u banai uza roku iyolo, tsishankala tsa dem wa yan.” ");
INSERT INTO kdlNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ama a ka tukuso mmuku n kenu ara Yesu kotsu u sawa le, aku atoni a ne a ɓarana le. ");
INSERT INTO kdlNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","An Yesu wenei nala, u panai upan. U tonuko le, “A̱sa̱ka̱i mmuku n kenu‑kenu n tuwa̱ ara va̱, ɓishinka le wa, kpaci tsugono tsu Kashila̱ tsu icun i le tsa. ");
INSERT INTO kdlNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mayun n tonuko ɗa̱, uza ɗa baci dem bawu u wushai tsugono tsu Kashila̱ tyoku ɗa maku ma kenu ma tsu yan, wa uꞌuwa tsa wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Aku u woɓuso le u taɗanku le akere, u zuwusuka le una̱ u shinga. ");
INSERT INTO kdlNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Gita̱ ɗa u gita̱i nwalu, aku vuma roku u wuranai n ilyaɗi, u kuɗa̱ngi a kapala ka ne u danai, “Kawenishiki ka shinga, ndya ma yan n tsa̱ra̱ uma u ɗa bawu wa̱ri n utyoku?” ");
INSERT INTO kdlNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu wece yi, “Ndya i zuwai vu isa̱ mu uza u shinga? Uza u shinga wa̱ la wa, she Kashila̱ koshi. ");
INSERT INTO kdlNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Vu reve ta̱ gai mele mi. Kotsu vu wuna uma u vuma gbani wa. Kotsu vu vaku n uka ɗa bawu wa̱ri u vunu wa. Kotsu vu boko wa. Kotsu vu sira̱ka kaɓan kaɓetsu wa. Kotsu vu ryafa uza wa. Vu na̱ka̱ tata na̱ mma u vunu tsupige.” ");
INSERT INTO kdlNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","U danai, “Kawenishiki, tun mpa kenu ɗa ma tono ili i nala yi.” ");
INSERT INTO kdlNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu weɓele yi n aꞌeshi a uciga, u danai, “Ili i te iꞌya i buwa vu koshi, ba vu denge gba̱ ili iꞌya va̱ri n iꞌya, vu ɓa̱nga̱ aza a unambi, tsa̱ra̱ vu yain n utsa̱ri a zuba. Aku vu tuwa̱ vu tono mu.” ");
INSERT INTO kdlNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","N upana kadyanshi ka nala ki, katakasuvu ka ne ka rukpa̱i, aku u lazai n unamgbi u asuvu, kpaci wa̱ ta̱ n utsa̱ri cika. ");
INSERT INTO kdlNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu weɓelei atoni a ne, u tonuko le, “U wuyana tani n ni, uza u utsa̱ri u uwa tsugono tsu Kashila̱?” ");
INSERT INTO kdlNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Atoni a ne yi a yain majiyan ma kadyanshi ka ne. Aku Yesu doku u tonuko le, “Mmuku n va̱, u wuyana tani n ni uza u utsa̱ri u uwa tsugono tsu Kashila̱? ");
INSERT INTO kdlNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Wa la ta̱ shana karakuma ka wura a kpele ka kujulu n u ɗa uza u utsa̱ri wa uwa a tsugono tsu Kashila̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Atoni yi a lapulai a yain majiyan cika, aku a ka wecemgbene, “Nala baci ya wa̱ la vi wa tsa̱ra̱ iwauwi?” ");
INSERT INTO kdlNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","U wundyana le, u danai, “A asu u ama ili i uyan iꞌya wa, shegai a asu u Kashila̱ ili dem i uyan iꞌya.” ");
INSERT INTO kdlNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Bituru tonuko yi, “A̱tsu wa̱ tani na, aza ɗa tsu a̱sa̱ka̱i gba̱ ili i tsunu tsu tono vu?” ");
INSERT INTO kdlNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","U wushuki, “Mayun n tonuko ɗa̱, uza ɗa baci dem u a̱sa̱ka̱i kuwa n kashina ka ne adama a va̱ n kadyanshi ka va̱, wa wusha ta̱ ili iꞌya i lai iꞌya u a̱sa̱ka̱i vi kakuma̱ aꞌayin a gogo‑na. Wa tsa̱ ta̱ aꞌuwa amangatawun (100), hal n ashina dem kaɓolo n mavura. Nala kpam dem uza ɗa baci u a̱sa̱ka̱i atoku n ama̱ku na̱ mma n tata na̱ mmuku n ne adama a va̱, wa tsa̱ ta̱ amangatawun u atoku n ama̱ku na̱ mma n tata na̱ mmuku kaɓolo n mavura. Kpam aꞌayin a ɗa a ka tuwa̱ wa tsa̱ ta̱ uma u ɗa bawu wa̱ri n utyoku. ");
INSERT INTO kdlNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Shegai aza ɗa aꞌa̱ri a kapala ushani a ka woko ta̱ makorishi, aza a makorishi tani a kapala.” ");
INSERT INTO kdlNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu n atoni a ne a lyai kelime na̱ nwalu ubana a Urishelima, kpam aya a kapala. Atoni yi a yain majiyan, aza ɗa a ka tono yi kpam a panai uwonvo. U doku u pura̱i Kupanamere vi paki, u tonuko le ili iꞌya ya ba i rukpa̱ a kaci ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","U danai, “A̱tsa na tsa bana a Urishelima. A ka neke ta̱ Maku ma Vuma a akere aɗara̱kpi a pige n awenishiki a Mele. A ka kiɗa̱ga yi ta̱ ugana u ukpa̱, aku a neke yi a akere a Awulawa. ");
INSERT INTO kdlNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","A ka yanka yi ta̱ majari, a cikpunka̱ yi ata̱tsa̱, a bawan yi, aku a wuna yi. Aꞌayin a tatsu a wura baci, aku u ꞌya̱nga̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Aku Yakubu n Yahaya mmuku n Zabidi a tuwa̱i ara Yesu, a danai, “Kawenishiki, tsa ciga ta̱ vu yanka tsu ukuna u roku tsu folo vu baci.” ");
INSERT INTO kdlNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","U wece le, “Ndya ya ciga n yanka ɗa̱?” ");
INSERT INTO kdlNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","A wushuki, “Kain ka va dusuku a tsugono tsu pige tsu vunu, a̱sa̱ka̱ uza u te u tsunu u dusuku a ulyaki u vunu, uza u ire tani a ugula̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","U danai, “I reve ili iꞌya ya folo vi wa. Ya fuɗa ya so mako ma upana ikyamba tyoku ɗa mpa ma tuwa̱ n soi ko a lyuɓugu ɗa̱ tyoku ɗa a ka lyuɓugu mu?” ");
INSERT INTO kdlNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","A danai, “Tsa fuɗa ta̱.” U tonuko le, “Ya fuɗa ta̱ ya so mako ma upana ikyamba tyoku ɗa ma so, a lyuɓugu ɗa̱ tyoku ɗa a ka lyuɓugu mu. ");
INSERT INTO kdlNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Shegai ndishi a ulyaki ko a ugula̱ u va̱, mpa ma na̱ka̱ wa. U aza ɗa Kashila̱ ka foɓusukoi u ɗa.” ");
INSERT INTO kdlNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","An atoni a ne kupa ɗa a buwai a panai nala, a gita̱i upana upan u Yakubu n Yahaya. ");
INSERT INTO kdlNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu isa̱ le gba̱ a asu u te, u danai, “Aza ɗa a revei n tsugono tsu Awulawa, a tsu wenike le ta̱ ucira, kpam ngono n pige n tsu wenike le ta̱ ucira cika. ");
INSERT INTO kdlNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Shegai ara ɗe nala wa, uza ɗa baci dem wa ciga u woko uzapige a mere ma ɗe, u ka̱na̱ ta̱ u woko kagbashi ka ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kpam ko ya baci wa ciga u woko a kapala, u ka̱na̱ ta̱ u woko kagbashi ka ama gba̱. ");
INSERT INTO kdlNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kpaci Maku ma Vuma ma tuwa̱ adama a ɗa a ka gbashika yi wa, shegai u gbasha, u na̱ka̱ kpam uma u ne katsupi adama a ama ushani.” ");
INSERT INTO kdlNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesu n atoni a ne a rawai a ilyuci i Jeriko kaɓolo n kakuma̱ ka ama ushani. An a ka wuta̱ a ilyuci yi, karumba̱ ka roku ndishi a ikengi i ure wa folo. Kala ka ne ka Batimawu maku ma Timawu. ");
INSERT INTO kdlNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","An u panai Yesu uza u Nazara ɗa, u gita̱i isali, “Yesu, maku ma Dawuda, pana asuvayali a va̱!” ");
INSERT INTO kdlNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ama ushani a ɓarana yi a tonuko yi u paɗa, shegai u lapulai u salai cika, “Maku ma Dawuda, pana asuvayali a va̱!” ");
INSERT INTO kdlNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu shamgbai, u danai, “Isa̱ ni.” Aku a ba a isa̱ yi, a tonuko yi, “Pana kayanyan! ꞌYa̱nga̱! Wa isa̱ vu.” ");
INSERT INTO kdlNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Aku u varangi kunya ku uwambana ku ne, u ꞌya̱nga̱i n ucira she ara Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu wece yi, “Ndya va ciga n yanka vu?” U danai, “Kawenishiki, ma ciga n wene asu.” ");
INSERT INTO kdlNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu danai, “Wala, upityanangu u vunu u ta̱na̱sa̱ vu ɗe.” Kute‑kute u lazai u wenei asu, aku u tonoi Yesu a lazai. ");
INSERT INTO kdlNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","An Yesu n atoni a ne a yain evu n Urishelima, n Betafaji, n Batani a asu u Masasa ma Zayitum, u suki atoni a ne a re. ");
INSERT INTO kdlNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","U tonuko le, “Uwai a une u ɗa wa̱ri a kapala ka ɗe nala vi, n uꞌuwa u ɗe ya wene ta̱ maku ma makparyagi ma bawu a taɓai uyuwa̱ usiri. I surukpa ma i tuko. ");
INSERT INTO kdlNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Uza ɗa baci dem u wece ɗa̱ ili iꞌya i zuwai ya tatsukpa ma, i tonuko yi, ‘Asheku a ɗa a ka ciga ma, kpam wa gonuko ta̱ ma gogo‑na.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Aku a lazai a ba a cinai maku ma makparyagi mi usiri a uwotsu u kuwa evu n ure. An a ka surukpa ma, ");
INSERT INTO kdlNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ama ɗa aꞌa̱ri pini kushani a asu vi a wece le, “Ndya i zuwai ya surukpa ma?” ");
INSERT INTO kdlNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","A wushunku le tyoku ɗa Yesu tonuko le, aku ama yi a a̱sa̱ka̱ le a lazai. ");
INSERT INTO kdlNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","An a tuko yi maku ma makparyagi mi, a polusoi aminya a upala̱ka a le a zuba u ne, aku u yuwa̱i. ");
INSERT INTO kdlNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ama ushani a polusoi aminya a upala̱ka a le a ure, aza roku tani a polusoi avuku a ɗa a sata̱sai a agbaji. ");
INSERT INTO kdlNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Aza a kapala n aza a kucina̱ a rongoi isali n a dansi, “Hosana, cikpalai Kashila̱! Kashila̱ ka zuwuka uza ɗa u tuwa̱i n kala ka Magono ma Zuba una̱ u shinga! ");
INSERT INTO kdlNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kashila̱ ka zuwuka tsugono tsu tata u tsunu Dawuda tsa tsa tuwa̱ na vi una̱ u shinga! Hosana, cikpalai Kashila̱!” ");
INSERT INTO kdlNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Aku u uwai a Urishelima u uwai a Kuwa ku Kashila̱. An u weɓelishei ko ndya wa, u wenei kaara ka kotsoi, aku u wuta̱i u banai a Batani kaɓolo n Kupanamere vi. ");
INSERT INTO kdlNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","An kain ka wansai, a a̱sa̱ka̱i Batani, Yesu panai kambulu. ");
INSERT INTO kdlNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","An u wenei maɗanga ma kapopi ma ma̱ri n avuku a mɓa̱ri, u ba u weɓelei ko ma matsa. An u rawai a asu vi, u wene ili wa she avuku, kpaci aꞌayin a ilimaci a kapopi a ɗa wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Aku u tonukoi kapopi ki, “Uza wa doku wa lya kpam ilimaci i kapopi ara vunu wa.” Kpam atoni a ne a pana̱ka yi ta̱ u danai nala. ");
INSERT INTO kdlNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","N urawa a Urishelima, Yesu uwai a Kuwa ku Kashila̱, aku u gita̱i uloko aza ɗa a ka tsila n a dengi pini. U mutsukpusa̱i iteburu i aza a usavaɗa̱sa ikebe n ikirika i adengi ntambara. ");
INSERT INTO kdlNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kpam u a̱sa̱ka̱ uza ɗa u cangai ili i roku u wura pini a ulanga u Kuwa ku Kashila̱ ki wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Aku u wenishike le u danai, “A korongu wa, a da ‘A ka isa̱ kuwa ku va̱ kuwa ku kavasu ka ama a iyamba gba̱ wa.’? Shegai eɗa̱ i gonukoi ka kaaɓuru ka aza a maga̱la̱ka̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","An aɗara̱kpi a pige n awenishiki a Mele a panai, a gita̱i ubolo ure u ɗa a ka wuna yi, kpaci a ka pana ta̱ uwonvo u ne an ama gba̱ a yain majiyan n uwenishike u ne. ");
INSERT INTO kdlNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","An kuvuli ku yain, aku a a̱sa̱ka̱i ilyuci yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","An a ka wura n usana, aku a wenei maɗanga mi ma ekpei hal n alu. ");
INSERT INTO kdlNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Bituru ciɓai, aku u tonukoi Yesu, “Kawenishiki, weɓele, maɗanga ma vu yankai una̱ vi ma ekpe ɗe.” ");
INSERT INTO kdlNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","U wushunku le, “Pityanangi n Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mayun n tonuko ɗa̱, vuma ɗa baci dem u tonukoi masasa ma na, ‘Muɗa̱ ba vu rukpa̱ a kushiva̱,’ kpam bawu u yain mala̱la̱ a katakasuvu ka ne, shegai u pityanangi ili iꞌya u danai, a ka yanka yi ta̱ iꞌya. ");
INSERT INTO kdlNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Adama a nala n tonuko ɗa̱, ili iꞌya baci dem i foloi n kavasu, wushuki i tsa̱ra̱ iꞌya ɗe, kpam ya woko ta̱ i ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Aꞌayin a ɗa baci dem i shamgbai uyan kavasu, iꞌa̱ baci n uza ɗa ya pana upan, cimbusuka̱ ni. Tata u ɗe uza ɗa wa̱ri a zuba wa cimbusuka̱ ɗa̱ ta̱ dem unyushi u cingi u ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Shegai i cimbusuka̱ baci ama wa, nala dem Tata u ɗe uza ɗa wa̱ri a zuba wa cimbusuka̱ ɗa̱ unyushi u cingi u ɗe wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","A doki a gonoi a Urishelima, tyoku ɗa Yesu wa̱ri nwalu a asuvu a Kuwa ku Kashila̱, aɗara̱kpi a pige n awenishiki a Mele na̱ nkoshi n pige a tuwa̱i ara ne. ");
INSERT INTO kdlNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","A wece yi, “N ucira u eni u ɗa va yansa ili i naha gba̱? Kpam ya na̱ka̱ vu ucira u ɗa va yansa iꞌya?” ");
INSERT INTO kdlNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","U wushunku le, “Ma yan ɗa̱ ta̱ dem keci. I wushunku mu baci, mpa dem ma tonuko ɗa̱ ta̱ ucira u ɗa ma yansa̱ka ili i na yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Tonuko numu: Ucira u ulyuɓugusu u Yahaya a zuba ɗa u wuta̱i ko a asu u ama?” ");
INSERT INTO kdlNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","A dansai utyoku u le a danai, “Tsu dana baci a zuba ɗa u wuta̱i, wa dana ta̱ ndya i ɓishinka tsu uwushuku n eyi? ");
INSERT INTO kdlNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kpam tsu dana baci a asu u ama ɗa u wuta̱i, kakuma̱ ka na ka pana ta̱ upan u tsunu.” A panai uwonvo u kakuma̱ ki, kpaci ya dem u bidya ta̱ Yahaya matsumate ma. ");
INSERT INTO kdlNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Aku a wushunki yi a danai, “Tsu reve wa.” Aku u tonuko le, “Mpa dem ma tonuko ɗa̱ ko ucira u eni u ɗa ma yansa̱ka ili i na yi wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu gita̱ le uyanka kadyanshi n agisani u danai, “Vuma roku u ɗa u yain kashina ka cinwi, u kanzai ka u ga̱va̱i kaɗa̱ka̱ ka ukpokuso ilimaci i cinwi yi. U mai kpam kunukuzuba ku uza u uwundya kashina ki. Aku u na̱ka̱i acimbi a roku haya u lazai nwalu. ");
INSERT INTO kdlNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","An aꞌayin a uta a yain, u suki kagbashi ka ne ka te a asu u aza a haya yi u wushika yi a asuvu ucanga u kashina vi. ");
INSERT INTO kdlNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Acimbi yi a ka̱na̱ yi a lapai, aku a loko yi akere a de. ");
INSERT INTO kdlNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Aku u doku u sukunku le kagbashi ka roku, eyi kpam a gbasha yi a kaci, a yanka yi uwono. ");
INSERT INTO kdlNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","U doki u suki kpam uza roku, eyi tani a wuna yi. Nala u sukusi ama ushani, a lapusai aza roku, aza roku tani a wunusa le. ");
INSERT INTO kdlNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","U buwai n uza u te, maku ma ne ma wa ciga cika. A makorishi u suki yi, u danai, ‘A ka wene ta̱ karinga̱ ka maku ma va̱!’ ");
INSERT INTO kdlNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Shegai aza a haya yi a sheshei utyoku u le, ‘Maku ma kagita̱ ma ne ma gai pa vi. Tuwa̱i tsu wuna ni, tsa̱ra̱ agadu yi a woko a tsunu.’ ");
INSERT INTO kdlNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Aku a ka̱na̱ yi a wunai, a varangi yi a uroto u kashina vi. ");
INSERT INTO kdlNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Ndya uza u kashina vi wa yan? Wa tuwa̱ ta̱ u wuna aza a haya yi, u na̱ka̱ ka aza roku. ");
INSERT INTO kdlNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","I taɓa uyan ka̱neshi a tagara̱da u Kashila̱ naha wa? ‘Katali ka aza a kuma a ꞌyuwain, ka ka lakai kalen cika a asu u kuma. ");
INSERT INTO kdlNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Manyan ma Asheku ma la vi, ara tsunu tani ili i majiyan iꞌya.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Azapige a aza a Yahuda yi a bolo ta̱ kotsu a ka̱na̱ yi, kpaci a reve ta̱ a kaci ka le ka u yain agisani yi. Shegai a ka pana ta̱ uwonvo u ama, adama a nala a a̱sa̱ka̱ yi u lazai. ");
INSERT INTO kdlNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","An nala wurai, azapige a aza a Yahuda yi a sukunki Yesu Afarishi a roku n ama a Hiridu a wandi yi n keci. ");
INSERT INTO kdlNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","An a rawai ara ne, a tonuko yi, “Kawenishiki, tsu reve ta̱ vu tsu dansa ta̱ ukuna u mayun, kpam ya dem una̱ u te ɗa vu bidya yi. Aꞌayin a ɗa dem va wenishike ukuna u Kashila̱, vu tsu dansa ta̱ ukuna u mayun, vu tsu dambula n ukuna u ɗa azapige a tsu dansa a kaci ka vunu wa. Tonuko tsu, ugan tsu tsupa Kaisa magono utafa?” ");
INSERT INTO kdlNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tsu tsupa ko tsu kpa̱ɗa̱ utsupa? Eyi tani an u revei wanda ɗa a ka wanda yi, u tonuko le, “Ndya i zuwai ya kondo mu? Tuko numu ukebe u azurufa n wene.” ");
INSERT INTO kdlNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","A tuko yi. Aku u wece le, “Kulu n kala ka yai ka ka̱ri pini a ukebe vi?” A danai, “Ku Kaisa ka.” ");
INSERT INTO kdlNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Aku u tonuko le, “Na̱ka̱i Kaisa ili iꞌya iꞌa̱ri i Kaisa; Kashila̱ kpam i na̱ka̱ yi ili iꞌya iꞌa̱ri i Kashila̱.” A yain majiyan cika. ");
INSERT INTO kdlNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Aku aza a Sadusi† (aza ɗa bawu a wushuki n uꞌya̱nga̱ u ukpa̱) a tuwa̱i ara Yesu, a wece yi, ");
INSERT INTO kdlNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Kawenishiki, Musa koronku tsu ta̱ a kaci ka tsira̱na̱. U da uza u kuwa̱ baci u a̱sa̱ka̱i uka bawu mmuku, u ka̱na̱ ta̱ utoku u ne u sotuku uka vi u matsa̱ka yi mmuku. ");
INSERT INTO kdlNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","A yan ta̱ aꞌali a roku ama a shindere, uza n utoku u ne. Uza u kagita̱ u zuwai uka, u kuwa̱i u a̱sa̱ka̱ maku wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Uza u ire (uza ɗa u tono yi) u sotuki mara̱na̱ mi, eyi dem u kuwa̱i u a̱sa̱ka̱ maku wa. Nala dem n uza u tatsu. ");
INSERT INTO kdlNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Gba̱ le gai uza wa̱ la u a̱sa̱ka̱i maku wa. A makorishi uka vi dem u kuwa̱i. ");
INSERT INTO kdlNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kain ka uꞌya̱nga̱ a ukpa̱, uka u yai u ɗa wa woko, cinda gba̱ le a zuwusa yi?” ");
INSERT INTO kdlNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu wushuki, “An bawu i revei Tagara̱da u Kashila̱,† kpam i reve ucira u Kashila̱ wa, ɗa i zuwai i puwa̱in. ");
INSERT INTO kdlNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kpaci a ꞌya̱nga̱ baci a ukpa̱ a ka yan iyolo wa, kpam a ka wutukpa̱ iyolo wa. Shegai tyoku u atsumate a zuba a ɗa a ka woko. ");
INSERT INTO kdlNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","A ukuna u uꞌya̱nga̱ u akushe, i taɓa uka̱neshi a tagara̱da Musa a asu u alabari a maku ma maɗanga ma ma tasa akina wa, an Kashila̱ ka danai, ‘Mpa Kashila̱ ka Ibirahi, Kashila̱ ka Ishaku, n Kashila̱ ka Yakubu?’ ");
INSERT INTO kdlNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Eyi Kashila̱ ka akushe ka wa, shegai ka aza a uma. Mayun ɗa i puwa̱in.” ");
INSERT INTO kdlNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Aku kawenishiki ka Mele ka roku ka tuwa̱i ka pana̱ka le aꞌa̱ri kananamgbani. An u wenei Yesu wushunku le mai, aku u wece yi, “Gba̱ a asuvu a mele, ma eni ma ma lai ugbonguro?” ");
INSERT INTO kdlNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","U wushunku yi, “Ma ma lai ugbonguro ma, ‘Panai, aza a Isaraꞌila! Magono ma Zuba Kashila̱ ka tsunu, aya koshi Magono ma Zuba. ");
INSERT INTO kdlNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ciga Magono ma Zuba Kashila̱ ka vunu n katakasuvu ka vunu n uma u vunu gba̱. Vu cigi yi kpam n kakiri ka vunu n ucira u vunu gba̱.’ ");
INSERT INTO kdlNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ma ma tono yi tani ma, ‘Ciga uza u karen u vunu tyoku ɗa va ciga kaci ka vunu.’ Mele ma roku ma̱ la ma ma lai ma nala mi wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Aku kawenishiki ka Mele ka danai, “Mayun ɗa vu, Kashila̱ ka te ka, uza roku wa̱ tani la wa, she eyi. ");
INSERT INTO kdlNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","A cigi yi gba̱ n katakasuvu, gba̱ n kakiri, gba̱ n ucira. Kpam vu cigi uza u karen u vunu tyoku ɗa va ciga kaci ka vunu, ili i na yi i la ta̱ uɗara̱kpa u urunukpa n ukiɗa̱sa a mɓa̱ri.” ");
INSERT INTO kdlNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","An Yesu wenei u wushunki yi mai, u tonuko yi, “Va̱ mɓa̱ri n tsugono tsu Kashila̱ wa.” Pini nala, uza u doku kawan kpam u wece yi wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","An Yesu wa wenishike a Kuwa ku Kashila̱, u wecikei, “Niɗa awenishiki a Mele a ka dana Kirisiti Kawauwi maku ma Dawuda magono ma? ");
INSERT INTO kdlNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kulu Keri ku zuwai Dawuda danai, ‘Magono ma Zuba ma tonukoi Asheku a va̱, dusuku a ulyaki u va̱, hal she n taɗangu vu a zuba u atokulalu a vunu.’ ");
INSERT INTO kdlNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Dawuda n kaci ka ne u isa̱ baci Kawauwi Asheku, niɗa wa yansa u woko maku ma Dawuda?” Kakuma̱ ka pana̱ka yi n ipeli. ");
INSERT INTO kdlNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Tyoku ɗa wa wenishike le, u danai, “Kiranai n awenishiki a Mele aza ɗa a ka ciga kutambu n aminya a pige. A tsu la ta̱ uciga a dana̱sa le a kuden n tsupige. ");
INSERT INTO kdlNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kpam a lai n uciga a asu u ndishi u ɗa u lai tsulobo a agata a Kashila̱, n a asu u shinga a asu u abiki. ");
INSERT INTO kdlNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Shegai a tsu lyasa ta̱ ucanga u nra̱na̱, a rongo kpam uyansa kavasu ka ugaɗi adama a ukimbusa̱ u aꞌeshi. Icun i ama a nala a ka yan le ta̱ mavura cika.” ");
INSERT INTO kdlNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu dusuki evu a asu u uzuwusa u ikebe u Kuwa ku Kashila̱, wa wundya tyoku ɗa ama a ka zuwusa ikebe a asu u uzuwusa u ikebe vi. Aza a utsa̱ri ushani a tsungi pini ikebe ushani. ");
INSERT INTO kdlNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Aku mara̱na̱ ma roku uza u unambi u tuwa̱ u zuwai irim i re i kenu. ");
INSERT INTO kdlNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Aku u isa̱i atoni a ne u tonuko le, “Mayun n tonuko ɗa̱, mara̱na̱ ma nala ma la ta̱ gba̱ aza ɗa a zuwai ikebe i le a asu u uzuwusa u ikebe u nala vi. ");
INSERT INTO kdlNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kpaci ele a asuvu a utsa̱ri u le u ɗa a zuwusai, shegai eyi asuvu a unambi u ne u ɗa u bidyai gba̱, u zuwai ikebe i ulyaka ilikulya i ne.” ");
INSERT INTO kdlNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","N uwuta̱ u Yesu a Kuwa ku Kashila̱, katoni ka ne ka te ka tonuko yi, “Kawenishiki, kondo ve icun i atali a nala yi! N icun i kuma ku nala ki!” ");
INSERT INTO kdlNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu wushunki yi, “Vu wene kuma ku pige ku nala? Katali ka̱ la ka a ka a̱sa̱ka̱ utaɗangi a zuba u utoku u ne bawu a wa̱sa̱i ka wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tyoku ɗa Yesu wa̱ri ndishi a Masasa ma Zayitum ma ma wundyamgbana n Kuwa ku Kashila̱, Bituru n Yakubu n Yahaya n Andurawu a wece yi a ikengi, ");
INSERT INTO kdlNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tonuko tsu, nwere ɗa a ka yan ili i nala yi? Kpam icun i iryoci i eni iꞌya a ka wene ya ciga baci i gita̱?” ");
INSERT INTO kdlNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","U tonuko le, “Kiranai kotsu uza roku u puwunsa̱ ɗa̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ama ushani a ka tuwa̱ ta̱ n kala ka va̱, a dana alya Kirisiti Kawauwi, hal a puwunsa̱ ama ushani. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","I pana baci ukuna u kuvon n alabari a kuvon, kotsu asuvu a ɗe a ꞌya̱nga̱ wa. U ka̱na̱ ta̱ u gita̱ nala, shegai makorishi ma kotsu wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kaletsu ka ama ka ꞌya̱nga̱sa̱ka̱ ta̱ kaletsu ka ama roku. Tsugono kpam tsu ꞌya̱nga̱sa̱ka̱ tsugono. Iyamba ya gba̱ɗa̱ ta̱ a asu kau‑kau, kpam a ka yan ta̱ kambulu. Shegai gba̱ nala vi kagita̱ ka upana u ikyamba ka ve. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Shegai eɗa̱ she i kirana. A ka ka̱na̱ ɗa̱ ta̱ a banka a asu u Asheshi a Pige, a bawan ɗa̱ a asuvu a agata a Kashila̱. A neke ɗa̱ akere a aza a tsugono na̱ ngono adama a kala ka va̱, an i tonuko le ukuna u va̱. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Shegai kahu makorishi ma tuwa̱, she a yanka aletsu a ama gba̱ Kadyanshi ka Shinga ka va̱. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Aꞌayin a ɗa baci dem a banka ɗa̱ a asu u afada a neke ɗa̱, kotsu i dambula a ili iꞌya ya dana wa. Shegai gba̱ ili iꞌya baci dem a na̱ka̱ ɗa̱ iꞌya ya dana. Kpaci eɗa ya dansa wa, Kulu Keri ka. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Vuma wa neke ta̱ utoku u ne a wuna yi, tata kpam dem nala wa yanka maku ma ne. Mmuku kpam n ꞌya̱nga̱sa̱ka̱ isheku i le hal a zuwa a wuna le. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ama gba̱ a ka ꞌyuwan ɗa̱ ta̱ adama a kala ka va̱. Shegai gba̱ uza ɗa baci dem u kawunki hal ubana a makorishi, a ka wauwa yi ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Aꞌayin aꞌa̱ ta̱ a utuwa̱, aɗa ya wene ili i icaɗi i shamgba a asu u ɗa bawu i gain i shamgba.” (Uza ɗa wa yan ka̱neshi, u reve ili iꞌya asu u na wa tono!) “Aza ɗa aꞌa̱ri a uyamba u Yahuda she a bana a nsasa. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Uza ɗa baci dem wa̱ri a zuba u kukpa̱ ku kunu ku ne, kotsu u cipa̱ u uwa a kuwa u bidya ili i roku wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Uza ɗa wa̱ri a kashina, kotsu u gono a ilyuci u bidya kunya ku upala̱ka ku ne wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ter ɗe aka a atsuma̱ n aza a mmuku n shili a aꞌayin a nala yi! ");
INSERT INTO kdlNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Yanyi kavasu kotsu ukuna u nala vi u gita̱ n ilyushi wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Aꞌayin a nala yi a ka yan ta̱ upana u ikyamba u pige, u ɗa bawu a taɓai uyan tun aꞌayin a ɗa Kashila̱ ka yain likimba hal utuwa̱ ara. A ka doku a ka yan a ɗa kpam wa hal ubana a makorishi. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","U woko baci Magono ma Zuba ma jebei aꞌayin yi wa, uma wa̱ la wa̱ri wa la wa. Shegai adama a aza ɗa a ɗanga̱sai vi ɗa i zuwai u jebei aꞌayin yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Aꞌayin a nala yi ko ya baci tonuko ɗa̱ weɓelei Kawauwi ka na, ko weɓelei aya ɗe! Kotsu i wushuku wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kpaci awauwi a kaɓan na̱ ntsumate n kaɓan a ka tuwa̱ ta̱ a yain iryoci n ikunesavu kotsu a puwunsa̱ aza ɗa a ɗanga̱sai, wa yan baci. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kiranai, kpaci n tonuko ɗa̱ ta̱ ko ndya wa ga̱mpa̱. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Shegai aꞌayin a upana u ikyamba a nala a wura baci, kaara ka lima̱na̱ ta̱, uwoto tani wa na̱ka̱ katyashi wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Atala a ka rukpusa̱ ta̱, kpam a gba̱ɗa̱ ili i pige i pige iꞌya iꞌa̱ri a zuba. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Aꞌayin a nala a ɗa a ka wene Maku ma Vuma ma tuwa̱ a asuvu a alishi, n ucira u pige u tsugono. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Aku u suku atsumate a zuba a ɓolomgbono aza ɗa a ɗanga̱sai a aɓon a nishi a likimba; wata, ili iꞌya i bidyai a mɓa̱ri n likimba n naha ubana a utyoku u zuba u niɗe. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Rotsongusi a iryoci i maɗanga ma kapopi. Aꞌayin a ɗa baci i wenei atyangi a ne a lima̱na̱i, aku a gita̱i utopo avuku, i reve ta̱ an ilyushi i yain evu. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nala kpam dem aꞌayin a ɗa baci dem i wenei ili i nala yi ya gita̱sa̱, ya reve ta̱ an aꞌayin a yain evu n uyan. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mayun n tonuko ɗa̱, ama a gogo‑na a ka kotso wa, she a shaɗangu ili i na yi gba̱. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Zuba n likimba wa cimba̱ ta̱, shegai kadyanshi ka va̱ ka cimba̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Shegai ukuna u kain ka nala ki ko ulapa u uwule vi, uza wa̱ la u revei ka wa. Atsumate a zuba ko Maku, a reve ka wa. Tata ɗa koshi u revei ka. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kiranai i rongo n afoɓi n i yanyi kavasu. Kpaci i reve aꞌayin a ɗa ulapa u uwule vi wa yan wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Utuwa̱ u Maku ma Vuma wa̱ ta̱ tyoku u vuma ɗa u yain nwalu, u a̱sa̱nka̱i agbashi a ne manyan ma ya dem wa yan, aku u tonukoi uza u uwundya u utsutsu u rongo n afoɓi. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Rongoi n afoɓi, kpaci i reve kain ka uza u kuwa wa gono wa, wa fuɗa ta̱ u gono n kuvuli, ko a mere ma kayin, ko n kpasani, ko n usana. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kotsu u tuwa̱ u danda ɗa̱ n i lavuti wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ili iꞌya n tonuko ɗa̱ kpam ma tonuko ya dem iꞌya, i rongo n afoɓi.” ");
INSERT INTO kdlNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Aꞌayin a re a ɗa a wokoi, a yain Abiki a Upasamgbana n Abiki a Ilikulya iꞌya i Nambai Yisti. Aku aɗara̱kpi a pige n awenishiki a Mele a boloi ure u ɗa a ka ka̱na̱ Yesu usokongi kotsu a wuna. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","A danai, “Shegai tsa kawan tsa yan u ɗa a aꞌayin a abiki a na wa, kawa ama a ka ꞌya̱nga̱sa̱ka̱ tsu ta̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Aꞌa̱ri pini Yesu wa̱ri a Batani a kuwa ku Simo uza ɗa caupa wa̱ri makutu. Eyi pini n u lyayi ilikulya, uka roku u tuwa̱i n majuju ma manivi. Manivi mi ma magula̱ni ma kpam ma̱ ta̱ n ikebe cika. U kukpa̱i una̱ u majuju mi, u tsa̱la̱i manivi mi gba̱ a kaci ka Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ama roku a ɗa aꞌa̱ri pini a asu vi a panai upan. A yamgbanai kadyanshi, “Ndya kalen ka koli ka manivi naha? ");
INSERT INTO kdlNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ma ra̱tsa ta̱ a denge ma ikebe iꞌya i lai iꞌya uza wa yan manyan ma uwoto kupa n u re, aku a pecike aza a unambi.” A ka̱na̱ yi uyanka tsali n asuvu a shen. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Shegai Yesu danai, “A̱sa̱ka̱ ni shiriri! Ndya i zuwai ya damgbara̱sa yi? Ili i shinga i pige iꞌya u yanka mu. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kain dem iꞌa̱ ta̱ kaɓolo n aza a unambi, kain ka baci dem, ya ciga ya fuɗa ta̱ i yanka le ili i shinga. Shegai mpa ma̱ kaɓolo n a̱ɗa̱ kain dem wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Eyi gba̱m u dara̱ka ta̱ hal u tsunki ikyamba i va̱ n manivi kahu kaciɗa̱ ka va̱. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mayun n tonuko ɗa̱, gba̱ ko nte baci a ka yan Kadyanshi ka Shinga a likimba, she a yan kadyanshi ka ili i shinga iꞌya uka u naha vi u yain, kpam a ka rongo yi ta̱ uciɓusa.” ");
INSERT INTO kdlNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yahuza Isikariyoti uza u te a asuvu Kupanamere yi, u banai a asu u aɗara̱kpi a pige kotsu u neke Yesu ara le. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","An a panai nala a yain maza̱nga̱ hal a zuwamgbanai a ka na̱ka̱ yi ikebe. Eyi tani u gita̱i uzama tyoku ɗa wa yan u neke yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kain ka kagita̱ ka Abiki a Ilikulya iꞌya i Nambai Yisti, kain ka a cuwana̱kai ukiɗa̱sa mmuku ma aꞌondom, kain ka Abiki a Upasamgbana ka la vi. Atoni a ne a wece yi, “Nte va ciga tsu ba tsu foɓusuko vu a asu u ɗa va lya ilikulya i Abiki a Upasamgbana?” ");
INSERT INTO kdlNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Aku u suki atoni a ne a re. U tonuko le, “Uwai a ilyuci, ya bana ta̱ i gawunsa n vuma roku u cangai malanda ma mini, i toni yi, ");
INSERT INTO kdlNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","kuwa ka baci dem u uwai, i tonuko uzakuwa vi, kawenishiki ka danai, nte kunu ka wa lya ilikulya i Abiki a Upasamgbana n atoni a ne ka̱ri? ");
INSERT INTO kdlNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wa wenike ɗa̱ ta̱ kunukuzuba ka a foɓusoi ucanga, nte ya foɓusuko tsu pini.” ");
INSERT INTO kdlNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Atoni yi a ꞌya̱nga̱i a uwai a ilyuci. A cinai tani tyoku ɗa u tonuko le. Aku a foɓusoi Abiki a Upasamgbana. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","An kuvuli ku yain, aku u tuwa̱i kaɓolo n Kupanamere vi. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Aꞌa̱ri ulya ilikulya, Yesu danai, “Mayun n tonuko ɗa̱, vuma u te a asuvu a ɗe wa neke mu ta̱, kpam uza ɗa tsa lya kaɓolo n eyi.” ");
INSERT INTO kdlNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","A namgba ta̱ katsuma̱ cika, aku a gita̱ yi uwecishe maten‑maten, “Mpa wa̱?” ");
INSERT INTO kdlNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","U wushunku le, “Uza u te ɗa gai a asuvu a Kupanamere, uza ɗa tsa lya kaɓolo a kapara ka te. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Maku ma Vuma ma kuwa̱ ta̱ tyoku ɗa a korongi ukuna u ne. Ter! Vuma ɗa wa neke Maku ma Vuma mi, aꞌa̱ri a matsa yi baci wa, wa̱ri u laka yi ta̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Aꞌa̱ri pini ulya ilikulya yi, Yesu bidyai burodi u cikpai Kashila̱, aku u jiba̱mgba̱na̱sa̱i u ɗa. U na̱ka̱i atoni a ne u danai, “Wushai na vi ikyamba i va̱ iꞌya.” ");
INSERT INTO kdlNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","U bidyai mako ma mini ma cinwi u cikpai Kashila̱. U na̱ka̱ le a soi. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Aku u danai, “Naha vi mpasa n va̱ n ɗa n ɗa a wotsongi a adama a ama ushani. Kashila̱ ka yan ta̱ manyan na̱ mpasa n na mi tsa̱ra̱ u yain kazuwamgbani ka savu n ama a ne. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mayun ɗa an bawu ma doku ma so mini ma cinwi she kain ka ma so ma savu a tsugono tsu Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","An a kotsoi ulya ilikulya yi, a shipai ushipa a cikpalai Kashila̱. Pini nala, a lazai ubana a Masasa ma Zayitum. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu tonuko le, “Gba̱ ɗe ya suma ta̱ i a̱sa̱ka̱ mu, kpaci nala wa̱ri ukorongi a tagara̱da u Kashila̱, ‘Ma ga̱la̱ ta̱ kaliniki ki, ncon mi kpam ma wacuwa ta̱.’ ");
INSERT INTO kdlNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Shegai a ꞌya̱nga̱sa̱ mu baci, ma lasa ɗa̱ ta̱ ubana a asuvu a Galili.” ");
INSERT INTO kdlNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Bituru tonuko yi, “Ko atoku a va̱ a suma baci gba̱ le, mpa ma suma wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","U danai, “Mayun n tonuko vu, n kayin ka na kahu kapen ka sala isali i ire, va nana mu ta̱ vu dana vu reve mu wa hal kutatsu.” ");
INSERT INTO kdlNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Shegai Bituru lapulai u wushuki n ucira, “Ko wuna ɗa baci a ka wuna mu kaɓolo n avu, ma nana an n reve vu wa.” Gba̱ le dem nala a dansai. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","A rawai a asu u ɗa wa̱ri na̱ nɗanga n zayitum asu u ɗa a ka isa̱ Getisimani. Yesu tonukoi atoni a ne, “Dusuki ve pini na hal n ba n yain kavasu.” ");
INSERT INTO kdlNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Aku u bidyai Bituru n Yakubu n Yahaya. Kpam u gita̱ ɗe upana ikyamba cika n kadambula ushani. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Aku u tonuko le, “Uma u va̱ wa pana ta̱ ikyamba cika, yavu ma kuwa̱. Rongoi na n afoɓi.” ");
INSERT INTO kdlNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","An u lyai kapala kenu, aku u kuɗa̱ngi u varai kaci a iyamba u yain kavasu, ko wa yan a takpa yi ulapa u uwule vi. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Aku u danai, “Tata, ili dem i uyan iꞌya ara vunu. Takpa mu mako ma mɓa̱la̱ mi. Ko n nala ukuna u va̱ u ɗa a ka tono wa, she u vunu.” ");
INSERT INTO kdlNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Aku u gonoi a asu u atoni a ne yi u cina le n a lavuti. U tonukoi Bituru, “Bituru alavu a ɗa va̱ri? Va fuɗa va rongo n vu wundi ulapa u uwule u te wa? ");
INSERT INTO kdlNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Rongoi n afoɓi n kavasu, kotsu i tuwa̱ i rukpa̱ a asuvu a ukondo wa. Kulu ku ɗe ku ciga ta̱ ku yain ili iꞌya i gain, shegai ikyamba iꞌa̱ n ucira wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Aku u doku u gonoi uyan kavasu, u rongoi utonusuko kadyanshi ka baci ki. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","An u gonoi u doku u cina le alavu, kpaci alavu a shaɗangu le ɗe aꞌeshi cika, ele tani a nambai ili iꞌya a ka tonuko yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","An u gonoi u tatsu, u wece le, “Hal n gogo‑na alavu a ɗa i buwai n i wunvugusi? U ra̱tsa ta̱ nala ulapa u uwule u yan ɗe. A neke ɗe Maku ma Vuma a akere a aza a unyushi u cingi. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ꞌYa̱nga̱i tsu walai. Kaneki ka va̱ ka la ka tuwa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","U kimba̱ gba̱m una̱ wa, aku a wenei Yahuza uza u te a asuvu a Kupanamere yi, n kakuma̱ ka ama, n iburundu na̱ mkpa̱ukpa̱u a akere a le. Aɗara̱kpi a pige n awenishiki a Mele na̱ nkoshi a lya a tutsuku le. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Kaneki ki ka sheshike le ta̱ kahu a tuwa̱, u danai, “Uza ɗa baci n wambatsai, aya, i ka̱na̱ yi, i laza n eyi.” ");
INSERT INTO kdlNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","N urawa u ne, u banai ara Yesu u danai, “Kawenishiki.” Aku u woɓo yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ele tani a ka̱na̱ yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Shegai uza u te a asuvu aza ɗa aꞌa̱ri kushani ki, u talai burundu u ne, aku u kapamgbanai kutsuvu ku kagbashi ka Magono ma Aɗara̱kpi u takpamgbanai ka. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu wece le, “Tuwa̱ ɗa i tuwa̱i n iburundu na̱ mkpa̱ukpa̱u i ka̱na̱ mu, yavu uza u maga̱la̱ka̱? ");
INSERT INTO kdlNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kain dem ma̱ ta̱ kaɓolo n a̱ɗa̱ a Kuwa ku Kashila̱ na̱ n wenishiki, kpam i ka̱na̱ mu wa. Shegai yan ɗa a yain nala tsa̱ra̱ a shaɗangu udani u tagara̱da u Kashila̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Pini nala, atoni a ne a sumai a a̱sa̱ka̱ yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kalobo ka roku kpam n kunya ku uwambana ku ne koshi, u tono yi. An a za̱ra̱i kotsu a ka̱na̱ yi, ");
INSERT INTO kdlNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","u a̱sa̱nka̱ le kunya ki, u sumai kataɓa. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Pini nala, a bankai Yesu a asu u Magono ma Aɗara̱kpi. Gba̱ aɗara̱kpi a pige na̱ nkoshi n awenishiki a Mele a ɓolomgbonoi ara ne. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Bituru tani wa tono yi mɓa̱ri mɓa̱ri, hal she a ulanga u kuwa ku Magono ma Aɗara̱kpi mi. U dusuki a asuvu ada̱ga̱ri a Kuwa ku Kashila̱ ki, wa lyashuku akina. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Aɗara̱kpi a pige gba̱ n Asheshi a Pige a boloi unyushi a kaci ka Yesu, kotsu a wuna yi. Shegai a tsa̱ra̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ama ushani a shamkpai kadyanshi ka kaɓan a kaci ka ne, shegai una̱ u le u tuwa̱ u te wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Aza roku kpam a ꞌya̱nga̱i a shamkpai kadyanshi ka kaɓan a danai, ");
INSERT INTO kdlNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Tsu pana̱ka yi ta̱ u danai wa wa̱sa̱ ta̱ Kuwa ku Kashila̱ ka ama a mai, aku u mai ku roku a asuvu a aꞌayin a tatsu. Kpam kuma ku uza ka wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Gba̱ n nala ushamkpa u kaɓan u le u tonomgbono wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Magono ma Aɗara̱kpi ma shamgbai a mere ma le, u wece yi, “Va̱ n ili iꞌya va wushuku a kaci ka kadyanshi ka ama a ka tukuso a kaci ka vunu wa? Paɗa ɗa va paɗa bini?” ");
INSERT INTO kdlNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Shegai u paɗai ili i ne, u wushuku ko i te wa. Aku Magono ma Aɗara̱kpi ma doku ma wece yi, “Aɗa Kirisiti Maku ma Kashila̱ Uza u Tsupige vi?” ");
INSERT INTO kdlNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","U wushuki u danai, “Mpa. Ya wene ta̱ Maku ma Vuma ndishi a ulyaki u Kashila̱ Uza u Ucira Gba̱, kpam i wene yi utuwa̱ a asuvu a alishi.” ");
INSERT INTO kdlNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Aku Magono ma Aɗara̱kpi ma kara̱sai aminya a ne, u danai, “Iryoci i eni iꞌya kpam tsa bolo? ");
INSERT INTO kdlNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","I pana ta̱ gai u yankai Kashila̱ kadyanshi ka cingi. Ndya i wenei?” Gba̱ le a wushuki, “U nusa ta̱, a wuna yi.” ");
INSERT INTO kdlNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Aza roku gba̱m a laza a gita̱ yi ucikpusuka̱ ata̱tsa̱. A sira yi aꞌeshi a sugbusa yi n a tonusuki yi, “Tonuko tsu ili iꞌya ya gita̱. Ya sugba vu.” Ada̱ga̱ri a Kuwa ku Kashila̱ tani a rongo yi uɓasa̱sa. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Bituru wa̱ri a iyamba a ulanga u kuwa vi, kagbashi ka ka̱ri makere ka Magono ma Aɗara̱kpi ka tuwa̱i. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","An u wenei Bituru wa lyashuku a akina aku u vara yi aꞌeshi, u danai, “Avu dem kaɓolo ka va̱ri n Yesu uza u Nazara nala vi!” ");
INSERT INTO kdlNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","U nanai u danai, “Mpa n reve gba̱m iꞌya va tono wa.” Aku u wuta̱i a keɓile ki, kute‑kute kapen ka salai. ");
INSERT INTO kdlNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","An kagbashi ka ka̱ri makere mi u wene yi pini, aku u tonukoi aza ɗa aꞌa̱ri pini a asu vi kushani, “Eyi na dem uza u le u ɗa.” ");
INSERT INTO kdlNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Aku u doku u nanai kpam. An a ɓa̱ra̱kpa̱i kenu, aza ɗa aꞌa̱ri kushani a tonukoi Bituru, “Mala̱la̱ ma̱ la wa, avu dem uza u te u ɗa a asuvu a le, kpaci avu uza u Galili u ɗa.” ");
INSERT INTO kdlNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Aku u ka̱na̱i uyansa̱ka kaci ka ne una̱ n u tsina̱si n u dansi, “N reve ve gba̱m vuma ɗa ya dansa̱ka vi wa.” ");
INSERT INTO kdlNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kute‑kute, kapen ka salai isali i ire. Aku Bituru ciɓai kadyanshi ka Yesu tonuko yi, “Kahu kapen ka sala isali i ire, va nana mu ta̱ vu dana vu reve mu wa hal kutatsu.” An u ciɓai nala, aku u ta̱sa̱i n kushen. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kain n ka wansi n kpasani ku de, aɗara̱kpi a pige na̱ nkoshi n awenishiki a Mele n Asheshi a Pige gba̱ a sheshei, aku a sirai Yesu a lazai n eyi ubana ara Bilatu gomuna. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","An a rawai, Bilatu wece yi, “Avu magono ma aza a Yahuda ma?” U wushunki yi u danai, “Nala wa̱ri tyoku ɗa vu danai vi.” ");
INSERT INTO kdlNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Aɗara̱kpi a pige a lyai kapala n utonusuko Bilatu ukuna u Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","U doku u wece yi, “Va̱ n ili i uwushuku wa, vu pana gba̱m ili iꞌya ama a na aꞌa̱ri utono a kaci ka vunu?” ");
INSERT INTO kdlNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Shegai Yesu doku u dana ili wa. Bilatu wenei nala, hal u yain majiyan. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kayen dem a aꞌayin a Abiki a Upasamgbana, Bilatu cuwana̱ka ta̱ u a̱sa̱nka̱ le vuma u te u ɗa ama a foloi u a̱sa̱nka̱ le a asuvu ama ɗa a ukai a kuwa ku aꞌali. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Vuma roku ɗa pini uza u kala Baraba. Wa̱ ta̱ usiri adama a uꞌya̱nga̱sa̱sa̱ atakasuvu a ama kaɓolo n atoku a ne aza ɗa a wunai ama, a kain ka a ꞌya̱nga̱sa̱i atakasuvu a ama. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ama a banai ara Bilatu a folo yi u yanka le ili iꞌya u cuwana̱kai. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","U wushunku le u danai, “Gogo‑na ciga ɗa ya ciga n a̱sa̱nka̱ ɗa magono ma aza a Yahuda mi?” ");
INSERT INTO kdlNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kpaci u reve ta̱ adama a malyon a ɗa aɗara̱kpi a pige a bankai Yesu ara ne. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Aɗara̱kpi a pige a ma̱tsa̱i ama a dana a wutumkpa̱ le Baraba. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Aku Bilatu danai, “Ndya ma yan n uza ɗa ya isa̱ magono ma aza a Yahuda mi?” ");
INSERT INTO kdlNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ama a worukpoi a danai, “A wandamgbana yi.” ");
INSERT INTO kdlNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","U wece le, “Adama a iyen, ili i cingi i eni iꞌya u yain?” Shegai ama yi a lapulai a worukpoi, a danai, “A wandamgbana yi.” ");
INSERT INTO kdlNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","An Bilatu wa ciga ama a pana kayanyan ka ne, aku u wutumkpa̱ le Baraba. U zuwai a bawain Yesu, aku u na̱ka̱ le a ba a wandamgbana yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Asoje a banai n Yesu a asuvu a keɓile ku tsugono, aku a ɓolomgbonoi gba̱ kakuma̱ ka asoje. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","A ukunka yi aminya a ngono a mini ma galura. Aku a yain funi u awana, a zuwuka yi u ɗa a kaci. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","A gita̱ yi idyani, “Uzapige, uzapige, magono ma aza a Yahuda.” ");
INSERT INTO kdlNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","A rongo yi ukuɗusa a kaci n kalangu, n a cikpusuki yi ata̱tsa̱. Aku a kuɗa̱ngi a da a ka na̱ka̱ yi tsupige. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","An a kotso yi uyanka majari, a mondo yi aminya a ngono yi. A uka yi aminya a ne. Pini nala, a wutukpa̱ yi a kateshe, kotsu a wandamgbana yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Vuma roku ɗa pini uza u kala Simo uza u Sirani, tata u Alizanda n Rafu, u wuta̱i a une wa wura. Asoje a shamkpa yi a ma̱tsa̱ yi u canga mawandamgbani ma Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","A bankai Yesu a asu u ɗa a ka isa̱ Golugota;† (wata, Asu u Mako ma Kaci). ");
INSERT INTO kdlNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","A na̱ka̱ yi mini ma cinwi kaɓolo n aguma̱ a ɗa a ka isa̱ ma̱r, shegai u ꞌyuwain ma uso. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Aku a wandamgbana yi. A pecishei aminya a ne utyoku u le. A varangi uruta, tsa̱ra̱ a wene ili iꞌya ya dem wa tsa̱ra̱. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","N ulapa uwule u kuci u usana u ɗa a wandamgbana yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Uza ɗa baci a wandamgbanai, a tsu korongu ta̱ unyushi u ne zuba n kaci ka ne. Ili iꞌya a koronki Yesu iꞌya na: MAGONO MA AZA A YAHUDA. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","A wandamgbanai kpam dem aza a maga̱la̱ka̱ ama a re. Uza u te a ulyaki u ne, uza u te tani a ugula̱.  ");
INSERT INTO kdlNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nala a shaɗangi udani u ɗa u danai, “A kece yi a asuvu a aza a unyushi.” ");
INSERT INTO kdlNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Aza ɗa a ka wurusa, a rongo yi uyansa̱ka kadyanshi ka gbani, n a gba̱ɗi aꞌaci a le. “Mhm! Avu uza ɗa vu da va wa̱sa̱ Kuwa ku Kashila̱, aku vu mai ka a asuvu aꞌayin a tatsu. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Cipa̱ wa̱wa! Vu wauwa kaci ka vunu.” ");
INSERT INTO kdlNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nala tani kpam dem aɗara̱kpi a pige n awenishiki a Mele a rongo yi uyanka majari. A danai, “U wauwai aza roku, shegai u fuɗa u wauwa kaci ka ne wa. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kawauwi ka na ki, magono ma aza a Isaraꞌila, u cipa̱ pini a mawandamgbani mi tsu wene wa̱wa tsa̱ra̱ tsu pityanangu n eyi.” Hal n aza a maga̱la̱ka̱ a ɗa a wandamgbanai kaɓolo n eyi dem a yanka yi kadyanshi ka gbani. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","N kaara a kaci, aku uyamba vi gba̱ u likpa̱mgba̱na̱i n karimbi hal ubana ulapa uwule u tatsu. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","N ulapa uwule u tatsu vi, Yesu salai, “Eloyi, Eloyi, lama sabaka̱tani.” (Wata, “Kashila̱ ka va̱, Kashila̱ ka va̱, ndya i zuwai vu varangu mu?”) ");
INSERT INTO kdlNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","An ama ɗa aꞌa̱ri pini kushani a panai nala, a danai, “Panai, wa isa̱ Iliya.” ");
INSERT INTO kdlNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Aku vuma u te u sumai u ba u reki kashaku n mini ma kalam, u sapai ka a kalangu, u sakunki yi kotsu u soi. Aku u danai, “A̱sa̱ka̱i tsu wene ko Iliya wa tuwa̱ u cipuka̱ yi.” ");
INSERT INTO kdlNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu salai cika, aku u uma u ne u wuta̱i. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kute‑kute kunya ka a ba̱ra̱kpa̱i a asuvu a Kuwa ku Kashila̱ ki ku pecemgbenei kure. Ili iꞌya i ka̱na̱i a zuba hal ubana a iyamba. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","An katigi ka ka shamgbai ka wundya Yesu, u wenei tyoku ɗa u kuwa̱i. U danai, “Mayun vuma u naha vi, Maku ma Kashila̱ ma.” ");
INSERT INTO kdlNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Aka a roku a ɗa pini a shamgbai a ka yan aka̱lu a mɓa̱ri. A asuvu a le alya Meri Magadaliya, n Solomi, n Meri (mma u Yakubu u kenu n Isuhu). ");
INSERT INTO kdlNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Alya a tono yi, tun a Galili n a yanki yi manyan. N aka a ɗa a tuwa̱i kaɓolo n eyi a Urishelima alya dem pini. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Gba̱ ukuna u na vi u gita̱ ta̱ a Kain ka Afoɓi; wata, kain ka wansa baci aku Ashibi. An kuvuli ka yan, ");
INSERT INTO kdlNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","aku Isuhu u Arimatiya u gbamai asuvu u banai ara Bilatu, u folo yi u na̱ka̱ yi ikyamba i Yesu u ciɗa̱ngu. (Isuhu vuma ɗa uza ɗa a ka pana n eyi a asuvu a Asheshi a Pige yi, uza ɗa wa vana utuwa̱ u tsugono tsu Kashila̱ tsu rawa.) ");
INSERT INTO kdlNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Bilatu yan ta̱ majiyan an u panai a da Yesu kuwa̱ ɗe. U isa̱i katigi ka ka wundya Yesu vi. Aku u wece yi ko u ɓa̱ra̱kpa̱ ɗe n ukpa̱. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","An katigi ki ka tonuko yi u kuwa̱ ɗe, aku u na̱ka̱i Isuhu ikyamba yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Pini nala, u ba u tsilai kunya, aku u ka̱ta̱la̱i pini ikyamba yi, u ba u ukai iꞌya a kasaun ka a saɗarai a katali. An u kotsoi, aku u gindala̱kpai katali ka pige u kimba̱i utsutsu u kasaun vi. ");
INSERT INTO kdlNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Meri Magadaliya n Meri mma u Isuhu a wene ta̱ a asu u ɗa a ciɗa̱ngi ikyamba i Yesu yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","An Ashibi a wurai, Meri Magadaliya, n Meri mma u Yakubu, n Solomi a tsilai ucanga u magula̱ni, kotsu a ba a tsunku ikyamba i Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","3","N kpasani ku kain ka kagita̱ ka a aꞌayin a shindere a ka̱na̱i ure. Ele a nwalu a ka yawunsa uza ɗa wa ba u gindala̱kpuka le katali ka a kimbuga̱i utsutsu u kasaun vi. Kaara n ka ɓa̱tsi ele n a rawi pini a utsutsu u kasaun vi. ");
INSERT INTO kdlNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","A weɓelei na a wenei katali ki a gindala̱kpa ka ɗe, ka la a ikengi ka pige ka tani. ");
INSERT INTO kdlNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","An a uwai a wenei kalobo ka roku n aminya a eri ndishi a ulyaki, aku uwonvo u ka̱na̱ le. ");
INSERT INTO kdlNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pini nala, kalobo ki ka tonuko le, “Panai uwonvo wa. N reve ta̱ Yesu uza u Nazara, uza ɗa a wandamgbanai vi aya ya bolo. Weɓelei asu u ɗa aꞌa̱ri a zuwai ikyamba i ne ɗa na, wa̱ kpam pini wa, u ꞌya̱nga̱ ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Walai i ba i tonuko Bituru n atoni a ne a ɗa a buwai, i tonuko le wa lasa ɗa̱ ta̱ ubana a uyamba u Galili. Nte ya ba i wene yi ɗe tyoku ɗa u tonuko ɗa̱ aꞌayin a ɗa wa̱ri n a̱ɗa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Aku a wuta̱i a wuranai n ilyaɗi ikyamba n i jeyi, kpam alya la ula̱pa̱ni a dana uza ukuna wa adama a uwonvo. ");
INSERT INTO kdlNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","N kpasani ku kain ka kagita̱ ka aꞌayin a shindere ka Yesu ꞌya̱nga̱i. Vuma ɗa u gita̱ yi uwene, Meri Magadaliya ɗa, uka ɗa u wutukpa̱i ityoni i cingi i shindere ara ne. ");
INSERT INTO kdlNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","U ba u tonukoi atoni a Yesu, u cina le atsuma̱ unamgbi n a sa̱yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Shegai an u tonuko le Yesu ꞌya̱nga̱ ɗe, hal gba̱m u wene yi ta̱, a ꞌyuwain uwushuku. ");
INSERT INTO kdlNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Yesu yansa̱kai tyoku u roku, aku u a̱sa̱ka̱i atoni a ne ama a re aza ɗa a ka bana a ilyuci a wene yi. ");
INSERT INTO kdlNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Aku a gonoi a ba a tonukoi atoku a le. Atoku yi a ꞌyuwain uwushuku n ili a danai. ");
INSERT INTO kdlNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pini nala, u a̱sa̱ka̱i atoni a ne kupa n uza u te vi a wene yi, aꞌayin a ɗa a ka lya ilikulya. Aku u ɓongo le adama a ugbama u asuvu a le n ukpa̱ɗa̱ u uwushuku n ili iꞌya ama ɗa a wene yi a tonuko le. ");
INSERT INTO kdlNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Aku u tonuko le, “Walai i bana a asuvu a likimba i yanka ama Kadyanshi ka Shinga ka va̱. ");
INSERT INTO kdlNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Gba̱ uza ɗa baci dem u wushuki n kadyanshi ki hal a lyuɓugi yi, a ka wauwa yi ta̱. Kpam uza ɗa baci u ꞌyuwain ka, a ka varangu yi ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Iryoci i na ya tono ta̱ aza ɗa a wushuki: asuvu a kala ka va̱ a ka wutukpa̱ ta̱ ityoni i cingi a asuvu a ama. A ka yan ta̱ dem kadyanshi n aletsu a roku. ");
INSERT INTO kdlNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","A ka bidya ta̱ aꞌali n akere a le, kpam a ka yanka le ili wa. Uza u so baci tsukonu, tsa tsa yan yi ili wa ko kenu. Kpam a ka sawa ta̱ aza a mɓa̱la̱ a ta̱na̱sa̱ le.” ");
INSERT INTO kdlNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","An Yesu kotso le uyanka kadyanshi, aku a canga yi ubana a zuba. U ba u dusuki a kukere ku ulyaki ku Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Atoni a ne tani a lazai, a rongoi uyan kuɓari ku Kadyanshi ka Shinga ka Kashila̱, ko nte wa a asuvu a likimba. Asheku n a ɓa̱nga̱ le asu u ɗa u a̱sa̱ka̱ le a ka yansa ikunesavu n i weniki kadyanshi ki mayun ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Uzapige Tiyofilu: Ama ushani a bidya ta̱ a korongu ukuna u ɗa u gita̱i a mere ma tsunu. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ama yi a korongu ta̱ dere tyoku u aza ɗa a yain ukuna vi a aꞌeshi a le, alya ayain a manyan ma udani mi, kpam a tonuko tsu. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Adama a nala, an u wokoi mpa n kaci ka va̱ n vecei ukuna vi a kagita̱ ben, n wenei u lobono ta̱ n koronku vu ukuna vi tyoku ɗa u tonomgbonoi. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Tsa̱ra̱ vu reve ukuna u ɗa a wenishike vu vi mayun ɗa u gita̱i. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Aꞌayin a Hiridu† Magono ma Yahuda, a yan ta̱ kaɗara̱kpi† ka roku, uza u kala Zakariya, uza ɗa wa̱ri a kaɓon ka kaɓolo ka aɗara̱kpi ka Abija. Uka u ne Alisabatu uza u kagali ka Haruna† kaɗara̱kpi ka. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ama a re le a ka wala ta̱ dere a aꞌeshi a Kashila̱, kpam a ka kirana n udani u Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Shegai aꞌa̱ri n maku wa, kpaci Alisabatu madari ma, kpam gba̱ le a kutsa ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kain ka kaɓon ka aɗara̱kpi ka Zakariya ka̱ri a manyan a Kuwa ku Kashila̱, wa̱ri a uyan tsuɗara̱kpi a kapala ka Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Uruta u rukpa̱i a kaci ka ne tyoku u agadu a aɗara̱kpi, u woko uza ɗa wa uwa a asuvu a Asu u Uwulukpi, u runukpa ili i magula̱ni. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","An aꞌayin a urunukpa a ili i magula̱ni† a yain, kakuma̱ ka ama ka ka lya kayala ka̱ri a ulanga a uyan kavasu. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Aku katsumate ka zuba ka Kashila̱ ka wenikei kaci ka ne ara Zakariya a ulyaki u asuɗara̱kpa u ili i magula̱ni vi. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","An u wenei nala, u giruwa̱i, uwonvo u ka̱na̱ yi cika. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Aku katsumate ki ka tonuko yi, “Zakariya, pana uwonvo wa, kpaci a pana ɗe kavasu ka vunu. Uka u vunu Alisabatu wa matsa̱ka vu ta̱ maku ma vali. Vu neke yi kala Yahaya. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Wa woko ta̱ ili i ipeli n i kayanyan ara vunu. Ama ushani a ka pele ta̱ adama a ilimaci i ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kpaci wa woko ta̱ uzapige a kapala ka Magono ma Zuba. Wa tuwa̱ u soi mini ma cinwi ko ili iꞌya ya zuwa umaka wa. Kpam a ka shaɗangu yi ta̱ n Kulu Keri, eyi pini a katsuma̱ ka mma u ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Wa gonuko ta̱ aza a Isaraꞌila ushani a asu u Magono ma Zuba Kashila̱ ka le. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kpam wa lasa ta̱ Asheku, n kulu n ucira tyoku u Iliya. U yira̱la̱kpa̱ atakasuvu a asheku ubana a asu u mmuku n le, n uyawunsa u aryagbaji uwoko tyoku u uyawunsa u ama a maci. U foɓuso atakasuvu a ama adama a utuwa̱ u Asheku.” ");
INSERT INTO kdlNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakariya wece yi, “Niɗa ma wushuku n ukuna u na vi? Mpa na n yan ɗe makoshi, kpam uka u va̱ dem u yan ɗe mamici.” ");
INSERT INTO kdlNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Katsumate ki ka wushunku yi, “Mpa Jiburaꞌilu, uza ɗa wa̱ri kushani a kapala ka Kashila̱. Suku ɗa a suku mu n tuwa̱ n dana̱sa vu, kpam n tonuko vu ukuna u shinga u na vi. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Gogo‑na, adama a ukpa̱ɗa̱ u upityanangu u vunu, va woko ta̱ kabebe. Va doku kpam va dana ukuna wa, she aꞌayin a ɗa a shaɗangi ukuna u na vi, a kain ka a zuwai u ɗa. Kpam nala wa woko.” ");
INSERT INTO kdlNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ama aꞌa̱ri a ulanga a uvana Zakariya, aꞌa̱ri uyan majiyan ma ili iꞌya i zuwai u ɓa̱ra̱kpa̱i a asuvu a Asu u Uwulukpi vi. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","An u wuta̱i, u fuɗa u dana ukuna wa. Ama a revei u wene ta̱ pini kuwene. U rongo le u wenishike iryoci n u ra̱ɗa̱gbusi akere. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","An aꞌayin a manyan a ne a shaɗangi, u lazai u gonoi a kuwa. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","An aꞌayin a nala a wurai, Alisabatu uka u ne u yain katsuma̱, u ka̱na̱i uronguso a kuwa bawu u wuta̱i hal uwoto u tawun. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","U danai, “Weɓelei ili iꞌya Magono ma Zuba ma yanka mu. A aꞌayin a ɗa a yan yi, ɗa u takpa mu uwono a aꞌeshi a ama.” ");
INSERT INTO kdlNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","A uwoto u teli u katsuma̱ ka Alisabatu, Kashila̱ ka suki katsumate ka zuba ka ne Jiburaꞌilu a Nazara, ilyuci iꞌya iꞌa̱ri a uyamba u Galili. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","U bana a asu u makere ma roku ma bawu ma revei vali. Uza ɗa vuma roku uza u kala Isuhu, uza u kagali ka Dawuda magono, u kenei tsumana. Kala ka makere mi ka Meri. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Katsumate ka banai ara ne, u danai, “A dana̱sa vu Meri, macigi ma Kashila̱. Magono ma Zuba ma̱ ta̱ n avu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Shegai Meri dambula ta̱ cika, wa yawunsa icun i idyani i eni iꞌya nala. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Katsumate ka tonuko yi, “Pana uwonvo wa, Meri, kpaci Kashila̱ ka bidya ta̱ ka zuwuka vu una̱ u shinga. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Va yan ta̱ katsuma̱, vu matsa maku ma vali, kpam vu neke yi kala Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Wa woko ta̱ uzapige. A isa̱ yi kpam Maku ma Kashila̱ ka Zuba. Magono ma Zuba Kashila̱ wa na̱ka̱ yi ta̱ tsugono tsu akaya a ne Dawuda. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Wa lya ta̱ tsugono tsu kagali ka Yakubu hal ubana. Tsugono tsu ne tani tsa̱ ta̱ pini hal ubana bawu utyoku.” ");
INSERT INTO kdlNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Meri wece yi, “Niɗa ukuna u na wa gita̱, an u wokoi mpa n reve vali wa?” ");
INSERT INTO kdlNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Katsumate ka wushunku yi, “Kulu Keri ka cipa̱ ta̱ ara vunu, ucira u Kashila̱ ka Zuba wa pala̱sa vu ta̱. Adama a nala uza u uwulukpi u ɗa va matsa vi, a ka isa̱ yi ta̱ Maku ma Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Alisabatu dem, kumaci ku vunu wa̱ ta̱ n katsuma̱ n tsumici tsu ne! Uwoto u teli u ɗa yi pa vi. Eyi uza ɗa a danai madari ma. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ili iꞌa̱ la iꞌya Kashila̱ ka kpa̱ɗa̱ uyan wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Meri danai, “Mpa kagbashi ka Magono ma Zuba ka. U woko mu tyoku ɗa vu danai.” Aku katsumate ki ka lazai ka a̱sa̱ka̱ yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Aꞌayin a nala yi, Meri yain maloko u foɓusoi u banai a uyamba u Yahuda, a ilyuci i roku, a kaɓon ka nsasa. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","U uwai a kuwa ku Zakariya u dana̱sai Alisabatu. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","An u panai idyani i ne, aku maku ma ma̱ri a katsuma̱ ka ne ma gba̱ɗa̱i n ucira. Pini nala, a shaɗangi Alisabatu n Kulu Keri. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","U ꞌya̱nga̱sa̱i kala̱ga̱tsu ka ne n ucira, u danai, “Avu uza u una̱ u shinga u ɗa a asuvu a aka gba̱. Maku ma kpam va matsa vi, uza u una̱ u shinga u ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Niɗa ukuna u shinga u na u tsa̱ra̱ mu, hal anuku a Asheku a va̱ u tuwa̱i ara va̱? ");
INSERT INTO kdlNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","An n panai kala̱ga̱tsu ka idyani i vunu, aku maku ma ma̱ri a katsuma̱ ka va̱ ma gba̱ɗa̱i n ucira adama a ipeli. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Uza u una̱ u shinga u ɗa va̱ri Meri, avu uza ɗa vu wushuki n ili iꞌya Magono ma Zuba ma tonuko vu ya shaɗangu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Aku Meri danai, “Katakasuvu ka va̱ ka na̱ka̱ ta̱ Magono ma Zuba tsupige. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","N Kashila̱ Kawauwi ka va̱ ka uma u va̱ wa̱ri a ipeli. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kpaci u weɓelei uvakunku u kaci u kagbashi ka ne. U ɗa na gba̱ ama a ka tuwa̱ a ka isa̱ mu uza u una̱ u shinga. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kpaci Uza u Ucira Gba̱ u yanka mu ta̱ ili i pige. Uwulukpi u ɗa kala ka ne ka̱ri. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Upasamgbana̱sa u ɗa upana u iyali u ne u tsu pasamgbana̱sa a agali a ɗa a ka pana uwonvo u Kashila̱ ubana. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","U yain manyan ma pige n akere a ne, u wacinsai aza a ara̱ɗi n uyawunsa u atakasuvu a le. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","U takpai ngono a tsugono tsu le, aku u na̱ka̱i aza ɗa a vakunki kaci ka le tsupige. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","U cuwa̱ta̱ngi aza a kambulu n ili i shinga, aza a utsa̱ri tani u tutsuku le akere a de. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","U ɓa̱nga̱i kagbashi ka ne Isaraꞌila, kpaci wa ciɓusa ta̱ n asuvayali a ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Tyoku ɗa u zuwamgbanai wa pana iyali i isheku i tsunu, Ibirahi n kagali ka ne ubana.” ");
INSERT INTO kdlNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meri dusuki n Alisabatu evu n uwoto u tatsu, aku u gonoi a kuwa. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","An aꞌayin a ilimaci a Alisabatu a yain, u matsai maku ma vali. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Aza a karen n amaci a ne, a panai tyoku ɗa Magono ma Zuba ma panai iyali i ne, hal a ɓa̱nga̱ yi ipeli. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kain ka kulla̱, a tuwa̱i kotsu a kiɗa maku mi kacombi.† Aꞌa̱ri a ka ciga a neke yi kala ka asheku a ne Zakariya. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Shegai mma u ne u danai, “Nala wa, kala ka ne ka Yahaya.” ");
INSERT INTO kdlNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Aku a danai, “Iyen! A kumaci ku vunu uza roku wa̱ la n kala ka nala wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","A yankai asheku a ne kadyanshi n kukere u tonuko le kala ka wa ciga a isa̱ maku mi. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","U zamai a tuko yi kagbagala ka ikorongi, aku u korongi, “Kala ka ne ka Yahaya.” Gba̱ le a yain majiyan. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kute‑kute, una̱ u ne u kukpa̱i, kaletsu ka ne kpam ka tatsukpai. Aku u gita̱i kadyanshi u rongoi ucikpala Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Uwonvo u ka̱na̱i aza a karen yi gba̱. A rongoi utambura kadyanshi ka ukuna vi gba̱ a kaɓon ka nsasa ka uyamba u Yahuda. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Gba̱ aza ɗa a panai ukuna vi a ka̱na̱i u ɗa a atakasuvu a le, a ka tono, “Ndya maku ma na ma tuwa̱ ma woko?” Kpaci ucira u Magono ma Zuba ma̱ ta̱ n eyi. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Aku a shaɗangi asheku a ne Zakariya n Kulu Keri, u yain kadyanshi ka ukuna u Kashila̱, u da, ");
INSERT INTO kdlNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“A cikpala Magono ma Zuba, Kashila̱ ka Isaraꞌila, kpaci u tuwa̱ ta̱ a asu u ama a ne u wutukpa̱ le. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","U ꞌya̱nga̱sa̱ka̱ tsu Kawauwi ka ucira, a asuvu a kagali ka kagbashi ka ne Dawuda. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","(Tyoku ɗa caupa u danai a una̱ u ntsumate n ne n ɗa a wulukpei.) ");
INSERT INTO kdlNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","U wauwa tsu a akere a atokulalu a tsunu, hal gba̱ n aza ɗa a ꞌyuwan tsu. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Tsa̱ra̱ u wenike asuvayali a ne a asu u nkoshi n cau n tsunu. U ciɓa kpam kazuwamgbani ka uwulukpi ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Kazuwamgbani ka u tsina̱kai asheku a tsunu Ibirahi ka la vi. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Kpaci u wauwa tsu ta̱ a asu u atokulalu a tsunu, tsu gbashika yi bawu upana uwonvo. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Tsu gbashika yi n uwulukpi n ukuna u maci a kapala ka ne, gba̱ aꞌayin a tsunu. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Avu kpam maku ma va̱, a ka isa̱ vu ta̱ matsumate ma Kashila̱ Uza u Ucira Gba̱, kpaci va lasa ta̱ Asheku, tsa̱ra̱ vu foɓusuko yi ure. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Vu tonuko ama a ne ukuna u iwauwi i utsa̱ra̱ ucimbusa̱ u unyushi u le. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Adama a asuvayali a maci a Kashila̱ ka tsunu, a zuba ɗa katyashi ka kpasani ka wuta̱ tsu. ");
INSERT INTO kdlNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Tsa̱ra̱ u wakana aza ɗa aꞌa̱ri ndishi a karimbi, n aza ɗa a ka tuwa̱ a kuwa̱. U toni n a̱tsu a ure u ndishi n shinga.” ");
INSERT INTO kdlNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Aku maku ma gbonguroi a ikyamba n kulu cika. U dusuki a kakamba hal kain ka u wenikei kaci ka ne a asu u Isaraꞌila. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Aꞌayin a nala, Kaisa Agusta magono ma pige ma Roma, u zuwai a keci gba̱ ama ɗa aꞌa̱ri a uyamba† vi. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Makeci ma a gita̱i uyan ma la vi, aꞌayin a tsugono tsu Kiriniyu uza u karatsu ka pige u Suriya.) ");
INSERT INTO kdlNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ya dem gonoi a ilyuci i ne tsa̱ra̱ a korongu yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Isuhu dem ꞌya̱nga̱i a ilyuci i Nazara, a uyamba u Galili, u banai a uyamba u Yahuda. U banai a ilyuci i Dawuda iꞌya a ka isa̱ Batalami, kpaci eyi uza u kagali ka Dawuda ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Tsa̱ra̱ a korongu yi n Meri kamana ka ne, uza ɗa kpam wa̱ri n katsuma̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ele pini ɗe, aꞌayin a ilimaci a Meri a yain. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Aku u matsai maku ma vali ma kapala ma ne, u pala̱sa yi n kunya, aku u vakunku yi a asu u uneshe kuzuwate ilikulya. Kpaci a tsa̱ra̱ kunu ku amoci pini a kuwa ki wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","N kayin ka nala ki, aliniki a roku a ɗa pini a uroto u ilyuci vi, a ka wundya ishiga i nlala n le. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Aku katsumate ka zuba ka Magono ma Zuba ka wenikei kaci ka ne ara le. Aku tsupige tsu Magono ma Zuba tsu kyawan le n katyashi, hal uwonvo u ka̱na̱ le. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Shegai katsumate ki ka tonuko le, “Panai uwonvo wa, ukuna u shinga u ipeli u ɗa n tuko ɗa̱, u ɗa wa woko u ama gba̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ara na a matsa̱ka ɗa̱ ta̱ Kawauwi a Batalami, ilyuci i Dawuda, aya Kirisiti Asheku. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Iryoci iꞌya ya wene iꞌya na: Ya cina ta̱ a vakunki maku a asu u uneshe kuzuwate ilikulya, upala̱si n kunya.” ");
INSERT INTO kdlNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kute‑kute, kaɓolo ka aza a kuvon a zuba a ɓolomgbonoi n katsumate ki, a ka cikpala Kashila̱ n a dansi, ");
INSERT INTO kdlNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Una̱ka̱ u tsupige ubana a asu u Kashila̱ u shamgba ta̱ a asuvu a zuba a asu u ɗa u lai tsupige. A likimba tani ndishi n shinga n shamgba ta̱ a asu u ama ɗa wa pana kayanyan ka le cika.” ");
INSERT INTO kdlNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","An atsumate yi a gonoi a zuba, aliniki yi a tonukoi kaci ka le, “Tsu banai a Batalami tsu wene ili iꞌya Magono ma Zuba ma tonuko tsu i gita̱i vi.” ");
INSERT INTO kdlNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","A banai n maloko, a ba a cinai Isuhu, n Meri, n maku mi dem nvain a asu u uneshe kuzuwate ilikulya. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Aku aliniki a tonukoi ya dem ili iꞌya i gita̱i n iꞌya katsumate ka zuba ka tonuko le a kaci ka maku ma na mi. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Gba̱ ama ɗa a panai ukuna u na vi, a rongoi uyan majiyan ma ukuna u ɗa aliniki yi a tonuko le. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Shegai Meri ka̱na̱i ukuna vi n kabini a katsuma̱ ka ne, aku u rongoi u ciɓusa u ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Aliniki yi a gonoi, a rongoi una̱ka̱ Kashila̱ tsupige n a cikpali yi, adama a ili iꞌya katsumate ki ka tonuko le. Kpam n adama a ɗa a wenei maku mi tyoku ɗa katsumate ki ka tonuko le. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","An kain ka kulla̱ ka kyawain, kain ka a ka kiɗa yi kacombi, a neke yi kala Yesu. Kala ka katsumate ka zuba ka na̱ka̱ yi, kahu a yain katsuma̱ ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","An aꞌayin a uwulukpe a le a yain, tyoku ɗa u wa̱ri a Mele ma Musa, a matsa baci maku. Aku Isuhu n Meri a bankai Yesu a Urishelima, a na̱ka̱ yi a asu u Magono ma Zuba. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(Tyoku ɗa wa̱ri ukorongi, Mele ma Kashila̱ ma danai, “Maku ma uka u gita̱i u matsa kalobo ka baci, u ka̱na̱ ta̱ a na̱ka̱ yi a asu u Magono ma Zuba.”) ");
INSERT INTO kdlNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","A yain uɗara̱kpa tyoku ɗa Mele ma Kashila̱ ma danai, “Aꞌaɗya a re ko tani mmuku ma ntambara n re.” ");
INSERT INTO kdlNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Vuma roku u ɗa pini a Urishelima a ka isa̱ Saminu, vuma u maci kpam uza ɗa wa gbashika Kashila̱. Wa̱ ta̱ n Kulu Keri, kpam u ɓa̱ra̱kpa̱i wa vana utuwa̱ u Kirisiti Kawauwi u tuwa̱ u wauwa aza a Isaraꞌila. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Kulu Keri ku wenike yi wa kuwa̱ wa, she aꞌayin a ɗa u wenei Kirisiti u Magono ma Zuba. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kain ki, Kulu Keri ku zuwai u uwai a Kuwa ku Kashila̱. Meri n Isuhu a tuwa̱i, kotsu a na̱ka̱ Yesu a asu u Magono ma Zuba, tyoku ɗa Mele ma da a yain. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Aku Saminu woɓo yi, u cikpai Kashila̱, u danai, ");
INSERT INTO kdlNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Gogo‑na, Ashekapige, she vu a̱sa̱ka̱ kagbashi ka vunu ka laza bawu ukuna u roku, tyoku ɗa vu danai. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kpaci n wene ɗe iwauwi i vunu ");
INSERT INTO kdlNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","iꞌya vu foɓusoi a kapala ka ama gba̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Aya katyashi ka ka wenike Awulawa† ure u vunu, aya kpam tsupige tsu ama a vunu Isaraꞌila.” ");
INSERT INTO kdlNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tata na̱ mma u ne a yain majiyan a ili iꞌya a danai a kaci ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Aku Saminu zuwuka le una̱ u shinga. Aku u tonukoi mma u ne vi, “Vu wene maku ma na mi? Aya a zuwai u woko ure u urukpa̱ u aza roku n u uꞌya̱nga̱ u aza roku ushani a asuvu a Isaraꞌila. Kpam Kashila̱ ka suku yi ta̱ u woko iryoci, shegai aza roku a ka ꞌyuwan yi ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Kotsu a wutukpa̱ uyawunsa u atakasuvu ushani a kateshe. Avu tani burundu wa ɓatsamgbana ta̱ katakasuvu ka vunu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Matsumate ma ma̱ri uka, uza u kala Hanatu, wa̱ ta̱ dem pini a Kuwa ku Kashila̱ ki, ukere u Fanuyila u ɗa, uza u kagali ka Ashiru. Mara̱na̱ ma, kpam u kutsa ta̱ cika. Iyolo i ayen a shindere a ɗa u yain n vali u ne an u bidya yi n tsikere. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Gba̱ ayen a ne hal n a ɗa a tsira̱na̱ tsu ne dem a ɗa yi amanganishi n a nishi. U a̱sa̱ka̱ Kuwa ku Kashila̱ wa, shegai ulya kayala kaara n kayin, n u yanyi kakuli n kavasu. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Tyoku ɗa Saminu wa̱ri a kadyanshi n Isuhu n Meri, eyi dem u tuwa̱i evu n ele, u cikpai Kashila̱. U ka̱na̱i kadyanshi ka maku mi a kapala ka ama ɗa a ka vana uwutukpa̱ u Urishelima. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","An a kotsoi gba̱ ili iꞌya Mele ma Kashila̱ ma danai, a gonoi a ilyuci i Nazara u uyamba u Galili. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nte maku mi ma gbonguroi u tukoi ucira pini. A shaɗangu yi n ugboji u ɗa u wurai aꞌayin a ne. Kpam Kashila̱ ka zuwuka yi una̱ u shinga. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kayen dem, isheku i Yesu i tsu bana ta̱ a Urishelima aꞌayin a Abiki a Upasamgbana. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","An u yain ayen kupa n a re, a banai Abiki yi tyoku ɗa a cuwana̱kai. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","An a kotsoi Abiki yi, isheku i ne i ka̱na̱i ure u ugono. Yesu shamgbai a Urishelima, bawu a revei. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","A yain nwalu ma uliva̱, a ka wundya ko wa̱ pini a asuvu a kaɓolo ki, shegai a wene yi wa. Aku a ka̱na̱ yi uzama a asu a amaci† n aje a le. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","An a kpa̱ɗa̱ yi uwene, a gonoi a Urishelima ubolo u ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","An aꞌayin a tatsu a wurai, a cina yi ndishi a asuvu a Kuwa ku Kashila̱ a mere ma awenishiki. Wa pana̱ka le n u yansi le keci. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Gba̱ ama ɗa a pana̱ka yi a yain majiyan n ureve u ne, n tyoku ɗa wa wushukusu. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","An isheku i ne i wene yi, a yain majiyan, aku mma u ne danai, “Maku ma va̱, ndya i zuwai vu yanka tsu naha? Mpa n asheku a vunu tsa̱ri vu uzama n katsuma̱ unamgbi.” ");
INSERT INTO kdlNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Aku u wece le, “Ndya i zuwai ya zama mu? I reve u ka̱na̱i n rongo a asu u Tata u va̱ wa?” ");
INSERT INTO kdlNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Shegai a reve ili iꞌya u tonuko le wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Aku u gonoi a Nazara kaɓolo n ele, u rongo le una̱ka̱ tsupige. Mma u ne tani u ka̱na̱i ukuna u nala vi a katakasuvu ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu gbonguroi a ikyamba n kakiri, kpam Kashila̱ n ama ɗa a reve yi a ciga yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","A kayen ka kupa n u tawun ka tsugono tsu Kaisa Tibariya magono ma pige ma Roma, a yan ta̱ ngono n nishi aza ɗa a lyai tsugono tsu iyamba i Isaraꞌila a kere ka ne, alya: Bontu Bilatu wa̱ri gomuna u Yahuda, Hiridu Antiba wa̱ri magono ma Galili, vangu u ne Filibu wa̱ri magono ma Ituriya n Tarakunita, Lisaniya wa̱ri magono ma Abiliya. ");
INSERT INTO kdlNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Aꞌayin a Hanana n Kayafa ngono m aɗara̱kpi, kadyanshi ka Kashila̱ ka tuwa̱i ara Yahaya maku ma Zakariya a kakamba. ");
INSERT INTO kdlNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","U banai gba̱ a iyamba iꞌya iꞌa̱ri uɓongu u Aga̱ta̱ u Urudu n u yanyi kuɓari: ama a kpatala ubana a asu u Kashila̱ a a̱sa̱ka̱ tsicingi tsu le, aku a lyuɓugu le tsa̱ra̱ u wenike an a cimbusuka̱ le. ");
INSERT INTO kdlNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tyoku ɗa wa̱ri ukorongi a Tagara̱da u Ishaya matsumate a ukuna u Yahaya Kalyuɓugi: “Kala̱ga̱tsu ka uza roku ka sala̱sa a kakamba, ‘Lapulukai Asheku Kawauwi ure, i shamkpa u ɗa mai tsa̱ra̱ u wala. ");
INSERT INTO kdlNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","A ka shaɗangu ta̱ gba̱ ara̱ra̱, kpam a betelikpe gba̱ nsasa n aga̱la̱la̱. A shamkpa ire iꞌya i kotolusoi, aku a gbandala iꞌya iꞌa̱ri n aɗa̱ka̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kpam ama gba̱ a ka wene ta̱ iwauwi i Kashila̱.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yahaya tonukoi kakuma̱ ka ama ka ka tuwusa̱ tsa̱ra̱ u lyuɓugusu le vi, “Eɗa̱ aꞌeku! Ya ɓarana ɗa̱ i suma unamgbukatsuma̱ u Kashila̱ u ɗa wa tuwa̱? ");
INSERT INTO kdlNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Yanyi ili iꞌya ya wenike ukpatala u ɗe. Kotsu i bidya a asuvu a atakasuvu a ɗe Ibirahi ɗa asheku a ɗe wa, nala wa ɓa̱nga̱ ɗa̱ wa. N tonuko ɗa̱, Kashila̱ ka fuɗa ta̱ ka ꞌya̱nga̱sa̱ka̱ Ibirahi mmuku a asuvu a atali a na yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","N gogo‑na naha a taɗangu ɗe kagovu a ami a nɗanga. Maɗanga ma baci dem ma kpa̱ɗa̱i u na̱ka̱ ilimaci i maci, a ka kapa ta̱ ma, a varangu a asuvu a akina.” ");
INSERT INTO kdlNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kakuma̱ ka ama ka wece yi, “Ndya wa̱ tsa yan gogo‑na?” ");
INSERT INTO kdlNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","U wushuki, “Uza u ntogo n re, u peci n uza ɗa bawu wa̱ri n ma. Uza u ilikulya kpam dem u yain nala.” ");
INSERT INTO kdlNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Awushi a utafa a roku a tuwa̱i tsa̱ra̱ a lyuɓugu le, a wece yi, “Kawenishiki, ndya tsa yan?” ");
INSERT INTO kdlNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","U tonuko le, “Kotsu i pasa̱ka a ili iꞌya a da i wushi wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Aku asoje a roku a wece yi, “A̱tsu tani, ndya tsa yan?” U tonuko le, “Kotsu i wusa uza ikebe wa. Ko i dana uza u nusa ta̱, kpam u nusa wa. I kawunku gai n katsupi ka ɗe.” ");
INSERT INTO kdlNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ama gba̱ aꞌa̱ri a ka vana ta̱ utuwa̱ u Kirisiti Kawauwi, aku aꞌa̱ri a uyawunsa a atakasuvu a le, ko Yahaya ɗa Kawauwi ki. ");
INSERT INTO kdlNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yahaya wushunku le gba̱, u danai, “Mpa gai n mini ma ma lyuɓugusu ɗa̱, shegai uza ɗa u la mu wa tuwa̱ ta̱. Uza ɗa mpa n ra̱tsa n surukpa isirikatsu i akpata i aꞌene a ne wa. Aya wa lyuɓugu ɗa̱ n Kulu Keri n akina. ");
INSERT INTO kdlNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kasasu ka uwelimkpe ka ne ka̱ ta̱ a kukere ku ne, wa wujuma̱ ta̱ asu u ulapa ilya vi, aku u cira̱ngu ilya yi u tsungu iꞌya a mapon. Shegai wa runukpa ta̱ kopo ki n akina† a ɗa bawu a ka cimba̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","N icun i kuɓari ku na ki ushani, ka Yahaya yankai ama Kadyanshi ka Shinga ka Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Shegai Yahaya ɓaranai Hiridu Antiba magono a kaci ka Hiridiya, uka u vangu u ne u ɗa u zuwai, n ukuna u cingi u roku u ɗa u yain. ");
INSERT INTO kdlNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Adama a nala u gbagiryai Yahaya a kuwa ku aꞌali, u dokunki kaci ka ne unyushi u cingi u na vi. ");
INSERT INTO kdlNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","An a lyuɓugusi ama gba̱, a lyuɓugi dem Yesu. Tyoku ɗa Yesu wa̱ri a kavasu, zuba u kukpa̱i. ");
INSERT INTO kdlNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Pini nala, Kulu Keri ku cipa̱i ara ne yavu kaɗya. A panai kala̱ga̱tsu ka wuta̱i a zuba, ka danai, “Aɗa Maku ma va̱ ma ma ciga. Ma pana ta̱ kayanyan n avu cika.” ");
INSERT INTO kdlNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Aꞌayin a ɗa Yesu gita̱i manyan ma ne, wa̱ ta̱ n ayen evu n kamankupa. Tyoku ɗa kpam ama a bidyai Yesu maku ma Isuhu ma. Isuhu maku ma Heli ma. ");
INSERT INTO kdlNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli maku ma Matat ma. Matat maku ma Levi ma. Levi maku ma Mala̱ki ma. Mala̱ki maku ma Yana ma. Yana maku Isuhu ma. ");
INSERT INTO kdlNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Isuhu maku ma Matiya ma. Matiya maku ma Emos ma. Emos maku ma Nahum ma. Nahum maku ma Hasa̱li ma. Hasa̱li maku ma Najaya ma. ");
INSERT INTO kdlNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Najaya maku ma Maꞌata ma. Maꞌata maku ma Matiya ma. Matiya maku ma Shimeya ma. Shimeya maku ma Isuhu ma. Isuhu maku ma Yahuda ma. ");
INSERT INTO kdlNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yahuda maku ma Yowana ma. Yowana maku ma Risa ma. Risa maku ma Zerubabe ma. Zerubabe maku ma Shayala̱tiya ma. Shayala̱tiya maku ma Niri ma. ");
INSERT INTO kdlNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Niri maku ma Mala̱ki ma. Mala̱ki maku ma Adi ma. Adi maku ma Kosuma ma. Kosuma maku ma Alumadama ma. Alumadama maku ma Iri ma. ");
INSERT INTO kdlNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Iri maku ma Yosi ma. Yosi maku ma Eliyaza ma. Eliyaza maku ma Yorima ma. Yorima maku ma Matat ma. Matat maku ma Levi ma. ");
INSERT INTO kdlNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi maku ma Saminu ma. Saminu maku ma Yahuza ma. Yahuza maku ma Isuhu ma. Isuhu maku ma Yunam ma. Yunam maku ma Eliyakim ma. ");
INSERT INTO kdlNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim maku ma Malaya ma. Malaya maku ma Mainana ma. Mainana maku ma Matata ma. Matata maku ma Natan ma. Natan maku ma Dawuda ma. ");
INSERT INTO kdlNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawuda maku ma Yese ma. Yese maku ma Ubida ma. Ubida maku ma Boza ma. Boza maku ma Salumuna ma. Salumuna maku ma Nashon ma. ");
INSERT INTO kdlNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashon maku ma Aminadabu ma. Aminadabu maku ma Aram ma. Aram maku ma Hesuruna ma. Hesuruna maku ma Farisa ma. Farisa maku ma Yahuza ma. ");
INSERT INTO kdlNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yahuza maku ma Yakubu ma. Yakubu maku ma Ishaku ma. Ishaku maku ma Ibirahi ma. Ibirahi maku ma Tera ma. Tera maku ma Naho ma. ");
INSERT INTO kdlNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naho maku ma Seru ma. Seru maku ma Reyu ma. Reyu maku ma Fele ma. Fele maku ma Eba ma. Eba maku ma Shela ma. ");
INSERT INTO kdlNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shela maku ma Kenan ma. Kenan maku ma Afaka̱sha ma. Afaka̱sha maku ma Shem ma. Shem maku ma Nuhu ma. Nuhu maku ma Lame ma. ");
INSERT INTO kdlNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lame maku ma Metusela ma. Metusela maku ma Anuhu ma. Anuhu maku ma Jare ma. Jare maku ma Mahalalel ma. Mahalalel maku ma Kenan ma. ");
INSERT INTO kdlNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan maku ma Enos ma. Enos maku ma Shitu ma. Shitu maku ma Ada̱mu† ma. Ada̱mu kpam uza ɗa u wuta̱i a asu u Kashila̱ ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Pini nala, Yesu a̱sa̱ka̱i Aga̱ta̱ a Urudu ushaɗangi n Kulu Keri, aku Kulu Keri ku tonoi n eyi ubana a kakamba. ");
INSERT INTO kdlNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","U yan ta̱ aꞌayin a amangare, Kala̱pa̱nsi ka̱ri yi ukonduso. A asuvu a aꞌayin a nala yi u lya ko ili wa, an aꞌayin yi a kotsoi, aku u panai kambulu. ");
INSERT INTO kdlNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Pini nala, Kala̱pa̱nsi ka tonuko yi, “Avu Maku ma Kashila̱ ma baci, yanka katali ka na kadyanshi ka gono burodi.” ");
INSERT INTO kdlNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu wushunku yi, “Ukorongi u ɗa wa̱ri a Tagara̱da u Kashila̱, ‘N burodi ɗa koshi vuma wa yan uma wa.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kala̱pa̱nsi ki ka banka yi a zuba a asu u roku, u wenishike yi gba̱ tsugono tsu likimba, kahu a yain aꞌeshi rapu. ");
INSERT INTO kdlNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","U tonukoi Yesu, “Ma na̱ka̱ vu ta̱ gba̱ tsupige n ucira u le, kpaci mpa a na̱ka̱i. Ma̱ ta̱ n ucira u ɗa ma na̱ka̱ uza ɗa ma ciga. ");
INSERT INTO kdlNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Va lyaka mu baci kayala, ya woko ta̱ i vunu gba̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu wushunku yi, “Ukorongi u ɗa wa̱ri a Tagara̱da u Kashila̱, ‘Lyaka Magono ma Zuba Kashila̱ ka vunu kayala, aya koshi va gbashika.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Aku Kala̱pa̱nsi ka banka yi a Urishelima, u zuwa yi u shamgbai a zuba u Kuwa ku Kashila̱ ku ugaɗi bilibili. U tonuko yi, “Avu Maku ma Kashila̱ ma baci, raɗugu a utuwa̱ a iyamba. ");
INSERT INTO kdlNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kpaci ukorongi u ɗa wa̱ri a Tagara̱da u Kashila̱, ‘Wa yanka ta̱ atsumate a zuba a ne kadyanshi adama a vunu, a kirana n avu. ");
INSERT INTO kdlNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kpam a ka keɓe vu ta̱ a akere a le, adama a ɗa va gbasha kune a katali.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu wushunku yi, “A korongu ta̱ dem, ‘Va kondo Magono ma Zuba Kashila̱ ka vunu wa.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","An Kala̱pa̱nsi ka kotsoi ukonduso u ne gba̱, aku u a̱sa̱ka̱ yi ve. ");
INSERT INTO kdlNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Pini nala, Yesu gonoi a uyamba u Galili, ucira u Kulu Keri wa̱ ta̱ kaɓolo n eyi. Ukuna u ne u kyawain gba̱ a uyamba vi. ");
INSERT INTO kdlNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","U rongoi a uwenishike a agata a Kashila̱ a le, gba̱ ama n a na̱ki yi tsupige. ");
INSERT INTO kdlNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","An Yesu tuwa̱i a Nazara (asu u ɗa a wo yi), aku u uwai a kagata ka Kashila̱ kain ka Ashibi, tyoku ɗa u cuwana̱kai. U ꞌya̱nga̱i kushani, kotsu u yain ka̱neshi. ");
INSERT INTO kdlNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","A na̱ka̱ yi tagara̱da u Ishaya matsumate, u ba̱ra̱kpa̱i tagara̱da vi, u cinai a asu u ɗa a korongi: ");
INSERT INTO kdlNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Kulu ku Magono ma Zuba ka̱ ta̱ kaɓolo na̱ mpa, u ɗanga̱sa mu n yanka aza a unambi Kadyanshi ka Shinga ka Kashila̱. U suku mu n tuwa̱ n yain kadyanshi ka utatsukpa a asu u aza ɗa a sirai, n kukpa̱ aꞌeshi a arumba̱, n wauwa aza ɗa a ꞌyanki, ");
INSERT INTO kdlNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","n yain kadyanshi ka kayen ka Magono ma Zuba ma yan ili i shinga.” ");
INSERT INTO kdlNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","U ka̱ta̱la̱i tagara̱da vi u gonukoi a asu u uza u manyan, aku u dusuki tsa̱ra̱ u wenishike. Gba̱ aza ɗa aꞌa̱ri pini a kagata ka Kashila̱ ki a gita̱ yi aka̱lu. ");
INSERT INTO kdlNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Aku u gita̱ le utonusuko, “Ara, udani naha u shaɗangu ɗe a atsuvu a ɗe.” ");
INSERT INTO kdlNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Gba̱ le a cikpala yi, a yain majiyan ma kadyanshi ka shinga ka u yain, hal a danai, “Eyi na maku ma Isuhu ma wa?” ");
INSERT INTO kdlNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","U tonuko le, “Ya yanka mu ta̱ tsizagaɗi tsu na tsi, ‘Kana̱ki ka aguma̱, ta̱na̱sa̱ kaci ka vunu.’ Wata, ‘Gba̱ ikunesavu iꞌya tsu panai vu yansai a Kafarnahum, yan iꞌya dem pini na a ilyuci i vunu.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Mayun ɗa n tonuko ɗa̱, matsumate ma̱ la ma a wushuki n eyi a ilyuci i ne wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Shegai mayun n tonuko ɗa̱, aꞌayin a Iliya, nra̱na̱ n ɗa pini ushani a Isaraꞌila. Aꞌayin a ɗa a shamkpai mini ma zuba hal ayen a tatsu n uwoto u teli, aꞌayin a ɗa kambulu ka pige ka kimba̱i gba̱ uyamba vi. ");
INSERT INTO kdlNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Gba̱ n nala, a suku Iliya a asu ko uza a asuvu a le wa, she a asu u mara̱na̱ ma ma̱ri a Zarafatu a uyamba u Sida. ");
INSERT INTO kdlNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Aꞌayin a Elisha† matsumate, a yan ta̱ nkutu ushani a uyamba u Isaraꞌila. Uza wa̱ tani la uza ɗa a ta̱na̱sa̱i wa, she Naꞌaman† koshi, vuma u uyamba u Suriya.” ");
INSERT INTO kdlNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ama ɗa aꞌa̱ri pini a kagata ka Kashila̱ ki a panai upan, an a panai nala vi. ");
INSERT INTO kdlNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Aku a ꞌya̱nga̱i a wutukpa̱ yi a uroto u ilyuci. A banka yi a zuba u masasa ma ma̱ri evu n ilyuci yi, kotsu a varangu yi a iyamba. ");
INSERT INTO kdlNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Shegai u wurai a mere ma le, u yain nwalu n ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Pini nala, Yesu banai a Kafarnahum, ilyuci i roku a uyamba u Galili, wa̱ri le a uwenishike kain ka Ashibi. ");
INSERT INTO kdlNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","A yain majiyan n uwenishike u ne, kpaci kadyanshi ka ne n ucira u ɗa ka̱ri. ");
INSERT INTO kdlNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","A kagata ka Kashila̱ ki tani, uza u ityoni i cingi u ɗa pini. Aku u ꞌya̱nga̱sa̱i kala̱ga̱tsu ka ne n ucira, u salai, ");
INSERT INTO kdlNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Wayai! Ndya i birika vu n a̱tsu, Yesu uza u Nazara? Tuwa̱ ɗa vu tuwa̱i vu wuna tsu? N reve ta̱ uza ɗa va̱ri. Uza u uwulukpi u nala vi u ɗa u Kashila̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Aku Yesu ɓarana yi, u da, “Paɗa bini! Pecemgbene n eyi!” Aku ityoni i cingi yi i varangu yi a iyamba a mere ma le, i pecemgbenei n eyi. U yanka yi tani ukuna u cingi wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","A yain majiyan gba̱ le, a ka dansa utyoku u le, “Icun i kadyanshi i eni iꞌya na vi? Ka na n ucira n tsupige, hal u tsu ɓarana ityoni i cingi, aku a wuta̱?” ");
INSERT INTO kdlNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ukuna u ne tani u tamburai ko nte wa a uyamba vi. ");
INSERT INTO kdlNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Aku Yesu a̱sa̱ka̱i kagata ka Kashila̱ ki, u uwai a kuwa ku Bituru. Mma u uka u Bituru tani wa̱ ta̱ n usuɗugbi u ikyamba, aku a folo yi u ta̱na̱sa̱ yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","U shamgbai evu n kaci ka ne, u ɓaranai maɓa̱la̱ mi, aku ma a̱sa̱ka̱ yi. Kute‑kute, u ꞌya̱nga̱i u gita̱ le uyanka manyan. ");
INSERT INTO kdlNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","An kaara ka rukpa̱i, gba̱ aza ɗa aꞌa̱ri n aza a mɓa̱la̱ icun kau‑kau, a tuwusuka̱ le a asu u ne. Aku u taɗangusuku le akere a aꞌaci a le, u ta̱na̱sa̱ le. ");
INSERT INTO kdlNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ityoni i cingi kpam i wuta̱i a asu u ama ushani, aꞌa̱ri iyoroli n a dansi, “Avu Maku ma Kashila̱ ma!” Shegai u ɓarana le, u ɓishinka le kadyanshi, kpaci a reve ta̱ eyi Kirisiti Kawauwi ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","An kain ka wansai, Yesu wuta̱i u banai a asu u ɗa bawu uza wa̱ri pini. Aku kakuma̱ ka ama ka̱ri yi uzama, a banai a asu u ɗa wa̱ri. Uciga u le u ɗa a shamkpa yi, kotsu u a̱sa̱ka̱ le wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Shegai u tonuko le, “U ka̱na̱ ta̱ n yain kadyanshi ka tsugono tsu Kashila̱ a ilyuci iꞌya i buwai, kpaci adama a nala a ɗa a suku mu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Aku u lyai kapala n u yanyi kuɓari a agata a Kashila̱ a uyamba u Yahuda. ");
INSERT INTO kdlNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Kain ka te, Yesu wa̱ri kushani a ikengi i Kushiva̱ ku Galili, kakuma̱ ka ama ka gbaɓaryangu yi, aꞌa̱ri upana kadyanshi ka Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","U wenei aꞌatsu a re a ɗa aka̱ni a adan a a̱sa̱ka̱i ikengi i kushiva̱ yi. Aꞌa̱ri uɓacangusu ibilili i le. ");
INSERT INTO kdlNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Aku u ba u uwai a asuvu a kpatsu ku Simo. An u uwai a asuvu, u tonukoi Simo jebe u vinga̱ kpatsu ki kenu u a̱sa̱ka̱ ikengi i kushiva̱ yi. Aku u dusuki u ka̱na̱i uwenishike ama, eyi pini a asuvu a kpatsu ki. ");
INSERT INTO kdlNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","An u kotsoi kadyanshi, u tonukoi Simo, “Uka kpatsu ki a asu u ɗa wa̱ri n kaɗa̱ka̱, kotsu i vuta̱la̱ ibilili i ɗe i ka̱na̱ adan.” ");
INSERT INTO kdlNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simo wushunku yi, “Uzakuwa, nte kain ka wansa tsu pini na tsa̱ri uyan manyan, kpam ko i te tsu ka̱na̱ wa. Shegai an u wokoi vu danai nala, ma vuta̱la̱ ta̱ ibilili yi.” ");
INSERT INTO kdlNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","An a yain nala, a ka̱na̱i adan ushani, hal ibilili i le i ka̱na̱i ukiɗa̱sa. ");
INSERT INTO kdlNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Adama a nala, a isa̱i atoku a le a ɗa aꞌa̱ri a kpatsu ku ire ki a tuwa̱ a ɓa̱nga̱ le. A tuwa̱i a shaɗangusi aꞌatsu yi a re gba̱ n adan, hal aꞌatsu yi a yain yavu a ka shumbugu. ");
INSERT INTO kdlNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Pini nala, an Simo uza ɗa a ka isa̱ Bituru wenei nala, u kuɗa̱ngi a kapala ka Yesu, u danai, “Asheku, ba̱tsa̱ pini dan na̱ mpa, kpaci mpa uza u unyushi u cingi u ɗa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ili iꞌya i zuwai tani, eyi n atoku a ne a yan ta̱ majiyan, an a ka̱na̱i adan nala. ");
INSERT INTO kdlNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nala tani kpam dem Yakubu n Yahaya, mmuku n Zabidi, atoku a manyan a Simo. Yesu tonukoi Simo, “Pana uwonvo wa. Ili iꞌya i bidyai gogo‑na naha ubana a kapala, ma gonuko vu ta̱ uza ɗa wa tukuso ama.” ");
INSERT INTO kdlNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","A wutukpa̱i aꞌatsu a le a kagiɗa, aku a a̱sa̱ka̱i gba̱ ili iꞌya aꞌa̱ri n iꞌya, a tono yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Kain ka te, Yesu wa̱ri a ilyuci i roku a uyamba u nala vi, aku vuma roku, uza u mɓa̱la̱ n tsukutu, u tuwa̱i ara ne. An u wenei Yesu, u kuɗa̱ngi a kapala ka ne, u folo yi u da, “Asheku, vu wushuku baci, va̱ ta̱ n ucira u ɗa va ta̱na̱sa̱ mu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu ba̱ra̱kpa̱i kukere, u sawa yi, u da, “N wushuku ta̱, ta̱na̱.” Kute‑kute, tsukutu tsi tsu a̱sa̱ka̱ yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","U ronoi vuma vi atsuvu, u da, “Kotsu vu tonuko uza wa, shegai wala vu ba vu wenike kaci ka vunu a asu u kaɗara̱kpi. Kpam vu na̱ka̱ kune tyoku ɗa Musa danai a yain, adama a ɗa vu ta̱na̱i, tsa̱ra̱ ama a reve n u ɗa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Shegai gba̱ n nala, kadyanshi ka Yesu ka̱ri a utambura, hal kakuma̱ ka ama ushani ka tuwusa̱i ka pana̱ka yi, tsa̱ra̱ a ta̱na̱sa̱ mɓa̱la̱ n le. ");
INSERT INTO kdlNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Shegai u tsu bana ta̱ a asu u ɗa bawu ama aꞌa̱ri, n u yanyi kavasu. ");
INSERT INTO kdlNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Kain ka te, an Yesu wa̱ri a uwenishike, Afarishi n awenishiki a Mele a roku aꞌa̱ ta̱ pini ndishi. Aza ɗa a wuta̱i gba̱ a ilyuci i uyamba u Galili n aza a Yahuda n Urishelima. Kpam ucira u Magono ma Zuba u uta̱na̱sa̱ u mɓa̱la̱ wa̱ ta̱ n eyi. ");
INSERT INTO kdlNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ama roku a tuwa̱i n kawunu, a canga yi a kajiba. A ka ciga a uka yi a kunu, tsa̱ra̱ a zuwa yi a kapala ka Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","An a kpa̱ɗa̱i utsa̱ra̱ ure u ɗa a ka uka yi, adama a kakuma̱ ka ama, a yuwa̱i a zuba u kukpa̱. A ɗapai kukpa̱ ki, aku a zurala̱kpai vuma vi a mere ma kakuma̱ ki, pini a kapala ka Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","An Yesu wenei upityanangu u le, u da, “Uza u va̱, a cimbusuka̱ vu ɗe unyushi u cingi u vunu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Aku awenishiki a Mele n Afarishi yi a gita̱i uyawunsa a atakasuvu a le, “Ucun u vuma u eni u ɗa na n uyansa̱ka Kashila̱ kadyanshi ka cingi naha? Ya wa fuɗa u cimbusa̱ unyushi u cingi? She Kashila̱ koshi.” ");
INSERT INTO kdlNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Shegai an Yesu revei tyoku ɗa a ka yawunsa, u wece le, “Ndya i zuwai ya yawunsa naha a atakasuvu a ɗe? ");
INSERT INTO kdlNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ndya i lai shana u ɗa a ka dana, ‘A cimbusa̱ ɗe unyushi u cingi u vunu,’ ko, ‘ꞌYa̱nga̱ vu wala’? ");
INSERT INTO kdlNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kondoi na, kotsu i reve an mpa Maku ma Vuma ma̱ri n ucira u ɗa ma cimbusa̱ unyushi u cingi a likimba.” U tonukoi kawunu ki, “N tonuko vu, ꞌya̱nga̱ vu bidya kajiba ka vunu vu wala a kuwa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kute‑kute a kapala ka le, u ꞌya̱nga̱i u bidyai kajiba ka ne. U lazai a kuwa n u cikpali Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","A yain majiyan cika, gba̱ kakuma̱ ki ka rongoi ucikpala̱sa Kashila̱, uwonvo kpam u ka̱na̱ le, a danai, “Ara tsu wene ta̱ ukuna u savu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","An nala u wurai, aku Yesu wuta̱i. Pini nala, u wenei kawushi ka utafa ka roku uza u kala Levi. U cina yi ndishi a kakinda ka uwusha u utafa ka ne. Aku u tonuko yi, “Tono mu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","U a̱sa̱ka̱i ko ndya wa, u ꞌya̱nga̱i u tono yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Levi foɓusuko yi abiki a pige a kuwa ku ne. Kpam awushi a utafa a roku a ɗa dem pini ushani n ama roku a ka lya kaɓolo n ele. ");
INSERT INTO kdlNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Aku Afarishi n awenishiki a Mele a ka yanka atoni a ne tsali, a danai, “Ndya i zuwai ya lya kaɓolo n awushi a utafa n aza a unyushi u cingi?” ");
INSERT INTO kdlNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu wushunku le, “Aza ɗa aꞌa̱ri n alafiya a ka ciga uza u aguma̱ wa, she aza a mɓa̱la̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","N tuwa̱ adama a ɗa ma isa̱ aza a maci wa, shegai adama a aza a unyushi u cingi, tsa̱ra̱ a kpatala.” ");
INSERT INTO kdlNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","A tonukoi Yesu, “Atoni a Yahaya a tsu yansa ta̱ kakuli n kavasu, nala dem atoni a Afarishi, shegai ndya i zuwai atoni a vunu a ka lya n a soyi?” ");
INSERT INTO kdlNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","U wece le, “Amoci a asu u abiki a iyolo a tsu yan kakuli, a ka yan baci abiki kaɓolo n valisavu vi? ");
INSERT INTO kdlNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Aꞌayin aꞌa̱ ta̱ a utuwa̱ a ɗa a ka bidya valisavu vi a mere ma le, aꞌayin a nala a ɗa a ka yan kakuli.” ");
INSERT INTO kdlNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","U tonuko le kpam agisani a na yi, u danai, “Uza wa kara kakashi a kunya ku savu, aku u paɗara ka a kunya ku cau wa. U yan baci nala, wa nangasa ta̱ ku savu ki. Kpam kakashi ka savu ka a paɗarai a kunya ku cau ki ka rotso ka wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Vuma wa tsungu mini ma cinwi ma savu a kadele ka ukpan ka cau wa. U yan baci nala, ma ta̱sa̱ ta̱ kadele ki ma wotsongu. Kadele ki tani ka namgba. ");
INSERT INTO kdlNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Shegai a tsungu mini ma cinwi ma savu a kadele ka ukpan ka savu. ");
INSERT INTO kdlNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kpam uza wa̱ la wa so mini ma cinwi ma cau, aku u dana wa ciga ma savu wa. Kpaci wa dana ta̱, ‘Ma cau mi ma la ta̱ ma savu mi tsulobo.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kain ka te n kain ka Ashibi, Yesu wa wura ashina a ilya kaɓolo n atoni a ne, pini nala, atoni yi a gita̱i ukoɗuso aratu a ilya n a yuruwi n a takumi. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Afarishi a roku a danai, “Ndya i zuwai ya yan ili iꞌya i nangasai mele ma Ashibi?” ");
INSERT INTO kdlNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu wushunku le, “Eɗa̱ kotsu i yan ka̱neshi u ili iꞌya Dawuda yain, aꞌayin a ɗa u panai kambulu, eyi n aje a nwalu a ne wa? ");
INSERT INTO kdlNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","An u uwai a Kuwa ku Kashila̱, u bidyai iburodi i uwulukpi u takumai. Ili iꞌya aɗara̱kpi a ɗa koshi a wushunki a takuma. Kpam u na̱ka̱i aje nwalu n ne i roku.” ");
INSERT INTO kdlNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Pini nala, u tonuko le, “Maku ma Vuma ma Asheku a kain ka Ashibi.” ");
INSERT INTO kdlNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kain ka Ashibi ka roku, Yesu uwai a kagata ka Kashila̱ wa̱ri a uwenishike. Pini a asuvu yi, uza roku u ɗa pini uza ɗa ili i soi kukere ku ulyaki ku ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Aku awenishiki a Mele n Afarishi a ka putsa̱ yi ko wa ta̱na̱sa̱ yi n kain ka Ashibi ki, kotsu a tsa̱ra̱ unyushi u ɗa a ka ba a sapula yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Eyi tani u revei uyawunsa u le, aku u tonukoi vuma vi, “ꞌYa̱nga̱ vu shamgba a mere.” Aku u ꞌya̱nga̱i u shamgbai. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","U tonuko le, “Ma wece ɗa̱, ndya iꞌa̱ri dere kain ka Ashibi? A yain ili i shinga, ko a yain i cingi? A wauwa uma, ko a wuna u ɗa?” ");
INSERT INTO kdlNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Aku u lingana le gba̱ le, u tonukoi vuma vi, “Ba̱ra̱kpa̱ kukere ku vunu.” U ba̱ra̱kpa̱i kukere ki, aku ku ta̱na̱i. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","A panai upan cika, a gita̱i usheshe tyoku ɗa a ka yan n Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Aꞌayin a nala yi, Yesu wuta̱i u yuwa̱i masasa tsa̱ra̱ u yain kavasu. U rongoi uyan kavasu ubana a asu u Kashila̱ hal kain ka wansai. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","An kain ka wansai, u isa̱i atoni a ne, aku u ɗanga̱sai kupa n ama a re a asuvu a le, u isa̱ le asuki. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Alya Simo (uza ɗa u isa̱i Bituru) n utoku u ne Andurawu n Yakubu, n Yahaya, n Filibu, n Batalamawu. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","U ɗanga̱sa ta̱ dem Matiyu, n Toma n Yakubu maku ma Halfa, n Simo uza ɗa a ka isa̱ Ziloti. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","U ɗanga̱sai kpam Yahuza maku ma Yakubu, n Yahuza Isikariyoti uza ɗa u tuwa̱i u neke yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Aku u gida̱la̱i kaɓolo n ele, u shamgbai a asu u ɗa wa̱ri kateshe. Kakuma̱ ka atoni a ne, n kakuma̱ ka ama ushani a tuwa̱i a pana̱ka yi, tsa̱ra̱ a ta̱na̱sa̱ le. A wutusa̱i a uyamba u Yahuda n Urishelima, n aza ɗa aꞌa̱ri a Taya n Sida u una̱ u kushiva̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","N aza ɗa ityoni i cingi ya yan mavura dem, a ta̱na̱sa̱ le. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Gba̱ ama yi a ka ciga a sawusa yi, kpaci ucira wa wutusa̱ ta̱ a asuvu a ne, u ta̱na̱sa̱ le gba̱ le. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Aku Yesu gaɗigbai kaci ka ne, u weɓelei atoni a ne, u danai: “Eɗa̱ aza a una̱ u shinga a ɗa, eɗa̱ aza a unambi, kpaci tsugono tsu Kashila̱ tsu ɗe tsa. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Eɗa̱ aza a una̱ u shinga a ɗa, eɗa̱ aza ɗa ya yan kambulu gogo‑na, kpaci a ka cuwa̱ta̱ngu ɗa̱ ta̱. Eɗa̱ aza a una̱ u shinga a ɗa, eɗa̱ aza ɗa ya sa̱ gogo‑na, kpaci ya dosuso ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Eɗa̱ aza a una̱ u shinga ɗa, aꞌayin a ɗa ama a ꞌyuwan ɗa̱, a wutukpa̱ ɗa̱ a asuvu a le, a wisha ɗa̱, a panai icaɗi i ɗe adama a va̱ Maku ma Vuma. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Pelei a kain ki, i raɗugusu n maza̱nga̱, kpaci katsupi ka malen ma manyan ma ɗe ka̱ ta̱ ushani a zuba. Nala dem akaya a le a yankai ntsumate. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Shegai ter ɗe eɗa̱ aza a utsa̱ri, kpaci i wusha ɗe upana u kayanyan u ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ter ɗe, eɗa̱ aza ɗa iꞌa̱ri n ucuwi gogo‑na, kpaci ya tuwa̱ ta̱ i yain kambulu. Ter ɗe, eɗa̱ aza ɗa ya dosuso gogo‑na, kpaci ya namgba ta̱ katsuma̱, kpam i sa̱i. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ter ɗe, eɗa̱ aza ɗa ama a ka cikpala̱sa, kpaci nala dem akaya a le a cikpala̱sai ntsumate n kaɓan.” ");
INSERT INTO kdlNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yesu doki u danai, “Shegai n tonuko ɗa̱, eɗa̱ aza ɗa ya pana̱ka mu, i cigi atokulalu a ɗe, i yanka aza ɗa a ꞌyuwan ɗa̱ ukuna u shinga. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","I zuwuka aza ɗa a ka wishisa ɗa̱ una̱ u shinga. Aza ɗa a ka kovo ɗa̱ kpam i yanka le kavasu. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Uza ɗa u ɓasa vu a kagbaguzu ka te, kpatala̱ka yi ka ire ki. Uza ɗa u wusa vu kunya, kotsu vu ɓishinka yi matogo ma vunu wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Gba̱ uza ɗa baci u folo vu ili, vu na̱ka̱ yi. Uza ɗa baci kpam u wusa vu ucanga, kotsu vu boli iꞌya wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Yankai ama tyoku ɗa ya ciga a yanka ɗa̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Aza ɗa a ka ciga ɗa̱ alya baci ya ciga koshi, katsupi ka malen ma manyan ka eni ka ya tsa̱ra̱? Ko aza a unyushi u cingi dem a ka ciga ta̱ aza ɗa a ka ciga le. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Aza ɗa baci a ka yansa̱ka ɗa̱ ukuna u shinga a ɗa baci ya yanka ukuna u shinga koshi, katsupi ka malen ma manyan ka eni ka iꞌa̱ri n ka? Ko aza a unyushi u cingi dem nala a ka yansa. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kpam aza ɗa baci i wenei a ka tuwa̱ a tsupa ɗa̱ a ɗa baci ya na̱ka̱ akopi, katsupi ka malen ma manyan ka eni ka iꞌa̱ri n ka? Ko aza a unyushi u cingi dem, a tsu na̱ka̱ ta̱ aza a unyushi u cingi akopi, tsa̱ra̱ a tsupa le dere. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Shegai i cigi atokulalu a ɗe, i yanka le ukuna u shinga. Na̱ka̱i akopi, kotsu i zuwa aꞌeshi a tsupa ɗa̱ wa. Katsupi ka malen ma manyan ma ɗe kpam ka yan ta̱ ushani. Ya woko ta̱ kpam mmuku n Kashila̱ ka Zuba, kpaci eyi uza u ukuna u shinga u ɗa a asu u aza ɗa bawu a tsu cikpa n aza a cingi. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","I woko aza a asuvayali, tyoku ɗa Tata u ɗe wa̱ri uza u asuvayali.” ");
INSERT INTO kdlNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yesu doki u danai, “Kotsu i taɗanku uza unyushi wa, adama a ɗa a ka taɗanku ɗa̱ dem. I kiɗa̱ga uza ugana wa, adama a ɗa a ka kiɗa̱ga ɗa̱ dem. I cimbusa̱ unyushi u ɗa a yanka ɗa̱, kotsu a cimbusuka̱ ɗa̱ dem. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Na̱ka̱i, kotsu a na̱ka̱ ɗa̱ dem: kakundatsu ka shinga ka a shaɗangi, a sovonoi, a colukpoi hal ka wotsongusu. Aku a tsunku ɗa̱ a matogo. Kakundatsu ka i kundunki ka a ka kundunku ɗa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","U yanka le agisani a roku u danai, “Karumba̱ ka fuɗa ka rono utoku u ne karumba̱? Ama a re a le gba̱ she a rukpa̱ a kaɗa̱ka̱ wa? ");
INSERT INTO kdlNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Karotsongishi ka tsu la kawenishiki ka ne wa. Shegai uza ɗa baci a wenishikei mai, she u woko tyoku u kawenishiki ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ndya i zuwai va wundya macuku ma kenukulu ma ma̱ri a keshi ka utoku u vunu, aku vu kpa̱ɗa̱i ukirana n kagbukulu ka ka̱ri a keshi ka vunu? ");
INSERT INTO kdlNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Niɗa va fuɗa vu tonuko utoku vunu, ‘Utoku u va̱, a̱sa̱ka̱ n takpa vu macuku ma ma̱ri a keshi ka vunu,’ avu tani vu wene kagbukulu ka ka̱ri a keshi ka vunu wa? Avu uza maci u kaɓan, gita̱ ve vu takpa kagbukulu ka ka̱ri a keshi ka vunu, aku vu wene mai tyoku ɗa va takpa macuku ma ma̱ri a keshi ka utoku u vunu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesu doki u danai, “Maɗanga ma shinga ma̱ la ma ma matsa ilimaci i cingi wa, maɗanga ma cingi ma̱ tani la ma ma matsa ilimaci i shinga wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kpaci maɗanga dem, a ilimaci i ne iꞌya a tsu reve ma. A tsu ta ilimaci i kapopi a kawana wa, ko kpam cinwi a kaworo wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Vuma u maci u tsu wutukpa̱ ta̱ ili iꞌya iꞌa̱ri i shinga a katakasuvu ka shinga ka ne. Vuma u cingi tani a asuvu a katakasuvu ka ne ka u tsu wutukpa̱ ili i cingi. Kpaci ili i ushani iꞌya iꞌa̱ri a katakasuvu ka vuma, iꞌya u tsu dansa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yesu doki u danai, “Adama a iyen a ɗa ya isa̱ mu ‘Asheku, Asheku,’ kpam ya yan tani ili iꞌya n tonuko ɗa̱ i yain wa? ");
INSERT INTO kdlNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Gba̱ uza ɗa baci u tuwa̱i ara va̱, wa pana̱ka mu, aku wa tono udani u va̱, ma wenike ɗa̱ ta̱ ucun u ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Wa̱ ta̱ tyoku u uza ɗa wa ma kuwa, u ga̱va̱i lyungu-lyungu, aku u zuwai cuku tsi a katali ka upeti. An aga̱ta̱ a wayai, mini ma aga̱ta̱ ma lapai ubana a kuwa ki. Shegai ma gba̱ɗa̱ ka wa, kpaci a ma ta̱ ka mai. ");
INSERT INTO kdlNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Shegai uza ɗa u panai kadyanshi ka va̱ u ꞌyuwain ka uyanka manyan, wa̱ ta̱ tyoku u uza ɗa u mai kuwa a kayala, bawu u zuwai cuku tsu maci. Aꞌayin a ɗa mini ma aga̱ta̱ ma lapai ka, kute‑kute aku ku rukpa̱i ku yuruwai yukuyuku.” ");
INSERT INTO kdlNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","An Yesu kotsoi udansa ukuna u ɗa wa ciga u dana a kapala ka ama ki, u uwai a Kafarnahum. ");
INSERT INTO kdlNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","A ilyuci yi, katigi ka aza a Roma ka roku ka pini, uza ɗa kagbashi ka ne ka̱ri a una̱ u ukpa̱, kpam wa ciga yi wa wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","An u panai ukuna u Yesu, u sukunku yi nkoshi n Yahuda n roku, wa folo yi u tuwa̱ u ta̱na̱sa̱ka̱ yi kagbashi ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Aꞌayin a ɗa a rawai ara ne, a folo yi cika, a da, “Vuma u na u rawa ta̱ vu yanka yi ili i na yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Kpaci wa ciga ta̱ ukuna u tsunu, hal u maka tsu kagata ka Kashila̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","An u panai nala, u lazai kaɓolo n ele. Shegai an a yain evu n kuwa ki, aku katigi ki ka suki aje a ne a ba a tonuko yi, “Asheku, dambula kaci ka vunu vu tuwa̱ a kuwa ku va̱ wa. Kpaci n rawa va uwa a kuwa ku va̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nala kpam n wenei n ra̱tsa n tuwa̱ a asu u ɗa va̱ri wa. Shegai dana ukuna koshi, kagbashi ka va̱ ka ta̱na̱ ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","N reve ta̱ nala kpaci mpa vuma ɗa wa̱ri a kere ka ucira ka, kpam ma̱ ta̱ n asoje a kere ka va̱. N tsu tonuko ta̱ uza u na, ‘Wala,’ aku tani u wala. N tonuko uza u niɗe, ‘Tuwa̱,’ aku tani u tuwa̱. N tonuko kagbashi ka va̱, ‘Yan naha,’ aku tani u yain.” ");
INSERT INTO kdlNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","An Yesu panai nala, u yain majiyan a kaci ka ne. Aku u yira̱la̱kpa̱i u kondoi kakuma̱ ka ama ka ka tono yi vi, aku u tonuko le, “Mayun n tonuko ɗa̱, ko a asuvu a Isaraꞌila n wene ucun u upityanangu u pige naha wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","An aza ɗa a suki vi a gonoi a kuwa, a cinai kagbashi ki ka ta̱na̱ ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","An a tsa̱ra̱i a ɓa̱ra̱kpa̱i kenu, u banai a ilyuci i roku iꞌya a ka isa̱ Nayim. Aku atoni a ne n kakuma̱ ka ama ka banai kaɓolo n eyi. ");
INSERT INTO kdlNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","An u yain evu n utsutsu u ilyuci vi, u wenei a cangai kalobo ka roku kakushe, aya tani utyoku u ne a asu u mma u ne. Mma u ne kpam mara̱na̱ ma. Ama a ilyuci yi ushani aꞌa̱ ta̱ kaɓolo n mara̱na̱ mi. ");
INSERT INTO kdlNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","An Asheku a wene yi, asuvayali a ka̱na̱ yi, u tonuko yi, “Sa̱ wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Aku u raɓai u sawai ili iꞌya a cankai kakushe ki, aku aza ɗa a cangai iꞌya vi a shamgbai a asu u te. Aku u danai, “Kalobo, n da vu ꞌya̱nga̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kakushe ki ka ꞌya̱nga̱i ka dusuki ka ka̱na̱i kadyanshi. Aku Yesu na̱ka̱ yi mma u ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Gba̱ le a panai uwonvo, aku a cikpalai Kashila̱ a ka dansa, “Matsumate ma pige ma wuta̱ ɗe a asuvu a tsunu. Kpam Kashila̱ ka tuwa̱ ɗe ka ɓa̱nga̱ ama a ne.” ");
INSERT INTO kdlNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ama a rongoi kadyanshi ka ili iꞌya Yesu yain na vi gba̱ uyamba u Yahuda n iyamba iꞌya i kyawain u ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Aꞌa̱ri pini, atoni a Yahaya a tonuko yi gba̱ ukuna u Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Aku Yahaya isa̱i atoni a ne ama a re, u suku le a asu u Asheku, a wece yi, “Aɗa uza ɗa wa tuwa̱ vi, ko tsu vana uza roku?” ");
INSERT INTO kdlNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","An ama yi a tuwa̱i ara Yesu, a tonuko yi, “Yahaya Kalyuɓugi ɗa u suku tsu ara vunu, u da, ‘Aɗa va tuwa̱ vi, ko tsu vana uza roku?’ ” ");
INSERT INTO kdlNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Aꞌayin a nala yi tani, Yesu ta̱na̱sa̱ ta̱ ama ushani aza a mɓa̱la̱ icun kau‑kau n aza a ityoni i cingi. Kpam arumba̱ ushani a wene ta̱ asu. ");
INSERT INTO kdlNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yesu wushunku le, “Walai i ba i tonuko Yahaya ili iꞌya i wenei, n iꞌya i panai. Arumba̱ a wene ta̱ asu, awunu a wala ta̱, nkutu n ta̱na̱ ta̱, agulani a pana ta̱, akushe a ꞌya̱nga̱ ta̱ n uma. A yanka ta̱ aza a unambi kuɓari ku Kadyanshi ka Shinga. ");
INSERT INTO kdlNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","I tonuko yi kpam, ‘Uza ɗa baci bawu u ta̱ɗa̱tsa̱i adama a va̱, uza u una̱ u shinga u ɗa.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","An atsumate a Yahaya yi a lazai, Yesu ka̱na̱i uyanka ama kadyanshi ka Yahaya, “An i banai a kakamba ki, ndya ya ciga i wene? Asomini a ɗa uwule u tsu purusa̱ a asu u ɗa baci dem u lapanai, ko iyen? ");
INSERT INTO kdlNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ko vuma ɗa u ukai aminya a ikebe, aya ya ciga i wene? Aꞌa. A aꞌeɓile a ngono a ɗa aza ɗa a ka ukusa aminya a shinga, n a pani kayanyan aꞌa̱ri, shegai a kakamba wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Matsumate ma ya bolo uwene? Eye, kpam u la ta̱ matsumate. ");
INSERT INTO kdlNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yahaya ɗa gai Tagara̱da u Kashila̱ wa dansa̱ka vi, an a danai, ‘Ma suku ta̱ katsumate ka va̱ a kapala ka vunu, uza ɗa wa lapuluka vu ure.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","N tonuko ɗa̱ gba̱ a asuvu a ama ɗa aka a matsai, uza wa̱ la u la yi wa. Shegai gba̱ n nala, uza u kenukulu gba̱ a asuvu a tsugono tsu Kashila̱ u la yi ta̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(An ama, hal gba̱m n awushi a utafa a ɗa aꞌa̱ri pini a panai nala, a wushuki an uyan u ukuna u Kashila̱ u ɗa ili i maci. An u wokoi a wushuki Yahaya lyuɓugusu le. ");
INSERT INTO kdlNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Shegai Afarishi n arevi a Mele a ꞌyuwain ili iꞌya Kashila̱ ka ciga le n iꞌya; an a ꞌyuwain u lyuɓugusu le.) ");
INSERT INTO kdlNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu danai, “N iyen iꞌya ma ra̱tsana̱ka ama a gogo‑na? Ndya wa̱ a rotsoi? ");
INSERT INTO kdlNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Icun yi mmuku n ɗa ma̱ri a kuden ndishi, n a ika̱mgba̱ni ɗa aꞌa̱ri. N a dani, ‘Tsu fula̱ka̱ ɗa̱ ta̱ ugbali u maza̱nga̱, shegai i ꞌyuwain kuje. Tsu shipai ushipa u ukpa̱, shegai i sa̱ wa.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Kpaci Yahaya Kalyuɓugi tuwa̱i u laɓa ulya ilikulya wa, u so tani mini ma cinwi wa, aku i danai, ‘Wa̱ ta̱ n ityoni i cingi.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","An mpa Maku ma Vuma† ma lya na̱ n soyi, aku i danai, ‘Kalyai ka n kasoi, kpam kaje ka aza a uwusha utafa n aza a unyushi u cingi ka.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Shegai ama a ka wene ta̱ tyoku ɗa ugboji u Kashila̱ wa̱ri mai a asu u aza ɗa a ka tono yi.” ");
INSERT INTO kdlNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Kafarishi ka roku uza u kala Simo, u libanai Yesu ulya ilikulya. Aku u banai a dusuki ulya u ilikulya vi. ");
INSERT INTO kdlNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Uka roku, uza u unyushi a ilyuci yi, u panai a da aya pini ɗe wa lya ilikulya a kuwa ku Kafarishi ki. Aku u tukoi majuju ma shinga ma a shaɗangi n manivi ma magula̱ni ma ikebe cika. ");
INSERT INTO kdlNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","U kuɗa̱ngi a aꞌene a Yesu wa sa̱, aku u rekpishei aꞌene yi n meshi, u yansa̱sai ma n kenji ka ne. U rongoi a uwoɓuso aꞌene yi, aku u tsunki a ɗa manivi mi. ");
INSERT INTO kdlNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pini nala, an Kafarishi ka ka libanai Yesu ulya u ilikulya vi u wenei nala, u danai a katakasuvu ka ne, “A da baci vuma u na matsumate ma, wa̱ri wa reve ta̱ ko ucun u uka u eni u ɗa wa sawusa yi vi; kpaci uza u unyushi u cingi u ɗa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu wushunku yi, “Simo, ma̱ ta̱ n ili iꞌya ma tonuko vu.” U wushuki, “Kawenishiki, tonuko mu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu danai, “Vuma roku u ɗa u kopuki ama roku ama a re ikebe, uza u te ikebe iꞌya uza wa yan manyan ma uwoto kamanga, uza u te tani amangarenkupa. ");
INSERT INTO kdlNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ama a re a le gba̱ a tsa̱ra̱ ikebe i utsupuka wa. Adama a nala u tonuko le a a̱sa̱nsa̱ n iꞌya. Asuvu a le ya wa laka uciga vuma vi?” ");
INSERT INTO kdlNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","U wushuki, “A uwene u va̱, uza ɗa kutan ku ne ku lai ushani.” Yesu danai, “Vu wushuku ta̱ mai.” ");
INSERT INTO kdlNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","U yira̱la̱kpa̱i a asu u uka vi, aku u tonukoi Simo, “Vu wene ili iꞌya uka u na vi wa yanka mu? An n uwai a kuwa ku vunu, vu ne mu mini ma ma ɓacangusu aꞌene a va̱ wa, shegai eyi ɓacangusu mu a ɗa ɗe n meshi ma ne. U yansa̱sai a ɗa kpam n kenji ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Vu ryabusa mu n uwambatsa wa, shegai uka u na an n uwai a kuwa ku vunu, u a̱sa̱ka̱ uwoɓuso aꞌene a va̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Vu tsunku kaci ka va̱ manivi wa, shegai eyi tani manivi ma magula̱ni ma u tsunki aꞌene a va̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Adama a nala, n tonuko vu, a cimbusuka̱ yi ɗe unyushi u cingi u ushani u ne, kpaci u wenike ta̱ uciga u pige. Uza ɗa baci a cimbusuka̱i kenu, uciga u kenu u ɗa u wenikei.” ");
INSERT INTO kdlNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Aku Yesu tonukoi uka vi, “A cimbusuka̱ vu ɗe unyushi u cingi u vunu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Aza ɗa aꞌa̱ri pini a asu u ulya ilikulya kaɓolo n eyi vi, a gita̱i udansa a atakasuvu a le, “Ucun u vuma u eni u ɗa naha, hal wa cimbusuka̱ uza unyushi u cingi?” ");
INSERT INTO kdlNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","U tonukoi uka vi, “Upityanangu u vunu, u wauwa vu ɗe. Wala ili i vunu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","A ɓa̱ra̱kpa̱ wa, Yesu kyawunsai ilyuci n une n u yanyi kuɓari. Wa yan kadyanshi ka tsugono tsu Kashila̱. Kupanamere† vi aꞌa̱ ta̱ kaɓolo n eyi, ");
INSERT INTO kdlNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","n aka a roku aza ɗa a pecei n ityoni i cingi na̱ mɓa̱la̱ n le kpam. Asuvu a le alya Meri, uza ɗa a ka isa̱ Magadaliya, uza ɗa a wutukpa̱i ityoni i cingi i shindere a asuvu a ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yuwana uka u Kuza (uza ɗa wa̱ri kaɓa̱ngi ka Hiridu), n Suzana dem a tono yi ta̱, kaɓolo pini n aka a roku ushani. Gba̱ aka a na yi a ɓa̱nga̱ le ta̱ n ili i kukere i le. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","An kakuma̱ ka ama ka ɓolongi, ama aꞌa̱ri u tuwusa̱ ara Yesu ilyuci ilyuci. Aku u tonuko le agisani, ");
INSERT INTO kdlNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Kacimbi ka ka banai uce. Aꞌayin a ɗa wa̱ri a wacangusu icun yi, aku i roku i rukpusa̱i a ure. A kpatsai iꞌya, nnu kpam n ka̱ɗa̱sa̱i. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","I roku kpam i rukpa̱i a atali. An i wuta̱i aku i ekpei, kpaci kuta̱nu ka̱ pini wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","I roku kpam i rukpa̱i a awana. An a gbonguroi kaɓolo, awana yi a sapusai iꞌya. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","I roku kpam i rukpa̱i a iyamba i shinga, i gbonguroi, i yain mmuku amangatawun‑amangatawun hal i lai tyoku ɗa a cei.” An u danai nala, aku u ꞌya̱nga̱sa̱i kala̱ga̱tsu, u danai, “Gba̱ uza ɗa wa̱ri n atsuvu a upana, u pana.” ");
INSERT INTO kdlNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Atoni a Yesu a wece yi kalen ka agisani ki. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Aku u danai, “Eɗa̱ a wushunku ɗa̱ ta̱ i reve ukuna u ɗa wa̱ri a asuvu a tsugono tsu Kashila̱. Shegai aza ɗa a buwai, she n agisani. Kpaci tyoku ɗa wa̱ri ukorongi, ‘A uwene a ka wene ta̱, shegai a ka reve ili iꞌya a wenei vi wa; a upana kpam a ka pana ta̱, shegai a ka reve ili iꞌya a panai vi wa.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Kalen ka agisani ki ka na: icun yi ukuna u tsugono tsu Kashila̱ u ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Icun iꞌya i rukpa̱i a ure, alya aza ɗa a panai ukuna u tsugono tsu Kashila̱ vi. Aku Kala̱pa̱nsi ka wusai u ɗa a atakasuvu a le, tsa̱ra̱ a pityanangu n Kashila̱ a tsa̱ra̱ iwauwi wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","I atali yi tani, alya aza ɗa a pana baci ukuna vi, aku a wushi u ɗa n ipeli, shegai aꞌa̱ n alu wa. A ɓa̱ra̱kpa̱ n uwushuku wa, an aꞌayin a ukondo a tuwa̱i, aku a lazai a rukpa̱i. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Iꞌya i rukpa̱i a asuvu a awana tani, alya aza ɗa a panai ukuna u tsugono tsu Kashila̱ vi. An a yain aꞌayin kenu, aku kadambula ka likimba, n utsa̱ri, n upana kayanyan ka likimba ka gbagbala le, hal a kpa̱ɗa̱i uyan ili i maci. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Iꞌya a cei a uyamba u shinga, alya ama a maci, aza ɗa a panai ukuna u tsugono tsu Kashila̱ vi. A ka̱na̱i u ɗa gbam-gbam a atakasuvu a le, a kawunki n u ɗa pini, a gbonguroi, a na̱ka̱i mmuku.” ");
INSERT INTO kdlNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesu doki u danai, “Uza wa̱ la wa sapa macikalu aku u kimba̱ ma n kabelu wa, ko kpam u zuwa ma a kere ka ivamkpatsu wa. Shegai u zuwa ma a kashamkpatsu ka ne, adama a aza ɗa a ka uwa a wene katyashi. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Iꞌya baci dem iꞌa̱ri usokongi, a ka kpa̱ɗa̱ iꞌya uwutukpa̱ wa. Ukuna wa̱ kpam la u ɗa wa kpa̱ɗa̱ u wuta̱ a kateshe wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kiranai n iꞌya ya pana. Uza ɗa wa̱ri n ili, aya a tsu doku. Uza ɗa bawu wa̱ri n ili, maku ma ili ma wa wundya wa̱ri n ma vi, a ka wusa yi ta̱ iꞌya.” ");
INSERT INTO kdlNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mma n aꞌangu Yesu a tuwa̱i a asu u ne, shegai a fuɗa a rawa a asu u ne wa, adama a kakuma̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Aku a tonuko yi, “Mma u vunu n aꞌangu a vunu alya ɗe kushani a uwotsu, a ka ciga a wene vu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","U wushunku le, “Aza ɗa a tsu pana kadyanshi ka Kashila̱ a kirana n ka, alya mma u va̱ n aꞌangu a va̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Kain ka te, Yesu uwai a kpatsu n atoni a ne. U tonuko le, “Tsu pasamgbanai upashi u niɗe.” Aku a uwai a kpatsu ki a lazai. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Aꞌa̱ri a asuvu a nwalu, aku alavu a pura̱ yi. Uwule n aɓali a ꞌya̱nga̱i a kushiva̱ ki. Kpatsu ku le ku gita̱i ushaɗangu n mini, hal ka shumbugu. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","A banai a ba a ꞌya̱nga̱sa̱ yi a danai, “Uzakuwa, uzakuwa, tsa shumbugu ɗe!” U ꞌya̱nga̱i, u ɓaranai uwule vi n aɓali yi. Aku a vaki, asu vi u wokoi shiriri. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Pini nala, u wece le, “Nte upityanangu u ɗe?” A panai uwonvo a yain majiyan, aku a dansai utyoku u le, “Ya kumbu na vi, hal u tsu ɓarana uwule n aɓali, hal a pana̱ka yi?” ");
INSERT INTO kdlNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Pini nala, Yesu n atoni a ne a rawai a uyamba u Garasa u ɗa wa̱ri a upashi u Kushiva̱ ku Galili. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","N uwuta̱ u Yesu a kpatsu ki, uza u ityoni i cingi u roku, uza u ilyuci vi, u tuwa̱i u gawunsai n eyi. U ɓa̱ra̱kpa̱ ta̱ u uka aminya wa kpam u tsu dusuku a kuwa wa, shegai a asu u asaun. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","An u wenei Yesu, u rukpa̱i a kapala ka ne, aku u ꞌya̱nga̱sa̱i kala̱ga̱tsu u danai, “Ndya i birika vu na̱ mpa, Yesu Maku ma Kashila̱ ka Zuba? Ma folo vu kotsu vu yan mu mavura wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Dana ɗa u danai nala, kpaci an a ka gawunsa vi, Yesu ɓarana ta̱ ityoni i cingi yi i wuta̱ a asuvu a vuma vi. I tsu varangusu yi ta̱ aꞌayin ushani. A tsu ka̱na̱ yi ta̱ a sira n ikani n irim, aku u kiɗa̱sa iꞌya. Ityoni i cingi yi i zuwa yi u laza she a mete. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu wece yi, “Ndya kala ka vunu?” U danai, “Katam,” kpaci ityoni i cingi iꞌa̱ ta̱ ushani a asuvu a ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Aku a rongo yi ufolo, kotsu u tonuko le a uwa a kaɗa̱ka̱ ka bawu ka̱ri n utyoku wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","A asu vi tani, ushiga u pige u mburusunu u ɗa pini wa lina a kaga̱la̱la̱ ka masasa. Aku a folo yi u a̱sa̱ka̱ le a uwa a asuvu a le, aku u a̱sa̱ka̱ le tani a uwa. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ityoni i cingi yi i wuta̱i a asu u vuma vi, a uwai a ushiga u mburusunu vi. Ushiga vi tani u gida̱la̱i n ilyaɗi she a kushiva̱, a kuwa̱i pini a mini mi. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","An aliniki a mburusunu a wenei ili iꞌya i gita̱i, a sumai a ba a dansai ukuna vi a ilyuci n une. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ama ushani a tuwa̱i a wene ukuna u ɗa u gita̱i. An a tuwa̱i a asu u Yesu, aku a cinai uza ɗa ityoni i cingi i wuta̱i ara ne vi ndishi a kapala ka ne. Uza vi u uka ta̱ aminya, kpam n ugboji u ne. Aku a panai uwonvo. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Aza ɗa a wenei ukuna vi, a tonuko le tyoku ɗa a ta̱na̱sa̱i uza u ityoni i cingi vi. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gba̱ aza a uɓongu u uyamba u Garasa a foloi Yesu u a̱sa̱nka̱ le a asu vi. Kpaci uwonvo u ka̱na̱ le ta̱ cika. An u uwai a kpatsu ki wa laza, ");
INSERT INTO kdlNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","uza ɗa ityoni i cingi i wuta̱ yi vi, u folo yi u a̱sa̱ka̱ yi u toni yi. Shegai u tonuko yi u wala, u danai, ");
INSERT INTO kdlNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Gono a kuwa, vu ba vu dana ukuna u pige u ɗa Kashila̱ ka yanka vu.” Aku u banai a asuvu a ilyuci u danai manyan ma pige ma Yesu yanka yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","An Yesu kpatalai u gonoi a upashi u kushiva̱ vi, ama ushani a ryabusa yi, kpaci aya aꞌa̱ri a uvana. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Aku vuma roku u rawai, uza u kala Jayiru, uzapige u kagata ka Kashila̱. U kuɗa̱ngi a kapala ka ne, u folo yi u bana a kuwa ku ne, ");
INSERT INTO kdlNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","adama a maku ma makere ma ne ma ma̱ri a una̱ u ukpa̱. Aya utyoku u ne a asu u asheku a ne, wa̱ ta̱ n ayen evu n kupa n a re. An Yesu wa̱ri a nwalu, shegai kakuma̱ ka ama ka̱ri yi a uma̱tsa̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Aku uka roku, uza ɗa u yain ayen kupa n a re n maɓa̱la̱ ma ula̱la̱ u mpasa. U wunai gba̱ iꞌya wa̱ri n iꞌya a asu u aguma̱. Shegai ko uza u fuɗa u ta̱na̱sa̱ yi wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","U raɓai a kucina̱ ku ne, u sawai kaletsu ka kunya ku ne. Kute‑kute, mpasa mi n a̱sa̱ka̱i ula̱la̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Aku Yesu danai, “Ya sawa mu?” An ama yi gba̱ a nanai, Bituru danai, “Uzakuwa, kakuma̱ ka ama ka ka yain ushani ka geɓishe vu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Shegai u danai, “A sawa mu ta̱. Kpaci n pana ta̱ ucira u wuta̱i a asuvu a va̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","An uka vi u wenei wa̱ri n tyoku ɗa wa kpawan wa, aku u raɓai evu, n u jeki ikyamba. U kuɗa̱ngi a kapala ka ne, u danai a kapala ka ama gba̱ ili iꞌya i zuwai u sawa yi, n tyoku ɗa kpam u ta̱na̱i kute‑kute. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu tonuko yi, “Maku ma va̱, upityanangu u vunu u ta̱na̱sa̱ vu ɗe, wala ili i vunu mai.” ");
INSERT INTO kdlNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Eyi pini a kadyanshi, aku uza roku u wuta̱i a kuwa ku uzapige u kagata ka Kashila̱ ki, u rawai u danai, “Makere mi ma kuwa̱ ɗe, kotsu vu damgbara̱sa kawenishiki ki kpam wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","An Yesu panai nala, u wushunki Jayiru vi, “Kotsu vu pana uwonvo wa. Avu gai pityanangu, wa ta̱na̱ ta̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","An u rawai a kuwa ki, u wushuku uza u uwa pini kaɓolo n eyi wa, she Bituru, n Yahaya, n Yakubu, n tata u maku mi na̱ mma u ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Shegai gba̱ aꞌa̱ri a kushen, hal n a lapi akamba adama a ukpa̱ u makere mi. Yesu danai, “A̱sa̱ka̱i kushen, kuwa̱ ɗa u kuwa̱i wa, alavu a ɗa yi.” ");
INSERT INTO kdlNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Aku a ka dosuso yi idyoshi i magori, an a revei u kuwa̱ ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","U ka̱na̱i kukere ku makere ki, u ꞌya̱nga̱sa̱i kala̱ga̱tsu, u danai, “Makere, ꞌya̱nga̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Uma u ne u gonoi, kute‑kute u ꞌya̱nga̱i. Aku u danai a ne yi ilikulya. ");
INSERT INTO kdlNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tata u ne na̱ mma u ne a yain majiyan. Shegai u ɓarana le, kotsu a tonuko uza ili iꞌya i gita̱i wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Kain ka te, Yesu isa̱i Kupanamere vi, aku u na̱ka̱ le gba̱ ucira u ɗa a ka fuɗa a wutukpa̱ ityoni i cingi, a ta̱na̱sa̱ kpam mɓa̱la̱ icun kau‑kau. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Aku u suku le a ba a yain kuɓari ku tsugono tsu Kashila̱, a ta̱na̱sa̱ kpam aza a mɓa̱la̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","U tonuko le kpam, “I bidya ili adama a nwalu n ɗe wa, ko kalangu, ko katsa̱n, ko ilikulya wa. Kpam i bidya ikebe ko ntogo n re wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kuwa ka baci dem i uwai, rongoi pini she aꞌayin a ɗa ya a̱sa̱ka̱ ilyuci yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ama yi a wusha ɗa̱ baci wa, aꞌayin a ɗa baci ya wuta̱ a ilyuci yi i ka̱pa̱tsa̱ kabuta̱ ka aꞌene a ɗe, kotsu u woko iryoci iꞌya i wuta̱i uwule u le.” ");
INSERT INTO kdlNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","A ꞌya̱nga̱i a uwai a ilyuci i pige n une n a yanyi kuɓari n a ta̱na̱si ama ko nte wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Aꞌayin a nala yi, Hiridu Antiba magono ma Galili u panai ukuna u ili iꞌya a ka yansa, u dambulai cika. Aza roku a danai Yahaya ɗa ꞌya̱nga̱i a ukpa̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Aza roku a danai Iliya ɗa gonoi. Aza roku a danai matsumate ma cau ma ma ꞌya̱nga̱i a ukpa̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hiridu danai, “N kiɗa ta̱ kaci ka Yahaya. Ya kumbu ma̱ri a upana ukuna u ne vi?” U zama yi uwene. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","An asuki yi a gonoi, a tonukoi Yesu gba̱ ili iꞌya a yain. Aku u bidya le a lazai ubana a ilyuci i roku iꞌya a ka isa̱ Besaida. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Shegai an kakuma̱ ka ama ki ka revei a asu u ɗa wa bana, a tono yi. U wusha le u yanka le kadyanshi ka tsugono tsu Kashila̱, u ta̱na̱sa̱i aza a mɓa̱la̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","An kaara ka ciga urukpa̱, aku Kupanamere vi a tuwa̱i ara ne a danai, “Tutsuku kakuma̱ ka ama ki a une n ashina a na, a zamuka kaci ka le ilikulya n asu u nvain, kpaci a asu u ɗa tsa̱ri vi uza wa̱ pini wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","U tonuko le, “Eɗa̱ na̱ka̱ le ili iꞌya a ka lya.” Aku a wushuki, “Ili iꞌya tsa̱ri n iꞌya i la iburodi i tawun n adan a re wa. Shegai tsa uwa baci a ilyuci tsu tsila̱ka le ilikulya.” ");
INSERT INTO kdlNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Kpaci ama evu n azu a tawun a ɗa aꞌa̱ri a asu vi aꞌali.) U tonukoi atoni a ne yi, “Tonuko le a dusukusu aɓolo aɓolo, kaɓolo dem evu n ama amangarenkupa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","A yain tani nala, a zuwai ama yi gba̱ a dusukusi. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Pini nala, u bidyai iburodi i tawun n adan a re yi, aku u gaɗigbai kaci ka ne a zuba, u cikpai Kashila̱. Pini nala, u jiba̱mgba̱na̱sa̱i iꞌya u na̱ka̱i atoni a ne a pecike kakuma̱ ka ama ki. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Gba̱ le a cuwusa̱i, aku a cira̱ngi abuwi a iburodi yi hal mbana kupa na̱ n re. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kain ka te, an Yesu wa yan kavasu utyoku u ne, atoni a ne aꞌa̱ri evu n eyi, aku u wece le, “Ya ama a ka dansa ma̱ri?” ");
INSERT INTO kdlNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","A wushuki, “Aza roku a danai avu Yahaya Kalyuɓugi ɗa, aza roku tani Iliya. Aza roku a danai matsumate ma cau ma ma ꞌya̱nga̱i a ukpa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","U wece le, “Eɗa̱ tani ya ya dansa ma̱ri?” Aku Bituru wushuki, “Avu Kawauwi ka, uza ɗa Kashila̱ ka suki.” ");
INSERT INTO kdlNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","U rono le atsuvu kotsu a tonuko uza ukuna u na vi wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Pini nala, Yesu lyai kapala n kadyanshi, “U ka̱na̱ ta̱ Maku ma Vuma ma pana ikyamba. Nkoshi n pige, n aɗara̱kpi a pige, n awenishiki a Mele a ꞌyuwan yi hal a wuna yi. Kain ka tatsu kpam u ꞌya̱nga̱ a ukpa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","U tonuko le gba̱, “Uza ɗa baci wa ciga u tono mu, u ka̱na̱ ta̱ u ꞌyuwan kaci ka ne, u canga mawandamgbani ma ne kain dem u tono mu. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Uza ɗa baci wa kirana n uma u ne, wa namba ta̱ u ɗa. Shegai uza ɗa baci u na̱ka̱i uma u ne adama a va̱, wa wauwa ta̱ u ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nte kalen ka vuma wa tsa̱ra̱ likimba gba̱, aku u namba uma u ne? ");
INSERT INTO kdlNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Gba̱ uza ɗa baci u panai uwono u va̱ n kadyanshi ka va̱, mpa Maku ma Vuma ma pana ta̱ uwono u ne, n gono baci n tsupige tsu va̱ n tsupige tsu Tata n tsu atsumate a eri a zuba.” ");
INSERT INTO kdlNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Aku u tonuko le, “Mayun n tonuko ɗa̱, aza roku a ɗa pini na vi kushani aza ɗa bawu a ka kuwa̱, she a wene tsugono tsu Kashila̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Evu n aꞌayin kulla̱ a wurai, an Yesu yain kadyanshi ka nala ki, u banai a masasa kaɓolo n Bituru n Yahaya n Yakubu, kotsu u yain kavasu. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Wa̱ri a uyan kavasu, aku upetiwaꞌeshi u ne u yansa̱kai. Aminya a ne a wa̱ra̱ma̱i pun a ka laɗa. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Pini nala, ama a re, Musa n Iliya a wenikei kaci ka le ara ne a ka dansa n eyi. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ama a re a na a wenikei kaci ka le n tsupige, aku a ka yan kadyanshi ka ukpa̱ u ne a Urishelima. Kpaci ili iꞌya i zuwai Kashila̱ ka suku yi iꞌya la vi. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Bituru n aza ɗa aꞌa̱ri kaɓolo n eyi, alavu a pura̱ le. An a rikpa̱na̱ka̱i a wenei tsupige tsu ne, n ama a re a ɗa aꞌa̱ri kaɓolo n eyi vi. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","An ama yi a ka laza a a̱sa̱ka̱ yi, aku Bituru tonuko yi, “Uzakuwa, u lobono ta̱ tsa̱ri pini na. A̱sa̱ka̱ tsu yain atani a kavasu a tatsu, ka te ka vunu, ka te ka Musa, ka te kpam ka Iliya.” U reve tani ili iꞌya wa tono wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tyoku ɗa wa̱ri a kadyanshi, kalishi ka kimba̱ le, aku uwonvo u ka̱na̱ le cika. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kala̱ga̱tsu ka wuta̱i pini a kalishi ki ka danai, “Maku ma va̱ ma n ɗanga̱sai ma na vi, pana̱ka ni.” ");
INSERT INTO kdlNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","An kala̱ga̱tsu ki ka kotsoi kadyanshi, aku a wenei Yesu utyoku u ne. Aꞌayin a ɗa a wenei ukuna u nala vi, a paɗa ta̱ bini, a tonuko uza ili iꞌya a wenei vi wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","An kain ka wansai, cina a cipa̱ ɗe a masasa mi, kakuma̱ ka ama ka cina yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Uza roku u isa̱ yi pini a kakuma̱ ki, u danai, “Kawenishiki, n folo vu, kondo maku ma va̱ n aꞌeshi a iyali, kpaci aya mu koshi. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ityoni i cingi i tsu kumba yi ta̱, aku u sala bawu kagita̱. I tsu zuwa ta̱ ikyamba i ne i rongo uje hal una̱ u ne u rongo kapufu. I tsu a̱sa̱ka̱ yi wa, she aꞌayin a ɗa i kpa̱ra̱sa̱ yi cika. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","N foloi atoni a vunu a wutukpa̱ iꞌya, shegai a kpa̱ɗa̱i.” ");
INSERT INTO kdlNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu wushuki, “Eɗa̱ ama a aꞌayin a na, aza a ukpa̱ɗa̱ u upityanangu n aryagbaji; hal ubana nwere ɗa ma rongo n a̱ɗa̱ na̱ n kawunki n a̱ɗa̱?” U tonukoi vuma vi, “Tuko maku mi na.” ");
INSERT INTO kdlNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","An a ka tuko maku mi, aku ityoni i cingi yi i gbashangu yi a iyamba cika, i zuwai ikyamba i ne ya je. Shegai Yesu ɓaranai ityoni i cingi yi, aku u ta̱na̱sa̱i maku mi. U gonuko yi a asu u tata u ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Gba̱ le a yain majiyan, an a wenei ucira u pige u Kashila̱. An ama aꞌa̱ri a uyan majiyan ma ili iꞌya Yesu wa yansa, u tonukoi atoni a ne, ");
INSERT INTO kdlNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Panai mai ili iꞌya ma ciga n tonuko ɗa̱: a ka neke ta̱ Maku ma Vuma a akere a ama a cingi.” ");
INSERT INTO kdlNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Shegai a reve kaci ka ukuna ki wa. Kpam a sokonku le u ɗa, tsa̱ra̱ a reve wa. Ele tani a panai uwonvo u ɗa a ka wece yi ukuna vi. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kananamgbani ka uwai a mere ma le a kaci ka uza ɗa wa woko uzapige a mere ma le. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Shegai an Yesu revei ili iꞌya a ka yawunsa, aku u bidyai maku ma kenu u zuwa yi a kaɓon ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","U tonuko le, “Gba̱ uza ɗa baci u wushai maku ma kenu ma na adama a kala ka va̱, mpa u wushai. Kpam uza ɗa baci dem u wusha mu, uza ɗa u suku mu aya u wushai. Kpaci uza u kenukulu a asuvu a ɗe gba̱, aya uzapige.” ");
INSERT INTO kdlNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yahaya danai, “Uzapige, tsu wene ta̱ uza roku wa wutukpusa̱ ityoni i cingi n kala ka vunu, a̱tsu tani tsu ɓishinka yi, kpaci wa̱ a asuvu a tsunu wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Shegai Yesu tonuko yi, “Ɓishinka ni wa. Gba̱ uza ɗa baci bawu wa yan tsilala n a̱ɗa̱, uza u ɗe u ɗa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","An aꞌayin a ɗa a ka canga Yesu ubana a zuba a yain evu, u zuwai a katakasuvu ka ne u bana a Urishelima. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","U suki atsumate a re a kapala ka ne, aza ɗa a lazai a ba a uwai a une u aza a Samariya, tsa̱ra̱ a foɓuso urawa u ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Shegai aza a Samariya a wushuku n eyi wa, an u wokoi a danai a Urishelima ɗa wa bana vi. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","An atoni a ne aza ɗa a ka isa̱ Yakubu n Yahaya a panai nala, aku a wece yi, “Asheku, va ciga tsu zuwa akina a zuba a tuwa̱ a lya le?” ");
INSERT INTO kdlNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Shegai u yira̱la̱kpa̱i u ɓarana le. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Aku a lyai kapala a banai a une u roku. ");
INSERT INTO kdlNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tyoku ɗa aꞌa̱ri a nwalu, aku vuma roku u tonukoi Yesu, “Ma tono vu ta̱ a asu u ɗa dem va bana.” ");
INSERT INTO kdlNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","U tonuko yi, “Iryanji iꞌa̱ ta̱ n aꞌele a le, nnu kpam ma̱ ta̱ n ikinda i le. Shegai mpa Maku ma Vuma ma̱ n asu u nvain wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","U tonukoi vuma roku, “Tono mu.” Vuma vi u tonuko yi, “Asheku, a̱sa̱ka̱ ve n ba n ciɗa̱ngu tata u va̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu tonuko yi, “A̱sa̱ka̱ akushe a ciɗa̱ngu atoku a le akushe. Avu wala vu ba vu yain kadyanshi ka tsugono tsu Kashila̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Uza roku kpam u tonuko yi, “Asheku, ma tono vu ta̱, shegai a̱sa̱ka̱ ve n ba n tonuko aza a kuwa a va̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu tonuko yi, “Uza ɗa baci dem u ka̱na̱i maberu ma anaka, aku u weɓelei kucina̱, u ra̱tsa u yain manyan a tsugono tsu Kashila̱ wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","An nala u wurai, Yesu ɗanga̱sai ama a amangatatsunkupa n ama a re u suku le ama a re ama a re. A lasa yi urawa a asu u ɗa dem wa ciga u bana. ");
INSERT INTO kdlNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","U tonuko le, “Manyan ma ukapa ma̱ ta̱ ushani, shegai ayain a manyan yi kenu ɗa aꞌa̱ri. Adama a nala, foloi Magono ma Zuba ma ukapa u suku ayain a manyan a kapuka yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Walai, n suku ɗa̱ ta̱ tyoku u mmuku ma̱ ncon a mere ma nleweni. ");
INSERT INTO kdlNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kotsu i bidya makpaka̱ta ma ikebe wa, ko katsa̱n, ko akpata a roku wa. Kpam kotsu i shamgba idyani i bululu n uza a ure wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Kuwa ka baci dem i uwai i gita̱ i dana, ‘Ndishi n shinga n rongo a kuwa ku na ki.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Uza u ndishi n shinga wa̱ baci pini a kuwa ki, wa wusha ta̱ n ɗa. Wa̱ tani baci pini wa, ma gono ta̱ ara ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","I dusuku pini a kuwa ki, i lyai i soi icun i ilikulya iꞌya baci dem a na̱ka̱ ɗa̱, kpaci kayain ka manyan ka gan ta̱ ka wushi katsupi ka ne. Kotsu i rongo a usavaɗa̱sa aꞌuwa wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ilyuci iꞌya baci dem i uwai a wusha ɗa̱, i lyai i soi iꞌya a na̱ka̱ ɗa̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","I ta̱na̱sa̱ aza a mɓa̱la̱ a ɗa aꞌa̱ri pini. I tonuko le, ‘Tsugono tsu Kashila̱ tsa̱ ta̱ evu n a̱ɗa̱.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Shegai ilyuci iꞌya baci dem i uwai iꞌya bawu a wusha ɗa̱, i kyawan a ure dem n i dansi, ");
INSERT INTO kdlNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ko kabuta̱ ka ilyuci i ɗe ka ka paɗarai a aꞌene a tsunu, tsu ka̱pa̱tsa̱ka̱ ɗa̱ ka ɗe. Shegai gba̱ n nala, i reve tsugono tsu Kashila̱ tsu yan ɗe evu.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","N tonuko ɗa̱, kain ka nala ki, ilyuci i cingi i Sodom gba̱m ya yan ta̱ shana n ilyuci i nala yi.” ");
INSERT INTO kdlNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yesu doki u danai, “Ter ɗe aza a Korasinu, ter ɗe aza a Besaida. Aꞌa̱ri a da baci ukunosavu u ɗa a yain a asuvu a ɗe u ɗa a yain a Taya n Sida, an aꞌa̱ri a kpatala ɗe caupa. A rongo ta̱ n akashi uꞌuki n a polusi kakomo, adama a katsuma̱ ka lima̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Shegai kain ka afada, Taya n Sida a ka laka ta̱ utsa̱ra̱ ajebigi kapala n a̱ɗa̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","A̱ɗa̱ kpam aza a Kafarnahum ꞌya̱nga̱sa̱ ɗa a ka ꞌya̱nga̱sa̱ ɗa̱ hal ubana a zuba? Nala wa, shegai a gonuko ɗa̱ hal ubana a asu u ukpa̱ u ama a cingi. ");
INSERT INTO kdlNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Uza ɗa pana̱ka ɗa̱, mpa u pana̱kai. Uza ɗa kpam u ꞌyuwan ɗa̱, mpa u ꞌyuwain. Uza ɗa u ꞌyuwan mu, mpa u ꞌyuwain wa. Uza ɗa u suku mu, aya u ꞌyuwain.” Pini nala, aku a lazai. ");
INSERT INTO kdlNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Aku ama amangatatsunkupa n ama a re vi a gonoi n ipeli, a danai, “Asheku, hal ityoni i cingi dem i pana̱ka tsu, adama a kala ka vunu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","U tonuko le, “N wene ta̱ Kanangasi ka wuta̱i a zuba ka rukpa̱i tyoku u ulaɗa. ");
INSERT INTO kdlNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","U ɗa na n na̱ka̱ ɗa̱ ucira u udeshe aꞌali n adaɓu, kpam i lyai ucira u utokulalu vi. Ili iꞌa̱ la iꞌya ya ne ɗa̱ usa̱n wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Gba̱ n nala, kotsu i yain ipeli an ityoni i cingi i pana̱ka ɗa̱ wa, shegai i yain ipeli an a korongi aꞌala a ɗe a zuba.” ");
INSERT INTO kdlNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Aꞌayin a nala yi, Yesu yan ta̱ ipeli cika n Kulu Keri, u danai, “N cikpa vu ta̱, Tata Magono ma Zuba n likimba, kpaci vu sokongu ta̱ ukuna u na vi a asu u arevi n aza ɗa a rotsongusi. Vu toɗugboi u ɗa a asu u aza ɗa bawu a revei ili. Kpaci nala u yan vu, vu yain ili i shinga. ");
INSERT INTO kdlNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Gba̱ ili, Tata u va̱ na̱ka̱ mu iꞌya ɗe. Uza wa̱ tani la u revei Maku mi wa, she Tata vi. Uza wa̱ kpam la u revei Tata vi wa, she Maku mi, she kpam aza ɗa Maku mi ma cigai u wenike.” ");
INSERT INTO kdlNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Aku u kpatalai u weɓelei atoni a ne u tonuko le usokongi, “Aza a una̱ u shinga a ɗa aꞌeshi a ɗa a wenei ili i shinga iꞌya i wenei. ");
INSERT INTO kdlNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","N tonuko ɗa̱, ntsumate na̱ ngono ushani aza ɗa a cigai a wene ili iꞌya i wenei, shegai a wene wa. A pana kpam ili iꞌya i panai, shegai a pana wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Aku uza u te a asuvu a arevi a Mele u ꞌya̱nga̱i kushani wa ciga u kondo Yesu, u danai, “Kawenishiki, ndya ma yan kotsu n tsa̱ra̱ uma u ɗa bawu wa̱ri n utyoku?” ");
INSERT INTO kdlNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu tonuko yi, “Ndya iꞌa̱ri a asuvu a Mele? Niɗa vu tsu yan iꞌya Ka̱neshi?” ");
INSERT INTO kdlNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Aku u danai, “Vu cigi Magono ma Zuba Kashila̱ ka vunu n katakasuvu ka vunu, n uma u vunu gba̱. Vu cigi yi n ucira u vunu n kakiri ka vunu gba̱. Vu cigi kpam uza u karen u vunu tyoku ɗa va ciga kaci ka vunu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu tonuko yi, “Vu wushuku ta̱ mai. Yansa nala, va tsa̱ra̱ ta̱ uma.” ");
INSERT INTO kdlNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Shegai vuma vi an wa ciga u gonuko kaci ka ne dere, u wecei Yesu, “Ya uza u karen u va̱?” ");
INSERT INTO kdlNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu wushunku yi n agisani, “Vuma roku u ɗa u ꞌya̱nga̱i a Urishelima wa bana a Jeriko. Aku aza a maga̱la̱ka̱ a ka̱ngu yi, a monduso yi aminya, a lapa yi cika. Aku a lazai a a̱sa̱ka̱ yi a una̱ u ukpa̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Pini nala, kaɗara̱kpi ka roku ka tono pini a ure u nala vi. An u wene yi, aku u katsai a ikengi u lazai ili i ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nala kpam uza u Levi u roku, an u rawai pini a asu vi u wene yi, eyi dem u katsai ikengi u lazai u a̱sa̱ka̱ yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Aꞌa̱ri pini uza u Samariya u roku u wuta̱i nwalu u rawai pini a asu u ɗa wa̱ri vi, an u wene yi, aku asuvayali a ka̱na̱ yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","U banai pini a asu u vuma vi, u sira̱sa yi a asu u ɗa u tsa̱ra̱sa̱i usa̱n vi, u tsungusu yi manivi n mini ma aguma̱. Aku u taɗangu yi a zuba u makparyagi ma ne, u banka yi a kuwa ku amoci, u kiranai n eyi. ");
INSERT INTO kdlNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","An kain ka wansai, u bidyai ikebe i azurufa i re, u na̱ka̱i uza u kuwa vi. U danai, ‘Vu kirana n eyi, gba̱ iꞌya baci vu wunai bamu n i na yi, n gono baci ma tsupa vu ta̱.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“A asuvu a ama a tatsu a na yi, ya vu wenei wa̱ri uza u karen u vuma ɗa aza a maga̱la̱ka̱ a lapai vi?” ");
INSERT INTO kdlNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Aku u danai, “Uza ɗa u yanka yi ili i shinga.” Yesu tonuko yi, “Bana dem vu yansa nala.” ");
INSERT INTO kdlNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","An Yesu n atoni a ne aꞌa̱ri a nwalu, aku a uwai a une u roku. Uka roku uza u kala Marta u cipuka̱ yi a kuwa ku ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Wa̱ ta̱ n utaku, uza u kala Meri uza ɗa u dusuki a kapala ka Asheku wa pana kadyanshi ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Shegai Marta afoɓi a pura̱ yi ugboji, aku u banai ara ne u danai, “Asheku, avu wene utaku u va̱ u a̱sa̱ka̱ mu ma yan manyan utyoku u va̱ wa? Tonuko yi u tuwa̱ u ɓa̱nga̱ mu wa̱wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Shegai Asheku a wushunku yi, “Marta, Marta, vu dambula ta̱, kpam va dambula a kaci ka ili ushani. ");
INSERT INTO kdlNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Shegai ili i te iꞌya a ka ciga, Meri ɗanga̱sa ta̱ ili i shinga. A ka wusa yi tani iꞌya wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kain ka te, Yesu wa yan kavasu a asu u roku. An u kotsoi, katoni ka ne ka te ka tonuko yi, “Asheku, wenishike tsu kavasu tyoku ɗa Yahaya wenishikei atoni a ne.” ");
INSERT INTO kdlNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","U tonuko le, “Ya yan baci kavasu, i dana, ‘Tata, a na̱ka̱ kala ka vunu tsupige, tsugono tsu vunu tsu tuwa̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ne tsu kain dem ilikulya. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Cimbusuka̱ tsu unyushi u cingi u tsunu, kpaci a̱tsu n kaci ka tsunu tsu tsu cimbusuka̱ ta̱ aza ɗa a nusuka tsu. Kpam kotsu vu banka tsu a asu u ukondo wa.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","U doki u tonuko le, “A dana uza u te ɗe wa̱ n kaje, aku u banai ara ne n kayin ka pige, u tonuko yi, ‘Kaje ka va̱, kopuku mu iburodi i tatsu. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kaje ka va̱ ka ka cipa̱i nwalu gogo‑na, kpam ma̱ n ili iꞌya ma na̱ka̱ yi u lyai wa.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Aku u wushuku eyi pini ɗe a asuvu, u dana, ‘Kotsu vu damgbara̱sa mu wa, n gbagirya ɗe utsutsu u kuwa vi. Mpa na̱ mmuku n va̱ tsu vaku ɗe, ma fuɗa ma ꞌya̱nga̱ ma na̱ka̱ vu ili wa.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","A̱sa̱ka̱ n tonuko ɗa̱, ko wa ꞌya̱nga̱ baci wa na̱ka̱ yi ili an wa̱ri kaje ka ne wa, wa ꞌya̱nga̱ ta̱ wa na̱ka̱ yi gba̱ ili iꞌya wa ciga, adama a uma̱tsa̱ u ɗa u ma̱tsa̱i. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Kpam n tonuko ɗa̱, rongoi ufolo, a ka ne ɗa̱ ta̱. Rongoi ubolo, ya tsa̱ra̱ ta̱. Kuɗusai utsutsu, a ka giduwunka̱ ɗa̱ ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Uza ɗa baci dem u foloi, a ka ne yi ta̱. Kpam uza ɗa baci dem u boloi, u tsu tsa̱ra̱ ta̱. A tsu giduwunka̱ ta̱ uza ɗa baci dem u kuɗai utsutsu. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Tata u eni u ɗa a asuvu a ɗe maku ma ne ma folo yi burodi aku u na̱ka̱ yi katali? Ko kpam u foli yi kadan, aku u bidya kali u na̱ka̱ yi? ");
INSERT INTO kdlNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ko kpam u foli yi kako, aku u bidya kudaɓu u na̱ka̱ yi? ");
INSERT INTO kdlNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Eɗa̱ ama a cingi i reve baci una̱ka̱ mmuku n ɗe ili i shinga, nala dem Tata u ɗe uza ɗa wa̱ri a zuba wa na̱ka̱ aza ɗa a folo yi Kulu Keri.” ");
INSERT INTO kdlNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Kain ka te, Yesu wa wutukpa̱ ityoni i cingi i tsubebe. An ityoni i cingi yi i wuta̱i, aku kabebe ki ka danai ukuna, ama kpam a yain majiyan. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Shegai ama roku a danai, “N ucira u Baꞌalzabu† magono ma ityoni i cingi u ɗa wa wutukpusa̱ ityoni i cingi.” ");
INSERT INTO kdlNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Kpam aza roku a ka konduso yi, aku a boloi u wenike le iryoci i roku i zuba. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yesu reve ta̱ ili iꞌya a ka yawunsa, aku u tonuko le, “Tsugono tsa baci dem tsu pecei kaci ka ne kure n tsu shila̱ka̱ni, tsugono tsu nala tsa wacuwa ta̱. Nala dem kuwa ka baci ku pecei kaci ka ne kure n ku shila̱ka̱ni, ka wacuwa ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kanangasi ka pece baci kaci ka ne kure n u shila̱ka̱ni, niɗa tsugono tsu ne tsa yan tsu shamgba? N dana ta̱ nala an i danai n ucira u Baꞌalzabu u ɗa ma wutukpusa̱ ityoni i cingi. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","N ucira u Baꞌalzabu u ɗa baci ma wutukpusa̱ ityoni i cingi, n ucira u eni u ɗa wa̱ kpam atoni a ɗe a ka wutukpusa̱ le? Adama a nala a ka woko ta̱ aza a afada a ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","N ucira u Kashila̱ u ɗa baci ma wutukpusa̱ ityoni i cingi, tsugono tsu Kashila̱ tsu tuwa̱ ta̱ la vi ara ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Uza u ucira u bidya baci iwunukatsu wa wundya kuwa ku ne, ko i te ya tsa̱ra̱ udukuyan u ne wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Shegai uza roku uza ɗa u la yi ucira u ꞌya̱nga̱sa̱ka̱ yi baci, hal u fuɗai u wusha yi iwunukatsu iꞌya u pityanangi n iꞌya vi, aku u pecike udukuyan u ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Uza ɗa baci dem bawu wa̱ri kaɓolo na̱ mpa, tsilala tsa wa yan na̱ mpa. Uza ɗa baci bawu u ɓa̱nga̱ mu ucira̱ngusu, uwacinsa u ɗa yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ityoni i cingi i wuta̱ baci a asu u uza, i tsu tono ta̱ a asu u ɗa bawu mini ma̱ri ubolo u asu uwunvuga. I tsa̱ra̱ baci wa, aku i dana, ‘Ma gono ta̱ a asu u ɗa n wuta̱i.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","I gono baci i cinai kuwa ki uwujumi sarara kpam a kalai ka, ");
INSERT INTO kdlNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","aku i ba i bidya ityoni i cingi i shindere i roku iꞌya i la yi tsicingi, a uwa a dusuku pini. Vuma u nala makorishi ma ndishi n ne ma la ta̱ n kagita̱ unamgba.” ");
INSERT INTO kdlNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Tyoku ɗa wa̱ri a kadyanshi, aku uka roku a asuvu a kaɓolo ki u ꞌya̱nga̱sa̱i kala̱ga̱tsu u danai, “Uza ɗa u matsa vu kpam u comuko vu uza u una̱ u shinga ɗa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","U danai, “Una̱ u shinga u la ta̱ uwoko a asu u aza ɗa a panai kadyanshi ka Kashila̱ a yankai ka manyan.” ");
INSERT INTO kdlNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","An kakuma̱ ka̱ri a udoku n ka doki, aku Yesu danai, “Ama a aꞌayin a na ama a cingi a ɗa. A ka bolo ta̱ iryoci, shegai iryoci iꞌa̱ la a ka wenike wa, she iryoci i Inusa. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Wata, tyoku ɗa Inusa wokoi iryoci i aza a Niniba, nala dem Maku ma Vuma ma woko a aꞌayin a na yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Magono ma Sheba ma ma̱ri uka ma ꞌya̱nga̱ ta̱ kain ka afada ma sapunku unyushi u ama a aꞌayin a na yi. Kpaci a mɓa̱ri n likimba n ɗa u wuta̱i u pana̱kai ugboji u Solomo. Shegai uza ɗa u lai Solomo aya naha. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ama a Niniba a ka ꞌya̱nga̱ ta̱ kain ka afada n a sapunki unyushi u ama a aꞌayin a na yi, kpaci a kpatalai adama a kuɓari ku Inusa. Gogo‑na uza ɗa u lai Inusa aya naha. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Uza wa sapa macikalu u sokongu ma a asu u ɗa a tsu sokongu ili wa, ko u kimba̱ ma n kabelu wa, shegai u zuwa ma a zuba u kashamkpatsu ka ne, tsa̱ra̱ ama ɗa a ka uwa a wene katyashi. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Aꞌeshi a ɗa macikalu ma ikyamba i vunu. Aꞌeshi a vunu a lobono baci, ikyamba i vunu ya shaɗangu ta̱ n katyashi. Shegai a namgba baci, ikyamba i vunu ya shaɗangu ta̱ n karimbi. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Weɓele ko katyashi ka va̱ri n ka vi karimbi ka. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Adama a nala, ikyamba i vunu i shaɗangu baci n katyashi gba̱, bawu kaɓon ka ka ka̱ri n karimbi. Gba̱ ya woko ta̱ katyashi, tyoku ɗa macikalu ma tsu na̱ka̱ vu katyashi.” ");
INSERT INTO kdlNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","An Yesu kotsoi kadyanshi, aku Kafarishi ka roku ka libana yi ulya ilikulya. An u uwai, aku u dusuki a asu u ulya ilikulya. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","An Kafarishi ka wenei Yesu dusuki ulya ilikulya bawu u sawai akere, u yain majiyan. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Asheku kpam a tonuko yi, “Eɗa̱ Afarishi i tsu za̱ ta̱ kucina̱ ku mako n ku kapara, shegai a asuvu a ɗe i shaɗangu ta̱ n kurura n tsicingi. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Eɗa̱ atengeshi! Uza ɗa u yain kucina̱ ki, aya dem u yain asuvu yi wa? ");
INSERT INTO kdlNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Adama a nala, za̱yi asuvu yi a asu u uneshe aza a unambi ili iꞌya iꞌa̱ri n iꞌya, kotsu a wulukpe ɗa̱ gba̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ter ɗe Afarishi, kpaci i tsu na̱ka̱ ta̱ Kashila̱ u te a asuvu a kupa u icun i kashaun, n tsulu, n icun i ishuwan kau‑kau, shegai i kpa̱ɗa̱i uyanka ama ili iꞌya iꞌa̱ri dere, kpam i ciga Kashila̱ wa. U laka ta̱ iꞌa̱ri i yain u makorishi vi n u kagita̱ vi dem. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Ter ɗe Afarishi, kpaci i la ta̱ uciga u asu u ndishi u shinga a agata a Kashila̱. Kpam ya ciga ama a rongo ɗa̱ udana̱sa̱sa a asuvu a kuden. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Ter ɗe Afarishi, kpaci tyoku u asaun a ɗa a yain bawu uza wa wene a ɗa iꞌa̱ri, a ɗa ama a ka kpatsa bawu a revei.” ");
INSERT INTO kdlNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Karevi ka Mele ka roku ka wushunku yi, “Kawenishiki, ili iꞌya vu danai nala vi, inyashi iꞌya vu taka tsu iꞌya.” ");
INSERT INTO kdlNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu wushuki, “Ter ɗe arevi a Mele, kpaci i tsu taɗangusuku ta̱ ama ucanga u ara̱ji, kpam i tsu zuwa ko majubu i dana ya ɓa̱nga̱ le wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Ter ɗe, kpaci asaun a ntsumate n ɗa isheku i ɗe i wunusai a ɗa ya masa̱ka ikali. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","U woko la vi ɗe an i wushuki n manyan ma isheku i ɗe. Kpaci alya a wunusa le, eɗa̱ kpam ya masa ikali a asaun a le. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ili iꞌya i zuwai Kashila̱ a asuvu a ugboji u ne, u danai, ‘Ma sukunku le ta̱ ntsumate n asuki. A ka wuna ta̱ aza roku, aza roku tani a yan le mavura.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Adama a nala a ka wecike ta̱ mpasa ma ntsumate n ɗa a wotsongi a likimba. Ili iꞌya i bidyai a kagita̱ ka uyan likimba a kaci ka ama a aꞌayin a na. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ili iꞌya i ka̱na̱i a mpasa n Habila hal ubana a mpasa n Zakariya uza ɗa a wunai a mere ma asuɗara̱kpa n Asu u Uwulukpi. Mayun n tonuko ɗa̱, a ka kece ta̱ n ɗa a kaci ka ama a aꞌayin a na. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ter ɗe arevi a Mele, kpaci i bidyai makukpunki ma ureve. Eɗa̱ i uwa wa, kpam i ɓishinkai aza ɗa a ka ciga uꞌuwa a uwa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","An u wuta̱i pini a asu vi, awenishiki a Mele n Afarishi a gita̱ yi uraga, tsa̱ra̱ u dansa ili ushani. ");
INSERT INTO kdlNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Kpam a ka ciga a ka̱na̱ yi n unyushi a asuvu a kadyanshi ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Pini nala, an kakuma̱ ka ama ka ɓolomgbonoi ushani hal ka deshene. Yesu gita̱i u kpatalai a asu u atoni a ne, u ɓarana le u danai, “Kiranai n yisti u Afarishi, wa̱ ta̱ n kusokongi ku gbani. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ili iꞌa̱ la a kimba̱i iꞌya a ka kpa̱ɗa̱ ukukpa̱ wa, ili iꞌa̱ la iꞌya a sokonki iꞌya a ka kpa̱ɗa̱ utoɗugbo wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Adama a nala iꞌya baci i danai a karimbi a ka pana ta̱ iꞌya a katyashi. Kpam ili iꞌya baci i danai n kabini a kunu ku asuvu, a ka dansa ta̱ dem iꞌya a kateshe. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Eɗa̱ aje a va̱, n tonuko ɗa̱ ta̱, kotsu i pana uwonvo u ama ɗa a ka wuna ikyamba wa. A wuna baci aꞌa̱ n ili iꞌya a ka yan kpam wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Shegai ma wenike ɗa̱ ta̱ uza ɗa u gain i pana uwonvo. I pana uwonvo u uza ɗa u wuna baci, wa fuɗa wa vuta̱la̱ a asuvu a kaɗa̱ka̱ ka akina. Mayun n tonuko ɗa̱, i pana yi uwonvo. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ma wundya mberikele n tawun n ɗa a tsu denge anini a re vi? Ko n nala, Kashila̱ ka a̱sa̱nsa̱ ko n ma te wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Gba̱ kenji ka kaci ka ɗe, ka̱ ta̱ a ukece, adama a nala, panai uwonvo wa. Tsupige tsu ɗe ubana a asu u Kashila̱ tsu la ta̱ tsu mberikele ushani. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“N tonuko ɗa̱, gba̱ uza ɗa baci dem u tonukoi aza roku eyi uza u va̱ u ɗa a kapala ka ama, mpa Maku ma Vuma ma dana ta̱ dem a kapala ka atsumate a zuba a Kashila̱ eyi na katoni ka va̱ ka. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Shegai uza ɗa baci u ꞌyuwan mu a kapala ka ama, a ka ꞌyuwan yi ta̱ a kapala ka atsumate a zuba a Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ko n nala, uza u nusuka baci Maku ma Vuma, a ka cimbusuka̱ yi ta̱. Shegai uza ɗa baci dem u wishai Kulu Keri a ka cimbusuka̱ yi unyushi u ne wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Kpam a banka ɗa̱ baci a agata a Kashila̱, ko a asu u ngono, ko asu u ukiɗa u ugana, she i dambula a ili iꞌya ya dana kotsu i ɓa̱nga̱ kaci ka ɗe wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kpaci Kulu Keri ka wenishike ɗa̱ ta̱ ili iꞌya ya dana pini a asu vi.” ");
INSERT INTO kdlNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Vuma roku a asuvu a kakuma̱ ka ama ki u tonukoi Yesu, “Kawenishiki, zuwa utoku u va̱ u peci ucanga u ɗa tata u tsunu u kuwa̱i u a̱sa̱ka̱i vi na̱ mpa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu wushunku yi, “Uza va̱, ya na̱ka̱ mu ucira u ɗa ma woko ɗa̱ uza u afada?” ");
INSERT INTO kdlNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Aku u tonuko le, “Kiranai, i pecemgbene n kurura ku gbani, kpaci kakuma̱ ka ucanga ka uma wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","U yanka le agisani a na yi, u danai, “Kashina ka uza u utsa̱ri u roku ka matsai cika. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","U danai a katakasuvu ka ne, ‘Ndya ma yan? Mpa na ma̱ n asu u ɗa ma zuwa ucanga u kashina u va̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ili iꞌya ma yan iꞌya, she n ta̱sa̱ mpon n va̱ n mai n pige n pige, aku n tsungu pini ucanga u kashina u va̱ n utsa̱ri u va̱ pini gba̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Pini nala, n tonuko kaci ka va̱, “Uma u va̱, va̱ ta̱ n utsa̱ri ushani uzuwi u ɗa wa rawa vu ayen ushani. Wunvuga ili i vunu, vu lyai, vu soi, vu pana kayanyan.” ’ ");
INSERT INTO kdlNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Shegai Kashila̱ ka tonuko yi, ‘Katengeshi, n kayin ka na a ka ciga ta̱ uma u vunu. Ucanga u ɗa vu tsa̱ra̱i vi, u yai u ɗa wa woko?’ ");
INSERT INTO kdlNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Nala wa woko n uza ɗa u cira̱nki kaci ka ne udukuyan, shegai wa̱ n udukuyan a asu u Kashila̱ wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesu tonukoi atoni a ne, “N tonuko ɗa̱, yanyi kadambula ka uma u ɗe a ili iꞌya ya lya ko kpam ya uka a ikyamba wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kpaci uma u la ta̱ ilikulya, ikyamba kpam i la ta̱ aminya. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Weɓelei agawun: a tsu ce wa, a tsu kapa tani wa, aꞌa̱ kpam na̱ mpon n kuzuwate ku ucanga wa. Gba̱ n nala Kashila̱ ka tsu lyatangu le ta̱. Eɗa̱ i la ta̱ nnu cika tani. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","A asuvu a ɗe, ya wa fuɗa wa doku kaci ka ne uma ulapa u uwule u te adama a kadambula? ");
INSERT INTO kdlNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Cinda bawu ya fuɗa ya yan ili i kenu i na, ndya i banka ɗa̱ kadambula ka ili iꞌya i buwai? ");
INSERT INTO kdlNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Weɓelei tyoku ɗa apa̱lu a tsu gbonguro, a tsu yan manyan ko a jila̱ka̱ kaci ka le aminya wa. Ko Solomo n tsupige tsu ne gba̱ u uka aminya a ikali a ɗa a lobonoi tyoku u a le wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kashila̱ ka guɓa baci apa̱lu a mete a ɗa aꞌa̱ri n uma ara, nakpan a vuta̱la̱ le a akina. Aminya a ɗa Kashila̱ ka na̱ka̱ ɗa̱ a ka la a naha wa? Eɗa̱ aza ɗa upityanangu u ɗe u gusa̱i. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Dambulai a ili iꞌya ya lya ko ya so wa, kpam kotsu i a̱sa̱ka̱ atakasuvu a ɗe a ꞌya̱nga̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Uyawunsa u ama a likimba nte wa̱ri pini a icun i nala yi, shegai eɗa̱ Tata u reve ta̱ ya ciga iꞌya. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","I gita̱ i zami ve tsugono tsu Kashila̱, a ka doku ɗa̱ ta̱ ili i nala yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Eɗa̱ ushiga u kenu, panai uwonvo wa, kpaci Tata u ɗe wa pana ta̱ kayanyan ka wa na̱ka̱ ɗa̱ tsugono tsu ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Dengei utsa̱ri u ɗe, aku i ɓa̱nga̱ aza a unambi. I zamuka kaci ka ɗe atsa̱n a ikebe a ɗa bawu a ka kutsa; wata, utsa̱ri u ɗa bawu wa kotso a zuba, a asu u ɗa bawu aboki a ka raɓa evu. Ko karan ka̱ la ka ka nangasa u ɗa wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kpaci a asu u ɗa utsa̱ri u vunu wa̱ri, nte dem katakasuvu ka vunu ka yan pini ɗe.” ");
INSERT INTO kdlNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yesu doki u danai, “Wampuki aminya a ɗe adama a manyan, kpam i a̱sa̱ka̱ ncikalu n ɗe usapi. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","I rongo tyoku u ama ɗa a ka vana uzakuwa u le u gono a asu u abiki, kotsu a giduwunka̱ yi utsutsu n ukuɗa u utsutsu u ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Agbashi a ɗa baci uzakuwa u le u cinai n a vani yi a ka pana ta̱ kayanyan. Mayun n tonuko ɗa̱, wa sira ta̱ kunya a cuku u zuwa le a dusuku a asu u ulya u ilikulya, aku u pecike le ilikulya yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Agbashi a ɗa baci uzakuwa u le wa gono n kayin ka pige ko kpam ubana kpasani u cina le ufoɓusi, a ka pana ta̱ kayanyan. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ma ciga ta̱ i reve, a da baci uza u kuwa u revei aꞌayin a ɗa kaboki ka tuwa̱, wa̱ri wa a̱sa̱ka̱ kaboki ka uwa yi a kuwa wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Eɗa̱ dem i gan ta̱ i rongo n afoɓi a ɗa ya wusha Maku ma Vuma, kpaci wa tuwa̱ ta̱ aꞌayin a ɗa bawu i zuwai uma wa tuwa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Aku Bituru wece yi, “Asheku, a̱tsa va yanka agisani a na yi, ko gai ya dem ɗa?” ");
INSERT INTO kdlNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Asheku a wushunku yi, “Ya kagbashi ka maci kpam uza u ugboji? Uza ɗa uzakuwa u ne u na̱ka̱ yi u kirana n kuwa ku ne u na̱ka̱sa̱ le ilikulya. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Uzakuwa u ne u gono baci u cina yi n u yanyi nala, wa pana ta̱ kayanyan. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mayun n tonuko ɗa̱, uzakuwa vi wa zuwa yi ta̱ u kirana n utsa̱ri u ne gba̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Shegai kagbashi ki ka yawunsa baci a katakasuvu ka ne u danai, ‘Uzakuwa u va̱ ɗa na u gono gogo wa,’ aku u gita̱i ulapusa agbashi yi aka n aꞌali, n u lyayi n u soyi hal u gutukpa. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Uzakuwa u kagbashi u nala wa gono ta̱ a kain n ulapa u uwule u ɗa bawu a zuwai uma wa tuwa̱. Kpam wa yanyi ta̱ mavura cika, aku u varangu yi a asu u ama ɗa a ꞌyuwain uwushuku. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Kagbashi ka baci dem ka revei ili iꞌya uzakuwa u ne wa ciga, aku u ꞌyuwain iꞌya uyan, wa so ta̱ malapa cika. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Shegai uza ɗa baci bawu u revei, aku u yain ili i malapa, a ka lapa yi ta̱ kenu. Uza ɗa baci a na̱ka̱i ili ushani, ili ushani iꞌya a ka ciga ara ne. Uza ɗa kpam a na̱ka̱i uga̱na̱ u ili ushani, ili ushani iꞌya a ka ciga ara ne.” ");
INSERT INTO kdlNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesu doki u danai, “Tuwa̱ ɗa n tuwa̱i n tsungu akina a likimba, uciga u va̱ u ɗa, a dana naha dem a ka tasa ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Shegai ma̱ ta̱ n ulyuɓugu u ɗa a ka lyuɓugu mu, katakasuvu ka va̱ ka dusuku wa, she aꞌayin a ɗa a kotsoi. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ya wundya tuwa̱ ɗa n tuwa̱i n tuko ndishi n shinga a likimba? Nala wa, upecene u ɗa n tuko ɗa̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ubana a kapala, kuwa ku ama a tawun ka pece ta̱ kure: ama a tatsu a yain tsilala n ama a re, ama a re kpam a yain tsilala n ama a tatsu. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nala a ka pecene. Tata u yain tsilala n maku ma ne, maku kpam ma yain tsilala n tata u ne. Mma u yain tsilala n makere ma ne, makere kpam ma yain tsilala na̱ mma u ne. Kajene ka yain tsilala n anuku a ne, anuku kpam a yain tsilala n kajene ka ne.” ");
INSERT INTO kdlNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Aku Yesu tonukoi kakuma̱ ka ama ki, “I wene baci alishi a ꞌya̱nga̱i a kalivi, kute‑kute she i dana, ‘A ka ro ta̱,’ nala tani u tsu woko. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","I wene baci uwule u ꞌya̱nga̱i a ɗaka, she i dana, ‘Wa suɗugba ta̱,’ kpam nala. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Aza a maci a kaɓan, ya fuɗa ta̱ ya reve iryoci iꞌya iyamba n kubain ku zuba a ka wenike, shegai ndya i ɓishinka ɗa̱ i reve iryoci i aꞌayin a naha? ");
INSERT INTO kdlNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ndya i ɓishinka ɗa̱ ya bidiga kaci ka ɗe ili i shinga? ");
INSERT INTO kdlNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ya bana baci a asu u afada n uza ɗa u banka vu, dara̱ka vu sheshi n eyi a ure, kawa u banka vu baci a asu u uza u ukiɗa u ugana. Uza u ukiɗa u ugana vi wa na̱ka̱ngu vu ta̱ a kukere ku katigi, katigi ki tani ka zuwa vu ta̱ a kuwa ku aꞌali. ");
INSERT INTO kdlNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","N tonuko vu va wuta̱ wa, she vu tsupa gba̱ ili iꞌya a ka tono vu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Pini nala, aza ɗa aꞌa̱ri pini a asu vi a yankai Yesu alabari a aza a Galili aza ɗa Bilatu wunai a Kuwa ku Kashila̱, hal mpasa n le n ɓolomgbonoi na̱ n ɗa ma uɗara̱kpa u ɗa a yain. ");
INSERT INTO kdlNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu wushunku le, “Ya wundya aza a Galili a nala yi a la aza a Galili a ɗa a buwai vi unyushi u cingi ɗa, an a panai ikyamba i nala yi? ");
INSERT INTO kdlNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","N tonuko ɗa̱, nala wa. I a̱sa̱ka̱ baci tsicingi tsu ɗe wa, gba̱ ɗe dem nala ya kuwa̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ko kpam ya wundya ama kupa n kulla̱ aza ɗa a kuwa̱i an kasaga ka ugaɗi ka Sila̱wamu ka rukpa̱i ka vara le vi, a la aza a Urishelima unyushi u cingi ɗa? ");
INSERT INTO kdlNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","N tonuko ɗa̱, nala wa. I a̱sa̱ka̱ baci tsicingi tsu ɗe wa, ya kuwa̱ ta̱ gba̱ ɗe tyoku u le.” ");
INSERT INTO kdlNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","U tonuko le agisani a na yi, “Vuma roku u ɗa u wa̱ri n maɗanga ma kapopi a kashina ka ne, aku u tuwa̱i n u boli ilimaci i ne, shegai u tsa̱ra̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Aku u tonukoi uza ɗa wa guɓa kashina ki, ‘Ayen a tatsu a ɗa pa vi ma tuwa̱ na̱ n boli ilimaci i kapopi i na yi, n tsa̱ra̱ tani wa. Kapa ma, niɗa ma ka̱ngu asu gbani?’ ");
INSERT INTO kdlNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“U wushunku yi, ‘Uzakuwa, a̱sa̱ka̱ ve ma ma kyawan kayen ka lalu, n za̱ɗa̱gba̱ kami ki, n tsunku ma kayala ka tsishinda̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ma matsa baci ilimaci kayen ka ugono, aku a a̱sa̱ka̱ ma. Ma matsa tani baci wa, aku a kapa ma.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Kain ka te kain ka Ashibi, Yesu wa wenishike a kagata ka Kashila̱ ka roku. ");
INSERT INTO kdlNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Aku uka roku u ɗa wa̱ri n ityoni i cingi i maɓa̱la̱ ma ukeliki hal ayen kupa n kulla̱, uza ɗa u kelikei gba̱ wa fuɗa wa gaɗigba kpam wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","An Yesu wene yi, u isa̱ yi u tonuko yi, “Uka, a pecemgbene vu ɗe n maɓa̱la̱ ma vunu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","U taɗanku yi kukere, kute‑kute u gaɗigbai u cikpai Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Shegai uzapige u kagata ka Kashila̱ vi u panai upan, an Yesu ta̱na̱sa̱ yi n kain ka Ashibi. U tonukoi ama yi, “Aꞌayin a ɗa pini ushani hal a teli a ɗa a gain a yain manyan, tuwa̱i a ta̱na̱sa̱ ɗa̱, shegai bamu n kain ka Ashibi.” ");
INSERT INTO kdlNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Asheku a wushunku yi, “Eɗa̱ aza a maci a kaɓan, uza u kanaka ko makparyagi u tsu tatsukpa ma n kain ka Ashibi u ba u ne yi mini wa? ");
INSERT INTO kdlNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","U gan uka u naha, kumaci ku Ibirahi, uza ɗa Kanangasi ka sirai ara ayen kupa n kulla̱ a tatsukpa yi n kain ka Ashibi wa?” ");
INSERT INTO kdlNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","An u danai nala, atokulalu a ne a panai uwono, gba̱ kakuma̱ ka ama ka rongoi ipeli adama a ili i shinga iꞌya Yesu wa yansa. ");
INSERT INTO kdlNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu danai, “Niɗa tsugono tsu Kashila̱ tsa̱ri? Ndya ma ra̱tsana̱ka tsa n iꞌya? ");
INSERT INTO kdlNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Tyoku u ucun u musta ɗa tsa̱ri, u ɗa vuma roku u ba u cei a kashina ka ne. U gbonguroi u wokoi mawurete ma hal nnu n cai pini ikinda a nsaɓu n ne.” ");
INSERT INTO kdlNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","U doki u danai, “N iyen iꞌya ma ra̱tsana̱ka tsugono tsu Kashila̱? ");
INSERT INTO kdlNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Tyoku u yisti u ɗa tsa̱ri, u ɗa uka u roku u bidyai u vura̱i u ɗa a akundatsu a pige a tatsu a kira hal ku vura̱i n yisti vi gba̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu ka̱na̱i nwalu n u wenishike a ilyuci n une iꞌya u wurusai, hal wa rawa a Urishelima. ");
INSERT INTO kdlNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Uza roku u wece yi, “Asheku, ama a ɗa a ka tsa̱ra̱ iwauwi† aꞌa̱ gba̱m ushani?” U tonuko le, ");
INSERT INTO kdlNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Moɗonoi i uwa a utsutsu u kenu. Kpaci n tonuko ɗa̱, ama ushani a ka zama ta̱ a uwa, shegai a ka fuɗa wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Uza u kuwa u ꞌya̱nga̱ baci u gida̱ki utsutsu vi, i gita̱ ɗe la vi kushani a uwotsu n i kuɗusi utsutsu, n i dansi, ‘Uza u kuwa, giduwuka̱ tsu.’ “Eyi kpam u wushuku, ‘N reve a asu u ɗa i wuta̱i wa.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Aku i dana, ‘Tsu lya ta̱ tsu soi kpam n avu, hal vu wenishikei a ire i tsunu.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Eyi kpam u dana, ‘N tonuko ɗa̱ n reve a asu u ɗa i wuta̱i wa. Banka numu dan aza a unyushi u cingi.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Aꞌayin a nala yi ya wene ta̱ Ibirahi n Ishaku n Yakubu na̱ ntsumate a tsugono tsu Kashila̱, eɗa̱ kpam she a loko ɗa̱, nte ya sa̱ pini hal n i lumusi aꞌanga. ");
INSERT INTO kdlNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ama a ka tuwa̱ ta̱ a kasana n kalivi n gaɗi n ɗaka, a dusuku a asu u le a tsugono tsu Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Gogo‑na aza a kucina̱ a ka woko ta̱ aza a kapala, aza a kapala kpam a woko aza a kucina̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Pini nala, Afarishi a roku a tuwa̱i a tonuko yi, “ꞌYa̱nga̱ vu wuta̱ pini na vi, kpaci Hiridu Antiba magono wa ciga ta̱ u wuna vu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","U tonuko le, “Walai i ba i tonuko mashe ma mete ma nala mi, ‘Ara ma wutukpa̱ ta̱ ityoni i cingi, n ta̱na̱sa̱ kpam ama. Nakpan kpam nala. Kain ka tatsu, aku n kotso manyan ma va̱.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Gba̱ n nala ma lya ta̱ kapala na̱ nwalu n va̱, ara n nakpan n nakpan kuten. Kpaci u gan a wuna matsumate a asu u roku wa, she a Urishelima. ");
INSERT INTO kdlNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Eɗa̱ aza a Urishelima, aza a Urishelima, awuni a ntsumate, aza a uvara̱sa aza ɗa a suki ara ɗe. N tsu ciga ta̱ n ɓolongu ɗa̱ tyoku ɗa matoku ma tsu ɓolongu mmuku n ne a ashan a ne, aku i ꞌyuwain. ");
INSERT INTO kdlNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Wundyai, kuwa ku ɗe ka la a a̱sa̱nka̱ ɗa̱ uvarangi. N tonuko ɗa̱ ya doku ya wene mu wa, she kain ka ya tuwa̱ ya dana, ‘Kashila̱ ka zuwuka uza ɗa wa tuwa̱ a asuvu a kala ka Magono ma Zuba una̱ u shinga.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Kain ka te n Ashibi, Yesu uwai a kuwa ku uzapige u Afarishi u roku ulya ilikulya, ama kpam a zuwuka yi aꞌeshi. ");
INSERT INTO kdlNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","A kapala ka ne tani vuma roku u ɗa pini uza ɗa akere a ne n aꞌene a ne a shita̱sai. ");
INSERT INTO kdlNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu wecei Afarishi n arevi a Mele, “U gan a ta̱na̱sa̱ maɓa̱la̱ n kain ka Ashibi, ko u gan wa?” ");
INSERT INTO kdlNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Shegai a paɗai bini bini. Aku u ka̱na̱i vuma vi u ta̱na̱sa̱ yi, u tonuko yi u wala. ");
INSERT INTO kdlNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","U wece le, “A asuvu a ɗe, ya maku ma ne ko kanaka ka ne ka rukpa̱ a ilyukoi kain ka Ashibi, aku u kpa̱ɗa̱ ka uwutukpa̱ n maloko?” ");
INSERT INTO kdlNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","A fuɗa a wushuku keci ku ne wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","An u wenei tyoku ɗa aza ɗa a libanai vi a ɗanga̱sai asu u ndishi u shinga u shinga, u wenishike le uwenishike u na vi: ");
INSERT INTO kdlNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kain ka baci uza roku u libana vu abiki a iyolo, kotsu vu yain maloko vu dusuku a karatsu ka shinga wa, gaawan a libana ta̱ uza ɗa u la vu tsupige. ");
INSERT INTO kdlNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nala baci uza ɗa u libana ɗa̱ ama a re a ɗe yi, wa tuwa̱ ta̱ u tonuko vu, ‘Na̱ka̱ vuma u na a asu u ndishi u vunu.’ Aku vu woko n uwono, vu gono a karatsu ka kenu. ");
INSERT INTO kdlNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Shegai a libana vu baci abiki, dusuku a karatsu ka kenu, tsa̱ra̱ uza ɗa u libana vu vi, u tuwa̱ baci u tonuko vu, ‘Kaje ka va̱, ꞌya̱nga̱ vu gono a asu u shinga.’ She vu tsa̱ra̱ tsupige a asu u aꞌeshi a atoku a vunu amoci. ");
INSERT INTO kdlNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Gba̱ uza ɗa baci u ra̱ɗa̱gba̱i kaci ka ne, a ka vakunku yi ta̱. Uza ɗa kpam u vakunki kaci ka ne, a ka ra̱ɗa̱gba̱ yi ta̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesu tonukoi uza ɗa u libana yi vi, “Va libana baci uza abiki a ulya ilikulya n kaara ko kayin, kotsu vu libana aje a vunu, ko atoku a vunu, ko aza a kuwa a vunu, ko aza a karen a vunu aza a utsa̱ri wa. Kawa ele dem a ka libana vu ta̱, a tsupa vu. ");
INSERT INTO kdlNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Shegai va libana baci ama abiki a ulya ilikulya, vu libana aza ɗa bawu aꞌa̱ri n ili, n aza a mɓa̱la̱ ma ukeliki, n awunu, n arumba̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kpam a ka zuwuka vu ta̱ una̱ u shinga, kpaci a ka tsupa vu wa. Shegai va tsa̱ra̱ ta̱ katsupi ka malen ma manyan ma vunu kain ka aza a maci a ka ꞌya̱nga̱ a ukpa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","An uza u te a asuvu a aza ɗa a ka lya kaɓolo, u panai nala, u tonukoi Yesu, “Uza ɗa wa lya ilikulya i abiki a tsugono tsu Kashila̱ uza u una̱ u shinga u ɗa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu wushunku yi, “Vuma roku u ɗa u foɓusoi abiki a ulya ilikulya a pige, aku u libanai ama ushani. ");
INSERT INTO kdlNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","An aꞌayin a ulya ilikulya a yain, u suki kagbashi ka ne ka ba ka tonuko amoci a ɗa u libanai vi, ‘Tuwa̱i, kpaci a foɓuso ɗe ko ndya wa.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Shegai gba̱ le a gita̱i utukuso kadambula. Uza u kagita̱ u danai, ‘N tsila ta̱ kashina, kpam u ka̱na̱ ta̱ n ba n wene ka. Ma folo vu, vu yanka mu ahankuri.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Uza roku kpam u danai, ‘N tsila ta̱ anaka a kulima kupa, gogo‑na kpam ma ciga ta̱ n ba n kondo a ɗa. Ma folo vu, vu yanka mu ahankuri.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Uza roku kpam u danai, ‘Gogo‑na-na ɗa n yain iyolo, adama a nala ma fuɗa ma bana wa.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Kagbashi ki ka gonoi ka tonukoi uzakuwa vi. Katsuma̱ ka namgbai uzakuwa vi, aku u tonukoi kagbashi ki, ‘Wuta̱ gogo a ire na̱ mɓakuru ma ilyuci mi vu tuko aza a unambi, n aza a mɓa̱la̱ ma ukeliki, n arumba̱, n awunu.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Kagbashi ka danai, ‘N yan ɗe iꞌya vu danai n yain vi, shegai hal n gogo‑na asu u ɗa pini u buwai.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Aku u uzakuwa vi u tonukoi kagbashi ki, ‘Wala a kateshe ka ilyuci, vu bana a ire i pige n i kenu, vu zuwa ama ɗa aꞌa̱ri pini a tuwa̱ a uwa a kuwa ku va̱, tsa̱ra̱ ku shaɗangu. ");
INSERT INTO kdlNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","N tonuko ɗa̱, uza wa̱ la a asuvu a aza ɗa n libanai n kagita̱, wa peɗe ilikulya i abiki a va̱ wa.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Pini nala, kakuma̱ ka ama ka tonoi Yesu, aku u kpatalai u tonuko le, ");
INSERT INTO kdlNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Uza ɗa baci wa ciga u tuwa̱ ara va̱, u ka̱na̱ ta̱ she u ciga mu kapala n tata u ne, na̱ mma u ne, n uka u ne. U cigi mu kpam kapala na̱ mmuku n ne, n atoku a ne aka n aꞌali. U ka̱na̱ ta̱ dem u cigi mu kapala n uma u ne, kawa u ra̱tsa u woko katoni ka va̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Vu ra̱tsa vu woko katoni ka va̱ wa, vu canga baci mawandamgbani ma vunu vu tono mu wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“A asuvu a ɗe, ya wa gita̱ kuma ku pige bawu dusuki u kecei iꞌya wa wuna, u wene ko wa̱ n ikebe iꞌya wa kotso kuma ki? ");
INSERT INTO kdlNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kawa u gita̱ baci aku u kpa̱ɗa̱i ka usala̱kpa, gba̱ uza ɗa baci dem u wenei wa dosuso yi ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","A dana, ‘Vuma u na u gita̱i kuma, shegai u kpa̱ɗa̱i ka usala̱kpa.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ko kpam magono ma eni ma ma bana kuvon n magono ma roku, aku u kpa̱ɗa̱ u dusuku u yawunsa u wene ko eyi uza u asoje azu kupa wa fuɗa wa yan kuvon n magono uza u asoje azu kamanga? ");
INSERT INTO kdlNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","U wene baci ufuɗa wa, she u suku atsumate a ba a cina uza niɗe vi a folo yi ndishi n shinga, cina u buwai ve a mɓa̱ri. ");
INSERT INTO kdlNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Nala dem gba̱ ɗe, uza ɗa baci bawu u fuɗai u a̱sa̱ka̱i gba̱ ili iꞌya wa̱ri n iꞌya, u ra̱tsa u woko katoni ka va̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Mkpaɗi ili i shinga iꞌya, shegai n namgba baci bawu n yankpai kpam, n iyen iꞌya a ka yankpusa n ɗa? ");
INSERT INTO kdlNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","N ɗa ma̱ n kalen a iyamba wa, ma̱ tani n kalen a ili i tsishinda̱ wa. Wotsongu ɗa a ka wotsongu n ɗa. “Uza u atsuvu a upana, u pana.” ");
INSERT INTO kdlNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Aku awushi a utafa n aza a unyushi u cingi a ka raɓusa evu n Yesu tsa̱ra̱ a pana̱ka yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Adama a nala, Afarishi n awenishiki a Mele aꞌa̱ri uyan tsali a ka dansa, “Vuma u na wa wusha aza a unyushi u cingi, hal wa lya kaɓolo n ele.” ");
INSERT INTO kdlNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","U tonuko le agisani a na yi, ");
INSERT INTO kdlNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ya asuvu a ɗe wa yan na̱ ncon amangatawun, aku ma te ma karai kakamba ma puwa̱in bawu wa a̱sa̱ka̱ amanganishinkupa n kuci n ɗa n buwai vi a asu u kalina u bana ubolo ma te ma ma puwa̱in vi hal she u wene ma? ");
INSERT INTO kdlNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","U wene baci ma, wa canga ta̱ ma a kutanga n u peli. ");
INSERT INTO kdlNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","U rawa baci a kuwa, wa ɓolongu ta̱ aje a ne n aza a karen a ne. U tonuko le, ‘Ɓa̱nga̱ numu ipeli, n wene ɗe macon ma ma puwa̱n mu vi.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","N tonuko ɗa̱, nala dem a ka yan ipeli a zuba a kaci ka uza u unyushi u cingi u te ɗa baci u a̱sa̱ka̱i tsicingi tsu ne. Hal i lai i aza a maci a amanganishinkupa n kuci ɗa bawu aꞌa̱ri n unyushi u cingi. ");
INSERT INTO kdlNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesu lyai kapala n kadyanshi, “A dana uka roku wa̱ n ikebe i azurufa kupa. Aku u te u puwa̱n yi. Ndya wa yan? She u sapa macikalu, u wujuma̱ kuwa ki, u zami u ɗa sawu hal u ba u wene u ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","U wene baci u ɗa, she u ɓolongu aje a ne n aza a karen a ne u dana, ‘Ɓa̱nga̱ numu ipeli, n wene ɗe ukebe u ɗa u puwa̱n mu vi.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","N tonuko ɗa̱, ili i ipeli iꞌya a asu u atsumate a zuba a Kashila̱ a kaci ka uza u unyushi u ɗa baci dem u a̱sa̱ka̱i unyushi u cingi u ne.” ");
INSERT INTO kdlNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu doki u danai, “A yan ta̱ vuma roku uza u mmuku ma aꞌali n re. ");
INSERT INTO kdlNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Aku uza u kenu vi u tonukoi tata u ne, ‘Tata, na̱ka̱ mu ucanga u agadu u va̱.’ Aku tata u le, u pecike le ucanga u ne vi. ");
INSERT INTO kdlNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“An a yain aꞌayin kenu, aku uza u kenu vi u pura̱i utsa̱ri u ne vi gba̱ u ka̱na̱i ure ubana a uyamba u roku u mɓa̱ri. Pini nala, ucanga u ne u kotsoi a asu u ure u gbani, aku u rongoi ndishi n gbani. ");
INSERT INTO kdlNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","An ucanga u ne u kotsoi gba̱, aku kambulu ka uwai a uyamba vi, u uwai dem kambulu. ");
INSERT INTO kdlNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","U ba u ɓolomgbonoi kaci n uza roku uza u uyamba vi, eyi tani u zuwa yi u woko kaliniki ka mburusunu. ");
INSERT INTO kdlNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","U tsu ciga ta̱ u lyai ilikulya iꞌya mburusunu n tsu lyasa, shegai ko uza wa na̱ka̱ yi ili wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“U tuwa̱i u yawunsai, u danai, ‘Agbashi a tata u va̱ a ɗa ɗe aꞌa̱ ta̱ n ilikulya iꞌya i rawa le hal i buwai, mpa tani na ma̱ri a ukuwa̱ n kambulu. ");
INSERT INTO kdlNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","A̱sa̱ka̱ n ꞌya̱nga̱ n bana a asu u tata u va̱ n dana, “Tata, n nusuka ta̱ Kashila̱ kpam n nusuka vu ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","U gan gba̱m a doku a isa̱ mu maku ma vunu wa. Gonuko mu tyoku u uza u te a asuvu a agbashi a vunu.” ’ ");
INSERT INTO kdlNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Aku u ꞌya̱nga̱i u banai a asu u tata u ne. “Eyi ubuwi a mɓa̱ri, tata u ne wene yi, aku asuvayali a ka̱na̱ yi, u sumai u wambatsa yi wa̱ri yi a upapurusa. ");
INSERT INTO kdlNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Aku maku mi ma tonuko yi, ‘Tata, n yanka ta̱ Kashila̱ unyushi, kpam n nusuka vu ta̱. U gan gba̱m a doku a isa̱ mu maku ma vunu wa.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Shegai tata vi u tonukoi agbashi a ne, ‘Yanyi maloko i tuko yi matogo ma ma lakai tsulobo, i uka yi. I uka yi makawani n akpata. ");
INSERT INTO kdlNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Tukoi madyondyom ma pige ma nala mi i kiɗa ma, tsu takumai, tsu yain ipeli. ");
INSERT INTO kdlNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kpaci maku ma na ma̱ri ma kuwa̱ ta̱, shegai gogo‑na u gono ɗe n uma. Wa̱ri u puwa̱n ta̱, shegai gogo‑na a wene yi ɗe.’ Pini nala, a gita̱i uyan maza̱nga̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Aꞌayin a nala yi, maku ma pige ma ne ma bana ta̱ a kashina. Eyi n u goni, an u yain evu n kuwa, aku u panai a ka keme n a jeyi. ");
INSERT INTO kdlNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","U isa̱i kagbashi ka roku ka kuwa ki u wece yi ili iꞌya i tukoi ukuna u nala vi. ");
INSERT INTO kdlNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","U tonuko yi, ‘Vangu u vunu u ɗa u gonoi. Tata u ɗe kpam u kiɗai madyondyom ma pige ma nala mi adama a ɗa u tsa̱ra̱ yi bawu usa̱n u roku.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Aku uza u pige vi u yain upan, u ꞌyuwain uꞌuwa a kuwa ki. Tata u ne u wuta̱i u rongo yi uleshe. ");
INSERT INTO kdlNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","U wushunki tata u ne u danai, ‘Wundya ve ayen a ushani a ɗa n gbashika vu, n kpa̱ɗa̱ tani ugorimuko udani u vunu wa. Gba̱ n nala, kain ka̱ la ka vu na̱ka̱ mu maku ma malala ma ma yan maza̱nga̱ n aje a va̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Shegai an maku ma vunu ma tuwa̱i uza ɗa u puwunsa̱i utsa̱ri u vunu a asu u ashankala, aku vu kiɗa̱ga yi madyondyom ma pige ma nala mi.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Aku tata u ne u tonuko yi, ‘Maku ma va̱, kain dem va̱ ta̱ kaɓolo na̱ mpa, kpam iꞌya baci dem iꞌa̱ri i va̱, i vunu iꞌya dem. ");
INSERT INTO kdlNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Dere ɗa a yain maza̱nga̱ n ipeli adama a vangu u vunu ɗa wa̱ri u kuwa̱i, shegai gogo‑na u gonoi n uma. Wa̱ri u puwa̱in, a wene yi kpam.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu doku u tonukoi atoni a ne, “A yan ta̱ uza u utsa̱ri u roku uza ɗa wa̱ri n uza ɗa wa guɓuga yi utsa̱ri u ne. A tonukoi uza u utsa̱ri vi, uza ɗa wa guɓuga yi utsa̱ri vi wa nangasa yi ta̱ u ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Pini nala, u isa̱ yi u danai, ‘Ndya n panai na a kaci ka vunu? Na̱ka̱ mu tyoku ɗa va tono n utsa̱ri u va̱, kpaci va lya kapala n ukirana n utsa̱ri u va̱ wa.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Uza ɗa wa guɓa utsa̱ri vi u tonukoi kaci ka ne, ‘Uzakuwa u va̱ u ɗa na wa loko mu a asu u manyan ma va̱. Ndya ma yan? Ma̱ n ucira u ɗa ma cimba wa, kpam ma pana ta̱ uwono u ufolu. ");
INSERT INTO kdlNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","N reve ta̱ ili iꞌya ma yan gogo‑na kotsu n tsa̱ra̱ ama ɗa ka wusha mu a aꞌuwa a le, manyan ma va̱ ma kotso baci.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Adama a nala u isa̱i gba̱ ama ɗa uzakuwa u ne wa tono atan. Aku u wecei uza u kagita̱, ‘I yain iꞌya uzakuwa u va̱ wa tono vu?’ ");
INSERT INTO kdlNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“U wushuki, ‘Adele a pige a manivi a amangatawun.’ “U tonuko yi, ‘Tagara̱da u vunu u ɗa na, dusuku vu shaɗangu amangarenkupa.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“U wecei kpam uza roku, ‘Avu tani i yain iꞌya a ka tono vu?’ “U wushuki u da, ‘Akpakpa a ilya amangatawun.’ “Uza ɗa wa guɓa utsa̱ri vi u tonuko yi, ‘Tagara̱da u vunu u ɗa na korongu amanganishi.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Adama a nala uzakuwa u uza ɗa wa guɓa utsa̱ri vi, u cikpala yi adama a ugboji u ne. Kpaci ama a likimba a gawunsa baci n ama a likimba u le, a la ta̱ ama a katyashi ugboji cika.” ");
INSERT INTO kdlNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesu lyai kapala u danai, “Adama a nala n tonuko ɗa̱, yankai utsa̱ri u likimba u ɗe manyan i ɓa̱nga̱ aza roku n u ɗa tsa̱ra̱ i yain aje, pini nala, aꞌayin a ɗa baci utsa̱ri vi u kotsoi, a wushi ɗa̱ a aꞌuwa a ɗa bawu a ka kotso. ");
INSERT INTO kdlNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Uza ɗa baci wa̱ri n ukuna u maci a ukuna u kenu, wa yan ta̱ n ukuna u maci a ukuna u pige. Uza ɗa baci bawu wa̱ri n ukuna u maci a ukuna u kenu, wa yan n ukuna u maci a ukuna u pige wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","I yan baci ukuna u maci a asu u uɓa̱na̱ u icanga i likimba wa, niɗa a ka yan a na̱ka̱ ɗa̱ icanga i maci i zuba? ");
INSERT INTO kdlNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kpam i yan baci ukuna u maci n icanga i aza roku wa, ya wa na̱ka̱ ɗa̱ ili iꞌya iꞌa̱ri i ɗe? ");
INSERT INTO kdlNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Kagbashi ka̱ la ka gbashika aza a aꞌuwa a re wa. Ucun u kagbashi u nala wa kovo ta uza u te, aku u cigi uza u te. Ko tani u toni ukuna u uza u te, aku u goro u uza u te. Va fuɗa va gbashika Kashila̱ kaɓolo n utsa̱ri wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","An Afarishi a panai nala, ele tani a wokoi acigi a ikebe a ɗa, aku a cira̱kpa yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","U tonuko le, “Eɗa̱ i tsu gonuko ta̱ kaci ka ɗe ama a ɗa aꞌa̱ri dere a aꞌeshi a ama. Shegai Kashila̱ ka reve ta̱ atakasuvu a ɗe. Ili iꞌya ama a bidyai n tsupige cika, ili i icaɗi iꞌya a kapala ka Kashila̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Yesu doki u danai, “Mele ma Musa n itagara̱da i Ntsumate, iꞌya awenishiki a ɗe hal ubana a aꞌayin a Yahaya. Aꞌayin a Yahaya a ɗa a gita̱i uyan kuɓari ku tsugono tsu Kashila̱, kpam ya dem wa moɗono tsa̱ra̱ u uwa pini. ");
INSERT INTO kdlNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Gba̱ n nala, wa laka ta̱ shana zuba n iyamba a cimba̱, n u ɗa uɗyani u te u kenu u tagara̱da u Mele wa gusa̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Uza ɗa baci u a̱sa̱ka̱i uka u ne, u zuwai uza roku, tsishankala tsa wa yan n eyi. Uza ɗa kpam u zuwai uka u ɗa uza roku u a̱sa̱ka̱i, tsishankala tsa wa yan.” ");
INSERT INTO kdlNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesu doki u danai, “A yan ta̱ uza u utsa̱ri u roku, uza ɗa u tsu ukusa aminya a mini ma galura n a ɗa a ka laɗa a pun a shinga, aku u rongo a upana kayanyan ka ne kain dem. ");
INSERT INTO kdlNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","A utsutsu u kuwa u ne, kafoloni ka roku ka pini a zuwai uza u kala Liꞌazaru. Ikyamba i ne gba̱ aꞌutsu a ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","U tsu ciga ta̱ u lyai ilikulya iꞌya i tsu rukpusa̱ vuma vi wa lya baci ilikulya. Hal gba̱m nshe n tsu tuwusa̱ ta̱ na̱ n peɗishi yi aꞌutsu yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Kain ka te kafoloni ki ka kuwa̱i, aku atsumate a zuba a canga yi ubana a asu u Ibirahi. Uza u utsa̱ri vi dem u tuwa̱i u kuwa̱i, aku ciɗa̱ngu yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Eyi a asuvu a akina a tsukonu wa̱ri a upana ikyamba, u gaɗigbai kaci ka ne u wenei Ibirahi mɓa̱ri n Liꞌazaru a asu u ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","U isa̱ yi u danai, ‘Tata Ibirahi, pana asuvayali a va̱. Suku Liꞌazaru u uka kaci ka majubu ma ne a mini u tuwa̱ u ɗakanku mu a kaletsu ka va̱. Kpaci ikyamba iꞌya ma pana a asuvu a akina a na yi.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Shegai Ibirahi danai, ‘Maku ma va̱, ciɓa ndishi n vunu a likimba, vu soi kayanyan ka utsa̱ri u vunu. Liꞌazaru tani u panai ikyamba, shegai gogo‑na kayanyan ka a ka neshe yi. Avu tani va pana ikyamba. ");
INSERT INTO kdlNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Bamu n u nala, a mere ma tsunu n a̱ɗa̱, kaɗa̱ka̱ ka pini ka pige ka ka ɓishinka aza ɗa aꞌa̱ri a asu u ɗe utuwa̱ ara tsunu. Nala kpam aza ɗa aꞌa̱ri ara tsunu a ka pasamgbana utuwa̱ ara ɗe wa.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Uza u utsa̱ri vi u danai, ‘Tata, ma folo vu, vu suku yi a kuwa ku tata u va̱, ");
INSERT INTO kdlNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kpaci ma̱ ta̱ n atoku aꞌali ama a tawun. U ba u rono le atsuvu, kotsu ele dem a tuwa̱ a asu u upana u ikyamba u na vi wa.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Shegai Ibirahi tonuko yi, ‘Aꞌa̱ ta̱ n itagara̱da i Musa na̱ i Ntsumate, a̱sa̱ka̱ a pana̱ka le.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Aku u danai, ‘Nala wa, tata Ibirahi, uza roku a asuvu a akushe u bana le baci, a ka kpatala ta̱ a a̱sa̱ka̱ tsicingi tsu le.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ibirahi tonuko yi, ‘A pana̱ka baci itagara̱da i Musa na̱ i Ntsumate wa, ko uza roku u ꞌya̱nga̱ baci a asuvu a akushe wa fuɗa wa zuwa le a a̱sa̱ka̱ tsicingi tsu le wa.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu tonukoi atoni a ne, “U ka̱na̱ ta̱ ili iꞌya ya zuwa uza u rukpa̱ i tuwa̱, shegai ter n u uza ɗa wa zuwa i tuwa̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Wa laka ta̱ shana a sira̱ka yi katali ka kira a udyoku u ne a varangu yi a kushiva̱, n u ɗa wa zuwa uza u te a asuvu a mmuku n kenu n na u nusa. ");
INSERT INTO kdlNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Adama a nala, kiranai n kaci ka ɗe. “Utoku u vunu u nusuka vu baci, ɓarana yi. U folo vu baci, vu cimbusuka̱ yi unyushi u ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","U nusuka vu baci kushindere a kain ka te, aku kpam u tuwa̱i ara vunu kushindere u foloi, vu cimbusuka̱ yi.” ");
INSERT INTO kdlNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Atoni a ne a tonuko yi, “Doku upityanangu u tsunu!” ");
INSERT INTO kdlNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","U tonuko le, “A da baci iꞌa̱ri n upityanangu kenukulu tyoku u ucun u musta, she i tonuko makuli ma na mi, ‘Muɗa̱ vu ba vu shigba̱ kaci ka vunu a kushiva̱.’ She tani u toni udani u ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“A dana a asuvu a ɗe, uza roku wa̱ n kagbashi ka ka limusuka yi ko kpam wa lina̱sa̱ka yi ncon. U wuta̱ baci a kakamba u rawai, uzakuwa wa laza wa tonuko yi, ‘Tuwa̱ vu dusuku vu lyai ilikulya.’? Wa yan nala wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Shegai wa tonuko ta̱ kagbashi ki, ‘Foɓusuko mu ilikulya, aku vu foɓuso kaci ka vunu tsa̱ra̱ vu tuko mu ilikulya. N kotso baci ulya n uso, aku avu lyai.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Wa cikpa kagbashi ki an u yain ili iꞌya u tonuko yi u yain? Ko kenu. ");
INSERT INTO kdlNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Eɗa̱ dem nala, i yan baci iꞌya a da i yain, she i dana, ‘A̱tsu agbashi a ɗa gai gbani, kpaci iꞌya i gain tsu yain iꞌya tsu yain koshi.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Kain ka te, Yesu wa bana a Urishelima, wa wala a karen ka Samariya n Galili. ");
INSERT INTO kdlNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tyoku ɗa wa uwa a une u roku, nkutu n roku ama kupa a shamgbai a mɓa̱ri, ");
INSERT INTO kdlNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","aku ꞌya̱nga̱sa̱i ala̱ga̱tsu a le tsa̱ra̱ a shamkpa yi, a danai, “Yesu Asheku, pana asuvayali a tsunu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","An u wene le, u tonuko le, “Walai i ba i wenike kaci ka ɗe a asu u aɗara̱kpi.” Tyoku ɗa aꞌa̱ri a nwalu, aku a ta̱na̱i. ");
INSERT INTO kdlNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","An uza u te a asuvu a le u wenei a ta̱na̱sa̱ yi, aku u kpatalai u gonoi n u cikpali Kashila̱ n ucira. ");
INSERT INTO kdlNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","U kuɗa̱ngi a kapala ka Yesu wa̱ri a ucikpa. Vuma vi tani uza u Samariya u ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu wece yi, “Ma wundya eɗa ama kupa aza ɗa a ta̱na̱sa̱i vi, ama kuci vi alya te? ");
INSERT INTO kdlNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","A tsa̱ra̱ uza ɗa wa gono u cikpala Kashila̱ wa, she kamoci ka na koshi.” ");
INSERT INTO kdlNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yesu tonuko yi, “ꞌYa̱nga̱ vu yain nwalu n vunu, upityanangu u vunu u ta̱na̱sa̱ vu ɗe.” ");
INSERT INTO kdlNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pini nala, Afarishi a wece yi kain ka tsugono tsu Kashila̱ tsa tuwa̱. U wushunku le, “Utuwa̱ u tsugono tsu Kashila̱ n aꞌeshi a ɗa a ka wene tsa wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kpam a ka dana, ‘Tsa naha,’ ko ‘Tsa niɗe,’ wa. Kpaci a asuvu a ɗe a ɗa tsugono tsu Kashila̱ tsa̱ri.” ");
INSERT INTO kdlNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","U tonukoi atoni a ne, “Aꞌayin aꞌa̱ ta̱ a utuwa̱ a ɗa ya bolo uwene kain ka te a asuvu a aꞌayin a Maku ma Vuma, shegai ya wene wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ama a ka tonuko ɗa̱ ta̱, ‘Aya ɗe,’ ko ‘Aya na.’ Kotsu i bana wa, kpam i tono le wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kpaci tyoku ɗa ulaɗa u tsu wuta̱ walu a zuba aku u laɗai a kaɓon ka na ubana a ka niɗe, nala Maku ma Vuma ma woko a kain ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Shegai u ka̱na̱ ta̱ u pana ve ikyamba icun kau‑kau, ama a aꞌayin a na kpam a ꞌyuwan yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Tyoku ɗa wa̱ri a aꞌayin a Nuhu, nala dem wa woko a aꞌayin a Maku ma Vuma. ");
INSERT INTO kdlNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","A rongoi a ulya n a soyi, a rongoi uyansa iyolo n a wutukpi iyolo, hal kain ka Nuhu uwai a kpatsu. Aku mini ma pige ma tuwa̱i ma kaɗuwan le gba̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Nala dem a yain a aꞌayin a Lutu.† A rongoi a ulya n a soyi, a rongoi a utsila̱sa n a dengi, a rongoi a iceshi n a masi. ");
INSERT INTO kdlNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Shegai kain ka Lutu wuta̱i pini a Sodom vi, a roi akina n ka̱nga̱ ka akina a eri. A kaɗuwan le gba̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Nala dem wa woko a kain ka utuwa̱ u Maku ma Vuma. ");
INSERT INTO kdlNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Kain ka nala ki, uza ɗa baci wa̱ri a asu u uwunvugusa, aku ucanga u ne a asuvu a kuwa, she u dana wa ba wa bidya u ɗa wa. Nala dem uza ɗa wa̱ri a kashina, u gono a kuwa wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ciɓai n uka u Lutu! ");
INSERT INTO kdlNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Uza ɗa baci dem wa ciga u wauwa uma u ne, wa namba ta̱ u ɗa. Shegai uza ɗa baci dem u nekei uma u ne, wa wauwa ta̱ u ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","N tonuko ɗa̱, n kayin ka nala ki, ama a re a ka vaku ta̱ a ivamkpatsu i te, a ka a bidya ta̱ uza u te a a̱sa̱ka̱ uza u te. ");
INSERT INTO kdlNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Aka a re a ka wurya ta̱ a katali ka kira ka te, a ka bidya ta̱ uza u te, a a̱sa̱ka̱ uza u te.  ");
INSERT INTO kdlNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ama a re a ka bana ta̱ a kashina ka te, a bidya uza u te a a̱sa̱ka̱ uza u te.” ");
INSERT INTO kdlNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","A wece yi, “Asheku, nte wa̱ la vi?” U wushunku le, “A asu u ɗa kakushe ka̱ri, nte asakali a tsu ɓolomgbono pini.” ");
INSERT INTO kdlNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Aꞌa̱ri pini, Yesu yankai atoni a ne agisani tsa̱ra̱ u wenike an u gain a rongo a uyansa kavasu bawu ubula̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","U danai, “A ilyuci i roku a yan ta̱ uza u afada u roku uza ɗa bawu wa pana uwonvo u Kashila̱, kpam u wula̱ uza wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","A ilyuci yi tani, mara̱na̱ ma roku ma pini uza ɗa u rongoi ubansa ara ne n u foli u yanka le afada a ɗa aꞌa̱ri dere a mere ma ne n utokulalu u ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Wa̱ri u ꞌyuwan ta̱, shegai u tuwa̱i u danai a katakasuvu ka ne, ‘Ko u wokoi bawu ma pana uwonvo u Kashila̱, kpam ko bawu n wula̱i uza, ");
INSERT INTO kdlNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","tyoku ɗa mara̱na̱ ma na ma damgbara̱sa mu ma yanka le ta̱ afada a ɗa aꞌa̱ri dere. Kute wa, wa togboluso mu ta̱ n utuwusa̱ kure kure.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Aku Asheku a danai, “Panai ili iꞌya uza u afada u cingi u na vi u danai. ");
INSERT INTO kdlNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ya wundya Kashila̱ ka yanka aɗangi a ne a ɗa a ka sa̱ka̱ yi kaara n kayin ukuna u ɗa wa̱ri dere wa? Wa ɓa̱ra̱kpa̱ a asu u uwushunku le ɗa? ");
INSERT INTO kdlNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","N tonuko ɗa̱, wa yanka le ta̱ ukuna u ɗa wa̱ri dere gogo. Shegai, aꞌayin a ɗa baci mpa Maku ma Vuma n tuwa̱i, ma cina gba̱m ama ushani n upityanangu a likimba?” ");
INSERT INTO kdlNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu yanka le agisani a aza roku aza ɗa a bidyai kaci ka le ama a maci a ɗa, aku a goroi aza ɗa a buwai. U da, ");
INSERT INTO kdlNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ama a roku ama a re, a uwai a Kuwa ku Kashila̱ uyan kavasu. Uza u te Kafarishi ka, uza u ire tani kawushi ka utafa. ");
INSERT INTO kdlNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Kafarishi ki ka ꞌya̱nga̱i ka shamgbai ka yanka kaci ka ne kavasu ka na ki, u da, ‘Kashila̱, n cikpa vu ta̱ an u wokoi mpa ma̱ tyoku u ama ɗa a buwai wa. Wata, aza a maga̱la̱ka̱, aza ɗa bawu a ka yan dere, ashankala, ko kpam tyoku u kawushi ka utafa ka na ki. ");
INSERT INTO kdlNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","N tsu yan ta̱ kakuli kure a asuvu a aꞌayin a shindere. Kpam n tsu wutukpa̱ ta̱ u te a asuvu a kupa a ili iꞌya baci dem n tsa̱ra̱i.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Kawushi ka utafa ki tani ka̱ri kushani dan. U wushuku gba̱m u gaɗigba kaci ka ne a zuba wa, shegai u shamgbai wa lapa makamba ma ne adama a katsuma̱ ka lima̱, n u dansi, ‘Kashila̱, pana asuvayali a va̱, mpa uza u unyushi u cingi u ɗa.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“N tonuko ɗa̱, kawushi ka utafa ka na ka gono ta̱ a kuwa n katakasuvu ka ne dere a kapala ka Kashila̱. Tyoku uza niɗe u ɗa wa. Kpaci uza ɗa baci u bidyai kaci ka ne ili i roku, a ka vakunku yi ta̱. Uza ɗa baci kpam u vakunki kaci ka ne, a ka ꞌya̱nga̱sa̱ yi ta̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Aꞌa̱ri pini, ama a ka tukuso Yesu mmuku n kenu n kenu kotsu u sawa le. An atoni a ne a wenei nala, a ɓarana le. ");
INSERT INTO kdlNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Shegai u isa̱i mmuku ara ne u danai, “A̱sa̱ka̱i mmuku n tuwa̱ ara va̱, ɓishinka le wa. Kpaci tsugono tsu Kashila̱ tsu icun i le tsa. ");
INSERT INTO kdlNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mayun n tonuko ɗa̱, gba̱ uza ɗa baci bawu u wushai tsugono tsu Kashila̱ tyoku u maku ma kenu, wa uwa tsa wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Uzapige u roku u wecei Yesu, “Kawenishiki ka shinga, ndya ma yan n tsa̱ra̱ uma u ɗa bawu wa̱ri n utyoku?” ");
INSERT INTO kdlNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","U wushunku yi, “Ndya i zuwai vu isa̱ mu uza u shinga? Uza u shinga wa̱ la wa, she Kashila̱ koshi. ");
INSERT INTO kdlNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Vu reve ta̱ gai Mele ma na mi: ‘Kotsu vu vaku n uka ɗa bawu wa̱ri u vunu wa. Kotsu vu wuna uma u vuma gbani wa. Kotsu vu boko wa. Kotsu vu sira̱ka kaɓan kaɓetsu wa. Vu na̱ka̱ tata na̱ mma u vunu tsupige.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Aku uzapige vi u danai, “Tun mpa kenu ɗa ma̱ri a utono ili i na yi.” ");
INSERT INTO kdlNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","An Yesu panai nala, u tonuko yi, “Hal n gogo‑na ili i te iꞌya pini i gusa̱ vu. Denge gba̱ ili iꞌya va̱ri n iꞌya, vu pecike aza a unambi. Va yan ta̱ n utsa̱ri a zuba. Aku vu tuwa̱ vu tono mu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","An u panai nala, ukuna u ɓa̱la̱ yi cika, kpaci uza u utsa̱ri u ɗa cika. ");
INSERT INTO kdlNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu wundyana yi u danai, “U wuyana tani n ni uza u utsa̱ri u uwa a tsugono tsu Kashila̱! ");
INSERT INTO kdlNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","U la ta̱ shana karakuma ka wura a kpele ka kujulu, n u ɗa uza u utsa̱ri wa uwa a tsugono tsu Kashila̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Aza ɗa a panai kadyanshi ki a danai, “Nala baci, ya wa̱ la vi wa tsa̱ra̱ iwauwi?” ");
INSERT INTO kdlNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Shegai Yesu danai, “Ili iꞌya baci bawu vuma wa fuɗa wa yan, Kashila̱ ka fuɗa ta̱ ka yan iꞌya.” ");
INSERT INTO kdlNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Bituru danai, “A̱tsa na tsu a̱sa̱ka̱ ɗe gba̱ iꞌya tsa̱ri n iꞌya, tsu tono vu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu tonuko le, “Mayun n tonuko ɗa̱, uza u fuɗa baci u a̱sa̱ka̱i kuwa ku ne, u a̱sa̱ka̱i uka u ne, u a̱sa̱ka̱i atoku a ne, u a̱sa̱ka̱i kpam isheku i ne, wa̱ ta̱ n katsupi. Uza u fuɗa baci dem u a̱sa̱ka̱i mmuku n ne gba̱ adama a tsugono tsu Kashila̱, ");
INSERT INTO kdlNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","wa wusha ta̱ ili iꞌya i lai iꞌya u a̱sa̱ka̱i aꞌayin a gogo‑na. Kpam n aꞌayin a ɗa a ka tuwa̱, wa wusha ta̱ uma u ɗa bawu wa̱ri n utyoku.” ");
INSERT INTO kdlNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu isa̱i Kupanamere yi paki, u tonuko le, “A̱tsa na tsa bana a Urishelima. Gba̱ ili iꞌya iꞌa̱ri ukorongi a kaci ka Maku ma Vuma a akere a ntsumate ya shaɗangu ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kpaci a ka neke yi ta̱ a akere a Awulawa, a yanka yi majari, a goruso yi, a cikpunka̱ yi ata̱tsa̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","A ka bawan yi ta̱, a wuna yi, aku u ꞌya̱nga̱ a kain ka tatsu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Shegai ko ukuna u te a fuɗa a reve a asuvu a ili iꞌya u tonoi vi wa. Kpaci sokongu ɗa a sokongi u ɗa, a reve ili iꞌya u danai wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","An Yesu yain evu n Jeriko, karumba̱ ka roku ka̱ri a ikengi i ure wa folo. ");
INSERT INTO kdlNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","An u panai kakuma̱ ka ama a ka wura, aku u wecikei ko ndya a ka yan. ");
INSERT INTO kdlNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","A tonuko yi, “Yesu uza u Nazara ɗa wa wura.” ");
INSERT INTO kdlNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","U ꞌya̱nga̱sa̱i kala̱ga̱tsu u danai, “Yesu Maku ma Dawuda, pana asuvayali a va̱!” ");
INSERT INTO kdlNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Aku aza ɗa aꞌa̱ri a kapala a ɓarana yi u paɗa. Shegai u lapulai u salai cika, “Maku ma Dawuda, pana asuvayali a va̱!” ");
INSERT INTO kdlNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Aku Yesu shamgbai, u zuwai a tuko yi ara ne. An u raɓai evu n eyi, u wece yi, ");
INSERT INTO kdlNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ndya va ciga n yanka vu?” U danai, “Asheku, ma ciga n wene asu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu tonuko yi, “Wene asu, upityanangu u vunu u ta̱na̱sa̱ vu ɗe.” ");
INSERT INTO kdlNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kute‑kute u wenei asu. U tonoi Yesu n u cikpala̱si Kashila̱. An ama a wenei nala, ele dem a cikpalai Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Kain ka te, Yesu uwai a Jeriko, wa wura pini. ");
INSERT INTO kdlNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Aku uza roku uza u kala Zaka, uzapige u ɗa a asuvu a aza ɗa a ka wusha utafa, kpam uza u utsa̱ri ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Wa ciga u wene Yesu, shegai u fuɗa u wene yi wa, adama a kakuma̱ ka ama, kpaci eyi magbidi ma. ");
INSERT INTO kdlNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Aku u sumai u yuwa̱i makuli, kotsu u wene yi kpaci nte wa tono pini. ");
INSERT INTO kdlNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","An Yesu rawai pini a asu vi, u gaɗigbai kaci u tonuko yi, “Zaka, cipa̱ gogo! Ara a kuwa ku vunu ka ma cipa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","U yain maloko u cipa̱i, u wusha yi n ipeli. ");
INSERT INTO kdlNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","An a wenei nala, gba̱ le a gita̱i tsali, a danai, “A kuwa ku uza u unyushi u cingi u ɗa u cipa̱i.” ");
INSERT INTO kdlNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zaka ꞌya̱nga̱i kushani, u tonukoi Asheku, “Asheku, ma pece ta̱ utsa̱ri u va̱ kure, ma na̱ka̱ ta̱ aza a unambi kapashi ka te. Uza ɗa baci dem n wusai ili, ma gonuko yi ta̱ iꞌya n wusa yi iꞌya vi hal kunishi.” ");
INSERT INTO kdlNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu tonuko yi, “Ara iwauwi i tuwa̱ ta̱ a kuwa ku na ki, kpaci vuma u na dem maku ma Ibirahi ma. ");
INSERT INTO kdlNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mpa Maku ma Vuma n tuwa̱ ta̱ n zami iꞌya i puwa̱in, n wauwa kpam iꞌya.” ");
INSERT INTO kdlNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ele n a pani nala, Yesu lyai kapala n u tonusuko le agisani, kpaci wa̱ ta̱ evu n Urishelima. Kpam a ka wundya yavu tsugono tsu Kashila̱ tsa tuwa̱ kute‑kute. ");
INSERT INTO kdlNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","U danai, “Vuma roku u ɗa uza u tsugono, u banai a ilyuci i roku i mɓa̱ri, u wushi tsugono aku u gono. ");
INSERT INTO kdlNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","U isa̱i agbashi a ne kupa u na̱ka̱ le ikebe i zinariya i te i te. U tonuko le, ‘Yankai iꞌya tsilaga hal na̱ n goni.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Shegai ama a ilyuci i ne a ꞌyuwan yi, hal a sukunku yi azapige a danai ele a ka ciga u lyai tsugono a kaci ka le wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Gba̱ n nala, an u tsa̱ra̱i tsugono tsi, aku u gonoi. U zuwai a isa̱ka̱ yi agbashi a ɗa u na̱ka̱i ikebe yi u wene ili iꞌya a tsa̱ra̱i a asu u tsilaga tsu le. ");
INSERT INTO kdlNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Pini nala, uza u kagita̱ u tuwa̱i ara ne u danai, ‘Ukebe u te u vunu u tuko ta̱ ikebe kupa.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“U tonuko yi, ‘A dana̱sa vu kagbashi ka shinga! An u wokoi a cina vu uza u maci a kaci ka ili i kenu. Wusha tsugono tsu ilyuci kupa i woko katsupi ka malen ma manyan ma vunu.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Uza ire u tuwa̱i u tonuko yi, ‘Ukebe u te u vunu u tuko ta̱ ikebe i tawun.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Eyi dem u tonuko yi, ‘A na̱ka̱ vu ta̱ tsugono tsu ilyuci i tawun.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Uza roku kpam u tuwa̱i u danai, ‘Uzapige, ukebe u te u vunu u ɗa na, a makashi ma n sirai u ɗa n sokongi. ");
INSERT INTO kdlNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kpaci ma pana ta̱ uwonvo u vunu, adama a ɗa bawu va̱ri yuwu. Vu tsu bidya ta̱ ili iꞌya bawu vu zuwai. Vu cai kpam ili iꞌya bawu vu cei.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“U tonuko yi, ‘Kagbashi ka cingi, ma kiɗa̱ga vu ta̱ ugana a kaci ka ili iꞌya vu danai n una̱ u vunu. Dana vu reve ta̱ bawu ma̱ri yuwu? Uza ɗa n tsu bidya ili iꞌya bawu n zuwai? N cai kpam ili iꞌya bawu n cei? ");
INSERT INTO kdlNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ndya i zuwai bawu vu bankai ukebe vi a kuwa ku ikebe, tsa̱ra̱ n gono baci n wushi iꞌya hal n apashani?’ ");
INSERT INTO kdlNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“U tonukoi aza ɗa aꞌa̱ri pini a asu vi, ‘Wushai ukebe vi a kukere ku ne, i na̱ka̱ uza ɗa wa̱ri n ikebe kupa vi.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“A tonuko yi, ‘Asheku, wa̱ ta̱ tani n ikebe kupa.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“U da, ‘N tonuko ɗa̱, uza ɗa yankai ili iꞌya a na̱ka̱ yi manyan mai, aya a ka doku. Uza ɗa kpam bawu u yain ili, i kenu iꞌya wa̱ri n iꞌya vi, she a wusa yi iꞌya. ");
INSERT INTO kdlNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Atokulalu a va̱ a nala yi aza ɗa bawu a ka ciga n lyai tsugono a kaci ka le ki, tuko le na a kapala ka va̱ a wuna le.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","An Yesu danai nala, aku u lazai n atoni a ne, wa bana a Urishelima. ");
INSERT INTO kdlNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","An u yain evu n Betafaji n Batani a asu u masasa ma a ka isa̱ Masasa ma Zayitum, u suki atoni a ne ama a re. ");
INSERT INTO kdlNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","U tonuko le, “Uwai a une u ɗa wa̱ri nala a kapala ka ɗe ki. N uꞌuwa u ɗe, ya wene ta̱ maku ma makparyagi usiri ma bawu kotsu uza u yuwa̱i. I surukpa ma i tuko. ");
INSERT INTO kdlNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Uza ɗa baci dem u wece ɗa̱ ‘Ndya i zuwai ya surukpa ma?’ I tonuko yi, ‘Asheku a ɗa a ka ciga ma.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Aku aza ɗa a suki vi a lazai a ba a cinai tyoku ɗa u tonuko le vi. ");
INSERT INTO kdlNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Aꞌa̱ri pini a usurukpa makparyagi mi, aku aza a ili yi a tonuko le, “Adama a iyen a ɗa ya surukpa makparyagi mi?” ");
INSERT INTO kdlNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","A danai, “Asheku a ɗa a ka ciga ma.” ");
INSERT INTO kdlNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Aku a tukoi ma a asu u Yesu. A polusoi aminya a le a zuba u makparyagi mi. A taɗangi Yesu pini a zuba. ");
INSERT INTO kdlNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Wa̱ri a asuvu a nwalu, aku ama a polusoi aminya a le a ure. ");
INSERT INTO kdlNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","An u rawai evu n kagida̱li ka Masasa ma Zayitum, gba̱ kakuma̱ ka atoni a ne a gita̱i maza̱nga̱ a ka cikpala Kashila̱ n kala̱ga̱tsu ka ucira adama a ukunosavu u ɗa a wenei. ");
INSERT INTO kdlNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","A danai, “Uza u una̱ u shinga ɗa Magono ma ma tuwa̱ a asuvu a kala ka Magono ma Zuba! Ndishi n shinga a zuba, tsupige kpam a asu u Kashila̱!” ");
INSERT INTO kdlNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Afarishi a roku a asuvu a kakuma̱ ki a tonuko yi, “Kawenishiki, ɓarana atoni a vunu!” ");
INSERT INTO kdlNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Aku u danai, “N tonuko ɗa̱, ko ama a paɗa baci bini, she atali a gita̱ isali i maza̱nga̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","An u rawai evu n Urishelima u wenei ilyuci yi, aku u sa̱ka̱i iꞌya. ");
INSERT INTO kdlNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","U danai, “Aꞌa̱ri a dana vu reve ili iꞌya ya tuko ndishi n shinga, shegai gogo‑na iꞌa̱ ta̱ usokongi ara vunu. ");
INSERT INTO kdlNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Aꞌayin a ka tuwa̱ ta̱ a ɗa atokulalu a vunu a ka maka vu aga̱la̱la̱ a kasaga ka vunu ukyawan, a kpada vu ko nte wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","A ka wa̱sa̱ vu ta̱ hal she a iyamba avu n ama a vunu gba̱. A ka a̱sa̱ka̱ katali a zuba u utoku u ne a asuvu a vunu wa, an bawu vu wushai kune ku Kashila̱ aꞌayin a ɗa ku tuwa̱ ɗa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Aku Yesu uwai a Kuwa ku Kashila̱ u gita̱i uloko aza a tsilaga. ");
INSERT INTO kdlNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","U tonuko le, “Ukorongi u ɗa wa̱ri, a danai, ‘Kuwa ku va̱ ka woko ta̱ kuwa ku kavasu,’ shegai i gonukoi ka ‘kaɓuru ka aza a maga̱la̱ka̱.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kain dem, u tsu wenishike ta̱ a Kuwa ku Kashila̱, shegai aɗara̱kpi a pige, n awenishiki a Mele, n azapige a ama a zamai a wuna yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","A nambai tyoku ɗa a ka yan n eyi, kpaci kadyanshi ka ne ka pura̱ ta̱ ama atakasuvu. ");
INSERT INTO kdlNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kain ka te, tyoku ɗa Yesu wa̱ri a uwenishike ama a Kuwa ku Kashila̱, n u yanyi Kadyanshi ka Shinga ka Kashila̱. Pini nala, aɗara̱kpi a pige n awenishiki a Mele kaɓolo na̱ nkoshi n pige, a tuwa̱i ara ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","A danai, “Tonuko tsu, n ucira u eni u ɗa va yansa ili i na yi, kpam ya na̱ka̱ vu u ɗa?” ");
INSERT INTO kdlNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","U wushunku le, “Mpa dem ma yan ɗa̱ ta̱ keci. Tonuko numu, ");
INSERT INTO kdlNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ulyuɓugu u Yahaya, a zuba ɗa u wuta̱i ko a asu u ama?” ");
INSERT INTO kdlNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","A dansai utyoku u le, a danai, “Tsu dana baci, ‘A zuba ɗa,’ wa dana ta̱, ndya i zuwai tsu kpa̱ɗa̱i uwushuku n eyi? ");
INSERT INTO kdlNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Tsu dana baci, ‘A asu u ama,’ ama yi a ka vara̱sa tsu ta̱, kpaci a bidya ta̱ Yahaya matsumate ma.” ");
INSERT INTO kdlNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Aku a wushuki, “Tsu reve a asu u ɗa u wuta̱i wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu tonuko le, “Nala kpam mpa dem ma tonuko ɗa̱ ko ucira u eni u ɗa ma yansa̱ka ili i na yi wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesu gita̱i uyanka ama agisani a na yi, u danai, “Vuma roku u ɗa u yain kashina ka cinwi, aku u na̱ka̱i acimbi a roku haya. U lazai a uyamba u roku u ba u ɓa̱ra̱kpa̱i. ");
INSERT INTO kdlNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","An aꞌayin a uta a yain, u suki kagbashi ka ne ka roku a asu u aza a haya yi, tsa̱ra̱ a na̱ka̱ yi a asuvu a ucanga u kashina vi. Shegai acimbi yi a lapa yi, a loko yi akere a de. ");
INSERT INTO kdlNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","U suki kpam kagbashi ka roku, eyi dem a lapa yi, a yanka yi uwono, a loko yi akere a de. ");
INSERT INTO kdlNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","U doki u suki uza u tatsu, eyi tani a zumgbusa̱ yi, aku a loko yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Uza kashina vi u danai, ‘Ndya ma yan? Ma suku ta̱ maku ma va̱ ma ma ciga. Gaawan a ka wene ta̱ karinga̱ ka ne.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Shegai an acimbi yi a wene yi, a tonukoi kaci ka le, ‘Maku ma kagita̱ ma ne ma na vi. Tsu wuna ni tsa̱ra̱ agadu yi a woko a tsunu. ");
INSERT INTO kdlNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Aku a wutukpa̱ yi a uroto u kashina vi a wuna yi.’ “Ndya wa̱ uza u kashina vi wa yan? ");
INSERT INTO kdlNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Wa tuwa̱ ta̱ u wuna acimbi yi, u na̱ka̱ aza roku kashina ki.” An ama yi a panai nala, a danai, “Kashila̱ ka jebige!” ");
INSERT INTO kdlNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Shegai Yesu weɓele le, u danai, “Ndya kalen ka ili iꞌya iꞌa̱ri ukorongi a tagara̱da u Kashila̱? ‘Katali ka aza a kuma a ꞌyuwain, ka ka lakai kalen cika a asu u kuma.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Uza ɗa baci dem u rukpa̱i a zuba u katali ka nala ki, wa koɗuso ta̱. Shegai ka rukpa̱ baci ka varai uza, ka yuruwa yi ta̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Aku awenishiki a Mele n aɗara̱kpi a pige a zamai ure u ɗa a ka ka̱na̱ Yesu pini a aꞌayin a nala yi, kpaci a reve ta̱ a kaci ka le ka u yain agisani yi. Shegai a panai uwonvo u ama. ");
INSERT INTO kdlNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","A gita̱ yi uwanda̱sa, a suki aza a aka̱lu, ele tani a yain yavu aza a mayun a ɗa. A ka ciga a ka̱na̱ yi n kadyanshi ka ne, tsa̱ra̱ a banka yi a asu u uza u tsugono a yan yi mavura. ");
INSERT INTO kdlNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","A wece yi, “Kawenishiki, tsu reve ta̱ kadyanshi ka vunu n uwenishike u vunu u maci u ɗa. Ya dem una̱ u te u ɗa vu bidya yi, kpam ure u Kashila̱ u ɗa va wenishike mai. ");
INSERT INTO kdlNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","U gan tsu tsupa utafa ara Kaisa magono, ko tsu kpa̱ɗa̱ utsupa?” ");
INSERT INTO kdlNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Eyi tani u revei wanda ɗa a ka wanda yi, aku u tonuko le, ");
INSERT INTO kdlNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Wenike numu ukebe u azurufa. Kulu n kala ka yai ka ka̱ri pini a ukebe vi?” A danai, “Ku Kaisa ka.” ");
INSERT INTO kdlNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Aku u tonuko le, “Na̱ka̱i Kaisa ili iꞌya iꞌa̱ri i Kaisa, Kashila̱ kpam i na̱ka̱ yi ili iꞌya iꞌa̱ri i Kashila̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","A fuɗa a ka̱na̱ yi n kadyanshi ka u yain a kapala ka ama wa. Adama a majiyan ma uwushuku u ne, a paɗai bini. ");
INSERT INTO kdlNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ama a roku a ɗa pini aza a Sadusi,† a tuwa̱i ara Yesu. Ama a na yi alya aza ɗa a danai uꞌya̱nga̱ u ukpa̱ wa̱ la wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","A wece yi, “Kawenishiki, Musa koronku tsu ta̱, u danai, ‘Uza u kuwa̱ baci u a̱sa̱ka̱i uka bawu mmuku, u ka̱na̱ ta̱ utoku u ne u sotuku uka vi, u matsa̱ka yi mmuku.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","A yan ta̱ ama roku ama a shindere, uza n utoku. Uza u kapala u zuwai uka, u kuwa̱i u a̱sa̱ka̱ maku wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Uza u ire u sotuki mara̱na̱ mi, eyi dem u kuwa̱i bawu maku. ");
INSERT INTO kdlNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Uza u tatsu kpam u sotuki mara̱na̱ mi, eyi dem u kuwa̱i. Nala gba̱ ama a shindere yi a zuwusai uka vi, hal a kuwusa̱i gba̱ le, uza wa̱ la u a̱sa̱ka̱i maku wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","A makorishi, uka vi dem u kuwa̱i. ");
INSERT INTO kdlNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","An u wokoi gba̱ ama a shindere a le a zuwusa yi vi, uka u yai u ɗa wa woko a aꞌayin a uꞌya̱nga̱ a ukpa̱?” ");
INSERT INTO kdlNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu wushuki, “Ama a gogo‑na a ka yansa ta̱ iyolo n a wutukpi iyolo. ");
INSERT INTO kdlNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Shegai aza ɗa baci a wenei a gain a uwa aꞌayin a ɗa a ka tuwa̱, kpam n uꞌya̱nga̱ u ukpa̱ vi, a ka yan iyolo ko a wutukpa̱ iyolo wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","A ka doku a ka kuwa̱ wa, kpaci dere ɗa aꞌa̱ri n atsumate a zuba, kpam mmuku n Kashila̱ n ɗa an a wokoi mmuku ma uꞌya̱nga̱ u ukpa̱ n ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ukuna u akushe n u uꞌya̱nga̱ u ukpa̱ tani, Musa dem dana ta̱ a ukuna u maku ma maɗanga ma ma tasa akina a asu u ɗa u isa̱i Magono ma Zuba ‘Kashila̱ ka Ibirahi, n Kashila̱ ka Ishaku, n Kashila̱ ka Yakubu.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Eyi Kashila̱ ka akushe ka wa, shegai ka aza a uma ka, kpaci ara ne ya dem wa̱ ta̱ n uma.” ");
INSERT INTO kdlNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Aku aza roku a asuvu a awenishiki a Mele yi a danai, “Kawenishiki, vu wushuku ta̱ dere.” ");
INSERT INTO kdlNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Pini nala, uza u doku u kawan u wece yi ukuna wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Aku Yesu wece le, “Niɗa a ka a dana Kawauwi Maku ma Dawuda ma? ");
INSERT INTO kdlNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dawuda n kaci ka ne u danai a Tagara̱da u Ishipa,† ‘Magono ma Zuba ma tonukoi Asheku a va̱, dusuku a ulyaki u va̱, ");
INSERT INTO kdlNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hal she n taɗangu vu a zuba u atokulalu a vunu.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dawuda isa̱ yi baci ‘Asheku’, niɗa wa yansa u gono u woko maku ma ne?” ");
INSERT INTO kdlNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yesu tonukoi atoni a ne a kapala ka ama gba̱, ");
INSERT INTO kdlNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Kiranai n awenishiki a Mele aza ɗa a ka ciga kutambu n aminya a pige, a ka ciga a dana̱sa le a kuden n tsupige. Kpam a lai uciga u asu u ndishi u ɗa u lai tsulobo a agata a Kashila̱, n asu u shinga u asu u abiki. ");
INSERT INTO kdlNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Alya a lyai ucanga u nra̱na̱, n a yanyi kavasu ka ugaɗi adama a ukimbusa̱ u aꞌeshi. Icun i ama a nala yi, a ka yan le ta̱ mavura cika.” ");
INSERT INTO kdlNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Kain ka te, Yesu wa̱ri a Kuwa ku Kashila̱, aku u gaɗigbai kaci ka ne u wenei tyoku ɗa aza a utsa̱ri a ka zuwusa ikebe i le a asu u uzuwusa ikebe. ");
INSERT INTO kdlNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","U wenei kpam mara̱na̱ ma roku uza u unambi, ma zuwai pini irim i re i kenu a asuvu. ");
INSERT INTO kdlNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Pini nala, u da, “Mayun n tonuko ɗa̱, ili iꞌya mara̱na̱ uza u unambi u nala u zuwai, i la ta̱ gba̱ ili iꞌya ele a zuwusai. ");
INSERT INTO kdlNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kpaci gba̱ le a asuvu a utsa̱ri u le u ɗa a kenei a zuwusai. Shegai eyi a asuvu a unambi u ne u ɗa u bidyai gba̱ ikebe i ulyaka ilikulya i ne.” ");
INSERT INTO kdlNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Aza roku a asuvu a atoni a ne, aꞌa̱ri a kadyanshi tyoku ɗa a kalai Kuwa ku Kashila̱ n atali a shinga, n kune ku a na̱ka̱i Kashila̱. Shegai Yesu danai, ");
INSERT INTO kdlNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Gba̱ ili iꞌya i wenei pini na, aꞌayin aꞌa̱ ta̱ a utuwa̱ a ɗa ko katali ka te a ka a̱sa̱ka̱ utaɗangi a zuba u utoku u ne, bawu a wa̱sa̱i ka wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Pini nala, a wece yi, “Kawenishiki, nwere ɗa ukuna u nala vi wa gita̱? Icun i iryoci i eni iꞌya a ka wenike ya ciga baci ugita̱?” ");
INSERT INTO kdlNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","U tonuko le, “Kiranai kotsu uza roku u puwunsa̱ ɗa̱ wa. Ama ushani a ka tuwa̱ ta̱ n kala ka va̱ a dana alya Kirisiti Kawauwi. Kpam a dana, ‘Aꞌayin a yan ɗe evu.’ Kotsu i toni le wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Aꞌayin a ɗa baci i panai ukuna u kuvon n ibili, kotsu i giruwa̱ wa. U ka̱na̱ ta̱ ukuna u nala u gita̱, shegai makorishi ma kotsu wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","U tonuko le kpam, “Kaletsu ka ama ka ꞌya̱nga̱sa̱ka̱ ta̱ kaletsu ka ama, tsugono kpam tsu ꞌya̱nga̱sa̱ka̱ tsugono. ");
INSERT INTO kdlNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Iyamba ya gba̱ɗa̱ ta̱ a asu kau‑kau, n kambulu n usara a asu kau‑kau. A ka yan ta̱ ili i uwonvo n ikunesavu i pige i pige a zuba. ");
INSERT INTO kdlNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Shegai kahu ukuna u nala u gita̱, a ka ka̱na̱ ɗa̱ ta̱ a yan ɗa̱ mavura. A banka ɗa̱ a agata a Kashila̱ n aꞌuwa a aꞌali. A banka ɗa̱ a asu u azapige na̱ ngono adama a kala ka va̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nala wa woko ɗa̱ ta̱ ure u ɗa ya yanka le kadyanshi ka va̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Shegai i vakunku atakasuvu a ɗe, i dambula n tyoku ɗa ya gonuko kadyanshi wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kpaci mpa ma na̱ka̱ ɗa̱ ta̱ ucira n ugboji u ɗa bawu atokulalu a ɗe a ka fuɗa a nanamgbana, ko a nani u ɗa wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Hal n isheku i ɗe n atoku a ɗe n kumaci ku ɗe, n aje a ɗe a ka neke ɗa̱ ta̱, hal a wuna gba̱m aza roku a asuvu a ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ya dem wa ꞌyuwan ɗa̱ ta̱ adama a kala ka va̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Shegai ko kenji ka kaci ka ɗe ka te ka̱ la ka namgba wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Akawunki a ɗe a ɗa a ka wauwa ɗa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yesu lyai kapala n kadyanshi, “Aꞌayin a ɗa baci i wenei asoje a kyawain Urishelima, u gan ta̱ i reve an a yain evu n uwacinsa u ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Adama a nala, a̱sa̱ka̱ aza ɗa aꞌa̱ri a uyamba u Yahuda a suma a bana a nsasa. Aza ɗa aꞌa̱ri a ilyuci a wuta̱ a suma, kpam aza ɗa aꞌa̱ri a une kotsu a uwa a asuvu a ilyuci wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kpaci aꞌayin a katsupi ka upana u ikyamba a ɗa, tsa̱ra̱ a shaɗangu iꞌya iꞌa̱ri ukorongi. ");
INSERT INTO kdlNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ter ɗe aka a atsuma̱ n aza a mmuku n shili a aꞌayin a nala yi! Kpaci a ka yan ta̱ upana u ikyamba u pige a uyamba vi, aku upan u Kashila̱ u rukpa̱ a kaci ka ama ki. ");
INSERT INTO kdlNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","A ka wuna ta̱ aza roku n iburundu, a ka̱na̱sa̱ kpam aza roku a bansa̱ka le a asu u tsugbashi a iyamba i likimba. Awulawa kpam a ka kpatsa ta̱ Urishelima hal aꞌayin a Awulawa a shaɗangu. ");
INSERT INTO kdlNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yesu doku u danai, “A ka wene ta̱ iryoci a kaara n uwoto n atala. A likimba kpam, aletsu a ama a ka dambula ta̱ cika. A dambula cika adama a mawura̱ ma kushiva̱ n aɓali. ");
INSERT INTO kdlNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ama a ka limusa̱ ta̱ adama a uwonvo, n a pani uwonvo u ili iꞌya ya gita̱sa̱ a likimba. Kpaci a ka gba̱ɗa̱ ta̱ ili i pige i pige iꞌya iꞌa̱ri a zuba. ");
INSERT INTO kdlNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Aꞌayin a nala a ɗa a ka wene Maku ma Vuma utuwa̱ a asuvu a alishi n ucira n tsupige tsu pige. ");
INSERT INTO kdlNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Aꞌayin a ɗa baci ukuna u nala wa gita̱sa̱, i gaɗigba aꞌaci a ɗe i kondo zuba kpaci uwutukpa̱ u ɗe wa yan ɗe evu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Aku Yesu yanka le agisani a na yi u da, “Weɓelei maɗanga ma kapopi na̱ nɗanga n ɗa n buwai. ");
INSERT INTO kdlNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","N gita̱ baci utopo avuku, ya wene ta̱ n kaci ka ɗe kpam i reve an ilyushi i yain evu. ");
INSERT INTO kdlNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nala dem, aꞌayin a ɗa baci i wenei ukuna u nala wa gita̱sa̱, i reve ta̱ an tsugono tsu Kashila̱ tsu yain evu. ");
INSERT INTO kdlNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Mayun n tonuko ɗa̱, ama a gogo‑na a ka kotso wa, she a shaɗangu ili i na yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Zuba n likimba wa cimba̱ ta̱. Shegai kadyanshi ka va̱ ka cimba̱ wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Pini nala, Yesu danai, “Kiranai n kaci ka ɗe, kotsu uma u ɗe u laka a asu u kulya ku gbani, n kuso ku umaka wa, n kadambula ka likimba, hal kain ka nala ka danda ɗa̱ tyoku u utyangi wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kpaci nala wa woko a kaci ka ama a likimba gba̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kain dem i rongo n afoɓi, n i yanyi kavasu, tsa̱ra̱ i tsa̱ra̱ i lai a asuvu a ukuna u ɗa wa ciga u gita̱ vi. Kpam tsa̱ra̱ i fuɗa i shamgba a kapala ka Maku ma Vuma.” ");
INSERT INTO kdlNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kain dem, u tsu wenishike ta̱ a Kuwa ku Kashila̱. Kaara ka kotso baci aku u wuta̱ u ba u wansa a masasa ma a ka isa̱ Masasa ma Zayitum. ");
INSERT INTO kdlNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kpam ama a tsu tuwusa̱ ta̱ a Kuwa ku Kashila̱ n usana u de, tsa̱ra̱ a pana̱ka yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Aꞌayin a Abiki a Ulya u Ilikulya iꞌya i Nambai Yisti† a ɗa dem a ka isa̱ Abiki a Upasamgbana a yain evu. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Aku aɗara̱kpi a pige n awenishiki a Mele a ka zama tyoku ɗa a ka wuna Yesu, shegai a ka pana ta̱ uwonvo u ama. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kanangasi ka uwai Yahuza, uza ɗa a ka isa̱ Isikariyoti, uza u te a asuvu a Kupanamere yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","U ba u dansai n aɗara̱kpi a pige n azapige aza a uwundya Kuwa ku Kashila̱ tyoku ɗa wa neke yi ara le. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","A yain maza̱nga̱ hal a zuwamgbanai a ka tsupa yi n ikebe. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Eyi kpam u wushuki u gita̱i uzama tyoku ɗa wa neke yi ara le, kakuma̱ ka ama ka wacuwa baci. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kain ka Abiki a Ulya Ilikulya iꞌya i Nambai Yisti ka rawai; wata, kain ka ukiɗa̱sa mmuku ma aꞌondom ma Abiki a Upasamgbana. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Aku Yesu suki Bituru n Yahaya, u tonuko le, “Walai i ba i foɓusuko tsu Abiki a Upasamgbana yi, tsa̱ra̱ tsu lyai.” ");
INSERT INTO kdlNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","A wece yi, “Nte ɗa va ciga tsu foɓuso?” ");
INSERT INTO kdlNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","U tonuko le, “N uꞌuwa u ɗe a ilyuci yi, ya gawunsa ta̱ n vuma roku u cangai malanda ma mini. I toni yi hal a kuwa ka wa uwa. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","I tonuko uza u kuwa vi, ‘Kawenishiki ka danai: Nte ɗa a asu u ɗa ma lya ilikulya i Abiki a Upasamgbana yi n atoni a va̱?’ ");
INSERT INTO kdlNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Wa wenike ɗa̱ ta̱ kunukuzuba ku pige ka ucanga u ne wa̱ri ufoɓusi. Nte ya foɓusuko tsu pini.” ");
INSERT INTO kdlNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Aku a lazai a ba a cinai tyoku ɗa u tonuko le vi. Pini nala, a foɓusoi ilikulya i Abiki a Upasamgbana yi pini. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","An aꞌayin a yain, Yesu dusuki ulya ilikulya n asuki yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","U tonuko le, “Ma̱ri ma ciga ta̱ gba̱m n lyai ilikulya i Abiki a Upasamgbana i na yi n a̱ɗa̱, kahu n pana ikyamba. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kpaci n tonuko ɗa̱, ma doku ma lya iꞌya wa, she aꞌayin a ɗa a shaɗangi u ɗa a tsugono tsu Kashila̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","U bidyai mako ma mini ma cinwi, u cikpai Kashila̱ aku u danai, “Wushai na i soi. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","N tonuko ɗa̱, ili iꞌya i bidyai n gogo‑na ma doku ma so mini ma cinwi wa, she aꞌayin a ɗa tsugono tsu Kashila̱ tsu tuwa̱i.” ");
INSERT INTO kdlNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","U bidyai burodi u cikpai Kashila̱, u jiba̱mgba̱na̱sa̱i u ɗa, u na̱ka̱ le. U danai, “Ikyamba i va̱ iꞌya na vi iꞌya a nekei adama a ɗe. Rongoi uyansa nala tsa̱ra̱ i ciɓusa na̱ mpa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","An a kotsoi ulya u ilikulya vi, u bidyai mako mi, u danai, “Mako ma na mi, kazuwamgbani ka savu ka a asuvu a mpasa n va̱ n ɗa a ka neke adama a ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Shegai uza ɗa wa neke mu vi, aya pini na wa lya kaɓolo na̱ mpa. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mayun ɗa mpa Maku ma Vuma ma laza tyoku ɗa a zuwai, shegai ter n uza ɗa wa neke mu vi.” ");
INSERT INTO kdlNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","A gita̱i uwecemgbene ko ya wa neke yi a asuvu a le yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kananamgbani ka uwai a mere ma le, ko ya wa woko uzapige u le. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","U tonuko le, “Ngono ma Awulawa a tsu ciga ta̱ a wenike le ucira. Akiɗi a ugana a le kpam a tsu zama ta̱ a isa̱ le Aɓa̱ngi a Ama. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Shegai ara ɗe nala wa. Uza ɗa wa̱ri uzapige a asuvu a ɗe, u woko tyoku u uza u kenu. Uza ɗa wa tono n a̱ɗa̱, u woko tyoku u kagbashi. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ya lai tsupige, uza ɗa u dusuki wa lya ilikulya ko gai kagbashi? Uza ɗa u dusuki wa lya ilikulya ɗa wa? Mpa tyoku u kagbashi ɗa ma̱ri a asuvu a ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Eɗa i shamgbai ara va̱ a ukonduso u ɗa n soi. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Tyoku ɗa Tata u va̱ u na̱ka̱ mu tsugono, nala mpa dem ma na̱ka̱ ɗa̱ ucira, ");
INSERT INTO kdlNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","tsa̱ra̱ i lyai i soi na̱ mpa a tsugono tsu va̱. I dusuku kpam a aratsu a tsugono, n i lyayi tsugono tsu agali kupa n a re a Isaraꞌila. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ele pini n a lyayi, aku u danai, “Simo, Simo, Kanangasi ka folo ta̱ u welikpe ɗa̱ tyoku u ilya. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Shegai ma yanka vu ta̱ kavasu, tsa̱ra̱ upityanangu u vunu u gusa̱ wa. Avu kpam aꞌayin a ɗa vu gonoi, vu gbamatangu aza a vunu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Bituru wushunku yi, “Asheku, ufoɓusi u ɗa ma̱ri n bana n avu a kuwa ku aꞌali, ko a ukpa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu danai, “N tonuko vu Bituru, ara gba̱m kahu kapen ka sala, va nana mu ta̱ vu dana vu reve mu wa hal kutatsu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesu wece le, “Aꞌayin a ɗa n suku ɗa̱ bawu makpaka̱ta, bawu katsa̱n, bawu akpata, ili iꞌa̱ la iꞌya i nambai?” A danai, “Ko i te tsu namba wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","U da, “Gogo‑na uza ɗa baci wa̱ri n makpaka̱ta u bidya, nala kpam uza ɗa wa̱ri n katsa̱n. Uza ɗa bawu wa̱ri n burundu, u denge kunya ku ne u tsila. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","N tonuko ɗa̱, mayun ɗa ukuna u ɗa a korongi a kaci ka va̱ u ka̱na̱ ta̱ u shaɗangu, ‘A kece yi ta̱ a asuvu a aza ɗa a ꞌya̱nga̱sa̱ka̱i tsugono.’ Kpaci ili iꞌya a danai a kaci ka va̱, ushaɗangu u ne u rawa ɗe.” ");
INSERT INTO kdlNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Aku a tonuko yi, “Asheku, iburundu iꞌya na i re.” U tonuko le, “U rawa ta̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu wuta̱i u banai a Masasa ma Zayitum tyoku ɗa u cuwana̱kai, atoni a ne dem a tono yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","An u rawai a asu vi, u tonuko le, “Yanyi kavasu kotsu i rukpa̱ a ukondo wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","U a̱sa̱ka̱ le kenu, tyoku u mɓa̱ri ma uvuta̱la̱ katali, u kuɗa̱ngi u yain kavasu. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","U danai, “Tata, vu wushuku baci, takpa mu mako ma upana u ikyamba ma na mi, shegai udani u va̱ u ɗa a ka tono wa, she u vunu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Aku katsumate ka zuba ka wenikei kaci ka ne ara ne, wa̱ri yi a ugbamatangu asuvu. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Kpaci wa pana ta̱ ikyamba cika. U ma̱tsa̱i kavasu cika, hal malen ma ne ma ɗaka yavu mpasa. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","An u ꞌya̱nga̱i a asu u kavasu vi, u gonoi a asu u atoni a ne. U cina le n a lavuti adama a uwowi u unamgbukatsuma̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","U wece le, “Ndya i zuwai ya lavuta? ꞌYa̱nga̱i i yain kavasu, kotsu i rukpa̱ a ukondo wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu pini a kadyanshi, aku u wenei kakuma̱ ka ama ka tuwa̱ yi. Uza ɗa a ka isa̱ Yahuza Isikariyoti, uza u te a asuvu a Kupanamere yi, wa tono n ele kapala. U raɓai evu n Yesu kotsu u wambatsa yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Aku Yesu wece yi, “Yahuza, n uwambatsa u ɗa va neke Maku ma Vuma?” ");
INSERT INTO kdlNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Aza ɗa aꞌa̱ri evu n eyi, an a wenei ili iꞌya ya gita̱, a wece yi, “Asheku, tsu kapusa n iburundu ɗa?” ");
INSERT INTO kdlNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Aku uza u te u le u kapamgbanai kutsuvu ku ulyaki ku kagbashi ka Magono ma Aɗara̱kpi. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yesu danai, “Kotsu i doku wa.” U sawai kutsuvu ku kagbashi ki, u ta̱na̱sa̱ yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","U tonukoi aza ɗa a ꞌya̱nga̱sa̱ka̱ yi vi; wata, aɗara̱kpi a pige, n azapige a awundi a Kuwa ku Kashila̱, na̱ nkoshi, “I tuwa̱i n iburundu na̱ mkpa̱ukpa̱u yavu aza a uka̱na̱ aza a maga̱la̱ka̱? ");
INSERT INTO kdlNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Aꞌayin a ɗa ma̱ri n a̱ɗa̱ kain dem a asuvu a Kuwa ku Kashila̱, i ba̱ra̱kpa̱ akere a ɗe i dana ya ka̱na̱ mu wa. Shegai aꞌayin a ɗe a ɗa na vi, n aꞌayin a ucira u karimbi.” ");
INSERT INTO kdlNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Pini nala, a ka̱na̱i Yesu a lazai n eyi, a banka yi a kuwa ku Magono ma Aɗara̱kpi. Bituru wa̱ri le a utono mɓa̱ri mɓa̱ri. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","A tasuki akina a mere ma kuwa mi a dusuki. Bituru dem dusuki kaɓolo n ele. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Aku kagbashi ka ka̱ri makere ka wene yi aꞌayin a ɗa katyashi ka akina ka wakanai, pini nala, kagbashi ki ka danai, “Vuma u na dem kaɓolo n eyi ɗa wa̱ri.” ");
INSERT INTO kdlNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Shegai u nanai u danai, “Mpa n reve yi wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","An a ɓa̱ra̱kpa̱i kenu, aku uza roku u wene yi u danai, “Avu dem uza u te u le u ɗa.” Bituru danai, “Uza u va̱, mpa n reve yi wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","A doki a ɓa̱ra̱kpa̱i hal ulapa u uwule u te, uza roku u ma̱tsa̱ yi, u danai, “Mala̱la̱ ma̱ la wa, vuma u na kaɓolo ka aꞌa̱ri, kpaci uza u Galili u ɗa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Bituru danai, “Uza u va̱, n reve gba̱m iꞌya va tono wa.” Kute‑kute kahu u kimba̱ una̱ u ne, kapen ka salai. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Asheku a kpatalai a kondonoi Bituru. Aku u ciɓai n kadyanshi ka Asheku, u da, “Ara gba̱m kahu kapen ka sala, va nana mu ta̱ vu dana vu reve mu wa hal kutatsu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Aku u wuta̱i a ulanga u sa̱i cika. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ama ɗa a ka wundya Yesu vi a rongo yi uyanka majari n a lapusi yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","A sira yi aꞌeshi, aku a danai, “Tonuko tsu ili iꞌya ya gita̱. Ya lapa vu?” ");
INSERT INTO kdlNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","A rongo yi a uyansa̱ka kadyanshi ka gbani ka gbani ushani n a wishisi yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","An kain ka wansai, aku Asheshi a Pige,† (asuvu a aɗara̱kpi a pige, n awenishiki a Mele) a ɓolomgbonoi a asu u te. A bankai Yesu a asu u Asheshi a Pige a le, a tonuko yi, ");
INSERT INTO kdlNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Avu Kirisiti Kawauwi ɗa baci, tonuko tsu.” U danai, “Ko n tonuko ɗa̱ baci, ya wushuku wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","N yan ɗa̱ baci kpam keci, ya wushunku mu wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Shegai ili iꞌya i bidyai gogo‑na ubana a kapala, Maku ma Vuma ma dusuku ta̱ a ulyaki u Kashila̱ Uza u Ucira.” ");
INSERT INTO kdlNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Gba̱ le a danai, “Dana, avu Maku ma Kashila̱ ma?” U tonuko le, “I dana ta̱ dere, mpa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Aku a danai, “Iryoci i eni iꞌya kpam tsa bolo? Tsu pana ta̱ n kaci ka tsunu a una̱ u ne.” ");
INSERT INTO kdlNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Pini nala, gba̱ kaɓolo ka Asheshi a Pige yi a ꞌya̱nga̱i a bankai Yesu ara Bilatu gomuna u Yahuda. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","A sapula yi, a danai, “Tsu cina ta̱ vuma u na vi wa puwunsa̱ a ama a tsunu. Kpam n u ɓishinki ama a tsupa utafa ara Kaisa. N u dansi kpam aya Kirisiti Kawauwi Magono.” ");
INSERT INTO kdlNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Bilatu wece yi, “Avu magono ma aza a Yahuda ma?” Aku u wushunku yi, “Nala wa̱ri tyoku ɗa vu danai vi.” ");
INSERT INTO kdlNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Bilatu tonukoi aɗara̱kpi a pige yi n kakuma̱ ka ama ki, “N tsa̱ra̱ vuma u na vi n unyushi wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","A doki a ma̱tsa̱ yi n a dansi, “Wa ꞌya̱nga̱sa̱sa̱ ta̱ atakasuvu a ama n uwenishike u ne a uyamba u Yahuda. U gita̱i ukuna u nala vi a Galili hal utuwa̱ na.” ");
INSERT INTO kdlNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","An Bilatu panai nala, u wecikei ko vuma vi uza u Galili u ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","An u revei Yesu a kaɓon ka tsugono tsu Hiridu Antiba tsa u wuta̱i, u geɓengu yi ara Hiridu uza ɗa wa̱ri dem a Urishelima aꞌayin a nala yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","An Hiridu wenei Yesu, u yain maza̱nga̱ cika kpaci wa ciga ta̱ u wene yi caupa. An u panai ukuna u ne, kpam wa ciga ta̱ u wene ukunosavu u ɗa Yesu wa yansa. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","U rongo yi a uyansa keci, shegai u wushunku yi ili wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Aɗara̱kpi a pige n awenishiki a Mele a ɗa pini kushani a rongo yi usapulusa ushani. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hiridu n asoje a ne a yanka yi magori, a yanka yi kpam majari. A uka yi aminya a tsugono, aku a gonuko yi ara Bilatu. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kain ka nala ka tsije tsu Hiridu n Bilatu tsu gita̱i. Kpaci caupa atokulalu a ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Bilatu ɓolomgbonoi aɗara̱kpi a pige, n aza a tsugono, n ama. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","U tonuko le, “I tuko ta̱ vuma u na i da wa puwunsa̱ ta̱ ama. Kpam an n vece yi a kapala ka ɗe, n tsa̱ra̱ yi n unyushi ko u te a asuvu a ikuna iꞌya i danai vi wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nala dem Hiridu u tsa̱ra̱ yi n unyushi wa, kpaci aya u gonuko yi ara tsunu. U yan ili iꞌya i ra̱tsai a ka wuna yi wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Adama a nala, ma bawan yi ta̱ n a̱sa̱ka̱ yi.”  ");
INSERT INTO kdlNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","U tsu a̱sa̱nka̱ le ta̱ vuma u te a asuvu a ama ɗa aꞌa̱ri a kuwa ku aꞌali a aꞌayin a abiki. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Gba̱ ama a ꞌya̱nga̱sa̱i ala̱ga̱tsu a le, a danai, “Rawuka vuma u na vi! A̱sa̱nka̱ tsu Baraba!” ");
INSERT INTO kdlNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Baraba aya uza ɗa a zuwai a kuwa ku aꞌali adama a uꞌya̱nga̱sa̱ u atakasuvu a ama u ɗa a yain n mawunuka a ilyuci yi.) ");
INSERT INTO kdlNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Aku Bilatu doku u yanka le kadyanshi, kpaci wa ciga ta̱ u a̱sa̱ka̱ Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Shegai a worukpoi n a dansi, “Wandamgbana yi! Wandamgbana yi!” ");
INSERT INTO kdlNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","U doki u tonuko le u tatsu, “Ndya i zuwai? Ili i cingi i eni iꞌya u yain? N tsa̱ra̱ yi n ili iꞌya i ra̱tsai a ka wuna yi wa. Adama a nala ma bawan yi ta̱ n a̱sa̱ka̱ yi.” ");
INSERT INTO kdlNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Shegai a rongo yi a uma̱tsa̱, a ꞌya̱nga̱sa̱i ala̱ga̱tsu a le a danai a wandamgbana yi, hal isali i le i fuɗai Bilatu. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Aku Bilatu kiɗa̱ga yi ugana, tsa̱ra̱ a yanka le iꞌya a ka ciga. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","U a̱sa̱nka̱ le uza ɗa a foloi vi; wata, uza ɗa a zuwai a kuwa ku aꞌali, adama a uꞌya̱nga̱sa̱ atakasuvu a ama n mawunuka. U na̱ka̱ le Yesu tyoku ɗa a ka ciga. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Aꞌa̱ri pini a nwalu n eyi, aku a ka̱na̱i vuma roku uza u kala Simo uza u Sirani, u wuta̱i a une. A taɗanku yi mawandamgbani mi u canga u toni Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kakuma̱ ka ama ushani ka tono yi hal n aka a roku aza ɗa a rongoi kushen n a pani mɓa̱la̱ ma ulaza u ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu kpatalai ara le u danai, “Aka a Urishelima, a̱sa̱ka̱i kushen adama a va̱. Shegai, i sa̱ka̱ kaci ka ɗe na̱ mmuku n ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Aꞌayin aꞌa̱ ta̱ a utuwa̱ a ɗa a ya dana, ‘Aza a una̱ u shinga a ɗa ndari, n atsuma̱ a ɗa bawu a matsai mmuku, kpam n mani ma bawu ma comukoi maku.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Aꞌayin a nala a ɗa a ka gita̱ ufolo nsasa n pige n pige, ‘Rukpa̱i a kaci ka tsunu.’ A foli kpam aga̱la̱la̱ a dana, ‘Ciɗa̱ngu tsu.’ ");
INSERT INTO kdlNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","A yanka baci maɗanga ma ta̱ku ukuna u naha, ndya ya gita̱ ma ekpe baci?” ");
INSERT INTO kdlNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","A banka ta̱ dem ama roku ama a re aza a maga̱la̱ka̱, tsa̱ra̱ a wuna le kaɓolo n eyi. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","An a rawai a asu u ɗa a ka isa̱ Mako ma Kaci, nte a wandamgbana yi pini n aza a unyushi u cingi a nala yi uza te a ulyaki, uza te a ugula̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu danai, “Tata, cimbusuka̱ le, kpaci a reve ili iꞌya a ka yan wa.” A varangi uruta a pecishei aminya a ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ama a shamgbai aꞌa̱ri a aka̱lu. Azapige tani a ka yanka yi majari a danai, “U wauwai aza roku, u wauwa kaci ka ne wa̱wa, aya baci uza ɗa Kashila̱ ka ɗanga̱sai u woko Kirisiti Kawauwi u Kashila̱.” ");
INSERT INTO kdlNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Asoje dem a yansa̱ka yi ta̱ majari. A banai ara ne a na̱ka̱ yi mini ma kalam. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","A danai, “Aɗa baci magono ma aza a Yahuda, wauwa kaci ka vunu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ikorongi iꞌya pini zuba n kaci ka ne, EYI NA MAGONO MA AZA A YAHUDA MA. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Uza u te a asuvu a aza ɗa a wandamgbanai kaɓolo n eyi vi, u yanka yi kadyanshi ka gbani, u danai, “Ma wundya a ɗa Kawauwi ki. Wauwa kaci ka vunu n a̱tsu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Shegai uza u te vi u ɓarana yi u da, “Avu ko uwonvo u Kashila̱ va pana an gba̱ tsunu a kiɗa̱ga tsu ugana u ukpa̱ wa? ");
INSERT INTO kdlNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","A̱tsu tani dere ɗa tsa wusha katsupi ka manyan ma tsunu, shegai vuma u na ko ili i cingi i te u yan wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","U danai, “Yesu, kotsu vu ciɓa na̱ mpa aꞌayin a ɗa baci vu uwai a tsugono tsu vunu.” ");
INSERT INTO kdlNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu tonuko yi, “N tonuko vu, ko ara va̱ ta̱ kaɓolo na̱ mpa a asu u uwunvugusa a zuba.” ");
INSERT INTO kdlNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","An kaara ka rawai a kaci, aku uyamba vi gba̱ u likpa̱mgba̱na̱i n karimbi hal ubana ulapa u uwule u tatsu. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Kaara ka na̱ka̱ kpam katyashi wa. Aku kunya ka a ba̱ra̱kpa̱i a Kuwa ku Kashila̱ ku pecemgbenei kure. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu ꞌya̱nga̱sa̱i kala̱ga̱tsu n ucira u danai, “Tata, a akere a vunu a ɗa ma na̱ka̱ kulu ku va̱.” An u danai nala, aku u uma u ne u wuta̱i. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","An katigi ka wenei ili iꞌya i gita̱i u cikpalai Kashila̱, u da, “Vuma u na, mayun ili i birika yi wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kakuma̱ ka ama ka ka banai aka̱lu a wenei ili iꞌya i gita̱i, a lazai n a lapi akamba a le adama a unamgbi u asuvu. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Shegai gba̱ ama ɗa a reve yi, kaɓolo n aka a ɗa a gita̱ yi utono tun a Galili, a shamgbai a mɓa̱ri aꞌa̱ri a uwundya ukuna u nala vi. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Vuma roku uza ɗa wa̱ri a asuvu a Asheshi a Pige, kala ka ne ka Isuhu vuma u Arimatiya u uyamba u Yahuda, vuma u maci ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","U wushuku n tyoku ɗa a sheshei n iꞌya a yain wa. Shegai utuwa̱ u tsugono tsu Kashila̱ u ɗa wa vana. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Pini nala, u banai ara Bilatu u foloi a na̱ka̱ yi ikyamba i Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","U cipuka̱ yi u pala̱sa yi n aminya a pun u zuwa yi a kasaun ka a shei a katali, a asu u ɗa bawu kotsu a vakunki uza. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Kain ka nala ki Kain ka Afoɓi ka, kpaci Ashibi a yan ɗe evu n uyan. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Aka a ɗa a wuta̱i a Galili kaɓolo n Yesu, a tonoi Isuhu kucina̱. A wenei kasaun ki n tyoku ɗa a zuwai ikyamba i ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Aku a gonoi a kuwa a ba a foɓusoi ucanga u awanli n u magula̱ni n manivi. Aku a wunvugai kain ka Ashibi ki tyoku ɗa Mele ma danai a yain. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kain ka kagita̱ ka aꞌayin a shindere; wata, kain ka Aladi n kpasani, aka a banai a asu u kasaun vi n ucanga u magula̱ni u ɗa a foɓusoi. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","A cinai a gindala̱kpa ɗe katali ka kasaun ki, ");
INSERT INTO kdlNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","shegai an a uwai a wene ikyamba i Yesu Asheku wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Aꞌa̱ri a uyan majiyan ma ukuna mi, kute‑kute ama a re uꞌuki n aminya a ɗa ka laɗa a shamgbai evu n ele. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Adama a uwonvo, aka yi a varai aꞌaci a le, shegai ama yi a tonuko le, “Ndya i zuwai ya bolo uza u uma a asuvu a akushe? ");
INSERT INTO kdlNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Wa̱ pini na wa; u ꞌya̱nga̱ ɗe! Ciɓai ili iꞌya u tonuko ɗa̱, aꞌayin a ɗa wa̱ri kaɓolo n a̱ɗa̱ a Galili. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘U ka̱na̱ ta̱ a neke Maku ma Vuma a akere a aza a unyushi u cingi, a wandamgbana yi, aku u ꞌya̱nga̱ a kain ka tatsu.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Aku a ciɓai n kadyanshi ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","An a wuta̱i a kasaun ki a gonoi a kuwa, a tonukoi atoni kupa n u te n ama ɗa a buwai gba̱ ukuna vi. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","(Meri Magadaliya n Yuwana n Meri mma u Yakubu n aka a roku a ɗa aꞌa̱ri kaɓolo n ele, alya a tonukoi atoni yi ukuna u na vi.) ");
INSERT INTO kdlNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Shegai a wushuku n ukuna vi wa, a gonukoi u ɗa yavu ukuna u gbani u ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Bituru ꞌya̱nga̱i u sumai ubana a kasaun ki, u kelikei u weɓelei, aku u wenei kunya ka a pala̱ka yi vi koshi. Aku u gonoi a kuwa wa̱ri uyan majiyan ma ukuna vi. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kain ka nala ki, ama a re a asuvu a atoni a Yesu, a ka bana a une u roku u ɗa a ka isa̱ Imawu. Mɓa̱ri n ne n ubana a Urishelima, evu na̱ nwalu m ulapa u uwule u re n ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Aꞌa̱ri a kadyanshi ka ili iꞌya i gita̱i vi. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ele pini a kadyanshi ki n a yawunsi utyoku u le, tyoku ɗa ukuna vi u gita̱i, aku Yesu n kaci ka ne u raɓa le, a lazai kaɓolo. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Shegai aꞌeshi a le a kukpa̱ a ka reve yi wa. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu wece le, “Ukuna u iyen u ɗa iꞌa̱ri a udansa an ya wala vi?” A shamgbusai, n a ɓa̱li asuvu n katsuma̱ ka̱ lima̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Uza ɗa a ka isa̱ Kiliyoba wushunku yi, “Avu kamoci ka a Urishelima? Va ciga vu dana vu reve iꞌya i gita̱i a asuvu a aꞌayin a na yi wa?” ");
INSERT INTO kdlNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","U wece le, “Ukuna u eni u ɗa la vi?” A tonuko yi, “Ukuna u Yesu uza u Nazara, matsumate ma tani ma ucira a asuvu a manyan ma ne n kadyanshi a kapala ka Kashila̱ n ama. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Aɗara̱kpi a pige na̱ ngono a neke yi, a kiɗa̱ga yi ugana u ukpa̱ a wandamgbana yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tsa̱ra̱ tsu zuwuka yi tani ta̱ aꞌeshi tsu da aya wa wutukpa̱ Isaraꞌila. Ara kain tatsu ɗa pa vi an ukuna u na vi u gita̱i. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ara aka a roku a asuvu a tsunu a yanka tsu ta̱ ukuna u majiyan, a banai pini a kasaun ki n usana u de. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","An bawu a cinai ikyamba i ne, a gonoi a tonuko tsu a wene ta̱ kuwene ku atsumate a zuba aza ɗa a tonuko le wa̱ ta̱ n uma. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Aza roku a tsunu a banai pini a kasaun ki, a ba a cinai tyoku ɗa aka yi a danai vi nala. Shegai eyi kaci ka ne a wene yi wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yesu tonuko le, “Eɗa̱ aza ɗa bawu iꞌa̱ri n ugboji. Aza ɗa atakasuvu a ɗe a ra̱zugba̱i bawu i wushuki gba̱ n ikorongi i ntsumate. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","U ka̱na̱ Kirisiti Kawauwi u pana ikyamba, aku u tsa̱ra̱ tsupige tsu ne wa?” ");
INSERT INTO kdlNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","U gita̱i n tagara̱da u Musa hal ubana a itagara̱da i Ntsumate, wa wutumkpusuka̱ le ukuna u ɗa wa̱ri a kaci ka ne a asuvu a itagara̱da yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","A yain evu n une u ɗa a ka bana vi. U yain yavu wa wura le. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","A ma̱tsa̱ yi a danai, “Tuwa̱ vu cipa̱ ara tsunu, kpaci kaara ka kotso ɗe, kayin kpam ka yan ɗe.” U wushuki u cipa̱i ara le. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","An wa̱ri a ulya ilikulya kaɓolo n ele, u bidyai burodi u cikpai Kashila̱, u jiba̱i u na̱ka̱ le. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Aꞌeshi a le a kukpa̱i aku a reve yi. Pini nala, u puwunka̱ le. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","A dansai utyoku u le, “Ipeli i tuwa̱ ta̱ a atakasuvu a tsunu aꞌayin a ɗa wa dansa n a̱tsu a ure vi, wa wutumkpusuka̱ tsu itagara̱da.” ");
INSERT INTO kdlNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kute‑kute a ꞌya̱nga̱i a gonoi a Urishelima a ba a cinai atoni kupa n u te vi a asu u te kaɓolo n aza ɗa aꞌa̱ri n ele. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Atoni yi a danai, “Mayun ɗa! Asheku a ꞌya̱nga̱ ta̱, hal gba̱m u wenike ta̱ kaci ka ne ara Bituru.” ");
INSERT INTO kdlNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ama a re yi dem a danai ili iꞌya i gita̱i n ele a ure, hal n tyoku ɗa a reve yi a asu u ɗa u jiba̱i burodi. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","An aꞌa̱ri pini a udansa ukuna u nala vi, kute‑kute Yesu tuwa̱i u shamgbai a mere ma le u dana̱sa le, “Ndishi n shinga ara ɗe.” ");
INSERT INTO kdlNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Shegai a giruwa̱i cika a panai uwonvo. A ka wundya kafofu ka a wenei. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","U tonuko le, “Ndya i zuwai i giruwa̱i? Ndya i zuwai ya yan mala̱la̱ a atakasuvu a ɗe? ");
INSERT INTO kdlNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Weɓelei akere a va̱ n aꞌene a va̱. Mpa n kaci ka va̱, sawa numu i pana. Kafofu ka̱ n inyama ko atele tyoku ɗa i wenei ma̱ri n iꞌya wa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","An u danai nala, u wenike le akere n aꞌene a ne. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Shegai adama a maza̱nga̱ n majiyan, a fuɗa a wushuku gogo wa. U wece le, “Iꞌa̱ pini na n ilikulya?” ");
INSERT INTO kdlNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","A na̱ka̱ yi kaɓirisa ka kadan ka a zungi. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","U wushai ka u takumai a kapala ka le. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","U doki u tonuko le, “Kadyanshi ka va̱ ka pa vi ka n tonuko ɗa̱ aꞌayin a ɗa tsa̱ri kaɓolo, “U ka̱na̱ ta̱ a shaɗangu ili iꞌya iꞌa̱ri ukorongi a kaci ka va̱ a asuvu a itagara̱da i Mele ma Musa, n iꞌya i Ntsumate hal n Tagara̱da u Ishipa.” ");
INSERT INTO kdlNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Aku u kukpa̱i atakasuvu a le tsa̱ra̱ a reve itagara̱da yi. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","U tonuko le, “Nala wa̱ri ukorongi, u ka̱na̱ ta̱ Kirisiti Kawauwi u pana ikyamba, kain ka tatsu aku u ꞌya̱nga̱ a ukpa̱. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kpam a ka yan ta̱ kuɓari ku ukpatala n ku ucimbusa̱ u unyushi u cingi a asuvu a kala ka ne. A ka gita̱ ta̱ a Urishelima ubana a aletsu a ɗa a buwai. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Eɗa aza ɗa i wenei ili i nala yi, kpam i dana iꞌya. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ma sukunku ɗa̱ ta̱ Kulu Keri ka Tata u va̱ u yain kazuwamgbani n a̱ɗa̱. Shegai i vana ve a Urishelima, hal n sukunku ɗa̱ ka kpam ku shaɗangu ɗa̱ n ucira u ɗa wa wuta̱ a zuba.” ");
INSERT INTO kdlNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","U wuta̱i n ele ubana a kateshe, hal ubana evu n Batani. U ꞌya̱nga̱sa̱i akere a ne u zuwuka le una̱ u shinga. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Eyi pini a uzuwusuka le una̱ u shinga vi, aku u pecenei n ele a canga yi ubana a zuba. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","A lyaka yi kayala, a gonoi a Urishelima n katsuma̱ ka eri cika. ");
INSERT INTO kdlNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","A rongoi a ubansa a Kuwa ku Kashila̱ kain dem, n a cikpala̱si Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kahu a yain likimba, Udani wa̱ ta̱ pini. Wa̱ ta̱ kaɓolo n Kashila̱, kpam dem Kashila̱ ka. ");
INSERT INTO kdlNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","A kagita̱ wa̱ ta̱ kaɓolo n Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","U yan ta̱ ili iꞌya iꞌa̱ri pini gba̱, ili iꞌa̱ la iꞌya bawu u yain wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Aya kami ka uma, kpam uma u nala vi u tuko ta̱ ama katyashi. ");
INSERT INTO kdlNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Katyashi ki ka wakana ta̱ a asuvu a karimbi, kpam karimbi ki ka fuɗa ka cimbusa̱ ka wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Kashila̱ ka suku ta̱ vuma roku, uza ɗa a ka isa̱ Yahaya, n kadyanshi. ");
INSERT INTO kdlNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","U tuwa̱ ta̱ u tonuko ama ukuna u mayun u katyashi vi, tsa̱ra̱ ya dem u pityanangu adama a ili iꞌya u danai vi. ");
INSERT INTO kdlNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Aya katyashi ki wa, shegai u tuwa̱ ta̱ u tonuko ama ukuna u mayun u katyashi vi. ");
INSERT INTO kdlNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Aꞌayin a ɗa baci katyashi ka mayun ki ka tuwa̱i a likimba, ka na̱ka̱ ta̱ ama gba̱ katyashi. ");
INSERT INTO kdlNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Udani vi wa̱ri ta̱ a likimba, kpam Kashila̱ ka yan ta̱ manyan n eyi an u yain likimba, kpam gba̱ n nala ama a likimba a reve yi wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","U tuwa̱ ta̱ a uyamba u ne, shegai ama a ne a wusha yi wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ama roku a wusha yi ta̱, kpam a wushuki n eyi. Adama a nala u zuwa le a wokoi mmuku n Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Aꞌayin a ɗa isheku i le i matsa le a likimba, ilimaci i nala i zuwa le a woko mmuku n Kashila̱ wa. Kashila̱ ka ka zuwa le a wokoi mmuku n ne. ");
INSERT INTO kdlNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Udani vi u woko ta̱ vuma, kpam u rongoi n a̱tsu. Wa̱ ta̱ ushaɗangi n ukuna n shinga n u mayun. Tsu wene ta̱ tsupige tsu ne; wata, tsupige tsa u wushai vi, kpaci aya koshi Maku ma Tata. ");
INSERT INTO kdlNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yahaya dana ta̱ ukuna u mayun a kaci ka Udani vi, kpam u tonukoi ama, “Uza ɗa n yanka ɗa̱ kadyanshi a kaci ka ne aya gai na vi, ‘Uza roku ɗa pini wa tuwa̱ a kucina̱ ku va̱, u la mu ta̱ tsupige, kpaci wa̱ ta̱ pini kahu mpa.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Adama a nala, uciga u ɗa wa ciga tsu cika ɗa u tsu yansa̱ka tsu ukuna u shinga,† kpam u tsu zuwusuka tsu ta̱ una̱ u shinga maco. ");
INSERT INTO kdlNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Musa ɗa tukoi ama Mele, Yesu Kawauwi kpam u tukoi ama ukuna u shinga n u mayun. ");
INSERT INTO kdlNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kotsu uza wa̱ la u wenei Kashila̱ wa. Shegai Maku mi ma zuwa ta̱ ama a revei tyoku ɗa Kashila̱ ka̱ri, kpaci aya koshi Maku ma ma̱ri ili i te n Kashila̱ ki, kpam wa̱ri evu n Tata. ");
INSERT INTO kdlNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Azapige a aza a Yahuda a Urishelima a suki aɗara̱kpi n aza a Levi ubana ara Yahaya a weci yi ko ya wa̱ri. ");
INSERT INTO kdlNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yahaya kpa̱ɗa̱ le uwushunku wa, shegai u dansai n ele karara, “Mpa Kawauwi ki wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Aku a wece yi, “Aɗa baci Kawauwi ki wa, aɗa yai? Aɗa Iliya vi?” U wushunku le, “Aꞌa, mpa wa.” A doku a wece yi, “Avu Matsumate ma a ɗanga̱sai vi ma?” U wushuki, “Aꞌa, mpa wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Aku a doku a wece yi, “Aɗa yai? Wushunku tsu tyoku ɗa tsa ba tsa tonuko aza ɗa a suku tsu. Ya vu bidyai kaci ka vunu?” ");
INSERT INTO kdlNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yahaya wushunku le n kadyanshi ka Ishaya matsumate: “Mpa kala̱ga̱tsu ka ka sala̱sa a kakamba, n ka dansi, ‘Lapulai ure adama a Asheku a ɗa a ka tuwa̱!’ ” ");
INSERT INTO kdlNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Afarishi a ɗa a suki atsumate yi. ");
INSERT INTO kdlNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","A wece yi, “Aɗa baci Kawauwi, ko Iliya, ko Matsumate ma a ɗanga̱sai vi wa, niɗa va lyuɓugusu ama naha?” ");
INSERT INTO kdlNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yahaya wushunku le, “Mpa n mini ma ma lyuɓugusu, shegai n gogo‑na naha uza roku ɗa pini a asuvu a kakuma̱ ka ama uza ɗa bawu i revei. ");
INSERT INTO kdlNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Aya uza ɗa wa tuwa̱ a kucina̱ ku va̱. Mpa n ra̱tsa n surukpa isirikatsu i akpata a ne wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yahaya wa lyuɓugusu ama a ilyuci i Batani, kasana n Aga̱ta̱ a Urudu nte ili i na yi i gita̱i pini gba̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","An kain ka wansai, Yahaya wenei Yesu, an wa gawunsa n eyi, aku u tonukoi ama, “Maku ma Kondom ma Kashila̱† ka yankai manyan tsa̱ra̱ u cimbusuka̱ ama a likimba unyushi u cingi u le ma na. ");
INSERT INTO kdlNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Aya gai ma dansa̱ka an n danai, ‘Uza roku ɗa pini wa tuwa̱ a kucina̱ ku va̱, u la mu ta̱ tsupige, kpaci wa̱ ta̱ pini kahu mpa.’ ");
INSERT INTO kdlNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ma̱ri n reve an aya wa, shegai ma̱ri ulyuɓugusu n mini tsa̱ra̱ n zuwa aza a Yahuda a reve ko aya yai.” ");
INSERT INTO kdlNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Aku Yahaya danai, “N wene ta̱ Kulu Keri ku wuta̱i a zuba ku cipa̱i ara ne yavu kaɗya ku woko yi pini. ");
INSERT INTO kdlNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ma̱ri n reve an aya wa, shegai an Kashila̱ ka suku mu n lyuɓugu ama n mini, ɗa u tonuko mu, ‘Vu wene baci Kulu Keri ku cipa̱i ara uza roku aku ku woko yi pini, vuma u nala vi aya ya vana vi. Aya wa lyuɓugu ama n Kulu Keri.’ ");
INSERT INTO kdlNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","N wene ta̱ ili i nala yi i gita̱i n Yesu. Adama a nala, n tonuko ɗa̱ ukuna u mayun, aya Maku ma Kashila̱ mi.” ");
INSERT INTO kdlNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","An kain ka wansai, Yahaya pini n u lyuɓugusi ama kaɓolo n ama a re a asuvu a atoni a ne, ");
INSERT INTO kdlNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","aku u wenei Yesu wa wala, u danai, “Maku ma Kondom ma Kashila̱ ma gai na vi!” ");
INSERT INTO kdlNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","An atoni a re yi a panai Yahaya danai nala, a tonoi Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","An Yesu kpatalai u wenei a ka tono yi, u wece le, “Ndya ya bolo?” Aku a wushuki, “Rabbi,† nte va rongo?” (“Rabbi;” wata, “Kawenishiki.”) ");
INSERT INTO kdlNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","U wushunku le, “Tuwa̱i i wene.” (Aꞌayin a nala yi evu n ulapa u uwule u nishi u ɗa u kaara.) Aku a lazai n eyi a wenei asu vi, a rongoi pini hal kaara ka rukpa̱i. ");
INSERT INTO kdlNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Uza te a asuvu a atoni a re yi aya Andurawu utoku u Simo Bituru uza ɗa aꞌa̱ri tata u te. ");
INSERT INTO kdlNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ili iꞌya Andurawu gita̱i uyan iꞌya u zamai utoku u ne vi u tonuko yi, “Tsu wene ta̱ Kawauwi ka a yanka tsu kazuwamgbani ki!” (N Tsiyahuda a yanka ta̱ manyan n “Kawauwi” kpam ili iꞌya i te n udani u “Kirisiti” n Tsiheline.) ");
INSERT INTO kdlNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Aku Andurawu bidyai utoku u ne vi ubana ara Yesu. Yesu kondono yi u danai, “Aɗa Simo, kala ka tata u vunu ka Yahaya. A ka isa̱ vu ta̱ Kefa.” (“Kefa” ili i te iꞌya n “Bituru.”) ");
INSERT INTO kdlNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","An kain ka wansai, Yesu yawunsai u bana a Galili. Aku u ba u cinai Filibu, u tonuko yi, “Tono mu.” ");
INSERT INTO kdlNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Besaida ɗa ilyuci i Filibu, n ilyuci i Andurawu n Bituru. ");
INSERT INTO kdlNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filibu ba u boloi Nataniya, aku u tonuko yi, “Tsu wene ta̱ vuma ɗa Musa korongi ukuna u ne a Mele mi. Kpam dem ntsumate n korongu ta̱ ukuna u ne. Aya Yesu maku ma Isuhu, kpam ilyuci i ne iꞌya Nazara.” ");
INSERT INTO kdlNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Shegai Nataniya wece yi, “Ili i shinga iꞌa̱ la ya wuta̱ a Nazara?” Filibu wushunku yi, “Tuwa̱ vu wene.” ");
INSERT INTO kdlNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","An Yesu wenei Nataniya wa raɓa evu n eyi, aku u danai, “Eyi na matsikaya ma aza a Yahuda ma mayun ma. Uza maryafuka ɗa wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniya wece yi, “Niɗa vu yansai vu reve mu?” U wushunku yi, “Kahu Filibu isa̱ vu, n wene vu ta̱ a kulu ku maɗanga ma kapopi.” ");
INSERT INTO kdlNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Aku Nataniya tonuko yi, “Kawenishiki, avu Maku ma Kashila̱ ma. Aɗa Magono ma aza a Yahuda.” ");
INSERT INTO kdlNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu danai, “Wushuku ɗa vu wushuki na̱ mpa an n tonuko vu n wene vu ta̱ a kulu ku maɗanga ma kapopi? Va wene ta̱ ili iꞌya i lai i naha ugbonguro.” ");
INSERT INTO kdlNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","U tonuko le kpam, “Mayun n tonuko ɗa̱, Ya wene ta̱ zuba u kukpa̱ kpam atsumate a zuba a Kashila̱ n a yuwi n a cipi a zuba u Maku ma Vuma.” ");
INSERT INTO kdlNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Pini nala, a kain ka tatsu, a ka yan abiki a iyolo a ilyuci i Kanan u Galili. Mma u Yesu wa̱ ta̱ dem pini a asu vi. ");
INSERT INTO kdlNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","A libana ta̱ dem Yesu n atoni a ne. ");
INSERT INTO kdlNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","An mini ma cinwi mi ma kotsoi, aku mma u Yesu u tonuko yi, “Mini ma cinwi mi ma kotso ɗe.” ");
INSERT INTO kdlNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu wushunku yi, “Mma, ndya i zuwai va damgbara̱sa mu naha? Kotsu aꞌayin a va̱ a yan wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mma u ne u tonukoi agbashi yi, “Yanyi gba̱ ili iꞌya u tonuko ɗa̱ i yain.” ");
INSERT INTO kdlNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Caupa, Kashila̱ ka na̱ka̱ ta̱ aza a Yahuda mele tyoku ɗa a ka yansa kuza̱. Adama a nala, aza a kuwa yi aꞌa̱ ta̱ na̱ mmuru n mini n teli n ɗa a shei a atali. Maru dem ma gbonguro ta̱ hal ma fuɗa ta̱ ma bidya evu na̱ nlanda n mini n teli. ");
INSERT INTO kdlNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu tonukoi agbashi yi, “Shaɗangi mmuru mi n mini.” Aku a shaɗangi n ɗa tipi-tipi. ");
INSERT INTO kdlNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","U tonuko le, “Gogo‑na kenei i banka uzapige u abiki vi.” Aku a yain tyoku ɗa u tonuko le a yain. ");
INSERT INTO kdlNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","An uzapige vi u peɗei, aku u wenei ma gono ɗe mini ma cinwi. U reve tani asu u ɗa mini ma cinwi mi ma wuta̱i wa, shegai agbashi a ɗa a tukoi ma vi a reve ta̱. Aku u isa̱i valisavu vi, ");
INSERT INTO kdlNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","u tonuko yi, “Mini ma cinwi ma shinga ma a tsu gita̱ a tuko, aꞌayin a ɗa baci ama a sosoi, aku a tuko ma bawu ma cinai ma kagita̱ kayanyan. Shegai avu vu sokongu ta̱ mini ma cinwi ma shinga mi she gogo‑na!” ");
INSERT INTO kdlNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","A Kanan u Galili ɗa Yesu yain ukunosavu u kagita̱ u ne. Nte ɗa u wenikei pini tsupige tsu ne, kpam atoni a ne a wushuki n eyi. ");
INSERT INTO kdlNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","An nala wurai, aku u lazai ubana a ilyuci i Kafarnahum kaɓolo na̱ mma u ne, n atoku a ne, n atoni a ne. A rongo ta̱ pini aꞌayin kenu. ");
INSERT INTO kdlNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yesu banai a Urishelima, kpaci aꞌayin a Abiki a Upasamgbana a yan ɗe evu. ");
INSERT INTO kdlNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","An u uwai a Kuwa ku Kashila̱ ki, aku u cinai aza a udengishe anaka, na̱ nlala, na̱ ntambara. U wenei aza ɗa a tsu dusukusu a asu u iteburu i le n a savaɗa̱si ikebe icun kau‑kau. ");
INSERT INTO kdlNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","U zamai aꞌawun u cai kaban u yain kajaɓu. U lokoi ama yi pini a Kuwa ku Kashila̱ ki, kaɓolo na̱ nlala n le n anaka a le dem. U mutsukpusa̱i iteburu i aza ɗa a ka savaɗa̱sa ikebe u wacinsai ikebe yi. ");
INSERT INTO kdlNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","U tonukoi aza ɗa a ka dengishe ntambara, “Takpai ili i na yi pini na! Kotsu i gonuko kuwa ku Tata u va̱ kuden wa!” ");
INSERT INTO kdlNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","An nala gita̱i, aku atoni yi a ciɓai n ili iꞌya a korongi caupa a asuvu a Tagara̱da u Kashila̱: “Adama a uciga u ɗa ma ciga kuwa ku vunu cika, u ɗa wa zuwa mu n kuwa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Azapige a aza a Yahuda a wecei Yesu, “Ukunosavu u eni u ɗa va yan tsa̱ra̱ u wenike tsu tyoku ɗa vu tsa̱ra̱i ucira u uyan ili i na yi?” ");
INSERT INTO kdlNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","U wushunku le, “Wa̱sa̱i kuwa ku Kashila̱ ku na ki, ma ma ta̱ ka kpam a asuvu a aꞌayin a tatsu.” ");
INSERT INTO kdlNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","A wushunku yi, “An a gita̱i kuma ku Kuwa ku Kashila̱ ku na ki, a yan ta̱ ayen amangare n a teli kahu a kotso ka! Niɗa va fuɗa va ma ka a asuvu a aꞌayin a tatsu?” ");
INSERT INTO kdlNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Shegai an Yesu danai “kuwa ku Kashila̱ ki,” ikyamba i ne iꞌya wa dansa̱ka. ");
INSERT INTO kdlNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Aꞌayin a ɗa u tuwa̱i u ꞌya̱nga̱i a ukpa̱, ɗa atoni yi a ciɓai u tonuko le ta̱ ukuna vi. Aku a wushuki gba̱ ili iꞌya Yesu dansai n iꞌya a korongusi a Tagara̱da u Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","An Yesu wa̱ri a Urishelima adama a Abiki a Upasamgbana yi, ama ushani a wushuku ta̱ n eyi kpaci a wene ta̱ ikunesavu iꞌya u yansai. ");
INSERT INTO kdlNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Yesu reve ta̱ tyoku ɗa atakasuvu a ama aꞌa̱ri, adama a nala u wushuku u a̱sa̱nka̱ le kaci wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Adama a ɗa u revei atakasuvu a ama gba̱, she kpam uza u tonuko yi ukuna u roku a kaci ka uza wa, kpaci eyi n kaci ka ne u reve ta̱ ili iꞌya iꞌa̱ri a asuvu a vuma. ");
INSERT INTO kdlNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","A asuvu a Asheshi a Pige yi, uza roku ɗa pini uza ɗa a ka isa̱ Nikodimu, Kafarishi ka. ");
INSERT INTO kdlNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Kain ka te n kayin, u banai ara Yesu, u danai, “Uzapige, tsu reve ta̱ Kashila̱ ka ka suku vu ara tsunu vu wenishike tsu. Kpaci ko uza wa fuɗa wa yan ikunesavu tyoku ɗa va yansa wa, shegai Kashila̱ ka̱ baci n eyi.” ");
INSERT INTO kdlNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu wushuki, “Mayun n tonuko vu, uza wa̱ la wa uwa a tsugono tsu Kashila̱ wa, she a doku a matsa yi ilimaci i ire.” ");
INSERT INTO kdlNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimu wece yi, “Vuma u kutsa baci, niɗa wa̱ kpam a ka doku a matsa yi? Wa doku kpam wa uwa a katsuma̱ ka mma u ne wa. Niɗa a ka yan a matsa vuma ilimaci i ire?” ");
INSERT INTO kdlNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Shegai u wushunku yi, “Mayun n tonuko vu, uza wa̱ la wa uwa a tsugono tsu Kashila̱ wa, she a matsa yi ilimaci i ire n mini n Kulu Keri. ");
INSERT INTO kdlNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Isheku i vuma alya a tsu zuwa ikyamba i vuma i tsa̱ra̱ uma, shegai Kulu Keri ku Kashila̱ ka ku tsu zuwa kulu ku vuma ku tsa̱ra̱ uma. ");
INSERT INTO kdlNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kotsu vu yain majiyan an n tonuko vu, ‘She a doku a matsa ɗa̱ ilimaci i ire wa.’ ");
INSERT INTO kdlNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Uwule u tsu lapana ta̱ a asu u ɗa dem wa ciga, kpam vu tsu pana ta̱ mawura̱ ma ne, shegai vu tsu reve asu u ɗa u gita̱i ko kpam a asu u ɗa wa bana wa. Nala dem wa̱ri Kulu Keri ku matsa baci vuma.” ");
INSERT INTO kdlNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimu wece yi, “Niɗa wa yan u gita̱ nala?” ");
INSERT INTO kdlNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","U wushunku yi, “Avu kawenishiki ka ka pige a asuvu a Isaraꞌila. Niɗa vu yansai vu kpa̱ɗa̱i ureve ukuna u na? ");
INSERT INTO kdlNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mayun n tonuko vu, ukuna u ɗa tsu revei u ɗa tsa dansa, kpam tsu yain kadyanshi ka ili iꞌya tsu wenei. Shegai i wushuku n ili iꞌya tsu tonuko ɗa̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","N tonuko ɗa̱ ta̱ ukuna u likimba naha, shegai i wushuku n kadyanshi ka va̱ wa. Adama a nala, ya fuɗa ya wushuku na̱ mpa n tonuko ɗa̱ baci ili iꞌya iꞌa̱ri a zuba wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Mpa Maku ma Vuma, mpa koshi n wuta̱i a zuba n tuwa̱i a likimba, kpam ma doku ma gono a zuba. ");
INSERT INTO kdlNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Tyoku ɗa Musa saki kali ka urim u shili a kakamba, nala dem a ka saku Maku ma Vuma. ");
INSERT INTO kdlNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Adama a nala, uza ɗa baci dem u wushuki n Maku ma Vuma, wa tsa̱ra̱ ta̱ uma u ɗa bawu wa kotso. ");
INSERT INTO kdlNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Tyoku ɗa Kashila̱ ka cigai ama a likimba cika u ɗa na: u neke ta̱ Maku ma te ma ne koshi tsa̱ra̱ uza ɗa baci dem u wushuki n eyi kotsu u kuwa̱ wa, shegai u tsa̱ra̱ uma u ɗa bawu wa̱ri n utyoku. ");
INSERT INTO kdlNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kashila̱ ka suku Maku ma ne a likimba tsa̱ra̱ u kiɗa̱ga ama ugana u ukpa̱ wa. Shegai u suku yi ta̱ tsa̱ra̱ u wauwa le. ");
INSERT INTO kdlNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","A ka kiɗa̱ga aza ɗa a wushuki n Maku mi ugana wa. Shegai a kiɗa̱ga ɗe aza ɗa bawu a wushuki vi ugana, kpaci a wushuku n Maku ma te ma Kashila̱ mi wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ili iꞌya i zuwai a ka kiɗa̱ga le ugana iꞌya na: Katyashi ka tuwa̱ ta̱ a likimba. Shegai a ciga katyashi ki wa, aku a gonoi a ka ciga karimbi, kpaci manyan ma cingi ma a ka yansa. ");
INSERT INTO kdlNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Aza ɗa a ka yansa ukuna u cingi a tsu ciga katyashi wa, kpam a ka tuwa̱ evu n ka wa, kpaci a ka ciga uza u wene manyan ma cingi ma a ka yansa wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Shegai aza ɗa a ka tono ure u mayun a ka tono ta̱ katyashi, ya dem wa wene ta̱ a ka yansa ili iꞌya Kashila̱ ka ciga le a yain.” ");
INSERT INTO kdlNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","An a yain aꞌayin kenu, Yesu n atoni a ne a banai uɓongu u Yahuda, a tsa̱ ta̱ a ɓa̱ra̱kpa̱i pini kenu n a lyuɓugusi ama. ");
INSERT INTO kdlNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Aꞌayin a nala yi kotsu a banka Yahaya a kuwa ku aꞌali wa. Yahaya rongo ta̱ ulyuɓugusu ama a Ayino evu n Salima, kpaci asu vi mini ma pini ushani. Ama a rongo ta̱ ubansa ara ne cika tsa̱ra̱ u lyuɓugu le. ");
INSERT INTO kdlNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kananamgbani ka rukpa̱ ta̱ a mere ma atoni a Yahaya n uza u Yahuda u roku a kaci ka uwulukpe u ikyamba. ");
INSERT INTO kdlNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Aku a banai ara Yahaya, a danai, “Kawenishiki, vuma ɗa vu cinai a kapashi ka Aga̱ta̱ a Urudu vi, uza ɗa vu danai Kawauwi ka vi, aya dem pini wa lyuɓugusu ama. Kpam ya dem nte wa bansa ɗe, n u ɗa a ka tuwa̱ ara tsunu.” ");
INSERT INTO kdlNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Aku Yahaya wushunku le, “Ili iꞌya Kashila̱ ka na̱ka̱i vuma iꞌya koshi wa tsa̱ra̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","I pana̱ka mu ta̱ an n danai, ‘Mpa Kawauwi ki wa, shegai mpa Kashila̱ ka suki n tuwa̱ n lapula ure adama a ne.’ ");
INSERT INTO kdlNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ukasavu u tsu bana ta̱ a asu u ɗa vali u ne wa̱ri. Kaje ka valisavu ka tsu pana ta̱ kala̱ga̱tsu ka valisavu ki, u yain kpam maza̱nga̱ kaɓolo n eyi. Mpa kaje ka valisavu ka, kpam ma pana ta̱ kayanyan cika an u lyai kaci ka ukuna. ");
INSERT INTO kdlNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","U ka̱na̱ ta̱ u lyai kapala n uwoko n tsupige, mpa kpam n woko uza u kenu.” ");
INSERT INTO kdlNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yahaya doki u danai, “Uza ɗa u wuta̱i a zuba u la ta̱ ama gba̱ tsupige. Uza ɗa u wuta̱i a likimba uza u likimba u ɗa, kpam ukuna u likimba u ɗa koshi u tsu rongo udansa. Shegai uza ɗa u wuta̱i a zuba vi u la ta̱ ya dem tsupige. ");
INSERT INTO kdlNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","U tsu yan ta̱ kadyanshi a kaci ka ili iꞌya u wenei kpam u panai, shegai ko uza u tsu wushuku n iꞌya wa tono wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Uza ɗa baci dem u wushuki n iꞌya u danai, u wenike ta̱ an u wushuku ta̱ la vi n ili iꞌya Kashila̱ ka danai mayun ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Uza ɗa Kashila̱ ka suki vi, ukuna u Kashila̱ u ɗa u tsu dansa, kpaci Kashila̱ ka na̱ka̱ yi ta̱ ucira u Kulu Keri gbende. ");
INSERT INTO kdlNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tata vi u ciga ta̱ Maku mi cika, adama a nala u na̱ka̱ yi ta̱ ucira a kaci ka ili gba̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Aza ɗa a wushuki n Maku mi, aꞌa̱ ta̱ n uma u ɗa bawu wa kotso. Shegai aza ɗa bawu a ka pana̱ka Maku mi, a ka tsa̱ra̱ uma wa. Asuvu a upan a Kashila̱ aꞌa̱ ta̱ a kaci ka le maco.” ");
INSERT INTO kdlNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Afarishi a pana ta̱ alabari an Yesu wa tsa̱ra̱sa̱ atoni ushani hal a lai atoni a Yahaya kakuma̱, kpam n u lyuɓugusi le. ");
INSERT INTO kdlNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Ko an u wokoi aya n kaci ka ne wa lyuɓugusu ama yi wa, atoni a ne a ɗa.) ");
INSERT INTO kdlNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","An u revei Afarishi a pana ta̱ ukuna vi, aku u lazai u a̱sa̱ka̱i Yahuda ugono a Galili. ");
INSERT INTO kdlNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ure vi u pasamgbana ta̱ a uyamba u Samariya. ");
INSERT INTO kdlNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Eyi pini a nwalu a Samariya vi, aku u rawai a ilyuci i roku iꞌya a ka isa̱ Saika, asu vi u ɓa̱ra̱kpa̱ n kashina ka Yakubu na̱ka̱i maku ma ne Isuhu wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ilyukoi i Yakubu iꞌa̱ ta̱ pini. N kaara a kaci, an Yesu wowoi cika, kpaci u yan ta̱ nwalu ma mɓa̱ri, aku u dusuki a ikengi i ilyukoi yi. ");
INSERT INTO kdlNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Aꞌayin a ɗa atoni a ne a banai a asuvu a ilyuci tsa̱ra̱ a tsila ilikulya, aku uka u aza a Samariya u roku u tuwa̱i ukene mini. Yesu folo yi, “Ne mu mini n soi.” ");
INSERT INTO kdlNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Uka vi u yan ta̱ majiyan cika, kpaci aza a Yahuda a ꞌyuwan ta̱ ili iꞌya ya gawan le n aza a Samariya. Aku u tonuko yi, “Avu uza u aza a Yahuda ɗa, mpa kpam uka u aza a Samariya ɗa ma̱ri. Ndya i zuwai va folo mu mini?” ");
INSERT INTO kdlNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","U wushunku yi, “Vu reve ili iꞌya Kashila̱ ka ciga ka na̱ka̱ vu wa, kpam vu reve uza ɗa wa̱ri vu a ufolo mini ma uso mi wa. A da baci va̱ri vu revei, va̱ri va folo mu ta̱ mini ma ma na̱ka̱ uma.” ");
INSERT INTO kdlNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Uka vi u danai, “Uzapige, va̱ gba̱m n ili i ukenike mini wa, kpam ilyukoi yi iꞌa̱ ta̱ lyungu-lyungu. Nte va tsa̱ra̱ mini ma ma na̱ka̱ uma vi? ");
INSERT INTO kdlNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Akaya a tsunu Yakubu ɗa ga̱vuga̱ tsu ilyukoi i na yi, eyi n aza a kuwa a ne na̱ nnama n kuwa n le a soso ta̱ pini mini. Avu la Yakubu tsupige ɗa?” ");
INSERT INTO kdlNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","U wushuki, “Uza ɗa baci dem u soi mini ma na mi, wa doku ta̱ wa pana kakuli. ");
INSERT INTO kdlNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Shegai aza ɗa a ka so mini ma ma na̱ka̱ le vi, a ka doku a ka pana kakuli wa. Mini ma ma na̱ka̱ le vi ma woko ta̱ tyoku u keshi ka mini a asuvu a le. Mini ma nala mi ma na̱ka̱ le ta̱ uma u ɗa bawu wa kotso.” ");
INSERT INTO kdlNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Uka vi u tonuko yi, “Uzapige, ne mu mini ma nala mi n soi, tsa̱ra̱ n doku n pana kakuli wa. Kotsu n doku n gono a asu u ilyukoi i na yi ukene u mini wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","U tonuko yi, “Wala ba vu isa̱ vali u vunu i tuwa̱ kaɓolo n eyi.” ");
INSERT INTO kdlNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Uka vi u wushuki, “Ma̱ri n vali wa.” U wushunku yi, “Mayun ɗa an vu danai va̱ri n vali wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Vu bansa ta̱ aꞌali a tawun iyolo, kpam uza ɗa va̱ri kaɓolo n eyi gogo‑na vi, vu yan iyolo n eyi wa. Ukuna u ɗa vu tonuko mu vi mayun ɗa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Uka vi u danai, “Uzapige, n reve ta̱ avu matsumate ma. ");
INSERT INTO kdlNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Isheku i va̱ i gbashika ta̱ Kashila̱ a Masasa ma Gerizim, shegai eɗa̱ aza a Yahuda i da Urishelima ɗa koshi asu u ulya kayala.” ");
INSERT INTO kdlNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","U tonuko yi, “Uka, wushuku na̱ mpa, aꞌayin a ka tuwa̱ ta̱ a ɗa bawu ama a ka lyaka Tata kayala ko a masasa ko kpam a Urishelima. ");
INSERT INTO kdlNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Eɗa̱ aza a Samariya kenu ɗa i revei a kaci ka uza ɗa ya lyaka kayala. A̱tsu kpam aza a Yahuda tsu reve ta̱ ukuna ushani a uza ɗa tsa lyaka kayala, kpaci Kashila̱ ka sukunku ta̱ ama iwauwi a kukere ku aza a Yahuda. ");
INSERT INTO kdlNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Aꞌayin a ka tuwa̱ ta̱, mayun gba̱m a ɗa a rawa ɗe, a ɗa Kulu Keri ka zuwa ama a lyaka Tata kayala tyoku ɗa wa̱ri mayun. Tyoku ɗa Tata wa ciga ama a lyaka yi kayala ɗa la vi. ");
INSERT INTO kdlNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Kashila̱ kulu ka, kpam u ka̱na̱ ta̱ ama a lyaka yi kayala a asuvu a kulu ku le tsa̱ra̱ a lyaka yi kayala dere.” ");
INSERT INTO kdlNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Uka vi u danai, “N reve ta̱ Kawauwi ka tuwa̱ ta̱, aya a tsu isa̱ Kirisiti. Aꞌayin a ɗa baci u tuwa̱i, wa toɗugbusuko tsu ta̱ ili dem.” ");
INSERT INTO kdlNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","U wushunku yi, “Mpa uza ɗa gai ma dansa n avu na vi, mpa vuma u nala vi.” ");
INSERT INTO kdlNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Kute‑kute, atoni a Yesu yi a gonoi. A yan ta̱ majiyan cika an a cina yi wa dansa n uka. Shegai ko uza u wece uka vi, “Ndya va ciga?” wa, ko kpam a weci Yesu, “Niɗa va dansa n eyi?” wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Uka vi u a̱sa̱ka̱i malanda ma mini ma ne, u lazai a ubana a ilyuci yi u tonukoi ama ukuna vi, u danai, ");
INSERT INTO kdlNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Tuwa̱i i wene vuma ɗa u tonuko mu gba̱ ili iꞌya n yansai! Ko wa yan aya Kawauwi ki?” ");
INSERT INTO kdlNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Aku a wuta̱i a ilyuci yi a ba a cinai Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","An aꞌa̱ri pini uyan nala, aku atoni a ne a tonuko yi, “Kawenishiki, yan ahankuri tsa̱ vu lyai ili i roku.” ");
INSERT INTO kdlNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Shegai u tonuko le, “Ma̱ ta̱ n ilikulya iꞌya bawu i revei n iꞌya.” ");
INSERT INTO kdlNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Aku atoni yi a ka wecemgbene n a dansi, “Uza roku u tuko yi ilikulya ɗa?” ");
INSERT INTO kdlNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","U wushunku le, “Ilikulya i va̱ iꞌya n yain manyan ma uza ɗa u suku mu wa ciga mu n yain, kpam n kotso ma. ");
INSERT INTO kdlNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Iꞌa̱ ta̱ n tsizagaɗi tsa tsu danai, ‘Iwoto i nishi i wura baci, ɗa ama a tsu kapa ilya.’ Shegai n tonuko ɗa̱ weɓelei mai, ya wene ta̱ ilya i gewe ɗe ya ciga ukapa. ");
INSERT INTO kdlNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","N gogo‑na naha, uza ɗa wa kapa vi wa tsa̱ra̱sa̱ ɗe katsupi ka ne, kpam wa cira̱ngusu ɗe ili iꞌya u kapai vi adama a uma u ɗa bawu wa kotso. Uza ɗa u cei n uza ɗa u kapai vi a ka za̱nga̱na̱ ta̱ kaɓolo. ");
INSERT INTO kdlNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tsizagaɗi tsu na tsi mayun ɗa, ‘Uza u naha u cei, uza u niɗe kpam u kapai.’ ");
INSERT INTO kdlNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","N suku ɗa̱ ta̱ i kapi ilya iꞌya bawu i yain manyan ma le. Ama roku a ɗa a gita̱i manyan mi, aku eɗa̱ kpam i koruso ma.” ");
INSERT INTO kdlNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Aza a Samariya ushani a ilyuci yi a wushuku ta̱ n Yesu adama a ukuna u na u ɗa uka vi u tonuko le: “U tonuko mu ta̱ gba̱ ili iꞌya n yansai.” ");
INSERT INTO kdlNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","An aza a Samariya a tuwa̱i ara Yesu, a folo yi u cipa̱ ara le, aku u doki u dusuki pini aꞌayin a re. ");
INSERT INTO kdlNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Pini nala, aza roku ushani a doku a wushuki adama a ili iꞌya u danai. ");
INSERT INTO kdlNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","A tonukoi uka vi, “A kagita̱ tsu wushuku ta̱ n Yesu adama a ili iꞌya vu tonuko tsu, shegai gogo‑na tsu wushuku ta̱ adama a ɗa tsu pana̱ka yi n kaci ka tsunu. Tsu reve ta̱ vuma u na vi aya Kawauwi ka likimba.” ");
INSERT INTO kdlNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","An aꞌayin a re a wurai, aku Yesu lazai ubana a kaɓon ka Galili. ");
INSERT INTO kdlNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Wa̱ri u dana ta̱ caupa ama a tsu wushuku n matsumate a ilyuci i ne wa.) ");
INSERT INTO kdlNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","An u rawai a Galili, ama yi a ryabusa yi. Adama a ɗa a wene ta̱ gba̱ ili iꞌya u yansai ɗe aꞌayin a Abiki a Upasamgbana a Urishelima, kpaci aꞌa̱ ta̱ dem pini a asu vi. ");
INSERT INTO kdlNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesu pini a Galili, aku u gonoi a ilyuci i Kanan a asu u ɗa u gonukoi mini ma wokoi mini ma cinwi. A ilyuci i Kafarnahum, uzapige u roku ɗa pini uza ɗa maku ma ne ma̱ri n maɓa̱la̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","An u panai a da Yesu wuta̱ ta̱ a Yahuda u tuwa̱i a Galili, aku u banai ara ne u folo yi u tuwa̱ a Kafarnahum u ta̱na̱sa̱ maku ma ne, kpaci maku mi ma̱ ta̱ a una̱ u ukpa̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu wushunku yi, “Uza wa̱ la a asuvu a ɗe wa wushuku wa, she u wene iryoci n ikunesavu.” ");
INSERT INTO kdlNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Uzapige vi u danai, “Kawenishiki, tuwa̱ a kuwa ku va̱ kahu maku ma va̱ ma kuwa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","U wushuki, “Wala vu gono a kuwa. Maku ma vunu ma yan ta̱ uma.” Vuma vi u wushuki n ili iꞌya Yesu tonuko yi, aku u lazai ugono a kuwa. ");
INSERT INTO kdlNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Eyi pini a nwalu a ugono, aku u gawunsai n agbashi a ne a roku, a tonuko yi, “Maku ma vunu ma ta̱na̱ ɗe!” ");
INSERT INTO kdlNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","U wece le aꞌayin a ɗa maku mi ma ta̱na̱i. A wushunku yi, “Maɓa̱la̱ mi ma a̱sa̱ka̱ yi ta̱ nayain dere u ulapa u uwule u iyan u kaara.” ");
INSERT INTO kdlNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Aku tata vi u revei derere u aꞌayin a nala yi a ɗa Yesu danai, “Maku ma vunu ma yan ta̱ uma.” Pini nala, vuma vi n ama ɗa aꞌa̱ri a kuwa ku ne a wushuki n Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ukunosavu u ire u ɗa la vi u ɗa Yesu yain an u a̱sa̱ka̱i Yahuda u rawai a Galili. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","An nala wurai, Yesu lazai ubana a Urishelima a asu u abiki a aza a Yahuda. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","A Urishelima vi, kaɗa̱ka̱ ka mini ka pini evu n Utsutsu u Ncon u ɗa a ka isa̱ Betesida n Tsiꞌarama. A kyawan ta̱ ka n afalaka a tawun. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Aza a mɓa̱la̱ ushani a tsu vakusu ta̱ pini evu n mini mi. Aza roku arumba̱ a ɗa, aza roku awunu, n aza ɗa ili i soi. Aꞌa̱ri a uvana mini mi ma vura̱, ");
INSERT INTO kdlNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","kpaci gaawan katsumate ka zuba ka tuwa̱ ta̱ ka vura̱ ma. Uza ɗa baci u gita̱i pini uꞌuwa aꞌayin a ɗa mini mi ma vura̱i vi wa ta̱na̱ ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Vuma roku u ɗa pini nvain a asu vi, uza ɗa u yain ayen kamankupa n kulla̱ n maɓa̱la̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu wene yi nvain, aku u revei vuma vi u ɓa̱ra̱kpa̱ ta̱ nvain n maɓa̱la̱ mi. Aku u wece yi, “Va ciga vu ta̱na̱?” ");
INSERT INTO kdlNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Vuma vi u wushuki, “Uzapige, ma̱ n uza ɗa wa banka mu a mini mi wa, a vura̱ baci ma. Aꞌayin a ɗa baci ma raɓa evu n mini mi, aku uza roku u lasa mu.” ");
INSERT INTO kdlNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu tonuko yi, “ꞌYa̱nga̱ vu bidya kajiba ka vunu vu wala.” ");
INSERT INTO kdlNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Kute‑kute vuma vi u ta̱na̱i. U bidyai kajiba ka ne u gita̱i nwalu. N kain ka Ashibi ka ukuna vi u gita̱i. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","An azapige a aza a Yahuda a wenei vuma vi u cangai kajiba ka ne, aku a tonuko yi, “Kain ka Ashibi ka! Mele ma ɓishinka ta̱ a canga kajiba n kain ka Ashibi.” ");
INSERT INTO kdlNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","U wushunku le, “Vuma ɗa u ta̱na̱sa̱ mu vi aya u tonuko mu, ‘Bidya kajiba ka vunu vu wala.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","A wece yi, “Ya uza ɗa u tonuko vu vu yain nala vi?” ");
INSERT INTO kdlNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Shegai u fuɗa u reve uza ɗa u ta̱na̱sa̱ yi vi wa, kpaci ama ɗa pini ushani a asu vi kpam cina Yesu laza ɗe n kabini. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Aꞌa̱ri pini, aku Yesu cinai vuma vi a Kuwa ku Kashila̱, u tonuko yi, “Vu ta̱na̱ ɗe gogo‑na. A̱sa̱ka̱ uyansa unyushi u cingi kotsu ili iꞌya i lai i na i gita̱ n avu wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Aku vuma vi u lazai u banai u tonukoi azapige yi Yesu ɗa ta̱na̱sa̱ yi. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Adama a nala, azapige a aza a Yahuda a gita̱i uraga Yesu adama a ɗa u yain ili i nala n kain ka Ashibi. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu tonuko le, “Manyan ma Tata u va̱ u tsu rongo uyansa maco, nala dem mpa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Adama a nala, azapige yi a ma̱tsa̱i tsa̱ra̱ a wuna yi adama a ɗa u kpa̱ɗa̱i utono mele ma Ashibi. Hal gai an u korusoi u danai Kashila̱ ka Tata u ne, u ɗa u zuwa yi u wokoi una̱ u te n Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu danai, “Mayun n tonuko ɗa̱, Maku mi ma yan ukuna utyoku u ne wa. Ili iꞌya u wenei Tata u ne u yain iꞌya koshi u tsu yan. Ili iꞌya dem Tata vi u yain iꞌya Maku mi dem ma tsu yan. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tata vi u ciga ta̱ Maku mi, kpam u wenike yi ta̱ gba̱ ili iꞌya u tsu yansa. U tsu wenike yi ta̱ ili i pige i pige iꞌya i lai i na tsa̱ra̱ i yain majiyan gba̱ ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Maku mi ma tsu na̱ka̱ ta̱ aza ɗa u ɗanga̱sai uma tyoku ɗa Tata vi ꞌya̱nga̱sa̱ le a ukpa̱ u na̱ka̱ le kpam uma. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tata vi u tsu kiɗa̱ga uza ugana wa, shegai u zuwai Maku ma ne ma woko uza ɗa wa kiɗa̱ga ya dem ugana. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Tata vi u ciga ta̱ ama a na̱ka̱ Maku mi tsupige tyoku ɗa a tsu na̱ka̱ yi tsupige. Uza u ꞌyuwan baci una̱ka̱ Maku mi tsupige, u ꞌyuwan dem ɗe la vi una̱ka̱ Tata ɗa u suku yi vi tsupige. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Mayun n tonuko ɗa̱, uza ɗa baci dem u panai ili iꞌya n danai, kpam u wushuki n uza ɗa u suku mu, wa̱ ta̱ n uma u ɗa bawu wa kotso. Vuma u nala vi a ka kiɗa̱ga yi ugana wa, shegai u pasa ɗe ukpa̱ ubana uma u ɗa bawu wa kotso. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Mayun n tonuko ɗa̱, aꞌayin a ka tuwa̱ ta̱ hal gba̱m a ɗa a rawa ɗe a ɗa akushe a ka pana kala̱ga̱tsu ka va̱, mpa Maku ma Kashila̱, aza ɗa a panai ka vi a ka tsa̱ra̱ ta̱ uma. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tata vi wa̱ ta̱ n ucira u ɗa wa na̱ka̱ uma, kpam u na̱ka̱ ta̱ dem Maku mi ucun u ucira u nala vi. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","U na̱ka̱ ta̱ dem Maku mi ucira u kiɗa̱ga ya dem ugana, kpaci aya Maku ma Vuma. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Kotsu i yain majiyan adama a ukuna u na vi wa: Aꞌayin a ka tuwa̱ ta̱ a ɗa akushe a ɗa aꞌa̱ri a asaun a le gba̱ a ka pana kala̱ga̱tsu ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Aku a wuta̱ a asuvu a asaun a le. Aza ɗa a yain ili i shinga a ka ꞌya̱nga̱ ta̱ a yain uma, aza ɗa kpam a yain tsicingi a ka ꞌya̱nga̱ ta̱ aku a kiɗa̱ga le ugana. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“N tsu yan ili adama a kaci ka va̱ wa. Tata u ɗa u suku mu aya u tonuko mu tyoku ɗa ma kiɗa ugana. N tsu kiɗa ta̱ ugana derere, kpaci n tsu yan ta̱ ili iꞌya i tsu zuwa yi u pana kayanyan, n tsu yan ili iꞌya ya zuwa mu n pana kayanyan wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“A da baci mpa koshi n tsu dansa ukuna u kaci u va̱, uza wa̱ri wa wushuku n kadyanshi ka va̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Shegai uza roku u ɗa pini uza ɗa wa dansa ukuna u va̱, kpam n reve ta̱ gba̱ ili iꞌya u dansai a kaci ka va̱ mayun ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","I suku ta̱ atsumate ara Yahaya, kpam u tonuko le ta̱ ukuna u mayun a kaci ka va̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Shegai udani u vuma u ɗa n pityanangi n u ɗa wa, ko an u wokoi n ciɓuga ɗa̱ ukuna u kadyanshi ka Yahaya tsa̱ra̱ i tsa̱ra̱ iwauwi. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yahaya rongo ta̱ n katyashi tyoku u macikalu ma a sapai, kpam i pana ta̱ kayanyan ka katyashi ka ne a aꞌayin kenu. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Shegai ili i roku iꞌya pini iꞌya i lai i Yahaya ugbonguro iꞌya i wenikei ukuna u maci a kaci ka va̱. Ili iꞌya Tata u na̱ka̱ mu n yain iꞌya ma dansa̱ka! Ili i na yi i wenike ta̱ an Tata u ɗa u suku mu. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tata u ɗa u suku mu vi dem u yan ta̱ kadyanshi a kaci ka va̱, shegai i pana kala̱ga̱tsu ka ne ko kpam i wene yi wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Udani u ne vi u dusuku a atakasuvu a ɗe wa, kpaci i wushuku n uza ɗa u suki vi wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","I tono ta̱ Tagara̱da u Kashila̱ mai kpaci ya wundya ta̱ nte ya tsa̱ra̱ pini uma u ɗa bawu wa kotso, kpam Tagara̱da u nala vi mpa wa dansa̱ka! ");
INSERT INTO kdlNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Shegai i ꞌyuwan ta̱ utuwa̱ ara va̱ tsa̱ra̱ n na̱ka̱ ɗa̱ uma u ɗa bawu wa kotso vi. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Icikpali i ama iꞌya ma ciga wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","N reve ɗa̱ ta̱, ko uza wa̱ la wa ciga Kashila̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","N tuwa̱ ta̱ a asuvu a kala ka Tata u va̱, i wusha mu wa. Shegai i gonoi ya wusha ama ɗa a ka tuwusa̱ adama a kaci ka le. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","I tsu ciga ta̱ icikpali a asu u atoku a ɗe, shegai i tsu dambula i zami icikpali i Kashila̱ wa. Niɗa ya wushuku na̱ mpa? ");
INSERT INTO kdlNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Kotsu i wundi yavu mpa ma sapula ɗa̱ a asu u Tata wa, Musa ɗa wa sapula ɗa̱! Ko an u wokoi aya uza ɗa i zuwai uma wa ɓa̱nga̱ ɗa̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Musa korongu ta̱ ukuna u maci a kaci ka va̱, i wushuku baci n Musa, u gan ta̱ dem i wushuku na̱ mpa. ");
INSERT INTO kdlNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","I wushuku baci n ili iꞌya Musa korongi wa, niɗa ya fuɗa ya wushuku n ili iꞌya n danai?” ");
INSERT INTO kdlNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","An ukuna u nala u wurai, Yesu lazai ubana a upashi u Kushiva̱ ku Galili (ka dem a ka isa̱ Kushiva̱ ku Tibariya.) ");
INSERT INTO kdlNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kakuma̱ ka ama ushani ka tono yi kpaci a wene yi ta̱ wa yansa ikunesavu an wa ta̱na̱sa̱sa̱ aza a mɓa̱la̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","4","Kpam aꞌayin a Abiki a Upasamgbana a aza a Yahuda a yan ɗe evu, aku Yesu banai a masasa n atoni a ne a dusuki. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","An Yesu wenei kakuma̱ ka ama ka tuwa̱ ara ne, aku u wecei Filibu, “Nte tsa tsa̱ra̱ iburodi iꞌya tsa lyatangu ama a na yi?” ");
INSERT INTO kdlNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Wece ɗa u wece yi tsa̱ra̱ u kondo yi, kpaci u reve ta̱ ili iꞌya wa ciga u yain.) ");
INSERT INTO kdlNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filibu wushuki, “Ikebe i manyan ma uwoto kulla̱ ma fuɗa ma tsila iburodi iꞌya ya dem wa tsa̱ra̱ kajibi pini na wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Katoni ka ne ka roku uza ɗa a ka isa̱ Andurawu utoku u Simo Bituru, u danai, ");
INSERT INTO kdlNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kalobo ka roku ka na ka ka̱ri n iburodi i kenu i kenu i tawun n adan a re. Shegai a ɗa a ka rawa kakuma̱ ka ama ka na ki wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu danai, “Tonukoi ama yi a dusuku.” Asu vi kpam wa̱ ta̱ n mete ushani, kpam ama evu n azu a tawun (5,000) aꞌali a dusuki pini. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","U bidyai iburodi yi u cikpai Kashila̱. Aku u na̱ka̱i aza ɗa aꞌa̱ri pini ndishi evu n eyi. Nala kpam dem u yain n adan yi, hal ya dem cuwa̱i. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","An ya dem takumai, aku u tonukoi atoni a ne, “Cira̱ngi abuwi a ɗa a buwai vi. Tsa yanka a ɗa koli wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","A cira̱ngi abuwi a iburodi a ɗa a buwai vi hal mbana kupa na̱ n re. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","An ama yi a wenei ukunosavu u ɗa Yesu yain, aku a danai, “Maken ma̱ la wa, aya gai Matsumate ma a ɗanga̱sai ma tuwa̱ a likimba vi.” ");
INSERT INTO kdlNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu reve ta̱ ama a foɓuso ta̱ a tuwa̱ a bidya yi n ucira a gonuko yi magono ma le, aku u lazai n kabini u banai a masasa utyoku u ne. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","An kaara ka rukpa̱i, atoni a Yesu a banai a kushiva̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","A uwai a kpatsu a ka pasa kushiva̱ ubana a Kafarnahum. An karimbi ka yain, Yesu tani kotsu u tuwa̱ a asu u le wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kute‑kute uwule u ucira wa lapana hal u ꞌya̱nga̱sa̱i aɓali a pige pini a kushiva̱ ki. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","An atoni yi a wala̱kai kpatsu ki ubana a mere ma kushiva̱, aku a wenei Yesu utuwa̱ a zuba u mini. U gita̱i uraɓa evu n kpatsu ki, aku a panai uwonvo cika. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","U tonuko le, “Mpa, kotsu i pana uwonvo wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Pini nala, a wushuki a uka yi pini a kpatsu ki. Kute‑kute kpatsu ki ku rawai a asu u ɗa a ka ciga a bana. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","An kain ka wansai, aza ɗa a buwai a upashi u kushiva̱ vi, a reve ta̱ kpatsu ku te ki ka koshi ku buwai ɗe. A reve ta̱ kpam Yesu uwa ka u tono atoni a ne wa, atoni yi a ɗa a lazai koshi bawu eyi. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Aꞌatsu ushani a wuta̱ ta̱ a ilyuci i Tibariya a rawai evu n asu u ɗa Asheku a cikpai Kashila̱ n iburodi iꞌya ama yi a takumai vi. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","An kakuma̱ ki ka wenei Yesu wa̱ kpam pini a asu vi wa, atoni a ne dem aꞌa̱ pini wa, aku a uwai aꞌatsu ubana a Kafarnahum tsa̱ra̱ a boli le. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","An a rawai a wene yi, aku a wece yi, “Kawenishiki, nwere ɗa vu tuwa̱i pini na?” ");
INSERT INTO kdlNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu wushunku le, “Mayun n tonuko ɗa̱, iꞌa̱ mu ta̱ uzama adama a ɗa i takumai burodi i cuwa̱i, shegai adama a kalen ka ikunesavu i va̱ iꞌya i wenei wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kotsu i zuwa ucira adama a ɗa ya tsa̱ra̱ ilikulya iꞌya ya namgba wa, shegai i zuwa ucira a ilikulya iꞌya ya na̱ka̱ uma u ɗa bawu wa̱ri n utyoku. Ilikulya iꞌya Maku ma Vuma ma na̱ka̱ ɗa̱ iꞌya gai na vi, kpaci aya Kashila̱ Tata u wushunki u yain nala. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Aku a wece yi, “Ndya Kashila̱ ka ciga tsu tsu yain?” ");
INSERT INTO kdlNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","U wushunku le, “Ili iꞌya Kashila̱ ka ciga ɗa̱ i yain iꞌya na: Wushuki n uza ɗa u suki.” ");
INSERT INTO kdlNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Aku a danai, “U ka̱na̱ ta̱ vu wenike tsu ukunosavu, va ciga baci tsu wushuku n avu. Ndya va yanka tsu? ");
INSERT INTO kdlNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Isheku i tsunu a takuma ta̱ mana† a kakamba. A korongu ta̱ ukuna u na vi a Tagara̱da u Kashila̱: ‘Musa na̱ka̱ le ta̱ ilikulya iꞌya i wuta̱i a zuba tsa̱ra̱ a lyai.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","U tonuko le, “Mayun n tonuko ɗa̱, Musa ɗa na̱ka̱ ɗa̱ ilikulya iꞌya i wuta̱i a zuba vi wa. Tata u va̱ u ɗa uza ɗa wa na̱ka̱ ɗa̱ ilikulya i mayun a zuba. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kpam ilikulya iꞌya Kashila̱ ka tsu na̱ka̱ vi iꞌya gai i wuta̱i a zuba i na̱ka̱i ama a likimba uma vi.” ");
INSERT INTO kdlNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ama yi a danai, “Uzapige, na̱ka̱sa̱ tsu ilikulya i na yi kain dem.” ");
INSERT INTO kdlNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Aku u danai, “Mpa ilikulya iꞌya i tsu na̱ka̱ uma. Uza ɗa baci dem u tuwa̱i ara va̱ wa pana kambulu wa, uza ɗa kpam u wushuki na̱ mpa, wa pana kakuli wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ma̱ri n tonuko ɗa̱ ɗe, n da i wene mu ta̱, shegai i wushuku na̱ mpa wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tata vi u tsu na̱ka̱ mu ta̱ ama a va̱. Ya dem a asuvu a le wa tuwa̱ ta̱ ara va̱, mpa kpam ma loko yi wa, ko kenu. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","N wuta̱ ta̱ a zuba n tuwa̱i tsa̱ra̱ n yain ili iꞌya Kashila̱ ka ciga mu n yain, shegai adama a ili iꞌya mpa ma ciga wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ili iꞌya uza ɗa u suku mu vi wa ciga n yain iꞌya na: Kotsu ko uza u te a asuvu a aza ɗa u na̱ka̱ mu vi u puwa̱n wa, shegai n ꞌya̱nga̱sa̱ le gba̱ kain ka makorishi. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Aza ɗa a wenei Maku mi kpam a wushuki n eyi, a ka tsa̱ra̱ ta̱ uma u ɗa bawu wa kotso, kpam ma ꞌya̱nga̱sa̱ le ta̱ kain ka makorishi. Ili iꞌya Tata u va̱ wa ciga iꞌya gai la vi.” ");
INSERT INTO kdlNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ama a gita̱i tsali a kaci ka ne, an u danai, “Mpa ilikulya iꞌya i wuta̱i a zuba.” ");
INSERT INTO kdlNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","A danai, “Yesu ɗa na vi maku ma Isuhu. Tsu reve ta̱ tata na̱ mma u ne. Niɗa wa dana, ‘A zuba u ɗa n wuta̱i’?” ");
INSERT INTO kdlNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","U wushunku le, “A̱sa̱ka̱i uyan tsali. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Tata ɗa u suku mu. Uza wa̱ la wa tuwa̱ ara va̱ wa, she Tata vi u tuko yi, kpam ma ꞌya̱nga̱sa̱ ta̱ vuma u nala vi kain ka makorishi. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ntsumate n korongu ta̱, ‘Kashila̱ ka wenishike le ta̱ gba̱ le.’ Gba̱ uza ɗa baci u pana̱kai Tata kpam u rotsongusi ili iꞌya wa wenishike, wa tuwa̱ ta̱ ara va̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Uza wa̱ la u wenei Tata vi wa, she mpa uza ɗa Kashila̱ ka suki, mpa koshi n wene yi. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Mayun n tonuko ɗa̱, uza ɗa baci u wushuki na̱ mpa wa̱ ta̱ n uma u ɗa bawu wa̱ri n utyoku. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mpa ilikulya iꞌya i tsu na̱ka̱ uma. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Isheku i ɗe i takuma ta̱ mana a kakamba, gba̱ n nala a kuwusa̱i. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ilikulya iꞌya i wuta̱i a zuba iꞌya na. Uza ɗa baci dem u lyai ilikulya i na yi wa kuwa̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mpa gai ilikulya iꞌya i tsu na̱ka̱ uma vi, iꞌya i wuta̱i a zuba. Uza ɗa baci dem u lyai iꞌya, wa tsa̱ra̱ ta̱ uma u ɗa bawu wa̱ri n utyoku. Ilikulya iꞌya ma na̱ka̱ ɗa̱ vi ikyamba i va̱ iꞌya, iꞌya ma na̱ka̱ ama a likimba a tsa̱ra̱ uma.” ");
INSERT INTO kdlNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Aku aza a Yahuda a gita̱i kananamgbani utyoku u le, “Niɗa vuma u na wa na̱ka̱ tsu ikyamba i ne tsu takuma?” ");
INSERT INTO kdlNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","U tonuko le, “Mayun n tonuko ɗa̱, i takuma baci ikyamba i Maku ma Vuma kpam i soi mpasa n ne wa, ya tsa̱ra̱ uma vi wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Uza ɗa u takumai ikyamba i va̱ kpam u soi mpasa n va̱, wa tsa̱ra̱ ta̱ uma u ɗa bawu wa̱ri n utyoku, kpam ma ꞌya̱nga̱sa̱ yi ta̱ kain ka makorishi. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ikyamba i va̱ ilikulya i maci iꞌya, mpasa n va̱ kpam ili i uso i maci iꞌya. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Uza ɗa u takumai ikyamba i va̱ kpam u soi mpasa n va̱, wa̱ ta̱ kaɓolo na̱ mpa, mpa kpam ma̱ ta̱ kaɓolo n eyi. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tata uza u uma, aya u suku mu, kpam adama a ne a ɗa ma̱ri n uma. Uza ɗa baci dem u takumai ikyamba i va̱, wa tsa̱ra̱ ta̱ uma a adama a va̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Mpa ilikulya iꞌya i wuta̱i a zuba. Uza ɗa baci dem u lyai iꞌya, wa tsa̱ra̱ ta̱ uma bawu utyoku, kpam wa kuwa̱ tyoku ɗa isheku i ɗe i kuwa̱i wa, ko an u wokoi a takumai mana.” ");
INSERT INTO kdlNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu dansa ta̱ ikuna i na yi eyi n u wenishiki a kagata ka Kashila̱ a Kafarnahum. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","An atoni a Yesu a panai nala, aku a danai, “Ukuna u na vi u wuyana ta̱ ureve. Ya wa wushuku n u ɗa?” ");
INSERT INTO kdlNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu reve ta̱ atoni a ne a ka yan tsali, aku u wece le, “Ukuna u na vi u ɓa̱la̱ ɗa̱ ɗa? ");
INSERT INTO kdlNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Niɗa ya yawunsa aꞌayin a ɗa baci i wenei mpa Maku ma Vuma ugono a zuba? ");
INSERT INTO kdlNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Kulu ka ku tsu na̱ka̱ uma u ɗa bawu wa̱ri n utyoku. Ucira u vuma wa fuɗa wa yan ili wa. Kadyanshi ka n tonuko ɗa̱ ka zuwa ɗa̱ ta̱ i tsa̱ra̱i Kulu Keri ku Kashila̱ ka ku tsu na̱ka̱ uma. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Shegai aza roku a asuvu a ɗe a wushuku wa.” (Yesu wa̱ri u gita̱ ta̱ u revei aza ɗa a ka ꞌyuwan uwushuku n uza ɗa wa neke yi.) ");
INSERT INTO kdlNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","U danai, “Adama a nala n tonuko ɗa̱, ‘Tata u tuko baci uza ara va̱ wa, wa fuɗa wa tuwa̱ wa.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Adama a kadyanshi ka Yesu yain, atoni a ne ushani a kpatala̱ka yi ta̱ kucina̱ a a̱sa̱ka̱ yi utono. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Aku u wecei Kupanamere, u danai, “Eɗa̱ dem ya laza ɗa?” ");
INSERT INTO kdlNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simo Bituru wushuki, “Asheku, ara yai ɗa tsa laza ubana? Va̱ ta̱ n kadyanshi ka ka na̱ka̱ uma u ɗa bawu wa̱ri n utyoku. ");
INSERT INTO kdlNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Tsu wushuku ta̱ kpam tsu reve ta̱ aɗa Uza u Uwulukpi u Kashila̱.” ");
INSERT INTO kdlNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","U danai, “N ɗanga̱sa ɗa̱ ta̱ Kupanamere. Shegai uza u te Kala̱pa̱nsi ka!” ");
INSERT INTO kdlNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yahuza maku ma Simo Isikariyoti ɗa wa dansa̱ka. Aya wa tuwa̱ wa neke yi, ko an u wokoi eyi dem wa̱ ta̱ a asuvu a Kupanamere yi. ");
INSERT INTO kdlNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","An nala u wurai, Yesu kyawunsai gba̱ kaɓon ka Galili. Wa ciga u wala a kaɓon ka Yahuda wa, kpaci azapige a aza a Yahuda a ɗa pini a ka ciga a wuna yi. ");
INSERT INTO kdlNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Evu n aꞌayin a Abiki a Atani a aza a Yahuda† a ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Aku aꞌangu a Yesu a banai ara ne a danai, “A̱sa̱ka̱ asu u na vi vu bana a Yahuda tsa̱ra̱ atoni a vunu a niɗe yi dem a wene ikunesavu iꞌya va yansa. ");
INSERT INTO kdlNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Uza ɗa baci dem wa ciga u zuwa ama a reve yi, u tsu sokongu ili iꞌya u tsu yansa wa. Aɗa baci va yansa ili i na yi, wenike kaci ka vunu a likimba.” ");
INSERT INTO kdlNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ko aꞌangu a ne dem a wushuku n eyi wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu wushunku le, “Aꞌayin a ɗa ma bana vi kotsu a yan wa, shegai eɗa̱ ya fuɗa ta̱ ya bana ko nwere ɗa baci. ");
INSERT INTO kdlNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ama a likimba a na a ka kovo ɗa̱ wa, mpa a ka kovo, kpaci n tsu tonuko le ta̱ ikuna i cingi iꞌya a ka yansa. ");
INSERT INTO kdlNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Walai ubana a asu u abiki vi. Mpa kotsu n foɓuso ubana ɗe wa, kpaci aꞌayin a ɗa ma bana ɗe kotsu a yan wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","An u danai nala, aku u shamgbai pini a Galili. ");
INSERT INTO kdlNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","An aꞌangu a Yesu a lazai ubana a asu u abiki vi, aku Yesu banai dem, shegai ukpawunsi u ɗa u banai. ");
INSERT INTO kdlNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Azapige a aza a Yahuda a ka ciga a wene yi pini a asu u abiki vi, a rongoi a uwecishike, “Nte wa̱ri?” ");
INSERT INTO kdlNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Pini a asuvu a kakuma̱ ki, ama ushani a ka dansa n tsubini a kaci ka Yesu, aza roku a danai, “Vuma maci ɗa.” Aza roku kpam a ka dansa, “Kaɓan ka wa yansa̱ka ama.” ");
INSERT INTO kdlNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Shegai ko uza u dansa n a pani wa, kpaci a ka pana ta̱ uwonvo u azapige a aza a Yahuda. ");
INSERT INTO kdlNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kain ka nishi ka abiki yi, Yesu banai a Kuwa ku Kashila̱ ki u gita̱i uwenishike. ");
INSERT INTO kdlNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Aza a Yahuda yi a yain majiyan, a danai, “Vuma u na u vi u dusuku a kukere ku kawenishiki wa, niɗa a yansai u revei ili ushani naha?” ");
INSERT INTO kdlNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","U wushunku le, “Ili iꞌya ma wenishike ara va̱ ɗa i wuta̱i wa, shegai Kashila̱ uza ɗa u suku mu, aya u na̱ka̱ mu iꞌya. ");
INSERT INTO kdlNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ama a ɗanga̱sa baci a yain ili iꞌya Kashila̱ ka ciga, a ka reve ta̱ uwenishike vi a asu u Kashila̱ ɗa u wuta̱i, ara va̱ ɗa wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Aza ɗa a tsu wenishike n ucira u kaci u le, icikpali i ama iꞌya a tsu bolo. Shegai uza ɗa u tsu ciga a cikpala uza ɗa u suku yi, ukuna u mayun u ɗa u tsu dansa. U tsu yan kaɓan wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Musa na̱ka̱ ɗa̱ ta̱ Mele, shegai ko uza u te u ɗe u tono ma wa. Niɗa ya ciga i wuna mu?” ");
INSERT INTO kdlNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ama yi a wushuki, “Va̱ ta̱ n ityoni i cingi! An ya a ka ciga a wuna vu?” ");
INSERT INTO kdlNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","U wushuki, “N yan ta̱ ukunosavu u te, aku i yain majiyan. ");
INSERT INTO kdlNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa tonuko ɗa̱ ta̱ i kiɗa mmuku n ɗe acombi. (Shegai isheku i cau i ɗe iꞌya i gita̱i n ukuna vi, Musa ɗa wa.) I tsu kiɗa ta̱ maku kacombi hal n kain ka Ashibi dem. ");
INSERT INTO kdlNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ya kiɗa baci maku kacombi n kain ka Ashibi an Mele ma Musa ma wushunku ɗa̱ nala, niɗa ya pana mu upan an n ta̱na̱sa̱i uza u maɓa̱la̱ gba̱ gba̱ n kain ka Ashibi? ");
INSERT INTO kdlNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","A̱sa̱ka̱i uyan afada adama a tyoku ɗa i bidyai ukuna wa̱ri, shegai i yain afada n ukuna u maci.” ");
INSERT INTO kdlNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Pini a aꞌayin a nala yi, aza a Urishelima a roku a ka dansa utyoku u le, “Vuma ɗa azapige a ka ciga a wuna ɗa gai na vi. ");
INSERT INTO kdlNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Shegai wa wenishike ta̱ a asu u ɗa ya dem wa wene kpam u pana̱ka yi, kpam azapige yi a shamkpa yi wa. Gaawan a reve ta̱ aya Kawauwi ki. ");
INSERT INTO kdlNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Shegai tsu reve ta̱ ilyuci i vuma u na vi. Kawauwi ka mayun ka tuwa̱ baci, ko uza wa reve ilyuci i ne wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu n u wenishiki pini a Kuwa ku Kashila̱ ki, aku u ꞌya̱nga̱sa̱i kala̱ga̱tsu, “Eye, i reve mu ta̱, kpam i reve ta̱ ilyuci i va̱. Mpa n suki kaci ka va̱ wa, uza ɗa u suku mu vi u dansa ta̱ ukuna u mayun, shegai eɗa̱ i reve yi wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Mpa n reve yi ta̱, kpaci a asu u ɗa wa̱ri u ɗa n wuta̱i, kpam aya u suku mu.” ");
INSERT INTO kdlNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","An u danai nala, aku ama yi a ka ciga a ka̱na̱ yi, shegai uza wa̱ la u fuɗai u sawa yi wa, kpaci kotsu aꞌayin a rawa wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ama ushani a wushuku ta̱ n Yesu. A ka dansa, “Ko Kawauwi ka tuwa̱ baci, wa la gba̱m vuma u naha vi uyan ikunesavu ushani?” ");
INSERT INTO kdlNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","An Afarishi a panai kakuma̱ ka ama a ka dansa ikuna i na yi a kaci ka Yesu n tsubini, aku a ɓolomgbonoi kaci n aɗara̱kpi a pige a suki aza a uwundya u Kuwa ku Kashila̱ a ka̱na̱ yi. ");
INSERT INTO kdlNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu danai, “Ma rongo ta̱ kaɓolo n a̱ɗa̱ aꞌayin kenu, aku n laza ubana a asu u uza ɗa u suku mu. ");
INSERT INTO kdlNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Aꞌayin a nala yi ya zama mu ta̱, shegai ya wene mu wa. Kpam ya fuɗa ya tuwa̱ a asu u ɗa ma̱ri wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Aku aza a Yahuda a gita̱i uwecishe kaci ka le, “Nte vuma na wa ciga u bana ɗa bawu tsa fuɗa tsa wene yi? A ilyuci ilyuci i Nheline iꞌya wa̱ wa bana a asu u ɗa ama a tsunu aꞌa̱ri na̱ ndishi, tsa̱ra̱ u ba u wenishike le ɗe? ");
INSERT INTO kdlNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ndya kalen ka kadyanshi ka u yain an u danai, ‘Ya zama mu ta̱ uwene, shegai ya wene mu wa,’ kpam ‘Ya fuɗa ya tuwa̱ a asu u ɗa ma̱ri wa’?” ");
INSERT INTO kdlNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Kain ka makorishi ka abiki yi; wata, kain ka pige ka la vi, Yesu shamgbai a kapala ka ama ki, u ꞌya̱nga̱sa̱i kala̱ga̱tsu u danai, “Gba̱ uza ɗa baci wa pana kakuli, u tuwa̱ ara va̱ u soi. ");
INSERT INTO kdlNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tagara̱da u Kashila̱ u dana ta̱, ‘Uza ɗa baci dem u pityanangi na̱ mpa, a asuvu a katakasuvu ka ne ka aga̱ta̱ a mini ma ma tsu na̱ka̱ uma ma rongo uwutusa̱ ushani.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ukuna u Kulu Keri u ɗa wa dansa̱ka. Kotsu Kashila̱ ka na̱ka̱ Kulu ki wa, kpaci kotsu u ra̱ɗa̱gba̱ Yesu u na̱ka̱ yi tsupige wa. Shegai ubana a kapala, ama ɗa a wushuki n Yesu vi a ka wusha ta̱ Kulu Keri. ");
INSERT INTO kdlNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","An ama yi a pana̱kai Yesu, aku aza roku a danai, “Vuma u na vi Matsumate ma a ɗanga̱sai vi ma mayun.” ");
INSERT INTO kdlNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Aza roku a danai, “Kawauwi ka.” Shegai aza roku a danai, “Kawauwi ka wuta̱ a asuvu a Galili wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tagara̱da u Kashila̱ u dana ta̱, Kawauwi ki a kumaci ku Dawuda Magono ka wa wuta̱, kpam a Batalami ɗa a ka matsa yi, a ilyuci iꞌya Dawuda rongoi.” ");
INSERT INTO kdlNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Aku ama yi a pecenei tyoku ɗa a ka yawunsa a kaci ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Aza roku a ka ciga a ka̱na̱ yi, shegai ko uza u sawa yi wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Aku aza ɗa a ka wundya Kuwa ku Kashila̱ ki a gonoi a asu u aɗara̱kpi a pige n Afarishi yi, aku a wece le, “Ndya i zuwai i kpa̱ɗa̱i utuko Yesu vi pini na?” ");
INSERT INTO kdlNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Aza a uwundya Kuwa ki a wushuki, “Ko uza wa̱ la u dansai tyoku ɗa vuma u na vi u dansai wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Afarishi yi a danai, “Eɗa̱ dem u puwunsa̱ ɗa̱ ɗe! ");
INSERT INTO kdlNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Uza wa̱ la a asuvu a tsunu a̱tsu aɗara̱kpi a pige n Afarishi u wushuki n Yesu wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Shegai kakuma̱ ka ama ka bawu ka revei n Mele ma Musa mi, Kashila̱ ka wacinsa le ta̱.” ");
INSERT INTO kdlNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimu, uza u te a asuvu a Afarishi yi, aya uza ɗa u banai tsa̱ra̱ u wene Yesu caupa. U tonukoi atoku a ne, ");
INSERT INTO kdlNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Mele ma tsunu ma wushunku tsu tsu wuna uza bawu tsu panai ili iꞌya wa dana wa. U gan tsu kiɗa̱ga le ugana bawu tsu revei ili iꞌya a yain wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Aku a wushunku yi, “Avu dem uza u Galili u ɗa? Tono Tagara̱da u Kashila̱ mai, va wene ta̱ matsumate ma̱ la ma wuta̱ a kaɓon ka Galili wa.”  ");
INSERT INTO kdlNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Aku ndishi mi n kotsoi, ya dem lazai ugono a kuwa. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pini nala, Yesu lazai ubana a Masasa ma Zayitum. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","An kain ka wansai n usana u de, aku u lazai ubana a Kuwa ku Kashila̱. Ama yi a tuwa̱i a asu u ne, aku u dusuki n ele u gita̱ le uwenishike. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Awenishiki a Mele n Afarishi a tukoi uka roku uza ɗa a ka̱na̱i n tsishankala, aku a zuwa yi u shamgba a kapala ka kakuma̱ ka ama. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","A danai, “Kawenishiki, a ka̱na̱ ta̱ uka u na n u yanyi tsishankala. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mele ma Musa ma wenishike tsu ta̱, uza ɗa baci dem a ka̱na̱i n ucun u ili i na yi a vara̱sa yi n atali a wuna yi. Ndya vu danai?” ");
INSERT INTO kdlNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","A dana ta̱ ukuna u na vi tsa̱ra̱ a wandi Yesu tsa̱ra̱ a tsa̱ra̱ ili iꞌya a ka sapula yi. Shegai Yesu kelikei a iyamba, u gita̱i uyan ikorongi n majubu ma ne. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","A ma̱tsa̱ yi n keci a kaci ka uka ki. Aku u tuwa̱i u ꞌya̱nga̱i u danai, “Gba̱ uza ɗa bawu wa̱ri pini na n unyushi, u gita̱ u fuluku katali u vara yi.” ");
INSERT INTO kdlNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Aku Yesu doki u kelikei u yain ikorongi. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","An a panai nala, aku a laza̱sai maten‑maten. Nkoshi n ɗa a gita̱i a laza̱sai, aku a a̱sa̱ka̱i Yesu n uka vi pini utyoku u le. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu ꞌya̱nga̱i u wece yi, “Nte ama yi? Uza wa̱ la u shamgbai u kiɗa̱ga vu ugana wa?” ");
INSERT INTO kdlNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","U wushuki, “Uzapige, ko uza u buwa wa.” Aku Yesu tonuko yi, “Mpa dem ma kiɗa̱ga vu ugana wa. Wala ili i vunu, kotsu vu doku vu yain unyushi u cingi wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu doki u dansai n ele, “Mpa uza ɗa u tsu na̱ka̱ ama a likimba katyashi. Uza ɗa baci dem u tono mu, wa tsa̱ra̱ ta̱ katyashi ka ka tsu na̱ka̱ uma, kpam wa wala a asuvu a karimbi wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Afarishi yi a tonuko yi, “Ama a re a dansa baci a kaci ka ukuna, tsa wushuku ta̱. Shegai aꞌayin a ɗa baci va dansa̱ka kaci ka vunu, aɗa koshi vu tsu bidya kadyanshi ki mayun ɗa, adama a nala, a̱tsu tsa wushuku n ili iꞌya vu danai wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","U wushunku le, “Mayun ɗa, a kaci ka va̱ ka ma yan kadyanshi ka na ki, kpam mayun ɗa ka̱ri. N reve ta̱ asu u ɗa n wuta̱i n asu u ɗa ma bana. Shegai eɗa̱ i reve asu u ɗa n wuta̱i n asu u ɗa ma bana wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Eɗa aza ɗa i tsu yan afada tyoku ɗa ama a tsu yansa. Mpa ma yanka uza u afada wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Shegai ko ma yan baci afada, a ɗa mpa ma yan a maci a ɗa, kpaci ma̱ri utyoku u va̱ wa. Tata u ɗa u suku mu wa̱ ta̱ kaɓolo na̱ mpa. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mele ma ɗe ma dana ta̱, ama a re a dana baci ili i te a kaci ka ukuna, u ka̱na̱ ta̱ i wushuku n ili iꞌya a danai. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ma̱ ta̱ a asuvu a aza ɗa a ka yan kadyanshi a kaci ka va̱, Tata u ɗa u suku mu vi, aya uza u ire vi.” ");
INSERT INTO kdlNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Aku a wece yi, “Nte tata u vunu vi?” U wushunku le, “I reve mu wa, kpam i reve Tata u va̱ wa. I reve mu baci, ya reve ta̱ dem Tata u va̱.” ");
INSERT INTO kdlNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","U yan ta̱ kadyanshi ka na ki aꞌayin a ɗa wa̱ri a uwenishike a Kuwa ku Kashila̱, evu n asu u ɗa a ka zuwusa ikebe. Shegai ko uza u ka̱na̱ yi wa, kpaci kotsu aꞌayin a ne a yan wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu doki u tonukoi ama yi, “Ma laza ta̱ n a̱sa̱ka̱ ɗa̱, kpam ya zama mu ta̱, shegai i lya baci kapala n unyushi u cingi u ɗe, ya kuwa̱ ta̱. Ya fuɗa ya bana a asu u ɗa ma bana wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Aku azapige a aza a Yahuda a danai, “U da tsa fuɗa tsa bana a asu u ɗa wa bana wa. Wa ciga u dana wa wuna kaci ka ne ɗa?” ");
INSERT INTO kdlNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","U danai, “Eɗa̱ aza a likimba u na ɗa a iyamba, shegai mpa a zuba u ɗa n wuta̱i. Eɗa̱ aza a likimba u na ɗa, shegai mpa uza u likimba u ɗa wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ɗa gai i zuwai n danai ya kuwa̱ ta̱ kaɓolo n unyushi u cingi u ɗa ya yansa vi. I ꞌyuwan baci uwushuku an mpa uza ɗa n da ma̱ri vi, mayun ya kuwa̱ ta̱ a asuvu a unyushi u cingi u ɗe.” ");
INSERT INTO kdlNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Aku a wece yi, “Aɗa yai?” U wushunku le, “Mpa gai uza ɗa n tsu tonusuko ɗa̱ ma̱ri vi. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ili iꞌya pini ushani iꞌya ma dansa a kaci ka ɗe, kpam n kiɗa̱ga ɗa̱ ugana. Shegai uza ɗa u suku mu u tsu dansa ta̱ ukuna u maci. Kpam n tonuko aza a likimba ili iꞌya u tonuko mu koshi.” ");
INSERT INTO kdlNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Shegai ama yi a fuɗa a reve an ukuna u Tata u ɗa wa̱ri le utonusuko wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","U danai, “Aꞌayin a ɗa baci i ra̱ɗa̱gba̱i Maku ma Vuma a zuba a mawandamgbani, ya reve ta̱ an mpa gai uza ɗa n tonuko ɗa̱ ma̱ri vi. Kpam ya reve ta̱ an n tsu yan ili adama a kaci ka va̱ wa. Ili iꞌya Tata u va̱ u wenishike mu iꞌya n tsu dansa. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Uza ɗa u suku mu wa̱ ta̱ kaɓolo na̱ mpa, u a̱sa̱ka̱ mu utyoku u va̱ wa, kpaci n tsu rongo ta̱ uyansa ili iꞌya u tsu pana kayanyan.” ");
INSERT INTO kdlNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ama ushani aza ɗa a pana̱kai Yesu n u dansi ikuna i na yi, a wushuku ta̱ n eyi. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu tonukoi aza ɗa a wushuki n eyi, “I lya baci kapala n utono uwenishike u va̱, eɗa̱ atoni a va̱ a ɗa a mayun. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kpam ya reve ta̱ ukuna u mayun, u tuko ɗa̱ kpam utsa̱ra̱ u kaci.” ");
INSERT INTO kdlNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Aku a wushuki, “A̱tsu mmuku n tsikaya ma Ibirahi n ɗa, kpam kotsu tsu gbashika uza roku wa. Niɗa va dana a ka tuko tsu utsa̱ra̱ u kaci?” ");
INSERT INTO kdlNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","U wushunku le, “Mayun n tonuko ɗa̱, gba̱ uza ɗa baci dem u yain unyushi u cingi, kagbashi ka unyushi u cingi ka. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kagbashi ka tsu rongo a kuwa ku uzapige maco wa, shegai maku ma vuma mi ma tsu rongo ta̱ a kuwa ku tata u ne maco. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Adama a nala, Maku mi ma tuko ɗa̱ baci utsa̱ra̱ u kaci, ya tsa̱ra̱ ta̱ utsa̱ra̱ u kaci u mayun. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","N reve ta̱ eɗa̱ mmuku ma Ibirahi n ɗa, shegai ya ciga ta̱ i wuna mu adama a ɗa bawu i wushuki n uwenishike u va̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ili iꞌya Tata u va̱ u wenike mu iꞌya ma tonuko ɗa̱, shegai ya yansa ili iꞌya tata u ɗe u tonuko ɗa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","A wushuki, “Ibirahi ɗa tata u tsunu.” U tonuko le, “A da baci eɗa̱ mmuku ma Ibirahi n ɗa mayun, ya yansa ta̱ ili iꞌya Ibirahi yain. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","N tonuko ɗa̱ ta̱ ukuna u mayun u ɗa n panai a asu u Kashila̱, aku ya ciga i wuna mu. Ibirahi wa yan ucun u ukuna nala wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Shegai ya yan derere ili iꞌya tata u ɗe wa yansa.” Aku a wushuki, “A̱tsu ilimaci i kateshe iꞌya wa! Kashila̱ n kaci ka ne aya Tata u tsunu u mayun.” ");
INSERT INTO kdlNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","U tonuko le, “Kashila̱ ka baci ka̱ri Tata u ɗe, iꞌa̱ri ya ciga mu ta̱, kpaci a asu u Kashila̱ ɗa n wuta̱i n tuwa̱i ara ɗe. N tuwa̱ adama a kaci ka va̱ wa, shegai aya u suku mu. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","I reve ili iꞌya n danai wa, kpaci ya wushuku n uwenishike u va̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kala̱pa̱nsi ka tata u ɗe, kpam ili iꞌya u tsu ciga iꞌya i tsu yan derere. Eyi uza u nkunu ɗa n uza u kaɓan tun a kagita̱. Ili iꞌa̱ la i mayun a kaci ka ne wa. Kaɓan ka u tsu rongo a uyansa, kpaci eyi uza u kaɓan ɗa. Uza u kaɓan ɗa gba̱m koshi wa, shegai tata u kaɓan u ɗa dem. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","An u wokoi ma tonusuko ɗa̱ ukuna u mayun ɗa i zuwai bawu i wushuki na̱ mpa. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","A asuvu a ɗe ya wa fuɗa wa wuta̱ karara u dana mpa uza u unyushi u cingi u ɗa? An u wokoi ma tonusuko ɗa̱ ukuna u mayun, ndya i zuwai i kpa̱ɗa̱i uwushuku na̱ mpa? ");
INSERT INTO kdlNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Maku ma Kashila̱† dem ma tsu pana ta̱ kadyanshi ka Kashila̱. Shegai eɗa̱ mmuku n Kashila̱ n ɗa wa, ɗa gai i zuwai bawu i panai vi.” ");
INSERT INTO kdlNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Aza a Yahuda a wushunki Yesu, “Dere ɗa tsu danai avu uza u Samariya u ɗa, kpam va̱ ta̱ n ityoni i cingi!” ");
INSERT INTO kdlNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","U danai, “Ma̱ n ityoni i cingi a asuvu a va̱ wa. N na̱ka̱ ta̱ Tata u va̱ tsupige, shegai eɗa̱ i ꞌyuwan mu una̱ka̱ tsupige. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kumoɗu ka ma̱ri tsa̱ra̱ n tsa̱ra̱ka̱ kaci ka va̱ tsupige wa, shegai uza roku u ɗa pini uza ɗa wa ciga mu n wushi tsupige. Aya kpam dem wa yan afada. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mayun n tonuko ɗa̱, uza ɗa baci dem u tonoi uwenishike u va̱, wa kuwa̱ wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","A danai, “Gogo‑na tsu reve ta̱ an va̱ri n ityoni i cingi a asuvu a vunu! Ko Ibirahi na̱ ntsumate a kuwusa̱ ta̱. Shegai avu vu danai, ‘Gba̱ uza ɗa baci u tonoi uwenishike u va̱, wa kuwa̱ wa.’ ");
INSERT INTO kdlNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Vu la tata u tsunu Ibirahi tsupige ɗa? U kuwa̱ ta̱, nala dem ntsumate. Ya vu bidyai kaci ka vunu?” ");
INSERT INTO kdlNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","U wushunku le, “N na̱ka̱ baci kaci ka va̱ tsupige, tsupige tsu va̱ tsa woko ili i roku wa. Uza ɗa u na̱ka̱ mu tsupige aya Tata u va̱, eɗa̱ kpam i danai aya Kashila̱ ka ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Eɗa̱ kotsu i reve yi wa, mpa tani n reve yi ta̱. N da baci kotsu n reve yi wa, ma woko ta̱ uza u kaɓan tyoku u ɗe. Shegai n reve yi ta̱, kpam n tono ta̱ ili iꞌya u danai. ");
INSERT INTO kdlNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tata u ɗe Ibirahi za̱nga̱na̱ ta̱ u wene utuwa̱ u va̱, kpam u wene ta̱ u yain kpam maza̱nga̱ cika.” ");
INSERT INTO kdlNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Aku a danai, “Niɗa va dana vu wene Ibirahi, aɗa tani na kotsu vu rawa ayen amangarenkupa wa?” ");
INSERT INTO kdlNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Aku u tonuko le, “Mayun n tonuko ɗa̱, kahu a matsa Ibirahi, Mpa† pini.” ");
INSERT INTO kdlNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","An Yesu danai nala, aku ama yi a bidisai atali tsa̱ra̱ a wuna yi. Shegai u puwa̱in, u lazai u a̱sa̱ka̱i Kuwa ku Kashila̱ ki. ");
INSERT INTO kdlNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","An Yesu wa̱ri a nwalu, aku u wenei vuma roku uza ɗa a matsai karumba̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Aku atoni a ne a wece yi, “Kawenishiki, ndya i zuwai a matsai vuma u na karumba̱? Nusa ɗa u nusai, ko gai isheku i ne iꞌya i yain unyushi vi?” ");
INSERT INTO kdlNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","U wushunku le, “Vuma u na u rumba̱na̱ adama a unyushi u ne, ko kpam u isheku i ne wa. Matsa ɗa a matsa yi nala tsa̱ra̱ Kashila̱ ka wenike ucira u ne ara ne. ");
INSERT INTO kdlNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","U ka̱na̱ ta̱ tsu yain manyan ma uza ɗa u suku mu n kaara. Kayin ka yan ta̱ ɗa bawu uza wa yan manyan. ");
INSERT INTO kdlNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Aꞌayin a ɗa ma̱ri pini naha a likimba, mpa n tsu zuwa katyashi a asu u ama a likimba.” ");
INSERT INTO kdlNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","An u danai nala, aku u cikpa̱i ata̱tsa̱ a iyamba, u vura̱i kalyon n a ɗa, aku u gbarai kalyon ki a aꞌeshi a vuma yi. ");
INSERT INTO kdlNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Aku u tonukoi vuma vi, “Wala ba vu sawa aꞌeshi a vunu a kaɗa̱ka̱ ka mini ka a ka isa̱ Sila̱wamu.” (Kalen ka “Sila̱wamu” ka “Uza ɗa a Suki.”) Aku vuma vi u banai u sawai aꞌeshi a ne. U gono ta̱ n u weni. ");
INSERT INTO kdlNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ama a ɗa aꞌa̱ri a asu vi n aza ɗa a revei karumba̱ ki uza ɗa wa̱ri u tsu folo vi, a wecikei, “Vuma ɗa u tsu dusukusu pini n u foli u ɗa na vi wa?” ");
INSERT INTO kdlNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Aza roku a danai, “Aya gai vi.” Aza roku kpam a danai, “Aya wa, rotsono ɗa gai a rotsonoi.” Karumba̱ ki ka rongoi gai udansa, “Mpa gai na vi!” ");
INSERT INTO kdlNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Aku a wece yi, “Niɗa vu yansai va wene gogo‑na?” ");
INSERT INTO kdlNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","U wushunku le, “Vuma ɗa a ka isa̱ Yesu ɗa u vura̱i kalyon, aku u gbara̱ka mu aꞌeshi. Pini nala, u tonuko mu n bana a Kaɗa̱ka̱ ka Sila̱wamu n sawa aꞌeshi yi. An n ba n sawai, aku n wenei.” ");
INSERT INTO kdlNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Aku a wece yi, “Nte vuma vi?” U danai, “N reve wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","A bidyai vuma ɗa wa̱ri karumba̱ caupa vi, a banka yi a asu u Afarishi. ");
INSERT INTO kdlNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Kain ka Yesu vura̱i kalyon u ta̱na̱sa̱i vuma vi, kain ka Ashibi ka. ");
INSERT INTO kdlNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Pini nala, Afarishi yi a wecei vuma vi, “Niɗa a yain vu tsa̱ra̱i aꞌeshi a vunu?” U wushunku le, “Aya u gbara̱ka mu kalyon a aꞌeshi, aku n sawai, pini nala, n wenei.” ");
INSERT INTO kdlNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Afarishi a roku a danai, “Yesu na vi a asu u Kashila̱ ɗa u wuta̱i wa, kpaci wa tono mele ma Ashibi wa.” Shegai aza roku a danai, “Vuma ɗa wa̱ri n unyushi u cingi wa fuɗa wa yan ikunesavu naha wa.” Aku ka kpa̱ɗa̱ le utuwa̱ ka te. ");
INSERT INTO kdlNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","A doku a wecei vuma vi, “Ndya va dana a kaci ka vuma ɗa u ta̱na̱sa̱ vu aꞌeshi yi?” U wushunku le, “Matsumate ma.” ");
INSERT INTO kdlNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Azapige a aza a Yahuda a wushuku an vuma vi karumba̱ ka caupa, kpam gogo‑na wa fuɗa wa wene wa, aku a suki a isa̱ isheku i ne. ");
INSERT INTO kdlNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","A wece le, “Maku ma ɗe ma na vi? I da nala i matsa yi n urumba̱, niɗa a yain aku gogo‑na wa wene?” ");
INSERT INTO kdlNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Aku a wushuki, “Tsu reve ta̱ gai maku ma tsunu ma, kpam nala tsu matsa yi n urumba̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Shegai tsu reve tyoku ɗa a yain wa wene wa. Kpam dem tsu reve uza ɗa u ta̱na̱sa̱ yi wa. Wece ni. U ra̱tsa ta̱ u wushunku ɗa̱ n kaci ka ne.” ");
INSERT INTO kdlNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","A dana ta̱ nala adama a ɗa a ka pana uwonvo u azapige yi. Alya a danai gba̱ uza ɗa baci dem a ka̱na̱i u da Yesu Kawauwi ka, wa doku wa uwa a kagata ka Kashila̱ kpam wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ɗa gai i zuwai isheku i ne a danai, “Wece ni, u ra̱tsa ta̱ u wushunku ɗa̱ n kaci ka ne.” ");
INSERT INTO kdlNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","A doku a isa̱i vuma ɗa a matsai karumba̱ ki, a tonuko yi, “Tsina n Kashila̱ vu tonuko tsu ukuna u mayun! Tsu reve ta̱ vuma ɗa u ta̱na̱sa̱ vu na vi uza u unyushi u cingi ɗa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","U wushuki, “Ko wa̱ n unyushi u cingi, ko wa̱ n u ɗa wa, mpa n reve wa. Ili iꞌya gai n revei iꞌya: Caupa ma̱ri ta̱ n urumba̱, shegai gogo‑na ma wene ta̱.” ");
INSERT INTO kdlNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","A wece yi, “Ndya u yanka vu? Niɗa u ta̱na̱sa̱ vu?” ");
INSERT INTO kdlNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","U wushunku le, “N tonuko ɗa̱ ɗe, shegai i pana̱ka mu wa. Niɗa ya ciga i doku i pana ukuna vi kpam? Ya ciga i woko atoni a ne a ɗa dem?” ");
INSERT INTO kdlNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Aku a wisha yi a danai, “Aɗa gai katoni ka ne, a̱tsu atoni a Musa a ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tsu reve ta̱ Kashila̱ ka dansa ta̱ n Musa, shegai tsu reve gba̱m ilyuci iꞌya vuma u na u wuta̱i wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Vuma vi u danai, “Ili i majiyan iꞌya! U ta̱na̱sa̱ ta̱ aꞌeshi a va̱, shegai niɗa i kpa̱ɗa̱i ureve a asu u ɗa u wuta̱i? ");
INSERT INTO kdlNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","A̱tsu gai tsu reve ta̱ Kashila̱ ka tsu pana̱ka aza a unyushi u cingi wa, shegai u tsu pana̱ka ta̱ uza ɗa baci dem wa lyaka yi kayala kpam wa yansa ili iꞌya u danai. ");
INSERT INTO kdlNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tun an Kashila̱ ka yain likimba, uza wa̱ la u ta̱na̱sa̱i aꞌeshi a vuma ɗa a matsai karumba̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","A da baci vuma u na Kashila̱ ka ka suku yi wa, wa fuɗa wa yan ko i te wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","A tonuko yi, “Avu uza u unyushi u cingi u ɗa mayun mayun tun kain ka a matsa vu! Va wundya va fuɗa va wenishike tsu ili i roku ɗa?” Aku a loko yi pini a kagata ka Kashila̱ ki. ");
INSERT INTO kdlNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","An Yesu panai ili iꞌya i gita̱i, aku u boloi vuma vi u wece yi, “Vu wushuku wa̱ n Maku ma Vuma?” ");
INSERT INTO kdlNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Vuma vi u wushuki, “Uzapige, tonuko mu ko eyi yayi, tsa̱ra̱ n wushuku n eyi!” ");
INSERT INTO kdlNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","U tonuko yi, “Vu wene yi ɗe, kpam aya gai wa dansa n avu gogo‑na vi.” ");
INSERT INTO kdlNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Vuma vi u danai, “Asheku, n wushuku ta̱!” Aku vuma vi u lyakai Yesu kayala. ");
INSERT INTO kdlNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu tonuko yi, “N tuwa̱ ta̱ tsa̱ra̱ n pecene ama a likimba. N tuwa̱ ta̱ n zuwa arumba̱ a wene, aza ɗa kpam a ka wundya ele a ka wene n wenike le ele arumba̱ a ɗa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","An Afarishi a ɗa aꞌa̱ri pini vi a pana̱ka yi u danai nala, aku a wece yi, “Va wundya a̱tsu arumba̱ a ɗa?” ");
INSERT INTO kdlNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","U wushunku le, “A da baci eɗa̱ arumba̱ a ɗa gma̱m wa, iꞌa̱ri ya yan n unyushi u cingi wa. Shegai an i danai eɗa̱ ya wene ta̱, iꞌa̱ ta̱ pini n unyushi u cingi u ɗe.” ");
INSERT INTO kdlNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu danai, “Mayun n tonuko ɗa̱, aboki n aza a maga̱la̱ka̱ a ɗa koshi a tsu raɗugu a yuwa̱ kasaga a una̱ u ɗa a ka uwa a utsutsu u asu u ɗa a tsu zuwa ncon. ");
INSERT INTO kdlNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Uza ɗa u tsu uwa a utsutsu aya kaliniki ka ncon ki. ");
INSERT INTO kdlNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Uza ɗa u tsu wundya utsutsu vi, aya u tsu giduwuka̱ yi u ɗa. Kpam ncon n ne mi n tsu pana ta̱ kala̱ga̱tsu ka ne. U tsu isa̱ ta̱ n ne ya dem n kala ka ne, aku u wutukpa̱ le. ");
INSERT INTO kdlNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Aꞌayin a ɗa baci u wutukpa̱ le, aku u uwa a kapala ka le, ele n a toni kpaci a reve ta̱ kala̱ga̱tsu ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","A tsu tono vuma roku wa, shegai a suma yi, kpaci a reve kala̱ga̱tsu ka ne wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu tonuko le ta̱ agisani a na yi, shegai a reve ili iꞌya wa tono wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yesu doki u danai, “Mayun n tonuko ɗa̱, Mpa utsutsu u asu u ncon vi. ");
INSERT INTO kdlNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Gba̱ aza ɗa a lasa mu utuwa̱, aboki a ɗa n aza a maga̱la̱ka̱. Ncon mi a pana̱ka le wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mpa utsutsu vi, kpam uza ɗa u uwai a asu u va̱, wa tsa̱ra̱ ta̱ iwauwi, wa fuɗa ta̱ wa uwa kpam u wuta̱ u zami ijani i utakuma. ");
INSERT INTO kdlNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kaboki ka tsu tuwa̱ ta̱ uboki, u wuna, kpam u nangasa, shegai mpa n tuwa̱ ta̱ tsa̱ra̱ n na̱ka̱ uma kpam a tsa̱ra̱ u ɗa ushani. ");
INSERT INTO kdlNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Mpa kaliniki ka shinga. Kaliniki ka shinga ka tsu neke ta̱ uma u ne tsa̱ra̱ u ka̱ngu ncon n ne. ");
INSERT INTO kdlNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Uza ɗa a bidyai manyan ma kalina wa̱ tyoku u kaliniki uza ɗa wa̱ri na̱ ncon mi wa. U wene baci maleweni a utuwa̱, wa suma ta̱ u a̱sa̱ka̱ ncon mi utyoku u le. Aku maleweni mi ma ba ma za̱ra̱ ncon mi ma wacinsa le. ");
INSERT INTO kdlNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Vuma vi u suma ta̱ kpaci bidya ɗa a bidya yi manyan kpam u dambula a kaci ka ncon mi wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Mpa kaliniki ka shinga. N reve ta̱ ncon n va̱, nala dem Tata u va̱ u reve mu. Ncon n va̱ dem a reve mu ta̱, tyoku ɗa dem n revei Tata vi. N neke ta̱ uma u va̱ tsa̱ra̱ n ɓa̱nga̱ ncon mi. ");
INSERT INTO kdlNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ma̱ ta̱ na̱ ncon n roku n ɗa bawu ma̱ri a asuvu a ushiga u na vi, kpam u ka̱na̱ ta̱ n tuko le dem. A ka pana ta̱ kala̱ga̱tsu ka va̱, kpam gba̱ a ka woko ta̱ ushiga u te n kaliniki ka te. ");
INSERT INTO kdlNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Tata vi wa ciga mu ta̱ kpaci ma̱ ta̱ ufoɓusi tsa̱ra̱ n na̱ka̱ uma u va̱, kpam n tuwa̱ n wushi u ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Uza wa fuɗa wa wusa uma u va̱ ara va̱ wa. N na̱ka̱ ta̱ u ɗa adama a uciga u kaci u va̱. Ma̱ ta̱ n ucira u ɗa ma neke u ɗa kpam n wushi u ɗa, tyoku ɗa Tata u va̱ u tonuko mu n yain.” ");
INSERT INTO kdlNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Aza a Yahuda a doku a wushuku wa, aku ka kpa̱ɗa̱ le kpam utuwa̱ ka te. ");
INSERT INTO kdlNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Aza roku a le a danai, “Ityoni i cingi iꞌya i uwa yi iꞌya i zuwa yi ijan. Ndya i zuwai ya pana̱ka yi?” ");
INSERT INTO kdlNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Shegai aza roku a danai, “Uza ɗa baci ityoni i cingi i uwai u tsu yan kadyanshi naha wa. Ityoni i cingi ya fuɗa ya kukpa̱ aꞌeshi a karumba̱ ɗa?” ");
INSERT INTO kdlNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","An aꞌayin a uyolu a rawai, aꞌayin yi a ɗa a tsu yan Abiki a Uciɓusa Una̱ka̱ Kuwa ku Kashila̱† a Urishelima. ");
INSERT INTO kdlNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Kain ka te, Yesu wa wala pini a Kuwa ku Kashila̱ a asu u ɗa a tsu isa̱ Kafalaka ka Solomo. ");
INSERT INTO kdlNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Aku aza a Yahuda yi a ɓolomgbonoi a kyawan yi, a danai, “Hal ku yain ka va zuwa tsu uyan mala̱la̱ ko avu ya va̱ri? Aɗa baci Kawauwi ki, tonuko tsu karara.” ");
INSERT INTO kdlNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu wushunku le, “N tonuko ɗa̱ ɗe caupa, shegai i kpa̱ɗa̱i uwushuku. Ikunesavu iꞌya n yansai a asuvu a kala ka Tata u va̱ i wenike ta̱ ko mpa yayi. ");
INSERT INTO kdlNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Shegai i ꞌyuwain uwushuku, kpaci eɗa̱ ncon n va̱ n ɗa wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ncon n va̱ n tsu pana ta̱ kala̱ga̱tsu ka va̱, n reve le ta̱, ele kpam dem a tsu tono mu ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","N na̱ka̱ le ta̱ uma u ɗa bawu wa kotso, kpam a ka kuwa̱ wa. Uza wa̱ kpam la wa wusa le a kukere ku va̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tata u va̱ u ɗa u na̱ka̱ mu n ele, u la ta̱ ili gba̱ tsupige, kpam uza wa fuɗa wa wusa le a kukere ku Tata u va̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Tata vi na̱ mpa ili i te iꞌya.” ");
INSERT INTO kdlNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Pini nala, a doki a bidisai atali tsa̱ra̱ a wuna yi. ");
INSERT INTO kdlNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Shegai u tonuko le, “N wenike ɗa̱ ta̱ ili i shinga i shinga iꞌya Tata u va̱ u suku mu n yain. N ukuna u eni u ɗa a asuvu a le ya ciga i vara̱sa mu?” ");
INSERT INTO kdlNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Aku a wushuki, “Adama a ɗa vu yain ili i shinga iꞌya i zuwai tsa ciga tsu vara̱sa vu wa, shegai adama a ɗa vu yankai Kashila̱ kadyanshi ka cingi ɗa. Avu vuma ɗa, shegai vu danai dere ɗa va̱ri n Kashila̱!” ");
INSERT INTO kdlNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","U wushunku le, “A korongu ta̱ a Mele ma ɗe ma Kashila̱ ka danai, ‘N da, eɗa̱ ashila̱ a ɗa.’ ");
INSERT INTO kdlNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Tsu reve ta̱ ili iꞌya Tagara̱da u Kashila̱ u danai mayun ɗa wa̱ri hal ubana a makorishi. Kpam Kashila̱ ka isa̱ ta̱ ama a nala yi ashila̱, aza ɗa u na̱ka̱i udani u ne. ");
INSERT INTO kdlNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Mpa gai, Tata u ɗanga̱sa mu ta̱ kpam u suku mu a asuvu a likimba. Niɗa ya dana n yanka Kashila̱ kadyanshi ka cingi an n danai, ‘Mpa Maku ma Kashila̱ ma’? ");
INSERT INTO kdlNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Manyan ma Tata u va̱ wa yansa ma baci ma yansa wa, kotsu i wushuku na̱ mpa wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Shegai ili iꞌya Tata u va̱ wa yansa iꞌya baci ma yansa, u gan ta̱ i wushuku adama a nala, ko i wushuku baci n kadyanshi ka va̱ wa. Aku i reve an Tata vi ili i te iꞌya na̱ mpa, mpa kpam ili i te iꞌya n Tata vi.” ");
INSERT INTO kdlNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","A doki a ma̱tsa̱i tsa̱ra̱ a ka̱na̱ yi, shegai u lai. ");
INSERT INTO kdlNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Aku u ba u pasai Aga̱ta̱ a Urudu ubana a asu u ɗa Yahaya gita̱i ulyuɓugusu, u rongoi ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ama ushani a tuwa̱i ara ne. A ka dansa utyoku u le, “Yahaya yan ukunosavu wa, shegai gba̱ ili iꞌya Yahaya danai a kaci ka vuma u na mayun ɗa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Pini nala, ama ushani a wushuki n Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Kain ka te, maɓa̱la̱ ma ka̱na̱i vuma roku uza ɗa a ka isa̱ Liꞌazaru, uza ɗa wa rongo a ilyuci i Batani n ataku a ne Meri n Marta. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Meri na vi, uza ɗa vangu u ne wa̱ri n maɓa̱la̱ mi, aya uza ɗa u tuwa̱i u tsungi manivi ma magula̱ni a aꞌene a Asheku, aku u yansai a ɗa n kenji ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Pini nala, Meri n Marta a suki uza roku u ba u tonuko Yesu, “Asheku, uza ɗa va ciga vi, maɓa̱la̱ ma ka̱na̱ yi ɗe.” ");
INSERT INTO kdlNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","An Yesu panai nala, u danai, “Maɓa̱la̱ ma nala ma kotso a ukpa̱ wa. Nala u gita̱ ta̱ tsa̱ra̱ a tuko tsupige a asu u Kashila̱, na̱ mpa Maku ma Kashila̱, n wushi tsupige adama a nala.” ");
INSERT INTO kdlNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu wa ciga ta̱ Marta n aꞌangu a ne. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Shegai an u panai a da maɓa̱la̱ ma ka̱na̱ ta̱ Liꞌazaru, aku u doki u shamgbai pini a asu u ɗa wa̱ri vi aꞌayin a re. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Aku u tonukoi atoni a ne, “Tsu gonoi a Yahuda.” ");
INSERT INTO kdlNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Atoni yi a danai, “Kawenishiki, kotsu u ɓa̱ra̱kpa̱ an azapige a aza a Yahuda a ka ciga a vara̱sa vu a wuna vu wa. Ndya i zuwai va ciga vu doku vu gono ɗe?” ");
INSERT INTO kdlNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","U wushuki, “Uliva̱ dem wa̱ ta̱ n ulapa uwule kupa n ure. Aꞌayin a ɗa baci dem katyashi ka̱ri la, ama a ka wala ta̱ kpam a ka ta̱ɗa̱tsa̱ wa. A ka wene ta̱ kpaci aꞌa̱ ta̱ n katyashi ka likimba u na. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Shegai a wala baci n karimbi, a ka ta̱ɗa̱tsa̱ ta̱, kpaci aꞌa̱ n katyashi wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Aku u tonuko le, “Kaje ka tsunu Liꞌazaru aya pini wa lavuta, nte ma bana ɗe tsa̱ra̱ n ꞌya̱nga̱sa̱ yi.” ");
INSERT INTO kdlNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Aku atoni yi a danai, “Asheku, alavu a ɗa yi baci, wa ta̱na̱ ta̱!” ");
INSERT INTO kdlNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ele n a dani ko alavu a maci a ɗa Yesu tonuko le wa lavuta, shegai Yesu tonuko ɗa wa tonuko le Liꞌazaru kuwa̱ ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Aku u wutumkpa̱ le a kateshe, u danai, “Liꞌazaru kuwa̱ ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Shegai n pana ta̱ kayanyan an bawu ma̱ri ɗe. Adama a nala, ya rotsongusu ta̱ i wushuku na̱ mpa. Tuwa̱i tsu banai ara ne gogo‑na.” ");
INSERT INTO kdlNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Aku katoni ka roku Toma (uza ɗa a ka isa̱ “Mapeshe”) u tonukoi aza ɗa a buwai, “Tsu soki kawenishiki ki gba̱ tsunu, tsa̱ra̱ tsu kuwa̱ ɗe kaɓolo n eyi!” ");
INSERT INTO kdlNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","An Yesu rawai evu, u cinai cina a ciɗa̱ngu ɗe Liꞌazaru n aꞌayin a nishi. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Batani n Urishelima aꞌa̱ ta̱ evu evu, evu n mel u re ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Adama a nala, aza a Yahuda ushani a bansa ta̱ idyani i ukpa̱ ara Marta n Meri adama a ukpa̱ u vangu u le. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","An Marta panai a da Yesu wa tuwa̱, aku u banai u gawunsai n eyi, shegai Meri shamgbai pini a kuwa. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta tonukoi Yesu, “Asheku, a da baci va̱ri pini, vangu u va̱ wa̱ri wa kuwa̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Shegai ko n gogo‑na n reve ta̱ Kashila̱ ka na̱ka̱ vu ta̱ ili iꞌya baci dem vu folo yi.” ");
INSERT INTO kdlNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","U danai, “Vangu u vunu wa ꞌya̱nga̱ ta̱ u yain kpam uma.” ");
INSERT INTO kdlNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta wushuki, “N reve ta̱ an wa ꞌya̱nga̱ kain ka makorishi, Kashila̱ ka ꞌya̱nga̱sa̱ baci gba̱ akushe.” ");
INSERT INTO kdlNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","U wushunku yi, “Mpa n tsu ꞌya̱nga̱sa̱ ukpa̱, mpa kpam uma. Aza ɗa baci a wushuki na̱ mpa, ko a kuwa̱ baci a ka ꞌya̱nga̱ ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Uza ɗa wa̱ri n uma kpam u wushuki na̱ mpa, wa kuwa̱ wa. Marta, vu wushuku wa̱?” ");
INSERT INTO kdlNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","U danai, “N wushuku ta̱, Asheku. Aɗa Kawauwi, Maku ma Kashila̱, uza ɗa wa tuwa̱ a likimba vi.” ");
INSERT INTO kdlNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","An Marta danai nala, aku u gonoi u ba u tonukoi vangu u ne Meri koshi, u danai, “Kawenishiki ki ka rawa ɗe, kpam aɗa wa wecike.” ");
INSERT INTO kdlNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","An Meri panai nala, aku u ꞌya̱nga̱i gogo wa bana ara Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Kotsu u rawa a ilyuci yi wa, nte u buwai ve ɗe a asu u ɗa Marta gawunsai n eyi. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ama ushani a tuwa̱ le ta̱ uwene, shegai an a wenei Meri wuta̱i a kuwa ki gogo, aku a yawunsai nte wa bana ɗe a asu u kasaun vi tsa̱ra̱ u sa̱i. Aku a tono yi. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Meri vi u banai a asu u ɗa Yesu wa̱ri. An u wene yi, aku u kuɗa̱ngi a kapala ka ne u danai, “Asheku, a da baci va̱ri pini na, vangu u va̱ wa̱ri wa kuwa̱ wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","U wene yi wa sa̱, ama ɗa aꞌa̱ri kaɓolo n eyi dem a ka sa̱, aku u dambulai cika. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","U wece le, “Nte i ciɗa̱ngu yi?” A wushunku yi, “Asheku, tuwa̱ vu wene asu vi.” ");
INSERT INTO kdlNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Aku Yesu dem u sa̱i. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ama ɗa aꞌa̱ri kushani pini evu a danai, “I wene ta̱ tyoku ɗa wa ciga Liꞌazaru cika.” ");
INSERT INTO kdlNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Shegai aza roku a le a danai, “U zuwa ta̱ karumba̱ ka wenei. Wa̱ri u gan ta̱ u ɓishinka Liꞌazaru ukuwa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Eyi pini a kadambula ki, aku u banai a asu u kasaun vi. Kasaun ki tani kaaɓuru ka, kpam a kimba̱ ta̱ ka n katali ka roku a utsutsu vi. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Aku u tonuko le, “Gindala̱kpai katali ki a ikengi.” Shegai Marta danai, “Asheku, vu reve ta̱ Liꞌazaru kuwa̱ ɗe aꞌayin a nishi, ka̱wa̱n ka yan ta̱ pini.” ");
INSERT INTO kdlNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu tonuko yi, “Vu a̱sa̱nsa̱ an n tonuko vu, ‘Vu wushuku baci va wene ta̱ tsupige tsu Kashila̱’?” ");
INSERT INTO kdlNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Aku a gindala̱kpai katali ki a ikengi. U weɓelei zuba u danai, “Tata, n cikpa vu ta̱ an vu pana̱ka mu. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","N reve ta̱ vu tsu pana̱ka mu ta̱ maco, shegai n dana ta̱ nala adama a ama ɗa a kyawan mu na vi. Ma ciga ta̱ a wushuku an aɗa vu suku mu.” ");
INSERT INTO kdlNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","An u kotsoi kavasu, aku u salai, “Liꞌazaru, wuta̱!” ");
INSERT INTO kdlNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Aku u wuta̱i. Akere n aꞌene a ne ucaci n aminya a eri, a cacai kpam upetiwaꞌeshi u ne n kunya. Aku Yesu danai, “Surukpa ni i a̱sa̱ka̱ yi u wala.” ");
INSERT INTO kdlNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ama ushani a ɗa a tuwa̱i tsa̱ra̱ a wene Meri vi a wenei ili iꞌya Yesu yain, aku a wushuki n eyi. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Aza roku a le a banai a asu u Afarishi a tonuko le ili iꞌya Yesu yain. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Aku aɗara̱kpi a pige n Afarishi a ɓolomgbonoi Asheshi a Pige a asu u te, a danai, “Ndya tsa yan? Vuma u na wa yansa ta̱ ikunesavu ushani. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tsu a̱sa̱ka̱ yi baci u lyai kapala n uyansa ili i na yi, ya dem wa wushuku ta̱ n eyi. Aku asoje a aza a Roma a tuwa̱ a wacinsa Kuwa ku Kashila̱ ku tsunu n uyamba u tsunu.” ");
INSERT INTO kdlNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Uza roku a asuvu a Asheshi a Pige yi; wata, Kayafa, uza ɗa wa̱ri Magono ma Aɗara̱kpi a kayen ki, u danai, “Eɗa̱ i reve ili iꞌya iꞌa̱ri pini wa! ");
INSERT INTO kdlNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Niɗa ya a̱sa̱ka̱ uyamba gba̱ u kuwa̱? Wa la ta̱ tsulobo uza u te u na vi u kuwa̱ n u ɗa a ama gba̱ a ka kuwa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Uyawunsa u na vi a katakasuvu ka Kayafa ka u wuta̱i wa. Shegai an wa̱ri Magono ma Aɗara̱kpi a kayen ka nala ki ɗa i zuwai wa yan kadyanshi ka ili iꞌya ya tuwa̱ ya gita̱: Dana ɗa wa dana Yesu wa kuwa̱ ta̱ adama a aza a Yahuda. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Adama a unyushi u aza a Yahuda a ɗa koshi Yesu wa kuwa̱ wa. Wa kuwa̱ ta̱ tsa̱ra̱ u ɓolomgbono ama a Kashila̱ a ɗa a wacinsai a asuvu a likimba. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kain ka nala ki ka azapige a aza a Yahuda a gita̱i ufoɓuso tyoku ɗa a ka wuna Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Adama a nala, Yesu doku u wala a kateshe a Yahuda wa, aku u a̱sa̱ka̱i Urishelima. U lazai ubana a ilyuci i Ifuramu, iꞌya iꞌa̱ri a ikengi i kakamba, aku u dusuki ɗe n atoni a ne. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","An a yain evu n Abiki a Upasamgbana, aku ama ushani aza ɗa aꞌa̱ri a ilyuci i kenu kenu a lazai ubana a Urishelima kahu abiki yi, tsa̱ra̱ a wulukpe kaci ka le tyoku ɗa Mele ma danai a yansa. ");
INSERT INTO kdlNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","A ka ciga a wene Yesu, ele pini a Kuwa ku Kashila̱ ki, aku a ka wecemgbene, “Ndya i wenei? Wa tuwa̱ gba̱m a asu u abiki vi?” ");
INSERT INTO kdlNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Aɗara̱kpi a pige n Afarishi yi a tonukoi ama, uza ɗa baci dem u wenei Yesu, u tonuko le, kotsu a ka̱na̱ yi. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","An aꞌayin a teli a wokoi kahu Abiki a Upasamgbana yi, Yesu banai a Batani u rawai a kuwa ku Liꞌazaru uza ɗa u ꞌya̱nga̱sa̱i a ukpa̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","A foɓusukoi Yesu ilikulya, Marta aya uza ɗa wa pecike ilikulya, Liꞌazaru kpam wa̱ ta̱ pini ndishi kaɓolo n aza ɗa a ka lya ilikulya n eyi. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Aku Meri bidyai kolubo u manivi ma ma̱ri n ikebe cika u pige, u tsunki Yesu a aꞌene. U yansai ma n kenji ka ne. Magula̱ni ma manivi mi ma shaɗangi kuwa ki. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Katoni ka a ka isa̱ Yahuza Isikariyoti wa̱ ta̱ dem pini. Aya wa tuwa̱ wa neke Yesu a asu u azapige. U danai, ");
INSERT INTO kdlNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Manivi ma nala mi ma rawa ta̱ ikebe iꞌya uza wa yan manyan ma kayen ka te. Wa̱ri u gan ta̱ a denge ma, aku a na̱ka̱ aza a unambi.” ");
INSERT INTO kdlNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Shegai Yahuza vi u dambula gba̱m n aza a unambi yi wa. U dana ta̱ nala kpaci kaboki ka. Aya uza ɗa wa ɓa̱na̱ makpaka̱ta ma ikebe kpam u tsu bidya ta̱ i roku u yanka manyan ma kaci ma ne. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Shegai Yesu tonuko yi, “Kotsu vu damgbara̱sa yi wa. U yan ta̱ nala tsa̱ra̱ u foɓuso ikyamba i va̱ adama a kaciɗa̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ya rongo ta̱ n aza a unambi maco, shegai ya rongo na̱ mpa maco wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Aꞌa̱ri pini, aku kakuma̱ ka ama ka panai a da Yesu rawa ɗe a Batani. Aku a banai an u wokoi Yesu wa̱ri ɗe, kpam tsa̱ra̱ a wene Liꞌazaru uza ɗa Yesu ꞌya̱nga̱sa̱i a ukpa̱ vi. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Aɗara̱kpi a pige yi a foɓusoi dem tsa̱ra̱ a wuna Liꞌazaru. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Adama a Liꞌazaru, ama ushani a a̱sa̱ka̱ le utono, aku a ka wushukusu n Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","An kain ka wansai, aku kakuma̱ ka ama ka ka tuwa̱i uyan Abiki a Upasamgbana vi, a panai a da Yesu ɗa pini utuwa̱ a Urishelima. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Aku a bidisai akere a nshuwan tsa̱ra̱ a ba a gawunsa n eyi, n a sala̱si, “Hosana, cikpalai Kashila̱!” “Kashila̱ ka zuwuka uza ɗa wa̱ri a utuwa̱ a asuvu a kala ka Magono ma Zuba una̱ u shinga! Kashila̱ ka zuwuka Magono ma aza a Isaraꞌila una̱ u shinga.” ");
INSERT INTO kdlNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","An Yesu tsa̱ra̱i maku ma makparyagi ma roku, u yuwa̱i ma. Tyoku ɗa Tagara̱da u Kashila̱ u danai u ɗa la vi, ");
INSERT INTO kdlNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Aza a Sihiyona, kotsu i pana uwonvo wa! Magono ma ɗe ma pini a utuwa̱, uyuwi a maku ma makparyagi.” ");
INSERT INTO kdlNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","A aꞌayin a nala yi, atoni a ne kotsu a reve n ukuna vi wa. Shegai a ubana a kapala, an a tuwa̱i a ꞌya̱nga̱sa̱ yi ubana a tsupige, ɗa a ciɓai an Tagara̱da u Kashila̱ u danai ukuna vi a kaci ka ne, hal gba̱m a yanka yi u ɗa ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ama ɗa pini ushani kaɓolo n Yesu aꞌayin a ɗa u ꞌya̱nga̱sa̱i Liꞌazaru a ukpa̱, kpam u tonuko yi u wuta̱ a kasaun ki. Gogo‑na alya a ka tonusuko ama ili iꞌya u yain. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ama ushani a bana ta̱ tsa̱ra̱ a cina Yesu, kpaci a pana ta̱ ukuna u ukunosavu vi. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Aku Afarishi yi a ka dansa utyoku u le, “Wundyai, tsu rukpa̱ ɗe gba̱ gba̱! Likimba gba̱ aya a ka tono!” ");
INSERT INTO kdlNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nheline n roku n bana ta̱ a Urishelima ulya kayala aꞌayin a Abiki a Upasamgbana. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","A banai ara Filibu (uza ɗa u wuta̱i a ilyuci i Besaida a Galili) a danai, “Uzapige, tsa ciga ta̱ tsu wene Yesu.” ");
INSERT INTO kdlNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filibu banai u tonukoi Andurawu, aku a lazai ama a re a le a ba a tonukoi Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Aku u tonuko le, “Aꞌayin a yan ɗe a ɗa Maku ma Vuma ma wusha tsupige tsu ne. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mayun n tonuko ɗa̱, ucun u ulya u te u rukpa̱ baci a iyamba u kuwa̱i wa, wa la u te vi wa. Aꞌayin a ɗa baci u kuwa̱i, aku u woko ushani. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Uza ɗa baci wa ciga uma u ne a likimba u naha, wa namba ta̱ u ɗa. Uza ɗa baci u ꞌyuwain uma u ne a likimba u naha, wa tsa̱ra̱ ta̱ uma u ɗa bawu wa̱ri n utyoku. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Uza ɗa baci wa ciga u gbashika mu u ka̱na̱ ta̱ u tono mu, tsa̱ra̱ kagbashi ka va̱ ka rongo a asu u ɗa baci dem ma̱ri, kpam Tata u va̱ wa na̱ka̱ ta̱ uza ɗa baci dem u gbashika mu tsupige.” ");
INSERT INTO kdlNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yesu lyai kapala n kadyanshi, “Gogo‑na n dambula ta̱ cika. Ndya ma dana? N dana wa̱, ‘Tata, wauwa mu a aꞌayin a na yi’? Nala wa, n tuwa̱ ta̱ aꞌayin a na adama a na, tsa̱ra̱ n pana ikyamba. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tata, wenike ama tsupige tsu vunu!” Aku kala̱ga̱tsu ka wuta̱i a zuba ka danai, “N wenike ta̱ tyoku ɗa ma̱ri n tsupige kpam ma doku ta̱ ma wenike.” ");
INSERT INTO kdlNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kakuma̱ ka ama ka ka̱ri pini kushani vi a pana ta̱ kala̱ga̱tsu ki, aku aza roku asuvu a le a danai makpankashila̱ ma. Shegai aza roku a danai, “Katsumate ka zuba ka ka dansai n eyi!” ");
INSERT INTO kdlNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Aku Yesu tonuko le, “Adama a ɗe a ɗa kala̱ga̱tsu ki ka tuwa̱i, adama a va̱ a ɗa wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Gogo‑na aꞌayin a yan ɗe a ɗa Kashila̱ ka yanka ama a likimba afada. Kpam dem aꞌayin a ɗa, a ɗa wa loko uza ɗa wa lya tsugono tsu likimba u na. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","A ꞌya̱nga̱sa̱ mu baci a zuba u mawandamgbani, ma zuwa ta̱ ya dem u tuwa̱ ara va̱.” ");
INSERT INTO kdlNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu dana ta̱ nala tsa̱ra̱ u wenike tyoku ɗa wa kuwa̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Kakuma̱ ki ka danai, “Mele ma tsunu ma tonuko tsu ta̱ Kawauwi ka rongo ta̱ n uma hal ubana. Niɗa va dana a ka ꞌya̱nga̱sa̱ ta̱ Maku ma Vuma a zuba u mawandamgbani? Ya Maku ma Vuma mi?” ");
INSERT INTO kdlNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu wushuki, “Ya tsa̱ra̱ ta̱ katyashi aꞌayin kenu. Rongoi a nwalu aꞌayin a ɗa iꞌa̱ri a katyashi, tsa̱ra̱ i ta̱ɗa̱tsa̱ wa aꞌayin a ɗa baci karimbi ka danda ɗa̱. Shegai ya wala baci a karimbi, ya fuɗa ya reve asu u ɗa ya bana wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Wushuki n uza ɗa u tsu zuwa katyashi ka tuwa̱ tun wa̱ri kaɓolo n a̱ɗa̱, tsa̱ra̱ i woko aza ɗa a aꞌa̱ri a katyashi.” An Yesu danai nala, aku u lazai u ba u kpawain tsa̱ra̱ a wene yi wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ko an u wokoi u yansai ikunesavu a kapala ka le, a wushuku n eyi wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nala gita̱ ta̱ tsa̱ra̱ ili iꞌya Ishaya matsumate u danai i shaɗangu, “Magono ma Zuba, ya wushuki n ili iꞌya tsu danai? Magono ma Zuba, ya vu wenikei ucira u vunu?” ");
INSERT INTO kdlNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Matsumate mi ma doku ta̱ ma danai, ili iꞌya i zuwai a kpa̱ɗa̱i uwushuku iꞌya na: ");
INSERT INTO kdlNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Magono ma Zuba ma zuwa ta̱ aꞌeshi a ama yi a rumba̱na̱i, kpam u zuwa le a ryagbajai. Mpa Magono ma Zuba, n yan ta̱ nala tsa̱ra̱ a wene ko a reve wa, kpam kotsu a kpatala utuwa̱ ara va̱, tsa̱ra̱ n ta̱na̱sa̱ le wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Matsumate mi ma dana ta̱ nala kpaci u wene ta̱ tsupige tsu Yesu, kpam u dansai ukuna u ne. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Aꞌayin a nala yi, azapige ushani a wushuku ta̱ n eyi. Shegai an a ka pana uwonvo u Afarishi, a kawan a dansa u ɗa a kateshe wa, kotsu a wutukpa̱ le a asuvu a kagata ka Kashila̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","A tsu la ta̱ uciga icikpali i ama kapala n icikpali i Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu ꞌya̱nga̱sa̱i kala̱ga̱tsu ka ne u danai, “Gba̱ uza ɗa baci dem u wushuki na̱ mpa, na̱ mpa ɗa koshi u wushuku wa, hal dem n uza ɗa u suku mu ɗa u wushuki. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Uza ɗa kpam u wene mu, u wene ta̱ dem uza ɗa u suku mu. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","N tuwa̱ ta̱ a likimba n woko katyashi, tsa̱ra̱ uza ɗa baci dem u wushuki na̱ mpa u rongo a asuvu a karimbi wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Uza ɗa u panai kadyanshi ka va̱ aku u ꞌyuwain ka utono, mpa ma kiɗa̱ga yi ugana wa. Kpaci n tuwa̱ tsa̱ra̱ n kiɗa̱ga likimba ugana wa, shegai n wauwa u ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Uza ɗa wa kiɗa̱ga uza ɗa u ꞌyuwan mu ugana aya pini; wata, kadyanshi ka n dansai, ka ka kiɗa̱ga yi ugana kain ka makorishi. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ili iꞌya n wenishikei ara va̱ ɗa i wuta̱i wa. Tata u ɗa u suku mu aya u tonuko mu ili iꞌya ma dana n iꞌya ma wenishike. ");
INSERT INTO kdlNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","N reve ta̱ ili iꞌya u danai ama a yain i zuwa ta̱ ama a yain uma hal ubana. Ɗa i zuwai n tonuko ɗa̱ dere ili iꞌya Tata u tonuko mu.” ");
INSERT INTO kdlNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Cina u woko kain ka te kahu kain ka Abiki a Upasamgbana ka yain. Yesu reve ta̱ aꞌayin a yan ɗe a ɗa wa a̱sa̱ka̱ likimba u na u gono a asu u Tata. Wa ciga ta̱ ama a ne a ɗa aꞌa̱ri a likimba, kpam gogo‑na pini na u wenike le ta̱ uciga vi gba̱ gba̱ bawu utyoku. ");
INSERT INTO kdlNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesu n atoni a ne a ka lya kaɓolo n kuvuli. Cina Kala̱pa̱nsi ka zuwa ɗe Yahuza Isikariyoti maku ma Simo u yawunsa tsa̱ra̱ u neke yi. ");
INSERT INTO kdlNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu reve ta̱ Tata na̱ka̱ yi ta̱ ucira u ili gba̱, u wuta̱ ta̱ a asu u Kashila̱, kpam nte wa gono ɗe ara ne. ");
INSERT INTO kdlNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","An aꞌa̱ri a ulya ilikulya, Yesu ꞌya̱nga̱i u mondoi matogo ma pige ma ne, aku u sirai mayaga a cuku tsu ne. ");
INSERT INTO kdlNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","U tsungi mini a kabelu u gita̱i uɓacangusa aꞌene a atoni a ne, aku u yansai a ɗa n mayaga ma u sirai a cuku tsu ne tsi. ");
INSERT INTO kdlNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yesu tuwa̱i ara Simo Bituru, eyi kpam u tonuko yi, “Asheku, aɗa va ciga vu ɓacangusu mu aꞌene?” ");
INSERT INTO kdlNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu wushunku yi, “Vu reve ili iꞌya ma̱ri uyan wa, shegai va tuwa̱ ta̱ va reve.” ");
INSERT INTO kdlNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Bituru danai, “Nala wa, va ɓacangusu aꞌene a va̱ wa.” Yesu wushuki, “N ɓacangusu baci aꞌene a vunu wa, avu uza u te ɗa a asuvu a ama a va̱ wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simo Bituru danai, “Asheku, ɓacangusu gba̱m aꞌene a va̱ koshi wa! Sawa mu dem akere n kaci.” ");
INSERT INTO kdlNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu danai, “Vuma u sumba̱ baci, ikyamba i ne gba̱ i tsu takpa ta̱ sarara. Aꞌene a ne a ɗa koshi wa ɓacangusu. Eɗa̱ ama iꞌa̱ ta̱ sarara, shegai gba̱ ɗe ɗa wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu reve ta̱ uza ɗa wa kpatala̱ka yi, ɗa gai i zuwai u danai, “Gba̱ ɗe ɗa iꞌa̱ri sarara wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","An u kotsoi uɓacangusu aꞌene a le gba̱, aku u ukai matogo ma ne u gonoi u dusuki. U wece le, “I reve ili iꞌya n yanka ɗa̱ gogo‑na vi? ");
INSERT INTO kdlNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","I tsu isa̱ mu ta̱ ‘Kawenishiki’ n ‘Asheku’ kpam dere ɗa wa̱ri, kpaci ili iꞌya ma̱ri iꞌya la vi. ");
INSERT INTO kdlNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mpa, Asheku n Kawenishiki, n ɓacangusu ta̱ aꞌene a ɗe gogo‑na. Eɗa̱ dem i ɓacangusu aꞌene a atoku a ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","N yan ta̱ nala tsa̱ra̱ u woko ɗa̱ iryoci tsa̱ra̱ i yain dem tyoku ɗa n yanka ɗa̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mayun n tonuko ɗa̱, kagbashi ka tsu la uzakuwa u ne tsupige wa. Katsumate ka tsu la uza ɗa u suku yi tsupige wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","I reve ta̱ ili i na yi gba̱ kpam Kashila̱ ka zuwuka ɗa̱ ta̱ una̱ u shinga i tono baci iꞌya. ");
INSERT INTO kdlNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Gba̱ ɗe ɗa ma yanka kadyanshi wa. N reve ta̱ aza ɗa n ɗanga̱sai. Shegai u ka̱na̱ ta̱ ili iꞌya Tagara̱da u Kashila̱ u danai i woko mayun. Kpam a dana ta̱, ‘Vuma ɗa wa lya kaɓolo na̱ mpa u kpatala̱ka mu ta̱ kucina̱!’ ");
INSERT INTO kdlNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Tonuko ɗa ma tonuko ɗa̱ kahu ukuna vi u gita̱, tsa̱ra̱ u gita̱ baci kotsu i wushuku an mpa ma̱ri uza ɗa wa̱ri pini maco. ");
INSERT INTO kdlNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mayun n tonuko ɗa̱, uza ɗa baci u wushai katsumate ka va̱, mpa u wushai. Uza ɗa baci kpam u wusha mu, u wusha ta̱ uza ɗa u suku mu.” ");
INSERT INTO kdlNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","An Yesu danai nala, u dambula ta̱ cika. U tonuko le a kateshe, “Mayun n tonuko ɗa̱, uza u te ɗe wa neke mu ta̱.” ");
INSERT INTO kdlNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","A fuɗa a reve gba̱m kalen ka kadyanshi ka Yesu yain wa. Aku a ka wundyamgbana. ");
INSERT INTO kdlNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Uza u te a asuvu a atoni yi uza ɗa Yesu wa uciga cika wa̱ ta̱ ndishi evu n eyi. ");
INSERT INTO kdlNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simo Bituru yanka yi iryoci n kukere u danai, “Wece yi, ya wa dansa̱ka?” ");
INSERT INTO kdlNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Katoni ki ka raɓai evu n Yesu ka wece yi, “Asheku, ya va dansa̱ka a asuvu a tsunu?” ");
INSERT INTO kdlNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu wushuki, “Ma daɓa ta̱ kawon ka na a kusan. Uza ɗa baci n na̱ka̱i ka, aya gai wa kpatala̱ka mu vi.” Aku u daɓai kawon ki a kusan u na̱ka̱i Yahuza maku ma Simo Isikariyoti. ");
INSERT INTO kdlNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","An Yahuza wushai kawon ki, aku Kanangasi† ka uwa yi. Yesu danai, “Yahuza, wala gogo vu ba vu yain ili iꞌya va yan.” ");
INSERT INTO kdlNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Uza wa̱ la a asuvu a aza ɗa a ka lya kaɓolo n Yesu u revei kalen ka ili iꞌya i zuwai u tonuko yi nala wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Shegai adama a ɗa wa̱ri kazuwi ka ikebe ka le, aku a yawunsai a da tonuko ɗa Yesu tonuko yi u ba u tsupa ikebe i ilikulya ko kpam u ba u nei aza a unambi ikebe. ");
INSERT INTO kdlNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","An u lyuki kawon ka Yesu na̱ka̱ yi vi, aku u wuta̱i n maloko, n kayin ka tani. ");
INSERT INTO kdlNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","An Yahuza lazai, Yesu danai, “Aꞌayin a tuwa̱ ta̱ a ɗa mpa Maku ma Vuma ma uwa a asuvu a tsupige tsu va̱, kpam Kashila̱ ka wusha ta̱ tsupige adama a ili iꞌya ya gita̱ na̱ mpa. ");
INSERT INTO kdlNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kashila̱ ka wusha baci tsupige adama a va̱, Kashila̱ n kaci ka ne wa wenike ta̱ ama tyoku ɗa tsupige tsu Maku ma Vuma tsi tsa̱ri gogo. ");
INSERT INTO kdlNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Mmuku n va̱, ma tsa̱ ta̱ n ɓa̱ra̱kpa̱ n a̱ɗa̱ kenu. Ya tuwa̱ ta̱ ya zama mu, shegai ya wene mu wa. N tonuko ɗa̱ tyoku ɗa n tonukoi ama, ‘Ya bana a asu u ɗa ma bana wa.’ ");
INSERT INTO kdlNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Shegai mele ma savu ma ma na̱ka̱ ɗa̱. I cigi atoku a ɗe dere tyoku ɗa n ciga ɗa̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ya cigamgbana baci, ya dem wa reve ta̱ eɗa̱ atoni a va̱ a ɗa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simo Bituru wecei Yesu, “Asheku, nte va bana?” Yesu wushuki, “Asu u ɗa ma bana ya fuɗa ya bana wa, shegai ya tuwa̱ ta̱ ya bana.” ");
INSERT INTO kdlNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Bituru wece yi, “Asheku, ndya i zuwai bawu ma tono vu gogo‑na? Ma̱ ta̱ ufoɓusi tsa̱ra̱ n kuwa̱ adama a vunu!” ");
INSERT INTO kdlNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu wece yi, “Va̱ri ufoɓusi vu kuwa̱ adama a va̱? Mayun n tonuko vu, kahu kapen ka sala, va nana mu ta̱ hal kutatsu, vu dana vu reve mu wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu tonukoi atoni a ne, “Kotsu i dambula wa. Wushuki n Kashila̱, i wushuku kpam na̱ mpa. ");
INSERT INTO kdlNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Aꞌunu a ɗa pini ushani a kuwa ku Tata u va̱, kpam nte ma bana ɗe tsa̱ra̱ n foɓusuko ɗa̱ asu. A da baci nala wa̱ri wa, ma̱ri ma tonuko ɗa̱ ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Aꞌayin a ɗa baci n yain nala, aku n gono n bidya ɗa̱ ubana ara va̱, aku tsu rongoi ɗe kaɓolo. ");
INSERT INTO kdlNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","I reve ta̱ ure u asu u ɗa ma bana.” ");
INSERT INTO kdlNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toma tonuko yi, “Asheku, tsu reve asu u ɗa va bana wa. Niɗa tsa reve ure u ubana ɗe?” ");
INSERT INTO kdlNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","U wushuki, “Mpa ure u ɗa wa wenike ukuna u maci u Kashila̱, u na̱ka̱ kpam ama uma. Uza wa̱ la wa bana a asu u Tata wa, she u tono mu. ");
INSERT INTO kdlNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","I reve mu baci, ya reve ta̱ dem Tata u va̱. Shegai gogo‑na i reve yi ta̱, kpam i wene yi ta̱.” ");
INSERT INTO kdlNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filibu danai, “Asheku, wenike tsu Tata vi, kpaci ili iꞌya tsa ciga iꞌya la vi koshi.” ");
INSERT INTO kdlNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu wushuki, “Filibu, n rongo ta̱ n a̱ɗa̱ aꞌayin ushani. Ndya i zuwai vu kpa̱ɗa̱i ureve ko ya mpa ma̱ri? Uza ɗa baci dem u wene mu, u wene ta̱ dem Tata vi. Niɗa vu danai ‘Wenike tsu Tata vi’? ");
INSERT INTO kdlNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Vu wushuku an mpa ili i te iꞌya tsa̱ri n Tata vi, kpam Tata vi ili i te na̱ mpa wa? Kadyanshi ka n yanka ɗa̱ ara va̱ ɗa ka wuta̱i wa. Tata ɗa wa̱ri a asuvu a va̱, aya u tsu yan ili iꞌya wa ciga u yain. ");
INSERT INTO kdlNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Wushuki na̱ mpa an n danai Tata vi ili i te iꞌya tsa̱ri, kpam mpa vi ili i te iꞌya tsa̱ri n Tata vi. Ya wushuku baci adama a kadyanshi ka va̱ wa, u gan ta̱ i wushuku adama a ikunesavu i na yi. ");
INSERT INTO kdlNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Mayun n tonuko ɗa̱, uza ɗa baci u wushuki na̱ mpa, wa fuɗa ta̱ wa yan dere ili iꞌya n yansai. Mayun ɗa, aza ɗa a wushuki, a ka yan ta̱ hal gba̱m ili iꞌya i lai la, kpaci ma bana ta̱ ma rongo ɗe n Tata u va̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Kpam i folo baci ili a asuvu a kala ka va̱, ma yanka ɗa̱ ta̱ iꞌya, tsa̱ra̱ Maku mi ma tuko tsupige a asu u Tata. ");
INSERT INTO kdlNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ma yan ta̱ ili iꞌya baci dem i foloi a asuvu a kala ka va̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ya ciga mu baci, ya yan ta̱ ili iꞌya n danai i yain. ");
INSERT INTO kdlNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ma folo ta̱ Tata, eyi kpam wa na̱ka̱ ɗa̱ ta̱ Kaɓa̱ngi ka roku, uza ɗa wa rongo n a̱ɗa̱ hal ubana. ");
INSERT INTO kdlNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Aya Kulu Keri ka ku tsu wenike ukuna u maci u Kashila̱. Ama a likimba a wusha yi wa, kpaci a wene yi ko a reve yi wa. Shegai i reve yi ta̱, kpaci u rongo ta̱ ara ɗe kpam wa rongo ta̱ a asuvu a ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","N laza baci, ma a̱sa̱ka̱ ɗa̱ utyoku u ɗe tyoku u mkpan wa, ma gono ta̱ ara ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Aꞌayin kenu ama a likimba a na a ka fuɗa a wene mu wa, shegai eɗa̱ ya wene mu ta̱. Kpam adama a ɗa ma̱ri n uma, eɗa̱ dem ya yan ta̱ uma. ");
INSERT INTO kdlNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kain ka nala ka tuwa̱ baci, ya reve ta̱ an ili i te iꞌya ma̱ri n Tata vi. Ya reve ta̱ eɗa̱ dem ili i te iꞌya iꞌa̱ri na̱ mpa, mpa kpam ili i te iꞌya ma̱ri n a̱ɗa̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Uza ɗa baci dem wa ciga mu, wa yan ta̱ ili iꞌya n danai, kpam Tata u va̱ wa ciga yi ta̱. Mpa dem ma ciga yi ta̱, kpam n wenike yi ko mpa yayi.” ");
INSERT INTO kdlNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Aku Yahuza (shegai Yahuza Isikariyoti wa), u danai, “Asheku, ndya i zuwai vu foɓusoi vu wenike kaci ka vunu ara tsunu, bawu va wenike kaci ka vunu a asu u ama a likimba a ɗa a buwai?” ");
INSERT INTO kdlNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu wushuki, “Ama a ciga mu baci, a ka yan ta̱ ili iꞌya n tonuko le a yain. Tata u va̱ wa ciga le ta̱, aku tsu tuwa̱ ara le tsu dusuku n ele. ");
INSERT INTO kdlNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Shegai uza ɗa baci bawu wa ciga mu, u tsu yan ili iꞌya n danai wa. Ili iꞌya i panai n danai na vi, ara va̱ ɗa i wuta̱i wa, shegai ara Tata ɗa u suku mu. ");
INSERT INTO kdlNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“N tonuko ɗa̱ ta̱ ili i na yi tun ma̱ri kaɓolo n a̱ɗa̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kaɓa̱ngi ki ka wenishike ɗa̱ ta̱ ili dem, kpam wa zuwa ɗa̱ ta̱ i ciɓa gba̱ ili iꞌya n tonuko ɗa̱. Kaɓa̱ngi ka nala ki aya Kulu Keri ka Tata wa suku n kala ka va̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","N zuwa ɗa̱ ta̱ i panai maza̱nga̱ a atakasuvu a ɗe. Icun i maza̱nga̱ ma ma̱ri a katakasuvu ka va̱ ka ma zuwa ɗa̱ i tsa̱ra̱. N zuwa ɗa̱ i tsa̱ra̱ ndishi n shinga n na mi dere tyoku ɗa ama a likimba a zuwa ɗa̱ i tsa̱ra̱i wa. Adama a nala kotsu i namgba katsuma̱ ko i pana uwonvo wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“I pana̱ka mu ta̱ an n danai ma laza ta̱ kpam ma bana ta̱ ma gono ara ɗe. Ya ciga mu baci mayun, u gan ta̱ i yain maza̱nga̱ ma ma gono ara Tata, kpaci u la mu ta̱ tsupige. ");
INSERT INTO kdlNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","N tonuko ɗa̱ ta̱ ili i na yi gba̱ gogo‑na kahu i tuwa̱ i gita̱, tsa̱ra̱ i gita̱ baci, i wushuku. ");
INSERT INTO kdlNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ma ɓa̱ra̱kpa̱ n a̱ɗa̱ na̱ n dansi wa, kpaci uza ɗa wa lya tsugono tsu likimba u naha wa̱ ta̱ a utuwa̱. Shegai wa̱ n ucira a kaci ka va̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ili iꞌya Tata u va̱ u tonuko mu n yain iꞌya n tsu yan, tsa̱ra̱ ya dem a likimba u reve ma ciga yi ta̱. “Gogo‑na tuwa̱i tsu walai.” ");
INSERT INTO kdlNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesu lyai kapala n kadyanshi n atoni a ne, “Mpa kami ka katyaci ka mayun. Tata u va̱ u ɗa kacimbi. ");
INSERT INTO kdlNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Katyangi ka baci ka̱ri a asuvu a va̱ bawu ka matsai, aku u kapa ka. U tsu gyara ta̱ kpam u lapula katyangi ka baci dem ka matsa̱sa tsa̱ra̱ ka doku ka matsa cika. ");
INSERT INTO kdlNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ili iꞌya n tonuko ɗa̱ i zuwa ta̱ i lapulai. ");
INSERT INTO kdlNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ya rongo baci kaɓolo na̱ mpa, ma rongo ta̱ dem kaɓolo n a̱ɗa̱. Katyangi ka tsu matsa n kaci ka ne wa. Kafuɗa ta̱ ka matsa ka̱ baci kaɓolo n kami ka ne. Nala dem eɗa̱ ya fuɗa ya yan ili wa, she iꞌa̱ kaɓolo na̱ mpa. ");
INSERT INTO kdlNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Mpa kami ka katyaci ki, eɗa atyangi. Uza ɗa baci wa rongo kaɓolo na̱ mpa, mpa kpam ma rongo kaɓolo n eyi, wa matsa ta̱ ilimaci cika. Shegai ya fuɗa ya yan ili wa, she n ɓa̱nga̱ ɗa̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Uza ɗa baci bawu wa̱ri kaɓolo na̱ mpa, wa̱ ta̱ tyoku u katyangi ka a varangi aku ka ekpei. Ama a tsu bidya ta̱ atyangi a ekpi tsa̱ra̱ a varangu a ɗa a akina, a runukpa a ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","I rongo baci kaɓolo na̱ mpa kpam i tonoi uwenishike u va̱, ya folo ta̱ Tata ili iꞌya baci dem ya ciga, eyi kpam wa na̱ka̱ ɗa̱ ta̱ iꞌya. ");
INSERT INTO kdlNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ya matsa̱sa baci ilimaci ushani, nala wa wenike ta̱ ama eɗa̱ atoni a va̱ a ɗa, kpam ya wenike ta̱ ama tsupige tsu Tata u va̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Ma ciga ɗa̱ ta̱ tyoku ɗa dem Tata wa ciga mu. Gogo‑na rongoi a asuvu a ucigi u va̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","I yan baci ili iꞌya n danai, ya rongo ta̱ a asuvu a uciga u va̱. Tyoku ɗa n yain ili iꞌya Tata u va̱ u tonuko mu n yain, kpam ma rongo a asuvu a uciga u ne. ");
INSERT INTO kdlNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","N tonuko ɗa̱ ta̱ ili i nala yi tsa̱ra̱ i tsa̱ra̱ maza̱nga̱ ma dem n tsa̱ra̱i, kotsu maza̱nga̱ ma ɗe ma namba ili wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ili iꞌya ma tonuko ɗa̱ i yain iꞌya na: Cigai atoku a ɗe tyoku ɗa dem mpa n ciga ɗa̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Vuma u kuwa̱ baci adama a kaje ka ne, nala wenike ta̱ an wa̱ri n uciga u pige u ɗa u lai u ya dem. ");
INSERT INTO kdlNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Eɗa̱ aje a va̱ a ɗa, i tono baci ili iꞌya n danai. ");
INSERT INTO kdlNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","N buwa ɗa̱ kpam uꞌisa̱ agbashi wa, adama a ɗa uzakuwa u tsu tonuko agbashi a ne ili gba̱ wa. Shegai n isa̱ ɗa̱ ta̱ aje kpaci n tonuko ɗa̱ ta̱ gba̱ ili iꞌya Tata u va̱ u tonuko mu. ");
INSERT INTO kdlNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","I ɗanga̱sa mu wa, mpa n ɗanga̱sa ɗa̱. Kpam n na̱ka̱ ɗa̱ manyan ma na i yain: walai i ba i matsa ilimaci, icun i ilimaci iꞌya ya ɓa̱ra̱kpa̱. Aku Tata u na̱ka̱ ɗa̱ gba̱ ili iꞌya baci dem i foloi n kala ka va̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ili iꞌya n tonuko ɗa̱ i yain iꞌya na: Cigai atoku a ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ama a likimba a na a kovo ɗa̱ baci, ciɓai a gita̱ ta̱ a kovo mu. ");
INSERT INTO kdlNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Eɗa̱ aza a likimba a ɗa baci, wa ciga ɗa̱ ta̱ tyoku ɗa u tsu ciga ama a ne. Shegai n ɗanga̱sa ɗa̱ ta̱ a asuvu a likimba, kotsu i woko ama a ne wa. Ɗa i zuwai likimba u kovo ɗa̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ciɓai ili iꞌya n tonuko ɗa̱: Kagbashi ka tsu la uzakuwa u ne tsupige wa. Ama a yanka mu baci mavura, a ka yanka ɗa̱ ta̱ dem. Kpam a yan baci ili iꞌya n wenishike le, a ka yan ta̱ dem ili iꞌya ya tonuko le. ");
INSERT INTO kdlNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Shegai a ka yan ɗa̱ ta̱ mavura adama a ɗa iꞌa̱ri ama a va̱. A ka yan ta̱ nala kpaci a reve uza ɗa u suku mu wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","A da baci n tuwa̱i n dansai n ele wa, aꞌa̱ri a ka yan n unyushi u unyushi u cingi wa. Shegai gogo‑na aꞌa̱ n ure u uwuta̱ a unyushi u cingi u le wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Uza ɗa baci dem u kovo mu, u kovo ta̱ dem Tata u va̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","N yan ta̱ ikunesavu cika iꞌya bawu uza kotsu u yain. A da baci ma̱ri n yain manyan ma nala wa, aꞌa̱ri a ka yan n unyushi u unyushi u cingi wa. Shegai gogo‑na a wene ta̱ ili iꞌya n yain, gba̱ n nala a kovo mu n Tata u va̱ dem. ");
INSERT INTO kdlNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nala gita̱ ta̱ tsa̱ra̱ ili iꞌya iꞌa̱ri ukorongi a Mele ma le i woko mayun: ‘A kovo mu bawu kagita̱.’ ");
INSERT INTO kdlNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ma sukunku ɗa̱ ta̱ uza ɗa a ka isa̱ Kaɓa̱ngi. Wa wuta̱ ta̱ a asu u Tata, aku u tuwa̱ ara ɗe. Aya Kulu ku mayun. U tuwa̱ baci, wa dansa ta̱ ukuna u va̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Eɗa̱ dem u ka̱na̱ ta̱ i tonuko ama ukuna u va̱, kpaci i rongo ta̱ kaɓolo na̱ mpa tun aꞌayin a ɗa n gita̱i uwenishike.” ");
INSERT INTO kdlNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yesu lyai kapala n kadyanshi, “N tonuko ɗa̱ ta̱ ukuna u na kotsu i a̱sa̱ka̱ uwushukusu na̱ mpa wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","A ka loko ɗa̱ ta̱ a agata a Kashila̱. Kpam aꞌayin a ka tuwa̱ ta̱ a ɗa ama a ka wunusa ɗa̱, a yan baci nala a ka wene ta̱ yavu Kashila̱ ka a ka gbashika. ");
INSERT INTO kdlNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","A ka yansa ta̱ ikuna i nala yi kpaci a reve Tata vi wa, kpam a reve mu wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Shegai n tonuko ɗa̱ ta̱ ukuna u na vi ga̱mpa̱, tsa̱ra̱ aꞌayin yi a rawa baci a ɗa a ka yan ikuna i nala yi, ya ciɓa ta̱ ili iꞌya n tonuko ɗa̱. “Aꞌayin a ɗa n gita̱i uwenishike, n tonuko ɗa̱ ili i na yi wa, adama a ɗa ma̱ri kaɓolo n a̱ɗa̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Gogo‑na ugono u ɗa mu a asu u uza ɗa u suku mu. Shegai ko uza a asuvu a ɗe wa̱ la u wece mu, ‘Nte va bana?’ wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Gogo‑na an n tonuko ɗa̱, atakasuvu a ɗe a shaɗangu ɗe n unamgbukatsuma̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Shegai ukuna u mayun u ɗa ma tonuko ɗa̱, wa laka ɗa̱ ta̱ tsulobo n laza. N laza baci, ma sukunku ɗa̱ ta̱ Kaɓa̱ngi ki. Shegai n laza baci wa, Kaɓa̱ngi ka nala ki ka tuwa̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Aꞌayin a ɗa baci Kaɓa̱ngi ki ka tuwa̱i, wa wenike ta̱ ama a likimba an a nusai a udani u ɗa a danai, ‘Tsu reve ta̱ n ukuna u unyushi u cingi, tsu reve ta̱ kpam n ili iꞌya iꞌa̱ri dere, n tyoku ɗa Kashila̱ ka tsu yanka unyushi u cingi afada.’ ");
INSERT INTO kdlNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","A nusa ta̱ a ukuna u unyushi u cingi, adama a ɗa bawu a wushuki na̱ mpa. ");
INSERT INTO kdlNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","A nusa ta̱ a ukuna u ili iꞌya iꞌa̱ri dere, kpaci a asu u Tata u ɗa ma bana kpam ya doku ya wene mu wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","A nusa ta̱ a ukuna u afada, kpaci Kashila̱ ka kiɗa̱ga ɗe uza ɗa wa lya tsugono tsu likimba u na ugana. ");
INSERT INTO kdlNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ma̱ ta̱ n ili ushani iꞌya ma ciga n tonuko ɗa̱, shegai gogo‑na i la ta̱ ucira u ɗa ya reve. ");
INSERT INTO kdlNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Aꞌayin a ɗa baci Kulu ka ku tsu wenike ukuna u mayun u Kashila̱ ku tuwa̱i, ka zuwa ɗa̱ ta̱ i reve gba̱ ikuna i mayun iꞌya i tsu wuta̱ a asu u Kashila̱. Wa dansa ili iꞌya i wuta̱i ara ne wa, shegai u dansa ili iꞌya u panai koshi, kpam wa tonuko ɗa̱ ta̱ ili iꞌya ya tuwa̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Wa na̱ka̱ mu ta̱ tsupige, kpaci wa bidya ta̱ ili iꞌya n danai u tonuko ɗa̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Gba̱ ili iꞌya Tata wa̱ri n iꞌya, i va̱ iꞌya dem. Ɗa gai i zuwai n danai Kulu ka bidya ta̱ ili iꞌya n danai u tonuko ɗa̱ vi. ");
INSERT INTO kdlNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Aꞌayin kenu ya wene mu wa, a yan baci aꞌayin kenu kpam aku i doku i wene mu.” ");
INSERT INTO kdlNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Aza roku a asuvu a atoni a ne a ka dansa utyoku u le, “Ndya kalen ka kadyanshi ka Yesu danai vi, ‘Aꞌayin kenu ya wene mu wa, a yan baci aꞌayin kenu kpam aku i wene mu.’ Kpam ndya kalen ka u danai ‘Adama a ɗa ma gono a asu u Tata’?” ");
INSERT INTO kdlNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","A doki a wecikei, “Ndya kalen ka ‘aꞌayin kenu yi’? Tsu reve ili iꞌya wa tono wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu reve ta̱ atoni yi a ka ciga ta̱ a yan yi keci a ukuna vi, aku u tonuko le, “Kaci ka ɗe ka ya wecemgbenishe an n danai, ‘Aꞌayin kenu ya wene mu wa, a yan baci aꞌayin kenu kpam aku i wene mu’? ");
INSERT INTO kdlNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mayun n tonuko ɗa̱, ya sa̱ ta̱ kpam i namgba katsuma̱, shegai likimba wa pele ta̱. Ya namgba ta̱ katsuma̱, shegai unamgbukatsuma̱ u ɗe wa woko ta̱ maza̱nga̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Aꞌayin a ɗa baci uka wa matsa, u tsu pana ta̱ mɓa̱la̱, kpaci aꞌayin a ilimaci a ne a rawa ɗe. Shegai u kotso baci ilimaci yi, aku u a̱sa̱nsa̱ na̱ mɓa̱la̱ mi, adama a ɗa wa̱ri ipeli an u matsai maku mi a likimba. ");
INSERT INTO kdlNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nala dem wa̱ri ara ɗe. Gogo‑na i namgba ta̱ katsuma̱, shegai ma doku ta̱ ma wene ɗa̱, kpam i yain maza̱nga̱ ma bawu ko uza wa fuɗa wa shamkpa ɗa̱ ma. ");
INSERT INTO kdlNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Aꞌayin a nala a rawa baci, ya yan mu keci wa. Mayun n tonuko ɗa̱, Tata u va̱ wa na̱ka̱ ɗa̱ ta̱ gba̱ ili iꞌya baci i foloi n kala ka va̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kotsu i folo icun ili i na caupa wa. Rongoi ufoluso, Kashila̱ ka na̱ka̱ ɗa̱ ta̱ iꞌya, tsa̱ra̱ i shaɗangu n ipeli. ");
INSERT INTO kdlNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“N yan ta̱ kadyanshi ka na ki n agisani, shegai aꞌayin a ka tuwa̱ ta̱ a ɗa bawu ma doku ma yan nala. Aku n tonuko ɗa̱ gba̱ ikuna i Tata karara. ");
INSERT INTO kdlNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ya folo ta̱ Tata vi n kala ka va̱, shegai u ka̱na̱ mpa n foluko ɗa̱ Tata vi wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Kashila̱ Tata u ciga ɗa̱ ta̱ adama a ɗa ya ciga mu, kpam i wushuki an ara ne ɗa n wuta̱i. ");
INSERT INTO kdlNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Asu u Tata u ɗa n wuta̱i, aku n tuwa̱i a likimba. Gogo‑na kpam ma a̱sa̱ka̱ likimba n gono a asu u Tata.” ");
INSERT INTO kdlNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Atoni yi a danai, “Gogo‑na ɗa va dansa n a̱tsu karara! N agisani a ɗa kpam va dansa wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Gogo‑na ɗa tsu revei an vu revei ili gba̱. Va wushunku ta̱ uza keci ku ne tun kahu gba̱m u wecike. Nala u zuwa tsu ta̱ tsu wushuki an a asu u Kashila̱ u ɗa vu wuta̱i.” ");
INSERT INTO kdlNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu wushuki, “Mayun ɗa i wushuki gogo‑na vi? ");
INSERT INTO kdlNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Aꞌayin a ka tuwa̱ ta̱, kpam gba̱m a rawa ɗe, a ɗa a ka wacinsa ɗa̱ gba̱ ɗe, ya dem u gono a kuwa ku ne, aku i a̱sa̱ka̱ mu utyoku u va̱. Shegai Tata wa rongo ta̱ kaɓolo na̱ mpa, adama a nala ma rongo utyoku u va̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“N tonuko ɗa̱ ta̱ ikuna i na yi tsa̱ra̱ i tsa̱ra̱ ipeli i maci adama a ɗa i wokoi ili i te na̱ mpa! Likimba wa zuwa ɗa̱ ta̱ i pana ikyamba, shegai kotsu i gbama asuvu, kpaci n lya ta̱ kaci ka ucira u likimba.” ");
INSERT INTO kdlNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","An Yesu kotsoi udansa gba̱ ili i na yi, u weɓelei zuba u danai, “Tata, aꞌayin a yan ɗe. Na̱ka̱ Maku ma vunu tsupige, tsa̱ra̱ Maku mi dem ma na̱ka̱ vu tsupige. ");
INSERT INTO kdlNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Vu na̱ka̱ ta̱ Maku mi ucira a kaci ka ama gba̱, tsa̱ra̱ Maku mi ma na̱ka̱ uma u ɗa bawu wa̱ri n utyoku a asu u aza ɗa vu na̱ka̱ yi gba̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ure u utsa̱ra̱ uma u ɗa bawu wa̱ri n utyoku u ɗa na: a reve vu, uza ɗa wa̱ri Kashila̱ ka mayun koshi, kpam a reve Yesu Kawauwi, uza ɗa vu suki. ");
INSERT INTO kdlNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","N wenike ta̱ tsupige tsu vunu a likimba an n kotsoi manyan ma vu na̱ka̱ mu n yain. ");
INSERT INTO kdlNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Gogo‑na Tata, doku vu na̱ka̱ mu tsupige tsa ma̱ri n tsa an ma̱ri kaɓolo n avu kahu a yain likimba. ");
INSERT INTO kdlNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Vu na̱ka̱ mu ta̱ atoni a roku pini a likimba u naha, kpam n wenike le ta̱ tyoku ɗa va̱ri. Aza a vunu a ɗa caupa, shegai vu na̱ka̱ mu n ele, kpam a gorimuko ta̱ kadyanshi ka vunu. ");
INSERT INTO kdlNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","A reve ta̱ vu na̱ka̱ mu gba̱ ili iꞌya ma̱ri n iꞌya. ");
INSERT INTO kdlNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kpaci n tonuko le ta̱ ili iꞌya vu tonuko mu, kpam a wushuku ta̱ n iꞌya. A reve ta̱ n wuta̱i ara vunu, kpam a wushuku ta̱ an aɗa vu suku mu. ");
INSERT INTO kdlNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ma̱ le ta̱ uyanka kavasu. Aza a likimba a ɗa ma̱ri uyanka kavasu wa, shegai aza ɗa vu na̱ka̱ mu, adama a ɗa aꞌa̱ri aza a vunu. ");
INSERT INTO kdlNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Gba̱ ama a nala yi aza ɗa aꞌa̱ri atoni a va̱ aza a vunu a ɗa, kpam gba̱ aza ɗa aꞌa̱ri atoni a vunu aza a va̱ a ɗa dem. Mayun a wenike ta̱ tyoku ɗa tsupige tsu va̱ tsa̱ri. ");
INSERT INTO kdlNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ma̱ ta̱ utuwa̱ ara vunu. Ma shamgba a likimba kpam wa. Shegai atoni a va̱ a buwa ta̱ ve pini a likimba. Wenike ucira u kala ka vunu; wata, kala ka vu na̱ka̱ mu, tsa̱ra̱ ko ili i sawa le wa. Aku a ɓolomgbono a woko ili i te n atoku a le, tyoku ɗa mpa n avu tsa̱ri ili i te. ");
INSERT INTO kdlNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","N ucira u vunu u ɗa, ucira u ɗa vu na̱ka̱ mu tun ma̱ri a likimba n u ɗa n ɓishinkai ili i sawa le. Ko uza u te u le u puwa̱n wa, shegai uza ɗa u ukai kaci ka ne a asuvu a ukpa̱ vi koshi, tsa̱ra̱ a shaɗangu ili iꞌya Tagara̱da u Kashila̱ u danai. ");
INSERT INTO kdlNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Gogo‑na mpa la a utuwa̱ ara vunu. Shegai n dansa ta̱ ili i na yi tun ma̱ri a likimba, tsa̱ra̱ atoni a va̱ a shaɗangu n maza̱nga̱ tyoku ɗa dem ma̱ri. ");
INSERT INTO kdlNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","N tonuko le ta̱ akani a vunu. Shegai ama a likimba a na a kovo le ta̱, adama a ɗa bawu aꞌa̱ri ili i te n ama a likimba. Tyoku ɗa dem mpa ma̱ri ili i te n likimba wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Tonuko ɗa ma tonuko vu vu wutukpa̱ le a asuvu a likimba vi wa, shegai vu ɓishinka uza u cingi vi u sawa le. ");
INSERT INTO kdlNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ma̱ri a asuvu a aza a likimba u na wa, nala dem ele aza a likimba a ɗa wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Gonuko le sarara vu wulukpe le a asu u uwenishike u akani a vunu a ɗa aꞌa̱ri a mayun. ");
INSERT INTO kdlNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","N suku le ta̱ a likimba, tyoku ɗa dem vu suku mu a likimba. ");
INSERT INTO kdlNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","N neke ta̱ kaci ka va̱ n gbashika vu kotsu ele dem a neke kaci ka le a gbashika vu. ");
INSERT INTO kdlNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“N yanka ta̱ atoni a nala yi kavasu, kpam dem ma yanka ta̱ aza ɗa a ka tuwa̱ a wushuku na̱ mpa kavasu adama a ili iꞌya atoni a va̱ a ka tonuko le a kaci ka va̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ma ciga ta̱ gba̱ le a woko ili i te n atoku, tyoku ɗa ma̱ri ili i te n avu, avu kpam ili i te na̱ mpa. Ma ciga ta̱ dem a woko ili i te n a̱tsu. Ama a likimba kpam a ka wushuku ta̱ an a ɗa vu suku mu. ");
INSERT INTO kdlNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","N na̱ka̱ ta̱ ama a na tsupige tsa vu na̱ka̱ mu tsa̱ra̱ a woko ili i te, tyoku ɗa mpa n avu tsa̱ri ili i te. ");
INSERT INTO kdlNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mpa ili i te iꞌya ma̱ri n ele, avu kpam ili i te iꞌya va̱ri na̱ mpa, tsa̱ra̱ a woko ili i te gba̱. Tsa̱ra̱ ama a likimba a reve an aɗa vu suku mu. A reve kpam an va ciga atoni a va̱ tyoku ɗa va ciga mu. ");
INSERT INTO kdlNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tata, vu na̱ka̱ mu ta̱ ama a na yi, kpam ma ciga le ta̱ a rongo a asu u ɗa ma̱ri, tsa̱ra̱ a wene tsupige tsu va̱, tsupige tsa vu na̱ka̱ mu adama a ɗa va ciga mu kahu uyan u likimba. ");
INSERT INTO kdlNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Tata, aɗa va̱ri uza u shinga. Likimba reve vu wa, shegai n reve vu ta̱, kpam ama a na a reve ta̱ an vu suku mu. ");
INSERT INTO kdlNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","N wenike le ta̱ tyoku ɗa va̱ri, kpam ma lya ta̱ kapala n uyansa nala. Kotsu a cigamgbana dere tyoku ɗa vu ciga mu, tsa̱ra̱ n ɓolomgbono n ele.” ");
INSERT INTO kdlNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","An Yesu kotsoi kavasu, aku a lazai kaɓolo n atoni a ne a pasai Kara̱ra̱ ka Kidiron. A rawai a asu u ɗa wa̱ri na̱ nɗanga n zayitum ushani, aku a uwai pini. ");
INSERT INTO kdlNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","A tsu bansa ta̱ pini asu u vi, adama a nala a ɗa i zuwai Yahuza, uza ɗa u nekei Yesu u revei asu u ɗa aꞌa̱ri. ");
INSERT INTO kdlNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Aɗara̱kpi a pige n Afarishi a roku a suki aza a uwundya u Kuwa ku Kashila̱ tsa̱ra̱ a soku Yahuza. Kaɓolo ka asoje ka aza a Roma ka dem pini, ama a na yi aꞌa̱ ta̱ uɓa̱ni n iwunukatsu na̱ ncikalu, n ava̱su. Yahuza ɗa tonoi n ele hal ubana a asu vi. ");
INSERT INTO kdlNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu reve ta̱ gba̱ ili iꞌya ya gita̱ n eyi, aku u raɓai a kapala u wece le, “Ya ya zama?” ");
INSERT INTO kdlNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","A wushuki, “Yesu uza u Nazara.” U wushunku le, “Mpa Yesu!” (Yahuza uza ɗa u kpatala̱kai Yesu vi, wa̱ ta̱ kushani pini n asoje yi.) ");
INSERT INTO kdlNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","An u tonuko le, “Mpa gai vi,” aku a ba̱tsa̱i n kucina̱cina̱ hal a rukpusa̱i a iyamba. ");
INSERT INTO kdlNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","U doku wece le, “Ya ya zama?” A danai “Yesu uza u Nazara.” ");
INSERT INTO kdlNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","U wushunku le, “N tonuko ɗa̱ ɗe mpa gai Yesu vi. Mpa baci ya zama vi, a̱sa̱ka̱i atoni a va̱ a laza.” ");
INSERT INTO kdlNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Nala gita̱ ta̱ tsa̱ra̱ ili iꞌya u danai caupa i woko mayun: “N puwunsa̱ ko uza u te a asuvu a aza ɗa vu na̱ka̱ mu wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Aku Simo Bituru talai burundu u ne u kapamgbanai kutsuvu ku ulyaki ku kagbashi ka Magono ma Aɗara̱kpi. (Kala ka kagbashi ki ka Mala̱ku.) ");
INSERT INTO kdlNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu tonukoi Bituru, “Gonuko burundu vi a ivin i ne. Va wundya ma wushuku n soi mako ma upana ikyamba tyoku ɗa Tata u va̱ u foɓusoi wa?” ");
INSERT INTO kdlNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Uzapige u kuvon† u Roma n asoje a ne, kaɓolo n aza a uwundya u Kuwa ku Kashila̱ a ka̱na̱i Yesu aku a sira yi. ");
INSERT INTO kdlNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","A gita̱ a banka yi ara Hanana, koku u Kayafa, uza ɗa wa̱ri Magono ma Aɗara̱kpi a kayen ki. ");
INSERT INTO kdlNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafa ɗa wa̱ri u tonukoi azapige a aza a Yahuda caupa, u da, “Wa la ta̱ tsulobo uza u te u na vi u kuwa̱ n u ɗa a ama gba̱ a ka kuwa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simo Bituru n katoni ka roku a tonoi Yesu. Katoni ki n Magono ma Aɗara̱kpi mi a revemgbene ta̱, adama a nala u uwa ta̱ pini a ulanga u kuwa ku Magono ma Aɗara̱kpi mi kaɓolo n Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Shegai Bituru vana yi pini a utsutsu u kuwa vi. Aku katoni ki ka gonoi ka dansai n makere ma ma̱ri kagbashi uza ɗa wa̱ri a utsutsu. Aku u a̱sa̱ka̱i Bituru uwai, ");
INSERT INTO kdlNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","makere mi ma wece yi, “Avu dem katoni ka Yesu ka, ko nala wa?” Bituru wushuki, “Nala wa, mpa wa!” ");
INSERT INTO kdlNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Aꞌayin yi a ka yan ta̱ kuta̱nu, aku agbashi yi n aza a uwundya u Kuwa ku Kashila̱ a tasuki akina a ka lyashuku. Pini nala, Bituru banai dem u shamgbai tsa̱ra̱ u lyashuku. ");
INSERT INTO kdlNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Magono ma Aɗara̱kpi ma yansai Yesu keci a kaci ka atoni a ne n uwenishike u ne. ");
INSERT INTO kdlNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu wushuki, “N yansa ta̱ kadyanshi tsa̱ra̱ ya dem pana. N rongo ta̱ uwenishike a agata a Kashila̱ n Kuwa ku Kashila̱, a asu u ɗa gba̱ aza a Yahuda a tsu ɓolomgbono. N tsu dana ili ukpawunsi wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Niɗa va yan mu keci ku na? Wece ama ɗa a panai uwenishike u va̱. A reve ta̱ ili iꞌya n dansai.” ");
INSERT INTO kdlNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","An Yesu danai nala, aku uza ɗa wa wundya Kuwa ku Kashila̱ ki u ɓasa yi, u danai, “Ya va̱ri hal va dansa n Magono ma Aɗara̱kpi naha?” ");
INSERT INTO kdlNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu wushuki, “N dana baci ili i roku iꞌya Mele ma danai i gan wa, she i dana iꞌya. Shegai ili iꞌya n danai mayun ɗa baci, niɗa u ɓasa mu?” ");
INSERT INTO kdlNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Yesu pini usiri, aku Hanana tutsuku yi ara Kayafa Magono ma Aɗara̱kpi. ");
INSERT INTO kdlNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Aꞌa̱ri pini, Simo Bituru pini kushani evu n akina n u lyashuki, aku a wece yi, “Avu dem katoni ka Yesu ka, ko nala wa?” Shegai Bituru nanai u danai, “Nala wa, mpa wa!” ");
INSERT INTO kdlNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Kagbashi ka Magono ma Aɗara̱kpi ka roku ka pini dem a asu vi. Kumaci ku vuma ɗa a kapai kutsuvu. U danai, “Yavu va da n wene vu ta̱ a asu u nɗanga n zayitum kaɓolo n eyi, ko n wene vu wa?” ");
INSERT INTO kdlNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Aku Bituru doki u nanai, kute‑kute kapen ka salai. ");
INSERT INTO kdlNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kayafa kotsu ta̱ uyanka Yesu afada n kpasani. Aku a banka yi ara Bilatu, gomuna a asuvu a tsugono tsu Roma. Shegai ama yi a uwa pini a kuwa ki wa. A da baci uza roku a asuvu a le wa̱ri u uwai pini, wa̱ri wa woko ta̱ n ashinda̱, kpam Mele ma a̱sa̱ka̱ yi u lyai ilikulya i Abiki a Upasamgbana wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Aku Bilatu wuta̱i a uwotsu vi u wece le, “Kadyanshi ka eni ka i tukoi vuma u na n ka?” ");
INSERT INTO kdlNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","A wushuki, “A da baci vuma u na wa̱ri uza u unyushi wa, tsa̱ra̱ tsa tuko yi ara vunu wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Bilatu tonuko le, “Bidya ni n kaci ka ɗe i ba i yanka yi afada tyoku ɗa Mele ma ɗe ma danai i yanka yi.” Aku a wushuki, “Eɗa̱ aza a Roma i tsu a̱sa̱ka̱ tsu tsu zuwa a wuna vuma wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ili iꞌya a danai i wenike ta̱ kadyanshi ka Yesu yain a ukuna u tyoku ɗa wa kuwa̱, wa woko ɗe mayun. ");
INSERT INTO kdlNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Aku Bilatu gonoi a kuwa ku tsugono tsi, u isa̱i Yesu u wece yi, “Avu magono ma aza a Yahuda ma?” ");
INSERT INTO kdlNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","U wushunku yi, “Keci ku vunu ka na vi, ko gai aza roku a ɗa a tonuko vu ukuna u va̱?” ");
INSERT INTO kdlNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Bilatu wece yi, “Vu reve ta̱ gai mpa uza u Yahuda ɗa wa! Ama a vunu a ɗa n aɗara̱kpi a pige a vunu alya a na̱ka̱ mu n avu. Ndya vu yain?” ");
INSERT INTO kdlNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","U wushuki, “Tsugono tsu va̱ tsu likimba u na tsa wa. A da baci tsu likimba u na tsa, agbashi a va̱ a ka shila̱ka̱na̱ ta̱ tsa̱ra̱ a ɓishinka ama a neke mu a akere a azapige a aza a Yahuda a na. Mpa tyoku u ngono n ɗa ma lya tsugono tsu likimba u na ɗa ma̱ri wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Bilatu wece yi, “Dana avu magono ma?” U wushuki, “Vu dana ta̱ mpa magono ma, kpam vu dana ta̱ mai. Adama a nala a ɗa a matsa mu kpam adama a nala a ɗa n tuwa̱i a likimba tsa̱ra̱ n tonuko ama ukuna u mayun. Kpam gba̱ uza ɗa wa ciga ukuna u mayun u tsu pana̱ka mu ta̱.” ");
INSERT INTO kdlNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Bilatu wece yi, “Ndya ukuna u mayun vi?” An Bilatu danai nala, aku u lazai ubana a asu u aza a Yahuda yi u tonuko le, “Vuma u na u yan ili i roku iꞌya i rawai ma dana, ‘U ka̱na̱ ta̱ u kuwa̱’ wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","I reve ta̱ gai n tsu a̱sa̱ka̱ ta̱ vuma u te a asuvu a kuwa ku aꞌali aꞌayin a Abiki a Upasamgbana dem. Ya ciga n a̱sa̱nka̱ ɗa̱ ‘magono ma aza a Yahuda ɗa’?” ");
INSERT INTO kdlNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","A worukpoi, “Aꞌa, eyi na wa! Baraba ɗa tsa ciga.” (Baraba tani uza u maga̱la̱ka̱ ɗa.) ");
INSERT INTO kdlNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pini nala, Bilatu zuwai asoje a ba a bawin Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","A cacai funi u awana kakondori aku a ukunkai yi a kaci, a ukunka yi kunya ku mini ma galura. ");
INSERT INTO kdlNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","A tuwusa̱i ara ne n a dansi, “Uma u vunu u ɓa̱ra̱kpa̱, magono ma aza a Yahuda!” A rongo yi kpam u ɓasa̱sa a upetiwaꞌeshi. ");
INSERT INTO kdlNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Bilatu doki u banai a uwotsu vi u tonukoi ama yi, “Panai, ma tuko yi ta̱ pini naha tsa̱ra̱ n wenike an bawu n tsa̱ra̱i unyushi u ɗa u rawai n wuna yi.” ");
INSERT INTO kdlNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Aku Yesu wuta̱i, uꞌuki n funi u awana n kunya ku mini ma galura. Bilatu tonuko le, “Vuma ɗa ɗa̱ na!” ");
INSERT INTO kdlNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","An aɗara̱kpi a pige n aza a uwundya u Kuwa ku Kashila̱ a wene yi, aku a salai, “Wandamgbana ni! Wandamgbana ni!” Shegai Bilatu wushunku le, “Eɗa̱ bidya ni i ba i wandamgbana. N tsa̱ra̱ yi n unyushi u ɗa u rawai n wuna yi wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Azapige a aza a Yahuda yi a wushuki, “U da aya Maku ma Kashila̱. Adama a nala, Mele ma tsunu ma dana ta̱ u kuwa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","An u panai nala, aku u doki u giruwa̱i cika. ");
INSERT INTO kdlNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","U doki u gonoi a asuvu u wecei Yesu, “Nte vu wuta̱i?” Shegai u wushunku yi wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Bilatu danai, “Va wushunku mu wa? Ciɓa, ma̱ ta̱ n ucira u ɗa ma zuwa a a̱sa̱ka̱ vu ko kpam a wandamgbana vu.” ");
INSERT INTO kdlNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu wushunku yi, “Va fuɗa ta̱ va zuwa ama a yanka mu ili iꞌya vu zuwa le adama a ɗa Kashila̱ ka zuwa vu vu fuɗa vu yain nala. Vuma ɗa u zuwai a tuko mu ara vunu u la vu ta̱ unyushi u cingi.” ");
INSERT INTO kdlNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","An Bilatu panai nala, aku wa ciga u a̱sa̱ka̱ Yesu. Shegai azapige a aza a Yahuda yi a rongoi isali, “Vu a̱sa̱ka̱ baci vuma u na, vu buwa kpam kaje ka Kaisa Magono wa! Uza ɗa baci dem u gonukoi kaci ka ne magono, utokulalu u Kaisa ɗa!” ");
INSERT INTO kdlNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","An Bilatu panai ili iꞌya aꞌa̱ri utono, aku u wutukpa̱i Yesu a ulanga u ɗa a ka isa̱ Ulanga u ɗa a Kira̱i n Atali (N Tsiꞌarama tani “Gabata”). Eyi kpam u dusuki a karatsu ka afada a ulanga u kuwa ku tsugono. ");
INSERT INTO kdlNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","N kaara a kaci ka Kain ka Afoɓi ka Abiki a Upasamgbana ka. Aku Bilatu tonukoi aza a Yahuda yi, “Magono ma ɗe ma na!” ");
INSERT INTO kdlNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Aku a worukpoi cika, “Wuna ni! Wuna ni! Wandamgbana ni!” U wece le, “Ya ciga mu n wandamgbana magono ma ɗe ɗa?” Aɗara̱kpi a pige a wushuki, “Tsa̱ n magono ma roku ma ma wurai Kaisa wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Aku Bilatu na̱ka̱ le Yesu tsa̱ra̱ a ba a wandamgbana yi. Pini nala, asoje yi a bidyai Yesu a lazai n eyi. ");
INSERT INTO kdlNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","An wa wuta̱ a ilyuci yi, aku u cangai mawandamgbani ma ne ubana a asu u ɗa a ka isa̱ Mako ma Kaci. (Asu vi a tsu isa̱ ta̱ u ɗa dem “Golugota”† n Tsiꞌarama). ");
INSERT INTO kdlNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Nte a varai Yesu pini n ikusa. Nala dem a yankai aza a kuwa ku aꞌali a roku ama a re, ya dem a kapashi ka te, Yesu aya a mere ma le. ");
INSERT INTO kdlNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Bilatu zuwa le a zuwa iryoci a mawandamgbani mi. I danai, “YESU UZA U NAZARA, MAGONO MA AZA A YAHUDA.” ");
INSERT INTO kdlNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","A korongu ta̱ iꞌya hal kutatsu: i kagita̱ n Tsiyahuda, n Tsiroma, aku n Tsiheline.† Ama ushani a yan ta̱ iꞌya ka̱neshi, kpaci a asu u ɗa a wandamgbanai Yesu vi, wa̱ri mɓa̱ri n ilyuci yi wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Aɗara̱kpi a pige a tonukoi Bilatu, “Kotsu vu korongu ‘Magono ma aza a Yahuda wa,’ shegai korongu ‘Vuma u na u danai aya Magono ma aza a Yahuda.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Bilatu wushunku le, “N korongu ta̱ u ɗa nala, kpam nala wa woko.” ");
INSERT INTO kdlNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","An asoje yi a varai Yesu ikusa a mawandamgbani, aku a bidyai aminya a ne a pecei a ɗa a asu u kunishi, kasoje dem ka tsa̱ra̱i ka te. A bidyai dem matogo ma bululu ma ne ma ma̱ri kunya ku te ka a cai ili iꞌya i bidyai a zuba ubana a iyamba. ");
INSERT INTO kdlNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Aku asoje yi a dansai utyoku u le, “Tsa kara ka wa. A̱sa̱ka̱ tsu varanki ka uruta tsa̱ra̱ tsu wene uza ɗa wa tsa̱ra̱ ka.” Nala gita̱ ta̱ tsa̱ra̱ udani u Tagara̱da u Kashila̱ u na u woko mayun: “A pecei aminya a va̱, aku a varanki matogo ma va̱ uruta.” Nala tani asoje yi a yain. ");
INSERT INTO kdlNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Mma u Yesu u shamgba ta̱ a ikengi i mawandamgbani mi kaɓolo n anukakenu a ne, n Meri uka u Kulofa. Meri Magadaliya wa̱ ta̱ dem pini kushani. ");
INSERT INTO kdlNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Katoni ka Yesu wa ciga cika ka dem pini kushani evu na̱ mma u Yesu vi. An Yesu wene le gba̱, u tonukoi mma u ne, “Vuma u na aya maku ma vunu gogo‑na.” ");
INSERT INTO kdlNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","U tonukoi kpam katoni ki, “Mma u vunu u ɗa na gogo‑na.” Pini nala, katoni ki ka bidyai mma vi ubana a kuwa ku ne. ");
INSERT INTO kdlNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu reve ta̱ gogo‑na u kotso ɗe manyan ma ne. Shegai an wa ciga u shaɗangu udani u Tagara̱da u Kashila̱, aku u danai, “Ma pana ta̱ kakuli!” ");
INSERT INTO kdlNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kadele ka pini ushaɗangi n mini ma cinwi ma kalam, aku asoje yi a ukai pini kashaku, a sirai ka a kalangu, a ra̱ɗa̱gba̱i ka ubana a una̱ u ne. ");
INSERT INTO kdlNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","An u comoi ma, aku u danai, “A kotso ɗe.” Aku u varai kaci ka ne a iyamba, pini nala, uma u ne u wuta̱i. ");
INSERT INTO kdlNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kain ka Afoɓi ka, kain ka wansa baci Ashibi kpam a doku ta̱ ka kalen kpaci kain ka Abiki a Upasamgbana ka. An u wokoi aza a Yahuda bawu a ka ciga ikyamba yi i woko pini a mawandamgbani n kain ka Ashibi, a foloi Bilatu tonuko asoje a koɗuso aꞌene a aza ɗa aꞌa̱ri a mawandamgbani mi. Aku kpam a takpusa ikyamba yi a zuba u mawandamgbani mi. ");
INSERT INTO kdlNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Asoje yi a gita̱i a koɗusoi aꞌene a ama a re aza ɗa aꞌa̱ri a apashi a re a Yesu yi. ");
INSERT INTO kdlNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Shegai an a rawai ara Yesu, a cina yi cina u kuwa̱ ɗe, a koɗo aꞌene a ne wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Uza u te a asuvu a asoje yi u bidyai masari ma ne u sapai yi n ma a maɓele. Aku mpasa n mini ma wuta̱i. ");
INSERT INTO kdlNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Tsu reve ta̱ ukuna vi mayun ɗa, kpaci uza ɗa u wenei u ɗa aꞌayin a ɗa ukuna vi u gita̱i aya u danai. U tonuko tsu ta̱ tsa̱ra̱ i wushuku. ");
INSERT INTO kdlNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ukuna vi u gita̱ ta̱ tsa̱ra̱ udani u Tagara̱da u Kashila̱ u woko mayun: “Ko katele ka te ka ne ka̱ la ka koɗo wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Tagara̱da u Kashila̱ kpam dem u dana ta̱, “A ka weɓele ta̱ uza ɗa a sapai n masari.” ");
INSERT INTO kdlNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","An nala wurai, Isuhu u Arimatiya, u wecei Bilatu ko wa a̱sa̱ka̱ u bidya ikyamba i Yesu. (Isuhu katoni ka Yesu ka shegai a ukpawunsi, kpaci wa pana ta̱ uwonvo u azapige a aza a Yahuda.) Bilatu wushuku ta̱, pini nala, Isuhu vi u lazai u ba u cangai ikyamba yi u lazai n iꞌya. ");
INSERT INTO kdlNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimu uza ɗa wa̱ri u tuwa̱i ara Yesu n kayin ki u soku yi ta̱. U tukoi ili i magula̱ni i utsunku akushe icun kure iꞌya i rawai evu n ura̱tsana̱ka amangatawun (100). ");
INSERT INTO kdlNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ama a re a na yi a bidyai ikyamba i Yesu a cacai iꞌya ukyawan n aminya kaɓolo n ili i magula̱ni yi. Tyoku ɗa aza a Yahuda a tsu yan ɗa la vi a ka ciɗa̱ngu baci kakushe. ");
INSERT INTO kdlNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Asu u uwandamgbana̱sa vi wa̱ ta̱ evu n kashina ka nɗanga, a asu u ɗa wa̱ri n kasaun ka savu ka bawu kotsu a zuwai pini uza. ");
INSERT INTO kdlNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","An u wokoi Kain ka Afoɓi ka kahu Abiki a Upasamgbana kpam kasaun ki ka̱ri evu, aku a ukai ikyamba i Yesu pini. ");
INSERT INTO kdlNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","N kpasani ku kain ka kagita̱ ka aꞌayin a shindere; wata, kain ka Aladi, Meri Magadaliya banai a kasaun ki, u wenei a gindala̱kpa ɗe katali ki a giduwa̱i una̱ u kasaun vi. ");
INSERT INTO kdlNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Aku u sumai ugono a asu u Simo Bituru n katoni ka roku, uza ɗa Yesu cigai, u tonuko le, “A bidya ɗe Asheku a kasaun ki, kpam tsu reve a asu u ɗa a zuwa yi wa!” ");
INSERT INTO kdlNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Bituru n katoni ki a lazai ubana a kasaun ki. ");
INSERT INTO kdlNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Aꞌa̱ri ilyaɗi gba̱ le, aku katoni ki ka wurai Bituru u lasa yi urawa pini a kasaun ki. ");
INSERT INTO kdlNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","An u kelikei u weɓelei a asuvu, u wenei aminya a kaciɗa̱ yi uzuwi, shegai u uwa pini wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Aku Simo Bituru rawai u uwai pini a asuvu. U wenei aminya a kaciɗa̱ yi uzuwi. ");
INSERT INTO kdlNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Aku kpam u wenei kakashi ka a pala̱kai upetiwaꞌeshi u Yesu vi, a ka̱ta̱la̱i ka a asu u ne kau. ");
INSERT INTO kdlNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Aku katoni ka ka gita̱i urawa a kasaun ki, eyi dem u uwai. U wenei kpam u wushuki Yesu ꞌya̱nga̱ ɗe a ukpa̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Kotsu aꞌa̱ri a reve an Tagara̱da u Kashila̱ u danai u ka̱na̱ ta̱ Yesu ꞌya̱nga̱ a ukpa̱ wa.) ");
INSERT INTO kdlNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Aku atoni yi a gonoi a kuwa. ");
INSERT INTO kdlNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Shegai Meri shamgbai a ulanga u kasaun vi, n u sa̱yi. U kelikei u weɓelei a asuvu a kasaun ki. ");
INSERT INTO kdlNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","U wenei atsumate a zuba a re pini, a ukai aminya a eri. Aku a dusuki a asu u ɗa ikyamba i Yesu iꞌa̱ri caupa. Uza u te a asu u kaci uza u te kpam a asu u aꞌene. ");
INSERT INTO kdlNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","A wece yi, “Ndya i zuwai va sa̱?” U wushuki, “A bidya ɗe Asheku a va̱, kpam n reve a asu u ɗa a zuwa yi wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","An Meri danai nala, aku u kpatalai u wenei Yesu kushani pini a asu vi, shegai u reve an aya wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu wece yi, “Ndya i zuwai va sa̱? Ya va zama?” Meri n u wundi uza ɗa wa kirana n kashina ka nɗanga ki aya, aku u danai, “Uzapige, vu bidya baci ikyamba i ne, ma folo vu, tonuko mu tsa̱ra̱ n bana n bidya.” ");
INSERT INTO kdlNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu tonuko yi, “Meri.” Meri kpatalai ara ne u danai, “Rabboni!” (Wata, “kawenishiki ka va̱” n Tsiꞌarama.) ");
INSERT INTO kdlNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu tonuko yi, “Kotsu vu ka̱na̱ mu wa, kpaci kotsu n gono ara Tata wa. Shegai wala vu bana a asu u atoni a va̱ vu tonuko le, ‘Ma gono ta̱ ara Tata u va̱ uza ɗa dem wa̱ri Tata u ɗe. Aya Kashila̱ ka va̱, kpam aya dem Kashila̱ ka ɗe.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Aku Meri Magadaliya gonoi u tonukoi atoni yi u wene ta̱ Asheku. U tonuko le kpam ili iꞌya u tonuko yi. ");
INSERT INTO kdlNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Pini n kayin ka Aladi ka nala ki, atoni yi a ɓolomgbonoi a kunu aku a gida̱kusi itsutsu yi gba̱, kpaci a ka pana ta̱ uwonvo u aza a Yahuda. Aku Yesu uwai u shamgbai a asuvu a le u dana̱sa le, u danai, “Ndishi n shinga n rongo n a̱ɗa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","An u danai nala, aku u wenike le aꞌutsu a ɗa aꞌa̱ri a akere a ne n a maɓele ma ne. Atoni yi a shaɗangu ta̱ n maza̱nga̱ cika an a wenei Asheku. ");
INSERT INTO kdlNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","U doki u danai, “Ndishi n shinga n rongo n a̱ɗa̱. Tyoku ɗa Tata u va̱ u suku mu, nala dem ma suku ɗa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Aku u fula̱ka̱ le kuvi ku ne, u danai, “Wushai Kulu Keri. ");
INSERT INTO kdlNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Aza ɗa baci i cimbusuka̱i unyushi u cingi u le, Kashila̱ dem ka cimbusuka̱ le ta̱, kpam a woko ɗe ucimbusuki. Aza ɗa baci kpam bawu i cimbusuka̱i unyushi u cingi u le, Kashila̱ dem ka cimbusuka̱ le wa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Uza u te a asuvu a Kupanamere yi; wata, Toma (uza ɗa a tsu isa̱ Mapeshe), wa̱ri pini kaɓolo n ele wa, aꞌayin a ɗa Yesu wenikei kaci ka ne vi. ");
INSERT INTO kdlNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","An u rawai, atoni a ɗa a buwai vi a ka tonusuko yi, “Tsu wene ta̱ Asheku!” Shegai Toma danai, “Ma wushuku wa she n wene aꞌutsu a ɗa a vara yi n ikusa yi, n uka pini kujubu ku va̱, kpam n uka kukere ku va̱ a maɓele ma ne.” ");
INSERT INTO kdlNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","An a yain aꞌayin a shindere, aku atoni yi a doki a ɓolomgbonoi a kunu ki, Toma pini dem kaɓolo n ele. A gida̱kusu ta̱ dem itsutsu yi tyoku ɗa a yain caupa, pini nala, Yesu tuwa̱i u shamgbai a mere ma le. U dana̱sa le u danai, “Ndishi n shinga n rongo n a̱ɗa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Aku u tonukoi Toma, “Wene akere a va̱, uka kujubu ku vunu a aꞌutsu yi. Uka kukere ku vunu pini a maɓele ma va̱. A̱sa̱ka̱ ukpa̱ɗa̱ u uwushuku vu wushuku.” ");
INSERT INTO kdlNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma wushuki, “Aɗa Asheku a va̱ n Kashila̱ ka va̱.” ");
INSERT INTO kdlNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Aku Yesu tonuko yi, “Vu wushuku ta̱ an u wokoi vu wene mu. Aza ɗa a wushuki bawu a wene mu, a ka yan ta̱ ipeli i mayun.” ");
INSERT INTO kdlNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Atoni a Yesu a wene yi ta̱ u yansai ikunesavu ushani iꞌya bawu a korongi a asuvu a tagara̱da u na. ");
INSERT INTO kdlNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","N korongu ta̱ ikuna i na yi tsa̱ra̱ i wushuku an Yesu aya Kawauwi Maku ma Kashila̱, kpam adama a ɗa i wushuki n eyi, ya tsa̱ra̱ ta̱ uma. ");
INSERT INTO kdlNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Aku Yesu tuwa̱i u doki u wenikei kaci ka ne a asu u atoni a ne a ikengi i Kushiva̱ ku Galili. Tyoku ɗa ukuna vi u gita̱i ɗa na: ");
INSERT INTO kdlNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Atoni a ne ushani alya a pini: Simo Bituru, n Toma (uza ɗa a tsu isa̱ Mapeshe), n Nataniya u Kanan u Galili, na̱ mmuku n Zabidi, n atoni a re a roku. ");
INSERT INTO kdlNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simo Bituru tonukoi aza ɗa a buwai vi, “Ma bana ta̱ uka̱na̱sa̱ adan.” Aku a danai, “Tsa bana ta̱ dem kaɓolo n avu.” Aku a lazai a asuvu a kpatsu ku le. Shegai a ka̱na̱ ko i te wa n kayin ka nala ki. ");
INSERT INTO kdlNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","An kain ka wansai n usana u de, aku Yesu shamgbai a ikengi i kushiva̱, shegai atoni yi a reve an Yesu ɗa wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","U isa̱ le u danai, “Ama a va̱, i ka̱na̱ gba̱m adan?” A wushuki, “Aꞌa.” ");
INSERT INTO kdlNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Aku u tonuko le, “Vuta̱la̱i ibilili i ɗe a kapashi ka ulyaki ka kpatsu ki, ya ka̱na̱ ta̱.” Aku a yain nala, a fuɗa gba̱m a rono ibilili yi wa kpaci adan a ɗa pini ushani. ");
INSERT INTO kdlNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Aku katoni ka Yesu wa ciga vi u tonukoi Bituru, “Asheku a ɗa!” An u panai a danai Asheku a ɗa, aku u ukai matogo ma ne (kpaci wa̱ri u mondo ta̱ ma an wa yan manyan), aku u raɗugi u rukpa̱i pini a mini mi. ");
INSERT INTO kdlNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Atoni a ɗa a buwai vi a rawai a kpatsu ki, aku a ka ɓa̱na̱ ibilili yi ushaɗangi n adan. Aꞌa̱ri mɓa̱ri n kagiɗa wa, evu n iyadi amangatawun (100) iꞌya. ");
INSERT INTO kdlNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","An atoni yi a wuta̱i a kpatsu ki, a wenei wa̱ ta̱ n ilikulya, kpam wa zungu adan a akina. ");
INSERT INTO kdlNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Aku Yesu danai, “Tukoi adan a roku a asuvu a ɗa i ka̱na̱i vi.” ");
INSERT INTO kdlNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Aku Simo Bituru gonoi a kpatsu ki u ronoi ibilili yi ubana a kagiɗa. Adan a pige amangatawun n amangarenkupa n a tatsu (153) a ɗa aꞌa̱ri pini, gba̱ n nala ibilili yi i kara wa. ");
INSERT INTO kdlNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu tonuko le, “Tuwa̱i i lyai ilikulya.” Ko uza u te a asuvu a atoni yi u kawan u wece yi, “Aɗa yai?” wa, kpaci a reve ta̱ Asheku a ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Aku Yesu banai u bidyai burodi u na̱ka̱ le. U na̱ka̱ le kpam dem adan yi. ");
INSERT INTO kdlNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Tatsu ɗa la vi an Yesu wenikei kaci ka ne ara le an u ꞌya̱nga̱i a ukpa̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","An a kotsoi ulya ilikulya, Yesu wecei Simo Bituru, “Simo maku ma Yahaya, va ciga mu kapala n uciga u ɗa atoni a na a ka ciga mu?” U wushuki, “Eye, Asheku, vu reve ta̱ ma ciga vu.” Yesu danai, “Lina̱ka mmuku ma ncon n va̱.” ");
INSERT INTO kdlNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesu doki u wecikei u ire, “Simo maku ma Yahaya, va ciga mu?” Bituru wushuki, “Eye, Asheku, vu reve ta̱ ma ciga vu!” Yesu danai, “Kirana na̱ ncon n va̱.” ");
INSERT INTO kdlNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","U doki u wecikei utatsu, “Simo maku ma Yahaya, va ciga mu?” Aku Bituru namgbai katsuma̱ an Yesu wece yi hal kutatsu u da wa ciga yi. Aku u tonukoi Yesu, “Asheku, vu reve ta̱ ko ndya wa. Vu reve ta̱ ma ciga vu.” Yesu tonuko yi, “Lina̱ka ncon n va̱. ");
INSERT INTO kdlNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mayun n tonuko vu, aꞌayin a ɗa va̱ri kalobo, vu tsu uka ta̱ aminya n kaci ka vunu vu bana a asu u ɗa dem va ciga vu bana. Shegai vu kutsa baci, va ba̱ra̱kpa̱ ta̱ akere a vunu uza roku u uka vu, u rono vu ubana a asu u ɗa bawu va ciga vu bana.” ");
INSERT INTO kdlNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Yesu dana ta̱ nala tsa̱ra̱ u wenike tyoku ɗa Bituru wa kuwa̱ tsa̱ra̱ u na̱ka̱ Kashila̱ tsupige.) Aku Yesu tonukoi Bituru, “Tono mu!” ");
INSERT INTO kdlNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Bituru yira̱la̱kpa̱i aku u wenei katoni ka Yesu wa ciga vi wa tono le, aya kpam dem uza ɗa u raɓai evu n Yesu an a ka lya ilikulya aku u wecikei, “Asheku, ya uza ɗa wa neke vu vi?” ");
INSERT INTO kdlNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","An u wene yi, u wecei Yesu, “Asheku, ndya ya tuwa̱ ya gita̱ n eyi?” ");
INSERT INTO kdlNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu wushunku yi, “N da baci ma a̱sa̱ka̱ yi n uma hal aꞌayin a ɗa ma gono, ndya i birika vu? Avu gai tono mu.” ");
INSERT INTO kdlNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Aku alabari a kyawain a asu u atoni a da eyi nala vi wa kuwa̱ wa. Shegai Yesu dana ɗa u danai eyi na wa kpa̱ɗa̱ ukuwa̱ wa. Dana ɗa gai u danai, “N da baci ma a̱sa̱ka̱ yi n uma hal aꞌayin a ɗa ma gono, ndya i birika vu?” ");
INSERT INTO kdlNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Katoni ka nala ki aya u dansai gba̱ ili i na yi. U korongi iꞌya, kpam tsu reve ta̱ ukuna u mayun u ɗa wa dansa. ");
INSERT INTO kdlNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu yansa ta̱ ili i roku ushani. A da baci a ka korongu gba̱ ili i na yi a itagara̱da, a uwene u va̱ kabala ka̱ la a likimba ka ka bidya iꞌya wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Uzapige Tiyofilu: An n koronku vu caupa vi, n korongu ta̱ gba̱ ili iꞌya Yesu yansai kpam u wenishikei, ili iꞌya i bidyai aꞌayin a ɗa u gita̱i manyan ma ne ");
INSERT INTO kdlNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","hal ubana kain ka a canga yi ubana a zuba. An u ꞌya̱nga̱i a ukpa̱, u wenishike ta̱ kaci ka ne a asu u asuki a ne a ɗa u ɗanga̱sai hal aꞌayin amangare. U yansa ta̱ ili ushani iꞌya i wenikei an wa̱ri n uma mayun. An aꞌayin a ɗa a ka canga yi ubana a zuba a yain evu, u dansa ta̱ n ele ukuna u tsugono tsu Kashila̱ u tonusuko le kpam ili iꞌya a ka yan. Gba̱ ili i na yi u yansa ta̱ iꞌya a asuvu a ucira u Kulu Keri. ");
INSERT INTO kdlNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Kain ka te an wa̱ri kaɓolo n ele a asu u ulya ilikulya, u tonuko le, “Kotsu i laza pini a Urishelima wa hal she Tata u sukunku ɗa̱ kune ku u zuwamgbanai vi. Ma̱ri n tonuko ɗa̱ ɗe ukuna u na vi caupa. ");
INSERT INTO kdlNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yahaya lyuɓugusu ta̱ ama n mini, shegai ubana a kapala kenu, a ka lyuɓugu ɗa̱ ta̱ n Kulu Keri.” ");
INSERT INTO kdlNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Kain ka te, an asuki yi a ɓolomgbonoi a asu u te kaɓolo n Yesu, a wece yi, “Asheku, aꞌayin a ɗa va gonuko aza a Isaraꞌila tsugono tsu le a ɗa na vi?” ");
INSERT INTO kdlNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","U tonuko le, “Tata ɗa koshi wa̱ri n ucira u ɗa wa reve aꞌayin a ɗa u foɓusoi vi, eɗa̱ ya reve wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Shegai ya wusha ta̱ ucira aꞌayin a ɗa Kulu Keri ku cipa̱i asuvu a ɗe. Ya woko ta̱ aza ɗa ya shamkpa mu a Urishelima, n gba̱ a asuvu a Yahuda. I tonuko kpam aza a Samariya hal ubana a asuvu a likimba gba̱.” ");
INSERT INTO kdlNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","An u kotsoi kadyanshi ka na ki, ele n a wundi yi, aku a canga yi a mere ma le ubana a zuba. Pini nala, kalishi ka kimba̱ yi, a doku a wene yi kpam wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Aꞌayin a ɗa aꞌa̱ri pini a uwundya zuba vi, kute‑kute ama a re uꞌuki n aminya a eri a shamgbai evu n ele. ");
INSERT INTO kdlNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","A tonuko le, “Aza a Galili, ndya i zuwai iꞌa̱ri kushani ya wundya zuba? Yesu ɗa i wenei a cangai ubana a zuba na vi, nala kpam wa gono.” ");
INSERT INTO kdlNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Aku asuki yi a lazai pini a Masasa ma Zayitum mi a gonoi a Urishelima, kpam nte masasa mi ma̱ri pini evu n Urishelima vi; wata, kagbidi ka mel u te. ");
INSERT INTO kdlNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","An a rawai a ilyuci yi, aku a yuwa̱i a kunukuzuba a asu u ɗa a tsu cipa̱. Ama ɗa aꞌa̱ri pini vi alya; Bituru, n Yahaya, n Yakubu. Andurawu, n Filibu, n Toma aꞌa̱ ta̱ dem pini. Aza ɗa aꞌa̱ri pini a ɓolomgbono ta̱ dem n Batalamawu, n Matiyu, n Yakubu maku ma Halfa, n Simo uza ɗa a ka isa̱ Ziloti, n Yahuza maku ma Yakubu. ");
INSERT INTO kdlNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","A tsu ɓolomgbono ta̱ kpam a na̱ka̱i kaci ka le adama a kavasu n katakasuvu ka te. Aka roku a ɗa dem pini hal n Meri mma u Yesu n aꞌangu a Yesu yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Aꞌayin a nala yi, kakuma̱ ka ama ka ka rawai ama amangatawun n kamanga (120) aza ɗa a pityanangi ka ka ɓolomgbonoi. Pini nala, Bituru shamgbai a mere ma le u danai, ");
INSERT INTO kdlNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Ama a va̱, u ka̱na̱ ta̱ a shaɗangu udani u Kashila̱ u ɗa Kulu Keri ku danai caupa a una̱ u Dawuda a kaci ka Yahuza, uza ɗa u tonoi n aza ɗa a ka̱na̱i Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Kpaci caupa uza u te u ɗa a asuvu a tsunu, kpam a na̱ka̱ yi ta̱ kapashi ka manyan ka ne a asuvu a manyan ma na mi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(U tsila ta̱ uyamba n ikebe iꞌya u tsa̱ra̱i a asu u manyan ma cingi mi. Pini nala, u rukpa̱i kaci uvari, aku katsuma̱ ka ne ka ta̱sa̱i, ucanga u katsuma̱ vi u tsa̱la̱i a iyamba. ");
INSERT INTO kdlNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Gba̱ aza ɗa aꞌa̱ri a Urishelima a pana ta̱ ukuna u na vi, aku a nekei asu vi kala, Akaladama n kaletsu ka le; wata, “Uyamba u Mpasa.”) ");
INSERT INTO kdlNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Bituru lyai kapala n kadyanshi, “Kpaci wa̱ ta̱ ukorongi a asuvu a Tagara̱da u Ishipa,† ‘A̱sa̱ka̱ kuwa ku ne ku woko uvarangi, kpam kotsu uza u dusuku pini wa.’ “Kpam a dana ta̱, ‘Kapashi ka manyan ka ne ki uza roku u bidya ka.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Adama a nala u ka̱na̱ ta̱ a ɗanga̱sa uza roku a asuvu a ama a na yi, uza ɗa wa̱ri kaɓolo n a̱tsu caupa aꞌayin a ɗa Yesu Asheku wa̱ri n a̱tsu. ");
INSERT INTO kdlNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","U ka̱na̱ ta̱ vuma vi u woko uza ɗa u rongoi n a̱tsu tun aꞌayin a ɗa Yahaya lyuɓugi Yesu hal ubana aꞌayin a ɗa a canga yi ubana a zuba. U ka̱na̱ ta̱ vuma vi u ɓolomgbono kaci n a̱tsu, u woko uza ɗa wa tonuko ama ukuna u uꞌya̱nga̱ u ne a ukpa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pini nala, a wutukpa̱i ama a re, Isuhu Bara̱saba uza ɗa a ka isa̱ Yusutu, n Mataya. ");
INSERT INTO kdlNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Asuki yi a yain kavasu a danai, “Asheku, ya dem vu reve ta̱ katakasuvu ka ne. Wenike tsu uza ɗa vu ɗanga̱sai a asuvu a ama a re a na yi, ");
INSERT INTO kdlNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","u woko kasuki. U bidya manyan ma Yahuza kasuki u a̱sa̱ka̱i kpaci u bana ɗe asu u ɗa u yain dere n eyi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","A varangi uruta, aku u rukpa̱i a kaci ka Mataya, pini nala, a zuwa yi u woko kasuki kaɓolo n kupa n u te vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","An kain ka Abiki a Kain ka Amangarenkupa† ka yain, gba̱ Atoni yi a ɓolomgbonoi a asu u te. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kute‑kute a panai mawura̱ ma uwule u pige u ɗa u wuta̱i a zuba u shaɗangi kuwa ka aꞌa̱ri pini ndishi vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Aku a wenei ili i roku yavu aletsu a akina a ka pecenishe n a cipusi a zuba u aꞌaci a le. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","A shaɗangu le n Kulu Keri, aku a gita̱i kadyanshi n aletsu a roku kau‑kau tyoku ɗa Kulu Keri ki ku tonoi n ele. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Aꞌayin a nala yi, aza a Yahuda a roku aza ɗa a ka tono Kashila̱ a wuta̱i a iyamba i likimba gba̱ ya dem n kaletsu ka ne a tuwa̱i pini a Urishelima vi na̱ ndishi. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","An a panai mawura̱ ma uwule mi, aku kakuma̱ ka ama ka sumai ka banai tsa̱ra̱ a wene ili iꞌya ya gita̱. Aku a yain majiyan kpaci gba̱ le ya dem pana ta̱ kaletsu ka ne a asu u Atoni yi a ka dansa ka. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","A yain majiyan cika, hal a ka wecishike, “Aza ɗa a ka dansa na vi tsa wundya gba̱ le aza a Galili a ɗa vi? ");
INSERT INTO kdlNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Niɗa kpam gba̱ tsunu tsu pana̱ka le a ka dansa aletsu a tsunu? ");
INSERT INTO kdlNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","A̱tsa tani na tsu wuta̱ ta̱ iyamba kau‑kau, aza a roku aza a Paratiya a ɗa, n aza a Madaya, n aza a Elam. Tsa̱ ta̱ dem n aza a Masopotamiya, n aza a Yahuda, n aza a Kapadosiya, n aza a Pontu, n aza a Asiya asuvu a tsunu. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Aza a Firijiya, n aza a Bamafiliya n aza a Masar a ɗa dem pini. Hal n aza a kaɓon ka kapashi ka Libiya evu n Sirani, n amoci a uyamba u Roma aza ɗa aꞌa̱ri aza a Yahuda n aza ɗa a uwai utono u adini a aza a Yahuda. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","A̱tsa tani na aza a Kiriti n aza a Arabi, gba̱ tsa pana̱ka le a ka dansa ukuna u manyan ma pige ma Kashila̱ ka yain n aletsu a tsunu.” ");
INSERT INTO kdlNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Gba̱ le a yain majiyan, hal a la̱pa̱na̱i a ka wecemgbene, a da, “Ndya kalen ka ukuna u naha vi?” ");
INSERT INTO kdlNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Shegai aza roku a ka yanka le majari, a danai, “Mini ma cinwi ma a soi hal a gutukpai.” ");
INSERT INTO kdlNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Bituru ꞌya̱nga̱i kushani kaɓolo n asuki kupa n uza u te vi, u danai, “Aza a va̱, aza a Yahuda n aza ɗa aꞌa̱ri ndishi a Urishelima, panai na, kpam i kirana n ili iꞌya ma tonuko ɗa̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ama a na yi, so ɗa a soi tyoku ɗa iꞌa̱ri uyawunsa wa. U yan ta̱ usana cika, ama a tsu so a gutukpa n ulapa u uwule u kuci n usana u de naha wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ili i na yi, ili iꞌya Juwelu matsumate u danai iꞌya: ");
INSERT INTO kdlNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Kashila̱ ka danai, Aꞌayin a makorishi a rawa baci, ma na̱ka̱ ta̱ ya dem Kulu Keri. Mmuku n ɗe aka n aꞌali a ka yan ta̱ kadyanshi ka ili iꞌya ya tuwa̱. Alobo a ka wene ta̱ kuwene. Nkoshi kpam ma lavutansa ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Aꞌayin a nala yi ma na̱ka̱ ta̱ agbashi a va̱ aka n aꞌali Kulu Keri, kpam a ka dansa ta̱ kadyanshi ka va̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ma wenike ta̱ ikunesavu a zuba u alishi, n iryoci i savu a likimba; wata, mpasa n akina, n ka̱nga̱ ka alishi. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kaara ka woko ta̱ karimbi, uwoto kpam u woko san yavu mpasa. Ili i na yi ya gita̱ ta̱ kahu kain ka tsupige n ka ucira ka Magono ma Zuba ka tuwa̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Aꞌayin a nala yi, uza ɗa baci dem u yain kavasu a asuvu a kala ka Magono ma Zuba wa tsa̱ra̱ ta̱ iwauwi.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Eɗa̱ aza a Isaraꞌila panai na! An Yesu uza u Nazara u yansai gba̱ iryoci n ikunesavu yi, i wenike ta̱ an Kashila̱ ka ka suki yi mayun, kpam gba̱ ɗe i reve ta̱ nala iꞌa̱ri. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Caupa Kashila̱ ka reve ta̱ ili iꞌya ya gita̱, kpam iꞌya u foɓusoi vi i gita̱ ta̱ an a nekei Yesu ara ɗe. I wandamgbana yi ta̱ a mawandamgbani, i wuna yi a akere a aza a unyushi u cingi. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Shegai Kashila̱ ka wutukpa̱ yi ta̱ a asuvu a ucira u ukpa̱, kpaci ukpa̱ wa̱ n ucira u ɗa wa ka̱na̱ yi wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dawuda Magono u yan ta̱ kadyanshi ka na a kaci ka Yesu, u danai, ‘Magono ma Zuba ma̱ ta̱ na̱ mpa kain dem, ili iꞌa̱ la ya ne mu uwonvo wa, kpaci wa̱ ta̱ a kukere ku ulyaki ku va̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Adama a nala katakasuvu ka va̱ ka shaɗangu ta̱ n maza̱nga̱, una̱ u va̱ wa sala ta̱ icikpali i ne, kpam ikyamba i va̱ ya rongo ta̱ n uzuwa u uma. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kpaci va a̱sa̱ka̱ uma u va̱ a asuvu a kasaun wa, kpam va a̱sa̱ka̱ ikyamba i Uza u Uwulukpi u vunu i shama wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Vu wenike mu ta̱ tyoku ɗa ma tsa̱ra̱ uma, kpam vu shaɗangu mu ta̱ n maza̱nga̱ kpaci va rongo ta̱ kaɓolo na̱ mpa.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Ama a va̱ aza a Isaraꞌila, ma fuɗa ta̱ ma dansa ukuna u akaya a tsunu Dawuda n a̱ɗa̱ bawu mala̱la̱. U kuwa̱ ɗe, a ciɗa̱ngu yi, kpam kasaun ka ne ka pini hal n ara. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Eyi matsumate ma, kpam Kashila̱ ka yanka yi ta̱ kazuwamgbani, u da wa zuwa ta̱ uza roku a asuvu a kagali ka ne u woko magono, tyoku ɗa u zuwa yi u wokoi magono. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","An Dawuda wenei nala, aku u yain kadyanshi ka ukuna u uꞌya̱nga̱ u ukpa̱ u Kawauwi, u da, ‘A ka a̱sa̱nsa̱ n ikyamba i ne a kasaun wa, kpam iꞌya ya shama wa.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Kashila̱ ka ꞌya̱nga̱sa̱ ta̱ Yesu u na vi a ukpa̱, kpam a̱tsu dem tsu wene ta̱ ukuna vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","“Gogo‑na aya pini ndishi a ulyaki u Kashila̱ a asu u tsupige, kpam Kashila̱ Tata u ne u na̱ka̱ yi ta̱ Kulu Keri tyoku ɗa u zuwamgbanai. Gogo‑na Yesu vi u tsunku tsu ɗe ka a aꞌaci a tsunu, aya u tukoi ili iꞌya tsu wenei kpam tsa pana na vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dawuda ɗa yuwa̱i a zuba wa, shegai eyi n kaci ka ne u dana ta̱, ‘Magono ma Zuba ma tonukoi Asheku a va̱, dusuku a ulyaki u va̱, ");
INSERT INTO kdlNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","hal n zuwa vu taɗanku atokulalu a vunu aꞌene.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Adama a nala, eɗa̱ aza a Isaraꞌila she i reve an Yesu ɗa i wandamgbanai nala vi, Kashila̱ ka gonuko yi ɗe Asheku n Kawauwi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","An a panai nala, aku kadyanshi ki ka sawa le atakasuvu cika, a wecei Bituru n asuki a ɗa aꞌa̱ri pini vi, “Atoku a tsunu, ndya tsa yan?” ");
INSERT INTO kdlNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Bituru wushunku le, “U ka̱na̱ ta̱ i a̱sa̱ka̱ tsicingi tsu ɗe i kpatala ubana a asu u Kashila̱. A lyuɓugu ɗa̱ a asuvu a kala ka Yesu Kirisiti, kotsu Kashila̱ ka cimbusuka̱ ɗa̱ unyushi u cingi u ɗe, tsa̱ra̱ i tsa̱ra̱ kune ku Kulu Keri. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kazuwamgbani ka Kashila̱ ka na ki adama a ɗe a ɗa na̱ mmuku n ɗe hal gba̱m n aza ɗa aꞌa̱ri a mɓa̱ri: aza ɗa Magono ma Zuba Kashila̱ ka tsunu ka isa̱i ubana ara ne.” ");
INSERT INTO kdlNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Bituru lyai kapala n u yanki le kuɓari cika, n u dansi, “Wauwai kaci ka ɗe a upana u ikyamba u ɗa wa tuwa̱ a kaci ka ama a cingi a aꞌayin a na yi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ama ushani a wushuku ta̱ n kadyanshi ka ne, aku a lyuɓugu le. Ama yi a raɓansa ta̱ ama azu a tatsu (3,000) aza ɗa a ɓolomgbonoi n atoni kain ki. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","A gonukoi ugboji u le a asu u uwenishike u asuki vi, n a rongi kaɓolo, n a lyayi ilikulya, n a yanyi kavasu. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Aku ya dem panai uwonvo n majiyan, adama a iryoci n ikunesavu iꞌya Kashila̱ ka yansa a akere a asuki. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Gba̱ Atoni yi a ɓolomgbonoi a asu u te, n a yanyi manyan n ili iꞌya a tsa̱ra̱i kaɓolo. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","A dengishei utsa̱ri u le aku a neshei ama ɗa bawu aꞌa̱ri n ili dere tyoku ɗa a ka ciga. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kain dem a tsu gbashika ta̱ Kashila̱ a Kuwa ku Kashila̱, a gawunsusa a aꞌuwa a le a lyai ilikulya kaɓolo n katakasuvu ka te. ");
INSERT INTO kdlNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","N a cikpali Kashila̱ kain dem, kpam gba̱ ama yi a ka na̱ka̱ le ta̱ tsupige. Kain dem Asheku a dokusu le ta̱ ama ushani aza ɗa a ka tsa̱ra̱sa̱ iwauwi. ");
INSERT INTO kdlNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Kain ka te, Bituru n Yahaya a ka bana a Kuwa ku Kashila̱ aꞌayin a uyan kavasu, n ulapa u uwule u tatsu u kuvuli. ");
INSERT INTO kdlNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","A utsutsu u ɗa a ka isa̱ Utsutsu u Shinga, vuma roku ɗa pini uza ɗa a matsai kawunu. Kain dem a tsu canga yi ta̱ ubana a utsutsu u Kuwa ku Kashila̱ vi tsa̱ra̱ u foli kune a asu u aza ɗa a ka uwusa pini. ");
INSERT INTO kdlNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","An u wenei Bituru n Yahaya a ka uwa a Kuwa ki, u folo le kune. ");
INSERT INTO kdlNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Bituru n Yahaya a weɓele yi, aku Bituru tonuko yi, “Kondono tsu.” ");
INSERT INTO kdlNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Kawunu ki ka zuwa ta̱ uma u ne a ara le n u wundi wa tsa̱ra̱ kune. ");
INSERT INTO kdlNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Bituru tonuko yi, “Ma̱ n ikebe wa, shegai ili iꞌya ma̱ri n iꞌya, iꞌya ma na̱ka̱ vu. A asuvu a kala ka Yesu Kawauwi, uza u Nazara, ꞌya̱nga̱ vu wala.” ");
INSERT INTO kdlNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pini nala, u ka̱na̱ yi kukere ku ulyaki u ra̱ɗa̱gba̱ yi, aku aꞌene n aꞌeshaꞌene a ne a gbamai. ");
INSERT INTO kdlNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Kute‑kute, u zaɗa̱gbai u ꞌya̱nga̱i kushani u gita̱i nwalu, u uwai a Kuwa ku Kashila̱ ki kaɓolo n ele, wa wala hal n u imkpusi n u cikpali Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Gba̱ ama yi a wene yi n u wali n u cikpali Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","A wene ta̱ ukuna u pige a yain kpam majiyan ma ili iꞌya i gita̱i n eyi, kpaci a reve ta̱ an aya wa̱ri u tsu dusukusu a Utsutsu u Shinga u Kuwa ku Kashila̱ n u foli vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Cina vuma vi buwai kaɓolo n Bituru n Yahaya, ama a wurana̱sai n ilyaɗi a tuwa̱i pini a kafalaka ka Kuwa ku Kashila̱ ka a ka isa̱ Kafalaka ka Solomo n a yanyi majiyan a kaci ka vuma vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","An Bituru wenei nala, u tonukoi ama yi, “Aza a Isaraꞌila, ndya i zuwai ya yan majiyan ma ili i na yi? Ndya i zuwai ya wundya tsu yavu n ucira u kaci u tsunu, ko kpam adama a utono u Kashila̱ u tsunu u ɗa i zuwai vuma na vi u walai? ");
INSERT INTO kdlNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Kashila̱ ka Ibirahi, n Kashila̱ ka Ishaku, n Kashila̱ ka Yakubu, Kashila̱ ka akaya a tsunu ka ka ra̱ɗa̱gba̱i kagbashi ka ne Yesu. Aya uza ɗa i nekei, kpam i ꞌyuwan yi a kapala ka Bilatu gomuna, gba̱ n uciga u ɗa Bilatu wa̱ri wa ciga u a̱sa̱ka̱ yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Shegai i ꞌyuwain Uza u Shinga vi, uza ɗa wa̱ri bawu unyushi, i foloi a a̱sa̱nka̱ ɗa̱ uza ɗa u wunai ama. ");
INSERT INTO kdlNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","I wunai uza ɗa wa̱ri kami ka uma, shegai Kashila̱ ka ꞌya̱nga̱sa̱ yi a ukpa̱. A̱tsu tsu wene ta̱ ukuna u nala vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Kawunu ka na ki ka ta̱na̱ ta̱ adama a ɗa u pityanangi n Yesu. Vuma ɗa gai na vi kpam i reve yi ta̱! U ta̱na̱ ta̱ gba̱ gba̱ an u wushuki n Yesu, gba̱ ɗe i wene ta̱ tyoku ɗa ukuna u na vi u gita̱i. ");
INSERT INTO kdlNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ama a va̱, n reve ta̱ a asuvu a unamba u ureve u ɗa i yain ili i nala yi, tyoku ɗa aza ɗa a ka tono n a̱ɗa̱ dem a yain. ");
INSERT INTO kdlNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kpam nala Kashila̱ ka shaɗangi ili iꞌya u danai a una̱ u ntsumate, ‘Kirisiti u ne wa pana ta̱ ikyamba.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Adama a nala kpatalai i a̱sa̱ka̱ unyushi u cingi u ɗe, i gono a asu u Kashila̱, tsa̱ra̱ a cimbusuka̱ ɗa̱ unyushi u cingi u ɗe gba̱, Magono ma Zuba kpam ma na̱ka̱ ta̱ atakasuvu a ɗe uwunvuga. ");
INSERT INTO kdlNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Wa sukunku ɗa̱ ta̱ Kirisiti Kawauwi ka u ɗanga̱sai caupa; wata, Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","U ka̱na̱ ta̱ Yesu rongo a zuba, hal ubana aꞌayin a ɗa a ka gonuko ili dem i woko i savu, tyoku ɗa Kashila̱ ka danai caupa a una̱ u ntsumate n shinga. ");
INSERT INTO kdlNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kpaci Musa dana ta̱, ‘Magono ma Zuba Kashila̱ ka ɗe, ma sukunku ɗa̱ ta̱ matsumate a asuvu a aza a ɗe tyoku u va̱. U ka̱na̱ ta̱ i pana ili iꞌya wa tonuko ɗa̱.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kpam, ‘Wa ka̱na̱ ta̱ gba̱ uza ɗa u kpa̱ɗa̱i upana̱ka matsumate ma nala mi, a ka pece yi ta̱ n ama a ne gba̱ a wacinsa yi.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Mayun, gba̱ ntsumate n ɗa n yain kadyanshi ki, ili iꞌya i ka̱na̱i tun Samaꞌila hal ubana, a yan ta̱ kadyanshi ka aꞌayin a na yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Eɗa mmuku ma ntsumate mi, eɗa kpam ya lya agadu a kazuwamgbani ka Kashila̱ ka yankai akaya a ɗe, an u tonukoi Ibirahi, ‘A asu u mmuku n vunu n ɗa a ka zuwuka gba̱ agali a likimba una̱ u shinga.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","An Kashila̱ ka ɗanga̱sai kagbashi ka ne, u gita̱ ta̱ u suku yi ara ɗe tsa̱ra̱ u zuwuka ɗa̱ una̱ u shinga, u zuwa ya dem a asuvu a ɗe u a̱sa̱ka̱ tsicingi tsu ne.” ");
INSERT INTO kdlNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Aꞌayin a ɗa Bituru n Yahaya aꞌa̱ri uyanka ama kadyanshi, aku aɗara̱kpi n azapige, n uzapige u ada̱ga̱ri a Kuwa ku Kashila̱, n aza a Sadusi a tuwa̱i ara le. ");
INSERT INTO kdlNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","A yain upan kpaci asuki yi a ka wenishike ta̱ ama, a danai akushe a ka ꞌya̱nga̱ ta̱ a ukpa̱ tyoku ɗa Yesu ꞌya̱nga̱i. ");
INSERT INTO kdlNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","A ka̱na̱ le a gbagirya le hal kain ka wansai, kpaci n kuvuli ka. ");
INSERT INTO kdlNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Shegai ama ushani aza ɗa a panai kuɓari ki a pityanangu ta̱, pini nala, kakuma̱ aza ɗa a pityanangi vi ka doki ushani hal ka rawai ama azu a tawun (5,000) aꞌali. ");
INSERT INTO kdlNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","An kain ka wansai, aku azapige a aza a Yahuda yi, na̱ nkoshi n le, n awenishiki a Mele a ɓolomgbonoi a Urishelima. ");
INSERT INTO kdlNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Hanana Magono ma Aɗara̱kpi wa̱ ta̱ kaɓolo n Kayafa n Yahaya n Alizanda n gba̱ aza ɗa aꞌa̱ri kumaci ku te n Magono ma Aɗara̱kpi mi. ");
INSERT INTO kdlNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","A zuwai Bituru n Yahaya a mere ma le, a wece le, “N ucira u eni u ɗa ko kpam n kala ka eni ka i yain ili i na yi?” ");
INSERT INTO kdlNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Shegai Bituru an wa̱ri ushaɗangi n Kulu Keri u tonuko le, “Eɗa̱ azapige na̱ nkoshi ma ama, ");
INSERT INTO kdlNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","wece ɗa ya wece tsu ara a kaci ka ukuna u shinga u ɗa a yankai vuma na vi, kpam ya ciga i reve uza ɗa u ta̱na̱sa̱ yi vi? ");
INSERT INTO kdlNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Tsa ciga ta̱ gba̱ ɗe i reve hal n aza a Isaraꞌila dem, a asuvu a kala ka Yesu uza u Nazara uza ɗa i wandamgbanai kpam Kashila̱ ka ꞌya̱nga̱sa̱ yi a ukpa̱ vi, a asuvu a kala ka nala ka vuma na wa̱ri kushani n alafiya a kapala ka ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Tagara̱da u Kashila̱ u dana ta̱ aya “ ‘Katali ka aza a kuma a ꞌyuwain ka ka lakai kalen cika a asu u kuma.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Yesu nala vi ɗa koshi wa̱ri n ucira u wauwa uma. Gba̱ a asuvu a likimba, kala ka ne ka koshi ama a ka fuɗa a isa̱ aku a tsa̱ra̱ iwauwi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Azapige yi a yain majiyan cika an a wenei Bituru n Yahaya bawu a panai uwonvo u kadyanshi, kpaci a reve ta̱ ama a na yi aꞌa̱ n ureve u roku wa. Kpam a reve le ta̱ aꞌayin a ɗa aꞌa̱ri kaɓolo n Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","An kpam azapige yi a wenei vuma ɗa a ta̱na̱sa̱i vi kaɓolo n asuki yi, aku a nambai ili iꞌya a ka dana. ");
INSERT INTO kdlNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","A tonukoi asuki yi a wuta̱ pini a asu u Asheshi a Pige yi, ele kpam a sheshei. ");
INSERT INTO kdlNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","A danai, “Ndya tsa yan n ama a na yi? Kpaci gba̱ aza ɗa a ka rongo a Urishelima a reve ta̱ an a yain iryoci i pige a akere a ama a na yi, tsa̱ tani n tyoku ɗa tsa dana nala wa̱ri wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Shegai tsa̱ra̱ kotsu ukuna vi u tambura a asuvu a ama wa, a̱sa̱ka̱ tsu ɓarana le a doku a tonuko uza ukuna a asuvu a kala ka nala ki wa.” ");
INSERT INTO kdlNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Pini nala, a isa̱i asuki yi, a ɓarana le kotsu a doku a tonuko uza ukuna ko a wenishike a asuvu a kala ka Yesu wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Shegai Bituru n Yahaya a wushunku le, “Mai ɗa wa̱ wa̱ri a asu u Kashila̱ tsu lai upana kadyanshi ka ɗe n ka ka Kashila̱? Kondoi ve i wene. ");
INSERT INTO kdlNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kpaci a̱tsu gai tsa fuɗa tsa paɗa bini a kaci ka ili iꞌya tsu panai kpam tsu wenei wa.” ");
INSERT INTO kdlNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","An a doki a ɓarana le, aku a a̱sa̱ka̱ le. A nambai tyoku ɗa a ka yan a yan le mavura, kpaci gba̱ ama a ka cikpala ta̱ Kashila̱ adama a ili iꞌya i gita̱i. ");
INSERT INTO kdlNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Vuma ɗa a matsai kawunu ki kpam a ta̱na̱sa̱ yi n ukunosavu vi, ayen a ne a la ta̱ amangare. ");
INSERT INTO kdlNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","An a a̱sa̱ka̱i Bituru n Yahaya, a banai a asu u aza a le, a yanka le alabari a ili iꞌya aɗara̱kpi a pige n azapige yi a tonuko le. ");
INSERT INTO kdlNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ele kpam an a panai nala aku a ꞌya̱nga̱sa̱i ala̱ga̱tsu a le ubana a asu u Kashila̱ n katakasuvu ka te a danai, “Ashekapige, uza ɗa u yain zuba n likimba n kushiva̱ n gba̱ ili iꞌya iꞌa̱ri a asuvu a le. ");
INSERT INTO kdlNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","A asu u Kulu Keri, vu yain kadyanshi n kagbashi ka vunu; wata, akaya a tsunu Dawuda, vu da, ‘Ndya i zuwai Awulawa a yain upan? Ndya i zuwai ama a ka yansa afoɓi a gbani? ");
INSERT INTO kdlNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ngono n likimba kpam a foɓusoi kushulu, aza ɗa a ka tono n ama kpam dem a ɓolomgbonoi aꞌaci a le, a ka yan tsilala n Magono ma Zuba n Kawauwi ka u suki.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Mayun ɗa ili i na yi i gita̱ ta̱ pini na a Urishelima. Hiridu† magono n Bontu Bilatu a ɓolomgbono ta̱ kaci n Awulawa n aza a Isaraꞌila n a yanyi tsilala n kagbashi ka vunu Yesu Uza u Uwulukpi, uza ɗa vu gonukoi Kawauwi. ");
INSERT INTO kdlNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","A ɓolomgbonoi tsa̱ra̱ a yain ili iꞌya vu foɓusoi ya gita̱ a asuvu a ucira u vunu n tyoku ɗa va ciga. ");
INSERT INTO kdlNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Gogo‑na Magono ma Zuba, kondo ve tyoku ɗa a ka ciga a ɓishinka tsu manyan. A̱tsu agbashi a vunu a ɗa, ne tsu ucira u ɗa tsa yan kadyanshi ka vunu bawu uwonvo. ");
INSERT INTO kdlNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Rongo usukusu kukere ku uta̱na̱sa̱, vu yansa iryoci n ikunesavu a asuvu a kala ka kagbashi ka vunu Yesu Uza u Uwulukpi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","An a kotsoi kavasu, aku asu u ɗa a ɓolomgbonoi vi u gba̱ɗa̱i. A shaɗangu le n Kulu Keri, a rongoi udansa kadyanshi ka Kashila̱ bawu uwonvo. ");
INSERT INTO kdlNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Gba̱ kaɓolo ka atoni ki katakasuvu ka te ka le, uyawunsa u ɗa le dem u te, uza wa̱ la u danai ili iꞌya wa̱ri n iꞌya vi i ne iꞌya koshi wa, shegai i gba̱ le. ");
INSERT INTO kdlNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","N ucira u pige u ɗa asuki yi a danai ukuna u uꞌya̱nga̱ u Yesu Asheku a ukpa̱. Ukuna u shinga u Kashila̱ ushani wa̱ ta̱ a kaci ka ya dem a asuvu a le. ");
INSERT INTO kdlNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kpam uza wa̱ la u nambai ili a asuvu a le wa, kpaci gba̱ aza a uyamba ko aꞌuwa a rongo ta̱ udengishe n a tukusi ikebe yi, ");
INSERT INTO kdlNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","a ka zuwusa a kapala ka asuki yi. Kpam a ka pecishike iꞌya ko ya wa tyoku ɗa mɓa̱la̱ n le ma̱ri. ");
INSERT INTO kdlNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Nala uza roku uza u kala Isuhu yain, eyi uza u Levi u ɗa, kumaci ku uyamba u Sayipuru, uza ɗa asuki yi a tsu isa̱ Bara̱naba; (wata, Uza ɗa wa Gbamatangu Asuvu.) ");
INSERT INTO kdlNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","U denge ta̱ uyamba u ne u roku, u tukoi ikebe yi a kapala ka asuki yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Vuma roku ɗa pini uza u kala Ananiya n uka u ne Sahiratu, u dengei uyamba u ne u roku. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Aku u sokongi ikebe i roku n ureve u uka u ne, u tukoi iꞌya i buwai vi u zuwai a kapala ka asuki u da iꞌya gai la vi gba̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Bituru wece yi, “Ananiya, niɗa vu a̱sa̱ka̱i Kanangasi ka uwai a katakasuvu ka vunu? Vu yankai Kulu Keri kaɓan, kpam vu sokongi ikebe i roku a asuvu a iꞌya vu dengei uyamba vi? ");
INSERT INTO kdlNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Uyamba vi u vunu u ɗa ko vu dengei ko bawu vu dengei. Vu denge baci, va fuɗa ta̱ va yanka ikebe yi tyoku ɗa va ciga. Niɗa vu yawunsai vu yain ucun u ukuna u naha? A̱tsa vu yankai kaɓan wa, Kashila̱ ka vu yankai.” ");
INSERT INTO kdlNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","N u pani kadyanshi ki, aku u rukpa̱i u kuwa̱i. Ama ɗa kpam a panai ukuna vi uwonvo u ka̱na̱ le cika. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Alobo a roku a cacai yi ikyamba yi n aminya a eri a wutukpa̱ yi a kunu ki, a ba a ciɗa̱ngu yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","An ulapa u uwule u tatsu u wurai, aku uka u ne uwai, shegai u reve ili iꞌya i gita̱i wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Aku Bituru wece yi, “Utyoku u ikebe iꞌya i dengei uyamba u ɗe iꞌya na vi?” U danai, “Utyoku u ɗa gai la vi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Bituru wece yi, “Niɗa i ɓolomgbonoi una̱ tsa̱ra̱ i kondo Kulu Keri ku Magono ma Zuba? Pana nwalu ma aza ɗa a ciɗa̱ngi vali u vunu a utsutsu, kpam a ka canga vu ta̱ dem a wutukpa̱ vu.” ");
INSERT INTO kdlNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Kute‑kute u rukpa̱i a kapala ka Bituru u kuwa̱i. An alobo yi a uwai, a cina yi cina u kuwa̱ dem ɗe. Aku a canga yi a ba a ciɗa̱ngi evu n vali u ne. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Atoni yi n ama ɗa a panai alabari a ukuna vi a panai uwonvo cika. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Asuki yi a yain iryoci n ikunesavu i roku ushani a asu u ama. Atoni yi a tsu ɓolomgbono ta̱ a Kafalaka ka Solomo a Kuwa ku Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Shegai a asuvu a ama ɗa a buwai, uza wa̱ la u fuɗai u gbamai asuvu u ɓolomgbonoi kaci n ele wa. Gba̱ n nala, ama a ka na̱ka̱sa̱ le ta̱ tsupige. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Gba̱ n nala aka n aꞌali ushani a ka wushukusu n Asheku. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Hal gba̱m ama aꞌa̱ri a uwutukpusa̱ aza a mɓa̱la̱ a ure n a zuwusi le a zuba u ivamkpatsu n ajiba tsa̱ra̱ Bituru wa wura baci kulu ku ne ku sawa le. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ama ushani a ilyuci iꞌya iꞌa̱ri evu n Urishelima aꞌa̱ri utukuso aza a mɓa̱la̱ n aza ɗa ityoni i cingi ya yan le mavura, kpam gba̱ le a ta̱na̱ ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Magono ma Aɗara̱kpi n aza ɗa aꞌa̱ri n eyi; wata, aza a Sadusi a yain malyon cika. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Pini nala, a ka̱na̱i asuki yi a ukai a kuwa ku aꞌali. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Shegai an kayin ka yain, aku katsumate ka Magono ma Zuba ka kukpusa̱i itsutsu yi u wutukpa̱ le, ka danai, ");
INSERT INTO kdlNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Banai i shamgba a ulanga u Kuwa ku Kashila̱ i tonuko ama gba̱ ukuna u uma u savu.” ");
INSERT INTO kdlNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","N a pani nala, aku a uwai a Kuwa ku Kashila̱ ki n usana u de a gita̱i uwenishike. Aꞌayin a ɗa Magono ma Aɗara̱kpi n aza ɗa aꞌa̱ri kaɓolo n eyi a ɓolomgbonoi, a isa̱i Asheshi a Pige† na̱ nkoshi n pige m aza a Isaraꞌila gba̱, aku a sukunki aza a kuwa ku aꞌali ki a tuko asuki yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Shegai an ada̱ga̱ri a Kuwa ku Kashila̱ ki a banai pini a kuwa ku aꞌali ki a cina le pini wa, a gonoi a yain alabari a danai, ");
INSERT INTO kdlNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Tsu cina ta̱ kuwa ku aꞌali ki ugbagiri, aza ɗa kpam a ka wundya kuwa ki alya pini a itsutsu, shegai an tsu giduwa̱i tsu cina pini uza wa.” ");
INSERT INTO kdlNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","An uzapige u ada̱ga̱ri a Kuwa ku Kashila̱ ki n aɗara̱kpi a pige yi a panai nala, aku a dambulai cika n a yanyi kacoco ka ili iꞌya ukuna u na wa tuko. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Uza roku u tuwa̱i u tonuko le, “Wundyai, ama ɗa i ukai a kuwa ku aꞌali ki, alya pini kushani a Kuwa ku Kashila̱ a ka wenishike ama.” ");
INSERT INTO kdlNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Uzapige u ada̱ga̱ri vi n aza ɗa a ka tono yi vi a ba a tukoi asuki yi, shegai n ucira wa, kpaci a ka pana ta̱ uwonvo u ama kotsu a vara̱sa le n atali wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","An a tuwa̱i n ele, aku a shamkpa le a kapala ka Asheshi a Pige, Magono ma Aɗara̱kpi ma tonuko le, ");
INSERT INTO kdlNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Tsu tonuko ɗa̱ ta̱, kotsu i doku i wenishike a asuvu a kala ka nala ki wa, shegai i kyawan ɗe Urishelima n uwenishike u ɗe hal gba̱m ya ciga i takpa tsu ukpa̱ u ne.” ");
INSERT INTO kdlNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Bituru n asuki yi a wushunku le, “U gan ta̱ tsu gorimuko udani u Kashila̱ kapala n u vuma. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Kashila̱ ka akaya a tsunu u ꞌya̱nga̱sa̱ ta̱ Yesu uza ɗa i wandamgbanai a mawandamgbani. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Aya Kashila̱ ka zuwai a ulyaki u ne, u woko Uzapige n Kawauwi tsa̱ra̱ u kukpunka̱ aza a Isaraꞌila ure u uꞌa̱sa̱ka̱ tsicingi tsu le, kpam a tsa̱ra̱ ucimbusa̱ u unyushi u cingi u le. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","A̱tsa tsu wenei ukuna vi, nala kpam dem Kulu Keri ku tonukoi ama ukuna u na vi mayun ɗa. Kashila̱ ka suku ta̱ Kulu Keri ku ne a asu u aza ɗa a gorimuko yi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","An a panai nala, aku a panai upan cika hal a ka ciga a wuna le. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Shegai a asuvu a Asheshi a Pige yi, Kafarishi ka roku ka pini a ka isa̱ Gamaliya. Kawenishiki ka Mele ka uza ɗa ama a ka na̱ka̱ tsupige. U ꞌya̱nga̱i u danai a wutukpa̱ le ve a ulanga. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Pini nala, u tonukoi Asheshi a Pige yi, “Atoku a va̱ aza a Isaraꞌila, kiranai n ili iꞌya ya ciga i yanka ama a na yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ayen a ɗa a wurai, a yan ta̱ vuma roku uza u kala Tuda uza ɗa u bidyai kaci ka ne n kalen cika. Ama amangatawanishi (400) a ɗa a ɓolomgbonoi kaci n eyi. Shegai a wuna yi. Aza ɗa kpam a ka tono yi vi a wacuwai, ko i te ukuna u nala u lekeɗe wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","An u ne u kotsoi, vuma roku kpam uza u kala Yahuza uza u Galili u wuta̱i aꞌayin a ɗa a ka yan makeci. Eyi dem tsa̱ra̱i ama ɗa a tono yi ushani. Shegai eyi dem a wuna yi, atoni a ne a wacuwai. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Gogo‑na adooki a va̱ a ɗa na a kaci ka ama a na yi, tsu a̱sa̱ka̱ le shiriri. Manyan ma a ka yan na vi n ucira u kaci u le u ɗa baci a ka yan ma, a ka ɓa̱ra̱kpa̱ wa a ka kpa̱ɗa̱ ta̱ ma. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","N ucira u Kashila̱ u ɗa baci kpam, ya fuɗa ya ɓishinka le wa, shegai i boluko kaci ka ɗe ukuna n Kashila̱ gbani.” ");
INSERT INTO kdlNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","A wushuki n adooki a ne, a isa̱i asuki yi a bawan le. Aku a ɓara le kotsu a doku a yain kadyanshi n kala ka Yesu wa. Pini nala, a a̱sa̱ka̱ le a lazai. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","An asuki yi a lazai pini a kapala ka Asheshi a Pige yi, aku a gita̱i maza̱nga̱, kpaci a wene ta̱ a rawai a yan le mavura adama a kala ka Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kain dem a tsu bana ta̱ a Kuwa ku Kashila̱ n a wenishiki ama n a dansi Yesu aya Kawauwi, hal n a toni aꞌuwa aꞌuwa a ama. ");
INSERT INTO kdlNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","A aꞌayin a nala yi an kakuma̱ ka Atoni ka̱ri a udoku, aku aza a kaletsu ka Tsiheline a ka yan tsali a kaci ka aza a kaletsu ka Tsiyahuda, an a kpa̱ɗa̱i ukirana na̱ nra̱na̱ n le a asu u una̱ka̱sa̱ le ilikulya ushani kain dem tyoku u aza ɗa a buwai. ");
INSERT INTO kdlNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Asuki kupa n ama a re yi a ɓolongi gba̱ Atoni yi asu u te a danai, “U gan tsu a̱sa̱ka̱ kuɓari ku kadyanshi ka Kashila̱ tsu uwa kapeci ka ilikulya wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Adama a nala atoku, ɗanga̱sai ama a shindere asuvu a ɗe aza ɗa aꞌa̱ri n ahali a shinga, ushaɗangi n Kulu Keri n ugboji, kotsu tsu na̱ka̱ le manyan mi. ");
INSERT INTO kdlNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","A̱tsu tani tsu tsa̱ra̱ kabala ka kavasu n uwenishike u kadyanshi ka Kashila̱.” ");
INSERT INTO kdlNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ama yi gba̱ a panai kayanyan ka ili iꞌya a danai. A ɗanga̱sai Isitifanu vuma ɗa u pityanangi cika kpam ushaɗangi n Kulu Keri, n Filibu, n Burukoro. A ɗanga̱sa ta̱ dem Nikana, n Timan, n Baramina, n Nikala vuma u Antakiya uza ɗa u uwai utono u adini a aza a Yahuda. ");
INSERT INTO kdlNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ama a na a ɗa a bankai a asu u asuki yi, aku a yain kavasu a taɗanku le akere. ");
INSERT INTO kdlNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Kadyanshi ka Kashila̱ ka tamburai, kakuma̱ ka Atoni a uyamba u Urishelima ka doki cika, kpam aɗara̱kpi ushani a pityanangi. ");
INSERT INTO kdlNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Isitifanu ushaɗangi n kune ku ukuna u shinga u Kashila̱ n ucira, u yain iryoci n ikunesav a mere ma ama. ");
INSERT INTO kdlNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Aku aza a kagata ka Kashila̱ ka a ka isa̱ Kagata ka Uꞌa̱sa̱ka̱ Agbashi, a gita̱i kananamgbani n Isitifanu. Ama a na yi aza a Yahuda a ɗa a wuta̱i a Sirani n Alizandariya nala dem n aza a kaɓon ka Kilikiya n Asiya. ");
INSERT INTO kdlNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Shegai adama a ureve u kadyanshi ka ne kaɓolo n Kulu Keri a fuɗa a nanamgbana n eyi wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","A leshei ama roku usokongi tsa̱ra̱ a yain kaɓan, a dana, “Tsu pana̱ka yi ta̱ n u wishisi Musa n u yanki Kashila̱ kadyanshi ka cingi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Nala a ꞌya̱nga̱sa̱i atakasuvu a ama n azapige n awenishiki a Mele, aku ele tani a ka̱na̱i Isitifanu a banka yi a kapala ka Asheshi a Pige. ");
INSERT INTO kdlNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Aku aza a kaɓan yi a tonukoi Asheshi a Pige yi, a danai, “Vuma na kain dem ɗa wa yansa kadyanshi ka gbani a kaci ka asu u uwulukpi u na n Mele ma Musa. ");
INSERT INTO kdlNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tsu pana̱ka yi ta̱ n u dansi, Yesu uza u Nazara nala vi wa wa̱sa̱ ta̱ asu vi aku u savaɗa gba̱ agadu a ɗa Musa a̱sa̱nka̱ tsu.” ");
INSERT INTO kdlNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Gba̱ ama ɗa aꞌa̱ri pini ndishi a asu u usheshe vi a zuwuka yi aꞌeshi, aku a wenei upetiwaꞌeshi u ne u wokoi tyoku u katsumate ka zuba. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Magono ma Aɗara̱kpi ma wece yi, “Ikuna i na yi mayun ɗa iꞌa̱ri?” ");
INSERT INTO kdlNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Aku Isitifanu danai, “Eɗa̱ atoku a va̱ n azapige, pana̱ka numu, Kashila̱ uza u tsupige u wenike ta̱ kaci ka ne a asu u akaya a tsunu Ibirahi, aꞌayin a ɗa wa̱ri a uyamba u Masopotamiya kahu u ba u dusuku a Haran. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","U tonuko yi, ‘ꞌYa̱nga̱ a uyamba u ɗe, vu a̱sa̱ka̱ atoku a vunu, vu bana a uyamba u ɗa ma wenike vu.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Aku u ꞌya̱nga̱i a uyamba u aza a Kaldiya u ba u dusuki a uyamba u Haran. “An tata u ne u kuwa̱i ɗa Kashila̱ ka tuko yi a uyamba u ɗa iꞌa̱ri ndishi gogo‑na vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Shegai u na̱ka̱ yi agadu a uyamba vi ko udeshe u te wa. U yan ta̱ kazuwamgbani n eyi wa na̱ka̱ yi u ɗa, eyi na̱ mmuku n tsikaya n ɗa ma tuwa̱ a kucina̱ ku ne, ko an u wokoi bawu wa̱ri n maku aꞌayin yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Kashila̱ ka tonuko yi kpam, ‘Kagali ka vunu ka gbasha ta̱ a uyamba u tsumoci. Aza a uyamba vi kpam a ka foro le ta̱ cika hal ayen amangatawanishi (400). ");
INSERT INTO kdlNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ma yanka ta̱ aza a uyamba u ɗa a gbashikai vi mavura. Nala u wura baci, aku a tuwa̱ a gbashika mu a asu u na vi.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Kashila̱ ka na̱ka̱ yi kazuwamgbani a ukuna u ukiɗa u kacombi. An Ibirahi matsai Ishaku, aku u kiɗa yi kacombi eyi n aꞌayin kulla̱. Ukuna vi u lya ta̱ kelime an Ishaku matsai Yakubu, kpam an Yakubu matsai isheku i tsunu aza ɗa a wokoi aletsu kupa n a re. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Shegai an mmuku n Yakubu mi ma takuma vangu u le Isuhu upan, aku a denge yi ubana a uyamba u Masar. Shegai Kashila̱ ka̱ ta̱ n eyi, ");
INSERT INTO kdlNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","kpam u wutukpa̱ yi a asuvu a upana u ikyamba. Kashila̱ ka na̱ka̱ yi ugboji, kpam u na̱ka̱ yi mapasa ma shinga ara Firiꞌauna† magono ma aza a Masar. U zuwa yi u lyai tsugono tsu Masar, u zuwa yi kpam u kirana n kuwa ku tsugono. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Kambulu ka cipa̱i a uyamba u Masar n Kaꞌana kaɓolo n upana u ikyamba u pige, hal isheku i tsunu a nambai ilikulya. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","An Yakubu panai a da ilya iꞌya pini a Masar, aku u suki isheku i tsunu ɗe, nwalu n kagita̱ n ɗa la vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nwalu n le n ire n ɗa Isuhu toɗugboi kaci ka ne ara le, u wenike le kpam ara Firiꞌauna. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","“Aku Isuhu sukunki tata u ne Yakubu u tuwa̱, n atoku a ne gba̱ ama amangatatsunkupa n ama a tawun. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakubu gonoi a Masar, nte u kuwa̱i ɗe n isheku i tsunu. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Aku a pura̱i ikyamba i le a gonuko le a Shekem, a zuwa le a kasaun ka Ibirahi tsilai n ikebe i azurufa a asu u mmuku n Hamo pini a Shekem vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“An aꞌayin a yain evu a ɗa Kashila̱ ka shaɗangu kazuwamgbani ka ne ara Ibirahi, aku kakuma̱ ka ama a tsunu ka doki cika a uyamba u Masar, ");
INSERT INTO kdlNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","hal a yain magono ma roku uza ɗa bawu u revei Isuhu. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Magono ma nala mi ma ryafa ta̱ isheku i tsunu aku u zuwa le a panai ikyamba, hal gba̱m u zuwai a varangusi mmuku n shili tsa̱ra̱ a yain uma wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“A aꞌayin a nala yi a ɗa a matsai Musa, aya la tsulobo tsu de, aku a wo yi a kuwa ku tata u ne uwoto u tatsu. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","U ka̱na̱ ta̱ a wutukpa̱ yi pini a kuwa ki, pini nala, makere ma kuwa ku Firiꞌauna ma tsa̱ra̱ yi u wo yi yavu maku ma ne hal u gbonguroi. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","A wenishike yi gba̱ ugboji u aza a Masar, eyi tani vuma ɗa uza u ucira a asu u kadyanshi n manyan ma ne. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“An Musa yain ayen amangare, aku u da a̱sa̱ka̱ ve u ba u kondo ama a ne aza a Isaraꞌila. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","An u wenei vuma u Masar u roku wa lapa vuma u ne uza u Isaraꞌila, aku u ba u ɓa̱nga̱ yi u wunai vuma vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","N u dani atoku a ne a ka reve an ara ne ɗa Kashila̱ ka wutukpa̱ le, shegai a reve wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“An kain ka wansai, u wenei ama a re aza a Isaraꞌila a ka shila̱ka̱na̱, aku u tuwa̱i tsa̱ra̱ u wansa le, u danai, ‘Eɗa̱ ama a na, uza n utoku u ɗa iꞌa̱ri, niɗa ya shila̱ka̱na̱?’ ");
INSERT INTO kdlNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Uza ɗa u gita̱i n kushulu ki u gamai Musa, u danai, ‘Ya zuwa vu vu woko uzapige n uza u afada a tsunu? ");
INSERT INTO kdlNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Wata, wuna ɗa va ciga vu wuna mu tyoku ɗa vu wunai vuma u Masar nala nayain vi?’ ");
INSERT INTO kdlNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","An Musa panai nala, u sumai u gonoi a uyamba u tsumoci a Midiya, nte u matsai pini ɗe mmuku ma aꞌali n re. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“An ayen amangare a wurai, aku katsumate ka zuba ka wenikei kaci ka ne ara Musa a kakamba evu n Masasa ma Sinai. U wenei katsumate ki a asuvu a katyashi ka akina a asuvu a maɗanga ma kenu. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","An u wenei ili i nala yi, uwonvo u ka̱na̱ yi cika, aku u raɓai evu tsa̱ra̱ u wene iꞌya mai. Aku u panai kala̱ga̱tsu ka Magono ma Zuba ka tonuko yi, ");
INSERT INTO kdlNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Mpa Kashila̱ ka isheku i vunu, Kashila̱ ka Ibirahi, n Kashila̱ ka Ishaku, n Kashila̱ ka Yakubu.’ Aku ikyamba i Musa i gita̱i uje, u fuɗa gba̱m kpam u weɓele wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Magono ma Zuba ma tonuko yi, ‘Foɗo akpata a vunu, kpaci asu u ɗa va̱ri na vi wa̱ ta̱ uwulukpi. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mayun n wene ta̱ mavura ma a ka yanka ama a va̱ a ɗa aꞌa̱ri a Masar, n pana ta̱ maꞌika ma le, kpam n tuwa̱ ta̱ tsa̱ra̱ n wauwa le. Tuwa̱ gogo n suku vu a Masar.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Musa ɗa a ꞌyuwain vi, hal a danai, ‘Ya zuwa vu vu woko uzapige n uza u afada a tsunu vi?’ Aya Kashila̱ ka suki u woko uzapige n kawauwi n uɓa̱nga̱ u katsumate ka zuba ka ka wenikei kaci ka ne ara ne a maɗanga mi. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","U wutukpa̱ le a asuvu a Masar, u yain kpam iryoci n ikunesavu a uyamba u Masar a Mala ma Shili† hal ayen a amangare a kakamba. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Musa na vi ɗa u tonukoi aza a Isaraꞌila, ‘Kashila̱ ka ɗanga̱sa̱ka ɗa̱ ta̱ matsumate a asuvu a ama a ɗe tyoku u va̱.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","U ɓolomgbonoi ama yi a kakamba. U rongoi ɗe kaɓolo n isheku i tsunu n katsumate ka zuba ka ka yanka yi kadyanshi a Masasa ma Sinai† mi. Aya kpam u na̱ka̱ yi kadyanshi ka una̱ka̱ uma a asu u Kashila̱, aku u tonuko tsu. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Shegai isheku i tsunu a ꞌyuwan yi upana̱ka, a ꞌyuwan yi. Aꞌa̱ri uyan maluwa a gono a Masar. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","A tonukoi Haruna, ‘Yanka tsu ameli a ɗa a ka tono n a̱tsu. Kpaci Musa ɗa wuta̱i n a̱tsu a Masar vi tsu reve ili iꞌya i gita̱i n eyi ɗe wa.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Aꞌayin a nala yi a ɗa a yain kameli ka ka rotsoi madyondyom. A yanka yi uɗara̱kpa, aꞌa̱ri uyan maza̱nga̱ a adama a ili iꞌya a yain n akere a le. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Adama a nala, Kashila̱ ka kpatala̱ka le kucina̱, u a̱sa̱ka̱ le a gbashika atala, tyoku ɗa wa̱ri ukorongi a asuvu a itagara̱da i Ntsumate, ‘Eɗa̱ aza a Isaraꞌila, i kiɗa̱ga mu nnama kpam i yanka mu uɗara̱kpa a aꞌayin a ɗa i rongoi a kakamba ayen amangare wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","I na̱ka̱i asu u ɗa a ka gbashika Meleki kameli tsupige, hal n kameli ka katala ka ɗe Rafani. I yain ameli a nala yi i gbashika le. Adama a nala ma tutsuku ɗa̱ ta̱ ɗe a kucina̱ ka uyamba u Babila.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Caupa isheku i tsunu aꞌa̱ri ta̱ n Katani ka Kavasu ka iryoci a kakamba. A yan ta̱ ka tyoku ɗa Kashila̱ ka tonukoi Musa yain ka. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","An ayen ushani a wurai, aku Joshuwa† tonoi n kuvon n iyamba i Awulawa, uyamba u ɗa Kashila̱ ka loko le. A cangai Katani ka Kavasu† ki ubana a uyamba u savu vi. Nte ka̱ri pini hal utuwa̱ aꞌayin a Dawuda magono. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Kashila̱ ka pana ta̱ kayanyan ka Dawuda. Aku Dawuda folo yi u maka Kashila̱ ka Yakubu Kuwa ku Kashila̱, ");
INSERT INTO kdlNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","shegai Solomo ɗa mai ka. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Gba̱ n nala, Kashila̱ Uza u Ucira Gba̱ u dusuku a kuwa ka ama a mai wa. Tyoku ɗa matsumate ma danai, an u yain kadyanshi ka Magono ma Zuba, ");
INSERT INTO kdlNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Zuba ɗa karatsu ka tsugono tsu va̱, likimba kpam a asu u ɗa aꞌene a va̱ a ka wunvuga. Icun i kuma ku eni ka kpam ya maka mu? Ko kpam nte a asu u uwunvuga u va̱? ");
INSERT INTO kdlNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Mpa n yain ili i na yi gba̱ n akere a va̱ wa?’ ");
INSERT INTO kdlNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Eɗa̱ aryagbaji, aza ɗa bawu iꞌa̱ri n upana̱ka kpam i ꞌyuwain Kulu Keri. Eɗa̱ tyoku u isheku i ɗe u ɗa iꞌa̱ri aza ɗa a tsu rongo kushulu n Kulu Keri kain dem. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","A asuvu a ntsumate, matsumate ma eni ma isheku i ɗe i kpa̱ɗa̱i uwisha? Hal gba̱m a wunusai aza ɗa a danai Uza u Uwulukpi wa̱ ta̱ utuwa̱. Kpam gogo‑na i neke ɗe Kawauwi i wuna yi kpam. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Eɗa i wushai Mele a akere a atsumate a zuba, shegai i kpa̱ɗa̱i ma utono.” ");
INSERT INTO kdlNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","An azapige a aza a Yahuda a panai ili iꞌya Isitifanu danai, aku a namgbai katsuma̱ cika hal a lumai ajubu a le. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Shegai Isitifanu wa̱ ta̱ ushaɗangi n Kulu Keri, u weɓelei zuba, aku u wenei tsupige tsu Kashila̱ n Yesu kushani a kukere ku ulyaki ku Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","U danai, “Wundyai, n wene ta̱ zuba u kukpa̱i aku n wenei Maku ma Vuma kushani a kukere ku ulyaki ku Kashila̱!” ");
INSERT INTO kdlNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Aku a salai a palai atsuvu a le, kute‑kute a ka̱na̱ yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","A wutukpa̱ yi a uroto u ilyuci a gita̱ yi uvara̱sa n atali tsa̱ra̱ a wuna yi. Aza ɗa a wenei ukuna vi a zuwusai aminya a le a kapala ka kalobo ka roku uza u kala Shawulu. ");
INSERT INTO kdlNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","An aꞌa̱ri yi uvara̱sa, aku u yain kavasu, u danai, “Asheku Yesu, wusha kulu ku va̱.” ");
INSERT INTO kdlNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Aku u kuɗa̱ngi u salai, “Asheku, kotsu vu ka̱na̱ unyushi u cingi u na a kaci ka le wa.” An u danai nala, aku uma u ne u wuta̱i. ");
INSERT INTO kdlNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Shawulu ɗa pini kushani wa wundya kpam u wushuki n uwuna u Isitifanu. Aku ama roku aza ɗa a ka tono Kashila̱ a ciɗa̱ngu yi n a sa̱yi cika. A aꞌayin a nala yi mavura ma pige ma rukpa̱i a mere ma Atoni a Yesu a Urishelima, aku gba̱ le a wacuwai a asuvu a uyamba u Yahuda n Samariya. Shegai asuki yi alya koshi a wokoi pini a Urishelima. ");
INSERT INTO kdlNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Shawulu tani u rongoi uyan Atoni yi mavura cika. U uwusai aꞌuwa aꞌuwa wa ronuso aka n aꞌali, wa ukusa le a kuwa ku aꞌali. ");
INSERT INTO kdlNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ama ɗa a sumai a a̱sa̱ka̱i Urishelima vi, a rongoi ukyawunsa n a tonusuki ama ukuna u Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filibu dem banai a ilyuci i pige i roku a uyamba u Samariya, wa tonusuko le ukuna u Kawauwi. ");
INSERT INTO kdlNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Aku ama a kyawan yi tsa̱ra̱ a pana ili iꞌya wa dana, kpaci a wene ta̱ iryoci iꞌya u yain. ");
INSERT INTO kdlNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","U wutukpa̱ ta̱ ityoni i cingi a asuvu a ama ushani. An ityoni i cingi yi i wuta̱i a asuvu a ama yi, aku i ka̱na̱i isali cika. U ta̱na̱sa̱i kpam aza ɗa ili i soi ikyamba n awunu ushani. ");
INSERT INTO kdlNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Adama a nala ilyuci yi i shaɗangi n ipeli. ");
INSERT INTO kdlNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Vuma roku u ɗa pini uza u kala Simo, uza ɗa wa̱ri wa yansa ada̱bu pini a ilyuci yi. Aza a Samariya† a yain majiyan ma ili iꞌya u tsu yansa, hal u lapai makamba u danai eyi vuma u pige u ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ama a Samariya azapige na̱ mmuku a danai, “Vuma u na uza u ucira u ɗa, u ɗa a ka isa̱, Ucira u Kashila̱.” ");
INSERT INTO kdlNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Aꞌayin ushani Simo wa̱ri uyansa ada̱bu n u zuwusi le majiyan, adama a nala u wokoi uza u ucira a asuvu a ilyuci yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Shegai an a wushuki n Kadyanshi ka Shinga ka Filibu yain a kaci ka tsugono tsu Kashila̱ n kala ka Yesu Kawauwi, aku a lyuɓugu le gba̱ le aka n aꞌali. ");
INSERT INTO kdlNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Hal dem Simo vi n kaci ka ne u wushuki dem n kadyanshi ki. An a lyuɓugu yi, aku u ka̱na̱i utono Filibu. An u wenei tyoku ɗa Filibu wa yansa iryoci n ikunesavu, aku u yain majiyan cika. ");
INSERT INTO kdlNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","An asuki a ɗa aꞌa̱ri a Urishelima a panai a da aza a Samariya a wushuku ɗe n kadyanshi ki, aku a sukunku le Bituru n Yahaya. ");
INSERT INTO kdlNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","An a rawai, aku a yanka le kavasu tsa̱ra̱ a wushi Kulu Keri. ");
INSERT INTO kdlNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Aꞌayin a nala yi a lyuɓugu le ta̱ a asuvu a kala ka Yesu Asheku, shegai ko uza u te u le wa̱ri u wusha Kulu Keri wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Aku Bituru n Yahaya a taɗanku le akere, aku Kulu Keri ku cipa̱ le. ");
INSERT INTO kdlNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","An Simo wenei tyoku ɗa a ka na̱ka̱sa̱ Kulu Keri a asu u utaɗangusu akere, aku wa ciga u na̱ka̱ le ikebe, ");
INSERT INTO kdlNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","u danai, “Mpa dem na̱ka̱ numu ucun u ucira u nala vi tsa̱ra̱ uza ɗa baci dem n taɗanki kukere u tsa̱ra̱ Kulu Keri.” ");
INSERT INTO kdlNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Shegai Bituru wushunku yi, “Kashila̱ ka wuna vu ta̱ n ikebe i vunu dem! Va wundya n ikebe iꞌya va tsa̱ra̱ kune ku Kashila̱? ");
INSERT INTO kdlNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ko ili i paɗa vu n manyan ma na wa, kpaci katakasuvu ka vunu ka̱ dere n Kashila̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","She vu kpatala vu a̱sa̱ka̱ tsicingi tsu vunu, vu foli Asheku a cimbusuka̱ vu unyushi u cingi u ili iꞌya vu foɓusoi a katakasuvu ka vunu. ");
INSERT INTO kdlNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kpaci n wene ta̱ vu shaɗangi n malyon ma cingi, kpam usiri a asuvu a unyushi u cingi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simo wushuki, “Yanka numu kavasu, tsa̱ra̱ ili iꞌya vu danai na vi i gita̱ na̱ mpa wa.” ");
INSERT INTO kdlNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Bituru n Yahaya a yain kuɓari ku kadyanshi ka Asheku a Samariya, an a kotsoi, aku a gonoi a Urishelima. A lyai kapala n kadyanshi ki ele n a goni a une iꞌya a cina̱sai a ure. ");
INSERT INTO kdlNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Aꞌayin a nala yi, katsumate ka zuba ka yankai Filibu kadyanshi, “ꞌYa̱nga̱ vu toni ubana a ɗaka, vu toni ure u kakamba u ɗa u wuta̱i a Urishelima ubana a Gaza.” ");
INSERT INTO kdlNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","U ka̱na̱i ure, eyi a nwalu, u cinai vuma roku kazuwi ka ikebe ka uyamba u Habasha, kpam kagbashi ka shegai wa̱ ta̱ n tsupige a tsugono tsu Kandakatu Magono, kpam uka ɗa magono ma Habasha mi. A Urishelima ɗa u banai tsa̱ra̱ u lyai kayala. ");
INSERT INTO kdlNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","An wa gono a kuwa, aku u dusuki a maringongo ma adoki ma ne, u kukpa̱i tagara̱da u Ishaya wa yan ka̱neshi. ");
INSERT INTO kdlNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Aku Kulu Keri ku tonukoi Filibu, “Raɓa evu n maringongo ma nala mi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","U sumai u banai asu u ne, u pana̱ka yi wa̱ri a ka̱neshi u tagara̱da u Ishaya matsumate. U wecei vuma vi, “Vu reve ili iꞌya va̱ri a ka̱neshi?” ");
INSERT INTO kdlNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","U wushunku yi, “Nte tani, she uza roku u ɓa̱nga̱ mu.” Aku u tonukoi Filibu u yuwa̱ maringongo mi u dusuku kaɓolo n eyi. ");
INSERT INTO kdlNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Kaɓon ka tagara̱da ka wa yan ka̱neshi vi ka na: “A rono yi yavu macon† ma a ka bana ukiɗa. Tyoku ɗa maku ma kondom ma tsu paɗa bini a ka kiɗa̱sa yi baci tsileme tsu ikyamba i ne, nala dem u paɗai. ");
INSERT INTO kdlNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","A yanka yi uwono hal a kiɗa̱ga yi ugana n ukuna u ɗa bawu wa̱ri dere. Uza wa̱ la wa yan kpam kadyanshi ka mmuku, na̱ mmuku n tsikaya n ne wa. Nte tani, kpaci a wuna yi kahu u tsa̱ra̱ le.” ");
INSERT INTO kdlNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Vuma vi u tonuko yi, “N folo vu, tonuko mu kalen ka asu ki. A kaci ka yai ka matsumate mi ma yain kadyanshi ki, n kaci ka ne ka wa yan ka, ko gai uza roku u ɗa kau?” ");
INSERT INTO kdlNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Aku Filibu gita̱i asu u tagara̱da u nala vi, u yanka yi alabari a Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ele pini a nwalu a cinai asu u roku n mini. Pini nala, vuma vi u danai, “Mini ma na, ndya ya ɓishinka vu vu lyuɓugu mu?”  ");
INSERT INTO kdlNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filibu danai, “Vu wushuku baci n katakasuvu ka te, ma lyuɓugu vu ta̱.” Vuma vi u wushuki. “N wushuku ta̱ n Yesu Kawauwi, Maku ma Kashila̱.” ");
INSERT INTO kdlNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","U zuwai a shamkpai maringongo ma adoki mi. Ama a re a le gba̱ a cipa̱i a uwai a asuvu a mini mi, aku u lyuɓugi yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","An a wuta̱i a asuvu a mini mi, Kulu Keri ku Magono ma Zuba ku cangai Filibu. Vuma vi u doku u wene yi wa. Aku u lyai kapala na̱ nwalu n ne ushaɗangi n ipeli. ");
INSERT INTO kdlNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filibu wenei kaci ka ne a ilyuci i Azatu. U tambai ilyuci ilyuci n u yanyi kuɓari ku Kadyanshi ka Shinga ka Asheku hal u rawai a Kasariya. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Aꞌayin a ɗa Shawulu wa̱ri pini a uyanka Atoni a Asheku mavura cika, hal n u dani wa wuna le. Aku u banai a asu u Magono ma Aɗara̱kpi, ");
INSERT INTO kdlNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","u folo yi u na̱ka̱ yi ukanikorongi u ubana a agata a Kashila̱ a Damasuka. Tsa̱ra̱ u cina baci Atoni a ɗa a wushuki n Ure u Asheku aka ko aꞌali, aku u tuwa̱ n ele usiri a Urishelima. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Eyi pini a nwalu, hal u yain evu n Damasuka, kute‑kute u wenei katyashi ka ucira ka wuta̱i a zuba ka wakana yi ukyawan. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Aku u rukpa̱i a iyamba u panai kala̱ga̱tsu ka danai, “Shawulu, Shawulu, ndya i zuwai va yan mu mavura?” ");
INSERT INTO kdlNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Shawulu wecikei, “Asheku, aɗa yai?” Aku kala̱ga̱tsu ki ka wushuki, “Mpa Yesu uza ɗa va̱ri a uyan mavura. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ꞌYa̱nga̱ vu uwa a ilyuci yi, a ka tonuko vu ta̱ iꞌya va yan.” ");
INSERT INTO kdlNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Aza ɗa a ka wala̱ka kaɓolo ki a fuɗa a dana ukuna wa, a pana ta̱ kala̱ga̱tsu ki, shegai a wene uza wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Aku Shawulu ꞌya̱nga̱i, shegai an u kukpa̱i aꞌeshi a ne u wene asu wa. Atoku a ne a ɗa a ka̱na̱ yi kukere a banka yi pini a ilyuci i Damasuka yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","U yan ta̱ aꞌayin a tatsu pini a Damasuka vi bawu u wenei asu, kpam u lya ili wa, u so tani ili wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","A Damasuka vi katoni ka pini uza u kala Ananiya. Asheku a isa̱ yi a asuvu a kuwene, u danai, “Ananiya!” Aku u wushuki, “Mpa na, Asheku.” ");
INSERT INTO kdlNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Asheku a tonuko yi, “ꞌYa̱nga̱ vu bana a ure u ɗa a ka isa̱ Ure u Karara vu wecike kuwa ku Yahuza. Uza roku ɗa pini uza u Tarsu, uza ɗa a ka isa̱ Shawulu. Aya pini wa yan kavasu. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","N wenike yi ta̱ gba̱m kuwene. A asuvu a kuwene ki u wene ta̱ vuma ɗa a ka isa̱ Ananiya u taɗanku yi kukere a kaci tsa̱ra̱ u wene asu.” ");
INSERT INTO kdlNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiya wushuki, “Asheku, n so ta̱ upana̱sa alabari a vuma u nala vi a ili i cingi iꞌya wa yansa̱ka aza a uwulukpi a vunu a Urishelima. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Kpam aɗara̱kpi a pige a wushunku yi ɗe u ka̱na̱ gba̱ uza ɗa baci dem wa isa̱ asuvu a kala ka vunu.” ");
INSERT INTO kdlNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Asheku a tonuko yi, “Avu gai wala, kpaci aya n ɗanga̱sai u dansa kala ka va̱ a asu u Awulawa, na̱ ngono n le, kpam n a asu u aza a Isaraꞌila. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ma wenike yi ta̱ tyoku ɗa wa pana ikyamba adama a kala ka va̱.” ");
INSERT INTO kdlNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananiya ba u uwai a kuwa ki. U ꞌya̱nga̱sa̱i kukere u sawai Shawulu u danai, “Utoku u va̱, Asheku a ɗa a suku mu; wata, Yesu uza ɗa u wenikei kaci ka ne ara vunu a ure u ɗa vu walai vi. Wa ciga ta̱ vu doku vu wene asu, kpam u shaɗangu vu n Kulu Keri.” ");
INSERT INTO kdlNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Kute‑kute aku ili i roku i rukpa̱i a aꞌeshi a Shawulu yavu apici, aku u wenei asu. Pini nala, u ꞌya̱nga̱i a lyuɓugu yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","An u lyai ilikulya, aku ucira u ne u gonoi. Shawulu yain aꞌayin pini a asuvu a Damasuka kaɓolo n Atoni a ɗa aꞌa̱ri pini vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","A ɓa̱ra̱kpa̱ wa, aku u gita̱i kuɓari ku kadyanshi ka Kashila̱ a agata a Kashila̱ n u dansi Yesu ɗa Maku ma Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Gba̱ aza ɗa a pana̱ka yi a yain majiyan, a danai, “Vuma na vi aya u ꞌya̱nga̱sa̱ka̱i Atoni n u yansa̱ki le mavura a Urishelima vi wa? Tuwa̱ ɗa u tuwa̱i tsa̱ra̱ u ka̱na̱ le u sira̱sa u banka le a asu u aɗara̱kpi a pige wa ko?” ");
INSERT INTO kdlNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Shegai Shawulu doki ucira u kuɓari, wa̱ri a uvurusa̱ atakasuvu a aza a Yahuda aza ɗa aꞌa̱ri a Damasuka, n u dansi Yesu ɗa Kawauwi. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","An a yain aꞌayin ushani, aza a Yahuda a sheshei a wuna yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Shegai u panai alabari a ili iꞌya a sheshei. Aꞌa̱ri uwundya itsutsu i ilyuci yi kaara n kayin tsa̱ra̱ a ka̱na̱ yi a wuna. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Pini nala, kayin ka pige aɓa̱ngi a ne a zurala̱kpa yi a ilinuku i kasaga ka ilyuci a asuvu a mabana ma pige. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","An Shawulu rawai a Urishelima, u cigai u ɓolomgbono kaci n Atoni yi, shegai a panai uwonvo u ne kpaci a wushuku an eyi katoni ka wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Shegai Bara̱naba tuko yi a asu u asuki, u tonuko le tyoku ɗa Shawulu wenei Asheku a ure n tyoku ɗa Asheku a dansai n eyi. N tyoku ɗa kpam u yain kuɓari ku kadyanshi ka Kashila̱ n u dansi kala ka Asheku a Damasuka bawu uwonvo. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Asuki yi a wushuki n Shawulu. Pini nala, u dusuki n ele a Urishelima n u tambi asu asu, n u yanyi kuɓari n kala ka Asheku bawu uwonvo. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","U dansa ta̱ n u yanyi kananamgbani n aza a Yahuda a ɗa a ka pana kaletsu ka Tsiheline, adama a nala, aꞌa̱ri uzama ure u ɗa a ka wuna yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","An atoku a ne a panai nala, aku a banka yi a Kasariya a tutsuku yi a kpatsu ubana a Tarsu ilyuci i ne. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Gba̱ Atoni a ɗa aꞌa̱ri a uyamba u Yahuda, n u Galili, n u Samariya a tsa̱ra̱i ndishi n shinga. A panai uwonvo u Asheku, a yain ucira, Kulu Keri kpam ka̱ri a ugbamatangusu le hal aꞌa̱ri a udoku kakuma̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Aꞌayin a nala yi, Bituru kyawunsai uyamba vi gba̱, u ba u kondoi ama a Kashila̱ ɗa aꞌa̱ri a ilyuci i Lida. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Nte a gawunsai pini n vuma roku uza u kala Iniyasu, uza ɗa wa̱ri nvain na̱ mɓa̱la̱ n tsuwunu hal ayen kulla̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Aku Bituru tonuko yi, “Iniyasu, Yesu Kawauwi ta̱na̱sa̱ vu ɗe, ꞌya̱nga̱ vu ka̱ta̱la̱ kajiba ka vunu.” Kute‑kute u ꞌya̱nga̱i. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Gba̱ aza a Lida n aza a uyamba a Sarana a wenei vuma ɗa a ta̱na̱sa̱i vi, pini nala, a kpatalai a asu u Asheku. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Uka roku ɗa pini a Japa uza u kala Tabita; wata, Dokas n Tsiheline, uka vi katoni ka. U na̱ka̱ ta̱ kaci ka ne a asu u manyan ma maci n u ɓa̱ngi aza a unambi. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Aꞌayin a nala yi a ɗa u yain maɓa̱la̱ aku u kuwa̱i. Pini nala, a sumba̱ yi a vakunku yi a kunukuzuba. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","An Atoni yi a panai alabari cina Bituru pini a Lida evu n Japa, aku a suki ama a re a ba a foli yi a danai, “Tuwa̱ gogo.” ");
INSERT INTO kdlNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Bituru lazai kaɓolo n ele. An a rawai, aku a banka yi a kunukuzuba ki. Nra̱na̱ n shamgbai evu n eyi a ka sa̱, kpam a ka wenishike yi ntogo n aminya a ɗa Dokas yanka le cina eyi n uma. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Bituru wutukpa̱ le a ulanga, aku u kuɗa̱ngi u yain kavasu. U kpatalai a asu u kakushe ki u danai, “Tabita, ꞌya̱nga̱.” Aku u kukpa̱i aꞌeshi, an u wenei Bituru, u ꞌya̱nga̱i u dusuki. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Bituru ka̱na̱ yi kukere u ɓa̱nga̱ yi tsa̱ra̱ u ꞌya̱nga̱. Aku u isa̱i Atoni yi na̱ nra̱na̱ mi gba̱, u na̱ka̱ le n eyi n uma. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Alabari yi a tamburai gba̱ a uyamba u Japa, kpam ama a wushuki n Asheku. ");
INSERT INTO kdlNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Bituru dusuki a Japa aꞌayin ushani, a kuwa ku uza u manyan ma ikpan uza u kala Simo. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","A yan ta̱ vuma roku a ilyuci i Kasariya uza u kala Koniliyu, katigi ka a asuvu a kaɓolo ka asoje ka a ka isa̱ Kaɓolo ka Asoje a Italiya. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Vuma u maci u ɗa, u tsu rongo ta̱ ulyasa̱ka Kashila̱ kayala aꞌayin dem. Nala dem aza ɗa aꞌa̱ri a kuwa ku ne. U tsu na̱ka̱sa̱ ta̱ aza a unambi kune, n u yansi kavasu ubana a asu u Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Kain ka te, evu n ulapa u uwule u tatsu u kaara, aku u wenei katsumate ka zuba a asuvu a kuwene ka tuwa̱i ka tonuko yi, “Koniliyu.” ");
INSERT INTO kdlNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Koniliyu wa wundya yi tuntu n uwonvo. U wecei katsumate ki, “Ndya yi, Asheku?” Aku u wushuki, “Kashila̱ ka wushuku ta̱ kavasu ka va yansa ubana ara ne, kpam u reve ta̱ n kune ku va yansa̱ka aza a unambi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Suku ama roku ubana a ilyuci i Japa a ba a isa̱ vuma roku uza u kala Simo, uza ɗa dem a tsu isa̱ Bituru. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Aya pini wa rongo n vuma roku uza ɗa dem a tsu isa̱ Simo, vuma vi manyan ma ikpan ma wa yansa. Kuwa ku ne evu n kushiva̱ ɗa ka̱ri.” ");
INSERT INTO kdlNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","An katsumate ki ka lazai, aku Koniliyu isa̱i agbashi a ne a re n kasoje ka roku, uza ɗa wa tono Kashila̱ a asuvu aza ɗa a ka yansa̱ka yi manyan kain dem. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Aku u tonuko le gba̱ ili iꞌya i gita̱i, pini nala, u suku le a Japa. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","An kain ka wansai, n kaara a kaci ele a asuvu a nwalu, cina a yain evu n ilyuci yi, aku Bituru yuwa̱i a zuba u kunu u yain kavasu. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pini nala, kambulu ka ka̱na̱ yi, ele pini a ufoɓuso ilikulya yi, aku u wenei kuwene. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","U wenei zuba u kukpa̱i aku ili i roku yavu kunya ku pige ku ngan n nishi uba̱ra̱kpi a ka cipuka̱ ka utuwa̱ a iyamba. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","A kunya ki gba̱ icun i nnama n ɗa ma̱ri n aꞌene a nishi na̱ n ɗa ma ka̱bura̱ na̱ nnu n ɗa ma̱ri pini. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Aku u panai kala̱ga̱tsu ka danai, “Bituru, ꞌya̱nga̱ vu kiɗa vu takuma.” ");
INSERT INTO kdlNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Shegai Bituru wushuki, “Aꞌa, Magono ma Zuba, kotsu n takuma ili iꞌya bawu a wulukpei ko kpam iꞌya iꞌa̱ri n icaɗi iꞌya Mele ma tsunu ma ɓishinka tsu utakuma wa.” ");
INSERT INTO kdlNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Aku u doki u panai kala̱ga̱tsu ki upana u ire, “Kotsu vu isa̱ ili iꞌya Kashila̱ ka wulukpei, ili iꞌya bawu iꞌa̱ri uwulukpi wa.” ");
INSERT INTO kdlNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","An ukuna u nala u gita̱i hal kutatsu, kute‑kute aku a bidyai kunya ki ugono a zuba. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Bituru pini a kadambula ka kalen ka kuwene ku nala ki, aku ama ɗa Koniliyu suki vi a rawai a utsutsu, cina a wecike ɗe kuwa ku Simo ki. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","A danai, “Azakuwa,” aku a wecikei ko nte Simo uza ɗa a ka isa̱ Bituru vi wa̱ri pini. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Eyi pini a uyawunsa a kaci ka kuwene ka u wenei vi, aku Kulu Keri ku tonuko yi, “Ama a tatsu ɗa la a ka bolo vu. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Cipa̱ vu tono le. Kotsu vu yain mala̱la̱ wa, kpaci mpa n suku le.” ");
INSERT INTO kdlNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Bituru cipa̱i u cinai ama yi, u danai, “Mpa ya bolo. Ndya ya boluko mu n iꞌya?” ");
INSERT INTO kdlNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","A danai, “Katigi ka aza a Roma, uza u kala Koniliyu aya u suku tsu. Vuma maci u ɗa, uza ɗa u tsu rongo a ulyaka Kashila̱ kayala, uza ɗa kpam gba̱ aza a Yahuda a ka na̱ka̱ karinga̱. Katsumate ka zuba ka ka̱ri uwulukpi ka ka tonuko yi u isa̱ vu vu bana ara ne tsa̱ra̱ u pana iꞌya va dana.” ");
INSERT INTO kdlNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pini nala, Bituru uwai n ele a asuvu a kuwa, u na̱ka̱ le asu u ɗa a ka wansa. An kain ka wansai, Bituru, kaɓolo n Atoni a roku aza a Japa, a wuta̱i a lazai kaɓolo n aza ɗa Koniliyu suki vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","An kain ka doki ka wansai, aku a uwai a Kasariya. Alya Koniliyu wa̱ri a uvana hal gba̱m u libanai amaci a ne n aje a ne. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Bituru n u uwi a kuwa ki, aku Koniliyu ryabusa yi, u rukpa̱i a kapala ka ne u lyaka yi kayala. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Aku Bituru ꞌya̱nga̱sa̱ yi u tonuko yi, “ꞌYa̱nga̱, mpa dem vuma ɗa.” ");
INSERT INTO kdlNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","An Bituru wa̱ri kadyanshi n eyi, aku u uwai u cinai kakuma̱ ka ama ushani. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","U tonuko le, “Eɗa̱ n kaci ka ɗe i reve ta̱ u gan uza u Yahuda u gawan kaci ko kpam u ba u kondo Kawulawa wa. Shegai Kashila̱ ka wenike mu ta̱ u da, kotsu n isa̱ uza roku uza u ashinda̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Adama a nala, an i isa̱ mu n ꞌyuwan utuwa̱ wa. Gogo‑na ma ciga n pana ili iꞌya ya isa̱ka̱ mu vi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Koniliyu wushuki, “Aꞌayin a nishi a ɗa a wurai dere n gogo‑na naha, a ulapa u uwule u tatsu u kaara an ma̱ri a uyan kavasu, aku vuma roku u tuwa̱ mu n aminya a eri a ulaɗa u shamgbai a kapala ka va̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","U danai, ‘Koniliyu, a wushuku ɗe kavasu ka vunu, kpam kune ku va neshe aza a unambi yi ku woko ɗe ili i uciɓusa a asu u Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Adama a nala she vu suku a ubana a Japa a ba a isa̱ Simo uza ɗa a ka isa̱ Bituru. Aya pini u cipa̱i a kuwa ku Simo uza u manyan ma ikpan, uza ɗa wa rongo evu n kushiva̱.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ɗa i zuwai n suki ama n maloko a isa̱ vu vi, kpam u gan ta̱ an vu tuwa̱i. Gogo‑na a̱tsa na gba̱ tsunu tsu ɓolomgbonoi a asu u te tsa̱ra̱ tsu pana ili iꞌya Asheku a tonuko vu vu tonuko tsu.” ");
INSERT INTO kdlNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pini nala, Bituru gita̱i kadyanshi, “Mayun ɗa, n reve ta̱ Kashila̱ ka̱ri n kuɗyangi wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Shegai u wushi gba̱ ama ɗa a ka pana yi uwonvo, n a yanyi ili iꞌya wa ciga, a asuvu a kaletsu dem. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","I reve ta̱ n akani a ɗa Kashila̱ ka sukunki aza a Isaraꞌila, n a tonusuki le alabari a kayanyan ka ndishi n shinga a asu u Yesu Kawauwi. Aya kpam Asheku a ama gba̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","I reve ta̱ n ili iꞌya i gita̱i a uyamba u Yahuda, an Yahaya danai a lyuɓugu ko ya wa. Kpam a Galili ɗa ukuna u na vi u gita̱i. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","I reve ta̱ Kashila̱ ka ka na̱ka̱i Yesu uza u Nazara tsupige, Kulu Keri ka̱ ta̱ n eyi, kpam wa̱ ta̱ n ucira cika. U tamba ta̱ n u yansi ukuna u shinga, n u ta̱na̱si aza ɗa Kala̱pa̱nsi ka ꞌyanki, kpaci Kashila̱ ka̱ ta̱ n eyi. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“A̱tsa tsu wenei ukuna u ɗa u gita̱i n eyi a uyamba u Yahuda, n Urishelima. Alya a wuna yi a mawandamgbani. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Shegai Kashila̱ ka ꞌya̱nga̱sa̱ yi a kain ka tatsu, kpam u zuwa yi u wenike kaci ka ne a asu u ama. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","U wenike kaci ka ne a asu u ama gba̱ wa, shegai ara tsunu; wata, a̱tsu aza ɗa Kashila̱ ka ɗanga̱sai caupa, tsa̱ra̱ tsu woko aza ɗa a wenei ukuna vi. A̱tsa aza ɗa tsu lyai kpam tsu soi kaɓolo n eyi an u ꞌya̱nga̱i a ukpa̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Kpam u tonuko tsu tsu yanka ama kuɓari, tsu tonuko le Yesu ɗa Kashila̱ ka ɗanga̱sai u yanka aza uma n akushe afada. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Gba̱ ntsumate n yan ta̱ kadyanshi ka ne a danai, ‘Gba̱ uza ɗa baci u wushuki n kala ka ne, a ka cimbusuka̱ yi ta̱ unyushi u cingi u ne.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Bituru pini a kadyanshi ki, aku Kulu Keri ku cipa̱i a kaci ka aza ɗa a ka pana̱ka yi vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Aku aza a Yahuda a ɗa aꞌa̱ri Atoni a asuvu a aza ɗa a tuwa̱i n Bituru vi, a yain majiyan an a wenei dem Awulawa a wushai kune ku Kulu Keri ki. ");
INSERT INTO kdlNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kpaci a pana̱ka le ta̱ a ka dansa n aletsu a roku, n a cikpali Kashila̱. Pini nala, Bituru danai, ");
INSERT INTO kdlNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Awulawa a na yi dem a wusha ta̱ Kulu Keri tyoku ɗa a̱tsu tsu wushai. Uza wa̱ la wa ɓishinka a lyuɓugu le wa.” ");
INSERT INTO kdlNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Aku u zuwai a lyuɓugu le a asuvu a kala ka Yesu Kawauwi. Pini nala, a folo yi u doku u yain aꞌayin n ele. ");
INSERT INTO kdlNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Asuki yi n Atoni a ɗa aꞌa̱ri a Yahuda a panai alabari a ɗa Awulawa a wushai kadyanshi ka Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Shegai an Bituru gonoi a Urishelima, aku Atoni a roku aza ɗa aꞌa̱ri aza a Yahuda a yanka yi kushulu. ");
INSERT INTO kdlNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","A danai, “Ndya i zuwai vu banai a asu u Awulawa, hal vu lyai kaɓolo n ele?” ");
INSERT INTO kdlNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Aku Bituru tonuko le ili iꞌya i gita̱i. ");
INSERT INTO kdlNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","U danai, “Kain ka te a Japa, tyoku ɗa ma̱ri a kavasu aku n wenei kuwene. N wenei ili i roku yavu kunya ku pige ku ngan n nishi uba̱ra̱kpi a ka cipuka̱ ka utuwa̱ a iyamba, hal ku rawai evu na̱ mpa. ");
INSERT INTO kdlNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","An n weɓelei kunya ki mai n wenei gba̱ icun i nnama n kenu, na̱ nnama n mete, n ili i nka̱buru, na̱ nnu. ");
INSERT INTO kdlNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Aku n panai kala̱ga̱tsu ka danai, ‘Bituru, ꞌya̱nga̱ vu kiɗa vu takuma.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Pini nala, n wushuki, ‘Ko kenu, Magono ma Zuba, ili iꞌya bawu iꞌa̱ri uwulukpi, ko i icaɗi iꞌya Mele ma tsunu ma ɓishinka tsu utakuma kotsu i uwa a una̱ u va̱ wa.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Shegai kala̱ga̱tsu ka ka wuta̱i a zuba vi ka doki ka danai ukuna u ire, ‘Kotsu vu isa̱ ili iꞌya Kashila̱ ka wulukpei, ili iꞌya bawu iꞌa̱ri uwulukpi wa.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Kutatsu ka a yain nala kahu a canga ili yi ubana a zuba. ");
INSERT INTO kdlNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Derere u ukuna vi u ɗa ama a tatsu a ɗa a suki a Kasariya a rawai a kuwa ka ma̱ri vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Aku Kulu Keri ku tonuko mu n toni le kpam n dambula an a wokoi Awulawa wa. Atoku a va̱ ama a teli a na yi alya a soku mu, hal tsu uwai a kuwa ku uza ɗa u suku le vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","U tonuko tsu kpam tyoku ɗa u wenei katsumate ka zuba ka shamgbai a kuwa ku ne ka tonuko yi, ‘Suku a ba a isa̱ Simo uza ɗa a ka isa̱ Bituru a Japa. ");
INSERT INTO kdlNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Aya wa tonuko vu tyoku ɗa avu n kuwa ku vunu gba̱ ya tsa̱ra̱ iwauwi.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Kadyanshi ka n gita̱ le uyanka, aku Kulu Keri ku cipa̱i ara le dere tyoku ɗa ku cipa̱ tsu a kagita̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Pini nala, aku n ciɓai an kadyanshi ka Kashila̱ ka danai, ‘Yahaya gai n mini ma u lyuɓugusi, shegai eɗa̱ Kashila̱ ka lyuɓugu ɗa̱ ta̱ n Kulu Keri.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","An u wokoi Kashila̱ ka yanka le kune derere tyoku ɗa u yanka tsu aꞌayin a ɗa tsu wushuki n Yesu Asheku Kawauwi, ya mpa n ɓishinka Kashila̱?” ");
INSERT INTO kdlNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","An a panai nala aku a nambai ili iꞌya a ka dana, pini nala, a ka̱na̱i ucikpala Kashila̱ a danai, “Gogo‑na dem Kashila̱ ka wushuku ɗe Awulawa a kpatala utuwa̱ ara ne, kpam u ne le ɗe uma.” ");
INSERT INTO kdlNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","An Isitifanu kuwa̱i, aku a gita̱i uyan Atoni yi mavura, hal a wacuwai ubana a mɓa̱ri. A rawa ta̱ a Finisiya n Sayipuru n Antakiya u Suriya. A yain kuɓari ku Kadyanshi ka Shinga ka Kashila̱, shegai aza a Yahuda a ɗa a yankai kuɓari ki koshi. ");
INSERT INTO kdlNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Asuvu a Atoni a ɗa a wacuwai vi aza roku a wuta̱i a Sayipuru n Sirani a banai a Antakiya, a ka̱na̱i uyanka Awulawa Kadyanshi ka Shinga ka Yesu Asheku. ");
INSERT INTO kdlNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ucira u Asheku wa̱ ta̱ kaɓolo n ele, hal ama ushani a wushuki a kpatalai asu u Asheku. ");
INSERT INTO kdlNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","An Atoni a ɗa aꞌa̱ri a Urishelima a panai ili iꞌya i gita̱i a Antakiya, a suki Bara̱naba ubana ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Vuma u maci ɗa uza ɗa wa̱ri ushaɗangi n Kulu Keri kpam u pityanangi. An u rawai u wenei ukuna u shinga u ɗa Kashila̱ ka yanka le, u yain ipeli cika. Aku u rono le atsuvu a pityanangu n Asheku n katakasuvu ka le ubana. Ama ushani a doku ta̱ a kpatalai ubana a asu u Asheku. ");
INSERT INTO kdlNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Pini nala, Bara̱naba banai a Tarsu uzama Shawulu. ");
INSERT INTO kdlNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","An u wene yi, aku u tuko yi a Antakiya. Ama a re a le gba̱ a shamgbai pini n Atoni yi hal kayen ka te dere, n a wenishiki kakuma̱ ka ama. A Antakiya ɗa a gita̱i uꞌisa̱ atoni a Yesu n kala ka Aza a Kirisiti.† ");
INSERT INTO kdlNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Aꞌayin a na yi a ɗa ntsumate n roku n wuta̱i a Urishelima a banai a Antakiya. ");
INSERT INTO kdlNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Uza u te a asuvu a le uza u kala Agaba u ꞌya̱nga̱i u yain kadyanshi n ucira u Kulu Keri u danai, “A ka tuwa̱ ta̱ a yain kambulu ka pige a likimba gba̱.” (Aꞌayin a ɗa Kaladiyu wa lya tsugono tsu Roma ɗa udani u na vi u shaɗangi.) ");
INSERT INTO kdlNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Aꞌayin a nala yi, Atoni a sukunku ta̱ atoku a le a ɗa aꞌa̱ri a Yahuda kune. Ya dem suki utyoku u ucira u ne. ");
INSERT INTO kdlNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Nala a yain a sukunki nkoshi ma atoni a Yahuda kune a akere a Bara̱naba n Shawulu. ");
INSERT INTO kdlNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Aꞌayin a nala yi a ɗa Hiridu Agaripa magono u gita̱i uforo ama a Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Hal gba̱m u zuwai a kapamgbanai kaci ka Yakubu utoku u Yahaya n burundu. ");
INSERT INTO kdlNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","An u wenei aza a Yahuda a panai kayanyan ka ili iꞌya u yain, aku u ka̱na̱i dem Bituru. Aꞌayin a Ulya u Ilikulya iꞌya i Nambai Yisti† ɗa ukuna vi u gita̱i. ");
INSERT INTO kdlNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","An u ka̱na̱ yi, aku u gida̱ku yi a kuwa ku aꞌali. U na̱ka̱ngu yi a akere a asoje a nishi a nishi hal asu kunishi a wundi yi, tsa̱ra̱ a kotso baci Abiki yi, u tuko yi a kapala ka ama u yanka yi afada. ");
INSERT INTO kdlNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Aꞌayin a ɗa Bituru wa̱ri pini a kuwa ku aꞌali ki, aku ama a Kashila̱ aꞌa̱ri uyan kavasu adama a ne. ");
INSERT INTO kdlNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","N kayin ka Hiridu wa yawunsa kain ka wansa baci u wutukpa̱ yi tsa̱ra̱ u yanka yi afada yi, Bituru wa̱ri alavu a mere ma asoje a re usiri n ikani i re. Kpam asoje a re aza ɗa a ka wundya kuwa ki kushani a utsutsu. ");
INSERT INTO kdlNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Kute‑kute aku katsumate ka zuba ka Magono ma Zuba ka wenikei kaci ka ne ara ne, aku katyashi ka wakanai kunu ki. Aku katsumate ki ka sawai Bituru a ikengi u ꞌya̱nga̱sa̱ yi u danai, “ꞌYa̱nga̱ gogo!” Pini nala, ikani yi i sa̱ruwa̱i. ");
INSERT INTO kdlNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Katsumate ki ka tonuko yi, “Uka matogo n akpata a vunu.” Aku u yain nala. U tonuko yi kpam, “Wambana kunya ku vunu, vu tono mu.” ");
INSERT INTO kdlNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Aku u wuta̱i u tono yi, kpam u reve an ili iꞌya katsumate ki ka yan vi mayun ɗa wa, eyi n u dani kuwene ka a ka wenike yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","An a wurai asoje a ɗa a ka wundya kuwa ki aza a kagita̱ n aza a ire, aku a rawai a utsutsu u urim, utsutsu u uwa a ilyuci yi. Aku utsutsu vi u giduwa̱i n kaci ka ne, aku a wuta̱i. An a rawai a nsandu ma ure, kute‑kute katsumate ki ka a̱sa̱ka̱ yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pini nala, ugboji u Bituru u gono yi, u danai, “Gogo‑na n reve ta̱ Magono ma Zuba ma ma suki katsumate ka zuba ka ne tsa̱ra̱ u wauwa mu a kukere ku Hiridu, n ukuna u cingi u ɗa aza a Yahuda a foɓusoi a kaci ka va̱.” ");
INSERT INTO kdlNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","An u revei nala, aku u banai a kuwa ku Meri mma u Yahaya uza ɗa kpam dem a ka isa̱ Marku, a asu u ɗa ama ushani a ɓolomgbonoi aꞌa̱ri uyan kavasu. ");
INSERT INTO kdlNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","An u kuɗai utsutsu u danai aza a kuwa, aku kagbashi ka ka̱ri makere uza u kala Ruda tuwa̱i tsa̱ra̱ u wene ko yayi. ");
INSERT INTO kdlNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","An u revei kala̱ga̱tsu ka Bituru ka, u giduwa̱ kpam utsutsu vi wa adama a maza̱nga̱, aku u gonoi a asuvu a kuwa n ilyaɗi, u danai, “Bituru ɗa pini kushani a utsutsu u kuwa.” ");
INSERT INTO kdlNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","A danai, “Ijan iꞌya vu?” Eyi tani u ma̱tsa̱i n u dansi aya. Aku a danai, “Yan maken wa, katsumate ka ne ka!” ");
INSERT INTO kdlNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Bituru gai lyai kapala n ukuɗusa utsutsu vi, aku a giduwa̱i a wene yi, a yain majiyan cika. ");
INSERT INTO kdlNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","U yanka le iryoci n kukere u da a paɗa bini. U tonuko le tyoku ɗa Magono ma Zuba ma wutukpa̱ yi a kuwa ku aꞌali. U doki u tonuko le, “Tonukoi Yakubu n Atoni a ɗa a buwai ukuna vi.” Aku u ꞌya̱nga̱i u banai a asu u roku. ");
INSERT INTO kdlNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","An kain ka wansai, ugiruwa̱ u kenu u ɗa asoje yi a giruwa̱i wa, adama a ili iꞌya i gita̱i n Bituru. ");
INSERT INTO kdlNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","An Hiridu zama yi bawu u wene yi. Aku u wecishei asoje a ɗa a ka wundya yi vi. Pini nala, u zuwai a wuna le. An nala u wurai, Hiridu ꞌya̱nga̱i a Yahuda ubana a Kasariya u yain aꞌayin ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Aꞌayin a nala yi, Hiridu wa̱ ta̱ n upan u ama a Taya n Sida. Shegai an a ka ciga ilikulya a asu u tsugono tsu Hiridu, aku a tuwa̱i ara ne n katakasuvu ka te. A boloi uɓolomgbono u kaci u Bilasutu kagbashi ka ka kirana n kunu ku magono, a zamai ndishi n shinga. ");
INSERT INTO kdlNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Kain ka te an a foɓusoi, aku Hiridu ukai aminya a tsugono u dusuki a karatsu ka tsugono, u yanka le kadyanshi. ");
INSERT INTO kdlNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","An kakuma̱ ka ama ki ka panai, aku a ꞌya̱nga̱sa̱i ala̱ga̱tsu a le a danai, “Kala̱ga̱tsu ka kashila̱ ka roku ka na vi, ka vuma ka wa.” ");
INSERT INTO kdlNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kute‑kute, aku katsumate ka zuba ka Magono ma Zuba ka gbasha yi, kpaci u bidiga ta̱ kaci ka ne tsupige aku u ꞌyuwain una̱ka̱ Kashila̱ tsupige. Pini nala, azun a katsuma̱ a gita̱ yi utakuma hal u kuwa̱i. ");
INSERT INTO kdlNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Kadyanshi ka Kashila̱ kpam ka̱ri a ulya kapala n ka tamburi. ");
INSERT INTO kdlNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","An Bara̱naba n Shawulu a kotsoi manyan ma a na̱ka̱ le a Urishelima, aku a gonoi a Antakiya kaɓolo n Yahaya Marku. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","A asuvu a Atoni a ɗa aꞌa̱ri a Antakiya vi, ntsumate n ɗa pini hal n awenishiki; wata, Bara̱naba, n Saminu uza ɗa a ka isa̱ “Uza u Da̱n,” n Lusiya uza ɗa u wuta̱i a Sirani, n Manayan, uza ɗa u gbonguroi kaɓolo n Hiridu Antiba, n Shawulu. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Kain ka te, tyoku ɗa ama a na aꞌa̱ri ulyaka Magono ma Zuba kayala n a yanyi kakuli, Kulu Keri ku danai, “Takpa numu Bara̱naba n Shawulu adama a manyan ma n isa̱ le n ma.” ");
INSERT INTO kdlNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","An a doki a yain kakuli n kavasu, aku a taɗanki Bara̱naba n Shawulu akere a tutsuku le a ka̱na̱ ure. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","An Kulu Keri ku suki Bara̱naba n Shawulu a banai a Salusiya, a uwai a kpatsu ubana a uyamba u mere ma mini u Sayipuru. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","An a rawai a ilyuci i Salami, a yain kuɓari ku kadyanshi ka Kashila̱ a agata a Kashila̱ a aza a Yahuda. Yahaya Marku dem bana ta̱ kaɓolo n ele wa ɓa̱nga̱ le. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","An a kyawunsai uyamba vi gba̱ hal ubana a ilyuci i Pafasu. Aku a gawunsai n uza u Yahuda u roku uza u ada̱bu uza u kala Bara-Yesu. Eyi matsumate ma kaɓan ma, ");
INSERT INTO kdlNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","uza ɗa wa̱ri kaɓolo n gomuna Sarajiya Bulus. Gomuna vi vuma ɗa uza u ugboji. U libana le a bana ara ne, kpaci wa ciga ta̱ u pana kadyanshi ka Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Shegai Alimasu uza u ada̱bu vi u ɓolomgbono kaci n ele wa. (Alimasu ɗa a ka isa̱ Bara-Yesu vi n Tsiheline.) Wa ciga a kpatala ugboji u gomuna vi tsa̱ra̱ u pityanangu wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Shegai Shawulu, uza ɗa a ka isa̱ Bulus, ushaɗangi n Kulu Keri aku ku tonoi n eyi, u wundyanai Alimasu, u danai, ");
INSERT INTO kdlNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Avu maku ma Kala̱pa̱nsi uza u tsilala n iꞌya iꞌa̱ri i maci! Vu shaɗangu ta̱ n tsukunu n ula̱pa̱na̱sa̱. Va a̱sa̱ka̱ unangasa ire i shinga i Magono ma Zuba wa? ");
INSERT INTO kdlNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Gogo‑na asuvu a upan u Kashila̱ a ka rukpa̱ ta̱ a kaci ka vunu, va rumba̱na̱ ta̱, ubana aꞌayin kenu va wene asu wa.” Kute‑kute karimbi ka kimba̱ yi aꞌeshi, aku u ka̱na̱i upapa wa bolo uza ɗa wa ka̱na̱ yi kukere. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","An gomuna wenei ili iꞌya i gita̱i, aku u wushuki, u yain majiyan ma uwenishike u Asheku. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Bulus n atoku a nwalu a ne a a̱sa̱ka̱i ilyuci i Pafasu a uwai a kpatsu ubana a uyamba u Bamafiliya. An a rawai a ilyuci i Paraga, a wuta̱i a kpatsu ki, aku Yahaya Marku a̱sa̱ka̱ le u gonoi a Urishelima. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Shegai Bulus n Bara̱naba a ꞌya̱nga̱i a Paraga a lyai kapala a banai a Antakiya u uyamba u Bisidiya. Kain ka Ashibi a uwai a kagata ka Kashila̱ a dusuki. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","An a yain ka̱neshi a itagara̱da i Mele ma Musa n i Ntsumate, aku azapige a kagata ka Kashila̱ a suki a tonuko le, “Atoku, iꞌa̱ baci n kadyanshi ka kuɓari ku ya doku ama, she i yain.” ");
INSERT INTO kdlNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Bulus ꞌya̱nga̱i u yanka le iryoci n kukere a paɗa bini, u danai, “Aza a Isaraꞌila n Awulawa a ɗa a ka lyaka Kashila̱ kayala, pana̱ka numu! ");
INSERT INTO kdlNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Kashila̱ ka aza a Isaraꞌila ka ɗanga̱sai isheku i tsunu, u zuwai a yain kakuma̱ aꞌayin a ɗa a rongoi a uyamba u Masar. N ucira u pige u ne u ɗa u wutukpa̱ le pini a uyamba vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","U kawunki n ele hal ayen amangare a kakamba. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","U wusai uyamba u aletsu a shindere a Kaꞌana, aku u na̱ka̱i u ɗa ama a ne u wokoi agadu a le. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Nala gita̱ ta̱ a asuvu a ayen amangatawanishi n amangarenkupa (450). “U na̱ka̱ le aza a afada, kpam a rongoi pini hal ubana aꞌayin a Samaꞌila† matsumate. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Shegai aza a Isaraꞌila a zamai a na̱ka̱ le magono, aku Kashila̱ ka na̱ka̱ le Shawulu maku ma Kishu uza u kagali ka Bayami† u lyai tsugono. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","An Kashila̱ ka takpa yi tsugono, u zuwai Dawuda. Kashila̱ ka yain kadyanshi a kaci ka Dawuda, u danai, ‘N tsa̱ ɗe Dawuda maku ma Yese, vuma ɗa uza ɗa u tsu zuwa katakasuvu ka va̱ ka rongo n ipeli, kpaci wa yan ta̱ gba̱ ili iꞌya ma ciga yi u yain.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Kashila̱ ka yain kazuwamgbani a asuvu a kagali ka vuma nala vi u zuwai Kawauwi ka aza a Isaraꞌila ka wuta̱ pini. Kpam Yesu ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Shegai kahu Yesu tuwa̱, Yahaya rongo ta̱ utonusuko ama a kpatala a lyuɓugu le. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","An Yahaya yain evu n ukotso manyan ma ne, u wecikei, ‘Ya wundya mpa Kawauwi ki? Mpa Kawauwi ki wa. Kawauwi ki ka̱ ta̱ a utuwa̱, mpa n ra̱tsa gba̱m ma surukpa isirikatsu i akpata a ne wa.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ama a va̱, eɗa̱ aza ɗa iꞌa̱ri a kagali ka Ibirahi, n a̱ɗa̱ Awulawa a ɗa a ka na̱ka̱ Kashila̱ karinga̱, panai na! A̱tsa Kashila̱ ka sukunki akani a iwauwi yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Azapige a aza a Urishelima n ama a le a reve an Yesu ɗa Kawauwi ka mayun ki wa. A reve dem an aya ntsumate n korongi a kaci ka ne kpam a tsu yansa ka̱neshi Ashibi dem vi wa. Shegai kadyanshi ka a yain a kaci ka ne ka shaɗangu ta̱ an a kiɗa̱ga yi ugana u ukpa̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","29","A yan ta̱ dere ili iꞌya tagara̱da u Kashila̱ u danai. Ko an u wokoi a tsa̱ra̱ unyushi u ɗa a ka wuna yi wa, gba̱ n nala a tonukoi Bilatu Gomuna u wandamgbana yi. “An u kuwa̱i, aku a cipuka̱ yi a mawandamgbani mi a uka yi a kasaun. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Shegai Kashila̱ ka ꞌya̱nga̱sa̱ yi ta̱ a ukpa̱! ");
INSERT INTO kdlNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Aꞌayin a nala yi, u wenishike ta̱ kaci ka ne a asu u atoni a ne aza ɗa a yansai nwalu kaɓolo a Galili hal ubana a Urishelima. Gogo‑na alya a ka tonusuko ama a tsunu ukuna u ne. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","“Kpam a̱tsa na tsu tuko ɗa̱ Kadyanshi ka Shinga: ili iꞌya Kashila̱ ka yain kazuwamgbani wa yanka akaya a tsunu iꞌya gai la vi. Gogo‑na u yanka tsu ta̱ iꞌya a̱tsu aza ɗa tsa̱ri mmuku n tsikaya n ne aꞌayin a ɗa u ꞌya̱nga̱sa̱i Yesu a ukpa̱. A korongu ta̱ ukuna u na vi a tagara̱da u Ishipa u ire: “ ‘Aɗa Maku ma va̱, ara n woko ta̱ Tata u vunu.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Kashila̱ ka ꞌya̱nga̱sa̱ ta̱ Yesu a ukpa̱ kpam wa a̱sa̱ka̱ ikyamba i ne i shama wa, dere tyoku ɗa u danai: ‘Ma zuwuka vu ta̱ una̱ u shinga u uwulukpi u ɗa n da ma zuwuka Dawuda.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“A korongu ta̱ a Ushipa u roku: ‘Va a̱sa̱ka̱ Uza u Uwulukpi u vunu u shama wa.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Aꞌayin a ɗa Dawuda wa̱ri n uma, u pana̱ka ta̱ Kashila̱. An u tuwa̱ u kuwa̱i, aku a ciɗa̱ngu yi a asu u asaun a akaya a ne, ikyamba i ne kpam i shamai. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Shegai Kashila̱ ka ꞌya̱nga̱sa̱ ta̱ Yesu a ukpa̱ kpam ikyamba i ne i shama wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","“Ama a va̱, zuwai atsuvu mai a ili iꞌya tsa tono: adama a ili iꞌya Yesu yain, iꞌya i zuwai tsu tsa̱ra̱i ucimbusa̱ u unyushi u cingi gogo‑na. Mele ma Musa ma fuɗa ma gonuko ɗa̱ i woko dere wa. Shegai adama a Yesu, uza ɗa baci dem u wushuki wa woko ta̱ dere. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kiranai, kawa ili iꞌya ntsumate n korongi ya gita̱ ta̱ n a̱ɗa̱. A dana ta̱: ");
INSERT INTO kdlNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“ ‘Panai na, aza a majari, i shaɗangi n majiyan i kuwa̱! Kpaci ma yan ta̱ manyan ma roku a aꞌayin a ɗe, manyan ma ya kpa̱ɗa̱ uwushuku n ma, ko uza roku u tonuko ɗa̱ baci tani.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","43","Wuta̱ ɗa Bulus n Bara̱naba a ka wuta̱ a kagata ka Kashila̱ ki, aku aza a Yahuda n Awulawa ushani aza ɗa a ka lyaka Kashila̱ kayala a tono le. Pini nala, Bulus n Bara̱naba aꞌa̱ri le ugbamatangusu asuvu a lyai kelime n uwushukusu n ukuna u shinga u Kashila̱. Aku ama yi a folo le a doku a yain kadyanshi a kaci ka ili i na yi n Ashibi a ɗa a ka tuwa̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","An Ashibi a kyawain, ama a ilyuci yi ushani a tuwa̱ ta̱ a pana kadyanshi ka Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","An aza a Yahuda a wenei kakuma̱ ka ama ki, a yan ta̱ malyon cika. A wishai Bulus kpam a ꞌyuwain ili iꞌya u danai. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Aku Bulus n Bara̱naba a dansai karara bawu uwonvo, a danai, “Eɗa u ka̱na̱i tsu gita̱ uyanka kuɓari ku kadyanshi ka Kashila̱, shegai i ꞌyuwain ka uwusha. Nala u wenike ta̱ an bawu i ra̱tsai i wushi uma u ɗa bawu wa̱ri n utyoku. Adama a nala, tsa a̱sa̱ka̱ ɗa̱ ta̱ aku tsu bana a asu u Awulawa. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ili iꞌya Kashila̱ ka tonuko tsu tsu yain iꞌya na: ‘N zuwa ta̱ vu woko katyashi a asu u Awulawa, tsa̱ra̱ vu tuko iwauwi hal ubana likimba gba̱.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","An Awulawa a panai nala, a pana ta̱ kayanyan aku a cikpalai kadyanshi ka Asheku. Aza ɗa a ɗanga̱sai adama a uma u ɗa bawu wa̱ri n utyoku a wushuku ta̱ n Asheku. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Pini nala, kadyanshi ka Asheku ka tamburai ko nte wa a uɓongu vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Aku aza a Yahuda a banai a asu u azapige a roku a ilyuci yi n aka a ɗa a ka na̱ka̱ tsupige. A zuwa le a ꞌyuwain Bulus n Bara̱naba, aku a gita̱ le mavura hal a loko le a kaɓon ka uyamba ki. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Aku Bulus n Bara̱naba a ka̱pa̱tsa̱i kabuta̱ ka aꞌene a le adama u woko iryoci a kaci ka aza a ilyuci yi, pini nala, a lazai ubana a ilyuci i Ikaniya. ");
INSERT INTO kdlNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Shegai atoni a Antakiya yi a woko ta̱ n maza̱nga̱ kpam ushaɗangi n Kulu Keri. ");
INSERT INTO kdlNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","An Bulus n Bara̱naba a rawai a Ikaniya, a uwai a kagata ka Kashila̱ ka aza a Yahuda tyoku ɗa a yain kuɓari a Antakiya. Ama ushani aza a Yahuda n Awulawa a wushuku ta̱ n kadyanshi ka Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Shegai aza a Yahuda a ɗa a kpa̱ɗa̱i uwushuku n kadyanshi ki, a vurusa̱i aꞌene a Awulawa a ɗa bawu kotsu a wushuki, a nangasai ndishi n le n ama a Kashila̱ yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Gba̱ n nala, asuki yi a ɓa̱ra̱kpa̱i pini n ele cika, n a yanyi kuɓari ku kadyanshi ka ukuna u shinga u Asheku bawu uwonvo. Kpam u na̱ka̱ le ucira u uyan iryoci n ikunesavu. ");
INSERT INTO kdlNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ama a ilyuci yi a pecei kure, aza roku a ka tono aza a Yahuda, aza roku kpam a ka tono asuki. ");
INSERT INTO kdlNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Aku Awulawa a roku n aza a Yahuda n azapige a le a ɓolomgbonoi kaci tsa̱ra̱ a yain asuki yi mavura, kpam a vara̱sa le n atali a wuna. ");
INSERT INTO kdlNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","An asuki yi a revei ukuna u ɗa wa̱ri a nwalu, aku a sumai ubana a uyamba u Likiya; wata, ilyuci i Lisitira n Daraba n une iꞌya i kyawan le. ");
INSERT INTO kdlNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Nte a lyai pini kapala n uyan kuɓari ku Kadyanshi ka Shinga. ");
INSERT INTO kdlNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","A Lisitira vi, Bulus n Bara̱naba a cinai vuma roku uza ɗa a matsai kawunu, uza ɗa tun a matsa yi u wala wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Wa̱ri a upana kuɓari ku Bulus wa̱ri uyan, pini nala, Bulus wenei vuma vi wa̱ ta̱ n upityanangu u ɗa u rawai a ta̱na̱sa̱ yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Aku u danai, “ꞌYa̱nga̱ vu shamgba n aꞌene a vunu.” Kute‑kute vuma vi u ꞌya̱nga̱i u gita̱i nwalu. ");
INSERT INTO kdlNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","An kakuma̱ ka wenei ili iꞌya Bulus yain, aku a ꞌya̱nga̱sa̱i ala̱ga̱tsu n kaletsu ka aza a Likiya, a danai, “Ama a na yi ashila̱ a roku a ɗa a cipa̱ tsu n iryoci i ama!” ");
INSERT INTO kdlNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Aku a na̱ka̱i Bara̱naba kala Zafosa, Bulus kpam Hamisa kpaci aya kayain ka kadyanshi. ");
INSERT INTO kdlNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Pini nala, kaɗara̱kpi ka katani ka Zafosa kameli ka ka̱ri a uroto u ilyuci vi u kalai anaka n apa̱lu u tukoi a ɗa a utsutsu u ilyuci vi, tsa̱ra̱ eyi n ama a ne a yanka asuki yi uɗara̱kpa. ");
INSERT INTO kdlNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Shegai an asuki yi a panai nala, aku a kara̱sai aminya a le adama a unamgbukatsuma̱, a uwai a asuvu a kakuma̱ ka ama ki n ilyaɗi n a dansi, ");
INSERT INTO kdlNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Atoku a tsunu, ndya i zuwai ya yan naha? A̱tsu dem ama ɗa tyoku u ɗe. Kadyanshi ka Shinga ka tsu tuko ɗa̱ tsa̱ra̱ i kpatala i a̱sa̱ka̱ ili i gbani i nala yi i gono a asu u Kashila̱ Uza u Uma, uza ɗa u yain zuba n likimba n kushiva̱ n gba̱ ili iꞌya iꞌa̱ri pini a asuvu a le. ");
INSERT INTO kdlNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Caupa u a̱sa̱ka̱ ta̱ gba̱ ama a likimba a yain ili iꞌya i luwa le. ");
INSERT INTO kdlNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Shegai u tsu wenike ta̱ kaci ka ne a asu u ili i shinga iꞌya u tsu yansa. Kashila̱ ka tsu suku ta̱ mini ma zuba, tsa̱ra̱ iceshi i ɗe i yain. U na̱ka̱ ɗa̱ kpam ilikulya kpam u zuwa ɗa̱ ipeli.” ");
INSERT INTO kdlNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Gba̱ n kadyanshi ka a yanka le vi, she na a ma̱tsa̱i aku a fuɗai a ɓishinka le uɗara̱kpa vi adama a le. ");
INSERT INTO kdlNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Shegai aza a Yahuda a roku a wuta̱i a uyamba u Antakiya n Ikaniya a leshei ama yi a vara̱sai Bulus a rono yi ubana a uroto u ilyuci, n a dani u kuwa̱ ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","An Atoni a tuwa̱i a kyawan yi, aku u ꞌya̱nga̱i u gonoi pini a ilyuci yi. An kain ka wansai aku a lazai ubana a Daraba kaɓolo n Bara̱naba. ");
INSERT INTO kdlNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","An Bulus n Bara̱naba a yain kuɓari ku Kadyanshi ka Shinga a Daraba, a tsa̱ra̱ ta̱ Atoni ushani. Pini nala, a gonoi a Lisitira n Ikaniya n Antakiya u Bisidiya. ");
INSERT INTO kdlNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","A gbamatangusu ta̱ atakasuvu a ama a Kashila̱ n a ɓara le a shamkpa upityanangu u le mai, n a dansi, “She tsu pana ikyamba aku tsu tsa̱ra̱ uꞌuwa a tsugono tsu Kashila̱.” ");
INSERT INTO kdlNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Bulus n Bara̱naba a yain kavasu n kakuli, aku a ɗanga̱sa̱kai kuwa ku Atoni dem nkoshi. A na̱ka̱ le a asu u Asheku uza ɗa nkoshi mi n wushuki n eyi. ");
INSERT INTO kdlNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","An a tonoi a Bisidiya aku a rawai a Bamafiliya. ");
INSERT INTO kdlNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","An a yain kuɓari a Paraga, aku a lazai ubana a Ataliya. ");
INSERT INTO kdlNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Pini nala, a uwai a kpatsu a banai a Antakiya, a asu u ɗa caupa a yanka le kavasu tsa̱ra̱ Kashila̱ ka kirana n ele a asuvu a manyan ma a kotsoi vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","N urawa u le, aku a ɓolomgbonoi ama a Kashila̱ a asu u te a tonuko le ili iꞌya Kashila̱ ka yain adama a le, n tyoku ɗa kpam u kukpunka̱i Awulawa ure u upityanangu. ");
INSERT INTO kdlNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Aku a ɓa̱ra̱kpa̱i pini n ama a Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","An Bulus n Bara̱naba aꞌa̱ri a Antakiya u Suriya, aku ama roku a wuta̱i a Yahuda a tuwa̱i a Antakiya a ka wenishike Atoni. Aku a ka dansa, “A kiɗa ɗa̱ baci acombi tyoku ɗa Mele ma Musa ma danai wa, ya tsa̱ra̱ iwauwi wa.” ");
INSERT INTO kdlNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pini nala, Bulus n Bara̱naba a yain kananamgbani n ele cika, adama a kadyanshi ka nala ki. Aku Atoni† a zuwai Bulus n Bara̱naba n Atoni a roku a bana a Urishelima a asu u asuki na̱ nkoshi n kuwa ku Atoni, tsa̱ra̱ a dansa kadyanshi ki. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Aku a soku le a lazai, a tonoi a uyamba u Finisiya n Samariya, n a na̱ki alabari tyoku ɗa Awulawa a wushuki. Nala zuwa ta̱ Atoni a panai kayanyan cika. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","An a rawai a Urishelima, Atoni, n asuki, na̱ nkoshi a ryabusa le. Aku Bulus n Atoni a ɗa a banai kaɓolo n eyi, a tonuko le gba̱ ili iꞌya Kashila̱ ka yankai ama ushani a akere a le. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Shegai Atoni a roku, aza a kaɓon ka Afarishi, a ꞌya̱nga̱i a danai, “U ka̱na̱ ta̱ Awulawa a kiɗa acombi, a toni kpam ili iꞌya Mele ma Musa ma danai.” ");
INSERT INTO kdlNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Aku asuki yi na̱ nkoshi mi a ɓolomgbonoi, tsa̱ra̱ a weɓele kadyanshi ki. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","An a ɓa̱ra̱kpa̱i a kananamgbani ki, aku Bituru ꞌya̱nga̱i kushani u tonuko le, “Aza a va̱, i reve ta̱ Kashila̱ ka ɗanga̱sa mu ta̱ caupa a asuvu a ɗe, u da ara va̱ ɗa Awulawa a ka pana kuɓari ku Kadyanshi ka Shinga, kpam a wushuku. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Kashila̱ uza ɗa u revei atakasuvu a ama gba̱, u wenike tsu ta̱ an u wushai Awulawa a asu u ɗa u na̱ka̱ le Kulu Keri tyoku ɗa u na̱ka̱ tsu. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","U bidya tsu kau‑kau n ele wa, kpaci adama a upityanangu u le u ɗa u wulukpe le. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Adama a nala, niɗa ya ciga i kondo Kashila̱ a asu u utaɗanku Awulawa a na ucanga u ɗa bawu a̱tsu n isheku i tsunu tsa fuɗa tsa canga? ");
INSERT INTO kdlNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Wa yan nala wa! Tsu wushuku ta̱ an adama a ukuna u shinga u Yesu Asheku u ɗa tsu tsa̱ra̱i iwauwi, kpam tyoku ɗa ele dem a tsa̱ra̱i iwauwi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pini nala, ama yi a paɗai bini, a ka pana̱ka Bara̱naba n Bulus tyoku ɗa a ka dansa iryoci n ikunesavu iꞌya Kashila̱ ka yain a asu u Awulawa a akere a le. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","An a kotsoi kadyanshi, aku Yakubu danai, “Atoku a va̱, pana̱ka numu. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simo Bituru tonuko tsu ta̱ tyoku ɗa Kashila̱ ka gita̱i utuwa̱ a asu u Awulawa a roku u gonuko le ama a ne. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nala wa̱ ta̱ dere n kadyanshi ka ntsumate n korongi ili iꞌya Magono ma Zuba ma danai, ");
INSERT INTO kdlNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“ ‘Ma gono ta̱ n lapula n mai kuwa ku Dawuda ka ku wa̱sa̱i. Ko an u wokoi ku wa̱sa̱i, ma lapula ta̱ n mai ka kpam n shamkpa ka. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Nala ma yan, tsa̱ra̱ aza ɗa a buwai vi a kpatala a asu u va̱, gba̱ n Awulawa dem, n aza ɗa n ɗanga̱sai a woko ama a va̱. Mpa, Magono ma Zuba, mpa n danai nala. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","N yan ta̱ kazuwamgbani nala tun caupa.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yakubu lyai kapala n kadyanshi, “Adama a nala, u gan tsu ma̱tsa̱ Awulawa, aza ɗa a ka kpatala̱sa ubana a asu u Kashila̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Shegai tsu koronku le ukanikorongi tsu tonuko le kotsu a lyai ilikulya iꞌya a ɗara̱mkpai kameli wa, kotsu a yain tsishankala wa, n utakuma u inyama i manama ma a piyanlai udyoku wa, ko kpam inyama iꞌya i buwai na̱ mpasa wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kpaci Mele ma Musa ma na mi aꞌa̱ ta̱ ma a uwenishike a agata a Kashila̱ a aza a Yahuda a ilyuci dem n kain ka Ashibi tun a aꞌayin a cau.” ");
INSERT INTO kdlNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Aku asuki na̱ nkoshi n kuwa ku Atoni, kaɓolo n aza a kuwa yi gba̱, a wenei u lobono ta̱ a ɗanga̱sa aza roku a asuvu a le a suku le a Antakiya kaɓolo n Bulus n Bara̱naba. Aku a ɗanga̱sai Yahuza, uza ɗa a ka isa̱ Bara̱saba, n Sila, azapige ɗa a asuvu a Atoni. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","A na̱ka̱ le ukanikorongi u ɗa u danai, “Idyani a asu u atoku a ɗe asuki na̱ nkoshi n kuwa ku Atoni, ubana a asu u Awulawa aza ɗa aꞌa̱ri Atoni, aza ɗa aꞌa̱ri a ilyuci i Antakiya n iyamba i Suriya n Kilikiya. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","“Tsu pana ta̱ alabari a da aza roku a asuvu a tsunu a tuwa̱ ta̱ ara ɗe. Tsu pana ta̱ a ꞌya̱nga̱sa̱ka̱ ɗa̱ atakasuvu n kadyanshi ka le, a damgbara̱sa ɗa̱, ko an u wokoi a̱tsa tsu suku le a yain nala wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","An tsu dansai kadyanshi ki, tsu wenei u lobono ta̱ tsu ɗanga̱sa aza roku a asuvu a tsunu tsu suku le ara ɗe kaɓolo n atoku a tsunu Bara̱naba n Bulus. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ama ɗa a na̱ka̱i uma u le ko a ka kuwa̱ baci adama a kala ka Yesu Kawauwi. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Adama a nala a ɗa dem tsu sukunku ɗa̱ Yahuza n Sila, ara le ɗa ya pana ukuna u ili iꞌya tsa koronku ɗa̱ na vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Kulu Keri ku wenike tsu ta̱ ku da kotsu a zuwuka ɗa̱ ara̱ji wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Shegai kotsu i lyai ili iꞌya a ɗara̱mkpai kameli wa. Kotsu i takuma unyama u ɗa wa̱ri na̱ mpasa wa, ko kpam unyama u manama ma a piyanlai udyoku. Kpam kotsu i yain tsishankala wa. I kirana baci n ili i na yi, ya rongo ta̱ mai. “U yan tsu ben.” ");
INSERT INTO kdlNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Aku a lazai ubana a Antakiya. An a rawai a ɓolomgbonoi Atoni yi a asu u te, a na̱ka̱ le ukanikorongi vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","An ama yi a yain u ɗa ka̱neshi, aku a yain maza̱nga̱ cika a adama a ugbami u atakasuvu u ɗa a doku le. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yahuza n Sila tani an u wokoi ele ntsumate n ɗa, aku a dansai cika n a gbamatangu le atakasuvu a shamgba n ucira. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","An a yain aꞌayin pini kenu, aku Atoni a Antakiya a soku le n katsuma̱ ka eri tsa̱ra̱ a gono a asu u aza ɗa a suku le.  ");
INSERT INTO kdlNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Shegai Sila wenei ulobono ta̱ u shamgba pini n ele. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Bulus n Bara̱naba a wokoi a Antakiya, ele n ama roku ushani a ka wenishike n a dansi kadyanshi ka Asheku. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","An a yain aꞌayin, aku Bulus tonukoi Bara̱naba, “Tuwa̱ tsu bana a ilyuci iꞌya tsu yain kuɓari ku kadyanshi ka Asheku, tsu kondo atoku yi tsa̱ra̱ tsu wene tyoku ɗa aꞌa̱ri.” ");
INSERT INTO kdlNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bara̱naba ciga ta̱ a bidya Yahaya Marku u bana dem n ele. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Shegai Bulus wenei ulobono a bana n eyi wa, kpaci u a̱sa̱ka̱ le ta̱ caupa a ilyuci i Bamafiliya, kpam u ꞌyuwain u lyai kapala n manyan mi kaɓolo n ele. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Aku kananamgbani ka uwai a mere ma le, hal ka zuwai a pecenei. Bara̱naba bidyai Yahaya Marku a uwai a kpatsu ubana a ilyuci i Sayipuru. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Shegai Bulus ɗanga̱sai Sila. Aku atoku yi a yanka le kavasu ka ndishi n shinga, Asheku a kirana n ele, pini nala, a lazai. ");
INSERT INTO kdlNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Bulus kyawunsai uyamba u Suriya n Kilikiya n u gbamatangusi atakasuvu a aza ɗa aꞌa̱ri a aꞌuwa a Atoni yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Bulus banai a Daraba n Lisitira, a asu u ɗa Katoni uza u kala Timoti wa rongo. Mma u ne dem Katoni ka, uza u Yahuda, tata u ne tani uza u Heline† u ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Atoni a ɗa aꞌa̱ri a Lisitira n Ikaniya a ka cikpala ta̱ Timoti cika. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Bulus wa ciga ta̱ Timoti toni le. Adama a nala u zuwai a kiɗa yi kacombi kahu a laza. U yan ta̱ nala adama a aza a Yahuda, kpaci ya dem reve ta̱ tata u ne uza u Heline u ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Tyoku ɗa aꞌa̱ri ukyawunsa a ilyuci ilyuci, a rongoi utonusuko ama ukuna u ɗa asuki na̱ nkoshi a shamkpai a Urishelima, aku a folo le a toni ukuna u nala vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Nala aza a aꞌuwa a Atoni yi a rongoi udoku upityanangu n ucira n kakuma̱ kain dem. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Bulus n atoku a ne a lazai a tonoi a asuvu a uyamba u Firijiya n Galatiya, kpaci Kulu Keri ku ɓishinka le ta̱ uyan kadyanshi ka Asheku a uyamba u Asiya a aꞌayin a nala yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","An a rawai utyoku u uyamba u Misiya, a cigai a bana a Bitiniya, shegai Kulu ku Yesu ku wushunku le wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Aku a walai a uyamba u Misiya ubana a ilyuci i Taruwasa a ikengi i kushiva̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","N kayin, Bulus wenei kuwene. A kuwene ki, u wenei uza u Masidaniya kushani wa folo yi, u danai, “Tuwa̱ a Masidaniya vu ɓa̱nga̱ tsu.” ");
INSERT INTO kdlNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","An u kotsoi uwene kuwene ki, kute‑kute tsu ka̱na̱i ure ubana a Masidaniya, kpaci tsu reve ta̱ Kashila̱ ka ka isa̱ tsu tsu yanka le kuɓari ku Kadyanshi ka Shinga. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Aku tsu uwai kpatsu a Taruwasa, tsu karai ubana a uyamba u mere u mini u Samutarasu. An kain ka wansai, tsu rawai a ilyuci i Niyapali. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Pini nala, tsu wurai ubana a Filibi, ilyuci iꞌya aza a Roma aꞌa̱ri ushani a uyamba u Masidaniya, u ɗa u wa̱ri a kere ka tsugono tsu Roma. Tsu rongoi pini aꞌayin ushani. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Kain ka Ashibi tsu wuta̱i a utsutsu u ilyuci vi ubana a una̱ u aga̱ta̱, asu u ɗa tsu wenei yavu a asu u kavasu u aza a Yahuda wa̱ ta̱ pini. Aku tsu dusuki tsu dansai n aka a ɗa a ɓolomgbonoi ukuna u Asheku. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Uka roku ɗa pini uza u kala Lidiya, kapani ka uwonvo u Kashila̱ wa pana̱ka tsu. Eyi uza u ilyuci i Tayatira u ɗa, kadengi ka aminya a ikebe a mini ma galura a ɗa. Kashila̱ ka kukpa̱i katakasuvu ka ne, hal u wushuki n ili iꞌya Bulus wa tono. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","An a lyuɓugu yi kaɓolo n aza a kuwa a ne, aku u folo tsu, u danai, “An u wokoi i wushuki mpa katoni ka Asheku ka, tuwa̱i i cipa̱ a kuwa ku va̱.” U rongo tsu a ufolo hal u fuɗa tsu aku tsu wushuki. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Kain ka te, an tsa bana a asu u kavasu, tsu gawunsai n kagbashi ka ka̱ri makere, uza u ityoni i cingi i udana ili iꞌya ya gita̱. Azakuwa a ne a ka tsa̱ra̱sa̱ ta̱ ikebe cika n manyan ma udana ili iꞌya ya gita̱ iꞌya makere mi ma yansa. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Aku u rongo tsu utono n u sala̱si, “Ama a na yi agbashi a Kashila̱ a ɗa, Uza u Ucira Gba̱. Tuwa̱ ɗa a tuwa̱i a tonuko ɗa̱ tyoku ɗa ya tsa̱ra̱ iwauwi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nala u rongoi uyan hal aꞌayin ushani, hal asuvu a namgbai Bulus, aku u kpatalai u ɓaranai ityoni i cingi yi, “A asuvu a kala ka Yesu Kawauwi, pecemgbene n eyi.” Kute‑kute i pecemgbenei n eyi. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","An azakuwa a makere yi a wenei ure u utsa̱ra̱sa̱ u ikebe i le u kimba̱ ɗe, aku a ka̱na̱i Bulus n Sila, a rono le ubana a kuden a kapala ka aza a afada. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","An a rawai aku a danai, “Aza a Yahuda a na a ka damgbara̱sa ta̱ ilyuci i tsunu. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ili iꞌya bawu i gain a̱tsu aza a Roma tsu wushi, iꞌya a ka wenishike.” ");
INSERT INTO kdlNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Aku ama a lazai a kyawan le a ka dansa, “Mayun ɗa, nala wa̱ri.” Aza a afada yi a zuwai a monduso le aminya n ucira, a bawan le. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","An a bawan le, aku a uka le a kuwa ku aꞌali, a zuwai uza ɗa wa kirana n kuwa ki u wundi le mai. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","An u panai nala, u uka le a kunu ku asuvu ku kuwa ki, aku u gbagbalai aꞌene a le a kagbukulu. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ubana kayin a mere, Bulus n Sila a ka yan kavasu n ishipa i ucikpala Kashila̱, aza ɗa aꞌa̱ri dem pini a kuwa ku aꞌali ki a ka pana̱ka le. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Kute‑kute iyamba i gba̱ɗa̱i cika, hal kami ka kuwa ku aꞌali ki ka gba̱ɗa̱i. Pini nala, itsutsu yi i giduwa̱i gba̱. Ikani iꞌya a sira̱sai aza ɗa aꞌa̱ri pini a kuwa ku aꞌali ki i sa̱ruwa̱i. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","An uza ɗa wa kirana n kuwa ki u rikpa̱na̱ka̱i alavu, u wenei itsutsu i kuwa yi gba̱ ugiduwi. Wa wundya aza a kuwa ku aꞌali ki a suma ɗe, aku u talai burundu u ne wa ciga u wuna kaci ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Shegai Bulus ɓarana yi, u danai, “Kotsu vu nei kaci ka vunu usa̱n wa, gba̱ tsunu tsa̱ ta̱ pini.” ");
INSERT INTO kdlNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Aku uza ɗa wa wundya kuwa ki u danai a tuko ncikalu. U wuranai u uwai a asuvu u rukpa̱i a kapala ka Bulus n Sila, n u jeki ikyamba adama a uwonvo. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Aku u wutukpa̱ le a kateshe, u danai, “Ndya ma yan tsa̱ra̱ n tsa̱ra̱ iwauwi?” ");
INSERT INTO kdlNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ele tani a danai, “Pityanangu n Yesu Asheku, avu na aza a kuwa a vunu ya tsa̱ra̱ ta̱ iwauwi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Aku a yanka yi kadyanshi ka Asheku n aza a kuwa a ne gba̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","N kayin ka nala ki, u za̱sa̱ le usa̱n u le, aku kute a lyuɓugu yi n aza a kuwa a ne dem. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Aku u uka le a asuvu a kuwa ku ne u tuko le ilikulya. Eyi n aza a kuwa a ne gba̱ a shaɗangi n ipeli adama a ɗa a pityanangi n Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","An kain ka wansai, aku aza a afada yi a suki ada̱ga̱ri a ba a dana a a̱sa̱ka̱ ama a nala yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Aku uza ɗa wa kirana n kuwa ku aꞌali ki u bankai Bulus akani, u danai, “Aza a afada a suku ɗe a a̱sa̱ka̱ ɗa̱, adama a nala, she i wuta̱ i wala alafiya.” ");
INSERT INTO kdlNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Shegai Bulus danai, “A̱tsu aza a Roma a ɗa, kpam a bawan tsu a kapala ka ama bawu afada, a uka tsu a kuwa ku aꞌali. Niɗa a ka yansa a wutukpa̱ tsu usokongi? Wa yan wa! Shegai a tuwa̱ n kaci ka le a wutukpa̱ tsu.” ");
INSERT INTO kdlNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ada̱ga̱ri yi a ba a tonukoi aza a afada kadyanshi ki. Aku uwonvo u ka̱na̱i aza a afada yi, an a panai a da ele aza a Roma a ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","A tuwa̱i a kuwa ku aꞌali ki, a foloi Bulus n Sila a yanka le ahankuri. Aꞌayin a ɗa a wutukpa̱ le, aku a folo le a a̱sa̱ka̱ ilyuci yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","An Bulus n Sila a wuta̱i a kuwa ku aꞌali ki, aku a lazai karara she a kuwa ku Lidiya. An a wenei Atoni, aku a gbamatangusu le atakasuvu cika kahu a a̱sa̱ka̱ a ilyuci yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","An Bulus n Sila a wurai a Amihipali n Apoloni, aku a tuwa̱i a Tasaloniya a asu u ɗa wa̱ri n kagata ka Kashila̱ ka aza a Yahuda. ");
INSERT INTO kdlNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Bulus uwai pini tyoku ɗa u cuwana̱kai, hal Ashibi a tatsu aꞌa̱ri a uyan kadyanshi ka ukuna u Kashila̱ a itagara̱da i Kashila̱, ");
INSERT INTO kdlNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","wa̱ri le ukasana̱sa̱ka n u tonusuko le mayun ɗa Kawauwi ka pana ikyamba kpam u ꞌya̱nga̱ a ukpa̱. U tonuko le, “Yesu ɗa ma̱ri ɗa̱ utonusuko na vi, aya gai Kawauwi ki.” ");
INSERT INTO kdlNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Aku ama roku aza a Yahuda, n aza a Heline aza ɗa a ka gbashika Kashila̱, n aka roku ushani, a wushuki n kadyanshi ka Bulus n Sila, kpam a ɓolomgbonoi n ele. ");
INSERT INTO kdlNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Shegai aza a Yahuda a ka yan malyon cika, aku a banai a kuden a ɓolomgbonoi ama aza a ahali a cingi, a ꞌya̱nga̱sa̱i atakasuvu a ama a ilyuci yi gba̱ le. A sumai ubana a kuwa ku Yason, tsa̱ra̱ a tuko Bulus n Sila a kapala ka kakuma̱ ka ama ki. ");
INSERT INTO kdlNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Shegai an bawu a cina le, aku a ronoi Yason n Atoni a roku ubana a asu u azapige a afada. A ka sala̱sa, “Bulus n Sila alya a ka ꞌya̱nga̱sa̱sa̱ atakasuvu a ama a likimba, alya na dem a rawai ara tsunu. ");
INSERT INTO kdlNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Kpam Yason ɗa cipuka̱ le a kuwa ku ne. Kpam gba̱ le a ka tono mele ma Kaisa wa, n a dansi magono ma roku ma pini a ka isa̱ Yesu.” ");
INSERT INTO kdlNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","An a panai nala, aku aza a ilyuci yi n azapige a afada yi atakasuvu a le a ꞌya̱nga̱i. ");
INSERT INTO kdlNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","A a̱sa̱ka̱ le wa, she na a zuwai Yason n ama yi a tsupai ikebe i uꞌa̱sa̱ka̱, aku a a̱sa̱ka̱ le a lazai. ");
INSERT INTO kdlNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","An kayin ka yain, aku Atoni yi a soku le, a lazai ubana a Biriya. An a rawai ɗe, a uwai a kagata ka Kashila̱ ka aza a Yahuda. ");
INSERT INTO kdlNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Shegai aza a naha a la ta̱ aza a Tasaloniya ahali a shinga, kpaci a wusha ta̱ kadyanshi ki n akere a re. Aꞌa̱ri ukonduso Itagara̱da i Ntsumate kain dem, tsa̱ra̱ a wene ko ili iꞌya Bulus wa tonusuko le vi mayun ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ama ushani a pityanangu ta̱ n Asheku. A asuvu a aza ɗa a wushuki vi, alya aza a Yahuda, kaɓolo n aka a roku ushani aza a Heline aza ɗa aꞌa̱ri n tsupige a ilyuci yi, hal n aꞌali aza a Heline dem. ");
INSERT INTO kdlNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","An aza a Yahuda aza ɗa aꞌa̱ri a Tasaloniya, a panai a da Bulus ɗa pini wa yan kuɓari ku kadyanshi ka Kashila̱ a Biriya, a banai ɗe n a la̱pa̱na̱si kakuma̱ ka ama ki n a ꞌya̱nga̱sa̱si le atakasuvu. ");
INSERT INTO kdlNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Kute‑kute Atoni yi a soki Bulus ubana a kushiva̱, shegai Sila n Timoti a shamgbai ve pini. ");
INSERT INTO kdlNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Aza ɗa a soki Bulus vi, a soku yi ta̱ hal ubana a Atina. An a ka gono, aku Bulus na̱ka̱ le akani a tuwa̱ a tonuko Sila n Timoti a tuwa̱ a cina yi pini gogo. ");
INSERT INTO kdlNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Aꞌayin a ɗa Bulus wa̱ri a uvana Sila n Timoti a Atina, u namgba ta̱ katsuma̱ an u wenei ilyuci yi i shaɗangi n ameli. ");
INSERT INTO kdlNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","U tsu yan ta̱ kadyanshi a kagata ka Kashila̱ n aza a Yahuda n Awulawa aza ɗa a ka tono Kashila̱. Kpam kain dem u tsu yan ta̱ kadyanshi n aza ɗa u tsu cina a kuden. ");
INSERT INTO kdlNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","An Bulus wa̱ri a uyan kuɓari ku Yesu n uꞌya̱nga̱ u ukpa̱ vi, aku ayawunshi a Epikuriya n ayawunshi a Sitokiya a yain kananamgbani n eyi. Aza roku a le a wecikei, “Ndya uza u kacan naha wa tono?” Aza roku a danai, “Yavu uza u uyan kuɓari ku ameli a roku a ɗa, bamu n a tsunu.” ");
INSERT INTO kdlNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Adama a nala, aku a bidya yi a banka yi a asu u Asheshi a ɗa a ka isa̱ Arasa, a danai, “Ko va tonuko tsu ucun u uwenishike u savu u ɗa va yan na vi? ");
INSERT INTO kdlNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kpaci kotsu tsu pana ukuna u na vi wa, kpam tsa ciga ta̱ tsu reve kalen ka ne.” ");
INSERT INTO kdlNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Gba̱ aza a Atina n amoci a ɗa aꞌa̱ri pini na̱ ndishi a la ta̱ uciga a ɓa̱ra̱kpa̱ a upana kadyanshi ka savu kpam a dansa ka kapala n ili gba̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Bulus shamgbai a kapala ka asheshi yi, u danai, “Eɗa̱, aza a Atina, n reve ta̱ eɗa̱ aza a uciga utono adini a ɗa cika. ");
INSERT INTO kdlNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kpaci an ma kyawunsa a ilyuci yi, ma konduso ili iꞌya ya gbashika. N wene ta̱ asuɗara̱kpa u roku n ikorongi a zuba u ne, i danai, ‘Adama a Kashila̱ ka Bawu a Revei.’ Uza ɗa ya gbashika bawu i reve yi vi, aya Kashila̱ kpam aya ma tonuko ɗa̱ ukuna u ne. ");
INSERT INTO kdlNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Kashila̱ ka ka yain likimba n ili iꞌya iꞌa̱ri a asuvu a ne. Aya Magono ma Zuba ma zuba n iyamba, u tsu dusuku a Kuwa ku Kashila̱ ka vuma mai wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Nala dem u tsu ciga vuma u ɓa̱nga̱ yi n ili i kukere i ne wa. U namba ili wa, kpaci aya u na̱ka̱i gba̱ ama uma, n kuvi, n ili iꞌya a ka ciga. ");
INSERT INTO kdlNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Aya kpam u yain gba̱ ama a asu u vuma u te. U ɗanga̱sa̱ka le asu u ɗa a ka dusuku gba̱ a kubain ku likimba. Kpam u foɓusuko le aꞌayin a ɗa gba̱ ama yi a ka rongo. ");
INSERT INTO kdlNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","“Kashila̱ ka yan ta̱ nala tsa̱ra̱ a zami yi, kpaci a papura baci a ka tsa̱ra̱ yi ta̱, ko an u wokoi u yan mɓa̱ri n ele wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Adama a ne a ɗa tsa̱ri n uma, tsa za̱mgba̱na̱sa̱ kpam, adama a ne a ɗa tsu wokoi ili iꞌya tsa̱ri, tyoku ɗa ashipi a ɗe a roku a danai, ‘A̱tsu aza a kagali ka ne a ɗa.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“An u wokoi a̱tsu aza a kagali ka Kashila̱ a ɗa, u gan tsu ra̱tsana̱ka Kashila̱ n ili iꞌya a yain n zinariya ko azurufa ko katali, iꞌya vuma u yain n ugboji u ne wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Caupa Kashila̱ ka̱ri ka foro ama a unyushi u le wa, adama a ukpa̱ɗa̱ u ureve u le. Shegai gogo‑na u tonuko ta̱ ama ko nte wa a kpatala a a̱sa̱ka̱ tsicingi tsu le tsu ugbashika ameli. ");
INSERT INTO kdlNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","“Kpaci u ɗanga̱sa ɗe kain ka wa tuwa̱ u yanka likimba afada a ɗa aꞌa̱ri dere a kukere ku uza ɗa u ɗanga̱sai. Kashila̱ ka a̱sa̱ka̱ tsu ta̱ tsu reve vuma u nala vi a asu u ɗa u ꞌya̱nga̱sa̱ yi a ukpa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","An a panai adama a uꞌya̱nga̱ u ukpa̱, aku aza roku a yanka yi majari, shegai aza roku a danai, “Tsa ciga ta̱ tsu doku tsu pana ukuna u ɗa vu danai nala vi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Pini nala, Bulus a̱sa̱ka̱i asheshi yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Shegai ama roku a asuvu a le a wushuki n kadyanshi ka Bulus a wokoi Atoni. A asuvu a Atoni a savu yi alya Diyonisiyu uza ɗa wa̱ri asuvu a asheshi, n uka u roku uza ɗa a ka isa̱ Damari, kaɓolo n aza roku kpam. ");
INSERT INTO kdlNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Aku Bulus a̱sa̱ka̱i Atina u banai a Korintiya, ");
INSERT INTO kdlNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","nte u cinai uza u Yahuda u roku ɗe uza ɗa a ka isa̱ Akila, uza ɗa a matsai a ilyuci i Pontu. Akila n uka u ne Bilikisu a ɓa̱ra̱kpa̱ n urawa an a wuta̱i a uyamba u Italiya wa. Kpaci an u wokoi Kaladiyu magono u zuwa ta̱ mele u da gba̱ aza a Yahuda a a̱sa̱ka̱ ilyuci i Roma. ");
INSERT INTO kdlNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Bulus rongo ta̱ n ele n u yanyi manyan n ele, kpaci ele aza a tsilaga tsa uyan atani a ɗa tyoku u ne. ");
INSERT INTO kdlNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ashibi dem Bulus wa̱ ta̱ a kagata ka Kashila̱ uyan kadyanshi n aza a Yahuda n aza a Heline. Wa ciga u zuwa le a wushuku n eyi. ");
INSERT INTO kdlNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","An Sila n Timoti a wuta̱i a Masidaniya a tuwa̱i a Korintiya, aku Bulus na̱ka̱i kaci ka ne gba̱ a asu u uyan kuɓari n u tonusuki aza a Yahuda, “Kawauwi ka ya bolo vi, Yesu ɗa.” ");
INSERT INTO kdlNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Shegai an aza a Yahuda a ꞌyuwan yi a taka yi n inyashi, Bulus ka̱pa̱tsa̱i kabuta̱ ka aminya a ne, u danai, “Mpasa n ɗe ma̱ ta̱ a kaci ka ɗe, mpa kabirya mu wa. Ili iꞌya i bidyai n gogo‑na ubana a kapala a asu u Awulawa ɗa ma bana.” ");
INSERT INTO kdlNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pini nala, u ba u dusuki n Titiyu Yusutu Kawulawa uza u ulyaka Kashila̱ kayala, kpam kuwa ku ne ka̱ ta̱ evu n kagata ka Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kirisibu uzapige u kagata ka Kashila̱ n aza a kuwa a ne gba̱ a pityanangu ta̱ n Asheku. Ama ushani a Korintiya dem a pityanangi, aku a lyuɓugu le. ");
INSERT INTO kdlNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Kain ka te n kayin, Asheku a ka yanka Bulus kadyanshi a kuwene u tonuko yi, “Pana uwonvo wa, yan kuɓari! Kotsu vu paɗa bini wa! ");
INSERT INTO kdlNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Kpaci ma̱ ta̱ n avu, kpam ko uza wa ne vu usa̱n wa. Ma̱ ta̱ n ama ushani pini a ilyuci i na yi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Bulus dusuki pini a ilyuci yi hal kayen ka te n uwoto u teli, u rongo le uwenishike kadyanshi ka Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Shegai a aꞌayin a ɗa Galiya wa̱ri gomuna u uyamba u Akataya, aza a Yahuda a ɓolomgbonoi kaci a ꞌya̱nga̱sa̱ka̱i Bulus, a banka yi a kapala ka aza a afada. ");
INSERT INTO kdlNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","A danai, “Vuma na ama ɗa wa ciga a lyaka Kashila̱ kayala a ure u ɗa mele ma ɓishinkai.” ");
INSERT INTO kdlNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Shegai an Bulus wa ciga u gita̱ kadyanshi, aku Galiya kpatalai a asu u aza ɗa a ꞌya̱nga̱sa̱ka̱i Bulus, u danai, “Panai eɗa̱ aza a Yahuda, a da baci nusa ɗa u nusai, ko kpam u yain unyushi u pige u roku, an ma̱ri ma pana̱ka ɗa̱ ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Shegai an u wokoi kananamgbani ki a kaci ka idani, n aꞌala a ɗa n mele ma ɗe koshi, she i yain afada yi n kaci ka ɗe. Mpa ma yan icun i afada a nala yi wa.” ");
INSERT INTO kdlNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Aku u loko le a kunu ku afada ki. ");
INSERT INTO kdlNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Aku kakuma̱ ki ka ka̱na̱i Sasatsani uzapige u kagata ka Kashila̱, a lapa yi a kapala ka kunu ku afada ki. Shegai Galiya kirana n ele wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","An ukuna u nala u wurai, Bulus doku rongoi a Korintiya aꞌayin kenu. Aku u tonukoi Atoni yi u da eyi wa laza. U uwai a kpatsu kaɓolo n Bilikisu n Akila a ka̱na̱i ure ubana a Suriya. Shegai kahu a ꞌya̱nga̱, Bulus kuruwa ta̱ kaci ka ne a Kankiriya, tyoku u agadu a aza a Yahuda, an u wokoi u yain kazuwamgbani n Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","An a rawai a Afisu, (pini a ilyuci yi Bulus a̱sa̱ka̱i Bilikisu n Akila,) aku Bulus uwai a kagata ka Kashila̱ tsa̱ra̱ u dansa n aza a Yahuda. ");
INSERT INTO kdlNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Aku a folo yi u doku u rongo n ele, eyi tani u wushuku wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Shegai an wa a̱sa̱ka̱ le, u danai, “Kashila̱ ka wushuku baci, ma gono ta̱ a asu u ɗe.” ");
INSERT INTO kdlNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","An Bulus a̱sa̱ka̱i Afisu u uwai kpatsu ubana a Kasariya, aku u wurai ubana a Urishelima. U ba u dana̱sai Atoni, pini nala, u lazai ubana a Antakiya. ");
INSERT INTO kdlNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","An u ɓa̱ra̱kpa̱i pini kenu, aku u ꞌya̱nga̱i u kyawunsai uyamba u Galatiya n uyamba u Firijiya. U tonoi a ilyuci ilyuci n u gbamatangusi Atoni atakasuvu, tsa̱ra̱ a gbonguro a ure u Asheku. ");
INSERT INTO kdlNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Aꞌa̱ri pini, aku uza u Yahuda u roku uza u kala Apolo tuwa̱i a Afisu. Kpam uza u ilyuci i Alizandariya u ɗa, karevi ka kadyanshi. U reve ta̱ tagara̱da u Kashila̱ cika. ");
INSERT INTO kdlNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","A wenishike yi ta̱ a asuvu a Ure u Asheku. U bidya ta̱ kadyanshi ka Kashila̱ ki mayun mayun n ucira, kpam wa wenishike ukuna u Yesu u maci vi. Shegai ukuna u ulyuɓugu u Yahaya u ɗa u revei koshi. ");
INSERT INTO kdlNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Aku u ka̱na̱i kuɓari a kagata ka Kashila̱ n ucira u ne gba̱. An Bilikisu n Akila a panai kadyanshi ka ne, a rono yi a banka yi a kuwa, a doku a tonusuko yi ukuna u Kashila̱ cika. ");
INSERT INTO kdlNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","An Apolo wa ciga u pasamgbana ubana a uyamba u Akataya, Atoni a ɓa̱nga̱ yi a koronki Atoni a ɗa aꞌa̱ri a Akataya vi ukanikorongi tsa̱ra̱ a wushi yi n akere a re. An u rawai tani ɗe, u woko ta̱ kaɓa̱ngi ka aza ɗa a pityanangi a asu u ukuna u shinga u Kashila̱, ");
INSERT INTO kdlNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","kpaci u varangu ta̱ aza a Yahuda cika a kapala ka ama, u kasana̱sa̱ka le tagara̱da u Kashila̱ an Yesu Kawauwi ka. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Aꞌayin a ɗa Apolo wa̱ri a Korintiya, Bulus walai pini a uyamba vi hal ubana a Afisu, a asu u ɗa u cinai Atoni a roku. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","U wece le, “I wusha Kulu Keri aꞌayin a ɗa i wushuki vi?” A danai, “Tsu reve gba̱m ili i roku Kulu Keri wa.” ");
INSERT INTO kdlNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","U wece le, “Ucun u ulyuɓugu u eni u ɗa a luɓugu ɗa̱?” A wushunku yi, “Ucun u ulyuɓugu u Yahaya u ɗa.” ");
INSERT INTO kdlNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Bulus danai, “Ulyuɓugu u Yahaya u ukpatala u ɗa. Yahaya tonusuko ta̱ dem ama a pityanangu n uza ɗa wa tuwa̱ a kucina̱ ku ne; wata, Yesu.” ");
INSERT INTO kdlNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","An a panai nala, aku a lyuɓugu le a asuvu a kala ka Yesu Asheku. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","An Bulus taɗanku le akere, aku Kulu Keri ku cipa̱ le. Pini nala, a gita̱i kadyanshi n aletsu a roku n a yanyi kadyanshi ka ukuna u Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Gba̱ gba̱ evu n ama kupa n ama a re a ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Bulus uwai a kagata ka Kashila̱ n u yanyi kuɓari bawu uwonvo hal uwoto u tatsu, n u yanyi kadyanshi n ele n u tonusuko le ukuna u tsugono tsu Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Shegai aza roku a asuvu a le a gbamai atakasuvu a le. A ꞌyuwain uwushuku, hal a yankai aza ɗa a wushuki vi kadyanshi ka gbani adama a Ure u Asheku vi a kapala ka ama. Aku Bulus a̱sa̱ka̱i kagata ka Kashila̱ ki, u bidyai Atoni yi, n u wenishiki le kain dem a asu u uwenishike u Tiraniyu. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Nala a rongoi uyansa hal ayen a re, hal gba̱ aza a Yahuda n aza a Heline a ɗa aꞌa̱ri na̱ ndishi a Asiya a panai kadyanshi ka Asheku. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Kashila̱ ka na̱ka̱ ta̱ Bulus ucira u ɗa wa yansa ikunesavu iꞌya bawu kotsu ama a taɓai uwene. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Hal gba̱m a bidya baci mayani ma ne ko aminya a manyan a ne a ɗa wa ukusa a bankai aza a mɓa̱la̱, a tsu ta̱na̱ ta̱. Nala dem ityoni i cingi i tsu pecemgbene ta̱ n ama. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Aza a Yahuda a roku aza ɗa aꞌa̱ri ukyawunsa ilyuci ilyuci n a wutukpusi ityoni i cingi. A ma̱tsa̱i tsa̱ra̱ a yain manyan nala n kala ka Yesu Asheku. N a dansi, “N ɓarana ɗa̱ ta̱ n kala ka Yesu ka Bulus wa yansa̱ka kuɓari ku ne ki, i wuta̱.” ");
INSERT INTO kdlNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Mmuku n Siva kaɗara̱kpi ka pige† ka aza a Yahuda, n ɗa dem pini n shindere aꞌali a asuvu a aza ɗa a ka yansa nala vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Kain ka te, an a kondoi a yain nala a asu u uza u ityoni i cingi u roku, aku ityoni i cingi i wushunku le, “Mpa gai n reve ta̱ Yesu! N reve ta̱ kpam Bulus. Shegai eɗa̱ tani an yayi?” ");
INSERT INTO kdlNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Aku uza u ityoni i cingi vi u imkpai u gita̱ le malapa hal u lyai ucira u le gba̱. Aku a wuta̱i a kuwa ki n ilyaɗi ya dem kataɓa ikyamba i le kpam n aꞌutsu. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","An aza ɗa aꞌa̱ri ndishi a Afisu, aza a Yahuda n aza a Heline a panai ili iꞌya i gita̱i, aku a panai uwonvo cika, a na̱ka̱i kpam kala ka Asheku tsupige. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ama ɗa kpam a wushuki vi a wuta̱i a kapala ka ama a ka dansa tsicingi tsu le. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ama ushani aza a uyan ada̱bu a ɓolomgbonusoi itagara̱da i le a asu u te a runukpai iꞌya a kapala ka ama. An a kecei ikebe i itagara̱da yi, i rawa ta̱ ikebe iꞌya vuma wa liva̱ manyan ma aꞌayin azu amangarenkupa (50,000.) ");
INSERT INTO kdlNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Nala kadyanshi ka Asheku ka rongoi utambura kpam ka yain ucira cika. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","An ukuna u nala u gita̱i, Bulus bidigai kaci ka ne u da u kyawunsa baci uyamba u Masidaniya n u Akataya, aku u bana a Urishelima. U danai kpam, “N bana baci ɗe, u ka̱na̱ mu ta̱ n bana a ilyuci i Roma. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Aku u suki aɓa̱ngi a ne a re, Timoti n Erasutu ubana a Masidaniya, eyi kpam u shamgbai ve pini a uyamba u Asiya vi kenu. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Aꞌayin a nala yi a ɗa a ꞌya̱nga̱sa̱i atakasuvu a ama cika a adama a Ure u Asheku. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Uꞌya̱nga̱sa̱ u atakasuvu a nala vi u gita̱ ta̱ n karumi ka roku uza u kala Dimitiriyu, uza ɗa wa yansa manyan n azurufa n u rumi agata a Aritima† kameli ka ka̱ri uka. Eyi n atoku a manyan a ne a tsu tsa̱ra̱ ta̱ ikebe cika adama a manyan ma nala mi. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Aku u ɓolomgbonoi gba̱ atoku a manyan a ne n aza ɗa a ka yan manyan ma ma rotsoi icun i manyan ma nala mi, u danai, “Eɗa̱ ama a va̱, i reve ta̱ n manyan ma na ma tsa tsa̱ra̱sa̱ ikebe. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","I wene ta̱ kpam i pana ta̱ tyoku ɗa Bulus nala vi wa la̱pa̱na̱sa̱ ama. Nala wa̱ri a uyan pini na a Afisu n a asu u aza a Asiya ushani. U danai ameli a ɗa ama a yain n akere, ashila̱ a ɗa wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ukuna u cingi wa gita̱ ta̱, a ka nangasa ta̱ manyan ma tsunu. Bamu gba̱m n nala, hal gba̱m a ka gonuko ta̱ Aritima kameli ili i gbani, kpam a pece yi n tsupige tsu ne. Eyi uza ɗa gba̱ uyamba u Asiya hal gba̱m n likimba gba̱ a ka gbashika.” ");
INSERT INTO kdlNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","An a panai nala, aku a yain upan cika, a ꞌya̱nga̱sa̱i ala̱ga̱tsu a le, a danai, “Tsupige she Aritima u aza a Afisu.” ");
INSERT INTO kdlNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Aku ama yi a dambulai, a sumai ubana a kakura̱ a asu u ɗa ama yi a ɓolomgbonoi, aꞌa̱ri urono Gayu n Aristaraku. Ama a na yi atoku a nwalu a Bulus a ɗa aza a Masidaniya. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Bulus ciga ta̱ u uwa pini a asuvu a ama yi, shegai Atoni a ɓishinka yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Azapige a roku aza a uyamba u Asiya aje a ne a sukunku yi akani a folo yi kotsu u kawan u bana a asu u ama a nala yi wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ama ɗa aꞌa̱ri pini vi atakasuvu a le gba̱ a shaɗangu ɗe n kadambula, kpaci a reve gba̱m ili iꞌya a ɓolomgbonoi uyan wa. Aza roku a ꞌya̱nga̱sa̱i ala̱ga̱tsu a ka dansa ili i roku, aza roku kpam a ka dansa ili i roku kau. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Aza a Yahuda a tutsuki vuma roku uza u kala Alizanda a kapala, a ka ciga yi u kasana̱sa ukuna vi. Pini nala, u ꞌya̱nga̱sa̱i akere a zuba u danai a paɗa, tsa̱ra̱ u sira̱ka ama a ne kaɓetsu. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Shegai an a revei eyi uza u Yahuda u ɗa, aku a ꞌya̱nga̱sa̱i ala̱ga̱tsu a danai, “Tsupige she Aritima kameli.” Aꞌa̱ri uyansa nala hal ulapa u uwule u re. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","An nala u wurai, aku kakorongi ka ilyuci ka zuwai ama yi a paɗai, u danai, “Eɗa̱ ama a Afisu, ama a likimba gba̱ a reve ta̱ an ilyuci i Afisu iꞌya ya kirana n Aritima kameli. Kpam ya dem reve ta̱ an kameli ka pige ka nala ki, ka rukpa̱i a zuba derere a ilyuci i tsunu. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","An u wokoi ili i na yi a ka nana iꞌya wa, u gan ta̱ i paɗa bini, kotsu i bidya ukuna vi n udagu wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","I tukoi ama a na pini na, a yan uboki a kagata ka kameli ki wa, a wisha tani kameli ki wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Shegai Dimitiriyu n atoku a manyan a ne aꞌa̱ baci n ukuna u roku a kaci ka uza roku, kunu ku afada ka̱ ta̱ ukukpi. Aza a afada a ɗa kpam pini, she i banka le ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Shegai iꞌa̱ baci n ukuna u roku kau u ɗa ya ciga i reve, she a dansa u ɗa na a asu u asheshi. ");
INSERT INTO kdlNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Mayun tani wa suɗugba tsu ta̱ a kukere ku azapige a Roma, an tsu wushuki n ukuna u uꞌya̱nga̱sa̱ u atakasuvu u ara u na vi, an u wokoi tsa fuɗa tsa na̱ka̱ kalen ka ili iꞌya i gita̱i na vi wa.” ");
INSERT INTO kdlNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","An u danai nala, aku u wacinsai ama yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","An uꞌya̱nga̱sa̱ u atakasuvu vi u kotsoi, aku Bulus isa̱i Atoni u gbamatangu le atakasuvu. Pini nala, u tonuko le, “U yan tsu ben.” Aku u lazai ubana a uyamba Masidaniya. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","An u kyawunsai aɓon a nala yi gba̱, n u gbamatangusu le atakasuvu cika, aku u lazai she a Heline. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","U dusuki pini hal uwoto u tatsu. Afoɓi a ɗa wa̱ri a uwa a kpatsu ubana a uyamba u Suriya, aku u revei aza a Yahuda a yanka yi ta̱ afoɓi a cingi. Adama a nala a ɗa u bidigai kaci ka ne wa gono a ure u Masidaniya. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ama a na ɗa a soku yi: Supata maku ma Puruhu uza u Biriya, kaɓolo n Aristaraku n Sakunda aza a Tasaloniya, kaɓolo n Gayu uza u Daraba, n Timoti, hal dem n Tikiku n Tarafima aza a Asiya. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ama a na yi a lyai kapala na̱ nwalu a ba a vana tsu a Taruwasa. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","A̱tsu tani an Abiki a Ilikulya iꞌya i Nambai Yisti a wurai, tsu uwai a kpatsu a Filibi. Tsu yan ta̱ nwalu ma aꞌayin a tawun, aku tsu rawai a Taruwasa tsu cina le pini ɗe. Nte tsu rongoi pini hal aꞌayin a shindere. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Kain ka Aladi, tsu ɓolomgbonoi tsa̱ra̱ tsu lyai ilikulya. Bulus dansai kadyanshi n ama yi hal kayin ka pige, kpaci wa laza ta̱ kain ka wansa baci. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","A kunukuzuba ka tsa̱ri vi a sapusa ta̱ pini ncikalu ushani. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Kalobo ka roku uza u kala Yutiku u dusuki a zuba u ilinuku i kunukuzuba ku ukumba u tatsu. Aku wa gbaɗiga aꞌayin a ɗa Bulus wa̱ri uyan kuɓari ku ugaɗi, hal alavu a bidya yi gbende-gbende. Aku u fa̱ta̱na̱i u rukpa̱i a kunukuzuba utuwa̱ a iyamba. An a canga yi, a cinai u kuwa̱ ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pini nala, Bulus cipa̱i a iyamba u woɓo yi, u danai, “Kotsu i dambula wa, wa̱ ta̱ n uma.” ");
INSERT INTO kdlNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","An Bulus gonoi a kunukuzuba, aku tsu lyai ilikulya kaɓolo. U lyai kapala n kadyanshi ki hal usana, aku u lazai. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Pini nala, a lazai n kalobo ki a kuwa n uma, aku a yain maza̱nga̱ cika. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Bulus bidiga ta̱ kaci ka ne u wala a aꞌene ubana a Asusu. A̱tsu kpam tsu uwai a kpatsu, tsa̱ra̱ tsu ba tsu gawunsa ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","An tsu gawunsai a Asusu, aku u uwai a kpatsu ki tsu lazai ubana a Mitilini. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","An kain ka wansai, aku tsu lyai kapala na̱ nwalu tsu rawai evu n a asu u ɗa a ka isa̱ Kiyo. An kain ka wansai kpam tsu rawai a uyamba u mere ma mini u ɗa a ka isa̱ Samasu. An kain ka doku ka wansai, aku tsu rawai a Milita. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Kpaci Bulus bidiga ta̱ kaci ka ne u da wa shamgba a Afisu wa, adama a ɗa wa ɓa̱ra̱kpa̱ a Asiya. Kpaci wa yan ta̱ maloko u rawa a Urishelima kahu kain ka Abiki a Kain ka Amangarenkupa.† ");
INSERT INTO kdlNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Shegai an tsu rawai a uyamba u Milita, ɗa Bulus sukunki nkoshi n kuwa ku Atoni a ɗa aꞌa̱ri a Afisu a tuwa̱ a cina yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","An a rawai, aku u danai, “Eɗa̱ i reve ta̱ gba̱ ili iꞌya n yain aꞌayin a ɗa n gita̱i utuwa̱ a Asiya. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","N yan ta̱ manyan ma Asheku bawu ara̱ɗi, kpam n meshi. N kawunki kpam n ukonduso u cingi u ɗa aza a Yahuda a tukuso mu. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","N kpa̱ɗa̱ ɗa̱ utonuko ukuna u mayun wa, na̱ n yansa̱ka ɗa̱ kuɓari a asu u ama n aꞌuwa a ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Kuɓari ku va̱ ku te ka ubana a asu u aza a Yahuda n Awulawa. N tonuko le a reve kalen ka ukpatala a gono a asu u Kashila̱ a a̱sa̱ka̱ tsicingi tsu le kpam a pityanangu n Yesu Asheku. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Gogo‑na Kulu Keri ka na ka zuwa mu ubana a Urishelima, kpam n reve ili iꞌya ya gita̱ na̱ mpa ɗe wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ko an u wokoi Kulu Keri ka tonusuko mu ta̱ a ilyuci iꞌya dem n banai, ka danai a ka gida̱ku mu ta̱ a kuwa ku aꞌali kpam n pana ikyamba. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Shegai mpa n gonuko uma u va̱ ili i roku wa, ma fuɗa baci ma kotso manyan ma Yesu Asheku u na̱ka̱ mu; wata, n dansa Kadyanshi ka Shinga ka ukuna u shinga u Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Gogo‑na n reve ta̱ aza ɗa n kyawunsai na̱ yansa̱ka le kuɓari ku tsugono tsu Kashila̱ a ka doku a ka wene mu wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Adama a nala a ɗa ma tonuko ɗa̱ ara, uza ɗa baci dem u tuwa̱ u puwa̱in a asuvu a ɗe a ka wece mu mpasa n ne wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","N tonuko ɗa̱ ta̱ mai ili iꞌya Kashila̱ ka ciga ɗa̱ i reve. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","I kirana n uma u ɗe n ushiga u ɗa Kulu Keri ku zuwa ɗa̱ i guɓi. Kpam i lyai kapala n ulina̱ka Atoni a ɗa Kashila̱ ka tsila̱kai kaci ka ne na̱ mpasa n Maku ma ne. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","N reve ta̱ n laza baci, awenishiki a ka tuwa̱ ta̱, aza ɗa bawu a ka wenishike ukuna u mayun. A ka yan ta̱ yavu nleweni, tsa̱ra̱ a wacinsa ncon n Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Hal gba̱m aza roku a asuvu a ɗe a ka yan ta̱ kadyanshi ka kaɓan tsa̱ra̱ a roni Atoni ubana ara le. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Adama a nala, she i rongo ufoɓusi, i ciɓa ayen a tatsu a ɗa pa vi kaara n kayin ma̱ri n a̱ɗa̱, n a̱sa̱ka̱ ɗa̱ uɓara wa. Hal gba̱m n sa̱i n meshi adama a ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Gogo‑na n na̱ka̱ngu ɗa̱ ta̱ a kukere ku Kashila̱. A̱sa̱ka̱ kadyanshi ka ukuna u shinga ka ne ka kirana n a̱ɗa̱. Ciɓai n kadyanshi ka pige ka shinga ka nala ki. Kadyanshi ka nala ki ka ka ɓa̱nga̱ ɗa̱ ka na̱ka̱ ɗa̱ ili iꞌya Kashila̱ ka ciga ka na̱ka̱ ama a ne agadu. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","“N yan malyon ma ikebe ko aminya a uza roku wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","I reve ta̱ n yan ta̱ manyan n akere a va̱, tsa̱ra̱ n tsupuka kaci ka va̱ ili iꞌya ma ciga, n aza ɗa aꞌa̱ri kaɓolo na̱ mpa. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Kain dem n woko ta̱ iryoci ara ɗe tyoku ɗa ya yan manyan cika, tsa̱ra̱ i ɓa̱nga̱ aza a unambi. Ciɓai n kadyanshi ka Yesu Asheku ka u danai, ‘U la ta̱ una̱ u shinga vu na̱ka̱ n u ɗa va wusha.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","An Bulus kotsoi kadyanshi, aku u kuɗa̱ngi kaɓolo n ele a yain kavasu. ");
INSERT INTO kdlNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","38","Aku a woɓo yi gba̱ le n unamgbukatsuma̱ a ka̱na̱i kushen cika, kpaci u dana ta̱ a ka doku a ka wene yi wa. Pini nala, a soku yi gba̱ le hal u uwai a kpatsu. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","An tsu pecemgbenei n ele, aku tsu uwai a kpatsu ubana a uyamba u mere ma mini u Kosso. An kain ka wansai, aku tsu banai a Rodusu, pini nala, she a Patara. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","An tsu cinai kpatsu ku ka bana a Finisiya, aku tsu uwai tsu lazai. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","An tsu gita̱i uwene uyamba u mere ma mini u Sayipuru, aku tsu a̱sa̱ka̱i iꞌya a ugula̱ u tsunu, tsu lyai kapala na̱ nwalu ubana a Suriya. Tsu cipa̱i a Taya kpaci nte kpatsu ki ka cipuka̱ pini ucanga. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Tsu cina ta̱ pini Atoni, aku tsu dusuki pini n ele hal aꞌayin a shindere. Kulu Keri ku tonuko le a tonuko Bulus kotsu u bana a Urishelima wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Shegai an aꞌayin a uꞌya̱nga̱ a tsunu a yain, aku tsu lyai kapala na̱ nwalu n tsunu. Atoni yi a soku tsu ta̱ hal gba̱m n aka a le na̱ mmuku n le gba̱ ubana a uroto u ilyuci vi. An tsu rawai a ikengi i aga̱ta̱, aku tsu kuɗa̱ngi tsu yain kavasu. Tsu ꞌya̱nga̱i tsu lyai kapala na̱ nwalu n tsunu. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","An tsu pecenei, aku tsu uwai a kpatsu, ele kpam a lazai ugono a kuwa. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","An tsu a̱sa̱ka̱i Taya, tsu lyai kapala na̱ nwalu she a Talamaya. Nte tsu damamgbana̱sai pini n atoku kpam tsu shamgbai pini n ele kain ka te. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","An kain ka wansai, aku tsu banai a Kasariya, tsu cipa̱i a kuwa ku Filibu uza u uyan kuɓari ku kadyanshi ka Kashila̱, uza u te a asuvu a ama a shindere a ɗa a ɗanga̱sai a pecike ama ilikulya. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Wa̱ ta̱ na̱ mmuku nkere n nishi n ɗa bawu kotsu n yain iyolo, alya aza a udansa kadyanshi ka Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","An tsu yain aꞌayin pini a asu vi, aku uza u udansa akani a Kashila̱ u roku uza u kala Agaba, u wuta̱i a Yahuda u tuwa̱i. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","U bidyai kagbawatsu ka cuku ka Bulus, u sirai akere a ne n aꞌene a ne n ka, u danai, “Ili iꞌya Kulu Keri ku danai iꞌya na, ‘Naha ɗa aza a Yahuda a Urishelima a ka sira uza u kagbawatsu ka na vi, kpam a neke yi a akere a Awulawa.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","An tsu panai nala, a̱tsu n aza ɗa aꞌa̱ri pini tsu foloi Bulus kotsu u bana a Urishelima wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Aku u wushuki, “Ndya i zuwai iꞌa̱ri a kushen ya zuwa mu unamgbukatsuma̱? Ufoɓusi u ɗa ma̱ri a sira mu hal gba̱m a wuna mu a Urishelima adama a kala ka Yesu Asheku.” ");
INSERT INTO kdlNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","An tsu dansai n eyi bawu tsu fuɗa yi, aku tsu paɗai bini, tsu danai, “A̱sa̱ka̱ Magono ma Zuba ma yain iꞌya i gan yi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","An nala u wurai, aku tsu foɓusoi tsu banai a Urishelima. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Atoni a roku aza ɗa a wuta̱i a Kasariya dem a soku tsu, a banka tsu a kuwa ku Nnasan uza ɗa tsa cipa̱ ara ne. Eyi vuma u Sayipuru u ɗa, uza u te a asuvu a Atoni a kagita̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","An tsu rawai a Urishelima, atoku a ryabusa tsu n ipeli cika. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","An kain ka wansai, aku Bulus n a̱tsu dem tsu banai ara Yakubu, kpam gba̱ nkoshi n kuwa ku Atoni n ɗa pini. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","An Bulus damamgbanai n ele, aku u tonusuko le ili iꞌya Kashila̱ ka yankai Awulawa a akere a ne. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","An a panai nala, aku a cikpalai Kashila̱, a tonukoi Bulus, “Utoku u tsunu, wene na tyoku ɗa ama azu ushani a aza a Yahuda a pityanangi. Gba̱ le gogo‑na aꞌa̱ ta̱ n maluwa ma a ka tono Mele ma Musa. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Shegai a tonuko ta̱ Atoni a savu yi alabari a vunu a da va wenishike ta̱ aza a Yahuda a ɗa aꞌa̱ri a asuvu a Awulawa vu da a varangu Mele ma Musa. Wata, kotsu a kiɗa mmuku n le acombi wa, ko kpam a toni agadu a tsunu wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","“Gogo‑na niɗa tsa yan? Kpaci u ka̱na̱ ta̱ a reve n utuwa̱ u vunu. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Adama a nala, she vu yain ili iꞌya tsa tonuko vu. Tsa̱ ta̱ n ama a nishi pini na aza ɗa a yain kazuwamgbani. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Bidya ama a nala yi i ba i wulukpe kaci ka ɗe kaɓolo, kpam vu tsupa ikebe i uwulukpe yi tsa̱ra̱ a kuruwa le. Nala wa zuwa ta̱ a reve an gba̱ ili iꞌya a tonuko le a kaci ka vunu ki kaɓan ka, kpam avu n kaci ka vunu va kirana ta̱ n Mele mi. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Shegai ukuna u Awulawa a ɗa a wushuki, tsu koronku le ta̱ ukanikorongi tsu da: kotsu a takuma ili iꞌya a ɗara̱mkpai kameli wa, kotsu a takuma unyama u ɗa wa̱ri na̱ mpasa wa, a takuma unyama u manama ma a piyanlai udyoku wa, kpam kotsu a yain tsishankala wa.” ");
INSERT INTO kdlNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","An kain ka wansai, Bulus bidyai ama yi a banai a wulukpei kaci ka le, aku a uwai a Kuwa ku Kashila̱. Pini nala, u tonukoi ama aꞌayin a ɗa uwulukpe vi wa shaɗangu, n kain ka a ka yanka ya dem uɗara̱kpa. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","An aꞌayin a shindere yi a yain evu n ushaɗangu, aku aza a Yahuda a roku aza a uyamba u Asiya a wenei Bulus a asuvu a Kuwa ku Kashila̱. Aku a ꞌya̱nga̱sa̱i atakasuvu a ama a ka̱na̱ yi, ");
INSERT INTO kdlNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","n a sala̱si n a dansi, “Atoku a tsunu aza a Isaraꞌila, ɓa̱nga̱ tsu! Vuma ɗa wa kyawunsa ko nte wa n u wishisi ama a tsunu, n Mele ma tsunu, kpam n Kuwa ku Kashila̱ ku tsunu ki aya gai na vi. Hal gba̱m u tukoi aza a Heline† a roku a asuvu a Kuwa ku Kashila̱ ki a nangasai Asu u Uwulukpi u na vi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ele n a dani ko u uwa pini n Tarafima Kawulawa ka Afisu asuvu a Kuwa ku Kashila̱ ki. Ili iꞌya i zuwai a danai nala, kpaci aꞌa̱ri a wene le ta̱ kaɓolo a asuvu a ilyuci. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Aku gba̱ ilyuci yi a dambulai cika, a wuranai n ilyaɗi a ka̱na̱i Bulus. A rono yi ubana a ulanga u Kuwa ku Kashila̱ ki. Kute‑kute a gida̱kusi itsutsu yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Pini nala, a ka̱na̱ yi malapa a ka ciga a wuna, aku alabari a rawai ara uzapige u kuvon u aza a Roma, a da gba̱ ilyuci i Urishelima iꞌya pini a ka ꞌya̱nga̱sa̱sa̱ atakasuvu a ama. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Kute‑kute u bidyai atigi a roku kaɓolo n asoje a banai ɗe a asu u le. An ama yi a wenei uzapige vi utuwa̱ n asoje, aku a a̱sa̱ka̱ yi malapa. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Uzapige vi u zuwai a ka̱na̱i Bulus, kpam u zuwai a sira yi n ikani i re. Aku u wecei ama yi ko ya Bulus vi n ili iꞌya kpam u yain. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Aku aza roku pini a asuvu a kakuma̱ ki a salai a danai ili i roku, aza roku kpam a danai ili i roku kau. Adama a kacan ka ama ki, hal gba̱m uzapige vi u fuɗa u reve ili iꞌya i gita̱i wa. U zuwai a lazai n Bulus ubana a kuwa ku asoje. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","An a rawai a asu u adeshikpetsu a uꞌuwa a kuwa ki, she na asoje yi a ra̱ɗa̱gba̱ yi a zuba adama a uꞌya̱nga̱sa̱ u atakasuvu u ama yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Kakuma̱ ka ama ka ka tono le vi aꞌa̱ri isali n a dansi, “Wuna ni.” ");
INSERT INTO kdlNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","An a yain evu n uꞌuwa a kuwa ku asoje ki, aku Bulus wecei uzapige vi, “Ko va wushuku n yain kadyanshi n avu?” Aku uzapige vi u wece yi, “Dana vu reve ta̱ Tsiheline? ");
INSERT INTO kdlNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ma wundya aɗa vuma u Masar u ɗa ayen a ɗa a wurai u ꞌya̱nga̱sa̱i atakasuvu a ama, hal gba̱m u tonoi n ama azu a nishi (4,000) a aza a maga̱la̱ka̱ a mete mi?” ");
INSERT INTO kdlNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Bulus wushunku yi, “Mpa uza u Yahuda u ɗa, u ilyuci i Tarsu a uyamba u Kilikiya. Mpa uza u ilyuci iꞌya iꞌa̱ri n tsupige tsu nala tsi ɗa. Ma folo vu vu a̱sa̱ka̱ mu n yain kadyanshi n ama a na yi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Aku u a̱sa̱ka̱ yi u yain kadyanshi, u shamgbai a zuba u adeshikpetsu a uꞌuwa a kuwa ki, u ꞌya̱nga̱sa̱ka̱i ama yi kukere a paɗa. An a paɗai bini, aku u yanka le kadyanshi n Tsiꞌarama. ");
INSERT INTO kdlNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Bulus yain kadyanshi, u danai, “Atoku a va̱ n isheku i va̱, panai mai n tonuko ɗa̱ ili iꞌya i gita̱i, tsa̱ra̱ n wenike an bawu ma̱ri n unyushi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","An wa dansa n ele n kaletsu ka le, aku kakuma̱ ka ama ka lapulai ka paɗai bini. ");
INSERT INTO kdlNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Aku u danai, “Mpa uza u Yahuda u ɗa, a matsa mu ta̱ a Tarsu, a uyamba u Kilikiya, shegai nte n gbonguroi pini na. N yan ta̱ ka̱neshi a kukere ku Gamaliya uza ɗa u wenishike mu gba̱ mele ma isheku i tsunu. Ma̱ ta̱ n uciga u ugbashika Kashila̱, tyoku ɗa gba̱ ɗe iꞌa̱ri uyan ara. ");
INSERT INTO kdlNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","N foro ta̱ ama ɗa a ka tono Ure u Asheku, hal gba̱m n wunai aza roku. N sira̱sai aka n aꞌali n gbagirya le a asuvu a kuwa ku aꞌali. ");
INSERT INTO kdlNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Magono ma Aɗara̱kpi n azapige a Asheshi a Pige a ka dana ta̱ mayun ɗa. A na̱ka̱ mu ta̱ ukanikorongi ubana a asu u atoku a tsunu aza a Yahuda a ɗa aꞌa̱ri a Damasuka. Ukanikorongi vi u wushunku mu ta̱ n tuko Atoni a ɗa aꞌa̱ri ɗe utuwa̱ a Urishelima usiri n ikani tsa̱ra̱ a yan le mavura. ");
INSERT INTO kdlNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Kain ka te, evu n ubana kaara a kaci, cina n yan ɗe evu n urawa a Damasuka, aku katyashi ka wuta̱i a zuba ka wakana mu ukyawan. ");
INSERT INTO kdlNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Aku n rukpa̱i a iyamba, n panai kala̱ga̱tsu ka wece mu, ‘Shawulu, Shawulu, ndya i zuwai va yan mu mavura?’ ");
INSERT INTO kdlNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Aku n wushuki, ‘Asheku, aɗa yai?’ “U wushuki, ‘Mpa Yesu uza u Nazara uza ɗa va yan mavura.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Aza ɗa tsa̱ri kaɓolo a wene ta̱ katyashi ki, shegai a reve ili iꞌya kala̱ga̱tsu ki ka tono wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Aku n wece yi, ‘Asheku, ndya va ciga n yain?’ “U wushunku mu, ‘ꞌYa̱nga̱ vu uwa a Damasuka. Vu rawa baci ɗe a ka tonuko vu ta̱ ili iꞌya va yan.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Katyashi ki ka zuwa mu ta̱ n rumba̱na̱i, aza ɗa tsa̱ri kaɓolo ki alya a rono mu ubana a Damasuka. ");
INSERT INTO kdlNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Aku vuma roku uza u kala Ananiya tuwa̱i ara va̱. Eyi uza ɗa wa gbashika Kashila̱ tyoku ɗa Mele ma tsunu ma danai ɗa, uza ɗa gba̱ aza a Yahuda a ɗa aꞌa̱ri a Damasuka a ka cikpala̱sa. ");
INSERT INTO kdlNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","U tuwa̱i ara va̱, u shamgbai evu na̱ mpa, u danai, ‘Utoku u va̱ Shawulu, wene asu.’ Pini a asu u nala vi ɗa n wene yi! ");
INSERT INTO kdlNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“U tonuko mu, ‘Kashila̱ ka isheku i tsunu ka ɗanga̱sa vu ta̱ vu reve ili iꞌya wa ciga. Kpam vu wene Uza u Uwulukpi u nala vi, vu pana kpam kadyanshi ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Aɗa va bidya kadyanshi ka ne ubana ko nte wa, n vu tonusuko le iꞌya vu wenei n iꞌya kpam vu panai. ");
INSERT INTO kdlNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Kotsu vu nangasa aꞌayin wa. ꞌYa̱nga̱ a lyuɓugu vu tsa̱ra̱ a za̱i unyushi u cingi u vunu. Yan nala n vu isa̱si kala ka Asheku.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Kain ka te, an n gonoi a Urishelima, mpa a uyan kavasu a Kuwa ku Kashila̱, aku n wenei kuwene, ");
INSERT INTO kdlNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","kpam n wenei Asheku a ka dansa, u danai, ‘A̱sa̱ka̱ Urishelima gogo, kpaci a ka wushuku n ili iꞌya va tonuko le a kaci ka va̱ wa.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Aku n wushuki, ‘Asheku, ele n kaci ka le dem a reve ta̱ an n ka̱na̱sa̱i aza ɗa a wushuki n avu a agata a Kashila̱ n sira̱sa le kpam n lapa le. ");
INSERT INTO kdlNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Aꞌayin a ɗa a wunai Isitifanu, uza u uyan kadyanshi ka Kashila̱, mpa pini kushani kpam n wushuku ta̱ n ili iꞌya a yain. Hal gba̱m mpa n ɓa̱na̱i aminya a ama ɗa a wuna yi vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Aku Asheku a tonuko mu, ‘ꞌYa̱nga̱ vu wala, ma suku vu ta̱ a mɓa̱ri a asu u Awulawa.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Kakuma̱ ka ama ki ka rongo yi upana̱ka hal a asu u ɗa u danai udani u ‘Awulawa,’ aku a salai una̱ u te, ‘Rawukai vuma u na vi! Wuna ni! U gan a a̱sa̱ka̱ yi n uma wa!’ ");
INSERT INTO kdlNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Aku a rongoi iyoroli n a mondusi aminya a le n maloko, a shaɗangusi akere a le n kayala a polusoi ka a uwule. ");
INSERT INTO kdlNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Aku uzapige u kuvon u aza a Roma u zuwai a bidya yi ubana a kuwa ku asoje, tsa̱ra̱ a bawan yi adama a ɗa wa tonuko le ukuna u maci. ");
INSERT INTO kdlNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Tyoku ɗa a sira yi tsa̱ra̱ a bawin yi, aku u tonukoi katigi ka ka̱ri pini vi, “U gan a bawin uza u Roma u ɗa wa̱ri n ucira u uyan ili bawu a yanka yi afada?” ");
INSERT INTO kdlNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","An katigi ki ka panai nala, aku u banai a asu u uzapige vi, u danai, “Ndya ya ciga n yain? Vuma u na vi uza u aza uyamba u Roma ɗa.” ");
INSERT INTO kdlNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Aku uzapige vi u banai ara Bulus, u wece yi, “Tonuko mu, avu uza u aza uyamba u Roma ɗa?” Aku u wushunku yi, “Nala wa̱ri.” ");
INSERT INTO kdlNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Aku uzapige vi u danai, “She na n tsupai ikebe ushani kahu n tsa̱ra̱ ucira u nala vi.” Bulus danai, “Mpa kpam n u ɗa a matsa mu.” ");
INSERT INTO kdlNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","An asoje a ɗa a ka ciga a bawin yi vi kpam a yan yi keci ki a panai nala, aku a wozoi akere a le gogo. Uzapige u kuvon vi u pana ta̱ uwonvo, kpaci u zuwa ta̱ a sira yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","An kain ka wansai, aku uzapige u kuvon vi wa ciga u reve ili iꞌya i zuwai aza a Yahuda a tukoi ukuna u na a kaci ka Bulus. U zuwai a surukpa yi ikani yi, aku u zuwai aɗara̱kpi a pige n Asheshi a Pige yi gba̱ a ɓolomgbonoi. U zuwai a ukai Bulus a asuvu, u zuwa yi u shamgbai a kapala ka le. ");
INSERT INTO kdlNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Bulus wundyai azapige a Asheshi a Pige yi mai, aku u danai, “Aza a va̱, n rongo ta̱ mai a kapala ka Kashila̱ a aꞌayin a va̱!” ");
INSERT INTO kdlNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Aku Ananiya Magono ma Aɗara̱kpi u zuwai aza ɗa aꞌa̱ri evu n Bulus vi a lapa yi a una̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Aku Bulus danai, “Kashila̱ ka lapa vu ta̱ avu uza u maci u kaɓan u gbani, dusuku ɗa vu dusuki tsa̱ra̱ vu yanka mu afada tyoku ɗa Mele ma danai, shegai avu gonoi vu koɗoi Mele mi, kpaci vu zuwai a lapa mu.” ");
INSERT INTO kdlNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Aza ɗa aꞌa̱ri evu n Bulus vi a danai, “Magono ma Aɗara̱kpi ma Kashila̱ ma va wishisa!” ");
INSERT INTO kdlNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Bulus wushunku le, “Yanka numu ahankuri atoku a va̱, n reve an Magono ma Aɗara̱kpi ma wa. Kpaci a korongu ta̱ a da ‘Kotsu uza u wisha uzapige uza ɗa wa tono n ama wa.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","An Bulus wenei Asheshi a Pige yi aza roku aza a Sadusi a ɗa aza roku kpam Afarishi, aku u ꞌya̱nga̱sa̱i kala̱ga̱tsu u danai, “Aje a va̱, mpa Kafarishi ka ilimaci i Kafarishi. An u wokoi n zuwai katakasuvu ka va̱ a asu u uꞌya̱nga̱ u ukpa̱, ɗa i zuwai a ka yanka mu afada.” ");
INSERT INTO kdlNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","An u danai nala, aku kananamgbani ka uwai a mere ma aza a Sadusi n Afarishi hal kaɓolo ki ka pecei kure. ");
INSERT INTO kdlNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Aza a Sadusi a wushuku n uꞌya̱nga̱ u ukpa̱, n atsumate a eri, n aꞌulu wa, shegai Afarishi a wushuku ta̱ n ili i nala yi gba̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Aku kacan ka ꞌya̱nga̱i cika, awenishiki a Mele aza ɗa aꞌa̱ri Afarishi a ꞌya̱nga̱i a ka ɓa̱nga̱ Bulus a danai, “Tsu wene unyushi u vuma u na vi wa, ko kenu. Gaawan kulu ko kpam katsumate ka zuba ka roku ka ka yanka yi kadyanshi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","An kacan ki ka̱ri uyan ushani, aku ama yi aꞌa̱ri uvinga̱sa̱ Bulus apashi a re gba̱. Pini nala, uzapige u kuvon u aza a Roma u zuwai asoje a wushi Bulus a akere a le, kotsu a banka yi a kuwa ku asoje. ");
INSERT INTO kdlNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","N kayin ka nala ki, Yesu Asheku u wenikei kaci ka ne ara Bulus, u danai, “Lya kapala n ugbami u asuvu. Tyoku ɗa vu yain kadyanshi ka va̱ pini naha a Urishelima, u ka̱na̱ ta̱ kpam vu yain ka a Roma.” ");
INSERT INTO kdlNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","An kain ka wansai, aku aza a Yahuda a roku a foɓusoi tsa̱ra̱ a wuna yi. A tsinai a da a ka lya ko a soi wa, she a wuna Bulus. ");
INSERT INTO kdlNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Aza ɗa a yain afoɓi a cingi a nala yi a la ta̱ ama amangare. ");
INSERT INTO kdlNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Aku a banai a asu u aɗara̱kpi a pige n azapige a tonuko le, “Tsu tsina ta̱, tsu da tsa lya ili ko tsu soi wa, she tsu wuna vuma u nala vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Eɗa̱ n Asheshi a Pige, she i tonuko uzapige u kuvon u aza a Roma u tuko yi pini na a asu u Asheshi, aku i yain yavu ciga ɗa ya ciga i doku i veci ukuna vi sawu. A̱tsu kpam ufoɓusi u ɗa tsa̱ri tsu pite yi a ure tsa̱ra̱ tsu wuna yi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Kalobo ka utaku u Bulus ka pana ta̱ ukuna u ɗa a sheshei vi, aku u banai a kuwa ku asoje ki u tonuko yi ukuna vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pini nala, Bulus isa̱i katigi ka te u tonuko yi, “Banka kalobo ka na a asu u uzapige u kuvon, Wa̱ ta̱ n ukuna u ɗa wa tonuko yi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Aku vuma vi u wushuki u bankai kalobo ki ara uzapige u kuvon vi. Pini nala, katigi ki ka tonukoi uzapige u kuvon vi u danai, “Vuma ɗa wa̱ri a kuwa ku aꞌali ku nala ki uza u kala Bulus vi, aya u zuwa mu n tuko kalobo ka na ara vunu, u da wa̱ ta̱ n ili iꞌya wa ciga u tonuko vu.” ");
INSERT INTO kdlNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Aku uzapige u kuvon vi u ka̱na̱i kukere ku kalobo ki u banka yi paki, u wece yi, ‘Ndya va ciga vu tonuko mu vi?” ");
INSERT INTO kdlNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Kalobo ki ka danai, “Ama roku a ɗa pini a sheshei a ka ciga a banka le Bulus a asu u Asheshi a Pige a aza a Yahuda nakpan. A ka yan ta̱ yavu a ka ciga a doku a veci ukuna vi mai. ");
INSERT INTO kdlNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Shegai kotsu vu yain nala wa! Kpaci ama ɗa pini a la ta̱ ama amangare a ka pite yi tsa̱ra̱ a wuna yi. A tsina ta̱ a da a ka lya ko a soi wa, she a wuna yi. Gogo‑na alya pini ufoɓusi, a ɗa a ka vana vu wushunku le.” ");
INSERT INTO kdlNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Aku uzapige vi u tonuko yi, “Kotsu vu a̱sa̱ka̱ uza u reve an vu tonuko mu ukuna u na vi wa.” Pini nala, u tonuko yi u wala. ");
INSERT INTO kdlNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Uzapige u kuvon vi u isa̱i atigi a re a tuwa̱, aku u tonuko le, “Tonukoi asoje amangatawanre (200) a foɓuso a bana a Kasariya n ulapa u uwule u kuci u kayin ka ara, n asoje a adoki amangatatsunkupa n asoje a amangatawanre (200) a kuvon na̱ nsari n le. ");
INSERT INTO kdlNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Eɗa̱ kpam i zami kadoki ka Bulus wa yuwa̱. Kotsu i banka yi ara Feli gomuna, bawu ko i te iꞌya ya gita̱ n eyi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Aku uzapige vi u korongi ukanikorongi u na ubana ara gomuna vi. U danai, ");
INSERT INTO kdlNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Mpa Kaladiyu Lisiya, ma sukunku uzapige Feli gomuna idyani. ");
INSERT INTO kdlNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Aza a Yahuda a roku a ɗa a ka̱na̱i vuma u na, hal a ka ciga a wuna yi. Shegai an n vecei ukuna vi, n revei an vuma vi uza u uyamba u Roma u ɗa, aku mpa n asoje a va̱ tsu wusa yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Aku n banka yi a asu u Asheshi a Pige, tsa̱ra̱ a veci unyushi u ɗa u yain vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Pini nala, n cinai unyushi u ɗa a ka̱na̱ yi n u ɗa vi u Mele ma le u ɗa, u rawa gba̱m a ka sira ko a wuna yi wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Shegai an vuma roku u tonuko mu ukuna u cingi u ɗa a foɓusoi a kaci ka ne, ɗa i zuwai n sukunku yi ara vunu kute‑kute. Aku n tonukoi aza a kadyanshi yi a tuwa̱ a dana unyushi u ɗa a wenei u yain vi ara vunu.” ");
INSERT INTO kdlNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Asoje yi a yain ili iꞌya a danai a yain. N kayin ka nala ka a bidyai Bulus ubana a ilyuci i Antipatari. ");
INSERT INTO kdlNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","An kain ka wansai, aku asoje a ɗa a ka wala a aꞌene yi a gonoi a kuwa ku asoje ku le, a a̱sa̱ka̱i asoje a ɗa a ka wala̱ka adoki yi a lazai n eyi ubana a Kasariya. ");
INSERT INTO kdlNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","An a rawai a Kasariya, aku a na̱ka̱i gomuna vi Bulus n ukanikorongi vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Pini nala, Feli gomuna u yain ka̱neshi u ukanikorongi vi, u wecei Bulus eyi uza u uyamba u eni u ɗa. Aku u wushunku yi, “Kilikiya.” ");
INSERT INTO kdlNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Pini nala, gomuna wushunku yi, “Ma pana̱ka vu ta̱ aꞌayin a ɗa baci dem aza ɗa a sapula vu vi a rawai. An u danai nala, aku u zuwai a kpada yi a asuvu a kuwa ku tsugono ka Hiridu magono u mai. ");
INSERT INTO kdlNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","An aꞌayin a tawun a wurai, aku ama roku a rawai a Kasariya, tsa̱ra̱ a dana ili iꞌya Bulus yain. Alya Ananiya Magono ma Aɗara̱kpi kaɓolo n azapige a aza a Yahuda a roku n karevi ka mele ka roku uza u kala Taratulu. ");
INSERT INTO kdlNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","An a isa̱i Bulus u uwa a asuvu, aku Taratulu gita̱i utonusuko gomuna vi ili iꞌya Bulus yain, u danai, “Uzapige Feli, adama a ugboji u vunu, ɗa i zuwai ama a tsunu aꞌa̱ri na̱ ndishi n shinga tun ara wa. Adama a ɗa kpam va̱ri n uwene u mɓa̱ri, ɗa i zuwai ama a tsunu a ka pana kayanyan ka ndishi n ulya u kapala. ");
INSERT INTO kdlNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ama ko nte wa a ka cikpa vu ta̱ bawu utyoku. ");
INSERT INTO kdlNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Shegai adama a ɗa bawu ma ciga n wowotongusu vu, ma folo vu adama a ugboji u ɗa va̱ri n u ɗa, vu pana̱ka tsu a asuvu a aꞌayin a kenu a na yi tsu dana ili iꞌya vuma u naha vi u yain. ");
INSERT INTO kdlNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Vuma u na vi kashila̱ka̱ni ka, tsu cina yi ta̱ wa ꞌya̱nga̱sa̱ atakasuvu a aza a Yahuda a likimba gba̱, kpam aya wa tono n kaɓolo ka aza ɗa a ka isa̱ Aza a Nazara. ");
INSERT INTO kdlNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Hal gba̱m wa ciga u nangasa Kuwa ku Kashila̱, aku tsu ka̱na̱ yi.  ");
INSERT INTO kdlNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Tsa ciga tsu yanka yi afada n Mele ma tsunu, shegai Lisiya uzapige u kuvon u aza a Roma u wusa yi ara tsunu. Aku u zuwai tsu tuko kadyanshi ki a kunu ku afada ku vunu. ");
INSERT INTO kdlNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","“Vu vece yi baci n kaci ka vunu ben, va fuɗa ta̱ va reve an ukuna u ɗa tsu tukoi a kaci ka ne ki mayun ɗa.” ");
INSERT INTO kdlNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Aku aza a Yahuda a ɗa a buwai a wushuki n ili iꞌya Taratulu danai. ");
INSERT INTO kdlNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Aku gomuna vi u yankai Bulus kukere u yain kadyanshi. Pini nala, u gita̱i u danai, “Uzapige, n reve ta̱ vu yanka ta̱ ama ushani aza a uyamba u na afada a ayen ushani, kpam n yan ta̱ maza̱nga̱ an ma wutukpa̱ kaci ka va̱ a kunu ku afada ku vunu. ");
INSERT INTO kdlNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Vu vece baci, va laza ta̱ va reve an kotsu u lai aꞌayin kupa n a re, an n banai a Urishelima ulya u kayala a Kuwa ku Kashila̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","N yan kananamgbani n uza roku a Kuwa ku Kashila̱ wa, ko kpam n ꞌya̱nga̱sa̱ atakasuvu a ama a agata a Kashila̱ ko kpam a asu u roku wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ama a naha a ka fuɗa a ka dana ili iꞌya a ka dansa na vi mayun ɗa wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ili i te iꞌya n revei iꞌya, an ma tono Kashila̱ ka isheku i tsunu a ure u ɗa a danai kaɓan ka vi, kpam n wushuki an gba̱ ili iꞌya iꞌa̱ri ukorongi a asuvu a tagara̱da u Mele ma Musa na̱ i Ntsumate. ");
INSERT INTO kdlNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","N zuwa ta̱ katakasuvu ka va̱ a asu u Kashila̱, tyoku ɗa aza ɗa a sapula mu na vi a zuwai, a da a ka ꞌya̱nga̱sa̱ ta̱ akushe aza a shinga n aza a cingi a ukpa̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Adama a nala a ɗa ma̱ri a ukirana kain dem tsa̱ra̱ n yain ili iꞌya iꞌa̱ri i maci, kpam katakasuvu ka va̱ ka rongo na̱ ndishi n shinga a asu u Kashila̱ n ama. ");
INSERT INTO kdlNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“N ɓa̱ra̱kpa̱ n ugono a Urishelima wa, ma̱ri ta̱ a kateshe ayen ushani. N gonoi n ikebe tsa̱ra̱ n na̱ka̱ ama a tsunu aza a unambi, kpam n na̱ka̱ kune a asu u Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Mpa pini a uyan nala a Kuwa ku Kashila̱ ki, cina n kotso ɗe uwulukpe kaci ka va̱, aku a cina mu pini, kpam kakuma̱ ka ama ka̱ pini wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Shegai aza a Yahuda a roku a ɗa pini aza a uyamba u Asiya, alya wa̱ri u gain a tuko kadyanshi ka va̱ ara vunu aꞌa̱ baci n ili iꞌya a ka dana a kaci ka va̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ko kpam a̱sa̱ka̱ aza ɗa a sapula na vi, a dana unyushi u ɗa Asheshi a Pige a tsa̱ra̱ mu n u ɗa aꞌayin a ɗa a yanka mu afada a Urishelima. ");
INSERT INTO kdlNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Kadyanshi ka a ka fuɗa a dana a kaci ka va̱ ka na koshi, an n salai n danai ukuna u na a kunu ku afada ku le; ‘Adama a kadyanshi ka uꞌya̱nga̱ u ukpa̱ u ɗa a ka yanka mu afada a kapala ka ɗe ara.’ ” ");
INSERT INTO kdlNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feli gomuna tani u reve ta̱ ili ushani a Ure u Asheku, aku u shamkpa le u danai, “Shamgbai she aꞌayin a ɗa Lisiya Uzapige u Kuvon† u tuwa̱i, aku n kiɗa̱ga ɗa̱ ugana.” ");
INSERT INTO kdlNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Aku u zuwai katigi ka roku ka wundi yi, u tonuko yi kotsu u gida̱ku yi wa, kpam u ɓishinka aje a ne utuwa̱ a ɓa̱nga̱ yi wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","An a yain aꞌayin, aku Feli tuwa̱i n uka u ne uza u kala Durusila, kpam uza u Yahuda u ɗa. A suki vuma roku u tuko Bulus, pini nala, a zuwuka yi atsuvu a ka pana kadyanshi ka upityanangu n Yesu Kawauwi. ");
INSERT INTO kdlNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Aku Bulus tonuko le ukuna u uyan ili i shinga, n u ka̱na̱ kaci, kpam n kain ka afada ka ka tuwa̱. An u panai nala, aku uwonvo u ka̱na̱ yi cika, u tonukoi Bulus, “Gogo‑na u rawa ta̱ ve. Wala. Shegai n tsa̱ra̱ baci kabala, ma isa̱ vu ta̱ vu tuwa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Feli tsu sukunku ta̱ Bulus tuwa̱ u dansa n eyi, kpaci u zuwa ta̱ uma wa tsa̱ra̱ ta̱ ikebe ara ne. ");
INSERT INTO kdlNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","An ayen a re a wurai, aku a takpai Feli gomuna, a na̱ka̱i Posiya Fesutu u wokoi gomuna. Shegai an Feli wa ciga kala ka shinga a asu u aza a Yahuda, aku u a̱sa̱ka̱i Bulus pini a kuwa ku aꞌali. ");
INSERT INTO kdlNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","An Fesutu ka̱na̱i manyan ma gomuna ma ne n aꞌayin a tatsu, aku u ꞌya̱nga̱i a Kasariya ubana a Urishelima. ");
INSERT INTO kdlNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Aku aɗara̱kpi a pige n azapige a aza a Yahuda a tuwa̱i n kadyanshi ka Bulus ara ne. A folo yi ");
INSERT INTO kdlNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","u zuwa a gono n Bulus a Urishelima, kpaci a foɓuso ta̱ ama a pite yi a ure a wuna yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Shegai Fesutu wushunku le, “A Kasariya ɗa a ka wundya Bulus, kpam nte ma gono ɗe gogo. ");
INSERT INTO kdlNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","U yan baci ukuna u cingi, a̱sa̱ka̱ azapige a ɗe a tono mu a ba a tuko kadyanshi ki ɗe.” ");
INSERT INTO kdlNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fesutu shamgba ta̱ n ele aꞌayin kulla̱ ubana aꞌayin kupa, aku u lazai ugono a Kasariya. An kain ka wansai, u isa̱i aza a kunu ku afada ki, u tonuko le a tuko Bulus vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","An Bulus tuwa̱i, aza a Yahuda a ɗa a wuta̱i a Urishelima vi a ꞌya̱nga̱i aꞌa̱ri utukuso kadyanshi a kaci ka ne, ka gba̱m bawu a ka fuɗa a shamkpa. ");
INSERT INTO kdlNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Shegai Bulus ꞌyuwain kadyanshi ki, u danai, “Mpa n nusuka Mele ma aza a Yahuda wa, ko Kuwa ku Kashila̱, ko kpam aza a tsugono tsu Roma wa.” ");
INSERT INTO kdlNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Shegai an Fesutu wa ciga atakasuvu a aza a Yahuda a pana kayanyan, aku u wecei Bulus, “Ko va wushuku vu bana a Urishelima n ba n yanka vu afada a ukuna u na vi ɗe?” ");
INSERT INTO kdlNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Bulus wushunku yi, “Wa yan wa, a asuvu a kunu ku afada ku Kaisa ka ma̱ri, kpam nte u gain a yanka mu pini afada. Avu n kaci ka vunu dem vu reve ta̱ mai, n nusuka aza a Yahuda wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","N yan baci ili i roku iꞌya i rawai ukpa̱, ma ꞌyuwan a wuna mu wa. Shegai ukuna u mayun wa̱ baci pini a asuvu a kadyanshi ka na ki wa, uza u ra̱tsa u neke mu a akere a ama a na yi a wuna mu wa. Ma folo ɗa̱ a ꞌya̱nga̱sa̱ kadyanshi ki ubana ara Kaisa magono ma pige.” ");
INSERT INTO kdlNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Fesutu dansai kadyanshi ki n asheshi a ne, aku u danai, “Nala wa̱ri, vu folo ta̱ ubana ara Kaisa, kpam nte va bana ɗe.” ");
INSERT INTO kdlNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","An a yain aꞌayin kenu, aku Agaripa magono n uka u ne Baranisi a tuwa̱i a Kasariya tsa̱ra̱ a ryabusa Fesutu. ");
INSERT INTO kdlNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","An u wokoi a ka yan aꞌayin ɗe, aku Fesutu tonukoi Agaripa ukuna u kadyanshi ka Bulus. U danai, “Vuma roku u ɗa pini a asuvu a kuwa ku aꞌali uza ɗa Feli a̱sa̱nka̱ mu n yanka yi afada. ");
INSERT INTO kdlNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","An ma̱ri a Urishelima, aɗara̱kpi a pige n azapige a aza a Yahuda a tuko mu kadyanshi ka vuma u nala vi, a folo mu n kiɗa̱ga yi ugana. ");
INSERT INTO kdlNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“Shegai n tonuko le, a mele ma tsunu a̱tsu aza a Roma tsu tsu kiɗa̱ga uza u ugana wa, she a tuwa̱ n eyi a kapala ka aza ɗa a tukoi kadyanshi ki, kpam a tsu a̱sa̱ka̱ yi ta̱ u dansa tsa̱ra̱ u wutukpa̱ kaci ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","An a tuwa̱i adama a kadyanshi ki, an kain ka wansai, n zuwai a tukoi Bulus, aku n gita̱i afada. ");
INSERT INTO kdlNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Shegai an ama yi a ꞌya̱nga̱i a dansa kadyanshi ki, a tuko unyushi u ɗa a da u yain u ɗa n zuwai katakasuvu n pana vi wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Shegai ukuna u adini a le u ɗa, kpam n ukuna u vuma roku uza ɗa a ka isa̱ Yesu uza ɗa u kuwa̱i, shegai Bulus ma̱tsa̱i u da wa̱ ta̱ n uma. ");
INSERT INTO kdlNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Mpa tani ma̱ri n namba ta̱ tyoku ɗa ma vece ukuna u na vi, aku n wecei Bulus ko wa wushuku u bana a Urishelima tsa̱ra̱ n ba n yanka yi afada yi ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Shegai u foloi a a̱sa̱ka̱ Kaisa magono ma pige ma pana ukuna vi, aku n zuwai a zuwa yi ve pini a kuwa ku aꞌali ki, hal ubana aꞌayin a ɗa ma tutsuku yi ubana ara Kaisa vi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Aku Agaripa tonukoi Fesutu, “Ma ciga ta̱ n pana ili iꞌya vuma na wa dana.” Aku u wushunku yi, “Va pana̱ka yi ta̱ nakpan.” ");
INSERT INTO kdlNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","An kain ka wansai, Agaripa n uka u ne Baranisi a ukai aminya a tsugono, a tuwa̱i kaɓolo n azapige a asoje n azapige a aza a ilyuci yi. Fesutu zuwai a tuko Bulus pini a asuvu a kunu ki. ");
INSERT INTO kdlNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Aku Fesutu danai, “Agaripa magono, n gba̱ azapige aza ɗa aꞌa̱ri pini na kaɓolo n a̱tsu, wundyai vuma u na vi, aza a Yahuda a ɗa aꞌa̱ri a Urishelima n Kasariya a tuwa̱ ta̱ ara va̱ a ka ciga n wuna vuma u na vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Shegai mpa n wene u yan unyushi u ɗa u rawai a ka wuna yi wa. Kpam an u wokoi u foloi a banka kadyanshi ki a asu u magono ma pige, ɗa i zuwai n yawunsai n banka yi ara ne. ");
INSERT INTO kdlNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","U ka̱na̱ ta̱ n korongu ukuna u maci a kaci ka vuma u na ubana a asu u magono. Ɗa i zuwai n tuko yi a kapala ka ɗe gba̱, hal gai avu Agaripa magono, tsa̱ra̱ tsu kotso baci uvece ukuna vi, n tsa̱ra̱ ili iꞌya ma korongu. ");
INSERT INTO kdlNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kpaci a uwene u va̱, utengeshi u ɗa a tutsuku vuma ɗa wa̱ri a kuwa ku aꞌali ubana a asu u magono bawu a danai ili iꞌya u yain.” ");
INSERT INTO kdlNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agaripa tonukoi Bulus, “Gogo‑na dansa n kaci ka vunu.” Aku Bulus ꞌya̱nga̱sa̱i kukere, u gita̱i kadyanshi: ");
INSERT INTO kdlNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Agaripa magono, n pana ta̱ kayanyan an u wokoi a kapala ka vunu ka ma yan kadyanshi n wutukpa̱ kaci ka va̱ a kadyanshi ka ama a va̱ a tukoi adama a va̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","N revei avu vu reve ta̱ Mele ma aza a Yahuda n gba̱ ili iꞌya a ka nanamgbana̱ka. Adama a nala, ma folo vu vu yain ahankuri vu pana̱ka mu. ");
INSERT INTO kdlNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“A wenishike mu ta̱ uwenishike u aza a Yahuda tun mpa kenu. N rotsongusu ta̱ a asu u ama a va̱ n a asu u aza a Urishelima. Azapige a aza a Yahuda a reve ta̱ n u ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","A reve ta̱ na̱ mpa caupa, kpam a ka fuɗa ta̱ a ka dana mpa Kafarishi ka mayun, a kaɓon ka ka̱ri n mele ma awuya a asuvu a adini a tsunu. A ka dana ta̱ mayun ɗa a ka ciga baci a dana. ");
INSERT INTO kdlNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","“Gogo‑na ma̱ ta̱ a asu u afada an n wushuki n kazuwamgbani ka Kashila̱ ka yankai ama a tsunu caupa. ");
INSERT INTO kdlNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Kazuwamgbani ka nala ki ka agali kupa n a re a zuwai uma a wene ushaɗangu u ne, ɗa i zuwai a ma̱tsa̱i ugbashika Kashila̱ kaara n kayin. Magono, an u wokoi n zuwai uma u va̱ a kazuwamgbani ka nala, ɗa i zuwai aza a Yahuda a wenei unyushi u va̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ndya i zuwai i kpa̱ɗa̱i uwushuku an Kashila̱ ka ꞌya̱nga̱sa̱ akushe? ");
INSERT INTO kdlNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Mpa n kaci ka va̱ caupa ma̱ri n wenei yavu mai ɗa n yain ili iꞌya ya ɓishinka ulya u kapala u kadyanshi ka Yesu uza u Nazara. ");
INSERT INTO kdlNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Aɗara̱kpi a pige† a wushunku mu ta̱ n yain ili i na yi, kpam n canga ta̱ Atoni ushani aza a Urishelima n uka le a kuwa ku aꞌali. Hal gba̱m n uɓolomgbono u kaci u va̱ u ɗa a wunusai aza roku. ");
INSERT INTO kdlNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","N tonoi gba̱ agata a Kashila̱ na̱ bawin le, kotsu gai n zuwa a yanka kala ka Kawauwi una̱ u cingi. Adama a ɗa ma pana upan u le cika, aku ma tonuso le a ilyuci i mɓa̱ri i tsumoci na̱ n foruso le ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Magono ma va̱, kain ka te, ma̱ri a asuvu a nwalu ubana a Damasuka uyan manyan mi, n ucira u ɗa aɗara̱kpi a pige a na̱ka̱ mu. ");
INSERT INTO kdlNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","N kaara a kaci, katyashi ka wuta̱i a zuba ka wakana mu n ama ɗa a soku mu. Katyashi ki ka la ta̱ ka kaara. ");
INSERT INTO kdlNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","An tsu rukpa̱i a iyamba gba̱ tsunu, aku n panai kala̱ga̱tsu ka dansa n Tsiꞌarama, ka tonuko mu, ‘Shawulu, Shawulu, ndya i zuwai va yan mu mavura? Utengeshi u ɗa kanaka ka shila̱ka̱na̱ n magutsu ma kalina.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Aku n wece yi, ‘Asheku, aɗa yai?’ “Asheku a wushunku mu, ‘Mpa Yesu, uza ɗa va yan mavura. ");
INSERT INTO kdlNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Gogo‑na ꞌya̱nga̱, ili iꞌya i zuwai n tuwa̱i iꞌya n zuwa vu vu woko kagbashi ka va̱ kpam vu dana ili iꞌya vu wenei a kaci ka va̱. Va tonuko ta̱ ama ukuna u ili iꞌya i gita̱i, n ili iꞌya kpam ya tuwa̱ aꞌayin a ɗa ma wenike kaci ka va̱ ara vunu. ");
INSERT INTO kdlNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ma suku vu ta̱ a asu u aza a Yahuda, n Awulawa. Ma kirana ta̱ n avu aꞌayin a ɗa va bana a asu u ɗa n suku vu. ");
INSERT INTO kdlNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Ma ciga ta̱ vu kukpa̱ aꞌeshi a le, a kpatala a a̱sa̱ka̱ karimbi ubana a katyashi. Kpam a kpatala a a̱sa̱ka̱ ucira u Kanangasi ubana ucira u Kashila̱. Aku Kashila̱ ka cimbusuka̱ le unyushi u cingi u le. Pini nala, a ka tsa̱ra̱ ta̱ asu a asuvu a ama ɗa Kashila̱ ka wulukpei an a zuwai upityanangu u le ara va̱.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Adama a nala, Agaripa magono, ma ꞌyuwan utono kuwene ka ku tuwa̱i a zuba vi wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","N gita̱ ta̱ n yankai aza a Damasuka kuɓari, aku n banai a Urishelima a uyamba u aza a Yahuda gba̱. Pini nala, n yankai Awulawa n tonuko le a kpatala a a̱sa̱ka̱ tsicingi tsu le a gono a asu u Kashila̱, kpam a yain ili iꞌya ya wenike an a kpatalai. ");
INSERT INTO kdlNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","“Ili iꞌya i zuwai aza a Yahuda a ka̱na̱ mu a Kuwa ku Kashila̱ a ka ciga a wuna mu iꞌya gai la vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Shegai Kashila̱ ka ɓa̱nga̱ mu ta̱, ɗa i zuwai ma̱ri udansa kadyanshi ka na ki a asu u aza a pige na̱ mmuku. Ili i roku iꞌya Musa na̱ ntsumate n ɗa n buwai a danai ya gita̱ vi iꞌya, ");
INSERT INTO kdlNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Kawauwi ka pana ta̱ ikyamba, kpam aya wa woko vuma u kagita̱ u ɗa wa ꞌya̱nga̱ a ukpa̱. Kpam wa woko ta̱ katyashi a asu u aza a Yahuda n Awulawa.” ");
INSERT INTO kdlNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Kute‑kute Fesutu salai, u danai, “Bulus, ijan iꞌya va suma? Uyan ka̱neshi ushani vi u zuwa vu vu woko kashimza ɗa?” ");
INSERT INTO kdlNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Shegai Bulus wushunku yi, “Uzapige Fesutu, ijan iꞌya mu wa. Ili iꞌya ma tono vi mai ɗa iꞌa̱ri, kpam n ugboji. ");
INSERT INTO kdlNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Agaripa magono u reve ta̱ n ili i na yi, kpam n eyi ɗa ma dansa bawu uwonvo. Kpaci ukuna u na u gita̱ ukpawunsi wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Agaripa magono, vu wushuku na̱ ntsumate? N revei vu wushuku ta̱.” ");
INSERT INTO kdlNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agaripa wushunku yi, “Va ciga vu gonuko mu Katoni a asuvu a aꞌayin a kenu a na a ɗa?” ");
INSERT INTO kdlNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Bulus wushunku yi, “Ko a asuvu a aꞌayin a kenu ko a ushani, ma yan ta̱ kavasu tsa̱ra̱ Kashila̱ ka zuwa avu n aza ɗa aꞌa̱ri pini na a ka pana̱ka mu gogo‑na a woko tyoku u va̱. Shegai ma ciga i uka ikani i nala yi wa.” ");
INSERT INTO kdlNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Aku Agaripa magono, n Fesutu gomuna, n Baranisi, n aza ɗa aꞌa̱ri kaɓolo n ele a ꞌya̱nga̱i a a̱sa̱ka̱i a asu vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","An a wuta̱i, aku a dansai n atoku a le, “Vuma nala u yan ili iꞌya i rawai a ka wuna yi, ko a uka yi a kuwa ku aꞌali wa.” ");
INSERT INTO kdlNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agaripa tonukoi Fesutu, “U woko baci vuma u na danai a banka kadyanshi ka ne ara Kaisa wa, she tsa̱ra̱ tsu a̱sa̱ka̱ yi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","An tsu foɓusoi tsa̱ra̱ tsu uwa a kpatsu ubana a uyamba u Italiya, aku a na̱ka̱i Bulus n aza a kuwa ku aꞌali a kukere ku katigi ka pige ka roku uza u kala Juliyo, uza u te a asuvu a asoje a Kaisa magono. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Aristaraku wa̱ ta̱ dem kaɓolo n a̱tsu. Eyi uza u ilyuci i Tasaloniya u ɗa, a uɓongu u Masidaniya. Tsu uwai a kpatsu ku ka tsu rongo uyan manyan a ilyuci i Adaramitiya. Aza a kpatsu yi a foɓuso ta̱ a ka shamgbusa a ilyuci ilyuci iꞌya iꞌa̱ri a ikengi i kushiva̱ i uyamba u Asiya. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","An kain ka wansai, aku tsu rawai a Sida. Juliyo katigi u yankai Bulus ukuna u shinga, u a̱sa̱ka̱ yi u ba kondoi aje a ne tsa̱ra̱ a na̱ka̱ yi gba̱ ili iꞌya wa ciga. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","An tsu a̱sa̱ka̱i Sida, aku uwule wa lapana tsu cika, aku tsu tonoi evu n uyamba u mere ma mini u Sayipuru tsa̱ra̱ tsu pana shana n uwule vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Tsu lyai kapala na̱ nwalu ubana a ɗaka a uɓongu u Kilikiya n Bamafiliya, aku tsu rawai a ilyuci i Mira a uyamba u Likiya. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Pini nala, Juliyo katigi u tsa̱ra̱i kpatsu ku roku ka aza a uyamba u Alizandariya kpam ka bana a Italiya, aku u zuwai tsu uwai pini. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","An tsu yain aꞌayin ushani n tsu wali sawu, she na tsu ma̱tsa̱i cika, aku tsu fuɗai tsu rawai evu n Kinidu. An uwule u ɓishinka tsu ulya kapala, aku tsu kyawain a kapashi ka bawu uwule wa̱ri pini, evu n asu u ɗa a ka isa̱ Sala̱mani a uyamba u mere ma mini u Kiriti. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Tsu moɗonoi tsu wurai asu vi n upana u ikyamba, aku tsu rawai a asu u roku u ɗa a ka isa̱ Asu u Uwunvuga u Shinga evu n ilyuci i Lasiya. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","An u wokoi tsu ɓa̱ra̱kpa̱i cika, nwalu mi n ɗa n buwa kpam mai wa, kpaci aꞌayin a aɓali a ɗa. Kpam aꞌayin a Abiki a Cimbusuka̱ Ama Unyushi u Le† a wura ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","Bulus tonukoi atigi a asoje yi, “Azapige, n wenei tsu lya baci kapala na̱ nwalu n na mi, n ɗa ma tuko ta̱ ukuna u cingi u unangasa u kpatsu, n unamba u ucanga cika. Ama kpam a ka pana ta̱ usa̱n, hal gba̱m uma u tsunu wa̱ ta̱ a una̱ u ukpa̱.” ");
INSERT INTO kdlNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Shegai katigi ka ka ɓa̱na̱ ama yi u wushuki n kadyanshi ka uza u kpatsu ki n uza ɗa wa wala̱ka kpatsu ki, u ꞌyuwain uwushuku n kadyanshi ka Bulus. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Asu u Uwunvuga u Shinga vi ukukpi u ɗa wa̱ri, kpam asu vi u lobono a lyai pini ilyushi wa, kpaci aɓali a tsu rongo ta̱ ulapusa asu vi. Adama a nala, aku aza a kpatsu yi a ka ciga a bana a ilyuci i Finikiya, tsa̱ra̱ a lyai ilyushi i le ɗe. Finikiya tani asu u ɗa aꞌatsu a tsu shamgbusa pini a uyamba u mere ma mini u Kiriti u ɗa, asu u shinga u ɗa u tsu ka̱ngu ta̱ aɓali, kpaci u ɗa wa wundya ta̱ ɗaka u kalivi n gaɗi u kalivi. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","An uwule vi u gita̱i uꞌya̱nga̱sa̱ kenu‑kenu a ɗaka, aku aza a kpatsu yi a ka yawunsa yavu aꞌayin a ɗa a yain a ɗa a ka yan ili iꞌya a foɓusoi. Aku a takpai kashamkpatsu ka kpatsu ki, tsu tonoi a ikengi i uyamba u Kiriti. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","A ɓa̱ra̱kpa̱ wa, aku uwule u pige u ɗa a ka isa̱, “Uwule u Gaɗi u Kasana,” u wuta̱i a kagiɗa u lapana tsu. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Uwule vi u lapai kpatsu ki, hal gba̱m tsu fuɗa tsu wala pini a asuvu wa. Aku tsu a̱sa̱ka̱i uwule vi u pura̱i kpatsu ki. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Tsu tonoi asu u roku u uyamba u mere ma mini u ɗa a ka isa̱ Kawuda, a asu u ɗa uwule u jebei. She na tsu moɗonoi cika, aku tsu fuɗai tsu ronoi kpatsu ku kenu ki utuwa̱ a asu u ku pige ki. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","An tsu ronoi kpatsu ku kenu ki, aku aza a kpatsu yi a zamai aban a sira̱sai kpatsu ku pige ki, adama a ɗa ka ta̱sa̱. Kpaci a ka pana ta̱ uwonvo u ɗa a ka vuta̱la̱ le a kayala ka ka soɗugusu ili dem u ɗa a ka isa̱ Siriti, aku a cipuka̱i kunya ka ka wala̱ka kpatsu ki tsa̱ra̱ ku jebe nwalu n kpatsu mi. Pini nala, a a̱sa̱ka̱i ka wala ili i ne eyi u de, kpaci a fuɗa a wala̱ka ka kpam wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","An kain ka wansai, aku a gita̱i upurusa̱ ucanga u ɗa wa̱ri pini a kpatsu ki n a vuta̱la̱si a mini, kpaci mini mi ma shila̱ka̱na̱ ta̱ cika ma gba̱ɗa̱ tsu. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Kain ka tatsu, ama yi n akere a le a ɗa a vuta̱la̱sa̱i ucanga u manyan ma kpatsu mi pini a mini mi. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","An tsu yain aꞌayin ushani bawu tsu wenei kaara ko atala, kpam uwule u pige u ulima̱ vi u a̱sa̱ka̱ wa, aku tsu takpai uma u ɗa tsa la. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Uza wa̱ la u lyai wa, gba̱ a aꞌayin a nala yi. Aku Bulus isa̱i aza a kpatsu yi, u danai, “Ama a va̱, a da baci iꞌa̱ri i pana̱ka mu tun a kagita̱, tsa̱ra̱ tsa a̱sa̱ka̱ Asu u Uwunvuga u Shinga u Kiriti u nala vi wa, tsa̱ri tsa tsa̱ra̱ usa̱n u na n unamba u ucanga u na vi wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Gbamai asuvu, uza wa̱ la wa namba uma u ne wa, shegai kpatsu ki ka shumbugu ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","I revei gai mpa vuma u Kashila̱ ɗa kpam aya ma gbashika. N kayin ka nayain, u suku ta̱ katsumate ka zuba ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Katsumate ki ka shamgbai evu na̱ mpa, ka danai, ‘Bulus, kotsu vu pana uwonvo wa! Va shamgba ta̱ a asu u afada a kapala ka Kaisa magono ma pige. Kpam adama a tsishinga tsu Kashila̱, wa wauwa ta̱ aza ɗa ya wala̱ka kaɓolo adama a vunu.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Adama a nala, gbamai asuvu a ɗe. N wushuku ta̱ n Kashila̱. Wa woko ta̱ dere tyoku ɗa u tonuko mu. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Shegai u ka̱na̱ ta̱ uwule u vuta̱la̱ tsu a kayala ka uyamba u mere ma mini, kpam kpatsu ku tsunu ku namgba gba̱.” ");
INSERT INTO kdlNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Aꞌayin kupa n a nishi uwule vi wa̱ri ugama kpatsu ki a upashi u na ubana a upashi u niɗe a kushiva̱ a ɗaka u uyamba u Italiya. Shegai a kain ka kupa n ka nishi ki, aza a kpatsu yi a wenei tsa rawa evu n iyamba. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","A kondoi akumgbi a kaɗa̱ka̱ ka mini ki, a cinai ka rawa ta̱ udeshe amangatawun n kamanga (120). An a tsa̱ra̱i a ɓa̱ra̱kpa̱i kenu, aku a doku a kondoi mini mi, a cinai ma gono ɗe udeshe amanganishinkupa koshi. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Aku a gita̱i upana uwonvo kotsu kpatsu ki ku gama atali wa. Aku a vuta̱la̱i ashamkpatsu a kpatsu a nishi a ɗa aꞌa̱ri n ara̱ji a kucina̱ ku kpatsu ki, tsa̱ra̱ a ɓishinka kpatsu ki nwalu. A yain kavasu tsa̱ra̱ kayin ka wansa gogo. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Aku aza a manyan ma kpatsu yi a ka ciga a a̱sa̱ka̱ kpatsu ki. A cipuka̱i kpatsu ku kenu ki. A yain yavu a ka cipuka̱ kashamkpatsu ka ara̱ji ka ka̱ri a kapala ka kpatsu ki. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Shegai Bulus tonukoi katigi ki n asoje yi, “Ama a na a shamgba baci a kpatsu ku pige ki wa, ya kuwa̱ ta̱ gba̱ ɗe.” ");
INSERT INTO kdlNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Aku asoje yi a kiɗa̱sai aban a kpatsu ku kenu ki a a̱sa̱ka̱i ka ku tonoi mini. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","N kpasani, aku Bulus foloi ama yi a lyai ilikulya kenu. U tonuko le, “Aꞌayin kupa n a nishi a ɗa pa vi iꞌa̱ri a kadambula bawu i lyai ilikulya. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Ma folo ɗa̱ i lyai ili i roku adama a alafiya a ɗe. I yan baci nala, ko kenji ka kaci ka ɗe ka te ka puwa̱n wa.” ");
INSERT INTO kdlNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","U shamgbai a kapala ka le, u bidyai burodi u cikpai Kashila̱, aku u jiba̱i u ɗa u gita̱i utakuma. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","A tsa̱ra̱i ugbami u asuvu, ele dem a lyai ilikulya. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","A̱tsu ama amangatawanre n amangatatsunkupa n a teli (276) a ɗa tsa̱ri pini a kpatsu ki. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","An a lyai a cuwa̱i, aku a jebigei kpatsu ki ara̱ji a varangusi icanga i ilya a mini mi. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","An kain ka wansai, aza a manyan a kpatsu yi a wene ta̱ uyamba, shegai a fuɗa kpam a reve asu u ɗa aꞌa̱ri wa. A wene ta̱ kpam asu u shinga u ɗa wa̱ri n kayala, aku a ka ciga a banka kpatsu ki ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Aku a kiɗa̱sai aban a ɗa a ka ɓa̱na̱ ashamkpatsu yi, a a̱sa̱ka̱i a ɗa a asuvu a mini. A tatsukpai ili iꞌya ya yira̱la̱kpusa̱ kpatsu ki. Pini nala, a ꞌya̱nga̱sa̱i kunya ku uwala̱ka kpatsu ki ka ka̱ri a kapala ka kpatsu ki dere tyoku ɗa uwule wa pura̱ ka ubana a asu u kayala vi. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Kpatsu ki ku tsa̱ra̱ urawa a asu u ɗa wa̱ri n kayala ki wa, aku a gbashai kayala ka roku ka ka̱ri a kere ka mini. Kaci ka kpatsu ki ka uwai a asuvu a kayala ka kpa̱ɗa̱i nwalu. Kucina̱ ku kpatsu ki ku gita̱i uta̱sa̱sa̱ adama a aɓali. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Aku asoje yi a ka ciga a wunusa aza a kuwa ku aꞌali yi, tsa̱ra̱ a yain tsuwoki a suma wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Shegai an katigi ki ka ciga ka wauwa Bulus, u ɓishinka le. Aku u zuwai aza ɗa a revei tsuwoki a raɗugusu pini a mini mi a yain tsuwoki ubana a kagiɗa. ");
INSERT INTO kdlNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Aza ɗa a buwai kpam a yuwusa̱i agbagala a upeti, aza roku kpam a yuwusa̱i aɓaci a kpatsu yi. Nala a yain a rawai a kagiɗa gba̱ le. ");
INSERT INTO kdlNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","An tsu lai, aku tsu revei an a uyamba u ɗa wa̱ri a mere ma mini u ɗa tsa̱ri, kpam kala ka asu ki ka Malita. ");
INSERT INTO kdlNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Aza a uyamba vi a ryabusa tsu ta̱ mai, hal a zuwuka tsu akina tsa̱ra̱ tsu lyashuku, kpaci a ka ro ta̱ kpam kuta̱nu ka pini. ");
INSERT INTO kdlNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Bulus cira̱ngi ncaka, aꞌayin a ɗa wa zuwa n ɗa a akina, aku kasuɗugbate ka akina ki ka wutukpa̱i kali ka roku ka tsukonu, cina eyi pini uka̱ni na̱ ncaka mi. Pini nala, kali ki ka kapa yi a kukere bawu ka takpai. ");
INSERT INTO kdlNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","An ama a ilyuci yi a wenei nala, aku a dansai utyoku u le, “Gaawan vuma u na kawuni ka ama ka. Ko an u lai a asuvu a aɓali yi, hal n gogo‑na kameli ka ka̱ri uka ka afada a ɗa aꞌa̱ri dere ka buwa yi ta̱ utono ka ciga ka wuna yi.” ");
INSERT INTO kdlNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Bulus vishanai kukere ku ne, aku kali ki ka rukpa̱i pini a akina yi, kpam ko i te ka yanka yi wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ama yi n a wundi kukere ki ka shita ko kpam wa rukpa̱ kute‑kute u kuwa̱. Shegai an a ɓa̱ra̱kpa̱i a wenei ili i yan yi wa, aku a savaɗai kadyanshi a da, “Vuma u na, kashila̱ ka roku ka.” ");
INSERT INTO kdlNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Evu n asu vi, uyamba u ɗa pini u ɗa wa̱ri u uzapige u uyamba u mere ma mini mi, uza ɗa a ka isa̱ Pubilu. Aya u wusha tsu u zuwa tsu a kuwa ku ne hal aꞌayin a tatsu. ");
INSERT INTO kdlNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Dana tata u ne ɗa pini nvain n usuɗugbi u ikyamba n kucaru. Pini nala, Bulus ba u dana̱sa yi, u taɗanku yi akere u yanka yi kavasu u ta̱na̱sa̱ yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","An vuma u ta̱na̱i, aku gba̱ aza ɗa aꞌa̱ri a uyamba vi a tukusoi aza a mɓa̱la̱ ara Bulus, kpam u ta̱na̱sa̱ le. ");
INSERT INTO kdlNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ama yi a na̱ka̱ tsu ta̱ karinga̱, kpam an tsa laza a kpatsu, a na̱ka̱sa̱ tsu ta̱ ili iꞌya tsa ciga. ");
INSERT INTO kdlNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Tsu rongo ta̱ a Malita hal uwoto u tatsu, pini nala, tsu lyai kapala na̱ nwalu mi. Tsu uwai a kpatsu ka ku wuta̱i a ilyuci i Alizandariya ka ka̱ri n iryoci i aꞌulu a mpeshe ma amelia a ɗa a ka isa̱ Kasata n Pololu a ɗa a shei na̱ nɗanga. Nte dem ku lyai pini ilyushi a ilyuci yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","An tsu rawai a ilyuci i Sirakusa, tsu rongo ta̱ pini aꞌayin a tatsu. ");
INSERT INTO kdlNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Pini nala, tsu uwai kpatsu she a Rigiyun. An kain ka wansai, uwule u ꞌya̱nga̱i a ɗaka, aku tsu lazai she a Putiyoli. ");
INSERT INTO kdlNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Tsu cina ta̱ pini Atoni, aku a folo tsu tsu shamgba n ele. An aꞌayin a shindere a wurai, aku tsu lazai she a Roma. ");
INSERT INTO kdlNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Aza a tsunu aza ɗa aꞌa̱ri a Roma a reve ta̱ an tsa tuwa̱, aku a tuwa̱i a ka̱ngu tsu a Kuden ku Apiyu n asu u ɗa a ka isa̱ Aꞌuwa a Amoci a Tatsu. An Bulus gawunsai n ele, u cikpai Kashila̱ kpam ikyamba i ne i doki ucira. ");
INSERT INTO kdlNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","An tsu rawai a Roma, aku a zuwai Bulus rongo utyoku u ne, kpam kasoje n ka wundi yi. ");
INSERT INTO kdlNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","An tsu yain aꞌayin a tatsu, Bulus isa̱i azapige aza a Yahuda, u tonuko le, “Aza a va̱, n nusuka ama a va̱ wa, ko kpam ukuna u isheku i tsunu wa. Shegai gba̱ n nala a neke mu a akere a aza a Roma a Urishelima a ka̱na̱ mu. ");
INSERT INTO kdlNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Alya n kunu ku afada ki, an a vecei ukuna u va̱ vi, aku a ka ciga a a̱sa̱ka̱ mu, kpaci a ka̱na̱ mu n unyushi u ɗa u rawai a wuna mu wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Shegai an aza a Yahuda a ꞌyuwain uwushuku, aku u ka̱na̱i n foli a gonuko kadyanshi ki ara Kaisa. Shegai ciga ɗa ma ciga n banka ama a tsunu a asu u afada wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Isa̱ ɗa n isa̱ ɗa̱ tsa̱ra̱ tsu dansa. A sira mu ta̱ n ikani, kpaci n wushuku ta̱ n uzuwa u uma u aza a Isaraꞌila; wata, Kawauwi uza ɗa tuwa̱i.” ");
INSERT INTO kdlNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Aku a danai, “Tsu pana ili i roku a kaci ka vunu wa. Tsu wene ukanikorongi u ɗa u wuta̱i asu u aza a Yahuda wa, ko uza u tuwa̱ u tonuko tsu ukuna vi wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Shegai tsa ciga ta̱ tsu pana ili iꞌya iꞌa̱ri a katakasuvu ka vunu, kpaci ili iꞌya tsu revei a kaci ka kaɓolo ka savu ka na ki iꞌya ko nte wa a ka dana ta̱ ukuna u cingi a kaci ka ne.” ");
INSERT INTO kdlNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","A zuwai kain ka a ka tuwa̱ a gawunsa n eyi a asu u ɗa u cipa̱i vi. Kain ki a tuwa̱ ta̱ ushani. Ili iꞌya i bidyai usana hal ubana kuvuli, Bulus wa̱ri udansa n ele ukuna u tsugono tsu Kashila̱. U yan ta̱ manyan n Mele ma Musa n Itagara̱da i Ntsumate. Wa moɗono tsa̱ra̱ u rono le utuwa̱ a asu u Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Aza roku a wushuku ta̱ n ili iꞌya u danai, aza roku tani wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Aku aꞌa̱ri kananamgbani ubana n ugono utyoku u le, aku a gita̱i ulaza̱sa. A makorishi, Bulus danai, “Kulu Keri ku dana ta̱ mai an ku yain kadyanshi a una̱ u Ishaya matsumate, an u tonukoi isheku i tsunu, ");
INSERT INTO kdlNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","“ ‘Ba vu tonuko ama a va̱, Ya pana ta̱ kadyanshi ka va̱, shegai ya reve wa. Ya wene ta̱, shegai ya reve kalen ka ne wa. ");
INSERT INTO kdlNT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Kpaci atakasuvu a ɗe a gbama ɗe, a votsuku ɗe atsuvu a ɗe, a kimba̱ ɗe aꞌeshi a ɗe. Tsa̱ra̱ i wene n aꞌeshi a ɗe wa, i pana n atsuvu a ɗe wa, kpam i reve n atakasuvu a ɗe wa. A da baci nala wa, iꞌa̱ri ya kpatala ta̱ utuwa̱ ara va̱ aku n ta̱na̱sa̱ ɗa̱.’ ");
INSERT INTO kdlNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“Adama a nala, ma ciga i reve, alabari a iwauwi a nala yi a asu u Kashila̱ u ɗa a wuta̱i hal utuwa̱ a asu u Awulawa, kpam alya a ka wusha a ɗa.”  ");
INSERT INTO kdlNT_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","An u danai nala, aku aza a Yahuda a ꞌya̱nga̱i aꞌa̱ri uyan kananamgbani utyoku u le. ");
INSERT INTO kdlNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Bulus dusuku ta̱ a kuwa ka wa tsupusa ikebe hal ayen a re n u wushi gba̱ uza ɗa baci dem u tuwa̱ yi uwene. ");
INSERT INTO kdlNT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","U yain kuɓari ku tsugono tsu Kashila̱ bawu uwonvo, n u wenishiki ama ukuna u Yesu Kawauwi Asheku, kpam uza u ɓishinka yi wa. ");
INSERT INTO kdlNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Mpa Bulus uza ɗa u korongi ukanikorongi u na vi. Mpa kagbashi ka Yesu† Kirisiti† Kawauwi† ka. Kashila̱ ka ɗanga̱sa mu ta̱ n woko kasuki,† kpam u suku mu n ba n yain kuɓari ku Kadyanshi ka Shinga† ka ne. ");
INSERT INTO kdlNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Caupa, Kashila̱ ka yan ta̱ kazuwamgbani† ka Kadyanshi ka Shinga ka na a asu u ntsumate n ne, tyoku ɗa a korongi a Tagara̱da u Kashila̱ u Uwulukpi.† ");
INSERT INTO kdlNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","4","Kadyanshi ka Shinga ki ukuna u Maku ma ne u ɗa u dansai; wata, Yesu Kawauwi Asheku a tsunu. A matsa yi ta̱ tyoku u vuma, eyi kumaci ku Dawuda† Magono ka wa̱ri. Shegai Kulu ku uwulukpi ku wenike ta̱ n ucira, Yesu Maku ma Kashila̱ ma, kpaci u ꞌya̱nga̱sa̱ yi ta̱ a ukpa̱. ");
INSERT INTO kdlNT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","A asu u Kawauwi, Kashila̱ ka na̱ka̱ mu ta̱ manyan ma shinga ma kasuki. Manyan ma na mi ma ma tono n ama a iyamba gba̱ a wushuku kpam a pana̱ka yi. Aya ma yanka manyan ma na mi. ");
INSERT INTO kdlNT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Iꞌa̱ ta̱ a asuvu a ama a nala yi a ɗa Yesu Kawauwi u ɗanga̱sai. ");
INSERT INTO kdlNT_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","N korongu ta̱ ukanikorongi u na vi ubana ara ɗe gba̱ aza ɗa aꞌa̱ri a ilyuci i Roma.† Kashila̱ ka ciga ɗa̱ ta̱ kpam u isa̱ ɗa̱ i woko ama a uwulukpi a ne. A̱sa̱ka̱ Kashila̱ Tata u tsunu n Asheku Yesu Kawauwi u na̱ka̱ ɗa̱ ukuna u shinga† na̱ ndishi n shinga. ");
INSERT INTO kdlNT_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","A̱sa̱ka̱ n gita̱ n cikpa Kashila̱ a asuvu a kala ka Yesu Kawauwi adama a ɗe gba̱. N yan ta̱ nala adama a ɗa gba̱ ama a asuvu a likimba a ka dansa ta̱ ukuna u upityanangu u ɗe. ");
INSERT INTO kdlNT_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Kashila̱ ka reve ta̱ n a̱sa̱ka̱ uyansa kavasu adama a ɗe wa, na̱ n gbashiki yi n katakasuvu ka va̱, na̱ n dansi Kadyanshi ka Shinga ka Maku ma ne. ");
INSERT INTO kdlNT_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Aꞌayin a ɗa baci ma yan kavasu, n tsu folo ta̱ Kashila̱ ka a̱sa̱ka̱ mu n kondo ɗa̱, kpam nala wa woko Kashila̱ ka wushuku baci. ");
INSERT INTO kdlNT_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Ma ciga ta̱ n wene ɗa̱ tsa̱ra̱ n na̱ka̱ ɗa̱ ucun u una̱ u shinga u ɗa Kulu ku Kashila̱ ku na̱ka̱ mu. Ka ka ɓa̱nga̱ ɗa̱ i gbonguro a asuvu a Asheku. ");
INSERT INTO kdlNT_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Dana ɗa ma dana ma ciga ta̱ tsu ɓa̱nga̱mgba̱na̱i n upityanangu u ɗa tsu tsa̱ra̱i. Upityanangu u ɗe wa ɓa̱nga̱ mu ta̱, kpam upityanangu u va̱ wa ɓa̱nga̱ ɗa̱ ta̱. ");
INSERT INTO kdlNT_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Aje a va̱, ma ciga ta̱ i reve an n tsu foɓuso ta̱ n tuwa̱ n kondo ɗa̱. Shegai ili i roku i tsu ka̱ngu mu ta̱ uyan nala. Ma ciga ta̱ n zuwa ama a toni Kawauwi a asuvu a Roma, tyoku ɗa n yain a asu u atoku a ɗe Awulawa.† ");
INSERT INTO kdlNT_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","U ka̱na̱ ta̱ n gbashika ama gba̱: Nheline n aza ɗa bawu aꞌa̱ri Nheline; aza ɗa aꞌa̱ri arevi n aza ɗa bawu a revei ili. ");
INSERT INTO kdlNT_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Ili iꞌya i zuwai n ma̱tsa̱i cika ma ciga n yanka ɗa̱ kuɓari ku Kadyanshi ka Shinga a Roma iꞌya gai la vi. ");
INSERT INTO kdlNT_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","N pana uwono adama a Kadyanshi ka Shinga ka Kawauwi ka na ki wa, kpaci ucira u ɗa Kashila̱ ka yankai manyan u wauwai uza ɗa baci dem u pityanangi u ɗa la vi, ili iꞌya i bidyai aza a Yahuda ubana aza ɗa bawu aꞌa̱ri aza a Yahuda.† ");
INSERT INTO kdlNT_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Kadyanshi ka Shinga ki ka wenike ta̱ tyoku ɗa Kashila̱ ka gonukoi ama, a woko ama a maci n eyi: a asu u upityanangu u ɗa tun a kagita̱ hal ubana a makorishi. Tyoku ɗa Tagara̱da u Kashila̱ u danai, “Uza ɗa Kashila̱ ka gonukoi uza u maci† n eyi wa tsa̱ra̱ ta̱ uma adama a ɗa u wushuki n Kashila̱.” ");
INSERT INTO kdlNT_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Kashila̱ uza ɗa wa̱ri a zuba† wa wenike ta̱ tyoku ɗa wa pana upan, a asu u ukiɗa̱ga ama ugana a unyushi u cingi n ikuna i cingi iꞌya a yansai. A ka̱ngu ta̱ ukuna u mayun n tsicingi tsu le. ");
INSERT INTO kdlNT_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Kashila̱ ka yan le ta̱ mavura, adama a ɗa a reve ta̱ ili iꞌya i gain ama a reve a ukuna u Kashila̱ mai, kpaci Kashila̱ ka wenike le ta̱ iꞌya gba̱. ");
INSERT INTO kdlNT_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Ama a ka wene ucira u Kashila̱ u ɗa bawu wa̱ri n utyoku n aꞌeshi a le wa, kpam n ure u uyawunsa u ne u uwulukpi. Tun an Kashila̱ ka yain likimba, gba̱ ili iꞌya u yain i wenike ta̱ tyoku ɗa wa̱ri. Adama a nala, ama a ka tsa̱ra̱ ure u kunyani wa. ");
INSERT INTO kdlNT_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Ko an a revei Kashila̱, a ꞌyuwan yi ta̱ una̱ka̱ tsupige tyoku u Kashila̱ ka mayun, a ꞌyuwan yi kpam ucikpa. A una̱ u nala, aku uyawunsa u le u wokoi u gbani. Atakasuvu a utengeshi a le a shaɗangi n karimbi. ");
INSERT INTO kdlNT_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","A da aꞌa̱ ta̱ n ugboji, shegai a wokoi atengeshi. ");
INSERT INTO kdlNT_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","A lyaka Kashila̱ ka tsupige uza ɗa wa̱ri n uma bawu utyoku kayala wa. Aku a gonoi a lyakai ameli a ɗa a rotsoi ama aza ɗa bawu aꞌa̱ri n uma u ɗa bawu wa̱ri n utyoku, na̱ nnu, na̱ nnama, n aꞌali kayala. ");
INSERT INTO kdlNT_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Adama a ɗa a yansai ili i nala yi, Kashila̱ ka a̱sa̱ka̱i ama a nala yi a karai ure u le. A yain gba̱ ili iꞌya a ka ciga a yain, kpam maluwa ma cingi ma le ma zuwa le a yamgbanai tsishankala tsu uwono n ikyamba i le. ");
INSERT INTO kdlNT_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","A ꞌyuwain ukuna u mayun u Kashila̱ aku a wushuki n kaɓan. A lyakai ili iꞌya Kashila̱ ka yain kayala a una̱ u ɗa a ka lyaka uza ɗa u yain iꞌya kayala. Aya uza ɗa wa wusha icikpali hal ubana bawu utyoku. Ami.† ");
INSERT INTO kdlNT_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","An u wokoi a yain nala, aku Kashila̱ ka a̱sa̱ka̱ le a tonoi maluwa ma uwono ma le. Aka a ka vakusu n atoku a le aka, kpam nala u gain u woko wa. ");
INSERT INTO kdlNT_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Nala dem aꞌali a yain. A a̱sa̱ka̱i uciga uvakusu n aka, aku a wokoi n maluwa ma pige ma uyan tsugbani n aꞌali. A yain ili i uwono n atoku a le, kpam ili iꞌya i gita̱i n ele iꞌya mavura adama a ili i utengeshi iꞌya a yain. ");
INSERT INTO kdlNT_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Ama a yawunsa an wa̱ri n kalen a tsa̱ra̱ ureve u mayun u Kashila̱ wa. Aku Kashila̱ ka lazai ka a̱sa̱ka̱ le n atakasuvu a cingi a le, u a̱sa̱ka̱ le a yain ili iꞌya bawu iꞌa̱ri i gain a yain. ");
INSERT INTO kdlNT_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","A shaɗangi n gba̱ icun i unyushi u cingi n tsicingi. A ka ciga̱ka kaci ka le ili dem. A kovoi ama. A shaɗangi n malyon. A ka ciga mawunuka gbani gbani, n a shila̱ka̱na̱si n atoku, a vurusa̱i aꞌene atoku. Kain dem uyawunsa u le u ili i cingi u ɗa a kaci ka ama. A yain ndyami. ");
INSERT INTO kdlNT_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","A nangasai aꞌala a ama. A kovoi Kashila̱. A wenike ama karinga̱ wa. A yain ara̱ɗi. A cikpala̱sai kaci ka le. A ma̱tsa̱i a yain tsicingi a ire i savu. A na̱ka̱ isheku i le karinga̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Aꞌa̱ ta̱ n utengeshi. A shaɗangusu kazuwamgbani ka le wa. A wenike ikuna i shinga ko asuvayali wa. ");
INSERT INTO kdlNT_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","A reve ta̱ mele† ma Kashila̱ ma dana ta̱ uza ɗa baci wa̱ri nala u gan ta̱ u kuwa̱. Shegai nala u ɓishinka le a lyai kelime n uyan tsicingi tsu le wa. Hal gba̱m a wushunki aza roku a yain dem nala. ");
INSERT INTO kdlNT_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Gaawan ya rongo ta̱ a udansa, “Ama a ɗa va dansa̱ka vi aza a cingi a ɗa!” Shegai eɗa̱ dem ama a cingi a ɗa tyoku ɗa aꞌa̱ri, kpam iꞌa̱ n ili iꞌya ya dana wa! I dana baci ama a cingi a ɗa, kpam a ka kiɗa̱ga le ta̱ ugana, kaci ka ɗe ka ya kiɗa̱ga ugana, kpaci ili i te iꞌya ya yansa. ");
INSERT INTO kdlNT_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Tsu reve ta̱ Kashila̱ ka yain derere an u kiɗa̱gai aza ɗa a ka yansa ili i nala yi ugana. ");
INSERT INTO kdlNT_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","An wa̱ i wenei unyushi u ama a na yi hal i kiɗa̱ga le ugana, kpam eɗa̱ dem nala ya yansa, niɗa ya wundya ya la a ukiɗa u ugana u Kashila̱? ");
INSERT INTO kdlNT_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","I goro Kashila̱ an wa̱ri uza u shinga, kpam an bawu u yanka ɗa̱ mavura kute‑kute, ko adama ahankuri a ne? Mayun ɗa ili iꞌya i zuwai Kashila̱ ka̱ri uza u shinga ara ɗe iꞌya an wa ciga ɗa̱ i kpatala† utuwa̱ ara ne. ");
INSERT INTO kdlNT_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Shegai eɗa̱ i ryagbaja ta̱ kpam i ꞌyuwain ukpatala a asu u Kashila̱. Wa zuwa ɗa̱ ta̱ i pana ikyamba cika kain ka wa wenike upan u ne kpam u yain afada dere. ");
INSERT INTO kdlNT_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Kashila̱ ka tsupa ta̱ ya dem a ili iꞌya u yain. ");
INSERT INTO kdlNT_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Wa na̱ka̱ ta̱ uma u ɗa bawu wa̱ri n utyoku a asu u aza ɗa a lyai kapala n uyan ili i shinga, aza ɗa kpam a zama yi u na̱ka̱ le tsupige, n icikpali, n uma u ɗa bawu wa̱ri n utyoku. ");
INSERT INTO kdlNT_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Shegai wa tsungu ta̱ upan u ne a asu u aza ɗa a rongoi tsa̱ra̱ a na̱ka̱ kaci ka le upana kayanyan koshi, kpam a ꞌyuwain una̱ka̱ ukuna u mayun karinga̱, kpam a ka yansa ikuna i cingi maco. ");
INSERT INTO kdlNT_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Kashila̱ ka zuwa ta̱ ya dem uza ɗa wa yansa unyushi u cingi maco u pana ikyamba kpam u pana mɓa̱la̱. Nala wa gita̱ ta̱ ve a asu u aza a Yahuda, aku a asu u Awulawa. ");
INSERT INTO kdlNT_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Shegai wa na̱ka̱ ta̱ tsupige, n icikpali, na̱ ndishi n shinga a asu u uza ɗa baci dem wa yansa ili i shinga. A asu u aza a Yahuda u ɗa nala wa gita̱, aku a asu u Awulawa. ");
INSERT INTO kdlNT_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Nala Kashila̱ ka yanka ama gba̱ afada una̱ u te. ");
INSERT INTO kdlNT_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","A ka foro ta̱ Awulawa a yan baci unyushi u cingi, ko an u wokoi a reve Mele ma Kashila̱ ka na̱ka̱i Musa† wa. A ka foro ta̱ aza a Yahuda a yan baci unyushi u cingi, kpaci aꞌa̱ ta̱ n Mele mi. ");
INSERT INTO kdlNT_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Kashila̱ ka zuwa ama a woko ama a maci a kapala ka ne an a tonoi Mele wa. Shegai a ka woko ta̱ nala a yan baci ili iꞌya Mele ma danai a yain. ");
INSERT INTO kdlNT_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Ko an u wokoi Awulawa, aza ɗa bawu aꞌa̱ri n Mele, a ɗanga̱sa̱ka ta̱ kaci ka le a toni ili iꞌya Mele ma danai, a wenike ta̱ a atakasuvu a le a reve ta̱ ili iꞌya iꞌa̱ri dere n ili iꞌya iꞌa̱ri i cingi. ");
INSERT INTO kdlNT_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","A wenike ta̱ mele mi ma̱ ta̱ a asuvu a le, adama a ɗa uyawunsa u le u tsu tonusuko le ta̱ ili iꞌya a ka yansa iꞌa̱ mai wa, ko kpam u tsu tonusuko le ta̱ a ka yansa ta̱ ili mai. ");
INSERT INTO kdlNT_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Gba̱ ili i na yi ya gita̱ ta̱ a kain ka Kashila̱ ka yanka uyawunsa u ama u ɗa wa̱ri usokongi afada a asu u Yesu Kawauwi. Kadyanshi ka Shinga ka ma yansa kuɓari ku ka danai nala. ");
INSERT INTO kdlNT_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Uza u Yahuda ɗa baci va̱ri, n Mele ma vu pityanangi. Va yan ta̱ ara̱ɗi an va̱ri a asuvu a ama a Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Vu reve ta̱ ili iꞌya wa ciga vu vu yain, vu reve ta̱ kpam ili iꞌya iꞌa̱ri derere, kpaci vu rotsongusu ta̱ Mele mi. ");
INSERT INTO kdlNT_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Vu bidiga ta̱ kaci ka vunu vu woko uza ɗa wa rono arumba̱, vu bidigai kpam kaci ka vunu vu woko katyashi ka aza ɗa aꞌa̱ri a asuvu a karimbi. ");
INSERT INTO kdlNT_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Vu wenei yavu va wenike ta̱ atengeshi ili iꞌya iꞌa̱ri dere, kpam i wenishike aza ɗa bawu a revei ili. Va̱ ta̱ n Mele mi, adama a nala vu wenei yavu vu reve ili dem, kpam va̱ri n ukuna u mayun gba̱. ");
INSERT INTO kdlNT_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Vu wenishike ta̱ ama, ndya i zuwai bawu vu wenishikei kaci ka vunu? Vu tonusuko ta̱ ama kotsu a yain uboki wa, shegai avu vu gonoi va boko. ");
INSERT INTO kdlNT_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Vu da u gan a yain tsishankala wa, shegai avu vu gonoi va yan tsa. Vu da u gan a lyaka ameli kayala wa, shegai va tsa̱ra̱sa̱ ta̱ ili iꞌya i tsu uwa vu a ure u ɗa bawu u gain a kuwa ku ameli a le. ");
INSERT INTO kdlNT_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Vu yan ta̱ ara̱ɗi an va̱ri n Mele, shegai vu zuwa ta̱ ama a goroi Kashila̱, kpaci vu ꞌyuwain ma una̱ka̱ karinga̱. ");
INSERT INTO kdlNT_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Dere ɗa tyoku ɗa Tagara̱da u Kashila̱ u danai, “Awulawa a tsu wishisa ta̱ Kashila̱ adama a ɗe.” ");
INSERT INTO kdlNT_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Uza u Yahuda ɗa baci va̱ri, kpam va yan ili iꞌya Mele ma danai vu yain, a kiɗa vu baci kacombi,† u woko gbani wa. Shegai vu na̱ka̱ baci Mele mi karinga̱ wa, dere ɗa yavu aꞌa̱ri a kiɗa vu kacombi wa. ");
INSERT INTO kdlNT_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","A tsu kiɗa Awulawa acombi wa, shegai a yan baci ili iꞌya Mele ma danai, Kashila̱ ka wene le ta̱ yavu a kiɗa le ta̱ acombi. ");
INSERT INTO kdlNT_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Kashila̱ ka tuwa̱ ta̱ ka yanka aza a Yahuda afada, kpaci Awulawa n kaci ka le a na̱ka̱ ta̱ Mele mi karinga̱. Va̱ ta̱ n Mele mi kpam a kiɗa vu ta̱ kacombi, shegai vu ꞌyuwain una̱ka̱ Mele mi karinga̱. Awulawa a na̱ka̱ ta̱ Mele mi karinga̱, ko an u wokoi a kiɗa le acombi wa. ");
INSERT INTO kdlNT_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Adama a ɗa ama a revei an avu uza u Yahuda u ɗa, kpam a kiɗa vu kacombi, nala u gonuko vu uza u Yahuda u mayun wa. ");
INSERT INTO kdlNT_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Mayun tani, uza u Yahuda u mayun aya uza ɗa katakasuvu ka ne ka̱ri dere n Kashila̱. Kpam ukiɗa u kacombi u mayun u ɗa an a kiɗa vu ikyamba wa, shegai usavaɗa u katakasuvu u ɗa, manyan ma Kulu ku Kashila̱ ma la vi. Usavaɗa u katakasuvu u nala vi, manyan ma Mele ma a korongi ma wa. Ucun u vuma u nala vi wa wusha ta̱ icikpali a asu u Kashila̱, shegai a asu u ama wa. ");
INSERT INTO kdlNT_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Aza a Yahuda aꞌa̱ n ili i roku iꞌya ama ɗa a buwai bawu aꞌa̱ri n iꞌya? Ndya i lobonoi a kiɗa le baci acombi? ");
INSERT INTO kdlNT_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","I lobono ta̱ a ire ushani! Ure u kagita̱ u ɗa, Kashila̱ ka wushunku ta̱ aza a Yahuda n akani a ne. ");
INSERT INTO kdlNT_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Mayun ɗa aza roku a le a wushuki n akani yi wa. Nala wa ɓishinka Kashila̱ uyan ili iꞌya u zuwamgbanai ɗa? ");
INSERT INTO kdlNT_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ko kenu! Ko ya dem u woko baci uza u kaɓan, Kashila̱ ka̱ ta̱ pini uza u mayun. Tagara̱da u Kashila̱ u dansa ta̱ ukuna u ne, “Ili iꞌya baci dem vu dansai, ya dem wa wene ta̱ mayun ɗa. Aꞌayin a ɗa a baci dem a banka vu a asu u afada, vu tsu lya ta̱ kaci.” ");
INSERT INTO kdlNT_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Aza roku a dana ta̱, “Tsu yan baci unyushi, nala u wenike ta̱ a kateshe Kashila̱ uza u maci ɗa. Adama a nala tsu dana ɗe la vi Kashila̱ ka nusa ta̱ u foro tsu baci.” (N pana ta̱ ama a danai nala.) ");
INSERT INTO kdlNT_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Shegai nala wa̱ri wa! Mayun ɗa baci Kashila̱ ka tsu yansa ili i shinga wa, wa fuɗa wa yanka likimba afada wa. ");
INSERT INTO kdlNT_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Uza roku u dana ta̱, “N yan baci kaɓan, kpam kaɓan ka va̱ ka wenikei ili iꞌya Kashila̱ ka danai mayun ɗa kpam ka na̱ka̱ yi tsupige, niɗa Kashila̱ ka dana mpa uza u unyushi u cingi u ɗa aku u yan mu mavura?” ");
INSERT INTO kdlNT_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Nala baci wa̱ri, ya fuɗa ta̱ kpam ya dana, “A̱sa̱ka̱ tsu lyai kapala n uyansa unyushi u cingi tsa̱ra̱ u woko utsa̱ra̱ u tsupige u Kashila̱.” Ama roku a tonuko tsu ta̱ kagbani a da ucun u uwenishike u nala vi u ɗa tsa yansa. Shegai nala wa̱ri wa! Kashila̱ ka yan le ta̱ mavura a ili iꞌya a yansai. ");
INSERT INTO kdlNT_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Dana ɗa tsa ciga tsu dana a̱tsu aza ɗa tsa̱ri aza a Yahuda tsu la aza ɗa a buwai ɗa? Nala wa! Tsu wenike ɗa̱ ɗe an unyushi u cingi wa tono n ama gba̱; wata, aza a Yahuda n Awulawa. ");
INSERT INTO kdlNT_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Tagara̱da u Kashila̱ u tonuko tsu ta̱, “Uza u maci wa̱ la wa, ko uza u te. ");
INSERT INTO kdlNT_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Uza u kakiri wa̱ la wa. Uza wa̱ la wa zama Kashila̱ wa. ");
INSERT INTO kdlNT_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Gba̱ le a kpatala̱ka ɗe Kashila̱ kucina̱. Ya dem u woko ɗe uza u gbani. Uza wa̱ la u yain ili i maci wa. Ko uza u te.” ");
INSERT INTO kdlNT_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","“Kadyanshi ka le kasaun ka ukukpi. Kadyanshi ka le ushaɗangi u ɗa ka̱ri n kaɓan.” “Ili iꞌya a dansai iꞌa̱ ta̱ tyoku u tsukonu tsu kali.” ");
INSERT INTO kdlNT_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","“A tsu rongo ta̱ uyansa una̱ u cingi u ɗa wa̱ri akoni a de.” ");
INSERT INTO kdlNT_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","“Ufoɓusi u ɗa aꞌa̱ri maco tsa̱ra̱ a wuna ama. ");
INSERT INTO kdlNT_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","A asu u ɗa dem a banai a tsu tuko ta̱ uwacinsa n upana u ikyamba. ");
INSERT INTO kdlNT_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","A tsu yan ili iꞌya ya zuwa ama a rongo na̱ ndishi n shinga n atoku wa.” ");
INSERT INTO kdlNT_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","“A tsu pana gba̱m uwonvo u Kashila̱ wa.” ");
INSERT INTO kdlNT_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Tsu reve ta̱ gai ili iꞌya gba̱ Mele ma danai, ma dana ta̱ iꞌya a kaci ka aza ɗa Kashila̱ ka na̱ka̱i ma. Nala wa̱ri tsa̱ra̱ ama gba̱ a namba ili i udana, kpam kotsu gba̱ likimba u reve an wa̱ri a kere ka afada a Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Uza wa fuɗa wa woko uza u maci n Kashila̱ a asu u utono u Mele wa, kpaci manyan ma Mele ma la wa. Ili iꞌya Mele ma tsu yan iꞌya ma zuwa tsu tsu reve an tsu yain unyushi u cingi. ");
INSERT INTO kdlNT_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Shegai gogo‑na Kashila̱ ka wenike ta̱ ure u roku kau u ugonuko ama a woko ama a maci. Mele mi n ikorongi i ntsumate a yan ta̱ kadyanshi ka ure u na vi, shegai a asu u una̱ka̱ Mele ma Musa karinga̱ ɗa wa. ");
INSERT INTO kdlNT_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Kashila̱ ka gonuko ta̱ ama a woko ama a maci a wushuku baci n Yesu Kawauwi u takpa le unyushi u cingi u le. Kpam gba̱ ama a ka tsa̱ra̱ ta̱ uwauwa a asu u ure u te u na vi, ko an ya baci aꞌa̱ri ko tani ndya baci a yain. ");
INSERT INTO kdlNT_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Ya dem yan ta̱ unyushi u cingi, kpam tsu gusa̱ ta̱ a tsupige tsu Kashila̱. ");
INSERT INTO kdlNT_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Shegai Kashila̱ ka gonuko le ta̱ a wokoi dere a asu u ukuna u shinga u ne u ɗa u nekei gbani. U yan ta̱ nala vi a asu u Yesu Kawauwi, uza ɗa u wutukpa̱ tsu u takpai unyushi u cingi u tsunu. ");
INSERT INTO kdlNT_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Kpaci Kashila̱ ka neke ta̱ Yesu Kawauwi tsa̱ra̱ u takpa mavura ma unyushi u cingi u ama tsa̱ra̱ Kashila̱ ka pana kpam upan u le wa. Kashila̱ ka gonuko ta̱ ama a woko dere a wushuku baci Kawauwi ka wotsongi mpasa n ne, an u nekei uma u ne uɗara̱kpa† adama a le. Kashila̱ uza u ahankuri ɗa kpam u tsu yansa ta̱ ukuna dere. Nala wa̱ri caupa, an bawu u tsu yan ama mavura adama a unyushi u cingi u le. ");
INSERT INTO kdlNT_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Kpam Kashila̱ ka neke ta̱ Yesu tsa̱ra̱ u wenike an u yain ili iꞌya iꞌa̱ri dere. Gogo‑na u gonuko ɗe aza a unyushi u cingi a woko dere a kapala ka ne adama a ɗa a wushuki n Yesu. ");
INSERT INTO kdlNT_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Nala baci, nte kalen ka ara̱ɗi a tsunu? Nte tani ka̱ri! An Kashila̱ ka wusha tsu, adama a ili i shinga iꞌya tsu yain ɗa wa. Adama a upityanangu u tsunu u ɗa. ");
INSERT INTO kdlNT_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Kashila̱ ka gonuko tsu ta̱ tsu wokoi dere a kapala ka ne adama a ɗa tsu wushuki, shegai adama a ɗa tsu tonoi Mele mi u ɗa wa. ");
INSERT INTO kdlNT_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Kashila̱ ka̱ adama a aza a Yahuda koshi ɗa? Aꞌa! Kashila̱ ka̱ ta̱ dem adama a Awulawa. Mayun, ka Awulawa ka dem. ");
INSERT INTO kdlNT_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Kashila̱ ka te ka koshi, kpam ure u te u ɗa koshi u ɗa u tsu wusha ama. U tsu gonuko ta̱ ama a woko dere a kapala ka ne a wushuku baci n eyi. U woko she aza a Yahuda ko Awulawa wa. ");
INSERT INTO kdlNT_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Gogo‑na an tsu tsa̱ra̱i upityanangu, tsu vuta̱la̱ Mele mi ɗa? Ko kenu! Upityanangu u ɗa u zuwa tsu tsu woko ili iꞌya Mele mi ma ciga tsu tsu woko mayun. ");
INSERT INTO kdlNT_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Ndya tsa dana makoshi ma cau ma tsunu Ibirahi† ma rotsongusi a ukuna u upityanangu? ");
INSERT INTO kdlNT_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Kashila̱ ka gonuko yi baci u wokoi dere adama a ili iꞌya u yain, wa tsa̱ra̱ ta̱ ili iꞌya wa yan ara̱ɗi n iꞌya, shegai ure u Kashila̱ wa̱ adama a uyan ili wa. ");
INSERT INTO kdlNT_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Tagara̱da u Kashila̱ u dana ta̱, “Ibirahi wushuku ta̱ n Kashila̱, adama a nala Kashila̱ ka gonuko yi ta̱ u woko vuma u maci.” ");
INSERT INTO kdlNT_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Vuma u yan baci manyan, u ka̱na̱ ta̱ a tsupa yi adama a ili iꞌya u yain. Katsupi ka malen ma manyan ka nala ki kune ku gbani wa. ");
INSERT INTO kdlNT_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Shegai va zuwa Kashila̱ ka gonuko vu vu woko dere adama a ili iꞌya vu yain wa. Kashila̱ ka wusha ta̱ aza a unyushi u cingi adama a ɗa a pityanangi n eyi. ");
INSERT INTO kdlNT_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Dawuda dana ta̱ dem nala an u yain kadyanshi ka ipeli i vuma ɗa Kashila̱ ka wushai tyo