﻿USE sofia;
DROP TABLE IF EXISTS sofia.kdh_vpl;
CREATE TABLE kdh_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kdh_vpl WRITE;
INSERT INTO kdh_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Bɩgabaazɩya, adɛ na ɩsɔ́ɔ́dáá gɛ Ɩsɔ́ɔ waalá. ");
INSERT INTO kdh_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Adɛ nɛ́, kɩlɛ́ kɩvʊnlewáa yéḿ gɛ, nabʊ́rʊ fʊnvɛ́yɩ́ kɩrɔ; bɩka bɩrɩ́ŋa bɩjɔɔ́ɔ temenuú. Ɩsɔ́ɔ-dɛ́ɛ Kezeŋa wɛ́nvɛtɩ kʊ lɩ́m-rɔ. ");
INSERT INTO kdh_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Bɩjɔɔ́ɔ nɛ́, ngɛ Ɩsɔ́ɔ sɩsɩ: «Bɩ́la ɖɛnyɛm,» ngɛ biivu bɩlá bɩlɛ́ ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ngɛ Ɩsɔ́ɔ waana sɩsɩ ɖɛnyɛm cɔɔ́ɔ kazɔ́ɔ. Ngɛ waadára ɖɛnyɛm na temenuú; ");
INSERT INTO kdh_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","ɩyáa ɖɛnyɛm sɩsɩ ɩdaawʊ́, bɩka ɩyáa temenuú sɩsɩ nuvoowú. Ńna gɛ kiiyu kifé. Wɩ́rɛ kaɖaa ńɖɛ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Sɩɩlɛ wɩ́rɛ nɛ́, Ɩsɔ́ɔ sɩsɩ: «Nɛrʊʊ́ ɩ́lɩɩ kɩtára lɩ́m nabʊ́lɛ; nabɩ́rɩ ɩsɔ́ɔ́dáá, nabɩ́rɩ adɛ.» Ngɛ bɩɩlá bɩlɛ́ nɛrʊʊ́ ɩlɩ́ɩ kɩtára lɩ́m nabʊ́lɛ. ");
INSERT INTO kdh_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ngɛ waayáa nɛrʊʊ́ kɩḿ kɩɖɩdáarɛ sɩsɩ ɩsɔ́ɔ́dáá. Ńna gɛ kiiyu kifé. Sɩɩlɛ wɩ́rɛ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Toozo wɩ́rɛ nɛ́, Ɩsɔ́ɔ sɩsɩ: «Adɛ lɩ́m rɩ́ŋa ɩ́bɩsɩ fɔɔlʊʊ́, bɩka adɛ laadɔ́ɔ ɩlɩ́ɩ bánnáa kɛ.» Ngɛ bɩɩlá bɩlɛ́ ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ngɛ waayáa lénlé lɩ́m wɛ nɛ́ sɩsɩ tenkú, bɩka ɩyáa lénlé lɩ́m fɛ́yɩ́ nɛ́ sɩsɩ adɛ laadɔ́ɔ. Ngɛ waana sɩsɩ bɩɩlá kazɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ngɛ Ɩsɔ́ɔ sɩsɩ: «Adɛ laadɔ́ɔ íyele nyɩ́ɩ́dɩ na tɩ́ɩ́nɩ ɩnyɔ kɔrɔɔzɩ́. Nyɩ́ɩ́dɩ ndɩ‑ndɩ na tɩ́ɩ́nɩ ndɩ‑ndɩ ɩ́nyɔ́, báa wentí na tibíya.» Ngɛ biivu bɩlá bɩlɛ́ ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ngɛ adɛ laadɔ́ɔ weeyéle nyɩ́ɩ́dɩ ɩbáázɩ nyɔ́ɔ, báa wentí na tibíya. Tɩ́ɩ́nɩ tɩlɛ́ ɖʊɖɔ bɩlɛ́. Ngɛ Ɩsɔ́ɔ waana sɩsɩ bɩɩlá kazɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ńna gɛ kiiyu kifé, toozo wɩ́rɛ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Naaza wɩ́rɛ nɛ́, Ɩsɔ́ɔ sɩsɩ: «Kpɩná weená ángɔnáa ɖɛnyɛm nɛ́, álɩɩ acɔ́ɔ ɩsɔ́ɔ́dáá; amʊ́ gɛ bánnáa na batɩlɩ́ nuvoowú na ɩdaawʊ́, batɩlɩ́ jíńgáárɩ́wá-dɛ́ɛ sáátɩ, na batɩlɩ́ wɛ́-bíya, na bɩ́ɩ́zɩ. ");
INSERT INTO kdh_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Kpɩná amʊ́ ábɩsɩ fɩtɩ́lawá ɩsɔ́ɔ́dáá bɩka ánnáa adɛ laadɔ́ɔ-rɔ.» Ngɛ bɩɩlá bɩlɛ́ ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Waalá fɩtɩ́lawá kʊ́bɔńdɩ natɩ́lɛ; ɩkpɔ́ɔ kʊ́bɔnbɔńgɩ ɩsɩ́ɩ sɩsɩ kɩlɛ́ kɩ́nnáa kʊ ɩdaawʊ́, bɩka ɩkpɔ́ɔ kúmuukú ɩsɩ́ɩ sɩsɩ kɩlɛ́ kɩ́ná nuvoowú. Ngɛ waadásɩ ɩlá wɩlásɩ ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Waalá kpɩná amʊ́ bɩtɛ́ nɛ́, ngɛ wɔɔgbɔ́ɔ yɛ ɩsɩ́ɩ ɩsɔ́ɔ́dáá sɩsɩ áná adɛ laadɔ́ɔ-rɔ, ");
INSERT INTO kdh_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","abɩ́ɩ́zɩ ánnáa nuvoowú na ɩdaawʊ́, bɩka abɩ́ɩ́zɩ atára temenuú na ɖɛnyɛm. Ngɛ Ɩsɔ́ɔ waana sɩsɩ bɩɩlá kazɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ńna gɛ kiiyu kifé; naaza wɩ́rɛ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Nʊʊwa wɩ́rɛ nɛ́, Ɩsɔ́ɔ sɩsɩ: «Weezíni kpɩná ɩ́la lɩ́m-daá biri‑biri, bɩka siḿsi ɩɖʊ sɩlɩ́ɩ ɩsɔ́ɔ́dáá síngilím.» ");
INSERT INTO kdh_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ngɛ Ɩsɔ́ɔ waalá lɩ́m-daá fanáńdɩ kʊ́bɔńdɩ na kúmuúti ndɩ‑ndɩ, na siḿsi ndɩ‑ndɩ. Ngɛ waana sɩsɩ: bɩɩlá kazɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ngɛ waaɖʊ yɛ alɩbáráka sɩsɩ: «Mɩ́ɩ lɩ́m-daá kpɩná, ɩɖʊ bɩɖɔ́ɔ isu lɩ́m-daá; mɩ́ɩ ɩsɔ́ɔ́dáá kpɩná nɛ́, ɩbɩ́sɩ áɖʊ́ʊ́ráa ɩɖʊ bɩɖɔ́ɔ adɛ laadɔ́ɔ-rɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ńna gɛ kiiyu kifé; nʊʊwa wɩ́rɛ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Loɖo wɩ́rɛ nɛ́, Ɩsɔ́ɔ sɩsɩ: «Adɛ íyele fʊ́ńdɩ kpɩná ndɩ‑ndɩ ɩ́lɩɩ ángilím; bɛɛ ɖaána fʊ́ńdɩ kpɩná, adɛ‑gaalɩɖáa na fanáńdɩ.» Ngɛ bɩɩlá bɩlɛ́ ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Bɩlɛ́ gɛ Ɩsɔ́ɔ waalá fanáńdɩ rɩ́ŋa ndɩ‑ndɩ, ɖaána fʊ́ńdɩ kpɩná ndɩ‑ndɩ, na adɛ‑gaalɩɖáa ɖʊɖɔ. Ngɛ waana sɩsɩ: bɩɩlá kazɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ɩsɔ́ɔ waalá bɩrɩ́ŋa bɩtɛ́ nɛ́, ngɛ sɩsɩ: «Ɖɩ́la ɩrʊ́ ńŋɩnáa ɖɔ́jɔwʊrɛ, ɩlɩ́ɩ ɖáa, bɩka iɖi kowúrátɩ lɩ́m-daá tiiná-rɔ, ɩsɔ́ɔ́dáá siḿsi, na fʊ́ńdɩ kpɩná rɩ́ŋa na adɛ‑gaalɩɖáa-rɔɔzɩ́ adɛ laadɔ́ɔ-rɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ngɛ waama ɩrʊ́ ńŋɩnáa ɩjɔwʊrɛ. Waalá yɩ ɩlɩ́ɩ ńŋɩnáa wenbí ɩmʊ́ Ɩsɔ́ɔ ɩjɔɔ́ɔ nɛ́. Waalá wɛ gɛ alʊ́ na abaalʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ngɛ waaɖʊ wɛ alɩbáráka sɩsɩ: «Mɩ́nlʊrʊ́ʊ bɩlʊ́rʊ isu adɛ laadɔ́ɔ, iɖi kʊ́bɔńdɩ ɖúúlínya-rɔɔzɩ́, iɖi kowúrátɩ lɩ́m-daá tiiná, na ɩsɔ́ɔ́dáá siḿsi, na fʊ́ńdɩ kpɩná rɩ́ŋa ángilím laadɔ́ɔ-rɔɔzɩ́ nɛ́ arɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ngɛ Ɩsɔ́ɔ sɩsɩ: «Ɩbɛ́ɛ, mígíɖíím nɖɔ́: máává mɩ́ɩ nyɩ́ɩ́dɩ rɩ́ŋa-dɛ́ɛ bíya na tɩ́ɩ́nɩ rɩ́ŋa-dɛ́ɛ bíya tʊwɛ adɛ laadɔ́ɔ-rɔɔzɩ́ nɛ́ sɩsɩ ɩ́tɔɔ. ");
INSERT INTO kdh_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Fʊ́ńdɩ kpɩná rɩ́ŋa, na siḿsi na wenbí bɩrɩ́ŋa kpátáá bʊwɛ adɛ laadɔ́ɔ-rɔ bínweezí nɛ́, bɛlɛ́ begíɖíím gɛ nyɩ́ɩ́dɩ.» Ngɛ bɩɩlá bɩlɛ́ ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ɩsɔ́ɔ waana sɩsɩ wenbí bɩrɩ́ŋa kpátáá waalá bɩ nɛ́, bɩɩbá bɩlá kazɔ́ɔ páá. Ńna gɛ kiiyu kifé. Loɖo wɩ́rɛ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Bɩlɛ́ gɛ adɛ na ɩsɔ́ɔ́dáá na wenbí bɩrɩ́ŋa bʊwɛ bɩdaá nɛ́ bɩdɛ́ɛ lám waagʊrɩná. ");
INSERT INTO kdh_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Wɛ́ lʊbɛ wɩ́rɛ nɛ́, ɩdɩmɛ́rɛ wɛ́ńdɛ́ḿ nɛ́, wɛɛvɛ́ɛ́zɩ. ");
INSERT INTO kdh_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ngɛ waaɖʊ lʊbɛ wɩ́rɛ ɖɩḿ alɩbáráka, ɩlá ɖɛ ɖacɩrɩ-cɩrɩ, ɩlɩzɩ́ ɖɛ sɩsɩ ɩmʊ́ ɩdɛ́ɛ wɩ́rɛ nbɩlɛ́; káma, wɩ́rɛ ɖɩḿ gɛ ɩmʊ́ wɛɛdɛ́ ɖúúlínya lám ɩfɛ́ɛ́zɩ. ");
INSERT INTO kdh_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Nŋɩ́nɩ́ Ɩsɔ́ɔ waalá adɛ na ɩsɔ́ɔ́dáá nɛ́ bɩdɛ́ɛ tɔ́m nɖɔ́: Ɩsɔ́ɔ waalá adɛ na ɩsɔ́ɔ́dáá nɛ́, ");
INSERT INTO kdh_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","tɩ́ɩ́nɩ ya, nyɩ́ɩ́dɩ ya, nabʊ́rʊ fɛ́yɩ́ bʊ́nnyɔ́ɔ adɛ laadɔ́ɔ-rɔ; káma, ideyele tá tɛ́ɛ́wʊ ɩnɩ́ɩ, ngʊ́ ɩrʊ́ naárʊ fɛ́yɩ́ sɩ ɩfára. ");
INSERT INTO kdh_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Amá, lɩ́m wángagám kʊ adɛ bɩ́nvʊʊzɩ́ laadɔ́ɔ rɩ́ŋa. ");
INSERT INTO kdh_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Bɩjɔɔ́ɔ nɛ́, ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ waajɩrɩ́ tɛ́ɛ́dɩ ɩma Áɖam; Áɖam kutoluú gɛ sɩsɩ ɩrʊ́. Wɛɛdɛ́ nɛ́, ngɛ woovósi ɩnɩbɔ́ɔ́nɩ-daá ɩɖʊ yɩ weezuú; ńna gɛ Áɖam waabɩ́sɩ ɩrʊ́ weezuú-dʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ɖádʊ́ʊ Ɩsɔ́ɔ waama ɩrʊ́ bɩtɛ́ nɛ́, ngɛ waalá kárɔɔ́ nɛkɛ́rɛ tɛ́ɛ́dɩ bánÿaá tɩ sɩsɩ Edɛ́ɛnɩ nɛ́ tɩdaá; tɛ́ɛ́dɩ tɩḿ tɩgɔwɛ ná wɩ́sɩ ɖaagalɩɩɖɛ́ fáráńdɩ́ gɛ. Ngɛ wɔɔgbɔ́ɔ ɩrʊ́ waalá yɩ nɛ́, ɩsɩ́ɩ kárɔɔ́ kɛḿ kadaá. ");
INSERT INTO kdh_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ weeyéle tɩ́ɩ́nɩ ndɩ‑ndɩ ɩnyɔ kárɔɔ́ kɛḿ kadaá. Tɩ́ɩ́nɩ tɩḿ tɩɩbá tɩjɔɔ́ɔ kazɔ́ɔ bɛɛŋ́, bɩka tibíya ɩbá bɔjɔɔ́ɔ ɩzɩ́bɛ́rɛ tɔwʊ́ʊ. Kɔlɔwʊtáá gɛ weezuú-dɛ́ɛ tɩɩwʊ́ sɩ́ŋɛ́ɛ na kífeńbi na bɩdaavé nɛ́-dɛ́ɛ tɩlɩ́ɩ dɛ́ɛ tɩɩwʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Edɛ́ɛnɩ tɛ́ɛ́dɩ tɩḿ tɩdaá gɛ buwá nɛkɛ́rɛ wéndím kánvʊʊzɩ́ kárɔɔ́ kɛḿ. Kárɔɔ́ kɛḿ kadɩ́ŋa gɛ buwá kɛḿ kaadára nʊ́ʊ́zɩ nasɩ́náázá. ");
INSERT INTO kdh_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Kaɖaa ńga gɛ bánÿaá sɩsɩ Pisɔ́ɔnɩ. Kɛlɛ́ kaalara ná kamɩlɩná laadɔ́ɔ bánÿaá kɛ Havíila, lé bánlɩzɩ́ɩ siká nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Tɛ́ɛ́dɩ tɩḿ tɩdaá siká kɛ́ɛ siká kífenveńgi gɛ; ngɛ cɩrɩ́m bánlanáa bɩ tulaarɩ́ nɛ́, na bɔ́ kífenvená ɖʊɖɔ wɛ ńna. ");
INSERT INTO kdh_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Sɩɩlɛ ńga gɛ bánÿaá sɩsɩ Giyɔ́ɔnɩ. Kɛlɛ́ kaalara ná kamɩlɩná laadɔ́ɔ bánÿaá kɛ Kúusi nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Toozo ńga gɛ Tíigiri; kɛlɛ́ kéndináa kʊ Asúuri tɛ́ɛ́dɩ-dɛ́ɛ wɩ́sɩ ɖaagalɩɩɖɛ́. Naaza ńga gɛ Efɩráatɩ. ");
INSERT INTO kdh_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Tɔ́ɔ, ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ wɔɔgbɔ́ɔ ɩrʊ́ ɩsɩ́ɩ Edɛ́ɛnɩ kárɔɔ́ kɛḿ kadaá sɩsɩ ɩ́bɛɛŋ kɛ, bɩka wánvarɩ́m. ");
INSERT INTO kdh_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ngɛ waabásɩ yɩ sɩsɩ: «Nyánbɩɩzɩ́ ndɔ́ɔ kárɔɔ́ kana kadaá tɩɩwʊ́ báa wenkí-dɛ́ɛ bíya, ");
INSERT INTO kdh_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","amá, tɩɩwʊ́ wenkí ɩrʊ́ wɔ́ndɔwʊ́ʊ kibíya na ɩtɩlɩ́ kífeńbi na bɩdaavé nɛ́, nkɔtɔ́ɔ kibíya; a wɩ́rɛ nyɔ́ɔ́dɔ́ɔ wɛ, nyánzɩ́m.» ");
INSERT INTO kdh_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ɖádʊ́ʊ Ɩsɔ́ɔ wɔɔdɔ́ yɩ bɩlɛ́ bɩtɛ́ nɛ́, ngɛ sɩsɩ: «Bɩdɔmɔɔná ɩrʊ́ cɔɔ́ɔ iriké; mánlám ɩzɩnárʊ weení waalɩ́ɩ yɩ nɛ́ madasɩná yɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ɖádʊ́ʊ Ɩsɔ́ɔ waajɩrɩ́ tɛ́ɛ́dɩ gɛ ɩmaná fʊ́ńdɩ kpɩná rɩ́ŋa na siḿsi rɩ́ŋa. Ngɛ weeyéle kpɩná amʊ́ akɔ́nɩ ɩrʊ́-jɔ́ ɩbɛ́ɛ sɩsɩ yɩrá weená gɛ sɩ ɩfa yɛ. Aadála nɛ́, waayáa kpɩ́nɖɛ báa wenɖé wenbí nɛ́ bɩɩbɩsɩ ná kpɩ́nɖɛ ɖɩḿ ɖɩyɩ́ɖɛ. ");
INSERT INTO kdh_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Na bɩrɩ́ŋa Áɖam waava ɖaána fʊ́ńdɩ kpɩná, na fɔɔ́-daá ńná na siḿsi rɩ́ŋa yɩrá nɛ́, arɩ́ŋa adaá, ɩdana sɩnárʊ weení waalɩ́ɩ yɩ wánbɩɩzɩ́ ɩsɩná yɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ńna gɛ Ɖádʊ́ʊ Ɩsɔ́ɔ weeyéle ɖóm kʊ́bɔńbɩ nabɩ́rɩ ɩkpɔ́ɔ Áɖam. Sáátɩ wenkí wónɖóm nɛ́, ngɛ wɛɛvɛ́ɛ ɩlɩzɩ́ ɩzɩnɖɛ́nɩ kʊ́ɖʊḿ, ɩbɩsɩná sɔ́m ifu bɩcɔ́ɔ bʊjɔwʊrɛ. ");
INSERT INTO kdh_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ngɛ wɔɔgbɔ́ɔ sɩnɖɛ́nɩ ɩmʊ́ iyóózi ɩmaná alʊ́. Wɛɛdɛ́ nɛ́, ngɛ wɔɔgbɔ́ɔ yɩ ikóduuzi abaalʊ́-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ńna gɛ ɩlɛ́ waagʊrʊ́ ɩna bɩlɛ́ nɛ́, ngɛ sɩsɩ: «Ɩhɩ́n, bɛɛ lɛlɛɛɖɔ́ weení mána yɩ ɖámʊ́ʊ́rɛ kʊ́ɖʊńɖɛ, ɖɔ́zɔ́m kʊ́ɖʊńbɩ nɛ́. Sɩ bayáa yɩ gɛ sɩsɩ alʊ́, káma, abaalʊ́-daá gɛ baalɩzɩ́ yɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Bʊrɔɔzɩ́ gɛ abaalʊ́ wánlɩɩ́ ɩgɔɔ na ɩjaa bɔjɔ́ ibó ɩkpɔ́ɔ alʊ́ boyóózi bɔcɔ́ɔ babɩ́sɩ tɔnʊʊ́ kʊ́ɖʊmʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ɩráa bana bɛlɛ́ɛ́nɩ́, tunbóóló gɛ bavʊnjɔɔ́ɔ; bɩka bɩdɛ́ɛ sáátɩ baasɩ fɛɛrɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Fɔɔ́-daá kpɩná rɩ́ŋa Ɖádʊ́ʊ Ɩsɔ́ɔ waalá yɛ nɛ́ adaá, ɖoḿ waagɩlɩ ná lɔ́nɩ. Wɩ́rɛ bɩjɔɔ́ɔ nɛ́, ngɛ ɖoḿ ɩmʊ́ wɔɔdɔ́ alʊ́ ceení sɩsɩ: «Toovonúm Ɩsɔ́ɔ wɔɔdɔ́ mɩ́ɩ sɩsɩ ɩ́kɔtɔ́ɔ kárɔɔ́-daá tɩ́ɩ́nɩ rɩ́ŋa-dɛ́ɛ bíya?» ");
INSERT INTO kdh_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ngɛ ɩlɛ́ woobúsi yɩ sɩsɩ: «Ɩsɔ́ɔ wɔɔdɔ́ ɖáa sɩsɩ ɖɩ́tɔɔ kárɔɔ́-daá tɩ́ɩ́nɩ rɩ́ŋa-dɛ́ɛ bíya, ");
INSERT INTO kdh_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","amá, tɩɩwʊ́ wenkí kɩzɩ́ŋɛ́ɛ kárɔɔ́ lɔwʊtáá nɛ́, ɖɩ́kɔtɔ́ɔ kibíya, ngʊ́ ɖíketekiná; káma, a wɩ́rɛ ɖɔ́ɔ́dɔ́ɔ wɛ, ɖánzɩ́m.» ");
INSERT INTO kdh_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ńna gɛ ɖoḿ ɩmʊ́ wɔɔdɔ́ yɩ sɩsɩ: «Bʊbɔ́tɩ gɛ, mɩ́dánzɩḿ. ");
INSERT INTO kdh_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Amá, Ɩsɔ́ɔ nyɩ sɩsɩ wɩ́rɛ wenɖé sɩ ɩtɔ́ɔ tɩɩwʊ́ kɩḿ kibíya nɛ́, mɩ́ɩ́zá-rɔ wónvulúu, mɩ́nbɩsɩ́ nyazɩ Ɩsɔ́ɔ ɩmʊ́ ɩdɩtɩŋa, ɩtɩlɩ́ kífeńbi na bɩdaavé nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Alʊ́ bɛɛ́na tɩɩwʊ́-bíya nɛ́, waana sɩsɩ baabá bɔjɔɔ́ɔ kazɔ́ɔ tɔwʊ́ʊ, bɔjɔɔ́ɔ kazɔ́ɔ bɛɛŋ́. Ɩbɛɛ́na ɖʊɖɔ sɩsɩ bɩjɔɔ́ɔ kazɔ́ɔ ɩrʊ́ ɩtɔ́ɔ wɛ bɩka waazá-rɔ ifulú. Ngɛ wɔɔgɔrɩ́ ɩtɔ́ɔ, ɩwaalʊ́ sɩ́ŋɛ́ɛ ɩjɔ́ nɛ́, ngɛ weejéle ɩlɛ́ ɖʊɖɔ ɩtɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ńna gɛ bɛlɛ́ɛ́nɩ́ baazá-rɔ woovulú. Ngɛ baadɩlɩ́ sɩsɩ bɔjɔɔ́ɔ tunbóóló. Ngɛ baajáa tɩɩwʊ́ bánÿaá kɩ sɩsɩ figíyée nɛ́-dɛ́ɛ fáádɩ balʊ́ʊ bɔtɔɔ́lɩ. ");
INSERT INTO kdh_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ɖaanɩ́ŋa-rɔ kpátáá bɩlɛ́ gɛ Ɖádʊ́ʊ Ɩsɔ́ɔ wɔɔgɔ́nɩ wéngilím kárɔɔ́-daá. Baanɩ́ɩ ɩdɛ́nɩ nɛ́, ngɛ beeze bamʊ́sɩ tɩ́ɩ́nɩ lɔwʊtáá. ");
INSERT INTO kdh_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ńna gɛ Ɖádʊ́ʊ Ɩsɔ́ɔ wɔɔbɔ́ɔ́zɩ Áɖam sɩsɩ: «Nyɔ́wɛ lé.» ");
INSERT INTO kdh_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ngɛ Áɖam woobúsi sɩsɩ: «Máánɩ́ɩ nyɛ́dɛ́nɩ kárɔɔ́-daá nɛ́ bɩɩlá ma nɩdáárɛ, káma, mɔ́jɔɔ́ɔ tunbóóló; ngɛ méézé mamʊ́sɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ńna gɛ Ɖádʊ́ʊ Ɩsɔ́ɔ sɩsɩ: «Nyáálá nŋɩ́nɩ́ ndɩlɩ́ sɩsɩ nyɔ́jɔɔ́ɔ tunbóóló. Nyɔ́ɔ́dɔ́ɔ tɩɩwʊ́ wenkí méégízíná nya nɛ́ kibíya yáá wé.» ");
INSERT INTO kdh_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ńna gɛ Áɖam sɩsɩ: «Alʊ́ weení nyɔ́ɔ́gɔ́ná yɩ ndasɩná ma nɛ́ weejele ná ma mɔdɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ wɔɔdɔ́ alʊ́ sɩsɩ: «Bɩyáásɩ́ gɛ nyɔ́ɔ́ nyáálá bɩlɛ́.» Ngɛ ɩlɛ́ woobúsi yɩ sɩsɩ: «Ɖoḿ wɔɔgɔnɩ ná itúúli ma mɔdɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ wɔɔdɔ́ ɖoḿ sɩsɩ: «Wenbí nyáálá bɩ ɖɔ́ nɛ́ bʊrɔɔzɩ́, mánlám nya láálɩ́ fʊ́ńdɩ kpɩná rɩ́ŋa-daá. Nyólóódi-rɔ gɛ sɩ ndúu bɩka buuruú wánzʊʊ́ nya báa ngbeére hálɩ nyázɩ́m wɩ́rɛ. ");
INSERT INTO kdh_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Mánɖʊ́ʊ báɖáárɛ nyána alʊ́ mɩ́lɔ́wʊ́táá, mánɖʊ́ʊ ɖɛ ɖʊɖɔ nyógutoluú-dɛ bíya na alʊ́ kutoluú-dɛ bíya bɔlɔwʊtáá. Ɩlɛ́ igutoluú-dɛ bú wɔ́nÿɔ́m nyágʊjʊʊ́, nyɔ́ɔ́ nnyásɩ ɩnʊvɔdóle.» ");
INSERT INTO kdh_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ngɛ wɔɔdɔ́ alʊ́ sɩsɩ: «Mónzuurí fúúzi sɩ nÿɛ́ɛ sɩ nɛ́-dɛ́ɛ wahála; bɩ́nnʊŋásɩ nya na nlʊ́rʊ. Nwaalʊ́ wánlám nya lowú, amá, ɩlɛ́ wénɖíi kʊ́bɔńdɩ nyɔ́rɔ́.» ");
INSERT INTO kdh_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ngɛ wɔɔdɔ́ Áɖam sɩsɩ: «Máávʊ́ńveeri nya sɩsɩ ńkɔtɔ́ɔ tɩɩwʊ́ kɩna kibíya. Ɖé nyáánɩ́ɩ́ná nɖɛɛlʊ́ ndɔ́ɔ wɛ nɛ́, nyɔ́rɔ́ɔ́zɩ́, mánlám adɛ laadɔ́ɔ láálɩ́. Asée nyáázɩ́rɛ wɛ́ńzɛ́ɛ́ naanɩ́ na nÿuú kíɖíím nɖi, hálɩ nyázɩ́m wɩ́rɛ. ");
INSERT INTO kdh_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Nyɩ́ɩ́dɩ tɩtɛ ńdɩ na sɔwá‑sɔwá wánbaazɩ́ nyɔ́ɔ adɛ laadɔ́ɔ-rɔ. Tɩlɔwʊtáá gɛ nyánvarɩ́m na nÿuú nɖi. ");
INSERT INTO kdh_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Asée nyáńláḿ fifíni ití nya na nÿuú kíɖíím, hálɩ bɩtála wɩ́rɛ wenɖé sɩ nbɩ́sɩ tɛ́ɛ́dɩ wentí baajɩrɩ́ bamaná nya nɛ́, káma, nyɛ́gɛ́ɛ tɛ́ɛ́dɩ gɛ, tɩnáábɩ́lɛ́ baajɩrɩ́ bamaná nya, ngɛ tɛ́ɛ́dɩ tɩḿ gɛ sɩ ndɔ́kɔnɩ́ nbɩ́sɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ńna gɛ Áɖam waava ɩɖɛɛlʊ́ yɩ́ɖɛ sɩsɩ Awááwʊ, bugutoluú sɩsɩ weezuú; káma, ɩmʊ́ gɛ wenbá barɩ́ŋa bénweezí nɛ́ bɔgɔɔ. ");
INSERT INTO kdh_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Bɩjɔɔ́ɔ nɛ́, Ɖádʊ́ʊ Ɩsɔ́ɔ waajáa tɔná isúu wɛ. ");
INSERT INTO kdh_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ngɛ wɔɔdɔ́ sɩsɩ: «Lɛlɛɛɖɔ́ nɛ́, ɩrʊ́ waabɩ́sɩ nyazɩ ɖádáá naárʊ nbɩlɛ́, ɩnyɩ kífeńbi na bɩdaavé nɛ́. Bɩlɛ́ nɛ́, ɖíkeyéle ikúti itekiná weezuú tɩɩwʊ́-dɛ́ɛ bíya, káma, a wɔɔdɔ́ɔ wɛ, wónÿuúu weezuú kɩvɛ́yɩ́na tɛ́m nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ wɔɔɖɔ́ɔ yɩ ɩlɩ́ɩ Edɛ́ɛnɩ kárɔɔ́-daá sɩsɩ íbo ɩfára adɛ laadɔ́ɔ wenká baajɩrɩ́ bamaná yɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Sáátɩ wenkí wɔɔɖɔ́ɔ yɩ ɩlɩ́ɩ nɛ́, ngɛ waazɩ́ɩ ɩdɛ́ɛ malááyɩ́kawá fereɖáa bána bɛdɛ́ɛ tókobíwá tínɖée nɛ́ kárɔɔ́ kɛḿ kɛdɛ́ɛ wɩ́sɩ ɖaagalɩɩɖɛ́ sɩsɩ béfere weezuú tɩɩwʊ́ kɩḿ kɩrɔ, na naárʊ ɩ́kabɩ́ɩ́zɩ ɩsʊ́ʊ ɩkɔrɩ́ kibíya. ");
INSERT INTO kdh_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Áɖam na ɩɖɛɛlʊ́ Awááwʊ baadɩlɩ́ ɖamá, ngɛ Awááwʊ wɛɛyɛ́ɛ fuwá ɩlʊ́rʊ bú abaalʊ́. Ngɛ waava yɩ yɩ́ɖɛ sɩsɩ Kááyinu, káma, wɔɔdɔ́ sɩsɩ Ɖádʊ́ʊ Ɩsɔ́ɔ waazɩná ɩmʊ́ iyuú bú abaalʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Bʊwɔ́rɔ́ nɛ́, waadásɩ ɩlʊ́rʊ Kááyinu wɔ́rɔ́ ńnɩ́ abaalʊ́; bánÿaá ɩlɛ́ sɩsɩ Abíilu. Bɛlɛ́ɛ́nɩ́ baabɩ́ɩ nɛ́, Abíilu ɩlɛ́ waabɩ́sɩ fééni ketirú, bɩka Kááyinu ɩlɛ́ ɩgɛ́ɛ faɖʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Bɩjɔɔ́ɔ‑bɩjɔɔ́ɔ nɛ́, wɩ́rɛ, Kááyinu wɔɔgɔ́gɔ́ná wenbí bɩrɩ́ŋa bɩgɛ́ɛ fɔɔ́-daá kíɖíídi nɛ́ ɩlá Ɖádʊ́ʊ Ɩsɔ́ɔ sarɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ngɛ newúu ɩlɛ́ wɔɔgɔ́gɔ́ná ɩdɛ́ɛ fééni-daá bíya kaɖaa ńba bɔjɔɔ́ɔ núm nɛ́ ɩkʊ, ngɛ waalɩzɩ́ núm ɖɩdáarɛ ɩlá Ɩsɔ́ɔ sarɔ́ɔ. Ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ waamʊ newúu ɩ́na ɩdɛ́ɛ sarɔ́ɔ, ");
INSERT INTO kdh_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","bɩka ɩdamʊ Kááyinu na ɩdɛ́ɛ ńga. Ńna gɛ bɩɩwɩ́ɩ́zɩ yɩ, ngɛ waajʊ́ʊ́rɩ. ");
INSERT INTO kdh_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Kááyinu, bɩyáásɩ́ gɛ bɩ́nwɩɩzɩ́ nya hálɩ nyánjʊʊrɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","A nyáálá kazɔ́ɔ, bɩ́nmɔɔnáa nya. A ńdálá kazɔ́ɔ, kidaavééníti cɔɔ́ɔ nyazɩ gúúní nyáɖáḿ wɔnɔɔ́ tɩ́njɔŋ́ sɩ tɩkpa nya. Amá, nyɔ́ɔ́ caarɩ nyádɩ nbɩ́ɩ́zɩ tɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Na bɩrɩ́ŋa Ɖádʊ́ʊ Ɩsɔ́ɔ wɔɔdɔ́ yɩ bɩlɛ́ nɛ́, Kááyinu wɔɔdɔ́ inewú sɩsɩ: «Ɖɩ́lɩɩ.» Sáátɩ wenkí baadála fɔɔ́ lɔwʊ́rɛ nɛ́, ngɛ weegbí inewú ɩkʊ. ");
INSERT INTO kdh_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Bɩɩdásɩ nɛ́, ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Kááyinu, nyénewú wɛ lé.» Ngɛ woobúsi yɩ sɩsɩ: «Máásɩ. Mɔ́ɔ́ mɛ́nbɛɛŋ kʊ ménewú-rɔɔzɩ́ yáá wé.» ");
INSERT INTO kdh_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ sɩsɩ: «We gɛ nyáálá bɩlɛ́. Mááná nyáágʊ́ nyénewú nɛ́, bɩ́nbɔɔzɩ́ kɩvɛrɛwʊ. ");
INSERT INTO kdh_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Sinje tɩ́ŋa, láálɩ́ wéndím nyɔ́rɔ́, adɛ tándanɩɩná nya; káma, nyáágʊ́ nyénewú nbɩ́rɩ ɩdɛ́ɛ azimá kɔrɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","A nyáávára kɔrɔ, kádándalaḿ kíɖíím. Sɩ ngíli yéḿ gɛ, nyɛ́dɛfɛ́yɩ́na ɖaána.» ");
INSERT INTO kdh_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ɖádʊ́ʊ Ɩsɔ́ɔ wɔɔdɔ́ bɩlɛ́ nɛ́, ngɛ Kááyinu woobúsi yɩ sɩsɩ: «Mɛ́dɛ́ɛ nɩgbamʊʊ́ fɔ́m waagɩ́lɩ ma. ");
INSERT INTO kdh_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ába, sinje nyɔ́nɖɔwʊ́ʊ ma tɛ́ɛ́dɩ kazɔ́ɔ ńdɩ-rɔ sɩsɩ mókokúti madɩlɩná nya; málɩɩ méngilím báa lé nɛ́, a naárʊ waana ma, ɩ́dángʊ́ʊ ma?» ");
INSERT INTO kdh_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ woobúsi yɩ sɩsɩ: «A naárʊ waagʊ nya, bɩdɛ́ɛ lʊbɛ gɛ sɩ bɛfɛ́rɛ yɩ.» Ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ waaɖʊ ɖaazɩ́tɩ Kááyinu-rɔɔzɩ́ sɩsɩ a naárʊ waana yɩ ɩ́kakʊ yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ńna gɛ Kááyinu waalɩ́ɩ ɩlaná Ɖádʊ́ʊ Ɩsɔ́ɔ bolíni ɩɖɛ́ɛ Edɛ́ɛnɩ wɩ́sɩ ɖaagalɩɩɖɛ́ fáráńdɩ́ lénlé bánÿaá sɩsɩ Nɔ́ɔdɩ nɛ́ ɩkɔ́jɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kááyinu na ɩɖɛɛlʊ́ baadɩlɩ́ ɖamá, ɩlɛ́ ɩyɛ́ɛ fuwá ɩlʊ́rʊ bú abaalʊ́. Ngɛ baava yɩ yɩ́ɖɛ sɩsɩ Enɔ́ɔkɩ. Bɩjɔɔ́ɔ nɛ́, ngɛ waama hálɩ bɩlá tɛ́ɛ́dɩ; ngɛ wɔɔgbɔ́ɔ ibú Enɔ́ɔkɩ-dɛ́ɛ yɩ́ɖɛ ɩfa tɩ. ");
INSERT INTO kdh_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enɔ́ɔkɩ waabɩ́ɩ ɩkʊrʊ́ ɩlʊ́rʊ Iráadɩ; Iráadɩ ɩlɛ́ ɩkʊrʊ́ ɩlʊ́rʊ Mehuyayɛ́ɛlɩ; Mehuyayɛ́ɛlɩ ɩlɛ́ ɩkʊrʊ́ ɩlʊ́rʊ Metusayɛ́ɛlɩ; Metusayɛ́ɛlɩ ɩlɛ́ ɩkʊrʊ́ ɩlʊ́rʊ Lamɛ́ɛkɩ. ");
INSERT INTO kdh_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamɛ́ɛkɩ waabɩ́ɩ nɛ́, ngɛ ɩlɛ́ wɔɔgbɔ́ɔ aláa nɔɔ́lɛ. Bánÿaá kʊ́bɔnɩ́ sɩsɩ Adáa, kúmuú gɛ Siláa. ");
INSERT INTO kdh_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ngɛ kʊ́bɔnɩ́ waalʊ́rʊ Yabáalɩ. Ɩlɛ́ ɩgɛ́ɛ na kʊ ketiráa bónɖóm bɩsaagɛ́rɛ́ɛ́zɩ-dɛ nɛ́ bajaájaa. ");
INSERT INTO kdh_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yabáalɩ wɔ́rɔ́ gɛ waadásɩ ɩlʊ́rʊ Yubáalɩ. Ɩlɛ́ gɛ cɩmɩ́nɩ ɖuuráa na foyísi fʊlʊɖáa bajaájaa. ");
INSERT INTO kdh_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Alʊ́ kúmuú ɖʊɖɔ waalʊ́rʊ bú abaalʊ́; bánÿaá ɩlɛ́ sɩsɩ Tubáalɩ-Kááyinu. Ɩlɛ́ ɩgɛ́ɛ kóólúu gɛ wónlúm nyɩɩrɩ́tɩ. Ɩwɛná bú aléeré ɖʊɖɔ, bánÿaá ɩlɛ́ sɩsɩ Naamá. ");
INSERT INTO kdh_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Wɩ́rɛ bɩjɔɔ́ɔ nɛ́, Lamɛ́ɛkɩ waabáázɩ yéńdi téédi wénveerím ɩɖɛɛlɩnáa sɩsɩ: «Adáa na Siláa, iwélesi ma cé, mɩ́ɩ Lamɛ́ɛkɩ-dɛ́ɛ aláa, ɩdʊlʊ́ mɩ́nɩgbamɩ́nɩ ɩnɩ́ɩ. Naárʊ waamá ma nɛ́, máágʊ́ yɩ! Bú waaɖʊ ma féézi nɛ́, máágʊ́ yɩ! ");
INSERT INTO kdh_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ɖányɩ bɩlɛ́ sɩsɩ a ɩrʊ́ waagʊ Kááyinu, bʊrɔ lʊbɛ gɛ sɩ bɩfɛ́rɛ yɩ. Sɩ mevééri mɩ́ɩ sɩsɩ weení sɩ ɩkʊ mɔ́ɔ́ Lamɛ́ɛkɩ nɛ́, bʊrɔ niídoozo na saaláa na lʊbɛ (77) gɛ sɩ bɩfɛ́rɛ bʊdʊ́ʊ.» ");
INSERT INTO kdh_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Tɔ́ɔ, Áɖam na ɩɖɛɛlʊ́, bɛlɛ́ baadásɩ balʊ́rʊ bú abaalʊ́. Ngɛ alʊ́ waava yɩ yɩ́ɖɛ sɩsɩ Séti. Káma, wɔɔdɔ́ sɩsɩ: «Kááyinu waagʊ móbú Abíilu nɛ́, Ɩsɔ́ɔ waava ma bú abaalʊ́ mazɩ́ɩ ɩɖɩdáarɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Séti ɩlɛ́ waagʊrʊ́ ɩbɩ́ɩ ɩkpɔ́ɔ alʊ́, balʊ́rʊ bú abaalʊ́, bánÿaá yɩ sɩsɩ Enɔ́ɔsɩ. Tɔ́ɔ, bɩdɛ́ɛ sáátɩ gɛ ɩráa waadábaazɩ Ɖádʊ́ʊ Ɩsɔ́ɔ yɩ́ɖɛ yáádɩ bɛ́nzɛɛ́ yɩ! ");
INSERT INTO kdh_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Áɖam kutoluú-dɛ bíya nɖɔ́: Wɩ́rɛ wenɖé Ɩsɔ́ɔ waalá ɩrʊ́ nɛ́, waalá yɩ gɛ ɩlɩ́ɩ yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Alʊ́ na abaalʊ́ gɛ waalá wɛ. Wɩ́rɛ wenɖé waalá wɛ nɛ́, bɩdɛ́ɛ wɩ́rɛ ɖɩḿ gɛ waaɖʊ wɛ alɩbáráka, ɩfa wɛ yɩ́ɖɛ sɩsɩ ɩráa. ");
INSERT INTO kdh_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Áɖam-dɛ́ɛ bɩ́ɩ́zɩ nɩɩ́nʊ́wá na ákoosaaláa-daá (130) gɛ waalʊ́rʊ bú abaalʊ́ waabá ɩlɩ́ɩ yɩ nɛ́. Ngɛ waava yɩ yɩ́ɖɛ sɩsɩ: Séti. ");
INSERT INTO kdh_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ɩlɛ́ ɩdɛ́ɛ lʊrʊ́ʊ wɔ́rɔ́ nɛ́, waadásɩ ɩlá bɩ́ɩ́zɩ kákpɩ́ɩ́zɩ nasɩ́náázá (800) ɩlʊ́rʊ bíya aláa na abaaláa. ");
INSERT INTO kdh_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Áɖam waalá bɩ́ɩ́zɩ kákpɩ́ɩ́zɩ nasɩ́náázá na nɩɩ́nʊ́wá na ákoosaaláa (930) nɛ́, ngɛ waazɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Séti waalá bɩ́ɩ́zɩ nɩɩ́nʊ́wá na nasʊ́nʊ́wá (105) nɛ́, ngɛ ɩlɛ́ waalʊ́rʊ Enɔ́ɔsɩ. ");
INSERT INTO kdh_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enɔ́ɔsɩ-dɛ́ɛ lʊrʊ́ʊ wɔ́rɔ́ nɛ́, waadásɩ ɩlá bɩ́ɩ́zɩ kákpɩ́ɩ́zɩ nasɩ́náázá na lʊbɛ (807) ɩlʊ́rʊ bíya aláa na abaaláa. ");
INSERT INTO kdh_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Bɩ́ɩ́zɩ kákpɩ́ɩ́zɩ nasɩ́náázá na nɩɩ́nʊ́wá na fuú na nasɩ́lɛ (912) gɛ Séti waalá ɖúúlínya naanɩ́ ɩsɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enɔ́ɔsɩ ɩlɛ́ waalá bɩ́ɩ́zɩ nɩɩ́náázá na saaláa (90) nɛ́, ngɛ waalʊ́rʊ bú abaalʊ́ ɩfa yɩ yɩ́ɖɛ sɩsɩ: Kenáanɩ. ");
INSERT INTO kdh_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kenáanɩ-dɛ́ɛ lʊrʊ́ʊ wɔ́rɔ́ nɛ́, Enɔ́ɔsɩ waadásɩ ɩlá bɩ́ɩ́zɩ kákpɩ́ɩ́zɩ nasɩ́náázá na ákɩzaalʊʊ́ (815) ɩlʊ́rʊ bíya aláa na abaaláa. ");
INSERT INTO kdh_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Bɩ́ɩ́zɩ kákpɩ́ɩ́zɩ nasɩ́náázá na nɩɩ́nʊ́wá na nasʊ́nʊ́wá (905) gɛ waalá ɖúúlínya naanɩ́ ɩsɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenáanɩ ɩlɛ́ waalá bɩ́ɩ́zɩ niídoozo na saaláa (70) nɛ́, ngɛ waalʊ́rʊ bú abaalʊ́ ɩfa yɩ yɩ́ɖɛ sɩsɩ Mahalalɛ́ɛlɩ. ");
INSERT INTO kdh_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mahalalɛ́ɛlɩ-dɛ́ɛ lʊrʊ́ʊ wɔ́rɔ́ nɛ́, Kenáanɩ waadásɩ ɩlá bɩ́ɩ́zɩ kákpɩ́ɩ́zɩ nasɩ́náázá na nɛɛ́lɛ (840) ɩlʊ́rʊ bíya aláa na abaaláa. ");
INSERT INTO kdh_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Bɩ́ɩ́zɩ kákpɩ́ɩ́zɩ nasɩ́náázá na nɩɩ́nʊ́wá na fuú (910) gɛ Kenáanɩ waalá ɖúúlínya naanɩ́ ɩsɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalɛ́ɛlɩ waalá bɩ́ɩ́zɩ niídoozo na nasʊ́nʊ́wá (65) nɛ́, ngɛ waalʊ́rʊ Yarɛ́ɛdɩ. ");
INSERT INTO kdh_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Yarɛ́ɛdɩ-dɛ́ɛ lʊrʊ́ʊ wɔ́rɔ́ nɛ́, Mahalalɛ́ɛlɩ waadásɩ ɩlá bɩ́ɩ́zɩ kákpɩ́ɩ́zɩ nasɩ́náázá na ákoosaaláa (830) ɩlʊ́rʊ bíya aláa na abaaláa. ");
INSERT INTO kdh_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Bɩ́ɩ́zɩ kákpɩ́ɩ́zɩ nasɩ́náázá na nɩɩ́náázá na saaláa na nasʊ́nʊ́wá (895) gɛ Mahalalɛ́ɛlɩ waalá ɖúúlínya naanɩ́ ɩsɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yarɛ́ɛdɩ waalá bɩ́ɩ́zɩ nɩɩ́nʊ́wá na niídoozo na nasɩ́lɛ (162) nɛ́, ngɛ waalʊ́rʊ Enɔ́ɔkɩ. ");
INSERT INTO kdh_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Enɔ́ɔkɩ-dɛ́ɛ lʊrʊ́ʊ wɔ́rɔ́ nɛ́, Yarɛ́ɛdɩ waadásɩ ɩlá bɩ́ɩ́zɩ kákpɩ́ɩ́zɩ nasɩ́náázá (800) ɩlʊ́rʊ bíya aláa na abaaláa. ");
INSERT INTO kdh_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Bɩ́ɩ́zɩ kákpɩ́ɩ́zɩ nasɩ́náázá na nɩɩ́nʊ́wá na niídoozo na nasɩ́lɛ (962) gɛ wɔɔjɔ́ɔ ɖúúlínya naanɩ́ ɩsɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enɔ́ɔkɩ waalá bɩ́ɩ́zɩ niídoozo na nasʊ́nʊ́wá (65) nɛ́, ngɛ waalʊ́rʊ Matusaláa. ");
INSERT INTO kdh_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Matusaláa-dɛ́ɛ lʊrʊ́ʊ wɔ́rɔ́ nɛ́, Enɔ́ɔkɩ woovu Ɩsɔ́ɔ na toovonúm bɩ́ɩ́zɩ kákpaanɩɩ́nʊwá (300) ɩtásɩ ɩlʊ́rʊ bíya aláa na abaaláa. ");
INSERT INTO kdh_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enɔ́ɔkɩ-dɛ́ɛ wɛ́ rɩ́ŋa wɔɔjɔɔná yɛ ɖúúlínya nɛ́ agɛ́ɛ bɩ́ɩ́zɩ kákpaanɩɩ́nʊwá na niídoozo na nasʊ́nʊ́wá (365). ");
INSERT INTO kdh_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Ɩrʊ́ ɩmʊ́ na Ɩsɔ́ɔ bɔɔjɔɔná hálɩ bɔkɔ́nɩ bacáa yɩ bawɩ́ɩ; káma, Ɩsɔ́ɔ waagbáázɩ yɩ ɩjɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matusaláa waalá bɩ́ɩ́zɩ nɩɩ́nʊ́wá na nɩɩ́náázá na lʊbɛ (187) nɛ́, ngɛ waalʊ́rʊ Lamɛ́ɛkɩ. ");
INSERT INTO kdh_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lamɛ́ɛkɩ-dɛ́ɛ lʊrʊ́ʊ wɔ́rɔ́ nɛ́, Matusaláa waadásɩ ɩlá bɩ́ɩ́zɩ kákpɩ́ɩ́zɩ nasúdoozo na nɩɩ́nʊ́wá na nɩɩ́náázá na nasɩ́lɛ (782) ɩlʊ́rʊ bíya aláa na abaaláa. ");
INSERT INTO kdh_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Bɩ́ɩ́zɩ kákpɩ́ɩ́zɩ nasɩ́náázá na nɩɩ́nʊ́wá na niídoozo na kééníré (969) gɛ Matusaláa waalá ɖúúlínya naanɩ́ ɩsɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamɛ́ɛkɩ waalá bɩ́ɩ́zɩ nɩɩ́nʊ́wá na nɩɩ́náázá na nasɩ́lɛ (182) nɛ́, ngɛ waalʊ́rʊ bú abaalʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ngɛ waava yɩ yɩ́ɖɛ sɩsɩ Núhum sɩsɩ ceení ɖɔ́ sɩ ɩfɛɛzɩ ná ɖáa tɩmɛ́ káálɛ ńná ɖánlám yɛ adɛ laadɔ́ɔ Ɖádʊ́ʊ Ɩsɔ́ɔ waalá kɛ láálɩ́ nɛ́ kɔrɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Núhum-dɛ́ɛ lʊrʊ́ʊ wɔ́rɔ́ nɛ́, Lamɛ́ɛkɩ waadásɩ ɩlá bɩ́ɩ́zɩ kákpɩ́ɩ́zɩ nasɩ́lɛ na nɩɩ́nʊ́wá na nɩɩ́náázá na saaláa na nasʊ́nʊ́wá (595) ɩlʊ́rʊ bíya aláa na abaaláa. ");
INSERT INTO kdh_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Bɩ́ɩ́zɩ kákpɩ́ɩ́zɩ nasúdoozo na nɩɩ́nʊ́wá na niídoozo na saaláa na lʊbɛ (777) gɛ Lamɛ́ɛkɩ waalá ɖúúlínya naanɩ́ ɩsɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Núhum ɩlɛ́ waadála bɩ́ɩ́zɩ kákpɩ́ɩ́zɩ nasɩ́lɛ na nɩɩ́nʊ́wá (500) nɛ́, ngɛ waalʊ́rʊ Sɛ́ɛmɩ, Háamɩ, na Yafɛ́ɛtɩ. ");
INSERT INTO kdh_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Sáátɩ wenkí ɩráa waabáázɩ ɖɔɔmɩ́nɩ adɛ laadɔ́ɔ-rɔ ngɛ baalʊ́rʊ bíya aléewá nɛ́, ");
INSERT INTO kdh_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","ɩsɔ́ɔ́dáá ńba wooyuú bana sɩsɩ bíya aléewá bɛḿ bɔjɔɔ́ɔ wɛ kazɔ́ɔ. Ngɛ bɔɔgbɔ́ɔ wɛ babɩ́sɩ bɛɖɛɛlɩnáa. ");
INSERT INTO kdh_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ńna gɛ Ɖádʊ́ʊ Ɩsɔ́ɔ sɩsɩ: «Kezeŋa mááɖʊ́ kɛ ɩrʊ́ nɛ́, kɔ́dɔ́njɔɔná yɩ bɩlɛ́ bɩvɛ́yɩ́na tɛ́m; káma, ɩrʊ́ kɛ́ɛ tɔnʊʊ́ gɛ. Bɩ́ɩ́zɩ sɩ ɩcɔɔná sɩ ɖúúlínya-daá nɛ́, sɩ́dɛ́njɛzɩ́ bɩ́ɩ́zɩ nɩɩ́nʊ́wá na ákoowú (120).» ");
INSERT INTO kdh_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Sáátɩ wenkí ɩsɔ́ɔ́dáá ńba na aléewá booyóózi nɛ́, ɩráa gáátʊwá gɛ baalʊ́rʊ; ɩráa bɛḿ bɔɔjɔ́ɔ adɛ laadɔ́ɔ-rɔ. Ɖoo caanawʊ́ nɛ́, ɩráa fɩ́ya ńba wenbá bayɩrá wɛɛzɛ́ɛ nɛ́ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ɖádʊ́ʊ Ɩsɔ́ɔ wɔɔgɔ́nɩ ɩna sɩsɩ ɩráa-dɛ́ɛ kidaavééníti bamáa bʊ́ʊ kpáa ɖúúlínya-daá; bɩka báa sáátɩ wenkí, tɩtɛ lomaazɛ́ riké gɛ bewenbé-daá nɛ́; ");
INSERT INTO kdh_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","ngɛ bɩɩjáárɩ yɩ waalá ɩrʊ́ ɩsɩ́ɩ adɛ laadɔ́ɔ-rɔ nɛ́. Bɩɩbá bɩkʊ́sɩ ɩlaakáarɩ. ");
INSERT INTO kdh_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ngɛ sɩsɩ ɩmʊ́ wónnuudí ɩráa waalá wɛ adɛ laadɔ́ɔ-rɔ nɛ́ barɩ́ŋa páyɩ́. Bɩkpɛdɩ́na fʊ́ńdɩ kpɩná kʊ́bɔná na kúmuwé, na siḿsi, kigbeemásɩ na adɛ‑gaalɩɖáa. Káma, baagʊ́sɩ ɩmʊ́ ɩlaakáarɩ. ");
INSERT INTO kdh_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Amá, Núhum wooyuú kʊnyɔnnɩɩrɛ́ Ɩsɔ́ɔ-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Núhum kutoluú-dɛ bíya-dɛ́ɛ tɔ́m nɖɔ́: Núhum-dɛ́ɛ sáátɩ-daá, ɩmʊ́ ɩba ná ɩgɛ́ɛ ɩrʊ́ ɩzɩɩzɛ́ɛ bádánnaná yɩ natɩ́rɩ tɩdakazɔ́ɔ nɛ́, bɩka ivóo Ɩsɔ́ɔ na toovonúm. ");
INSERT INTO kdh_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Ngɛ waalʊ́rʊ bíya noódoozo: Sɛ́ɛmɩ, Háamɩ na Yafɛ́ɛtɩ. ");
INSERT INTO kdh_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","Ɩsɔ́ɔ waana sɩsɩ ɖúúlínya wɔɔvɔrɔ́sɩ; kidaavééníti waagɩ́lɩ ɖɔɔmɩ́nɩ: bɛɛ tɩtɛ lakásɩ, kánnyáádɩ, na yóóni. Ɖúúlínya-daá ɩráa rɩ́ŋa kpátáá wánlám kʊ bɩlakásɩ. ");
INSERT INTO kdh_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Waana bɩlɛ́ nɛ́, ngɛ wɔɔdɔ́ Núhum sɩsɩ: «Wenbí bɩrɩ́ŋa bínweezí adɛ laadɔ́ɔ-rɔ nɛ́ bɩdɛ́ɛ kʊʊrɩ́ waadála; káma, ɩráa-rɔɔzɩ́ gɛ kánnyáádɩ woozu ɖúúlínya. Mɔ́zɔɔlɛ́ɛ sɩ monúúdi bɩrɩ́ŋa bɩ́na adɛ laadɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Bɩlɛ́ nɛ́, nyɔ́ɔ́ ka nyádɩ mɛ́ɛ́lɛ kʊ́bɔńgɩ. A sɩ ngá kɩ, caa tɩɩwʊ́ kɩdɛ́ɛ cɩrɩ́m cɔɔ́ɔ kéti‑kéti nɛ́ nganá kɩ. A nyángám kɩ, nlɩzɩ́ ɖamɩ́nɩ ndɩ‑ndɩ kɩdaá; na ndíi kɩdaá na kɩwɔ́rɔ́ aŋɔ. ");
INSERT INTO kdh_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Kɩbɩɩzɩ́nɩ ɩtála nʊ́ʊ́zɩ kákpaanɩɩ́nʊwá (300), kɩwaláázɩ: nʊ́ʊ́zɩ nɛɛ́saaláa (50), kuworáázɩ: nʊ́ʊ́zɩ ákoosaaláa (30). ");
INSERT INTO kdh_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","A nyáágá kɩ bɩtɛ́ gɛ sɩ nlɔ́ kɩ, nga lɔ́tɩ na koláázɩ bɔlɔwʊtáá fotoolo nyazɩ nʊ́ʊ́nɩ bɩɩzɩ́nɩ bɩlɛ́; nga ɖaḿ wɔnɔɔ́ fɔɔlʊʊ́ nakɩ́rɩ-rɔ; ngá kɩdaá bísa natúdoozo. ");
INSERT INTO kdh_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","A nyáágbɩ́ɩ́rɩ bɩtɛ́, mɔ́ɔ́ ménÿelíi lɩ́m kʊ́bɔńbɩ isu adɛ laadɔ́ɔ rɩ́ŋa-rɔɔzɩ́ bɩkʊ wenbí bɩrɩ́ŋa bínweezí nɛ́; bɩrɩ́ŋa kpátáá bɩ́nzɩ́m. ");
INSERT INTO kdh_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Amá, mɔ́nɖɔkɩ́ mána nya ɖávʊ́ndɛ́ɛ keɖiyá; mɔ́ɔ́ mɛ́nlɛɛ́ nya. Nyánzʊʊ́ mɛ́ɛ́lɛ-daá nyána nɖɛɛlʊ́ na nbiyaalɩnáa na bɛɖɛɛlɩnáa. ");
INSERT INTO kdh_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Bɩka nzʊ́ʊ́zɩ fʊ́ńdɩ kpɩ́nɖɛ báa wenɖé ɖɩdɛ́ɛ alʊ́ na abaalʊ́: wenbí bɩɩlá ɖaána na fɔɔ́-daá fʊ́ńdɩ kpɩná ndɩ‑ndɩ, siḿsi ndɩ‑ndɩ, kigbeemásɩ ndɩ‑ndɩ, na adɛ‑gaalɩɖáa ndɩ‑ndɩ nɛ́ mɛlɛ́ɛ alɛ́. Kpɩná amʊ́ arɩ́ŋa ángɔnɩ kʊ amɔɔná nya na bʊcɔ ayuú weezuú. ");
INSERT INTO kdh_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Bɩlɛ́ nɛ́, fʊnjaa mɩ́rɩ́ŋa mígíɖíídi nzɩ́ɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ngɛ toovonúm, Núhum waalá wenbí bɩrɩ́ŋa Ɩsɔ́ɔ weevééri yɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ wɔɔdɔ́ Núhum sɩsɩ: «Núhum, kpɩɩrɩ nyána nyɛ́dɛ́ɛ zamɔ́ɔ ɩsʊ́ʊ mɛ́ɛ́lɛ-daá; káma, mɛ́ɛ́bɛ́ɛ nɛ́, hálɩ na sinje, nyɛ́dɛ́ɛ sáátɩ ɩráa rɩ́ŋa-daá, nyériké nyázɩ́ɩ́zɛ́ɛ na kʊ máázá-daá. ");
INSERT INTO kdh_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","A sɩ nzʊ́ʊ, kpɛdɩ́na fʊ́ńdɩ kpɩná bánlanáa yɛ sarásɩ nɛ́ adɛ́ɛ aláa na abaaláa lʊbɛ-lʊbɛ; weená adɛkɛ́ɛ sarásɩ ńná nɛ́, alʊ́ na abaalʊ́ kʊ́ɖʊńɖɛ‑kʊ́ɖʊńɖɛ; ");
INSERT INTO kdh_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","bɩɩga siḿsi nɛ́, kpɔɔ sɩlɛ́ ɖʊɖɔ sɩdɛ́ɛ aláa na abaaláa lʊbɛ-lʊbɛ, na bʊcɔ báa kpɩ́nɖɛ wenɖé-dɛ́ɛ kutoluú ɩcɔ́ɔ adɛ laadɔ́ɔ-rɔ. ");
INSERT INTO kdh_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Sinje bɩɩga wɛ́ lʊbɛ, ménÿelíi tɛ́ɛ́wʊ ɩnɩ́ɩ wɛ́ nɛɛ́lɛ nuvoowú na ɩdaawʊ́, bɩlɛ́ gɛ sɩ malá na monúúdi weezíni-dɩnáa rɩ́ŋa máálá wɛ adɛ laadɔ́ɔ-rɔ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ngɛ Núhum waalá wenbí Ɖádʊ́ʊ Ɩsɔ́ɔ wɔɔdɔ́ yɩ nɛ́ nɔ́ɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Tɛ́ɛ́wʊ waabáázɩ nɩ́ɩ́dɩ wɩ́rɛ wenɖé bɩlɛ́ nɛ́, Núhum-dɛ́ɛ bɩ́ɩ́zɩ kákpɩ́ɩ́zɩ nasúdoozo (600) nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Na lɩ́m íkeɖi wɛ nɛ́, mɛ́ɛ́lɛ-daá gɛ ɩ́na ɩɖɛɛlʊ́ na ibíya na bɛɖɛɛlɩnáa baazʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Fʊ́ńdɩ kpɩná ɖʊɖɔ: weená bánlanáa yɛ sarásɩ nɛ́, na weená bádánlaná yɛ nɛ́, siḿsi, kigbeemásɩ na adɛ‑gaalɩɖáa, arɩ́ŋa bɩlɛ́, ná-náálɛ gɛ aagɔ́nɩ báa wenɖé na ɖɩɖɛɛlʊ́ asʊ́ʊ ńŋɩnáa Ɩsɔ́ɔ wɔɔdɔ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","11","Biizúlu wɛ́ lʊbɛ nɛ́, ngɛ lɩ́m bʊwɛ adɛ nɛ́, bɩɩbáázɩ kagám, ngɛ tɛ́ɛ́wʊ waabáázɩ nɩɩ́. Núhum-dɛ́ɛ bɩ́nɩ kákpɩ́ɩ́zɩ nasúdoozo ńnɩ́ wɔ́rɔ́ irodúu sɩɩlɛ ńnɩ́-dɛ́ɛ wɛ́ ákɩzaalʊʊ́ na náálɛ wɩ́rɛ gɛ lɩ́m waabáázɩ kagám adɛ bɩka ɩsɔ́ɔ́dáá ńbɩ ɖʊɖɔ ɩkádʊ́lʊ́ bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ngɛ tɛ́ɛ́wʊ kɩḿ kɩɩnɩ́ɩ nuvoowú na ɩdaawʊ́ hálɩ wɛ́ nɛɛ́lɛ. ");
INSERT INTO kdh_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Tɛ́ɛ́wʊ baazɩ́ nɩɩ́ wɩ́rɛ gɛ Núhum na ɩɖɛɛlʊ́ na ibiyaalɩnáa Sɛ́ɛmɩ, Háamɩ na Yafɛ́ɛtɩ na iwoolináa toozóóní ");
INSERT INTO kdh_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","na fɔɔ́-daá fʊ́ńdɩ kpɩná ndɩ‑ndɩ; ɖaána ńná ndɩ‑ndɩ, siḿsi ndɩ‑ndɩ, kigbeemásɩ ndɩ‑ndɩ na adɛ‑gaalɩɖáa ndɩ‑ndɩ baazʊ́ʊ mɛ́ɛ́lɛ-daá. ");
INSERT INTO kdh_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Kpɩná amʊ́ sɩ asʊ́ʊ nɛ́, nánnáálɛ gɛ aazʊ́ʊ Núhum-jɔ́; ");
INSERT INTO kdh_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","báa wenɖé-dɛ́ɛ alʊ́ na abaalʊ́, ńŋɩnáa wenbí Ɩsɔ́ɔ waavʊ́ńdɔḿ Núhum nɛ́. Baazʊ́ʊ bɩtɛ́ nɛ́, ngɛ Ɖádʊ́ʊ wɔɔdɔ tará bɔrɔ. ");
INSERT INTO kdh_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Lɩ́m bamáa súu adɛ laadɔ́ɔ-rɔ hálɩ wɛ́ nɛɛ́lɛ. Sáátɩ wenkí biizu bɩkpa ɩsɔ́ɔ́dáá nɛ́, ngɛ bɩɩgbáázɩ mɛ́ɛ́lɛ kʊ́bɔńgɩ kɩḿ kɩdɛlɛndɛ́ɛ lɩ́m-rɔ. ");
INSERT INTO kdh_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Lɩ́m wɛ bɩbamáa kpáa hálɩ mɛ́ɛ́lɛ ibulú ɖɛɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Lɩ́m waagba gɛ bɩwáálɩ bʊ́ʊ́nɩ tiiwóro nɛ́ tɩrɩ́ŋa tɩrɔ ɖúúlínya rɩ́ŋa-daá. ");
INSERT INTO kdh_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Bukúti bisu bɩfɛ́lɛ tɩ nyazɩ nʊ́ʊ́zɩ ákɩzaalʊʊ́ bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","23","Tɔ́ɔ, bɩlɛ́ gɛ Ɩsɔ́ɔ waalá inúúdi wenbí bɩrɩ́ŋa bʊwɛ adɛ laadɔ́ɔ-rɔ bínweezí nɛ́: bɩɩlá bɩ ɩráa, ɖaána na fɔɔ́-daá fʊ́ńdɩ kpɩná, siḿsi, adɛ‑gaalɩɖáa; bɩdaka nabʊ́rʊ. Wenbí bɩrɩ́ŋa kpátáá bʊwɛ adɛ laadɔ́ɔ-rɔ bínweezí nɛ́, bɩrɩ́ŋa bɩɩzɩ́. Asée Núhum na ɩdɛ́ɛ ńba na wenbí bɩrɩ́ŋa bʊwɛ mɛ́ɛ́lɛ-daá nɛ́ beriké gɛ bɩɩga weezíni-dɩnáa. ");
INSERT INTO kdh_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ngɛ lɩ́m waagba bɩwáálɩ adɛ laadɔ́ɔ-rɔ bɩlɛ́ hálɩ wɛ́-bíya nɩɩ́nʊ́wá na nɛɛ́saaláa (150). ");
INSERT INTO kdh_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ɩsɔ́ɔ tɔɔzɛ́ɛ Núhum na ɩdɛ́ɛ ńba na fʊ́ńdɩ kpɩná ɩ́na yɛ bɔwɛ mɛ́ɛ́lɛ-daá nɛ́ bɔrɔɔzɩ́. Bɩjɔɔ́ɔ nɛ́, ngɛ weeyéle fefelimá ɩbáázɩ fɛtɩ́ adɛ laadɔ́ɔ-rɔɔzɩ́, ngɛ lɩ́m waabáázɩ tʊʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Adɛ lɩ́m weeyéle kagám; ɩsɔ́ɔ́dáá ńbɩ iyéle kedím, tɛ́ɛ́wʊ ɩcɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ngɛ lɩ́m waabáázɩ sɔɔ́ cʊ́kɔ-cʊ́kɔ. Wɛ́ nɩɩ́nʊ́wá na nɛɛ́saaláa (150) gɛ lɩ́m wɔɔgbɔ́ɔ bʊsɔ́ɔ bití. ");
INSERT INTO kdh_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Bɩka irodúu lʊbɛ ńnɩ́-dɛ́ɛ wɛ́ ákɩzaalʊʊ́ na náálɛ wɩ́rɛ gɛ mɛ́ɛ́lɛ kʊ́bɔńgɩ kɩḿ kiidí kɩcɔ́ɔ Araráatɩ-dɛ́ɛ bʊ́ʊ́nɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Lɩ́m bamáa sɔɔ́ bɩlɛ́ hálɩ irodúu fuú ńnɩ́. Irodúu ɩmʊ́ ɩdɛ́ɛ wɩ́rɛ kaɖaa ńɖɛ gɛ bʊ́ʊ́nɩ kʊjʊ́nɩ waabáázɩ losí. ");
INSERT INTO kdh_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Bɩɩlá wɛ́ nɛɛ́lɛ nɛ́, ngɛ Núhum waadʊlʊ́ tókóró waalá kɩ nɛ́, ");
INSERT INTO kdh_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ɩlɩzɩ́ ŋɔ́ɔŋɔ́ɔ́wʊ ɩtálɩ. Kɩlɛ́ kiibó kɩkábɩ́sɩ kɩɖamáa sɩsɩ lɩ́m ɩsɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Bɩjɔɔ́ɔ nɛ́, ngɛ waadálɩzɩ́ ɖuvóóre kʊ́fʊlʊńɖɛ ɩtálɩ ɩbɛ́ɛ sɩsɩ lɩ́m waadʊʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ɖɩɩɖɛ́ɛ nɛ́, ɖɩdakáná ɖaazomɖɛ́; ngɛ ɖiizúu ɖɩkábɩsɩ Núhum-jɔ́, ngɛ ɩlɛ́ woodóózi ɩnʊ́ʊ́nɩ ɩmʊ ɖɛ ɩsʊ́ʊ́zɩ mɛ́ɛ́lɛ-daá, káma, lɩ́m tɛɛzɩzuurée. ");
INSERT INTO kdh_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ngɛ weeyéle bɩlá wɛ́ lʊbɛ gɛ waadálɩzɩ́ ɖɛ ɩtálɩ. ");
INSERT INTO kdh_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ɖɩɩɖɛ́ɛ nɛ́, hálɩ ɖaanɩ́ŋa-rɔ gɛ ɖɩɩgábɩsɩ. Ɖɩɩgɔ́nɩ nɛ́, tɩɩwʊ́ bánÿaá kɩ olivíyée nɛ́-dɛ́ɛ faawʊ́yɔ́ɔ kadʊ́ʊ na ɖɩnjʊ́ʊ́rɛ. Ńna gɛ Núhum waadɩlɩ́ sɩsɩ lɩ́m waadásɩ bɩtʊʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ngɛ weeyéle bɩtálaḿ wɛ́ lʊbɛ ɖʊɖɔ gɛ waadátalɩ ɖɛ. Ɖɩɩjáŋ ɖɩɖɛ́ɛ nɛ́, ɖidokúti ɖɩkábɩsɩ. ");
INSERT INTO kdh_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Bɩ́nɩ weení Núhum wooyuú bɩ́ɩ́zɩ kákpɩ́ɩ́zɩ nasúdoozo na nɛkɛ́rɛ (601) nɛ́-dɛ́ɛ kááɖɛ wɩ́rɛ gɛ lɩ́m wɔɔzɔ́ɔ adɛ. Ngɛ Núhum woovulú mɛ́ɛ́lɛ-dɛ́ɛ ɩsɔ́ɔ́dáá, iwííli ɩbɛ́ɛ adɛ; wɛɛbɛ́ɛ nɛ́, adɛ bamáa wɩlɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Bɩbɩ́nɩ ɩmʊ́ ɩdɛ́ɛ irodúu sɩɩlɛ ńnɩ́-dɛ́ɛ wɛ́ ákoowú na lʊbɛ (27) wɩ́rɛ gɛ adɛ wɛɛdɛ́ɛ́zɩ wɩlɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ngɛ Ɩsɔ́ɔ wɔɔdɔ́ Núhum sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«Nyána nɖɛɛlʊ́ na nyébíya na nwoolináa, ɩlɩ́ɩ mɛ́ɛ́lɛ-daá, ");
INSERT INTO kdh_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","nÿéle kpɩná nyána yɛ mɩ́ɩ́zʊ́ʊ mɛ́ɛ́lɛ-daá nɛ́ arɩ́ŋa alɩ́ɩ ɖʊɖɔ. A aalɩ́ɩ, nÿéle yɛ aya ɖamá aɖʊ bɩɖɔ́ɔ adɛ laadɔ́ɔ rɩ́ŋa-rɔɔzɩ́.» ");
INSERT INTO kdh_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ngɛ ɩ́na ibiyaalɩnáa, ɩɖɛɛlʊ́ na iwoolináa baalɩ́ɩ; ");
INSERT INTO kdh_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","kpɩná báa weená na agoobíya ifu ɖamá ɖʊɖɔ alɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Baalɩ́ɩ bɩtɛ́ nɛ́, ngɛ Núhum waama sarɔ́ɔ ɖaalanɖɛ́ sɩ ɩlá Ɖádʊ́ʊ Ɩsɔ́ɔ sarɔ́ɔ. Waama bɩtɛ́ nɛ́, ngɛ waalɩzɩ́ fʊ́ńdɩ kpɩná bánlanáa yɛ sarásɩ nɛ́ rɩ́ŋa-daá naárɛ; ɩlɩzɩ́ siḿsi bánlanáa sɩ sarásɩ nɛ́ rɩ́ŋa-daá nasɩ́rɩ ɩkʊ iyóózi bɩrɩ́ŋa iboná ɩtɩ́nɩ sarɔ́ɔ ɖaalanɖɛ́ ńnaamʊ́ ɩlá yɩ sarɔ́ɔ bɩcáŋ biɖe bɩnyɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Sarɔ́ɔ kɛngɛ́ kɛdɛ́ɛ aŋmaala woovóóri bɩsʊ́ʊ Ɖádʊ́ʊ Ɩsɔ́ɔ. Bɩɩzʊ́ʊ yɩ bɩlɛ́ nɛ́, ngɛ ɩlɛ́ wɔɔdɔ́ ɩdaá sɩsɩ: «Sinje tɩ́ŋa, mádándatɩŋɩná ɩrʊ́ malá adɛ laadɔ́ɔ láálɩ́. Toovonúm, ɩrʊ́-dɛ́ɛ afobire kaɖaa gɛ ɩdɛ́ɛ tɩtɛ lomaazɛ́ wángabaazɩ́ iwenbiré-daá. Sinje tɩ́ŋa, mádándakʊ́ʊ wenbí bɩrɩ́ŋa bínweezí adɛ laadɔ́ɔ-rɔ ńŋɩnáa wenbí máálá bɩ ɖɔ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","A ɖúúlínya takʊrʊ́ kʊwɛ, wenbí sɩ bɩcɔ́ɔ bilééri ɖʊɖɔ nɛ́ nɖɔ́: Kíɖíídi ɖúúdi na tɩlɩzɩ́ɩ, ɖokpowu na kaanɩŋá, yoolimá na lʊngʊrɛ́, nuvoowú na ɩdaawʊ́.» ");
INSERT INTO kdh_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ngɛ Ɩsɔ́ɔ waaɖʊ Núhum na ibiyaalɩnáa alɩbáráka sɩsɩ: «Mɩ́nlʊrʊ́ʊ bisu adɛ laadɔ́ɔ-rɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Kpɔɔ lɛlɛɛɖɔ́ hálɩ nɖɛ́ɛ, fʊ́ńdɩ kpɩná rɩ́ŋa, adɛ‑gaalɩɖáa na tiiná wánnɩɩ́ mɩ́nɩdáárɛ adɛ laadɔ́ɔ-rɔ. Mɩ́nbɩɩzɩ́ ɩlaná yɛ wenbí bɩrɩ́ŋa mɩ́zɔɔlɛ́ɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ńŋɩnáa wenbí máávʊ́ńváa mɩ́ɩ kíɖíídi tɩ́nnyɔ́ɔ adɛ nɛ́, lɛlɛɛɖɔ́ máává mɩ́ɩ kpɩná rɩ́ŋa weená ánweezí nɛ́ sɩsɩ ɩ́tɔɔ. ");
INSERT INTO kdh_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Amá, mɩ́dɔ́ndɔwʊ́ sɔ́m na bɩdɛ́ɛ azimá; káma, weezuú wɛ azimá-daá gɛ. ");
INSERT INTO kdh_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Mɩ́nyɔ́ɔ́ ɖʊɖɔ mɩ́dɛ́ɛ azimá kɛ́ɛ na míweezuú. A fʊ́ńdɩ kpɩ́nɖɛ waagʊ ɩrʊ́, mɔ́ngɔbɔɔzɩ́ ɖɛ tɔ́m; bɩlɛ́ ɖʊɖɔ gɛ sɩ mɔgɔ́bɔɔzɩ ɩrʊ́ weení ɩrɩ́ŋa waagʊ ɩrɔwʊ́ nɛ́ tɔ́m. ");
INSERT INTO kdh_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","A ɩrʊ́ waagʊ ɩrɔwʊ́, ɩrʊ́ ɖʊɖɔ sɩ ɩkʊ ná yɩ ɩfɛ́rɛ. Káma, Ɩsɔ́ɔ waalá ɩrʊ́ gɛ ɩlɩ́ɩ ɩmʊ́ Ɩsɔ́ɔ ɩdɩtɩŋa. ");
INSERT INTO kdh_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Bɩɩga mɩ́nyɔ́ɔ́ nɛ́, ɩlʊ́rʊ bɩɖɔ́ɔ isu adɛ laadɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ngɛ Ɩsɔ́ɔ waadásɩ ɩtɔ́ wɛ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«Mɔ́nɖɔkɩ́ mávʊ́ndɛ́ɛ keɖiyá mána mɩ́ɩ, na míbíya, na míbíya-bíya, ");
INSERT INTO kdh_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","bɩkpɛdɩ́na weezíni kpɩná weená mɩ́na yɛ nɛ́, bɩɩlá bɩ siḿsi, ɖaána na fɔɔ́-daá fʊ́ńdɩ kpɩná; wenbí bɩrɩ́ŋa bínweezí mɩ́na bɩ mɩ́ɩ́lɩ́ɩ mɛ́ɛ́lɛ-daá nɛ́, na weená sɩ bɩkɔ́nɩ bʊɖʊ yɛ bʊwɔ́rɔ́-bʊwɔ́rɔ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Mɔ́nɖɔkɩ́ ɖɛ́dɛ́ɛ keɖiyá kɛḿ; sinje tɩ́ŋa, lɩ́m kʊ́bɔńbɩ tóndosúu bɩfɔrɔ́sɩ adɛ laadɔ́ɔ, yáá bɩkʊ weezíni-dɩnáa rɩ́ŋa bɔwɛ kɔrɔ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ngɛ sɩsɩ: «Ɖaazɩ́tɩ sɩ tɩwɩ́lɩ mɛ́dɛ́ɛ keɖiyá mána mɩ́ɩ, na múgutoluú-dɛ bíya na weezíni kpɩná mɩ́na yɛ na weená sɩ akɔ́nɩ akájɔɔ bʊwɔ́rɔ́-bʊwɔ́rɔ́ nɛ́ nɖɔ́: ");
INSERT INTO kdh_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","mónbuú mɔ́dɔ́ɔ́wʊ ŋmɩ́ńdɩ-daá ɩsɔ́ɔ́dáá, kɩ́nwɩlɩ́ɩ kʊ keɖiyá kɔwɛ mána ɖúúlínya ɖɔ́lɔ́wʊ́táá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","A mééyéle ŋmɩ́ńdɩ ibirí ɩsɔ́ɔ́dáá gɛ boolósi kééwúré, ");
INSERT INTO kdh_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","sɩ kɩtɔɔzɩ ná ma mána mɩ́ɩ na weezíni kpɩná ɖɛ́dɛ́ɛ keɖiyá-rɔɔzɩ́. Lɩ́m kʊ́bɔńbɩ tɛfɛ́yɩ́ bínzúu bɩkʊ weezíni-dɩnáa rɩ́ŋa adɛ laadɔ́ɔ-rɔ. ");
INSERT INTO kdh_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Kééwúré ɖɩḿ gɛ mánnáa na mɔ́ńdɔ́rɔdɔ́ɔ́zɩ́ keɖiyá kɔwɛ mána wenbí bɩrɩ́ŋa bʊwɛ adɛ laadɔ́ɔ-rɔ bínweezí nɛ́ ɖɔ́lɔ́wʊ́táá nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Bɩlɛ́ gɛ Ɩsɔ́ɔ weevééri Núhum sɩsɩ: kééwúré ɖɩḿ gɛ mɛ́dɛ́ɛ keɖiyá kɛḿ kɛdɛ́ɛ ɖaazɩ́tɩ. ");
INSERT INTO kdh_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Núhum-dɛ́ɛ bíya baalɩ́ɩ mɛ́ɛ́lɛ-daá nɛ́ nɖɔ́: Sɛ́ɛmɩ, Háamɩ na Yafɛ́ɛtɩ. Háamɩ ɩlɛ́ waalʊrʊ ná Kanáanɩ. ");
INSERT INTO kdh_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Núhum-dɛ́ɛ bíya toozóóní waalʊ́rʊ wɛ nɛ́ nbɩlɛ́; baajáŋ bɛdɛ́ɛ lʊrʊ́ʊ-daá gɛ bɩɩlʊ́rʊ bɩlʊ́rʊ busuná ɖúúlínya laadɔ́ɔ rɩ́ŋa. ");
INSERT INTO kdh_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Bɩjɔɔ́ɔ nɛ́, Núhum waabáázɩ farɩ́m, waaɖaaná tiyɔ́ɔ bánÿaá kɛ víinyi bánlanáa kebíya sʊlʊ́m nɛ́ sɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Wɩ́rɛ nɛ́, ngɛ waabá ɩnyɔ́ɔ sʊlʊ́m ɩfɔ́ɔ. Sʊlʊ́m bɩḿ bɩdɛ́ɛ yɩ ɖɛɛzɩ́-daá gɛ waazʊ́ʊ ɩdɛ́ɛ bɩsaagɛ́rɛ́ŋɛ-dɛ ibúti ɩgbɩná rɩ́ŋa ɩlɔ bɩka yɩ tunbóóló ilewáa. ");
INSERT INTO kdh_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ilewáa tunbóóló bɩlɛ́ gɛ, Kanáanɩ ɩjaa Háamɩ waagázʊʊ ɩmɔɔná yɩ. Waana bɩlɛ́ nɛ́, ngɛ woozúu ɩbɩ́sɩ ikéveeri igoobíya baaganáa lɛ́ɛ́nɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Bɛlɛ́ baanɩ́ɩ bɩlɛ́ nɛ́, ngɛ baajáa kpáyɩ kʊ́bɔńgɩ nakɩ́rɩ, batɩ́nɩ bavaamɩ́nɩ-rɔ, bɩka bánnʊŋnáa bɔwɔ́rɔ́-bɔwɔ́rɔ́, hálɩ batála bajaa-jɔ́ bofu yɩ kɩ. Ńŋɩnáa bondoláázɩ fáa nɛ́, badana bajaa lewáa tunbóóló nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Tɔ́ɔ, sʊlʊ́m wɔɔgɔ́nɩ bɩcɛ́ bajaa ɩzá-rɔ ɩkʊrʊ́ nɛ́, waanɩ́ɩ wenbí ibiyaalʊ́ kúmuú ɩmʊ́ waalá bɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Waanɩ́ɩ bɩlɛ́ nɛ́ gɛ sɩsɩ: «Mánváa mɩ́ɩ nɔɔ́ kʊ́ɖʊḿ‑kʊ́ɖʊḿ. Kanáanɩ, Ɩsɔ́ɔ ɩ́la nya láálɩ́, bɩ́bɩ́sɩ́ná nya nɖawaalɩnáa-dɛ́ɛ yomáa-dɛ́ɛ tɔ́ɔ́rɔɔ́.» ");
INSERT INTO kdh_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ngɛ sɩsɩ: «Sɛ́ɛmɩ, máázá Nyádʊ́ʊ Ɩsɔ́ɔ. Kanáanɩ ɩ́bɩsɩ Sɛ́ɛmɩ-dɛ́ɛ yoḿ. ");
INSERT INTO kdh_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ɩsɔ́ɔ ɩ́tɔ́ Yafɛ́ɛtɩ ndɛ́ ndɔɔlɩmá; ɩfa yɩ ɖɩdáarɛ ɩcɔ́ɔ Sɛ́ɛmɩ bɩsaagɛ́rɛ́ɛ́zɩ-dɛ; bɩka Kanáanɩ ɩbɩ́sɩ ɩdɛ́ɛ yoḿ ɖʊɖɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Lɩ́m súu bɩḿ bʊwɔ́rɔ́, Núhum waadásɩ ɩcɔ́ɔ bɩ́ɩ́zɩ kákpaanɩɩ́nʊwá na nɛɛ́saaláa (350) gɛ waazɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ɩdɛ́ɛ bɩ́ɩ́zɩ rɩ́ŋa wɔɔjɔ́ɔ ɖúúlínya nɛ́, siiyóózi sɩlɩ́ɩ bɩ́ɩ́zɩ kákpɩ́ɩ́zɩ nasɩ́náázá na nɩɩ́nʊ́wá na nɛɛ́saaláa (950). ");
INSERT INTO kdh_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Lɩ́m súu wɔ́rɔ́ nɛ́, Núhum-dɛ́ɛ bíya Sɛ́ɛmɩ, Háamɩ, na Yafɛ́ɛtɩ bogutoluú-dɛ bíya nɖɔ́: ");
INSERT INTO kdh_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yafɛ́ɛtɩ-dɛ́ɛ lʊrʊ́ʊ-daá nɛ́, waalʊ́rʊ bíya abaaláa: Gɔmɛ́ɛrɩ, Magɔ́ɔgɩ, Madáayɩ, Yaváanɩ, Tubáalɩ, Mɛsɛ́ɛkɩ na Tiráasɩ. ");
INSERT INTO kdh_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gɔmɛ́ɛrɩ waagʊrʊ́ nɛ́, waalʊ́rʊ bíya abaaláa: Asɩkɛnáazɩ, Rifáatɩ na Togarɩmáa. ");
INSERT INTO kdh_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yaváanɩ ɩlɛ́ waagʊrʊ́ nɛ́, waalʊ́rʊ bíya abaaláa: Elísa, Tarɩsíisɩ, Kitíim na Rodaníim. ");
INSERT INTO kdh_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Bíya bɛḿ bɛdɛ́ɛ lʊrʊ́ʊ-daá gɛ zamɔ́ɔ waaya kisu tenkú kpámásɩ-rɔ, hálɩ kɩtára tɛ́ɛ́dɩ ndɩ‑ndɩ laadɔ́ɔ báa wenká-daá na sɛ́ɛ́dɩwá ndɩ‑ndɩ kʊnʊm báa wenkí-daá. ");
INSERT INTO kdh_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Háamɩ waagʊrʊ́ nɛ́, ngɛ waalʊ́rʊ bíya abaaláa: Kúusi, Mɩsɩrayím, Púuti, na Kanáanɩ. ");
INSERT INTO kdh_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kúusi ɩlɛ́ waagʊrʊ́ nɛ́, ngɛ waalʊ́rʊ bíya abaaláa: Séba, Havíila, Sábɩta, Rahííma na Sabitéka. Rahííma ɩlɛ́ waagʊrʊ́ nɛ́, ngɛ waalʊ́rʊ bíya abaaláa: Séba na Ɖɩdáánɩ. ");
INSERT INTO kdh_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kúusi-dɛ́ɛ bú naárʊ ɖʊɖɔ gɛ Nimiróodi; ɩlɛ́ gɛ ɖúúlínya-daá ɩrʊ́ fɩ́ya ńnɩ́ kaɖaa ńnɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ɩbá ɩgɛ́ɛ ɩgbám fɩ́ya ńnɩ́ gɛ Ɖádʊ́ʊ Ɩsɔ́ɔ ɩzá-daá. Bʊrɔ gɛ baazɩ́ɩ bɛ́ngɛɛzɩ́ sɩsɩ: «Wáánɩ kɛ́ɛ ɩgbám kʊ́bɔnɩ́ Ɖádʊ́ʊ Ɩsɔ́ɔ ɩzá-daá gɛ nyazɩ Nimiróodi.» ");
INSERT INTO kdh_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Weeɖi kowúrátɩ Babɛ́ɛlɩ, Erɛ́kɩ na Akáadɩ barɩ́ŋa bɛdɛ́ɛ́dɩwá-rɔ Sineyáarɩ laadɔ́ɔ-daá. ");
INSERT INTO kdh_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Laadɔ́ɔ kɛḿ kadaá gɛ Nimiróodi waalɩ́ɩ ɩɖɛ́ɛ Asúuri laadɔ́ɔ-daá. Ńna gɛ waama Niníivi, Rehɔbɔ́ɔtɩ-Íirɩ, Kaláa ");
INSERT INTO kdh_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","na Resɛ́ɛnɩ tɛ́ɛ́dɩ tʊwɛ Niníivi na Kaláa tɛ́ɛ́dɩ kʊ́bɔńdɩ bɔlɔwʊtáá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mɩsɩrayím kutoluú-dɛ bíya gɛ Lúudi, Anɛ́ɛmɩ, Leháabɩ, Nafɩtúu, ");
INSERT INTO kdh_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patɩrɔ́ɔsɩ, Kasɩlúu ńba; Kasɩlúu tɛ́ɛ́dɩ tɩḿ tɩdaá gɛ Filisitíi na Kafɩtɔ́ɔrɩ ńba waagálɩ́ɩ́ná. ");
INSERT INTO kdh_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanáanɩ biyaalʊ́ kaɖaa ńnɩ́ waalʊ́rʊ yɩ nɛ́ gɛ Sidɔ́ɔnɩ. Ɩlɛ́ ɩwɔ́rɔ́ gɛ waalʊ́rʊ Hitíi, ");
INSERT INTO kdh_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Kanáanɩ ɩmʊ́ ɩgɛ́ɛ na Yebúsi, Amɔ́ɔrɩ, Gigáarɩ, ");
INSERT INTO kdh_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hivíi, Áarɩkɩ, Síini, ");
INSERT INTO kdh_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arɩváadɩ, Sɩmáárɩ, na Hamáatɩ ńba rɩ́ŋa bajaájaa. Bɩlɛ́ bʊwɔ́rɔ́, Kanáanɩ ńba bɛḿ baaya ɖamá bosuná tɛ́ɛ́dɩ. ");
INSERT INTO kdh_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Bɛdɛ́ɛ laadɔ́ɔ tɩ́ŋa-tɩ́ŋa gɛ kpɔɔ Sidɔ́ɔnɩ nɖɛɛ ná Gɩráarɩ fáráńdɩ́ hálɩ Gazáa, ngbɔ́ɔ nbó Sodɔ́ɔmɩ, Gomɔ́ɔrɩ, Adɩ́ma, na Sɩbɔ́ɔ ńba-dɛ́ɛ, hálɩ ngóyoozi Lésa. ");
INSERT INTO kdh_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Bɩlɛ́ gɛ Háamɩ waalʊ́rʊ bíya bosu tɛ́ɛ́dɩwá ndɩ‑ndɩ, báa wenbá na bɛdɛ́ɛ sɛ́ɛ́dɩwá ndɩ‑ndɩ na kʊnʊmɩ́nɩ ndɩ‑ndɩ. ");
INSERT INTO kdh_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sɛ́ɛmɩ, Yafɛ́ɛtɩ ɖawaalʊ kʊ́bɔnɩ́ ɖʊɖɔ waalʊ́rʊ bíya abaaláa. Sɛ́ɛmɩ ɩmʊ́ ɩgɛ́ɛ na Éburu na igutoluú-dɛ bíya bajaájaa. ");
INSERT INTO kdh_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sɛ́ɛmɩ ɩmʊ́ ibíya bɛḿ nɖɔ́: Eláamɩ, Asúuri, Arɩpakɩsáadɩ, Lúudi na Aráamɩ. ");
INSERT INTO kdh_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aráamɩ ɩlɛ́ waagʊrʊ́ nɛ́, ngɛ waalʊ́rʊ Úusi, Úuli, Gɛtɛ́ɛrɩ na Máasɩ. ");
INSERT INTO kdh_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arɩpakɩsáadɩ waagʊrʊ́ nɛ́, ngɛ waalʊ́rʊ Séla; Séla ɩlɛ́ waalʊ́rʊ Éburu. ");
INSERT INTO kdh_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Éburu waagʊrʊ́ nɛ́, ngɛ ɩlɛ́ waalʊ́rʊ bíya nɔɔ́lɛ. Kʊ́ɖʊḿ gɛ bánÿaá sɩsɩ Pelɛ́ɛgɩ, bugutoluú sɩsɩ tarɩ́ɩ; káma, ɩlɛ́ ɩdɛ́ɛ sáátɩ gɛ ɩráa waadára ɖamá adɛ laadɔ́ɔ-rɔ. Sɩɩlɛ ńnɩ́ gɛ bánÿaá sɩsɩ Yɔkɩtáanɩ. ");
INSERT INTO kdh_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Ɩlɛ́ waagʊrʊ́ nɛ́, ngɛ waalʊ́rʊ Alɩmɔdáadɩ, Sɩlɛ́ɛfʊ, Hasarɩmavɛ́ɛtɩ, Yeráa, ");
INSERT INTO kdh_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoráam, Uzáalɩ, Ɖikiláa, ");
INSERT INTO kdh_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obáalɩ, Abɩmayɛ́ɛlɩ, Séba, ");
INSERT INTO kdh_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofíiri, Havíila na Yobáabɩ. Tɔ́ɔ, Yɔkɩtáanɩ-dɛ́ɛ bíya riké nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ngɛ tɛ́ɛ́dɩ bánÿaá tɩ sɩsɩ Mésáa nɛ́, tɩ́na Sefáarɩ-dɛ́ɛ wɩ́sɩ ɖaagalɩɩɖɛ́ fáráńdɩ́-dɛ́ɛ bʊ́ʊ́nɩ nɛ́ bɔlɔwʊtáá gɛ bɔɔjɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Bɩlɛ́ gɛ Sɛ́ɛmɩ waalʊ́rʊ bíya bosu tɛ́ɛ́dɩwá ndɩ‑ndɩ, báa wenbá na bɛdɛ́ɛ sɛ́ɛ́dɩwá ndɩ‑ndɩ na kʊnʊmɩ́nɩ ndɩ‑ndɩ. ");
INSERT INTO kdh_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Wenbí Núhum-dɛ́ɛ bíya waalʊ́rʊ bɩlʊ́rʊ bisu laadásɩ ndɩ‑ndɩ nɛ́ nbɩlɛ́. Lɩ́m woozu bɩwáálɩ ɖúúlínya rɩ́ŋa na bʊsɔ́ɔ wɔ́rɔ́ nɛ́, Núhum kutoluú-dɛ bíya bɛḿ baalʊrʊ ná bíya baya ɖamá bosu laadásɩ ndɩ‑ndɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ɖoo bɩgaɖaa nɛ́, ɩráa rɩ́ŋa wánŋmatɩ́ ŋmatɩrɛ kʊ́ɖʊńɖɛ gɛ, kʊnʊm kʊ́ɖʊmʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Bɛdɛ́ɛ kisɔɔ́-daá gɛ bɔɔgɔ́nɩ bakálɩ́ɩ́ná wɩ́sɩ ɖaagalɩɩɖɛ́ batála Sineyáarɩ bɔkɩrɛ-daá bɔcɔ́ɔ. Ngɛ baajáŋ bawalɩ́ ńnaamʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Bɔwɛ ńna nɛ́ gɛ bɔɔdɔ́ ɖamá sɩsɩ: «Ɖɛ́dɛ́ɛ ńba, ɩgɔ́nɩ ɖɩcɛ́ bírikisiwá, bɩka ɖɩwɔ́ tɩ tɩlá ɖóni.» Ngɛ bɛɛjɛ́ bírikisiwá wentí sɩ bamaná nɛ́, bacáa aŋɔ wenkí sɩ kiyóózi bɩrɩ́ŋa bʊɖɔ́kɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ngɛ sɩsɩ: «Ɖɛ́dɛ́ɛ ńba, ɖɩ́má tɛ́ɛ́dɩ kʊ́bɔńdɩ na bísa; bɩka bísa kɩḿ kɩgʊjʊʊ́ ikédékíná ɩsɔ́ɔ́dáá ŋmɩ́ńdɩ. A ɖáámá bɩlɛ́, ɖádándayáa ɖamá ɖúúlínya rɩ́ŋa-daá, bɩka ɖʊɖɔ ɖáájáa yɩ́ɖɛ ɖɩsɩ́ɩ ɖádɩ nbɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ weegédi ɩbɛ́ɛ́ŋ bɛdɛ́ɛ tɛ́ɛ́dɩ kʊ́bɔńdɩ na bísa kʊ́bɔńgɩ wenkí bánmáa kɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ngɛ wɔɔdɔ́ sɩsɩ: «Ɩráa bana barɩ́ŋa bɛgɛ́ɛ ɩrʊ́ kʊ́ɖʊḿ gɛ, bɩka bánŋmatɩ́ kʊnʊm kʊ́ɖʊmʊ́ʊ. A bɩlɛ́ gɛ baabáázɩ, nabʊ́rʊ fɛ́yɩ́ sɩ bukúti bʊtɔ wenbí bɔzɔɔlɛ́ɛ sɩ balá nɛ́ nɩ́bááwʊ. ");
INSERT INTO kdh_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Bɩlɛ́ nɛ́, iyéle ɖití ɖiyóózi bɛdɛ́ɛ kʊnʊm ɖɩsááwʊ, bɩka badaá naárʊ tándanɩɩ ɩrɔwʊ́-dɛ́ɛ ńgɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ weegédi ɩkɔ́nɩ ɩsááwʊ bɛdɛ́ɛ kʊnʊm. Ngɛ waayáázɩ wɛ ɩsɩ́ɩ ndɩ‑ndɩ ɖúúlínya rɩ́ŋa-daá, ngɛ beeyéle tɛ́ɛ́dɩ kʊ́bɔńdɩ tɩḿ tɩdɛ́ɛ máa. ");
INSERT INTO kdh_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ńŋɩnáa ńnaamʊ́ gɛ Ɖádʊ́ʊ Ɩsɔ́ɔ waazááwʊ ɩráa rɩ́ŋa-dɛ́ɛ kʊnʊm nɛ́, biiyele ná bayáa bɛdɛ́ɛ́dɩ tɩḿ sɩsɩ Babɛ́ɛlɩ; bugutoluú sɩsɩ saawʊ́. Lɛlɛɛɖɔ́, Ɖádʊ́ʊ Ɩsɔ́ɔ waayáázɩ wɛ ɩsɩ́ɩ ndɩ‑ndɩ, wenbí biiyéle gɛ ɩráa woozu ɖúúlínya-daá nɛ́ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Sɛ́ɛmɩ kutoluú-dɛ bíya nɖɔ́. Lɩ́m kʊ́bɔńbɩ súu bɩwáálɩ ɖúúlínya-rɔ wɔ́rɔ́, bɩɩlá bɩ́ɩ́zɩ nasɩ́lɛ nɛ́, Sɛ́ɛmɩ waalá bɩ́ɩ́zɩ nɩɩ́nʊ́wá (100) nɛ́, ngɛ waalʊ́rʊ Arɩpakɩsáadɩ. ");
INSERT INTO kdh_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Ɩdɛ́ɛ lʊrʊ́ʊ wɔ́rɔ́ nɛ́, Sɛ́ɛmɩ waadásɩ ɩcɔ́ɔ bɩ́ɩ́zɩ kákpɩ́ɩ́zɩ nasɩ́lɛ na nɩɩ́nʊ́wá (500) ɩlʊ́rʊ bíya aláa na abaaláa. ");
INSERT INTO kdh_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arɩpakɩsáadɩ ɩlɛ́ waagʊrʊ́ ɩtála bɩ́ɩ́zɩ ákoosaaláa na nasʊ́nʊ́wá (35) nɛ́, ngɛ waalʊ́rʊ Séla. ");
INSERT INTO kdh_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Séla-dɛ́ɛ lʊrʊ́ʊ wɔ́rɔ́ nɛ́, Arɩpakɩsáadɩ waadásɩ ɩcɔ́ɔ bɩ́ɩ́zɩ kákpɩ́ɩ́zɩ nasɩ́lɛ na nasúdoozo (403) ɩlʊ́rʊ bíya aláa na abaaláa. ");
INSERT INTO kdh_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Séla waadála bɩ́ɩ́zɩ ákoosaaláa (30) nɛ́, ngɛ waalʊ́rʊ Éburu. ");
INSERT INTO kdh_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Éburu-dɛ́ɛ lʊrʊ́ʊ wɔ́rɔ́ nɛ́, Séla waadásɩ ɩlá bɩ́ɩ́zɩ kákpɩ́ɩ́zɩ nasɩ́lɛ na nasúdoozo (403) ɩlʊ́rʊ bíya aláa na abaaláa. ");
INSERT INTO kdh_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Éburu waadála bɩ́ɩ́zɩ ákoosaaláa na nasɩ́náázá (34) nɛ́, ngɛ waalʊ́rʊ Pelɛ́ɛgɩ. ");
INSERT INTO kdh_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Pelɛ́ɛgɩ-dɛ́ɛ lʊrʊ́ʊ wɔ́rɔ́ nɛ́, Éburu waadásɩ ɩlá bɩ́ɩ́zɩ kákpɩ́ɩ́zɩ nasɩ́lɛ na ákoosaaláa (430) ɩlʊ́rʊ bíya aláa na abaaláa. ");
INSERT INTO kdh_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelɛ́ɛgɩ ɩlɛ́ waagʊrʊ́ ɩtála bɩ́ɩ́zɩ ákoosaaláa (30) nɛ́, ngɛ waalʊ́rʊ Réhu. ");
INSERT INTO kdh_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Réhu-dɛ́ɛ lʊrʊ́ʊ wɔ́rɔ́ nɛ́, Pelɛ́ɛgɩ waadásɩ ɩcɔ́ɔ bɩ́ɩ́zɩ kákpáŋa na kééníré (209) ɩlʊ́rʊ bíya aláa na abaaláa. ");
INSERT INTO kdh_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Réhu ɩlɛ́ waagʊrʊ́ ɩtála bɩ́ɩ́zɩ ákoosaaláa na nasɩ́lɛ (32) nɛ́, ngɛ waalʊ́rʊ Serúugu. ");
INSERT INTO kdh_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Serúugu-dɛ́ɛ lʊrʊ́ʊ wɔ́rɔ́ nɛ́, Réhu waadásɩ ɩcɔ́ɔ bɩ́ɩ́zɩ kákpáŋa na lʊbɛ (207) ɩlʊ́rʊ bíya aláa na abaaláa. ");
INSERT INTO kdh_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serúugu waalá bɩ́ɩ́zɩ ákoosaaláa (30) nɛ́, ngɛ waalʊ́rʊ Nahɔ́ɔrɩ. ");
INSERT INTO kdh_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nahɔ́ɔrɩ-dɛ́ɛ lʊrʊ́ʊ wɔ́rɔ́ nɛ́, Serúugu waadásɩ ɩcɔ́ɔ bɩ́ɩ́zɩ kákpáŋa (200) ɩlʊ́rʊ bíya aláa na abaaláa. ");
INSERT INTO kdh_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahɔ́ɔrɩ waagʊrʊ́ ɩtála bɩ́ɩ́zɩ ákoosaaláa nɛkɛ́rɛ fɛ́yɩ́ (29) nɛ́, ngɛ waalʊ́rʊ Teráa. ");
INSERT INTO kdh_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Teráa-dɛ́ɛ lʊrʊ́ʊ wɔ́rɔ́ nɛ́, Nahɔ́ɔrɩ waadásɩ ɩcɔ́ɔ bɩ́ɩ́zɩ nɩɩ́nʊ́wá na ákoowú nɛkɛ́rɛ fɛ́yɩ́ (119) ɩlʊ́rʊ bíya aláa na abaaláa. ");
INSERT INTO kdh_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Teráa ɩlɛ́ waalá bɩ́ɩ́zɩ niídoozo na saaláa (70) nɛ́, ngɛ waalʊ́rʊ bíya noódoozo: Ɩbrám, Nahɔ́ɔrɩ, na Haráanɩ. ");
INSERT INTO kdh_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Teráa kutoluú-dɛ bíya nɖɔ́: waalʊ́rʊ Ɩbrám, Nahɔ́ɔrɩ, na Haráanɩ. Ngɛ Haráanɩ ɩlɛ́ waalʊ́rʊ Lɔ́ɔtɩ. ");
INSERT INTO kdh_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Tɛ́ɛ́dɩ bánÿaá tɩ sɩsɩ Úuri tʊwɛ Babilɔ́ɔnɩ laadɔ́ɔ-daá lé baalʊ́rʊ Haráanɩ ɩmʊ́ nɛ́ tɩdaá ńna gɛ waazɩ́ ɩka ɩjaa. ");
INSERT INTO kdh_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ɩbrám na Nahɔ́ɔrɩ bɛlɛ́ bɔɔgbɔ́ɔ aláa. Ɩbrám-dɛ́ɛ ńnɩ́ gɛ bánÿaá sɩsɩ Saaráyɩ; Nahɔ́ɔrɩ nɛ́, Haráanɩ wɛɛlɛ́ɛ Mílíka gɛ ɩlɛ́ wɔɔgbɔ́ɔ. Haráanɩ ɩmʊ́ ibú naárʊ ɖʊɖɔ gɛ bánÿaá sɩsɩ: Yísíka. ");
INSERT INTO kdh_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saaráyɩ kɛ́ɛ kaalʊrʊya gɛ, ɩvɛ́yɩ́na bú. ");
INSERT INTO kdh_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Ngɛ Teráa wɛɛzɛlɩ́ ibiyaalʊ́ Ɩbrám na ɩlɛ́ ɩɖɛɛlʊ́ Saaráyɩ na ibiyaalʊ́ Haráanɩ bú Lɔ́ɔtɩ bakʊrʊ́ Úuri Babilɔ́ɔnɩ laadɔ́ɔ-daá bɛ́nɖɛɛ́ Kanáanɩ. Amá, baagʊrʊ́ nɛ́, boobó bɩlɛ́ hálɩ Haráanɩ tɛ́ɛ́dɩ-daá; ngɛ boozúu ńnaamʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Haráanɩ ńnaamʊ́ gɛ Teráa wɛ, hálɩ ɩlá bɩ́ɩ́zɩ kákpáŋa na nasʊ́nʊ́wá (205) gɛ waazɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Wɩ́rɛ bɩjɔɔ́ɔ nɛ́, ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ wɔɔdɔ́ Ɩbrám sɩsɩ: «Ɩbrám, lɩɩ ngɔɔ na njaa bɛdɛ́ɛ, nÿéle nyɛ́dɛ́ɛ koobíre na mawɩ́lɩ nya tɛ́ɛ́dɩ wentí tɩdaá sɩ nbó ngɔ́jɔ́ɔ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Mánɖʊ́ʊ nya alɩbáráka nlʊ́rʊ bɩɖɔ́ɔ bɩlá tɛ́ɛ́dɩ kʊ́bɔńdɩ, nyáyɩ́ɖɛ ɩlɩ́ɩ; ɩráa iɖiná nya alɩbáráka. ");
INSERT INTO kdh_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","A weení ɩrɩ́ŋa wóngoorináa nya kífeńbi nɛ́, kífeńbi gɛ sɩ mɛvɛ́rɛ yɩ. Amá, a weení wóngoorináa nya bɩdaavé nɛ́, bɩdaavé ɖʊɖɔ gɛ mɛ́nvɛrɩ́ɩ yɩ. Nyánáábɩ́lɛ́ sɩ mabaná maɖʊ yíriwá rɩ́ŋa alɩbáráka.» ");
INSERT INTO kdh_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Ngɛ Ɩbrám weedísi ɩkʊrʊ́ Haráanɩ ńŋɩnáa wenbí Ɖádʊ́ʊ Ɩsɔ́ɔ wɔɔdɔ́ yɩ nɛ́. Bɩdɛ́ɛ sáátɩ kɩḿ, Ɩbrám wɛná bɩ́ɩ́zɩ niídoozo na saaláa na nasʊ́nʊ́wá (75) nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Sɩ ɩkʊrʊ́ nɛ́, ngɛ wɔɔgbɔ́ɔ ɩɖɛɛlʊ́ Saaráyɩ, na inewú-dɛ́ɛ bú Lɔ́ɔtɩ; ɩkpɔ́ɔ ɩdɛ́ɛ yomáa rɩ́ŋa na ɩdɛ́ɛ amáána rɩ́ŋa ɩgɔwɛná Haráanɩ nɛ́ bɛɖɛ́ɛ Kanáanɩ laadɔ́ɔ-daá. ");
INSERT INTO kdh_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Boobó batála Kanáanɩ laadɔ́ɔ-daá nɛ́, ngɛ boobó hálɩ ɖɩdáarɛ bánÿaá ɖɛ Sɩkɛ́ɛm nɛ́ ɖɩdaá, Morée tɩɩwʊ́ kʊ́bɔńgɩ-dɛ. Bɩdɛ́ɛ sáátɩ kɩḿ baadála nɛ́, Kanáanɩ ńba suwáa ńnaamʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Bɔwɛ ńnaamʊ́ gɛ Ɖádʊ́ʊ Ɩsɔ́ɔ waaɖʊ ɩlɩ́ɩ Ɩbrám-rɔ ifééri yɩ sɩsɩ: «Laadɔ́ɔ kana gɛ sɩ mava nyébíya‑bíya.» Ngɛ Ɩbrám waajáŋ ɩma sarɔ́ɔ ɖaalanɖɛ́ sɩ ɩlá Ɖádʊ́ʊ sarɔ́ɔ lénlé waaɖʊ ɩlɩ́ɩ ɩrɔɔzɩ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Bɩjɔɔ́ɔ nɛ́, ngɛ waadákʊrʊ́ ɩɖɛ́ɛ tɛ́ɛ́dɩ bánÿaá tɩ sɩsɩ Betɛ́ɛlɩ nɛ́ tɩdɛ́ɛ wɩ́sɩ ɖaagalɩɩɖɛ́-dɛ́ɛ bʊ́ʊ́nɩ-daá isúu; Betɛ́ɛlɩ wɛná ɩdɛ́ɛ wɩ́sɩ ɖaazalaɖɛ́, bɩka Ayíi wɛná ɩdɛ́ɛ wɩ́sɩ ɖaagalɩɩɖɛ́. Waadála ńna nɛ́, ngɛ waadámáa sarɔ́ɔ ɖaalanɖɛ́ bɩka ɩyáa Ɖádʊ́ʊ Ɩsɔ́ɔ yɩ́ɖɛ. ");
INSERT INTO kdh_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ɩcɔ́ɔ cé, ɩkʊrʊ́; ɩcɔ́ɔ cé, ɩkʊrʊ́. Wɩ́rɛ bɩjɔɔ́ɔ nɛ́, ngɛ wɔɔgbɔɔná Negɛ́ɛvɩ tɛɛwʊ́lɔ́ɔ́-daá nɩ́bááwʊ. ");
INSERT INTO kdh_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Bɩɩgɔ́nɩ bɩjɔɔ́ɔ nɛ́, nyɔɔ́sɩ waazʊ́ʊ Kanáanɩ laadɔ́ɔ-daá. Sɩɩgɔ́nɩ sɩbá sɩkɩ́lɩ nɛ́ gɛ Ɩbrám waagʊrʊ́ ɩɖɛ́ɛ Mɩ́sɩra sɩ ɩkɔ́jɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Sáátɩ wenkí waajʊʊná Mɩ́sɩra laadɔ́ɔ nɛ́, ngɛ wɔɔdɔ́ ɩɖɛɛlʊ́ Saaráyɩ sɩsɩ: «Nyááná, mányɩ bɩlɛ́ sɩsɩ nyɔ́jɔɔ́ɔ kazɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","A ɖáádála gɛ Mɩ́sɩra ńba waana nya, bɔ́ndɔ́m sɩsɩ ɩɖɛɛlʊ́ nbɩlɛ́; asée baagʊ ma bɩka beyéle nyɔ́ɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Bɩlɛ́ nɛ́, a ɖáádála gɛ bɔɔbɔ́ɔ́zɩ nya, máávɩ́nɩ nya, busi wɛ sɩsɩ ménewú gɛ nya. Ńdánátá bánlám ma kazɔ́ɔ nyɔ́rɔ́ɔ́zɩ́ nɛ́, ńna nɛ́, mɔ́ɔ́ ɖʊɖɔ mónÿuúu weezuú.» ");
INSERT INTO kdh_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ɩbrám waadála Mɩ́sɩra nɛ́, ngɛ bɛlɛ́ baana sɩsɩ ɩɖɛɛlʊ́ ɩbá ɩjɔɔ́ɔ kazɔ́ɔ páá. ");
INSERT INTO kdh_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Mɩ́sɩra wúro Farawʊ́na-dɛ́ɛ awóronbíya waana bɩlɛ́ sɩsɩ ɩjɔɔ́ɔ kazɔ́ɔ nɛ́, ngɛ boobó bánzám ɩdɛ́ɛ kazɔ́ɔ wúro ɩmʊ́ waazá-daá; bɔkɔ́nɩ bɔkpɔ́ɔ yɩ boboná ɩdɛ́ɛ ɖaána-daá. ");
INSERT INTO kdh_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Alʊ́ ɩmʊ́ ɩrɔɔzɩ́ nɛ́, baabá gɛ bamʊ Ɩbrám kazɔ́ɔ: bafa yɩ fééni, namɩ́nɩ, náánɩ, kpangbásɩ na raakúḿwá, bɩkpɛdɩ́na yomáa aláa na abaaláa. ");
INSERT INTO kdh_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Amá, Ɩbrám ɖɛɛlʊ́ Saaráyɩ ɩmʊ́ ɩrɔɔzɩ́ nɛ́, Ɖádʊ́ʊ Ɩsɔ́ɔ weeyéle nbusú ɩmɔɔná wúro Farawʊ́na na ɩdɛ́ɛ ɩyáálɩ rɩ́ŋa. ");
INSERT INTO kdh_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Ńna gɛ weedíri bayáa Ɩbrám ifééri yɩ sɩsɩ: «Ɩbrám, we-rɔ gɛ nyáálá ma bɩlɛ́. Bɩyáásɩ́ gɛ ńdéfééri ma sɩsɩ nɖɛɛlʊ́ nbɩlɛ́, ");
INSERT INTO kdh_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","ndísi nvééri ma sɩsɩ nyénewú gɛ, hálɩ bʊkɔná ma mɔgbɔ́ɔ yɩ ɩsɩ mɛɖɛɛlʊ́; bɛɛ́ɛ, nɖɛɛlʊ́ ɩmʊ́ nbɩlɛ́, kpɔɔ yɩ nɖɛ́ɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ńna gɛ wúro weevééri ɩdɛ́ɛ furúsiwá sɩsɩ bɔ́ɖɔɔ yɩ ɩ́na ɩɖɛɛlʊ́ na bagbɩná rɩ́ŋa balɩzɩ́ wɛ tɛ́ɛ́dɩ. ");
INSERT INTO kdh_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ngɛ Ɩbrám na ɩɖɛɛlʊ́ baagálɩɩ Mɩ́sɩra bakábɩsɩ Negɛ́ɛvɩ tɛɛwʊ́lɔ́ɔ́-daá bágana bagbɩná rɩ́ŋa. Bɛ́ngɛɖɛɛ́ bɩlɛ́ nɛ́, bɛɛgɛ́gbɛ́dɩ́na Lɔ́ɔtɩ. ");
INSERT INTO kdh_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ɩbrám cɔɔ́ɔ bɩlɛ́ nɛ́, ɩbá ɩgɛ́ɛ ɖɔ́ɔ́lɛ-dʊ́ʊ gɛ na toovonúm; ɩwɛná fʊ́ńdɩ kpɩná, liideé, na siká. ");
INSERT INTO kdh_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ɩwɛ Negɛ́ɛvɩ bɩlɛ́ gɛ wɩ́rɛ bɩjɔɔ́ɔ nɛ́, wɔɔgbɔ́ɔ bɩsɩ́-daá; ɩcɔ́ɔ cé, ɩkʊrʊ́, ɩcɔ́ɔ cé, ɩkʊrʊ́, ");
INSERT INTO kdh_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","hálɩ ɩbɩ́sɩ ɩdɛ́ɛ kɩ́bɩńɖɛ Betɛ́ɛlɩ na Ayíi bɔlɔwʊtáá, lénlé waavʊ́ńmáa Ɩsɔ́ɔ-dɛ́ɛ sarɔ́ɔ ɖaalanɖɛ́ nɛ́. Waadála ńna nɛ́, ngɛ waayáa Ɩsɔ́ɔ sɩsɩ: Ɖádʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Inewú-bú Lɔ́ɔtɩ weení ɩ́gana yɩ bɩlɛ́ nɛ́, ɩlɛ́ ɖʊɖɔ ɩwɛná fééni, namɩ́nɩ, náánɩ; na ɩdɩtɩŋa ɩdɛ́ɛ zamɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","7","Bána bavʊ́ńdɩ kpɩná-dɛ́ɛ ɖɔɔmɩ́nɩ weeyéle ɖɩdáarɛ bɔwɛ ɖɩdaá nɛ́, ɖidokúti ɖɩcáa sɩ ɖɩwála wɛ na boyuú bɔcɔ́ɔ bɛlɛ́ɛ́nɩ́. Bɩdɛ́ɛ sáátɩ, Kanáanɩ ńba na Perizíi ńba ɖʊɖɔ wɛ ńnaamʊ́. Wɩ́rɛ bɩjɔɔ́ɔ nɛ́, yowú waazʊ́ʊ Ɩbrám-dɛ́ɛ ketiráa na Lɔ́ɔtɩ-dɛ́ɛ ńba bɔlɔwʊtáá. ");
INSERT INTO kdh_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Bɩnáábɩ́lɛ́ Ɩbrám waayáa Lɔ́ɔtɩ ɩtɔ́ yɩ sɩsɩ: «Ɖɔ́jɔɔ́ɔ ɖɔ́ nɛ́, ɖɛ́gɛ́ɛ koobíre gɛ. Bɩdɔmɔɔná yowú ɩsʊ́ʊ ɖɔ́lɔ́wʊ́táá, yáá kʊsʊ́ʊ ɖɛ́dɛ́ɛ ketiráa lɔwʊtáá. ");
INSERT INTO kdh_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Bɛɛ laadɔ́ɔ lewáa na puuu bɩlɛ́; bɩlɛ́ nɛ́, ɖɩ́yá ɖamá; a nyɔ́ngbɔɔnáa nʊ́ʊ́nɩ nɩbɩɩwʊ́-rɔ, mɔ́ɔ́ mɔ́ngbɔɔnáa nʊ́ʊ́nɩ kíɖiiwú-rɔ. A ngʊ́ nyɔ́ngbɔɔnáa nʊ́ʊ́nɩ kíɖiiwú-rɔ, mɔ́ɔ́ mɔ́ngbɔɔnáa nʊ́ʊ́nɩ nɩbɩɩwʊ́-rɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lɔ́ɔtɩ wɔɔlɔ ɩzá ɩbɛ́ɛ́ŋ nɛ́, ngɛ waana sɩsɩ Yɔrɔdáanɩ-dɛ́ɛ buwá-dɛ́ɛ kɩdɛrɛwʊ rɩ́ŋa saláa kaanɩŋá. Naanɩ́ na Ɖádʊ́ʊ Ɩsɔ́ɔ ɩyɔ́ Sodɔ́ɔmɩ na Gomɔ́ɔrɩ nɛ́, kpɔɔ bɩlɛ́ nɖɛ́ɛ hálɩ Sowáarɩ fʊnjɔɔ́ɔ kazɔ́ɔ gɛ nyazɩ Ɖádʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ kárɔɔ́-daá, yáá nyazɩ Mɩ́sɩra tɛ́ɛ́dɩ-daá bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","12","Ngɛ waalɩzɩ́ na ńnaamʊ́; ɩkpɔ́ɔ ɩgbɩná ɩfaná ɩzá na wɩ́sɩ ɖaagalɩɩɖɛ́. Bɩka Ɩbrám ɩlɛ́ ɩwalɩ́ Kanáanɩ laadɔ́ɔ-daá. Bɩlɛ́ gɛ Ɩbrám na Lɔ́ɔtɩ baalá baya ɖamá. Lɔ́ɔtɩ woobó isúu Yɔrɔdáanɩ kɩdɛrɛwʊ-daá tɛ́ɛ́dɩwá-jɔ́, bɩka ɩdɩláána Sodɔ́ɔmɩ. ");
INSERT INTO kdh_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodɔ́ɔmɩ ńba bɛḿ babá bɛgɛ́ɛ tɩtɛ lakásɩ-dɩnáa gɛ. Ɖádʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ bɛɛŋ́-daá nɛ́, bɛdɛ́ɛ kidaavééníti lám taká fɛ́yɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Sáátɩ wenkí Ɩbrám na Lɔ́ɔtɩ baaya ɖamá nɛ́, ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ wɔɔdɔ́ Ɩbrám sɩsɩ: «Sɩŋ lénlé nyɔ́wɛ ɖɔ́ nɛ́, nbɛ́ɛ nyánʊ́ʊ́nɩ kíɖiiwú-rɔ, nbɛ́ɛ nyánʊ́ʊ́nɩ nɩbɩɩwʊ́-rɔ; nbɛ́ɛ wɩ́sɩ ɖaagalɩɩɖɛ́; nbɛ́ɛ wɩ́sɩ ɖaagazalaɖɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Laadɔ́ɔ rɩ́ŋa nyɛ́bɛɛ́na kɛ ɖɔ́ nɛ́, mánváa kɛ nyána nyébíya‑bíya, kpɔɔ sinje hálɩ ceré. ");
INSERT INTO kdh_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ménÿelíi nyébíya‑bíya bɛḿ bɔɖɔ́ɔ; a weení waabɩ́ɩ́zɩ ɩkála wɛ nɛ́, ɩlɛ́ waabɩ́ɩ́zɩ ɩkála buuruú nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Bɩlɛ́ nɛ́, kʊrʊ́ ngíli nbɛ́ɛ́ŋ laadɔ́ɔ kɛḿ kabɩɩzɩ́nɩ na kawaláázɩ-daá; káma, nyánáábɩ́lɛ́ sɩ mava kɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ngɛ Ɩbrám wɛɛgɛ́gbɛ́zɩ́ ɩbɩsaagɛ́rɛ́ɛ́zɩ ɩkɔ́nɩ isúu Mamɩrée tɩ́ɩ́nɩ kʊ́bɔńdɩ kpɔ́mɔ́ɔ́ Ebɩrɔ́ɔnɩ tɛ́ɛ́dɩ-jɔ́. Waadála ńna nɛ́, ngɛ waama Ɖádʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ sarɔ́ɔ ɖaalanɖɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Bɩdɛ́ɛ zaamáánɩ gɛ Sineyáarɩ-dɛ́ɛ wúro Amɩrafɛ́ɛlɩ, na Elasáarɩ-dɛ́ɛ wúro Arɩyɔ́ɔkɩ, na Eláam-dɛ́ɛ wúro Kedɔ́ɔrɩ-Lawʊmɛ́ɛrɩ na Goyíim-dɛ́ɛ wúro Tideyáalɩ ");
INSERT INTO kdh_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","baalá yowú bána Sodɔ́ɔmɩ-dɛ́ɛ wúro Beráa, na Gomɔ́ɔrɩ-dɛ́ɛ wúro Birisáa, na Adɩ́ma-dɛ́ɛ wúro Sineyáabɩ, na Sɩbɔ́ɔ ńba-dɛ́ɛ wúro Sɛmbɛ́ɛrɩ na Béla tɛ́ɛ́dɩ bándayaá tɩ sɩsɩ Sowáarɩ nɛ́-dɛ́ɛ wúro. ");
INSERT INTO kdh_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Wúrowá sɩɩlɛ ńba bana bɛɛɖɛ́ɛ botúúzi ɖamá Sidíim bɔkɩrɛ-daá Ɖɔ́m Tenkú ɖɩdáarɛ. ");
INSERT INTO kdh_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Bɩ́ɩ́zɩ fuú na nasɩ́lɛ gɛ bɔɔjɔ́ɔ balá wúro Kedɔ́ɔrɩ-Lawʊmɛ́ɛrɩ bɔwʊtá. Amá, fuú na toozo ńga-daá gɛ baagʊrʊ́ basɩ́ŋ. ");
INSERT INTO kdh_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ákɩzaalʊʊ́ nɛkɛ́rɛ fɛ́yɩ́ ńga-daá nɛ́, ngɛ wúro Kedɔ́ɔrɩ-Lawʊmɛ́ɛrɩ na wúrowá ɩ́na wɛ nɛ́ baagʊrʊ́ boyóo Réfa ńba Asiteróoti-Karinayíim tɛ́ɛ́dɩ-daá, boyóo Zuzíimiwá Háamɩ tɛ́ɛ́dɩ-daá, na Emíimiwá Savé-Kiriyatayíim tɛ́ɛ́dɩ-daá barɩ́ŋa bɩlɛ́ beɖi wɛ. ");
INSERT INTO kdh_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Bɩlɛ́ gɛ booyóo Hɔ́ɔrɩ ńba ɖʊɖɔ bɛlɛ́ bɛdɛ́ɛ Seyíiri bʊ́ʊ-daá beɖi wɛ; bofu wɛ bɩlɛ́ hálɩ Paráanɩ tɩɩwʊ́ kʊ́bɔńgɩ kʊwɛ tɛɛwʊ́lɔ́ɔ́-jɔ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Booyóo bɩlɛ́ bɩtɛ́ nɛ́, ngɛ baagábɩsɩ bɔwɔ́rɔ́ bɔkɔ́nɩ Eyíini-Misipáatɩ bándayaá sɩsɩ Kadɛ́ɛsɩ nɛ́ botóyoo Amalɛ́ɛkɩ ńba bɛlɛ́ balaadásɩ rɩ́ŋa-rɔɔzɩ́, bɩkpɛdɩ́na Amɔ́ɔrɩ ńba bɔwɛ Asasɔ́ɔnɩ-Tamáarɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Ńna gɛ Sodɔ́ɔmɩ, na Gomɔ́ɔrɩ, na Adɩ́ma, na Sɩbɔ́ɔ ńba na Béla tɛ́ɛ́dɩ bándayaá tɩ sɩsɩ Sowáarɩ nɛ́ bɛdɛ́ɛ wúrowá waagʊrʊ́ bakpɩ́ɩ́rɩ boyóo wúro Kedɔ́ɔrɩ-Lawʊmɛ́ɛrɩ Eláam ńnɩ́, na wúro Tideyáalɩ Goyíim ńnɩ́, na wúro Amɩrafɛ́ɛlɩ Mesopotamíi ńnɩ́, na wúro Arɩyɔ́ɔkɩ Elasáarɩ ńnɩ́ Sidíim bɔkɩrɛ-daá. Wúrowá nɔɔ́nʊ́wá wooyóo wúrowá nɔɔ́náázá. ");
INSERT INTO kdh_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Na ngʊ́ nbɛ́ɛ́ŋ nɛ́, Sidíim-dɛ́ɛ bɔkɩrɛ-daá nɛ́, aŋɔ bɔ́ɔ́nɩ waabá gɛ tɩɖɔ́ɔ. Sodɔ́ɔmɩ na Gomɔ́ɔrɩ-dɛ́ɛ wúrowá wɛ bénzewɔ́ɔ nɛ́, boobó basála tɩdaá; bɩka baaganáa rɩ́ŋa bána wɛ nɛ́, bɛlɛ́ bese bakpa bʊ́ʊ́nɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ngɛ wenbá bóngoyoó wɛ nɛ́ bɔɔgɔ́nɩ bokúu Sodɔ́ɔmɩ na Gomɔ́ɔrɩ ńba-dɛ́ɛ kpɩná rɩ́ŋa páyɩ́, bɩkpɛdɩ́na kíɖíídi azíya bɔkpɔ́ɔ bɛɖɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Bɔɔgɔ́nɩ bɔ́ngbɔwʊ́ʊ kpɩná bɩlɛ́ nɛ́, Ɩbrám newú-bú Lɔ́ɔtɩ wɛ Sodɔ́ɔmɩ ɖʊɖɔ, ngɛ baajáŋ bakpa yɩ, bɔkpɔ́ɔ ɩ́na ɩdɛ́ɛ ɖɔ́ɔ́lɛ rɩ́ŋa bɛɖɛɛná. ");
INSERT INTO kdh_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ńna gɛ wenbá booyuú bese bɩlɛ́ nɛ́ badaá kʊ́ɖʊḿ woobó ɩtɩ́ tɔ́m ifééri Ɩbrám Éburu ńnɩ́. Bɩdɛ́ɛ sáátɩ nɛ́, ɩlɛ́ ɩwɛ Amɔ́ɔrɩ Mamɩrée-dɛ́ɛ tɩ́ɩ́nɩ-jɔ́. Esekɔ́ɔlɩ na Anɛ́ɛrɩ bogoobú gɛ Mamɩrée ɩmʊ́. Bodoozóóní bána Ɩbrám baavʊ́ńdaḿ nɔɔ́ gɛ balá kʊ́ɖʊḿ. ");
INSERT INTO kdh_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ɩbrám waanɩ́ɩ sɩsɩ bɩlɛ́ gɛ baagba inewú-bú bɛɖɛɛná nɛ́, ngɛ waagbɩ́ɩ́rɩ ɩdɛ́ɛ yooráa bɛgɛ́ɛ yomáa baalʊ́rʊ wɛ ɩɖaána-daá nɛ́ ɩráa kákpaanɩɩ́nʊwá na ákɩzaalʊʊ́ na noódoozo (318) banyáa batá bɔwɔ́rɔ́ hálɩ Dáanɩ tɛ́ɛ́dɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Baadála nɛ́, ngɛ Ɩbrám waadára wɛ nuvoowú-daá boyóo wɛ beɖi bɔrɔ; bɔɖɔ́ɔ wɛ hálɩ Damáasɩ kʊjʊʊ́-rɔ Óoba tɛ́ɛ́dɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ngɛ Ɩbrám wɛɛgɛ́lɛɛ kpɩná rɩ́ŋa kpátáá baavʊ́ńgbɔwʊ́ yɛ nɛ́, bɩkpɛdɩ́na Lɔ́ɔtɩ na ɩlɛ́ ɩgbɩná na aláa na wenbá barɩ́ŋa baavʊ́ńgbáa wɛ nɛ́ ikégbéná. ");
INSERT INTO kdh_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ɩbrám wooyóo Kedɔ́ɔrɩ-Lawʊmɛ́ɛrɩ na wúrowá baaganáa iɖi wɛ bɩtɛ́ wéngegbém nɛ́, ngɛ Sodɔ́ɔmɩ-dɛ́ɛ wúro woobó ɩkɛ́gɛtɩ yɩ Savé bɔkɩrɛ-daá lé bándayaá sɩsɩ wúro-dɛ́ɛ bɔkɩrɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ńna gɛ Salɛ́ɛm-dɛ́ɛ wúro Mɛlɩkisedɛ́ɛkɩ waajáa kpɔ́nɔ́ na sʊlʊ́m iboná. Mɛlɩkisedɛ́ɛkɩ ɩmʊ́ ɩgɛ́ɛ Ɩsɔ́ɔ Wúro Kʊ́bɔnɩ́-dɛ́ɛ sarásɩ lanɖʊ́ gɛ. ");
INSERT INTO kdh_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Waadála nɛ́, ngɛ waazʊ́lʊ Ɩbrám-rɔ sɩsɩ: «Ɩsɔ́ɔ Wúro Kʊ́bɔnɩ́ waalá adɛ na ɩsɔ́ɔ́dáá nɛ́, ɩ́ɖʊ́ Ɩbrám alɩbáráka. ");
INSERT INTO kdh_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ɖánzám Ɩsɔ́ɔ Wúro Kʊ́bɔnɩ́ ɩmʊ́ weení wɔɔgbɔ́ɔ nyɛ́dɛ́ɛ ɩ́bɛrɛwá ɩɖʊ nyɛ́ńdɛ́ nɛ́.» Ńnaamʊ́ gɛ Ɩbrám waadára wenbí bɩrɩ́ŋa wooyuú bɩ nɛ́ bʊrɔ fuú ɩkpɔ́ɔ fɔɔlʊʊ́ kʊ́ɖʊmʊ́ʊ icéle Mɛlɩkisedɛ́ɛkɩ ɩmʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Bɩlɛ́ bʊwɔ́rɔ́ nɛ́, ngɛ Sodɔ́ɔmɩ wúro weevééri Ɩbrám sɩsɩ: «Bɩsɩná ɩráa njéle mɔ́ɔ́, na nyɔ́ɔ́ ngbɔ́ɔ kpɩná.» ");
INSERT INTO kdh_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ngɛ Ɩbrám sɩsɩ: «Máágbáázɩ ménííká mawɩ́lɩ Ɖádʊ́ʊ Ɩsɔ́ɔ Wúro Kʊ́bɔnɩ́ waalá adɛ na ɩsɔ́ɔ́dáá nɛ́ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Mɔ́ɔ́ mɛ́vɛ́yɩ́ mɔ́ngbɔwʊ́ʊ nyɛ́dɛ́ɛ yɔ́ɔ́lɩ́ká yáá takaḿ nibiiká; cáńfáná nabʊ́rʊ na ngɔ́nɩ ndɔ́ sɩsɩ nyééyéle ná mɔ́ɔ́ Ɩbrám mabɩ́sɩ ɖɔ́ɔ́lɛ-dʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Wenbí mɛ́dɛ́ɛ ńba weeɖi nɛ́, méédísi tɩlɛ́, na wenbá badásɛ́ɛná ma nɛ́: Anɛ́ɛrɩ, Esekɔ́ɔlɩ na Mamɩrée sɩ bɔkpɔ́ɔ nɛ́, bibaasí, mɛ́vɛ́yɩ́ mánzɩɩ́ mádɩ nabʊ́rʊ.» ");
INSERT INTO kdh_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Bɩjɔɔ́ɔ nɛ́, ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ waaɖʊ ɩlɩ́ɩ Ɩbrám-rɔɔzɩ́ ɩtɔ́ yɩ sɩsɩ: «Nkɛnyɛ́ nabʊ́rʊ; mázɩ́ŋɛ́ɛ nyɔ́wɔ́rɔ́; bɩlɛ́ bibaasí, mɛ́nvɛrɩ́ɩ nya kɩvɛrɛwʊ kʊ́bɔńgɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ngɛ Ɩbrám woobúsi yɩ sɩsɩ: «Mádʊ́ʊ Ɩsɔ́ɔ Wúro Kʊ́bɔnɩ́, mɔ́jɔɔ́ɔ ɖɔ́ nɛ́ mɛ́vɛ́yɩ́na bú. Kʊjɔɔwʊ wenkí gɛ sɩ nva ma bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","A sinje máázála mazɩ́, mɛ́dɛ́ɛ yomáa-daá kʊ́bɔnɩ́ Damáasɩ bú bánÿaá yɩ sɩsɩ Elizɛ́ɛrɩ nɛ́ sɩ iɖi ná médííbí. Káma, ńdáfá ma bú.» ");
INSERT INTO kdh_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ńna gɛ Ɖádʊ́ʊ Ɩsɔ́ɔ woobúsi yɩ sɩsɩ: «Aayɩ́, bɩdɛkɛ́ɛ ɩlɛ́ sɩ iɖi ná nyédííbí amá, nyóbú sɩ nlʊ́rʊ yɩ nɛ́ sɩ iɖi ná nyédííbí.» ");
INSERT INTO kdh_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ngɛ wɔɔdɔ́ yɩ ɩkálɩɩ asʊ. Waagálɩɩ nɛ́, ngɛ wɔɔdɔ́ yɩ sɩsɩ: «Kpaazɩ nyáázá ɩsɔ́ɔ́dáá nbɛ́ɛ wɩlásɩ; a nyánbɩɩzɩ́, kala sɩ. Wenbí nyááná sɩɩɖɔ́ɔ nɛ́, bɩlɛ́ gɛ nyébíya‑bíya ɖʊɖɔ sɩ bɔɖɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ngɛ Ɩbrám waava wentí Ɖádʊ́ʊ Ɩsɔ́ɔ wɔɔdɔ́ yɩ tɩ nɛ́ toovonúm. Biiyéle ɩlɛ́ ɩtɔ́ yɩ ɖʊɖɔ sɩsɩ ɩgɛ́ɛ ɩrʊ́ weení ɩzɩɩzɛ́ɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ wɔɔdɔ́tɔḿ yɩ sɩsɩ: «Mánáábɩ́lɛ́ nyádʊ́ʊ Ɩsɔ́ɔ máagálɩzɩ́ nya Úuri Kalɩdée tɛ́ɛ́dɩ-daá mava nya laadɔ́ɔ kana nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ngɛ Ɩbrám woobúsi yɩ sɩsɩ: «Mádʊ́ʊ Ɩsɔ́ɔ Wúro Kʊ́bɔnɩ́, we gɛ sɩ madɩlɩ́ na sɩsɩ mádɩɩná kɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ńna gɛ Ɖádʊ́ʊ Ɩsɔ́ɔ wɔɔdɔ́ yɩ sɩsɩ: «Bo ngájaa bɩ́ɩ́zɩ nasúdoozo nɔ́wʊ aléeré, na bɩ́ɩ́zɩ nasúdoozo nemíka, na bɩ́ɩ́zɩ nasúdoozo agbaŋ, njáa kovóoyɔ́ɔ na ɖuvóore kɩ́faɖɛ́ nÿóózi nlá ma sarɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ngɛ Ɩbrám waajáa kpɩná amʊ́ arɩ́ŋa ɩfɛ́ɛ báa wenɖé nabʊ́nbʊ́lɛ, ɩsɩ́ɩ fɔɔlʊʊ́ báa wenkí kɩfaná kɩrɔwʊ́ ɩzá; amá, ɩdɛfɛ́ɛ siḿsi. ");
INSERT INTO kdh_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Waazɩ́ɩ nɛ́, abɛ́ntɛ́wá wéndím sɔ́m-rɔɔzɩ́; ngɛ ɩjɔɔ́ɔ wɔ́nɖɔwʊ́ʊ tɩ. ");
INSERT INTO kdh_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Wɩ́sɩ sɩ ɩsála nɛ́, ɖóm kʊ́bɔńbɩ nabɩ́rɩ wɔɔgbɔ́ɔ yɩ; temenuú kʊ́bɔnbɔńgɩ ití bɩka nɩdáárɛ kʊ́bɔńɖɛ ɩsʊ́ʊ yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ wɔɔdɔ́ yɩ sɩsɩ: «Tɩlɩ́ sɩsɩ nyébíya‑bíya wɔ́ngɔnɩ́ bɔkɔ́jɔ́ɔ tɛ́ɛ́dɩ natɩ́rɩ-daá ɩgɔ́ńdɩ, babɩ́sɩ yomáa, banáázɩ wɛ hálɩ bɩ́ɩ́zɩ kákpɩ́ɩ́zɩ nasɩ́lɛ (400). ");
INSERT INTO kdh_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Amá, mɔ́ngɔnɩ́ mɔvɔ́ wenbá sɩ bakpa wɛ yoḿti nɛ́ banɩgbamʊʊ́; a bɩɩdɛ́, bɛḿ bánbɩɩzɩ́ balɩ́ɩ tɛ́ɛ́dɩ tɩḿ na ɖɔ́ɔ́lɛ ɖabata bɛɖɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Bɩɩga nyɔ́ɔ́ nɛ́, sɩ nbá gɛ ngɔ́nɩ nbɩ́ɩ ábɔ́nɩ́ kúdú‑kúdú naanɩ́ nzɩ́ fɛɛzɩrɛ-daá boboná nya bebí. ");
INSERT INTO kdh_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Nyébíya-bíya sɩ bokúti bɔkɔ́nɩ bakábɩsɩ cé nɛ́, báńlʊ́rʊ́ bɩlʊ́rʊ, bɩlʊ́rʊ hálɩ nabʊ́náázá. Káma, Amɔ́ɔrɩ ńba-dɛ́ɛ kidaavééníti takɩlɩ tá na mɔɖɔ́ɔ wɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Wɩ́sɩ wɛɛgbɛdɩ́ sɩsála gɛ bɩɩlá temenuú nɛ́, sɩ bɔtɔ́ na bosú nɛ́, bɛɛ nimíni aŋmalá ánɖée bɩka nyɔ́ɔ́zɩ wángám nɛ́, na nimíni kaadɔ́ɔ́rɛ nbɩlɛ́ bɩ́nɖɛɛ́ sɔ́m tuwé lɔwʊtáá. ");
INSERT INTO kdh_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Bɩdɛ́ɛ wɩ́rɛ ɖɩḿ gɛ Ɖádʊ́ʊ Ɩsɔ́ɔ na Ɩbrám beeɖi keɖiyá. Ngɛ Ɩsɔ́ɔ wɔɔdɔ́ yɩ sɩsɩ: «Máává nyébíya‑bíya laadɔ́ɔ kana. Kɔgbɔɔ Mɩ́sɩra buwá nbó Efɩráatɩ buwá kʊ́bɔńga, na laadásɩ wensí ");
INSERT INTO kdh_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Kéni, na Keníizi, na Kadɩmɔ́ɔ, ");
INSERT INTO kdh_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hitíi, na Perizíi, na Réfa, ");
INSERT INTO kdh_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amɔ́ɔrɩ, na Kanáanɩ, na Gigáarɩ, na Yebúsi ńba tɩɩná sɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Ɩbrám ɖɛɛlʊ́ Saaráyɩ wɛ bɩlɛ́ nɛ́, ɩdalʊ́rʊ yɩ bú. Aléeré yoḿ naárʊ wɛ ná ɩjɔ́ ɩgɛ́ɛ Mɩ́sɩra ńnɩ́, bánÿaá yɩ sɩsɩ Agáarɩ. ");
INSERT INTO kdh_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Bɩjɔɔ́ɔ nɛ́, ngɛ Saaráyɩ wɔɔdɔ́ ɩwaalʊ́ Ɩbrám sɩsɩ: «Nyááná sɩsɩ Ɖádʊ́ʊ Ɩsɔ́ɔ wɔɔdɔ ma lʊrʊ́ʊ! Bɩlɛ́ nɛ́, yele mɛ́dɛ́ɛ yoḿ ɩsʊ́ʊ nyɔ́jɔ́ nyána yɩ ɩfɩ́nɩ; nabʊ́rʊ, ɩlɛ́ wánlʊrʊ́ʊ bɩka moyuú bú mɔɖɔ́kɩ.» Saaráyɩ waaŋmátɩ Ɩbrám bɩlɛ́ nɛ́, ɩlɛ́ waanɩ́ɩ ɩnɔɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ngɛ wɔɔgbɔ́ɔ ɩdɛ́ɛ yoḿ Mɩ́sɩra alʊ́ Agáarɩ ɩmʊ́ ɩfa ɩwaalʊ́. Bɩdɛ́ɛ sáátɩ nɛ́, Ɩbrám-dɛ́ɛ bɩ́ɩ́zɩ fuú nbɩlɛ́ Kanáanɩ laadɔ́ɔ-daá. ");
INSERT INTO kdh_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ngɛ Ɩbrám waazʊ́ʊ ɩ́na Agáarɩ bafɩ́nɩ, ngɛ fuwá waazʊ́ʊ. Sáátɩ wenkí Agáarɩ waadɩlɩ́ sɩsɩ ɩ́na fuwá nɛ́, idokúti wénzewɔ́ɔ ɩgʊ́bɔnɩ́ Saaráyɩ. ");
INSERT INTO kdh_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Saaráyɩ waana bɩlɛ́ nɛ́, ngɛ wɔɔdɔ́ ɩwaalʊ́ sɩsɩ: «Kʊdʊ́ʊ́nɩ bándʊ́ʊ́dɩ ma tɩ ɖɔ́ nɛ́, nyádɩɩná tɩ. Mɔ́ɔ́ mávʊndɩɩná yoḿ gɛ mɔ́ɔ́gbɔ́ɔ yɩ mava nya; amá, lɛlɛɛɖɔ́ wooyuú fuwá nɛ́, wɛ́ngbɛɛnáa ma. Bɩlɛ́ nɛ́, Ɖádʊ́ʊ Ɩsɔ́ɔ riké wánvʊʊ kʊ mána nya ɖɔ́dɔ́m.» ");
INSERT INTO kdh_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Waaŋmátɩ bɩlɛ́ nɛ́ gɛ Ɩbrám sɩsɩ: «Nyɛ́dɛ́ɛ yoḿ gɛ; a nyánlám yɩ wenbí nɛ́, nlá yɩ.» Ngɛ Saaráyɩ waabá ɩnáázɩ Agáarɩ hálɩ ɩlɛ́ ɩwɩ́ɩ ise iyéle yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ malááyɩ́ka wɔɔmɔɔná yɩ bɔɔnʊʊ́ kɩdɩláána Súuri ɖibimbiɖé nɛ́ kɩjɔ́ tɛɛwʊ́lɔ́ɔ́-daá. ");
INSERT INTO kdh_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ngɛ ɩlɛ́ wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Agáarɩ Saaráyɩ-dɛ́ɛ yoḿ, lé gɛ nyáagálɩɩ, ngɛ lé gɛ nyɛ́nɖɛɛ́.» Ngɛ woobúsi yɩ sɩsɩ: «Mágʊ́bɔnɩ́ ɩmʊ́ gɛ ménzewɔ́ɔ bɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ngɛ ɩlɛ́ wɔɔdɔ́ yɩ sɩsɩ: «Bɩsɩ nyágʊ́bɔnɩ́ ɩmʊ́ ɩjɔ́, a nyáádála, fʊʊzɩ nyádɩ ɩdɛɛzɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ménÿelíi nyɛ́dɛ́ɛ lʊrʊ́ʊ-daá ɩráa ɩbá bɔkɔ́nɩ bɔɖɔ́ɔ; bɛdɛ́ɛ ɖɔɔmɩ́nɩ ikúti biyéle naárʊ tándabɩɩzɩ ɩkála wɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ngɛ sɩsɩ: «Fuwá nyɛ́yɛ́ɛ́na kɛ ɖɔ́ nɛ́, bú abaalʊ́ gɛ sɩ ngɔ́nɩ nlʊ́rʊ, bɩka nva yɩ yɩ́ɖɛ sɩsɩ Asʊmáyɩ́la; káma, Ɖádʊ́ʊ Ɩsɔ́ɔ waanɩ́ɩ nyɛ́dɛ́ɛ mɛɛdɩrɛ. ");
INSERT INTO kdh_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Nyóbú ɩmʊ́ sɩ ɩbɩ́sɩ gɛ nyazɩ fɔɔ́-daá kpangbɔ́ɔ; wónÿoó ɩráa rɩ́ŋa na bɛlɛ́ ɖʊɖɔ boyóo yɩ. Sɩ ɩlɩ́ɩ gɛ ɩcɔɔná ɩdɩ, iyóo igoobíya.» ");
INSERT INTO kdh_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ńna gɛ Agáarɩ wɔɔbɔ́ɔ́zɩ ɩdɩ sɩsɩ: «Weení ɩbɛɛ́na ma ɖɔ́ nɛ́, mɔ́ɔ́ máábá mana yɩ toovonúm yáá wé.» Ngɛ waava Ɖádʊ́ʊ Ɩsɔ́ɔ weení wɔɔgɔ́nɩ ɩŋmatɩná yɩ nɛ́ yɩ́ɖɛ sɩsɩ: «Nyɔ́ɔ́ gɛ Ɛl‑Rɔ́ɔyɩ,» bugutoluú sɩsɩ, Ɩsɔ́ɔ weení ɩbɛɛ́na ma nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ngɛ baava bɔɔnʊʊ́ kɩḿ yɩ́ɖɛ sɩsɩ Lakáayɩ-Rɔ́ɔyɩ; sɩsɩ weezuú-dʊ́ʊ wánnáa ma nɛ́ ɩdɛ́ɛ lɔkɔ. Lɔkɔ kɩḿ kɩdɛɛzɩwɛ Kadɛ́ɛsɩ tɛ́ɛ́dɩ na Bɛrɛ́ɛdɩ tɛ́ɛ́dɩ bɔlɔwʊtáá. ");
INSERT INTO kdh_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ngɛ Agáarɩ waalʊ́rʊ bú abaalʊ́; ɩjaa Ɩbrám waava yɩ́ɖɛ sɩsɩ Asʊmáyɩ́la. ");
INSERT INTO kdh_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Sáátɩ wenkí baalʊ́rʊ bú ɩmʊ́ nɛ́, Ɩbrám wɛná bɩ́ɩ́zɩ nɩɩ́náázá na loɖo (86). ");
INSERT INTO kdh_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Sáátɩ wenkí Ɩbrám wooyuú bɩ́ɩ́zɩ nɩɩ́nʊ́wá nɛkɛ́rɛ fɛ́yɩ́ (99) nɛ́, ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ waaɖʊ ɩlɩ́ɩ ɩrɔɔzɩ́ ifééri yɩ sɩsɩ: «Mɔ́ɔ́ gɛ Ɩsɔ́ɔ yíko rɩ́ŋa-dʊ́ʊ. Bɩlɛ́ nɛ́, fu ma, nvu toovonúm. ");
INSERT INTO kdh_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Mána nya ɖénɖíi keɖiyá na mava nya lʊrʊ́ʊ ɖabata.» ");
INSERT INTO kdh_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ngɛ Ɩbrám woovu ilóódi-rɔɔzɩ́, ɩbá ɩnyɩ́ɩ́rɛ adɛ. ");
INSERT INTO kdh_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Ngɛ Ɩsɔ́ɔ sɩsɩ: «Mɔ́ɔ́ sɩ malá ɖɛ́dɛ́ɛ keɖiyá kɛḿ kadaá wenbí nɛ́ nɖɔ́: nyánbɩsɩ́ laadásɩ ɖabata-dɛ́ɛ ɩráa ɩjaa kʊ́bɔnɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Bádándayaa nya sɩsɩ Ɩbrám, sɩ bayáa nya gɛ sɩsɩ Ibrahím; káma, ménÿelíi nbɩ́sɩ laadásɩ ɖabata-dɛ́ɛ ɩráa ɩjaa kʊ́bɔnɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ménÿelíi nlʊ́rʊ bɩlʊ́rʊ bɩbá bɩɖɔ́ɔ. Lʊrʊ́ʊ bɩḿ bɩdaá gɛ yíriwá ɖabata sɩ ɩlɩɩná. Badaá ɖʊɖɔ gɛ bɩ́nlɩzɩ́ɩ wúrowá. ");
INSERT INTO kdh_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Mɔ́nɖɔkɩ́ mána nya ɖɛ́dɛ́ɛ keɖiyá kɔcɔ́ɔ bɩlɛ́ mána nya na nyébíya‑bíya ɖɔ́lɔ́wʊ́táá sinje hálɩ ceré. Bɩlɛ́ nɛ́, mɛ́gɛ́ɛ na nyána nyébíya‑bíya mɩ́dɛ́ɛ Ɩsɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Kanáanɩ laadɔ́ɔ nyɔ́jɔɔ́ɔ kadaá ɩgɔ́ńdɩ ɖɔ́ nɛ́, mánváa karɩ́ŋa nyána nyébíya‑bíya, nyɔ́ɔ́gɔ́nɩ nyɔ́wɔ́rɔ́ nɛ́, kabɩ́sɩ bɛdɛ́ɛ ńga sinje hálɩ ceré, bɩka mɛ́gɛ́ɛ bɛdɛ́ɛ Ɩsɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ngɛ Ɩsɔ́ɔ waadásɩ ɩtɔ́ yɩ sɩsɩ: «Nyɔ́ɔ́ nyána nyógutoluú-dɛ bíya, kpɔɔ sinje hálɩ bɩɖɛ́ɛ, ɩɖɔ́kɩ keɖiyá mána mɩ́ɩ ɖééɖí kɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ɖɛ́dɛ́ɛ keɖiyá wɔɔbɔ́ɔ́zɩ wenbí sɩsɩ ɩ́la bɩ nɛ́ nɖɔ́: Mɩ́dáá báa weení gɛ ɩgɛ́ɛ abaalʊ́, bɩɩbɔ́ɔ́zɩ bɛbɛlɩ́ yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Bɛlɩ́ɩ kɛ́ɛ na mána mɩ́ɩ ɖɛ́dɛ́ɛ keɖiyá-dɛ́ɛ ɖaazɩ́tɩ. ");
INSERT INTO kdh_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Kpɔɔná sinje hálɩ míbíya-bíya-jɔ́; bú abaalʊ́ báa weení gɛ baalʊ́rʊ yɩ, ɩdɛ́ɛ wɛ́ lutoozo wɩ́rɛ nɛ́, asée bɛbɛlɩ́ yɩ. Bɩlɛ́ ɖʊɖɔ gɛ yomáa mɩ́ɩ́mʊ́ wɛ bɛdɛkɛ́ɛ mɩ́dɛ́ɛ yíri nɛ́, asée bɛbɛlɩ́ wɛ. ");
INSERT INTO kdh_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Bɛlɩ́ɩ bɩḿ bɩgɛ́ɛ na ɖɛ́dɛ́ɛ keɖiyá-dɛ́ɛ ɖaazɩ́tɩ mɩ́rɩ́ŋa mɩ́dɔnɩ́nɩ-rɔɔzɩ́ sinje hálɩ ceré. ");
INSERT INTO kdh_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","A bɩɩga ɩrʊ́ weení gɛ bɛdɛbɛlɩ́ yɩ nɛ́, wenbí ńŋɩnáa idofu keɖiyá-dɛ́ɛ mará nɛ́, bánlɩzɩ́ɩ yɩ koobíre-daá.» ");
INSERT INTO kdh_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ngɛ Ɩsɔ́ɔ wɔɔdɔ́tɔḿ Ibrahím sɩsɩ: «Lɛlɛɛɖɔ́, nkokúti nÿáa nɖɛɛlʊ́ sɩsɩ Saaráyɩ; yaa yɩ sɩsɩ Saráa. ");
INSERT INTO kdh_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Mánɖʊ́ʊ yɩ alɩbáráka meyéle ɩlʊ́rʊ nya bú abaalʊ́, maɖʊ yɩ alɩbáráka ɩbɩ́sɩ yíriwá ɖabata-dɛ́ɛ ɩráa nize. Ɩdɛ́ɛ lʊrʊ́ʊ-daá, bɩ́ngɔnɩ́ bɩlɩzɩ́ wúrowá.» ");
INSERT INTO kdh_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ibrahím waanɩ́ɩ Ɩsɔ́ɔ waaŋmátɩ yɩ bɩlɛ́ nɛ́, ngɛ waabála ifu ilóódi-rɔɔzɩ́ ɩsála kɔdɔ́ŋa; káma, ɩwɛ wánŋmatɩ́ iwenbiré-daá sɩsɩ: «Mɔ́ɔ́ abaalʊ́ kʊ́bɔnɩ́, mɔ́wɛná bɩ́ɩ́zɩ nɩɩ́nʊ́wá (100) nɛ́, we gɛ sɩ malá na mogúti malʊ́rʊ. Ngʊ́ mɛɖɛɛlʊ́ ɩlɛ́ wáńláḿ ábɔ́nɩ́ ɖʊɖɔ ɩwɛná bɩ́ɩ́zɩ nɩɩ́náázá na saaláa (90). We gɛ sɩ ɩlá na bɔtɔ́ sɩsɩ waalʊ́rʊ bú.» ");
INSERT INTO kdh_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ngɛ Ibrahím woobúsi Ɩsɔ́ɔ sɩsɩ: «Aaa… A bɩgɛ́ɛ nyɔ́ɔ́ɖɔ́kɩ móbú Asʊmáyɩ́la, bɩɩɖɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ngɛ Ɩsɔ́ɔ sɩsɩ: «Aayɩ́, nɖɛɛlʊ́ Saráa wánlʊrʊnáa nya bú abaalʊ́; na nva yɩ yɩ́ɖɛ sɩsɩ Ɩsaáka. Mɔ́nɖɔkɩ́ mána nya ɖɛ́dɛ́ɛ keɖiyá kɔcɔ́ɔ mána yɩ ɖɔ́lɔ́wʊ́táá; kɔcɔ́ɔ bɩlɛ́ hálɩ ibíya-bíya-jɔ́. Keɖiyá kɛḿ, kɛdɛ́ndɛŋ́. ");
INSERT INTO kdh_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Tɩlɛ́ tɩbaasí, sʊlʊ́ńdɩ nyáázʊ́lʊ tɩ Asʊmáyɩ́la-rɔɔzɩ́ nɛ́, máánɩ́ɩ tɩ. Mánɖʊ́ʊ yɩ alɩbáráka ɩlʊ́rʊ bɩlʊ́rʊ páá; wánlʊrʊ́ʊ bíya fuú na nɔɔ́lɛ, babɩ́sɩ wúrowá, bɩka ɩbɩ́sɩ ɩráa zamɔ́ɔ ɩjaa kʊ́bɔnɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Amá, a bɩɩga ɖɛ́dɛ́ɛ keɖiyá, sɩ mɔɖɔ́kɩ kɛ gɛ kɔcɔ́ɔ mána Ɩsaáka ɩmʊ́ ɖɔ́lɔ́wʊ́táá. Sɩ busúlu bɩ́nɩ ńŋɩnáa ɖɔ́ nɛ́ gɛ nɖɛɛlʊ́ Saráa sɩ ɩlʊrʊná nya bú ɩmʊ́.» ");
INSERT INTO kdh_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Sáátɩ wenkí Ɩsɔ́ɔ waaŋmatɩná Ibrahím bɩtɛ́ nɛ́, ngɛ wɛɛɖɛ́ɛ iyéle yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ngɛ Ibrahím wooyóózi ɩ́na ibiyaalʊ́ Asʊmáyɩ́la na yomáa wenbá barɩ́ŋa baalʊ́rʊ wɛ ɩɖaána-daá nɛ́, na wenbá barɩ́ŋa waamʊ wɛ na liideé nɛ́; weení ɩrɩ́ŋa ɩwɛ ɩɖaána-daá gɛ ɩgɛ́ɛ abaalʊ́ nɛ́, ɩbɛlɩ́ wɩ́rɛ ɖɩḿ ńŋɩnáa wenbí Ɩsɔ́ɔ wɔɔdɔ́ yɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ibrahím-dɛ́ɛ bɩ́ɩ́zɩ nɩɩ́nʊ́wá nɛkɛ́rɛ fɛ́yɩ́ (99) gɛ bɛɛbɛlɩ́ yɩ, ");
INSERT INTO kdh_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","bɩɩga ibiyaalʊ́ Asʊmáyɩ́la nɛ́, ɩlɛ́ ɩdɛ́ɛ bɩ́ɩ́zɩ fuú na nasúdoozo gɛ bɛɛbɛlɩ́ yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","27","Sɩ bɛbɛlɩ́ Ibrahím nɛ́, ɩ́na ibiyaalʊ́ Asʊmáyɩ́la na weení ɩrɩ́ŋa ɩdanbá ɩwɛ ɩɖaána-daá ɩgɛ́ɛ abaalʊ́ nɛ́: bɩɩlá ɩdɛ́ɛ yomáa waamʊ wɛ ɩgɔma-jɔ́ nɛ́, na wenbá barɩ́ŋa baalʊ́rʊ wɛ ɩdɛ́ɛ nɛ́ gɛ booyóózi bɛbɛlɩ́ wɩ́rɛ ɖɩḿ. ");
INSERT INTO kdh_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Tɔ́ɔ, wɩ́rɛ bɩjɔɔ́ɔ nɛ́, ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ waadáɖʊʊ ɩlɩ́ɩ Ibrahím-rɔɔzɩ́ Mamɩrée tɩ́ɩ́nɩ kʊ́bɔńdɩ-jɔ́. Bɩdɛ́ɛ wɩ́rɛ ɖɩḿ, ɩdaawʊ́ fifíni sáátɩ, Ibrahím wáńlɩ́ɩ́ ɩjɔɔ́ɔ ijókúre wɔnɔɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Sɩ ɩkʊ́sɩ na ɩbɛ́ɛ ɖɔ́ nɛ́, waana abaaláa noódoozo sɩ́ŋɛ́ɛ bajʊ́ʊ́na yɩ. Waana wɛ nɛ́, ngɛ waanyʊʊ́ ɩkʊrʊ́ itoózi ibó ití isóm ɩsɛ́ɛ wɛ. ");
INSERT INTO kdh_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","4","Ngɛ wɔɔdɔ́ wɛ sɩsɩ: «Kʊ́bɔnáa, ɩlá suúru ɩyɛlɩ́ mɛ́dɛ́ɛ cé na bɔkɔná mɩ́ɩ lɩ́m cʊ́kɔ ɩsáŋ mɩ́nʊvɔ́, bɩka ibó ɩcɔ́ɔ tɩɩwʊ́-dɛ ɩfɛ́ɛ́zɩ. Ɩ́kabá ɩɖɛ́ɛ bɩlɛ́ yéḿ. ");
INSERT INTO kdh_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Mɔ́ngɔnáa mɩ́ɩ kíɖíím iɖi mɩ́dɔnɩ́nɩ ɩkpa ɖóni na bʊcɔ ɩɖɛ́ɛ.» Ngɛ ɩdɛ́ɛ ɩgɔma woobúsi yɩ sɩsɩ: «Tɔ́ɔ, bɩɩlá kazɔ́ɔ; la wenbí nyááŋmátɩ bɩ ɖɔ́ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ńna gɛ Ibrahím wɛɛgbɛdɩ́ ise ɩbɩ́sɩ kɛ́rɛ́ŋɛ-dɛ ifééri ɩɖɛɛlʊ́ Saráa sɩsɩ: «Ɖasam, kpɛdɩ́ njɩrɩ́ mʊlʊ́m kazɔ́ɔ ńbɩ nnúúdi nlá kɩ́kandáárɩ́nɩ natúdoozo.» ");
INSERT INTO kdh_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ngɛ weeze ibó fʊ́ńdɩ kpɩná-daá ɩkálɩ́zɩ́ naavalʊ́ ɩjɔɔ́ɔ núm nɛ́ ɩkɔná yɩ icéle ɩdɛ́ɛ ketíriyɔ́ɔ ɩlɛ́ ɩkʊ iyíízi ituú. ");
INSERT INTO kdh_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Sɔ́m waabɩ́ɩ nɛ́, ngɛ Ibrahím woogózólí bɩ bɩ́na naalɩ́m sitá na naalɩ́m sinje ńbɩ ɩkɔná ɩsɩ́ɩ ɩdɛ́ɛ ɩgɔma. Bɛlɛ́ bɔwɛ bénɖíi nɛ́, ɩmʊ́ ɩwɛ ɩzɩ́ŋɛ́ɛ bɔjɔ́ tɩɩwʊ́-dɛ ńna. ");
INSERT INTO kdh_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ngɛ bɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Nɖɛɛlʊ́ Saráa wɛ lé.» Ngɛ woobúsi wɛ sɩsɩ: «Ɩwɛ bɩsaagɛ́rɛ́ŋɛ-dɛ cé.» ");
INSERT INTO kdh_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ngɛ ɩgɔma-daá naárʊ nɔɔ́ nbɩlɛ́ sɩsɩ: «Sɩ bitósulú bɩ́nɩ ɖɛkɛrɛ-kɛrɛ nɛ́, mángabɩsɩ́; sɩ mɔgɔ́nɩ nɛ́, báa bɩɩlá wé, Saráa wáńlʊ́rʊ́ bú abaalʊ́.» Ɩgɔm ceení wánŋmatɩ́ bɩlɛ́ nɛ́, Saráa sɩ́ŋɛ́ɛ ɩwaalʊ́ wɔ́rɔ́ bɩsaagɛ́rɛ́ŋɛ wɔnɔɔ́ wénwelesí. ");
INSERT INTO kdh_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","12","Waanɩ́ɩ bɩlɛ́ nɛ́, ngɛ waamʊ́ŋ ɩdaá; káma, ɩ́na ɩwaalʊ́ báńláḿ ábɔ́náa, bɩka ɩmʊ́ wáńlɩ́ɩ́ sáa-daá. Ngɛ sɩsɩ: «Mɔ́ɔ́ nɖɔ́ máńláḿ ábɔ́nɩ́, mawaalʊ́ ɖʊɖɔ bɩlɛ́, kɔɖɛyɩ́ wenkí gɛ mándacáádɩ ɖʊɖɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ńna gɛ Ɖádʊ́ʊ wɔɔbɔ́ɔ́zɩ Ibrahím sɩsɩ: «Ngbetíi-rɔɔzɩ́ gɛ Saráa wánmʊŋɛ́. Ngbetíi-rɔɔzɩ́ gɛ wánŋmatɩ́ sɩsɩ ɩmʊ́ waalá ábɔ́nɩ́, ɩmʊ́ waalɩ́ɩ sáa-daá. ");
INSERT INTO kdh_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Nabʊ́rʊ wɛ bɩɩgɩ́lɩ Ɖádʊ́ʊ Ɩsɔ́ɔ nɛ́? Sɩ magábɩsɩ bɩ́nɩ naárʊ ńŋɩnáa ɖɔ́ nɛ́, Saráa wáńlʊ́rʊ́ bú abaalʊ́.» ");
INSERT INTO kdh_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Bɩɩlá Saráa nɩdáárɛ nɛ́, ngɛ wɔɔjɔ́ɔ́lɩ sɩsɩ ɩmʊ́ ɩdamʊ́ŋ. Ngɛ ɩlɛ́ sɩsɩ: «Nyándanjɔɔlɩ́ yéḿ gɛ, nyáámʊ́ŋ.» ");
INSERT INTO kdh_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Bɩɩdɛ́ nɛ́, ngɛ ɩráa bɛḿ baagʊrʊ́ sɩ bɛ́nɖɛɛ́. Sɩ bɛɖɛ́ɛ nɛ́, Sodɔ́ɔmɩ fáráńdɩ́ gɛ baavaná ɩzá. Ngɛ Ibrahím waagʊrʊ́ ɩlɩzɩ́ wɛ nɩ́bááwʊ. ");
INSERT INTO kdh_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ngɛ Ɖádʊ́ʊ sɩsɩ: «Bɩdɔmɔɔná mamʊ́sɩ Ibrahím wenbí sɩ malá bɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Sɩ ɩkɔ́nɩ gɛ ɩbɩ́sɩ yíriwá fɩ́ya ńdɩ ɩjaájaa. Ɩnaa sɩ mabaná maɖʊ ɖúúlínya-dɛ́ɛ yíriwá rɩ́ŋa alɩbáráka. ");
INSERT INTO kdh_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Máálɩ́zɩ́ yɩ gɛ sɩsɩ ɩ́fá ibiyaalɩnáa wɛ́ɖɛ na bofu mɛ́dɛ́ɛ nɩ́bááwʊ ɖéyí-ɖéyí na toovonúm, hálɩ bebíya-bíya-jɔ́, na bʊcɔ malá yɩ wenbí bɩrɩ́ŋa móóɖúu mazɩ́ɩ sɩ malá yɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ sɩsɩ: «Lakásɩ Sodɔ́ɔmɩ na Gomɔ́ɔrɩ ńba waalá gɛ bíngoó nɛ́ kɛ́ɛ tɩtɛ ńzɩ; bɛdɛ́ɛ kidaavééníti waagɩ́lɩ ɖɔɔmɩ́nɩ. ");
INSERT INTO kdh_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Méndím mɛbɛ́ɛ́ŋ sɩsɩ wentí bánŋmatɩ́ bɔrɔɔzɩ́ nɛ́ kɛ́ɛ toovonúm yáá wé; a bɩdɛkɛ́ɛ bɩlɛ́, mánnáa.» ");
INSERT INTO kdh_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ngɛ Ibrahím-dɛ́ɛ ɩgɔma noódoozo bana badaá nɔɔ́lɛ wɔɔgbɔ́ɔ Sodɔ́ɔmɩ nɩ́bááwʊ; Ɖádʊ́ʊ Ɩsɔ́ɔ ɩlɛ́ ɩwalɩ́, bɩka Ibrahím sɩ́ŋɛ́ɛ ɩjɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ńnaamʊ́ gɛ Ibrahím waabá ikóduu ɩbɔ́ɔ́zɩ yɩ sɩsɩ: «Mádʊ́ʊ Ɩsɔ́ɔ, toovonúm nyánba nÿéle sɩ́m ɩkpɔ́ɔ ɩrʊ́ ɩzɩɩzɛ́ɛ nɛ́ na kidaavéénúu bɛlɛ́ɛ́nɩ́? ");
INSERT INTO kdh_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Nabʊ́rʊ, Sodɔ́ɔmɩ tɛ́ɛ́dɩ-daá ńnaamʊ́, bánbɩɩzɩ́ bana ɩráa bazɩɩzɛ́ɛ nɛ́ nyazɩ ɩráa nɛɛ́saaláa (50) bɩlɛ́. A bɩlɛ́ gɛ bʊwɛ, nyénÿelíi sɩ́m iyóózi barɩ́ŋa bɩkpɔ́ɔ? Ɩráa nɛɛ́saaláa bazɩɩzɛ́ɛ nɛ́ bɔrɔɔzɩ́, ńdɛ́njɛḿ tɛ́ɛ́dɩ tɩḿ? ");
INSERT INTO kdh_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Aayɩ́, bɩ́dánbɩɩzɩ bɩlá bɩlɛ́ nÿéle sɩ́m iyóózi bɩkpɔ́ɔ ɩrʊ́ kidaavéénúu na ɩrʊ́ ɩzɩɩzɛ́ɛ nɛ́. Bɩdɔmɔɔná wenbí sɩ bɩlá kidaavéénúu nɛ́ ɩmɔɔná weení ɩzɩɩzɛ́ɛ nɛ́ ɖʊɖɔ. Nyɔ́ɔ́ weení nyánvʊʊnáa ɩráa rɩ́ŋa adɛ laadɔ́ɔ-rɔ nɛ́, nyánbɩɩzɩ́ ńdónvúu wenbí bɩzɩɩzɛ́ɛ nɛ́?» ");
INSERT INTO kdh_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ woobúsi yɩ sɩsɩ: «Tɔ́ɔ, a máábɩ́ɩ́zɩ mana Sodɔ́ɔmɩ ńnaamʊ́ ɩráa bazɩɩzɛ́ɛ nɛ́ batála ɩráa nɛɛ́saaláa (50), mɛ́njɛ́m tɛ́ɛ́dɩ tɩḿ tɩrɩ́ŋa ɩráa bɛḿ bɔrɔɔzɩ́.» ");
INSERT INTO kdh_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ngɛ Ibrahím sɩsɩ: «Mádʊ́ʊ, la ma gááfára, mɔ́ɔ́ weení mɛ́gɛ́ɛ buuruú na tɔɔlɩmá nɛ́, nkɔtɔ́ sɩsɩ mɔ́wɛ mángalɩɩnáa nya tɔ́m. ");
INSERT INTO kdh_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","A badatála nɛɛ́saaláa ngɛ bɛgɛ́ɛ ɩráa nɛɛ́lɛ na nɔɔ́nʊ́wá ní; nɔɔ́nʊ́wá kɩna bɩɩga kɩ na bɩtála nɛ́ kɩrɔɔzɩ́, nyɔ́nÿɔ́m tɛ́ɛ́dɩ rɩ́ŋa?» Ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ sɩsɩ: «A ɖé ɩráa bazɩɩzɛ́ɛ nɛ́ nɛɛ́lɛ na nɔɔ́nʊ́wá wɛ ná, mɔ́dɔ́nÿɔḿ tɛ́ɛ́dɩ tɩḿ.» ");
INSERT INTO kdh_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ibrahím tosú, ɩbamáa; ngɛ sɩsɩ: «Nabʊ́rʊ, ɩráa bazɩɩzɛ́ɛ nɛ́ nɛɛ́lɛ gɛ sɩ nna.» Ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ sɩsɩ: «A ɩráa bazɩɩzɛ́ɛ nɛ́ nɛɛ́lɛ wɛ ná, mádánlaḿ tɩ nabʊ́rʊ.» ");
INSERT INTO kdh_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ngɛ Ibrahím sɩsɩ: «Mádʊ́ʊ, máávɩ́nɩ nya; nkɔkɔ́ nÿɛ́ɛ baaná sɩsɩ mábamáa nya ŋmatɩnáa. Nabʊ́rʊ, a bɩdalá, ɩráa bazɩɩzɛ́ɛ nɛ́ ákoosaaláa wɛ ná.» Ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ sɩsɩ: «Báa bɩlɛ́, mádánlaḿ tɩ nabʊ́rʊ.» ");
INSERT INTO kdh_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ngɛ Ibrahím sɩsɩ: «Nyááwɩ́ɩ mɔ́dɔ́m; nabʊ́rʊ, ɩráa bazɩɩzɛ́ɛ nɛ́ ákoowú wɛ ná.» Ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ sɩsɩ: «A ɩráa ákoowú bazɩɩzɛ́ɛ nɛ́ wɛ ná, mɔ́dɔ́nÿɔḿ tɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ngɛ Ibrahím sɩsɩ: «Mádʊ́ʊ, bɩ́kawɩ́ɩ́zɩ nya, mɛ́dɛ́ɛ ŋmatɩrɛ kegbiirinɔ́ɔ nɖɔ́. Nabʊ́rʊ, ɖánŋmatɩ́ ɖɔ́ nɛ́, ɩráa fuú gɛ bɛgɛ́ɛ.» Ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ sɩsɩ: «Báa bɛgɛ́ɛ fuú, beriké bɔrɔɔzɩ́, mɔ́dɔ́nÿɔḿ tɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ɖádʊ́ʊ na Ibrahím baaŋmátɩ bɩlɛ́ bɩtɛ́ nɛ́, ngɛ ɩlɛ́ waajáŋ ɩɖɛ́ɛ, bɩka Ibrahím ɩlɔ́ɔ ɩbɩ́sɩ ɩdɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ɖaanɩ́ŋa-rɔ bɩlɛ́ gɛ Ɩsɔ́ɔ-dɛ́ɛ malááyɩ́kawá bɛlɛ́ bɛlɛ́ɛ́nɩ́ baadála Sodɔ́ɔmɩ. Bɩlɛ́ bɩdɛ́ɛ sáátɩ, Lɔ́ɔtɩ ɩlɛ́ ɩwɛ ɩjɔɔ́ɔ tɛ́ɛ́dɩ-daá ɖaazʊʊnáɖɛ. Sáátɩ wenkí waajáŋ ikólosi wɛ ɖɔ́ nɛ́, ngɛ waanyʊʊ́ ɩkʊrʊ́ ibó ɩkázɩŋ wɛ. Waadála bɔjɔ́ nɛ́, ngɛ weedí ɩbála ifu adɛ baazá-daá ");
INSERT INTO kdh_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ɩtɔ́ wɛ sɩsɩ: «Kʊ́bɔnáa, máávɩ́nɩ mɩ́ɩ, ɩlá suúru ibó iɖóo mɛ́dɛ́ɛ. Bánváa mɩ́ɩ lɩ́m ɩsáŋ mɩ́nʊvɔ́, bɩka ceré tɛ́ɛrɛ́ nɛ́, ɩlɩ́ɩ ɩkpɔ́ɔ mɩ́nɩ́bááwʊ.» Ngɛ bɛlɛ́ boobúsi yɩ sɩsɩ: «Aayɩ́, ɖánvɩnɩ́ kadɔ́ɔ-daá ɖɔ́.» ");
INSERT INTO kdh_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Amá, Lɔ́ɔtɩ waabá ɩcáárɩ wɛ ɖɔ́, hálɩ bɛtɛ́ betísi basʊ́ʊ ɩdɛ́ɛ. Baadála nɛ́, ngɛ baalá wɛ kíɖíím, balá wɛ kpɔ́nɔ́ kɩ́dángbáa nɛ́, beɖi bɔnyɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Badatanvɩnɩ tá gɛ Sodɔ́ɔmɩ ńba wɔɔgɔ́nɩ balára bamɩlɩná ɖɔɔ́; kpɛdɩ́ ngbɔ́ɔ tɛ́ɛ́dɩ nɔɔ́-nɔɔ́ afobivaláa bɩlɛ́ hálɩ ábɔ́náa wɔɔgɔnɩ ná barɩ́ŋa balára bamɩlɩná ɖɔɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ngɛ baayáa Lɔ́ɔtɩ bɔtɔ́ yɩ sɩsɩ: «Nyɛ́dɛ́ɛ ɩgɔma baazʊ́ʊ nyɛ́dɛ́ɛ cé nuvoowú kɩna nɛ́ bɔwɛ lé, yaa wɛ bakálɩɩ; ɖɔ́zɔɔlɛ́ɛ sɩ ɖiɖooná wɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Ngɛ Lɔ́ɔtɩ waagálɩɩ ɩsɩ́ŋ ɩdɛ́ɛ ɖaḿ wɔnɔɔ́, ɩbɩsɩná tará ɩtɔ; ");
INSERT INTO kdh_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ngɛ wɔɔdɔ́ wɛ sɩsɩ: «Mogoobíya, máávɩ́nɩ mɩ́ɩ, iyéle lakásɩ sɩ ɩlá sɩ ɖɔ́ nɛ́; ");
INSERT INTO kdh_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","mɔ́wɛná aléewá náálɛ badaá naárʊ waasɩ abaalʊ́ nɛ́, mángalɩɩnáa yɛ mejéle mɩ́ɩ ɩlaná yɛ wenbí mɩ́zɔɔlɛ́ɛ nɛ́. Amá, bɩɩga ɩráa abaaláa bɛlɛ́ɛ́nɩ́ baazʊ́ʊ mɔ́jɔ́ ɖɔ́ nɛ́, bɔwɛ mánʊ́ʊ́zɩ-daá gɛ. Bɩlɛ́ nɛ́, ɩ́kalá wɛ nabʊ́rʊ.» ");
INSERT INTO kdh_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ngɛ boobúsi yɩ sɩsɩ: «Lɩɩ ńnaamʊ́; nyɔ́ɔ́ nyɛ́gɛ́ɛ ɩgɔm gɛ nyóógúti nyɔ́zɔɔlɛ́ɛ sɩ nɖi kʊ́bɔńdɩ? A ńdéfére, bɩ́nnɩɩ́ nya bɩkɩ́lɩ wɛ.» Ngɛ bɛɛvɛdɩ́ yɩ ɖóni-ɖóni bacáŋ bɛɖɛ́ɛ sɩ bɔyɔ́ tará. ");
INSERT INTO kdh_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ńna gɛ malááyɩ́kawá bana bɛɛgbɛdɩ́ bɔlɔ nʊ́ʊ́zɩ banára Lɔ́ɔtɩ basʊʊná bɔjɔ́ bokuná tará bɔtɔ. ");
INSERT INTO kdh_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ngɛ baaɖʊ ɩráa bana barɩ́ŋa bazɩ́ŋɛ́ɛ ɖɔɔ́ wɔnɔɔ́-jɔ́ nɛ́ njɛ́ńdɩ; kpɔɔ bíya hálɩ kʊ́bɔnáa, badabɩ́ɩ́zɩ bacáa bana ɖaḿ wɔnɔɔ́ ɖɩdáarɛ. ");
INSERT INTO kdh_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ngɛ malááyɩ́kawá bana bɛlɛ́ɛ́nɩ́ bɔɔbɔ́ɔ́zɩ Lɔ́ɔtɩ sɩsɩ: «Nyóógúti nyɔ́wɛná naárʊ ɩgɛ́ɛ ngoobú ɩwɛ tɛ́ɛ́dɩ-daá cé yáá wé: bɩɩlá nbiyaalɩnáa, nwɛɛlɩnáa, yáá nmɩɩdɩnáa; wenbí bɩrɩ́ŋa nyádanwɛná bɩ bʊwɛ tɛ́ɛ́dɩ tɩna tɩdaá nɛ́, bɩrɩ́ŋa bɩ́lɩɩ tɛ́ɛ́dɩ. ");
INSERT INTO kdh_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Ɖɔ́zɔɔlɛ́ɛ sɩ ɖɩyɔ́ tɩ. Wenbí bóngoó tɩdɛ́ɛ kidaavééníti lám nɛ́ waagɩ́lɩ ɖɔɔmɩ́nɩ Ɩsɔ́ɔ ɩzá-daá. Bʊrɔɔzɩ́ Ɖádʊ́ʊ Ɩsɔ́ɔ weegédíri ɖáa sɩsɩ ɖɩ́kɔnɩ ɖɩyɔ́ tɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ngɛ Lɔ́ɔtɩ waalɩ́ɩ ibó ɩtɔ́ ɩmɩɩdɩnáa sɩsɩ: «Ɩgʊrʊ́ ɖasam ɩlɩ́ɩ tɛ́ɛ́dɩ, Ɖádʊ́ʊ Ɩsɔ́ɔ sɔɔlɛ́ɛ sɩ ɩyɔ́ tɩ.» Waaŋmátɩ bɛlɛ́ bɩlɛ́ nɛ́, bɛlɛ́ bɔjɔɔ́ɔ sɩsɩ abɩɩla gɛ wánlám. ");
INSERT INTO kdh_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Kɩɩgbɛdɩ́ sɩ kifé asʊbáa-daá bɩlɛ́ gɛ malááyɩ́kawá bana bɛlɛ́ɛ́nɩ́ baajáárɩ Lɔ́ɔtɩ kpiti‑kpiti sɩsɩ: «Nyɔ́ɔ́ kʊrʊ́ ngbɔ́ɔ nɖɛɛlʊ́ na nwɛɛlɩnáa lɛ́ɛ́nɩ́ ɩlɩ́ɩ tɛ́ɛ́dɩ ɖasam, tɩdɛ́ɛ aleesi ɩ́kɔmɔɔná nya.» ");
INSERT INTO kdh_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Baaŋmátɩ yɩ bɩlɛ́ nɛ́, igúti ɩjɔɔ́ɔ wɛ́njɛɛnɩ́; Ɖádʊ́ʊ Ɩsɔ́ɔ sɔɔlɛ́ɛ sɩ ɩlɛ́ɛ wɛ nɛ́, ngɛ bɛlɛ́ bɔɔɖɔ́kɩ ɩ́na ɩɖɛɛlʊ́ na ɩwɛɛlɩnáa banʊ́ʊ́zɩ-daá balɩɩná wɛ tɛ́ɛ́dɩ wɔ́rɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Sáátɩ wenkí baalɩɩná wɛ tɛ́ɛ́dɩ wɔ́rɔ́ bɩtɛ́ nɛ́, ngɛ malááyɩ́kawá bɛḿ badaá naárʊ wɔɔdɔ́ Lɔ́ɔtɩ sɩsɩ: «Ba nbá nze, bɩlɛ́ɛ nyéweezuú. A nyénzée, nkɛkɛ́ɛ́zɩ nbɛ́ɛ́ŋ nyɔ́wɔ́rɔ́, ngʊ́ nkasɩ́ŋ ɖeelí, hálɩ bʊ́ʊ-daá. A bɩdɛkɛ́ɛ bɩlɛ́, bɩ́ngbɛdɩ́na nya.» ");
INSERT INTO kdh_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ngɛ Lɔ́ɔtɩ sɩsɩ: «Aayɩ́ yoo, Mádʊ́ʊ, máávɩ́nɩ nya. ");
INSERT INTO kdh_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Toovonúm, mányɩ sɩ nyééwíi ná mɔ́rɔ́ nbá nlá ɩrʊ́tɩ nlɛ́ɛ ma, amá, mɔgbɔ́ɔ ɖɔ́ sɩ magádála bʊ́ʊ, aleesi kɩna kɩ́nmɔɔnáa ma nɩ́bááwʊ mazɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Nyááná tɛ́ɛ́dɩyɔ́ɔ tɩna, ńdáná sɩsɩ tɩdɔɖɔ́ɔ? Tɩlɛ́ tɩjʊ́ʊ́na bɩkɩ́lɩ; bɩlɛ́ nɛ́, yele meze mobó ńna bɩlɛ́ɛ ma.» ");
INSERT INTO kdh_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Wɔɔdɔ́ bɩlɛ́ nɛ́ gɛ tɩndʊ́ʊ sɩsɩ: «Tɔ́ɔ, méédísi ɖʊɖɔ; mɔ́dɔ́ndɔyɔḿ tɛ́ɛ́dɩ nyánŋmatɩ́ tɩdɔ́m ɖɔ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","La ɖasam nze; a ńdatala tá nzʊ́ʊ ńnaamʊ́, mádánbɩɩzɩ malá nabʊ́rʊ.» Wenbí bʊrɔɔzɩ́ baava tɛ́ɛ́dɩ tɩḿ yɩ́ɖɛ sɩsɩ Sowáarɩ nɛ́ nbɩlɛ́; bugutoluú sɩsɩ mádáázá. ");
INSERT INTO kdh_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Wɩ́sɩ wɛɛgbɛdɩ́ sɩkɔ́dɔ́ sɩdɩ bɩlɛ́ nɛ́ gɛ Lɔ́ɔtɩ waadála ɩsʊ́ʊ Sowáarɩ tɛ́ɛ́dɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ńna gɛ Ɖádʊ́ʊ Ɩsɔ́ɔ weeyéle fáráwíítá nimíni ɩlɩ́ɩ ɩsɔ́ɔ́dáá ɩnɩ́ɩ nyazɩ tɛ́ɛ́wʊ bɩlɛ́ Sodɔ́ɔmɩ na Gomɔ́ɔrɩ tɛ́ɛ́dɩwá-rɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Weeyéle tɛ́ɛ́dɩ tɩḿ tɩlɛ́ɛ́nɩ́ na tɩdɛ́ɛ zamɔ́ɔ na bɔkɩrɛ rɩ́ŋa na wenbí bɩrɩ́ŋa bɩɩnyɔ adɛ-bú-rɔ nɛ́ binúúdi cɩ́rɩ́-cɩ́rɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Lɔ́ɔtɩ ɖɛɛlʊ́ ɩlɛ́ ɩbamáa ɖɛɛ́ nɛ́, ngɛ waazɩ́ŋ ɩkɛ́ɛ́zɩ ɩdɩ, ɩbɛ́ɛ́ŋ ɩwɔ́rɔ́. Ńna‑ńna gɛ waajáŋ ɩbɩ́sɩ ɖɔ́ḿbʊ́ʊ́rɛ. ");
INSERT INTO kdh_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Kiivé asʊbáa bɩlɛ́ gɛ Ibrahím wɔɔjɔ́ɔ́rɩ ibó lénlé ɩ́na Ɖádʊ́ʊ Ɩsɔ́ɔ bavʊnzɩ́ŋɛ́ɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Waadála ńna gɛ wɛɛgɛ́ɛ́zɩ ɩbɛ́ɛ́ŋ Sodɔ́ɔmɩ na Gomɔ́ɔrɩ bɛdɛ́ɛ́dɩ na bɩdɛ́ɛ bɔkɩrɛ rɩ́ŋa-daá nɛ́, wánnáa nyɔ́ɔ́zɩ nyazɩ nimíni nyɔ́ɔ́zɩ kadaaleŋa kɛḿ kadaá. ");
INSERT INTO kdh_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ɩsɔ́ɔ wɔɔyɔ́ bɔkɩrɛ lénlé Lɔ́ɔtɩ wɔɔjɔɔná nɛ́ bɩdɛ́ɛ́dɩwá bɩtɛ́ nɛ́, ɩdɔsɔ́ɔ Ibrahím-rɔɔzɩ́, waalɩzɩ́ Lɔ́ɔtɩ aleesi kɩḿ kɩdaá. ");
INSERT INTO kdh_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Sowáarɩ tɛ́ɛ́dɩ-daá cɔɔ́ɔ Lɔ́ɔtɩ nɩdáárɛ cɔwʊ́ʊ. Ngɛ wɔɔgbɔ́ɔ ɩdɛ́ɛ aléewá lɛ́ɛ́nɩ́ balɩ́ɩ tɩdaá bɛɖɛ́ɛ bakpa bʊ́ʊ-daá bɔkɔ́jɔ́ɔ. Baadála bʊ́ʊ-daá nɛ́, bʊ́tangbalʊʊ́ nakɩ́rɩ-dɛ́ɛ bɔɔwʊ́-daá gɛ bɔɔjɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Wɩ́rɛ bɩjɔɔ́ɔ nɛ́, ngɛ ɩwɛɛlɩnáa bɛḿ badaá kaáwʊ wɔɔdɔ́ newúu sɩsɩ: «Ɖájaa cɔɔ́ɔ ɖɔ́ nɛ́, waalá ábɔ́nɩ́ nbɩlɛ́, ngʊ́ abaalʊ́ naárʊ fɛ́yɩ́ fáráńdɩ́-daá cé sɩ ɖɩsáa yɩ ńŋɩnáa bánlám báa lé nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Bɩlɛ́ nɛ́, yele ɖibó ɖɩfa yɩ sʊlʊ́m ɩnyɔ́ɔ; a bɩɩɖɛ́ɛ́zɩ yɩ, ɖibó ɖána yɩ ɖuɖóo, bɩka ɖʊlʊ́rʊ yɩ bíya ɖɩsɩ́ɩ ceré wɔ́rɔ́.» ");
INSERT INTO kdh_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ɖaanɩ́ŋa kɛḿ gɛ baava bajaa sʊlʊ́m ɩnyɔ́ɔ. Ngɛ kaáwʊ waazʊ́ʊ ɩ́na yɩ bafɩ́nɩ, bɩka caáwʊ tatɩlɩ́ sɩsɩ nabʊ́rʊ waalá; ɩdana ɩwɛɛlɛ́ɛ-dɛ́ɛ sʊʊ́, ngʊ́ ɩdana ɩlɩɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Kiivé nɛ́, ngɛ kaáwʊ ɩmʊ́ wɔɔdɔ́ inewú sɩsɩ: «Nyááná, keɖee mána yɩ ɖóóɖóo; bɩlɛ́ nɛ́, ɖaanɩ́ŋa kana ɖʊɖɔ ɖɩ́fá yɩ sʊlʊ́m, na nyɔ́ɔ́ ɖʊɖɔ nzʊ́ʊ ɩjɔ́; bɩka ɖiyuú ɖʊlʊ́rʊ yɩ bíya ɖɩsɩ́ɩ ceré.» ");
INSERT INTO kdh_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ngɛ baadáfáa bajaa sʊlʊ́m ɖaanɩ́ŋa kɛḿ kɔrɔ ɩnyɔ́ɔ. Ngɛ newúu waazʊ́ʊ ɩjɔ́ ɩ́na yɩ boɖóo, bɩka ɩdatɩlɩ́ sɩsɩ nabʊ́rʊ waalá; ɩdana ɩwɛɛlɛ́ɛ ɩmʊ́ ɩdɛ́ɛ sʊʊ́, ngʊ́ ɩdana ɩlɩɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Bíya aléewá bana bɛlɛ́ɛ́nɩ́ bána bajaa baavɩ́nɩ nɛ́, ngɛ baamʊ fúúzi. ");
INSERT INTO kdh_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Kaáwʊ ɩlɛ́ ɩkɔ́nɩ ɩlʊ́rʊ bú abaalʊ́. Ngɛ waava yɩ yɩ́ɖɛ sɩsɩ Mowáabɩ. Ɩlɛ́ ɩnáábɩ́lɛ́ sinje Mowáabɩ ńba ɩjaájaa kʊ́bɔnɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Newúu ɩlɛ́ ɖʊɖɔ waalʊ́rʊ bú abaalʊ́, ngɛ waava yɩ yɩ́ɖɛ sɩsɩ Ben‑Ami; sinje Amɔ́ɔnɩ ńba ɩjaájaa kʊ́bɔnɩ́ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ngɛ Ibrahím waagbɩ́ɩ́rɩ ɩkʊrʊ́ lénlé ɩwɛ nɛ́ ɩbɩsɩná Negɛ́ɛvɩ fáráńdɩ́. Waadála fáráńdɩ́ kɩḿ kɩdaá nɛ́, Kadɛ́ɛsɩ na Súuri bɔlɔwʊtáá gɛ woozúu; bɩka ibó ɩgɔwɛ Gɩráarɩ. ");
INSERT INTO kdh_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ibrahím wángʊrʊ́ʊ sɩ ɩŋmátɩ ɩɖɛɛlʊ́ Saráa-dɛ́ɛ tɔ́m nɛ́, wɔ́ndɔ́m gɛ sɩsɩ: Ménewú nbɩlɛ́. Gɩráarɩ wúro Abɩmelɛ́ɛkɩ waanɩ́ɩ sɩsɩ inewú gɛ Saráa nɛ́, ngɛ ɩlɛ́ weeyéle bɔkɔ́nɩ bakpa yɩ saarɩ́tɩ boboná yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Nuvoowú ɖoozire-daá gɛ Ɩsɔ́ɔ waaɖʊ ɩlɩ́ɩ wúro Abɩmelɛ́ɛkɩ ɩmʊ́ ɩrɔɔzɩ́ ɩtɔ́ yɩ sɩsɩ: «Alʊ́ nyɔ́ɔ́gbɔ́ɔ yɩ ɖɔ́ nɛ́ ɩrɔɔzɩ́, nyánzɩ́m; káma, ɩgɛ́ɛ alʊ́ ɩzáána nɛ́ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ngʊ́ wúro Abɩmelɛ́ɛkɩ tetekiná ta Saráa ɩmʊ́. Ngɛ sɩsɩ: «Mádʊ́ʊ, mána mɛ́dɛ́ɛ ɩyáálɩ ɖáásɩ natɩ́rɩ, bɩlɛ́ nɛ́, nyénÿelíi ɖáa ɖɩsɩ́? ");
INSERT INTO kdh_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ibrahím ɩmʊ́ weeveeri ná ma sɩsɩ inewú gɛ, bɩka alʊ́ ɖʊɖɔ itísi ma sɩsɩ ɩmʊ́ ɩɖawaalʊ gɛ. Wenbí máálá nɛ́, mádáná lénlé mááyɩ́sɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ɖoozire ɖɩḿ ɖɩdaá gɛ Ɩsɔ́ɔ woobúsi yɩ sɩsɩ: «Mɔ́ɔ́ mádɩtɩŋa mányɩ sɩsɩ wenbí nyáálá nɛ́, na wenbiré kʊ́ɖʊńɖɛ gɛ nyáálá ná bɩrɩ́ŋa. Mɔ́ɔ́ méégbí ná nya sɩsɩ nkalá nabʊ́rʊ nÿɩsɩná ma. Bɩlɛ́ bʊrɔ gɛ médéyéle ndáńdekiná yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Kpɛdɩ́ ngbɔ́ɔ alʊ́ ɩmʊ́ nbɩsɩná njéle ɩwaalʊ́ lɛlɛɛkɩna. Ɩwaalʊ́ ɩmʊ́ ɩgɛ́ɛ anɖébi gɛ. Sɩ ɩsʊlʊ ná Ɩsɔ́ɔ nyɔ́rɔ́ɔ́zɩ́ na nÿuú weezuú. Amá, a nyéégízi ńdábɩ́sɩ́ná yɩ njéle ɩwaalʊ́, tɩlɩ́ sɩsɩ nyána nyɛ́dɛ́ɛ zamɔ́ɔ mɩ́nzɩ́m.» ");
INSERT INTO kdh_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Kiivé nɛ́, ngɛ wúro Abɩmelɛ́ɛkɩ waalɩ́ɩ tɛ́ɛrɛ́ itúúzi ɩdɛ́ɛ awóronbíya ɩkpɔ́ɔ bɩlɛ́ ɩtɩ́ ifééri wɛ. Ngɛ tɔ́m tɩḿ tɩɩbá tɩsʊ́ʊ́zɩ bɛlɛ́ kaanɩŋá. ");
INSERT INTO kdh_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Ngɛ weeyéle bakáya Ibrahím ɖʊɖɔ. Wɔɔgɔ́nɩ nɛ́, ngɛ wúro ɩmʊ́ wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Ngbetíi lakásɩ gɛ nyáábá nlá ɖáa bɩlɛ́. Taalɩ́ wenkí gɛ máábá malá nya gɛ nyáábá nÿéle mána mɛ́dɛ́ɛ tɛ́ɛ́dɩ-daá ɩráa sɩ ɖɩlá kidaavééníti tɩna. Bɩdɔmɔɔná ɩrʊ́ ɩlá ńŋɩnáa wenbí nyáálá ma nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Wentí gɛ nyáámáázɩ gɛ nyáálá bɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ngɛ Ibrahím woobúsi yɩ sɩsɩ: «Mɔ́jɔɔ́ɔ gɛ sɩsɩ ńŋɩnáa ɖɔ́ bɩdɛkɛ́ɛ ɩráa wénzewɔ́ɔ Ɩsɔ́ɔ fáráńdɩ́ kɩna kɩdaá; mɛɖɛɛlʊ́-rɔɔzɩ́, sɩ bɔkɔ́nɩ gɛ bakʊ ma. ");
INSERT INTO kdh_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Na ngʊ́ nbɛ́ɛ ɖʊɖɔ nɛ́, ménewú gɛ ɩgɛ́ɛ, mána yɩ caáwʊ kʊ́ɖʊḿ gɛ, kɔɔnáa gɛ ɖɛ́dɛ́kpɛ́dɩ́; ngɛ mɔ́ɔ́gbɔ́ɔ yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ɖoo Ɩsɔ́ɔ yelíi magágʊ́rʊ́ majaa-dɛ́ɛ mazʊ́ʊ kisɔɔ́ kana ɖɔ́, máávʊ́ńdɔḿ Saráa gɛ sɩsɩ báa lé gɛ ɖáádála, ɩ́la isóórómíti ɩtɔ́ sɩsɩ ɩɖawaalʊ gɛ ma.» ");
INSERT INTO kdh_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ńna gɛ wúro Abɩmelɛ́ɛkɩ waajáa fééni, namɩ́nɩ, náánɩ, na yomáa aláa na abaaláa ɩfa yɩ, ɩcáŋ ɩkpɔ́ɔ ɩɖɛɛlʊ́ Saráa ɩbɩsɩná icéle yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ngɛ wɔɔdɔ́ yɩ sɩsɩ: «Máláádɔ́ɔ nyɛ́bɛɛ́na kɛ ɖɔ́ nɛ́, bɛɛŋ lé bɩ́nlám nya nɛ́ njɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ngɛ wɔɔdɔ́ Saráa sɩsɩ: «Bɛɛ! Liideé jɩtɔ́ɔ mííli mééjéle nɖawaalʊ nɛ́, agɛ́ɛ na kʊ seríya wenbá bajʊ́ʊ́na nya nɛ́ bɔjɔ́ sɩsɩ ńdáyɩ́sɩ natɩ́rɩ tɔ́m tɩna tɩdaá bɩka baɖʊ nya gírímá.» ");
INSERT INTO kdh_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Ibrahím ɖɛɛlʊ́ Saráa-dɛ́ɛ tɔ́m tɩna tɩrɔɔzɩ́, Ɖádʊ́ʊ Ɩsɔ́ɔ waabɩsɩná aláa wenbá bɔwɛ wúro Abɩmelɛ́ɛkɩ-dɛ́ɛ nɛ́ kaalʊrʊ́sɩ. Ngɛ Ibrahím waazʊ́lʊ Ɩsɔ́ɔ wúro Abɩmelɛ́ɛkɩ-rɔɔzɩ́, na ɩɖɛɛlʊ́ na ɩdɛ́ɛ bɔwʊtá-dɩnáa bɔrɔ. Ngɛ aláa waadábɩ́sɩ álʊ́rʊ́ɖáa. ");
INSERT INTO kdh_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Bɩjɔɔ́ɔ nɛ́, ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ wɔɔdɔ́ɔ́zɩ Saráa-rɔɔzɩ́ ɩlá yɩ wenbí waavʊ́ńdɔḿ yɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Ngɛ wɛɛyɛ́ɛ fuwá ɩlʊ́rʊ Ibrahím-dɛ́ɛ ábɔɔ‑bú abaalʊ́ alɩwáátɩ Ɩsɔ́ɔ waavʊ́ńzɩɩ yɩ kɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ngɛ Ibrahím waava bú Saráa waalʊ́rʊ nɛ́ yɩ́ɖɛ sɩsɩ Ɩsaáka. ");
INSERT INTO kdh_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Bú ɩmʊ́ waalá wɛ́ lutoozo nɛ́, ngɛ wɛɛbɛlɩ́ yɩ ńŋɩnáa wenbí Ɩsɔ́ɔ waavʊ́ńdɔḿ yɩ bɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Baalʊ́rʊ Ɩsaáka nɛ́, ɩjaa wɛná bɩ́ɩ́zɩ nɩɩ́nʊ́wá (100). ");
INSERT INTO kdh_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ngɛ Saráa wɔɔdɔ́ sɩsɩ: «Ɩsɔ́ɔ waagʊ ma kɔdɔ́ŋa. Wenbá barɩ́ŋa bánnɩɩ́ sɩsɩ máálʊ́rʊ Ɩsaáka nɛ́, bɛlɛ́ ɖʊɖɔ sɩ basála kɔdɔ́ŋa gɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ngɛ sɩsɩ: «A naárʊ waabá ifééri Ibrahím sɩsɩ mɔ́ɔ́ Saráa, bú wɔ́ngɔnɩ́ ɩmʊ́zʊ ma, ítetísi; na bɩrɩ́ŋa bɩlɛ́, mɛ́ɛ́dɛ́ malʊ́rʊ yɩ bú abaalʊ́ ɩdɛ́ɛ ábɔńdɩ-daá.» ");
INSERT INTO kdh_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Bɩɩgɔ́nɩ bʊwɛ nɛ́, Ɩsaáka waabɩ́ɩ. Sáátɩ wenkí ɩgɔɔ wɛɛjɛ́ yɩ yɩ́lɛ nɛ́, ngɛ ɩjaa waabá iɖi jíńgáárɩ́ kʊ́bɔńgɩ. ");
INSERT INTO kdh_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ńna gɛ Saráa waana Mɩ́sɩra alʊ́ Agáarɩ-dɛ́ɛ bú Asʊmáyɩ́la wánbɩɩlɩ́ Ɩsaáka. ");
INSERT INTO kdh_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Ngɛ woobó ifééri ɩwaalʊ́ Ibrahím sɩsɩ: «Ɖɔɔ yoḿ ceení na ibiyaalʊ́ balɩ́ɩ cé. Ibú tɔmɔɔná ɩ́na móbú Ɩsaáka boyóózi beɖi nyédííbí.» ");
INSERT INTO kdh_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Tɔ́m tɩna tɩɩbá tɩcáárɩ Ibrahím ɖɔ́ páá. Wenbí bʊrɔɔzɩ́ nɛ́, Asʊmáyɩ́la ɖʊɖɔ kɛ́ɛ ibú gɛ. ");
INSERT INTO kdh_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Amá, Ɩsɔ́ɔ sɩ ɩtɔ́ yɩ wentí nɛ́ gɛ sɩsɩ: «Nyɛ́dɛ́ɛ yoḿ na ibiyaalʊ́ bɛdɛ́ɛ tɔ́m ɩ́kacáárɩ nya. Kpɛdɩ́ nvu nlá wenbí nɖɛɛlʊ́ Saráa wɔɔdɔ́ nya bɩ nɛ́. Káma, Ɩsaáka-dɛ́ɛ lʊrʊ́ʊ-daá gɛ lʊrʊ́ʊ wenkí kɩgɛ́ɛ nyɛ́dɛ́ɛ ńgɩ nɛ́ sɩ kɩlɩɩná. ");
INSERT INTO kdh_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Bɩlɛ́ ɖʊɖɔ gɛ sɩ meyéle nyɛ́dɛ́ɛ yoḿ-dɛ́ɛ bú ɩlʊ́rʊ bɩlʊ́rʊ bɩbɩ́sɩ yíri. Káma, nyádɩɩná yɩ ɖʊɖɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Kiivé asʊbáa nɛ́, ngɛ Ibrahím wɔɔjɔ́ɔ́rɩ ɩlɩ́ɩ ɩcáa kíɖíím, ɩcɩrɩ́ lɩ́m isúu jɔlɔ ɩsɛlɩ́ icéle Agáarɩ; ɩkpɔ́ɔ ibú ɖʊɖɔ icéle yɩ ɩcáŋ ɩɖɔ́ɔ yɩ ɖaána. Ɩlɛ́ waagʊrʊ́ nɛ́, hálɩ Bɛrɩsebáa tɛɛwʊ́lɔ́ɔ́-daá gɛ woobó wɛ́nÿɛrɛ́tɩ. ");
INSERT INTO kdh_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ɩbamáa yɛrɛ́tɩ gɛ jɔlɔ-daá lɩ́m wɛɛdɛ́. Ngɛ wooboná ibú ɩfɩ́ɩ́zɩ tiyɔ́ɔ nɛkɛ́rɛ-dɛ; ");
INSERT INTO kdh_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","bɩka ɩmʊ́ itorí ɩdɩ ɩ́na ibú bɔjɔɔ́na ɖamá bolíni nyazɩ bɔ́ndɔ́ɔ tɔ́ɔ́wʊ nyɩmɛ́rɛ na ɖɩkázála nɛ́-dɛ́ɛ bolíni. Ɩ́dánjaa ɩna ibú-dɛ́ɛ sɩ́m. Kpɔ́mɔ́ɔ́ ńna bɩlɛ́ gɛ ɩgɔjɔɔ́ɔ gɛ waabáázɩ wíídi. ");
INSERT INTO kdh_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Bú wénwií ɖʊɖɔ nɛ́, Ɩsɔ́ɔ waanɩ́ɩ. Ngɛ malááyɩ́ka woogógoo ɖoo ɩsɔ́ɔ́dáá ɩyáa Agáarɩ ɩtɔ́ yɩ sɩsɩ: «Ngbaalá nya, Agáarɩ. Nkakʊ́sɩ nyéwenbiré, Ɩsɔ́ɔ waanɩ́ɩ nyóbú tɛ́nɩ lé ɩwɛ ɖɔ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Kʊrʊ́ nbó nzɛlɩ́ yɩ adɛ bɩka nɖɔ́kɩ yɩ; sɩ meyéle gɛ ɩbá ɩkɔ́nɩ ɩlʊ́rʊ bɩlʊ́rʊ bɩbɩ́sɩ yíri.» ");
INSERT INTO kdh_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ngɛ Ɩsɔ́ɔ woovulú waazá-rɔ ɩna lɔkɔ lɩ́m wɛ kɩdaá nɛ́. Ngɛ woobó ilu ɩɖʊ ɩdɛ́ɛ jɔlɔ-daá, ɩfa ibú ɩlɛ́ ɩnyɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ngɛ Ɩsɔ́ɔ waazɩná bú ceení tɛɛwʊ́lɔ́ɔ́-daá ńnaamʊ́, hálɩ ɩbɩ́ɩ ɩlá ɩrʊ́, ɩkɔ́nɩ ɩbɩ́sɩ tɔ́ɔ́wʊ tɔɔrʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Paráanɩ tɛɛwʊ́lɔ́ɔ́-daá ńnaamʊ́ gɛ bɔɔjɔ́ɔ, hálɩ ɩgɔɔ ɩcáa Mɩ́sɩra alʊ́ ɩfa yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Bɩdɛ́ɛ sáátɩ gɛ wúro Abɩmelɛ́ɛkɩ na ɩdɛ́ɛ sɔ́ɔ́jawá-dɛ́ɛ kʊ́bɔnɩ́ Pɩkɔ́ɔlɩ bɔɔgɔ́nɩ Ibrahím-jɔ́ bɔtɔ́ yɩ sɩsɩ: «Ɩsɔ́ɔ sɩ́ŋɛ́ɛ nyɔ́wɔ́rɔ́ wenbí bɩrɩ́ŋa nyánlám nɛ́ bɩdaá. ");
INSERT INTO kdh_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Bɩlɛ́ nɛ́, lɛlɛɛɖɔ́, mʊná Ɩsɔ́ɔ sɩsɩ ńdánlɩɩ mɔ́wɔ́rɔ́ yáá mébíya na mógutoluú-dɛ bíya wɔ́rɔ́. Wenbí ńŋɩnáa mɔ́ɔ́ɖɔ́kɩ́ná nya na wenbiré kʊ́ɖʊńɖɛ nɛ́, bɩlɛ́ gɛ nyɔ́nɖɔkɩ́ mána tɛ́ɛ́dɩ nyɔ́jɔɔ́ɔ tɩdaá ɩgɔ́ńdɩ ɖɔ́ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ngɛ Ibrahím sɩsɩ: «Máámʊ́ná.» ");
INSERT INTO kdh_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Wúro Abɩmelɛ́ɛkɩ-dɛ́ɛ tɩmɛlanɖáa waavʊ́ńlɛɛ lɔkɔ nakɩ́rɩ ɖóni-ɖóni; ngɛ Ibrahím waajáŋ iyooná yɩ tɩrɔ. ");
INSERT INTO kdh_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ngɛ wúro Abɩmelɛ́ɛkɩ woobúsi yɩ sɩsɩ: «Mɔ́ɔ́ mádábá madɩlɩ́ weení waalá lakásɩ sɩḿ bɩlɛ́ nɛ́, ngʊ́ ńdéfééri ma tɩ, a bɩdɛkɛ́ɛ sinje nyánŋmatɩ́ ɖɔ́.» ");
INSERT INTO kdh_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ńna gɛ Ibrahím waalɩzɩ́ fééni, na namɩ́nɩ, na náánɩ ɩfa yɩ; bacáŋ beɖi keɖiyá. ");
INSERT INTO kdh_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Bʊwɔ́rɔ́ nɛ́, ngɛ Ibrahím woogúti ɩlɩzɩ́ fééni aláa lʊbɛ ɩsɩ́ɩ kpɔ́mɔ́ɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ngɛ wúro Abɩmelɛ́ɛkɩ wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Fééni wentí gɛ nyáálɩ́zɩ́ nzɩ́ɩ kpɔ́mɔ́ɔ́ ɖɔ́.» ");
INSERT INTO kdh_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ngɛ ɩlɛ́ woobúsi yɩ sɩsɩ: «A nyéédísi nmʊ fééni tɩna mɛ́ńdɛ́, sɩ tɩwɩlɩ ná seríya sɩsɩ toovonúm máábáa ná lɔkɔ kɩḿ.» ");
INSERT INTO kdh_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ngɛ bɛlɛ́ɛ́nɩ́ baajáŋ boɖuuná ɖamá ɖɩdáarɛ ɖɩḿ ɖɩdaá, bʊrɔ gɛ bánÿaá lɔkɔ kɩḿ kɩɖɩdáarɛ sɩsɩ Bɛrɩsebáa. ");
INSERT INTO kdh_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Tɔ́ɔ, Bɛrɩsebáa ńnaamʊ́ gɛ beeɖi keɖiyá. Bɩɩdɛ́ nɛ́, ngɛ wúro Abɩmelɛ́ɛkɩ na ɩdɛ́ɛ sɔ́ɔ́jawá-dɛ́ɛ kʊ́bɔnɩ́ Pɩkɔ́ɔlɩ bɛlɛ́ baazɩ́ŋ babɩ́sɩ Filisitíi ńba-dɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ibrahím wɔɔzɔ tiyɔ́ɔ kaabá kándáa, kénleerí nɛ́ Bɛrɩsebáa ńnaamʊ́ ɩyáa Ɖádʊ́ʊ Ɩsɔ́ɔ yɩ́ɖɛ ɩtɔ́ sɩsɩ: «Ɩsɔ́ɔ nyɔ́wɛ sinje hálɩ ceré nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ngɛ wɔɔjɔ́ɔ Filisitíi ńba-dɛ́ɛ bilééri. ");
INSERT INTO kdh_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Bʊwɔ́rɔ́ nɛ́, ngɛ Ɩsɔ́ɔ sɩsɩ ɩmʊ́ wánɖaazɩ́ Ibrahím na ɩbɛ́ɛ. Ngɛ sɩsɩ: «Ibrahím wɛ lé.» Ngɛ Ibrahím sɩsɩ: «Mánááɖɔ́.» ");
INSERT INTO kdh_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ngɛ Ɩsɔ́ɔ sɩsɩ: «Kpɔɔ nyágʊ́ɖʊmɔ́ɔ Ɩsaáka nyɔ́zɔɔlɛ́ɛ yɩ nɛ́ nboná Moriyáa laadɔ́ɔ-daá. A nyáádála, mánwɩlɩ́ɩ nya bʊ́ʊ nakɩ́rɩ, kɩrɔɔzɩ́ gɛ nyɔ́ngbɔwʊ́ʊ nyóbú ɩmʊ́ nlá ma sarɔ́ɔ keɖe kanyɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Kiivé nɛ́, ngɛ Ibrahím wɔɔjɔ́ɔ́rɩ ɩlɩ́ɩ ɩkpɩ́ɩ́rɩ ɩdɛ́ɛ kpangbɔ́ɔ, ɩkpɔ́ɔ ɩdɩmɛlanɖáa nɔɔ́lɛ na ibiyaalʊ́ Ɩsaáka, ɩfɛ́ɛ sarɔ́ɔ ɖáázɩ sɩ ɩkáláná sarɔ́ɔ nɛ́, bɔkpɔ́ɔ lé Ɩsɔ́ɔ waawɩ́lɩ yɩ nɛ́-dɛ́ɛ nɩ́bááwʊ. ");
INSERT INTO kdh_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Wɛ́ náádoozo wɩ́rɛ nɛ́, Ibrahím waagbáázɩ waazá nɛ́, woogólosi bɩɖɩdáarɛ. ");
INSERT INTO kdh_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ngɛ wɔɔdɔ́ ɩdɩmɛlanɖáa sɩsɩ: «Mɩ́na kpangbɔ́ɔ ɩjɔ́ɔ cé ɩɖáŋ ɖáa. Mána afobú ɖángbáa ɩsɔ́ɔ́dáá ɖɔ́ ɖikóguu Ɩsɔ́ɔ tɛ́ɛ́dɩ na ɖɩkɔ́nɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ngɛ Ibrahím wɛɛzɛlɩ́ ɖáázɩ ɩsʊ́ʊ ibiyaalʊ́, bɩka ɩmʊ́ ɩdɔ́kɩ nimíni, ɩkpɔ́ɔ sɔɔ́ bɩka bɛlɛ́ɛ́nɩ́ bɔkpɔ́ɔ nɩ́bááwʊ. ");
INSERT INTO kdh_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Bɛrɛŋɛ‑bɛrɛŋɛ nɛ́, ngɛ Ɩsaáka sɩsɩ: «Baabá, bɛɛ ɖáázɩ, bɛɛ nimíni, fée sɩ ngála yɩ sarɔ́ɔ nɛ́ wɛ lé.» ");
INSERT INTO kdh_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ngɛ Ibrahím woobúsi yɩ sɩsɩ: «Móbú, a ɖáádála, Ɩsɔ́ɔ wánváa kʊ ɖáa fée ɖɩlaná keɖe-kanyɔ́ɔ sarɔ́ɔ.» Ngɛ bɛlɛ́ɛ́nɩ́ baanʊ́ŋ bɩlɛ́ bobó batála. ");
INSERT INTO kdh_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Baadála lénlé Ɩsɔ́ɔ waawɩ́lɩ yɩ nɛ́, ngɛ Ibrahím waagáa bɔ́ ɩlá Ɩsɔ́ɔ-dɛ́ɛ sarásɩ ɖaalanɖɛ́. Wɛɛdɛ́ nɛ́, ɩkáa ɖáázɩ bɔ́ amʊ́ arɔɔzɩ́. Waagáa ɖáázɩ bɩtɛ́ nɛ́, ngɛ wɔɔvɔ́kɩ ibiyaalʊ́ Ɩsaáka nibé ɩsɛlɩ́ ɩtɩ́nɩ ɖáázɩ sɩḿ sɩrɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Wɛ́ńzɛ́lɩ́ sɔɔ́ sɩ ɩtɔ́ɖɩ ibiyaalʊ́ ɖɔ́ gɛ ");
INSERT INTO kdh_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ɖádʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ malááyɩ́ka woogóo ɩyáa yɩ ɩsɔ́ɔ́dáá sɩsɩ: «Ibrahím, Ibrahím». Ngɛ woobúsi yɩ sɩsɩ: «Bɛɛ́ɛ ma.» ");
INSERT INTO kdh_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ngɛ malááyɩ́ka sɩsɩ: «Yele bú, nkalá yɩ nabʊ́rʊ. Lɛlɛɛɖɔ́ gɛ máádɩ́lɩ́ sɩsɩ nyénzewɔ́ɔ Ɩsɔ́ɔ; káma, ńdékízíná ma nyágʊ́ɖʊmɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ńna gɛ Ibrahím waagʊ́sɩ ɩbɛ́ɛ́ŋ nɛ́, waana agbankúrú‑kúrú fɔɖásɩ ɖɔ́kɩná ɩyɩ́sɩ. Ngɛ woobó ikóboɖi kɩ ɩkɔná ɩkɛɛná ibú ɩkʊ ɩlá sarɔ́ɔ keɖe-kanyɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ngɛ Ibrahím waava ɖɩdáarɛ ɖɩḿ yɩ́ɖɛ sɩsɩ: Ɖádʊ́ʊ Ɩsɔ́ɔ wánváa kʊ. Bʊrɔ gɛ sinje bɔ́ndɔ́m sɩsɩ: «A nyáádála Ɖádʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ bʊ́ʊ-daá, Ɩsɔ́ɔ wánváa kʊ.» ");
INSERT INTO kdh_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ malááyɩ́ka waadáyáa Ibrahím ɖoo ɩsɔ́ɔ́dáá ifééri yɩ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","«Mɔ́ɔ́ Mɩ́dʊ́ʊ Ɩsɔ́ɔ mazɩ: ɖé nyéédísi nlá ma ɖɔ́, ńdékízíná ma nyágʊ́ɖʊmɔ́ɔ nɛ́, máámʊ́ná mádɩ sɩsɩ ");
INSERT INTO kdh_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","mánɖʊ́ʊ nya alɩbáráka bɩka nlʊ́rʊ bɩlʊ́rʊ bɩɖɔ́ɔ nyazɩ wɩlásɩ, yáá tenkú nɔɔ́ kanyɩ́ŋa bɩlɛ́. Nyébíya-bíya sɩ boyóo babáɖaanáa gɛ beɖi bɛdɛ́ɛ́dɩ. ");
INSERT INTO kdh_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Nyáánɩ́ɩ mɔ́nɔ́ɔ́ nɛ́, nyébíya‑bíya-rɔ gɛ sɩ mabaná maɖʊ laadásɩ rɩ́ŋa-dɛ́ɛ ɩráa alɩbáráka.» ");
INSERT INTO kdh_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Tɔ́ɔ, bɩɩdɛ́ nɛ́, ngɛ Ibrahím na ibiyaalʊ́ boozúu bakábɩsɩ bɔmɔɔná ɩdɩmɛlanɖáa; barɩ́ŋa bakágʊ́rʊ́ bakábɩsɩ Bɛrɩsebáa lénlé Ibrahím woozúu nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Bʊwɔ́rɔ́ nɛ́, ngɛ baadɩ́ tɔ́m befééri Ibrahím sɩsɩ Mílíka waalʊrʊná inewú Nahɔ́ɔrɩ bíya abaaláa. ");
INSERT INTO kdh_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Kʊ́bɔnɩ́ gɛ Úusɩ, ɩlɛ́ ɩwɔ́rɔ́ ńba gɛ Búuzi na Kemuwɛ́ɛlɩ, ɩlɛ́ gɛ Aráamɩ ɩjaa; ");
INSERT INTO kdh_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesɛ́ɛdɩ na Hazóo na Pilidáasɩ na Yidɩláafɩ na Betuwɛ́ɛlɩ. ");
INSERT INTO kdh_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Ɩlɛ́ ɩmʊ́ waalʊrʊ ná Rebééka. Bíya ɩráa kʊjʊ́nɩ lutoozo gɛ Mílíka waalʊrʊná Ibrahím newú Nahɔ́ɔrɩ. ");
INSERT INTO kdh_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ngɛ ɩɖɛɛlʊ́ kúmuú Rehúma ɩlɛ́ ɖʊɖɔ waalʊrʊná yɩ bíya. Bɛlɛ́ gɛ: Tééba, Gaháam, Taháasɩ, na Maakáa. ");
INSERT INTO kdh_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saráa-dɛ́ɛ bɩ́ɩ́zɩ wensí sɩrɩ́ŋa wɔɔjɔɔná sɩ ɖúúlínya-daá nɛ́, kɛ́ɛ nɩɩ́nʊ́wá na ákoowú na lʊbɛ (127) gɛ. ");
INSERT INTO kdh_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sɩ ɩsɩ́ nɛ́, Kiriyátɩ-Arɩbáa tɛ́ɛ́dɩ tɩɩbɩ́sɩ Ebɩrɔ́ɔnɩ tʊwɛ Kanáanɩ laadɔ́ɔ-daá nɛ́ tɩdaá gɛ waazɩ́. Ngɛ Ibrahím wɔɔgɔ́nɩ iwíi ɩdɛ́ɛ lííya. ");
INSERT INTO kdh_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Weewíi kɛ nɛ́, ngɛ weeyéle ɩsɩɖʊ́, bɩka ɩdɩtɩŋa ɩkʊrʊ́ ibó ikéveeri Hitíi kutoluú-dɛ bíya sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","«Kʊ́bɔnáa, mɛ́gɛ́ɛ agɔ́ɔ́jɔwʊ gɛ; ɩgɔ́ńdɩ gɛ mɔ́jɔɔ́ɔ mɩ́lɔ́wʊ́táá cé. Bɩlɛ́ nɛ́, ɩva ma bɔɔlááwʊ mebí mɛɖɛɛlʊ́ bɩlɩ́ɩ mɔ́rɔ́.» ");
INSERT INTO kdh_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ngɛ bɛlɛ́ boobúsi yɩ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«Kʊ́bɔnɩ́, welesi ɖáa. Nyɔ́jɔɔ́ɔ ɖɔ́ nɛ́, nyɛ́gɛ́ɛ Ɩsɔ́ɔ-dɛ́ɛ awóronbú gɛ ɖɔ́lɔ́wʊ́táá; bɩlɛ́ nɛ́, bo nbí nyáárʊ́ ɖɛ́dɛ́ɛ bɔɔlááwʊ kɩɩbá kɩmɔɔ́ɔ nya nɛ́ kɩdaá. Ɖádáá naárʊ fɛ́yɩ́ wéngizíi sɩ ńkebí yɩ ɩbɔɔlááwʊ-daá nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Bɔɔdɔ́ bɩlɛ́ nɛ́, ngɛ Ibrahím waagʊrʊ́ isóm Hitíi kutoluú-dɛ bíya rɩ́ŋa ɩzá-daá ");
INSERT INTO kdh_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ɩtɔ́ wɛ sɩsɩ: «A bɩgɛ́ɛ míídísi sɩsɩ mánbɩɩzɩ́ mebí máárʊ́, iwélesi ɩnɩ́ɩ ma: ɩlá suúru ɩsʊlʊ ná mɔ́nɔ́ɔ́ Sowáarɩ biyaalʊ́ Efɩrɔ́ɔnɩ ");
INSERT INTO kdh_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","sɩsɩ ɩ́yáná ma ɩdɛ́ɛ Makpéela bʊ́tangbalʊʊ́ bɔɔwʊ́ kʊwɛ ɩvɔɔ́ tɩ́ŋa-daá nɛ́ kɩbɩ́sɩ mɛ́dɛ́ɛ ńgɩ. A sɩ ɩyaná ma, ɩ́yáná ma biliideé nɔɔ́-daá mɩ́rɩ́ŋa mɩ́ɩ́zá-daá.» ");
INSERT INTO kdh_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Wánŋmatɩ́ bɩlɛ́ nɛ́, Efɩrɔ́ɔnɩ Hitíi kutoluú-dɛ bú ɩmʊ́ ɩgʊ́ ɩwɛ ɩdɛ́ɛ ńba lɔwʊtáá ńna; ngɛ ɩlɛ́ woobúsi yɩ Hitíi kutoluú-dɛ bíya rɩ́ŋa baagáyáa wɛ tɛ́ɛ́dɩ wɔnɔɔ́-daá nɛ́ baazá-daá sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","«Aayɩ́, kʊ́bɔnɩ́, máávɩ́nɩ nya; mɔ́vɔɔ́ na bɔɔlááwʊ bʊ́tangbalʊʊ́ bɔɔwʊ́, kpɔɔ, máává nya bɩrɩ́ŋa. Mánŋmatɩ́ ɖɔ́ nɛ́, mɛ́dɛ́ɛ ńba rɩ́ŋa ɩzá-daá gɛ mááŋmátɩ, bo nbí nyáárʊ́.» ");
INSERT INTO kdh_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Baaŋmátɩ Ibrahím bɩlɛ́ nɛ́ gɛ waabɩ́sɩ ibó ɩbá ití isóm tɛ́ɛ́dɩ bíya ɩzá-daá. ");
INSERT INTO kdh_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Ngɛ wɔɔdɔ́ Efɩrɔ́ɔnɩ tɛ́ɛ́dɩ bíya bɛḿ baazá-daá sɩsɩ: «Kʊ́bɔnɩ́, máávɩ́nɩ nya, nyɔ́ɔ́ ɖʊɖɔ welesi ma; fɔɔ́ kɛḿ kɛdɛ́ɛ kɩyakʊ nɖɔ́ sɩ maɖʊ nya nɛ́, la suúru ndísi nmʊ liideé amʊ́, bɩka moboná máárʊ́ mebí.» ");
INSERT INTO kdh_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ngɛ ɩlɛ́ woobúsi yɩ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«Kʊ́bɔnɩ́, liideé jɩtɔ́ɔ kákpɩ́ɩ́zɩ nasɩ́lɛ (400) laadɔ́ɔ tónÿoozi mána nya. Bɩlɛ́ nɛ́, boná nyáárʊ́ nbí.» ");
INSERT INTO kdh_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ibrahím ɖʊɖɔ waanɩ́ɩ tɔ́m kutoluú; ngɛ waamáázɩ liideé jɩtɔ́ɔ kákpɩ́ɩ́zɩ nasɩ́lɛ (400) waaŋmátɩ kɩdɔ́m nɛ́ fɔɔ́-dʊ́ʊ igoobíya rɩ́ŋa ɩzá-daá icéle Efɩrɔ́ɔnɩ. ");
INSERT INTO kdh_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Tɔ́ɔ, Efɩrɔ́ɔnɩ-dɛ́ɛ fɔɔ́ kɔwɛ Makpéela kadɩláána Mamɩrée nɛ́, kána bʊ́tangbalʊʊ́ bɔɔwʊ́ kʊwɛ kadaá nɛ́, na tɩ́ɩ́nɩ bɔɔzɔ tɩ kadaá na kɛdɛ́ɛ tɩ́ŋa-tɩ́ŋa nɛ́, ");
INSERT INTO kdh_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","bɩɩbɩ́sɩ Ibrahím-dɛ́ɛ ńbɩ kadʊ́ʊ na ɩdɛ́ɛ ńba na wenbá barɩ́ŋa baagáyáa wɛ bɔwɛ tɛ́ɛ́dɩ wɔnɔɔ́-daá nɛ́ baazá-daá. ");
INSERT INTO kdh_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Bɩɩdɛ́ nɛ́ gɛ Ibrahím wooboná ɩɖɛɛlʊ́ Saráa ibí bʊ́tangbalʊʊ́ bɔɔwʊ́-daá. Bɔɔwʊ́ kɩḿ kʊwɛ Makpéela fɔɔ́ kadɩláána Mamɩrée tɛ́ɛ́dɩ nɛ́ Kanáanɩ laadɔ́ɔ-daá. Tɛ́ɛ́dɩ tɩḿ tɩɩbɩsɩ ná lɛlɛɛɖɔ́ Ebɩrɔ́ɔnɩ bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Bɩlɛ́ gɛ fɔɔ́ kɛḿ na kɛdɛ́ɛ bʊ́tangbalʊʊ́ bɔɔwʊ́ waajáŋ bɩlɩ́ɩ Hitíi bíya ndɛ́ bɩbɩ́sɩ Ibrahím-dɛ́ɛ ńbɩ, lénlé wénbím ɩdɛ́ɛ ɩsɩɖáa nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ibrahím waabá ɩbɩ́ɩ ɩlá ábɔ́nɩ́; ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ ɖʊɖɔ waaɖʊ yɩ alɩbáráka bɩrɩ́ŋa bɩdaá. ");
INSERT INTO kdh_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Wɩ́rɛ gɛ waayáa ɩdɩmɛlanɖáa-daá kʊ́bɔnɩ́ wɛ́nbɛɛŋ́ ɩdɛ́ɛ ɖɔ́ɔ́lɛ-rɔ nɛ́ ɩtɔ́ yɩ sɩsɩ: «Ɖʊ nyánʊ́ʊ́nɩ móyúúre-dɛ ");
INSERT INTO kdh_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","bɩka meyéle nmʊná Ɖádʊ́ʊ Ɩsɔ́ɔ weení waalá adɛ na ɩsɔ́ɔ́dáá nɛ́ sɩsɩ ńdánjaa Kanáanɩ laadɔ́ɔ mɔ́wɛ kadaá ɖɔ́ nɛ́ kɛdɛ́ɛ aléeré njéle mebiyaalʊ́; ");
INSERT INTO kdh_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Mʊná sɩsɩ nyónboɖé mɛ́dɛ́ɛ tɛɛvʊ́lɔɔ́-daá nbɛ́ɛ́ŋ mɛ́dɛ́ɛ koobíre-daá ngájaa aléeré ngɔná móbú Ɩsaáka.» ");
INSERT INTO kdh_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ngɛ ɩdɩmɛlanɖʊ́ ɩmʊ́ woobúsi yɩ sɩsɩ: «Nabʊ́rʊ, gaḿ, alʊ́ ɩmʊ́ ikízi sɩ ídóngovúu ma ɩkɔ́nɩ tɛ́ɛ́dɩ tɩna tɩdaá; bɩlɛ́ nɛ́, mɔ́gbɔɔ nyóbú moboná tɛ́ɛ́dɩ nyáagágʊ́rʊ́ tɩ nɛ́ tɩdaá yáá wé.» ");
INSERT INTO kdh_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ngɛ Ibrahím sɩsɩ: «Hń‑hn, bɩ́kacɩ́ nya nboná móbú ńna. ");
INSERT INTO kdh_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Mádʊ́ʊ Ɩsɔ́ɔ waalá ɩsɔ́ɔ́dáá nɛ́ waagálɩ́zɩ́ na ma majaa-dɛ́ɛ na mɛ́dɛ́ɛ́dɩ-daá; waagálɩ́zɩ́ ma nɛ́, waaŋmátɩ gɛ ɩmʊná sɩsɩ ɩmʊ́ wɔ́ngbɔwʊ́ʊ laadɔ́ɔ kana icéle mógutoluú-dɛ bíya. Mádʊ́ʊ Ɩsɔ́ɔ ɩmʊ́ wéngediríi ɩdɛ́ɛ malááyɩ́ka ɩtɛ nya nɩ́bááwʊ, na nbɩ́ɩ́zɩ ngájaa aléeré ngɔná móbú. ");
INSERT INTO kdh_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","A bɩgɛ́ɛ aléeré weegízi sɩ ídóngovúu nya nbɩlɛ́, nyɔ́ɔ́ nyáálɩ́ɩ nyódoovonúm-daá; amá, móbú gɛ nkoboná ńna.» ");
INSERT INTO kdh_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ngɛ tɩmɛlanɖʊ́ ɩmʊ́ waaɖʊ ɩnʊ́ʊ́nɩ ɩgʊ́bɔnɩ́ Ibrahím yúúre-dɛ ɩmʊná sɩsɩ ɩmʊ́ weedísi. ");
INSERT INTO kdh_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ngɛ waalɩzɩ́ ɩgʊ́bɔnɩ́-dɛ́ɛ raakúḿwá-daá tɩrɔ fuú, na ɩlɛ́ ɩdɛ́ɛ ɖɔ́ɔ́lɛ kpɩná ɩkpɛdɩ́na Mesopotamíi Nahɔ́ɔrɩ-dɛ́ɛ tɛ́ɛ́dɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Woobó ɩtála sɩ ɩsʊ́ʊ tɛ́ɛ́dɩ nɛ́, waana lɔkɔ nakɩ́rɩ, ngɛ weeyéle raakúḿwá ɩká tɩɖʊná-rɔɔzɩ́ tɩcɔ́ɔ tɩfɛ́ɛ́zɩ. Bɩdɛ́ɛ sáátɩ kɛ́ɛ na ɖaanɩ́ŋa-rɔ, sáátɩ wenkí aláa wɔ́ngɔnɩ́ lɩ́m lúu nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ńna gɛ waazʊ́lʊ sɩsɩ: «Ɖádʊ́ʊ Ɩsɔ́ɔ, mágʊ́bɔnɩ́ Ibrahím-dɛ́ɛ Ɩsɔ́ɔ, yele mabɩ́ɩ́zɩ mɛgɛtɩná wenbí mánjáádɩ bɩ nɛ́ sinje kɩna. Ɖɔkɩ mágʊ́bɔnɩ́ Ibrahím bɩcáárɩ. ");
INSERT INTO kdh_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Bɛɛ ma lɔkɔ-jɔ́; tɛ́ɛ́dɩ-daá aléewá nɖɔ́ bɛlɛ́ sɩ balɩ́ɩ bɔkɔ́nɩ bolu lɩ́m. ");
INSERT INTO kdh_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Bɩlɛ́ nɛ́, badaá wenɖé sɩ mɔdɔ́ ɖɛ sɩsɩ ɖíkpilisi ɖɩdɛ́ɛ báyɔ́ɔ mɔnyɔ́ɔ lɩ́m gɛ ɖiidísi sɩsɩ mɔ́nyɔɔ, na a mɛ́ɛ́dɛ́, ɖɩḿ ɖulu ɖɩɖʊ mɛ́dɛ́ɛ raakúḿwá nɛ́, mándɩlɩ́ɩ sɩsɩ aléeré ɖɩḿ gɛ nyáágbɩ́ɩ́rɩ nzɩ́ɩ nyáárʊ́ Ɩsaáka. Ńnaamʊ́ gɛ mándɩlɩ́ɩ na sɩsɩ nyɔ́ɖɔ́kɩná mágʊ́bɔnɩ́ Ibrahím bɩjaarɛ́ɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Sɩ ɩtɔ́ na isú nɛ́, Betuwɛ́ɛlɩ wɛɛlɛ́ɛ Rebééka nbɩlɛ́, ɩgɛrɛŋɛ báyɔ́ɔ kadɩ́nɛ́ɛ ɩvaamʊ́ʊ-rɔ. Betuwɛ́ɛlɩ ɩmʊ́ ɩgɛ́ɛ na Mílíka na Nahɔ́ɔrɩ bebiyaalʊ́, bɩka Ibrahím newú nbɩlɛ́ Nahɔ́ɔrɩ. ");
INSERT INTO kdh_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Bú aléeré ɩmʊ́ ɩjɔɔ́ɔ bɩlɛ́ nɛ́, ɩgazɔ́ɔ na nabʊ́rʊ bɩdatá, bɩka waasɩ abaalʊ́. Ngɛ woobó lɔkɔ-jɔ́ ikólú lɩ́m wɛ́ngɛɖɛɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ńna gɛ Ibrahím-dɛ́ɛ tɩmɛlanɖʊ́ weegézé ɩkɔ́nɩ ɩsɩ́ŋ yɩ ɩtɔ́ yɩ sɩsɩ: «Aléeré, la suúru, fa ma nyábáyɔ́ɔ-daá lɩ́m cʊ́kɔ mɔnyɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ngɛ aléeré woobúsi yɩ sɩsɩ: «Tɔ́ɔ, kʊ́bɔnɩ́, nyɔɔ.» Ngɛ wɛɛgbɛdɩ́ itísi báyɔ́ɔ ɩɖɔ́kɩ ɩnʊ́ʊ́zɩ-daá kʊ́bɔnɩ́ ɩmʊ́ ɩnyɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Wɔɔnyɔ́ɔ bɩtɛ́ nɛ́, ngɛ waadásɩ ɩtɔ́ sɩsɩ: «Mónlúu maɖʊ nyɛ́dɛ́ɛ raakúḿwá rɩ́ŋa páyɩ́ ɖʊɖɔ tɩnyɔ́ɔ bɩɖɔ́ɔ tɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ngɛ wɛɛgbɛdɩ́ ɩbɩ́rɩ lɩ́m bɩɩga nɛ́ lénlé fʊ́ńdɩ kpɩná wɔ́nnyɔɔ́ nɛ́, ise ɩbɩ́sɩ lɔkɔ-jɔ́ wóngolúu wánɖʊ́ʊ yɛ. ");
INSERT INTO kdh_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Waalá ɖɔ́nɖɔ́ rɩ́ŋa kpátáá nɛ́, ngɛ abaalʊ́ tɩmɛlanɖʊ́ ceení wɛɛbɛ́ɛ́ŋ yɩ tíḿḿ, bɩka wɔ́nbɔɔzɩ́ ɩdɩ sɩsɩ: «Hm‑hmm, toovonúm Ɖádʊ́ʊ Ɩsɔ́ɔ weeyéle ma nɩ́bááwʊ ɩlá ɖéyí-ɖéyí yáá ngʊ́ nŋɩ́nɩ́ gɛ tɩ ɖɔ́.» ");
INSERT INTO kdh_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Sáátɩ wenkí raakúḿwá wɔɔnyɔ́ɔ bɩtɛ́ nɛ́, ngɛ abaalʊ́ ceení waalɩzɩ́ siká ketéreniiká sanɩ́ya fɔɔlʊʊ́-dɛ́ɛ yíni ńga, na siká kpaarásɩ sanɩ́ya fuú-dɛ́ɛ yíni ńzɩ nasɩ́lɛ icéle Rebééka ɩmʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ngɛ wɔɔmɔ́ɔ ɩbɔ́ɔ́zɩ yɩ sɩsɩ: «Awéní-dɛ́ɛ bú gɛ nya. Ɖónÿuú ɖaavɩnɩɖɛ́ njaa-dɛ́ɛ?» ");
INSERT INTO kdh_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ngɛ Rebééka woobúsi yɩ sɩsɩ: «Betuwɛ́ɛlɩ wɛɛlɛ́ɛ gɛ ma, Betuwɛ́ɛlɩ Mílíka waalʊrʊ ná yɩ Nahɔ́ɔrɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Nyɩ́ɩ́dɩ na ɖoofú ɩbá gɛ bʊwɛ ɖɛ́dɛ́ɛ aboyi, ngɛ ɖaaɖooɖɛ́ ɖʊɖɔ wɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ńna gɛ abaalʊ́ ɩmʊ́ woozóm adɛ ɩsɛ́ɛ Ɖádʊ́ʊ Ɩsɔ́ɔ kɩzɛɛwʊ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","«Máázá Mádʊ́ʊ Ɩsɔ́ɔ, mágʊ́bɔnɩ́ Ibrahím-dɛ́ɛ Ɩsɔ́ɔ. Toovonúm, nyééwíi mágʊ́bɔnɩ́ ɩmʊ́ ɩrɔ, bɩka nyɔ́ɖɔ́kɩná yɩ. Mádɩtɩŋa gɛ nyáagálaazɩ mágʊ́bɔnɩ́ ɩmʊ́ inewú-dɛ́ɛ bɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Rebééka waana bɩlɛ́ nɛ́, ngɛ weeze ikpé ibó ɩtɩ́ tɔ́m tɩḿ ifééri ɩgɔɔ. ");
INSERT INTO kdh_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebééka ɩmʊ́, ɩwɛná ɖawaalʊ́ʊ, bánÿaá ɩlɛ́ sɩsɩ Labáanɩ. Ɩlɛ́ waanɩ́ɩ tɔ́m tɩna nɛ́, ngɛ weeze ɩlɩ́ɩ lɔkɔ-jɔ́ ɩkɔ́mɔ́ɔ́ná ɩrʊ́ ɩmʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Wáńgánáa ketéreniiká na kpaarásɩ newúu ɖɩ́ɩ́na nɛ́; bɩka ɩnɩ́ɩ tɔ́m wentí beevééri ɩlɛ́ nɛ́, ngɛ woobó ɩmɔɔná ɩrʊ́ ɩmʊ́ ɩdɛ́ɛ raakúḿwá-jɔ́ lɔkɔ-jɔ́ ");
INSERT INTO kdh_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","ifééri yɩ sɩsɩ: «Ówu, isóóroḿ, kʊrʊ́ ngɔ́nɩ; we-rɔ gɛ nyááwálɩ́ asʊ, máńgbɩɩrɩ ɖaána na ɖɩdáarɛ mazɩ́ɩ nyɛ́dɛ́ɛ raakúḿwá.» ");
INSERT INTO kdh_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ngɛ ɩrʊ́ ɩmʊ́ waagʊrʊ́ ifu yɩ bɛɖɛ́ɛ ɩdɛ́ɛ. Baadála nɛ́, ngɛ Labáanɩ wɔɔdɔ́ bobóɖi kpɩná raakúḿwá-rɔ, baɖʊ tɩ nyɩ́ɩ́dɩ na ɖoofú. Ngɛ bɔɔgɔná lɩ́m ɩrʊ́ ɩmʊ́ ɩ́na wenbá bogovóo yɩ nɛ́ basáŋ banʊvɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Bɛɛdɛ́ nɛ́, ngɛ bɔɔgɔná wɛ kíɖíím. Ńna gɛ abaalʊ́ ɩmʊ́ sɩsɩ: «A ɖé mádaŋmatɩ tá wentí tɩɩgɔ́gɔná ma nɛ́, mɛ́vɛ́yɩ́ ménɖíi kíɖíím.» Ngɛ Labáanɩ sɩsɩ: «Tɔ́ɔ, kʊ ngʊ́ nŋmátɩ ɖɩnɩ́ɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ngɛ sɩsɩ: «Ibrahím-dɛ́ɛ tɩmɛlanɖʊ́ gɛ mɛ́gɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Toovonúm, Ɖádʊ́ʊ Ɩsɔ́ɔ waaɖʊ mágʊ́bɔnɩ́ ɩmʊ́ alɩbáráka, ɩsɩ́ɩ yɩ kʊ́bɔńdɩ, ɩfa yɩ fééni, namɩ́nɩ na náánɩ, liideé, siká, yomáa aláa na abaaláa, raakúḿwá na bɩdɛ́ɛ kpangbásɩ. ");
INSERT INTO kdh_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Mágʊ́bɔnɩ́ ɩmʊ́ ɩɖɛɛlʊ́ Saráa waalʊrʊná yɩ bú abaalʊ́ ɩdɛ́ɛ ábɔńdɩ-daá. Bú ɩmʊ́ gɛ weejéle wenbí bɩrɩ́ŋa ɩwɛná nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Weeyéle mamʊná sɩsɩ mádánjaa Kanáanɩ laadɔ́ɔ ɩwɛ kadaá ɖɔ́ nɛ́-dɛ́ɛ aléeré mejéle ibiyaalʊ́ ɩmʊ́; ");
INSERT INTO kdh_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ɩsɩ mɔ́gɔnɩ ɩdɛɛvʊ́lɔɔ́-daá mɛbɛ́ɛ́ŋ igoobíre-daá majáa aléeré moboná yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Waaŋmátɩ ma bɩlɛ́ nɛ́, ngɛ mɔ́ɔ́bɔ́ɔ́zɩ yɩ sɩsɩ a gaḿ mááná aléeré gɛ weegízi sɩsɩ ídónvúu ma ní. ");
INSERT INTO kdh_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ngɛ woobúsi ma sɩsɩ: “Ɖádʊ́ʊ Ɩsɔ́ɔ weení ɩmʊ́ ivóo yɩ nɛ́, wéngediríi ɩdɛ́ɛ malááyɩ́ka ɩtɛ ma nɩ́bááwʊ hálɩ mogóyuú wenbí mánjáádɩ nɛ́ mɔgɔ́gbɔ́ɔ ɩmʊ́ igoobíre-daá aléeré mɔgɔ́gɔná ibiyaalʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Sáátɩ kɩḿ nɛ́, a bɩgɛ́ɛ móóbó ɩdɛ́ɛ koobíre-daá gɛ bedetísi, máálá wenbí móóɖúúná bɩ nɛ́; ɩmʊ́ wɛ́njɛ́m ma.” ");
INSERT INTO kdh_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Ngɛ sinje máádála lɔkɔ-jɔ́ nɛ́, sʊlʊ́ńdɩ tɩna gɛ máázʊ́lʊ mazɩ: “Mádʊ́ʊ Ɩsɔ́ɔ, mágʊ́bɔnɩ́ Ibrahím-dɛ́ɛ Ɩsɔ́ɔ, boɖi ma mánɩ́bááwʊ kɩna kɩdaá. ");
INSERT INTO kdh_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Bɛɛ ma lɔkɔ-jɔ́, bɩ́la aléeré neɖére ɩkɔ́nɩ sɩ ɖulu lɩ́m, mánzʊlʊ́ʊ ɖɛ ɖɩfa ma ɖɩdɛ́ɛ báyɔ́ɔ-daá lɩ́m cʊ́kɔ mɔnyɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","A mɔ́ɔ́dɔ́ ɖɛ bɩlɛ́ gɛ ɖiidísi sɩsɩ mɔ́nyɔɔ, na ɖɩḿ ɖikólú ɖɩɖʊ mɛ́dɛ́ɛ raakúḿwá ɖʊɖɔ; aléeré ɖɩḿ ɖɩ́la aléeré nyáágbɩ́ɩ́rɩ ɖɛ nzɩ́ɩ sɩsɩ mágʊ́bɔnɩ́ biyaalʊ́ ɖɛɛlʊ́ nɛ́.” ");
INSERT INTO kdh_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Mánzʊlʊ́ʊ bɩlɛ́ nɛ́, mádatandɛ tá gɛ mááná Rebééka waadála ɩgazʊwáána báyɔ́ɔ, ɩkɔ́nɩ ití lɔkɔ-jɔ́ ikólú lɩ́m. Ngɛ máázʊ́lʊ yɩ sɩsɩ ɩ́la suúru ɩfa ma lɩ́m cʊ́kɔ mɔnyɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ngɛ wɛɛgbɛdɩ́ itísi ɩdɛ́ɛ báyɔ́ɔ ɩtɔ́ ma sɩsɩ: “Kɔnɩ nnyɔ́ɔ, a nyɔ́ɔ́nyɔ́ɔ bɩtɛ́, mobó molu maɖʊ nyɛ́dɛ́ɛ raakúḿwá.” Ngɛ mɔ́ɔ́nyɔ́ɔ; ibó ikólú ɩɖʊ mɛ́dɛ́ɛ raakúḿwá tɩnyɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Mɔ́ɔ́bɔ́ɔ́zɩ yɩ sɩsɩ ɩjaa gɛ awé. Ngɛ woobúsi ma sɩsɩ ɩmʊ́ ɩjaa gɛ Betuwɛ́ɛlɩ, bɩka ɩjaájaa gɛ Nahɔ́ɔrɩ, inize gɛ Mílíka. Ngɛ máájáŋ mɔgbɔ́ɔ ketéreniiká maɖʊ ɩnʊbɔɔwʊ́; bɩka mɔgbɔ́ɔ kpaarásɩ maɖʊ ɩnʊ́ʊ́zɩ. ");
INSERT INTO kdh_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ngɛ méédí mozóm mogúu Mádʊ́ʊ Ɩsɔ́ɔ tɛ́ɛ́dɩ, mɛzɛ́ɛ mágʊ́bɔnɩ́ Ibrahím-dɛ́ɛ Ɩsɔ́ɔ kɩzɛɛwʊ. Mɛ́ɛ́zɛ́ɛ yɩ ńŋɩnáa weegégeti ma nɔwɛ́ya nakɩ́rɩ talá hálɩ mágʊ́bɔnɩ́ yídawʊ́-bú-jɔ́ nɛ́. Bú ɩmʊ́ gɛ sɩ mɔgbɔ́ɔ moboná mágʊ́bɔnɩ́ ɩmʊ́ ibiyaalʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Tɔ́ɔ, lɛlɛɛɖɔ́ a míndisí ɩlá mágʊ́bɔnɩ́ kazɔ́ɔ kɛngɛ́ mɩ́dánlɩɩ ɩwɔ́rɔ́, ivééri ma. A ngʊ́ mídéndisi, ifééri ma bɩka madɩlɩ́ wenkí sɩ mɔgbɔɔná nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ngɛ Labáanɩ na Betuwɛ́ɛlɩ boobúsi yɩ sɩsɩ: «Tɩna ɖɔ́ nɛ́, Ɖádʊ́ʊ Ɩsɔ́ɔ waavʊ́ńbaná ɩkpɩ́ɩ́rɩ tɩ; bɩlɛ́ nɛ́, tɩlɛ́ tɩɩbá tɩvɛ́yɩ́na fʊ́ʊ́dɩ sɩ bafʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebééka cɔɔ́ɔ na nyáázá-daá bɩlɛ́, kpɛdɩ́na yɩ nyána yɩ ɩɖɛ́ɛ; bɩka ɩbɩ́sɩ nyɛ́dɛ́ɛ kʊ́bɔnɩ́ biyaalʊ́ ɖɛɛlʊ́, ńŋɩnáa Ɖádʊ́ʊ Ɩsɔ́ɔ wɔɔdɔ́ bɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ibrahím-dɛ́ɛ tɩmɛlanɖʊ́ ceení waanɩ́ɩ baaŋmátɩ bɩlɛ́ nɛ́, ngɛ weedí ɩwááwʊ, ilúúzi ɩdɩ hálɩ adɛ ɩsɛ́ɛ Ɖádʊ́ʊ Ɩsɔ́ɔ kɩzɛɛwʊ. ");
INSERT INTO kdh_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Wɛɛdɛ́ nɛ́, ngɛ waazʊ́ʊ́zɩ ivuruú-daá ɩlɩzɩ́ siká kpɩná, na kpɩná kúsuuyé ɩfa Rebééka; ɩfa ɩgɔɔ na ɩɖawaalʊ kpɩná kífenvená ńná ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ngɛ ɩ́na wenbá baagálaazɩ yɩ bɔkɔ́nɩ nɛ́ baabá beɖi bɔnyɔ́ɔ; bɛɛdɛ́ nɛ́, ngɛ baazʊ́ʊ bafɩ́nɩ. Tɛ́ɛ́wʊ weevé baalɩ́ɩ nɛ́, ngɛ tɩmɛlanɖʊ́ ceení wɔɔdɔ́ Rebééka ɩgɔɔ na ɩɖawaalʊ sɩsɩ: ɩmʊ́ wánzʊlʊ́ʊ wɛ nɩ́bááwʊ ɩbɩ́sɩ ɩmʊ́ ɩgʊ́bɔnɩ́-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ngɛ bɛlɛ́ boobúsi yɩ sɩsɩ: «Tɔ́ɔ, yele aléeré ɩtásɩ ɩlá wɛ́ náálɛ, nyazɩ wɛ́ fuú bɩlɛ́ naanɩ́ ɩkɔ́nɩ ibó.» ");
INSERT INTO kdh_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ngɛ ɩmʊ́ sɩsɩ: «Mɩ́nyɩ sɩsɩ Ɖádʊ́ʊ Ɩsɔ́ɔ wónboɖí ma mánɩ́bááwʊ-daá; bɩlɛ́ nɛ́, íkokuti ɩbárasɩ ma; iyéle mabɩ́sɩ mɔgɔ́mɔ́ɔ́ná mágʊ́bɔnɩ́.» ");
INSERT INTO kdh_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ngɛ bɛlɛ́ sɩsɩ: «Ɖɩ́yaa aléeré ɖɩbɔ́ɔ́zɩ yɩ ɖɩbɛ́ɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ngɛ baayáa Rebééka bɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Nyónvúu abaalʊ́ ɩmʊ́ ɩɖɛ́ɛ?» Ngɛ ɩlɛ́ woobúsi wɛ sɩsɩ: «Ɩɩ́n, mónboɖé.» ");
INSERT INTO kdh_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ngɛ baava ɩ́na ɩdɛ́ɛ bɔwʊtá-dʊ́ʊ nɩ́bááwʊ bofu abaalʊ́ ɩmʊ́ na ɩdɛ́ɛ ńba bɛɖɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Sɩ bɛɖɛ́ɛ nɛ́, boogóóri bafa benewú Rebééka sɩsɩ: «Ɖénéwú Rebééka, Ɩsɔ́ɔ ɩ́fá nya lʊrʊ́ʊ nlʊ́rʊ bɩɖɔ́ɔ, bɩka nyébíya‑bíya bɛḿ beɖi wenbá barɩ́ŋa bádánjaa nya nɛ́ balaadásɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ngɛ Rebééka waagbɩ́ɩ́rɩ ɩ́na ɩdɛ́ɛ bɔwʊtá-dɩnáa bakpa raakúḿwá-rɔɔzɩ́ bofu Ibrahím-dɛ́ɛ tɩmɛlanɖʊ́ bɛɖɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Bɩlɛ́ bɩdɛ́ɛ sáátɩ, Ɩsaáka wáńgagʊrʊ́ Lakáayɩ-Rɔ́ɔyɩ-dɛ́ɛ lɔkɔ-jɔ́ ɩkɔ́nɩ isúu Negɛ́ɛvɩ fáráńdɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Wɩ́rɛ ɖaanɩ́ŋa waalɩ́ɩ fatɩma wánmʊ́ʊ fefelimá nɛ́, waagʊ́sɩ nɛ́, waagáná raakúḿwá kɛgɛrɛŋɛ. ");
INSERT INTO kdh_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Sáátɩ wenkí Rebééka waagʊ́sɩ ɩkáná Ɩsaáka nɛ́, ngɛ weedí raakúḿ-rɔ; ");
INSERT INTO kdh_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ngɛ wɔɔbɔ́ɔ́zɩ Ibrahím-dɛ́ɛ tɩmɛlanɖʊ́ ɩmʊ́ sɩsɩ: «Weení wɛ́ngɛɖɛɛ kʊ ɖáázá-daá ɖɔ́.» Ngɛ ɩlɛ́ woobúsi yɩ sɩsɩ: «Mágʊ́bɔnɩ́ nbɩlɛ́.» Ngɛ waajáŋ ɩwaláɖɩ ɩdɛ́ɛ kɛkɛntɛ́ ifu waazá-daá. ");
INSERT INTO kdh_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Bɔɔgɔ́nɩ batála nɛ́, ngɛ tɩmɛlanɖʊ́ ceení waadɩ́ wenbí bɩrɩ́ŋa kpátáá waagála nɛ́ ifééri Ɩsaáka. ");
INSERT INTO kdh_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ngɛ Ɩsaáka ɩmʊ́ wɔɔgbɔ́ɔ Rebééka ɩsʊʊná ɩgɔɔ Saráa-dɛ́ɛ ɖaḿ-daá. Ngɛ Rebééka waabɩ́sɩ ɩɖɛɛlʊ́; ɩmʊ́ ɩbá ɩsɔ́ɔ́lɩ yɩ. Rebééka-dɛ́ɛ tɔ́m tɩna tɩɩgɔnɩ ná tɩfɛ́ɛ́zɩ Ɩsaáka ɩmʊ́ iwenbiré ɩgɔɔ sɩ́m wɔ́rɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Bɩjɔɔ́ɔ nɛ́, Ibrahím woogúti ɩkpɔ́ɔ alʊ́ ɖʊɖɔ ɩtásɩ. Bánÿaá ɩlɛ́ sɩsɩ Ketúúra. ");
INSERT INTO kdh_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ɩlɛ́ ibíya waalʊrʊná yɩ wɛ nɛ́ nɖɔ́: Zimiráanɩ, Yɔkɩsáánɩ, Medáanɩ, Madiyáanɩ, Yisebáakɩ, na Súwa. ");
INSERT INTO kdh_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yɔkɩsáánɩ waagʊrʊ́ nɛ́, ngɛ ɩlɛ́ waalʊ́rʊ Séba na Ɖɩdáánɩ. Ɖɩdáánɩ ɩmʊ́ ibíya-bíya gɛ Asúuri bíya, Letusíi bíya na Lewumíi bíya. ");
INSERT INTO kdh_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Madiyáanɩ ɩlɛ́ ibíya gɛ Éfa, Efɛ́ɛrɩ, Enɔ́ɔkɩ, Abidáa na Ɛlɩdáa. Barɩ́ŋa bɩlɛ́ nɛ́, Ketúúra bíya-bíya nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ibrahím wɔɔgbɔ́ɔ ɩdɛ́ɛ ɖɔ́ɔ́lɛ rɩ́ŋa ɩwɛná kɩ nɛ́ gɛ ɩfa Ɩsaáka. ");
INSERT INTO kdh_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Bɩɩga ɩɖɛɛlɩnáa asʊ ńba bíya nɛ́, ɖoo ɩwɛ weezuú-daá nɛ́ gɛ waavʊ́ńlaḿ bɛlɛ́ kʊjɔ́ɔ́nɩ ɩcáŋ ɩɖɔ́ɔ wɛ bɛɖɛ́ɛ wɩ́sɩ ɖaagalɩɩɖɛ́ fáráńdɩ́ bɩka Ɩsaáka riké. ");
INSERT INTO kdh_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Bɩ́ɩ́zɩ nɩɩ́nʊ́wá na niídoozo na saaláa na nasʊ́nʊ́wá (175) gɛ Ibrahím wɔɔjɔɔná ɖúúlínya-daá naanɩ́ ɩsɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Waabá gɛ ɩbɩ́ɩ, iɖi ábɔńdɩ kazɔ́ɔ naanɩ́ ɩmɔ́ɔ ɩsɩ́ ibó ɩkɔ́mɔ́ɔ́ná kʊ́bɔnáa. ");
INSERT INTO kdh_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Waazɩ́ nɛ́, ngɛ ibiyaalɩnáa Ɩsaáka na Asʊmáyɩ́la bɔɔgbɔ́ɔ yɩ, boboná bekébi Makpéela bʊ́tangbalʊʊ́ bɔɔwʊ́-daá, ɩɖɛɛlʊ́ Saráa-dɛ́ɛ bɔɔlááwʊ-daá kpɔ́mɔ́ɔ́. Bɔɔlááwʊ kɩngɩ́ nɛ́, Hitíi ńba-daá abaalʊ́ Sowáarɩ biyaalʊ́ Efɩrɔ́ɔnɩ-dɛ́ɛ fɔɔ́ kadɩláána Mamɩrée nɛ́ kadaá gɛ kʊwɛ; fɔɔ́ kɛḿ, Hitíi kutoluú-dɛ bíya-jɔ́ gɛ Ibrahím waavʊ́ńmʊ́ʊ kɛ. ");
INSERT INTO kdh_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ibrahím waazɩ́ nɛ́, ngɛ Ɩsɔ́ɔ waabá ɩɖʊ Ɩsaáka alɩbáráka. Ngɛ waagágʊ́rʊ́ ɩkɔ́nɩ isúu Lakáayɩ-Rɔ́ɔyɩ lɔkɔ-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Saráa-dɛ́ɛ yoḿ Mɩ́sɩra alʊ́-dɛ́ɛ bú Asʊmáyɩ́la weení waalʊrʊná yɩ Ibrahím nɛ́ igutoluú-dɛ bíya nɖɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ibíya bɛḿ bayɩrá nɖɔ́ kʊ́bɔńdɩ-rɔ: Nebayɔ́ɔtɩ, Kedáarɩ, Adɩbɛ́ɛlɩ, Mibisám, ");
INSERT INTO kdh_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misemáa, Ɖúma, Masáa, ");
INSERT INTO kdh_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadáadɩ, Temáa, Yetúuri, Nefíisi na Kedimáa. ");
INSERT INTO kdh_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Asʊmáyɩ́la-dɛ́ɛ bíya fuú na nɔɔ́lɛ bɛḿ nbɩlɛ́. Badaá báa awéní weeɖi kʊ́bɔńdɩ ɩdɛ́ɛ sɛ́ɛ́dɩ-rɔɔzɩ́; ngɛ bɔɔgbɔ́ɔ bayɩrá bafa bɛdɛ́ɛ́dɩwá na lénlé boozúu‑bosúu nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Asʊmáyɩ́la-dɛ́ɛ bɩ́ɩ́zɩ nɩɩ́nʊ́wá na ákoosaaláa na lʊbɛ (137) gɛ waazɩ́ ibó ɩkɔ́mɔ́ɔ́ná kʊ́bɔnáa. ");
INSERT INTO kdh_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ibíya wɔɔgbɔɔná fáráńdɩ́ kʊwɛ Havíila na Súuri kɩdɩláána Mɩ́sɩra nɛ́ bɔlɔwʊtáá, hálɩ ngbɔ́ɔ nɖɛ́ɛ Asúuri. Fáráńdɩ́wá tɩḿ tɩdaá gɛ bɛlɛ́ baalɩ́ɩ bɔcɔɔná badɩ bodoyooziná badɩ Ibrahím-dɛ́ɛ bíya baaganáa. ");
INSERT INTO kdh_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ibrahím biyaalʊ́ Ɩsaáka kutoluú-dɛ bíya nɖɔ́: ");
INSERT INTO kdh_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Ibrahím waalʊ́rʊ Ɩsaáka; Ɩsaáka-dɛ́ɛ bɩ́ɩ́zɩ nɛɛ́lɛ gɛ wɔɔgbɔ́ɔ Labáanɩ newú Rebééka; bɛlɛ́ bajaa gɛ Aráamɩ abaalʊ́ Betuwɛ́ɛlɩ Padan-Aráamɩ ńnɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rebééka cɔɔ́ɔ bɩlɛ́ nɛ́, ɩgɛ́ɛ kaalʊrʊya gɛ; ngɛ ɩwaalʊ́ waazʊ́lʊ Ɖádʊ́ʊ Ɩsɔ́ɔ ɩrɔɔzɩ́. Ngɛ Ɩsɔ́ɔ waamʊ ɩdɛ́ɛ sʊlʊ́ńdɩ ɩyɛ́ɛ fuwá. ");
INSERT INTO kdh_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ɩdɛ́ɛ fuwá-daá nɛ́, a ɩjɔɔ́ɔ, bíya wónduú ɖamá ilóódi-daá gɛ. Ngɛ sɩsɩ: «Alaafɩ́ya nbɩlɛ́?» Woobó ɩbɔ́ɔ́zɩ Ɖádʊ́ʊ Ɩsɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Wɔɔbɔ́ɔ́zɩ nɛ́, ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ wɔɔdɔ́ yɩ sɩsɩ: «Yíriwá natɩ́lɛ gɛ nyólóódi-daá; yíri natɩ́lɛ-dɛ́ɛ ɩráa gɛ sɩ nlʊ́rʊ. Badaá kʊ́ɖʊḿ wɔ́ngɔnɩ́ ɩlá ɖóni ɩkɩ́lɩ ɩrɔwʊ́; badaá kúmuú wénɖíi kʊ́bɔńdɩ ɩɖawaalʊ-rɔɔzɩ́.» ");
INSERT INTO kdh_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ɩdɛ́ɛ lʊrʊ́ʊ wɩ́rɛ waadála sɩ ɩlʊ́rʊ nɛ́, sikawá nɔɔ́lɛ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Kaɖaa ńnɩ́ waagálɩɩ nɛ́, ɩrɩ́ŋa ɩgɛzɛɛmáána fʊ́ńdɩ gɛ nyazɩ fanavʊ́ńdɩ tóko. Ngɛ baava ɩlɛ́ yɩ́ɖɛ sɩsɩ Ísááwʊ. ");
INSERT INTO kdh_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ngɛ sɩɩlɛ ńnɩ́ ɩlɛ́ ɖʊɖɔ waagálɩɩ ɩgɛgɛ́ɛ abaalʊ́; bɩka ɩgɔɖɔ́kɩ́ná kaɖaa ńnɩ́ nʊvɔdóle. Ngɛ baava ɩlɛ́ yɩ́ɖɛ sɩsɩ Yaakúbu. Bánlʊrʊ́ʊ bíya bɛḿ nɛ́, bajaa Ɩsaáka wɛná bɩ́ɩ́zɩ niídoozo (60). ");
INSERT INTO kdh_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Bɔɔgɔ́nɩ babɩ́ɩ nɛ́, ngɛ Ísááwʊ ɩlɛ́ waabɩ́sɩ ɩgbám kpeŋ‑kpéŋ́; waabá ɩsɔ́ɔ́lɩ fɔɔ́-daá kisɔɔ́ gɛ. Bɩɩga Yaakúbu ɩlɛ́ nɛ́, ɩjɔɔ́ɔ gɛ ɖɛfɛɛ, bɩka ɩlaakáarɩ rɩ́ŋa wɛ ɖaána-rɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Fanazɔ́m-rɔɔzɩ́, Ɩsaáka waabá gɛ ɩzɔɔlɛ́ɛ Ísááwʊ; bɩka Rebééka ɩlɛ́ ɩzɔɔlɛ́ɛ Yaakúbu. ");
INSERT INTO kdh_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Wɩ́rɛ Yaakúbu ɩbá ɩwɛ ɩbamáa kíɖíím nabɩ́rɩ lám gɛ Ísááwʊ waagálɩɩ kisɔɔ́ ɩtála nyɔɔ́sɩ wáńganɩɩ yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ngɛ waayáa Yaakúbu ifééri yɩ sɩsɩ: «Nyɔɔ́sɩ wáńganɩɩ ma; bɩlɛ́ nɛ́, kpɛdɩ́ nÿéle meɖi nyégíɖíím kɩ́sɛɛḿbɩ bɩna.» Wenbí bʊrɔɔzɩ́ baava Ísááwʊ yɩ́ɖɛ sɩsɩ Edɔ́m nɛ́ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ńna gɛ Yaakúbu sɩsɩ: «Kpɔɔ nyɔ́gʊ́bɔńdɩ nÿaná ma naanɩ́.» ");
INSERT INTO kdh_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ngɛ Ísááwʊ sɩsɩ: «Nyɔɔ́sɩ gɛ mánzɩ́m ɖɔ́; we gɛ kʊ́bɔńdɩ sɩ tɩfɔ́ɔ́zɩ ma yée.» ");
INSERT INTO kdh_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ngɛ Yaakúbu sɩsɩ: «Tɔ́ɔ, bɩlɛ́ nɛ́, mʊná naanɩ́.» Ngɛ waamʊná, ɩkpɔ́ɔ ɩgʊ́bɔńdɩ ɩyaná ɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ngɛ ɩlɛ́ wɔɔgbɔ́ɔ sɔɔná kíɖíím bɩḿ na kpɔ́nɔ́ ɩfa yɩ. Ngɛ weeɖi ɩnyɔ́ɔ; wɛɛdɛ́ nɛ́, ngɛ waagʊrʊ́ ɩɖɛ́ɛ. Tɔ́ɔ, bɩlɛ́ gɛ waalá ɩkpɛɛná ɩgʊ́bɔńdɩ. ");
INSERT INTO kdh_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ibrahím-dɛ́ɛ sáátɩ gɛ, nyɔɔ́sɩ nasɩ́rɩ waazɩ́ŋ sɩlá. Sɩlɛ́ sɩbaasí gɛ kɩ́fasɩ waazʊ́ʊ tɛ́ɛ́dɩ ɖʊɖɔ. Ngɛ Ɩsaáka waagʊrʊ́ ibó Filisitíi ńba-dɛ́ɛ wúro Abɩmelɛ́ɛkɩ-jɔ́ Gɩráarɩ tɛ́ɛ́dɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ waaɖʊ ɩlɩ́ɩ ɩrɔɔzɩ́ ɩtɔ́ yɩ sɩsɩ íkokuti ɩbɩ́sɩ Mɩ́sɩra; sɩsɩ ɩ́wálɩ́ laadɔ́ɔ wenká ɩmʊ́ sɩ ifééri yɩ sɩsɩ ɩcɔ́ɔ kadaá nɛ́ kadaá. ");
INSERT INTO kdh_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ngɛ sɩsɩ: «Cɔɔ laadɔ́ɔ kana kadaá cé, mánzɩŋ́ nyɔ́wɔ́rɔ́, bɩka maɖʊ nya alɩbáráka. Nyána nyógutoluú-dɛ bíya gɛ sɩ mava laadásɩ sɩna sɩrɩ́ŋa. A máálá bɩlɛ́, wenbí móóɖúu mazɩ́ɩ njaa Ibrahím nɛ́ gɛ máálá bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ménÿelíi nyébíya‑bíya ɩbá bɔɖɔ́ɔ nyazɩ wɩlásɩ bɩlɛ́, mava wɛ laadásɩ sɩna sɩrɩ́ŋa. Bɔrɔɔzɩ́ gɛ sɩ mabaná maɖʊ ɖúúlínya laadásɩ rɩ́ŋa-dɛ́ɛ ɩráa alɩbáráka. ");
INSERT INTO kdh_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Káma, Ibrahím waanɩ́ɩ mɔ́nɔ́ɔ́, ifu mɛ́dɛ́ɛ wɛ́ɖɛ, ɩlá mɛ́dɛ́ɛ mará-rɔɔzɩ́.» ");
INSERT INTO kdh_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ɖádʊ́ʊ Ɩsɔ́ɔ wɔɔdɔ́ bɩlɛ́ nɛ́, ngɛ Ɩsaáka waawalɩ́ ɩcɔ́ɔ Gɩráarɩ tɛ́ɛ́dɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ɩwɛ ńnaamʊ́ nɛ́, ɩ́na ɩɖɛɛlʊ́ gɛ, ngɛ tɛ́ɛ́dɩ tɩḿ tɩdaá ɩráa wɛ bɔ́nbɔɔzɩ́ yɩ alʊ́ ɩmʊ́ ɩdɛ́ɛ tɔ́m. A bɔɔbɔ́ɔ́zɩ yɩ, wónbusí gɛ sɩsɩ ɩmʊ́ inewú gɛ; ídéndisi sɩsɩ ɩɖɛɛlʊ́ gɛ yɩ. Wɛ́nnyɛ́m sɩsɩ ɩlɛ́ ɩbá ɩjɔɔ́ɔ kazɔ́ɔ nɛ́, bɔ́kɔkɔ́nɩ bakʊ ɩmʊ́ ɩrɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Tɔ́ɔ, Ɩsaáka wɔɔjɔ́ɔ tɛ́ɛ́dɩ tɩḿ tɩdaá gɛ ilééri. Wɩ́rɛ Filisitíi ńba-dɛ́ɛ wúro Abɩmelɛ́ɛkɩ wɛ wɛ́nbɛɛŋnáa tókóró nɛ́, ngɛ woolósi yɩ ɩbá ɩwɛ wánjɩnáa ɩɖɛɛlʊ́ Rebééka ɩmʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ngɛ wúro weedíri bakáyáa yɩ sɩsɩ: «Nbá nɖɛɛlʊ́ nbɩlɛ́; bɩɩlá nŋɩ́nɩ́ gɛ nyɔ́ndɔ́m sɩsɩ nyénewú.» Ngɛ Ɩsaáka sɩsɩ: «Aa, mɛ́nnyɛ́m sɩsɩ ɩrɔɔzɩ́ bɔ́kɔkɔ́nɩ bakʊ ma; bʊrɔɔzɩ́ gɛ mánŋmatɩ́ bɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ngɛ wúro Abɩmelɛ́ɛkɩ sɩsɩ: «We gɛ nyáálá ɖáa bɩlɛ́. Buroogúti bilééri cʊ́kɔ gɛ naárʊ ɩraajáa nɖɛɛlʊ́, bɩ́tabɩ́sɩ ɖáa tɔ́m tá.» ");
INSERT INTO kdh_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ngɛ wúro Abɩmelɛ́ɛkɩ weeyéle bɔbɔ́ɔ tɛ́ɛ́dɩ rɩ́ŋa-daá sɩsɩ: «Weení ɩrɩ́ŋa bɩɩjɩ́ yɩ ɩɖʊ nʊ́ʊ́nɩ Ɩsaáka yáá ɩɖɛɛlʊ́ Rebééka-rɔɔzɩ́ nɛ́, bʊdʊ́ʊ weezuú fɛ́yɩ́.» ");
INSERT INTO kdh_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Bɩbɩ́nɩ ɩmʊ́ gɛ Ɩsaáka waavára fásɩ tɛ́ɛ́dɩ tɩḿ tɩdaá. Wɔɔgɔ́nɩ sɩ ɩlɩzɩ́ kíɖíídi nɛ́, wenbí wooɖúu nɛ́ bɩdɛ́ɛ nɩɩ́nʊ́wá gɛ waalɩzɩ́. Ɖádʊ́ʊ Ɩsɔ́ɔ waabá gɛ ɩɖʊ yɩ alɩbáráka. ");
INSERT INTO kdh_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ɩdɛ́ɛ ɖɔ́ɔ́lɛ woogúti ɖɩbamáa kpáa ɩsɔ́ɔ́dáá; biiyéle ɩbá ɩbɩ́sɩ ɖɔ́ɔ́lɛ-dʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ɩwɛná fééni, namɩ́nɩ, na náánɩ ɖabata. Bɩka ɩwɛná yomáa ɖabata. Ńna gɛ Filisitíi ńba waalɩzɩ́ ɩzɩ́rɛ batɩ́nɩ ɩrɔ. ");
INSERT INTO kdh_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ɩjaa Ibrahím waavʊ́ńbáa lɔkɔwá wentí sáa wenkí ɩvʊnwɛ weezuú-daá nɛ́, beegíli bosúúri tɩrɩ́ŋa. ");
INSERT INTO kdh_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ngɛ wúro Abɩmelɛ́ɛkɩ wɔɔdɔ́ Ɩsaáka sɩsɩ: «Nyɔ́jɔɔ́ɔ ɖɔ́ nɛ́, nyáágɩ́lɩ ɖáa ɖóni, bɩlɛ́ nɛ́, asée ɖé gɛ ngʊrʊ́ ɖɛ́dɛ́ɛ cé.» ");
INSERT INTO kdh_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ngɛ Ɩsaáka waagʊrʊ́ bɛdɛ́ɛ ńna ɩɖɛ́ɛ hálɩ Gɩráarɩ-dɛ́ɛ bɔkɩrɛ-daá ikózuu, ɩcáŋ ɩcɔ́ɔ ńnaamʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ngɛ woogóózi lɔkɔwá ɩjaa fʊnwɛ gɛ waabáa tɩ na Filisitíi ńba isúúri tɩ nɛ́. Ngɛ waava tɩ yɩrá ɩjaa waavʊ́ńváa tɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ɩdɛ́ɛ yomáa waadásɩ babáa lɔkɔ nakɩ́rɩ bɔkɩrɛ-daá nɛ́, ngɛ baalɩ́ɩ lɩɩrɛ́ neɖére-rɔ. ");
INSERT INTO kdh_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ngɛ lɔkɔ kɩḿ kɩdɛ́ɛ tɔ́m wɔɔgɔná bána Gɩráarɩ-dɛ́ɛ fʊ́ńdɩ kpɩná ketiráa ŋmatɩrɛ. Bɛlɛ́ sɩsɩ bɛḿ badɩɩná lɔkɔ. Ngɛ Ɩsaáka waava lɔkɔ kɩḿ yɩ́ɖɛ sɩsɩ: «Esɛ́ɛkɩ,» bugutoluú sɩsɩ: Bɩɩgɔná ŋmatɩrɛ. Káma, baajáa ɩmʊ́ ŋmatɩrɛ. ");
INSERT INTO kdh_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Bʊwɔ́rɔ́ nɛ́, baadásɩ babáa nakɩ́rɩ, ngɛ kɩlɛ́ ɖʊɖɔ kiidóyoozi wɛ. Ngɛ waava kɩlɛ́ yɩ́ɖɛ sɩsɩ: «Sitináa,» bugutoluú sɩsɩ: Bɩɩgɔná sitáánɩ. ");
INSERT INTO kdh_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ngɛ baalɩ́ɩ ńna botóbolí ɖeelí babáa nakɩ́rɩ ɖʊɖɔ. Kɩlɛ́ kɩjɔ́, yowú talá. Ngɛ waava kɩlɛ́ yɩ́ɖɛ sɩsɩ: «Rehɔbɔ́ɔtɩ,» bugutoluú sɩsɩ: Faɖáma. Ngɛ sɩsɩ Ɖádʊ́ʊ Ɩsɔ́ɔ weeyéle ɖɩfɛ́ɛ́zɩ; bɩka ɖábámáa tɛ́ɛ́dɩ ɖíi. ");
INSERT INTO kdh_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ngɛ waagʊrʊ́ ńnaamʊ́ ɩkpa ná Bɛrɩsebáa ɩkɔ́jɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Waadála ńnaamʊ́ nɛ́, bɩwɩ́rɛ ɖɩḿ ɖɩdɛ́ɛ nuvoowú-daá gɛ Ɖádʊ́ʊ Ɩsɔ́ɔ waaɖʊ ɩlɩ́ɩ ɩrɔɔzɩ́ ɩtɔ́ yɩ sɩsɩ: «Mánáábɩ́lɛ́ njaa Ibrahím-dɛ́ɛ Ɩsɔ́ɔ, bɩ́kalá nya nɩdáárɛ, mázɩ́ŋɛ́ɛ nyɔ́wɔ́rɔ́. Mɛ́dɛ́ɛ bɔwʊtá-dʊ́ʊ Ibrahím-rɔɔzɩ́, mánɖʊ́ʊ nya alɩbáráka meyéle nlʊ́rʊ bɩlʊ́rʊ bʊɖɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ngɛ waama sarɔ́ɔ ɖaalanɖɛ́ ɩyáa Ɩsɔ́ɔ ɩmʊ́ ɩyɩ́ɖɛ sɩsɩ: Ɖádʊ́ʊ Ɩsɔ́ɔ; ɩcáŋ isúu ijókúre ńnaamʊ́. Ngɛ iyomáa waabáázɩ lɔkɔ báádɩ ńna ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Bɔwɛ ńna gɛ wúro Abɩmelɛ́ɛkɩ na ɩɖɔndɩ Ahuzátɩ na wúro Abɩmelɛ́ɛkɩ ɩmʊ́ ɩdɛ́ɛ sɔ́ɔ́jawá-dɛ́ɛ kʊ́bɔnɩ́ Pɩkɔ́ɔlɩ baagálɩɩ Gɩráarɩ bɔkɔ́nɩ sɩ bɛsɛ́ɛ yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ngɛ Ɩsaáka wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «Kʊ́bɔnáa, mɩ́nyɔ́ɔ́ nɖɔ́ mɩ́dánvʊnjaa ma, ɩkʊrʊ́ ɩkɔ́ɖɔ́ɔ ma mɩ́dɛ́ɛ; bɩlɛ́ nɛ́, wentí-rɔɔzɩ́ gɛ mɩ́ɩ́gɔ́nɩ sɩ ɩna ma.» ");
INSERT INTO kdh_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ngɛ bɛlɛ́ boobúsi yɩ sɩsɩ: «Ɖáábá ɖusúlu ɖɩbɛ́ɛ nɛ́, ɖááná sɩsɩ Ɖádʊ́ʊ Ɩsɔ́ɔ ɩbá ɩzɩ́ŋɛ́ɛ nyɔ́wɔ́rɔ́. Biiyéle ɖɔ́ɔ́jɔ́ɔ ɖɩŋmátɩ sɩsɩ bɩmɔɔ́na keɖiyá ɩcɔ́ɔ ɖána nya ɖɔ́lɔ́wʊ́táá. Bɩlɛ́ nɛ́, ɖɔ́zɔɔlɛ́ɛ ɖána nya ɖiɖi keɖiyá. ");
INSERT INTO kdh_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Nyányɩ sɩsɩ nyɔ́ɔgɔ́jɔɔ ɖɔ́lɔ́wʊ́táá nɛ́, ɖádábá ɖɩlá nya nɔwɛ́ya nakɩ́rɩ; kazɔ́ɔ riké gɛ ɖáálá nya, ngɛ na alehééri gɛ ɖééyéle ngágʊ́rʊ́ na ɖɛ́dɛ́ɛ. Bɩlɛ́ nɛ́, nyɔ́ɔ́ weení Ɖádʊ́ʊ Ɩsɔ́ɔ waaɖʊ nya alɩbáráka nɛ́, mʊná sɩsɩ ńdánlaḿ ɖáa nɔwɛ́ya.» ");
INSERT INTO kdh_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ngɛ Ɩsaáka waabá iɖi wɛ jíńgáárɩ́ kʊ́bɔnbɔńgɩ babá beɖi, bɔnyɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Kiivé tɛ́ɛrɛ́ nɛ́, ngɛ booɖuuná ɖamá. Bɩɩdɛ́ nɛ́, ngɛ bɛḿ baagbɩ́ɩ́rɩ bakʊrʊ́ na alehééri; Ɩsaáka ɩcáŋ ɩsɛ́ɛ wɛ bɛɖɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Bɩdɛ́ɛ wɩ́rɛ ɖɩḿ ɖʊɖɔ gɛ Ɩsaáka ɩmʊ́ ɩdɛ́ɛ yomáa wɔɔgɔ́nɩ befééri yɩ sɩsɩ lɔkɔ wenkí bɛḿ bɔwɛ bánbaá kɩ nɛ́, bɛḿ baalɩ́ɩ lɩ́m-rɔ. ");
INSERT INTO kdh_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ngɛ bagʊ́bɔnɩ́ waava lɔkɔ kɩḿ yɩ́ɖɛ sɩsɩ: «Sibeyáa,» bugutoluú sɩsɩ: Ɖuunáa. Biiyéle baabɩsɩná tɛ́ɛ́dɩ tɩḿ bánÿaá hálɩ na sinje sɩsɩ: «Bɛrɩsebáa,» bugutoluú sɩsɩ: Ɖuunáa-dɛ́ɛ lɔkɔ-dɛ́ɛ tɛ́ɛ́dɩ. ");
INSERT INTO kdh_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ísááwʊ waabɩ́ɩ ɩtála bɩ́ɩ́zɩ nɛɛ́lɛ nɛ́, ngɛ wɔɔgbɔ́ɔ Hitíi aláa nɔɔ́lɛ. Kʊ́ɖʊḿ gɛ bánÿaá sɩsɩ Yehudíiti; ɩlɛ́ ɩjaa gɛ Beeríi. Sɩɩlɛ ńnɩ́ gɛ Basɩmáatɩ; ɩlɛ́ ɩjaa gɛ Elɔ́ɔnɩ. ");
INSERT INTO kdh_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Aláa bɛḿ badabá bɛfɛ́ɛ́zɩ Ɩsaáka na Rebééka bewenbé péḿ. ");
INSERT INTO kdh_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Bɩjɔɔ́ɔ nɛ́, Ɩsaáka waabɩ́ɩ ɩlá ábɔ́nɩ́, waazá waawɩ́ɩ, ádándanáa ɖʊɖɔ. Wɩ́rɛ nɛ́, ngɛ waayáa ibiyaalʊ́ kʊ́bɔnɩ́ Ísááwʊ sɩsɩ: «Móbú». Ngɛ ɩlɛ́ sɩsɩ: «Mánááɖɔ́.» ");
INSERT INTO kdh_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ńna gɛ Ɩsaáka sɩsɩ: «Nyááná sɩsɩ máálá ábɔ́nɩ́, máásɩ wɩ́rɛ wenɖé sɩ mazɩ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Bɩlɛ́ nɛ́, kpɔɔ nyɛ́dɛ́ɛ kagbáńdɩ kpɩná nzʊ́ʊ nyɩ́ɩ́dɩ ngágʊ́ sɔ́m ");
INSERT INTO kdh_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","ngɔná nlá ma mólowú-dɛ kíɖíím máábá mɔ́zɔɔlɛ́ɛ bɩ nɛ́ meɖi bɩka maɖʊ nya alɩbáráka naanɩ́ mazɩ́.» ");
INSERT INTO kdh_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Sáátɩ wenkí Ɩsaáka wɛ wánŋmatɩnáa Ísááwʊ nɛ́, Rebééka ɩlɛ́ waanɩ́ɩ. Ngɛ Ísááwʊ waagbɩ́ɩ́rɩ ɩsʊ́ʊ nyɩ́ɩ́dɩ sɔ́m kʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Ńna gɛ Rebééka waayáa ibiyaalʊ́ Yaakúbu ifééri yɩ sɩsɩ: «Máánɩ́ɩ njaa wɔ́ndɔ́m nɖawaalʊ Ísááwʊ sɩsɩ ");
INSERT INTO kdh_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","íbo ɩkágʊ́ fanaḿ ɩkɔná ɩlá ɩmʊ́ kíɖíím kífeńbi ɩmʊ́ iɖi; a weeɖi gɛ bɩɩdɛ́, ikóóri ɩfa yɩ Ɖádʊ́ʊ Ɩsɔ́ɔ ɩzá-daá naanɩ́ ɩmʊ́ ɩsɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Bɩlɛ́ nɛ́, móbú, nɩɩ wentí sɩ mevééri nya nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Kpɛdɩ́ nbó namɩ́nɩ-daá ngálɩ́zɩ́ nemísi nasɩ́lɛ ngɔná ma malá kíɖíím kífeńbi njaa sɔɔlɛ́ɛ bɩ nɛ́, ");
INSERT INTO kdh_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","nboná yɩ iɖi bɩka ikóóri ɩfa nya naanɩ́ ɩsɩ́.» ");
INSERT INTO kdh_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ngɛ Yaakúbu woobúsi ɩgɔɔ sɩsɩ: «Nyányɩ sɩsɩ maɖawaalʊ Ísááwʊ ɩlɛ́ ɩdɔnʊʊ́ cɔɔ́ɔ fʊ́ńdɩ-fʊ́ńdɩ gɛ, bɩka mɔ́ɔ́ mɛ́dɛ́ɛ ńgɩ lɛɛzɛ́ɛ! ");
INSERT INTO kdh_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Mándalɩ́ɩ majaa ɩzá-daá nɛ́, nabʊ́rʊ, ɩlɛ́ sɩ ɩtákɩ ma gɛ ɩbɛ́ɛ́ŋ. A waadɩlɩ́ sɩsɩ bɩlɛ́ gɛ máálá, máábɩ́sɩ bʊbɔtʊ́ʊ; bɩ́dándanlaḿ alɩbáráka ɖʊ́ʊ; láálɩ́ gɛ bɩ́nbɩsɩ́.» ");
INSERT INTO kdh_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ngɛ ɩgɔɔ woobúsi yɩ sɩsɩ: «A láálɩ́ gɛ sɩ bɩbɩ́sɩ, láálɩ́ kɩḿ kíti mɔ́ɔ́ mɔ́rɔ́. Nyɔ́ɔ́ nɩɩ mɔ́dɔ́m nbó ngálɩ́zɩ́ ma nemísi ɖé.» ");
INSERT INTO kdh_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ngɛ woobó ɩkálɩ́zɩ́ sɩ ɩkɔná yɩ; ɩlá kíɖíím kazɔ́ɔ ńbɩ bajaa ɩbá ɩzɔɔlɛ́ɛ bɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ngɛ bɔgɔɔ waazʊ́ʊ ɩkálɩ́zɩ́ ibiyaalʊ́ kʊ́bɔnɩ́ Ísááwʊ-dɛ́ɛ kpɩná kífenvená ɩwɛná yɛ ɖaána-daá nɛ́ ɩkɔná isúu ibiyaalʊ́ kúmuú Yaakúbu. ");
INSERT INTO kdh_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ngɛ wɔɔgbɔ́ɔ nemísi waagʊ nɛ́ sɩdɛ́ɛ tɔná ifu Yaakúbu nʊ́ʊ́zɩ lénlé tóko tofu nɛ́, na ilowú-dɛ lé bɩlɛɛzɛ́ɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Woovu bɩtɛ́ nɛ́, ngɛ wɛɛzɛlɩ́ kíɖíím na kpɔ́nɔ́ waalá nɛ́ ɩɖʊ wɛndɛ́ ɩlɛ́ ");
INSERT INTO kdh_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","ɩkpɔ́ɔ ibó ɩmɔɔná ɩjaa Ɩsaáka ɩtɔ́ yɩ sɩsɩ: «Baabá», ngɛ ɩlɛ́ weedísi sɩsɩ: «Ɩɩ́n, nyɔ́ɔ́ móbú awéní gɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Ngɛ Yaakúbu sɩsɩ: «Mɔ́ɔ́ nbiyaalʊ́ kʊ́bɔnɩ́ Ísááwʊ gɛ. Máagála nya wenbí nyɔ́ɔ́bɔ́ɔ́zɩ ma bɩ nɛ́ gɛ. Kʊrʊ́ njɔ́ɔ ndɔ́ɔ sɔ́m máagágʊ nya bɩ nɛ́, a nyɛ́ɛ́dɛ́, ngóóri nva ma.» ");
INSERT INTO kdh_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ngɛ ɩjaa wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Óo, nŋɩ́nɩ́ gɛ bɩɩgbɛdɩ́ bɩlá gɛ nyóogóyuú sɔ́m ngágʊ́ ɖasam bɩlɛ́ móbú.» Ngɛ woobúsi yɩ sɩsɩ: «Ɖádʊ́ʊ nyɛ́dɛ́ɛ Ɩsɔ́ɔ waanara ná bɩ ɩkɔná ma.» ");
INSERT INTO kdh_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ngɛ ɩjaa wɔɔdɔ́ yɩ sɩsɩ: «Móbú, koduuzi nyádɩ cʊ́kɔ madákɩ nyɔ́rɔ́ mɛbɛ́ɛ sɩsɩ toovonúm nyɔ́ɔ́ móbú Ísááwʊ yáá bɩdɛkɛ́ɛ nya.» ");
INSERT INTO kdh_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Ngɛ Yaakúbu woogóduu ɩjaa-jɔ́. Ɩlɛ́ waadákɩ ɩrɔ nɛ́, ngɛ wɔɔdɔ́ sɩsɩ: «Hḿm, lowú kɛ́ɛ Yaakúbu-dɛ́ɛ ńgɩ gɛ, amá, nʊ́ʊ́zɩ kɛ́ɛ Ísááwʊ nʊ́ʊ́zɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Waadákɩ ɩrɔɔzɩ́ nɛ́, ɩdatɩlɩ́ yɩ; káma, ɩnʊ́ʊ́zɩ rɩ́ŋa-rɔɔzɩ́ cɔɔ́ɔ fʊ́ńdɩ-fʊ́ńdɩ nyazɩ ɩɖawaalʊ Ísááwʊ. Naanɩ́ ikóóri ɩfa yɩ nɛ́, wenbí wɔɔbɔ́ɔ́zɩ yɩ nɛ́ nɖɔ́: ");
INSERT INTO kdh_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","«Toovonúm nyánáábɩ́lɛ́ mebiyaalʊ́ Ísááwʊ?» Ngɛ Yaakúbu sɩsɩ: «Ɩɩ́n, mánáábɩ́lɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ngɛ sɩsɩ: «Móbú, kʊ nɖʊ ma kíɖíím bɩka mɔdɔ́ɔ sɔ́m nyáagágʊ́ bɩ ngɔná ma nɛ́; na bɩka mogóóri mava nya.» Ngɛ Yaakúbu waaɖʊ yɩ kíɖíím iɖi, ɩkɔná yɩ sʊlʊ́m ɩnyɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Bɩɩdɛ́ nɛ́, ngɛ sɩsɩ: «Tɔ́ɔ, móbú, koduu ngbíriki ma.» ");
INSERT INTO kdh_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ngɛ Yaakúbu woogóduu ikpíriki yɩ. Ɩjaa waanɩ́ɩ tóko fɔwʊ́tɩ, ngɛ waaɖʊ yɩ alɩbáráka sɩsɩ: «Óo, móbú-dɛ́ɛ kiveḿ wónvoorí gɛ nyazɩ fɔɔ́ wenká Ɖádʊ́ʊ Ɩsɔ́ɔ waaɖʊ kɛ alɩbáráka nɛ́ kɛdɛ́ɛ foorí. ");
INSERT INTO kdh_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","“Ɩsɔ́ɔ ɩ́mɩzɩ ɩdɛ́ɛ amɩɩlɛ́ nyɔ́rɔ́; bɩka adɛ ɩlá niíni bʊkɔná nya ɖíi na nyɔɔ́ ɖabata. ");
INSERT INTO kdh_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Nyénɖíi kʊ́bɔńdɩ laadásɩ rɩ́ŋa-dɛ́ɛ ɩráa-rɔ, bɩka yíri báa wenkí ɩkɔ́nɩ kisóm nyáázá-daá. Sɩ nɖi ná kʊ́bɔńdɩ njaa-dɛ́ɛ bíya rɩ́ŋa-rɔ, ngɔɔ-dɛ́ɛ bíya isóm nyáázá-daá. Weení ɩrɩ́ŋa sɩ ɩlá nya láálɩ́ nɛ́, láálɩ́ sɩ iti ná ɩrɔ. Amá, weení sɩ ɩɖʊ nya alɩbáráka nɛ́, ɩlɛ́ ɖʊɖɔ íyúú alɩbáráka.”» ");
INSERT INTO kdh_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Sáátɩ wenkí Ɩsaáka woogóóri ɩfa ibú Yaakúbu bɩtɛ́ ɩlɛ́ ɩkpɛdɩ́ ɩlɩ́ɩ nɛ́, ɩɖawaalʊ Ísááwʊ nbɩlɛ́ ɩlɛ́ waagálɩ́ɩ́ná kisɔɔ́ ɩtála. ");
INSERT INTO kdh_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ngɛ ɩlɛ́ ɖʊɖɔ waabá ɩlá ɩjaa kíɖíím kazɔ́ɔ ńbɩ ɩkpɔ́ɔ iboná yɩ. Waadalaná nɛ́, ngɛ wɔɔdɔ́ ɩjaa sɩsɩ: «Baabá, kʊrʊ́ njɔ́ɔ nɖi kíɖíím máagágʊ sɔ́m malaná nya bɩ nɛ́. A nyééɖí ndɛ́, ngóóri nva ma.» ");
INSERT INTO kdh_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ngɛ ɩjaa wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Nyɔ́ɔ́ awé gɛ.» Ngɛ woobúsi yɩ sɩsɩ: «Mɔ́ɔ́ nbiyaalʊ́ kʊ́bɔnɩ́ Ísááwʊ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ɩsaáka waajáŋ ɩnɩ́ɩ bɩlɛ́ nɛ́, ngɛ ɩdɔnʊʊ́ rɩ́ŋa waazʊ́ʊ kaanɩŋá kínzelíi. Ngɛ sɩsɩ: «Ngɛ weení ɩlɛ́ waagágʊ́ ná sɔ́m ɩkɔná ma mɔdɔ́ɔ, bɩka maɖʊ yɩ alɩbáráka naanɩ́ nmɔ́ɔ ngɔ́nɩ ye. Ngʊ́ alɩbáráka kɩḿ, sɩ kɩcɔɔná yɩ gɛ, bɩvɛ́yɩ́ bɛ́nlɛɛ́ ɩjɔ́.» ");
INSERT INTO kdh_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Sáátɩ wenkí Ísááwʊ waanɩ́ɩ ɩjaa nɔɔ́-daá tɔ́m tɩna nɛ́, ngɛ waamá kebiká. Ngɛ wɔɔdɔ́ ɩjaa sɩsɩ: «Baabá, koori nva mɔ́ɔ́ ɖʊɖɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ɩjaa nɔɔ́ nbɩlɛ́ sɩsɩ: «Alɩbáráka wenkí sɩ maɖʊ nya nɛ́, nyénewú wɔɔgɔ́nɩ itúúli ma ɩlɛ́ɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ngɛ ɩmʊ́ sɩsɩ: «Bánÿaá yɩ Yaakúbu-rɔɔzɩ́ gɛ woodúúli ma iɖi ma bɔɔrɩ́ nabʊ́lɛ? Kaɖaa-dɛ́ɛ, wɛɛlɛ́ɛ mɔ́gʊ́bɔńdɩ; lɛlɛɛɖɔ́, ikúti ɩkɔ́nɩ ɩlɛ́ɛ mɛ́dɛ́ɛ alɩbáráka ɩtásɩ.» Ngɛ wɔɔdɔ́ bajaa sɩsɩ: «Baabá, bidokúti bɩka nabʊ́rʊ ngóóri nva mɔ́ɔ́ ɖʊɖɔ?» ");
INSERT INTO kdh_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ngɛ ɩjaa sɩsɩ: «Bɛɛ́ɛ! Nyɔ́gʊ́bɔńdɩ, mééjéle yɩ tɩ; ngɛ igoobíya rɩ́ŋa sɩ balá yɩ bɔwʊtá gɛ. Ɖíi na nyɔɔ́, sɩ ɩbá gɛ ɩkɔ́nɩ iyuú. Bɩlɛ́ nɛ́, móbú, nabʊ́rʊ tɛfɛ́yɩ́ sɩ malá nya.» ");
INSERT INTO kdh_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ngɛ Ísááwʊ sɩsɩ: «Kooríti wentí tɩrɩ́ŋa nyɔ́wɛná tɩ nɛ́ nbɩlɛ́? Baabá, koori gɛ nva mɔ́ɔ́ ɖʊɖɔ.» Ngɛ waamá kebiká ɩbáázɩ wíídi. ");
INSERT INTO kdh_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ngɛ ɩjaa sɩsɩ: «Bɛɛ adɛ laadɔ́ɔ kɛvɛ́yɩ́ niíni nɛ́ kadaá gɛ sɩ njɔ́ɔ, ńdándɩlɩná ɩsɔ́ɔ́dáá amɩɩlɛ́ sɩ amɩ́zɩ lé nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Nyɛ́dɛ́ɛ tókobí sɩ kɩfa ná nya kíɖíím nɖi. Nyénewú gɛ sɩ nlá bɔwʊtá njéle. Amá, a bɩɩgɔ́nɩ bɩkɩ́lɩ nya, nyánlɩɩ́ ɩdɛ́ɛ yíko-daá.» ");
INSERT INTO kdh_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ɩsaáka-dɛ́ɛ alɩbáráka waaɖʊ Yaakúbu nɛ́ kɩrɔɔzɩ́, Yaakúbu ɩmʊ́ waabá ɩbɩ́sɩ Ísááwʊ-dɛ́ɛ ɩ́bɛrɛ gɛ. Ɩjɔɔ́ɔ nɛ́, ilowú-dɛ gɛ sɩsɩ bɛḿ bajaa-dɛ́ɛ lííya wɩ́rɛ sɩ ɩtála nɛ́, ɩmʊ́ sɩ ɩkʊ inewú Yaakúbu gɛ ɩfɛ́rɛ. ");
INSERT INTO kdh_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ngɛ naárʊ waanɩ́ɩ tɔ́m tɩḿ ɩkpɔ́ɔ tɩ iboná ikéveeri bɔgɔɔ Rebééka. Ngɛ ɩlɛ́ waayáa Yaakúbu ifééri yɩ sɩsɩ: «Nɖawaalʊ sɔɔlɛ́ɛ ɩkʊ nya ɩfɛ́rɛ. ");
INSERT INTO kdh_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Bɩlɛ́ nɛ́, móbú, welesi nnɩ́ɩ sɩ maŋmátɩ nya nɛ́. Kʊrʊ́ nze nɖɛ́ɛ maɖawaalʊ Labáanɩ-jɔ́ Haráanɩ tɛ́ɛ́dɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","A bɩgɛ́ɛ nyóóbó, cɔɔ ńna cʊ́kɔ hálɩ nɖawaalʊ-dɛ́ɛ baaná ɩkɔ́nɩ kɩfɛ́ɛ; ");
INSERT INTO kdh_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","njɔ́ɔ bɩlɛ́ hálɩ iwenbiré ɩfɛ́ɛ ɩsɔɔná wenbí nyáálá yɩ nɛ́. Ńnaamʊ́ kɩḿ nɛ́, ménÿelíi ngábɩsɩ. Mádánjaa mébíya lɛ́ɛ́nɩ́ iyóózi basɩ́ beyéle ma.» ");
INSERT INTO kdh_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ngɛ Rebééka weevééri ɩwaalʊ́ Ɩsaáka sɩsɩ: «Mólowú ɩbá gɛ bɩvɛ́yɩ́ Hitíi bíya aléewá péḿ. A Yaakúbu sɩ ɩkpɔ́ɔ ńŋɩnáa bɩlɛ́ bɩdɛ́ɛ aléewá taká, we gɛ sɩ mɔjɔ́ɔ ɖúúlínya-daá malá.» ");
INSERT INTO kdh_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ngɛ Ɩsaáka waayáa ibiyaalʊ́ Yaakúbu ɩmʊ́ ikóóri ɩfa yɩ, ngɛ waava yɩ wɛ́ɖɛ sɩsɩ: «Nkɔkpɔ́ɔ Kanáanɩ tɛ́ɛ́dɩ tɩna tɩdaá alʊ́ naárʊ. ");
INSERT INTO kdh_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Kʊrʊ́ nbó Padan-Aráamɩ tɛ́ɛ́dɩ-daá; a nyáádála, nzʊ́ʊ ngɔɔ ɩjaa Betuwɛ́ɛlɩ-dɛ́ɛ, ngbɔ́ɔ ngɔɔ ɖawaalʊ Labáanɩ-dɛ́ɛ bíya aléewá-daá naárʊ. ");
INSERT INTO kdh_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ɩsɔ́ɔ yíko-dʊ́ʊ ɩ́ɖʊ́ nya alɩbáráka nlʊ́rʊ bɩlʊ́rʊ bʊɖɔ́ɔ, bɩka yíriwá ɖabata ɩlɩ́ɩ nyɛ́dɛ́ɛ lʊrʊ́ʊ bɩḿ bɩdaá. ");
INSERT INTO kdh_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ɩsɔ́ɔ ɩ́ɖʊ́ nyána nyébíya‑bíya alɩbáráka wenkí waaɖʊ Ibrahím nɛ́; bɩka tɛ́ɛ́dɩ Ɩsɔ́ɔ waava tɩ Ibrahím nyɔ́jɔɔ́ɔ tɩdaá ɩgɔ́ńdɩ ɖɔ́ nɛ́ tɩbɩ́sɩ nyɛ́dɛ́ɛ ńdɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Ɩsaáka wɔɔdɔ́ Yaakúbu bɩlɛ́ nɛ́, ngɛ ɩlɛ́ waagbɩ́ɩ́rɩ ɩkʊrʊ́ ɩɖɛ́ɛ Padan-Aráamɩ Betuwɛ́ɛlɩ Aráamɩ ńnɩ́ biyaalʊ́ Labáanɩ-jɔ́. Labáanɩ ɩmʊ́ gɛ Yaakúbu na Ísááwʊ beese, bɔgɔɔ Rebééka ɖawaalʊ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Bɩjɔɔ́ɔ nɛ́, Ísááwʊ wooyuú ɩnɩ́ɩ sɩsɩ bajaa Ɩsaáka waaɖʊ Yaakúbu alɩbáráka, bɩka ɩtɔ́ yɩ sɩ ɩɖɛ́ɛ Padan-Aráamɩ na ɩkpɔ́ɔ alʊ́. Sɩ ikóóri ɩfa yɩ nɛ́, waava wɛ́ɖɛ gɛ sɩsɩ ɩmʊ́ ɩ́dánjaa sɩsɩ ɩ́kpɔɔ Kanáanɩ tɛ́ɛ́dɩ-daá alʊ́ naárʊ; ");
INSERT INTO kdh_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","ngɛ Yaakúbu waanɩ́ɩ ɩjaa nɔɔ́ ɩkpɩ́ɩ́rɩ ɩɖɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Bajaa waaŋmátɩ bɩlɛ́ nɛ́, Ísááwʊ wooyuú ɩnɩ́ɩ bɩdaá sɩsɩ Kanáanɩ tɛ́ɛ́dɩ-daá aléewá-dɛ́ɛ tɔ́m tasʊ́ʊ yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ngɛ Ísááwʊ waagʊrʊ́ ɩɖɛ́ɛ Asʊmáyɩ́la-dɛ́ɛ sɩ ɩkɔ́gbɔ́ɔ alʊ́. Ɩdɛ́ɛ aláa ɩvʊnwɛná wɛ nɛ́ babaasí, ngɛ waadásɩ ɩkpɔ́ɔ Ibrahím biyaalʊ́ Asʊmáyɩ́la wɛɛlɛ́ɛ Mahalátu. Mahalátu ɩmʊ́ ɩɖawaalʊ gɛ Nebayɔ́ɔtɩ. ");
INSERT INTO kdh_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Ngɛ Yaakúbu waagbɩ́ɩ́rɩ ɩkʊrʊ́ Bɛrɩsebáa wɛ́nɖɛɛ́ Haráanɩ. ");
INSERT INTO kdh_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ɩbamáa ɖɛɛ́ ngɛ waadála ɖeelí gɛ kiiyu yɩ nɛ́, ngɛ wooɖóo ńna. Sɩ ɩfɩ́nɩ nɛ́, ngɛ wɔɔgbɔ́ɔ bʊ́ʊ́rɛ neɖére ɩtɩlɩ́ ɩgʊjʊʊ́ ɩcáŋ ɩfɩ́nɩ ɖɩdáarɛ ɖɩḿ ɖɩdaá. ");
INSERT INTO kdh_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ɖóm-daá gɛ wooɖóózi ɖoozire neɖére. Wooɖóózi sɩsɩ karɩ́-karɩ́ ɩbaná kɩzɩ́ŋɛ́ɛ adɛ, ngɛ kɩɩbɩ́nɩ hálɩ kikédékíná ɩsɔ́ɔ́dáá ŋmɩ́ńdɩ; ngɛ Ɩsɔ́ɔ-dɛ́ɛ malááyɩ́kawá wángbáa kɩrɔ béndím. ");
INSERT INTO kdh_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ tɩtɩŋa kazɩ́ŋɛ́ɛ kʊgʊjʊʊ́-daá wɔ́ndɔ́m ɩmʊ́ sɩsɩ: «Mánáábɩ́lɛ́ nyádʊ́ʊ Ɩsɔ́ɔ, njaa Ibrahím-dɛ́ɛ Ɩsɔ́ɔ; Ɩsaáka-dɛ́ɛ Ɩsɔ́ɔ. Laadɔ́ɔ nyávɩ́nɛ́ɛ kɔrɔ ɖɔ́ nɛ́, nyána nyébíya‑bíya gɛ sɩ mava kɛ. ");
INSERT INTO kdh_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Nyébíya-bíya sɩ bɔɖɔ́ɔ gɛ nyazɩ buuruú bɩlɛ́; sɩ bɔcɔ́ɔ nɛ́, bánbá gɛ bɔfɔ badɩ, kɔgbɔɔ wɩ́sɩ ɖaagalɩɩɖɛ́ hálɩ sɩɖaagazalaɖɛ́; nyánʊ́ʊ́nɩ kíɖiiwú-rɔ hálɩ nyánʊ́ʊ́nɩ nɩbɩɩwʊ́-rɔ. Nyána nyébíya‑bíya gɛ sɩ mabaná maɖʊ ɖúúlínya ɩráa rɩ́ŋa alɩbáráka. ");
INSERT INTO kdh_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Mɔ́ɔ́ mɔ́wɛ nyɔ́jɔ́ gɛ; báa lé gɛ nyóóbó, sɩ mazɩ́ŋ nyɔ́wɔ́rɔ́ gɛ hálɩ ngábɩsɩ tɛ́ɛ́dɩ tɩna tɩdaá cé. A ɖé mádala tá wenbí mɔ́ɔ́dɔ́ nya nɛ́, mɛ́vɛ́yɩ́ mɛ́nɖɛɛ́ meyéle nya.» ");
INSERT INTO kdh_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ngɛ Yaakúbu wɛɛnyɛ́ ifé sɩsɩ: «Toovonúm gɛ, Ɖádʊ́ʊ Ɩsɔ́ɔ wɛ cé, mádafʊ́ńdɩlɩ́ bɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Bɩɩlá bɩlɛ́ nɛ́, ngɛ nɩdáárɛ waazʊ́ʊ yɩ ɩtɔ́ sɩsɩ: «Óo, maamááci gɛ ɖɩdáarɛ ɖɩna; cé gɛ Ɩsɔ́ɔ-dɛ́ɛ ɖɔɔ́, cé gɛ arɩjáńna ɖɔɔ́ wɔnɔɔ́.» ");
INSERT INTO kdh_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Kiivé nɛ́, wɔɔjɔ́ɔ́rɩ ɩkʊrʊ́; ngɛ wɔɔgbɔ́ɔ bʊ́ʊ́rɛ waadɩ́lɩ ɖɛ ɩgʊjʊʊ́ nɛ́ isúu ɩsɩ́ɩ. Woozúu ɖɛ bɩlɛ́ nɛ́, ngɛ waabɩ́rɩ núm ɖɩgʊjʊʊ́-daá. ");
INSERT INTO kdh_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ngɛ waava ɖɩdáarɛ ɖɩḿ yɩ́ɖɛ sɩsɩ Betɛ́ɛlɩ, bugutoluú sɩsɩ Ɩsɔ́ɔ-dɛ́ɛ ɖɔɔ́; bɩka fáráńdɩ́ wenkí kɩdaá ɩwɛ nɛ́, bánvʊnÿaá kɩ gɛ sɩsɩ Lúuzi. ");
INSERT INTO kdh_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Tɔ́ɔ, Yaakúbu wooɖuuná gɛ sɩsɩ: «Mɛ́dɛ́ɛ nɩ́bááwʊ mɛ́nɖɛɛ́ kɩ ɖɔ́ nɛ́, a ɖé Ɩsɔ́ɔ waazɩ́ŋ mɔ́wɔ́rɔ́ kɩdaá, bɩka ifére mɔ́rɔ́, ɩfa ma ɖíi na nyɔɔ́ na kpɩná kúsuuyé, ");
INSERT INTO kdh_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ngɛ a máagábɩ́sɩ́ná alaafɩ́ya majaa-dɛ́ɛ, bɩlɛ́ nɛ́, Ɖádʊ́ʊ Ɩsɔ́ɔ wánbɩsɩ́ mɛ́dɛ́ɛ ńnɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Bʊ́ʊ́rɛ ɖɩna móózúu ɖɛ mazɩ́ɩ ɖɔ́ nɛ́, ɖɩ́nbɩsɩ́ Ɩsɔ́ɔ-dɛ́ɛ ɖaána; ngɛ wenbí bɩrɩ́ŋa Ɩsɔ́ɔ sɩ ɩfa ma bɩ nɛ́, mándarɩ́ɩ bɩ bʊrɔ fuú gɛ mejéle yɩ bɩdɛ́ɛ kʊ́ɖʊńbɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Ngɛ wɔɔgbɔ́ɔ nɩ́bááwʊ hálɩ wɩ́sɩ ɖaagalɩɩɖɛ́ fáráńdɩ́ ńba-dɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Waadála fɔɔ́ nɛkɛ́rɛ-daá nɛ́, waana lɔkɔ nakɩ́rɩ. Lɔkɔ kɩḿ kɩjɔ́ nɛ́, bóńdúuzi fééni fuwé náádoozo basɩ́ɩ tɩjɔɔ́ɔ tɩ́nvɛɛzɩ́. Ńna gɛ tɩ́ndárányɔɔ́ lɩ́m. Bʊ́ʊ́rɛ wenɖé bónzulúu lɔkɔ kɩḿ kɩnɔɔ́-rɔ nɛ́, bʊ́ʊ́rɛ gɛ fɩ́ya ńɖɛ. ");
INSERT INTO kdh_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","A bɩgɛ́ɛ fééni rɩ́ŋa woodúúzi bɩlɛ́, na botúúzi bʊ́ʊ́rɛ kpɔ́mɔ́ɔ́ na tɩnyɔ́ɔ; bɩɩdɛ́ nɛ́, babɩsɩná ɖɛ bosúlu ɖɩɖɩdáarɛ. ");
INSERT INTO kdh_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yaakúbu waana lɔkɔ bɩlɛ́ nɛ́, ngɛ wɔɔbɔ́ɔ́zɩ fééni ketiráa bɔwɛ ńna nɛ́ sɩsɩ: «Mogoobíya, lé gɛ mɩ́ɩgálɩ́ɩ́ná.» Ngɛ bɛlɛ́ boobúsi yɩ sɩsɩ: «Haráanɩ». ");
INSERT INTO kdh_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ngɛ sɩsɩ: «Mɩ́nyɩ ɩrʊ́ weení bánÿaá yɩ sɩsɩ Nahɔ́ɔrɩ nɛ́ ibiyaalʊ́ Labáanɩ?» Ngɛ bɛlɛ́ sɩsɩ: «Ɩɩ́n, ɖányɩ yɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ngɛ ɩmʊ́ sɩsɩ: «Ɩ́na ɩdɩ?» Ngɛ bɛlɛ́ boodóbusi yɩ sɩsɩ: «Alaafɩ́ya, hálɩ bɛɛ ɩwɛɛlɛ́ɛ Rasɩ́ɩ́la kɛrɛŋɛ ná bɩlɛ́ ɩ́gana fééni.» ");
INSERT INTO kdh_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ngɛ Yaakúbu sɩsɩ: «Kudoyúu ta botúúzi fééni; ɩva tɩ lɩ́m tɩnyɔ́ɔ, bɩka ɩbɩ́sɩ kisɔɔ́.» ");
INSERT INTO kdh_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Waaŋmátɩ bɩlɛ́ nɛ́, ngɛ ketiráa bɛḿ boobúsi yɩ sɩsɩ: «Ɖɔ́ɔ́ ɖádánbɩɩzɩ; asée fééni rɩ́ŋa wóńdúuzi na ɖutúúzi bʊ́ʊ́rɛ lɔkɔ nɔɔ́-jɔ́ na tɩnyɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yaakúbu bamáa ŋmatɩrɛ bɩlɛ́ gɛ Rasɩ́ɩ́la waadála ɩ́gana ɩjaa-dɛ́ɛ fééni. Rasɩ́ɩ́la ɩmʊ́ ɩjɔɔ́ɔ bɩlɛ́ nɛ́, fééni ketirú gɛ ɩgɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Sáátɩ wenkí Yaakúbu waana weeseni Labáanɩ wɛɛlɛ́ɛ Rasɩ́ɩ́la na isenúu ɩmʊ́ ɩdɛ́ɛ fééni nɛ́, ngɛ waajáŋ itúu ɩtɩlɩná lɔkɔ itúúzi bʊ́ʊ́rɛ ɖizuláa nɛ́ ɩlɛ́ ivééni ɩnyɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Ngɛ woobó ikpíriki Rasɩ́ɩ́la ɩmʊ́ na wíídi, bʊdɔcɔ yɩ ɩɖɔ́kɩ ɩdɩ. ");
INSERT INTO kdh_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ngɛ weevééri yɩ sɩsɩ ɩmʊ́ ɩ́na ɩjaa bɛgɛ́ɛ koobíre gɛ; ɩmʊ́ ɩnáábɩ́lɛ́ Rebééka-dɛ́ɛ bú. Wɔɔdɔ́ bɩlɛ́ nɛ́, ngɛ ɩlɛ́ waajáŋ ise ibó ikéveeri tɩ ɩjaa Labáanɩ. ");
INSERT INTO kdh_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labáanɩ waanɩ́ɩ baaŋmátɩ inewú-bú Yaakúbu-dɛ́ɛ tɔ́m bɩlɛ́ nɛ́, ngɛ ɩlɛ́ ɖʊɖɔ weeze ɩlɩ́ɩ ɩkázɩŋ yɩ, ikpíriki yɩ, ɩkpɔ́ɔ yɩ ɩkázʊ́ʊ́ná ɖaána. Baadála ɖaána nɛ́, ngɛ Yaakúbu waadɩ́ wenbí bɩrɩ́ŋa kpátáá bɩɩmɔɔná yɩ nɛ́ ifééri yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Ńna gɛ Labáanɩ weevééri yɩ sɩsɩ: «Tʊtʊʊ́rɛ, nyábá nyɛ́gɛ́ɛ máárʊ́ gɛ; mána nya koobíre kʊ́ɖʊńɖɛ gɛ.» Tɔ́ɔ, irodúu ɖebilibili gɛ Yaakúbu wɔɔjɔ́ɔ Labáanɩ-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Wɩ́rɛ gɛ Labáanɩ weevééri yɩ sɩsɩ: «Bɩdɛkɛ́ɛ nyɛ́gɛ́ɛ mɛ́dɛ́ɛ ńnɩ́-rɔ gɛ nyɔ́nvɔɔzɩ́ ma faala; bɩlɛ́ nɛ́, feeri ma wenbí máta mɛvɛ́rɛ nya nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Ngʊ́ nbɛ́ɛ́ŋ nɛ́, Labáanɩ wɛná bíya aléewá nɔɔ́lɛ. Kʊ́bɔnɩ́ gɛ bánÿaá sɩsɩ Léya, kúmuú nɛ́, Rasɩ́ɩ́la. ");
INSERT INTO kdh_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Léya ɩlɛ́ waazá-daá cɔɔ́ɔ summ, bɩka Rasɩ́ɩ́la ɩlɛ́ waazɩ́ŋ aléeré, ɩbá ɩjɔɔ́ɔ kazɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yaakúbu ɩgʊ́ ɩzɔɔlɛ́ɛ Rasɩ́ɩ́la gɛ; ngɛ wɔɔdɔ́ Labáanɩ sɩsɩ: «Mánlám nya bɔwʊtá bɩ́ɩ́zɩ lʊbɛ nyɛ́dɛ́ɛ aléeré kúmuú Rasɩ́ɩ́la-rɔɔzɩ́.» ");
INSERT INTO kdh_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Wɔɔdɔ́ bɩlɛ́ nɛ́, ngɛ Labáanɩ weedísi sɩsɩ: «Mava nya yɩ cɔɔ́ɔ ma kazɔ́ɔ bɩkɩ́lɩ mava yɩ naárʊ yéḿ; cɔɔ mɔ́jɔ́.» ");
INSERT INTO kdh_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ngɛ Yaakúbu waalá bɔwʊtá bɩ́ɩ́zɩ lʊbɛ ɩfɛ́rɛ Rasɩ́ɩ́la kʊjʊʊ́-rɔ. Ɩzɔɔlɛ́ɛ yɩ nɛ́, bɩ́ɩ́zɩ sɩḿ sɩɩgbɛdɩ́ gɛ sɩlá waazá-jɔ́ nyazɩ wɛ́ náálɛ bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ngɛ wɔɔdɔ́ Labáanɩ sɩsɩ: «Bɩ́ɩ́zɩ ɖáázɩ́ɩ nɛ́, siizúluki, cele ma mɛɖɛɛlʊ́ mɔgbɔ́ɔ yɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ngɛ Labáanɩ woobó ɩyáa ɩráa itúúzi balá hiije kɩḿ kɩdɛ́ɛ jíńgáárɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Bɩɩdásɩ ɖaanɩ́ŋa nɛ́, ngɛ wɔɔgbɔ́ɔ ɩwɛɛlɛ́ɛ Léya iboná Yaakúbu; ngɛ ɩ́na yɩ baavɩ́nɩ. ");
INSERT INTO kdh_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Bɩɩga nɛ́, Labáanɩ ɩmʊ́ ɩdɛ́ɛ yoḿ alʊ́ Zílipa gɛ wɔɔgbɔ́ɔ icéle ɩwɛɛlɛ́ɛ ɩmʊ́ sɩsɩ ɩfɔ́ɔ́zɩ yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Kiivé tɛ́ɛrɛ́ Yaakúbu woolósi ɩɖɛɛlʊ́ ɩzá-daá nɛ́, awé nbɩlɛ́, Léya nbɩlɛ́. Ńna gɛ wɔɔdɔ́ Labáanɩ sɩsɩ: «We gɛ nyáálá ma bɩlɛ́. Rasɩ́ɩ́la-dɛ́ɛ kpɔwʊ́ʊ-rɔɔzɩ́ gɛ máálá nya bɔwʊtá. We-rɔ gɛ nyóódúúli ma ɖɔ́.» ");
INSERT INTO kdh_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Ngɛ Labáanɩ sɩsɩ: «Ɖɔ́ɔ́ ɖɛ́dɛ́ɛ cé nɛ́, newúu tánzaa ɩka kaáwʊ. ");
INSERT INTO kdh_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Nyána ceení ɩdɛ́ɛ́zɩ wɛ́ lʊbɛ kɩna ɖíi na ɖɩtáfáa nya waaganáa na ndásɩ nlá ma bɔwʊtá bɩ́ɩ́zɩ lʊbɛ ɖʊɖɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yaakúbu woovu ɩlá bɩlɛ́ ɩ́na Léya bɛtɛ́ɛ́zɩ wɛ́ lʊbɛ ɖíi. Ngɛ Labáanɩ wɔɔgbɔ́ɔ ɩwɛɛlɛ́ɛ Rasɩ́ɩ́la itécelí yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ngɛ wɔɔgbɔ́ɔ ɩdɛ́ɛ yoḿ alʊ́ Bíla icéle Rasɩ́ɩ́la ɩmʊ́ sɩsɩ ɩfɔ́ɔ́zɩ yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yaakúbu na Rasɩ́ɩ́la baadɩlɩ́ ɖamá; ngɛ Yaakúbu wɔɔzɔ́ɔ́lɩ yɩ bukúti bɩkɩ́lɩ Léya. Ngɛ wɔɔjɔ́ɔ Labáanɩ ɩmʊ́ ɩjɔ́ ɩtásɩ ɩfɔ́ɔ́zɩ yɩ bɩ́ɩ́zɩ lʊbɛ ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ɖádʊ́ʊ Ɩsɔ́ɔ waana sɩsɩ baraazɔɔlɛ́ɛ Léya nɛ́, ngɛ waava yɩ lʊrʊ́ʊ, bɩka Rasɩ́ɩ́la ɩlɛ́ ɩbɩ́sɩ kaalʊrʊya. ");
INSERT INTO kdh_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Ngɛ Léya wɛɛyɛ́ɛ fuwá ɩlʊ́rʊ bú abaalʊ́ ɩfa yɩ yɩ́ɖɛ sɩsɩ Rʊ́bɛ́ɛnɩ. Wenbí nɛ́, wɔɔdɔ́ gɛ sɩsɩ: «Ɖádʊ́ʊ Ɩsɔ́ɔ waana fɛɛrɛ́ baaɖʊ ma ɖɛ nɛ́. Lɛlɛɛɖɔ́ nɛ́, mawaalʊ́ wɔ́nzɔɔlɩ́ ma.» ");
INSERT INTO kdh_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Bʊwɔ́rɔ́ nɛ́, ngɛ waadásɩ ɩyɛ́ɛ fuwá ɖʊɖɔ ɩlʊ́rʊ bú abaalʊ́. Ngɛ wɔɔdɔ́ sɩsɩ: «Ɖádʊ́ʊ Ɩsɔ́ɔ waadɩlɩ́ sɩsɩ bádánjaa ma nɛ́, ngɛ waava ma ceení ɖʊɖɔ.» Ńna gɛ waava ɩlɛ́ yɩ́ɖɛ sɩsɩ Simeyɔ́ɔnɩ. ");
INSERT INTO kdh_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Bʊwɔ́rɔ́ nɛ́, waadásɩ ɩyɛ́ɛ fuwá ɖʊɖɔ ɩlʊ́rʊ bú abaalʊ́. Ngɛ sɩsɩ: «Lɛlɛɛɖɔ́-dɛ́ɛ nɛ́, máálʊ́rʊ mawaalʊ́ bíya noódoozo nbɩlɛ́, wɔ́ngbɔwʊ́ʊ ɩdɩ ɩtaná ma.» Bʊrɔɔzɩ́ gɛ baava bú ɩmʊ́ yɩ́ɖɛ sɩsɩ Léévi. ");
INSERT INTO kdh_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ngɛ woogúti ɩyɛ́ɛ fuwá ɩlʊ́rʊ bú abaalʊ́; ngɛ sɩsɩ: «Lɛlɛɛɖɔ́ nɛ́, mánzám Ɖádʊ́ʊ Ɩsɔ́ɔ.» Bʊrɔɔzɩ́ gɛ waava ɩlɛ́ yɩ́ɖɛ sɩsɩ Yudáa, ɩcáŋ iyéle lʊrʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rasɩ́ɩ́la wɔɔgɔ́nɩ ɩna sɩsɩ ɩvɛ́yɩ́na lʊrʊ́ʊ nɛ́, ngɛ waazʊ́ʊ ɩgaa sʊ́ʊ́zɩ lám. Ngɛ wɔɔdɔ́ Yaakúbu sɩsɩ: «Fa ma bíya, a bɩdɛkɛ́ɛ bɩlɛ́, mánzɩ́m.» ");
INSERT INTO kdh_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Waaŋmátɩ bɩlɛ́ nɛ́, ngɛ Yaakúbu wɛɛyɛɛná yɩ baaná sɩsɩ: «Mánáábɩ́lɛ́ Ɩsɔ́ɔ yáá wé, bɩdɛkɛ́ɛ mɔ́jɔ́; Ɩsɔ́ɔ wɔɔdɔ ná nya lʊrʊ́ʊ.» ");
INSERT INTO kdh_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ngɛ Rasɩ́ɩ́la sɩsɩ: «Bɛɛ mɛ́dɛ́ɛ yoḿ Bíla nɖɔ́, bo nyána yɩ ɩfɩ́nɩ ɩlʊ́rʊ na mɔgɔrɩ́ ibíya mɔ́ɔ́ ɖʊɖɔ meɖi ɩdɛ́ɛ alɩbáráka moyuú bíya.» ");
INSERT INTO kdh_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ngɛ wɔɔgbɔ́ɔ Bíla ɩfa Yaakúbu ɩlɛ́ ɩ́na yɩ bafɩ́nɩ. ");
INSERT INTO kdh_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ngɛ ɩlɛ́ wɛɛyɛ́ɛ fuwá ɩlʊrʊ ná Yaakúbu bú abaalʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ngɛ Rasɩ́ɩ́la sɩsɩ: «Ɩsɔ́ɔ weeɖéézi ma. Waanɩ́ɩ mázʊ́lʊ́ńdɩ ɩfa mɔ́ɔ́ ɖʊɖɔ bú abaalʊ́.» Ngɛ waava bú ɩmʊ́ yɩ́ɖɛ sɩsɩ Dáanɩ. ");
INSERT INTO kdh_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Biigúti bɩjɔɔ́ɔ nɛ́, Bíla waadásɩ ɩyɛ́ɛ fuwá ɩlʊrʊná Yaakúbu bú sɩɩlɛ ńnɩ́ abaalʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Ngɛ Rasɩ́ɩ́la sɩsɩ: «Mána magaa ɖáálʊ́ Ɩsɔ́ɔ ɩzá-daá, ngɛ máágá yɩ.» Ngɛ waava bú ɩmʊ́ yɩ́ɖɛ sɩsɩ Nɛfɩtalíi. ");
INSERT INTO kdh_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Léya ɩlɛ́ wɔɔgɔ́nɩ ɩna sɩsɩ ɩdɛ́ɛ lʊrʊ́ʊ waazɩ́ŋ nɛ́, ngɛ wɔɔgbɔ́ɔ ɩdɛ́ɛ yoḿ Zílipa ɖʊɖɔ ɩfa ɩwaalʊ́ Yaakúbu. ");
INSERT INTO kdh_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ngɛ Zílipa waalʊrʊná Yaakúbu bú abaalʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Bɩɩlá bɩlɛ́ nɛ́, ngɛ Léya sɩsɩ: «Alehééri wenkí nɖɔ́.» Ngɛ waava bú ɩmʊ́ yɩ́ɖɛ sɩsɩ Gaádɩ. ");
INSERT INTO kdh_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Bʊwɔ́rɔ́ ɖʊɖɔ nɛ́, ngɛ Zílipa waadásɩ ɩyɛ́ɛ fuwá ɩlʊrʊná Yaakúbu bú abaalʊ́ sɩɩlɛ ńnɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Bɩnáábɩ́lɛ́ Léya sɩsɩ: «Kʊjʊʊ́ niíni wenkí nɖɔ́ ɖʊɖɔ; aléewá rɩ́ŋa sɩ bayáa ma gɛ sɩsɩ kʊjʊʊ́ niíni-dʊ́ʊ.» Ngɛ waava bɩlɛ́ bɩdɛ́ɛ bú yɩ́ɖɛ sɩsɩ Asɛ́ɛrɩ. ");
INSERT INTO kdh_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Mɩlá naárɛ kʊ́m sáátɩ gɛ Rʊ́bɛ́ɛnɩ waalɩ́ɩ ɩkáná lʊrʊ́ʊ cɔ́kɔ́ɔ́rɛ-bíya bɔjɔɔ́ɔ nyazɩ cʊ́cʊ́ɖɛ-bíya nɛ́ fɔɔ́-daá ɩkájaa ɩkɔ́gɔ́ná ɩgɔɔ Léya. Ngɛ Rasɩ́ɩ́la woobó ɩsʊ́lʊ Léya sɩsɩ: «Ówu, la suúru nva ma nbiyaalʊ́-dɛ́ɛ cʊ́cʊ́ɖɛ-bíya.» ");
INSERT INTO kdh_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ngɛ ɩlɛ́ woobúsi yɩ sɩsɩ: «Nyɛ́ɛ́lɛ́ɛ mawaalʊ́ nɛ́, bɩdɔɖɔ́ɔ nya; nyɔ́zɔɔlɛ́ɛ ndásɩ nlɛ́ɛ móbú-dɛ́ɛ cʊ́cʊ́ɖɛ-bíya?» Ngɛ Rasɩ́ɩ́la woobúsi yɩ sɩsɩ: «Tɔ́ɔ, ɩ́sʊʊ nyɔ́wɔ́rɔ́ sinje iɖóo ɖɩkɛɛná cʊ́cʊ́ɖɛ-bíya.» ");
INSERT INTO kdh_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ɖaanɩ́ŋa-rɔ Yaakúbu waagálɩɩ fɔɔ́ ɩtála nɛ́, ngɛ Léya waalɩ́ɩ ɩsɩ́ŋ yɩ sɩsɩ: «Mána nya sɩ ɖiɖoo ná sinje. Mɔ́ɔ́gbɔ́ɔ mébiyaalʊ́-dɛ́ɛ cʊ́cʊ́ɖɛ-bíya mɛgɛɛná sɩsɩ na ɖuɖóo.» Ngɛ Yaakúbu waazʊ́ʊ Léya wɔ́rɔ́ ɩ́na yɩ boɖóo nuvoowú kɩḿ. ");
INSERT INTO kdh_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ɩsɔ́ɔ waamʊ Léya-dɛ́ɛ sʊlʊ́ńdɩ, ngɛ wɛɛyɛ́ɛ fuwá ɩlʊrʊná Yaakúbu bú abaalʊ́ nʊʊwa ńnɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ngɛ Léya sɩsɩ: «Mɔ́ɔ́gbɔ́ɔ mɛ́dɛ́ɛ yoḿ mejéle mawaalʊ́ nɛ́, Ɩsɔ́ɔ wɛɛvɛ́rɛ ma kɩvɛrɛwʊ.» Ngɛ waava bú ɩmʊ́ yɩ́ɖɛ sɩsɩ Isakáarɩ. ");
INSERT INTO kdh_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Waadásɩ ɩyɛ́ɛ fuwá ɖʊɖɔ ɩlʊrʊná Yaakúbu bú abaalʊ́ loɖo ńnɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ngɛ sɩsɩ: «Ɩsɔ́ɔ waalá ma kʊjɔɔwʊ kífeńgi; máálʊ́rʊ́ná mawaalʊ́ bíya kʊjʊ́nɩ loɖo nɛ́, lɛlɛɛɖɔ́-dɛ́ɛ nɛ́, wánlaanáa ma.» Ngɛ waava bú ɩmʊ́ yɩ́ɖɛ sɩsɩ Zabulɔ́ɔnɩ. ");
INSERT INTO kdh_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Bʊwɔ́rɔ́ nɛ́, ngɛ waalʊ́rʊ bú aléeré ɩfa ɩlɛ́ yɩ́ɖɛ sɩsɩ Dína. ");
INSERT INTO kdh_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Bɩjɔɔ́ɔ nɛ́, ngɛ Ɩsɔ́ɔ wɔɔdɔ́ɔ́zɩ Rasɩ́ɩ́la-rɔɔzɩ́ ɩmʊ ɩdɛ́ɛ sʊlʊ́ńdɩ ɩfa yɩ lʊrʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ngɛ wɛɛyɛ́ɛ fuwá ɩlʊ́rʊ bú abaalʊ́. Ńna gɛ sɩsɩ: «Ɩsɔ́ɔ waalɩzɩ́ ma fɛɛrɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ngɛ waava yɩ yɩ́ɖɛ sɩsɩ Ísifu. Ngɛ waazʊ́lʊ sɩsɩ Ɖádʊ́ʊ Ɩsɔ́ɔ ɩ́tasɩ ɩfa ɩmʊ́ bú abaalʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Ísifu-dɛ́ɛ lʊrʊ́ʊ wɔ́rɔ́ nɛ́, ngɛ Yaakúbu wɔɔdɔ́ Labáanɩ sɩsɩ: «Cɛ ma megbé máɖaána. ");
INSERT INTO kdh_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Bɩlɛ́ nɛ́, cele ma mɛ́dɛ́ɛ aláa na mébíya máálá tɩmɛ́rɛ bɔrɔ nyɛ́dɛ́ɛ cé nɛ́ bɩka mɛɖɛ́ɛ. Nyádɩtɩŋa nyányɩ nŋɩ́nɩ́ mɔ́ɔ́vɔ́ɔ́zɩ nya nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ngɛ Labáanɩ weevééri yɩ sɩsɩ: «Máávɩ́nɩ nya, mɔ́ɔ́bɔ́ɔ́zɩ madɩlɩ́ sɩsɩ nyɔ́rɔ́ɔ́zɩ́, Ɖádʊ́ʊ Ɩsɔ́ɔ waaɖʊ ma alɩbáráka. ");
INSERT INTO kdh_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Bɩlɛ́ nɛ́, feeri ma nŋɩ́nɩ́ sɩ mɛvɛ́rɛ nya nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ngɛ Yaakúbu sɩsɩ: «Nyányɩ bɔwʊtá máálá nya kɩ nɛ́, ngɛ nyányɩ ɖʊɖɔ nŋɩ́nɩ́ mɔ́rɔ́ɔ́zɩ́ nyávʊ́ńdɩ kpɩná waabɩ́sɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Cʊ́kɔ wenkí nyávʊnwɛná kɩ naanɩ́ mɔgɔ́nɩ nɛ́, lɛlɛɛɖɔ́ kɩɩbá kifizí. Ɖoo mɔ́gɔ́nɩ́ nyɛ́dɛ́ɛ cé, Ɖádʊ́ʊ Ɩsɔ́ɔ waabá ɩɖʊ nya alɩbáráka. Bɩɩdála mɔ́ɔ́ ɖʊɖɔ malá tɩmɛ́rɛ mɔvɔ́ɔ́zɩ mɛ́dɛ́ɛ zamɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Ngɛ Labáanɩ sɩsɩ: «Bɩlɛ́ nɛ́, we gɛ mɛ́vɛrɛ nya ɖɔ́.» Ngɛ Yaakúbu sɩsɩ: «Nkɛfɛ́rɛ ma nabʊ́rʊ, a nyéédísi wentí sɩ mevééri nya tɩ ɖɔ́ nɛ́ mánbaazɩ́ nyɛ́dɛ́ɛ fʊ́ńdɩ kpɩná ketí, bɩka mɛbɛ́ɛ́ŋ tɩrɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Sinje tɩtɩŋa, yele mazʊ́ʊ nyávʊ́ńdɩ kpɩná-daá madára yɛ ndɩ‑ndɩ. Mánlɩzɩ́ɩ fééni kɩ́kpádɩ́tɩ fɔɔlʊʊ́, malɩzɩ́ namɩ́nɩ-daá wentí tɩvʊ́ńdɩ wɔɔyɔ́ɔ yáá tɩɩja nɛ́ ɖʊɖɔ fɔɔlʊʊ́. Mɛ́dɛ́ɛ kɩvɛrɛwʊ sɩ nvɛ́rɛ ma kɩ nɛ́ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","A ceré wɔ́rɔ́ nyádɩtɩŋa nyɔ́ɔ́gɔ́nɩ nna mɛ́dɛ́ɛ kɩvɛrɛwʊ wenbí nɛ́, nyándɩlɩ́ɩ sɩsɩ módomúúli nya. A nyááná namɩ́nɩ wentí tɩrɩ́ŋa tɩvʊ́ńdɩ taca, na fééni tibiráa nɛ́ mɔ́jɔ́, mááŋmɩ́ɩ́lɩ tɩ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Waaŋmátɩ bɩlɛ́ nɛ́ gɛ Labáanɩ sɩsɩ: «Bɩ́la ńŋɩnáa nyɔ́ɔ́dɔ́ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Bɩɩjáŋ bɩdɛ́ɛ wɩ́rɛ gɛ Labáanɩ wɔɔdɔ́ɔ́zɩ agbɛzɛyɩ́wá tɩvʊ́ńdɩ waaja bɩca nɛ́, na namɩ́nɩ aláa tɩvʊ́ńdɩ wɔɔyɔ́ɔ bɩyɔ́ɔ nɛ́, na fééni tɩvʊ́ńdɩ waaja bɩca ɖʊɖɔ nɛ́ fɔɔlʊʊ́; ɩkpɔ́ɔ tɩlɛ́ ɩɖʊ ibiyaalɩnáa ndɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ngɛ wɔɔdɔ́ wɛ bakpɩ́ɩ́rɩ bakʊrʊ́ ńna bobó nyazɩ wɛ́ náádoozo boɖé-dɛ́ɛ bolíni ɩtára bána Yaakúbu bɔlɔwʊtáá. Ngɛ Yaakúbu ɩlɛ́ waawalɩ́ wéngetí fʊ́ńdɩ kpɩná aaga nɛ́ Labáanɩ-dɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Ńna gɛ Yaakúbu wɔɔgbɔ́ɔ tɩ́ɩ́nɩ natúdoozo natɩ́rɩ-dɛ́ɛ wɩlɛnísi lɩ́m ńzɩ ɩkɔná ikéreɖi bɩfʊ́lʊ. ");
INSERT INTO kdh_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ngɛ wɔɔgbɔ́ɔ wɩlɛnísi weegéreɖi sɩ bɩlɛ́ nɛ́ ɩkɔná ɩsɩ́ɩ nabɔ́ɔ́nɩ-daá fʊ́ńdɩ kpɩná wɔ́nnyɔɔ́ lɩ́m ɖɩdáarɛ tɩɩzá-jɔ́ sɩsɩ a tɩɩgɔ́nɩ sɩ tɩnyɔ́ɔ lɩ́m, tɩ́ngbáa ɖamá tɩbɛɛ́na wɩlɛnísi sɩḿ. ");
INSERT INTO kdh_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Fʊ́ńdɩ kpɩná wɔɔgɔ́nɩ tɩ́ngbáa ɖamá tínlosí wɩlɛnísi nɛ́, tɩɩgɔ́nɩ tɩ́nɖʊ́ʊ bíya nɛ́, natɩ́rɩ fʊ́ńdɩ cáa bɩjáa, natɩ́rɩ ɩyɔ́ɔ na natɩ́rɩ kaarásɩ‑kaarásɩ. ");
INSERT INTO kdh_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Amá, fééni wentí Yaakúbu waalɩzɩ́ tɩ fɔɔlʊʊ́ nɛ́, weeyéle tɩbɛɛ́na Labáanɩ-dɛ́ɛ ńdɩ wentí tɩjɔɔ́ɔ kaarásɩ‑kaarásɩ na tibiráa nɛ́. Waalá bɩlɛ́ ɩlɩzɩ́ fééni natɩ́rɩ fɔɔlʊʊ́ ɩsɩ́ɩ ɩdɩ, idoyooziná tɩ Labáanɩ-dɛ́ɛ ńdɩ. ");
INSERT INTO kdh_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Báa sáa wenkí gɛ fééni tɩvɛɛdɛ́ɛ nɛ́ sɩ tɩkpa ɖamá, asée Yaakúbu wɔɔgɔ́gbɔ́ɔ ɩdɛ́ɛ wɩlɛnísi sɩḿ ɩkɔná ɩsɩ́ɩ tɩɖaanyɔɔɖɛ́ lɩ́m tɩɩzá-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","A fééni bɔɔrásɩ sɩ tɩkpa ná ɖamá, ɩ́dɔ́ngɔná wɩlɛnísi sɩḿ ɩsɩ́ɩ tɩ. Ńna nɛ́, ɩmʊ́ ɩdɛ́ɛ ńdɩ gɛ tɩvɛɛdɛ́ɛ nɛ́, bɩka Labáanɩ-dɛ́ɛ ńdɩ gɛ bɔɔrásɩ. ");
INSERT INTO kdh_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ngɛ Yaakúbu waabá ɩbɩ́sɩ ɖɔ́ɔ́lɛ-dʊ́ʊ ɩbá iyuú fʊ́ńdɩ kpɩná kúmuwé na kʊ́bɔná; iyuú yomáa aláa na abaaláa, raakúḿwá na kpangbásɩ. ");
INSERT INTO kdh_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Bɩjɔɔ́ɔ nɛ́, Yaakúbu wooyuú ɩnɩ́ɩ Labáanɩ-dɛ́ɛ bíya wánŋmatɩ́ sɩsɩ: «Ɖájaa-dɛ́ɛ kpɩná rɩ́ŋa gɛ Yaakúbu woogúu ɩsɩ́ɩ ɩdɩ. Kpɩná amʊ́ aabɩsɩná na yɩ ɖɔ́ɔ́lɛ-dʊ́ʊ ɖɔ́.» ");
INSERT INTO kdh_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ngɛ woogúti ɩna sɩsɩ wenbí ɩ́na Labáanɩ bavʊnjɔɔ́ɔ nɛ́ bɩɩgɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ńna gɛ Ɖádʊ́ʊ Ɩsɔ́ɔ waaŋmatɩná yɩ sɩsɩ: «Kpɩɩrɩ nbɩ́sɩ nyɛ́dɛɛvʊ́lɔɔ́ lé baalʊ́rʊ nya nɛ́; mána nya sɩ ɖɩcɔɔ ná.» ");
INSERT INTO kdh_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ngɛ Yaakúbu weedíri bakáyáa Léya na Rasɩ́ɩ́la bɔkɔ́nɩ bɔmɔɔná yɩ fʊ́ńdɩ kpɩná-jɔ́ fɔɔ́-daá. ");
INSERT INTO kdh_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Bɔɔgɔ́nɩ nɛ́ gɛ weevééri wɛ sɩsɩ: «Wenbí mána mɩ́jaa ɖávʊnjɔɔ́ɔ na bɩ nɛ́, mááná sɩsɩ wɛɛgɛ́ɛ. Amá, majaa-dɛ́ɛ Ɩsɔ́ɔ tɛbɛ́ɖɩ ma. ");
INSERT INTO kdh_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Mɩ́dɩtɩŋa mɩ́nyɩ sɩsɩ móɖóni rɩ́ŋa gɛ mɔ́ɔ́gbɔ́ɔ malaná mɩ́jaa bɔwʊtá. ");
INSERT INTO kdh_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ngɛ ɩdɩtɩŋa weeyíli ma hálɩ bʊrɔ fuú wɛ́ngɛɛ́ mɛ́gɩvɛrɛwʊ wɛ́nvɛrɩ́ɩ ma nɛ́. Amá, Ɩsɔ́ɔ tafa yɩ nɩ́bááwʊ sɩ ɩ́la ma bɩdaavé nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","A mɩ́jaa wɔɔdɔ́ ma sɩsɩ a fʊ́ńdɩ kpɩná waaɖʊ bíya gɛ tɩjáa‑tɩjáa, mádɩ́lɩ́ sɩsɩ mɛ́dɛ́ɛ kɩvɛrɛwʊ nbɩlɛ́ sɩ ɩkpɔ́ɔ ɩfɛ́rɛ ma nɛ́; wánŋmatɩ́ bɩlɛ́ nɛ́, fʊ́ńdɩ kpɩná wángʊrʊ́ʊ sɩ tɩɖʊ nɛ́, na tɩɖʊ tɩjáa‑tɩjáa nɛ́ tiriké. A ngʊ́ wɔɔdɔ́ sɩsɩ fʊ́ńdɩ kpɩná sɩ tɩɖʊ bíya wenbá nɛ́, a bíya bɛḿ bɔjɔɔ́ɔ kaarásɩ‑kaarásɩ, mɛ́dɛ́ɛ kɩvɛrɛwʊ nbɩlɛ́ sɩ ɩkpɔ́ɔ ɩfɛ́rɛ ma nɛ́, wánŋmatɩ́ bɩlɛ́ nɛ́, na fʊ́ńdɩ kpɩná ɩtáɖʊ́ʊ bíya kaarásɩ‑kaarásɩ ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ɩsɔ́ɔ wɔɔgbɔɔná mɩ́jaa-dɛ́ɛ fʊ́ńdɩ kpɩná rɩ́ŋa icéle ma. ");
INSERT INTO kdh_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Sáátɩ wenkí namɩ́nɩ wángbáa ɖamá nɛ́, wenbí mánnáa bɩ ɖoozire-daá nɛ́ nɖɔ́: mánnáa sɩsɩ agbɛzɛyɩ́wá wentí tɩ́ngbáa namɩ́nɩ aláa bɩlɛ́ nɛ́, natɩ́rɩ fʊ́ńdɩ cáa bɩjáa, natɩ́rɩ ɩyɔ́ɔ, na natɩ́rɩ kaarásɩ‑kaarásɩ. ");
INSERT INTO kdh_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ɖoozire ɖɩḿ ɖɩdaá gɛ Ɩsɔ́ɔ-dɛ́ɛ malááyɩ́ka wɔɔgɔ́nɩ ɩyáa ma sɩsɩ: “Yaakúbu!” Ngɛ mazɩ: “Mánááɖɔ́.” ");
INSERT INTO kdh_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ngɛ Ɩsɔ́ɔ sɩsɩ: “Kpaazɩ nyáázá ɩsɔ́ɔ́dáá nbɛ́ɛ́ŋ agbankúrú‑kúrúwá wentí tɩrɩ́ŋa tɩ́ngbáa fééni ɖɔ́ nɛ́, natɩ́rɩ fʊ́ńdɩ cáa bɩjáa, natɩ́rɩ ɩyɔ́ɔ, na natɩ́rɩ kaarásɩ‑kaarásɩ. Bɩlɛ́ gɛ sɩ bɩlá; káma, mááná wenbí bɩrɩ́ŋa Labáanɩ wánlám nya nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Mɔ́ɔ́ mánáábɩ́lɛ́ Ɩsɔ́ɔ waaɖʊ ɩlɩ́ɩ nyɔ́rɔ́ Betɛ́ɛlɩ lé nyóózúu bʊ́ʊ́rɛ nbɩ́rɩ ɖʊgʊjʊʊ́-daá núm nɖúu nzɩ́ɩ sɩ nlá ma bɩ nɛ́. Lɛlɛɛɖɔ́, kʊrʊ́ ngbɩ́ɩ́rɩ nlɩ́ɩ tɛ́ɛ́dɩ tɩna nbɩ́sɩ nyɛ́dɛɛvʊ́lɔɔ́ lé baalʊ́rʊ nya nɛ́.”» ");
INSERT INTO kdh_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Yaakúbu waadɩ́ wɛ tɔ́m bɩlɛ́ nɛ́, ngɛ Rasɩ́ɩ́la na Léya boobúsi yɩ sɩsɩ: «Ɖɔ́ɔ́ ɖɔ́wɛná nabʊ́rʊ yáá tííbí nakɩ́rɩ ɖájaa-dɛ́ɛ ɖʊɖɔ? ");
INSERT INTO kdh_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ɩdɔkpɔ́ɔ ɖáa ɩbɩsɩná ɩgɔma bɩka ɩkpɔ́ɔ ɖáa ɩyá iɖi ɖéliideé? ");
INSERT INTO kdh_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ɖɔ́ɔ́lɛ wenɖé ɖɩrɩ́ŋa Ɩsɔ́ɔ wɛɛlɛ́ɛ ɖɛ ɖájaa-jɔ́ nɛ́, ɖɔ́ɔ́ ɖána ɖébíya ɖɛ́dɛ́ɛ ńɖɛ nbɩlɛ́. Bɩlɛ́ nɛ́, la wenbí bɩrɩ́ŋa Ɩsɔ́ɔ wɔɔdɔ́ nya bɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Ngɛ Yaakúbu wɔɔdɔ́ ɩɖɛɛlɩnáa na ibíya bakpa raakúḿwá-rɔɔzɩ́ bakʊrʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Sɩ bɛɖɛ́ɛ nɛ́, ngɛ wɛɛgbɛdɩ́na ɩdɛ́ɛ ɖɔ́ɔ́lɛ ɩvʊngɔwɛná ɖɛ nɛ́; ɩkpɛdɩ́na ɩdɛ́ɛ fʊ́ńdɩ kpɩná weená ɩvʊngɔwɛná yɛ ɖoo Padan-Aráamɩ nɛ́. Baagʊrʊ́ nɛ́, hálɩ Kanáanɩ tɛ́ɛ́dɩ-daá ɩjaa Ɩsaáka-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Labáanɩ wɛ́ńɖɛ́ɛ́ ɩdɛ́ɛ fééni fʊ́m gɛ Rasɩ́ɩ́la waalá ɖɛfɛɛ ɩŋmɩ́ɩ́lɩ ɩjaa ɩmʊ́ ɩdɛ́ɛ lɩzásɩ. ");
INSERT INTO kdh_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yaakúbu sɩ ɩɖɛ́ɛ nɛ́, weeyíli Aráamɩ abaalʊ́ Labáanɩ gɛ; idefééri yɩ sɩ wɛ́nɖɛɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Sɩ ise nɛ́, wɛɛgbɛdɩ́na wenbí bɩrɩ́ŋa ɩwɛná bɩ nɛ́. Waagʊrʊ́ nɛ́, ngɛ woobó ɩɖʊ buwá ɩtɛ́sɩ, ɩkpɔɔná Galáadɩ bʊ́ʊ fáráńdɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Wɛ́ náádoozo wɩ́rɛ gɛ beevééri Labáanɩ sɩsɩ Yaakúbu weeze. ");
INSERT INTO kdh_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ngɛ wɔɔgbɔ́ɔ igoobíya abaaláa banyáa batá ɩwɔ́rɔ́. Baanʊ́ŋ hálɩ wɛ́ lʊbɛ naanɩ́ bobó bɔkɔ́mɔ́ɔ́ná yɩ Galáadɩ bʊ́ʊ-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Amá, nuvoowú-daá gɛ Ɩsɔ́ɔ waaɖʊ ɩlɩ́ɩ Aráamɩ abaalʊ́ Labáanɩ-rɔ ɖoozire-daá ifééri yɩ sɩsɩ: «Bɩ́kacɩ́ nya ndɔ́ Yaakúbu tɔ́m natɩ́rɩ: báa kífeńbi, báa bɩdaavé nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Ngɛ Labáanɩ woobó ɩmɔɔná Yaakúbu. Baadála nɛ́, ɩlɛ́ wóńzúú ɩdɛ́ɛ bɩsaagɛ́rɛ́ŋɛ Galáadɩ bʊ́ʊ-rɔ; ngɛ ɩmʊ́ ɖʊɖɔ na igoobíya boozúu bɛdɛ́ɛ ńga ńna. ");
INSERT INTO kdh_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Ngɛ Labáanɩ wɔɔbɔ́ɔ́zɩ Yaakúbu sɩsɩ: «We gɛ nyáálá bɩlɛ́; ngbetíi-rɔ gɛ nyééyíli ma ngʊrʊ́ ngɔ́gbɔ́ɔ mɛwɛɛlɩnáa ngézéná nyazɩ yowú gɛ nyóóyóo ngágbá wɛ bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Bɩyáásɩ́ gɛ ńdafʊ́ńveeri ma nyɛ́dɛ́ɛ kɛɖɛɛ́ gɛ nyééyíli ma nmʊ́sɩ ngézé. Nyaraavʊ́ńveeri ma ɖɔ́, ayɛnɛ́ɛ na lóózi na kamɩ́nɩ gɛ maraayéle ngɛ́ɖɛ́ɛ́ná. ");
INSERT INTO kdh_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Nyáálá bɩlɛ́ ńdeyéle megbíriki mɛwɛɛlɩnáa na bebíya. Wenbí nyáálá ɖɔ́ nɛ́, ńdábá nlá péḿ. ");
INSERT INTO kdh_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Mɔ́jɔɔ́ɔ ɖɔ́ nɛ́, mɔ́wɛná yíko malá nya bɩdaavé nɛ́. Amá, mɩ́jaa-dɛ́ɛ Ɩsɔ́ɔ weevééri ma keɖee nuvoowú sɩsɩ bɩ́kacɩ́ ma maŋmátɩ nya kífeńdi natɩ́rɩ yáá tɩdaavé nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Tɔ́ɔ, lɛlɛɛɖɔ́ nyáázá waanyɩŋná njaa-dɛ́ɛ ngágʊ́rʊ́ nyéngbém nɛ́, bɩɩlá nŋɩ́nɩ́ gɛ nyáagáŋmɩɩlɩ málɩ́zásɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Ngɛ Yaakúbu woobúsi yɩ sɩsɩ: «Wenbí mɛ́ɛ́nyɛ́ nɛ́ gɛ sɩsɩ mɔ́kɔkɔ́nɩ mevééri nya na nlɛ́ɛ nwɛɛlɩnáa. ");
INSERT INTO kdh_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Amá, nyálɩ́zásɩ nɛ́, sɩ nna sɩ mɛ́dɛ́ɛ ńnɩ́ weení-jɔ́ nɛ́, bʊdʊ́ʊ weezuú fɛ́yɩ́. Yaazɩ ɖágbɩ́ná rɩ́ŋa ɖɛ́dɛ́ɛ ńba ɩzá-daá cé. Wenbí bɩrɩ́ŋa sɩ nna bɩ bɩgɛ́ɛ nyɛ́dɛ́ɛ ńbɩ nɛ́, kpɔɔ.» Yaakúbu tatɩlɩ́ sɩsɩ Rasɩ́ɩ́la waagáŋmɩɩlɩ lɩzásɩ. ");
INSERT INTO kdh_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ngɛ Labáanɩ waazʊ́ʊ Yaakúbu-dɛ́ɛ bɩsaagɛ́rɛ́ŋɛ-dɛ ɩbɛ́ɛ́ŋ, ɩsʊ́ʊ Léya-dɛ́ɛ ɩbɛ́ɛ́ŋ, ɩsʊ́ʊ Léya na Rasɩ́ɩ́la bɛdɛ́ɛ yomáa lɛ́ɛ́nɩ́-dɛ́ɛ ɩbɛ́ɛ́ŋ; na bɩrɩ́ŋa, ɩdana nabʊ́rʊ. Tɔ́ɔ, waagálɩɩ Léya-dɛ́ɛ nɛ́, Rasɩ́ɩ́la-dɛ́ɛ gɛ waazʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rasɩ́ɩ́la waavʊ́ńgbɔwʊ́ lɩzásɩ sɩḿ gɛ ɩkáɖʊ́ raakúḿ kpelé-daá bɩka ɩkpa ɩkɔ́jɔ́ɔ bʊrɔɔzɩ́. Labáanɩ waayáázɩ bɩsaagɛ́rɛ́ŋɛ rɩ́ŋa-daá, ɩdana nabʊ́rʊ. ");
INSERT INTO kdh_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ngɛ Rasɩ́ɩ́la wɔɔdɔ́ ɩjaa sɩsɩ: «Baabá, a mádakʊ́rʊ́ nyáázá-daá, bɩ́kawɩ́ɩ́zɩ nya, aláa kʊdɔḿ wɛná na ma.» Ngɛ Labáanɩ waajáa lɩzásɩ sɩna ɩwɩ́ɩ ɩdana. ");
INSERT INTO kdh_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ngɛ Yaakúbu wɛɛyɛ́ɛ baaná wónÿoonáa Labáanɩ sɩsɩ: «Kidaavééníti wentí gɛ máábá malá nya, taalɩ́ wenkí gɛ máálá nya gɛ nyáábá ngʊrʊ́ nyágadɩ́nɛɛ mɔ́wɔ́rɔ́ ɖóni-ɖóni bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Nyáábá nÿáázɩ mágbɩná rɩ́ŋa nbɛ́ɛ́ŋ nɛ́, we gɛ nyááná bɩgɛ́ɛ nyɛ́dɛ́ɛ ńbɩ. Wɩlɩ ma bɩ mogoobíya na ngoobíya ɩzá-daá cé bɛlɛ́ batára ɖáa tɔ́m. ");
INSERT INTO kdh_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Bɩ́ɩ́zɩ ákoowú nɖɔ́ mɔ́ɔ́jɔ́ɔ nyɔ́jɔ́ nɛ́, kɛtɛngɛrɛ nyévéwu yáá nyánáḿ naárʊ tɔbɔ́lɔsɩ cáńfáná mɔdɔ́ɔ nyɛ́dɛ́ɛ agbaŋ nakɩ́rɩ sɔ́m. ");
INSERT INTO kdh_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ngʊ́ bɩlɛ́ gɛ kɛtɛngɛrɛ mɔ́dɔkɔ́ná nya fʊ́ńdɩ kpɩ́nɖɛ neɖére sɩsɩ fanaḿ naárʊ waagba ná ɖɛ ɖɩsɩ́. Bɩ́nlám bɩlɛ́ nɛ́, mágʊjʊʊ́-daá gɛ bɩ́ndɛ́rɛ́dɛ́m. A baaŋmɩ́ɩ́lɩ ma ɩdaawʊ́, asée nyɔ́ɔ́bɔ́ɔ́zɩ ma mɛvɛ́rɛ, a ngʊ́ nuvoowú gɛ baaŋmɩ́ɩ́lɩ ma, asée mɛvɛ́rɛ nya. ");
INSERT INTO kdh_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ɩdaawʊ́-daá, bɩlɛ́ gɛ wɩ́sɩ wɔ́nwɔ́m ma, nuvoowú, kaanɩŋá wángʊ́ʊ ma; bɩka ɖóm fɛ́yɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ábá, bɩ́ɩ́zɩ ákoowú nbɩlɛ́ mɔ́ɔ́jɔ́ɔ nyáɖaána-daá nɛ́; malá nya nyɛ́dɛ́ɛ aléewá-rɔɔzɩ́ bɔwʊtá bɩ́ɩ́zɩ ákɩzaalʊʊ́ nɛkɛ́rɛ fɛ́yɩ́; mɛbɛ́ɛ́ŋ nyɛ́dɛ́ɛ fʊ́ńdɩ kpɩná-rɔ bɩ́ɩ́zɩ loɖo; mɛ́dɛ́ɛ fɛrɩ́tɩ sɩ nvɛ́rɛ ma nɛ́, ngɛ́ɛ hálɩ bʊrɔ fuú. ");
INSERT INTO kdh_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","A bɩdɛkɛ́ɛ majaájaa Ibrahím-dɛ́ɛ Ɩsɔ́ɔ, Ɩsɔ́ɔ Ɩsaáka wánnɩɩ́ ɩdɛ́ɛ nɩdáárɛ nɛ́, sɩ́ŋɛ́ɛ mɔ́wɔ́rɔ́, nyaraaɖɔ́ɔ ma gɛ mɛɖɛ́ɛ nʊ́ʊ́zɩ yéḿ. Amá, Ɩsɔ́ɔ waana máɖɩwɩɩrɛ na mɛ́dɛ́ɛ konkárɩ́; bʊrɔɔzɩ́ keɖee nuvoowú weeɖéézi toovonúm.» ");
INSERT INTO kdh_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Ngɛ Labáanɩ woobúsi yɩ sɩsɩ: «Bɛɛ́ɛ! Aléewá bana, mádɩɩná wɛ; bebíya, mébíya nbɩlɛ́, fʊ́ńdɩ kpɩná ana arɩ́ŋa, mádɩɩná; wenbí bɩrɩ́ŋa kpátáá nyɛ́bɛɛ́na ɖɔ́ nɛ́, mádɩɩná. Ngɛ bɩjɔɔ́ɔ ɖɔ́ nɛ́, sinje we gɛ sɩ mabɩ́ɩ́zɩ malá mɛwɛɛlɩnáa na bebíya baalʊ́rʊ wɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Bɩlɛ́ nɛ́, yele mána nya ɖiɖi keɖiyá sɩ kalɩzɩ́ mána nya seríya nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ngɛ Yaakúbu wɛɛzɛlɩ́ bʊ́ʊ́rɛ isúu. ");
INSERT INTO kdh_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ngɛ wɔɔdɔ́ igoobíya sɩsɩ bɔ́kɔdɔɔzɩ bɔ́; ngɛ bɔɔdɔ́ɔ́zɩ bɔ́ basɩ́ɩ fuúre, barɩ́ŋa bakpa bɔcɔ́ɔ arɔ beɖi kíɖíím. ");
INSERT INTO kdh_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Ngɛ Labáanɩ waava ɖɩdáarɛ ɖɩḿ yɩ́ɖɛ sɩsɩ Yegáarɩ-Sahadúta, bɩka Yaakúbu ɩlɛ́ ɩfa ɖɛ yɩ́ɖɛ ɖʊɖɔ sɩsɩ Galɛ́ɛdɩ. ");
INSERT INTO kdh_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Ńnaamʊ́ gɛ Labáanɩ wɔɔdɔ́ sɩsɩ: «Bɔ́ ana ɖáágáa yɛ sinje ɖɔ́ nɛ́, ánlɩzɩ́ɩ kʊ seríya mána nya ɖɔ́lɔ́wʊ́táá.» Bʊrɔɔzɩ́ gɛ baava yɛ yɩ́ɖɛ sɩsɩ Galɛ́ɛdɩ. ");
INSERT INTO kdh_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ngɛ baadáyáa yɛ sɩsɩ Mísipa; káma, Labáanɩ wɔɔdɔ́ gɛ sɩsɩ: «A mána nya ɖódokúti ɖɩna ɖamá, Ɖádʊ́ʊ Ɩsɔ́ɔ ífere ɖɔ́rɔ́ɔ́zɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","A nyáánáázɩ mɛ́wɛɛlɩnáa yáá ngúti ngbɔ́ɔ aláa ndasɩná wɛ, tɩlɩ́ sɩsɩ bɩdɛkɛ́ɛ ɩrʊ́ gɛ ɖɛ́dɛ́ɛ seríya-dʊ́ʊ; amá, Ɩsɔ́ɔ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Ngɛ Labáanɩ wɔɔdɔ́ Yaakúbu sɩsɩ: «Bɛɛ bɔ́ ɖáagáa yɛ nɛ́ nɖɔ́; bʊ́ʊ́rɛ móózúu ɖɛ nɛ́ nɖɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Aabɩ́sɩ ɖɛ́dɛ́ɛ seríya-dɩnáa, mɛ́dɛ́nvɛlɩ́ yɛ mɔɖɔ́kɩ nyánɩ́bááwʊ, nyɔ́ɔ́ ɖʊɖɔ ńdɛ́vɛlɩ́ yɛ nɖɔ́kɩ mánɩ́bááwʊ nlá ma bɩdaavé nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ibrahím na Nahɔ́ɔrɩ, bajaa-dɛ́ɛ Ɩsɔ́ɔ, ɩ́sɩŋ seríya mána nya ɖɔ́lɔ́wʊ́táá.» Ngɛ Yaakúbu waamʊná Ɩsɔ́ɔ ɩjaa Ɩsaáka wánnɩɩ́ ɩdɛ́ɛ nɩdáárɛ nɛ́; ");
INSERT INTO kdh_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","ɩcáŋ ɩlá sarɔ́ɔ bʊ́ʊ-daá ńna; ɩyáa igoobíya jíńgáárɩ́; beeɖi bɩtɛ́ nɛ́, bʊ́ʊ-daá ńnaamʊ́ gɛ baawalɩ́ boɖóo. ");
INSERT INTO kdh_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Kiivé tɛ́ɛrɛ́ nɛ́, ngɛ Labáanɩ wɔɔjɔ́ɔ́rɩ ibó ikpíriki ɩwɛɛlɩnáa na bebíya; ngɛ waaɖʊ wɛ alɩbáráka. Bɩɩdɛ́ nɛ́, ngɛ waabɩ́sɩ ikpé ɩdɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yaakúbu waagʊrʊ́ wéngbém nɛ́, ɩbamáa ɖɛɛ́ gɛ Ɩsɔ́ɔ-dɛ́ɛ malááyɩ́kawá wɛɛgɛ́tɩ yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Sáátɩ wenkí waajáŋ ɩna wɛ ɖɔ́ nɛ́, ngɛ sɩsɩ: «Cé gɛ Ɩsɔ́ɔ na ɩdɛ́ɛ ńba baɖaaduuziɖé.» Ngɛ waava ɖɩdáarɛ ɖɩḿ yɩ́ɖɛ sɩsɩ Mahanayíim. ");
INSERT INTO kdh_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ngɛ waagʊ́sɩ ɩdɛ́ɛ tɩndɩnáa itíri ɩɖawaalʊ Ísááwʊ-jɔ́ Seyíiri tɛ́ɛ́dɩ tɩgɔwɛ Edɔ́m nɛ́ tɩdaá. ");
INSERT INTO kdh_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Bɛlɛ́ sɩ bɛɖɛ́ɛ nɛ́, ngɛ wɔɔdɔ́ wɛ sɩsɩ: «Wentí sɩ ikéveeri mágʊ́bɔnɩ́ Ísááwʊ nɛ́ nɖɔ́: Ivééri yɩ sɩsɩ mɔ́ɔ́ ɩdɛ́ɛ yoḿ Yaakúbu mánŋmatɩ kʊ yɩ sɩsɩ ɖoo bɩrɩ́ŋa, Labáanɩ-dɛ́ɛ gɛ mɔ́ɔ́jɔ́ɔ; ngɛ ɩjɔ́ gɛ mááwálɩ́ mɔjɔ́ɔ hálɩ na sinje. ");
INSERT INTO kdh_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Mɔ́wɛná náánɩ, kpangbásɩ, fééni, yomáa aláa na abaaláa. Bɩlɛ́ bʊrɔɔzɩ́ gɛ méédíri sɩ béfeeri mádʊ́ʊ sɩsɩ: “Máávɩ́nɩ nya, cɛ ma.”» ");
INSERT INTO kdh_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Tɩndɩnáa woobó bakábɩsɩ nɛ́, ngɛ bɔɔgɔ́nɩ befééri yɩ sɩsɩ: «Ɖóóbó ɖɩna nɖawaalʊ Ísááwʊ nɛ́, waagágʊ́rʊ́ ɩgɛrɛŋɛ sɩ ɩkɔ́nɩ ɩsɩ́ŋ nya, ɩ́gana ɩráa kákpɩ́ɩ́zɩ nasɩ́lɛ (400).» ");
INSERT INTO kdh_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Baaŋmátɩ bɩlɛ́ Yaakúbu ɩnɩ́ɩ nɛ́, ɩdaá lɩ́m wɛɛjɛ́; ɩdɔnʊʊ́ ɩyɔ́ɔ́lɩ. Ngɛ waadára ɩdɛ́ɛ zamɔ́ɔ nabʊ́lɛ, bɩkpɛdɩ́na fééni, nemísi, náánɩ, na raakúḿwá ");
INSERT INTO kdh_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","sɩsɩ: «A bɩgɛ́ɛ Ísááwʊ wɔɔgɔ́nɩ ɩkɛtɩná fɔɔlʊʊ́ kʊ́ɖʊmʊ́ʊ gɛ sɩ iyóo kɩ, fɔɔlʊʊ́ kɩɩganáa wánbɩɩzɩ́ kise.» ");
INSERT INTO kdh_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ngɛ sɩsɩ: «Óo, majaájaa Ibrahím na majaa Ɩsaáka bɛdɛ́ɛ Ɩsɔ́ɔ, Mádʊ́ʊ Ɩsɔ́ɔ, nyéévééri ma sɩsɩ mábɩsɩ mɛ́dɛɛvʊ́lɔɔ́ lé baalʊ́rʊ ma nɛ́, nyazɩ nyánlám ma kazɔ́ɔ ńbɩ. ");
INSERT INTO kdh_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Mádʊ́ʊ, mádatála nlá isóórómíti nvu mɔ́ɔ́ nyóyóḿ na wenbiré kʊ́ɖʊńɖɛ ɖɔ́; ɖooriká gɛ mɔ́ɔ́ɖɔ́kɩ mɛdɛ́sɩ Yɔrɔdáanɩ buwá kana; amá, sinje máagábɩ́sɩ na zamɔ́ɔ fɔɔlɩ́nɩ natɩ́lɛ. ");
INSERT INTO kdh_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","La suúru nlɩzɩ́ ma maɖawaalʊ Ísááwʊ ndɛ́; mɛ́nnyɛ́m sɩsɩ ɩ́kɔkɔ́nɩ ɩkʊ mɛɖɛɛlɩnáa na mébíya. ");
INSERT INTO kdh_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Aa tɔ́ɔ, nyɔ́ɔ́dɔ́ ma gɛ sɩsɩ nyánlám ma kazɔ́ɔ ńbɩ nɖʊ mébíya-bíya alɩbáráka bɔɖɔ́ɔ bádánbɩɩzɩ bakála wɛ nyazɩ tenkú nɔɔ́-jɔ́ kanyɩ́ŋa bɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Ńna gɛ Yaakúbu waawalɩ́ ɩfɩ́nɩ iɖóo. Ngɛ wɛɛbɛ́ɛ́ŋ ɩdɛ́ɛ fʊ́ńdɩ kpɩná awɛ ɩjɔ́ nɛ́ adaá ɩlɩzɩ́ kʊjɔ́ɔ́nɩ natɩ́rɩ ɩsɩ́ɩ ɩɖawaalʊ Ísááwʊ. ");
INSERT INTO kdh_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Waalɩzɩ́ namɩ́nɩ kákpáŋa (200), agbɛzɛyɩ́wá ákoowú (20), fééni aláa kákpáŋa (200), agbankúrú‑kúrúwá ákoowú, (20) ");
INSERT INTO kdh_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Raakúḿwá aláa ákoosaaláa (30) tɩ́na tibíya tɩbamáa mʊzʊ́ʊ nɛ́, náánɩ aláa nɛɛ́lɛ (40) na tɩdɛ́ɛ abaaláa fuú (10), kpangbásɩ aláa ákoowú (20), na sɩdɛ́ɛ abaaláa fuú (10). ");
INSERT INTO kdh_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ngɛ waadára fʊ́ńdɩ kpɩná amʊ́ fuwé-fuwé icéle ɩdɛ́ɛ tɩmɛlanɖáa, báa weení, fuúre kʊ́ɖʊńɖɛ, ɩtɔ́ wɛ sɩsɩ bɛ́tɛ́ ɩmʊ́ nɩ́bááwʊ, bɩka beyéle fuúre báa wenɖé ɩlaná ɖɩrɔwʊ́ bolíni cʊ́kɔ-cʊ́kɔ. ");
INSERT INTO kdh_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ngɛ wɔɔdɔ́ badaá weení ɩdɛ́ɛ nɩ́bááwʊ nɛ́ sɩsɩ: «A bɩgɛ́ɛ maɖawaalʊ Ísááwʊ wɛɛgɛ́tɩ nya gɛ wɔɔbɔ́ɔ́zɩ nya sɩsɩ awéní-dɛ́ɛ ńnɩ́ gɛ nyɔ́ɔ́, lé gɛ nyɛ́nɖɛɛ́, ngɛ awéní tɩɩná fʊ́ńdɩ kpɩná adɛ́ɛ nya nɩ́bááwʊ ɖɔ́ nɛ́, ");
INSERT INTO kdh_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","busi yɩ sɩsɩ ɩdɛ́ɛ yoḿ Yaakúbu tɩɩná nya; ɩdɩɩná fʊ́ńdɩ kpɩná ɖʊɖɔ; kʊjɔɔwʊ gɛ waagála ɩgʊ́bɔnɩ́ Ísááwʊ; ɩdɩtɩŋa ɩgɔwɛ bʊwɔ́rɔ́ ɩgɛgɛrɛŋɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Tɔ́m kʊ́ɖʊńtɩ tɩḿ nɔ́ɔ́ gɛ wɔɔdɔ́ sɩɩlɛ ńnɩ́, ɩtɔ́ toozo ńnɩ́, na wenbá barɩ́ŋa bɛ́nɖɛɛnáa fʊ́ńdɩ kpɩná amʊ́ nɛ́, sɩsɩ a bɩgɛ́ɛ baana ɩgʊ́bɔnɩ́ Ísááwʊ, bɩlɛ́ gɛ sɩ báŋmatɩ yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Na batásɩ befééri yɩ sɩsɩ ɩdɛ́ɛ yoḿ ɩmʊ́ ɩdɩtɩŋa ɩgɔwɛ bɔwɔ́rɔ́ ɩgɛgɛrɛŋɛ, sɩsɩ kʊjɔɔwʊ kɩdɛ́ɛ ɩmʊ́ nɩ́bááwʊ ɖɔ́ nɛ́ gɛ ɩmʊ́ sɩ ɩfɛɛzɩná ɩgʊ́bɔnɩ́ Ísááwʊ wenbiré, na ɩmʊ́ ɩ́na yɩ bɔkɔ́nɩ bana ɖamá. Nabʊ́rʊ, ɩmʊ́ ɩ́na yɩ bɛdɛ́ɛ ɖamá náa-daá, wánmʊ́ʊ ɩmʊ́ kazɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ngɛ wɛɛdɛ́ɛ́zɩ kʊjɔ́ɔ́nɩ rɩ́ŋa nɩ́bááwʊ tɩɖɛ́ɛ, bɩka ɩmʊ́ ɩwalɩ́ ɖɩdáarɛ lé boozúu nɛ́ iɖóo. ");
INSERT INTO kdh_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Nuvoowú kɩḿ kɩdaá gɛ waagʊrʊ́ ɩkpɔ́ɔ ɩdɛ́ɛ aláa lɛ́ɛ́nɩ́ na bɛdɛ́ɛ yomáa lɛ́ɛ́nɩ́, na ɩdɛ́ɛ bíya fuú na naárʊ iboná wɛ bɛtɛ́sɩ buwá bánÿaá kɛ sɩsɩ Yabɔ́ɔkɩ nɛ́ kɛdɛ́ɛ lɩ́m tɔɖɔ́ɔ ɖɩdáarɛ; ");
INSERT INTO kdh_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","ɩtɛsɩná ɖʊɖɔ wenbí bɩrɩ́ŋa ɩwɛná bɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ngɛ ɩmʊ́ waawalɩ́ iriké. Ngɛ nuvoowú kɩḿ kɩdaá, ɩrʊ́ naárʊ wɔɔgɔ́nɩ ɩ́na yɩ balʊ́ hálɩ asʊbáa. ");
INSERT INTO kdh_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Bɩdɛ́ɛ ɩrʊ́ waana sɩsɩ ɩ́dánbɩɩzɩ ɩká Yaakúbu nɛ́, ngɛ waamá ɩdɩnɔɔ́-rɔ tɩnɔɔ́ ɩcáŋ kabʊʊ́dɩ. ");
INSERT INTO kdh_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ngɛ bɩdɛ́ɛ ɩrʊ́ wɔɔdɔ́ yɩ sɩsɩ: «Bɛɛ́ɛ! Tɛ́ɛ́wʊ wénvém kʊ bɩlɛ́, yele ma mɛɖɛ́ɛ.» Ngɛ Yaakúbu woobúsi yɩ sɩsɩ: «A ńdáɖʊ́ ma alɩbáráka, mɛ́vɛ́yɩ́ ménÿelíi nya nɖɛ́ɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ngɛ ɩlɛ́ wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Bánÿaá nya sɩsɩ wé.» Ngɛ ɩmʊ́ sɩsɩ: «Yaakúbu». ");
INSERT INTO kdh_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ngɛ sɩsɩ: «Tɔ́ɔ, bádándayaa nya ɩsɩ Yaakúbu; amá, sɩ bayáa nya gɛ sɩsɩ Israyɛ́ɛlɩ, káma, nyána Ɩsɔ́ɔ na ɩráa mɩ́ɩ́lʊ́, ngɛ nyééɖí.» ");
INSERT INTO kdh_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ńna gɛ Yaakúbu wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «La suúru nvééri ma nyáyɩ́ɖɛ.» Ngɛ ɩmʊ́ sɩsɩ: «Ngbetíi-rɔ gɛ nyɔ́nbɔɔzɩ́ máyɩ́ɖɛ.» Ngɛ waaɖʊ yɩ alɩbáráka ńna. ");
INSERT INTO kdh_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ńnaamʊ́ gɛ Yaakúbu waava ɖɩdáarɛ ɖɩḿ yɩ́ɖɛ sɩsɩ Peniyɛ́ɛlɩ, wenbí nɛ́, wɔɔdɔ́ gɛ sɩsɩ: «Mááná Ɩsɔ́ɔ ɩzá na ɩzá, bɩka méweezuú talɩ́ɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Wɩ́sɩ sɩ sɩlɩ́ɩ nɛ́, wɛ́ńgɛvɛlɩ́ Peniyɛ́ɛlɩ, bɩka wánganʊŋ́ tɩnɔɔ́-rɔ. ");
INSERT INTO kdh_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Bɩlɛ́ bʊrɔɔzɩ́ gɛ hálɩ na sinje Israyɛ́ɛlɩ bíya tɔ́ndɔtɔwʊ́ tɩnɔɔ́ fóle sɔ́m. Káma, Yaakúbu-dɛ́ɛ tɩnɔɔ́ fóle ɖɩḿ ɖɩɖɩdáarɛ gɛ Ɩsɔ́ɔ waamá. ");
INSERT INTO kdh_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yaakúbu waagʊ́sɩ waazá ɩkɛ́bɛ́ɛŋ ɖɔ́ nɛ́, ngɛ waagáná Ísááwʊ kɛrɛŋɛ ɩ́gana ɩráa kákpɩ́ɩ́zɩ nasɩ́lɛ (400). Ngɛ waadára bíya icéle Léya na Rasɩ́ɩ́la na yomáa lɛ́ɛ́nɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ngɛ wɔɔdɔ́ yomáa bɛḿ bána bebíya bɛtɛ nɩ́bááwʊ; bɛlɛ́ bɔwɔ́rɔ́ nɛ́, ngɛ Léya na ibíya baadɩ́nɩ; ngɛ Rasɩ́ɩ́la na Ísifu bɛlɛ́ bɛɛdɛ́ɛ́zɩ fúu bɔwɔ́rɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ɩmʊ́ ɩdɩtɩŋa wɛɛdɛ ná wɛ nɩ́bááwʊ. Naanɩ́ ɩtála ɩɖawaalʊ ɩzá-daá nɛ́, bʊrɔ lʊbɛ gɛ woozóm adɛ. ");
INSERT INTO kdh_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ngɛ Ísááwʊ weeze ɩkázɩŋ yɩ; ɩnyáa ikpíriki yɩ. Ngɛ baabáázɩ wíídi. ");
INSERT INTO kdh_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ísááwʊ wɔɔgɔ́nɩ ɩkʊ́sɩ ɩgʊjʊʊ́ ɩbɛ́ɛ́ŋ nɛ́, waana aláa na bíya; ngɛ sɩsɩ: «Wenbá gɛ ɩráa bana baagálaazɩ nya ɖɔ́ nɛ́.» Ngɛ Yaakúbu woobúsi yɩ sɩsɩ: «Bíya Ɩsɔ́ɔ waava ma wɛ nɛ́ nbɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ńna gɛ yomáa aláa na bebíya bɛlɛ́ boogóduu baká baɖʊná-rɔ. ");
INSERT INTO kdh_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Ngɛ Léya na ibíya ɖʊɖɔ boogóduu baká baɖʊná-rɔ. Ngɛ Ísifu na Rasɩ́ɩ́la bɔɔmɔ́ɔ bokóduu baká baɖʊná-rɔ ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ńnaamʊ́ gɛ Ísááwʊ sɩsɩ: «Fʊ́ńdɩ kpɩná rɩ́ŋa mɛ́ɛ́gɛ́gɛ́tɩ yɛ ɖɔ́ nɛ́, we gɛ nyáázɩ́ɩ sɩ nlaná.» Ngɛ Yaakúbu woobúsi yɩ sɩsɩ: «Aayɩ́, sɩ mavɩnɩná nya gɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ngɛ Ísááwʊ sɩsɩ: «Ménewú, bɩbá bʊwɛ mɔ́jɔ́, bɩlɛ́ nɛ́, ɖɔkɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ngɛ Yaakúbu sɩsɩ: «Aayɩ́, la suúru, a ɖé nyɛ́ɛ́jɛ́ ma, tisi nmʊ mágʊjɔɔwʊ mɛ́ńdɛ́; káma, mɛ́dɛ́ɛ nya náa cɔɔ́ɔ ma gɛ nyazɩ Ɩsɔ́ɔ gɛ mááná; ngɛ toovonúm, nyáámʊ́ ma nʊ́ʊ́zɩ nasɩ́lɛ. ");
INSERT INTO kdh_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ɩsɔ́ɔ waaɖʊ ma alɩbáráka, nabʊ́rʊ fɛ́yɩ́ ma takáásɩ́; bɩlɛ́ nɛ́, la suúru ndísi nmʊ mágʊjɔɔwʊ máálá nya kɩ nɛ́.» Bɩlɛ́ gɛ waalaaná Ísááwʊ caarɩ́ hálɩ ɩlɛ́ ɩtɛ́ ɩmʊ. ");
INSERT INTO kdh_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ngɛ ɩlɛ́ sɩsɩ: «Ɖʊ́kʊ́rʊ́ ɖɩɖɛ́ɛ maláázɩ nya.» ");
INSERT INTO kdh_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ngɛ Yaakúbu sɩsɩ: «Mágʊ́bɔnɩ́, nyányɩ sɩsɩ bíya ɩbá bɛvɛ́yɩ́ fɩ́ya ɖɔ́, ngʊ́ ɖʊɖɔ mɔ́wɛná fééni na náánɩ ásɔ́ɔ́nɩ́náa. A ɖéégbí tɩ ɖóni tɩnʊ́ŋ wɩ́rɛ kʊ́ɖʊńɖɛ, fʊ́ńdɩ kpɩná rɩ́ŋa wánzɩ́m. ");
INSERT INTO kdh_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Bɩlɛ́ nɛ́, mágʊ́bɔnɩ́, tɛ nɩ́bááwʊ ndóróbó, mɔ́ɔ́ mónvúu mávʊ́ńdɩ kpɩná na bíya-dɛ́ɛ nʊŋɛ́ mɔgɔ́mɔ́ɔ́ná mɩ́ɩ Seyíiri.» ");
INSERT INTO kdh_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ngɛ Ísááwʊ sɩsɩ: «A bɩlɛ́, ménÿelenáa nya mááráa nɛbɛ́rɛ.» Ngɛ Yaakúbu woobúsi yɩ sɩsɩ: «Na bɩlá wé; a nyáábá nmʊ ma kazɔ́ɔ, bɩɩɖɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ngɛ Ísááwʊ waajáŋ isúu ɩbɩ́sɩ Seyíiri wɩ́rɛ ɖɩḿ. ");
INSERT INTO kdh_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yaakúbu ɩlɛ́ waagʊrʊ́ ɩɖɛ́ɛ Sukɔ́ɔtɩ. Ngɛ woobó ɩma ɩdɩ ɖɔɔ́, ɩma fʊ́ńdɩ kpɩná kɛ́rɛ́ɛ́zɩ. Bʊrɔɔzɩ́ gɛ bánÿaá ɖɩdáarɛ ɖɩḿ sɩsɩ Sukɔ́ɔtɩ, bugutoluú sɩsɩ kɛ́rɛ́ɛ́zɩ. ");
INSERT INTO kdh_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Bɩjɔɔ́ɔ nɛ́, Yaakúbu waagálɩɩ Padan-Aráamɩ ɩtala ná alaafɩ́ya Sɩkɛ́ɛm, Kanáanɩ laadɔ́ɔ-daá. Waadála nɛ́, tɛ́ɛ́dɩ-jɔ́ ńna gɛ woozúu. ");
INSERT INTO kdh_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Laadɔ́ɔ wenká-rɔ woozúu nɛ́, Amɔ́ɔrɩ-dɛ́ɛ bú Sɩkɛ́ɛm-dɛ́ɛ bíya-jɔ́ gɛ waamʊ kɛ ɩfɛ́rɛ liidásɩ nɩɩ́nʊ́wá. ");
INSERT INTO kdh_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ngɛ Yaakúbu waama Ɩsɔ́ɔ sarásɩ ɖaalanɖɛ́ ńnaamʊ́ ɩfa yɩ́ɖɛ sɩsɩ: Ɛ́ɛlɩ-Elohée-Israyɛ́ɛlɩ. ");
INSERT INTO kdh_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Wɩ́rɛ gɛ Yaakúbu wɛɛlɛ́ɛ Dína waalɩ́ɩ sɩsɩ wónboɖé ɩkáná tɛ́ɛ́dɩ-daá aléewá. Dína ɩmʊ́ nɛ́, Léya waalʊrʊná Yaakúbu bú weení nɛ́ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Wɛ́nɖɛɛ́ nɛ́, fáráńdɩ́ kɩḿ kɩdɛ́ɛ wúro Hivíi ńnɩ́ Amɔ́ɔrɩ biyaalʊ́ Sɩkɛ́ɛm waana yɩ. Ngɛ ɩlɛ́ weegbí yɩ ɩɖɛɛná ikóɖóóná ɩfɔrɔ́sɩ yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ngɛ Yaakúbu wɛɛlɛ́ɛ Dína waazʊ́ʊ afobú kezeŋa. Ngɛ waadɩ́ tɔ́m tɩ́nbɩɩzɩ́ tɩyɔ́ iwenbiré nɛ́ ifééri yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ngɛ wɔɔdɔ́ ɩjaa Amɔ́ɔrɩ sɩsɩ: «Bo ngázʊlʊ ma aléeré ceení, mɔ́zɔɔlɛ́ɛ yɩ sɩ mɔgbɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yaakúbu ɩlɛ́ waanɩ́ɩ sɩsɩ bɩlɛ́ gɛ afobú ɩmʊ́ wɔɔvɔrɔ́sɩ ɩmʊ́ ɩwɛɛlɛ́ɛ Dína. Ibiyaalɩnáa wɛ́ńɖɛ́ɛ́ná ɩvʊ́ńdɩ kpɩná fásɩ-daá nɛ́, woozu ɖɛfɛɛ ɩdaŋmátɩ, hálɩ bɛlɛ́ bakábɩsɩ. ");
INSERT INTO kdh_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Ngɛ Sɩkɛ́ɛm ɩjaa Amɔ́ɔrɩ waagʊrʊ́ ibó Yaakúbu-jɔ́ sɩ ɩkáŋmátɩ́na yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Yaakúbu biyaalɩnáa waagálɩɩ fɔɔ́ batála gɛ baanɩ́ɩ wenbí bɩɩlá bɩ nɛ́, ngɛ sɩsɩ bɩna bɩbá bɩgɛ́ɛ bɛḿ Israyɛ́ɛlɩ bíya kʊdʊ́ʊ́wʊ gɛ. Ńna gɛ baabá bɛyɛ́ɛ baaná. Wenbí wɔɔvɔrɔ́sɩ bɛḿ benewú nɛ́, bɩdabá bɩmɔɔná bɩlɛ́. Bɩdɔbɔ́ɔ́zɩ balá Israyɛ́ɛlɩ bíya bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Amɔ́ɔrɩ woobó nɛ́, ngɛ ɩlɛ́ wɔɔgbɔ́ɔ tɔ́m ɩŋmátɩ wɛ sɩsɩ: «Mebiyaalʊ́ Sɩkɛ́ɛm wenbiré waabá bɩsʊ́ʊ mɩ́dɛ́ɛ bú aléeré ceení, ɩlá suúru ɩfa ma yɩ mejéle mebiyaalʊ́ ɩmʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ɖána mɩ́ɩ ɖíɖí keɖiyá, ɖɔ́ngbɔwʊ́ʊ mɩ́dɛ́ɛ aléewá bɩka mɩ́nyɔ́ɔ́ ɖʊɖɔ mɩ́ngbɔwʊ́ʊ ɖɛ́dɛ́ɛ ńba. ");
INSERT INTO kdh_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ɩjɔ́ɔ ɖána mɩ́ɩ, mɩ́jɔwʊ́ʊ gɛ tɛ́ɛ́dɩ tɩna tɩjɔɔ́ɔ; mɩ́nbɩɩzɩ́ ɩlá fótóósi bɩka iyuú laadásɩ ɖʊɖɔ ɩsɩ́ɩ mɩ́dɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","12","Ngɛ Sɩkɛ́ɛm woovulú ɩnɔɔ́ ifééri Dína ɖawaalɩnáa na ɩjaa sɩsɩ: «Máávɩ́nɩ mɩ́ɩ sɩsɩ báa mɩɩdɩ́rɛ-dɛ́ɛ kɩmɛ́rɛ gɛ ɖiigíi nŋɩ́nɩ́, bɩ́na kʊjɔ́ɔ́nɩ, ɩbɛlɩ́ ma, mɛ́nvɛrɩ́ɩ; na wenbí bɩrɩ́ŋa sɩ ɩtɔ́ ma sɩsɩ mɛ́vɛrɛ nɛ́, bɩrɩ́ŋa mɛ́nvɛrɩ́ɩ, bɩka ɩbá itísi ɩfa ma Dína mɔgbɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Sɩkɛ́ɛm wɔɔvɔrɔ́sɩ Dína nɛ́ bʊrɔɔzɩ́, bɛlɛ́ baagʊrʊ́ sɩ bobúsi ɩ́na ɩjaa Amɔ́ɔrɩ nɛ́, boodúúli wɛ gɛ ");
INSERT INTO kdh_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","bobúsi wɛ sɩsɩ: «Kéyi, ɖɔ́ɔ́ ɖɛ́vɛ́yɩ́ ɖɔ́ngbɔwʊ́ʊ ɖénéwú ɖɩfa jɔfɔ́lɔ-dʊ́ʊ. A ɖáálá bɩlɛ́, bɩgɛ́ɛ ɖáa kʊdʊ́ʊ́wʊ gɛ. ");
INSERT INTO kdh_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","A mɩ́zɔɔlɛ́ɛ ɖɩlá mɩ́ɩ wenbí mɩ́ɩ́bɔ́ɔ́zɩ ɖáa nɛ́, asée bɛbɛlɩ́ wenbá barɩ́ŋa bɛgɛ́ɛ abaaláa nɛ́ babɩ́sɩ ńŋɩnáa ɖɔ́ɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","A mɩ́ɩ́lá bɩlɛ́, mɩ́nbɩɩzɩ́ mɩ́ngbɔwʊ́ʊ ɖɛ́dɛ́ɛ aléewá, bɩka ɖɔ́ɔ́ ɖʊɖɔ ɖɔ́ngbɔwʊ́ʊ mɩ́ɩ mɩ́dɛ́ɛ ńba; ɖárɩ́ŋa ɖiyóózi ɖɩcɔ́ɔ ɖɩbɩ́sɩ ɩrʊ́ kʊ́ɖʊḿ. ");
INSERT INTO kdh_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Amá, a míígízi mɩ́danɩ́ɩ tɔ́m ɖááŋmátɩ mɩ́ɩ ɖɔ́ nɛ́, ɖɔ́ɔ́ ɖɔ́ngbɔwʊ́ʊ ɖɛ́dɛ́ɛ aléeré ɖɩɖɛ́ɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ngɛ Amɔ́ɔrɩ na ibiyaalʊ́ beedísi tɔ́m tɩḿ. ");
INSERT INTO kdh_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Sɩkɛ́ɛm wɛɛgbɛdɩ́ na ɩkʊrʊ́ ɩsɩ́ŋ wenbí bɔɔdɔ́ wɛ nɛ́ bʊrɔɔzɩ́; káma, ɩzɔɔlɛ́ɛ aléeré nɛ́ ní. Na nbɛ́ɛ nɛ́, ɩmʊ́ gɛ baabá bánɖʊ́ʊ gírímá ɩjaa-dɛ́ɛ ɖaána-daá. ");
INSERT INTO kdh_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ngɛ Amɔ́ɔrɩ na ibiyaalʊ́ baagʊrʊ́ bobó tɛ́ɛ́dɩ wɔnɔɔ́-daá, befééri ɩráa sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«Ɩráa bana bɔwɛ ɖɔ́lɔ́wʊ́táá ɖɔ́ nɛ́, bɛgɛ́ɛ ɩráa ɖɔyɔɔyɔɔ ńba gɛ. Bɩlɛ́ nɛ́, bɔ́cɔɔ ɖɛ́dɛ́ɛ́dɩ-daá cé bɩka bánlám bɛdɛ́ɛ fótóósi. Tɛ́ɛ́dɩ waawála, bɩ́ndalɩ́ɩ wɛ. Ɖónÿuú ɖʊkpɔ́ɔ bɛdɛ́ɛ aléewá bɩka bɛḿ ɖʊɖɔ bɔkpɔ́ɔ ɖɛ́dɛ́ɛ ńba. ");
INSERT INTO kdh_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Amá, na ɩráa bɛḿ betísi bɔcɔ́ɔ ɖɔ́lɔ́wʊ́táá cé ɖána wɛ ɖɩlá kʊ́ɖʊḿ nɛ́, asée bɛ́ńbɛ́lɩ́ ɖáa ńŋɩnáa bɛɛbɛlɩ́ wɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Náńta bɛdɛ́ɛ fʊ́ńdɩ kpɩná kúmuwé na kʊ́bɔná na bɛdɛ́ɛ ɖɔ́ɔ́lɛ rɩ́ŋa wánbɩsɩ́ ɖɛ́dɛ́ɛ ńbɩ nɛ́. Ɖɩ́kpɛ́dɩ́ gɛ ɖufu ɖɩlá wenbí bɔɔbɔ́ɔ́zɩ ɖáa nɛ́; bɩka ɖána wɛ ɖiyóózi ɖɩcɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Bɔwɛ bánŋmatɩ́ bɩlɛ́ nɛ́, tɛ́ɛ́dɩ-daá ńba wenbá barɩ́ŋa baadála abaaláa nɛ́ beedísi tɔ́m tɩḿ. Ngɛ baajáŋ bɛbɛlɩ́ wenbá barɩ́ŋa kpátáá bɔɔgɔ́nɩ bɔwɛ ńna nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Wɛ́ náádoozo wɩ́rɛ abaaláa bɛɛbɛlɩ́ wɛ nɛ́ lewáa bɛ́nÿɛlɛ́ŋ nɛ́, ngɛ Dína ɖawaalɩnáa Simeyɔ́ɔnɩ na Léévi baagʊrʊ́ bɛsɛlɩ́ bɛdɛ́ɛ tókobíwá basʊ́ʊ tɛ́ɛ́dɩ-daá botudú wɛ bakʊ barɩ́ŋa. ");
INSERT INTO kdh_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ngɛ baagʊ Amɔ́ɔrɩ na ibiyaalʊ́ Sɩkɛ́ɛm. Ngɛ bɔɔgɔ́gbɔ́ɔ benewú Dína Sɩkɛ́ɛm-dɛ́ɛ ɖaána-daá bekégbéná. ");
INSERT INTO kdh_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ńnaamʊ́ gɛ Yaakúbu-dɛ́ɛ bíya rɩ́ŋa waazʊ́ʊ ɩsɩɖáa-rɔɔzɩ́ balɩzɩ́ bɔwɛná bɩ nɛ́; basʊ́ʊ tɛ́ɛ́dɩ rɩ́ŋa-daá bokóti ɩráa kpɩná; káma, bɔɔvɔrɔ́sɩ benewú. ");
INSERT INTO kdh_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ngɛ bɔɔgbɔ́ɔ bɛlɛ́ bɛdɛ́ɛ fʊ́ńdɩ kpɩná kúmuwé na kʊ́bɔná, kpangbásɩ, wenbí bɩrɩ́ŋa badanbá bɔwɛná tɛ́ɛ́dɩ-daá na fásɩ-daá nɛ́, bɔɔgbɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ngɛ baaŋmɩ́ɩ́lɩ bagbɩná rɩ́ŋa cɩ́rɩ́, bɩkpɛdɩ́na bebíya na bɛdɛ́ɛ aláa, na wenbí bɩrɩ́ŋa kpátáá bʊwɛ bɛɖɛ́ɛ́zɩ-daá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Ngɛ Yaakúbu weevééri Simeyɔ́ɔnɩ na Léévi sɩsɩ: «Mɩ́ɩ́vɔ́rɔ́sɩ ma Kanáanɩ na Fɛrɛ́ɛzɩ tɛ́ɛ́dɩ bíya ɩzá-daá ɖɔ́ nɛ́, mɩ́ɩ́jáa ma tɔ́m gɛ. Ɩráa mɔ́wɛná wɛ nɛ́, bɔdɔɖɔ́ɔ; a bɩgɛ́ɛ bɛlɛ́ baadá nɔɔ́ bakágʊ́rʊ́ mɔ́rɔ́ɔ́zɩ́, bónnuudí mána mɛ́dɛ́ɛ zamɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ngɛ boobúsi yɩ sɩsɩ: «Bɩlɛ́ nɛ́, ɖénéwú gɛ báláná nyazɩ kiliɖú yáá wé.» ");
INSERT INTO kdh_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ngɛ Ɩsɔ́ɔ wɔɔdɔ́ Yaakúbu sɩsɩ: «Kʊrʊ́ nɖɛ́ɛ Betɛ́ɛlɩ ngɔ́jɔ́ɔ. A nyáádála ńna, ma ma sarɔ́ɔ ɖaalanɖɛ́, mɔ́ɔ́ weení máávʊ́ńɖʊ́ʊ malɩ́ɩ nyɔ́rɔ́ sáátɩ wenkí nyéngezewɔ́ɔ nɖawaalʊ Ísááwʊ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ngɛ Yaakúbu wɔɔdɔ́ ɩdɛ́ɛ ɩyáálɩ na wenbá barɩ́ŋa bɔwɛ ɩjɔ́ nɛ́ sɩsɩ: «Ɩlɩzɩ́ lɩzásɩ sɩwɛ mɩ́lɔ́wʊ́táá nɛ́ ɩbɛ́ɖɩ, bɩka ɩlá mɩ́dɩ ɖacɩrɩ-cɩrɩ, ɩkɛ́ɛ kpɩná kúsuuyé. ");
INSERT INTO kdh_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Sɩ ɖʊkʊrʊ́ nbɩlɛ́ ɖɩɖɛ́ɛ Betɛ́ɛlɩ; ɖándalɩ́ɩ ńna nɛ́, mánmáa Ɩsɔ́ɔ wɛɛlɛ́ɛ ma wɩ́rɛ wenɖé takáásɩ́ sɩ iɖi ma nɛ́, ɩdɛ́ɛ sarɔ́ɔ ɖaalanɖɛ́; waalaazɩ ná ma mánɩ́bááwʊ-daá.» ");
INSERT INTO kdh_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ngɛ barɩ́ŋa boodúúzi lɩzásɩ sɩḿ na bɩdɛ́ɛ abúńkunɖíwá baɖʊ Yaakúbu ndɛ́. Ngɛ ɩlɛ́ wɔɔgbɔ́ɔ bɩrɩ́ŋa iboná ɩnyʊ́ʊ́dɩ tɩɩwʊ́ kʊ́bɔńgɩ nakɩ́rɩ-dɛ, tɩɩwʊ́ kɩḿ kɩdɩláána Sɩkɛ́ɛm gɛ. ");
INSERT INTO kdh_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ngɛ baagbɩ́ɩ́rɩ bakʊrʊ́. Baagʊrʊ́ nɛ́, tɛ́ɛ́dɩwá tɩdɩláána wɛ nɛ́, tɩɩnɩ́ɩ Ɩsɔ́ɔ nɩdáárɛ, biiyéle báa naárʊ takʊrʊ́ bɔwɔ́rɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Ngɛ Yaakúbu na wenbá barɩ́ŋa bovóo yɩ nɛ́ bɔɔgɔ́nɩ batála Lúuzi tɛ́ɛ́dɩ bándayaá tɩ sɩsɩ Betɛ́ɛlɩ nɛ́ Kanáanɩ laadɔ́ɔ-daá. ");
INSERT INTO kdh_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Waadála nɛ́, ngɛ waama sarɔ́ɔ ɖaalanɖɛ́ ɖɩdáarɛ ɖɩḿ ɖɩdaá, bɩka ɩfa ɖɛ yɩ́ɖɛ sɩsɩ: Ɛ́ɛlɩ‑Betɛ́ɛlɩ; káma, sáátɩ wenkí wénzewɔ́ɔ ɩɖawaalʊ nɛ́, ńnaamʊ́ gɛ Ɩsɔ́ɔ waaɖʊ ɩlɩ́ɩ ɩrɔ. ");
INSERT INTO kdh_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Tɔ́ɔ, Ɖebóóra weení wɔɔɖɔ́kɩ Rebééka nɛ́ weevéti boboná yɩ bebí Betɛ́ɛlɩ-jɔ́ tɩɩwʊ́ bánÿaá kɩ sɩsɩ «Wíídi tɩɩwʊ́» nɛ́ kɩdɛ. ");
INSERT INTO kdh_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ngɛ sáátɩ wenkí Yaakúbu waagálɩɩ Padan-Aráamɩ ɩtála nɛ́, Ɩsɔ́ɔ waadáɖʊʊ ɩlɩ́ɩ ɩrɔ ɩɖʊ yɩ alɩbáráka. ");
INSERT INTO kdh_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ngɛ Ɩsɔ́ɔ ɩmʊ́ wɔɔdɔ́ yɩ sɩsɩ: «Nyáyɩ́ɖɛ gɛ Yaakúbu; bádándayaa nya bɩlɛ́, sɩ bayáa nya gɛ sɩsɩ Israyɛ́ɛlɩ.» Ngɛ waava yɩ yɩ́ɖɛ sɩsɩ Israyɛ́ɛlɩ. ");
INSERT INTO kdh_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ngɛ Ɩsɔ́ɔ sɩsɩ: «Mánáábɩ́lɛ́ Ɩsɔ́ɔ yíko-dʊ́ʊ, mánváa nya lʊrʊ́ʊ nlʊ́rʊ bɩɖɔ́ɔ. Yíriwá ɖabata gɛ sɩ nlʊ́rʊ; badaá, wúrowá ɖabata sɩ bɔkɔnɩ ná balɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Laadɔ́ɔ máávʊ́ńvaa kɛ Ibrahím na Ɩsaáka nɛ́, mɔ́ngbɔwʊ́ʊ kɛ mava nya; na nyɔ́ɔ́gɔ́nɩ nyɔ́wɔ́rɔ́ nɛ́, nyébíya‑bíya ɩkpɔ́ɔ kɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Bɩɩdɛ́ nɛ́, ngɛ Ɩsɔ́ɔ waagʊrʊ́ ɖɩdáarɛ lé ɩ́na Yaakúbu baazɩ́ŋ baŋmátɩ nɛ́ ɩɖɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Ngɛ Yaakúbu woozúu bʊ́ʊ́rɛ lénlé ɩ́na Ɩsɔ́ɔ baazɩ́ŋ baŋmátɩ nɛ́. Bʊ́ʊ́rɛ ɖɩḿ ɖɩrɔ gɛ weelé lɩ́m, ɩbɩ́rɩ núm ɖʊgʊjʊʊ́-daá. ");
INSERT INTO kdh_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ngɛ waava baɖɩdáarɛ ɖɩḿ yɩ́ɖɛ sɩsɩ Betɛ́ɛlɩ. ");
INSERT INTO kdh_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ngɛ ɩ́na ɩdɛ́ɛ zamɔ́ɔ baagʊrʊ́ Betɛ́ɛlɩ ńna. Báńjʊ́ʊ́ná Efɩráatɩ bɩlɛ́ gɛ Rasɩ́ɩ́la waalʊ́rʊ. Bɩdɛ́ɛ lʊrʊ́ʊ waalá yɩ káálɛ. ");
INSERT INTO kdh_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Bɩbamáa yɩ nʊŋásɩ nɛ́, ngɛ alʊ́ álʊ́rʊ́sɩ́rʊ́ wɔɔdɔ́ yɩ sɩsɩ: «Bɩ́kalá nya nɩdáárɛ; bú abaalʊ́ ɖʊɖɔ gɛ nyóóyúú.» ");
INSERT INTO kdh_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Bɩdɛ́ɛ sáátɩ kɩḿ nɛ́, ɩdɛ́ɛ weezuú wáńjʊ́ʊ́ tɛ́m; káma, bɩbá bʊwɛ bɩ́njaarɩ́ yɩ. Ngɛ waava bú ɩmʊ́ yɩ́ɖɛ sɩsɩ Bɛ́ɛnɩ-Oníi, bugutoluú sɩsɩ máwahála bú. Amá, caáwʊ ɩlɛ́ waava yɩ gɛ sɩsɩ Bɛ́ɛnɩ-Yáámíínu, bugutoluú sɩsɩ mólowú-dɛ bú. ");
INSERT INTO kdh_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ngɛ Rasɩ́ɩ́la waazɩ́ bɔkpɔ́ɔ yɩ bebí Efɩráatɩ tɛ́ɛ́dɩ bánÿaá tɩ sɩsɩ Bɛtɩlɛhɛ́ɛm nɛ́ tɩdɛ́ɛ nɩ́bááwʊ-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ngɛ Yaakúbu woozúu bʊ́ʊ́rɛ ɩbɔɔlááwʊ kɩḿ kɩrɔ; hálɩ na sinje, bʊ́ʊ́rɛ ɖɩḿ ɖɩdɛɛzɩzuwáa ńna, bánÿaá bɩɖɩdáarɛ sɩsɩ Rasɩ́ɩ́la bɔɔlááwʊ bʊ́ʊ́rɛ. ");
INSERT INTO kdh_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Ngɛ Israyɛ́ɛlɩ, bándayaá yɩ sɩsɩ Yaakúbu nɛ́, waagʊrʊ́ ɩɖɛ́ɛ ikózuu Mɩgɩdáalɩ-Ɛdɛ́ɛrɩ wɔ́rɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Sáátɩ wenkí ɩwɛ ńna nɛ́, ngɛ Rʊ́bɛ́ɛnɩ woobó ɩfɩnɩná ɩjaa ɩmʊ́ ɩɖɛɛlʊ́ kúmuú Bíla. Ngɛ tɔ́m tɩḿ tɩɩzʊ́ʊ ɩjaa nɩgbamʊʊ́-daá. Yaakúbu ɩmʊ́ ɩjɔɔ́ɔ bɩlɛ́ nɛ́, ibíya abaaláa riké kɛ́ɛ ɩráa kʊjʊ́nɩ fuú na natɩ́lɛ gɛ. ");
INSERT INTO kdh_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Léya-dɛ́ɛ bíya nɖɔ́: Rʊ́bɛ́ɛnɩ, ɩlɛ́ ɩgɛ́ɛ na Yaakúbu-dɛ́ɛ bú kaɖaa ńnɩ́. Simeyɔ́ɔnɩ, Léévi, Yudáa, Isakáarɩ na Zabulɔ́ɔnɩ. ");
INSERT INTO kdh_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rasɩ́ɩ́la-dɛ́ɛ bíya nɖɔ́: Ísifu na Bɛ́ɛnɩ-Yáámíínu. ");
INSERT INTO kdh_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rasɩ́ɩ́la-dɛ́ɛ yoḿ Bíla-dɛ́ɛ bíya nɖɔ́: Dáanɩ na Nɛfɩtalíi. ");
INSERT INTO kdh_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Léya ɩlɛ́ iyoḿ Zílipa-dɛ́ɛ bíya nɖɔ́: Gaádɩ na Asɛ́ɛrɩ. Tɔ́ɔ, Yaakúbu-dɛ́ɛ bíya waalʊ́rʊ wɛ Padan-Aráamɩ nɛ́ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Bɩjɔɔ́ɔ nɛ́, ngɛ woobó ɩkɔ́mɔ́ɔ́ná ɩjaa Ɩsaáka Mamɩrée Kiriyátɩ-Arɩbáa tɛ́ɛ́dɩ bándayaá tɩ Ebɩrɔ́ɔnɩ nɛ́ tɩdaá; ńnaamʊ́ gɛ ɩjaa Ɩsaáka na ɩjaájaa Ibrahím baavʊ́ńjɔwʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Bɩ́ɩ́zɩ kákpáŋa ákoowú fɛ́yɩ́ (180) gɛ Ɩsaáka waalá ɖúúlínya-daá ");
INSERT INTO kdh_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","naanɩ́ ɩsɩ́ ibó ɩkɔ́mɔ́ɔ́ná kʊ́bɔnáa. Waabá gɛ ɩbɩ́ɩ ɩlá ábɔ́nɩ́. Ngɛ ibiyaalɩnáa Ísááwʊ na Yaakúbu bɔɔgbɔ́ɔ yɩ boboná bebí. ");
INSERT INTO kdh_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ísááwʊ bándayaá yɩ Edɔ́m nɛ́ igutoluú-dɛ bíya nɖɔ́: ");
INSERT INTO kdh_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Kanáanɩ aléewá lɔwʊtáá gɛ Ísááwʊ wɛɛbɛ́ɛ́ŋ ɩkpɔ́ɔ ɩdɛ́ɛ aláa; Hitíi ńnɩ́ Elɔ́ɔnɩ wɛɛlɛ́ɛ Adáa, Hivíi ńnɩ́ Sibeyɔ́ɔnɩ wɛɛlɛ́ɛ Anáa-dɛ́ɛ bú Oholibamáa; ");
INSERT INTO kdh_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","na Asʊmáyɩ́la wɛɛlɛ́ɛ Basɩmáatɩ. Aléeré ɩmʊ́ igoobú gɛ Nebayɔ́ɔtɩ. ");
INSERT INTO kdh_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Elifáazɩ gɛ Adáa waalʊrʊná Ísááwʊ. Basɩmáatɩ ɩlɛ́ ɩlʊrʊná yɩ Rehuwɛ́ɛlɩ; ");
INSERT INTO kdh_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ngɛ Oholibamáa ɩlɛ́ waalʊ́rʊ Yewúsɩ, Yawɛlám na Korée. Bíya wenbá Ísááwʊ waalʊ́rʊ wɛ Kanáanɩ laadɔ́ɔ-daá nɛ́ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ngɛ Ísááwʊ waagʊrʊ́ ɩsɛlɩ́ ɩɖɛɛlɩnáa, na ibiyaalɩnáa, na ɩwɛɛlɩnáa, na ɩɖaána-daá ńba rɩ́ŋa, na ɩdɛ́ɛ fʊ́ńdɩ kpɩná kúmuwé na kʊ́bɔná; na ɩdɛ́ɛ ɖɔ́ɔ́lɛ rɩ́ŋa wenɖé wooyuú ɖɛ Kanáanɩ nɛ́ ɩkpɔ́ɔ ɩɖɛ́ɛ tɛ́ɛ́dɩ natɩ́rɩ-daá ɩlaná inewú Yaakúbu bolíni. ");
INSERT INTO kdh_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Bɛlɛ́ɛ́nɩ́, báa awéní-dɛ́ɛ ɖɔ́ɔ́lɛ fɛ́yɩ́na kalɩ́ɩ; ngʊ́ nbɛ́ɛ nɛ́, bɔwɛná fʊ́ńdɩ kpɩná ɖabata, biiyéle ɖɩdáarɛ bɔwɛ ɖɩdaá nɛ́, ɖidokúti ɖɩcáa sɩ ɖɩwála wɛ bɛlɛ́ɛ́nɩ́ boyóózi bɔcɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ngɛ Ísááwʊ Edɔ́m wɛɛɖɛ́ɛ ikózuu Seyíiri bʊ́ʊ-daá. ");
INSERT INTO kdh_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Edɔ́m ńba ɩjaa kʊ́bɔnɩ́ Ísááwʊ, Seyíiri bʊ́ʊ-daá abaalʊ́ ɩmʊ́ igutoluú-dɛ bíya nɖɔ́; ");
INSERT INTO kdh_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Ísááwʊ biyaalɩnáa yɩrá nɖɔ́: Elifáazɩ, ɩɖɛɛlʊ́ Adáa waalʊrʊná yɩ nɛ́; na Rehuwɛ́ɛlɩ ɩɖɛɛlʊ́ Basɩmáatɩ waalʊrʊná yɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifáazɩ ɩlɛ́ ibiyaalɩnáa yɩrá nɖɔ́: Temáanɩ, Omáarɩ, Sééfu, Gayetám na Kenáazɩ. ");
INSERT INTO kdh_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Ngɛ Ísááwʊ biyaalʊ́ Elifáazɩ ɩmʊ́ igúti ɩwɛná alʊ́ asʊ ńnɩ́ naárʊ kúmuú, bánÿaá ɩlɛ́ sɩsɩ Tɩ́mɩna. Ngɛ Tɩ́mɩna ɩmʊ́ waalʊrʊná yɩ Amalɛ́ɛkɩ. Tɔ́ɔ, Ísááwʊ ɖɛɛlʊ́ Adáa biyaalɩnáa nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Rehuwɛ́ɛlɩ ɩlɛ́ ɩdɛ́ɛ bíya nɖɔ́: Naháatɩ, Zeráa, Samáa na Mizáa. Ísááwʊ ɖɛɛlʊ́ Basɩmáatɩ biyaalʊ́-bíya yɩrá nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ísááwʊ ɖɛɛlʊ́ Oholibamáa Sibeyɔ́ɔnɩ biyaalʊ́ Anáa wɛɛlɛ́ɛ biyaalɩnáa waalʊrʊná Ísááwʊ nɛ́ bayɩrá nɖɔ́: Yewúsɩ, Yawɛlám na Korée. ");
INSERT INTO kdh_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ɖugoré báa wenɖé-dɛ́ɛ wúrowá bɩɩlɩzɩ́ wɛ Ísááwʊ-dɛ́ɛ lʊrʊ́ʊ-daá nɛ́ nɖɔ́: wúrowá baalɩ́ɩ Ísááwʊ-dɛ́ɛ bú kʊ́bɔnɩ́ Elifáazɩ-dɛ́ɛ lʊrʊ́ʊ-daá nɛ́ nɖɔ́: wúro Temáanɩ, wúro Omáarɩ, wúro Sééfu, wúro Kenáazɩ, ");
INSERT INTO kdh_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","wúro Korée, wúro Gayetám na wúro Amalɛ́ɛkɩ. Wúrowá wenbá baalɩ́ɩ Elifáazɩ na ɩɖɛɛlʊ́ Adáa bɛdɛ́ɛ lʊrʊ́ʊ-daá Edɔ́m tɛ́ɛ́dɩ-daá nɛ́ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Wúrowá baalɩ́ɩ Ísááwʊ biyaalʊ́ Rehuwɛ́ɛlɩ-dɛ́ɛ lʊrʊ́ʊ-daá nɛ́ nɖɔ́: wúro Naháatɩ, wúro Zeráa, wúro Samáa na wúro Mizáa. Wúrowá baalɩ́ɩ Ísááwʊ na ɩɖɛɛlʊ́ Basɩmáatɩ bebiyaalʊ́ Rehuwɛ́ɛlɩ-dɛ́ɛ lʊrʊ́ʊ-daá Edɔ́m nɛ́ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Wúrowá baalɩ́ɩ Ísááwʊ na ɩɖɛɛlʊ́ Oholibamáa bɛdɛ́ɛ lʊrʊ́ʊ-daá nɛ́ nɖɔ́: wúro Yewúsɩ, wúro Yawɛlám, na wúro Korée. Wúrowá baalɩ́ɩ Ísááwʊ na ɩɖɛɛlʊ́ Anáa wɛɛlɛ́ɛ Oholibamáa-dɛ́ɛ lʊrʊ́ʊ-daá nɛ́ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ísááwʊ-dɛ́ɛ bíya-daá wenbá beeɖi kowúrátɩ nɛ́ nbɩlɛ́. Ísááwʊ ɩmʊ́ ɩnáábɩ́lɛ́ Edɔ́m. ");
INSERT INTO kdh_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Seyíiri, Hɔ́ɔrɩ abaalʊ́ ɩvʊnwɛ tɛ́ɛ́dɩ-daá nɛ́-dɛ́ɛ bíya nɖɔ́: Lotáanɩ, Sobáalɩ, Sibeyɔ́ɔnɩ, Anáa, ");
INSERT INTO kdh_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Ɖisɔ́ɔnɩ, Esɛ́ɛrɩ na Ɖisáanɩ. Hɔ́ɔrɩ ńba-dɛ́ɛ wúrowá Seyíiri waalʊ́rʊ wɛ Edɔ́m tɛ́ɛ́dɩ-daá nɛ́ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotáanɩ-dɛ́ɛ bíya waalʊ́rʊ wɛ nɛ́ gɛ Horíi na Hemáamɩ. Lotáanɩ ɩmʊ́ ɩgaa gɛ Tɩ́mɩna. ");
INSERT INTO kdh_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobáalɩ biyaalɩnáa yɩrá nɖɔ́: Alɩváanɩ, Manaháatɩ, Ebáalɩ, Sefóo na Onáamɩ. ");
INSERT INTO kdh_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeyɔ́ɔnɩ biyaalɩnáa yɩrá nɖɔ́: Aya na Anáa. Anáa ɩmʊ́ waazɩŋ ná ɩlɩ́ɩ búúzi kʊjʊ́nɩ sizoláa nɛ́ sɩrɔ tɛɛwʊ́lɔ́ɔ́-daá sáátɩ wenkí wéngetí ɩjaa Sibeyɔ́ɔnɩ-dɛ́ɛ kpangbásɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anáa ɩlɛ́ ibíya yɩrá nɖɔ́: ibiyaalʊ́ Ɖisɔ́ɔnɩ na ɩwɛɛlɛ́ɛ Oholibamáa. ");
INSERT INTO kdh_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ɖisɔ́ɔnɩ biyaalɩnáa yɩrá nɖɔ́: Hɛmɩdáanɩ, Esebáanɩ, Yitiráanɩ na Keráanɩ. ");
INSERT INTO kdh_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Esɛ́ɛrɩ ɩlɛ́ ibiyaalɩnáa yɩrá nɖɔ́: Biliháanɩ, Zaváanɩ, na Akáanɩ. ");
INSERT INTO kdh_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ɖisáanɩ biyaalɩnáa yɩrá nɖɔ́: Úusi na Aráanɩ. ");
INSERT INTO kdh_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Hɔ́ɔrɩ ńba-dɛ́ɛ wúrowá yɩrá nɖɔ́: wúro Lotáanɩ, wúro Sobáalɩ, wúro Sibeyɔ́ɔnɩ, wúro Anáa, ");
INSERT INTO kdh_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","wúro Ɖisɔ́ɔnɩ, wúro Esɛ́ɛrɩ na wúro Ɖisáanɩ. Hɔ́ɔrɩ ńba-dɛ́ɛ wúrowá beeɖi kowúrátɩ Seyíiri tɛ́ɛ́dɩ-daá nɛ́ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Wúrowá beeɖi kowúrátɩ Edɔ́m tɛ́ɛ́dɩ-daá naanɩ́ na basɩ́ɩ kowúrátɩ Israyɛ́ɛlɩ nɛ́ bayɩrá nɖɔ́: ");
INSERT INTO kdh_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beyɔ́ɔrɩ biyaalʊ́ Béla, ɩlɛ́ ɩmʊ́ weeɖi kowúrátɩ Edɔ́m laadɔ́ɔ-daá; ɩdɛ́ɛ tɛ́ɛ́dɩ yɩ́ɖɛ gɛ Ɖináába. ");
INSERT INTO kdh_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Béla wɔɔgɔ́nɩ ɩsɩ́; ngɛ Zeráa Bosɩráa ńnɩ́ biyaalʊ́ Yobáabɩ weeɖi kowúrátɩ ɩɖɩdáarɛ. ");
INSERT INTO kdh_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Ngɛ Yobáabɩ ɩmʊ́ ɖʊɖɔ wɔɔgɔ́nɩ ɩsɩ́; ngɛ Temáanɩ ńnɩ́ Husáamɩ weeɖi kowúrátɩ ɩɖɩdáarɛ. ");
INSERT INTO kdh_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Ngɛ Husáamɩ ɖʊɖɔ wɔɔgɔ́nɩ ɩsɩ́; waazɩ́ nɛ́, ngɛ Bedáadɩ biyaalʊ́ Hadáa wɔɔgbɔ́ɔ ɩɖɩdáarɛ. Ɩlɛ́ ɩmʊ́ wooyoo ná Madiyáanɩ ńba Mowáabɩ fásɩ-daá. Ɩdɛ́ɛ́dɩ gɛ bánÿaá sɩsɩ Avíiti. ");
INSERT INTO kdh_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadáadɩ wɔɔgɔ́nɩ ɩsɩ́; waazɩ́ nɛ́, ngɛ Masɩrekáa ńnɩ́ Samɩláa weeɖi kowúrátɩ ɩɖɩdáarɛ. ");
INSERT INTO kdh_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samɩláa wɔɔgɔ́nɩ ɩsɩ́; waazɩ́ nɛ́, ngɛ Rehɔbɔ́ɔtɩ tɛ́ɛ́dɩ tʊwɛ buwá-rɔ nɛ́ ńnɩ́ Sawúuli weeɖi kowúrátɩ ɩɖɩdáarɛ. ");
INSERT INTO kdh_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sawúuli wɔɔgɔ́nɩ ɩsɩ́; waazɩ́ nɛ́, ngɛ Akɩbɔ́ɔrɩ biyaalʊ́ Báalɩ-Hanáanɩ weeɖi kowúrátɩ ɩɖɩdáarɛ. ");
INSERT INTO kdh_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Ngɛ Akɩbɔ́ɔrɩ biyaalʊ́ Báalɩ-Hanáanɩ wɔɔgɔ́nɩ ɩsɩ́; waazɩ́ nɛ́, ngɛ Hadáarɩ weeɖi kowúrátɩ ɩɖɩdáarɛ. Ɩlɛ́ ɩdɛ́ɛ́dɩ gɛ bánÿaá sɩsɩ: Pawúu. Ngɛ ɩɖɛɛlʊ́ gɛ Metabɛ́ɛlɩ, Mezaháabɩ wɛɛlɛ́ɛ Matɩrɛ́ɛdɩ-dɛ́ɛ bú nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Wúrowá beeɖi Ísááwʊ-dɛ́ɛ lʊrʊ́ʊ-daá nɛ́ bɛdɛ́ɛ sɛ́ɛ́dɩ na bɛdɛ́ɛ́dɩ na bayɩrá nɖɔ́: wúro Tɩ́mɩna, wúro Alɩváa, wúro Yetɛ́ɛtɩ, ");
INSERT INTO kdh_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","wúro Oholibamáa, wúro Éla, wúro Pinɔ́ɔnɩ, ");
INSERT INTO kdh_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","wúro Kenáazɩ, wúro Temáanɩ, wúro Mibisáarɩ, ");
INSERT INTO kdh_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","wúro Magɩdɩyɛ́ɛlɩ na wúro Iráamɩ. Edɔ́m wúrowá wenbá boozúu adá ndɩ‑ndɩ bɛdɛ́ɛ́dɩ-daá nɛ́ nbɩlɛ́. Ísááwʊ náábɩ́lɛ́ Edɔ́m ńba ɩjaájaa. ");
INSERT INTO kdh_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yaakúbu ɩlɛ́ wɛɛɖɛ́ɛ ikózuu Kanáanɩ laadɔ́ɔ-daá lénlé ɩjaa waavʊ́ńjɔwʊ́ ɩgɔ́ńdɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Bɛɛ Yaakúbu ɩmʊ́ igutoluú-dɛ bíya-dɛ́ɛ tɔ́m. Ɩdɛ́ɛ bú Ísifu waalá bɩ́ɩ́zɩ ákɩzaalʊʊ́ na nasɩ́lɛ (17) nɛ́, ɩ́na ɩɖawaalɩnáa béngetí fééni na namɩ́nɩ; bɔwɛ nɛ́, ɩmʊ́ Ísifu na ɩgɔɔ yɔ́ɖɔ́ɔ́nɩ́náa Bíla na Zílipa bebiyaalɩnáa béngeti kʊ fʊ́ńdɩ kpɩná. A bɛlɛ́ baalá nabʊ́rʊ bɩdakazɔ́ɔ, ɩmʊ́ wɔ́ngɔnáa gɛ wénveerím bajaa. ");
INSERT INTO kdh_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yaakúbu ɩbá ɩzɔɔlɛ́ɛ Ísifu-dɛ́ɛ tɔ́m gɛ bɩkɩ́lɩ ibíya baaganáa; káma, ɩdɛ́ɛ ábɔɔ-bú nbɩlɛ́. Ngɛ ɩjaa waanyára yɩ jaba kífeńgi nakɩ́rɩ. ");
INSERT INTO kdh_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ɩɖawaalɩnáa wooyuú bana sɩsɩ bajaa sɔɔlɛ́ɛ Ísifu-dɛ́ɛ tɔ́m bɩkɩ́lɩ bɛḿ. Ngɛ baalɩzɩ́ ɩzɩ́rɛ batɩ́nɩ ɩrɔ; bádándabá bokúti bacáa baŋmatɩná yɩ ɖɛfɛɛ. ");
INSERT INTO kdh_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Wɩ́rɛ bɩjɔɔ́ɔ nɛ́, ngɛ Ísifu wooɖóózi, ngɛ ɖoozire ɖɩḿ ɖiiyéle ɩɖawaalɩnáa tándacaa ɩdɔ́m. ");
INSERT INTO kdh_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ngɛ weevééri ɩɖawaalɩnáa sɩsɩ: «Móóɖóózi ɖoozire neɖére; iwélesi ɩnɩ́ɩ ɖɛ. ");
INSERT INTO kdh_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Móóɖóózi sɩsɩ ɖárɩ́ŋa ɖɔ́wɛ fɔɔ́ ɖɔ́nvɔkɩ́ mɩlá abángámá. Sɩ ɖɩtɔ́ na ɖusú nɛ́, mɛ́dɛ́ɛ ɖɩbánɖɛ́ waagʊrʊ́ ɖɩsɩ́ŋ ɩsɔ́ɔ́dáá; ngɛ mɩ́ɩ mɩ́dɛ́ɛ ńná wɔɔgɔ́nɩ alára amɩlɩná ɖɛ, acáŋ alúúzi adɩ ɖɩɩzá-daá.» ");
INSERT INTO kdh_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Waaŋmátɩ bɩlɛ́ nɛ́ gɛ ɩɖawaalɩnáa sɩsɩ: «Kéyi, bɩlɛ́ nɛ́, nyánvʊʊ́ sɩsɩ sɩ ngɔ́nɩ nbɩ́sɩ wúro bɩka nɖi ɖɔ́ɔ́ ɖɔ́rɔ́ɔ́zɩ́ kʊ́bɔńdɩ yáá wé.» Ɩdɛ́ɛ ŋmatɩrɛ na ɩdɛ́ɛ ɖoozá amʊ́ aabá ayéle ɩɖawaalɩnáa ɩbá bɔnyɔ́ɔ́zɩ balɩzɩ́ ɩzɩ́rɛ batɩ́nɩ ɩrɔ. ");
INSERT INTO kdh_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Bɩdɔrɔjɔɔ́ɔ ɖʊɖɔ nɛ́, Ísifu woodóɖoozi ɖoozire neɖére. Ngɛ wɔɔdɔ́kpɔwʊ́ ɖɛ ifééri ɩɖawaalɩnáa sɩsɩ: «Óo, ɖɛ́dɛ́ɛ ńba, móódóɖoozi ɖʊɖɔ: móóɖóózi sɩsɩ wɩ́sɩ na fenɔɔ́ na wɩlásɩ fuú na nɛkɛ́rɛ bɔɔgɔ́nɩ bosóm máázá-daá.» ");
INSERT INTO kdh_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ngɛ ɩdasɩŋná bɛlɛ́ beriké, weevééri ɩjaa ɖʊɖɔ. Ɩjaa waanɩ́ɩ bɩlɛ́ nɛ́, ngɛ ɩlɛ́ sɩsɩ: «Kéyi, we-dɛ́ɛ ɖoozire nbɩlɛ́; bɩlɛ́ nɛ́, mána ngɔɔ na nɖawaalɩnáa sɩ ɖɩkɔ́nɩ ɖisóm nyáázá-daá yáá wé.» ");
INSERT INTO kdh_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ngɛ ɩɖawaalɩnáa waabá bánlám yɩ sʊ́ʊ́zɩ; amá, bajaa ɩlɛ́ ɩdɔsɔɔná tɩ. ");
INSERT INTO kdh_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Wɩ́rɛ bɩjɔɔ́ɔ nɛ́, ngɛ ɩɖawaalɩnáa wɔɔgbɔ́ɔ fééni na namɩ́nɩ bɛɖɛɛná Sɩkɛ́ɛm kisɔɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Wɩ́rɛ neɖére nɛ́, ngɛ bajaa waayáa yɩ sɩsɩ: «Ísifu, nyányɩ sɩsɩ nɖawaalɩnáa kɔwɛ Sɩkɛ́ɛm fáráńdɩ́ bána bavʊ́ńdɩ kpɩná ya. Méndiríi nya bɔjɔ́.» Ngɛ Ísifu woobúsi yɩ sɩsɩ: «Tɔ́ɔ, baabá.» Ngɛ Yaakúbu sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","«Bo ngɛ́bɛɛŋ wɛ sɩsɩ bána badɩ? A nyáagána wenbí-daá bɔwɛ nɛ́, ngábɩsɩ ngɔ́nɩ nvééri ma.» Ngɛ waalɩ́ɩ bɛdɛ́ɛ Ebɩrɔ́ɔnɩ kazalɩ́ya-daá ɩkpɔ́ɔ Sɩkɛ́ɛm nɩ́bááwʊ. Woobó ɩtála Sɩkɛ́ɛm nɛ́, ");
INSERT INTO kdh_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ɩdatɩlɩ́ na fúu lénlé ɩɖawaalɩnáa wɛná nɛ́. Ngɛ wɔɔgbɔ́ɔ yɛrɛ́tɩ. Ɩdɛ́ɛ yɛrɛ́tɩ tɩḿ tɩdaá, wɛɛgɛtɩná abaalʊ́ naárʊ fɔɔ́-daá ɖeelí; ngɛ ɩlɛ́ wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Afobú, we gɛ nyánjáádɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ngɛ Ísifu sɩsɩ: «Maɖawaalɩnáa gɛ mánjáádɩ; la suúru, a nyányɩ lénlé béngilináa fééni nɛ́, nvééri ma.» ");
INSERT INTO kdh_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ngɛ ɩlɛ́ sɩsɩ: «Óo, báńlɩ́ɩ́ cé; máánɩ́ɩ bánŋmatɩ́ sɩsɩ bɛḿ bánbɩsɩnáa Ɖɔtáanɩ fáráńdɩ́.» Ngɛ Ísifu wɔɔgbɔ́ɔ nɩ́bááwʊ. Woobó ɩtála Ɖɔtáanɩ ńnaamʊ́ nɛ́, toovonúm, wɔɔmɔɔná wɛ. ");
INSERT INTO kdh_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Sáátɩ wenkí bɛlɛ́ baagʊ́sɩ bakáná yɩ bolíni ɩgɛgɛrɛŋɛ nɛ́, naanɩ́ ɩtála bɔjɔ́ nɛ́, báńjáá áséńsí sɩsɩ bángʊ́ʊ yɩ. Ngɛ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","«Kɛbɛɛ ɖɛ́dɛ́ɛ ɖoozá-dʊ́ʊ ɩmʊ́ ɩgɛgɛrɛŋɛ ná ɖɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","A bɩgɛ́ɛ waadála, ɖɩ́kʊ́ yɩ ɖɩsɛlɩ́ ɖʊlɔ lɔkɔ nakɩ́rɩ-daá, bɩka ɖubuuná sɩsɩ fɔɔ́-daá kpɩ́nɖɛ neɖére wɔɔdɔɔ ná yɩ. A ɖáálá yɩ bɩlɛ́, ɖánnáa nŋɩ́nɩ́ ɩdɛ́ɛ ɖoozá sɩ akɛ́dɛ́ná nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Baɖawaalʊ kʊ́bɔnɩ́ gɛ bánÿaá sɩsɩ Rʊ́bɛ́ɛnɩ; ɩlɛ́ waanɩ́ɩ bɩlɛ́ nɛ́, ngɛ weegízi sɩsɩ bákakʊ yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ngɛ sɩsɩ: «Ɩ́kakʊ ɩrʊ́, bɛɛ lɔkɔ tɛɛwʊ́lɔ́ɔ́-daá cé, lɩ́m fɛ́yɩ́ kɩdaá; a wɔɔgɔ́nɩ, ɩzɛlɩ́ yɩ ɩlɔ kɩdaá, ɩ́kakʊ yɩ.» We-rɔ gɛ baɖawaalʊ ɩmʊ́ waalá lɔ́nɩ ɩmʊ́, káma, ɩzɔɔlɛ́ɛ sɩ ɩlɛ́ɛ benewú Ísifu ɩbɩ́sɩ ɩkɔ́mɔ́ɔ́ná bajaa ɖaána na alaafɩ́ya. ");
INSERT INTO kdh_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Sáátɩ wenkí Ísifu wɔɔgɔ́nɩ ɩtála bɔjɔ́ nɛ́, ngɛ beegbí yɩ, bobúti ɩdɛ́ɛ jaba kífeńgi kɩna ɩrɔɔzɩ́, ");
INSERT INTO kdh_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ngɛ bɛɛzɛlɩ́ yɩ bɔlɔ lɔkɔ kɩḿ kɩdaá. ");
INSERT INTO kdh_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Bɔɔlɔ yɩ bɩtɛ́ nɛ́, ngɛ bɛɛɖɛ́ɛ bobó betí bɔcɔ́ɔ bénɖíi kíɖíím. Bɩɩgɔ́nɩ bɩtásɩ nɛ́, baagáná fótóósi-dɩnáa nɛbɛ́rɛ kɛgɛrɛŋɛ. Baagálɩ́ɩ́ná tɛ́ɛ́dɩ bánÿaá tɩ sɩsɩ Galáadɩ nɛ́ bɛ́nɖɛɛ́ Mɩ́sɩra tɛ́ɛ́dɩ-daá, bɛgɛ́ɛ Asʊmáyɩ́la-dɛ́ɛ fɔɔlʊʊ́-daá ńba gɛ. Bɛdɛ́ɛ raakúḿwá kazʊwáána kpɩná: yáázɩwá, tulaarɩ́ na faadɩ́nɩ núm ńdɩ. ");
INSERT INTO kdh_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ísifu ɖawaalɩnáa-daá naárʊ gɛ bánÿaá sɩsɩ Yudáa. Ńna gɛ wɔɔdɔ́ igoobíya sɩsɩ: «Ɖɛ́dɛ́ɛ ńba, ɖɩkʊ ɖénéwú ɖusuná ɖádɩ, we gɛ sɩ bɩtásɩ ɖáa. Ɖánlám bɩlɛ́ bɩtɛ́, na bɩrɩ́ŋa, ɖénéwú gɛ ɩgɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Bɩlɛ́ nɛ́ ɖɩ́kpɔɔ yɩ ɖɩyaná Asʊmáyɩ́la-dɛ́ɛ ńba bɛ́nɖɛɛ́ ɖɔ́ nɛ́; ɖíketekiná yɩ; káma, ɖárɩ́ŋa, azimá kʊ́ɖʊmá gɛ.» Ngɛ baaganáa weedísi. ");
INSERT INTO kdh_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Medáanɩ fótóósi-dɩnáa bɛḿ bɔɔgɔ́nɩ bɛ́nɖɛɛ́ nɛ́, ngɛ baalɩzɩ́ benewú Ísifu lɔkɔ-daá bayaná bɛlɛ́ wɛ́ ákoowú tɩmɛ́rɛ liideé; bɛlɛ́ bacáŋ bɔkpɔ́ɔ yɩ bɛɖɛɛná Mɩ́sɩra. ");
INSERT INTO kdh_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Bɩɩgɔ́nɩ bɩtásɩ ɖawaalʊ́ʊ kʊ́bɔnɩ́ Rʊ́bɛ́ɛnɩ wɔɔgɔ́nɩ iwííli lɔkɔ-daá ɩbɛ́ɛ nɛ́, ŋméńgéléḿ, Ísifu fɛ́yɩ́ ńna. Ngɛ bɩɩgʊ́sɩ ɩlaakáarɩ, ɩcáŋ ɩlɛrɩ́ idóko. ");
INSERT INTO kdh_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ngɛ woozúu ɩbɩ́sɩ inewáa-jɔ́ ifééri wɛ sɩsɩ: «Bú fɛ́yɩ́ ńna; nŋɩ́nɩ́ gɛ sɩ malá lɛlɛɛɖɔ́ ɖɔ́.» ");
INSERT INTO kdh_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ngɛ boobó bɛbɛ́ɛ fʊ́ńdɩ kpɩná-daá bakálɩzɩ́ agbɛzɛyɩ́ bɔkɔná bakʊ, bɔkpɔ́ɔ Ísifu-dɛ́ɛ jaba baalɩzɩ́ kɩ ɩrɔɔzɩ́ nɛ́ banyʊʊ́ azimá-daá. ");
INSERT INTO kdh_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Bɩɩdɛ́ nɛ́, ngɛ bɔɔgbɔ́ɔ kɩ beyéki boboná bajaa sɩsɩ ɩ́mʊ́ tóko kɩna ɩbɛ́ɛ, kɩɩlɩ́ɩ ibiyaalʊ́-dɛ́ɛ tóko? ");
INSERT INTO kdh_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Baadalaná kɩ bawɩ́lɩ bajaa Yaakúbu nɛ́, ɩlɛ́ wɛɛbɛ́ɛ tóko kɩna nɛ́, waadɩlɩ́ kɩ. Ngɛ sɩsɩ: «Ówu, móbú-dɛ́ɛ tóko nbɩlɛ́. Fɔɔ́-daá fʊ́ńdɩ kpɩ́nɖɛ neɖére waayáázɩ Ísifu sɔ́m bɩka ɖɩtɔ́ɔ yɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ngɛ bɩɩbá bɩkʊ́sɩ ɩlaakáarɩ, ɩcáŋ ɩlɛrɩ́ idóko izóóna kɩ nɛ́; ibó ɩkpɔ́ɔ ɩzá nyɩ́nŋɩrɛ kpɩná isúu. Ɖoo wɔɔgbɔ́ɔ mɛɛdɩrɛ nɛ́, hálɩ wɛ́-bíya ɖabata. ");
INSERT INTO kdh_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ibiyaalɩnáa na ɩwɛɛlɩnáa rɩ́ŋa ɩbɛ́ɛ́lɩ yɩ bawɩ́ɩ, weegízi ɩbamáa sɩsɩ bɩlɛ́ gɛ ɩmʊ́ sɩ ɩcɔ́ɔ lííya hálɩ ɩmʊ́ ibó ɩkɔ́mɔ́ɔ́ná ibú. Ngɛ ɩjɔɔ́ɔ ɩbamáa yɩ wíídi. ");
INSERT INTO kdh_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Medáanɩ fótóósi-dɩnáa bɛḿ baadalaná Ísifu Mɩ́sɩra nɛ́, ngɛ babɩsɩná yɩ bayaná Pɔtɩfáarɩ. Ɩlɛ́ gɛ Mɩ́sɩra wúro Farawʊ́na-dɛ́ɛ fereɖáa-dɛ́ɛ kʊ́bɔnɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Sáátɩ kɩḿ gɛ Yaakúbu biyaalʊ́ Yudáa waalɩ́ɩ igoobíya-jɔ́ ɩɖɛ́ɛ Aduláam abaalʊ́ bánÿaá yɩ sɩsɩ Hiráa nɛ́ ɩjɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ńna gɛ ɩwɛ gɛ waana Kanáanɩ ńnɩ́ Súwa wɛɛlɛ́ɛ ɩkpɔ́ɔ yɩ ɩbɩ́sɩ ɩɖɛɛlʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Bɩjɔɔ́ɔ nɛ́, alʊ́ wɛɛyɛ́ɛ fuwá ɩlʊ́rʊ bú abaalʊ́, ngɛ baava yɩ yɩ́ɖɛ sɩsɩ Ɛ́ɛrɩ. ");
INSERT INTO kdh_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ngɛ waadámʊʊ fuwá ɖʊɖɔ ɩlʊ́rʊ bú abaalʊ́; ngɛ baava ɩlɛ́ yɩ́ɖɛ sɩsɩ Onáanɩ. ");
INSERT INTO kdh_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ɩlɛ́ ɩwɔ́rɔ́ nɛ́, ngɛ waadátasɩ ɩlʊ́rʊ bú abaalʊ́, ngɛ baava ɩlɛ́ yɩ́ɖɛ sɩsɩ Séla. Kezíibi tɛ́ɛ́dɩ-daá gɛ bɔwɛ gɛ balʊ́rʊ ɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Bɩjɔɔ́ɔ nɛ́, ngɛ Yudáa wɔɔgbɔ́ɔ alʊ́ icéle ibiyaalʊ́ kʊ́bɔnɩ́ Ɛ́ɛrɩ; bánÿaá alʊ́ ɩmʊ́ sɩsɩ Tamáarɩ. ");
INSERT INTO kdh_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ɛ́ɛrɩ cɔɔ́ɔ bɩlɛ́ nɛ́, waabá gɛ ɩlá kidaavééníti Ɩsɔ́ɔ ɩzá-daá; ngɛ Ɩsɔ́ɔ waalɩzɩ́ iweezuú. ");
INSERT INTO kdh_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ńna gɛ Yudáa wɔɔdɔ́ Onáanɩ sɩsɩ: «Nyányɩ wenbí bɩɩbɔ́ɔ́zɩ sɩsɩ a ngoobú waazɩ́, ńla ɩɖɛɛlʊ́ nɛ́. Bɩlɛ́ nɛ́ Kpɔɔ nɖawaalʊ ɖɛɛlʊ́ ńŋɩnáa bɩɩbɔ́ɔ́zɩ nɛ́ bɩka ɩlʊ́rʊ yɩ bíya.» ");
INSERT INTO kdh_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Amá, Onáanɩ waana sɩsɩ báa baalʊ́rʊ, bɩdɛkɛ́ɛ bíya sɩ balá ɩdɛ́ɛ ńba nɛ́, a ɩ́na alʊ́ boyóózi gɛ sɩ ɩna ɩdɩ, adɛ gɛ wánbɩrɩ́ɩ na alʊ́ ɩ́kamʊ fuwá ɩlʊ́rʊ ɩɖawaalʊ bú. ");
INSERT INTO kdh_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ɩlakásɩ sɩḿ sɩdɔmɔ́ɔ Ɖádʊ́ʊ Ɩsɔ́ɔ nɛ́, ngɛ Ɩsɔ́ɔ waalɩzɩ́ ɩmʊ́ ɖʊɖɔ iweezuú. ");
INSERT INTO kdh_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Bɩɩlá bɩlɛ́ nɛ́, ngɛ Yudáa wɔɔdɔ́ iwoolú Tamáarɩ ɩsɩ ɩ́kpɔɔ ikpé ɩjaa-dɛ́ɛ ɩkɔ́jɔ́ɔ leelíti ɩɖáŋ ɩmʊ́ ibiyaalʊ́ Séla ɩbɩ́ɩ. Ilowú-dɛ sɩsɩ Séla ɩ́kɔkɔ́nɩ ɩsɩ́ nyazɩ ɩɖawaalɩnáa waazɩ́ nɛ́. Wɔɔdɔ́ alʊ́ ɩmʊ́ bɩlɛ́ nɛ́, ngɛ ɩlɛ́ waagbɩ́ɩ́rɩ ikpé ɩjaa-dɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Bɩjɔɔ́ɔ nɛ́, ngɛ Súwa wɛɛlɛ́ɛ Yudáa ɖɛɛlʊ́ waazɩ́. Sáátɩ wenkí lííya wɛɛdɛ́ nɛ́, ngɛ Yudáa na ɩɖɔndɩ Hiráa, Aduláam ńnɩ́ baagʊrʊ́ bakpa Tɩ́mɩna ivééni fʊ́m. ");
INSERT INTO kdh_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ngɛ beevééri Tamáarɩ sɩsɩ: «Bɛɛ nwɔ́nyɩ́nɩ́ wɛ́nɖɛɛ kʊ Tɩ́mɩna bɩlɛ́ sɩ ɩkávʊ ivééni.» ");
INSERT INTO kdh_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Sáátɩ wenkí ɩlɛ́ waanɩ́ɩ bɩlɛ́ nɛ́, ngɛ waalɩzɩ́ ɩdɛ́ɛ leelíti kpɩná ɩsɩ́ɩ, ɩcáa kɛkɛntɛ́ ifu, ibó ɩɖɛ́ɛ ɩgɔjɔɔ́ɔ Enayíim wɔnɔɔ́-jɔ́ Tɩ́mɩna nɩ́bááwʊ-daá. Wáńnáa ɩsɩ Séla waabɩ́ɩ ɩlá afobú, amá, bɔdɔkpɔ́ɔ ɩmʊ́ bafa yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yudáa wɔɔgɔ́nɩ gɛ waana yɩ kɛkɛntɛ́ fóo waazá-daá nɛ́, ɩjɔɔ́ɔ sɩsɩ alʊ́ kiliɖú gɛ. ");
INSERT INTO kdh_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ngɛ woogóduu ɩjɔ́ nɩ́bááwʊ-jɔ́ ńna ɩtɔ́ yɩ sɩsɩ: «Kʊrʊ́ ɖibó mána nya ɖɩfɩ́nɩ,» bɩka ɩdatɩlɩ́ sɩsɩ iwoolú nbɩlɛ́. Ńna gɛ Tamáarɩ woobúsi yɩ sɩsɩ: «A méédísi, we gɛ sɩ nva ma.» ");
INSERT INTO kdh_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ngɛ Yudáa sɩsɩ: «Mánváa nya mánámɩ́nɩ-daá nemíka kʊ́ɖʊmɔ́ɔ.» Ngɛ Tamáarɩ sɩsɩ: «Tɔ́ɔ, amá, sɩɩná ma nabʊ́rʊ naanɩ́.» ");
INSERT INTO kdh_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ngɛ wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «We gɛ sɩ mazɩɩná nya.» Ngɛ alʊ́ sɩsɩ: «Nyɛ́dɛ́ɛ kɩ́ɖaazɩkʊ́, kɩdɛ́ɛ nibiiká, bɩtasɩná nyɛ́dɛ́ɛ ɖooriká wenká nyɔ́ɖɔ́kɩná kɛ ɖɔ́ nɛ́.» Ngɛ wooguná yɛ icéle yɩ; bɩka ɩ́na yɩ bafɩ́nɩ. Baavɩ́nɩ nɛ́, fuwá waazʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Ngɛ alʊ́ ɩmʊ́ waagʊrʊ́ ikpé. Waadála nɛ́, waalɩzɩ́ kɛkɛntɛ́ ɩsɩ́ɩ, bɩka ɩbɩsɩná ɩdɛ́ɛ leelíti kpɩná isúu. ");
INSERT INTO kdh_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yudáa waadála nɛ́, ngɛ waalɩzɩ́ nemíka ikédíríná ɩɖɔndɩ Aduláam ńnɩ́ ɩsɩ ɩ́kɔ́ná kɛ icéle alʊ́ ɩmʊ́ na ɩkpɔ́ɔ kpɩná waazɩɩná yɩ yɛ nɛ́. Ɩɖɔndɩ waadála nɛ́, ɩdɔmɔɔná alʊ́ ɩmʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ngɛ wɔɔbɔ́ɔ́zɩ ńnaamʊ́ ńba sɩsɩ: «Alʊ́ kiliɖú wɔ́njɔwʊ́ʊ Enayíim nɩ́bááwʊ-jɔ́ cénjé nɛ́ ɩwɛ lé.» Ngɛ bɛlɛ́ boobúsi yɩ sɩsɩ: «Alʊ́ kiliɖú naárʊ fɛ́yɩ́ ɖɛ́dɛ́ɛ cé.» ");
INSERT INTO kdh_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ɖɔndʊ́ʊ waanɩ́ɩ bɩlɛ́ nɛ́, ngɛ ɩlɛ́ waagábɩsɩ ɩkɔ́nɩ ifééri Yudáa sɩsɩ: «Móóbó nɛ́, mádáná yɩ; hálɩ ɩráa wenbá bɔwɛ ńna nɛ́ beevééri ma sɩsɩ alʊ́ kiliɖú naárʊ fɛ́yɩ́ bɛḿ bɛdɛ́ɛ ńnaamʊ́.» ");
INSERT INTO kdh_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Ńna gɛ Yudáa sɩsɩ: «Ɖíyéléná yɩ kpɩná, bɔ́kɔkɔ́nɩ bamʊ́ŋ ɖáa. Aa tɔ́ɔ, máádánjelí nemíka nboná yɩ gɛ ńdákáná yɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Bɩjɔɔ́ɔ nɛ́ ní, sɩ bɩlá irodunáa noódoozo nɛ́, ngɛ naárʊ wɔɔgɔ́nɩ ifééri Yudáa sɩsɩ iwoolú Tamáarɩ waalá wásangarɩ́tɩ hálɩ ɩmʊ fuwá. Ngɛ Yudáa sɩsɩ: «Bóbo balɩzɩ́ yɩ bɔsɔ́ nimíni.» ");
INSERT INTO kdh_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Sáátɩ wenkí boobó bánlɩzɩ́ɩ yɩ nɛ́, ngɛ weedíri befééri ɩwɔ́nyɩ́nɩ́ sɩsɩ ɩ́bɛɛŋ kɩ́ɖaazɩkʊ́ kɩna na kɩdɛ́ɛ nibiiká na ɖooriká, weení ɩdɩɩná ɩmʊ́ ivuwá nɛ́ ɩdɩɩná kpɩná amʊ́. Bɩlɛ́ nɛ́, ɩ́caa ɩtɩlɩ́ bɩlɛ́ bɩdɛ́ɛ ɩrʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yudáa waana kpɩná nɛ́, waadɩlɩ́ yɛ, ngɛ sɩsɩ: «Alʊ́ ɩlɛ́ ɩdɛ́ɛ yɩsɩ́tɩ cɔɔ́ɔ sóńcí na mɛ́dɛ́ɛ ńdɩ. Káma, mebiyaalʊ́ Séla gɛ mɔrɔɔgbɔ́ɔ yɩ mava.» Sɩɩná bɩwɩ́rɛ, ɩ́na yɩ bodokúti boyóózi. ");
INSERT INTO kdh_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Bɩɩgɔ́nɩ bɩtála lʊrʊ́ʊ sáátɩ nɛ́, baana sɩsɩ sikawá nɔɔ́lɛ gɛ ɩdaá. ");
INSERT INTO kdh_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Lʊrʊ́ʊ wɩ́rɛ waadála sɩ ɩlʊ́rʊ nɛ́, sikawá-daá kʊ́ɖʊḿ waagálɩ́zɩ́ ɩnʊ́ʊ́nɩ. Ngɛ alʊ́ álʊ́rʊ́sɩ́rʊ́ weegbí ɩnʊ́ʊ́nɩ ɩcáa yɔ́ɔ́lɩ́ká kɩ́sɛɛmɔ́ɔ ɩtá sɩsɩ bú ɩmʊ́ gɛ kaɖaa ńnɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ngɛ bú ɩmʊ́ waabɩsɩná ɩnʊ́ʊ́nɩ. Waabɩsɩná bɩtɛ́ nɛ́, ngɛ igoobú wɔɔmɔ́ɔ ɩkálɩɩ. Ńna gɛ alʊ́ álʊ́rʊ́sɩ́rʊ́ wɔɔdɔ́tɔḿ sɩsɩ: «Bɩlɛ́ gɛ nyáádʊ́lʊ́ nlɩ́ɩ?» Ngɛ baava yɩ yɩ́ɖɛ sɩsɩ Perɛ́ɛsɩ, bugutoluú sɩsɩ Tʊlʊ́ nlɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Bʊwɔ́rɔ́ nɛ́, ngɛ bú lí ńnɩ́ waagálɩɩ, bɩka yɔ́ɔ́lɩ́ká kɩ́sɛɛmɔ́ɔ kadamáa na ɩnʊ́ʊ́nɩ. Ngɛ baava ɩlɛ́ yɩ́ɖɛ sɩsɩ Zeráa, bugutoluú sɩsɩ wɩ́sɩ kalɩɩ́ sɛɛmɩ́nɩ. ");
INSERT INTO kdh_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Asʊmáyɩ́la-dɛ́ɛ ńba waadalaná Ísifu Mɩ́sɩra nɛ́, Mɩ́sɩra ńnɩ́ Pɔtɩfáarɩ waamʊ ná yɩ. Pɔtɩfáarɩ ɩmʊ́ ɩgɛ́ɛ Mɩ́sɩra wúro Farawʊ́na-dɛ́ɛ fereɖáa-dɛ́ɛ kʊ́bɔnɩ́ gɛ. ");
INSERT INTO kdh_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Ɖádʊ́ʊ Ɩsɔ́ɔ wɛ Ísifu-jɔ́; ɩgʊ́bɔnɩ́ Mɩ́sɩra ńnɩ́-dɛ́ɛ ɖaána-daá gɛ ɩwɛ wánlám tɩmɛ́rɛ. ");
INSERT INTO kdh_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ɩgʊ́bɔnɩ́ ɩmʊ́ woogúti ɩbɛ́ɛ nɛ́, waana sɩsɩ Ɖádʊ́ʊ Ɩsɔ́ɔ sɩ́ŋɛ́ɛ ɩwɔ́rɔ́; káma, wenbí bɩrɩ́ŋa wánlám nɛ́, Ɩsɔ́ɔ wénÿelíi gɛ bínboɖé bɩɩzá-daá. ");
INSERT INTO kdh_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Ísifu-dɛ́ɛ tɔ́m waabá bɩlá yɩ kazɔ́ɔ; ngɛ wɔɔgbɔ́ɔ yɩ ɩbɩsɩná ɩdɩmɛlanɖʊ́. Wenbí bɩrɩ́ŋa ɩwɛná nɛ́, na ɩɖaána rɩ́ŋa-dɛ́ɛ yíko gɛ wɔɔgbɔ́ɔ ɩɖʊ wɛndɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ɩgʊ́bɔnɩ́ kpɔwʊ́ʊ yɩ ɩɖʊ tɩmɛ́rɛ ɖɩḿ ɖɩdaá, Ɖádʊ́ʊ Ɩsɔ́ɔ weeyéle wenbí bɩrɩ́ŋa bʊwɛ wɛndɛ́ nɛ́ bibó bɩɩzá-daá. Mɩ́sɩra ńnɩ́-dɛ́ɛ ɖaána-dɛ́ɛ báa wenbí, na ɩdɛ́ɛ fɔɔ́-daá, bɩrɩ́ŋa biibó bɩɩzá-daá gɛ Ísifu-rɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Biiyele ná ɩgʊ́bɔnɩ́ ɩkpɔ́ɔ ɩdɛ́ɛ báa wenbí ɩɖʊ wɛndɛ́. Wenbí bɩɩga bɩ ɩlɛ́ sɩ ɩlá nɛ́ gɛ kíɖíím ɖíi. Ísifu cɔɔ́ɔ bɩlɛ́ nɛ́, ɩbɩɩzɩ́nɩ na waazá-daá kazɔ́ɔ na nabʊ́rʊ bɩ́dɛ́ngɛɛzɩ. ");
INSERT INTO kdh_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ngɛ ɩdɛ́ɛ kazɔ́ɔ waazʊ́ʊ ɩgʊ́bɔnɩ́ ɖɛɛlʊ́. Wɩ́rɛ nɛ́, ngɛ alʊ́ ɩmʊ́ ɩsɩ: «Ísifu, kɔnɩ mána nya ɖɩfɩ́nɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ngɛ Ísifu sɩsɩ: «Kéyi, bɩ́dánlaḿ bɩlɛ́. Mɛ́dɛ́ɛ kʊ́bɔnɩ́ waava ma toovonúm-rɔ gɛ wɔɔgbɔ́ɔ ɩdɛ́ɛ bɩrɩ́ŋa ɩɖʊ mɛ́ńdɛ́. Ɩvɛ́yɩ́na neɖére lám ɖaána-daá cé. ");
INSERT INTO kdh_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ɩdɛ́ɛ ɖaána rɩ́ŋa-daá cé, naárʊ fɛ́yɩ́ waagɩ́lɩ ma nɛ́, nyɔ́ɔ́ ɩɖɛɛlʊ́ nyériké gɛ weegiziná ma. Bɩlɛ́ nɛ́, bɩ́nlám nŋɩ́nɩ́ na malá ziná mayɩsɩná Ɩsɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Amá, alʊ́ ɩmʊ́ ideyéle Ísifu caarɩ́; báa ngbeére, bɩlɛ́ gɛ ɩbamáa yɩ caarɩ́. Na bɩrɩ́ŋa bɩlɛ́ Ísifu weegízi. ");
INSERT INTO kdh_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Wɩ́rɛ bɩjɔɔ́ɔ nɛ́, ngɛ Ísifu waazʊ́ʊ ɖaḿ-daá sɩ ɩbáázɩ ɩdɩmɛ́rɛ. Bɩdɛ́ɛ sáátɩ, tɩmɛlanɖáa baaganáa fɛ́yɩ́ ńnaamʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Waagázʊʊ gɛ alʊ́ ceení waagʊ́sɩ ɩna yɩ nɛ́, ngɛ wɛɛgbɛdɩ́ ibó ikpí idóko wánnarɩ́ɩ yɩ sɩsɩ: «Kɔnɩ ɖibó mána nya ɖɩfɩ́nɩ!» Sɩ bɩkɩ́lɩ nɛ́ gɛ Ísifu wooguná tóko ɩtalɩná yɩ bɩka ise ɩlɩ́ɩ asʊ. ");
INSERT INTO kdh_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Sáátɩ wenkí alʊ́ ceení waana sɩsɩ Ísifu wooguná idóko ɩtalɩná yɩ ise ɩlɩ́ɩ nɛ́, ");
INSERT INTO kdh_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ngɛ waamá kebiká wánÿaá tɩmɛlanɖáa baaganáa sɩsɩ: «Cíbeyi, ɩgɔ́nɩ yoo, ɩgɔ́nɩ ɩbɛ́ɛ bɔɔgɔná Éburu ńnɩ́ wɛ́ngbɛɛnáa ɖáa nɛ́; waagázʊʊ mɔ́jɔ́ gɛ sɩsɩ mána yɩ ɖɩfɩ́nɩ. Ngɛ máámá kebiká. ");
INSERT INTO kdh_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Sáátɩ wenkí waanɩ́ɩ máámá kebiká mogóo mánÿaá nɛ́, ngɛ waagʊrʊ́ ise ɩɖɛ́ɛ ɩcáŋ iyelená ma idóko.» ");
INSERT INTO kdh_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Bɩɩdɛ́ nɛ́ ní, ngɛ alʊ́ ceení wɔɔgbɔ́ɔ tóko kɩḿ ɩsɩ́ɩ ɩjɔ́ hálɩ kʊ́bɔnɩ́ ɩkɔ́nɩ. ");
INSERT INTO kdh_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ɩlɛ́ waadála nɛ́, ngɛ wɔɔgbɔ́ɔ wénveerím yɩ sɩsɩ: «Bɛɛ́ɛ! Éburu afobú yoḿ weení nyɔ́ɔ́gɔ́ná ɖáa yɩ nɛ́, waagázʊʊ mɔ́wɔ́rɔ́ gɛ sɩ ɩfɩnɩná ma. ");
INSERT INTO kdh_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Sáátɩ wenkí waanɩ́ɩ máámá kebiká nɛ́, ngɛ waagʊrʊ́ ise ɩlɩ́ɩ iyéle idóko mɔ́jɔ́.» ");
INSERT INTO kdh_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Sáátɩ wenkí Ísifu-dɛ́ɛ kʊ́bɔnɩ́ waanɩ́ɩ tɔ́m tɩna nɛ́, ngɛ wɛɛyɛ́ɛ baaná. ");
INSERT INTO kdh_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ngɛ weeyéle bakpa Ísifu bɔtɔ sáráka. Sɩ bɔtɔ yɩ nɛ́, sáráka wenká kadaá bɔ́ndɔ́rɔ́dɔ́ɔ wúro-dɛ́ɛ sáráka-dɩnáa nɛ́ kadaá gɛ bɔɔdɔ Ísifu. ");
INSERT INTO kdh_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Na bɩrɩ́ŋa, Ɖádʊ́ʊ Ɩsɔ́ɔ sɩ́ŋɛ́ɛ ɩwɔ́rɔ́, ɩɖɔ́kɩná yɩ bɩjaarɛ́ɛ. Ɩsɔ́ɔ-dɛ́ɛ ɩzɩ́ŋɛ́ɛ ɩwɔ́rɔ́ weeyéle Ísifu ɩmʊ́ ɩdɛ́ɛ tɔ́m ɩlá sáráka fereɖú kazɔ́ɔ; ");
INSERT INTO kdh_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","ngɛ ɩlɛ́ wɔɔgbɔ́ɔ sáráka-dɩnáa rɩ́ŋa kpátáá-dɛ́ɛ báa wenbí ɩɖʊ wɛndɛ́ wɛ́nbɛɛŋ́ baaganáa rɩ́ŋa-rɔ. Ɩmʊ́ Ísifu wɛ́nbɛɛŋ kʊ barɩ́ŋa badɩmɛ́ wónboɖé wenbí nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Bɩɩga nɛ́, sáráka fereɖú tɛ́ndɛbɛɛŋ tɩmɛ́ weená weejéle yɩ yɛ nɛ́; káma waana sɩsɩ Ɖádʊ́ʊ Ɩsɔ́ɔ sɩ́ŋɛ́ɛ ɩwɔ́rɔ́ wónboɖí yɩ báa ngbetíi-daá. ");
INSERT INTO kdh_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Bʊwɔ́rɔ́ nɛ́, Mɩ́sɩra wúro Farawʊ́na-dɛ́ɛ tɩmɛlanɖáa kʊ́bɔnáa nɔɔ́lɛ waayɩsɩná yɩ. Bɛlɛ́ ɩmʊ́ bɛgɛ́ɛ na wenbá bánɖʊ́ʊ wúro sʊlʊ́m wɔ́nnyɔɔ́ nɛ́ bɛdɛ́ɛ kʊ́bɔnɩ́, na wenbá bánlám yɩ kpɔ́nɔ́ nɛ́ bɛdɛ́ɛ kʊ́bɔnɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Baalá wenbí nɛ́, weeyele ná wúro ɩbá ɩyɛ́ɛ baaná, ");
INSERT INTO kdh_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","iyéle bakpa wɛ bɔtɔ fereɖáa-dɛ́ɛ kʊ́bɔnɩ́-dɛ́ɛ sáráka-daá lé bɔɔdɔ Ísifu nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ngɛ kʊ́bɔnɩ́ ɩmʊ́ wɔɔdɔ́ bɔkpɔ́ɔ wɛ baɖʊná Ísifu bɩka wɔ́nvɔɔzɩ́ wɛ. Ngɛ barɩ́ŋa bɔɔjɔ́ɔ sáráka kɛḿ kadaá balá wɛ́ náálɛ. ");
INSERT INTO kdh_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Wɩ́rɛ nuvoowú bɩjɔɔ́ɔ nɛ́, ngɛ Mɩ́sɩra wúro-dɛ́ɛ sʊlʊm‑ɖʊʊrʊ́ na ɩdɛ́ɛ kpɔ́nɔ́ lanɖʊ́ bɔdɔ́ɔ sáráka nɛ́ booɖóózi; báa awéní na ɩdɛ́ɛ ɖoozire. Ngɛ ɖoozá amʊ́, báa wenɖé na ɖugutoluú. ");
INSERT INTO kdh_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Kiivé tɛ́ɛrɛ́ Ísifu wɔɔgɔ́nɩ ɩna wɛ nɛ́, bɔjɔɔ́ɔ ɩzá nyɩ́nŋɩrɛ-daá. ");
INSERT INTO kdh_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ngɛ wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «Bɩyáásɩ́ gɛ mɩ́ɩ́zá nyɩ́ŋɛ́ɛ sinje bɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ngɛ boobúsi yɩ sɩsɩ: «Ɖoozá gɛ ɖóóɖóózi ɖɛ́lɛ́ɛ́nɩ́ báa weení na ɩdɛ́ɛ ɖoozire; ngʊ́ naárʊ fɛ́yɩ́ cé sɩ ɩlɩzɩ́ ɖáa agutoluú.» Ngɛ Ísifu sɩsɩ: «Tɔ́ɔ, awéní wánlɩzɩ́ɩ kʊ ɖoozá kutoluú bɩdɛkɛ́ɛ Ɩsɔ́ɔ. Bɩlɛ́ nɛ́, ɩdɩ́ yɛ ifééri ma yeeé.» ");
INSERT INTO kdh_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ngɛ Wúro-dɛ́ɛ sʊlʊm-ɖʊʊráa-dɛ́ɛ kʊ́bɔnɩ́ weevééri Ísifu ɩdɛ́ɛ ɖoozire. Sɩsɩ: «Mɛ́dɛ́ɛ ɖoozire nɖɔ́: mááná gɛ sɩsɩ víinyi tiyɔ́ɔ bánlanáa kibíya sʊlʊ́m nɛ́ sɩ́ŋɛ́ɛ máázá-daá, ");
INSERT INTO kdh_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","kɔwɛná wʊláázɩ nasúdoozo. Ngɛ kaajáŋ kɛtɛ, kalá fɛ́ɛ́dɩ́tɩ, kaɖʊ bíya, bɛsɛ́ɛ nɔɔ́ kʊ́ɖʊḿ. ");
INSERT INTO kdh_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Mɔ́ɔ́ mɔ́ɖɔ́kɩná wúro-dɛ́ɛ kɔ́ɔ́pɩ. Ngɛ mɔ́ɔ́gɔ́rɩ́ tiyɔ́ɔ-bíya bɛḿ manyáázɩ maɖʊ kɔ́ɔ́pɩ-daá mejéle yɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Ńna gɛ Ísifu sɩsɩ: «Nyóɖoozire kutoluú nɖɔ́: Nyááná tiyɔ́ɔ kɛḿ kɛdɛ́ɛ wʊláázɩ nasúdoozo sɩna, wɛ́ náádoozo nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Bɩ́nwɩlɩ́ɩ sɩsɩ sinje bɩɩga wɛ́ náádoozo, wúro wángagʊsɩ́ nyɔ́dɔ́m, wɔ́ngbɔwʊ́ʊ nya ɩbɩsɩná nyádɩmɛ́rɛ kɩ́bɩńɖɛ-daá. Nyánbaazɩ́ yɩ ɩdɛ́ɛ sʊlʊ́m celíi wɔ́nnyɔɔ́ ńŋɩnáa nyánvʊnlám nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Amá, a bɩɩlá bɩlɛ́, ngɛ nyɛ́dɛ́ɛ báa wenbí wɔɔnyɔ́ɔ́zɩ, máávɩ́nɩ nya nkɔsɔɔná mɔ́rɔ́. Nɩɩ mágʊnyɔḿ ndɔ́ɔ́zɩ nŋmátɩ mɔ́dɔ́m Farawʊ́na-jɔ́ hálɩ bɩlá balɩzɩ́ ma sáráka kana kadaá. ");
INSERT INTO kdh_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Mɔ́jɔɔ́ɔ ɖɔ́ nɛ́, na ɖóni gɛ baagágbá ma Éburu laadɔ́ɔ-daá bɔkɔná cé; bɩka ɖʊɖɔ máádála cé nɛ́, mádábá malá nabʊ́rʊ bínÿelíi bɔtɔ ma sáráka nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Wúro-dɛ́ɛ kpɔ́nɔ́ lanɖáa-dɛ́ɛ kʊ́bɔnɩ́ waana sɩsɩ wenbí Ísifu waalɩzɩ́ sʊlʊm-ɖʊʊráa-dɛ́ɛ kʊ́bɔnɩ́-dɛ́ɛ ɖoozire kutoluú nɛ́ waalá kazɔ́ɔ nɛ́, ngɛ ɩmʊ́ ɖʊɖɔ sɩsɩ: «Mɔ́ɔ́ ɖʊɖɔ móóɖóózi gɛ sɩsɩ mázʊ́wáána kpɔ́nɔ́ ɖɔkɩ́nɩ natúdoozo; ");
INSERT INTO kdh_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ɖɔkʊ́ ɩsɔ́ɔ́dáá ńgɩ-daá nɛ́, wúro-dɛ́ɛ kíɖíídi kpɔ́nɔ́-dɩnáa wánlám nɛ́ wɛ ná kɩdaá. Amá, siḿsi wɔ́ngɔnɩ́ sínɖíi tɩ mágʊjʊʊ́-daá.» ");
INSERT INTO kdh_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Ngɛ Ísifu sɩsɩ: «Ménveerím nya nyóɖoozire kutoluú. Nyááná ɖɔkɩ́nɩ natúdoozo tɩḿ? Tɩgɛ́ɛ wɛ́ náádoozo gɛ. Bɩlɛ́ nɛ́, bɩ́nwɩlɩ́ɩ sɩsɩ ");
INSERT INTO kdh_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","sinje bɩɩga wɛ́ náádoozo, Farawʊ́na wɛ́njɛ́m nyágʊjʊʊ́, bosúu nya ɖɛ́nɩ-rɔ bʊwɔ́rɔ́ nɛ́, siḿsi ɩkɔ́nɩ siɖi nyɔ́zɔ́m.» ");
INSERT INTO kdh_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Bɩɩlá wɛ́ náádoozo nɛ́, wúro sɩ iɖi ɩdɛ́ɛ lʊrʊ́ʊ wɩ́rɛ tɔɔzɩ́-dɛ́ɛ jíńgáárɩ́. Ngɛ waayáa ɩdɛ́ɛ tɩmɛlanɖáa rɩ́ŋa ɖíi. Baazá-daá gɛ weeyéle bakʊ́sɩ ɩdɛ́ɛ sʊlʊm-ɖʊʊráa-dɛ́ɛ kʊ́bɔnɩ́-dɛ́ɛ tɔ́m na kpɔ́nɔ́ lanɖáa-dɛ́ɛ kʊ́bɔnɩ́-dɛ́ɛ tɔ́m. ");
INSERT INTO kdh_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ngɛ waabɩsɩná sʊlʊ́m-dʊ́ʊ ɩdɩmɛ́rɛ kɩ́bɩńɖɛ-daá. ");
INSERT INTO kdh_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Bɩɩga lí ńnɩ́ nɛ́, weeyéle gɛ bɛcɛ́ ɩgʊjʊʊ́ bɔkpɔ́ɔ yɩ bosúsi. Wenbí Ísifu weevééri wɛ nɛ́, bɩɩlá bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Amá, sʊlʊm-ɖʊʊráa-dɛ́ɛ kʊ́bɔnɩ́ waalɩ́ɩ sáráka-daá nɛ́, ngɛ wɔɔzɔɔná Ísifu-rɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Bɩɩlá bɩ́ɩ́zɩ nasɩ́lɛ nɛ́, ngɛ Farawʊ́na tɩtɩŋa wooɖóózi ɖoozire neɖére. Wooɖóózi sɩsɩ ɩmʊ́ ɩzɩ́ŋɛ́ɛ bɛdɛ́ɛ buwá kʊ́bɔńga-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Ngɛ waana náánɩ fɩ́ya ńdɩ tɩɩbá tikíi nɛ́ lʊbɛ waagálɩɩ lɩ́m-daá tɩkɔ́nɩ kpaam-rɔ tɩ́ndɔwʊ́ʊ nyɩ́ɩ́dɩ. ");
INSERT INTO kdh_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Bɩɩgɔ́nɩ bɩtásɩ cʊ́kɔ nɛ́, ngɛ náánɩ bɔɔrásɩ lʊbɛ tɩɩbá tɩwɩláa nɛ́ ɖʊɖɔ waagálɩɩ lɩ́m bɩḿ bɩdaá tɩkɔ́nɩ tɩsɩ́ŋ tɩɩganáa-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ngɛ tɩɩjáŋ tɩsɛlɩ́ náánɩ kíkiidíti lʊbɛ tɩna tɩtɔ́ɔ. Waajáŋ iɖóózi bɩlɛ́ nɛ́, ngɛ wɛɛnyɛ́ ifé. ");
INSERT INTO kdh_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Bʊwɔ́rɔ́ nɛ́, ngɛ waabáázɩ ɖóm. Ngɛ woodóɖoozi sɩsɩ mɩ́lɛ kʊ́ɖʊńɖɛ waaɖʊ mɩlɩzɛnɖɩ́nɩ fɩ́ya ńdɩ tɩjɔɔ́ɔ kazɔ́ɔ nɛ́ lʊbɛ nɔɔ́ kʊ́ɖʊḿ. ");
INSERT INTO kdh_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ngɛ neɖére ɖʊɖɔ-rɔɔzɩ́ nɛ́, mɩlɩzɛnɖɩ́nɩ lʊbɛ kpáfʊ́ʊ́rɩ́nɩ tɩwɩláa nɛ́ gɛ ɖɩlɛ́ ɖɩɩɖʊ nɔɔ́ kʊ́ɖʊḿ; wɩlɩ́ŋa-dɛ́ɛ fefelimá waawɩlɩsɩ ná yɛ. ");
INSERT INTO kdh_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ngɛ mɩlɩzɛnɖɩ́nɩ kpáfʊ́ʊ́rɩ́nɩ tɩna tiilí tɩɩganáa fɩ́ya ńdɩ. Bɩɩjáŋ bɩlá bɩlɛ́ nɛ́, ngɛ wúro weevé, ngɛ waana sɩsɩ ɩwɛ wónɖoozí gɛ. ");
INSERT INTO kdh_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Kiivé nɛ́, ɖoozá amʊ́ aagʊ́sɩ ɩlaakáarɩ, ngɛ waayáa Mɩ́sɩra rɩ́ŋa-dɛ́ɛ síhíri-dɩnáa na kɩdɛ́ɛ tɩlɩ́ɖa. Bɛlɛ́ bɔɔgɔ́nɩ nɛ́, ngɛ wɔɔgbɔ́ɔ yɛ bɩlɛ́ ɩtɩ́ ifééri wɛ. Amá, badabɩ́ɩ́zɩ balɩzɩ́ yɩ ɖoozá amʊ́ agutoluú. ");
INSERT INTO kdh_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ńna gɛ sʊlʊm-ɖʊʊráa-dɛ́ɛ kʊ́bɔnɩ́ wɔɔdɔ́ wúro sɩsɩ: «Kʊ́bɔnɩ́, sinje mɔ́zɔɔlɛ́ɛ madɩ́ nya taalɩ́wá natɩ́rɩ máálá bɩɖɛ́ɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Wɩ́rɛ, nyɛ́ɛ́yɛ́ɛ baaná ndɔ́ bɔkpɔ́ɔ mána nyɛ́dɛ́ɛ kpɔ́nɔ́ lanɖáa-dɛ́ɛ kʊ́bɔnɩ́ bɔtɔ fereɖáa-dɛ́ɛ kʊ́bɔnɩ́-dɛ́ɛ sáráka-daá. ");
INSERT INTO kdh_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ɖɔ́wɛ ńnaamʊ́ gɛ wɩ́rɛ nuvoowú kʊ́ɖʊmʊ́ʊ-daá, ɖɛ́lɛ́ɛ́nɩ́ ɖóóɖóózi. Ngɛ báa awéní-dɛ́ɛ ɖoozire na ɖugutoluú. ");
INSERT INTO kdh_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ɖɔ́wɛ sáráka-daá ńna nɛ́, ɖána bú afobú Éburu ńnɩ́ naárʊ gɛ; ɩgɛ́ɛ fereɖáa-dɛ́ɛ kʊ́bɔnɩ́-dɛ́ɛ yoḿ gɛ. Ngɛ ɖɔ́ɔ́gbɔ́ɔ ɖɛ́dɛ́ɛ ɖoozá ɖɩtɩ́ ɖifééri yɩ. Ngɛ waalɩzɩ́ ɖáa báa weení-dɛ́ɛ ńɖɛ kutoluú. ");
INSERT INTO kdh_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Wenbí waaŋmátɩ ifééri ɖáa nɛ́, bɩlɛ́ gɛ bɩɩlá nɔ́ɔ́. Waavʊ́ńveeri ma sɩsɩ bánbɩsɩnáa ma mádɩmɛ́rɛ-daá; bɩlɛ́ bɩɩla ná ɖɔ́. Wenbí ɖʊɖɔ weedéfeeri lí ńnɩ́ nɛ́, bɩlɛ́ bɩɩla ná, bosúsi yɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Wúro waanɩ́ɩ bɩlɛ́ nɛ́, ngɛ weedíri sɩsɩ bákalɩzɩ́ Ísifu sáráka-daá bɔkɔná. Ńna‑ńna gɛ baagálɩ́zɩ́ Ísifu bafʊ́ yɩ, bɛkɛ́ɛ yɩ kpɩná. Bɩɩdɛ́ nɛ́, ngɛ wɔɔgɔ́nɩ ɩsɩ́ŋ wúro ɩzá-daá. ");
INSERT INTO kdh_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ńna gɛ wúro weevééri Ísifu sɩsɩ: «Ɖoozire neɖére gɛ móóɖóózi; amá, naárʊ tabɩ́ɩ́zɩ ifééri ma ɖugutoluú. Ngɛ beevééri ma sɩsɩ báa ɖoozire wenɖé gɛ beevééri nya, nyɔ́ɔ́ nyánbɩɩzɩ́ nlɩzɩ́ ɖugutoluú.» ");
INSERT INTO kdh_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Ngɛ Ísifu sɩsɩ: «Aayɩ́, bɩdɛkɛ́ɛ mɔ́ɔ́, Ɩsɔ́ɔ wánbɩɩzɩ kʊ ɩlɩzɩ́ nya nyóɖoozire kutoluú bɩsáa.» ");
INSERT INTO kdh_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ngɛ wúro waadɩ́ ifééri yɩ sɩsɩ: «Móóɖóózi sɩsɩ mázɩ́ŋɛ́ɛ ɖɛ́dɛ́ɛ buwá kʊ́bɔńga-jɔ́ gɛ ");
INSERT INTO kdh_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","mááná náánɩ fɩ́ya ńdɩ tɩɩbá tikíi nɛ́ lʊbɛ waagálɩɩ buwá kɛḿ kadaá tɩ́ndɔwʊ́ʊ nyɩ́ɩ́dɩ kpaam-rɔ. ");
INSERT INTO kdh_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Bɩɩdásɩ nɛ́, náánɩ natɩ́rɩ lʊbɛ ɖʊɖɔ waagálɩɩ buwá kɛḿ kadaá tɩkɔ́nɩ tɩsɩ́ŋ tɩɩganáa-jɔ́. Náánɩ tɩḿ, tɩɩbá gɛ tɩjɔɔ́ɔ bɔɔrásɩ, bɩka tɩjɔɔ́ɔ mʊwá; mádanáá ta náánɩ ɩŋmɩ́ɩ bɩlɛ́ Mɩ́sɩra laadɔ́ɔ rɩ́ŋa-daá. ");
INSERT INTO kdh_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ngɛ náánɩ tɩḿ tɩɩzɛlɩ́ náánɩ fɩ́ya ńdɩ tɩɩɖáa kalɩɩ́ nɛ́ tɩtɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Na bɩrɩ́ŋa tɩɩdɔ́ɔ náánɩ fɩ́ya ńdɩ tɩḿ nɛ́, bɩdanvɛ́yɩ́ sɩ tɩɩdɔ́ɔ nabʊ́rʊ, bɩlɛ́ gɛ tɩdɛɛzɩwɩláa. Bɩɩjáŋ bɩtɛ́ nɛ́, ngɛ mɛ́ɛ́nyɛ́ mevé. ");
INSERT INTO kdh_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Bɩjɔɔ́ɔ nɛ́, ngɛ máádábaazɩ ɖóm. Ngɛ móódóɖoozi ɖʊɖɔ sɩsɩ mááná mɩ́lɛ waaɖʊ mɩlɩzɛnɖɩ́nɩ lʊbɛ fɩ́ya ńdɩ tɩjɔɔ́ɔ kazɔ́ɔ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ngɛ neɖére ɖʊɖɔ waaɖʊ mɩlɩzɛnɖɩ́nɩ kpáfʊ́ʊ́rɩ́nɩ fefelimá waawɩ́lɩsɩ yɛ nɛ́ lʊbɛ. ");
INSERT INTO kdh_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ngɛ mɩlɩzɛnɖɩ́nɩ kpáfʊ́ʊ́rɩ́nɩ tɩḿ tɩɩzɛlɩ́ fɩ́ya ńdɩ tɩɩganáa tɩcáŋ tilí. Mɛ́dɛ́ɛ ɖoozire sɩɩlɛ ńɖɛ nbɩlɛ́. Ɖoozá ana ɖɔ́ móóɖóózi yɛ nɛ́, máńɖɩ́ḿ yɛ mevééri mɛ́dɛ́ɛ síhíri-dɩnáa, amá, badaá naárʊ tabɩ́ɩ́zɩ ifééri ma agutoluú.» ");
INSERT INTO kdh_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ngɛ Ísifu woobúsi sɩsɩ: «Wúro, nyɛ́dɛ́ɛ ɖoozá ana alɛ́ɛ́nɩ́, agutoluú kɛgɛ́ɛ kʊ́ɖʊńbɩ gɛ. Ɩsɔ́ɔ waawɩ́lɩ nya wenbí sɩ ɩlá bɩ nɛ́ gɛ. ");
INSERT INTO kdh_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Nyááná náánɩ fɩ́ya ńdɩ lʊbɛ tɩna na mɩlɩzɛnɖɩ́nɩ fɩ́ya ńdɩ lʊbɛ tɩna? Bɩgɛ́ɛ kʊ́ɖʊńbɩ gɛ. Bɩ́ɩ́zɩ lʊbɛ nbɩlɛ́; bɩlɛ́ nɛ́, ɖoozire kʊ́ɖʊńɖɛ gɛ. ");
INSERT INTO kdh_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Bɩɩga náánɩ lʊbɛ bɔɔrásɩ tɩɩganáa na mɩlɩzɛnɖɩ́nɩ fefelimá waawɩ́lɩsɩ yɛ bɩlɛ́ nɛ́, bɩ́ɩ́zɩ lʊbɛ ɖʊɖɔ nbɩlɛ́; amá, bɩlɛ́ bɩdɛ́ɛ bɩ́ɩ́zɩ kɛ́ɛ nyɔɔ́sɩ bɩ́ɩ́zɩ gɛ. ");
INSERT INTO kdh_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Bɩlɛ́ bʊrɔɔzɩ́ nɛ́, kʊ́bɔnɩ́, tɩnáábɩ́lɛ́ méévééri nya sɩsɩ Ɩsɔ́ɔ wánwɩlɩ́ɩ nya wenbí sɩ ɩlá nɛ́ gɛ. ");
INSERT INTO kdh_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Nyááná bɩ́ɩ́zɩ lʊbɛ kaɖaa ńzɩ sɩgɛrɛŋɛ ɖɔ́ nɛ́, fɔɔnɔ́ɔ-dɛ́ɛ bɩ́ɩ́zɩ nbɩlɛ́ Mɩ́sɩra laadɔ́ɔ rɩ́ŋa-daá. ");
INSERT INTO kdh_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Amá, fɔɔnɔ́ɔ-dɛ́ɛ bɩ́ɩ́zɩ lʊbɛ sɩḿ sɩwɔ́rɔ́, nyɔɔ́sɩ kʊ́bɔńzɩ wánzʊʊ́ tɛ́ɛ́dɩ bɩ́ɩ́zɩ lʊbɛ. Nyɔɔ́sɩ-dɛ́ɛ bɩ́ɩ́zɩ sɩḿ sínÿelíi ɩsɔ́ɔ mɩ́dɛ́ɛ fɔɔnɔ́ɔ kɛlɛ́. Nyɔɔ́sɩ sɩḿ sínnuudí tɛ́ɛ́dɩ. ");
INSERT INTO kdh_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Sɩ́nbá sɩcáárɩ hálɩ ɩráa ɩsɔɔná sɩsɩ kɛtɛngɛrɛ fɔɔnɔ́ɔ waazɩ́ŋ kalá. ");
INSERT INTO kdh_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Nyɛ́dɛ́ɛ nyóóɖóózi nabʊ́lɛ bɩlɩ́ɩ ɖamá wánwɩlɩ́ɩ sɩsɩ wenbí Ɩsɔ́ɔ waazɩ́ɩ sɩ ɩlá nɛ́, bídénleeri wɛ́ndɛ́m ɩlá bɩ. ");
INSERT INTO kdh_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Bɩlɛ́ nɛ́, kʊ́bɔnɩ́, kpɛdɩ́ njáa ɩrʊ́ áséńsí-dʊ́ʊ ngbɔ́ɔ bɩna bɩdɩmɛ́rɛ nɖʊ wɛndɛ́; ɩbɩ́ɩ́zɩ ɩwɛná yíko Mɩ́sɩra laadɔ́ɔ rɩ́ŋa-rɔ, ");
INSERT INTO kdh_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","na nlɩzɩ́ sɩbaabɩwá ɖʊɖɔ; bɛlɛ́ badɩmɛ́rɛ gɛ fɔɔnɔ́ɔ sáátɩ, bekíli befééri Mɩ́sɩra ńba batára báa awéní-dɛ́ɛ kíɖíídi nabʊ́nʊ́wá, bokúu kʊ́ɖʊńbɩ, ");
INSERT INTO kdh_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","bamáárɩ kíɖíídi fɔɔnɔ́ɔ sáátɩ. Bakáa mɩlá ɖamɩ́nɩ-daá tɛ́ɛ́dɩ kʊ́bɔńdɩ-daá basɩ́ɩ azíya, bɩka bɩrɩ́ŋa bʊwɛ nyɛ́ńdɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","A baalá bɩlɛ́, Mɩ́sɩra wooyuú kíɖíídi baɖáŋ nyɔɔ́sɩ bɩ́ɩ́zɩ lʊbɛ sɩgɛrɛŋɛ nɛ́; bɩka nyɔɔ́sɩ tándasʊʊ tɛ́ɛ́dɩ bɩkʊ ɩráa rɩ́ŋa.» ");
INSERT INTO kdh_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Wúro na ɩdɛ́ɛ sɩbaabɩwá baanɩ́ɩ Ísifu-dɛ́ɛ lomaazɛ́ ana nɛ́, aabá alá wɛ kazɔ́ɔ páá. ");
INSERT INTO kdh_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ńna gɛ wúro wɔɔdɔ́ wɛ sɩsɩ: «Mɩ́ɩ́ná ɩrʊ́ ceení, Ɩsɔ́ɔ-dɛ́ɛ Kezeŋa-dɛ́ɛ ɖóni wɛ ɩrɔ. Lé gɛ sɩ ɖukúti ɖɩkáná ɩrʊ́ ceení taká.» ");
INSERT INTO kdh_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ngɛ wúro weevééri Ísifu sɩsɩ: «Wenbí ńŋɩnáa Ɩsɔ́ɔ waabɩ́ɩ́zɩ ifulúsi nyáázá ndɩlɩ́ tɩna tɩrɩ́ŋa ɖɔ́ nɛ́, ɖódókúti ɖɩna áséńsí-dʊ́ʊ naárʊ ɩwɛná tɩlɩ́ɩ ɩtála nya. ");
INSERT INTO kdh_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Bɩlɛ́ nɛ́, ménjelíi nya tɛ́ɛ́dɩ-dɛ́ɛ kʊ́bɔńdɩ. Mɛ́dɛ́ɛ Mɩ́sɩra laadɔ́ɔ ɩráa rɩ́ŋa sɩ banɩ́ɩ gɛ bofu nyɔ́nɔ́ɔ́. Mɛ́dɛ́ɛ kowuro-gbelé gɛ sɩ magɩlɩ ná nya.» ");
INSERT INTO kdh_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Farawʊ́na wɔɔdɔ́ Ísifu sɩsɩ: «Máává nya yíko Mɩ́sɩra laadɔ́ɔ rɩ́ŋa-rɔɔzɩ́.» ");
INSERT INTO kdh_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ngɛ waalɩzɩ́ ɩdɛ́ɛ kowúrátɩ ketéreniiká ɩnʊ́ʊ́nɩ-daá, ɩkpɔ́ɔ ɩɖʊ Ísifu niiká. Ngɛ weejéle yɩ kowuro-dóko isúu; ɩkpɔ́ɔ siká kejiya ɩɖʊ ilowú-dɛ. ");
INSERT INTO kdh_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Bɩɩdɛ́ nɛ́, ngɛ wɔɔdɔ́ ɩkpa awéńja túúruú wenkí kuvóo ɩmʊ́ wúro-dɛ́ɛ ńgɩ nɛ́, bɩka ɩráa tɛ́ɛ yɩ nɩ́bááwʊ bóngoó sɩsɩ: «Izóm adɛ, izóm adɛ.» Tɔ́ɔ, bɩlɛ́ gɛ wúro waazɩ́ɩ yɩ kʊ́bɔńdɩ Mɩ́sɩra laadɔ́ɔ rɩ́ŋa-rɔ. ");
INSERT INTO kdh_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ngɛ wúro waadásɩ ifééri Ísifu sɩsɩ: «Mɩ́sɩra laadɔ́ɔ-daá cé, mɛ́gɛ́ɛ na wúro Farawʊ́na. Amá, laadɔ́ɔ kana kadaá, a ɖé ńdáfá yíko, naárʊ fɛ́yɩ́ wɛ́ngbɛzɩ́ɩ nʊvɔ́rɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Ngɛ wúro waava Ísifu Mɩ́sɩra yɩ́ɖɛ neɖére sɩsɩ: Safɩnáatɩ-Paneyáa; ɩcáŋ ɩcáa alʊ́ ɩfa yɩ. Óoni tɛ́ɛ́dɩ-daá sarásɩ lanɖʊ́ bánÿaá yɩ sɩsɩ Poti-Feráa nɛ́, ɩwɛɛlɛ́ɛ Asɩnáatɩ gɛ waava yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Sáátɩ wenkí Ísifu waabáázɩ wúro-dɛ́ɛ tɩmɛ́rɛ-ɖɩḿ nɛ́, ɩwɛná bɩ́ɩ́zɩ ákoosaaláa (30). Ngɛ waalɩ́ɩ wúro-dɛ́ɛ ɩsʊ́ʊ ikíli ɩbɛ́ɛ́ŋ laadɔ́ɔ-rɩ́ŋa. ");
INSERT INTO kdh_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Fɔɔnɔ́ɔ bɩ́ɩ́zɩ lʊbɛ sɩḿ sɩdaá, kíɖíím waabá gɛ bɩlá fásɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ngɛ Ísifu woodúúzi kíɖíídi ɖabata ɩsɩ́ɩ azíya bɩ́ɩ́zɩ sɩḿ sɩdaá. Wɔɔgbɔ́ɔ kíɖíídi wooyuú tɩ fásɩ-daá nɛ́ ɩkázɩ́ɩ tɛ́ɛ́dɩwá kʊ́bɔńdɩ tɩdɩláána nɛ́ tɩdaá. ");
INSERT INTO kdh_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Ngɛ Ísifu woodúúzi kíɖíídi bɩbá bɩɖɔ́ɔ nyazɩ tenkú nɔɔ́ kanyɩ́ŋa, hálɩ biiyéle waasɩ bɩgʊjʊʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Naanɩ́ nyɔɔ́sɩ ɩsʊ́ʊ tɛ́ɛ́dɩ nɛ́, Ísifu ɖɛɛlʊ́ Óoni tɛ́ɛ́dɩ sarásɩ lanɖʊ́ Poti-Feráa wɛɛlɛ́ɛ Asɩnáatɩ wáńlʊ́rʊ́ bíya abaaláa nɔɔ́lɛ. ");
INSERT INTO kdh_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Ngɛ Ísifu waava kʊ́bɔnɩ́ yɩ́ɖɛ sɩsɩ Manasée bugutoluú sɩsɩ: «Ɩsɔ́ɔ weeyéle mɔzɔ́ɔ mɛ́dɛ́ɛ wahála na mána mɛ́dɛ́ɛ koobíre ɖɛ́dɛ́ɛ ɖamá tarɩ́ɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ngɛ waava kúmuú ɩlɛ́ yɩ́ɖɛ sɩsɩ Efɩrayíim, bugutoluú sɩsɩ: «Ɩsɔ́ɔ waava ma lʊrʊ́ʊ laadɔ́ɔ wenká kadaá máálá wahála nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Bɩjɔɔ́ɔ‑bɩjɔɔ́ɔ nɛ́, ngɛ fɔɔnɔ́ɔ-dɛ́ɛ bɩ́ɩ́zɩ lʊbɛ wɛɛdɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Nyɔɔ́sɩ bɩ́ɩ́zɩ lʊbɛ waabáázɩ ńŋɩnáa wenbí Ísifu waavʊ́ńdɔḿ bɩ nɛ́. Nyɔɔ́sɩ waaɖʊ sɩlɩ́ɩ laadásɩ rɩ́ŋa-daá. Amá, Mɩ́sɩra laadɔ́ɔ-daá, kíɖíím wɛ. ");
INSERT INTO kdh_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Sáátɩ wenkí nyɔɔ́sɩ waajáárɩ Mɩ́sɩra ńba bádándanáa nabʊ́rʊ beɖi nɛ́, ngɛ boobó bénwiináa wúro sɩsɩ bɛḿ bánzɩ́m nyɔɔ́sɩ. Ngɛ wúro sɩsɩ: «Ibó ɩbɔ́ɔ́zɩ Ísifu; a wenbí wɔɔdɔ́ mɩ́ɩ sɩ ɩlá nɛ́, ivu ɩlá bɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Sáátɩ wenkí nyɔɔ́sɩ waabá sɩcáárɩ laadɔ́ɔ rɩ́ŋa-daá páá nɛ́, ngɛ Ísifu weeyéle batʊlʊ́ kpééni lénléwá baazɩ́ɩ azíya nɛ́, bánÿanáa ɩráa kíɖíím. Báa ɖoo nyɔɔ́sɩ ɩbá sɩwɛ sɩbamáa ɖóni kpáa Mɩ́sɩra ńnaamʊ́, ");
INSERT INTO kdh_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","ɩráa wángalɩɩ́ laadásɩ ndɩ‑ndɩ ɖʊɖɔ gɛ bɔ́ngɔnɩ́ Mɩ́sɩra ńna bánmʊ́ʊ Ísifu-jɔ́ kíɖíídi; káma, adɛ laadɔ́ɔ rɩ́ŋa-rɔ gɛ nyɔɔ́sɩ sɩḿ sɩwɛ. ");
INSERT INTO kdh_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","2","Yaakúbu waanɩ́ɩ sɩsɩ kíɖíídi kɔwɛ Mɩ́sɩra tɛ́ɛ́dɩ-daá bángayám. Ngɛ wɔɔdɔ́ ibiyaalɩnáa sɩsɩ: «Mébíya, máánɩ́ɩ sɩsɩ kíɖíídi kɔwɛ Mɩ́sɩra laadɔ́ɔ-daá; bɩlɛ́ nɛ́, ɩ́kɔcɔ́ɔ mɩ́bɛɛ́na ɖamá bɩlɛ́. Ɩgʊrʊ́ ibó ɩkámʊ́ ɩkɔná ɖiɖi ɖɩlɛɛná ɖéweezíni.» ");
INSERT INTO kdh_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ngɛ Ísifu ɖawaalɩnáa fuú bana baagʊrʊ́ bɛɖɛ́ɛ Mɩ́sɩra sɩ bakámʊ́ kíɖíídi. ");
INSERT INTO kdh_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Sɩ bɛɖɛ́ɛ nɛ́, bajaa teyéle benewú Ísifu wɔ́rɔ́ ńnɩ́ Bɛ́ɛnɩ-Yáámíínu ifu wɛ; káma, sɩsɩ nabʊ́rʊ ɩ́kɔkɔ́nɩ bɩkála yɩ nɩ́bááwʊ. ");
INSERT INTO kdh_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kanáanɩ laadásɩ rɩ́ŋa gɛ nyɔɔ́sɩ wɔ́nwɔ́m, biiyéle Israyɛ́ɛlɩ biyaalɩnáa wɛ mʊʊráa boobó Mɩ́sɩra kíɖíím mʊ́ʊ nɛ́ bɔlɔwʊtáá. ");
INSERT INTO kdh_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Mɩ́sɩra ńna, Ísifu kɛ́ɛ na kʊ wúro-dɛ́ɛ bɩdɛ ńnɩ́; wánÿanáa kʊ ɩráa rɩ́ŋa kíɖíídi. Ɩɖawaalɩnáa waadála nɛ́, ngɛ boobó betí baká baɖʊná waazá-daá; babá bɛnyɛ́ adɛ. ");
INSERT INTO kdh_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Ísifu waana wɛ nɛ́, waadɩlɩ́ wɛ; amá, ideyéle bɛlɛ́ batɩlɩ́ yɩ. Ngɛ woovolí wɛ sɩsɩ: «Lé gɛ mɩ́ɩgálɩ́ɩ.» Ngɛ bɛlɛ́ boobúsi yɩ sɩsɩ: «Kanáanɩ laadɔ́ɔ-daá gɛ; ɖɔ́ɔ́gɔ́nɩ sɩ ɖɩmʊ kíɖíídi gɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Ńna nɛ́, Ísifu waabá ɩtɩlɩ́ wɛ páá; amá, bɛḿ badatɩlɩ́ yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ngɛ Ísifu wɔɔdɔ́ɔ́zɩ ɖoo ɩdɛ́ɛ ɖoozá alɛ́ arɔ. Ńna gɛ wɔɔdɔ́kpɔwʊ́ wɔ́ndɔ́m wɛ sɩsɩ: «Mɩ́ɩ mɩ́jɔɔ́ɔ ɖɔ́ nɛ́, mɩ́gɛ́ɛ cɔŋɩráa gɛ. Mɩ́ɩ́gɔ́nɩ sɩ ɩcɔ́ŋ ɩna laadɔ́ɔ-dɛ́ɛ mádafɩ́yátɩ ɖɩdáarɛ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ngɛ boobúsi yɩ sɩsɩ: «Aayɩ́, bɩdɛkɛ́ɛ bɩlɛ́, mádʊ́ʊ; kíɖíídi mʊ́ʊ wɔɔgɔná na ɖáa cé. ");
INSERT INTO kdh_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Bɛɛ, ɖárɩ́ŋa ɖázɩ́ŋɛ́ɛ ɖɔ́ nɛ́, ɖájaa kʊ́ɖʊḿ gɛ. Toovonúm-dɩnáa gɛ ɖɛ́gɛ́ɛ; ɖɛ́dɛ́kɛ́ɛ cɔŋɩráa.» ");
INSERT INTO kdh_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ngɛ Ísifu waabá ɩnyɩ́ŋ sɩsɩ: «Bʊbɔ́tɩ gɛ, mɩ́ɩ́gɔ́nɩ sɩ ɩcɔ́ŋ laadɔ́ɔ ɩna lénlé kɛvɛ́yɩ́ fɩ́ya nɛ́ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ngɛ sɩsɩ: «Ɖɔ́ɔ́ nyɛ́dɛ́ɛ yomáa ɖɔ́jɔɔ́ɔ ɖɔ́ nɛ́, ɖájaa kʊ́ɖʊḿ gɛ; ɖávʊ́ngɛ́ɛ ɩráa fuú na nɔɔ́lɛ gɛ, ngɛ kʊ́ɖʊḿ igúti ɩvɛ́yɩ́ ɖʊɖɔ. Kanáanɩ laadɔ́ɔ-daá gɛ ɖáagálɩɩ; bɩɩga ɖɛ́dɛ́ɛ tɔ́ɔ́rɔɔ́ ɩlɛ́ ɩgɔwɛ ɖaána ɖájaa-jɔ́.» ");
INSERT INTO kdh_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Ngɛ Ísifu sɩsɩ: «Yaa mɔ́nɔɔdɔmʊʊ́ nbɩlɛ́? Mɩ́gɛ́ɛ cɔŋɩráa gɛ. ");
INSERT INTO kdh_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Tɔ́ɔ, a ngʊ́ bɩdɛkɛ́ɛ bɩlɛ́, mánɖaazɩ́ mɩ́ɩ mɛbɛ́ɛ; máámʊ́ná wúro Farawʊ́na sɩsɩ naanɩ́ mɛjɛ́ mɩ́ɩ ikpé nɛ́, asée máńnáa mínewú weení waagágá ɖaána mɩ́jaa-jɔ́ nɛ́ cé. ");
INSERT INTO kdh_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Bɩlɛ́ nɛ́, ɩlɩzɩ́ mɩ́dáá kʊ́ɖʊḿ ɩlɛ́ ibó ɩkɔ́gbɔ́ɔ mínewú ɩmʊ́ ɩkɔná; bɩka baaganáa ɩcɔ́ɔ sáráka hálɩ ɩlɛ́ ibó ɩkɔ́nɩ. Ńnaamʊ́ gɛ mónÿuúu na madɩlɩ́ sɩsɩ toovonúm gɛ míívééri ma. A ngʊ́ bɩdɛkɛ́ɛ bɩlɛ́, máámʊ́ná wúro Farawʊ́na sɩsɩ mɩ́gɛ́ɛ cɔŋɩráa.» ");
INSERT INTO kdh_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ngɛ wɔɔgbɔ́ɔ barɩ́ŋa páyɩ́ ɩtɔ sáráka hálɩ wɛ́ náádoozo. ");
INSERT INTO kdh_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Wɛ́ náádoozo wɩ́rɛ nɛ́, Ísifu woobó ifééri wɛ sɩsɩ: «Bɩlɛ́ nɛ́, mɔ́ɔ́ ménzewɔ́ɔ Ɩsɔ́ɔ; bɛɛ wenbí sɩ ɩlá na iyuú mɩ́dɩ nɛ́ nɖɔ́: ");
INSERT INTO kdh_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","A mɩ́gɛ́ɛ ɩráa kazɔ́ɔ ńba, mɩ́dáá kʊ́ɖʊḿ ɩ́cɔɔ sáráka-daá cé, bɩka baaganáa ɩkpɔ́ɔ kíɖíídi bekpená zamɔ́ɔ kɩ́ngazɩ́m nyɔɔ́sɩ ɖaána nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Na a bɩgɛ́ɛ bɛlɛ́ boobó gɛ sɩ bakábɩsɩ, bɛkɛ́gbɛ́dɩ́na mínewú mɩ́ndɔ́m ɩdɔ́m nɛ́ bɔkɔná. A mááná yɩ, na bɩcɔ mava mɩ́ɩ toovonúm bɩka ɩlɩ́ɩ sɩ́m-daá.» Ngɛ ɩɖawaalɩnáa weedísi. ");
INSERT INTO kdh_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Bɔjɔɔ́ɔ bɔ́ndɔ́m ɖamá sɩsɩ: «Ɩhɩ́n, ɖoo ɖénéwú-dɛ́ɛ naazɩrɛ ɖáánáázɩ yɩ ɖɛ nɛ́, ɖɩnáábɩ́lɛ́ bɩ́nvɛrɩ́ɩ ɖáa sinje bɩlɛ́ yoo. Ɖoo sáátɩ wenkí ɖánnaazɩ́ yɩ nɛ́, waavɩ́nɩ ɖáa sɩsɩ ɖɩ́cɛ ɩmʊ́, amá, ɖádatáńnɩɩná yɩ. Bɛɛ bɩdɛ́ɛ naazɩrɛ gɛ bɩ́nvɛrɩ́ɩ ɖáa ɖɔ́.» ");
INSERT INTO kdh_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ngɛ baɖawaalʊ Rʊ́bɛ́ɛnɩ ɩlɛ́ ɩnɔɔ́ nbɩlɛ́ sɩsɩ: «Ahán, máávʊ́ńveeri mɩ́ɩ sɩsɩ lakásɩ wensí mɩ́nlanáa bú ceení ɖɔ́ nɛ́, iyéle sɩ; amá, mɩ́dánɩ́ɩ́ná ma. Tɔ́ɔ, lɛlɛɛɖɔ́, ɩdɛ́ɛ sɩ́m-dɛ́ɛ kɩvɛrɛwʊ gɛ bɩ́nvɛrɩ́ɩ ɖáa ɖɔ́.» ");
INSERT INTO kdh_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Amá, bánŋmatɩ́ bɩlɛ́ nɛ́, badatɩlɩ́ sɩsɩ Ísifu wánnɩɩ́. Ɩlɛ́ wánŋmatɩ́ kʊnʊm nakɩ́rɩ-daá gɛ bɩka naárʊ wánlɩzɩ́ɩ wɛ bugutoluú bagʊnʊŋ-daá, biiyéle bodoyuú batɩlɩ́ sɩsɩ ɩlɛ́ wánnɩɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ísifu waanɩ́ɩ bánŋmatɩ́ nɛ́, ngɛ woodorí ɩdɩ ɩlɩ́ɩ kpɔ́mɔ́ɔ́ íkewíi. Weewíi bɩtɛ́ nɛ́, ngɛ woozúu ɩkábɩsɩ bɔjɔ́. Wɔɔgɔ́nɩ nɛ́, ngɛ wɔɔdɔ́ wɛ sɩsɩ ɩmʊ́ wángbáa Simeyɔ́ɔnɩ ɩsɩ́ɩ; ngɛ weeyéle bɔfɔ́kɩ yɩ nibé baazá-daá ńna. ");
INSERT INTO kdh_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Bʊwɔ́rɔ́ nɛ́, ngɛ waava nɔɔ́ sɩsɩ bósuu wɛ kíɖíídi bɛdɛ́ɛ kpetekíni-daá bisu; bɩka babɩsɩná báa awéní-dɛ́ɛ liideé baamʊ ná yɛ nɛ́ baɖʊ ɩdɛ́ɛ kpetekú-daá; bɩka bacáŋ balá wɛ guzúúrí. Boozúu wɛ kíɖíídi bɩtɛ́ nɛ́, ");
INSERT INTO kdh_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","ngɛ báa awéní wɔɔgbɔ́ɔ ɩgbɩná ɩfɔ́kɩ ɩgbangbɔ́ɔ-rɔɔzɩ́ bɔkpɔ́ɔ nɩ́bááwʊ. ");
INSERT INTO kdh_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Boobó batála ɖeelí kiiyu wɛ sɩ boɖóo nɛ́ ní, ngɛ badaá naárʊ woobóɖi ɩdɛ́ɛ kpetekú sɩ ɩlɩzɩ́ kíɖíídi ɩɖʊ ɩdɛ́ɛ kpangbɔ́ɔ. Woobóɖi nɛ́, ngɛ waana iliideé tɩ́nɛ́ɛ kíɖíídi-rɔɔzɩ́ kpetekú-daá. ");
INSERT INTO kdh_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ngɛ waajáŋ ikóo ifééri baaganáa sɩsɩ: «Ɖɛ́dɛ́ɛ ńba, ɩbɛ́ɛ! Baabɩsɩná méliideé bakáɖʊ́ ma mégbetekú-daá cé.» Ngɛ bewenbé wɛɛbɛlɩ́ bɔ́nbɔɔzɩ́ ɖamá sɩsɩ: «We gɛ Ɩsɔ́ɔ waalá ɖáa bɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ngɛ baagʊrʊ́ bobó batála bɔmɔɔná bajaa Kanáanɩ laadɔ́ɔ-daá; bɔkpɔ́ɔ wenbí bɩrɩ́ŋa kpátáá bɩɩlá nɛ́ batɩ́ befééri yɩ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","«Ɖóóbó ɖɩtála nɛ́, tɛ́ɛ́dɩ-daá kʊ́bɔnɩ́ ɩbá wónvolíi ɖɔ́rɔ́ɔ́zɩ́ gɛ sɩsɩ ɖɛ́dɛkɛ́ɛ ɩráa kazɔ́ɔ ńba, ɩsɩ ɖɛ́gɛ́ɛ cɔŋɩráa gɛ. ");
INSERT INTO kdh_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Wɔɔdɔ́ ɖáa bɩlɛ́ nɛ́, ngɛ ɖóóbúsi yɩ sɩsɩ aayɩ́, ɖɛ́dɛkɛ́ɛ bɩlɛ́ bɩdɛ́ɛ ɩráa; toovonúm-dɩnáa gɛ ɖɛ́gɛ́ɛ. Ngɛ ɖáádásɩ ɖifééri yɩ sɩsɩ ");
INSERT INTO kdh_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ɖázɩ́ŋɛ́ɛ ɖɔ́ nɛ́, ɖávʊ́ngɛ́ɛ afobíya fuú na nɔɔ́lɛ gɛ, caáwʊ kʊ́ɖʊḿ. Amá, ɖádáá kʊ́ɖʊḿ wɛɛdɛlɛ́ŋ, bɩka ɖɛ́dɛ́ɛ tɔ́ɔ́rɔɔ́ ɩlɛ́ ɩkáwalɩ́ ɖájaa-jɔ́ Kanáanɩ laadɔ́ɔ-daá. ");
INSERT INTO kdh_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ngɛ kʊ́bɔnɩ́ ɩmʊ́ sɩsɩ a bɩlɛ́, ɩmʊ́ wánɖaazɩ́ ɖáa na ɩbɛ́ɛ sɩsɩ toovonúm ɖɛ́gɛ́ɛ toovonúm-dɩnáa? Ngɛ sɩsɩ ɖíyele ɖádáá kʊ́ɖʊḿ ɩkɔ́jɔ́ɔ ɩmʊ́ ɩjɔ́; bɩka baaganáa ɩkɔ́gbɔ́ɔ kíɖíídi bekégbéná becéle zamɔ́ɔ nyɔɔ́sɩ wángʊ́ʊ kɩ nɛ́; ");
INSERT INTO kdh_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","a bɛlɛ́ bɔɔgɔ́nɩ, bɛlɛ́ bɔkpɔ́ɔ ɖénéwú waaga ɩwɛ nyɔ́jɔ́ cé nɛ́ boboná ɩmʊ́ ɩkáná yɩ. Ńnaamʊ́ nɛ́, ɩmʊ́ wónÿuúu ɩtɩlɩ́ sɩsɩ ɖɛ́dɛkɛ́ɛ cɔŋɩráa, amá, toovonúm-dɩnáa gɛ ɖɛ́gɛ́ɛ; na bʊcɔ ɩmʊ́ ɩkɛ́jɛ ɖénéwú, bɩka iyéle ɖáa ɖɩbɩ́ɩ́zɩ ɖíkíli laadɔ́ɔ-daá ɖɩlá wenbíwá ɖɔ́zɔɔlɛ́ɛ lám nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Boovúti begbetekíni nɛ́, ngɛ báa awéní waana sɩsɩ baabɩsɩná ɩdɛ́ɛ jɔrɔfɔ́ńdɔ́ na liideé bakáɖʊ́ yɩ. Baana bɩlɛ́ nɛ́, ngɛ bɩɩlá bána bajaa Yaakúbu nɩdáárɛ. ");
INSERT INTO kdh_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ngɛ bajaa sɩsɩ: «Ówu, lɛlɛɛɖɔ́ mííyéle mádánnáa mébíya nɔɔ́lɛ, Ísifu fɛ́yɩ́, Simeyɔ́ɔnɩ ɖʊɖɔ fɛ́yɩ́; mɩzɩ sɩ ikúti ɩsɛlɩ́ Bɛ́ɛnɩ-Yáámíínu. Yaatá bɩrɩ́ŋa kpátáá ɖɔ́ nɛ́, mɔ́rɔ́ɔ́zɩ́ gɛ sɩ bɩbɩ́sɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ńna gɛ Rʊ́bɛ́ɛnɩ woobúsi yɩ sɩsɩ: «Baabá, a mɔ́ɔ́ mádakábɩ́sɩ́ná nya Bɛ́ɛnɩ-Yáámíínu, nyánbɩɩzɩ́ ngʊ mebiyaalɩnáa lɛ́ɛ́nɩ́. Bɩlɛ́ nɛ́, kpɔɔ yɩ nɖʊ mɛ́ńdɛ́, mángabɩsɩnáa nya yɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ngɛ bajaa sɩsɩ: «Bʊbɔ́tɩ gɛ, móbú fɛ́yɩ́ wónvúu mɩ́ɩ. Ɩjɔɔ́ɔ ɖɔ́ nɛ́, ɩɖawaalʊ wáńzɩ́ḿ; iriké gɛ bɩɩganá ma. A ɖɔ́ gɛ mɩ́nɖɛɛ́ gɛ nabʊ́rʊ bɩdakazɔ́ɔ nɛ́ waalá yɩ nɩ́bááwʊ, mínÿelíi na mɛ́dɛ́ɛ ábɔńdɩ tɩna, mɛbɛlɩ́ mazɩ ná sísíbí.» ");
INSERT INTO kdh_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Nyɔɔ́sɩ ɩbá sɩwɛ sɩbamáa ɩráa caarɩ́ Kanáanɩ laadɔ́ɔ-daá. ");
INSERT INTO kdh_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Sáátɩ wenkí Yaakúbu na ɩdɛ́ɛ ńba begíɖíídi baagámʊ́ tɩ Mɩ́sɩra nɛ́ tɩɩdɛ́ nɛ́, ngɛ wɔɔdɔ́ ibiyaalɩnáa sɩsɩ: «Bɩlɛ́ nɛ́, ɩbɩ́sɩ Mɩ́sɩra ɩkámʊ́ ɖáa kíɖíídi.» ");
INSERT INTO kdh_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ńna gɛ ibiyaalʊ́ Yudáa woobúsi yɩ sɩsɩ: «Mɩ́sɩra kʊ́bɔnɩ́ ɩmʊ́ waabá gɛ ifééri ɖáa ɩyáázɩ sɩsɩ naanɩ́ ɖɩkɔ́nɩ ɖɩna ɩmʊ́ nɛ́, asée ɩmʊ́ wáńnáa ɖána ɖénéwú ɖázɩ́ŋɛ́ɛ ɖɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Bɩlɛ́ nɛ́, a nyéndisí ɖána Bɛ́ɛnɩ-Yáámíínu ɖɩɖɛ́ɛ, ɖɔ́ɔ́ ɖónboɖé ɖɩkámʊ́ nya kíɖíídi. ");
INSERT INTO kdh_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Amá, a nyéégízi, ɖɔ́ɔ́ ɖódónbolí. Káma, kʊ́bɔnɩ́ ɩmʊ́ waabá ɩtɔ́ gɛ sɩsɩ a ɩmʊ́ ɩdana ɖána ɖénéwú ɖɔ́, ɩmʊ́ ɩ́dánmʊ́ʊ ɖáa.» ");
INSERT INTO kdh_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ngɛ bajaa Israyɛ́ɛlɩ sɩsɩ: «We-rɔ gɛ mɩ́ɩ́bá ifééri ɩrʊ́ ɩmʊ́ sɩsɩ bɩɩgágá mínewú naárʊ ɖaána. Mɩ́dálá ma kazɔ́ɔ kpátáá.» ");
INSERT INTO kdh_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ngɛ boobúsi yɩ sɩsɩ: «Ɩlɛ́ ɩdɩtɩŋa waabaná ɩbɔ́ɔ́zɩ ɖáa tɔ́m ɖabata; ɩbɔ́ɔ́zɩ ɖána ɖɛ́dɛ́ɛ zamɔ́ɔ-rɔɔzɩ́ sɩsɩ: “Mɩ́jaa ní, ɩwɛ? Míígúti mɩ́wɛná newúu naárʊ?” Wenbí bɩrɩ́ŋa sɩ ɖubúsi yɩ nɛ́, tisí gɛ ɖéédísi. Ɖádánbɩɩzɩ ɖɩfʊ́ńdɩlɩ́ sɩsɩ wɔ́ndɔ́m ɖáa sɩsɩ ɖɩ́kɔ́gɔná ɖénéwú.» ");
INSERT INTO kdh_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ngɛ ibiyaalʊ́ Yudáa wɔɔdɔ́ yɩ sɩsɩ: «Baabá, a nyɔ́zɔɔlɛ́ɛ sɩsɩ nyána ɖáa na ɖɛ́dɛ́ɛ zamɔ́ɔ ɖiyuú weezuú nyɔɔ́sɩ ɩ́kakʊ ɖáa, talɩná mɔ́ɔ́ bú ɖána yɩ ɖɩɖɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Máázɩ́ŋ sɩsɩ mɛ́nbɛɛŋ́ yɩ. A nabʊ́rʊ waalá yɩ, nyánbɩɩzɩ́ nbɔ́ɔ́zɩ ma ɩrɔɔzɩ́. A bɩgɛ́ɛ mádákábɩsɩná yɩ, mɔ́ɔ́ mɛ́gɛ́ɛ na tɔ́m-dʊ́ʊ nyɔ́jɔ́ sinje hálɩ ceré. ");
INSERT INTO kdh_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Na nbɛ́ɛ nɛ́, a bɩdɛkɛ́ɛ ɖááwálɩ́ ɖoo bɩrɩ́ŋa, ńŋɩnáa ɖɔ́, ɖááfʊ́ńbólí hálɩ nabʊ́lɛ ɖɩkábɩsɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ńna gɛ bajaa Israyɛ́ɛlɩ woobúsi wɛ sɩsɩ: «Tɔ́ɔ, wenbí bɩgɛ́ɛ bɩ nɛ́ nbɩlɛ́, mánlám nŋɩ́nɩ́. Bɩlɛ́ nɛ́, a sɩ ɩɖɛ́ɛ, ɩgbɛdɩ́na ɖɛ́dɛ́ɛ cé kpɩná kífená naárɛ ɩɖʊ mɩ́gbɩná-daá; a mɩ́ɩ́dála, ɩlɩzɩ́ ɩfa Mɩ́sɩra kʊ́bɔnɩ́ ɩmʊ́. Bɩɩlá ɖɛ́dɛ́ɛ cé faadɩ́nɩ núm ńbɩ, tʊ́ʊ́nɩ, yáázɩwá, cɩrɩ́m kéti ńbɩ, pisitáasɩ, kpákpa, na kpákpa-bíya, ");
INSERT INTO kdh_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","ɩkpɛdɩ́na liideé nabʊ́lɛ: kaɖaa ńná weená baabɩsɩná yɛ bakáɖʊ́ mɩ́ɩ kpetekíni-daá nɛ́; báa bɩɩlá nŋɩ́nɩ́, naárʊ waayɩsɩ ná ɩkáɖʊ́. Na ikúti ɩɖɔ́kɩ kɩ́falá sɩ ɩkámʊ́ ná yɛ kíɖíídi nɛ́; ");
INSERT INTO kdh_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","bɩka ɩkpɛdɩ́na mínewú ɩɖɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Mánzʊlʊ́ʊ Ɩsɔ́ɔ yíko-dʊ́ʊ sɩsɩ sɩ ibó ɩmɔɔná kʊ́bɔnɩ́ ɩmʊ́ nɛ́, ɩ́bɩɩzɩ ɩkánɩɩ mɩ́gʊnyɔḿ bɩka ɩkɛ́jɛ lí ńnɩ́ na Bɛ́ɛnɩ-Yáámíínu mɩ́rɩ́ŋa ikégbe. A bɩɩga mɔ́ɔ́, a bɩ́ndarɩ́ɩ mána mébíya nbɩlɛ́, bɩ́tara ɖʊɖɔ; móbú kʊ́ɖʊḿ wɛ́ńdɛ́lɛ́ŋ, nɛbɛ́rɛ ɖʊɖɔ sɩ ɩtasɩná tɛlɛ́ŋ ɖɔ́.» ");
INSERT INTO kdh_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ngɛ ibiyaalɩnáa waadákpɩɩrɩ wenbí ńŋɩnáa bajaa wɔɔdɔ́ wɛ nɛ́, bɩɩlá kʊjɔ́ɔ́nɩ sɩ bakává tɩ kʊ́bɔnɩ́ nɛ́ na liideé lɛ́ɛ́nɩ́. Sɩ babɩ́sɩ Mɩ́sɩra bɩlɛ́ nɛ́, ngɛ bɛɛgbɛdɩ́na Bɛ́ɛnɩ-Yáámíínu bána yɩ bɛɖɛ́ɛ. Boobó batála nɛ́, ngɛ boobó bɔmɔɔná Mɩ́sɩra kʊ́bɔnɩ́ Ísifu. ");
INSERT INTO kdh_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Sáátɩ wenkí Ísifu waagʊ́sɩ ɩna sɩsɩ bána Bɛ́ɛnɩ-Yáámíínu bɔɔgɔnɩ ná nɛ́, ngɛ wɔɔdɔ́ ɩdɛ́ɛ ɖɔɔ́ ɖɔkɩrʊ́ sɩsɩ: «Kpɔɔ ɩráa bana nzʊʊná mɛ́dɛ́ɛ. A nyáázʊ́ʊ́ná wɛ, nlɩzɩ́ fʊ́ńdɩ kpɩ́nɖɛ neɖére ngʊ balá kíɖíím; mána wɛ sɩ ɖiɖi ná ɩdaawʊ́.» ");
INSERT INTO kdh_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ngɛ ɩlɛ́ ɖʊɖɔ waanɩ́ɩ ɩgʊ́bɔnɩ́ nɔɔ́, ɩkpɔ́ɔ wɛ bɛɖɛ́ɛ ɩdɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Sáátɩ wenkí baadála sɩ basʊ́ʊ Ísifu-dɛ́ɛ ńŋɩnáa ɖɔ́ nɛ́, ngɛ nɩdáárɛ waazʊ́ʊ wɛ. Ńna gɛ baazála ɖamá ŋmatɩnáa sɩsɩ: «Ɖɛ́dɛ́ɛ ńba, báa bɩɩlá nŋɩ́nɩ́, liideé weená ɖɔ́ɔ́gɔ́nɩ ɖɩmʊ kíɖíídi na ɖɩbɩ́sɩ na ɖɩna yɛ ɖágbɩ́ná-daá bɩlɛ́ nɛ́, arɔɔzɩ́ gɛ bánzʊʊnáa ɖáa cé bɩlɛ́. Tɩrɔɔzɩ́, bánzʊʊnáa ɖáa cé ɖɔ́ nɛ́, sɩ banáázɩ ɖáa gɛ. Bɛ́nlɛɛ́ ɖɛ́dɛ́ɛ kpangbásɩ, bɩka babɩsɩná ɖáa yomáa.» ");
INSERT INTO kdh_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Baabá bacʊʊná ɖaḿ-wɔnɔɔ́ sɩ basʊ́ʊ nɛ́, ngɛ boogóduu wúro-dɛ́ɛ ɖɔɔ́ ɖɔkɩrʊ́ ɩmʊ́ ɩjɔ́ bɔ́ndɔ́m yɩ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","«Kʊ́bɔnɩ́, la suúru, bɛɛ́ɛ, ɖáńzɩm ɖɩkɔ́nɩ cé kááɖɛ-dɛ́ɛ ɖɩmʊ kíɖíídi. Ɖáámʊ́ bɩtɛ́ ɖɩbɩ́sɩ ɖéngbém nɛ́, ");
INSERT INTO kdh_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ɖáádála ɖeelí kiiyu gɛ sɩ ɖuɖóo nɛ́, ɖóóbóɖi ɖɛ́dɛ́ɛ kpetekíni sɩ ɖɩbɛ́ɛ nɛ́, ɖɛ́dɛ́ɛ liideé ɖɔ́ɔgɔ́ɖɔkɩ yɛ ɖɩkɔ́nɩ sɩ ɖɩmʊ ná kíɖíídi nɛ́, anáábɩ́lɛ́ nɔ́ɔ́ ɖáábɩ́sɩ ɖɩna ɖégbetekíni-daá. Amá, ɖáagábɩ́sɩ́ná yɛ, awɛ ɖɔ́jɔ́ cé. ");
INSERT INTO kdh_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ngɛ ɖɔ́ɔ́gɔ́ná liideé kɩ́falá sɩ ɖɩmʊ ná kíɖíídi nɛ́ ɖʊɖɔ. Amá, liideé amʊ́ adɛ́ɛ tɔ́m waalá ɖáa bítí ɖɔ́nbɔɔzɩ́ ɖádɩ sɩsɩ weení bʊdʊ́ʊ waabɩsɩná na yɛ ɩɖʊ ɖégbetekíni-daá.» ");
INSERT INTO kdh_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Baaŋmátɩ bɩlɛ́ nɛ́ gɛ ɩlɛ́ woobúsi wɛ sɩsɩ: «Ɩzɩ́ɩ míwenbé ɖɛfɛɛ, ɩ́kalá síka, ɩdɩlɩ́ sɩsɩ mɩ́dɛ́ɛ Ɩsɔ́ɔ, mɩ́jaa-dɛ́ɛ Ɩsɔ́ɔ waaɖʊ ná mɩ́ɩ ɖɔ́ɔ́lɛ mígbetekíni-daá. A bɩɩga míliideé míívʊ́ńjelí yɛ bɩlɛ́ nɛ́, máńmʊ́ʊ yɛ.» Ngɛ waagálɩ́zɩ́ Simeyɔ́ɔnɩ ɩkɔná wɛ ");
INSERT INTO kdh_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","ɩsʊʊná barɩ́ŋa Ísifu-dɛ́ɛ. Waazʊʊná wɛ nɛ́, ngɛ baagájɩ́rɩ́ wɛ lɩ́m basáŋ banʊvɔ́; baɖʊ bɛdɛ́ɛ kpangbásɩ kíɖíím. ");
INSERT INTO kdh_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Bɛɛdɛ́ nɛ́, ngɛ baagbɩ́ɩ́rɩ bɛdɛ́ɛ kʊjɔ́ɔ́nɩ bɔɔgɔ́gɔ́ná tɩ sɩ bafa Ísifu nɛ́ baɖamáa ɩdɛ́ɛ kɔnɖɛ́ ɩdaawʊ́. Béńveeri wɛ sɩsɩ bána yɩ sɩ beɖi ná kíɖíím ɩdaawʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Sáátɩ wenkí Ísifu waagázʊʊ nɛ́, ngɛ bɔɔgbɔ́ɔ ɩdɛ́ɛ kʊjɔ́ɔ́nɩ becéle yɩ, bacáŋ baká bɛnyɛ́ adɛ waazá-daá, bɛsɛ́ɛ yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ngɛ Ísifu wɔɔbɔ́ɔ́zɩ bɛdɛ́ɛ alaafɩ́ya-rɔɔzɩ́; ɩbɔ́ɔ́zɩ wɛ ɖʊɖɔ sɩsɩ: «Mɩ́jaa ábɔ́nɩ́ mɩ́ɩ́vʊ́ńŋmatɩ ma ɩdɔ́m bɩlɛ́ nɛ́, ɩ́na ɩdɩ? Ɩdɛɛzɩwɛ weezuú-daá?» ");
INSERT INTO kdh_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ngɛ boobúsi yɩ sɩsɩ: «Ɖájaa nyɛ́dɛ́ɛ yoḿ na ɩdɩ.» Ngɛ boodóluuzi badɩ adɛ waazá-daá betí bosóm bɛsɛ́ɛ yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ísifu waagʊ́sɩ ɩna inewú Bɛ́ɛnɩ-Yáámíínu ɩ́na yɩ bɔgɔɔ kʊ́ɖʊḿ nɛ́, ngɛ wɔɔdɔ́ wɛ sɩsɩ: «A bɩlɛ́, mínewú mɩ́ɩ́vʊ́ńveeri ma ɩdɔ́m nɛ́ nɖɔ́?» Ngɛ sɩsɩ: «Ɩɩ́n». Ngɛ waajáŋ ɩtɔ́ ɩlɛ́ sɩsɩ: «Móbú fɔɔ́, Ɩsɔ́ɔ ɩ́sɩ́ná nya.» ");
INSERT INTO kdh_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Ísifu wɛɛbɛ́ɛ́ŋ inewú nɛ́, ɩlaakáarɩ waagʊrʊ́ hálɩ waazá ɩkɛ́gɛ́ɛ́ná lɩ́m. Ngɛ waajáŋ ɩkʊrʊ́ ɩɖɛ́ɛ ɩsʊ́ʊ ɩɖaḿ-daá ɩsála wíídi. ");
INSERT INTO kdh_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Weewíi bɩtɛ́ nɛ́, ngɛ woojozí lɩ́m ɩkɔ waazá; ngɛ waabɩ́sɩ ɩkálɩɩ. Waagálɩɩ nɛ́, ngɛ weeɖi suúru ɩɖɔ́kɩ ɩdɩ, ɩtɔ́ sɩsɩ báɖʊ́ kíɖíím barɩ́ŋa beɖi. ");
INSERT INTO kdh_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Sɩ baɖʊ nɛ́, ngɛ baaɖʊ ɩmʊ́ Ísifu na wandɩ; bɩka baɖʊ igoobíya na bandɩ; Mɩ́sɩra ńba ɩ́na wɛ bénɖíi nɛ́, bɛlɛ́ bána bandɩ ɖʊɖɔ. Káma, bɛlɛ́ bána Éburu ńba bódóndóróyóózi bénɖíi kíɖíím. ");
INSERT INTO kdh_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ísifu igoobíya sɩ beɖi kíɖíím nɛ́, sɩ basɩ́ɩ wɛ nɛ́, kʊ́bɔńdɩ-rɔɔzɩ́ gɛ baazɩ́ɩ wɛ waazá-jɔ́; ngɛ bɩɩlá wɛ bítí bɛ́ngɛɛzɩ́ bɛ́nbɛɛŋ́ ɖamá ŋmalam‑ŋmalam. ");
INSERT INTO kdh_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Bɔɔjɔ́ɔ bɩtɛ́ nɛ́, ngɛ Ísifu wɔɔdɔ́ bɔkpɔ́ɔ kíɖíím waazá-daá batára baɖʊ wɛ. Bánɖʊ́ʊ wɛ nɛ́, ngɛ wɔɔdɔ́ baɖʊ Bɛ́ɛnɩ-Yáámíínu-dɛ́ɛ bɩɖɔ́ɔ bɩkɩ́lɩ ɩɖawaalɩnáa rɩ́ŋa-dɛ́ɛ nabʊ́nʊ́wá. Ngɛ barɩ́ŋa beeɖi bɔfɔ́ɔ, bɔnyɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Bɩjɔɔ́ɔ nɛ́, ngɛ Ísifu wɔɔdɔ́ ɩdɛ́ɛ ɖɔɔ́ ɖɔkɩrʊ́ ɩmʊ́ sɩsɩ: «Kʊrʊ́ ngbɔ́ɔ ɩráa bana begbetekíni nzúu wɛ kíɖíídi. A sɩ nzúu wɛ, suu wenbí báa awéní wánbɩɩzɩ́ ɩsʊ́ʊ bɩ nɛ́. A nyóózúu wɛ bɩtɛ́, nbɩsɩná báa awéní-dɛ́ɛ liideé sɩ ɩfɛ́rɛ yɛ nɛ́ ndɩ́nɩ ɩsɔ́ɔ́dáá.» ");
INSERT INTO kdh_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ngɛ sɩsɩ: «A nyábámáa wɛ kíɖíídi suú gɛ bɩɩdála bɛdɛ́ɛ tɔ́ɔ́rɔɔ́, kpɔɔ mɛ́dɛ́ɛ nyɩɩrʊʊ́ kɔ́ɔ́pɩ na iliideé wɔɔgɔ́ɖɔ́kɩ yɛ sɩ ɩmʊná kíɖíídi nɛ́ ndɩ́nɩ kíɖíídi-rɔ igbetekú-daá.» Ngɛ ɩlɛ́ waalá wenbí Ísifu wɔɔdɔ́ yɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Kiivé tɛ́ɛrɛ́ nɛ́, ngɛ bɛɛjɛ́ wɛ bɔkpɔ́ɔ bɛdɛ́ɛ kpangbásɩ, bɛɖɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Bɛɛgbɛdɩ́ bakʊrʊ́ bɛfɛ́lɛ tɛ́ɛ́dɩ badalɩɩ tá bolíni gɛ Ísifu waagʊ́sɩ ɩdɛ́ɛ ɖɔɔ́ ɖɔkɩrʊ́ sɩsɩ: «Ɖasam, kʊrʊ́ nvu ɩráa bana banʊvɔ́; a nyáájʊ́ʊ́ná wɛ, bɔɔzɩ wɛ sɩsɩ we-rɔ gɛ baalá wɛ kazɔ́ɔ gɛ bɛ́nvɛrɩ́ɩ juutá. ");
INSERT INTO kdh_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ngbaalá baagáŋmɩɩlɩ kʊ́bɔnɩ́-dɛ́ɛ kɔ́ɔ́pɩ wɔ́nnyɔnáa kɩ bɩka wánlanáa bɔɔzɩ́tɩ nɛ́. Wenbí baalá ɖɔ́ nɛ́ ɩbá bɩvɛ́yɩ́ kazɔ́ɔ kpátáá.» ");
INSERT INTO kdh_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ngɛ ɩlɛ́ ɖʊɖɔ waagʊrʊ́ ise ɩkɔ́mɔɔná wɛ; wɔɔmɔɔná wɛ nɛ́, ngɛ wɔɔdɔ́kpɔwʊ́ bɩlɛ́ ɩbɔ́ɔ́zɩ wɛ. ");
INSERT INTO kdh_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ngɛ bɛlɛ́ boobúsi yɩ sɩsɩ: «Nŋɩ́nɩ́ gɛ nyánbɩɩzɩ́ nbuuná ɖáa tɔ́m tɩna, kʊ́bɔnɩ́. Ɖɔ́jɔɔ́ɔ ɖɔ́ nɛ́, ɖádánbɩɩzɩ ɖɩlá tɔ́m tɩna tɩdaká kɛtɛngɛrɛ. ");
INSERT INTO kdh_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Bɛɛ ɖáagálɩɩ Kanáanɩ ɖɩkɔ́nɩ nɛ́, ɖɛ́ɛgɛ́gbɛ́dɩ́na liideé ɖáávʊ́ńnáa yɛ ɖégbetekíni-daá nɛ́ gɛ ɖɩkɔná. Ngbetíi wénÿelíi kʊ na ɖɩkɔ́nɩ nyágʊ́bɔnɩ́-dɛ́ɛ ɖaána-daá ɖángaŋmɩɩlɩ́m nyɩɩrɩ‑gbɩ́nɖɛ yáá siká. ");
INSERT INTO kdh_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Amá, bɛ́bɛɛŋ ɖágbɩ́ná-daá, weení ɩdɛ́ɛ kpetekú-daá bánnáa kɩ nɛ́, bánbɩɩzɩ́ bakʊ yɩ; bɩka ɖádɩtɩŋa ɖɩbɩ́sɩ kʊ́bɔnɩ́-dɛ́ɛ yomáa.» ");
INSERT INTO kdh_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ngɛ kʊ́bɔnɩ́ ɩmʊ́ woobúsi wɛ sɩsɩ: «Tɔ́ɔ, máánɩ́ɩ, mɩ́dɩtɩŋa mɩ́ɩ́dɔ́ ná; amá, weení igbetekú-daá sɩ mana kɩ nɛ́, ɩlɛ́ iriké wánbɩsɩ kʊ mɛ́dɛ́ɛ yoḿ; bɩka baaganáa rɩ́ŋa ɩlɩ́ɩ tɔ́m-daá.» ");
INSERT INTO kdh_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ngɛ barɩ́ŋa boobóɖi bagbɩná betísi adɛ ɖasam. Ngɛ boobóɖi begbetekíni; ");
INSERT INTO kdh_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","ngɛ ɩlɛ́ waabáázɩ bɛɛŋ́. Sɩ ɩɖáa nɛ́, ɖawaalʊ́ʊ kʊ́bɔnɩ́-dɛ́ɛ gɛ waaɖaaná hálɩ bibó bikégbííríná tɔ́ɔ́rɔɔ́. Bɩɩgɔ́nɩ sɩ bikégbííríná Bɛ́ɛnɩ-Yáámíínu nɛ́, ɩlɛ́ igbetekú-daá gɛ baana kɔ́ɔ́pɩ. ");
INSERT INTO kdh_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ɖawaalɩnáa waana bɩlɛ́ nɛ́, ngɛ bɩɩgʊ́sɩ balaakáarɩ bɛlɛrɩ́ bagbɩná bozóóna yɛ nɛ́; ngɛ báa awéní waabɩsɩná ɩgbɩná bɔfɔ́kɩ, barɩ́ŋa bosúu babɩ́sɩ tɛ́ɛ́dɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yudáa na igoobíya boobó batála bɔmɔɔná Ísifu ɩdɛɛzɩ ɩwɛ ɖaána. Ngɛ barɩ́ŋa beedí babála bofu waazá-daá. ");
INSERT INTO kdh_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ngɛ ɩlɛ́ wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «Ngbaalá mɩ́ɩ́lá bɩlɛ́. Mɩ́dátɩ́lɩ́ sɩsɩ ɩrʊ́ ńŋɩnáa mádáká ɖɔ́ wɛná yíko ɩbɔ́ɔ́zɩ ɩna wenbí bɩrɩ́ŋa bɩgɛ́ɛ nɛ́?» ");
INSERT INTO kdh_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Ńna gɛ Yudáa sɩsɩ: «Wentí gɛ sɩ ɖɩŋmátɩ, mágʊ́bɔnɩ́. Wentí gɛ ɖɔ́wɛná sɩ ɖɩŋmátɩ na bɩwɩ́lɩ sɩsɩ ɖɛ́dɛ́kɛ́ɛ tɔ́m-dɩnáa; Ɩsɔ́ɔ wóńvúlú ɖɔ́wɔ́rɔ́. Bɩlɛ́ nɛ́, ɖárɩ́ŋa ɖɔ́, ɖána weení igbetekú-daá baana kɔ́ɔ́pɩ nɛ́, ɖánbɩsɩ́ nyɛ́dɛ́ɛ yomáa.» ");
INSERT INTO kdh_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ngɛ Ísifu sɩsɩ: «Aayɩ́, bɩ́dánlaḿ bɩlɛ́. Bɩdɔmɔɔná malá bɩlɛ́. A sɩ magba yoḿti, weení igbetekú-daá baana kɔ́ɔ́pɩ nɛ́, ɩlɛ́ iriké gɛ mángbáa yoḿti; a bɩɩga mɩ́nyɔ́ɔ́, mɩ́nyɔ́ɔ́ ibó ikpé ɖɛfɛɛ ɩkɔ́mɔ́ɔ́ná mɩ́jaa.» ");
INSERT INTO kdh_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ngɛ Yudáa woogóduu Ísifu ɩzá-daá ɩtɔ́ yɩ sɩsɩ: «Kʊ́bɔnɩ́; nyɔ́jɔɔ́ɔ gɛ nyazɩ wúro Farawʊ́na. Máálá nya gááfára sɩsɩ bafa ma nɔɔ́ maŋmátɩ tɔ́m bíya cʊ́kɔyɔ́ɔ ɖɔ́; amá mákákʊsɩ nyálaakáarɩ. ");
INSERT INTO kdh_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ɖoo kaɖaa-dɛ́ɛ ɖɔ́ɔ́gɔ́nɩ nɛ́, nyɔ́ɔ́bɔ́ɔ́zɩ ɖáa sɩsɩ ɖájaa wɛ, yáá ɖógóóbú naárʊ wɛ. ");
INSERT INTO kdh_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ngɛ ɖóóbúsi nya sɩsɩ ɩɩ́n, ɖájaa wɛ; amá, wáńbɩ́ɩ ábɔ́nɩ́ gɛ, ɖénéwú ɖájaa-dɛ́ɛ ábɔɔ-bú ɖʊɖɔ wɛ. Ngɛ ɖénéwú ɩmʊ́, ɖájaa ɩbá ɩzɔɔlɛ́ɛ ɩdɔ́m gɛ; iriké waaga ná ɩgɔɔ-dɛ́ɛ bíya-daá. Bú ɩmʊ́ ɩɖawaalʊ waazɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ɖááŋmátɩ nya bɩlɛ́ nɛ́, ngɛ nyazɩ ɖíbo ɖɩkɔ́gɔ́ná ɖénéwú ɩmʊ́ nna yɩ na nyáázá. ");
INSERT INTO kdh_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ngɛ ɖéévééri nya tɔ́m kutoluú sɩsɩ bú ɩmʊ́ ɩ́dánbɩɩzɩ ɩbá ɩɖɛ́ɛ ɖeelí ɖɔ́ iyéle ɩjaa. A wɛɛɖɛ́ɛ bɩlɛ́, ɩjaa wɛ́nbɛlɩ́ɩ ɩsɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ɖááŋmátɩ nya bɩlɛ́ nɛ́, ngɛ nyɔ́ɔ́dɔ́ ɖáa sɩsɩ a ɖé ɖódóbó ɖɩkɔná ɖénéwú ɩmʊ́ nna yɩ ɖádándanáa nya. ");
INSERT INTO kdh_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Tɔ́ɔ, nyááŋmátɩ ɖáa bɩlɛ́ nɛ́, ngɛ ɖóózúu ɖɩbɩ́sɩ ɖɛ́dɛ́ɛ. Ɖáádála nɛ́, ɖʊkpɔ́ɔ bɩlɛ́ ɖɩtɩ́ ɖifééri ɖájaa. ");
INSERT INTO kdh_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Woogúti ɩkɔ́nɩ ɩtɔ́ ɖáa sɩsɩ ɖɩ́kábɩsɩ cé ɖɩmʊ kíɖíídi nɛ́, ");
INSERT INTO kdh_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","ngɛ ɖɔ́ɔ́dɔ́ yɩ sɩsɩ naanɩ́ ɖɩbɩ́sɩ ɖɩkámʊ́ kíɖíídi nɛ́, asée wéńÿélí ɖána ɖénéwú ɖibó; a bɩdɛkɛ́ɛ bɩlɛ́, ɖɔ́ɔ́ ɖódónbolí. Káma, Mɩ́sɩra kʊ́bɔnɩ́ wɔɔdɔ́ ɖáa gɛ sɩsɩ a bɩdɛkɛ́ɛ ɖána yɩ ɖɔ́, ɖádándanáa yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ngɛ ɖájaa woobúsi ɖáa sɩsɩ ɖányɩ bɩlɛ́ sɩsɩ bíya abaaláa nɔɔ́lɛ riké gɛ ɩmʊ́ ɩɖɛɛlʊ́ waalʊrʊná ɩmʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ngɛ kʊ́ɖʊḿ ɩlɛ́ waazʊ́ʊ nyɩ́ɩ́dɩ; ɩsɩ báa bɩɩlá nŋɩ́nɩ́ fɔɔ́-daá fʊ́ńdɩ kpɩ́nɖɛ neɖére wɔɔdɔɔ ná yɩ; ɖoo bɩrɩ́ŋa, ɩmʊ́ idokúti ɩna yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ngɛ sinje nɛ́, ɖazɩ ɖɛ́ndɛɛzɩ́ ceení kpɔwʊ́ʊ. A ɖɔ́ gɛ nabʊ́rʊ waalá yɩ nɩ́bááwʊ-daá, ɖénÿelíi na ɩmʊ́ ɩdɛ́ɛ ábɔńdɩ tɩna, ɩbɛlɩ́ ɩsɩná sísíbí. ");
INSERT INTO kdh_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Bɩlɛ́ nɛ́, nŋɩ́nɩ́ gɛ mánbá mabɩ́ɩ́zɩ mabɩ́sɩ ɖájaa-jɔ́ bɩka bú ceení fɛ́yɩ́ ɖɔ́jɔ́; káma, ɩgɛ́ɛ na ɖájaa-dɛ́ɛ weezuú. ");
INSERT INTO kdh_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","A ɖé ɩdana ɖána bú ɩmʊ́ ɖɩkábɩsɩ, sɩ́m wɛ́nbɛlɩ́ɩ bɩkpɔ́ɔ yɩ. Ngɛ ɩdɛ́ɛ sɩ́m bɩḿ nɛ́, ɖɔ́ɔ́ ɖééyélé ná gɛ waazɩ ná sísíbí ɩdɛ́ɛ ábɔńdɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Na ngúti nbɛ́ɛ nɛ́, mɔ́ɔ́ mɔ́ɔgɔ́dɔ́ ná ɖájaa sɩsɩ bú ɩmʊ́ ɩdɛ́ɛ tɔ́m rɩ́ŋa kpátáá, bɔ́kpɔɔ baɖʊ mɛ́ńdɛ́. Méévééri yɩ sɩsɩ a mádákábɩsɩná yɩ, ɩdɔ́m ɩ́bɩsɩ mágʊjʊʊ́-rɔ sinje hálɩ ceré. ");
INSERT INTO kdh_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Bɩlɛ́ nɛ́, kʊ́bɔnɩ́, máávɩ́nɩ nya, la suúru; mɔ́ɔ́ mɔ́njɔwʊ́ʊ bú ɩmʊ́ ɩɖɩdáarɛ nyɔ́jɔ́ cé, mabɩ́sɩ nyɛ́dɛ́ɛ yoḿ; bɩka bɛcɛ́ yɩ ɩ́na ɩɖawaalɩnáa baaganáa bekpé. ");
INSERT INTO kdh_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Mádánbɩɩzɩ megbé meyéle bú ceení cé mobó mɔgɔ́mɔ́ɔ́ná majaa. Mádánbɩɩzɩ mana kʊnyɔḿ wenkí majaa sɩ ɩna kɩ nɛ́, mɛ́vɛ́yɩ́na bɩdɛ́ɛ wenbiré.» ");
INSERT INTO kdh_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ísifu cɔɔ́ɔ nɛ́, ɩdabɩ́ɩ́zɩ ɩɖɔ́kɩ ɩdɩ ɩɖaána-daá ńba ɩzá-daá. Ngɛ wɔɔdɔ́ sɩsɩ bɔ́tɔ wɛ balɩ́ɩ asʊ. Ngɛ bɩɩga ɩ́na igoobíya beriké ɖaḿ-daá. Ńna gɛ wɔɔgbɔ́ɔ ɩdɩ ɩwɩ́lɩ wɛ babɩ́ɩ́zɩ batɩlɩ́ yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ngɛ waabáázɩ wíídi. Ɩdɛ́ɛ wíídi ɖóni weeyéle Mɩ́sɩra ńba bɔwɛ asʊ nɛ́ banɩ́ɩ. Ngɛ bɛlɛ́ bɔɔgbɔ́ɔ tɔ́m tɩna hálɩ wúro Farawʊ́na-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Nna gɛ Ísifu weevééri igoobíya sɩsɩ: «Mɔ́ɔ́ gɛ Ísifu; majaa ní, ɩdɛɛzɩwɛ weezuú-daá?» Wɔɔdɔ́ igoobíya bɩlɛ́ banɩ́ɩ sɩsɩ ɩmʊ́ Ísifu ɩnáábɩ́lɛ́ nɛ́, ngɛ bɩɩbá biyóózi bɩlá bɛlɛ́ kirim, badatɩlɩ́ wentí sɩ baŋmátɩ yɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ngɛ Ísifu sɩsɩ: «Igóduuzi mɩ́dɩ.» Ngɛ boogóduu. Ngɛ waadásɩ ifééri wɛ sɩsɩ: «Mɔ́ɔ́ mánáábɩ́lɛ́ mínewú Ísifu weení mɩ́ɩ́gbɔ́ɔ yɩ ɩyaná ɩráa sɩsɩ bɛ́ɖɛ́ɛ́ná yɩ Mɩ́sɩra nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Bɩlɛ́ nɛ́, ɩ́kayɩ́tɩ mɩ́dɩ, ngʊ́ ɩ́kɛnyɛ́ sɩsɩ bɛɛ ɖááyá yɩ bɔkɔná yɩ cé nɛ́, ɖɔ́ yáá ɖɔ́. Ɩdɩlɩ́ sɩsɩ Ɩsɔ́ɔ waavʊ́ńgɛdɛɛzɩ ná ma nɩ́bááwʊ sɩsɩ mɔ́gɔnɩ mɛlɛ́ɛ ɩráa weezíni. ");
INSERT INTO kdh_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Bɛɛ nyɔɔ́sɩ bɩ́ɩ́zɩ nasɩ́lɛ wɛ́ńɖɛ́ɛ́, bɩɩga bɩ́ɩ́zɩ nasʊ́nʊ́wá. Bɩ́ɩ́zɩ sɩḿ sɩdaá, ɩrʊ́ fɛ́yɩ́ sɩ ɩbɩ́ɩ́zɩ ɩfára, belenté bɔtɔ́ sɩsɩ wɔ́ngɔnɩ́ ikóyuú kíɖíídi. ");
INSERT INTO kdh_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Bɩlɛ́ nɛ́, a Ɩsɔ́ɔ wɔɔgbɔ́ɔ ma ɩtɛ́ɛ́zɩ mɩ́ɩ nɩ́bááwʊ, wɔɔzɔ́ɔ́lɩ sɩsɩ bɩ́ká mɩ́dɛ́ɛ lʊrʊ́ʊ adɛ laadɔ́ɔ-rɔ gɛ. Ɩdɩlɩ́ sɩsɩ lɛ́ɛ́dɩ kʊ́bɔńbɩ gɛ mííyúú. ");
INSERT INTO kdh_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Bɩdɛkɛ́ɛ mɩ́ɩgɔ́gɔná na ma cé, Ɩsɔ́ɔ gɛ; Ɩsɔ́ɔ ɩmʊ́ ɖʊɖɔ waazɩɩ ná ma nyazɩ wúro Farawʊ́na ɩjaa. Mɛ́ńdɛ́ gɛ waaɖʊ wúro Farawʊ́na-dɛ́ɛ kowúrátɩ; bɩka ɩbɩsɩná ma Mɩ́sɩra laadɔ́ɔ-dɛ́ɛ kʊ́bɔnɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Bɩlɛ́ nɛ́, ɩlá ɖasam ibó ikéveeri majaa sɩsɩ mɔ́ɔ́ ibú Ísifu mazɩ béfeeri yɩ sɩsɩ Ɩsɔ́ɔ waabɩsɩná ma Mɩ́sɩra rɩ́ŋa-dɛ́ɛ kʊ́bɔnɩ́; bɩlɛ́ nɛ́, ɩ́kpɩɩrɩ ɖasam ikégbe mɔ́jɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","A wɔɔgɔ́nɩ, Goséníi fáráńdɩ́ gɛ sɩ ɩcɔ́ɔ, ɩ́na ibíya, na bebíya; na ɩdɛ́ɛ fééni, namɩ́nɩ, na náánɩ, na ɩdɛ́ɛ ɖɔ́ɔ́lɛ rɩ́ŋa; mɩ́rɩ́ŋa ɩkɔ́nɩ ɩcʊʊná ma. ");
INSERT INTO kdh_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","A wɔɔgɔ́nɩ ɩtála, mánváa ɩ́na ɩdɛ́ɛ zamɔ́ɔ kíɖíídi; mava ɩvʊ́ńdɩ kpɩná ɖʊɖɔ. Tɩ́fa, takáásɩ́ wénɖíi ɩ́na ɩdɛ́ɛ zamɔ́ɔ na wenbí bɩrɩ́ŋa ɩdɩɩná nɛ́; nabʊ́rʊ tángáa yɩ; káma, bɩɩga nyɔɔ́sɩ bɩ́ɩ́zɩ nasʊ́nʊ́wá.» ");
INSERT INTO kdh_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ngɛ waadásɩ ifééri wɛ ɖʊɖɔ sɩsɩ: «Mɩ́dɩtɩŋa mɩ́ɩ́bá ɩna, ɖabáŋ́ na nyɔ́ɔ́ Bɛ́ɛnɩ-Yáámíínu sɩsɩ mɔ́ɔ́ mánŋmatɩnáa kʊ mɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Bɩlɛ́ nɛ́, ibó ɖasam ɩtɩ́ ikéveeri majaa kʊ́bɔńdɩ wentí ménɖíi tɩ Mɩ́sɩra laadɔ́ɔ-daá cé nɛ́; bɩka ifééri yɩ wenbí bɩrɩ́ŋa mɩ́ɩ́ná nɛ́. A míívééri yɩ bɩtɛ́, íkokuti ɩkɔ́jɔ́ɔ ikéleeri, ɩgbɛdɩ́ ɩkɔ́gbɔ́ɔ yɩ ɩkɔná mɔ́jɔ́ cé.» ");
INSERT INTO kdh_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Waaŋmátɩ wɛ bɩtɛ́ nɛ́, ngɛ waanyáa ikpí Bɛ́ɛnɩ-Yáámíínu ɩ́na yɩ babáázɩ wíídi. ");
INSERT INTO kdh_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ngɛ ɩ́na baaganáa beegbíriki ɖamá ɖʊɖɔ na wíídi. Ńna gɛ bɛlɛ́ bána yɩ baazʊ́ʊ faawɩ́ɩ lám. ");
INSERT INTO kdh_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Wúro tɩtɩŋa waanɩ́ɩ sɩsɩ Ísifu igoobíya wɔɔgɔ́nɩ Mɩ́sɩra. Ngɛ tɔ́m tɩḿ tɩɩbá tɩlá wúro tɩtɩŋa na ɩdɛ́ɛ awóronbíya niíni. ");
INSERT INTO kdh_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Ngɛ wúro waayáa Ísifu ɩtɔ́ yɩ sɩsɩ: «Feeri ngoobíya sɩsɩ bɔ́kpɔɔ kíɖíídi babɩ́sɩ Kanáanɩ ");
INSERT INTO kdh_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","bɔkɔ́gbɔ́ɔ bajaa na bɛdɛ́ɛ ɩyáálɩ bɔkɔ́nɩ mɔ́jɔ́ cé. Mánváa wɛ Mɩ́sɩra laadɔ́ɔ kífeńga nɛkɛ́rɛ-daá bɔcɔ́ɔ boyuú kíɖíídi kífeńdi. ");
INSERT INTO kdh_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Na ndásɩ nvééri wɛ sɩsɩ bóyúú Mɩ́sɩra cé tuuríni natɩ́rɩ bɔkɔ́gbɔ́ɔ́ná bajaa na bɛɖɛɛlɩnáa na bebíya. ");
INSERT INTO kdh_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Bákatáńvɔrɔ́sɩ bewenbé sɩsɩ sɩ bakágʊ́rʊ́ bekéyéle bagbɩná. Káma, sɩ bɔkɔ́nɩ cé ɖɔ́ nɛ́, Mɩ́sɩra laadɔ́ɔ rɩ́ŋa-dɛ́ɛ ɖɔ́ɔ́lɛ cɔɔ́ɔ na bɔjɔwʊ́ʊ.» ");
INSERT INTO kdh_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ngɛ Israyɛ́ɛlɩ-dɛ́ɛ bíya waalá wenbí bɔɔdɔ́ wɛ nɛ́. Ísifu waalɩzɩ́ tuuríni icéle igoobíya, ńŋɩnáa wenbí wúro wɔɔdɔ́ yɩ bɩ nɛ́; ɩfa wɛ ɖʊɖɔ bɛdɛ́ɛ guzúúrí. ");
INSERT INTO kdh_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ngɛ waava igoobíya báa awéní jíńgáárɩ́ tóko kʊ́ɖʊmʊ́ʊ‑kʊ́ɖʊmʊ́ʊ. Wɔɔgɔ́nɩ sɩ ɩkává inewú Bɛ́ɛnɩ-Yáámíínu nɛ́, tɩrɔ natʊ́nʊ́wá gɛ waava ɩlɛ́. Sɩ ikúti ɩtásɩ yɩ nɛ́, ngɛ waava yɩ wɛ́ kákpaanɩɩ́nʊwá (300)-dɛ́ɛ tɩmɛ́rɛ liideé. ");
INSERT INTO kdh_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Bɩlɛ́ bibaasí, ngɛ waaɖʊ ɩjaa Mɩ́sɩra kpɩná kífená ɩsʊ́ʊ kpangbásɩ abaaláa sɩrɔ fuú; ɩɖʊ kíɖíídi, kpɔ́nɔ́, na kíɖíídi ndɩ‑ndɩ ɖʊɖɔ ɩsʊ́ʊ kpangbásɩ aláa fuú sɩsɩ bóbóná bekéjéle ɩmʊ́ ɩjaa sɩsɩ ɩdɛ́ɛ nɩ́bááwʊ guzúúrí nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Bɩɩdɛ́ sɩ bɛɖɛ́ɛ nɛ́, ngɛ waabásɩ wɛ sɩsɩ bókoyóo nɩ́bááwʊ. Ngɛ wɛɛjɛ́ wɛ bɛɖɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ngɛ baagʊrʊ́ Mɩ́sɩra hálɩ Kanáanɩ laadɔ́ɔ-daá bɔkɔ́mɔ́ɔ́ná bajaa Yaakúbu. ");
INSERT INTO kdh_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Baadála nɛ́, ngɛ bɔɔgbɔ́ɔ bɩlɛ́ befééri bajaa sɩsɩ: «Ísifu wɛ weezuú-daá, ɩdasɩ́; hálɩ ɩlɛ́ ɩɖɔ́kɩná na kʊ Mɩ́sɩra rɩ́ŋa-dɛ́ɛ kowúrátɩ.» Beevééri bajaa bɩlɛ́ nɛ́, bɩdatáńveeri ɩlɛ́ natɩ́rɩ, ɩdafa wɛ toovonúm. ");
INSERT INTO kdh_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ngɛ bɔɔgbɔ́ɔ wenbí bɩrɩ́ŋa kpátáá Ísifu weegéveeri wɛ sɩsɩ béfeeri yɩ nɛ́ befééri yɩ. Ngɛ baawɩ́lɩ yɩ tuuríni wentí Ísifu weegéjéle wɛ sɩsɩ bɔ́kɔ́ná bɔkpɔɔná yɩ nɛ́. Ńnaamʊ́ gɛ bajaa Yaakúbu Israyɛ́ɛlɩ waagba ɖóni. ");
INSERT INTO kdh_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ngɛ sɩsɩ: «Óo, móbú Ísifu wɛ weezuú-daá yaá. Bɩ́katáńgɩlɩ́ ɖɔɔmɩ́nɩ, mónboɖé máázɩ́rɛ ilósi yɩ naanɩ́ mázɩ́m ɩtála.» ");
INSERT INTO kdh_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ngɛ Israyɛ́ɛlɩ waagbɩ́ɩ́rɩ ɩ́na ɩdɛ́ɛ zamɔ́ɔ na wenbí bɩrɩ́ŋa ɩwɛná bɩ nɛ́ bakʊrʊ́ bɔkpɔ́ɔ Mɩ́sɩra nɩ́bááwʊ. Boobó batála Bɛrɩsebáa nɛ́, ngɛ waagʊ fʊ́ńdɩ kpɩná ɩlá ɩjaa Ɩsaáka-dɛ́ɛ Ɩsɔ́ɔ sarásɩ. ");
INSERT INTO kdh_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Kiiyu nuvoowú nɛ́, ngɛ Ɩsɔ́ɔ waaɖʊ ɩlɩ́ɩ ɩrɔɔzɩ́ ɩtɔ́ yɩ sɩsɩ: «Yaakúbu, Yaakúbu!» Ngɛ Yaakúbu weedísi sɩsɩ: «Mánááɖɔ́ Mádʊ́ʊ.» ");
INSERT INTO kdh_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ngɛ sɩsɩ: «Mɔ́ɔ́ gɛ njaa-dɛ́ɛ Ɩsɔ́ɔ. Mɩ́sɩra boɖé ɩ́kalá nya nɩdáárɛ. Káma, nyándalɩ́ɩ ńna nɛ́, sɩ meyéle gɛ yíri kʊ́bɔńgɩ ɩbá kɩlɩ́ɩ nyálʊrʊ́ʊ-daá. ");
INSERT INTO kdh_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Mádɩtɩŋa sɩ malaazɩ ná nya moboná. Bɩlɛ́ ɖʊɖɔ gɛ a nyáagádala, sɩ malaazɩ ná nyébíya magábɩ́sɩ́ná. Nyánzɩ́m nɛ́, Ísifu sɩ ifu ná nyáázá.» ");
INSERT INTO kdh_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","6","Ngɛ Yaakúbu na ɩdɛ́ɛ ńba baadákpɩɩrɩ bakʊrʊ́ Bɛrɩsebáa babamáa hálɩ Mɩ́sɩra. Sɩ bakʊrʊ́ nɛ́, ngɛ ibiyaalɩnáa wɛɛzɛlɩ́ ɩ́na iwoolináa na bebíya baɖʊ tuuríni wentí Mɩ́sɩra wúro weegéjéle wɛ tɩ nɛ́. Bɛ́nɖɛɛ́ nɛ́, bɛɛgbɛdɩ́na bɛdɛ́ɛ fʊ́ńdɩ kpɩná na wenbí bɩrɩ́ŋa bavʊngɔwɛná bɩ Kanáanɩ laadɔ́ɔ-daá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Wenbí-daá Yaakúbu wɛɛɖɛɛná bɩ Mɩ́sɩra nɛ́ nbɩlɛ́; ɩ́na ibiyaalɩnáa na bɛlɛ́ bebíya na ɩwɛɛlɩnáa na bebíya. Ɩbá ɩ́na igutoluú-dɛ bíya rɩ́ŋa páyɩ́ bɛɛɖɛɛná Mɩ́sɩra. ");
INSERT INTO kdh_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Yaakúbu kutoluú-dɛ bíya wenbá bɛɛɖɛ́ɛ Mɩ́sɩra nɛ́, Israyɛ́ɛlɩ bíya nbɩlɛ́; bayɩrá nɖɔ́: Yaakúbu-dɛ́ɛ kaɖaa bú gɛ Rʊ́bɛ́ɛnɩ. ");
INSERT INTO kdh_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rʊ́bɛ́ɛnɩ ɩlɛ́ ibiyaalɩnáa nɖɔ́: Enɔ́ɔkɩ, Palúu, Ɛsɩrɔ́ɔnɩ, na Karɩmíi. ");
INSERT INTO kdh_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeyɔ́ɔnɩ ɩlɛ́ ibiyaalɩnáa nɖɔ́: Yemuwɛ́ɛlɩ, Yamíini, Oháádɩ, Yakíini, Sowáarɩ; Kanáanɩ alʊ́ biyaalʊ́ Sawúuli. ");
INSERT INTO kdh_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Léévi ɩlɛ́ ibiyaalɩnáa nɖɔ́: Gɛrɩsɔ́ɔnɩ, Keháatɩ na Meraríi. ");
INSERT INTO kdh_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yudáa ɩlɛ́ ibiyaalɩnáa nɖɔ́: Ɛ́ɛrɩ, Onáanɩ, Séla, Perɛ́ɛsɩ na Zeráa; amá, Ɛ́ɛrɩ na Onáanɩ bɛlɛ́ baazɩ́ Kanáanɩ laadɔ́ɔ-daá. Perɛ́ɛsɩ bíya gɛ Ɛsɩrɔ́ɔnɩ na Hamúuli. ");
INSERT INTO kdh_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakáarɩ ɩlɛ́ ibiyaalɩnáa nɖɔ́: Toláa, Púúva, Yasúubɩ na Simirɔ́ɔnɩ. ");
INSERT INTO kdh_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zabulɔ́ɔnɩ ɩlɛ́ ibiyaalɩnáa nɖɔ́: Serɛ́ɛdɩ, Elɔ́ɔnɩ na Yaleyɛ́ɛlɩ. ");
INSERT INTO kdh_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Léya biyaalɩnáa waalʊrʊná wɛ Yaakúbu Padan-Aráamɩ nɛ́ nbɩlɛ́, bána ɩwɛɛlɛ́ɛ alʊ́ Dína. Ɩdɛ́ɛ aléewá bɛḿ na ɩdɛ́ɛ afobíya na bebíya wooyóózi gɛ balɩ́ɩ ɩráa ákoosaaláa na noódoozo (33). ");
INSERT INTO kdh_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gaádɩ biyaalɩnáa nɖɔ́: Sifiyɔ́ɔnɩ, Hagíi, Súuni, Ɛsɩbɔ́ɔnɩ, Eríi, Arodíi, na Arelíi. ");
INSERT INTO kdh_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asɛ́ɛrɩ biyaalɩnáa nɖɔ́: Yimináa, Yisiváa, Yisivíi, na Beriyáa; bána benewú alʊ́ Seráa. Beriyáa biyaalɩnáa nɖɔ́: Éburu na Malikiyɛ́ɛlɩ. ");
INSERT INTO kdh_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Aléeré wenɖé Labáanɩ wɔɔgbɔ́ɔ ɖɛ icéle ɩwɛɛlɛ́ɛ Léya bánÿaá yɩ sɩsɩ Zílipa nɛ́ waalʊrʊná Yaakúbu bíya afobíya wenbá na bebíya nɛ́ nbɩlɛ́. Barɩ́ŋa booyóózi gɛ balɩ́ɩ ɩráa ákɩzaalʊʊ́ na naárʊ (16). ");
INSERT INTO kdh_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yaakúbu ɖɛɛlʊ́ Rasɩ́ɩ́la biyaalɩnáa nɖɔ́: Ísifu na Bɛ́ɛnɩ-Yáámíínu. ");
INSERT INTO kdh_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Ísifu biyaalɩnáa Manasée na Efɩrayíim nɛ́, Mɩ́sɩra gɛ baalʊ́rʊ wɛ. Bíya bɛḿ nɛ́, ɩɖɛɛlʊ́ Asɩnáatɩ, Óoni tɛ́ɛ́dɩ sarásɩ lanɖʊ́ Poti‑Feráa waava yɩ weení nɛ́ waalʊrʊná yɩ wenbá nɛ́ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Bɛ́ɛnɩ-Yáámíínu biyaalɩnáa nɖɔ́: Béla, Bekɛ́ɛrɩ, Asɩbɛ́ɛlɩ, Géra, Namáanɩ; Ehíi, Rɔ́ɔsɩ, Mupíim, Hupíim, na Áarɩdɩ. ");
INSERT INTO kdh_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Rasɩ́ɩ́la-dɛ́ɛ bíya rɩ́ŋa waalʊrʊná wɛ Yaakúbu nɛ́ na bebíya nbɩlɛ́. Barɩ́ŋa baalɩ́ɩ gɛ ɩráa ákɩzaalʊʊ́ naárʊ fɛ́yɩ́ (14). ");
INSERT INTO kdh_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dáanɩ ɩlɛ́ ibiyaalʊ́ gɛ Husíim. ");
INSERT INTO kdh_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Nɛfɩtalíi biyaalɩnáa nɖɔ́: Yatɩséyɛ́ɛlɩ, Guníi, Yetisɛ́ɛrɩ, na Silɛ́ɛm. ");
INSERT INTO kdh_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Bíla Labáanɩ wɔɔgbɔ́ɔ yɩ icéle ɩwɛɛlɛ́ɛ Rasɩ́ɩ́la nɛ́ ibiyaalɩnáa waalʊrʊná wɛ Yaakúbu nɛ́ na bebíya nbɩlɛ́. Ɩráa kʊjʊ́nɩ lʊbɛ (7) gɛ barɩ́ŋa baalɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ɩráa wenbá barɩ́ŋa boogóvú Yaakúbu bɔkɔ́nɩ Mɩ́sɩra nɛ́, wenbá baabá bɛgɛ́ɛ ɩmʊ́ Yaakúbu ɩdɛ́ɛ azimá nɛ́ bɛgɛ́ɛ gɛ ɩráa niídoozo na loɖo (66); bodoyooziná ibiyaalɩnáa-dɛ́ɛ aláa. ");
INSERT INTO kdh_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","A bɔɔgbɔ́ɔ Ísifu-dɛ́ɛ bíya lɛ́ɛ́nɩ́ waalʊ́rʊ wɛ Mɩ́sɩra nɛ́ boyóózi, barɩ́ŋa wenbá bɔɔgɔ́nɩ Mɩ́sɩra nɛ́ baalɩ́ɩ gɛ ɩráa niídoozo na saaláa (70). ");
INSERT INTO kdh_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Sáátɩ wenkí bɔɔgɔ́nɩ bakájʊ́ʊ́ná Mɩ́sɩra nɛ́, ngɛ Yaakúbu waalɩzɩ́ ibiyaalʊ́ Yudáa itíri Ísifu-jɔ́ sɩsɩ bákpɩɩrɩ baɖáŋ ɩmʊ́ ɩdɛ́ɛ talɩ́ɩ Goséníi fáráńdɩ́. Sáátɩ wenkí Yaakúbu na ɩdɛ́ɛ ńba baadála Goséníi nɛ́, bɩdɛ́ɛ sáátɩ ɖʊɖɔ gɛ ");
INSERT INTO kdh_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Ísifu weeyéle bɔfɔ́kɩ ɩdɛ́ɛ awéńja túúruú ɩkágʊ́rʊ́ ɩkɔ́nɩ ɩsɩ́ŋ ɩjaa. Sáátɩ wenkí waadála ɩjaa Israyɛ́ɛlɩ ɩzá-daá nɛ́, ngɛ waanyáa ikpí yɩ iwíi bilééri. ");
INSERT INTO kdh_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ńna gɛ ɩlɛ́ wɔɔdɔ́ yɩ sɩsɩ: «Mááná nya nyɔ́wɛ weezuú-daá ɖɔ́ nɛ́, báa lɛlɛɛɖɔ́, mánbɩɩzɩ́ mazɩ́.» ");
INSERT INTO kdh_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ngɛ Ísifu wɔɔdɔ́ igoobíya na ɩjaa-dɛ́ɛ koobíre ɖɩrɩ́ŋa ɖiigóvú yɩ nɛ́ sɩsɩ: «Tɔ́ɔ, lɛlɛɛɖɔ́ mɩ́ɩ́dála ɖɔ́ nɛ́, mónboɖé megéveeri wúro Farawʊ́na sɩsɩ mogoobíya na majaa-dɛ́ɛ zamɔ́ɔ bavʊngɔwɛ Kanáanɩ nɛ́ bɔɔgɔ́nɩ bɔmɔɔná ma.» ");
INSERT INTO kdh_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ménveerím yɩ ɖʊɖɔ sɩsɩ mɩ́ɩ́gɔ́nɩ nɛ́, mɩ́gɛ́ɛ fʊ́ńdɩ kpɩná ketiráa gɛ; ngɛ sɩ ɩkɛ́ɖɛɛ nɛ́, mɩ́ɩgɛ́gbɛ́dɩ́na mívééni, mínémísi; mɩ́náánɩ na wenbí bɩrɩ́ŋa mɩ́gɔwɛná bɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","A weedíri bayáa mɩ́ɩ gɛ wɔɔbɔ́ɔ́zɩ mɩ́ɩ sɩsɩ mɩ́dɩmɛ́rɛ gɛ wenɖé, ");
INSERT INTO kdh_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ibúsi yɩ sɩsɩ: «Kʊ́bɔnɩ́, ɖoo ɖébijáádɩ hálɩ na sinje, fʊ́ńdɩ kpɩná gɛ ɖéngetí ńŋɩnáa ɖájaájaanáa waavʊ́ńlaḿ bɩ nɛ́.» A mɩ́ɩ́dɔ́ yɩ bɩlɛ́, wɔ́ndɔ́m mɩ́ɩ ɩwalɩ́ Goséníi fáráńdɩ́. Káma, Mɩ́sɩra ńba na fééni na nemísi ketiráa bódónÿoozi bɔcɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Ngɛ Ísifu waanyʊʊ́ ɩkʊrʊ́ ibó ikéveeri wúro Farawʊ́na sɩsɩ: «Majaa na mogoobíya baagágʊ́rʊ́ Kanáanɩ bɔkɔ́nɩ bɔmɔɔná ma cé. Bɔɔgɔ́nɩ bágana bavʊ́ńdɩ kpɩná; bɩɩlá bɩ: fééni, nemísi, na náánɩ, na bɛdɛ́ɛ ɖɔ́ɔ́lɛ rɩ́ŋa. Mánŋmatɩ́ nya ɖɔ́ nɛ́ báńdálɩ́ bɔgɔwɛ Goséníi.» ");
INSERT INTO kdh_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Naanɩ́ Ísifu ibó ikéveeri wúro Farawʊ́na bɩlɛ́ nɛ́, wɛɛgbɛdɩ́na ɩɖawaalɩnáa nɔɔ́nʊ́wá gɛ ɩkáwɩlɩ wúro ɩmʊ́. ");
INSERT INTO kdh_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Wúro waana bɛlɛ́ bɩlɛ́ nɛ́, ngɛ wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ tɩmɛ́rɛ wenɖé gɛ mɩ́nlám. Ngɛ boobúsi yɩ sɩsɩ: «Kʊ́bɔnɩ́, ɖájaájaanáa-dɛ́ɛ tííbí gɛ ɖɔ́ɔ́gbɔ́ɔ; fʊ́ńdɩ kpɩná gɛ ɖéngetí. ");
INSERT INTO kdh_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Nyɔɔ́sɩ wánjaarɩ kʊ Kanáanɩ laadɔ́ɔ hálɩ nyɩ́ɩ́dɩ igúti tɩvɛ́yɩ́ ɖávʊ́ńdɩ kpɩná ɩtɔ́ɔ. Biiyéle ɖáagágʊ́rʊ́ sɩ ɖɩkɔ́nɩ ɖusúu cé. Bɩlɛ́ nɛ́, kʊ́bɔnɩ́, a bɩgɛ́ɛ béndisí, bafa ɖáa nɩ́bááwʊ ɖɩcɔ́ɔ Goséníi fáráńdɩ́.» ");
INSERT INTO kdh_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Ngɛ Farawʊ́na wɔɔdɔ́ Ísifu sɩsɩ: «Njaa na ngoobíya bɔɔgɔ́nɩ bɔmɔɔná nya ɖɔ́ nɛ́, ");
INSERT INTO kdh_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Mɩ́sɩra laadɔ́ɔ rɩ́ŋa cɔɔ́ɔ nyɔ́jɔ́wʊ́ʊ, bɛɛŋ lénlé tɛ́ɛ́dɩ cɔɔ́ɔ kazɔ́ɔ bɩ́nlám nɛ́ nzɩ́ɩ wɛ. A Goséníi ɖʊɖɔ gɛ bɩ́nlám, bánbɩɩzɩ́ bɔcɔ́ɔ, nɔwɛ́ya fɛ́yɩ́. Bɩka, a nyɛ́ɛ́bɛ́ɛ́ŋ bɔlɔwʊtáá ɖʊɖɔ gɛ nyááná wenbá bánbɩɩzɩ́ nɛ́, nlɩzɩ́ bɛlɛ́ béngetí mávʊ́ńdɩ kpɩná.» ");
INSERT INTO kdh_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Bʊwɔ́rɔ́ nɛ́, Ísifu wɔɔgbɔ́ɔ ɩjaa Yaakúbu iboná yɩ ɩkɛ́zɛɛ wúro. Baadála nɛ́, ngɛ Yaakúbu wɛɛzɛ́ɛ wúro na gírímá. ");
INSERT INTO kdh_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Ngɛ wúro wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Bɩ́ɩ́zɩ nŋɩ́nɩ́ gɛ nyɔ́wɛná bɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Ngɛ woobúsi yɩ sɩsɩ: «Mɛ́dɛ́ɛ kisɔɔ́-daá, mɛ́dɛ́ɛ bɩ́ɩ́zɩ nɩɩ́nʊ́wá na ákoosaaláa (130) nɖɔ́. Máábɩ́ɩ ɖasam; máálá wahála. Mána majaájaanáa ɖɛ́dɛ́ɛ kisásɩ kɛ́ɛ kʊ́ɖʊńsɩ gɛ, amá, mɛ́dɛ́ɛ bɩ́ɩ́zɩ tatála wɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ngɛ wɛɛzɛ́ɛ wúro Farawʊ́na, ɩcáŋ ɩkálɩɩ. ");
INSERT INTO kdh_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ísifu sɩ ɩsɩ́ɩ ɩjaa na igoobíya nɛ́, Mɩ́sɩra ɖɩdáarɛ kífeńɖe-daá gɛ waazɩ́ɩ wɛ; Ramɩsɛ́ɛsɩ fáráńdɩ́-daá gɛ waalɩzɩ́ ɩfa wɛ ńŋɩnáa wenbí wúro Farawʊ́na wɔɔdɔ́ nɛ́; ");
INSERT INTO kdh_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","ɩfa ɩjaa na igoobíya na bɛdɛ́ɛ zamɔ́ɔ kíɖíím wenbí bɩ́nɖɔɔ́ báa awéní-dɛ́ɛ zamɔ́ɔ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Bɩɩgɔ́nɩ bʊwɛ nɛ́, ngɛ nyɔɔ́sɩ waabá sɩcáárɩ páá, hálɩ nabʊ́rʊ igúti bɩvɛ́yɩ́ sɩ beɖi; Mɩ́sɩra na Kanáanɩ tɛ́ɛ́dɩ rɩ́ŋa-daá nyɔɔ́sɩ ɩbá sɩ́nwɔ́m. ");
INSERT INTO kdh_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ngɛ Ísifu woodúúzi liideé Mɩ́sɩra ńba na Kanáanɩ ńba waamʊná yɛ kíɖíídi nɛ́; woodúúzi yɛ bɩtɛ́ nɛ́, ngɛ wɔɔgbɔ́ɔ yɛ iboná wúro Farawʊ́na-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Liideé wɛɛdɛ́ Mɩ́sɩra na Kanáanɩ nɛ́, ngɛ Mɩ́sɩra ńba rɩ́ŋa wɔɔgɔ́nɩ befééri Ísifu sɩsɩ: «Báfá ɖáa kíɖíídi. We-rɔ gɛ mɩ́bɛɛ́na ɖáa ɖánzɩ́m nyɔɔ́sɩ, ngʊ́ ɖɛ́vɛ́yɩ́na liideé.» ");
INSERT INTO kdh_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Ngɛ Ísifu woobúsi wɛ sɩsɩ: «A mɩ́dɛfɛ́yɩ́na liideé, ɩgɔná ma mɩ́vʊ́ńdɩ kpɩná na mɔ́ɔ́ mejéle mɩ́ɩ kíɖíídi.» ");
INSERT INTO kdh_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ngɛ boobó bɔkɔ́gɔ́ná yɩ bavʊ́ńdɩ kpɩná, bɩka ɩlɛ́ icéle wɛ kíɖíídi ɩkɛɛná awéńja, fééni, namɩ́nɩ, náánɩ, na kpangbásɩ. Bɩbɩ́nɩ ɩmʊ́ ɩdaá nɛ́, bɛdɛ́ɛ fʊ́ńdɩ kpɩná gɛ wɛɛgɛɛ ná wɛ kíɖíídi. ");
INSERT INTO kdh_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Bɩ́nɩ ɩmʊ́ wɛɛdɛ́ nɛ́, ngɛ baadákabɩsɩ Ísifu-jɔ́ bɔtɔ́ yɩ sɩsɩ: «Kʊ́bɔnɩ́, ɖádanbá ɖɩmʊ́sɩ nya, ɖɛ́vɛ́yɩ́na liideé nɖɔ́! Ngɛ ɖɛ́dɛ́ɛ fʊ́ńdɩ kpɩná rɩ́ŋa kpátáá wɛ́ńgɛɖɛɛ nyɔ́jɔ́ cé. Lɛlɛɛɖɔ́, ɖóógúti ɖáábá ɖɛ́vɛ́yɩ́na nabʊ́rʊ ɖʊɖɔ, asée ɖádɩtɩŋa na ɖɛ́dɛ́ɛ laadásɩ ɖábáásí. ");
INSERT INTO kdh_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Mɩ́nbɛɛŋ́ ɖáa na mɩ́ɩ́zá ɖɔ́ hálɩ ɖɩsɩ́? Ɩbaná ɖána ɖɛ́dɛ́ɛ laadásɩ mʊ́ʊ bɩka ɩfa ɖáa kíɖíím. A mɩ́ɩ́mʊ́ ɖáa bɩlɛ́, náńta ɖána ɖɛ́dɛ́ɛ laadásɩ ɖɔ́nvɔɔzɩ́ mɩ́ɩ bɩka ɖɩtɔlɩ́ nɛ́. Íkeyéle ɖɛ́dɛ́ɛ laadásɩ ɩwalɩ́ bɩwɩ́lɩ faala; ɩva ɖáa tɔsʊʊ́ ɖuɖúu.» ");
INSERT INTO kdh_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Nyɔɔ́sɩ waabá sɩcáárɩ hálɩ biiyéle báa awéní ɩkpɔ́ɔ ɩvásɩ ɩyá. Ngɛ Ísifu waamʊ Mɩ́sɩra laadásɩ rɩ́ŋa na Farawʊ́na yɩ́ɖɛ-daá. Bɩlɛ́ gɛ bɩɩlá Farawʊ́na iɖi Mɩ́sɩra tɛ́ɛ́dɩ rɩ́ŋa. ");
INSERT INTO kdh_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Ngɛ Ísifu wɔɔgbɔ́ɔ Mɩ́sɩra báa lé-dɛ́ɛ ɩráa ɩbɩsɩná yomáa. ");
INSERT INTO kdh_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Bɩɩga laadásɩ wensí siriké Ísifu tamʊ nɛ́ gɛ sarásɩ lanɖáa-dɛ́ɛ ńzɩ; káma, wɛ́ɖɛ neɖére wɛ bána Farawʊ́na bɔlɔwʊtáá sɩsɩ wánváa kʊ wɛ kíɖíídi. Bɩlɛ́ bʊrɔɔzɩ́ gɛ badayá bɛlɛ́ balaadásɩ. ");
INSERT INTO kdh_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Ngɛ Ísifu wɔɔdɔ́ Mɩ́sɩra ńba sɩsɩ: «Ńŋɩnáa máámʊ́ mɩ́ɩ mɩ́na mɩ́láádásɩ maɖʊ Farawʊ́na ndɛ́ nɛ́, bɛɛ tɔsʊʊ́ nɖɔ́, mɩ́nbɩɩzɩ́ iɖúu fásɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","A bɩgɛ́ɛ mɩ́ɩ́gɔ́nɩ ɩlɩzɩ́ kíɖíídi, mɩ́ndarɩ́ɩ bɩ nabʊ́nʊ́wá; Farawʊ́na-dɛ́ɛ, kʊ́ɖʊńbɩ, bɩka nabʊ́náázá bɩɩga nɛ́, bɩdaá gɛ mɩ́na míbíya na mɩ́dɛ́ɛ zamɔ́ɔ mínɖíi, bɩka ɩtɔ́sɩ.» ");
INSERT INTO kdh_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ísifu wɔɔdɔ́ wɛ bɩlɛ́ nɛ́, ngɛ boobúsi yɩ sɩsɩ: «Aayɩ́, nyɛ́ɛ́lɛ́ɛ ɖáa gɛ kʊ́bɔnɩ́. Báa nyééwíi ɖɔ́rɔ́ɔ́zɩ́ ɖɔ́ nɛ́, ɖéédísi sɩsɩ ɖánbɩsɩ́ Farawʊ́na-dɛ́ɛ yomáa.» ");
INSERT INTO kdh_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Bɩdɛ́ɛ tɔ́m tɩḿ gɛ Ísifu waajáŋ ɩkpɔ́ɔ ɩbɩsɩná mará; bɩcáŋ bɩcɔ́ɔ bɩlɛ́ hálɩ na sinje. Mɩ́sɩra tɛ́ɛ́dɩ-daá, báa weení gɛ waalɩzɩ́ kíɖíídi, asée ɩtára bɩ nabʊ́nʊ́wá gɛ, ɩkpɔ́ɔ kʊ́ɖʊńbɩ iboná Farawʊ́na. Sarásɩ lanɖáa riké-dɛ́ɛ fásɩ-rɔɔzɩ́ gɛ Farawʊ́na fɛ́yɩ́na yíko. ");
INSERT INTO kdh_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israyɛ́ɛlɩ ńba waadála Mɩ́sɩra nɛ́, Goséníi fáráńdɩ́ gɛ boozúu, bɩka bakpa laadásɩ. Bɔwɛ ńna nɛ́, baabá balʊ́rʊ ɖabata boyóózi bɔɖɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Bɩ́ɩ́zɩ ákɩzaalʊʊ́ na nasɩ́lɛ gɛ Yaakúbu wɔɔjɔ́ɔ Mɩ́sɩra. Wɔɔjɔ́ɔ ɖúúlínya-daá nɛ́, bɩ́ɩ́zɩ nɩɩ́nʊ́wá na nɛɛ́lɛ na lʊbɛ (147) gɛ waalá. ");
INSERT INTO kdh_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Sáátɩ wenkí waadɩlɩ́ sɩsɩ ɩdɛ́ɛ sɩ́m waajʊ́ʊ nɛ́, ngɛ weedíri bakáyáa ibiyaalʊ́ Ísifu ɩkɔ́nɩ. Ngɛ weevééri yɩ sɩsɩ: «A nyányɩ sɩsɩ nyáábá nyénwií mɔ́rɔ́, nkalɩ́ɩ mɔ́wɔ́rɔ́; mʊná nɖʊ nyánʊ́ʊ́nɩ móyúúre-dɛ sɩsɩ ńdénbiḿ ma Mɩ́sɩra laadɔ́ɔ-daá cé. ");
INSERT INTO kdh_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","A máázɩ́, lɩɩná ma Mɩ́sɩra tɛ́ɛ́dɩ, nboná ma ngébi majaájaanáa-dɛ́ɛ bɔɔláánɩ-daá.» Waaŋmátɩ bɩlɛ́ nɛ́ ngɛ Ísifu woobúsi yɩ sɩsɩ: «Máánɩ́ɩ, mónvúu malá wenbí ńŋɩnáa nyéévééri ma nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ńna gɛ Yaakúbu sɩsɩ: «Mʊná.» Ngɛ Ísifu waamʊná. Ngɛ Yaakúbu woozóm ɩdɛ́ɛ gáɖó kʊjʊʊ́-jɔ́ ikúu Ɩsɔ́ɔ tɛ́ɛ́dɩ. ");
INSERT INTO kdh_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Bɩlɛ́ bʊwɔ́rɔ́ gɛ bɔɔgɔ́nɩ befééri Ísifu sɩsɩ ɩjaa wánnyaadɩ́. Ngɛ wɔɔgbɔ́ɔ ibiyaalɩnáa Manasée na Efɩrayíim bɛɖɛ́ɛ ɩjaa-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Beevééri Yaakúbu sɩsɩ ibiyaalʊ́ Ísifu kɛgɛrɛŋɛ sɩ ɩsɛ́ɛ yɩ nɛ́, ngɛ waajáárɩ ɩdɩ ɩkʊrʊ́ ɩdɛ́ɛ gáɖó-rɔ ɩcɔ́ɔ igutoluú-rɔ. ");
INSERT INTO kdh_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ísifu waadála nɛ́, ngɛ ɩjaa wɔɔdɔ́ yɩ sɩsɩ: «Ɩsɔ́ɔ yíko-dʊ́ʊ waaɖʊ ɩlɩ́ɩ mɔ́rɔ́ Lúuzi, Kanáanɩ laadɔ́ɔ-daá ɩɖʊ ma alɩbáráka. ");
INSERT INTO kdh_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Wɔɔdɔ́ ma sɩsɩ ɩmʊ́ wánváa ma lʊrʊ́ʊ bɩɖɔ́ɔ, bɩka iyéle mabɩ́sɩ ɩráa zamɔ́ɔ-dʊ́ʊ. Mébíya-bíya gɛ ɩmʊ́ sɩ ɩfa laadɔ́ɔ kana sinje hálɩ ceré.» ");
INSERT INTO kdh_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ngɛ Yaakúbu waadásɩ ɩtɔ́ Ísifu sɩsɩ: «Nyááná nyébíya nɔɔ́lɛ bana nyáálʊ́rʊ wɛ Mɩ́sɩra naanɩ́ mɔgɔ́nɩ mɔmɔɔná nya nɛ́, bɛlɛ́, mebiyaalɩnáa nbɩlɛ́. Efɩrayíim na Manasée, mɔ́ɔ́ mádɩɩná bɛlɛ́ ńŋɩnáa mádɩɩná Rʊ́bɛ́ɛnɩ na Simeyɔ́ɔnɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Amá, bíya sɩ ngɔ́nɩ nlʊ́rʊ wɛ bʊwɔ́rɔ́ nɛ́ gɛ nyɛ́dɛ́ɛ ńba. Baɖawaalɩnáa-dɛ́ɛ laadɔ́ɔ-daá gɛ bɛḿ ɖʊɖɔ bɛdɛ́ɛ tííbí wɛ. ");
INSERT INTO kdh_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Máagágʊrʊ́ Padan-Aráamɩ mɛ́ngɛɖɛɛ́ nɛ́, bɩ́ńgáa cʊ́kɔ na madála Efɩráatɩ tɛ́ɛ́dɩ Kanáanɩ laadɔ́ɔ-daá gɛ ngɔɔ Rasɩ́ɩ́la waazɩ́ mánʊ́ʊ́zɩ-daá. Ńna gɛ méébí yɩ nɩ́bááwʊ kpɔ́mɔ́ɔ́.» Efɩráatɩ gɛ bánÿaá lɛlɛɛɖɔ́ sɩsɩ Bɛtɩlɛhɛ́ɛm. ");
INSERT INTO kdh_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ńna gɛ Yaakúbu Israyɛ́ɛlɩ waagʊ́sɩ ɩna Ísifu biyaalɩnáa, ngɛ wɔɔbɔ́ɔ́zɩ sɩsɩ: «Wenbá gɛ bana.» ");
INSERT INTO kdh_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Ngɛ Ísifu woobúsi yɩ sɩsɩ: «Bíya wenbá Ɩsɔ́ɔ waava ma wɛ Mɩ́sɩra cénjé nɛ́ nbɩlɛ́.» Ngɛ sɩsɩ: «Koduuzi wɛ mɔ́jɔ́ mogóóri mava wɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Israyɛ́ɛlɩ waabá ɩbɩ́ɩ ábɔ́nɩ́ páá, biiyéle waazá tɛfɛ́yɩ́ fɩ́ya ɖʊɖɔ; ɩ́dándanáa kazɔ́ɔ. Ngɛ Ísifu woogóduuzi ibiyaalɩnáa ɩjaa-jɔ́. Ngɛ ɩlɛ́ waaɖʊ wɛ ndɛ́, ikpíriki wɛ. ");
INSERT INTO kdh_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ngɛ wɔɔdɔ́ Ísifu sɩsɩ: «Ɖoo mádafʊ́ńɖʊʊ tamɔ́ɔ ɖʊɖɔ sɩsɩ wɩ́rɛ mánnáa nyáázɩ́rɛ-daá. Amá, Ɩsɔ́ɔ weeyéle mana nya, hálɩ mana nyébíya.» ");
INSERT INTO kdh_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ngɛ Ísifu waagʊ́sɩ ibiyaalɩnáa ɩjaa nʊvɔ́-rɔ. Ngɛ weedí ɩwááwʊ ɩjaa ɩzá-daá adɛ. ");
INSERT INTO kdh_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ngɛ wɔɔɖɔ́kɩ Efɩrayíim na ɩnʊ́ʊ́nɩ kíɖiiwú, ɩbɩsɩná ɩjaa-dɛ́ɛ nʊ́ʊ́nɩ nɩbɩɩwʊ́-rɔ; bɩka ɩɖɔ́kɩ Manasée na ɩnʊ́ʊ́nɩ nɩbɩɩwʊ́ ɩbɩsɩná ɩlɛ́ ɩjaa-dɛ́ɛ nʊ́ʊ́nɩ kíɖiiwú-rɔ. Ngɛ woogóduuzi wɛ batɩlɩná bajaa kʊ́bɔnɩ́ Israyɛ́ɛlɩ. ");
INSERT INTO kdh_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ngɛ ɩlɛ́ wɛɛgɛ́ɛ́zɩ ɩnʊ́ʊ́zɩ, ɩkpɔ́ɔ nʊ́ʊ́nɩ kíɖiiwú ɩtɩ́nɩ Efɩrayíim-rɔ, ngʊ́ ɩlɛ́ gɛ bú; ngɛ waadɩ́nɩ ɩnʊ́ʊ́nɩ nɩbɩɩwʊ́ Manasée-rɔ. Bɩka ɩlɛ́ gɛ kʊ́bɔnɩ́. ");
INSERT INTO kdh_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Nʊ́ʊ́zɩ wɛ sɩjɔɔ́ɔ bɩlɛ́ gɛ woogóóri ɩfa Ísifu sɩsɩ: «Bíya bana, mánzʊlʊ́ʊ Ɩsɔ́ɔ majaájaa Ibrahím na majaa Ɩsaáka boovu ɩnɩ́bááwʊ nɛ́; Ɩsɔ́ɔ weení weegéti ma ɖoo bɩrɩ́ŋa nɛ́; ");
INSERT INTO kdh_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","malááyɩ́ka weení woovu ma ásíírí nɔwɛ́yawá rɩ́ŋa-daá nɛ́, mánzʊlʊ́ʊ sɩsɩ ɩ́ɖʊ́ wɛ alɩbáráka. Bɔ́ɖɔkɩ máyɩ́ɖɛ, bɔɖɔ́kɩ majaa Ɩsaáka na majaájaa Ibrahím bayɩrá. Bálʊrʊ bɩlʊ́rʊ bɩɖɔ́ɔ laadɔ́ɔ rɩ́ŋa-rɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Israyɛ́ɛlɩ-dɛ́ɛ wɔɔgbɔ́ɔ ɩnʊ́ʊ́nɩ kíɖiiwú ɩtɩ́nɩ Efɩrayíim kʊjʊʊ́-rɔ nɛ́ waajáárɩ Ísifu páá. Waana waadɩ́nɩ ɩnʊ́ʊ́zɩ bɩlɛ́ nɛ́ gɛ wɛɛgbɛdɩ́ ɩkʊ́sɩ ɩjaa nʊ́ʊ́nɩ kíɖiiwú ɩmʊ́ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","«Aayɩ́, bɩdɛkɛ́ɛ bɩlɛ́ baabá, ceení gɛ kʊ́bɔnɩ́, tɩnɩ nyánʊ́ʊ́nɩ kíɖiiwú ɩlɛ́ ɩgʊjʊʊ́-rɔ.» ");
INSERT INTO kdh_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Amá, ɩjaa weegízi sɩsɩ: «Móbú, mányɩ. Manasée ɖʊɖɔ-dɛ́ɛ bíya sɩ bɔkɔ́nɩ babɩ́sɩ zamɔ́ɔ gɛ; iɖi kʊ́bɔńdɩ, na bɩrɩ́ŋa, inewú wángɩlɩ́ɩ yɩ kʊ́bɔńdɩ, bɩka newúu ɩmʊ́ ɩdɛ́ɛ lʊrʊ́ʊ-daá ɩráa ɩkɔ́nɩ babɩ́sɩ yíriwá ɖabata.» ");
INSERT INTO kdh_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Bɩdɛ́ɛ wɩ́rɛ nɛ́, wenbí waaŋmátɩ ɩɖʊ wɛ alɩbáráka nɛ́ nɖɔ́ sɩsɩ: «Mɩ́yɩ́rá gɛ Israyɛ́ɛlɩ bíya sɩ baɖʊná ɖamá alɩbáráka. Bángʊrʊ́ʊ sɩ baŋmátɩ nɛ́, bɔ́ndɔ́m gɛ sɩsɩ: “Ɩsɔ́ɔ ɩ́la bɩlɩɩná Efɩrayíim na Manasée bɛdɛ́ɛ alɩbáráka-daá.”» Bɩlɛ́ gɛ waaŋmátɩ ɩkpɔ́ɔ Efɩrayíim ɩtɛ́ɛ́zɩ Manasée nɩ́bááwʊ. ");
INSERT INTO kdh_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ngɛ wɔɔdɔ́ Ísifu sɩsɩ: «Mɔ́jɔ́ɔ ɖɔ́ nɛ́, mɛ́dɛ́ɛ sɩ́m waajʊ́ʊ; amá, Ɩsɔ́ɔ wánzɩnáa mɩ́ɩ; ɩláázɩ mɩ́ɩ ɩbɩ́sɩ mɩ́jaájaanáa-dɛ́ɛ laadɔ́ɔ-daá. ");
INSERT INTO kdh_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Mánváa nya laadɔ́ɔ bɩcɛzɩ́ nɖawaalɩnáa-dɛ́ɛ; kanáábɩ́lɛ́ tɛ́ɛ́dɩ móóyóóná tókobí na tɔ́ɔ́wʊ meɖi Amɔ́ɔrɩ ńba mɛlɛ́ɛ tɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Bɩjɔɔ́ɔ nɛ́, ngɛ Yaakúbu waayáa ibiyaalɩnáa ɩtɔ́ wɛ sɩsɩ: «Idúúzi ɖamá, na mevééri mɩ́ɩ wenbí sɩ bɩkɔ́nɩ bʊkɔ́mɔ́ɔ́ná mɩ́ɩ ceré wɔ́rɔ́ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Bɔɔgɔ́nɩ nɛ́, ngɛ sɩsɩ: «Mébíya, idúúzi ɖamá iwélesi ɩnɩ́ɩ mɔ́ɔ́ mɩ́jaa Israyɛ́ɛlɩ sɩ maŋmátɩ mɩ́ɩ wentí nɛ́: ");
INSERT INTO kdh_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Nyɔ́ɔ́ Rʊ́bɛ́ɛnɩ, nyánáábɩ́lɛ́ móbú kʊ́bɔnɩ́ mááɖáa yɩ lʊrʊ́ʊ mɛ́dɛ́ɛ afobire-daá nɛ́. Nyáágɩ́lɩ nyénewáa rɩ́ŋa ɖóni na kʊ́bɔńdɩ. ");
INSERT INTO kdh_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Amá, nyáágɩ́lɩ kiri-kiri nyazɩ lɩ́m ɖóni ńbɩ. Bɩlɛ́ nɛ́, ńdóndoyuú kʊ́bɔńdɩ, káma, nyáávɩ́nɩ́ná mɛ́dɛ́ɛ aláa-daá naárʊ máɖaavɩnɩɖɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Mɩ́nyɔ́ɔ́ Simeyɔ́ɔnɩ na Léévi; mɩ́gɔɔ kʊ́ɖʊḿ gɛ, lakásɩ tɩtɛ ńzɩ gɛ mɩ́ɩ́lá ná mɩ́zɛ́ɛ́zɩ. ");
INSERT INTO kdh_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Módónvúu mɩ́lakásɩ ngʊ́ bɩlɛ́ gɛ mádánzʊʊ mɩ́dɛ́ɛ nɔɔdaka-daá; káma, mɩ́dɛ́ɛ baaná-daá, mɩ́ɩ́gʊ́ ɩráa, ɩlá tɩtɛ lakásɩ ɩcɛ́ náánɩ abaaláa fɩ́ya ńdɩ nʊvɔdolá. ");
INSERT INTO kdh_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Máálá mɩ́dɛ́ɛ baaná tɩtɛ ńgɩ láálɩ́; malá mɩ́dɛ́ɛ ɩzɩ́sɛɛmɩ́rɛ láálɩ́. Mánÿaazɩ́ míbíya-bíya málaadɔ́ɔ rɩ́ŋa-daá. Báyá ɖamá Israyɛ́ɛlɩ laadɔ́ɔ rɩ́ŋa-daá. ");
INSERT INTO kdh_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Nyɔ́ɔ́ Yudáa, ngoobíya sɩ bɔkɔ́nɩ gɛ betée yéńdi baɖára nya. Sɩ ngɔ́nɩ gɛ njáárɩ nyábáɖaanáa bolúúzi badɩ nyáázá-daá; bɩka njaa-dɛ́ɛ bíya ɩkɔ́nɩ bosóm nyáázá-daá ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Mebiyaalʊ́ Yudáa, nyɔ́jɔɔ́ɔ gɛ nyazɩ guunivalʊ́ wángbáa fanaḿ kɩtɔ́ɔ na kɩbɩ́sɩ kɩraazʊʊɖɛ́ nɛ́. Gúúní wángám kɩɖʊná-rɔ gɛ na kɩfɩ́nɩ. A kɩɩvɩ́nɩ, awéní wánbɩɩzɩ kʊ ɩkʊ́sɩ kɩ. ");
INSERT INTO kdh_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Kowuro-ɖooriká wɔ́nlɔwʊ́ʊ nyɔ́ɔ́ Yudáa nyóɖúgoré-daá; ngɛ nyébíya‑bíya ndɛ́ gɛ kowuro-ɖɛ́nɩ sɩ ɩwalɩ́ hálɩ bɩtála wɩ́rɛ wenɖé ɩdʊ́ʊ sɩ ɩtála nɛ́. Ɩlɛ́ ɩmʊ́ ɩdɛɛzɩ́ gɛ ɖúúlínya ɩráa rɩ́ŋa sɩ bɔkɔ́nɩ bosóm. ");
INSERT INTO kdh_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Sɩ bɩkɔ́nɩ gɛ bɩlá nyánɖɩnáa nyágbangbɔ́ɔ víinyi fɔɖásɩ bɩka nɖɩná kpangbɔ́ɔ-bú víinyi wɩlɛnísi. Víinyi sʊlʊ́m-daá gɛ sɩ ngɔ́nɩ ngbéézi nyágbɩná kúsuuyé; bɩka ngbéézi nyɛ́dɛ́ɛ kosúu katɩ́nɩ kɩdɛ́ɛ bíya lɩ́m-daá. ");
INSERT INTO kdh_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Nyáázá-bíya-ɖée kazɔ́ɔ wángɩlɩ́ɩ víinyi sʊlʊ́m-dɛ́ɛ ńbɩ, bɩka nyágálá ɩfʊ́lʊ bɩkɩ́lɩ naalɩ́m fʊlʊmɩ́nɩ. ");
INSERT INTO kdh_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Nyɔ́ɔ́ Zabulɔ́ɔnɩ, tenkú kidiríni-jɔ́ gɛ sɩ ngɔ́nɩ njɔ́ɔ, ńna gɛ mɛ́ɛ́lɛwá sɩ tɩkɔ́nɩ tɩ́nzɩŋ́; bɩka nyɛ́dɛ́ɛ́dɩ ɩfɔ bɩlɛ́ hálɩ Sidɔ́ɔnɩ. ");
INSERT INTO kdh_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakáarɩ, nyɔ́ɔ́ nyɛ́gɛ́ɛ na kpangbɔ́ɔ fɩ́ya ńga kónɖóm kárɔɔ́wá nasɩ́lɛ lɔwʊtáá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Nyááná sɩsɩ ɖɩdáarɛ sɩ njɔ́ɔ ɖɩdaá nɛ́ ɖɩjɔɔ́ɔ kazɔ́ɔ, ngɛ tɛ́ɛ́dɩ tɩḿ ɖʊɖɔ tɩjɔɔ́ɔ yáásɩ́. Nyáámʊ́ sʊʊ́tɩ ndɩ́nɩ nyáváámʊ́ʊ-rɔ; ngɛ nyéédísi nlá yomáa tɩmɛ́rɛ. ");
INSERT INTO kdh_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Nyɔ́ɔ́ Dáanɩ, sɩ ngɔnɩ ná nvʊʊná nyɛ́dɛ́ɛ ɩráa tɔ́m ńŋɩnáa Israyɛ́ɛlɩ agó aaganáa sɩ alá bɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Nyɔ́ngɔnɩ́ nbɩ́sɩ gɛ nyazɩ nɩ́bááwʊ-daá ɖoḿ; bɔɔzɩ́rɛ ɖilewáa nɩ́bááwʊ kpɔ́mɔ́ɔ́ nɛ́. Bɔɔzɩ́rɛ ɖɩḿ ɖɩ́nnyasɩ́ ɖeére nʊvɔdóle na ɖɩdʊ́ʊ ɩkɔrɩ́ ɩsála lééléé. ");
INSERT INTO kdh_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ówu Mádʊ́ʊ Ɩsɔ́ɔ, nyánáábɩ́lɛ́ mɔ́jɔɔ́ɔna tamɔ́ɔ sɩsɩ nyɛ́nlɛɛ́ ɖáa. ");
INSERT INTO kdh_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Nyɔ́ɔ́ Gaádɩ, yooráa wánlɩɩ́ nyɔ́rɔ́, amá, nyɔ́nɖɔwʊ́ʊ wɛ. ");
INSERT INTO kdh_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Nyɔ́ɔ́ Asɛ́ɛrɩ, nyálaadɔ́ɔ sɩ kabá gɛ kalá kíɖíím kazɔ́ɔ ńbɩ; wúrowá kíɖíím gɛ sɩ kalá. ");
INSERT INTO kdh_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nyɔ́ɔ́ Nɛfɩtalíi, nyɛ́gɛ́ɛ koluú kʊwɛ kɩdɩ kɩrɔ kɩ́nɖʊ́ʊ bíya kazɔ́ɔ ńba nɛ́ gɛ ");
INSERT INTO kdh_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Nyɔ́ɔ́ Ísifu, nyɔ́jɔɔ́ɔ gɛ nyazɩ tiyɔ́ɔ kánzɩŋ́ buwá kʊjʊʊ́-rɔ nɛ́. Kɛdɛ́ɛ wʊláázɩ wángbáa bɩfɛ́lɛ koláázɩ. ");
INSERT INTO kdh_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Tɔ́ɔ́nɩ-dɩnáa woojóódi nya hálɩ bɔtɔ nya nyɩmɛ́, boyóo nya; ");
INSERT INTO kdh_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","amá, Yaakúbu-dɛ́ɛ Ɩsɔ́ɔ ɖóni-dʊ́ʊ, ɩgɛ́ɛ Israyɛ́ɛlɩ ńba-dɛ́ɛ ketirú na bɛdɛ́ɛ bʊ́tangbalʊʊ́ nɛ́ ɩdɛ́ɛ yíko-daá, bɔdɔ́ɔ́nɩ waawɩ́ɩ koodí, banára hálɩ bovolá ɩbáázɩ selíi. ");
INSERT INTO kdh_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Njaa-dɛ́ɛ Ɩsɔ́ɔ sɩ ɩsɩná na nya; Ɩsɔ́ɔ ɖóni-dʊ́ʊ ɩmʊ́ sɩ ɩɖʊ ná nya alɩbáráka; adɛ-dɛɛzɩ́-dɛ́ɛ alɩbáráka ɩ́kpá nyɔ́rɔ́, bɩka ɩsɔ́ɔ́dáá ńgɩ ití nyɔ́rɔ́. Ɩsɔ́ɔ ɩ́ɖʊ́ nya lʊrʊ́ʊ-dɛ́ɛ alɩbáráka, bɩka ɩɖʊ nyávʊ́ńdɩ kpɩná ɖʊ́ʊ-dɛ́ɛ alɩbáráka. ");
INSERT INTO kdh_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Njaa-dɛ́ɛ alɩbáráka waagɩ́lɩ caanawʊ́ bʊ́ʊ́nɩ na wenbí bɩrɩ́ŋa booyuú tɩdaá nɛ́. Nyɔ́ɔ́ Ísifu weení nyénɖíi kʊ́bɔńdɩ ngoobíya-rɔ nɛ́, alɩbárákawá tɩḿ títi nyágʊjʊʊ́-daá. ");
INSERT INTO kdh_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Bɛ́ɛnɩ-Yáámíínu, nyɛ́gɛ́ɛ káwʊkáwʊ fɩ́ya ńgɩ gɛ; tɛ́ɛrɛ́ gɛ nyéngbím fanáńdɩ ndɔ́ɔ, na ɖaanɩ́ŋa nɛ́, ndára nyóóyúú bɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Tɔ́ɔ, wenbá booyóózi bama Israyɛ́ɛlɩ agó fuú na náálɛ nɛ́ nbɩlɛ́, bɩka alɩbáráka bajaa waaɖʊ badaá báa weení nɛ́ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Bʊwɔ́rɔ́ nɛ́, ngɛ Yaakúbu waazɩ́ɩ́zɩ ibíya tɔ́mwá tɩna ɖɔ́ sɩsɩ: «Méngbém mɔgɔ́mɔ́ɔ́ná kʊ́bɔnáa, a máázɩ́, iboná ma ikébi majaájaanáa-dɛ́ɛ bʊ́tangbalʊʊ́ bɔɔlááwʊ-daá. Bɔɔlááwʊ kɩḿ kʊgɔwɛ Efɩrɔ́ɔnɩ Hitíi ńnɩ́-dɛ́ɛ fɔɔ́ ");
INSERT INTO kdh_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","bánÿaá kɛ Makpéela nɛ́ kadaá gɛ; kadɩláána Mamɩrée gɛ Kanáanɩ laadɔ́ɔ-daá. Fɔɔ́ kɛḿ nɛ́, Ibrahím waamʊ ná kɛ Efɩrɔ́ɔnɩ ńnɩ́ ɩmʊ́ ɩjɔ́ kabɩ́sɩ ɩdɛ́ɛ ɩráa ɖaabimɖé. ");
INSERT INTO kdh_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Waazɩ́ nɛ́, ńna gɛ beebí yɩ ɩ́na ɩɖɛɛlʊ́ Saráa. Ńna ɖʊɖɔ gɛ beedébiḿ ibiyaalʊ́ Ɩsaáka na ɩɖɛɛlʊ́ Rebééka; ńna ɖʊɖɔ gɛ mádɩtɩŋa méébí mɛɖɛɛlʊ́ Léya. ");
INSERT INTO kdh_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Fɔɔ́ kɛḿ na kɛdɛ́ɛ bʊ́tangbalʊʊ́ bɔɔwʊ́ nɛ́, Hitíi bíya-jɔ́ gɛ baamʊ kɛ.» ");
INSERT INTO kdh_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yaakúbu waajáŋ ɩwɩ́lɩ ibiyaalɩnáa bɩlɛ́ bɩtɛ́ nɛ́, ngɛ waabɩ́sɩ ití ɩfɩ́nɩ, ɩcáŋ itísi weezuú, ibó ɩkɔ́mɔ́ɔ́ná kʊ́bɔnáa. ");
INSERT INTO kdh_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yaakúbu waazɩ́ bɩlɛ́ nɛ́, ngɛ ibiyaalʊ́ Ísifu wɛɛjɛ́ ɩsála ɩrɔɔzɩ́ ikpíriki yɩ na nzʊlʊ́m. ");
INSERT INTO kdh_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ngɛ wɔɔdɔ́ ɩdɛ́ɛ lákʊ́tawá sɩsɩ bákpɩɩrɩ ɩjaa Israyɛ́ɛlɩ basaárɩ yɩ faadɩ́nɩ kʊ́wɩlɩsɩ́tɩ; ngɛ bɛlɛ́ baazaárɩ yɩ. ");
INSERT INTO kdh_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Wɛ́ nɛɛ́lɛ (40) gɛ baagbɩɩrɩ ná ɩdɔnʊʊ́ ńŋɩnáa bɩɩbɔ́ɔ́zɩ nɛ́. Ngɛ Mɩ́sɩra ńba wɔɔjɔ́ɔ Yaakúbu-dɛ́ɛ lííya wɛ́ niídoozo na saaláa (70). ");
INSERT INTO kdh_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Lííya wɛɛdɛ́ nɛ́, ngɛ Ísifu wɔɔdɔ́ Farawʊ́na-dɛ́ɛ awóronbíya sɩsɩ: «A mɩ́zɔɔlɛ́ɛ ma, ɩlá suúru ibó ifééri wúro Farawʊ́na wentí sɩ mevééri mɩ́ɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","“Naanɩ́ majaa ɩsɩ́ nɛ́, weeyéle mamʊná sɩsɩ a ɩmʊ́ waazɩ́, móbóná ɩmʊ́ Kanáanɩ laadɔ́ɔ-daá bɔɔlááwʊ waagbɩ́ɩ́rɩ kɩ ɩsɩ́ɩ ɩdɩ nɛ́ megébi yɩ kɩdaá. Bɩlɛ́ nɛ́, ɩ́fá ma nɩ́bááwʊ mobó megébi yɩ lɛlɛɛɖɔ́ na magábɩsɩ.”» ");
INSERT INTO kdh_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Boobó befééri Farawʊ́na nɛ́, ngɛ ɩlɛ́ weedísi sɩsɩ íbo ikébi ɩjaa ńŋɩnáa wenbí wooɖuuná yɩ bɩ ɩsɩ́ɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Ngɛ Ísifu waagʊrʊ́ ɩkpɔ́ɔ nɩ́bááwʊ ɩɖɛ́ɛ ɩjaa bím. Sɩ ɩɖɛ́ɛ nɛ́, Farawʊ́na-dɛ́ɛ awóronbíya na ɩdɛ́ɛ ɖaána-daá kʊ́bɔnáa na Mɩ́sɩra tɛ́ɛ́dɩ-daá kʊ́bɔnáa, ");
INSERT INTO kdh_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","na ɩmʊ́ Ísifu ɩdɛ́ɛ ɖaána-daá ńba rɩ́ŋa na igoobíya kʊ́bɔnáa na ɩjaagoobíya-daá ńba nɔɔ́-nɔɔ́ waalaazɩ ná yɩ. Wenbá bɩɩga wɛ Goséníi tɛ́ɛ́dɩ-daá bodobó nɛ́, a bɩdɛkɛ́ɛ bíya, asée fʊ́ńdɩ kpɩná. ");
INSERT INTO kdh_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Bɛdɛ́ɛ boɖé ɖɩḿ ɖɩdaá, awéńja tuuríni na awéńja gɛ bɛɛɖɛɛná. Ngɛ zamɔ́ɔ waabá kɩɖɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Baajʊʊná Yɔrɔdáanɩ buwá nɛ́, Atáadɩ kíɖíídi ɖaamasɩɖɛ́ gɛ bɔɔjɔ́ɔ wɛ́ lʊbɛ babá bewíi lííya kalá yíni bɔtɔ́ɔ́zɩ ɩsɩɖʊ́-rɔ. ");
INSERT INTO kdh_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kanáanɩ ńba bɔwɛ lɔwʊtáá ńna nɛ́, baana baalá lííya nɛ́, ngɛ bɔɔdɔ́ sɩsɩ: «Lííya kana kaabá kɛgɛ́ɛ Mɩ́sɩra lííya kʊ́bɔńga gɛ.» Bʊrɔɔzɩ́ gɛ baava Yɔrɔdáanɩ buwá ɖɩdáarɛ ɖɩḿ yɩ́ɖɛ sɩsɩ Abɛ́ɛlɩ-Mɩsɩrayím; bugutoluú sɩ bɩlɩ́ɩ gɛ sɩsɩ «Mɩ́sɩra lííya». ");
INSERT INTO kdh_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Bɩlɛ́ gɛ Yaakúbu biyaalɩnáa waalá wenbí bajaa waavʊ́ńdɔḿ wɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Bɔɔgbɔ́ɔ yɩ boboná Kanáanɩ laadɔ́ɔ-daá Makpéela fɔɔ́ kajʊ́ʊ́na Mamɩrée Ibrahím waamʊ kɛ Hitíi ńnɩ́-jɔ́ wénbím ɩdɛ́ɛ ɩráa nɛ́ kɛdɛ́ɛ bɔɔlááwʊ-daá bekébi. ");
INSERT INTO kdh_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Ísifu weebí ɩjaa bɩtɛ́ nɛ́, ngɛ ɩ́na igoobíya na wenbá barɩ́ŋa kpátáá baaláázɩ wɛ nɛ́, bɔɔlɔ́ɔ bakábɩsɩ Mɩ́sɩra. ");
INSERT INTO kdh_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ísifu igoobíya waana sɩsɩ bajaa waazɩ́ nɛ́, ngɛ sɩsɩ: «Ɖájaa waazɩ́ ɖɔ́ nɛ́, a lɛlɛɛɖɔ́ gɛ Ísifu wɛɛyɛɛná ɖáa baaná sɩsɩ ɩmʊ́ wɛ́nvɛrɩ́ɩ ɖáa wenbí bɩrɩ́ŋa ɖáálá yɩ nɛ́, nŋɩ́nɩ́ gɛ sɩ ɖɩlá.» ");
INSERT INTO kdh_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ńna gɛ beedíri bekéveeri yɩ sɩsɩ: «Naanɩ́ njaa ɩsɩ́ nɛ́, nɔɔ́ wenká waadásɩ kɛ nɛ́ nɖɔ́: ");
INSERT INTO kdh_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Wɔɔdɔ́ gɛ sɩsɩ: “Ivééri ma Ísifu sɩsɩ ɩ́nɩɩ ɩɖawaalɩnáa kʊnyɔḿ, bɩka ɩcɛ́ wɛ taalɩ́ kidaavéénúu wenkí baalá yɩ nɛ́; na wenbí bɩrɩ́ŋa baalá yɩ bɩdakazɔ́ɔ nɛ́.” Bɩlɛ́ nɛ́, la suúru njɛ́ ɖáa, ɖɔ́ɔ́ wenbá ɖána njaa ɖɛ́nzɛɛ́ Ɩsɔ́ɔ kʊ́ɖʊḿ nɛ́.» Ísifu waanɩ́ɩ tɔ́m tɩna nɛ́, ngɛ waabáázɩ wíídi. ");
INSERT INTO kdh_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ngɛ igoobíya bɛḿ badɩtɩŋa bɔɔgɔ́nɩ bɛcɛ́ basála waazá-daá sɩsɩ: «Ɖáábɩ́sɩ nyɛ́dɛ́ɛ yomáa.» ");
INSERT INTO kdh_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Amá, Ísifu sɩ ibúsi wentí nɛ́ gɛ sɩsɩ: «Bɩ́kalá mɩ́ɩ nɩdáárɛ; mɛ́dɛkɛ́ɛ Ɩsɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Mɩ́ɩ́zɔ́ɔ́lɩ sɩ ɩlá ma kidaavééníti, amá, Ɩsɔ́ɔ wɔɔgbɔ́ɔ tɩ ɩbɩsɩná kazɔ́ɔ ńbɩ. Ɩráa ɖabata weezíni gɛ wɔɔzɔ́ɔ́lɩ sɩ ɩlɛ́ɛ; bɩnáábɩ́lɛ́ sinje mɩ́nnáa ɖɔ́. ");
INSERT INTO kdh_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Bɩlɛ́ nɛ́, nabʊ́rʊ ɩ́kalá mɩ́ɩ nɩdáárɛ; mɛ́nbɛɛŋ́ mɩ́na mɩ́dɛ́ɛ zamɔ́ɔ mɩ́rɔ́.» Ísifu-dɛ́ɛ ŋmatɩrɛ ɖɩna ɖɩɩvɛ́ɛ́zɩ igoobíya wenbé. ");
INSERT INTO kdh_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Tɔ́ɔ, wenbí Ísifu na ɩjaa na ɩdɛ́ɛ ńba bɔɔjɔɔná bɩ Mɩ́sɩra laadɔ́ɔ-daá nɛ́ nbɩlɛ́. Ísifu wɔɔjɔ́ɔ nɛ́, ɩwɛná bɩ́ɩ́zɩ nɩɩ́nʊ́wá na saaláa (110). ");
INSERT INTO kdh_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Waana Efɩrayíim bíya-bíya igúti bebíya, ɩna Manasée biyaalʊ́ Makíiri hálɩ ɩɖɔ́kɩ ɩlɛ́ ibíya. ");
INSERT INTO kdh_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Naanɩ́ Ísifu ɩsɩ́ nɛ́, wɔɔdɔ́ igoobíya gɛ sɩsɩ: «Mɔ́jɔɔ́ɔ ɖɔ́ nɛ́, mánzɩ́m; amá, mányɩ sɩsɩ Ɩsɔ́ɔ wánzɩnáa mɩ́ɩ ɩlɩ́ɩ Mɩ́sɩra laadɔ́ɔ-daá cé ibó tɛ́ɛ́dɩ wentí waavʊ́ńɖúu ɩsɩ́ɩ Ibrahím, Ɩsaáka na Yaakúbu nɛ́ tɩdaá. ");
INSERT INTO kdh_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Bɩlɛ́ nɛ́, mɩ́ɩ Israyɛ́ɛlɩ bíya, iɖuuná sɩsɩ a Ɩsɔ́ɔ waazɩná mɩ́ɩ bɩlɛ́, mɩ́ngbɛdɩ́na mɛ́dɛ́ɛ mʊwá ɩɖɛɛná.» ");
INSERT INTO kdh_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ísifu wooyuú bɩ́ɩ́zɩ nɩɩ́nʊ́wá na saaláa (110) ngɛ waazɩ́. Waazɩ́ nɛ́, ngɛ baazaárɩ ɩdɔnʊʊ́ faadɩ́nɩ kʊ́wɩlɩsɩ́tɩ. Bɩɩdɛ́ nɛ́, ngɛ bɛɛzɛlɩ́ yɩ boboná baɖʊ aɖákaá-daá basɩ́ɩ Mɩ́sɩra ńna.");
INSERT INTO kdh_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yeésu Krísto caájaanáa yɩrá nɖɔ́: Ɖáwʊɖa gɛ Yeésu Krísto ɩjaájaanáa ɩjaa, bɩka Ibrahím gɛ Ɖáwʊɖa ɩjaájaanáa ɩjaa. ");
INSERT INTO kdh_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibrahím waalʊ́rʊ Ɩsaáka, Ɩsaáka ɩlʊ́rʊ Yaakúbu, Yaakúbu ɩlʊ́rʊ Yudáa na igoobíya. ");
INSERT INTO kdh_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yudáa ɩlɛ́ waalʊ́rʊ Farɛ́ɛsɩ na Zaará (bɛlɛ́ bɔgɔɔ gɛ Tamáarɩ), Farɛ́ɛsɩ waalʊ́rʊ Ɛsɩrɔ́ɔnɩ, Ɛsɩrɔ́ɔnɩ ɩlʊ́rʊ Aráamɩ. ");
INSERT INTO kdh_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aráamɩ waalʊ́rʊ Aminadáabɩ, Aminadáabɩ ɩlʊ́rʊ Nasɔ́ɔnɩ, Nasɔ́ɔnɩ ɩlɛ́ waalʊ́rʊ Salɩmɔ́ɔnɩ; ");
INSERT INTO kdh_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salɩmɔ́ɔnɩ waalʊ́rʊ Bóozɩ, ɩlɛ́ ɩgɔɔ gɛ Ráábí. Bóozɩ waalʊ́rʊ Obɛ́ɛdɩ, ɩlɛ́ ɩgɔɔ gɛ Ruwétu. Obɛ́ɛdɩ waalʊ́rʊ Yesée. ");
INSERT INTO kdh_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesée waalʊrʊ ná wúro Ɖáwʊɖa. Ɖáwʊɖa waalʊ́rʊ Sulemáana (ɩlɛ́ ɩgɔɔ fʊngɛ́ɛ na Uríi ɖɛɛlʊ́). ");
INSERT INTO kdh_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sulemáana waalʊ́rʊ Robowáamɩ, Robowáamɩ ɩlʊ́rʊ Abiyáa, Abiyáa ɩlʊ́rʊ Azáa. ");
INSERT INTO kdh_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Azáa waalʊ́rʊ Yosafáatɩ, Yosafáatɩ ɩlʊ́rʊ Yoráamɩ, Yoráamɩ ɩlʊ́rʊ Oziyáasɩ. ");
INSERT INTO kdh_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Oziyáasɩ waalʊ́rʊ Yowatáanɩ, Yowatáanɩ ɩlʊ́rʊ Akáazɩ, Akáazɩ ɩlʊ́rʊ Ezekíyáasɩ. ");
INSERT INTO kdh_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekíyáasɩ waalʊ́rʊ Manasée, Manasée ɩlʊ́rʊ Amɔ́ɔnɩ, Amɔ́ɔnɩ ɩlʊ́rʊ Yoziyáasɩ. ");
INSERT INTO kdh_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yoziyáasɩ waalʊ́rʊ Yokoniyáasɩ na igoobíya. Bɩdɛ́ɛ sáátɩ gɛ baagba Israyɛ́ɛlɩ bíya bɛɖɛɛná Babilɔ́ɔnɩ laadɔ́ɔ-daá. ");
INSERT INTO kdh_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bɛɛɖɛɛná Israyɛ́ɛlɩ bíya Babilɔ́ɔnɩ wɔ́rɔ́ nɛ́, Yokoniyáasɩ waalʊ́rʊ Salatɩyɛ́ɛlɩ, Salatɩyɛ́ɛlɩ ɩlɛ́ ɩlʊ́rʊ Zorobabɛ́ɛlɩ. ");
INSERT INTO kdh_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabɛ́ɛlɩ waalʊ́rʊ Abiwúudi, Abiwúudi ɩlʊ́rʊ Eliyakíimi, Eliyakíimi ɩlʊ́rʊ Azɔ́ɔrɩ. ");
INSERT INTO kdh_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azɔ́ɔrɩ waalʊ́rʊ Sadɔ́ɔkɩ, Sadɔ́ɔkɩ ɩlʊ́rʊ Akíimi, Akíimi ɩlʊ́rʊ Eliwúudi. ");
INSERT INTO kdh_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliwúudi waalʊ́rʊ Eleyazáarɩ, Eleyazáarɩ ɩlʊ́rʊ Matáanɩ, Matáanɩ ɩlʊ́rʊ Yaakúbu. ");
INSERT INTO kdh_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yaakúbu waalʊ́rʊ Ísifu, Marɩyáma weení waalʊ́rʊ Yeésu weení bánÿaá yɩ sɩsɩ Lɛɛrʊ́ nɛ́, ɩwaalʊ́. ");
INSERT INTO kdh_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kɔgbɔɔ Ibrahím ngɔ́nɩ Ɖáwʊɖa, caájaanáa waalɩ́ɩ gɛ ákɩzaalʊʊ́ naárʊ fɛ́yɩ́; bɩka kɔgbɔɔ Ɖáwʊɖa ngɔ́nɩ sáátɩ bɛɛɖɛɛná Israyɛ́ɛlɩ bíya Babilɔ́ɔnɩ nɛ́, caájaanáa waadálɩɩ ɖʊɖɔ ákɩzaalʊʊ́ naárʊ fɛ́yɩ́ gɛ. Kɔgbɔɔ sáátɩ kɩḿ ngɔ́nɩ baalʊ́rʊ Yeésu Krísto nɛ́, caájaanáa waalɩ́ɩ gɛ ákɩzaalʊʊ́ naárʊ fɛ́yɩ́. ");
INSERT INTO kdh_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ɩbɛ́ɛ nŋɩ́nɩ́táá baalʊrʊ ná Yeésu Krísto nɛ́. Báńváa ɩgɔɔ Marɩyáma Ísifu sɩ ɩkpɔ́ɔ. Ɩ́na yɩ bodoyoozi tá bɔcɔ́ɔ gɛ Marɩyáma wɛɛyɛ́ɛ fuwá na Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga-dɛ́ɛ ɖóni-daá. ");
INSERT INTO kdh_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ísifu weení baava yɩ nɛ́, kɛ́ɛ ɩrʊ́ weení ɩzɩɩzɛ́ɛ nɛ́, ɩdɔsɔ́ɔ́lɩ sɩsɩ ɩŋmátɩ tɩ ɩráa zamɔ́ɔ ɩnɩ́ɩ bɩka bɩfɔrɔ́sɩ Marɩyáma yɩ́ɖɛ. Biiyéle wɔɔzɔ́ɔ́lɩ sɩsɩ ɩ́na yɩ batára súmúú-daá. ");
INSERT INTO kdh_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ɩwɛ wánmaazɩ́ bɩlɛ́ nɛ́, ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ malááyɩ́ka naárʊ waaɖʊ ɩlɩ́ɩ ɩrɔ ɖoozire-daá ɩtɔ́ yɩ sɩsɩ: «Ísifu, Ɖáwʊɖa kutoluú-dɛ bú, nkanɩ́ɩ nɩdáárɛ sɩ ngbɔ́ɔ Marɩyáma nɛ́, káma, na Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga-dɛ́ɛ yíko-daá gɛ wɛɛyɛɛ ná fuwá kana. ");
INSERT INTO kdh_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Wánlʊrʊ́ʊ bú abaalʊ́ na nva yɩ yɩ́ɖɛ sɩsɩ Yeésu, káma, ɩmʊ́ sɩ ɩlɛɛ ná ɩdɛ́ɛ zamɔ́ɔ kɩdɛ́ɛ alaháácɩ́wá-daá.» ");
INSERT INTO kdh_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Bɩrɩ́ŋa bɩɩlá bɩlɛ́ gɛ na wentí Ɖádʊ́ʊ Ɩsɔ́ɔ waaŋmátɩ na anɖébi nɔɔ́ nɛ́ ikóódi; waaŋmátɩ gɛ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Aléeré waasɩ abaalʊ́ nɛ́ wɛ́nÿɛɛ́ fuwá ɩlʊ́rʊ bú abaalʊ́ na bafa yɩ yɩ́ɖɛ sɩsɩ Emanʊwɛ́ɛlɩ.» Yɩ́ɖɛ ɖɩḿ ɖugutoluú gɛ sɩsɩ «Ɩsɔ́ɔ wɛ ɖɔ́jɔ́.» ");
INSERT INTO kdh_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ísifu weevé nɛ́, waalá ńŋɩnáa Ɖádʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ malááyɩ́ka waaŋmátɩ yɩ nɛ́ nɔ́ɔ́, ɩkpɔ́ɔ Marɩyáma ɩbɩ́sɩ ɩɖɛɛlʊ́. ");
INSERT INTO kdh_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Amá, ɩ́na yɩ bodoyóózi hálɩ ɩkɔ́nɩ ɩlʊ́rʊ bú abaalʊ́ weení Ísifu waava yɩ́ɖɛ sɩsɩ Yeésu nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Baalʊ́rʊ Yeésu Bɛtɩlɛhɛ́ɛm, tɛɛbiiyá kɔwɛ Yudée laadɔ́ɔ-daá nɛ́-daá gɛ, sáátɩ wenkí Eróodi wénɖíi kowúrɔ́ɔ nɛ́. Baalʊ́rʊ yɩ wɔ́rɔ́ nɛ́, ngɛ tɩlɩ́ɖa túbu-dɩnáa bɛɛgbɛ́lɛŋ wɩlásɩ-dɛ́ɛ boɖé nɛ́ waagálɩ́ɩ́ná wɩ́sɩ ɖaagalɩɩɖɛ́ fáráńdɩ́ batála Yerusalɛ́ɛm tɛ́ɛ́dɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ngɛ bɔɔbɔ́ɔ́zɩ sɩsɩ: «Yahúúɖuwá-dɛ́ɛ wúro baalʊ́rʊ yɩ nɛ́, ɩwɛ lé. Káma, ɖáagáná ɩdɛ́ɛ wɩlɔɔ́ ɖoo wɩ́sɩ ɖaagalɩɩɖɛ́ fáráńdɩ́ nɛ́ gɛ ɖɔ́ɔ́gɔ́nɩ sɩ ɖukúu yɩ tɛ́ɛ́dɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Wúro Eróodi waanɩ́ɩ bɩlɛ́ nɛ́, ngɛ ɩlaakáarɩ waagʊrʊ́ ɩ́na Yerusalɛ́ɛm zamɔ́ɔ rɩ́ŋa. ");
INSERT INTO kdh_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ngɛ woodúúzi Ɩsɔ́ɔ sarásɩ lanɖáa-dɛ́ɛ kʊ́bɔnáa rɩ́ŋa na Mará wɩlɩɖáa ɩbɔ́ɔ́zɩ wɛ sɩsɩ lé gɛ sɩ balʊ́rʊ Lɛɛrʊ́. ");
INSERT INTO kdh_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ngɛ bɛlɛ́ boobúsi yɩ sɩsɩ: «Bɛtɩlɛhɛ́ɛm, Yudée laadɔ́ɔ-daá. Káma, bɛɛ wentí Ɩsɔ́ɔ waaŋmatɩná anɖébi nɔɔ́ nɛ́ nɖɔ́ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Nyɔ́ɔ́ Bɛtɩlɛhɛ́ɛm Yudée laadɔ́ɔ-daá, ńdɛkɛ́ɛ tɛɛbiiyá bɩɩdɔɔrɩ ná kɛ Yudée laadɔ́ɔ-daá nɛ́, káma nyɔ́ɔ́ nyádáá gɛ wúro weení sɩ ikéti Israyɛ́ɛlɩ mɛ́dɛ́ɛ zamɔ́ɔ nɛ́ sɩ ɩlɩɩná.”» ");
INSERT INTO kdh_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ngɛ Eróodi weeyéle bayáa tɩlɩ́ɖa túbu-dɩnáa bɛɛgbɛ́lɛŋ wɩlásɩ-dɛ́ɛ boɖé nɛ́ súmúú-daá, ɩbɔ́ɔ́zɩ wɛ sáátɩ wenkí ɖéyí‑ɖéyí wɩlɔɔ́ waaɖʊ kalɩ́ɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ngɛ weeyéle bɛɖɛ́ɛ Bɛtɩlɛhɛ́ɛm bɩka ɩtɔ́ wɛ sɩsɩ: «Ibó ɩbɔ́ɔ́zɩ ɩtɩlɩ́ bú ɩmʊ́ ɩɖɩdáarɛ ɖéyí‑ɖéyí. A mɩ́ɩ́ná yɩ iyéle madɩlɩ́, na mɔ́ɔ́ ɖʊdɔ mobó mogóguu yɩ tɛ́ɛ́dɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Wúro waaŋmátɩ wɛ bɩlɛ́ bɩtɛ́ nɛ́, bɔɔgbɔ́ɔ nɩ́bááwʊ. Ngɛ baana wɩlɔɔ́ wenká baagáná kɛ wɩ́sɩ ɖaagalɩɩɖɛ́ nɛ́ baazá-daá kɛ́nɖɛɛ́. Kaadála lénlé bú wɛ nɛ́, ngɛ kaazɩ́ŋ. ");
INSERT INTO kdh_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Baana wɩlɔɔ́ bɩlɛ́ nɛ́, ngɛ bɩɩbá bɩlá wɛ niíni. ");
INSERT INTO kdh_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ngɛ baazʊ́ʊ ɖaána-daá bɔmɔɔná bú na ɩgɔɔ Marɩyáma. Ńna gɛ baagá baɖʊná-rɔ bokúu bú tɛ́ɛ́dɩ, bobóɖi bagbɩná-daá balɩzɩ́ siká, cɛ́lɛ bɩná-dɛ́ɛ tulaarɩ́ bónvuudɩ́ nɛ́, na tulaarɩ́ bánÿaá kɩ sɩsɩ míiri nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ngɛ Ɩsɔ́ɔ waabásɩ wɛ ɖoozire-daá sɩsɩ bákabɩ́sɩ Eróodi-jɔ́; ngɛ bɔɔgbɔɔná nɩ́bááwʊ nakɩ́rɩ babɩ́sɩ balaadɔ́ɔ-daá. ");
INSERT INTO kdh_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Bɛɛɖɛ́ɛ wɔ́rɔ́ nɛ́, ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ malááyɩ́ka waaɖʊ ɩlɩ́ɩ Ísifu-rɔ ɖoozire-daá ɩtɔ́ yɩ sɩsɩ: «Kʊrʊ́, kpɔɔ bú na ɩgɔɔ ise ɩɖɛ́ɛ Mɩ́sɩra. Cɔɔ ńna hálɩ sáátɩ wenkí sɩ mɔdɔ́ nya sɩsɩ ngábɩsɩ nɛ́, káma Eróodi wɔ́ngɔnɩ́ ɩcáa bú sɩ ɩkʊ yɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ísifu waagʊrʊ́ ɩkpɔ́ɔ bú na ɩgɔɔ nuvoowú bɛɖɛ́ɛ Mɩ́sɩra. ");
INSERT INTO kdh_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Wɔɔjɔ́ɔ ńna hálɩ Eróodi ɩkɔ́nɩ ɩsɩ́. Bɩɩlá bɩlɛ́ gɛ na wentí Ɩsɔ́ɔ waaŋmatɩná anɖébi nɔɔ́ nɛ́ ikóódi; waaŋmátɩ gɛ sɩsɩ: «Mááyáa mebiyaalʊ́ sɩsɩ ɩ́lɩɩ Mɩ́sɩra.» ");
INSERT INTO kdh_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Eróodi waadɩlɩ́ sɩsɩ tɩlɩ́ɖa túbu-dɩnáa bɛɛgbɛ́lɛŋ wɩlásɩ-dɛ́ɛ boɖé nɛ́ boodúúli yɩ nɛ́, ngɛ waabá ɩyɛ́ɛ baaná. Ngɛ waava wɛ́ɖɛ sɩsɩ bákʊ́ bíya abaaláa rɩ́ŋa bɔwɛná bɩ́ɩ́zɩ nasɩ́lɛ ngbɔ́ɔ ngédi nɛ́ Bɛtɩlɛhɛ́ɛm na kɩdɛ́ɛ fáráńdɩ́wá-daá. Bɩ́ɩ́zɩ sɩḿ sɩdaá gɛ tɩlɩ́ɖa waawɩ́lɩ sɩsɩ bánlʊrʊ́ʊ bú ɩmʊ́. ");
INSERT INTO kdh_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Bɩɩlá bɩlɛ́ gɛ na wentí anɖébi Yeremíya waavʊ́ńŋmátɩ nɛ́ ikóódi. Waavʊ́ńŋmátɩ gɛ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Baanɩ́ɩ lowú nakɩ́rɩ Raamáa tɛ́ɛ́dɩ-daá, wíídi na mɛɛdɩrɛ gɛ bɩgɛ́ɛ. Rasɩ́ɩ́la wénwii kʊ ɩdɛ́ɛ bíya, ɩ́dánjaa bɛbɛ́ɛ́lɩ yɩ, káma ibíya waazɩ́.» ");
INSERT INTO kdh_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Eróodi sɩ́m wɔ́rɔ́ gɛ Ɩsɔ́ɔ-dɛ́ɛ malááyɩ́ka waaɖʊ ɩlɩ́ɩ Ísifu-rɔ ɖoozire-daá Mɩ́sɩra laadɔ́ɔ-daá. ");
INSERT INTO kdh_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ngɛ wɔɔdɔ́ Ísifu sɩsɩ: «Kʊrʊ́, kpɔɔ bú na ɩgɔɔ nbɩ́sɩ Israyɛ́ɛlɩ laadɔ́ɔ-daá, káma, wenbá bánvʊnjáádɩ sɩ bakʊ bú nɛ́ baazɩ́.» ");
INSERT INTO kdh_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ngɛ Ísifu waagʊrʊ́ ɩkpɔ́ɔ bú na ɩgɔɔ ɩbɩ́sɩ Israyɛ́ɛlɩ laadɔ́ɔ-daá. ");
INSERT INTO kdh_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Amá, waanɩ́ɩ sɩsɩ Arɩkelawɔ́ɔsɩ Eróodi biyaalʊ́ wénɖíi kʊ kowúrɔ́ɔ ɩjaa wɔ́rɔ́ Yudée laadɔ́ɔ-daá nɛ́, bɩɩlá yɩ nɩdáárɛ ńna boɖé. Ngɛ Ɩsɔ́ɔ waaŋmatɩná yɩ ɖoozire-daá ɩɖɛ́ɛ Galilée fáráńdɩ́-daá. ");
INSERT INTO kdh_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ngɛ woobó ɩcɔ́ɔ tɛ́ɛ́dɩ bánÿaá tɩ sɩsɩ Nazarɛ́ɛtɩ nɛ́ tɩdaá. Bɩɩlá bɩlɛ́ gɛ na wentí anɖébiwá waavʊ́ńŋmátɩ nɛ́ ikóódi; bɛlɛ́ baavʊ́ńŋmátɩ gɛ sɩsɩ: «Sɩ bayáa yɩ gɛ sɩsɩ Nazarɛ́ɛtɩ ńnɩ́.» ");
INSERT INTO kdh_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Bʊwɔ́rɔ́ gɛ Yaayá weení wénliríi ɩráa lɩ́m-daá wɔ́nzɔ́ɔ wɛ túúbá lɩ́m nɛ́ waaɖʊ ɩlɩ́ɩ Yudée tɛɛwʊ́lɔ́ɔ́-daá wánlám waázu sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Ɩgɛ́ɛ mɩ́lakásɩ, káma Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ waajʊ́ʊ.» ");
INSERT INTO kdh_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yaayá-dɛ́ɛ tɔ́m gɛ anɖébi Esáya waavʊ́ńŋmátɩ sɩsɩ: «Lowú nakɩ́rɩ wɔɔvɔ tɛɛwʊ́lɔ́ɔ́-daá sɩsɩ: “Ɩgbɩ́ɩ́rɩ Ɖádʊ́ʊ-dɛ́ɛ nɩ́bááwʊ, ɩzɩ́ɩ́zɩ ɩdɛ́ɛ níbeyísi.”» ");
INSERT INTO kdh_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Raakúḿ-dɛ́ɛ fʊ́ńdɩ tóko gɛ Yaayá sóóna bɩka tɔ́nɖɛ ɖanbára nyaarɛ́ɛ ɩdɩnɔɔ́-daá. Bɩɩga nɛ́, igíɖíím gɛ cɩ́báánɩ na tʊ́ʊ́nɩ. ");
INSERT INTO kdh_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Yerusalɛ́ɛm na Yudée rɩ́ŋa, na Yɔrɔdáanɩ buwá fáráńdɩ́-daá ɩráa wɔ́ngɔnɩ́ ɩjɔ́ ");
INSERT INTO kdh_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","bándɩ́m bɛdɛ́ɛ alaháácɩ́wá ɩráa-daá, bɩka wénliríi wɛ lɩ́m-daá wɔ́nzɔ́ɔ wɛ túúbá lɩ́m Yɔrɔdáanɩ buwá-daá. ");
INSERT INTO kdh_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yaayá waana sɩsɩ Faríizi ńba ɖabata na Sadusée ńba wɔ́ngɔnɩ́ ɩjɔ́ sɩsɩ ilíri wɛ lɩ́m-daá ɩsɔ wɛ túúbá lɩ́m. Ńna gɛ wɔɔdɔ́ wɛ sɩsɩ: «Mɩ́ɩ bɔɔzá ana ɖɔ́! Weení waawɩlɩ ná mɩ́ɩ sɩsɩ ísé ɩlɩ́ɩ Ɩsɔ́ɔ-dɛ́ɛ tɔ́m fʊʊnáa tɩɩjʊ́ʊ nɛ́ tɩdaá. ");
INSERT INTO kdh_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ɩlá lakásɩ sɩ́nwɩlɩ́ɩ sɩsɩ mɩ́ɩ́lá túúbá ɩkɛ́ɛ nɛ́; ");
INSERT INTO kdh_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ɩ́kamáázɩ mɩ́dáá sɩsɩ mɩ́jaájaa gɛ Ibrahím nɛ́ bɩɩdɛ́. Káma, ménveerím mɩ́ɩ sɩsɩ Ɩsɔ́ɔ wánbɩɩzɩ́ ɩkpɔ́ɔ bɔ́ ana ɖɔ́ ɩbɩsɩná Ibrahím kutoluú-dɛ bíya. ");
INSERT INTO kdh_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Báńgbɩɩrɩ kpenbiiyá sɩ bɛbɛlɩ́ na tɩ́ɩ́nɩ tigutolíni dɛ nɛ́. Tɩɩwʊ́ wenkí kɩrɩ́ŋa kɩ́dánɖʊ́ʊ bíya kazɔ́ɔ ńba nɛ́, bɛ́nbɛlɩ́ɩ kɩ baɖʊ nimíni-daá. ");
INSERT INTO kdh_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Lɩ́m-daá gɛ mɔ́ɔ́ ménliríi mɩ́ɩ mɔzɔ mɩ́ɩ túúbá lɩ́m na bɩwɩ́lɩ sɩsɩ mɩ́ɩ́lá túúbá ɩkɛ́ɛ, amá, weení ɩgɛrɛŋɛ mɔ́wɔ́rɔ́ nɛ́ waagɩ́lɩ ma. Mádatála malɩzɩ́ yɩ takaḿwá. Ɩlɛ́ sɩ iliri ná mɩ́ɩ Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga-daá na nimíni. ");
INSERT INTO kdh_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ɩɖɔ́kɩná kɩ́falanákʊ ɩnʊ́ʊ́zɩ-daá, sɩsɩ ɩlɩzɩ́ tolá fɔɔlʊʊ́ bɩka ɩkpɔ́ɔ mɩlá ɩbɩ́rɩ igbeewú-daá, na ɩkpɔ́ɔ tolá ɩbɩ́rɩ nimíni ɩ́dánɖɩḿ nɛ́ ɩdaá biɖe.» ");
INSERT INTO kdh_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Bɩdɛ́ɛ sáátɩ gɛ Yeésu waagálɩ́ɩ́ná Galilée ɩkɔ́nɩ Yaayá-jɔ́ Yɔrɔdáanɩ buwá-jɔ́ sɩsɩ ilíri yɩ lɩ́m-daá. ");
INSERT INTO kdh_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yaayá wɔɔjɔ́ɔ́lɩ yɩ ɩtɔ́ yɩ sɩsɩ: «Mɔ́ɔ́ mɔ́mɔɔ́na kʊ mɔgɔ́nɩ nyɔ́jɔ́ nlíri ma lɩ́m-daá nzɔ ma túúbá lɩ́m, na nyɔ́ɔ́ ngúti nyɔ́ngɔnɩ́ mɔ́jɔ́?» ");
INSERT INTO kdh_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Amá, Yeésu woobúsi yɩ sɩsɩ: «Yele ɖɩlá bɩlɛ́ lɛlɛɛɖɔ́, káma, bɩlɛ́ gɛ bɩmɔɔ́na ɖɩlá wenbí bɩrɩ́ŋa Ɩsɔ́ɔ wɔɔbɔ́ɔ́zɩ nɛ́.» Ńna gɛ Yaayá weedísi ilíri Yeésu lɩ́m-daá. ");
INSERT INTO kdh_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Weelíri Yeésu lɩ́m-daá ɩlɩ́ɩ nɛ́, bɩdɛ́ɛ sáátɩ kɩḿ gɛ ɩsɔ́ɔ́dáá waadʊlʊ́, ngɛ Yeésu waana Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga wéngedím nyazɩ ɖuvóóre kʊ́fʊlʊńɖɛ bɩlɛ́ kɔkɔ́nɩ kosóm ɩrɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ngɛ baanɩ́ɩ lowú nakɩ́rɩ ɩsɔ́ɔ́dáá sɩsɩ: «Ceení gɛ Mebiyaalʊ́ máábá mɔ́zɔɔlɛ́ɛ yɩ nɛ́. Ɩrɔ gɛ mááɖʊ́ mɛ́dɛ́ɛ sɔɔlɩ́m rɩ́ŋa.» ");
INSERT INTO kdh_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ńna gɛ Ɩsɔ́ɔ-dɛ́ɛ Kezeŋa wooboná Yeésu tɛɛwʊ́lɔ́ɔ́-daá sɩsɩ Sitáánɩ ɩyɩ́ yɩ kɔdɔ́sɩ. ");
INSERT INTO kdh_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Wɔjɔ́ɔ wɛ́ nɛɛ́lɛ nuvoowú na ɩdaawʊ́ ideɖi ɩdɔnyɔ́ɔ wɔ́rɔ́ nɛ́, ngɛ nyɔɔ́sɩ waalá yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ngɛ Sitáánɩ woogóduu ɩjɔ́ ɩtɔ́ yɩ sɩsɩ: «A nyɛ́gɛ́ɛ Ɩsɔ́ɔ Biyaalʊ́, tɔ bɔ́ ana abɩ́sɩ kíɖíím.» ");
INSERT INTO kdh_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Amá, Yeésu woobúsi yɩ sɩsɩ: «Baaŋmáa Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá sɩsɩ: “Bɩdɛkɛ́ɛ kíɖíím riké gɛ ɩrʊ́ wénɖíi na ɩcɔ́ɔ weezuú-daá, amá, ŋmatɩrɛ rɩ́ŋa ɖɩ́nlɩɩnáa Ɩsɔ́ɔ nɔɔ́-daá nɛ́ ɖʊɖɔ gɛ.”» ");
INSERT INTO kdh_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ńna gɛ Sitáánɩ wooboná Yeésu Yerusalɛ́ɛm Ɩsɔ́ɔ-dɛ́ɛ tɛ́ɛ́dɩ-daá, ɩdɛ́ɛ ɖaána kʊ́bɔńga kʊjʊʊ́-daá. ");
INSERT INTO kdh_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ngɛ wɔɔdɔ́ yɩ sɩsɩ: «A nyɛ́gɛ́ɛ Ɩsɔ́ɔ Biyaalʊ́, tɔ nyádɩ nzúu adɛ, káma, baaŋmáa Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá sɩsɩ: “Ɩsɔ́ɔ wánváa ɩdɛ́ɛ malááyɩ́kawá wɛ́ɖɛ sɩsɩ bɛkpɛ́kɩ nya banʊ́ʊ́zɩ-daá na nyɔ́nʊvɔ́ íkotuúli bʊ́ʊ́rɛ.”» ");
INSERT INTO kdh_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ńna gɛ Yeésu wɔɔdɔ́ yɩ sɩsɩ: «Baadáŋmáa Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá sɩsɩ: “Ńdánɖaazɩ Nyádʊ́ʊ Ɩsɔ́ɔ nbɛ́ɛ sɩsɩ wánbɩɩzɩ́?”» ");
INSERT INTO kdh_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sitáánɩ waadásɩ iboná yɩ bʊ́ʊ kʊ́bɔńgɩ nakɩ́rɩ kʊjʊʊ́-daá, ngɛ waawɩ́lɩ yɩ ɖúúlínya rɩ́ŋa na kɩdɛ́ɛ ásícé, ");
INSERT INTO kdh_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ngɛ wɔɔdɔ́ yɩ sɩsɩ: «A nyáágá nyáɖʊná-rɔ ngúu ma tɛ́ɛ́dɩ, mánváa nya bɩrɩ́ŋa.» ");
INSERT INTO kdh_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ńna gɛ Yeésu wɔɔdɔ́ yɩ sɩsɩ: «Laná ma bolíni, Sitáánɩ! Káma, baaŋmáa Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá sɩsɩ: “Nyádʊ́ʊ Ɩsɔ́ɔ riké gɛ nyónguú tɛ́ɛ́dɩ, bɩka iriké gɛ nyánlám bɔwʊtá.”» ");
INSERT INTO kdh_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ńna gɛ Sitáánɩ wɛɛɖɛ́ɛ iyéle yɩ. Ngɛ malááyɩ́kawá woogóduu Yeésu-jɔ́ balá yɩ bɔwʊtá. ");
INSERT INTO kdh_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yeésu waanɩ́ɩ sɩsɩ bɔɔdɔ Yaayá sáráka. Waanɩ́ɩ bɩlɛ́ nɛ́, ngɛ waalɩ́ɩ ńna ɩɖɛ́ɛ Galilée. ");
INSERT INTO kdh_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Amá, idokúti ɩcɔ́ɔ Nazarɛ́ɛtɩ, wɛɛɖɛ́ɛ ɩcɔ́ɔ Kapɛrɩnawʊ́m lɩɩrɛ́ kʊ́bɔńɖɛ-jɔ́, Zabulɔ́ɔnɩ na Nɛfɩtalíi bɛdɛ́ɛ laadásɩ-daá, ");
INSERT INTO kdh_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","na wentí anɖébi Esáya waaŋmátɩ nɛ́ ikóódi; tɩlɛ́ gɛ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Zabulɔ́ɔnɩ-dɛ́ɛ laadɔ́ɔ, na Nɛfɩtalíi-dɛ́ɛ laadɔ́ɔ mɩ́dɩ́láána tenkú, na Yɔrɔdáanɩ buwá-dɛ́ɛ fɔɔlʊʊ́ kɩɩganáa nɛ́, Nyɔ́ɔ́ Galilée, ɩráa bɛdɛkɛ́ɛ Yahúúɖuwá nɛ́ bɛdɛ́ɛ laadɔ́ɔ, ");
INSERT INTO kdh_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Zamɔ́ɔ kʊwɛ temenuú-daá nɛ́ kɩɩna ɖɛnyɛm kʊ́bɔńgɩ, bɩka ɖɛnyɛm ɩɖʊ kɩlɩ́ɩ sɩ́m-dɛ́ɛ temenuú tɛ́ɛ́dɩ-daá.» ");
INSERT INTO kdh_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Bɩdɩ́ŋa-rɔ gɛ Yeésu waabáázɩ waázu lám sɩsɩ: «Ɩgɛ́ɛ mɩ́lakásɩ, káma, Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ waajʊ́ʊ.» ");
INSERT INTO kdh_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Waadála Galilée tenkú nɔɔ́-jɔ́ nɛ́, ngɛ waana ɩráa nɔɔ́lɛ ɩrʊ́ na igoobú, bɔ́nlɔ́ɔ biruú, káma bɛgɛ́ɛ biríni lɔɔráa gɛ; ɩráa bɛḿ bayɩrá gɛ Simɔ́ɔnɩ weení baava yɩ sɩsɩ Pétro nɛ́, na Andirée. ");
INSERT INTO kdh_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ngɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Igóvú ma bɩka mabɩsɩná mɩ́ɩ wenbá bánÿaá ɩráa sɩsɩ bófú ma nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ńna‑ńna gɛ beeyéle biríni bofu yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Woodúu bolíni nɛ́, ngɛ waana koobíya nɔɔ́lɛ: Yaakúbu Zebedée biyaalʊ́ na igoobú Yʊháánɩ, bɔwɛ bɛdɛ́ɛ kpɩ́ɩ́rʊʊ́-daá bána bajaa Zebedée, bɔ́nnyɔɔzɩ́ bɛdɛ́ɛ biríni. Ngɛ waayáa wɛ. ");
INSERT INTO kdh_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ńna‑ńna gɛ beeyéle bɛdɛ́ɛ kpɩ́ɩ́rʊʊ́ na bajaa bɩka bofu yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ngɛ Yeésu woobó wéngilím Galilée laadɔ́ɔ rɩ́ŋa-daá wánwɩlɩ́ɩ ɩráa Ɩsɔ́ɔ-dɛ́ɛ tɔ́m Ɩsɔ́ɔ ɖaazɛɛɖɛ́, wénveerím wɛ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-dɛ́ɛ Laabáárʊ Kífeńgi bɩka wánwaazɩ́ ɩráa-dɛ́ɛ kʊdɔmɩ́nɩ báa wentí na bɛdɛ́ɛ mádafɩ́yatɩ. ");
INSERT INTO kdh_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ɩráa waanɩ́ɩ bánŋmatɩ́ Yeésu-dɛ́ɛ tɔ́m Siríi tɛ́ɛ́dɩwá rɩ́ŋa-daá, ngɛ bɔ́ngɔgɔnáa yɩ wenbá barɩ́ŋa bɛ́nÿɛlɛ́ŋ nɛ́, na kʊdɔndɩnáa na wenbá zííniwá wánjaarɩ́ wɛ nɛ́, kazáladɛ́ɛ́dɩ-dɩnáa na gaala‑gáálásɩ, bɩka Yeésu wánwaazɩ́ wɛ. ");
INSERT INTO kdh_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Zamɔ́ɔ kʊ́bɔńgɩ fóo na kʊ yɩ. Badaá nɛbɛ́rɛ waagálɩ́ɩ́ná Galilée na tɛ́ɛ́dɩwá fuú tɩdamáa nɛ́, na Yerusalɛ́ɛm na Yudée na Yɔrɔdáanɩ buwá-dɛ́ɛ fɔɔlʊʊ́ kɩɩganáa. ");
INSERT INTO kdh_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yeésu waana zamɔ́ɔ nɛ́, ngɛ waagba bʊ́ʊ-daá ɩkɔ́jɔ́ɔ. Ngɛ ɩdɛ́ɛ wanbaaráa woogóduu ɩjɔ́. ");
INSERT INTO kdh_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ńna gɛ waabáázɩ wɛ wɩlɩ́ɩ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Wenbi‑niíni-dɩnáa gɛ wenbá banyɩ bewenbé-daá sɩsɩ bɛgɛ́ɛ kadanbʊrʊ́sɩ nɛ́, káma, badɩɩná Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Wenbi‑niíni-dɩnáa gɛ wenbá bɔjɔɔ́ɔ ɖúkúru nɛ́, káma, Ɩsɔ́ɔ wɛ́nbɛɛlɩ́ wɛ. ");
INSERT INTO kdh_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Wenbi‑niíni-dɩnáa gɛ wenbá bɔjɔɔ́ɔ ɖɔyɔɔyɔɔ nɛ́, káma, Ɩsɔ́ɔ wánlám wɛ laadɔ́ɔ kʊjɔɔwʊ. ");
INSERT INTO kdh_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Wenbi‑niíni-dɩnáa gɛ wenbá bɔcɔ́ɔ wenbí Ɩsɔ́ɔ sɔɔlɛ́ɛ ɩrʊ́ ɩcɔɔná nɛ́, cɔɔ́ɔ na wɛ nyɔɔ́sɩ na ɖoolɔɔ́ nɛ́, káma, babʊkááta wánzɩ́m. ");
INSERT INTO kdh_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Wenbi‑niíni-dɩnáa gɛ wenbá bánnɩɩ́ baranáa kʊnyɔḿ nɛ́, káma, Ɩsɔ́ɔ wánnɩɩ́ bagʊnyɔḿ. ");
INSERT INTO kdh_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Wenbi‑niíni-dɩnáa gɛ wenbá bewenbé-daá cɔɔ́ɔ ɖacɩrɩ‑cɩrɩ nɛ́, káma, bánnáa Ɩsɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Wenbi‑niíni-dɩnáa gɛ wenbá bánjaanáa baranáa fɛɛzɩrɛ nɛ́, káma, sɩ bayáa wɛ gɛ sɩsɩ Ɩsɔ́ɔ-dɛ́ɛ bíya. ");
INSERT INTO kdh_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Wenbi‑niíni-dɩnáa gɛ wenbá bánnáa wahála, káma, bovóo Ɩsɔ́ɔ-dɛ́ɛ nɩ́bááwʊ na toovonúm nɛ́, káma, badɩɩná Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Wenbi‑niíni-dɩnáa gɛ mɩ́gɛ́ɛ a bɩgɛ́ɛ bándʊ́ʊ́dɩ mɩ́ɩ, bánnaazɩ́ mɩ́ɩ bɩka bónbuunáa mɩ́ɩ tɔ́mwá ndɩ‑ndɩ mɔ́rɔ́ɔ́zɩ́. ");
INSERT INTO kdh_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ɩváárɩ bɩka bɩlá mɩ́ɩ niíni, káma, mɩ́dɛ́ɛ kɩvɛrɛwʊ wɔɔɖɔ́ɔ ɩsɔ́ɔ́dáá. Bɩlɛ́ ɖʊɖɔ gɛ baanáázɩ anɖébiwá baavʊ́ńdɛ́ɛ mɩ́ɩ nɩ́bááwʊ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Mɩ́nyɔ́ɔ́ mɩ́gɛ́ɛ na ɖúúlínya-dɛ́ɛ ɖɔ́m. A ɖɔ́m waazɩ́ niíni, nŋɩ́nɩ́ gɛ bánlám bɩ na bɩtálaḿ niíni ɖʊɖɔ. Asée bɔkpɔ́ɔ bɩ gɛ bɛbɛ́ɖɩ asʊ bɩka ɩráa ɩnʊ́ŋ bɩ. ");
INSERT INTO kdh_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Mɩ́nyɔ́ɔ́ mɩ́gɛ́ɛ na ɖúúlínya-dɛ́ɛ ɖɛnyɛm. Tɛ́ɛ́dɩ baama tɩ bʊ́ʊ kʊjʊʊ́-daá nɛ́, tɩ́dánmʊsɩ. ");
INSERT INTO kdh_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ngʊ́ bɔ́dɔ́nzɔḿ fɩtɩ́la na bɔkpɔ́ɔ gbégídi bofu kɩrɔ. Amá, bɔ́ngbɔwʊ́ʊ kɩ gɛ batɩ́nɩ ɩsɔ́ɔ́dáá na bɩka bilósi báa weení ɖaána-daá. ");
INSERT INTO kdh_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Bɩlɛ́ ɖʊɖɔ gɛ mɩ́dɛ́ɛ ɖɛnyɛm mɔɔ́na kilósi, báa weení ɩna mɩ́lakásɩ kazɔ́ɔ ńzɩ, na basá Mɩ́jaa ɩwɛ ɩsɔ́ɔ́dáá nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Ɩ́kamáázɩ sɩsɩ mɔ́ɔ́gɔ́nɩ sɩ maɖɩ́ Múúsá-dɛ́ɛ Mará na anɖébiwá baaganáa-dɛ́ɛ ŋmáádɩ. Mɔ́dɔkɔ́nɩ sɩ maɖɩ́ tɩ, amá, mɔ́ɔ́gɔ́nɩ gɛ na tɩbɩ́ɩ́zɩ tikóódi. ");
INSERT INTO kdh_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ménveerím mɩ́ɩ toovonúm sɩsɩ: hálɩ ɖúúlínya ɩkʊrʊ́ gɛ, Mará-daá báa ŋmáádɩ-bú yáá toḿka tándʊʊ́. ");
INSERT INTO kdh_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Bɩlɛ́ nɛ́, weení idofu Mará amʊ́ adaá kʊ́ɖʊńɖɛ báa ɖɩgɛ́ɛ kúmuuɖé, ngɛ weeyéle baaganáa ikízi ɖɛ nɛ́, sɩ bayáa yɩ kúmuú gɛ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-daá. Amá, weení woovu tɩ ngɛ waawɩ́lɩ tɩ ɩranáa nɛ́, sɩ bayáa yɩ kʊ́bɔnɩ́ gɛ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-daá. ");
INSERT INTO kdh_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ménveerím mɩ́ɩ sɩsɩ a mɩ́dɛ́ɛ toovonúm fáa tɔɖɔ́ɔ bɩkɩ́lɩ Mará wɩlɩɖáa na Faríizi ńba, mɩ́dánzʊʊ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-daá.» ");
INSERT INTO kdh_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Mɩ́ɩ́nɩ́ɩ sɩsɩ baaŋmátɩ ɖájaájaanáa sɩsɩ: “Ńdángʊ́ʊ ɩrʊ́; weení waagʊ ɩrɔwʊ́ nɛ́, bánvʊʊnáa yɩ.” ");
INSERT INTO kdh_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Amá, mɔ́ɔ́ ménveerím mɩ́ɩ sɩsɩ: weení wɛɛyɛɛ ná ɩrɔwʊ́ baaná nɛ́, bánvʊʊnáa yɩ; weení wɔɔdɔ́ ɩrɔwʊ́ sɩsɩ ɩvɛ́yɩ́na lomaazɛ́ nɛ́, bánvʊʊnáa yɩ; weení waadʊ́ʊ ɩrɔwʊ́ sɩsɩ ɖijinɖe nɛ́ mɔɔ́na baɖʊ yɩ azáába nimíni-daá. ");
INSERT INTO kdh_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","A bɩgɛ́ɛ sɩsɩ nyáádála Ɩsɔ́ɔ sarásɩ ɖaalanɖɛ́ sɩ nlá Ɩsɔ́ɔ sarɔ́ɔ, ngɛ nyɔ́ɔ́dɔ́ɔ́zɩ sɩsɩ nyɔ́rɔwʊ́ yɛ́ɛ́na nya, ");
INSERT INTO kdh_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","sɩɩ nyázarɔ́ɔ sarásɩ ɖaalanɖɛ́ ɩzá-daá bɩka nbó nnyɔ́ɔ́zɩ nyána nyɔ́rɔwʊ́ mɩ́lɔ́wʊ́táá naanɩ́ ngábɩsɩ nlá kɛ. ");
INSERT INTO kdh_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","A nyána naárʊ tɔ́m, caarɩ nyádɩ ɩnyɔ́ɔ́zɩ tɩ mɩ́lɛ́ɛ́nɩ́ mɩ́wɛ nɩ́bááwʊ-daá nɛ́, na ɩlɛ́ ɩ́kɔkɔ́nɩ iboná nya tɔmvʊʊráa-jɔ́, bɛlɛ́ bɔkpɔ́ɔ nya becéle sɔ́ɔ́jawá bɔtɔ nya sáráka. ");
INSERT INTO kdh_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ménveerím nya toovonúm sɩsɩ, a ńdɛfɛrɛ tá bɩrɩ́ŋa bɩtɛ́, nyɛ́vɛ́yɩ́ nyánlɩɩ́ ńna.» ");
INSERT INTO kdh_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Mɩ́ɩ́nɩ́ɩ bɔɔdɔ́ sɩsɩ: “Nkalɩ́ɩ nɖɛɛlʊ́ yáá nwaalʊ́ wɔ́rɔ́” nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Amá, mɔ́ɔ́ ménveerím mɩ́ɩ sɩsɩ: ɩrʊ́ weení waana naárʊ ɖɛɛlʊ́ ɩcɩ́ɩ́lɩ yɩ nɛ́, ɩ́tɩ́lɩ́ sɩsɩ waalɩ́ɩ ɩɖɛɛlʊ́ wɔ́rɔ́ iwenbiré-daá. ");
INSERT INTO kdh_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","A bɩgɛ́ɛ nyáázɩ́rɛ kíɖiiwú wénÿelíi kʊ gɛ nyánlám alaháácɩ́, lɩzɩ́ ɖɛ nlɔ bolíni, káma, bɩjɔɔ́ɔ sóńcí nbɛ́ɖɩ nyɛ́dɛ́ɛ ɖeelí na nyárɩ́ŋa nzʊ́ʊ azáába nimíni-daá. ");
INSERT INTO kdh_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","A ngʊ́ nyánʊ́ʊ́nɩ kíɖiiwú wénÿelíi kʊ nyánlám alaháácɩ́, cɛ yɩ nbɛ́ɖɩ bolíni, káma, nbɛ́ɖɩ nyánʊ́ʊ́nɩ kʊ́ɖʊḿ cɔɔ́ɔ sóńcí na nyárɩ́ŋa nzʊ́ʊ azáába nimíni-daá.» ");
INSERT INTO kdh_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Bɔɔdɔ́tɔḿ ɖʊɖɔ sɩsɩ: “A naárʊ weegízi ɩɖɛɛlʊ́, ícéle yɩ wasɩ́ɩ́ka kɩ́nwɩlɩ́ɩ sɩsɩ weegízi yɩ nɛ́.” ");
INSERT INTO kdh_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Amá, mɔ́ɔ́ ménveerím mɩ́ɩ sɩsɩ weení ɩrɩ́ŋa weegízi ɩɖɛɛlʊ́ bɩdɛkɛ́ɛ na sɩsɩ waalɩ́ɩ ɩwɔ́rɔ́ nɛ́, weeyele ná alʊ́ ɩmʊ́ ɩlɩ́ɩ ɩwɔ́rɔ́ a bɩgɛ́ɛ sɩ woobó ɩsáa naárʊ; ngʊ́ bɩlɛ́ ɖʊɖɔ gɛ weení wooɖooná alʊ́ weení naárʊ weegízi yɩ nɛ́, bʊdʊ́ʊ wooɖooná naárʊ ɖɛɛlʊ́.» ");
INSERT INTO kdh_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Mɩ́ɩ́dánɩ́ɩ ɖʊɖɔ sɩsɩ bɔɔdɔ́ ɖájaájaanáa sɩsɩ: “A nyóóɖúúná Ɩsɔ́ɔ ɩzá-daá sɩsɩ nyánlám wenbí nɛ́, asée nlá bɩ gɛ.” ");
INSERT INTO kdh_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Amá, mɔ́ɔ́ ménveerím mɩ́ɩ sɩsɩ íkoɖuuná nabʊ́rʊ. Íkoɖuuná ɩsɔ́ɔ́dáá, káma, Ɩsɔ́ɔ-dɛ́ɛ kowuro-gbelé gɛ bɩgɛ́ɛ, ");
INSERT INTO kdh_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","cáńfáná adɛ laadɔ́ɔ, káma, kɛgɛ́ɛ Ɩsɔ́ɔ-dɛ́ɛ nʊvɔ́ ɖaazɩɩɖɛ́ gɛ, cáńfáná nɖuuná Yerusalɛ́ɛm tɛ́ɛ́dɩ, káma, tɩgɛ́ɛ Ɩsɔ́ɔ Wúro Kʊ́bɔnɩ́-dɛ́ɛ tɛ́ɛ́dɩ gɛ. ");
INSERT INTO kdh_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ngʊ́ nkoɖuuná nyágʊjʊʊ́, káma, ńdánbɩɩzɩ nlá nyágʊjʊʊ́-daá nyɔká kʊ́ɖʊmɔ́ɔ ɩbɩ́sɩ kʊ́fʊ́lʊmɔ́ɔ yáá kɩ́kpɛdɔɔ́. ");
INSERT INTO kdh_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Wenbí sɩ ɩlá nɛ́ gɛ sɩsɩ a bɔɔbɔ́ɔ́zɩ mɩ́ɩ tɔ́m, a mɩ́nyɩ tɩ, idísi sɩsɩ: Ɩɩ́n; a mɩ́ɩ́sɩ tɩ, sɩsɩ: Aayɩ́. Wentí bónzuurí nɛ́ wánlɩɩnáa Sitáánɩ-jɔ́ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Mɩ́ɩ́nɩ́ɩ bɔɔdɔ́ sɩsɩ: “A ɩrʊ́ wɔɔyɔ́ nyáázɩ́rɛ, waazɩ́rɛ gɛ bɔ́nÿɔ́m bɛfɛ́rɛ; a wɛɛbɛlɩ́ nyégéle, bɛ́nbɛlɩ́ɩ ɩdɛ́ɛ-ńɖɛ.” ");
INSERT INTO kdh_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Amá, mɔ́ɔ́ ménveerím mɩ́ɩ sɩsɩ: A ɩrʊ́ waalá mɩ́ɩ bɩdaavé, ɩ́kɛfɛrɛ yɩ. A ɩrʊ́ wɛɛjɛ́ nya kadaŋá nyédeegbeluú kíɖiiwú-rɔ, kɛɛzɩ kɩɩganáa njéle yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","A naárʊ sɩ iboná nya tɔmvʊʊrʊ́-jɔ́ ibuuná nya tɔ́m na ɩkpɔ́ɔ nyɛ́dɛ́ɛ ɖaazíki, yele ɩkpɔ́ɔ bɩkpɛdɩ́na kpáyɩ. ");
INSERT INTO kdh_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","A naárʊ waagba nya ɖóóle sɩsɩ nzʊ́ʊ yɩ sʊʊ́tɩ nboná hálɩ kilomɛ́ɛ́tawá natɩ́lɛ, sʊʊ nboná natɩ́náázá. ");
INSERT INTO kdh_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Fa weení wánzʊlʊ́ʊ nya nɛ́, bɩka ngɩ́ weení ɩzɔɔlɛ́ɛ ngɩ́ yɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Mɩ́ɩ́nɩ́ɩ bɔɔdɔ́ sɩsɩ: “Sɔɔlɩ nyɔ́rɔwʊ́ bɩka nlɩzɩ́ weení ɩ́dánjaa nya nɛ́ báɖáárɛ.” ");
INSERT INTO kdh_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Amá, mɔ́ɔ́ ménveerím mɩ́ɩ sɩsɩ: Ɩzɔ́ɔ́lɩ mɩ́báɖaanáa, bɩka ɩsʊ́lʊ wenbá bánváa mɩ́ɩ fúkúḿsi nɛ́ bɔrɔ, ");
INSERT INTO kdh_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","na ɩbɩ́sɩ toovonúm Mɩ́jaa weení ɩwɛ ɩsɔ́ɔ́dáá nɛ́ ɩdɛ́ɛ bíya. Káma, Ɩsɔ́ɔ waalá wɩ́sɩ gɛ sínlosí ɩráavénáa na badaavé nɛ́ barɩ́ŋa, wénÿelíi tɛ́ɛ́wʊ wánnɩɩ́ ɩráavénáa na badaavé nɛ́ bɛdɛ́ɛ fásɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","A wenbá bɔzɔɔlɛ́ɛ mɩ́ɩ nɛ́ beriké gɛ mɩ́zɔɔlɛ́ɛ, kɩvɛrɛwʊ wenkí gɛ mɩ́ɖamáa Ɩsɔ́ɔ-jɔ́. Bɩlɛ́ gɛ tikée mʊʊráa ɖʊɖɔ wánlám. ");
INSERT INTO kdh_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","A mígoobíya riké gɛ mɩ́nzɛɛ́, we gɛ maamááci mɩ́ɩ́lá. Bɩlɛ́ gɛ wenbá baasɩ Ɩsɔ́ɔ nɛ́ ɖʊɖɔ wánlám. ");
INSERT INTO kdh_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Wenbí ńŋɩnáa Mɩ́jaa weení ɩwɛ ɩsɔ́ɔ́dáá nɛ́ ɩbá ɩzɩɩzɛ́ɛ nɛ́, mɩ́nyɔ́ɔ́ ɖʊɖɔ ɩzɩ́ɩ́zɩ bɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Ɩ́kalá mɩ́dɛ́ɛ aɖííni ɩráa-daá sɩsɩ na balaakáarɩ ɩkábɩsɩ mɩ́rɔ́. Tɩ́fa mɩ́vɛ́yɩ́na kɩvɛrɛwʊ nakɩ́rɩ Mɩ́jaa weení ɩwɛ ɩsɔ́ɔ́dáá nɛ́ ɩjɔ́. ");
INSERT INTO kdh_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","A bɩgɛ́ɛ nyɔ́ɔ́ nyánváa kadanbʊrʊ́sɩ nabʊ́rʊ, nkalá hálɩ ɩráa laakáarɩ ɩbɩ́sɩ nyɔ́rɔ́ ńŋɩnáa munáávikíwá wánlám Ɩsɔ́ɔ ɖaazɛɛɖɛ́ na nɩ́báánɩ-daá nɛ́; bɛlɛ́ bánlám bɩlɛ́ gɛ na ɩráa ɩsá wɛ. Ménveerím mɩ́ɩ toovonúm sɩsɩ bɛlɛ́ báńmʊ́ʊ bɛdɛ́ɛ kɩvɛrɛwʊ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Amá, nyɔ́ɔ́, a sɩ nva kadanbʊrʊ́sɩ nabʊ́rʊ, nyánʊ́ʊ́nɩ nɩbɩɩwʊ́ ɩ́katɩlɩ́ wenbí kíɖiiwú waava nɛ́, ");
INSERT INTO kdh_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","na bɩlɔ́ɔ nyána weení nyáává yɩ nɛ́ mɩ́lɔ́wʊ́táá, na Njaa weení wánnáa súmúú-daá nɛ́, ɩfɛ́rɛ nya bɩdɛ́ɛ kɩvɛrɛwʊ.» ");
INSERT INTO kdh_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«A sɩ ɩsɛ́ɛ Ɩsɔ́ɔ, ɩ́kalá nyazɩ munáávikíwá wánlám nɛ́, bɛlɛ́ bángʊrʊ́ʊ gɛ bazɩ́ŋɛ́ɛ Ɩsɔ́ɔ ɖaazɛɛɖɛ́ yáá nɩ́baadará na bʊcɔ ɩráa rɩ́ŋa ɩna wɛ. Ménveerím mɩ́ɩ toovonúm sɩsɩ baajáŋ bánmʊ́ʊ bɛdɛ́ɛ kɩvɛrɛwʊ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Amá, nyɔ́ɔ́ a bɩgɛ́ɛ sɩ nzɛ́ɛ Ɩsɔ́ɔ, sʊʊ nyáɖáḿ-daá ndɔ tará na nzɛ́ɛ Ɩsɔ́ɔ ńna súmúú-daá, na Njaa Ɩsɔ́ɔ weení ɩbɛɛ́na súmúú-daá nɛ́, ɩfɛ́rɛ nya bɩdɛ́ɛ kɩvɛrɛwʊ. ");
INSERT INTO kdh_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","A sɩ ɩsɛ́ɛ Ɩsɔ́ɔ, ɩ́kɔkpɔ́ɔ ŋmatɩrɛ tʊmm bɩ́dɛ́ndɛŋ́ bɩka mɩ́láána tɔ́m kʊ́ɖʊńtɩ tɩvɛ́yɩ́na fɔ́ɔ́zɩrɛ nɛ́ busí ńŋɩnáa wenbá baasɩ Ɩsɔ́ɔ nɛ́ wánlám nɛ́. Bɛlɛ́ bɛdɛ́ɛ lomaazɛ́ gɛ sɩsɩ, asée ɩrʊ́ waaŋmátɩ bʊɖɔ́ɔ na Ɩsɔ́ɔ ɩmʊ ɩdɛ́ɛ sʊlʊ́ńdɩ. ");
INSERT INTO kdh_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ɩ́kamáázɩ wɛ, káma, Mɩ́jaa Ɩsɔ́ɔ nyɩ wenbí bɩjaarɛ́ɛ mɩ́ɩ nɛ́ naanɩ́ ɩbɔ́ɔ́zɩ yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ɩnɩ́ɩ nŋɩ́nɩ́ bɩmɔɔ́na ɩsʊ́lʊ Ɩsɔ́ɔ nɛ́: Ɖájaa weení ɩwɛ ɩsɔ́ɔ́dáá nɛ́, yele ɩráa ɩtɩlɩ́ sɩsɩ nyɛ́gɛ́ɛ ɖacɩrɩ‑cɩrɩ-dʊ́ʊ gɛ; ");
INSERT INTO kdh_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","nyógowúrátɩ íkedi adɛ laadɔ́ɔ-rɔ, bála nyɔ́zɔɔlɩ́m adɛ laadɔ́ɔ-rɔ ńŋɩnáa bánlám ɩsɔ́ɔ́dáá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Fa ɖáa sinje wɩ́rɛ-dɛ́ɛ kíɖíím. ");
INSERT INTO kdh_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Cɛ ɖáa ɖɛ́dɛ́ɛ yɩsɩ́tɩwá, ńŋɩnáa ɖɛ́njɛ́m wenbá baayɩsɩná ɖáa nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nkeyéle ɖáa ɖɩsála ɩ́bɛrɛ-dɛ́ɛ kɔdɔ́sɩ-daá, amá, laná ɖáa bolíni na Sitáánɩ. Káma, nyánáábɩ́lɛ́ kowúrɔ́ɔ na yíko rɩ́ŋa, na ásícé-dʊ́ʊ kpɔɔ lɛlɛɛɖɔ́ hálɩ bɩ́dɛ́ndɛŋ́. Amí. ");
INSERT INTO kdh_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Bɩlɛ́ nɛ́, a bɩgɛ́ɛ mɩ́njɛ́m mɩ́ránáa bɛdɛ́ɛ yɩsɩ́tɩ, Mɩ́jaa weení ɩwɛ ɩsɔ́ɔ́dáá nɛ́ wɛ́njɛ́m mɩ́ɩ ɖʊɖɔ, ");
INSERT INTO kdh_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","amá, a mɩ́dɛ́njɛḿ mɩ́ránáa bɛdɛ́ɛ yɩsɩ́tɩ, Mɩ́jaa ɖʊɖɔ tɛ́njɛḿ mɩ́ɩ mɩ́dɛ́ɛ ńdɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«A bɩgɛ́ɛ sɩsɩ mɩ́vɔ́kɩná, ɩ́kɔcɔ́ɔ cʊ́ḿḿ ńŋɩnáa munáávikíwá wánlám nɛ́. Bɛlɛ́ bɔ́nvɔrɔ́sɩ baazá-daá gɛ bɩka bɔ́dɔnnyɔɔzɩ badɩ na báa weení ɩna sɩsɩ bɔvɔ́kɩná. Ménveerím mɩ́ɩ toovonúm sɩsɩ bɛlɛ́ báńmʊ́ʊ bɛdɛ́ɛ kɩvɛrɛwʊ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Amá, nyɔ́ɔ́, a bɩgɛ́ɛ sɩsɩ nyɔ́vɔ́kɩná, kɔ nyáázá bɩka nzaárɩ nyágʊjʊʊ́ tulaarɩ́, ");
INSERT INTO kdh_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","na baaganáa ɩ́katɩlɩ́ sɩsɩ nyɔ́vɔ́kɩná; amá, yele bɩlɔ́ɔ nyána Ɩsɔ́ɔ mɩ́lɔ́wʊ́táá na bɩka ɩmʊ́ weení wánnáa súmúú-daá nɛ́, ɩfɛ́rɛ nya bɩdɛ́ɛ kɩvɛrɛwʊ.» ");
INSERT INTO kdh_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Ɩ́kacáa ɖɔ́ɔ́lɛ ɩmáárɩ adɛ laadɔ́ɔ-rɔɔzɩ́ lénlé siizeeyá na korɔ́ɔ wánbɩɩzɩ́ bɩfɔrɔ́sɩ ɖɛ yáá ŋmɩɩláa wánbɩɩzɩ́ bɔyɔ́ baŋmɩ́ɩ́lɩ ɖɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ɩjáa ɖɔ́ɔ́lɛ ɩmáárɩ ɩsɔ́ɔ́dáá, káma, ńna siizeeyá na korɔ́ɔ tánbɩɩzɩ bɩfɔrɔ́sɩ ɖɛ, cáńfáná ŋmɩɩláa ɩyɔ́ basʊ́ʊ baŋmɩ́ɩ́lɩ. ");
INSERT INTO kdh_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Káma, lénlé nyɛ́dɛ́ɛ ɖɔ́ɔ́lɛ wɛ nɛ́, ńna ɖʊɖɔ gɛ nyálaakáarɩ wɛ.» ");
INSERT INTO kdh_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Ɩzɩ́rɛ gɛ tɔnʊʊ́-dɛ́ɛ fɩtɩ́la. A nyáázɩ́rɛ na ɖɩdɩ, nyɔ́dɔ́nʊʊ́ rɩ́ŋa wɛ ɖɛnyɛm-daá gɛ. ");
INSERT INTO kdh_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Amá, a nyáázɩ́rɛ fɛ́yɩ́ ɖéyí‑ɖéyí, nyárɩ́ŋa nyɔ́wɛ temenuú-daá gɛ. A ngʊ́ bɩlɛ́ gɛ ɖɛnyɛm kʊwɛ nyɔ́rɔ́ nɛ́ kɛ́ɛ temenuú, yaatá bɩ́nbá bɩnyɔ́ɔ́zɩ bɩlá temenuú gɛ.» ");
INSERT INTO kdh_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Naárʊ fɛ́yɩ́ wánbɩɩzɩ́ ɩlá kʊ́bɔnáa nɔɔ́lɛ bɔwʊtá: wéngizíi kʊ́ɖʊḿ, ɩsɔ́ɔ́lɩ lí ńnɩ́; yáá wánmalanáa ɩdɩ kʊ́ɖʊḿ bɩka ɩkpɛɛná lí ńnɩ́. Mɩ́dánbɩɩzɩ ɩlá Ɩsɔ́ɔ na liideé bɔwʊtá.» ");
INSERT INTO kdh_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Bʊrɔɔzɩ́ gɛ ménveerím mɩ́ɩ sɩsɩ ɩ́kayɩ́tɩ mɩ́dɩ kíɖíím sɩ iɖi na ɩcɔ́ɔ weezuú-daá nɛ́, na kúsúúdi-rɔ. Weezuú waagɩ́lɩ kíɖíím bɩka tɔnʊʊ́ ɩkɩ́lɩ kúsúúdi, yáá bɩdɛkɛ́ɛ bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ɩbɛɛŋná siḿsi: sídónɖuu, sɩ́dángʊḿ; ngʊ́ sɩ́dánjaa kíɖíím sɩmáárɩ kpééni-daá, amá, Mɩ́jaa weení ɩwɛ ɩsɔ́ɔ́dáá nɛ́ wɛ́njɛlɩ́ɩ sɩ. Mɩ́nyɔ́ɔ́ mɩ́vɛ́yɩ́na fɔ́ɔ́zɩrɛ bɩkɩ́lɩ siḿsi? ");
INSERT INTO kdh_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mɩ́dáá weení wánbɩɩzɩ kʊ ɩdɛ́ɛ ɩdɩ yɩtɩ́-daá ɩtándúuzi iweezuú báa cʊ́kɔ. ");
INSERT INTO kdh_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Tɔ́ɔ ngbaalá gɛ mɩ́nÿɩtɩ́ mɩ́dɩ kúsúúdi-rɔɔzɩ́? Ɩbɛɛŋná nyɩ́ɩ́dɩ na tɩdɛ́ɛ fɛ́ɛ́dɩ́tɩ-dɛ́ɛ kazɔ́ɔ, tɩ́dánlaḿ tɩmɛ́rɛ, tɩ́dánlʊʊ, ");
INSERT INTO kdh_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","amá, wúro Sulemáana tɩtɩŋa na ɩdɛ́ɛ ásícé, ɩdɛ́ɛ kúsúúdi tacʊʊná tɩ. ");
INSERT INTO kdh_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","A Ɩsɔ́ɔ wɔ́nzɔ́ɔ nyɩ́ɩ́dɩ tɩwɛ sinje bɩka ceré sɩ bɔsɔ́ tɩ nimíni nɛ́ lɩ́m ńŋɩnáa ɖɔ́, ɩdɔ́nzɔ́ɔ mɩ́ɩ bɩkɩ́lɩ bɩlɛ́? Toovonúm fáa tɔɖɔ́ɔ-dɩnáa mɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Bɩlɛ́ nɛ́ ɩ́kayɩ́tɩ mɩ́dɩ sɩsɩ: We gɛ ɖénɖíi. We gɛ ɖɔ́nnyɔɔ́ yáá we gɛ ɖónzuú. ");
INSERT INTO kdh_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Wenbá baasɩ Ɩsɔ́ɔ nɛ́ mɔɔ́na kʊ balá bɩlɛ́. Mɩ́nyɔ́ɔ́ Mɩ́jaa Ɩsɔ́ɔ nyɩ wenbí bɩjɔɔ́ɔ mɩ́ɩ takáásɩ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kaɖaa-dɛ́ɛ, ɩjáa Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ na wenbí bɩzɩɩzɛ́ɛ yɩ nɛ́. Wenbí bɩrɩ́ŋa bɩɩga bɩ nɛ́, wánváa mɩ́ɩ bɩ. ");
INSERT INTO kdh_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Bɩlɛ́ nɛ́, ɩ́kayɩ́tɩ mɩ́dɩ ceré-rɔɔzɩ́ sinje. A ceré-dɛ́ɛ ńbɩ wɔɔgɔ́nɩ, ɩrʊ́ wánnáa nŋɩ́nɩ́ sɩ ɩkpɔɔná nɛ́. Báa wɩ́rɛ wenɖé na ɖɩdɛ́ɛ ɖɩwɩɩrɛ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Ɩ́kafʊʊná naárʊ, na bádanvʊʊná mɩ́ɩ; ");
INSERT INTO kdh_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","káma, wenbí mɩ́nvʊʊnáa baaganáa nɛ́ gɛ sɩ bafʊʊná mɩ́ɩ, bɩka kɩ́maazʊʊ́ wenkí mɩ́nmaazɩnáa baaganáa nɛ́ gɛ sɩ bamaazɩ ná mɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ngbaalá gɛ nyɛ́bɛɛ́na keyiká kɔwɛ nyɔ́rɔwʊ́ ɩzɩ́rɛ-daá nɛ́, bɩka ńdánnáa ɖaagbetumuú kʊwɛ nyɛ́dɛ́ɛ-ńɖɛ-daá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nŋɩ́nɩ́ gɛ nyánbɩɩzɩ́ ndɔ́ ngoobú sɩsɩ: “Yele malɩzɩ́ keyiká kɔwɛ nyáázɩ́rɛ-daá nɛ́,” bɩka ɖaagbetumuú gɛ nyɛ́dɛ́ɛ-ńɖɛ-daá. ");
INSERT INTO kdh_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Munáávikí, lɩzɩ́ ɖaagbetumuú nyáázɩ́rɛ-daá naanɩ́ na bʊcɔ nya nna kazɔ́ɔ nlɩzɩ́ keyiká kɔwɛ ngoobú ɩzɩ́rɛ-daá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ɩ́kɔkpɔ́ɔ wenbí baalɩzɩ́ bɩ basɩ́ɩ Ɩsɔ́ɔ nɛ́ ɩfa fáázɩ. Ɩ́kɔkpɔ́ɔ kejísi ɩlɔ afawá na tɩ́kɔkɔ́nɩ tɩnʊ́ŋ sɩ bɩka fáázɩ ɩfaná mɩ́ɩ ɩzá sɩnyásɩ mɩ́ɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Ɩbɔ́ɔ́zɩ, bánváa mɩ́ɩ; ɩjáa, mínÿuúu; ɩgɔ́tɩ, bándʊlʊ́ʊ mɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Káma, weení ɩrɩ́ŋa wɔ́nbɔɔzɩ́ nɛ́ bánváa yɩ, weení wánjáádɩ nɛ́ wónÿuúu bɩka weení wɔ́ngɔtɩ́ nɛ́ bándʊlʊ́ʊ yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Mɩ́dáá naárʊ wɛ a ibú wɔɔbɔ́ɔ́zɩ yɩ kpɔ́nɔ́, wánváa yɩ bʊ́ʊ́rɛ? ");
INSERT INTO kdh_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Yáá a wɔɔbɔ́ɔ́zɩ yɩ tińɖe, wɔ́ngbɔwʊ́ʊ ɖoḿ ɩfa yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Na bɩrɩ́ŋa mɩ́dáávé nɛ́, mɩ́nyɩ mɩ́nváa míbíya wenbí bɩjɔɔ́ɔ kazɔ́ɔ nɛ́. Bɩ́nlám nŋɩ́nɩ́ na Mɩ́jaa weení ɩwɛ ɩsɔ́ɔ́dáá nɛ́ ɩ́dánváa ibíya kazɔ́ɔ ńbɩ wenbí bɔ́nbɔɔzɩ́ yɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ɩlá baaganáa wenbí bɩrɩ́ŋa mɩ́zɔɔlɛ́ɛ sɩsɩ bɛlɛ́ bála mɩ́ɩ nɛ́, káma, bɩlɛ́ gɛ Múúsá-dɛ́ɛ Mará na anɖébiwá baaganáa waawɩ́lɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Ɩzʊʊ ná ɖaḿ wɔnɔɔ́ kadawála nɛ́, káma ɖaḿ wɔnɔɔ́ kaawála nɛ́, na nɩ́bááwʊ kɩɩwála kɩrɔɔzɩ́ fɛ́yɩ́ káálɛ nʊŋɛ́ nɛ́ wɛ́nɖɛɛ́ nimíni-daá gɛ. Ngɛ kɩlɛ́ gɛ ɩráa ɖabata wánmʊnáa. ");
INSERT INTO kdh_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Amá, ɖaḿ wɔnɔɔ́ kadawála nɛ́, na nɩ́bááwʊ kɩdawála kɩrɔɔzɩ́ cɔɔ́ɔ káálɛ nʊŋɛ́ nɛ́, wɛ́nɖɛɛ́ weezuú-daá gɛ. Ɩráa cʊ́kɔ wɔ́ngbɔɔná kʊ kɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Iguná laakáarɩ na anɖébiwá bʊbɔtɩnáa. Bɔ́ngɔnɩ́ mɩ́jɔ́ nɛ́, bogozóóna gɛ nyazɩ fééni. Amá, badaá, káwʊ‑káwʊwá gɛ bɛgɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Balakásɩ gɛ mɩ́ndɩlɩ́ɩ na wɛ, káma, bɔ́dɔ́ngɔrɩ́ furúu bíya sɔɔzɔ́ɔ́zɩ-daá, yáá kɩjɩcɩ́lʊ́ʊ bíya bʊvʊ́m-daá. ");
INSERT INTO kdh_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tɩɩwʊ́ kazɔ́ɔ ńgɩ wánɖʊ́ʊ bíya kazɔ́ɔ ńba gɛ, bɩka tɩɩwʊ́ kɩdaavé nɛ́ ɩɖʊ bíya badaavé nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tɩɩwʊ́ kazɔ́ɔ ńgɩ tánbɩɩzɩ kɩɖʊ bíya badaavé nɛ́, yáá tɩɩwʊ́ kɩdaavé nɛ́ ɩɖʊ bíya kazɔ́ɔ ńba. ");
INSERT INTO kdh_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tɩɩwʊ́ wenkí kɩrɩ́ŋa kɩ́dánɖʊ́ʊ bíya kazɔ́ɔ ńba nɛ́, bɛ́nbɛlɩ́ɩ kɩ gɛ baɖʊ nimíni. ");
INSERT INTO kdh_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Bɩlɛ́ nɛ́, anɖébiwá bʊbɔtɩnáa, balakásɩ gɛ mɩ́ndɩlɩ́ɩ na wɛ.» ");
INSERT INTO kdh_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Bɩdɛkɛ́ɛ wenbá barɩ́ŋa bánÿaá ma sɩsɩ: “Ɖádʊ́ʊ, Ɖádʊ́ʊ” nɛ́, sɩ basʊʊ ná Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-daá, amá, wenbá bánlám Majaa weení ɩwɛ ɩsɔ́ɔ́dáá nɛ́ ɩdɛ́ɛ sɔɔlɩ́m nɛ́ gɛ. ");
INSERT INTO kdh_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tɔ́m fʊ́ʊ́dɩ wɩ́rɛ wándalɩ́ɩ nɛ́, ɖabata wɔ́ndɔ́m ma sɩsɩ: “Ɖádʊ́ʊ, mányɩ sɩsɩ na nyáyɩ́ɖɛ-daá gɛ ɖááŋmátɩ ɩráa Ɩsɔ́ɔ-dɛ́ɛ tɔ́m, ɖɩɖɔ́ɔ zííniwá ya. Na nyáyɩ́ɖɛ-daá, ɖáálá maamááciwá ɖabata.” ");
INSERT INTO kdh_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Na mobúsi wɛ sɩsɩ: “Kɛtɛngɛrɛ mádátɩ́lɩ́ mɩ́ɩ; ɩlaná ma bolíni, mɩ́nyɔ́ɔ́ wenbá mɩ́nlám bɩdaavé nɛ́.”» ");
INSERT INTO kdh_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Ɩrʊ́ weení waanɩ́ɩ tɔ́m mánŋmatɩ́ mɩ́ɩ tɩ ɖɔ́ nɛ́, ngɛ woovu ɩlá wenbí tɩ́nbɔɔzɩ́ nɛ́, cɔɔ́ɔ gɛ nyazɩ ɩrʊ́ áséńsí-dʊ́ʊ weení waama ɩɖɔɔ́ bʊ́tangbalʊʊ́-rɔ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tɛ́ɛ́wʊ waanɩ́ɩ, búúzi isu sɩyɛlɩ́, fefelimá kʊ́bɔná ɩfɛ́tɩ na ɖóni, bɩrɩ́ŋa bɩkʊrʊ́na ɖɔɔ́ kɛḿ; amá, ɖɔɔ́ kɛḿ kadasála, káma, bʊ́tangbalʊʊ́-rɔ gɛ baazɩ́ɩ kɛdɛ́ɛ ɖɩzɩɩrɛ. ");
INSERT INTO kdh_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Amá, ɩrʊ́ weení waanɩ́ɩ tɔ́m mánŋmatɩ́ mɩ́ɩ tɩ ɖɔ́ nɛ́, ngɛ ɩdalá wenbí tɩ́nbɔɔzɩ́ nɛ́ cɔɔ́ɔ gɛ nyazɩ ɩrʊ́ kʊjʊʊ́ fɛ́yɩ́-dʊ́ʊ weení waama ɩɖɔɔ́ kanyɩ́ŋa-daá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tɛ́ɛ́wʊ waanɩ́ɩ, búúzi isu sɩyɛlɩ́, fefelimá kʊ́bɔná ɩfɛ́tɩ, ngɛ ɖɔɔ́ waazála kabá konúúdi.» ");
INSERT INTO kdh_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yeésu waaŋmátɩ tɔ́mwá tɩḿ bɩtɛ́ nɛ́, ngɛ ɩdɛ́ɛ wɩlɩ́ɩ waabá bɩlá zamɔ́ɔ bítí. ");
INSERT INTO kdh_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ɩ́dánwɩlɩ́ nyazɩ bɛdɛ́ɛ Mará wɩlɩɖáa wánwɩlɩ́ɩ nɛ́, amá, wánwɩlɩnáa yíko wenkí Ɩsɔ́ɔ weejéle yɩ nɛ́ gɛ. ");
INSERT INTO kdh_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yeésu weedí bʊ́ʊ nɛ́, ngɛ zamɔ́ɔ kʊ́bɔńgɩ woovu yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ńna gɛ cɛnɩŋa nɛkɛ́rɛ woogóduu ɩjɔ́ kosóm waazá-daá kɔtɔ́ yɩ sɩsɩ: «Kʊ́bɔnɩ́ mányɩ sɩsɩ a nyɔ́zɔɔlɛ́ɛ, nyánbɩɩzɩ́ nÿéle mawáa malá ɖacɩrɩ‑cɩrɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ngɛ Yeésu wɔɔvɔ́ ɩnʊ́ʊ́nɩ itekiná kɛ ɩtɔ́ kɛ sɩsɩ: «Ɩɩ́n, mɔ́zɔɔlɛ́ɛ, waa nlá ɖacɩrɩ‑cɩrɩ.» Ngɛ ńna‑ńna gɛ kɛdɛ́ɛ cɛnɩ́tɩ waawáa kalá ɖacɩrɩ‑cɩrɩ. ");
INSERT INTO kdh_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ngɛ Yeésu wɔɔdɔ́ kɛ sɩsɩ: «Welesi nnɩ́ɩ ma kazɔ́ɔ. Nkefééri naárʊ wenbí bɩɩlá nɛ́. Amá, bo Ɩsɔ́ɔ sarásɩ lanɖʊ́ ɩna wenbí nyɔ́jɔɔ́ɔ nɛ́, na nlá sarɔ́ɔ wenká Múúsá wɔɔdɔ́ sɩsɩ bála nɛ́, na báa weení ɩtɩlɩ́ sɩsɩ nyááwáa.» ");
INSERT INTO kdh_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yeésu sɩ ɩsʊ́ʊ Kapɛrɩnawʊ́m tɛ́ɛ́dɩ-daá nɛ́, ngɛ Róóma sɔ́ɔ́ja kʊ́bɔnɩ́ naárʊ woogóduu ɩjɔ́ wánvɩnɩ́ yɩ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«Kʊ́bɔnɩ́, mɛ́dɛ́ɛ bɔwʊtá-dʊ́ʊ lewáa ɖaána biilí yɩ ɩbá wɛ́nÿɛlɛ́m.» ");
INSERT INTO kdh_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ngɛ Yeésu woobúsi yɩ sɩsɩ: «Mónboɖé magáwaazɩ yɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ngɛ sɔ́ɔ́ja kʊ́bɔnɩ́ woobúsi yɩ sɩsɩ: «Kʊ́bɔnɩ́, mádatála nzʊ́ʊ máɖaána-daá, amá, ŋmatɩ tɔ́m bú kʊ́ɖʊḿ, mɛ́dɛ́ɛ bɔwʊtá-dʊ́ʊ wánwaá. ");
INSERT INTO kdh_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mádɩtɩŋa mɔ́wɛná mɛ́dɛ́ɛ kʊ́bɔnáa, bɩka mɔ́wɛná sɔ́ɔ́jawá mɛ́dɛ́ɛ́zɩ́ mɛ́dɛ́ɛ tɩmɛ́rɛ-daá. A mɔ́ɔ́dɔ́ mɛ́dɛ́ɛ yoḿ sɩsɩ: ɖɛɛ, wɛ́nɖɛɛ́ gɛ; a mááyáa weení nɛ́, wɔ́ngɔnɩ́ gɛ; a mɔ́ɔ́dɔ́ naárʊ sɩsɩ la ɖɔ́, wánlám gɛ.» ");
INSERT INTO kdh_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yeésu waanɩ́ɩ ɩrʊ́ ceení-dɛ́ɛ ŋmatɩrɛ nɛ́, ngɛ bɩɩlá yɩ mááɖé ɩtɔ́ wenbá bovóo yɩ nɛ́ sɩsɩ: «Ménveerím mɩ́ɩ toovonúm sɩsɩ, mádanáá ta toovonúm fáa ńŋɩnáa bɩna bɩdaká Israyɛ́ɛlɩ bíya-daá. ");
INSERT INTO kdh_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ménveerím mɩ́ɩ sɩsɩ ɩráa ɖabata wángalɩɩnáa wɩ́sɩ ɖaagalɩɩɖɛ́ na sɩɖaagazalaɖɛ́ fáráńdɩ́ bána Ibrahím na Ɩsaáka na Yaakúbu, boyóózi bɔcɔ́ɔ beɖi Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-daá. ");
INSERT INTO kdh_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Bɩka wenbá báta basʊ́ʊ kadaá nɛ́, bɛbɛ́ɖɩ wɛ asʊ temenuú-daá bewíi balá mányɩ lé.» ");
INSERT INTO kdh_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ngɛ Yeésu wɔɔdɔ́ sɔ́ɔ́ja kʊ́bɔnɩ́ sɩsɩ: «Bo ngbé; nyɛ́dɛ́ɛ toovonúm fáa wénÿelíi nÿuú wenbí nyɔ́ɔ́bɔ́ɔ́zɩ nɛ́.» Ngɛ kʊ́bɔnɩ́-dɛ́ɛ tɩmɛlanɖʊ́ waadáwáa sáátɩ kɩḿ nɔ́ɔ́. ");
INSERT INTO kdh_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Bʊwɔ́rɔ́ nɛ́, Yeésu woobó Pétro-dɛ́ɛ ɖaána. Ngɛ wɔɔmɔɔná Pétro nɔɔzɔ́ɔ ɩvɩ́nɛ́ɛ wánnyaadɩ́ bɩka ɩdɔnʊʊ́ ɩbá kizoláa. ");
INSERT INTO kdh_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yeésu weedekiná ɩnʊ́ʊ́nɩ, ngɛ waawáa ɩkʊrʊ́ ɩɖʊ yɩ kíɖíím. ");
INSERT INTO kdh_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ɖaanɩ́ŋa waalá nɛ́, bɔɔgɔná Yeésu ɩráa ɖabata zííniwá wánjaarɩ́ wɛ nɛ́, na ɩdɛ́ɛ ŋmatɩrɛ gɛ wɔɔɖɔɔ ná zííniwá tɩḿ. Ngɛ waawáázɩ kʊdɔndɩnáa bɔɔgɔ́nɩ nɛ́ barɩ́ŋa. ");
INSERT INTO kdh_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Waalá bɩlɛ́ gɛ na wentí anɖébi Esáya waaŋmátɩ nɛ́ ikóódi; tɩlɛ́ gɛ sɩsɩ: «Wɔɔgbɔ́ɔ ɖɛ́dɛ́ɛ mádafɩ́yatɩ ɩrɔ, bɩka ɩmʊ ɖágʊdɔmɩ́nɩ rɩ́ŋa.» ");
INSERT INTO kdh_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yeésu waana wenbí zamɔ́ɔ waalára kɩmɩlɩná yɩ nɛ́, ngɛ sɩsɩ bɛ́tɛ́sɩ́ná lɩɩrɛ́ kʊ́bɔńɖɛ-dɛ́ɛ fúu lí ńgɩ-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ńna gɛ Mará wɩlɩɖʊ́ naárʊ woogóduu ɩjɔ́ ɩtɔ́ yɩ sɩsɩ: «Kʊ́bɔnɩ́, báa lé gɛ nyɛ́nɖɛɛ́ móvóo nya gɛ.» ");
INSERT INTO kdh_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ńna gɛ Yeésu woobúsi yɩ sɩsɩ: «Sɔ́ɔ́lɛ́ɛ́rásɩ wɛná bɔ́ɔ́nɩ bɩka siḿsi wɛná ɖɛ́ńɖɛ́lá, amá, Ɩrʊ́ Biyaalʊ́ fɛ́yɩ́na lénlé sɩ ɩfɩ́nɩ ɩfɛ́ɛ́zɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Bʊwɔ́rɔ́ gɛ Yeésu-dɛ́ɛ wanbaaráa-daá naárʊ wɔɔdɔ́ yɩ sɩsɩ: «Kʊ́bɔnɩ́, fa ma nɩ́bááwʊ mobó megébi majaa naanɩ́.» ");
INSERT INTO kdh_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ngɛ Yeésu woobúsi yɩ sɩsɩ: «Kovu ma bɩka nÿéle ɩsɩɖáa ibí bɛdɛ́ɛ ɩsɩɖáa.» ");
INSERT INTO kdh_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Bɩlɛ́ bʊwɔ́rɔ́ gɛ Yeésu waagba kpɩ́ɩ́rʊʊ́-daá, ngɛ ɩwanbaaráa waaláázɩ yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ńna‑ńna gɛ fefelimá kʊ́bɔná waabáázɩ fɛtɩ́ lɩɩrɛ́ kʊ́bɔńɖɛ-rɔ bɩka bɩ́ndańdɩ kpɩ́ɩ́rʊʊ́ hálɩ lɩ́m wánzʊʊ́ kɩdaá. Amá, Yeésu wɛ wónɖóm. ");
INSERT INTO kdh_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ńna gɛ ɩwanbaaráa woogóduu ɩjɔ́ beféézi yɩ bɔtɔ yɩ sɩsɩ: «Kʊ́bɔnɩ́, lɛɛ ɖáa, ɖánzɩ́m!» ");
INSERT INTO kdh_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Ngbaalá gɛ mɩ́jɔɔ́ɔ nɩdáárɛ bɩlɛ́, toovonúm fáa tɔɖɔ́ɔ-dɩnáa mɩ́ɩ.» Ngɛ waagʊrʊ́ ɩkazɩ́ fefelimá na lɩ́m, ngɛ bɩɩzála bɩcɔ́ɔ ɖɛfɛɛ. ");
INSERT INTO kdh_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ńna gɛ bɩɩlá ɩwanbaaráa rɩ́ŋa bítí hálɩ bɔ́nbɔɔzɩ́ badɩ sɩsɩ: «Ɩrʊ́ ceení gɛ weení gɛ bɩkpɛdɩ́na lɩ́m na fefelimá wánlám wenbí wɔɔbɔ́ɔ́zɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yeésu wɛɛdɛsɩná lɩɩrɛ́ kʊ́bɔńɖɛ-dɛ́ɛ fúu lí ńgɩ-rɔ Gadaráa tɛ́ɛ́dɩ-daá nɛ́, ngɛ ɩráa nɔɔ́lɛ zííniwá wánjaarɩ́ wɛ nɛ́, waagálɩ́ɩ́ná bɔɔláánɩ-daá bɛgɛgɛrɛŋɛ sɩ basɩ́ŋ yɩ. Bɛdɛ́ɛ bánlám ɩráa bɩdaavé nɛ́ weeyéle naárʊ tɔ́ngbɔɔná nɩ́bááwʊ kɩḿ. ");
INSERT INTO kdh_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ngɛ ɩráa bɛḿ baabáázɩ agogo sɩsɩ: «Ɩsɔ́ɔ Biyaalʊ́, we gɛ nyɔ́zɔɔlɛ́ɛ na ɖáa. Yáá nyɔ́ɔ́gɔ́nɩ sɩ nva ɖáa fúkúḿsi naanɩ́ alɩwáátɩ Ɩsɔ́ɔ waazɩ́ɩ kɩ nɛ́ kɩtála.» ");
INSERT INTO kdh_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Afawá natɩ́rɩ cɔɔ́ɔ na wɛ bolíni cʊ́kɔ, tɩlɛ́ tɩwɛ tínɖíi kíɖíím. ");
INSERT INTO kdh_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ngɛ zííniwá waavɩ́nɩ Yeésu sɩsɩ: «A bɩgɛ́ɛ sɩ nɖɔ́ɔ ɖáa, yele ɖáa ɖɩsʊ́ʊ afawá fuúre ɖɩna ɖɩdaá.» ");
INSERT INTO kdh_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ngɛ Yeésu waava tɩ wɛ́ɖɛ sɩsɩ tíbo tɩɖɛ́ɛ. Ngɛ zííniwá waalɩ́ɩ ɩráa nɔɔ́lɛ bɛḿ bɔrɔ tibó tɩsʊ́ʊ afawá. Ngɛ afawá waalɩ́ɩ bʊ́ʊyɔ́ɔ kʊjʊʊ́-daá na sewɔ́ɔ tɩsʊ́ʊ lɩɩrɛ́ kʊ́bɔńɖɛ-daá lɩ́m iɖi tɩ tɩsɩ́. ");
INSERT INTO kdh_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Wenbá béngetí afawá tɩḿ nɛ́ beeze bobó tɛ́ɛ́dɩ-daá batɩ́ wenbí bɩɩlá nɛ́ befééri, na wenbí bɩɩmɔɔná zííniwá-dɩnáa nɔɔ́lɛ bɛḿ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ńna gɛ tɛ́ɛ́dɩ-daá ɩráa rɩ́ŋa waagálɩɩ sɩ bɛkɛ́tɩ Yeésu. Baana yɩ nɛ́, ngɛ baavɩ́nɩ yɩ sɩsɩ ɩ́lɩɩ bɛḿ balaadɔ́ɔ-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ngɛ Yeésu waagba kpɩ́ɩ́rʊʊ́-daá ɩtɛ́sɩ lɩɩrɛ́ kʊ́bɔńɖɛ ɩbɩ́sɩ ɩdɛ́ɛ́dɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ńna gɛ bɔɔgɔná yɩ gaala‑gáálɔɔ́ kagavɩ́nɛ́ɛ kagɩgbáláwʊ-rɔ. Yeésu waana nŋɩ́nɩ́ baava yɩ toovonúm nɛ́, ngɛ wɔɔdɔ́ gaala‑gáálɔɔ́ sɩsɩ: «Ɖɔkɩ nyádɩ móbú, mɛ́ɛ́jɛ́ nya nyɛ́dɛ́ɛ alaháácɩ́wá.» ");
INSERT INTO kdh_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ńna gɛ Mará wɩlɩɖáa nɛbɛ́rɛ wɔɔdɔ́ badaá sɩsɩ: «Ɩrʊ́ ceení wánŋmatɩ́ wɛ́ngbɛɛnáa Ɩsɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yeésu waadɩlɩ́ wentí bánmaazɩ́ nɛ́, ngɛ wɔɔdɔ́ wɛ sɩsɩ: «We-rɔ gɛ mɩ́nmaazɩ́ wenbí bɩdaavé nɛ́ bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mɔdɔ́ sɩsɩ: bɛɛjɛ́ nya nyɛ́dɛ́ɛ alaháácɩ́wá, yáá mɔdɔ́ sɩsɩ: kʊrʊ́ nnʊ́ŋ, bɩlɛ́ɛ́nɩ́ bɩlɔwʊtáá, wenbí fɛ́yɩ́na káálɛ. ");
INSERT INTO kdh_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Amá, mɔ́zɔɔlɛ́ɛ ɩtɩlɩ́ sɩsɩ Ɩrʊ́ Biyaalʊ́ wɛná yíko ɩcɛ́ ɩráa bɛdɛ́ɛ alaháácɩ́wá adɛ laadɔ́ɔ-rɔ cé.» Ngɛ wɔɔdɔ́ gaala‑gáálɔɔ́ sɩsɩ: «Kʊrʊ́ ngbɔ́ɔ nyágɩgbáláwʊ ngbé nyɛ́dɛ́ɛ.» ");
INSERT INTO kdh_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ngɛ ɩlɛ́ waagʊrʊ́ ikpé ɩdɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Zamɔ́ɔ waana bɩlɛ́ nɛ́, ngɛ kɩɩnɩ́ɩ nɩdáárɛ bɩka kɩ́nzám Ɩsɔ́ɔ ńŋɩnáa waava ɩráa yíko ńŋɩnáa kɩna nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yeésu waalɩ́ɩ ńna wɛ́nɖɛɛ́ nɛ́, ngɛ waana abaalʊ́ naárʊ bánÿaá yɩ sɩsɩ Maatéwu, ɩjɔɔ́ɔ wánmʊ́ʊ tikée ɩdɩmɛ́rɛ-daá. Ngɛ wɔɔdɔ́ yɩ sɩsɩ: «Kovu ma.» Ngɛ Maatéwu waagʊrʊ́ ifu yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Bɩɩgɔ́nɩ Yeésu ibó ɩsʊ́ʊ Maatéwu-dɛ́ɛ ɖaána-daá kíɖíím ɖíi. Tikée mʊʊráa ɖabata na alaháácɩ́-dɩnáa, bɔɔgɔ́nɩ bɔcɔ́ɔ ɩjɔ́ bána ɩwanbaaráa bénɖíi kíɖíím. ");
INSERT INTO kdh_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Faríizi ńba waana bɩlɛ́ nɛ́, ngɛ bɔɔdɔ́ Yeésu-dɛ́ɛ wanbaaráa sɩsɩ: «Bɩyáásɩ́ gɛ mɩ́dɛ́ɛ kʊ́bɔnɩ́ na tikée mʊʊráa na alaháácɩ́-dɩnáa booyóózi bénɖíi kíɖíím.» ");
INSERT INTO kdh_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yeésu waanɩ́ɩ bánŋmatɩ́ bɩlɛ́ nɛ́ gɛ sɩsɩ: «Kʊdɔndɩnáa wánjáádɩ kʊ lákʊ́ta, alaafɩ́ya-dɩnáa baafɛ́yɩ́na yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ibó ɩcáa tɔ́m tɩna Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m waaŋmátɩ nɛ́ tugutoluú; tɩlɛ́ gɛ sɩsɩ: “Kʊnyɔnnɩɩrɛ́ waagɩ́lɩ ma fʊ́ńdɩ kpɩná mɩ́ngʊ́ʊ sɩsɩ mɩ́ɩ́lá ma sarɔ́ɔ nɛ́.” Káma, mɔ́dɔkɔ́nɩ sɩ mayáa wenbá bazɩɩzɛ́ɛ nɛ́, amá, alaháácɩ́-dɩnáa-rɔ gɛ mɔ́ɔ́gɔ́nɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Yeésu waaŋmátɩ bɩlɛ́ bɩtɛ́ nɛ́, ngɛ Yaayá-dɛ́ɛ wanbaaráa woogóduu ɩjɔ́ bɔbɔ́ɔ́zɩ yɩ sɩsɩ: «We-rɔ gɛ ɖɔ́ɔ́ ɖána Faríizi ńba ɖɔ́ndɔ́rɔ́vɔ́kɩ́ nɔɔ́ gɛ nyɛ́dɛ́ɛ wanbaaráa tɔ́nvɔkɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yeésu woobúsi wɛ sɩsɩ: «Mɩ́nmaazɩ́ sɩsɩ weetáhárʊ ɖɔndɩnáa mɔɔ́na bɔcɔ́ɔ ɩzá nyɩ́nŋɩrɛ-daá sáátɩ wenkí bána weetáhárʊ nɛ́? Bɩ́dánlaḿ bɩlɛ́. Sáátɩ nakɩ́rɩ wɔ́ngɔnɩ́, bɔ́ngɔnɩ́ balɩzɩ́ yɩ bɔlɔwʊtáá. Bɩdɛ́ɛ sáátɩ gɛ bɔ́nvɔkɩ́ nɔɔ́.» ");
INSERT INTO kdh_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Yeésu waadásɩ ɩtɔ́ wɛ sɩsɩ: «Naárʊ fɛ́yɩ́ wɔ́ngbɔwʊ́ʊ bɩsaawʊ́ kedeyɔ́ɔ kɩ́falɔɔ́ ɩtɔ ná tóko kɩ́bɩńgɩ. Tɩ́fa bɩsaawʊ́ kɩ́falʊʊ́ wánjɩrɩ́ɩ tóko kɩ́bɩńgɩ gɛ, bɔɔwʊ́ ɩnyɔ́ɔ́zɩ kɩwála. ");
INSERT INTO kdh_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ngʊ́ bɩlɛ́ gɛ bódónzuu sʊlʊ́m kɩ́fabɩ bɩdabɩɩ tá bɩtɛ́ nɛ́ tɔ́nɖɛ furuú kɩ́bɩńgɩ-daá, tɩ́fa kɩ́nÿáa gɛ, sʊlʊ́m ɩbɩ́rɩ adɛ, tɔ́nɖɛ furuú ɩlá ásáráwʊ́. Amá, bónzuú sʊlʊ́m kɩ́fabɩ bɩdabɩɩ tá bɩtɛ́ nɛ́ tɔ́nɖɛ furuú kɩ́falʊʊ́-daá gɛ na bɩrɩ́ŋa bɩcɔ́ɔ ɖéyí‑ɖéyí.» ");
INSERT INTO kdh_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yeésu bamáa ŋmatɩrɛ bɩlɛ́ nɛ́ gɛ Yahúúɖuwá-dɛ́ɛ kʊ́bɔnɩ́ naárʊ wɔɔgɔ́nɩ ɩká ɩɖʊná-rɔ waazá-daá ɩtɔ́ sɩsɩ: «Lɛlɛɛkɩna gɛ mɛwɛɛlɛ́ɛ weevéti. Amá, kɔnɩ ngádɩnɩ nʊ́ʊ́nɩ ɩrɔ, wénvém.» ");
INSERT INTO kdh_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ńna gɛ Yeésu waagʊrʊ́ ɩ́na ɩwanbaaráa batɩ́nɩ ɩwɔ́rɔ́. ");
INSERT INTO kdh_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ngɛ alʊ́ naárʊ azimá wéndináa yɩ bʊwɛná bɩ́ɩ́zɩ fuú na nasɩ́lɛ nbɩlɛ́ nɛ́ woogóduu itekiná Yeésu-dɛ́ɛ tóko njʊ́ʊ́rɛ na ɩwɔ́rɔ́. ");
INSERT INTO kdh_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Alʊ́ ɩmʊ́ waamáázɩ sɩsɩ: «A ɖé máábɩ́ɩ́zɩ medekiná idóko, mánwaá.» ");
INSERT INTO kdh_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yeésu wɛɛgɛ́ɛ́zɩ ɩdɩ ɩbɛ́ɛ́ŋ yɩ, ngɛ wɔɔdɔ́ yɩ sɩsɩ: «Ɖɔkɩ nyádɩ mɛwɛɛlɛ́ɛ, nyɛ́dɛ́ɛ toovonúm fáa wɛɛlɛ́ɛ nya.» Sáátɩ kɩḿ nɔ́ɔ́ gɛ alʊ́ ɩmʊ́ waajáŋ ɩwáa. ");
INSERT INTO kdh_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yeésu woobó ɩtála Yahúúɖuwá-dɛ́ɛ kʊ́bɔnɩ́ ɩmʊ́ ɩdɛ́ɛ. Ngɛ wɔɔmɔɔná foyísi-dɩnáa bángbɩɩrɩ́ sɩ bɛɖɛ́ɛ ɩrʊ́ bím, bɩka ɩráa zamɔ́ɔ wɛ ɖaána-daá bénwií, bóngoó. ");
INSERT INTO kdh_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ńna gɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Ɩlɩ́ɩ, káma, aléeré tasɩ́, wónɖóm gɛ.» Ngɛ bɛlɛ́ baamʊ́ŋ yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Baalɩzɩ́ zamɔ́ɔ asʊ nɛ́, Yeésu waazʊ́ʊ ɖaḿ-daá ɩɖɔ́kɩ aléeréyɔ́ɔ ɩmʊ́ ɩnʊ́ʊ́nɩ-daá, ngɛ aléeré waagʊrʊ́. ");
INSERT INTO kdh_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ngɛ tɔ́m tɩḿ tiizu fáráńdɩ́ kɩḿ kɩrɩ́ŋa kɩdaá. ");
INSERT INTO kdh_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yeésu waalɩ́ɩ ńna wɛ́nɖɛɛ́ nɛ́ gɛ njɛma nɔɔ́lɛ waalɩ́ɩ batɩ́nɩ ɩwɔ́rɔ́ bóngoó sɩsɩ: «Ɖáwʊɖa Biyaalʊ́, nɩɩ ɖágʊnyɔḿ.» ");
INSERT INTO kdh_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yeésu waadála ɖaána nɛ́, njɛma woogóduu ɩjɔ́. Ngɛ wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «Mɩ́ɩ́vá toovonúm sɩsɩ mánbɩɩzɩ́ mawáázɩ mɩ́ɩ?» Ngɛ bɛlɛ́ boobúsi yɩ sɩsɩ: «Ɩɩ́n kʊ́bɔnɩ́». ");
INSERT INTO kdh_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ńna gɛ Yeésu weedekiná baazá ɩtɔ́ sɩsɩ: «Bɩ́la mɩ́ɩ ńŋɩnáa wenbí mɩ́ɩ́vá toovonúm nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ngɛ baabáázɩ náa. Ngɛ waabá ɩbásɩ wɛ sɩsɩ békeyéle naárʊ ɩnɩ́ɩ tɩ. ");
INSERT INTO kdh_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Amá, bɛlɛ́ boobó gɛ bekiliná tɩ fáráńdɩ́ kɩḿ kɩrɩ́ŋa kɩdaá. ");
INSERT INTO kdh_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Sáátɩ wenkí njɛma wánlɩɩ́ nɛ́ gɛ bɔɔgɔná Yeésu ɩrʊ́ naárʊ zííni waabɩsɩná yɩ komóomúŋa nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yeésu wɔɔɖɔ́ɔ zííni kɩḿ nɛ́, ngɛ komóomúŋa waabáázɩ ŋmatɩrɛ. Ngɛ bɩɩlá zamɔ́ɔ bítí bɩka kɩ́ndɔ́m sɩsɩ: «Kɛtɛngɛrɛ ɖádanáa ta bɩna bɩdaká Israyɛ́ɛlɩ laadɔ́ɔ-daá cé.» ");
INSERT INTO kdh_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Amá, Faríizi ńba bɛlɛ́ sɩsɩ zííniwá-dɛ́ɛ wúro gɛ wɔ́nɖɔɔnáa zííniwá. ");
INSERT INTO kdh_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yeésu wɛ wéngilím tɛ́ɛ́dɩwá na tɛɛbíízi-daá wánwɩlɩ́ɩ ɩráa Ɩsɔ́ɔ-dɛ́ɛ tɔ́m Ɩsɔ́ɔ ɖaazɛɛɖɛ́, wénveerím wɛ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-dɛ́ɛ Laabáárʊ Kífeńgi, wánwaazɩ́ kʊdɔḿ báa wenkí na mádafɩ́yatɩ báa wentí. ");
INSERT INTO kdh_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Waana ɩráa zamɔ́ɔ nɛ́, ngɛ bɩɩlá yɩ kʊnyɔḿ, káma, bɩ́ńnɩ́ɩ́ ɩráa bɩka balaakáarɩ kʊráa nyazɩ fééni tɩvɛ́yɩ́na ketirú nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ńna gɛ wɔɔdɔ́ ɩwanbaaráa sɩsɩ: «Kíɖíídi sɩ bakʊ́ nɛ́ wɔɔɖɔ́ɔ, amá, kʊmɖáa tɔɖɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ɩzʊ́lʊ fɔɔ́-dʊ́ʊ ɩtásɩ ikédiri kʊmɖáa bʊɖɔ́ɔ bɔkɔ́nɩ bakʊ́.» ");
INSERT INTO kdh_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ngɛ Yeésu waayáa ɩwanbaaráa fuú na nɔɔ́lɛ ɩfa wɛ yíko sɩsɩ bɔ́ɖɔɔ zííniwá bɩka bawáázɩ ɩráa-dɛ́ɛ kʊdɔmɩ́nɩ na gaala‑gáálátɩ. ");
INSERT INTO kdh_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Tɩndɩnáa fuú na nɔɔ́lɛ bɛḿ bayɩrá nɖɔ́: kaɖaa ńnɩ́ gɛ Simɔ́ɔnɩ weení bánÿaá yɩ sɩsɩ Pétro nɛ́, na igoobú Andirée, Yaakúbu na igoobú Yʊháánɩ Zebedée biyaalɩnáa, ");
INSERT INTO kdh_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filíipu na Barɩtelemíi, Tomáa na Maatéwu tikée mʊʊrʊ́, Yaakúbu Alɩfée biyaalʊ́ na Tadée; ");
INSERT INTO kdh_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simɔ́ɔnɩ kezée-bú na Yudásɩ Isikariyóo weení waayá yɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ɩráa fuú na nɔɔ́lɛ bana gɛ Yeésu weedíri, ifééri wɛ sɩsɩ: «Íkobó wenbá bɛdɛkɛ́ɛ Yahúúɖuwá nɛ́ bɔjɔ́, ngʊ́ ɩ́kasʊ́ʊ Samarɩ́ya tɛ́ɛ́dɩ báa natɩ́rɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Amá, ibó Israyɛ́ɛlɩ bíya-jɔ́; bɔjɔɔ́ɔ gɛ nyazɩ fééni tɩɩdɛlɛ́ŋ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nɩ́bááwʊ-daá, ivééri ɩráa sɩsɩ: “Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ waajʊʊná mɩ́ɩ.” ");
INSERT INTO kdh_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ɩwáázɩ kʊdɔndɩnáa, ivéézi ɩsɩɖáa, ɩwáázɩ cɛnɩ́sɩ, ɩɖɔ́ɔ zííniwá. Faala gɛ baava mɩ́ɩ, mɩ́nyɔ́ɔ́ ɖʊɖɔ ɩva faala. ");
INSERT INTO kdh_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","A sɩ ɩɖɛ́ɛ, ɩ́kaɖʊ siká, yáá liideé, yáá jɩtɔ́ɔ mízíba-daá. ");
INSERT INTO kdh_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ngʊ́ ɩ́kɔkpɔ́ɔ furuú nɩ́bááwʊ kɩ́ɖɛ́ɛnákʊ, ɩ́kɔkpɔ́ɔ tókowá natɩ́lɛ. Ɩ́kɔkpɔ́ɔ takaḿwá yáá ɖɛ́nɩ, káma, bɩ́nbɔɔzɩ́ sɩsɩ weení wánlám tɩmɛ́rɛ nɛ́ iɖi kíɖíím. ");
INSERT INTO kdh_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","A mííbó tɛ́ɛ́dɩ yáá tɛɛbiiyá nɛkɛ́rɛ-daá, ɩjáa ɩbɛ́ɛ sɩsɩ naárʊ wɛ wéndisí ɩmʊ mɩ́ɩ bɩka ɩcɔ́ɔ ɩdɛ́ɛ hálɩ wɩ́rɛ wenɖé sɩ ɩɖɛ́ɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","A mɩ́nzʊʊ́ ɖaána wenká-daá nɛ́, ɩdɔ́ sɩsɩ: “Ɩsɔ́ɔ-dɛ́ɛ fɛɛzɩrɛ ɩ́cɔ́ɔ́ná mɩ́ɩ.” ");
INSERT INTO kdh_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","A bɩgɛ́ɛ baamʊ mɩ́ɩ, Ɩsɔ́ɔ-dɛ́ɛ fɛɛzɩrɛ wɔ́njɔɔnáa wɛ. Amá, a badamʊ mɩ́ɩ, mɩ́dɛ́ɛ kooríti wángabɩsɩ́ mɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","A bɩgɛ́ɛ mɩ́ɩ́zʊ́ʊ ɖaána nɛkɛ́rɛ yáá tɛ́ɛ́dɩ natɩ́rɩ-daá, ngɛ badamʊ mɩ́ɩ ngʊ́ bedewélesi mɩ́ɩ, ɩlɩ́ɩ ńna bɩka ikpíízi mɩ́nʊvɔ́-dɛ́ɛ buuruú ɩtalɩná wɛ. ");
INSERT INTO kdh_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ménveerím mɩ́ɩ toovonúm sɩsɩ wɩ́rɛ wenɖé Ɩsɔ́ɔ sɩ ɩfʊʊná ɩráa nɛ́, Sodɔ́ɔmɩ na Gomɔ́ɔrɩ tɛ́ɛ́dɩwá-dɛ́ɛ nɩgbamʊʊ́ fɔ́m wánlám sóńcí na tɛ́ɛ́dɩ tɩḿ.» ");
INSERT INTO kdh_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Iwélesi ɩnɩ́ɩ ma. Méndiríi mɩ́ɩ ɖɔ́ nɛ́, bɩjɔɔ́ɔ gɛ nyazɩ bónbonáa fééni káwʊ‑káwʊwá lɔwʊtáá nɛ́. Bɩlɛ́ nɛ́ ɩlá laakáarɩ, ɩlá ɖabaram nyazɩ ɖomáa, bɩka ńŋɩnáa avówa kʊ́fʊlʊmá cɔɔ́ɔ bɩ nɛ́, míwenbé-daá ɖʊɖɔ ɩ́fʊlʊ bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ɩlá laakáarɩ, káma, ɩráa wánÿaá mɩ́ɩ wɔnásɩ tɔmvʊʊráa-dɛ́ɛ bakʊ mɩ́dɔ́m, bamá mɩ́ɩ agbáázá bɛdɛ́ɛ Ɩsɔ́ɔ ɖaazɛɛɖɛ́wá; ");
INSERT INTO kdh_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","mɔ́ɔ́ mɔ́rɔ́ɔ́zɩ́ bónbonáa mɩ́ɩ tɛ́ɛ́dɩ nɩ́baadɛɛráa na wúrowá-jɔ́, ńna nɛ́ mɩ́nlɩzɩ́ɩ seríya bána wenbá bɛdɛkɛ́ɛ Yahúúɖuwá nɛ́ bɔjɔ́. ");
INSERT INTO kdh_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","A bɩgɛ́ɛ booboná mɩ́ɩ tɔmvʊʊráa-jɔ́, ɩ́kayɩ́tɩ mɩ́dɩ sɩsɩ nŋɩ́nɩ́táá gɛ sɩ ɩŋmatɩ ná, yáá wentí gɛ sɩ ɩŋmátɩ, káma, sáátɩ kɩḿ nɔ́ɔ́, Ɩsɔ́ɔ tɩtɩŋa wénveerím mɩ́ɩ wentí sɩ ɩŋmátɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Káma, bɩdɛkɛ́ɛ mɩ́nyɔ́ɔ́ sɩ ɩŋmatɩná, Mɩ́jaa-dɛ́ɛ Kezeŋa sɩ ɩŋmatɩná na mɩ́nɔ́ɔ́. ");
INSERT INTO kdh_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Koobúu wɔ́ngɔnɩ́ iyéle bakpa koobúu sɩsɩ bákʊ́ yɩ, caáwʊ iyéle bakpa ibú sɩsɩ bákʊ́ yɩ; bíya ɩkʊrʊ́ na bajaanáa bakʊ bɔdɔ́m sɩsɩ bákʊ́ wɛ. ");
INSERT INTO kdh_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mɔ́ɔ́ mɔ́rɔ́ɔ́zɩ́, ɩráa rɩ́ŋa wánlɩzɩ́ɩ mɩ́ɩ báɖáárɛ. Amá, weení wɔɔɖɔ́kɩ ɩdɩ hálɩ bɩkádʊ́lʊ́ nɛ́, Ɩsɔ́ɔ wɛ́nlɛɛ́ yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","A bɩgɛ́ɛ sɩsɩ bánváa mɩ́ɩ fúkúḿsi tɛ́ɛ́dɩ natɩ́rɩ-daá, ize ɩkɛ́ɛ tɛ́ɛ́dɩ. Ménveerím mɩ́ɩ toovonúm sɩsɩ mídéngilí Israyɛ́ɛlɩ tɛ́ɛ́dɩwá rɩ́ŋa-daá ɩtɛ́ na Ɩrʊ́ Biyaalʊ́ ɩkɔ́nɩ. ");
INSERT INTO kdh_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Wanbaarʊ́ tángɩlɩ́ weení wɛ́ngbɛlɛŋ́ yɩ nɛ́, cáńfáná bɔwʊtá-dʊ́ʊ ɩkɩ́lɩ ɩdɛ́ɛ kʊ́bɔnɩ́. ");
INSERT INTO kdh_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Wanbaarʊ́ mɔɔ́na ɩjɔɔ́ɔ gɛ nyazɩ weení wɛ́ngbɛlɛŋ́ yɩ nɛ́, bɩka bɔwʊtá-dʊ́ʊ nyazɩ ɩgʊ́bɔnɩ́. A baadʊ́ʊ ɖaána-dʊ́ʊ sɩsɩ Bɛlɩzebúuli, mɩ́nyɔ́ɔ́ ɖaána-daá ńba, bádándʊʊ mɩ́ɩ bɩcɛzɩ́ bɩlɛ́?» ");
INSERT INTO kdh_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Bɩlɛ́ nɛ́, ɩ́kanɩ́ɩ banɩdáárɛ, nabʊ́rʊ fɛ́yɩ́ bɩmʊ́sɛ́ɛ bɩ́dánlɩɩ bana bɩ nɛ́, cáńfáná ásíírí bádándɩlɩ́ kɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Wentí ménveerím mɩ́ɩ nuvoowú nɛ́, ɩŋmátɩ tɩ ɩdaawʊ́. Wentí bánzaazɩ́ mɩ́ɩ nɛ́, ɩbɔ́ɔ tɩ ɖamɩ́nɩ kʊjʊ́nɩ-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ɩ́kanɩ́ɩ wenbá bángʊ́ʊ tɔnʊʊ́ bɩka bádánbɩɩzɩ bakʊ kezeŋa nɛ́ banɩdáárɛ, amá, ɩnɩ́ɩ weení wánbɩɩzɩ́ ɩkʊ kezeŋa na tɔnʊʊ́ azáába nimíni-daá nɛ́ ɩnɩdáárɛ. ");
INSERT INTO kdh_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Mányɩ sɩsɩ fárám gɛ bánÿám cɩcɩ́sɩ nasɩ́lɛ ya. Amá, na bɩrɩ́ŋa bɩlɛ́, sɩdaá nɛkɛ́rɛ fɛ́yɩ́ kánzalɩ́ɩ adɛ bɩka Mɩ́jaa Ɩsɔ́ɔ waasɩ bʊrɔ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nyááná mɩ́nyɔ́ɔ́ nɛ́, bɩrɩ́ŋa na mɩ́nyɔ́ɔ́zɩ, Ɩsɔ́ɔ nyɩ sɩgʊjʊʊ́. ");
INSERT INTO kdh_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Bɩlɛ́ nɛ́, ɩ́kanɩ́ɩ nɩdáárɛ, mɩ́wɛná Ɩsɔ́ɔ fɔ́ɔ́zɩrɛ bɩcɛzɩ́ cɩcɩ́sɩ birika.» ");
INSERT INTO kdh_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«A naárʊ waaŋmátɩ zamɔ́ɔ ɩzá-daá sɩsɩ ɩmʊ́ ɩgɛ́ɛ mɛ́dɛ́ɛ ńnɩ́, mɔ́ɔ́ ɖʊɖɔ Majaa weení ɩwɛ ɩsɔ́ɔ́dáá nɛ́ waazá-daá, mánŋmatɩ́ sɩsɩ bʊdʊ́ʊ kɛ́ɛ mɛ́dɛ́ɛ ńnɩ́. ");
INSERT INTO kdh_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Amá, a naárʊ wɔɔdɔ́ zamɔ́ɔ ɩzá-daá sɩsɩ waasɩ ma, mɔ́ɔ́ ɖʊɖɔ mɔ́ndɔ́m Majaa weení ɩwɛ ɩsɔ́ɔ́dáá nɛ́ waazá-daá sɩsɩ máásɩ yɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Ɩ́kamáázɩ sɩsɩ fɛɛzɩrɛ gɛ mɔ́ɔ́gɔ́ná adɛ laadɔ́ɔ-rɔ; mɔ́dɔkɔ́ná fɛɛzɩrɛ, amá, yowú gɛ mɔ́ɔ́gɔ́ná. ");
INSERT INTO kdh_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mɔ́ɔ́gɔ́nɩ gɛ sɩsɩ madára ɩrʊ́ na ɩjaa, aléeré na ɩgɔɔ, awónboolú na ɩwɔ́nɩ́. ");
INSERT INTO kdh_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ɩráa wánlɩzɩ́ɩ bogoobíya báɖáárɛ. ");
INSERT INTO kdh_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Weení wɔɔzɔ́ɔ́lɩ ɩgɔɔ yáá ɩjaa bɩkɩ́lɩ ma nɛ́, tɛkɛ́ɛ mɛ́dɛ́ɛ ńnɩ́, weení wɔɔzɔ́ɔ́lɩ ɩwɛɛlɛ́ɛ yáá ibiyaalʊ́ bɩkɩ́lɩ ma nɛ́, tɛkɛ́ɛ mɛ́dɛ́ɛ ńnɩ́. ");
INSERT INTO kdh_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Weení ɩdɔkpɔ́ɔ ɩdɛ́ɛ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ ikóvú ma nɛ́, tɛkɛ́ɛ mɛ́dɛ́ɛ ńnɩ́. ");
INSERT INTO kdh_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Weení wɔɔzɔ́ɔ́lɩ iweezuú nɛ́, wɛ́nbɛɖɩ́ kɩ; amá, weení wɛ́nbɛɖɩ́ iweezuú mɔ́rɔ́ɔ́zɩ́ nɛ́, wóngoyuú kɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Weení waamʊ mɩ́ɩ ɩgɔ́ńdɩ nɛ́, mɔ́ɔ́ gɛ waamʊ bɩlɛ́; ngʊ́ weení waamʊ ma nɛ́, waamʊ weení weegédíri ma nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Weení waamʊ anɖébi ɩgɔ́ńdɩ ńŋɩnáa bɩɩbɔ́ɔ́zɩ sɩsɩ bámʊ́ anɖébi nɛ́, kɩvɛrɛwʊ bɩɩbɔ́ɔ́zɩ sɩ bɛfɛ́rɛ anɖébi nɛ́-dɛ́ɛ nɔ́ɔ́ gɛ bɛ́nvɛrɩ́ɩ yɩ. Weení waamʊ ɩrʊ́ toovonúm-dʊ́ʊ ɩgɔ́ńdɩ káma, wénzewɔ́ɔ Ɩsɔ́ɔ nɛ́, kɩvɛrɛwʊ bɩɩbɔ́ɔ́zɩ sɩsɩ bɛfɛ́rɛ toovonúm-dʊ́ʊ nɛ́-dɛ́ɛ nɔ́ɔ́ gɛ sɩ bɛfɛ́rɛ yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ménveerím mɩ́ɩ toovonúm sɩsɩ weení ɩrɩ́ŋa báa lɩmgaanɩŋá kagbɔ́ɔ gɛ waava mɛ́dɛ́ɛ wanbaaráa-daá báa kúmuú sɩsɩ ɩgɛ́ɛ mɛ́dɛ́ɛ wanbaarʊ́-rɔ nɛ́, wóngoyuú ɩdɛ́ɛ kɩvɛrɛwʊ.» ");
INSERT INTO kdh_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Sáátɩ wenkí Yeésu wɛɛdɛ́ ɩwanbaaráa tɔ́mwá tɩna wɩlɩ́ɩ nɛ́, ngɛ wɛɛɖɛ́ɛ tɛ́ɛ́dɩwá-daá Ɩsɔ́ɔ-dɛ́ɛ tɔ́m wɩlɩ́ɩ, na waázu lám. ");
INSERT INTO kdh_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yaayá wɛ ɩdɛ́ɛ sáráka-daá nɛ́, waanɩ́ɩ bánŋmatɩ́ tɩmɛ́ Krísto wánlám yɛ nɛ́ adɔ́m. Ngɛ weedíri ɩwanbaaráa bɔbɔ́ɔ́zɩ yɩ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","«Nyánáábɩ́lɛ́ weení sɩsɩ wɔ́ngɔnɩ́ nɛ́ yáá ɖándasɩ́ ɖɩɖáŋ naárʊ.» ");
INSERT INTO kdh_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Ibó ifééri Yaayá wenbí mɩ́ɩ́nɩ́ɩ na wenbí mɩ́ɩ́ná nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Njɛma wánnáa bɩka gaala‑gáálásɩ wánnʊŋɛ́, cɛnɩ́sɩ waawáa sɩlá ɖacɩrɩ‑cɩrɩ, ndamáa wánnɩɩ́, ɩsɩɖáa wénvém, bɩka bénveerím kadanbʊrʊ́sɩ Laabáárʊ Kífeńgi. ");
INSERT INTO kdh_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Wenbi‑niíni-dʊ́ʊ gɛ weení ɩdɛbɛ́ɖɩ toovonúm waava ma nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Sáátɩ wenkí Yaayá-dɛ́ɛ wanbaaráa wɛɛɖɛ́ɛ nɛ́, ngɛ Yeésu wɔɔgbɔ́ɔ wánŋmatɩ́ zamɔ́ɔ Yaayá-rɔ sɩsɩ: «Wé gɛ mííbó ɩkɛ́bɛ́ɛŋ tɛɛwʊ́lɔ́ɔ́-daá. Ɖɩgɛrɛ́ fefelimá wónÿuúdi ɖɛ nɛ́? Aayɩ́. ");
INSERT INTO kdh_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Bɩlɛ́ nɛ́, wé gɛ mííbó ɩkɛ́bɛ́ɛŋ. Ɩrʊ́ izóóna tókowá kífeńdi nɛ́? Wenbá bónzuú tókowá kífeńdi nɛ́ bɔwɛ wúrowá-dɛ́ɛ kowuro-ɖɛ́ɛ́zɩ-daá gɛ. ");
INSERT INTO kdh_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Bɩlɛ́ nɛ́, we gɛ mííbó ɩkɛ́bɛ́ɛŋ. Anɖébi? Ɩɩ́n, bɩlɛ́ gɛ ménveerím mɩ́ɩ, hálɩ waagɩ́lɩ anɖébi. ");
INSERT INTO kdh_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Káma, Yaayá-dɛ́ɛ tɔ́m gɛ Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá waaŋmátɩ sɩsɩ: “Méndiríi mɛ́dɛ́ɛ tɩndʊ́ʊ itóróbó bɩka ɩkpára nya nyánɩ́bááwʊ.” ");
INSERT INTO kdh_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ménveerím mɩ́ɩ toovonúm sɩsɩ ɩráa-daá, anɖébi naárʊ tɔcɔ́ɔ waagɩ́lɩ Yaayá. Ngʊ́ nbɛ́ɛ́ŋ nɛ́, weení ɩgɛ́ɛ kúmuú Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-daá nɛ́ waagɩ́lɩ yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kɔgbɔɔ Yaayá-dɛ́ɛ sáátɩ ngɔ́nɩ lɛlɛɛɖɔ́, Ɩsɔ́ɔ-dɛ́ɛ kowuro-ɖɔɔ́ wánnáa fúkúḿsi, fúkúḿsi-dɩnáa wánjáádɩ sɩ bɛlɛ́ɛ kɛ. ");
INSERT INTO kdh_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Káma, anɖébiwá rɩ́ŋa na Múúsá-dɛ́ɛ Mará tákaraɖá waaŋmátɩ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-dɛ́ɛ tɔ́m hálɩ bɩkɔ́nɩ bɩtála Yaayá. ");
INSERT INTO kdh_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","A mɩ́zɔɔlɛ́ɛ ɩnɩ́ɩ gɛ, Yaayá gɛ Elíya weení baaŋmátɩ sɩsɩ wángabɩsɩ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Weení ɩwɛná nɩgbamɩ́nɩ nɛ́, ɩ́nɩɩ. ");
INSERT INTO kdh_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Weení gɛ mánbɩɩzɩ́ mɛgɛɛzɩná zaamáánɩ kɩna kɩdɛ́ɛ ɩráa. Bɔjɔɔ́ɔ gɛ nyazɩ bíya bɔjɔɔ́ɔ wɔnɔɔ́ kʊ́bɔńga-daá bɔ́ndɔ́m baranáa sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Ɖáávʊ́lʊ mɩ́ɩ foyísi, amá, mɩ́dabáa. Ɖéédée lííya yéńdi, mɩ́dɛ́mɛ́ɛ́dɩ iwíi,” nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Káma, Yaayá wɔɔgɔ́nɩ nɛ́, bɩdɛkɛ́ɛ kíɖíím yáá sʊlʊ́m-dɛ́ɛ tɔ́m ɖɔ́kɩná na yɩ, ngɛ bɔɔdɔ́ sɩsɩ ɩwɛná zííniwá. ");
INSERT INTO kdh_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ɩrʊ́ Biyaalʊ́ wɔɔgɔ́nɩ nɛ́, ɩlɛ́ wénɖíi wɔ́nnyɔɔ́. Ngɛ bɔɔdɔ́ sɩsɩ: “Ɩbɛ́ɛ ceení, ɖiirú na sʊlʊ́m nyɔɔrʊ́ gɛ ɩgɛ́ɛ; tikée mʊʊráa na alaháácɩ́-dɩnáa gɛ ɩɖɔndɩnáa.” Amá, wenbí wánlám nɛ́ bɩdaá gɛ bánnanáa Ɩsɔ́ɔ-dɛ́ɛ áséńsí.» ");
INSERT INTO kdh_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ńna gɛ Yeésu waabáázɩ tɛ́ɛ́dɩwá wentí waalá maamááciwá tɩdaá ɖabata nɛ́ yoonáa, káma, tɩdɛkɛ́ɛ tɩlakásɩ tɩlá túúbá. ");
INSERT INTO kdh_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Yeésu wɔɔdɔ́ tɩ sɩsɩ: «Nbusú ɖamáa na kʊ nya Korazíini tɛ́ɛ́dɩ! Nbusú ɖamáa na kʊ nya Bɛtɩsayɩdáa tɛ́ɛ́dɩ! Káma, maamááciwá tɩɩlá mɩ́dɛ́ɛ nɛ́, a baraalá tɩ Tíiri na Sidɔ́ɔnɩ tɛ́ɛ́dɩwá-daá, tɩlɛ́ tɩraajɔ́ɔ lííya tisúu kpetekíni tókowá tifuná tɩdɩ tɔɔlɩmá bɩwɩ́lɩ sɩsɩ tɩɩlá túúbá tɩkɛ́ɛ lakásɩ. ");
INSERT INTO kdh_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Bʊrɔ gɛ ménveerím mɩ́ɩ toovonúm sɩsɩ tɔ́m fʊ́ʊ́dɩ wɩ́rɛ, Tíiri na Sidɔ́ɔnɩ-dɛ́ɛ nɩgbamʊʊ́ fɔ́m wánlám sóńcí na mɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Bɩɩga nyɔ́ɔ́ Kapɛrɩnawʊ́m tɛ́ɛ́dɩ, nyánmaazɩ́ sɩsɩ nyángbáa Ɩsɔ́ɔ-jɔ́ yáá wé. Béndisí nya hálɩ ɩsɩɖáa-daá. Káma, maamááciwá tɩɩlá nyɛ́dɛ́ɛ nɛ́, a baraalá tɩ Sodɔ́ɔmɩ tɛ́ɛ́dɩ-daá, tɛ́ɛ́dɩ tɩḿ tɩ́fʊnwɛ hálɩ na sinje. ");
INSERT INTO kdh_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Bʊrɔ gɛ ménveerím nya sɩsɩ tɔ́m fʊ́ʊ́dɩ wɩ́rɛ, Sodɔ́ɔmɩ-dɛ́ɛ nɩgbamʊʊ́ fɔ́m wánlám sóńcí na nya.» ");
INSERT INTO kdh_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Bɩdɛ́ɛ sáátɩ gɛ Yeésu wɔɔdɔ́ sɩsɩ: «Majaa, Mádʊ́ʊ Ɩsɔ́ɔ adɛ na ɩsɔ́ɔ́dáá lanɖʊ́, mɛ́nzɛɛ́ nya kɩzɛɛwʊ ńŋɩnáa nyáámʊ́sɩ áséńsí-dɩnáa na tɩlɩ́ɖa wentí nɛ́, nyééyéle bíya kúmuúsi ɩtɩlɩ́ tɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ɩɩ́n Majaa, bɩlɛ́ gɛ nyɔ́ɔ́zɔ́ɔ́lɩ nɛ́, bʊrɔ gɛ bɩɩlá bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Majaa weejéle ma bɩrɩ́ŋa. Naárʊ fɛ́yɩ́ ɩnyɩ Biyaalʊ́ʊ, asée Caáwʊ riké, ngʊ́ bɩlɛ́ gɛ naárʊ fɛ́yɩ́ ɩnyɩ Caáwʊ asée Biyaalʊ́ʊ na wenbá Biyaalʊ́ʊ wɔɔzɔ́ɔ́lɩ sɩsɩ bátɩ́lɩ́ yɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mɩ́nyɔ́ɔ́ wenbá mɩ́rɩ́ŋa bɩ́ńnɩ́ɩ́ mɩ́ɩ bɩka mɩ́zʊ́wáána nɛ́, ɩgɔ́nɩ mɔ́jɔ́, mánváa mɩ́ɩ fɛɛzɩrɛ. ");
INSERT INTO kdh_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ɩgbɔ́ɔ mɛ́dɛ́ɛ ɖɛ́nɩ kɩ́kawʊ́ ɩtɩ́nɩ mɩ́rɔ́ bɩka ɩkɔ́nɩ mɛgbɛ́lɛ́ŋ mɩ́ɩ; káma, mɛ́dɛ́ɛ fúu cɔɔ́ɔ niíni bɩka mɔ́jɔɔ́ɔ ɖɔyɔɔyɔɔ. Ńna nɛ́, mínÿuúu fɛɛzɩrɛ. ");
INSERT INTO kdh_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ɩɩ́n, mɛ́dɛ́ɛ ɖɛ́nɩ kɩ́kawʊ́ fɛ́yɩ́ káálɛ sʊʊ́ʊ bɩka mɛ́dɛ́ɛ sʊʊ́tɩ fɛ́yɩ́ yíni.» ");
INSERT INTO kdh_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Bɩdɛ́ɛ sáátɩ kɩḿ, Fɛɛzɩrɛ wɩ́rɛ neɖére gɛ Yeésu wɛ́ndɛsɩ́ bilée fásɩ. Nyɔɔ́sɩ wánjaarɩ́ ɩwanbaaráa nɛ́, ngɛ baabáázɩ bilée kpɛɛ́ bɔ́ndɔwʊ́ʊ kibíya. ");
INSERT INTO kdh_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Faríizi ńba waana bɩlɛ́ nɛ́, ngɛ bɔɔdɔ́ yɩ sɩsɩ: «Bɛɛ nyɛ́dɛ́ɛ wanbaaráa wánlám wenbí ɖɛ́dɛ́ɛ Mará tafa nɩ́bááwʊ sɩsɩ bála Fɛɛzɩrɛ wɩ́rɛ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yeésu woobúsi wɛ sɩsɩ: «Mɩ́dákála wenbí Ɖáwʊɖa waalá sáátɩ wenkí nyɔɔ́sɩ waagʊ ɩ́na ɩwanbaaráa nɛ́? ");
INSERT INTO kdh_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Waazʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ bɩsaagɛ́rɛ́ŋɛ-dɛ, ngɛ wɔɔgɔ́gbɔ́ɔ kpɔ́nɔ́wá baalá tɩ Ɩsɔ́ɔ sarɔ́ɔ nɛ́ bɔtɔ́ɔ. Ngʊ́ bɩdafa nɩ́bááwʊ sɩsɩ ɩmʊ́ Ɖáwʊɖa yáá ɩwanbaaráa bɔtɔ́ɔ tɩ, asée Ɩsɔ́ɔ sarásɩ lanɖáa riké. ");
INSERT INTO kdh_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Yáá mɩ́dákála Múúsá-dɛ́ɛ Mará-daá sɩsɩ Fɛɛzɩrɛ wɩ́rɛ, Ɩsɔ́ɔ sarásɩ lanɖáa bánlám tɩmɛ́rɛ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá nɛ́ bódónvúu Fɛɛzɩrɛ wɩ́rɛ-dɛ́ɛ mará bɩka bádánÿɩsɩ. ");
INSERT INTO kdh_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ménveerím mɩ́ɩ sɩsɩ wenbí bʊwɛ cé nɛ́, bɩɩgɩ́lɩ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga. ");
INSERT INTO kdh_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","A mɩraanɩ́ɩ Ɩsɔ́ɔ wɔɔdɔ́ sɩsɩ: “Kʊnyɔnnɩɩrɛ́ gɛ mɔ́zɔɔlɛ́ɛ bɩdɛkɛ́ɛ sarásɩ,” nɛ́ bugutoluú, mɩ́takʊ ɩráa bana badayɩ́sɩ nɛ́ bɔdɔ́m. ");
INSERT INTO kdh_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Káma, Ɩrʊ́ Biyaalʊ́ wɛná na kʊ yíko Fɛɛzɩrɛ wɩ́rɛ-rɔ.» ");
INSERT INTO kdh_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Waalɩ́ɩ ńna nɛ́, ngɛ wɛɛɖɛɛ ná bɛdɛ́ɛ Ɩsɔ́ɔ ɖaazɛɛɖɛ́ ɖaána fáráńdɩ́ ibó ɩsʊ́ʊ kadaá. ");
INSERT INTO kdh_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Abaalʊ́ naárʊ wɛ ńna biilí ɩnʊ́ʊ́nɩ. Ɩráa wánjáádɩ sɩ bayɩ́ Yeésu nɔɔ́-jɔ́ na bakʊ ɩdɔ́m nɛ́, ngɛ bɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Bɩɩva nɩ́bááwʊ sɩsɩ báwaazɩ ɩrʊ́ Fɛɛzɩrɛ wɩ́rɛ?» ");
INSERT INTO kdh_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yeésu woobúsi wɛ sɩsɩ: «Mɩ́dáá weení gɛ a fée kʊ́ɖʊḿ gɛ ɩwɛná, ngɛ fée ɩmʊ́ waazála bɔɔwʊ́-daá Fɛɛzɩrɛ wɩ́rɛ, ídéndiḿ ɩkálɩ́zɩ́ yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ngʊ́ ɩrʊ́ wɛná fɔ́ɔ́zɩrɛ bɩcɛzɩ́ fée. Bɩlɛ́ nɛ́ ɖɛ́dɛ́ɛ Mará waava nɩ́bááwʊ sɩsɩ bála kazɔ́ɔ ńbɩ Fɛɛzɩrɛ wɩ́rɛ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ńna gɛ Yeésu wɔɔdɔ́ abaalʊ́ ɩmʊ́ sɩsɩ: «Fɔ nyánʊ́ʊ́nɩ.» Ɩlɛ́ wɔɔvɔ́ ɩnʊ́ʊ́nɩ, ngɛ nʊ́ʊ́nɩ waawáa ɩbɩ́sɩ nyazɩ lí ńnɩ́. ");
INSERT INTO kdh_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Faríizi ńba waalɩ́ɩ ńna nɛ́, ngɛ boobó balá sááwʊ́ra nŋɩ́nɩ́ báta balá na bakʊ Yeésu nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yeésu waanɩ́ɩ bɩlɛ́ nɛ́, ngɛ waalɩ́ɩ ɖɩdáarɛ ɖɩḿ ɖɩdaá. Zamɔ́ɔ kʊ́bɔńgɩ woovu yɩ, ngɛ waawáázɩ badaá wenbá barɩ́ŋa bánnyaadɩ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ńna gɛ waabásɩ wɛ sɩsɩ békeyéle ɩráa ɩtɩlɩ́ weení ɩmʊ́ ɩgɛ́ɛ nɛ́, ");
INSERT INTO kdh_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","na wentí anɖébi Esáya waaŋmátɩ nɛ́ ikóódi; tɩlɛ́ gɛ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Ɩsɔ́ɔ sɩsɩ: “Ɩbɛ́ɛ mɛ́dɛ́ɛ bɔwʊtá-dʊ́ʊ máádá malɩzɩ́ yɩ nɛ́, ɩnáábɩ́lɛ́ máábá mɔzɔ́ɔ́lɩ, wɛ́nvɛɛzɩ kʊ méwenbiré, mánɖʊ́ʊ mɛ́dɛ́ɛ Kezeŋa ɩrɔ na ifééri zamɔ́ɔ wenbí bɩzɩɩzɛ́ɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ɩ́dánjaa yóóni, ídóngoo, ɩ́dángbaazɩ ilowú zamɔ́ɔ ɖaaduuziɖé. ");
INSERT INTO kdh_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ɩ́dɛ́nbɛlɩ́ ɖɩgɛrɛ́ ɖíńgoodi nɛ́ bɩka ɩ́dánɖɩḿ fɩtɩ́la kídénɖée kazɔ́ɔ nɛ́ hálɩ iyéle toovonúm iɖi, ");
INSERT INTO kdh_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Yíri báa wenkí wánɖʊ́ʊ tamɔ́ɔ ɩrɔ.”» ");
INSERT INTO kdh_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ngɛ bɔɔgɔná Yeésu ɩrʊ́ naárʊ zííniwá wáńbɩ́sɩ́ná yɩ njɛm na komóomúŋa nɛ́. Wawáázɩ yɩ hálɩ ɩlɛ́ wánŋmatɩ́ bɩka wánnáa nɛ́, ");
INSERT INTO kdh_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ngɛ bɩɩlá zamɔ́ɔ rɩ́ŋa bítí kɩ́ndɔ́m sɩsɩ: «Bɩdɛkɛ́ɛ ceení gɛ Ɖáwʊɖa Biyaalʊ́?» ");
INSERT INTO kdh_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Amá, Faríizi ńba waanɩ́ɩ bɩlɛ́ nɛ́, ngɛ sɩsɩ: «Bɛlɩzebúuli, zííniwá-dɛ́ɛ wúro gɛ ceení wɔ́nɖɔɔnáa zííniwá.» ");
INSERT INTO kdh_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yeésu nyɩ bɛdɛ́ɛ lomaazɛ́ nɛ́, ngɛ wɔɔdɔ́ wɛ sɩsɩ: «Laadɔ́ɔ báa wenká gɛ kɛdɛ́ɛ ɩráa wónÿoó, asée kɔɔyɔ́. Tɛ́ɛ́dɩ natɩ́rɩ, yáá koobíre neɖére fɛ́yɩ́ ɖɩdaá ɩráa tánnɩɩ ɖamá gɛ ɖɩjɔɔ́ɔ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","A Sitáánɩ wɔ́nɖɔwʊ́ʊ Sitáánɩ, wónÿoó ɩdɩ nbɩlɛ́, bɩ́nlám nŋɩ́nɩ́ na ɩdɛ́ɛ tɛ́ɛ́dɩ ɩcɔ́ɔ tɩ́dɔ́nÿɔḿ. ");
INSERT INTO kdh_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ngɛ a na Bɛlɩzebúuli gɛ mɔ́ɔ́ mɔ́nɖɔɔnáa zííniwá, mɩ́dɛ́ɛ wanbaaráa ní. Na weení gɛ bɔ́nɖɔɔnáa tɩ. Mɩ́wanbaaráa tɩtɩŋa wángʊ́ʊ kʊ mɩ́dɔ́m. ");
INSERT INTO kdh_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Amá, a na Ɩsɔ́ɔ-dɛ́ɛ Kezeŋa gɛ mɔ́nɖɔɔnáa zííniwá, bɩ́nwɩlɩ́ɩ sɩsɩ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ wáńdálɩ́ mɩ́lɔ́wʊ́táá nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Yáá nŋɩ́nɩ́ gɛ naárʊ wánbɩɩzɩ́ ɩsʊ́ʊ ɩrʊ́ ɩjɔɔ́ɔ ɖóni nɛ́ ɩdɛ́ɛ ɩkpɔ́ɔ ɩgbɩná, a ɩdafʊ́ńbɩɩzɩ ɩfɔ́kɩ yɩ. Asée wɔɔvɔ́kɩ yɩ na ɩbɩ́ɩ́zɩ ɩkpɔ́ɔ ɩgbɩná. ");
INSERT INTO kdh_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Weení ɩraavóo ma nɛ́, ɩyɛ́ɛ́na ma, bɩka weení ɩ́dánzɩná ma tuuzí nɛ́, wánÿaazɩ́ gɛ. ");
INSERT INTO kdh_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Bʊrɔɔzɩ́ gɛ ménveerím mɩ́ɩ sɩsɩ Ɩsɔ́ɔ wɛ́njɛ́m ɩráa alaháácɩ́ báa wenkí na kʊdʊ́ʊ́wʊ báa wenkí gɛ baadʊ́ʊ yɩ, amá, weení waadʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ Kezeŋa nɛ́, Ɩsɔ́ɔ tɛ́njɛḿ yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Weení waaŋmátɩ ɩyɩsɩná Ɩrʊ́ Biyaalʊ́ nɛ́, Ɩsɔ́ɔ wɛ́njɛ́m yɩ, amá, weení waaŋmátɩ ɩyɩsɩná Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga nɛ́, bɛ́dɛ́njɛḿ yɩ ɖúúlínya kɩna kɩdaá, cáńfáná ceré.» ");
INSERT INTO kdh_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Naanɩ́ na ɩrʊ́ iyuú tɩɩwʊ́ bú kazɔ́ɔ ńnɩ́ nɛ́, asée wooyuú tɩɩwʊ́ kazɔ́ɔ ńgɩ. A tɩɩwʊ́ wánnyaadɩ́, kibíya ɖʊɖɔ kʊdɔndɩnáa gɛ. Tɩɩwʊ́-dɛ́ɛ bíya gɛ bándɩlɩ́ɩ na kɩ. ");
INSERT INTO kdh_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mɩ́ɩ bɔɔzá ana! Mɩ́nlám nŋɩ́nɩ́ ɩbɩ́ɩ́zɩ ɩŋmátɩ tɔ́m kazɔ́ɔ ńdɩ bɩka mɩ́dáávé. Káma, wenbí biizu wenbiré-daá nɛ́ gɛ nɔɔ́ wánŋmatɩ́. ");
INSERT INTO kdh_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ɩrʊ́ kazɔ́ɔ ńnɩ́ wánlɩzɩ́ɩ wenbí bɩjɔɔ́ɔ kazɔ́ɔ nɛ́ gɛ wenbí ɩwɛná kazɔ́ɔ ńbɩ nɛ́ bɩdaá; ɩrʊ́ kidaavéénúu ɩlɩzɩ́ wenbí bɩdaavé nɛ́ wenbí ɩwɛná bɩdaavé nɛ́ bɩdaá. ");
INSERT INTO kdh_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ménveerím mɩ́ɩ sɩsɩ tɔ́m fʊ́ʊ́dɩ wɩ́rɛ, ɩráa wándɩnáa bɔnɔ́ɔ́zɩ tɔ́m bú tɩtɛ ńnɩ́ weení baaŋmátɩ yɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Káma, wentí tɩrɩ́ŋa nyááŋmátɩ nɛ́, tɩnáábɩ́lɛ́ sɩ bafʊʊná na nya na beɖéézi nya yáá bakʊ nyɔ́dɔ́m.» ");
INSERT INTO kdh_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ńna gɛ Mará wɩlɩɖáa nɛbɛ́rɛ na Faríizi ńba wɔɔdɔ́ Yeésu sɩsɩ: «Kʊ́bɔnɩ́, ɖɔ́zɔɔlɛ́ɛ nlá ɖáa maamááci nakɩ́rɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yeésu woobúsi wɛ sɩsɩ: «Zaamáánɩ kɩna kɩdɛ́ɛ ɩráa badaavé bɩka bádánzɩŋná Ɩsɔ́ɔ riké nɛ́, bɔ́nbɔɔzɩ́ sɩsɩ bála maamááci, amá, anɖébi Ínúusa-dɛ́ɛ ńgɩ baasí, bádándanáa maamááci nakɩ́rɩ ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Káma, ńŋɩnáa Ínúusa waalá wɛ́ náádoozo nuvoowú na ɩdaawʊ́ tińɖe kʊ́bɔńɖɛ lóódi-daá nɛ́, bɩlɛ́ ɖʊɖɔ gɛ Ɩrʊ́ Biyaalʊ́ sɩ ɩlá wɛ́ náádoozo nuvoowú na ɩdaawʊ́ adɛ laadɔ́ɔ-daá. ");
INSERT INTO kdh_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Tɔ́m fʊ́ʊ́dɩ wɩ́rɛ, Niníivi tɛ́ɛ́dɩ-daá ɩráa wángʊrʊ́ʊna zaamáánɩ kɩna kɩdɛ́ɛ ɩráa bakʊ bɔdɔ́m, káma, Niníivi ńba waalá túúbá bɛkɛ́ɛ balakásɩ sáátɩ wenkí baanɩ́ɩ Ínúusa-dɛ́ɛ waázu nɛ́. Ngʊ́ sinje-daá, naárʊ wɛ cé waagɩ́lɩ Ínúusa. ");
INSERT INTO kdh_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tɔ́m fʊ́ʊ́dɩ wɩ́rɛ, Sebáa laadɔ́ɔ-dɛ́ɛ wúro alʊ́ wángʊrʊ́ʊna zaamáánɩ kɩna kɩdɛ́ɛ ɩráa, ɩkʊ bɔdɔ́m káma, waagálɩ́ɩ́ná ɖoo bolíni ɩkɔ́nɩ iwélesi wúro Sulemáana-dɛ́ɛ áséńsí. Ngʊ́ sinje-daá, naárʊ wɛ cé waagɩ́lɩ Sulemáana.» ");
INSERT INTO kdh_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«A Zííni waalɩ́ɩ ɩrʊ́-rɔ, kínboɖé gɛ kɩ́ngabɩsɩ́ ɖɩdáarɛ wɩlɩ́ŋa ńɖɛ-daá kɩ́njáádɩ ɖaavɛɛzɩɖɛ́, amá, kídónÿuú nɛ́ ");
INSERT INTO kdh_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","na kɩtɔ́ sɩsɩ: “Mánbɩsɩ́ mɛ́dɛ́ɛ ɖaána wenká máagálɩɩ kadaá nɛ́.” A kɩɩdála gɛ kɩɩmɔɔná kɛ naárʊ fɛ́yɩ́ kadaá, báńgbárɩ́ kɛ bɔnyɔ́ɔ́zɩ, ");
INSERT INTO kdh_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ńna nɛ́, kínboɖé kɩkájaa zííniwá lʊbɛ tɩgɩdaavééníti waagɩ́lɩ kɩḿ nɛ́, na tɩkɔ́nɩ tisúu ńna. Bɩgɛdɛɛzɩya, ɩrʊ́ ɩmʊ́ ɩdɛ́ɛ cɔwʊrɛ wɔ́nvɔrɔ́sɩ bɩkɩ́lɩ kaɖaa-dɛ́ɛ. Bɩlɛ́ gɛ zaamáánɩ kɩna kɩdɛ́ɛ ɩráa kɩdaavéénínáa sɩ bɛtɛná.» ");
INSERT INTO kdh_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yeésu bamáa zamɔ́ɔ ŋmatɩnáa gɛ ɩgɔɔ na igoobíya baadála bazɩ́ŋɛ́ɛ asʊ bánjáádɩ sɩ baŋmatɩná yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ńna gɛ naárʊ wɔɔdɔ́ Yeésu sɩsɩ: «Bɛɛ ngɔɔ na ngoobíya bazɩ́ŋɛ́ɛ asʊ bɔzɔɔlɛ́ɛ sɩ baŋmatɩná nya.» ");
INSERT INTO kdh_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ńna gɛ Yeésu woobúsi weení waaŋmatɩná yɩ nɛ́ sɩsɩ: «Weení gɛ mɔgɔɔ. Wenbá gɛ mogoobíya.» ");
INSERT INTO kdh_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ngɛ waawɩ́lɩ ɩwanbaaráa na ɩnʊ́ʊ́nɩ ɩtɔ́ sɩsɩ: «Bɛɛ mɔgɔɔ na mogoobíya. ");
INSERT INTO kdh_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Weení ɩrɩ́ŋa wánlám Majaa ɩwɛ ɩsɔ́ɔ́dáá nɛ́ ɩzɔɔlɩ́m nɛ́, ɩlɛ́ gɛ mogoobú alʊ́, yáá abaalʊ́, yáá mɔgɔɔ.» ");
INSERT INTO kdh_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Bɩdɛ́ɛ wɩ́rɛ ɖɩḿ, Yeésu waalɩ́ɩ ɖaána-daá ibó ɩcɔ́ɔ lɩɩrɛ́ kʊ́bɔńɖɛ nɔɔ́-jɔ́ sɩ ɩwɩ́lɩ ɩráa Ɩsɔ́ɔ-dɛ́ɛ tɔ́m. ");
INSERT INTO kdh_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ngɛ zamɔ́ɔ kʊ́bɔńgɩ waalára kɩmɩlɩná yɩ hálɩ biiyéle ɩkpa kpɩ́ɩ́rʊʊ́-daá ɩcɔ́ɔ bɩka zamɔ́ɔ sɩ́ŋɛ́ɛ lɩ́m nɔɔ́‑nɔɔ́. ");
INSERT INTO kdh_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Waawɩ́lɩ zamɔ́ɔ kɩḿ tɔ́mwá ɖabata na tɔmgɛɛzɩrɛ. Ngɛ wɔɔdɔ́ wɛ sɩsɩ: «Wɩ́rɛ gɛ ɩrʊ́ naárʊ woobó ɩvɔɔ́-daá kúɖúúdi larɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Wánlarɩ́ɩ nɛ́, ngɛ natɩ́rɩ waazála nɩ́bááwʊ‑nɩ́bááwʊ, ngɛ siḿsi wɔɔgɔ́nɩ siɖi tɩ. ");
INSERT INTO kdh_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Natɩ́rɩ waazála bɔ́-daá lénlé tɛ́ɛ́dɩ tɔɖɔ́ɔ nɛ́, ngɛ tɩɩjáŋ tɩnyɔ káma, tɛ́ɛ́dɩ telím. ");
INSERT INTO kdh_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Wɩ́sɩ wɔɔgɔ́nɩ sɩsáa nɛ́, ngɛ bɩɩnyɔ́ɔ tɩ, ngɛ tɩɩwɩ́lɩ, káma, wóózi tafɩ́ya. ");
INSERT INTO kdh_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kúɖúúdi natɩ́rɩ waazála sɔɔzɔ́ɔ́zɩ-daá, ngɛ sɔɔzɔ́ɔ́zɩ waabɩ́ɩ sɩnyʊʊ́ tɩ. ");
INSERT INTO kdh_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Natɩ́rɩ waazála tɛ́ɛ́dɩ kazɔ́ɔ ńdɩ-daá. Ngɛ tɩlɛ́ tɩɩɖʊ bíya; tikú nakɩ́rɩ nɩɩ́nʊ́wá, nakɩ́rɩ niídoozo nakɩ́rɩ ɖʊɖɔ ákoosaaláa.» ");
INSERT INTO kdh_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ngɛ Yeésu waadásɩ sɩsɩ: «Weení ɩwɛná nɩgbamɩ́nɩ nɛ́, ɩ́nɩɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ńna gɛ Yeésu-dɛ́ɛ wanbaaráa woogóduu ɩjɔ́ bɔbɔ́ɔ́zɩ yɩ sɩsɩ: «We-rɔ gɛ nyánŋmatɩnáa ɩráa na tɔmgɛɛzɩrɛ bɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Mɩ́nyɔ́ɔ́ nɛ́, Ɩsɔ́ɔ waava mɩ́ɩ sɩsɩ ɩ́tɩ́lɩ́ ɩdɛ́ɛ kowúrɔ́ɔ-dɛ́ɛ ásíírí, amá, bɛlɛ́ nɛ́, ɩdafa wɛ sɩsɩ bátɩ́lɩ́ kɩ. ");
INSERT INTO kdh_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Káma, weení ɩwɛná nɛ́, bándasɩ́ yɩ na iyuú bɩbá bɩɖɔ́ɔ; amá, weení ɩvɛ́yɩ́na nɛ́, bɛ́nlɛɛ́ cʊ́kɔyɔ́ɔ wenká ɩwɛná nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Wenbí bʊrɔ mánŋmatɩnáa wɛ na tɔmgɛɛzɩrɛ nɛ́ gɛ sɩsɩ bɛbɛɛ́na, amá, bádánnáa; bénwelesí, amá, bádánnɩɩ, cáńfáná banɩ́ɩ bugutoluú. ");
INSERT INTO kdh_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Bɩɩlá bɩlɛ́ gɛ na wentí anɖébi Esáya waaŋmátɩ nɛ́ ikóódi; waaŋmátɩ gɛ sɩsɩ: “Mɩ́nbá iwélesi amá, mɩ́dánnɩɩ, mɩ́nbá ɩbɛ́ɛ́ŋ amá, mɩ́dánnáa, ");
INSERT INTO kdh_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","káma, zamɔ́ɔ kɩna kiwenbiré waagbɩ́ɩ́zɩ, baabɩ́sɩ nɩgbaaɖóni-dɩnáa boovu baazá na bákana na baazá yáá banɩɩná banɩgbamɩ́nɩ na bitekiná bewenbé balá túúbá na mɛlɛ́ɛ wɛ.” ");
INSERT INTO kdh_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Bɩɩga mɩ́nyɔ́ɔ́ nɛ́, mɩ́náábɩ́lɛ́ wenbi‑niíni-dɩnáa, káma, mɩ́ɩ́zá wánnáa bɩka mɩ́nɩgbamɩ́nɩ wánnɩɩ́. ");
INSERT INTO kdh_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ménveerím mɩ́ɩ toovonúm sɩsɩ anɖébiwá ɖabata na ɩráa ɖabata boovu Ɩsɔ́ɔ na toovonúm nɛ́ bɔɔzɔ́ɔ́lɩ sɩsɩ bana wenbí mɩ́bɛɛ́na ɖɔ́ nɛ́, amá, badana; banɩ́ɩ wentí mɩ́nnɩɩ́ ɖɔ́ nɛ́, amá, badanɩ́ɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Bɩlɛ́ nɛ́, iwélesi ɩnɩ́ɩ kúɖúúdi laraɖʊ́ ɩmʊ́ ɩdɛ́ɛ tɔmgɛɛzɩrɛ kutoluú. ");
INSERT INTO kdh_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Wenbá bánnɩɩ́ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-dɛ́ɛ tɔ́m bɩka bádánnɩɩ tugutoluú nɛ́ cɔɔ́ɔ gɛ nyazɩ nɩ́bááwʊ‑nɩ́bááwʊ lé kúɖúúdi waazála nɛ́. Sitáánɩ wɔ́ngɔnɩ́ gɛ ɩkpɛzɩ́ wenbí booɖúu bewenbé-daá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Weení wánnɩɩ́ Ɩsɔ́ɔ-dɛ́ɛ tɔ́m na ɩcáŋ ɩmʊ tɩ na wenbi‑niíni nɛ́, cɔɔ́ɔ gɛ nyazɩ bɔ́-daá lénlé kúɖúúdi waazála nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Amá, wóózi fɛ́yɩ́ nɛ́, tídénleeri. A bɩgɛ́ɛ nɔwɛ́ya yáá fúkúḿsi waadála yɩ Ɩsɔ́ɔ-dɛ́ɛ tɔ́m-rɔ, wánbɩsɩ́ ɩwɔ́rɔ́. ");
INSERT INTO kdh_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Weení wénwelesí Ɩsɔ́ɔ-dɛ́ɛ tɔ́m na iyéle ɖúúlínya lomaazɛ́ na ɖɔ́ɔ́lɛ-dɛ́ɛ ayiila ɩnyʊʊ́ tɩ bɩka ɩ́dánɖʊ́ʊ bíya nɛ́, cɔɔ́ɔ gɛ nyazɩ sɔɔzɔ́ɔ́zɩ-daá lénlé kúɖúúdi waazála nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Wenbá bánnɩɩ́ Ɩsɔ́ɔ-dɛ́ɛ tɔ́m bɩka bánnɩɩ́ tugutoluú nɛ́ cɔɔ́ɔ gɛ nyazɩ tɛ́ɛ́dɩ kazɔ́ɔ ńdɩ wentí-daá kúɖúúdi waazála nɛ́. Bʊrɔ gɛ wánɖʊ́ʊ bíya: naárʊ nɩɩ́nʊ́wá, naárʊ niídoozo, naárʊ ákoosaaláa.» ");
INSERT INTO kdh_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ngɛ Yeésu wɛɛdɛ́kɛɛzɩ wɛ tɔ́m natɩ́rɩ sɩsɩ: «Ɩbɛ́ɛ wenbí bɛ́ngɛɛzɩnáa Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ nɛ́: Ɩrʊ́ naárʊ wooɖuu ná kúɖúúdi kazɔ́ɔ ńdɩ ɩvɔɔ́-daá. ");
INSERT INTO kdh_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Wɩ́rɛ nuvoowú ɩráa rɩ́ŋa wónɖóm nɛ́, ngɛ ɩrʊ́ ɩmʊ́ ɩbáɖaa wɔɔgɔná nyɩ́ɩ́dɩ tɩtɛ ńdɩ ɩsɔ ɩlɛ́ ɩdɛ́ɛ bilée-daá bɩka ɩɖɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kúɖúúdi wɔɔnyɔ bɩɖʊ bíya nɛ́, ngɛ nyɩ́ɩ́dɩ tɩtɛ ńdɩ ɖʊɖɔ waaɖʊ tɩlɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ngɛ ɖaána-dʊ́ʊ-dɛ́ɛ bɔwʊtá-dɩnáa wɔɔgɔ́nɩ bɔtɔ́ yɩ sɩsɩ: “Kʊ́bɔnɩ́, mányɩ sɩsɩ kúɖúúdi kazɔ́ɔ ńdɩ gɛ nyóóɖúu nyɔ́vɔɔ́-daá ya. Lé gɛ nyɩ́ɩ́dɩ tɩtɛ ńdɩ waalɩɩ ná.” ");
INSERT INTO kdh_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ngɛ woobúsi wɛ sɩsɩ: “Ɩ́bɛrɛ naárʊ waala ná bɩlɛ́.” Ńna gɛ ɩdɛ́ɛ bɔwʊtá-dɩnáa sɩsɩ: “Bɩlɛ́ nɛ́, nyɔ́zɔɔlɛ́ɛ sɩsɩ ɖibó ɖɩkpɛzɩ́ nyɩ́ɩ́dɩ tɩtɛ ńdɩ tɩḿ?” ");
INSERT INTO kdh_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ngɛ ɩlɛ́ sɩsɩ: “Aayɩ́, ɩ́kɔkɔ́nɩ ɩkpɛzɩ́ bɩkpɛdɩ́na kúɖúúdi. ");
INSERT INTO kdh_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Iyéle bɩrɩ́ŋa bɩbɩ́ɩ hálɩ kʊ́m sáátɩ. Sáátɩ kɩḿ nɛ́, ménveerím kʊmɖáa sɩsɩ bákʊ nyɩ́ɩ́dɩ tɩtɛ ńdɩ bɔfɔ́kɩ na bɔsɔ́ tɩ nimíni, bɩɩga bilée nɛ́, a baagʊ́ kɩ bɩtɛ́, boboná kɩ babɩ́rɩ mégbééwú-daá.”» ");
INSERT INTO kdh_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ngɛ Yeésu waadáŋmatɩ wɛ na tɔmgɛɛzɩrɛ neɖére sɩsɩ: «Ɩbɛ́ɛ wenbí bɛ́ngɛɛzɩnáa Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ nɛ́: kaalɩ́ɩ báńŋɩ́náyɔ́ɔ bú ɩrʊ́ wɔɔgbɔ́ɔ iɖúu ɩvɔɔ́-daá nɛ́ gɛ. ");
INSERT INTO kdh_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Idekii ná kúɖúúdiwá rɩ́ŋa-daá; amá, a wɔɔnyɔ, na ɩdɛ́ɛ tikú ɩkʊrʊ́ ɩkɩ́lɩ ɖóóziwá sɩɩganáa rɩ́ŋa-dɛ́ɛ tikíni hálɩ ɩbɩ́sɩ tɩɩwʊ́ bɩka siḿsi wɔ́ngɔnɩ́ sɩ́ngaá sɩdɛ́ɛ ɖɛ́ńɖɛ́lá kɩdɛ́ɛ wʊláázɩ-daá.» ");
INSERT INTO kdh_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ngɛ Yeésu waadáŋmatɩ wɛ na tɔmgɛɛzɩrɛ neɖére sɩsɩ: «Ɩbɛ́ɛ wenbí bɛ́ngɛɛzɩnáa Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ nɛ́: kɔjɔɔ́ɔ gɛ nyazɩ faadɩ́nɩ alʊ́ wɔɔgbɔ́ɔ inuudiná kpɔ́nɔ́ mʊlʊ́m agúwe natúdoozo kpɔ́nɔ́ mʊ́tʊ rɩ́ŋa ɩkpa nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Na tɔmgɛɛzɩrɛ gɛ Yeésu waaŋmatɩná zamɔ́ɔ tɔ́mwá tɩna tɩrɩ́ŋa. Ɩdaŋmátɩ natɩ́rɩ bɩdɛkɛ́ɛ na tɔmgɛɛzɩrɛ, ");
INSERT INTO kdh_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","na wentí anɖébi waaŋmátɩ nɛ́ ikóódi; tɩlɛ́ gɛ sɩsɩ: «Mónvulúu mɔ́nɔ́ɔ́ maŋmatɩná wɛ na tɔmgɛɛzɩrɛ. Mɔ́nbɔwʊ́ʊ wentíwá tɩvʊnmʊ́sɛ́ɛ ɖoo balám ɖúúlínya nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ngɛ Yeésu weeyéle zamɔ́ɔ ɩɖɛ́ɛ ɖaána. Ngɛ ɩwanbaaráa woogóduu ɩjɔ́ bɔtɔ́ yɩ sɩsɩ: «Lɩzɩ́ ɖáa fɔɔ́-daá nyɩ́ɩ́dɩ tɩtɛ ńdɩ-dɛ́ɛ tɔmgɛɛzɩrɛ kutoluú.» ");
INSERT INTO kdh_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ngɛ woobúsi wɛ sɩsɩ: «Weení wooɖúu kúɖúúdi kazɔ́ɔ ńdɩ nɛ́ gɛ Ɩrʊ́ Biyaalʊ́, ");
INSERT INTO kdh_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","fɔɔ́ gɛ ɖúúlínya. Kúɖúúdi kazɔ́ɔ ńdɩ gɛ wenbá badɩɩná Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ nɛ́. Nyɩ́ɩ́dɩ tɩtɛ ńdɩ gɛ wenbá bovóo kidaavéénúu nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ɩ́bɛrɛ weení wooɖúu nyɩ́ɩ́dɩ tɩtɛ ńdɩ nɛ́ gɛ Sitáánɩ. Kʊ́m sáátɩ gɛ ɖúúlínya kʊrʊ́ʊ wɩ́rɛ. Bɩɩga kʊmɖáa gɛ malááyɩ́kawá. ");
INSERT INTO kdh_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ńŋɩnáa bánlɩzɩ́ɩ nyɩ́ɩ́dɩ tɩtɛ ńdɩ na bɔsɔ́ tɩ nimíni nɛ́, bɩlɛ́ gɛ sɩ bɩlá ɖúúlínya kʊrʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ɩrʊ́ Biyaalʊ́ wéngediríi ɩdɛ́ɛ malááyɩ́kawá balɩzɩ́ ɩdɛ́ɛ kowúrɔ́ɔ-daá wenbá barɩ́ŋa bénÿelíi baranáa wánlám alaháácɩ́ nɛ́ na wenbá barɩ́ŋa bánlám bɩdaavé nɛ́; ");
INSERT INTO kdh_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","na bɔlɔ wɛ nimíni kʊ́bɔnɩ́-daá, ńna gɛ bénwií balá mányɩ lé. ");
INSERT INTO kdh_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Bɩdɛ́ɛ sáátɩ kɩḿ nɛ́, toovonúm-dɩnáa wénɖée nyazɩ wɩ́sɩ bɩlɛ́ Bajaa-dɛ́ɛ kowúrɔ́ɔ-daá. Weení ɩwɛná nɩgbamɩ́nɩ nɛ́, ɩ́nɩɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ cɔɔ́ɔ gɛ nyazɩ ɖɔ́ɔ́lɛ baamʊ́sɩ ɖɛ fɔɔ́-daá gɛ naárʊ waalɩ́ɩ ɖɩrɔ nɛ́; ɩlɛ́ ɖʊɖɔ wándamʊsɩ́ ɖɛ gɛ na ńŋɩnáa bɩjɔɔ́ɔ yɩ niíni nɛ́, wónboɖé ɩyá wenbí bɩrɩ́ŋa ɩwɛná nɛ́ na ɩmʊ fɔɔ́ kɛḿ. ");
INSERT INTO kdh_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ tɔrɔjɔɔ́ɔ gɛ nyazɩ bɛ́ɛ́dɛ́ɛ́rɛ-dʊ́ʊ weení wánjáádɩ kejibíya kazɔ́ɔ ńba nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Wooyuú kejibú kífenvení nɛ́, ngɛ woobó ɩyá wenbí bɩrɩ́ŋa ɩwɛná nɛ́ ibó ɩmʊ yɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ tɔrɔjɔɔ́ɔ gɛ nyazɩ biruú bɔ́nlɔ́ɔ tenkú-daá na kikóbuu tiiná ndɩ‑ndɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","A tiiná woozu biruú, na banára kɩ balɩɩná kpaam-rɔ, na balɩzɩ́ tiiná kazɔ́ɔ ńná baɖʊ ɖɔkɩ́nɩ-daá na bɛbɛ́ɖɩ weená avɛ́yɩ́na fɔ́ɔ́zɩrɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Bɩlɛ́ nɔ́ɔ́ gɛ sɩ bɩlá ɖúúlínya kʊrʊ́ʊ. Malááyɩ́kawá wánɖʊ́ʊ balɩ́ɩ, na bata balɩzɩ́ toovonúm-dɩnáa fɔɔlʊʊ́, badaavé nɛ́ fɔɔlʊʊ́, ");
INSERT INTO kdh_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","na bɔlɔ badaavé nɛ́ nimíni kʊ́bɔnɩ́-daá. Ńna gɛ bénwií balá mányɩ lé.» ");
INSERT INTO kdh_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ngɛ Yeésu wɔɔbɔ́ɔ́zɩ ɩwanbaaráa sɩsɩ: «Mɩ́ɩ́nɩ́ɩ wentí tɩrɩ́ŋa mááŋmátɩ ɖɔ́ nɛ́ tugutoluú?» Ngɛ bɛlɛ́ boobúsi yɩ sɩsɩ: «Ɩɩ́n». ");
INSERT INTO kdh_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ngɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Mará wɩlɩɖʊ́ weení baawɩ́lɩ yɩ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-dɛ́ɛ tɔ́m nɛ́, cɔɔ́ɔ gɛ nyazɩ ɖaána-dʊ́ʊ weení wánlɩzɩ́ɩ ɩdɛ́ɛ ɖɔ́ɔ́lɛ-daá kɩ́fabɩ na kɩ́bɩńbɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yeésu waaŋmatɩná tɔ́mwá tɩna na tɔmgɛɛza bɩtɛ́ nɛ́, ngɛ waalɩ́ɩ ɖɩdáarɛ ɖɩḿ ɖɩdaá. ");
INSERT INTO kdh_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ngɛ wɛɛɖɛ́ɛ tɛ́ɛ́dɩ wentí tɩdaá wɔɔjɔ́ɔ ɩbɩ́ɩ nɛ́; bɩka wánwɩlɩ́ɩ ɩráa Ɩsɔ́ɔ-dɛ́ɛ tɔ́m bɛdɛ́ɛ Ɩsɔ́ɔ ɖaazɛɛɖɛ́. Ngɛ bɩɩlá bɛlɛ́ bítí bɔ́ndɔ́m sɩsɩ: «Lé gɛ wooyuú na áséńsí na maamááciwá tɩna bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Mányɩ sɩsɩ kááfɩ́nta biyaalʊ́ nbɩlɛ́! Mányɩ sɩsɩ ɩgɔɔ gɛ Marɩyáma bɩka igoobíya gɛ Yaakúbu na Ísifu na Simɔ́ɔnɩ na Yudáa gɛ! ");
INSERT INTO kdh_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Mányɩ sɩsɩ ɖána igoobíya aláa rɩ́ŋa gɛ cé ya! Ngɛ lé gɛ ɩmʊ́ wooyuú na bɩna bɩrɩ́ŋa.» ");
INSERT INTO kdh_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ngɛ bɛdɛ́ɛ banyɩ Yeésu nɛ́ wɔɔdɔ wɛ nɩ́bááwʊ sɩsɩ bafa yɩ toovonúm. Ńna gɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Bánváa anɖébi gírímá báa lé, asée ɩdɛ́ɛ́dɩ na ɩɖaána-daá baasí gɛ bɛ́ngbɛɛnáa yɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tɛ́ɛ́dɩ tɩḿ tɩdaá, Yeésu talá maamááciwá ɖabata káma, badafa yɩ toovonúm. ");
INSERT INTO kdh_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Bɩdɛ́ɛ sáátɩ kɩḿ, Eróodi weení wénɖíi kowúrɔ́ɔ Galilée nɛ́ waanɩ́ɩ bánŋmatɩ́ Yeésu-dɛ́ɛ tɔ́m. ");
INSERT INTO kdh_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ngɛ wɔɔdɔ́ ɩdɛ́ɛ bɔwʊtá lanɖáa sɩsɩ: «Ɩrʊ́ ceení ɖɔ́, Yaayá gɛ. Weevé ɩlɩ́ɩ ɩsɩɖáa-daá-rɔ gɛ ɩwɛná yíko wánlám maamááciwá.» ");
INSERT INTO kdh_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Wúro Eróodi waamáázɩ bɩlɛ́ káma, waavʊ́ńÿélí bakpa Yaayá baɖʊ yɩ agbarangbára bɔtɔ sáráka; káma, wúro Eróodi wɔɔgbɔ́ɔ igoobú Filíipu ɖɛɛlʊ́ Erodiyáadɩ nɛ́, ");
INSERT INTO kdh_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yaayá wɔɔdɔ́ yɩ sɩsɩ: «Ńdɔmɔ́ɔ́ná nlá bɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Wúro Eróodi wɔɔzɔ́ɔ́lɩ sɩsɩ ɩkʊ yɩ, amá, wánnɩɩ́ zamɔ́ɔ nɩdáárɛ, káma, kɩlɛ́ kiiɖéézi sɩsɩ Yaayá kɛ́ɛ anɖébi gɛ. ");
INSERT INTO kdh_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ngʊ́ nbɛ́ɛ́ŋ nɛ́, wúro Eróodi-dɛ́ɛ lʊrʊ́ʊ wɩ́rɛ tɔɔzɩ́-dɛ́ɛ jíńgáárɩ́ wɩ́rɛ waadála nɛ́, ngɛ Erodiyáadɩ wɛɛlɛ́ɛ waabáa zamɔ́ɔ baayáa kɩ ɖíína nɛ́ kɩɩzá-daá. Ɩdɛ́ɛ báárɛ waalá wúro kazɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ngɛ Eróodi wooɖuuná sɩsɩ báa wé gɛ wɔɔbɔ́ɔ́zɩ, ɩmʊ́ wánváa yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Bɩnáábɩ́lɛ́ bú ɩgɔɔ waadásɩ yɩ tɔ́m sɩsɩ ɩ́tɔ sɩsɩ: «Fa ma Yaayá kʊjʊʊ́ tɛ́lɛ́lɛ́-daá cé.» ");
INSERT INTO kdh_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Wúro laakáarɩ waagʊrʊ́. Amá, ńŋɩnáa wooɖuuná zamɔ́ɔ bayáa kɩ ɖíína nɛ́ ɩzá-daá nɛ́, waava wɛ́ɖɛ sɩsɩ bɔ́kɔ́gɔná aléeré Yaayá kʊjʊʊ́. ");
INSERT INTO kdh_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ngɛ weedíri bɛkɛ́jɛ Yaayá kʊjʊʊ́ sáráka-daá. ");
INSERT INTO kdh_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Bɔɔgɔ́gɔ́ná kʊjʊʊ́ tɛ́lɛ́lɛ́-daá becéle aléeré, ngɛ ɩlɛ́ wooboná kɩ icéle ɩgɔɔ. ");
INSERT INTO kdh_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ngɛ Yaayá-dɛ́ɛ wanbaaráa wɔɔgɔ́nɩ bɔkpɔ́ɔ ɩdɔnʊʊ́ bebí; ngɛ boobó bekéveeri Yeésu. ");
INSERT INTO kdh_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yeésu waanɩ́ɩ tɔ́m tɩḿ nɛ́, ngɛ wɔɔgbɔ́ɔ kpɩ́ɩ́rʊʊ́ ɩɖɛ́ɛ faɖáma-daá ɩgɔjɔɔ́ɔ ɩlaná ɩráa bolíni. Zamɔ́ɔ waanɩ́ɩ bɩlɛ́ nɛ́, ngɛ kɩɩlɩ́ɩ tɛ́ɛ́dɩwá-daá kifu yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yeésu weedí kpɩ́ɩ́rʊʊ́-daá nɛ́, ngɛ waana zamɔ́ɔ kʊ́bɔńgɩ. Ngɛ kɩdɛ́ɛ tɔ́m waalá yɩ kʊnyɔḿ. Ngɛ waawáázɩ bɛdɛ́ɛ kʊdɔndɩnáa. ");
INSERT INTO kdh_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ɖaanɩ́ŋa waalá nɛ́, ngɛ Yeésu-dɛ́ɛ wanbaaráa woogóduu ɩjɔ́ bɔtɔ́ yɩ sɩsɩ: «Ɖɔ́jɔɔ́na tɛ́ɛ́dɩ bolíni, ngʊ́ kɩɩɖáánɩ, bɩlɛ́ nɛ́, feeri zamɔ́ɔ kɩɖɛ́ɛ tɛɛbíízi-daá kɩkámʊ́ kíɖíím kiɖi.» ");
INSERT INTO kdh_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Amá, Yeésu woobúsi wɛ sɩsɩ: «Bɩdɔbɔ́ɔ́zɩ sɩsɩ bobó ɖeelí, mɩ́dɩtɩŋa ɩva wɛ kíɖíím beɖi.» ");
INSERT INTO kdh_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ńna gɛ bɛlɛ́ bɔɔdɔ́ yɩ sɩsɩ: «Kpɔ́nɔ́wá natʊ́nʊ́wá na tiiná náálɛ gɛ ɖɔ́jɔ́ cé.» ");
INSERT INTO kdh_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ngɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Ɩgɔná ma kpɔ́nɔ́wá natʊ́nʊ́wá na tiiná náálɛ amʊ́ cé.» ");
INSERT INTO kdh_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ngɛ waava wɛ́ɖɛ sɩsɩ zamɔ́ɔ ɩcɔ́ɔ adɛ nyɩ́ɩ́dɩ-rɔ. Ngɛ wɔɔgbɔ́ɔ kpɔ́nɔ́wá natʊ́nʊ́wá na tiiná náálɛ amʊ́, ɩsá Ɩsɔ́ɔ bʊrɔ. Bɩlɛ́ bʊwɔ́rɔ́ gɛ wɛɛbɛlɩ́ kpɔ́nɔ́wá, ɩkpɔ́ɔ tɩ icéle ɩwanbaaráa batára zamɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Barɩ́ŋa bɔɔdɔ́ɔ bɔfɔ́ɔ. Fɔɔlásɩ sɩɩga wanbaaráa wɔɔdɔ́ɔ́zɩ nɛ́ woozu ɖɔkɩ́nɩ fuú na natɩ́lɛ. ");
INSERT INTO kdh_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Abaaláa nyazɩ mííli nɔɔ́nʊ́wá bɩlɛ́ weeɖi ná kíɖíím bɩḿ, ngʊ́ badakála aláa na bíya. ");
INSERT INTO kdh_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Bɩlɛ́ bɩɩjáŋ bʊwɔ́rɔ́ gɛ Yeésu waajáárɩ ɩwanbaaráa sɩsɩ bákpa kpɩ́ɩ́rʊʊ́-daá bɛtɛ ɩmʊ́ nɩ́bááwʊ bɛtɛsɩ ná fɔɔlʊʊ́ kɩɩganáa. Bɩdɛ́ɛ sáátɩ nɛ́, ɩmʊ́ iyéle zamɔ́ɔ ɩya ɖamá. ");
INSERT INTO kdh_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Weeyéle zamɔ́ɔ ɩya ɖamá bɩtɛ́ nɛ́, ngɛ waagba bʊ́ʊ-daá sɩ ɩsʊ́lʊ Ɩsɔ́ɔ. Kɩɩɖáánɩ nɛ́, ɩwɛ ńna iriké. ");
INSERT INTO kdh_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kpɩ́ɩ́rʊʊ́ wáńláná laadɔ́ɔ bolíni bɩka lɩ́m wángʊrʊ́ʊ bínÿoó kɩ, káma, fefelimá wónÿoó kɩ. ");
INSERT INTO kdh_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Asʊbáa gɛ Yeésu wɔɔgɔ́nɩ ɩwanbaaráa-jɔ́ wánganʊŋ́ lɩɩrɛ́ kʊ́bɔńɖɛ-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Wanbaaráa waana yɩ wánganʊŋ́ lɩ́m-rɔ nɛ́, nɩdáárɛ waazʊ́ʊ wɛ bɔ́ndɔ́m sɩsɩ: «Ásɩ́náálɩ́ɩ gɛ!» Ngɛ baabáázɩ agogo. ");
INSERT INTO kdh_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ńna‑ńna Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Ɩɖɔ́kɩ mɩ́dɩ, mɔ́ɔ́ gɛ, ɩ́kanɩ́ɩ nɩdáárɛ.» ");
INSERT INTO kdh_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ńna gɛ Pétro wɔɔdɔ́ yɩ sɩsɩ: «Ɖádʊ́ʊ, a toovonúm nyánáábɩ́lɛ́, fa ma nɩ́bááwʊ manʊ́ŋ lɩ́m-rɔ mɔgɔ́nɩ nyɔ́jɔ́.» ");
INSERT INTO kdh_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ngɛ Yeésu wɔɔdɔ́ yɩ sɩsɩ: «Kɔnɩ.» Ngɛ Pétro waalɩ́ɩ kpɩ́ɩ́rʊʊ́-daá, wánnʊŋɛ́ lɩ́m-rɔ wɛ́nɖɛɛ́ Yeésu-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Amá, waana fefelimá-dɛ́ɛ ɖóni nɛ́, ngɛ nɩdáárɛ waazʊ́ʊ yɩ. Ńna gɛ waabáázɩ lɩ́m-daá tím. Ngɛ woogóo sɩsɩ: «Ɖádʊ́ʊ, lɛɛ ma.» ");
INSERT INTO kdh_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ńna‑ńna gɛ Yeésu wɔɔlɔ nʊ́ʊ́nɩ ɩɖɔ́kɩ Pétro, ngɛ wɔɔdɔ́ yɩ sɩsɩ: «Nyɛ́dɛ́ɛ toovonúm fáa tɔɖɔ́ɔ, ngbaalá nyáálá síka.» ");
INSERT INTO kdh_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Baabɩ́sɩ bakpa kpɩ́ɩ́rʊʊ́-daá nɛ́, ngɛ fefelimá waazála. ");
INSERT INTO kdh_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ngɛ wenbá bɔwɛ kpɩ́ɩ́rʊʊ́-daá nɛ́ boogúu yɩ tɛ́ɛ́dɩ bɔtɔ́ sɩsɩ: «Toovonúm gɛ, nyɔ́ɔ́ gɛ Ɩsɔ́ɔ Biyaalʊ́.» ");
INSERT INTO kdh_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bɛɛdɛ́sɩ lɩɩrɛ́ kʊ́bɔńɖɛ bɩtɛ́ nɛ́, baadála Genezarɛ́ɛtɩ laadɔ́ɔ-daá. ");
INSERT INTO kdh_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tɛ́ɛ́dɩ tɩḿ tɩdaá ɩráa waadɩlɩ́ yɩ, ngɛ beegíli befééri ɩráa fáráńdɩ́ kɩḿ kɩrɩ́ŋa kɩdaá, ngɛ bɔɔgɔná yɩ kʊdɔndɩnáa rɩ́ŋa. ");
INSERT INTO kdh_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ngɛ baavɩ́nɩ yɩ sɩsɩ íyele kʊdɔndɩnáa itekiná báa ɩdɛ́ɛ tóko njʊ́ʊ́rɛ riké. Ngɛ wenbá barɩ́ŋa beedekiná nɛ́, baawáa. ");
INSERT INTO kdh_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Bɩlɛ́ bʊwɔ́rɔ́ nɛ́, ngɛ Faríizi ńba na Mará wɩlɩɖáa waalɩɩná Yerusalɛ́ɛm bɔkɔ́nɩ Yeésu-jɔ́, ngɛ bɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Ngbaalá gɛ nyɛ́dɛ́ɛ wanbaaráa tónvúu caájaanáa-dɛ́ɛ taáɖɛ. Káma, bádánzam banʊ́ʊ́zɩ naanɩ́ beɖi kíɖíím.» ");
INSERT INTO kdh_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yeésu woobúsi wɛ sɩsɩ: «Mɩ́nyɔ́ɔ́ ní, we-rɔ gɛ mɩ́nÿɩsɩnáa Ɩsɔ́ɔ-dɛ́ɛ Mará mɩ́dɛ́ɛ taáɖɛ-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Káma, Ɩsɔ́ɔ wɔɔdɔ́ sɩsɩ: “Ɖɔɔzɩ ngɔɔ na njaa,” ngɛ wɔɔdɔ́tɔḿ sɩsɩ: “Weení waalá ɩgɔɔ yáá ɩjaa láálɩ́ nɛ́ mɔɔ́na bakʊ yɩ.” ");
INSERT INTO kdh_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Amá, mɩ́nyɔ́ɔ́ mɩ́ndɔ́m sɩsɩ a ɩrʊ́ wɔɔdɔ́ ɩgɔɔ yáá ɩjaa sɩsɩ: “Wenbí máázɩ́ɩ sɩ malá nya kʊjɔɔwʊ na bɩsɩná nya nɛ́, mɔ́ɔ́gbɔ́ɔ bɩ malá Ɩsɔ́ɔ sarɔ́ɔ,” ");
INSERT INTO kdh_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","mɩ́nwɩlɩ́ɩ sɩsɩ bidokúti bɩbɔ́ɔ́zɩ bʊdʊ́ʊ ɩɖɔ́ɔ́zɩ ɩjaa. Bɩlɛ́ gɛ mɩ́dɛ́ɛ taáɖɛ-rɔ, mɩ́nɖɩ́m Ɩsɔ́ɔ-dɛ́ɛ tɔ́m. ");
INSERT INTO kdh_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Munáávikíwá bana ɖɔ́, Esáya waabá ɩwɛná toovonúm waaŋmatɩná Ɩsɔ́ɔ nɔɔ́ ɩŋmátɩ mɩ́dɔ́m nɛ́; káma, waaŋmátɩ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Na ntɔɔ́nɩ gɛ zamɔ́ɔ kɩna kɩ́nÿaanáa máyɩ́ɖɛ, amá, kiwenbiré cɔɔ́ɔ na ma bolíni. ");
INSERT INTO kdh_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Faala gɛ bánlám sɩsɩ bɛ́nzɛɛ́ ma, káma, wentí bánwɩlɩ́ɩ nɛ́ kɛ́ɛ ɩráa-dɛ́ɛ mará gɛ.”» ");
INSERT INTO kdh_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ngɛ Yeésu waayáa zamɔ́ɔ ɩtɔ́ kɩ sɩsɩ: «Iwélesi ɩnɩ́ɩ ma kazɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Bɩdɛkɛ́ɛ wenbí bɩ́nzʊʊ́ ɩrʊ́ nɔɔ́-daá nɛ́ wénÿelíi kʊ ɩvɛ́yɩ́ ɖacɩrɩ‑cɩrɩ, amá, wenbí bɩ́nlɩɩ́ ɩnɔɔ́-daá nɛ́ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ngɛ Yeésu-dɛ́ɛ wanbaaráa woogóduu ɩjɔ́ bɔtɔ́ yɩ sɩsɩ: «Nyáádɩ́lɩ́ sɩsɩ wentí nyááŋmátɩ nɛ́, tɩɩgʊ́sɩ Faríizi ńba laakáarɩ?» ");
INSERT INTO kdh_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ngɛ woobúsi wɛ sɩsɩ: «Tɩɩwʊ́ wenkí kɩrɩ́ŋa Majaa weení ɩwɛ ɩsɔ́ɔ́dáá nɛ́ toɖúu kɩ nɛ́, bɛ́ngbɛzɩ́ɩ kɩ. ");
INSERT INTO kdh_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Iyéle wɛ, njɛma wéngeti kʊ njɛma. Ngʊ́ bɩlɛ́ gɛ a njɛm wéngeti kʊ njɛm, bɛlɛ́ɛ́nɩ́ bánzalɩ́ɩ bɔɔwʊ́-daá gɛ.» ");
INSERT INTO kdh_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ńna gɛ Pétro sɩsɩ: «Lɩzɩ́ ɖáa tɔ́m nyɛ́ɛ́gɛ́ɛ́zɩ tɩ ɖɔ́ nɛ́ tugutoluú.» ");
INSERT INTO kdh_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ngɛ Yeésu sɩsɩ: «A bɩlɛ́ mɩ́nyɔ́ɔ́ ɖʊɖɔ mɩ́vɛ́yɩ́na tɩlɩ́ɩ? ");
INSERT INTO kdh_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mɩ́ɩ́sɩ sɩsɩ wenbí bɩrɩ́ŋa bɩ́nzʊʊ́ nɔɔ́-daá nɛ́, bíndím lóódi-daá gɛ na bɩlɩ́ɩ bɩɖɛ́ɛ ɖɩyáásʊ́-daá? ");
INSERT INTO kdh_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Amá, wenbí bɩ́nlɩɩ́ ɩrʊ́ nɔɔ́-daá nɛ́, wánlɩɩnáa wenbiré-daá gɛ. Ngɛ bɩlɛ́ bínÿelíi kʊ gɛ ɩrʊ́ fɛ́yɩ́ ɖacɩrɩ‑cɩrɩ. ");
INSERT INTO kdh_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Bɩlɛ́ nɛ́, wenbiré-daá gɛ lomaazɛ́ tɩtɛ ńná wánlɩɩnáa: bɛɛ ɩráa kʊ́ʊ, ɩrʊ́ ɩlɩ́ɩ ɩwaalʊ́ yáá ɩɖɛɛlʊ́ wɔ́rɔ́, wásangarɩ́tɩ, ŋmɩɩlɩ́m, seríya tɩtɛ ńgɩ, na ɩráa tʊ́ʊ́dɩ. ");
INSERT INTO kdh_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Wenbí bínÿelíi ɩrʊ́ fɛ́yɩ́ ɖacɩrɩ‑cɩrɩ nɛ́ nbɩlɛ́. Amá, ɩrʊ́ iɖi kíɖíím ɩdasám ɩnʊ́ʊ́zɩ ténÿelí ɩ́dánlaḿ ɖacɩrɩ‑cɩrɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yeésu waalɩ́ɩ ńna nɛ́, ngɛ wɛɛɖɛ́ɛ Tíiri na Sidɔ́ɔnɩ fáráńdɩ́. ");
INSERT INTO kdh_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ngɛ Kanáanɩ alʊ́ naárʊ ɩwɛ fáráńdɩ́ kɩḿ kɩdaá nɛ́ wɔɔgɔ́nɩ ɩjɔ́ wóngoó sɩsɩ: «Nɩɩ mágʊnyɔḿ, Kʊ́bɔnɩ́, Ɖáwʊɖa Biyaalʊ́. Zííni ɩbaná kɩ́njaarɩ́ mɛwɛɛlɛ́ɛ.» ");
INSERT INTO kdh_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Amá, Yeésu tobúsi yɩ báa tɔ́m bú. Ɩwanbaaráa woogóduu ɩjɔ́ nɛ́, ngɛ bɛlɛ́ bɔɔdɔ́ yɩ sɩsɩ: «Ɖɔɔ yɩ, káma, ivóo ɖáa wánjaarɩ́ ɖáa na agogo.» ");
INSERT INTO kdh_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ngɛ Yeésu woobúsi sɩsɩ: «Israyɛ́ɛlɩ fééni tɩɩdɛlɛ́ŋ nɛ́ tiriké tɩrɔ gɛ beegédiri ma.» ");
INSERT INTO kdh_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Amá, alʊ́ ceení wɔɔgɔ́nɩ isóm waazá-daá wánvɩnɩ́ yɩ sɩsɩ: «Ɖádʊ́ʊ, lɛɛ ma.» ");
INSERT INTO kdh_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ngɛ Yeésu woobúsi yɩ sɩsɩ: «Bɩvɛ́yɩ́ kazɔ́ɔ sɩsɩ bɔkpɔ́ɔ bíya-dɛ́ɛ kíɖíím bɔlɔ fáa‑bíya.» ");
INSERT INTO kdh_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ngɛ alʊ́ sɩsɩ: «Toovonúm gɛ, amá, fáa‑bíya wánjalaazɩ́ cʊ́kɔ wenkí kɩ́nlɩɩ́ sɩdɩnáa-dɛ́ɛ tébíri-rɔ bɩ́nzalɩ́ɩ nɛ́ sínɖíi.» ");
INSERT INTO kdh_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ńna gɛ Yeésu woobúsi alʊ́ ɩmʊ́ sɩsɩ: «Ɖɔ́gɔɔ, nyɛ́dɛ́ɛ toovonúm fáa wɔɔɖɔ́ɔ. Ɩsɔ́ɔ ɩ́fá nya wenbí nyɔ́ɔ́zɔ́ɔ́lɩ nɛ́.» Sáátɩ kɩḿ nɔ́ɔ́ ɖʊɖɔ gɛ ɩwɛɛlɛ́ɛ waagáwaa. ");
INSERT INTO kdh_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Bɩlɛ́ bʊwɔ́rɔ́ nɛ́, ngɛ Yeésu waalɩ́ɩ ńna ɩɖɛ́ɛ Galilée lɩɩrɛ́ kʊ́bɔńɖɛ-jɔ́. Ngɛ waagba bʊ́ʊ-daá ití ɩcɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ngɛ zamɔ́ɔ kʊ́bɔńgɩ wɔɔgɔ́nɩ ɩjɔ́ kɩ́gana nʊvɔ́-dɩnáa na njɛma na wenbá biilí wɛ nɛ́, na komóomúsi, na kʊdɔndɩnáa nɛbɛ́rɛ ɖʊɖɔ. Ngɛ bɔɔgɔná wɛ basɩ́ɩ Yeésu nʊvɔ́-jɔ́. Ngɛ Yeésu waawáázɩ wɛ. ");
INSERT INTO kdh_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Bɩɩlá zamɔ́ɔ mááɖé kɩɩna komóomúsi wánŋmatɩ́ nɛ́, na wenbá biilí wɛ nɛ́ baawáa nɛ́, na nʊvɔ́-dɩnáa wánnʊŋɛ́ bazɩɩzɛ́ɛ nɛ́, na njɛma wánnáa nɛ́. Ngɛ zamɔ́ɔ kɩḿ kɩɩɖɔ́ɔ́zɩ Israyɛ́ɛlɩ-dɛ́ɛ Ɩsɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ngɛ Yeésu waayáa ɩwanbaaráa ɩtɔ́ wɛ sɩsɩ: «Zamɔ́ɔ kɩna kɩjɔɔ́ɔ ma kʊnyɔḿ, káma, wɛ́ náádoozo nbɩlɛ́ kʊwɛ mɔ́jɔ́ nɛ́, ngʊ́ kɩvɛ́yɩ́na nabʊ́rʊ sɩ kiɖi. Mádánjaa mɔdɔ́ kɩ sɩsɩ kíkpe bɩka kideɖi nabʊ́rʊ, na kɩ́kɔkɔ́nɩ kɩwɩ́ɩ nɩ́bááwʊ-daá.» ");
INSERT INTO kdh_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ngɛ wanbaaráa wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Lé gɛ ɖónÿuú na kpɔ́nɔ́wá faɖáma kɩna kɩdaá bɩtála zamɔ́ɔ ńŋɩnáa kɩna ɖɔ́ kiɖi kɩfɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ngɛ Yeésu wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «Kpɔ́nɔ́wá nŋɩ́nɩ́ gɛ mɩ́wɛná.» Ngɛ boobúsi yɩ sɩsɩ: «Tɩrɔ lʊbɛ na tiiná yáawá cʊ́kɔ ɖɔ́.» ");
INSERT INTO kdh_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ngɛ weeyéle zamɔ́ɔ ɩcɔ́ɔ adɛ. ");
INSERT INTO kdh_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ngɛ wɔɔgbɔ́ɔ kpɔ́nɔ́wá lʊbɛ tɩḿ na tiiná amʊ́. Waazá Ɩsɔ́ɔ bɩtɛ́ nɛ́, ngɛ wɛɛbɛlɩ́ tɩ ɩkpɔ́ɔ icéle ɩwanbaaráa batára zamɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Barɩ́ŋa bɔɔdɔ́ɔ bɔfɔ́ɔ. Fɔɔlásɩ sɩɩga wanbaaráa wɔɔdɔ́ɔ́zɩ nɛ́, woozu ɖɔkɩ́nɩ lʊbɛ. ");
INSERT INTO kdh_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Abaaláa mííli nɔɔ́náázá weeɖi ná kíɖíím bɩḿ, ngʊ́ badakála aláa na bíya. ");
INSERT INTO kdh_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yeésu weeyéle zamɔ́ɔ ɩya ɖamá wɔ́rɔ́ nɛ́, ngɛ waagba kpɩ́ɩ́rʊʊ́-daá ɩɖɛ́ɛ Magadáanɩ fáráńdɩ́-daá. ");
INSERT INTO kdh_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Faríizi ńba na Sadusée ńba woogóduu Yeésu-jɔ́ sɩ bayɩ́ yɩ kɔdɔká. Ngɛ bɔɔdɔ́ yɩ sɩsɩ ɩ́la maamááci nakɩ́rɩ kɩ́nwɩlɩ́ɩ sɩsɩ Ɩsɔ́ɔ-jɔ́ gɛ waagálɩ́ɩ́ná nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yeésu woobúsi wɛ sɩsɩ: «A ɖaanɩ́ŋa waalá, mɩ́ndɔ́m sɩsɩ: “Ɩsɔ́ɔ́dáá wɛ́njɛ́m káma, ŋmɩ́ńdɩ wɛɛzɛ́ɛ.” ");
INSERT INTO kdh_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Bɩka tɛ́ɛrɛ́ nɛ́, mɩ́ndɔ́m sɩsɩ: “Sinje ɩsɔ́ɔ́dáá fɛ́yɩ́ ɖéyí‑ɖéyí, káma, biivu ɩsɔ́ɔ́dáá, bɩraajɛmáa.” Bɩlɛ́ gɛ mɩ́nyɩ mɩ́nbɛɛŋnáa ɩsɔ́ɔ́dáá mɩ́nɖaazɩ́ sáátɩwá. Amá, wentí tɩ́nlám lɛlɛɛɖɔ́ nɛ́ gɛ mɩ́ɩ́sɩ. ");
INSERT INTO kdh_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Zaamáánɩ kɩna kɩdɛ́ɛ ɩráa badaavé bɩka bádánzɩŋná Ɩsɔ́ɔ riké nɛ́, bɔ́nbɔɔzɩ́ maamááci. Amá, Ínúusa-dɛ́ɛ maamááci baasí, bádánnáa nakɩ́rɩ ɖʊɖɔ.» Ngɛ Yeésu weeyéle wɛ ńna ɩɖɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Wanbaaráa wɛɛdɛ́sɩ lɩɩrɛ́ kʊ́bɔńɖɛ-dɛ́ɛ fúu lí ńgɩ-rɔ nɛ́, bɔɔzɔ́ɔ bɔdɔkpɔ́ɔ kpɔ́nɔ́wá. ");
INSERT INTO kdh_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Ɩlá laakáarɩ na Faríizi ńba na Sadusée ńba-dɛ́ɛ faadɩ́nɩ bónnuudináa kpɔ́nɔ́ mʊlʊ́m nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Yeésu wɔɔdɔ́ bɩlɛ́ nɛ́, wanbaaráa waamáázɩ sɩsɩ bɛḿ bɔdɔkpɔ́ɔ kpɔ́nɔ́wá-rɔ gɛ wɔɔdɔ́ bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Amá, Yeésu waadɩlɩ́ bɛdɛ́ɛ lomaazɛ́. Ngɛ wɔɔdɔ́ wɛ sɩsɩ: «Mɩ́dɛ́ɛ toovonúm fáa tɔɖɔ́ɔ, ngbaalá gɛ mɩ́ɩ́máázɩ sɩsɩ mɩ́dɔkɔ́gbɔɔ kpɔ́nɔ́wá-rɔ nɛ́ gɛ. ");
INSERT INTO kdh_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mɩ́dánɩɩ tá kazɔ́ɔ? Mɩ́raadɔɔzɛ́ɛ kpɔ́nɔ́wá natʊ́nʊ́wá ɩráa mííli nɔɔ́nʊ́wá wɔɔdɔ́ɔ bɩka nɛ́, na kpɔ́nɔ́ ɖɔkɩ́nɩ nŋɩ́nɩ́ bɩɩga ɩkpɔ́ɔ ɩkpɛdɩ́na nɛ́? ");
INSERT INTO kdh_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Yáá mɩ́raadɔɔzɛ́ɛ kpɔ́nɔ́wá lʊbɛ ɩráa mííli nɔɔ́náázá wɔɔdɔ́ɔ bɩka nɛ́, na kpɔ́nɔ́ ɖɔkɩ́nɩ nŋɩ́nɩ́ bɩɩga ɩkpɔ́ɔ ɩkpɛdɩ́na nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nŋɩ́nɩ́ gɛ mɩ́dábɩ́ɩ́zɩ ɩnɩ́ɩ sɩsɩ bɩdɛkɛ́ɛ kpɔ́nɔ́wá-dɛ́ɛ ńdɩ gɛ mánŋmatɩ́ sáátɩ wenkí mɔ́ɔ́dɔ́ mɩ́ɩ sɩsɩ ɩ́la laakáarɩ na Faríizi ńba na Sadusée ńba-dɛ́ɛ faadɩ́nɩ bónnuudináa kpɔ́nɔ́ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ńna gɛ baanɩ́ɩ sɩsɩ ɩdɔtɔ́ sɩsɩ bála laakáarɩ na faadɩ́nɩ bónnuudináa kpɔ́nɔ́ nɛ́, amá, Faríizi ńba na Sadusée ńba-dɛ́ɛ wentí bánwɩlɩ́ɩ ɩráa nɛ́ gɛ báláná laakáarɩ. ");
INSERT INTO kdh_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yeésu waadála Sezarée tɛ́ɛ́dɩ wentí wúro Filíipu waama tɩ nɛ́ tɩdɛ́ɛ fáráńdɩ́-daá nɛ́, ngɛ wɔɔbɔ́ɔ́zɩ ɩwanbaaráa sɩsɩ: «Ɩráa-dɛ́ɛ ŋmatɩrɛ-daá, weení gɛ Ɩrʊ́ Biyaalʊ́ kɛ́ɛ.» ");
INSERT INTO kdh_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ngɛ bɛlɛ́ boobúsi yɩ sɩsɩ: «Nɛbɛ́rɛ sɩsɩ nyɔ́ɔ́ gɛ Yaayá, nɛbɛ́rɛ sɩsɩ Elíya, nɛbɛ́rɛ ɖʊɖɔ sɩsɩ nyánáábɩ́lɛ́ Yeremíya yáá anɖébi naárʊ.» ");
INSERT INTO kdh_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ńna gɛ Yeésu wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «Mɩ́nyɔ́ɔ́ mɩ́jɔ́ ní, weení gɛ mɛ́gɛ́ɛ.» ");
INSERT INTO kdh_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Pétro woobúsi yɩ sɩsɩ: «Nyɔ́ɔ́ gɛ Lɛɛrʊ́, Ɩsɔ́ɔ weezuú-dʊ́ʊ Biyaalʊ́.» ");
INSERT INTO kdh_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ńna gɛ Yeésu woobúsi yɩ sɩsɩ: «Simɔ́ɔnɩ, Ínúusa biyaalʊ́, nyóóyúú wenbi‑niíni káma, bɩdɛkɛ́ɛ ɩrʊ́ waawɩlɩ ná nya wentí nyááŋmátɩ tɩ ɖɔ́ nɛ́, amá, Majaa weení ɩwɛ ɩsɔ́ɔ́dáá nɛ́ gɛ. ");
INSERT INTO kdh_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ngɛ mɔ́ɔ́ ménveerím nya sɩsɩ nyɛ́gɛ́ɛ Bʊ́ʊ́rɛ gɛ, ngɛ bʊ́ʊ́rɛ ɖɩḿ ɖɩrɔ gɛ sɩ mama mɛ́dɛ́ɛ Koduuziya. Sɩ́m tɩtɩŋa na bɩdɛ́ɛ yíko bɩ́dánbɩɩzɩ bɩlá kɛ nabʊ́rʊ. ");
INSERT INTO kdh_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ménjelíi nya Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-dɛ́ɛ sááfɩwá. Wenbí sɩ nvɔ́kɩ bɩ adɛ laadɔ́ɔ-rɔ nɛ́, bɔ́ngɔvɔkɩ́ bɩ ɩsɔ́ɔ́dáá; bɩka wenbí sɩ nbóɖi bɩ adɛ laadɔ́ɔ-rɔ nɛ́, bóngoboɖí bɩ ɩsɔ́ɔ́dáá.» ");
INSERT INTO kdh_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ńna gɛ waabásɩ ɩwanbaaráa sɩsɩ békefééri naárʊ sɩsɩ ɩmʊ́ gɛ Lɛɛrʊ́. ");
INSERT INTO kdh_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Sɩɩná sáátɩ kɩḿ gɛ Yeésu waabáázɩ ɩwanbaaráa wɩlɩ́ɩ sɩsɩ bɩ́nbɔɔzɩ́ ɩmʊ́ ibó Yerusalɛ́ɛm ɩna wahála ɖabata Yahúúɖuwá-dɛ́ɛ kʊ́bɔnáa, na sarásɩ lanɖáa kʊ́bɔnáa, na Mará wɩlɩɖáa nʊ́ʊ́zɩ-daá; bakʊ ɩmʊ́, amá, wɛ́ náádoozo wɩ́rɛ, ɩmʊ́ wánbɩsɩ́ ifé ɩlɩ́ɩ ɩsɩɖáa-daá. ");
INSERT INTO kdh_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ńna gɛ Pétro waanára yɩ ɩlɩɩná kpɔ́mɔ́ɔ́, ngɛ weegiziná yɩ ɩtɔ́ yɩ sɩsɩ: «Ɩsɔ́ɔ wénveríi nyɔ́rɔ́, Ɖádʊ́ʊ. Aayɩ́, wentí nyánŋmatɩ́ ɖɔ́ nɛ́, tɩ́dɔ́nmɔɔná nya.» ");
INSERT INTO kdh_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Amá, Yeésu wɛɛgɛ́ɛ́zɩ ɩdɩ nɛ́, ngɛ wɔɔdɔ́ Pétro sɩsɩ: «Laná ma bolíni Sitáánɩ! Nyɛ́gɛ́ɛ ma kɔdɔká gɛ mánɩ́bááwʊ-rɔ, káma, nyólomaazɛ́ tɛkɛ́ɛ Ɩsɔ́ɔ-dɛ́ɛ ńná, amá, ɩráa-dɛ́ɛ ńná gɛ agɛ́ɛ.» ");
INSERT INTO kdh_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ngɛ Yeésu wɔɔdɔ́ ɩwanbaaráa sɩsɩ: «A naárʊ sɔɔlɛ́ɛ sɩ ifu ma, íkizi ɩdɩ bɩka ɩkpɔ́ɔ ɩdɛ́ɛ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ ikóvú ma. ");
INSERT INTO kdh_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Káma, weení wánjáádɩ sɩ ɩlɛ́ɛ iweezuú nɛ́ wɛ́nbɛɖɩ́ kɩ, amá, weení wɛ́nbɛɖɩ́ kɩ mɔ́rɔ́ɔ́zɩ́ nɛ́, wóngoyuú kɩ. ");
INSERT INTO kdh_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ɩrʊ́ iɖi ɖúúlínya rɩ́ŋa, amá, ɩbɛ́ɖɩ iweezuú nɛ́, we gɛ bɩvɔ́ɔ́zɩrɛ. Yáá we gɛ wánbɩɩzɩ́ ɩfɛ́rɛ na ɩmʊ iweezuú. ");
INSERT INTO kdh_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Káma, Ɩrʊ́ Biyaalʊ́ wángabɩsɩ́ na ɩjaa-dɛ́ɛ ásícé-daá ɩ́na ɩdɛ́ɛ malááyɩ́kawá na ɩfɛ́rɛ báa weení bɩlɩɩná wenbí báa weení waalá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ménveerím mɩ́ɩ toovonúm sɩsɩ nɛbɛ́rɛ wɛ cé, bádánzɩḿ naanɩ́ bana Ɩrʊ́ Biyaalʊ́ ɩkɔ́nɩ nyazɩ wúro.» ");
INSERT INTO kdh_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Wɛ́ loɖo wɔ́rɔ́ nɛ́, Yeésu wɔɔgbɔ́ɔ Pétro na Yaakúbu na igoobú Yʊháánɩ bobó bakpa bʊ́ʊ kʊ́bɔńgɩ nakɩ́rɩ-rɔ bɔgɔjɔɔ́ɔ beriké. ");
INSERT INTO kdh_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ngɛ Yeésu-dɛ́ɛ yáásɩ́ wɛɛgɛ́ɛ baazá-daá ńna. Waazá-daá wénɖée nyazɩ wɩ́sɩ bɩlɛ́, bɩka ɩdɛ́ɛ kpɩná izóóna nɛ́ ɩbá afʊ́lʊ párɩ́‑párɩ́. ");
INSERT INTO kdh_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ngɛ ɩwanbaaráa toozóóní waana Múúsá na Elíya baaɖʊ balɩ́ɩ bána Yeésu bánŋmatɩ́. ");
INSERT INTO kdh_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ngɛ Pétro wɔɔdɔ́ Yeésu sɩsɩ: «Ɖádʊ́ʊ, ɖɛ́dɛ́ɛ cénjé cɔwʊ́ʊ wánlám kazɔ́ɔ. A nyɔ́zɔɔlɛ́ɛ, mónzuú kɛ́rɛ́ɛ́zɩ nasúdoozo cé: Nyɔ́ɔ́ kʊ́ɖʊmɔ́ɔ, Múúsá kʊ́ɖʊmɔ́ɔ, Elíya kʊ́ɖʊmɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ɩbamáa ŋmatɩrɛ gɛ, ŋmɩnʊʊ́ nakɩ́rɩ kínnyeléɖi nɛ́ woovu bɔrɔ. Ngɛ baanɩ́ɩ lowú nakɩ́rɩ ŋmɩnʊʊ́-daá sɩsɩ: «Ceení gɛ mebiyaalʊ́ weení máábá mɔzɔ́ɔ́lɩ yɩ nɛ́. Ɩrɔ gɛ mááɖʊ́ mɛ́dɛ́ɛ sɔɔlɩ́m rɩ́ŋa. Ɩnɩɩná yɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wanbaaráa waanɩ́ɩ bɩlɛ́ nɛ́, nɩdáárɛ waabá bɩlá wɛ, ngɛ boovu bolóódi-rɔ babá bɛnyɛ́ adɛ. ");
INSERT INTO kdh_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Amá, Yeésu woogóduu bɔjɔ́ itekiná wɛ ɩtɔ́ wɛ sɩsɩ: «Ɩgʊrʊ́, nɩdáárɛ ɩ́kalá mɩ́ɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Baagʊ́sɩ ɩzá nɛ́, badana naárʊ, Yeésu riké gɛ baana. ");
INSERT INTO kdh_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Bɔwɛ béndím bʊ́ʊ nɛ́, ngɛ Yeésu waabásɩ wɛ sɩsɩ: «Íkefééri naárʊ wenbí bɩɩlɩzɩ́ bɩwɩ́lɩ mɩ́ɩ cé nɛ́, hálɩ Ɩrʊ́ Biyaalʊ́ ɩkɔ́nɩ ifé ɩlɩ́ɩ ɩsɩɖáa-daá.» ");
INSERT INTO kdh_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ńna gɛ wanbaaráa wɔɔbɔ́ɔ́zɩ Yeésu sɩsɩ: «We-rɔ gɛ Mará wɩlɩɖáa wánŋmatɩ́ sɩsɩ asée Elíya wɔ́ńgɔ́nɩ́ naanɩ́.» ");
INSERT INTO kdh_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Toovonúm, Elíya wɔ́ngɔnɩ́ na ɩnyɔ́ɔ́zɩ báa wenbí.» ");
INSERT INTO kdh_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Amá, ménveerím mɩ́ɩ sɩsɩ Elíya wɔ́ńgɔ́nɩ́. Badatɩlɩ́ yɩ, ngɛ baala ná yɩ wenbí bolowú fáa bɩ nɛ́. Bɩlɛ́ ɖʊɖɔ gɛ Ɩrʊ́ Biyaalʊ́ sɩ ɩna wahála bɔjɔ́. ");
INSERT INTO kdh_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ńna gɛ wanbaaráa waadɩlɩ́ sɩsɩ Yaayá-dɛ́ɛ tɔ́m gɛ wɔ́ndɔ́m. ");
INSERT INTO kdh_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yeésu na ɩwanbaaráa baadála zamɔ́ɔ-jɔ́ nɛ́, ngɛ ɩrʊ́ naárʊ wɔɔgɔ́nɩ ɩká ɩɖʊná Yeésu ɩzá-daá ɩtɔ́ yɩ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«Kʊ́bɔnɩ́, nɩɩ mebiyaalʊ́ kʊnyɔḿ, kazáladɛ́ɛ́dɩ wɛná yɩ wɛ́nÿɛlɛ́m páá. Wándárázálɩ́ɩ nimíni yáá lɩ́m-daá gɛ. ");
INSERT INTO kdh_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mɔ́ɔ́gɔ́ná yɩ nyɛ́dɛ́ɛ wanbaaráa-jɔ́, amá, badabɩ́ɩ́zɩ bawáázɩ yɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ńna gɛ Yeésu sɩsɩ: «Zaamáánɩ kɩna kɩdɛ́ɛ ɩráa badafa Ɩsɔ́ɔ toovonúm bɩka badaavé nɛ́! Wɛ́ nŋɩ́nɩ́ gɛ mógúti mɔjɔ́ɔ mɩ́jɔ́. Wɛ́ nŋɩ́nɩ́ gɛ mógúti mɔɖɔ́kɩ mɩ́ɩ. Ɩgɔná ma bú ɩmʊ́ cé.» ");
INSERT INTO kdh_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ngɛ Yeésu waagazɩ́ zííni kɩ́njaarɩ́ bú ɩmʊ́ nɛ́ kɩcáŋ kɩlɩ́ɩ ɩrɔ, bú ɩcáŋ ɩwáa ńna‑ńna. ");
INSERT INTO kdh_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ngɛ wanbaaráa woogóduu Yeésu-jɔ́ bɔbɔ́ɔ́zɩ yɩ bána yɩ beriké nɛ́ sɩsɩ: «Ngbaalá gɛ ɖɔ́ɔ́ ɖádabɩ́ɩ́zɩ ɖɩɖɔ́ɔ zííni kɩḿ.» ");
INSERT INTO kdh_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Káma, mɩ́dɛ́ɛ toovonúm fáa tɔɖɔ́ɔ. Ménveerím mɩ́ɩ toovonúm sɩsɩ a mɩ́dɛ́ɛ toovonúm fáa waadála báńŋɩ́náyɔ́ɔ bú, mɩ́ndɔ́m bʊ́ʊ kɩna sɩsɩ kpɛzɩ́ nyádɩ cé ngózuu lí. Bɩka bifu bɩlá bɩlɛ́. Nabʊ́rʊ fɛ́yɩ́ sɩsɩ mɩ́dánbɩɩzɩ ɩlá nɛ́.  ");
INSERT INTO kdh_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Amá, na sʊlʊ́ńdɩ na nɔɔ́ fɔkɩ́ gɛ bánbɩɩzɩ́ bɔɖɔɔná zííni ńŋɩnáa kɩna.» ");
INSERT INTO kdh_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Boduuzée Galilée ńna gɛ Yeésu weevééri wɛ sɩsɩ: «Bángbáa Ɩrʊ́ Biyaalʊ́ becéle ɩráa, ");
INSERT INTO kdh_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","bɛlɛ́ bángʊ́ʊ yɩ, amá, toozo wɩ́rɛ wénvém ɩlɩ́ɩ ɩsɩɖáa-daá.» Ńna gɛ wanbaaráa waabá basʊ́ʊ kaanɩŋá. ");
INSERT INTO kdh_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Baadála Kapɛrɩnawʊ́m nɛ́, ngɛ wenbá bɔ́nbɔɔzɩ́ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá lanpóo nɛ́, bɔɔgɔ́nɩ bɔbɔ́ɔ́zɩ Pétro sɩsɩ: «Mɩ́dɛ́ɛ kʊ́bɔnɩ́ wɛ́nvɛrɩ́ɩ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá lanpóo?» ");
INSERT INTO kdh_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ngɛ Pétro sɩsɩ: «Ɩɩ́n, wɛ́nvɛrɩ́ɩ.» Yeésu waadála ɖaána nɛ́, ngɛ wɛɛdɛ nɩ́bááwʊ ɩbɔ́ɔ́zɩ Pétro sɩsɩ: «Simɔ́ɔnɩ, sɩsɩ wé gɛ nyánmaazɩnáa tɔ́m tɩna: wenbá-jɔ́ gɛ adɛ laadɔ́ɔ-rɔ cé wúrowá wánmʊ́ʊ lanpóo. Tɛ́ɛ́dɩ-bíya yáá ɩgɔma-jɔ́.» ");
INSERT INTO kdh_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ngɛ woobúsi sɩsɩ ɩgɔma. Ngɛ Yeésu sɩsɩ: «Bɩlɛ́ nɛ́, bɩdɛkɛ́ɛ tɩ́lásɩ sɩsɩ tɛ́ɛ́dɩ bíya ɩfɛ́rɛ lanpóo. ");
INSERT INTO kdh_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Amá, na bɩ́kɔkɔ́nɩ bɩwɩ́ɩ́zɩ wɛ nɛ́, bo ngɔ́lɔ́ kolɔɔ́ lɩɩrɛ́ kʊ́bɔńɖɛ-daá. Fulú tińɖe kaɖaa ńɖɛ sɩ nbúu ɖɛ nɛ́ ɖɩnɔɔ́, nyánnáa liideé weená nɔ́ɔ́ bɩ́nbɔɔzɩ́ mána nya sɩ ɖɩfɛrɛ ná lanpóo nɛ́. Kpɔɔ yɛ nbó nvɛ́rɛ mána nya.» ");
INSERT INTO kdh_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Bɩdɛ́ɛ sáátɩ kɩḿ gɛ wanbaaráa woogóduu Yeésu-jɔ́ bɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Weení gɛ kʊ́bɔnɩ́ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-daá.» ");
INSERT INTO kdh_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ngɛ Yeésu waayáa bú naárʊ ɩkɔná yɩ bɔlɔwʊtáá ");
INSERT INTO kdh_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ɩtɔ́ wɛ sɩsɩ: «Ménveerím mɩ́ɩ toovonúm sɩsɩ a mɩ́dɛkɛ́ɛ ɩbɩ́sɩ nyazɩ bíya, mɩ́dánzʊʊ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-daá. ");
INSERT INTO kdh_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Bɩlɛ́ nɛ́, weení wánvʊʊzɩ́ ɩdɩ nyazɩ bú ceení nɛ́, wónÿuúu kʊ kʊ́bɔńdɩ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-daá. ");
INSERT INTO kdh_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Weení waamʊ bú ńŋɩnáa ceení ɩgɔ́ńdɩ mɔ́rɔ́ɔ́zɩ́ nɛ́, mádɩtɩŋa gɛ waamʊ.» ");
INSERT INTO kdh_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Weení rɩ́ŋa sɩ iyéle bíya bana baava ma toovonúm nɛ́ badaá naárʊ ɩlá alaháácɩ́ nɛ́, a baadaná bʊdʊ́ʊ lowú namɩ́rɛ kʊ́bɔńɖɛ bɔlɔ tenkú-daá, bɩjɔɔ́ɔ sóńcí. ");
INSERT INTO kdh_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Nbusú ɖamáa na nya ɖúúlínya, ńŋɩnáa nyénÿelíi ɩráa wánÿɩsɩnáa Ɩsɔ́ɔ nɛ́! Wenbí bínÿelíi na ɩrʊ́ ɩyɩ́sɩ nɛ́, tɛ́ndɛŋ́ kɛtɛngɛrɛ, amá, nbusú na weení wénÿelíi ɩrɔwʊ́ ɩyɩsɩná Ɩsɔ́ɔ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","A bɩgɛ́ɛ nyánʊ́ʊ́nɩ yáá nyɔ́nʊvɔ́rɛ wénÿelíi kʊ gɛ nyánÿɩsɩnáa Ɩsɔ́ɔ, cɛ ɖɛ nbɛ́ɖɩ bolíni; káma, bɩjɔɔ́ɔ sóńcí nzʊ́ʊ arɩjáńna-daá nʊ́ʊ́nɩ yáá nʊvɔ́rɛ kʊ́ɖʊńɖɛ fɛ́yɩ́, bɩkɩlɩ ná nyánʊ́ʊ́zɩ lɛ́ɛ́nɩ́, yáá nyɔ́nʊvɔ́ lɛ́ɛ́nɩ́ wɛ bɩka nzʊ́ʊ azáába nimíni ɩ́dánɖɩḿ kɛtɛngɛrɛ nɛ́ ɩdaá. ");
INSERT INTO kdh_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","A nyáázɩ́rɛ wénÿelíi kʊ gɛ nyánÿɩsɩnáa Ɩsɔ́ɔ, lɩzɩ́ ɖɛ nbɛ́ɖɩ bolíni; bɩjɔɔ́ɔ sóńcí nzʊ́ʊ arɩjáńna-daá na ɩzɩ́rɛ kʊ́ɖʊńɖɛ bɩkɩlɩ ná alɛ́ɛ́nɩ́ awɛ bɩka nzʊ́ʊ azáába nimíni ɩ́dánɖɩḿ kɛtɛngɛrɛ nɛ́ ɩdaá.» ");
INSERT INTO kdh_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Ɩlá laakáarɩ. Ɩ́kɛkpɛɛná bíya bɛḿ badaá naárʊ, káma, ménveerím mɩ́ɩ sɩsɩ báa sáátɩ wenkí bɛdɛ́ɛ malááyɩ́kawá sɩ́ŋɛ́ɛ Majaa weení ɩwɛ ɩsɔ́ɔ́dáá nɛ́ waazá-daá gɛ. ");
INSERT INTO kdh_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Káma, Ɩrʊ́ Biyaalʊ́ wɔɔgɔ́nɩ gɛ sɩ ɩlɛ́ɛ wenbá bɛɛdɛlɛ́ŋ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Mɩ́nmaazɩ́ sɩsɩ wé tɔ́m tɩna sɩ mɛgɛ́ɛ́zɩ mɩ́ɩ tɩ ɖɔ́ nɛ́ tɩrɔ. A bɩgɛ́ɛ sɩsɩ ɩrʊ́ wɛná fééni nɩɩ́nʊ́wá, ngɛ tɩdaá kʊ́ɖʊḿ wɛɛdɛlɛ́ŋ, ídénÿelí nɩɩ́nʊ́wá kʊ́ɖʊḿ fɛ́yɩ́ tɩna bʊ́ʊ-rɔ ɩɖɛ́ɛ ɩkájaa weení wɛɛdɛlɛ́ŋ nɛ́? ");
INSERT INTO kdh_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ménveerím mɩ́ɩ toovonúm sɩsɩ a bɩgɛ́ɛ waana yɩ, ɩdɛ́ɛ wenbi‑niíni fée kʊ́ɖʊḿ ɩmʊ́ ɩrɔ wángɩlɩ́ɩ nɩɩ́nʊ́wá kʊ́ɖʊḿ fɛ́yɩ́ tɩɩganáa rɩ́ŋa tɩdɛtɛlɛ́ŋ nɛ́-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Bɩlɛ́ ɖʊɖɔ gɛ Mɩ́jaa weení ɩwɛ ɩsɔ́ɔ́dáá nɛ́ tánjaa sɩsɩ bíya bɛḿ badaá báa kʊ́ɖʊḿ ɩtɛlɛ́ŋ.» ");
INSERT INTO kdh_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«A bɩgɛ́ɛ ngoobú waayɩsɩná nya, bo ɩjɔ́ nvééri yɩ ɩdɛ́ɛ yɩsɩ́tɩ nyána yɩ mɩ́lɛ́ɛ́nɩ́. A waanɩɩná nya itísi sɩsɩ waayɩ́sɩ, nyáábɩ́sɩ́ná yɩ Ɩsɔ́ɔ-dɛ́ɛ nɩ́bááwʊ-daá nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Amá, a ɩdanɩɩná nya, kpɔɔ ɩrʊ́ kʊ́ɖʊḿ yáá nɔɔ́lɛ ibó ɩna yɩ. Ńna nɛ́, nyóóyúú seríya-dɩnáa nɔɔ́lɛ yáá noódoozo ɩnyɔ́ɔ́zɩ tɔ́m ńŋɩnáa Ɩsɔ́ɔ-dɛ́ɛ tɔ́m waaŋmátɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","A weegízi ɩdanɩɩná wɛ, feeri Krísto-dɛ́ɛ Koduuziya. A bɩlɛ́ gɛ weegízi ɩdanɩɩná Krísto-dɛ́ɛ Koduuziya, ɩ́bɩsɩ nya nyazɩ weení waasɩ Ɩsɔ́ɔ nɛ́ yáá tikée mʊʊrʊ́. ");
INSERT INTO kdh_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ménveerím mɩ́ɩ toovonúm sɩsɩ wenbí rɩ́ŋa sɩ ɩfɔ́kɩ bɩ adɛ laadɔ́ɔ-rɔ cé nɛ́, bɔ́nvɔkɩ́ bɩ ɩsɔ́ɔ́dáá; wenbí rɩ́ŋa sɩ ibóɖi bɩ adɛ laadɔ́ɔ-rɔ cé nɛ́, bónboɖí bɩ ɩsɔ́ɔ́dáá. ");
INSERT INTO kdh_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ménveerím mɩ́ɩ toovonúm ɖʊɖɔ sɩsɩ adɛ laadɔ́ɔ-rɔ cé, a mɩ́dáá nɔɔ́lɛ waalá nɔɔ́ kʊ́ɖʊmɔ́ɔ, ngɛ bɔɔbɔ́ɔ́zɩ báa wenbí, Majaa weení ɩwɛ ɩsɔ́ɔ́dáá nɛ́ wánváa wɛ bɩ. ");
INSERT INTO kdh_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Káma, lénlé ɩráa nɔɔ́lɛ yáá noódoozo woodúúzi na máyɩ́ɖɛ-daá nɛ́, mɔ́wɛ bɔlɔwʊtáá.» ");
INSERT INTO kdh_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ngɛ Pétro woogóduu Yeésu-jɔ́ ɩbɔ́ɔ́zɩ yɩ sɩsɩ: «Kʊ́bɔnɩ́, a mogoobú wánÿɩsɩnáa ma, bʊrɔ nŋɩ́nɩ́ gɛ mɛ́njɛ́m yɩ. Hálɩ bʊrɔ lʊbɛ yáá wé.» ");
INSERT INTO kdh_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ngɛ Yeésu woobúsi yɩ sɩsɩ: «Mɔ́dɔ́tɔ́ nya sɩsɩ hálɩ bʊrɔ lʊbɛ, amá, hálɩ niídoozo na saaláa bʊrɔ lʊbɛ. ");
INSERT INTO kdh_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Bʊrɔɔzɩ́ gɛ bɛ́ngɛɛzɩnáa Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ nyazɩ wúro weení waayáa ɩdɛ́ɛ bɔwʊtá-dɩnáa sɩsɩ bɔ́kɔnɩ batɩ́ ɩmʊ́ kɩmɛ́ beeɖi ɩmʊ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Waabáázɩ nɛ́ gɛ bɔɔgɔná yɩ ɩrʊ́ naárʊ ɩlɛ́ ɩgɩmɛ́rɛ kɛ́ɛ liideé tuutúúma. ");
INSERT INTO kdh_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ɩvɛ́yɩ́na liideé sɩ ɩfɛ́rɛ kɩmɛ́rɛ nɛ́, ngɛ ɩdɛ́ɛ kʊ́bɔnɩ́ waava wɛ́ɖɛ sɩsɩ báya yɩ ɩ́na ɩɖɛɛlʊ́, na ibíya na wenbí bɩrɩ́ŋa bɔwɛná nɛ́ bɛfɛ́rɛ ɩgɩmɛ́rɛ. ");
INSERT INTO kdh_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ńna gɛ bɔwʊtá-dʊ́ʊ wɛɛjɛ́ ɩsála kʊ́bɔnɩ́ ɩzá-daá ɩɖʊná-rɔ wɔ́ndɔ́m yɩ sɩsɩ: “Ɖiná ma suúru, mɛ́nvɛrɩ́ɩ nya bɩrɩ́ŋa.” ");
INSERT INTO kdh_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Bɩɩlá ɩdɛ́ɛ kʊ́bɔnɩ́ kʊnyɔḿ, ngɛ wɛɛjɛ́ yɩ ɩgɩmɛ́rɛ iyéle yɩ ɩɖɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Bɔwʊtá-dʊ́ʊ ɩmʊ́ wánlɩɩ́ nɛ́, ngɛ waana ɩɖɔndɩnáa ɩ́na wɛ bánlám tɩmɛ́rɛ nɛ́ badaá naárʊ, ɩlɛ́ weeɖi yɩ kɩmɛ́rɛ liideé cʊ́kɔyɔ́ɔ. Ngɛ weegbí yɩ wánŋmɩrɩ́ɩ ilowú bɩka wɔ́ndɔ́m yɩ sɩsɩ: “Fɛrɛ ma mágɩmɛ́rɛ.” ");
INSERT INTO kdh_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ngɛ ɩɖɔndɩ wɛɛjɛ́ ɩsála ɩnʊvɔ́-dɛ wánvɩnɩ́ yɩ sɩsɩ: “Ɖiná ma suúru, mɛ́nvɛrɩ́ɩ nya.” ");
INSERT INTO kdh_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Amá, ɩlɛ́ weegízi. Wooboná yɩ gɛ bɔtɔ sáráka sɩsɩ asée wɛɛvɛ́rɛ ɩmʊ́ ɩgɩmɛ́rɛ. ");
INSERT INTO kdh_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ɩɖɔndɩnáa waana wenbí bɩɩlá nɛ́, bɛlɛ́ baabá basʊ́ʊ kaanɩŋá. Ngɛ boobó befééri bagʊ́bɔnɩ́ wenbí bɩrɩ́ŋa bɩɩlá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ńna gɛ ɩgʊ́bɔnɩ́ weeyéle bɔkɔná yɩ, ngɛ weevééri yɩ sɩsɩ: “Nyɛ́gɛ́ɛ bɔwʊtá-dʊ́ʊ kidaavéénúu; mɛ́ɛ́jɛ́ nya nyágɩmɛ́rɛ ɖɩna ɖɩrɩ́ŋa gɛ, káma, nyáávɩ́nɩ ma sɩsɩ mɛ́jɛ nya. ");
INSERT INTO kdh_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Bɩdɔbɔ́ɔ́zɩ sɩsɩ nyɔ́ɔ́ ɖʊɖɔ ńnɩ́ɩ nɖɔndɩ kʊnyɔḿ ńŋɩnáa máánɩ́ɩ nyágʊnyɔḿ nɛ́?” ");
INSERT INTO kdh_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ɩdɛ́ɛ kʊ́bɔnɩ́ waabá ɩyɛ́ɛ baaná. Ngɛ weeyéle boboná yɩ sáráka baɖʊ yɩ tɩmɛ́ ɖóni‑ɖóni ńná sɩsɩ hálɩ ɩfɛ́rɛ ɩgɩmɛ́rɛ rɩ́ŋa. ");
INSERT INTO kdh_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Bɩlɛ́ ɖʊɖɔ gɛ Majaa weení ɩwɛ ɩsɔ́ɔ́dáá nɛ́ sɩ ɩlá mɩ́dáá báa weení, a ɩ́dɛ́njɛḿ igoobú bɩtála iwenbiré-daá.» ");
INSERT INTO kdh_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yeésu wɛɛdɛ́ tɔ́mwá tɩḿ wɩlɩ́ɩ nɛ́, waalɩ́ɩ Galilée laadɔ́ɔ-daá ɩɖɛ́ɛ Yudée laadɔ́ɔ-daá na Yɔrɔdáanɩ buwá-dɛ́ɛ fúu lí ńgɩ. ");
INSERT INTO kdh_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Zamɔ́ɔ kʊ́bɔńgɩ woovu yɩ, ngɛ waawáázɩ wɛ ńna. ");
INSERT INTO kdh_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ńna gɛ Faríizi ńba woogóduu ɩjɔ́ sɩ bayɩ́ yɩ kɔdɔká, ngɛ bɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Ɖɛ́dɛ́ɛ Mará waava nɩ́bááwʊ sɩsɩ ɩrʊ́ ɩɖɔ́ɔ ɩɖɛɛlʊ́ báa we gɛ waalá nɛ́ bʊrɔ?» ");
INSERT INTO kdh_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yeésu woobúsi sɩsɩ: «Mɩ́dákála wentí baaŋmáa Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá nɛ́ gɛ? Baaŋmáa gɛ sɩsɩ bɩgabaazɩya, alʊ́ na abaalʊ́ gɛ Ɩsɔ́ɔ waalá wɛ. ");
INSERT INTO kdh_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ngɛ wɔɔdɔ́ sɩsɩ: “Bʊrɔɔzɩ́ gɛ abaalʊ́ wánlɩɩ́ ɩgɔɔ na ɩjaa bɛdɛ́ɛ ɩ́na ɩɖɛɛlʊ́ bɔcɔ́ɔ, na bɛlɛ́ɛ́nɩ́ babɩ́sɩ tɔnʊʊ́ kʊ́ɖʊmʊ́ʊ.” ");
INSERT INTO kdh_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ńna nɛ́, bodokúti bɛgɛ́ɛ nɔɔ́lɛ, amá, tɔnʊʊ́ kʊ́ɖʊmʊ́ʊ. Bɩlɛ́ nɛ́, ɩrʊ́ ɩkátara wenbí Ɩsɔ́ɔ waadá bɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ngɛ Faríizi ńba wɔbɔ́ɔ́zɩ Yeésu sɩsɩ: «A bɩlɛ́, wé-rɔɔzɩ́ gɛ Múúsá waazɩ́ɩ́zɩ sɩsɩ a ɩrʊ́ sɩ ikízi ɩɖɛɛlʊ́, asée weejéle yɩ wasɩ́ɩ́ka kɩ́nwɩlɩ́ɩ sɩsɩ weegízi yɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Mɩ́dɛ́ɛ wenbi-ɖóni-rɔ gɛ Múúsá waava mɩ́ɩ nɩ́bááwʊ sɩsɩ íkizi mɩ́dɛ́ɛ aláa. Amá, bɩgabaazɩya nɛ́ bɩdɛkɛ́ɛ bɩlɛ́ gɛ bɩvʊnwɛ. ");
INSERT INTO kdh_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ménveerím mɩ́ɩ toovonúm sɩsɩ a naárʊ wɔɔɖɔ́ɔ ɩɖɛɛlʊ́ bɩdɛkɛ́ɛ na sɩsɩ alʊ́ waalɩ́ɩ ɩwɔ́rɔ́, ngɛ wɔɔgbɔ́ɔ alʊ́ kɩ́falʊ́, ɩmʊ́ waalɩɩ ná ɩɖɛɛlʊ́ wɔ́rɔ́ bɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ńna gɛ Yeésu-dɛ́ɛ wanbaaráa wɔɔdɔ́ yɩ sɩsɩ: «A bɩlɛ́ gɛ bɩjɔɔ́ɔ ɩrʊ́ abaalʊ́ na ɩɖɛɛlʊ́ bɔlɔwʊtáá, a ɩrʊ́ tɔkpɔ́ɔ alʊ́, bɩjɔɔ́ɔ sóńcí nbɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Ɩráa rɩ́ŋa téndisi, asée wenbá Ɩsɔ́ɔ waava wɛ bɩdɛ́ɛ yíko nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ɩramáa nɛbɛ́rɛ wɛ bɔdɔkpɔ́ɔ aláa nɛ́, ɖoo balʊrʊ́ʊ wɩ́rɛ gɛ badafʊngɛ́ɛ abaaláa; nɛbɛ́rɛ nɛ́, ɩráa waala ná wɛ; nɛbɛ́rɛ nɛ́, Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-rɔ gɛ baabɩsɩná badɩ ɩramáa. Weení wéndisí tɔ́m mááŋmátɩ tɩ ɖɔ́ nɛ́, ɩlɛ́ ítísi.» ");
INSERT INTO kdh_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Bɩlɛ́ bʊwɔ́rɔ́ gɛ ɩráa wɔɔgɔná Yeésu bíya sɩsɩ ɩtɩ́nɩ nʊ́ʊ́zɩ bɔrɔ na ɩsʊ́lʊ bɔrɔ. Amá, Yeésu-dɛ́ɛ wanbaaráa wónÿoonáa wɛ. ");
INSERT INTO kdh_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ngɛ Yeésu wɔɔdɔ́ ɩwanbaaráa sɩsɩ: «Iyéle bíya ɩkɔ́nɩ mɔ́jɔ́. Ɩ́kɔtɔ wɛ nɩ́bááwʊ, káma, wenbá baalɩ́ɩ wɛ nɛ́ badɩɩná Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Waadɩ́nɩ nʊ́ʊ́zɩ bɔrɔ bɩtɛ́ nɛ́, ngɛ waalɩ́ɩ ɖɩdáarɛ ɖɩḿ ɖɩdaá. ");
INSERT INTO kdh_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Bɩlɛ́ bʊwɔ́rɔ́ gɛ abaalʊ́ naárʊ woogóduu ɩjɔ́ ɩtɔ́ yɩ sɩsɩ: «Kʊ́bɔnɩ́, kazɔ́ɔ ńbɩ wenbí gɛ bɩ́nbɔɔzɩ́ sɩsɩ mála na moyuú weezuú kɩ́dɛ́ndɛŋ́ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ngɛ Yeésu woobúsi yɩ sɩsɩ: «We-rɔ gɛ nyɔ́nbɔɔzɩ́ ma kazɔ́ɔ ńbɩ tɔ́m. Kʊ́ɖʊḿ kóŋ́ gɛ kazɔ́ɔ ńnɩ́. A nyɔ́zɔɔlɛ́ɛ nÿuú weezuú kɩ́dɛ́ndɛŋ́ nɛ́, la wenbí Mará wɔɔbɔ́ɔ́zɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ńna gɛ afobú ɩmʊ́ wɔɔbɔ́ɔ́zɩ Yeésu sɩsɩ: «Mará weená.» Ngɛ Yeésu woobúsi yɩ sɩsɩ: «Ńdángʊ́ʊ ɩrʊ́; ńdánlɩɩ nɖɛɛlʊ́ wɔ́rɔ́; ńdánŋmɩɩlɩ; ńdánlɩzɩ́ seríya tɩtɛ ńgɩ. ");
INSERT INTO kdh_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ɖʊ ngɔɔ na njaa gírímá na nzɔ́ɔ́lɩ nyɔ́rɔwʊ́ nyazɩ nyádɩtɩŋa.» ");
INSERT INTO kdh_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ńna gɛ afobú ɩmʊ́ sɩsɩ: «Máálá bɩlɛ́ ɩmʊ́ bɩrɩ́ŋa. Wé gɛ bɩɩga ma sɩ mádasɩ malá.» ");
INSERT INTO kdh_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ngɛ Yeésu sɩsɩ: «A nyɔ́zɔɔlɛ́ɛ nzɩ́ɩ́zɩ bɩrɩ́ŋa bɩdaá, bo nÿá wenbí bɩrɩ́ŋa nyɔ́wɛná nɛ́ nva kadanbʊrʊ́sɩ na nÿuú ɖɔ́ɔ́lɛ ɩsɔ́ɔ́dáá. A nyáálá bɩlɛ́ bɩtɛ́, na ngɔ́nɩ nvu ma.» ");
INSERT INTO kdh_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Afobú ceení waanɩ́ɩ bɩlɛ́ nɛ́, ngɛ waazʊ́ʊ kaanɩŋá ɩɖɛ́ɛ ɖɛfɛɛ, káma, ɩbá ɩgɛ́ɛ ɖɔ́ɔ́lɛ-dʊ́ʊ gɛ. ");
INSERT INTO kdh_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ngɛ Yeésu wɔɔdɔ́ ɩwanbaaráa sɩsɩ: «Ménveerím mɩ́ɩ toovonúm sɩsɩ bɩ́nlám káálɛ na ɖɔ́ɔ́lɛ-dʊ́ʊ iyuú Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Máádásɩ ménveerím mɩ́ɩ sɩsɩ bɩvɛ́yɩ́ raakúḿ káálɛ sɩsɩ kɩsʊʊ ná ɩjɔ́wʊ bɔyɔ́ɔ bɩtála ɖɔ́ɔ́lɛ-dʊ́ʊ ɩsʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-daá.» ");
INSERT INTO kdh_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wanbaaráa waanɩ́ɩ bɩlɛ́ nɛ́, ngɛ bɩɩbá bɩlá wɛ bítí bɔ́ndɔ́m sɩsɩ: «Bɩlɛ́ nɛ́, weení wónÿuúu kʊ lɛ́ɛ́dɩ Ɩsɔ́ɔ-jɔ́ bɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ngɛ Yeésu wɛɛbɛ́ɛ́ŋ wɛ ɩtɔ́ wɛ sɩsɩ: «Wenbí ɩráa tánbɩɩzɩ nɛ́, bɩvɛ́yɩ́ Ɩsɔ́ɔ káálɛ.» ");
INSERT INTO kdh_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ńna gɛ Pétro wɔɔdɔ́ Yeésu sɩsɩ: «Ɖɔ́ɔ́ ɖééyéle bɩrɩ́ŋa ɖufu nya nɛ́, nŋɩ́nɩ́ gɛ ɖɛ́ndɛnáa.» ");
INSERT INTO kdh_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ńna gɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Ménveerím mɩ́ɩ toovonúm sɩsɩ ɖúúlínya kɩ́falʊʊ́ Ɩsɔ́ɔ sɩ ɩlá kɩ nɛ́ kɩdaá, Ɩrʊ́ Biyaalʊ́ wɔ́njɔwʊ́ʊ ɩdɛ́ɛ ásícé kowuro-gbelé-daá nɛ́, mɩ́nyɔ́ɔ́ wenbá míívú ma nɛ́ ɖʊɖɔ mɩ́njɔwʊ́ʊ kowuro-gbelásɩ fuú na nasɩ́lɛ-daá ɩfʊʊná Israyɛ́ɛlɩ agó fuú na náálɛ. ");
INSERT INTO kdh_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ngɛ bɩlɛ́ gɛ weení ɩrɩ́ŋa weeyéle ɖɛ́ɛ́zɩ, koobíya aláa na abaaláa, kɔɔ́wʊ, caáwʊ, bíya yáá fásɩ máyɩ́ɖɛ-rɔ nɛ́, wóngoyuú bɩdɛ́ɛ nɩɩ́nʊ́wá na ɩtásɩ iyuú weezuú kɩ́dɛ́ndɛŋ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Amá, ɖabata wenbá lɛlɛɛɖɔ́ bɛdɛ́ɛ nɩ́bááwʊ nɛ́, bɔ́ngɔnɩ́ bekpííri; bɩka ɖabata wenbá beegbííri lɛlɛɛɖɔ́ nɛ́, ɩkɔ́nɩ bɛtɛ nɩ́bááwʊ.» ");
INSERT INTO kdh_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Ɩbɛ́ɛ wenbí bɛ́ngɛɛzɩnáa Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ nɛ́: Ɖaána-dʊ́ʊ naárʊ waalɩɩ ná tɛ́ɛrɛ́‑tɛ́ɛrɛ́ sɩ ɩcáa tɩmɛlanɖáa balá yɩ tɩmɛ́rɛ ɩdɛ́ɛ víinyi fɔɔ́-daá. ");
INSERT INTO kdh_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ɩ́na tɩmɛlanɖáa baaŋmátɩ bɩsáa sɩsɩ wɩ́rɛ, ɩmʊ́ wɛ́nvɛrɩ́ɩ báa weení wɩ́rɛ tɩmɛ́rɛ liideé. Ngɛ weeyéle bɛɖɛ́ɛ tɩmɛ́rɛ lám víinyi fɔɔ́-daá. ");
INSERT INTO kdh_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tɛ́ɛrɛ́ kéréfu kééníré waadálɩɩ nɛ́, ngɛ waana nɛbɛ́rɛ ɖʊɖɔ bazɩ́ŋɛ́ɛ wɔnɔɔ́-daá bádánlaḿ neɖére, ");
INSERT INTO kdh_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ngɛ wɔɔdɔ́ wɛ sɩsɩ: “Mɩ́nyɔ́ɔ́ ɖʊɖɔ ibó mɛ́dɛ́ɛ víinyi fɔɔ́-daá ɩkála tɩmɛ́rɛ. Mɛ́nvɛrɩ́ɩ mɩ́ɩ wenbí bɩ́nbɔɔzɩ́ nɛ́.” ");
INSERT INTO kdh_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ngɛ bɛlɛ́ bɛɛɖɛ́ɛ. Ɩdaawʊ́ na kéréfu natúdoozo ɖaanɩ́ŋa waadálɩɩ nɛ́, ngɛ waadálaḿ bɩlɛ́ nɔ́ɔ́. ");
INSERT INTO kdh_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ɖaanɩ́ŋa-rɔ kéréfu natʊ́nʊ́wá gɛ waadálɩɩ. Ngɛ wɔɔdɔ́mɔɔná tɩmɛlanɖáa nɛbɛ́rɛ kadɔ́ɔ-daá. Ngɛ wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: “We-rɔ gɛ ɖoo tɛ́ɛrɛ́ mɩ́zɩ́ŋɛ́ɛ ńna bɩka mɩ́dánlaḿ neɖére.” ");
INSERT INTO kdh_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ngɛ bɛlɛ́ boobúsi yɩ sɩsɩ: “Naárʊ tɔkpɔ́ɔ ɖáa sɩsɩ ɖíbo ɖɩlá yɩ tɩmɛ́rɛ.” Ngɛ wɔɔdɔ́ wɛ sɩsɩ: “Mɩ́nyɔ́ɔ́ ɖʊɖɔ ibó mɛ́dɛ́ɛ víinyi fɔɔ́-daá.” ");
INSERT INTO kdh_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ɖaanɩ́ŋa waalá nɛ́, ngɛ fɔɔ́-dʊ́ʊ waayáa ɩdɛ́ɛ tɩmɛ́ bɛɛŋɩrʊ́ ɩtɔ́ yɩ sɩsɩ: “Yaa tɩmɛlanɖáa bɩka njéle báa weení ɩdɛ́ɛ wɩ́rɛ tɩmɛ́rɛ liideé. Baazɩ ná wenbá biigbiiriná wɛ nɛ́, bɩka ndɛɛzɩ ná wenbá baaɖáa nɛ́.” ");
INSERT INTO kdh_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Wenbá baabáázɩ tɩmɛ́rɛ ɖaanɩ́ŋa kéréfu natʊ́nʊ́wá nɛ́ bɔɔgɔ́nɩ. Ngɛ baamʊ wɩ́rɛ tɩmɛ́rɛ liideé. ");
INSERT INTO kdh_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Bɩɩdála wenbá baaɖáa nɛ́, bɔjɔɔ́ɔ sɩsɩ bánmʊ́ʊ bɩcɛzɩ́ baaganáa, amá, bɛḿ ɖʊɖɔ baamʊ wɩ́rɛ tɩmɛ́rɛ liideé gɛ. ");
INSERT INTO kdh_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Baamʊ yɛ nɛ́, bánŋmɩɩdɩnáa ɖaána-dʊ́ʊ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Bana ɖɔ́ beegbííri bɔkɔ́nɩ nɛ́, áwa kʊ́ɖʊḿ gɛ baalá tɩmɛ́rɛ, ngɛ nyɛ́nvɛrɩ́ɩ ɖɔ́ɔ́ wenbá ɖáálá tɩmɛ́rɛ na fifíni wɩ́rɛ rɩ́ŋa nɛ́ ɖána wɛ ɖéyí‑ɖéyí?” ");
INSERT INTO kdh_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Amá, ɖaána-dʊ́ʊ woobúsi badaá kʊ́ɖʊḿ sɩsɩ: “Mɔɖɔndɩ, módomúúli nya! Ɖáávʊ́ńŋmátɩ bɩsáa sɩsɩ wɩ́rɛ tɩmɛ́rɛ liideé gɛ mɛ́nvɛrɩ́ɩ nya! ");
INSERT INTO kdh_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Mʊ nyɛ́dɛ́ɛ wɩ́rɛ tɩmɛ́rɛ liideé bɩka nɖɛ́ɛ. Mɛ́nvɛrɩ́ɩ nyána tɩmɛlanɖʊ́ méégbííri mɔgbɔ́ɔ yɩ nɛ́ ɖéyí‑ɖéyí. ");
INSERT INTO kdh_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Bɩdafa ma nɩ́bááwʊ sɩsɩ máláná mɛ́dɛ́ɛ ɖɔ́ɔ́lɛ wenbí mɔ́zɔɔlɛ́ɛ nɛ́? Yáá máálá waaganáa kazɔ́ɔ nɛ́ gɛ nyánlám sʊ́ʊ́zɩ.”» ");
INSERT INTO kdh_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ngɛ Yeésu waadásɩ ɩtɔ́ sɩsɩ: «Wenbá beegbííri nɛ́, bɔ́ngɔnɩ́ bɛtɛ nɩ́bááwʊ; bɩka wenbá bɛɛdɛ nɩ́bááwʊ nɛ́, bekpííri.» ");
INSERT INTO kdh_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yeésu wángbáa Yerusalɛ́ɛm nɛ́, ngɛ waalɩzɩ́ ɩwanbaaráa fuú na nɔɔ́lɛ fɔɔlʊʊ́ ɩ́na wɛ bánnʊŋɛ́ bɩka wénveerím wɛ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Iwélesi ma kazɔ́ɔ, ɖángbáa Yerusalɛ́ɛm. Bángbáa Ɩrʊ́ Biyaalʊ́ becéle sarásɩ lanɖáa kʊ́bɔnáa na Mará wɩlɩɖáa, na bakʊ ɩdɔ́m bɔtɔ́ sɩsɩ bákʊ́ yɩ; ");
INSERT INTO kdh_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","na bɔkpɔ́ɔ yɩ becéle wenbá baasɩ Ɩsɔ́ɔ nɛ́ sɩsɩ bámʊ́ŋ yɩ, bamá yɩ, baká yɩ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ. Amá, wɛ́ náádoozo wɩ́rɛ, ifé ɩlɩ́ɩ ɩsɩɖáa-daá.» ");
INSERT INTO kdh_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ńna gɛ Zebedée biyaalɩnáa ɩgɔɔ woogóduu Yeésu-jɔ́ ɩ́na ibíya. Ngɛ woozóm waazá-daá sɩ ɩbɔ́ɔ́zɩ yɩ nabʊ́rʊ. ");
INSERT INTO kdh_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ngɛ Yeésu wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Wé gɛ nyɔ́zɔɔlɛ́ɛ.» Ngɛ woobúsi yɩ sɩsɩ: «Mɔ́zɔɔlɛ́ɛ sɩsɩ nyɛ́dɛ́ɛ kowúrɔ́ɔ-daá, nÿéle mebiyaalɩnáa nɔɔ́lɛ bana badaá kʊ́ɖʊḿ ɩcɔ́ɔ nyánʊ́ʊ́nɩ kíɖiiwú-rɔ, waaganáa nyánʊ́ʊ́nɩ nɩbɩɩwʊ́-rɔ.» ");
INSERT INTO kdh_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yeésu woobúsi sɩsɩ: «Mɩ́ɩ́sɩ wenbí mɩ́nbɔɔzɩ́ nɛ́. Mɩ́nbɩɩzɩ́ ɩnyɔ́ɔ wahála kagbɔ́ɔ wenká sɩ mɔnyɔ́ɔ kɛ nɛ́?» Ngɛ boobúsi yɩ sɩsɩ: «Ɩɩ́n, ɖánbɩɩzɩ́.» ");
INSERT INTO kdh_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ngɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Mɩ́nnyɔɔ́ máwahála kagbɔ́ɔ, amá, a bɩɩga weení ɩcɔ́ɔ mánʊ́ʊ́nɩ kíɖiiwú yáá nɩbɩɩwʊ́-rɔ nɛ́, bɩdɛkɛ́ɛ mɔ́ɔ́ mánváa kʊ bɩlɛ́ bɩdɛ́ɛ adá. Wenbá Majaa waagbɩ́ɩ́rɩ yɛ ɩsɩ́ɩ nɛ́ gɛ sɩ bafa yɛ.» ");
INSERT INTO kdh_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wanbaaráa fuú baaganáa waanɩ́ɩ wentí nɔɔ́lɛ bana bɔ́nbɔɔzɩ́ nɛ́, ngɛ bɛɛyɛɛ ná wɛ baaná. ");
INSERT INTO kdh_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Amá, Yeésu waayáa wɛ ɩtɔ́ wɛ sɩsɩ: «Mɩ́nyɩ bɩlɛ́ sɩsɩ yíriwá-dɛ́ɛ wúrowá wánnaazɩ́ bɛdɛ́ɛ́dɩ-daá ɩráa gɛ na bɛdɛ́ɛ yíko bɩka kʊ́bɔnáa bɛlɛ́ bánwɩlɩ́ɩ wɛ boɖóni. ");
INSERT INTO kdh_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Amá, mɩ́nyɔ́ɔ́ nɛ́, bɩdɔbɔ́ɔ́zɩ bɩlɛ́ mɩ́lɔ́wʊ́táá. Hálɩ a bɩgɛ́ɛ sɩsɩ mɩ́dáá naárʊ sɔɔlɛ́ɛ ɩbɩ́sɩ kʊ́bɔnɩ́ mɩ́lɔ́wʊ́táá, ɩ́bɩsɩ mɩ́dɛ́ɛ bɔwʊtá-dʊ́ʊ, ");
INSERT INTO kdh_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","bɩka a mɩ́dáá naárʊ sɔɔlɛ́ɛ ɩbɩ́sɩ kaɖaa ńnɩ́, ɩ́bɩsɩ mɩ́dɛ́ɛ yoḿ. ");
INSERT INTO kdh_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Bɩlɛ́ gɛ Ɩrʊ́ Biyaalʊ́ tɔkɔ́nɩ sɩsɩ balá yɩ bɔwʊtá. Amá, wɔɔgɔ́nɩ gɛ sɩ ɩlá ɩráa bɔwʊtá bɩka ɩkpɔ́ɔ iweezuú ɩfɛrɛ ná ɩráa zamɔ́ɔ-dɛ́ɛ kɩmɛ́rɛ na boyuú lɛ́ɛ́dɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Baalɩ́ɩ Yerikóo tɛ́ɛ́dɩ-daá nɛ́, zamɔ́ɔ kʊ́bɔńgɩ woovu Yeésu. ");
INSERT INTO kdh_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Njɛma nɔɔ́lɛ cɔɔ́ɔ nɩ́bááwʊ-jɔ́ gɛ baanɩ́ɩ sɩsɩ Yeésu wɛ́nɖɛɛ kʊ nɛ́, ngɛ baabáázɩ agogo sɩsɩ: «Kʊ́bɔnɩ́, Ɖáwʊɖa Biyaalʊ́, nɩɩ ɖágʊnyɔḿ.» ");
INSERT INTO kdh_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ngɛ zamɔ́ɔ wɔ́nɖɔwʊ́ʊ wɛ sɩsɩ bósu tɔ́m. Amá, bɩdɛ́ɛ sáátɩ gɛ bɛlɛ́ baabá bóngoó bínjaarɩ́ sɩsɩ: «Kʊ́bɔnɩ́, Wúro Ɖáwʊɖa Biyaalʊ́, nɩɩ ɖágʊnyɔḿ!» ");
INSERT INTO kdh_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ńna gɛ Yeésu waazɩ́ŋ, ɩyáa wɛ, ɩtɔ́ wɛ sɩsɩ: «Wé gɛ mɩ́zɔɔlɛ́ɛ sɩsɩ mála mɩ́ɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ngɛ bɔɔdɔ́ yɩ sɩsɩ: «Ɖádʊ́ʊ, ɖɔ́zɔɔlɛ́ɛ ɖáázá ifulú.» ");
INSERT INTO kdh_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Bɩɩlá Yeésu kʊnyɔḿ nɛ́, ngɛ weedekiná baazá. Ńna‑ńna gɛ baabáázɩ náa; ngɛ baagʊrʊ́ bofu yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Sáátɩ wenkí baajʊʊná Yerusalɛ́ɛm sɩ batála Bɛtɩfagée tɛɛbiiyá Olivíyée tɩ́ɩ́nɩ bʊ́ʊ fáráńdɩ́ nɛ́, ngɛ Yeésu weedíri ɩwanbaaráa nɔɔ́lɛ, ");
INSERT INTO kdh_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ifééri wɛ sɩsɩ: «Ibó tɛɛbiiyá kɔwɛ mɩ́ɩ́zá-daá nɛ́ kadaá; mɩ́nnáa baaɖɩ kpangbɔ́ɔ alʊ́ na kobú; ibóɖi sɩ ɩkɔná ma. ");
INSERT INTO kdh_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","A naárʊ waaŋmátɩ mɩ́ɩ natɩ́rɩ, ibúsi yɩ sɩsɩ: “Ɖádʊ́ʊ sɔɔlɛ́ɛ sɩ.” Bánjáŋ beyéle ɩkɛ́ɖɛɛná sɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Bɩɩlá bɩlɛ́ gɛ na wentí anɖébi waaŋmátɩ nɛ́ ikóódi; tɩlɛ́ gɛ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Ivééri Siyɔ́ɔnɩ aléeré sɩsɩ: Bɛɛ́ɛ, nyɛ́dɛ́ɛ wúro kɛgɛrɛŋɛ nyɔ́jɔ́. Ɩjɔɔ́ɔ ɖɔyɔɔyɔɔ bɩka ɩgɔjɔɔ́ɔ na kpangbɔ́ɔ alʊ́ na kobú; fʊ́ńdɩ kpɩ́nɖɛ bɔ́njɔwʊ́ʊ ɖɛ nɛ́ ɖibú.» ");
INSERT INTO kdh_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ngɛ wanbaaráa woobó bakála wenbí nɔ́ɔ́ Yeésu waaŋmátɩ wɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bɔɔgɔ́gɔ́ná kpangbɔ́ɔ na kobú; ngɛ baalɩzɩ́ bɛdɛ́ɛ kúsúúdi batɩ́nɩ sɩrɔ Yeésu ɩkpa ɩcɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ngɛ ɩráa ɖabata bɔwɛ zamɔ́ɔ-daá nɛ́, bɔɔvɔ bogúsúúdi nɩ́bááwʊ-rɔ; nɛbɛ́rɛ waajáa cɔ́kɔ́ bɔlɔ nɩ́bááwʊ-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Wenbá bɔwɛ waazá-daá na wenbá bɔwɛ ɩwɔ́rɔ́ nɛ́, bóngoó sɩsɩ: «Sám mɔɔ́na kʊ Ɖáwʊɖa Biyaalʊ́! Ɩsɔ́ɔ ɩ́ɖʊ́ weení ɩgɛrɛŋɛ na Ɖádʊ́ʊ-dɛ́ɛ yɩ́ɖɛ-daá nɛ́ alɩbáráka! Bása Ɩsɔ́ɔ ɩsɔ́ɔ́dáá bílí‑bílí.» ");
INSERT INTO kdh_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yeésu waazʊ́ʊ Yerusalɛ́ɛm tɛ́ɛ́dɩ-daá nɛ́, ngɛ tɛ́ɛ́dɩ-daá rɩ́ŋa woodulú bɩka ɩráa wɔ́nbɔɔzɩ́ sɩsɩ: «Weení gɛ ɩrʊ́ ceení.» ");
INSERT INTO kdh_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ngɛ zamɔ́ɔ woobúsi sɩsɩ: «Anɖébi Yeésu, Nazarɛ́ɛtɩ tɛ́ɛ́dɩ tɩwɛ Galilée laadɔ́ɔ-daá nɛ́ ńnɩ́ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Bɩlɛ́ bʊwɔ́rɔ́ gɛ Yeésu waazʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá ɩɖɔ́ɔ wenbá barɩ́ŋa bánÿám yáá bánmʊ́ʊ kpɩná ńna nɛ́. Wɛɛvɛdɩ́ liide-gɛɛráa-dɛ́ɛ tébíriwá na avówa kʊ́fʊlʊmá yamɖáa-dɛ́ɛ kpelásɩ. ");
INSERT INTO kdh_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ngɛ wɔɔdɔ́ wɛ sɩsɩ: «Baaŋmáa Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá sɩsɩ: “Sɩ bayáa máɖaána gɛ sɩsɩ Ɩsɔ́ɔ sɛ́ɛ́dɩ ɖaána,” amá, mɩ́nyɔ́ɔ́ mɩ́ɩ́bɩ́sɩ́ná kɛ ŋmɩɩláa ɖaána.» ");
INSERT INTO kdh_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ngɛ njɛma na nʊvɔ́-dɩnáa woogóduu Yeésu-jɔ́ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá, ngɛ waawáázɩ wɛ. ");
INSERT INTO kdh_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa na Mará wɩlɩɖáa baana bítí-tɩmɛ́ Yeésu waalá nɛ́, na nŋɩ́nɩ́ bíya wóngoó sɩsɩ: «Sám mɔɔ́na kʊ Wúro Ɖáwʊɖa Biyaalʊ́,» Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá nɛ́, ngɛ bɛɛyɛ́ɛ baaná. ");
INSERT INTO kdh_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ńna gɛ bɔɔdɔ́ Yeésu sɩsɩ: «Nyáánɩ́ɩ wentí bánŋmatɩ́ nɛ́?» Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Ɩɩ́n, kɛtɛngɛrɛ mɩ́dákala tá wentí baaŋmáa Ɩsɔ́ɔ tɔ́m tákaraɖá-daá sɩsɩ: “Nyáálá hálɩ bɩkpɛdɩ́na bíya kúmuúsi na áfʊlʊmáa wánzám nya” nɛ́?» ");
INSERT INTO kdh_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ngɛ Yeésu waalɩ́ɩ tɛ́ɛ́dɩ-daá iyéle wɛ ńna ɩɖɛ́ɛ Betáániya ikóɖóo. ");
INSERT INTO kdh_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kiivé tɛ́ɛrɛ́ waalɩ́ɩ wángabɩsɩ́ tɛ́ɛ́dɩ-daá nɛ́, ngɛ nyɔɔ́sɩ waalá yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Waana figíyée tɩɩwʊ́ nakɩ́rɩ nɩ́bááwʊ-jɔ́ nɛ́, ngɛ woodúu kɩjɔ́, amá, idoyuú nabʊ́rʊ, asée fáádɩ riké. Ńna gɛ wɔɔdɔ́ kɩ sɩsɩ: «Kɛtɛngɛrɛ ńdándaɖʊ́ʊ bíya ɖʊɖɔ.» Ńna‑ńna gɛ figíyée tɩɩwʊ́ waawɩ́lɩ. ");
INSERT INTO kdh_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Yeésu-dɛ́ɛ wanbaaráa waana bɩlɛ́ nɛ́, ngɛ bɩɩlá wɛ bítí bɔ́ndɔ́m sɩsɩ: «Nŋɩ́nɩ́ gɛ bɩɩlá gɛ ńna‑ńna kɩḿ, tɩɩwʊ́ waajáŋ kɩwɩ́lɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Ménveerím mɩ́ɩ toovonúm sɩsɩ a mɩ́ɩ́vá toovonúm bɩka mɩ́dálá síka, bɩdɛkɛ́ɛ wenbí máálá figíyée tɩɩwʊ́ nɛ́ biriké gɛ sɩ ɩlá, amá, báa mɩ́ɩ́dɔ́ bʊ́ʊ kɩna sɩsɩ: “Kpɛzɩ́ nyádɩ ńna nzála tenkú-daá,” bɩ́nlám bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Wenbí bɩrɩ́ŋa sɩ ɩbɔ́ɔ́zɩ sʊlʊ́ńdɩ-daá na toovonúm fáa nɛ́, mínÿuúu bɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yeésu waazʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá nɛ́, Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa na Yahúúɖuwá-dɛ́ɛ kʊ́bɔnáa woogóduu ɩjɔ́ sáátɩ wenkí wánwɩlɩ́ɩ nɛ́ bɔtɔ́ yɩ sɩsɩ: «Na yíko wenkí gɛ nyánlanáa tɩmɛ́ ana. Ngɛ weení waava ná nya yíko kɩḿ.» ");
INSERT INTO kdh_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Mɔ́ɔ́ ɖʊɖɔ mɔ́nbɔɔzɩ́ mɩ́ɩ tɔ́m kʊ́ɖʊńtɩ kóŋ́; a mííbúsi ma tɩ, mɔ́ɔ́ ɖʊɖɔ ménveerím mɩ́ɩ weení waava ma bɩdɛ́ɛ yíko nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Weení weegédíri ná Yaayá ɩkɔ́nɩ ilíri ɩráa lɩ́m-daá ɩsɔ wɛ túúbá lɩ́m. Ɩsɔ́ɔ yáá ɩráa.» Ngɛ baala ná ɖamá sááwʊ́ra bɔtɔ́ ɖamá sɩsɩ: «A ɖɔ́ɔ́dɔ́ sɩsɩ Ɩsɔ́ɔ, wɔ́ndɔ́m ɖáa sɩsɩ: “Ngbaalá mɩ́dálá yɩ yaraɖá.” ");
INSERT INTO kdh_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","A ngʊ́ ɖɔ́ɔ́dɔ́ sɩsɩ ɩráa, zamɔ́ɔ ténÿelí ɖáa, káma, barɩ́ŋa beeɖéézi sɩsɩ Yaayá kɛ́ɛ anɖébi gɛ.» ");
INSERT INTO kdh_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ngɛ boobúsi Yeésu sɩsɩ: «Ɖádátɩ́lɩ́ weení weegédíri yɩ nɛ́.» Ńna gɛ Yeésu ɖʊɖɔ wɔɔdɔ wɛ sɩsɩ: «Mɔ́ɔ́ ɖʊɖɔ médénveeri mɩ́ɩ yíko wenkí mánlanáa tɩmɛ́ ana nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","«Mɩ́nmaazɩ́ sɩsɩ wé, tɔ́m tɩna tɩrɔ. Ɩrʊ́ naárʊ wɛná na bíya abaaláa nɔɔ́lɛ. Woogóduu kaɖaa ńnɩ́-jɔ́ nɛ́, ngɛ wɔɔdɔ́ yɩ sɩsɩ: “Mebiyaalʊ́, sinje bo víinyi fɔɔ́-daá ngála tɩmɛ́rɛ.” ");
INSERT INTO kdh_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ɩlɛ́ woobúsi yɩ sɩsɩ: “Módónbolí.” Bʊwɔ́rɔ́ nɛ́, ngɛ waalá mányɩ lé ɩkʊrʊ́ ɩɖɛ́ɛ fɔɔ́. ");
INSERT INTO kdh_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Caáwʊ woogóduu sɩɩlɛ ńnɩ́-jɔ́ nɛ́, ngɛ wɔɔdɔ́ yɩ tɔ́m kʊ́ɖʊńtɩ tɩḿ nɔ́ɔ́. Ngɛ ɩlɛ́ woobúsi yɩ sɩsɩ: “Mónboɖé, baabá,” amá, idobó. ");
INSERT INTO kdh_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Bɛlɛ́ɛ́nɩ́ bɔlɔwʊtáá, weení waala ná bajaa-dɛ́ɛ sɔɔlɩ́m.» Ngɛ boobúsi sɩsɩ kaɖaa ńnɩ́. Ńna gɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Ménveerím mɩ́ɩ toovonúm sɩsɩ tikée mʊʊráa na wásangarɩ́wá wɛ́ndɛ́ɛ mɩ́ɩ nɩ́bááwʊ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-daá. ");
INSERT INTO kdh_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Káma, Yaayá wɔɔgɔ́nɩ ɩwɩ́lɩ mɩ́ɩ nɩ́bááwʊ toovonúm ńgɩ, amá, mɩ́dálá yɩ yaraɖá. Amá, tikée mʊʊráa na wásangarɩ́wá waalá yɩ yaraɖá. Mɩ́nyɔ́ɔ́ nɛ́, na bɩrɩ́ŋa mɩ́ɩ́ná bɩlɛ́ nɛ́, mɩ́dálá túúbá ɩlá yɩ yaraɖá.» ");
INSERT INTO kdh_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«Iwélesi tɔmgɛɛzɩrɛ neɖére ɖʊɖɔ. Fɔɔ́-dʊ́ʊ naárʊ wooɖuu ná víinyi tiyísi, ngɛ waalá kárɔɔ́ ɩmɩlɩná ɩvɔɔ́, ɩbáa lénlé bánnyaazɩ́ víinyi bíya nɛ́, ɩma lénlé fereɖáa wɔ́njɔwʊ́ʊ na befére nɛ́, buwóro. Ngɛ wɔɔgbɔ́ɔ fɔɔ́ kɛḿ icéle wenbá bánvarɩ́m víinyi nɛ́ bɩka ɩɖɛ́ɛ nɩ́bááwʊ. ");
INSERT INTO kdh_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Víinyi bíya kɔrɩ́ɩ-dɛ́ɛ sáátɩ waadála nɛ́, ngɛ weedíri ɩdɛ́ɛ bɔwʊtá-dɩnáa wenbá bánvarɩ́m víinyi nɛ́ bɔjɔ́ sɩsɩ bóbo bakámʊ́ ɩmʊ́ ɩdɛ́ɛ ńbɩ bɔkɔ́gɔ́ná ɩmʊ́. ");
INSERT INTO kdh_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Amá, wenbá bánvarɩ́m víinyi nɛ́, beegbí ɩdɛ́ɛ bɔwʊtá-dɩnáa; baabá bamá kʊ́ɖʊḿ, ngɛ baagʊ naárʊ, bɩka bɔyɔ́ɔ naárʊ bɔ́ ɩsɩ́. ");
INSERT INTO kdh_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ngɛ fɔɔ́-dʊ́ʊ weedétirí bɔwʊtá-dɩnáa nɛbɛ́rɛ. Bɛlɛ́ bɔɔɖɔ́ɔ bɛcɛzɩ́ kaɖaa ńba. Wenbí nɔ́ɔ́ baalá kaɖaa ńba nɛ́ gɛ baadálaḿ wɛ. ");
INSERT INTO kdh_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kegbiirinɔ́ɔ-dɛ́ɛ nɛ́, fɔɔ́-dʊ́ʊ weedíri ibiyaalʊ́. Ilomaazɛ́-daá sɩsɩ: “Bánɖʊ́ʊ mebiyaalʊ́ gírímá.” ");
INSERT INTO kdh_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Amá, wenbá bánvarɩ́m víinyi nɛ́, baana biyaalʊ́ʊ nɛ́, ngɛ bɔɔdɔ́ ɖamá sɩsɩ: “Tííbí-dʊ́ʊ nbɩlɛ́! Ɩgɔ́nɩ! Ɖɩ́kʊ́ yɩ bɩka ɖɩkpɔ́ɔ tííbí.” ");
INSERT INTO kdh_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ngɛ beegbí yɩ balɩɩná víinyi fɔɔ́ wɔ́rɔ́ bakágʊ́. ");
INSERT INTO kdh_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Bɩlɛ́ nɛ́, a víinyi fɔɔ́-dʊ́ʊ wɔɔgɔ́nɩ, nŋɩ́nɩ́ gɛ wánlám wenbá bánvarɩ́m víinyi nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ngɛ boobúsi yɩ sɩsɩ: «Wénÿelíi bakʊ kánnyáázɩ sɩḿ; ɩ́dánnɩɩ bagʊnyɔḿ, na ɩkpɔ́ɔ víinyi fɔɔ́ icéle kɩ́faláa. Na a víinyi bíya kɔrɩ́ɩ waadála, bɛlɛ́ bɔkɔ́gɔ́ná ɩdɛ́ɛ ńbɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ńna gɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Kɛtɛngɛrɛ mɩ́dákala tá tɔ́m tɩna baaŋmáa Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá nɛ́ gɛ? Tɩlɛ́ gɛ sɩsɩ: “Bʊ́ʊ́rɛ wenɖé maaráa weegízi ɖɛ nɛ́, ɖɩɩbɩsɩ ná cʊnbʊʊrɛ-daá bʊ́ʊ́rɛ Ɖádʊ́ʊ Ɩsɔ́ɔ waala ná bɩlɛ́. Mááɖé kʊ́bɔńgɩ gɛ bɩgɛ́ɛ ɖáa.” ");
INSERT INTO kdh_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ménveerím mɩ́ɩ sɩsɩ bʊrɔɔzɩ́, bɛ́nlɛɛ́ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ mɩ́jɔ́ becéle yíri nakɩ́rɩ wenkí kɩ́nlám lakásɩ kazɔ́ɔ ńzɩ nɛ́.  ");
INSERT INTO kdh_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Weení ɩrɩ́ŋa sɩ ɩsála bʊ́ʊ́rɛ ɖɩḿ ɖɩrɔ nɛ́, wánbʊʊ́rɩ, a ngʊ́ ɖɩɩzála weení-rɔ nɛ́, ɖɩ́nnaḿ yɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa na Faríizi ńba baanɩ́ɩ tɔ́mwá Yeésu wɛɛgɛ́ɛ́zɩ nɛ́, baadɩlɩ́ sɩsɩ bɔdɔ́m gɛ wánŋmatɩ́. ");
INSERT INTO kdh_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Baajáa sɩ bakpa yɩ, amá, baanɩ́ɩ zamɔ́ɔ-dɛ́ɛ nɩdáárɛ, káma, zamɔ́ɔ ɖɔ́kɩná sɩsɩ Yeésu kɛ́ɛ anɖébi gɛ. ");
INSERT INTO kdh_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ngɛ Yeésu waadáŋmatɩ wɛ na tɔmgɛɛzɩrɛ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Wenbí bɛ́ngɛɛzɩnáa Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ nɛ́ nɖɔ́: Wúro naárʊ waayaa ná ɖíína ibiyaalʊ́-dɛ́ɛ hiije-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ngɛ weedíri ɩdɛ́ɛ bɔwʊtá-dɩnáa sɩsɩ bóbo bakáyáa wenbá bayáa wɛ ɖíína nɛ́. Amá, bɛlɛ́ beegízi kɔnɖɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ngɛ weedétirí bɔwʊtá-dɩnáa kɩ́faláa sɩsɩ bóbo befééri wenbá baayáa wɛ nɛ́ sɩsɩ waagbɩ́ɩ́rɩ kíɖíím, ɩkʊ ɩdɛ́ɛ náánɩ abaaláa na ɩvʊ́ńdɩ kpɩná ajɔɔ́ɔ núm nɛ́. Bɩrɩ́ŋa biizúluki, bɩlɛ́ nɛ́, bɔ́kɔnɩ hiije-dɛ́ɛ ɖíína. ");
INSERT INTO kdh_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Amá, bɛlɛ́ badatáńbɩsɩná laakáarɩ. Báa weení wɛɛɖɛ́ɛ gɛ ɩnɩɩná ɩdɩ. Nɛbɛ́rɛ wɛɛɖɛ́ɛ bɔvɔɔ́-daá, nɛbɛ́rɛ ɩɖɛ́ɛ bɛdɛ́ɛ kɩyakʊ. ");
INSERT INTO kdh_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Nɛbɛ́rɛ bɛlɛ́ beegbí bɔwʊtá-dɩnáa banáázɩ wɛ bɩka bakʊ wɛ. ");
INSERT INTO kdh_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Wúro wɛɛyɛ́ɛ baaná, ngɛ weedíri ɩdɛ́ɛ sɔ́ɔ́jawá bakágʊ́ ɩráńgʊ́ʊ́ráa bɛḿ, bɩka beɖéézi bɛdɛ́ɛ tɛ́ɛ́dɩ nimíni. ");
INSERT INTO kdh_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ngɛ wɔɔdɔ́ ɩdɛ́ɛ bɔwʊtá-dɩnáa sɩsɩ: “Hiije-dɛ́ɛ ɖíína waagbɩ́ɩ́rɩ, amá, wenbá baayáa wɛ ɖíi nɛ́, badatála beɖi kɩ. ");
INSERT INTO kdh_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Bɩlɛ́ nɛ́, ibó nɩ́baadará ɩkáyaa wenbá barɩ́ŋa sɩ ɩna wɛ nɛ́ sɩsɩ bɔ́kɔnɩ beɖi hiije-dɛ́ɛ ɖíína.” ");
INSERT INTO kdh_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ngɛ ɩdɛ́ɛ bɔwʊtá-dɩnáa waalɩ́ɩ nɩ́báánɩ-daá botúúzi wenbá barɩ́ŋa baana nɛ́, kazɔ́ɔ ńba na badaavé nɛ́. Ngɛ ɩráa woozu hiije ɖaána-daá. ");
INSERT INTO kdh_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Wúro waagázʊʊ sɩ ɩbɛ́ɛ́ŋ wenbá baagáyáa wɛ nɛ́, ngɛ waana ɩrʊ́ naárʊ badaá; ɩlɛ́ idosúu hiije tóko. ");
INSERT INTO kdh_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ngɛ wɔɔdɔ́ yɩ sɩsɩ: “Mɔɖɔndɩ, nŋɩ́nɩ́ gɛ nyáálá ngázʊʊ cé bɩka nyɛ́vɛ́yɩ́na hiije tóko.” Ɩrʊ́ ceení tana kʊ́tɔḿtɩ. ");
INSERT INTO kdh_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ngɛ wúro wɔɔdɔ́ ɩdɛ́ɛ bɔwʊtá-dɩnáa sɩsɩ: “Ɩvɔ́kɩ ɩnʊ́ʊ́zɩ na ɩnʊvɔ́ ɩkpɔ́ɔ yɩ ɩlɔ temenuú-daá asʊ. Ńna gɛ wénwií ɩlá mányɩ lé.” ");
INSERT INTO kdh_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Toovonúm, ɩráa ɖabata gɛ baayáa, amá, cʊ́kɔ gɛ sɩ balɩzɩ́.» ");
INSERT INTO kdh_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ńna gɛ Faríizi ńba woobó bakála sááwʊ́ra nŋɩ́nɩ́ bayɩ́ Yeésu nɔɔ́-jɔ́ na ɩŋmátɩ na bobúu yɩ kɔdɔká nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ngɛ beedíri bɛdɛ́ɛ wanbaaráa na Eróodi-dɛ́ɛ bɔwʊ́ɖɛ-daá ɩráa sɩsɩ bóbo befééri Yeésu sɩsɩ: «Kʊ́bɔnɩ́, ɖányɩ sɩsɩ toovonúm gɛ nyánŋmatɩ́, bɩka nyánwɩlɩ́ɩ Ɩsɔ́ɔ-dɛ́ɛ nɩ́bááwʊ na toovonúm; ngʊ́ bɩlɛ́ gɛ ńdánnɩɩ naárʊ nɩdáárɛ, bɩka ńdɛ́nbɛɛŋná ɩrʊ́ ɩzá-daá na nŋmátɩ. ");
INSERT INTO kdh_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Bɩlɛ́ nɛ́, feeri ɖáa wentí nyánmaazɩ́ tɔ́m tɩna tɩrɔ nɛ́: Bɩɩva nɩ́bááwʊ yáá bɩdafa sɩsɩ ɖɩ́fɛrɛ Róóma wúro kʊ́bɔnɩ́ lanpóo.» ");
INSERT INTO kdh_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Amá, Yeésu nyɩ bɛdɛ́ɛ lɔ́nɩ-rɔ nɛ́, ngɛ sɩsɩ: «Munáávikíwá bana! We-rɔ gɛ mɩ́nÿɩ́m ma kɔdɔká. ");
INSERT INTO kdh_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ɩwɩ́lɩ ma liideé mɩ́nvɛrɛnáa lanpóo nɛ́.» Ngɛ baawɩ́lɩ yɩ liideé jɩtɔ́ɔ kʊ́ɖʊmʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ngɛ Yeésu wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «Weení kʊjʊʊ́ na ɩyɩ́ɖɛ gɛ kɩrɔ.» ");
INSERT INTO kdh_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ngɛ boobúsi yɩ sɩsɩ: «Róóma wúro kʊ́bɔnɩ́ gɛ.» Ńna gɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Ijéle Róóma wúro kʊ́bɔnɩ́ wenbí bɩgɛ́ɛ Róóma wúro kʊ́bɔnɩ́-dɛ́ɛ ńbɩ nɛ́, bɩka icéle Ɩsɔ́ɔ wenbí bɩgɛ́ɛ Ɩsɔ́ɔ-dɛ́ɛ ńbɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yeésu wɔɔdɔ́ bɩlɛ́ nɛ́, ngɛ bɩɩbá bɩlá wɛ bítí bɛɖɛ́ɛ beyéle yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Bɩdɛ́ɛ wɩ́rɛ ɖɩḿ, Sadusée ńba wenbá bɔ́ndɔ́m sɩsɩ ɩsɩɖáa ténveḿ nɛ́, boogóduu Yeésu-jɔ́ bɔbɔ́ɔ́zɩ yɩ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Kʊ́bɔnɩ́, Múúsá wɔɔdɔ́ sɩsɩ a ɩrʊ́ abaalʊ́ talʊ́rʊ gɛ waazɩ́, igoobú wɔ́ngbɔwʊ́ʊ leelú na ɩlʊ́rʊ bíya babɩ́sɩ koobúu weení waazɩ́ nɛ́ ɩdɛ́ɛ bíya. ");
INSERT INTO kdh_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ngʊ́ ɖɔ́ɔ́ ɖɛ́dɛ́ɛ, koobíya lʊbɛ wɛ ná. Kaɖaa ńnɩ́ weení wɔɔgbɔ́ɔ alʊ́ nɛ́ waazɩ́; ńŋɩnáa ɩdalʊ́rʊ nɛ́, inewú waavʊ́ leelú. ");
INSERT INTO kdh_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Bɩlɛ́ gɛ bɩɩla ná sɩɩlɛ ńnɩ́ na toozo ńnɩ́ hálɩ lʊbɛ ńnɩ́. ");
INSERT INTO kdh_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Barɩ́ŋa bazɩ́m wɔ́rɔ́ nɛ́, ngɛ leelú ɖʊɖɔ waazɩ́. ");
INSERT INTO kdh_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tɔ́ɔ, ńŋɩnáa barɩ́ŋa bɔɔgbɔ́ɔ yɩ nɛ́, wɩ́rɛ wenɖé ɩsɩɖáa sɩ befé bɩlɛ́ nɛ́, badaá weení tɩɩná alʊ́.» ");
INSERT INTO kdh_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yeésu woobúsi wɛ sɩsɩ: «Mɩ́wɛ yɩsɩ́tɩ-daá! Káma, mɩ́ɩ́sɩ Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá, cáńfáná ɩdɛ́ɛ yíko. ");
INSERT INTO kdh_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ɩsɩɖáa wénvém nɛ́, aláa na abaaláa tɔ́ndɔkpɔwʊ́ ɖamá ɖʊɖɔ. Amá, bɔ́njɔwʊ́ʊ gɛ nyazɩ malááyɩ́kawá bɩlɛ́ ɩsɔ́ɔ́dáá. ");
INSERT INTO kdh_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Bɩɩga ɩsɩɖáa-dɛ́ɛ fém tɔ́m nɛ́, mɩ́dákála Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m-daá baaŋmáa sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Mɔ́ɔ́ gɛ Ibrahím na Ɩsaáka na Yaakúbu bɛdɛ́ɛ Ɩsɔ́ɔ” nɛ́? Ɩdɛkɛ́ɛ ɩsɩɖáa-dɛ́ɛ Ɩsɔ́ɔ, amá, weezíni-dɩnáa dɛ́ɛ Ɩsɔ́ɔ gɛ ɩgɛ́ɛ.» ");
INSERT INTO kdh_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Zamɔ́ɔ waanɩ́ɩ bɩlɛ́ nɛ́, ngɛ ɩdɛ́ɛ wɩlɩ́ɩ waalá wɛ bítí. ");
INSERT INTO kdh_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Faríizi ńba waanɩ́ɩ sɩsɩ bɩlɛ́ gɛ Yeésu waagá Sadusée ńba tɔ́m nɛ́, ngɛ boodúúzi ɖamá. ");
INSERT INTO kdh_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ngɛ badaá kʊ́ɖʊḿ weení ɩgɛ́ɛ Mará wɩlɩɖʊ́ nɛ́ sɩ ɩyɩ́ Yeésu kɔdɔká nɛ́, wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Kʊ́bɔnɩ́, Mará-daá, wenɖé waagɩlɩ ná.» ");
INSERT INTO kdh_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yeésu woobúsi yɩ sɩsɩ: «“Nyɔ́nzɔɔlɩ́ Nyádʊ́ʊ Ɩsɔ́ɔ na nyéwenbiré rɩ́ŋa, na nyégezeŋa rɩ́ŋa, na nyólomaazɛ́ rɩ́ŋa.” ");
INSERT INTO kdh_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mará-daá, wenɖé ɖɩɩgɩ́lɩ nɛ́ nbɩlɛ́; ɖɩnáábɩ́lɛ́ kaɖaa ńɖɛ. ");
INSERT INTO kdh_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Kʊ́bɔńɖɛ sɩɩlɛ ńɖɛ ɖɩɩlɩ́ɩ ɖɛ nɛ́ nɖɔ́: “Nyɔ́nzɔɔlɩ́ nyɔ́rɔwʊ́ nyazɩ nyádɩtɩŋa.” ");
INSERT INTO kdh_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mará amʊ́ alɛ́ɛ́nɩ́ gɛ Múúsá-dɛ́ɛ Mará na anɖébiwá-dɛ́ɛ wɩlɩ́ɩ tɛlɛsɛ́ɛ na.» ");
INSERT INTO kdh_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Faríizi ńba tuuzée bɩlɛ́ nɛ́, ngɛ Yeésu wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Wentí gɛ mɩ́nmaazɩnáa Lɛɛrʊ́. Weení biyaalʊ́ gɛ ɩgɛ́ɛ.» Ngɛ boobúsi yɩ sɩsɩ: «Ɖáwʊɖa». ");
INSERT INTO kdh_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ngɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Bɩɩlá nŋɩ́nɩ́ gɛ Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga waaŋmatɩná Ɖáwʊɖa ɩyáa Lɛɛrʊ́ sɩsɩ “Mádʊ́ʊ”. Káma, wɔɔdɔ́ gɛ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Ɖádʊ́ʊ wɔɔdɔ́ Mádʊ́ʊ sɩsɩ: Cɔɔ mégíɖíiwú-rɔ, hálɩ maɖʊ nbáɖaanáa nyɔ́nʊvɔ́-dɛ.” ");
INSERT INTO kdh_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","A bɩlɛ́ gɛ Ɖáwʊɖa waayáa yɩ sɩsɩ “Ɩdʊ́ʊ”, bɩ́nlám nŋɩ́nɩ́ na ikúti ɩgɛ́ɛ ibiyaalʊ́ ɖʊɖɔ.» ");
INSERT INTO kdh_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Badaá naárʊ toyuú báa natɩ́rɩ ibúsi. Bɩdɩ́ŋa-rɔ gɛ naárʊ tokúti iyuú wenbiré ɩbɔ́ɔ́zɩ yɩ tɔ́m ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Bɩlɛ́ bʊwɔ́rɔ́ gɛ Yeésu waaŋmatɩná zamɔ́ɔ na ɩwanbaaráa sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Mará wɩlɩɖáa na Faríizi ńba bánlɩzɩ́ɩ kʊ Múúsá-dɛ́ɛ Mará kutoluú. ");
INSERT INTO kdh_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Bɩlɛ́ nɛ́, ɩlá bɩka ifu wentí tɩrɩ́ŋa bánŋmatɩ́ mɩ́ɩ nɛ́. Amá, ɩ́kamáázɩ balakásɩ. Káma, bádánlaḿ wentí bánŋmatɩ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bɔ́nvɔkɩ́ sʊʊ́tɩ yíni ńdɩ gɛ bándɩnɩ́ ɩráa faamɩ́nɩ-rɔ, amá, bɛḿ badɩtɩŋa bédéndendekiná tɩ na niiká basɩná wɛ. ");
INSERT INTO kdh_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Bánlám balakásɩ rɩ́ŋa gɛ sɩsɩ na ɩráa ɩna wɛ. Bʊrɔɔzɩ́ nɛ́, bɔ́ngbɔwʊ́ʊ tɔná bátawá bándám bɛnyɛ́ na banʊ́ʊ́zɩ-rɔ; bɩka bónzuú kpáyɩwá tɩwɛná kpɛ́ɛ́dɩ kɩ́bɩɩzɩ́tɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kʊ́bɔɔ-ɖɩdáarɛ gɛ bɔɔzɔ́ɔ́lɩ cɔwʊ́ʊ ɖíínawá-daá na Ɩsɔ́ɔ ɖaazɛɛɖɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Bɔzɔɔlɛ́ɛ gɛ a ɩráa wɛ́nzɛɛ́ wɛ, bɔ́nɖɔɔzɩ́ wɛ, bɩka bɔzɔɔlɛ́ɛ ɖʊɖɔ bánÿaá wɛ sɩsɩ Ɩsɔ́ɔ-dɛ́ɛ tɔ́m wɩlɩɖáa kʊ́bɔnáa zamɔ́ɔ-daá. ");
INSERT INTO kdh_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Bɩɩga mɩ́nyɔ́ɔ́ nɛ́, ɩ́kɔsɔ́ɔ́lɩ sɩsɩ báyaa mɩ́ɩ sɩsɩ Ɩsɔ́ɔ-dɛ́ɛ tɔ́m wɩlɩɖáa kʊ́bɔnáa. Káma, Ɩsɔ́ɔ-dɛ́ɛ tɔ́m wɩlɩɖʊ́ kʊ́bɔnɩ́ kʊ́ɖʊḿ gɛ mɩ́wɛná; bɩɩga mɩ́rɩ́ŋa nɛ́, koobíya gɛ mɩ́gɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ɩ́káyaa naárʊ adɛ laadɔ́ɔ-rɔ sɩsɩ mɩ́jaa; káma, Caáwʊ kʊ́ɖʊḿ gɛ mɩ́wɛná, ɩnáábɩ́lɛ́ Caáwʊ ɩwɛ ɩsɔ́ɔ́dáá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Íkeyéle bayáa mɩ́ɩ sɩsɩ nɩ́baadɛɛrʊ́; káma, nɩ́baadɛɛrʊ́ kʊ́ɖʊḿ gɛ mɩ́wɛná, ɩnáábɩ́lɛ́ Lɛɛrʊ́. ");
INSERT INTO kdh_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mɩ́dáá kʊ́bɔnɩ́ ɩ́bɩsɩ mɩ́dɛ́ɛ bɔwʊtá-dʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Weení ɩrɩ́ŋa wángbaazɩ́ ɩdɩ nɛ́, béndisí yɩ, bɩka weení ɩrɩ́ŋa wéndisí ɩdɩ nɛ́, bángbaazɩ́ yɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Nbusú ɖamáa na mɩ́ɩ Mará wɩlɩɖáa na Faríizi ńba munáávikíwá. Mɩ́ndɔ́ɔ ɩráa Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ wɔnɔɔ́. Mɩ́dɩtɩŋa mɩ́dánzʊʊ, ngʊ́ mídénÿelí wenbá bɔzɔɔlɛ́ɛ nɛ́ basʊ́ʊ.  ");
INSERT INTO kdh_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Nbusú ɖamáa na mɩ́ɩ Mará wɩlɩɖáa na Faríizi ńba munáávikíwá. Mɩ́nlɛɛ́ leeláa-jɔ́ wenbíyɔ́ɔ rɩ́ŋa bɔwɛná nɛ́, bɩka mɩ́nlám sʊlʊ́ńdɩ kɩ́bɩɩzɩ́tɩ ɖʊɖɔ na bana mɩ́ɩ. Bʊrɔɔzɩ́ gɛ mɩ́dɛ́ɛ tɔ́m fʊʊnáa wánbá bɩlá ɖóni. ");
INSERT INTO kdh_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Nbusú ɖamáa na mɩ́ɩ Mará wɩlɩɖáa na Faríizi ńba munáávikíwá. Mɩ́nɖɛɛ́ nɩ́báánɩ báa lé, tenkú-rɔ, na adɛ laadɔ́ɔ-rɔ, na sɩsɩ iyuú naárʊ ɩlá yɩ túúbá. Na a mííyúú yɩ, ɩbɩsɩná yɩ azáába nimíni ɩrʊ́ ɩdɛ́ɛ ńdɩ waagɩ́lɩ mɩ́ɩ nabʊ́lɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Nbusú ɖamáa na mɩ́ɩ nɩ́baadɛɛráa njɛma, mɩ́ɩ wenbá mɩ́ndɔ́m sɩsɩ: “A ɩrʊ́ wooɖuuná Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga, bɩdɛkɛ́ɛ tɔ́m, amá, a ɩrʊ́ wooɖuuná Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá siká, asée waalá wentí wooɖuuná sɩsɩ wánlám nɛ́.” ");
INSERT INTO kdh_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kʊjʊʊ́ fɛ́yɩ́-dɩnáa njɛma mɩ́ɩ. Ngbetíi waagɩlɩ ná gɛ. Siká yáá Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga wenká keeyéle gɛ siká waabɩ́sɩ Ɩsɔ́ɔ-dɛ́ɛ ńbɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mɩ́ndɔtɔ́m ɖʊɖɔ sɩsɩ: “A ɩrʊ́ wooɖuuná Ɩsɔ́ɔ sarásɩ ɖaalanɖɛ́ bɩdɛkɛ́ɛ tɔ́m, amá, a ɩrʊ́ wooɖuuná sarɔ́ɔ baalá batɩ́nɩ ɖɩrɔ nɛ́, asée waalá wentí wooɖuuná sɩsɩ wánlám nɛ́.” ");
INSERT INTO kdh_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Njɛma bana! Ngbetíi waagɩlɩ ná gɛ. Sarɔ́ɔ yáá sarásɩ ɖaalanɖɛ́ wenɖé ɖiiyéle gɛ sarɔ́ɔ waabɩ́sɩ Ɩsɔ́ɔ-dɛ́ɛ ńbɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Bɩlɛ́ nɛ́, ɩdɩlɩ́ sɩsɩ weení wooɖuuná Ɩsɔ́ɔ-dɛ́ɛ sarásɩ ɖaalanɖɛ́ nɛ́, wooɖuuná wenbí bɩrɩ́ŋa bʊwɛ ɖɩrɔ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Weení wooɖuuná Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga nɛ́, wooɖuuná wenbí bɩrɩ́ŋa bʊwɛ kadaá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Weení wooɖuuná ɩsɔ́ɔ́dáá nɛ́, wooɖuuná Ɩsɔ́ɔ-dɛ́ɛ kowuro-gbelé na Ɩsɔ́ɔ weení ɩjɔɔ́ɔ ɖɩrɔ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Nbusú ɖamáa na mɩ́ɩ Mará wɩlɩɖáa na Faríizi ńba munáávikíwá. Mɩ́nvɛrɩ́ɩ yáázɩwá mɩ́nlanáa ɖóózi nɛ́-dɛ́ɛ fuú-rɔ kʊ́ɖʊńbɩ, bɩka mɩ́ngbɛɛnáa wenbí bɩjaarɛ́ɛ nɛ́ Mará-daá, bɩlɛ́ ɩmʊ́ gɛ: toovonúm fúu, kʊnyɔnnɩɩrɛ́ na ɩrʊ́ ɩsɩŋná Ɩsɔ́ɔ. Tɩlɛ́ gɛ bɩmɔɔ́na ɩɖaaná na ɩtásɩ tɩɩganáa. ");
INSERT INTO kdh_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nɩ́baadɛɛráa njɛma, mɩ́njɛtɩ́ lɩ́m mɩ́nlɩzɩ́ɩ bɔɖʊʊ́ bɩka mɩ́nnyɔɔ́ mɩ́ngbɛdɩ́na raakúḿ! ");
INSERT INTO kdh_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Nbusú ɖamáa na mɩ́ɩ Mará wɩlɩɖáa na Faríizi ńba munáávikíwá. Mɩ́nÿaalɩ́ yíka na nyɩnɔɔ́ wɔ́rɔ́ bɩka bɩdaá na ŋmɩɩlɩ-gbɩná na wenbí mɩ́ɩ́lɛ́ɛ́ná ɖóni nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Faríizi ńnɩ́ njɛm! Yaalɩ yíka-daá naanɩ́ na kɔwɔ́rɔ́ ɖʊɖɔ ɩlá ɖacɩrɩ‑cɩrɩ. ");
INSERT INTO kdh_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Nbusú ɖamáa na mɩ́ɩ Mará wɩlɩɖáa na Faríizi ńba munáávikíwá. Mɩ́jɔɔ́ɔ gɛ nyazɩ bɔɔláánɩ baavʊ́láazɩ tɩ nɛ́. A ɩrʊ́ bɛɛ́na tɩwɔ́rɔ́, tɩjɔɔ́ɔ bɛɛŋ́, amá, tɩdaá na ɩsɩɖáa mʊwá na kpɩná áńɖázɩ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Bɩlɛ́ ɖʊɖɔ gɛ mɩ́nyɔ́ɔ́, ɩráa ɩzá-daá nɛ́, bɛbɛɛ́na mɩ́ɩ sɩsɩ toovonúm-dɩnáa, ngʊ́ nbɛ́ɛ́ŋ nɛ́, mɩ́dáá nɛ́, munááfíísi na kidaavééníti riké gɛ. ");
INSERT INTO kdh_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Nbusú ɖamáa na mɩ́ɩ Mará wɩlɩɖáa na Faríizi ńba munáávikíwá. Mɩ́nyɔ́ɔ́ wenbá mɩ́nmáa anɖébiwá-dɛ́ɛ bɔɔláánɩ bɩka mɩ́nnyɔɔzɩ́ toovonúm-dɩnáa-dɛ́ɛ ńdɩ ");
INSERT INTO kdh_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","bɩka mɩ́ndɔ́m sɩsɩ: “A ɖáfʊ́nwɛ ɖájaájaanáa-dɛ́ɛ sáátɩ, ɖátátasɩná wɛ ɖɩkʊ anɖébiwá.” ");
INSERT INTO kdh_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Bɩlɛ́ gɛ mɩ́dɩtɩŋa mɩ́nlɩzɩ́ɩ mɩ́dɩ seríya sɩsɩ mɩ́gɛ́ɛ na wenbá baagʊ anɖébiwá nɛ́ bebíya. ");
INSERT INTO kdh_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Bɩlɛ́ nɛ́, ɩdɛ́ɛ́zɩ wenbí mɩ́jaájaanáa waabáázɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mɩ́ɩ ɖomáa bɔɔzá ana ɖɔ́! Nŋɩ́nɩ́ gɛ sɩ ɩlá na ɩlɩ́ɩ azáába nɩgbamʊʊ́ fɔ́m-daá. ");
INSERT INTO kdh_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Bʊrɔɔzɩ́ gɛ méngediríi mɩ́ɩ anɖébiwá, áséńsí-dɩnáa na Mará wɩlɩɖáa. Mɩ́ngʊ́ʊ badaá nɛbɛ́rɛ, ɩká nɛbɛ́rɛ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ basɩ́. Mínzutí badaá nɛbɛ́rɛ agbáázá mɩ́dɛ́ɛ Ɩsɔ́ɔ ɖaazɛɛɖɛ́, bɩka ɩtɩ́nɩ bɔwɔ́rɔ́ ɩlɩ́ɩ tɛ́ɛ́dɩ ɩsʊ́ʊ tɛ́ɛ́dɩ. ");
INSERT INTO kdh_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Bɩka ɩráa toovonúm-dɩnáa: kɔgbɔɔ Abíilu ɩrʊ́ toovonúm-dʊ́ʊ hálɩ ngɔ́nɩ Sákarɩ Barasíi biyaalʊ́, weení mɩ́ɩ́gʊ́ yɩ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga na sarásɩ ɖaalanɖɛ́ bɔlɔwʊtáá nɛ́, bɛdɛ́ɛ azimá-dɛ́ɛ nɩgbamʊʊ́ fɔ́m ití mɩ́rɔ́. ");
INSERT INTO kdh_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ménveerím mɩ́ɩ toovonúm sɩsɩ zaamáánɩ kɩna kɩdɛ́ɛ ɩráa-rɔ gɛ nbusúwá tɩḿ tɩrɩ́ŋa ɖɔ́ sɩ tití.» ");
INSERT INTO kdh_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Yerusalɛ́ɛm! Yerusalɛ́ɛm! Nyɔ́ɔ́ weení nyángʊ́ʊ anɖébiwá bɩka nyɔ́nÿɔwʊ́ʊ tɩndɩnáa bɔ́ nɛ́, bʊrɔ nŋɩ́nɩ́-nŋɩ́nɩ́ gɛ mɔ́ɔ́zɔ́ɔ́lɩ sɩ modúúzi nyébíya ńŋɩnáa konɖóowú wónduuzí kibíya kigelíni-dɛ nɛ́; amá, nyéégízi. ");
INSERT INTO kdh_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Bɩlɛ́ nɛ́, Ɩsɔ́ɔ wándalɩnáa mɩ́ɩ mɩ́ɖaána. ");
INSERT INTO kdh_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Káma, ménveerím mɩ́ɩ toovonúm sɩsɩ kɛtɛngɛrɛ mɩ́dándanáa ma hálɩ wɩ́rɛ wenɖé sɩ ɩtɔ́ sɩsɩ: “Sám mɔɔ́na kʊ weení ɩgɛrɛŋɛ na Ɖádʊ́ʊ yɩ́ɖɛ-daá nɛ́.”» ");
INSERT INTO kdh_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yeésu waalɩ́ɩ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá wɛ́nɖɛɛ́ nɛ́, ngɛ ɩdɛ́ɛ wanbaaráa woogóduu ɩjɔ́ bánwɩlɩ́ɩ yɩ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-dɛ́ɛ máa-dɛ́ɛ kazɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ńna gɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Mányɩ sɩsɩ mɩ́bɛɛ́na bɩrɩ́ŋa ɖɔ́ ya. Tɔ́ɔ, ménveerím mɩ́ɩ toovonúm sɩsɩ bɩ́dángáa bʊ́ʊ́rɛ ɖɩdɩ́nɛ́ɛ ɖɩrɔwʊ́-rɔ. Bɩrɩ́ŋa bínnuudí.» ");
INSERT INTO kdh_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ɩjɔɔ́ɔ Olivíyée tɩ́ɩ́nɩ bʊ́ʊ-daá nɛ́, ngɛ ɩwanbaaráa woogóduu ɩjɔ́ fɔɔlʊʊ́-rɔ bɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Feeri ɖáa sáátɩ wenkí sɩ bɩlá bɩlɛ́ nɛ́, na nyɛ́dɛ́ɛ kɔnɖɛ́ na ɖúúlínya kʊrʊ́ʊ-dɛ́ɛ seríya.» ");
INSERT INTO kdh_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Iguná laakáarɩ, naárʊ ɩ́kɛtɛlɛ́sɩ mɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Káma, ɩráa ɖabata wɔ́ngɔnɩ́ na máyɩ́ɖɛ-daá, bɔtɔ́ sɩsɩ: “Mɔ́ɔ́ gɛ Lɛɛrʊ́,” na bɛtɛlɛ́sɩ ɩráa ɖabata. ");
INSERT INTO kdh_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mɩ́nnɩɩ́ baŋmátɩ yóóni tɩjʊ́ʊ́na nɛ́, na bolíni ńdɩ tɔ́m. Ɩ́kanɩ́ɩ nɩdáárɛ! Bɩmɔɔ́na bɩlɛ́ bɩrɩ́ŋa bɩtála. Amá, bɩdɛkɛ́ɛ sɩsɩ ɖúúlínya kʊrʊ́ʊ waadala ná. ");
INSERT INTO kdh_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Káma, yíri wónÿoó yíri, wúro iyóo wúro; Fáráńdɩ́wá ndɩ‑ndɩ-daá nyɔɔ́sɩ wánlám, adɛ iséle. ");
INSERT INTO kdh_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Bɩlɛ́ bɩrɩ́ŋa bɩlɛ́ nɛ́, bɩjɔɔ́ɔ gɛ nyazɩ alʊ́ fuwá-dʊ́ʊ-dɛ́ɛ nʊŋásɩ kabaazɩya. ");
INSERT INTO kdh_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Na bayá mɩ́ɩ, banáázɩ mɩ́ɩ bɩka bakʊ mɩ́ɩ. Wenbá barɩ́ŋa baasɩ Ɩsɔ́ɔ nɛ́, bánlɩzɩ́ɩ mɩ́ɩ báɖáárɛ máyɩ́ɖɛ-rɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Na ɩráa ɖabata ɩbɛ́ɖɩ toovonúm fáa. Bánlɩɩ́ ɖamá wɔ́rɔ́ bɩka balɩzɩ́ ɖamá báɖáárɛ. ");
INSERT INTO kdh_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Anɖébiwá bʊbɔtɩnáa ɖabata wánɖʊ́ʊ balɩ́ɩ, na bɛtɛlɛ́sɩ ɩráa ɖabata. ");
INSERT INTO kdh_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kɩdaavééníti lám wɔ́nɖɔɔ́ hálɩ biyéle ɩráa tuutúúma-dɛ́ɛ sɔɔlɩ́m ɩfʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Amá, weení wɔ́nɖɔkɩ́ ɩdɩ hálɩ bɩkádʊ́lʊ́ nɛ́, Ɩsɔ́ɔ wɛ́nlɛɛ́ yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Bénveerím ɖúúlínya rɩ́ŋa Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-dɛ́ɛ Laabáárʊ Kífeńgi kɩna, na yíri báa wenkí ɩnɩ́ɩ kɩsɩ́ɩ seríya. Bɩlɛ́ bʊwɔ́rɔ́ gɛ ɖúúlínya wángʊrʊ́ʊ.» ");
INSERT INTO kdh_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«A mɩ́ɩ́gɔ́nɩ ɩna Fɔrɔ́sɩ́rʊ láálɩ́-dʊ́ʊ, anɖébi Danɩyɛ́ɛlɩ waaŋmátɩ ɩdɔ́m nɛ́, ɩkɔ́nɩ isúu ɖacɩrɩ‑cɩrɩ ɖɩdáarɛ, (weení wángalɩ́ɩ nɛ́, ɩ́nɩɩ bugutoluú kazɔ́ɔ). ");
INSERT INTO kdh_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Bɩdɛ́ɛ sáátɩ nɛ́, wenbá bɔwɛ Yudée laadɔ́ɔ-daá nɛ́, bésé bɛɖɛ́ɛ bʊ́ʊ́nɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Weení ɩwɛ ɖaḿ kʊjʊʊ́-daá atáárɩ-rɔ nɛ́, íketí sɩsɩ sɩ ɩkpɔ́ɔ ɩgbɩná awɛ ɖaḿ-daá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Weení ɩwɛ fɔɔ́ nɛ́, ɩ́kakábɩsɩ ɩwɔ́rɔ́ sɩsɩ ɩkɔ́gbɔ́ɔ ɩdɛ́ɛ kpáyɩ. ");
INSERT INTO kdh_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nbusú ɖamáa na aláa bɛyɛ́ɛna fúúzi nɛ́, na wenbá bebíya wánmʊzʊ́ʊ wɛ wɛ́ amʊ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ɩzʊ́lʊ Ɩsɔ́ɔ sɩsɩ sɩ ise nɛ́, bɩ́kásaaná kaanɩŋá sáátɩ yáá Fɛɛzɩrɛ wɩ́rɛ. ");
INSERT INTO kdh_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Sáátɩ kɩḿ, ɩráa wánnáa fúkúḿsi kɛtɛngɛrɛ badanáa ta sɩ ɖoo ɖúúlínya kabaazɩya hálɩ ngɔ́nɩ lɛlɛɛɖɔ́ nɛ́. Ngʊ́ bɩlɛ́ gɛ naárʊ tándanáa sɩdaká. ");
INSERT INTO kdh_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","A Ɩsɔ́ɔ ɩ́tatʊʊ́ wɛ́-bíya bɛḿ, naárʊ ɩ́tabɩ́ɩ́zɩ ɩcɔ́ɔ weezuú-daá. Amá, wenbá waada ɩlɩzɩ́ wɛ nɛ́ bɔrɔɔzɩ́, waadʊʊ́ wɛ́-bíya bɛḿ. ");
INSERT INTO kdh_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Bɩlɛ́ nɛ́, a naárʊ wɔɔdɔ́ mɩ́ɩ sɩsɩ Lɛɛrʊ́ wɛ cé yáá ɩwɛ lí, ɩ́kafa yɩ toovonúm. ");
INSERT INTO kdh_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Káma, lɛɛráa bʊbɔtɩnáa na anɖébiwá bʊbɔtɩnáa wángʊrʊ́ʊ balá maamááciwá kʊ́bɔńdɩ na mááɖéwá na a bɩ́njɔ́ɔ, bɛtɛlɛ́sɩ bɩkpɛdɩ́na wenbá Ɩsɔ́ɔ waada ɩlɩzɩ́ wɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Bɩlɛ́ nɛ́ máábásɩ mɩ́ɩ nbɩlɛ́ naanɩ́ bɩtála. ");
INSERT INTO kdh_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Bɩlɛ́ nɛ́, a beevééri mɩ́ɩ sɩsɩ: “Ɩbɛ́ɛ yɩ tɛɛwʊ́lɔ́ɔ́-daá,” íkobó. Yáá a bɔɔdɔ́ mɩ́ɩ sɩsɩ: “Ɩbɛ́ɛ yɩ, ɩmʊ́sɛ́ɛ cé,” ɩ́kafa wɛ toovonúm. ");
INSERT INTO kdh_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Káma, ńŋɩnáa bɩ́nnyaláázɩ wɩ́sɩ ɖaagalɩɩɖɛ́ fáráńdɩ́ na bikólósi sɩ ɖaagazalaɖɛ́ fáráńdɩ́ nɛ́, bɩlɛ́ gɛ sɩ bɩlá Ɩrʊ́ Biyaalʊ́-dɛ́ɛ kɔnɖɛ́ wɩ́rɛ. ");
INSERT INTO kdh_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Lénlé wenbí bɩ́ńzɩ́ḿ nɛ́ bʊwɛ nɛ́, ńna gɛ abɛ́ntɛ́wá wónduuzí.» ");
INSERT INTO kdh_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Wɛ́-bíya bɛḿ bajáŋ bɛdɛ́ɛ fúkúḿsi wɔ́rɔ́ nɛ́, wɩ́sɩ-daá, bɩ́nlám temenuú; fenɔɔ́-dɛ́ɛ ɖɛnyɛm tóńdolosi, wɩlásɩ wánlɩɩ́ ɩsɔ́ɔ́dáá sɩ́nzalɩ́ɩ, bɩka ɩsɔ́ɔ́dáá yíkowá iséle. ");
INSERT INTO kdh_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Na Ɩrʊ́ Biyaalʊ́-dɛ́ɛ ɖaazɩ́tɩ ɩɖʊ tɩlɩ́ɩ ɩsɔ́ɔ́dáá, na adɛ laadɔ́ɔ-rɔɔzɩ́ yíriwá rɩ́ŋa ɩbáázɩ mɛɛdɩ́ bénwií. Bánnáa Ɩrʊ́ Biyaalʊ́ ɩkálɩ́ɩ́ná ɩsɔ́ɔ́dáá ŋmɩ́ńdɩ-rɔɔzɩ́ ɩ́na ɩdɛ́ɛ yíko rɩ́ŋa na ásícé. ");
INSERT INTO kdh_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Wéngediríi ɩdɛ́ɛ malááyɩ́kawá na ɖɩgandɩ́rɛ kʊ́bɔńɖɛ botúúzi wenbá waada ɩlɩzɩ́ wɛ ɖúúlínya gootá natɩ́náázá-daá fúu cé na fúu lí nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Ɩgbɛlɛm ná figíyée tɩɩwʊ́. A bɩgɛ́ɛ kɩdɛ́ɛ wʊláázɩ waalá siíni bɩka fáádɩ wánzʊʊ́, mɩ́nyɩ sɩsɩ lʊngʊrɛ́ waajʊ́ʊ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Bɩlɛ́ ɖʊɖɔ gɛ mɩ́nyɔ́ɔ́ ɖʊɖɔ, a mɩ́ɩ́ná wentí tɩrɩ́ŋa mááŋmátɩ mɩ́ɩ nɛ́, ɩdɩlɩ́ sɩsɩ Ɩrʊ́ Biyaalʊ́ waajʊ́ʊ nbɩlɛ́, wáńdálɩ́ mɩ́ɖaḿ wɔnásɩ. ");
INSERT INTO kdh_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ménveerím mɩ́ɩ toovonúm sɩsɩ zaamáánɩ kɩna kɩdɛ́ɛ ɩráa tɛ́ndɛŋ́ na bɩrɩ́ŋa máádɩ́ ɖɔ́ nɛ́ bɩtála. ");
INSERT INTO kdh_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Adɛ na ɩsɔ́ɔ́dáá wɛ́ndɛlɛ́ŋ, amá, mɛ́dɛ́ɛ ŋmatɩrɛ tɛ́ndɛlɛ́ŋ kɛtɛngɛrɛ.» ");
INSERT INTO kdh_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Amá, naárʊ waasɩ bɩdɛ́ɛ wɩ́rɛ yáá alɩwáátɩ. Malááyɩ́kawá bɔwɛ ɩsɔ́ɔ́dáá nɛ́ baasɩ, cáńfáná Biyaalʊ́ʊ, asée Caáwʊ riké. ");
INSERT INTO kdh_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Wenbí bɩɩlá Núhum-dɛ́ɛ sáátɩ nɛ́ nɔ́ɔ́ sɩ bɩla ná Ɩrʊ́ Biyaalʊ́-dɛ́ɛ kɔnɖɛ́ sáátɩ. ");
INSERT INTO kdh_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Bɩdɛ́ɛ sáátɩ kɩḿ, naanɩ́ na tɛ́ɛ́wʊ kʊ́bɔńgɩ ɩbáázɩ nɩɩ́ lɩ́m iɖi ɩráa nɛ́, ɩráa wénɖíi bɔ́nnyɔɔ́, bɔ́ngbɔwʊ́ʊ aláa, bɩka bánváa bebíya hálɩ wɩ́rɛ wenɖé Núhum waazʊ́ʊ mɛ́ɛ́lɛ nɛ́ ɩtála. ");
INSERT INTO kdh_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Bidefééri wɛ natɩ́rɩ hálɩ lɩ́m kʊ́bɔńbɩ ɩkɔ́nɩ biɖi barɩ́ŋa. Bɩlɛ́ ɖʊɖɔ gɛ sɩ bɩlá Ɩrʊ́ Biyaalʊ́-dɛ́ɛ kɔnɖɛ́ wɩ́rɛ. ");
INSERT INTO kdh_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ɩráa nɔɔ́lɛ wɛ fɔɔ́-daá gɛ na bɩsɛlɩ́ kʊ́ɖʊḿ biyéle sɩɩlɛ ńnɩ́. ");
INSERT INTO kdh_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Aláa nɔɔ́lɛ wɛ bánnaḿ namɩ́rɛ-rɔ gɛ na bɩsɛlɩ́ kʊ́ɖʊḿ biyéle lí ńnɩ́. ");
INSERT INTO kdh_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Bɩlɛ́ nɛ́ ivére, káma, mɩ́ɩ́sɩ wɩ́rɛ wenɖé Mɩ́dʊ́ʊ sɩ ɩkɔ́nɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mɩ́nyɩ bɩlɛ́ sɩsɩ a ɖɔɔ́-dʊ́ʊ ɩ́fʊnnyɩ nuvoowú-dɛ́ɛ alɩwáátɩ wenkí ŋmɩɩlʊ́ sɩ ɩkɔ́nɩ nɛ́, wénveríi gɛ ɩcɔɔná waazá na ŋmɩɩlʊ́ ɩ́kɔkɔ́nɩ ɩsʊ́ʊ ɖaána-daá. ");
INSERT INTO kdh_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Bʊrɔɔzɩ́ nɛ́, mɩ́nyɔ́ɔ́ ɖʊɖɔ ɩgbɩ́ɩ́rɩ mɩ́ɖamáa, káma, Ɩrʊ́ Biyaalʊ́ sɩ ɩkɔ́nɩ alɩwáátɩ wenkí mɩ́raaɖamáa nɛ́ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Weení gɛ bɔwʊtá-dʊ́ʊ ɩzɩɩzɛ́ɛ bɩka ɩgɛ́ɛ tɩlɩ́ɖʊ ɩgʊ́bɔnɩ́ waazɩ́ɩ yɩ wɛ́nbɛɛŋ́ ɩɖaána-daá bɔwʊtá-dɩnáa-rɔ, bɩka wánváa wɛ kíɖíím sáátɩ wenkí bɩɩbɔ́ɔ́zɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","A bɩgɛ́ɛ bɔwʊtá-dʊ́ʊ ɩmʊ́ ɩgʊ́bɔnɩ́ waagábɩsɩ, ngɛ wɔɔmɔɔná yɩ wánlám tɩmɛ́rɛ wenɖé waaɖʊ yɩ nɛ́, ɩnáábɩ́lɛ́ wenbi‑niíni-dʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ménveerím mɩ́ɩ toovonúm sɩsɩ wánzɩɩ́ yɩ kʊ́bɔńdɩ ɩdɛ́ɛ ɖɔ́ɔ́lɛ rɩ́ŋa-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Amá, a ɩgɛ́ɛ bɔwʊtá-dʊ́ʊ tɩtɛ ńnɩ́, wɔ́ndɔ́m iwenbiré-daá sɩsɩ: “Mágʊ́bɔnɩ́ tángabɩsɩ ɖasam,” ");
INSERT INTO kdh_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","na ɩsʊ́ʊ ɩ́na wenbá tɩmɛ́rɛ-daá nɛ́ mám, wénɖíi bɩka ɩ́na nyɔɔráa bɔ́nnyɔɔ́. ");
INSERT INTO kdh_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Bɔwʊtá-dʊ́ʊ ɩmʊ́ ɩdɛ́ɛ kʊ́bɔnɩ́ wándalɩ́ɩ wɩ́rɛ na alɩwáátɩ wenkí ɩraaɖʊ́ʊ́na nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ɩgʊ́bɔnɩ́ wɔ́nɖɔwʊ́ʊ yɩ bɩka ɩfɛ́rɛ yɩ munáávikíwá-dɛ́ɛ kɩvɛrɛwʊ. Ńna gɛ wénwií bɩka wánlám mányɩ lé.» ");
INSERT INTO kdh_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Bɩlɛ́ nɛ́, wenbí bɛ́ngɛɛzɩnáa Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ nɛ́ nɖɔ́: Aléewá fuú badatɩlɩ́ ta abaaláa nɛ́ wɔɔgbɔɔ ná fɩtɩ́lawá balɩ́ɩ weetáhárʊ sɩŋ́. ");
INSERT INTO kdh_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Badaá nɔɔ́nʊ́wá kɛ́ɛ laakáarɩ buḿsi-dɩnáa, bɩka nɔɔ́nʊ́wá baaganáa kɛ́ɛ áséńsí-dɩnáa. ");
INSERT INTO kdh_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nɔɔ́nʊ́wá laakáarɩ buḿsi-dɩnáa wɔɔgbɔ́ɔ bɛdɛ́ɛ fɩtɩ́lawá nɛ́, bɛdɛkpɛdɩ́na núm bánɖʊ́ʊ fɩtɩ́la-daá nɛ́ azíya. ");
INSERT INTO kdh_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Amá, nɔɔ́nʊ́wá baaganáa kɛ́ɛ áséńsí-dɩnáa, bɛlɛ́ bɛɛgbɛdɩ́na núm azíya bɛdɛ́ɛ kpárábayáawá-daá. ");
INSERT INTO kdh_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Weetáhárʊ tofolí kɔnɖɛ́ nɛ́, ɖóm waalá aléewá bɛḿ barɩ́ŋa bɔkpɔ́ɔ ɖóm. ");
INSERT INTO kdh_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nuvoo-lɔwʊ́rɛ gɛ ɖugoogoore wɔɔvɔ sɩsɩ: “Ɩbɛ́ɛ weetáhárʊ, ɩlɩ́ɩ ɩsɩ́ŋ yɩ!” ");
INSERT INTO kdh_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ńna gɛ aléewá bɛḿ barɩ́ŋa beevé bángbɩɩrɩ́ bavɩtɩ́lawá. ");
INSERT INTO kdh_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nɔɔ́nʊ́wá laakáarɩ buḿsi-dɩnáa wɔɔdɔ́ áséńsí-dɩnáa sɩsɩ: “Ɩva ɖáa mɩ́dɛ́ɛ núm, ɖɛ́dɛ́ɛ fɩtɩ́lawá wánɖɩ́m.” ");
INSERT INTO kdh_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Áséńsí-dɩnáa woobúsi wɛ sɩsɩ: “Aayɩ́. Bɩ́dándalɩ́ ɖána mɩ́ɩ, bɩlɛ́ nɛ́ ibó yamɖáa-jɔ́ ɩkámʊ́.” ");
INSERT INTO kdh_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Sáátɩ wenkí bɛɛɖɛ́ɛ mʊ́ʊ nɛ́ gɛ weetáhárʊ waadála. Wenbá báńgbɩɩrɩ badɩ baɖamáa nɛ́, boovu yɩ basʊ́ʊ hiije ɖaána-daá, ngɛ bɔɔdɔ tará bakára. ");
INSERT INTO kdh_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Bɩlɛ́ bʊwɔ́rɔ́ gɛ aléewá baaganáa waadála bɔ́ndɔ́m sɩsɩ: “Kʊ́bɔnɩ́! Kʊ́bɔnɩ́! Bátʊlʊ́-ɖáa.” ");
INSERT INTO kdh_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Amá, woogóbusi wɛ sɩsɩ: “Ménveerím mɩ́ɩ toovonúm sɩsɩ máásɩ mɩ́ɩ.” ");
INSERT INTO kdh_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Bɩlɛ́ nɛ́, ivére káma, mɩ́ɩ́sɩ wɩ́rɛ yáá alɩwáátɩ wenkí Ɩrʊ́ Biyaalʊ́ sɩ ɩkɔ́nɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ tɔrɔjɔɔ́ɔ gɛ nyazɩ ɩrʊ́ weení sɩ ɩɖɛ́ɛ nɩ́bááwʊ gɛ waayáa ɩdɛ́ɛ bɔwʊtá-dɩnáa ɩtalɩná wɛ ɩdɛ́ɛ ɖɔ́ɔ́lɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Weejéle kʊ́ɖʊḿ siká liideé kákpɩ́ɩ́zɩ nasɩ́lɛ na nɩɩ́nʊ́wá (500), naárʊ siká liideé kákpáŋa (200), ngɛ weejéle toozo ńnɩ́ siká liideé nɩɩ́nʊ́wá (100). Weejéle báa weení bɩlɩɩná ɩdɛ́ɛ konkárɩ́-rɔ. Ngɛ wɛɛɖɛ́ɛ ɩdɛ́ɛ nɩ́bááwʊ. ");
INSERT INTO kdh_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Weení beejéle yɩ siká liideé kákpɩ́ɩ́zɩ nasɩ́lɛ na nɩɩ́nʊ́wá nɛ́, waajáŋ ibó ɩlaná yɛ tɩmɛ́rɛ iyuú alɩbɔ́ɔ siká liideé kákpɩ́ɩ́zɩ nasɩ́lɛ na nɩɩ́nʊ́wá ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Siká liideé kákpáŋa-dʊ́ʊ woobó ɩlá bɩlɛ́ ɖʊɖɔ iyuú alɩbɔ́ɔ siká liideé kákpáŋa ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Amá, weení beejéle yɩ siká liideé nɩɩ́nʊ́wá nɛ́, woobó ɩbáa bɔɔwʊ́ adɛ ɩkpɔ́ɔ ɩdɛ́ɛ kʊ́bɔnɩ́-dɛ́ɛ liideé ɩmʊ́sɩ ńna. ");
INSERT INTO kdh_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Bʊwɔ́rɔ́ kpeteree nɛ́, bɔwʊtá-dɩnáa bana bɛdɛ́ɛ kʊ́bɔnɩ́ waadála, ngɛ waayáa badaá báa weení sɩsɩ ɩtɩ́ yɩ wenbí waalaná iliideé nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Weení beejéle yɩ siká liideé kákpɩ́ɩ́zɩ nasɩ́lɛ na nɩɩ́nʊ́wá nɛ́ wɔɔgɔ́nɩ ɩgʊ́bɔnɩ́ ɩzá-daá, ngɛ waazɩ́ɩ siká liideé kákpɩ́ɩ́zɩ nasɩ́lɛ na nɩɩ́nʊ́wá kɩ́falá ɩtɔ́ sɩsɩ: “Kʊ́bɔnɩ́, nyééjéle ma siká liideé kákpɩ́ɩ́zɩ nasɩ́lɛ na nɩɩ́nʊ́wá gɛ, bɛɛ siká liideé kákpɩ́ɩ́zɩ nasɩ́lɛ na nɩɩ́nʊ́wá móóyúú alɩbɔ́ɔ nɛ́ nɖɔ́.” ");
INSERT INTO kdh_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ńna gɛ ɩgʊ́bɔnɩ́ wɔɔdɔ́ yɩ sɩsɩ: “Nyáálá kazɔ́ɔ, nyɛ́gɛ́ɛ bɔwʊtá-dʊ́ʊ kazɔ́ɔ ńnɩ́ na toovonúm-dʊ́ʊ; mééjéle nya cʊ́kɔ, ngɛ nyáálá ná kɩ tɩmɛ́rɛ na toovonúm nɛ́, ménjelíi nya tɩmɛ́rɛ kʊ́bɔńɖɛ. Kɔnɩ mána nya ɖɩfáárɩ.” ");
INSERT INTO kdh_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Weení beejéle yɩ siká liideé kákpáŋa nɛ́ wɔɔgɔ́nɩ ɩgʊ́bɔnɩ́ ɩzá-daá ɩtɔ́ yɩ sɩsɩ: “Kʊ́bɔnɩ́, nyééjéle ma siká liideé kákpáŋa gɛ, bɛɛ siká liideé kákpáŋa móóyúú alɩbɔ́ɔ nɛ́.” ");
INSERT INTO kdh_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ńna gɛ ɩgʊ́bɔnɩ́ wɔɔdɔ́ yɩ sɩsɩ: “Nyáálá kazɔ́ɔ, nyɛ́gɛ́ɛ bɔwʊtá-dʊ́ʊ kazɔ́ɔ ńnɩ́ na toovonúm-dʊ́ʊ; mééjéle nya cʊ́kɔ, ngɛ nyáálá ná kɩ tɩmɛ́rɛ na toovonúm nɛ́, ménjelíi nya tɩmɛ́rɛ kʊ́bɔńɖɛ. Kɔnɩ mána nya ɖɩfáárɩ.” ");
INSERT INTO kdh_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Weení beejéle yɩ siká liideé nɩɩ́nʊ́wá nɛ́, wɔɔgɔ́nɩ ɩgʊ́bɔnɩ́ ɩzá-daá nɛ́, ngɛ sɩsɩ: “Kʊ́bɔnɩ́, mányɩ sɩsɩ nyɛ́gɛ́ɛ ɩrʊ́ weení ɩjɔɔ́ɔ káálɛ nɛ́ gɛ. Lénlé ńdóɖuu nɛ́ gɛ nyɔ́ngɔrɩ́ɩ, bɩka nyángʊ́m lénlé ndálára nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Biiyéle máánɩ́ɩ nɩdáárɛ nɛ́, móóbóná nyɛ́dɛ́ɛ siká liideé nɩɩ́nʊ́wá mabáa bɔɔwʊ́ adɛ mɔgbɔ́ɔ yɛ mamʊ́sɩ ńna. Bɛɛ yɛ, nyéliideé nbɩlɛ́.” ");
INSERT INTO kdh_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ngɛ, ɩgʊ́bɔnɩ́ woobúsi yɩ sɩsɩ: “Bɔwʊtá-dʊ́ʊ tɩtɛ ńnɩ́ bɩgaadʊ́ʊ. Nyányɩ bɩlɛ́ sɩsɩ lénlé módóɖúu nɛ́ gɛ mɔ́ngɔrɩ́ɩ bɩka mángʊ́m lénlé mádalára nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Bɩlɛ́ nɛ́, nɖaaboná méliideé nzɩ́ɩ bánkɩ; máagábɩ́sɩ ɖɔ́ nɛ́, maraamʊ méliideé na adɛ́ɛ alɩbɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Bɩlɛ́ nɛ́, ɩlɛ́ɛ siká liideé nɩɩ́nʊ́wá ɩjɔ́ icéle weení ɩwɛná siká liideé mííli nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Káma, weení ɩwɛná nɛ́, bándasɩ́ yɩ na iyuú bɩbá bɩɖɔ́ɔ, amá, weení ɩvɛ́yɩ́na nɛ́, bɛ́nlɛɛ́ wenbíyɔ́ɔ ɩwɛná nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Bɩɩga bɔwʊtá-dʊ́ʊ tɩtɛ ńnɩ́ ɩmʊ́ nɛ́, ɩlɔ yɩ asʊ temenuú-daá. Ńna gɛ wénwií ɩlá mányɩ lé.”» ");
INSERT INTO kdh_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Sáátɩ wenkí Ɩrʊ́ Biyaalʊ́ sɩ ɩkɔ́nɩ ɩdɛ́ɛ ásícé-daá ɩ́gana malááyɩ́kawá rɩ́ŋa nɛ́, wɔ́njɔwʊ́ʊ ɩdɛ́ɛ kowuro-gbelé ásícé ńɖɛ-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Yíriwá rɩ́ŋa wónduuzí waazá-daá. Wándarɩ́ɩ ɩráa ńŋɩnáa ketirú wándarɩ́ɩ ɩsɩ́ɩ fééni fɔɔlʊʊ́, namɩ́nɩ fɔɔlʊʊ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Wánzɩɩ́ fééni igíɖiiwú-rɔ, ɩsɩ́ɩ namɩ́nɩ ɩnɩbɩɩwʊ́-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Na wúro ɩtɔ́ wenbá bɔwɛ igíɖiiwú-rɔ nɛ́ sɩsɩ: “Ɩgɔ́nɩ, mɩ́nyɔ́ɔ́ wenbá Majaa waaɖʊ mɩ́ɩ alɩbáráka nɛ́, ɩmʊ kowuro-ɖɔɔ́ wenká baagbɩ́ɩ́rɩ basɩ́ɩ mɩ́ɩ ɖoo balám ɖúúlínya nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Káma, nyɔɔ́sɩ wɛná ma, ngɛ mɩ́ɩ́vá ma kíɖíím meɖí; ɖoolɔɔ́ wɛná ma, ngɛ mɩ́ɩ́vá ma lɩ́m mɔnyɔ́ɔ, mɔ́wɛ ɩgɔ́ńdɩ, ngɛ mɩ́ɩ́mʊ́ ma; ");
INSERT INTO kdh_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","mɔ́jɔɔ́ɔ tunbóóló, ngɛ míízúu ma kpɩná; mánnyaadɩ́ nɛ́, míízúlu mɔ́rɔ́; mɔ́wɛ sáráka-daá nɛ́, mɩ́ɩ́gɔ́nɩ mɔ́jɔ́.” ");
INSERT INTO kdh_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Na wenbá baalá Ɩsɔ́ɔ-dɛ́ɛ sɔɔlɩ́m nɛ́ bobúsi yɩ sɩsɩ: “Ɖádʊ́ʊ, sáátɩ wenkí gɛ ɖááná nya nyɔɔ́sɩ wɛná nya gɛ ɖáává nya kíɖíím nɖi yáá ɖoolɔɔ́ wɛná nya gɛ ɖáává nya lɩ́m nnyɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Sáátɩ wenkí gɛ ɖááná nya nyɔ́wɛ ɩgɔ́ńdɩ gɛ ɖáámʊ nya, yáá nyɔ́jɔɔ́ɔ tunbóóló gɛ ɖóózúu nya kpɩná. ");
INSERT INTO kdh_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Sáátɩ wenkí gɛ ɖááná nya nyánnyaadɩ́ yáá nyɔ́wɛ sáráka-daá gɛ ɖóózúlu nyɔ́rɔ́.” ");
INSERT INTO kdh_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Na wúro ibúsi wɛ sɩsɩ: “Ménveerím mɩ́ɩ toovonúm sɩsɩ báa sáátɩ wenkí gɛ mɩ́ɩ́lá bɩlɛ́ mogoobíya bana badaá báa kúmuú naárʊ, mɔ́ɔ́ gɛ mɩ́ɩ́lá.” ");
INSERT INTO kdh_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Na ɩtɔ́ wenbá bɔwɛ ɩnɩbɩɩwʊ́-rɔ nɛ́ sɩsɩ: “Ɩlaná ma bolíni, mɩ́nyɔ́ɔ́ wenbá Ɩsɔ́ɔ waalá mɩ́ɩ láálɩ́ nɛ́. Ibó ɩɖɛ́ɛ nimíni ɩ́dánɖɩḿ kɛtɛngɛrɛ baagbɩ́ɩ́rɩ yɩ basɩ́ɩ Sitáánɩ na ɩdɛ́ɛ malááyɩ́kawá nɛ́ ɩdaá. ");
INSERT INTO kdh_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Káma, nyɔɔ́sɩ waalá ma, ngɛ mɩ́dáfá ma kíɖíím meɖi; ɖoolɔɔ́ waalá ma, ngɛ mɩ́dáfá ma lɩ́m mɔnyɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mɔ́wɛ ɩgɔ́ńdɩ, ngɛ mɩ́damʊ́ ma; mɔ́jɔɔ́ɔ tunbóóló, ngɛ mídosúu ma kpɩná. Mánnyaadɩ́ bɩka mɔ́wɛ sáráka, ngɛ mídóbó isúlu mɔ́rɔ́.” ");
INSERT INTO kdh_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Na bɛlɛ́ ɖʊɖɔ bobúsi sɩsɩ: “Ɖádʊ́ʊ, sáátɩ wenkí gɛ ɖááná nya nyɔɔ́sɩ yáá ɖoolɔɔ́ wɛná nya; nyɛ́gɛ́ɛ ɩgɔm yáá nyɔ́jɔɔ́ɔ tunbóóló; nyánnyaadɩ́ yáá nyɔ́wɛ sáráka-daá gɛ ɖádásɩ́ná nya.” ");
INSERT INTO kdh_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Na wúro ibúsi wɛ sɩsɩ: “Ménveerím mɩ́ɩ toovonúm sɩsɩ báa sáátɩ wenkí gɛ mɩ́dálá bɩlɛ́ mogoobíya bana badaá báa kúmuú naárʊ, mɔ́ɔ́ gɛ mɩ́dálá.” ");
INSERT INTO kdh_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Na bɛɖɛ́ɛ azáába kɩ́dɛ́ndɛŋ́ nɛ́ kɩdaá. Bɩɩga wenbá bánlám Ɩsɔ́ɔ-dɛ́ɛ sɔɔlɩ́m nɛ́, bɛlɛ́ bɛɖɛ́ɛ weezuú kɩ́dɛ́ndɛŋ́ nɛ́ kɩdaá.» ");
INSERT INTO kdh_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yeésu wɛɛdɛ́ tɔ́mwá tɩna tɩrɩ́ŋa wɩlɩ́ɩ nɛ́, ngɛ wɔɔdɔ́ ɩwanbaaráa sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Mɩ́nyɩ sɩsɩ bɩɩga wɛ́ náálɛ na beɖi Fɛlɛ nɖɛ́ɛ-dɛ́ɛ jíńgáárɩ́. Bángbáa Ɩrʊ́ Biyaalʊ́ becéle na baká yɩ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ.» ");
INSERT INTO kdh_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ngɛ Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa na tɛ́ɛ́dɩ-daá kʊ́bɔnáa woodúúzi ɖamá Kayífu, Ɩsɔ́ɔ sarásɩ lanɖáa rɩ́ŋa-dɛ́ɛ kʊ́bɔnɩ́-dɛ́ɛ ɖaána-daá. ");
INSERT INTO kdh_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Baaŋmátɩ banɩ́ɩ ɖamá sɩsɩ bakpa Yeésu súmúú-daá bɩka bakʊ yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Amá, sɩsɩ bɩ́kalá jíńgáárɩ́ lɔwʊ́rɛ, na bɩ́kɔkɔ́nɩ bitulúsi zamɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yeésu wɛ Betáániya tɛ́ɛ́dɩ-daá Simɔ́ɔnɩ weení cɛnɩ́tɩ waazɩ́ŋ bɩkpa yɩ nɛ́-dɛ́ɛ ɖaána-daá nɛ́, ");
INSERT INTO kdh_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ngɛ alʊ́ naárʊ woogóduu ɩjɔ́ ɩ́gana kpárábá kazɔ́ɔ ńgɩ kɩdaá na liidebɔná tulaarɩ́. Ngɛ waabɩ́rɩ tulaarɩ́ Yeésu kʊjʊʊ́-daá sáátɩ wenkí ɩlɛ́ ɩwɛ wénɖíi kíɖíím nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Wanbaaráa waana bɩlɛ́ nɛ́, ngɛ bɛɛyɛ́ɛ baaná. Ngɛ sɩsɩ: «We-rɔ gɛ wɔɔvɔrɔ́sɩ tulaarɩ́ bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Baraabɩ́ɩ́zɩ bayá kɩ liidebɔná, bɔkpɔ́ɔ kiliideé bafa kadanbʊrʊ́sɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yeésu waanɩ́ɩ bɩlɛ́ nɛ́, ngɛ sɩsɩ: «We-rɔ gɛ mɩ́nlám alʊ́ ɩmʊ́ nɔwɛ́ya. Kazɔ́ɔ ńbɩ gɛ waalá ma. ");
INSERT INTO kdh_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Káma, báa sáátɩ wenkí mɩ́na kadanbʊrʊ́sɩ gɛ, amá, bɩdɛkɛ́ɛ báa sáátɩ wenkí gɛ sɩ iyuú mɔ́ɔ́ mɩ́jɔ́. ");
INSERT INTO kdh_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Waabɩrɩná ma tulaarɩ́ nɛ́, mɛ́dɛ́ɛ bím gɛ waajáŋ ɩkpɩ́ɩ́rɩ bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ménveerím mɩ́ɩ toovonúm sɩsɩ báa lé gɛ sɩ befééri Laabáárʊ Kífeńgi ɖúúlínya rɩ́ŋa-daá, bánŋmatɩ́ wenbí waalá nɛ́ bɔtɔɔzɩná ɩrɔ.» ");
INSERT INTO kdh_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ńna gɛ fuú na nɔɔ́lɛ-daá kʊ́ɖʊḿ weení bánÿaá yɩ sɩsɩ Yudásɩ Isikariyóo nɛ́, wɛɛɖɛ́ɛ Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa-jɔ́ ");
INSERT INTO kdh_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ɩtɔ́ wɛ sɩsɩ: «We gɛ mɩ́nváa ma a bɩgɛ́ɛ máágbá Yeésu mejéle mɩ́ɩ.» Ngɛ bɛlɛ́ beejéle yɩ wɛ́ ákoosaaláa tɩmɛ́rɛ liideé. ");
INSERT INTO kdh_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Bɩdɩ́ŋa-rɔ gɛ waazʊ́ʊ nɩ́báánɩ na ɩkpa Yeésu icéle wɛ. ");
INSERT INTO kdh_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kpɔ́nɔ́ badaɖʊ kɩ faadɩ́nɩ nɛ́-dɛ́ɛ jíńgáárɩ́ wɩ́rɛ kaɖaa ńɖɛ gɛ wanbaaráa wɔɔgɔ́nɩ bɔbɔ́ɔ́zɩ Yeésu sɩsɩ: «Lé gɛ nyɔ́zɔɔlɛ́ɛ sɩsɩ ɖɩ́kpɩɩrɩ nya Fɛlɛ nɖɛ́ɛ-dɛ́ɛ jíńgáárɩ́ kíɖíím.» ");
INSERT INTO kdh_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ngɛ woobúsi wɛ sɩsɩ: «Ibó tɛ́ɛ́dɩ-daá ŋmáánɩ-jɔ́, ɩtɔ́ yɩ sɩsɩ kʊ́bɔnɩ́ sɩsɩ ɩdɛ́ɛ alɩwáátɩ waajʊ́ʊ, nyɛ́dɛ́ɛ gɛ ɩ́na ɩdɛ́ɛ wanbaaráa sɩ beɖi Fɛlɛ nɖɛ́ɛ-dɛ́ɛ jíńgáárɩ́.» ");
INSERT INTO kdh_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ngɛ wanbaaráa waalá wenbí nɔ́ɔ́ Yeésu waaŋmátɩ wɛ nɛ́ bakpɩ́ɩ́rɩ Fɛlɛ nɖɛ́ɛ-dɛ́ɛ jíńgáárɩ́. ");
INSERT INTO kdh_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kɩɩɖáánɩ nɛ́, ngɛ Yeésu na ɩwanbaaráa fuú na nɔɔ́lɛ bɔɔjɔ́ɔ sɩ beɖi kíɖíím. ");
INSERT INTO kdh_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Bɔwɛ bénɖíi nɛ́, ngɛ Yeésu sɩsɩ: «Ménveerím mɩ́ɩ toovonúm sɩsɩ mɩ́dáá kʊ́ɖʊḿ wánÿám ma.» ");
INSERT INTO kdh_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Wanbaaráa waazʊ́ʊ kaanɩŋá, ngɛ bɔ́nbɔɔzɩ́ yɩ kʊ́ɖʊḿ‑kʊ́ɖʊḿ bángáa ɖamá sɩsɩ: «Ɖádʊ́ʊ, mɔ́ɔ́ yáá wé; mɔ́ɔ́ yáá wé.» ");
INSERT INTO kdh_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ngɛ woobúsi wɛ sɩsɩ: «Mána weení wánÿám ma nɛ́ ɖénɖíi nyɩnɔɔ́ kʊ́ɖʊmɔ́ɔ-daá. ");
INSERT INTO kdh_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ɩrʊ́ Biyaalʊ́ wɛ́nɖɛɛ́ ńŋɩnáa baaŋmáa Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá ɩrɔ nɛ́, amá, nbusú na weení sɩ ɩyá yɩ nɛ́. A bátalʊ́rʊ bʊdʊ́ʊ, bɩraalá sóńcí.» ");
INSERT INTO kdh_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ńna gɛ Yudásɩ, weení wánÿám yɩ nɛ́, wɔɔbɔ́ɔ́zɩ sɩsɩ: «Mɔ́ɔ́ gɛ bɩgɛ́ɛ yáá wé kʊ́bɔnɩ́.» Ngɛ Yeésu woobúsi yɩ sɩsɩ: «Nyɔ́ɔ́dɔ́ ná.» ");
INSERT INTO kdh_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Bɔwɛ bénɖíi kíɖíím nɛ́, Yeésu wɔɔgbɔ́ɔ kpɔ́nɔ́, waazá Ɩsɔ́ɔ kɩrɔ bɩtɛ́ nɛ́, ngɛ wɛɛbɛlɩ́ kɩ icéle ɩwanbaaráa ɩtɔ́ sɩsɩ: «Ɩmʊ ɩtɔ́ɔ, mɔ́dɔ́nʊʊ́ nbɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Bɩlɛ́ bʊwɔ́rɔ́ nɛ́, ngɛ wɔɔgbɔ́ɔ sʊlʊ́m na kagbɔ́ɔ, waazá Ɩsɔ́ɔ bʊrɔ bɩtɛ́ nɛ́, ngɛ weejéle bɩ ɩwanbaaráa ɩtɔ́ wɛ sɩsɩ: «Mɩ́rɩ́ŋa ɩnyɔ́ɔ bɩ, ");
INSERT INTO kdh_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","káma, mɛ́dɛ́ɛ azimá nbɩlɛ́, bɩnáábɩ́lɛ́ keɖiyá azimá sɩ abɩ́rɩ ɩráa tuutúúma-rɔ na bɛcɛ́ wɛ bɛdɛ́ɛ alaháácɩ́wá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ménveerím mɩ́ɩ sɩsɩ mɔ́dɔ́ndɔnyɔɔ sʊlʊ́m bɩḿ hálɩ wɩ́rɛ wenɖé sɩ mɔgɔ́nyɔ́ɔ sʊlʊ́m kɩ́fabɩ mána mɩ́ɩ Majaa-dɛ́ɛ kowúrɔ́ɔ-daá nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Beedée jíńgáárɩ́ yéńdiwá basá Ɩsɔ́ɔ bɩtɛ́ nɛ́, ngɛ baalɩ́ɩ bɛɖɛ́ɛ Olivíyée tɩ́ɩ́nɩ bʊ́ʊ-daá. ");
INSERT INTO kdh_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ńna gɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Nuvoowú kɩna kɩdɩtɩŋa, mínzée iyéle ma, káma, baaŋmáa Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá sɩsɩ: “Mángʊ́ʊ ketirú na fééni ɩya ɖamá fuúre-daá.” ");
INSERT INTO kdh_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Amá, a méévé malɩ́ɩ ɩsɩɖáa-daá, mɛ́ndɛ́ɛ mɩ́ɩ nɩ́bááwʊ mobó Galilée laadɔ́ɔ-daá.» ");
INSERT INTO kdh_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ńna gɛ Pétro sɩsɩ: «Báa barɩ́ŋa bénzée beyéle nya, mɔ́ɔ́ médénzée kɛtɛngɛrɛ meyéle nya.» ");
INSERT INTO kdh_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ngɛ Yeésu wɔɔdɔ́ yɩ sɩsɩ: «Ménveerím nya toovonúm sɩsɩ nuvoowú kɩna kɩdɩtɩŋa, naanɩ́ na kalɩńbaawʊ́ ɩbɔ́ɔ nɛ́, nyɔ́njɔɔlɩ́ bʊrɔ nabúdoozo sɩsɩ nyáásɩ ma.» ");
INSERT INTO kdh_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ńna gɛ Pétro wɔɔdɔ́ yɩ sɩsɩ: «Báa bɩ́nbɔɔzɩ́ sɩsɩ mána nya ɖɩsɩ́, mɔ́dɔ́ndɔḿ sɩsɩ máásɩ nya.» Ngɛ wanbaaráa baaganáa rɩ́ŋa ɖʊɖɔ wɔɔdɔ́ bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Bána Yeésu boobó bɩlɛ́ hálɩ batála ɖɩdáarɛ bánÿaá ɖɛ sɩsɩ Gɛtɩsemanée nɛ́ ɖɩdaá. Ńna gɛ Yeésu wɔɔdɔ́ ɩwanbaaráa sɩsɩ: «Ɩjɔ́ɔ cé, na mobó lí magázʊlʊ Ɩsɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ngɛ wɛɛgbɛdɩ́na Pétro na Zebedée biyaalɩnáa lɛ́ɛ́nɩ́. Bɩdɛ́ɛ sáátɩ gɛ waazʊ́ʊ kaanɩŋá bɩka ɩlaakáarɩ kʊráa. ");
INSERT INTO kdh_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ńna gɛ wɔɔdɔ́ wɛ sɩsɩ: «Málaakáarɩ waazʊ́ʊ kaanɩŋá páá hálɩ bínÿelíi mazɩ́. Ɩjɔ́ɔ cé ɩcɔɔná mɩ́ɩ́zá mána mɩ́ɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ngɛ woodorí ɩdɩ ɩlɩ́ɩ bolíni cʊ́kɔ, ngɛ waabá ɩgʊjʊʊ́ adɛ ɩsʊ́lʊ sɩsɩ: «Majaa, a bɩ́nlám, laná ma bolíni na wahála kagbɔ́ɔ kana. Amá, bɩdɛkɛ́ɛ wenbí mɔ́zɔɔlɛ́ɛ nɛ́ ɩ́la ná, wenbí nyɔ́zɔɔlɛ́ɛ nɛ́ ɩ́la ná.» ");
INSERT INTO kdh_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yeésu wɔɔlɔ́ɔ ɩkábɩsɩ ɩwanbaaráa toozóóní-jɔ́ nɛ́, ngɛ wɔɔmɔɔná wɛ bónɖóm. Ngɛ wɔɔdɔ́ Pétro sɩsɩ: «A bɩlɛ́ mɩ́dábɩ́ɩ́zɩ ɩcɔɔná mɩ́ɩ́zá báa alɩwáátɩ cʊ́kɔ mána mɩ́ɩ? ");
INSERT INTO kdh_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ɩjɔɔná mɩ́ɩ́zá bɩka ɩsʊ́lʊ Ɩsɔ́ɔ na ɩ́kasála Sitáánɩ-dɛ́ɛ kɔdɔ́sɩ-daá. Ɩrʊ́ wɛná sɔɔlɩ́m sɩ ɩlá, amá, tɔnʊʊ́ tafɩ́ya.» ");
INSERT INTO kdh_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ngɛ woodorí ɩdɩ ɩlɩ́ɩ bolíni cʊ́kɔ sɩɩlɛ-dɛ́ɛ ɩsʊ́lʊ sɩsɩ: «Majaa, a ńdánlaná ma bolíni na wahála kagbɔ́ɔ kana, ngɛ bɩ́nbɔɔzɩ́ sɩsɩ mɔnyɔ́ɔ kɛ gɛ, nyɛ́dɛ́ɛ sɔɔlɩ́m ɩ́la ná.» ");
INSERT INTO kdh_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Waadákabɩsɩ ɩwanbaaráa-jɔ́ nɛ́, wɔɔdɔ́mɔɔná wɛ bónɖóm, káma, ɖóm caarɛ́ɛ wɛ. ");
INSERT INTO kdh_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ngɛ Yeésu weeyéle wɛ itorí ɩdɩ ɩlɩ́ɩ bolíni cʊ́kɔ ɖʊɖɔ ɩsʊ́lʊ toozo-dɛ́ɛ na tɔ́m bíya kʊ́ɖʊmáa bɛḿ. ");
INSERT INTO kdh_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ngɛ waagábɩsɩ wanbaaráa-jɔ́ ɩtɔ́ wɛ sɩsɩ: «Mɩ́bamáa ɖóm mɩ́nvɛɛzɩ́! Tɔ́ɔ, alɩwáátɩ wenkí sɩ bakpa Ɩrʊ́ Biyaalʊ́ bayaná alaháácɩ́-dɩnáa nɛ́ waajʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ɩgʊrʊ́! Ɖɩ́ɖɛ́ɛ! Ɩbɛ́ɛ, weení wánÿám ma nɛ́ waadála.» ");
INSERT INTO kdh_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Babamáa ŋmatɩrɛ gɛ wanbaaráa fuú na nɔɔ́lɛ-daá kʊ́ɖʊḿ bánÿaá yɩ sɩsɩ Yudásɩ nɛ́ waadála, ɩ́na ɩráa fuúre bágána tókobíwá na ɖáázɩ. Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa na Yahúúɖuwá-dɛ́ɛ kʊ́bɔnáa weegédíri ná wɛ. ");
INSERT INTO kdh_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yudásɩ, weení wánÿám yɩ nɛ́, waavʊ́ńgéveeri wɛ sɩsɩ: «Weení sɩ megbíríki yɩ mɛzɛ́ɛ yɩ nɛ́, Yeésu nbɩlɛ́. Ɩgba yɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ńna‑ńna gɛ waanʊ́ŋ ɩkɛ́ɖɛɛ Yeésu-jɔ́ ɩtɔ́ yɩ sɩsɩ: «Mɛ́ɛ́zɛ́ɛ nya kʊ́bɔnɩ́.» Ngɛ weegbíríki Yeésu. ");
INSERT INTO kdh_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ngɛ Yeésu wɔɔdɔ́ yɩ sɩsɩ: «Mɔɖɔndɩ, la wenbí nyɔ́ɔ́gɔ́nɩ lám nɛ́.» Ńna gɛ baaganáa woogóduu bakpa Yeésu. ");
INSERT INTO kdh_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Bɩnáábɩ́lɛ́ Yeésu na wenbá nɛ́ badaá kʊ́ɖʊḿ wɛɛgbɛ́ɛ ɩdɛ́ɛ tókobí ɩcɛ́sɩ Ɩsɔ́ɔ sarásɩ lanɖáa rɩ́ŋa-dɛ́ɛ kʊ́bɔnɩ́-dɛ́ɛ bɔwʊtá-dʊ́ʊ, ngɛ bɩɩjɛ́ ɩlɛ́ ɩnɩgbamʊʊ́. ");
INSERT INTO kdh_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ngɛ Yeésu wɔɔdɔ́ yɩ sɩsɩ: «Bɩsɩná nyɛ́dɛ́ɛ tókobí nɖʊ kɩɖɩdáarɛ, káma, wenbá barɩ́ŋa bónÿoonáa tókobí nɛ́, tókobí gɛ sɩ basɩná. ");
INSERT INTO kdh_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nyánmaazɩ́ sɩsɩ mádánbɩɩzɩ mavɩ́nɩ Majaa ikéjele ma malááyɩ́kawá yooráa tuutúúma fuwé fuú na náálɛ na bʊwɔ́rɔ́? ");
INSERT INTO kdh_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Bɩ́nlám nŋɩ́nɩ́ na wentí Ɩsɔ́ɔ-dɛ́ɛ tɔ́m waaŋmátɩ sɩsɩ bɩmɔɔ́na bɩlá bɩlɛ́ nɛ́ ikóódi.» ");
INSERT INTO kdh_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Alɩwáátɩ kɩḿ gɛ Yeésu wɔɔdɔ́ zamɔ́ɔ sɩsɩ: «Mɩ́ɩgálɩ́ɩ ɩkɔ́nɩ sɩ ɩkpa ma na tókobíwá na ɖáázɩ nyazɩ mɛ́gɛ́ɛ ɩráńgʊ́ʊ́rʊ́? Báa wɩ́rɛ wenɖé, mɔ́jɔɔ́ɔ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá gɛ mánwɩlɩ́ɩ ɩráa Ɩsɔ́ɔ-dɛ́ɛ tɔ́m, mɩ́dákpá ma. ");
INSERT INTO kdh_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Amá, bɩlɛ́ bɩrɩ́ŋa bɩɩlá gɛ na wentí anɖébiwá waaŋmáa nɛ́ ikóódi.» Ngɛ Yeésu-dɛ́ɛ wanbaaráa waaya ɖamá bese beyéle yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Wenbá baagba Yeésu nɛ́, bɛɛɖɛɛná yɩ Ɩsɔ́ɔ sarásɩ lanɖáa rɩ́ŋa-dɛ́ɛ kʊ́bɔnɩ́ Kayífu weení Mará wɩlɩɖáa na Yahúúɖuwá-dɛ́ɛ kʊ́bɔnáa tuuzée ɩdɛ́ɛ nɛ́-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pétro ɩlɛ́ woovu Yeésu ɩjɔɔ́na yɩ bolíni hálɩ sarásɩ lanɖʊ́ kʊ́bɔnɩ́-dɛ́ɛ ɖaána-daá, ɩsʊ́ʊ ɩcɔ́ɔ ɩ́na ɩlɛ́ ɩdɛ́ɛ bɔwʊtá-dɩnáa sɩ ɩna nŋɩ́nɩ́ sɩ bɩtɛná nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa na Yahúúɖuwá-dɛ́ɛ tɔmvʊʊráa kʊ́bɔnáa baaganáa wánjáádɩ sɩ bobuuná Yeésu tɔ́m na bakʊ yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Bodoyuú kúbuunátɩ, na bɩrɩ́ŋa ɩráa ɖabata waalɩzɩ́ seríya bʊbɔ́tɩ ńgɩ nɛ́. Kegbiirinɔ́ɔ gɛ ɩráa nɔɔ́lɛ wɔɔgɔ́nɩ ");
INSERT INTO kdh_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","bɔtɔ́ sɩsɩ: «Ɩrʊ́ ceení wɔɔdɔ́ sɩsɩ wánbɩɩzɩ́ ɩyɔ́ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga na ɩbɩ́sɩ ɩma kɛ wɛ náádoozo.» ");
INSERT INTO kdh_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ńna gɛ Ɩsɔ́ɔ sarásɩ lanɖáa rɩ́ŋa-dɛ́ɛ kʊ́bɔnɩ́ waagʊrʊ́ ɩtɔ́ yɩ sɩsɩ: «Nyɛ́vɛ́yɩ́na natɩ́rɩ sɩ nbúsi wentí ɩráa bana bónbuunáa nya nɛ́?» ");
INSERT INTO kdh_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Amá, Yeésu sumáa gɛ. Bɩnáábɩ́lɛ́ Ɩsɔ́ɔ sarásɩ lanɖáa rɩ́ŋa-dɛ́ɛ kʊ́bɔnɩ́ sɩsɩ: «Na Ɩsɔ́ɔ weezuú-dʊ́ʊ-dɛ́ɛ yɩ́ɖɛ-daá, mɔ́nbɔɔzɩ́ nya sɩsɩ nvééri-ɖáa a nyɔ́ɔ́ gɛ Lɛɛrʊ́, Ɩsɔ́ɔ Biyaalʊ́.» ");
INSERT INTO kdh_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yeésu woobúsi yɩ sɩsɩ: «Nyɔ́ɔ́dɔ́ná. Amá, wentí sɩ mevééri mɩ́ɩ nɛ́ gɛ sɩsɩ sɩɩná lɛlɛɛɖɔ́, mɩ́nnáa Ɩrʊ́ Biyaalʊ́ ɩjɔɔ́ɔ Ɩsɔ́ɔ yíko-dʊ́ʊ-dɛ́ɛ nʊ́ʊ́nɩ kíɖiiwú-rɔ. Mɩ́ndanáa yɩ wángalɩɩnáa ɩsɔ́ɔ́dáá wéngedím ŋmɩ́ńdɩ-rɔ.» ");
INSERT INTO kdh_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ńna gɛ Ɩsɔ́ɔ sarásɩ lanɖáa rɩ́ŋa-dɛ́ɛ kʊ́bɔnɩ́ wɛɛlɛrɩ́ igúsúúdi ɩtɔ́ sɩsɩ: «Wɛɛgbɛɛná Ɩsɔ́ɔ. Bidokúti bɩbɔ́ɔ́zɩ seríya-dʊ́ʊ ɖʊɖɔ. Mɩ́ɩ́nɩ́ɩ waaŋmátɩ ɩkpɛɛná Ɩsɔ́ɔ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mɩ́nmaazɩ́ sɩsɩ wé.» Ngɛ boobúsi sɩsɩ: «Ɩmɔɔ́na gɛ bakʊ yɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ngɛ bɔɔdɔ ndɔɔlɩmá waazá-daá, bamá yɩ cɔɖɩ́wá, nɛbɛ́rɛ ɩcɛ́ yɩ kadáázɩ ");
INSERT INTO kdh_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","bɩka bɔ́ndɔ́m sɩsɩ: «Lɛɛrʊ́, tɩrɩkɩ, weení waama ná nya.» ");
INSERT INTO kdh_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Bɩdɛ́ɛ sáátɩ, Pétro cɔɔ́ɔ asʊ tɔ́ɔ-rɔɔzɩ́. Ngɛ alʊ́ bɔwʊtá-dʊ́ʊ woogóduu ɩjɔ́ ɩtɔ́ yɩ sɩsɩ: «Nyɔ́ɔ́ ɖʊɖɔ nyágána Yeésu Galilée ńnɩ́ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Amá, wɔɔjɔ́ɔ́lɩ ɩráa rɩ́ŋa ɩzá-daá ɩtɔ́ sɩsɩ: «Máásɩ wentí nyɔ́ndɔ́m nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Sáátɩ wenkí wɛ́nɖɛɛ́ ɖɔɔ́ wɔnɔɔ́ nɛ́, kɩ́falʊ́ waana yɩ ifééri wenbá bɔwɛ ńna nɛ́ sɩsɩ: «Ceení kána Yeésu Nazarɛ́ɛtɩ ńnɩ́ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Waadásɩ ɩcɔ́ɔ́lɩ iɖuuná sɩsɩ: «Máásɩ ɩrʊ́ ɩmʊ́.» ");
INSERT INTO kdh_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Bɩɩdásɩ cʊ́kɔ nɛ́, wenbá bavʊnwɛ ńna nɛ́, boogóduu bɔtɔ́ Pétro sɩsɩ: «Toovonúm gɛ, nyɔ́ɔ́ ɖʊɖɔ nyɛ́gɛ́ɛ ɩdɛ́ɛ ɩrʊ́ gɛ, nyɛ́dɛ́ɛ ŋmatɩrɛ wánwɩlɩ́ɩ bɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ńna gɛ waaŋmátɩ sɩsɩ: «A ɖé bʊbɔ́tɩ gɛ mɛ́nbɛlɩ́ɩ, Ɩsɔ́ɔ ɩ́fɔ mánɩgbamʊʊ́. Máásɩ ɩrʊ́ ɩmʊ́.» Ngɛ kalɩńbaawʊ́ waajáŋ kɩbɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ngɛ Pétro wɔɔdɔ́ɔ́zɩ tɔ́m Yeésu wɔɔdɔ́ yɩ sɩsɩ: «Naanɩ́ na kalɩńbaawʊ́ ɩbɔ́ɔ nɛ́, nyɔ́njɔɔlɩ́ bʊrɔ nabúdoozo sɩsɩ nyáásɩ ma» nɛ́. Ngɛ waalɩ́ɩ ɩbá iwíi. ");
INSERT INTO kdh_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kiivé tɛ́ɛrɛ́‑tɛ́ɛrɛ́ nɛ́, Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa na Yahúúɖuwá-dɛ́ɛ kʊ́bɔnáa wɔɔjɔ́ɔ bacáa lomaazɛ́ na bakʊ Yeésu. ");
INSERT INTO kdh_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ngɛ bɔɔvɔ́kɩ yɩ nibé boboná yɩ becéle laadɔ́ɔ-dɛ́ɛ nɩ́baadɛɛrʊ́ Piláatɩ. ");
INSERT INTO kdh_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yudásɩ weení waayá Yeésu nɛ́, waana sɩsɩ baazɩ́ɩ́zɩ sɩsɩ bángʊ́ʊ Yeésu nɛ́, waalá mányɩ lé ɩkpɔ́ɔ wɛ́ ákoosaaláa tɩmɛ́rɛ liideé iboná icéle Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa na Yahúúɖuwá-dɛ́ɛ kʊ́bɔnáa ");
INSERT INTO kdh_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","sɩsɩ: «Máálá alaháácɩ́ mayá ɩrʊ́ weení ɩdalá nabʊ́rʊ nɛ́.» Amá, bɛlɛ́ boobúsi yɩ sɩsɩ: «Wentí waana ná ɖáa. Nyɔ́jɔ́ nbɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ngɛ Yudásɩ wooboná liideé ɩlɔ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá. Ngɛ wɛɛɖɛ́ɛ ɩɖʊ ɩdɩ nibiiré ɩsɩ́. ");
INSERT INTO kdh_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa wɔɔgbɔ́ɔ liideé bɔtɔ́ sɩsɩ: «Bɩdafa nɩ́bááwʊ sɩsɩ ɖɩ́ɖʊ́ liideé ana Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá kʊjɔ́ɔ́nɩ wɔ́rɔ́, káma, ɩrʊ́-dɛ́ɛ azimá liideé gɛ agɛ́ɛ.» ");
INSERT INTO kdh_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Baala ná ɖamá sááwʊ́ra bɩtɛ́ nɛ́, ngɛ bɔɔgbɔ́ɔ liideé amʊ́ bamʊ cʊ́ʊ maarʊ́-dɛ́ɛ laadɔ́ɔ bénbím ɩgɔma. ");
INSERT INTO kdh_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Bʊrɔɔzɩ́ gɛ hálɩ na sinje bánÿaá laadɔ́ɔ kɛḿ sɩsɩ azimá laadɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Bɩlɛ́ gɛ wentí anɖébi Yeremíya waaŋmátɩ nɛ́ woogóódi; tɩlɛ́ gɛ sɩsɩ: «Bɔɔgbɔ́ɔ wɛ́ ákoosaaláa tɩmɛ́rɛ liideé ńŋɩnáa Israyɛ́ɛlɩ bíya waamáázɩ sɩsɩ bɛfɛ́rɛ ɩrɔ nɛ́, ");
INSERT INTO kdh_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","bamʊ ná cʊ́ʊ maarʊ́-dɛ́ɛ laadɔ́ɔ ńŋɩnáa Ɖádʊ́ʊ waavʊ́ńzɩɩzɩ ma nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Booboná Yeésu laadɔ́ɔ-dɛ́ɛ nɩ́baadɛɛrʊ́-jɔ́ sɩ bafʊʊná yɩ, ngɛ ɩlɛ́ wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Nyɔ́ɔ́ gɛ Yahúúɖuwá-dɛ́ɛ wúro?» Ngɛ Yeésu woobúsi yɩ sɩsɩ: «Nyɔ́ɔ́dɔ́ ná.» ");
INSERT INTO kdh_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ngɛ Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa na Yahúúɖuwá-dɛ́ɛ kʊ́bɔnáa woobuuná yɩ tɔ́mwá ɖabata, amá, idobúsi wɛ natɩ́rɩ. ");
INSERT INTO kdh_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ńna gɛ Piláatɩ wɔɔdɔ́ yɩ sɩsɩ: «Ńdánnɩɩ wentí tɩrɩ́ŋa bónbuunáa nya nɛ́?» ");
INSERT INTO kdh_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Amá, Yeésu tobúsi yɩ báa natɩ́rɩ wentí tɩrɩ́ŋa waaŋmátɩ yɩ nɛ́ tɩrɔ hálɩ bɩbá bɩlá laadɔ́ɔ-dɛ́ɛ nɩ́baadɛɛrʊ́ Piláatɩ bítí. ");
INSERT INTO kdh_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Fɛlɛ nɖɛ́ɛ-dɛ́ɛ jíńgáárɩ́ báa wenkí, laadɔ́ɔ-dɛ́ɛ nɩ́baadɛɛrʊ́ wɛ́ndɛ́rɛ́jɛ́m sáráka-dʊ́ʊ kʊ́ɖʊḿ weení zamɔ́ɔ wɔɔzɔ́ɔ́lɩ sɩsɩ ɩ́cɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Bɩdɛ́ɛ sáátɩ nɛ́, sáráka-dʊ́ʊ kʊ́bɔnɩ́ naárʊ wɛ sáráka-daá, bánÿaá yɩ sɩsɩ Barabáasɩ. ");
INSERT INTO kdh_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Bɩnáábɩ́lɛ́ Piláatɩ wɔɔbɔ́ɔ́zɩ zamɔ́ɔ kiduuzée ńnaamʊ́ nɛ́ sɩsɩ: «Weení gɛ mɩ́zɔɔlɛ́ɛ sɩsɩ mɛ́jɛ. Barabáasɩ yáá Yeésu weení bánÿaá yɩ sɩsɩ Lɛɛrʊ́ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Káma, Piláatɩ nyɩ bɩlɛ́ sɩsɩ sʊ́ʊ́zɩ weeyele ná bakpa Yeésu becéle yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Sáátɩ wenkí Piláatɩ cɔɔ́ɔ tɔ́m ɖaavʊʊɖɛ́ ńna nɛ́ gɛ ɩɖɛɛlʊ́ weegédíri befééri yɩ sɩsɩ: «Nkaɖʊ nyɔ́nɔ́ɔ́ ɩrʊ́ ceení ɩzɩɩzɛ́ɛ nɛ́ ɩdɛ́ɛ tɔ́m-daá. Káma, nuvoowú kɩna mááná wahála ɖabata mɛ́dɛ́ɛ ɖoozire-daá ɩrɔɔzɩ́.» ");
INSERT INTO kdh_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa na Yahúúɖuwá-dɛ́ɛ kʊ́bɔnáa waadásɩ zamɔ́ɔ sɩsɩ kɩ́bɔɔzɩ Barabáasɩ-dɛ́ɛ cɛ́m bɩka bakʊ Yeésu. ");
INSERT INTO kdh_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Laadɔ́ɔ-dɛ́ɛ nɩ́baadɛɛrʊ́ waadásɩ ɩbɔ́ɔ́zɩ wɛ sɩsɩ: «Bɛlɛ́ɛ́nɩ́ badaá, weení gɛ mɩ́zɔɔlɛ́ɛ sɩsɩ mɛ́jɛ.» Ngɛ boobúsi yɩ sɩsɩ: «Barabáasɩ!» ");
INSERT INTO kdh_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Bɩnáábɩ́lɛ́ Piláatɩ wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «Nɛ́, we gɛ máláná Yeésu weení bánÿaá yɩ sɩsɩ Lɛɛrʊ́ nɛ́.» Barɩ́ŋa boobúsi yɩ sɩsɩ: «Báka yɩ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ!» ");
INSERT INTO kdh_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ngɛ waadásɩ ɩbɔ́ɔ́zɩ wɛ sɩsɩ: «Taalɩ́ wenkí gɛ waalá.» Amá, bɛlɛ́ baabá gɛ babamáa kóódi bɩ́njaarɩ́ sɩsɩ: «Báka yɩ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ!» ");
INSERT INTO kdh_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Piláatɩ waana sɩsɩ waawɩ́ɩ wɛ, bɩka bɩbamáa bʊ́ʊ kpáa nɛ́, ngɛ waajɩrɩ́ lɩ́m ɩsáŋ ɩnʊ́ʊ́zɩ zamɔ́ɔ ɩzá-daá ɩtɔ́ sɩsɩ: «Mánʊ́ʊ́nɩ fɛ́yɩ́ ɩrʊ́ ceení-dɛ́ɛ sɩ́m tɔ́m-daá yoo. Mɩ́jɔ́ nbɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ngɛ zamɔ́ɔ rɩ́ŋa woobúsi yɩ sɩsɩ: «Ɩdɛ́ɛ sɩ́m-dɛ́ɛ nɩgbamʊʊ́ fɔ́m íti ɖána ɖébíya-ɖɔ́rɔ́.» ");
INSERT INTO kdh_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ńna gɛ Piláatɩ wɛɛjɛ́ wɛ Barabáasɩ. Bɩɩga Yeésu ɩlɛ́ nɛ́, weeyéle bosúti yɩ agbáázá bɩtɛ́ nɛ́, ngɛ wɔɔgbɔ́ɔ yɩ icéle wɛ sɩsɩ bóbóná yɩ baká ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ngɛ laadɔ́ɔ-dɛ́ɛ nɩ́baadɛɛrʊ́ Piláatɩ-dɛ́ɛ sɔ́ɔ́jawá wooboná Yeésu ɩdɛ́ɛ kowuro-ɖugoré-daá; botúúzi sɔ́ɔ́jawá baaganáa rɩ́ŋa balára bamɩlɩná yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Baalɩzɩ́ yɩ ɩgbɩná izóóna nɛ́, bosúu yɩ tóko kɩ́sɛɛmʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ngɛ baalʊ́ʊ wʊláázɩ sɩjɔɔ́ɔ sɔwá‑sɔwá nɛ́ nyazɩ kowuro-vulɔɔ́ bɩlɛ́ bofu ɩgʊjʊʊ́; bacáa ɖɩgɛrɛ́ ɖeníka baɖʊ ɩnʊ́ʊ́nɩ kíɖiiwú-daá. Ngɛ boozóm waazá-daá bánmʊŋɛ́ yɩ bɔ́ndɔ́m sɩsɩ: «Ɖɛ́ɛ́zɛ́ɛ nya, Yahúúɖuwá-dɛ́ɛ wúro!» ");
INSERT INTO kdh_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bɔ́ndɔnáa yɩ ndɔɔlɩmá bɩka bɔ́ngbɔwʊ́ʊ ɖɩgɛrɛ́ ɖeníka bánmám ɩgʊjʊʊ́-daá. ");
INSERT INTO kdh_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Baamʊ́ŋ yɩ bɩtɛ́ nɛ́, ngɛ baalɩzɩ́ yɩ tóko boozúu yɩ nɛ́, babɩsɩná ɩdɛ́ɛ-ndɩ bosúu yɩ. Ngɛ bɛɛɖɛɛná yɩ sɩ bakága ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Baalɩ́ɩ bɛ́nɖɛɛ́ nɛ́, bɛɛgɛ́tɩ abaalʊ́ naárʊ, ɩgɛ́ɛ Sirɛ́ɛnɩ tɛ́ɛ́dɩ-daá ńnɩ́ gɛ. Bánÿaá yɩ sɩsɩ Simɔ́ɔnɩ. Ngɛ baagba yɩ ɖóóle ɩsʊ́ʊ Yeésu-dɛ́ɛ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Baadála ɖɩdáarɛ wenɖé bánÿaá ɖɛ sɩsɩ Gɔlɩgóóta nɛ́, bugutoluú gɛ sɩsɩ Kʊjʊʊ́ Bɔɔrɔɔ́ ɖɩdáarɛ. ");
INSERT INTO kdh_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Baadála ńna nɛ́, ngɛ baava yɩ sʊlʊ́m baaja ná faadɩ́nɩ nyɛ́nɩ ńdɩ nɛ́ sɩsɩ ɩ́nyɔ́ɔ. Waaɖɩ́m nɛ́, idetísi ɩnyɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Baagá yɩ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ bɩtɛ́ nɛ́, ngɛ bɔɔdɔ tɛ́tɛ́ ɩgbɩná-rɔ batára yɛ ɖamá. ");
INSERT INTO kdh_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ngɛ beedí bɔcɔ́ɔ ńna bénveríi ɩrɔ. ");
INSERT INTO kdh_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ngɛ baaŋmáa kpálɩfɔ́ɔ-rɔ wenbí-rɔ baagʊ yɩ nɛ́, bosúsi ɩgʊjʊʊ́-rɔ; tɩlɛ́ gɛ sɩsɩ: «Ceení gɛ Yeésu, Yahúúɖuwá-dɛ́ɛ wúro.» ");
INSERT INTO kdh_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ngɛ baagá ɩráńgʊ́ʊ́ráa nɔɔ́lɛ batasɩná yɩ. Kʊ́ɖʊḿ igíɖiiwú-rɔ, waaganáa ɩnɩbɩɩwʊ́-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nɩ́baaɖɛɛráa wándʊ́ʊ́dɩ yɩ, bánmʊŋɛ́ yɩ, ");
INSERT INTO kdh_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","bɩka bɔ́ndɔ́m sɩsɩ: «Nyɔ́ɔ́ weení nyɔ́nÿɔ́m Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga nbɩ́sɩ nma kɛ wɛ náádoozo nɛ́, nyádɩtɩŋa lɛɛ nyádɩ a nyɛ́gɛ́ɛ Ɩsɔ́ɔ Biyaalʊ́, bɩka ngédi ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ!» ");
INSERT INTO kdh_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bɩlɛ́ ɖʊɖɔ gɛ Mará wɩlɩɖáa na Yahúúɖuwá-dɛ́ɛ kʊ́bɔnáa na Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa wánmʊŋɛ́ yɩ bɔ́ndɔ́m yɩ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Wɛɛlɛ́ɛ baaganáa, amá, ɩ́dánbɩɩzɩ ɩlɛ́ɛ ɩdɩ. A ɩgɛ́ɛ Israyɛ́ɛlɩ wúro, íkedi lɛlɛɛɖɔ́ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ na ɖɩfa yɩ toovonúm! ");
INSERT INTO kdh_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ɩsɔ́ɔ gɛ waava toovonúm nɛ́, Ɩsɔ́ɔ ɩ́kɔnɩ ɩlɛ́ɛ yɩ lɛlɛɛɖɔ́ a ɩzɔɔlɛ́ɛ yɩ, káma, wɔɔdɔ́ sɩsɩ ɩgɛ́ɛ Ɩsɔ́ɔ Biyaalʊ́ gɛ!» ");
INSERT INTO kdh_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bɩlɛ́ nɔ́ɔ́ gɛ bɩkpɛdɩ́na ɩráńgʊ́ʊ́ráa wenbá baagá ɩ́na wɛ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ nɛ́ bándʊ́ʊ́dɩ yɩ. ");
INSERT INTO kdh_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kpɔɔ ɩdaawʊ́ kéréfu fuú na natɩ́lɛ nbó ɖaanɩ́ŋa kéréfu natúdoozo, bɩɩlá temenuú laadɔ́ɔ rɩ́ŋa-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ɖaanɩ́ŋa kéréfu natúdoozo bɩlɛ́ gɛ Yeésu woogóo bɩcáárɩ sɩsɩ: «Elíi, Elíi, lemá sabakɩtááni.» Bugutoluú sɩsɩ: «Mɛ́dɛ́ɛ Ɩsɔ́ɔ, mɛ́dɛ́ɛ Ɩsɔ́ɔ, ngbaalá gɛ nyɛ́ɛ́jɛ́ ma ndálɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Wenbá bɔwɛ ńna gɛ baanɩ́ɩ nɛ́, badaá nɛbɛ́rɛ sɩsɩ: «Elíya gɛ wánÿaá.» ");
INSERT INTO kdh_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ngɛ badaá naárʊ waajáŋ ise ɩkɔ́gbɔ́ɔ kɩcɛ́ ilíi sʊlʊ́m nyɩ́gáázɩ ńbɩ-daá ɩkpɔ́ɔ isúu ɖɩgɛrɛ́ ɖeníka nɔɔ́-daá ɩkpáázɩ Yeésu nɔɔ́-jɔ́ sɩsɩ ɩ́nyɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Baaganáa sɩsɩ: «Ɩzɩ́ŋ ɖɩbɛ́ɛ sɩsɩ Elíya wɔ́ngɔnɩ́ ɩlɛ́ɛ yɩ?» ");
INSERT INTO kdh_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Amá, Yeésu woodókoo bɩcáárɩ, ngɛ weedísi weezuú. ");
INSERT INTO kdh_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ngɛ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá láámílé waadára nabʊ́lɛ kɔgbɔɔ ɩsɔ́ɔ́dáá ngɔ́nɩ adɛ. Adɛ weezéle, bʊ́tángbalɩ́nɩ ɩfɛ́ɛ, ");
INSERT INTO kdh_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","bɔɔláánɩ ifulú bɩka Ɩsɔ́ɔ-dɛ́ɛ ɩráa ɖabata báńzɩ́ḿ nɛ́ ifé. ");
INSERT INTO kdh_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yeésu weevé ɩlɩ́ɩ ɩsɩɖáa-daá nɛ́, bɛlɛ́ ɖʊɖɔ baalɩ́ɩ, ngɛ baazʊ́ʊ Yerusalɛ́ɛm Ɩsɔ́ɔ-dɛ́ɛ tɛ́ɛ́dɩ-daá balɩzɩ́ badɩ bawɩ́lɩ ɩráa ɖabata. ");
INSERT INTO kdh_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Róóma sɔ́ɔ́ja kʊ́bɔnɩ́ na sɔ́ɔ́jawá baaganáa bénveríi Yeésu nɛ́, baana adɛ weezéle na wenbí bɩrɩ́ŋa bɩɩlá nɛ́, ngɛ nɩdáárɛ kʊ́bɔńɖɛ waazʊ́ʊ wɛ bɔtɔ́ sɩsɩ: «Toovonúm, ɩrʊ́ ceení kɛ́ɛ Ɩsɔ́ɔ Biyaalʊ́ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Aláa ɖabata wɛ ńna bagazɩ́ŋɛ́ɛ bolíni bɛgɛbɛɛ́na. Ɖoo Galilée laadɔ́ɔ-daá gɛ boogóvú Yeésu bángalám yɩ bɔwʊtá. ");
INSERT INTO kdh_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Badaá, bɛɛ Marɩyáma Magɩdaláa alʊ́, Marɩyáma Yaakúbu na Ísifu bɔgɔɔ na Zebedée biyaalɩnáa ɩgɔɔ bɔwɛ ńna. ");
INSERT INTO kdh_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ɖaanɩ́ŋa waalá nɛ́, ɖɔ́ɔ́lɛ-dʊ́ʊ bánÿaá yɩ sɩsɩ Ísifu ɩgɛ́ɛ Arɩmatée tɛ́ɛ́dɩ-daá ńnɩ́ bɩka ɩgɛ́ɛ Yeésu-dɛ́ɛ wanbaarʊ́ ɖʊɖɔ nɛ́, waadála. ");
INSERT INTO kdh_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ɩrʊ́ ɩmʊ́ woobó ɩmɔɔná Piláatɩ ɩbɔ́ɔ́zɩ yɩ Yeésu tɔnʊʊ́. Ngɛ Piláatɩ waava nɩ́bááwʊ sɩsɩ bécéle yɩ kɩ. ");
INSERT INTO kdh_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ísifu wɔɔgbɔ́ɔ kɩ nɛ́, ngɛ woogoodi ná kɩ kásáŋá. ");
INSERT INTO kdh_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ngɛ wɔɔgbɔ́ɔ kɩ ɩɖʊ bɔɔlááwʊ kɩ́falʊʊ́ waabáa kɩ ɩdɩ bʊ́tangbalʊʊ́-daá nɛ́ kɩdaá; ngɛ weebiláázɩ bʊ́ʊ́rɛ kʊ́bɔńɖɛ ɩtɔ bɔɔlááwʊ nɔɔ́. Bɩlɛ́ bʊwɔ́rɔ́ nɛ́, ngɛ wɛɛɖɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Bɩdɛ́ɛ sáátɩ kɩḿ, Marɩyáma Magɩdaláa alʊ́ na Marɩyáma lí ńnɩ́ bɔwɛ ńna, bɔjɔɔ́ɔ bɔɔlááwʊ ɩzá-daá. ");
INSERT INTO kdh_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kiivé nɛ́, bángbɩɩrɩ́ Fɛɛzɩrɛ wɩ́rɛ kifé nɛ́ nbɩlɛ́, ngɛ Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa na Faríizi ńba booyóózi bobó Piláatɩ-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ngɛ bɔɔdɔ́ yɩ sɩsɩ: «Kʊ́bɔnɩ́, ɖɔ́ɔ́dɔ́ɔ́zɩ sɩsɩ bʊbɔtʊ́ʊ ɩmʊ́ wɔɔdɔ́ ɩ́na waazá nɛ́ sɩsɩ: “Wɛ́ náádoozo wɩ́rɛ ménvém.” ");
INSERT INTO kdh_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Bɩlɛ́ nɛ́, fa nɩ́bááwʊ befére bɔɔlááwʊ hálɩ wɛ́ náádoozo na ɩwanbaaráa ɩ́kɔkɔ́nɩ baŋmɩ́ɩ́lɩ yɩ bɩka bɔtɔ́ zamɔ́ɔ sɩsɩ weevé ɩlɩ́ɩ ɩsɩɖáa-daá. Bʊbɔ́tɩ kegbiirinɔ́ɔ ńdɩ tɩna tɩ́ngɩlɩ́ɩ kaɖaa ńdɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ngɛ Piláatɩ weevééri wɛ sɩsɩ: «Bɛɛ fereɖáa. Iboná wɛ befére bɔɔlááwʊ ńŋɩnáa mɩ́zɔɔlɛ́ɛ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ngɛ boobó sɩ befére bɔɔlááwʊ. Baaɖáázɩ bʊ́ʊ́rɛ kʊ́bɔńɖɛ boovu kɩnɔɔ́-rɔ nɛ́, na a naárʊ weedekiná ɖɛ, batɩlɩ́. ");
INSERT INTO kdh_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Beeɖi Fɛɛzɩrɛ wɩ́rɛ kifé aláháɖɩ tɛ́ɛrɛ́‑tɛ́ɛrɛ́ nɛ́, Marɩyáma Magɩdaláa alʊ́ na Marɩyáma lí ńnɩ́ boobó sɩ bɛkɛ́bɛ́ɛŋ bɔɔlááwʊ. ");
INSERT INTO kdh_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ńna‑ńna gɛ adɛ waabá biséle. Ɖádʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ malááyɩ́ka waalɩ́ɩ ɩsɔ́ɔ́dáá ití ibiláázɩ bʊ́ʊ́rɛ ití ɩcɔ́ɔ ɖɩrɔ. ");
INSERT INTO kdh_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Wénɖée nyazɩ wɩlɔɔ́ bɩka ɩgbɩná izóóna nɛ́ aabá avʊlʊmáa párɩ́‑párɩ́. ");
INSERT INTO kdh_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ngɛ bɩɩɖʊ sɔ́ɔ́jawá fereɖáa nɩdáárɛ bénzelíi, bɩka babɩ́sɩ nyazɩ ɩsɩɖáa bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Amá, malááyɩ́ka wɔɔdɔ́ aláa sɩsɩ: «Mɩ́nyɔ́ɔ́ ɩ́kanɩ́ɩ nɩdáárɛ. Mányɩ sɩsɩ Yeésu baagá yɩ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ nɛ́ gɛ mɩ́njáádɩ. ");
INSERT INTO kdh_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ɩvɛ́yɩ́ cé, káma, weevé ɩlɩ́ɩ ɩsɩɖáa-daá ńŋɩnáa waavʊ́ńdɔḿ nɛ́. Ɩgɔ́nɩ ɩbɛ́ɛ lénlé baavʊ́ńvɩɩzɩ yɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ibó ɖasam ifééri ɩwanbaaráa sɩsɩ weevé ɩlɩ́ɩ ɩsɩɖáa-daá. Wɛ́ndɛ́ɛ mɩ́ɩ nɩ́bááwʊ ɩɖɛ́ɛ Galilée. Ńna gɛ mɩ́ngɔmɔɔnáa yɩ. Wentí sɩ mevééri mɩ́ɩ nɛ́ nbɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Na nɩdáárɛ na wenbi‑niíni kʊ́bɔńɖɛ gɛ boodoózi ná balɩ́ɩ bɔɔlááwʊ-jɔ́ bese bobó bekéveeri Yeésu-dɛ́ɛ wanbaaráa laabáárʊ kɩḿ. ");
INSERT INTO kdh_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ngɛ nɔɔ́ kʊ́ɖʊḿ nɛ́, Yeésu wɔɔgɔ́nɩ ɩkɛ́tɩ wɛ ɩtɔ́ wɛ sɩsɩ: «Mɛ́ɛ́zɛ́ɛ mɩ́ɩ!» Ngɛ boogóduu ɩjɔ́ bosóm ɩnʊvɔ́-dɛ bokúu yɩ tɛ́ɛ́dɩ. ");
INSERT INTO kdh_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ngɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Ɩ́kanɩ́ɩ nɩdáárɛ. Ibó ifééri mogoobíya sɩsɩ bɛ́ɖɛɛ Galilée. Ńna gɛ bánganáa ma.» ");
INSERT INTO kdh_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Aláa bɛḿ bɔwɛ nɩ́bááwʊ-daá nɛ́, ngɛ fereɖáa-daá nɛbɛ́rɛ woobó tɛ́ɛ́dɩ-daá bafa Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa wenbí bɩrɩ́ŋa bɩɩlá nɛ́-dɛ́ɛ báárʊ. ");
INSERT INTO kdh_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Bɛlɛ́ boodúúzi ɖamá bána Yahúúɖuwá-dɛ́ɛ kʊ́bɔnáa balá sááwʊ́ra nɛ́, ngɛ baava sɔ́ɔ́jawá fereɖáa bɛḿ liidebɔná, ");
INSERT INTO kdh_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","befééri wɛ sɩsɩ: «Wentí sɩ ɩŋmátɩ nɛ́ nɖɔ́: “Ɩdɛ́ɛ wanbaaráa wɔɔgɔ́nɩ nuvoowú baŋmɩ́ɩ́lɩ yɩ sáátɩ wenkí ɖónɖóm nɛ́.” ");
INSERT INTO kdh_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","A ngʊ́ tɔ́m waadála laadɔ́ɔ-dɛ́ɛ nɩ́baadɛɛrʊ́, ɖɔ́ɔ́ sɩ ɖɩlɩzɩ́ na yɩ bugutoluú na mɩ́nyɔ́ɔ́ mídónÿuú nɔwɛ́ya nakɩ́rɩ.» ");
INSERT INTO kdh_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ngɛ bɛlɛ́ baamʊ liideé balá ńŋɩnáa baaŋmátɩ wɛ nɛ́. Bɛdɛ́ɛ ŋmatɩrɛ ɖɩḿ ɖɩrɔ, hálɩ na sinje bánŋmatɩ́ tɔ́m tɩḿ Yahúúɖuwá lɔwʊtáá. ");
INSERT INTO kdh_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Bɩɩga wanbaaráa fuú na naárʊ nɛ́, bɛɛɖɛ́ɛ Galilée bʊ́ʊ wenkí Yeésu waavʊ́ńveeri wɛ sɩsɩ bóbo nɛ́-kɩrɔ. ");
INSERT INTO kdh_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Baana yɩ nɛ́, ngɛ boozóm ɩnʊvɔ́-dɛ bokúu yɩ tɛ́ɛ́dɩ, amá, badaá nɛbɛ́rɛ waalá síka. ");
INSERT INTO kdh_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ngɛ Yeésu woogóduu bɔjɔ́ ɩtɔ́ wɛ sɩsɩ: «Baava ma yíko rɩ́ŋa ɩsɔ́ɔ́dáá na adɛ laadɔ́ɔ-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Bɩlɛ́ nɛ́, ibó ɩbɩsɩná yíri báa wenkí-dɛ́ɛ ɩráa mɛ́dɛ́ɛ wanbaaráa. Ilíri wɛ lɩ́m-daá ɩsɔ wɛ túúbá lɩ́m na Caáwʊ na Biyaalʊ́ʊ na Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga-dɛ́ɛ yɩ́ɖɛ-daá. ");
INSERT INTO kdh_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ɩwɩ́lɩ wɛ bofu balá wentí tɩrɩ́ŋa máázɩ́ɩ́zɩ mɩ́ɩ nɛ́. Bɩɩga nɛ́, mɔ́ɔ́ mɔ́wɛ mɩ́jɔ́ gɛ báa wɩ́rɛ wenɖé hálɩ ɖúúlínya kʊrʊ́ʊ.»");
INSERT INTO kdh_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Laabáárʊ Kífeńgi kɩ́nŋmatɩ́ Yeésu Krísto Ɩsɔ́ɔ Biyaalʊ́-dɛ́ɛ tɔ́m waabaazɩ ná lé nɛ́ nɖɔ́: ");
INSERT INTO kdh_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Baaŋmáa Anɖébi Esáya-dɛ́ɛ tákaraɖá-daá sɩsɩ: «Méndiríi mɛ́dɛ́ɛ tɩndʊ́ʊ itóróbó bɩka ɩkpára nyánɩ́bááwʊ. ");
INSERT INTO kdh_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Lowú nakɩ́rɩ wɔɔvɔ tɛɛwʊ́lɔ́ɔ́-daá sɩsɩ: “Ɩgbɩ́ɩ́rɩ Ɖádʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ nɩ́bááwʊ, Ɩzɩ́ɩ́zɩ ɩdɛ́ɛ níbeyísi.”» ");
INSERT INTO kdh_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ńŋɩnáa baaŋmáa wenbí nɛ́, Yaayá waaɖʊ ɩlɩ́ɩ tɛɛwʊ́lɔ́ɔ́-daá wánlám waázu sɩsɩ ɩráa ɩ́kɛɛ balakásɩ belíri wɛ lɩ́m-daá bɔsɔ wɛ túúbá lɩ́m na Ɩsɔ́ɔ ɩcɛ́ bɛdɛ́ɛ alaháácɩ́wá. ");
INSERT INTO kdh_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yudée laadɔ́ɔ-daá ńba rɩ́ŋa na Yerusalɛ́ɛm ńba rɩ́ŋa wónboɖé Yaayá-jɔ́ bándɩ́m bɛdɛ́ɛ alaháácɩ́wá ɩráa-daá bɩka ɩlɛ́ wénliríi wɛ Yɔrɔdáanɩ buwá-dɛ́ɛ lɩ́m-daá. ");
INSERT INTO kdh_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Raakúḿ fʊ́ńdɩ-dɛ́ɛ tóko gɛ Yaayá sóóna, bɩka tɔ́nɖɛ ɖanbára nyaarɛ́ɛ ɩdɩnɔɔ́-daá. Bɩɩga nɛ́, igíɖíím gɛ cɩ́báánɩ na tʊ́ʊ́nɩ. ");
INSERT INTO kdh_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yaayá wánlám waázu sɩsɩ: «Naárʊ kɛrɛŋɛ mɔ́wɔ́rɔ́, ɩlɛ́ waagɩ́lɩ ma. Mádatála molúúzi mádɩ malɩzɩ́ yɩ ɩdakaḿwá. ");
INSERT INTO kdh_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mɔ́ɔ́ nɛ́, lɩ́m-daá gɛ ménliríi mɩ́ɩ mɔ́nzɔ́ɔ mɩ́ɩ túúbá lɩ́m, amá, ɩlɛ́ sɩ ilíri mɩ́ɩ Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga-daá gɛ.» ");
INSERT INTO kdh_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Bɩdɛ́ɛ sáátɩ gɛ Yeésu waagálɩ́ɩ́ná Nazarɛ́ɛtɩ Galilée laadɔ́ɔ-daá ɩkɔ́nɩ Yaayá ilíri yɩ lɩ́m-daá Yɔrɔdáanɩ buwá-daá. ");
INSERT INTO kdh_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Sáátɩ wenkí sɩ ɩkálɩɩ lɩ́m-daá ɖɔ́ nɛ́, ngɛ waana ɩsɔ́ɔ́dáá wɛ́nvɛɛ́ nabʊ́lɛ, bɩka Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga wéngedím nyazɩ ɖuvóóre kʊ́fʊlʊńɖɛ bɩlɛ́ kɔkɔ́nɩ kosóm ɩrɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ngɛ baanɩ́ɩ lowú nakɩ́rɩ ɩsɔ́ɔ́dáá sɩsɩ: «Nyɔ́ɔ́ gɛ Mebiyaalʊ́ máábá mɔ́zɔɔlɛ́ɛ yɩ nɛ́; nyɔ́rɔ́ gɛ mááɖʊ́ mɛ́dɛ́ɛ sɔɔlɩ́m rɩ́ŋa.» ");
INSERT INTO kdh_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ńna‑ńna gɛ Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga wooboná Yeésu tɛɛwʊ́lɔ́ɔ́-daá. ");
INSERT INTO kdh_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ngɛ wɔɔjɔ́ɔ tɛɛwʊ́lɔ́ɔ́-daá ńna wɛ́ nɛɛ́lɛ bɩka Sitáánɩ ɩyɩ́ yɩ kɔdɔ́sɩ. Ɩ́na fanáńdɩ gɛ bɩka malááyɩ́kawá wánlám yɩ bɔwʊtá. ");
INSERT INTO kdh_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Baagba Yaayá wɔ́rɔ́ nɛ́, Yeésu waalɩ́ɩ ńna ɩɖɛ́ɛ Galilée wénveerím ɩráa Ɩsɔ́ɔ-dɛ́ɛ Laabáárʊ Kífeńgi sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","«Alɩwáátɩ waadála, Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ waajʊʊná mɩ́ɩ; ɩlá túúbá ɩkɛ́ɛ mɩ́lakásɩ bɩka ɩfa Laabáárʊ Kífeńgi toovonúm.» ");
INSERT INTO kdh_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Wɩ́rɛ Yeésu wɛ wánnʊŋɛ́ Galilée lɩɩrɛ́ kʊ́bɔńɖɛ nɔɔ́-jɔ́ gɛ waana Simɔ́ɔnɩ na igoobú Andirée bɔwɛ bɔ́nlɔ́ɔ biruú, káma, bɛgɛ́ɛ biríni lɔɔráa gɛ. ");
INSERT INTO kdh_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ńna gɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Igóvú ma, bɩka mabɩsɩná mɩ́ɩ wenbá bánÿaá ɩráa sɩsɩ bófú ma nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ńna‑ńna gɛ beeyéle biríni, bofu yɩ. ");
INSERT INTO kdh_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Woodúu bolíni cʊ́kɔ nɛ́, ngɛ waana Yaakúbu, Zebedée biyaalʊ́ na igoobú Yʊháánɩ bɛlɛ́ ɖʊɖɔ bɔwɛ kpɩ́ɩ́rʊʊ́-daá bɔ́nnyɔɔzɩ́ bɛdɛ́ɛ biríni. ");
INSERT INTO kdh_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ńna‑ńna gɛ waayáa wɛ. Ngɛ bɛlɛ́ beeyéle bajaa Zebedée na ɩdɩmɛlanɖáa, bofu yɩ. ");
INSERT INTO kdh_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Boobó basʊ́ʊ Kapɛrɩnawʊ́m tɛ́ɛ́dɩ-daá. Fɛɛzɩrɛ wɩ́rɛ nɛ́, ngɛ woobó Ɩsɔ́ɔ ɖaazɛɛɖɛ́, ɩbáázɩ ɩráa wɩlɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ngɛ ɩdɛ́ɛ wɩlɩ́ɩ waabá bɩlá ɩráa bítí; káma, wánwɩlɩnáa yíko wenkí Ɩsɔ́ɔ weejéle yɩ kɩ nɛ́ gɛ. Ɩ́dánwɩlɩ́ nyazɩ Mará wɩlɩɖáa. ");
INSERT INTO kdh_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ɩrʊ́ naárʊ ɩjáŋ ɩwɛ bɛdɛ́ɛ Ɩsɔ́ɔ ɖaazɛɛɖɛ́ ńna. Ɩrʊ́ ɩmʊ́ ɩwɛná zííni. ");
INSERT INTO kdh_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Ɩrʊ́ ɩmʊ́ wóngoó sɩsɩ: «We gɛ nyɔ́zɔɔlɛ́ɛ na ɖáa, Yeésu Nazarɛ́ɛtɩ ńnɩ́. Nyɔ́ɔ́gɔ́nɩ sɩ ndɛlɛ́sɩ ɖáa yáá wé. Mányɩ weení nyɛ́gɛ́ɛ nɛ́; ɩrʊ́ Ɖacɩrɩ‑cɩrɩ ńnɩ́ Ɩsɔ́ɔ weegédíri yɩ nɛ́ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ńna gɛ Yeésu waagazɩ́ zííni ɩtɔ́ kɩ sɩsɩ: «Su tɔ́m bɩka nlɩ́ɩ ɩrɔɔzɩ́ nɖɛ́ɛ!» ");
INSERT INTO kdh_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ngɛ zííni woojuúdi ɩrʊ́ ɩmʊ́, kɩlɩ́ɩ ɩrɔ na ɖugoogoore kʊ́bɔńɖɛ. ");
INSERT INTO kdh_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ngɛ bɩɩlá barɩ́ŋa nɩdáárɛ hálɩ bɔ́nbɔɔzɩ́ ɖamá sɩsɩ: «Tɔ́m wentí gɛ tɩna ɖɔ́. Wánwɩlɩ́ɩ tɔ́m kɩ́fatɩ na yíko. Bɩkpɛdɩ́na zííniwá tɩtɩŋa wánlám wentí wɔ́nbɔɔzɩ́ tɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ngɛ ɩyɩ́ɖɛ waajáŋ ɖɩsɛ́ɛ báa lé, Galilée laadɔ́ɔ rɩ́ŋa-daá. ");
INSERT INTO kdh_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ńna gɛ waajáŋ ɩlɩ́ɩ Ɩsɔ́ɔ ɖaazɛɛɖɛ́ ɩ́na Yaakúbu na Yʊháánɩ bobó Simɔ́ɔnɩ na Andirée bɛdɛ́ɛ ɖaána-daá. ");
INSERT INTO kdh_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Baadála nɛ́, bɔɔmɔɔná Simɔ́ɔnɩ nɔɔzɔ́ɔ fɩ́nɛ́ɛ wánnyaadɩ́ tɔnʊʊ́ ɩbá kizoláa. Ńna gɛ bɔɔgbɔ́ɔ befééri Yeésu. ");
INSERT INTO kdh_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ngɛ Yeésu woogóduu ɩjɔ́ ɩɖɔ́kɩ ɩnʊ́ʊ́nɩ ɩkʊ́sɩ yɩ. Ńna gɛ waawáa. Ngɛ waagʊrʊ́ ɩɖʊ wɛ kíɖíím. ");
INSERT INTO kdh_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ɖaanɩ́ŋa-rɔ wɩ́sɩ waazála nɛ́, bɔɔgɔná wenbá barɩ́ŋa bánnyaadɩ́ nɛ́ na zííniwá-dɩnáa Yeésu-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tɛ́ɛ́dɩ rɩ́ŋa woodúúzi ɖaḿ wɔnɔɔ́. ");
INSERT INTO kdh_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ngɛ Yeésu waawáázɩ kʊdɔndɩnáa ɖabata bɛ́nÿɛlɛ́ŋ na kʊdɔmɩ́nɩ ndɩ‑ndɩ nɛ́, bɩka ɩɖɔ́ɔ zííniwá ɖabata ɩráa-rɔɔzɩ́, bɩka ídénÿelí zííniwá wánŋmatɩ́, káma, tɩlɛ́ tɩnyɩ weení ɩgɛ́ɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Asʊbáa kidefe tá nɛ́, Yeésu weevé ɩɖɛ́ɛ faɖáma-daá wángazʊlʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simɔ́ɔnɩ na wenbá nɛ́ baagʊrʊ́ batɩ́nɩ Yeésu wɔ́rɔ́; ");
INSERT INTO kdh_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","baana yɩ nɛ́, ngɛ beevééri yɩ sɩsɩ: «Ɩráa rɩ́ŋa wánjáádɩ nya.» ");
INSERT INTO kdh_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ngɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Ɖɩ́ɖɛ́ɛ ɖeelí tɛɛbíízi sɩdɩláána nɛ́ sɩdaá megéveeri Laabáárʊ Kífeńgi ńna ɖʊɖɔ, káma, bʊrɔɔzɩ́ gɛ máagálɩɩ.» ");
INSERT INTO kdh_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ngɛ weegíli Galilée laadɔ́ɔ rɩ́ŋa-daá wénveerím ɩráa Laabáárʊ Kífeńgi bɛdɛ́ɛ Ɩsɔ́ɔ ɖaazɛɛɖɛ́wá-daá bɩka wɔ́nɖɔwʊ́ʊ zííniwá. ");
INSERT INTO kdh_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Cɛnɩŋa nɛkɛ́rɛ woogóduu Yeésu-jɔ́ kosóm ɩnʊvɔ́-dɛ kánvɩnɩ́ yɩ sɩsɩ: «A nyɔ́zɔɔlɛ́ɛ, nyánbɩɩzɩ́ nÿéle mawáa malá ɖacɩrɩ‑cɩrɩ.» ");
INSERT INTO kdh_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ngɛ kɔdɔ́m waabá bɩlá Yeésu kʊnyɔḿ. Ńna gɛ Yeésu wɔɔvɔ́ ɩnʊ́ʊ́nɩ itekiná kɛ ɩtɔ́ kɛ sɩsɩ: «Ɩɩ́n, mɔ́zɔɔlɛ́ɛ, waa nlá ɖacɩrɩ‑cɩrɩ.» ");
INSERT INTO kdh_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ngɛ ńna‑ńna cɛnɩ́tɩ waalɩ́ɩ kɔrɔ. Kaawáa kalá ɖacɩrɩ‑cɩrɩ. ");
INSERT INTO kdh_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ngɛ Yeésu waabá ɩbásɩ kɛ ɩtɔ́ kɛ sɩsɩ kékpe. ");
INSERT INTO kdh_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ngɛ wɔɔdɔ́tɔḿ kɛ sɩsɩ: «Bɛɛ́ɛ! Nkefééri naárʊ wenbí bɩɩlá nɛ́, amá, bo Ɩsɔ́ɔ sarásɩ lanɖʊ́ ɩna wenbí nyɔ́jɔɔ́ɔ nɛ́, na nlá sarɔ́ɔ wenká Múúsá wɔɔdɔ́ sɩsɩ bála nɛ́, na báa weení ɩtɩlɩ́ sɩsɩ nyááwáa.» ");
INSERT INTO kdh_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ɩrʊ́ ɩmʊ́ wɛɛɖɛ́ɛ, ngɛ waajáŋ ɩbáázɩ laabáárʊ kɩḿ feerím bɩ́njaarɩ́ báa lé bɩka wándɩ́m ɩráa wenbí bɩɩlá nɛ́. Biiyéle Yeésu tándalɩɩ tɛ́ɛ́dɩ natɩ́rɩ-daá ɩráa ɩna yɩ. Wánmʊsɩ́ ɩdɩ tɛ́ɛ́dɩ wɔ́rɔ́ lénlé ɩráa fɛ́yɩ́ nɛ́ gɛ, bɩka ɩráa wángalɩɩnáa báa lé bɔ́ngɔnɩ́ ɩjɔ́. ");
INSERT INTO kdh_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Bɩɩlá wɛ́-bíya nɛ́, ngɛ Yeésu waabɩ́sɩ Kapɛrɩnawʊ́m; ɩráa waanɩ́ɩ sɩsɩ ɩwɛ ɖaána. ");
INSERT INTO kdh_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ngɛ ɩráa tuutúúma woodúúzi ɩdɛ́ɛ, hálɩ bɩkpɛdɩ́na ɖaḿ wɔnɔɔ́, ɖɩdáarɛ tanvɛ́yɩ́. Bɩka Yeésu wánŋmatɩ́ wɛ Ɩsɔ́ɔ-dɛ́ɛ tɔ́m. ");
INSERT INTO kdh_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ɩráa nɔɔ́náázá waagázʊʊ gaala‑gáálɔɔ́ bɔkɔ́gɔ́ná Yeésu. ");
INSERT INTO kdh_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Zamɔ́ɔ-rɔ nɛ́, bádánbɩɩzɩ sɩ basʊ́ʊ kɛ boboná Yeésu-jɔ́; ngɛ baadʊlʊ́ bɔɔwʊ́ ɖaḿ ɩwɛ kɩdaá nɛ́ kɩgʊjʊʊ́-daá lénlé ɖéyí‑ɖéyí Yeésu sɩ́ŋɛ́ɛ nɛ́ betísi ɩrʊ́ ɩmʊ́ na kɩgbáláwʊ ɩvɩ́nɛ́ɛ kɩrɔ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yeésu waana bɛdɛ́ɛ toovonúm fáa nɛ́, ngɛ wɔɔdɔ́ gaala‑gáálɔɔ́ sɩsɩ: «Móbú, mɛ́ɛ́jɛ́ nya nyɛ́dɛ́ɛ alaháácɩ́wá.» ");
INSERT INTO kdh_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mará wɩlɩɖáa nɛbɛ́rɛ wɛ bɔjɔɔ́ɔ ńna nɛ́, bɔwɛ bɔ́ndɔ́m badaá sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Ngbaalá gɛ ɩrʊ́ ceení wánŋmatɩ́ bɩlɛ́. Wɛ́ngbɛɛnáa Ɩsɔ́ɔ. Weení wánbɩɩzɩ kʊ ɩcɛ́ ɩráa-dɛ́ɛ alaháácɩ́wá bɩdɛkɛ́ɛ Ɩsɔ́ɔ riké.» ");
INSERT INTO kdh_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yeésu waajáŋ ɩtɩlɩ́ wentí bánmaazɩ́ badaá nɛ́, ngɛ wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «We-rɔ gɛ mɩ́nmaazɩ́ míwenbé-daá bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ɩrʊ́ ɩtɔ́ gaala‑gáálɔɔ́ sɩsɩ: “Bɛɛjɛ́ nya nyɛ́dɛ́ɛ alaháácɩ́wá,” yáá ɩtɔ́ yɩ sɩsɩ: “Kʊrʊ́ ngbɔ́ɔ nyɛ́dɛ́ɛ kɩgbáláwʊ nnʊ́ŋ, bɩlɛ́ɛ́nɩ́ bɩlɔwʊtáá, wentí fɛ́yɩ́na káálɛ.” ");
INSERT INTO kdh_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Amá, mɔ́zɔɔlɛ́ɛ ɩtɩlɩ́ sɩsɩ Ɩrʊ́ Biyaalʊ́ wɛná yíko ɩcɛ́ ɩráa bɛdɛ́ɛ alaháácɩ́wá adɛ laadɔ́ɔ-rɔ cé.» ");
INSERT INTO kdh_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ngɛ wɔɔdɔ́ gaala‑gáálɔɔ́ sɩsɩ: «Nyɔ́ɔ́, kʊrʊ́! Kpɔɔ nyágɩgbáláwʊ ngbé nyɛ́dɛ́ɛ.» ");
INSERT INTO kdh_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ngɛ waagʊrʊ́ ɩsɩ́ŋ, ɩcáŋ ɩsɛlɩ́ ɩgɩgbáláwʊ ɩlɩ́ɩ báa weení ɩzá-daá. Ngɛ bɩɩbá bɩlá báa weení bítí bánzám Ɩsɔ́ɔ, bánŋmatɩ́ sɩsɩ: «Kɛtɛngɛrɛ ɖádanáa ta ńŋɩnáa ɖɔ́.» ");
INSERT INTO kdh_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yeésu waadálɩɩ ibó lɩɩrɛ́ kʊ́bɔńɖɛ-jɔ́. Ngɛ zamɔ́ɔ rɩ́ŋa wɔ́ngɔnɩ́ ɩjɔ́ bɩka wánwɩlɩ́ɩ kɩ. ");
INSERT INTO kdh_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Wɔɔgɔ́nɩ wɛ́nɖɛɛ́ nɛ́, waana Léévi Alɩfée biyaalʊ́ ɩjɔɔ́ɔ tikée ɖaajɛnɖɛ́. Ngɛ weevééri yɩ sɩsɩ: «Kovu ma.» Ngɛ waagʊrʊ́ ifu yɩ. ");
INSERT INTO kdh_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ngɛ Yeésu woobó Léévi-dɛ́ɛ wénɖíi kíɖíím. Tikée mʊʊráa ɖabata na alaháácɩ́-dɩnáa wɔɔgɔ́nɩ batasɩná ɩ́na ɩwanbaaráa; káma, bɔɔɖɔ́ɔ bovóo yɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Faríizi ńba-daá Mará wɩlɩɖáa waana Yeésu na alaháácɩ́-dɩnáa na tikée mʊʊráa bónÿoozí bénɖíi kíɖíím nɛ́, ngɛ bɔ́nbɔɔzɩ́ Yeésu-dɛ́ɛ wanbaaráa sɩsɩ: «Bɩyáásɩ́ gɛ mɩ́gʊ́bɔnɩ́ na alaháácɩ́-dɩnáa na tikée mʊʊráa bónÿoozí bénɖíi kíɖíím.» ");
INSERT INTO kdh_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yeésu waanɩ́ɩ bɔ́nbɔɔzɩ́ nɛ́, ngɛ ɩlɛ́ wɔɔdɔ́ wɛ sɩsɩ: «Kʊdɔndɩnáa wánjáádɩ kʊ lákʊ́ta, alaafɩ́ya-dɩnáa baafɛ́yɩ́ na yɩ. Mɔ́dɔkɔ́nɩ sɩ mayáa wenbá bazɩɩzɛ́ɛ nɛ́, amá, alaháácɩ́-dɩnáa-rɔ gɛ mɔ́ɔ́gɔ́nɩ.» ");
INSERT INTO kdh_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Wɩ́rɛ Yaayá-dɛ́ɛ wanbaaráa na Faríizi ńba wɛ bɔ́nvɔkɩ́ nɔɔ́; ngɛ bɔɔgɔ́nɩ Yeésu-jɔ́ bɔbɔ́ɔ́zɩ sɩsɩ: «We-rɔ gɛ Yaayá-dɛ́ɛ wanbaaráa na Faríizi ńba-dɛ́ɛ ńba wɔ́nvɔkɩ́, ngɛ nyɛ́dɛ́ɛ ńba tɔ́nvɔkɩ.» ");
INSERT INTO kdh_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Weetáhárʊ ɖɔndɩnáa mɔɔ́na bɔfɔ́kɩ nɔɔ́ sáátɩ wenkí bána weetáhárʊ nɛ́? Sáátɩ wenkí kɩrɩ́ŋa bána weetáhárʊ nɛ́, bádánbɩɩzɩ bɔfɔ́kɩ. ");
INSERT INTO kdh_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Amá, Sáátɩ nakɩ́rɩ wɔ́ngɔnɩ́, bɔ́ngɔnɩ́ balɩzɩ́ yɩ bɔlɔwʊtáá. Bɩdɛ́ɛ sáátɩ gɛ bɔ́nvɔkɩ́. ");
INSERT INTO kdh_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Naárʊ fɛ́yɩ́ wɔ́ngbɔwʊ́ʊ bɩsaawʊ́ kedeyɔ́ɔ kɩ́falɔɔ́ ɩtɔ ná tóko kɩ́bɩńgɩ. Tɩ́fa, bɩsaawʊ́ kɩ́falʊʊ́ wánjɩrɩ́ɩ tóko kɩ́bɩńgɩ gɛ, bɔɔwʊ́ ɩnyɔ́ɔ́zɩ kɩwála. ");
INSERT INTO kdh_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ngʊ́ bɩlɛ́ gɛ bódónzuu sʊlʊ́m kɩ́fabɩ bɩdabɩɩ tá bɩtɛ́ nɛ́ tɔ́nɖɛ furuú kɩ́bɩńgɩ-daá, tɩ́fa kɩ́nÿáa gɛ sʊlʊ́m ɩbɩ́rɩ adɛ, tɔ́nɖɛ furuú ɩlá ásáráwʊ́. Amá, bónzuú sʊlʊ́m kɩ́fabɩ bɩdabɩɩ tá bɩtɛ́ nɛ́ tɔ́nɖɛ furuú kɩ́falʊʊ́-daá gɛ.» ");
INSERT INTO kdh_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Wɩ́rɛ Fɛɛzɩrɛ wɩ́rɛ neɖére gɛ Yeésu wɛ́ndɛsɩ́ bilée fásɩ. Ngɛ ɩdɛ́ɛ wanbaaráa waabáázɩ bilée kpɛɛ́ na nɩ́bááwʊ. ");
INSERT INTO kdh_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ńna gɛ Faríizi ńba waana bɩlɛ́ nɛ́, bɔɔdɔ́ Yeésu sɩsɩ: «Bɛɛ nyɛ́dɛ́ɛ wanbaaráa wánlám wenbí ɖɛ́dɛ́ɛ Mará tafa nɩ́bááwʊ sɩsɩ bála Fɛɛzɩrɛ wɩ́rɛ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Mɩ́dákala tá kɛtɛngɛrɛ wenbí Ɖáwʊɖa waalá ɩwɛ takáásɩ́-daá nyɔɔ́sɩ wɛná ɩ́na wenbá nɛ́? ");
INSERT INTO kdh_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nŋɩ́nɩ́ waazʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá, sarásɩ lanɖáa rɩ́ŋa-dɛ́ɛ kʊ́bɔnɩ́ Abiyatáarɩ-dɛ́ɛ sáátɩ, ɩtɔ́ɔ kpɔ́nɔ́wá baalá Ɩsɔ́ɔ sarɔ́ɔ nɛ́? Hálɩ ɩfa tɩ ɩ́na wenbá nɛ́ bɔtɔ́ɔ ɖʊɖɔ. Ngʊ́ Ɩsɔ́ɔ sarásɩ lanɖáa riké gɛ bɩɩva sɩsɩ bɔ́tɔɔ.» ");
INSERT INTO kdh_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ngɛ Yeésu weevééri wɛ sɩsɩ: «Ɩrʊ́-rɔ gɛ baalá Fɛɛzɩrɛ wɩ́rɛ, bɩdɛkɛ́ɛ Fɛɛzɩrɛ wɩ́rɛ-rɔ gɛ baalá ɩrʊ́. ");
INSERT INTO kdh_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Bɩlɛ́ nɛ́, Ɩrʊ́ Biyaalʊ́ wɛná yíko Fɛɛzɩrɛ wɩ́rɛ-rɔ.» ");
INSERT INTO kdh_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yeésu waadásʊʊ Ɩsɔ́ɔ ɖaazɛɛɖɛ́; abaalʊ́ naárʊ fʊnwɛ ńnaamʊ́ biilí ɩnʊ́ʊ́nɩ. ");
INSERT INTO kdh_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ngɛ ɩráa wɛ bɛbɛɛ́na Yeésu sɩsɩ wánwaazɩ́ ɩrʊ́ ɩmʊ́ Fɛɛzɩrɛ wɩ́rɛ yáá nŋɩ́nɩ́, na boyuú kúbuunátɩ bobuuná. ");
INSERT INTO kdh_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ngɛ Yeésu wɔɔdɔ́ abaalʊ́ ɩmʊ́ biilí ɩnʊ́ʊ́nɩ nɛ́ sɩsɩ: «Kʊrʊ́ nzɩ́ŋ lɔwʊtáá ɖɔ́.» ");
INSERT INTO kdh_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ngɛ wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «We gɛ bɩɩva nɩ́bááwʊ sɩsɩ bála Fɛɛzɩrɛ wɩ́rɛ. Bɩɩva nɩ́bááwʊ sɩsɩ bála kazɔ́ɔ ńbɩ yáá bɩdaavé nɛ́; sɩsɩ bɛ́lɛɛ ɩrʊ́ yáá bákʊ́ yɩ gɛ.» Amá, bodobúsi natɩ́rɩ. ");
INSERT INTO kdh_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ńna gɛ Yeésu wɛɛbɛ́ɛ́ŋ wɛ ɩlára ɩmɩ́lɩ na baaná. Bɛdɛ́ɛ wenbi-ɖóni talá yɩ niíni kpátáá. Ngɛ wɔɔdɔ́ abaalʊ́ ɩmʊ́ sɩsɩ: «Fɔ nyánʊ́ʊ́nɩ.» Ngɛ ɩlɛ́ wɔɔvɔ́ ɩnʊ́ʊ́nɩ, ngɛ ɩnʊ́ʊ́nɩ waawáa. ");
INSERT INTO kdh_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Faríizi ńba waalɩ́ɩ Ɩsɔ́ɔ ɖaazɛɛɖɛ́ nɛ́, ngɛ bɛɛgbɛdɩ́ botúúzi ɖamá bána wúro Eróodi-dɛ́ɛ ńba balá sááwʊ́ra nŋɩ́nɩ́ báta balá na bakʊ Yeésu nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yeésu wɛɛɖɛɛ ná Galilée lɩɩrɛ́ kʊ́bɔńɖɛ fáráńdɩ́ ɩ́na ɩwanbaaráa. Ngɛ zamɔ́ɔ kʊ́bɔńgɩ waalɩ́ɩ kivóo yɩ. Zamɔ́ɔ kɩḿ kɩɩgálɩ́ɩ́ná Galilée na Yudée laadásɩ-rɔ, Yerusalɛ́ɛm tɛ́ɛ́dɩ-daá, Idúmée laadɔ́ɔ, na laadásɩ sɩgɔwɛ ná Yɔrɔdáanɩ buwá kɩdɛ́sʊ́ʊ nɛ́; na Tíiri na Sidɔ́ɔnɩ laadásɩ-rɔ. Zamɔ́ɔ kʊ́bɔńgɩ kɩḿ kɩɩnɩ́ɩ wenbí bɩrɩ́ŋa wánlám nɛ́, ngɛ kɩɩgɔ́nɩ ɩjɔ́. ");
INSERT INTO kdh_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ńna gɛ Yeésu wɔɔdɔ́ ɩwanbaaráa sɩsɩ bɔ́kɔ́ná kpɩ́ɩ́rʊʊ́ ɩmʊ́ ɩkpa ɩcɔ́ɔ kɩdaá na zamɔ́ɔ ɩ́kányʊʊ́ yɩ. ");
INSERT INTO kdh_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Káma, Yeésu waawáázɩ ɩráa ɖabata, biiyéle wenbá barɩ́ŋa bɔwɛná kʊdɔmɩ́nɩ nɛ́, bánzalɩ́ɩ ɩrɔɔzɩ́ na boyuú betekiná yɩ. ");
INSERT INTO kdh_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Wenbá bɔwɛná zííniwá nɛ́, bánnáa Yeésu nɛ́, bónzoḿ ɩnʊvɔ́-dɛ bɩka bóngoó sɩsɩ: «Nyɔ́ɔ́ gɛ Ɩsɔ́ɔ Biyaalʊ́.» ");
INSERT INTO kdh_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Amá, Yeésu wángazɩ́ɩ zííniwá wánbasɩ́ tɩ sɩsɩ tíkeyéle batɩlɩ́ weení ɩmʊ́ ɩgɛ́ɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Bɩlɛ́ bʊwɔ́rɔ́ nɛ́, ngɛ Yeésu waagba bʊ́ʊ-daá ɩyáa wenbá ɩzɔɔlɛ́ɛ wɛ nɛ́, bɛlɛ́ bɔkɔ́nɩ ɩjɔ́. ");
INSERT INTO kdh_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ngɛ waalɩzɩ́ badaá ɩráa fuú na nɔɔ́lɛ ɩbɩsɩná wɛ ɩdɛ́ɛ tɩndɩnáa sɩ bɔ́cɔɔ ɩjɔ́ bɩka wéndiríi wɛ bángalám waázu, ");
INSERT INTO kdh_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","bɩka ɩfa wɛ yíko bɔ́nɖɔwʊ́ʊ zííniwá. ");
INSERT INTO kdh_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ɩráa fuú na nɔɔ́lɛ bana gɛ waalɩzɩ́: Simɔ́ɔnɩ, weení waava yɩ yɩ́ɖɛ sɩsɩ Pétro nɛ́, ");
INSERT INTO kdh_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yaakúbu, Zebedée biyaalʊ́ na Yʊháánɩ Yaakúbu igoobú wenbá waava wɛ yɩ́ɖɛ sɩsɩ Bowanɛrgɛ́ɛsɩ nɛ́; bugutoluú sɩsɩ: Ɩráa bɛdɛ́ɛ baaná cɔɔ́ɔ nyazɩ kpálálayɔ́ɔ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andirée, Filíipu, Barɩtelemíi, Maatéwu, Tomáa, Yaakúbu Alɩfée biyaalʊ́, Tadée, Simɔ́ɔnɩ kezée-bú ");
INSERT INTO kdh_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Yudásɩ Isikariyóo, weení waayá Yeésu nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Bɩlɛ́ bɩwɔ́rɔ́ nɛ́, Yeésu na ɩwanbaaráa baagábɩ́sɩ ɖaána, ngɛ zamɔ́ɔ woodótuuzi hálɩ biiyéle badabɩ́ɩ́zɩ beɖi kíɖíím. ");
INSERT INTO kdh_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ɩdɛ́ɛ ńba waanɩ́ɩ bɩlɛ́ nɛ́, bɔɔgɔ́nɩ sɩ bɔkpɔ́ɔ yɩ na ɖóni bekpená, káma, bɔwɛ bɔ́ndɔ́m sɩsɩ bɩvɛ́yɩ́ yɩ ɖéyí‑ɖéyí. ");
INSERT INTO kdh_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mará wɩlɩɖáa baagálɩ́ɩ́ná Yerusalɛ́ɛm bɔkɔ́nɩ nɛ́ sɩsɩ: «Ɩwɛná zííni Bɛlɩzebúuli; na zííniwá-dɛ́ɛ wúro gɛ wɔ́nɖɔɔnáa zííniwá.» ");
INSERT INTO kdh_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ngɛ Yeésu waayáa wɛ ɩŋmatɩná wɛ na tɔmgɛɛzɩrɛ sɩsɩ: «Bɩ́nlám nŋɩ́nɩ́ na Sitáánɩ ɩɖɔ́ɔ Sitáánɩ. ");
INSERT INTO kdh_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","A laadɔ́ɔ nɛkɛ́rɛ-dɛ́ɛ ɩráa wónÿoó ɖamá, laadɔ́ɔ kɛḿ kádánbɩɩzɩ kɔcɔ́ɔ kɔdɔyɔ́. ");
INSERT INTO kdh_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","A koobíre neɖére-daá ɩráa tánnɩɩ ɖamá, koobíre ɖɩḿ ɖɩ́dánbɩɩzɩ ɖɩcɔ́ɔ ɖɩdɔyɔ́. ");
INSERT INTO kdh_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","A bɩlɛ́ gɛ Sitáánɩ wónÿoó ɩdɩ, Sitáánɩ waadára ɩdɩ nbɩlɛ́, ńna nɛ́, ɩdɔ́njɔwʊ́, asée wɛɛdɛlɛ́ŋ. ");
INSERT INTO kdh_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Naárʊ tánbɩɩzɩ ɩsʊ́ʊ ɩrʊ́ ɖóni ńnɩ́-dɛ́ɛ, ɩŋmɩ́ɩ́lɩ ɩgbɩná bɩka ɩdafʊ́ńvɔkɩ yɩ nibé. Asée wɔɔvɔ́kɩ yɩ nibé na ɩbɩ́ɩ́zɩ ɩŋmɩ́ɩ́lɩ ɩgbɩná rɩ́ŋa ɩɖaána-daá. ");
INSERT INTO kdh_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ménveerím mɩ́ɩ toovonúm sɩsɩ Ɩsɔ́ɔ wɛ́njɛ́m ɩráa-dɛ́ɛ alaháácɩ́wá rɩ́ŋa bánlám nɛ́, bɩ́na kʊdʊ́ʊ́nɩ rɩ́ŋa bándʊ́ʊ́dɩ yɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Amá, weení waadʊ́ʊ Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga nɛ́, Ɩsɔ́ɔ tɛ́njɛḿ yɩ kɛtɛngɛrɛ. Bɩdɛ́ɛ alaháácɩ́ wɔ́njɔɔnáa yɩ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Bɔwɛ bɔ́ndɔ́m sɩsɩ ɩwɛná zííni nɛ́-rɔɔzɩ́ gɛ Yeésu wɔ́ndɔ́m bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yeésu ɩgɔɔ na igoobíya bɔɔgɔ́nɩ bagazɩ́ŋɛ́ɛ asʊ, ngɛ beedíri sɩsɩ bákayaa yɩ. ");
INSERT INTO kdh_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Zamɔ́ɔ wɔɔjɔ́ɔ kɩlára kɩmɩlɩná yɩ. Ngɛ beevééri yɩ sɩsɩ: «Bɛɛ ngɔɔ na ngoobíya aláa na abaaláa bɔwɛ asʊ bánjáádɩ nya.» ");
INSERT INTO kdh_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ngɛ woobúsi wɛ sɩsɩ: «Weení gɛ mɔgɔɔ na mogoobíya.» ");
INSERT INTO kdh_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Wɛɛbɛ́ɛ́ŋ wenbá bɔjɔɔ́ɔ bamɩláána yɩ bisúlúki nɛ́, ngɛ sɩsɩ: «Bɛɛ mɔgɔɔ na mogoobíya nɖɔ́; ");
INSERT INTO kdh_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","weení wánlám Ɩsɔ́ɔ-dɛ́ɛ sɔɔlɩ́m nɛ́, ɩlɛ́ gɛ mogoobú alʊ́, mogoobú abaalʊ́ na mɔgɔɔ.» ");
INSERT INTO kdh_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yeésu waadábaazɩ wɩlɩ́ɩ lɩɩrɛ́ kʊ́bɔńɖɛ nɔɔ́-jɔ́. Ngɛ zamɔ́ɔ kʊ́bɔńgɩ woodúúzi ɩjɔ́ hálɩ biiyéle waagba ɩcɔ́ɔ kpɩ́ɩ́rʊʊ́-daá lɩɩrɛ́ kʊ́bɔńɖɛ-rɔ. Bɩka zamɔ́ɔ rɩ́ŋa wɛ kɩzɩ́ŋɛ́ɛ adɛ lɩ́m nɔɔ́‑nɔɔ́. ");
INSERT INTO kdh_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ngɛ waawɩ́lɩ wɛ tɔ́mwá ɖabata na tɔmgɛɛza. Ɩdɛ́ɛ wɩlɩ́ɩ-daá, wɔɔdɔ́ wɛ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Iwélesi ma. Wɩ́rɛ gɛ ɩrʊ́ naárʊ woobó ɩvɔɔ́-daá kúɖúúdi larɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Wánlarɩ́ɩ nɛ́, ngɛ natɩ́rɩ waazála nɩ́bááwʊ‑nɩ́bááwʊ, ngɛ siḿsi wɔɔgɔ́nɩ siɖi tɩ. ");
INSERT INTO kdh_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Natɩ́rɩ waazála bɔ́-daá lénlé tɛ́ɛ́dɩ tɔɖɔ́ɔ nɛ́, ngɛ tɩɩjáŋ tɩnyɔ, káma, tɛ́ɛ́dɩ telím. ");
INSERT INTO kdh_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Wɩ́sɩ wɔɔgɔ́nɩ sɩsáa nɛ́, ngɛ bɩɩnyɔ́ɔ tɩ, ngɛ tɩɩwɩ́lɩ, káma, wóózi tafɩ́ya. ");
INSERT INTO kdh_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kúɖúúdi natɩ́rɩ waazála sɔɔzɔ́ɔ́zɩ-daá, ngɛ sɔɔzɔ́ɔ́zɩ waabɩ́ɩ sɩnyʊʊ́ tɩ. Ngɛ tɩdaɖʊ bíya. ");
INSERT INTO kdh_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Natɩ́rɩ waazála tɛ́ɛ́dɩ kazɔ́ɔ ndɩ-daá. Ngɛ tɩɩnyɔ, tɩkʊrʊ́, tɩkpa, tɩɖʊ bíya. Tikú nakɩ́rɩ ákoosaaláa, nakɩ́rɩ niídoozo nakɩ́rɩ ɖʊɖɔ nɩɩ́nʊ́wá.» ");
INSERT INTO kdh_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ngɛ Yeésu waadásɩ sɩsɩ: «Weení ɩwɛná nɩgbamʊʊ́ sɩ ɩnɩ́ɩ nɛ́, ɩlɛ́ ɩ́nɩɩ.» ");
INSERT INTO kdh_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yeésu waalɩ́ɩ kpɔ́mɔ́ɔ́ iriké nɛ́, ngɛ ɩdɛ́ɛ wanbaaráa fuú na nɔɔ́lɛ na wenbá bovóo yɩ nɛ́ bɔɔbɔ́ɔ́zɩ yɩ tɔ́m tɔmgɛɛza-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ngɛ woobúsi wɛ sɩsɩ: «Mɩ́nyɔ́ɔ́ nɛ́, Ɩsɔ́ɔ waava mɩ́ɩ sɩsɩ ɩ́tɩ́lɩ́ ɩdɛ́ɛ kowúrɔ́ɔ-dɛ́ɛ ásíírí. Bɩɩga asʊ ńba nɛ́, tɔmgɛɛza gɛ bánnɩɩ́, ");
INSERT INTO kdh_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","na “Bɛbɛɛ́na, amá, bádánnáa, bénwelesí, amá, bádánnɩɩ bugutoluú na bɔ́kɔkɔ́nɩ balá túúbá bɛkɛ́ɛ balakásɩ bɩka Ɩsɔ́ɔ ɩcɛ́ bɛdɛ́ɛ alaháácɩ́wá.”» ");
INSERT INTO kdh_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ngɛ Yeésu wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «A bɩlɛ́, mɩ́danɩ́ɩ tɔmgɛɛzɩrɛ ɖɩna ɖugutoluú? Bɩlɛ́ nɛ́ nŋɩ́nɩ́ gɛ sɩ ɩlá na ɩnɩ́ɩ tɔmgɛɛza rɩ́ŋa. ");
INSERT INTO kdh_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kúɖúúdi laraɖʊ́ wánlarɩ́ɩ Ɩsɔ́ɔ-dɛ́ɛ tɔ́m gɛ. ");
INSERT INTO kdh_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wenbá bánnɩɩ́ tɔ́m tɩḿ bɩka bádánnɩɩ tugutoluú nɛ́ cɔɔ́ɔ gɛ nyazɩ nɩ́bááwʊ‑nɩ́bááwʊ lé kúɖúúdi waazála nɛ́. Sitáánɩ wɔ́ngɔnɩ́ gɛ ɩkpɛzɩ́ wenbí booɖúu bewenbé-daá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Wenbá bánnɩɩ́ Ɩsɔ́ɔ-dɛ́ɛ tɔ́m na bacáŋ bamʊ tɩ na wenbi‑niíni nɛ́, cɔɔ́ɔ gɛ nyazɩ bɔ́-daá lénlé kúɖúúdi waazála nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Amá, wóózi fɛ́yɩ́ nɛ́, tídénleeri. A bɩgɛ́ɛ nɔwɛ́ya yáá fúkúḿsi waadála wɛ Ɩsɔ́ɔ-dɛ́ɛ tɔ́m-rɔ, bánbɩsɩ́ bɔwɔ́rɔ́ gɛ. ");
INSERT INTO kdh_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Wenbá bénwelesí Ɩsɔ́ɔ-dɛ́ɛ tɔ́m, na beyéle ɖúúlínya lomaazɛ́ na ɖɔ́ɔ́lɛ-dɛ́ɛ ayiila na kɔɖɛyɩ́wá ndɩ‑ndɩ ɩnyʊʊ́ tɩ bɩka tɩ́dánɖʊ́ʊ bíya nɛ́, cɔɔ́ɔ gɛ nyazɩ sɔɔzɔ́ɔ́zɩ-daá lénlé kúɖúúdi waazála nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Wenbá bánnɩɩ́ Ɩsɔ́ɔ-dɛ́ɛ tɔ́m bɩka bánnɩɩ́ tugutoluú nɛ́ cɔɔ́ɔ gɛ nyazɩ tɛ́ɛ́dɩ kazɔ́ɔ ńdɩ wentí tɩdaá kúɖúúdi waazála nɛ́. Bʊrɔ gɛ bánɖʊ́ʊ bíya; tikú nakɩ́rɩ ákoosaaláa, nakɩ́rɩ niídoozo, nakɩ́rɩ nɩɩ́nʊ́wá. ");
INSERT INTO kdh_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ngɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: bɔ́dɔ́nzɔḿ fɩtɩ́la na bɔkpɔ́ɔ gbégídi bofu kɩrɔ yáá basɩ́ɩ kɩ gáɖó-dɛ. Amá, bɔ́ngbɔwʊ́ʊ kɩ gɛ batɩ́nɩ ɩsɔ́ɔ́dáá na bilósi báa weení ɖaána-daá. ");
INSERT INTO kdh_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Káma, nabʊ́rʊ fɛ́yɩ́ bɩmʊ́sɛ́ɛ bɩ́dánlɩɩ bana bɩ nɛ́, cáńfáná ásíírí bádándɩlɩ́ kɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Weení ɩwɛná nɩgbamʊʊ́ sɩsɩ ɩnɩ́ɩ nɛ́, ɩlɛ́ ɩnɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ngɛ Yeésu weevééri wɛ sɩsɩ: «Iguná laakáarɩ na wentí mɩ́nnɩɩ́ nɛ́. Kɩ́maazʊʊ́ wenkí mɩ́ɩ́máázɩ́ná mɩ́ránáa nɛ́ gɛ sɩ bamaazɩ ná mɩ́ɩ, bɩka batásɩ mɩ́ɩ ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Káma, weení ɩwɛná nɛ́, bándasɩ́ yɩ na iyuú bɩbá bɩɖɔ́ɔ; amá, weení ɩvɛ́yɩ́na nɛ́, bɛ́nlɛɛ́ cʊ́kɔyɔ́ɔ wenká ɩwɛná nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ngɛ waadásɩ ɩtɔ́ sɩsɩ: «Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ cɔɔ́ɔ gɛ nyazɩ ɩrʊ́ wánlarɩ́ɩ kúɖúúdi ɩvɔɔ́-daá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Wánlarɩ́ɩ bɩtɛ́ nɛ́, kínÿúu nɛ́, wánzʊʊ́ ɩfɩ́nɩ, kínvém nɛ́, ɩkʊrʊ́. Báa ngbeére, bɩlɛ́ bɩdaá gɛ ɩwɛ. Sáátɩ kɩḿ nɛ́, kúɖúúdi waalára tɩ nɛ́ wɔ́nnyɔ́ɔ, bɩka bɩ́ngʊrʊ́ʊ, ngʊ́ waasɩ nŋɩ́nɩ́ bɩ́nlám nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Adɛ tɩtɩŋa wénÿelíi kʊ bɩnyɔ, bɩkʊrʊ́, bɩmʊ fuwá, bɩlá bíya cɩkpɩtɩɩ. ");
INSERT INTO kdh_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","A bíya wɛɛzɛ́ɛ, na baɖʊ loozó, káma, kʊ́m waadála.» ");
INSERT INTO kdh_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ngɛ Yeésu wɔɔdɔ́ wɛ ɖʊɖɔ sɩsɩ: «We gɛ ɖándabɩɩzɩ́ ɖɩkpɔ́ɔ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ ɖɩkɛɛzɩná. Tɔmgɛɛzɩrɛ wenɖé gɛ sɩ ɖɩkpɔ́ɔ kɛ ɖɩkɛɛzɩná. ");
INSERT INTO kdh_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Bɩjɔɔ́ɔ gɛ nyazɩ báńŋɩ́náyɔ́ɔ bú bónɖuú adɛ nɛ́, idekii ná kúɖúúdiwá rɩ́ŋa-daá ɖúúlínya-daá. ");
INSERT INTO kdh_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Amá, a bɔɔgbɔ́ɔ yɩ gɛ booɖúu, ɩdɛ́ɛ tikú wángʊrʊ́ʊ kɩkɩ́lɩ ɖóóziwá sɩɩganáa-dɛ́ɛ tikíni, bɩka kɩlɩzɩ́ wʊláázɩ kʊ́bɔńzɩ hálɩ siḿsi wánbɩɩzɩ́ sɩkɔ́nɩ sɩkáa sɩdɛ́ɛ ɖɛ́ńɖɛ́lá kɩdɛ́ɛ wʊláázɩ-rɔ.» ");
INSERT INTO kdh_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Na tɔmgɛɛza ɖabata ńŋɩnáa ana ɖɔ́ gɛ Yeésu waaŋmatɩná ɩráa Ɩsɔ́ɔ-dɛ́ɛ tɔ́m, waaŋmatɩná wɛ wenbí báta babɩ́ɩ́zɩ banɩ́ɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ɩdaŋmátɩ wɛ natɩ́rɩ bɩdɛkɛ́ɛ na tɔmgɛɛzɩrɛ. Amá, a iriké ɩ́na ɩwanbaaráa, na ɩlɩzɩ́ wɛ tɔmgɛɛza rɩ́ŋa kutoluú. ");
INSERT INTO kdh_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Bɩdɛ́ɛ wɩ́rɛ ɖɩḿ bɩɩlá ɖaanɩ́ŋa nɛ́, ngɛ Yeésu wɔɔdɔ́ ɩwanbaaráa sɩsɩ: «Ɖɩ́tɛsɩ fúu lí ńgɩ-rɔ.» ");
INSERT INTO kdh_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ngɛ beeyéle zamɔ́ɔ bɩka bɔkpɔ́ɔ Yeésu kpɩ́ɩ́rʊʊ́ ɩvʊnjɔɔ́ɔ kɩdaá nɛ́ bána yɩ bɛɖɛ́ɛ. Kpɩ́ɩ́rɩ́nɩ natɩ́rɩ ɖʊɖɔ fóo yɩ. ");
INSERT INTO kdh_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Bɔwɛ bɛ́nɖɛɛ́ lɩ́m-rɔ nɛ́, ngɛ fefelimá kʊ́bɔná naárɛ waabáázɩ fɛtɩ́ na ɖóni; bɩka bɩ́ngʊsɩ́ lɩ́m bɩ́nÿɔɔnáa kpɩ́ɩ́rʊʊ́ hálɩ kpɩ́ɩ́rʊʊ́ ɩbáázɩ súu. ");
INSERT INTO kdh_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yeésu ɩlɛ́ ɩwɛ kpɩ́ɩ́rʊʊ́ wɔ́rɔ́ wónɖóm kʊjʊʊ́ tɩ́nɛ́ɛ kʊjʊʊ́ tɩ́lɩ́wʊ́-rɔ. Ngɛ ɩwanbaaráa weevéézi yɩ bɔ́ndɔ́m yɩ sɩsɩ: «Kʊ́bɔnɩ́, bɩvɛ́yɩ́ nya natɩ́rɩ ɖánzɩ́m nɛ́?» ");
INSERT INTO kdh_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yeésu weevé nɛ́, ngɛ waagazɩ́ fefelimá, ɩtɔ́ lɩɩrɛ́ kʊ́bɔńɖɛ sɩsɩ: «Su tɔ́m, cɔɔ ɖɛfɛɛ.» Ngɛ fefelimá waazála bɩcɔ́ɔ ɖɛfɛɛ. ");
INSERT INTO kdh_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ngɛ wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «We-rɔ gɛ nɩdáárɛ waabá ɖɩsʊ́ʊ mɩ́ɩ bɩlɛ́. A bɩlɛ́ nɛ́, mɩ́dafáá ta toovonúm?» ");
INSERT INTO kdh_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ngɛ bɩɩbá bɩlá wɛ nɩdáárɛ bɔ́nbɔɔzɩ́ ɖamá sɩsɩ: «Ɩrʊ́ ceení gɛ weení gɛ bɩkpɛdɩ́na lɩ́m na fefelimá wánlám wenbí wɔɔbɔ́ɔ́zɩ nɛ́ bɩlɛ́!» ");
INSERT INTO kdh_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yeésu na ɩwanbaaráa baadála lɩɩrɛ́ kʊ́bɔńɖɛ-dɛ́ɛ fúu lí ńgɩ-rɔ Geraseníi ńba-dɛ́ɛ laadɔ́ɔ-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ngɛ Yeésu waalɩ́ɩ kpɩ́ɩ́rʊʊ́-daá; ńna‑ńna gɛ ɩrʊ́ naárʊ zííni wánjaarɩ́ yɩ nɛ́ waagálɩ́ɩ́ná bɔɔláánɩ-daá ɩgɛgɛrɛŋɛ sɩ ɩsɩ́ŋ yɩ. ");
INSERT INTO kdh_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ɩrʊ́ ɩmʊ́, bɔɔláánɩ-daá gɛ ɩwɛ, naárʊ fɛ́yɩ́ wɔ́nvɔkɩ́ yɩ ɩdɛcɛ́ nɛ́, báa na agbarangbára gɛ bɔɔvɔkɩná yɩ. ");
INSERT INTO kdh_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Káma, baalaaná ɩnʊvɔ́ ɖɩ́ɩ na nyɩɩrɩ́tɩ, bɔfɔ́kɩ ɩnʊ́ʊ́zɩ na agbarangbára, amá, wɛɛjɛ́ bɩrɩ́ŋa, báa naárʊ tɛfɛ́yɩ́ wánbɩɩzɩ́ yɩ ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Báa sáátɩ wenkí, bɩlɛ́ gɛ wéngilím bɔɔláánɩ na bʊ́ʊ́nɩ-daá nuvoowú na ɩdaawʊ́, wóngoó bɩka wɛ́nlɛrɩ́ɩ ɩdɩ na bɔ́. ");
INSERT INTO kdh_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ɩrʊ́ ɩmʊ́ woogólosi Yeésu nɛ́, ngɛ weegézé ɩkɔ́nɩ isóm waazá-daá. ");
INSERT INTO kdh_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Wóngoó sɩsɩ: «Yeésu Ɩsɔ́ɔ bílí‑bílí-dʊ́ʊ Biyaalʊ́, we gɛ nyɔ́zɔɔlɛ́ɛ na ma. Máávɩ́nɩ nya Ɩsɔ́ɔ-rɔ, nkanáázɩ ma.» ");
INSERT INTO kdh_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Káma, Yeésu wɛ wɔ́ndɔ́m yɩ sɩsɩ: «Zííni, lɩɩ ɩrʊ́ ɩmʊ́-rɔ.» ");
INSERT INTO kdh_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ngɛ Yeésu wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Sɩsɩ wé gɛ bánÿaá nya.» Ngɛ ɩrʊ́ ɩmʊ́ sɩsɩ: «“Tuutúúma”, káma, ɖɔ́ɔ́ɖɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ngɛ waabá ɩfɩ́nɩ yɩ sɩsɩ ɩ́kɔɖɔ́ɔ wɛ ɩlɩzɩ́ wɛ laadɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ngʊ́ lé bɔwɛ nɛ́, bʊ́ʊ cʊ́ʊ́na wɛ. Ngɛ afawá tuutúúma natɩ́rɩ wɛ bʊ́ʊ fáráńdɩ́ ńna tínɖíi. ");
INSERT INTO kdh_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ngɛ zííniwá waavɩ́nɩ Yeésu sɩsɩ: «Yele ɖáa ɖibó ɖɩsʊ́ʊ afawá tɩna tɩdaá.» ");
INSERT INTO kdh_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ngɛ Yeésu waava tɩ nɩ́bááwʊ. Ńna gɛ zííniwá waalɩ́ɩ ɩrʊ́ ɩmʊ́ ɩrɔ tɩsʊ́ʊ afawá. Ngɛ afawá weeze tití kazalɩ́ya tɩsʊ́ʊ lɩɩrɛ́ kʊ́bɔńɖɛ-daá lɩ́m iɖi tɩ tɩsɩ́. Tɩgɛ́ɛ gɛ nyazɩ afawá mííli natɩ́lɛ (2.000) bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tigetiráa weeze bobó bekéveeri tɛ́ɛ́dɩ-daá na fásɩ-daá. Ngɛ ɩráa wɔɔgɔ́nɩ sɩ bɛbɛ́ɛ wenbí bɩɩlá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ngɛ bɔɔgɔ́nɩ bɔmɔɔná Yeésu. Bɔɔgɔ́nɩ nɛ́, baana zííniwá-dʊ́ʊ cɔɔ́ɔ izóóna kpɩná ɩ́na ɩdɩ, ɩmʊ́ weení ɩvʊnwɛná zííniwá tuutúúma nɛ́. Ńna gɛ bɩɩlá wɛ nɩdáárɛ. ");
INSERT INTO kdh_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Wenbá baana wenbí bɩɩlá nɛ́, baadɩ́ nŋɩ́nɩ́ bɩɩlá zííniwá-dʊ́ʊ na afawá nɛ́ befééri wɛ. ");
INSERT INTO kdh_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ńna gɛ baabáázɩ Yeésu fɩnɩ́ sɩsɩ ɩ́lɩɩ bɛḿ balaadɔ́ɔ-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Sáátɩ wenkí Yeésu wángbáa kpɩ́ɩ́rʊʊ́-daá nɛ́, ngɛ zííniwá-dʊ́ʊ Yeésu waawáázɩ yɩ nɛ́ waavɩ́nɩ yɩ sɩsɩ íyele ɩmʊ́ ifu yɩ. ");
INSERT INTO kdh_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Amá, Yeésu weegízi, ngɛ weevééri yɩ sɩsɩ: «Bɩsɩ nyɛ́dɛ́ɛ, nyɛ́dɛ́ɛ ńba-jɔ́, feeri wɛ wenbí bɩrɩ́ŋa Ɖádʊ́ʊ Ɩsɔ́ɔ waalá nya nɛ́ na nŋɩ́nɩ́ waanɩ́ɩ nyɔ́gʊnyɔḿ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ngɛ ɩrʊ́ ɩmʊ́ wɛɛɖɛ́ɛ ɩbáázɩ ɩráa feerím wenbí bɩrɩ́ŋa Yeésu waalá yɩ nɛ́ laadɔ́ɔ bánÿaá kɛ Tɛ́ɛ́dɩwá fuú tɩdamáa nɛ́ kadaá, bɩka bɩjɔɔ́ɔ ɩráa rɩ́ŋa bítí. ");
INSERT INTO kdh_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yeésu waazʊ́ʊ kpɩ́ɩ́rʊʊ́ ɩtɛ́sɩ fúu lí ńgɩ-rɔ. Ngɛ Zamɔ́ɔ kʊ́bɔńgɩ wɔɔgɔ́nɩ kitúúzi ɩjɔ́ lɩɩrɛ́ kʊ́bɔńɖɛ-jɔ́ ńna. ");
INSERT INTO kdh_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ńna gɛ Yahúúɖuwá-dɛ́ɛ Ɩsɔ́ɔ ɖaazɛɛɖɛ́-dɛ́ɛ kʊ́bɔnáa-daá naárʊ, bánÿaá yɩ sɩsɩ Yááhíru nɛ́ wɔɔgɔ́nɩ ɩjɔ́. Ɩlɛ́ waana Yeésu nɛ́ ngɛ wɛɛjɛ́ ɩsála Yeésu nʊvɔ́-dɛ. ");
INSERT INTO kdh_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ɩbá wánvɩnɩ́ yɩ sɩsɩ: «Mɛwɛɛlɛ́ɛyɔ́ɔ wɛ kánzɩ́m. Máávɩ́nɩ nya, kɔnɩ ngádɩnɩ nyánʊ́ʊ́zɩ kɔrɔɔzɩ́ nlɛ́ɛ kɛ koyuú weezuú.» ");
INSERT INTO kdh_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ngɛ ɩ́na yɩ bɔɔgbɔ́ɔ nɩ́bááwʊ bɛ́nɖɛɛ́. Zamɔ́ɔ kʊ́bɔńgɩ fóo Yeésu bɩka kɩ́nnyʊʊ́ yɩ cé na cé. ");
INSERT INTO kdh_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Alʊ́ naárʊ wɛ zamɔ́ɔ lɔwʊtáá ńna. Alʊ́ ɩmʊ́, azimá wéndináa yɩ bʊwɛná bɩ́ɩ́zɩ fuú na nasɩ́lɛ bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Alʊ́ ɩmʊ́ waabá ɩyɛlɛ́m lákʊ́tawá ɖabata nʊ́ʊ́zɩ-daá. Weeɖi wenbí bɩrɩ́ŋa ɩwɛná bɩ nɛ́, ngʊ́ natɩ́rɩ tasáa wɩ́sɩ; biigúti gɛ bɩnyɔ́ɔ́zɩ bɩkpa bʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Waanɩ́ɩ bánŋmatɩ́ Yeésu-dɛ́ɛ tɔ́m nɛ́, ngɛ wɔɔgɔ́nɩ ɩsʊ́ʊ zamɔ́ɔ-daá na bʊwɔ́rɔ́ itekiná Yeésu-dɛ́ɛ tóko. ");
INSERT INTO kdh_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Káma, waamáázɩ sɩsɩ: «A ɖé máábɩ́ɩ́zɩ medekiná idóko, mánwaá.» ");
INSERT INTO kdh_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Weedekiná yɩ nɛ́, ngɛ azimá bíndináa yɩ nɛ́ bɩɩjáŋ bɩsɩ́ŋ. Wooyuú ɩnɩ́ɩ ɩdɔnʊʊ́-daá sɩsɩ waawáa. ");
INSERT INTO kdh_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Bɩɩlá bɩlɛ́ nɛ́, ngɛ Yeésu waajáŋ iyuú ɩtɩlɩ́ sɩsɩ ɖóni nabɩ́rɩ waalɩ́ɩ ɩmʊ́ ɩrɔ, ngɛ wɛɛgɛ́ɛ́zɩ ɩdɩ zamɔ́ɔ-daá ɩbɔ́ɔ́zɩ sɩsɩ: «Weení weedekiná na módóko.» ");
INSERT INTO kdh_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ngɛ ɩwanbaaráa sɩsɩ: «Bɛɛ zamɔ́ɔ wánnyʊʊ́ nya cé na cé nɛ́, ngɛ nyɔ́nbɔɔzɩ́ sɩsɩ weení weedekiná na nya?» ");
INSERT INTO kdh_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ngɛ Yeésu wɛɛbɛ́ɛ́ŋ ɩlára ɩmɩ́lɩ wánjáádɩ weení weedekiná yɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Alʊ́ ɩmʊ́ ɩnyɩ wenbí bɩɩlá yɩ nɛ́, wɔɔgbɔ́ɔ selíi, nɩdáárɛ wɛná yɩ. Ngɛ wɔɔgɔ́nɩ ɩcɛ́ ɩsála Yeésu ɩzá-daá ɩtɩ́ toovonúm rɩ́ŋa ifééri yɩ. ");
INSERT INTO kdh_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ngɛ Yeésu wɔɔdɔ́ yɩ sɩsɩ: «Mɛwɛɛlɛ́ɛ, nyɛ́dɛ́ɛ toovonúm fáa wɛɛlɛ́ɛ nya, bo nɖɛɛ ná alaafɩ́ya, bíyéle nya.» ");
INSERT INTO kdh_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ɩwɛ ɩbamáa ŋmatɩrɛ gɛ ɩráa waagálɩ́ɩ́ná Ɩsɔ́ɔ ɖaazɛɛɖɛ́-dɛ́ɛ kʊ́bɔnɩ́-dɛ́ɛ batála sɩsɩ: «Nwɛɛlɛ́ɛ waazɩ́, nkacáárɩ kʊ́bɔnɩ́ ɖʊɖɔ.» ");
INSERT INTO kdh_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Amá, Yeésu waanɩ́ɩ wentí baaŋmátɩ nɛ́, ngɛ weevééri Ɩsɔ́ɔ ɖaazɛɛɖɛ́-dɛ́ɛ kʊ́bɔnɩ́ sɩsɩ: «Nkanɩ́ɩ nɩdáárɛ, fa toovonúm ɖé.» ");
INSERT INTO kdh_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yeésu teyéle naárʊ ɩláázɩ yɩ, asée Pétro, na Yaakúbu, na ɩlɛ́ igoobú Yʊháánɩ beriké. ");
INSERT INTO kdh_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Boobó batála Ɩsɔ́ɔ ɖaazɛɛɖɛ́-dɛ́ɛ kʊ́bɔnɩ́-dɛ́ɛ ɖaána nɛ́, waana bɩjɔɔ́ɔ kiri-kiri bɩka ɩráa wénwií baabá bánmám kebísi. ");
INSERT INTO kdh_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ngɛ Yeésu waazʊ́ʊ ɩbɔ́ɔ́zɩ wɛ sɩsɩ: «Ngbaalá mɩ́nlám kiri-kiri bɩlɛ́. Ngbaalá gɛ mínwií bɩlɛ́. Bú tasɩ́, amá, wónɖóm gɛ.» ");
INSERT INTO kdh_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ńna gɛ ɩráa waamʊ́ŋ Yeésu. Amá, Yeésu weeyéle barɩ́ŋa balɩ́ɩ asʊ. Ngɛ weeyéle ɩ́na bú ɩgɔɔ na ɩjaa, na ɩwanbaaráa baagálaazɩ yɩ nɛ́ basʊ́ʊ lé bú wɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ngɛ wɛɛzɛlɩ́ bú nʊ́ʊ́nɩ ɩtɔ́ yɩ sɩsɩ: «Talííta kúm!» Bugutoluú gɛ sɩsɩ: Aléeréyɔ́ɔ, mazɩ kʊrʊ́ nzɩ́ŋ! ");
INSERT INTO kdh_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ngɛ aléeréyɔ́ɔ waagʊrʊ́ kabáázɩ nʊŋɛ́. Bɩ́ɩ́zɩ fuú na nasɩ́lɛ gɛ kavʊnwɛná. Bɩɩlá bɩlɛ́ nɛ́, ngɛ bɩɩbá bɩlá wɛ bítí. ");
INSERT INTO kdh_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ngɛ Yeésu waabá ɩbásɩ wɛ sɩsɩ békéyele naárʊ ɩtɩlɩ́. Ngɛ wɔɔdɔ́ wɛ ɖʊɖɔ sɩsɩ báfá bú kíɖíím iɖi. ");
INSERT INTO kdh_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ngɛ Yeésu waalɩ́ɩ ńna ɩɖɛ́ɛ lé wɔɔjɔ́ɔ ɩbɩ́ɩ nɛ́, ɩ́na ɩwanbaaráa. ");
INSERT INTO kdh_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Fɛɛzɩrɛ wɩ́rɛ waadála nɛ́, ngɛ waazʊ́ʊ Ɩsɔ́ɔ ɖaazɛɛɖɛ́ ɩbáázɩ Ɩsɔ́ɔ-dɛ́ɛ tɔ́m wɩlɩ́ɩ. Ɖabata waanɩ́ɩ ɩdɛ́ɛ wɩlɩ́ɩ nɛ́, ngɛ bɩɩlá wɛ bítí, ngɛ sɩsɩ: «Lé gɛ woogóyuú na tɩna ɖɔ́. Áséńsí kɩna bɩɩva yɩ nɛ́, wenkí gɛ kɩlɛ́ bɩlɛ́. Nŋɩ́nɩ́ gɛ bɩ́nlám gɛ wánlám maamááciwá tɩna bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ɩmʊ́ nɛ́, mányɩ sɩsɩ Marɩyáma biyaalʊ́ kááfɩ́nta nbɩlɛ́. Mányɩ sɩsɩ Yaakúbu, na Yoozée, na Yudáa, na Simɔ́ɔnɩ bogoobú nbɩlɛ́! Igoobíya aláa fɛ́yɩ́ ɖɔ́lɔ́wʊ́táá cé?» Ngɛ beegízi yɩ badafa yɩ toovonúm. ");
INSERT INTO kdh_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ńna gɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Bánváa anɖébi gírímá báa lé asée ɩdɛ́ɛ́dɩ-daá, na igoobíre-daá, na ɩɖaána-daá baasí gɛ bɛ́ngbɛɛnáa yɩ.» ");
INSERT INTO kdh_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ɩdabɩ́ɩ́zɩ ɩlá maamááci báa nakɩ́rɩ Nazarɛ́ɛtɩ ńnaamʊ́. Amá, kʊdɔndɩnáa nɛbɛ́rɛ-rɔɔzɩ́ gɛ waadɩ́nɩ nʊ́ʊ́zɩ ɩwáázɩ wɛ. ");
INSERT INTO kdh_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nazarɛ́ɛtɩ ńba-dɛ́ɛ badafa yɩ toovonúm waalá Yeésu bítí. Yeésu wéngilím tɛɛbíízi sɩdɩláána Nazarɛ́ɛtɩ nɛ́ sɩdaá wánwɩlɩ́ɩ Ɩsɔ́ɔ-dɛ́ɛ tɔ́m. ");
INSERT INTO kdh_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ngɛ waayáa tɩndɩnáa fuú na nɔɔ́lɛ wéndiríi wɛ nɔwɔ́nwɔ́lɛ. Waava wɛ yíko zííniwá-rɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Weevééri wɛ wéndiríi wɛ nɛ́ sɩsɩ: «A mɩ́nɖɛɛ́, ɩ́kɔkpɔ́ɔ nabʊ́rʊ, ɖɛ́nɩ riké gɛ ɩɖɔ́kɩ. Ɩ́kɔɖɔ́kɩ kíɖíím, ɩ́kɔkpɔ́ɔ furuú, ɩ́kaɖʊ liideé zíba-daá, ");
INSERT INTO kdh_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","amá, ɩɖɩ takaḿwá bɩka íkosúu tóko natɩ́lɛ.» ");
INSERT INTO kdh_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Weevééri wɛ sɩsɩ: «A mɩ́ɩ́dála gɛ mɩ́ɩ́zʊ́ʊ ɖaána wenká-daá nɛ́, ɩjɔ́ɔ ńna hálɩ ɩkɔ́nɩ ɩlɩ́ɩ fáráńdɩ́ kɩḿ. ");
INSERT INTO kdh_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","A mɩ́ɩ́dála lé gɛ beegízi badamʊ mɩ́ɩ, ngʊ́ bedewélesi mɩ́ɩ, ɩlɩ́ɩ ńna bɩka ikpíízi mɩ́nʊvɔ́-dɛ́ɛ buuruú ɩtalɩná wɛ.» ");
INSERT INTO kdh_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ngɛ baalɩ́ɩ befééri laabáárʊ sɩsɩ ɩráa ɩ́la túúbá. ");
INSERT INTO kdh_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bɔɔɖɔ́ɔ zííniwá ɖabata, batáa kʊdɔndɩnáa ɖabata núm bawáázɩ wɛ. ");
INSERT INTO kdh_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Wúro Eróodi waanɩ́ɩ Yeésu tɛ́nɩ, káma, ɩyɩ́ɖɛ wɛɛzɛ́ɛ báa lé. Nɛbɛ́rɛ sɩsɩ: «Yaayá weegéve ná sɩ́m-daá, bʊrɔɔzɩ́ gɛ ɩwɛná yíko wánlám maamááciwá bɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nɛbɛ́rɛ sɩsɩ: «Elíya gɛ», nɛbɛ́rɛ ɖʊɖɔ sɩsɩ: «Anɖébi naárʊ gɛ, ńŋɩnáa caanawʊ́ anɖébiwá-daá naárʊ.» ");
INSERT INTO kdh_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Wúro Eróodi waanɩ́ɩ bɩlɛ́ nɛ́, ngɛ sɩsɩ: «Yaayá weení mééyéle bɛcɛ́ ɩgʊjʊʊ́ nɛ́ weegéve ná.» ");
INSERT INTO kdh_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Káma, wúro Eróodi ɩmʊ́ weediri ná bakágbá Yaayá bɔfɔ́kɩ yɩ bɔtɔ sáráka. Wenbí bʊrɔɔzɩ́ nɛ́, wúro Eróodi wɔɔgbɔ́ɔ igoobú Filíipu ɖɛɛlʊ́ Erodiyáadɩ. ");
INSERT INTO kdh_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Káma, Yaayá weevééri Eróodi sɩsɩ: «Bɩdafa nya nɩ́bááwʊ sɩsɩ ńgbɔɔ ngoobú ɖɛɛlʊ́!» ");
INSERT INTO kdh_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Biiyéle Erodiyáadɩ waalɩzɩ́ Yaayá báɖáárɛ wánjáádɩ sɩ ɩkʊ yɩ, amá, ɩ́dánbɩɩzɩ. ");
INSERT INTO kdh_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Káma, Eróodi wénzewɔ́ɔ Yaayá. Ɩnyɩ sɩsɩ ɩlɛ́ ɩjɔwʊrɛ sɩɩzɛ́ɛ, bɩka ɩgɛ́ɛ Ɩsɔ́ɔ-dɛ́ɛ ɩrʊ́ nɛ́, ɩ́danbá ɩcáa balá yɩ nabʊ́rʊ. A bɩgɛ́ɛ wɔɔjɔ́ɔ iwélesi ɩnɩ́ɩ Yaayá wánŋmatɩ́ wentí nɛ́, na bɩnyɔ yɩ, ngʊ́ na bɩlɛ́, waabá wénwelesí yɩ gɛ kazɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Amá, wɩ́rɛ neɖére gɛ Erodiyáadɩ wooyuú wentí sɩ ibuuná na ɩkʊ Yaayá nɛ́. Bɩgɛ́ɛ na wɩ́rɛ wenɖé Eróodi wénɖíi ɩdɛ́ɛ lʊrʊ́ʊ wɩ́rɛ tɔɔzɩ́-dɛ́ɛ jíńgáárɩ́ nɛ́. Waayáa ɩdɛ́ɛ tɩmɛlanɖáa kʊ́bɔnáa, na sɔ́ɔ́jawá kʊ́bɔnáa, na Galilée kʊ́bɔnáa ɖíína. ");
INSERT INTO kdh_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Bɔwɛ ɖíína-daá ńna gɛ Erodiyáadɩ wɛɛlɛ́ɛ waazʊ́ʊ ɩbáa. Ngɛ ɩdɛ́ɛ báárɛ waabá bɩlá Eróodi na wenbá waayáa wɛ ɖíína nɛ́ kazɔ́ɔ. Ńna gɛ Eróodi wɔɔdɔ́ bú aléeré ɩmʊ́ sɩsɩ: «Sʊlʊ ma wenbí nyɔ́zɔɔlɛ́ɛ nɛ́, mánváa nya.» ");
INSERT INTO kdh_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ngɛ waamʊná ɩlɛ́ waazá-daá sɩsɩ: «Báa wé gɛ nyáázʊ́lʊ ma mánváa nya, báa ɖoo mógowúrɔ́ɔ laadɔ́ɔ fɔɔlʊʊ́, mánváa nya.» ");
INSERT INTO kdh_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ngɛ bú aléeré ɩmʊ́ waalɩ́ɩ ɩbɔ́ɔ́zɩ ɩgɔɔ sɩsɩ: «Wé gɛ mázʊlʊ.» Ngɛ ɩgɔɔ sɩsɩ: «Sʊlʊ Yaayá kʊjʊʊ́.» ");
INSERT INTO kdh_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ńna gɛ waajáŋ ɩkɔ́nɩ ɩsʊ́ʊ wúro Eróodi-jɔ́ na toózi, ngɛ waazʊ́lʊ wúro sɩsɩ: «Mɔ́zɔɔlɛ́ɛ ngɔná ma lɛlɛɛkɩna Yaayá kʊjʊʊ́ tɛ́lɛ́lɛ́-daá.» ");
INSERT INTO kdh_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Wúro laakáarɩ waagʊrʊ́. Amá, ńŋɩnáa wooɖuuná zamɔ́ɔ baayáa kɩ ɖíína nɛ́ kɩɩzá-daá nɛ́, ɩ́dánbɩɩzɩ ikízi bú aléeré waazʊ́lʊ wenbí nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ngɛ ńna‑ńna wúro weedíri sɔ́ɔ́ja, ɩfa yɩ wɛ́ɖɛ sɩsɩ ɩ́kɔ́ná ɩmʊ́ Yaayá kʊjʊʊ́. Ngɛ ɩlɛ́ woobó sáráka-daá ɩkɛ́jɛ Yaayá kʊjʊʊ́. ");
INSERT INTO kdh_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Waagáɖʊ́ kɩ tɛ́lɛ́lɛ́-daá ɩkɔná icéle bú aléeré. Ngɛ ɩlɛ́ waamʊ iboná icéle ɩgɔɔ. ");
INSERT INTO kdh_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yaayá-dɛ́ɛ wanbaaráa waanɩ́ɩ nɛ́, ngɛ boobó bɔkpɔ́ɔ ɩdɔnʊʊ́ bebí. ");
INSERT INTO kdh_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yeésu-dɛ́ɛ tɩndɩnáa woodúúzi ɩjɔ́, ngɛ baadɩ́ wenbí bɩrɩ́ŋa baagála nɛ́ befééri yɩ, na wentí tɩrɩ́ŋa baagáwɩlɩ ɩráa nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ngɛ wɔɔdɔ́ wɛ sɩsɩ: «Mɩ́nyɔ́ɔ́ ɩgɔ́nɩ ɖibó kpɔ́mɔ́ɔ́ lé ɩráa fɛ́yɩ́ nɛ́ ɩkɛ́vɛɛzɩ.» Káma, ɩráa wɔɔɖɔ́ɔ bánzʊʊ́ bánlɩɩ́ nɛ́, badanvɛ́yɩ́na ɖáámá na beɖi kíɖíím. ");
INSERT INTO kdh_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ngɛ boobó bɔkpɔ́ɔ kpɩ́ɩ́rʊʊ́ balɩ́ɩ kpɔ́mɔ́ɔ́, lé ɩráa fɛ́yɩ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Bɛ́nɖɛɛ́ nɛ́, ɩráa waana wɛ, ɖabata waadɩlɩ́ wɛ, ngɛ bɔɔgbɔ́ɔ nʊvɔ́ bovóo wɛ bénzewɔ́ɔ bɛ́nɖɛɛ́ lé babamáa nɛ́. Tɛ́ɛ́dɩwá rɩ́ŋa-daá gɛ baagálɩ́ɩ́ná. Ngɛ baadála baka Yeésu na ɩwanbaaráa. ");
INSERT INTO kdh_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yeésu weedí kpɩ́ɩ́rʊʊ́-daá nɛ́, ngɛ waana zamɔ́ɔ kʊ́bɔńgɩ. Ngɛ kɩdɛ́ɛ tɔ́m waalá yɩ kʊnyɔḿ, káma, kɩjɔɔ́ɔ nyazɩ fééni tɩvɛ́yɩ́na ketirú nɛ́. Ngɛ waawɩ́lɩ kɩ tɔ́mwá ɖabata. ");
INSERT INTO kdh_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ɖaanɩ́ŋa waalá nɛ́, ngɛ Yeésu-dɛ́ɛ wanbaaráa woogóduu ɩjɔ́ bɔtɔ́ yɩ sɩsɩ: «Ɖɔ́jɔɔ́ɔ na tɛ́ɛ́dɩ bolíni ngʊ́ kɩɩɖáánɩ, ");
INSERT INTO kdh_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","bɩlɛ́ nɛ́, feeri zamɔ́ɔ kɩɖɛ́ɛ fásɩ na tɛɛbíízi sɩdɩláána nɛ́ sɩdaá kɩkámʊ́ kíɖíím kiɖi.» ");
INSERT INTO kdh_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Mɩ́nyɔ́ɔ́ mɩ́dɩtɩŋa ɩva wɛ kíɖíím beɖi.» Ngɛ bɔɔbɔ́ɔ́zɩ Yeésu sɩsɩ: «A bɩlɛ́, ɖɩkpɔ́ɔ wɛ́ kákpáŋa (200) tɩmɛ́rɛ liideé ɖibó ɖɩkámʊ́ kpɔ́nɔ́ ɖicéle wɛ bɔtɔ́ɔ?» ");
INSERT INTO kdh_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ńna gɛ Yeésu woobúsi wɛ sɩsɩ: «Ibó ɩbɛ́ɛ! Kpɔ́nɔ́wá tɩrɔ nŋɩ́nɩ́ gɛ mɩ́wɛná!» Boobó bɔbɔ́ɔ́zɩ, ngɛ beevééri yɩ sɩsɩ: «Kpɔ́nɔ́wá natʊ́nʊ́wá na tiiná náálɛ.» ");
INSERT INTO kdh_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ńna gɛ wɔɔdɔ́ wanbaaráa sɩsɩ béyele ɩráa rɩ́ŋa ɩcɔ́ɔ fuwé‑fuwé nyɩ́ɩ́dɩ lɩ́m ńdɩ-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ngɛ beeyéle ɩráa ɩcɔ́ɔ fuwé‑fuwé. Fuwé naárɛ-daá, ɩráa nɩɩ́nʊ́wá (100), naárɛ-daá ɩráa nɛɛ́saaláa (50). ");
INSERT INTO kdh_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ngɛ Yeésu wɔɔgbɔ́ɔ kpɔ́nɔ́wá natʊ́nʊ́wá tɩḿ na tiiná náálɛ amʊ́, ɩkpáázɩ waazá ɩsɔ́ɔ́dáá ɩsá Ɩsɔ́ɔ bʊrɔ. Bɩlɛ́ bʊwɔ́rɔ́ gɛ wɛɛbɛlɩ́ kpɔ́nɔ́wá ɩkpɔ́ɔ tɩ icéle ɩwanbaaráa batára zamɔ́ɔ. Ngɛ waadára barɩ́ŋa tiiná náálɛ ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Barɩ́ŋa bɔɔdɔ́ɔ bɔfɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Bɔɔdɔ́ɔ́zɩ kpɔ́nɔ́ na tiiná fɔɔlásɩ bɩɩga nɛ́ bisu ɖɔkɩ́nɩ fuú na natɩ́lɛ. ");
INSERT INTO kdh_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Abaaláa nyazɩ mííli nɔɔ́nʊ́wá (5.000) bɩlɛ́ weeɖiná kíɖíím bɩḿ. ");
INSERT INTO kdh_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Bɩlɛ́ bɩɩjáŋ bʊwɔ́rɔ́ gɛ Yeésu waajáárɩ ɩwanbaaráa sɩsɩ bákpá kpɩ́ɩ́rʊʊ́-daá bɛtɛ ɩmʊ́ nɩ́bááwʊ bɛtɛsɩ ná fɔɔlʊʊ́ kɩɩganáa Bɛtɩsayɩdáa tɛ́ɛ́dɩ fáráńdɩ́. Bɩdɛ́ɛ sáátɩ nɛ́, ɩmʊ́ iyéle zamɔ́ɔ ɩya ɖamá. ");
INSERT INTO kdh_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Weeyéle zamɔ́ɔ ɩya ɖamá bɩtɛ́ nɛ́, ngɛ waagba bʊ́ʊ-daá sɩ ɩsʊ́lʊ Ɩsɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kɩɩɖáánɩ nɛ́, kpɩ́ɩ́rʊʊ́ wáńdálɩ́ lɔwʊtáá bɩka Yeésu wɛ ɩzɩ́ŋɛ́ɛ iriké kpaam-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ɩzɩ́ŋɛ́ɛ nɛ́, ɩbɛɛ́na wɛ bánzaá bɛ́nÿɛlɛ́ŋ, káma, fefelimá wónÿoó kpɩ́ɩ́rʊʊ́. Asʊbáa gɛ Yeésu waagʊrʊ́ wɛ́ngɛɖɛɛ́ ɩwanbaaráa-jɔ́ wánganʊŋ́ lɩɩrɛ́ kʊ́bɔńɖɛ-rɔ. Wáńjʊ́ʊ́ná wɛ hálɩ sɩ ɩcɛzɩ́. ");
INSERT INTO kdh_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Bɛlɛ́ baana yɩ wánganʊŋ́ lɩ́m-rɔ nɛ́, bɔjɔɔ́ɔ sɩsɩ ásɩ́náálɩ́ɩ gɛ. Ńna gɛ baabáázɩ agogo. ");
INSERT INTO kdh_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Káma, barɩ́ŋa baana yɩ nɛ́, nɩdáárɛ waabá bɩsʊ́ʊ wɛ. Ńna‑ńna gɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Ɩɖɔ́kɩ mɩ́dɩ, mɔ́ɔ́ gɛ, ɩ́kanɩ́ɩ nɩdáárɛ.» ");
INSERT INTO kdh_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ngɛ waagba bɔjɔ́ kpɩ́ɩ́rʊʊ́-daá; fefelimá ɩcáŋ asála. Bɩɩbá bɩlá wɛ bítí páá. ");
INSERT INTO kdh_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Káma, badanɩ́ɩ Yeésu waadára kpɔ́nɔ́ nɛ́ bɩdɛ́ɛ maamááci kutoluú. Wenbí bʊrɔɔzɩ́ nɛ́, bewenbé cɔɔ́ɔ ɖóni. ");
INSERT INTO kdh_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Bɛɛdɛ́sɩ lɩɩrɛ́ kʊ́bɔńɖɛ bɩtɛ́ nɛ́, baadála Genezarɛ́ɛtɩ laadɔ́ɔ-daá; ngɛ baazɩ́ŋ ńna. ");
INSERT INTO kdh_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Baajáŋ betí kpɩ́ɩ́rʊʊ́-daá ɖɔ́ nɛ́, ɩráa waadɩlɩ́ Yeésu. ");
INSERT INTO kdh_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ngɛ beegíli tɛ́ɛ́dɩ rɩ́ŋa-daá bakázʊʊ kʊdɔndɩnáa tará-rɔ bɔkɔná lé baanɩ́ɩ sɩsɩ Yeésu wɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Báa tɛɛbiiyá, yáá tɛ́ɛ́dɩ, yáá fɔɔ́ wenká-daá gɛ waadála, bɔ́ngɔnáa kʊdɔndɩnáa gɛ bánvɩɩzɩ́ wɔnásɩ-daá bɩka bánvɩnɩ́ Yeésu sɩsɩ íyéle betekiná báa idóko njʊ́ʊ́rɛ-daá riké. Ngɛ wenbá barɩ́ŋa beedekiná kɩ nɛ́, baawáa. ");
INSERT INTO kdh_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Faríizi ńba na Mará wɩlɩɖáa nɛbɛ́rɛ baagálɩ́ɩ́ná Yerusalɛ́ɛm nɛ́, bɔɔgɔ́nɩ botúúzi Yeésu-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Baana sɩsɩ Yeésu-dɛ́ɛ wanbaaráa wénɖíi kíɖíím bɩka banʊ́ʊ́zɩ fɛ́yɩ́ ɖacɩrɩ‑cɩrɩ, bugutoluú sɩsɩ badasám sɩ ńŋɩnáa caájaanáa-dɛ́ɛ taáɖɛ waazɩ́ɩ́zɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ngʊ́ Faríizi ńba na Yahúúɖuwá baaganáa ɖɔ́kɩná wentí bajaájaanáa waawɩ́lɩ wɛ nɛ́ gɛ bɩjaarɛ́ɛ, tɩlɛ́ gɛ sɩsɩ: a sɩ beɖi kíɖíím, asée báńzám banʊ́ʊ́zɩ máḿ-máḿ naanɩ́ beɖi. ");
INSERT INTO kdh_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","A baagálɩ́ɩ́ná kɩyakʊ, asée báńwaadɩ balá badɩ ɖacɩrɩ‑cɩrɩ Ɩsɔ́ɔ ɩzá-daá naanɩ́ beɖi kíɖíím. Bɩlɛ́ bibaasí, caana-zɔ́ɔ́zɩwá ɖabata ɖʊɖɔ wɛ bɔɖɔ́kɩná sɩ bɩjaarɛ́ɛ, ńŋɩnáa kagbásɩ na toyísi, na nyɩnásɩ-dɛ́ɛ yaalɩ́. ");
INSERT INTO kdh_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ńna gɛ Faríizi ńba na Mará wɩlɩɖáa wɔɔbɔ́ɔ́zɩ Yeésu sɩsɩ: «We-rɔ gɛ nyɛ́dɛ́ɛ wanbaaráa tónvúu wentí caájaanáa-dɛ́ɛ taáɖɛ waazɩ́ɩ nɛ́, ngɛ bádánzam banʊ́ʊ́zɩ na beɖi kíɖíím.» ");
INSERT INTO kdh_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Munáávikíwá bana ɖɔ́; Esáya waabá ɩwɛná toovonúm waaŋmatɩná Ɩsɔ́ɔ nɔɔ́ ɩŋmátɩ mɩ́dɔ́m nɛ́. Káma, waaŋmátɩ sɩsɩ: “Na ntɔɔ́nɩ gɛ zamɔ́ɔ kɩna kɩ́nÿaanáa máyɩ́ɖɛ. Amá, kiwenbiré cɔɔ́ɔ na ma bolíni. ");
INSERT INTO kdh_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Faala gɛ bánlám sɩsɩ bɛ́nzɛɛ́ ma. Káma, wentí bánwɩlɩ́ɩ nɛ́, kɛ́ɛ ɩráa-dɛ́ɛ mará gɛ.” ");
INSERT INTO kdh_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mɩ́ɩ́zɩ́ɩ Ɩsɔ́ɔ-dɛ́ɛ Mará fɔɔlʊʊ́ bɩka mívóo caájaanáa-dɛ́ɛ taáɖɛ.» ");
INSERT INTO kdh_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ngɛ waadásɩ ɩtɔ́ wɛ sɩsɩ: «Mɩ́nyɩ míngizíi Ɩsɔ́ɔ-dɛ́ɛ Mará bɩka mɩ́ɖɔ́kɩná caájaanáa-dɛ́ɛ taáɖɛ bɩjaarɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Káma, Múúsá wɔɔdɔ́ sɩsɩ: “Ɖɔɔzɩ ngɔɔ na njaa,” ngɛ wɔɔdɔ́tɔḿ sɩsɩ: “Weení waalá ɩgɔɔ yáá ɩjaa láálɩ́ nɛ́, mɔɔ́na bakʊ yɩ.” ");
INSERT INTO kdh_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Amá, mɩ́nyɔ́ɔ́ mɩ́ndɔ́m sɩsɩ a ɩrʊ́ wɔɔdɔ́ ɩgɔɔ yáá ɩjaa sɩsɩ: “Wenbí máázɩ́ɩ sɩ malá nya kʊjɔɔwʊ na bɩsɩná nya nɛ́, mɔ́ɔ́gbɔ́ɔ bɩ malá Ɩsɔ́ɔ sarɔ́ɔ,” ");
INSERT INTO kdh_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","mɩ́nwɩlɩ́ɩ sɩsɩ bidokúti bɩbɔ́ɔ́zɩ bʊdʊ́ʊ ɩɖɔ́ɔ́zɩ ɩgɔɔ yáá ɩjaa. ");
INSERT INTO kdh_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Bɩlɛ́ gɛ mɩ́nlám mɩ́ngbɔwʊ́ʊ mɩ́dɛ́ɛ taáɖɛ mɩ́nɖɩnáa Ɩsɔ́ɔ-dɛ́ɛ tɔ́m; ngɛ míígúti mɩ́nlám yáásɩ́wá natɩ́rɩ tɩɩlɩ́ɩ tɩna nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ngɛ Yeésu waadáyáa zamɔ́ɔ ɩtɔ́ kɩ sɩsɩ: «Mɩ́rɩ́ŋa iwélesi ɩnɩ́ɩ ma kazɔ́ɔ: ");
INSERT INTO kdh_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nabʊ́rʊ fɛ́yɩ́ bɩ́nzʊʊ́ ɩrʊ́ nɔɔ́-daá na bɩbɩsɩná yɩ weení ɩvɛ́yɩ́ ɖacɩrɩ‑cɩrɩ nɛ́. Amá, wenbí bɩ́nlɩɩ́ ɩrʊ́-daá nɛ́ wánbɩsɩnáa kʊ yɩ weení ɩvɛ́yɩ́ ɖacɩrɩ‑cɩrɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Weení ɩwɛná nɩgbamʊʊ́ sɩ ɩnɩ́ɩ nɛ́, ɩlɛ́ ɩ́nɩɩ.» ");
INSERT INTO kdh_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ngɛ Yeésu weeyéle zamɔ́ɔ, bɩka ibó ɩsʊ́ʊ ɖaána. Ńna gɛ ɩwanbaaráa wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ ɩ́lɩ́zɩ́ wɛ tɔmgɛɛzɩrɛ ɖɩḿ ɖugutoluú. ");
INSERT INTO kdh_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ngɛ wɔɔdɔ́ wɛ sɩsɩ: «A bɩlɛ́, mɩ́nyɔ́ɔ́ ɖʊɖɔ mɩ́vɛ́yɩ́na tɩlɩ́ɩ? Mɩ́ɩ́sɩ sɩsɩ wenbí bɩrɩ́ŋa bɩ́nzʊʊ́ ɩrʊ́-daá nɛ́ tánbɩɩzɩ bɩbɩsɩná yɩ weení ɩvɛ́yɩ́ ɖacɩrɩ‑cɩrɩ nɛ́? ");
INSERT INTO kdh_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Káma, bɩ́dánzʊʊ iwenbiré-daá, amá, bíndím lóódi-daá gɛ, na bɩlɩ́ɩ bɩɖɛ́ɛ ɖɩyáásʊ́-daá.» Yeésu waaŋmátɩ bɩlɛ́ nɛ́, waawɩ́lɩ sɩsɩ kíɖíídi rɩ́ŋa kɛ́ɛ ɖacɩrɩ‑cɩrɩ kpɩná gɛ. ");
INSERT INTO kdh_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ngɛ waadásɩ ɩtɔ́ sɩsɩ: «Wenbí bɩ́nlɩɩ́ ɩrʊ́-daá nɛ́, bɩ́nbɩsɩnáa kʊ yɩ weení ɩvɛ́yɩ́ ɖacɩrɩ‑cɩrɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Káma, wenbí bɩ́nlɩɩ́ ɩrʊ́-daá nɛ́, wángalɩɩnáa iwenbiré-daá gɛ; ńna gɛ lomaazɛ́ tɩtɛ ńná wángalɩɩnáa: bɛɛ tɩtɛ-lakásɩ, ŋmɩɩlɩ́m, ɩráa kʊ́ʊ, ");
INSERT INTO kdh_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ɩrʊ́ ɩlɩ́ɩ ɩɖɛɛlʊ́ yáá ɩwaalʊ́ wɔ́rɔ́, liideé na kpɩná-dɛ́ɛ sɔɔlɩ́m ɖabata, kánnyáádɩ, ɩráa tuulím, wásangarɩ́tɩ, sʊ́ʊ́zɩ, kaawarɔɔ, ɩrʊ́-dɛ́ɛ ɩdɩ wɩlɩ́ɩ, kʊjʊʊ́ fɛ́yɩ́-dʊ́ʊ lakásɩ. ");
INSERT INTO kdh_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Wenbiré-daá gɛ yáásɩ́wá tɩḿ tɩdaavé nɛ́ tɩ́ngalɩɩnáa, ngɛ tɩ́nlám kʊ gɛ ɩrʊ́ fɛ́yɩ́ ɖacɩrɩ‑cɩrɩ.» ");
INSERT INTO kdh_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ngɛ Yeésu waalɩ́ɩ ńna ɩɖɛ́ɛ Tíiri laadɔ́ɔ fáráńdɩ́. Waadála nɛ́, ngɛ waazʊ́ʊ ɖaána nɛkɛ́rɛ-daá. Ɩdacáa sɩsɩ báa naárʊ ɩtɩlɩ́, amá, na bɩrɩ́ŋa, ɩdabɩ́ɩ́zɩ ɩmʊ́sɩ ɩdɩ. ");
INSERT INTO kdh_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Káma, alʊ́ naárʊ waanɩ́ɩ bánŋmatɩ́ ɩdɔ́m. Alʊ́ ɩmʊ́, zííni wánjaarɩ́ ɩwɛɛlɛ́ɛ. Waanɩ́ɩ Yeésu tɛ́nɩ nɛ́, ngɛ wɔɔgɔ́nɩ ití isóm waazá-daá. ");
INSERT INTO kdh_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Alʊ́ ɩmʊ́ ɩdɛkɛ́ɛ Yahúúɖu, Siríi laadɔ́ɔ-dɛ́ɛ tɛ́ɛ́dɩ bánÿaá tɩ sɩsɩ Fenisíi nɛ́ tɩdaá gɛ baalʊ́rʊ yɩ. Wɔɔgɔ́nɩ wánvɩnɩ́ Yeésu sɩsɩ ɩ́ɖɔɔ zííni ɩwɛɛlɛ́ɛ-rɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ngɛ Yeésu wɔɔdɔ́ yɩ sɩsɩ: «Yele bíya iɖi bɔfɔ́ɔ naanɩ́, káma, bɩvɛ́yɩ́ kazɔ́ɔ sɩsɩ bɔkpɔ́ɔ bíya-dɛ́ɛ kíɖíím bɔlɔ fáa‑bíya.» ");
INSERT INTO kdh_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ńna gɛ alʊ́ woobúsi yɩ sɩsɩ: «Toovonúm gɛ, amá, kʊ́bɔnɩ́, na bɩrɩ́ŋa, fáa‑bíya wánjalaazɩ́ cʊ́kɔ wenkí kɩ́nlɩɩ́ bíya-dɛ́ɛ tébíri-rɔ bɩ́nzalɩ́ɩ nɛ́ sínɖíi.» ");
INSERT INTO kdh_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ngɛ Yeésu wɔɔdɔ́ yɩ sɩsɩ: «Nyɛ́dɛ́ɛ busí bɩna bʊrɔ, bo nbɩ́sɩ nyɛ́dɛ́ɛ, zííni waalɩ́ɩ nwɛɛlɛ́ɛ-rɔ.» ");
INSERT INTO kdh_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Alʊ́ waabɩ́sɩ ikpé ɩdɛ́ɛ nɛ́, wɔɔmɔɔná ibú fɩ́nɛ́ɛ gáɖó-rɔ, bɩka zííni wáńlɩ́ɩ́ ɩrɔ. ");
INSERT INTO kdh_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Bɩlɛ́ bʊwɔ́rɔ́ nɛ́, Yeésu waalɩ́ɩ Tíiri laadɔ́ɔ-daá ɩkpɔɔná Sidɔ́ɔnɩ tɛ́ɛ́dɩ-daá, ngɛ waagábaná laadɔ́ɔ bánÿaá kɛ sɩsɩ Tɛ́ɛ́dɩwá fuú tɩdamáa nɛ́, ɩkábɩsɩ Galilée lɩɩrɛ́ kʊ́bɔńɖɛ-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ngɛ bɔɔgɔ́gɔ́ná yɩ ndaḿ komóomúŋa nɛkɛ́rɛ bánvɩnɩ́ yɩ sɩsɩ ɩ́tɩnɩ kɛ nʊ́ʊ́zɩ. ");
INSERT INTO kdh_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ngɛ waanára yɩ ɩ́na yɩ balɩ́ɩ kpɔ́mɔ́ɔ́ balaná zamɔ́ɔ bolíni. Ńna gɛ waaɖʊ iníízi ɩrʊ́ ɩmʊ́ ɩnɩgbamɩ́nɩ-daá, ɩtɔ ndɔɔlɩmá ɩnʊ́ʊ́nɩ-rɔ itekiná wanzʊlʊmʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Waalá bɩlɛ́ nɛ́, ngɛ waagbáázɩ waazá ɩsɔ́ɔ́dáá, itísi weezuú. Ngɛ wɔɔdɔ́ ɩrʊ́ ɩmʊ́ sɩsɩ: «Efááta!» Bugutoluú sɩsɩ: Tʊlʊ́! ");
INSERT INTO kdh_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ńna‑ńna gɛ ɩnɩgbamɩ́nɩ waadʊlʊ́, wanzʊlʊmʊ́ʊ ibóɖi, ɩcáŋ ɩbáázɩ ŋmatɩrɛ sɛ́yɩ́‑sɛ́yɩ́. ");
INSERT INTO kdh_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yeésu waabásɩ wɛ sɩsɩ bákaŋmátɩ tɩ naárʊ-jɔ́. Amá, sáátɩ wenkí wéngizináa wɛ nɛ́, bɩdɛ́ɛ sáátɩ gɛ baabá bénveerím tɩ. ");
INSERT INTO kdh_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Bɩɩlá wɛ mááɖé páá bɩcɛzɩ́ hálɩ bɔ́ndɔ́m sɩsɩ: «Wenbí bɩrɩ́ŋa wánlám nɛ́, ɩbá bɩjɔɔ́ɔ kazɔ́ɔ páá, wénÿelíi ndamáa wánnɩɩ́ bɩka komóomúsi wánŋmatɩ́.» ");
INSERT INTO kdh_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Wɛ́-bíya bɛḿ badaá nɛ́, zamɔ́ɔ kʊ́bɔńgɩ wɔɔdɔ́kɔnɩ́ kɩlára kɩmɩlɩná Yeésu; ngɛ ńŋɩnáa nabʊ́rʊ fɛ́yɩ́ sɩ kiɖi nɛ́, waayáa ɩwanbaaráa ɩtɔ́ wɛ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Zamɔ́ɔ kɩna kɩjɔɔ́ɔ ma kʊnyɔḿ, káma, wɛ́ náádoozo nbɩlɛ́ kʊwɛ mɔ́jɔ́ nɛ́, ngʊ́ kɩvɛ́yɩ́na nabʊ́rʊ sɩ kiɖi. ");
INSERT INTO kdh_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","A mééyéle kikpé kɩdɛ́ɛ kideɖi nabʊ́rʊ, kɩ́ngɔnɩ́ kɩwɩ́ɩ nɩ́bááwʊ-daá, káma, nɛbɛ́rɛ waagálɩ́ɩ́ná bolíni.» ");
INSERT INTO kdh_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ngɛ wanbaaráa wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Lé gɛ ɖónÿuú na kpɔ́nɔ́wá faɖáma kɩna kɩdaá bɩtála zamɔ́ɔ ńŋɩnáa kɩna kɩtɔ́ɔ kɩfɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ngɛ Yeésu wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «Kpɔ́nɔ́wá nŋɩ́nɩ́ gɛ mɩ́wɛná.» Ngɛ boobúsi yɩ sɩsɩ: «Tɩrɔ lʊbɛ.» ");
INSERT INTO kdh_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ngɛ weeyéle zamɔ́ɔ ɩcɔ́ɔ adɛ. Ngɛ wɔɔgbɔ́ɔ kpɔ́nɔ́wá lʊbɛ tɩḿ, waazá Ɩsɔ́ɔ bɩtɛ́ nɛ́, ngɛ wɛɛbɛlɩ́ tɩ ɩkpɔ́ɔ icéle ɩwanbaaráa sɩsɩ bátára zamɔ́ɔ. Ngɛ bɛlɛ́ baadára wɛ tɩ. ");
INSERT INTO kdh_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tiiná yáawá cʊ́kɔ ɖʊɖɔ fʊnwɛ bɔjɔ́. Yeésu waazá Ɩsɔ́ɔ bʊrɔ ngɛ weejéle wɛ sɩsɩ bátára yɛ ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ngɛ bɔɔdɔ́ɔ bɔfɔ́ɔ. Fɔɔlásɩ sɩɩga wanbaaráa wɔɔdɔ́ɔ́zɩ nɛ́ woozu ɖɔkɩ́nɩ lʊbɛ. ");
INSERT INTO kdh_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ngʊ́ bavʊngɛ́ɛ gɛ nyazɩ abaaláa mííli nɔɔ́náázá bɩlɛ́. Bʊwɔ́rɔ́ nɛ́, ngɛ Yeésu wɔɔdɔ́ wɛ bekpé bɛdɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Nɔɔ́ kʊ́ɖʊḿ nɛ́, woobó ɩkpa kpɩ́ɩ́rʊʊ́-daá ɩ́na ɩwanbaaráa bɛɖɛ́ɛ Dalɩmanúúta laadɔ́ɔ fáráńdɩ́. ");
INSERT INTO kdh_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ńna gɛ Faríizi ńba nɛbɛ́rɛ wɔɔgɔ́nɩ bána Yeésu babáázɩ ŋmatɩrɛ. Sɩ bayɩ́ yɩ kɔdɔká nɛ́, bɔɔdɔ́ yɩ sɩsɩ ɩ́la wɛ maamááci nakɩ́rɩ na bɩwɩ́lɩ sɩsɩ Ɩsɔ́ɔ-jɔ́ gɛ waagálɩ́ɩ́ná. ");
INSERT INTO kdh_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yeésu waabá itísi weezuú bɩtɛ́ nɛ́, ngɛ wɔɔdɔ́ sɩsɩ: «We-rɔ gɛ zaamáánɩ kɩna kɩdɛ́ɛ ɩráa wɔ́nbɔɔzɩ́ maamááci. Aayɩ́, ménveerím mɩ́ɩ toovonúm sɩsɩ zaamáánɩ kɩna kɩdɛ́ɛ ɩráa tánnáa maamááci nakɩ́rɩ.» ");
INSERT INTO kdh_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Waaŋmátɩ bɩlɛ́ bɩtɛ́ nɛ́, ngɛ weeyéle wɛ ibó ɩkpa kpɩ́ɩ́rʊʊ́-daá ɩɖɛ́ɛ lɩɩrɛ́ kʊ́bɔńɖɛ-dɛ́ɛ fúu lí ńgɩ-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Wanbaaráa wɔɔzɔɔná bɔdɔkpɔ́ɔ kpɔ́nɔ́wá. Kʊ́ɖʊmʊ́ʊ kóŋ́ wɛná bɔjɔ́ kpɩ́ɩ́rʊʊ́-daá. ");
INSERT INTO kdh_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yeésu wɛ wánbasɩ́ wɛ wɔ́ndɔ́m sɩsɩ: «Ɩlá laakáarɩ na Faríizi ńba na wúro Eróodi bɛdɛ́ɛ faadɩ́nɩ bónnuudináa kpɔ́nɔ́ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Wanbaaráa waamáázɩ sɩsɩ bɛḿ bɔdɔkɔ́gbɔɔ kpɔ́nɔ́wá-rɔ nɛ́ gɛ wɔɔdɔ́ bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Amá, Yeésu waadɩlɩ́ bɛdɛ́ɛ lomaazɛ́, ngɛ wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «Ngbaalá gɛ mɩ́ɩ́máázɩ sɩsɩ mɩ́dɔkɔ́gbɔɔ kpɔ́nɔ́wá nɛ́-rɔ gɛ. A bɩlɛ́, mɩ́danɩɩ tá kazɔ́ɔ? Mɩ́vɛ́yɩ́na tɩlɩ́ɩ? Míwenbé cɔɔ́ɔ ɖóni gɛ? ");
INSERT INTO kdh_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mɩ́wɛná ɩzá, bɩka mɩ́dánnáa; mɩ́wɛná nɩgbamɩ́nɩ, bɩka mɩ́dánnɩɩ. ");
INSERT INTO kdh_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Mɩ́raadɔɔzɛ́ɛ kpɔ́nɔ́wá natʊ́nʊ́wá máádára ɩráa mííli nɔɔ́nʊ́wá ɩtɔ́ɔ nɛ́, na ɖɔkɩ́nɩ tɩrɔ nŋɩ́nɩ́ mɩ́ɩ́ɖʊ́ fɔɔlásɩ sɩɩga nɛ́?» Ngɛ boobúsi yɩ sɩsɩ: «fuú na natɩ́lɛ». ");
INSERT INTO kdh_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","«Ngɛ kpɔ́nɔ́wá tɩrɔ lʊbɛ máádára ɩráa mííli nɔɔ́náázá ɩtɔ́ɔ nɛ́, ɖɔkɩ́nɩ tɩrɔ nŋɩ́nɩ́ gɛ mɩ́ɩ́ɖʊ́ fɔɔlásɩ sɩɩga nɛ́.» Ngɛ boobúsi yɩ sɩsɩ: «lʊbɛ». ");
INSERT INTO kdh_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ngɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Bɩlɛ́ nɛ́, mɩ́dánɩɩ tá?» ");
INSERT INTO kdh_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Bɩlɛ́ bʊwɔ́rɔ́ nɛ́, ngɛ baalɩ́ɩ bobó Bɛtɩsayɩdáa tɛɛbiiyá-daá. Bɔwɛ ńna gɛ bɔɔgɔná njɛm naárʊ Yeésu-jɔ́ bánvɩnɩ́ yɩ sɩsɩ ítékíná yɩ. ");
INSERT INTO kdh_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yeésu wɔɔɖɔ́kɩ njɛm nʊ́ʊ́nɩ-daá ɩ́na yɩ balɩ́ɩ kpɔ́mɔ́ɔ́ balaná tɛɛbiiyá bolíni. Ngɛ waadáa ndɔɔlɩmá njɛm ɩzá-rɔ, ɩtɩ́nɩ yɩ nʊ́ʊ́zɩ, ngɛ wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Nyánnáa nabʊ́rʊ?» ");
INSERT INTO kdh_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Njɛm woovulú waazá nɛ́, ngɛ woobúsi yɩ sɩsɩ: «Mánnáa ɩráa, amá, bɔjɔɔ́ɔ nyazɩ tɩ́ɩ́nɩ, bɩka bánnʊŋ́.» ");
INSERT INTO kdh_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ngɛ Yeésu waadátɩnɩ nʊ́ʊ́zɩ njɛm ɩzá-rɔ. Ɩlɛ́ wɛɛbɛ́ɛ́ŋ tíḿḿ nɛ́, waawáa ngɛ waabáázɩ náa kazɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ngɛ Yeésu wɔɔdɔ́ yɩ ikpé ɩdɛ́ɛ, bɩka ɩbásɩ yɩ sɩsɩ ɩ́katánzʊʊ tɛɛbiiyá-daá ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yeésu na ɩwanbaaráa baalɩ́ɩ bɛ́nɖɛɛ́ tɛɛbíízi sɩjʊ́ʊ́na Sezarée, tɛ́ɛ́dɩ wentí wúro Filíipu waama tɩ nɛ́ sɩdaá. Babamáa ɖɛɛ́ nɛ́, ngɛ Yeésu wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «Ɩráa-dɛ́ɛ ŋmatɩrɛ-daá nɛ́, weení gɛ mɛ́gɛ́ɛ.» ");
INSERT INTO kdh_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ngɛ bɛlɛ́ boobúsi yɩ sɩsɩ: «Nɛbɛ́rɛ sɩsɩ nyɔ́ɔ́ gɛ Yaayá, nɛbɛ́rɛ sɩsɩ Elíya, yáá anɖébiwá-daá naárʊ.» ");
INSERT INTO kdh_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ńna gɛ Yeésu wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «Mɩ́nyɔ́ɔ́ mɩ́jɔ́ ní, weení gɛ mɛ́gɛ́ɛ.» Ngɛ Pétro woobúsi yɩ sɩsɩ: «Nyɔ́ɔ́ gɛ Lɛɛrʊ́.» ");
INSERT INTO kdh_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ngɛ Yeésu waabá ɩbásɩ wɛ sɩsɩ békefééri tɩ báa naárʊ. ");
INSERT INTO kdh_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Sáátɩ kɩḿ gɛ waabáázɩ wɛ wɩlɩ́ɩ sɩsɩ: «Bɩ́nbɔɔzɩ́ Ɩrʊ́ Biyaalʊ́ ɩna wahála ɖabata, Yahúúɖuwá-dɛ́ɛ kʊ́bɔnáa na sarásɩ lanɖáa kʊ́bɔnáa, na Mará wɩlɩɖáa ikízi yɩ, bakʊ yɩ, amá, wɛ́ náádoozo wɩ́rɛ nɛ́, ifé ɩlɩ́ɩ ɩsɩɖáa-daá.» ");
INSERT INTO kdh_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Waaŋmatɩná wɛ bɩlɛ́ gɛ ɩyáázɩ. Ńna gɛ Pétro waanára yɩ ɩlɩɩná kpɔ́mɔ́ɔ́ wéngizináa yɩ. ");
INSERT INTO kdh_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ngɛ Yeésu wɛɛgɛ́ɛ́zɩ ɩwɔ́rɔ́, ɩbɛ́ɛ́ŋ ɩwanbaaráa, ngɛ wooyooná Pétro ɩtɔ́ yɩ sɩsɩ: «Laná ma bolíni, Sitáánɩ! Káma, nyólomaazɛ́ tɛkɛ́ɛ Ɩsɔ́ɔ-dɛ́ɛ lomaazɛ́, amá, ɩráa-dɛ́ɛ ńná gɛ agɛ́ɛ.» ");
INSERT INTO kdh_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ngɛ Yeésu waayáa zamɔ́ɔ na ɩwanbaaráa, ngɛ wɔɔdɔ́ wɛ sɩsɩ: «A naárʊ sɔɔlɛ́ɛ sɩ ifu ma, íkizi ɩdɩ bɩka ɩkpɔ́ɔ ɩdɛ́ɛ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ ikóvú ma. ");
INSERT INTO kdh_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Káma, weení wánjáádɩ sɩ ɩlɛ́ɛ iweezuú nɛ́, wɛ́ngɛbɛɖɩ́ kɩ. Amá, weení wɛ́nbɛɖɩ́ iweezuú mɔ́rɔ́ɔ́zɩ́ na Laabáárʊ Kífeńgi-rɔ nɛ́, wóngoyuú kɩ. ");
INSERT INTO kdh_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ɩrʊ́ iɖi ɖúúlínya rɩ́ŋa, amá, ɩbɛ́ɖɩ iweezuú nɛ́, we gɛ bɩvɔ́ɔ́zɩrɛ. ");
INSERT INTO kdh_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Yáá we gɛ ɩrʊ́ wánbɩɩzɩ́ ɩfɛ́rɛ na ɩmʊ iweezuú. ");
INSERT INTO kdh_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Káma, weení ɩrɩ́ŋa mɔ́dɔ́m sɩ ɩlá yɩ fɛɛrɛ́, yáá mɛ́dɛ́ɛ ŋmatɩrɛ sɩ ɩlaná yɩ fɛɛrɛ́ zaamáánɩ ɩráa bana bádánzɩŋná Ɩsɔ́ɔ riké bɩka bánlám alaháácɩ́wá nɛ́ bɔlɔwʊtáá nɛ́, ɩdɔ́m wánlám Ɩrʊ́ Biyaalʊ́ ɖʊɖɔ fɛɛrɛ́ sáátɩ wenkí sɩ ɩkɔ́nɩ na ɩjaa-dɛ́ɛ ásícé-daá ɩ́na ɩdɛ́ɛ malááyɩ́kawá nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yeésu waadásɩ ɩtɔ́ wɛ sɩsɩ: «Ménveerím mɩ́ɩ toovonúm sɩsɩ nɛbɛ́rɛ wɛ cé bádánzɩḿ naanɩ́ bana Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ ɩkɔnɩ ná yíko.» ");
INSERT INTO kdh_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Wɛ́ loɖo wɔ́rɔ́ nɛ́, Yeésu wɔɔgbɔ́ɔ Pétro na Yaakúbu na Yʊháánɩ, ɩ́na wɛ bobó bakpa bʊ́ʊ kʊ́bɔńgɩ nakɩ́rɩ kʊjʊʊ́-rɔ bɔgɔjɔɔ́ɔ beriké. Ngɛ Yeésu-dɛ́ɛ yáásɩ́ wɛɛgɛ́ɛ baazá-daá ńna. ");
INSERT INTO kdh_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ɩdɛ́ɛ kpɩná izóóna nɛ́ waavʊ́lʊ párɩ́‑párɩ́. Ɖúúlínya-daá, wenbá bánvʊlaazɩ́ kpɩná nɛ́, badaá báa naárʊ tánbɩɩzɩ ɩfʊ́laazɩ bɩfʊ́lʊ ńŋɩnáa bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ńna gɛ Elíya na Múúsá baaɖʊ balɩ́ɩ bɔrɔ bána Yeésu bánŋmatɩ́. ");
INSERT INTO kdh_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ngɛ Pétro wɔɔdɔ́ Yeésu sɩsɩ: «Kʊ́bɔnɩ́, ɖɛ́dɛ́ɛ cénjé cɔwʊ́ʊ wánlám kazɔ́ɔ; ɖɩ́la kɛ́rɛ́ɛ́zɩ nasúdoozo: nyɔ́ɔ́ kʊ́ɖʊmɔ́ɔ, Múúsá kʊ́ɖʊmɔ́ɔ, Elíya kʊ́ɖʊmɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Wánŋmatɩ́ bɩlɛ́ nɛ́, waatanzɩ wentí-daá ɩwɛ nɛ́, káma, nɩdáárɛ kʊ́bɔńɖɛ wáńbá ɖɩkpa wɛ. ");
INSERT INTO kdh_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ŋmɩnʊʊ́ nakɩ́rɩ waaɖʊ kɩlɩ́ɩ kɩbála kifu bɔrɔ. Ngɛ baanɩ́ɩ lowú nakɩ́rɩ ŋmɩnʊʊ́-daá sɩsɩ: «Ceení gɛ Mebiyaalʊ́ weení máábá mɔzɔ́ɔ́lɩ yɩ nɛ́, ɩnɩɩná yɩ.» ");
INSERT INTO kdh_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Baajáŋ bɛbɛ́ɛ́ŋ balára bamɩ́lɩ nɛ́, badana naárʊ, Yeésu riké gɛ baana bɔjɔ́. ");
INSERT INTO kdh_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Sáátɩ wenkí béngedím bʊ́ʊ nɛ́, ngɛ Yeésu waabásɩ wɛ sɩsɩ békefééri naárʊ wenbí baana nɛ́, hálɩ Ɩrʊ́ Biyaalʊ́ ifé ɩlɩ́ɩ ɩsɩɖáa-daá. ");
INSERT INTO kdh_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Boovu balá wentí Yeésu waabásɩ wɛ nɛ́ tɩrɔ kazɔ́ɔ. Amá, na bɩrɩ́ŋa, bɔwɛ bɔ́nbɔɔzɩ́ ɖamá sɩsɩ: «“Ɩrʊ́ Biyaalʊ́ ifé ɩlɩ́ɩ ɩsɩɖáa-daá” kutoluú gɛ sɩ wé.» ");
INSERT INTO kdh_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ńna gɛ wanbaaráa wɔɔbɔ́ɔ́zɩ Yeésu sɩsɩ: «We-rɔ gɛ Mará wɩlɩɖáa wánŋmatɩ́ sɩsɩ asée Elíya wɔ́ńgɔ́nɩ́ naanɩ́.» ");
INSERT INTO kdh_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Toovonúm, Elíya wɔ́ngɔnɩ́ ɩnyɔ́ɔ́zɩ báa wenbí naanɩ́. Tɔ́ɔ, ngʊ́ ngbaalá gɛ baaŋmáa Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá ɖʊɖɔ sɩsɩ Ɩrʊ́ Biyaalʊ́ wánbá ɩna wahála bɩka bɛkpɛɛná yɩ. ");
INSERT INTO kdh_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Amá, ménveerím mɩ́ɩ sɩsɩ Elíya wɔ́ńgɔ́nɩ́, ngɛ baalaná yɩ wenbí bolowú fáa bɩ nɛ́ ńŋɩnáa wenbí Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá waaŋmátɩ ɩrɔɔzɩ́ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Sáátɩ wenkí baagábɩ́sɩ wanbaaráa baaganáa-jɔ́ nɛ́, baana zamɔ́ɔ tuutúúma wáńlárɩ́ kɩmɩlɩná wɛ, bɩka Mará wɩlɩɖáa wɛ bána wɛ bánŋmatɩ́. ");
INSERT INTO kdh_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Zamɔ́ɔ waagʊ́sɩ gɛ kɩɩgána Yeésu nɛ́, bɩɩbá bɩlá kɩ bítí, ngɛ kɩɩgbɔ́ɔ sewɔ́ɔ nɔɔ́ kʊ́ɖʊḿ kɩ́nɖɛɛ́ sɩ kɩkɛ́zɛɛ yɩ. ");
INSERT INTO kdh_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ngɛ Yeésu wɔɔbɔ́ɔ́zɩ ɩwanbaaráa sɩsɩ: «Wentí gɛ mɩ́na wɛ mɩ́wɛ mɩ́nŋmatɩ́.» ");
INSERT INTO kdh_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ńna gɛ zamɔ́ɔ-daá, naárʊ woobúsi yɩ sɩsɩ: «Kʊ́bɔnɩ́, mɔ́ɔ́gɔ́ná nya mebiyaalʊ́ gɛ, káma, zííni nakɩ́rɩ wánjaarɩ́ yɩ, kɩɩbɩsɩná yɩ komóomúŋa ɩ́dánŋmatɩ. ");
INSERT INTO kdh_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Báa lé gɛ zííni kɩḿ kɩɩgʊrʊ́na yɩ, kɩ́nlɔ́ɔ yɩ adɛ gɛ; na bú nɔɔ́ ɩbáázɩ kʊbʊʊdʊ́ʊ lɩɩ́, wánzarɩ́ɩ ɩgalá, bɩka ɩdɔnʊʊ́ ɩkpa ɖóni. Máávɩ́nɩ nyɛ́dɛ́ɛ wanbaaráa sɩsɩ bɔ́ɖɔɔ zííni kɩḿ, amá, badabɩ́ɩ́zɩ.» ");
INSERT INTO kdh_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ngɛ Yeésu sɩsɩ: «Zaamáánɩ ɩráa badafa Ɩsɔ́ɔ toovonúm nɛ́ bana ɖɔ́! Wɛ́ nŋɩ́nɩ́ gɛ móguti mɔjɔ́ɔ mɩ́jɔ́. Wɛ́ nŋɩ́nɩ́ gɛ móguti mɔɖɔ́kɩ mɩ́ɩ. Ɩgɔná ma bú ɩmʊ́ cé.» ");
INSERT INTO kdh_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ngɛ bɔɔgbɔ́ɔ bú ɩmʊ́ bɔkɔ́gɔ́ná Yeésu. Sáátɩ wenkí zííni waajáŋ gɛ kɩɩna Yeésu nɛ́, ngɛ kɩɩbá kicuúdi bú na ɖóni, ngɛ bú waazála adɛ, ibiláázɩ ɩdɩ bɩka ɩnɔɔ́ ɩbáázɩ kʊbʊʊdʊ́ʊ lɩɩ́. ");
INSERT INTO kdh_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ńna gɛ Yeésu wɔɔbɔ́ɔ́zɩ bú ɩjaa sɩsɩ: «Ɖoo ngbeére gɛ bɩɩbáázɩ yɩ.» Ngɛ ɩlɛ́ woobúsi yɩ sɩsɩ: «Ɖoo ibijáádɩ-daá gɛ. ");
INSERT INTO kdh_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Bɩlɛ́ gɛ kɩɩlɔɔná yɩ lɔ́ɔ nimíni-daá yáá lɩ́m-daá sɩ kɩkʊ yɩ. Amá, a nyánbɩɩzɩ́ nlá nabʊ́rʊ, la suúru nnɩ́ɩ ɖágʊnyɔḿ nlɛ́ɛ ɖáa.» ");
INSERT INTO kdh_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ngɛ Yeésu woobúsi yɩ sɩsɩ: «Nyazɩ a mánbɩɩzɩ́ yaá? Weení waava toovonúm nɛ́, nabʊ́rʊ fɛ́yɩ́ ɩ́dánbɩɩzɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ngɛ bú ɩjaa waajáŋ ɩcɔ na ɖóni sɩsɩ: «Máává toovonúm, amá, la suúru nzɩná ma, káma, mɛ́dɛ́ɛ toovonúm fáa tɔɖɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yeésu waana sɩsɩ zamɔ́ɔ bamáa kɔnɩ́ kɩ́nɖɔɔ́ nɛ́, ngɛ waagazɩ́ zííni ɩtɔ́ kɩ sɩsɩ: «Zííni ndaḿ komóomúŋa, mazɩ lɩɩ bú ceení-rɔɔzɩ́! Ngɛ nkokúti nzʊ́ʊ yɩ kɛtɛngɛrɛ.» ");
INSERT INTO kdh_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ngɛ zííni waamá kebísi, kɩcɔlɩ́ bú kɩlɔ adɛ kɩbá kɩ́nnarɩ́ɩ yɩ wɔ́ndɔ́ɔ nʊ́ʊ́zɩ na nʊvɔ́, kɩcáŋ kɩlɩ́ɩ ɩrɔ. Ngɛ bɩɩlá nyazɩ bú waazɩ́ bɩlɛ́, hálɩ ɩráa ɖabata wɔ́ndɔ́m sɩsɩ: «Waazɩ́.» ");
INSERT INTO kdh_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Amá, Yeésu wɔɔɖɔ́kɩ ɩnʊ́ʊ́nɩ-daá ɩkʊ́sɩ yɩ, ngɛ bú waagʊrʊ́ ɩsɩ́ŋ ɩnʊvɔ́-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Sáátɩ wenkí Yeésu waazʊ́ʊ ɖaána nɛ́, ngɛ ɩwanbaaráa woodúu ɩjɔ́ bɔbɔ́ɔ́zɩ yɩ bána yɩ beriké nɛ́ sɩsɩ: «Ngbaalá gɛ ɖɔ́ɔ́ ɖádabɩ́ɩ́zɩ ɖɩɖɔ́ɔ zííni kɩḿ.» ");
INSERT INTO kdh_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Na sʊlʊ́ńdɩ riké gɛ bánbɩɩzɩ́ bɔɖɔɔná zííni ńŋɩnáa kɩna.» ");
INSERT INTO kdh_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yeésu na ɩwanbaaráa baalɩ́ɩ ńna bɔkpɔ́ɔ nɩ́bááwʊ bɔkpɔɔná Galilée laadɔ́ɔ-rɔ bɛ́nɖɛɛ́. Yeésu tacáa sɩsɩ naárʊ ɩ́tɩ́lɩ́ lé ɩwɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Káma, ɩwɛ wánwɩlɩ́ɩ ɩwanbaaráa wénveerím wɛ sɩsɩ: «Bángbáa Ɩrʊ́ Biyaalʊ́ becéle ɩráa; bɛlɛ́ bángʊ́ʊ yɩ, amá, toozo wɩ́rɛ, wénvém ɩlɩ́ɩ ɩsɩɖáa-daá.» ");
INSERT INTO kdh_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Amá, wanbaaráa bɛlɛ́ badanɩ́ɩ tɔ́m tɩḿ tugutoluú, ngʊ́ bénzée nɩdáárɛ sɩsɩ bɔbɔ́ɔ́zɩ yɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bɛɛɖɛ́ɛ bɩlɛ́ hálɩ batála Kapɛrɩnawʊ́m. Sáátɩ wenkí baazʊ́ʊ ɖaána-daá nɛ́, ngɛ Yeésu wɔɔbɔ́ɔ́zɩ ɩwanbaaráa sɩsɩ: «Wentí gɛ mɩ́ngaŋmatɩ́ nɩ́bááwʊ-daá ye.» ");
INSERT INTO kdh_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Amá, bɛlɛ́ bozumáa, káma, nɩ́bááwʊ-daá nɛ́, baagáŋmátɩ́ná ɖamá na batɩlɩ́ weení ɩgɛ́ɛ kʊ́bɔnɩ́ bɔlɔwʊtáá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ńna gɛ Yeésu weedí ɩcɔ́ɔ, ngɛ waayáa wanbaaráa fuú na nɔɔ́lɛ bɛḿ ɩtɔ́ wɛ sɩsɩ: «A naárʊ sɔɔlɛ́ɛ sɩsɩ ɩbɩ́sɩ kaɖaa ńnɩ́, bʊdʊ́ʊ ɩ́bɩ́sɩ́ná ɩdɩ mɩ́rɩ́ŋa mɩ́dɛ́ɛ kegbiirinɔ́ɔ ńnɩ́ na mɩ́dɛ́ɛ bɔwʊtá-dʊ́ʊ.» ");
INSERT INTO kdh_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Bʊwɔ́rɔ́ nɛ́, ngɛ Yeésu wɔɔgbɔ́ɔ bú naárʊ ɩkɔná ɩsɩ́ɩ bɔlɔwʊtáá, ikpíriki yɩ, ngɛ wɔɔdɔ́ wɛ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Weení waamʊ bú ńŋɩnáa ceení ɩgɔ́ńdɩ mɔ́rɔ́ɔ́zɩ́ nɛ́, mádɩtɩŋa gɛ waamʊ, ngɛ weení waamʊ ma nɛ́, bɩdɛkɛ́ɛ mɔ́ɔ́ mériké gɛ waamʊ, amá, bɩkpɛdɩ́na weení weegédíri ma nɛ́ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Bɩnáábɩ́lɛ́ Yʊháánɩ wɔɔdɔ́ Yeésu sɩsɩ: «Kʊ́bɔnɩ́, ɖááná naárʊ wɔ́nɖɔwʊ́ʊ zííniwá na nyáyɩ́ɖɛ-daá, ɖɔ́ɔ́ ɖɔ́ɔ́zɔ́ɔ́lɩ sɩ ɖikiziná yɩ, káma, ɩraavóo ɖáa.» ");
INSERT INTO kdh_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ngɛ Yeésu woobúsi yɩ sɩsɩ: «Íkekiziná yɩ, káma, naárʊ fɛ́yɩ́ wánlám maamááci nakɩ́rɩ na máyɩ́ɖɛ-daá, na bʊwɔ́rɔ́ nɛ́ ɩcáŋ ɩkʊrʊ́ ɩŋmátɩ tɩdaavé nɛ́ mɔ́rɔ́. ");
INSERT INTO kdh_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Káma, weení ídónÿoo ɖáa nɛ́, fóo ɖáa gɛ. ");
INSERT INTO kdh_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ménveerím mɩ́ɩ toovonúm sɩsɩ weení ɩrɩ́ŋa waava mɩ́ɩ lɩ́m kagbɔ́ɔ sɩ ɩnyɔ́ɔ káma, sɩsɩ mɩ́gɛ́ɛ Krísto-dɛ́ɛ ńba-rɔ nɛ́, wóngoyuú ɩdɛ́ɛ kɩvɛrɛwʊ.» ");
INSERT INTO kdh_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Weení ɩrɩ́ŋa sɩ iyéle bíya bana baava ma toovonúm nɛ́ badaá naárʊ ɩlá alaháácɩ́ nɛ́, a baadaná bʊdʊ́ʊ lowú namɩ́rɛ kʊ́bɔńɖɛ bɔlɔ tenkú-daá, bɩjɔɔ́ɔ sóńcí. ");
INSERT INTO kdh_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","A bɩgɛ́ɛ nyánʊ́ʊ́nɩ wénÿelíi kʊ gɛ nyánÿɩsɩnáa Ɩsɔ́ɔ, cɛ yɩ. Káma, bɩjɔɔ́ɔ sóńcí nzʊ́ʊ arɩjáńna-daá na nʊ́ʊ́nɩ kʊ́ɖʊḿ, bɩkɩlɩná nyánʊ́ʊ́zɩ lɛ́ɛ́nɩ́ wɛ bɩka nzʊ́ʊ azáába nimíni ɩ́dánɖɩḿ kɛtɛngɛrɛ nɛ́ ɩdaá. ");
INSERT INTO kdh_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Lénlé siizeeyá ándɔwʊ́ʊ ɩráa tɔnɩ́nɩ nɛ́ tánzɩḿ bɩka nimíni tánɖɩḿ kɛtɛngɛrɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","A nyɔ́nʊvɔ́rɛ wénÿelíi kʊ gɛ nyánÿɩsɩnáa Ɩsɔ́ɔ, cɛ ɖɛ. Káma, bɩjɔɔ́ɔ sóńcí nzʊ́ʊ arɩjáńna-daá nʊvɔ́rɛ kʊ́ɖʊńɖɛ fɛ́yɩ́ bɩkɩlɩná nyɔ́nʊvɔ́ lɛ́ɛ́nɩ́ wɛ bɩka nzʊ́ʊ azáába nimíni ɩ́dánɖɩḿ kɛtɛngɛrɛ nɛ́ ɩdaá. ");
INSERT INTO kdh_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Lénlé siizeeyá ándɔwʊ́ʊ ɩráa tɔnɩ́nɩ nɛ́ tánzɩḿ bɩka nimíni tánɖɩḿ kɛtɛngɛrɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","A ngʊ́ nyáázɩ́rɛ wénÿelíi kʊ gɛ nyánÿɩsɩnáa Ɩsɔ́ɔ, lɩzɩ́ ɖɛ. Bɩjɔɔ́ɔ sóńcí nzʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-daá na ɩzɩ́rɛ kʊ́ɖʊńɖɛ, bɩkɩlɩná nyáázá lɛ́ɛ́nɩ́ wɛ bɩka nzʊ́ʊ azáába nimíni ɩ́dánɖɩḿ kɛtɛngɛrɛ nɛ́ ɩdaá. ");
INSERT INTO kdh_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Lénlé siizeeyá ándɔwʊ́ʊ ɩráa tɔnɩ́nɩ nɛ́ tánzɩḿ bɩka nimíni tánɖɩḿ kɛtɛngɛrɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ńŋɩnáa bánɖʊ́ʊ ɖɔ́m kíɖíím-daá na bɩlá niíni nɛ́, bɩlɛ́ gɛ Ɩsɔ́ɔ sɩ ɩbaná wahála na ɩnyɔ́ɔ́zɩ báa weení. ");
INSERT INTO kdh_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ɖɔ́m kɛ́ɛ kpɩ́nɖɛ kífeńɖe gɛ. Amá, a ɖɔ́m waazɩ́ niíni, nŋɩ́nɩ́ gɛ bánlám bɩ na bɩtálaḿ niíni ɖʊɖɔ. Bɩlɛ́ nɛ́ mɩ́ɩ ɖʊɖɔ, bɩmɔɔ́na mɩ́jɔɔ́na ɖamá niíni ńŋɩnáa ɖɔ́m cɔɔ́ɔ niíni nɛ́. Bɩka mɩ́rɩ́ŋa ɩcɔ́ɔ fɛɛzɩrɛ-daá.» ");
INSERT INTO kdh_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yeésu waalɩ́ɩ ńna nɛ́, wɛɛɖɛ́ɛ Yudée laadɔ́ɔ-daá, na Yɔrɔdáanɩ buwá-dɛ́ɛ fúu lí ńgɩ-rɔ. Zamɔ́ɔ kʊ́bɔńgɩ wɔɔdɔ́kɔnɩ́ kitúúzi ɩjɔ́ ngɛ ńŋɩnáa bɩgɛ́ɛ ɩdɛ́ɛ ɖɔ́ɔ́ná nɛ́, waadábaazɩ wɛ wɩlɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ńna gɛ Faríizi ńba woogóduu ɩjɔ́ sɩ bayɩ́ yɩ kɔdɔká, ngɛ bɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Bɩɩva nɩ́bááwʊ sɩsɩ ɩrʊ́ ɩ́ɖɔɔ ɩɖɛɛlʊ́?» ");
INSERT INTO kdh_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ngɛ Yeésu ɖʊɖɔ wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «Sɩsɩ wé gɛ Múúsá waazɩ́ɩ́zɩ mɩ́ɩ Mará-daá.» ");
INSERT INTO kdh_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Faríizi ńba woobúsi yɩ sɩsɩ: «Múúsá waazɩ́ɩ́zɩ sɩsɩ a ɩrʊ́ sɩ ikízi ɩɖɛɛlʊ́, ícele yɩ wasɩ́ɩ́ka kɩ́nwɩlɩ́ɩ sɩsɩ weegízi yɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Mɩ́dɛ́ɛ wenbi-ɖóni-rɔ gɛ Múúsá waazɩ́ɩ mɩ́ɩ bɩdɛ́ɛ Mará. ");
INSERT INTO kdh_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Amá, bɩgabaazɩya Ɩsɔ́ɔ waalá ɖúúlínya nɛ́, “waalá wɛ gɛ alʊ́ na abaalʊ́.” ");
INSERT INTO kdh_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Bʊrɔɔzɩ́ gɛ abaalʊ́ wánlɩɩ́ ɩgɔɔ na ɩjaa bɔjɔ́ ibó ɩkpɔ́ɔ alʊ́ boyóózi bɔcɔ́ɔ ");
INSERT INTO kdh_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","babɩ́sɩ tɔnʊʊ́ kʊ́ɖʊmʊ́ʊ.” Ńna nɛ́, bodokúti bɛgɛ́ɛ nɔɔ́lɛ, amá, tɔnʊʊ́ kʊ́ɖʊmʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Bɩlɛ́ nɛ́, ɩrʊ́ ɩ́katara wenbí Ɩsɔ́ɔ waadá nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Baagábɩ́sɩ ɖaána nɛ́, ngɛ Yeésu wanbaaráa waadábaazɩ yɩ tɔ́m tɩḿ bɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ngɛ woobúsi wɛ sɩsɩ: «A naárʊ wɔɔɖɔ́ɔ ɩɖɛɛlʊ́ ngɛ wɔɔgbɔ́ɔ alʊ́ kɩ́falʊ́, waalɩ́ɩ kaɖaa ńnɩ́ wɔ́rɔ́ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Bɩlɛ́ ɖʊɖɔ gɛ a alʊ́ weegízi ɩwaalʊ́ ibó ɩsáa abaalʊ́ kɩ́falʊ́, waalɩ́ɩ ɩwaalʊ́ wɔ́rɔ́.» ");
INSERT INTO kdh_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bɩlɛ́ bʊwɔ́rɔ́ gɛ ɩráa wɔɔgɔná Yeésu bíya sɩsɩ ɩ́tɩnɩ ɩnʊ́ʊ́zɩ bɔrɔ ɩsʊ́lʊ bɔrɔɔzɩ́; amá, Yeésu-dɛ́ɛ wanbaaráa wooyooná wɛ. ");
INSERT INTO kdh_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yeésu waana bɩlɛ́ nɛ́, wɛɛyɛ́ɛ baaná, ngɛ wɔɔdɔ́ ɩwanbaaráa sɩsɩ: «Iyéle bíya ɩkɔ́nɩ mɔ́jɔ́, ɩ́kɔtɔ wɛ nɩ́bááwʊ, káma, wenbá baalɩ́ɩ wɛ nɛ́ badɩɩná Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ménveerím mɩ́ɩ toovonúm sɩsɩ weení ɩdamʊ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ ńŋɩnáa bú nɛ́ tánzʊʊ kadaá kɛtɛngɛrɛ.» ");
INSERT INTO kdh_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Bɩlɛ́ bʊwɔ́rɔ́ gɛ weegbíríki bíya, bɩka wándɩnɩ́ wɛ nʊ́ʊ́zɩ wánzʊlʊ́ʊ bɔrɔ. ");
INSERT INTO kdh_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Sáátɩ wenkí Yeésu wɔɔgbɔ́ɔ nɩ́bááwʊ wɛ́nɖɛɛ́ nɛ́, ngɛ abaalʊ́ naárʊ wɔɔgɔ́nɩ na sewɔ́ɔ ití isóm ɩnʊvɔ́-jɔ́ wɔ́nbɔɔzɩ́ yɩ sɩsɩ: «Kʊ́bɔnɩ́ kazɔ́ɔ ńnɩ́, we gɛ bɩ́nbɔɔzɩ́ sɩsɩ mála na moyuú weezuú kɩ́dɛ́ndɛŋ́ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ngɛ Yeésu woobúsi yɩ sɩsɩ: «We-rɔ gɛ nyánÿaá ma kazɔ́ɔ ńnɩ́. Naárʊ fɛ́yɩ́ ɩgɛ́ɛ kazɔ́ɔ ńnɩ́ a bɩdɛkɛ́ɛ Ɩsɔ́ɔ riké. ");
INSERT INTO kdh_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nyányɩ wenbíwá Mará waazɩ́ɩ́zɩ nɛ́; tɩlɛ́ gɛ sɩsɩ: “Ńdángʊ́ʊ ɩrʊ́, ńdánlɩɩ nɖɛɛlʊ́ wɔ́rɔ́, ńdánŋmɩɩlɩ, ńdánlɩzɩ́ seríya tɩtɛ ńgɩ, ndónduuli naárʊ, ɖʊ ngɔɔ na njaa gírímá.”» ");
INSERT INTO kdh_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ńna gɛ abaalʊ́ ɩmʊ́ woobúsi sɩsɩ: «Kʊ́bɔnɩ́, ɖoo mɛ́dɛ́ɛ afobire-daá gɛ mánlám bɩlɛ́ ɩmʊ́ bɩrɩ́ŋa.» ");
INSERT INTO kdh_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ngɛ Yeésu wɛɛbɛ́ɛ́ŋ yɩ tíḿḿ, ngɛ waalá yɩ kazɔ́ɔ. Ńna gɛ wɔɔdɔ́ yɩ sɩsɩ: «Kʊ́ɖʊńtɩ waaga ná nya, tɩlɛ́ gɛ sɩsɩ: bo nÿá wenbí rɩ́ŋa nyɔ́wɛná nɛ́ nva kadanbʊrʊ́sɩ na ngóyuú ɖɔ́ɔ́lɛ Ɩsɔ́ɔ-jɔ́. A nyáálá bɩlɛ́ bɩtɛ́ na ngɔ́nɩ nvu ma.» ");
INSERT INTO kdh_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Amá, abaalʊ́ ceení waanɩ́ɩ bɩlɛ́ nɛ́, ngɛ waazʊ́ʊ kaanɩŋá ɩɖɛ́ɛ ɖɛfɛɛ, káma, ɩbá ɩgɛ́ɛ ɖɔ́ɔ́lɛ-dʊ́ʊ gɛ. ");
INSERT INTO kdh_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yeésu wɛɛbɛ́ɛ́ŋ ɩlára ɩmɩ́lɩ nɛ́, ngɛ wɔɔdɔ́ ɩwanbaaráa sɩsɩ: «Bɩ́nlám káálɛ na ɖɔ́ɔ́lɛ-dʊ́ʊ ɩsʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-daá!» ");
INSERT INTO kdh_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Yeésu-dɛ́ɛ tɔ́m tɩḿ tɩɩlá ɩwanbaaráa bítí, ńna gɛ waadásɩ ɩtɔ́ wɛ sɩsɩ: «Mébíya, bɩjɔɔ́ɔ káálɛ na ɩrʊ́ ɩsʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-daá. ");
INSERT INTO kdh_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Bɩvɛ́yɩ́ raakúḿ káálɛ sɩsɩ kɩsʊʊ ná ɩjɔ́wʊ bɔyɔ́ɔ bɩtála ɖɔ́ɔ́lɛ-dʊ́ʊ ɩsʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-daá.» ");
INSERT INTO kdh_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Bɩɩdásɩ bɩlá wanbaaráa bítí ɖabata hálɩ bɔ́nbɔɔzɩ́ ɖamá sɩsɩ: «Bɩlɛ́ nɛ́, weení wónÿuúu kʊ lɛ́ɛ́dɩ Ɩsɔ́ɔ-jɔ́ bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ńna gɛ Yeésu wɛɛbɛ́ɛ́ŋ wɛ ngɛ wɔɔdɔ́ wɛ sɩsɩ: «Ɩráa-jɔ́ nɛ́, bɩjɔɔ́ɔ káálɛ; amá, Ɩsɔ́ɔ-jɔ́ nɛ́, bɩvɛ́yɩ́ káálɛ. Káma, wenbí ɩráa tánbɩɩzɩ nɛ́, bɩvɛ́yɩ́ Ɩsɔ́ɔ káálɛ.» ");
INSERT INTO kdh_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Bɩnáábɩ́lɛ́ Pétro wɔɔbɔ́ɔ́zɩ Yeésu sɩsɩ: «Tɔ́ɔ, ɖɔ́ɔ́ ɖééyéle bɩrɩ́ŋa ɖufu nya nɛ́ ní.» ");
INSERT INTO kdh_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ngɛ Yeésu woobúsi yɩ sɩsɩ: «Ménveerím mɩ́ɩ toovonúm sɩsɩ weení ɩrɩ́ŋa weeyéle ɖɛ́ɛ́zɩ, koobíya aláa na abaaláa, kɔɔ́wʊ, caáwʊ, bíya yáá fásɩ mɔ́ɔ́ mɔ́rɔ́ɔ́zɩ́, yáá Laabáárʊ Kífeńgi-rɔ nɛ́, ");
INSERT INTO kdh_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","bʊdʊ́ʊ wónÿuúu sáátɩ wenkí-daá ɖɔ́wɛ lɛlɛɛɖɔ́ nɛ́ ɖɛ́ɛ́zɩ, koobíya aláa na abaaláa, kɔɔ́wʊ, caáwʊ, bíya na fásɩ bʊrɔ nɩɩ́nʊ́wá, bɩtasɩná fúkúḿsi; bɩka ɖúúlínya kɩgɛgɛrɛŋɛ nɛ́ kɩdaá, ikóyuú weezuú kɩ́dɛ́ndɛŋ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Bɩlɛ́ gɛ wenbá beegbííri nɛ́, bɔ́ngɔnɩ́ bɛtɛ nɩ́bááwʊ, bɩka wenbá bɛɛdɛ nɩ́bááwʊ nɛ́ bekpííri.» ");
INSERT INTO kdh_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yeésu na wenbá bovóo yɩ nɛ́, bɔɔgbɔ́ɔ nɩ́bááwʊ bángbáa Yerusalɛ́ɛm, bɩka Yeésu ɩlɛ́ ɩdɛ́ɛ wɛ nɩ́bááwʊ. Ɩwanbaaráa laakáarɩ wáńgʊ́rʊ́ bɩka nɩdáárɛ wɛná wenbá bovóo wɛ nɛ́. Ngɛ Yeésu waadáyáa ɩwanbaaráa fuú na nɔɔ́lɛ bɔkɔ́nɩ ɩjɔ́, ńna gɛ waabáázɩ wɛ feerím wenbí sɩ bɩkɔ́nɩ bɩkɔ́mɔ́ɔ́ná yɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Wénveerím wɛ sɩsɩ: «Iwélesi ma kazɔ́ɔ, ɖángbáa Yerusalɛ́ɛm. Bángbáa Ɩrʊ́ Biyaalʊ́ becéle sarásɩ lanɖáa kʊ́bɔnáa na Mará wɩlɩɖáa. Bángʊ́ʊ ɩdɔ́m bɔtɔ́ sɩsɩ bákʊ́ yɩ, na bɔkpɔ́ɔ yɩ becéle wenbá baasɩ Ɩsɔ́ɔ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Bɛlɛ́ bánmʊŋɛ́ yɩ, bɔtɔná yɩ ndɔɔlɩmá, bosúti yɩ agbáázá bɩka bakʊ yɩ, na wɛ́ náádoozo wɩ́rɛ nɛ́, ifé ɩlɩ́ɩ ɩsɩɖáa-daá.» ");
INSERT INTO kdh_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ńna gɛ Zebedée biyaalɩnáa lɛ́ɛ́nɩ́, Yaakúbu na Yʊháánɩ boogóduu Yeésu-jɔ́ bɔtɔ́ yɩ sɩsɩ: «Ɖádʊ́ʊ, ɖɔ́zɔɔlɛ́ɛ sɩsɩ ńla ɖáa wenbí sɩ ɖɩbɔ́ɔ́zɩ nya nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ngɛ Yeésu sɩsɩ: «Wé gɛ mɩ́zɔɔlɛ́ɛ sɩsɩ mála mɩ́ɩ.» ");
INSERT INTO kdh_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ngɛ boobúsi yɩ sɩsɩ: «Ɖɔ́zɔɔlɛ́ɛ sɩsɩ nyɛ́dɛ́ɛ kowúrɔ́ɔ ásícé ńgɩ-daá, nÿéle ɖádáá kʊ́ɖʊḿ ɩcɔ́ɔ nyánʊ́ʊ́nɩ kíɖiiwú-rɔ, bɩka waaganáa nyánʊ́ʊ́nɩ nɩɩbɩɩwʊ́-rɔ.» ");
INSERT INTO kdh_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Mɩ́ɩ́sɩ wenbí mɩ́nbɔɔzɩ́ nɛ́. Mɩ́nbɩɩzɩ́ ɩnyɔ́ɔ wahála kagbɔ́ɔ wenká sɩ mɔnyɔ́ɔ kɛ nɛ́? Yáá mɩ́nbɩɩzɩ́ belíri mɩ́ɩ wahála lɩ́m sɩ belíri ma nɛ́ bɩdaá.» ");
INSERT INTO kdh_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ngɛ boobúsi yɩ sɩsɩ: «Ɩɩ́n, ɖánbɩɩzɩ́.» Ńna gɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Mɩ́nnyɔɔ́ wahála kagbɔ́ɔ wenká sɩ mɔnyɔ́ɔ kɛ nɛ́, bɩka belíri mɩ́ɩ wahála lɩ́m sɩ belíri ma nɛ́ bɩdaá; ");
INSERT INTO kdh_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","amá, a bɩɩga weení ɩcɔ́ɔ mánʊ́ʊ́nɩ kíɖiiwú-rɔ yáá mánʊ́ʊ́nɩ nɩbɩɩwʊ́-rɔ nɛ́, bɩdɛkɛ́ɛ mɔ́ɔ́ mánváa kʊ bɩlɛ́ bɩdɛ́ɛ adá. Wenbá Majaa waagbɩ́ɩ́rɩ yɛ ɩsɩ́ɩ nɛ́ gɛ sɩ bafa yɛ.» ");
INSERT INTO kdh_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wanbaaráa fuú baaganáa waanɩ́ɩ bɩlɛ́ nɛ́, ngɛ bɛɛyɛɛná Yaakúbu na Yʊháánɩ baaná. ");
INSERT INTO kdh_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ńna gɛ Yeésu waayáa wɛ ɩtɔ́ wɛ sɩsɩ: «Mɩ́nyɩ bɩlɛ́ sɩsɩ wenbá bɛbɛɛ́na wɛ sɩsɩ yíriwá-dɛ́ɛ wúrowá nɛ́ wánnaazɩ́ bɛdɛ́ɛ ɩráa gɛ na bɛdɛ́ɛ yíko, bɩka kʊ́bɔnáa bɛlɛ́ bánwɩlɩ́ɩ wɛ bɛdɛ́ɛ ɖóni. ");
INSERT INTO kdh_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Amá, mɩ́nyɔ́ɔ́ nɛ́, bɩdɔbɔ́ɔ́zɩ bɩlɛ́ mɩ́lɔ́wʊ́táá. Amá, a bɩgɛ́ɛ sɩsɩ naárʊ sɔɔlɛ́ɛ ɩbɩ́sɩ kʊ́bɔnɩ́ mɩ́lɔ́wʊ́táá, ɩ́bɩsɩ mɩ́dɛ́ɛ bɔwʊtá-dʊ́ʊ, ");
INSERT INTO kdh_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","bɩka a mɩ́dáá naárʊ sɔɔlɛ́ɛ ɩbɩ́sɩ kaɖaa ńnɩ́, ɩ́bɩsɩ mɩ́rɩ́ŋa mɩ́dɛ́ɛ yoḿ. ");
INSERT INTO kdh_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Káma, Ɩrʊ́ Biyaalʊ́ tɔkɔ́nɩ sɩsɩ balá yɩ bɔwʊtá, amá, wɔɔgɔ́nɩ gɛ sɩ ɩlá ɩráa bɔwʊtá, bɩka ɩkpɔ́ɔ iweezuú ɩfɛrɛná ɩráa tuutúúma-dɛ́ɛ kɩmɛ́rɛ na boyuú lɛ́ɛ́dɩ.» ");
INSERT INTO kdh_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Bɩlɛ́ bʊwɔ́rɔ́ gɛ Yeésu na ɩwanbaaráa bɔɔgɔ́nɩ batála Yerikóo tɛ́ɛ́dɩ-daá. Sáátɩ wenkí bɔɔgbɔ́ɔ nɩ́bááwʊ bánlɩɩ́ Yerikóo tɛ́ɛ́dɩ bána zamɔ́ɔ kʊ́bɔńgɩ nɛ́, njɛm weení bánÿaá yɩ sɩsɩ Barɩtimée, ɩjaa gɛ Timée nɛ́, wɛ ɩjɔɔ́ɔ nɩ́bááwʊ kpɔ́mɔ́ɔ́ wánlám bára. ");
INSERT INTO kdh_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Waanɩ́ɩ sɩsɩ Yeésu Nazarɛ́ɛtɩ ńnɩ́ wɛ́nɖɛɛ kʊ nɛ́, ngɛ waabáázɩ agogo sɩsɩ: «Yeésu! Wúro Ɖáwʊɖa Biyaalʊ́, nɩɩ mágʊnyɔḿ!» ");
INSERT INTO kdh_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ngɛ zamɔ́ɔ wɔ́nɖɔwʊ́ʊ yɩ sɩsɩ ísu tɔ́m. Amá, bɩdɛ́ɛ sáátɩ gɛ ɩlɛ́ waabá wóngoó bɩ́njaarɩ́ sɩsɩ: «Yeésu! Wúro Ɖáwʊɖa Biyaalʊ́, nɩɩ mágʊnyɔḿ!» ");
INSERT INTO kdh_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ńna gɛ Yeésu waazɩ́ŋ ɩtɔ́ sɩsɩ: «Ɩyáa yɩ.» Ngɛ baayáa njɛm bɔtɔ́ yɩ sɩsɩ: «Ɖɔkɩ nyádɩ! Kʊrʊ́, wánÿaá nya.» ");
INSERT INTO kdh_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ńna gɛ njɛm waajáŋ ɩlɔ ɩdɛ́ɛ kpáyɩ ɩnyáa ɩkʊrʊ́ cácáráḿ ibó Yeésu jɔ́. ");
INSERT INTO kdh_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ngɛ Yeésu wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Wé gɛ nyɔ́zɔɔlɛ́ɛ sɩsɩ mála nya.» Ngɛ njɛm woobúsi yɩ sɩsɩ: «Ɖádʊ́ʊ, mɔ́zɔɔlɛ́ɛ máázá ifulú.» ");
INSERT INTO kdh_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ngɛ Yeésu wɔɔdɔ́ yɩ sɩsɩ: «Bo, nyɛ́dɛ́ɛ toovonúm fáa wɛɛlɛ́ɛ nya.» Ngɛ waabáázɩ náa nɔɔ́ kʊ́ɖʊḿ, ɩkʊrʊ́ ifu yɩ. ");
INSERT INTO kdh_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Sáátɩ wenkí baajʊʊná Yerusalɛ́ɛm sɩ batála Bɛtɩfagée na Betáániya tɛɛbíízi Olivíyée tɩ́ɩ́nɩ bʊ́ʊ fáráńdɩ́ nɛ́, ngɛ Yeésu weedíri ɩwanbaaráa nɔɔ́lɛ, ");
INSERT INTO kdh_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ifééri wɛ sɩsɩ: «Ibó tɛɛbiiyá kɔwɛ mɩ́ɩ́zá-daá nɛ́ kadaá, mɩ́nnáa baaɖɩ kpangbɔ́ɔ bú báa naárʊ tɔcɔɔ tá kɛ nɛ́. Ibóɖi kɛ ɩkɔná ma. ");
INSERT INTO kdh_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","A naárʊ wɔɔbɔ́ɔ́zɩ mɩ́ɩ sɩsɩ: “We-rɔ gɛ mɩ́nlám bɩlɛ́.” Ibúsi yɩ sɩsɩ: “Ɖádʊ́ʊ sɔɔlɛ́ɛ na kɛ, amá, wénÿelíi bacáŋ bakábɩ́sɩ́ná kɛ.”» ");
INSERT INTO kdh_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Wanbaaráa woobó nɛ́, ngɛ baana kpangbɔ́ɔ bú ɖɩ́ɩ asʊ, nɩ́bááwʊ-daá, ɖaḿ nakɩ́rɩ wɔnɔɔ́. Ngɛ boogóboɖi kɛ. ");
INSERT INTO kdh_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Wenbá bɔwɛ ńna nɛ́ badaá nɛbɛ́rɛ wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «Wé gɛ mɩ́nlám bɩlɛ́. Ngbaalá gɛ mínboɖí kpangbɔ́ɔ bú.» ");
INSERT INTO kdh_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ngɛ boobúsi wɛ ńŋɩnáa Yeésu wɔɔgɔ́dɔ wɛ nɛ́, ngɛ beeyéle wɛ bobóɖi kɛ bɛkɛ́ɖɛɛná. ");
INSERT INTO kdh_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Wanbaaráa wɔɔgɔ́gɔ́ná Yeésu kpangbɔ́ɔ bú; ngɛ baalɩzɩ́ bogúsúúdi batɩ́nɩ kɔrɔ Yeésu ɩkpa ɩcɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ngɛ ɩráa ɖabata wɔɔvɔ bogúsúúdi nɩ́bááwʊ-rɔ, nɛbɛ́rɛ ɩkájaa cɔ́kɔ́ fásɩ-daá bɔkɔná bɔlɔ nɩ́bááwʊ-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Wenbá bɔwɛ waazá-daá na wenbá bɔwɛ ɩwɔ́rɔ́ nɛ́, bóngoó sɩsɩ: «Sám mɔɔ́na Ɖádʊ́ʊ Ɩsɔ́ɔ; Ɩsɔ́ɔ ɩ́ɖʊ́ weení ɩgɛrɛŋɛ na ɩmʊ́ Ɩsɔ́ɔ ɩyɩ́ɖɛ-daá nɛ́ alɩbáráka. ");
INSERT INTO kdh_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ɩsɔ́ɔ ɩ́ɖʊ́ ɖájaa Ɖáwʊɖa-dɛ́ɛ kowúrɔ́ɔ kɛgɛrɛŋɛ nɛ́ alɩbáráka. Bása Ɩsɔ́ɔ ɩsɔ́ɔ́dáá bílí‑bílí.» ");
INSERT INTO kdh_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yeésu waazʊ́ʊ Yerusalɛ́ɛm tɛ́ɛ́dɩ-daá nɛ́, ngɛ woobó ɩsʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá. Wɛɛbɛ́ɛ́ŋ bɩrɩ́ŋa ɩlára ɩmɩ́lɩ bɩtɛ́ nɛ́, ngɛ ɩ́na ɩwanbaaráa fuú na nɔɔ́lɛ baalɩ́ɩ bɛɖɛ́ɛ Betáániya, káma, kɩ́ńbaazɩ yúu. ");
INSERT INTO kdh_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kiivé baalɩ́ɩ Betáániya bɛ́ngɛɖɛɛ́ nɛ́, ngɛ nyɔɔ́sɩ waagba Yeésu. ");
INSERT INTO kdh_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Waagáná figíyée tɩɩwʊ́ nakɩ́rɩ bolíni fáádɩ wɛ kɩrɔ nɛ́, ngɛ woobó ɩbɛ́ɛ́ŋ sɩsɩ a wónÿuúu kɩdɛ́ɛ bíya. Amá, woobó ɩcʊʊná kɩ nɛ́, fáádɩ riké gɛ waana, káma, bɩdɛkɛ́ɛ kɩdɛ́ɛ bíya sɛɛ́ alɩwáátɩ. ");
INSERT INTO kdh_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ńna gɛ Yeésu wɔɔdɔ́ figíyée tɩɩwʊ́ kɩḿ sɩsɩ: «Kɛtɛngɛrɛ, naárʊ tóndokúti ɩtɔ́ɔ nyébíya.» Ngɛ ɩwanbaaráa waanɩ́ɩ waaŋmátɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Boobó batála Yerusalɛ́ɛm nɛ́, ngɛ Yeésu waazʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá. Ńna gɛ waabáázɩ wenbá bánÿám kpɩná ńna na wenbá bánmʊ́ʊ nɛ́ ɖɔwʊ́ʊ. Wɛɛvɛdɩ́ liide-gɛɛráa-dɛ́ɛ tébíriwá na avówa kʊ́fʊlʊmá yamɖáa-dɛ́ɛ kpelásɩ. ");
INSERT INTO kdh_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ngɛ ideyéle báa naárʊ ɩsʊ́ʊ nabʊ́rʊ ɩkpɔɔná Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-dɛ́ɛ kadɔ́ɔ-daá. ");
INSERT INTO kdh_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ngɛ waabáázɩ wɩlɩ́ɩ wɔ́ndɔ́m sɩsɩ: «Baaŋmáa Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá sɩsɩ: “Sɩ bayáa máɖaána gɛ sɩsɩ yíriwá rɩ́ŋa-dɛ́ɛ Ɩsɔ́ɔ sɛ́ɛ́dɩ ɖaána.” Amá, mɩ́ɩ mɩ́ɩ́bɩ́sɩ́ná kɛ ŋmɩɩláa ɖaána.» ");
INSERT INTO kdh_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa na Mará wɩlɩɖáa waanɩ́ɩ bɩlɛ́, ngɛ bɔwɛ bánjáádɩ nŋɩ́nɩ́ sɩ balá na bakʊ yɩ nɛ́. Káma, bánnɩɩ́ ɩnɩdáárɛ, wenbí bʊrɔɔzɩ́ nɛ́, ɩdɛ́ɛ wɩlɩ́ɩ ɩbá bíndekináa zamɔ́ɔ rɩ́ŋa. ");
INSERT INTO kdh_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kɩɩɖáánɩ nɛ́, ngɛ Yeésu na ɩwanbaaráa baagʊrʊ́ tɛ́ɛ́dɩ-daá balɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kiivé tɛ́ɛrɛ́‑tɛ́ɛrɛ́ baalɩ́ɩ bɛ́nɖɛɛ́ nɛ́, baana figíyée tɩɩwʊ́ wáńwɩ́lɩ́ hálɩ kilirá. ");
INSERT INTO kdh_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ngɛ Pétro wɔɔdɔ́ɔ́zɩ wenbí bɩɩlá nɛ́, ngɛ wɔɔdɔ́ Yeésu sɩsɩ: «Kʊ́bɔnɩ́, figíyée tɩɩwʊ́ nyáálá kɩ láálɩ́ nɛ́, bɛɛ́ɛ, kɩɩwɩ́lɩ kɩrɩ́ŋa.» ");
INSERT INTO kdh_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ngɛ Yeésu woobúsi ɩwanbaaráa sɩsɩ: «Ɩva Ɩsɔ́ɔ toovonúm. ");
INSERT INTO kdh_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ménveerím mɩ́ɩ toovonúm sɩsɩ a naárʊ wɔɔdɔ́ bʊ́ʊ kɩna sɩsɩ: “Kpɛzɩ́ nyádɩ ńna nzála tenkú-daá,” ngɛ ɩdalá síka iwenbiré-daá, amá, waava toovonúm sɩsɩ wenbí wɔɔdɔ́ bɩ nɛ́ bɩ́nlám, Ɩsɔ́ɔ wánlám bɩrɩ́ŋa icéle yɩ. ");
INSERT INTO kdh_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Bʊrɔ gɛ ménveerím mɩ́ɩ sɩsɩ a mɩ́wɛ sʊlʊ́ńdɩ-daá ngɛ mɩ́ɩ́vá toovonúm, wenbí bɩrɩ́ŋa sɩ ɩsʊ́lʊ bɩ nɛ́, ɩlá yaraɖá sɩsɩ míńÿúú bɩ. ");
INSERT INTO kdh_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ngɛ a bɩgɛ́ɛ sɩsɩ mɩ́zɩ́ŋɛ́ɛ mɩ́nzʊlʊ́ʊ Ɩsɔ́ɔ gɛ mɩ́jɔɔ́na naárʊ, ɩjɛ́ bʊdʊ́ʊ, na Mɩ́jaa weení ɩwɛ ɩsɔ́ɔ́dáá nɛ́ ɩcɛ́ mɩ́ɩ ɖʊɖɔ mɩ́dɛ́ɛ yɩsɩ́tɩ.  ");
INSERT INTO kdh_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Amá, a mɩ́dɛ́njɛḿ baaganáa, Mɩ́jaa weení ɩwɛ ɩsɔ́ɔ́dáá nɛ́ tɛ́njɛḿ mɩ́ɩ ɖʊɖɔ yɩsɩ́tɩ wentí mɩ́ɩ́lá nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Bɔɔlɔ́ɔ bakábɩsɩ Yerusalɛ́ɛm. Ngɛ sáátɩ wenkí Yeésu wɛ wánnʊŋɛ́ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá wéndím wángbáa nɛ́, Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa, na Mará wɩlɩɖáa, na Yahúúɖuwá-dɛ́ɛ kʊ́bɔnáa woogóduu ɩjɔ́. ");
INSERT INTO kdh_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ngɛ bɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Na yíko wenkí gɛ nyánlanáa tɩmɛ́ ana. Ngɛ weení waava ná nya yíko kɩḿ sɩsɩ nlá yɛ.» ");
INSERT INTO kdh_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Mɔ́ɔ́ ɖʊɖɔ mɔ́nbɔɔzɩ́ mɩ́ɩ tɔ́m kʊ́ɖʊńtɩ kóḿ, a mɩ́ɩ́búsi ma tɩ, bɩlɛ́ nɛ́, mɔ́ɔ́ ménveerím mɩ́ɩ yíko wenkí mánlanáa tɩmɛ́ amʊ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Weení weegédíri ná Yaayá ɩkɔ́nɩ ilíri ɩráa lɩ́m-daá ɩsɔ wɛ túúbá lɩ́m. Ɩsɔ́ɔ yáá ɩráa. Ibúsi ma.» ");
INSERT INTO kdh_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ngɛ baalaná ɖamá sááwʊ́ra bɔtɔ́ ɖamá sɩsɩ: «A ɖɔ́ɔ́dɔ́ sɩsɩ Ɩsɔ́ɔ, wɔ́ndɔ́m ɖáa sɩsɩ ngbaalá ɖádálá yɩ yaraɖá. ");
INSERT INTO kdh_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","A ngʊ́ ɖɔ́ɔ́dɔ́ sɩsɩ ɩráa…» Bánnɩɩ́ zamɔ́ɔ nɩdáárɛ nɛ́, badacáa bɔtɔ́ bɩlɛ́, káma, barɩ́ŋa beeɖéézi sɩsɩ Yaayá kɛ́ɛ anɖébi gɛ. ");
INSERT INTO kdh_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ngɛ boobúsi Yeésu sɩsɩ: «Ɖáásɩ weení weegédíri yɩ nɛ́.» Ńna gɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Mɔ́ɔ́ ɖʊɖɔ médénveeri mɩ́ɩ yíko wenkí mánlanáa tɩmɛ́ ana nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Bɩlɛ́ bʊwɔ́rɔ́ gɛ Yeésu waabáázɩ wɛ ŋmatɩnáa tɔmgɛɛza-daá sɩsɩ: «Ɩrʊ́ naárʊ wooɖuu ná víinyi tiyísi, ngɛ waalá kárɔɔ́ ɩlára ɩmɩlɩná ɩvɔɔ́, ɩbáa lénlé bánnyaazɩ́ víinyi bíya nɛ́, ɩma lénlé fereɖáa wɔ́njɔwʊ́ʊ na befére nɛ́ buwóro. Ngɛ wɔɔgbɔ́ɔ fɔɔ́ kɛḿ icéle wenbá bánvarɩ́m víinyi nɛ́ bɩka ɩmʊ́ ɩɖɛ́ɛ nɩ́bááwʊ. ");
INSERT INTO kdh_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Víinyi bíya kɔrɩ́ɩ-dɛ́ɛ sáátɩ waadála nɛ́, ngɛ weedíri bɔwʊtá-dʊ́ʊ naárʊ wenbá weejéle wɛ ɩvɔɔ́ nɛ́ sɩsɩ íbo ɩkámʊ́ ɩmʊ́ ɩdɛ́ɛ ńbɩ ɩkɔ́gɔ́ná ɩmʊ́. ");
INSERT INTO kdh_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Amá, wenbá bánvarɩ́m víinyi nɛ́ beegbí bɔwʊtá-dʊ́ʊ babá bamá, bɩka bɔkɔ́ɖɔ́ɔ yɩ nʊ́ʊ́zɩ riké. ");
INSERT INTO kdh_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Fɔɔ́-dʊ́ʊ weedétirí bɔwʊtá-dʊ́ʊ naárʊ ɖʊɖɔ bɔjɔ́. Ɩlɛ́ ɖʊɖɔ, baagáma ɩgʊjʊʊ́, bɩka babá bakádʊʊ yɩ. ");
INSERT INTO kdh_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ngɛ waadásɩ itíri naárʊ ɖʊɖɔ; ngɛ baagágʊ́ ɩlɛ́. Ngɛ weedíri nɛbɛ́rɛ ɖʊɖɔ bɔɖɔ́ɔ. Baabá bakáma badaá nɛbɛ́rɛ, bɩka bakágʊ́ lí ńba. ");
INSERT INTO kdh_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ibiyaalʊ́ weení waabá ɩsɔ́ɔ́lɩ yɩ nɛ́ iriké gɛ bɩɩga yɩ. Ngɛ weedíri ɩlɛ́ kegbiirinɔ́ɔ-dɛ́ɛ. Ilomaazɛ́-daá sɩsɩ: “Bánɖʊ́ʊ mebiyaalʊ́ gírímá.” ");
INSERT INTO kdh_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Amá, wenbá bánvarɩ́m víinyi nɛ́ bɔɔdɔ́ ɖamá sɩsɩ: “Tííbí-dʊ́ʊ nbɩlɛ́! Ɩgɔ́nɩ! Ɖɩ́kʊ́ yɩ bɩka ɖɩkpɔ́ɔ tííbí.” ");
INSERT INTO kdh_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ngɛ beegbí yɩ bakʊ, bɛɛzɛlɩ́ yɩ bɔlɔná víinyi fɔɔ́ wɔ́rɔ́.» ");
INSERT INTO kdh_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ńna gɛ Yeésu wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «Nŋɩ́nɩ́ gɛ fɔɔ́-dʊ́ʊ wánlám. Wɔ́ngɔnɩ́, na iyéle bakʊ wenbá bánvarɩ́m víinyi nɛ́ bɩka ɩkpɔ́ɔ fɔɔ́ icéle kɩ́faláa. ");
INSERT INTO kdh_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kɛtɛngɛrɛ mɩ́dákála baaŋmáa Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá nɛ́ gɛ? Baaŋmáa gɛ sɩsɩ: “Bʊ́ʊ́rɛ wenɖé maaráa weegízi ɖɛ nɛ́, ɖɩɩbɩsɩ ná ɖaḿ cʊnbʊʊrɛ-daá bʊ́ʊ́rɛ. ");
INSERT INTO kdh_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ɖádʊ́ʊ Ɩsɔ́ɔ waala ná bɩlɛ́. Mááɖé gɛ bɩgɛ́ɛ ɖáa.”» ");
INSERT INTO kdh_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ńna gɛ baabáázɩ cáádɩ sɩsɩ bakpa Yeésu, amá, baanɩ́ɩ zamɔ́ɔ-dɛ́ɛ nɩdáárɛ. Baabá batɩlɩ́ sɩsɩ bɔdɔ́m gɛ Yeésu waaŋmátɩ tɔmgɛɛzɩrɛ ɖɩna ɖɩdaá. Ngɛ beeyéle yɩ bɛɖɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Beegédiri Faríizi ńba nɛbɛ́rɛ na Eróodi-dɛ́ɛ bɔwʊ́ɖɛ-daá ɩráa Yeésu-jɔ́ sɩsɩ bayɩ́ yɩ kɔdɔká ɩŋmátɩ na boyuú yɩ. ");
INSERT INTO kdh_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bɔɔgɔ́nɩ bɔtɔ́ yɩ sɩsɩ: «Kʊ́bɔnɩ́, ɖányɩ sɩsɩ toovonúm gɛ nyánŋmatɩ́, ngʊ́ bɩlɛ́ gɛ ńdánnɩɩ naárʊ nɩdáárɛ, bɩka ńdɛ́nbɛɛŋná ɩrʊ́ ɩzá-daá na nŋmátɩ. Amá, na toovonúm gɛ nyánwɩlɩ́ɩ Ɩsɔ́ɔ-dɛ́ɛ nɩ́bááwʊ. Bɩlɛ́ nɛ́ feeri ɖáa: bɩɩva nɩ́bááwʊ yáá bɩdafa sɩsɩ ɖɩ́fɛrɛ Róóma wúro kʊ́bɔnɩ́ lanpóo. Bɩɩbɔ́ɔ́zɩ sɩsɩ ɖɩ́fɛrɛ yáá ɖɩ́kɛfɛrɛ.» ");
INSERT INTO kdh_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Amá, Yeésu ɩlɛ́ ɩnyɩ bɛdɛ́ɛ munááfíísi-rɔ nɛ́, ngɛ wɔɔdɔ́ wɛ sɩsɩ: «We-rɔ gɛ mɩ́nÿɩ́m ma kɔdɔká. Ɩgɔná ma liideé jɩtɔ́ɔ mɛbɛ́ɛ.» ");
INSERT INTO kdh_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ngɛ bɔɔgɔná yɩ jɩtɔ́ɔ kʊ́ɖʊmʊ́ʊ. Ńna gɛ wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «Weení kʊjʊʊ́ na ɩyɩ́ɖɛ gɛ kɩrɔ.» Ngɛ boobúsi sɩsɩ: «Róóma wúro kʊ́bɔnɩ́.» ");
INSERT INTO kdh_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Bɩnáábɩ́lɛ́ Yeésu woobúsi wɛ sɩsɩ: «Ijéle Róóma wúro kʊ́bɔnɩ́, Róóma wúro kʊ́bɔnɩ́-dɛ́ɛ ńbɩ bɩka icéle Ɩsɔ́ɔ, Ɩsɔ́ɔ-dɛ́ɛ ńbɩ.» Wentí Yeésu woobúsi wɛ nɛ́, waabá bɩlá wɛ bítí páá. ");
INSERT INTO kdh_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Bʊwɔ́rɔ́ nɛ́, Sadusée ńba wenbá bɔ́ndɔ́m sɩsɩ ɩsɩɖáa ténveḿ nɛ́, boogóduu Yeésu-jɔ́ bɔbɔ́ɔ́zɩ yɩ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Kʊ́bɔnɩ́, anɖébi Múúsá wɔɔdɔ́ sɩsɩ: “A ɩrʊ́ abaalʊ́ wɛná igoobú abaalʊ́ ngɛ ɩrʊ́ ɩmʊ́ waazɩ́ iyéle leelú bɩka badalʊ́rʊ, bɩɩbɔ́ɔ́zɩ igoobú ɩfʊ́ leelú bɩka ɩlʊ́rʊ bíya babɩ́sɩ koobúu weení waazɩ nɛ́ ibíya.” ");
INSERT INTO kdh_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Koobíya lʊbɛ wɔɔjɔɔ ná. Kaɖaa ńnɩ́ wɔɔgbɔ́ɔ alʊ́, ngɛ waazɩ́ bɩka ɩdalʊ́rʊ. ");
INSERT INTO kdh_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Sɩɩlɛ ńnɩ́ waavʊ́ leelú, ngɛ waazɩ́ bɩka ɩdalʊ́rʊ. Toozo ńnɩ́ ɖʊɖɔ bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ngɛ baaganáa ɖʊɖɔ bɩlɛ́. Barɩ́ŋa bɔɔgbɔ́ɔ alʊ́ ɩmʊ́ baka ɖamá bɩka badalʊ́rʊ. Barɩ́ŋa baazɩ́ wɔ́rɔ́ nɛ́, ngɛ alʊ́ ɖʊɖɔ waazɩ́. ");
INSERT INTO kdh_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tɔ́ɔ, wɩ́rɛ wenɖé ɩsɩɖáa sɩ befé bɩlɛ́ nɛ́, badaá weení gɛ alʊ́ waalʊ́, káma, barɩ́ŋa bɔɔgbɔ́ɔ yɩ.» ");
INSERT INTO kdh_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Mɩ́wɛ yɩsɩ́tɩ-daá! Káma, mɩ́ɩ́sɩ Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá, cáńfáná ɩdɛ́ɛ yíko. ");
INSERT INTO kdh_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ɩsɩɖáa wénvém nɛ́, aláa na abaaláa tɔ́ndɔkpɔwʊ́ ɖamá ɖʊɖɔ. Amá, bɔ́njɔwʊ́ʊ gɛ nyazɩ malááyɩ́kawá bɩlɛ́ ɩsɔ́ɔ́dáá. ");
INSERT INTO kdh_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Bɩɩga ɩsɩɖáa-dɛ́ɛ fém tɔ́m nɛ́, mɩ́dákála Múúsá-dɛ́ɛ tákaraɖá-daá lé baaŋmáa nimíni wénɖée sɔɔzɔ́ɔ́zɩ nɛ́-dɛ́ɛ tɔ́m ɩbɛ́ɛ gɛ? Baaŋmáa gɛ sɩsɩ Ɩsɔ́ɔ wɔɔdɔ́ Múúsá sɩsɩ: “Mɔ́ɔ́ gɛ Ibrahím, na Ɩsaáka, na Yaakúbu bɛdɛ́ɛ Ɩsɔ́ɔ.” ");
INSERT INTO kdh_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ɩdɛkɛ́ɛ ɩsɩɖáa-dɛ́ɛ Ɩsɔ́ɔ, amá, weezíni-dɩnáa-dɛ́ɛ ńnɩ́ gɛ ɩgɛ́ɛ. Mɩ́ɩ́bá mɩ́wɛ yɩsɩ́tɩ-daá páá.» ");
INSERT INTO kdh_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mará wɩlɩɖʊ́ naárʊ waanɩ́ɩ Yeésu na Sadusée ńba bánŋmatɩ́ nɛ́, ngɛ waana sɩsɩ Yeésu waabá ibúsi wɛ kazɔ́ɔ. Ńna gɛ woogóduu Yeésu-jɔ́ ɩbɔ́ɔ́zɩ yɩ sɩsɩ: «Mará-daá, wenɖé gɛ kʊ́bɔńɖɛ.» ");
INSERT INTO kdh_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ngɛ Yeésu woobúsi yɩ sɩsɩ: «Kaɖaa ńɖɛ nɖɔ́: “Welesi Israyɛ́ɛlɩ, Ɖádʊ́ʊ Ɩsɔ́ɔ kɛ́ɛ kʊ́ɖʊḿ gɛ. ");
INSERT INTO kdh_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nyɔ́nzɔɔlɩ́ Nyádʊ́ʊ Ɩsɔ́ɔ na nyéwenbiré rɩ́ŋa, na nyégezeŋa rɩ́ŋa, na nyólomaazɛ́ rɩ́ŋa, na nyóɖóni rɩ́ŋa.” ");
INSERT INTO kdh_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Bɛɛ sɩɩlɛ ńɖɛ nɖɔ́: “Nyɔ́nzɔɔlɩ́ nyɔ́rɔwʊ́ nyazɩ nyádɩtɩŋa.” Mará naárɛ fɛ́yɩ́ aagɩ́lɩ mará amʊ́ alɛ́ɛ́nɩ́ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ngɛ Mará wɩlɩɖʊ́ woobúsi Yeésu sɩsɩ: «Nyáábá nbúsi kazɔ́ɔ, Kʊ́bɔnɩ́. Toovonúm gɛ nyááŋmátɩ sɩsɩ Ɖádʊ́ʊ Ɩsɔ́ɔ kɛ́ɛ kʊ́ɖʊḿ gɛ, ngɛ ɩbaasí, Ɩsɔ́ɔ naárʊ fɛ́yɩ́, ");
INSERT INTO kdh_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ngɛ nzɔ́ɔ́lɩ yɩ na nyéwenbiré rɩ́ŋa, na nyádɩlɩ́ɩ rɩ́ŋa, na nyóɖóni rɩ́ŋa; bɩka nzɔ́ɔ́lɩ nyɔ́rɔwʊ́ nyazɩ nyádɩtɩŋa cɔɔ́ɔ kazɔ́ɔ bɩkɩ́lɩ keɖe-kanyɔ́ɔ sarásɩ na sarásɩ rɩ́ŋa.» ");
INSERT INTO kdh_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yeésu waana sɩsɩ woobusi ná áséńsí nɛ́, ngɛ wɔɔdɔ́ yɩ sɩsɩ: «Nyɛ́vɛ́yɩ́ bolíni na Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ.» Bɩlɛ́ bʊwɔ́rɔ́ nɛ́, naárʊ tokúti iyuú wenbiré ɩbɔ́ɔ́zɩ yɩ natɩ́rɩ ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yeésu wánwɩlɩ́ɩ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá nɛ́, wɔɔbɔ́ɔ́zɩ tɔ́m tɩna ɖɔ́ sɩsɩ: «Nŋɩ́nɩ́ gɛ bɩɩlá gɛ Mará wɩlɩɖáa wɔ́ndɔ́m sɩsɩ Lɛɛrʊ́ kɛ́ɛ Ɖáwʊɖa biyaalʊ́. ");
INSERT INTO kdh_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Káma, Ɖáwʊɖa tɩtɩŋa, Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga waaŋmatɩná ɩnɔɔ́ sɩsɩ: “Ɖádʊ́ʊ Ɩsɔ́ɔ wɔɔdɔ́ Mádʊ́ʊ sɩsɩ: ‘Cɔɔ mégíɖíiwú-rɔ, Hálɩ maɖʊ nbáɖaanáa nyɔ́nʊvɔ́-dɛɛzɩ́.’ ” ");
INSERT INTO kdh_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ɖáwʊɖa tɩtɩŋa waayáa yɩ sɩsɩ Ɩdʊ́ʊ, bɩɩlá nŋɩ́nɩ́ gɛ igúti ɩgɛ́ɛ ibiyaalʊ́ ɖʊɖɔ.» Zamɔ́ɔ tuutúúma wénwelesí Yeésu nɛ́, bɩmɔɔ́ kɩ. ");
INSERT INTO kdh_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yeésu wénveerím ɩráa ɩdɛ́ɛ wɩlɩ́ɩ-daá sɩsɩ: «Iguná laakáarɩ na Mará wɩlɩɖáa; bɔzɔɔlɛ́ɛ gɛ bónzuú kpáyɩwá kɩ́bɩɩzɩ́tɩ béngilím; bɔzɔɔlɛ́ɛ ɖʊɖɔ gɛ bɛ́nzɛɛ́ wɛ zamɔ́ɔ-daá na wɔnásɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kʊ́bɔɔ-ɖɩdáarɛ gɛ bɔzɔɔlɛ́ɛ Ɩsɔ́ɔ ɖaazɛɛɖɛ́wá-daá na ɖíínawá-daá. ");
INSERT INTO kdh_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bɛ́nlɛɛ́ leeláa-jɔ́ wenbíyɔ́ɔ rɩ́ŋa bɔwɛná nɛ́, bɩka bánlám sʊlʊ́ńdɩ kɩ́bɩɩzɩ́tɩ na bana wɛ. Bɛdɛ́ɛ nɩgbamʊʊ́ fɔ́m wánbá bɩlá ɖóni.» ");
INSERT INTO kdh_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yeésu waaŋmátɩ bɩlɛ́ bɩtɛ́ nɛ́, ngɛ woobó ití ɩcɔ́ɔ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá, kʊjɔ́ɔ́nɩ ɖaaɖʊ́ʊ́ɖɛ ɩzá-daá, bɩka ɩbɛɛ́na nŋɩ́nɩ́ ɩráa wánɖʊ́ʊ liideé kɩdaá nɛ́. Liideé-dɩnáa ɖabata wɔ́ngɔnɩ́ bánɖʊ́ʊ liidebɔná. ");
INSERT INTO kdh_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ngɛ alʊ́ leelú kɛdɛɛrɩ́ya nɛkɛ́rɛ wɔɔgɔ́nɩ kaɖʊ liideé jɩtɔ́ɔ yáawá nasɩ́lɛ sɩdatála nabʊ́rʊ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ńna gɛ Yeésu waayáa ɩwanbaaráa ɩtɔ́ wɛ sɩsɩ: «Ménveerím mɩ́ɩ toovonúm sɩsɩ alʊ́ leelú kɛdɛɛrɩ́ya kana, kaaɖʊ bɩcɛzɩ́ baaganáa rɩ́ŋa. ");
INSERT INTO kdh_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Káma, baaganáa rɩ́ŋa waalɩzɩ́ weená avɛ́yɩ́na wɛ fɔ́ɔ́zɩrɛ nɛ́ adaá gɛ baɖʊ. Amá, ɩlɛ́ nɛ́, na bɩrɩ́ŋa na ɩgɛdɛɛrɩ́tɩ, weegbíízi wenbí bɩrɩ́ŋa ɩwɛná sɩ iɖi nɛ́ gɛ ɩɖʊ.» ");
INSERT INTO kdh_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Sáátɩ wenkí Yeésu waalɩ́ɩ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá wɛ́nɖɛɛ́ nɛ́, ngɛ ɩdɛ́ɛ wanbaarʊ́ naárʊ wɔɔdɔ́ yɩ sɩsɩ: «Kʊ́bɔnɩ́, ba nbɛ́ɛ bɔ́ cɔɔ́ɔ kazɔ́ɔ nɛ́! Bɛɛ ɖamɩ́nɩ waabá tiwóro nŋɩ́nɩ́ nɛ́!» ");
INSERT INTO kdh_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ngɛ Yeésu wɔɔjɔ yɩ sɩsɩ: «Yaa nyááná ɖamɩ́nɩ kʊ́bɔńdɩ tɩna ya, bɩ́dángáa bʊ́ʊ́rɛ ɖɩdɩ́nɛ́ɛ ɖɩrɔwʊ́-rɔ, bɩrɩ́ŋa bínnuudí.» ");
INSERT INTO kdh_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yeésu woobó ɩjɔɔ́ɔ Olivíyée tɩ́ɩ́nɩ bʊ́ʊ-daá Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga ɩzá-daá nɛ́, Pétro, na Yaakúbu, na Yʊháánɩ, na Andirée boobó ɩjɔ́ fɔɔlʊʊ́-rɔ bɔbɔ́ɔ́zɩ yɩ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Feeri ɖáa sáátɩ wenkí sɩ bɩlá bɩlɛ́ nɛ́, na seríya wenkí kɩ́nwɩlɩ́ɩ sɩsɩ bɩrɩ́ŋa bɩlɛ́ bɩ́nlám nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ńna gɛ Yeésu waabáázɩ wɛ feerím sɩsɩ: «Iguná laakáarɩ, naárʊ ɩ́kɛtɛlɛ́sɩ mɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Káma, ɩráa ɖabata wɔ́ngɔnɩ́ na máyɩ́ɖɛ-daá bɔtɔ́ sɩsɩ: “Mɔ́ɔ́ gɛ Lɛɛrʊ́,” na bɛtɛlɛ́sɩ ɩráa ɖabata. ");
INSERT INTO kdh_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mɩ́nnɩɩ́ baŋmátɩ yóóni tɩ́ńjʊ́ʊ́ nɛ́ na bolíni ńdɩ tɔ́m. Ɩ́kanɩ́ɩ nɩdáárɛ. Bɩmɔɔ́na bɩlɛ́ bɩrɩ́ŋa bɩtála. Amá, bɩdɛkɛ́ɛ sɩsɩ ɖúúlínya kʊrʊ́ʊ waadala ná. ");
INSERT INTO kdh_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Yíri wónÿoó yíri, bɩka wúro iyóo wúro. Fáráńdɩ́wá ndɩ‑ndɩ-daá, adɛ wénzelíi, bɩka nyɔɔ́sɩ ɩlá. Bɩlɛ́ bɩrɩ́ŋa bɩlɛ́ sɩ bɩlá gɛ nyazɩ alʊ́ fuwá-dʊ́ʊ-dɛ́ɛ nʊŋásɩ kabaazɩya. ");
INSERT INTO kdh_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Bɩɩga mɩ́nyɔ́ɔ́ nɛ́, iguná laakáarɩ. Bángbáa mɩ́ɩ boboná tɔ́m ɖaavʊʊɖɛ́wá-daá; bánbá bamá mɩ́ɩ Ɩsɔ́ɔ ɖaazɛɛɖɛ́wá-daá, bayáa mɩ́ɩ tɛ́ɛ́dɩ bɛɛŋɩráa na wúrowá-jɔ́ bɩka bafʊʊná mɩ́ɩ mɔ́ɔ́ mɔ́rɔ́ɔ́zɩ́ na ɩlɩzɩ́ seríya baazá-daá. ");
INSERT INTO kdh_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Káma, bɩɩbɔ́ɔ́zɩ befééri yíriwá rɩ́ŋa Ɩsɔ́ɔ-dɛ́ɛ Laabáárʊ Kífeńgi naanɩ́. ");
INSERT INTO kdh_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","A bɩgɛ́ɛ sɩsɩ baagba mɩ́ɩ bónbonáa tɔmvʊʊráa-jɔ́, ɩ́kayɩ́tɩ mɩ́dɩ sɩsɩ wentí gɛ sɩ ɩkáŋmatɩ. Ɩŋmátɩ wentí sɩ tɩkɔ́nɩ mɩ́ɩ bɩdɛ́ɛ sáátɩ kɩḿ nɔ́ɔ́ nɛ́. Káma, bɩdɛkɛ́ɛ mɩ́dɩtɩŋa sɩ ɩŋmatɩná, amá, Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga sɩ kaŋmatɩná na mɩ́nɔ́ɔ́. ");
INSERT INTO kdh_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Koobúu wɔ́ngɔnɩ́ iyéle bakpa koobúu sɩsɩ bákʊ́ yɩ; caáwʊ iyéle bakpa ibú sɩsɩ bákʊ́ yɩ. Bíya ɩkʊrʊ́na bajaanáa bakʊ bɔdɔ́m sɩsɩ bákʊ́ wɛ. ");
INSERT INTO kdh_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ɩráa rɩ́ŋa wánlɩzɩ́ɩ mɩ́ɩ báɖáárɛ mɔ́ɔ́ mɔ́rɔ́ɔ́zɩ́. Amá, a weení wɔɔɖɔ́kɩ ɩdɩ hálɩ bɩkádʊ́lʊ́ nɛ́, Ɩsɔ́ɔ wɛ́nlɛɛ́ yɩ.» ");
INSERT INTO kdh_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«A mɩ́ɩ́gɔ́nɩ ɩna “Fɔrɔ́sɩ́rʊ Láálɩ́-dʊ́ʊ” wɔɔgɔ́nɩ isúu ɖɩdáarɛ lé bɩdɔmɔɔná isúu nɛ́ (weení wángalɩ́ɩ nɛ́, ɩ́nɩɩ bugutoluú kazɔ́ɔ), bɩdɛ́ɛ sáátɩ kɩḿ nɛ́, wenbá bɔwɛ Yudée laadɔ́ɔ-daá nɛ́ bésé bɛɖɛ́ɛ bʊ́ʊ́nɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Weení ɩwɛ ɖaḿ kʊjʊʊ́-daá atáárɩ-rɔ nɛ́, íkekédi sɩsɩ ɩkpɔ́ɔ ɩgbɩná awɛ ɖaḿ-daá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Weení ɩwɛ fɔɔ́ nɛ́ ɩ́kakábɩsɩ ɩwɔ́rɔ́ sɩsɩ ɩkɔ́gbɔ́ɔ ɩdɛ́ɛ kpáyɩ. ");
INSERT INTO kdh_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Nbusú ɖamáa na aláa bɛyɛ́ɛna fúúzi nɛ́ na wenbá bebíya wánmʊzʊ́ʊ wɛ wɛ́ amʊ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ɩzʊ́lʊ Ɩsɔ́ɔ sɩsɩ a sɩ bɩlá bɩlɛ́, bɩ́kásaaná kaanɩŋá sáátɩ. ");
INSERT INTO kdh_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Káma, bɩdɛ́ɛ sáátɩ kɩḿ, ɩráa wánnáa fúkúḿsi kɛtɛngɛrɛ badanáa ta sɩ ɖoo ɖúúlínya kabaazɩya hálɩ ngɔ́nɩ lɛlɛɛɖɔ́ nɛ́. Ngʊ́ bɩlɛ́ gɛ naárʊ tándanáa sɩdaká. ");
INSERT INTO kdh_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","A Ɩsɔ́ɔ ɩ́tatʊʊ́ wɛ́-bíya bɛḿ, naárʊ ɩ́tabɩ́ɩ́zɩ ɩcɔ́ɔ weezuú-daá. Amá, wenbá waada ɩlɩzɩ́ wɛ nɛ́ bɔrɔɔzɩ́, waadʊʊ́ wɛ́-bíya bɛḿ. ");
INSERT INTO kdh_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Bɩlɛ́ nɛ́, a naárʊ wɔɔdɔ́ mɩ́ɩ sɩsɩ: “Lɛɛrʊ́ wɛ cé,” yáá “ɩwɛ lí,” ɩ́kafa yɩ toovonúm. ");
INSERT INTO kdh_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Káma, lɛɛráa bʊbɔtɩnáa na anɖébiwá bʊbɔtɩnáa wángʊrʊ́ʊ balá maamááciwá kʊ́bɔńdɩ na mááɖéwá, na a bɩ́njɔ́ɔ, bɛtɛlɛ́sɩ bɩkpɛdɩ́na wenbá Ɩsɔ́ɔ waada ɩlɩzɩ́ wɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Bɩlɛ́ nɛ́, mɩ́ɩ iguná laakáarɩ, máábásɩ mɩ́ɩ bɩrɩ́ŋa bʊrɔ naanɩ́ bɩtála nbɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Amá, bɩdɛ́ɛ wɛ́-bíya bɛḿ badaá, fúkúḿsi sɩḿ sɩwɔ́rɔ́ nɛ́, wɩ́sɩ wánlám temenuú, fenɔɔ́-dɛ́ɛ ɖɛnyɛm tóńdolosi. ");
INSERT INTO kdh_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Wɩlásɩ wánlɩɩ́ ɩsɔ́ɔ́dáá sɩ́nzalɩ́ɩ bɩka ɩsɔ́ɔ́dáá yíkowá iséle. ");
INSERT INTO kdh_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Bɩdɛ́ɛ sáátɩ gɛ bánnáa Ɩrʊ́ Biyaalʊ́ wɛ́ngɛɖɛɛ́ ɩgɔwɛ ɩsɔ́ɔ́dáá ŋmɩ́ńdɩ-daá ɩ́na ɩdɛ́ɛ yíko rɩ́ŋa na ásícé. ");
INSERT INTO kdh_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Wéngediríi ɩdɛ́ɛ malááyɩ́kawá ɖúúlínya gootá natɩ́náázá-daá fúu cé na fúu lí botúúzi wenbá waada ɩlɩzɩ́ wɛ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Ɩgbɛlɛm ná figíyée tɩɩwʊ́. A bɩgɛ́ɛ kɩdɛ́ɛ wʊláázɩ waalá siíni bɩka fáádɩ wánzʊʊ́, mɩ́nyɩ sɩsɩ lʊngʊrɛ́ waajʊ́ʊ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Bɩlɛ́ ɖʊɖɔ gɛ a mɩ́ɩ́ná wentí tɩrɩ́ŋa mááŋmátɩ mɩ́ɩ nɛ́, ɩdɩlɩ́ sɩsɩ Ɩrʊ́ Biyaalʊ́ waajʊ́ʊ nbɩlɛ́; wáńdálɩ́ mɩ́ɖaḿ wɔnásɩ. ");
INSERT INTO kdh_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ménveerím mɩ́ɩ toovonúm sɩsɩ zaamáánɩ kɩna kɩdɛ́ɛ ɩráa tɛ́ndɛŋ́ na bɩrɩ́ŋa máádɩ́ ɖɔ́ nɛ́ bɩtála. ");
INSERT INTO kdh_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Adɛ na ɩsɔ́ɔ́dáá wɛ́ndɛlɛ́ŋ, amá, mɛ́dɛ́ɛ ŋmatɩrɛ tɛ́ndɛlɛ́ŋ kɛtɛngɛrɛ.» ");
INSERT INTO kdh_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Amá, naárʊ waasɩ bɩdɛ́ɛ wɩ́rɛ yáá alɩwáátɩ. Malááyɩ́kawá bɔwɛ ɩsɔ́ɔ́dáá nɛ́ baasɩ, cáńfáná Biyaalʊ́ʊ, asée Caáwʊ riké. ");
INSERT INTO kdh_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Bɩlɛ́ nɛ́, iguná laakáarɩ bɩka ɩcɔ́ɔ míveráa, káma, mɩ́ɩ́sɩ sáátɩ wenkí sɩ bɩlá bɩlɛ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Sɩ bɩlá gɛ nyazɩ ɩrʊ́ weení sɩ ɩɖɛ́ɛ nɩ́bááwʊ, ngɛ wɔɔgbɔ́ɔ ɩɖaána ɩtalɩná ɩdɛ́ɛ bɔwʊtá-dɩnáa, báa weení na ɩdɩmɛ́rɛ; bɩka ifééri ɩɖaána-rɔ fereɖú sɩsɩ ífere nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Bɩlɛ́ nɛ́ ivére, káma, mɩ́ɩ́sɩ sáátɩ wenkí ɖɔɔ́-dʊ́ʊ sɩ ɩkɔ́nɩ nɛ́: a ɖaanɩ́ŋa ya, a nuvoo-lɔwʊ́rɛ ya, a asʊbáa ya, yáá tɛ́ɛrɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Na bɩ́kɔkɔ́nɩ a waadála, ɩmɔɔná mɩ́ɩ mínɖóm. ");
INSERT INTO kdh_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Wentí ménveerím mɩ́ɩ ɖɔ́ nɛ́, ɩráa rɩ́ŋa gɛ ménveerím tɩ: Ivére!» ");
INSERT INTO kdh_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Bɩɩga wɛ́ náálɛ na beɖi Fɛlɛ nɖɛ́ɛ-dɛ́ɛ jíńgáárɩ́ na Kpɔ́nɔ́ badaɖʊ kɩ faadɩ́nɩ nɛ́-dɛ́ɛ jíńgáárɩ́ nɛ́, ngɛ Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa na Mará wɩlɩɖáa waazʊ́ʊ cáádɩ nŋɩ́nɩ́ báta balá na bakpa Yeésu súmúú-daá bɩka bakʊ yɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Amá, sɩsɩ: «Bɩ́kalá jíńgáárɩ́ lɔwʊ́rɛ, na bɩ́kɔkɔ́nɩ bitulúsi zamɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yeésu wɛ Betáániya tɛɛbiiyá-daá, Simɔ́ɔnɩ weení cɛnɩ́tɩ waazɩ́ŋ bɩkpa yɩ nɛ́ ɩdɛ́ɛ ɖaána-daá. Sáátɩ wenkí ɩwɛ wénɖíi kíɖíím nɛ́, ngɛ alʊ́ naárʊ waagázʊʊ ɩ́gana kpárábá kazɔ́ɔ ńgɩ kɩdaá na liidebɔná tulaarɩ́ baala ná kɩ nyɩ́ɩ́dɩ bánÿaá tɩ sɩsɩ náarɩ nɛ́, ngɛ waadʊlʊ́ kpárábá ɩbɩ́rɩ tulaarɩ́ Yeésu kʊjʊʊ́-daá. ");
INSERT INTO kdh_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Wenbá ɩ́na wɛ nɛ́, badaá nɛbɛ́rɛ waana bɩlɛ́ nɛ́, bɛɛyɛ́ɛ baaná. Ngɛ sɩsɩ: «We-rɔ gɛ wɔɔvɔrɔ́sɩ tulaarɩ́ bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Baraabɩ́ɩ́zɩ bayá kɩ wɛ́ kákpaanɩɩ́nʊwá (300) tɩmɛ́rɛ liideé, bɔkpɔ́ɔ yɛ bafa kadanbʊrʊ́sɩ.» Ńna gɛ baabá bɛyɛɛná alʊ́ ɩmʊ́ baaná. ");
INSERT INTO kdh_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ngɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Iyéle yɩ. We-rɔ gɛ mɩ́nlám yɩ nɔwɛ́ya. Kazɔ́ɔ ńbɩ gɛ waalá ma. ");
INSERT INTO kdh_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Káma, báa sáátɩ wenkí mɩ́na kadanbʊrʊ́sɩ gɛ, bɩka mɩ́nbɩɩzɩ́ ɩlá wɛ kazɔ́ɔ ńbɩ báa sáátɩ wenkí gɛ mɩ́zɔɔlɛ́ɛ. Amá, mɔ́ɔ́ nɛ́, bɩdɛkɛ́ɛ báa sáátɩ wenkí gɛ sɩ iyuú ma mɩ́jɔ́. ");
INSERT INTO kdh_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Wenbí wánbɩɩzɩ́ nɛ́ gɛ waalá. Waabɩrɩná ma tulaarɩ́ nɛ́, mɛ́dɛ́ɛ bím gɛ waajáŋ ɩkpɩ́ɩ́rɩ bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ménveerím mɩ́ɩ toovonúm sɩsɩ báa lé gɛ sɩ befééri Laabáárʊ Kífeńgi ɖúúlínya rɩ́ŋa-daá, bánŋmatɩ́ wenbí waalá nɛ́ bɔtɔɔzɩná ɩrɔ.» ");
INSERT INTO kdh_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ńna gɛ ɩwanbaaráa fuú na nɔɔ́lɛ-daá kʊ́ɖʊḿ weení bánÿaá yɩ sɩsɩ Yudásɩ Isikariyóo nɛ́ wɛɛɖɛ́ɛ sarásɩ lanɖáa kʊ́bɔnáa-jɔ́ sɩ ifééri wɛ sɩsɩ wángbáa Yeésu icéle wɛ. ");
INSERT INTO kdh_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Bɛlɛ́ baanɩ́ɩ bɩlɛ́ nɛ́, ngɛ bɩɩlá wɛ niíni bɔtɔ́ yɩ sɩsɩ bɛḿ bánváa yɩ liideé. Ngɛ Yudásɩ waazʊ́ʊ nɩ́báánɩ na ɩkpa Yeésu icéle wɛ. ");
INSERT INTO kdh_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kpɔ́nɔ́ badaɖʊ kɩ faadɩ́nɩ nɛ́-dɛ́ɛ jíńgáárɩ́ wɩ́rɛ kaɖaa ńɖɛ wenɖé bángʊ́ʊ Fɛlɛ nɖɛ́ɛ-dɛ́ɛ jíńgáárɩ́ feevaláa nɛ́ gɛ wanbaaráa wɔɔbɔ́ɔ́zɩ Yeésu sɩsɩ: «Lé gɛ nyɔ́zɔɔlɛ́ɛ sɩsɩ ɖɩkpɩ́ɩ́rɩ nya Fɛlɛ nɖɛ́ɛ-dɛ́ɛ jíńgáárɩ́ kíɖíím.» ");
INSERT INTO kdh_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ngɛ Yeésu weedíri ɩwanbaaráa nɔɔ́lɛ ɩtɔ́ wɛ sɩsɩ: «Ibó tɛ́ɛ́dɩ-daá, mɩ́ngɛtɩ́ ɩrʊ́ naárʊ ɩzʊwáána báyɔ́ɔ na lɩ́m nɛ́. Ivu yɩ. ");
INSERT INTO kdh_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ɩdɔ́ ɖaána wenká kadaá sɩ ɩsʊ́ʊ nɛ́ kadʊ́ʊ sɩsɩ: “Kʊ́bɔnɩ́ sɩsɩ mɔbɔ́ɔ́zɩ nya sɩsɩ ɩɖaḿ wenkí kɩdaá ɩ́na ɩdɛ́ɛ wanbaaráa sɩ beɖi Fɛlɛ nɖɛ́ɛ-dɛ́ɛ jíńgáárɩ́ kíɖíím nɛ́ kɩ wɛ lé.” ");
INSERT INTO kdh_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ɩlɛ́ wánwɩlɩ́ɩ mɩ́ɩ ɖaḿ bú ɩsɔ́ɔ́dáá kɩɩwála bɩka bɔ́ńnyɔɔzɩ kɩdaá nɛ́. Ńna gɛ mɩ́nlám ɖáa kíɖíím.» ");
INSERT INTO kdh_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ngɛ wanbaaráa wɛɛɖɛ́ɛ tɛ́ɛ́dɩ-daá. Wenbí nɔ́ɔ́ Yeésu waaŋmátɩ wɛ nɛ́ bɩɩla ná. Ngɛ baagbɩ́ɩ́rɩ Fɛlɛ nɖɛ́ɛ-dɛ́ɛ jíńgáárɩ́. ");
INSERT INTO kdh_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kɩɩɖáánɩ nɛ́, ngɛ Yeésu na ɩwanbaaráa fuú na nɔɔ́lɛ baadála. ");
INSERT INTO kdh_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Bɔjɔɔ́ɔ bénɖíi kíɖíím nɛ́, ngɛ Yeésu sɩsɩ: «Ménveerím mɩ́ɩ toovonúm sɩsɩ mɩ́dáá kʊ́ɖʊḿ weení mána yɩ ɖénɖíi nɛ́ wánÿám ma.» ");
INSERT INTO kdh_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Wanbaaráa waazʊ́ʊ kaanɩŋá, ngɛ bɔ́nbɔɔzɩ́ yɩ kʊ́ɖʊḿ‑kʊ́ɖʊḿ bángáa ɖamá sɩsɩ: «Mɔ́ɔ́ yáá wé.» ");
INSERT INTO kdh_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ngɛ woobúsi wɛ sɩsɩ: «Mɩ́nyɔ́ɔ́ wanbaaráa fuú na nɔɔ́lɛ mɩ́dáá kʊ́ɖʊḿ mána yɩ ɖénɖíi nyɩnɔɔ́ kʊ́ɖʊmɔ́ɔ-daá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ɩrʊ́ Biyaalʊ́ wɛ́nɖɛɛ́ ńŋɩnáa baaŋmáa Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá ɩrɔ nɛ́. Amá, nbusú ɖamáa na weení sɩ ɩyá yɩ nɛ́. A bátalʊ́rʊ bʊdʊ́ʊ, bɩraalá yɩ sóńcí.» ");
INSERT INTO kdh_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Bɔwɛ bénɖíi kíɖíím nɛ́, Yeésu wɔɔgbɔ́ɔ kpɔ́nɔ́. Waazá Ɩsɔ́ɔ kɩrɔ bɩtɛ́ nɛ́, ngɛ wɛɛbɛlɩ́ kɩ icéle ɩwanbaaráa ɩtɔ́ wɛ sɩsɩ: «Ɩmʊ ɩtɔ́ɔ, mɔ́dɔ́nʊʊ́ nbɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Bɩlɛ́ bʊwɔ́rɔ́ nɛ́, ngɛ wɔɔgbɔ́ɔ sʊlʊ́m na kagbɔ́ɔ, waazá Ɩsɔ́ɔ bʊrɔ bɩtɛ́ nɛ́, ngɛ weejéle wɛ bɩ. Ngɛ barɩ́ŋa bɔɔnyɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ngɛ wɔɔdɔ́ wɛ sɩsɩ: «Mɛ́dɛ́ɛ azimá nbɩlɛ́, bɩnáábɩ́lɛ́ keɖiyá azimá bɩɩbɩ́rɩ ɩráa tuutúúma-rɔ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ménveerím mɩ́ɩ toovonúm sɩsɩ mɔ́dɔ́ndɔnyɔɔ sʊlʊ́m bɩḿ hálɩ wɩ́rɛ wenɖé sɩ mɔgɔ́nyɔ́ɔ sʊlʊ́m kɩ́fabɩ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-daá nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Beedée jíńgáárɩ́ yéńdiwá basá Ɩsɔ́ɔ bɩtɛ́ nɛ́, ngɛ baalɩ́ɩ bɛɖɛ́ɛ Olivíyée tɩ́ɩ́nɩ bʊ́ʊ-daá. ");
INSERT INTO kdh_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ńna gɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Mɩ́rɩ́ŋa mínzée iyéle ma, káma, baaŋmáa Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá sɩsɩ: “Mángʊ́ʊ ketirú na fééni ɩya ɖamá.” ");
INSERT INTO kdh_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Amá, a méévé malɩ́ɩ ɩsɩɖáa-daá, mɛ́ndɛ́ɛ mɩ́ɩ nɩ́bááwʊ mobó Galilée laadɔ́ɔ-daá.» ");
INSERT INTO kdh_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ngɛ Pétro sɩsɩ: «Báa barɩ́ŋa bénzée beyéle nya, mɔ́ɔ́ médénzée kɛtɛngɛrɛ meyéle nya.» ");
INSERT INTO kdh_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ńna gɛ Yeésu wɔɔdɔ́ yɩ sɩsɩ: «Ménveerím nya toovonúm sɩsɩ sinje nuvoowú kɩna kɩdɩtɩŋa, naanɩ́ na kalɩńbaawʊ́ ɩbɔ́ɔ nabʊ́lɛ nɛ́, nyɔ́njɔɔlɩ́ bʊrɔ nabúdoozo sɩsɩ nyáásɩ ma.» ");
INSERT INTO kdh_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ńna gɛ Pétro waazɩ́ŋ bɩcáárɩ sɩsɩ: «Báa bɩ́nbɔɔzɩ́ sɩsɩ mána nya ɖɩsɩ́, mɔ́dɔ́ndɔḿ sɩsɩ máásɩ nya.» Ngɛ wanbaaráa baaganáa rɩ́ŋa ɖʊɖɔ wɔɔdɔ́ bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yeésu na ɩwanbaaráa boobó bɩlɛ́ hálɩ batála ɖɩdáarɛ bánÿaá ɖɛ sɩsɩ Gɛtɩsemanée nɛ́ ɖɩdaá. Ńna gɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Ɩjɔ́ɔ cé, na mobó magázʊlʊ Ɩsɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ngɛ wɛɛgbɛdɩ́na Pétro na Yaakúbu na Yʊháánɩ. Bɩdɛ́ɛ sáátɩ gɛ waabá ɩsʊ́ʊ kaanɩŋá bɩka ɩlaakáarɩ ɩbá bɩkʊrʊ́. ");
INSERT INTO kdh_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ńna gɛ wɔɔdɔ́ wɛ sɩsɩ: «Málaakáarɩ waazʊ́ʊ kaanɩŋá páá hálɩ bínÿelíi mazɩ́. Ɩjɔ́ɔ cé ɩcɔɔná mɩ́ɩ́zá.» ");
INSERT INTO kdh_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ngɛ woodorí ɩdɩ ɩlɩ́ɩ bolíni cʊ́kɔ, ɩcɛ́ ɩsála adɛ ɩsʊ́lʊ sɩsɩ a bɩ́nlám Ɩsɔ́ɔ ɩlaná yɩ alɩwáátɩ kɩḿ bolíni. ");
INSERT INTO kdh_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ngɛ sɩsɩ: «Áába!» Bugutoluú sɩsɩ Baabá. «Nyánbɩɩzɩ́ báa wé, laná ma bolíni na wahála kagbɔ́ɔ kana. Amá, bɩdɛkɛ́ɛ wenbí mɔ́zɔɔlɛ́ɛ nɛ́ ɩ́la ná, wenbí nyɔ́zɔɔlɛ́ɛ nɛ́ ɩ́la ná.» ");
INSERT INTO kdh_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yeésu wɔɔlɔ́ɔ ɩkábɩsɩ ɩwanbaaráa toozóóní-jɔ́ nɛ́, ngɛ wɔɔmɔɔná wɛ bónɖóm. Ngɛ wɔɔdɔ́ Pétro sɩsɩ: «Simɔ́ɔnɩ, nyɔ́wɛ nyónɖóm! A bɩlɛ́ ńdábɩ́ɩ́zɩ njɔɔná nyáázá báa áwa kʊ́ɖʊmʊ́ʊ? ");
INSERT INTO kdh_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ɩjɔɔná mɩ́ɩ́zá bɩka ɩsʊ́lʊ Ɩsɔ́ɔ na ɩ́kasála Sitáánɩ-dɛ́ɛ kɔdɔ́sɩ-daá. Ɩrʊ́ wɛná sɔɔlɩ́m sɩ ɩlá, amá, tɔnʊʊ́ tafɩ́ya.» ");
INSERT INTO kdh_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ngɛ woodótorí ɩdɩ ɩlɩ́ɩ bolíni cʊ́kɔ ɩsʊ́lʊ Ɩsɔ́ɔ na tɔ́m bíya kʊ́ɖʊmáa bɛḿ. ");
INSERT INTO kdh_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Waadákabɩsɩ ɩwanbaaráa-jɔ́ nɛ́, wɔɔdɔ́mɔɔná wɛ bónɖóm, káma, ɖóm caarɛ́ɛ wɛ, ngɛ bodoyuú kʊ́tɔḿtɩ. ");
INSERT INTO kdh_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Toozo-dɛ́ɛ waagábɩsɩ nɛ́, ngɛ wɔɔdɔ́ wɛ sɩsɩ: «Mɩ́bamáa ɖóm mɩ́nvɛɛzɩ́! Tɔ́ɔ bɩɩdála! Alɩwáátɩ wenkí sɩ bakpa Ɩrʊ́ Biyaalʊ́ bayaná alaháácɩ́-dɩnáa nɛ́ waadála. ");
INSERT INTO kdh_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ɩgʊrʊ́ ɖɩɖɛ́ɛ! Ɩbɛ́ɛ, weení wánÿám ma nɛ́ waadála.» ");
INSERT INTO kdh_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ɩbamáa ŋmatɩrɛ gɛ wanbaaráa fuú na nɔɔ́lɛ-daá kʊ́ɖʊḿ bánÿaá yɩ sɩsɩ Yudásɩ nɛ́ waadála, ɩ́gana ɩráa fuúre bágána tókobíwá na ɖáázɩ. Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa na Mará wɩlɩɖáa na Yahúúɖuwá-dɛ́ɛ kʊ́bɔnáa weegédíri ná wɛ. ");
INSERT INTO kdh_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yudásɩ, weení wánÿám yɩ nɛ́, waavʊ́ńgéveeri wɛ sɩsɩ: «Weení sɩ megbíríki yɩ mɛzɛ́ɛ yɩ nɛ́, Yeésu nbɩlɛ́. Ɩgba yɩ ɩɖɛɛná bɩka ifére ɩrɔ kazɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ńna‑ńna gɛ waanʊ́ŋ ɩkɛ́ɖɛɛ Yeésu-jɔ́ ɩtɔ́ yɩ sɩsɩ: «Kʊ́bɔnɩ́». Ngɛ weegbíríki Yeésu. ");
INSERT INTO kdh_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ńna gɛ baaganáa woogóduu bakpa Yeésu. ");
INSERT INTO kdh_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Bɩnáábɩ́lɛ́ Yeésu na wenbá nɛ́ badaá kʊ́ɖʊḿ wɛɛgbɛ́ɛ ɩdɛ́ɛ tókobí ɩcɛ́sɩ Ɩsɔ́ɔ sarásɩ lanɖáa rɩ́ŋa-dɛ́ɛ kʊ́bɔnɩ́-dɛ́ɛ bɔwʊtá-dʊ́ʊ, ngɛ bɩɩjɛ́ ɩlɛ́ ɩnɩgbamʊʊ́. ");
INSERT INTO kdh_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Alɩwáátɩ kɩḿ gɛ Yeésu wɔɔdɔ́ zamɔ́ɔ sɩsɩ: «Mɩ́ɩgálɩ́ɩ ɩkɔ́nɩ sɩ ɩkpa ma na tókobíwá na ɖáázɩ nyazɩ mɛ́gɛ́ɛ ɩrángʊ́ʊ́rʊ? ");
INSERT INTO kdh_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Báa wɩ́rɛ wenɖé, mɔ́jɔɔ́ɔ mɩ́lɔ́wʊ́táá Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá gɛ mánwɩlɩ́ɩ ɩráa Ɩsɔ́ɔ-dɛ́ɛ tɔ́m, mɩ́dákpá ma. Amá, bɩlɛ́ bɩrɩ́ŋa bɩɩlá gɛ na wentí anɖébiwá waaŋmáa nɛ́ ikóódi.» ");
INSERT INTO kdh_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Yeésu wanbaaráa waaya ɖamá bese beyéle yɩ. ");
INSERT INTO kdh_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ngɛ bú afobú naárʊ ivóóna bɩsaawʊ́ nɛ́ woovu yɩ. Ngɛ baagba yɩ. ");
INSERT INTO kdh_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Amá, ɩlɛ́ weeyéle bɩsaawʊ́ ise ɩɖɛ́ɛ tunbóóló. ");
INSERT INTO kdh_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Wenbá baagba Yeésu nɛ́, bɛɛɖɛɛná yɩ Ɩsɔ́ɔ sarásɩ lanɖáa rɩ́ŋa-dɛ́ɛ kʊ́bɔnɩ́ weení Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa rɩ́ŋa, na Yahúúɖuwá-dɛ́ɛ kʊ́bɔnáa na Mará wɩlɩɖáa tuuzée ɩdɛ́ɛ nɛ́-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pétro ɩlɛ́ woovu Yeésu ɩjɔɔ́na yɩ bolíni hálɩ sarásɩ lanɖʊ́ kʊ́bɔnɩ́-dɛ́ɛ ɖaána-daá, ɩsʊ́ʊ ɩcɔ́ɔ ɩ́na ɩlɛ́ ɩdɛ́ɛ bɔwʊtá-dɩnáa wénweríi nimíni. ");
INSERT INTO kdh_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa na Yahúúɖuwá-dɛ́ɛ tɔmvʊʊráa kʊ́bɔnáa baaganáa wánjáádɩ seríya sɩ bakʊná Yeésu-dɛ́ɛ tɔ́m na bakʊ yɩ nɛ́, ngʊ́ bodoyuú kúbuunátɩ. ");
INSERT INTO kdh_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Káma, ɩráa ɖabata waalɩzɩ́ seríyawá bʊbɔ́tɩ ńdɩ, amá, tɩdasáa. ");
INSERT INTO kdh_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ngɛ ɩráa nɛbɛ́rɛ waagʊrʊ́ balɩzɩ́ seríya bʊbɔ́tɩ ńgɩ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Ɖáánɩ́ɩ ɩrʊ́ ceení wɔɔdɔ́ sɩsɩ wánbɩɩzɩ́ ɩyɔ́ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga kana ɩráa waama kɛ nɛ́, na wɛ́ náádoozo, ɩbɩ́sɩ ɩma nɛkɛ́rɛ wenká ɩráa tama kɛ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Amá, na bɩrɩ́ŋa bɩlɛ́, bɔnɔ́ɔ́zɩ tasáa bɛdɛ́ɛ seríya lɩzɩ́ɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ńna gɛ Ɩsɔ́ɔ sarásɩ lanɖáa rɩ́ŋa-dɛ́ɛ kʊ́bɔnɩ́ waagʊrʊ́ zamɔ́ɔ lɔwʊtáá ɩtɔ́ yɩ sɩsɩ: «Nyɛ́vɛ́yɩ́na natɩ́rɩ sɩ nbúsi wentí ɩráa bana bónbuunáa nya nɛ́?» ");
INSERT INTO kdh_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Amá, Yeésu sumáa gɛ. Bɩnáábɩ́lɛ́ Ɩsɔ́ɔ sarásɩ lanɖáa rɩ́ŋa-dɛ́ɛ kʊ́bɔnɩ́ wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Nyɔ́ɔ́ gɛ Lɛɛrʊ́, Ɩsɔ́ɔ weení ɖónguú yɩ tɛ́ɛ́dɩ nɛ́ Ibiyaalʊ́?» ");
INSERT INTO kdh_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yeésu woobúsi yɩ sɩsɩ: «Bɩlɛ́ gɛ mɛ́gɛ́ɛ, ngɛ mɩ́nnáa Ɩrʊ́ Biyaalʊ́ ɩjɔɔ́ɔ Ɩsɔ́ɔ Wúro Kʊ́bɔnɩ́-dɛ́ɛ nʊ́ʊ́nɩ kíɖiiwú-rɔ. Mɩ́ndanáa yɩ wángalɩɩnáa ɩsɔ́ɔ́dáá wéngedím ŋmɩ́ńdɩ-rɔ.» ");
INSERT INTO kdh_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ńna gɛ Ɩsɔ́ɔ sarásɩ lanɖáa rɩ́ŋa-dɛ́ɛ kʊ́bɔnɩ́ wɛɛlɛrɩ́ igúsúúdi ɩtɔ́ sɩsɩ: «Wɛɛgbɛɛná Ɩsɔ́ɔ. Bidokúti bɩbɔ́ɔ́zɩ seríya-dʊ́ʊ ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mɩ́ɩ́nɩ́ɩ waaŋmátɩ ɩkpɛɛná Ɩsɔ́ɔ nɛ́. Mɩ́nmaazɩ́ sɩsɩ wé.» Ngɛ barɩ́ŋa baagʊ ɩdɔ́m bɔtɔ́ sɩsɩ ɩmɔɔ́na bakʊ yɩ gɛ. ");
INSERT INTO kdh_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ngɛ badaá nɛbɛ́rɛ wɔɔdɔ ndɔɔlɩmá waazá-daá, bamá yɩ cɔɖɩ́wá, bɩka bɔ́ndɔ́m sɩsɩ: «Lɛɛrʊ́ tɩrɩkɩ, weení waama ná nya.» Ngɛ sɔ́ɔ́jawá fereɖáa wɔɔgbɔ́ɔ Yeésu bɛcɛ́ yɩ kadáázɩ. ");
INSERT INTO kdh_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Bɩdɛ́ɛ sáátɩ, Pétro cɔɔ́ɔ bɩdɛ tɔ́ɔ-rɔɔzɩ́. Ngɛ Ɩsɔ́ɔ sarásɩ lanɖáa rɩ́ŋa-dɛ́ɛ kʊ́bɔnɩ́-dɛ́ɛ aláa bɔwʊtá-dɩnáa-daá naárʊ waadála. ");
INSERT INTO kdh_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Waana Pétro wénweríi nimíni nɛ́, ngɛ waabá ɩbɛ́ɛ́ŋ yɩ tíḿḿ; ngɛ wɔɔdɔ́ yɩ sɩsɩ: «Nyɔ́ɔ́ ɖʊɖɔ nyágána Yeésu Nazarɛ́ɛtɩ ńnɩ́ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Amá, wɔɔjɔ́ɔ́lɩ ɩtɔ́ sɩsɩ: «Máásɩ wentí nyɔ́ndɔ́m nɛ́, ngʊ́ mádánnɩɩ wentí nyánŋmatɩ́ nɛ́ tugutoluú.» Ngɛ wɛɛɖɛ́ɛ ɩlɩ́ɩ asʊ ɖugoré-daá. Ńna gɛ kalɩńbaawʊ́ wɔɔbɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Amá, alʊ́ bɔwʊtá-dʊ́ʊ waadánáa yɩ ngɛ wɔɔdɔ́tɔḿ ɩ́na wenbá nɛ́ ɩzá-daá sɩsɩ: «Ceení ɖʊɖɔ na wɛ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ngɛ Pétro wɔɔdɔ́cɔɔlɩ. Bɩɩdásɩ nɛ́, wenbá bɔwɛ ńna nɛ́, bɔɔdɔ́tɔḿ Pétro sɩsɩ: «Toovonúm gɛ, nyɔ́ɔ́ ɖʊɖɔ nyɛ́gɛ́ɛ bɛdɛ́ɛ ɩrʊ́ gɛ, Galilée ńnɩ́ gɛ nyɛ́gɛ́ɛ.» ");
INSERT INTO kdh_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ńna gɛ waaŋmátɩ sɩsɩ: «A ɖé bʊbɔ́tɩ gɛ mɛ́nbɛlɩ́ɩ, Ɩsɔ́ɔ ɩ́fɔ mánɩgbamʊʊ́. Máámʊ́ná sɩsɩ máásɩ ɩrʊ́ weení mɩ́nŋmatɩ́ ɩdɔ́m nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ngɛ kalɩńbaawʊ́ waajáŋ kɩbɔ́ɔ sɩɩlɛ-dɛ́ɛ. Ńna gɛ Pétro wɔɔdɔ́ɔ́zɩ tɔ́m wentí Yeésu wɔɔdɔ́ yɩ nɛ́; tɩlɛ́ gɛ sɩsɩ: «Naanɩ́ na kalɩńbaawʊ́ ɩbɔ́ɔ nabʊ́lɛ nɛ́, nyɔ́njɔɔlɩ́ bʊrɔ nabúdoozo sɩsɩ nyáásɩ ma.» Ngɛ waalɩ́ɩ ɩbá iwíi. ");
INSERT INTO kdh_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kiivé tɛ́ɛrɛ́‑tɛ́ɛrɛ́ nɛ́, Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa na Yahúúɖuwá-dɛ́ɛ kʊ́bɔnáa na Mará wɩlɩɖáa na Yahúúɖuwá-dɛ́ɛ tɔmvʊʊráa kʊ́bɔnáa bɔɔjɔ́ɔ bacáa lomaazɛ́. Ngɛ bɔɔvɔ́kɩ Yeésu nibé boboná yɩ becéle laadɔ́ɔ-dɛ́ɛ nɩ́baadɛɛrʊ́ Piláatɩ. ");
INSERT INTO kdh_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ngɛ ɩlɛ́ wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Nyɔ́ɔ́ gɛ Yahúúɖuwá-dɛ́ɛ wúro?» Ngɛ Yeésu woobúsi yɩ sɩsɩ: «Nyɔ́ɔ́dɔ́ ná.» ");
INSERT INTO kdh_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ngɛ Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa woobuuná Yeésu tɔ́mwá ɖabata. ");
INSERT INTO kdh_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ńna gɛ Piláatɩ wɔɔdɔ́bɔɔzɩ yɩ sɩsɩ: «Ńdónbusi natɩ́rɩ? Ńdánnɩɩ wentí tɩrɩ́ŋa bónbuunáa nya nɛ́?» ");
INSERT INTO kdh_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Amá, Yeésu tobúsi yɩ natɩ́rɩ hálɩ bɩbá bɩlá Piláatɩ bítí. ");
INSERT INTO kdh_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Fɛlɛ nɖɛ́ɛ-dɛ́ɛ jíńgáárɩ́ báa wenkí, laadɔ́ɔ-dɛ́ɛ nɩ́baadɛɛrʊ́ wɛ́ndɛ́rɛ́jɛ́m sáráka-dʊ́ʊ kʊ́ɖʊḿ weení zamɔ́ɔ wɔɔzɔ́ɔ́lɩ sɩsɩ ɩ́cɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Abaalʊ́ naárʊ wɔɔjɔɔ ná bánÿaá yɩ sɩsɩ Barabáasɩ. Baagba ɩ́na ɩɖɔndɩnáa nɛbɛ́rɛ bɔtɔ sáráka, káma, baagʊ ɩrʊ́ naárʊ wɩ́rɛ wenɖé ɩráa zamɔ́ɔ waagʊrʊ́na gómínantɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ngɛ zamɔ́ɔ woobó Piláatɩ-dɛ́ɛ kɩ́nbɔɔzɩ́ yɩ sɩsɩ ɩ́la bɛḿ ńŋɩnáa wándárálám bɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ńna gɛ Piláatɩ wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «Mɩ́zɔɔlɛ́ɛ mɛjɛ́ mɩ́ɩ Yahúúɖuwá-dɛ́ɛ wúro?» ");
INSERT INTO kdh_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Káma, Piláatɩ nyɩ bɩlɛ́ sɩsɩ sʊ́ʊ́zɩ weeyele ná Ɩsɔ́ɔ sarásɩ lanɖáa ɩkpa Yeésu becéle yɩ. ");
INSERT INTO kdh_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Amá, Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa waajáárɩ zamɔ́ɔ sɩsɩ kɩ́bɔɔzɩ Barabáasɩ-dɛ́ɛ cɛ́m. ");
INSERT INTO kdh_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Bɩnáábɩ́lɛ́ Piláatɩ wɔɔdɔ́bɔɔzɩ wɛ sɩsɩ: «Nɛ́, we gɛ máláná weení mɩ́nÿaá yɩ sɩsɩ Yahúúɖuwá-dɛ́ɛ wúro nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Boodóbusi yɩ bɩcáárɩ sɩsɩ: «Ka yɩ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ.» ");
INSERT INTO kdh_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ngɛ Piláatɩ wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «Taalɩ́ wenkí gɛ waalá.» Amá, bɛlɛ́ baabá gɛ babamáa kóódi bɩ́njaarɩ́ sɩsɩ: «Ka yɩ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ.» ");
INSERT INTO kdh_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Piláatɩ sɩ ɩlá bɩlá zamɔ́ɔ niíni nɛ́, ngɛ wɛɛjɛ́ kɩ Barabáasɩ. Bɩɩga Yeésu ɩlɛ́ nɛ́, wɔɔgbɔ́ɔ yɩ icéle wɛ sɩsɩ bósuti yɩ agbáázá bɩka baká yɩ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ngɛ sɔ́ɔ́jawá wooboná Yeésu laadɔ́ɔ-dɛ́ɛ nɩ́baadɛɛrʊ́ Piláatɩ-dɛ́ɛ kowuro-ɖugoré-daá. Ngɛ boodúúzi sɔ́ɔ́jawá baaganáa rɩ́ŋa. ");
INSERT INTO kdh_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Boozúu yɩ tóko kɩ́sɛɛmʊ́ʊ. Ngɛ baalʊ́ʊ wʊláázɩ sɩjɔɔ́ɔ sɔwá‑sɔwá nɛ́ nyazɩ kowuro-vulɔɔ́ bofu ɩgʊjʊʊ́; ");
INSERT INTO kdh_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","bɩka bɛ́nzɛɛ́ yɩ bɔ́ndɔ́m sɩsɩ: «Ɖɛ́ɛ́zɛ́ɛ nya Yahúúɖuwá-dɛ́ɛ wúro.» ");
INSERT INTO kdh_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bɩka bɔ́ngbɔwʊ́ʊ ɖɩgɛrɛ́ ɖeníka bánmám ɩgʊjʊʊ́-daá. Bɔ́ndɔnáa yɩ ndɔɔlɩmá. Bɩka boozóm waazá-daá hálɩ babá bolúúzi badɩ adɛ. ");
INSERT INTO kdh_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Baamʊ́ŋ yɩ bɩtɛ́ nɛ́, ngɛ baalɩzɩ́ yɩ tóko kɩ́sɛɛmʊ́ʊ, babɩsɩná ɩdɛ́ɛ ńdɩ bosúu yɩ. Ngɛ bɛɛɖɛɛná yɩ sɩ bakága ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Baalɩ́ɩ bɛ́nɖɛɛ́ nɛ́, baana abaalʊ́ naárʊ wáńgálɩɩná fɔɔ́ wɛ́nɖɛɛ́, bánÿaá yɩ sɩsɩ Simɔ́ɔnɩ. Ɩgɛ́ɛ Sirɛ́ɛnɩ laadɔ́ɔ-daá ńnɩ́ gɛ. Ibiyaalɩnáa gɛ Alɛkɩsándɩrɩ na Rufúusi. Ngɛ baagba yɩ ɖóóle ɩsʊ́ʊ Yeésu-dɛ́ɛ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Booboná Yeésu ɖɩdáarɛ wenɖé bánÿaá ɖɛ sɩsɩ Gɔlɩgóóta nɛ́. Gɔlɩgóóta kutoluú gɛ sɩsɩ Kʊjʊʊ́ Bɔɔrɔɔ́ ɖɩdáarɛ. ");
INSERT INTO kdh_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Bɔɔzɔ́ɔ́lɩ sɩsɩ bafa yɩ sʊlʊ́m baaja ná faadɩ́nɩ nyɛ́nɩ ńdɩ nɛ́ sɩsɩ ɩ́nyɔ́ɔ. Amá, Yeésu tɔnyɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ngɛ baagá yɩ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ. Bɛɛdɛ́ nɛ́, ngɛ bɔɔdɔ tɛ́tɛ́ ɩgbɩná-rɔ na batɩlɩ́ wenbí báa weení wɔ́ngbɔwʊ́ʊ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Tɛ́ɛrɛ́ kéréfu kééníré gɛ baagá yɩ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Wenbí baaŋmáa kpálɩfɔ́ɔ-rɔ bosúsi ɩgʊjʊʊ́-rɔ bɩ́nwɩlɩ́ɩ wenbí bʊrɔ baagʊ yɩ nɛ́ gɛ sɩsɩ: «Yahúúɖuwá-dɛ́ɛ wúro.» ");
INSERT INTO kdh_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ngɛ baagá ɩráńgʊ́ʊ́ráa nɔɔ́lɛ batasɩná yɩ. Kʊ́ɖʊḿ igíɖiiwú-rɔ, waaganáa ɩnɩbɩɩwʊ́-rɔ.  ");
INSERT INTO kdh_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Bɩlɛ́ gɛ bɩɩlá gɛ wentí baaŋmáa Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá nɛ́ woogóódi. Tɩlɛ́ gɛ sɩsɩ: «Bɔɔgbɔ́ɔ yɩ baɖʊ ɩráa badaavé nɛ́ bɔlɔwʊtáá.» ");
INSERT INTO kdh_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nɩ́baaɖɛɛráa wándʊ́ʊ́dɩ yɩ bɩka bɔ́nbɔtɩ́ bagʊjʊ́nɩ, bɩka bɔ́ndɔ́m sɩsɩ: «Nyɔ́ɔ́ weení nyɔ́nÿɔ́m Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga nbɩ́sɩ nma kɛ wɛ́ náádoozo nɛ́, ");
INSERT INTO kdh_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","nyádɩtɩŋa lɛɛ nyádɩ, bɩka ngédi ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ.» ");
INSERT INTO kdh_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bɩlɛ́ ɖʊɖɔ gɛ Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa na Mará wɩlɩɖáa wánmʊŋɛ́ yɩ bɔ́ndɔ́m yɩ sɩsɩ: «Wɛɛlɛ́ɛ baaganáa, amá, ɩ́dánbɩɩzɩ ɩlɛ́ɛ ɩdɩ. ");
INSERT INTO kdh_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","A ɩnáábɩ́lɛ́ Lɛɛrʊ́, íkedi lɛlɛɛɖɔ́ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ ɖɩna na ɖɩfa yɩ toovonúm!» Bɩlɛ́ nɔ́ɔ́ gɛ bɩkpɛdɩ́na ɩráńgʊ́ʊ́ráa wenbá baagá ɩ́na wɛ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ nɛ́ bándʊ́ʊ́dɩ yɩ. ");
INSERT INTO kdh_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kpɔɔ ɩdaawʊ́ kéréfu fuú na natɩ́lɛ nbó ɖaanɩ́ŋa kéréfu natúdoozo, bɩɩlá temenuú laadɔ́ɔ rɩ́ŋa-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ɖaanɩ́ŋa kéréfu natúdoozo bɩlɛ́ gɛ Yeésu woogóo bɩcáárɩ sɩsɩ: «Elíi, Elíi, lemá sabakɩtááni.» Bugutoluú sɩsɩ: «Mɛ́dɛ́ɛ Ɩsɔ́ɔ, mɛ́dɛ́ɛ Ɩsɔ́ɔ, ngbaalá gɛ nyɛ́ɛ́jɛ́ ma ndálɩ.» ");
INSERT INTO kdh_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Wenbá bɔwɛ ńna gɛ baanɩ́ɩ nɛ́, badaá nɛbɛ́rɛ sɩsɩ Elíya gɛ wánÿaá. ");
INSERT INTO kdh_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ngɛ badaá naárʊ waajáŋ ise ɩkɔ́gbɔ́ɔ kɩcɛ́ ilíi sʊlʊ́m nyɩ́gáázɩ ńbɩ-daá ɩkpɔ́ɔ isúu ɖɩgɛrɛ́ nɔɔ́-daá ɩkpáázɩ Yeésu nɔɔ́-jɔ́ sɩsɩ ɩ́nyɔ́ɔ. Ngɛ sɩsɩ: «Ɩzɩ́ŋ ɖɩbɛ́ɛ sɩsɩ Elíya wɔ́ngɔnɩ́ ikédisi yɩ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ?» ");
INSERT INTO kdh_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Amá, Yeésu woogóo bɩcáárɩ, ngɛ weedísi weezuú. ");
INSERT INTO kdh_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ngɛ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá láámílé waadára nabʊ́lɛ kɔgbɔɔ ɩsɔ́ɔ́dáá ngɔ́nɩ adɛ. ");
INSERT INTO kdh_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Róóma sɔ́ɔ́ja kʊ́bɔnɩ́ waana iweezuú waalɩ́ɩ nɛ́, ngɛ sɩsɩ: «Toovonúm, ɩrʊ́ ceení ɩbá ɩgɛ́ɛ Ɩsɔ́ɔ Biyaalʊ́ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Aláa ɖabata wɛ ńna bagazɩ́ŋɛ́ɛ bolíni bɛgɛbɛɛ́na. Badaá: bɛɛ Marɩyáma Magɩdaláa alʊ́, na Marɩyáma Yaakúbu kúmuú na Yoozée bɔgɔɔ, na Salomée. ");
INSERT INTO kdh_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ɖoo Galilée laadɔ́ɔ-daá gɛ bogovóo Yeésu bángalám yɩ bɔwʊtá. Aláa ɖabata wɛ ńna ɖʊɖɔ, boogóvú Yeésu bɔkɔ́nɩ Yerusalɛ́ɛm nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kɩ́ńjáŋ kɩɖáánɩ; ngɛ bɩgɛ́ɛ na wɩ́rɛ wenɖé bángbɩɩrɩ́ nɛ́. Bugutoluú sɩsɩ sɩ kifé na beɖi Fɛɛzɩrɛ wɩ́rɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ngɛ Ísifu ɩgɛ́ɛ Arɩmatée tɛ́ɛ́dɩ-daá ńnɩ́ nɛ́ waadála. Ɩrʊ́ ɩmʊ́ ɩgɛ́ɛ Yahúúɖuwá-dɛ́ɛ tɔmvʊʊráa kʊ́bɔnáa-daá ɩrʊ́ fɩ́ya ńnɩ́ naárʊ gɛ, bɩka ɩvʊnɖamáa Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ. Ngɛ wooyuú wenbiré ibó ɩmɔɔná Piláatɩ ɩbɔ́ɔ́zɩ yɩ Yeésu tɔnʊʊ́. ");
INSERT INTO kdh_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Bɩɩlá Piláatɩ bítí sɩsɩ Yeésu wáńzɩ́ḿ. Ngɛ weeyéle bakáyáa Róóma sɔ́ɔ́ja kʊ́bɔnɩ́ ɩbɔ́ɔ́zɩ yɩ sɩsɩ Yeésu waavʊ́ńzɩḿ gɛ? ");
INSERT INTO kdh_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Waanɩ́ɩ ɩnɔɔ́-daá nɛ́, ngɛ waava nɩ́bááwʊ sɩsɩ bécéle yɩ kɩ. ");
INSERT INTO kdh_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ísifu woobó ɩkámʊ́ kásáŋá, ngɛ wɔɔgɔ́nɩ ikédisi ɩsɩɖʊ́ ikoodi ná yɩ kásáŋá. Ngɛ wɔɔgbɔ́ɔ yɩ ɩɖʊ bɔɔlááwʊ baabáa kɩ bʊ́tangbalʊʊ́-daá nɛ́ kɩdaá. Ngɛ weebiláázɩ bʊ́ʊ́rɛ kʊ́bɔńɖɛ ɩtɔ bɔɔlááwʊ nɔɔ́. ");
INSERT INTO kdh_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Bɩdɛ́ɛ sáátɩ kɩḿ, Marɩyáma Magɩdaláa alʊ́ na Marɩyáma Yoozée ɩgɔɔ bɛbɛɛ́na lé bánɖʊ́ʊ Yeésu nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Fɛɛzɩrɛ wɩ́rɛ wɛɛɖɛ́ɛ bɩtɛ́ nɛ́, ngɛ Marɩyáma Magɩdaláa alʊ́ na Marɩyáma Yaakúbu ɩgɔɔ na Salomée baamʊ núm bínvoorí nɛ́ sɩ bobó basaárɩ Yeésu tɔnʊʊ́. ");
INSERT INTO kdh_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Beeɖi Fɛɛzɩrɛ wɩ́rɛ kifé aláháɖɩ tɛ́ɛrɛ́‑tɛ́ɛrɛ́ nɛ́, wɩ́sɩ wángalɩɩ́ nɛ́, ngɛ bɛɛɖɛ́ɛ bɔɔlááwʊ-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Bɔwɛ bɔ́nbɔɔzɩ́ badɩ sɩsɩ weení sɩ ibiláázɩ ná bɛḿ bʊ́ʊ́rɛ kʊ́bɔńɖɛ bɔɔdɔ ɖɛ bɔɔlááwʊ nɔɔ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Baagʊ́sɩ ɩzá nɛ́, na bɩrɩ́ŋa bʊ́ʊ́rɛ waabá ɖikíi nɛ́, baana sɩsɩ ɖilewáa fɔɔlʊʊ́. ");
INSERT INTO kdh_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Baazʊ́ʊ bɔɔlááwʊ-daá nɛ́, ngɛ baana afobú naárʊ ɩjɔɔ́ɔ kíɖiiwú-rɔ, izóóna jaba kʊ́fʊlʊmʊ́ʊ. Ngɛ nɩdáárɛ waazʊ́ʊ wɛ. ");
INSERT INTO kdh_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Amá, ɩlɛ́ wɔɔdɔ́ wɛ sɩsɩ: «Mɩ́nyɔ́ɔ́ ɩ́kanɩ́ɩ nɩdáárɛ. Mányɩ sɩsɩ Yeésu Nazarɛ́ɛtɩ ńnɩ́ baagá yɩ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ nɛ́ gɛ mɩ́njáádɩ. Ɩvɛ́yɩ́ cé, káma, weevé ɩlɩ́ɩ ɩsɩɖáa-daá. Ɩgɔ́nɩ ɩbɛ́ɛ lénlé baavʊ́ńvɩɩzɩ yɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Amá, ibó ifééri ɩwanbaaráa na Pétro sɩsɩ: “Wɛɛdɛ mɩ́ɩ nɩ́bááwʊ ɩɖɛ́ɛ Galilée. Ńna gɛ mɩ́ngɔmɔɔnáa yɩ ńŋɩnáa waavʊ́ńdɔḿ mɩ́ɩ nɛ́.”» ");
INSERT INTO kdh_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Aláa bɛḿ baalɩ́ɩ bɔɔlááwʊ-daá na sewɔ́ɔ bɛɖɛ́ɛ bolíni, káma, balaakáarɩ waagʊrʊ́ bɩka bénzelíi, ngʊ́ bedefééri naárʊ natɩ́rɩ, káma, nɩdáárɛ waazʊ́ʊ wɛ.  ");
INSERT INTO kdh_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Aláháɖɩ wɩ́rɛ tɛ́ɛrɛ́ Yeésu weevé ɩlɩ́ɩ ɩsɩɖáa-daá nɛ́, Marɩyáma Magɩdaláa alʊ́ weení ɩrɔ wɔɔɖɔ́ɔ zííniwá lʊbɛ nɛ́ gɛ waaɖáa ɩdɩ lɩzɩ́ɩ ɩwɩ́lɩ. ");
INSERT INTO kdh_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ngɛ ɩlɛ́ wɛɛɖɛ́ɛ ikéveeri tɩ Yeésu-dɛ́ɛ wanbaaráa bɔwɛ lííya na wíídi-daá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Amá, bɛlɛ́ baanɩ́ɩ wɔ́ndɔ́m sɩsɩ Yeésu wɛ weezuú-daá hálɩ waana yɩ nɛ́, badalá yɩ yaraɖá. ");
INSERT INTO kdh_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Bɩlɛ́ bʊwɔ́rɔ́, waalɩzɩ́ ɩdɩ ɩwɩ́lɩ ɩwanbaaráa nɔɔ́lɛ bɛ́nɖɛɛ́ fɔɔ́ nɛ́ yáásɩ́ nakɩ́rɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ngɛ bɛlɛ́ baagábɩ́sɩ befééri tɩ wanbaaráa baaganáa, bɛlɛ́ ɖʊɖɔ badalá wɛ yaraɖá. ");
INSERT INTO kdh_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Bɩlɛ́ bʊwɔ́rɔ́, waalɩzɩ́ ɩdɩ ɩwɩ́lɩ ɩwanbaaráa fuú na naárʊ bɔwɛ bénɖíi kíɖíím nɛ́. Wooyooná wɛ bɛdɛ́ɛ badafa toovonúm nɛ́ na bɛdɛ́ɛ wenbi-ɖóni-rɔ. Káma, weevé ɩlɩ́ɩ ɩsɩɖáa-daá wɔ́rɔ́ nɛ́, badalá wenbá baana yɩ nɛ́ yaraɖá. ");
INSERT INTO kdh_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ngɛ wɔɔdɔ́ wɛ sɩsɩ: «Ibó ɖúúlínya rɩ́ŋa-daá ifééri ɩráa rɩ́ŋa Laabáárʊ Kífeńgi. ");
INSERT INTO kdh_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Weení waava toovonúm ngɛ beelíri yɩ lɩ́m-daá nɛ́, Ɩsɔ́ɔ wɛ́nlɛɛ́ yɩ. Weení ɩdafa toovonúm nɛ́, Ɩsɔ́ɔ wángʊ́ʊ ɩdɔ́m. ");
INSERT INTO kdh_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Maamááciwá wentí wenbá baava ma toovonúm nɛ́ sɩ balá nɛ́ nɖɔ́: na máyɩ́ɖɛ-daá, bɔ́nɖɔwʊ́ʊ zííniwá, bánŋmatɩ́ kʊnʊmɩ́nɩ kɩ́fatɩ, ");
INSERT INTO kdh_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","bɛ́nzɛlɩ́ɩ ɖomáa banʊ́ʊ́zɩ-daá, ngɛ a bɔɔnyɔ́ɔ sɔ́ɔ́dɩ, bɩ́dánlaḿ wɛ nabʊ́rʊ. Bándɩnɩ́ nʊ́ʊ́zɩ kʊdɔndɩnáa-rɔ, bɛlɛ́ bawáa.» ");
INSERT INTO kdh_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ɖádʊ́ʊ Yeésu waaŋmatɩná wɛ bɩtɛ́ nɛ́, ngɛ waagba ɩsɔ́ɔ́dáá ɩcɔ́ɔ Ɩsɔ́ɔ-dɛ́ɛ nʊ́ʊ́nɩ kíɖiiwú-rɔ. ");
INSERT INTO kdh_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Bɩɩga wanbaaráa nɛ́, bɛlɛ́ bɛɛɖɛ́ɛ báa lé bénveerím ɩráa Laabáárʊ Kífeńgi. Ɖádʊ́ʊ wánzɩnáa wɛ badɩmɛ́rɛ-daá bɩka wénÿelíi maamááciwá wánlám tínɖeezi bɛdɛ́ɛ waázu.");
INSERT INTO kdh_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kʊ́bɔnɩ́ Tewofíili, wenbí bɩrɩ́ŋa bɩɩlá ɖɛ́dɛ́ɛ cé nɛ́, ɩráa ɖabata waaŋmáa bɩdɛ́ɛ tɔ́m. ");
INSERT INTO kdh_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Wenbá baana ná tɩ na baazá ɖoo bɩgabaazɩya ngɛ bɛɛgɛ́ɛ́zɩ ɖáa nɛ́, bɛlɛ́ baabɩ́sɩ Ɩsɔ́ɔ-dɛ́ɛ tɔ́m feeriɖáa. Wenbí bɛɛgɛ́ɛ́zɩ nɛ́, bɩlɛ́ nɔ́ɔ́ gɛ ɩráa bɛḿ baaŋmáa. ");
INSERT INTO kdh_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Bɩnáábɩ́lɛ́ mɔ́ɔ́ ɖʊɖɔ mɔ́ɔ́bɔ́ɔ́zɩ bɩbɩ́ɩ madɩlɩ́ wenbí bɩrɩ́ŋa bɩɩlá ɖoo bɩgabaazɩya nɛ́, ngɛ mááná sɩsɩ bɩmɔɔ́na maŋmáa nya nŋɩ́nɩ́ biibó nɛ́, ");
INSERT INTO kdh_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","na ndɩlɩ́ sɩsɩ wentí baawɩ́lɩ nya nɛ́ kɛ́ɛ toovonúm. ");
INSERT INTO kdh_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Sáátɩ wenkí Eróodi wénɖíi kowúrátɩ Yudée laadɔ́ɔ-rɔ nɛ́, Ɩsɔ́ɔ-dɛ́ɛ sarásɩ lanɖʊ́ naárʊ fʊnwɛ, bánÿaá yɩ sɩsɩ Sákarɩ. Sarásɩ lanɖáa-dɛ́ɛ bɔwá-daá, bɔwʊ́ɖɛ wenɖé-daá Abíya kɛ́ɛ kʊjʊ-dʊ́ʊ nɛ́ ɖɩdaá gɛ ɩwɛ, bɩka ɩɖɛɛlʊ́ kɛ́ɛ sarásɩ lanɖʊ́ kʊ́bɔnɩ́ Árʊ́ʊ́na bíya‑bíya-daá alíya, bánÿaá ɩlɛ́ sɩsɩ Elizabɛ́ɛtɩ. ");
INSERT INTO kdh_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sákarɩ ɩmʊ́ na ɩɖɛɛlʊ́, bɛlɛ́ɛ́nɩ́ bɔjɔwʊrɛ sɩɩzɛ́ɛ gɛ Ɩsɔ́ɔ ɩzá-daá, bɩka bovóo Ɖádʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ Mará na wenbí bɩrɩ́ŋa waazɩ́ɩ́zɩ bɩ nɛ́ na toovonúm. ");
INSERT INTO kdh_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Amá, bɛvɛ́yɩ́na bú, káma, Elizabɛ́ɛtɩ kɛ́ɛ kaalʊrʊya, bɩka bɛlɛ́ɛ́nɩ́ báńbá babɩ́ɩ ábɔ́náa. ");
INSERT INTO kdh_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Wɩ́rɛ neɖére gɛ Sákarɩ wɛ wánlám sarɔ́ɔ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá, káma, bɔwʊ́ɖɛ wenɖé ɩwɛ ɖɩdaá nɛ́ gɛ bɩɩdála sɩsɩ ɖɩlá Ɩsɔ́ɔ sarásɩ. ");
INSERT INTO kdh_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Sarásɩ lanɖáa tɔ́rɔ́wɛná ɖɔ́ɔ́ná bɔ́ndɔ́ɔ tɛ́tɛ́ na bana weení sɩ ɩfʊ́ʊ́dɩ tulaarɩ́ nɛ́. Bɩdɛ́ɛ wɩ́rɛ bɔɔdɔ nɛ́, Sákarɩ gɛ bɩɩgba sɩsɩ ɩ́sʊʊ Ɖádʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá ɩfʊ́ʊ́dɩ tulaarɩ́ ɖɩdáarɛ ɖacɩrɩ‑cɩrɩ ńɖɛ-daá. ");
INSERT INTO kdh_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sáátɩ wenkí ɩwɛ wánvʊʊdɩ́ tulaarɩ́ nɛ́, zamɔ́ɔ tuutúúma wɛ ná asʊ kɩ́nzʊlʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ńna gɛ Ɖádʊ́ʊ-dɛ́ɛ malááyɩ́ka naárʊ waaɖʊ ɩlɩ́ɩ Sákarɩ-rɔ ɩgazɩ́ŋɛ́ɛ ná sarásɩ ɖaalanɖɛ́ wenɖé ɖɩrɔ bánvʊʊdɩ́ tulaarɩ́ nɛ́ ɖɩdɛ́ɛ fúu kíɖiiwú-rɔ. ");
INSERT INTO kdh_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sákarɩ waagʊ́sɩ gɛ waana yɩ nɛ́, ɩdaá lɩ́m wɛɛjɛ́, ngɛ nɩdáárɛ kʊ́bɔnbɔńɖɛ waagba yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Amá, malááyɩ́ka wɔɔdɔ́ yɩ sɩsɩ: «Sákarɩ, nkanɩ́ɩ nɩdáárɛ, Ɩsɔ́ɔ waamʊ nyɛ́dɛ́ɛ sʊlʊ́ńdɩ. Nɖɛɛlʊ́ Elizabɛ́ɛtɩ wánlʊrʊ́ʊ nya bú abaalʊ́, na nva yɩ yɩ́ɖɛ sɩsɩ Yaayá. ");
INSERT INTO kdh_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Wɛ́nvɛɛzɩ́ nyéwenbiré bɩlá nya niíni, bɩka ɩráa ɖabata ɩfaarɩná ɩdɛ́ɛ lʊrʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Wɔ́ngɔnɩ́ ɩlá ɩrʊ́ kʊ́bɔnɩ́ Ɩsɔ́ɔ ɩzá-daá; ɩ́dɔ́nnyɔɔ víinyi bíya sʊlʊ́m, cáńfáná sʊlʊ́m ɖóni ńbɩ nabɩ́rɩ, ngɛ Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga wóngozunáa yɩ ɖoo ɩgɔɔ lóódi-daá. ");
INSERT INTO kdh_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Wɔ́ngɔnɩ́ ɩkábɩsɩná Israyɛ́ɛlɩ bíya ɖabata-dɛ́ɛ laakáarɩ Badʊ́ʊ Ɩsɔ́ɔ-rɔ. ");
INSERT INTO kdh_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Wɛ́ndɛ́ɛ yɩ nɩ́bááwʊ; Kezeŋa na yíko Anɖébi Elíya wooyuú kɩ nɛ́ gɛ sɩ iyuú na ɩnyɔ́ɔ́zɩ caanáa na bebíya bɔlɔwʊtáá. Bɩka wenbá bédénzée Ɩsɔ́ɔ nɛ́, babɩ́sɩ áséńsí-dɩnáa ńŋɩnáa ɩráa bɔjɔwʊrɛ sɩɩzɛ́ɛ nɛ́. Bɩlɛ́ gɛ sɩ ɩlá na ɩkpɩ́ɩ́rɩ Ɖádʊ́ʊ Ɩsɔ́ɔ zamɔ́ɔ wenkí kɩɖamáa yɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ngɛ Sákarɩ wɔɔbɔ́ɔ́zɩ malááyɩ́ka sɩsɩ: «Wé gɛ sɩ madɩlɩ́na sɩsɩ bɩgɛ́ɛ toovonúm. Káma, mána mɛɖɛɛlʊ́ ɖáńbɩ́ɩ́ ábɔ́náa.» ");
INSERT INTO kdh_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ngɛ malááyɩ́ka woobúsi yɩ sɩsɩ: «Mɔ́ɔ́ gɛ Jibiríílu, mɔ́wɛ Ɩsɔ́ɔ ɩzá-daá gɛ mánlám yɩ bɔwʊtá. Weegédíri ma gɛ sɩsɩ mɔ́gɔnɩ mevééri nya Laabáárʊ Kífeńgi kɩna. ");
INSERT INTO kdh_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Amá, ńŋɩnáa ńdáfá wentí méévééri nya tɩ nɛ́ toovonúm ngʊ́ tɩwɛ sɩ tɩlá a tɩdɛ́ɛ alɩwáátɩ waadála nɛ́, bʊrɔɔzɩ́, nyánbɩsɩ́ komóomúŋa hálɩ wɩ́rɛ wenɖé bɩdɛ́ɛ yáásɩ́wá sɩ tɩlá nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Bɩdɛ́ɛ sáátɩ kɩḿ nɛ́, zamɔ́ɔ wɛ kɩɖamáa Sákarɩ bɩka kɩ́nlám bítí sɩsɩ weegéleeri ɖɩdáarɛ ɖacɩrɩ‑cɩrɩ ńɖɛ-daá. ");
INSERT INTO kdh_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sáátɩ wenkí waagálɩɩ nɛ́, ɩdabɩ́ɩ́zɩ ɩŋmatɩná wɛ; ńna gɛ bɛlɛ́ baadɩlɩ́ sɩsɩ bɩɩlɩzɩ́ nabʊ́rʊ bɩkáwɩlɩ yɩ ɖɩdáarɛ ɖacɩrɩ‑cɩrɩ ńɖɛ-daá. Níízi gɛ waaŋmatɩná wɛ bɩka ɩwalɩ́ bɩlɛ́ ɩbɩ́sɩ komóomúŋa. ");
INSERT INTO kdh_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sáátɩ wenkí Sákarɩ-dɛ́ɛ sarásɩ lám-dɛ́ɛ wɛ́-bíya wɛɛdɛ́ nɛ́, ngɛ wɔɔlɔ́ɔ ɩbɩ́sɩ ikpé ɩdɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Bɩɩgɔ́nɩ bɩlá wɛ́ náálɛ nɛ́, ɩɖɛɛlʊ́ Elizabɛ́ɛtɩ wɛɛyɛ́ɛ fuwá, ngɛ ɩlɛ́ wɔɔjɔ́ɔ ɖaána hálɩ irodunáa nɔɔ́nʊ́wá ɩdalɩ́ɩ asʊ. Bɩdɛ́ɛ sáátɩ kɩḿ nɛ́ ɩwɛ wɔ́ndɔ́m ɩdɩ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Wenbí Ɖádʊ́ʊ Ɩsɔ́ɔ waalá ma nɛ́ nbɩlɛ́; alɩwáátɩ wenkí bɩɩmɔ́ɔ yɩ nɛ́, weewíi mɔ́rɔ́ ɩlɩzɩ́ ma fɛɛrɛ́ ɩráa-daá.» ");
INSERT INTO kdh_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabɛ́ɛtɩ-dɛ́ɛ fuwá-dɛ́ɛ irodúu loɖo ńnɩ́-daá gɛ Ɖádʊ́ʊ Ɩsɔ́ɔ weegédíri malááyɩ́ka Jibiríílu Nazarɛ́ɛtɩ tɛ́ɛ́dɩ tɩwɛ Galilée laadɔ́ɔ-rɔ nɛ́ tɩdaá. ");
INSERT INTO kdh_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Weegédíri yɩ bú aléeré naárʊ ɩdatɩlɩ́ ta abaalʊ́ nɛ́ ɩjɔ́. Bú aléeré ɩmʊ́, wúro Ɖáwʊɖa-dɛ́ɛ ɖugoré-daá ɩrʊ́ bánÿaá yɩ sɩsɩ Ísifu nɛ́ gɛ baava yɩ, ɩdɛ́ɛ yɩ́ɖɛ gɛ Marɩyáma. ");
INSERT INTO kdh_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Malááyɩ́ka waazʊ́ʊ ɩjɔ́ ɩtɔ́ yɩ sɩsɩ: «Mɛ́ɛ́zɛ́ɛ nya. Nyóóyúú kʊjʊʊ́ niíni Ɖádʊ́ʊ Ɩsɔ́ɔ-jɔ́, Ɖádʊ́ʊ Ɩsɔ́ɔ sɩ́ŋɛ́ɛ nyɔ́wɔ́rɔ́.» ");
INSERT INTO kdh_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Marɩyáma waanɩ́ɩ tɔ́m bíya bɛḿ nɛ́, ngɛ waazʊ́ʊ bítí, ngɛ wɔ́nbɔɔzɩ́ ɩdɩ sɩsɩ: «Sɛ́ɛ́dɩ tɩna tugutoluú gɛ sɩsɩ wé.» ");
INSERT INTO kdh_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ńna gɛ malááyɩ́ka wɔɔdɔ́ yɩ sɩsɩ: «Nkanɩ́ɩ nɩdáárɛ, Marɩyáma, nyóóyúú kʊjʊʊ́ niíni Ɩsɔ́ɔ-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Bɛɛ́ɛ, nyɛ́nÿɛɛ́ fuwá nlʊ́rʊ bú abaalʊ́, na nva yɩ yɩ́ɖɛ sɩsɩ Yeésu. ");
INSERT INTO kdh_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Wɔ́ngɔnɩ́ ɩbɩ́sɩ ɩrʊ́ kʊ́bɔnɩ́, bɩka bayáa yɩ sɩsɩ Ɩsɔ́ɔ bílí-bílí-dʊ́ʊ Biyaalʊ́. Ɖádʊ́ʊ Ɩsɔ́ɔ wánzɩɩ́ yɩ ɩjaájaa wúro Ɖáwʊɖa-dɛ́ɛ kowuro-gbelé-rɔ. ");
INSERT INTO kdh_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Wénɖíi kowúrɔ́ɔ kɛvɛ́yɩ́na tɛ́m nɛ́ Yaakúbu-dɛ́ɛ ɖaána-rɔ ngɛ ɩdɛ́ɛ kowúrɔ́ɔ fɛ́yɩ́na kánzɩɩ́ tɩ́ŋa kɛtɛngɛrɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ngɛ Marɩyáma wɔɔdɔ́ malááyɩ́ka sɩsɩ: «Tɔ́ɔ, nɛ́, nŋɩ́nɩ́ gɛ bɩ́nbɩɩzɩ́ bɩlá bɩlɛ́. Káma, máásɩ abaalʊ́.» ");
INSERT INTO kdh_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ngɛ malááyɩ́ka woobúsi yɩ sɩsɩ: «Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga wɔ́ngɔnɩ́ nyɔ́rɔ́, na Ɩsɔ́ɔ bílí‑bílí-dʊ́ʊ iyéle ɩdɛ́ɛ yíko ɩbála kifu nyɔ́rɔ́ nyazɩ izotuu. Bɩlɛ́ bʊrɔ gɛ bú weení sɩ nlʊ́rʊ yɩ nɛ́ kɛ́ɛ ɖacɩrɩ‑cɩrɩ ɩrʊ́, sɩ bayáa yɩ gɛ sɩsɩ Ɩsɔ́ɔ Biyaalʊ́. ");
INSERT INTO kdh_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Hálɩ bɛɛ́ɛ, ngoobú Elizabɛ́ɛtɩ ɖʊɖɔ yɛ́ɛ́na fuwá sɩ ɩlʊ́rʊ bú abaalʊ́ ɩdɛ́ɛ ábɔńdɩ-daá. Ɩdɛ́ɛ irodúu loɖo ńnɩ́-daá gɛ ɩwɛ ɖɔ́, ɩmʊ́ weení bánvʊnÿaá yɩ sɩsɩ kaalʊrʊya nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Káma, nabʊ́rʊ fɛ́yɩ́ Ɩsɔ́ɔ tánbɩɩzɩ ɩlá nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ngɛ Marɩyáma woobúsi yɩ sɩsɩ: «Ɖádʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ bɔwʊtá-dʊ́ʊ gɛ mɛ́gɛ́ɛ, bɩ́la ma ńŋɩnáa nyɔ́ɔ́dɔ́ nɛ́.» Ngɛ malááyɩ́ka wɛɛɖɛ́ɛ iyéle yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Wɛ́ amʊ́ adaá nɛ́, Marɩyáma waagʊrʊ́ ɩkpɔ́ɔ nɩ́bááwʊ itoózi ɩɖɛ́ɛ bʊ́ʊ́nɩ fáráńdɩ́ Yudée laadɔ́ɔ-dɛ́ɛ tɛ́ɛ́dɩ natɩ́rɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Waadála nɛ́, waazʊ́ʊ Sákarɩ-dɛ́ɛ ɖaána, ngɛ wɛɛzɛ́ɛ Elizabɛ́ɛtɩ. ");
INSERT INTO kdh_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Sáátɩ wenkí Elizabɛ́ɛtɩ waanɩ́ɩ Marɩyáma-dɛ́ɛ sɛ́ɛ́dɩ nɛ́, bú waalʊwɔ́ɔ ilóódi-daá. Ngɛ Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga woozuná Elizabɛ́ɛtɩ. ");
INSERT INTO kdh_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ńna gɛ woogóo na ɖóni ɩtɔ́ sɩsɩ: «Ɩsɔ́ɔ waaɖʊ nya alɩbáráka aláa-daá, ɩɖʊ bú weení nyɛ́yɛ́ɛ́na ivuwá nɛ́ ɖʊɖɔ alɩbáráka. ");
INSERT INTO kdh_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kʊjʊʊ́ niíni wenkí gɛ móóyúú bɩlɛ́ ngɛ hálɩ Mádʊ́ʊ ɩgɔɔ wɔɔgɔ́nɩ mɔ́jɔ́. ");
INSERT INTO kdh_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Káma, bɛɛ́ɛ, sáátɩ wenkí máánɩ́ɩ nyɛ́zɛ́ɛ́dɩ nɛ́, bú waalʊwɔ́ɔ na avaara mádáá. ");
INSERT INTO kdh_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Wenbi‑niíni-dʊ́ʊ gɛ nyɛ́gɛ́ɛ, káma, nyáává toovonúm sɩsɩ wentí Ɖádʊ́ʊ Ɩsɔ́ɔ weegédíri befééri nya nɛ́ tɩ́nlám.» ");
INSERT INTO kdh_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Waaŋmátɩ bɩlɛ́ nɛ́, ngɛ Marɩyáma wɔɔjɔ yɩ sɩsɩ: «Mɔ́nɖɔɔzɩ́ Mádʊ́ʊ Ɩsɔ́ɔ! ");
INSERT INTO kdh_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Bɩɩbá bɩjɔɔ́ɔ ma niíni ɖabata Ɩsɔ́ɔ Mɛ́lɛ́ɛ́rʊ́-rɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Káma, waabɩsɩná ɩlaakáarɩ mɔ́ɔ́ ɩdɛ́ɛ bɔwʊtá-dʊ́ʊ mɔ́rɔ́, mɔ́ɔ́ weení mɛ́dɛkɛ́ɛ nabʊ́rʊ nɛ́. Ɩɩ́n, kpɔɔ lɛlɛɛɖɔ́ hálɩ nbó bíya-bíya-jɔ́ nɛ́, sɩ bayáa ma gɛ sɩsɩ wenbi‑niíni-dʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Káma, Ɖóni-rɩ́ŋa-dʊ́ʊ waalá ma wenbí nɛ́, bɩɩbá bɩɖɔ́ɔ. Ɖacɩrɩ‑cɩrɩ-dʊ́ʊ gɛ ɩgɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Wánnɩɩ́ wenbá bɛ́nnyɛ́m yɩ nɛ́ bagʊnyɔmɩ́nɩ báa ngbeére. ");
INSERT INTO kdh_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Waawɩ́lɩ ɩdɛ́ɛ ɖóni rɩ́ŋa ɩɖɔ́ɔ wenbá bángbaazɩ́ badɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Wɛɛvɛdɩ́ ɖóni-dɩnáa bɛdɛ́ɛ kowuro-gbelásɩ-rɔ, bɩka ɩkpáázɩ wenbá baavʊ́ʊ́zɩ badɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Waava nyɔɔ-dɩnáa ɖɔ́ɔ́lɛ kʊ́bɔńɖɛ, bɩka ɩɖɔ́ɔ liideé-dɩnáa bɛɖɛ́ɛ banʊ́ʊ́zɩ riké. ");
INSERT INTO kdh_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Wɔɔdɔ́ɔ́zɩ ɩdɛ́ɛ kʊnyɔnnɩɩrɛ́-rɔɔzɩ́, ngɛ wɔɔɖɔ́kɩ Israyɛ́ɛlɩ ɩzamɔ́ɔ kɩ́nlám yɩ bɔwʊtá nɛ́, ");
INSERT INTO kdh_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ńŋɩnáa wenbí waavʊ́ńɖuuná ɖájaájaanáa sɩsɩ wánbanáa Ibrahím na ibíya-bíya ɩlá bʊrɔ báa ngbeére hálɩ bɩ́dɛ́ndɛŋ́ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Marɩyáma wɔɔjɔ́ɔ Elizabɛ́ɛtɩ-jɔ́ nyazɩ irodunáa noódoozo bɩlɛ́ naanɩ́ ɩlɔ́ɔ ɩbɩ́sɩ ɩdɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Sáátɩ wenkí Elizabɛ́ɛtɩ-dɛ́ɛ lʊrʊ́ʊ waadála nɛ́, waalʊ́rʊ bú abaalʊ́. ");
INSERT INTO kdh_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Igoobíya na ɩdɛ́ɛ fáráńdɩ́-daá ńba waanɩ́ɩ bɩlɛ́ sɩsɩ Ɖádʊ́ʊ Ɩsɔ́ɔ waabá ɩnɩ́ɩ ɩgʊnyɔḿ nɛ́, bɩɩlá wɛ niíni bána yɩ bánvaarɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Bú waalá wɛ́ lutoozo sɩ bɛbɛlɩ́ yɩ nɛ́, ngɛ bɔɔgɔ́nɩ. Bɔɔzɔ́ɔ́lɩ sɩsɩ bafa yɩ yɩ́ɖɛ sɩsɩ Sákarɩ, ńŋɩnáa bánÿaá ɩjaa nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Amá, kɔɔ́wʊ wɔɔjɔ wɛ sɩsɩ: «Aayɩ́, sɩ bayáa yɩ gɛ sɩsɩ Yaayá.» ");
INSERT INTO kdh_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ńna gɛ bɛlɛ́ boobúsi yɩ sɩsɩ: «Naárʊ fɛ́yɩ́ nyɛ́dɛ́ɛ koobíre-daá bánÿaá yɩ bɩlɛ́!» ");
INSERT INTO kdh_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ngɛ baavaná caáwʊ ɩzá bɔ́nbɔɔzɩnáa yɩ na níízi na batɩlɩ́ sɩsɩ wé gɛ ɩzɔɔlɛ́ɛ bayáa bú. ");
INSERT INTO kdh_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ńna gɛ wɔɔbɔ́ɔ́zɩ becéle yɩ kpálɩfɔ́ɔ, ngɛ waaŋmáa kɔrɔ sɩsɩ: «Ɩdɛ́ɛ yɩ́ɖɛ gɛ Yaayá.» Ngɛ bɩɩlá barɩ́ŋa bítí. ");
INSERT INTO kdh_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nɔɔ́ kʊ́ɖʊḿ nɛ́, wanzʊlʊmʊ́ʊ woobóɖi ɩbáázɩ ŋmatɩrɛ wánzám Ɩsɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ńna gɛ bɩɩlá fáráńdɩ́-daá ńba rɩ́ŋa nɩdáárɛ, bɩka Yudée laadɔ́ɔ-dɛ́ɛ tɛ́ɛ́dɩwá tɩwɛ bʊ́ʊ́nɩ-daá nɛ́ tɩdaá ɩráa wɛ́ngɛɛzɩ́ wenbí bɩrɩ́ŋa bɩɩlá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ngɛ wenbá barɩ́ŋa bánnɩɩ́ tɩ nɛ́ bánmaazɩ́ tɩrɔ bɩka bɔ́nbɔɔzɩ́ badɩ sɩsɩ: «We gɛ bú ceení sɩ ɩkɔ́nɩ ɩbɩ́sɩ bɩlɛ́.» Káma, Ɖádʊ́ʊ Ɩsɔ́ɔ sɩ́ŋɛ́ɛ ɩwɔ́rɔ́ gɛ na toovonúm. ");
INSERT INTO kdh_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga woozuná bú ɩjaa Sákarɩ, ngɛ waabáázɩ ŋmatɩrɛ na Ɩsɔ́ɔ nɔɔ́ wɔ́ndɔ́m sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Sám mɔɔ́na Ɖádʊ́ʊ, Israyɛ́ɛlɩ-dɛ́ɛ Ɩsɔ́ɔ, káma, waagábɩ́sɩ́ná ɩlaakáarɩ ɩzamɔ́ɔ-rɔ ɩlɛ́ɛ kɩ. ");
INSERT INTO kdh_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Weegédíri ɖáa Lɛɛrʊ́ yíko-dʊ́ʊ ɩdɛ́ɛ bɔwʊtá-dʊ́ʊ wúro Ɖáwʊɖa-dɛ́ɛ kutoluú-dɛ bíya-daá. ");
INSERT INTO kdh_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Bɩlɛ́ gɛ waavʊ́ńbaná ɩdɛ́ɛ anɖébiwá ɖacɩrɩ‑cɩrɩ ńba ɖoo nɛ́ ɩŋmátɩ. ");
INSERT INTO kdh_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Waabaná wɛ ɩŋmátɩ sɩsɩ wɛ́nlɛɛ́ ɖáa ɖábáɖaanáa ndɛ́, bɩka ɩlɩzɩ́ ɖáa wenbá bádánjaa ɖɛ́dɛ́ɛ kazɔ́ɔ nɛ́ banʊ́ʊ́zɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Bɩlɛ́ gɛ waalá ɩwɩ́lɩ ɖájaájaanáa ɩdɛ́ɛ kʊnyɔnnɩɩrɛ́, bɩka ɩtɔ́ɔ́zɩ ɩdɛ́ɛ keɖiyá ɖacɩrɩ‑cɩrɩ ńga-rɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Wɔɔdɔ́ɔ́zɩ wentí waavʊ́ńɖuuná ɖájaájaa Ibrahím nɛ́ bʊrɔ. ");
INSERT INTO kdh_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Tɩlɛ́ gɛ sɩsɩ ɩmʊ́ wánlɩzɩ́ɩ ɖáa ɖábáɖaanáa nʊ́ʊ́zɩ-daá, na iyéle ɖɩlá yɩ bɔwʊtá nɩdáárɛ fɛ́yɩ́, ");
INSERT INTO kdh_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","bɩka ɖɩbɩ́sɩ ɩráa ɖacɩrɩ‑cɩrɩ ńba na wenbá bɔjɔwʊrɛ sɩɩzɛ́ɛ ɩmʊ́ waazá-daá ɖéweezuú rɩ́ŋa-daá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Bɩɩga nyɔ́ɔ́ móbú nɛ́, sɩ bɔkɔ́nɩ gɛ bayáa nya sɩsɩ Ɩsɔ́ɔ bílí‑bílí-dʊ́ʊ-dɛ́ɛ anɖébi. Káma, nyɛ́ndɛ́ɛ Ɖádʊ́ʊ nɩ́bááwʊ ngbɩ́ɩ́rɩ ɩnɩ́báánɩ, ");
INSERT INTO kdh_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","bɩka nÿéle ɩdɛ́ɛ zamɔ́ɔ ɩtɩlɩ́ sɩsɩ Ɩsɔ́ɔ wɔ́ngɔnɩ́ sɩ ɩlɛ́ɛ kɩ, ngɛ na kɩdɛ́ɛ alaháácɩ́wá cɛ́m gɛ sɩ ɩlɛɛná kɩ. ");
INSERT INTO kdh_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ɩsɔ́ɔ-dɛ́ɛ kʊnyɔnnɩɩrɛ́ kʊ́bɔńɖɛ wánlʊrʊ́ʊ wenbí nɛ́ nbɩlɛ́. Kɩdɩɩná gɛ weeyéle ɩsɔ́ɔ́dáá ɖɛnyɛm ikédi ɖɔ́rɔ́ ńŋɩnáa wɩ́sɩ wángayáa nɛ́, ");
INSERT INTO kdh_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","na ɖɛnyɛm kɩḿ kɩna wenbá bɔwɛ temenuú na sɩ́m nɩ́bááwʊ-daá nɛ́, bɩka kikéti ɖáa ɖɩnʊ́ŋ fɛɛzɩrɛ-dɛ́ɛ nɩ́bááwʊ-daá.» ");
INSERT INTO kdh_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Bú ɩlɛ́ ɩwɛ ɩbamáa bɩɩ́, bɩka ɩdɛ́ɛ áséńsí bamáa ɖɔɔmɩ́nɩ Ɩsɔ́ɔ-dɛ́ɛ nɩ́bááwʊ-daá. Fáráńdɩ́wá lé ɩráa fɛ́yɩ́ nɛ́ tɩdaá gɛ wɔ́njɔwʊ́ʊ hálɩ bɩkɔ́nɩ bɩtála ɩlɩzɩ́ ɩdɩ ɩwɩ́lɩ Israyɛ́ɛlɩ zamɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Bɩdɛ́ɛ sáátɩ kɩḿ, Róóma wúro kʊ́bɔnɩ́ Ogúsuto waava wɛ́ɖɛ sɩsɩ bákala ɩráa bɔwɛ laadásɩ wensí sɩrɩ́ŋa wénɖíi kʊ́bɔńdɩ sɩrɔ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kaɖaa-dɛ́ɛ nbɩlɛ́ bángalɩ́ɩ ɩráa ńŋɩnáa bɩlɛ́ nɛ́. Bɩdɛ́ɛ sáátɩ kɩḿ nɛ́, Kiriniwúusi kɛ́ɛ na Siríi laadɔ́ɔ-rɔ bɛɛŋɩrʊ́. ");
INSERT INTO kdh_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Báa weení wɛ́nɖɛɛ́ ɩdɛɛvʊ́lɔɔ́-daá gɛ bakáŋmáa ɩyɩ́ɖɛ. ");
INSERT INTO kdh_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Bɩnáábɩ́lɛ́ Ísifu ɖʊɖɔ waagʊrʊ́ Nazarɛ́ɛtɩ, tɛ́ɛ́dɩ tɩwɛ Galilée laadɔ́ɔ-rɔ nɛ́ tɩdaá ɩkpa Yudée laadɔ́ɔ-daá, wúro Ɖáwʊɖa-dɛ́ɛ tɛ́ɛ́dɩ bánÿaá tɩ sɩsɩ Bɛtɩlɛhɛ́ɛm nɛ́ tɩdaá, káma, igutoluú kɛgɛ́ɛ wúro Ɖáwʊɖa-dɛ́ɛ ɖugoré gɛ. ");
INSERT INTO kdh_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Woobó ɩ́na ɩdɛ́ɛ ábɔɔzɔɔ́ Marɩyáma sɩsɩ bakáŋmáa bayɩrá. Bɩdɛ́ɛ sáátɩ, Marɩyáma na fuwá. ");
INSERT INTO kdh_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Bɔwɛ Bɛtɩlɛhɛ́ɛm ńna gɛ Marɩyáma-dɛ́ɛ lʊrʊ́ʊ waadála. ");
INSERT INTO kdh_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ngɛ waalʊ́rʊ ɩdɛ́ɛ aléebú, bú abaalʊ́. Waamɩlɩná yɩ ɖidéére, bɩka ɩkpɔ́ɔ yɩ ɩfɩ́ɩ́zɩ fʊ́ńdɩ kpɩná kíɖíím ɖaaɖʊ́ʊ́ɖɛ-daá. Káma, bodoyuú ɖɩdáarɛ ɩgɔma ɖaazʊʊɖɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ketiráa nɛbɛ́rɛ wɛ fásɩ sɩwɛ fáráńdɩ́wá tɩḿ tɩdaá nɛ́ bénveríi bavʊ́ńdɩ kpɩná-rɔ nuvoowú. ");
INSERT INTO kdh_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ɖádʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ malááyɩ́ka waaɖʊ ɩlɩ́ɩ bɔrɔ, ngɛ Ɖádʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ ásícé-dɛ́ɛ ɖɛnyɛm waalára kɩmɩlɩná wɛ́, ngɛ bɩɩbá bɩlá wɛ nɩdáárɛ. ");
INSERT INTO kdh_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ńna gɛ malááyɩ́ka wɔɔdɔ́ wɛ sɩsɩ: «Nɩdáárɛ ɩ́kalá mɩ́ɩ, káma, mɔ́ɔ́gɔ́ná mɩ́ɩ Laabáárʊ Kífeńgi kɩ́ngɔnáa zamɔ́ɔ rɩ́ŋa wenbi‑niíni kʊ́bɔńbɩ nɛ́ gɛ. ");
INSERT INTO kdh_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Sinje baalʊ́rʊ mɩ́ɩ Lɛɛrʊ́ wúro Ɖáwʊɖa-dɛ́ɛ tɛ́ɛ́dɩ-daá, ɩnáábɩ́lɛ́ Krísto Ɖádʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ngɛ wenbí sɩ ɩtɩlɩ́ na yɩ nɛ́ nɖɔ́: mɩ́nnáa bú áfʊ́lʊḿ baamɩlɩná yɩ ɖidéére bɩka bafɩ́ɩ́zɩ yɩ fʊ́ńdɩ kpɩná kíɖíím ɖaaɖʊ́ʊ́ɖɛ-daá.» ");
INSERT INTO kdh_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ngɛ malááyɩ́kawá tuutúúma waaɖʊ balɩ́ɩ nɔɔ́ kʊ́ɖʊḿ batasɩná malááyɩ́ka lí ńnɩ́ béndéédi yéńdi bánzám Ɩsɔ́ɔ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Bása Ɩsɔ́ɔ weení ɩwɛ bílí‑bílí nɛ́, bɩka fɛɛzɩrɛ ɩcɔɔ ná wenbá ɩzɔɔlɛ́ɛ wɛ nɛ́ adɛ laadɔ́ɔ-rɔ.» ");
INSERT INTO kdh_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Sáátɩ wenkí malááyɩ́kawá waagʊrʊ́ babɩ́sɩ ɩsɔ́ɔ́dáá nɛ́, ngɛ ketiráa wɔɔdɔ́ ɖamá sɩsɩ: «Bɩlɛ́ nɛ́ ɖíbo Bɛtɩlɛhɛ́ɛm, ɖɩkáná wenbí bɩɩlá gɛ Ɖádʊ́ʊ Ɩsɔ́ɔ wɔɔzɔ́ɔ́lɩ sɩsɩ ɖɩ́tɩ́lɩ́ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ngɛ boodoózi bobó ńna. Baadála nɛ́, bɔɔmɔɔná Marɩyáma na Ísifu na bú áfʊ́lʊḿ ɩlɛ́ ɩvɩ́nɛ́ɛ fʊ́ńdɩ kpɩná kíɖíím ɖaaɖʊ́ʊ́ɖɛ-daá. ");
INSERT INTO kdh_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Baana yɩ nɛ́, ngɛ baadɩ́ wentí tɩrɩ́ŋa beevééri wɛ bú ɩmʊ́ ɩrɔ nɛ́ befééri wɛ. ");
INSERT INTO kdh_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bɩɩlá wenbá barɩ́ŋa bénwelesí fééni ketiráa nɛ́ bítí wentí bándɩ́m nɛ́ tɩrɔ. ");
INSERT INTO kdh_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Bɩka Marɩyáma ɩlɛ́ ɩɖɔ́kɩná tɔ́m tɩḿ tɩrɩ́ŋa iwenbiré-daá wánmaazɩ́ tɩrɔ. ");
INSERT INTO kdh_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ngɛ fʊ́ńdɩ kpɩná ketiráa wɔɔlɔ́ɔ babɩ́sɩ bekpé bɛdɛ́ɛ, bɩka bɔ́nɖɔɔzɩ́ Ɩsɔ́ɔ bánzám yɩ wentí tɩrɩ́ŋa baanɩ́ɩ na baana nɛ́ tɩrɔɔzɩ́, ńŋɩnáa wenbí nɔ́ɔ́ malááyɩ́ka waavʊ́ńgéveeri wɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Biizúlu wɛ́ lutoozo sɩ bɛbɛlɩ́ bú nɛ́, ngɛ baava yɩ yɩ́ɖɛ sɩsɩ Yeésu, ńŋɩnáa malááyɩ́ka waavʊ́ńdɔḿ sɩsɩ báyaa yɩ naanɩ́ bɛyɛ́ɛ ivuwá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Bɩlɛ́ bʊwɔ́rɔ́ nɛ́, wɩ́rɛ wenɖé Múúsá-dɛ́ɛ Mará waazɩ́ɩ́zɩ sɩsɩ bú ɩgɔɔ na ɩjaa bála badɩ ɖacɩrɩ‑cɩrɩ nɛ́ ɖɩɩdála nɛ́, Ísifu na Marɩyáma booboná Yeésu Yerusalɛ́ɛm Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá sɩ bakáwɩlɩ yɩ Ɖádʊ́ʊ Ɩsɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Káma, baaŋmáa Ɖádʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ Mará tákaraɖá-daá sɩsɩ: «Bú abaalʊ́ kaɖaa ńnɩ́ báa weení, Ɖádʊ́ʊ Ɩsɔ́ɔ tɩɩná yɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Bibaasí nɛ́, bɔwɛná sɩ balá sarɔ́ɔ wenká Mará amʊ́ aazɩ́ɩ́zɩ sɩsɩ bála nɛ́, kɛlɛ́ gɛ avówa kʊ́fʊlʊmá náálɛ, yáá avówa báa weená-dɛ́ɛ kúmuwé náálɛ. ");
INSERT INTO kdh_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Bɩdɛ́ɛ sáátɩ kɩḿ nɛ́, abaalʊ́ naárʊ wɛ Yerusalɛ́ɛm bánÿaá yɩ sɩsɩ Simeyɔ́ɔnɩ. Ɩrʊ́ ɩmʊ ɩgɛ́ɛ ɩrʊ́ weení ɩjɔwʊrɛ sɩɩzɛ́ɛ nɛ́ gɛ, bɩka ɩbá wénzewɔ́ɔ Ɩsɔ́ɔ. Ɩɖamáa weení sɩ ɩkɔ́nɩ ɩlɛ́ɛ Israyɛ́ɛlɩ nɛ́, bɩka Ɩsɔ́ɔ-dɛ́ɛ Kezeŋa wɛ ɩrɔ. ");
INSERT INTO kdh_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Simeyɔ́ɔnɩ ɩmʊ́ nɛ́, Ɩsɔ́ɔ-dɛ́ɛ Kezeŋa waavʊ́ńveeri yɩ sɩsɩ wánnáa Lɛɛrʊ́ weení Ɖádʊ́ʊ Ɩsɔ́ɔ sɩ ikédiri yɩ nɛ́ naanɩ́ ɩsɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Bɩdɛ́ɛ sáátɩ kɩḿ gɛ Ɩsɔ́ɔ-dɛ́ɛ Kezeŋa wooboná yɩ ibó Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá. Sáátɩ wenkí Yeésu ɩgɔɔ na ɩjaa bɔɔgɔná yɩ sɩ balá yɩ wenbí Mará-daá, baaɖʊ sɩsɩ bála nɛ́, ");
INSERT INTO kdh_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeyɔ́ɔnɩ waamʊ yɩ ɩkpɛ́kɩ ɩnʊ́ʊ́zɩ-daá ɩsá Ɩsɔ́ɔ wɔ́ndɔ́m sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Lɛlɛɛɖɔ́ nɛ́ Ɖádʊ́ʊ, nyánbɩɩzɩ́ nÿéle mɔ́ɔ́ nyɛ́dɛ́ɛ bɔwʊtá-dʊ́ʊ mazɩ́ fɛɛzɩrɛ-daá ńŋɩnáa nyɔ́ɔ́dɔ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Káma, mádɩtɩŋa mááná nyɛ́dɛ́ɛ lɛ́ɛ́dɩ na máázá. ");
INSERT INTO kdh_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Lɛ́ɛ́dɩ wentí nyáágbɩ́ɩ́rɩ tɩ nzɩ́ɩ yíriwá rɩ́ŋa nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Tɩgɛ́ɛ na ɖɛnyɛm wenkí sɩ kiyéle na ɖúúlínya-daá yíriwá rɩ́ŋa ɩtɩlɩ́ nya nɛ́. Kɩ́nɖɔɔzɩ kʊ nyɛ́dɛ́ɛ zamɔ́ɔ Israyɛ́ɛlɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Wentí Simeyɔ́ɔnɩ wánŋmatɩ́ Yeésu-rɔ nɛ́ waalá Yeésu ɩgɔɔ na ɩjaa bítí. ");
INSERT INTO kdh_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeyɔ́ɔnɩ waaɖʊ wɛ alɩbáráka, ngɛ wɔɔdɔ́ bú ɩgɔɔ Marɩyáma sɩsɩ: «Bɛɛ́ɛ, bú ceení-rɔɔzɩ́, Israyɛ́ɛlɩ-daá ɩráa ɖabata wánzalɩ́ɩ, bɩka nɛbɛ́rɛ ɩkʊrʊ́. Wánbɩsɩ́ Ɩsɔ́ɔ-dɛ́ɛ seríya, amá, ɩráa wéngizíi yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Bɩlɛ́ gɛ sɩ bɩlá na ɩráa ɖabata-dɛ́ɛ lomaazɛ́ amʊ́sɛ́ɛ bewenbé-daá nɛ́ ɩlɩ́ɩ bayáána. Bɩɩga nyɔ́ɔ́ nyádɩtɩŋa nɛ́, nyánba nÿɛlɛ́m nyazɩ bɔɔzɔ́ nya tókobí bɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Alʊ́ anɖébi naárʊ fʊnwɛ ńna ɖʊɖɔ, bánÿaá yɩ sɩsɩ Áanɩ. Fanʊwɛ́ɛlɩ wɛɛlɛ́ɛ nbɩlɛ́, bɩka Fanʊwɛ́ɛlɩ ɩlɛ́ ɩdɛ́ɛ gɛ Azɛ́ɛrɩ-dɛ́ɛ ɖugoré-daá. Áanɩ ɩmʊ́ wáńbá ɩbɩ́ɩ páá; bɩ́ɩ́zɩ lʊbɛ gɛ wɔɔjɔ́ɔ abaaladɔ́ɔ-rɔ ");
INSERT INTO kdh_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","naanɩ́ ɩbɩ́sɩ leelú. Wáńdálɩ́ bɩ́ɩ́zɩ nɩɩ́náázá na nasɩ́náázá. Ɩ́dɛ́njɛḿ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá, ɩwɛ ńna gɛ nuvoowú na ɩdaawʊ́ wánlám yɩ bɔwʊtá, wɛ́nzɛɛ́ yɩ bɩka wɔ́nvɔkɩ́ nɔɔ́. ");
INSERT INTO kdh_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Bɩdɛ́ɛ sáátɩ kɩḿ ɖʊɖɔ nɛ́, alʊ́ ɩmʊ́ waajáŋ ɩtála, ngɛ waabáázɩ Ɩsɔ́ɔ sám bɩka wénveerím wenbá barɩ́ŋa baɖamáa Yerusalɛ́ɛm-dɛ́ɛ lɛ́ɛ́dɩ nɛ́ bú ɩmʊ́ ɩdɛ́ɛ tɔ́m. ");
INSERT INTO kdh_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Sáátɩ wenkí Yeésu ɩgɔɔ na ɩjaa baalá wenbí bɩrɩ́ŋa Ɖádʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ Mará waazɩ́ɩ́zɩ sɩsɩ bála nɛ́, bána yɩ bɔɔlɔ́ɔ babɩ́sɩ Nazarɛ́ɛtɩ bɛdɛ́ɛ́dɩ-daá, Galilée laadɔ́ɔ-rɔ. ");
INSERT INTO kdh_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Bɩɩga bú nɛ́, ɩlɛ́ ɩwɛ ɩbamáa bɩɩ́, tɔnʊʊ́ wángbáa ɖóni, áséńsí bamáa yɩ ɖɔɔmɩ́nɩ bɩka Ɩsɔ́ɔ sɩ́ŋɛ́ɛ ɩwɔ́rɔ́. ");
INSERT INTO kdh_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Báa bɩ́nɩ weení, Yeésu ɩgɔɔ na ɩjaa bɛ́ndɛ́rɛ́ɖɛ́ɛ Yerusalɛ́ɛm Fɛlɛ nɖɛ́ɛ-dɛ́ɛ jíńgáárɩ́ ɖíi. ");
INSERT INTO kdh_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Sáátɩ wenkí wooyuú bɩ́ɩ́zɩ fuú na nasɩ́lɛ nɛ́, bána yɩ bɛɛɖɛ́ɛ ńŋɩnáa bɩgɛ́ɛ bɛdɛ́ɛ jíńgáárɩ́-dɛ́ɛ ɖɔ́ɔ́ná nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Beeɖi jíńgáárɩ́ bɩtɛ́ nɛ́, baabɩ́sɩ bekpé. Amá, Yeésuyɔ́ɔ waawalɩ́ Yerusalɛ́ɛm bɩka ɩgɔɔ na ɩjaa badatɩlɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bɔjɔɔ́ɔ sɩsɩ ɩwɛ bogoobíya bána wɛ bɔgɔwɛ nɩ́bááwʊ-daá nɛ́ bɔlɔwʊtáá, ngɛ baanʊ́ŋ hálɩ wɩ́rɛ ɖebilibili. Bɩlɛ́ bʊwɔ́rɔ́ gɛ baabáázɩ yɩ cáádɩ bogoobíya na bɔɖɔndɩnáa lɔwʊtáá, ");
INSERT INTO kdh_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","amá, badana yɩ. Ngɛ bɔɔlɔ́ɔ babɩ́sɩ Yerusalɛ́ɛm babamáa yɩ cáádɩ. ");
INSERT INTO kdh_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Wɛ́ náádoozo wɩ́rɛ gɛ baana yɩ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá. Ɩjɔɔ́ɔ Mará wɩlɩɖáa lɔwʊtáá wénwelesí wɛ, bɩka wɔ́nbɔɔzɩ́ wɛ tɔ́m. ");
INSERT INTO kdh_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ɩdɛ́ɛ tɩlɩ́ɩ na wentí wónbusí nɛ́ waabá bɩjɔɔ́ɔ wenbá bénwelesí yɩ nɛ́ bítí. ");
INSERT INTO kdh_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ɩgɔɔ na ɩjaa baana yɩ nɛ́, bɩɩbá bɩlá wɛ bítí. Ńna gɛ ɩgɔɔ wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Móbú, ngbaalá gɛ nyáálá ɖáa bɩlɛ́. Bɛɛ mána njaa ɖálaakáarɩ wáńgʊ́rʊ́ nyɛ́dɛ́ɛ cáádɩ-daá.» ");
INSERT INTO kdh_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Ngbaalá gɛ mɩ́njáádɩ ma. Mɩ́ɩ́fʊnzɩ sɩsɩ máta mɔ́wɛ Majaa-dɛ́ɛ ɖaána-daá?» ");
INSERT INTO kdh_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Amá, bɛlɛ́ badanɩ́ɩ wentí waaŋmátɩ wɛ nɛ́ tugutoluú. ");
INSERT INTO kdh_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ngɛ waagʊrʊ́ ifu wɛ bekpé Nazarɛ́ɛtɩ bɩka wánnɩɩnáa wɛ. Ɩgɔɔ ɩlɛ́ ɩɖɔ́kɩná tɔ́mwá tɩḿ tɩrɩ́ŋa iwenbiré-daá. ");
INSERT INTO kdh_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Bɩɩga Yeésu ɩlɛ́ ɩwɛ ɩbamáa bɩɩ́ bɩka ɩdɛ́ɛ áséńsí bamáa ɖɔɔmɩ́nɩ. Ɩsɔ́ɔ sɩ́ŋɛ́ɛ ɩwɔ́rɔ́ bɩka ɩdɔ́m mɔɔ́ɔ ɩráa. ");
INSERT INTO kdh_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Róóma wúro kʊ́bɔnɩ́ Tibɛ́ɛrɩ-dɛ́ɛ kowúrɔ́ɔ ɖíi-dɛ́ɛ bɩ́nɩ ákɩzaalʊʊ́ ńnɩ́-daá nɛ́, Pɔ́nsɩ Piláatɩ kɛ́ɛ na Yudée laadɔ́ɔ-rɔ bɛɛŋɩrʊ́, Eróodi ɩlɛ́ wénɖíi kowúrɔ́ɔ Galilée laadɔ́ɔ-rɔ bɩka igoobú Filíipu ɩlɛ́ wénɖíi Iturée na Tirakonitíidi laadásɩ-rɔ, bɩka Lizaniyáasɩ ɩlɛ́ wénɖíi Abilɛ́ɛnɩ laadɔ́ɔ-rɔ. ");
INSERT INTO kdh_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Áanɩ na Kayífu gɛ Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa. Bɩdɛ́ɛ bɩ́nɩ ɩmʊ́ gɛ Ɩsɔ́ɔ waaŋmatɩná Yaayá Sákarɩ biyaalʊ́ tɛɛwʊ́lɔ́ɔ́-daá. ");
INSERT INTO kdh_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ngɛ ɩlɛ́ waalɩ́ɩ ikíli laadɔ́ɔ kɔwɛ ná Yɔrɔdáanɩ buwá fáráńdɩ́ nɛ́ karɩ́ŋa kadaá wánlám waázu sɩsɩ: «Ɩgɛ́ɛ mɩ́lakásɩ bɩka iyéle belíri mɩ́ɩ lɩ́m-daá bɔsɔ mɩ́ɩ túúbá lɩ́m, na Ɩsɔ́ɔ ɩcɛ́ mɩ́dɛ́ɛ alaháácɩ́wá.» ");
INSERT INTO kdh_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Bɩɩlá bɩlɛ́ gɛ na wentí baaŋmáa anɖébi Esáya-dɛ́ɛ tákaraɖá-daá nɛ́ ikóódi, tɩlɛ́ gɛ sɩsɩ: «Lowú nakɩ́rɩ wɔɔvɔ tɛɛwʊ́lɔ́ɔ́-daá sɩsɩ: “Ɩgbɩ́ɩ́rɩ Ɖádʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ nɩ́bááwʊ, ɩzɩ́ɩ́zɩ ɩdɛ́ɛ níbeyísi. ");
INSERT INTO kdh_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Bónzuurí kazalɩ́sɩ bɩlá ɖɛtɛrɛ‑tɛrɛ bɩka bɔyɔ́ bʊ́ʊ́nɩ rɩ́ŋa na buurásɩ rɩ́ŋa bɩlá ɖɛtɛrɛ‑tɛrɛ. Nɩ́báánɩ tɩmɩláa nɛ́, bɔ́nnyɔɔzɩ́ tɩ tɩsɩ́ɩ́zɩ; níbeyísi bɩ́ńdɔ́wʊ́ sɩ nɛ́, bɔ́nnyɔɔzɩ́ sɩ sɩlá ɖɛtɛrɛ‑tɛrɛ, ");
INSERT INTO kdh_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","na báa weení ɩna nŋɩ́nɩ́ Ɩsɔ́ɔ wɛ́nlɛɛ́ ɩrʊ́ nɛ́.”» ");
INSERT INTO kdh_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yaayá wɔɔdɔ́ ɩráa tuutúúma bɔɔgɔ́nɩ ɩjɔ́ sɩsɩ ílíri wɛ lɩ́m-daá ɩsɔ wɛ túúbá lɩ́m nɛ́ sɩsɩ: «Mɩ́ɩ bɔɔzá ana ɖɔ́! Weení waawɩlɩ ná mɩ́ɩ sɩsɩ ísé ɩlɩ́ɩ Ɩsɔ́ɔ-dɛ́ɛ tɔ́m fʊʊnáa tɩɩjʊ́ʊ nɛ́ tɩdaá. ");
INSERT INTO kdh_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ɩlá lakásɩ sɩ́nwɩlɩ́ɩ sɩsɩ mɩ́ɩ́lá túúbá ɩkɛ́ɛ nɛ́. Ɩ́kamáázɩ mɩ́dáá sɩsɩ mɩ́jaájaa gɛ Ibrahím nɛ́ bɩɩdɛ́. Káma, ménveerím mɩ́ɩ sɩsɩ Ɩsɔ́ɔ wánbɩɩzɩ́ ɩkpɔ́ɔ bɔ́ ana ɖɔ́ ɩbɩsɩná Ibrahím kutoluú-dɛ bíya. ");
INSERT INTO kdh_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Báńgbɩɩrɩ kpenbiiyá sɩ bɛbɛlɩ́ na tɩ́ɩ́nɩ tigutolíni-dɛ nɛ́. Tɩɩwʊ́ wenkí rɩ́ŋa kɩ́dánɖʊ́ʊ bíya kazɔ́ɔ ńba nɛ́, bɛ́nbɛlɩ́ɩ kɩ baɖʊ nimíni-daá.» ");
INSERT INTO kdh_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ńna gɛ zamɔ́ɔ wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Bɩlɛ́ nɛ́, wé gɛ bɩmɔɔ́na ɖɩlá ɖɔ́.» ");
INSERT INTO kdh_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ngɛ woobúsi wɛ sɩsɩ: «Weení ɩwɛná ɖaazíkiwá natɩ́lɛ nɛ́, ɩ́fá weení ɩvɛ́yɩ́na nɛ́ kʊ́ɖʊmʊ́ʊ, bɩka weení ɩwɛná kíɖíím nɛ́, ɩlá bɩlɛ́ ɖʊɖɔ.» ");
INSERT INTO kdh_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Tikée mʊʊráa ɖʊɖɔ wɔɔgɔ́nɩ sɩ belíri wɛ lɩ́m-daá bɔsɔ wɛ túúbá lɩ́m, ngɛ bɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Kʊ́bɔnɩ́, wé gɛ bɩmɔɔ́na ɖɔ́ɔ́ ɖɩlá.» ");
INSERT INTO kdh_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ngɛ woobúsi wɛ sɩsɩ: «Ɩ́kɔbɔ́ɔ́zɩ naárʊ bɩcɛzɩ́ wenbí baazɩ́ɩ mɩ́ɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sɔ́ɔ́jawá ɖʊɖɔ wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Nɛ́ ɖɔ́ɔ́ ní, wé gɛ bɩmɔɔ́na ɖɩlá.» Ngɛ woobúsi wɛ sɩsɩ: «Ɩ́kɛlɛ́ɛ liideé na ɖóni naárʊ-jɔ́, ngʊ́ íkomúúli naárʊ ɩbɛlɩ́ bʊbɔ́tɩ ɩrɔ. Ɩzɩŋná mɩ́vɛrɩ́tɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ńŋɩnáa zamɔ́ɔ fʊnɖamáa na tamɔ́ɔ kʊ́bɔńga nɛ́, báa weení wɔ́nbɔɔzɩ́ ɩdɩ tɔ́m Yaayá-rɔ sɩsɩ bɩdɛkɛ́ɛ ɩmʊ́ gɛ Lɛɛrʊ́? ");
INSERT INTO kdh_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ńna gɛ Yaayá woobúsi barɩ́ŋa sɩsɩ: «Lɩ́m-daá gɛ mɔ́ɔ́ ménliríi mɩ́ɩ mɔ́nzɔ́ɔ mɩ́ɩ túúbá lɩ́m. Amá, weení ɩgɛrɛŋɛ mɔ́wɔ́rɔ́ nɛ́, waagɩ́lɩ ma, mádatála malɩzɩ́ yɩ ɩdakaḿwá. Ɩlɛ́ sɩ ilíri mɩ́ɩ Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga-daá gɛ na nimíni. ");
INSERT INTO kdh_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ɩɖɔ́kɩná kɩ́falanákʊ ɩnʊ́ʊ́zɩ-daá sɩ ɩlɩzɩ́ tolá fɔɔlʊʊ́ bɩka ɩkpɔ́ɔ mɩlá ɩbɩ́rɩ igbeewú-daá, na ɩkpɔ́ɔ tolá ɩbɩ́rɩ nimíni ɩ́dánɖɩḿ nɛ́ ɩdaá biɖe.» ");
INSERT INTO kdh_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Na tɔndasɩrɛwá ndɩ‑ndɩ ɖabata-daá gɛ Yaayá weeveeri ná wɛ Ɩsɔ́ɔ-dɛ́ɛ Laabáárʊ Kífeńgi. ");
INSERT INTO kdh_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Amá, Yaayá wooyooná Eróodi weení wénɖíi kowúrɔ́ɔ Galilée laadɔ́ɔ-rɔ nɛ́. Káma, wɔɔgbɔ́ɔ igoobú ɖɛɛlʊ́ Erodiyáadɩ, bɩka waalá lakásɩ sɩdakazɔ́ɔ nɛ́ ɖʊɖɔ bʊɖɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ńna gɛ woogúti ɩlá lakásɩ nasɩ́rɩ sɩdakazɔ́ɔ nɛ́ ɩtásɩ. Sɩlɛ́ gɛ sɩsɩ weeyéle bakpa Yaayá bɔtɔ sáráka. ");
INSERT INTO kdh_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Sáátɩ wenkí bɔɔzɔ zamɔ́ɔ rɩ́ŋa túúbá lɩ́m bɩtɛ́ nɛ́, ngɛ bɔɔzɔ Yeésu ɖʊɖɔ. Sáátɩ wenkí ɩwɛ ɩbamáa sʊlʊ́ʊ nɛ́, ngɛ ɩsɔ́ɔ́dáá waadʊlʊ́, ");
INSERT INTO kdh_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ngɛ Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga weegédi nyazɩ ɖuvóóre kʊ́fʊlʊńɖɛ bɩlɛ́ kosóm ɩrɔ. Ńna gɛ baanɩ́ɩ lowú nakɩ́rɩ ɩsɔ́ɔ́dáá sɩsɩ: «Nyɔ́ɔ́ gɛ Mebiyaalʊ́ máábá mɔ́zɔɔlɛ́ɛ yɩ nɛ́, nyɔ́rɔ́ gɛ mááɖʊ́ mɛ́dɛ́ɛ sɔɔlɩ́m rɩ́ŋa.» ");
INSERT INTO kdh_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yeésu wɛná bɩ́ɩ́zɩ ákoosaaláa bɩlɛ́ gɛ waabáázɩ ɩdɩmɛ́rɛ. Ɩráa wánvʊnmaazɩ́ gɛ sɩsɩ Ísifu biyaalʊ́ gɛ ɩgɛ́ɛ. Elíi waalʊrʊ ná Ísifu, ");
INSERT INTO kdh_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matáatɩ ɩlʊ́rʊ Elíi, Léévi ɩlʊ́rʊ Matáatɩ, Mɛlɩkíi ɩlʊ́rʊ Léévi, Iyanayíi ɩlʊ́rʊ Mɛlɩkíi, bɩka Ísifu ɩlʊ́rʊ Iyanayíi. ");
INSERT INTO kdh_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matatiyáasɩ waalʊ́rʊ Ísifu, Amɔ́ɔsɩ ɩlʊ́rʊ Matatiyáasɩ, Nawumíi ɩlʊ́rʊ Amɔ́ɔsɩ, Ɛsɩlíi ɩlʊ́rʊ Nawumíi, Nagayíi ɩlʊ́rʊ Ɛsɩlíi. ");
INSERT INTO kdh_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Máatɩ waalʊ́rʊ Nagayíi, Matatiyáasɩ ɩlʊ́rʊ Máatɩ, Semɛ́ɛnɩ ɩlʊ́rʊ Matatiyáasɩ, Iyoosɛ́ɛkɩ ɩlʊ́rʊ Semɛ́ɛnɩ, Iyodáa ɩlʊ́rʊ Iyoosɛ́ɛkɩ, ");
INSERT INTO kdh_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Iyoyanáanɩ waalʊ́rʊ Iyodáa, Réeza ɩlʊ́rʊ Iyoyanáanɩ, Zorobabɛ́ɛlɩ ɩlʊ́rʊ Réeza, Salatɩyɛ́ɛlɩ ɩlʊ́rʊ Zorobabɛ́ɛlɩ, bɩka Neríi ɩlʊ́rʊ Salatɩyɛ́ɛlɩ. ");
INSERT INTO kdh_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Mɛlɩkíi waalʊ́rʊ Neríi, Adíi ɩlʊ́rʊ Mɛlɩkíi, Kazáamɩ ɩlʊ́rʊ Adíi, Ɛlɩmadáamɩ ɩlʊ́rʊ Kazáamɩ, bɩka Ɛ́ɛrɩ ɩlʊ́rʊ Ɛlɩmadáamɩ. ");
INSERT INTO kdh_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Yeésu waalʊ́rʊ Ɛ́ɛrɩ, Eliyezɛ́ɛrɩ ɩlʊ́rʊ Yeésu, Iyorimíi ɩlʊ́rʊ Eliyezɛ́ɛrɩ, Matáatɩ ɩlʊ́rʊ Iyorimíi, bɩka Léévi ɩlʊ́rʊ Matáatɩ. ");
INSERT INTO kdh_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Simeyɔ́ɔnɩ waalʊ́rʊ Léévi, Yudáa ɩlʊ́rʊ Simeyɔ́ɔnɩ, Ísifu ɩlʊ́rʊ Yudáa, Iyonáamɩ ɩlʊ́rʊ Ísifu, bɩka Eliyakíimi ɩlʊ́rʊ Iyonáamɩ. ");
INSERT INTO kdh_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Meleyáa waalʊ́rʊ Eliyakíimi, Menáa ɩlʊ́rʊ Meleyáa, Matatáa ɩlʊ́rʊ Menáa, Natáanɩ ɩlʊ́rʊ Matatáa, bɩka Ɖáwʊɖa ɩlʊ́rʊ Natáanɩ. ");
INSERT INTO kdh_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Yesée waalʊ́rʊ Ɖáwʊɖa, Obɛ́ɛdɩ ɩlʊ́rʊ Yesée, Bóozɩ ɩlʊ́rʊ Obɛ́ɛdɩ, Saláa ɩlʊ́rʊ Bóozɩ, bɩka Nasɔ́ɔnɩ ɩlʊ́rʊ Sulemáana. ");
INSERT INTO kdh_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminadáabɩ waalʊ́rʊ Nasɔ́ɔnɩ, Adimíini ɩlʊ́rʊ Aminadáabɩ, Arɩníi ɩlʊ́rʊ Adimíini, Ɛsɩrɔ́ɔmɩ ɩlʊ́rʊ Arɩníi, Farɛ́ɛsɩ ɩlʊ́rʊ Ɛsɩrɔ́ɔmɩ, bɩka Yudáa ɩlʊ́rʊ Farɛ́ɛsɩ. ");
INSERT INTO kdh_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yaakúbu waalʊ́rʊ Yudáa, Ɩsaáka ɩlʊ́rʊ Yaakúbu, Ibrahím ɩlʊ́rʊ Ɩsaáka, Teráa ɩlʊ́rʊ Ibrahím, bɩka Nahɔ́ɔrɩ ɩlʊ́rʊ Teráa. ");
INSERT INTO kdh_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Serúki waalʊ́rʊ Nahɔ́ɔrɩ, Ragóo ɩlʊ́rʊ Serúki, Falɛ́ɛkɩ ɩlʊ́rʊ Ragóo, Ebɛ́ɛrɩ ɩlʊ́rʊ Farɛ́ɛkɩ, bɩka Saláa ɩlʊ́rʊ Ebɛ́ɛrɩ. ");
INSERT INTO kdh_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Kayinám waalʊ́rʊ Saláa, Arɩfagizáadɩ ɩlʊ́rʊ Kayinám, Sɛ́ɛmɩ ɩlʊ́rʊ Arɩfagizáadɩ, Núhum ɩlʊ́rʊ Sɛ́ɛmɩ, bɩka Lamɛ́ɛkɩ ɩlʊ́rʊ Núhum. ");
INSERT INTO kdh_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Matusaláa waalʊ́rʊ Lamɛ́ɛkɩ, Enɔ́ɔkɩ ɩlʊ́rʊ Matusaláa, Yarɛ́ɛdɩ ɩlʊ́rʊ Enɔ́ɔkɩ, Maleleyɛ́ɛlɩ ɩlʊ́rʊ Yarɛ́ɛdɩ, bɩka Kayinám ɩlʊ́rʊ Maleleyɛ́ɛlɩ. ");
INSERT INTO kdh_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enɔ́ɔsɩ waalʊ́rʊ Kayinám, Séti ɩlʊ́rʊ Enɔ́ɔsɩ, Áɖam ɩlʊ́rʊ Séti, bɩka Ɩsɔ́ɔ ɩlá Áɖam. ");
INSERT INTO kdh_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga woozuná Yeésu, ngɛ waalɩ́ɩ Yɔrɔdáanɩ buwá-daá ɩkábɩsɩ ngɛ kooboná yɩ tɛɛwʊ́lɔ́ɔ́-daá. ");
INSERT INTO kdh_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Wɔɔjɔ́ɔ ńna wɛ́ nɛɛ́lɛ bɩka Sitáánɩ wánÿɩ́m yɩ kɔdɔ́sɩ. Ideɖi nabʊ́rʊ wɛ́-bíya bɛḿ badaá. Wɛ́-bíya bɛḿ bɛɛdɛ́ nɛ́, ngɛ nyɔɔ́sɩ waagʊ yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ńna gɛ Sitáánɩ wɔɔdɔ́ yɩ sɩsɩ: «A nyɛ́gɛ́ɛ Ɩsɔ́ɔ Biyaalʊ́, tɔ bʊ́ʊ́rɛ ɖɩna ɖɩbɩ́sɩ kíɖíím.» ");
INSERT INTO kdh_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ngɛ Yeésu woobúsi yɩ sɩsɩ: «Baaŋmáa Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá sɩsɩ: “Bɩdɛkɛ́ɛ kíɖíím riké gɛ ɩrʊ́ wénɖíi na ɩcɔ́ɔ weezuú-daá.”» ");
INSERT INTO kdh_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ngɛ Sitáánɩ wooboná yɩ lénlé bɩɩbá buwóro nɛ́ ɩwɩ́lɩ yɩ sáa kʊ́ɖʊmʊ́ʊ-daá ɖúúlínya-dɛ́ɛ kowúrásɩ rɩ́ŋa, ");
INSERT INTO kdh_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ngɛ wɔɔdɔ́ yɩ sɩsɩ: «Mánváa nya yíko kɩna kɩrɩ́ŋa, na kowúrásɩ na sɩdɛ́ɛ ɖɔ́ɔ́lɛ rɩ́ŋa, káma, mɔ́ɔ́ gɛ baava yíko bɩrɩ́ŋa bɩlɛ́ bʊrɔ, ngɛ weení mɔ́ɔ́zɔ́ɔ́lɩ nɛ́ gɛ mánváa. ");
INSERT INTO kdh_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Bɩlɛ́ nɛ́, a nyáágá nyáɖʊná-rɔ ngúu ma tɛ́ɛ́dɩ, mánváa nya bɩrɩ́ŋa.» ");
INSERT INTO kdh_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ngɛ Yeésu woobúsi yɩ sɩsɩ: «Baaŋmáa Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá sɩsɩ: “Ɖádʊ́ʊ Ɩsɔ́ɔ riké gɛ nyónguú tɛ́ɛ́dɩ, ngɛ iriké gɛ nyánlám bɔwʊtá.”» ");
INSERT INTO kdh_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ńna gɛ Sitáánɩ wooboná Yeésu Yerusalɛ́ɛm, ɩsɩ́ɩ yɩ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga kʊjʊʊ́-daá. Ngɛ wɔɔdɔ́ yɩ sɩsɩ: «A nyɛ́gɛ́ɛ Ɩsɔ́ɔ Biyaalʊ́, tɔ nyádɩ nzúu adɛ, ");
INSERT INTO kdh_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","káma, baaŋmáa Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá sɩsɩ: “Ɩsɔ́ɔ wánváa ɩdɛ́ɛ malááyɩ́kawá wɛ́ɖɛ befére nyɔ́rɔ́, ");
INSERT INTO kdh_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","bɩka bɛkpɛ́kɩ nya banʊ́ʊ́zɩ-daá, na nyɔ́nʊvɔ́rɛ íkotuúli bʊ́ʊ́rɛ.”» ");
INSERT INTO kdh_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ngɛ Yeésu woobúsi yɩ sɩsɩ: «Baadáŋmáa Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá sɩsɩ: “Ńdánɖaazɩ Nyádʊ́ʊ Ɩsɔ́ɔ nbɛ́ɛ sɩsɩ wánbɩɩzɩ́?”» ");
INSERT INTO kdh_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sitáánɩ waayɩ́ yɩ kɔdɔ́sɩ ɩwɩ́ɩ nɛ́, ngɛ wɛɛɖɛ́ɛ iyéle yɩ hálɩ sáátɩ kɩ́falʊʊ́. ");
INSERT INTO kdh_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ngɛ Yeésu wɔɔlɔ́ɔ ɩbɩ́sɩ Galilée bɩka Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga-dɛ́ɛ ɖóni wɛ ɩrɔ. Ngɛ ɩyɩ́ɖɛ wɛɛzɛ́ɛ fáráńdɩ́ kɩḿ kɩrɩ́ŋa kɩdaá. ");
INSERT INTO kdh_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Wánwɩlɩ́ɩ ɩráa bɛdɛ́ɛ Ɩsɔ́ɔ ɖaazɛɛɖɛ́wá-daá bɩka barɩ́ŋa bánzám yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yeésu wɛɛɖɛ́ɛ Nazarɛ́ɛtɩ, tɛ́ɛ́dɩ wentí tɩdaá wɔɔjɔ́ɔ ɩbɩ́ɩ nɛ́. Ngɛ Fɛɛzɩrɛ wɩ́rɛ, waazʊ́ʊ Ɩsɔ́ɔ ɖaazɛɛɖɛ́ ńŋɩnáa bɩdɛ́rɛ́gɛ́ɛ ɩdɛ́ɛ ɖɔ́ɔ́ná nɛ́. Ngɛ waagʊrʊ́ sɩ ɩkála Ɩsɔ́ɔ-dɛ́ɛ tɔ́m. ");
INSERT INTO kdh_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ngɛ beejéle yɩ anɖébi Esáya-dɛ́ɛ tákaraɖá. Woovulú kɩ nɛ́, ngɛ bɩɩzaaná lénlé baaŋmáa sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Ɖádʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ Kezeŋa wɛ mɔ́rɔ́, waalɩzɩ́ ma sɩsɩ méveeri kadanbʊrʊ́sɩ Laabáárʊ Kífeńgi. Weegédíri ma sɩsɩ méveeri sáráka-dɩnáa sɩsɩ bɛ́njɛ́m wɛ, mevééri njɛma sɩsɩ baazá wónvulúu babáázɩ náa, na meyéle wenbá bánnaazɩ́ wɛ́ nɛ́ boyuú badɩ, ");
INSERT INTO kdh_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","na mevééri mɩ́ɩ Ɖádʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ kʊnyɔnnɩɩrɛ́ bɩ́nɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Waagála bɩtɛ́ nɛ́, ngɛ waabɩsɩná tákaraɖá ifu, icéle kɩ bɔwʊtá-dʊ́ʊ, ngɛ weedí ɩcɔ́ɔ. Wenbá barɩ́ŋa bɔwɛ ńna nɛ́, baabá bɛbɛɛ́na yɩ tíḿḿ. ");
INSERT INTO kdh_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ńna gɛ wɔɔdɔ́ wɛ sɩsɩ: «Ɩsɔ́ɔ-dɛ́ɛ tɔ́m mɩ́ɩ́nɩ́ɩ tɩ ɖɔ́ nɛ́, sinje gɛ tiigóódi.» ");
INSERT INTO kdh_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ngɛ ɩdɔ́m waalá barɩ́ŋa mááɖé bánzám bɩka bɩjɔɔ́ɔ wɛ bítí kʊnyɔnnɩɩrɛ́-dɛ́ɛ waázu wánlám kɩ nɛ́ kɩrɔɔzɩ́, bɩka bɔ́ndɔ́m sɩsɩ: «Bɩdɛkɛ́ɛ Ísifu biyaalʊ́ nbɩlɛ́?» ");
INSERT INTO kdh_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ńna gɛ Yeésu wɔɔdɔ́ sɩsɩ: «Báa bɩɩlá nŋɩ́nɩ́, mínduú ma ɖudúúre ɖɩna sɩsɩ: “Faadɩ-ɖʊʊrʊ́, waazɩ nyádɩ; ɖáánɩ́ɩ wenbí bɩrɩ́ŋa nyáagála Kapɛrɩnawʊ́m nɛ́, la ńŋɩnáa bɩlɛ́ ɖʊɖɔ nyɛ́dɛ́ɛ́dɩ-daá cé.”» ");
INSERT INTO kdh_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ngɛ waadásɩ ɩtɔ́ wɛ ɖʊɖɔ sɩsɩ: «Ménveerím mɩ́ɩ toovonúm sɩsɩ anɖébi naárʊ fɛ́yɩ́ bánváa yɩ gírímá ɩdɩtɩŋa ɩdɛ́ɛ́dɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Bɩlɛ́ bibaasí, anɖébi Elíya-dɛ́ɛ sáátɩ, aláa leeláa waabá bɔɖɔ́ɔ Israyɛ́ɛlɩ tɛ́ɛ́dɩ-daá sáátɩ wenkí tɛ́ɛ́wʊ waagba hálɩ bɩ́ɩ́zɩ nasúdoozo na fɔɔlʊʊ́, ngɛ nyɔɔ́sɩ kʊ́bɔńzɩ waazʊ́ʊ laadɔ́ɔ rɩ́ŋa nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Amá, na bɩrɩ́ŋa, Ɩsɔ́ɔ tetíri Elíya badaá naárʊ-jɔ́, asée Sarɛpɩtáa tɛ́ɛ́dɩ tɩwɛ Sidɔ́ɔnɩ laadɔ́ɔ-daá nɛ́-dɛ́ɛ alʊ́ leelú-jɔ́ riké. ");
INSERT INTO kdh_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Anɖébi Elizée-dɛ́ɛ sáátɩ, cɛnɩ́sɩ waabá sɩɖɔ́ɔ Israyɛ́ɛlɩ laadɔ́ɔ-daá, amá, sɩdaá báa nɛkɛ́rɛ tawáa kalá ɖacɩrɩ‑cɩrɩ, asée Siríi laadɔ́ɔ-daá cɛnɩŋa Namáanɩ riké.» ");
INSERT INTO kdh_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Wenbá bɔwɛ Ɩsɔ́ɔ ɖaazɛɛɖɛ́ nɛ́, baabá bɛyɛ́ɛ baaná baanɩ́ɩ tɔ́mwá tɩḿ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Barɩ́ŋa baagʊrʊ́ banára Yeésu balɩzɩ́ tɛ́ɛ́dɩ. Booboná yɩ buurɔɔ́ wenká kɔrɔ bɛdɛ́ɛ tɛ́ɛ́dɩ wɛ nɛ́ kɛdɛ́ɛ kʊjʊʊ́-daá sɩsɩ na bɛkɛ́vɛ́dɩ́ yɩ ɩsála kazalɩ́ya-daá. ");
INSERT INTO kdh_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Amá, ɩlɛ́ wɔɔgbɔɔná bɔlɔwʊtáá ɩɖɛ́ɛ ɩnɩ́bááwʊ. ");
INSERT INTO kdh_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Woobó ɩtála Kapɛrɩnawʊ́m, tɛ́ɛ́dɩ tɩwɛ Galilée laadɔ́ɔ-daá nɛ́ tɩdaá. Ngɛ Fɛɛzɩrɛ wɩ́rɛ nɛ́, ɩwɛ wánwɩlɩ́ɩ ɩráa. ");
INSERT INTO kdh_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ɩdɛ́ɛ wɩlɩ́ɩ waabá bɩlá wɛ bítí, káma, wánwɩlɩnáa yíko wenkí Ɩsɔ́ɔ weejéle yɩ nɛ́ gɛ. ");
INSERT INTO kdh_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ɩrʊ́ naárʊ wɛ Ɩsɔ́ɔ ɖaazɛɛɖɛ́ ɩwɛná zííni; ngɛ ɩrʊ́ ɩmʊ́ woogóo bɩcáárɩ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Ówu! Yeésu Nazarɛ́ɛtɩ ńnɩ́, wé gɛ nyɔ́zɔɔlɛ́ɛ na ɖáa. Nyɔ́ɔ́gɔ́nɩ sɩ ndɛlɛ́sɩ ɖáa yáá wé. Máábá mányɩ weení nyɛ́gɛ́ɛ nɛ́: nyɔ́ɔ́ gɛ Ɖacɩrɩ‑cɩrɩ-dʊ́ʊ weení Ɩsɔ́ɔ weegédíri yɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ngɛ Yeésu waagazɩ́ kɩ na ɖóni ɩtɔ́ kɩ sɩsɩ: «Su tɔ́m, bɩka nlɩ́ɩ ɩrʊ́ ceení-rɔɔzɩ́.» Ńna gɛ zííni wɔɔlɔ ɩrʊ́ ɩmʊ́ adɛ ɩráa lɔwʊtáá kɩcáŋ kɩlɩ́ɩ ɩrɔ. Amá, kɩdalá yɩ nabʊ́rʊ bɩdaavé nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bɩɩbá bɩlá wenbá barɩ́ŋa bɔwɛ ńna nɛ́ bítí hálɩ bɔ́nbɔɔzɩ́ ɖamá sɩsɩ: «Ŋmatɩrɛ wenɖé gɛ ɖɩna bɩlɛ́! Wánŋmatɩnáa zííniwá na yíko páá bɩka tɩlɛ́ tɩ́nlɩɩ́.» ");
INSERT INTO kdh_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ngɛ Yeésu yɩ́ɖɛ waabá ɖɩsɛ́ɛ fáráńdɩ́ kɩḿ kɩrɩ́ŋa kɩdaá. ");
INSERT INTO kdh_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yeésu waalɩ́ɩ Ɩsɔ́ɔ ɖaazɛɛɖɛ́ nɛ́, ngɛ woobó ɩɖɛ́ɛ Simɔ́ɔnɩ-dɛ́ɛ ɖaána. Waadála nɛ́, Simɔ́ɔnɩ nɔɔzɔ́ɔ wánnyaadɩ́ ɩdɔnʊʊ́ ɩbá kizoláa. Ngɛ baavɩ́nɩ Yeésu sɩsɩ ɩ́waazɩ yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ńna gɛ Yeésu woolúúzi ɩdɩ ɩrɔ ɩkazɩ́ kʊdɔḿ, ngɛ waawáa, ɩkʊrʊ́ ńna‑ńna ɩɖʊ wɛ kíɖíím. ");
INSERT INTO kdh_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Wɩ́sɩ waazála nɛ́, wenbá barɩ́ŋa bɔwɛná kʊdɔndɩnáa bánnyaadɩ́ kʊdɔmɩ́nɩ ndɩ‑ndɩ nɛ́ bɔɔgɔ́gɔ́ná wɛ Yeésu-jɔ́. Ngɛ ɩlɛ́ waadɩ́nɩ wɛ nʊ́ʊ́zɩ bɩka ɩwáázɩ wɛ. ");
INSERT INTO kdh_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Zííniwá ɖʊɖɔ waalɩ́ɩ ɖabata-daá tíngoó sɩsɩ: «Nyɔ́ɔ́ gɛ Ɩsɔ́ɔ Biyaalʊ́!» Amá, Yeésu waabá ɩkazɩ́ tɩ bɩka ikiziná tɩ sɩsɩ tɩ́kaŋmatɩ, káma, tɩlɛ́ tɩnyɩ sɩsɩ ɩnáábɩ́lɛ́ Lɛɛrʊ́. ");
INSERT INTO kdh_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tɛ́ɛ́wʊ weevé nɛ́, ngɛ waalɩ́ɩ ibó lénlé ɩráa fɛ́yɩ́ nɛ́. Ngɛ zamɔ́ɔ tuutúúma wɛ kɩ́njáádɩ yɩ. Sáátɩ wenkí baana yɩ nɛ́, bɔɔzɔ́ɔ́lɩ sɩsɩ bɔɖɔ́kɩ yɩ na ɩkɛ́ɖɛɛ iyéle wɛ. ");
INSERT INTO kdh_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Amá, wɔɔdɔ́ wɛ sɩsɩ: «Bɩmɔɔ́na mevééri ɩráa Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-dɛ́ɛ Laabáárʊ Kífeńgi tɛ́ɛ́dɩwá tɩɩganáa-daá ɖʊɖɔ, káma, bʊrɔ gɛ Ɩsɔ́ɔ weegédíri ma.» ");
INSERT INTO kdh_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ngɛ weevééri ɩráa Laabáárʊ Kífeńgi Yudée laadɔ́ɔ-dɛ́ɛ Ɩsɔ́ɔ ɖaazɛɛɖɛ́wá-daá. ");
INSERT INTO kdh_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Wɩ́rɛ neɖére gɛ Yeésu wɛ Genezarɛ́ɛtɩ lɩɩrɛ́ kʊ́bɔńɖɛ nɔɔ́-rɔ wánlám waázu. Zamɔ́ɔ kʊ́bɔńgɩ wɛ ńna bɩka kɩdɛ́ɛ ɩráa ɩbá bányʊʊ́ ɖamá sɩ banɩ́ɩ Ɩsɔ́ɔ-dɛ́ɛ tɔ́m. ");
INSERT INTO kdh_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Waana kpɩ́ɩ́rɩ́nɩ natɩ́lɛ sɩ́ŋɛ́ɛ lɩ́m nɔɔ́-rɔ. Tiiná kpaaráa wáńlɩ́ɩ́ tɩdaá bánÿaalɩ́ bɛdɛ́ɛ biríni. ");
INSERT INTO kdh_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tɩdaá nakɩ́rɩ kɛ́ɛ Simɔ́ɔnɩ-dɛ́ɛ ńgɩ. Ngɛ Yeésu woobó ɩkpa kɩlɛ́ kɩdaá ɩtɔ́ Simɔ́ɔnɩ sɩsɩ ɩ́saa kpɩ́ɩ́rʊʊ́ ɩtásɩ ɩsʊ́ʊ cʊ́kɔ. Ngɛ weedí ɩcɔ́ɔ kpɩ́ɩ́rʊʊ́-daá ńna bɩka wánwɩlɩ́ɩ ɩráa Ɩsɔ́ɔ-dɛ́ɛ tɔ́m. ");
INSERT INTO kdh_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Wɛɛdɛ́ ŋmatɩrɛ nɛ́, ngɛ wɔɔdɔ́ Simɔ́ɔnɩ sɩsɩ: «Saa kpɩ́ɩ́rʊʊ́ nbó lénlé biilíŋ nɛ́ bɩka ɩlɔ mɩ́dɛ́ɛ biríni ɩkpa tiiná.» ");
INSERT INTO kdh_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ngɛ Simɔ́ɔnɩ woobúsi yɩ sɩsɩ: «Kʊ́bɔnɩ́, nuvoowú rɩ́ŋa, ɖáábá ɖɩlɔ biríni fifíni ití ɖáa faala, ɖódoyuú báa nabʊ́rʊ. Amá, nyɔ́ɔ́dɔ́ ná nɛ́, mɔ́nlɔ́ɔ tɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ngɛ bɔɔlɔ biríni babá bakpa tiiná bɩɖɔ́ɔ páá hálɩ bɛdɛ́ɛ biríni wɛ́nlɛrɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ńna gɛ bɔɔlɔ nʊ́ʊ́zɩ bayáa bɔɖɔndɩnáa bɔgɔwɛ kpɩ́ɩ́rʊʊ́ kɩɩganáa-daá nɛ́ sɩsɩ bɔ́kɔnɩ basɩná wɛ. Bɛlɛ́ bɔɔgɔ́nɩ ngɛ barɩ́ŋa baaɖʊ tiiná kpɩ́ɩ́rɩ́nɩ lɛ́ɛ́nɩ́-daá bisu hálɩ tɩlɛ́ tɩ́nlʊwáána lɩ́m-daá liríi. ");
INSERT INTO kdh_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simɔ́ɔnɩ Pétro waana bɩlɛ́ nɛ́, ngɛ weedí isóm Yeésu ɩzá-daá ɩtɔ́ sɩsɩ: «Ɖádʊ́ʊ, laná ma bolíni, káma, mɛ́gɛ́ɛ alaháácɩ́-dʊ́ʊ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Wenbí bʊrɔ Simɔ́ɔnɩ wɔɔdɔ́ bɩlɛ́ nɛ́ gɛ sɩsɩ nɩdáárɛ kʊ́bɔńɖɛ waabaná ɖɩlá yɩ bɩkpɛdɩ́na ɩ́na wenbá nɛ́, tiiná ɖabata baagba yɛ nɛ́ arɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Hálɩ bɩkpɛdɩ́na Simɔ́ɔnɩ ɖɔndɩnáa Yaakúbu na Yʊháánɩ, Zebedée biyaalɩnáa ɖʊɖɔ. Amá, Yeésu wɔɔdɔ́ Simɔ́ɔnɩ sɩsɩ: «Bɩ́kalá nya nɩdáárɛ. Kpɔɔná lɛlɛɛɖɔ́, ɩráa gɛ sɩ ngáyáa sɩsɩ bófú ma.» ");
INSERT INTO kdh_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ngɛ baagábɩ́sɩ́ná bɛdɛ́ɛ kpɩ́ɩ́rɩ́nɩ kpaam-rɔ, beyéle bɩrɩ́ŋa bofu Yeésu. ");
INSERT INTO kdh_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Wɩ́rɛ neɖére gɛ Yeésu wɛ tɛ́ɛ́dɩ natɩ́rɩ-daá, ngɛ ɩrʊ́ naárʊ cɛnɩ́tɩ waabɩrɩná ɩrɩ́ŋa nɛ́ waadála. Waana Yeésu nɛ́, ngɛ wɛɛjɛ́ ɩsála ɩlɛ́ waazá-daá wánzʊlʊ́ʊ yɩ sɩsɩ: «Kʊ́bɔnɩ́, a nyɔ́zɔɔlɛ́ɛ, nyánbɩɩzɩ́ nÿéle mawáa malá ɖacɩrɩ‑cɩrɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ńna gɛ Yeésu wɔɔvɔ́ ɩnʊ́ʊ́nɩ itekiná yɩ ɩtɔ́ yɩ sɩsɩ: «Ɩɩ́n, mɔ́zɔɔlɛ́ɛ, waa nlá ɖacɩrɩ‑cɩrɩ.» Ngɛ nɔɔ́ kʊ́ɖʊḿ nɛ́, cɛnɩ́tɩ waawáa. ");
INSERT INTO kdh_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ngɛ Yeésu waabásɩ yɩ, ɩtɔ́ yɩ sɩsɩ: «Nkefééri naárʊ wenbí bɩɩlá nɛ́. Amá, bo Ɩsɔ́ɔ sarásɩ lanɖʊ́ ɩna wenbí nyɔ́jɔɔ́ɔ nɛ́, na nlá sarɔ́ɔ wenká Múúsá wɔɔdɔ́ sɩsɩ bála nɛ́, na báa weení ɩtɩlɩ́ sɩsɩ nyááwáa.» ");
INSERT INTO kdh_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ɩráa ɩbá bɔwɛ bánŋmatɩ́ Yeésu-dɛ́ɛ tɔ́m ɖabata, bɩka zamɔ́ɔ tuutúúma wɔ́ngɔnɩ́ kínduuzí ɩjɔ́ kínwelesí yɩ bɩka wánwaazɩ́ ɩráa-dɛ́ɛ kʊdɔmɩ́nɩ. ");
INSERT INTO kdh_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Amá, Yeésu ɩlɛ́ nɛ́, wándárálɩ́ɩ gɛ wɛ́nɖɛɛ́ faɖáma-daá lé ɩráa fɛ́yɩ́ nɛ́ wángazʊlʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Wɩ́rɛ neɖére Yeésu wɛ ɩbamáa Ɩsɔ́ɔ-dɛ́ɛ tɔ́m wɩlɩ́ɩ nɛ́, Faríizi ńba na Mará wɩlɩɖáa wɛ bɔjɔɔ́ɔ ɩjɔ́. Baagálɩ́ɩ́ná Galilée na Yudée laadásɩ-dɛ́ɛ tɛɛbíízi rɩ́ŋa na Yerusalɛ́ɛm tɛ́ɛ́dɩ-daá. Ɖádʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ yíko wɛ Yeésu-rɔ, kínÿelíi wánwaazɩ́ kʊdɔndɩnáa. ");
INSERT INTO kdh_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ɩráa nɛbɛ́rɛ wɔɔgɔ́nɩ bagazʊwáána gaala‑gáálɔɔ́ nɛkɛ́rɛ kɩgbáláwʊ-rɔ bánjáádɩ sɩ basʊʊná kɛ ɖaána-daá basɩ́ɩ kɛ Yeésu ɩzá-daá. ");
INSERT INTO kdh_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Amá, zamɔ́ɔ-rɔ nɛ́, badabɩ́ɩ́zɩ basʊʊná kɛ. Ngɛ baagba ná kɛ ɖaḿ kʊjʊʊ́-rɔ batʊlʊ́ bɔɔwʊ́ bekédisi kɛ zamɔ́ɔ lɔwʊtáá Yeésu ɩzá-daá kána kagɩgbáláwʊ. ");
INSERT INTO kdh_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yeésu waana nŋɩ́nɩ́ baava yɩ toovonúm nɛ́, ngɛ wɔɔdɔ́ kʊdɔndʊ́ʊ sɩsɩ: «Mɛ́ɛ́jɛ́ nya nyɛ́dɛ́ɛ alaháácɩ́wá.» ");
INSERT INTO kdh_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Mará wɩlɩɖáa na Faríizi ńba wɛ bɔ́ndɔ́m badaá sɩsɩ: «Ɩrʊ́ weení gɛ ceení gɛ wɛ́ngbɛɛnáa Ɩsɔ́ɔ bɩlɛ́. Weení wánbɩɩzɩ kʊ ɩcɛ́ ɩráa-dɛ́ɛ alaháácɩ́wá bɩdɛkɛ́ɛ Ɩsɔ́ɔ riké.» ");
INSERT INTO kdh_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yeésu waadɩlɩ́ wentí bánmaazɩ́ nɛ́, ngɛ wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «We-rɔ gɛ mɩ́nmaazɩ́ míwenbé-daá bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Mɔdɔ́ sɩsɩ: “Mɛ́ɛ́jɛ́ nya nyɛ́dɛ́ɛ alaháácɩ́wá,” na: “Kʊrʊ́ nnʊ́ŋ,” bʊlɔwʊtáá, wentí fɛ́yɩ́na káálɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Amá, mɔ́zɔɔlɛ́ɛ ɩtɩlɩ́ sɩsɩ ɩrʊ́ Biyaalʊ́ wɛná yíko ɩcɛ́ ɩráa bɛdɛ́ɛ alaháácɩ́wá adɛ laadɔ́ɔ-rɔ cé. Ngɛ wɔɔdɔ́ gaala‑gáálɔɔ́ sɩsɩ: «Mazɩ: “Kʊrʊ́! Kpɔɔ nyágɩgbáláwʊ ngbé nyɛ́dɛ́ɛ.”» ");
INSERT INTO kdh_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ńna‑ńna gɛ waagʊrʊ́ ɩsɩ́ŋ barɩ́ŋa baazá-daá, ɩkpɔ́ɔ kɩgbáláwʊ ɩvʊnvɩ́nɛ́ɛ kɩrɔ nɛ́ wéngbém ɩdɛ́ɛ bɩka wánzám Ɩsɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Bɩɩbá bɩlá barɩ́ŋa bítí bɩka bánzám Ɩsɔ́ɔ. Nɩdáárɛ waabá bɩlá wɛ nɛ́, bánŋmatɩ́ sɩsɩ: «Sinje ɖááná wenbí kɛtɛngɛrɛ ɖádanáa ta nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Bʊwɔ́rɔ́ nɛ́, Yeésu waalɩ́ɩ, ngɛ waana tikée mʊʊrʊ́ naárʊ bánÿaá yɩ sɩsɩ Léévi, ɩjɔɔ́ɔ ɩdɩmɛ́rɛ-daá. Ngɛ wɔɔdɔ́ yɩ sɩsɩ: «Kovu ma.» ");
INSERT INTO kdh_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ngɛ ɩlɛ́ weeyéle bɩrɩ́ŋa ɩkʊrʊ́ ifu yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Bʊwɔ́rɔ́ nɛ́, Léévi waalá Yeésu jíńgáárɩ́ kʊ́bɔńgɩ nakɩ́rɩ ɩdɛ́ɛ ɖaána. Ngɛ tikée mʊʊráa ɖabata na ɩráa nɛbɛ́rɛ wɔɔgɔ́nɩ bána wɛ bénɖíi kíɖíím. ");
INSERT INTO kdh_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Faríizi ńba na bɛdɛ́ɛ Mará wɩlɩɖáa wánŋmɩɩdɩ́, ngɛ bɔɔbɔ́ɔ́zɩ ɩdɛ́ɛ wanbaaráa sɩsɩ: «Bɩyáásɩ́ gɛ mɩ́na tikée mʊʊráa na ɩráa balakásɩ taavé nɛ́, mínɖíi mɩ́nyɔɔ́.» ");
INSERT INTO kdh_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ńna gɛ Yeésu woobúsi wɛ sɩsɩ: «Kʊdɔndɩnáa wánjáádɩ kʊ lákʊ́ta, alaafɩ́ya-dɩnáa baafɛ́yɩ́ na yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mɔ́dɔkɔ́nɩ sɩ mayáa wenbá bazɩɩzɛ́ɛ nɛ́, amá, alaháácɩ́-dɩnáa-rɔ gɛ mɔ́ɔ́gɔ́nɩ na babɩ́ɩ́zɩ balá túúbá.» ");
INSERT INTO kdh_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ngɛ Faríizi ńba wɔɔdɔ́ Yeésu sɩsɩ: «Yaayá-dɛ́ɛ wanbaaráa wɔ́ndɔ́rɔ́vɔ́kɩ́ nɔɔ́ gɛ bɩka bánlám sʊlʊ́ńdɩ, ɖɔ́ɔ́ ɖɛ́dɛ́ɛ ńba ɖʊɖɔ wánlám bɩlɛ́. Amá, nyɔ́ɔ́ nyɛ́dɛ́ɛ wanbaaráa wénɖíi gɛ bɩka bɔ́nnyɔɔ́.» ");
INSERT INTO kdh_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Mɩ́nbɩɩzɩ́ iyéle weetáhárʊ ɖɔndɩnáa ɩfɔ́kɩ nɔɔ́ sáátɩ wenkí bána yɩ nɛ́? ");
INSERT INTO kdh_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Amá, sáátɩ nakɩ́rɩ kɛgɛrɛŋɛ, bɔ́ngɔnɩ́ balɩzɩ́ yɩ bɔlɔwʊtáá, bɩdɛ́ɛ sáátɩ gɛ bɔ́nvɔkɩ́.» ");
INSERT INTO kdh_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ngɛ Yeésu waadásɩ ɩŋmatɩná wɛ ɖʊɖɔ na tɔmgɛɛzɩrɛ ɩtɔ́ wɛ sɩsɩ: «Naárʊ fɛ́yɩ́ wɛ́nlɛrɩ́ɩ bɩsaawʊ́ kɩ́falʊʊ́-dɛ́ɛ fɔɔlɔɔ́ ɩtɔ ná bɩsaawʊ́ kɩ́bɩńgɩ, a waalá bɩlɛ́, wɛɛlɛrɩ́ bɩsaawʊ́ kɩ́falʊʊ́ bɩka ɖʊɖɔ fɔɔlɔɔ́ kɩ́falɔɔ́ tánzaaná bɩsaawʊ́ kɩ́bɩńgɩ. ");
INSERT INTO kdh_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Naárʊ tɔ́ngbɔwʊ́ sʊlʊ́m kɩ́fabɩ bɩdabɩɩ tá bɩtɛ́ nɛ́ isúu tɔná furúni kɩ́bɩńdɩ-daá. A waalá bɩlɛ́, sʊlʊ́m bɩḿ bínÿelíi tɔná furúni ɩya, sʊlʊ́m ɩbɛ́ɖɩ, bɩka tɔná furúni ɩlá ásáráwʊ́. ");
INSERT INTO kdh_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Amá, bónzuú sʊlʊ́m kɩ́fabɩ tɔná furúni kɩ́fatɩ-daá gɛ. ");
INSERT INTO kdh_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Naárʊ tánjaa wɔ́ńnyɔ́ɔ́ sʊlʊ́m kɩ́bɩńbɩ bɩtɛ́ nɛ́, ɩtásɩ ɩnyɔ́ɔ kɩ́fabɩ, káma, bánŋmatɩ́ sɩsɩ: “Sʊlʊ́m kɩ́bɩńbɩ cɔɔ́ɔ na kʊ kazɔ́ɔ.”» ");
INSERT INTO kdh_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Fɛɛzɩrɛ wɩ́rɛ neɖére gɛ Yeésu wɛ́ndɛsɩ́ bilée fásɩ. Ngɛ ɩwanbaaráa waabáázɩ bilée kpɛɛ́ bónnuudí banʊ́ʊ́zɩ-daá bɔ́ndɔwʊ́ʊ kibíya. ");
INSERT INTO kdh_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ńna gɛ Faríizi ńba nɛbɛ́rɛ wɔɔdɔ́ wɛ sɩsɩ: «We-rɔ gɛ mɩ́nlám wenbí ɖɛ́dɛ́ɛ Mará tafa nɩ́bááwʊ sɩsɩ bála Fɛɛzɩrɛ wɩ́rɛ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «A bɩlɛ́, mɩ́dákála wenbí Ɖáwʊɖa waalá wɩ́rɛ neɖére nyɔɔ́sɩ waalá yɩ bɩkpɛdɩ́na ɩ́na wenbá nɛ́ gɛ? ");
INSERT INTO kdh_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Waazʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá gɛ, ɩkpɔ́ɔ kpɔ́nɔ́wá baalá tɩ Ɩsɔ́ɔ sarɔ́ɔ nɛ́ ɩtɔ́ɔ. Ngɛ waava tɩ ɩ́na wenbá nɛ́ bɔtɔ́ɔ ɖʊɖɔ. Ngʊ́ Ɩsɔ́ɔ sarásɩ lanɖáa riké gɛ Mará waava nɩ́bááwʊ sɩsɩ bɔ́tɔɔ tɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ngɛ Yeésu waadásɩ ɩtɔ́ wɛ ɖʊɖɔ sɩsɩ: «Ɩrʊ́ Biyaalʊ́ wɛná na kʊ yíko Fɛɛzɩrɛ wɩ́rɛ-rɔ.» ");
INSERT INTO kdh_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Fɛɛzɩrɛ wɩ́rɛ neɖére ɖʊɖɔ gɛ Yeésu waazʊ́ʊ Ɩsɔ́ɔ ɖaazɛɛɖɛ́ wánwɩlɩ́ɩ ɩráa Ɩsɔ́ɔ-dɛ́ɛ tɔ́m; abaalʊ́ naárʊ wɛ ńnaamʊ́ biilí ɩnʊ́ʊ́nɩ kíɖiiwú. ");
INSERT INTO kdh_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mará wɩlɩɖáa na Faríizi ńba wɛ bɛbɛɛ́na Yeésu sɩsɩ wánwaazɩ́ ɩrʊ́ Fɛɛzɩrɛ wɩ́rɛ yáá nŋɩ́nɩ́, na boyuú kúbuunátɩ bobuuná yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Amá, Yeésu ɩlɛ́ ɩvʊnnyɩ bolomaazɛ́. Ńna gɛ wɔɔdɔ́ ɩrʊ́ ɩmʊ́ biilí ɩnʊ́ʊ́nɩ nɛ́ sɩsɩ: «Kʊrʊ́ ɩsɔ́ɔ́dáá nzɩ́ŋ lɔwʊtáá ńna.» Ngɛ ɩlɛ́ waagʊrʊ́ ɩsɩ́ŋ ɩsɔ́ɔ́dáá. ");
INSERT INTO kdh_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ngɛ wɔɔdɔ́ wɛ sɩsɩ: «Mɔ́nbɔɔzɩ́ mɩ́ɩ sɩsɩ we gɛ Mará waava nɩ́bááwʊ sɩsɩ bála Fɛɛzɩrɛ wɩ́rɛ. Bɩɩva nɩ́bááwʊ sɩsɩ bála kazɔ́ɔ ńbɩ yáá bɩdaavé nɛ́. Sɩsɩ bɛ́lɛɛ ɩrʊ́ yáá bákʊ́ yɩ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ńna gɛ Yeésu wɛɛbɛ́ɛ́ŋ barɩ́ŋa ɩlára ɩmɩ́lɩ, ngɛ wɔɔdɔ́ ɩrʊ́ ɩmʊ́ sɩsɩ: «Fɔ nyánʊ́ʊ́nɩ.» Ngɛ ɩlɛ́ wɔɔvɔ́ ɩnʊ́ʊ́nɩ, ngɛ ɩnʊ́ʊ́nɩ waawáa ɩbɩ́sɩ nyazɩ lí ńnɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mará wɩlɩɖáa na Faríizi ńba waabá bɛyɛ́ɛ baaná páá, ngɛ baabáázɩ ɖamá sááwʊ́ra lanáa na batɩlɩ́ nŋɩ́nɩ́ sɩ bala ná Yeésu nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Wɩ́rɛ neɖére gɛ Yeésu waagba bʊ́ʊ-daá sɩ ɩkázʊlʊ Ɩsɔ́ɔ. Wɔɔjɔ́ɔ ńna nuvoowú rɩ́ŋa sʊlʊ́ńdɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tɛ́ɛ́wʊ weevé nɛ́, ngɛ waayáa ɩwanbaaráa ɩlɩzɩ́ fuú na nɔɔ́lɛ badaá ɩfa wɛ yɩ́ɖɛ sɩsɩ: Tɩndɩnáa. ");
INSERT INTO kdh_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Fuú na nɔɔ́lɛ bɛḿ nɖɔ́: Simɔ́ɔnɩ weení waava yɩ yɩ́ɖɛ sɩsɩ Pétro nɛ́, na igoobú Andirée; Yaakúbu na Yʊháánɩ; Filíipu na Barɩtelemíi; ");
INSERT INTO kdh_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Maatéwu na Tomáa; Yaakúbu Alɩfée biyaalʊ́ na Simɔ́ɔnɩ weení bánÿaá yɩ sɩsɩ kezée-bú nɛ́; ");
INSERT INTO kdh_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yúudi Yaakúbu biyaalʊ́ na Yudásɩ Isikariyóo weení waayá yɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yeésu waagálɩɩ bʊ́ʊ-rɔɔzɩ́ ikédi ɩ́gana wɛ, ngɛ bɔɔgɔ́nɩ basɩ́ŋ kɩdɛrɛwʊ-daá lé ɩwanbaaráa tuutúúma fʊnzɩ́ŋɛ́ɛ nɛ́. Zamɔ́ɔ kʊ́bɔńgɩ ɖʊɖɔ wɛ ńna kɩɩgálɩ́ɩ́ná Yudée laadɔ́ɔ-daá, Yerusalɛ́ɛm tɛ́ɛ́dɩ-daá, na tenkú nɔɔ́‑nɔɔ́ tɛ́ɛ́dɩ Tíiri na Sidɔ́ɔnɩ. ");
INSERT INTO kdh_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bɔɔgɔ́nɩ sɩ bewélesi yɩ bɩka ɩwáázɩ bɛdɛ́ɛ kʊdɔmɩ́nɩ. Wenbá zííniwá wánjaarɩ́ wɛ nɛ́ baawáa, ");
INSERT INTO kdh_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","bɩka zamɔ́ɔ rɩ́ŋa wánjáádɩ sɩsɩ kitekiná yɩ, káma, ɖóni naárʊ wánlɩɩ́ ɩrɔ wánwaazɩ́ barɩ́ŋa. ");
INSERT INTO kdh_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ńna gɛ waagʊ́sɩ waazá ɩbɛ́ɛ ɩwanbaaráa, ngɛ wɔɔdɔ́ wɛ sɩsɩ: «Wenbi‑niíni-dɩnáa gɛ mɩ́gɛ́ɛ, mɩ́nyɔ́ɔ́ kadanbʊrʊ́sɩ; káma, mɩ́dɩɩná Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Wenbi‑niíni-dɩnáa gɛ mɩ́gɛ́ɛ, mɩ́nyɔ́ɔ́ wenbá nyɔɔ́sɩ wángʊ́ʊ mɩ́ɩ lɛlɛɛɖɔ́ nɛ́; káma, mɩ́ngɔnɩ́ ikéɖí ɩfɔ́ɔ. Wenbi‑niíni-dɩnáa gɛ mɩ́gɛ́ɛ, mɩ́nyɔ́ɔ́ wenbá mínwií lɛlɛɛɖɔ́ nɛ́; káma, mɩ́ngɔnɩ́ ɩkámʊŋ. ");
INSERT INTO kdh_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Wenbi‑niíni-dɩnáa gɛ mɩ́gɛ́ɛ, a bɩgɛ́ɛ sɩsɩ ɩráa tánjaa mɩ́ɩ, béngizíi mɩ́ɩ, bándʊ́ʊ́dɩ mɩ́ɩ, bɩka bánŋmatɩ́ wentí tɩdaavé nɛ́ mɩ́rɔ́ɔ́zɩ́, káma, mívóo Ɩrʊ́ Biyaalʊ́ nɛ́-rɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Bɩdɛ́ɛ wɩ́rɛ, bɩ́la mɩ́ɩ niíni ɩfáárɩ, káma, mɩ́dɛ́ɛ kɩvɛrɛwʊ wɔɔɖɔ́ɔ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-daá. Ńŋɩnáa bɩlɛ́ gɛ bajaájaanáa waanáázɩ anɖébiwá. ");
INSERT INTO kdh_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Amá, nbusú ɖamáa na mɩ́ɩ, mɩ́ɩ wenbá mɩ́gɛ́ɛ ɖɔ́ɔ́lɛ-dɩnáa nɛ́, káma, míńÿúú mɩ́dɛ́ɛ wenbi‑niíni. ");
INSERT INTO kdh_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nbusú ɖamáa na mɩ́ɩ, mɩ́ɩ wenbá mɩ́vɔɔ́ lɛlɛɛɖɔ́ nɛ́, káma, mɩ́ngɔnɩ́ ɩsɩ́ nyɔɔ́sɩ. Nbusú ɖamáa na mɩ́ɩ, mɩ́ɩ wenbá mɩ́nmʊŋ́ lɛlɛɛɖɔ́ nɛ́, káma, mɩ́ngɔnɩ́ ɩcɔ́ɔ ɖúkúru-daá bɩka iwíi. ");
INSERT INTO kdh_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Nbusú ɖamáa na mɩ́ɩ, a bɩgɛ́ɛ sɩsɩ ɩráa rɩ́ŋa wánŋmatɩ́ kazɔ́ɔ ńdɩ mɩ́rɔ́ɔ́zɩ́, káma, bɩlɛ́ gɛ bajaájaanáa waazá anɖébiwá bʊbɔtɩnáa.» ");
INSERT INTO kdh_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Amá, mɩ́ɩ wenbá mínwelesí ma nɛ́, ménveerím mɩ́ɩ sɩsɩ: Ɩzɔ́ɔ́lɩ mɩ́báɖaanáa, bɩka ɩlá wenbá bádánjaa mɩ́ɩ nɛ́ kífeńbi; ");
INSERT INTO kdh_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ɩɖʊ wenbá bánlám mɩ́ɩ láálɩ́ nɛ́ alɩbáráka, bɩka ɩsʊ́lʊ wenbá bánnaazɩ́ mɩ́ɩ nɛ́ bɔrɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","A naárʊ wɛɛjɛ́ nya kadaŋá nyédeegbeluú nakɩ́rɩ-rɔɔzɩ́, kɛɛzɩ́ kɩɩganáa njéle yɩ. A bɩgɛ́ɛ sɩsɩ naárʊ wɔɔgbɔ́ɔ nyɛ́dɛ́ɛ ɖaazíki, talɩná yɩ nyɛ́dɛ́ɛ kpáyɩ ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Fa weení wánzʊlʊ́ʊ nya nɛ́, bɩka a naárʊ wɔɔgbɔ́ɔ nyɛ́dɛ́ɛ nabʊ́rʊ, nkɔbɔ́ɔ́zɩ yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ɩlá baaganáa wenbí nɔ́ɔ́ mɩ́zɔɔlɛ́ɛ sɩsɩ bɛlɛ́ bála mɩ́ɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","A wenbá bɔzɔɔlɛ́ɛ mɩ́ɩ nɛ́ beriké gɛ mɩ́zɔɔlɛ́ɛ, kɩvɛrɛwʊ wenkí gɛ mɩ́ɖamáa ɖʊɖɔ. Káma, alaháácɩ́-dɩnáa ɖʊɖɔ sɔɔlɛ́ɛ wenbá bɔzɔɔlɛ́ɛ wɛ nɛ́ gɛ. ");
INSERT INTO kdh_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","A ngʊ́ wenbá bánlám mɩ́ɩ kífeńbi nɛ́ beriké gɛ mɩ́nlám kífeńbi, kɩvɛrɛwʊ wenkí gɛ mɩ́ɖamáa. Bɩlɛ́ gɛ alaháácɩ́-dɩnáa tɩtɩŋa wánlám. ");
INSERT INTO kdh_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ngɛ a wenbá mɩ́nyɩ sɩsɩ bɔ́ngɔnɩ́ bɛfɛ́rɛ mɩ́ɩ nɛ́ beriké gɛ mɩ́ngɩ́m, kɩvɛrɛwʊ wenkí gɛ mɩ́ɖamáa. Alaháácɩ́-dɩnáa ɖʊɖɔ wángɩ́m alaháácɩ́-dɩnáa gɛ na bɛfɛ́rɛ wɛ bɩdɛ́ɛ nɔ́ɔ́. ");
INSERT INTO kdh_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Amá, ɩzɔ́ɔ́lɩ mɩ́báɖaanáa, ɩlá wɛ kífeńbi, ngɛ ɩgɩ́ bɩka mɩ́raaɖamáa nabʊ́rʊ. Bɩlɛ́ nɛ́, mɩ́dɛ́ɛ kɩvɛrɛwʊ wɔ́nɖɔɔ́ bɩka ɩbɩ́sɩ Ɩsɔ́ɔ bílí‑bílí-dʊ́ʊ biyaalɩnáa, káma, ɩlɛ́ wánlám kutulúwá na wenbá badaavé nɛ́ kífeńbi. ");
INSERT INTO kdh_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ɩbɩ́sɩ kazɔ́ɔ-lanɖáa ńŋɩnáa Mɩ́jaa kɛ́ɛ kazɔ́ɔ-lanɖʊ́ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Ɩ́kafʊʊná naárʊ, na bádanvʊʊná mɩ́ɩ; ɩ́kakʊ naárʊ-dɛ́ɛ tɔ́m, na bádángʊ́ʊ mɩ́dɔ́m; ɩjɛ́ baaganáa na bɛcɛ́ mɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ɩva baaganáa na bafa mɩ́ɩ; sɩ babá gɛ bamáázɩ bisu bɩwáádɩ babɩ́rɩ mɩ́bɩsaawʊ́-daá. Káma, kɩ́maazʊʊ́ wenkí mɩ́nmaazɩnáa baaganáa nɛ́ gɛ sɩ bamaazɩ ná mɩ́ɩ ɖʊɖɔ.» ");
INSERT INTO kdh_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yeésu waadásɩ ɩŋmatɩná wɛ na tɔmgɛɛzɩrɛ sɩsɩ: «Njɛm wánbɩɩzɩ́ ikéti njɛm naárʊ? Bɛlɛ́ɛ́nɩ́ bódónÿoozi basála bɔɔwʊ́-daá? ");
INSERT INTO kdh_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Wanbaarʊ́ weení wɛ́ngbɛlɛŋ́ nɛ́ takɩ́lɩ ɩdɛ́ɛ wɩlɩɖʊ́, amá, weení baawɩ́lɩ yɩ kazɔ́ɔ nɛ́ wánbɩsɩ́ gɛ nyazɩ ɩdɛ́ɛ wɩlɩɖʊ́. ");
INSERT INTO kdh_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ngbaalá gɛ nyɛ́bɛɛ́na keyiká kɔwɛ nyɔ́rɔwʊ́ ɩzɩ́rɛ-daá nɛ́ bɩka ńdánnáa ɖaagbetumuú kʊwɛ nyɛ́dɛ́ɛ ńɖɛ-daá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nŋɩ́nɩ́ gɛ nyánbɩɩzɩ́ ndɔ́ ngoobú sɩsɩ: “Yele malɩzɩ́ keyiká kɔwɛ nyáázɩ́rɛ-daá nɛ́,” nyɔ́ɔ́ weení ńdánnáa ɖaagbetumuú kʊwɛ nyɛ́dɛ́ɛ ńɖɛ-daá nɛ́. Munáávikí, lɩzɩ́ ɖaagbetumuú kʊwɛ nyáázɩ́rɛ-daá naanɩ́, na nna kazɔ́ɔ nlɩzɩ́ keyiká kɔwɛ nyɔ́rɔwʊ́ ɩzɩ́rɛ-daá nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Tɩɩwʊ́ kazɔ́ɔ ńgɩ tánɖʊ́ʊ bíya badaavé nɛ́, ngʊ́ tɩɩwʊ́ kɩdaavé nɛ́ tánɖʊ́ʊ bíya kazɔ́ɔ ńba. ");
INSERT INTO kdh_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tɩɩwʊ́ báa wenkí nɛ́, kibíya gɛ bándɩlɩ́ɩ na kɩ. Bɔ́dɔ́ngɔrɩ́ furúu bíya sɔɔzɔ́ɔ́zɩ-daá, yáá kɩjɩcɩ́lʊ́ʊ bíya bʊvʊ́m-daá. ");
INSERT INTO kdh_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ɩrʊ́ kazɔ́ɔ ńnɩ́ wánlɩzɩ́ɩ wenbí bɩjɔɔ́ɔ kazɔ́ɔ nɛ́ wenbí ɩwɛná kazɔ́ɔ ńbɩ bʊwɛ iwenbiré-daá nɛ́ bɩdaá, ɩrʊ́ kidaavéénúu ɩlɩzɩ́ wenbí bɩdaavé nɛ́ wenbí ɩwɛná bɩdaavé nɛ́ bɩdaá.» ");
INSERT INTO kdh_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Ngɛ ngbaalá mɩ́nÿaá ma sɩsɩ: “Ɖádʊ́ʊ, Ɖádʊ́ʊ,” bɩka mɩ́ndánlaḿ wentí mɔ́ndɔ́m nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Weení rɩ́ŋa wɔɔgɔ́nɩ mɔ́jɔ́, ɩnɩ́ɩ tɔ́m mánŋmatɩ́ tɩ ɖɔ́ nɛ́, ngɛ woovu ɩlá wenbí tɩ́nbɔɔzɩ́ nɛ́, ménveerím mɩ́ɩ weení waalɩ́ɩ nɛ́: ");
INSERT INTO kdh_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","waalɩ́ɩ gɛ nyazɩ ɩrʊ́ weení wánmáa ɖaána nɛ́, waabáa adɛ bɩbá bilíŋ, ngɛ waalá ɖɩzɩɩrɛ bʊ́tangbalʊʊ́-rɔ. Sáátɩ wenkí tɛ́ɛ́nɩ waanɩ́ɩ búúzi isu sɩyɛlɩ́, búúzi-daá lɩ́m iyóo ɖaána kɛḿ, amá, bɩdabɩ́ɩ́zɩ bɩyɔ́ kɛ, káma, baama kɛ kazɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Amá, ɩrʊ́ weení waanɩ́ɩ mɛ́dɛ́ɛ tɔ́m, ngɛ ɩdalá wenbí tɩ́nbɔɔzɩ́ nɛ́ cɔɔ́ɔ gɛ nyazɩ ɩrʊ́ weení waama ɩɖɔɔ́ adɛ ɖɩzɩɩrɛ fɛ́yɩ́ nɛ́. Búúzi-daá lɩ́m wɔɔgɔ́nɩ biyóo kɛ nɛ́, ngɛ kaajáŋ kasála, kabá konúúdi.» ");
INSERT INTO kdh_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yeésu waaŋmátɩ zamɔ́ɔ kínwelesí yɩ nɛ́ tɔ́mwá tɩḿ tɩrɩ́ŋa bɩtɛ́ nɛ́, ngɛ waagʊrʊ́ ibó Kapɛrɩnawʊ́m tɛ́ɛ́dɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tɛ́ɛ́dɩ tɩḿ tɩdaá, Róóma sɔ́ɔ́ja kʊ́bɔnɩ́ naárʊ wɛ ńna, ɩwɛná bɔwʊtá-dʊ́ʊ naárʊ ɩbá ɩzɔɔlɛ́ɛ ɩdɔ́m. Bɔwʊtá-dʊ́ʊ ɩmʊ́ ɩbá wánnyaadɩ́ wánlʊwɔ́ɔ na sɩ́m. ");
INSERT INTO kdh_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Róóma sɔ́ɔ́ja kʊ́bɔnɩ́ ɩmʊ́ waanɩ́ɩ bánŋmatɩ́ Yeésu-dɛ́ɛ tɔ́m nɛ́, ngɛ weedíri Yahúúɖuwá-dɛ́ɛ kʊ́bɔnáa nɛbɛ́rɛ ɩjɔ́ sɩ bakávɩ́nɩ yɩ sɩsɩ ɩ́kɔnɩ ɩwáázɩ ɩdɛ́ɛ bɔwʊtá-dʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Baadála Yeésu-jɔ́ nɛ́, ngɛ baabá babáázɩ yɩ kɩvɩ́nʊ́ʊ sɩsɩ: «Ɩrʊ́ ɩmʊ́ ɩmɔɔ́na nlɛ́ɛ yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ɩzɔɔlɛ́ɛ ɖɛ́dɛ́ɛ laadɔ́ɔ, hálɩ weeyele ná bama ɖɛ́dɛ́ɛ Ɩsɔ́ɔ ɖaazɛɛɖɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ńna gɛ boovu Yeésu bɔkpɔ́ɔ nɩ́bááwʊ bɛ́nɖɛɛ́. Wáńjʊ́ʊ́ná ɖaána gɛ Róóma ńba-dɛ́ɛ sɔ́ɔ́ja kʊ́bɔnɩ́ weedíri ɩɖɔndɩnáa sɩsɩ béfeeri yɩ sɩsɩ: «Kʊ́bɔnɩ́, nkatánnaazɩ nyádɩ, káma, mádatála nzʊ́ʊ máɖaána-daá; ");
INSERT INTO kdh_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","bɩlɛ́ bʊrɔ gɛ mádacáa mádɩtɩŋa mobó nyɔ́jɔ́. Amá, ŋmatɩ tɔ́m bú kʊ́ɖʊḿ na mɛ́dɛ́ɛ bɔwʊtá-dʊ́ʊ ɩwáa. ");
INSERT INTO kdh_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mádɩtɩŋa mɔ́wɛná mágʊ́bɔnáa, bɩka mɔ́wɛná sɔ́ɔ́jawá mɛ́dɛ́ɛ́zɩ́ mɛ́dɛ́ɛ tɩmɛ́rɛ-daá. A mɔ́ɔ́dɔ́ kʊ́ɖʊḿ sɩsɩ: “Ɖɛɛ,” wɛ́nɖɛɛ́ gɛ; a mɔ́ɔ́dɔ́ lí ńnɩ́ sɩsɩ: “Kɔnɩ,” wɔ́ngɔnɩ́ gɛ; ngɛ a mɔ́ɔ́dɔ́ mɛ́dɛ́ɛ bɔwʊtá-dʊ́ʊ sɩsɩ: “La ɖɔ́,” wánlám gɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yeésu waanɩ́ɩ bɩlɛ́ nɛ́, bɩɩbá bɩlá yɩ mááɖé, ngɛ wɛɛgɛ́ɛ́zɩ ɩtɔ́ zamɔ́ɔ kiigóvú yɩ nɛ́ sɩsɩ: «Ménveerím mɩ́ɩ toovonúm sɩsɩ báa Israyɛ́ɛlɩ ńba-daá, mádanáá ta toovonúm-fáa ńŋɩnáa bɩna bɩdaká.» ");
INSERT INTO kdh_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Wenbá beegédiri wɛ nɛ́, bɔɔlɔ́ɔ babɩ́sɩ Róóma ńba-dɛ́ɛ sɔ́ɔ́ja kʊ́bɔnɩ́-dɛ́ɛ ɖaána-daá, ngɛ bɔɔmɔɔná bɔwʊtá-dʊ́ʊ wáńwáá. ");
INSERT INTO kdh_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Bʊwɔ́rɔ́ nɛ́, Yeésu wɛɛɖɛ́ɛ tɛ́ɛ́dɩ natɩ́rɩ bánÿaá tɩ sɩsɩ Nayíini nɛ́ tɩdaá, ngɛ ɩwanbaaráa na zamɔ́ɔ kʊ́bɔńgɩ fóo yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Sáátɩ wenkí waajʊʊná tɛ́ɛ́dɩ-daá ɖaazʊʊnáɖɛ nɛ́, waana bazʊwáána ɩsɩɖʊ́ bɛ́nɖɛɛnáa bím. Ɩsɩɖʊ́ ɩmʊ́ nɛ́, alʊ́ leelú naárʊ biyaalʊ́ gɛ bɩgɛ́ɛ. Iriké gɛ bɩɩva yɩ. Tɛ́ɛ́dɩ-daá ɩráa ɖabata waagálaazɩ alʊ́ ɩmʊ́. ");
INSERT INTO kdh_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ɖádʊ́ʊ Yeésu waana alʊ́ ɩmʊ́ nɛ́, bɩɩbá bɩlá yɩ kʊnyɔḿ, ngɛ wɔɔdɔ́ yɩ sɩsɩ: «Yele wíídi.» ");
INSERT INTO kdh_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ngɛ woodúu itekiná amákaá; ńna gɛ wenbá bazʊwáána kɩ nɛ́ baazɩ́ŋ. Ngɛ Yeésu wɔɔdɔ́ sɩsɩ: «Afobú, mazɩ kʊrʊ́, mɔ́ɔ́dɔ́ ná!» ");
INSERT INTO kdh_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ngɛ ɩsɩɖʊ́ waagʊrʊ́ ɩcɔ́ɔ ɩbáázɩ ŋmatɩrɛ. Ngɛ Yeésu weejéle yɩ ɩgɔɔ. ");
INSERT INTO kdh_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nɩdáárɛ kʊ́bɔnbɔńɖɛ waagba barɩ́ŋa, ngɛ baabáázɩ Ɩsɔ́ɔ sám bɔ́ndɔ́m sɩsɩ: «Anɖébi kʊ́bɔnɩ́ naárʊ waaɖʊ ɩlɩ́ɩ ɖɔ́lɔ́wʊ́táá! Ɩsɔ́ɔ wɔɔgɔ́nɩ isúlu ɩdɛ́ɛ zamɔ́ɔ-rɔ ɩlɛ́ɛ kɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ngɛ wenbí Yeésu waalá nɛ́, woozuná Yudée laadɔ́ɔ rɩ́ŋa na kɩdɛ́ɛ fáráńdɩ́wá. ");
INSERT INTO kdh_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yaayá-dɛ́ɛ wanbaaráa woobó bakádɩ tɔ́mwá tɩḿ tɩrɩ́ŋa befééri yɩ, ngɛ ɩlɛ́ waalɩzɩ́ badaá nɔɔ́lɛ ");
INSERT INTO kdh_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","itíri Ɖádʊ́ʊ Yeésu-jɔ́ bɔkɔ́bɔɔzɩ yɩ sɩsɩ: «Nyánáábɩ́lɛ́ weení sɩsɩ wɔ́ngɔnɩ́ nɛ́ yáá ɖándasɩ́ ɖɩɖáŋ naárʊ.» ");
INSERT INTO kdh_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bɛlɛ́ baadála Yeésu-jɔ́ nɛ́, ngɛ bɔɔdɔ́ yɩ sɩsɩ: «Yaayá weegédíri ɖáa sɩsɩ ɖɩ́bɔɔzɩ nya sɩsɩ nyánáábɩ́lɛ́ weení sɩ ɩkɔ́nɩ nɛ́ yáá ɖándasɩ́ ɖɩɖáŋ naárʊ.» ");
INSERT INTO kdh_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Bɩɩjáŋ bɩdɛ́ɛ sáátɩ kɩḿ, Yeésu waawáázɩ kʊdɔndɩnáa ɖabata, ɩwáázɩ ɩráa ɖabata bɛ́nÿɛlɛ́ŋ nɛ́, na wenbá zííniwá wánjaarɩ́ wɛ nɛ́, bɩka iyéle njɛma ɖabata ɩbáázɩ náa. ");
INSERT INTO kdh_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Bʊwɔ́rɔ́ gɛ woobúsi Yaayá-dɛ́ɛ tɩndɩnáa sɩsɩ: «Ibó ifééri Yaayá wenbí mɩ́ɩ́ná na wenbí mɩ́ɩ́nɩ́ɩ nɛ́: Njɛma wánnáa bɩka gaala‑gáálásɩ wánnʊŋɛ́, cɛnɩ́sɩ waawáa sɩlá ɖacɩrɩ‑cɩrɩ, ndamáa wánnɩɩ́, ɩsɩɖáa wénvém, bɩka bénveerím kadanbʊrʊ́sɩ Laabáárʊ Kífeńgi. ");
INSERT INTO kdh_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Wenbi‑niíni-dʊ́ʊ gɛ weení ɩdɛbɛ́ɖɩ toovonúm waava ma nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Sáátɩ wenkí Yaayá-dɛ́ɛ wanbaaráa wɛɛɖɛ́ɛ nɛ́, ngɛ Yeésu wɔɔgbɔ́ɔ wánŋmatɩ́ zamɔ́ɔ Yaayá-rɔ sɩsɩ: «Wé gɛ mííbó ɩkɛ́bɛ́ɛŋ tɛɛwʊ́lɔ́ɔ́-daá. Ɖɩgɛrɛ́ fefelimá wónÿuúdi ɖɛ nɛ́? Aayɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Bɩlɛ́ nɛ́, wé gɛ mííbó ɩkɛ́bɛ́ɛŋ. Ɩrʊ́ izóóna tókowá kífeńdi nɛ́? Wenbá bónzuú tókowá kífeńdi bɩka bɔjɔɔ́ɔ bɩzaláa wɛ́ nɛ́ wɛ wúrowá-dɛ́ɛ kowuro-ɖɛ́ɛ́zɩ-daá gɛ. ");
INSERT INTO kdh_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Bɩlɛ́ nɛ́, we gɛ mííbó ɩkɛ́bɛ́ɛŋ. Anɖébi? Ɩɩ́n, bɩlɛ́ gɛ ménveerím mɩ́ɩ. Hálɩ waagɩ́lɩ anɖébi. ");
INSERT INTO kdh_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Káma, Yaayá-dɛ́ɛ tɔ́m gɛ Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá waaŋmátɩ sɩsɩ: “Méndiríi mɛ́dɛ́ɛ tɩndʊ́ʊ nyáázá-daá ɩnyɔ́ɔ́zɩ nya nɩ́bááwʊ.” ");
INSERT INTO kdh_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ménveerím mɩ́ɩ sɩsɩ ɩráa-daá, naárʊ tɔcɔ́ɔ waagɩ́lɩ Yaayá nɛ́. Ngʊ́ nbɛ́ɛ́ŋ nɛ́, weení ɩgɛ́ɛ kúmuú Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-daá nɛ́ waagɩ́lɩ yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ɩráa rɩ́ŋa weewélesi Yaayá, bɩkpɛdɩ́na tikée mʊʊráa; ngɛ beeɖéézi Ɩsɔ́ɔ, bʊrɔɔzɩ́ gɛ beeyéle Yaayá ilíri wɛ lɩ́m-daá ɩsɔ wɛ túúbá lɩ́m. ");
INSERT INTO kdh_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Amá, Faríizi ńba na Mará wɩlɩɖáa weegízi wenbí Ɩsɔ́ɔ wánvʊnjaanáa wɛ nɛ́ bekízi Yaayá telíri wɛ lɩ́m-daá ɩsɔ wɛ túúbá lɩ́m.» ");
INSERT INTO kdh_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ngɛ Yeésu waadásɩ ɩtɔ́ sɩsɩ: «Weení gɛ mánbɩɩzɩ́ mɛgɛɛzɩná zaamáánɩ kɩna kɩdɛ́ɛ ɩráa. Weení gɛ baalɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bɔjɔɔ́ɔ gɛ nyazɩ bíya bɔjɔɔ́ɔ wɔnɔɔ́ kʊ́bɔńga-daá bɔ́ndɔ́m baranáa sɩsɩ: “Ɖáávʊ́lʊ mɩ́ɩ foyísi, amá, mɩ́dabáa. Ɖéédée lííya yéńdi, mɩ́dɛ́mɛ́ɛ́dɩ iwíi,” nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Káma, Yaayá wɔɔgɔ́nɩ nɛ́, ideɖi kíɖíím ngʊ́ ɩdɔnyɔ́ɔ sʊlʊ́m, ngɛ mɩ́ɩ́dɔ́ sɩsɩ ɩwɛná zííni. ");
INSERT INTO kdh_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ɩrʊ́ Biyaalʊ́ wɔɔgɔ́nɩ nɛ́, wénɖíi wɔ́nnyɔɔ́. Ngɛ mɩ́ndɔ́m sɩsɩ: “Ɩbɛ́ɛ ceení, ɖiirú na sʊlʊ́m nyɔɔrʊ́ gɛ ɩgɛ́ɛ; tikée mʊʊráa na alaháácɩ́-dɩnáa gɛ ɩɖɔndɩnáa.” ");
INSERT INTO kdh_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Amá, wenbá barɩ́ŋa baava Ɩsɔ́ɔ-dɛ́ɛ áséńsí toovonúm nɛ́, beeɖéézi sɩsɩ kɩzɩɩzɛ́ɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Wɩ́rɛ gɛ Faríizi ńnɩ́ naárʊ waayáa Yeésu sɩsɩ ɩ́kɔnɩ iɖi kíɖíím ɩdɛ́ɛ. Ngɛ Yeésu woobó ɩrʊ́ ɩmʊ́ ɩdɛ́ɛ bɔjɔɔ́ɔ bénɖíi kíɖíím. ");
INSERT INTO kdh_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Alʊ́ wásangarɩ́ naárʊ wɛ tɛ́ɛ́dɩ tɩḿ tɩdaá. Alʊ́ ɩmʊ́ waanɩ́ɩ sɩsɩ Yeésu wɛ Faríizi ńnɩ́-dɛ́ɛ ɖaána wénɖíi kíɖíím nɛ́, ngɛ waagázʊʊ ɩ́gana kpárábá kazɔ́ɔ ńgɩ nakɩ́rɩ tulaarɩ́ woozu kɩdaá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Wɛɛgɛɛ ná Yeésu wɔ́rɔ́ ɩlɛ́ ɩnʊvɔ́-jɔ́ wénwií bɩka ɩdɛ́ɛ nzʊlʊ́m wéndím Yeésu nʊvɔ́-rɔ. Ngɛ waavɩɩzɩná yɛ na ɩnyɔ́ɔ́zɩ, ɩkparásɩ yɛ, ngɛ waabɩ́rɩ tulaarɩ́ arɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Faríizi ńnɩ́ weení waagáyáa Yeésu kíɖíím ɖíi nɛ́ waana bɩlɛ́ nɛ́, ɩwɛ wɔ́ndɔ́m ɩdaá sɩsɩ: «A toovonúm ɩrʊ́ ceení ɩ́fʊ́ngɛ́ɛ anɖébi, ɩraadɩlɩ́ weení alʊ́ ceení wéndekináa yɩ ɖɔ́ nɛ́ kɛ́ɛ nɛ́; ɩraadɩlɩ́ sɩsɩ wásangarɩ́ gɛ ɩgɛ́ɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ńna gɛ Yeésu wɔɔdɔ́ yɩ sɩsɩ: «Simɔ́ɔnɩ, mɔ́wɛná natɩ́rɩ sɩ maŋmátɩ nya.» Ngɛ Simɔ́ɔnɩ sɩsɩ: «Ŋmatɩ, kʊ́bɔnɩ́.» ");
INSERT INTO kdh_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ngɛ Yeésu sɩsɩ: «Ɩráa nɔɔ́lɛ weeɖi ná kʊ́bɔnɩ́ naárʊ kɩmɛ́rɛ. Badaá kʊ́ɖʊḿ-dɛ́ɛ kɩmɛ́rɛ kɛ́ɛ wɛ́ kákpɩ́ɩ́zɩ nasɩ́lɛ na nɩɩ́nʊ́wá (500) tɩmɛ́rɛ liideé, bɩka sɩɩlɛ ńnɩ́ wɛ́ nɛɛ́saaláa (50) tɩmɛ́rɛ liideé. ");
INSERT INTO kdh_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ńŋɩnáa badaá báa naárʊ tánbɩɩzɩ sɩ ɩfɛ́rɛ yɩ nɛ́, ngɛ wɛɛjɛ́ wɛ barɩ́ŋa. Tɔ́ɔ, bɛlɛ́ɛ́nɩ́ badaá, weení wánbá kʊ ɩsɔ́ɔ́lɩ kʊ́bɔnɩ́ ɩmʊ́ bɩkɩ́lɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ngɛ Simɔ́ɔnɩ woobúsi yɩ sɩsɩ: «Mɛ́dɛ́ɛ bɛɛŋ́-daá nɛ́, weení ɩgɩmɛ́rɛ waabá ɖɩɖɔ́ɔ ngɛ bɛɛjɛ́ yɩ nɛ́ gɛ.» Ngɛ Yeésu sɩsɩ: «Nyóóbúsi kazɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ńna gɛ Yeésu waavaná alʊ́ ɩzá, ngɛ wɔɔdɔ́ Simɔ́ɔnɩ sɩsɩ: «Yaa nyááná alʊ́ ceení ya; máagázʊʊ nyáɖaána-daá nɛ́, ńdáfá ma lɩ́m sɩsɩ mazám mɔ́nʊvɔ́. Amá, ɩlɛ́ waazám yɛ na ɩdɛ́ɛ nzʊlʊ́m bɩka ɩfɩɩzɩná yɛ na ɩnyɔ́ɔ́zɩ. ");
INSERT INTO kdh_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ńdékpíríki ma, amá, ɖoo ɩlɛ́ waagázʊʊ nɛ́, mɔ́nʊvɔ́ gɛ ɩlɔɔ́na kparásɩ wónbusí ɖɔ́. ");
INSERT INTO kdh_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ńdábɩ́rɩ mágʊjʊʊ́-rɔ núm, amá, ɩlɛ́ waabɩ́rɩ mɔ́nʊvɔ́-rɔ tulaarɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Bʊrɔɔzɩ́ nɛ́, ménveerím nya sɩsɩ ɩdɛ́ɛ alaháácɩ́wá waabá bʊɖɔ́ɔ gɛ, bɛɛjɛ́ tɩ; biiyéle waawɩ́lɩ sɔɔlɩ́m bɩbá bʊɖɔ́ɔ. Amá, weení bɛɛjɛ́ yɩ cɩ́kɔ nɛ́, wánwɩlɩ́ɩ sɔɔlɩ́m cɩ́kɔ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ngɛ Yeésu wɔɔdɔ́ alʊ́ sɩsɩ: «Mɛ́ɛ́jɛ́ nyɛ́dɛ́ɛ alaháácɩ́wá.» ");
INSERT INTO kdh_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Wenbá bɔwɛ ńna bénɖíi kíɖíím bána yɩ nɛ́, bɔwɛ bɔ́ndɔ́m badaá sɩsɩ: «Ɩrʊ́ ceení gɛ weení gɛ hálɩ wɛ́njɛ́m alaháácɩ́wá ye.» ");
INSERT INTO kdh_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ngɛ Yeésu wɔɔdɔ́ alʊ́ sɩsɩ: «Bo nɖɛ́ɛ bɩka njɔ́ɔ Ɩsɔ́ɔ-dɛ́ɛ fɛɛzɩrɛ-daá, nyɛ́dɛ́ɛ toovonúm fáa wɛɛlɛ́ɛ nya.» ");
INSERT INTO kdh_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Bɩlɛ́ bʊwɔ́rɔ́ gɛ Yeésu wɛɛɖɛ́ɛ tɛ́ɛ́dɩwá na tɛɛbíízi-daá wánlám waázu bɩka wénveerím Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-dɛ́ɛ Laabáárʊ Kífeńgi. Ɩwanbaaráa fuú na nɔɔ́lɛ fóo yɩ, ");
INSERT INTO kdh_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","bɩtasɩná aláa nɛbɛ́rɛ wenbá Yeésu wɔɔɖɔ́ɔ zííniwá bɔrɔ nɛ́, na wenbá waawáázɩ wɛ kʊdɔmɩ́nɩ nɛ́: bɛɛ Marɩyáma bánÿaá yɩ sɩsɩ Magɩdaláa alʊ́ Yeésu wɔɔɖɔ́ɔ zííniwá lʊbɛ ɩrɔ nɛ́; ");
INSERT INTO kdh_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yuháána, Eróodi-dɛ́ɛ tɩmɛlanɖáa-rɔ bɛɛŋɩrʊ́ Kúúza ɖɛɛlʊ́, na Suuzáána, na aláa ɖabata nɛbɛ́rɛ ɖʊɖɔ. Aláa bɛḿ bɔ́ngbɔwʊ́ʊ wenbí bɔwɛná nɛ́ bánzɩnáa Yeésu na ɩwanbaaráa. ");
INSERT INTO kdh_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Zamɔ́ɔ kʊ́bɔńgɩ woodúúzi; ɩráa waagálɩ́ɩ́ná tɛ́ɛ́dɩwá ndɩ‑ndɩ-daá bɔkɔ́nɩ ɩjɔ́, ngɛ waaŋmatɩná wɛ na tɔmgɛɛzɩrɛ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Ɩrʊ́ naárʊ woobo ná ɩvɔɔ́-daá kúɖúúdi larɩ́ɩ. Wánlarɩ́ɩ nɛ́, ngɛ natɩ́rɩ waazála nɩ́bááwʊ‑nɩ́bááwʊ, nɩ́baaɖɛɛráa ɩnʊ́ŋ tɩrɔ, ngɛ siḿsi wɔɔgɔ́nɩ siɖi tɩ. ");
INSERT INTO kdh_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Natɩ́rɩ waazála bɔ́-daá; tɩɩnyɔ nɛ́, ngɛ tɩɩwɩ́lɩ, káma, adɛ fɛ́yɩ́ kaanɩŋá. ");
INSERT INTO kdh_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kúɖúúdi natɩ́rɩ waazála sɔɔzɔ́ɔ́zɩ-daá, ngɛ tɩ́na sɔɔzɔ́ɔ́zɩ tiiyóózi tɩnyɔ, sɔɔzɔ́ɔ́zɩ ɩnyʊʊ́ tɩ. ");
INSERT INTO kdh_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Natɩ́rɩ waazála tɛ́ɛ́dɩ kazɔ́ɔ ndɩ-daá. Ngɛ tɩlɛ́ tɩɩɖʊ bíya, tikú báa wenkí-rɔ, bíya nɩɩ́nʊ́wá.» Ngɛ Yeésu waaŋmátɩ bɩcáárɩ sɩsɩ: «Weení ɩwɛná nɩgbamɩ́nɩ nɛ́, ɩ́nɩɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ngɛ wanbaaráa wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Tɔmgɛɛzɩrɛ ɖɩḿ ɖugutoluú gɛ sɩsɩ wé.» ");
INSERT INTO kdh_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ńna gɛ Yeésu woobúsi wɛ sɩsɩ: «Mɩ́nyɔ́ɔ́ nɛ́, Ɩsɔ́ɔ waava mɩ́ɩ sɩsɩ ɩ́tɩ́lɩ́ ɩdɛ́ɛ kowúrɔ́ɔ-dɛ́ɛ ásííríwá. Amá, baaganáa nɛ́, tɔmgɛɛza-daá gɛ bánwɩlɩnáa wɛ, na: “Bɛbɛɛ́na bɩka bádánnáa, bénwelesí bɩka bádánnɩɩ.”» ");
INSERT INTO kdh_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Tɔmgɛɛzɩrɛ ɖɩḿ ɖugutoluú nɖɔ́: kúɖúúdi gɛ Ɩsɔ́ɔ-dɛ́ɛ tɔ́m. ");
INSERT INTO kdh_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nɩ́bááwʊ‑nɩ́bááwʊ lénlé kúɖúúdi waazála nɛ́ gɛ ɩráa wenbá baanɩ́ɩ Ɩsɔ́ɔ-dɛ́ɛ tɔ́m, ngɛ Sitáánɩ wɔɔgɔ́nɩ nɛ́, wɛɛgbɛzɩ́ tɔ́m tɩḿ bewenbé-daá na bʊcɔ bákafa toovonúm bɩka boyuú lɛ́ɛ́dɩ. ");
INSERT INTO kdh_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Bɔ́-daá lénlé kúɖúúdi waazála nɛ́ gɛ ɩráa wenbá baanɩ́ɩ Ɩsɔ́ɔ-dɛ́ɛ tɔ́m na bacáŋ bamʊ tɩ na wenbi‑niíni nɛ́. Amá, bedeyéle tɔ́m tɩḿ tɩnyɔ wóózi: bánváa toovonúm alɩwáátɩ nakɩ́rɩ gɛ, ngɛ a nɔwɛ́ya waadála kɩmɔɔná wɛ, na babɩ́sɩ bɔwɔ́rɔ́. ");
INSERT INTO kdh_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Sɔɔzɔ́ɔ́zɩ-daá lénlé kúɖúúdi waazála nɛ́ gɛ ɩráa wenbá bánnɩɩ́ Ɩsɔ́ɔ-dɛ́ɛ tɔ́m na beyéle lomaazɛ́ na ɖɔ́ɔ́lɛ na ɖúúlínya-dɛ́ɛ kɔɖɛyɩ́wá ɩkɔ́nɩ bɩnyʊʊ́ tɩ bɩka bádánɖʊ́ʊ bíya bɛsɛ́ɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Tɛ́ɛ́dɩ kazɔ́ɔ ńdɩ-daá lénlé kúɖúúdi waazála nɛ́ gɛ ɩráa wenbá bánnɩɩ́ Ɩsɔ́ɔ-dɛ́ɛ tɔ́m, ngɛ bánmʊ́ʊ tɩ na wenbiré kʊ́ɖʊńɖɛ bɩka bɔ́nɖɔkɩ́ tɩ bánjaarɩ́ badɩ hálɩ baɖʊ bíya nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yeésu wɔɔdɔ́tɔḿ wɛ sɩsɩ: «Bɔ́dɔ́nzɔḿ fɩtɩ́la na bɔkpɔ́ɔ gbégídi bofu kɩrɔ yáá basɩ́ɩ kɩ gáɖó-dɛ. Amá, bɔ́ngbɔwʊ́ʊ kɩ gɛ batɩ́nɩ ɩsɔ́ɔ́dáá na wenbá bángazʊʊ́ nɛ́ bana ɖɛnyɛm. ");
INSERT INTO kdh_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Káma, nabʊ́rʊ fɛ́yɩ́ bɩmʊ́sɛ́ɛ bɩ́dánlɩɩ bana bɩ nɛ́, cáńfáná ásíírí bádándɩlɩ́ kɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Iguná laakáarɩ na nŋɩ́nɩ́ mɩ́nnɩɩ́ nɛ́, káma, weení ɩwɛná nɛ́, bándasɩ́ yɩ. Amá, weení ɩvɛ́yɩ́na nɛ́, bɛ́nlɛɛ́ bɩkpɛdɩ́na cʊ́kɔyɔ́ɔ wenká wánmaazɩ́ sɩsɩ ɩwɛná kɛ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yeésu ɩgɔɔ na igoobíya bɔɔgɔ́nɩ ɩjɔ́, amá, zamɔ́ɔ-rɔ nɛ́, bádánbɩɩzɩ bobó hálɩ ɩjɔ́. ");
INSERT INTO kdh_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ngɛ naárʊ veevééri yɩ sɩsɩ: «Bɛɛ ngɔɔ na ngoobíya bɔwɛ asʊ bánjáádɩ sɩsɩ bana nya.» ");
INSERT INTO kdh_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ngɛ woobúsi wɛ sɩsɩ: «Mɔgɔɔ na mogoobíya gɛ wenbá bánnɩɩ́ Ɩsɔ́ɔ-dɛ́ɛ tɔ́m bɩka bónvúu bánlám wenbí tɩ́nbɔɔzɩ́ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wɩ́rɛ neɖére gɛ Yeésu na ɩwanbaaráa baagba kpɩ́ɩ́rʊʊ́-daá, ngɛ wɔɔdɔ́ wɛ sɩsɩ: «Ɖɩ́tɛsɩ lɩɩrɛ́ kʊ́bɔńɖɛ-dɛ́ɛ fúu lí ńgɩ-rɔ.» Ngɛ bɛɛɖɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Babamáa kpɩ́ɩ́rʊʊ́ saá bɛ́nɖɛɛ́ nɛ́, Yeésu wooɖóo. Ngɛ fefelimá kʊ́bɔná naárɛ waajáŋ abáázɩ fɛtɩ́ na ɖóni lɩɩrɛ́ kʊ́bɔńɖɛ-rɔɔzɩ́; lɩ́m waabáázɩ kpɩ́ɩ́rʊʊ́-daá sʊʊ́ bínzúu hálɩ bɛ́nɖɛɛ́ sɩ́m nɔɔ́. ");
INSERT INTO kdh_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ngɛ wanbaaráa woodúu Yeésu-jɔ́ beféézi yɩ bɔ́ndɔ́m sɩsɩ: «Kʊ́bɔnɩ́, Kʊ́bɔnɩ́, ɖánzɩ́m!» Yeésu weevé, ngɛ waagazɩ́ fefelimá na lɩmvolá. Ngɛ bɩrɩ́ŋa bɩɩzála bɩcɔ́ɔ ɖɛfɛɛ. ");
INSERT INTO kdh_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Bʊwɔ́rɔ́ gɛ Yeésu wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «Lé gɛ mɩ́dɛ́ɛ toovonúm fáa wɛ.» Nɩdáárɛ waalá wɛ, bɩlá wɛ bítí hálɩ bɔ́nbɔɔzɩ́ ɖamá sɩsɩ: «Ɩrʊ́ weení gɛ ceení bɩlɛ́ gɛ bɩkpɛdɩ́na fefelimá na lɩ́m wánlám wenbí wɔ́nbɔɔzɩ́ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yeésu na ɩwanbaaráa boobó batála Geraseníi ńba-dɛ́ɛ laadɔ́ɔ-rɔ; laadɔ́ɔ kɛḿ na Galilée laadɔ́ɔ baazá fáána ɖamá gɛ. ");
INSERT INTO kdh_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Sáátɩ wenkí baalɩ́ɩ kpɩ́ɩ́rʊʊ́-daá betí adɛ nɛ́, ngɛ tɛ́ɛ́dɩ-daá ɩrʊ́ naárʊ wɔɔgɔ́nɩ sɩ ɩsɩ́ŋ yɩ. Ɩrʊ́ ɩmʊ́, zííniwá ɩbaná tɩ́njaarɩ́ yɩ. Bɩɩbá bɩlá wɛ́ náálɛ ídóndosuu kpɩná bɩka ɩ́dánzʊʊ ɖaána nɛkɛ́rɛ-daá nɛ́, bɔɔláánɩ-daá gɛ ɩwɛ. ");
INSERT INTO kdh_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Waana Yeésu nɛ́, ngɛ waamá kebiká, ɩcɛ́ ɩsála ɩlɛ́ ɩnʊvɔ́-dɛ wóngoó wɔ́ndɔ́m sɩsɩ: «We gɛ nyɔ́zɔɔlɛ́ɛ na ma, Yeésu Ɩsɔ́ɔ bílí‑bílí-dʊ́ʊ Biyaalʊ́. Máávɩ́nɩ nya, nkanáázɩ ma.» ");
INSERT INTO kdh_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Káma, Yeésu waaŋmatɩná zííni ɩsɩ́ɩ́zɩ kɩ sɩsɩ kɩ́lɩɩ ɩrʊ́ ɩmʊ́ ɩrɔ. Wenbí bʊrɔɔzɩ́ nɛ́, zííni kɩḿ kɩɩbá kɩlɔɔná ɩrʊ́ ɩmʊ́ caarɩ́ gɛ. Na babɩ́ɩ́zɩ basɩ́ɩ yɩ ɖɩdáarɛ kʊ́ɖʊńɖɛ nɛ́, bɔ́nvɔkɩ́ yɩ na agbarangbára na nyɩɩrɩ́tɩ gɛ. Amá, waalaaná bɩlɛ́ bɩrɩ́ŋa cɛ́m, bɩka zííni wónbonáa yɩ faɖáma-daá lénlé ɩráa fɛ́yɩ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ngɛ Yeésu wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Sɩsɩ wé gɛ bánÿaá nya.» Ngɛ ɩrʊ́ ɩmʊ́ sɩsɩ: «Tuutúúma». Káma, zííniwá ɖabata fóo na kʊ yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Bɩka tɩ́nvɩnɩ́ Yeésu sɩsɩ íkeyéle tɩḿ tɩsʊ́ʊ azáába-daá. ");
INSERT INTO kdh_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ngʊ́ lénlé bɔwɛ nɛ́, bʊ́ʊ cʊ́ʊ́na wɛ. Bɩka afawá tuutúúma natɩ́rɩ wɛ bʊ́ʊ-rɔ tínɖíi. Ngɛ zííniwá waavɩ́nɩ yɩ sɩsɩ íyéle tɩḿ tibó tɩsʊ́ʊ afawá tɩḿ. Ngɛ ɩlɛ́ waava tɩ nɩ́bááwʊ. ");
INSERT INTO kdh_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ńna gɛ zííniwá waalɩ́ɩ ɩrʊ́ ɩmʊ́ ɩrɔ tibó tɩsʊ́ʊ afawá, ngɛ afawá fuúre rɩ́ŋa waagálɩɩ bʊ́ʊ-rɔ tise tɩsála lɩɩrɛ́ kʊ́bɔńɖɛ-daá, lɩ́m iɖi tɩ tɩsɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Tɩdɛ́ɛ ketiráa waana wenbí bɩɩlá nɛ́, ngɛ beeze bobó bekéveeri tɛ́ɛ́dɩ-daá na fásɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ngɛ ɩráa wɔɔgɔ́nɩ sɩ bɛbɛ́ɛ́ŋ wenbí bɩɩlá nɛ́. Baadála Yeésu-jɔ́ nɛ́, baana ɩrʊ́ weení zííniwá waalɩ́ɩ ɩrɔ nɛ́ ɩjɔɔ́ɔ Yeésu nʊvɔ́-jɔ́ izóóna kpɩná bɩka ɩ́na ɩdɩ. Ńna gɛ bɩɩbá bɩlá wɛ nɩdáárɛ. ");
INSERT INTO kdh_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Wenbá baana wenbí bɩɩlá nɛ́, baadɩ́ nŋɩ́nɩ́ bɩɩlá hálɩ zííniwá-dʊ́ʊ iyuú alaafɩ́ya nɛ́ befééri baaganáa. ");
INSERT INTO kdh_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ńna gɛ Geraseníi laadɔ́ɔ-daá ɩráa rɩ́ŋa wɔɔdɔ́ Yeésu sɩsɩ ɩ́lɩɩ bɛḿ balaadɔ́ɔ-daá ɩɖɛ́ɛ bolíni; wenbí bʊrɔɔzɩ́ nɛ́ nɩdáárɛ kʊ́bɔńɖɛ waabá ɖɩkpa wɛ. Ngɛ Yeésu waagba kpɩ́ɩ́rʊʊ́-daá sɩ ɩbɩ́sɩ. ");
INSERT INTO kdh_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ɩrʊ́ weení zííniwá waalɩ́ɩ ɩrɔ nɛ́ waavɩ́nɩ yɩ sɩsɩ íyele ɩmʊ́ ifu yɩ. Amá, Yeésu weegízi ɩtɔ́ yɩ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Bɩsɩ nyɛ́dɛ́ɛ bɩka ndɩ́ wenbí bɩrɩ́ŋa Ɩsɔ́ɔ waalá nya nɛ́ nvééri.» Ngɛ ɩrʊ́ ɩmʊ́ wɛɛɖɛ́ɛ ɩbáázɩ ɩráa feerím tɛ́ɛ́dɩ rɩ́ŋa-daá wenbí bɩrɩ́ŋa Yeésu waalá yɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yeésu waadála lɩɩrɛ́ kʊ́bɔńɖɛ-dɛ́ɛ fúu lí ńgɩ-rɔ nɛ́, zamɔ́ɔ kɩvʊnwɛ ńna kɩɖamáa yɩ nɛ́, kɩɩmʊ yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ńna gɛ ɩrʊ́ naárʊ wɔɔgɔ́nɩ ɩjɔ́, bánÿaá yɩ sɩsɩ Yááhíru. Yahúúɖuwá-dɛ́ɛ Ɩsɔ́ɔ ɖaazɛɛɖɛ́-dɛ́ɛ kʊ́bɔnɩ́ gɛ ɩgɛ́ɛ. Ngɛ wɛɛjɛ́ ɩsála Yeésu nʊvɔ́-dɛ wánvɩnɩ́ yɩ sɩsɩ ɩ́kɔnɩ ɩdɛ́ɛ ɖaána-daá. ");
INSERT INTO kdh_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Káma, ɩwɛná bú aléeré, iriké kóŋ́ gɛ bɩɩva yɩ. Bú ɩmʊ́ ɩwɛná bɩ́ɩ́zɩ fuú na nasɩ́lɛ gɛ, ngɛ ɩbá wánnyaadɩ́ wánlʊwɔ́ɔ na sɩ́m. Sáátɩ wenkí Yeésu wɔɔgbɔ́ɔ nɩ́bááwʊ wɛ́nɖɛɛ́ ńna nɛ́, zamɔ́ɔ fóo yɩ kɩbá kɩ́nyʊʊ́ yɩ cé na cé. ");
INSERT INTO kdh_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Alʊ́ naárʊ wɛ zamɔ́ɔ lɔwʊtáá ńna. Alʊ́ ɩmʊ́, azimá wéndináa yɩ bʊwɛná bɩ́ɩ́zɩ fuú na nasɩ́lɛ nbɩlɛ́. Weeɖi wenbí bɩrɩ́ŋa ɩwɛná bɩ nɛ́ lákʊ́tawá-jɔ́, amá, báa naárʊ tabɩ́ɩ́zɩ ɩwáázɩ yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Wɔɔgɔ́nɩ ɩcʊʊná Yeésu na bʊwɔ́rɔ́ itekiná ɩdɛ́ɛ tóko-dɛ́ɛ njʊ́ʊ́rɛ. Ngɛ azimá bíndináa yɩ nɛ́, bɩɩjáŋ bɩsɩ́ŋ. ");
INSERT INTO kdh_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ńna gɛ Yeésu wɔɔbɔ́ɔ́zɩ sɩsɩ: «Weení weedekiná na ma.» Tɔ́ɔ, ńŋɩnáa barɩ́ŋa bɔwɛ bɔ́njɔɔlɩ́ nɛ́, ngɛ Pétro sɩsɩ: «Kʊ́bɔnɩ́, zamɔ́ɔ woozuná na nya ngɛ kɩ́nnyʊʊ́ nya cé na cé.» ");
INSERT INTO kdh_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ngɛ Yeésu wɔɔdɔ́ yɩ sɩsɩ: «Ɩɩ́n, mányɩ bɩlɛ́, amá, naárʊ waabá itekiná ma. Káma mááná sɩsɩ ɖóni nabɩ́rɩ waalɩ́ɩ mɔ́rɔ́.» ");
INSERT INTO kdh_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Alʊ́ wooyuú ɩtɩlɩ́ sɩsɩ baadɩlɩ́ wenbí waalá nɛ́, wɔɔgbɔ́ɔ selíi ɩkɔ́nɩ ɩcɛ́ ɩsála Yeésu nʊvɔ́-dɛ; ngɛ waadɩ́ wenbí biiyéle gɛ weedekiná yɩ nɛ́ ifééri yɩ zamɔ́ɔ rɩ́ŋa ɩzá-daá, na nŋɩ́nɩ́ waajáŋ ɩwáa nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ńna gɛ Yeésu wɔɔdɔ́ yɩ sɩsɩ: «Mɛwɛɛlɛ́ɛ, bo nɖɛɛ ná alaafɩ́ya, nyɛ́dɛ́ɛ toovonúm fáa wɛɛlɛ́ɛ nya.» ");
INSERT INTO kdh_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ɩwɛ ɩbamáa ŋmatɩrɛ gɛ naárʊ waagálɩ́ɩ́ná Ɩsɔ́ɔ ɖaazɛɛɖɛ́-dɛ́ɛ kʊ́bɔnɩ́-dɛ́ɛ ɖaána ɩtála sɩsɩ: «Nwɛɛlɛ́ɛ waazɩ́, nkacáárɩ kʊ́bɔnɩ́ ɖʊɖɔ.» ");
INSERT INTO kdh_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Amá, Yeésu waanɩ́ɩ wentí baaŋmátɩ nɛ́, ngɛ weevééri Ɩsɔ́ɔ ɖaazɛɛɖɛ́-dɛ́ɛ kʊ́bɔnɩ́ sɩsɩ: «Nkanɩ́ɩ nɩdáárɛ, fa toovonúm ɖé, wánwaá.» ");
INSERT INTO kdh_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Waadála ɖaána nɛ́, ideyéle naárʊ ɩsʊ́ʊ ɩtasɩná yɩ, asée Pétro, na Yʊháánɩ, na Yaakúbu, na bú ɩgɔɔ na ɩjaa beriké. ");
INSERT INTO kdh_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Wenbá barɩ́ŋa bavʊnwɛ ńna nɛ́, bɔwɛ bénwií bɛ́nmɛɛdɩ́ ɩsɩɖʊ́-rɔɔzɩ́. Ńna gɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Íkewíi, ɩdasɩ́, wónɖóm gɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ngɛ bɛlɛ́ bɔwɛ bánmʊŋ́ yɩ, káma, banyɩ sɩsɩ bú waazɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ńna gɛ Yeésu wɔɔɖɔ́kɩ aléeréyɔ́ɔ nʊ́ʊ́nɩ, ngɛ waaŋmatɩná yɩ bɩcáárɩ sɩsɩ: «Búyɔ́ɔ, kʊrʊ́ nzɩ́ŋ.» ");
INSERT INTO kdh_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ngɛ bú weezuú waagábɩsɩ ɩcáŋ ɩkʊrʊ́ ńna‑ńna. Ngɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ báfá yɩ kíɖíím iɖi. ");
INSERT INTO kdh_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Bɩɩbá bɩlá ɩjaanáa bítí, amá, Yeésu waabásɩ wɛ sɩsɩ békefééri naárʊ wenbí bɩɩlá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yeésu woodúúzi ɩdɛ́ɛ tɩndɩnáa fuú na nɔɔ́lɛ, ngɛ waava wɛ ɖóni na yíko zííniwá rɩ́ŋa-rɔɔzɩ́ bɩka ɩfa wɛ yíko ɖʊdɔ sɩsɩ báwaazɩ kʊdɔmɩ́nɩ. ");
INSERT INTO kdh_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ngɛ weedíri wɛ sɩsɩ bóbo befééri Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-dɛ́ɛ Laabáárʊ Kífeńgi, bɩka bawáázɩ kʊdɔndɩnáa. ");
INSERT INTO kdh_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Wɔɔdɔ́ wɛ sɩsɩ: «A mɩ́nɖɛɛ́ ɩ́kɔkpɔ́ɔ nabʊ́rʊ, ɩ́kɔkpɔ́ɔ ɖɛ́nɩ, cáńfáná furuú, yáá kíɖíím, yáá liideé, ngʊ́ ɩ́kɔkpɔ́ɔ tókowá natɩ́ntɩ́lɛ. ");
INSERT INTO kdh_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","A mɩ́ɩ́dála gɛ mɩ́ɩ́zʊ́ʊ ɖaána wenká-daá nɛ́, ɩjɔ́ɔ ńna hálɩ ɩkɔ́nɩ ɩlɩ́ɩ fáráńdɩ́ kɩḿ. ");
INSERT INTO kdh_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","A mɩ́ɩ́dála lénlé gɛ beegízi badamʊ mɩ́ɩ nɛ́, ɩlɩ́ɩ ńna bɩka ikpíízi mɩ́nʊvɔ́-dɛ́ɛ buuruú ɩtalɩná wɛ: seríya kɩ́nwɩlɩ́ɩ sɩsɩ badala ná kazɔ́ɔ nɛ́ nbɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tɩndɩnáa waalɩ́ɩ bɛɖɛ́ɛ, ngɛ boobó bánzʊʊ́ bánlɩɩ́ tɛɛbíízi-daá bénveerím Laabáárʊ Kífeńgi bɩka bánwaazɩ́ kʊdɔndɩnáa báa lénlé. ");
INSERT INTO kdh_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Eróodi weení wénɖíi kowúrɔ́ɔ Galilée laadɔ́ɔ-rɔ nɛ́, waanɩ́ɩ bánŋmatɩ́ wenbí bɩrɩ́ŋa bɩ́nlám nɛ́. Ngɛ waasɩ wentí sɩ ɩtɔ́ nɛ́. Káma, nɛbɛ́rɛ wɛ bɔ́ndɔ́m sɩsɩ Yaayá weeve ná ɩlɩ́ɩ ɩsɩɖáa-daá. ");
INSERT INTO kdh_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Baaganáa sɩsɩ Elíya waaɖʊ ná ɩlɩ́ɩ. Nɛbɛ́rɛ ɖʊɖɔ sɩsɩ caanawʊ́ anɖébiwá-daá naárʊ weeve ná ɩlɩ́ɩ ɩsɩɖáa-daá. ");
INSERT INTO kdh_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Amá, Eróodi sɩsɩ: «Ngʊ́ mɔ́ɔ́ mééyéle bɛcɛ́ Yaayá kʊjʊʊ́; bɩlɛ́ nɛ́, ɩrʊ́ weení gɛ ceení gɛ mánnɩɩ́ bánŋmatɩ́ tɩna tɩrɩ́ŋa ɩrɔ bɩlɛ́.» Biiyéle waazʊ́ʊ cáádɩ sɩsɩ ɩna yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tɩndɩnáa waagábɩsɩ nɛ́, ngɛ baadɩ́ wenbí bɩrɩ́ŋa baagála nɛ́ befééri Yeésu. Ngɛ wooboná wɛ tɛ́ɛ́dɩ bánÿaá tɩ sɩsɩ Bɛtɩsayɩdáa nɛ́ tɩváráńdɩ́ ɩ́na wɛ balaná ɩráa bolíni. ");
INSERT INTO kdh_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ɩráa wooyuú batɩlɩ́ nɛ́, ngɛ baadɩ́nɩ bɔwɔ́rɔ́. Yeésu waamʊ wɛ, ngɛ waaŋmatɩná wɛ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-dɛ́ɛ tɔ́m, bɩka ɩwáázɩ wenbá bɔwɛná kʊdɔmɩ́nɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kɩɩbáázɩ ɖaanɩ́ nɛ́, ngɛ tɩndɩnáa fuú na nɔɔ́lɛ woodúu Yeésu-jɔ́ bɔtɔ́ yɩ sɩsɩ: «Feeri zamɔ́ɔ kɩɖɛ́ɛ tɛɛbíízi na fásɩ sɩwɛ fáráńdɩ́wá tɩḿ tɩdaá nɛ́ kiyuú ɖaaɖooɖɛ́ na wenbí sɩ kiɖi nɛ́, káma, faɖáma-daá lénlé ɩráa fɛ́yɩ́ nɛ́ gɛ ɖɔ́wɛ cé.» ");
INSERT INTO kdh_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Mɩ́dɩtɩŋa ɩva wɛ kíɖíím beɖi.» Ngɛ boobúsi yɩ sɩsɩ: «Kpɔ́nɔ́ natʊ́nʊ́wá na tiiná náálɛ gɛ ɖɔ́jɔ́ cé. Yáá nyɔ́zɔɔlɛ́ɛ sɩsɩ ɖibó ɖɩkámʊ́ kíɖíím ɖɩkɔná zamɔ́ɔ kɩna kɩrɩ́ŋa.» ");
INSERT INTO kdh_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ngʊ́ abaaláa nyazɩ mííli nɔɔ́nʊ́wá (5.000) bɩlɛ́ wɛná ńna. Ngɛ Yeésu wɔɔdɔ́ ɩwanbaaráa sɩsɩ: «Iyéle wɛ bɔcɔ́ɔ fuwé-fuwé, fuúre báa wenɖé-daá, ɩráa nyazɩ nɛɛ́saaláa bɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Wanbaaráa waanɩ́ɩ Yeésu nɔɔ́ beyéle ɩráa rɩ́ŋa ɩcɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ngɛ Yeésu wɔɔgbɔ́ɔ kpɔ́nɔ́wá natʊ́nʊ́wá tɩḿ na tiiná náálɛ amʊ́, ɩkpáázɩ waazá ɩsɔ́ɔ́dáá ɩsá Ɩsɔ́ɔ bʊrɔ. Ngɛ wɛɛbɛlɩ́ tɩ icéle ɩwanbaaráa batára zamɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Barɩ́ŋa bɔɔdɔ́ɔ bɔfɔ́ɔ. Ngɛ baaɖʊ fɔɔlásɩ bɔɔdɔ́ɔ bɩka nɛ́ bisu ɖɔkɩ́nɩ fuú na natɩ́lɛ. ");
INSERT INTO kdh_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wɩ́rɛ neɖére gɛ Yeésu waalɩ́ɩ kpɔ́mɔ́ɔ́ wángazʊlʊ́ʊ, bɩka ɩwanbaaráa wɛ ɩjɔ́. Ngɛ wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «Ɩráa-dɛ́ɛ ŋmatɩrɛ-daá nɛ́, weení gɛ mɛ́gɛ́ɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ngɛ bɛlɛ́ boobúsi yɩ sɩsɩ: «Nɛbɛ́rɛ sɩsɩ nyɔ́ɔ́ gɛ anɖébi Yaayá, nɛbɛ́rɛ sɩsɩ anɖébi Elíya, nɛbɛ́rɛ ɖʊɖɔ sɩsɩ caanawʊ́ anɖébiwá-daá naárʊ weeve ná ɩlɩ́ɩ ɩsɩɖáa lɔwʊtáá.» ");
INSERT INTO kdh_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ńna gɛ Yeésu wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «Mɩ́nyɔ́ɔ́ mɩ́jɔ́ ní, weení gɛ mɛ́gɛ́ɛ.» Ngɛ Pétro woobúsi yɩ sɩsɩ: «Nyɔ́ɔ́ gɛ Lɛɛrʊ́ Ɩsɔ́ɔ weegédíri yɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ngɛ Yeésu waabá ɩbásɩ wɛ sɩsɩ békefééri tɩ báa naárʊ. ");
INSERT INTO kdh_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ngɛ waadásɩ ɩtɔ́ wɛ sɩsɩ: «Bɩ́nbɔɔzɩ́ sɩsɩ Ɩrʊ́ Biyaalʊ́ ɩna wahála ɖabata; tɛ́ɛ́dɩ-daá kʊ́bɔnáa, na Ɩsɔ́ɔ-dɛ́ɛ Sarásɩ lanɖáa kʊ́bɔnáa na Mará wɩlɩɖáa wéngizíi yɩ; bángʊ́ʊ yɩ, na toozo wɩ́rɛ nɛ́, ifé ɩlɩ́ɩ ɩsɩɖáa lɔwʊtáá.» ");
INSERT INTO kdh_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ngɛ weevééri barɩ́ŋa sɩsɩ: «A naárʊ sɔɔlɛ́ɛ sɩ ifu ma, íkizi ɩdɩ bɩka ɩkpɔ́ɔ ɩdɛ́ɛ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ báa wɩ́rɛ wenɖé ikóvú ma. ");
INSERT INTO kdh_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Káma, weení wánjáádɩ sɩsɩ ɩlɛ́ɛ iweezuú nɛ́ wɛ́nbɛɖɩ́ kɩ, amá, weení wɛ́nbɛɖɩ́ iweezuú mɔ́rɔ́ɔ́zɩ́ nɛ́, wóngoyuú kɩ. ");
INSERT INTO kdh_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ɩrʊ́ iɖi ɖúúlínya rɩ́ŋa, amá, ɩbɛ́ɖɩ iweezuú yáá inúúdi ɩdɩ nɛ́, we gɛ bɩvɔ́ɔ́zɩrɛ. ");
INSERT INTO kdh_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Káma, weení ɩrɩ́ŋa mɔ́dɔ́m sɩ ɩlá yɩ fɛɛrɛ́, yáá mɛ́dɛ́ɛ ŋmatɩrɛ sɩ ɩlaná yɩ fɛɛrɛ́ nɛ́, ɩdɔ́m wánlám Ɩrʊ́ Biyaalʊ́ ɖʊɖɔ fɛɛrɛ́ sáátɩ wenkí sɩ ɩkɔ́nɩ ɩdɛ́ɛ ásícé kɩgɛ́ɛ Ɩjaa na ɩdɛ́ɛ malááyɩ́kawá ɖacɩrɩ‑cɩrɩ ńba-dɛ́ɛ ńgɩ ɖʊɖɔ nɛ́-daá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ménveerím mɩ́ɩ toovonúm sɩsɩ nɛbɛ́rɛ wɛ cé, bádánzɩḿ naanɩ́ bana Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Bɩɩlá nyazɩ wɛ́ lutoozo Yeésu waaŋmátɩ tɔ́mwá tɩḿ wɔ́rɔ́ nɛ́, ngɛ wɔɔgbɔ́ɔ Pétro, na Yʊháánɩ, na Yaakúbu ɩ́na wɛ bakpa bʊ́ʊ-daá sɩ ɩkɛ́zɛɛ Ɩsɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ɩwɛ ɩbamáa sʊlʊ́ńdɩ nɛ́, ngɛ waazá-daá wɛɛgɛ́ɛ bɩka idóko izóóna nɛ́ ɩbá kɩfʊ́lʊ párɩ́‑párɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ńna‑ńna gɛ ɩráa nɔɔ́lɛ waaɖʊ balɩ́ɩ bána yɩ bánŋmatɩ́; ɩráa bɛḿ nɛ́, Múúsá na Elíya gɛ bɩgɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Baaɖʊ balɩ́ɩ Ɩsɔ́ɔ-dɛ́ɛ ásícé-daá bána yɩ bánŋmatɩ́ nŋɩ́nɩ́ sɩ ɩsɩ́ ɩkʊ́ʊ́rɩ ɩdɩmɛ́rɛ Yerusalɛ́ɛm tɛ́ɛ́dɩ-daá nɛ́ bɩdɛ́ɛ tɔ́m. ");
INSERT INTO kdh_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pétro na igoobíya wɛ bónɖóm páá, amá, beevé nɛ́, ngɛ baana Yeésu-dɛ́ɛ ásícé na ɩráa bɛḿ bɛlɛ́ɛ́nɩ́, bɔwɛ bazɩ́ŋɛ́ɛ bána yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Sáátɩ wenkí ɩráa bɛḿ bɛ́nɖɛɛ́ nɛ́, ngɛ Pétro wɔɔdɔ́ Yeésu sɩsɩ: «Kʊ́bɔnɩ́, ɖɛ́dɛ́ɛ cénjé cɔwʊ́ʊ wánlám kazɔ́ɔ; ɖɩ́la kɛ́rɛ́ɛ́zɩ nasúdoozo: nyɔ́ɔ́ kʊ́ɖʊmɔ́ɔ, Múúsá kʊ́ɖʊmɔ́ɔ, Elíya kʊ́ɖʊmɔ́ɔ.» Wánŋmatɩ́ bɩlɛ́ nɛ́, waatanzɩ wentí wánŋmatɩ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ɩwɛ ɩbamáa ŋmatɩrɛ bɩlɛ́ gɛ ŋmɩnʊʊ́ nakɩ́rɩ waaɖʊ kɩlɩ́ɩ kɩbála kifu bɔrɔ. Sáátɩ wenkí baazʊ́ʊ kɩdaá nɛ́, nɩdáárɛ waabá ɖɩkpa wɛ. ");
INSERT INTO kdh_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ngɛ baanɩ́ɩ lowú nakɩ́rɩ ɖoo ŋmɩnʊʊ́-daá sɩsɩ: «Ceení gɛ Mebiyaalʊ́ weení máálɩ́zɩ́ yɩ nɛ́, ɩnɩɩná yɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Baajáŋ banɩ́ɩ lowú kɩḿ bɩtɛ́ nɛ́, Yeésu riké wɛná ńna. Wanbaaráa woozuná tɩ badɩ, ngɛ wɛ́ amʊ́ adaá, bedefééri báa naárʊ wenbí baaná nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kiivé nɛ́, ngɛ Yeésu na ɩwanbaaráa toozóóní baagálɩɩ bʊ́ʊ-rɔ bekédi. Ngɛ zamɔ́ɔ tuutúúma wɔɔgɔ́nɩ sɩ kɩsɩ́ŋ yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Zamɔ́ɔ-daá ńna gɛ ɩrʊ́ naárʊ woogóo bɩcáárɩ sɩsɩ: «Kʊ́bɔnɩ́ máávɩ́nɩ nya, nɩɩ mebiyaalʊ́ kʊnyɔḿ, iriké kóŋ́ gɛ mɔ́wɛná. ");
INSERT INTO kdh_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Zííni nakɩ́rɩ wándárájáárɩ́ yɩ gɛ; a kɩɩjáŋ gɛ kɩɩgʊrʊ́na yɩ, na ɩbáázɩ ɖugoogoore, bɩka kɩbá kínjuúdi yɩ ɖóni‑ɖóni, na bú nɔɔ́ ɩbáázɩ kʊbʊʊdʊ́ʊ lɩɩ́. Kɩ́nnaazɩ́ yɩ gɛ, kɩbá kɩfʊ́ʊ́zɩ ɩdɔnʊʊ́, ngɛ kɩ́ngʊrʊ́ʊ sɩ kɩlɩ́ɩ nɛ́, káálɛ na káálɛ gɛ. ");
INSERT INTO kdh_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Máávɩ́nɩ nyɛ́dɛ́ɛ wanbaaráa sɩsɩ bɔ́ɖɔɔ zííni kɩḿ, amá, badabɩ́ɩ́zɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ngɛ Yeésu sɩsɩ: «Zaamáánɩ kɩna kɩdɛ́ɛ ɩráa badaavé bɩka badafa Ɩsɔ́ɔ toovonúm nɛ́ bana ɖɔ́! Wɛ́ nŋɩ́nɩ́ gɛ mógúti mɔjɔ́ɔ mɩ́jɔ́. Wɛ́ nŋɩ́nɩ́ gɛ mógúti mɔɖɔ́kɩ mɩ́ɩ.» Ngɛ wɔɔdɔ́ bú ɩjaa sɩsɩ: «Kɔná nbiyaalʊ́ cé.» ");
INSERT INTO kdh_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Bú wɛɛgbɛdɩ́ ɩgɛgɛrɛŋɛ ɖɔ́ gɛ zííni wɔɔjɔlɩ́ yɩ kɩyɔ́ɔ adɛ, kɩbá kicuúdi yɩ ɖóni-ɖóni. Amá, Yeésu waagazɩ́ zííni, ngɛ waawáázɩ bú, ɩkpɔ́ɔ yɩ icéle ɩjaa. ");
INSERT INTO kdh_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Baana Ɩsɔ́ɔ-dɛ́ɛ ɖóni bɩlɛ́ nɛ́, ngɛ bɩɩbá bɩlá barɩ́ŋa mááɖé. Ńŋɩnáa báa weení wɛ wánlám wenbí bɩrɩ́ŋa Yeésu waalá nɛ́-dɛ́ɛ bítí nɛ́, ngɛ ɩlɛ́ wɔɔdɔ́ ɩdɛ́ɛ wanbaaráa sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Bɩɩga mɩ́ɩ nɛ́, iwélesi ɩnɩ́ɩ wentí sɩ mevééri mɩ́ɩ nɛ́ kazɔ́ɔ: Bángbáa Ɩrʊ́ Biyaalʊ́ becéle ɩráa.» ");
INSERT INTO kdh_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Amá, wanbaaráa tanɩ́ɩ tɔ́m tɩḿ tugutoluú; bɩdafa wɛ babɩ́ɩ́zɩ banɩ́ɩ tugutoluú na bákatɩlɩ́ wenbí tɩ́nwɩlɩ́ɩ nɛ́. Ngɛ bɩjɔɔ́ɔ wɛ nɩdáárɛ sɩ bɔbɔ́ɔ́zɩ yɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Wanbaaráa wɛ bánŋmatɩnáa ɖamá na batɩlɩ́ badaá weení ɩgɛ́ɛ kʊ́bɔnɩ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yeésu waadɩlɩ́ wentí bánmaazɩ́ nɛ́, ngɛ wɔɔgɔná búyɔ́ɔ ɩsɩ́ɩ ɩjɔ́. ");
INSERT INTO kdh_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ngɛ wɔɔdɔ́ ɩwanbaaráa sɩsɩ: «Weení waamʊ bú ceení ɩgɔ́ńdɩ mɔ́rɔ́ɔ́zɩ́ nɛ́, mádɩtɩŋa gɛ waamʊ; ngɛ weení waamʊ ma nɛ́, waamʊ bɩkpɛdɩ́na weení weegédíri ma nɛ́. Káma, weení ɩgɛ́ɛ bú mɩ́rɩ́ŋa mɩ́lɔ́wʊ́táá nɛ́, ɩlɛ́ gɛ kʊ́bɔnɩ́.» ");
INSERT INTO kdh_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Bɩnáábɩ́lɛ́ Yʊháánɩ wɔɔdɔ́ Yeésu sɩsɩ: «Kʊ́bɔnɩ́, ɖááná naárʊ wɔ́nɖɔwʊ́ʊ zííniwá na nyáyɩ́ɖɛ-daá, ɖɔ́ɔ́ ɖɔ́ɔ́zɔ́ɔ́lɩ sɩsɩ ɖikiziná yɩ, káma, ɩraavóo nya ɩ́na ɖáa.» ");
INSERT INTO kdh_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ngɛ Yeésu woobúsi yɩ sɩsɩ: «Íkekiziná yɩ, káma, weení ɩraayɛ́ɛ́na mɩ́ɩ nɛ́, fóo mɩ́ɩ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ńŋɩnáa alɩwáátɩ wenkí Yeésu sɩ ɩlɩ́ɩ ɖúúlínya kɩna kɩdaá nɛ́ kɩɩjʊ́ʊ nɛ́, waamá wenbiré ɩkpɔ́ɔ Yerusalɛ́ɛm nɩ́bááwʊ. ");
INSERT INTO kdh_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ngɛ weedíri tɩndɩnáa bɛtɛ yɩ nɩ́bááwʊ. Bɛlɛ́ bɔɔgbɔ́ɔ nɩ́bááwʊ nɛ́, ngɛ boobó basʊ́ʊ Samarɩ́ya ńba-dɛ́ɛ tɛɛbiiyá nɛkɛ́rɛ-daá sɩsɩ bakpɩ́ɩ́rɩ ɩdɛ́ɛ kɔnɖɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Amá, tɛɛbiiyá-daá ńba weegízi badamʊ yɩ, káma, Yerusalɛ́ɛm gɛ ɩbamáa ɖɛɛ́ nɛ́-rɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Wanbaaráa Yaakúbu na Yʊháánɩ baanɩ́ɩ bɩlɛ́ nɛ́, ngɛ bɔɔbɔ́ɔ́zɩ Yeésu sɩsɩ: «Kʊ́bɔnɩ́, nyɔ́zɔɔlɛ́ɛ ɖɩfa nɔɔ́ nimíni ɩkálɩɩ ɩsɔ́ɔ́dáá ɩkɔ́nɩ ɩnyɔ́ɔ wɛ?» ");
INSERT INTO kdh_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Amá, Yeésu wɛɛgɛ́ɛ́zɩ ɩdɩ ɩfaná wɛ́ ɩzá ɩbá ikiziná wɛ. Ngɛ wɔɔdɔ́ wɛ sɩsɩ: «Mɩ́ɩ́sɩ kezeŋa wenká kéngetí mɩ́ɩ nɛ́, ");
INSERT INTO kdh_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","káma, Ɩrʊ́ Biyaalʊ́ tɔkɔ́nɩ sɩsɩ ɩkʊ ɩráa, amá, wɔɔgɔ́nɩ gɛ sɩ ɩlɛ́ɛ wɛ.» Ngɛ baalɩ́ɩ bɛɖɛ́ɛ tɛɛbiiyá nɛkɛ́rɛ-daá. ");
INSERT INTO kdh_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Bɔwɛ nɩ́bááwʊ gɛ ɩrʊ́ naárʊ wɔɔdɔ́ Yeésu sɩsɩ: «Báa lé gɛ nyɛ́nɖɛɛ́, móvóo nya gɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ńna gɛ Yeésu woobúsi yɩ sɩsɩ: «Sɔ́ɔ́lɛ́ɛ́rásɩ wɛná bɔ́ɔ́nɩ, bɩka siḿsi wɛná ɖɛ́ńɖɛ́lá. Amá, Ɩrʊ́ Biyaalʊ́ fɛ́yɩ́na lénlé sɩ ɩfɩ́nɩ ɩfɛ́ɛ́zɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ngɛ Yeésu wɔɔdɔ́ naárʊ sɩsɩ: «Kovu ma.» Ngɛ ɩlɛ́ woobúsi yɩ sɩsɩ: «Kʊ́bɔnɩ́, fa ma nɩ́bááwʊ mobó megébi majaa naanɩ́.» ");
INSERT INTO kdh_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ngɛ Yeésu woobúsi yɩ sɩsɩ: «Yele ɩsɩɖáa ibí bɛdɛ́ɛ ɩsɩɖáa, bɩɩga nyɔ́ɔ́ nɛ́, bo nvééri ɩráa Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-dɛ́ɛ tɔ́m.» ");
INSERT INTO kdh_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ɩrʊ́ naárʊ ɖʊɖɔ wɔɔdɔ́ yɩ sɩsɩ: «Kʊ́bɔnɩ́ mónvúu nya, amá, yele mobó mɛgɛ́zɛɛ mɛ́dɛ́ɛ ńba biléceré naanɩ́.» ");
INSERT INTO kdh_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ngɛ Yeésu weevééri yɩ sɩsɩ: «Weení waabáázɩ farɩ́m ngɛ weeyéle wɛ́nbɛɛŋ́ bʊwɔ́rɔ́ nɛ́ tánbɩɩzɩ ɩlá Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-daá-dɛ́ɛ tɩmɛ́rɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Bɩlɛ́ bʊwɔ́rɔ́ nɛ́, Ɖádʊ́ʊ waalɩzɩ́ wanbaaráa niídoozo na saaláa na nɔɔ́lɛ nɛbɛ́rɛ, ngɛ weedíri wɛ nɔwɔ́nwɔ́lɛ bɛtɛ yɩ nɩ́bááwʊ tɛ́ɛ́dɩwá rɩ́ŋa na tɛɛbíízi wensí sɩrɩ́ŋa sɩdaá ɩdɩtɩŋa sɩ ɩfʊ́nɖɛ́ɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Weevééri wɛ sɩsɩ: «Kíɖíídi sɩ bakʊ́ fɔɔ́-daá nɛ́ wɔɔɖɔ́ɔ, amá, kʊmɖáa tɔɖɔ́ɔ. Bɩlɛ́ nɛ́, ɩzʊ́lʊ fɔɔ́-dʊ́ʊ ɩtásɩ ikédiri kʊmɖáa bʊɖɔ́ɔ bɔkɔ́nɩ bakʊ́. ");
INSERT INTO kdh_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ibó ɩɖɛ́ɛ, méndiríi mɩ́ɩ gɛ nyazɩ fée‑bíízi káwʊ‑káwʊwá lɔwʊtáá. ");
INSERT INTO kdh_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ɩ́kɔkpɔ́ɔ liideé, ɩ́kɔkpɔ́ɔ furuú, cáńfáná takaḿwá; ɩ́kasɩ́ŋ nɩ́bááwʊ-daá ɩsɛ́ɛ naárʊ. ");
INSERT INTO kdh_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ɖaána báa wenká-daá gɛ sɩ ɩsʊ́ʊ, ɩdɔ́ sɩsɩ: “Ɩsɔ́ɔ-dɛ́ɛ fɛɛzɩrɛ ɩ́cɔ́ɔ́ná ɖɔɔ́ kana.” ");
INSERT INTO kdh_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","A bɩlɛ́ gɛ fɛɛzɩrɛ-dɛ́ɛ ɩrʊ́ naárʊ wɛ ńna, Ɩsɔ́ɔ-dɛ́ɛ fɛɛzɩrɛ wɔ́njɔɔnáa yɩ; a ngʊ́ bɩdɛkɛ́ɛ bɩlɛ́, mɩ́dɛ́ɛ kooríti wángabɩsɩ́ mɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ɩjɔ́ɔ ɖaána kɛḿ kadaá, iɖi ɩnyɔ́ɔ wenbí sɩ bafa mɩ́ɩ nɛ́, káma, tɩmɛlanɖʊ́ mɔɔ́na bɛfɛ́rɛ yɩ. Ɩ́kasʊ́ʊ mɩ́nlɩɩ́ ɖɛ́ɛ́zɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","A bɩgɛ́ɛ sɩsɩ mɩ́ɩ́zʊ́ʊ tɛ́ɛ́dɩ natɩ́rɩ-daá gɛ baamʊ mɩ́ɩ, iɖi wenbí sɩ bafa mɩ́ɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ɩwáázɩ kʊdɔndɩnáa bɔwɛ ńna nɛ́, bɩka ifééri tɛ́ɛ́dɩ tɩḿ tɩdɛ́ɛ ɩráa sɩsɩ: “Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ waajʊʊná mɩ́ɩ.” ");
INSERT INTO kdh_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Amá, a bɩgɛ́ɛ sɩsɩ mɩ́ɩ́zʊ́ʊ tɛ́ɛ́dɩ natɩ́rɩ-daá gɛ beegízi badamʊ mɩ́ɩ, ɩlɩ́ɩ nɩ́báánɩ-daá ɩtɔ́ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Bɩkpɛdɩ́na mɩ́dɛ́ɛ tɛ́ɛ́dɩ-dɛ́ɛ buuruú biivuná ɖɔ́nʊvɔ́ nɛ́, ɖéégbíízi ɖɩtalɩná mɩ́ɩ; amá, na bɩrɩ́ŋa, ɩdɩlɩ́ sɩsɩ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ waajʊʊná mɩ́ɩ.” ");
INSERT INTO kdh_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ménveerím mɩ́ɩ toovonúm sɩsɩ wɩ́rɛ wenɖé Ɩsɔ́ɔ sɩ ɩfʊʊná ɩráa tɔ́m nɛ́, Sodɔ́ɔmɩ-dɛ́ɛ tɛ́ɛ́dɩ-dɛ́ɛ nɩgbamʊʊ́ fɔ́m wánlám sóńcí na tɛ́ɛ́dɩ tɩḿ.» ");
INSERT INTO kdh_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Nbusú ɖamáa na kʊ nya Korazíini tɛ́ɛ́dɩ! Nbusú ɖamáa na kʊ nya Bɛtɩsayɩdáa tɛ́ɛ́dɩ! Káma, maamááciwá tɩɩlá mɩ́dɛ́ɛ nɛ́, a baraalá tɩ Tíiri na Sidɔ́ɔnɩ tɛ́ɛ́dɩwá-daá, tɩlɛ́ tɩraavʊ́ńjɔ́wʊ́ lííya tusúu kpetekíni tókowá, tifuná tɩdɩ tɔɔlɩmá bɩwɩ́lɩ sɩsɩ tɩɩlá túúbá tɩkɛ́ɛ lakásɩ. ");
INSERT INTO kdh_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Bʊrɔ gɛ wɩ́rɛ wenɖé Ɩsɔ́ɔ sɩ ɩfʊʊná ɩráa tɔ́m nɛ́, Tíiri na Sidɔ́ɔnɩ-dɛ́ɛ nɩgbamʊʊ́ fɔ́m wánlám sóńcí na mɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Bɩɩga nyɔ́ɔ́ Kapɛrɩnawʊ́m tɛ́ɛ́dɩ, nyánmaazɩ́ sɩsɩ nyángbáa Ɩsɔ́ɔ-jɔ́ yáá wé. Aayɩ́, béndisí nya hálɩ ɩsɩɖáa-daá.» ");
INSERT INTO kdh_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ngɛ wɔɔdɔ́ ɩwanbaaráa ɖʊɖɔ sɩsɩ: «Weení weewélesi mɩ́ɩ nɛ́, weewélesi ma; weení weegízi mɩ́ɩ nɛ́, bʊdʊ́ʊ weegízi ma; ngɛ weení weegízi ma nɛ́, weegízi weení weegédíri ma nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Bʊwɔ́rɔ́ nɛ́, ngɛ wanbaaráa niídoozo na saaláa na nɔɔ́lɛ beedíri wɛ nɛ́ boobó bakábɩsɩ bɩka bɩjɔɔ́ɔ wɛ niíni páá bɔ́ndɔ́m sɩsɩ: «Kʊ́bɔnɩ́, na nyɛ́dɛ́ɛ yɩ́ɖɛ-daá, zííniwá tɩtɩŋa wánlám wenbí ɖɔ́nbɔɔzɩ́ tɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ńna gɛ Yeésu woobúsi wɛ sɩsɩ: «Mɛ́nbɛɛŋ́ nɛ́, mááná Sitáánɩ waagálɩɩ ɩsɔ́ɔ́dáá ɩsála nyazɩ bɩɩnyaláázɩ bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Iwélesi ma: máává mɩ́ɩ yíko sɩsɩ ɩ́nʊŋ ɖomáa na cáálɩ́sɩ, mava mɩ́ɩ yíko ɖʊɖɔ sɩsɩ ɩ́nám báɖaa-dɛ́ɛ yíko rɩ́ŋa, bɩka nabʊ́rʊ tánlaḿ mɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Amá, na bɩrɩ́ŋa, bɩ́kalá mɩ́ɩ niíni ɩfáárɩ sɩsɩ zííniwá wánlám wenbí mɩ́nbɔɔzɩ́ tɩ nɛ́-rɔɔzɩ́, amá, bɩ́la mɩ́ɩ niíni sɩsɩ baaŋmáa mɩ́yɩ́rá ɩsɔ́ɔ́dáá nɛ́-rɔɔzɩ́ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ńna‑ńna gɛ Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga weeyéle bɩbá bɩlá Yeésu niíni ɩtɔ́ sɩsɩ: «Majaa, Mádʊ́ʊ Ɩsɔ́ɔ, adɛ na ɩsɔ́ɔ́dáá lanɖʊ́, mánzám nya ńŋɩnáa nyáámʊ́sɩ áséńsí-dɩnáa na tɩlɩ́ɖa wentí nɛ́, nyééyéle bíya kúmuúsi ɩtɩlɩ́ tɩ nɛ́-rɔɔzɩ́. Ɩɩ́n Majaa, bɩlɛ́ gɛ nyáábá nzɔ́ɔ́lɩ sɩsɩ bɩ́la. ");
INSERT INTO kdh_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Majaa weejéle ma bɩrɩ́ŋa. Naárʊ fɛ́yɩ́ ɩnyɩ Biyaalʊ́ʊ, asée Caáwʊ, ngʊ́ bɩlɛ́ gɛ naárʊ fɛ́yɩ́ ɩnyɩ Caáwʊ asée Biyaalʊ́ʊ na wenbá ɖʊɖɔ Biyaalʊ́ʊ wɔɔzɔ́ɔ́lɩ sɩsɩ batɩlɩ́ yɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ngɛ Yeésu wɛɛgɛ́ɛ́zɩ ɩdɩ ɩfaná wanbaaráa riké ɩzá ɩtɔ́ wɛ sɩsɩ: «Wenbi‑niíni-dɩnáa gɛ ɩráa wenbá bánnáa wenbí mɩ́nnáa ɖɔ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Káma, ménveerím mɩ́ɩ toovonúm sɩsɩ anɖébiwá ɖabata na wúrowá ɖabata wɔɔzɔ́ɔ́lɩ sɩsɩ bana wenbí mɩ́bɛɛ́na nɛ́, amá, badana; bɔɔzɔ́ɔ́lɩ sɩsɩ banɩ́ɩ wentí mɩ́nnɩɩ́ nɛ́, amá, badanɩ́ɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ńna gɛ Mará wɩlɩɖʊ́ naárʊ sɩ ɩyɩ́ Yeésu kɔdɔká nɛ́, waagʊrʊ́ ɩsɔ́ɔ́dáá ɩbɔ́ɔ́zɩ yɩ sɩsɩ: «Kʊ́bɔnɩ́, wé gɛ bɩ́nbɔɔzɩ́ sɩsɩ mála na moyuú ceré.» ");
INSERT INTO kdh_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ngɛ Yeésu woobúsi yɩ sɩsɩ: «Ɩsɩ wé gɛ baaŋmáa ɖɛ́dɛ́ɛ Mará-dɛ́ɛ tákaraɖá-daá. Nyángalɩ́ɩ nɛ́, wentí gɛ nyánnɩɩ́.» ");
INSERT INTO kdh_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ngɛ ɩrʊ́ ɩmʊ́ woobúsi sɩsɩ: «Nyɔ́nzɔɔlɩ́ Ɖádʊ́ʊ Ɩsɔ́ɔ na nyéwenbiré rɩ́ŋa, na nyégezeŋa rɩ́ŋa, na nyóɖóni rɩ́ŋa, na nyólomaazɛ́ rɩ́ŋa.» Bɩka ɖʊɖɔ «nzɔ́ɔ́lɩ nyɔ́rɔwʊ́ nyazɩ nyádɩtɩŋa.» ");
INSERT INTO kdh_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ngɛ Yeésu wɔɔdɔ́ yɩ sɩsɩ: «Nyóóbúsi kazɔ́ɔ, la bɩlɛ́ na nÿuú ceré.» ");
INSERT INTO kdh_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Amá, Mará wɩlɩɖʊ́ sɔɔlɛ́ɛ ɩwɩ́lɩ sɩsɩ ɩdɛ́ɛ bɔɔzɩ́ sɩɩzɛ́ɛ nɛ́, ngɛ wɔɔbɔ́ɔ́zɩ Yeésu sɩsɩ: «Bɩlɛ́ nɛ́, weení gɛ mɔ́rɔwʊ́.» ");
INSERT INTO kdh_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ngɛ Yeésu woobúsi sɩsɩ: «Ɩrʊ́ naárʊ waalɩɩ ná Yerusalɛ́ɛm wéndím Yerikóo tɛ́ɛ́dɩ-daá. Ɩwɛ wɛ́nɖɛɛ́ gɛ ŋmɩɩláa waalɩ́ɩ bɛbɛlɩ́ yɩ nɩ́bááwʊ, bɛlɛ́ɛ ɩgbɩná rɩ́ŋa, bɩka bába bamá yɩ hálɩ wánlʊwɔ́ɔ na sɩ́m, bokuná yɩ bɔlɔ bɛɖɛ́ɛ beyéle yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Bɩɩdásɩyɔ́ɔ nɛ́, bɩɩzaaná Ɩsɔ́ɔ-dɛ́ɛ sarásɩ lanɖʊ́ naárʊ waalɩ́ɩ wɛ́ngɛɖɛɛnáa nɩ́bááwʊ kɩḿ. Waana ɩrʊ́ ɩmʊ́ nɛ́, ngɛ wɛɛjɛ́ nɩ́bááwʊ ikééri ɩɖɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Léévi-dɛ́ɛ ɖugoré-daá ɩrʊ́ naárʊ ɖʊɖɔ wɔɔgɔ́nɩ ɩtála ńna; waana ɩrʊ́ ɩmʊ́ nɛ́, ngɛ wɛɛjɛ́ nɩ́bááwʊ ikééri ɩɖɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Amá, Samarɩ́ya tɛ́ɛ́dɩ-dɛ́ɛ ɩrʊ́ naárʊ wɛ́nɖɛɛ́ nɩ́bááwʊ nɛ́, wɔɔgɔ́nɩ ɩtála ɩrʊ́ ɩmʊ́ ɩɖɩdáarɛ; waana yɩ nɛ́, ngɛ bɩɩbá bɩlá yɩ kʊnyɔḿ. ");
INSERT INTO kdh_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ńna gɛ woogóduu ɩjɔ́, ɩbɩ́rɩ núm na sʊlʊ́m ɩdɛ́ɛ fééziwá-daá, ngɛ wɔɔvɔ́kɩ sɩ. Bɩɩdɛ́ nɛ́, ngɛ wɔɔgbɔ́ɔ yɩ ɩtɩ́nɩ ɩdɩtɩŋa ɩdɛ́ɛ kpangbɔ́ɔ wenká ɩgɔjɔɔ́na kɛ nɛ́ kɔrɔ ɩɖɛɛná yɩ ɩgɔma ɖaána nɛkɛ́rɛ-daá ɩbɛ́ɛ́ŋ yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kiivé nɛ́, ngɛ Samarɩ́ya ńnɩ́ ɩmʊ́ waalɩzɩ́ wɛ́ náálɛ tɩmɛ́rɛ liideé icéle ɩgɔma ɖɔɔ́-dʊ́ʊ ɩtɔ́ yɩ sɩsɩ: “Bɛɛŋ yɩ; a bɩgɛ́ɛ sɩsɩ nyééɖí bɩcɛzɩ́ bɩlɛ́, a máagábɩ́sɩ mádɩtɩŋa mɛ́nvɛrɩ́ɩ nya wenbí biizúúri nɛ́.”» ");
INSERT INTO kdh_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ńna gɛ Yeésu wɔɔbɔ́ɔ́zɩ Mará wɩlɩɖʊ́ sɩsɩ: «Nyɛ́dɛ́ɛ bɛɛŋ́-daá nɛ́, ɩráa bana bodoozóóní badaá, weení gɛ nyánmaazɩ́ sɩsɩ ɩrʊ́ weení waazála ŋmɩɩláa nʊ́ʊ́zɩ-daá nɛ́ ɩ́tɛ ɩyáa sɩsɩ ɩrɔwʊ́.» ");
INSERT INTO kdh_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ngɛ Mará wɩlɩɖʊ́ woobúsi sɩsɩ: «Weení waanɩ́ɩ ɩrʊ́ ɩmʊ́ ɩgʊnyɔḿ nɛ́ gɛ.» Ngɛ Yeésu wɔɔdɔ́ yɩ sɩsɩ: «Tɔ́ɔ, nyɔ́ɔ́ ɖʊɖɔ bo nlá bɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yeésu wɛ́nɖɛɛ́ ɩ́na ɩwanbaaráa nɛ́, woobó ɩsʊ́ʊ tɛɛbiiyá nɛkɛ́rɛ-daá, ngɛ alʊ́ naárʊ waamʊ yɩ ɩɖaána-daá. Bánÿaá alʊ́ ɩmʊ́ sɩsɩ Maárɩtɩ. ");
INSERT INTO kdh_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Alʊ́ ɩmʊ́ ɩwɛná igoobú alʊ́ naárʊ bánÿaá yɩ sɩsɩ Marɩyáma. Ɩlɛ́ woobó ití ɩjɔɔ́ɔ Ɖádʊ́ʊ Yeésu nʊvɔ́-jɔ́ wénwelesí ɩdɛ́ɛ tɔ́m. ");
INSERT INTO kdh_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Maárɩtɩ ɩlɛ́ ɩwɛ waazɩ́rɛ ɩbá bɩzɛɛmáa na kpɩná kpɩɩrɩ́ sɩsɩ ɩlá kíɖíím. Ńna gɛ wɛɛgbɛdɩ́ ikóduu Yeésu-jɔ́ ɩtɔ́ yɩ sɩsɩ: «Kʊ́bɔnɩ́, bɩlɛ́ nɛ́, bídénveeri nya natɩ́rɩ sɩsɩ mogoobú waadalɩná ma tɩmɛ́rɛ rɩ́ŋa mériké? Feeri yɩ sɩsɩ ɩ́kʊrʊ́ ɩsɩná ma.» ");
INSERT INTO kdh_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ngɛ Ɖádʊ́ʊ Yeésu woobúsi yɩ sɩsɩ: «Maárɩtɩ, Maárɩtɩ! Nyánÿɩtɩ́ nyádɩ nyɛ́nÿɛrɛ́tɩ kpɩná ɖabata-rɔ. ");
INSERT INTO kdh_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Amá, kpɩ́nɖɛ kʊ́ɖʊńɖɛ kóŋ́ wɛná na fɔ́ɔ́zɩrɛ. Marɩyáma waalɩzɩ́ na wenbí bɩjɔɔ́ɔ kazɔ́ɔ bɩkɩ́lɩ nɛ́, ngɛ naárʊ fɛ́yɩ́ sɩ ɩlɛ́ɛ bɩ ɩjɔ́.» ");
INSERT INTO kdh_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yeésu wɛ ɖeelí wánzʊlʊ́ʊ wɩ́rɛ neɖére. Sáátɩ wenkí waazʊ́lʊ bɩtɛ́ nɛ́, ngɛ ɩwanbaaráa-daá naárʊ wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Kʊ́bɔnɩ́, wɩlɩ ɖáa sʊlʊ́ńdɩ ńŋɩnáa Yaayá waawɩ́lɩ ɩwanbaaráa nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ngɛ Yeésu weevééri wɛ sɩsɩ: «A bɩgɛ́ɛ mɩ́nzʊlʊ́ʊ ɩdɔ́ sɩsɩ: “Ɖájaa, Yele ɩráa ɩtɩlɩ́ sɩsɩ nyɛ́gɛ́ɛ ɖacɩrɩ‑cɩrɩ-dʊ́ʊ. Nyógowúrɔ́ɔ íkedi adɛ laadɔ́ɔ-rɔ. ");
INSERT INTO kdh_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Fa ɖáa báa wɩ́rɛ wenɖé ɖégíɖíím. ");
INSERT INTO kdh_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Cɛ ɖáa ɖɛ́dɛ́ɛ alaháácɩ́wá, ńŋɩnáa ɖɔ́ɔ́ ɖʊɖɔ ɖɛ́njɛ́m wenbá bánÿɩsɩnáa ɖáa nɛ́. Nkeyéle ɖáa ɖɩsála ɩ́bɛrɛ-dɛ́ɛ kɔdɔ́sɩ-daá.”» ");
INSERT INTO kdh_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ngɛ weedéféeri wɛ sɩsɩ: «A mɩ́dáá naárʊ wɛná ɖɔndʊ́ʊ gɛ waagʊrʊ́ nuvoowú-daá ibó ɩlɛ́ ɩdɛ́ɛ ɩna yɩ sɩsɩ: “Mɔɖɔndɩ, kɩ ma kpɔ́nɔ́wá natúdoozo, ");
INSERT INTO kdh_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","káma, mɔɖɔndɩ naárʊ waagálɩ́ɩ́ná nɩ́bááwʊ ɩtála nɛ́ waazʊ́ʊ mɛ́dɛ́ɛ, ngʊ́ mɛ́vɛ́yɩ́na nabʊ́rʊ sɩ mava yɩ.” ");
INSERT INTO kdh_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","A bɩlɛ́ gɛ ɩlɛ́ woogóbusíná yɩ na ɩɖaḿ-daá sɩsɩ: “Nkacáárɩ ma, ɖɔ́ńdɔ́ɔ tará. Mána mébíya ɖáńvɩ́nɩ, mádánbɩɩzɩ magʊrʊ́ mava nya kpɔ́nɔ́wá.” ");
INSERT INTO kdh_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ménveerím mɩ́ɩ sɩsɩ, báa ɖoo ɩ́dángʊrʊ́ ɩfa yɩ kpɔ́nɔ́wá sɩsɩ ɩgɛ́ɛ ɩɖɔndɩ-rɔ nɛ́, ńŋɩnáa waabá wánjaarɩ́ yɩ nɛ́, wángʊrʊ́ʊ ɩfa yɩ wenbí bɩrɩ́ŋa wánjáádɩ nɛ́ bɩka ɩfɛ́ɛ́zɩ. ");
INSERT INTO kdh_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Tɔ́ɔ, mɔ́ɔ́ ménveerím mɩ́ɩ sɩsɩ: Ɩbɔ́ɔ́zɩ bánváa mɩ́ɩ, ɩjáa mínÿuúu, ɩgɔ́tɩ bándʊlʊ́ʊ mɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Káma, weení ɩrɩ́ŋa wɔ́nbɔɔzɩ́ nɛ́ bánváa yɩ, weení wánjáádɩ nɛ́ wónÿuúu bɩka weení wɔ́ngɔtɩ́ nɛ́ bándʊlʊ́ʊ yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Mɩ́dáá caáwʊ weení wɔ́ngbɔwʊ́ʊ kʊ ɖoḿ ɩfa ibiyaalʊ́ a bɩgɛ́ɛ ɩlɛ́ waazʊ́lʊ yɩ tińɖe. ");
INSERT INTO kdh_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Yáá a ɩlɛ́ waazʊ́lʊ yɩ yɛ́lɛ, ɩkpɔ́ɔ cáálɩ́ya ɩfa yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Bɩlɛ́ nɛ́, a mɩ́nyɔ́ɔ́ wenbá mɩ́dáávé nɛ́, mɩ́nyɩ mɩ́nváa míbíya wenbí bɩjɔɔ́ɔ kazɔ́ɔ nɛ́, bɩ́nlám nŋɩ́nɩ́ na Mɩ́jaa weení ɩwɛ ɩsɔ́ɔ́dáá nɛ́ tánváa Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga wenbá bɔ́nbɔɔzɩ́ yɩ kɛ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Wɩ́rɛ gɛ Yeésu wɛ wɔ́nɖɔwʊ́ʊ zííni nakɩ́rɩ kɩɩbɩsɩná ɩrʊ́ komóomúŋa nɛ́. Sáátɩ wenkí zííni waalɩ́ɩ ɩrʊ́ ɩmʊ́ ɩrɔ nɛ́, ngɛ waabáázɩ ŋmatɩrɛ. Ngɛ bɩɩlá zamɔ́ɔ bítí. ");
INSERT INTO kdh_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ńna gɛ nɛbɛ́rɛ sɩsɩ: «Na Bɛlɩzebúuli, zííniwá-dɛ́ɛ wúro gɛ wɔ́nɖɔɔnáa zííniwá.» ");
INSERT INTO kdh_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nɛbɛ́rɛ sɔɔlɛ́ɛ sɩ bayɩ́ yɩ kɔdɔká nɛ́, ngɛ bɔɔbɔ́ɔ́zɩ yɩ sɩsɩ ɩlá maamááci kɩ́nwɩlɩ́ɩ sɩsɩ Ɩsɔ́ɔ-jɔ́ gɛ waagálɩ́ɩ́ná nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yeésu nyɩ bolomaazɛ́ nɛ́, ngɛ weevééri wɛ sɩsɩ: «Laadɔ́ɔ báa wenká gɛ kɛdɛ́ɛ ɩráa wónÿoó ɖamá, asée koonúúdi, ɖɛ́ɛ́zɩ ɩsála ɖamá-rɔ. ");
INSERT INTO kdh_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","A Sitáánɩ wónÿoó ɩdɩ nŋɩ́nɩ́ gɛ bɩ́nlám na ɩdɛ́ɛ kowúrɔ́ɔ tɔ́nÿɔḿ, káma, mɩzɩ na Bɛlɩzebúuli gɛ mɔ́nɖɔɔnáa zííniwá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","A na Bɛlɩzebúuli gɛ mɔ́nɖɔɔnáa zííniwá, mɩ́dɛ́ɛ wanbaaráa ní, na weení gɛ bɛlɛ́ bɔ́nɖɔɔnáa tɩ. Bʊrɔɔzɩ́ gɛ míbiyaalɩnáa tɩtɩŋa sɩ bafʊʊná na mɩ́ɩ tɔ́m. ");
INSERT INTO kdh_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Amá, a na Ɩsɔ́ɔ-dɛ́ɛ yíko gɛ mɔ́nɖɔɔnáa zííniwá, bɩlɛ́ nɛ́ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ waadála mɩ́lɔ́wʊ́táá nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","A ɩrʊ́ ɖóni-dʊ́ʊ wénveríi ɩɖaána-rɔ ɩ́na yoogbɩná, nabʊ́rʊ téndekiná wenbí bɩrɩ́ŋa ɩwɛná nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Amá, a naárʊ waagɩ́lɩ yɩ ɖóni nɛ́ wɔɔgɔ́nɩ iyóo yɩ, ngɛ ɩlɛ́ waabɩ́ɩ́zɩ yɩ, wɛ́nlɛɛ́ yoogbɩná rɩ́ŋa ɩvʊnjɔɔ́ɔna yɛ tamɔ́ɔ nɛ́ bɩka ɩtára wenbí bɩrɩ́ŋa wɔɔgbɔ́ɔ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Weení ɩraavóo ma nɛ́, ɩyɛ́ɛ́na ma, bɩka weení ɩ́dánzɩná ma tuuzí nɛ́, wánÿaazɩ́ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«A zííni waalɩ́ɩ ɩrʊ́-rɔ, kínboɖé gɛ kɩ́ngabɩsɩ́ ɖɩdáarɛ wɩlɩ́ŋa ńɖɛ-daá kɩ́njáádɩ ɖaavɛɛzɩɖɛ́. Amá, kídónÿuú nɛ́, na kɩtɔ́ kɩdɩ sɩsɩ: “Mánbɩsɩ́ mɛ́dɛ́ɛ ɖaána wenká máagálɩɩ kadaá nɛ́.” ");
INSERT INTO kdh_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","A kɩɩdála gɛ kɩɩmɔɔná báńgbárɩ́ kɛ bɔnyɔ́ɔ́zɩ, ");
INSERT INTO kdh_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ńna nɛ́ kínboɖé kɩkájaa zííniwá lʊbɛ tɩgɩdaavééníti waagɩ́lɩ kɩḿ nɛ́, na tɩkɔ́nɩ tɩsʊ́ʊ ńna tɩcɔ́ɔ. Bɩgɛdɛɛzɩya, ɩrʊ́ ɩmʊ́ ɩdɛ́ɛ cɔwʊrɛ wɔ́nvɔrɔ́sɩ bɩkɩ́lɩ kaɖaa-dɛ́ɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ɩwɛ ɩbamáa ŋmatɩrɛ bɩlɛ́ gɛ alʊ́ naárʊ waaŋmátɩ bɩcáárɩ zamɔ́ɔ lɔwʊtáá ɩtɔ́ yɩ sɩsɩ: «Alʊ́ weení wɛɛyɛ́ɛ nyóvuwá bɩka nmʊ́zʊ yɩ nɛ́, kɛ́ɛ wenbi-niíni-dʊ́ʊ.» ");
INSERT INTO kdh_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Amá, Yeésu woobúsi sɩsɩ: «Wenbi‑niíni-dɩnáa gɛ wenbá bánnɩɩ́ Ɩsɔ́ɔ-dɛ́ɛ tɔ́m bɩka bánnʊŋɛ́ tɩrɔ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Zamɔ́ɔ wɛ kínduuzí ɩjɔ́ nɛ́, ngɛ waabáázɩ kɩ feerím sɩsɩ: «Zaamáánɩ kɩna kɩdɛ́ɛ ɩráa taavé; bánjáádɩ maamááci; maamááci nakɩ́rɩ fɛ́yɩ́ bánnáa kɩ bɩdɛkɛ́ɛ Ínúusa-dɛ́ɛ ńgɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Káma, ńŋɩnáa Ínúusa-dɛ́ɛ tɔ́m waalá Niníivi ńba maamááci nɛ́, bɩlɛ́ ɖʊɖɔ gɛ Ɩrʊ́ Biyaalʊ́-dɛ́ɛ tɔ́m sɩ ɩlá zaamáánɩ kɩna kɩdɛ́ɛ ɩráa maamááci. ");
INSERT INTO kdh_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tɔ́m fʊ́ʊ́dɩ wɩ́rɛ, Laadɔ́ɔ kɔwɛ na fúu adɛ nɛ́-dɛ́ɛ wúro alʊ́ wángʊrʊ́ʊna zaamáánɩ kɩna kɩdɛ́ɛ ɩráa, ɩkʊ bɔdɔ́m, káma, waagálɩ́ɩ́ná ɖoo ɖúúlínya-dɛ́ɛ tɩ́ŋa-daá ɩkɔ́nɩ iwélesi Sulemáana-dɛ́ɛ áséńsí. Ngʊ́ wenbí bʊwɛ cé nɛ́ bɩɩgɩ́lɩ Sulemáana. ");
INSERT INTO kdh_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tɔ́m fʊ́ʊ́dɩ wɩ́rɛ Niníivi tɛ́ɛ́dɩ-daá ɩráa wángʊrʊ́ʊna zaamáánɩ kɩna kɩdɛ́ɛ ɩráa bakʊ bɔdɔ́m, káma, Niníivi ńba waalá túúbá bɛkɛ́ɛ balakásɩ sáátɩ wenkí baanɩ́ɩ Ínúusa-dɛ́ɛ waázu nɛ́. Ngʊ́ wenbí bʊwɛ cé nɛ́ bɩɩgɩ́lɩ Ínúusa.» ");
INSERT INTO kdh_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Naárʊ tɔ́nzɔḿ fɩtɩ́la na ɩkpɔ́ɔ kɩ ɩmʊ́sɩ yáá ifu gbégídi kɩrɔ. Amá, wɔ́ngbɔwʊ́ʊ kɩ gɛ ɩtɩ́nɩ ɩsɔ́ɔ́dáá na kínlosí wenbá bángazʊʊ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nyáázɩ́rɛ kɛ́ɛ na nyɔ́dɔ́nʊʊ́-dɛ́ɛ fɩtɩ́la. A nyáázɩ́rɛ na ɖɩdɩ, nyɔ́dɔ́nʊʊ́ rɩ́ŋa wɛ ɖɛnyɛm-daá gɛ. Amá, a nyáázɩ́rɛ fɛ́yɩ́ ɖéyí‑ɖéyí, nyárɩ́ŋa nyɔ́wɛ temenuú-daá ɖʊɖɔ gɛ. ");
INSERT INTO kdh_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Bɩlɛ́ nɛ́, kuná laakáarɩ na ɖɛnyɛm kʊwɛ nyɔ́rɔ́ nɛ́ kɩ́kábɩsɩ temenuú. ");
INSERT INTO kdh_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","A bɩ́nnáa nyɔ́dɔ́nʊʊ́ rɩ́ŋa kɩdɛ́ɛ ɖeelí fɛ́yɩ́ temenuú-daá, kɩrɩ́ŋa kʊwɛ ɖɛnyɛm-daá gɛ nyazɩ fɩtɩ́la wónlosí nya nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yeésu bamáa ŋmatɩrɛ gɛ Faríizi ńnɩ́ naárʊ waayáa yɩ ɩdɛ́ɛ sɩ íbo ikéɖi kíɖíím. Ngɛ Yeésu woobó ɩsʊ́ʊ ɩcɔ́ɔ sɩ beɖi kíɖíím. ");
INSERT INTO kdh_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Bɩɩlá Faríizi ńnɩ́ bítí waana sɩsɩ Yeésu tasáŋ ɩnʊ́ʊ́zɩ ɩlá ɖacɩrɩ‑cɩrɩ Ɩsɔ́ɔ ɩzá-daá naanɩ́ ɩmɔ́ɔ ɩbáázɩ kíɖíím ɖíi. ");
INSERT INTO kdh_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Amá, Ɖádʊ́ʊ Yeésu wɔɔdɔ́ yɩ sɩsɩ: «Mɩ́nyɔ́ɔ́ Faríizi ńba, mɩ́nÿaalɩ́ yíka na nyɩnɔɔ́ wɔ́rɔ́ bɩka mɩ́dɩtɩŋa mɩ́dáá na ŋmɩɩlɩ́m na kidaavééníti riké. ");
INSERT INTO kdh_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mɩ́vɛ́yɩ́na lomaazɛ́ nɛ́, weení waalá bʊwɔ́rɔ́ nɛ́, bɩdɛkɛ́ɛ waadála ná bɩdaá? ");
INSERT INTO kdh_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ɩgbɔ́ɔ bɩdaá ńdɩ ɩlá kadanbʊrʊ́sɩ sarɔ́ɔ, bɩka bɩrɩ́ŋa bɩlá mɩ́ɩ ɖacɩrɩ‑cɩrɩ. ");
INSERT INTO kdh_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Nbusú ɖamáa na mɩ́ɩ Faríizi ńba! Mɩ́nvɛrɩ́ɩ yáázɩwá mɩ́nlanáa ɖóózi nɛ́ na kárɔɔ́-daá ɖóóziwá-rɔɔzɩ́-dɛ́ɛ fuú-rɔ kʊ́ɖʊńbɩ, bɩka mɩ́ngbɛɛnáa wenbí bɩjaarɛ́ɛ nɛ́ Mará-daá; tɩlɛ́ gɛ toovonúm fúu na Ɩsɔ́ɔ-dɛ́ɛ sɔɔlɩ́m. Tɩlɛ́ gɛ bɩmɔɔ́na ɩlá bɩka ɩtásɩ tɩɩganáa. ");
INSERT INTO kdh_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Nbusú ɖamáa na mɩ́ɩ Faríizi ńba! Kʊ́bɔɔ-ɖɩdáarɛ gɛ mɩ́zɔɔlɛ́ɛ cɔwʊ́ʊ Ɩsɔ́ɔ ɖaazɛɛɖɛ́ bɩka mɩ́zɔɔlɛ́ɛ ɩráa wɛ́nzɛɛ́ mɩ́ɩ wɔnásɩ-daá! ");
INSERT INTO kdh_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Nbusú ɖamáa na mɩ́ɩ Faríizi ńba! Mɩ́jɔɔ́ɔ gɛ nyazɩ bɔɔláánɩ tɩ́ńzálɩ́ ɩráa wánnʊŋɛ́ tɩrɔ bɩka baasɩ sɩsɩ bɔɔláánɩ gɛ bɩgɛ́ɛ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ńna gɛ Mará wɩlɩɖʊ́ naárʊ sɩsɩ: «Kʊ́bɔnɩ́, nyánŋmatɩ́ bɩlɛ́ nɛ́, ɖɔ́ɔ́ ɖʊɖɔ gɛ nyándʊ́ʊ́dɩ bɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ngɛ woobúsi yɩ sɩsɩ: «Nbusú ɖamáa na mɩ́ɩ ɖʊɖɔ, Mará wɩlɩɖáa! Mɩ́nzʊʊ́ ɩráa sʊʊ́tɩ káálɛ ńdɩ, amá, mɩ́nyɔ́ɔ́ mɩ́dɩtɩŋa mɩ́dándandekiná tɩ na niiká báa cʊ́kɔ sɩsɩ ɩsɩná wɛ. ");
INSERT INTO kdh_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Nbusú ɖamáa na mɩ́ɩ! Mɩ́nmáa anɖébiwá-dɛ́ɛ bɔɔláánɩ, ngʊ́ anɖébiwá bɛḿ nɛ́, mɩ́jaájaanáa waagʊ ná wɛ. ");
INSERT INTO kdh_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Bɩlɛ́ nɛ́ mɩ́ɩ́lɩ́zɩ́ seríya sɩsɩ wentí mɩ́jaájaanáa waalá nɛ́ wɔɔmɔ́ɔ mɩ́ɩ nbɩlɛ́. Káma, bɛlɛ́ baagʊ anɖébiwá nɛ́, ngɛ mɩ́nyɔ́ɔ́ mɩ́wɛ mɩ́nmáa bɛdɛ́ɛ bɔɔláánɩ. ");
INSERT INTO kdh_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Bʊrɔɔzɩ́ gɛ Ɩsɔ́ɔ-dɛ́ɛ áséńsí-daá nɛ́, wɔɔdɔ́ sɩsɩ: “Méngediríi wɛ anɖébiwá na tɩndɩnáa; bángʊ́ʊ nɛbɛ́rɛ bɩka banáázɩ nɛbɛ́rɛ.” ");
INSERT INTO kdh_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Bʊrɔɔzɩ́ nɛ́, bánvʊʊnáa zaamáánɩ kɩna kɩdɛ́ɛ ɩráa anɖébiwá rɩ́ŋa baagʊ wɛ kɔgbɔɔ ɖoo ɖúúlínya-dɛ́ɛ kabaazɩya nɛ́ bɩdɛ́ɛ tɔ́m. ");
INSERT INTO kdh_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Bɛɛ kɔgbɔɔ ɖoo Abíilu-dɛ́ɛ sɩ́m hálɩ ngɔ́nɩ Sákarɩ baagʊ yɩ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga kadɔ́ɔ-daá, sarásɩ ɖaalanɖɛ́ na Ɖacɩrɩ‑cɩrɩ ɖɩdáarɛ bɔlɔwʊtáá nɛ́. Ménveerím mɩ́ɩ sɩsɩ bánvʊʊnáa zaamáánɩ kɩna kɩdɛ́ɛ ɩráa bɩrɩ́ŋa bʊrɔ. ");
INSERT INTO kdh_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Nbusú ɖamáa na mɩ́nyɔ́ɔ́ Mará wɩlɩɖáa! Mɩ́ɩ́gbɔ́ɔ tɩlɩ́ɩ-dɛ́ɛ sááfɩ; ngʊ́ mɩ́dɩtɩŋa mɩ́dasʊ́ʊ, bɩka ɩkʊrʊ́ ɩtɔ wenbá bɔzɔɔlɛ́ɛ sɩ basʊ́ʊ nɛ́ nɩ́bááwʊ.» ");
INSERT INTO kdh_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Tɔ́ɔ, Yeésu waalɩ́ɩ ńna nɛ́, ngɛ Mará wɩlɩɖáa na Faríizi ńba waabá bɛyɛɛ ná yɩ baaná bɩka bɔ́nbɔɔzɩ́ yɩ tɔ́mwá ɖabata, ");
INSERT INTO kdh_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","bánÿɩ́m yɩ kɔdɔ́sɩ sɩ banɩ́ɩ ɩnɔɔ́-jɔ́ tɔ́m na boyuú natɩ́rɩ bobuuná yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Bɩdɛ́ɛ sáátɩ kɩḿ, ɩráa sɩnsɛ́nɩ́, wɔɔgɔ́nɩ botúúzi Yeésu-jɔ́, hálɩ bánnʊŋɛ́ ɖamá. Ńna gɛ wɔɔdɔ́ ɩwanbaaráa sɩsɩ: «Iguná laakáarɩ na Faríizi ńba-dɛ́ɛ faadɩ́nɩ bónnuudináa kpɔ́nɔ́ nɛ́. Tɩlɛ́ gɛ munááfíísi. ");
INSERT INTO kdh_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Wenbí bɩrɩ́ŋa bʊwɛ bivóo nɛ́ bínvulúu. Wenbí bɩrɩ́ŋa bʊwɛ bɩmʊ́sɛ́ɛ nɛ́, bándɩlɩ́ɩ bɩ. ");
INSERT INTO kdh_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Bʊrɔɔzɩ́ gɛ wentí tɩrɩ́ŋa sɩ ɩŋmátɩ tɩ súmúú-daá nɛ́, sɩ tɩlɩ́ɩ bayáána gɛ. Wentí sɩ ɩsáázɩ tɩ nɩgbamʊʊ́-daá ɖoo ɖamɩ́nɩ-daá nɛ́, sɩ bɔbɔ́ɔ tɩ ɖamɩ́nɩ kʊjʊ́nɩ-rɔ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Ménveerím mɩ́nyɔ́ɔ́ mɔɖɔndɩnáa sɩsɩ íkese wenbá bángʊ́ʊ tɔnʊʊ́, bɩka bɩlɛ́ bʊwɔ́rɔ́ nɛ́ bádándabɩɩzɩ balá nabʊ́rʊ ɖʊɖɔ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mánwɩlɩ́ɩ mɩ́ɩ weení bɩmɔɔ́na ise nɛ́. Ize weení a waagʊ bɩtɛ́, ɩwɛná yíko ɩɖʊ ɩrʊ́ azáába nimíni-daá nɛ́. Ɩɩ́n, ɩlɛ́ gɛ bɩmɔɔ́na ise. ");
INSERT INTO kdh_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Mányɩ sɩsɩ fárám nɔɔ́lɛ gɛ bánÿám cɩcɩ́sɩ nasʊ́nʊ́wá ya. Ngʊ́ sɩdaá nɛkɛ́rɛ fɛ́yɩ́ Ɩsɔ́ɔ waasɩ kɔrɔ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nyááná mɩ́nyɔ́ɔ́ nɛ́, bɩrɩ́ŋa na mɩ́nyɔ́ɔ́zɩ rɩ́ŋa, Ɩsɔ́ɔ nyɩ sɩgʊjʊʊ́. Bɩlɛ́ nɛ́, ɩ́kanɩ́ɩ nɩdáárɛ, mɩ́wɛná fɔ́ɔ́zɩrɛ bɩcɛzɩ́ cɩcɩ́sɩ birika.» ");
INSERT INTO kdh_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Ménveerím mɩ́ɩ sɩsɩ weení ɩrɩ́ŋa sɩ ɩŋmátɩ zamɔ́ɔ ɩzá-daá sɩsɩ ɩmʊ́ ɩgɛ́ɛ mɛ́dɛ́ɛ ńnɩ́ nɛ́, mɔ́ɔ́ Ɩrʊ́ Biyaalʊ́ ɖʊɖɔ mánŋmatɩ́ Ɩsɔ́ɔ-dɛ́ɛ malááyɩ́kawá ɩzá-daá sɩsɩ bʊdʊ́ʊ kɛ́ɛ mɛ́dɛ́ɛ ńnɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Amá, a naárʊ weegízi ma zamɔ́ɔ ɩzá-daá, béngizíi bʊdʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ malááyɩ́kawá ɩzá-daá ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Bɩka weení waaŋmátɩ ɩyɩsɩná Ɩrʊ́ Biyaalʊ́ nɛ́, Ɩsɔ́ɔ wɛ́njɛ́m yɩ, amá, weení waadʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ Kezeŋa nɛ́, Ɩsɔ́ɔ tɛ́ndɛnjɛḿ yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","A booboná mɩ́ɩ Ɩsɔ́ɔ ɖaazɛɛɖɛ́wá-daá, na wúrowá na kʊ́bɔnáa-jɔ́ sɩ bafʊʊná mɩ́ɩ tɔ́m, ɩ́kayɩ́tɩ mɩ́dɩ nŋɩ́nɩ́ sɩ ɩfʊ́ʊ nɛ́, na wentí sɩ ɩŋmátɩ nɛ́ tɩrɔ. ");
INSERT INTO kdh_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Káma, Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga wánwɩlɩ́ɩ mɩ́ɩ wentí bɩmɔɔ́na ɩŋmátɩ sáátɩ kɩḿ kɩdɩtɩŋa nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Zamɔ́ɔ-daá ńna gɛ naárʊ wɔɔdɔ́ Yeésu sɩsɩ: «Kʊ́bɔnɩ́, feeri maɖawaalʊ sɩsɩ ɩtára mána yɩ ɖɛ́dɛ́ɛ tííbí.» ");
INSERT INTO kdh_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ńna gɛ Yeésu woobúsi yɩ sɩsɩ: «Mɛ́dɛ́ɛ ńnɩ́, weení waazɩɩ ná ma sɩsɩ mávʊʊ mɩ́dɔ́m, yáá mádara mɩ́gbɩná.» ");
INSERT INTO kdh_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ngɛ weevééri wɛ sɩsɩ: «Iguná laakáarɩ na kpɩná-dɛ́ɛ sɔɔlɩ́m ɖabata; káma, báa ɩrʊ́ wɛná amáána, bɩdɛkɛ́ɛ ɩdɛ́ɛ ɖɔ́ɔ́lɛ tɩɩná iweezuú.» ");
INSERT INTO kdh_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ngɛ wɛɛgɛ́ɛ́zɩ wɛ tɔmgɛɛzɩrɛ neɖére sɩsɩ: «Ɩrʊ́ liideé-dʊ́ʊ naárʊ-dɛ́ɛ fɔɔ́ waaba ná kalá kíɖíím bɩɖɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ngɛ ɩwɛ wánmaazɩ́ wɔ́ndɔ́m sɩsɩ: “Nŋɩ́nɩ́ gɛ sɩ malá ɖɔ́. Káma, mɛ́vɛ́yɩ́na ɖɩdáarɛ ɖɩ́ndalɩ́ɩ mazɩ́ɩ kíɖíím nɛ́.” ");
INSERT INTO kdh_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ngɛ wɔɔdɔ́ sɩsɩ: “Bɛɛ wenbí sɩ malá nɛ́ nɖɔ́: mɔ́nÿɔ́m mégbééni gɛ mama kʊ́bɔńdɩ, maɖʊ mégíɖíím rɩ́ŋa na mɛ́dɛ́ɛ ɖɔ́ɔ́lɛ bɩdaá. ");
INSERT INTO kdh_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Na ńna nɛ́ mɔdɔ́ mádɩ sɩsɩ: ‘Mɛ́dɛ́ɛ ńnɩ́, nyáábá nyɔ́wɛná ɖɔ́ɔ́lɛ azíya, bɩ́ɩ́zɩ‑bɩ́ɩ́zɩ gɛ sɩ ɖɩbá ɖɩlá nya; fɛɛzɩ, ɖi nnyɔ́ɔ bɩka nɖi ɖúúlínya.’ ” ");
INSERT INTO kdh_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Amá, Ɩsɔ́ɔ wɔɔdɔ́ yɩ gɛ sɩsɩ: “Nyɛ́vɛ́yɩ́na kʊjʊʊ́ nɛ́! Nuvoowú kɩna nyánzɩ́m! Bɩɩga wenbí nyáágbɩ́ɩ́rɩ nzɩ́ɩ nɛ́, weení sɩ ɩkpɔɔná bɩlɛ́.” ");
INSERT INTO kdh_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Bɩlɛ́ gɛ weení wánmaarɩ́ ɩdɩ ɖɔ́ɔ́lɛ adɛ cé bɩka ɩvɛ́yɩ́na ɖɔ́ɔ́lɛ Ɩsɔ́ɔ-jɔ́ nɛ́, wɛ́ndɛnáa.» ");
INSERT INTO kdh_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ngɛ weevééri ɩwanbaaráa sɩsɩ: «Bʊrɔɔzɩ́ gɛ ménveerím mɩ́ɩ sɩsɩ ɩ́kayɩ́tɩ mɩ́dɩ kíɖíím sɩ iɖi na ɩcɔ́ɔ weezuú-daá nɛ́, na kúsúúdi sɩ isúu mɩ́dɔnɩ́nɩ-rɔ nɛ́ bʊrɔ. ");
INSERT INTO kdh_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Káma, weezuú waagɩ́lɩ kíɖíím bɩka tɔnʊʊ́ ɩkɩ́lɩ kúsúúdi. ");
INSERT INTO kdh_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ɩbɛɛŋná ŋɔ́ɔŋɔ́ɔ́nɩ: tídónɖuu, tɩ́dángʊḿ; tɩvɛ́yɩ́na kacáálawá yáá kpééni, amá, Ɩsɔ́ɔ wɛ́njɛlɩ́ɩ tɩ. Ngʊ́ mɩ́nyɔ́ɔ́ mɩ́ɩ́bá mɩ́wɛná fɔ́ɔ́zɩrɛ bɩkɩ́lɩ siḿsi. ");
INSERT INTO kdh_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mɩ́dáá weení wánbɩɩzɩ kʊ ɩdɛ́ɛ ɩdɩ yɩtɩ́-daá, itándúuzi iweezuú báa cʊ́kɔ. ");
INSERT INTO kdh_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","A ngʊ́ bɩlɛ́ gɛ mɩ́dándanbɩɩzɩ ɩlá wenbí bɩdanvɛ́yɩ́ káálɛ nɛ́, ngbaalá gɛ mɩ́nÿɩtɩ́ mɩ́dɩ na tɩɩganáa. ");
INSERT INTO kdh_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ɩbɛɛŋná nyɩ́ɩ́dɩ na tɩdɛ́ɛ fɛ́ɛ́dɩ́tɩ: tɩ́dánlaḿ tɩmɛ́rɛ, tɩ́dánlʊʊ. Amá, ménveerím mɩ́ɩ sɩsɩ wúro Sulemáana tɩtɩŋa na ɩdɛ́ɛ ásícé, ɩdɛ́ɛ kúsúúdi tacʊʊná tɩ. ");
INSERT INTO kdh_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","A Ɩsɔ́ɔ wɔ́nzɔ́ɔ nyɩ́ɩ́dɩ tɩwɛ sinje, bɩka ceré sɩ bɔsɔ́ tɩ nimíni nɛ́ lɩ́m ńŋɩnáa ɖɔ́, ɩdɔ́nzɔ́ɔ mɩ́ɩ bɩkɩ́lɩ bɩlɛ́? Toovonúm fáa tɔɖɔ́ɔ-dɩnáa mɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Mɩ́nyɔ́ɔ́ ɩ́kakʊ́sɩ mɩ́laakáarɩ sɩsɩ mɩ́njáádɩ wenbí sɩ iɖi nɛ́, yáá wenbí sɩ ɩnyɔ́ɔ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Káma, bɩlɛ́ bɩrɩ́ŋa gɛ ɖúúlínya-daá ɩráa baasɩ Ɩsɔ́ɔ nɛ́ wánjáádɩ báa sáátɩ wenkí; Mɩ́jaa nyɩ sɩsɩ bɩlɛ́ bɩjɔɔ́ɔ mɩ́ɩ takáásɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ɩbaná ɩdɛ́ɛ kowúrɔ́ɔ cáádɩ na bafa mɩ́ɩ bɩlɛ́ ɩmʊ́ bɩrɩ́ŋa batásɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Ɩ́kanɩ́ɩ nɩdáárɛ, mázamɔ́ɔyɔ́ɔ; káma, Mɩ́jaa waaɖʊ sɩsɩ wénÿelíi mɩ́ɩ ɩsʊ́ʊ ɩdɛ́ɛ kowúrɔ́ɔ-daá. ");
INSERT INTO kdh_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ɩyá mɩ́gbɩná bɩka ɩkpɔ́ɔ biliideé ɩlá kadanbʊrʊ́sɩ sarɔ́ɔ. Ɩnyára mɩ́dɩ fátakásɩ sɩ́dánzɩḿ nɛ́, ɩjáa ɖɔ́ɔ́lɛ ɩmáárɩ ɩsɔ́ɔ́dáá lénlé ŋmɩɩlʊ́ tónduu bɩka tííre tánmʊʊ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Káma, lénlé mɩ́dɛ́ɛ ɖɔ́ɔ́lɛ wɛ nɛ́, ńna ɖʊɖɔ gɛ mɩ́laakáarɩ wɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Ɩnyáárɩ ɖanbárawá mɩ́ɖamáa bɩka mɩ́vɩtɩ́lawá sɔmáa. ");
INSERT INTO kdh_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mɩ́nyɔ́ɔ́ ɖʊɖɔ ɩjɔ́ɔ nyazɩ ɩráa bagʊ́bɔnɩ́ wɛɛɖɛ́ɛ hiije, ngɛ bɔjɔɔ́ɔ baɖamáa ɩdɛ́ɛ kabɩsɩ́ sɩsɩ a waajáŋ ɩtála ɩkɔ́tɩ, batʊlʊ́ yɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bɔwʊtá-dɩnáa wenbá bagʊ́bɔnɩ́ sɩ ɩkábɩsɩ ɩmɔɔná wɛ bɔjɔɔ́ɔ bána baazá nɛ́ gɛ wenbi-niíni-dɩnáa. Ménveerím mɩ́ɩ toovonúm sɩsɩ wɔ́ngbɔwʊ́ʊ ɩdɩmɛ́rɛ kpɩná isúu, ɩtɔ́ wɛ bɔcɔ́ɔ bɩka ɩɖʊ wɛ kíɖíím beɖi. ");
INSERT INTO kdh_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","A nuvoolɔwʊ́rɛ gɛ wɔɔgɔ́nɩ yáá asʊbáa, ngɛ bɔwɛ bɔjɔɔ́ɔ bɩlɛ́ bana baazá, wenbi-niíni-dɩnáa gɛ bɛgɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Iyuú ɩtɩlɩ́ kazɔ́ɔ sɩsɩ a ɖoo ɖɔɔ́-dʊ́ʊ fʊnnyɩ sáátɩ wenkí ɖéyí‑ɖéyí ŋmɩɩlʊ́ sɩ ɩkɔ́nɩ ɩŋmɩ́ɩ́lɩ nɛ́, ídénÿelí yɩ ɩsʊ́ʊ ɩɖaána-daá ɩŋmɩ́ɩ́lɩ. ");
INSERT INTO kdh_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mɩ́nyɔ́ɔ́ ɖʊɖɔ ivére, káma, sáátɩ wenkí mɩ́raaɖʊ́ʊ́na nɛ́ gɛ Ɩrʊ́ Biyaalʊ́ sɩ ɩkɔ́nɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ngɛ Pétro sɩsɩ: «Ɖádʊ́ʊ, ɖɔ́ɔ́ ɖériké gɛ nyɛ́ngɛɛzɩ́ tɔ́m tɩna yáá ɩráa rɩ́ŋa.» ");
INSERT INTO kdh_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ngɛ Ɖádʊ́ʊ sɩsɩ: «Bɔwʊtá-dʊ́ʊ weení kɛ́ɛ na áséńsí-dʊ́ʊ bánbɩɩzɩ́ balá yɩ yaraɖá. Weení ɩgʊ́bɔnɩ́ wánbɩɩzɩ́ ɩsɩ́ɩ yɩ kʊ́bɔńdɩ bɔwʊtá-dɩnáa baaganáa-rɔ sɩsɩ ɩ́fa wɛ kíɖíím beɖi sáátɩ wenkí bɩ́nbɔɔzɩ́ nɛ́ gɛ. ");
INSERT INTO kdh_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Bɔwʊtá-dʊ́ʊ weení ɩgʊ́bɔnɩ́ wɔ́ngɔnɩ́ ɩmɔɔná yɩ ɩwɛ wánváa baaganáa kíɖíím nɛ́, ɩgɛ́ɛ wenbi‑niíni-dʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Toovonúm gɛ ménveerím mɩ́ɩ sɩsɩ, ɩgʊ́bɔnɩ́ wánzɩɩ́ yɩ kʊ́bɔńdɩ ɩdɛ́ɛ ɖɔ́ɔ́lɛ rɩ́ŋa-rɔ. ");
INSERT INTO kdh_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Amá, a bɔwʊtá-dʊ́ʊ ɩmʊ́ wɔɔdɔ́ iwenbiré-daá sɩsɩ: “Mágʊ́bɔnɩ́ tɔ́ngɔnɩ́ lɛlɛɛɖɔ́,” ngɛ waazʊ́ʊ bɔwʊtá-dɩnáa aláa na abaaláa baaganáa mám, ɩmʊ́ iɖi, ɩnyɔ́ɔ bɩɖɛ́ɛ́zɩ yɩ; ");
INSERT INTO kdh_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","bɔwʊtá-dʊ́ʊ ɩmʊ́ ɩgʊ́bɔnɩ́ sɩ ɩkɔ́nɩ wɩ́rɛ wenɖé ɩraaɖʊ́ʊ́na nɛ́ gɛ, na alɩwáátɩ wenkí waasɩ kɩ nɛ́. Ɩgʊ́bɔnɩ́ wánbá ɩnáázɩ yɩ bɩka ɩfɛ́rɛ yɩ toovonúm fɛ́yɩ́-dɩnáa-dɛ́ɛ kɩvɛrɛwʊ. ");
INSERT INTO kdh_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Bɔwʊtá-dʊ́ʊ weení ɩnyɩ ɩgʊ́bɔnɩ́-dɛ́ɛ sɔɔlɩ́m, ngɛ ɩdakpɩ́ɩ́rɩ nabʊ́rʊ, bɩka ɩdalá wenbí ɩlɛ́ ɩzɔɔlɛ́ɛ nɛ́, bánbá bosúti yɩ agbáázá. ");
INSERT INTO kdh_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Bɩɩga weení waafʊnzɩ ɩgʊ́bɔnɩ́ sɔɔlɛ́ɛ wenbí nɛ́, ngɛ waalá lakásɩ wensí sɩrɔ bɩmɔɔ́na bamá yɩ nɛ́, ɩlɛ́ ɩdɛ́ɛ masɩ́tɩ tángɩlɩ́ yɩ. Weení beejéle yɩ bɩɖɔ́ɔ nɛ́, bɔ́ndɔbɔɔzɩ́ yɩ ɖʊɖɔ gɛ bɩɖɔ́ɔ; weení baazɩɩná yɩ bɩɖɔ́ɔ nɛ́, bɔ́nbɔɔzɩ́ yɩ ɖʊɖɔ gɛ bɩɖɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Mɔ́ɔ́gɔ́nɩ sɩ maɖʊ nimíni adɛ laadɔ́ɔ-rɔ; ngɛ máábá mɔ́zɔɔlɛ́ɛ sɩsɩ ńŋɩnáa ɖɔ́ nɛ́, ɩ́fʊ́ńmʊʊ. ");
INSERT INTO kdh_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Sɩ belíri ma wahála lɩ́m nabɩ́rɩ-daá, bedeliri tá ma bɩdaá nɛ́, málaakáarɩ fɛ́yɩ́ adɛ. ");
INSERT INTO kdh_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ɩ́kamáázɩ sɩsɩ fɛɛzɩrɛ gɛ mɔ́ɔ́gɔ́ná adɛ laadɔ́ɔ-rɔ. Aayɩ́, ménveerím mɩ́ɩ sɩsɩ mɔ́ɔ́gɔ́nɩ gɛ sɩsɩ na ɩráa ɩ́kanɩɩná ɖamá. ");
INSERT INTO kdh_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Káma, kpɔɔná lɛlɛɛɖɔ́, koobíre-daá lé ɩráa nɔɔ́nʊ́wá wɛ nɛ́, bándarɩ́ɩ ɖamá: noódoozo wángʊrʊ́ʊna nɔɔ́lɛ, nɔɔ́lɛ ɩkʊrʊ́na noódoozo. ");
INSERT INTO kdh_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Caáwʊ wángʊrʊ́ʊna biyaalʊ́ʊ, biyaalʊ́ʊ ɩkʊrʊ́na caáwʊ; kɔɔ́wʊ wángʊrʊ́ʊna wɛɛlʊ́ʊ, wɛɛlʊ́ʊ ɩkʊrʊ́ na kɔɔ́wʊ, wɔ́nʊ́ʊ wángʊrʊ́ʊna awónboolú, awónboolú ɩkʊrʊ́na wɔ́nʊ́ʊ.» ");
INSERT INTO kdh_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ngɛ weedéféeri zamɔ́ɔ sɩsɩ: «A mɩ́ɩ́ná ŋmɩnʊʊ́ wɔɔgɔ́jɔ́ɔ ná wɩ́sɩ ɖaagazalaɖɛ́ fáráńdɩ́, mɩ́ndɔ́m ńna‑ńna sɩsɩ: “Tɛ́ɛ́wʊ wánnɩɩ́,” bɩka bifu bɩlá bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","A fefelimá wɛ́nvɛtɩnáa kpáa-daá, mɩ́ndɔ́m sɩsɩ: “Iyolúu wánlám.” Bɩka bifu bɩlá bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Munáávikíwá, mɩ́nyɩ adɛ laadɔ́ɔ na ɩsɔ́ɔ́dáá-dɛ́ɛ yáásɩ́wá kutoluú, bɩ́nlám nŋɩ́nɩ́ gɛ mɩ́dándɩlɩ́ wenbí bɩ́nlám sáátɩ kɩna nɛ́ bugutoluú.» ");
INSERT INTO kdh_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Ngbaalá gɛ mɩ́dɩtɩŋa mɩ́dánjaa ɩtɩlɩ́ wenbí bɩzɩɩzɛ́ɛ Ɩsɔ́ɔ-jɔ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","A nyána nbáɖaa mɩ́nɖɛɛ́ tɔ́m fʊ́ʊ́dɩ wúro-jɔ́, nyɔɔzɩ nyána yɩ mɩ́lɔ́wʊ́táá mɩ́wɛ nɩ́bááwʊ-daá nɛ́, na íkoboná nya tɔmvʊʊrʊ́-jɔ́, ɩlɛ́ ɩkpɔ́ɔ nya icéle sɔ́ɔ́jawá bɔtɔ nya sáráka. ");
INSERT INTO kdh_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ménveerím nya sɩsɩ a ńdɛfɛrɛ tá hálɩ bɩkpɛdɩ́na fárám kegbiirinɔ́ɔ ńgɩ, nyɛ́vɛ́yɩ́ nyánlɩɩ́ ńna.» ");
INSERT INTO kdh_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Bɩdɛ́ɛ sáátɩ kɩḿ gɛ ɩráa nɛbɛ́rɛ wɔɔgɔ́nɩ bándɩ́m Yeésu Galilée ńba wenbá Piláatɩ weeyéle bakʊ wɛ sáátɩ wenkí bɔwɛ bánlám Ɩsɔ́ɔ sarásɩ nɛ́ bɛdɛ́ɛ tɔ́m. ");
INSERT INTO kdh_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Mɩ́nmaazɩ́ sɩsɩ Galilée ńba bɛḿ bɛgɛ́ɛ alaháácɩ́-dɩnáa kʊ́bɔnáa bakɩ́lɩ Galilée ńba baaganáa-rɔ gɛ baazɩ́ bɩdɛ́ɛ sɩ́m? ");
INSERT INTO kdh_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Aayɩ́. Amá, ménveerím mɩ́ɩ sɩsɩ a mɩ́dɛkɛ́ɛ ɩlá túúbá, mɩ́nzɩ́m mɩ́rɩ́ŋa ńŋɩnáa bɛlɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Yáá ɩráa fuú na lutoozo bana wenbá Silowée ɖaḿ kiiwóro nɛ́ kɩɩzála bɔrɔ basɩ́ nɛ́, mɩ́nmaazɩ́ sɩsɩ bɛlɛ́ bɛgɛ́ɛ yɩsɩráa bɩkɩ́lɩ Yerusalɛ́ɛm ńba rɩ́ŋa? ");
INSERT INTO kdh_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Aayɩ́. Amá, ménveerím mɩ́ɩ sɩsɩ a mɩ́dɛkɛ́ɛ ɩlá túúbá, mɩ́nzɩ́m mɩ́rɩ́ŋa ńŋɩnáa bɛlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ngɛ Yeésu waaŋmatɩná wɛ na tɔmgɛɛzɩrɛ ɖɩna sɩsɩ: «Ɩrʊ́ naárʊ wɛná na figíyée tɩɩwʊ́ ɩdɛ́ɛ víinyi fɔɔ́-daá. Woobó sɩsɩ ɩkɔgɔ́rɩ́ kibíya nɛ́, ngɛ ɩdana nabʊ́rʊ. ");
INSERT INTO kdh_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ngɛ wɔɔdɔ́ weení wɛ́nbɛɛŋ́ víinyi fɔɔ́ nɛ́ sɩsɩ: “Bɛɛ́ɛ, bɩɩlá bɩ́ɩ́zɩ nasúdoozo nɖɔ́ mɔ́ngɔnɩ́ sɩsɩ mɔgɔrɩ́ figíyée kɩna kibíya nɛ́, mádánnáa nabʊ́rʊ. Bɩlɛ́ nɛ́, bɛlɩ́ kɩ. We-rɔɔzɩ́ gɛ kɩ́nnyɔɔ́ adɛ faala.” ");
INSERT INTO kdh_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ngɛ weení wɛ́nbɛɛŋ́ víinyi fɔɔ́ nɛ́ woobúsi yɩ sɩsɩ: “Kʊ́bɔnɩ́, yele kɩ kɩtásɩ kɩcɔ́ɔ bɩ́nɩ ceení, bɩka mobuúdi kɩdɛɛzɩ́ malára mamɩ́lɩ maɖʊ fuúle. ");
INSERT INTO kdh_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","A máálá bɩlɛ́, nabʊ́rʊ bɩ́nɩ kɩ́falʊ́ kɩ́nɖʊ́ʊ bíya. A bɩlɛ́ gɛ kɩdaɖʊ, na nÿéle bɛbɛlɩ́ kɩ.”» ");
INSERT INTO kdh_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Fɛɛzɩrɛ wɩ́rɛ neɖére gɛ Yeésu wɛ wánwɩlɩ́ɩ Ɩsɔ́ɔ-dɛ́ɛ tɔ́m Ɩsɔ́ɔ ɖaazɛɛɖɛ́ neɖére-daá. ");
INSERT INTO kdh_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Alʊ́ naárʊ wɛ ńna; alʊ́ ɩmʊ́, zííni nakɩ́rɩ waazʊ́ʊ yɩ kɩɖʊ yɩ kʊdɔḿ bʊwɛná bɩ́ɩ́zɩ fuú na lutoozo nbɩlɛ́; biilúúzi yɩ gɛ igoodée bɩlɛ́, bɩka ɩ́dánbɩɩzɩ ɩsɩ́ɩ́zɩ ɩdɩ. ");
INSERT INTO kdh_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yeésu waana yɩ nɛ́, waayáa yɩ, ngɛ wɔɔdɔ́ yɩ sɩsɩ: «Ɖɔ́gɔɔ, nyɛ́dɛ́ɛ kʊdɔḿ wɛɛdɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ngɛ waadɩ́nɩ ɩnʊ́ʊ́zɩ ɩrɔ, alʊ́ ɩcáŋ ɩkʊrʊ́ ɩzɩɩzɛ́ɛ ńna‑ńna, ɩbáázɩ Ɩsɔ́ɔ sám. ");
INSERT INTO kdh_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Amá, ńŋɩnáa Yeésu waawáázɩ ɩrʊ́ Fɛɛzɩrɛ wɩ́rɛ bɩlɛ́ nɛ́, Ɩsɔ́ɔ ɖaazɛɛɖɛ́-dɛ́ɛ kʊ́bɔnɩ́ wɛɛyɛ́ɛ bɩdɛ́ɛ baaná ngɛ wɔ́ndɔ́m zamɔ́ɔ sɩsɩ: «Wɛ́ loɖo wɛ ná sɩ balá tɩmɛ́rɛ, bɩlɛ́ nɛ́ ɩgɔ́nɩ wɛ́ amʊ́ adaá bawáázɩ mɩ́ɩ, bɩdɛkɛ́ɛ Fɛɛzɩrɛ wɩ́rɛ gɛ sɩsɩ ɩ́kɔnɩ bawáázɩ mɩ́ɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ńna gɛ Ɖádʊ́ʊ woobúsi yɩ sɩsɩ: «Munáávikíwá bana ɖɔ́! Mɩ́dáá naárʊ wɛ sɩsɩ Fɛɛzɩrɛ wɩ́rɛ, ɩ́dánlɩzɩ́ ɩdɛ́ɛ nɔ́wʊ yáá ɩdɛ́ɛ kpangbɔ́ɔ kaɖaaɖɩ́ɩ́ɖɛ iboná kɛ kɔkɔ́nyɔ́ɔ lɩ́m? ");
INSERT INTO kdh_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ngɛ alʊ́ ceení, Ibrahím wɛɛlɛ́ɛ weení Sitáánɩ waagba yɩ ɩɖɩ bɩ́ɩ́zɩ fuú na lutoozo nɖɔ́ nɛ́ ní. Bɩdɔmɔɔná bobóɖi yɩ nibiiré ɖɩḿ ɖɩdaá Fɛɛzɩrɛ wɩ́rɛ?» ");
INSERT INTO kdh_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yeésu wɛ wánŋmatɩ́ bɩlɛ́ nɛ́, ngɛ fɛɛrɛ́ waagba wenbá bádánjaa yɩ nɛ́, amá, zamɔ́ɔ kɩlɛ́ nɛ́, bɩjɔɔ́ɔ kɩ niíni kɩ́nvaarɩ́ mááɖéwá wánlám tɩ nɛ́ tɩrɔ. ");
INSERT INTO kdh_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ngɛ Yeésu waadásɩ ɩtɔ́ sɩsɩ: «Wé gɛ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ waalɩ́ɩ. Wé gɛ mánbɩɩzɩ́ mɛgɛɛzɩná kɛ. ");
INSERT INTO kdh_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kaalɩ́ɩ báńŋɩ́náyɔ́ɔ bú ɩrʊ́ wɔɔgbɔ́ɔ iɖúu ɩvɔɔ́-daá nɛ́ gɛ. Wɔɔnyɔ nɛ́, ngɛ ɩdɛ́ɛ tikú waabɩ́sɩ tɩɩwʊ́ bɩka siḿsi wɔ́ngɔnɩ́ sɩ́nlám sɩdɛ́ɛ ɖɛ́ńɖɛ́lá kɩdɛ́ɛ wʊláázɩ-daá.» ");
INSERT INTO kdh_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yeésu waadásɩ ɩtɔ́ sɩsɩ: «Wé gɛ mánbɩɩzɩ́ mɛgɛɛzɩná Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kɔjɔɔ́ɔ gɛ nyazɩ kpɔ́nɔ́ faadɩ́nɩ alʊ́ wɔɔgbɔ́ɔ inuudiná kpɔ́nɔ́ mʊlʊ́m agúwe natúdoozo hálɩ kpɔ́nɔ́ mʊ́tʊ rɩ́ŋa ɩkpa nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yeésu wɛ́nɖɛɛ́ Yerusalɛ́ɛm nɛ́, wɔɔgbɔɔná tɛ́ɛ́dɩwá-daá na tɛɛbíízi-daá bɩka wánwɩlɩ́ɩ ɩráa Ɩsɔ́ɔ-dɛ́ɛ tɔ́m. ");
INSERT INTO kdh_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ngɛ ɩrʊ́ naárʊ wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Kʊ́bɔnɩ́, yaatá ɩráa cʊ́kɔ sɩ iyuú na lɛ́ɛ́dɩ bɩlɛ́.» Ngɛ Yeésu woobúsi sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Ɩjáárɩ mɩ́dɩ ɩsʊʊná wɔnɔɔ́ kadawála nɛ́, káma, ménveerím mɩ́ɩ sɩsɩ ɩráa ɖabata wɔ́ngɔnɩ́ bacáárɩ badɩ sɩ basʊ́ʊ, amá, bádánbɩɩzɩ. ");
INSERT INTO kdh_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","A bɩgɛ́ɛ sɩsɩ ɖɔɔ́-dʊ́ʊ waagʊrʊ́ ɩtɔ wɔnɔɔ́ ngɛ mɩ́gɔ́wɛ ná asʊ gɛ mɩ́ɩ́báázɩ tará kɔtɩ́ mɩ́ndɔ́m sɩsɩ: “Kʊ́bɔnɩ́, tʊlʊ́ ɖáa” wónbusí mɩ́ɩ sɩsɩ: “Máásɩ lénlé mɩ́ɩ́lɩ́ɩ́ná nɛ́.” ");
INSERT INTO kdh_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ńna gɛ mínbusí yɩ sɩsɩ: “Ɖána nya ɖééɖí ɖɩnyɔ́ɔ, ngɛ nyááwɩ́lɩ Ɩsɔ́ɔ-dɛ́ɛ tɔ́m ɖɛ́dɛ́ɛ wɔnásɩ-daá.” ");
INSERT INTO kdh_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Na ɩtásɩ ɩtɔ́ mɩ́ɩ sɩsɩ: “Máásɩ lénlé mɩ́ɩ́lɩ́ɩ́ná nɛ́. Ɩlaná ma bolíni mɩ́ɩ wenbá mɩ́rɩ́ŋa mɩ́nlám alaháácɩ́wá nɛ́.” ");
INSERT INTO kdh_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ńna gɛ mínwií ɩlá mányɩ lé sáátɩ wenkí mɩ́nganáa Ibrahím, na Ɩsaáka, na Yaakúbu bɩtasɩná anɖébiwá rɩ́ŋa Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-daá bɩka mɩ́ɩ mɩ́gɔ́lɔ́ɔ asʊ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ɩráa wángalɩɩnáa wɩ́sɩ ɖaagalɩɩɖɛ́, na sɩɖaagazalaɖɛ́, na fúu ɩsɔ́ɔ́dáá, na fúu adɛ bɔkɔ́nɩ beɖi ɖíína Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-daá. ");
INSERT INTO kdh_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ńna gɛ wenbá beegbííri lɛlɛɛɖɔ́ nɛ́, badaá nɛbɛ́rɛ wɔ́ngɔnɩ́ bɛtɛ nɩ́bááwʊ; bɩka nɛbɛ́rɛ wenbá bɛɛdɛ nɩ́bááwʊ lɛlɛɛɖɔ́ nɛ́, bɔkɔ́nɩ bekpííri.» ");
INSERT INTO kdh_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Bɩdɛ́ɛ sáátɩ kɩḿ gɛ Faríizi ńba nɛbɛ́rɛ woogóduu Yeésu-jɔ́ bɔtɔ́ yɩ sɩsɩ: «Lɩɩ cé nɖɛ́ɛ ɖeelí, káma Eróodi sɔɔlɛ́ɛ sɩ ɩkʊ nya.» ");
INSERT INTO kdh_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Ibó ifééri bʊbɔtʊ́ʊ ɩmʊ́ sɩsɩ: “Mɔ́nɖɔwʊ́ʊ zííniwá, bɩka mawáázɩ kʊdɔmɩ́nɩ sinje na ceré, na toozo wɩ́rɛ nɛ́, magʊ́ʊ́rɩ mádɩmɛ́rɛ.” ");
INSERT INTO kdh_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Amá, sinje na ceré na kínvém nɛ́ bɩmɔɔ́na mɛdɛ́ɛ́zɩ mánɩ́bááwʊ. Káma, bɩdɔmɔɔná anɖébi ɩsɩ́ ɖeelí bɩdɛkɛ́ɛ Yerusalɛ́ɛm. ");
INSERT INTO kdh_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yerusalɛ́ɛm, Yerusalɛ́ɛm! Nyɔ́ɔ́ weení nyángʊ́ʊ anɖébiwá bɩka nyɔ́nÿɔwʊ́ʊ wenbá Ɩsɔ́ɔ wéngediríi nya wɛ nɛ́ bɔ́ bánzɩ́m nɛ́, bʊrɔ nŋɩ́nɩ́ gɛ mɔ́ɔ́zɔ́ɔ́lɩ sɩ modúúzi nyébíya ńŋɩnáa konɖóowú wónduuzí kibíya kigelíni-dɛ nɛ́. Amá, mɩ́dɔ́sɔɔlɩ bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Bɩlɛ́ nɛ́, Ɩsɔ́ɔ wándalɩnáa mɩ́ɩ na mɩ́dɛ́ɛ́dɩ. Ngɛ ménveerím mɩ́ɩ sɩsɩ mídóndokúti ɩna ma hálɩ bɩkɔ́nɩ bɩtála sáátɩ wenkí sɩ ɩtɔ́ sɩsɩ: “Sám mɔɔ́na kʊ weení ɩgɛgɛrɛŋɛ Ɖádʊ́ʊ Ɩsɔ́ɔ yɩ́ɖɛ-daá nɛ́.”» ");
INSERT INTO kdh_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Fɛɛzɩrɛ wɩ́rɛ neɖére gɛ Yeésu woobó Faríizi ńba-dɛ́ɛ kʊ́bɔnáa-daá naárʊ-dɛ́ɛ sɩ iɖi kíɖíím. Ngɛ wenbá bɔwɛ ńna nɛ́ wɛ beveráa yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ɩrʊ́ naárʊ kʊdɔnvuurúu wɛná yɩ nɛ́, wɛ waazá-daá. ");
INSERT INTO kdh_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ngɛ Yeésu wɔɔbɔ́ɔ́zɩ Mará wɩlɩɖáa kʊ́bɔnáa na Faríizi ńba sɩsɩ: «Ɖɛ́dɛ́ɛ Mará waava nɩ́bááwʊ sɩsɩ báwaazɩ ɩrʊ́ Fɛɛzɩrɛ wɩ́rɛ yáá bɩdafa.» ");
INSERT INTO kdh_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Amá, bɛlɛ́ bozumáa. Ńna gɛ Yeésu weedekiná kʊdɔndʊ́ʊ ɩwáázɩ yɩ, bɩka ɩtɔ́ yɩ ɩɖɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ngɛ wɔɔdɔ́ wɛ sɩsɩ: «A mɩ́dáá naárʊ biyaalʊ́ yáá ɩdɛ́ɛ nɔ́wʊ waazála lɔkɔ-daá, ɩ́danjáŋ iyéle bakálɩzɩ́ yɩ báa bɩgɛ́ɛ Fɛɛzɩrɛ wɩ́rɛ?» ");
INSERT INTO kdh_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Amá, badabɩ́ɩ́zɩ bobúsi natɩ́rɩ. ");
INSERT INTO kdh_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yeésu waana sɩsɩ wenbá baayáa wɛ kíɖíím ɖíi nɛ́ wɛ bángbáa adá kaɖaa ńná nɛ́, ngɛ waaŋmatɩná wɛ na tɔmgɛɛzɩrɛ ɖɩna sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«A bɩgɛ́ɛ sɩsɩ naárʊ waayáa nya hiije-dɛ́ɛ jíńgáárɩ́-daá, nkobó njɔ́ɔ ɖɩdáarɛ kaɖaa ńɖɛ-daá. Káma, bɩ́nbɩɩzɩ́ bɩlá sɩsɩ baagáyáa naárʊ ɖʊɖɔ ɩgɛ́ɛ gírímá-dʊ́ʊ bɩcɛzɩ́ nyɔ́ɔ́, ");
INSERT INTO kdh_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","na weení waagáyáa nyána ɩlɛ́ nɛ́, ɩtɔ́ nya sɩsɩ: “Kʊrʊ́ ńna nga yɩ ɖɩdáarɛ.” Ńna nɛ́, bɩ́nlám nya fɛɛrɛ́ sɩ nbó ngɔ́jɔ́ɔ ɖɩdáarɛ kegbiirinɔ́ɔ ńɖɛ-daá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Amá, a bɩgɛ́ɛ sɩsɩ baayáa nya, bo ngɔ́jɔ́ɔ ɖɩdáarɛ kegbiirinɔ́ɔ ńɖɛ-daá, na a weení waayáa nya nɛ́ waagázʊʊ, ɩtɔ́ nya sɩsɩ: “Mɔɖɔndɩ, kɔnɩ njɔ́ɔ bɩɩzá-daá.” Ńna nɛ́, bɩ́nɖɔɔzɩ́ nya wenbá barɩ́ŋa baagáyáa nyána wɛ jíńgáárɩ́ ɖíi nɛ́ baazá-daá. ");
INSERT INTO kdh_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Káma, a weení waagbáázɩ ɩdɩ nɛ́, béndisí yɩ, ngɛ a weení weedísi ɩdɩ nɛ́, bángbaazɩ́ yɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Bʊwɔ́rɔ́ nɛ́, ngɛ wɔɔdɔ́ weení waagáyáa yɩ nɛ́ sɩsɩ: «A bɩgɛ́ɛ sɩsɩ nyáálá kíɖíím ɩdaawʊ́ yáá ɖaanɩ́ŋa ngɛ sɩ nva ɩráa, nkakáyáa nɖɔndɩnáa, yáá ngoobíya, yáá nyɛ́dɛ́ɛ ńba, cáńfáná liideé-dɩnáa badɩláána nya nɛ́. Tɩ́fa, bɛlɛ́ ɖʊɖɔ bɔ́ngɔnɩ́ bayáa nya wɩ́rɛ neɖére bɛfɛ́rɛ nya wenbí nyáálá wɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Amá, a bɩgɛ́ɛ sɩsɩ nyáálá ɖíína, kayaa kadanbʊrʊ́sɩ, na wenbá bɔdɔnɩ́nɩ-dɛ́ɛ fɔɔlɩ́nɩ rɩ́ŋa raazulukée nɛ́, na wenbá bénziíri nɛ́, na njɛma. ");
INSERT INTO kdh_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","A nyáálá bɩlɛ́, nyónÿuú wenbi‑niíni, káma, bádánbɩɩzɩ sɩsɩ bɛfɛ́rɛ nya. Ɩsɔ́ɔ wɛ́ngɛvɛrɩ́ɩ nya kífeńbi lanɖáa-dɛ́ɛ ɩsɩɖáa-daá fém sáátɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Wenbá bɔwɛ bénɖíi kíɖíím bána Yeésu nɛ́, badaá naárʊ waanɩ́ɩ tɔ́m tɩḿ nɛ́, ngɛ wɔɔdɔ́ Yeésu sɩsɩ: «Wenbi-niíni-dʊ́ʊ gɛ weení sɩ ikéɖí nyégíɖíím Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-daá nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ngɛ Yeésu woobúsi yɩ sɩsɩ: «Ɩrʊ́ naárʊ waala ná ɖíína kʊ́bɔńgɩ nakɩ́rɩ, ngɛ waayáa ɩráa bɔɖɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ɖíína kíɖíím waabɩ́ɩ nɛ́, ngɛ weedíri ɩdɛ́ɛ bɔwʊtá-dʊ́ʊ sɩ ikéveeri wenbá waayáa wɛ nɛ́ sɩsɩ bɔ́kɔnɩ, káma, bɩrɩ́ŋa bɩ́ńbɩ́ɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Amá, barɩ́ŋa booyóózi boyuú kúbuunátɩ na bɩfa bekízi boɖé. Kaɖaa ńnɩ́ wɔɔdɔ́ bɔwʊtá-dʊ́ʊ sɩsɩ: “Máámʊ́ fɔɔ́ nɛkɛ́rɛ, ngɛ bɩ́nbɔɔzɩ́ sɩsɩ mobó mɛgɛ́bɛɛŋ kɛ, bɩlɛ́ nɛ́ la suúru, mɔ́nbɔɔzɩ́ nɩ́bááwʊ.” ");
INSERT INTO kdh_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Naárʊ sɩsɩ: “Máámʊ́ náánɩ tɩ́nvarɩ́m nɛ́ natɩ́ntɩ́lɛ hálɩ bʊrɔ nabʊ́nʊ́wá ɖɔ́, ngɛ mɔ́zɔɔlɛ́ɛ mobó magámaazɩ tɩ mɛbɛ́ɛ. Bɩlɛ́ nɛ́, la suúru mɔ́nbɔɔzɩ́ nɩ́bááwʊ.” ");
INSERT INTO kdh_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Lí ńnɩ́ sɩsɩ: “Lɛlɛɛɖɔ́ gɛ máálá hiije ɖɔ́, bʊrɔɔzɩ́ nɛ́, mádánbɩɩzɩ mobó.” ");
INSERT INTO kdh_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Bɔwʊtá-dʊ́ʊ wɔɔlɔ́ɔ ɩbɩ́sɩ nɛ́, ngɛ waadɩ́ bɩrɩ́ŋa ifééri ɩgʊ́bɔnɩ́. Ńna gɛ ɖɔɔ́-dʊ́ʊ waabá ɩyɛ́ɛ baaná, ngɛ wɔɔdɔ́ ɩdɛ́ɛ bɔwʊtá-dʊ́ʊ sɩsɩ: “Kpɛdɩ́ ndoózi nbó tɛ́ɛ́dɩ wɔnásɩ-daá, na nɩ́báánɩ-daá ngɔ́gɔná kadanbʊrʊ́sɩ, na wenbá biilí wɛ nɛ́, na njɛma, na wenbá bénziíri nɛ́ cé.” ");
INSERT INTO kdh_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Bɩɩdásɩ cʊ́kɔ nɛ́, ngɛ bɔwʊtá-dʊ́ʊ wɔɔgɔ́nɩ ifééri yɩ sɩsɩ: “Kʊ́bɔnɩ́, wenbí nyɔ́ɔ́bɔ́ɔ́zɩ sɩsɩ bála nɛ́ biizúluki, amá, ɖɩdáarɛ woogúti bɩka ɖʊɖɔ.” ");
INSERT INTO kdh_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ngɛ kʊ́bɔnɩ́ sɩsɩ: “Bo nlɩ́ɩ fásɩ nɩ́báánɩ-daá, na kárɔɔ́wá kutolíni, ɩráa wenbá barɩ́ŋa sɩ ngɛ́gɛtɩ wɛ nɛ́, kajaarɩ wɛ bɔkɔ́nɩ basʊ́ʊ mɛ́dɛ́ɛ, na máɖaána isu. ");
INSERT INTO kdh_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Káma, ménveerím mɩ́ɩ sɩsɩ kaɖaa ńba wenbá barɩ́ŋa mááyáa wɛ nɛ́, badaá báa naárʊ tánɖɩ́m mɛ́dɛ́ɛ ɖíína kíɖíím.”» ");
INSERT INTO kdh_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Bɩlɛ́ bʊwɔ́rɔ́ gɛ Yeésu wɔɔgbɔ́ɔ nɩ́bááwʊ wɛ́nɖɛɛ́ bɩka zamɔ́ɔ tuutúúma fóo yɩ. Ngɛ wɛɛgɛ́ɛ́zɩ ɩdɩ ɩfaná wɛ ɩzá ɩtɔ́ wɛ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«A weení ivóo ma gɛ ɩdɔsɔ́ɔ́lɩ ma bɩkɩ́lɩ ɩgɔɔ yáá ɩjaa, yáá ɩɖɛɛlʊ́ na ibíya, yáá igoobíya aláa na abaaláa, yáá ɩdɩtɩŋa iweezuú nɛ́, ɩlɛ́ ɩ́dánbɩɩzɩ ɩbɩ́sɩ mɛ́dɛ́ɛ wanbaarʊ́. ");
INSERT INTO kdh_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Weení ɩdɔkpɔ́ɔ ɩdɛ́ɛ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ ɩfɔɔ́lɩ ɩtɩ́nɩ mɔ́wɔ́rɔ́ nɛ́, ɩlɛ́ ɩ́dánbɩɩzɩ ɩbɩ́sɩ mɛ́dɛ́ɛ wanbaarʊ́. ");
INSERT INTO kdh_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Káma, mɩ́dáá weení gɛ a sɩ ɩma ɖaḿ kʊ́bɔńgɩ, ɩdɔ́njɔwʊ́ ɩtɩ́ wenbí bɩ́nbɔɔzɩ́ yɩ sɩ iɖi nɛ́, bɩka ɩbɛ́ɛ́ŋ sɩsɩ ɩwɛná liideé ánbɩɩzɩ́ atála yɩ hálɩ bɩkɛ́dɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","A ɩdalá bɩlɛ́ gɛ woobó isúu ɖɩzɩɩrɛ ngɛ ɩdabɩ́ɩ́zɩ ɩkʊ́ʊ́rɩ ɖaḿ, wenbá barɩ́ŋa sɩ bana sɩsɩ ɩdabɩ́zɩ ɩkʊ́ʊ́rɩ nɛ́, bɛlɛ́ sɩ bamʊ́ŋ yɩ gɛ, ");
INSERT INTO kdh_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","bɩka bɔtɔ́ yɩ sɩsɩ: “Ɩbɛ́ɛ ɩrʊ́ weení waabáázɩ ɖaḿ máa gɛ ɩdabɩ́ɩ́zɩ ɩkʊ́ʊ́rɩ nɛ́.” ");
INSERT INTO kdh_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Bɩlɛ́ ɖʊɖɔ gɛ a bɩgɛ́ɛ sɩsɩ wúro naárʊ sɔɔlɛ́ɛ ibó ikóyoo wúro naárʊ, ɩdɔ́njɔwʊ́ ɩmáázɩ ɩbɛ́ɛ sɩsɩ ɩráa mííli fuú (10.000) ɩwɛná wɛ nɛ́ bánbɩɩzɩ́ bokóyoo ɩbáɖaa weení ɩgɛgɛrɛŋɛ ɩwɔ́rɔ́ ɩ́gana ɩráa mííli ákoowú (20.000) nɛ́? ");
INSERT INTO kdh_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","A bɩlɛ́ gɛ waana sɩsɩ ɩ́dánbɩɩzɩ, wéndiríi tɩndɩnáa ɩbáɖaa ɩmʊ́ ɩjɔ́ sáátɩ wenkí ɩlɛ́ ɩgɔwɛ bolíni nɛ́ gɛ ɩbɔ́ɔ́zɩ yɩ sɩsɩ bɔ́nyɔɔzɩ bɔlɔwʊtáá. ");
INSERT INTO kdh_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Bɩlɛ́ nɛ́, mɩ́dáá naárʊ fɛ́yɩ́ wánbɩɩzɩ́ ɩbɩ́sɩ mɛ́dɛ́ɛ wanbaarʊ́ a bɩgɛ́ɛ sɩsɩ idekízi wenbí bɩrɩ́ŋa ɩwɛná nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Ɖɔ́m kɛ́ɛ kpɩ́nɖɛ kífeńɖe gɛ. Amá, a ɖɔ́m waazɩ́ niíni, nŋɩ́nɩ́ gɛ bánlám bɩ na bɩtálaḿ niíni. ");
INSERT INTO kdh_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Bɩ́dɔ́ndɔfɔɔzɩ tɛ́ɛ́dɩ bánvarɩ́m tɩ nɛ́, cáńfáná fuúle, bɛ́nbɛɖɩ́ bɩ asʊ gɛ. Weení ɩwɛná nɩgbamɩ́nɩ nɛ́, ɩlɛ́ ɩ́nɩɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tikée mʊʊráa rɩ́ŋa na wenbá balakásɩ taavé nɛ́ boogóduu Yeésu-jɔ́ sɩ bewélesi yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ńna gɛ Faríizi ńba na Mará wɩlɩɖáa wɛ bánŋmɩɩdɩ́ sɩsɩ: «Ɩrʊ́ ceení wánmʊ́ʊ alaháácɩ́-dɩnáa kazɔ́ɔ bɩka ɩ́na wɛ bónÿoozí bénɖíi kíɖíím!» ");
INSERT INTO kdh_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ńna gɛ Yeésu waaŋmatɩná wɛ na tɔmgɛɛzɩrɛ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Mɩ́dáá weení gɛ a ɩwɛná fééni nɩɩ́nʊ́wá, ngɛ tɩdaá kʊ́ɖʊḿ wɛɛdɛlɛ́ŋ, ídénÿelí nɩɩ́nʊ́wá kʊ́ɖʊḿ fɛ́yɩ́ tɩna tɛɛwʊ́lɔ́ɔ́-daá ɩɖɛ́ɛ ɩkájaa weení wɛɛdɛlɛ́ŋ nɛ́ hálɩ ɩkáná yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","A bɩgɛ́ɛ waana yɩ, na wenbi‑niíni gɛ wɔ́ngɔvɔɔ́lɩ yɩ ɩvaamɩ́nɩ-rɔ, ");
INSERT INTO kdh_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","bɩka a weegégbe ɖaána wónduuzí ɩɖɔndɩnáa na wenbá bajʊ́ʊ́na yɩ nɛ́ ɩtɔ́ wɛ sɩsɩ: “Ɩzɩná ma faarɩ́, káma, mááná mévée weení wɛɛdɛlɛ́ŋ nɛ́.” ");
INSERT INTO kdh_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ménveerím mɩ́ɩ sɩsɩ bɩlɛ́ ɖʊɖɔ gɛ sɩ bafáárɩ ɩsɔ́ɔ́dáá a alaháácɩ́-dʊ́ʊ kʊ́ɖʊḿ waalá túúbá bɩkɩlɩ ná ɩráa kʊ́ɖʊḿ fɛ́yɩ́ nɩɩ́nʊ́wá wenbá bazɩɩzɛ́ɛ bɩka bɛvɛ́yɩ́na túúbá lám nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Yáá alʊ́ weení gɛ a ɩwɛná liideé jɩtɔ́ɔ fuú ngɛ jɩtɔ́ɔ kʊ́ɖʊmʊ́ʊ wɛɛbɛ́ɖɩ, ɩ́dɔ́nzɔḿ fɩtɩ́la ɩkpára ɩɖaána ɩcáa liideé amʊ́ kazɔ́ɔ hálɩ ɩna yɛ. ");
INSERT INTO kdh_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ngɛ a waana yɛ, wánÿaá ɩɖɔndɩnáa na wenbá bajʊ́ʊ́na yɩ nɛ́ ɩtɔ́ wɛ sɩsɩ: “Ɩzɩná ma faarɩ́, káma, mááná méliideé weená aabɛ́ɖɩ nɛ́.” ");
INSERT INTO kdh_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ménveerím mɩ́ɩ sɩsɩ bɩlɛ́ ɖʊɖɔ gɛ Ɩsɔ́ɔ-dɛ́ɛ malááyɩ́kawá wánvaarɩ́ ɩsɔ́ɔ́dáá a alaháácɩ́-dʊ́ʊ kʊ́ɖʊḿ waalá túúbá.» ");
INSERT INTO kdh_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ngɛ waadásɩ ɩtɔ́ sɩsɩ: «Abaalʊ́ naárʊ wɛná na kʊ bíya abaaláa nɔɔ́lɛ. ");
INSERT INTO kdh_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ngɛ badaá kúmuú wɔɔdɔ́ ɩjaa sɩsɩ: “Baabá, cele ma mɛ́dɛ́ɛ tííbí.” Ngɛ bajaa waadára wɛ bɛdɛ́ɛ tííbí. ");
INSERT INTO kdh_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Bɩɩlá wɛ́-bíya cʊ́kɔ nɛ́, bíya-daá kúmuú waayá ɩdɛ́ɛ tííbí bɩka ɩkpɔ́ɔ iliideé ɩɖɛ́ɛ tɛ́ɛ́dɩ bolíni ńdɩ-daá. Ngɛ woobó ɩlá báa nŋɩ́nɩ́-nŋɩ́nɩ́ ɩfɔrɔ́sɩ iliideé atɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Weeɖi iliideé bɩtɛ́ nɛ́, ngɛ nyɔɔ́sɩ kʊ́bɔńzɩ waazʊ́ʊ laadɔ́ɔ kɛḿ kadaá. Ngɛ bɩrɩ́ŋa bɩɩbáázɩ yɩ cɛ́m. ");
INSERT INTO kdh_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ngɛ woobó ɩkpɔ́ɔ ɩdɩ ɩtaná tɛ́ɛ́dɩ tɩḿ tɩdaá ɩrʊ́ naárʊ, ɩlɛ́ ɩkpɔ́ɔ yɩ tɩmɛ́rɛ. Ngɛ ɩlɛ́ wooboná yɩ ɩdɛ́ɛ fɔɔ́-daá wɛ́ngɛbɛɛŋ́ afawá. ");
INSERT INTO kdh_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Afawá-dɛ́ɛ kíɖíím tɩtɩŋa cɔɔ́ɔ yɩ lowú sɩ iɖi, amá, naárʊ tánváa yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Wɔɔjɔ́ɔ ɩmáázɩ nɛ́, ngɛ wɔɔdɔ́ ɩdɩ sɩsɩ: “Tɩmɛlanɖáa aboyi wɛná majaa-jɔ́, bɩka bénɖíi bɩ́ngáa, na mɔ́ɔ́ mɔ́jɔɔ́ɔ cé mánzɩ́m nyɔɔ́sɩ? ");
INSERT INTO kdh_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mángʊrʊ́ʊ mabɩ́sɩ majaa-jɔ́, na mɔdɔ́ yɩ sɩsɩ: ‘Baabá, mááyɩ́sɩ́ná Ɩsɔ́ɔ, bɩka mayɩsɩná nyɔ́ɔ́ ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mɔ́dɔmɔ́ɔ́ná ngúti nÿáa ma sɩsɩ nbiyaalʊ́. Kpɔɔ ma nyazɩ mɛ́gɛ́ɛ nyɛ́dɛ́ɛ tɩmɛ́ lanɖáa-daá kʊ́ɖʊḿ bɩlɛ́.’ ” ");
INSERT INTO kdh_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ngɛ waagʊrʊ́ wánbɩsɩ́ ɩjaa-jɔ́. Ɩjaa woogólosi yɩ ɖoo bolíni nɛ́, ngɛ bɩɩbá bɩlá yɩ kʊnyɔḿ; ngɛ weeze ibó ɩkázɩŋ yɩ ikpíriki yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ngɛ ibiyaalʊ́ wɔɔdɔ́ yɩ sɩsɩ: “Baabá, mááyɩ́sɩ́ná Ɩsɔ́ɔ, bɩka mayɩsɩná nyɔ́ɔ́ ɖʊɖɔ. Mɔ́dɔmɔ́ɔ́ná ngúti nÿáa ma sɩsɩ nbiyaalʊ́.” ");
INSERT INTO kdh_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Amá, caáwʊ wɔɔdɔ́ ɩdɛ́ɛ bɔwʊtá-dɩnáa sɩsɩ: “Ɖasam, ɩgɔná tóko kɩɩbá kɩjɔɔ́ɔ kazɔ́ɔ nɛ́ isúu yɩ, ɩɖʊ yɩ ketéreniiká, na takaḿwá. ");
INSERT INTO kdh_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ɩgɔ́gbɔɔ naavalʊ́ ɩjɔɔ́ɔ núm kazɔ́ɔ nɛ́ ɩkʊ ɖɩtɔ́ɔ ɖiɖi jíńgáárɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Káma, mebiyaalʊ́ mɩ́bɛɛ́na yɩ ɖɔ́ nɛ́, wáńzɩ́ḿ ngɛ waagábɩsɩ weezuú-daá, wɛ́ńdɛ́lɛ́ŋ, ngɛ mááná yɩ.” Ngɛ baabáázɩ jíńgáárɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Bɩdɛ́ɛ sáátɩ, ibiyaalʊ́ kʊ́bɔnɩ́ kɔwɛ fɔɔ́-daá. Kabɩsɩ́-daá waajʊʊná ɖaána nɛ́, ngɛ waanɩ́ɩ bónɖúu bɩka bánbáárɛ. ");
INSERT INTO kdh_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Bɩnáábɩ́lɛ́ waayáa tɩmɛlanɖʊ́ kʊ́ɖʊḿ ɩbɔ́ɔ́zɩ yɩ wenbí bɩ́nlám nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ńna gɛ ɩlɛ́ sɩsɩ: “Nyénewú waagábɩsɩ ná gɛ njaa waagʊ nɔ́wʊ ɩjɔɔ́ɔ núm kazɔ́ɔ nɛ́, káma, waagábɩsɩ ná alaafɩ́ya.” ");
INSERT INTO kdh_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ńna gɛ ɩlɛ́ waabá ɩyɛ́ɛ baaná ikízi ɖaána sʊʊ́. Ngɛ ɩjaa waagálɩɩ ɩfɩ́nɩ yɩ sɩsɩ ɩ́sʊʊ. ");
INSERT INTO kdh_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Amá, woobúsi ɩjaa sɩsɩ: “Bɩɩlá bɩ́ɩ́zɩ‑bɩ́ɩ́zɩ mɔ́ɔ́ mɔ́wɛ mɔ́nvɔɔzɩ́ nya nɛ́, bɩka kɛtɛngɛrɛ médekízi wenbí nyɔ́ɔ́bɔ́ɔ́zɩ nɛ́ lám. Ngʊ́ kɛtɛngɛrɛ ńdáfá ma báa nemíkayɔ́ɔ́ sɩsɩ mána mɔɖɔndɩnáa ɖiɖi jíńgáárɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Amá, nbiyaalʊ́ ceení, weení ɩ́na aléewá wásangarɩ́wá beeɖi nyɛ́dɛ́ɛ liideé nɛ́ wɔɔgɔ́nɩ nɛ́, nyáágʊ́ yɩ nɔ́wʊ ɩjɔɔ́ɔ núm kazɔ́ɔ nɛ́.” ");
INSERT INTO kdh_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ngɛ caáwʊ wɔɔdɔ́ yɩ sɩsɩ: “Móbú, báa sáátɩ wenkí mána nyɔ́ɔ́ gɛ, bɩka wenbí bɩrɩ́ŋa mádɩɩná nɛ́, kɛ́ɛ nyɛ́dɛ́ɛ ńbɩ gɛ. ");
INSERT INTO kdh_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Amá, bɩɩbɔ́ɔ́zɩ ɖiɖi jíńgáárɩ́ ɖɩfáárɩ, káma, nyénewú ceení wáńzɩ́ḿ ngɛ waagábɩsɩ weezuú-daá, wɛ́ńdɛ́lɛ́ŋ, ngɛ ɖááná yɩ.”» ");
INSERT INTO kdh_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ngɛ Yeésu wɔɔdɔ́ ɩwanbaaráa sɩsɩ: «Abaalʊ́ liideé-dʊ́ʊ naárʊ wɛná na bɔwʊtá-dʊ́ʊ wɛ́nbɛɛŋ́ yɩ ɩdɛ́ɛ ɖɔ́ɔ́lɛ. Ngɛ bɔɔgɔ́nɩ befééri yɩ sɩsɩ ɩdɛ́ɛ bɔwʊtá-dʊ́ʊ wánlám ɩdɛ́ɛ ɖɔ́ɔ́lɛ ásáráwʊ́. ");
INSERT INTO kdh_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ngɛ waayáa yɩ ɩbɔ́ɔ́zɩ yɩ sɩsɩ: “Wentí gɛ mánnɩɩ́ bánŋmatɩ́ nyɔ́rɔ́ ye. Tɩ ma tɩmɛ́ weená nyáálá ma nɛ́, káma, sinje tɩ́ŋa, ńdɛ́ndɛbɛɛŋ mɛ́dɛ́ɛ ɖɔ́ɔ́lɛ-rɔ.” ");
INSERT INTO kdh_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Bɔwʊtá-dʊ́ʊ wɔɔdɔ́ ɩdaá sɩsɩ: “Mágʊ́bɔnɩ́ tándacaa sɩsɩ mɛ́bɛɛŋ ɩdɛ́ɛ ɖɔ́ɔ́lɛ nɛ́, wenɖé gɛ sɩ malá ɖɔ́. A farɩ́m, mɛ́vɛ́yɩ́na ɖóni sɩ mavára. A bára lám bɩjɔɔ́ɔ ma fɛɛrɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Mányɩ wenbí sɩ malá na a wɩ́rɛ bɔɔɖɔ́ɔ ma tɩmɛ́rɛ-daá, ɩráa ɩmʊ ma bɛdɛ́ɛ nɛ́.” ");
INSERT INTO kdh_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ngɛ waayáa wenbá barɩ́ŋa beeɖi ɩgʊ́bɔnɩ́ kɩmɛ́ nɛ́ kʊ́ɖʊḿ‑kʊ́ɖʊḿ. Ngɛ wɔɔdɔ́ kaɖaa ńnɩ́ sɩsɩ: “Nŋɩ́nɩ́ gɛ sɩ nvɛ́rɛ mágʊ́bɔnɩ́.” ");
INSERT INTO kdh_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ngɛ ɩlɛ́ sɩsɩ: “Núm ánkʊrá nɩɩ́nʊ́wá (100).” Ngɛ bɔwʊtá-dʊ́ʊ wɔɔdɔ́ yɩ sɩsɩ: “Bɛɛ nyɛ́dɛ́ɛ kɩmɛ́rɛ tákaraɖá, cɔɔ bɩka nŋmáa sɩsɩ ánkʊráwá nɛɛ́saaláa (50) gɛ sɩ nvɛ́rɛ.” ");
INSERT INTO kdh_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ngɛ wɔɔdɔ́tɔḿ naárʊ sɩsɩ: “Nyɔ́ɔ́ ní, nŋɩ́nɩ́ gɛ sɩ nvɛ́rɛ mágʊ́bɔnɩ́.” Ngɛ ɩlɛ́ sɩsɩ bilée kpetekíni nɩɩ́nʊ́wá (100). Ngɛ bɔwʊtá-dʊ́ʊ wɔɔdɔ́ yɩ sɩsɩ: “Bɛɛ nyɛ́dɛ́ɛ kɩmɛ́rɛ tákaraɖá, ŋmaa sɩsɩ bilée kpetekíni nɩɩ́náázá (80) gɛ sɩ nvɛ́rɛ.” ");
INSERT INTO kdh_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ngɛ kʊ́bɔnɩ́ waazá bɔwʊtá-dʊ́ʊ aduula-dʊ́ʊ ɩmʊ́, káma, waalá lɔ́nɩ. Ɖúúlínya-daá ɩráa cɔɔ́ɔ lɔ́nɩ a bána baranáa bɩkɩ́lɩ wenbá bɛgɛ́ɛ ɖɛnyɛm-daá ńba nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Bɩlɛ́ nɛ́, ménveerím mɩ́ɩ sɩsɩ ɩ́kpɔɔ aduula liideé ɩcaaná ɖɔndɩnáa na a aagɔ́nɩ atɛlɛ́ŋ, Ɩsɔ́ɔ ɩmʊ mɩ́ɩ ɩdɛ́ɛ ɖaána-daá. ");
INSERT INTO kdh_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Weení baava yɩ toovonúm wenbí bɩgɛ́ɛ kúmuúbi nɛ́ bɩdaá nɛ́, bánváa yɩ toovonúm kʊ́bɔńbɩ-daá ɖʊɖɔ. Weení badafa yɩ toovonúm wenbí bɩgɛ́ɛ kúmuúbi nɛ́ bɩdaá nɛ́, bádánváa yɩ toovonúm wenbí bɩgɛ́ɛ kʊ́bɔńbɩ nɛ́ bɩdaá. ");
INSERT INTO kdh_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","A bɩlɛ́ gɛ badafa mɩ́ɩ toovonúm nŋɩ́nɩ́ mɩ́nlanáa ɖúúlínya kɩna kɩdɛ́ɛ aduula liideé nɛ́, weení wénjelíi kʊ mɩ́ɩ ɖɔ́ɔ́lɛ toovonúm ńɖɛ. ");
INSERT INTO kdh_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ngɛ a badafa mɩ́ɩ toovonúm baaganáa-dɛ́ɛ ɖɔ́ɔ́lɛ beejéle mɩ́ɩ nɛ́-jɔ́, weení sɩ icele ná mɩ́ɩ mɩ́dɩtɩŋa mɩ́dɛ́ɛ ńɖɛ. ");
INSERT INTO kdh_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Bɔwʊtá-dʊ́ʊ naárʊ fɛ́yɩ́ wánbɩɩzɩ́ ɩlá kʊ́bɔnáa nɔɔ́lɛ bɔwʊtá: wéngizíi kʊ́ɖʊḿ, ɩsɔ́ɔ́lɩ lí ńnɩ́, yáá wánmalanáa ɩdɩ kʊ́ɖʊḿ bɩka ɩkpɛɛná lí ńnɩ́. Mɩ́dánbɩɩzɩ ɩlá Ɩsɔ́ɔ na liideé bɔwʊtá.» ");
INSERT INTO kdh_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Faríizi ńba waanɩ́ɩ tɔ́mwá tɩna tɩrɩ́ŋa nɛ́, ngɛ bɔwɛ bánmʊŋɛ́ Yeésu, káma, bɔɔzɔ́ɔ́lɩ liideé. ");
INSERT INTO kdh_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ngɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Mɩ́nyɔ́ɔ́ nɛ́, ɩráa ɩzá-daá gɛ mɩ́nwɩlɩ́ɩ sɩsɩ mɩ́zɩ́ɩ́zɛ́ɛ, amá, Ɩsɔ́ɔ nyɩ míwenbé. Wenbí ɩráa bɛɛ́na sɩsɩ bɩɩgɩlɩ ná nɛ́ kɛ́ɛ láálɩ́ gɛ Ɩsɔ́ɔ ɩzá-daá. ");
INSERT INTO kdh_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Múúsá-dɛ́ɛ Mará na anɖébiwá baaganáa-dɛ́ɛ ŋmáádɩ waaŋmátɩ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-dɛ́ɛ tɔ́m hálɩ bɩkɔ́nɩ bɩtála Yaayá. Kɔgbɔɔ Yaayá dɛ́ɛ sáátɩ kɩḿ, beevééri ɩráa Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-dɛ́ɛ Laabáárʊ Kífeńgi, ngɛ ɩrʊ́ báa weení wánlʊwɔ́ɔ na ɖóni sɩsɩ ɩsʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ɩsɔ́ɔ́dáá na adɛ-dɛ́ɛ tɛlɛ́ŋ wánlám ɖasam bɩkɩ́lɩ na Mará-daá ŋmáádɩ-bú-dɛ́ɛ tɛlɛ́ŋ. ");
INSERT INTO kdh_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Weení ɩrɩ́ŋa wɔɔɖɔ́ɔ ɩɖɛɛlʊ́, ngɛ wɔɔgbɔ́ɔ kɩ́falʊ́ nɛ́, waalɩ́ɩ ɩɖɛɛlʊ́ ɩmʊ́ ɩwɔ́rɔ́. Ngɛ weení wɔɔgbɔ́ɔ alʊ́ weení ɩwaalʊ́ weegízi yɩ nɛ́, waalá wásangarɩ́tɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Abaalʊ́ liideé-dʊ́ʊ naárʊ wɔɔjɔɔ ná. Liidebɔná kpɩná gɛ wónzuú, bɩka báa wɩ́rɛ wenɖé, jíńgáárɩ́-daá gɛ ɩwɛ. ");
INSERT INTO kdh_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Kadanbʊrɩya nɛkɛ́rɛ bánÿaá kɛ sɩsɩ Lazáarɩ nɛ́ wánvɩnɩ́ ɩɖɔɔ́ wɔnɔɔ́. Lazáarɩ ɩmʊ́ ɩrɩ́ŋa‑ɩrɩ́ŋa ɩjɔɔ́ɔ féézi‑féézi gɛ. ");
INSERT INTO kdh_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Bɩjɔɔ́ɔ yɩ lowú sɩsɩ iyuú kíɖíím bɩ́nzalɩ́ɩ liideé-dʊ́ʊ-dɛ́ɛ tébíri-dɛ sáátɩ wenkí ɩlɛ́ wénɖíi nɛ́ iɖi, na bɩrɩ́ŋa ídónÿuú; amá, fáázɩ wɔ́ngɔnɩ kʊ sínnyeezí ivééziwá-daá. ");
INSERT INTO kdh_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Wɩ́rɛ nɛ́, kadanbʊrɩya waazɩ́. Ngɛ malááyɩ́kawá wɔɔgbɔ́ɔ yɩ boboná anɖébi Ibrahím-jɔ́. Liideé-dʊ́ʊ ɖʊɖɔ waazɩ́, bebí yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ngɛ waabá wánnáa wahála páá ɩsɩɖáa ɖaajɔɔɖɛ́. Waagbáázɩ ɩzá nɛ́, ngɛ woogólosi ɖoo bolíni anɖébi Ibrahím bɩka Lazáarɩ wɛ ɩdɛ́ɛ kpɛyɩ́-daá. ");
INSERT INTO kdh_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ńna gɛ woogóo sɩsɩ: “Ibrahím majaa, nɩɩ mágʊnyɔḿ bɩka ndíri Lazáarɩ ilíi iniiká nɔɔ́ lɩ́m-daá itósi mánzʊlʊmʊ́ʊ-rɔ bɩsála ma kaanɩŋá; káma, máábá mánnáa wahála páá nimíni ceení-daá.” ");
INSERT INTO kdh_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ngɛ Ibrahím woobúsi yɩ sɩsɩ: “Móbú, tɔɔzɩ sɩsɩ nyóóyúú nyɛ́dɛ́ɛ ɖɔ́ɔ́lɛ ɖabata nyɔ́wɛ weezuú-daá nɛ́ bɩka Lazáarɩ ɩlɛ́ ɩna kʊnyɔḿ ɖabata; lɛlɛɛɖɔ́ ɩlɛ́ wooyuú wenbivɛɛzɩrɛ cé bɩka nyɔ́ɔ́ nyánnáa wahála. ");
INSERT INTO kdh_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Bɩlɛ́ bibaasí, ɖána mɩ́ɩ ɖɔ́lɔ́wʊ́táá, bɔɔwʊ́ kʊ́bɔnbɔńgɩ wɛná. Biiyéle báa ɩrʊ́ sɔɔlɛ́ɛ ɩlɩ́ɩ cé ɩtɛ́sɩ mɩ́jɔ́ ɩ́dánbɩɩzɩ, cáńfáná naárʊ ɩkálɩɩ mɩ́jɔ́ ɩkɛ́dɛsɩ ɖɔ́jɔ́ cé.” ");
INSERT INTO kdh_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ńna gɛ liideé-dʊ́ʊ wɔɔdɔ́ sɩsɩ: “Majaa, máávɩ́nɩ nya sɩsɩ ńdiri Lazáarɩ majaa-dɛ́ɛ ɖaána-daá, ");
INSERT INTO kdh_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","káma, mogoobíya nɔɔ́nʊwá wɛ ńna; ɩ́basɩ wɛ na bɛlɛ́ ɖʊɖɔ bɔ́kɔkɔ́nɩ wahála ɖɩdáarɛ ɖɩna ɖɩdaá.” ");
INSERT INTO kdh_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ngɛ Ibrahím woobúsi yɩ sɩsɩ: “Múúsá na anɖébiwá baaganáa-dɛ́ɛ tákaraɖáwá wɛ bɔjɔ́, bánɩɩ wentí bɛlɛ́ baaŋmáa nɛ́.” ");
INSERT INTO kdh_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ngɛ liideé-dʊ́ʊ sɩsɩ: “Aayɩ́, majaa Ibrahím, bɛlɛ́ beriké bɛdɛ́ɛ ŋmatɩrɛ tɔɖɔ́ɔ, amá, a naárʊ waalɩ́ɩ ɩsɩɖáa-daá ibó ɩmɔɔná wɛ, bánlám túúbá.” ");
INSERT INTO kdh_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Amá, anɖébi Ibrahím woobúsi yɩ sɩsɩ: “A badanɩɩná Múúsá na anɖébiwá baaganáa, báa ɩsɩɖʊ́ weeve ná ibó ɩŋmátɩ wɛ, bádánváa toovonúm.”» ");
INSERT INTO kdh_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yeésu wɔɔdɔ́ ɩwanbaaráa sɩsɩ: «Wenbí bínÿelíi na ɩrʊ́ ɩyɩ́sɩ nɛ́ tɛ́ndɛŋ́ kɛtɛngɛrɛ, amá, nbusú na weení wénÿelíi ɩrɔwʊ́ ɩyɩ́sɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","A baadaná bʊdʊ́ʊ lowú namɩ́rɛ kʊ́bɔńɖɛ bɔlɔ tenkú-daá, bɩjɔɔ́ɔ sóńcí na iyéle bíya bana badaá naárʊ ɩlá alaháácɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Iguná laakáarɩ. A ngoobú waayɩ́sɩ, feeri yɩ ɩdɛ́ɛ yɩsɩ́tɩ, ngɛ a waavɩ́nɩ nya, cɛ yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ngɛ a wɩ́rɛ-daá waayɩsɩná nya bʊrɔ lʊbɛ, ngɛ báa sáátɩ wenkí gɛ waayɩsɩná nya bɩlɛ́ nɛ́, wɔɔgɔ́nɩ sɩsɩ: “Cɛ ma,” bʊrɔ lʊbɛ kɩḿ, nyɛ́njɛm yɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tɩndɩnáa wɔɔdɔ́ Ɖádʊ́ʊ sɩsɩ: «Tasɩ ɖáa toovonúm fáa.» ");
INSERT INTO kdh_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ngɛ Ɖádʊ́ʊ woobúsi sɩsɩ: «A mɩ́dɛ́ɛ toovonúm fáa weegíi nyazɩ báńŋɩ́náyɔ́ɔ bú, mɩ́nbɩɩzɩ́ ɩtɔ́ tɩɩwʊ́ kʊ́bɔńgɩ kɩna sɩsɩ: “Kpɛzɩ́ nyádɩ cé ngózuu tenkú-daá.” Bɩka kifu kɩlá bɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Mɩ́dáá weení gɛ a ɩwɛná bɔwʊtá-dʊ́ʊ wánvarɩ́m yɩ, yáá wɛ́nbɛɛŋ́ ɩvʊ́ńdɩ kpɩná, ngɛ bɔwʊtá-dʊ́ʊ ɩmʊ́ waalɩɩ ná fɔɔ́ ɩtála, wɔ́ndɔ́m yɩ sɩsɩ: “Bo ɖasam njɔ́ɔ nɖi kíɖíím.” ");
INSERT INTO kdh_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mányɩ sɩsɩ wɔ́ndɔ́m yɩ gɛ sɩsɩ: “Bo nlá ma kíɖíím; a bɩɩbɩ́ɩ, nbó ngɛ́ɛ nyágbɩná ngɔ́nɩ nɖʊ ma meɖi, mɔnyɔ́ɔ; bʊwɔ́rɔ́ nɛ́, nyɔ́ɔ́ ɖʊɖɔ nyánbɩɩzɩ́ nbó nɖi nnyɔ́ɔ” gɛ. ");
INSERT INTO kdh_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ɩ́dɛnzɛɛ ɩdɛ́ɛ bɔwʊtá-dʊ́ʊ tɩmɛ́rɛ waaɖʊ yɩ ɩlá nɛ́ ɖɩrɔ. ");
INSERT INTO kdh_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Bɩlɛ́ ɖʊɖɔ gɛ mɩ́nyɔ́ɔ́, a bɩgɛ́ɛ mɩ́ɩ́lá wenbí bɩrɩ́ŋa baaɖʊ mɩ́ɩ nɛ́, ɩdɔ́ sɩsɩ: “Bɔwʊtá-dɩnáa gɛ ɖɛ́gɛ́ɛ, ɖádɩmɛ́rɛ bɩ́nbɔɔzɩ́ sɩsɩ ɖɩ́la nɛ́ gɛ ɖáálá.”» ");
INSERT INTO kdh_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yeésu bamáa Yerusalɛ́ɛm ɖɛɛ́ nɛ́, wɛɛdɛ́sɩ Samarɩ́ya na Galilée laadásɩ. ");
INSERT INTO kdh_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Waadála tɛɛbiiyá nɛkɛ́rɛ-daá nɛ́, ngɛ cɛnɩ́sɩ fuú wɔɔgɔ́nɩ sɩsɩ́ŋ yɩ; sɩgazɩ́ŋɛ́ɛ bolíni ");
INSERT INTO kdh_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","síngoó sɩsɩ: «Yeésu! Kʊ́bɔnɩ́! Nɩɩ ɖágʊnyɔḿ.» ");
INSERT INTO kdh_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yeésu waana sɩ nɛ́, ngɛ wɔɔdɔ́ sɩ sɩsɩ: «Ibó Ɩsɔ́ɔ sarásɩ lanɖáa ɩbɛ́ɛ́ŋ mɩ́ɩ.» Sɩwɛ sɩ́nɖɛɛ́ nɛ́, ngɛ sɩɩwáa. ");
INSERT INTO kdh_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Sɩdaá kʊ́ɖʊmɔ́ɔ waana sɩsɩ kaawáa nɛ́, kaagábɩ́sɩ bɩka kabá kángazám Ɩsɔ́ɔ bɩ́njaarɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Kɔɔgɔ́nɩ kaká kaɖʊná-rɔ Yeésu ɩzá-daá kɛ́nzɛɛ́ yɩ. Cɛnɩŋa kɛḿ kɛgɛ́ɛ Samarɩ́ya ńnɩ́ gɛ. ");
INSERT INTO kdh_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ńna gɛ Yeésu sɩsɩ: «Mányɩ sɩsɩ sɩgɛ́ɛ fuú sɩɩwáa sɩlá ɖacɩrɩ‑cɩrɩ nɛ́ gɛ. Kééníré kɩɩganáa wɛ lé. ");
INSERT INTO kdh_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nɛkɛ́rɛ tamáázɩ sɩsɩ kakábɩsɩ kasá Ɩsɔ́ɔ, asée ɩgɔm ceení riké?» ");
INSERT INTO kdh_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ngɛ wɔɔdɔ́ kɛ sɩsɩ: «Kʊrʊ́ nɖɛ́ɛ, nyɛ́dɛ́ɛ toovonúm fáa wɛɛlɛ́ɛ nya.» ");
INSERT INTO kdh_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Faríizi ńba wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Tɔ́ɔ, sáátɩ wenkí gɛ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ sɩ kɔkɔ́nɩ.» Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ sɩ kɔkɔ́nɩ nɛ́, bádánnáa kɛ na ɩzá. ");
INSERT INTO kdh_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Bɔ́dɔ́ndɔḿ sɩsɩ: “Ɩbɛ́ɛ kɛ cé yáá ɩgɛ́bɛ́ɛ kɛ lí.” Káma, Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ wɛ mɩ́lɔ́wʊ́táá gɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ngɛ wɔɔdɔ́ wanbaaráa sɩsɩ: «Wɛ́-bíya nɛbɛ́rɛ wɔ́ngɔnɩ́, bɩ́nlám mɩ́ɩ lowú sɩsɩ ɩna Ɩrʊ́ Biyaalʊ́ báa wɩ́rɛ kʊ́ɖʊńɖɛ, amá, mɩ́dánnáa yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Bénveerí mɩ́ɩ sɩsɩ: “Ɩbɛ́ɛ yɩ cé, ɩgɛ́bɛ́ɛ yɩ lí.” Íkobó ngʊ́ íkotoózi. ");
INSERT INTO kdh_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Káma, ńŋɩnáa bɩ́nnyaláázɩ wɩ́sɩ ɖaagalɩɩɖɛ́ fáráńdɩ́ hálɩ bibó sɩɖaagazalaɖɛ́ nɛ́, bɩlɛ́ gɛ sɩ bɩlá Ɩrʊ́ Biyaalʊ́-dɛ́ɛ kɔnɖɛ́ wɩ́rɛ. ");
INSERT INTO kdh_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Amá, naanɩ́ na bɩtála bɩlɛ́ nɛ́, bɩ́nbɔɔzɩ́ ɩna wahála bɩɖɔ́ɔ bɩka zaamáánɩ kɩna kɩdɛ́ɛ ɩráa ikízi yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Wenbí bɩɩlá Núhum-dɛ́ɛ sáátɩ nɛ́ nɔ́ɔ́ sɩ bɩla ná Ɩrʊ́ Biyaalʊ́-dɛ́ɛ kɔnɖɛ́ sáátɩ: ");
INSERT INTO kdh_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ɩráa wénɖíi bɔ́nnyɔɔ́, bɔ́ngbɔwʊ́ʊ aláa bɩka bánváa bɛwɛɛlɩnáa hálɩ wɩ́rɛ wenɖé Núhum waazʊ́ʊ mɛ́ɛ́lɛ nɛ́ ɩtála. Ngɛ tɛ́ɛ́wʊ kʊ́bɔńgɩ waanɩ́ɩ, lɩ́m ɩkʊ barɩ́ŋa. ");
INSERT INTO kdh_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Yáá wenbí ɖʊɖɔ bɩɩlá Lɔ́ɔtɩ-dɛ́ɛ sáátɩ nɛ́ nɔ́ɔ́ sɩ bɩla ná: Ɩráa wénɖíi, bɔ́nnyɔɔ́, bánmʊ́ʊ, bánÿám, bónɖuú, bánmáa. ");
INSERT INTO kdh_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Amá, wɩ́rɛ wenɖé Lɔ́ɔtɩ waalɩ́ɩ Sodɔ́ɔmɩ nɛ́, Ɩsɔ́ɔ weeyéle fáráwíítá nimíni ɩlɩ́ɩ ɩsɔ́ɔ́dáá kɩnɩ́ɩ nyazɩ tɛ́ɛ́wʊ bɩlɛ́ bɩkʊ barɩ́ŋa. ");
INSERT INTO kdh_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Bɩlɛ́ nɔ́ɔ́ sɩ bɩla ná wɩ́rɛ wenɖé Ɩrʊ́ Biyaalʊ́ sɩ ɩɖʊ ɩlɩ́ɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Wɩ́rɛ ɖɩḿ, weení ɩwɛ ɖaḿ kʊjʊʊ́-daá atáárɩ-rɔ nɛ́, íketí sɩsɩ ɩkpɔ́ɔ ɩgbɩná awɛ ɖaḿ-daá nɛ́. Weení ɩwɛ fɔɔ́ nɛ́ ɩ́kɔlɔ́ɔ ɩbɩ́sɩ ɩwɔ́rɔ́. ");
INSERT INTO kdh_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ɩdɔ́ɔ́zɩ Lɔ́ɔtɩ ɖɛɛlʊ́-dɛ́ɛ tɔ́m. ");
INSERT INTO kdh_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Weení wánjáádɩ sɩ ɩlɛ́ɛ iweezuú nɛ́, wɛ́nbɛɖɩ́ kɩ, bɩka weení wɛɛbɛ́ɖɩ iweezuú nɛ́, wóngoyuú kɩ. ");
INSERT INTO kdh_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ménveerím mɩ́ɩ sɩsɩ nuvoowú kɩḿ, ɩráa nɔɔ́lɛ fɩ́nɛ́ɛ gáɖó kʊ́ɖʊmʊ́ʊ-rɔ gɛ, na bɩsɛlɩ́ kʊ́ɖʊḿ bɩka biyéle lí ńnɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Aláa nɔɔ́lɛ wónÿoozí bánnaḿ namɩ́rɛ kʊ́ɖʊńɖɛ-rɔ gɛ na bɩsɛlɩ́ kʊ́ɖʊḿ, bɩka biyéle lí ńnɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Abaaláa nɔɔ́lɛ wɛ fɔɔ́-daá bánlám tɩmɛ́rɛ gɛ na bɩsɛlɩ́ kʊ́ɖʊḿ biyéle lí ńnɩ́.» ");
INSERT INTO kdh_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ngɛ wanbaaráa wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Ɖádʊ́ʊ, lé gɛ sɩ bɩlá bɩlɛ́.» Ngɛ woobúsi wɛ sɩsɩ: «Lénlé wenbí bɩ́ńzɩ́ḿ nɛ́ bʊwɛ nɛ́, ńna gɛ abɛ́ntɛ́wá wónduuzí.» ");
INSERT INTO kdh_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ngɛ Yeésu waaŋmatɩná na tɔmgɛɛzɩrɛ ɖɩna ɩwɩlɩ ná wɛ sɩsɩ bɩɩbɔ́ɔ́zɩ báa sáátɩ wenkí bánzʊlʊ́ʊ Ɩsɔ́ɔ bɩka bɛ́kɛbɛ́ɖɩ zinbirí. ");
INSERT INTO kdh_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Wɔɔdɔ́ wɛ sɩsɩ: «Tɔmvʊʊrʊ́ naárʊ wɔɔjɔɔ ná tɛ́ɛ́dɩ natɩ́rɩ-daá; ídénzée Ɩsɔ́ɔ bɩka ɩvɛ́yɩ́na ɩrʊ́-dɛ́ɛ gírímá. ");
INSERT INTO kdh_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Alʊ́ leelú naárʊ ɩwɛ tɛ́ɛ́dɩ tɩḿ tɩdaá nɛ́ wɔ́ndɔ́rɔgɔ́nɩ́ wɔ́ndɔ́m tɔmvʊʊrʊ́ sɩsɩ: “Fʊʊ mɔ́dɔ́m nɖéézi ma mabáɖaa ɩzá-daá.” ");
INSERT INTO kdh_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tɔmvʊʊrʊ́ waalaaná kizíi, báa sáátɩ wenkí. Ngɛ wɔɔgɔ́nɩ ɩtɔ́ ɩdɩ sɩsɩ: “Báa ɖoo médénzée Ɩsɔ́ɔ bɩka mɛ́vɛ́yɩ́na ɩrʊ́-dɛ́ɛ gírímá, ");
INSERT INTO kdh_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","wenbí alʊ́ leelú ceení wánhaawʊ́ ma nɛ́, asée máávʊ́ʊ ɩdɔ́m na íkokuti ɩkɔ́nɩ wánjaarɩ́ ma ɖʊɖɔ.”» ");
INSERT INTO kdh_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ngɛ Ɖádʊ́ʊ woozúúri sɩsɩ: «Ɩnɩ́ɩ tɔmvʊʊrʊ́ ídónvúu toovonúm nɛ́ ceení waaŋmátɩ wentí nɛ́ kazɔ́ɔ! ");
INSERT INTO kdh_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nɛ́, Ɩsɔ́ɔ ténɖeezi ɩdɛ́ɛ ńba wenbá bóngoó bánÿaá yɩ nuvoowú na ɩdaawʊ́ nɛ́? Wénÿelíi bilééri na ɩsɩná wɛ? ");
INSERT INTO kdh_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ménveerím mɩ́ɩ sɩsɩ ídénÿelí bilééri na iɖéézi wɛ. Amá, Ɩrʊ́ Biyaalʊ́ sɩ ɩkɔ́nɩ nɛ́, wɔ́nmɔɔnáa ɩráa baava toovonúm nɛ́ adɛ laadɔ́ɔ-rɔ?» ");
INSERT INTO kdh_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ngɛ Yeésu waaŋmatɩná wenbá bɛbɛɛ́na badɩ sɩsɩ bazɩɩzɛ́ɛ Ɩsɔ́ɔ ɩzá-daá bɩka bɛ́ngbɛɛnáa baaganáa nɛ́ na tɔmgɛɛzɩrɛ ɖɩna: ");
INSERT INTO kdh_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Ɩráa nɔɔ́lɛ waagba ná Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá Ɩsɔ́ɔ sɛ́ɛ́dɩ. Kʊ́ɖʊḿ kɛ́ɛ Faríizi ńnɩ́, bɩka lí ńnɩ́ kɛ́ɛ tikée mʊʊrʊ́. ");
INSERT INTO kdh_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Faríizi ńnɩ́ waagʊrʊ́ ɩsɩ́ŋ wánzʊlʊ́ʊ ɩdaá sɩsɩ: “Óo! Ɩsɔ́ɔ, máázá nya ńŋɩnáa ńdálá ma nyazɩ ɩráa baaganáa bɛgɛ́ɛ ŋmɩɩláa, badaavé bɩka bánlɩɩ́ bɛɖɛɛlɩnáa wɔ́rɔ́ nɛ́. Mánzám nya ńŋɩnáa ńdálá ma nyazɩ tikée mʊʊrʊ́ ceení nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mɔ́nvɔkɩ́ nɔɔ́ nabʊ́lɛ gɛ wɛ́ lʊbɛ-daá, bɩka mɛ́nvɛrɩ́ɩ wenbí bɩrɩ́ŋa móóyúú bɩ nɛ́ bɩdɛ́ɛ fuú-rɔ kʊ́ɖʊńbɩ.” ");
INSERT INTO kdh_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Tikée mʊʊrʊ́ ɩlɛ́ ɩzɩ́ŋɛ́ɛ bolíni; ɩdɔsɔ́ɔ́lɩ sɩ ɩkpáázɩ waazá ɩbɛ́ɛ́ŋ ɩsɔ́ɔ́dáá, amá, ɩwɛ gɛ wándaáa nʊ́ʊ́zɩ sɩsɩ: “Óo Ɩsɔ́ɔ! Nɩɩ mɔ́ɔ́ alaháácɩ́-dʊ́ʊ mágʊnyɔḿ.”» ");
INSERT INTO kdh_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ngɛ Yeésu sɩsɩ: «Ménveerím mɩ́ɩ sɩsɩ Ɩsɔ́ɔ waamʊ tikée mʊʊrʊ́ ɩmʊ́ ɩdɛ́ɛ sʊlʊ́ńdɩ ɩcɛ́ yɩ bɩka ikízi ɩdamʊ lí ńnɩ́-dɛ́ɛ ńdɩ. Káma, weení waagbáázɩ ɩdɩ nɛ́, béndisí yɩ, amá, weení weedísi ɩdɩ nɛ́, bángbaazɩ́ yɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bɩlɛ́ bʊwɔ́rɔ́ gɛ ɩráa wɔɔgɔná Yeésu bíya kɩdaáɖɛyáawá sɩsɩ ɩtɩ́nɩ wɛ nʊ́ʊ́zɩ ɩsʊ́lʊ bɔrɔ. Yeésu-dɛ́ɛ wanbaaráa waana bɩlɛ́ nɛ́, ngɛ bónÿoonáa wɛ. ");
INSERT INTO kdh_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Amá, Yeésu weeyéle bɔkɔná yɩ bíya bɛḿ ngɛ wɔɔdɔ́ sɩsɩ: «Iyéle bíya ɩkɔ́nɩ mɔ́jɔ́. Ɩ́kɔtɔ wɛ nɩ́bááwʊ, káma, wenbá baalɩ́ɩ wɛ nɛ́ badɩɩná Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ménveerím mɩ́ɩ toovonúm sɩsɩ weení ɩdamʊ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ nyazɩ bú nɛ́, ɩ́dánzʊʊ kadaá.» ");
INSERT INTO kdh_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Bɩlɛ́ bʊwɔ́rɔ́ gɛ Yahúúɖuwá-dɛ́ɛ wúro naárʊ wɔɔbɔ́ɔ́zɩ Yeésu sɩsɩ: «Kʊ́bɔnɩ́ kazɔ́ɔ ńnɩ́, we gɛ bɩ́nbɔɔzɩ́ sɩ mála na moyuú weezuú kɩ́dɛ́ndɛŋ́ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ngɛ Yeésu woobúsi yɩ sɩsɩ: «We-rɔ gɛ nyánÿaá ma sɩsɩ kazɔ́ɔ ńnɩ́. Naárʊ fɛ́yɩ́ ɩgɛ́ɛ kazɔ́ɔ ńnɩ́ nɛ́, asée Ɩsɔ́ɔ riké. ");
INSERT INTO kdh_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nyányɩ wenbí Mará waazɩ́ɩ́zɩ nɛ́, tɩlɛ́ gɛ sɩsɩ: “Ńdánlɩɩ nɖɛɛlʊ́ wɔ́rɔ́; ńdángʊ́ʊ ɩrʊ́; ńdánŋmɩɩlɩ; ńdánlɩzɩ́ seríya tɩtɛ ńgɩ; ɖʊ ngɔɔ na njaa gírímá.”» ");
INSERT INTO kdh_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ńna gɛ ɩrʊ́ ɩmʊ́ sɩsɩ: «Máálá bɩlɛ́ ɩmʊ́ bɩrɩ́ŋa kɔgbɔɔ ɖoo mɛ́dɛ́ɛ afobire.» ");
INSERT INTO kdh_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yeésu waanɩ́ɩ waaŋmátɩ bɩlɛ́ nɛ́, ngɛ wɔɔdɔ́ yɩ sɩsɩ: «Bɩɩga nya tɔ́m kʊ́ɖʊńtɩ kóŋ́, tɩlɛ́ gɛ sɩsɩ: “Bo nÿá wenbí bɩrɩ́ŋa nyɔ́wɛná nɛ́ ndára kadanbʊrʊ́sɩ na nÿuú ɖɔ́ɔ́lɛ ɩsɔ́ɔ́dáá. A nyáálá bɩlɛ́ bɩtɛ́, na ngɔ́nɩ nvu ma.”» ");
INSERT INTO kdh_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ɩrʊ́ ceení waanɩ́ɩ bɩlɛ́ nɛ́, ngɛ waazʊ́ʊ kaanɩŋá, káma, ɩbá ɩgɛ́ɛ ɖɔ́ɔ́lɛ-dʊ́ʊ gɛ. ");
INSERT INTO kdh_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yeésu waana bɩlɛ́ nɛ́, ngɛ sɩsɩ: «Bɩ́nlám káálɛ na ɖɔ́ɔ́lɛ-dʊ́ʊ ɩsʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-daá. ");
INSERT INTO kdh_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ɩɩ́n! Bɩvɛ́yɩ́ raakúḿ káálɛ sɩsɩ kɩsʊʊ ná ɩjɔ́wʊ bɔyɔ́ɔ bɩtála ɖɔ́ɔ́lɛ-dʊ́ʊ ɩsʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-daá.» ");
INSERT INTO kdh_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Wenbá bewelesée nɛ́ baanɩ́ɩ bɩlɛ́ nɛ́, ngɛ sɩsɩ: «Bɩlɛ́ nɛ́ weení wónÿuúu kʊ lɛ́ɛ́dɩ Ɩsɔ́ɔ-jɔ́ bɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Wenbí ɩráa tánbɩɩzɩ nɛ́, Ɩsɔ́ɔ ɩlɛ́ wánbɩɩzɩ́.» ");
INSERT INTO kdh_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ńna gɛ Pétro wɔɔdɔ́ Yeésu sɩsɩ: «Welesi yoo, ɖɔ́ɔ́ ɖééyéle bɩrɩ́ŋa ɖifu nya nɛ́, nŋɩ́nɩ́ gɛ ɖɛ́ndɛnáa.» ");
INSERT INTO kdh_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Ménveerím mɩ́ɩ toovonúm sɩsɩ weení ɩrɩ́ŋa weeyéle ɩɖaána, yáá ɩɖɛɛlʊ́, yáá igoobíya abaaláa, yáá ɩjaanáa, yáá ibíya Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-rɔ nɛ́, ");
INSERT INTO kdh_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","wónÿuúu bɩkɩ́lɩ bɩlɛ́ adɛ laadɔ́ɔ-rɔ cé, na ɩtásɩ iyuú weezuú kɩ́dɛ́ndɛŋ́ nɛ́ ceré Ɩsɔ́ɔ-jɔ́.» ");
INSERT INTO kdh_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yeésu wɔɔgbɔ́ɔ ɩwanbaaráa fuú na nɔɔ́lɛ wénveerím wɛ sɩsɩ: «Iwélesi ma kazɔ́ɔ, ɖángbáa Yerusalɛ́ɛm. Ńna gɛ wentí tɩrɩ́ŋa anɖébiwá waaŋmátɩ Ɩrʊ́ Biyaalʊ́-rɔ nɛ́, sɩ tikóódi. ");
INSERT INTO kdh_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Bángbáa yɩ becéle wenbá baasɩ Ɩsɔ́ɔ nɛ́ sɩsɩ bánmʊŋ́ yɩ, batʊ́ʊ yɩ, bɔtɔ ná yɩ ndɔɔlɩmá, ");
INSERT INTO kdh_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","bosúti yɩ agbáázá, bakʊ yɩ, amá, wɛ́ náádoozo wɩ́rɛ wénvém ɩlɩ́ɩ ɩsɩɖáa-daá.» ");
INSERT INTO kdh_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Amá, wanbaaráa bɛlɛ́, badanɩ́ɩ wentí Yeésu waaŋmátɩ nɛ́ tugutoluú, tɩɩlá wɛ temenuú biiyéle badatɩlɩ́ wentí wánŋmatɩ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yeésu waajʊʊná Yerikóo tɛ́ɛ́dɩ nɛ́, njɛm naárʊ cɔɔ́ɔ nɩ́bááwʊ-jɔ́ wánlám bára. ");
INSERT INTO kdh_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Waanɩ́ɩ zamɔ́ɔ wɛ́nɖɛɛ́ nɛ́, ngɛ wɔɔbɔ́ɔ́zɩ sɩsɩ ngbetíi wánlám kʊ. ");
INSERT INTO kdh_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ngɛ boobúsi yɩ sɩsɩ: «Yeésu Nazarɛ́ɛtɩ ńnɩ́ wɛ́nɖɛɛ kʊ.» ");
INSERT INTO kdh_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ńna gɛ woogóo sɩsɩ: «Yeésu, Ɖáwʊɖa Biyaalʊ́, nɩɩ mágʊnyɔḿ.» ");
INSERT INTO kdh_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ngɛ wenbá bɛdɛ́ɛ nɩ́bááwʊ nɛ́, wɛ bónÿoonáa yɩ sɩsɩ ísu tɔ́m. Amá, bɩdɛ́ɛ sáátɩ gɛ ɩlɛ́ waabá wóngoó bínjaarɩ́ sɩsɩ: «Ɖáwʊɖa Biyaalʊ́, nɩɩ mágʊnyɔḿ!» ");
INSERT INTO kdh_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ńna gɛ Yeésu waazɩ́ŋ ɩtɔ́ sɩsɩ bɔ́kɔ́ná ɩmʊ́ yɩ. Njɛm waajʊʊná Yeésu nɛ́, ngɛ Yeésu wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Wé gɛ nyɔ́zɔɔlɛ́ɛ sɩsɩ mála nya.» Ngɛ wɔɔdɔ́ yɩ sɩsɩ: «Kʊ́bɔnɩ́, mɔ́zɔɔlɛ́ɛ máázá ifulú.» ");
INSERT INTO kdh_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ngɛ Yeésu wɔɔdɔ́ yɩ sɩsɩ: «Nyáázá ífúlú! Nyɛ́dɛ́ɛ toovonúm fáa wɛɛlɛ́ɛ nya.» ");
INSERT INTO kdh_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ńna‑ńna gɛ waazá woovulú bɩka ivóo Yeésu wánzám Ɩsɔ́ɔ. Zamɔ́ɔ rɩ́ŋa waana bɩlɛ́ nɛ́, ngɛ kɩɩzá Ɩsɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yeésu waazʊ́ʊ Yerikóo tɛ́ɛ́dɩ-daá wɛ́ndɛsɩ́ tɩ. ");
INSERT INTO kdh_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Abaalʊ́ naárʊ wɛ tɛ́ɛ́dɩ tɩḿ tɩdaá bánÿaá yɩ sɩsɩ Zakée. Ɩgɛ́ɛ tikée mʊʊráa-dɛ́ɛ kʊ́bɔnɩ́ gɛ, bɩka ɩgɛ́ɛ ɖɔ́ɔ́lɛ-dʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Wánjáádɩ sɩ ɩna weení Yeésu kɛ́ɛ nɛ́, amá, zamɔ́ɔ-rɔɔzɩ́ nɛ́, ɩ́dánbɩɩzɩ, káma, ɩdabɩ́nɩ. ");
INSERT INTO kdh_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ngɛ weeze ibó bɩɩzá-daá ɩkpa tɩɩwʊ́ kʊ́bɔnbɔńgɩ nakɩ́rɩ-daá na bʊcɔ ɩbɩ́ɩ́zɩ ɩna Yeésu, káma, ńna gɛ ɩlɛ́ sɩ ɩbaná. ");
INSERT INTO kdh_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yeésu waadála ɖɩdáarɛ ɖɩḿ ɖɩdaá nɛ́, waagbáázɩ waazá ɩsɔ́ɔ́dáá ɩtɔ́ yɩ sɩsɩ: «Zakée kedi ɖasam, káma, sinje bɩɩbɔ́ɔ́zɩ mazʊ́ʊ nyɛ́dɛ́ɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ngɛ Zakée weegédi ɖasam ɩmʊ Yeésu na wenbi‑niíni. ");
INSERT INTO kdh_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Wenbá barɩ́ŋa baana bɩlɛ́ nɛ́, baayɩ́rɩ Yeésu sɩsɩ: «Alaháácɩ́-dʊ́ʊ-dɛ́ɛ gɛ woobó ɩsʊ́ʊ bɩlɛ́!» ");
INSERT INTO kdh_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakée sɩ́ŋɛ́ɛ Ɖádʊ́ʊ ɩzá-daá, ngɛ wɔɔdɔ́ yɩ sɩsɩ: «Welesi kʊ́bɔnɩ́, mɔ́ngbɔwʊ́ʊ mɛ́dɛ́ɛ ɖɔ́ɔ́lɛ-dɛ́ɛ fɔɔlʊʊ́ mava kadanbʊrʊ́sɩ; a ngʊ́ móómúúli naárʊ mamʊ ɩdɛ́ɛ liideé bɩcɛzɩ́ wenbí bɩɩbɔ́ɔ́zɩ nɛ́, mɛ́nvɛrɩ́ɩ yɩ bɩdɛ́ɛ nabʊ́náázá.» ");
INSERT INTO kdh_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ńna gɛ Yeésu wɔɔdɔ́ yɩ sɩsɩ: «Sinje lɛ́ɛ́dɩ waazʊ́ʊ ɖaána kana kadaá, káma, nyɔ́ɔ́ ɖʊɖɔ nyɛ́gɛ́ɛ Ibrahím biyaalʊ́ gɛ. ");
INSERT INTO kdh_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Káma, Ɩrʊ́ Biyaalʊ́ wɔɔgɔ́nɩ sɩ ɩcáa bɩka ɩlɛ́ɛ wenbí bɩɩdɛlɛ́ŋ nɛ́ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ngɛ Yeésu waadásɩ ɩŋmatɩná wenbá baanɩ́ɩ tɔ́m waaŋmátɩ tɩ nɛ́ na tɔmgɛɛzɩrɛ. Káma, wáńjʊ́ʊ́ná Yerusalɛ́ɛm bɩka bɛlɛ́ bánmaazɩ́ sɩsɩ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ wándalɩ́ɩ lɛlɛɛkɩna. ");
INSERT INTO kdh_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Wentí wɛɛgɛ́ɛ́zɩ wɛ nɛ́ nɖɔ́: «Ɩrʊ́ naárʊ ɩgɛ́ɛ koobíre kʊ́bɔńɖɛ-daá ɩrʊ́ nɛ́ sɩ ɩɖɛɛ ná laadɔ́ɔ bolíni ńga nɛkɛ́rɛ-daá bakázɩ́ɩ yɩ kowúrɔ́ɔ na bʊwɔ́rɔ́ nɛ́, ɩkábɩsɩ. ");
INSERT INTO kdh_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Waayáa ɩdɛ́ɛ bɔwʊtá-dɩnáa-daá fuú icéle badaá báa weení siká liideé ɩtɔ́ wɛ sɩsɩ bála ná yɛ fótóósi hálɩ ɩmʊ́ ɩkábɩsɩ. ");
INSERT INTO kdh_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Amá, ɩlaadɔ́ɔ-daá ɩráa tánjaa yɩ; ngɛ beedíri ɩráa na ɩwɔ́rɔ́ bobó befééri sɩsɩ bɛḿ bádánjaa ɩbɩ́sɩ bɛdɛ́ɛ wúro. ");
INSERT INTO kdh_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Na bɩrɩ́ŋa, baagázɩɩ ɩlɛ́ kowúrátɩ ɩkábɩsɩ ɩlaadɔ́ɔ-daá. Ngɛ waayáa ɩdɛ́ɛ bɔwʊtá-dɩnáa wenbá weejéle wɛ liideé nɛ́ sɩsɩ ɩna alɩbɔ́ɔ wenkí booyuú nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Kaɖaa ńnɩ́ wɔɔgɔ́nɩ nɛ́, ngɛ sɩsɩ: “Kʊ́bɔnɩ́, móóyúú siká liideé fuú madasɩ ná siká liideé nyééjéle ma nɛ́.” ");
INSERT INTO kdh_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ńna gɛ ɩgʊ́bɔnɩ́ wɔɔdɔ́ yɩ sɩsɩ: “Nyáálá kazɔ́ɔ, nyɛ́gɛ́ɛ bɔwʊtá-dʊ́ʊ kazɔ́ɔ ńnɩ́; mééjéle nya cʊ́kɔ ngɛ nyáálá ná kɩ tɩmɛ́rɛ na toovonúm nɛ́, mánzɩɩ́ nya kʊ́bɔńdɩ tɛ́ɛ́dɩ fuú-rɔ.” ");
INSERT INTO kdh_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Sɩɩlɛ ńnɩ́ wɔɔgɔ́nɩ nɛ́, ngɛ sɩsɩ: “Kʊ́bɔnɩ́, móóyúú siká liideé natʊ́nʊ́wá madasɩ ná siká liideé nyééjéle ma nɛ́.” ");
INSERT INTO kdh_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ngɛ wɔɔdɔ́tɔḿ ɩlɛ́ sɩsɩ: “Mánzɩɩ́ nya kʊ́bɔńdɩ tɛ́ɛ́dɩ natʊ́nʊ́wá-rɔ.” ");
INSERT INTO kdh_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Naárʊ ɩlɛ́ wɔɔgɔ́nɩ nɛ́, ngɛ ɩlɛ́ sɩsɩ: “Kʊ́bɔnɩ́, bɛɛ nyɛ́dɛ́ɛ siká liideé, mɔ́ɔ́gbɔ́ɔ yɛ gɛ mamʊ́sɩ bɩsaawʊ́-daá. ");
INSERT INTO kdh_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Káma, máánɩ́ɩ nyɛ́dɛ́ɛ nɩdáárɛ. Mányɩ sɩsɩ nyɛ́gɛ́ɛ ɩrʊ́ weení ɩjɔɔ́ɔ káálɛ nɛ́ gɛ; wenbí ńdásɩ́ɩ́ná nɛ́ gɛ nyɔ́ngbɔwʊ́ʊ, bɩka nyángʊ́m lénlé ndálára nɛ́.” ");
INSERT INTO kdh_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ńna gɛ wúro wɔɔdɔ́ yɩ sɩsɩ: “Na nyádɩtɩŋa nyɔ́nɔ́ɔ́-daá tɔ́m gɛ sɩ magʊ ná nyɔ́dɔ́m, bɔwʊtá-dʊ́ʊ tɩtɛ ńnɩ́ ceení. Nyányɩ sɩsɩ mɛ́gɛ́ɛ ɩrʊ́ weení ɩjɔɔ́ɔ káálɛ nɛ́, mángʊ́m lénlé mádalára nɛ́ bɩka mɔ́ngbɔwʊ́ʊ wenbí mádásɩ́ɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Bɩlɛ́ nɛ́, nɖaaboná méliideé nzɩ́ɩ bánkɩ; máagábɩ́sɩ ɖɔ́ nɛ́, maraamʊ yɛ ána adɛ́ɛ alɩbɔ́ɔ.” ");
INSERT INTO kdh_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ngɛ weevééri wenbá bɔwɛ ńna nɛ́ sɩsɩ bɛ́lɛɛ siká liideé ɩjɔ́ becéle weení ɩwɛná fuú nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bɛlɛ́ bɔɔdɔ́ yɩ sɩsɩ: “Kʊ́bɔnɩ́, ɩlɛ́ ɩwɛná fuú!” ");
INSERT INTO kdh_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ngɛ wúro woobúsi wɛ sɩsɩ: “Ménveerím mɩ́ɩ sɩsɩ weení ɩwɛná nɛ́, bándasɩ́ yɩ, amá, weení ɩvɛ́yɩ́na nɛ́, bɛ́nlɛɛ́ wenbíyɔ́ɔ ɩwɛná bɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Bɩɩga mabáɖaanáa wenbá bɔdɔsɔ́ɔ́lɩ sɩsɩ mábɩ́sɩ bɛdɛ́ɛ wúro nɛ́, ɩgɔná wɛ ɩtɔ́ɖɩ máázá-daá cé.”» ");
INSERT INTO kdh_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yeésu waaŋmátɩ bɩlɛ́ bɩtɛ́ nɛ́, ngɛ wɛɛdɛ nɩ́bááwʊ ɩkpɔ́ɔ wángbáa Yerusalɛ́ɛm. ");
INSERT INTO kdh_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Sáátɩ wenkí ɩwɛ bʊ́ʊ bánÿaá kɩ sɩsɩ Olivíyée tɩ́ɩ́nɩ bʊ́ʊ nɛ́ kɩdɛ́ɛ fáráńdɩ́ wáńjʊ́ʊ́ná Bɛtɩfagée na Betáániya tɛɛbíízi nɛ́, ngɛ Yeésu weedíri wanbaaráa nɔɔ́lɛ ");
INSERT INTO kdh_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ifééri wɛ sɩsɩ: «Ibó tɛɛbiiyá kɔwɛ mɩ́ɩ́zá-daá nɛ́ kadaá; a mɩ́ɩ́dála, mɩ́nnáa baaɖɩ kpangbɔ́ɔ bú naárʊ tɔcɔɔ tá kɛ nɛ́; ibóɖi kɛ ɩkɔná ma. ");
INSERT INTO kdh_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","A naárʊ wɔɔbɔ́ɔ́zɩ mɩ́ɩ sɩsɩ ngbaalá gɛ mínboɖí kɛ, ibúsi yɩ sɩsɩ: “Ɖádʊ́ʊ sɔɔlɛ́ɛ na kɛ.”» ");
INSERT INTO kdh_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ngɛ wenbá weedíri wɛ nɛ́ woobó bɔmɔɔná wenbí nɔ́ɔ́ Yeésu waaŋmátɩ wɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bɔwɛ bónboɖí kpangbɔ́ɔ bú nɛ́, ngɛ kɛlɛ́ kadɩnáa wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «Ngbaalá gɛ mínboɖí kɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ngɛ boobúsi sɩsɩ: «Ɖádʊ́ʊ sɔɔlɛ́ɛ na kɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bɔɔgɔ́gɔ́ná Yeésu kpangbɔ́ɔ bú; ngɛ baalɩzɩ́ bɛdɛ́ɛ kúsúúdi batɩ́nɩ kɔrɔ bakpáázɩ Yeésu ɩcɔ́ɔ kɔrɔ. ");
INSERT INTO kdh_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yeésu wɛ́nɖɛɛ́ nɛ́, ɩráa wɔ́nvɔ́ɔ bogúsúúdi nɩ́bááwʊ-rɔ gɛ. ");
INSERT INTO kdh_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Wáńjʊ́ʊ́ná Olivíyée tɩ́ɩ́nɩ bʊ́ʊ-dɛ́ɛ kedíkɔ́ɔ-daá gɛ bɩɩbá bɩlá ɩwanbaaráa rɩ́ŋa boduuzée nɛ́ niíni babáázɩ Ɩsɔ́ɔ sám bɩcáárɩ maamááciwá bánnáa tɩ nɛ́ tɩrɔ. ");
INSERT INTO kdh_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Bɔ́ndɔ́m sɩsɩ: «Ɩsɔ́ɔ ɩ́ɖʊ́ wúro weení ɩgɛrɛŋɛ na ɩyɩ́ɖɛ-daá nɛ́ alɩbáráka! Ɩsɔ́ɔ-dɛ́ɛ fɛɛzɩrɛ ɩ́cɔɔ ɩsɔ́ɔ́dáá bɩka ɩdɛ́ɛ ásícé ɩcɔ́ɔ ɩsɔ́ɔ́dáá bílí‑bílí!» ");
INSERT INTO kdh_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ńna gɛ Faríizi ńba nɛbɛ́rɛ bɔwɛ zamɔ́ɔ lɔwʊtáá nɛ́ bɔɔdɔ́ Yeésu sɩsɩ: «Kʊ́bɔnɩ́, feeri nyɛ́dɛ́ɛ wanbaaráa sɩsɩ bósu tɔ́m.» ");
INSERT INTO kdh_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Ménveerím mɩ́ɩ sɩsɩ a boozú tɔ́m, bɔ́ sɩ akoo ná.» ");
INSERT INTO kdh_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yeésu waajʊʊná Yerusalɛ́ɛm tɛ́ɛ́dɩ gɛ waagʊ́sɩ ɩbɛ́ɛ́ŋ tɩ ɖɔ́ nɛ́, ngɛ weewíi tɩrɔ ");
INSERT INTO kdh_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","wɔ́ndɔ́m sɩsɩ: «A sinje wɩ́rɛ ɖɩna nyɔ́ɔ́ ɖʊɖɔ nɖaadɩlɩ́ nŋɩ́nɩ́táá nyónÿuú na fɛɛzɩrɛ nɛ́! Amá, lɛlɛɛɖɔ́ bɩmʊ́sɛ́ɛ nya, ńdánbɩɩzɩ nna! ");
INSERT INTO kdh_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Káma, wɛ́-bíya nɛbɛ́rɛ wándalɩ́ɩ, na nbáɖaanáa ɩma balára bamɩlɩná nya, boyóo nya cé na cé. ");
INSERT INTO kdh_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bónnuudí nya cɩ́rɩ́-cɩ́rɩ́ nyána nyébíya, bádángáa bʊ́ʊ́rɛ ɖɩdɩ́nɛ́ɛ ɖɩrɔwʊ́-rɔ, káma, ńdátɩ́lɩ́ sáátɩ wenkí Ɩsɔ́ɔ wɔɔgɔ́nɩ sɩ ɩlɛ́ɛ nya nɛ́!» ");
INSERT INTO kdh_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Bɩlɛ́ bʊwɔ́rɔ́ gɛ Yeésu waazʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá ɩɖɔ́ɔ wenbá barɩ́ŋa bánÿám kpɩná ńna nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ngɛ wɔɔdɔ́ wɛ sɩsɩ: «Baaŋmáa Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá sɩsɩ: “Máɖaána sɩ kalá Ɩsɔ́ɔ sɛ́ɛ́dɩ ɖaána gɛ.” Amá, mɩ́nyɔ́ɔ́ mɩ́ɩ́bɩ́sɩ́ná kɛ ŋmɩɩláa ɖaána.» ");
INSERT INTO kdh_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Báa wɩ́rɛ wenɖé Yeésu wɛ gɛ wánwɩlɩ́ɩ ɩráa Ɩsɔ́ɔ-dɛ́ɛ tɔ́m Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá. Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa na Mará wɩlɩɖáa na Yahúúɖuwá-dɛ́ɛ kʊ́bɔnáa baaganáa wánjáádɩ sɩ bakʊ yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Amá, baasɩ nŋɩ́nɩ́ sɩ bɔkpɔɔná nɛ́, káma, zamɔ́ɔ rɩ́ŋa ɩbá kínwelesí yɩ na kɩlaakáarɩ rɩ́ŋa gɛ. ");
INSERT INTO kdh_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Wɩ́rɛ Yeésu wɛ wánwɩlɩ́ɩ Ɩsɔ́ɔ-dɛ́ɛ tɔ́m Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá bɩka wénveerím ɩráa Laabáárʊ Kífeńgi nɛ́, Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa na Mará wɩlɩɖáa na Yahúúɖuwá-dɛ́ɛ kʊ́bɔnáa waaɖʊ balɩ́ɩ ɩjɔ́. ");
INSERT INTO kdh_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ngɛ bɔɔdɔ́ yɩ sɩsɩ: «Feeri ɖáa: na yíko wenkí gɛ nyánlanáa tɩmɛ́ ana. Ngɛ weení waava ná nya yíko kɩḿ.» ");
INSERT INTO kdh_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yeésu woobúsi wɛ sɩsɩ: «Mɔ́ɔ́ ɖʊɖɔ mɔ́nbɔɔzɩ́ mɩ́ɩ tɔ́m. Ivééri ma. ");
INSERT INTO kdh_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Weení weegédíri ná Yaayá ɩkɔ́nɩ ilíri ɩráa lɩ́m-daá ɩsɔ wɛ túúbá lɩ́m. Ɩsɔ́ɔ yáá ɩráa.» ");
INSERT INTO kdh_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ngɛ baala ná ɖamá sááwʊ́ra bɔtɔ́ ɖamá sɩsɩ: «A ɖɔ́ɔ́dɔ́ sɩsɩ Ɩsɔ́ɔ, wɔ́ndɔ́m ɖáa sɩsɩ: “Ngbaalá mɩ́dálá yɩ yaraɖá.” ");
INSERT INTO kdh_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","A ngʊ́ ɖɔ́ɔ́dɔ́ sɩsɩ ɩráa, zamɔ́ɔ wɔ́nÿɔwʊ́ʊ ɖáa bɔ́ ɖɩsɩ́, káma, barɩ́ŋa beeɖéézi sɩsɩ Yaayá kɛ́ɛ anɖébi gɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ngɛ boobúsi Yeésu sɩsɩ: «Ɖádátɩ́lɩ́ weení weegédíri yɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yeésu ɖʊɖɔ wɔɔdɔ́ wɛ sɩsɩ: «Mɔ́ɔ́ ɖʊɖɔ médénveeri mɩ́ɩ yíko wenkí mánlanáa tɩmɛ́ ana nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Bɩlɛ́ bʊwɔ́rɔ́ gɛ Yeésu waaŋmatɩná zamɔ́ɔ na tɔmgɛɛzɩrɛ sɩsɩ: «Fɔɔ́-dʊ́ʊ naárʊ wooɖuu ná víinyi tiyísi. Ngɛ wɔɔgbɔ́ɔ fɔɔ́ kɛḿ icéle wenbá bánvarɩ́m víinyi nɛ́ bɩka ɩɖɛ́ɛ nɩ́bááwʊ sɩ ikéleeri. ");
INSERT INTO kdh_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Víinyi bíya kɔrɩ́ɩ-dɛ́ɛ sáátɩ waadála nɛ́, ngɛ weedíri ɩdɛ́ɛ bɔwʊtá-dʊ́ʊ kʊ́ɖʊḿ wenbá bánvarɩ́m víinyi nɛ́ bɔjɔ́ sɩsɩ íbo ɩkámʊ́ ɩmʊ́ ɩdɛ́ɛ ńbɩ ɩkɔ́gɔ́ná ɩmʊ́. Amá, bɛlɛ́ baabá gɛ bamá ɩdɛ́ɛ bɔwʊtá-dʊ́ʊ bɔkɔ́ɖɔ́ɔ yɩ ɩkábɩsɩ nʊ́ʊ́zɩ yéḿ. ");
INSERT INTO kdh_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ngɛ fɔɔ́-dʊ́ʊ weedétirí bɔwʊtá-dʊ́ʊ kɩ́falʊ́. Amá, wenbá bánvarɩ́m víinyi nɛ́, baabá gɛ bamá ɩlɛ́ ɖʊɖɔ, baɖʊ yɩ fɛɛrɛ́ bɔkɔ́ɖɔ́ɔ yɩ ɩkábɩsɩ nʊ́ʊ́zɩ yéḿ. ");
INSERT INTO kdh_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ngɛ fɔɔ́-dʊ́ʊ weedétirí bɔwʊtá-dʊ́ʊ toozo ńnɩ́. Ngɛ baadálaḿ bɩnɩ́ɩ ɩlɛ́ ɖʊɖɔ bɔkɔ́ɖɔ́ɔ yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ngɛ fɔɔ́-dʊ́ʊ sɩsɩ: “Nŋɩ́nɩ́ gɛ mánlám ɖɔ́. Méndiríi mebiyaalʊ́ máábá mɔ́zɔɔlɛ́ɛ yɩ nɛ́ gɛ, nabʊ́rʊ bánɖʊ́ʊ ɩlɛ́ gírímá.” ");
INSERT INTO kdh_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Amá, wenbá bánvarɩ́m víinyi nɛ́, baana biyaalʊ́ʊ nɛ́, ngɛ bɔɔdɔ́ ɖamá sɩsɩ: “Tííbí-dʊ́ʊ nbɩlɛ́! Ɩgɔ́nɩ! Ɖɩ́kʊ́ yɩ bɩka ɖɩkpɔ́ɔ tííbí.” ");
INSERT INTO kdh_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ngɛ beegbí yɩ balɩɩná víinyi fɔɔ́ wɔ́rɔ́ bakágʊ́.» Ngɛ Yeésu wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «Bɩlɛ́ nɛ́, nŋɩ́nɩ́ gɛ víinyi fɔɔ́-dʊ́ʊ wánlám wɛ. ");
INSERT INTO kdh_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Wɔ́ngɔnɩ́ ɩkʊ wɛ na ɩkpɔ́ɔ víinyi fɔɔ́ icéle kɩ́faláa.» Zamɔ́ɔ waanɩ́ɩ bɩlɛ́ nɛ́, ngɛ sɩsɩ: «Aayɩ́, Ɩsɔ́ɔ íkeyéle bɩlá bɩlɛ́ kɛtɛngɛrɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Amá, Yeésu wɛɛbɛ́ɛ́ŋ wɛ nɛ́, ngɛ sɩsɩ: «Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá ŋmáádɩ tɩna tugutoluú gɛ sɩsɩ wé. “Bʊ́ʊ́rɛ wenɖé maaráa weegízi ɖɛ nɛ́, ɖɩɩbɩsɩ ná cʊnbʊʊrɛ-daá bʊ́ʊ́rɛ.” ");
INSERT INTO kdh_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Weení ɩrɩ́ŋa sɩ ɩsála ɖɩrɔ nɛ́ wánbʊʊ́rɩ, a ngʊ́ ɖɩɩzála weení-rɔ nɛ́, ɖɩ́nnaŋ́ yɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ńna‑ńna gɛ Mará wɩlɩɖáa na Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa wɔɔzɔ́ɔ́lɩ sɩsɩ bakpa Yeésu, amá, baanɩ́ɩ zamɔ́ɔ-dɛ́ɛ nɩdáárɛ. Baabá boyuú banɩ́ɩ sɩsɩ bɛḿ gɛ wɔɔdɔ́ waaŋmatɩná tɔmgɛɛzɩrɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ńna gɛ baabáázɩ Yeésu cɔŋ́; ngɛ beedíri cɔŋɩráa bɩka bɛlɛ́ bánlám nyazɩ bɛgɛ́ɛ toovonúm-dɩnáa bɩlɛ́. Bɔzɔɔlɛ́ɛ bayɩ́ ɩnɔɔ́-jɔ́ na boyuú natɩ́rɩ ɩdɛ́ɛ ŋmatɩrɛ-daá bobuuná yɩ bɩka bakpa yɩ becéle laadɔ́ɔ-daá nɩ́baadɛɛrʊ́. ");
INSERT INTO kdh_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Bɛlɛ́ bɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Kʊ́bɔnɩ́, ɖányɩ sɩsɩ toovonúm gɛ nyánŋmatɩ́ bɩka nyánwɩlɩ́ɩ kazɔ́ɔ, ngʊ́ bɩlɛ́ gɛ nyáábafɛ́yɩ́na naárʊ, amá, nyánwɩlɩ́ɩ Ɩsɔ́ɔ-dɛ́ɛ tɔ́m na toovonúm gɛ. ");
INSERT INTO kdh_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Bɩlɛ́ nɛ́, feeri ɖáa wentí nyánmaazɩ́ tɔ́m tɩna tɩrɔ nɛ́: Bɩɩva nɩ́bááwʊ yáá bɩdafa sɩsɩ ɖɩ́fɛrɛ Róóma wúro kʊ́bɔnɩ́ lanpóo.» ");
INSERT INTO kdh_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Amá, Yeésu nyɩ bɛdɛ́ɛ lɔ́nɩ-rɔ nɛ́, ngɛ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Ɩwɩ́lɩ ma liideé mɩ́nvɛrɛnáa lanpóo nɛ́. Weení kʊjʊʊ́ na ɩyɩ́ɖɛ gɛ kɩrɔ.» Ngɛ boobúsi yɩ sɩsɩ: «Róóma wúro kʊ́bɔnɩ́ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ńna gɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Ijéle Róóma wúro kʊ́bɔnɩ́ wenbí bɩgɛ́ɛ Róóma wúro kʊ́bɔnɩ́-dɛ́ɛ ńbɩ nɛ́, bɩka icéle Ɩsɔ́ɔ Ɩsɔ́ɔ-dɛ́ɛ ńbɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bodoyuú natɩ́rɩ ɩdɛ́ɛ ŋmatɩrɛ-daá bobuuná bakʊ ɩdɔ́m zamɔ́ɔ ɩzá-daá ńna. Hálɩ ɩdɛ́ɛ tɔ́m busí waalá wɛ bítí gɛ bosú tɔ́m. ");
INSERT INTO kdh_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Bʊwɔ́rɔ́ gɛ Sadusée ńba wenbá bɔ́ndɔ́m sɩsɩ ɩsɩɖáa ténveḿ nɛ́, boogóduu Yeésu-jɔ́ bɔbɔ́ɔ́zɩ yɩ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Kʊ́bɔnɩ́, Múúsá wɔɔdɔ́ sɩsɩ a ɩrʊ́ abaalʊ́ talʊ́rʊ gɛ waazɩ́, bɩɩbɔ́ɔ́zɩ igoobú ɩfʊ́ leelú na ɩlʊ́rʊ bíya babɩ́sɩ koobúu weení waazɩ́ nɛ́ ɩdɛ́ɛ bíya. ");
INSERT INTO kdh_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ngʊ́ ɖɔ́ɔ́ ɖɛ́dɛ́ɛ, koobíya lʊbɛ wɛ ná. Kaɖaa ńnɩ́ wɔɔgbɔ́ɔ alʊ́ nɛ́ waazɩ́, ɩdalʊ́rʊ. ");
INSERT INTO kdh_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Sɩɩlɛ ńnɩ́ waavʊ́ leelú, ");
INSERT INTO kdh_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","toozo ńnɩ́ ɩkpɔ́ɔ yɩ, bɩlɛ́ gɛ bɩɩlaaná hálɩ bɛdɛ́ɛ lʊbɛ basɩ́ bɩka báa kʊ́ɖʊḿ talʊ́rʊ. ");
INSERT INTO kdh_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Barɩ́ŋa baazɩ́ wɔ́rɔ́ nɛ́, ngɛ leelú ɖʊɖɔ waazɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Tɔ́ɔ, ńŋɩnáa barɩ́ŋa bɔɔgbɔ́ɔ yɩ nɛ́, wɩ́rɛ wenɖé ɩsɩɖáa sɩ befé bɩlɛ́ nɛ́, badaá weení gɛ alʊ́ waalʊ́ ɖɔ́.» ");
INSERT INTO kdh_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yeésu woobúsi wɛ sɩsɩ: «Ɖúúlínya kɩna kɩdaá gɛ aláa na abaaláa bɔ́ngbɔwʊ́ʊ ɖamá. ");
INSERT INTO kdh_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Amá, wenbá Ɩsɔ́ɔ weeɖéézi wɛ sɩsɩ bónÿuú ceré bɩka befé balɩ́ɩ ɩsɩɖáa-daá nɛ́ bɔ́dɔngbɔwʊ́ aláa yáá basáa abaaláa. ");
INSERT INTO kdh_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bɛlɛ́ bádándasɩḿ ɖʊɖɔ, káma, bɔjɔɔ́ɔ gɛ nyazɩ malááyɩ́kawá. Bɛgɛ́ɛ Ɩsɔ́ɔ biyaalɩnáa gɛ, káma, beevé balɩ́ɩ ɩsɩɖáa-daá. ");
INSERT INTO kdh_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Múúsá waawɩ́lɩ bɩlɛ́ sɔɔzɔ́ɔ́zɩ-daá nimidʊlʊʊ́-dɛ́ɛ tɔ́m-daá sáátɩ wenkí waayáa Ɖádʊ́ʊ sɩsɩ Ibrahím na Ɩsaáka na Yaakúbu bɛdɛ́ɛ Ɩsɔ́ɔ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ɩsɔ́ɔ tɛkɛ́ɛ ɩsɩɖáa-dɛ́ɛ Ɩsɔ́ɔ, amá, weezíni-dɩnáa-dɛ́ɛ ńnɩ́ gɛ ɩgɛ́ɛ. Káma, ɩjɔ́ nɛ́ wenbá barɩ́ŋa bɛgɛ́ɛ ɩdɛ́ɛ ńba nɛ́ bɔwɛ weezuú-daá gɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ńna gɛ Mará wɩlɩɖáa nɛbɛ́rɛ wɔɔdɔ́ sɩsɩ: «Kʊ́bɔnɩ́, nyááŋmátɩ kazɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Káma, bɩdɩ́ŋa-rɔ bodokúti boyuú wenbiré bɔbɔ́ɔ́zɩ yɩ tɔ́m natɩ́rɩ ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Nŋɩ́nɩ́ gɛ ɩráa wánbɩɩzɩ́ bɔtɔ́ sɩsɩ Lɛɛrʊ́ kɛ́ɛ Ɖáwʊɖa biyaalʊ́. ");
INSERT INTO kdh_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Káma, Ɖáwʊɖa tɩtɩŋa wɔɔdɔ́ Yéńdiwá-dɛ́ɛ tákaraɖá-daá sɩsɩ: “Ɖádʊ́ʊ wɔɔdɔ́ Mádʊ́ʊ sɩsɩ: ‘Cɔɔ mégíɖíiwú-rɔ ");
INSERT INTO kdh_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hálɩ maɖʊ nbáɖaanáa nyɔ́nʊvɔ́-dɛ.’ ” ");
INSERT INTO kdh_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","A bɩlɛ́ gɛ Ɖáwʊɖa waayáa yɩ sɩsɩ Ɩdʊ́ʊ, bɩɩlá nŋɩ́nɩ́ gɛ igúti ɩgɛ́ɛ ibiyaalʊ́ ɖʊɖɔ.» ");
INSERT INTO kdh_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Bɩlɛ́ bʊwɔ́rɔ́ gɛ Yeésu waaŋmatɩná ɩwanbaaráa zamɔ́ɔ rɩ́ŋa kiwelesée yɩ nɛ́ kɩɩzá-daá sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Iguná laakáarɩ na Mará wɩlɩɖáa. Bɔzɔɔlɛ́ɛ béngilím bozóóna kpáyɩwá kʊ́bɔńdɩ bɩka ɖʊɖɔ bɔzɔɔlɛ́ɛ gɛ a bɛ́nzɛɛ́ wɛ zamɔ́ɔ-daá, bɔ́nɖɔɔzɩ́ wɛ. Kʊ́bɔɔ-ɖɩdáarɛ gɛ bɔɔzɔ́ɔ́lɩ cɔwʊ́ʊ Ɩsɔ́ɔ ɖaazɛɛɖɛ́ na ɖíínawá-daá. ");
INSERT INTO kdh_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bɛ́nlɛɛ́ leeláa-jɔ́ wenbí bɩrɩ́ŋa bɛlɛ́ bɔwɛná nɛ́, bɩka bánlám sʊlʊ́ńdɩ kɩ́bɩɩzɩ́tɩ na ɩráa ɩna wɛ. Bʊrɔɔzɩ́ gɛ bɛdɛ́ɛ nɩgbamʊʊ́ fɔ́m wánbá bɩlá ɖóni.» ");
INSERT INTO kdh_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yeésu waagʊ́sɩ ɩzá nɛ́, ngɛ waana liideé-dɩnáa wánɖʊ́ʊ bɛdɛ́ɛ kʊjɔ́ɔ́nɩ, kʊjɔ́ɔ́nɩ ɖaaɖʊ́ʊ́ɖɛ. ");
INSERT INTO kdh_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ngɛ waadánáa leelú kɛdɛɛrɩ́ya nɛkɛ́rɛ waaɖʊ jɩtɔ́ɔ yáawá nasɩ́lɛ sɩdatála nabʊ́rʊ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ngɛ wɔɔdɔ́ sɩsɩ: «Ménveerím mɩ́ɩ toovonúm sɩsɩ leelú kɛdɛɛrɩ́ya kana kaaɖʊ kakɩ́lɩ baaganáa rɩ́ŋa. ");
INSERT INTO kdh_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Káma, baaganáa rɩ́ŋa waalɩzɩ́ weená avɛ́yɩ́na wɛ fɔ́ɔ́zɩrɛ nɛ́ adaá gɛ, amá, kɛḿ nɛ́, na bɩrɩ́ŋa na kɛdɛ́ɛ kɛdɛɛrɩ́tɩ, kaava wenbí bɩrɩ́ŋa kɔwɛná sɩ bité kɛ nɛ́ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nɛbɛ́rɛ wɛ bánŋmatɩ́ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-dɛ́ɛ máa-dɛ́ɛ kazɔ́ɔ, na bɔ́ baamaná kɛ nɛ́, na kpɩná baava Ɩsɔ́ɔ nɛ́-dɛ́ɛ kazɔ́ɔ nɛ́, ngɛ Yeésu sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Wɩ́rɛ wándalɩ́ɩ, bɩ́dángáa bʊ́ʊ́rɛ ɖɩdɩ́nɛ́ɛ ɖɩrɔwʊ́-rɔ. Bɩrɩ́ŋa bínnuudí.» ");
INSERT INTO kdh_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ngɛ bɛlɛ́ bɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Kʊ́bɔnɩ́, feeri ɖáa sáátɩ wenkí sɩ bɩlá bɩlɛ́ nɛ́ na nyɛ́dɛ́ɛ kɔnɖɛ́ na ɖúúlínya kʊrʊ́ʊ-dɛ́ɛ seríya.» ");
INSERT INTO kdh_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Iguná laakáarɩ, naárʊ ɩ́kɛtɛlɛ́sɩ mɩ́ɩ. Káma, ɩráa ɖabata wɔ́ngɔnɩ́ na máyɩ́ɖɛ-daá, bɔtɔ́ sɩsɩ: “Mɔ́ɔ́ gɛ Lɛɛrʊ́, alɩwáátɩ waadála.” Íkofu wɛ. ");
INSERT INTO kdh_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","A mɩ́nnɩɩ́ bánŋmatɩ́ yóóni na ɖamá kʊrʊ́na-dɛ́ɛ tɔ́m, ɩ́kanɩ́ɩ nɩdáárɛ! Káma, bɩmɔɔ́na bɩlɛ́ bɩrɩ́ŋa bɩtála. Amá, bɩdɛkɛ́ɛ sɩsɩ ɖúúlínya kʊrʊ́ʊ waajaŋ ná bɩtála.» ");
INSERT INTO kdh_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ngɛ woozúúri sɩsɩ: «Yíri wónÿoó yíri, wúro iyóo wúro; ");
INSERT INTO kdh_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Fáráńdɩ́wá ndɩ‑ndɩ-daá, adɛ wánbá biséle, kɩzɩ́kʊ ɩlá, nyɔɔ́sɩ ɖʊɖɔ ɩlá. Bónlosí maanáwá tɩjɔɔ́ɔ nɩdáárɛ nɛ́ ɩsɔ́ɔ́dáá, na maamááciwá kʊ́bɔńdɩ. ");
INSERT INTO kdh_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Amá, naanɩ́ bɩlɛ́ bɩrɩ́ŋa bɩtála nɛ́, bángbáa mɩ́ɩ, banáázɩ mɩ́ɩ, bɩka bakʊ mɩ́ɩ. Bɔ́ngbɔwʊ́ʊ mɩ́ɩ becéle tɔmvʊʊráa Ɩsɔ́ɔ ɖaazɛɛɖɛ́, bɔtɔ mɩ́ɩ sáráka. Bánÿaá mɩ́ɩ wɔnásɩ wúrowá na laadásɩ-dɛ́ɛ nɩ́baadɛɛráa-jɔ́ máyɩ́ɖɛ-rɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Bɩ́nváa nɩ́bááwʊ ɩlɩzɩ́ mɛ́dɛ́ɛ seríya. ");
INSERT INTO kdh_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ɩdɩlɩ́ ɩsɩ́ɩ mɩ́gʊjʊ́nɩ-daá sɩsɩ bɩdɔbɔ́ɔ́zɩ ɩfʊ́ńgbɩɩrɩ kúbúsíti sáátɩ wenkí sɩ bafʊʊná mɩ́ɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Mádɩtɩŋa sɩ mejele ná mɩ́ɩ áséńsí ŋmatɩrɛ wenɖé mɩ́báɖaanáa tánbɩɩzɩ bɔcɔ́ɔ́lɩ ɖɛ péḿ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Mɩ́jaanáa tɩtɩŋa na mɩ́gɔɔnáa, mígoobíya, mígoobíre, na mɩ́ɖɔndɩnáa wánÿám mɩ́ɩ, beyéle bakʊ mɩ́dáá nɛbɛ́rɛ tɔ́m sɩsɩ bákʊ́ wɛ. ");
INSERT INTO kdh_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Barɩ́ŋa béngizíi mɩ́ɩ máyɩ́ɖɛ-rɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Amá, báa mɩ́gʊjʊʊ́-daá nyɔká kʊ́ɖʊmɔ́ɔ tɛ́nbɛɖɩ. ");
INSERT INTO kdh_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ɩɖɔ́kɩ mɩ́dɩ: Bɩlɛ́ bínÿelíi kʊ ɩlɛ́ɛ míweezíni.» ");
INSERT INTO kdh_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«A bɩgɛ́ɛ mɩ́ɩ́ná sɔ́ɔ́jawá waalára bamɩlɩná Yerusalɛ́ɛm, ɩdɩlɩ́ sɩsɩ tɩdɛ́ɛ nuudí waadála. ");
INSERT INTO kdh_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Bɩdɛ́ɛ sáátɩ nɛ́, wenbá bɔwɛ Yudée laadɔ́ɔ-daá nɛ́, bésé bɛɖɛ́ɛ bʊ́ʊ́nɩ-daá. Wenbá bɔwɛ Yerusalɛ́ɛm tɛ́ɛ́dɩ-daá nɛ́, bálɩɩ. Wenbá bɔwɛ fásɩ nɛ́ bákákázʊʊ tɛ́ɛ́dɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Káma, wɛ́-bíya bɛḿ badaá Ɩsɔ́ɔ wɔ́nvɔ́m ɩráa nɩgbamʊʊ́ nɛ́ gɛ wentí tɩrɩ́ŋa baaŋmáa Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá nɛ́ wóngoodí. ");
INSERT INTO kdh_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nbusú ɖamáa na aláa bɛyɛ́ɛna fúúzi nɛ́, na wenbá bebíya wánmʊzʊ́ʊ wɛ wɛ́ amʊ́ nɛ́. Káma, laadɔ́ɔ kɛḿ kánnáa wahála kʊ́bɔńgɩ, bɩka Ɩsɔ́ɔ-dɛ́ɛ baaná ití kɛdɛ́ɛ ɩráa-rɔ. ");
INSERT INTO kdh_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bángʊ́ʊ nɛbɛ́rɛ na tókobíwá, bakpa nɛbɛ́rɛ yoḿti bɛɖɛɛná laadásɩwá rɩ́ŋa-daá na bɩka wenbá baasɩ Ɩsɔ́ɔ nɛ́ bonúúdi Yerusalɛ́ɛm hálɩ alɩwáátɩ wenkí baava wɛ nɛ́ ɩtɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Yáásɩ́wá natɩ́rɩ wánlám wɩ́sɩ-daá, na fenɔɔ́-daá, na wɩlásɩ-daá; bɩka adɛ laadɔ́ɔ-rɔɔzɩ́, tenkú na kɩdɛ́ɛ lɩmvolá-dɛ́ɛ agogo wánbá bɩsʊ́ʊ́zɩ yíriwá kaanɩŋá. ");
INSERT INTO kdh_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Baɖamáa nbusúwá sɩ tɩkɔ́nɩ adɛ laadɔ́ɔ-rɔ nɛ́, ɩráa wɛ́nbɛlɩ́ɩ basɩ́ nɩdaazɩ́m. Káma, yíkowá tɩwɛ ɩsɔ́ɔ́dáá nɛ́ tínzelíi. ");
INSERT INTO kdh_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Sáátɩ kɩḿ gɛ bánnáa Ɩrʊ́ Biyaalʊ́ wɛ́ngɛɖɛɛ́ ŋmɩnʊʊ́-rɔɔzɩ́ ɩ́gana yíko rɩ́ŋa na ásícé rɩ́ŋa. ");
INSERT INTO kdh_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","A bɩdɛ́ɛ yáásɩ́wá tɩḿ tɩɩbáázɩ lám, ɩgʊrʊ́ ɩsɩ́ŋ bɩka ɩkʊ́sɩ kʊjʊʊ́, káma, mɩ́dɛ́ɛ lɛ́ɛ́dɩ waajʊ́ʊ.» ");
INSERT INTO kdh_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ngɛ waaŋmatɩná wɛ na tɔmgɛɛzɩrɛ sɩsɩ: «Ɩbɛ́ɛ́ŋ figíyée tɩɩwʊ́ na tɩ́ɩ́nɩ rɩ́ŋa: ");
INSERT INTO kdh_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","a bɩgɛ́ɛ sɩsɩ tɩɩbáázɩ fáádɩ lɩzɩ́ɩ, mɩ́dɩtɩŋa mɩ́nyɩ sɩsɩ lʊngʊrɛ́ waajʊ́ʊ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Bɩlɛ́ nɛ́ mɩ́nyɔ́ɔ́ ɖʊɖɔ, a bɩgɛ́ɛ sɩsɩ mɩ́ɩ́ná yáásɩ́wá tɩḿ tɩ́nlám, ɩdɩlɩ́ sɩsɩ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ waajʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ménveerím mɩ́ɩ toovonúm sɩsɩ zaamáánɩ kɩna kɩdɛ́ɛ ɩráa tɛ́ndɛŋ́ na bɩrɩ́ŋa ɖɔ́ bɩtála. ");
INSERT INTO kdh_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Adɛ na ɩsɔ́ɔ́dáá wɛ́ndɛlɛ́ŋ, amá, mɛ́dɛ́ɛ ŋmatɩrɛ tɛ́ndɛlɛ́ŋ kɛtɛngɛrɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Ɩɖɔ́kɩ mɩ́dɩ míveráa na ɩ́kɔkpɔ́ɔ mɩ́dɩ ɩɖʊ ɖíi na nyɔ́ɔ́dɩ na wenbí sɩ bʊɖɔ́kɩ mɩ́ɩ weezuú-daá nɛ́ bɩdɛ́ɛ lomaazɛ́wá-daá, na bɩdɛ́ɛ wɩ́rɛ ɖɩḿ ɖɩ́kɔkɔ́nɩ ɖɩtála mɩ́raabaazɛ́ɛ́na. ");
INSERT INTO kdh_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Sɩ ɖɩcɛ́ gɛ ɖɩsála wenbá barɩ́ŋa bɔwɛ adɛ laadɔ́ɔ rɩ́ŋa-rɔ nɛ́ bɔrɔ nyazɩ bɔ́nlɔ́ɔ biruú nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Bɩlɛ́ nɛ́, ɩjɔ́ɔ míveráa bɩka mɩ́nzɛɛ́ Ɩsɔ́ɔ báa sáátɩ wenkí, na ɩbɩ́ɩ́zɩ iyuú ɖóni ɩlɩ́ɩ wenbí bɩrɩ́ŋa sɩ bɩkɔ́nɩ nɛ́ bɩdaá, na ɩbɩ́ɩ́zɩ ɩsɩ́ŋ Ɩrʊ́ Biyaalʊ́ ɩzá-daá.» ");
INSERT INTO kdh_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ɩdaavéézi nɛ́, Yeésu wánwɩlɩ́ɩ Ɩsɔ́ɔ-dɛ́ɛ tɔ́m Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá gɛ; amá, kínÿúu nɛ́, na ɩlɩ́ɩ ɩɖɛ́ɛ bʊ́ʊ bánÿaá kɩ Olivíyée tɩ́ɩ́nɩ bʊ́ʊ nɛ́ kɩdaá ikóɖoo. ");
INSERT INTO kdh_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tɛ́ɛrɛ́-tɛ́ɛrɛ́ nɛ́, zamɔ́ɔ rɩ́ŋa wɔ́ngɔnɩ́ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá bénwelesí yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Kpɔ́nɔ́ badaɖʊ kɩ faadɩ́nɩ nɛ́-dɛ́ɛ jíńgáárɩ́ bánÿaá kɩ sɩsɩ Fɛlɛ nɖɛ́ɛ-dɛ́ɛ jíńgáárɩ́ nɛ́ bamáa cʊʊ́. ");
INSERT INTO kdh_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa na Mará wɩlɩɖáa wánjáádɩ nŋɩ́nɩ́ báta balá na bakʊ Yeésu nɛ́, amá, bánnɩɩ́ zamɔ́ɔ nɩdáárɛ. ");
INSERT INTO kdh_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Bɩdɛ́ɛ sáátɩ gɛ Sitáánɩ waazʊ́ʊ Yudásɩ weení bánÿaá yɩ sɩsɩ Isikariyóo bɩka ɩgɛ́ɛ fuú na nɔɔ́lɛ-daá ńnɩ́ naárʊ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ngɛ Yudásɩ waagʊrʊ́ ibó ɩmɔɔná Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa na sɔ́ɔ́jawá bénveríi Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga nɛ́ bɛdɛ́ɛ kʊ́bɔnáa ɩ́na wɛ bɔmɔ́ɔ ɖamá nŋɩ́nɩ́ sɩ ɩlá na ɩkpa Yeésu icéle wɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ńna gɛ bɩɩbá bɩlá wɛ niíni, ngɛ baazɩ́ŋ sɩsɩ bánváa yɩ liideé. ");
INSERT INTO kdh_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Kʊjɔɔwʊ sɩ balá Yudásɩ nɛ́ wɔɔmɔ́ɔ yɩ, ngɛ waazʊ́ʊ nɩ́báánɩ cáádɩ na ɩkpa Yeésu icéle wɛ bɩka zamɔ́ɔ tándɩlɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kpɔ́nɔ́ badaɖʊ kɩ faadɩ́nɩ nɛ́-dɛ́ɛ jíńgáárɩ́-dɛ́ɛ wɩ́rɛ wenɖé bángʊ́ʊ Fɛlɛ nɖɛ́ɛ-dɛ́ɛ jíńgáárɩ́-dɛ́ɛ feevaláa nɛ́ waadála. ");
INSERT INTO kdh_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ngɛ Yeésu weedíri Pétro na Yʊháánɩ ɩtɔ́ wɛ sɩsɩ: «Ibó ɩkágbɩɩrɩ ɖáa Fɛlɛ nɖɛ́ɛ-dɛ́ɛ jíńgáárɩ́ na ɖiɖi kɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ngɛ bɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Lé gɛ nyɔ́zɔɔlɛ́ɛ sɩsɩ ɖɩ́kagbɩɩrɩ kɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Bɛɛ́ɛ, a mɩ́ɩ́dála sɩ ɩsʊ́ʊ tɛ́ɛ́dɩ-daá, mɩ́nzɩŋ́ abaalʊ́ naárʊ, ɩgazʊwáána lɩ́m na báyɔ́ɔ. Ivu yɩ ɖaána wenká kadaá sɩ ɩsʊ́ʊ nɛ́, ");
INSERT INTO kdh_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","na ɩtɔ́ ɖaána-dʊ́ʊ sɩsɩ: “Kʊ́bɔnɩ́ sɩsɩ ɖɩ́bɔɔzɩ nya sɩsɩ ɖaḿ wenkí-daá gɛ ɩmʊ́ sɩ iɖi Fɛlɛ nɖɛ́ɛ-dɛ́ɛ jíńgáárɩ́ ɩ́na ɩwanbaaráa.” ");
INSERT INTO kdh_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Wánwɩlɩ́ɩ mɩ́ɩ ɖaḿ kʊ́bɔńgɩ nakɩ́rɩ bísa-daá báńgbɩɩrɩ kɩ. Ńna gɛ ɩgbɩ́ɩ́rɩ ɖáa jíńgáárɩ́.» ");
INSERT INTO kdh_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bɛɛɖɛ́ɛ, ngɛ baagána wenbí nɔ́ɔ́ wɔɔdɔ́ wɛ nɛ́; ngɛ baagbɩ́ɩ́rɩ kɩ. ");
INSERT INTO kdh_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kíɖíím ɖíi alɩwáátɩ waadála nɛ́, ngɛ Yeésu na ɩdɛ́ɛ tɩndɩnáa boobó bɔcɔ́ɔ sɩ beɖi. ");
INSERT INTO kdh_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ngɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Máábá mɔzɔ́ɔ́lɩ sɩsɩ meɖi Fɛlɛ nɖɛ́ɛ-dɛ́ɛ jíńgáárɩ́ kɩna mána mɩ́ɩ naanɩ́ mana naazɩrɛ. ");
INSERT INTO kdh_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Káma, ménveerím mɩ́ɩ sɩsɩ módóndokúti meɖi kɩ hálɩ wenbí bʊrɔ bénɖíi kɩ nɛ́ ɩkɔ́nɩ bikógoodi Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-daá.» ");
INSERT INTO kdh_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Bʊwɔ́rɔ́ nɛ́, ngɛ wɔɔgbɔ́ɔ sʊlʊ́m na kagbɔ́ɔ, waazá Ɩsɔ́ɔ nɛ́, ngɛ wɔɔdɔ́ sɩsɩ: «Ɩmʊ sʊlʊ́m bɩna ɩnyɔ́ɔ ɩka ɖamá. ");
INSERT INTO kdh_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Káma, ménveerím mɩ́ɩ sɩsɩ módóndokúti mɔnyɔ́ɔ sʊlʊ́m hálɩ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ ɩtála.» ");
INSERT INTO kdh_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ngɛ wɔɔgbɔ́ɔ kpɔ́nɔ́. Waazá Ɩsɔ́ɔ kɩrɔ bɩtɛ́ nɛ́, ngɛ wɛɛbɛlɩ́ kɩ icéle wɛ ɩtɔ́ sɩsɩ: «Kpɔ́nɔ́ kɩna kɩgɛ́ɛ na mɛ́dɛ́ɛ tɔnʊʊ́ wenkí sɩ malá kɩ sarɔ́ɔ mɩ́rɔ́ɔ́zɩ́ nɛ́. Ɩlá bɩlɛ́ na ɩtɔ́ɔ́zɩ mɔ́rɔ́.» ");
INSERT INTO kdh_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Beeɖi kíɖíím bɩtɛ́ nɛ́, ngɛ wɔɔgbɔ́ɔ sʊlʊ́m na kagbɔ́ɔ ɩtálaḿ bɩlɛ́ ɖʊɖɔ icéle wɛ ɩtɔ́ sɩsɩ: «Sʊlʊ́m bɩna bɩgɛ́ɛ na keɖiyá kɩ́falɔɔ́ Ɩsɔ́ɔ sɩ iɖi kɛ ɩ́na ɩzamɔ́ɔ nɛ́. Bɩgɛ́ɛ na mɛ́dɛ́ɛ azimá sɩ abɩ́rɩ adɛ mɩ́rɔ́ɔ́zɩ́ nɛ́. Azimá amʊ́ sɩ ayele ná na keɖiyá kɛḿ katá. ");
INSERT INTO kdh_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Amá, ɩbɛ́ɛ, weení sɩ ɩyá ma nɛ́ wɛ wénɖíi kíɖíím cé mána yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ɩrʊ́ Biyaalʊ́ wánzɩ́m ńŋɩnáa Ɩsɔ́ɔ waazɩ́ɩ́zɩ bɩ nɛ́, amá, nbusú na weení sɩ ɩyá yɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ngɛ baabáázɩ ɖamá bɔɔzɩ́ na batɩlɩ́ badaá weení sɩ ɩlá bɩlɛ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Wanbaaráa ɩbá bɔwɛ bónÿoó beriké bánjáádɩ sɩ batɩlɩ́ badaá weení ɩgɛ́ɛ kʊ́bɔnɩ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ńna gɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Yíriwá-dɛ́ɛ wúrowá wánnaazɩ́ bɛdɛ́ɛ ɩráa gɛ, bɩka wenbá bɔwɛná yíko ɩráa-rɔ nɛ́ sɔɔlɛ́ɛ bayáa wɛ sɩsɩ kazɔ́ɔ lanɖáa. ");
INSERT INTO kdh_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Amá, mɩ́nyɔ́ɔ́ nɛ́, bɩdɔbɔ́ɔ́zɩ bɩlɛ́ mɩ́lɔ́wʊ́táá. Mɩ́dáá weení ɩgɛ́ɛ kʊ́bɔnɩ́ nɛ́, ɩ́bɩsɩ nyazɩ kúmuú, bɩka weení ɩgɛ́ɛ nɩ́baadɛɛrʊ́ nɛ́ ɩbɩ́sɩ nyazɩ bɔwʊtá-dʊ́ʊ. ");
INSERT INTO kdh_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Káma, weení ɩjɔɔ́ɔ bɔ́ngɔnáa yɩ kíɖíím nɛ́, na weení wɔ́ngɔnáa kíɖíím nɛ́ bɔlɔwʊtáá, weení gɛ kʊ́bɔnɩ́. Bɩdɛkɛ́ɛ weení ɩjɔɔ́ɔ bɩka bɔ́ngɔnáa yɩ kíɖíím nɛ́? Ngʊ́ mɔ́ɔ́ nɛ́, mɔ́wɛ mɩ́lɔ́wʊ́táá gɛ nyazɩ weení wɔ́ngɔnáa kíɖíím nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Mɩ́nyɔ́ɔ́ nɛ́, mɩ́ɩ́ɖɔ́kɩ mɩ́dɩ ɩcɔɔná ma nɔwɛ́yawá mááná tɩ nɛ́ tɩdaá. ");
INSERT INTO kdh_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Bʊrɔɔzɩ́ gɛ ńŋɩnáa Majaa weejéle ma kowúrɔ́ɔ nɛ́, mɔ́ɔ́ ɖʊɖɔ ménjelíi mɩ́ɩ kɛ. ");
INSERT INTO kdh_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Na ɩkɔ́nɩ iɖi ɩnyɔ́ɔ mána mɩ́ɩ mɛ́dɛ́ɛ kowúrɔ́ɔ-daá, bɩka ɩcɔ́ɔ kowuro-gbelásɩ-rɔ ɩfʊʊná Israyɛ́ɛlɩ agó fuú na náálɛ tɔ́m.» ");
INSERT INTO kdh_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yeésu weevééri Simɔ́ɔnɩ sɩsɩ: «Simɔ́ɔnɩ, Simɔ́ɔnɩ, Sitáánɩ wɔɔbɔ́ɔ́zɩ sɩsɩ béyele yɩ na ɩcaádɩ mɩ́ɩ nyazɩ bánjaádɩ bilée na balɩzɩ́ fúti nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Amá, máázʊ́lʊ nyɔ́rɔ́ɔ́zɩ́ na ńkɛbɛ́ɖɩ nyɛ́dɛ́ɛ toovonúm nyáává ma kɩ nɛ́. Bɩlɛ́ nɛ́, a nyáagábɩsɩ mɔ́jɔ́, kpaazɩ ngoobíya ɖóni.» ");
INSERT INTO kdh_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ngɛ Pétro woobúsi yɩ sɩsɩ: «Ɖádʊ́ʊ, mɔ́ɔ́ mázɩ́ŋɛ́ɛ sɩsɩ a sáráka ya, a ngʊ́ sɩ́m ya, mána nya ɖónboɖé.» ");
INSERT INTO kdh_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ngɛ Yeésu wɔɔdɔ́ yɩ sɩsɩ: «Pétro, ménveerím nya sɩsɩ sinje kɩna, kalɩńbaawʊ́ tatanbɔɔ tá gɛ sɩ njɔ́ɔ́lɩ bʊrɔ nabúdoozo sɩsɩ nyáásɩ ma.» ");
INSERT INTO kdh_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ngɛ Yeésu wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «Méédíri mɩ́ɩ mɩ́dɔɖɔ́kɩ liideé, cáńfáná furuú yáá takaḿwá nɛ́, nabʊ́rʊ waagála mɩ́ɩ takáásɩ́?» Ngɛ boobúsi yɩ sɩsɩ: «Aayɩ́». ");
INSERT INTO kdh_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ngɛ wɔɔdɔ́ wɛ sɩsɩ: «Tɔ́ɔ, lɛlɛɛɖɔ́ nɛ́, weení ɩwɛná liideé nɛ́, ɩkpɔ́ɔ yɛ, bɩlɛ́ ɖʊɖɔ gɛ weení ɩwɛná furuú nɛ́ ɩ́kpɔɔ kɩ; ngɛ weení ɩvɛ́yɩ́na sɔɔ́ tókobí nɛ́, bʊdʊ́ʊ ɩyá ɩdɛ́ɛ kpáyɩ ɩmʊ kʊ́ɖʊmɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Káma, ménveerím mɩ́ɩ sɩsɩ tɔ́m tɩna baaŋmáa tɩ Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá nɛ́, bɩmɔɔ́na tikóódi méweezuú-daá. Tɩlɛ́ gɛ sɩsɩ: “Baagála yɩ baɖʊ wenbá bánlám bɩdaavé nɛ́ badaá.” Káma, wentí tɩgɛ́ɛ mɛ́dɛ́ɛ ńdɩ nɛ́, asée tiigóódi.» ");
INSERT INTO kdh_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ngɛ wanbaaráa sɩsɩ: «Ɖádʊ́ʊ, bɛɛ tókobíwá natɩ́lɛ.» Ngɛ woobúsi wɛ sɩsɩ: «Bɩɩmɔ́ɔ bɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yeésu waalɩ́ɩ ibó Olivíyée tɩ́ɩ́nɩ bʊ́ʊ-daá ńŋɩnáa bɩdɛ́rɛ́gɛ́ɛ ɩdɛ́ɛ ɖɔ́ɔ́ná nɛ́. Ngɛ ɩwanbaaráa woovu yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Waadála ńnaamʊ́ nɛ́, ngɛ wɔɔdɔ́ wɛ sɩsɩ: «Ɩzʊ́lʊ na ɩ́kasála Sitáánɩ-dɛ́ɛ kɔdɔ́sɩ-daá.» ");
INSERT INTO kdh_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ngɛ waalɩ́ɩ bɔjɔ́ itúu kpɔ́mɔ́ɔ́ nyazɩ báta bɔlɔ bʊ́ʊ́rɛ ɖɩsála ɖɩdáarɛ ɩká ɩɖʊná-rɔ wánzʊlʊ́ʊ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«Majaa, a nyéndisí, laná ma bolíni na wahála kagbɔ́ɔ kana. Amá, bɩ́kalá wenbí mɔ́zɔɔlɛ́ɛ nɛ́, nyɛ́dɛ́ɛ sɔɔlɩ́m ɩ́la ná.»  ");
INSERT INTO kdh_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Bɩdɛ́ɛ sáátɩ gɛ ɩsɔ́ɔ́dáá malááyɩ́ka naárʊ waaɖʊ ɩlɩ́ɩ ɩjɔ́ ɩkpáázɩ yɩ ɖóni. ");
INSERT INTO kdh_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ɩlaakáarɩ waabá bɩkʊrʊ́ nɛ́, waadásɩ ɩbá ɩlɔɔná sʊlʊ́ʊ, ngɛ ɩdɛ́ɛ fifíni waabɩ́sɩ nyazɩ azimá bɩlɛ́ bíndosí adɛ. ");
INSERT INTO kdh_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Waazʊ́lʊ bɩlɛ́ bɩtɛ́ nɛ́, ngɛ waagʊrʊ́ ɩkábɩsɩ wanbaaráa-jɔ́ ɩmɔɔná bɛlɛ́ bónɖóm ɖúkúru ɖóm. ");
INSERT INTO kdh_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ngɛ wɔɔdɔ́ wɛ sɩsɩ: «Ngbaalá gɛ mínɖóm. Ɩgʊrʊ́ bɩka ɩsʊ́lʊ na ɩ́kasála Sitáánɩ-dɛ́ɛ kɔdɔ́sɩ-daá.» ");
INSERT INTO kdh_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ɩbamáa ŋmatɩrɛ gɛ zamɔ́ɔ nakɩ́rɩ waaɖʊ kɩlɩ́ɩ; bɩka fuú na nɔɔ́lɛ-daá ńnɩ́ weení bánvʊnÿaá yɩ sɩsɩ Yudásɩ nɛ́, kɛdɛ́ɛ kɩ nɩ́bááwʊ. Yudásɩ ɩmʊ́ woogóduu Yeésu-jɔ́ ɩsɛ́ɛ yɩ ikpíriki yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ńna gɛ Yeésu wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Yudásɩ, nyéngbirikí Ɩrʊ́ Biyaalʊ́ gɛ na nÿá yɩ?» ");
INSERT INTO kdh_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Wenbá bavʊnwɛ bána Yeésu nɛ́ baana wenbí sɩ bɩlá nɛ́, ngɛ bɔɔbɔ́ɔ́zɩ Yeésu sɩsɩ: «Ɖádʊ́ʊ, ɖɩ́cɛsɩ wɛ tókobí?» ");
INSERT INTO kdh_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ngɛ badaá kʊ́ɖʊḿ wɛɛjɛ́sɩ sarásɩ lanɖʊ́ kʊ́bɔnɩ́-dɛ́ɛ bɔwʊtá-dʊ́ʊ bɩcɛ́ ɩlɛ́ ɩnɩgbamʊʊ́ kíɖiiwú. ");
INSERT INTO kdh_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Amá, Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Iyéle, bɩɩmɔ́ɔ bɩlɛ́.» Ngɛ weedekiná ɩrʊ́ ɩmʊ́ ɩnɩgbamʊʊ́ ɩwáázɩ yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ngɛ wɔɔdɔ́ sarásɩ lanɖáa kʊ́bɔnáa, na Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-rɔ fereɖáa-dɛ́ɛ kʊ́bɔnáa na tɛ́ɛ́dɩ-daá kʊ́bɔnáa bɔɔgɔ́nɩ ɩwɔ́rɔ́ nɛ́ sɩsɩ: «Mɛ́gɛ́ɛ ŋmɩɩlʊ́ yáá we-rɔ gɛ mɩ́ɩgágʊ́rʊ́ mɔ́wɔ́rɔ́ mɩ́gana tókobíwá na ɖáázɩ bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mávʊ́nna mɩ́ɩ gɛ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá báa wɩ́rɛ wenɖé, ngɛ mɩ́dákpá ma. Amá, tɔ́ɔ, lɛlɛɛɖɔ́ nɛ́, mɩ́dɛ́ɛ alɩwáátɩ na temenuú-dɛ́ɛ yíko waadala ná.» ");
INSERT INTO kdh_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Baagba Yeésu nɛ́, ngɛ booboná yɩ Ɩsɔ́ɔ sarásɩ lanɖáa rɩ́ŋa-dɛ́ɛ kʊ́bɔnɩ́-dɛ́ɛ ɖaána-daá. Pétro kɔwɛ bolíni igovóo wɛ. ");
INSERT INTO kdh_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Baaɖʊ nimíni tɔ́ɔ lɔwʊ́rɛ betí bɔcɔ́ɔ balára bamɩlɩná yɩ nɛ́, ngɛ Pétro wɔɔgɔ́nɩ ɩcɔ́ɔ bɔlɔwʊtáá. ");
INSERT INTO kdh_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Alʊ́ bɔwʊtá-dʊ́ʊ naárʊ waana yɩ ɩjɔɔ́ɔ nimíni-jɔ́ nɛ́, woozúu yɩ ɩzɩ́rɛ tíḿḿ, ngɛ wɔɔdɔ́ sɩsɩ: «Ceení ɖʊɖɔ fʊngana yɩ gɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ngɛ Pétro wɔɔjɔ́ɔ́lɩ ɩtɔ́ sɩsɩ: «Aayɩ́ yoo ɖɔ́gɔɔ, máásɩ yɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Bɩɩdásɩ cʊ́kɔ nɛ́, naárʊ waana yɩ nɛ́, wɔɔdɔ́ yɩ sɩsɩ: «Nyɔ́ɔ́ ɖʊɖɔ nyɔ́wɛ ɩráa bɛḿ badaá.» Amá, Pétro woobúsi ɩrʊ́ ɩmʊ́ sɩsɩ: «Aayɩ́ yoo, mɛ́vɛ́yɩ́ badaá.» ");
INSERT INTO kdh_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Bɩlɛ́ bʊwɔ́rɔ́, bɩɩlá nyazɩ áwa kʊ́ɖʊmʊ́ʊ nɛ́, naárʊ ɖʊɖɔ waadábaazɩ tɩ ɖʊɖɔ na ɖóni sɩsɩ: «Ceení ɖɔ́ ɩbá ɩgɛ́ɛ badaá naárʊ gɛ, káma, Galilée ńnɩ́ gɛ ɩgɛ́ɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ngɛ Pétro woobúsi sɩsɩ: «Bʊbɔ́tɩ gɛ, máátanzɩ wentí nyánŋmatɩ́ tɩ ɖɔ́ nɛ́.» Ɩbamáa ŋmatɩrɛ bɩlɛ́ ɩdatanzum tá gɛ kalɩńbaawʊ́ wɔɔbɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ńna gɛ Ɖádʊ́ʊ wɛɛgɛ́ɛ́zɩ ɩkɛ́bɛ́ɛŋ Pétro. Ngɛ Pétro wɔɔdɔ́ɔ́zɩ tɔ́m wentí Ɖádʊ́ʊ waavʊ́ńveeri yɩ tɩ nɛ́ sɩsɩ: «Naanɩ́ kalɩńbaawʊ́ ɩbɔ́ɔ sinje nɛ́, nyéngizíi ma hálɩ bʊrɔ nabúdoozo.» ");
INSERT INTO kdh_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ngɛ waalɩ́ɩ asʊ ɩbá iwíi páá. ");
INSERT INTO kdh_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Sɔ́ɔ́jawá baazɩ́ɩ wɛ bénveríi Yeésu nɛ́ wɛ bánmʊŋɛ́ yɩ bɩka bánmám yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Boovu waazá-rɔ bɩka bɔ́nbɔɔzɩ́ yɩ sɩsɩ: «Tɩrɩkɩ, weení waama ná nya.» ");
INSERT INTO kdh_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Bɩka babá bándʊ́ʊ́dɩ yɩ kʊdʊ́ʊ́nɩ ndɩ‑ndɩ. ");
INSERT INTO kdh_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tɛ́ɛ́wʊ weevé nɛ́, ngɛ Ɩsɔ́ɔ sarásɩ lanɖáa-dɛ́ɛ kʊ́bɔnáa na Mará wɩlɩɖáa na Yahúúɖuwá-dɛ́ɛ kʊ́bɔnáa baaganáa woodúúzi. Ngɛ bɔɔgɔ́gɔ́ná Yeésu bɛdɛ́ɛ tɔmvʊʊráa kʊ́bɔnáa-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ngɛ bɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Nyɔ́ɔ́ gɛ Lɛɛrʊ́? Feeri ɖáa.» Ngɛ woobúsi wɛ sɩsɩ: «A méévééri mɩ́ɩ sɩsɩ bɩlɛ́ gɛ bɩgɛ́ɛ, bɩdɛkɛ́ɛ sɩ ɩfa ma toovonúm. ");
INSERT INTO kdh_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ngʊ́ a mɔ́ɔ́bɔ́ɔ́zɩ mɩ́ɩ, bɩdɛkɛ́ɛ sɩ ibúsi ma. ");
INSERT INTO kdh_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Amá, kpɔɔná lɛlɛɛɖɔ́, Ɩrʊ́ Biyaalʊ́ wɔ́njɔwʊ́ʊ Ɩsɔ́ɔ yíko-dʊ́ʊ-dɛ́ɛ nʊ́ʊ́nɩ kíɖiiwú-rɔ.» ");
INSERT INTO kdh_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ńna gɛ barɩ́ŋa bɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «A bɩlɛ́, nyɔ́ɔ́ gɛ Ɩsɔ́ɔ Biyaalʊ́?» Ngɛ woobúsi wɛ sɩsɩ: «Ńŋɩnáa wenbí mɩ́ɩ́ŋmátɩ nɛ́, bɩlɛ́ gɛ mɛ́gɛ́ɛ.» ");
INSERT INTO kdh_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ngɛ bɔɔdɔ́ sɩsɩ: «Ɖóógúti ɖánjáádɩ seríya wenkí ɖʊɖɔ, káma, ɖádɩtɩŋa ɖáánɩ́ɩ ɩdɩtɩŋa ɩnɔɔ́-daá.» ");
INSERT INTO kdh_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Barɩ́ŋa booyóózi bakʊrʊ́, bɔkpɔ́ɔ Yeésu boboná Piláatɩ-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Baadála ńna nɛ́, ngɛ baabáázɩ yɩ tɔ́mwá ndɩ‑ndɩ buunáa sɩsɩ: «Ɖáágbá ɩrʊ́ ceení ɩbamáa ɖɛ́dɛ́ɛ zamɔ́ɔ tɛlɛ́sɩ sɩsɩ kɩ́kʊrʊ́na nɩ́baadɛɛráa, wéngizináa ɩráa sɩsɩ bɛ́kɛfɛrɛ Róóma wúro kʊ́bɔnɩ́ lanpóo, bɩka wɔ́ndɔ́m ɩdɩ sɩsɩ ɩmʊ́ gɛ Lɛɛrʊ́, sɩsɩ ɩmʊ́ gɛ wúro.» ");
INSERT INTO kdh_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Bɩnáábɩ́lɛ́ Piláatɩ wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Nyɔ́ɔ́ gɛ Yahúúɖuwá-dɛ́ɛ wúro?» Ngɛ Yeésu woobúsi yɩ sɩsɩ: «Tɩnáábɩ́lɛ́ nyɔ́ɔ́dɔ́ ɖɔ́.» ");
INSERT INTO kdh_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ngɛ Piláatɩ wɔɔdɔ́ Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa na zamɔ́ɔ sɩsɩ: «Mádáná taalɩ́ nakɩ́rɩ kɩ́nbɩɩzɩ́ kiyéle bakʊ ɩrʊ́ ceení-dɛ́ɛ tɔ́m nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Amá, baabá bazɩ́ŋɛ́ɛ bɩjaarɛ́ɛ bɔ́ndɔ́m sɩsɩ: «Ɩdɛ́ɛ wɩlɩ́ɩ-daá, wóndulúsi ɩráa. Galilée gɛ waagábaazɩná, ɩkɔ́nɩ ɩsʊ́ʊ Yudée laadɔ́ɔ rɩ́ŋa-daá hálɩ ɩtála cé ɖɔ́.» ");
INSERT INTO kdh_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Piláatɩ waanɩ́ɩ bɩlɛ́ nɛ́, ngɛ wɔɔbɔ́ɔ́zɩ sɩsɩ: «Ɩrʊ́ ɩmʊ́ ɩgɛ́ɛ Galilée ńnɩ́ gɛ?» ");
INSERT INTO kdh_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Wooyuú ɩtɩlɩ́ sɩsɩ Yeésu kɛ́ɛ laadɔ́ɔ Eróodi wénɖíi kowúrɔ́ɔ kɔrɔ nɛ́-dɛ́ɛ ɩrʊ́ nɛ́, ngɛ weeyéle boboná yɩ Eróodi-jɔ́. Káma, bɩdɛ́ɛ sáátɩ kɩḿ nɛ́, Eróodi wáńgágbáa Yerusalɛ́ɛm. ");
INSERT INTO kdh_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Eróodi waana Yeésu nɛ́, ngɛ bɩɩbá bɩlá yɩ niíni ɖabata, káma, ɖoo bɩrɩ́ŋa bɩlɛ́, wánjáádɩ sɩsɩ ɩna Yeésu wentí wánnɩɩ́ bánŋmatɩ́ ɩrɔ nɛ́-rɔɔzɩ́, ngɛ ɩdɛ́ɛ tamɔ́ɔ wɛ sɩsɩ ɩna Yeésu ɩlá maamááci nakɩ́rɩ. ");
INSERT INTO kdh_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Waabá ɩbɔ́ɔ́zɩ yɩ tɔ́mwá ɖabata, amá, Yeésu tobúsi yɩ báa natɩ́rɩ. ");
INSERT INTO kdh_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa na Mará wɩlɩɖáa fʊnwɛ ńna bɩka babá bónbuunáa yɩ tɔ́mwá na baaná. ");
INSERT INTO kdh_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Eróodi na ɩdɛ́ɛ sɔ́ɔ́jawá bénveríi ɩrɔ nɛ́, baabá bɛkpɛɛná Yeésu bɩka bamʊ́ŋɩ yɩ. Bʊwɔ́rɔ́ nɛ́, ngɛ boozúu yɩ jaba kífeńgi nakɩ́rɩ, ngɛ weeyéle babɩsɩná yɩ Piláatɩ-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Bɩdɛ́ɛ wɩ́rɛ ɖɩḿ gɛ Piláatɩ na Eróodi baabɩ́sɩ ɖɔndɩnáa, bɛḿ wenbá ɖoo bavʊngɛ́ɛ báɖaanáa nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Piláatɩ woodúúzi Ɩsɔ́ɔ sarásɩ lanɖáa kʊ́bɔnáa na wúrowá na zamɔ́ɔ, ");
INSERT INTO kdh_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ngɛ wɔɔdɔ́ wɛ sɩsɩ: «Mɩ́ɩ́gɔ́ná ma ɩrʊ́ ceení sɩsɩ wɛ́ndɛlɛ́sɩ zamɔ́ɔ sɩsɩ kɩ́kʊrʊ́na nɩ́baadɛɛráa, ngʊ́ mɔ́ɔ́bɔ́ɔ́zɩ yɩ tɔ́mwá mɩ́ɩ́zá-daá cé nɛ́, mádáná taalɩ́ nakɩ́rɩ kɩ́ngʊ́ʊ ɩdɔ́m wentí mɩ́ɩ́ŋmátɩ nɛ́ tɩdaá. ");
INSERT INTO kdh_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Eróodi ɖʊɖɔ takáná na yɩ nabʊ́rʊ, káma, weeyéle bakábɩ́sɩ́ná ɖáa yɩ. Bɩlɛ́ nɛ́, ɩdalá nabʊ́rʊ bɩ́nbɔɔzɩ́ bakʊ yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Bʊrɔɔzɩ́ nɛ́, ménÿelíi bosúti yɩ agbáázá na bʊwɔ́rɔ́ nɛ́ madálɩ yɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Jíńgáárɩ́ báa wenkí asée Piláatɩ wɛɛjɛ́ wɛ sáráka-dʊ́ʊ kʊ́ɖʊḿ. ");
INSERT INTO kdh_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Barɩ́ŋa booyóózi bóngoó sɩsɩ: «Bákʊ́ ɩrʊ́ ceení bɩka bɛcɛ́ ɖáa Barabáasɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabáasɩ ɩmʊ́ nɛ́, sáátɩ wenkí ɩráa waagʊrʊ́na gómínantɩ nɛ́, bɩdaá gɛ waagʊ ɩrʊ́; biiyéle baagba yɩ bɔtɔ sáráka. ");
INSERT INTO kdh_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ńŋɩnáa Piláatɩ wɔɔzɔ́ɔ́lɩ sɩ ɩcɛ́ Yeésu nɛ́, waadábaazɩ zamɔ́ɔ tɔ́m bɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Amá, bɛlɛ́ baadásɩ gɛ bóngoó sɩsɩ: «Ka yɩ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ! Ka yɩ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ!» ");
INSERT INTO kdh_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ngɛ Piláatɩ waadábaazɩ wɛ bɔɔɔzɩ́ toozo-dɛ́ɛ sɩsɩ: «Taalɩ́ wenkí gɛ waabá ɩlá. Mádábá mana taalɩ́ nakɩ́rɩ ɩrɔ kɩ́nbɔɔzɩ́ sɩsɩ bákʊ́ yɩ nɛ́. Bɩlɛ́ nɛ́, ménÿelíi bosúti yɩ agbáázá bɩka madálɩ yɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Amá, bɛlɛ́ baabá bazɩ́ŋɛ́ɛ bɩjaarɛ́ɛ na agogo kʊ́bɔná bɔ́nbɔɔzɩ́ sɩsɩ báka yɩ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ, hálɩ bɛdɛ́ɛ agogo wɛɛdɛ́ abɩ́ɩ́zɩ Piláatɩ. ");
INSERT INTO kdh_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Biiyéle Piláatɩ ɩsɩ́ɩ́zɩ sɩsɩ wánlám wenbí bɔɔbɔ́ɔ́zɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Wɛɛjɛ́ weení bɔɔdɔ yɩ sáráka, káma, baagʊrʊ́na gómínantɩ bɩka ɩkʊ ɩrʊ́ bɩdaá ngɛ bɔ́nbɔɔzɩ́ ɩdɛ́ɛ cɛ́m nɛ́, bɩka icéle wɛ Yeésu sɩsɩ báláná yɩ wenbí bɔzɔɔlɛ́ɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Baalɩ́ɩ bɛ́nɖɛɛnáa Yeésu nɛ́, baana abaalʊ́ naárʊ bánÿaá yɩ sɩsɩ Simɔ́ɔnɩ, wáńgálɩɩná fɔɔ́. Ɩgɛ́ɛ Sirɛ́ɛnɩ tɛ́ɛ́dɩ-daá ńnɩ́ gɛ. Ngɛ baagba yɩ basʊ́ʊ yɩ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ ɩtɩ́nɩ Yeésu wɔ́rɔ́. ");
INSERT INTO kdh_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Zamɔ́ɔ tuutúúma fóo yɩ bɩkpɛdɩ́na aláa, bɩka aláa bɛḿ bénwií bɛ́nmɛɛdɩ́ ɩrɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ngɛ Yeésu wɛɛgɛ́ɛ́zɩ ɩbɛ́ɛ́ŋ wɛ ɩtɔ́ wɛ sɩsɩ: «Yerusalɛ́ɛm aláa, íkewíi mɔ́rɔ́, amá, iwíi mɩ́na míbíya mɩ́rɔ́. ");
INSERT INTO kdh_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Káma, wɛ́ naárɛ kɛgɛrɛŋɛ, ngɛ wɛ́ amʊ́ adaá nɛ́, sɩ bɔtɔ́ gɛ sɩsɩ: “Wenbi‑niíni-dɩnáa gɛ aláa kaalʊrʊ́sɩ; wenbi‑niíni-dɩnáa gɛ wenbá badalʊ́rʊ bana yáá bíya tamʊ́zʊ wɛ nɛ́.” ");
INSERT INTO kdh_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Bɩdɛ́ɛ sáátɩ kɩḿ, bɔ́ndɔ́m bʊ́ʊ́nɩ sɩsɩ: “Bʊ́ʊ́nɩ, ɩzála ɖɔ́rɔ́.” Bɩka bɔtɔ́ buuronísi sɩsɩ: “Buuronísi, ɩbála ifu ɖɔ́rɔ́.” ");
INSERT INTO kdh_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Káma, a bánlám tɩɩwʊ́ lɩ́m ńgɩ ńŋɩnáa ɖɔ́, wenkí kɩ́ńwɩ́lɩ́ nɛ́, nŋɩ́nɩ́ gɛ sɩ balá kɩlɛ́ bɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Bɛ́nɖɛɛnáa ɩráa kɩdaavéénínáa nɔɔ́lɛ ɖʊɖɔ sɩ bakágʊ́ wɛ bána Yeésu. ");
INSERT INTO kdh_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Baadála ɖɩdáarɛ bánÿaá ɖɛ sɩsɩ Kʊjʊʊ́ Bɔɔrɔɔ́ nɛ́, ngɛ baagá yɩ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ ńna. Ngɛ baagá ɖʊɖɔ ɩráa kɩdaavéénínáa bɛḿ bɛlɛ́ɛ́nɩ́ ɖáázɩ abɛlɩ́ akɔ́ɔ-rɔ: kʊ́ɖʊḿ, ɩdɛ́ɛ nʊ́ʊ́nɩ kíɖiiwú-rɔ, waaganáa, ɩdɛ́ɛ nʊ́ʊ́nɩ nɩbɩɩwʊ́-rɔ. ");
INSERT INTO kdh_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ńna gɛ Yeésu waaŋmátɩ sɩsɩ: «Baabá, cɛ wɛ káma, baasɩ wenbí bánlám nɛ́.» Ngɛ bɔɔdɔ tɛ́tɛ́ ɩgbɩná-rɔ batára yɛ ɖamá. ");
INSERT INTO kdh_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Zamɔ́ɔ wɛ kɩzɩ́ŋɛ́ɛ ńna kɩbɛɛ́na, bɩka Yahúúɖuwá-dɛ́ɛ wúrowá bɛlɛ́ bɔwɛ bánmʊŋ́ yɩ bɔ́ndɔ́m sɩsɩ: «Wɛɛlɛ́ɛ baaganáa nɛ́, ɩ́kʊ́ ɩlɛ́ɛ ɩdɩ a toovonúm ɩgɛ́ɛ Lɛɛrʊ́, a ɩmʊ́ gɛ Ɩsɔ́ɔ waalɩzɩ́.» ");
INSERT INTO kdh_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sɔ́ɔ́jawá ɖʊɖɔ wɛ bánmʊŋɛ́ yɩ. Ngɛ boogóduu ɩjɔ́ becéle yɩ sʊlʊ́m nyɩ́gáázɩ ńbɩ, ");
INSERT INTO kdh_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","bɔ́ndɔ́m yɩ sɩsɩ: «A nyɛ́gɛ́ɛ Yahúúɖuwá-dɛ́ɛ wúro, nyádɩtɩŋa lɛɛ nyádɩ!» ");
INSERT INTO kdh_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ngɛ baaŋmáa tɔ́m bíya bana ɖɔ́ kpálɩfɔ́ɔ-rɔ bosúsi ɩgʊjʊʊ́-rɔ sɩsɩ: «Ceení gɛ Yahúúɖuwá-dɛ́ɛ wúro.» ");
INSERT INTO kdh_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kɩdaavéénínáa baagá wɛ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ nɛ́, badaá naárʊ wándʊ́ʊ́dɩ yɩ sɩsɩ: «Mányɩ sɩsɩ nyɛ́gɛ́ɛ Lɛɛrʊ́ gɛ. Lɛɛ nyádɩ bɩka nlɛ́ɛ ɖɔ́ɔ́ ɖʊɖɔ!» ");
INSERT INTO kdh_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Amá, waaganáa wooyooná yɩ sɩsɩ: «Nyɔ́ɔ́ weení bɔ́nvɔ́m nyánɩgbamʊʊ́ nyazɩ ɩlɛ́ nɛ́, ńdénzée Ɩsɔ́ɔ? ");
INSERT INTO kdh_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ɖɔ́ɔ́ nɛ́, ɖɛ́dɛ́ɛ nɩgbamʊʊ́ fɔ́m mɔɔ́ɔ, káma, ɖálakásɩ wɔ́nbɔɔzɩ́ wenbí nɛ́ gɛ bánlanáa ɖáa. Amá, ɩlɛ́ ɩdalá taalɩ́ nakɩ́rɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ngɛ wɔɔdɔ́ Yeésu sɩsɩ: «A nyɔ́ɔ́gɔ́nɩ sɩ nɖi kowúrátɩ, la suúru ndɔ́ɔ́zɩ mɔ́rɔ́.» ");
INSERT INTO kdh_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ngɛ Yeésu woobúsi yɩ sɩsɩ: «Ménveerím nya toovonúm sɩsɩ sinje mána nya sɩ ɖɩsʊʊ ná arɩjáńna-daá.» ");
INSERT INTO kdh_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Bɩ́ńgbɛ́dɩ́ bɩlá nyazɩ ɩdaawʊ́ bɩlɛ́, ngɛ adɛ laadɔ́ɔ rɩ́ŋa waalá temenuú hálɩ bɩlá kéréfu natúdoozo ɩdaawʊ́ wɔ́rɔ́. ");
INSERT INTO kdh_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Wɩ́sɩ waalá temenuú, ngɛ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá láámílé waadára nabʊ́lɛ. ");
INSERT INTO kdh_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ngɛ Yeésu woogóo na ɖóni sɩsɩ: «Majaa, mááɖʊ́ méweezuú nyánʊ́ʊ́zɩ-daá.» Wɔɔdɔ́ bɩlɛ́ bɩtɛ́ nɛ́, ngɛ weedísi weezuú ɩsɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Róóma ńba-dɛ́ɛ sɔ́ɔ́ja kʊ́bɔnɩ́ waana wenbí bɩɩlá nɛ́, ngɛ waazá Ɩsɔ́ɔ ɩtɔ́ sɩsɩ: «Toovonúm gɛ, ɩrʊ́ ceení fɛ́yɩ́na yɩsɩ́tɩ!» ");
INSERT INTO kdh_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ɩráa tuutúúma wenbá barɩ́ŋa bɔɔgɔ́nɩ bɛbɛ́ɛ́ŋ wenbí sɩ balaná Yeésu nɛ́, baana bɩlɛ́ nɛ́, bɔɔlɔ́ɔ babɩ́sɩ na ɖúkúru bɩka bénwií. ");
INSERT INTO kdh_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Wenbá barɩ́ŋa ɩ́na wɛ bavʊnnyɩ ɖamá nɛ́, na aláa wenbá boogóvú yɩ ɖoo Galilée nɛ́, bagazɩ́ŋɛ́ɛ bolíni bɛbɛɛ́na wenbí bɩ́nlám nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Yahúúɖuwá-dɛ́ɛ tɔmvʊʊráa-daá ɩrʊ́ naárʊ wɛ bánÿaá yɩ sɩsɩ Ísifu. Ɩrʊ́ ɩmʊ́ ɩgɛ́ɛ ɩrʊ́ kazɔ́ɔ ńnɩ́ gɛ bɩka ɩzɩɩzɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ɩrʊ́ ɩmʊ́ ɩdafʊ́ńdisi wenbí tɔmvʊʊráa-dɛ́ɛ bɔwʊ́ɖɛ waazɩ́ŋ sɩ bánlám nɛ́, ngʊ́ ɩdaɖʊ ɩnɔɔ́ wenbí baalá nɛ́ bɩdaá. Yahúúɖuwá-dɛ́ɛ laadɔ́ɔ-daá tɛ́ɛ́dɩ bánÿaá tɩ sɩsɩ Arɩmatée nɛ́ tɩdɛ́ɛ ɩrʊ́ gɛ ɩgɛ́ɛ, bɩka ɩvʊnɖamáa Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Woobó Piláatɩ-jɔ́ ɩsʊ́lʊ sɩsɩ bécéle yɩ Yeésu tɔnʊʊ́. ");
INSERT INTO kdh_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ngɛ waagálɩ́zɩ́ yɩ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ ikédisi, isúu yɩ kásáŋá iboná yɩ ɩfɩ́ɩ́zɩ bɔɔlááwʊ baabáa kɩ bʊ́tangbalʊʊ́-daá bɩka bedebim tá báa naárʊ kɩdaá nɛ́, kɩdaá. ");
INSERT INTO kdh_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Bɩgɛ́ɛ na wɩ́rɛ wenɖé bángbɩɩrɩ́ Fɛɛzɩrɛ wɩ́rɛ nɛ́, bɩka Fɛɛzɩrɛ wɩ́rɛ ɖɩḿ ɖɩ́ńgbɛ́dɩ́ ɖɩ́nbaazɩ́ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Aláa wenbá boogóvú Yeésu ɖoo Galilée nɛ́ baadɩ́nɩ Ísifu wɔ́rɔ́. Baana bɔɔlááwʊ, na nŋɩ́nɩ́ baavɩ́ɩ́zɩ Yeésu tɔnʊʊ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ngɛ bɔɔlɔ́ɔ babɩ́sɩ tɛ́ɛ́dɩ-daá bakpɩ́ɩ́rɩ núm bínvoorí nɛ́, na tulaarɩ́wá. Ngɛ Fɛɛzɩrɛ wɩ́rɛ nɛ́, bɔɔjɔ́ɔ badalá nabʊ́rʊ ńŋɩnáa Múúsá-dɛ́ɛ Mará waazɩ́ɩ́zɩ bɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Aláháɖɩ wɩ́rɛ tɛ́ɛrɛ́‑tɛ́ɛrɛ́ nɛ́, aláa waalɩ́ɩ bɔkpɔ́ɔ núm bínvoorí baavʊ́ńgbɩ́ɩrɩ nɛ́, ngɛ bɛɛɖɛ́ɛ bɔɔlááwʊ-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Baadála nɛ́, baana sɩsɩ beebiláázɩ bʊ́ʊ́rɛ ɖɩvʊnvóo bɔɔlááwʊ nɔɔ́-rɔ nɛ́ bɔlɔ kpɔ́mɔ́ɔ́. ");
INSERT INTO kdh_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ngɛ baazʊ́ʊ bɔɔlááwʊ-daá nɛ́, badana Ɖádʊ́ʊ Yeésu tɔnʊʊ́. ");
INSERT INTO kdh_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Bɔwɛ bánlám bítí baasɩ wentí-daá bɔwɛ nɛ́, ngɛ ɩráa nɔɔ́lɛ waajáŋ baɖʊ balɩ́ɩ bɔrɔ bozóóna kpɩná ánɖée nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ńna gɛ nɩdáárɛ waabá bɩlá wɛ hálɩ bolúúzi bagʊjʊ́nɩ adɛ, ngɛ ɩráa bɛḿ bɔɔdɔ́ wɛ sɩsɩ: «Ngbaalá gɛ mɩ́njáádɩ weezuú-dʊ́ʊ ɩsɩɖáa lɔwʊtáá. ");
INSERT INTO kdh_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ɩvɛ́yɩ́ cé, weevé ɩlɩ́ɩ ɩsɩɖáa-daá. Ɩdɔ́ɔ́zɩ wentí waavʊ́ńgáŋmatɩ mɩ́ɩ ɖoo sáátɩ ɩgɔwɛ Galilée nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Sɩsɩ: “Bángbáa Ɩrʊ́ Biyaalʊ́ becéle alaháácɩ́-dɩnáa, na bɛlɛ́ baká yɩ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ, na wɛ́ náádoozo wɩ́rɛ nɛ́, ifé ɩlɩ́ɩ ɩsɩɖáa-daá.”» ");
INSERT INTO kdh_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ńna gɛ bɔɔdɔ́ɔ́zɩ tɔ́m tɩḿ tɩrɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ngɛ baalɩ́ɩ bɔɔlááwʊ-jɔ́ bɛɖɛ́ɛ bakádɩ bɩlɛ́ bɩrɩ́ŋa befééri tɩndɩnáa fuú na naárʊ na wanbaaráa baaganáa rɩ́ŋa. ");
INSERT INTO kdh_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Aláa bɛḿ nɖɔ́: Marɩyáma Magɩdaláa alʊ́, na Yuháána, na Marɩyáma Yaakúbu ɩgɔɔ. Aláa baaganáa bána wɛ nɛ́, weevééri tɩndɩnáa tɔ́m tɩḿ tɩrɩ́ŋa ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Amá, tɩndɩnáa bɛlɛ́ baamáázɩ gɛ sɩsɩ aláa bɛḿ bánŋmatɩ́ kʊjʊʊ́ fɛ́yɩ́-dɩnáa-dɛ́ɛ ŋmatɩrɛ gɛ, biiyéle badafa wɛ toovonúm. ");
INSERT INTO kdh_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Amá, na bɩrɩ́ŋa, Pétro waagʊrʊ́ ɩkpɔ́ɔ sewɔ́ɔ ɩɖɛ́ɛ bɔɔlááwʊ-jɔ́. Waadála gɛ woolúúzi ɩdɩ nɛ́, kásáŋá-fɔɔlásɩ gɛ waana adɛ. Ngɛ wɔɔlɔ́ɔ ɩbɩ́sɩ ɩdɛ́ɛ bɩka bɩbá bɩjɔɔ́ɔ yɩ bítí wenbí bɩɩlá nɛ́ bʊrɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ngʊ́ nbɛ́ɛ nɛ́, bɩdɛ́ɛ wɩ́rɛ ɖɩḿ nɔ́ɔ́, wanbaaráa-daá nɔɔ́lɛ waalɩ́ɩ bɛ́nɖɛɛ́ tɛɛbiiyá bánÿaá kɛ sɩsɩ Emayúusi nɛ́ kadaá. Áwa natɩ́lɛ gɛ a ɩrʊ́ waalɩ́ɩ Yerusalɛ́ɛm, wánɖʊ́ʊ na ɩkádála. ");
INSERT INTO kdh_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Wanbaaráa bɛḿ bɔwɛ bánŋmatɩnáa ɖamá wentí tɩrɩ́ŋa tɩɩlá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Babamáa ŋmatɩrɛ bɛ́ngɛɛzɩ́ ɖamá bɛ́nɖɛɛ́ nɛ́, Yeésu tɩtɩŋa wɔɔgɔ́nɩ ɩcʊʊná wɛ ɩ́na wɛ boyóózi bɛ́nɖɛɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Amá, bɩɩdɔ baazá-rɔ badabɩ́ɩ́zɩ batɩlɩ́ yɩ. ");
INSERT INTO kdh_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ngɛ Yeésu wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «Wentí gɛ mɩ́nganʊŋɛ́ bɩka mɩ́ngɛɛzɩ́ ɖamá ye.» Ngɛ baazɩ́ŋ bɩka bɔwɛ ɖúkúru-daá. ");
INSERT INTO kdh_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Badaá weení bánÿaá yɩ sɩsɩ Kilewofáasɩ nɛ́, woobúsi yɩ sɩsɩ: «Yerusalɛ́ɛm ńba rɩ́ŋa-daá nɛ́, nyɔ́ɔ́ nyériké ńdátɩ́lɩ́ na wenbí bɩɩlá wɛ́-bíya bana badaá nɛ́?» ");
INSERT INTO kdh_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ngɛ wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «Ngbetíi waala ná.» Ńna gɛ bɛlɛ́ boobúsi yɩ sɩsɩ: «Wenbí bɩɩmɔɔná Yeésu Nazarɛ́ɛtɩ ńnɩ́ nɛ́. Ɩvʊnbá ɩgɛ́ɛ anɖébi ɩwɛná yíko nɛ́ gɛ Ɩsɔ́ɔ ɩzá-daá na zamɔ́ɔ rɩ́ŋa ɩzá-daá. Waawɩ́lɩ ɩdɛ́ɛ yíko ɩdɛ́ɛ ŋmatɩrɛ na ɩdɛ́ɛ lakásɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ɖɛ́dɛ́ɛ sarásɩ lanɖáa kʊ́bɔnáa na ɖɛ́dɛ́ɛ wúrowá waagba yɩ, bakʊ ɩdɔ́m sɩsɩ bánɖʊ́ʊ yɩ sɩ́m, ngɛ baagá yɩ ɖɛ́nɩ abɛlɩ́ akɔ́ɔ-rɔ. ");
INSERT INTO kdh_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ngʊ́ ɖɔ́ɔ́ ɖáńɖʊ́ʊ tamɔ́ɔ sɩsɩ ɩlɛ́ sɩ ɩlɛɛ ná Israyɛ́ɛlɩ. Amá, bɛɛ sinje wɛ́ náádoozo nɖɔ́ bɩlɛ́ ɩmʊ́ bɩrɩ́ŋa bɩɩlá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Aláa bovóo ɖáa nɛ́, badaá nɛbɛ́rɛ waaɖʊ ɖáa bítí. Bɔɔjɔ́ɔ́rɩ tɛ́ɛrɛ́‑tɛ́ɛrɛ́ bobó bɔɔlááwʊ-jɔ́, ");
INSERT INTO kdh_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ngɛ badakáná ɩdɔnʊʊ́ nɛ́, baagábɩ́sɩ befééri ɖáa sɩsɩ malááyɩ́kawá waaɖʊ baalɩ́ɩ bɔrɔ befééri wɛ sɩsɩ ɩwɛ weezuú-daá. ");
INSERT INTO kdh_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ɖádáá nɛbɛ́rɛ woobó bɔɔlááwʊ-jɔ́, ngɛ wenbí nɔ́ɔ́ aláa waaŋmátɩ nɛ́ gɛ baagáná, amá, ɩmʊ́ ɩdɩtɩŋa nɛ́, badakáná yɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ńna gɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Mɩ́ɩ ɩráa bɛvɛ́yɩ́na tɩlɩ́ɩ bɩka bádánváa wentí anɖébiwá waaŋmátɩ nɛ́ toovonúm ɖasam nɛ́ bana ɖɔ́! ");
INSERT INTO kdh_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Bɩdɛkɛ́ɛ bɩlɛ́ gɛ bɩɩbɔ́ɔ́zɩ sɩsɩ Lɛɛrʊ́ ɩ́na wahála naanɩ́ na ɩsʊ́ʊ ɩdɛ́ɛ ásícé-daá?» ");
INSERT INTO kdh_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ngɛ waalɩzɩ́ wentí tɩrɩ́ŋa baaŋmátɩ Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá tɩgɛ́ɛ ɩdɛ́ɛ ńdɩ nɛ́ tugutoluú wénveerím wɛ. Waagábaazɩ ná Múúsá-dɛ́ɛ ŋmáádɩ hálɩ ɩkɔ́nɩ anɖébiwá rɩ́ŋa-dɛ́ɛ ŋmáádɩ-daá. ");
INSERT INTO kdh_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Sáátɩ wenkí baajʊʊná tɛɛbiiyá wenká kadaá wanbaaráa wɛ́nɖɛɛ́ nɛ́, Yeésu waalá nyazɩ sɩ ɩcɛzɩ́ bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Amá, wanbaaráa waajáárɩ yɩ bɔtɔ́ yɩ sɩsɩ: «Bɛɛ́ɛ, kɩɩgbɛdɩ́ kínÿúu nbɩlɛ́, wɩ́sɩ waazála. Bɩlɛ́ nɛ́ nkɛɖɛ́ɛ, cɔɔ ɖɔ́jɔ́ cé.» Ngɛ weedísi ɩsʊ́ʊ bɔjɔ́ ɩ́na wɛ bɔcɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Sáátɩ wenkí ɩ́na wɛ bɔɔjɔ́ɔ sɩ beɖi kíɖíím nɛ́, wɔɔgbɔ́ɔ kpɔ́nɔ́, ngɛ waazá Ɩsɔ́ɔ kɩrɔ, ngɛ wɛɛbɛlɩ́ kɩ icéle wɛ. ");
INSERT INTO kdh_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ńna gɛ baazá-rɔ weevé batɩlɩ́ yɩ, amá, waajáŋ ɩtɛlɛ́ŋ baazá-daá. ");
INSERT INTO kdh_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ngɛ baabáázɩ ɖamá tɔ́m sɩsɩ: «Ńdáná sɩsɩ bʊrɔ gɛ bɩɩbá bɩgɔjɔɔ́ɔ ɖáa niíni sáátɩ wenkí wángaŋmatɩnáa ɖáa nɩ́bááwʊ-daá bɩka wángalɩzɩ́ɩ ɖáa wentí baaŋmáa Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá nɛ́ tugutoluú nɛ́?» ");
INSERT INTO kdh_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ngɛ baajáŋ bakʊrʊ́ ńna‑ńna babɩ́sɩ Yerusalɛ́ɛm bɔmɔɔná tɩndɩnáa fuú na naárʊ na wenbá bána wɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ngɛ bɛlɛ́ beevééri wɛ sɩsɩ: «Ɖádʊ́ʊ weevé toovonúm. Waalɩzɩ́ ɩdɩ ɩwɩ́lɩ Simɔ́ɔnɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ńna gɛ badɩtɩŋa baabáázɩ wɛ kɛɛzɩ́ wenbí bɩɩlá nɩ́bááwʊ-daá, na nŋɩ́nɩ́ baadɩlɩ́ na yɩ kíɖíím ɖaaɖííɖɛ wɛɛbɛlɩ́ kpɔ́nɔ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Bɔwɛ bánŋmatɩ́ bɩlɛ́ nɛ́ gɛ Yeésu tɩtɩŋa waaɖʊ ɩlɩ́ɩ bɔlɔwʊtáá, ngɛ wɔɔdɔ́ wɛ sɩsɩ: «Fɛɛzɩrɛ ɩ́cɔ́ɔ́ná mɩ́ɩ.» ");
INSERT INTO kdh_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ngɛ bɩɩbá bɩlá wɛ nɩdáárɛ páá, káma, bɔjɔɔ́ɔ sɩsɩ ásɩ́náálɩ́ɩ gɛ. ");
INSERT INTO kdh_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ńna gɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Ngbaalá gɛ biidulúsi mɩ́ɩ bɩlɛ́. Ngɛ ngbaalá gɛ mɩ́nlám síka. ");
INSERT INTO kdh_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ɩbɛ́ɛ mánʊ́ʊ́zɩ na mɔ́nʊvɔ́, mánáábɩ́lɛ́! Idekiná ma na ɩbɛ́ɛ, ásɩ́náálɩ́ɩ fɛ́yɩ́na tɔnʊʊ́, cáńfáná mʊwá ńŋɩnáa mɩ́bɛɛ́na mɔ́wɛná ɖɔ́ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Waaŋmátɩ bɩlɛ́ nɛ́, ngɛ waawɩ́lɩ wɛ ɩnʊ́ʊ́zɩ na ɩnʊvɔ́. ");
INSERT INTO kdh_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Bɩɩbá bɩlá wɛ niíni bɩcɛzɩ́na seríya bɩka bɩjɔɔ́ɔ wɛ bítí hálɩ bádánjaa sɩ bafa toovonúm nɛ́, Yeésu wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ: «Mɩ́wɛná nabʊ́rʊ cé bénɖíi?» ");
INSERT INTO kdh_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ngɛ beejéle yɩ tińɖe fɔɔlɔɔ́ bɔ́ńwɔ́ḿ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ngɛ waamʊ ɖɛ ɩtɔ́ɔ baazá-daá. ");
INSERT INTO kdh_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ngɛ wɔɔdɔ́ wɛ sɩsɩ: «Bɛɛ tɔ́m wentí méévééri mɩ́ɩ tɩ sáátɩ wenkí mána mɩ́ɩ ɖávʊnwɛ nɛ́ nɖɔ́: Bɩmɔɔ́na wentí tɩrɩ́ŋa baaŋmáa mɔ́rɔ́ɔ́zɩ́ Múúsá-dɛ́ɛ Mará tákaraɖá-daá, na anɖébiwá-dɛ́ɛ tákaraɖáwá-daá, na Yéńdiwá-daá nɛ́ ikóódi.» ");
INSERT INTO kdh_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ńna kɩḿ gɛ woovulúsi baazá-rɔ banɩ́ɩ Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá kutoluú. ");
INSERT INTO kdh_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ngɛ wɔɔdɔ́ wɛ sɩsɩ: «Wentí baaŋmáa Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá nɛ́ gɛ sɩsɩ Lɛɛrʊ́ wɔ́ngɔnɩ́ ɩna wahála, na wɛ́ náádoozo wɩ́rɛ nɛ́, ifé ɩlɩ́ɩ ɩsɩɖáa-daá. ");
INSERT INTO kdh_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Na ɩyɩ́ɖɛ-daá nɛ́, bánlám yíriwá rɩ́ŋa waázu sɩsɩ bála túúbá bɛkɛ́ɛ cɔwʊrɛ na Ɩsɔ́ɔ ɩcɛ́ wɛ bɛdɛ́ɛ alaháácɩ́wá, ngɛ Yerusalɛ́ɛm gɛ bɩ́ngabaazɩnáa. ");
INSERT INTO kdh_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mɩ́nyɔ́ɔ́ gɛ bɩdɛ́ɛ seríya-dɩnáa. ");
INSERT INTO kdh_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mɔ́ɔ́ mángaváa mɩ́ɩ wenbí Majaa wooɖúu sɩsɩ wánváa mɩ́ɩ nɛ́. Bɩɩga mɩ́nyɔ́ɔ́ nɛ́, ɩjɔ́ɔ tɛ́ɛ́dɩ-daá hálɩ yíko wenkí sɩ kɩkálɩɩ ɩsɔ́ɔ́dáá nɛ́ kikédi mɩ́rɔ́.» ");
INSERT INTO kdh_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Bʊwɔ́rɔ́ nɛ́, ngɛ Yeésu wɔɔgbɔ́ɔ ɩwanbaaráa iboná tɛɛbiiyá bánÿaá kɛ Betáániya nɛ́ kɔjɔ́. Ngɛ waagbáázɩ ɩnʊ́ʊ́zɩ ɩɖʊ wɛ alɩbáráka. ");
INSERT INTO kdh_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ɩbamáa wɛ alɩbáráka ɖʊ́ʊ nɛ́, ngɛ bɩɩlɩzɩ́ yɩ bɔlɔwʊtáá bɩkpáázɩ yɩ Ɩsɔ́ɔ-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Bɩɩga bɛḿ nɛ́, boogúu yɩ tɛ́ɛ́dɩ bɩtɛ́ nɛ́, bɔɔlɔ́ɔ babɩ́sɩ Yerusalɛ́ɛm na niíni kʊ́bɔńbɩ. ");
INSERT INTO kdh_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá gɛ bɔwɛ báa sáátɩ wenkí bánzám Ɩsɔ́ɔ.");
INSERT INTO kdh_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Bɩgabaazɩya naanɩ́ na balá báa wenbí nɛ́, weení bánÿaá yɩ sɩsɩ Ŋmatɩrɛ nɛ́, ɩvʊnwɛ. Ɩ́vʊnna Ɩsɔ́ɔ bɔwɛ ná, bɩka ɩvʊngɛ́ɛ Ɩsɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ɩ́vʊnna Ɩsɔ́ɔ bɔwɛ ná bɩgabaazɩya. ");
INSERT INTO kdh_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ɩnáábɩ́lɛ́ Ɩsɔ́ɔ waabaná ɩlá báa ngbetíi, bɩka nabʊ́rʊ fɛ́yɩ́ waalá bɩ ɩdabaná yɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ɩjɔ́ gɛ weezuú fʊnwɛ bɩka weezuú kɩḿ kɩvʊngɛ́ɛ na kʊ ɩráa-dɛ́ɛ ɖɛnyɛm. ");
INSERT INTO kdh_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ɖɛnyɛm wónlosí temenuú-daá, amá, temenuú tamʊ kɩ. ");
INSERT INTO kdh_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ɩrʊ́ naárʊ wɔɔgɔnɩ ná, ɩrʊ́ ɩmʊ́, Ɩsɔ́ɔ weegédíri ná yɩ, ɩyɩ́ɖɛ gɛ Yaayá. ");
INSERT INTO kdh_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Wɔɔgɔ́nɩ nɛ́, seríya lɩzɩ́ɩ gɛ wɔɔgɔ́nɩ. Wɔɔgɔ́nɩ gɛ sɩ ɩlɩzɩ́ weení ɩgɛ́ɛ ɩráa-dɛ́ɛ ɖɛnyɛm nɛ́ seríya, na ɩmʊ́ ɩdɛ́ɛ seríya-rɔ nɛ́, ɩráa ɩfa ɩlɛ́ toovonúm. ");
INSERT INTO kdh_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Bɩdɛkɛ́ɛ ɩmʊ́ ɩdɩtɩŋa ɩgɛ́ɛ na kʊ ɩráa-dɛ́ɛ ɖɛnyɛm, amá, wɔɔgɔ́nɩ gɛ sɩ ɩlɩzɩ́ weení ɩgɛ́ɛ ɩráa-dɛ́ɛ ɖɛnyɛm nɛ́ seríya. ");
INSERT INTO kdh_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Weení ɩgɛ́ɛ ŋmatɩrɛ nɛ́ kɛ́ɛ na kʊ ɖɛnyɛm toovonúm ńgɩ, wenkí kɩ́ngɔnɩ́ ɖúúlínya-daá bɩka kínlosí ɩráa rɩ́ŋa nɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Weení bánÿaá yɩ sɩsɩ Ŋmatɩrɛ nɛ́ fʊnwɛ ɖúúlínya-daá, bɩka ɩnáábɩ́lɛ́ Ɩsɔ́ɔ waala ná ɖúúlínya. Amá, ɖúúlínya-daá ɩráa tatɩlɩ́ yɩ. ");
INSERT INTO kdh_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Wɔɔgɔ́nɩ ɩdɩtɩŋa ɩdɛ́ɛ, amá, ɩdɛ́ɛ-ńba weegízi badamʊ yɩ. ");
INSERT INTO kdh_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ngʊ́ nbɛ́ɛ nɛ́, badaá nɛbɛ́rɛ weedísi bamʊ yɩ, bafa yɩ toovonúm. Wenbá beedísi bamʊ yɩ bafa yɩ toovonúm nɛ́, waava wɛ yíko sɩsɩ bábɩsɩ Ɩsɔ́ɔ-dɛ́ɛ bíya. ");
INSERT INTO kdh_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Bɛdɛ́ɛ baabɩ́sɩ Ɩsɔ́ɔ-dɛ́ɛ bíya nɛ́ tɛkɛ́ɛ ɩrʊ́-dɛ́ɛ sɔɔlɩ́m, yáá alʊ́ na abaalʊ́ bɛdɛ́ɛ yoozí, amá, Ɩsɔ́ɔ tɩtɩŋa weeyele ná babɩ́sɩ ɩdɛ́ɛ bíya. ");
INSERT INTO kdh_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Weení bánÿaá yɩ sɩsɩ Ŋmatɩrɛ nɛ́, waabɩ́sɩ ɩrʊ́ ɩkɔ́nɩ ɩcɔ́ɔ ɖɔ́lɔ́wʊ́táá. Ngɛ ɖááná ɩdɛ́ɛ ásícé. A nyááná yɩ, kʊnyɔnnɩɩrɛ́ na toovonúm riké nbɩlɛ́! Ɩdɛ́ɛ ásícé kɩḿ kɩɩlɩɩná Caáwʊ-jɔ́ gɛ. Ásícé wenkí Caáwʊ weejéle ɩgʊ́ɖʊmɔ́ɔ nɛ́ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yaayá waaŋmátɩ na ɖóni ɩlɩzɩ́ yɩ seríya sɩsɩ: «Ɩdɔ́m gɛ máávʊ́ńveeri mɩ́ɩ sɩsɩ mɔ́wɔ́rɔ́, weení sɩ ɩkɔ́nɩ nɛ́, waagɩ́lɩ ma; káma, ɩvʊnwɛ naanɩ́ gɛ baalʊ́rʊ ma.» ");
INSERT INTO kdh_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ɖárɩ́ŋa ɖééɖí ɩgʊnyɔnnɩɩrɛ́-dɛ́ɛ ɖɔɔmɩ́nɩ-dɛ́ɛ alɩbáráka, bɩdɛkɛ́ɛ kʊ́ɖʊńbɩ ngʊ́ bɩdɛkɛ́ɛ nabʊ́lɛ. ");
INSERT INTO kdh_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Káma, Múúsá gɛ Ɩsɔ́ɔ waabaná icéle ɖáa ɩdɛ́ɛ Mará, amá, Yeésu Krísto gɛ Ɩsɔ́ɔ waabaná ɩwɩ́lɩ ɖáa ɩdɛ́ɛ kʊnyɔnnɩɩrɛ́ na ɩdɛ́ɛ toovonúm. ");
INSERT INTO kdh_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Naárʊ tanáá ta Ɩsɔ́ɔ kɛtɛngɛrɛ. Ɩsɔ́ɔ Biyaalʊ́ kʊ́ɖʊḿ weení ɩwɛná yɩ ɩgɛ́ɛ Ɩsɔ́ɔ bɩka ɩwɛ Ɩsɔ́ɔ-jɔ́ nɛ́, weeyéle ná ɖɩtɩlɩ́ yɩ. ");
INSERT INTO kdh_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ɩbɛ́ɛ seríya wenkí Yaayá waalɩzɩ́ kɩ sáátɩ wenkí Yahúúɖuwá waagálɩ́zɩ́ Ɩsɔ́ɔ sarásɩ lanɖáa na Léévi bíya Yerusalɛ́ɛm bekédiri ɩjɔ́ bɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Nyɔ́ɔ́ gɛ weení» nɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ɩdamʊ́sɩ wɛ, waabá gɛ ifééri wɛ toovonúm sɩsɩ: «Bɩdɛkɛ́ɛ mɔ́ɔ́ gɛ Lɛɛrʊ́.» ");
INSERT INTO kdh_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ngɛ bɛlɛ́ bɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «A bɩlɛ́ nɛ́, nyɔ́ɔ́ gɛ Elíya?» Ngɛ woobúsi wɛ sɩsɩ: «Aayɩ́, bɩdɛkɛ́ɛ mɔ́ɔ́ gɛ Elíya.» Ngɛ bɔɔdɔ́bɔɔzɩ yɩ sɩsɩ: «Nyánáábɩ́lɛ́ anɖébi?» Ngɛ Yaayá sɩsɩ: «Aayɩ». ");
INSERT INTO kdh_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ńna gɛ bɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Nyɔ́ɔ́ gɛ weení. Feeri ɖáa, na ɖɩbɩ́ɩ́zɩ ɖukóbusi wenbá beegédiri ɖáa nɛ́. Weení gɛ nyɔ́ɔ́ nyádɩtɩŋa nyánmaazɩ́ sɩsɩ nyɛ́gɛ́ɛ.» ");
INSERT INTO kdh_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ngɛ Yaayá sɩsɩ: «Mɔ́ɔ́ gɛ weení wóngoó tɛɛwʊ́lɔ́ɔ́-daá sɩsɩ: “Ɩgbɩ́ɩ́rɩ Ɖádʊ́ʊ-dɛ́ɛ nɩ́bááwʊ kɩsɩ́ɩ́zɩ kazɔ́ɔ,” ńŋɩnáa anɖébi Esáya waaŋmátɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Wenbá beegédiri wɛ Yaayá-jɔ́ nɛ́ badaá, Faríizi ńba wɛ. ");
INSERT INTO kdh_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ngɛ bɛlɛ́ bɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «A bɩdɛkɛ́ɛ nyɔ́ɔ́ gɛ Lɛɛrʊ́, ngʊ́ bɩdɛkɛ́ɛ nyánáábɩ́lɛ́ Elíya, cáńfáná anɖébi, bɩlɛ́ nɛ́ ngbetíi-rɔ gɛ nyénliríi ɩráa lɩ́m-daá nyɔ́nzɔ́ɔ wɛ túúbá lɩ́m.» ");
INSERT INTO kdh_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ngɛ Yaayá woobúsi wɛ sɩsɩ: «Mɔ́ɔ́ nɛ́, lɩ́m-daá gɛ ménliríi mɩ́ɩ mɔ́nzɔ́ɔ mɩ́ɩ túúbá lɩ́m; mɩ́lɔ́wʊ́táá, naárʊ wɛ mɩ́ɩ́sɩ yɩ. ");
INSERT INTO kdh_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Mɔ́wɔ́rɔ́ nɛ́, sɩ ɩkɔnɩ ná, amá, mádatála mobóɖi ɩdakaḿwá.» ");
INSERT INTO kdh_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Betáániya tɛɛbiiyá-daá, Yɔrɔdáanɩ buwá-dɛ́ɛ fúu lí ńgɩ-rɔ, lénlé Yaayá wénliríi ɩráa lɩ́m-daá nɛ́ gɛ bɩ́ngalám bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kiivé nɛ́, Yaayá waana Yeésu wɛ́ngɛɖɛɛ́ ɩjɔ́ nɛ́, ngɛ sɩsɩ: «Ɩbɛ́ɛ Ɩsɔ́ɔ-dɛ́ɛ Fée-bú weení wɛ́njɛ́m ɩráa-dɛ́ɛ alaháácɩ́wá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ɩdɔ́m gɛ mááŋmátɩ mɩ́ɩ sɩsɩ mɔ́wɔ́rɔ́, naárʊ wɔ́ngɔnɩ́, bʊdʊ́ʊ waagɩ́lɩ ma, káma, ɩvʊnwɛ naanɩ́ gɛ baalʊ́rʊ ma. ");
INSERT INTO kdh_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mɔ́ɔ́ mádɩtɩŋa mááfʊnzɩ weení ɖéyí‑ɖéyí bɩɩbá bɩgɛ́ɛ nɛ́; amá, mɔ́ɔ́gɔ́nɩ sɩ melíri ɩráa lɩ́m-daá gɛ na meyéle Israyɛ́ɛlɩ zamɔ́ɔ ɩtɩlɩ́ yɩ.» ");
INSERT INTO kdh_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ngɛ Yaayá waadáŋmatɩ sɩsɩ: «Mááná Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga waagálɩɩ ɩsɔ́ɔ́dáá nyazɩ ɖuvóóre kʊ́fʊlʊńɖɛ bɩlɛ́, kɔkɔ́nɩ kɔcɔ́ɔ ɩrɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mɔ́ɔ́ mááfʊnzɩ weení bʊdʊ́ʊ kɛ́ɛ nɛ́, amá, weení weegédíri ma sɩ melíri ɩráa lɩ́m-daá nɛ́, weevééri ma sɩsɩ: “Weení ɩrɔɔzɩ́ sɩ ńna Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga ikédi kɔkɔ́nɩ kɔcɔ́ɔ nɛ́, ɩlɛ́ wénliríi kʊ ɩráa Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga-daá.” ");
INSERT INTO kdh_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Mááná bɩlɛ́ na máázá, bʊrɔɔzɩ́ gɛ mánlɩzɩ́ɩ seríya sɩsɩ ɩnáábɩ́lɛ́ Ɩsɔ́ɔ Biyaalʊ́.» ");
INSERT INTO kdh_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kiivé nɛ́, Yaayá tɔrɔwɛ ńna ɩ́na ɩwanbaaráa nɔɔ́lɛ ");
INSERT INTO kdh_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","gɛ waana Yeésu wɛ́nɖɛɛ́; ngɛ sɩsɩ: «Ɩbɛ́ɛ Ɩsɔ́ɔ-dɛ́ɛ Fée-bú.» ");
INSERT INTO kdh_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Yaayá-dɛ́ɛ wanbaaráa nɔɔ́lɛ bɛḿ baanɩ́ɩ bɩlɛ́ nɛ́, ngɛ baagʊrʊ́ bofu Yeésu. ");
INSERT INTO kdh_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yeésu wɛɛgɛ́ɛ́zɩ ɩbɛ́ɛ́ŋ ɩwɔ́rɔ́ nɛ́, waana sɩsɩ bogovóo yɩ, ngɛ sɩsɩ: «We gɛ mɩ́njáádɩ.» Ngɛ boobúsi yɩ sɩsɩ: «Ráabi, lé gɛ nyɛ́dɛ́ɛ.» (Ráabi kutoluú gɛ sɩsɩ Mará wɩlɩɖʊ́). ");
INSERT INTO kdh_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ngɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Ɩgɔ́nɩ, mɩ́nganáa.» Ngɛ boobó ɖʊɖɔ bana lénlé Yeésu wɛ nɛ́; ngɛ bɔɔjɔ́ɔ ɩjɔ́ bɩdɛ́ɛ wɩ́rɛ ɖɩḿ. Ɖaanɩ́ŋa kéréfu natɩ́náázá bɩlɛ́ gɛ bɩ́nlám bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Wanbaaráa nɔɔ́lɛ wenbá baanɩ́ɩ Yaayá waaŋmátɩ na bakʊrʊ́ bofu Yeésu nɛ́ badaá naárʊ gɛ bánÿaá sɩsɩ Andirée. Andirée ɩmʊ́ ɩwɛná igoobú bánÿaá ɩlɛ́ sɩsɩ Simɔ́ɔnɩ Pétro. ");
INSERT INTO kdh_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Igoobú Simɔ́ɔnɩ ɩmʊ́ gɛ waaɖáa náa ifééri yɩ sɩsɩ baana Krísto. Krísto kutoluú gɛ sɩsɩ Lɛɛrʊ́. ");
INSERT INTO kdh_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ngɛ wɔɔgbɔ́ɔ Simɔ́ɔnɩ iboná Yeésu-jɔ́. Yeésu waana yɩ nɛ́, wɛɛbɛ́ɛ́ŋ yɩ, ngɛ wɔɔdɔ́ yɩ sɩsɩ: «Nyɔ́ɔ́ gɛ Simɔ́ɔnɩ, Yʊháánɩ biyaalʊ́; sɩ bayáa nya gɛ sɩsɩ Kéfáasɩ.» Kéfáasɩ kutoluú gɛ sɩsɩ Bʊ́ʊ́rɛ. ");
INSERT INTO kdh_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kiivé nɛ́, Yeésu waaɖʊ sɩ wɛ́nɖɛɛ́ Galilée laadɔ́ɔ-daá, ngɛ waana Filíipu. Ńna gɛ wɔɔdɔ́ yɩ sɩsɩ: «Kovu ma!» ");
INSERT INTO kdh_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filíipu-dɛ́ɛ gɛ Bɛtɩsayɩdáa, Andirée na Pétro bɛdɛ́ɛ tɛɛbiiyá. ");
INSERT INTO kdh_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filíipu wɔɔgɔ́nɩ ɩna Natanayɛ́ɛlɩ, ngɛ weevééri yɩ sɩsɩ: «Weení ɩdɔ́m baaŋmáa Múúsá-dɛ́ɛ Mará na anɖébiwá-dɛ́ɛ tákaraɖáwá-daá nɛ́, ɖááná yɩ, Yeésu Nazarɛ́ɛtɩ ńnɩ́ gɛ, Ísifu biyaalʊ́.» ");
INSERT INTO kdh_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ngɛ Natanayɛ́ɛlɩ sɩsɩ: «Kazɔ́ɔ ńbɩ nabɩ́rɩ wánbɩɩzɩ́ bɩkálɩ́ɩ́ná Nazarɛ́ɛtɩ nbɩlɛ́?» Ńna gɛ Filíipu sɩsɩ: «Kɔnɩ na ngáná.» ");
INSERT INTO kdh_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yeésu waana Natanayɛ́ɛlɩ wɛ́ngɛɖɛɛ́ ɩjɔ́ nɛ́, ngɛ wánŋmatɩ́ ɩdɔ́m sɩsɩ: «Bɛɛ Israyɛ́ɛlɩ bú tɩtɩŋa nɖɔ́; ɩrʊ́ weení ɩ́dɛ́nbɛlɩ́ bʊbɔ́tɩ kɛtɛngɛrɛ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ngɛ Natanayɛ́ɛlɩ wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Lénlé gɛ nyányɩ ná ma.» Ńna gɛ Yeésu sɩsɩ: «Naanɩ́ na Filíipu ɩyáa nya nyɔ́gɔwɛ figíyée tɩɩwʊ́-dɛ nɛ́, máávʊ́ńgánaa nya.» ");
INSERT INTO kdh_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ńna gɛ Natanayɛ́ɛlɩ wɔɔdɔ́ yɩ sɩsɩ: «Kʊ́bɔnɩ́, nyɔ́ɔ́ gɛ Ɩsɔ́ɔ Biyaalʊ́, nyɔ́ɔ́ gɛ Israyɛ́ɛlɩ wúro.» ");
INSERT INTO kdh_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ngɛ Yeésu woobúsi yɩ sɩsɩ: «A bɩlɛ́, méévééri nya sɩsɩ mááná nya figíyée tɩɩwʊ́-dɛ nɛ́-rɔ gɛ nyáává toovonúm ɖɔ́? Tɔ́ɔ, nyɔ́ngɔnɩ́ ńna wenbí bɩɩjɛzɩ́ ɖɔ́ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ngɛ waadásɩ ɩtɔ́ sɩsɩ: «Ménveerím mɩ́ɩ toovonúm sɩsɩ mɩ́ngɔnɩ́ ɩna ɩsɔ́ɔ́dáá tʊláa, bɩka Ɩsɔ́ɔ-dɛ́ɛ malááyɩ́kawá wéndím bángbanáa Ɩrʊ́ Biyaalʊ́.» ");
INSERT INTO kdh_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Bɩdɛ́ɛ wɛ́ náádoozo wɩ́rɛ nɛ́, ngɛ baalá hiije Kána tɛɛbiiyá-daá Galilée laadɔ́ɔ-rɔ. Yeésu ɩgɔɔ woobó hiije kɩḿ. ");
INSERT INTO kdh_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Baadáyáa Yeésu ɖʊɖɔ na ɩwanbaaráa bɔkɔ́nɩ. ");
INSERT INTO kdh_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Sʊlʊ́m bɔwɛ bɔ́nnyɔɔ́ hiije-daá nɛ́ wɔɔgɔ́nɩ bɩtɛ́, ngɛ Yeésu ɩgɔɔ weevééri yɩ sɩsɩ: «Bɛdɛ́ɛ sʊlʊ́m wɛɛdɛ́.» ");
INSERT INTO kdh_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ngɛ Yeésu woobúsi yɩ sɩsɩ: «Ɖɔ́gɔɔ, mána nya wentí. Mɛ́dɛ́ɛ alɩwáátɩ tatala tá.» ");
INSERT INTO kdh_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ngɛ ɩgɔɔ weevééri hiije-daá bɔwʊtá-dɩnáa sɩsɩ: «Ɩlá wenbí bɩrɩ́ŋa sɩ ɩtɔ́ mɩ́ɩ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Hiije-daá, nɩgbáánɩ loɖo wɛ ńnaamʊ́, nɩgbáánɩ tɩḿ, bɔ́ gɛ bɛɛjɛ́sɩ bala ná tɩ. Tɩdaá gɛ Yahúúɖuwá wánɖʊ́ʊ lɩ́m bánlanáa badɩ ɖacɩrɩ‑cɩrɩ Ɩsɔ́ɔ ɩzá-daá. Báa wenkí-daá bánbɩɩzɩ́ baɖʊ nyazɩ lɩ́m líitiri nɩɩ́nʊ́wá (100) bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ngɛ Yeésu wɔɔdɔ́ bɔwʊtá-dɩnáa sɩsɩ: «Ɩɖʊ lɩ́m bisu nɩgbáánɩ tɩna.» Ngɛ baaɖʊ lɩ́m bisu tɩ fɛ́lɛ́‑fɛ́lɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ngɛ Yeésu sɩsɩ: «Ɩjɩrɩ́ lɛlɛɛɖɔ́ iboná hiije-dɛ́ɛ ɖíína-dɛ́ɛ nɩ́baadɛɛrʊ́.» Ngɛ baajɩrɩ́ boboná yɩ. ");
INSERT INTO kdh_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Hiije-dɛ́ɛ ɖíína-dɛ́ɛ nɩ́baadɛɛrʊ́ waaɖɩ́m lɩ́m nɛ́, bɩ́ńbɩ́sɩ sʊlʊ́m. (Ɩmʊ́ ɩdɩtɩŋa waasɩ lénlé sʊlʊ́m waagálɩ́ɩ́ná nɛ́, amá, wenbá baagájɩ́rɩ́ lɩ́m nɛ́, bɛlɛ́ banyɩ ná). Ńna gɛ waayáa weetáhárʊ ");
INSERT INTO kdh_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ɩtɔ́ yɩ sɩsɩ: «Sʊlʊ́m kazɔ́ɔ ńbɩ gɛ báa weení wánɖaanáa ɩráa fáa bɔnyɔ́ɔ naanɩ́, na a ɩráa wɔɔnyɔ́ɔ bɩ́nɖɛɛzɩ́ wɛ nɛ́, bafa wɛ sʊlʊ́m bɩdɛ́ɛ kazɔ́ɔ tɔɖɔ́ɔ nɛ́. Amá, nyɔ́ɔ́ nyáázɩ́ɩ sʊlʊ́m kazɔ́ɔ ńbɩ hálɩ lɛlɛɛɖɔ́!» ");
INSERT INTO kdh_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yeésu sɩ ɩɖáa ɩdɛ́ɛ maamááciwá tɩ́nwɩlɩ́ɩ weení ɩgɛ́ɛ nɛ́ lám nɛ́, maamááci kɩḿ gɛ waaɖaaná Kána tɛɛbiiyá-daá Galilée laadɔ́ɔ-rɔ. Waawɩ́lɩ ɩdɛ́ɛ ásícé, ngɛ ɩdɛ́ɛ wanbaaráa waava yɩ toovonúm. ");
INSERT INTO kdh_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Bɩlɛ́ bʊwɔ́rɔ́ nɛ́, ngɛ Yeésu weedí Kapɛrɩnawʊ́m tɛ́ɛ́dɩ-daá ɩ́na ɩgɔɔ na igoobíya na ɩwanbaaráa. Amá, wɛ́-bíya cʊ́kɔ gɛ baalá ńna. ");
INSERT INTO kdh_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yahúúɖuwá-dɛ́ɛ Fɛlɛ nɖɛ́ɛ-dɛ́ɛ jíńgáárɩ́ wáńjʊ́ʊ́, ngɛ Yeésu waagba Yerusalɛ́ɛm. ");
INSERT INTO kdh_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Waana ɩráa bánÿám náánɩ, na fééni na avówa kʊ́fʊlʊmá Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá. Waadánáa wenbá bɛ́ngɛɛ́ ɩráa liideé nɛ́ bɔjɔɔ́ɔ. ");
INSERT INTO kdh_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ńna gɛ waajáa nibé ɩlá kegbééziyɔ́ɔ ɩɖɔ́ɔ barɩ́ŋa Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá, bɩ́na fééni na náánɩ; ɩyáázɩ liide-gɛɛráa-dɛ́ɛ liideé, ikulú tébiriwá. ");
INSERT INTO kdh_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ngɛ weevééri avówa yamɖáa sɩsɩ: «Ɩlɩzɩ́ mɩ́gbɩná cé! Ɩ́kɔkpɔ́ɔ Majaa-dɛ́ɛ ɖaána ɩbɩsɩná fótóósi ɖaána!» ");
INSERT INTO kdh_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ngɛ ɩwanbaaráa wɔɔdɔ́ɔ́zɩ sɩsɩ baaŋmáa Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖáwá-daá sɩsɩ: «Mádʊ́ʊ Ɩsɔ́ɔ, sɔɔlɩ́m máábá mɔzɔ́ɔ́lɩ nyáɖaána nɛ́-dɛ́ɛ tɔ́m ɖɔ́kɩná méwenbiré páá.» ");
INSERT INTO kdh_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ngɛ Yahúúɖuwá-dɛ́ɛ nɩ́baadɛɛráa wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Maamááci wenkí gɛ nyánbɩɩzɩ́ nlá na nwɩ́lɩ ɖáa sɩsɩ nyɔ́wɛná yíko ńla ńŋɩnáa ɖɔ́.» ");
INSERT INTO kdh_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ńna gɛ Yeésu woobúsi wɛ sɩsɩ: «Ɩyɔ́ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga kana, mángʊsɩ́ kɛ wɛ́ náádoozo-daá.» ");
INSERT INTO kdh_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ngɛ Yahúúɖuwá weevééri yɩ sɩsɩ: «Bɩ́ɩ́zɩ nɛɛ́lɛ na loɖo gɛ bɔɔgbɔ́ɔ bama ná Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga kana, ngɛ nyɔ́ɔ́ nyazɩ wɛ́ náádoozo gɛ sɩ ngbɔ́ɔ nma ná kɛ?» ");
INSERT INTO kdh_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ngʊ́ Yeésu ɩlɛ́ waayáa sɩ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga nɛ́, ɩdɔnʊʊ́ gɛ waayáa bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Sáátɩ wenkí wɔɔgɔ́nɩ ifé ɩkálɩɩ ɩsɩɖáa-daá nɛ́, ngɛ ɩwanbaaráa wɔɔdɔ́ɔ́zɩ sɩsɩ waavʊ́ńŋmátɩ bɩlɛ́. Ngɛ baava Ɩsɔ́ɔ-dɛ́ɛ tɔ́m na tɔ́m tɩḿ Yeésu waavʊ́ńŋmátɩ tɩ nɛ́ toovonúm. ");
INSERT INTO kdh_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Sáátɩ wenkí Yeésu fʊnwɛ Yerusalɛ́ɛm Fɛlɛ nɖɛ́ɛ-dɛ́ɛ jíńgáárɩ́ sáátɩ nɛ́, ɩráa ɖabata waana maamááciwá wánlám nɛ́, baava yɩ toovonúm. ");
INSERT INTO kdh_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Amá, Yeésu ɩlɛ́ ɩdalá wɛ yaraɖá, káma, ɩvʊnnyɩ wenbí barɩ́ŋa bɛgɛ́ɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ɩdanvɛ́yɩ́na sɩsɩ befééri yɩ wenbí ɩrʊ́ kɛ́ɛ bɩ nɛ́, káma, ɩvʊnnyɩ wenbí bʊwɛ ɩrʊ́-daá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Faríizi ńba-daá abaalʊ́ naárʊ wɔɔjɔɔ ná, bánÿaá yɩ sɩsɩ Nikodɛ́ɛmɩ, ɩgɛ́ɛ Yahúúɖuwá-dɛ́ɛ kʊ́bɔnɩ́ naárʊ gɛ. ");
INSERT INTO kdh_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Wɩ́rɛ gɛ wɔɔgɔ́nɩ nuvoowú-daá ɩmɔɔná Yeésu, ngɛ weevééri yɩ sɩsɩ: «Kʊ́bɔnɩ́, ɖányɩ bɩlɛ́ sɩsɩ Ɩsɔ́ɔ weegédíri ná nya sɩ ngɔ́nɩ nwɩ́lɩ ɖáa ɩdɛ́ɛ tɔ́m. Káma, naárʊ tánbɩɩzɩ ɩlá maamááciwá wentí nyɔ́ɔ́ nyánlám tɩ nɛ́ a Ɩsɔ́ɔ raazɩ́ŋɛ́ɛ bʊdʊ́ʊ wɔ́rɔ́.» ");
INSERT INTO kdh_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ngɛ Yeésu woobúsi yɩ sɩsɩ: «Ménveerím nya toovonúm sɩsɩ weení badatásɩ balʊ́rʊ yɩ nɛ́, bʊdʊ́ʊ tánbɩɩzɩ ɩna Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ngɛ Nikodɛ́ɛmɩ wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Nŋɩ́nɩ́ gɛ bɩ́nlám na batásɩ balʊ́rʊ ɩrʊ́ wánlám ábɔ́nɩ́ nɛ́. Bʊdʊ́ʊ wánbɩɩzɩ́ ɩtásɩ ɩsʊ́ʊ ɩgɔɔ lóódi-daá balʊ́rʊ yɩ?» ");
INSERT INTO kdh_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ngɛ Yeésu woobúsi yɩ sɩsɩ: «Ménveerím nya toovonúm sɩsɩ a badatásɩ balʊrʊ ná ɩrʊ́ na lɩ́m na Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga, bʊdʊ́ʊ tánbɩɩzɩ ɩsʊ́ʊ Ɩsɔ́ɔ-dɛ́ɛ kowúrɔ́ɔ-daá. ");
INSERT INTO kdh_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Wenbí ɩrʊ́ wánlʊrʊ́ʊ nɛ́ kɛ́ɛ ɩrʊ́ gɛ, bɩka wenbí Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga wánlʊrʊ́ʊ nɛ́ kɛ́ɛ Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga-dɛ́ɛ ńbɩ gɛ. ");
INSERT INTO kdh_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Bɩ́kalá nya bítí mɔ́ɔ́dɔ́ nya sɩsɩ asée batásɩ balʊ́rʊ mɩ́ɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Fefelimá wɛ́nvɛtɩ́ nɛ́, lé bɩɩmɔ́ɔ yɛ nɛ́ gɛ ánvɛtɩ́; nyánnɩɩ́ ánvɛtɩ́ nɛ́, amá, nyáásɩ lé aagálɩ́ɩ́ná nɛ́, cáńfáná lénlé ánɖɛɛnáa nɛ́. Bɩlɛ́ ɖʊɖɔ gɛ bɩjɔɔ́ɔ weení baadásɩ balʊrʊ ná yɩ na Kezeŋa Ɖacɩrɩ‑cɩrɩ ńga nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ngɛ Nikodɛ́ɛmɩ wɔɔdɔ́bɔɔzɩ Yeésu sɩsɩ: «Nŋɩ́nɩ́ gɛ bɩ́nbɩɩzɩ́ bɩlá bɩlɛ́.» ");
INSERT INTO kdh_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ńna gɛ Yeésu woobúsi sɩsɩ: «A bɩlɛ́, nyɔ́ɔ́ weení nyɛ́gɛ́ɛ Israyɛ́ɛlɩ Mará wɩlɩɖʊ́ nɛ́, ńdánnɩɩ bugutoluú? ");
INSERT INTO kdh_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ménveerím nya toovonúm sɩsɩ wentí ɖányɩ nɛ́ gɛ ɖánŋmatɩ́, bɩka wenbí ɖááná nɛ́-dɛ́ɛ seríya gɛ ɖánlɩzɩ́ɩ, amá, mɩ́dánjaa sɩ itísi ɖɛ́dɛ́ɛ seríya. ");
INSERT INTO kdh_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mánŋmatɩ́ mɩ́ɩ adɛ laadɔ́ɔ-rɔ cé-dɛ́ɛ ńdɩ gɛ mɩ́dánjaa sɩ ɩfa toovonúm nɛ́, nŋɩ́nɩ́ gɛ bɩ́nbɩɩzɩ́ bɩlá na ɩfa ma toovonúm a bɩgɛ́ɛ mɔ́ɔ́gɔ́nɩ mánŋmatɩ́ wenbí bɩgɛ́ɛ ɩsɔ́ɔ́dáá ńbɩ nɛ́ bɩdɔ́m. ");
INSERT INTO kdh_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Naárʊ takpa ɩsɔ́ɔ́dáá kɛtɛngɛrɛ, asée Ɩrʊ́ Biyaalʊ́ weení waagálɩɩ ɩsɔ́ɔ́dáá ikédi adɛ nɛ́ iriké. ");
INSERT INTO kdh_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ńŋɩnáa tɛɛwʊ́lɔ́ɔ́-daá anɖébi Múúsá wɔɔgbɔ́ɔ ɖoḿ boolú nyɩɩrʊʊ́ balaná yɩ nɛ́ ɩtʊʊ ná ɖɛ́nɩ kɩ́bɩɩzʊ́ʊ isúu nɛ́, bɩlɛ́ ɖʊɖɔ gɛ sɩ balá Ɩrʊ́ Biyaalʊ́, ");
INSERT INTO kdh_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","na weení ɩrɩ́ŋa waava yɩ toovonúm nɛ́ iyuú weezuú kɩ́dɛ́ndɛŋ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Káma, Ɩsɔ́ɔ wɔɔzɔ́ɔ́lɩ ɖúúlínya páá hálɩ ɩkpɔ́ɔ Ibiyaalʊ́ kʊ́ɖʊḿ weení ɩwɛná yɩ nɛ́ ɩfa, na weení ɩrɩ́ŋa waava yɩ toovonúm nɛ́ ɩ́kɛtɛlɛ́ŋ, amá, iyuú weezuú kɩ́dɛ́ndɛŋ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Káma, Ɩsɔ́ɔ tekédiri Ibiyaalʊ́ ɖúúlínya-daá sɩsɩ ɩkʊ ɩráa tɔ́m; amá, weegédíri yɩ gɛ sɩsɩ ɩ́kɔnɩ ɩlɛ́ɛ wɛ. ");
INSERT INTO kdh_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Weení waava yɩ toovonúm nɛ́, bádángʊ́ʊ ɩdɔ́m; amá, weení ɩdafa yɩ toovonúm nɛ́, ɩlɛ́ ɩdɔ́m wáńzɩ́ḿ nbɩlɛ́, káma, ɩdafa Ɩsɔ́ɔ Biyaalʊ́ kʊ́ɖʊḿ weení ɩwɛná yɩ nɛ́ toovonúm. ");
INSERT INTO kdh_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Wentí tɩrɔ sɩ bakʊ ɩráa-dɛ́ɛ tɔ́m nɛ́ nɖɔ́: Ɖɛnyɛm wɔɔgɔ́nɩ ɖúúlínya nɛ́, beegízi kɩ bɩka bɔsɔ́ɔ́lɩ temenuú, káma, badɩmɛ́ taavé nɛ́-rɔɔzɩ́. ");
INSERT INTO kdh_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Wenbí bʊrɔ nɛ́, weení ɩrɩ́ŋa wánlám bɩdaavé nɛ́ tánjaa ɖɛnyɛm; bʊdʊ́ʊ tánjaa ɩkɔ́nɩ ɖɛnyɛm-daá, káma, wénzewɔ́ɔ sɩsɩ bɩ́kɔkɔ́nɩ bufulú ɩwɔ́rɔ́. ");
INSERT INTO kdh_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Amá, weení ivóo toovonúm nɛ́, wɔ́ngɔnɩ́ ɖɛnyɛm-daá gɛ, na ɩráa ɩna sɩsɩ wenbí bɩmɔɔ́ Ɩsɔ́ɔ nɛ́ gɛ wánlám.» ");
INSERT INTO kdh_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Bɩlɛ́ bʊwɔ́rɔ́ nɛ́, ngɛ Yeésu na ɩwanbaaráa bɛɛɖɛ́ɛ Yudée. Ngɛ ɩ́na wɛ bɔɔjɔ́ɔ ńna cʊ́kɔ bɩka wénliríi ɩráa lɩ́m-daá wɔ́nzɔ́ɔ wɛ túúbá lɩ́m. ");
INSERT INTO kdh_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yaayá ɖʊɖɔ wánvʊnliríi ɩráa lɩ́m-daá fáráńdɩ́ bánÿaá kɩ Enɔ́ɔnɩ, bɩjʊ́ʊ́na Salíim tɛ́ɛ́dɩ nɛ́, káma, lɩ́m wɔɔɖɔ́ɔ ńnaamʊ́; ɩráa wónboɖé ńnaamʊ́ bénliríi wɛ lɩ́m-daá. ");
INSERT INTO kdh_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Bɩdɛ́ɛ sáátɩ kɩḿ nɛ́, bɔdɔtɔ́ɔ ta Yaayá sáráka. ");
INSERT INTO kdh_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ngɛ bɩɩgɔná ŋmatɩrɛ Yaayá-dɛ́ɛ wanbaaráa na Yahúúɖu naárʊ, ɩrʊ́-dɛ́ɛ ɩdɩ ɖacɩrɩ‑cɩrɩ lám Ɩsɔ́ɔ ɩzá-daá-dɛ́ɛ tɔ́m-rɔ. ");
INSERT INTO kdh_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ngɛ bɔɔgɔ́nɩ bana Yaayá befééri yɩ sɩsɩ: «Kʊ́bɔnɩ́, weení ɩvʊngɔwɛ nyɔ́jɔ́ Yɔrɔdáanɩ buwá-dɛ́ɛ fúu lí ńgɩ-rɔ, ngɛ nyáálɩ́zɩ́ yɩ seríya nɛ́, bɛɛ lɛlɛɛɖɔ́ wénliríi ɩráa lɩ́m-daá gɛ, bɩka ɩráa rɩ́ŋa wɛ́nɖɛɛ́ ɩjɔ́.» ");
INSERT INTO kdh_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ngɛ Yaayá woobúsi sɩsɩ: «A ɖé Ɩsɔ́ɔ tafa ɩrʊ́ nabʊ́rʊ, ɩ́dánbɩɩzɩ iyuú bɩ. ");
INSERT INTO kdh_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mɩ́dɩtɩŋa mɩ́ɩ́zá-daá gɛ mɔ́ɔ́dɔ́ sɩsɩ: “Bɩdɛkɛ́ɛ mɔ́ɔ́ gɛ Lɛɛrʊ́, amá, mɛ́ɛgɛ́dɛ́ yɩ nɩ́bááwʊ gɛ.” ");
INSERT INTO kdh_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Weení ɩdɩɩná alʊ́ nɛ́, ɩlɛ́ gɛ weetáhárʊ; bɩɩga cɛrɛ́ɛ ɩlɛ́ wánzɩŋ́ weetáhárʊ-jɔ́ gɛ wénwelesí yɩ; wánnɩɩ́ weetáhárʊ lowú nɛ́, bɩɩbá gɛ bɩjɔɔ́ɔ yɩ niíni. Cɛrɛ́ɛ-dɛ́ɛ niíni igoobire gɛ mɛ́dɛ́ɛ ńbɩ. Bʊrɔ gɛ máábá mɔ́wɛ wenbi‑niíni-daá. ");
INSERT INTO kdh_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Bɩmɔɔ́na ɩlɛ́ ɩdɛ́ɛ yɩ́ɖɛ ɩkpa bɩka mɔ́ɔ́ mɛ́dɛ́ɛ ńɖɛ ití.» ");
INSERT INTO kdh_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«Weení waagálɩ́ɩ́ná ɩsɔ́ɔ́dáá nɛ́, waagɩ́lɩ ɩráa baaganáa rɩ́ŋa. Weení waalɩɩná adɛ laadɔ́ɔ-rɔ nɛ́, ɩlɛ́ ɩgɛ́ɛ adɛ laadɔ́ɔ-rɔ ńnɩ́ gɛ, bɩka adɛ laadɔ́ɔ-rɔ-dɛ́ɛ ńdɩ gɛ wánŋmatɩ́. Weení waagálɩ́ɩ́ná ɩsɔ́ɔ́dáá nɛ́, ");
INSERT INTO kdh_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","wenbí waana nɛ́, na wentí waanɩ́ɩ nɛ́-dɛ́ɛ seríya gɛ wánlɩzɩ́ɩ, amá, ɩráa téndisi ɩdɛ́ɛ seríya wánlɩzɩ́ɩ kɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Weení weedísi ɩdɛ́ɛ seríya nɛ́, wɔɔdɔ́ sɩsɩ Ɩsɔ́ɔ kɛ́ɛ toovonúm-dʊ́ʊ nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Káma, weení Ɩsɔ́ɔ weegédíri yɩ nɛ́, Ɩsɔ́ɔ-dɛ́ɛ tɔ́m gɛ wánŋmatɩ́. Wenbí nɛ́ gɛ sɩsɩ Ɩsɔ́ɔ wánváa bʊdʊ́ʊ ɩdɛ́ɛ Kezeŋa rɩ́ŋa ɖetéḿ gɛ. ");
INSERT INTO kdh_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Caáwʊ sɔɔlɛ́ɛ Biyaalʊ́ʊ, ngɛ wɔɔgbɔ́ɔ bɩrɩ́ŋa ɩɖʊ wɛndɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Weení waava Biyaalʊ́ʊ toovonúm nɛ́, wooyuú weezuú kɩ́dɛ́ndɛŋ́ nɛ́; weení ɩdafa Biyaalʊ́ʊ toovonúm nɛ́, tónÿuú weezuú kɩḿ, amá, Ɩsɔ́ɔ-dɛ́ɛ baaná wɛná ɩrɔɔzɩ́.» ");
INSERT INTO kdh_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Faríizi ńba waanɩ́ɩ ɩráa wánŋmatɩ́ sɩsɩ Yeésu wánbɩsɩnáa wenbá ɩdɛ́ɛ wanbaaráa nɛ́ na wenbá wénliríi lɩ́m-daá wɔ́nzɔ́ɔ wɛ túúbá lɩ́m nɛ́ wɔ́nɖɔɔ́ bángɩlɩ́ɩ Yaayá-dɛ́ɛ wanbaaráa. Ngʊ́ nbɛ́ɛ nɛ́, bɩdɛkɛ́ɛ Yeésu tɩtɩŋa wénliríi kʊ ɩráa lɩ́m-daá, ɩdɛ́ɛ wanbaaráa gɛ. Yeésu waanɩ́ɩ bɩlɛ́ nɛ́, ngɛ waalɩ́ɩ Yudée laadɔ́ɔ-daá ɩbɩ́sɩ Galilée laadɔ́ɔ-daá. ");
INSERT INTO kdh_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ngʊ́ naanɩ́ na ɩkádála Galilée nɛ́, asée wɔɔgbɔɔná Samarɩ́ya laadɔ́ɔ-rɔ. ");
INSERT INTO kdh_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yeésu wɛ́nɖɛɛ́ nɛ́, waadála Samarɩ́ya laadɔ́ɔ-dɛ́ɛ tɛ́ɛ́dɩ natɩ́rɩ-daá, bánÿaá tɩ sɩsɩ Sikáarɩ, fɔɔ́ Yaakúbu waava kɛ ibiyaalʊ́ Ísifu nɛ́ kɔjɔ́. ");
INSERT INTO kdh_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ńnaamʊ́ gɛ Yaakúbu-dɛ́ɛ lɔkɔ fʊnwɛ. Bɩɩnɩ́ɩ Yeésu nɛ́, ngɛ weedí ɩcɔ́ɔ lɔkɔ-jɔ́. Bɩdɛ́ɛ sáátɩ kɩḿ bɩ́ńláḿ ɩdaawʊ́ bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Samarɩ́ya alʊ́ naárʊ wɔɔgɔ́nɩ sɩ ilu lɩ́m; ngɛ Yeésu wɔɔdɔ́ yɩ sɩsɩ: «Fa ma lɩ́m mɔnyɔ́ɔ.» ");
INSERT INTO kdh_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Bɩdɛ́ɛ sáátɩ kɩḿ Yeésu-dɛ́ɛ wanbaaráa wɛ́ńɖɛ́ɛ́ tɛ́ɛ́dɩ-daá sɩ bakámʊ́ kíɖíím. ");
INSERT INTO kdh_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ngɛ Samarɩ́ya alʊ́ weevééri Yeésu sɩsɩ: «Bɩ́nlám nŋɩ́nɩ́ na nyɔ́ɔ́ weení nyɛ́gɛ́ɛ Yahúúɖu nɛ́ nyánzʊlʊ́ʊ mɔ́ɔ́ Samarɩ́ya alʊ́ sɩsɩ máva nya lɩ́m nnyɔ́ɔ.» Káma, Yahúúɖuwá na Samarɩ́ya ńba bádánjʊʊná ɖamá. ");
INSERT INTO kdh_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ngɛ Yeésu woobúsi yɩ sɩsɩ: «A nyáfʊ́nnyɩ Ɩsɔ́ɔ-dɛ́ɛ kʊjɔɔwʊ, bɩka a nyáfʊ́nnyɩ weení wɔɔdɔ́ nya sɩsɩ ńva yɩ lɩ́m ɩnyɔ́ɔ nɛ́, nyɔ́ɔ́ nɖaazʊlʊ ná ɩlɛ́ lɩ́m, bɩka ɩfa nya lɩ́m bɩ́nváa weezuú nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ngɛ alʊ́ woobúsi sɩsɩ: «Kʊ́bɔnɩ́, nyɛ́vɛ́yɩ́na kúlúúgu bɩka lɔkɔ ɖʊɖɔ weelíŋ. Nŋɩ́nɩ́ gɛ sɩ nlá na iyuú lɩ́m bɩḿ bɩ́nváa weezuú nɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","A bɩlɛ́ nɛ́, nyɔ́ɔ́ nyáágɩ́lɩ ɖájaájaa Yaakúbu weení waava ɖáa lɔkɔ kɩna nɛ́? Ɩlɛ́ ɩdɩtɩŋa na ibíya na ɩdɛ́ɛ fʊ́ńdɩ kpɩná bɔɔnyɔ́ɔ kɩdɛ́ɛ lɩ́m.» ");
INSERT INTO kdh_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ngɛ Yeésu woobúsi yɩ sɩsɩ: «Weení wɔɔnyɔ́ɔ lɩ́m bɩna nɛ́, ɖoolɔɔ́ wándasɩ́ kakʊ yɩ ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Amá, weení sɩ ɩnyɔ́ɔ lɩ́m wenbí sɩ mava yɩ nɛ́, ɖoolɔɔ́ tándakʊ́ʊ yɩ kɛtɛngɛrɛ, lɩ́m wenbí sɩ mava yɩ nɛ́ wánbɩsɩ́ ɩdaá gɛ nyazɩ buwá kʊjʊʊ́ lénlé weezuú kɩ́dɛ́ndɛŋ́ nɛ́ wángagám nyazɩ lɩ́m nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ngɛ alʊ́ wɔɔdɔ́ yɩ sɩsɩ: «Kʊ́bɔnɩ́, fa ma bɩdɛ́ɛ lɩ́m na ɖoolɔɔ́ ɩkátasɩ kakʊ ma bɩka mákákabɩ́sɩ cé molu lɩ́m.» ");
INSERT INTO kdh_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ngɛ Yeésu weevééri yɩ sɩsɩ: «Bo ngáyáa nwaalʊ́ bɩka ngábɩsɩ cé.» ");
INSERT INTO kdh_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ngɛ alʊ́ woobúsi yɩ sɩsɩ: «Mɛ́vɛ́yɩ́ na abaalʊ́.» Ńna gɛ Yeésu sɩsɩ: «Nyɔ́wɛná toovonúm ndɔ́ sɩsɩ nyɛ́vɛ́yɩ́na abaalʊ́. ");
INSERT INTO kdh_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Káma, abaaláa nyáázáa wɛ nɛ́ waalɩ́ɩ nɔɔ́nʊ́wá, bɩka weení nyána yɩ ɖɔ́ nɛ́ tɛkɛ́ɛ nwaalʊ́. Toovonúm gɛ nyááŋmátɩ.» ");
INSERT INTO kdh_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ngɛ alʊ́ sɩsɩ: «Kʊ́bɔnɩ́, mɛ́bɛɛ́na sɩsɩ nyɛ́gɛ́ɛ anɖébi gɛ. ");
INSERT INTO kdh_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ɖájaájaanáa Samarɩ́ya ńba woogúu Ɩsɔ́ɔ tɛ́ɛ́dɩ bʊ́ʊ kɩna kɩrɔ gɛ; amá, mɩ́nyɔ́ɔ́ Yahúúɖuwá mɩzɩ Yerusalɛ́ɛm gɛ bɩmɔɔ́na bokúu Ɩsɔ́ɔ tɛ́ɛ́dɩ.» ");
INSERT INTO kdh_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ngɛ Yeésu weevééri yɩ sɩsɩ: «Ɖɔ́gɔɔ, toovonúm gɛ ménveerím nya, alɩwáátɩ kɛrɛŋɛ, bidokúti bɩgɛ́ɛ bʊ́ʊ kɩna kɩrɔ, cáńfáná Yerusalɛ́ɛm gɛ sɩ bokúu Caáwʊ tɛ́ɛ́dɩ. ");
INSERT INTO kdh_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mɩ́nyɔ́ɔ́ Samarɩ́ya ńba, mɩ́ɩ́sɩ wenbí mínguú bɩ tɛ́ɛ́dɩ nɛ́; ɖɔ́ɔ́ Yahúúɖuwá ɖányɩ wenbí ɖónguú bɩ tɛ́ɛ́dɩ nɛ́, káma, Yahúúɖuwá gɛ Ɩsɔ́ɔ sɩ ɩbaná ɩlɛ́ɛ ɩráa. ");
INSERT INTO kdh_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Káma, alɩwáátɩ kɛrɛŋɛ, hálɩ kɩ́ńdálɩ́ bɩtɛ́, kɩdaá, wenbá bónguú Ɩsɔ́ɔ tɛ́ɛ́dɩ na toovonúm nɛ́ wónguú Caáwʊ tɛ́ɛ́dɩ na ɩdɛ́ɛ Kezeŋa-dɛ́ɛ yíko-daá na toovonúm. Wenbá bónguú Ɩsɔ́ɔ tɛ́ɛ́dɩ ńŋɩnáa bɩlɛ́ nɛ́ gɛ Caáwʊ sɔɔlɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ɩsɔ́ɔ kɛ́ɛ Kezeŋa gɛ, ngɛ bɩmɔɔ́na wenbá barɩ́ŋa bónguú yɩ tɛ́ɛ́dɩ nɛ́ bokúu yɩ tɛ́ɛ́dɩ na ɩdɛ́ɛ Kezeŋa-dɛ́ɛ yíko-daá na toovonúm.» ");
INSERT INTO kdh_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ngɛ alʊ́ weevééri yɩ sɩsɩ: «Mányɩ sɩsɩ Krísto, (bugutoluú sɩsɩ: Lɛɛrʊ́ Gɩrɛ́ɛkɩ kʊnʊm-daá) wɔ́ngɔnɩ́. A wɔɔgɔ́nɩ wánwɩlɩ́ɩ ɖáa bɩrɩ́ŋa.» ");
INSERT INTO kdh_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ngɛ Yeésu weevééri yɩ sɩsɩ: «Mɔ́ɔ́ weení mánŋmatɩnáa nya ɖɔ́ nɛ́, mánáábɩ́lɛ́.» ");
INSERT INTO kdh_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ńna gɛ Yeésu-dɛ́ɛ wanbaaráa waagálɩ́ɩ́ná tɛ́ɛ́dɩ-daá batála. Ngɛ bɩɩlá wɛ bítí Yeésu wɛ wánŋmatɩnáa alʊ́ nɛ́. Amá, badaá naárʊ tabɩ́ɩ́zɩ ɩbɔ́ɔ́zɩ yɩ sɩsɩ: «We gɛ nyánjáádɩ» yáá «Wentí gɛ nyána yɩ mɩ́nŋmatɩ́.» ");
INSERT INTO kdh_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ngɛ alʊ́ weeyéle ɩdɛ́ɛ báyɔ́ɔ ńnaamʊ́, ɩɖɛ́ɛ tɛ́ɛ́dɩ-daá ikéveeri ɩráa sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Ɩgɔ́nɩ ɩbɛ́ɛ! Ɩrʊ́ naárʊ wɛ cé weevééri ma wenbí bɩrɩ́ŋa máálá nɛ́! Bɩdɛkɛ́ɛ Lɛɛrʊ́ nbɩlɛ́?» ");
INSERT INTO kdh_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ngɛ ɩráa waagálɩɩ tɛ́ɛ́dɩ-daá bɔkɔ́nɩ Yeésu-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Bɩdɛ́ɛ sáátɩ kɩḿ nɛ́, Yeésu-dɛ́ɛ wanbaaráa wɛ bánjaarɩ́ yɩ sɩsɩ: «Kʊ́bɔnɩ́, ɖi kíɖíím!» ");
INSERT INTO kdh_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Amá, Yeésu weevééri wɛ gɛ sɩsɩ: «Mɔ́ɔ́, mɔ́wɛná kíɖíím nabɩ́rɩ sɩ meɖi, mɩ́nyɔ́ɔ́ mɩ́ɩ́sɩ bɩ.» ");
INSERT INTO kdh_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ngɛ wanbaaráa waabáázɩ ɖamá bɔɔzɩ́ sɩsɩ: «Naárʊ waagʊ́ ɩkɔná yɩ kíɖíím sɩ iɖi yáá wé.» ");
INSERT INTO kdh_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ngɛ Yeésu weevééri wɛ sɩsɩ: «Mégíɖíím gɛ malá weení weegédíri ma nɛ́ ɩzɔɔlɩ́m, bɩka magʊ́ʊ́rɩ ɩdɩmɛ́rɛ wenɖé waaɖʊ ma ɖɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mɩ́dɩtɩŋa mɩ́ndɔ́m kʊ sɩsɩ: “Bɩɩga irodunáa nɔɔ́náázá na kíɖíídi kʊ́m ɩtála.” Amá, mɔ́ɔ́ ménveerím mɩ́ɩ sɩsɩ ɩgʊ́sɩ mɩ́gʊ́jʊ́nɩ ɩbɛ́ɛ fásɩ kazɔ́ɔ: Kíɖíídi wáńbɩ́ɩ bɩɖamáa kʊ́m. ");
INSERT INTO kdh_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Kíɖíídi kʊmɖʊ́ wónÿuúu ɩdɛ́ɛ kɩvɛrɛwʊ bɩka wónduuzí kíɖíídi wángʊ́m nɛ́ wánzɩɩ́ weezuú kɩ́dɛ́ndɛŋ́ nɛ́. Na biyóózi bɩlá ɖuurú na kʊmɖʊ́ niíni. ");
INSERT INTO kdh_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ńna gɛ ɖánnáa sɩsɩ ɖudúúre ɖɩna ɖɩgɛ́ɛ toovonúm; ɖudúúre ɖɩḿ gɛ sɩsɩ: “Naárʊ wónɖuú gɛ bɩka naárʊ ɩkʊ́.” ");
INSERT INTO kdh_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Méédíri mɩ́ɩ ɩkágʊ lénlé mɩ́dálá bɩnɩ́ɩ mɩ́ɩ nɛ́; nɛbɛ́rɛ waala ná tɩmɛ́rɛ, ngɛ mɩ́nyɔ́ɔ́ mɩ́ɩ́dála iɖi bɛlɛ́ bɛdɛ́ɛ tɩmɛ́rɛ-dɛ́ɛ alɩbáráka.» ");
INSERT INTO kdh_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Tɛ́ɛ́dɩ tɩḿ tɩdaá Samarɩ́ya ńba ɖabata waava Yeésu toovonúm alʊ́ ɩmʊ́ ɩdɛ́ɛ seríya waalɩzɩ́ kɩ nɛ́ kɩrɔɔzɩ́. Waalɩzɩ́ seríya sɩsɩ: «Weevééri ma wenbí bɩrɩ́ŋa máálá nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Biiyéle Samarɩ́ya ńba wɔɔgɔ́nɩ Yeésu-jɔ́ nɛ́, baavɩ́nɩ yɩ sɩsɩ ɩcɔ́ɔ bɛḿ bɔjɔ́; ngɛ wɔɔjɔ́ɔ bɔjɔ́ ńna wɛ́-bíya nɔɔ́lɛ. ");
INSERT INTO kdh_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ngɛ baadásɩ bɔɖɔ́ɔ baava yɩ toovonúm baanɩ́ɩ ɩdɩtɩŋa ɩdɛ́ɛ faawɩ́ɩ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ngɛ beevééri alʊ́ sɩsɩ: «Bidokúti bɩgɛ́ɛ wentí nyéévééri ɖáa nɛ́ tiriké tɩrɔ gɛ ɖáává toovonúm, amá, ɖádɩtɩŋa ɖáánɩ́ɩ ná ɖánɩgbamɩ́nɩ wánŋmatɩ́ nɛ́, ngɛ ɖáádɩ́lɩ́ sɩsɩ ɩnáábɩ́lɛ́ toovonúm ɖúúlínya-dɛ́ɛ Lɛɛrʊ́.» ");
INSERT INTO kdh_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yeésu wɔɔjɔ́ɔ ńna wɛ́-bíya nɔɔ́lɛ nɛ́, ngɛ waalɩ́ɩ ńna ɩɖɛ́ɛ Galilée laadɔ́ɔ-daá. ");
INSERT INTO kdh_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Káma, ɩdɩtɩŋa wɔɔdɔ́ sɩsɩ: «Anɖébi naárʊ fɛ́yɩ́ bánɖʊ́ʊ yɩ gírímá ɩdɩtɩŋa ɩdɛ́ɛ́dɩ-daá nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Amá, waadála Galilée nɛ́, Galilée ńba waamʊ yɩ kazɔ́ɔ, káma, baagáná wenbí bɩrɩ́ŋa waagála Yerusalɛ́ɛm jíńgáárɩ́-dɛ́ɛ sáátɩ nɛ́. Káma, bɛḿ ɖʊɖɔ boobó jíńgáárɩ́ kɩḿ. ");
INSERT INTO kdh_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yeésu waadásɩ ɩbɩ́sɩ Kána Galilée laadɔ́ɔ-daá, lénlé waabɩsɩná lɩ́m sʊlʊ́m nɛ́. Wúro-dɛ́ɛ sɔ́ɔ́ja kʊ́bɔnɩ́ naárʊ wɛ Kapɛrɩnawʊ́m tɛ́ɛ́dɩ-daá, ibiyaalʊ́ wánganyaadɩ́. ");
INSERT INTO kdh_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ɩlɛ́ waanɩ́ɩ sɩsɩ Yeésu waagálɩɩ ná Yudée laadɔ́ɔ-daá ɩtála Galilée laadɔ́ɔ-daá nɛ́, ngɛ woobó ɩmɔɔná Yeésu ɩfɩ́nɩ yɩ sɩsɩ íti Kapɛrɩnawʊ́m tɛ́ɛ́dɩ-daá ɩkáwaazɩ ɩmʊ́ ibiyaalʊ́ wánnyaadɩ́ sɩ ɩsɩ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ngɛ Yeésu weevééri yɩ sɩsɩ: «A bɩlɛ́ nɛ́, a mɩ́danáa ta maamááciwá na mááɖéwá, mɩ́dánváa toovonúm kɛtɛngɛrɛ?» ");
INSERT INTO kdh_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ngɛ sɔ́ɔ́ja kʊ́bɔnɩ́ wɔɔdɔ́ Yeésu sɩsɩ: «Kʊ́bɔnɩ́, kɔnɩ mɛ́dɛ́ɛ naanɩ́ na móbú ɩsɩ́.» ");
INSERT INTO kdh_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ngɛ Yeésu weevééri yɩ sɩsɩ: «Bɩsɩ nyɛ́dɛ́ɛ, nyóbú na ɩdɩ.» Abaalʊ́ ɩmʊ́ waava wentí Yeésu weevééri yɩ nɛ́ toovonúm, ngɛ wɛɛɖɛ́ɛ. ");
INSERT INTO kdh_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ɩwɛ nɩ́bááwʊ-rɔ wánbɩsɩ́ gɛ ɩdɛ́ɛ bɔwʊtá-dɩnáa wɔɔgɔ́nɩ basɩ́ŋ yɩ nɩ́bááwʊ befééri yɩ sɩsɩ ibú na ɩdɩ. ");
INSERT INTO kdh_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ngɛ wɔɔbɔ́ɔ́zɩ wɛ sɩsɩ sáátɩ wenkí gɛ bɩɩlá yɩ sóńcí. Ngɛ beevééri yɩ sɩsɩ: «Keɖee, ɩdaawʊ́ kéréfu kʊ́ɖʊmʊ́ʊ bɩlɛ́ gɛ suúle weeyéle yɩ.» ");
INSERT INTO kdh_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ngɛ caáwʊ wooyuú ɩtɩlɩ́ sɩsɩ bɩdɛ́ɛ sáátɩ kɩḿ nɔ́ɔ́ gɛ Yeésu weevééri yɩ sɩsɩ: «Nyóbú na ɩdɩ.» Ngɛ ɩ́na ɩdɛ́ɛ ɖaána rɩ́ŋa baava Yeésu toovonúm. ");
INSERT INTO kdh_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yeésu waagálɩɩ Yudée ɩkɔ́nɩ Galilée wɔ́rɔ́ nɛ́, ngɛ waadásɩ ɩlá maamááci sɩɩlɛ ńgɩ kɩna. ");
INSERT INTO kdh_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Bɩlɛ́ bʊwɔ́rɔ́, Yahúúɖuwá wɛ bénɖíi bɛdɛ́ɛ jíńgáárɩ́ nakɩ́rɩ nɛ́, ngɛ Yeésu woobó Yerusalɛ́ɛm. ");
INSERT INTO kdh_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yerusalɛ́ɛm tɛ́ɛ́dɩ-daá, fééni ɖaḿ wɔnɔɔ́-jɔ́ gɛ lɩmjokú nakɩ́rɩ wɛ. Lɩmjokú kɩḿ kɩjɔ́ gɛ boozúu kɛ́rɛ́ɛ́zɩ nasʊ́nʊ́wá balára bamɩlɩná kɩ bɔlɔ́ sɩ atáárɩ. Bánÿaá lɩmjokú kɩḿ Éburu ńba-dɛ́ɛ kʊnʊm-daá sɩsɩ Bɛtɩzatáa lɩmjokú (bugutoluú sɩsɩ kʊnyɔnnɩɩrɛ́ lɩmjokú). ");
INSERT INTO kdh_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Kɛ́rɛ́ɛ́zɩ sɩḿ sɩdɛɛzɩ́ gɛ kʊdɔndɩnáa tuutúúma fɩ́nɛ́ɛ. Badaá, nyánnáa njɛma, na nʊvɔ́-dɩnáa, na wenbá biilí wɛ nɛ́. Kʊdɔndɩnáa bɛḿ baɖamáa sɩsɩ lɩ́m íyúúdi. ");
INSERT INTO kdh_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Káma, malááyɩ́ka wéńderégedím sáa-sáa lɩmjokú kɩḿ-daá wónÿuúdi lɩ́m. A wooyuúdi bɩ bɩlɛ́ gɛ kʊdɔndʊ́ʊ weení waajáŋ ɩɖáa tím bɩdaá nɛ́, báa ɩgʊdɔḿ kɛ́ɛ wenkí, asée waawáa. ");
INSERT INTO kdh_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Kʊdɔndɩnáa bɛḿ badaá gɛ abaalʊ́ naárʊ wɛ, bɩ́ɩ́zɩ ákoosaaláa na lutoozo nbɩlɛ́ wánnyaadɩ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yeésu waana yɩ ilewáa adɛ ngɛ waanɩ́ɩ sɩsɩ ɩgʊdɔḿ weelééri nɛ́, ngɛ wɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Nyɔ́zɔɔlɛ́ɛ nwáa?» ");
INSERT INTO kdh_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ngɛ kʊdɔndʊ́ʊ woobúsi yɩ sɩsɩ: «Kʊ́bɔnɩ́, mɛ́vɛ́yɩ́na naárʊ sɩ itísi ma lɩmjokú-daá sáátɩ wenkí lɩ́m wónÿuúdi nɛ́. Sáátɩ wenkí sɩ mamáázɩ sɩsɩ méndím nɛ́, naárʊ wɛ́ńlɛ́zɩ́ ma.» ");
INSERT INTO kdh_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ńna gɛ Yeésu wɔɔdɔ́ yɩ sɩsɩ: «Kʊrʊ́ ngbɔ́ɔ nyágɩgbáláwʊ bɩka nnʊ́ŋ.» ");
INSERT INTO kdh_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Sɩ ɩtɔ́ na isú nɛ́, ɩrʊ́ ɩlɛ́ waawáa. Ngɛ wɔɔgbɔ́ɔ ɩgɩgbáláwʊ ɩbáázɩ nʊŋɛ́. Fɛɛzɩrɛ wɩ́rɛ gɛ tɔ́m tɩna tɩ́nlám bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Yahúúɖuwá-dɛ́ɛ kʊ́bɔnáa waana ɩrʊ́ ɩlɛ́ waawáa bɩlɛ́ nɛ́, ngɛ bɔɔdɔ́ yɩ sɩsɩ: «Sinje Fɛɛzɩrɛ wɩ́rɛ gɛ, ɖɛ́dɛ́ɛ Mará tafa nɩ́bááwʊ sɩ nzʊ́ʊ nyágɩgbáláwʊ.» ");
INSERT INTO kdh_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ńna gɛ ɩlɛ́ woobúsi wɛ sɩsɩ: «Weení waawáázɩ ma nɛ́ wɔɔdɔ́ ma gɛ sɩsɩ: “Kʊrʊ́ ngbɔ́ɔ nyágɩgbáláwʊ nnʊ́ŋ.”» ");
INSERT INTO kdh_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ngɛ Yahúúɖuwá-dɛ́ɛ kʊ́bɔnáa bɛḿ bɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Weení wɔɔdɔ ná nya sɩsɩ ńgʊ́rʊ́ ngbɔ́ɔ nyágɩgbáláwʊ nnʊ́ŋ.» ");
INSERT INTO kdh_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Amá, weení waawáa bɩlɛ́ nɛ́ waasɩ weení waawáázɩ yɩ nɛ́, káma, Yeésu wɛɛdɛlɛ́ŋ zamɔ́ɔ kʊwɛ ɖɩdáarɛ ɖɩḿ ɖɩdaá nɛ́ kɩdaá. ");
INSERT INTO kdh_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Bʊwɔ́rɔ́ gɛ, Yeésu waana ɩrʊ́ weení waawáázɩ yɩ bɩlɛ́ nɛ́ Ɩsɔ́ɔ-dɛ́ɛ Ɖaána kʊ́bɔńga-daá, ngɛ wɔɔdɔ́ yɩ sɩsɩ: «Lɛlɛɛɖɔ́ nyááwáa, amá, nkokúti nlá alaháácɩ́ na wenbí bɩɩgɩ́lɩ bɩna nɛ́ bʊ́kɔ́mɔɔná nya.» ");
INSERT INTO kdh_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ɩrʊ́ ɩmʊ́ waalɩ́ɩ nɛ́, ngɛ woobó ifééri Yahúúɖuwá-dɛ́ɛ kʊ́bɔnáa sɩsɩ Yeésu waawaazɩ ná ɩmʊ́. ");
INSERT INTO kdh_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ngɛ bɛlɛ́ baabáázɩ Yeésu fúkúḿsi fáa, káma, Fɛɛzɩrɛ wɩ́rɛ gɛ waawáázɩ yɩ nɛ́-rɔ. ");
INSERT INTO kdh_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ńna gɛ Yeésu woobúsi wɛ sɩsɩ: «Majaa wɛ wánlám tɩmɛ́rɛ hálɩ na sinje. Ngɛ mɔ́ɔ́ ɖʊɖɔ mɔ́wɛ mánlám tɩmɛ́rɛ.» ");
INSERT INTO kdh_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yeésu waaŋmátɩ bɩlɛ́ nɛ́, Yahúúɖuwá-dɛ́ɛ kʊ́bɔnáa woogúti bacáa sɩ bakʊ yɩ, káma, waayɩsɩná Fɛɛzɩrɛ wɩ́rɛ-dɛ́ɛ mará baasí, woogúti ɩtɔ́ ɖʊɖɔ sɩsɩ ɩmʊ́ Ɩjaa gɛ Ɩsɔ́ɔ; waabɩsɩná ɩlɛ́ ɩzáárá nbɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yeésu waadásɩ ɩŋmátɩ wɛ sɩsɩ: «Ménveerím mɩ́ɩ toovonúm sɩsɩ Biyaalʊ́ʊ tánbɩɩzɩ ɩlá nabʊ́rʊ ɩdɩ‑ɩdɩ, amá, wenbí waana Caáwʊ wánlám nɛ́ biriké gɛ wánlám. Káma, wenbí bɩrɩ́ŋa Caáwʊ wánlám nɛ́, bɩlɛ́ nɔ́ɔ́ ɖʊɖɔ gɛ Biyaalʊ́ʊ wánlám. ");
INSERT INTO kdh_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Caáwʊ sɔɔlɛ́ɛ Biyaalʊ́ʊ, bɩka wánwɩlɩ́ɩ yɩ wenbí bɩrɩ́ŋa wánlám nɛ́. Wándasɩ́ ɩwɩ́lɩ yɩ tɩmɛ́ kʊ́bɔná aagɩ́lɩ ana nɛ́ ɩlá, na bɩbá bɩlá mɩ́ɩ bítí. ");
INSERT INTO kdh_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Wenbí ńŋɩnáa Caáwʊ wénveezí ɩsɩɖáa ɩɖʊ wɛ weezuú nɛ́, bɩlɛ́ ɖʊɖɔ gɛ Biyaalʊ́ʊ wánɖʊ́ʊ wenbá ɩzɔɔlɛ́ɛ wɛ nɛ́ weezuú. ");
INSERT INTO kdh_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Bɩka Caáwʊ tánvʊʊná naárʊ, amá, wɔɔgbɔ́ɔ yíko rɩ́ŋa gɛ ɩɖʊ Biyaalʊ́ʊ ndɛ́ sɩsɩ ɩ́fʊʊná ɩráa, ");
INSERT INTO kdh_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","na barɩ́ŋa bɔɖɔ́ɔ́zɩ yɩ ńŋɩnáa bɔ́nɖɔɔzɩ́ Caáwʊ nɛ́. Weení ɩrɩ́ŋa ɩdɔɖɔ́ɔ́zɩ Biyaalʊ́ʊ nɛ́, ɩdɔɖɔ́ɔ́zɩ Caáwʊ weení weegédíri yɩ nɛ́ ɖʊɖɔ. ");
INSERT INTO kdh_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ménveerím mɩ́ɩ toovonúm sɩsɩ weení ɩrɩ́ŋa waanɩ́ɩ mɛ́dɛ́ɛ ŋmatɩrɛ gɛ waava weení weegédíri ma nɛ́ toovonúm nɛ́, wooyuú weezuú kɩ́dɛ́ndɛŋ́ nɛ́. Bádanvʊʊná yɩ; bʊdʊ́ʊ waalɩ́ɩ sɩ́m-daá ɩsʊ́ʊ weezuú-daá. ");
INSERT INTO kdh_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ménveerím mɩ́ɩ toovonúm sɩsɩ alɩwáátɩ kɛrɛŋɛ hálɩ kɩ́ńdálɩ́ bɩtɛ́, ɩsɩɖáa wánnɩɩ́ Ɩsɔ́ɔ Biyaalʊ́ lowú, wenbá sɩ banɩ́ɩ lowú kɩḿ nɛ́, bónÿuú weezuú. ");
INSERT INTO kdh_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Káma, ńŋɩnáa Caáwʊ wɛná weezuú-dɛ́ɛ yíko nɛ́, bɩlɛ́ ɖʊɖɔ gɛ waava Biyaalʊ́ʊ weezuú-dɛ́ɛ yíko. ");
INSERT INTO kdh_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ngɛ waava Biyaalʊ́ʊ yíko sɩsɩ ɩ́fʊʊná ɩráa, káma, ɩgɛ́ɛ na Ɩrʊ́ Biyaalʊ́. ");
INSERT INTO kdh_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Bɩ́kalá mɩ́ɩ bítí, alɩwáátɩ nakɩ́rɩ kɛrɛŋɛ wenbá barɩ́ŋa baazɩ́ bebí wɛ nɛ́ bánnɩɩ́ ilowú ");
INSERT INTO kdh_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","bakálɩɩ bɔbɔɔláánɩ-daá. Wenbá baalá kazɔ́ɔ ńbɩ nɛ́ bángʊsɩ́ wɛ basʊ́ʊ weezuú-daá. Amá, wenbá baalá bɩdaavé nɛ́, bángʊsɩ́ wɛ bafʊʊná wɛ bakʊ bɔdɔ́m. ");
INSERT INTO kdh_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Mɔ́ɔ́ mádánbɩɩzɩ malá nabʊ́rʊ mádɩ‑mádɩ. Mánvʊʊnáa ɩráa tɔ́m bɩlɩɩná wentí Caáwʊ weevééri ma nɛ́ gɛ. Ngʊ́ nŋɩ́nɩ́ mánvʊʊnáa nɛ́ sɩɩzɛ́ɛ, káma, bɩdɛkɛ́ɛ mólowú fáa bɩ nɛ́ gɛ mánlám, amá, wenbí weení weegédíri ma nɛ́ sɔɔlɛ́ɛ nɛ́ gɛ mánlám.» ");
INSERT INTO kdh_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«A mádɩtɩŋa máfʊ́nlɩzɩ́ɩ kʊ mádɩ seríya, bɩlɛ́ nɛ́, mɛ́dɛ́ɛ seríya lɩzɩ́ɩ kɩḿ kɩ́fʊnvɛ́yɩ́na fɔ́ɔ́zɩrɛ. ");
INSERT INTO kdh_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Amá, naárʊ wánlɩzɩ́ɩ kʊ ma seríya; bɩka mányɩ sɩsɩ ɩdɛ́ɛ seríya kɩḿ kɩgɛ́ɛ toovonúm. ");
INSERT INTO kdh_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mɩ́ɩ́gʊ́sɩ tɩndɩnáa itíri Yaayá-jɔ́ nɛ́, toovonúm gɛ waagálɩ́zɩ́ seríya. ");
INSERT INTO kdh_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mɔ́ɔ́ nɛ́, bɩdɛkɛ́ɛ ɩrʊ́-dɛ́ɛ seríya lɩzɩ́ɩ gɛ mánjáádɩ, amá, na mɩ́nyɔ́ɔ́ iyuú lɛ́ɛ́dɩ-rɔ gɛ mááŋmátɩ bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yaayá fʊngɛ́ɛ gɛ nyazɩ fɩtɩ́la bɔɔzɔ́ kɩ kínlosí nɛ́; ngɛ míídísi ɩkɔ́nɩ ɩfáárɩ cʊ́kɔ kɩdɛ́ɛ ɖɛnyɛm-daá. ");
INSERT INTO kdh_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ngʊ́ mɔ́wɛná seríya kɩɩgɩ́lɩ Yaayá-dɛ́ɛ ńgɩ nɛ́. Tɩmɛ́ Caáwʊ weegéjéle ma mánlám yɛ nɛ́, adɩtɩŋa ánlɩzɩ́ɩ kʊ ma seríya sɩsɩ toovonúm, weegédíri ná ma. ");
INSERT INTO kdh_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Bɩka Caáwʊ weení weegédíri ma nɛ́, ɩdɩtɩŋa waalɩzɩ́ ma seríya ɖʊɖɔ. Kɛtɛngɛrɛ mɩ́dánɩɩ tá ilowú, belenté ɩna waazá-daá. ");
INSERT INTO kdh_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ngʊ́ bɩlɛ́ gɛ mɩ́dɔ́nɖɔkɩ ɩdɛ́ɛ tɔ́m, káma, mɩ́dáfá weení weegédíri yɩ nɛ́ toovonúm. ");
INSERT INTO kdh_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mɩ́ɩ́bá mɩ́ngbɛlɛŋ́ Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá sɩsɩ na iyuú weezuú kɩ́dɛ́ndɛŋ́ nɛ́ kɩdaá. Ngʊ́ kɩlɛ́ kɩ́nlɩzɩ́ɩ kʊ ma seríya. ");
INSERT INTO kdh_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Amá, mɩ́dánjaa sɩ ɩkɔ́nɩ mɔ́jɔ́ na iyuú weezuú. ");
INSERT INTO kdh_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Mánŋmatɩ́ ɖɔ́ nɛ́, bɩdɛkɛ́ɛ ɩráa-dɛ́ɛ ma sám gɛ mánjáádɩ. ");
INSERT INTO kdh_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Amá, mányɩ mɩ́ɩ; mányɩ sɩsɩ Ɩsɔ́ɔ-dɛ́ɛ sɔɔlɩ́m fɛ́yɩ́ míwenbé-daá. ");
INSERT INTO kdh_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Na Majaa-dɛ́ɛ yɩ́ɖɛ-daá gɛ mɔ́ɔ́gɔ́nɩ́ná, ngɛ mídéyí ma mʊ́ʊ; amá, a naárʊ wɔɔgɔnɩná ɩdɩtɩŋa ɩyɩ́ɖɛ-daá mɩ́nmʊ́ʊ ɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mɩ́zɔɔlɛ́ɛ ɖamá-dɛ́ɛ sám bɩka mɩ́dánjaa Ɩsɔ́ɔ weení ɩgɛ́ɛ kʊ́ɖʊḿ nɛ́-dɛ́ɛ ńbɩ; mɩ́nlám nŋɩ́nɩ́ na ɩbɩ́ɩ́zɩ ɩfa toovonúm. ");
INSERT INTO kdh_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ɩ́kamáázɩ sɩsɩ mɔ́ɔ́ sɩ magágʊ́ ná mɩ́dɔ́m Caáwʊ ɩzá-daá. Múúsá mɩ́jɔɔ́na yɩ tamɔ́ɔ nɛ́ sɩ ɩkágʊ́ ná mɩ́dɔ́m. ");
INSERT INTO kdh_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","A mɩraabá ɩfa Múúsá toovonúm, mɩraava mɔ́ɔ́ ɖʊɖɔ toovonúm. Káma, mɔ́dɔ́m gɛ Múúsá waaŋmáa Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá. ");
INSERT INTO kdh_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Amá, mɩ́dáfá wenbí waaŋmáa nɛ́ toovonúm nɛ́, mɩ́nlám nŋɩ́nɩ́ na ɩbɩ́ɩ́zɩ ɩfa tɔ́m mánŋmatɩ́ mɩ́ɩ ɖɔ́ nɛ́ toovonúm.» ");
INSERT INTO kdh_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Bɩlɛ́ bʊwɔ́rɔ́ nɛ́, Yeésu wɛɛdɛsɩná Galilée lɩɩrɛ́ kʊ́bɔńɖɛ bándayaá ɖɛ sɩsɩ Tiberíyáadɩ lɩɩrɛ́ nɛ́ ɖɩdɛ́ɛ fúu lí ńgɩ-rɔ. ");
INSERT INTO kdh_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Zamɔ́ɔ kʊ́bɔńgɩ fóo yɩ, káma, kɩɩna maamááciwá waalá ɩwáázɩ kʊdɔndɩnáa nɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ngɛ Yeésu woobó ɩkpa bʊ́ʊ-daá ití ɩcɔ́ɔ ɩ́na ɩwanbaaráa. ");
INSERT INTO kdh_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Bɩdɛ́ɛ sáátɩ, Yahúúɖuwá-dɛ́ɛ jíńgáárɩ́ bánÿaá kɩ sɩsɩ Fɛlɛ nɖɛ́ɛ-dɛ́ɛ jíńgáárɩ́ nɛ́ kɩ́ńjʊ́ʊ́. ");
INSERT INTO kdh_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yeésu waagʊ́sɩ ɩbɛ́ɛ́ŋ nɛ́, waana zamɔ́ɔ kʊ́bɔńgɩ wɛ́ngɛɖɛɛ́ ɩjɔ́. Ngɛ wɔɔbɔ́ɔ́zɩ Filíipu sɩsɩ: «Lé gɛ ɖánnáa kíɖíím ɖɩmʊ ɖicéle zamɔ́ɔ kɩna kɩrɩ́ŋa kiɖi.» ");
INSERT INTO kdh_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yeésu waalá Filíipu bɩlɛ́ sɩ ɩɖáázɩ yɩ ɩbɛ́ɛ́ŋ gɛ, káma, ɩvʊnnyɩ wenbí sɩ ɩlá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filíipu woobúsi yɩ sɩsɩ: «Sɔɔlɩ bɔkpɔ́ɔ ɩrʊ́ kʊ́ɖʊḿ-dɛ́ɛ wɛ́ kákpáŋa (200) tɩmɛ́rɛ-dɛ́ɛ fɛrɩ́tɩ bakámʊ ná kíɖíím, bɩ́dándalɩ́ na batára báa weení ɩtáńÿuú cʊ́kɔ.» ");
INSERT INTO kdh_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ngɛ Andirée, ɩwanbaaráa-daá naárʊ, Simɔ́ɔnɩ Pétro igoobú, wɔɔdɔ́ yɩ sɩsɩ: ");
INSERT INTO kdh_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Bú afobú naárʊ wɛ ɖɔ́lɔ́wʊ́táá cé ɩɖɔ́kɩná kpɔ́nɔ́wá natʊ́nʊ́wá na tiiná náálɛ. Amá, we gɛ sɩ bɩbɩ́ɩ́zɩ bɩlá zamɔ́ɔ ńŋɩnáa kɩna.» ");
INSERT INTO kdh_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ńna gɛ Yeésu sɩsɩ: «Ɩdɔ́ ɩráa rɩ́ŋa bɔcɔ́ɔ adɛ.» Nyɩ́ɩ́dɩ ɖabata ɩbá tɩwɛ ɖɩdáarɛ ɖɩḿ ɖɩdaá. Ngɛ bɔɔdɔ́ ɩráa bɔcɔ́ɔ. Ɩráa bɛḿ badaá, abaaláa riké kɛ́ɛ nyazɩ mííli nɔɔ́nʊ́wá (5.000) bɩlɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ngɛ Yeésu wɔɔgbɔ́ɔ kpɔ́nɔ́wá ɩsá Ɩsɔ́ɔ tɩrɔ, ngɛ waadára ɩráa bɔjɔɔ́ɔ ńna nɛ́. Ngɛ wɛɛdɛ́sɛlɩ́ tiiná, ɩsá Ɩsɔ́ɔ arɔ ɖʊɖɔ. Ngɛ waadátárɩ́ báa weení wenbí bʊdʊ́ʊ sɔɔlɛ́ɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Beeɖi bɔfɔ́ɔ nɛ́, ngɛ Yeésu wɔɔdɔ́ ɩwanbaaráa sɩsɩ: «Ɩdɔ́ɔ́zɩ buḿsi ɩráa wɔɔdɔ́ɔ bɩka nɛ́, na bɩdaá nabʊ́rʊ ɩ́kalá ásáráwʊ́.» ");
INSERT INTO kdh_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Kpɔ́nɔ́wá natʊ́nʊ́wá bɔɔdɔ́ɔ nɛ́-dɛ́ɛ fɔɔlásɩ wanbaaráa wɔɔdɔ́ɔ́zɩ bɩɩga nɛ́ woozu ɖɔkɩ́nɩ fuú na natɩ́lɛ. ");
INSERT INTO kdh_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ɩráa waana maamááci wenkí Yeésu waalá nɛ́, ngɛ sɩsɩ: «Toovonúm, ceení gɛ anɖébi weení sɩ ɩkɔ́nɩ ɖúúlínya-daá nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yeésu waadɩlɩ́ sɩsɩ bɛgɛgɛrɛŋɛ sɩ bɔkpɔ́ɔ yɩ na ɖóni basɩ́ɩ kowúrátɩ. Waana bɩlɛ́ nɛ́, ngɛ wɛɛɖɛ́ɛ ɩkpa bʊ́ʊyɔ́ɔ kʊjʊʊ́-daá ɩgɔjɔɔ́ɔ iriké. ");
INSERT INTO kdh_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kɩɩɖáánɩ nɛ́, ngɛ ɩwanbaaráa weedí lɩɩrɛ́ kʊ́bɔńɖɛ nɔɔ́-jɔ́. ");
INSERT INTO kdh_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ngɛ baagba kpɩ́ɩ́rʊʊ́-daá bɛ́ndɛsɩ́ bɛ́nɖɛɛ́ Kapɛrɩnawʊ́m fáráńdɩ́. Kíńÿúu ngʊ́ Yeésu tɔkɔnɩ tá ɩmɔɔná wɛ. ");
INSERT INTO kdh_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Fefelimá kʊ́bɔná wɛ́nvɛtɩ́ bɩka lɩ́m wángʊrʊ́ʊ bɩ́nzalɩ́ɩ. ");
INSERT INTO kdh_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Bɛ́ńɖɛɛzɩ batála nyazɩ kilomɛ́ɛ́tawá natʊ́nʊ́wá bɩlɛ́ gɛ baajáŋ bana Yeésu wánganʊŋ́ lɩ́m-rɔ ɩgɛrɛŋɛ sɩ ɩcʊʊná kpɩ́ɩ́rʊʊ́. Ngɛ bɩɩlá wɛ nɩdáárɛ. ");
INSERT INTO kdh_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ńna gɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Mɔ́ɔ́ gɛ, bɩ́kalá mɩ́ɩ nɩdáárɛ!» ");
INSERT INTO kdh_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Bɔɔzɔ́ɔ́lɩ sɩ bɔkpɔ́ɔ yɩ kpɩ́ɩ́rʊʊ́-daá. Amá, sɩ bacáŋ bɛbɛ́ɛ́ŋ nɛ́, kpɩ́ɩ́rʊʊ́ wáńdálɩ́ baɖaaboɖé kɩsɩ́ŋ. ");
INSERT INTO kdh_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kiivé nɛ́, zamɔ́ɔ kɩɩgáwalɩ́ lɩɩrɛ́ kʊ́bɔńɖɛ-dɛ́ɛ fúu lí ńgɩ nɛ́ kɩɩna sɩsɩ kpɩ́ɩ́rʊʊ́ kʊ́ɖʊmʊ́ʊ kóŋ́ wáńgáná kɩzɩ́ŋɛ́ɛ; bɩka banyɩ bɩlɛ́ ɖʊɖɔ sɩsɩ Yeésu tasʊ́ʊ kpɩ́ɩ́rʊʊ́ kɩḿ ɩ́na ɩwanbaaráa; bɛlɛ́ beriké bɛɛɖɛɛ ná. ");
INSERT INTO kdh_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ngʊ́ kpɩ́ɩ́rɩ́nɩ tɩɩgálɩ́ɩ́ná Tiberíyáadɩ nɛ́ tɩɩdála ɖɩdáarɛ wenɖé ɖɩdaá ɩráa wɔɔjɔ́ɔ bɔtɔ́ɔ kpɔ́nɔ́ Ɖádʊ́ʊ waazá Ɩsɔ́ɔ kɩrɔ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Zamɔ́ɔ waana sɩsɩ Yeésu na ɩwanbaaráa bɛvɛ́yɩ́ ńna nɛ́, ngɛ ɩráa waagba kpɩ́ɩ́rɩ́nɩ tɩḿ tɩdaá bɛɖɛ́ɛ Kapɛrɩnawʊ́m Yeésu cáádɩ. ");
INSERT INTO kdh_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Bɔɔmɔɔná Yeésu lɩɩrɛ́ kʊ́bɔńɖɛ-dɛ́ɛ fúu lí ńgɩ nɛ́, ngɛ bɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Kʊ́bɔnɩ́, sáátɩ wenkí gɛ nyáádála cé.» ");
INSERT INTO kdh_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Ménveerím mɩ́ɩ toovonúm sɩsɩ kpɔ́nɔ́wá mɩ́ɩ́dɔ́ɔ ɩfɔ́ɔ nɛ́-rɔɔzɩ́ gɛ mɩ́njáádɩ ma, bɩdɛkɛ́ɛ sɩsɩ mɩ́ɩ́nɩ́ɩ maamááciwá máálá tɩ nɛ́ tugutoluú nɛ́-rɔ. ");
INSERT INTO kdh_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ɩ́kalá tɩmɛ́rɛ kíɖíím bɩ́nvɔrɔ́sɩ nɛ́ bʊrɔ. Amá, ɩlá tɩmɛ́rɛ kíɖíím bɩ́dɔ́nvɔrɔ́sɩ kɛtɛngɛrɛ, bɩka bɩ́nváa weezuú kɩ́dɛ́ndɛŋ́ nɛ́ bʊrɔ. Ɩrʊ́ Biyaalʊ́ sɩ ɩfa ná mɩ́ɩ kíɖíím bɩḿ, káma, ɩrɔɔzɩ́ gɛ Ɩsɔ́ɔ Caáwʊ waaɖʊ ɩdɛ́ɛ yíko-dɛ́ɛ ɖaazɩ́tɩ.» ");
INSERT INTO kdh_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ńna gɛ ɩráa wɔɔbɔ́ɔ́zɩ Yeésu sɩsɩ: «We gɛ bɩ́nbɔɔzɩ́ ɖɩlá na ɖɩlá tɩmɛ́ weená Ɩsɔ́ɔ sɔɔlɛ́ɛ yɛ nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Tɩmɛ́rɛ wenɖé Ɩsɔ́ɔ sɔɔlɛ́ɛ na mɩ́ɩ nɛ́ gɛ sɩsɩ ɩ́fá weení weegédíri yɩ nɛ́ toovonúm.» ");
INSERT INTO kdh_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ńna gɛ bɛlɛ́ bɔɔbɔ́ɔ́zɩ yɩ sɩsɩ: «Maamááci wenkí gɛ sɩ nlá ɖɩna na ɖɩfa nya toovonúm. Tɩmɛ́rɛ wenɖé gɛ sɩ nlá. ");
INSERT INTO kdh_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ɖájaájaanáa wɔɔjɔ́ɔ tɛɛwʊ́lɔ́ɔ́-daá nɛ́, kíɖíím bánÿaá bɩ sɩsɩ máánɩnɛ́ gɛ beeɖi ńŋɩnáa wenbí baaŋmáa Ɩsɔ́ɔ-dɛ́ɛ Tɔ́m Tákaraɖá-daá nɛ́. Baaŋmáa gɛ sɩsɩ: “Waava wɛ kíɖíím bɩɩgálɩ́ɩ́ná ɩsɔ́ɔ́dáá nɛ́ beɖi.”» ");
INSERT INTO kdh_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ngɛ Yeésu woobúsi wɛ sɩsɩ: «Ménveerím mɩ́ɩ toovonúm sɩsɩ bɩdɛkɛ́ɛ Múúsá waava ná mɩ́ɩ kíɖíím bɩɩgálɩ́ɩ́ná ɩsɔ́ɔ́dáá bikédi nɛ́, amá, Majaa wánváa kʊ mɩ́ɩ kíɖíím toovonúm ńbɩ bɩ́ngalɩɩ́ ɩsɔ́ɔ́dáá nɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Káma, kíɖíím Ɩsɔ́ɔ wánváa bɩ nɛ́ gɛ weení wángalɩɩnáa ɩsɔ́ɔ́dáá bɩka wánváa ɖúúlínya weezuú nɛ́.» ");
INSERT INTO kdh_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ngɛ bɔɔdɔ́ yɩ sɩsɩ: «A bɩlɛ́, kʊ́bɔnɩ́, kʊ nlɔɔná ɖáa kíɖíím bɩḿ fáa!» ");
INSERT INTO kdh_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ngɛ Yeésu wɔɔdɔ́ wɛ sɩsɩ: «Mɔ́ɔ́ gɛ kíɖíím bɩ́nváa weezuú nɛ́. Weení ɩrɩ́ŋa wɔɔgɔ́nɩ mɔ́jɔ́ nɛ́, ɩlɛ́ ɩmʊ́ nyɔɔ́sɩ tángʊ́ʊ yɩ kɛtɛngɛrɛ, bɩka weení ɩrɩ́ŋa waava ma toovonúm nɛ́, ɖoolɔɔ́ tánlaḿ yɩ kɛtɛngɛrɛ. ");
INSERT INTO kdh_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Méévééri mɩ́ɩ bɩlɛ́ amá, na bɩrɩ́ŋa mɩ́ɩ́ná ma nɛ́, mɩ́dáfá ma toovonúm. ");
INSERT INTO kdh_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Wenbá barɩ́ŋa Caáwʊ waava ma nɛ́, bɔ́ngɔnɩ́ mɔ́jɔ́. Ngʊ́ bɩlɛ́ gɛ médéngizí weení ɩrɩ́ŋa sɩ ɩkɔ́nɩ mɔ́jɔ́ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Máagálɩɩ ɩsɔ́ɔ́dáá megédi adɛ laadɔ́ɔ-rɔɔzɩ́ gɛ sɩ malá weení weegédíri ma nɛ́ ɩdɛ́ɛ sɔɔlɩ́m; mɔ́dɔkɔ́nɩ sɩ malá wenbí mɔ́zɔɔlɛ́ɛ nɛ́. ");
INSERT INTO kdh_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Weení weegédíri ma nɛ́ ɩdɛ́ɛ sɔɔlɩ́m gɛ sɩsɩ mékeyéle wenbá waaɖʊ wɛ mɛ́ńdɛ́ nɛ́ badaá naárʊ ɩtɛlɛ́ŋ. Amá, kɛdɛɛzɩya wɩ́rɛ, magʊ́sɩ wɛ befé balɩ́ɩ ɩsɩɖáa-daá. ");
INSERT INTO kdh_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ɩɩ́n, wenbí Majaa sɔɔlɛ́ɛ bɩ nɛ́ gɛ sɩsɩ wenbá barɩ́ŋa baana Biyaalʊ́ʊ ngɛ baava yɩ toovonúm nɛ́, boyuú weezuú kɩ́dɛ́ndɛŋ́ nɛ́, bɩka kɛdɛɛzɩya wɩ́rɛ nɛ́, magʊ́sɩ wɛ b