﻿USE sofia;
DROP TABLE IF EXISTS sofia.kde_vpl;
CREATE TABLE kde_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kde_vpl WRITE;
INSERT INTO kde_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Anepo patandi, Nnungu áumbile kumahunde na chilambo. ");
INSERT INTO kde_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Chilambo nanga pachinavele na liumbo na chívele chihi nanga chinu. Chilambo chíhunikwije na medi lohe namene na lupi ludimbîje pii, na Umumu wa Nnungu nkuva avèlè muha medi. ");
INSERT INTO kde_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Nnungu nkuhaula kuchidoni, “Pààve nng'anji!” Nng'anji nkupwawa. ");
INSERT INTO kde_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Nnungu nkwona kuva anewo nng'anji nni chinu chambone. Anepo Nnungu nkuhapulanya nng'anji na lupi. ");
INSERT INTO kde_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Nnungu nkuuchema nng'anji “Muhi,” na lupi nkuluchema “Chilo.” Bahi nkuva muhi, na nkuva chilo. Na anelyo lyávele liduva litandi. ");
INSERT INTO kde_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Nnungu nkuchidoni, “Pààve na nafasi ching'ati medi. Nafasi aneyo ilayavanye medi mibali mivili, yani muha na pahi.” ");
INSERT INTO kde_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Bahi nkuva muchi chahawile. Nnungu nkuvika nafasi ya kulayavanya medi lavêle muha na medi lavêle pahi. ");
INSERT INTO kde_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Nnungu nkuichema aneyo nafasi, “Kumahunde.” Bahi nkuva muhi, na nkuva chilo. Na anelyo lyávele liduva lyavili. ");
INSERT INTO kde_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Nnungu nkuchidoni, “Medi lavêle pahi lalilopolele pamo, uchinga paonekane pachinu pakávele medi.” Bahi nkuva muchi chahawile. ");
INSERT INTO kde_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Nnungu nkupachema pachinu pakávele medi “Chilambo,” na muchinu amula mulopokedile medi nkumuchema “Dibahali.” Bahi Nnungu nkwona kuva anecho chachitendile nni chinu chambone. ");
INSERT INTO kde_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Bahi Nnungu nkuhaula kuchidoni, “Chilambo chimeje kila aina ya mimea, mimea ivêle na dimbeyu, na milandi îpa vihepo vivêle na dimbeyu dya namuna yake.” Bahi nkuva muchi chahawile. ");
INSERT INTO kde_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Chilambo nkumeja mimea ivêle na dimbeyu dya namuna yake, na milandi îpa vihepo vivêle na dimbeyu dya namuna yake. Bahi Nnungu nkwona kuva anecho chachitendile nni chinu chambone. ");
INSERT INTO kde_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Bahi nkuva muhi, na nkuva chilo. Na anelyo lyávele liduva lyatatu. ");
INSERT INTO kde_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Nnungu nkuchidoni, “Kumahunde kùùve na ming'anje uchinga ihapulanye chilo na muhi. Ming'anje uyoyo ììve vimaiho vya kulanguja mahiku, na maduva na vyaka, ");
INSERT INTO kde_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","na ming'anje aneyo ivale aneko kumahunde uchinga ilangajije pachilambo.” Bahi nkuva muchi chahawile. ");
INSERT INTO kde_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Nnungu nkujuha ming'anje mivili mikulungwa, aula nng'anje nkulu namene ulangaje muhi na aula n'joko ulangaje chilo. Uchocho, Nnungu nkujuha na dinondwa. ");
INSERT INTO kde_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Nnungu nkuivika aneyo ming'anje kumahunde uchinga ilangaje pachilambo, ");
INSERT INTO kde_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ilangaje chilo na muhi na kuhapulanya nng'anje na lupi. Bahi Nnungu nkwona kuva anecho chachitendile nni chinu chambone. ");
INSERT INTO kde_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Bahi nkuva muhi, na nkuva chilo. Na anelyo lyávele liduva lya ncheche. ");
INSERT INTO kde_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Nnungu nkuchidoni, “Mmedi muumbale makuwa la viumbe vyomi, na vyuni viuluke kumahunde.” ");
INSERT INTO kde_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Bahi Nnungu nkuvaumba anyama vakulu namene va m'bahali na aina dyammalele dya viumbe vyomi viônga mmedi. Uchocho, nkuumba na aina dyammalele dya vyuni. Bahi Nnungu nkwona kuva anecho chachitendile nni chinu chambone. ");
INSERT INTO kde_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Nnungu nkuvibaliki wachidoni, “Velekana, na kuyenjejeka. Viumbe vya m'bahali viumbale m'bahali, na vyuni viyenjejeke pachilambo.” ");
INSERT INTO kde_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Bahi nkuva muhi, na nkuva chilo. Na anelyo lyávele liduva lya nnyano. ");
INSERT INTO kde_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Nnungu nkuchidoni, “Chilambo chììve na aina dyammalele dya viumbe vivêle na umi, yani anyama va kulangwa na va munnyitu na vakoko.” Bahi nkuva muchi chahawile. ");
INSERT INTO kde_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Nnungu nkuumba kila aina ya anyama va kulangwa na va munnyitu na vakoko. Bahi Nnungu nkwona kuva anecho chachitendile nni chinu chambone. ");
INSERT INTO kde_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Anepo Nnungu nkuchidoni, “Tummumbe munu kwa nfano wetu, alandane na hwetu uchinga atawale dihomba dya m'bahali na vyuni viulûka kumahunde na anyama vammalele va kulangwa na anyama vammalele va munnyitu na vakoko vammalele va pachilambo.” ");
INSERT INTO kde_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Bahi Nnungu nkummumba munu kwa nfano wake. Kwa nfano wake mwene Nnungu ámmumbile nnume na mmahe. ");
INSERT INTO kde_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Nnungu nkuvabaliki wavahaulila kuchidoni, “Velekana na muyenjejeke, muumbale pachilambo na kuchitawala. Uchocho, muvatawale ahomba va m'bahali, na vyuni viulûka kumahunde na kila chiumbe chivêle na umi chiônga pachilambo.” ");
INSERT INTO kde_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Anepo Nnungu nkuchidoni, “Lola, nangu nìmwing'anga kila mmea wa pachilambo uvêle na dimbeyu, na kila nnandi ûpa vihepo vivêle na dimbeyu uchinga vììve chakulya chenu. ");
INSERT INTO kde_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Na anevo anyama vammalele va nchilambo, na vyuni vyammalele viulûka kumahunde, na viumbe vyammalele viônga pachilambo, yani kila chiumbe chivêle na umi, chakulya chavo chìmbekuva mahamba lammalele la mimea.” Bahi nkuva muchi chahawile. ");
INSERT INTO kde_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Bahi Nnungu nkuvilola vyammalele vyaviumbele, nkwona kuva kila chinu chachitendile nni chambone namene. Bahi nkuva muhi, na nkuva chilo. Na anelyo lyávele liduva lya sita. ");
INSERT INTO kde_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Bahi chilambo na kumahunde na vyammalele vivêle anemwo, nkumalilika kuumbwa. ");
INSERT INTO kde_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Kabla likànahwika liduva lya saba Nnungu ávele amalidìlè madengo lammalele la kuumba. Bahi nniduva anelyo lya saba Nnungu nkuyewelela kukola madengo lake. ");
INSERT INTO kde_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Nnungu nkulibaliki liduva anelyo lya saba na kulitenda lììve kwajili yake mwene, kwa kuva, liduva anelyo Nnungu ániyewelela kukola madengo lake lammalele la kuumba. ");
INSERT INTO kde_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Bahi uvila njo chichiumbwije chilambo na kumahunde. Yahwe Nnungu paumbile chilambo na kumahunde, ");
INSERT INTO kde_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","nchilambo múvele bado mukanambimèlà chinu chohecho ing'anya Yahwe Nnungu ávele bado akanambichitonyèlà chilambo imbula, na wala nanga panapwawije munu wa kulima. ");
INSERT INTO kde_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Henga medi lachihuma mmimbwimbwi njo lachiulovya ulongo wa nchilambo. ");
INSERT INTO kde_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Bahi Yahwe Nnungu nkummumba nnume kwa litutunga lya ulongo, nkummehija dimumu dya umi n'dimula dyake, na aneyo munu nkuva chiumbe chivêle na umi. ");
INSERT INTO kde_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Bahi Yahwe Nnungu nkuvika bustani m'bali wa mashaliki, kueneo lichêmwa Adeni, na m'bustani aneyo nkummika ayula munu wammumbile. ");
INSERT INTO kde_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Anepo Yahwe Nnungu nkumeja kila namuna ya nnandi ukatapêle na ufâa kwa chakulya. Na ching'ati bustani aneyo pávele na milandi inji mivili ya vihepo. Vihepo vya nnandi umo vìvatenda vanu vààve na umi ukee na ntululilo, na vihepo vya nnandi unji vìvatenda vanu vààve na uweso wa kupembula mambo lambone na lahakalenge. ");
INSERT INTO kde_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Aneko ku Adeni kúvele na muto uchimwadilangila medi lake m'bustani aneyo, na kutandikila pabustani aneyo muto nkuyavanyika kuva myuto ncheche. ");
INSERT INTO kde_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Lina lya muto ntandi nni Pishoni. Muto anewo ùdinguka chilambo chammalele cha Havila, chilambo chivêle zahabu. ");
INSERT INTO kde_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Sahabu ya chilambo anecho nni yambone namene. Uchocho, nchilambo anecho mùvele malashi la bedola na mayanga lakatapêle la shohamu. ");
INSERT INTO kde_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Na muto wavili ùchemwa Gihoni. Muto anewo ùdinguka nchilambo chammalele cha Kushi. ");
INSERT INTO kde_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Na muto watatu ùchemwa Tigili. Muto anewo ùkululila m'bali wa mashaliki wa imanga ya Ashulu. Na muto wa ncheche ùchemwa Eflati. ");
INSERT INTO kde_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Bahi Yahwe Nnungu nkuntwala ayula nnume nkummika M'bustani ya Adeni uchinga ailime na kuichunga. ");
INSERT INTO kde_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Yahwe Nnungu nkumwamulisa ayula nnume wachidoni, “Unahulula chihi kulya vihepo vya nnandi wohewo wa m'bustani, ");
INSERT INTO kde_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","henga vihepo vya nnandi wa kupembula mambo lambone na lahakalenge unalye, kwa kuva, liduva lyumbekulya vihepo vya nnandi anewo, muhiu uchiuhwe.” ");
INSERT INTO kde_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Anepo Yahwe Nnungu nkuchidoni, “Chikee chinu chambone ayu nnume kuva weka. Nìmbemmumbila nkúyangata ambenfâla.” ");
INSERT INTO kde_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Bahi Yahwe Nnungu nkummumba kwa ulongo kila nnyama wa munnyitu na kila chuni chiulûka kumahunde, nkumpelekejija ayula nnume uchinga alole chambevachema. Na malina lávichemìlè viumbe anevyo, nkuva njo malina lavo. ");
INSERT INTO kde_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Bahi ayula nnume nkuvachema malina anyama vammalele va kulangwa, na anyama va munnyitu na vyuni vyammalele viulûka kumahunde. Henga aneyo nnume nanga panammwene nkúyangata ambenfâla. ");
INSERT INTO kde_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Bahi Yahwe Nnungu nkunnaja ayula nnume luwono luidôpa, pánavele nkwona luwono, Nnungu nkuhalamola luvau lumo lwa aneyo nnume, na pachinu apala pahalamwele luvau nkupahunika kwa inyama. ");
INSERT INTO kde_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Bahi alula luvau lwaholomwene kuhaloka kwanga nnume, Yahwe Nnungu nkulujuha kuva mmahe, nkumpelekeja ayula mmahe kwanga ayula nnume. ");
INSERT INTO kde_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Anepo aneyo nnume nkuchidoni, “Enhee, ayuno njo angufâla! Ayuno nni liwangwa kuhaloka mmawangwa langu, na inyama kuhaloka muinyama yangu. Ayuno àmbechemwa ‘Mmahe,’ kwa kuva, àhumile mwang'une ninnume.” ");
INSERT INTO kde_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Njo mana nnume ànneka atatake na anyokwe, nkulundana na n'jawe, na anevo vavili vààva mmili umo. ");
INSERT INTO kde_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Bahi aneyo nnume na n'jawe vammalele vávele chihi lukundu mwandu, henga wala nanga pávanawene dihoni. ");
INSERT INTO kde_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Nnyongo ávele na ulamba kuvapunda anyama vammalele va munnyitu vanavaumbile Yahwe Nnungu. Bahi nnyongo nkunnyaulila ayula mmahe kuchidoni, “Ati muhiu kuva Nnungu áhawile kuva munalye vihepo vya nnandi wohewo wa m'bustani?” ");
INSERT INTO kde_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Mmahe nkunnyang'ula ayula nnyongo kuchidoni, “Nanga, tùnahulula chihi kulya vihepo vya milandi ivêle m'bustani, ");
INSERT INTO kde_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","henga Nnungu áhawile kuva, tunalye vihepo vya nnandi uvêle ching'ati bustani, na wala tunaukwahe, na tukàtenda uchocho tùmbekuhwa.” ");
INSERT INTO kde_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Nnyongo nkunnyaulila mmahe kuchidoni, “Mmh! Nanga pamumbekuhwa! ");
INSERT INTO kde_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Nnungu áhawile uchocho kwa kuva ànimala kuva mukàlya vihepo vya nnandi anewo ding'ano dyenu dichidihunukuliwe, na mwenu mùmbekuva muchi mwene Nnungu kwa kumala lambone na lahakalenge.” ");
INSERT INTO kde_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Bahi mmahe pawene kuva vihepo anevyo vìnafala namene kwa chakulya, na vìnautila mmeho na vìnafala kwa kupata lúnda, nang'e nkuhepa chihepo cha nnandi anewo, nkulya, nkumwing'a na nng'andomwe anavele nawe pamo, nanang'e nkulya. ");
INSERT INTO kde_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Upala vammalele nkuhunukuliwa ding'ano, nkulimala kuva vàvele chihi lukundu mwandu, bahi nkutota mahamba la nnandi wa tini la kulikuhikija. ");
INSERT INTO kde_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Bahi chinalyulo, mpapa pauchipunga, ayula nnume na n'jawe nkupilikana dihinji dya Yahwe Nnungu waonga m'bustani, vanang'o nkulipiha mmilandi ya m'bustani kuchinga Yahwe Nnungu anavone. ");
INSERT INTO kde_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Henga Yahwe Nnungu nkunchema ayula nnume na kummuja kuchidoni, “Ùvele kwachi?” ");
INSERT INTO kde_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Nang'e nkunnyang'ula kuchidoni, “Nangu ngúpilikene dihinji dyako m'bustani, nangu nkuyopa, nkulipiha, kwa kuva ngúvele lukundu mwandu.” ");
INSERT INTO kde_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Yahwe Nnungu nkummuja kuchidoni, “Nnani akuhaulidîle kuva úvele lukundu mwandu? Dachi, ùlile chihepo cha nnandi chinikulimbijije unalye?” ");
INSERT INTO kde_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ayula nnume nkuyang'ula kuchidoni, “Ayu mmahe úngupèlè aikale pamo na nangu njo angupêle chihepo cha nnandi anewo, nangu nkulya.” ");
INSERT INTO kde_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Anepo Yahwe Nnungu nkummuja ayula mmahe kuchidoni, “Chinu ntwani achino chiuchitendile?” Mmahe nkuyang'ula kuchidoni, “Nnyongo áningulambila, nangu nkulya.” ");
INSERT INTO kde_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Bahi Yahwe Nnungu nkunnyaulila nnyongo kuchidoni, “Kwa kuva wako ùtendile uchocho, bahi ùnilaniwa kupunda anyama vammalele valângwa, na kupunda anyama vammalele va munnyitu. Ùmbekwava kwa litumbo lyako, na kuwila litutunga maduva lammalele la umi wako. ");
INSERT INTO kde_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nìmbevika umongo kati yakuwe na ayu mmahe, kati ya chiveleko chako na vanu va nnukolo lwanga ayu mmahe. Na munu yumo muvanu va nnukolo lwake àmbeponda muti wako, na wako ùmbennuma aneyo munu chihing'ino chake.” ");
INSERT INTO kde_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Anepo nkunnyaulila ayula mmahe kuchidoni, “Nìmbekunonoheja uchungu wa kuveleka, ùmbevaveleka vana kwa uchungu. Henga, pamo na anelyo, wako ùmbekuva chihi nkuntamwa namene ntwalo, nanang'e àmbekutawala wako.” ");
INSERT INTO kde_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Anepo Yahwe Nnungu nkunnyaulila ayula nnume kuchidoni, “Kwa kuva wako ùmpilikanidile n'jalo, nkulya vihepo vya nnandi vinnakulimbijije unalye, bahi ulongo ùnilaniwa ing'anya yakuwe. Na wako ùmbelipatila chakulya kuhaloka muulongo anewo kwa kukola madengo lakamajanga namene, mmaduva lammalele la umi wako. ");
INSERT INTO kde_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ulongo ùmbemeja miva na lukwekwe kwajili yako, na wako ùmbekulya mahamba la mmwelu. ");
INSERT INTO kde_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Na ùmbelipatila chakulya kwa kukola madengo lakamajanga namene, mpaka paumbeuya muulongo mutwaliwije. Kwa kuva, wako úumbwije kwa litutunga, na uchiuile kavila kuva litutunga.” ");
INSERT INTO kde_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Bahi ayula nnume nkunchema n'jawe lina “Eva,” kwa kuva, àmbekuva mama wa vanu vammalele. ");
INSERT INTO kde_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Yahwe Nnungu nkunkatapajija Adamu na n'jawe mambende, nkuvawaja. ");
INSERT INTO kde_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Bahi Yahwe Nnungu nkuchidoni, “Vino vanu vàvele muchi mutuvelelee hwetu, kwa kulamala lambone na lahakalenge. Vino vàlembelewa vadivilwe kulya chihepo cha nnandi wa umi ukee na ntululilo, kwa kuva, vakàlya vàmbekuva na umi ukee na ntululilo. ");
INSERT INTO kde_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Bahi Yahwe Nnungu nkuvavingangila anevo vanu panda bustani ya Adeni, uchinga vakalime muulongo muvanatwaliwijwe. ");
INSERT INTO kde_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Nnungu pavavingangidile vanu panda bustani, nkuvivika viumbe vya kulihunde vivêle na dimapa, m'bali wa mashaliki wa Bustani ya Adeni pamo na upanga wa moto uchidinguka-dinguka nnyenje, kwa kuichunga indila ichihwena kunnandi wa umi ukee na ntululilo. ");
INSERT INTO kde_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Bahi Adamu nkulala na Eva n'jawe, Eva nkwikuta chitumbo, nkummeleka Kaini. Eva nkuchidoni, “Nìmmaleke munu kwa kuhululihwa na Yahwe.” ");
INSERT INTO kde_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Alafu nkummeleka Habilu, nnung'une Kaini. Habilu ávele nchunga wa dingandolo, na Kaini ávele nkúlima. ");
INSERT INTO kde_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Palanahwikile mahiku la lichela, Kaini nkunanhumija Yahwe sadaka ya vilyo kuhaloka mmwelu, ");
INSERT INTO kde_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","na Habilu nanang'e nkunhumija Yahwe sadaka ya vipande vya inyama ya angandolo vake vatandi kuvelekwa, vitumbwîle namene. Yahwe nkukatapaliwa namene na Habilu chalumo na sadaka yake, ");
INSERT INTO kde_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","henga Nnungu nanga panakatapaliwije na Kaini, wala sadaka yake. Bahi Kaini nkuvisa namene, nkukwinyilanya lyenye lyake. ");
INSERT INTO kde_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Yahwe nkunyaulila Kaini kuchidoni, “Ing'anya ntwani ùnivisa, na ing'anya ntwani ukwinyilanyije lyenye lyako? ");
INSERT INTO kde_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Dachi, ukàtenda lyambone ukámbekubaliwa? Na ukànatende lyambone, bahi sambi ìvenkukuvetela pannango pako, ìnakulembela namene, henga ùlembelewa uileme.” ");
INSERT INTO kde_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Anepo Kaini nkunnyaulila Habilu nnung'une kuchidoni, “Tuhwene kumawelu.” Bahi pavanavele kumawelu, Kaini nkunhavila Habilu nnung'une, nkummwalala. ");
INSERT INTO kde_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Bahi Yahwe nkummuja Kaini kuchidoni, “Nnung'uno Habilu àvele kwachi?” Kaini nkunnyang'ula kuchidoni, “Nangu nikámaite! Dachi, kwani nangu njo nchunga wa nnung'unwangu?” ");
INSERT INTO kde_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Anepo Yahwe nkuchidoni, “Ùtendile chamani? Myadi ya nnung'uno imwadilikidîle muulongo ìvenkungukutila. ");
INSERT INTO kde_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Hambi wako ùnilaniwa! Nanga chinu chohecho chiumbechipanda muulongo nkukulumuka. Kwa kuva, ulongo anewo ùnywejije myadi ya nnung'uno úmmwalèlè. ");
INSERT INTO kde_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Paumbelima muulongo, anewo ulongo nanga paumbemeja kavila vilyo kwajili yako. Ùmbekuva munu ukávele na kwenu na wakuhama-hama pachilambo.” ");
INSERT INTO kde_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kaini nkunnyaulila Yahwe kuchidoni, “Asabu yuning'ile nni ing'ulungwa namene, nikambehulula kuipililila. ");
INSERT INTO kde_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Lola, nelo ùninguvinganga nguuke paulongo wa matapata, nnaonekane pameho pako. Bahi nìmbekuva nimunu wakuhama-hama, nikávele na iikadi pachilambo, na munu woheyo ambengwôna àmbenguwalala.” ");
INSERT INTO kde_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Henga Yahwe nkunnyang'ula kuchidoni, “Nanga, ikámbekuva uchocho! Munu woheyo ambekuwalâla wako, munu aneyo àmbepindikulwa myanda saba.” Bahi Yahwe nkummika Kaini alama uchinga kila munu ambemwôna anammwalale. ");
INSERT INTO kde_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kaini nkuuka pameho pa Yahwe, nkuhwena unaikala nchilambo cha ku Nodi, chivêle m'bali wa mashaliki wa ku Adeni. ");
INSERT INTO kde_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Aneko, Kaini nkulala na n'jawe, na n'jawe nkwikuta chitumbo, nkummeleka Henoko. Kaini nkudenga imanga, nkuichema lina Henoko, lina lya mwanawe. ");
INSERT INTO kde_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Henoko nkummeleka Iladi. Iladi nanang'e nkummeleka Mehuyaeli, na Mehuyaeli nkummeleka Mesushaeli, na Mesushaeli nkummeleka Lameki. ");
INSERT INTO kde_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameki ávalombile vamahe vavili, yumo vánchema Ada na yunji vánchema Zila. ");
INSERT INTO kde_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada nkummeleka Yabali. Na Yabali njo ánavele anakulwao vanu vaikâla mmigongwe na kulanga. ");
INSERT INTO kde_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Nnung'une Yabali vánchema Yubali. Na Yubali njo ánavele anakulwao vanu vammalele vawômba ving'wenya-ng'wenya na vimbeta. ");
INSERT INTO kde_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zila nanang'e nkummeleka mwana wa chilume uvanchema Tubali-Kaini, ánavele nkúhana wa vyombo vyammalele vya chitale na shaba. Nnumbuwe Tubali-Kaini vánchema Nama. ");
INSERT INTO kde_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lameki nkuvahaulila ajavake kuchidoni, “Ada na Sila, ngupilikanile nangu! Pilikanila malove lángutangòlà na mwenu mmajavangu. Nangu nímmwalele kijana yumo ing'anya ya kunguchabolanga. ");
INSERT INTO kde_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ikàva munu ambemmwalâla Kaini àmbepindikulwa myanda saba, bahi muhiu kuva, munu ambemmwalâla Lameki àmbepindikulwa myanda sabini na saba.” ");
INSERT INTO kde_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adamu nkulala kavila na Eva n'jawe, Eva nkummeleka mwana wa chilume. Eva nkuchidoni, “Ayu mwana nìmbenchema lina Seti, ing'anya Nnungu àningujalila kumpata mwana yunji badala ya Habilu, awalêlwe na Kaini, nkuluwe.” ");
INSERT INTO kde_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seti nanang'e nkummaleka mwana wa chilume, nkunchema lina, Enoshi. Anepo njo vanu pavatandilike kunnyuwa Yahwe. ");
INSERT INTO kde_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Aino njo histoliya ya Adamu na vanu va nnukolo lwake. Nnungu pavaumbile vanu, ávaumbile malinga mwavelelee mwene Nnungu. ");
INSERT INTO kde_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ávaumbile nnume na mmahe, nkuvabaliki, nkuvachema lina, “Vanu.” ");
INSERT INTO kde_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adamu panavele na vyaka myamoja salasini, nkummaleka mwana ánavele mwavelelee mwene mwalehu, nkunchema lina Seti. ");
INSERT INTO kde_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Bada ya kummaleka Seti, Adamu nkuikala vyaka myanane. Na muvyaka anevyo, Adamu ánivaveleka vana vanji vachilume na vachimahe. ");
INSERT INTO kde_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Bahi Adamu áikele myaka myatisa salasini, nkuhila. ");
INSERT INTO kde_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seti panavele na vyaka myamoja na tano, nkummeleka Enoshi. ");
INSERT INTO kde_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Bada ya kummaleka Enoshi, Seti nkuikala vyaka myanane na saba. Na muvyaka anevyo, Seti ánivaveleka vana vanji vachilume na vachimahe. ");
INSERT INTO kde_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Bahi Seti áikele vyaka myatisa kumi na mbili, nkuhila. ");
INSERT INTO kde_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enoshi panavele na vyaka tisini, nkummaleka Kenani. ");
INSERT INTO kde_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Bada ya kummaleka Kenani, Enoshi nkuikala vyaka myanane kumi na tano. Na muvyaka anevyo, Enoshi nkuvaveleka vana vanji vachilume na vachimahe. ");
INSERT INTO kde_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Bahi Enoshi áikele vyaka myatisa na tano, nkuhila. ");
INSERT INTO kde_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenani panavele na vyaka sabini, nkummeleka Mahalaleli. ");
INSERT INTO kde_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Bada ya kummaleka Mahalaleli, Kenani nkuikala vyaka myanane alubaini. Na muvyaka anevyo, Kenani nkuvaveleka vana vanji vachilume na vachimahe. ");
INSERT INTO kde_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Bahi Kenani áikele vyaka myatisa na kumi, nkuhila. ");
INSERT INTO kde_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaleli panavele na vyaka sitini na tano, nkummaleka Yaledi. ");
INSERT INTO kde_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Bada ya kummaleka Yaledi, Mahalaleli nkuikala vyaka myanane salasini. Na muvyaka anevyo, Mahalaleli nkuvaveleka vana vanji vachilume na vachimahe. ");
INSERT INTO kde_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Bahi Mahalaleli áikele vyaka myanane tisini na tano, nkuhila. ");
INSERT INTO kde_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yaledi panavele na vyaka myamoja sitini na mbili, nkummeleka Henoko. ");
INSERT INTO kde_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Bada ya kummaleka Henoko, Yaledi nkuikala myaka myanane. Na muvyaka anevyo, Yaledi nkuvaveleka vana vanji vachilume na vachimahe. ");
INSERT INTO kde_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Bahi Yaledi áikele vyaka myatisa sitini na mbili, nkuhila. ");
INSERT INTO kde_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Henoko panavele na vyaka sitini na tano, nkummeleka Mesusela. ");
INSERT INTO kde_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Henoko ávele munu ánavele pepi namene nawi Nnungu. Bada ya kummaleka Mesusela, Henoko nkuikala vyaka myatatu. Na muvyaka anevyo, Henoko nkuvaveleka vana vanji vachilume na vachimahe. ");
INSERT INTO kde_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Bahi Henoko áikele vyaka myatatu sitini na tano. ");
INSERT INTO kde_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Henoko ávele munu ánavele pepi namene nawi Nnungu, na ániwalawala, kwa kuva, Nnungu ánintwala. ");
INSERT INTO kde_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Mesusela panavele na vyaka myamoja samanini na saba, nkummaleka Lameki. ");
INSERT INTO kde_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Bada ya kummaleka Lameki, Mesusela nkuikala vyaka myasaba samanini na mbili. Na muvyaka anevyo, Mesusela nkuvaveleka vana vanji vachilume na vachimahe. ");
INSERT INTO kde_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Bahi Mesusela áikele vyaka myatisa sitini na tisa, nkuhila. ");
INSERT INTO kde_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lameki panavele na vyaka myamoja samanini na mbili, nkummaleka mwana wa chilume. ");
INSERT INTO kde_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Lameki nkuchidoni,“Ayu mwana nìmbenchema lina Nuhu, kwa kuva àmbetutuja mitima ing'anya ya madengo lakamajanga latukola kwa makono letu muulongo auno waulanite Yahwe.” ");
INSERT INTO kde_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Bada ya kummaleka Nuhu, Lameki nkuikala vyaka myatano tisini na tano. Na muvyaka anevyo, Lameki nkuvaveleka vana vanji vachilume na vachimahe. ");
INSERT INTO kde_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Bahi Lameki áikele vyaka myasaba sabini na saba, nkuhila. ");
INSERT INTO kde_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nuhu panavele na vyaka myatano, nkummaleka Shemu, nkummaleka Yafeti, nkummaleka nawi Hamu. ");
INSERT INTO kde_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Bahi vanu pavatandilike kuyenjejeka pachilambo na kuvaveleka vana vachimahe, ");
INSERT INTO kde_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","viumbe fulani vinahaleke kulihunde nkuvona anevo vana va chimahe kuva vànikatapala, bahi nkulitomolelanga avala uvachivatamwa, nkuvajuha kuva ajavao. ");
INSERT INTO kde_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Anepo Yahwe nkuchidoni, “Nikambeleka imumu yangu ya umi ììkale nkati mwanga munu maduva lammalele, kwa kuva nang'e nni munu chihi wa kuhwa. Bahi munu akámbelama vyaka vipûnda myamoja na ishilini.” ");
INSERT INTO kde_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Bahi mmahiku anelo, na lapapête, pachilambo pávele na vanu maluchi lalepîle namene, vanavelekwejije kuhalokana na ulombi wa avala viumbe na avala vana va chimahe. Anevo vanu maluchi váchemwa “Vanefili,” na nni vanu vanavele ang'ondo vavêle na dimongo namene vanapwawije anepo kala, na nni vanu vachimaikana namene. ");
INSERT INTO kde_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Yahwe pawene kuva mambo lahakalenge làvenkuhalija kuyenjejeka pachilambo, na kuva kila chinu chakudungila munu muisungu yake chììva chihi chibaya mmaduva lammalele, ");
INSERT INTO kde_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Yahwe nkulihamola namene kwa kummumba munu pachilambo, na muntima mwake nkuva na lihindambi. ");
INSERT INTO kde_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Bahi nkuchidoni, “Nìmbevaondonganga mwalehu vanu univaumbile, vanapwawe pachilambo. Uchocho, nìmbevaondonganga na anyama vammalele na vakoko na vyuni viulûka kumahunde. Kwa kuva, nahinginika kwa kuvaumba.” ");
INSERT INTO kde_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Henga Yahwe nkukatapaliwa nawi Nuhu. ");
INSERT INTO kde_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Aino njo histoliya yanga Nuhu na vanu va nnukolo lwake. Nuhu ávele munu achilatenda àlalá lalalembela Nnungu, na ávele munu akánavele na likosa ching'ati vanu va mmaduva anelo, na ávele munu anavele pepi namene nawi Nnungu. ");
INSERT INTO kde_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuhu ávele na vana vatatu vachilume, Shemu, Yafeti nawi Hamu. ");
INSERT INTO kde_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Nnungu áchiwene chilambo kuva chìniondongeka na chìumbele chihi ukatili, ");
INSERT INTO kde_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","yani áchiwene chìniondongeka mwalehu, kwa kuva kila munu àtenda chihi lahakalenge. ");
INSERT INTO kde_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Nnungu nkunnyaulila Nuhu kuchidoni, “Nìmbeviondonganga viumbe vyammalele kwa kuva, chilambo chammalele chìumbele ukatili ing'anya ya vanang'o. Muhiu, nìmbevaondonganga mwalehu pamo na chilambo! ");
INSERT INTO kde_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Bahi likatapajije safina ya mbao dya mvinje. Yavanya vyumba nkati mwake na uipakalange lami, nkati na pawelu uchinga medi lanainjile nkati. ");
INSERT INTO kde_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ikatapaje safina ivêle na ulehu wa futi myanne na amsini, na upana wa futi sabini na tano na changa cha futi alubaini na tano. ");
INSERT INTO kde_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Aneyo safina ììve ya galofa tatu na ììve na nnango nnuvau. Tununa muha, na uleke mwanya wa ding'olokoto uvêle na ulehu malinga wa futi moja na nusu kati ya nakatene na likangala, mmipata yammalele ya safina. ");
INSERT INTO kde_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Nìmbekwida na livambwe uchinga nguondongange viumbe vyammalele vya pachilambo. Kila chiumbe chivêle na umi pachilambo chìmbekuhwa. ");
INSERT INTO kde_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Henga nìmbetenda lilailano lyangu na wako. Ùmbeinjila nsafina, wako pamo na n'jalo na vana vako pamo na ajavao. ");
INSERT INTO kde_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Na kila aina ya viumbe vivêle na umi viinjije nsafina vivili-vivili, yani nannume na mmahe, uchinga uvachunge vààve vomi chalumo na wako umwene. ");
INSERT INTO kde_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Kila aina ya chuni na nnyama na kila aina ya nkoko, vachivaide kwakuwe vavili-vavili, uchinga vachungwe, vanahwe. ");
INSERT INTO kde_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Uchocho, twala aina dyammalele dya vilyo, uvikondye uchinga vììve chakulya chenu na cha anevyo viumbe.” ");
INSERT INTO kde_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Bahi Nuhu nkutenda lammalele malinga chalaijijwe na Nnungu. ");
INSERT INTO kde_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Yahwe nkunnyaulila Nuhu kuchidoni, “Injila nsafina, wako pamo na vanu vammalele va nng'ande mwako, kwa kuva muvanu va chívelèkwà achino, nangu nìkuwene chihi wako weka kuva umunu utênda àlalá lángulembèlà. ");
INSERT INTO kde_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Vatwale anyama vammalele halali, vachilume saba na vachimahe saba, henga anyama halamu vatwale vachilume vavili na vachimahe vavili. ");
INSERT INTO kde_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Uchocho, vitwale vyuni viulûka kumahunde vya kila aina, vyachilume saba na vyachimahe saba. Tenda uchocho kwajili ya kukondya mipandani ya aina dya anyama na vyuni anevyo, pachilambo. ");
INSERT INTO kde_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Bada ya maduva saba, nìmbetonya imbula pachilambo maduva alubaini, chilo na muhi, na kila chiumbe chivêle na umi chinichiumbile pachilambo nìmbechiondonganga.” ");
INSERT INTO kde_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Bahi Nuhu nkutenda lammalele malinga chalaijijwe na Yahwe. ");
INSERT INTO kde_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Livambwe paliidile pachilambo, Nuhu ávele na myaka myasita. ");
INSERT INTO kde_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nuhu na n'jawe na vana vake na ajavao nkuinjila nsafina uchinga valinyemye na livambwe. ");
INSERT INTO kde_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Bahi anyama halali na anyama halamu na vyuni na viumbe vyammalele viônga pachilambo, ");
INSERT INTO kde_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","vyachilume na vyachimahe, nkuida kwanga Nuhu, nkuinjila nsafina malinga Nnungu chamwamulisije Nuhu. ");
INSERT INTO kde_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Bada ya maduva saba, medi la livambwe nkutandilika kuchihunika chilambo. ");
INSERT INTO kde_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nuhu panavele na vyaka myasita, nniduva lya kumi na saba lya mwedi wa vili, liduva anelyo vimbwimbwi vyammalele vya pahi chilambo nkulipuha medi, na medi lavêle kumahunde nkukung'unikila pachilambo. ");
INSERT INTO kde_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Bahi imbula nkutonya pachilambo kwa maduva alubaini, chilo na muhi. ");
INSERT INTO kde_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Nniduva ulyolyo imbula paitandilike kutonya, Nuhu na n'jawe na vana vake, Shemu, Yafeti na Hamu pamo na ajavao, nkuinjila nsafina. ");
INSERT INTO kde_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Anemwo nsafina váinjidile vene pamo na aina dyammalele dya anyama va munnyitu na aina dyammalele dya anyama va kulangwa na aina dyammalele dya vakoko vaônga pachilambo na vyuni vya kila aina, na kila chiumbe chivêle na dimapa. ");
INSERT INTO kde_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Bahi viumbe vyammalele vya kila aina nkuida kwanga Nuhu, nkuinjila nsafina, vivili-vivili. ");
INSERT INTO kde_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Kila aina ya viumbe anevyo víinjidile nannume na mmahe malinga Nnungu chanamwamulisije Nuhu. Bahi Nuhu pamalilikidile kuinjila nsafina, Yahwe Nnungu nkuchima nnango. ");
INSERT INTO kde_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Imbula ítonyile maduva alubaini, na livambwe nkuhalija kuyenjejeka pachilambo. Medi nkuyenjejeka namene mpaka safina kunyanyulwa muha namene mwa chilambo. ");
INSERT INTO kde_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Medi nkuhalija kuyenjejeka namene ulehu, na safina nkuva uielea muha mwake. ");
INSERT INTO kde_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Anelo medi nkuva lohe namene muha chilambo mpaka machinga lammalele malehu la pachilambo nkuhunikwa. ");
INSERT INTO kde_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Medi lániyenjejeka mpaka kuhunika machinga na kulapunda, malinga ulehu wa futi ishilini na mbili. ");
INSERT INTO kde_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Bahi viumbe vyammalele vya pachilambo nkuhwanga, yani vyuni na anyama va kulangwa na anyama va munnyitu na vakoko vammalele vaônga pachilambo, na vanu vammalele. ");
INSERT INTO kde_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","23","Nnungu ániviondonganga viumbe vyammalele vivêle na umi vya nchilambo, yani vanu na vanyama na vakoko vaônga pachilambo na vyuni vyammalele. Na nanga chiumbe chinalekwije chivèlè chomi ikànave chihi Nuhu na vanji vanavele nsafina. ");
INSERT INTO kde_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Medi anelo lánitanda pachilambo kwa uhiku wa maduva myamoja na amsini. ");
INSERT INTO kde_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Nnungu nanga panannuvalidile Nuhu na anyama vammalele va munnyitu, na va kulangwa vanavele chalumo nanang'e nsafina. Bahi Nnungu nkupungiha lipungo pachilambo chammalele, na medi nkutandilika kunywenyelekela. ");
INSERT INTO kde_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Vimbwimbwi vya medi, na medi lachikung'unika kuhaloka kumahunde nkunyalajwa. ");
INSERT INTO kde_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Medi nkuhweneha kunywa kadiki-kadiki nchilambo. Bada ya maduva myamoja na amsini, medi nkunywa namene. ");
INSERT INTO kde_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Nniduva lya kumi na saba lya mwedi wa saba, safina nkunatula kumachinga la Alalati. ");
INSERT INTO kde_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Medi nkuhweneha kupungula kadiki-kadiki, na nniduva litandi lya mwedi wa kumi, visweswe vya machinga nkutandilika kwonekana. ");
INSERT INTO kde_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Bada ya maduva alubaini, Nuhu nkuchimula lidilisha lyanakatapajije nsafina aneyo, ");
INSERT INTO kde_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","nkunhumya nankonda pawelu, henga nankonda nanga panauyite, nang'e ápite chihi wanachiuluka-uluka mpaka uhiku aula medi palanywele nchilambo. ");
INSERT INTO kde_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Bahi Nuhu nkunhumya umunda pawelu uchinga apate kumala ikàva medi làninywa. ");
INSERT INTO kde_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Henga kwa kuva medi lávele bado lakànambikunywa, ayula umunda nanga panawene pachinu pakutulila, bahi nkuuya kwanga Nuhu nsafina. Nuhu nkunyoloja nkono wake nkuntwala ayula umunda nkunnyinjija nsafina. ");
INSERT INTO kde_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nuhu nkulindilila kwa maduva lanji saba, nkunhumya kavila ayula umunda. ");
INSERT INTO kde_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Chinalyulo ayula umunda nkuuya kwanga Nuhu akuno apambìlè pakanya pake lihamba livihi lya nnandi wa nzeituni. Bahi Nuhu nkumala kuva medi lànipungula nchilambo. ");
INSERT INTO kde_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Nuhu nkulindilila kwa maduva lanji saba, nkunhumya kavila ayula umunda, mwanda anewo ayula umunda nanga panauite kavila kwanga Nuhu. ");
INSERT INTO kde_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nuhu panavele na vyaka myasita na moja, liduva litandi lya mwedi ntandi, medi lávele lanywèlè nchilambo. Anepo Nuhu nkuchihunukula chihuniko cha safina, na palolite pawelu, nkwona medi lanywèlè mwalehu nchilambo. ");
INSERT INTO kde_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Liduva lya ishilini na saba lya mwedi wavili, chilambo chívele chiyumìlè mwalehu. ");
INSERT INTO kde_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Bahi Nnungu nkunnyaulila Nuhu kuchidoni, ");
INSERT INTO kde_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Huma nsafina, wako pamo na n'jalo na vana vako na ajavao. ");
INSERT INTO kde_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Na vihumye pawelu viumbe vyammalele, yani vyuni na anyama na vakoko vammalele vaônga pachilambo uchinga vapate kuvelekana namene na kuyenjejeka na kuyanjala pachilambo chammalele.” ");
INSERT INTO kde_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Bahi Nuhu nkuhuma nsafina, nang'e pamo na n'jawe na vana vake na ajavao. ");
INSERT INTO kde_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Uchocho, viumbe vyammalele vivêle na umi nkuhumananga kupapatana na aina dyake, yani anyama vammalele na vakoko vammalele vaônga pachilambo na vyuni vyammalele vya pachilambo. ");
INSERT INTO kde_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nuhu nkun'dengela Yahwe chitala, nkuntwala nnyama yumo-yumo kuhaloka nnikuwa lya kila aina ya anyama halali na kuhaloka nnikuwa lya kila aina ya vyuni halali, nkunhumija Nnungu sadaka ya kuipija moto pachitala. ");
INSERT INTO kde_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Liumba lya kunung'ila lya sadaka aneyo nkunkatapalila Yahwe, nkutangola chimunda-munda kuva, “Nikambechilani kavila chilambo ing'anya ya vanu. Nangu ǹnimala kuva mawaso lavo lànihakalanga kutandikila ujoko wavo. Mwiko nikambeuila kavila kuviondonganga viumbe vyammalele malinga chíngutendìlè. ");
INSERT INTO kde_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Bahi mahiku la kupanda na la kuvuna, na mahiku la chipwepwe na la chitukuta, na mahiku la chihuku na la chambu, chilo na muhi, anevyo vyammalele vìmbekuva chihi nkupwawa mpaka ntululilo wa chilambo.” ");
INSERT INTO kde_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Nnungu nkum'baliki Nuhu na vana vake wannyaulila kuchidoni, “Velekana, na muyenjejeke mukachiumbaje chilambo. ");
INSERT INTO kde_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Anyama vammalele va pachilambo na vyuni vyammalele na viumbe vyammalele viônga pachilambo na ahomba vammalele va m'bahali, vàkamujijwe mmakono lenu, vanang'o vàmbennyopanga namene mwenu. ");
INSERT INTO kde_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Viumbe vyammalele vivêle na umi vìmbekuva chakulya chenu malinga chinimpelenge dimbowa dya mahamba kuva chakulya chenu. ");
INSERT INTO kde_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Henga munamulye nnyama bila kumwadila myadi yake, kwa kuva umi ùvele mmyadi. ");
INSERT INTO kde_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","6","Nangu nìmmumbile munu kwa nfano wangu nimwene, bahi nguchinimwasibu nnyama woheyo au munu woheyo ambemmwalâla munu. Ikàva nnyama àmbemmwalala munu, aneyo nnyama lasima awalalwe. Na ikàva munu àmbemmwalala munu nnyake, aneyo munu lasima awalalwe. ");
INSERT INTO kde_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Bahi mwenu velekanga na muyenjejeke, velekanga namene, muyenjejeke pachilambo.” ");
INSERT INTO kde_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Bahi Nnungu nkunnyaulila Nuhu pamo na vana vake kuchidoni, ");
INSERT INTO kde_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Lola, nangu ngùtenda lilailano lyangu na mwenu pamo na vanu va nnukolo lwenu, ");
INSERT INTO kde_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","na viumbe vyammalele vivêle na umi, yani vyuni na vanyama va kulangwa pamo na vanyama vammalele va munnyitu, vammalele vahumîle nsafina pamo na mwenu. ");
INSERT INTO kde_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Nangu ngùtenda lilailano lyangu na mwenu kuva, likambehumila kavila livambwe lya kwondonganga chilambo chammalele na viumbe vyammalele. ");
INSERT INTO kde_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Na ayi inyingamu inguivikile kumahunde, ìmbekuva chimaiho cha lilailano lingulitenda na mwenu na viumbe vyammalele vya pachilambo. Inyingamu ayi ichiinkumbusange mwenu kuva, pàvele lilailano kati yangu na mwenu, mmivelekwa vyammalele. ");
INSERT INTO kde_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Na ìmbekuva uvila, kila panimbetanda mahunde la imbula kumahunde, na aneyo inyingamu paimbeoneka aneko kumahunde, ");
INSERT INTO kde_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","anepo nguchingukumbukile lilailano lyangu língutendìlè pamo na mwenu na viumbe vyammalele. Na pakambekuva na livambwe lya kwondonganga viumbe vyammalele, mwiko. ");
INSERT INTO kde_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Aneyo inyingamu paimbehumila kumahunde, nìmbeyona na kulihimukila lilailano anelyo likee na ntululilo kati yangu na viumbe vyammalele vya pachilambo.” ");
INSERT INTO kde_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Anepo Nnungu nkunnyaulila Nuhu kuchidoni, “Achi njo chimaiho cha lilailano lyangu língutendìlè na viumbe vyammalele vya pachilambo.” ");
INSERT INTO kde_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Vana vanga Nuhu vanahumile nsafina nni, Shemu, Yafeti na Hamu. Na Hamu njo anavele atatake Kanaani. ");
INSERT INTO kde_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Anevo njo vana vatatu vanga Nuhu, na kuhalokana na vana anevo, vanu vániyenjejeka na kuyanjala pachilambo chammalele. ");
INSERT INTO kde_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Bada ya livambwe, Nuhu ávele nkúlima, na ávele munu ntandi kulima welu wa mizabibu. ");
INSERT INTO kde_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Liduva limo, Nuhu nkukumbila divayi, nkukalewa, nkulala chihi lukundumwandu mun'gongwe wake wachiikala. ");
INSERT INTO kde_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Bahi Hamu, atatake Kanaani, nkuwona mwandu wa atatake, nkuhuma pawelu nkunavahaulila avala akuluvake vavili. ");
INSERT INTO kde_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Henga Shemu na Yafeti nkutwala inguwo, nkuivika mmavala lavo, nkuhwena chihenganyuma, nkunammimba atatawao. Meho lavo lálola chihi nnyenje, na wala nanga pavanauwene mwandu wa atatawao. ");
INSERT INTO kde_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Bahi Nuhu paunnyamwike wala, nkumala namuna chantendeledile mwanawe n'joko, ");
INSERT INTO kde_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","nkuchidoni, “Kanaani alanike! Àmbekuva ntumwa wa pahi namene wa akuluvake.” ");
INSERT INTO kde_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Nkuhaula kavila kuchidoni, “Yahwe, Nnungu wangu am'baliki Shemu! Na Kanaani ààve ntumwa wanga Shemu. ");
INSERT INTO kde_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Nnungu aidalambule mipaka yanga Yafeti, na Yafeti akumilane na Shemu na kuikala nawe pamo, na Kanaani ààve ntumwa wanga Yafeti.” ");
INSERT INTO kde_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Bada ya livambwe, Nuhu nkuikala vyaka myatatu amsini. ");
INSERT INTO kde_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Bahi Nuhu nkuikala vyaka myatisa amsini, nkuhila. ");
INSERT INTO kde_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Bada ya livambwe, vana vanga Nuhu, yani Shemu, Yafeti na Hamu, nkuvaveleka vavana. Na aino njo histoliya ya vanu va n'ding'olo dyavo. ");
INSERT INTO kde_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yafeti ámmeleke Gomeli na Magogu na Madayi na Yavani na Tubali na Mesheki na Tilasi. ");
INSERT INTO kde_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomeli nkummaleka Ashikenazi na Lifati na Togama. ");
INSERT INTO kde_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yavani nkummaleka Elisha na Talishishi na Kitimu na Lodanimu. ");
INSERT INTO kde_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Kuhalokana na vana anevo vanga Yavani, nkuvelekwa vanu vohe vayanjêle mmilambo vya pwani ya bahali ya Meditelaniya na mmisiwa vyake. Anevo njo vanu va nnukolo lwanga Yafeti kupapatana na matawa lao na luga dyavo na ding'olo dyavo na vilambo vyao. ");
INSERT INTO kde_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Hamu ámmeleke Kushi na Misili na Puti na Kanaani. ");
INSERT INTO kde_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kushi nkummaleka Seba na Havila na Sabita na Laama na Sabiteka. Na Laama nkummaleka Sheba na Dedani. ");
INSERT INTO kde_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Uchocho, aneyo Kushi nkummaleka Nimlodi, anavele munu ntandi kuva mwing'ondo shujaa pachilambo. ");
INSERT INTO kde_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nimlodi ávele nkúlumbata nkulu kupunda vammalele pachilambo, njo mana pàvele na itangodi ivatangola vanu kuva, “Ayu munu àvele muchi Nimlodi, ayula nkúlumbata nkulu kupunda vammalele pachilambo.” ");
INSERT INTO kde_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Dimanga dinandi dyanatandilike kuditawala dyávele, Babeli na Eleku na Akadi na Kaline, nchilambo cha Babiloni. ");
INSERT INTO kde_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nimlodi paukile nchilambo anecho nkuhwena mpaka chilambo cha ku Ashulu, aneko nkunadenga imanga ya Ninawi na Lehobosi-Ili na Kala, ");
INSERT INTO kde_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","na Leseni. Na imanga ya Leseni yávele ching'ati imanga ya Ninawi na imanga ya Kala, na imanga ya Kala yávele imanga ing'ulu. ");
INSERT INTO kde_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Na Misili njo ánavele anakulwao Valudi na Vaanami na Valehabi na Vanafutuhi, ");
INSERT INTO kde_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","na Vapasilusi na Vakafutoli na Vakasiluhi. Na Vakasiluhi njo anakuluvao Vafilisti. ");
INSERT INTO kde_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaani nkummaleka Sidoni, mwanawe chihungula mikova. Na Sidoni njo anakulwao Vasidoni. Uchocho, Kanaani ávele anakulwao Vahiti, ");
INSERT INTO kde_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","na Vayebusi na Vaamoli na Vagiligashi, ");
INSERT INTO kde_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","na Vahivi na Vaaliki na Vasini, ");
INSERT INTO kde_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","na Valivadi na Vasemali na Vahamasi. Bahi lukoto, vanu va lukolo lwanga Kanaani nkuyanjala, ");
INSERT INTO kde_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","na lipalu lya chilambo chavo nkutandikila Sidoni kuloja m'bali wa kusini mpaka ku Gelali na ku Gaza. Na kutandikila Gaza kuloja m'bali wa mashaliki línihweneha mpaka ku Sodoma na ku Gomola na ku Adima na ku Seboimu, mpaka kuhwikila ku Lasha. ");
INSERT INTO kde_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Anevo njo vanu va nnukolo lwanga Hamu kupapatana na matawa lao na luga dyavo na ding'olo dyavo na vilambo vyao. ");
INSERT INTO kde_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Shemu nkuluwe Yafeti, nang'e ávele anakulwao vanu vammalele va nnukolo lwanga Ebeli. ");
INSERT INTO kde_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Shemu ámmeleke Elamu na Ashulu na Alifakisadi na Ludi na Alamu. ");
INSERT INTO kde_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Na Alamu nkummaleka Uzi na Huli na Geseli na Mashi. ");
INSERT INTO kde_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Alifakisadi nkummaleka Sela, na Sela nkummaleka Ebeli. ");
INSERT INTO kde_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebeli nkuvaveleka vana vavili vachilume, yumo nkunchema lina Pelegi, ing'anya mahiku anelo vanu vánimwadilihanyijwa pachilambo chammalele, na mwana yunji nkunchema Yokitani. ");
INSERT INTO kde_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yokitani nkummaleka Alimodadi na Selefu na Hazalimaweti na Yela, ");
INSERT INTO kde_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","na Hadolamu na Uzali na Dikla, ");
INSERT INTO kde_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","na Obali na Abimaeli na Seba, ");
INSERT INTO kde_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","na Ofili na Havila na Yobabu. Anevo vammalele nni anavake Yokitani. ");
INSERT INTO kde_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Vanu anevo váikelenge kutandikila ku Mesha mpaka ku Sefali, chilambo cha machinga chivêle m'bali wa mashaliki. ");
INSERT INTO kde_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Anevo njo vanu va nnukolo lwanga Shemu kupapatana na matawa lao na luga dyavo na ding'olo dyavo na vilambo vyao. ");
INSERT INTO kde_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Bahi aneyo njo histoliya ya vanu va n'ding'olo dya vana vanga Nuhu kupapatana na matawa lavo na vilambo vyao. Na bada ya livambwe, vanu anevo vániyanjala, na vanu va vilambo vyammalele vàhalokene na vanu va ding'olo anedyo. ");
INSERT INTO kde_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Mmahiku anelo vanu vammalele va pachilambo vávele chihi na luga imo, na vátangola chihi uchimo. ");
INSERT INTO kde_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Bahi vanu pavatandilike kuhwena-hwena kuloja m'bali wa mashaliki, nkuhwika nchilambo chikávele na machinga-machinga aneko ku Babiloni, nkuikalanga aneko. ");
INSERT INTO kde_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Bahi anevo vanu nkuhaulanila kuchidoni, “Hambi, tufyatule matofali koka tulayoche mmoto uchinga latandeke saana.” Bahi vanu anevo vátumidile matofali badala ya mayanga, na vátumidile lami kulundanyijija matofali anelo. ");
INSERT INTO kde_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Nkuhaulanila kavila kuchidoni, “ Hambi tuidenge imanga na nnala ulepîle namene, umbehwîka kumahunde uchinga tupate kumaikana na tunamwadilikane pachilambo chammalele.” ");
INSERT INTO kde_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Bahi Yahwe nkusulupuka kuhaloka kulihunde uchinga akailole aila imanga na anewo nnala uvachidenga vanu. ");
INSERT INTO kde_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Yahwe nkuhaula kuchidoni, “Ava vanu nni uvamo na vammalele nni vanu va luga imo, na anecho chivachitenda nni ntandiliko chihi wa àlalá lavambelatenda, bahi chinu chohecho chivambekudungila kuchitenda chichichitendeke. ");
INSERT INTO kde_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Bahi tusulupuke pachilambo tukaitimbange luga yavo uchinga vanapilikanane.” ");
INSERT INTO kde_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Bahi Yahwe nkuvamwadilihanyija kila pachinu, pachilambo chammalele, nkulekanga kuidenga aila imanga. ");
INSERT INTO kde_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Imanga aneyo nkuchemwa Babeli, kwa kuva, aneko njo Yahwe kwanatimbenge luga ya chilambo chammalele, na kutandikila anepo pachinu, Yahwe nkuvamwadilihanyija vanu kila pachinu, pachilambo chammalele. ");
INSERT INTO kde_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Aino njo histoliya ya Shemu na vanu va nnukolo lwake. Paipitile myaka mivili bada ya livambwe, Shemu panavele na vyaka myamoja, nkummaleka Alifakisadi. ");
INSERT INTO kde_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Bada ya kummaleka Alifakisadi, Shemu nkuikala vyaka myatano, na mmyaka aneyo nkuvaveleka vana vanji, vachilume na vachimahe. ");
INSERT INTO kde_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Na Alifakisadi panavele na vyaka salasini na tano, nkummaleka Sela. ");
INSERT INTO kde_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Alifakisadi bada ya kummaleka Sela, nkuikala vyaka myanne na tatu, na mmyaka aneyo nkuvavaleka vana vanji vachilume na vachimahe. ");
INSERT INTO kde_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Na Sela panavele na vyaka salasini, nkummaleka Ebeli. ");
INSERT INTO kde_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Na bada ya kummaleka Ebeli, nkuikala vyaka myanne na tatu, na mmyaka aneyo nkuvaveleka vana vanji vachilume na vachimahe. ");
INSERT INTO kde_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ebeli panavele na vyaka salasini na nne, nkummaleka Pelegi. ");
INSERT INTO kde_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Na bada ya kummaleka Pelegi, nkuikala vyaka myanne na salasini, na mmyaka aneyo nkuvaveleka vana vanji vachilume na vachimahe. ");
INSERT INTO kde_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelegi panavele na vyaka salasini, nkummaleka Leu. ");
INSERT INTO kde_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Na bada ya kummaleka Leu, nkuikala vyaka myambili na tisa, na mmyaka aneyo nkuvaveleka vana vanji, vachilume na vachimahe. ");
INSERT INTO kde_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Leu panavele na vyaka salasini na mbili, nkummaleka Selugi. ");
INSERT INTO kde_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Na bada ya kummaleka Selugi, nkuikala vyaka myambili na saba, na mmyaka aneyo nkuvaveleka vana vanji, vachilume na vachimahe. ");
INSERT INTO kde_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Selugi panavele na vyaka salasini, nkummaleka Naholi. ");
INSERT INTO kde_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Na bada ya kummaleka Naholi, nkuikala vyaka myambili, na mmyaka aneyo kuvaveleka vana vanji, vachilume na vachimahe. ");
INSERT INTO kde_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naholi panavele na vyaka ishilini na tisa, nkummaleka Tela. ");
INSERT INTO kde_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Na bada ya kummaleka Tela, nkuikala vyaka myamoja kumi na tisa, na mmyaka aneyo nkuvaveleka vana vanji, vachilume na vachimahe. ");
INSERT INTO kde_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tela pahwikihije vyaka sabini, nkutandilika kuvaveleka vana, yani Ablamu na Naholi na Halani. ");
INSERT INTO kde_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Na aino njo histoliya ya Tela na vanu va nnukolo lwake. Tela nkummaleka Ablamu na Naholi na Halani. Halani nkummaleka Lutu. ");
INSERT INTO kde_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Henga Halani ánihila muimanga ya Ulu ya Vakaludayo, muimanga yanavelekwejije, na uhiku anewo atatake ávele chihi momi. ");
INSERT INTO kde_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Bahi Ablamu na Naholi nkulomba. N'jawe Ablamu vánchema Salai, na n'jawe Naholi vánchema Milika. Milika na Isika vávele vana vachimahe vanga Halani. ");
INSERT INTO kde_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Na Salai ávele ntonga, nanga panavele na mwana. ");
INSERT INTO kde_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tela nkuntwala mwanawe uvanchema Ablamu na Salai n'jawe Ablamu, chalumo na n'dukuluwe uvanchema Lutu, mwanawe Halani, vammalele nkuukananga ku Ulu ya Vakaludayo, nkulodya kuchilambo cha ku Kanaani. Henga pavakamwele ku Halani, nkuikalanga anepo. ");
INSERT INTO kde_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tela áikele vyaka myambili na tano, nkuhila aneko ku Halani. ");
INSERT INTO kde_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Bahi Yahwe nkunnyaulila Ablamu kuchidoni, “Uka nchilambo chako, valeke alangavako na ing'ande ya atatako, koka uhwene nchilambo chinimbekulanguja. ");
INSERT INTO kde_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Nangu nìmbevatenda vanu va nnukolo lwako kuva chilambo chikulungwa, na nìmbekubaliki na kulitumbyanga lina lyako. Wako pamo na vanu va nnukolo lwako mùmbekuva balaka kwa vanu vanji. ");
INSERT INTO kde_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Munu ambekubalîki wako, nangu nguchinim'baliki, na munu woheyo ambekulâni wako, nangu nguchingunlani. Na kwa kupitila wako, nìmbevabaliki vanu va vilambo vyammalele vya pachilambo.” ");
INSERT INTO kde_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Bahi Ablamu nkuuka ku Halani malinga chanalaijijwe nawi Yahwe. Lutu nanang'e nkulongana nawe. Ablamu paukile ku Halani ávele na vyaka sabini na tano. ");
INSERT INTO kde_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Ablamu nkuntwala Salai n'jawe na Lutu mwana wa nnung'une na dimali dyavo dyammalele pamo na vanu vammalele uvanavapete aneko ku Halani. Vammalele nkupanganika mwanda, nkuhwena mpaka chilambo cha ku Kanaani. Pavahwikile aneko, ");
INSERT INTO kde_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ablamu nkupita nchilambo anecho, nkuhwena unaikala ku Shekemu, pachinu pachinnungu, pavêle nnandi wa chinnungu wa Mole. Mmahiku anelo, venedi va chilambo anecho vávele Vakanaani. ");
INSERT INTO kde_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Bahi Yahwe nkunhumila Ablamu nkunnyaulila kuchidoni, “Chiveleko chako nìmbeching'a chilambo achino.” Anepo Ablamu nkudenga chitala kwajili ya Yahwe, anhumidîle. ");
INSERT INTO kde_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ablamu nkuuka, nkulodya ya kumachinga lavêle m'bali wa mashaliki wa ku Beseli. Aneko Ablamu nkudenga n'gongwe wake ching'ati eneo livêle m'bali wa mashaliki wa imanga ya Beseli na m'bali wa mangalibi wa imanga ya Ai. Anepo napanang'o nkun'dengela Yahwe chitala cha kunhumija sadaka, nkutandilika kunnyuwa. ");
INSERT INTO kde_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Anepo Ablamu nkuhweneha na mwanda, waonganya-onganya kulodya m'bali wa kusini, kulilanga lya Negebu. ");
INSERT INTO kde_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Mmahiku anelo nkukamola indala ing'ulungwa nchilambo anecho, bahi Ablamu nkubidi ahwene ku Misili akaikale aneko kadiki. ");
INSERT INTO kde_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ablamu panavele pepi kuhwika ku Misili nkunnyaulila Salai n'jawe kuchidoni, “Ǹnimala kuva wako nni nkongwe ukatapele namene na uutila mmeho. ");
INSERT INTO kde_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Vamisili pavambekwona vàmbehaula kuva, ‘Ayu nni n'jawe.’ Anepo njo pavambembwalala nangu, henga wako vàmbekuleka uvèlè umumi. ");
INSERT INTO kde_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Bahi vahaulile kuva, wako nnumbwangu, uchinga vangutendele lambone, na ngupate kulama kwajili yako.” ");
INSERT INTO kde_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Bahi Ablamu pahwikile ku Misili, Vamisili nkumwona Salai kuva nkongwe akatapele namene. ");
INSERT INTO kde_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Maafisa fulani vanga Falao, nfalume wa Misili pavammwene Salai, nkunannombolela namene kwanga Falao. Bahi Salai nkupelekejwa muing'ande yanga Falao. ");
INSERT INTO kde_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Falao nkuntendela Ablamu lambone ing'anya ya Salai, nkumwing'a Ablamu dingandolo na ding'ombe na punda anamilume na makolo, vatumwa vachilume na vachimahe pamo na angamila. ");
INSERT INTO kde_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Henga Yahwe nkuntaya magonjwa Falao, nang'e pamo na vanu va nng'ande mwake ing'anya ya kuntwala Salai, n'jawe Ablamu. ");
INSERT INTO kde_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Anepo Falao nkunchema Ablamu nkummuja kuchidoni, “Chinu ntwani achino chungutendeledile? Mwadachi unanguhaulile kuva Salai ni n'jalo? ");
INSERT INTO kde_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Mwadachi úhawile kuva ni nnumbulo mpaka nangu nkuntwala kuva n'jangu? Bahi n'jalo ayuno, ntwale uuke nawe!” ");
INSERT INTO kde_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Anepo Falao nkuvalaija vanu vake vampelekele Ablamu pamo na n'jawe. Vanang'o nkumpelekela pamo na dimali dyake dyammalele. ");
INSERT INTO kde_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ablamu nkuuka ku Misili, nkuhwena kulilanga lya Negebu. Ablamu ávele na n'jawe na dimali dyake dyammalele pamo na Lutu. ");
INSERT INTO kde_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Mmahiku anelo Ablamu ávele na dimali dyohe namene, yani makuwa la anyama na dihela na zahabu. ");
INSERT INTO kde_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Anepo Ablamu nkuuka, nkupita wanachionga-onga kulodya ya ku Beseli. Nkunahwika pachinu panadengile n'gongwe anepo patandi, ching'ati imanga ya Beseli na Ai, ");
INSERT INTO kde_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","pachinu apala panadengile chitala. Anepo Ablamu nkunnyuwa kavila Yahwe kwa lina lyake. ");
INSERT INTO kde_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Uchocho, Lutu nanang'e ávele na makuwa la dingandolo na dimbudi na ding'ombe pamo na migongwe yachiikala na vanu vake. ");
INSERT INTO kde_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Isabu ya vanyama uvanavenavo yavele ing'ulu namene, na chilambo achila nanga pachinatosije Ablamu na Lutu kuikala pamo, ");
INSERT INTO kde_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","kwa kuva, mmahiku anelo venedi va chilambo anecho, yani Vakanaani na Vapelizi váikalanga eneo ulyolyo. Bahi vachunga vanga Ablamu na vanga Lutu nkutandilika kupwatana. ");
INSERT INTO kde_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Bahi Ablamu nkunnyaulila Lutu kuchidoni, “Nangu na wako tunapwatane, wala vachunga vangu na vako navanang'o vanapwatane, kwa kuva nangu na wako nni munu na mwanawe. ");
INSERT INTO kde_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Lola chilambo achino chammalele chivêle muyo mwako. Bahi tuhapukane, wako ukàhwena m'bali wa kunchinda, nangu nìmbehwena m'bali wa kunkono, na ukàhwena m'bali wa kunkono, nangu nìmbehwena m'bali wa kunchinda.” ");
INSERT INTO kde_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lutu palolite saana, nkulwona luhunde lwa muto wa Yoludani. Lutu áluwene luhunde anelwo kuva lùvele na medi lohe namene kila pachinu. Eneo lya luhunde anelwo mpaka ku Soali lyanikatapala muchi bustani ya Adeni, yanaivikile Yahwe, na muchi chilambo cha ku Misili. Kwa kuva, uhiku anewo wavele kabla Yahwe akànambikwondonga imanga ya Sodoma na Gomola. ");
INSERT INTO kde_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Bahi Lutu nkulitandolela luhunde lwammalele lwa muto wa Yoludani, nkulodya m'bali wa mashaliki. Anepo Ablamu na Lutu nkuhapukana. ");
INSERT INTO kde_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ablamu nkuikala nchilambo uchila cha Kanaani, na Lutu nkuhwena unadenga migongwe yake pepi na imanga ya Sodoma na kuikala ching'ati dimanga divêle nnuhunde lwa muto wa Yoludani. ");
INSERT INTO kde_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Henga vanu va ku Sodoma vávele vanu vatênda lahakalenge na va kupundiha kutenda masambi pameho panga Yahwe. ");
INSERT INTO kde_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Bada ya Lutu kuhapukana na Ablamu, Yahwe nkunnyaulila Ablamu kuchidoni, “Kutandikila anepo pauvele, lola saana mipata yammalele, kaskazini na kusini na mashaliki na mangalibi. ");
INSERT INTO kde_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Chilambo anecho chammalele chiuchona nìmbekwing'a wako na vanu va nnukolo lwako chììve chenu, vyaka vyammalele. ");
INSERT INTO kde_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Vanu va nnukolo lwako nìmbevatenda kuva vohe namene, vanu vakávalangika, malinga litutunga lya pachilambo chilikavalangika! ");
INSERT INTO kde_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Bahi imila upite uwonga-onga nchilambo achino, ulehu wake na upana wake, kwa kuva, nìmbekwing'a wako.” ");
INSERT INTO kde_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Bahi Ablamu nkuusa migongwe yake, nkuhwena unaikala ku Hebloni, pepi na milandi ya chinnungu yanga Mamle. Aneko Ablamu nkun'dengela Yahwe chitala. ");
INSERT INTO kde_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Bahi mmahiku anelo, nfalume Amulafeli wa ku Babiloni na nfalume Alioko wa ku Elasali na nfalume Kedolilaoma wa ku Elamu na nfalume Tidali wa ku Goimu, ");
INSERT INTO kde_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","kwa pamo nkuhwena unapanya ing'ondo na nfalume Bera wa ku Sodoma na nfalume Bilisha wa ku Gomola na nfalume Shinabu wa ku Adima na nfalume Shemebeli wa ku Seboimu na nfalume wa ku Bela, yani wa ku Soali. ");
INSERT INTO kde_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Likuwa anelyo lyavili lya vafalume nnyano vánilalundanya matiyala lao kuluhunde lwa Sidimu, yani kuluhunde lwa bahali ya Munyu. ");
INSERT INTO kde_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Vafalume anevo vánitawaliwa na nfalume Kedolilaoma kwa vyaka kumi na mbili, henga chaka cha kumi na tatu, nkuhita kutawaliwa na nfalume aneyo. ");
INSERT INTO kde_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Nchaka cha kumi na nne, nfalume Kedolilaoma na vafalume vavake vanalilundenye pamo na nang'e nkuhwena unapanyana ing'ondo. Nkuvalema Valefaimu aneko ku Ashitelosi-Kalinaimu na Vazuzi aneko ku Hamu, na Vaemi aneko ku Shawe-Kilyasaimu, ");
INSERT INTO kde_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","na Vaholi aneko kulichinga lyao lya Seili, nkuvavinganga mpaka ku Elipalani, nnipalu lya lilanga. ");
INSERT INTO kde_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Bahi anevo vafalume nkuuya nnyuma mpaka ku Enimisifati, yani Kadeshi, nkuchipanya chilambo chammalele cha Vaamaleki pamo na Vaamoli vachiikala ku Hasason-Tamali. ");
INSERT INTO kde_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Anepo nfalume wa ku Sodoma na nfalume wa ku Gomola na nfalume wa ku Adima na nfalume wa ku Seboimu na nfalume wa ku Bela, yani Soali, nkuhwena unalipanga kwajili ya ing'ondo nnuhunde lwa Sidimu uchinga vapanyane, ");
INSERT INTO kde_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","nawi Kedolilaoma nfalume wa ku Elamu na Tidali nfalume wa ku Goimu na Amulafeli nfalume wa ku Babiloni na Alioko nfalume wa ku Elasali. Vafalume anevo ncheche nkupanyana ing'ondo na vafalume anevo nnyano. ");
INSERT INTO kde_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Nnuhunde lwa Sidimu múumbele mapondo la lami, bahi nfalume wa ku Sodoma na wa ku Gomola pavachitukuta ing'ondo, matiyala lavo lanji nkumatokela mmapondo anelo, henga vanji nkutukutila kumachinga. ");
INSERT INTO kde_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Bahi vafalume avala ncheche, nkutwala dimali dyammalele dya ku Sodoma na ku Gomola, chalumo na vyakulya vyao vyammalele, nkuukananga. ");
INSERT INTO kde_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Nkunkamula na Lutu, mwana wanga nnung'une Ablamu, achiikala ku Sodoma. Uchocho, vátwete na dimali dyammalele dya Lutu. ");
INSERT INTO kde_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Munu yumo anapalanyweke mmakono mwa anevo vafalume, nkuhwena unahaulanga habali dyanga Lutu kwanga Ablamu, Mweblaniya achiikâla pepi na milandi ya chinnungu yanga Mamle, Mwamoli. Mamle ávele nnangawake Eshikoli na Aneli, na vanu anevo vatatu, anepo patandi vátendile lilailano lya kuyangatana nawi Ablamu. ");
INSERT INTO kde_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ablamu papete habali kuva mwana wa nnung'une àtwaliwije litwala, nkuuka na ang'ondo vake myatatu na kumi na nane, vavelekwejîje nng'ande mwake, nkuvalandola anevo vafalume mpaka ku Dani. ");
INSERT INTO kde_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Aneko Ablamu nkuvayavanya ang'ondo vake matunji-matunji. Chilo, nkuvahavila anevo vafalume, nkuvalema na kuvavinganga mpaka ku Hoba, m'bali wa kaskazini wa ku Dameski. ");
INSERT INTO kde_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Bahi Ablamu nkumpoha Lutu na dimali dyake, na dimali dinji dyammalele dinatwaliwijwe na anevo vafalume, chalumo na vamahe na vanu vanji. ");
INSERT INTO kde_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ablamu panavenkuuya, bada ya kunnema dimongo nfalume Kedolilaoma na vafalume avake vanji, nfalume wa ku Sodoma nkuhwena unanchingamila Ablamu nnuhunde lwa Shawe, luhunde lumaikâna kwa lina lya, Luhunde lwa Nfalume. ");
INSERT INTO kde_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melikisedeki, nfalume wa imanga ya ku Salemu, anavele kuhani wa Nnungu Nkulu, nanang'e nkwida na nkate na divayi, ");
INSERT INTO kde_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","nkum'baliki Ablamu wachidoni, “Ablamu àbalikiwe na Nnungu Nkulu, aumbîle chilambo na kulihunde! ");
INSERT INTO kde_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Àtumbyangwe Nnungu Nkulu, avakamujîje amongo vako mmakono lako!” Ablamu nanang'e nkumwing'a Melikisedeki asilimiya kumi ya vitukutuku vyammalele vyanatwete litwala. ");
INSERT INTO kde_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Nfalume wa ku Sodoma nkunnyaulila Ablamu kuchidoni, “Ning'e vanu vangu vanatwaliwijwe litwala, koka anedyo dimali dyammalele uditwale wako umwene.” ");
INSERT INTO kde_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Henga Ablamu nkunnyaulila nfalume wa ku Sodoma kuchidoni, “Mbènkwapila kwanga Yahwe, Nnungu Nkulu, aumbîle chilambo na kulihunde, ");
INSERT INTO kde_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","kuva, nangu nikambetwala uzi, wala n'didi wa chilatu wala chinu chako chohecho, uyopa ùnahaula kuva ùningutajilisha. ");
INSERT INTO kde_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Bahi nangu nikambetwala chinu chinji chohecho, ila litunji lyangu lìmbekuva chihi chakulya achila chivanalile vanu vangu mmwanda. Henga Aneli na Eshikoli na Mamle, anevo vàvele na haki ya kupata litunji kuhaloka n'dimali anedyo, kwa kuva, vanang'o vápapatene na nangu.” ");
INSERT INTO kde_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Bada ya kupita mambo anelo, Yahwe nkutangola na Ablamu mwindoto kuchidoni, “Ablamu unayope, kwa kuva, nangu njo nikuchûnga wako. Na inudyo yako ìmbekuva ing'ulu namene!” ");
INSERT INTO kde_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Henga Ablamu nkuyang'ula kuchidoni, “Nang'olo Yahwe, balaka anedyo dìmbengukatapalila chani nangu nikavèlè na mwana? Eliezeli, munu wa ku Dameski njo ambetwâla mapala langu. ");
INSERT INTO kde_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Wako nanga paungujalidile nangu kumpata mwana. Bahi Eliezeli, ntumishi wa nng'ande mwangu, aneyo njo ambekûva mmapala wangu!” ");
INSERT INTO kde_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Bahi Yahwe nkutangola kavila na Ablamu kuchidoni, “Aneyo ntumishi nanga pambetwala mapala lako! Henga mwana umbemmalêka wako umwene, aneyo njo ambetwâla mapala lako.” ");
INSERT INTO kde_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Bahi Yahwe nkunhumya panda Ablamu nkunnyaulila kuchidoni, “Lola meho lako kumahunde udivalange dinondwa ikàva muhiu uchiuhulule kudivalanga!” Nkunnyaulila kavila kuchidoni, “Vanu va nnukolo lwako vàmbekuva muchi anedyo dinondwa dyudyona!” ");
INSERT INTO kde_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ablamu nkunkulupila Yahwe, na kwa kutenda uchocho Yahwe nkummalangila kuva wambone pameho pake. ");
INSERT INTO kde_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Nnungu nkunnyaulila kuchidoni, “Nangu njo Yahwe nikupelekejîje apano kuhaloka ku Ulu, imanga ya Vakaludayo, uchinga nikwing'e chilambo achino chììve mapala lako.” ");
INSERT INTO kde_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Henga Ablamu nkummuja kuchidoni, “Nang'olo Yahwe, nangu nìmbemala dachi kuva chilambo achino chìmbekuva mapala langu?” ");
INSERT INTO kde_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Yahwe nkunnyang'ula kuchidoni, “Ning'e ung'ombe wachimahe wa vyaka vitatu na umbudi wachimahe wa vyaka vitatu na ungandolo nannume wa vyaka vitatu na lideya na likanda lya umunda.” ");
INSERT INTO kde_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Bahi Ablamu nkuvasinja anevo anyama vammalele na vyuni, nkumpelekejija Yahwe. Kila nnyama nkumpasulanya vipande vivili, nkuvipanga midododo mivili, uvilolana. Henga vyuni nanga panavipasulanyije vipande vivili. ");
INSERT INTO kde_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Na vipungo paviidile unadadola mituhi ya anyama anevo, Ablamu nkuva wavavinganga. ");
INSERT INTO kde_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Liduva palichiswa, Ablamu nkukamulwa na luwono luidôpa. Muuhiku uwowo, lupi lwanapi pii lwa kuyoha nkunnyidila Ablamu. ");
INSERT INTO kde_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Yahwe nkunnyaulila Ablamu kuchidoni, “Bahi umale kuva, muhiu vanu va nnukolo lwako vàmbekuva vamidi nchilambo chikávele chavo, vàmbejuhwa kuva vatumwa na vàmbebanihwa namene kwa vyaka myanne. ");
INSERT INTO kde_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Henga nìmbechihukumu asabu chilambo anecho chivambechitumikila muchi vatumwa, na ntululilo wake vanu anevo vàmbeuka nchilambo anecho vavèlè na dimali dyohe. ");
INSERT INTO kde_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Henga wako Ablamu ùmbeikala pachilambo kwa vyaka vyohe, na ùmbehila uhiku wa amani. ");
INSERT INTO kde_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Bada ya vanu va nnukolo lwako kuva vatumwa kwa vyaka myanne, vàmbeuya nchilambo achino, kwa kuva, mmahiku anelo lavambeuya, mambo lahakalenge la Vaamoli làmbekuva lahwikidìlè muuhiku uvalembelewa kwasibiwa.” ");
INSERT INTO kde_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Bahi liduva paliswele na lupi palwendile, Ablamu nkuchona chilongo chitutûma lyohi na mwenje uyâka moto upìtà ching'ati avila vipande vya anyama. ");
INSERT INTO kde_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Liduva anelyo Yahwe nkutenda lilailano na Ablamu, nkuchidoni, “Chilambo achino nìveng'a vanu va nnukolo lwako, kutandikila kulipalu lya ku Misili mpaka kumuto aula nkulungwa wa Eflati, ");
INSERT INTO kde_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","yani vilambo vya Vakeni na Vakenizi na Vakadimoni, ");
INSERT INTO kde_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","na Vahiti na Vapelizi na Valefaimu, ");
INSERT INTO kde_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","na Vaamoli na Vakanaani na Vagiligashi na Vayebusi.” ");
INSERT INTO kde_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Bahi Salai, n'jawe Ablamu, ávele akànammelekela mwana nng'andomwe. Henga ávele na ntumwa wa chikongwe wa ku Misili uvanchema Hajili. ");
INSERT INTO kde_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Bahi Salai nkunnyaulila Ablamu kuchidoni, “Wako ùnimala kuva Yahwe nanga pangujalidile kupata mwana. Bahi ntwale Hajili ntumwa wangu, panjika nguchingupate vavana kupitila nang'e.” Bahi Ablamu nkuyambukila achila channyaulidile Salai. ");
INSERT INTO kde_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Anepo Salai nkuntwala Hajili ntumwa wake nkumwing'a Ablamu uchinga ààve n'jawe. Mambo anelo láhumidile bada ya Ablamu kuikala nchilambo cha ku Kanaani kwa vyaka kumi. ");
INSERT INTO kde_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Bahi Ablamu nkulala na Hajili, na Hajili nkupata chitumbo. Henga Hajili pawene kuva àvele pammili, nkutandilika kunsalau Salai, nkulu wake. ");
INSERT INTO kde_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Anepo Salai nkunnyaulila Ablamu kuchidoni, “Wako njo utendîle nangu ngusalauliwe. Nangu níkupele ntumwa wangu, henga nang'e pàyukwite chihi chitumbo, nangu ngwònekana chihi kuva nikee chinu pameho pake! Bahi Yahwe aamule, kati yangu na wako, nnani avêle na haki!” ");
INSERT INTO kde_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Henga Ablamu nkunnyaulila Salai kuchidoni, “Aneyo nni ntumwa wako, wako ntendele chihi chohecho chulembela.” Bahi Salai nkum'baniha namene Hajili, ntululilo wake Hajili nkutaloka. ");
INSERT INTO kde_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Malaika wa Yahwe nkunkoja Hajili pepi na pachimbwimbwi cha medi aneko kulilanga, chimbwimbwi chinavele pepi na indila ilôja ku Shuli. ");
INSERT INTO kde_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Malaika nkummuja Hajili kuchidoni, “Wako Hajili, ntumwa wanga Salai, ùhaloka kwachi na ùhwena kwachi?” Hajili nkunnyang'ula kuchidoni, “Nìntukuta Salai, nkulu wangu.” ");
INSERT INTO kde_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Malaika wa Yahwe nkunnyaulila Hajili kuchidoni, “Uya kwanga Salai, nkulu wako na ukalisulupuhe pameho pake. ");
INSERT INTO kde_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Nangu nìmbevatenda vanu va nnukolo lwako kuva vohe, ata vanahululike kuvalangika ing'anya vàmbekuva vohe namene.” ");
INSERT INTO kde_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Nkunnyaulila kavila kuchidoni, “Wako ùvele na chitumbo, na ùmbemmeleka mwana wa chilume. Mwana aneyo ùmbenchema lina Isumaili, mana lake ‘Nnungu ànipilikana,’ kwa kuva, Yahwe àniyona ibaniki yako. ");
INSERT INTO kde_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Henga Isumaili àmbeikala muchi punda wa munnyitu. Àmbekuva mmongo wa kila munu na kila munu àmbekuva mmongo wake. Na àmbehapukana na alangavake. ");
INSERT INTO kde_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Bahi Hajili nkutumila lina linji kumwamba Yahwe alonjedîle nawi nang'e. Nkunchema Yahwe “El-loi,” mana lake “Nnungu alôla.” Kwa kuva, álihaulidile muntima wake kuva, “Muhiu apano nìmmwene ayula angwôna nangu.” ");
INSERT INTO kde_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Njo mana chihima achila chivêle ching'ati Kadeshi na Beledi chìchemwa Beli-Lahai-Loi, mana yake “chihima cha ayula avêle na umi na angwôna.” ");
INSERT INTO kde_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Bahi Hajili nkuuya, nkummelekela Ablamu mwana wa chilume. Ablamu nkunchema mwana aneyo lina lyake, Isumaili. ");
INSERT INTO kde_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Hajili pammaleke Isumaili, Ablamu ávele na vyaka samanini na sita. ");
INSERT INTO kde_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ablamu panavele na vyaka tisini na tisa, Yahwe nkunhumila nkunnyaulila kuchidoni, “Nangu ni Nnungu Nguvêle Na Dimongo Dyammalele. Ngutumikile nangu kwa ikulupiki na uikale kwa kutenda àlalá langulalembela nangu, ");
INSERT INTO kde_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","na nangu nguchingutende lilailano na wako na nìmbevatenda vanu va nnukolo lwako kuva vohe namene.” ");
INSERT INTO kde_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ablamu nkuhunama mpaka pahi, na Nnungu nkunnyaulila kuchidoni, ");
INSERT INTO kde_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Alino njo lilailano lingulitenda na wako kuva, wako ùmbekuva atata wa vilambo vyohe. ");
INSERT INTO kde_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Na kutandikila vino, ukambechemwa kavila Ablamu, henga ùmbechemwa Iblahimu, kwa kuva nìkutendile kuva atata wa vilambo vyohe. ");
INSERT INTO kde_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Nangu nìmbevatenda vanu va nnukolo lwako kuva vohe namene. Na vanu anevo nìmbevajuha kuva vilambo vyohe, na vanji muanevo vàmbekuva vafalume. ");
INSERT INTO kde_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Maduva lammalele na mmivelekwa vyammalele, nangu nìmbelichunga lilailano lingutendile na wako na vanu va nnukolo lwako kuva, nangu njo Nnungu wako na Nnungu wa vanu va nnukolo lwako. ");
INSERT INTO kde_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Na chilambo achino cha Kanaani chuikala vino muchi mmidi, chammalele nìmbekwing'a wako na vanu va nnukolo lwako, vyaka na vyaka. Na nangu nìmbekuva Nnungu wavo.” ");
INSERT INTO kde_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Anepo Nnungu nkunnyaulila Iblahimu kuchidoni, “Na kwa upande wako, wako chalumo na vanu vammalele va nnukolo lwako na vívelèkwà vyao vyammalele, mùlembelewa mulichunge lilailano lyangu. ");
INSERT INTO kde_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Na alino njo lilailano limulembelewa mulichunge kuva, kila nnume mmwenu àlembelewa ayalulwe. ");
INSERT INTO kde_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Mùlembelewa mucheketwe mambende lenu, na anecho njo chimbekûva chimaiho cha lilailano lyangu na mwenu. ");
INSERT INTO kde_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","13","Kila mwana wachilume wa maduva nane mmwenu àlembelewa ayalulwe, na ata vanu vakávele va n'ding'olo dyenu, ikàva vatumwa vavelekwejîje n'ding'ande dyenu au vasumwîje kwa dihela kuhaloka kwa amidi, navanang'o vàlembelewa vayalulwe. Na anecho njo chimbekûva chimaiho cha lilailano lyangu mmiili yenu, lilailano lya vyaka na vyaka. ");
INSERT INTO kde_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Nnume woheyo akambeyalulwa, àmbenyemwa na vanu, kwa kuva àmbekuva ànilitimbanga lilailano lyangu.” ");
INSERT INTO kde_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Bahi Nnungu nkunnyaulila Iblahimu kuchidoni, “Na kwamba n'jalo Salai, nang'e ukambenchema kavila Salai, ila lina lyake lìmbekuva Sala. ");
INSERT INTO kde_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Nangu nìmbem'baliki Sala kwa kuntenda akuvelekele mwana wachilume. Nìmbem'baliki namene Sala kwa kuntenda kuva mama wa vilambo vyohe. Na vanu vanji va nnukolo lwake vàmbekuva vafalume.” ");
INSERT INTO kde_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Anepo Iblahimu nkuhunama mpaka pahi, nkuva waheka chimunda-munda walyuja kuchidoni, “Ìmbehululika dachi nangu ninsele wa vyaka myamoja kummaleka mwana? Na ìmbehululika dachi Sala, nkongwe wa vyaka tisini kummaleka mwana?” ");
INSERT INTO kde_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Bahi Iblahimu nkunnyaulila Nnungu kuchidoni, “Chikaniva chinu chambone kuikave ahadi aneyo uiva kwanga Isumaili.” ");
INSERT INTO kde_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Nnungu nkunnyang'ula Iblahimu kuchidoni, “Nanga! N'jalo Sala achiakuvelekele mwana wachilume, na wako uchiuncheme lina lyake, Isaka. Nangu nìmbehweneha kulichunga lilailano lyangu kwake na kwa vanu va nnukolo lwake, vyaka na vyaka. ");
INSERT INTO kde_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Na kwamba Isumaili, nangu ǹnipilikana kuyuwa kwako. Nìmbem'baliki na kuvatenda vanu va nnukolo lwake kuva vohe namene. Isumaili àmbekuva atata wa vatawâla kumi na mbili, na nìmbentenda kuva chilambo chikulungwa. ");
INSERT INTO kde_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Henga nangu nìmbehweneha kulichunga lilailano lyangu kwanga Isaka, mwana wambekuvelekela Sala mmahiku malinga ulano, mmwaka uîda.” ");
INSERT INTO kde_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Bahi Nnungu pamalidile kulonjela nawi Iblahimu, nkunneka. ");
INSERT INTO kde_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Nniduva ulyolyo, Iblahimu nkutenda muchi chalaijijwe nawi Nnungu. Nkunnyalula Isumaili na valume vammalele vavêle nng'ande mwake, yani avala vavelekwejîje nng'ande mwake na avala vasumwîje kwa dihela. ");
INSERT INTO kde_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Iblahimu áyalwike avèlè na vyaka tisini na tisa. ");
INSERT INTO kde_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Na Isumaili mwanawe Iblahimu áyalwike avèlè na vyaka kumi na tatu. ");
INSERT INTO kde_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Nniduva ulyolyo, Iblahimu pamo na mwanawe Isumaili, ");
INSERT INTO kde_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","na valume vammalele va nng'ande mwake, yani valume vammalele vavelekwejîje nng'ande mwake na vammalele vasumwîje kwa dihela kuhaloka kwa amidi, vammalele vániyalulwa. ");
INSERT INTO kde_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Liduva limo Yahwe ánhumidile kavila Iblahimu pepi na milandi ya chinnungu ya Mamle. Uhiku anewo Iblahimu áikele pannango wa n'gongwe wake, muhi uhiku wa chitukuta. ");
INSERT INTO kde_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Panyamwile meho lake, nkuvona valume vatatu vaimidìlè pepi nanang'e. Upala Iblahimu pavawene anevo vanu, nkutukuta uhwena unavachingamila. Pavahwikidile, nkuhunama kwa eshima mpaka pahi, ");
INSERT INTO kde_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","nkuchidoni, “Nang'olo wangu, ikàva wako ùnikatapaliwa na nangu, bahi nakuyuwa unangupite nangu nintumishi wako. ");
INSERT INTO kde_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Leka ngulaije medi kadiki mukalave mmadodo lenu koka mupumulile pammbweha wa nnandi auno. ");
INSERT INTO kde_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Pamumbekuva umupumulila, nangu nguchinguandae chakulya kadiki mulye, uchinga mupate dimongo dya kuhweneha na mwanda, kwa kuva mùnguidilidile nangu ntumishi wenu.” Vanang'o nkuchidoni, “Haya! Tenda muchi chuhawile.” ");
INSERT INTO kde_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Iblahimu nkupiyanya kuinjila mun'gongwe, nkunnyaulila Sala kuchidoni, “Upehi! Yamola pishi tatu dya uhu wambone namene, umunyange koka ukatapaje mikate. ");
INSERT INTO kde_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Anepo Iblahimu nkuuka upehi nkuhwena kulikuwa lya ding'ombe, nkuntandola undama anunîle namene, nkumwing'a ntumishi wake ansinje. Aneyo ntumishi nkupiyanya kumwandaa. ");
INSERT INTO kde_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Chakulya pachinavele tayali, Iblahimu nkutwala ntindi na mavele na aila inyama yandaliwîje, nkuvavikila anevo vayeni. Na Iblahimu nkuimila pepi na vayeni anevo pavachilya, pahi nnandi akuno wavahudumila. ");
INSERT INTO kde_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Anevo vayeni nkummuja Iblahimu kuchidoni, “Sala n'jalo àvele kwachi?” Iblahimu nkuvayang'ula kuchidoni, “Àvele mun'gongwe.” ");
INSERT INTO kde_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Munu yumo muavala vayeni nkuchidoni, “Chaka chiîda mmahiku ulano, muhiu nguchinguide kavila kwajili yako, na n'jalo Sala àmbekuva avèlè na mwana wa chilume.” Aneyo munu pachitangola malove anelo Sala ávele kunyuma nnango wa n'gongwe wapilikanila. ");
INSERT INTO kde_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Mmahiku anelo Iblahimu na Sala vánikongopala namene, na vyaka vya Sala vya kuvaleka vívele vipundìlè. ");
INSERT INTO kde_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Bahi Sala nkuheka chimunda-munda wachidoni, “Nangu ǹnikongopala, na ntwangu nanang'e uchocho ànikongopala. Ìmbehululika dachi nangu kuva na ihangaladi ya kumpata mwana?” ");
INSERT INTO kde_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Yahwe nkummuja Iblahimu kuchidoni, “Ing'anya ntwani Sala àniheka na kuliuja ikàva muhiu ichiihululike kumpata mwana akuno akongopèlè? ");
INSERT INTO kde_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Dachi, chitukutuku ntwani chikáhululika kwanga Yahwe? Mwaka uîda, mmahiku malinga alano, nangu nguchinguide kavila kwakuwe, na Sala n'jalo àmbekuva avèlè na mwana wa chilume.” ");
INSERT INTO kde_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Henga Sala kwa kuva ániyopa namene, nkukana wachidoni, “Nangu nikáhekile!” Yahwe nkunnyaulila kuchidoni, “Unakane, wako ùniheka!” ");
INSERT INTO kde_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Bahi avala valume pavatakatwike uchinga vauke, nkulola mpata wa ku Sodoma. Na pavachiuka, Iblahimu nkuvapelekela kadiki. ");
INSERT INTO kde_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Bahi Yahwe nkuliuja muntima wake kuva, “Dachi, nìmpihe Iblahimu chinu chingukudungidile kuchitenda? ");
INSERT INTO kde_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Nangu nìmbentenda nang'e kuva chilambo chikulungwa, chivêle na dimongo, na kupitila nang'e nìmbevabaliki vanu va vilambo vyammalele vya pachilambo. ");
INSERT INTO kde_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Kwa kuva, nangu nìntandwele nang'e kuchinga avalodye vana vake na vanu va nnukolo lwake kuipapata indila yangu kwa kutenda haki na kulatenda àlalá langúlambèlà nangu uchinga ngulatimise àlalá lanimwahidite Iblahimu.” ");
INSERT INTO kde_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Bahi Yahwe nkuchidoni, “Pàvele mahinginiko lohe layâmba masambi la vanu va ku Sodoma na ku Gomola kuva, masambi lavo lànipundya namene. ");
INSERT INTO kde_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Bahi nìmbesulupuka uchinga nikalyonele nimwene, ikàva muhiu mambo lavátendàngà lanalinganana na chitangelo chinguhwikidîle. Na ikànave uchocho, nguchingumale.” ");
INSERT INTO kde_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Bahi avala valume nkuuka anepo, nkulodya ya ku Sodoma. Henga Yahwe nkuisalila chihi upala aimidìlè na Iblahimu. ");
INSERT INTO kde_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Iblahimu nkunhengelekela Yahwe, nkummuja kuchidoni, “Dachi, uchiuvaondongange vanu vatênda haki chalumo na vanu vatênda lahakalenge? ");
INSERT INTO kde_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ikàva muimanga aneyo mùvele vanu vatênda haki malinga amsini, dachi, muhiu uchiuyondongange imanga yammalele badala ya kuileka ing'anya ya vanu vatênda haki vavêle muimanga aneyo? ");
INSERT INTO kde_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ikávaila wala kadiki wako kutenda uchocho. Ikáhululika kuvawalala vanu vatênda haki chalumo na vanu vatênda lahakalenge, au vanu vatênda haki kutendewa sawa na vanu vatênda lahakalenge! Nkúhukumu wa chilambo chammalele akambeleka kutenda haki!” ");
INSERT INTO kde_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Yahwe nkuchidoni, “Nikàvakoja vanu amsini vatênda haki muimanga ya Sodoma, nangu nikambeyondonganga ing'anya ya vanang'o.” ");
INSERT INTO kde_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Iblahimu nkuchidoni, “Hambi kwa kuva ǹnikudungila kutangola na Nang'olo, ikànava nangu nni litutunga na liu, bahi leka ngutangole kavila. ");
INSERT INTO kde_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Vakàpwawa chihi vanu alubaini na tano vatênda haki badala ya amsini, dachi uchiuyondongange ing'anya ya kupungula vanu nnyano?” Yahwe nkunnyang'ula kuchidoni, “Nikàvakoja vanu alubaini na tano vatênda haki, nanga panimbeyondonganga imanga aneyo.” ");
INSERT INTO kde_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Iblahimu nkuhweneha kutangola wachidoni, “Dachi, vakàpwawa chihi vanu alubaini vatênda haki?” Yahwe nkunnyang'ula kuchidoni, “Kwajili ya vanu alubaini vatênda haki, nangu nikambeyondonganga.” ");
INSERT INTO kde_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Iblahimu nkutangola kavila kuchidoni, “Chonde Nang'olo unangusunalile, leka ngutangole kavila. Dachi vakàpwawa chihi vanu salasini vatênda haki?” Yahwe nkunnyang'ula kuchidoni, “Nikambetenda uchocho nikàvakoja anevo vanu salasini.” ");
INSERT INTO kde_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Iblahimu nkuchidoni, “Nangu ǹnisubutu kutangola na Nang'olo. Dachi, vakàpwawa chihi vanu ishilini vatênda haki?” Yahwe nkunnyang'ula kuchidoni, “Ing'anya ya anevo vanu ishilini, nanga panimbeyondonganga.” ");
INSERT INTO kde_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Anepo Iblahimu nkuchidoni, “Chonde Nang'olo unangusunalile, leka ngutangole chihi mwanda umo bahi. Dachi, vakàpwawa chihi vanu kumi vatênda haki?” Yahwe nkunnyang'ula kuchidoni, “Ing'anya ya anevo vanu kumi, nanga panimbeyondonganga imanga aneyo.” ");
INSERT INTO kde_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Bahi Yahwe pamalidile kulonjela na Iblahimu, nkulihwenela, na Iblahimu nkuuya kukaya kwake. ");
INSERT INTO kde_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Bahi avala malaika vavili nkuhwika ku Sodoma chinalyulo. Na Lutu áikele pannango wa imanga ya ku Sodoma. Lutu pavawene, nkuimila uhwena unavachingamila, nkuhunama kwa eshima mpaka pahi, ");
INSERT INTO kde_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","nkuhaula kuchidoni,“Mmanang'olo vangu, kalibu kukaya kwangu, nangu ni ntumishi wenu. Muchimukalave medi mmadodo na kulala kukaya kwangu chilo cha nelo, koka ulyamba namambumbu muhwenehe na mwanda wenu.” Henga vanang'o nkuchidoni, “Nanga, hwetu tùmbelala chihi ukuno kuchiwanja, kuching'ati imanga.” ");
INSERT INTO kde_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Lutu nkuvapembeja namene, kuntululilo vanang'o nkukubali, nkuhwena unainjila nng'ande mwake. Lutu nkuvaandalila chakulya chohe namene pamo na mikate ikátaijwe hamila, vanang'o nkulyanga. ");
INSERT INTO kde_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Henga chilo kabla vakànambilala, valume vammalele va muimanga ya ku Sodoma, vijana na vasele vammalele, nkuidinguka ing'ande yanga Lutu. ");
INSERT INTO kde_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Nkunchema Lutu nkummuja kuchidoni, “Valume avala vaidîle kwakuwe vàvele kwachi? Vahumye pawelu, hwetu tùlembela tuvalale.” ");
INSERT INTO kde_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lutu nkuhuma pawelu, akuno wachima nnango wa ing'ande yake, ");
INSERT INTO kde_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","nkuvahaulila kuchidoni, “Chonde mmalangavangu, nannyuwanga munatende chinu anecho chihakalenge. ");
INSERT INTO kde_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Lola, nangu apano ngùvele na vana vangu vavili vachimahe, vakámmaite nnume. Nangu nìnnyuwanga nimwing'ange vali anevo uchinga muvatendele muchi chimulembela. Henga valume avano nìnnyuwanga munavatendele chinu chohecho, kwa kuva vàidile paing'ande yangu na ngùlembelewa nivachunge.” ");
INSERT INTO kde_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Henga anevo vanu nkuchidoni, “Uka wako! Wako paunaidile apano wavele mmidi, na hambi ùlitenda kuva nkúhukumu! Bahi tùmbekutenda vibaya kupunda chitumbevatenda anevo vayeni vako.” Bahi vanu anevo nkuntukuha Lutu, nkuhengelekelanga muyo uchinga vatutumule nnango wa ing'ande yake. ");
INSERT INTO kde_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Henga avala vayeni nkuchimula nnango, nkunyalodya makono lavo, nkummutangila Lutu nng'ande, nkuchima nnango. ");
INSERT INTO kde_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Anepo nkuvaputaja meho valume vammalele vanavele pannango, vijana na vasele, bahi nkusindwa kuuhwikila nnango. ");
INSERT INTO kde_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Avala vanu vavili nkunnyaulila Lutu kuchidoni, “Dachi, ùvele na munu yunji apano, ikàva vana vako au vaposi va vana vako au alangavako vanji vaikâla muimanga aino? Vause apano upehi, ");
INSERT INTO kde_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","kwa kuva, tùmbeyondonganga mwalehu imanga aino. Chitangelo chimmwikilidîle Yahwe kwamba venedi va apano ni chikulungwa namene, nanang'e ànitutuma tuide tukayondongange.” ");
INSERT INTO kde_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Bahi Lutu nkuvahwenela vaposi va vana vake nkuvahaulila kuchidoni, “Ukananga pachinu apano, kwa kuva, Yahwe àmbeiondonganga imanga aino!” Henga vanang'o nkumwona chihi kuva àtenda mang'wanyu. ");
INSERT INTO kde_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Bahi uhiku pauchele, malaika nkunkulumisa Lutu uvachidoni, “Takatuka ntwale n'jalo na vana vako vavili uyopa munaondongwa paimbeondongwa imanga aino.” ");
INSERT INTO kde_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lutu nkuva walidoha-doha, bahi avala malaika vavili nkunkamula nkono Lutu na n'jawe na vana vake vavili, nkuvahumya panda imanga, kwa kuva Yahwe ámmikidile chididi. ");
INSERT INTO kde_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Pavavausije muimanga aneyo, malaika yumo nkuvahaulila kuchidoni, “Tukutanga mupohe umi wenu! Munalole nnyuma na wala munaimile pachinu pohepo nnuhunde aluno! Tukutilangila aneko kuchilambo cha machinga uyopa munaondongwa.” ");
INSERT INTO kde_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lutu nkunnyaulila kuchidoni, “Chonde nang'olo wangu ngùyuwa inààve uchocho! ");
INSERT INTO kde_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Wako ngwòna ùnikatapaliwa na nangu, na ùngutendeledile lambone namene kwa kuupoha umi wangu. Henga aneko kuchilambo cha machinga nni kulehu namene. Na kwondongwa anekwo kumbeng'oja chihi kabla nikànambihwika aneko, nanangu nguchinguhwe. ");
INSERT INTO kde_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Lola, akula kùvele imanga inyoko, nangu nahulula chihi kutukutila aneko kwa kuva ìvele pepi. Bahi nguluhusu ngutukutile aneko. Aila nni imanga chihi inyoko, na aneko nguchingupohe umi wangu.” ");
INSERT INTO kde_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Nang'e nkunnyang'ula kuchidoni, “Haya, ǹnikubali chiuyuwite. Nangu nikambeyondonganga imanga aneyo. ");
INSERT INTO kde_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Bahi tukutila aneko upehi, nangu nikambetenda chinu chohecho mpaka paumbehwika aneko.” Na aneyo njo ing'anya inatendile imanga aneyo ichemwe Soali, mana lake “pachinu pajoko.” ");
INSERT INTO kde_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lutu pahwikile kuimanga ya Soali liduva lívele lihumìlè tayali. ");
INSERT INTO kde_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Bahi Yahwe nkutonya moto wa baluti kuhaloka kumahunde muimanga ya ku Sodoma na ku Gomola, ");
INSERT INTO kde_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","nkudyondonganga dimanga anedyo na luhunde lwammalele na vanu vammalele na mimeya yammalele nchilambo anecho. ");
INSERT INTO kde_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Henga n'jawe Lutu ánavele nnyuma mwanga Lutu, nkulauka kulola nnyuma, nkujuka sanamu ya munyu. ");
INSERT INTO kde_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Bahi nniduva ulyolyo, Iblahimu átakatwike ulyamba na mambumbu, nkupiyanya kuhwena pachinu apala pánaimidìlè walonjela nawi Yahwe. ");
INSERT INTO kde_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Iblahimu pahwikile pachinu anepo, nkulola kuluhunde mpata wa ku Sodoma na ku Gomola na eneo lyammalele lya luhunde, nkukangana palyonite lyohi ulitutuma mueneo lyammalele lya luhunde, muchi lyohi lihalôka nnitanuli likulungwa. ");
INSERT INTO kde_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Henga Nnungu áninkumbukila Iblahimu kwa kummusa Lutu n'dimanga dya nnuhunde, dyachiikala uchinga anaondongwe pamo na anedyo dimanga muuhiku aula Nnungu padyondongenge dimanga anedyo. ");
INSERT INTO kde_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lutu nkuyopa kuikala muimanga ya ku Soali, bahi nang'e pamo na vana vake vavili nkuhama muimanga aneyo, nkuhwena unaikala nnipanga, aneko kuchilambo cha machinga. ");
INSERT INTO kde_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Lutu na vana vake pavanavele aneko, mwali wake nkulungwa nkunnyaulila nnung'une kuchidoni, “Atata wetu vino ànikongopala, na wala nanga nnume nchilambo achino wa kulala na hwetu uchinga tupate vavana muchi chiivele kwa vanu vammalele va pachilambo. ");
INSERT INTO kde_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Bahi tunkelewehe atata wetu wala uchinga tupate kulala nawe. Kwa kutenda uchocho, tuchituhwenehe lukolo lwetu kupitila atata wetu.” ");
INSERT INTO kde_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Chilo cha liduva anelyo, nkunkeleweha atata wao wala, na ayula mwali wake ntandi nkuhwena unalala nawe. Henga atatake nanga panakameke uhiku wainjidile mwanawe unalala nawe, wala uhiku waukile. ");
INSERT INTO kde_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Liduva lipapête, ayula mwali nkulungwa nkunnyaulila nnung'une kuchidoni, “Chilo cha nelo nangu ńnilala na atata. Uchocho na nelo tunkelewehe, koka na wako uhwene ukalale nawe uchinga tuhwenehe lukolo lwetu kupitila atata wetu. ");
INSERT INTO kde_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Bahi chilo chipapête nkunkeleweha wala atata wao, na ayula mwali n'joko nkuhwena unalala nawe. Henga atatake nanga panakameke uhiku wainjidile mwanawe unalala nawe, wala uhiku waukile. ");
INSERT INTO kde_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Bahi avala vali vanga Lutu vammalele nkuva na vitumbo vya atata wao. ");
INSERT INTO kde_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ayula mwali ntandi nkummaleka mwana wachilume, nkunchema Moabu. Aneyo njo anakulwao Vamoabu mpaka nelo. ");
INSERT INTO kde_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Na ayula mwali n'joko nanang'e nkummaleka mwana wachilume, nkunchema Benami. Aneyo njo anakulwao Vaamoni mpaka nelo. ");
INSERT INTO kde_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Bahi Iblahimu nkuuka, nkuloja maeneo la kulilanga lya Negebu, livêle mpata wa kusini, nkunaikala ching'ati Kadeshi na ku Shuli. Anepo nkuuka nkuhwena unaikala kwa mahiku kadiki aneko ku Gelali. ");
INSERT INTO kde_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Iblahimu panavele aneko ku Gelali áhawile kuva, Sala n'jawe nni nnumbuwe. Bahi nfalume Abimeleki wa ku Gelali nkuntwala Sala. ");
INSERT INTO kde_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Henga Nnungu nkumwidila Abimeleki muindoto nkunnyaulila kuchidoni, “Wako ùmbekuhwa ing'anya ya mmahe untwete, kwa kuva àvele na ntwave.” ");
INSERT INTO kde_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimeleki ávele akànambilala nawe, bahi nkunnyang'ula Nang'olo kuchidoni, “Nang'olo, ùmbevawalala dachi vanu vakávele na likosa? ");
INSERT INTO kde_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Iblahimu mwene tenda njo ahawîle kuva ayu mmahe nni nnumbuwe? Tena ata Sala mwene áhawile kuva Iblahimu ni nkuluwe. Alano langútendìlè nangu, ngùlatendile chihi bila kuhukumika muntima na wala nikee na likosa.” ");
INSERT INTO kde_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Bahi Nnungu nkunnyaulila Abimeleki muindoto aneyo kuchidoni, “Elo, nangu ǹnimala kuva ùtendile chihi bila kuhukumika muntima, na nangu njo nikudividîle unangutende masambi, njo mana nangu nanga pannakulekile un'guse aneyo mmahe. ");
INSERT INTO kde_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Hambi nnudise aneyo mmahe kwa ntwave. Iblahimu ni nabii, nang'e achiakuyuwile na wako uchiulame. Henga ukànannudise, uikale umala kuva wako pamo na vanu vako vammalele mùmbekuhwa.” ");
INSERT INTO kde_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Bahi ulyamba namambumbu, Abimeleki nkutakatuka, nkuvachema maafisa vake vammalele na kuvahaulila mambo lalalotile, vanang'o nkuyopa namene. ");
INSERT INTO kde_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Anepo Abimeleki nkunchema Iblahimu nkummuja kuchidoni, “Ùtutendeledile chani wako? Nangu nìkukosedile chani mpaka ukudungile kungutenda ngùùve na likosa ling'ulungwa malinga ali, nangu na ufalume wangu? Wako ùngutendeledile mambo lakálembelewa kutendwa. ");
INSERT INTO kde_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Dachi, chinu ntwani chikutendîle utende uchocho?” ");
INSERT INTO kde_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Iblahimu nkunnyang'ula kuchidoni, “Nangu ngùtendile uchocho ing'anya ngútenda kuva apano nanga munu annyôpa Nnungu, na ngúyopa munanguwalala nkuntwala n'jangu. ");
INSERT INTO kde_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Pamo na anelo, ni muhiu kuva aneyo mmahe nnumbwangu, kwa kuva atata wetu yumo, henga tùtindene kumama, njo mana àjukile kuva n'jangu. ");
INSERT INTO kde_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Nnungu pananguhaulidile niileke ing'ande ya atatangu koka nguhwene kumidi, nangu nínnyaulidile n'jangu kuva, “Pachinu pohepo patumbehwena, wako haula kuva nangu ninkululo. Ukàtenda uchocho njo paumbelanguja kuva unangutamwa.” ");
INSERT INTO kde_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Bahi Abimeleki nkunnudisija Iblahimu n'jawe, nkumwing'a na dingandolo na ding'ombe na vatumwa va chilume na vachimahe. ");
INSERT INTO kde_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimeleki nkunnyaulila Iblahimu kavila kuchidoni, “Lola, chilambo achino chammalele chang'une! Bahi tandola pachinu pohepo paulambela, uikale.” ");
INSERT INTO kde_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Abimeleki nkunnyaulila Sala kuchidoni, “Nangu nìmwing'a nkululo vipande alufu moja vya madini la dihela. Ngùtenda uchocho uchinga nnààve na likosa, na ilanguje kuva wako nanga pauvêle na likosa.” ");
INSERT INTO kde_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Anepo Iblahimu nkunnyuwa Nnungu, na Nnungu nkunnamya Abimeleki chalumo na n'jawe na vatumwa vake, na kuvahululiha kuveleka kavila vana. ");
INSERT INTO kde_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Kwa kuva, anepo patandi Yahwe ánilahunga matumbo la vanu va nng'ande mwa Abimeleki ing'anya ya Sala, n'jawe Iblahimu. ");
INSERT INTO kde_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yahwe nkum'baliki Sala kwa kuntendela muchi chanamwahidite. ");
INSERT INTO kde_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Bahi Sala nkwikuta chitumbo, nkummalekela Iblahimu mwana wachilume akuno Iblahimu avèlè nsele namene. Na anelo láhumidile mmahiku ulala lanahawile Nnungu. ");
INSERT INTO kde_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Mwana ayula, Sala wammelekedile Iblahimu, Iblahimu nkunchema lina Isaka. ");
INSERT INTO kde_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Isaka panavele na changa cha maduva nane, Iblahimu nkunnyalula malinga chanalaijijwe nawi Nnungu. ");
INSERT INTO kde_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Pavelekwejije Isaka, Iblahimu ávele na vyaka myamoja. ");
INSERT INTO kde_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Bahi Sala nkuchidoni, “Nnungu àngutendile nguheke, na munu woheyo ambepilikâna habali adino, àmbelihekela chalumo na nangu. ");
INSERT INTO kde_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Dachi, nnani achichiahulule kunnyaulila Iblahimu kuva, nangu Sala nguchinguyong'eje vavana? Tena nìmmelekedile mwana wachilume muusele wake!” ");
INSERT INTO kde_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Isaka nkuhweneha kukulumuka, na liduva alila livanannekehije kuyong'a, Iblahimu nkuntendela Isaka ing'ole ing'ulungwa. ");
INSERT INTO kde_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Liduva limo Sala ámmwene Isumaili, mwana wanga Iblahimu wammelekedile Hajili, nkongwe wa ku Misili, wannembula Isaka mwanawe. ");
INSERT INTO kde_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Bahi Sala nkunnyaulila Iblahimu kuchidoni, “Mmingange ayu ntumwa chalumo na mwanawe, kwa kuva ikáhululika mwana wanga ntumwa kupata mapala pamo na mwanangu Isaka.” ");
INSERT INTO kde_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Chinu anecho chíninnyundaja namene Iblahimu, kwa kuva Isumaili nanang'e nni mwanawe. ");
INSERT INTO kde_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Henga Nnungu nkunnyaulila Iblahimu kuchidoni, “Unayundale ing'anya ya aneyo mwana, wala aneyo ntumwa wako. Chinu chohecho chambekuhaulila Sala wako chitende, kwa kuva, vanu va nnukolo lwako vàmbehalokana na Isaka. ");
INSERT INTO kde_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Na kwamba aneyo mwana wanga ntumwa wako, nanang'e nìmbentenda kuva atata wa chilambo chikulungwa, kwa kuva, nanang'e nni mwanalo.” ");
INSERT INTO kde_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Bahi ulyamba namambumbu, Iblahimu nkutwala chakulya na medi, nkunnyakuja Hajili mmavala, nkumminganga chalumo na mwanawe. Hajili nkuuka, nkuva wadumba-dumba nnilanga lya ku Beli-sheba. ");
INSERT INTO kde_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Àlalá medi palannyilidile, Hajili nkunnaja mwanawe pachihole. ");
INSERT INTO kde_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Anepo Hajili nkuhwena kunyenje kadiki, malinga mita myamoja uvila, walitangolela chimunda-munda kuchidoni, “Nikátamwa nimwone mwanangu pámbekùvà wahwa.” Hajili panaikele anepo, nkukuta kwa uchungu. ");
INSERT INTO kde_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Nnungu nkumpilikana mwana wakuta, malaika wanga Nnungu nkunchema Hajili kuhaloka kulihunde nkunnyaulila kuchidoni, “Chikutendile chani Hajili? Bahi unayope, ing'anya Nnungu ànipilikana chitangelo chake kuhaloka apala pávèlè. ");
INSERT INTO kde_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Imila uhwene ukampembeje mwana kwa kuva, nìmbentenda kuva chilambo chikulungwa.” ");
INSERT INTO kde_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Bahi Nnungu nkunkusumbula Hajili meho, nkuchona chihima cha medi. Nang'e nkuhwena unateka medi, nkunankumbija mwanawe. ");
INSERT INTO kde_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Bahi Nnungu nkunchunga ayula mwana, na aneyo mwana nkuhweneha kukulumuka. Nkuikala kulilanga, na nkuva munu amaîte kutemelela saana upinde. ");
INSERT INTO kde_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Mwana aneyo áikala kulilanga lya Palani, na anyokwe nkunnembelela mmahe kuhaloka nchilambo cha ku Misili. ");
INSERT INTO kde_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Bahi mmahiku ulolo, Nfalume Abimeleki pamo na Fikoli, nkulungwa wa matiyala lake, nkummwenela Iblahimu, nkunnyaulila kuchidoni, “Nnungu àvele pamo na wako kwa kila chinu chiutenda. ");
INSERT INTO kde_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Bahi ngwapilile kwa lina lya Nnungu kuva nanga paumbengulambila nangu wala vana vangu wala vanu va nnukolo lwangu. Malinga chinikutendedile nangu lambone, na wako uchocho ngutendele nangu lambone chalumo na vanu va chilambo achino chuwikala. ");
INSERT INTO kde_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Iblahimu nkuchidoni, “Mbènkwapila kuva nguchingutende uchocho.” ");
INSERT INTO kde_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Mmahiku anelo Iblahimu nkunhinginikila Abimeleki kwamba chihima cha medi chivanampakanywele vatumwa vanga Abimeleki. ");
INSERT INTO kde_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Henga Abimeleki nkunnyaulila Iblahimu kuchidoni, “Nangu nikánkameke atendîle uchocho, na nanga paunanguhaulidile. Nangu nelo njo kupilikana habali anedyo.” ");
INSERT INTO kde_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Bahi Iblahimu nkutwala dingandolo na dimbudi na ding'ombe, nkumwing'a Abimeleki, vammalele vavili nkutenda lilailano. ");
INSERT INTO kde_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Iblahimu nkudihapula dingandolo saba dya chimahe. ");
INSERT INTO kde_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimeleki nkummuja Iblahimu kuchidoni, “Ing'anya ntwani ùvahapula anevo angandolo saba va chimahe?” ");
INSERT INTO kde_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Iblahimu nkunnyang'ula kuchidoni, “Avano angandolo saba vachimahe ngùyuwa uvapwechelele kuhaloka kwang'une, uchinga ùùve ushahidi kuva nangu njo nguhimbîle chihima achino.” ");
INSERT INTO kde_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Bahi apala pachinu nkupachema Beli-sheba, kwa kuva vammalele vavili vániapilanila pachinu anepo. ");
INSERT INTO kde_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Bada ya kutenda lilailano anelyo aneko ku Beli-sheba, Abimeleki na Fikoli, nkulu wa matiyala lake nkuuyang'ana kwavo, chilambo cha Vafilisti. ");
INSERT INTO kde_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Iblahimu nkupanda nnandi wa nkwaju akula ku Beli-sheba, nkunnyuwa Yahwe, Nnungu wa vyaka na vyaka. ");
INSERT INTO kde_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Bahi Iblahimu nkuikala nchilambo cha Vafilisti kwa vyaka vyohe malinga mmidi. ");
INSERT INTO kde_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Bada ya myaka fulani, Nnungu nkuilinga ing'ulupa yanga Iblahimu. Nnungu nkunchema Iblahimu wachidoni, “Iblahimu!” Iblahimu nkunnyang'ula kuchidoni, “Nangu apano.” ");
INSERT INTO kde_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Nnungu nkuchidoni, “Ntwale mwanalo Isaka, mwana uyoyo yumo, untâmwa namene, uhwene nawe mpaka chilambo cha ku Moliya, unhumye kuva sadaka ya kupija moto nnichinga linimbekulanguja.” ");
INSERT INTO kde_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Bahi liduva lipapête, Iblahimu nkutakatuka ulyamba namambumbu, nkuntayalisha saana punda wake, nkuvatwala vatumishi vake vavili pamo na Isaka mwanawe. Nkutayalisha ding'uni kwajili ya sadaka ya kupija moto, anepo nkutandilika mwanda kuhwena pachinu pannyaulidile Nnungu ahwene. ");
INSERT INTO kde_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Nniduva lya tatu lya mwanda wavo, Iblahimu palolite meho muyo, nkupona anepo pachinu kwa kulehu uvila. ");
INSERT INTO kde_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Iblahimu nkuvahaulila vatumishi vake kuchidoni, “Mwenu chalumo na ayu punda ngulindange upano, nangu pamo na mwanangu tùmbehwena akula, tukamwabudu Nnungu, koka tunkojange.” ");
INSERT INTO kde_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Bahi Iblahimu nkuditwala adila ding'uni, nkunnyakuja Isaka mwanawe, mwene nkunyakula moto na chipula, nkuukananga. ");
INSERT INTO kde_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaka nkummuja atatake kuchidoni, “Eti atata!” Atatake nkuyambukila kuchidoni, “Nangu apano mwanangu!” Isaka nkuchidoni, “Moto na ding'uni tunivanadyo, hambi ungandolo wa sadaka ya kupija moto àvele kwachi?” ");
INSERT INTO kde_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Iblahimu nkunnyang'ula kuchidoni, “Mwanangu, Nnungu mwene achiatwing'e.” Bahi nkuhweneha na mwanda wavo. ");
INSERT INTO kde_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Pavakamwele pachinu pannyaulidile Nnungu ahwene, Iblahimu nkudenga chitala, nkupanga ding'uni muha mwake. Anepo nkunnyunga Isaka mwanawe, nkunnaja n'ding'uni, divêle muha chitala. ");
INSERT INTO kde_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Iblahimu nkunyaloja nkono wake, nkutwala chipula uchinga ansinje mwanawe. ");
INSERT INTO kde_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Henga malaika wanga Yahwe nkunchema Iblahimu kuhaloka kulihunde wachidoni, “Iblahimu! Iblahimu!” Nang'e nkwitika, “Nangu apano!” ");
INSERT INTO kde_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Malaika nkunnyaulila Iblahimu kuchidoni, “Unansinje mwana na wala unantende chinu chohecho! Hambi ǹnimala kuva unamweshimu Nnungu, kwa kuva nanga paungwimile kananga mwanalo uyoyo yumo.” ");
INSERT INTO kde_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Iblahimu nkunyamula meho lake, nkumwona ungandolo nannume nnyuma mwake ahavikwìjè dimembe dyake nchihole. Bahi nkuhwena, nkuntwala ayula ungandolo, nkunhumya sadaka ya kupija moto badala ya mwanawe. ");
INSERT INTO kde_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Bahi Iblahimu nkupachema anepo pachinu “Yahwe-Yile,” yani, Yahwe ànajalila,” malinga chiihaulika mpaka nelo kuva, “Palichinga lyanga Yahwe, vanu vànajaliwa.” ");
INSERT INTO kde_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Bahi malaika wanga Yahwe nkunchema Iblahimu mwanda wavili kuhaloka kulihunde, ");
INSERT INTO kde_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","nkunnyaulila kuchidoni, “Yahwe àhaula uvila, ‘Nangu ǹniapila kwa lina lyangu nimwene kuva, ing'anya ùtendile uvila, na wala nanga pungwimile mwanalo uyoyo uyumo, ");
INSERT INTO kde_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","muhiu nìmbekubaliki, na vanu va nnukolo lwako nìmbevatenda kuva vohe malinga dinondwa dya kumahunde na nnyangi uvêle nnyenje bahali. Vanu va nnukolo lwako vàmbevalema amongo vao na kuditwala litwala dimanga dyavo. ");
INSERT INTO kde_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Kupitila vanu va nnukolo lwako, nìmbevabaliki vanu va vilambo vyammalele vya pachilambo ing'anya wako ùniipilikana amuli yangu.” ");
INSERT INTO kde_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Bahi Iblahimu nkuuya kwa avala vatumishi vake akuno alongènè na mwanawe Isaka, vammalele nkuukananga, nkuuya ku Beli-sheba. Na Iblahimu nkuikala aneko ku Beli-sheba. ");
INSERT INTO kde_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Bada ya anelo, munu fulani nkunnyaulila Iblahimu kuchidoni, “Milika, nkongwe wa Naholi nnung'uno, nanang'e àvaveleke vana nane vachilume. ");
INSERT INTO kde_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Mwanawao ntandi vànchema Uzi, na wavili vànchema Buzi na yunji vànchema Kemueli, atatake Alamu. ");
INSERT INTO kde_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Na vana vanji nni, Kesedi, na Hazo, na Pildashi na Idilafu na Besueli. ");
INSERT INTO kde_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Besueli nkummaleka Labeka. Milika ámmelekedile Naholi, nnung'une Iblahimu vana anevo nane. ");
INSERT INTO kde_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Uchocho, Naholi ávele na n'jawe ntumwa uvanchema Leuma, nanang'e nkummelekela Naholi vana ncheche, yani Teba na Gahamu na Tahashi na Maaka. ");
INSERT INTO kde_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sala pahwikihije vyaka myamoja ishilini na saba, ");
INSERT INTO kde_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","nkuhila aneko kuimanga ya Kiliasi-Alba, yani Hebloni, nchilambo cha ku Kanaani. Iblahimu nkunkutangila namene Sala n'jawe. ");
INSERT INTO kde_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Iblahimu nkuuleka mmili wa n'jawe, nkuhwena unatangola na Vahiti, nkuvahaulila kuchidoni, ");
INSERT INTO kde_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Apano nangu ni mmidi. Bahi ngùyuwa pachinu pakukatapaja nsati, uchinga ngupate kunsika n'jangu.” ");
INSERT INTO kde_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Vahiti nkunnyang'ula Iblahimu kuchidoni, ");
INSERT INTO kde_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Tupilikanile nang'olo wetu! Wako nni munu nkulu namene kwetu hwetu. Wako tandola chihi pachinu pohepo pambone pakunsika n'jalo, na wala nanga munu woheyo muhwetu ambekwîma kukusumisa pachinu pakunsika n'jalo.” ");
INSERT INTO kde_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Bahi Iblahimu nkuimila na kutepa kwa eshima muyo mwa avala Vahiti, vene chilambo, ");
INSERT INTO kde_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","nkuvahaulila kuchidoni, “Bahi kwa kuva mùninguluhusu kunsika n'jangu, hambi ngùyuwa mukannyuwe Efuloni, mwana wanga Sohali kwajili yangu, ");
INSERT INTO kde_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","uchinga angusumise lipanga lyake lya ku Makipela livêle nnipalu lya welu wake. Nnyuwange namene angusumise pachinu anepo uchinga nipajuhe kuva pachinu pangu pakusikila. Na nangu nguchingulipe bei yoheyo ilinganâna na pachinu anepo, muyo mwenu.” ");
INSERT INTO kde_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Mwene Efuloni ávele nnikuwa anelyo lya Vahiti vanakojene pannango wa imanga. Bahi Efuloni, Mhiti nkunnyang'ula Iblahimu muyo mwa Vahiti vammalele apala pannango kuchidoni, ");
INSERT INTO kde_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Nanga nang'olo. Chonde nangu ngùyuwa ungupilikanile. Nangu nìkwing'a aula welu wammalele na lipanga alila livêle mmwelu anewo, na nìkwing'a muyo mwa Vahiti avangu, unsike anemwo n'jalo.” ");
INSERT INTO kde_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Bahi Iblahimu nkutepa kavila kwa eshima muyo mwa venedi va chilambo anecho, ");
INSERT INTO kde_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","nkunnyaulila Efuloni akuno Vahiti vammalele uvapilikànà kuchidoni, “Chonde nangu ngùyuwa ungupilikane. Ngùyuwa ungusumise welu wako, na upwechele malipo anelo uchinga ngupate kunsika n'jangu.” ");
INSERT INTO kde_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efuloni nkunnyang'ula Iblahimu kuchidoni, ");
INSERT INTO kde_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Ngupilikanile, nang'olo. Anewo welu ùvele na samani ya vipande myanne vya madini la dihela, henga anecho chikee chinu chikulu kati yangu na wako. Wako nsike chihi n'jalo.” ");
INSERT INTO kde_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Iblahimu nkwelewana na Efuloni, nkumwing'a avila vipande vya dihela vyanatambulenge muyo mwa Vahiti vammalele, yani vipande myanne vya madini la dihela vivanapimile kulinganana na vipimo vya akúchuusa va mahiku anelo. ");
INSERT INTO kde_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Bahi welu wanga Efuloni wa aneko ku Makipela, pepi na ku Mamle, chalumo na lipanga na milandi yammalele inavele mmwelu anewo, vyammalele nkupewa Iblahimu kuva vyake, ");
INSERT INTO kde_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","muyo mwa Vahiti vammalele vanakojene pannango wa imanga. ");
INSERT INTO kde_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Bada ya anelo, Iblahimu nkunsika Sala n'jawe nnipanga alila livêle amula mmwelu wa ku Makipela, pepi na ku Mamle, yani Hebloni, nchilambo cha ku Kanaani. ");
INSERT INTO kde_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Bahi kwa indila aneyo njo Vahiti chivanankamujije Iblahimu welu na lipanga livêle mmwelu anewo, uchinga apate kuvasikila vanu vake. ");
INSERT INTO kde_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Mmahiku anelo Iblahimu ávele nsele wa vyaka vyohe, na Yahwe ánim'baliki kwa kila chinu chachitendile. ");
INSERT INTO kde_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Liduva limo Iblahimu nkunnyaulila ntumishi wake anantumikidile kwa vyaka vyohe kupunda vanji, nkwímilila wa dimali dyake dyammalele kuchidoni, “Ngwapilile kwa kutaya nkono wako munnyonga mwangu. ");
INSERT INTO kde_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Apila kwa Yahwe, Nnungu aumbîle kumahunde na chilambo kuva, ukambemposija mwanangu, mwali woheyo wa Chikanaani, unguikala navo nchilambo achino. ");
INSERT INTO kde_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Unguapile kuva ùmbehwena mpaka nchilambo changu, kwa alangavangu, untahije mmahe, mwanangu Isaka.” ");
INSERT INTO kde_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ayula ntumishi nkunnyaulila Iblahimu kuchidoni, “Aneyo mmahe akàhita kulangana na nangu kwida akuno, dachi lasima nimpelekeje mwanalo nchilambo chiuhaleke?” ");
INSERT INTO kde_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Iblahimu nkunnyang'ula kuchidoni, “Nanga! Chonde ngùyuwa unampelekeje mwanangu aneko. ");
INSERT INTO kde_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yahwe, Nnungu aumbîle kumahunde, anguusîje nng'ande mwa atatangu, na nchilambo changu chinguvelekwejije, Nnungu anatongwêle na nangu, áninguapilila kuva, àmbeveng'a vanu va nnukolo lwangu chilambo achino. Nang'e àmbentuma malaika wake muyo mwako uchinga wako umpelekejije mwanangu mmahe kuhaloka aneko. ");
INSERT INTO kde_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ikàva mmahe aneyo akambetamwa kulangana na wako mpaka akuno, bahi chiapilo changu chikambekuhunga, henga kwa namuna yoheyo, unampelekeje mwanangu aneko.” ");
INSERT INTO kde_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Bahi ayula ntumishi nkutaya nkono wake munnyonga mwanga Iblahimu nang'olo wake, nkwapila kwamba chinu anecho. ");
INSERT INTO kde_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Anepo ayula ntumishi nkuvatwala angamila kumi va nang'olo wake, nkutandilika mwanda akuno anyakwìlè dinudyo dikatapêle dya kila namuna kuhaloka kwa nang'olo wake. Nkuhwena mpaka imanga yachiikala Naholi, nchilambo cha ku Mesopotamiya. ");
INSERT INTO kde_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Pahwikile, nkuvatindivaja malundi angamila vake nnyenje chihima cha medi chivêle kunyenje imanga uchinga asulupuke. Na anewo wavele uhiku wa chinalyulo, uhiku uvahwena vakongwe unateka medi. ");
INSERT INTO kde_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Aneyo ntumishi nkuyuwa wachidoni, “Yahwe, Nnungu wa nang'olo wangu Iblahimu, nelo nangu ngùyuwa ungujalile kuchipata achila chinguidilidile, na untendele lambone nang'olo wangu Iblahimu kwa ikulupiki yako yammalele. ");
INSERT INTO kde_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Lola, nangu ngùvele apano pepi na chihima achino cha medi chivaida vali, venedi va imanga unateka medi. ");
INSERT INTO kde_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Bahi mwali unimbennyaulila kuva tula chitumba chako cha medi uning'e medi ngukumbile, nanang'e nkuning'a medi na kuvakumbija angamila vangu, bahi aneyo njo ààve nkongwe untandoledile ntumishi wako Isaka. Na chinu anecho chichichingumaihe kuva ùntendeledile lambone nang'olo wangu Iblahimu kwa ikulupiki yako yammalele.” ");
INSERT INTO kde_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Bahi kabla akànambimalila kuyuwa, upala nkuhaloka Labeka akuno anyakwìlè chitumba chake nnivala lyake. Labeka ávele mwali wanga Besueli, na Besueli ávele mwana wanga Milika, anavele mmahe wa Naholi, nnung'une Iblahimu. ");
INSERT INTO kde_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ayula mwali ánikatapala namene kumeho na ávele akànambimmala nnume. Bahi ayula mwali nkuhelelekela kuchihima, nkuumbaja chitumba chake medi, nkuyamboka. ");
INSERT INTO kde_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Anepo ayula ntumishi nkuhwena unakojana nawe upehi, nkunnyaulila kuchidoni, “Chonde mbeyele medi la kukumbila kuhaloka nchitumba chako.” ");
INSERT INTO kde_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ayula mwali nkunnyang'ula kuchidoni, “Aya kumbila nang'olo wangu.” Upala nkusulupusa chitumba chake nnivala, nkukamulila mmakono, nkunkumbija. ");
INSERT INTO kde_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Bada ya kunkumbija, ayula mwali nkuchidoni, “Nguchinguvatekele medi na angamila vako, vakumbile mpaka vatolele.” ");
INSERT INTO kde_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Bahi ayula mwali nkupiyanya kumiminila medi nchombo cha kuvakumbijija anyama medi, nkupeya kuhwena kuchihima unateka medi lanji, nkuvakumbija angamila vake vammalele. ");
INSERT INTO kde_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Bahi ayula ntumishi nkuva wannoleha saana bila kutangola chinu chohecho, uchinga apate kumala ikàva Yahwe àniujalila mwanda wake au nanga. ");
INSERT INTO kde_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Angamila pavatoledile medi, ayula ntumishi nkumwing'a ayula mwali chipini cha zahabu cha samani ing'ulu na dibangili dimbili dya zahabu dya samani ing'ulu. ");
INSERT INTO kde_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Nkummuja kuchidoni, “Chonde nguhaulile, wako nni mwali wanga nnani? Dachi, pànipwawa pachinu pakulala nng'ande mwa atatako kwajili yetu?” ");
INSERT INTO kde_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Labeka nkunnyang'ula kuchidoni, “Nangu nni mwali wanga Besueli, mwana wanga Milika, mmahe wanga Naholi. ");
INSERT INTO kde_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Kwetu hwetu kùvele mahahi na vyakulya vinji vya kutosha kuvalisha anyama vohe, na pachinu pakulala vayeni.” ");
INSERT INTO kde_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Bahi ayula ntumishi nkuhunama mpaka pahi, nkumwabudu Yahwe, ");
INSERT INTO kde_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","wachidoni, “Atumbyangwe Yahwe, Nnungu wanga nang'olo wangu Iblahimu. Nang'e àvechinkuva wambone na wakukulupilika kwa nang'olo wangu. Yahwe àningulodya nangu mpaka kwa alangavake nang'olo wangu!” ");
INSERT INTO kde_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Bahi ayula mwali nkutukuta uhwena unavahaulila habali anedyo vanu vammalele va nng'ande mwa anyokwe. ");
INSERT INTO kde_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Labeka ávele na nkuluwe uvanchema Labani. Labani pachiwene achila chipini na adila dibangili mmakono mwa nnumbuwe na kupilikana malove àlalá lanatangwele ayula munu kunnyaulila Labeka, bahi nkuuka watukuta uhwena unakojana na aneyo munu akula kuchihima. Pahwikile, nkunkoja ayula ntumishi aimidìlè pepi na angamila vake nnyenje chihima. ");
INSERT INTO kde_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Labani nkunnyaulila kuchidoni, “Kalibu kukaya, wako ubalikiwîje nawi Yahwe. Mwadachi ùimidile chihi akuno panda imanga? Nangu ǹnitayalisha ing'ande kwajili yako na pachinu pakuvavika anevo angamila vako!” ");
INSERT INTO kde_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Bahi ayula ntumishi nkuhwena nawe kukaya kwavo. Labani nkuvalaija vanu vavahungule angamila misigo, na kuveng'a mahahi na vyakulya vinji. Uchocho, nkumwing'a ayula ntumishi medi la kukalava mmadodo, nang'e chalumo na vanu vake. ");
INSERT INTO kde_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Bahi nkumwing'a chakulya, henga nang'e nkuchidoni, “Nikambekulya mpaka ninnyaulilange àlalá langulembela kuhaula.” Labani nkunnyaulila kuchidoni, “Bahi haula nano.” ");
INSERT INTO kde_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ayula munu nkuchidoni, “Nangu ni ntumishi wanga Iblahimu. ");
INSERT INTO kde_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yahwe ànim'baliki namene nang'olo wangu, na vino àjukile kuva munu nkulu. Yahwe ànimwing'a dingandolo na ding'ombe na angamila na punda vohe na madini la dihela na zahabu na vatumwa vachilume na vachimahe. ");
INSERT INTO kde_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Na Sala, anavele mmahe wa nang'olo wangu, ata kama ánikongopala, henga ámmelekedile nang'olo wangu mwana wachilume, na nang'olo wangu àmpele aneyo mwana vitukutuku vyammalele vyavenavyo. ");
INSERT INTO kde_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Na nang'olo wangu àningwapilila wachidoni, ‘Unamposije mwanangu mmahe woheyo muvali va Chikanaani, chilambo achino chinguikala. ");
INSERT INTO kde_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Henga hwena mpaka kwa alangavake atatangu, yani kulitawa lyangu nimwene uchinga ukantahije mwanangu Isaka mmahe.’ ");
INSERT INTO kde_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Nangu nkummuja nang'olo wangu kuchidoni, ‘Ìmbekuva dachi mmahe aneyo akàhita kwida akuno?’ ");
INSERT INTO kde_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Henga nang'e nkunguyang'ula kuchidoni, ‘Yahwe angulôja nangu mmaisha langu, achiannaije malaika wake ahwene pamo na wako na kuujalila mwanda wako uchinga untwalile mwanangu, mmahe kuhaloka kwa alangavake atatangu na kulitawa lyangu nimwene. ");
INSERT INTO kde_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Paumbehwika kwa alangavangu, na vakànakwing'e aneyo mwali, anepo wako nanga paumbehungwa na chiapilo chinikuapishije.’ ");
INSERT INTO kde_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Na nelo panguhwikile kuchihima, nangu nkuyuwa kuchidoni, ‘Wako Yahwe, Nnungu wa nang'olo wangu Iblahimu, nelo nakuyuwa uujalile mwanda wangu na untendele lambone nang'olo wangu. ");
INSERT INTO kde_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Lola, nangu ngùvele apano nnyenje chihima achino cha medi. Mwali ambeîda unateka medi, unimbennyuwa medi kadiki la kukumbila la nchitumba chake, ");
INSERT INTO kde_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","nanang'e nkuning'a na kuvatekela angamila vangu medi, bahi aneyo ààve mmahe untandwêle kuva mmahe wa mwana wa nang'olo wangu.’ ");
INSERT INTO kde_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Kabla nikànambimalila kuyuwa muntima mwangu, upala Labeka nkukamola akuno anyakwìlè chitumba chake nnivala, nkuhelelekela kuchihima unateka medi. Nangu nkunnyaulila kuchidoni, ‘Chonde mbeyele medi ngukumbile.’ ");
INSERT INTO kde_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Upala nang'e nkupiyanya kuchisulupusa chitumba chake cha medi nnivala nkuhaula kuchidoni, ‘Kumbila. Na nguchinguhwene nikavatekele angamila vako medi.’ Bahi nangu nkukumbila, na nang'e nkuveng'a na angamila vangu medi. ");
INSERT INTO kde_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Anepo nangu nkummuja kuchidoni, ‘Wako nni mwali wanga nnani?’ Nang'e nkunguyang'ula kuchidoni, ‘Nangu ni mwali wanga Besueli, mwana wanga Milika, mmahe wanga Naholi.’ Nangu nkummika chipini mwimula yake na kummwaja dibangili mmakono mwake. ");
INSERT INTO kde_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Anepo nangu nkuhunama mpaka pahi, nkumwabudu Yahwe. Nkuntumbyanga Yahwe, Nnungu wa nang'olo wangu Iblahimu, angulojîje mwalehu mpaka kwanga mwali, udukulu wanga nnung'une mwene nang'olo wangu uchinga nintwale kwajili ya mwanawe. ");
INSERT INTO kde_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Hambi nguhaulilange ikàva mùvele tayali kuntendela nang'olo wangu uwambone na kwa ikulupiki. Na ikànave uchocho, bahi nguhaulile uchinga ngumale chakutenda.” ");
INSERT INTO kde_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Labani na Besueli pavapilikene uchocho, nkunnyang'ula kuchidoni, “Chinu achino chìhaleke kwa Yahwe, na hwetu nanga patumbehulula kuhita. ");
INSERT INTO kde_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Labeka ayuno apano, wako ntwale uhwene nawe, ààve mmahe wa mwana wa nang'olo wako malinga chahawile Yahwe.” ");
INSERT INTO kde_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ayula ntumishi wanga Iblahimu papilikene uchocho, nkuhunama mpaka pahi, nkumwabudu Yahwe. ");
INSERT INTO kde_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Anepo nkuhumya vitukutuku vikatapajîjwe kwa zahabu na kwa madini la dihela pamo na dinguwo, nkumwing'a Labeka. Uchocho, nkumwing'a nnumbuwe Labeka na anyokwe, dinujo digalîka namene. ");
INSERT INTO kde_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Bahi ayula ntumishi wanga Iblahimu chalumo na vanu avala vanalongêne nawe, nkulyanga, nkukumbila na kulala aneko. Ulyamba pavatakatwike, ayula ntumishi nkuchidoni, “Nangu ngùyuwa nguuye kwa nang'olo wangu.” ");
INSERT INTO kde_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Henga nnumbuwe Labeka na anyokwe nkuchidoni, “Nneke ayuno mwali aikale na hwetu kadiki, malinga maduva kumi uvila, koka uhwene nawe. ");
INSERT INTO kde_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Henga ayula ntumishi nkuchidoni, “Chonde munangutimye, kwa kuva Yahwe àniujalila mwanda wangu, bahi ngùyuwa munguluhusu nguuye kwa nang'olo wangu.” ");
INSERT INTO kde_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Vanang'o nkuchidoni, “Hoti tuncheme mwali mwene, tummuje.” ");
INSERT INTO kde_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Nkunchema Labeka nkummuja kuchidoni, “Uchiuhwene na ayuno munu?” Nang'e nkuyang'ula kuchidoni, “Nguchinguhwene nawe.” ");
INSERT INTO kde_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Bahi nkunnailanga Labeka, nkunneka ahwene na ayula ntumishi wanga Iblahimu na vanu vake pamo na yaya annedîle Labeka. ");
INSERT INTO kde_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Bahi nkum'baliki Labeka, nkunnyaulila kuchidoni, “Wako nnumbwetu Labeka, ùùve mama wa maelufu kwa maelufu la vanu, na vanu va nnukolo lwako vaditwale dimanga dya amongo vao kuva dyavo.” ");
INSERT INTO kde_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Bahi Labeka na vatumishi vake vachimahe nkuvakwela angamila nkupapatana na ayula ntumishi wanga Iblahimu, vammalele nkuhweneng'ana. ");
INSERT INTO kde_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Uhiku aula ntumishi wanga Iblahimu panavele mmwanda, Isaka áidile kukaya kwa Iblahimu atatake, kuhaloka ku Beli-Lahai-Loi nchilambo cha Negebu kwachiikala. ");
INSERT INTO kde_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Liduva limo chinalyulo, Isaka nkuuka nkuhwena kumawelu unachionga. Bahi palolite meho lake muyo, nkuvona angamila uvaida. ");
INSERT INTO kde_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Labeka nanang'e palolite meho lake muyo nkumwona Isaka, nkusulupuka pahi, ");
INSERT INTO kde_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","nkummuja ntumishi wanga Iblahimu kuchidoni, “Ayula avêle mmwelu nnani aîda unatupwechela?” Ayula ntumishi nkuchidoni, “Ayula nni nang'olo wangu.” Bahi Labeka nkutwala inguwo yake, nkulihunika kumeho. ");
INSERT INTO kde_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ayula ntumishi nkunnyaulila Isaka lammalele lalatendile. ");
INSERT INTO kde_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Bahi Isaka nkuntwala Labeka kuva n'jawe, nkuikala nawe mun'gongwe wa Sala, anyokwe. Isaka nkuntamwa namene Labeka, na kutujwa ntima wake ing'anya ya kuhwa kwa anyokwe. ");
INSERT INTO kde_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Iblahimu ánnombile nkongwe yunji uvanchema Ketula. ");
INSERT INTO kde_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Nkongwe aneyo nkummalekela Iblahimu vana sita vachilume, yani Zimlani na Yokishani na Medani na Midiani na Ishibaki na Shua. ");
INSERT INTO kde_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokishani nkummaleka Sheba na Dedani. Na vanu va nnukolo lwanga Dedani ni Vaashulu na Valetushi na Valeumi. ");
INSERT INTO kde_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Vana vachilume vanga Midiani vávele Efa na Efeli na Hanoki na Abida na Elida. Anevo vammalele njo vanavele vanu va nnukolo lwanga Ketula. ");
INSERT INTO kde_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Iblahimu nkumwing'a Isaka dimali dyake dyammalele kuva mapala lake. ");
INSERT INTO kde_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Henga Iblahimu kabla akànambikuhwa, nkuveng'a dinudyo vana va ajavake vatumwa, nkuvausa anevo vana nkuvapelekeja m'bali wa kumashaliki, kulehu na Isaka, mwanawe. ");
INSERT INTO kde_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Iblahimu áhidile akongopèlè namene, avèlè na vyaka vyohe namene, vyaka myamoja sabini na tano. Na bada ya kuhwa, nkuhwena unaikala pamo na anyakala vake, vanahidile kala. ");
INSERT INTO kde_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Isaka na Isumaili, vana vake Iblahimu, nkunsika atatawao nnipanga lya ku Makipela, pepi na ku Mamle, mmwelu unavele wanga Efuloni, mwana wanga Sohali, Mhiti. ");
INSERT INTO kde_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Welu anewo njo wanasumile mwene Iblahimu kwa Vahiti. Na anepo njo panasikwije Iblahimu na Sala n'jawe. ");
INSERT INTO kde_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Bada ya kuhwa Iblahimu, Nnungu nkum'baliki Isaka, mwana wanga Iblahimu. Na uhiku anewo Isaka áikala pepi na chihima cha Beli-Lahai-Loi. ");
INSERT INTO kde_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Aino njo histoliya ya vana vachilume vanga Isumaili, mwanawe Iblahimu, mwana wanammelekedile Hajili, Mmisili anavele ntumwa wanga Sala. ");
INSERT INTO kde_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Na alano njo malina lavo kupapatana na chivavelekwejije. Mwana ntandi ni Nebayosi nkwida Kedali nkwida Adibeli nkwida Mibisamu, ");
INSERT INTO kde_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","nkwida Mishima nkwida Duma nkwida Masha, ");
INSERT INTO kde_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","nkwida Hadadi nkwida Tema nkwida Yetuli nkwida Nafishi nkumalilikila Kedema. ");
INSERT INTO kde_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Anelo njo malina la vana kumi na mbili vanga Isumaili, na vana anevo vávele vatawâla va matawa lavo kumi na mbili. Na vanu vao váchemile malina la kaya dyavo na vijiji vyao kupapatana na malina la vana anevo. ");
INSERT INTO kde_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isumaili áhidile avèlè na vyaka myamoja salasini na saba, nkuhwena unaikala pamo na anyakala vake, vanahidile kala. ");
INSERT INTO kde_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Vanu va nnukolo lwanga Isumaili váikala eneo livêle ching'ati Havila na Shuli, mpata wa kumanga wa ku Misili, kulodya ku Ashulu. Vanu anevo vánihapukana na udukulu unji wanga Iblahimu. ");
INSERT INTO kde_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Aino njo histoliya ya Isaka, mwana wanga Iblahimu, na vanu va nnukolo lwake. ");
INSERT INTO kde_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaka panavele na vyaka alubaini nkunnomba Labeka, mwali wanga Besueli, Mwalamu wa ku Padani-Alamu. Labeka ávele nnumbuwe Labani. ");
INSERT INTO kde_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Labeka ávele ntonga, bahi Isaka nkunnyuwa Yahwe. Na Yahwe nkun'jalila, Labeka nkupata chitumbo. ");
INSERT INTO kde_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Chitumbo chívele cha vana mavila. Vana anevo nkuva uvatukuhana nnitumbo lyanga Labeka, nang'e nkuchidoni, “Mwadachi làng'oja alano?” Bahi nkuhwena unammuja Yahwe. ");
INSERT INTO kde_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Yahwe nkunnyaulila kuchidoni, “Vana vavili vavêle nnitumbo lyako vàmbekuva vilambo vivili, na matawa mavili lambehalokâna na vana umbevavelêka wako, làmbehapukana. Litawa limo lìmbekuva na dimongo kupunda linji, na mwana nkulungwa àmbentumikila n'joko.” ");
INSERT INTO kde_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Mahiku lake la kuveleka palakamwele, Labeka nkuvaveleka vana mavila. ");
INSERT INTO kde_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Mwana ntandi ávele wanahuvi, anavele na maleha mmili wammalele, nkunchema lina Esau. ");
INSERT INTO kde_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Wavili nkuvelekwa akuno ankamwìlè Esau chihing'ino, nkunchema lina Yakobo. Pavelekwejije Esau na Yakobo, Isaka ávele na vyaka sitini. ");
INSERT INTO kde_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Anevo vavana nkukulumuka, Esau nkuva munu akamêke saana kulumbata, na átamwa namene maisha la kwilanga. Henga Yakobo nkuva munu wakutungamana, na átamwa namene maisha la kuikala pakaya. ");
INSERT INTO kde_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Bahi Isaka nkuntamwa namene Esau, ing'anya Isaka ánatamwa namene kulya dinyama dyachilumbata, na Labeka nkuntamwa namene Yakobo. ");
INSERT INTO kde_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Liduva limo Yakobo pachitaleka susa ya dengu, Esau nkuuya kuhaloka kwilanga akuno avèlè na indala namene. ");
INSERT INTO kde_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Bahi Esau nkunnyaulila Yakobo kuchidoni, “Nangu ngùvele na indala. Chonde ngùyuwa ungumayele aneyo susa yanahuvi ngulye.” Aneyo njo ing'anya inantendile Esau achemwe Edomu, lina livêle na mana ya “wanahuvi.” ");
INSERT INTO kde_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakobo nkunnyaulila kuchidoni, “Ukàlembela ngusumise haki yako ya kuva umwana ntandi kuvelekwa.” ");
INSERT INTO kde_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau nkuchidoni, “Sawa! Nangu ngùvele pepi na kuhwa. Haki yangu ya kuva mwana ntandi kuvelekwa ìmbengufala chamani?” ");
INSERT INTO kde_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakobo nkunnyaulila kuchidoni, “Ngwapilile hoti.” Bahi Esau nkumwapilila na kunsumisa Yakobo haki yake ya kuva mwana ntandi kuvelekwa. ");
INSERT INTO kde_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Anepo Yakobo nkumwing'a Esau nkate na aila susa ya dengu. Esau nkulya na kukumbila, nkuuka nkulihwenela. Bahi uvila njo Esau chanaihebwile haki yake ya kuva mwana ntandi kuvelekwa. ");
INSERT INTO kde_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Bahi nkukamola indala inji nchilambo achila, tofauti na indala aila inahumidile mmahiku langa Iblahimu. Bahi Isaka nkuhwena ku Gelali kwanga Abimeleki nfalume wa Vafilisti. ");
INSERT INTO kde_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Yahwe nkunhumila Isaka nkunnyaulila kuchidoni, “Unahwene ku Misili, ila wako hwena ukaikale nchilambo chinimbekuhaulila. ");
INSERT INTO kde_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ikala nchilambo anecho malinga mmidi, nanangu nguchinguve pamo na wako na kukubaliki. Nangu nguchingutimise ahadi inimwahidite atatako Iblahimu, kwa kuva vilambo avino vyammalele nìmbekwing'a wako chalumo na vanu va nnukolo lwako. ");
INSERT INTO kde_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Vanu va nnukolo lwako nìmbevatenda kuva vohe namene malinga dinondwa dya kumahunde, na nìmbeveng'a vilambo avino vyammalele. Kupitila vanu va nnukolo lwako, nìmbevabaliki vanu va vilambo vyammalele vya pachilambo, ");
INSERT INTO kde_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","kwa kuva Iblahimu áningupilikana nangu na kulakamuliha malaijo langu na amuli dyangu na mashaliti langu na Sheliya dyangu.” ");
INSERT INTO kde_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Bahi Isaka nkuikala aneko ku Gelali. ");
INSERT INTO kde_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Valume va aneko pavammujije kwamba n'jawe, nang'e nkuvayang'ula kuchidoni, “Ayuno nnumbwangu.” Áhawile uchocho kwa kuva, áyopile venedi va chilambo anecho vanammwalala ing'anya ya Labeka, kwa kuva Labeka ávele nkongwe akatapêle namene. ");
INSERT INTO kde_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Bahi Isaka bada ya kuikala aneko maduva lohe, Abimeleki, nfalume wa Vafilisti, nkupenekela palidilisha lyake kulola pahi, nkumwona Isaka ankumbatidìlè Labeka, n'jawe. ");
INSERT INTO kde_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimeleki nkunchema Isaka nkunnyaulila kuchidoni, “Muhiu ayu n'jalo! Ing'anya ntwani úhawile kuva nnumbulo?” Isaka nkunnyang'ula kuchidoni, “Ngúyopa nawalalwa ing'anya yanga nang'e.” ");
INSERT INTO kde_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimeleki nkunnyang'ula kuchidoni, “Chinu ntwani achino chiututendeledile? Kwikave munu yumo muvanu vangu walàlà na n'jalo, wako ukanitutenda tùùve na likosa.” ");
INSERT INTO kde_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Bahi Abimeleki nkuhumya amuli kwa vanu vake vammalele kuva, “Munu woheyo ambentênda chinu chohecho chibaya munu ayu au n'jawe, achiawalalwe.” ");
INSERT INTO kde_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Mwaka anewo Isaka nkupanda dimbeyu nchilambo anecho, nkuvuna mafuno lohe namene, kwa kuva Yahwe ánim'baliki. ");
INSERT INTO kde_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Isaka nkutajilika, nkuhalija kupata dimali mpaka nkuva tajili nkulungwa namene. ");
INSERT INTO kde_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Isaka ávele na matunji la dingandolo na ding'ombe dyohe na vatumwa vohe, mpaka Vafilisti kumwonela wiu. ");
INSERT INTO kde_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Bahi Vafilisti nkuvihuhulila vihima vyammalele vya medi, vivanahimbile vatumwa vanga Iblahimu atatake, panavele mumi. ");
INSERT INTO kde_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Bahi Abimeleki nkunnyaulila Isaka kuchidoni, “Uka apano, kwa kuva wako ùvele na dimongo kutupunda hwetu.” ");
INSERT INTO kde_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Bahi Isaka nkuuka aneko, nkunaikala nnuhunde lwa Gelali. ");
INSERT INTO kde_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isaka nkuvihukula kavila avila vihima vya medi vivanahuhulidile Vafilisti bada ya kuhwa kwanga Iblahimu. Isaka nkuvichema malina ulala lanachemile atatake. ");
INSERT INTO kde_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Henga vatumishi vanga Isaka pavachihimba vihima amula nnuhunde, nkudawola medi lachikulula pahi kwa pahi, ");
INSERT INTO kde_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","henga vachunga va apala pa Gelali nkupwatana na vachunga vanga Isaka uvachidoni, “Alano medi letu.” Bahi Isaka nkuchichema achila chihima, “Eseki” kwa kuva vánipwatana nawe. ");
INSERT INTO kde_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Vatumishi vanga Isaka nkuhimba chihima chinji, nachinang'o uchocho nkuchipwatanila, Isaka nkuchichema chihima anecho Sitina, mana lake “umongo.” ");
INSERT INTO kde_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Bahi Isaka nkuhwena pachinu panji nkunahimba chihima chinji. Henga anecho nanga pavanapwatanidile. Isaka nkuchichema chihima anecho, “Lehobosi,” kwa kuva áhawile kuchidoni, “Yahwe ànitwing'a nafasi, na hwetu tuchitujaliwe nchilambo achino.” ");
INSERT INTO kde_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Isaka nkuuka anepo nkuhwena ku Beli-Sheba. ");
INSERT INTO kde_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Chilo uchila Yahwe nkunhumila nkunnyaulila kuchidoni, “Nangu nni Nnungu wa atatako Iblahimu. Unayope, kwa kuva ngùvele pamo na wako. Nìmbekubaliki na kuvatenda kuva vohe namene vanu va nnukolo lwako kwajili ya Iblahimu, ntumishi wangu.” ");
INSERT INTO kde_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Bahi aneko, Isaka nkun'dengela Yahwe chitala cha kunhumija sadaka, nkunnyuwa kwa lina lyake. Nkudenga n'gongwe wake, na vatumishi vake nkuhimba chihima. ");
INSERT INTO kde_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Mmahiku anelo, Abimeleki nkuuka ku Gelali nkummwenela Isaka akuno alongènè na Ahuzati nshauli wake na Fikoli, nkulu wa matiyala lake. ");
INSERT INTO kde_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaka nkuvauja kuchidoni, “Mwadachi mùidile kwang'une wakati mwenu mùnanguvenga na múninguvinganga kwenu?” ");
INSERT INTO kde_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Nkunnyang'ula kuchidoni, “Muhiu hwetu tùwene kuva Yahwe àvele pamo na wako. Bahi hwetu nkwona kuva inafala twapilanile, ");
INSERT INTO kde_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","kuva, ukambetutendela mabaya malinga hwetu chitukakutendeledile mabaya. Hwetu túkutendeledile lambone na kukuleka uhwene kwa amani bila kukutendela ubaya wohewo. Na wako vino nni munu ubalikiwîje na Yahwe.” ");
INSERT INTO kde_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Bahi Isaka nkuvatendela ing'ole, vanang'o nkulya na kukumbila. ");
INSERT INTO kde_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Liduva lipapête vammalele nkutakatukanga ulyamba namambumbu nkwapilanila. Bahi Isaka nkuvapelekela, nkulekana kwa amani. ");
INSERT INTO kde_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Liduva ulila vatumishi vanga Isaka nkummwenela Isaka nkunnyaulila habali dya achila chihima chivanahimbile, kuchidoni, “Tùnidowola medi!” ");
INSERT INTO kde_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Isaka nkuchichema chihima anecho “Sheba,” Bahi imanga ivêle anepo mpaka nelo ìchemwa Beli-Sheba. ");
INSERT INTO kde_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau panavele na vyaka alubaini, nkuvalomba amahe vavili va litawa lya Vahiti, Yudisi mwali wanga Beeli na Basemasi mwali wanga Eloni. ");
INSERT INTO kde_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Amahe anevo nkulatendiha maisha langa Isaka na Labeka kuva na uchungu. ");
INSERT INTO kde_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaka panakongopele namene na meho lake kuputala, anahulule kuchona chinu chohecho, nkunchema Esau mwanawe nkulungwa, nkunnyaulila kuchidoni, “Mwanangu!” Nang'e nkuyambukila, “Nangu apano atata!” ");
INSERT INTO kde_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaka nkuhaula kuchidoni, “Lola, nangu vino ǹnikongopala namene na liduva lya kuhwa kwangu wala nikálikameke. ");
INSERT INTO kde_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Bahi twala myumba na upinde wako, uhwene kwilanga ukalumbate anyama kwajili yangu, ");
INSERT INTO kde_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","koka ungutelekele chakulya chinowa, achila chinichitamwa namene, ungupelekejeje ngulye, uchinga ngupate kukubaliki kabla nikànambikuhwa.” ");
INSERT INTO kde_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Uhiku aula Isaka pachilonjela na Esau, kumbe Labeka ávenkupilikanila. Bahi Esau papite kwilanga unalumbata, ");
INSERT INTO kde_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Labeka nkunnyaulila Yakobo mwanawe kuchidoni, “Ǹnimpilikana atatako wannyaulila nkululo Esau kuva, ");
INSERT INTO kde_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","ampelekejije nnyama wannumbete na kunkatapajija chakulya chinôwa alye, uchinga apate kum'baliki muyo mwanga Yahwe, kabla akànambikuhwa. ");
INSERT INTO kde_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Hambi mwanangu, pilikanila malove langu, na utende chinikulaija. ");
INSERT INTO kde_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Hwena mpaka kulikuwa lya ambudi ukangutwalile ambudi vavili vavana vanunile namene, uchinga ngunkatapajije atatako chakulya chinôwa, cháchitàmwà namene. ");
INSERT INTO kde_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Nikàteleka, koka ukamwing'e atatako alye, uchinga apate kukubaliki kabla akànambikuhwa.” ");
INSERT INTO kde_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Henga Yakobo nkunnyaulila Labeka anyokwe kuchidoni, “ Nkulwangu Esau àvele na maleha mummili wammalele, henga nangu mmili wangu ukee na maleha. ");
INSERT INTO kde_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Panjika atata achiangupame-pame, dachi nikambekwonekana kuva nkúlambila, nkulitaya chihi dinumbu badala ya balaka?” ");
INSERT INTO kde_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Anyokwe nkuchidoni, “Mwanangu, dinumbu dyako dingupate nangu, wako tenda chinikuhaulidile, hwena ukangutwalile anevo ambudi uide navo.” ");
INSERT INTO kde_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Bahi Yakobo nkuhwena unavatwala ambudi vavili, nkumpelekejija anyokwe, na anyokwe nkukatapaja chakulya chinôwa, cháchitàmwà namene atatake. ");
INSERT INTO kde_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Anepo Labeka nkutwala dinguwo dyambone dyanga Esau, mwanawe nkulungwa, dyanavenadyo kukaya kwake, nkummwaja Yakobo, mwanawe n'joko. ");
INSERT INTO kde_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Nkutwala mambende la ambudi nkunhwinika mmakono na muukoti wake. ");
INSERT INTO kde_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Bahi nkumwing'a Yakobo achila chakulya chinôwa na nkate wanakatapajije. ");
INSERT INTO kde_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Bahi Yakobo nkumpelekejija atatake, nkunchema kuchidoni, “Atata.” Na nang'e nkwitika, “Nangu apano! Wako nnani mwanangu, Esau au Yakobo?” ");
INSERT INTO kde_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakobo nkunnyang'ula atatake kuchidoni, “Nangu Esau, nimwanalo ntandi. Ngùtendile muchi chungulaijije. Chonde atata, takatuka ulye inyama inikulumbatidile, koka ungubaliki.” ");
INSERT INTO kde_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Henga Isaka nkummuja kuchidoni, “Mwanangu, ìhululike dachi nelo kupata inyama upehi namuna ai?” Yakobo nkunnyang'ula kuchidoni, “Yahwe, Nnungu wako, àningujalila.” ");
INSERT INTO kde_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Anepo Isaka nkunnyaulila Yakobo kuchidoni, “Bahi mwanangu hengelekela apano uchinga nikupame-pame ngumale ikàva wako ni muhiu mwanangu Esau au nanga.” ");
INSERT INTO kde_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakobo nkunhengelekela Isaka atatake, nanang'e nkumpama-pama nkuchidoni, “Lidi lyanga Yakobo, henga makono langa Esau.” ");
INSERT INTO kde_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Bahi Isaka nanga panammaite ing'anya makono lake lávele na maleha lohe muchi makono langa Esau, nkuluwe. Henga kabla akànambim'baliki, ");
INSERT INTO kde_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Isaka nkummuja kavila Yakobo kuchidoni, “Ivi muhiu kuva wako mwanangu Esau?” Nang'e nkunnyang'ula kuchidoni, “Elo, unene.” ");
INSERT INTO kde_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Atatake nkuchidoni, “Idanayo aneyo inyama yumbwalalidile, niilye koka nikubaliki.” Bahi Yakobo nkumpelekejija, nang'e nkulya, nkumpelekejija na divayi, nkukumbila. ");
INSERT INTO kde_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Anepo atatake nkunnyaulila kuchidoni, “Hengelekela pepi mwanangu ungubusu.” ");
INSERT INTO kde_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Bahi Yakobo nkunnyengelekela atatake, nkum'busu, na atatake papilikene liumba lya dinguwo dyake, nkum'baliki wachidoni, “Enhee! Alino nni liumba likatapele lya mwanangu, livêle muchi liumba lya welu waubalikite Yahwe! ");
INSERT INTO kde_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Nnungu akung'unile lime lya kulihunde mmawelu lako, na akwing'e ulongo wa matapata, na vilyo vyohe na divayi dyohe. ");
INSERT INTO kde_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Matawa la vanu lakutumikile, na vanu va vilambo vakuhunamile. Ùùve ntawala wa alangavako, na vana va anyoko vakuhunamile. Kila munu ambekulâni wako, nanang'e alaniwe, na kila munu ambekubalîki wako, nanang'e abalikiwe!” ");
INSERT INTO kde_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isaka pamalidile kum'baliki Yakobo, na Yakobo paukile chihi kwa atatake, Esau nkuluwe Yakobo, nkuuya kuhaloka unalumbata. ");
INSERT INTO kde_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Esau na nang'e nkwandaa chakulya chinôwa, nkumpelekejija atatake, nkunnyaulila kuchidoni, “Atata, takatuka ulye inyama inikuwalalidile, koka ungubaliki!” ");
INSERT INTO kde_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isaka nkummuja kuchidoni, “Wako nnani?” Nang'e nkunnyang'ula kuchidoni, “Nangu Esau, mwanalo ntandi kuvelekwa.” ");
INSERT INTO kde_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Anepo Isaka nkutetemela namene, nkuchidoni, “Vino ayula aidîle unaning'a inyama ya munnyitu nnani? Nangu ǹnilya kabla wako ukànambikamola, na ǹnim'baliki tayali. Na nni muhiu kuva achiabalikiwe!” ");
INSERT INTO kde_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau papilikene malove la atatake, nkutumbula chitengelo kwa uchungu. Bahi nkunnyaulila atatake kuchidoni, “Chonde atata, nanani ngùbàlìkì!” ");
INSERT INTO kde_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Henga Isaka nkuchidoni, “Nnung'uno ániida kwa kulilambilila, nanang'e ànitwala balaka yako.” ");
INSERT INTO kde_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau nkuchidoni, “Njo mana àchemwa Yakobo! Nang'e àtwete nafasi yangu myanda mivili. Mwanda ntandi átwete haki yangu ya kuva nimwana ntandi kuvelekwa, na vino àtwete balaka yangu.” Bahi Esau nkummuja atatake kuchidoni, “Dachi, ukándekedile balaka yoheyo?” ");
INSERT INTO kde_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaka nkunnyang'ula kuchidoni, “Nangu tayali ǹnintenda Yakobo kuva ntawala wako, uchocho, nìvatendile alangavake vammalele kuva vatumishi vake. Ǹnim'baliki apate vilyo vyohe na divayi dyohe. Hambi nangu nikutendele chani mwanangu?” ");
INSERT INTO kde_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau nkunnyaulila atatake kuchidoni, “Atata, kwani wako ùvele chihi na balaka imo bahi? Nanani ngùbàlìkì atata!” Bahi Esau nkutumbula chitengelo. ");
INSERT INTO kde_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Isaka nkunnyaulila kuchidoni, “Wako ùmbeikala kulehu na ulongo wa matapata, kulehu na mawelu làkung'uniwa lime lya kulihunde. ");
INSERT INTO kde_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ùmbelamila chihi upanga wako wa ing'ondo, na ùmbentumikila nnung'uno, henga paumbekwamula kuuka mmakono lake, uchiulihungulange kuhaloka nnikongwa lyake lya utawala.” ");
INSERT INTO kde_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Bahi Esau nkunvisija Yakobo ing'anya ya balaka yapewije na atatake. Esau nkulitangolela chimunda-munda kuchidoni, “Kwa kuva atata àvele pepi na kuhwa, bahi akàhwa, na palambemalilika maduva la kunkutangila, anepo njo panimbemmwalala nnung'unwangu Yakobo.” ");
INSERT INTO kde_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Henga Labeka palamaite àlalá lalakudungidile mwanawe nkulungwa, nkunchema Yakobo mwanawe n'joko, nkunnyaulila kuchidoni, “Lyongolele, nkululo Esau àvenkulituja ntima kwa kukudungila kukuwalala wako. ");
INSERT INTO kde_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Hambi mwanangu, tenda chinimbekuhaulila. Apano uka, tukutila ku Halani kwanga Labani, nkulwangu. ");
INSERT INTO kde_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Uikale nawe kwa mahiku kadiki mpaka asila ya nkululo paimbehila. ");
INSERT INTO kde_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Asila yake paimbehila, na kulaluvalila àlalá luntendeledile, nguchinintume munu akakutahe aneko. Mwadachi nguhiliwe na mmanavangu mmammalele nniduva limo?” ");
INSERT INTO kde_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Labeka nkunnyaulila Isaka kuchidoni, “Nangu munda nkánowa ing'anya ya amahe avano va Chihiti vanga Esau. Ikàva Yakobo nanang'e àmbennomba mmahe wa Chihiti, nangu ngwòna kuva nanga faida ya kuhweneha kuva nimomi.” ");
INSERT INTO kde_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Bahi Isaka nkunchema Yakobo, nkum'baliki, nkunnaija wachidoni, “Unannombe mmahe woheyo wa Chikanaani. ");
INSERT INTO kde_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Wako hwena ku Padani-Alamu, kuing'ande ya anakululo Besueli, ukannombe mwali yumo muvali va anang'alavako Labani. ");
INSERT INTO kde_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Nnungu Avêle Na Dimongo Dyammalele akubaliki uchinga vanu va nnukolo lwako vààve vohe na kuyenjejeka mpaka kuhwikila kuva matawa lohe. ");
INSERT INTO kde_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Uchocho, Nnungu akubaliki wako chalumo na vanu va nnukolo lwako kwa kukuhululiha kuchimiliki chilambo chuwikala vino muchi mmidi, chilambo chanaahidite Nnungu kumwing'a atatangu Iblahimu chalumo na vanu va nnukolo lwake!” ");
INSERT INTO kde_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Bahi Isaka nkuntuma Yakobo kuhwena ku Padani-Alamu kwanga Labani, mwana wanga Besueli, Mwalamu. Labani ávele nkuluwe Labeka, anyokwe Yakobo na Esau. ");
INSERT INTO kde_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau nkumala kuva Isaka ànim'baliki Yakobo na kuntuma ahwene ku Padani-Alamu, uchinga akannombe mmahe aneko, na ánimala kuva Isaka pam'balikite Yakobo, áninnimbija anannombe mmahe wa Chikanaani. ");
INSERT INTO kde_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Na ánimala kuva Yakobo ànivapilikanila anyokwe na atatake, nkuhwena ku Padani-Alamu. ");
INSERT INTO kde_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Uchocho, ánimala kuva atatake nanga pakatapaliwa na amahe va Chikanaani. ");
INSERT INTO kde_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Bahi Esau nkuhwena kwanga Isumaili, mwana wanga Iblahimu, nkunannomba Mahalati mwali wanga Isumaili, nnumbuwe Nebayosi. ");
INSERT INTO kde_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Bahi Yakobo nkuuka ku Beli-Sheba, nkulodya ya ku Halani. ");
INSERT INTO kde_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Pahwikile pachinu fulani, nkulala anepo, kwa kuva liduva líniswa. Nkutwala liyanga lya pachinu anepo, nkuyamya muti wake, nkulala. ");
INSERT INTO kde_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Yakobo nkulota indoto, na muindoto aneyo, áiwene ingasi iimijìjwè nchilambo na chisweswe chake chihwikìlè kumahunde, na malaika va Nnungu uvakwela na kusulupuka muingasi aneyo. ");
INSERT INTO kde_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ámmwene na Yahwe aimidìlè kuchisweswe ingasi aneyo, nkunnyaulila Yakobo kuchidoni, “Nangu nni Yahwe, Nnungu wanga Iblahimu anakululo, na Nnungu wanga Isaka. Chilambo achino chulele, nìmbekwing'a wako na vanu va nnukolo lwako. ");
INSERT INTO kde_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Vanu va nnukolo lwako vàmbekuva vohe muchi litutunga lya pachilambo, na kuyanjala kila mpata, mpata wa mangalibi na mashaliki na kaskazini na kusini. Na kupitila wako na vanu va nnukolo lwako, vanu vammalele va pachilambo vàmbebalikiwa. ");
INSERT INTO kde_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Nangu ngùvele pamo na wako, nguchinikuchunge kila pachinu paumbehwena na nguchinikuuihe nchilambo achino. Nangu nikambekuleka mwiko, na nguchinikutendele anelo lanikuahidite. ");
INSERT INTO kde_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yakobo patakatwike nnuwono nkutangola chimunda-munda kuchidoni, “Muhiu Yahwe àvele apano, na nangu nikanamaite!” ");
INSERT INTO kde_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Yakobo nkuyopa namene, nkuchidoni, “Apano pachinu pànayoha namene! Muhiu pachinu apano nni paing'ande ya Nnungu na nnango wa kulihunde.” ");
INSERT INTO kde_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Bahi ulyamba na mambumbu, Yakobo nkutakatuka, nkutwala alila liyanga lyanayamije muti wake, nkuliimija uchinga lììve ukumbuso, nkulitenda kuva lyanga Nnungu kwa kulimiminila mahuta. ");
INSERT INTO kde_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Yakobo nkupachema pachinu anepo “Beseli,” mana lake, “ing'ande ya Nnungu.” Henga lina litandi lya pachinu anepo lívele Luzu. ");
INSERT INTO kde_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Bahi Yakobo nkuvika nasili wachidoni, “Ikàva wako Nnungu, ùmbekuva pamo na nangu na kunguchunga mmwanda wangu, unìng'à chakulya na dinguwo, ");
INSERT INTO kde_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","uchinga nguuye kukaya kwa atatangu salama, bahi wako Yahwe ùmbekuva Nnungu wangu. ");
INSERT INTO kde_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Na pachinu apano panguimijije liyanga alino lya ukumbuso pàmbekuva pachinu pakukuabudu wako Nnungu, na nangu nguchinikwing'e wako asilimiya kumi ya vitukutuku vyammalele vyumbening'a.” ");
INSERT INTO kde_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Bahi Yakobo nkuhweneha na mwanda wake, nkunahwika nchilambo cha vanu vaikâla mpata wa kumashaliki wa chilambo cha Kanaani. ");
INSERT INTO kde_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Pahwikile aneko, liduva limo nkuchona chihima aneko kulilanga, na matunji matatu la angandolo lapumulidìlè pepi na chihima anecho. Angandolo vákumbijwa medi la chihima anecho chinahinikwije liyanga likulungwa. ");
INSERT INTO kde_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Kwa kawaida, makuwa lammalele la angandolo lakàkojana anepo, vachunga vánakumilana kulihingiliha alila liyanga lya pachihima na kuvakumbija angandolo medi. Na vakàmalila kuvakumbija, nkuchihinika kavila kwa liyanga anelyo. ");
INSERT INTO kde_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakobo nkuvauja vachunga anevo kuchidoni, “Mmalangavangu, mwenu kwenu kwachi?” Nkunnyang'ula kuchidoni, “Hwetu kwetu ku Halani.” ");
INSERT INTO kde_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Nang'e nkuvauja kuchidoni, “Dachi, mùnimmala Labani n'dukuluwe Naholi?” Nkunnyang'ula kuchidoni, “Elo tùnimmala.” ");
INSERT INTO kde_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Nkuhweneha kuvauja kuchidoni, “Dachi, mumi?” Vanang'o nkunnyang'ula kuchidoni, “Nang'e mumi, na Laheli mwali wake ayula apala, àvenkwida na angandolo vake.” ");
INSERT INTO kde_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Bahi Yakobo nkuvahaulila kuchidoni, “Lola, vino nni muhi namene, na auno ukee uhiku wa kuvapelekeja anyama unalala. Vakumbijange anyama medi koka muhwene mukavachunge.” ");
INSERT INTO kde_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Henga vanang'o nkunnyaulila kuchidoni, “Tukáhulula kutenda uchocho mpaka makuwa lammalele laide, na liyanga lihingilihwe, koka tuvakumbije medi angandolo.” ");
INSERT INTO kde_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Bahi Yakobo pachitangola na anevo vachunga, nkukamola Laheli na angandolo va atatake, kwa kuva nang'e njo achivachunga. ");
INSERT INTO kde_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakobo pammwene Laheli, mwali wanga Labani anang'alavake na angandolo vake, nkuhwena unalihingiliha alila liyanga pachihima, nkuvakumbija angandolo va anang'alavake. ");
INSERT INTO kde_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Bahi Yakobo nkusalimila Laheli kwa kum'busu, na kukuta chitangelo kwa kuhangalala. ");
INSERT INTO kde_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yakobo nkunnyaulila Laheli kuva, atatake Laheli nang'e ànchema nnang'alavake, na kuva, nang'e ni mwana wanga Labeka amatiye Laheli. Laheli nkutukuta chimbamba kuhwena kukaya unannyaulila atatake. ");
INSERT INTO kde_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labani papilikene chihi habali dya Yakobo mwipwave, nkutukuta upehi uhwena unanchingamila. Pammwene, nkunkumbatila na kum'busu, nkunkalibisha kukaya kwake. Yakobo nkunnyaulila Labani mambo lammalele lahumidîle. ");
INSERT INTO kde_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Labani nkuchidoni, “Muhiu, wako ni nnangawangu, na myadi yangu!” Yakobo nkuikala kwanga Labani mwedi umo. ");
INSERT INTO kde_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Paumalilike mwedi anewo umo, Labani nkunnyaulila Yakobo kuchidoni, “Wako kuva unnangawangu ikee na mana kuva ùlembelewa ungutumikile bila kukwing'a chinu chohecho. Bahi nguhaulila, ùlembela nikulipe chamani.” ");
INSERT INTO kde_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Hambi Labani ávele na vana vavili vachimahe, ntandi vánchema Leya na n'joko vánchema Laheli. ");
INSERT INTO kde_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leya ávele na meho lakukakula, henga Laheli ávele na liumbo lyambone na kumeho kwake kúnikatapala namene. ");
INSERT INTO kde_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakobo nkuntamwa namene Laheli, bahi nkunnyaulila Labani kuchidoni, “Nangu nguchinikutumikile kwa vyaka saba uchinga uning'e Laheli, mwali wako n'joko.” ");
INSERT INTO kde_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labani nkunnyaulila kuchidoni, “Wasa nikwing'e wako Laheli kuliko umwing'a munu yunji. Bahi hweneha kuikala na nangu.” ");
INSERT INTO kde_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Bahi Yakobo nkuntumikila Labani vyaka saba kwajili yanga Laheli, henga Yakobo áwene chihi maduva anelo kuva kadiki, kwa kuva ánintamwa namene Laheli. ");
INSERT INTO kde_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Anepo Yakobo nkunnyaulila Labani kuchidoni, “Maduva langu lànitimila, bahi ning'e n'jangu, ngwende nawe ulombi.” ");
INSERT INTO kde_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Bahi Labani nkwandaa ing'ole na kuvakumbula vanu vammalele va pachinu anepo. ");
INSERT INTO kde_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Henga pachikamwele chinalyulo, Labani nkuntwala Leya mwanawe nkulungwa, nkumpelekeja kwanga Yakobo, na Yakobo nkulala nawe. ");
INSERT INTO kde_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Na Labani nkunhumya ntumwa wake wa pachimahe uvanchema Zilipa, ààve ntumwa wanga Leya. ");
INSERT INTO kde_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ulyamba wake, Yakobo nkumala kuva vàmwing'ile Leya! Bahi Yakobo nkummuja Labani kuchidoni, “Ùngutendeledile chinu ntwani? Dachi, tenda ńikutumikidile kwajili yanga Laheli? Ing'anya ntwani ùningulambila?” ");
INSERT INTO kde_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labani nkunnyang'ula kuchidoni, “Nchilambo chetu nanga patutenda uchocho. Akee nnyambo wetu kulongolela kulombwa mwali n'joko kabla ya nkulungwa. ");
INSERT INTO kde_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Bahi malila lijuma limo lya kuhangalalila ing'ole ya ulombi, koka tukwing'e Laheli utumikile vyaka vinji saba.” ");
INSERT INTO kde_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakobo nkukubali. Bahi Yakobo pamalidile anelyo lijuma limo, Labani nkunhumya Laheli, mwali wake n'joko ààve n'jawe Yakobo. ");
INSERT INTO kde_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labani nkunhumya ntumwa wake wa pachimahe uvanchema Biliha, uchinga ààve ntumwa wanga Laheli. ");
INSERT INTO kde_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Uchocho, Yakobo nkulala na Laheli. Yakobo nkuntamwa namene Laheli kupunda Leya. Nkuntumikila Labani vyaka vinji saba. ");
INSERT INTO kde_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Yahwe pawene kuva Yakobo nanga pantamwa namene Leya, bahi nkun'jalila Leya kupata vana, henga Laheli nkuva ntonga. ");
INSERT INTO kde_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leya nkupata chitumbo, nkummeleka mwana wachilume, nkunchema Lubeni, kwa kuva áhawile kuchidoni, “Yahwe ànikwona kubanika kwangu, muhiu kuva ntwangu vino achiangutamwe.” ");
INSERT INTO kde_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Leya nkupata chitumbo kavila, nkummeleka mwana wachilume, nkunchema lina Simeoni, kwa kuva áhawile kuchidoni, “Yahwe ànining'a mwana yunji wachilume, kwa kuva ànipilikana namuna chakangutamwa.” ");
INSERT INTO kde_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Leya nkupata chitumbo chinji, nkummeleka mwana wachilume, nkunchema lina Lawi, kwa kuva áhawile kuchidoni, “Vino ntwangu achialundane na nangu, kwa kuva nìmmelekedile vana vatatu vachilume.” ");
INSERT INTO kde_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Leya nkupata chitumbo kavila, nkummeleka mwana wachilume, nkunchema lina Yuda, kwa kuva áhawile kuchidoni, “Mwanda auno nìmbennombolela Yahwe.” Bahi Leya nkuimija kuvaleka kwa vyaka fulani. ");
INSERT INTO kde_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Laheli pawene kuva nanga pammelekedile Yakobo vavana, nkummikila wiu adadaye, nkunnyaulila Yakobo kuchidoni, “Nguvelekele vana. Ikànave uchocho, bahi nìmbekuhwa.” ");
INSERT INTO kde_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakobo nkunsunalila Laheli, nkunnyaulila kuchidoni, “Kwani nangu ngùjukile kuva Nnungu akutendîle unààve na vana?” ");
INSERT INTO kde_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Laheli nkunnyang'ula kuchidoni, “Biliha ntumwa wangu wachimahe ànipwawa. Bahi lala nawe uchinga unguvelekele vana, nanangu ngupate vana kupitila nang'e.” ");
INSERT INTO kde_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Bahi Laheli nkumwing'a Yakobo Biliha ntumwa wake, uchinga ààve n'jawe, na Yakobo nkulala nawe. ");
INSERT INTO kde_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Biliha nkupata chitumbo, nkummelekela Yakobo mwana wachilume. ");
INSERT INTO kde_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Laheli nkuchema lina Dani, kwa kuva áhawile kuchidoni, “Nnungu ànining'a haki yangu, ànipilikana kuyuwa kwangu na kuning'a mwana wachilume.” ");
INSERT INTO kde_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Biliha ntumwa wanga Laheli, nkupata kavila chitumbo, nkummelekela Yakobo mwana wavili wachilume. ");
INSERT INTO kde_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Laheli nkunchema lina Nafutali, kwa kuva áhawile kuchidoni, “Ngùpanyene ing'ondo ing'ulungwa na nkulwangu, nanangu ǹninnema.” ");
INSERT INTO kde_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Bahi Leya pawene kuva lutumbo lwake lùninyalalika kuveleka, nkuntwala Zilipa ntumwa wake, nkumwing'a Yakobo uchinga ààve n'jawe. ");
INSERT INTO kde_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilipa nkummelekela Yakobo mwana wachilume. ");
INSERT INTO kde_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leya nkunchema lina Gadi, kwa kuva áhawile kuchidoni, “Ǹnibahatika.” ");
INSERT INTO kde_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilipa, ntumwa wanga Leya, nkummelekela Yakobo mwana wavili wachilume. ");
INSERT INTO kde_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leya nkunchema lina Asheli, kwa kuva áhawile kuchidoni, “Ǹnihangalala! Vino vakongwe vàmbenguchema ihangaladi.” ");
INSERT INTO kde_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Bahi mahiku la lichela lya ngano, Lubeni nkuhwena kumawelu, na aneko nkuyona mimeya fulani innyululîha munu kupata chitumbo, nang'e nkuitwala nkunamwing'a Leya, anyokwe. Laheli nkunnyaulila Leya kuchidoni, “Chonde ngùyuwa ungumayele kadiki mimeya yakupele mwanalo!” ");
INSERT INTO kde_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Henga Leya nkunkalipila wachidoni, “Wako ùtenda chinu chijoko ungupakanyola ntwangu? Dachi, na vino ùlembela uitwale mimeya yaning'ile mwanangu?” Laheli nkunnyang'ula kuchidoni, “Ukàning'a mimeya yakwing'ile mwanalo, bahi nelo Yakobo achialale kwakuwe.” ");
INSERT INTO kde_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Bahi chinalyulo Yakobo pachiuya kumawelu, Leya nkuhwena unanchingamila, nkunnyaulila kuchidoni, “Nelo ùlembelewa ulale kwang'une, kwa kuva ǹnikusuma kwa mimeya yaning'ile mwanangu.” Bahi chilo anecho Yakobo nkulala kwanga Leya. ");
INSERT INTO kde_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Nnungu nkupilikana kuyuwa kwanga Leya, na Leya nkupata chitumbo, nkummelekela Yakobo mwana wa nnyano wachilume. ");
INSERT INTO kde_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leya nkunchema lina Isakali, kwa kuva áhawile kuchidoni, “Nnungu àning'ile inudyo, ing'anya nímwing'ile ntwangu ntumwa wangu wachimahe.” ");
INSERT INTO kde_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leya nkupata kavila chitumbo, nkummelekela Yakobo mwana wa sita wa chilume. ");
INSERT INTO kde_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Leya nkunchema lina Zabuloni, kwa kuva áhawile kuchidoni, “Nnungu àning'ile inudyo yambone. Vino ntwangu achiangutumbyange, kwa kuva nìmmelekedile vana sita vachilume.” ");
INSERT INTO kde_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Mmyaka ipapête, Leya nkummaleka mwana wachimahe, nkunchema lina Dina. ");
INSERT INTO kde_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Bahi Nnungu nanga panannuvalidile Laheli, nkupilikana kuyuwa kwanga Laheli, nkunnyungula litumbo lyake. ");
INSERT INTO kde_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Laheli nkupata chitumbo, nkummaleka mwana wachilume. Laheli nkuchidoni, “Nnungu àninguusija dihoni dyangu.” ");
INSERT INTO kde_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Bahi mwana aneyo nkunchema lina Yusufu, kwa kuva áhawile kuchidoni, “Yahwe anguyenjeje mwana yunji wachilume.” ");
INSERT INTO kde_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Bahi Laheli pammaleke Yusufu, Yakobo nkunnyaulila Labani kuchidoni, “Ndeke vino nguuye kukaya, kuchilambo changu. ");
INSERT INTO kde_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Uning'e ajavangu na anavangu, unguvapete kwa kukutumikila wako, uchinga nguhwene navo. Kwa kuva ùnimala namuna chinikutumikidile saana.” ");
INSERT INTO kde_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Henga Labani nkunnyaulila kuchidoni, “Ikàva ùnikatapaliwa na nangu, ngùyuwa uikale upano. Nangu ǹnipata kumala kwa indila ya kulauja kuva, ing'anya yakuwe, Yahwe àningubaliki namene. ");
INSERT INTO kde_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Bahi tambulanga nshahala ulambêla nikulipe, nanangu nguchinikulipe.” ");
INSERT INTO kde_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakobo nkunnyaulila kuchidoni, “Wako umwene ùnimala namuna chinikutumikidile saana, na namuna anyama vako chivahalijije kuva vohe. ");
INSERT INTO kde_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Kabla nikànambikwida, wako wavele chihi na dimali kadiki, henga kutandikila panguidile nangu, dimali dyako dìniyenjejeka namene, na Yahwe ànikubaliki kwa lammalele langulatendile. Henga vino ngùlembela nguvakambikambile vanu va nng'ande mwangu nimwene.” ");
INSERT INTO kde_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labani nkummuja Yakobo kuchidoni, “Vino ùlambela nikulipe chinu ntwani?” Yakobo nkunnyang'ula kuchidoni, “Wala unaning'e chinu chohecho. Nangu nguchinguhwenehe kuvachunga anyama vako, ");
INSERT INTO kde_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","ikàva nelo uchiunguluhusu ngupite mmatunji la anyama vako vammalele, na kila litunji nivatwale angandolo na ambudi vavêle na madolidoli au malemba, na kila ungandolo wanapi. Anevo njo vambekûva nshahala wangu. ");
INSERT INTO kde_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Paumbeida unalola nshahala wangu mmaduva laîda, anepo njo paimbekwonekana ikulupiki yangu. Umbudi woheyo akávele na madolidoli au malemba, au ungandolo woheyo akávele wa langi-langi au wanapi akàonekana nnitunji lyangu, aneyo àmbekuva ǹnimwiva.” ");
INSERT INTO kde_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labani nkuchidoni, “Sawa! Bahi ììve muchi chuhawile.” ");
INSERT INTO kde_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Henga nniduva ulyolyo, Labani nkuhwena unalatwala magogoma lammalele la ambudi vavêle na misitali na madolidoli, na makolo lammalele la ambudi vavêle na madolidoli au malemba lanahe, na kila ungandolo wa langi-langi, nkuvakamuja vana vake uchinga vavalolihije. ");
INSERT INTO kde_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Labani na vana vake nkuhapukana na Yakobo, nkuvapelekeja anyama anevo ulehu wa mwanda wa maduva matatu, henga Yakobo nkwisalila wavachunga anyama vanji vanga Labani vaisalidîle. ");
INSERT INTO kde_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Bahi Yakobo nkutwala dinavi dimbihi dya milandi fulani, nkudiwaula vipande-vipande uchinga yonekane misitali yanahe n'dinavi anedyo. ");
INSERT INTO kde_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Yakobo nkuva wadiimija dinavi anedyo dyadiwawile, muvyombo vivavakumbijija anyama medi. Na kwa kuva anyama anevo pavachiida unakumbila medi vánakwelana, ");
INSERT INTO kde_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","bahi nkupata vitumbo muyo dinavi anedyo, bahi nkuvaveleka anyama vavêle na misitali na malemba na madolidoli. ");
INSERT INTO kde_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Bahi Yakobo nkuvahapula anevo angandolo vajoko vavelekwejîje, kuva vake. Na angandolo vanji vanga Labani pavachikwelana, Yakobo nkuvalodya meho kuvavele anyama vanji vanga Labani. Bahi kwa kutenda uchocho, Yakobo nkupata kuvayenjeja anyama nnitunji lyake mwene, na wala nanga panalikundanije na alila lyanga Labani. ");
INSERT INTO kde_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Na kila palachikamola mahiku la anyama vanyetîle kuhamula, Yakobo nkuva waimija adila dinavi muvyombo anevyo vya kuvakumbijija anyama uchinga vapate vitumbo muyo mwa dinavi anedyo. ");
INSERT INTO kde_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Henga Yakobo nanga panadivikile dinavi anedyo muyo mwa vanyama vayandîle pavachipata vitumbo. Bahi anyama vanyetîle nkuva vanga Yakobo na vayandîle nkuva vanga Labani. ");
INSERT INTO kde_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Bahi Yakobo nkutajilika namene, nkuva na matunji makulungwa la anyama na vatumwa vachimahe na vachilume na angamila na punda. ");
INSERT INTO kde_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Bahi Yakobo nkupilikana kuva vana vachilume vanga Labani vánatangola kuva, “Yakobo ànitwala kila chinu cha atatawetu, na ànipata utajili kupitila dimali dya atatawetu.” ");
INSERT INTO kde_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Uchocho, Yakobo ánimala kuva Labani vino akán'jali muchi chachin'jali patandi. ");
INSERT INTO kde_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Bahi Yahwe nkunnyaulila Yakobo kuchidoni, “Uya nchilambo cha vasele vako na alangavako, nanangu nguchinguve pamo na wako.” ");
INSERT INTO kde_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Bahi Yakobo nkuvatuma vanu vakancheme Laheli na Leya uchinga vaide kumawelu kwachivachunga angandolo na ambudi vake. ");
INSERT INTO kde_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Pavakamwele, Yakobo nkuvahaulila kuchidoni, “Nangu ngwòna kuva atatawenu vino nanga pangujali muchi patandi. Henga Nnungu wa atatangu àvele pamo na nangu. ");
INSERT INTO kde_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Mwenu mmene mùnimala kuva nìntumikidile atatawenu kwa dimongo dyangu dyammalele. ");
INSERT INTO kde_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Pamo na anelo, atatawenu àningulambila kwa kupindikulanya nshahala wangu myanda yohe, henga Nnungu nanga pannampele wasa wa kungutenda mabaya. ");
INSERT INTO kde_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Atatawenu kila pahawile kuva, ‘Anyama vavêle na malemba njo vambekûva nshahala wako,’ bahi litunji lyammalele nkuveleka anyama vavêle na malemba. Na kila pahawile kuva, ‘Anyama vavêle na misitali njo vambekûva nshahala wako,’ bahi litunji lyammalele nkuveleka anyama vavêle na misitali. ");
INSERT INTO kde_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Bahi uvila njo Nnungu chavatwete anyama va atatawenu, nkuning'a nangu.” ");
INSERT INTO kde_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Mmahiku la anyama kuhamula, nangu ńnilota, na muindoto aneyo ngúlawene magogoma lanavakwedile makolo. Na magogoma anelo lammalele lávele na misitali na madolidoli na malemba. ");
INSERT INTO kde_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Malaika wanga Nnungu nkulonjela na nangu muindoto aneyo, nkunguchema wachidoni, ‘Yakobo,’ nangu nkwitika, ‘Nangu apano!’ ");
INSERT INTO kde_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Nang'e nkunguhaulila kuchidoni, ‘Lola magogoma lammalele lavakwêla makolo làvele na misitali na madolidoli na malemba. Ìvele uchocho ing'anya ǹnilona àlalá lakutendeledîle Labani. ");
INSERT INTO kde_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Nangu njo Nnungu nnakuhumidile ku Beseli, pachinu apala paunalimiminidile mahuta liyanga alila lya ukumbuso lyunaimijije, na kunguvikila nasili. Vino uka nchilambo achino uuye nchilambo chuvelekwejije.’” ");
INSERT INTO kde_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Laheli na Leya nkunnyang'ula Yakobo kuchidoni, “Hwetu nanga patuvele na chinu wala mapala lohelo kwa atatawetu! ");
INSERT INTO kde_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Na hwetu vino àtwona chihi muchi tuvamidi, kwa kuva ànitusumisa, na dimali dyapete kwa kutusumisa hwetu àniditumila tayali. ");
INSERT INTO kde_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Dimali dyammalele dyaditwete Nnungu kuhaloka kwa atatawetu, anedyo njo dimali dyetu chalumo na vavana vetu. Bahi wako tenda chihi chinu chohecho chakulaijije Nnungu!” ");
INSERT INTO kde_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Bahi Yakobo nkupanganika kuuka, nkuvakweja vana vake na ajavake muangamila. ");
INSERT INTO kde_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Nkuvatwala anyama vake vammalele na dimali dyake dyammalele dyadipete aneko ku Padani-Alamu, nkutandilika mwanda wa kuuya nchilambo cha ku Kanaani, kwa Isaka atatake. ");
INSERT INTO kde_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Uhiku anewo Labani ápite unavahenga maleha angandolo vake, bahi Laheli nkupata wasa wa kwiva disanamu dya milungu ya atatake. ");
INSERT INTO kde_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Pamo na anelo, Yakobo nanang'e nkunnambila Labani, Mwalamu kwa kuuka bila kunnaila. ");
INSERT INTO kde_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Bahi Yakobo nkutwala dimali dyake dyammalele, nkutaloka. Nkuyamboka muto wa Efulati, nkulodya ya ku Gileadi, chilambo cha machinga-machinga. ");
INSERT INTO kde_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Liduva lya tatu, vanu vanji nkunnyaulila Labani kuva Yakobo ànitaloka. ");
INSERT INTO kde_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Bahi Labani nkuvatwala alangavake, nkunnondola Yakobo kwa maduva saba, nkunkoja ku Gileadi, chilambo cha machinga-machinga. ");
INSERT INTO kde_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Henga chilo, Nnungu nkunhumila Labani, Mwalamu muindoto, nkunnyaulila kuchidoni, “Lichunge! Unannyohe Yakobo kwa namuna yoheyo.” ");
INSERT INTO kde_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Labani ánkojije Yakobo adengìlè n'gongwe aneko ku Gileadi, nchilambo cha machinga-machinga. Labani pamo na alangavake, nanang'e nkudenga n'gongwe upopo. ");
INSERT INTO kde_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Labani nkummuja Yakobo kuchidoni, “Wako ùtendile chamani? Mwadachi ùningulambila, nkuvatwala vali vangu muchi matwala la kuing'ondo? ");
INSERT INTO kde_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Mwadachi ùningutaloka na kungulambila? Mwadachi ukanangulaidile uchinga ngupate kukulaila kwa ihangaladi akuno ungwimba dihimu na ungwomba likungwa na libangu? ");
INSERT INTO kde_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Mwadachi ukaning'ile wasa wa kuvabusu anavangu na adukuluvangu? Muhiu ùtendile uvelu! ");
INSERT INTO kde_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Nangu ngùvele na dimongo dya kukutendela chinu chibaya, henga chilo cha kwimukila nelo, Nnungu wa atatako áninguhumila, nkunguhaulila kuchidoni, ‘Lichunge! Unannyohe Yakobo kwa namuna yoheyo.’ ");
INSERT INTO kde_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Nangu ǹnimala kuva ùnitaloka ing'anya ya kuva na hamu ing'ulungwa ya kuuya kukaya kwa atatako. Henga ing'anya ntwani ùivite disanamu dya milungu yangu?” ");
INSERT INTO kde_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakobo nkunnyang'ula kuchidoni, “Nangu nnayopa, ing'anya ngútenda kuva uchiungupakanyole vali vako. ");
INSERT INTO kde_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Henga ukànkoja munu woheyo avêle na disanamu dya milungu yako muhwetu, bahi analame. Muyo mwa alangavetu avano, chilanguje chinu chako chohecho, na ikàva chìnipwawa, bahi chitwale.” Yakobo átangwele uchocho ing'anya nanga panamaite kuva Laheli njo adiivîte disanamu dya milungu yanga Labani. ");
INSERT INTO kde_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Bahi Labani nkwinjila mun'gongwe wanga Yakobo, na mun'gongwe wa Leya, na mmigongwe ya avala vatumwa vavili vanavajuhije Yakobo kuva ajavake, wataha disanamu dyake dya milungu, henga nanga panadipete. Kuntululilo nkunainjila mun'gongwe wa Laheli. ");
INSERT INTO kde_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Na Laheli átwete adila disanamu nkudivika nnitandiko livavavika angamila pamongo, nang'e nkuliikalila. Labani nkutaha mun'gongwe wammalele, henga nanga panadipete. ");
INSERT INTO kde_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Laheli nkunnyaulila atatake kuchidoni, “Chonde atatangu unasunale, kwa kuva nikáhulula kwimila muyo mwako kwa kuva ngùvele mmaduva langu.” Bahi Labani ánitaha namene disanamu dya milungu yake, henga nanga panadipete. ");
INSERT INTO kde_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Bahi Yakobo nkusunala, nkupwatana na Labani nkummuja wachidoni, “Nangu ngùtendile likosa ntwani? Nangu ngùtendile sambi ntwani mpaka ungupapatilile uvila? ");
INSERT INTO kde_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Dachi, ùwene chinu ntwani chako pupalahanyije vitukutuku vyangu? Ikàva chìnipwawa, bahi chivike muyo mwa alangavangu na alangavako, uchinga vanang'o vatwamulile cha kutenda hwetu tuvavili! ");
INSERT INTO kde_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Nangu ngùikele na wako kwa vyaka ishilini vino. Na uhiku anewo wammalele, angandolo vako na ambudi vako vakánambiwahi kwondonganga vitumbo, wala nikánambiwahi kutang'una ligogoma lya ungandolo wa nnikuwa lyako. ");
INSERT INTO kde_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Nangu wala nikánambiwahi kukupelekejija nnyama wako awalêlwe na anyama va kunnyitu, henga aneyo asala yavele chihi yangu nimwene. Wako úningudayi nnyama aivîjwe chilo au muhi. ");
INSERT INTO kde_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Na aino njo inavele hali yangu, muhi ńnipililila liduva likalipa namene na chilo imepo ínanguputa. Na wala nanga panichipata luwono kananga kadiki. ");
INSERT INTO kde_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Anelo njo maisha languikele kwa uhiku wa vyaka ishilini, panichiikala na wako. Vyaka kumi na nne ńnikutumikila uchinga nivapate vali vako vavili, na vyaka sita ńnikutumikila uchinga nivapate anyama vambekûva vangu. Henga wako nkupindikulanya nshahala wangu myanda yohe. ");
INSERT INTO kde_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Na kwikavele Nnungu wa anakulwangu Iblahimu, Nnungu wa kuyoha namene wa atatangu Isaka, akààva mpata wangu, muhiu ukaninguleka nguuke chihi makono weka. Henga Nnungu ànikwona kubanika kwangu na madengo langukodile kwa makono langu, nkukuduma chilo cha kuyumukila nelo.” ");
INSERT INTO kde_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labani nkunnyang'ula Yakobo kuchidoni, “Ava vali vang'une, na ava vana nni vadukuluvangu, na ava anyama vang'une, na vyammalele vyuvyona apano vyang'une. Henga nangu nìmbetenda chani nelo kwamba ava vali vangu na vana vao uvavaveleke? ");
INSERT INTO kde_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Bahi tutende lilailano nangu na wako uchinga lììve ushahidi kati yangu nangu na wako.” ");
INSERT INTO kde_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Bahi Yakobo nkutwala liyanga nkuliimija uchinga lììve ukumbuso. ");
INSERT INTO kde_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Nkuvahaulila alangavake kuchidoni, “Kunganya mayanga.” Na vanang'o nkukunganya, nkuvika chisulu. Bahi nkulyanga chakulya pepi na chisulu anecho cha mayanga. ");
INSERT INTO kde_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labani nkuchichema chisulu anecho cha mayanga kwa Chialamu, Yegali-Sahaduta, mana lake “chisulu cha ushahidi.” Henga Yakobo nkuchichema chisulu anecho kwa Chieblaniya Galedi, mana lake “chisulu cha ushahidi.” ");
INSERT INTO kde_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labani nkuchidoni, “Chisulu achino ni ushahidi kati yako na nangu nelo.” Njo mana chisulu anecho chíchemwa Galedi. ");
INSERT INTO kde_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Anecho chisulu nkuchichema Mizipa, kwa kuva áhawile kuchidoni, “Yahwe atulolihije nangu na wako kwa uhiku aula utumbelekana na kuva kulehu uchinga ààve shahidi wa lilailano lyetu. ");
INSERT INTO kde_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ukàvabaniha vali vangu au ukàvatwala amahe vanji tafauti na avano, na ata kama munu yunji anamale, ila umale kuva Nnungu njo shahidi kati yangu na wako. ");
INSERT INTO kde_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Lola chisulu achino cha mayanga na alino liyanga lya ukumbuso linguimijije kati yako na nangu. ");
INSERT INTO kde_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Chisulu achino na liyanga alino nni ushahidi kuva, nangu nikambepulung'anya chisulu achino kwida kwakuwe unakutendela mabaya, na wako ukambepulung'anya chisulu achino na liyanga alino kwida kwang'une unangutendela mabaya. ");
INSERT INTO kde_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Nangu nìiyuwa milungu ya anyakala vetu, yani milungu ya anakululo Iblahimu na anakulwangu Naholi, vatuamulile nangu na wako.” Bahi Yakobo nkwapila kwa kuntambulanga Nnungu ayôha, Nnungu wanga Isaka, atatake Yakobo. ");
INSERT INTO kde_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Bahi Yakobo nkuhumya sadaka aneko kuchilambo cha machinga-machinga, na nkuvakumbula alangavake valye chakulya. Pavamalidile kulya, nkwisalila ukoko chilo chammalele. ");
INSERT INTO kde_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ulyamba na mambumbu, Labani nkuvabusu adukulu vake na vali vake, nkuvabaliki. Anepo Labani nkuuka, nkuuya kukaya kwake. ");
INSERT INTO kde_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakobo nkuuka nkuhwena mwanda wake, na malaika va Nnungu nkukojana nawe. ");
INSERT INTO kde_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yakobo pavonite, nkuhaula kuchidoni, “Alino nni likambi lya jeshi lya Nnungu!” Apala pachinu nkupachema Mahanaimu. ");
INSERT INTO kde_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Bahi Yakobo nkuvatuma vajumbe vannongolele kuhwena kwanga Esau nkuluwe aneko ku Seili nchilambo cha Edomu. ");
INSERT INTO kde_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Nkuvalaija wachidoni, “Nnyaulile nkulwangu Esau kuchidoni, ‘Ntumishi wako Yakobo atedoni, ‘Nangu ngúikala kumidi kwanga Labani mpaka vino. ");
INSERT INTO kde_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Na vino ngùvele na ding'ombe na punda na angandolo na ambudi na vatumwa vachilume na vachimahe. Na vino ngùtuma ujumbe auno kwa nkulwangu, uchinga ngupate kuyambukilwa muyo mwako.’ ” ");
INSERT INTO kde_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Anevo vajumbe nkuhwena, pavauite kwanga Yakobo nkunnyaulila kuchidoni, “Tùnihwika kwa nkululo Esau, na nang'e vino àvenkwida unakuchingamila, na àlongene na valume myanne.” ");
INSERT INTO kde_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Bahi Yakobo nkuyopa namene na kulipwalela. Nkuvayavanya vanu vanalongene navo matunji mavili, uchocho nkuvayavanya angandolo na ambudi, na ang'ombe na angamila. ");
INSERT INTO kde_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Yakobo nkulitangolela chimunda-munda wachidoni, “Esau akàida nkulyondonganga litunji limo, bahi litunji limbeisalîla, lichililame.” ");
INSERT INTO kde_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Bahi Yakobo nkunnyuwa Nnungu wachidoni, “Wako Nnungu wa anakulwangu Iblahimu na wa atatangu Isaka! Wako Yahwe unguhaulidîle nguuye nchilambo changu kwa alangavangu, na kunguahidi kungutendela lambone, ");
INSERT INTO kde_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","nangu wala nikáfala kananga kadiki kupwechela uwambone ungutendedile na ikulupiki yundangujije nangu ntumishi wako. Panguyombweke muto wa Yoludani, nangu ngúvele chihi nanga chinu ila isimbo weka, henga vino ngùvele na matunji mavili la vanu vohe na anyama. ");
INSERT INTO kde_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Vino ngùyuwa ungupohe kuhaloka mmakono la nkulwangu Esau, kwa kuva, ngùyopa kuva achiaide unanguwalala nangu na ajavangu pamo na anavangu. ");
INSERT INTO kde_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Wako úninguahidi kuva uchiungutendele lambone, na kuvatenda vanu va nnukolo lwangu kuva vohe namene muchi nnyangi wa kubahali, ukáhululika kuvalangika!” ");
INSERT INTO kde_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Bahi chilo anecho Yakobo nkulala pachinu anepo. Bahi nkutwala dimali dyake fulani uchinga dììve dinudyo kwa Esau nkuluwe. ");
INSERT INTO kde_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Yakobo álatwete magogoma la dimbudi ishilini na makolo myambili, na angandolo ishilini anamilume na makolo myambili, ");
INSERT INTO kde_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","angamila salasini vayong'êja chalumo na anavao, na makolo la ding'ombe alubaini na maluchi la ding'ombe kumi, na makolo ishilini la punda na anamilume kumi. ");
INSERT INTO kde_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Nkuvakamuja vatumishi vake, kila munu na litunji lyake, nkuvahaulila kuchidoni, “Ngulongolele, na mulekane kadiki kati ya litunji limo na linji.” ");
INSERT INTO kde_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Nkunnaija ayula alongoledile kuchidoni, “Nkulwangu Esau pambekojana na wako na kukuuja kuva, ‘Wako ntumishi wanga nnani? Uhwena kwachi? Na vanyama ava vammalele vanga nnani?’ ");
INSERT INTO kde_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Wako nnyang'ule kuchidoni, ‘Adino nni dimali dya ntumishi wako Yakobo. Na dyammalele adino ni dinudyo kwajili yako wako nkulu. Na Yakobo mwene àvenkwida nnyuma mwetu.’ ” ");
INSERT INTO kde_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Na ntumishi wa litunji lya vili na lya tatu na vanji vammalele nkuvalaija uchocho, wavahaulila kuchidoni, “Pamumbekojana na Esau nnyaulile malove ulolo. ");
INSERT INTO kde_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Pamo na anelo, munaluvalile kunnyaulila kuva, ‘Ntumishi wako Yakobo àvenkwida nnyuma mwetu.’ ” Yakobo átendile uchocho kwa kuva álitangoledile chimunda-munda kuva, “Nímbentungamaniha kwa dinudyo adino dingúlongolèjà, na panimbekojana nawe, panjika achiangupwachele.” ");
INSERT INTO kde_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Bahi nkulongoledya dinudyo dyake, henga mwene nkulala upopo palipanda chilo achila. ");
INSERT INTO kde_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Chilo uchocho Yakobo nkutakatuka, nkuntwala Leya na Laheli na avala ajavake vanji vavili vatumwa, na vana vake kumi na moja, nkuyamboka muto wa Yaboki. ");
INSERT INTO kde_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Pávayombohìjè avala vanalongene navo na dimali dyake dyammalele, ");
INSERT INTO kde_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Yakobo nkwisalila chihi weka. Bahi nkwida munu yumo, nkuyalahana na Yakobo mpaka kulyamba. ");
INSERT INTO kde_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ayula munu pawene kuva nanga pahulula kunnema Yakobo, bahi pavachiyalahana ayula munu nkukwaha inyonga yanga Yakobo, na aneyo inyonga nkuteneng'uka. ");
INSERT INTO kde_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Anepo ayula munu nkunnyaulila Yakobo kuchidoni, “Ndeka nguuke, kwa kuva uhiku ùvenkucha.” Henga Yakobo nkunnyang'ula kuchidoni, “Nikambekuleka mwiko, mpaka ungubaliki.” ");
INSERT INTO kde_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ayula munu nkummuja Yakobo kuchidoni, “Wako lina lyako nnani?” Yakobo nkunnyang'ula kuchidoni, “Yakobo.” ");
INSERT INTO kde_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ayula munu nkunnyaulila Yakobo kuchidoni, “Wako ukambechemwa kavila Yakobo, ila ùmbechemwa Isilaeli, kwa kuva ùnishindana na Nnungu na vanu, na wako ùnivalema.” ");
INSERT INTO kde_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Bahi Yakobo nkuchidoni, “Chonde ngùyuwa unguhaulile lina lyako.” Henga nang'e nkummuja kuchidoni, “Ing'anya ntwani ùnguuja lina lyangu?” Bahi nkum'baliki Yakobo. ");
INSERT INTO kde_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakobo nkupachema pachinu anepo “Penueli,” kwa kuva áhawile kuchidoni, “Nangu nìmmwene Nnungu meho kwa meho, henga umi wangu nanga pautwaliwije.” ");
INSERT INTO kde_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yakobo nkuuka ku Penueli liduva lihumìlè akuno wahumbaila ing'anya ya kupwateka inyonga. ");
INSERT INTO kde_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Njo mana mpaka nelo Vaisilaeli nanga pavalya nnanga wa muinyonga, kwa kuva, ayula munu ánkwahije Yakobo pamalundilo la chiya, munnanga wa inyonga yake. ");
INSERT INTO kde_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Bahi Yakobo nkulola meho lake muyo, nkumwona Esau waida na vanu vake, valume myanne. Anepo Yakobo nkuvayavanya vana vake, kila mwana nkumpelekeja kwa anyokwe, vana va Leya nkumwing'a Leya, na va Laheli nkumwing'a Laheli, na vana va avala ajavake vavili vatumwa navanang'o nkuvapelekeja kwa ayuvao. ");
INSERT INTO kde_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Yakobo nkuvalongoleja muyo avala ajavake vatumwa na vanavao, nkupapatila Leya na vana vake, na kuntululilo nkwida Laheli na Yusufu, mwanawe. ");
INSERT INTO kde_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yakobo mwene nkuvalongolela muyo, na pachinnyengelekela Esau nkuluwe, nkuva wannyunamila kwa eshima mpaka pahi myanda saba, mpaka pammwikidile. ");
INSERT INTO kde_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Henga Esau nkutukuta uhwena unanchingamila Yakobo nnung'une. Pahwikile nkunkumbatila na kum'busu. Vammalele vavili nkukuta. ");
INSERT INTO kde_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esau palolite meho lake muyo nkuvona avala vamahe na vavana, nkuuja kuchidoni, “Ava vanu vupapatene navo vanga nnani?” Yakobo nkunnyang'ula kuchidoni, “Ava nni vavana vángujalidìlè Nnungu kwa inema yake, nangu nintumishi wako.” ");
INSERT INTO kde_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Bahi avala ajavake Yakobo vatumwa na vana vao nkuhengelekela, nkuhunama muyo mwanga Esau kwa eshima mpaka pahi. ");
INSERT INTO kde_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Leya nanang'e nkwida chalumo na anavake, navanang'o nkuhunama muyo mwanga Esau kwa eshima mpaka pahi. Kuntululilo, nkwida Laheli chalumo na Yusufu, navanang'o nkuhunama muyo mwanga Esau kwa eshima mpaka pahi. ");
INSERT INTO kde_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Bahi Esau nkuuja kuchidoni, “Matunji la anyama lanilawene nndila lachani?” Yakobo nkunnyang'ula kuchidoni, “Nangu ngùlembela njambukilwe na wako, nang'olo wangu.” ");
INSERT INTO kde_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Henga Esau nkuchidoni, “Nangu ngùvele na dimali dyohe nnung'unwangu, dimali dyako dììve chihi dyako umwene.” ");
INSERT INTO kde_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakobo nkunnyaulila kuchidoni, “Nanga! Ikàva muhiu ùninguyambukila, bahi nakuyuwa upwechelele dinudyo dyangu. Kwa kuva, kukwona kumeho kwako ìvele muchi nìkuwene kumeho kwanga Nnungu, ing'anya ùngupwechedile saana. ");
INSERT INTO kde_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Chonde nakuyuwa udipwechele dinujo dinikupelekejije, kwa kuva nanani Nnungu àningwing'a dinema, ngùvele na dimali dyohe.” Bahi uvila njo Yakobo chanankolokohije Esau, na Esau nkupwechelela dinudyo dyake. ");
INSERT INTO kde_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Bahi Esau nkuhaula kuchidoni, “Panganika mwanda tuhweneng'ane. Na nangu nguchingulongolele muyo.” ");
INSERT INTO kde_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Henga Yakobo nkunnyaulila kuchidoni, “Nang'olo wangu, wako ùnimala kuva ava vavana ni vajoko. Uchocho, ùnimala kuva ava anyama vànayong'eja, nanangu ngùlembelewa nivaongolele. Avano anyama vakàtukutihwa kwa liduva limo, vammalele vachivahwe. ");
INSERT INTO kde_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Bahi nang'olo wangu, nangu nìkuyuwa ungulongolele nangu nintumishi wako, akuno ungwida kadiki-kadiki kupapatana na mwanda wa anyama na vavana vangu, mpaka panimbekukoja aneko ku Seili.” ");
INSERT INTO kde_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau nkunnyaulila Yakobo kuchidoni, “Nangu ngwòna kuva wasa nikulekele vanu vangu kadiki uchinga vakuchunge na kukulodya.” Henga Yakobo nkuchidoni, “Mwadachi utende uchocho? Nang'olo wangu, nangu kuyambukilwa na wako inatosha.” ");
INSERT INTO kde_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Bahi liduva ulila Esau nkutandilika mwanda wa kuuya ku Seili. ");
INSERT INTO kde_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Henga Yakobo nkuhwena ya ku Sukosi, na aneko nkulidengela ing'ande na vitundu kwajili ya anyama vake. Njo mana pachinu anepo pàchemwa Sukosi. ");
INSERT INTO kde_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Na bada ya kupita mahiku fulani, Yakobo nkuhwena ku Shekemu, nchilambo cha ku Kanaani. Bahi anepo njo panamalilidile mwanda wake wa kuhaloka ku Padani-Alamu, na kuhwika salama nchilambo cha ku Kanaani, nkuvika lipanda pepi na imanga aneyo ya Shekemu. ");
INSERT INTO kde_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Na pachinu anepo panaikele, Yakobo ánipasuma kuhaloka kwa vanu va nnukolo lwa Hamoli, atatake Shekemu, kwa vipande myamoja vya madini la dihela. ");
INSERT INTO kde_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Bahi Yakobo nkudenga chitala pachinu anepo nkupachema, “Eli-Elohe-Isilaeli,” mana lake “Nnungu ni Nnungu wa Isilaeli.” ");
INSERT INTO kde_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Liduva limo, Dina, mwali wanga Yakobo wammelekedile Leya, nkuhwena unavaongela vamahe va chilambo anecho cha Vahivi. ");
INSERT INTO kde_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Na Hamoli njo anavele nkulungwa wa chilambo anecho. Bahi Shekemu mwana wanga Hamoli pammwene Dina, nkunkamula nkuntula na kunnala. ");
INSERT INTO kde_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Henga Shekemu nkunowelwa namene na ayula mwali, nkuntamwa namene na kutandilika kulonjela nawe saana uchinga antamwe. ");
INSERT INTO kde_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Bahi Shekemu nkunnyaulila Hamoli atatake kuchidoni, “Chonde atata, ngùyuwa uning'e ayu mwali ààve n'jangu.” ");
INSERT INTO kde_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakobo nkupilikana kuva Dina mwali wake àtaijwe dihoni na Shekemu, henga kwa kuva vana vake vávele kumachungani, nang'e nkunyalalila chihi mpaka pavauite kukaya. ");
INSERT INTO kde_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Bahi Hamoli, atatake Shekemu, nkuhwena kwanga Yakobo unalonjela nawe. ");
INSERT INTO kde_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Na vana vachilume vanga Yakobo pavapilikene chihi habali anedyo, nkuuyang'ana kuhaloka kumachungani. Vijana anevo dínivapwateka namene disungu, na kutunuuka namene, kwa kuva kwa kulala na mwali wanga Yakobo, Shekemu átendile chitendo chivachona Vaisilaeli kuva chitendo cha dihoni namene, chitendo chikáchilembelewa kutendwa. ");
INSERT INTO kde_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Henga Hamoli nkuvahaulila kuchidoni, “Mwanangu Shekemu ànantamwa namene mwali wenu. Chonde ngùyuwa munnuhusu aende nawe ulombi. ");
INSERT INTO kde_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Leka tulombane, mwenu mutulombese vali venu na hwetu tunnombesange vali vetu. ");
INSERT INTO kde_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Na mwenu muchimuikale pamo na hwetu, na kuva hulu nchilambo achino. Ikalanga nchilambo achino na kuchuusa na kupata dimali.” ");
INSERT INTO kde_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Uchocho, Shekemu nkunnyaulila atatake Dina na alangavake Dina kuchidoni, “Chonde, ngùyuwa ngukubaliwe pameho penu, nanangu nguchinimwing'ange chinu chohecho chimumbehaula. ");
INSERT INTO kde_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Mwenu nguhaulile chihi nkaka umulembela na dinudyo, ata kudiva dyohe namuna ntwani, nangu nguchinguhumye kupapatana na namuna chimumbenguhaulila. Mwenu ning'e chihi ayu mwali ààve n'jangu.” ");
INSERT INTO kde_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Bahi vana vachilume vanga Yakobo nkunnyang'ula Shekemu na Hamoli atatake kwa hila, kwa kuva nnumbwao Dina átaijwe dihoni. ");
INSERT INTO kde_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Nkuvahaulila kuchidoni, “Hwetu tukáhulula kuntwala nnumbwetu nkumwing'a munu akáyalwike. Kutenda uchocho ni dihoni kwetuhwe. ");
INSERT INTO kde_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Hwetu tuchitukubaliane na mwenu mukàtenda chinu chimo. Chinu anecho nni mwenu kuva muchi chituvele hwetu, kwa kunnyalula kila nnume mmwenu. ");
INSERT INTO kde_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Anepo njo pamumbevalomba vali vetu na hwetu kuvalomba vali venu. Tuchituikale pamo na kuva utuvamo. ");
INSERT INTO kde_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Henga mukàhita kukubaliana na hwetu na kuyalulwa, bahi hwetu tùmbentwala nnumbwetu na kuuka nawe.” ");
INSERT INTO kde_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Malove anelo nkuva lambone pameho panga Hamoli na Shekemu mwanawe. ");
INSERT INTO kde_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Bahi Shekemu, kijana achieshimika namene kupunda vanu vammalele vachiikala nng'ande mwa atatake, nang'e nanga panatimile kuhwena unalatenda àlalá lavavahaulidile, kwa kuva ánintamwa namene mwali wanga Yakobo. ");
INSERT INTO kde_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Bahi Hamoli na Shekemu mwanawe, nkuhwena pannango wa kuinjilila muimanga yavo, pachinu pavakojana vanu, nkulonjela na vanu vao, ");
INSERT INTO kde_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","uvachidoni, “Ava vanu nni ayanjavetu. Bahi tuvakalibishe vaikale nchilambo chetu na kuchuusa, kwa kuva tùvele na chilambo cha kututosha hwetu na vanang'o, koka hwetu tuvalombe vali vao na vanang'o vavalombe vali vetu. ");
INSERT INTO kde_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Henga vanang'o vàmbekubali kuikala na hwetu na kuva utuvamo tukàtenda chinu chimo. Kila nnume muhwetu àlembelewa ayalulwe muchi chivayalwike vanang'o. ");
INSERT INTO kde_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Dachi, mwenu nanga pamwona kuva anyama vao vammalele na dimali dyao dìmbekuva dyetu? Bahi tukubaliane navo uchinga vaikale pamo na hwetu.” ");
INSERT INTO kde_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Bahi alume vammalele vanakojêne pannango wa kuinjilila muimanga nkuyambukilana na Hamoli na Shekemu mwanawe. Bahi alume vammalele va imanga aneyo nkuyalulwa. ");
INSERT INTO kde_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Nniduva lya tatu lya kuyalulwa kwavo, wakati vammalele vilonda vivenkuukùtà namene, vana vavili vanga Yakobo, yani Simeoni na Lawi, alumbuvake Dina, nkutwala mapanga lavo, nkuhwena unaihavila aila imanga bila vene kumala na kuvawalala alume vammalele. ");
INSERT INTO kde_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Nkummwalala kwa upanga Hamoli na Shekemu mwanawe, nkunhumya Dina nng'ande mwanga Shekemu, nkuukananga. ");
INSERT INTO kde_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Anepo vana vanji vachilume vanga Yakobo nkuinjila muimanga aneyo nkutwala litwala dimali dyammalele ing'anya nnumbwao Dina átaijwe dihoni. ");
INSERT INTO kde_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Vátwete dingandolo na dimbudi na ding'ombe na punda na kila chinu chinavele muimanga na kumawelu, ");
INSERT INTO kde_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","na kuvatwala litwala vavana na amahe vammalele na dimali dyavo dyammalele dinavele n'ding'ande dyavo. ");
INSERT INTO kde_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Bahi Yakobo nkunnyaulila Simeoni na Lawi kuchidoni, “Mwenu mùngupelekejijije ibaniki kwa kungutenda ngunung'e kwa venedi va chilambo achino cha Vakanaani na Vapelizi. Nangu nikávele na vanu vohe, na kama vakàlundana na kwida unanguhavila, vachivanguwalale nangu chalumo na alangavetu.” ");
INSERT INTO kde_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Anevo vana vavili nkuchidoni, “Dachi, wako úlembela tunneke nnumbwetu wantendela muchi malaya?” ");
INSERT INTO kde_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Liduva limo Nnungu nkunnyaulila Yakobo kuchidoni, “Panganika mwanda uhwene ukaikale ku Beseli na ukangudengele chitala. Nangu njo Nnungu nnakuhumidile puchintukuta nkululo Esau.” ");
INSERT INTO kde_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Bahi Yakobo nkuvahaulila alangavake na vanu vammalele vanavenavo kuchidoni, “Yahilangila kulehu disanamu dya milungu dimuvenadyo, lihahulange na muwalange dinguwo dinji kulanguja kuva mùnilihahula muyo mwanga Nnungu, ");
INSERT INTO kde_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","koka tuhwene ku Beseli uchinga nikan'dengele Nnungu chitala, Nnungu ayula anayang'wile maombi langu muuhiku wa kubanika kwangu na kuva pamo na nangu kila pachinu panichihwena.” ");
INSERT INTO kde_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Bahi anevo vanu nkumwing'anga Yakobo disanamu dyammalele dya milungu divanavenadyo pamo na diheleni divanawete mmakutu lavo. Yakobo nkudihuhulila pahi nnandi wa mwaloni unavele pepi na ku Shekemu. ");
INSERT INTO kde_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Yakobo na vana vake pavanavele mmwanda, Nnungu nkuvayopeha namene venedi va dimanga dyammalele dichivadinguka, na wala nanga pavanalingile kuvapapatilila. ");
INSERT INTO kde_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Bahi Yakobo pamo na vanu vammalele vanalongene navo nkuhwika ku Luzu, yani ku Beseli, nchilambo cha ku Kanaani. ");
INSERT INTO kde_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Yakobo nkudenga chitala pachinu anepo, nkupachema “El-Beseli,” kwa kuva, pachinu anepo njo panalilangujije Nnungu kwanga Yakobo uhiku wachintukuta Esau, nkuluwe. ");
INSERT INTO kde_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Bahi Debola, anavele yaya wanga Labeka, nkuhila, nkunansika pannandi wa mwaloni unavele mpata wa kusini wa imanga ya Beseli. Bahi Yakobo nkupachema pachinu anepo Aloni-Bakusi, mana lake “Mwaloni wa Maomboleso.” ");
INSERT INTO kde_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yakobo pauyite kuhaloka ku Padani-Alamu, Nnungu nkunhumila kavila na kum'baliki. ");
INSERT INTO kde_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Nnungu nkunnyaulila kuchidoni, “Wako lina lyako Yakobo, henga ukambechemwa kavila lina anelyo, vino lina lyako lìmbekuva Isilaeli.” Bahi anepo njo Nnungu panchemile Yakobo lina, Isilaeli. ");
INSERT INTO kde_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Nnungu nkunnyaulila Yakobo kuchidoni, “Nangu ni Nnungu Nguvêle Na Dimongo Dyammalele. Veleka, na vanu va nnukolo lwako vayenjejeke. Vanu va nnukolo lwako vàmbekuva chilambo chikulungwa, na vàmbekuva vilambo vyohe na vanji vàmbekuva vafalume. ");
INSERT INTO kde_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Chilambo chinnamwing'ile Iblahimu na Isaka, nìmbekwing'a na wako na vanu va nnukolo lwako.” ");
INSERT INTO kde_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Bahi Nnungu pamalidile kulonjela na Yakobo, nkunneka. ");
INSERT INTO kde_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Na pachinu anepo Nnungu pachitangola na Yakobo, Yakobo nkuliimija liyanga uchinga lììve ukumbuso, nkulijuha kuva lyanga Nnungu kwa kulimiminila mahuta na sadaka ya chikimbilo. ");
INSERT INTO kde_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Bahi Yakobo nkupachema anepo pachinu panalonjedile na Nnungu, Beseli. ");
INSERT INTO kde_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Bahi Yakobo pamo na alangavake vammalele nkuuka pa Beseli, nkulodya ku Efulata. Henga pavanavele nndila, kulehu kadiki na ku Efulata, Laheli nkulindamuka uchungu wa kuveleka, na ánibanika namene pachiveleka. ");
INSERT INTO kde_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Laheli bada ya kuveleka kwa ibaniki ing'ulu, nkunga nkunnyaulila kuchidoni, “Unayope, kwa kuva ùmpete mwana yunji wachilume.” ");
INSERT INTO kde_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Laheli panavele pepi na kuhwa, nkunchema aneyo mwana lina, Ben-Oni, mana lake “mwana wa ibaniki yangu.” Henga atatake nkunchema lina, Benjamini, mana lake “mwana wa kunkono kwangu.” ");
INSERT INTO kde_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Bahi Laheli nkuhila, nkunansika nnyenje indila ilôja ya ku Efulata, yani Beselehemu. ");
INSERT INTO kde_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakobo nkuliimija liyanga lya ukumbuso muha nsati wa Laheli, na liyanga anelyo lìnipwawa mpaka nelo. ");
INSERT INTO kde_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Bahi Isilaeli, yani Yakobo nkuuka anepo chalumo na alangavake nkuhwena unadenga n'gongwe wake mpata wavili wa nnala wa valinzi aneko ku Edeli. ");
INSERT INTO kde_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Isilaeli pachiikala nchilambo anecho, Lubeni mwanawe, nkulala na Biliha, ntumwa anavele n'jawe atatake, Isilaeli nkupilikana habali aneyo. Yakobo ávele na vana kumi na mbili vachilume. ");
INSERT INTO kde_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Vana vachilume vammelekedile Leya ni avano, Lubeni mwana ntandi wanga Yakobo na Simeoni na Lawi na Yuda na Isakali na Zabuloni. ");
INSERT INTO kde_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Na vana vachilume vammelekedile Laheli ni avano, Yusufu na Benjamini. ");
INSERT INTO kde_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Na vana vachilume vammelekedile Biliha, ntumwa wanga Laheli ni avano, Dani na Nafutali. ");
INSERT INTO kde_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Na vana vachilume vammelekedile Zilipa, ntumwa wanga Leya ni avano, Gadi na Asheli. Anevo njo vana vachilume vanga Yakobo, vanavelekwejije aneko ku Padani-Alamu. ");
INSERT INTO kde_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Bahi Yakobo nkuuka anepo, nkunahwika kukaya kwa Isaka atatake aneko ku Mamle, pepi na Kiliasi-Alba, yani Hebloni, pachinu pavachiikala Iblahimu na Isaka muchi amidi. ");
INSERT INTO kde_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Isaka áhidile akongopèlè namene, avèlè na vyaka vyohe namene, vyaka myamoja samanini. Na bada ya kuhwa nkuhwena unaikala pamo na anyakala vake, vanahidile kala. Bahi vana vake, yani Esau na Yakobo, nkunsika. ");
INSERT INTO kde_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Aino njo histoliya yanga Esau, yani Edomu. ");
INSERT INTO kde_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau ávalombile amahe vavili va Chikanaani, yani Ada mwali wanga Eloni, Mhiti na Oholibama mwali wanga Anahi, n'dukuluwe Zibeoni, Mhivi. ");
INSERT INTO kde_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Uchocho, nkunnomba na Basemasi mwali wanga Isumaili, nnumbuwe Nebayosi. ");
INSERT INTO kde_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada nkummelekela Esau mwana uvananchemile lina Elifazi, na Basemasi nkummelekela Esau mwana uvananchemile lina Leuweli. ");
INSERT INTO kde_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Na Oholibama nanang'e nkummaleka Esau vana vatatu, yani Yeushi na Yalamu na Kola. Anevo njo vana vanga Esau vanavelekwejije nchilambo cha ku Kanaani. ");
INSERT INTO kde_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Bahi Esau nkuvatwala ajavake na vana vake vachilume na vachimahe na vanu vammalele va nng'ande mwake na ang'ombe vake na anyama vake vanji vammalele pamo na dimali dyake dyammalele dyanapete nchilambo cha Kanaani, nkuhamila pachinu panji, kulehu na Yakobo nnung'une. ");
INSERT INTO kde_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Esau átendile uchocho ing'anya dimali dyao dívele dyohe namene mpaka nanga kuhululika kuikala pamo. Chilambo chivachiikala muchi amidi chikáchivatosha ing'anya vávele na anyama vohe namene. ");
INSERT INTO kde_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Bahi Esau, yani Edomu nkuhwena unaikala nchilambo cha machinga-machinga cha ku Seili. ");
INSERT INTO kde_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Aino njo histoliya ya vanu va nnukolo lwanga Esau, anakulwao Vaedomu vaikâla nchilambo cha machinga-machinga cha ku Seili. ");
INSERT INTO kde_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Vana vachilume vanga Esau nni, Elifazi wanammelekedile Ada n'jawe, na Leuweli wanammelekedile Basemasi n'jawe yunji. ");
INSERT INTO kde_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Na vana vachilume vanga Elifazi nni, Temani na Omali na Sefo na Gatamu na Kenazi. ");
INSERT INTO kde_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifazi mwana wanga Esau ávele na ntumwa wanan'juhije kuva n'jawe, uvachinchema Timna. Mmahe aneyo ámmelekedile Elifazi mwana uvachinchema Amaleki. Bahi anevo njo vanavele adukuluvake Ada, n'jawe Esau. ");
INSERT INTO kde_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Na vana vachilume vanga Leuweli nni Nahasi na Zela na Shama na Miza. Bahi anevo njo vanavele adukuluvake Basemasi n'jawe Esau. ");
INSERT INTO kde_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Na Oholibama mmahe yunji wanga Esau, mwali wanga Anahi, n'dukuluwe Zibeoni, ámmelekedile Esau vana vatatu vachilume, yani Yeushi na Yalamu na Kola. ");
INSERT INTO kde_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Avano njo vanu va nnukolo lwanga Esau, vanajukile kuva vakulu va ding'olo. Vana vachilume vanga Elifazi, mwana ntandi wanga Esau vanajukile kuva vakulu va ding'olo nni Temani na Omali na Sefo na Kenazi, ");
INSERT INTO kde_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","na Kola na Gatamu na Amaleki. Anevo njo vakulu va ding'olo vanahalokene na Elifazi, nchilambo cha Edomu. Na anevo vammalele njo vanavele adukuluvake Ada, n'jawe Esau. ");
INSERT INTO kde_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Vana va chilume vanga Leuweli, mwana wanga Esau, vanajukile kuva vakulu va ding'olo nni Nahasi na Zela na Shama na Miza. Anevo njo vakulu va ding'olo vanahalokene na Leuweli, nchilambo cha Edomu. Na anevo vammalele njo vanavele adukuluvake Basemasi, n'jawe Esau. ");
INSERT INTO kde_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Vana vachilume vanga Oholibama n'jawe Esau vanajukile kuva vakulu va ding'olo nni Yeushi na Yalamu na Kola. Anevo njo vanavele vakulu va ding'olo vanahalokene na Oholibama, n'jawe Esau, mwali wanga Anahi. ");
INSERT INTO kde_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Bahi anevo njo vanavele vanu va nnukolo lwanga Esau, yani Edomu, na kila munu muanevo ávele nkulu wa lukolo lwake. ");
INSERT INTO kde_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Vana vachilume vanga Seili, Muholi, vachiikala nchilambo cha Edomu nni Lotani na Shobali na Zibeoni na Anahi, ");
INSERT INTO kde_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","na Dishoni na Eseli na Dishani. Anevo njo vanajukile kuva vakulu va ding'olo dya Vaholi nchilambo cha Edomu. ");
INSERT INTO kde_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Vana va chilume vanga Lotani nni Holi na Hemamu, na nnumbuwe Lotani vánchema Timna. ");
INSERT INTO kde_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Vana vachilume vanga Shobali nni Aluvani na Manahasi na Ebali na Shefo na Onamu. ");
INSERT INTO kde_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Vana vachilume vanga Zibeoni nni Aiya na Anahi. Anahi njo anaviwene vimbwimbwi vya medi la moto aneko kulilanga pachivachunga punda va Zibeoni atatake. ");
INSERT INTO kde_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Vana vanga Anahi nni Dishoni na Oholibama nnumbuwe Dishoni. ");
INSERT INTO kde_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Vana vachilume vanga Dishoni nni Hemdani na Eshibani na Isilani na Kelani. ");
INSERT INTO kde_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Vana vachilume vanga Eseli nni Biluhani na Zawani na Akani. ");
INSERT INTO kde_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Na vana vachilume vanga Dishani nni Uzi na Alani. ");
INSERT INTO kde_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Bahi vakulu va ding'olo dya Vaholi nni Lotani na Shobali na Zibeoni na Anahi, ");
INSERT INTO kde_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","na Dishoni na Eseli na Dishani. Ding'olo dya Vaholi dìchemwije malina kupapatana na malina la vakulu anevo, vachiikala nchilambo cha Seili. ");
INSERT INTO kde_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","32","Malina la vafalume vanatawalite chilambo cha Edomu nni Bela, mwana wanga Beoli, anajuhije imanga ya Dinihaba kuva imanga yake ing'ulu. ");
INSERT INTO kde_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bada ya kuhila Bela, nkutawala Yobabu mwana wanga Zela kuhaloka ku Bosila. ");
INSERT INTO kde_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Na bada ya kuhila Yobabu, nkutawala Hushamu wa chilambo cha Vatemani. ");
INSERT INTO kde_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Na pahidile Hushamu, nkutawala Hadadi mwana wanga Bedadi anajuhije imanga ya Avisi kuva imanga yake ing'ulu. Nfalume aneyo njo anavapanyile na kuvalema Vamidiani nchilambo cha ku Moabu. ");
INSERT INTO kde_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Bada ya kuhila Hadadi, nkutawala Samula kuhaloka ku Masileka. ");
INSERT INTO kde_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samula pahidile, nkutawala Shauli kuhaloka imanga ya ku Lehobosi, imanga ivêle pepi na muto. ");
INSERT INTO kde_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Bada ya kuhila Shauli, nkutawala Baali-Hanani, mwana wanga Akiboli. ");
INSERT INTO kde_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Na bada ya kuhila Baali-Hanani mwana wanga Akiboli, nkutawala Hadadi anajuhije imanga ya Pau kuva imanga yake ing'ulu. N'jawe Hadadi vánchema Mehetabeli, mwali wanga Matiledi, n'dukuluwe Mezahabu. ");
INSERT INTO kde_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Malina la vakulu va ding'olo dihalokêne na Esau nni Timna na Aluva na Yasesi na Oholibama na Ela na Pinoni, na Kenazi na Temani na Mibisali na Magidieli na Ilamu. Anevo vammalele váikalanga nchilambo cha Edomu. Na kila pachinu pavachiikala vanu va lukolo fulani, páchemwije lina lya nkulu wa lukolo anelwo. ");
INSERT INTO kde_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakobo nkuhweneha kuikala nchilambo cha ku Kanaani, chilambo chachiikala atatake muchi mmidi. ");
INSERT INTO kde_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Aino njo histoliya ya Yakobo na vanu va nnukolo lwake. Yusufu mwana wanga Yakobo panavele na vyaka kumi na saba, nang'e ávachunga angandolo na ambudi chalumo na akuluvake va ayuvake vanji. Anevo akuluvake nni vana va atatake vavavelekedîle kwa avala ajavake vatumwa, yani Biliha na Zilipa. Na Yusufu nkuva wannyaulila atatake habali dikee dyambone kwamba anevo akuluvake. ");
INSERT INTO kde_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Bahi Isilaeli, yani Yakobo nkuntamwa namene Yusufu kupunda vana vake vanji vammalele ing'anya ávele mwana wanammeleke muusele wake. Yakobo nkulaija vantotele Yusufu lijoho likatapele namene. ");
INSERT INTO kde_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Henga avala akuluvake pavawene kuva atatawao àntamwa namene Yusufu kupunda vavana vanji vammalele, vanang'o nkunsunalila Yusufu na nanga pavanalonjedile nawe kwa amani. ");
INSERT INTO kde_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Liduva limo Yusufu nkulota indoto. Nang'e nkuvahaulila akuluvake kwamba aneyo indoto, vanang'o nkuhalija kunsunalila. ");
INSERT INTO kde_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yusufu ávahaulidile kuchidoni, “Pilikanila indoto ingulotile. ");
INSERT INTO kde_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ngúlotile tuvammalele tuvèlè kumawelu utuhunganga visa vya ngano. Upala chisa changu nkuimila, na visa vyenu nkuchidinguka chisa changu na kuchihunamila mpaka pahi kwa eshima.” ");
INSERT INTO kde_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Akuluvake nkummuja kuchidoni, “Dachi, wako ùlembela ututawale hwetu? Dachi, muhiu kuva wako uchiututawale hwetu?” Bahi vanang'o nkuhalija kunsunalila ing'anya ya indoto na malove lake lavahaulidile. ");
INSERT INTO kde_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Bahi Yusufu nkulota kavila indoto inji, nkuvasimulila akuluvake wachidoni, “Mwenu pilikanila! Ngùlotile indoto inji. Muindoto aneyo ngúliwene liduva na mwedi na dinondwa kumi na moja udinguhunamila mpaka pahi kwa eshima.” ");
INSERT INTO kde_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Na pachivasimulila akuluvake indoto aneyo, atatake nanang'e ánipwawa. Henga atatake nkunkalipila wachidoni, “Indoto ntwani aneyo yulotile? Ìmbehululika dachi nangu na anyoko na akuluvako tukuhunamile wako mpaka pahi kwa eshima?” ");
INSERT INTO kde_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Akuluvake nkummikila wiu, henga atatake nkulavika munda malove anelo. ");
INSERT INTO kde_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Bahi liduva limo akuluvake Yusufu vápite unavachunga anyama va atatawao pepi na ku Shekemu. ");
INSERT INTO kde_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Isilaeli nkunnyaulila Yusufu kuchidoni, “Akuluvako vàvachunga anyama aneko ku Shekemu. Bahi nangu ngùlembela nikutume ukavalole.” Yusufu nkuyang'ula kuchidoni, “Nangu ngùvele chihi tayali.” ");
INSERT INTO kde_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Atatake nkunnyaulila kuchidoni, “Hwena ukavalole akuluvako na anyama kama vàvele salama, koka uuye unguhaulile.” Bahi Yakobo nkuntuma Yusufu kuuka anepo paluhunde lwa Hebloni, pachinu pavachiikala, ahwene ku Shekemu. Yusufu panavele pepi kuhwika ku Shekemu, ");
INSERT INTO kde_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","wanachidumba-dumba mwilanga, nkukojana na munu yumo. Aneyo munu nkummuja Yusufu kuchidoni, “Utaha chamani?” ");
INSERT INTO kde_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yusufu nkunnyang'ula kuchidoni, “Ngùvataha akuluvangu. Chonde nguhaulile pachinu pavavachungila anyama.” ");
INSERT INTO kde_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ayula munu nkunnyang'ula kuchidoni, “Anevo vanu apano vàniuka, kwa kuva nívapilikene uvahaula kuva vàhwena ku Dosani.” Bahi Yusufu nkuvalondola akuluvake, nkuvakoja aneko ku Dosani. ");
INSERT INTO kde_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Bahi akuluvake pavammwene avèlè kwa kulehu, kabla akànambihwika, vanang'o nkutenda ntemelo wa kummwalala. ");
INSERT INTO kde_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Nkuhaulanila kuchidoni, “Lola, nkúlota àvenkwida. ");
INSERT INTO kde_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Bahi tummwalale na kuntaya nchihima chimo muavi, koka tukahaule kuva àliwije na nnyama wa kuyoha wa munnyitu, koka tulole anedyo dindoto dyake dìmbekuva dachi.” ");
INSERT INTO kde_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Henga Lubeni papilikene anelo malove, nkulembela ampohe mmakono mwavo wachidoni, “Chonde, tunammwalale. ");
INSERT INTO kde_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ing'anya ntwani tumwadile myadi kwa makono letu? Tuntaye chihi nchihima achino cha apano palilanga koka tunneke ahwe chihi mwene.” Lubeni áhawile uchocho uchinga ampohe Yusufu mmakono mwavo, koka ammuihe kukaya kwa atatake. ");
INSERT INTO kde_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yusufu pahwikile kwa akuluvake, vanang'o nkunkudumbula alila lijoho likatapêle lyanawete. ");
INSERT INTO kde_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Bahi nkunkamula na kuntaya nchihima chikavele na medi. ");
INSERT INTO kde_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Akuluvake Yusufu pavachilya chakulya, nkuvona Vaisumaili vavêle mmwanda uvahaloka ku Gileadi uvahwena ku Misili. Na angamila vao ványakuhijwe misigo ya samani ing'ulu, yani ubani na manemane na aina dinji dya ulimbo wa kunung'ila. ");
INSERT INTO kde_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Anepo Yuda nkuvahaulila anung'unuvake kuchidoni, “Tùmbepata chamani tukàmmwalala nnung'unwetu na kupiha chitendo anecho? ");
INSERT INTO kde_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kwa kuva, ayu ni nnung'unwetu, na nni myadi imo na hwetu, bahi tunammwalale, wasa tunsumise chihi kwa ava Vaisumaili.” Bahi akuluvake na anung'unuvake nkukubali. ");
INSERT INTO kde_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Bahi Vaisumaili, yani vakúchuusa va Chimidiani pavakamwele pachinu apala, akuluvake Yusufu nkunhumya Yusufu nchihima, nkunsumisa kwa vipande ishilini vya madini la dihela. Na anevo vakúchuusa nkunnyakula Yusufu mpaka ku Misili. ");
INSERT INTO kde_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Bahi Lubeni pauyite apala pachihima, nanga panammwene kavila Yusufu, nang'e nkupapula dinguwo dyake, ing'anya ánihinginika namene, ");
INSERT INTO kde_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","nkuvahwenela anung'unuvake nkuvahaulila kuchidoni, “Nnung'unwetu akapali nchihima! Vino nangu nìmbetenda dachi?” ");
INSERT INTO kde_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Bahi vanang'o nkunsinja umbudi, nkulitwala alila lijoho lyanga Yusufu, nkulichuvika mmyadi ya umbudi. ");
INSERT INTO kde_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Nkulitwala alila lijoho nkumpelekejija atatawao, nkunnyaulila kuchidoni, “Alino lijoho tùnililakota. Lilole ikàva lya mwanalo au nanga.” ");
INSERT INTO kde_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Atatawao palilolite nkulimala, nkuchidoni, “Alino lijoho lya mwanangu! Muhiu nnyama wa kuyoha àninkamula na kuntang'una. Muhiu Yusufu ànihalangwa vipande-vipande.” ");
INSERT INTO kde_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Bahi Yakobo nkupapulanga dinguwo dyake ing'anya ánihinginika namene, nkuwala inguwo ya ligunila nchikundu, nkunkutangila mwanawe kwa maduva lohe. ");
INSERT INTO kde_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Vana vake vachilume na vachimahe nkwida unantuja ntima, henga nang'e nkuhita kutujwa ntima wachidoni, “Ngulekange. Nangu nguchinguhwenehe kunkutangila mwanangu mpaka panimbekuhwa.” Bahi atatake nkuhweneha kunkutangila. ");
INSERT INTO kde_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Mmahiku ulolo, Vaisumaili nkunsumisa Yusufu aneko ku Misili kwa munu yumo uvanchema Potifa, afisa yumo wa Falao, nfalume wa ku Misili. Potifa ávele nkulu wa valinzi va paing'ande ya nfalume. ");
INSERT INTO kde_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Mmahiku ulolo, Yuda nkuhapukana na akuluvake na anung'unuvake, nkuhwena kuimanga ya ku Adulami unaikala na munu yumo uvanchema Hila. ");
INSERT INTO kde_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Yuda panavele aneko nkumwona mwali yumo wa Chikanaani, nang'e nkunnomba. Mwali aneyo atatake vánchema Shuwa. ");
INSERT INTO kde_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Aneyo mwali nkwikuta chitumbo, nkummaleka mwana wachilume nkunchema lina Eli. ");
INSERT INTO kde_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Nkwikuta kavila chitumbo, nkummaleka mwana wa chilume nkunchema lina Onani. ");
INSERT INTO kde_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Nkwikuta kavila chitumbo nkummaleka mwana yunji wachilume nkunchema lina Shela. Pavelekwejije Shela, mahiku anelo Yuda áikala ku Kezibu. ");
INSERT INTO kde_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yuda nkuntwalila Eli, mwanawe ntandi, mmahe uvanchema Tamali. ");
INSERT INTO kde_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Henga Eli, ávele munu atênda lahakalenge pameho panga Yahwe, bahi Yahwe nkummwalala. ");
INSERT INTO kde_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Bahi Yuda nkunnyaulila Onani kuchidoni, “Ntwale mmahe wa nkululo ahidîle, kwa kuva nni chulembelewa kutenda uchinga ummalekele nkululo vana.” ");
INSERT INTO kde_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Henga Onani, ánimala kuva anevo vana vakambekuva vake, bahi Onani kila pachilala na aneyo mmahe, nkuva wahumula uchinga anammelekela nkuluwe vana. ");
INSERT INTO kde_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Yahwe nkwona kuva chitendo anecho chinihakalanga pameho pake, bahi nanang'e nkummwalala. ");
INSERT INTO kde_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Bahi Yuda nkunnyaulila Tamali, mmahe wa mwanawe kuchidoni, “Uya kukaya kwa atatako, ukahwenehe kuva nannidi mpaka pambekulumuka mwanangu Shela.” Yuda átangwele uchocho wayopa Shela nanang'e anahwa muchi akuluvake. Bahi Tamali nkuuya kukaya kwa atatake. ");
INSERT INTO kde_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Bada ya kupita vyaka fulani, n'jawe Yuda, mwali wanga Shuwa, nkuhila. Yuda pamalidile kunkutangila nkuuka chalumo na nnyanjawake uvanchema Hila, Mmwadulami, nkuhwena ku Timna kwa vanu vachivacheketa angandolo vake maleha. ");
INSERT INTO kde_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamali papilikene kuva nkawake àvele nndila kuhwena ku Timna unavacheketa angandolo vake maleha, ");
INSERT INTO kde_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","nang'e nkuula dinguwo dyake dya unannidi, nkulivimba inguwo kumeho uchinga anamaikane. Nkuikala pannango wa kuinjilila nchijiji cha Enaimu, chijiji chivêle nndila ihwêna ku Timna. Tamali átendile uchocho ing'anya áwene kuva Shela ànikulumuka, henga nanga pavanantwalidile uchinga ààve ntwave. ");
INSERT INTO kde_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yuda pammwene Tamali, nang'e ántenda kahaba, ing'anya Tamali álivimbile inguwo kumeho kwake. ");
INSERT INTO kde_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Bila kummala, Yuda nkummwenela Tamali apala panyenje indila panavele, nkunnyaulila kuchidoni, “ Nangu ngùlembela ngulale na wako.” Tamali nkummuja kuchidoni, “Ùmbening'a chamani nikàlala na wako?” ");
INSERT INTO kde_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yuda nkunnyaulila kuchidoni, “Nguchinikwing'e umbudi yumo wamwana kuhaloka nnikuwa lyangu.” Tamali nkuchidoni, “Ngùvikile chinu chimbemaîha kuva uchiuning'e aneyo umbudi.” ");
INSERT INTO kde_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yuda nkummuja kuchidoni, “Wako ùlembela nikuvikile chinu ntwani?” Nang'e nkunnyang'ula kuchidoni, “Ning'e pete ivêle na inembo yako na luvoi lwake lwa kuwalila pang'ulo na isimbo yunyakwile.” Bahi Yuda nkumwing'a anevyo vitukutuku vyammalele, nkulala nawe. Tamali nkwikuta chitumbo cha Yuda. ");
INSERT INTO kde_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Anepo Tamali nkuuya kukaya kwake, nkuula aila inguwo yanalivimbile kumeho, nkuwala kavila dinguwo dyake dya unannidi. ");
INSERT INTO kde_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Mmahiku ulolo, Yuda nkuntuma ayula nnyanjawake, Mmwadulami ampelekeje umbudi uchinga agambole vitukutuku vyanannekedile ayula kahaba, henga Hila nnyanjawake nanga panankojije ayula mmahe. ");
INSERT INTO kde_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Hila nkuvauja venedi va ku Enaimu kuchidoni, “Ayula kahaba wa pachinu pakuabudila milungu achiikala pannango wa kuinjilila nchijiji, nnyenje indila àvele kwachi?” Nkunnyang'ula kuchidoni, “Apano akánambiwahi kupwawa kahaba malinga aneyo.” ");
INSERT INTO kde_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Bahi ayula nnyanjawake nkuuya kwanga Yuda, nkunnyaulila kuchidoni, “Nanga panimmwene! Na venedi va apala vànguhaulidile kuva, pachinu apala pakanambiwahi kupwawa kahaba wa pachinu pakuabudila milungu. ");
INSERT INTO kde_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yuda nkuchidoni, “Nneke aikale navyo uyopa tunahekwa. Nangu nímpelekejijije umbudi, henga wako nanga paunkojije.” ");
INSERT INTO kde_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Bada ya myedi mitatu, munu fulani nkunnyaulila Yuda kuchidoni, “Nkawako Tamali vino àjukile kuva kahaba, na àikwite chitumbo kupitila anewo ukahaba.” Yuda nkuchidoni, “Nnyumye panda munnyoche moto mpaka ahwe!” ");
INSERT INTO kde_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Bahi pavachinnyumya panda, Tamali nkuntuma munu kwa nkawake wachidoni, “Mwene vitukutuku avino njo aning'île chitumbo. Vino nìkuyuwa ummale mwene pete aino na luvoi lwake na isimbo aino.” ");
INSERT INTO kde_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda nkuvimala avila vitukutuku, nkuchidoni, “Tamali njo avêle na haki upunda nangu, kwa kuva nikanampele Shela ààve ntwave.” Bahi kutandikila liduva anelyo Yuda nanga panalele kavila na Tamali. ");
INSERT INTO kde_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Palakamwele mahiku la Tamali kuveleka, nkumaikana kuva nnitumbo lyake mùvele vana mavila. ");
INSERT INTO kde_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Bahi papete uchungu wa kuvaleka, mwana yumo nkuhumya nkono pawelu, nkunga nkuuhunga uzi wanahuvi anewo nkono wachidoni, “Ayuno njo ambekûva ntandi kuvelekwa.” ");
INSERT INTO kde_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Henga ayula mwana pauihije nkono wake nkati, nnyake nkuva ntandi kuvelekwa. Nkunga nkuchidoni, “Mmaa! Uvila njo chuhumile kwa dimongo!” Bahi aneyo mwana nkuchemwa lina Pelesi. ");
INSERT INTO kde_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Lukoto nkuvelekwa ayula anahungwije uzi wanahuvi munkono, nang'e nkuchemwa lina Zela. ");
INSERT INTO kde_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Bahi Yusufu patwaliwije kupelekejwa ku Misili, Mmisili yumo uvanchema Potifa anavele afisa nkulu wa valinzi va paing'ande ya Falao, nfalume wa Misili, nkunsuma Yusufu kuhaloka kwa Vaisumaili vanampelekejije Yusufu ku Misili. ");
INSERT INTO kde_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Na Yahwe ávele pamo na Yusufu, na kun'jalila namene. Na Yusufu nkuva waikala nng'ande mwa Potifa, nang'olo wake Mmisili. ");
INSERT INTO kde_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Nang'olo wake nkumala kuva Yahwe ávele pamo na Yusufu, na kumala kuva Yahwe njo achijalîla kila chinu cháchitenda Yusufu. ");
INSERT INTO kde_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Bahi Potifa nkukatapaliwa namene nawi Yusufu, mpaka kuva ntumishi wake mwene Potifa. Potifa nkun'juha Yusufu kuva nkwímilila wa ing'ande yake na dimali dyake dyammalele. ");
INSERT INTO kde_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Bahi kutandikila uhiku aula Potifa wanantendile Yusufu kuva nkwímilila wa ing'ande yake na dimali dyake dyammalele, Yahwe nkuibaliki ing'ande ya aneyo Mmisili ing'anya yanga Yusufu. Yahwe nkuchibaliki kila chinu chanavenacho Potifa, nng'ande na kumawelu. ");
INSERT INTO kde_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Bahi ing'anya ya anelyo, Potifa nkumwing'a Yusufu mamulaka la kwimilila mambo lake lammalele, na mwene Potifa nkuva chihi walyamulila chakulya chambekulya. Yusufu ávele kijana avêle na mmili wambone na ánikatapala namene. ");
INSERT INTO kde_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Bahi bada ya muda fulani, n'jawe Potifa nkummilangila mata Yusufu, nkunnyaulila kuchidoni, “Lala na nangu!” ");
INSERT INTO kde_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Henga Yusufu nkuhita, nkunnyaulila kuchidoni, “Pilikanila! Nang'olo wangu àning'ile mamulaka la kwimilila kila chinu amuno nng'ande, na mwene vino nanga pakambikambila kavila chinu chohecho. ");
INSERT INTO kde_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Na amuno nng'ande, nang'olo wangu àngupele mamulaka lammalele. Nang'e nanga pangulimbijije kuchikamula chinu chohecho, ikànave chihi wako bahi, ing'anya wako n'jawe. Vino nangu nìmbehulula dachi kutenda chinu chihakalenge malinga achi na kunkosela Nnungu?” ");
INSERT INTO kde_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ayula mmahe nkuhweneha kunkumba Yusufu kila liduva, henga Yusufu nanga panampilikanidile na wala panayambukidile kulala nawe. ");
INSERT INTO kde_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Liduva limo Yusufu nkwinjila nng'ande unakola madengo lake malinga cháchitenda, na amadengo vanji nanga pavanapwawije anemwo nng'ande. ");
INSERT INTO kde_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","N'jawe Potifa nkukamula inguwo ya Yusufu, nkunnyaulila kuchidoni, “Lala na nangu!” Henga Yusufu nkunnekela aneyo inguwo nkutukutila pawelu. ");
INSERT INTO kde_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Bahi ayula mmahe pawene kuva Yusufu àilekile inguwo yake mmakono mwake na kutukutila pawelu, ");
INSERT INTO kde_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","nang'e nkuvachema vatumishi va nng'ande mwake nkuvahaulila kuchidoni, “Lola! Ayu Mweblaniya ntumwa waidile nawe ntwangu àidile unatutaya dihoni. Nang'e áidile kwang'une walembela angutule, henga nangu nkukuta ding'uto. ");
INSERT INTO kde_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Papilikene ungukuta ding'uto, nkuleka inguwo yake, nkutukutila pawelu.” ");
INSERT INTO kde_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Bahi ayula mmahe nkuiungula aila inguwo mpaka pauite ntwave. ");
INSERT INTO kde_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Nkunnyaulila ntwave habali aneyo wachidoni, “Ayula ntumwa Mweblaniya uwidîle nawe apano pakaya ámbengutula. ");
INSERT INTO kde_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Henga pangukutile chihi ding'uto, nang'e nkuileka inguwo yake nkutukutila pawelu.” ");
INSERT INTO kde_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Bahi Potifa papilikene malove lannyaulidile n'jawe kwamba chatendile Yusufu, nkuvisa namene. ");
INSERT INTO kde_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Potifa nkuntwala Yusufu nkunantaya nnilungu, pachinu pavachihungwa vafungwa vanga nfalume. Henga Yusufu panavele nnilungu, ");
INSERT INTO kde_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Yahwe ávele pamo na Yusufu na kuntendela lambone na kuntenda akatapaliwe na nkulu wa lilungu. ");
INSERT INTO kde_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Bahi ayula nkulu wa lilungu nkun'juha Yusufu kuva nkulu wa vafungwa, na kila chinu chichitendêka nnilungu chítendeka kwa mamulaka la Yusufu. ");
INSERT INTO kde_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Ayula nkulu wa lilungu nanga pachikambikambila chinu chohecho chachiimilila Yusufu, kwa kuva Yahwe ávele pamo na Yusufu na kun'jalila kila chinu cháchitenda. ");
INSERT INTO kde_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Mahiku fulani bada ya mambo anelo, maafisa vavili vachintumikila Falao, nfalume wa Misili, nkunkosela Falao, nang'olo wao. Maafisa anevo yumo ávele nkwímilila nkulu wa vikimbilo vya nfalume na yunji ávele nkútaleka nkulu wa mikate ya nfalume. ");
INSERT INTO kde_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Falao nkuvavisija anevo maafisa, ");
INSERT INTO kde_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","nkuvahungila muing'ande ya chitawala yanga Potifa, nkulu wa valinzi va paing'ande ya Falao, pachinu panahungwije Yusufu. ");
INSERT INTO kde_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ayula nkulu wa valinzi nkuntandola Yusufu uchinga avatumikile anevo maafisa. Na anevo vanu nkuhungwa nnilungu kwa mahiku fulani. ");
INSERT INTO kde_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Bahi liduva limo chilo, ayula nkwímilila nkulu wa vikimbilo vya nfalume na ayula nkútaleka nkulu wa mikate ya nfalume, nkulota dindoto anemwo nnilungu, na kila munu álotile indoto yake ivêle na mana tofauti na ya nnyake. ");
INSERT INTO kde_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Yusufu papite ulyamba unavalola, ávakojije vammalele vavili vavèlè nnihindambi. ");
INSERT INTO kde_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Yusufu nkuvauja anevo maafisa vanahungwîje pamo nanang'e muing'ande ya chitawala ya nang'olo wake kuchidoni, “Mwadachi nelo mùikele nnihindambi?” ");
INSERT INTO kde_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Vanang'o nkunnyang'ula kuchidoni, “Tùvele na lipamba ing'anya tùlotile dindoto na nanga munu ahulûla kutuhaulila mana lake.” Yusufu nkuvahaulila kuchidoni, “Kuhaula mana la indoto tenda madengo la Nnungu? Bahi njaulile nangu dindoto dyenu.” ");
INSERT INTO kde_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Bahi ayula nkwímilila nkulu wa vikimbilo vya nfalume nkunsimulila Yusufu indoto yake wachidoni, “Muindoto yangu ngúuwene nzabibu muyo mwangu, ");
INSERT INTO kde_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","unavele na dinavi dinatu. Kwa mwanda umo, anewo nzabibu nkuhipuka mahamba, na dinduva dyake nkulikusumbula na kuhumila zabibu, na anedyo zabibu nkuula upala. ");
INSERT INTO kde_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Munkono mwangu ngúnyakwile chikombe changa nfalume, bahi nangu nkuditwala adila zabibu, nkudiminyila nchikombe anecho, nkumwing'a nfalume.” ");
INSERT INTO kde_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yusufu nkunnyaulila kuchidoni, “Mana la indoto yako nni aino, anedyo dinavi dinatu ni maduva matatu. ");
INSERT INTO kde_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Nniduva lyatatu, Falao achiakuhumye nnilungu na kukuuija kavila mmadengo lako. Uchiumwing'e kavila Falao chikombe chake muchi chúchitenda anepo patandi. ");
INSERT INTO kde_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Henga paumbejaliwa mmambo lako, chonde ngùyuwa unanguluvalile. Ungutendele lambone na kungulonjelela kwanga nfalume uchinga ngupate kuhuma nnilungu amuno. ");
INSERT INTO kde_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Kwa kuva, nangu ngútwaliwije kwa dimongo kuhaloka nchilambo cha Vaeblaniya, na apano pa Misili nanga chinu chohecho chingútendìlè chakungutenda nguhungwe nnilungu.” ");
INSERT INTO kde_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ayula nkútaleka nkulu wa mikate pawene kuva mana la indoto yahumije Yusufu ni ya mambo lambone nkunnyaulila Yusufu kuchidoni, “Ata nanangu ngùlotile indoto! Muindoto yangu ngùlotile ngunyakwìlè vikapu vitatu vya mikate mmuti mwangu. ");
INSERT INTO kde_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Nchikapu cha muha, múvele aina dyohe dya mikate kwajili ya Falao. Henga vyuni nkuva uvadadola mikate inavele nchikapu cha muha chingúnyakwìlè pamuti pangu!” ");
INSERT INTO kde_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yusufu nkunnyaulila kuchidoni, “Mana la indoto yako nni aino, anevyo vikapu vitatu nni maduva matatu. ");
INSERT INTO kde_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Nniduva lyatatu, Falao achiakuhumye nnilungu, koka auchekete muti wako na kuupatika mmili wako munnandi, na vyuni vàmbekulya inyama ya mmili wako.” ");
INSERT INTO kde_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Liduva lyatatu, lívele liduva lya ukumbuso wa kuvelekwa kwa Falao, bahi Falao nkuvatendela ing'ole maafisa vake vammalele. Nkunhumya nnilungu ayula nkwímilila nkulu wa vikimbilo vya nfalume na nkútaleka nkulu wa mikate, nkuvavika muyo mwa maafisa vake. ");
INSERT INTO kde_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Bahi ayula nkwímilila nkulu wa vikimbilo vya nfalume nkumuija mmadengo lake, uchinga apate kumwing'a kavila Falao chikombe chake cha chikimbilo. ");
INSERT INTO kde_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Henga ayula nkútaleka nkulu wa mikate nkumpatika munnandi, muchi Yusufu chanavahaulidile mana la dindoto dyao. ");
INSERT INTO kde_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Henga ayula nkwímilila nkulu wa vikimbilo vya nfalume áninnuvalila Yusufu, nanga panankumbukidile. ");
INSERT INTO kde_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Bada ya myaka mivili, Falao nkulota indoto. Muindoto aneyo álotile aimidìlè nnyenje muto wa Naili, ");
INSERT INTO kde_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","nkuvona ang'ombe saba vakatapêle na vanyetîle uvahuma mmuto na uvalya wahi. ");
INSERT INTO kde_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Henga bada ya avala ang'ombe saba, nkuhumila ang'ombe vanji saba vahakalenge na vayandîle namene mmuto wa Naili, nkuimila nnyenje, pepi na avala vanyetîle. ");
INSERT INTO kde_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Avala ang'ombe vayandîle namene nkuvalya avala ang'ombe saba vakatapêle na vanyetîle. Anepo Falao nkwimuka nnuwono. ");
INSERT INTO kde_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Falao palalite kavila, nkulota mwanda wavili. Nkulona mahahi saba makulungwa na lakatapêle ulahipuka nnupambahi lumo. ");
INSERT INTO kde_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Alafu nkuhipuka na mahahi lanji saba lachapakêle, layumîjwe na lipungo livêle na chitukuta namene. ");
INSERT INTO kde_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Àlalá mahahi saba lachapakêle nkulamila àlalá mahahi saba makulungwa laumbalidîle ngano. Bahi Falao payumwike, nkumala kuva yavele indoto. ");
INSERT INTO kde_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ulyamba wake, Falao nkuva na lipamba namene, nkuvachema vahavi vammalele va ku Misili, pamo na vanu vavêle na lúnda, nkuvahaulila dindoto dyake, henga wala nanga munu kananga yumo anahulwile kunnyaulila mana lake. ");
INSERT INTO kde_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Bahi ayula nkwímilila nkulu wa vikimbilo vya nfalume nkunnyaulila Falao kuchidoni, “Nelo ngùlakumbukila makosa langu. ");
INSERT INTO kde_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Maduva àlalá lunatuvisijije hwetu tuvatumishi vako, nangu chalumo na nkútaleka nkulu wa mikate, nkutuhungila nng'ande ya chitawala yanga Potifa, nkulu wa valinzi vako, ");
INSERT INTO kde_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","liduva limo chilo twalotile dindoto, kila munu na indoto yake ivêle na mana tofauti na ya nnyake. ");
INSERT INTO kde_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Kijana yumo wa Chieblaniya, ntumishi wanga nkulu wa valinzi vako ávele pamo na hwetu nnilungu. Patunsimulidile dindoto dyetu, nang'e ánihulula kutuhaulila mana la dindoto anedyo, kila munu na indoto yake. ");
INSERT INTO kde_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Chanatuhaulidile njo chiihumidile, nangu nkuuijwa mmadengo langu, na ayula nkútaleka nkulu wa mikate nkupatikwa munnandi.” ");
INSERT INTO kde_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Bahi Falao nkulaija Yusufu achemwe, bahi Yusufu nkuhumywa nnilungu upehi. Bada ya kumowa ulindo wake na kubadili dinguwo dyake, nkuhwena muyo mwanga Falao. ");
INSERT INTO kde_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Falao nkunnyaulila Yusufu kuchidoni, “Nangu ngùlotile indoto, henga nanga munu ahulwîle kunguhaulila mana lake. Henga ǹnipilikana imbili yako kuva wako ukàsimuliwa indoto unahulula kuhaulanga mana lake.” ");
INSERT INTO kde_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yusufu nkunnyang'ula Falao kuchidoni, “Nangu nikáhulula, henga Nnungu achiakwing'e lijibu limbekûva na faida kwakuwe.” ");
INSERT INTO kde_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Bahi Falao nkunnyaulila Yusufu kuchidoni, “Muindoto yangu ngúlotile nguimidìlè nnyenje muto wa Naili, ");
INSERT INTO kde_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","nkuvona ang'ombe saba vakatapêle na vanyetîle uvahuma mmuto na kulya wahi. ");
INSERT INTO kde_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Bada ya anevo, nkuhumila na ang'ombe vanji saba vadabadênge, vahakalênge na vayandîle namene. Nangu nikánambiwahi kuvona ang'ombe vavêle na hali ibaya namuna aneyo nchilambo achino cha Misili. ");
INSERT INTO kde_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Bahi avala ang'ombe vahakalenge na vayandîle namene nkuvalya avala ang'ombe saba vanyetîle. ");
INSERT INTO kde_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Henga pamo na kuvalya avala ang'ombe vanyetîle, wala nanga munu achichiavamale kuva vàvalile avao, kwa kuva váyandile chihi uchila muchi chivanavele patandi. Anepo nangu nkwimuka nnuwono. ");
INSERT INTO kde_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Anepo nangu nkulota indoto inji, na muindoto aneyo ngúlawene mahahi saba lakatapêle, laumbalidîle ngano ulahipuka nnupambahi lumo. ");
INSERT INTO kde_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Bada ya anelo nkuhipuka mahahi lanji saba lakávele na ngano nkati mwake, lachapakêle, layumîjwe na lipungo livêle na chitukuta namene. ");
INSERT INTO kde_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Àlalá mahahi saba lachapakêle nkulamila àlalá mahahi saba lakatapêle. Bahi nangu nkuvasimulila ahavi dindoto anedyo, henga nanga munu ahulwîle kunguhaulila mana lake.” ");
INSERT INTO kde_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Anepo Yusufu nkunnyaulila Falao kuchidoni, “Dindoto dyako dyammalele dìvele chihi na mana imo bahi. Nnungu àkuhunukulidile mambo lambelatenda mmaduva ulola laîda. ");
INSERT INTO kde_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Avala ang'ombe saba vakatapêle ni vyaka saba, na àlalá mahahi saba lakatapêle nni vyaka saba. Dindoto anedyo dìvele chihi na mana imo. ");
INSERT INTO kde_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Avala ang'ombe saba vayandîle namene vanahumidile bada ya avala vanyetîle, na àlalá mahahi saba lakávele na chinu, layumîjwe na lipungo livêle na chitukuta namene, mana lake ni myaka saba ya indala. ");
INSERT INTO kde_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Nfalume, malinga chinikuhaulidile kuva, Nnungu àkuhunukulidile mambo lambelatenda mmaduva ulola laîda. ");
INSERT INTO kde_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Pàmbekuva na vyaka saba vya indimbu ya vilyo nchilambo chammalele cha ku Misili. ");
INSERT INTO kde_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Henga bada ya anepo, vìmbekwida vyaka vinji saba vya indala, mpaka aneyo indimbu ìmbeluvalika mwalehu. Indala aneyo ìmbechondonganga chilambo achino. ");
INSERT INTO kde_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Indimbu aneyo ìmbeluvalika mwalehu ing'anya indala imbekwîda ìmbeyoha namene. ");
INSERT INTO kde_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Indoto yako íliuyidile myanda mivili kwa mifano ilandâna kumaiha kuva, Nnungu ànikudungila, na àmbetenda chinu anecho mmaduva ulola. ");
INSERT INTO kde_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Bahi vino wako nfalume, ùlembelewa untandole munu avêle na ding'ano na lúnda uchinga un'juhe kuva nkwímilila wa chilambo chammalele cha ku Misili. ");
INSERT INTO kde_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Uchocho, ùlembelewa uvatandole vakwímilila nchilambo achino koka uvalaije valapole asilimiya ishilini ya vilyo vyammalele vya Misili muvyaka avino saba ya indimbu ya vilyo. ");
INSERT INTO kde_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Uvalaije vakwímilila anevo valapole vilyo anevyo vyammalele muvyaka saba viîda vya indimbu ya vilyo. Na vavichunge vilyo anevyo n'dimanga dyammalele kwa amuli yako nfalume uchinga vanu va dimanga anedyo vààve na akiba ya vilyo. ");
INSERT INTO kde_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Vilyo anevyo vìmbekuva akiba kwajili ya chilambo cha Misili uchinga chinaondongwe ing'anya ya myaka saba iîda ya indala.” ");
INSERT INTO kde_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ushauli anewo wauhumije Yusufu nkwonekana kuva wambone muyo mwanga Falao na kwa maafisa vake vammalele. ");
INSERT INTO kde_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Bahi Falao nkuvauja maafisa vake kuchidoni, “Ayu munu àvele na Umumu wa Nnungu. Dachi, tuchituhulule kumpata munu yunji malinga ayu?” ");
INSERT INTO kde_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Anepo Falao nkunnyaulila Yusufu kuchidoni, “Kwa kuva, Nnungu ànikuhunukulila mambo alano lammalele, nanga munu yunji avêle na ding'ano na lúnda muchi wako. ");
INSERT INTO kde_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Wako njo umbechiimilila chilambo changu, na vanu vangu vammalele vàmbekuva mumamulaka lako. Nangu weka njo nkulu ukupunda wako, kwa kuva nangu njo nfalume. ");
INSERT INTO kde_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Bahi vino nìkutandola kuva nkulungwa wa chilambo chammalele cha Misili!” ");
INSERT INTO kde_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Anepo Falao nkuula pete yake ivêle na muhuli wake nkummwaja Yusufu. Nkummwaja na dinguwo dya kung'anyima namene na nkufu wa zahabu pang'ulo. ");
INSERT INTO kde_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Falao nkunkweja Yusufu munkokoteni uutângwa na falasi ukatapajîjwe kwajili ya kuikala munu wa nafasi yavili muufalume wake, na valinzi nkulongolela muyo mwanga Yusufu uvanonoha lidi uvachidoni, “Tindivalanga malundi!” Bahi namuna aneyo njo Falao champele Yusufu mamulaka makulu nchilambo chammalele cha Misili. ");
INSERT INTO kde_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Pamo na anelo, Falao nkunnyaulila Yusufu kuchidoni, “Nangu njo nfalume wa Misili! Ngùhaula kuva, munu woheyo wa nchilambo chammalele cha Misili anatende chinu chohecho bila luhusa lwako.” ");
INSERT INTO kde_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Falao nkumwing'a Yusufu lina lya Chimisili, Safenasi-Panea. Uchocho, nkumwing'a Yusufu mwali wanga Potifela, uvanchema Asenasi uchinga ààve n'jawe. Potifela ávele kuhani wa milungu yao wa imanga ya Oni. Bahi Yusufu nkutandilika kuongela chilambo chammalele cha ku Misili. ");
INSERT INTO kde_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yusufu ávele na vyaka salasini patandilike kuntumikila Falao, nfalume wa ku Misili. Yusufu nkuuka paing'ande ya nfalume, nkwonga nchilambo chammalele cha Misili. ");
INSERT INTO kde_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Na muvyaka avila saba vya indimbu ya vilyo, mawelu la ku Misili nkuva na vilyo vyohe namene. ");
INSERT INTO kde_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Bahi Yusufu nkulapola vilyo anevyo vyammalele, nkuvikondya n'dimanga dya ku Misili. N'dimanga dyammalele nkukondya akiba ya vilyo vichihaloka mmawelu lavêle pepi na dimanga anedyo. ");
INSERT INTO kde_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yusufu nkukondya akiba ya vilyo vyohe namene. Na vilyo anevyo vyavele vyohe namene muchi ulongo wa kubahali, nkuleka kuvalanga kwa kuva vikáchivalangika. ");
INSERT INTO kde_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Kabla vikànambitandilika vyaka saba vya indala, Yusufu ávele na vana vavili vanammelekedile Asenasi n'jawe, mwali wanga Potifela kuhani wa imanga ya Oni. ");
INSERT INTO kde_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yusufu nkunchema mwanawe wachilume, chihungula mikova lina lyake Manase wachidoni, “Nnungu àngutendile nguluvalile ibaniki yangu yammalele na nivaluvalile vanu vammalele va muing'ande ya atatangu.” ");
INSERT INTO kde_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Mwanawe wavili wachilume nkunchema lina Efulaimu wachidoni, “Nnungu àning'ile vana nchilambo cha ibaniki yangu.” ");
INSERT INTO kde_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Aila myaka saba ya indimbu ya vilyo nchilambo cha Misili nkupita. ");
INSERT INTO kde_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Nkutandilika myaka saba ya indala malinga chanahawile Yusufu anepo patandi. Vilambo vyammalele nkuva na indala, henga chilambo chammalele cha ku Misili chívele na vilyo. ");
INSERT INTO kde_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Vanu vammalele va nchilambo chammalele cha ku Misili pavatandilike kuyona indala, nkunkutila Falao aveng'e vilyo. Nang'e nkuvahaulila Vamisili vammalele kuchidoni, “Hweneng'ana kwanga Yusufu, koka mutende achila chambennyaulilanga.” ");
INSERT INTO kde_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Kwa kuva indala ívele ing'ali na íniyanjala nchilambo chammalele, bahi Yusufu nkuchimula magala lammalele, nkuvasumisa Vamisili vilyo. ");
INSERT INTO kde_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Pamo na anelo, vanu kuhaloka kila pachinu pachilambo chammalele nkwida ku Misili kwanga Yusufu unasuma vilyo, ing'anya indala íniyoha namene pachilambo chammalele. ");
INSERT INTO kde_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Isilaeli, yani Yakobo papilikene kuva aneko ku Misili kùvele vilyo, nkuvahaulila vana vake kuchidoni, “Mwadachi mùikalenge chihi apano umulolana? ");
INSERT INTO kde_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Nangu ngùpilikene kuva, aneko ku Misili kùvele vilyo. Hweneng'ana aneko mukasume vilyo, uchinga tunahwe na indala.” ");
INSERT INTO kde_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Bahi avala akuluvake Yusufu kumi, nkuhwena aneko ku Misili unasuma vilyo. ");
INSERT INTO kde_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Henga Yakobo nanga panannekile Benjamini, nnung'une Yusufu alangane navo, kwa kuva áyopa lanankoja mambo mabaya. ");
INSERT INTO kde_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Bahi vana vanga Isilaeli nkuhwika ku Misili na nkuva kati ya vanu avala vapîte ku Misili unasuma vilyo, kwa kuva ata chilambo cha ku Kanaani nachinang'o chívele na indala. ");
INSERT INTO kde_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Mahiku anelo Yusufu njo anavele nkulu wa chilambo anecho cha ku Misili. Na nang'e njo achivasumisa vanu vilyo. Bahi akuluvake nkuhwena unanhunamila Yusufu kwa eshima mpaka pahi. ");
INSERT INTO kde_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yusufu pavawene akuluvake nkuvamala, henga nkulitenda muchi akávamaite, nkulonjela navo kwa kukalipa. Nkuvauja kuchidoni, “Mwenu mùhaloka kwachi?” Vanang'o nkunnyang'ula kuchidoni, “Hwetu tùhaleke nchilambo cha ku Kanaani, tùidile unasuma vilyo.” ");
INSERT INTO kde_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Pamo na kuva Yusufu ánivamala akuluvake, henga vanang'o nanga pavanammaite. ");
INSERT INTO kde_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Nkuhimukila dindoto dyake dya tangu kwamba akuluvake, nkuvahaulila kuchidoni, “Mwenu mmapelelesi. Mùidile unapelelesa nchilambo chetu uchinga mupate kumala idabadangi yetu.” ");
INSERT INTO kde_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Vanang'o nkunnyang'ula kuchidoni, “Nanga nang'olo wetu. Hwetu tuvatumishi vako tùidile unasuma vilyo. ");
INSERT INTO kde_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Hwetu tuvammalele nni tuvana tùva atata yumo. Hwetu nni tuvanu tùvá kukulupika, akee tuvapelelesi.” ");
INSERT INTO kde_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Henga Yusufu nkuhimya wachidoni, “Nanga! Mwenu mùidile unapelelesa nchilambo chetu uchinga mupate kumala idabadangi yetu.” ");
INSERT INTO kde_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Henga vanang'o nkunnyang'ula kuchidoni, “Hwetu tuvatumishi vako, túvele tuvana kumi na mbili tùvá atata yumo, mwenedi wa chilambo cha ku Kanaani. Nnung'unwetu àisalidile kukaya na atata wetu, na nnung'unwetu yunji ànihila.” ");
INSERT INTO kde_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Henga Yusufu nkuvahaulila kuchidoni, “Nni uchocho chinguhawile kuva mwenu nni mmapelelesi. ");
INSERT INTO kde_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Uvila njo chimumbelingwa. Nangu mbènkwapila kwanga Falao kuva, apano nanga pamumbeuka mpaka pambeida nnung'unwenu. ");
INSERT INTO kde_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Nnaije munu yumo mmwenu akantwale aneyo nnung'unwenu akuno mmanji mutaìjwè nnilungu. Anepo njo paumbemaikana uhiu wa malove lenu. Na akànaide na nnung'unwenu, bahi ngwàpila kwanga Falao kuva, muhiu mwenu mmapelelesi.” ");
INSERT INTO kde_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Bahi nkuvataya vammalele nnilungu kwa maduva matatu. ");
INSERT INTO kde_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Liduva lya tatu Yusufu nkuvahaulila kuchidoni, “Bahi tendanga uvila uchinga mupate kulama, kwa kuva nangu namweshimu Nnungu. ");
INSERT INTO kde_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ikàva muhiu mwenu ni mmanu mukulupika, bahi yumo mmwenu àisalile nnilungu, na mwenu mmanji muvapelekejije vilyo alangavenu vavêle na indala, ");
INSERT INTO kde_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","koka mukahaloke na nnung'unwenu n'joko apano. Anelyo njo limbemaîha uhiu wa malove lenu, na mwenu mukambewalalwa.” Bahi vanang'o nkukubali kutenda uchocho. ");
INSERT INTO kde_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Vanang'o nkuva uvahaulanila vene kwa vene kwa luga yavo uvachidoni, “Muhiu hwetu twaninkosela nnung'unwetu. Ikànava twanimwona chanavele na uchungu pachitupembeja tuupohe umi wake, henga hwetu nanga patunampilikanidile. Aneyo njo ing'anya ya ibaniki aino ituipata vino.” ");
INSERT INTO kde_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Lubeni nkuvahaulila kuchidoni, “Dachi, nangu tenda ńninnyaulilanga kuva tunantendele mabaya nnung'unwetu? Henga mwenu nanga pamunangupilikanidile! Hambi tùvenkwasibiwa ing'anya ya kuhwa kwake.” ");
INSERT INTO kde_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Vanang'o nanga pavanamaite kuva àlalá lavachitangola Yusufu ánalapilikana, kwa kuva álonjela navo kwa indila ya nkalimani. ");
INSERT INTO kde_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yusufu nkuhwena kunyenje, nkutandilika ukuta. Panyalele, nkuuya unalonjela navo kavila. Yusufu nkulaija Simeoni akamulwe na kuhungwa mididi akuno anung'unuvake uvalola. ");
INSERT INTO kde_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yusufu nkuvalaija vatumishi vake vavataile vilyo mmagunila lao na kila munu vammuihije madini lake la dihela nnigunila lyake, na vaveng'e chakulya cha nndila. Vanang'o nkuvatendela muchi chalaijije. ");
INSERT INTO kde_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Bahi avala akuluvake nkuvanyakuja punda vao misigo yavo ya vilyo, nkuuka. ");
INSERT INTO kde_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Pavanavele nndila, nkuhwika pachinu pakulala, munu yumo muanevo nkuhungula ligunila lyake uchinga annihe punda wake chakulya, nkukangana namene palawene madini lake la dihela pannima ligunila lyake. ");
INSERT INTO kde_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Nkuvahaulila anung'unuvake kuchidoni, “Madini langu la dihela vàninguuyihija. Alano apano pannima ligunila lyangu!” Pavapilikene anelo, mitima yao nkutenguka. Nkulolana akuno uvatetemela, nkuujana kuchidoni, “Chinu ntwani achino chatutendeledile Nnungu?” ");
INSERT INTO kde_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Pavahwikile nchilambo cha ku Kanaani kwa Yakobo atatawao, vanang'o nkunnyaulila lammalele lavakojîje uvachidoni, ");
INSERT INTO kde_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Nkulungwa wa chilambo achila átangola na hwetu kwa kukalipa, na kutwona hwetu kuva tuvapelelesi nchilambo chake. ");
INSERT INTO kde_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Henga hwetu nkunnyaulila kuva, hwetu ni tuvanu tuvakukulupika, na wala akee tuvapelelesi. ");
INSERT INTO kde_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Hwetu nkunnyaulila kuva, hwetu twavele tuvana kumi na mbili tùvá atata yumo, na kuva, nnung'unwetu ànihila na nnung'unwetu wa chihwangwa àvele kukaya, nchilambo cha ku Kanaani pamo na atata wetu. ");
INSERT INTO kde_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Anepo ayula nkulungwa wa chilambo achila nkutuhaulila kuchidoni, ‘Uvila njo chinimbemala kuva muhiu mwenu ni mmanu mukulupika. Nneke apano munu yumo mmwenu, koka mwenu mupelekeje vilyo kwa alangavenu vavêle na indala. ");
INSERT INTO kde_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Bahi pamumbeuya aneko mulangane na nnung'unwenu wa chihwangwa, na anepo njo panimbemala kuva mwenu mukee mmapelelesi ila ni mmanu mukulupîka. Mukàtenda uchocho, nangu nguchininchimulile nnilungu nkulwenu, na muchimuluhusiwe kusuma na kusumisa nchilambo achino.’ ” ");
INSERT INTO kde_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Pavachikuchula vilyo mmagunila lao, nkukangana pavawene kila munu vammuihijìjè chihwitiki chake cha madini la dihela nnigunila lyake. Pavalawene anelo, vammalele pamo na atata wao nkuyopa. ");
INSERT INTO kde_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Yakobo atata wao nkuvahaulila kuchidoni, “Mwenu mùngupakanywele vana vangu! Yusufu akapali, na Simeoni akapali, na vino mùlembela muntwale na Benjamini. Anelo lammalele làngukoja chihi unene!” ");
INSERT INTO kde_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Anepo Lubeni nkunnyaulila atatake kuchidoni, “Nikànauye na Benjamini, bahi vawalale anavangu vavili. Nneke Benjamini mmakono langu, nanangu nguchininchunge na kuuya nawe apano.” ");
INSERT INTO kde_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Henga atatake nkunnyang'ula kuchidoni, “Mwanangu nanga pambelangana na mwenu. Nkuluwe ànihila, nang'e weka njo aisalidîle. Na nangu vino nni nsele nguvêle na dihulisi. Na lakànkoja mambo mabaya mmwanda umuhwena, nguchinguhwe na lihindambi.” ");
INSERT INTO kde_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Bahi indala nkuhalija kuva ing'ali nchilambo cha ku Kanaani. ");
INSERT INTO kde_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Pavihidile avila vilyo vivanasumile ku Misili, Isilaeli, yani Yakobo nkuvahaulila vana vake kuchidoni, “Hweneng'ana kavila ku Misili mukasume vilyo vinji.” ");
INSERT INTO kde_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Henga Yuda nkunnyaulila atatake kuchidoni, “Ayula munu ánituhimya wachidoni, ‘Mukànaide na nnung'unwenu, nangu nanga pamumbengwona, wala kadiki.’ ");
INSERT INTO kde_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Wako ukàkubali nnung'unwetu kulongana na hwetu, bahi tuchituhwene tukasume vilyo. ");
INSERT INTO kde_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Henga ukànannuhusu kulongana na hwetu, bahi hwetu nanga patumbehwena unasuma vilyo, kwa kuva ayula munu átuhaulidile kuva, ‘Mukànaide na nnung'unwenu, nangu nanga pamumbengwona, wala kadiki.’ ” ");
INSERT INTO kde_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Isilaeli nkuuja kuchidoni, “Mwadachi mùngupelekejijije ibaniki kwa kunnyaulila aneyo munu kuva mùvele na nnung'unwenu yunji?” ");
INSERT INTO kde_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Nkunnyang'ula kuchidoni, “Ayula munu ànituujiha namene kwamba habali dyetu na alangavetu wachidoni, ‘Dachi, atata wenu àvechinkulama? Dachi, muniva na nnung'unwenu yunji?’ Na hwetu nkunnyang'ula kupapatana na chatuujije. Hwetu túmbemala dachi kuva achiatuhaulile tuhwene na nnung'unwenu?” ");
INSERT INTO kde_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Bahi Yuda nkunnyaulila Isilaeli atatake kuchidoni, “Nnuhusu alongane na nangu uchinga tuuke uvino tuhwene tukasume vilyo ili hwetu na wako na vana vetu tunahwe na indala. ");
INSERT INTO kde_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Nangu nguchinilivikile nimwene poni kwakuwe. Wako uchiungudai nangu. Na nikànammuihe umwone kwa meho lako, likosa anelyo lììve lyang'une maisha langu lammalele. ");
INSERT INTO kde_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Kwikavele tukatima uvila, tukavele tupite myanda mivili vino.” ");
INSERT INTO kde_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Anepo Isilaeli atata wao nkuvahaulila kuchidoni, “Ikàva ni lasima ììve uchocho, bahi tendanga uvila, tayanga mmagunila lenu dinujo dya vitukutuku vyambone namene vya nchilambo chetu koka mumpelekejije aneyo nkulu. Nnyakulile uchi kadiki na ubani kadiki na manemane na vitukutuku vinji vya kunung'ila na vilyo vya samani, malinga kungumanga na lozi. ");
INSERT INTO kde_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Uchocho, mpelekejije na madini lanji la dihela, myanda mivili ya àlalá matandi lavanammikidile mmagunila lenu, kwa kuva lasima muuihe, panjika láuihijwe kwa makosa. ");
INSERT INTO kde_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ntwalange na nnung'unwenu, muhwene kwa aneyo munu upehi. ");
INSERT INTO kde_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Na Nnungu Avêle Na Dimongo Dyammalele an'jalilange mwenu, aneyo munu ammikilange chididi uchinga anneke Simeoni na Benjamini uchinga vauye pamo na mwenu. Ikàva lasima nangu kuvakoha anavangu, bahi nanga chinu!” ");
INSERT INTO kde_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Bahi nkuditwalanga adila dinudyo na àlalá madini la dihela chalumo na Benjamini, nkuhwena ku Misili. Pavahwikile, nkuhwena unalilanguja kwanga Yusufu. ");
INSERT INTO kde_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yusufu pammwene Benjamini alongènè navo, nkunnyaulila nkwímilila ing'ande yake kuchidoni, “Vapelekeje ava vanu kukaya kwangu, unsinje nnyama yumo na unkatapaje saana, kwa kuva ava vanu vàmbekulya na nangu chakulya cha muhi.” ");
INSERT INTO kde_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ayula nkwímilila nkutenda muchi chalaijijwe. Nkuvapelekeja avala vayeni kukaya kwanga Yusufu. ");
INSERT INTO kde_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Avala vanu pavawene kuva vàpelekwejije kukaya kwanga Yusufu, nkuyopa namene, nkuva uvatangola vene kwa vene kuchidoni, “Tùpelekejijwe akuno ing'anya ya àlalá madini la dihela lavanatuvikidile mmagunila letu patunaidile mwanda ntandi. Àtendile uchocho uchinga apate kutulambilila kuva tùivite madini la dihela, koka atukamule na kututenda kuva tuvatumwa vake na kutupakanyola punda vetu.” ");
INSERT INTO kde_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Bahi nkummwenela ayula nkwímilila wa ing'ande ya Yusufu nkulonjela nawe vavèlè pannango, ");
INSERT INTO kde_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","nkunnyaulila kuchidoni, “Nkulu, mwanda ntandi hwetu twaniida apano unasuma vilyo. ");
INSERT INTO kde_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Patuchiuya kukaya, nkuhwika pachinu pakulala, hwetu nkuhungulanga magunila letu, nkukangana namene patulakojije madini la dihela la kila munu lavèlè chihi uchila nnigunila lyake. Hambi tùnidiuiha dihela anedyo. ");
INSERT INTO kde_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Na tùidile na dihela dinji dya kusumila vilyo, na nanga patummaite munu adivikîle dihela dyetu mmagunila letu.” ");
INSERT INTO kde_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ayula nkwímilila nkuvahaulila kuchidoni, “Munave na lipamba, wala munayope. Muhiu, Nnungu wenu, Nnungu wa atata wenu, njo ammuihijîje mwenu dihela mmagunila lenu. Nangu nanipwachela madini lenu la dihela.” Bahi nang'e nkuvapelekejija Simeoni, nnung'unwao. ");
INSERT INTO kde_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ayula nkwímilila nkuvapelekeja anevo vanu muing'ande yanga Yusufu, nkuveng'a medi la kukalava mmadodo lao, na kuvaliha punda vao. ");
INSERT INTO kde_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Na vanang'o nkwandaa dinudyo dyao dya kumwing'a Yusufu, kwa kuva vánimala kuva vàmbekulya nawe chakulya cha muhi. ");
INSERT INTO kde_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yusufu pakamwele pakaya, vanang'o nkumpelekejija adila dinudyo divananyakwile, nkuhunama mpaka pahi. ");
INSERT INTO kde_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yusufu nkuvasalimila na kuvauja habali dyavo wachidoni, “Mwenu múnguhaulidile habali dya nsele, atata wenu. Achidachi? Dachi, mwomi?” ");
INSERT INTO kde_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Vanang'o nkunnyang'ula kuchidoni, “Ntumishi wako, atata wetu, mwomi, àvele chihi nkwimuka.” Anepo nkuhunama muyo mwake. ");
INSERT INTO kde_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yusufu palolite meho lake muyo nkumwona Benjamini, nnung'une, mwana wa anyokwe, nkuchidoni, “Dachi, ayu njo nnung'unwenu wachihwangwa umunanguhaulidile habali dyake?” Anepo nkuchidoni, “Nnungu akujalile mwanangu!” ");
INSERT INTO kde_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yusufu nkuuka pachinu anepo upehi, ing'anya pammwene nnung'une ntima wake wanimeta ing'anya ya kuntamwa namene. Yusufu nkuinjila kuchumba kwake nkutandilika kukuta. ");
INSERT INTO kde_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Pamalidile ukuta, nkukalava medi kumeho, nkulikamya, nkuhuma, nkulaija chakulya. ");
INSERT INTO kde_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Yusufu nkummikila paweka, na akuluvake navanang'o nkuvavikila paweka. Na Vamisili vanalile pamo na nang'e navanang'o nkuvavikila paweka, kwa kuva Vamisili vàona kuva, kulya chakulya pamo na Vaeblaniya nni najisi. ");
INSERT INTO kde_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Akuluvake Yusufu pavawene vapangwìjè kupapatana na vyaka vyao, kutandikila ntandi mpaka wa chihwangwa, nkulolana akuno uvakangana. ");
INSERT INTO kde_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Chakulya chítwaliwa pameza yanga Yusufu na kupelekejwa kwa akuluvake, henga Benjamini ápewije myanda nnyano kupunda achila chivapewije akuluvake. Bahi nkukumbila na kuhangalala pamo nanang'e. ");
INSERT INTO kde_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Bahi Yusufu nkunnaija ayula nkwímilila ing'ande kuchidoni, “Umbaja vilyo mmagunila la anevo vanu kupapatana na chivahulula kunyakula, koka uvike madini la dihela la kila munu pannima ligunila lyake, ");
INSERT INTO kde_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","na uvike na chikombe changu chikatapajîjwe kwa madini la dihela, nnigunila lya ayula n'joko namene pamo na madini lake la dihela lachichiasumile vilyo lyake.” Bahi ayula nkwímilila nkutenda muchi chalaijijwe na Yusufu. ");
INSERT INTO kde_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Uhiku pauchele, akuluvake Yusufu na nnung'une, nkulekelewa uchinga vahweneng'ane chalumo na punda vao. ");
INSERT INTO kde_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Pavaukile chihi pamanga, kabla vakànambihwika kulehu, Yusufu nkunnaija nkwímilila wa ing'ande yake kuchidoni, “Vapapate avala vanu upehi! Pumbevakoja vauje uvila, ‘Ing'anya ntwani mùtendile lahakalenge akuno mutendewìjè lambone? ");
INSERT INTO kde_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ing'anya ntwani mùivite chikombe changa nkulu wangu chakumbilila na kulaujija? Chimutendile choo, chìnihakalanga.’ ” ");
INSERT INTO kde_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Bahi ayula nkwímilila pavakojije nkuvahaulila malove anelo. ");
INSERT INTO kde_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Henga vanang'o nkummuja kuchidoni, “Nkulu, mwadachi ùtangola malove malinga anelo? Hwetu tuvatumishi vako, tukáhulula kutenda chinu malinga anecho! ");
INSERT INTO kde_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Madini àlalá la dihela latunalakojije mmagunila letu tùnilauiha kuhaloka nchilambo cha ku Kanaani. Ìmbehululika dachi tuive madini la dihela au zahabu muing'ande ya nkulu wako? ");
INSERT INTO kde_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Bahi chikombe anecho chikàonekana kwa munu yumo muhwetu, bahi awalalwe, na hwetu tuvanji tuvammalele tuchituve tuvatumwa vako.” ");
INSERT INTO kde_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ayula nkwímilila nkuchidoni, “Sawa, ììve uchocho muchi chimuhawile. Munu woheyo ambekôjwa na chikombe anecho àmbekuva ntumwa wangu, henga mwenu mmanji mukambekuva na likosa.” ");
INSERT INTO kde_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Bahi kila munu nkupiyanya kusulupuha ligunila lyake pahi na kulihungula. ");
INSERT INTO kde_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ayula nkwímilila nkukusumbulanga magunila lammalele. Átandilike ligunila lya nkulungwa wao, nkumalilila lya n'joko wao. Na anecho chikombe nkwonekana nnigunila lyanga Benjamini. ");
INSERT INTO kde_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Bahi ing'anya ya anelyo, anevo vanu nkupapulanga dinguwo dyavo kwa kuhinginika. Kila munu nkunnyakuha punda wake nsigo wake, nkuuyang'ana kumanga. ");
INSERT INTO kde_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yuda pamo na anung'unuvake nkuhwika kuing'ande yanga Yusufu, na Yusufu ávele chihi pakaya. Bahi vammalele nkulimatohija pahi kwa kulisulupuha namene muyo mwake. ");
INSERT INTO kde_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yusufu nkuvauja kuchidoni, “Ing'anya ntwani mùtendile uchocho? Dachi, mwenu mukámaite kuva munu malinga nangu anahulula kumala mambo kwa kulauja?” ");
INSERT INTO kde_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda nkunnyang'ula kuchidoni, “Tukuhaulile chamani nkulu? Tùmbetangola chamani kulanguja kuva tukávele na makosa? Nnungu àvenkutuasibu ing'anya ya makosa letu. Hambi hwetu tuvammalele nni tuvatumwa vako, hwetu pamo na ayula akojîjwe na chikombe chako.” ");
INSERT INTO kde_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Henga Yusufu nkuchidoni, “Nanga! Nangu nikambetenda uchocho! Ayula akojîjwe na chikombe changu njo ambekûva ntumwa wangu. Mwenu mmanji mmammalele uyang'ana chihi kwa amani kwa atata wenu.” ");
INSERT INTO kde_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Bahi Yuda nkunnyengelekela Yusufu, nkunnyaulila kuchidoni, “Chonde nkulu wangu, wako ùvele na mamulaka muchi mwene Falao, na nangu nintumishi wako chihi. Chonde ngùyuwa unanguvisije, henga unguluhusu ngutangole kadiki muyo mwako. ");
INSERT INTO kde_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Nkulu, wako wanituuja ikàva tùvele na atata au anung'unuvetu vanji. ");
INSERT INTO kde_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Hwetu nkukuyang'ula kuva tùvele na atata, na ànikongopala namene, na kuva, tùvele na nnung'unwetu yunji n'joko wammeleke atata wetu muusele wake. Na nkuluwe aneyo nnung'unwetu ànihila, na ayula wachihwangwa njo mwana aisalidîle nnitumbo lya anyokwe, na atata wetu ànantamwa namene. ");
INSERT INTO kde_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Nkulu, wako únitulaija hwetu tuvatumishi vako twide na nnung'unwetu uchinga upate kumwona. ");
INSERT INTO kde_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Na hwetu nkukuhaulila kuva, aneyo kijana nanga pahulula kulekana na atatake, kwa kuva akànneka chihi atatake, atata wetu achiahwe. ");
INSERT INTO kde_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Henga wako nkulu nkutuhaulila kuva, ‘Mukànaide na nnung'unwenu mukambengwona, wala kadiki.’ ");
INSERT INTO kde_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Patuuite kukaya kwa atata wetu, ntumishi wako, hwetu nkunnyaulila muchi chutulaijije. ");
INSERT INTO kde_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Na nang'e patuhaulidile kuva twide kavila akuno unasuma vilyo, ");
INSERT INTO kde_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","hwetu nkunnyaulila kuchidoni, ‘Hwetu tukambehwena mpaka nnung'unwetu alongane na hwetu. Akànalongane na hwetu, ayula munu tukambemwona, wala kadiki.’ ");
INSERT INTO kde_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Bahi atata wetu, ntumishi wako, nkutuhaulila kuchidoni, ‘Mwenu mùnimala kuva n'jangu Laheli ánguvelekedile chihi vana vavili vachilume. ");
INSERT INTO kde_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Yumo ániyahika, na nangu nkwona kuva muhiu ànihalangwa vipande-vipande na nnyama wa kuyoha, kwa kuva nikánamwona kavila. ");
INSERT INTO kde_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Na mukàntwala na ayu, koka nkunkoja mambo mabaya mmwanda umuhwena, nguchinguhwe na lihindambi.’ ");
INSERT INTO kde_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Bahi nkulu, nangu nikambehulula kuuya kwa atatangu, ntumishi wako, bila ayu kijana. Umi wa atata ùlisingila umi wa ayu kijana, ");
INSERT INTO kde_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","na pambekwona tukàlongene nawe, achiahwe! Na ikàva uchocho, hwetu tuvatumishi vako, ìmbekuva tùmmwalele atata wetu kwa lihindambi. ");
INSERT INTO kde_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Pamo na anelo, nangu ngúlivikidile nimwene poni kwa atatangu ya kunchunga ayu kijana unguchidoni, ‘Nikànauye nawe Benjamini kwakuwe, likosa anelyo lììve lyang'une maisha langu lammalele!’ ");
INSERT INTO kde_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Hambi nkulu, ngùyuwa nangu nintumishi wako, ngwisalile apano ngùùve ntumwa wako badala ya ayu kijana. Nneke ayu kijana auye kukaya pamo na akuluvake. ");
INSERT INTO kde_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Nangu nìmbehulula dachi kuuya kwa atatangu bila ayu kijana? Nangu nikambehulula kupililila kuyona ibaniki yambebanika atatangu.” ");
INSERT INTO kde_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Anepo Yusufu nanga panahulwile kulikamulanga muyo mwa vatumishi vake vammalele vanavele pamo na nang'e, nkunonoha lidi wavahaulila vatumishi anevo kuchidoni, “Mmanu mmammalele humananga pawelu!” Pavahumanenge pawelu, nanga munu woheyo anapwawije nng'ande uhiku aula wachilitambuliha Yusufu kwa akuluvake. ");
INSERT INTO kde_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Yusufu nkunonoha lidi wakuta, na Vamisili vánimpilikana pachikuta. Na vanu va mwing'ande yanga Falao navanang'o vánipilikana habali anedyo. ");
INSERT INTO kde_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yusufu nkuvahaulila akuluvake kuchidoni, “Nangu njo Yusufu! Dachi, atatangu àvele chihi nkulama?” Henga akuluvake nkuhemwa namene kumwona Yusufu muyo mwavo, mpaka nanga pavanahulwile kuyang'ula. ");
INSERT INTO kde_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yusufu nkuvahaulila akuluvake kuchidoni, “Chonde, hengelekela pepi na nangu.” Pavahengelekedile, nkuvahaulila kuchidoni, “Nangu njo nnung'unwenu Yusufu, umunansumisije kwa vanu vachihwena ku Misili! ");
INSERT INTO kde_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Henga vino munayuvale na wala munalyambe kwa kungusumisa akuno. Nnungu njo angupelekejîje ninnongolelange mwenu uchinga nguupohe umi wa vanu. ");
INSERT INTO kde_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Achino nni chaka chihi chavili cha indala nchilambo, henga pàvele vyaka vinji nnyano viîda, vanu vakambehulula kulima wala kufuna. ");
INSERT INTO kde_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Nnungu áningulongoleja akuno uchinga kwa namuna ikee ya kawaida ngupate kulapoha maisha lenu na maisha la vanu va n'ding'olo dyetu, na kuvatenda vanu vohe namene vanahwe na indala. ");
INSERT INTO kde_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Bahi akee mwenu mungupelekejîje akuno, ila nni Nnungu. Nang'e njo angutendîle nangu kuva nkúhumya ding'ano kwanga Falao, nkwímilila wa ing'ande yake yammalele na ntawala wa chilambo chammalele cha Misili. ");
INSERT INTO kde_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Bahi tendanga upehi muhwene kwa atatangu mukannyaulile kuva, ‘Yusufu, mwanalo, àhaula kuchidoni, “Nnungu àngutendile kuva nkulu wa chilambo chammalele cha ku Misili. Hambi, unatime kwida kwang'une. ");
INSERT INTO kde_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Paumbekwida akuno, wako chalumo na vana vako na adukulu vako na makuwa lako la dingandolo na dimbudi na ding'ombe na vyammalele vyuvenavyo, muchimuikale eneo lya Gosheni, pepi na nangu. ");
INSERT INTO kde_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Paumbekuva ku Gosheni, nangu nguchinikuchunge wako na vanu va nng'ande mwako chalumo na anyama vako uchinga munahwe na indala, kwa kuva pàvele vyaka vinji nnyano vya indala vivenkwîda.’ ” ");
INSERT INTO kde_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Yusufu nkuvahaulila akuluvake kuchidoni, “Mwenu mmene mùningwona kwa meho lenu na ata nnung'unwangu Benjamini nanang'e àningwona kwa meho lake kuva, nangu njo nimwene Yusufu ngulonjêla na mwenu. ");
INSERT INTO kde_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Mùlembelewa mukannyaulile atatangu kwamba ukulu wammalele ungupewije akuno ku Misili, na kwamba kila chinu chimuchiwene. Bahi tendanga upehi muide na atatangu akuno.” ");
INSERT INTO kde_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Bahi Yusufu nkunkumbatila Benjamini nnung'une, nkukuta. Benjamini nanang'e nkukuta, akuno vakumbatilènè na nkuluwe. ");
INSERT INTO kde_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Yusufu panavenkukuta, nkuvakumbatila akuluvake na kuvabusu. Anepo njo akuluvake pavahulwile kutangola nawe. ");
INSERT INTO kde_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Bahi anedyo habali padihwikile kuing'ande yanga Falao, kuva akuluvake Yusufu vànikamola, Falao pamo na maafisa vake nkuhangalala namene. ");
INSERT INTO kde_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Bahi Falao nkunnyaulila Yusufu kuchidoni, “Vahaulile akuluvako vavanyakuje punda misigo yavo, vauye nchilambo cha ku Kanaani, ");
INSERT INTO kde_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","vaide na atatawao na alangavao vammalele apano. Nangu nguchiniveng'e eneo lyambone namene lya chilambo achino cha Misili, na aneko vachivahangalalile vilyo vyammalele vyambone namene vya chilambo achino. ");
INSERT INTO kde_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Uchocho, pavambeuka vahaulile vanyakule na mikokoteni ya kuutangwa uchinga vakavapakile vana vao na ajavao na atatawao, koka vaide navo apano. ");
INSERT INTO kde_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Vahaulile vanalipwalele kudileka dimali dyavo ukoko, kwa kuva, eneo lyambone kupunda lammalele nchilambo cha Misili lìmbekuva lyavo.” ");
INSERT INTO kde_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Bahi vana vanga Isilaeli nkutenda muchi chivalaijijwe. Yusufu nkuveng'a mikokoteni kupapatana na chalaijije Falao, na nkuveng'a na chakulya cha nndila. ");
INSERT INTO kde_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Kila munu nkumwing'a dinguwo dyahambi, henga Benjamini nkumwing'a vipande myatatu vya madini la dihela na dinguwo nnyano. ");
INSERT INTO kde_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Na dimali dyanahumije Yusufu kumwing'a atatake nni adino, punda kumi vananyakwile vitukutuku vyambone vya ku Misili, na punda kumi makolo vananyakwile ngano na mikate na vyakulya vinji vya mmwanda wa kuida ku Misili. ");
INSERT INTO kde_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Bahi Yusufu nkulailana na akuluvake. Na pavachiuka nkuvaduma wachidoni, “Munapwatane nndila!” ");
INSERT INTO kde_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Bahi nkuukananga pa Misili, nkuuya kukaya kwa atatawao Yakobo, nchilambo cha ku Kanaani. ");
INSERT INTO kde_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Nkunnyaulila atatawao kuchidoni, “Yusufu mwomi! Nang'e njo ntawala wa chilambo chammalele cha ku Misili!” Anepo atatawao nkuhemwa, kwa kuva nanga panalakulupidile malove lavo. ");
INSERT INTO kde_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Henga pavansimulidile lammalele lavalaijijwe na Yusufu, na payonite mikokoteni yampelekejijije Yusufu kwajili ya kunnyakula, ntima wake nkuhangalala namene . ");
INSERT INTO kde_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Bahi Isilaeli nkuhaula kuchidoni, “Vino nankulupilanga! Muhiu mwanangu Yusufu mwomi! Nìmbehwena nikamwone kabla nikànambikuhwa.” ");
INSERT INTO kde_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Bahi Isilaeli nkutandilika mwanda akuno anyakwìlè dimali dyake dyammalele. Pahwikile ku Beli-Sheba, nkunhumija sadaka Nnungu wa Isaka, atatake. ");
INSERT INTO kde_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Chilo uchila, Nnungu nkulonjela na Isilaeli muindoto, nkuchema wachidoni, “Yakobo! Yakobo!” Yakobo nkuyambukila, “Nangu apano!” ");
INSERT INTO kde_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Nnungu nkunnyaulila kuchidoni, “Nangu ni Nnungu, Nnungu wa atatako. Unayope kuhwena ku Misili. Paumbekuva aneko, nangu nìmbevatenda vanu va nnukolo lwako kuva chilambo chikulungwa. ");
INSERT INTO kde_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Nangu nimwene nguchinguhwene pamo na wako aneko ku Misili, na kukuuiha akuno. Na paumbehila, mwanalo Yusufu àmbekuva upopo na nkono wake njo umbekuhunîka meho lako.” ");
INSERT INTO kde_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Bahi Yakobo nkuuka ku Beli-Sheba. Vana vake nkunnyakula atatawao na vana vao na ajavao mmikokoteni yanahumije Falao uchinga vakannyakule Yakobo. ");
INSERT INTO kde_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Uchocho, vávanyakulenge anyama vao na dimali dyammalele divanapete nchilambo cha ku Kanaani, nkuhweneng'ana ku Misili, Yakobo chalumo na vanu vammalele va nnukolo lwake, ");
INSERT INTO kde_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","vana vake na adukulu vake, vammalele nkuhwena navo ku Misili. ");
INSERT INTO kde_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Alano njo malina la vanu va nnukolo lwanga Isilaeli, yani Yakobo vanapite ku Misili pamo nanang'e. Lubeni, mwanawe ntandi kuvelekwa wachilume, ");
INSERT INTO kde_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","pamo na vana vake vachilume, yani Hanoki na Palu na Heziloni nawi Kalimi. ");
INSERT INTO kde_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeoni pamo na vana vake vachilume, yani Yemueli na Yamini na Ohadi na Yakini na Sohali na Shauli, anavelekwejije na mmahe Nkanaani. ");
INSERT INTO kde_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lawi pamo na vana vake vachilume, yani Gelishoni na Kohasi na Melali. ");
INSERT INTO kde_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yuda pamo na vana vake vachilume, yani Eli na Onani na Shela na Pelesi na Zela. (Henga Eli na Onani váhilidile kuchilambo cha ku Kanaani). Na vana vanga Pelesi nni Heziloni na Hamuli. ");
INSERT INTO kde_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakali pamo na vana vake vachilume, yani Tola na Puva na Yashubu na Shimiloni. ");
INSERT INTO kde_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zabuloni pamo na vana vake vachilume, yani Seledi na Eloni na Yaleli. ");
INSERT INTO kde_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Anevo njo vana vachilume vanga Leya vanammelekedile Yakobo aneko ku Padani-Alamu, pamo na Dina mwali wake. Na jumula ya vana vake vachilume na vachikongwe na adukuluvake vávele salasini na tatu. ");
INSERT INTO kde_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gadi pamo na vana vake vachilume, yani Sefoni na Hagi na Shuni na Eziboni na Eli na Alodi na Aleli. ");
INSERT INTO kde_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asheli pamo na vana vake vachilume, yani Imna na Ishiva na Ishivi na Beliya na Sela, nnumbwao. Na vana vanga Beliya nni Hebeli na Malukieli. ");
INSERT INTO kde_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Anevo njo vana na adukuluvake Zilipa, vana vanammelekedile Yakobo. Zilipa ávele ntumishi wanga Leya wananhumije Labani kumwing'a Leya, mwali wake. Na jumula ya anevo vanu ívele kumi na sita. ");
INSERT INTO kde_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Na vana vanga Laheli vachilume, n'jawe Yakobo nni Yusufu na Benjamini. ");
INSERT INTO kde_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Na vana vanga Yusufu vachilume vanavelekwejije aneko ku Misili nni, Manase na Efulaimu. Anevo vana, Yusufu ávaveleke na mmahe yumo uvanchema Asenasi mwali wanga Potifela, anavele kuhani wa imanga ya Oni. ");
INSERT INTO kde_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjamini pamo na vana vake vachilume, yani Bela na Bekeli na Ashibeli na Gela na Naamani na Ehi na Loshi na Mupimu na Hupimu na Alidi. ");
INSERT INTO kde_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Anevo vanu kumi na nne nni vana na adukuluvake Yakobo vammelekedîle Laheli, n'jawe. ");
INSERT INTO kde_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dani pamo na mwanawe wachilume uvanchema Hushimu. ");
INSERT INTO kde_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Nafutali pamo na vana vake vachilume, yani Yaseli na Guni na Yeseli na Shilemu. ");
INSERT INTO kde_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Anevo vanu saba ni vana vake na adukuluvake Yakobo vammelekedîle Biliha, ntumishi wananhumije Labani kumwing'a Laheli, mwali wake. ");
INSERT INTO kde_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Jumula ya vana na adukuluvake Yakobo vanapite navo ku Misili, bila kuvavalangila amahe va anavake, yavele vanu sitini na sita. ");
INSERT INTO kde_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Na aneko ku Misili Yusufu ávaveleke vana vavili. Bahi pamo na vana vavili vavaveleke Yusufu aneko ku Misili, jumula ya vanu va nnukolo lwanga Yakobo vanainjidile nchilambo cha Misili vávele vanu sabini. ");
INSERT INTO kde_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Bahi Yakobo nkuntuma Yuda ahwene kwanga Yusufu uchinga akannyuwe vakojane aneko ku Gosheni. Pavahwikile kueneo lya ku Gosheni, ");
INSERT INTO kde_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusufu nkukwela munkokoteni wake uutângwa na falasi, nkuhwena unampwechela Isilaeli atatake, aneko ku Gosheni. Pammwikidile atatake, nkunkumbatila, nkukuta kwa uhiku nnehu. ");
INSERT INTO kde_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Isilaeli nkunnyaulila Yusufu kuchidoni, “Ata kunguhwa vino, wala nanga chinu kwa kuva ǹnikwona na kumala kuva umwomi!” ");
INSERT INTO kde_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yusufu nkuvahaulila akuluvake na vanu vammalele va nng'ande mwa atatake kuchidoni, “Nangu ngùhwena unannyaulila Falao kuchidoni, ‘Akuluvangu na vanu va nng'ande mwa atatangu vanavele nchilambo cha ku Kanaani vàninguidila. ");
INSERT INTO kde_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Vanu anevo nni vachunga, na vàidile na angandolo vao na ambudi vao na dimali dyavo dyammalele.’ ");
INSERT INTO kde_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Bahi nfalume pambenchemanga na kummujanga kuva, ‘Mwenu mùkola madengo ntwani?’ ");
INSERT INTO kde_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","mwenu nnyang'ule kuva, ‘Nkulu, hwetu tuvatumishi vako, hwetu nni tuvachunga kutandikila ujoko wetu mpaka nelo, kwa kuva njo chivanavele anakuluvetu.’ Tangola uchocho uchinga Falao annuhusu mwenu kuikala eneo lya ku Gosheni.” Yusufu átangwele uchocho ing'anya munu woheyo achûnga anyama, Vamisili vàmmalangila kuva najisi.” ");
INSERT INTO kde_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Bahi Yusufu nkuhwena kwanga Falao, nkunnyaulila kuchidoni, “Atatangu na akuluvangu chalumo na angandolo na ambudi na ang'ombe na dimali dyao dyammalele vànikamola kuhaloka chilambo cha ku Kanaani. Na vino vàvele ku Gosheni.” ");
INSERT INTO kde_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Na Yusufu ávatandwele akuluvake nnyano, nkuvavika muyo mwanga Falao. ");
INSERT INTO kde_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Falao nkuvauja kuchidoni, “Mwenu mùkola madengo ntwani?” Vanang'o nkunnyang'ula kuchidoni, “Nkulu, hwetu tuvatumishi vako nni tuvachunga, kwa kuva njo chivanavele anakuluvetu.” ");
INSERT INTO kde_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Anepo nkunnyaulila Falao kuchidoni, “Hwetu tuvatumishi vako tùniida uchinga tuikale kwa uhiku kadiki nchilambo achino kwa kuva, indala ni ing'ali namene aneko ku Kanaani, na wala nanga wahi wa kuvaliha anyama vetu. Hambi nkulu, tùnakuyuwa hwetu tuvatumishi vako utuluhusu kuikala eneo lya ku Gosheni.” ");
INSERT INTO kde_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Falao nkunnyaulila Yusufu kuchidoni, “Atatako na akuluvako vàkwidilidile wako. ");
INSERT INTO kde_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Wako tandola chihi eneo lyohelyo nchilambo achino cha Misili uchinga vaikale. Mwing'e atatako na akuluvako eneo lya Gosheni, eneo lyambone kupunda maeneo lammalele apano pa Misili. Na ikàva ùnivamala vanu vamaîte kuvachunga saana anyama nnikuwa lyao, bahi vatandole vavachunge anyama vangu.” ");
INSERT INTO kde_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Anepo Yusufu nkuhaloka na Yakobo atatake, nkumwimija muyo mwanga Falao, na Yakobo nkum'baliki Falao. ");
INSERT INTO kde_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Falao nkummuja Yakobo kuchidoni, “Ùvele na changa cha vyaka vingapi?” ");
INSERT INTO kde_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakobo nkunnyang'ula kuchidoni, “Changa chingujaliwije mmwanda wangu wakupita pachilambo nni vyaka myamoja salasini. Vyaka anevyo vìjukile kuva vyaka kadiki namene, na nni vyaka viumbêle ibaniki, tena vyaka anevyo vikànambihwikila isabu ya vyaka vya anakuluvangu vanaikele pachilambo muchi vakúpita.” ");
INSERT INTO kde_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Anepo Yakobo nkum'baliki Falao, nkuuka. ");
INSERT INTO kde_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Bahi Yusufu nkumwing'a atatake na akuluvake eneo lya ku Lamesesi, eneo lyambone namene nchilambo cha Misili uchinga vaikale anepo, na vanang'o nkulitwala eneo anelyo malinga chalaijije Falao. ");
INSERT INTO kde_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Na Yusufu nkuva waveng'a chakulya atatake na akuluvake chalumo na vanu va nng'ande mwa atatake kupapatana na isabu ya vana vao. ");
INSERT INTO kde_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Bahi mmahiku anelo vilyo vínihova mwalehu nchilambo chammalele. Indala yavele ing'ali namene mpaka vanu vammalele va ku Misili na ku Kanaani kuyanda namene. ");
INSERT INTO kde_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Bahi Yusufu nkukunganya dihela dyammalele dya nchilambo cha ku Misili na dya nchilambo cha ku Kanaani dinapatikene kuhaloka kwa vanu vachisuma ngano kwa Falao. Yusufu nkudipelekeja dihela anedyo muing'ande yanga Falao. ");
INSERT INTO kde_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Vanu vammalele va chilambo cha ku Misili na chilambo cha ku Kanaani pavamalidile kuditumila dihela dyavo dyammalele, Vamisili vammalele nkummwenela Yusufu nkunnyaulila kuchidoni, “Tumeyele vilyo! Mwadachi tuhwe muyo mwako? Lola, vino dihela dyetu dyammalele dìnimalilika!” ");
INSERT INTO kde_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yusufu nkuvahaulila kuchidoni, “Ikàva dihela dyenu dìnimalilika, bahi ning'e anyama venu koka nanani nimwing'ange vilyo!” ");
INSERT INTO kde_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Bahi anevo vanu nkumpelekejija Yusufu anyama vao, yani falasi na ang'ombe na angandolo na ambudi na punda, na Yusufu nkuveng'a anevo vanu vilyo. Mmwaka anewo wammalele Yusufu nkuva waveng'a vanu vilyo kwa kubadilana na anyama vao vammalele. ");
INSERT INTO kde_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Mwaka upapête nkumwidila kavila Yusufu nkunnyaulila kuchidoni, “Nkulu, muhiu dihela dyetu dyammalele dìnimalilika na anyama vetu vàjukile kuva mali yako. Hambi nkulu, hwetu tuvatumishi vako tukávele na chinu chohecho chakukwing'a, ìisalidile chihi miili yetu na mawelu letu bahi. ");
INSERT INTO kde_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Mwadachi tuhwe muyo mwako na mawelu letu laondongeke? Tusume hwetu pamo na mawelu letu kwa vilyo uchinga tùùve tuvatumwa tùva Falao. Twing'e vilyo uchinga tunahwe, na utwing'e na dimbeyu kwajili ya mawelu letu.” ");
INSERT INTO kde_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Bahi Yusufu nkuchisuma chilambo chammalele cha Misili uchinga chììve mali yanga Falao. Kila Mmisili nkusumisa mawelu lake, kwa kuva indala ívele ing'ali namene. Chilambo chammalele nkuva mali yanga Falao, ");
INSERT INTO kde_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","na Yusufu nkuvatenda vanu kuva vatumwa, kutandikila mpata umo wa chilambo cha Misili mpaka mpata unji. ");
INSERT INTO kde_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Eneo lyakanasumile Yusufu nni alila livachiikala makuhani. Anevo makuhani nanga pavanasumisije mawelu lavo kwa kuva vàpata vilyo kuhaloka kwanga Falao. ");
INSERT INTO kde_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Bahi Yusufu nkuvahaulila vanu kuchidoni, “Lola, nangu ǹninsumanga mwenu mmammalele pamo na mawelu lenu kuva mali yanga Falao. Bahi nangu nguchinimwing'ange dimbeyu uchinga mupande mmawelu lenu. ");
INSERT INTO kde_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Henga pamumbefuna, mwing'ange Falao asilimiya ishilini ya mafuno, na asilimiya samanini dimbeisalîla, anedyo dìmbekuva mpandani na chakulya chenu na cha vanu va n'ding'ande dyenu na cha vana venu.” ");
INSERT INTO kde_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Vanang'o nkunnyang'ula kuchidoni, “Nkulu, wako ùniupoha umi wetu! Na kwa kuva ùnitulanguja uwambone wako, hwetu tùmbekuva tuvatumwa tùvá Falao.” ");
INSERT INTO kde_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Bahi kwa namuna aneyo njo Yusufu chanavikile sheliya itumîka mpaka nelo nchilambo cha ku Misili kuva, kila munu àlembelewa ahumye asilimiya ishilini ya mafuno lake kwa nfalume. Chilambo cha makuhani weka njo chikanasumwije na kujuhwa kuva mali yanga Falao. ");
INSERT INTO kde_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Vaisilaeli váikele eneo lya ku Gosheni nchilambo cha ku Misili. Na pavanavele aneko, nkupata dimali dyohe na vánivelekana namene na kuyenjejeka namene. ");
INSERT INTO kde_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakobo nkuikala nchilambo cha ku Misili kwa uhiku wa vyaka kumi na saba, mpaka pahwikihije vyaka myamoja alubaini na saba. ");
INSERT INTO kde_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Uhiku wa kuhwa kwake paunavele pepi, Yakobo nkunchema Yusufu mwanawe nkunnyaulila kuchidoni, “Hambi, ikàva wako ùnikatapaliwa na nangu, bahi nguahidi kwa kutaya nkono wako munnyonga wangu kuva, uchiungutendele uwambone na uchiukulupike. Unangusike akuno ku Misili, ");
INSERT INTO kde_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ila panimbehila na kuhwena unaikala pamo na anakuluvangu vahidîle tangu, ungutwale apano pa Misili koka ukangusike munsati wavo.” Yusufu nkuchidoni, “Nguchingutende muchi chunguhaulidile.” ");
INSERT INTO kde_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yakobo nkunnyaulila kuchidoni, “Ngwapilile!” Yusufu nkumwapilila. Bahi Isilaeli, yani Yakobo nkutepehija muti wake mpata wa kumuti wa chinanda chake, nkumwabudu Nnungu. ");
INSERT INTO kde_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Bahi bada ya mambo anelo Yusufu nkupilikana kuva atatake ànauula. Yusufu nkuvatwala vana vake vavili, yani Manase na Efulaimu, nkulanganavo kwa atatake. ");
INSERT INTO kde_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Yakobo papilikene kuva Yusufu mwanawe àniida unannola, nkulikamya kutakatuka, nkuikala nchinanda. ");
INSERT INTO kde_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yakobo nkunnyaulila Yusufu kuchidoni, “Nnungu Avêle Na Dimongo Dyammalele áninguhumila pannavele akula ku Luzu, nchilambo cha ku Kanaani, nkungubaliki. ");
INSERT INTO kde_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Nkunguhaulila kuchidoni, ‘Nìmbekutenda ùùve na vanu vohe nnukolo lwako na kuyenjejeka. Nìmbekutenda wako kuva nnyakala wa ding'olo ding'ulu dya vanu. Na chilambo achino nìmbeveng'a vanu va nnukolo lwako vyaka na vyaka. ");
INSERT INTO kde_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Na vana vako vavili vuvapete apano pa Misili kabla nikànambikamola vàmbevalangiwa kuva vangu. Efulaimu na Manase vàmbekuva vana vangu malinga chavele Lubeni na Simeoni. ");
INSERT INTO kde_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Henga vana umbevapâta lukoto anevo njo vambekûva vako umwene, henga mapala lavo làmbehalokana na Efulaimu nawi Manase. ");
INSERT INTO kde_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ngwàmwile kutenda uchocho ing'anya ya àlalá lananhumidile anyoko, Laheli. Panichiuya kuhaloka ku Padani, Laheli ánihila nchilambo cha ku Kanaani, patunavele pepi kuhwika ku Efulata, yani ku Beselehemu nkungulekela uchiva. Bahi nangu nkunsika upala, nnyenje indila ihwêna ku Efulata.’ ” ");
INSERT INTO kde_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Isilaeli, yani Yakobo pavawene vana vanga Yusufu, nkummuja Yusufu kuchidoni, “Ava vana vannani?” ");
INSERT INTO kde_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yusufu nkunnyang'ula kuchidoni, “Ava ni vana vangu vangujalidîle Nnungu kuvapata nguvèlè akuno ku Misili.” Isilaeli nkuchidoni, “Chonde ngùyuwa uvahengeleje pepi uchinga ngupate kuvabaliki.” ");
INSERT INTO kde_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Na meho langa Isilaeli lakáchilola saana ing'anya ya kukongopala. Bahi Yusufu nkuvahengeleja vana vake pepi na atatake, Isilaeli nkuvabusu na kuvakumbatila. ");
INSERT INTO kde_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Anepo Isilaeli nkunnyaulila Yusufu kuchidoni, “Nangu nikáchilolela ukwona kumeho kwako kavila, henga Nnungu àningujalila kuvona na vana vako!” ");
INSERT INTO kde_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Bahi Yusufu nkuvausa vana vake mmalundi la atatake, nkuhunama mpaka pahi. ");
INSERT INTO kde_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yusufu nkuvakamula avala vana vake vavili. Efulaimu ánkamwile kwa nkono wake wa kunkono nkunnodya mpata wa kunchinda wa nkono wa atatake, na Manase ánkamwile kwa nkono wake wa kunchinda nkunnodya mpata wa kunkono wa nkono wa atatake, nkuvahengeleja kwa anakulwao. ");
INSERT INTO kde_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Henga Isilaeli nkulatindanya makono lake, nkono wake wa kunkono nkuuvika mmuti wanga Efulaimu, ikànava ávele n'joko, na nkono wake wa kunchinda nkuuvika mmuti wanga Manase, anavele ntandi kuvelekwa. ");
INSERT INTO kde_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Bahi Isilaeli nkum'baliki Yusufu wachidoni, “Nnungu uvanantumikidile anakuluvangu, Iblahimu na Isaka mmaisha lavo kwa ikulupiki yavo yammalele, Nnungu anguchungîle mmaisha langu mpaka nelo, ");
INSERT INTO kde_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","N'jumbe ayula angupohîje mmambo mabaya lammalele, avabalìkì avano vanemba! Vana avano vààve ukumbuso wa lina lyangu, na malina la anakuluvangu, Iblahimu na Isaka, na vahalije kuyenjejeka namene pachilambo.” ");
INSERT INTO kde_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yusufu pawene kuva atatake àuvikile nkono wake wa kunkono mmuti wanga Efulaimu, nanga panakatapaliwije. Bahi nang'e nkuukamula nkono wa atatake uchinga auuse mmuti mwa Efulaimu na kuuvika mmuti mwanga Manase. ");
INSERT INTO kde_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yusufu nkunnyaulila atatake kuchidoni, “Akee uchocho atata! Ayuno njo ntandi kuvelekwa. Uvike nkono wako wa kunkono mmuti mwake.” ");
INSERT INTO kde_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Henga atatake nkuhita wachidoni, “Ǹnimala mwanangu, ǹnimala. Manase àmbekuva nkulu, na vanu va nnukolo lwake vàmbekuva chilambo chikulungwa. Pamo na anelo, nnung'une àmbekuva nkulu kumpunda nang'e, na vanu va nnukolo lwake vàmbekuva vilambo vyohe.” ");
INSERT INTO kde_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Bahi liduva anelyo Yakobo nkuvabaliki wachidoni, “Vaisilaeli vàmbelatumila malina lenu kwa kuvabaliki vanu, uvachidoni,‘Nnungu akubaliki muchi chanam'balikite Efulaimu na Manase!’ ” Bahi uvila njo Yakobo chanantendile Efulaimu kuva nkulu kumpunda Manase nkuluwe. ");
INSERT INTO kde_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Bahi Isilaeli nkunnyaulila Yusufu kuchidoni, “Nangu ngùvele pepi kuhwa, henga Nnungu achiave pamo na mwenu na achiammuihange nchilambo cha anakuluvenu. ");
INSERT INTO kde_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Pamo na anelo, eneo fulani lya kumachinga linivapakanywele Vaamoli kwa upanga na upinde wangu, nìkwing'ile wako, na akee akuluvako.” ");
INSERT INTO kde_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Bahi Yakobo nkuvachema vana vake nkuvahaulila kuchidoni, “Idang'ana apano ninnyaulilange mambo lambenkojanga mmaduva laîda. ");
INSERT INTO kde_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Idang'ana mupilikanile, mwenu mmana mma Yakobo, mungupilikanile nangu Isilaeli atata wenu. ");
INSERT INTO kde_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Wako Lubeni mwanangu ntandi kuvelekwa, mwana wa ujana wangu, na chihepo cha ujana wangu. Wako ùnivapunda anung'unuvako kwa ukulu na dimongo. ");
INSERT INTO kde_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Henga ùvele muchi medi lakádivilika la livambwe. Wako nanga paumbekuva kavila mwanangu ntandi, kwa kuva, úlele na n'jangu ntumwa, nkuutaya najisi ulombi wangu. ");
INSERT INTO kde_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeoni na Lawi ni munu na nnung'une, vanang'o vàtumila vikomanilo vyao kuvalagiha vanu chikalalihi, ");
INSERT INTO kde_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","henga nangu nanga panimbekumila njama dyao dibaya. Nangu nanga panimbekumila makojano lao, kwa kuva, kwa kuvisa kwavo vávawalele vanu, na kwa kutamwa kwavo vene váchekete minanga ya ang'ombe. ");
INSERT INTO kde_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ivisi yavo ilaniwe, kwa kuva nni ing'ali namene, na gasabu yavo nni ya chikalalihi. Nnungu avamwadilihanye vanu va ding'olo dyavo muvanu va ding'olo dyangu dinji. Na avamwadilihanye nchilambo cha Isilaeli. ");
INSERT INTO kde_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Wako Yuda chalumo na vanu va nnukolo lwako, vanu va n'ding'olo dya anung'unuvako vàmbennombolelanga. Vanu va n'ding'olo dya anung'unuvako vàmbenhunamila mwenu, kwa kuva, mùmbevalema amongo venu. ");
INSERT INTO kde_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda mwanangu, wako na vanu va nnukolo lwako mùvele muchi uhimba, amalidîle kuntang'una nnyama wammwalele. Uhimba aneyo àhwena unalinyoloja na kulala, na nanga munu alînga kuntakatuha. ");
INSERT INTO kde_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Isimbo ya chifalume nanga paimbeuka kwa vanu va nnukolo lwanga Yuda, wala isimbo ya utawala nanga paimbeuka mmakono lavo, mpaka pambeida ayula mwene isimbo, uvambempilikana vanu va vilambo. ");
INSERT INTO kde_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Vanu va nnukolo lwako vàmbebalikiwa namene. Kupapatana na anelyo, vanu anevo vàmbevahungangila punda vao mmizabibu yambone namene. Vàmbechapa dinguwo dyavo n'divayi, na majoho lavo n'divayi dyanahuvi. ");
INSERT INTO kde_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Meho lavo làmbekunduvala ing'anya ya divayi kuva dyohe namene, na meno lavo làmbeswelela ing'anya ya mavele kuva lohe namene. ");
INSERT INTO kde_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zabuloni, vanu va nnukolo lwako vàmbeikala nnyenje bahali, na pwani yavo ìmbekuva pachinu pakuyamija dingalava. Na chilambo chavo chìmbedambaluka mpaka ku Sidoni. ");
INSERT INTO kde_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakali, vanu va nnukolo lwako vàmbekuva muchi punda avêle na dimongo, alilâja ching'ati misigo yake. ");
INSERT INTO kde_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Kwa kuva, vàmbepona pachinu pao pakuikala kuva pambone namene, na vàmbechona chilambo chao kuva chìnikatapala namene. Bahi vàmbeitepya myongo yavo uchinga vanyakule misigo iidôpa namene, na kukolokohwa kukola madengo lakamajânga namene. ");
INSERT INTO kde_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dani, ikànava lukolo lwako lujoko, henga vakulu vake vàmbevatawala vanu vao, muchi vakulu va ding'olo dinji dya Isilaeli chivavatawala vanu vao. ");
INSERT INTO kde_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Vanu va nnukolo lwako vàmbekuva muchi nnyongo nndila, nnyongo avêle na sumu nnyenje indila, alûma vikotwa vya falasi, na munu ankwedîle nkumotoka luwali. ");
INSERT INTO kde_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Yahwe, nangu ngùlindilila ungupohe kuhaloka kwa amongo vangu! ");
INSERT INTO kde_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gadi, vanu va nnukolo lwako vàmbehavilwa na vakúpakanyola, henga vanang'o vàmbevapapatilila anevo vanu kwa nnyuma na kuvahavila. ");
INSERT INTO kde_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Chilambo cha Asheli chìmbehumya vilyo vyambone namene, na vilyo anevyo vìmbefala kumwing'a nfalume. ");
INSERT INTO kde_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nafutali, vanu va nnukolo lwako vàvele muchi umbavala avêle hulu, avavelêka vana vakatapêle namene. ");
INSERT INTO kde_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusufu àvele muchi nzabibu ûpa vihepo pepi na chimbwimbwi, na dinavi dyake dìnakulumuka mpaka kuhulula kuhavila na kuyomboka lingongo. ");
INSERT INTO kde_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Amongo vake, vatalamu va kuyela myumba, vánintunduwilila namene, nkunnyelangila myumba na kunhavila kwa ukatili. ");
INSERT INTO kde_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Henga upinde wake únihwinga, na makono lake nkutaywa dimongo, kwa kuhululihwa na Nnungu wa Yakobo, Nnungu Avêle Na Dimongo Dyammalele, Nnungu avêle muchi Nchunga, na Mwamba wa Isilaeli. ");
INSERT INTO kde_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Nnungu wa atatako achiakuyangate, Nnungu Avêle Na Dimongo Dyammalele achiakubaliki, uchinga upate balaka dya kuhaloka muha kulihunde na balaka dya medi la vimbwimbwi vivêle pahi, na balaka dya kuvelekana kwa vanu na anyama. ");
INSERT INTO kde_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Balaka dyang'une atatako nni ding'ulu namene kupunda adila dihalôka mmachinga la kala. Na balaka anedyo dìnnyidilile Yusufu, kwa kuva, nang'e njo nkulu wa akuluvake na nnung'une. ");
INSERT INTO kde_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamini, vanu va nnukolo lwako vàvele muchi lihoha ayôha namene, ulyamba àvalya anyama vavalumbête, na lyulo àyavanya vitukutuku vyake vyavitwete litwala.” ");
INSERT INTO kde_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Anelo njo matawa kumi na mbili la Isilaeli. Na anelo njo malove lanatangwele atatawao pachim'baliki kila mwana kupapatana na namuna chachilembelewa. ");
INSERT INTO kde_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Bahi Isilaeli nkuvalaija vana vake wachidoni, “Nangu ngùvele pepi na kuhwa na kuhwena unaikala na anyakala vangu vahidîle kala. Nikàhwa, ngusike pachinu pavasikwije anakuluvangu, nnipanga livêle mmwelu mwa Efuloni Mhiti, ");
INSERT INTO kde_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","aneko ku Makipela, pepi na ku Mamle, nchilambo cha ku Kanaani. Iblahimu ásumile lipanga na welu anewo kuhaloka kwa Efuloni, Mhiti, uchinga pààve pachinu pake pakusikila. ");
INSERT INTO kde_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Aneko njo kwasikwije Iblahimu na Sala n'jawe, na njo kwasikwije Isaka na Labeka n'jawe, na njo kuninsikile Leya. ");
INSERT INTO kde_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Welu anewo pamo na lipanga livêle mmwelu anewo, vísumwije kwa Vahiti.” ");
INSERT INTO kde_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yakobo pamalidile kuveng'a vana vake malaijo, nkuuiha madodo lake nchinanda, nkuhila. Nkuhwena unaikala pamo na anyakala vake vahidîle kala. ");
INSERT INTO kde_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Bahi Yusufu nkunkumbatila atatake akuno wakuta na kum'busu. ");
INSERT INTO kde_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Anepo Yusufu nkuvalaija vatumishi vake vaganga, vampake ntela Isilaeli atatake uchinga anakandike, navanang'o nkutenda uchocho. ");
INSERT INTO kde_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Anevo vaganga vátumidile maduva alubaini kukola madengo anelo, kwa kuva njo maduva lachilembelewa. Na Vamisili navanang'o nkunkutangila Yakobo kwa maduva sabini. ");
INSERT INTO kde_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Palamalilike maduva la kunkutangila, Yusufu nkuvahaulila vashauli vanga Falao kuchidoni, “Ikàva mwenu mùnikatapaliwa na nangu, chonde ngùyuwa mulonjele na Falao kwajili yangu kuva, ");
INSERT INTO kde_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","atatangu áningwapisa wachidoni, ‘Nangu ngùvele pepi na kuhwa. Ùlembelewa ukangusike munsati unguvedile kwajili yangu nchilambo cha ku Kanaani.’ Hambi ngùyuwa anguluhusu nguhwene nikansike atatangu, koka nguuye.” ");
INSERT INTO kde_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Falao nkunnyang'ula kuchidoni, “Hwena ukansike atatako malinga chakuapisije.” ");
INSERT INTO kde_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Bahi Yusufu nkuuka, nkuhwena unansika atatake akuno apapatènè na maafisa vohe vanga Falao na vashauli va lukumbi lwanga Falao, pamo na vashauli vammalele va nchilambo cha ku Misili. ");
INSERT INTO kde_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Uchocho, Yusufu álongene na vanu vammalele va nng'ande mwake na akuluvake vammalele na nnung'une na vanu vammalele va nng'ande mwa Yakobo atatake. Mueneo lya ku Gosheni váisalidile chihi anavao pamo na angandolo na ambudi na ang'ombe vao bahi. ");
INSERT INTO kde_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Uchocho, álongene na vakúkwela falasi na mikokoteni iutângwa na falasi, nkuva likuwa likulungwa namene. ");
INSERT INTO kde_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Pavahwikile paluungo lwanga Atadi luvahulila ngano, luvêle mpata wa mashaliki wa muto wa Yoludani, nkulikutangila kwa uchungu namene, na Yusufu nkunnalila atatake matanga kwa uhiku wa maduva saba. ");
INSERT INTO kde_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Vakanaani, yani venedi va chilambo anecho, pavalawene maomboleso latendewîje paluungo luvahulila ngano lwanga Atadi, nkuchidoni, “Maomboleso ala la Vamisili ni makulungwa namene!” Bahi pachinu anepo pavêle ng'ambo yavili ya muto wa Yoludani nkuchemwa Abeli-Misili. ");
INSERT INTO kde_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Bahi vana vanga Yakobo nkuntendela atatawao muchi chavalaijije. ");
INSERT INTO kde_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Váninnyakula mpaka nchilambo cha ku Kanaani, nkunsika nnipanga livêle mmwelu aneko ku Makipela, pepi na ku Mamle. Lipanga anelyo na welu anewo Iblahimu ánisuma kuhaloka kwanga Efuloni, Mhiti uchinga pààve pachinu pake pakusikila. ");
INSERT INTO kde_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Bada ya kunsika atatake, Yusufu nkuuya ku Misili chalumo na akuluvake na nnung'une na vanu vammalele vanampelekedile unansika atatake. ");
INSERT INTO kde_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Bada ya kuhila atatawao, akuluvake Yusufu nkuhaulanila kuchidoni, “Mbwasa vino Yusufu àmbetuvenga na kutupindikulila mabaya lammalele latuntendeledile.” ");
INSERT INTO kde_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Bahi vanang'o nkumpelekejija ujumbe uvachidoni, “Atatako kabla akànambikuhwa álaijije uvila, ");
INSERT INTO kde_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Nnyaulile Yusufu kwa niaba yangu kuva, ‘Chonde ngùyuwa uvasamehe akuluvako makosa lavo na mabaya lammalele lavakutendeledile.’ Hambi tùyuwa utusamehe mabaya lammalele latukutendeledile hwetu tuvatumishi tùvá Nnungu wa atatako.” Yusufu papilikene ujumbe anewo, nkukuta. ");
INSERT INTO kde_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Anepo akuluvake nkumwidilila, nkunhunamila mpaka pahi uvachidoni, “Lola, hwetu ni tuvatumwa vako.” ");
INSERT INTO kde_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Henga Yusufu nkuvahaulila kuchidoni, “Munayope! Dachi, kwani nangu Nnungu mpaka ninnyukumu mwenu? ");
INSERT INTO kde_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Mwenu múlembela mungutendele mabaya, henga Nnungu ángukudungidile lambone uchinga vanu vohe vapate kuva vomi malinga chimwona nelo. ");
INSERT INTO kde_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Bahi munayope. Nangu nguchinimwing'ange vilyo, mwenu pamo na vana venu.” Bahi Yusufu nkuvatuja mitima na kutangola navo saana. ");
INSERT INTO kde_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yusufu nkuhweneha kuikala nchilambo cha Misili, nang'e pamo na vanu vammalele va nng'ande mwa atatake. Yusufu nkulama kwa uhiku wa vyaka myamoja na kumi. ");
INSERT INTO kde_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yusufu ánijaliwa kuvona vavana na vadukulu va mwanawe Efulaimu. Uchocho, vana vanga Makili mwana wanga Manase, ánivapwechela kuva vana vake. ");
INSERT INTO kde_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Anepo Yusufu nkuvahaulila akuluvake kuchidoni, “Nangu vino ngùvele pepi na kuhwa. Henga muhiu Nnungu achiannyangatange na kummusanga nchilambo achino na kumpelekejanga nchilambo chanamwahidite Iblahimu na Isaka na Yakobo.” ");
INSERT INTO kde_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Bahi Yusufu nkuvaapisa vana vanga Isilaeli wachidoni, “Muhiu Nnungu achiaide unannyangatanga mwenu kuuka nchilambo achino, na mwenu muchimunyakule mawangwa langu.” ");
INSERT INTO kde_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Bahi Yusufu nkuhila aneko ku Misili akuno avèlè na vyaka myamoja na kumi. Na vanang'o nkuupakala mmili wake ntela uchinga unakandike upehi, nkuuvika nnisanduku aneko ku Misili.");
INSERT INTO kde_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Auno njo n'dododo wa malina la vanu va nnitawa lyavelekwejije Yesu Kilisto, n'dukuluwe Nfalume Daudi, n'dukuluwe Iblahimu. ");
INSERT INTO kde_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Iblahimu ámmaleke Isaka, Isaka nkummaleka Yakobo, Yakobo nkummaleka Yuda chalumo na akuluvake na anung'unuvake. ");
INSERT INTO kde_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda nkummaleka Pelesi na Sela, na amamayavo ávele Tamali, Pelesi nkummaleka Esiloni, Esiloni nkummaleka Alamu. ");
INSERT INTO kde_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Alamu nkummaleka Aminadabu, Aminadabu nkummaleka Nashoni, Nashoni nkummaleka Salumoni, ");
INSERT INTO kde_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salumoni nkummaleka Boasi, na anyokwe Boasi ávele Lahabu. Boasi nkummaleka Obedi, na anyokwe Obedi ávele Lutu. Obedi nkummaleka Yese. ");
INSERT INTO kde_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese nkummaleka Nfalume Daudi. Daudi nkummaleka Selemani, na anyokwe Selemani njo ánavele n'jawe Uliya kabla akànambimmaleka Selemani. ");
INSERT INTO kde_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Selemani nkummaleka Lehoboamu, Lehoboamu nkummaleka Abiya, Abiya nkummaleka Asa, ");
INSERT INTO kde_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa nkummaleka Yehoshafati, Yehoshafati nkummaleka Yolamu, Yolamu nkummaleka Usiya. ");
INSERT INTO kde_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiya nkummaleka Yosamu, Yosamu nkummaleka Ahasi, Ahasi nkummaleka Ezekiya, ");
INSERT INTO kde_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekiya nkummaleka Manase, Manase nkummaleka Amoni, Amoni nkummaleka Yosiya, ");
INSERT INTO kde_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiya nkummaleka Yekoniya chalumo na anung'unuvake, mmaduva àlalá lavachitwaliwa Vayahudi kupelekejwa kumidi, aneko ku Babeli. ");
INSERT INTO kde_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Vayahudi pavapelekejijwe kumidi, aneko ku Babeli, Yekoniya nkummaleka Shealitieli, Shealitieli nkummaleka Selubabeli, ");
INSERT INTO kde_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Selubabeli nkummaleka Abiudi, Abiudi nkummaleka Eliakimu, Eliakimu nkummaleka Asoli, ");
INSERT INTO kde_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asoli nkummaleka Sadoki, Sadoki nkummaleka Akimu, Akimu nkummaleka Eliudi, ");
INSERT INTO kde_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudi nkummaleka Eleasali, Eleasali nkummaleka Matani, Matani nkummaleka Yakobo, ");
INSERT INTO kde_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobo nkummaleka Yusufu ntwave Maliya, na Maliya njo ammalêke Yesu, uvanchema Kilisto. ");
INSERT INTO kde_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Bahi kutandikila Iblahimu mpaka Nfalume Daudi, pávele na vivélekwa kumi na ncheche, na vivélekwa kumi na ncheche kutandikila Nfalume Daudi mpaka pavachitwaliwa Vayahudi kupelekejwa kumidi aneko ku Babeli, na vivélekwa vinji kumi na ncheche kutandikila kutwaliwa kwa Vayahudi mpaka kuvelekwa kwanga Kilisto. ");
INSERT INTO kde_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Aino njo habali ya kuvelekwa kwanga Yesu Kilisto. Maliya anyokwe Yesu áposwa na munu yumo uvanchema Yusufu. Henga kabla vakànambikwikalana, na Maliya kabla akànambikummala nnume, áonekene àvele na chitumbo kwa dimongo dya Umumu Wanaswe. ");
INSERT INTO kde_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Na Yusufu kwa kuva ávele munu wambone pameho pa Nnungu na akanatamwije untaya dihoni Maliya, bahi nkukudungila anneke kwa sili bila vanu vanji kumala. ");
INSERT INTO kde_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Bahi pachikumbukilanya anelo, malaika wa Nang'olo nkumwidila muindoto nkunnyaulila kuchidoni, “Wako Yusufu n'dukuluwe Nfalume Daudi, unayope kuntwala Maliya ààve n'jalo, kwa kuva, chitumbo chake chìhalokene na dimongo dya Umumu Wanaswe. ");
INSERT INTO kde_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nang'e àmbemmeleka mwana wa chilume, koka uncheme lina lyake Yesu, kwa kuva, nang'e njo ambevapôha vanu vake n'disambi dyavo.” ");
INSERT INTO kde_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Anelo lammalele lánitendeka uchinga latimile malove lanatangwele Nang'olo Nnungu kupitila kwanga nabii wake kuva, ");
INSERT INTO kde_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Nkongwe akámmaite nnume àmbekuva na chitumbo, na àmbemmaleka mwana wa chilume, na vàmbenchema Imanueli,” mana lake, Nnungu àvele pamo na hwetu. ");
INSERT INTO kde_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Bahi Yusufu patakatwike, nkuhwena unatenda muchi malaika wa Nang'olo channaijije, nang'e nkuntwala Maliya kuva n'jawe. ");
INSERT INTO kde_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Henga nanga panalele nawe mpaka pammaleke mwana wa chilume, na Yusufu nkunchema lina Yesu. ");
INSERT INTO kde_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu ávelekwejije muimanga ya Beselehemu, nchilambo cha Yudeya, mmaduva àlalá Helode lánavele nfalume. Bahi Yesu pavelekwejije, nkuhalokanga vanu kuhaloka m'bali wa mashaliki, vanu vavêle na elimu ya kumala lambehumîla kwa kuloleha dinondwa, nkuhwika ku Yelusalemu. ");
INSERT INTO kde_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Vanu anevo nkuuja kuchidoni, “Àvele kwachi Nfalume wa Vayahudi avelekwejîje? Tùniyona inondwa yake patunavele m'bali wa mashaliki, na hwetu tùidile unamwabudu.” ");
INSERT INTO kde_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nfalume Helode papilikene anelo, nang'e pamo na vanu vammalele va pa Yelusalemu nkuva na lipamba. ");
INSERT INTO kde_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Bahi Helode nkuvachema makuhani vakulu vammalele na vakúhunda Sheliya yanga Musa, nkuvauja kuchidoni, “Kilisto àmbevelekwa kwachi?” ");
INSERT INTO kde_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Vanang'o nkunnyang'ula kuchidoni, “Àmbevelekwa ku Beselehemu, nchilambo cha Yudeya, kwa kuva njo chalembile nabii kuva, ");
INSERT INTO kde_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Henga wako Beselehemu, uvêle chilambo cha ku Yudeya, wako nanga puvele n'joko n'dimanga ding'ulu dya ku Yudeya, kwa kuva, kwakuwe àmbehaloka nkútawala ambevatawâla vanu vangu Vaisilaeli.’ ” ");
INSERT INTO kde_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Bahi Helode nkuvachema chitinya-tinya avala vanu vavêle na elimu ya kumala lambehumîla kwa kuloleha dinondwa, uchinga avauje aila inondwa íhumidile duvani. ");
INSERT INTO kde_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Anepo Helode nkuvatuma vahwene aneko ku Beselehemu wahaula kuchidoni, “Hweneng'ana mukatumbame kuntaha aneyo mwana. Mukàmwona, uyang'ana munguhaulile, uchinga nanani nguhwene nikàmwabudu.” ");
INSERT INTO kde_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pavampilikanidile nfalume, vanang'o nkuhweneng'ana. Na aila inondwa ivaiwene pavanavele m'bali wa mashaliki nkuvalodya, na vanang'o nkuilondola mpaka paiimidile pachinu apala pavele ayula mwana. ");
INSERT INTO kde_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Pavaiwene aneyo inondwa nkuhangalala namene. ");
INSERT INTO kde_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Anevo vanu nkuinjila nng'ande, nkumwona mwana chalumo na Maliya anyokwe, nkutindivala malundi nkumwabudu ayula mwana. Anepo nkuhungula vihapu vyao nkumwing'a ayula mwana dinujo dya zahabu na ubani na mahuta lagalika la manemane. ");
INSERT INTO kde_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Anevo vanu nkuuyang'ana kukaya kwavo kwa kupitila chihi indila inji ing'anya Nnungu ánivakalipila muindoto vanauyile kavila kwanga Helode. ");
INSERT INTO kde_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Avala vanu pavaukile, malaika wa Nang'olo nkunnyumila Yusufu muindoto nkunnyaulila kuchidoni, “Takatuka, ntwale mwanalo pamo na anyokwe, mutukutile ku Misili. Ikalanga aneko mpaka panimbekuhaulila uuye, kwa kuva, Helode àntaha mwana uchinga ammwalale.” ");
INSERT INTO kde_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Bahi chilo anecho Yusufu nkutakatuka, nkuntwala mwana pamo na anyokwe mwana, nkuhwena ya ku Misili. ");
INSERT INTO kde_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nkuikala aneko mpaka Helode pahwile. Chinu anecho chínitendeka uchinga litimile lilove lyanatangwele Nang'olo Nnungu kupitila kwanga nabii wake kuva, “Nínchemile Mwanangu, auye kuhaloka ku Misili.” ");
INSERT INTO kde_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Helode pamaite kuva avala vanu vavêle na elimu ya kumala lambehumîla kwa kuloleha dinondwa vàninnambila, nkutunduwila namene. Nkulaija vavana vammalele va chilume va ku Beselehemu na vannyenje, kutandikila vakanunu mpaka vavêle na myaka mivili, vawalalwe. Helode ávatondwele vavana va changa anecho kupapatana na uhiku aula uvanaiwene inondwa avala vanu vavêle na elimu ya kumala lambehumîla kwa kuloleha dinondwa. ");
INSERT INTO kde_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Anepo njo palatimidile malove lanatangwele nabii Yelemiya kuva, ");
INSERT INTO kde_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Lidi línipilikanika aneko ku Lama, kukuta na kulikutangila. Laheli wavakutila vana vake, wala anatamwe kutujwa ntima, ing'anya vammalele vànihwa.” ");
INSERT INTO kde_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pahwile Helode, malaika wanga Nang'olo Nnungu nkunnyumila Yusufu muindoto akula ku Misili. ");
INSERT INTO kde_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Nkunnyaulila kuchidoni, “Takatuka, ntwale mwana pamo na anyokwe, uuye navo ku chilambo cha Isilaeli, kwa kuva, avala vachilambela kummwalala mwana, vànihwa.” ");
INSERT INTO kde_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Bahi Yusufu nkutakatuka, nkuntwala mwana pamo na anyokwe mwana, nkuuya ku chilambo cha ku Isilaeli. ");
INSERT INTO kde_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Henga Yusufu papilikene kuva Alikelao, mwanawe Helode, àjukile kuva nfalume wa chilambo cha Yudeya, pachinu pachitawala atatake, ániyopa kuhwena aneko. Henga Yusufu padumwije muindoto, nkuhwena kuchilambo cha ku Galilaya, ");
INSERT INTO kde_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","nkunaikala kuimanga ya ku Nasaleti, uchinga latimile malove lavanatangwele manabii kumwamba Kilisto kuva, “Vàmbenchema Nnasaleti.” ");
INSERT INTO kde_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mmahiku anelo, Yohana Nkúbatisa áhumilidile kulilanga lya ku Yudeya, nkutandilika kuvahubilila vanu, ");
INSERT INTO kde_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","wachidoni, “Lekanga kutenda masambi, kwa kuva, Ufalume wa Nnungu ùvele pepi.” ");
INSERT INTO kde_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Aneyo Yohana njo wachimwamba nabii Isaya pachihaula kuchidoni, “Munu ànonoha lidi kulilanga, wachidoni, ‘Nkatapajije Nang'olo indila yake, nyoshanga dihengo dyambepita.’ ” ");
INSERT INTO kde_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohana áwete inguwo ikatapajîjwe kwa maleha la ungamila na nchikundu mwake áhungile nkanda wa limbende. Chakulya chake chívele chihi mahiya na uchi wa munnyitu. ");
INSERT INTO kde_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Vanu vohe kuhaloka imanga ya ku Yelusalemu na chilambo chammalele cha ku Yudeya na va vilambo vyammalele vivêle nnyenje muto wa Yoludani, vánimmwenela. ");
INSERT INTO kde_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nkulitangolanga masambi lavo, na Yohana nkuvabatisa mmuto wa Yoludani. ");
INSERT INTO kde_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yohana pavawene Mafalisayo na Masadukayo vohe uvammwenela uchinga avabatise, nang'e nkuvahaulila kuchidoni, “Mwenu nni mmana mma nachihungo! Nnani an'dumênge mwenu muitile gasabu ya Nnungu iîda? ");
INSERT INTO kde_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tendanga matendo lalanguja kuva munilekanga masambi lenu. ");
INSERT INTO kde_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Munatende kuva mùnahulula kulisingila kuva Iblahimu nni anakulwenu! Lola, nangu nìnnyaulilanga kuva, Nnungu ànahulula kulapindikulanya mayanga alano lààve udukulu wanga Iblahimu. ");
INSERT INTO kde_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Bahi vino imbedo ìnivikwa tayali kucheketa mahina la milandi. Kila nnandi ukápa vihepo vikatapêle umbecheketwa na kuyahwa mmoto. ");
INSERT INTO kde_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nangu nìm'batisa mwenu kwa medi kulanguja kuva mùnileka masambi lenu. Henga aîda nnyuma mwangu àvele na dimongo ungupunda nangu, na nangu nikáfala kuntumikila kananga kwa kuhungula mididi ya vilatu vyake. Nang'e àmbem'batisa mwenu kwa Umumu Wanaswe na kwa moto. ");
INSERT INTO kde_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nang'e ànyakwile chihelo cha kupembulila mmakono mwake uchinga apepetele ngano yake. Àmbeilapola ngano na kuivika nnikangala, henga makadakada àmbelayocha mmoto ukádimika.” ");
INSERT INTO kde_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Anepo Yesu nkuuka ku Galilaya, nkuhwena kumuto wa Yoludani, uchinga Yohana am'batise. ");
INSERT INTO kde_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Henga Yohana nkulinga unnimbija Yesu wachidoni, “Nangu ngùlembelewa ngubatiswe na wako, mwadachi wako ùida kwang'une?” ");
INSERT INTO kde_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesu nkunnyang'ula kuchidoni, “Kwa vino, leka ììve chihi uchocho, kwa kuva njo chiilembelewa uchinga tulatimise lammalele lalalembela Nnungu.” Bahi Yohana nkukubali. ");
INSERT INTO kde_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesu pamalidile kubatiswa, nkuhuma mmedi, upala kulihunde nkuhunukuka, nkumwona Umumu wa Nnungu achionekâna muchi umunda, wasulupuka na kutulila muha mwake. ");
INSERT INTO kde_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Lidi nkupilikanika kuhaloka kulihunde ulichidoni, “Ayuno njo Mwanangu unguntamwa, ǹnikatapaliwa nawe.” ");
INSERT INTO kde_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Bahi Yesu nkulojwa na Umumu Wanaswe mpaka kulilanga uchinga akalingwe na Ibilisi. ");
INSERT INTO kde_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesu nkufunga maduva alubaini chilo na muhi, pamalidile maduva anelo nkwona indala. ");
INSERT INTO kde_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Bahi Ibilisi, ayula avalînga vanu nkumwidila Yesu nkunnyaulila kuchidoni, “Ikàva wako Mwana wanga Nnungu lahaulile mayanga alano lààve mikate.” ");
INSERT INTO kde_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu nkunnyaulila kuchidoni, “Ìnilembwa Mmalemba Lanaswe kuva, ‘Munu akambelama, kwa kulya chihi nkate, ila kwa kulikamula kila lilove lyatangola Nnungu.’ ” ");
INSERT INTO kde_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ibilisi nkuntwala Yesu mpaka ku Yelusalemu, imanga yanaswe, nkunammika kuchisweswe cha muha namene cha Ing'ande ya Nnungu, ");
INSERT INTO kde_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","nkunnyaulila kuchidoni, “Ikàva wako Mwana wa Nnungu, liyahe pahi, kwa kuva, ìnilembwa Mmalemba Lanaswe kuva, ‘Nnungu àmbevalaija malaika vake kwajili yako. Vanang'o vàmbekunyakula mmakono lavo, uchinga unalihumbule kananga madodo lako mmayanga.’ ” ");
INSERT INTO kde_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu nkunnyang'ula kuchidoni, “Ìnilembwa kavila Mmalemba Lanaswe kuva, ‘Unanninge Nang'olo, Nnungu wako.’ ” ");
INSERT INTO kde_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Anepo Ibilisi nkuntwala kavila Yesu mpaka kudedu lichinga lilehu, nkunnanguja ufalume wa kila chilambo na ukulu wake. ");
INSERT INTO kde_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ibilisi nkunnyaulila Yesu kuchidoni, “Ukatindivala malundi na kungwabudu, nakwing'a anevyo vyammalele.” ");
INSERT INTO kde_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Henga Yesu nkunnyaulila kuchidoni, “Uka, Nanchindenga! Kwa kuva, ìnilembwa Mmalemba Lanaswe kuva, ‘Mwabudu Nang'olo Nnungu wako, na kuntumikila chihi nang'e weka.’ ” ");
INSERT INTO kde_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Anepo Ibilisi nkunneka Yesu, nkuhaloka malaika nkunnyudumila. ");
INSERT INTO kde_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Bahi Yesu papilikene kuva Yohana vantadile nnilungu, nkuhwena chijiji cha ku Nasaleti, chilambo cha ku Galilaya. ");
INSERT INTO kde_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Yesu nkuuka kuimanga ya Nasaleti, nkuhwena unaikala imanga ya ku Kapelinaumu, imanga ivêle pepi na Litanda lya ku Galilaya, vilambo vya vanu va litawa lya Sabuloni na litawa lya Nafutali. ");
INSERT INTO kde_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yatendeke uchocho uchinga latimile malove lanatangwele nabii Isaya kuva, ");
INSERT INTO kde_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Vilambo vya vanu va litawa lya Sabuloni na litawa lya Nafutali, nni vilambo vivêle nndila ilôdya kubahali na m'bali wavili wa muto wa Yoludani. Anevyo njo vilambo vya ku Galilaya, vivaikala vanu vohe vakávele Vayahudi. ");
INSERT INTO kde_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Vanu anevo vaikâla nnupi, vàniwona nng'anje nkulu. Na anevo vaikâla nchilambo chihinikwije kwa chimbwehedi cha kuhwa, nng'anje univahimbukila!” ");
INSERT INTO kde_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Na kutandikila mahiku ulolo, Yesu nkutandilika kuvahubilila vanu ujumbe wake wachidoni, “Lekanga kutenda masambi, kwa kuva, Ufalume wa Nnungu ùvele pepi!” ");
INSERT INTO kde_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Bahi Yesu pánavele nkwonga nnyenje Litanda lya ku Galilaya, nkuvona akúupa dihomba vavili uvayela dinjau dyavo nnitanda, Simoni uvanchema Petulo chalumo na nnung'une uvanchema Anduleya. ");
INSERT INTO kde_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu nkuvahaulila kuchidoni, “Ngupapate, nangu nguchinintende mwenu kuva mmanu mma kuvaupila vanu kwa Nnungu.” ");
INSERT INTO kde_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Upala, nkudilekanga dinjau dyavo, nkumpapata Yesu. ");
INSERT INTO kde_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Papite muyo kadiki, nkuvona vanu vanji vavili, munu na nnung'une, Yakobo na Yohana vana vanga Sebedayo. Vanang'o vávelenge muingalava pamo na atatawavo Sebedayo uvakatapaja dinjau dyavo. Yesu nkuvachema, ");
INSERT INTO kde_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","upala, nkuileka ingalava pamo na atatawavo, nkumpapata Yesu. ");
INSERT INTO kde_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Bahi Yesu nkwonga chilambo chammalele cha ku Galilaya, wavahunda vanu n'ding'ande dya kunnyuwila Nnungu na kuvahubilila vanu Malove Lambone layâmba Ufalume wanga Nnungu na kulamya kila namuna ya ugonjo na kila namuna ya kuhuvanga. ");
INSERT INTO kde_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Imbili yake nkupilikanika nchilambo chammalele cha ku Siliya. Bahi vanu nkumpelekejija Yesu vanu vammalele vánavele na magonjo la kila namuna na vachihuvanga na vabanîhwa na anamindenga, na vánavele na chihundahunda, na vadidimênge miili, nang'e nkuvalamya vammalele. ");
INSERT INTO kde_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Makuwa lohe la vanu kuhaloka kudimanga kumi dichemwa Dikapoli, na kuhaloka ku Yelusalemu na chilambo cha ku Galilaya na ku Yudeya na kung'ambo muto wa Yoludani, lammalele lánimpapata. ");
INSERT INTO kde_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Bahi Yesu pauwene mmuluku wa vanu, nkukwela nnichinga, nkunaikala. Vakuhundwa vake nkummwenela, ");
INSERT INTO kde_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","nang'e nkutandilika kuvahunda wachidoni, ");
INSERT INTO kde_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Wasa vanu avala valisingîla chihi Nnungu weka, kwa kuva, Ufalume wa Nnungu nni wavo. ");
INSERT INTO kde_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Wasa vanu avala valikutangîla, kwa kuva, Nnungu achiavatuje ntima. ");
INSERT INTO kde_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Wasa vanu avala valisulupûha, kwa kuva, chilambo chimbekuva mapala lavo. ");
INSERT INTO kde_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Wasa vanu avala vavêle na indala na inyota ya kutenda lalalembela Nnungu, kwa kuva, Nnungu àmbevasibiha. ");
INSERT INTO kde_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Wasa vanu avala vavêle na chididi, kwa kuva, Nnungu achiavavikile chididi. ");
INSERT INTO kde_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Wasa vanu avala vavêle na disungu dihahwîke, kwa kuva, vàmbemwona Nnungu. ");
INSERT INTO kde_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Wasa vanu avala vavapatanîsa vanu, kwa kuva, vàmbevalangiwa kuva vana va Nnungu. ");
INSERT INTO kde_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Wasa vanu avala vabanîhwa ing'anya ya kutenda lalalembela Nnungu, kwa kuva, Ufalume wa Nnungu nni wavo. ");
INSERT INTO kde_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Wasa mwenu, vanu vakàntangolela malove lahakalenge na kum'baniha na kunnambilila lahakalenge, kwajili yangu. ");
INSERT INTO kde_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Hangalala na kululutila, kwa kuva, inujo yenu ing'ulu ìnivikwa kulihunde. Uvila njo chivanananihijwe manabii vanapwawije, kabla mwenu mukànambipwawa.” ");
INSERT INTO kde_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mwenu mùvele muchi munyu kwa vanu vammalele. Henga inowi ya munyu ikàhang'uka, dachi, ùmbetaywa chamani uchinga inowi yake iuyile kavila? Ukálembelewa kwa chinu chohecho, ila uuyaha chihi pawelu na kuluvatwa na vanu. ");
INSERT INTO kde_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Mwenu mùvele muchi nng'anje kwa vanu vammalele, nng'anje ukáhululika kupihika, malinga chuukapihika nng'anje wa imanga idengwîje muha lichinga. ");
INSERT INTO kde_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nanga munu achâcha chibatali koka nkuchihinika lidebe, ila vàchivika muha chipanda, uchinga chivamulikile vanu vammalele vàvele nng'ande. ");
INSERT INTO kde_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Uchocho, na mwenu nng'anje wenu ulangaje muyo mwa vanu, uchinga valone àlalá lambone lamutenda, koka vannombolele Atata wenu wa kulihunde.” ");
INSERT INTO kde_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Munatende kuva nangu ngùidile unaipukutanga Sheliya ya Musa au mahundo la manabii. Nangu nikáidile unaipukutanga, henga ngùidile unaitimilisa. ");
INSERT INTO kde_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nangu nìnnyaulilanga uhiu kuva, mpaka anepo chilambo na lihunde pavimbepita, wala nanga pachinu kananga pajoko pa lilove mu Sheliya yanga Musa pambeûka mpaka lammelele latimile. ");
INSERT INTO kde_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Munu woheyo akambeiyonela mana kananga amuli inyoko mu Sheliya adino na kuvahunda vanu vanji vatende uchocho, aneyo àmbevalangiwa kuva n'joko mu Ufalume wa Nnungu. Henga ayula ambekamûla Sheliya na kuvahunda vanu vatende uchocho, aneyo àmbevalangiwa kuva nkulu mu Ufalume wa Nnungu. ");
INSERT INTO kde_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nangu nìnnyaulilanga uhiu kuva, ikàva nanga pamutenda àlalá lalalembela Nnungu kupunda chivatenda Mafalisayo na vakúhunda Sheliya yanga Musa, mukámbeinjila mu Ufalume wa Nnungu.” ");
INSERT INTO kde_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mwenu mùnipilikana amuli ihaûla kuva, ‘Unawalale, na munu woheyo ambewalâla àlembelewa ahukumiwe asabu.’ ");
INSERT INTO kde_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Henga nangu nìnnyaulilanga uhiu kuva, munu woheyo amvisîja nnyake, àlembelewa ahukumiwe asabu. Na munu antangolêla nnyake malove lahakalenge, nang'e àmbehukumiwa asabu ku Lukumbi Lukulu lwa Vayahudi. Na munu annyaulîla nnyake kuva, ‘Ukávele na ding'ano’ nang'e àlembelewa ayahwe mmoto wa Jihannamu. ");
INSERT INTO kde_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ikàva ùhwena unannyumija Nnungu sadaka pachitala, upala nkukumbukila kuva nnyako àvele na lituku na wako, ");
INSERT INTO kde_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","bahi ileke sadaka yako pachitala, uhwene ukapatane na nnyako hoti, koka uuye unnyumije Nnungu sadaka yako. ");
INSERT INTO kde_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Piyanyija kupatana na munu akusitêke, tenda uchocho kabla mukànambihwika kulukumbi. Ukanatende uchocho, munu akusitêke àmbekupelekeja kwa nkúhukumu, koka nkúhukumu akupelekeje kwa litiyala, koka litiyala akuchimile nnilungu. ");
INSERT INTO kde_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nangu nìkuhaulila uhiu kuva, anemwo ukambehuma mpaka paumbemalilila ulipa senti ya ntululilo.” ");
INSERT INTO kde_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mwenu mùnipilikana amuli ihaûla kuva, ‘Unalale ugoni.’ ");
INSERT INTO kde_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Hambi nangu nìnnyaulilanga kuva, ambennôla mmahe kwa kunng'unukila, aneyo ànilala nawe ugoni mwisungu mwake. ");
INSERT INTO kde_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ikàva liso lyako lya kunkono lìkutenda utende sambi, lidabole uliyahe kulehu na wako! Wasa unààve na imbande imo, kuliko mmili wako wammalele kuyahwa mmoto wa Jihannamu. ");
INSERT INTO kde_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Na ikàva nkono wako wa kunkono ùkutenda utende sambi, uchekete uuyahe kulehu na wako! Wasa unààve na imbande imo, kuliko mmili wako wammalele kuyahwa mmoto wa Jihannamu.” ");
INSERT INTO kde_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Vanu vanji vàhaula kuva Sheliya ìhaula kuva, ‘Munu woheyo annêka n'jawe, àlembelewa amwing'e talaka.’ ");
INSERT INTO kde_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Henga nangu nìnnyaulilanga kuva, munu woheyo annêka n'jawe, ikànave chihi kwa ing'anya ya kulala ugoni, àntenda mmahe aneyo kuva n'goni, na nnume ambennômba mmahe aneyo, nanang'e àlalá ugoni.” ");
INSERT INTO kde_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Uchocho, múnipilikana chivanavahaulidile vanyakala kuva, ‘Munavike nasili ya kulambila, henga ùlembelewa utimise nasili yunavikile kwanga Nang'olo Nnungu.’ ");
INSERT INTO kde_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Henga nangu nìnnyaulilanga kuva, wala munaapile kwa kutambulanga kulihunde, kwa kuva, aneko njo kwaikala Nnungu nchiteng'u chake cha chifalume. ");
INSERT INTO kde_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Na wala munaapile kwa kutambulanga chilambo, kwa kuva, anepo njo pachinu pakuvika madodo lake, na wala munaapile kwa kutambulanga Yelusalemu, kwa kuva, aneyo njo imanga ya Nnungu, Nfalume Nkulu. ");
INSERT INTO kde_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Na wala unaapile kwa kutambulanga muti wako, kwa kuva, nanga pauhulula kananga kuutenda ulindo wako umo ùùve wanaswe au wanapi. ");
INSERT INTO kde_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mwenu mukàhaula, ‘Elo,’ muhiu ììve elo, na mukàhaula, ‘Nanga,’ muhiu ììve nanga, kwa kuva, malove latongolêwa kupunda anepo làhaloka kwa Nanchindenga.” ");
INSERT INTO kde_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mùnipilikana kuva ìnihaulwa kuva, ‘Antumbûla nnyake liso nanang'e atumbulwe liso, na an'gong'ôla nnyake lino nanang'e agong'olwe lino.’ ");
INSERT INTO kde_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Hambi nangu nìnnyaulilanga kuva, munu akutendedîle lahakalenge unampindikule. Na munu akàkusalau kwa kukupanya likofi nnibuda lya kunkono, nnekele akupindikulile na lya kunchinda. ");
INSERT INTO kde_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Na ikàva munu àlembela akusitaki kulukumbi uchinga atwale nkogo wako, bahi nnekele atwale na likoti lyako mwalehu. ");
INSERT INTO kde_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Munu akàkunamatija unyakula chihapo chake kilometa imo, wako nnyakulile kilometa dimbili. ");
INSERT INTO kde_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Munu akàkuyuwa mwing'e, na munu ambekuyadîka chinu unamwime.” ");
INSERT INTO kde_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mwenu mùnipilikana chiinahaulike kuva, ‘Ntamwe nnyako, na ummenge mmongo mwalo.’ ");
INSERT INTO kde_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Henga nangu nìnnyaulilanga kuva, vatamwange amongo mwenu na kuvayuwila avala vam'baniha mwenu, ");
INSERT INTO kde_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","kwa kutenda uchocho mùùva mmana mmahiu mma Atata wenu wa kulihunde. Kwa kuva, nang'e àvalangajija liduva vanu vatênda lahakalenge na vanu vambone, na kuvatonyela imbula vanu vatênda lalalembela Nnungu na vanu vakátenda lalalembela Nnungu. ");
INSERT INTO kde_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ikàva mùvatamwa chihi vanu vantamwânga mwenu, dachi, mùmbepata inujo ntwani kwa Nnungu? Kwa kuva, ata vakútwala kodi na vanang'o vàtendanga uchocho! ");
INSERT INTO kde_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ikàva mùvasalimila chihi vakúkulupila avenu, dachi chinu ntwani chinji chimuchitenda kupunda vanu vanji? Ata vanu vakámmaite Nnungu vàtenda uchocho. ");
INSERT INTO kde_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Bahi mùlembelewa mùùve mmanu mmakukamilika malinga Atata wenu wa kulihunde chakamilike.” ");
INSERT INTO kde_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Lyongolelange uyopa munatenda lambone pameho pa vanu uchinga vannolange. Mukàtenda uchocho, Atata wenu wa kulihunde nanga pambemwing'a dinujo. ");
INSERT INTO kde_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Bahi paunnyangata mmahuvani, unalihaulange kwa vanu kwa kwombela lipenga muchi vakulilambilila chivatenda n'ding'ande dya kunnyuwila Nnungu na mmadila uchinga valombolewe na vanu. Nangu nìnnyaulilanga uhiu kuva, vanang'o tayali vànipata inujo yavo. ");
INSERT INTO kde_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Henga wako paunnyangata mmahuvani, ìlembelewa kananga nkono wako wa kunchinda unamale chiutenda nkono wako wa kunkono. ");
INSERT INTO kde_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Paunnyangata mmahuvani, nnyangate kwa sili, na Atatako alôna àlalá laulatenda kwa sili achiakwing'e dinujo.” ");
INSERT INTO kde_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Pamuyuwa munatende muchi vakulilambilila chivatenda. Vanang'o vananowelwa kwimila na kuyuwa n'ding'ande dya kunnyuwila Nnungu na nnyenje dindila uchinga vanu vavone. Nangu nìnnyaulilanga uhiu kuva, vanang'o tayali vànipata inujo yavo. ");
INSERT INTO kde_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Henga wako puyuwa, injila nchumba chako, uchime nnango, koka unnyuwe Atatako akáonekana. Na Atatako, achôna anecho chutenda kwa sili achiakwing'e inujo yako. ");
INSERT INTO kde_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Pamuyuwa, munatangole malove lohe lákuuila-uila muchi vanu vakámmaite Nnungu chivatenda. Vanang'o vàtenda kuva Nnungu achiavapilikane ing'anya ya malove lavo lohe. ");
INSERT INTO kde_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Munatende muchi vanang'o, kwa kuva, Atata wenu ànilamala lamusikikidile kabla mwenu mukànambinnyuwa. ");
INSERT INTO kde_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Bahi mwenu yuwanga uvila, ‘Atata wetu uvêle kulihunde, lina lyako litumbyangwe. ");
INSERT INTO kde_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ufalume wako uide. Na apano pachilambo, latendeke àlalá lulalembela wako, malinga chilatendeka aneko kulihunde. ");
INSERT INTO kde_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Utwing'e nelo chakulya chimbetutoleja kwa nelo. ");
INSERT INTO kde_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Utusamehe makosa letu, muchi hwetu chituvasamehe vanu vatukosêla. ");
INSERT INTO kde_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Na patulingwa, unatuleke ututenda masambi, henga utupohe mmakono mwanga Nanchindenga. Kwa kuva, Ufalume na dimongo na ukulu nni vyako, vyaka na vyaka. Amina.’ ");
INSERT INTO kde_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Mukàvasamehe vanu vankosêla mwenu, uchocho na Atata wenu wa kulihunde achiansamehe mwenu makosa lenu. ");
INSERT INTO kde_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Henga mukánavasamehe vanu vankosêla mwenu, na Atata wenu wa kulihunde akambensamehe mwenu makosa lenu.” ");
INSERT INTO kde_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Pamufunga, munayundale muchi vakulilambilila chivatenda. Vanang'o vakungunyaja kumeho kwavo uchinga vapate kwonekana na vanu kuva vanafunga. Nangu nìnnyaulilanga uhiu kuva, vanang'o tayali vànipata inujo yavo. ");
INSERT INTO kde_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Henga wako paufunga, kalava medi kumeho na ulipakale mahuta mmuti, ");
INSERT INTO kde_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","uchinga vanu vanamale kuva wako unifunga, ila umaikane chihi na Atatako akáoneka. Na Atatako alôna anelo laulatenda kwa sili achiakwing'e inujo yako.” ");
INSERT INTO kde_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Munalikondeje dimali dyohe apano pachilambo. Apano pachilambo vakoko vànaondonganga na ing'ange ìnaondonganga, na vakwiva vanatutumula nkwiva. ");
INSERT INTO kde_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mwenu likondeje dimali dyenu kulihunde, aneko vakoko vakáondonganga na ing'ange ikáondonganga, na wala vakwiva vakáhulula kututumula, nkwiva. ");
INSERT INTO kde_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kwa kuva, apala padivele dimali dyako njo padimbeloleha ding'ano dyako. ");
INSERT INTO kde_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Meho njo chibatali cha mmili. Bahi meho lako lakàva lumi, mmili wako wammalele ùmbeumbala nng'anje. ");
INSERT INTO kde_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Henga meho lako lakàondongeka, mmili wako wammalele ùmbekuva nnupi. Bahi ikàva nng'anje uvêle nkati mwako ùnipindikuka kuva lupi, bahi anelwo nni lupi lwa kuyoha! ");
INSERT INTO kde_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Nanga munu ahulûla kuvatumikila anang'olo vavili. Kwa kuva, akàtenda uchocho àmbenchima yumo na kuntamwa yunji, au àmbekamulana na yumo na kummenga yunji. Mwenu mukambehulula kuntumikila Nnungu akuno umuditumikila na dimali. ");
INSERT INTO kde_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Bahi nangu nìnnyaulilanga kuva, munààve na lipamba ing'anya ya maisha lenu, kuva mùmbekulya chani au mùmbekumbila chani, au kuyamba miili yenu, kuva mùmbewala chani. Kwa kuva, maisha lenu nni la mana namene, akee chihi kwajili ya chakulya weka. Na miili yenu nni ya mana namene, akee chihi kwajili ya dinguwo weka. ");
INSERT INTO kde_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Valolange vyuni. Vanang'o nanga pavapanda wala nanga pavafuna, na wala nanga pavakondya chinu chohecho nnichehe. Pamo na anelo, Atata wenu wa kulihunde ànavalisa. Dachi, mwenu mukee mmamana namene kupunda vyuni? ");
INSERT INTO kde_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Alida mmwenu kwa kulikambya-kambya namene ànahulula kuyenjeja kananga lisaa limo mmaisha lake? ");
INSERT INTO kde_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Mwadachi mùùva na lipamba ing'anya ya dinguwo? Lolanga mauwa la kunnyitu chilakulumuka. Wala nanga palakola madengo na wala nanga palalitotela lene dinguwo. ");
INSERT INTO kde_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Henga nangu nìnnyaulilanga kuva, ata Nfalume Selemani pamo na ukulu wake wanavele nawo, henga nanga panawahite kuwajwa saana muchi liuwa limo mmauwa anelo. ");
INSERT INTO kde_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Mwenu mmanu muvêle na ing'ulupa inyoko, ikàva Nnungu àlawaja uchocho mauwa la kumawelu, lapwâwa chihi nelo, nundu nkuyahwa mmoto, dachi Nnungu akambepunda kummwajanga mwenu saana? ");
INSERT INTO kde_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Bahi munààve na lipamba, umuchidoni, ‘Tùmbekulya chani,’ au ‘Tùmbekumbila chani,’ au ‘Tùmbewala chani!’ ");
INSERT INTO kde_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kwa kuva, anelo lammalele njo lavátàhà vanu vakámmaite Nnungu. Henga Atata wenu wa kulihunde ànimala kuva mùnisikikila anevyo vyammalele. ");
INSERT INTO kde_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Henga tandilika kuukambi-kambila Ufalume wanga Nnungu na àlalá lalalembela Nnungu hoti, nanang'e achiamwing'ange anelo lammalele. ");
INSERT INTO kde_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Bahi munààve na lipamba kwajili ya liduva lya nundu, kwa kuva, mambo la nundu nni la nundu, na la nelo nni la nelo. Kulikambya-kambya na mambo la nelo kunatosa kwa nelo.” ");
INSERT INTO kde_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Munavahukumu vanu vanji ili Nnungu anannyukumu mwenu. ");
INSERT INTO kde_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Malinga chimuvahukumu vanu vanji, nni uchocho Nnungu chambennyukumu mwenu, na chipimo chimutumila kuvahukumila vanu vanji njo uchocho chambetumila Nnungu kunnyukumu mwenu. ");
INSERT INTO kde_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mwadachi ùuloleha nswani uvêle nniso lya nnung'uno, akuno lukongolo luvêle nniso lyako ukàlwònà? ");
INSERT INTO kde_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ùmbehulula dachi kunnyaulila nnung'uno kuchi, ‘Nnung'unwangu, nahoti nikuuse chipatu chivêle nniso lyako,’ akuno umwene uvèlè na lukongolo nniso lyako? ");
INSERT INTO kde_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nkúlilambilila wako! Tandilika kuluusa lukongolo luvêle nniso lyako nahoti, na anepo njo pumbelola saana na kuchiusa chipatu chivêle nniso lya nnung'uno. ");
INSERT INTO kde_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Munaveng'e vitukutuku vyanaswe vanu vakávele vanaswe, uyopa vanampindikukila na kunnumanga muchi chivaluma ang'avanga. Na wala munavayelele vitukutuku vyambone vanu vakávele vambone, uyopa vànavikadamba kwa madodo lavo muchi anguluve chivakadamba vitukutuku.” ");
INSERT INTO kde_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Yuwanga, na Nnungu achiamwing'ange, tahanga na mwenu muchimupate, hodikanga na mwenu muchimuchimuliwe. ");
INSERT INTO kde_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kwa kuva, kila munu ayûwa ànapewa, na atâha ànapata, na ahodîka ànachimuliwa. ");
INSERT INTO kde_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Alida mmwenu, mwanawe akànnyuwa nkate, nang'e àmwing'a liyanga? ");
INSERT INTO kde_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Au akànnyuwa uhomba, nang'e àmwing'a nnyongo? ");
INSERT INTO kde_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ikàva mwenu mmakutenda masambi, mùnimala kuveng'a vavana venu vitukutuku vikatapele, dachi Atata wenu wa kulihunde akambepunda namene kuveng'a vitukutuku vikatapele avala vannyûwa? ");
INSERT INTO kde_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Chimulembela vanu vantendele mwenu, na mwenu vatendele vanang'o uchocho, kwa kuva, aino njo mana ya mahundo la Sheliya ya Musa na manabii.” ");
INSERT INTO kde_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Injilanga kwa kupitila nnango uhonene, kwa kuva, nnango na indila ilôja kukuondongwa ìnidalambuka na vanu vapitîla indila aneyo, nni vohe. ");
INSERT INTO kde_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Henga nnango wa kwinjilila kuumi ùnihonana na indila ilôja aneko ìnihonana, na vanu vayôna indila aneyo vàvele chihi kadiki.” ");
INSERT INTO kde_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Lyongolelange na manabii va kulambila. Vamwidîla akuno uvaonekana muchi angandolo kwa pawelu, henga nkati mwavo nni mahoha lakalipa. ");
INSERT INTO kde_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Bahi muchimuvamale kwa vihepo vyavo. Dachi, vanu vàhepa zabibu n'diheya au vàhepa tini mmbigili? ");
INSERT INTO kde_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Bahi kila nnandi wambone ùpa vihepo vyambone, na kila nnandi ukee wambone ùpa vihepo vikee vyambone. ");
INSERT INTO kde_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nnandi wambone ukápa vihepo vikee vyambone, na nnandi ukee wambone nanga paupa vihepo vyambone. ");
INSERT INTO kde_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kila nnandi ukápa vihepo vyambone umbecheketwa na kuyahwa mmoto. ");
INSERT INTO kde_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Bahi muchimuvamale manabii va kulambila kwa àlalá lávatendânga. ");
INSERT INTO kde_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Akee kila munu anguchêma nangu, ‘Nang'olo, Nang'olo,’ ambekwinjîla mu Ufalume wa Nnungu, henga vambekwinjîla nni avala vatênda àlalá lalalembela Atatangu avêle kulihunde bahi. ");
INSERT INTO kde_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nniduva anelyo lya hukumu, vanu vohe vàmbenguhaulila kuchidoni, ‘Nang'olo, Nang'olo! Kwa lina lyako twanihumya unabii, na kwa lina lyako twanivahumya vanu anamindenga na kutenda masaibu!’ ");
INSERT INTO kde_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Anepo njo panimbevahaulila kuchidoni, ‘Mwiko nangu nikánkamekenge mwenu! Ukananga apano pang'une, mwenu mmanu mutênda lahakalenge!’ ” ");
INSERT INTO kde_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Bahi kila munu apilikanîla mahundo langu na kutenda muchi chahundwije, aneyo àlandana na munu avêle na ding'ano adengîle ing'ande yake nniyanga likulungwa. ");
INSERT INTO kde_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Imbula nkutonya, livambwe nkuida, lipungo nkupunga nkuiguma ing'ande aneyo. Henga nanga painayangwike kwa kuva nsingi wake údengwije muha liyanga likulungwa. ");
INSERT INTO kde_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Henga kila munu apilikâna mahundo langu, koka anatende muchi chahundwije, aneyo àlandana na munu walivelu, adengîle ing'ande yake pannima ulongo. ");
INSERT INTO kde_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Imbula nkutonya, livambwe nkuida, lipungo nkupunga na kuiguma aila ing'ande, nkuyanguka na kubamoka mwalehu.” ");
INSERT INTO kde_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Bahi Yesu pamalidile kutangola anelo lammalele, makuwa la vanu nkukangana namene namuna chachivahunda, ");
INSERT INTO kde_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kwa kuva, ávahunda muchi munu avêle na mamulaka, na akee muchi vakúhunda vao va Sheliya. ");
INSERT INTO kde_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu pasulupwike nnichinga, makuwa makulungwa la vanu lánimpapata. ");
INSERT INTO kde_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nkuida munu yumo avêle na mangundula, nkutindivala malundi muyo mwanga Yesu nkunnyaulila kuchidoni, “Nang'olo, ukàlembela ùnahulula chihi unguhahulanga kwa kungulamya.” ");
INSERT INTO kde_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu nkunyoloja nkono wake, nkun'gusa aneyo munu, nkuhaula kuchidoni, “Elo nalembela, lama.” Upala ayula munu, nkulama mangundula lake. ");
INSERT INTO kde_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Bahi Yesu nkunnyaulila ayula munu kuchidoni, “Kaleha, unannyaulile munu woheyo, henga wako hwena ukalilanguje kwanga kuhani, na ukahumye sadaka muchi chalaijije Musa, uchinga vanu vamale kuva ùnihahulwa.” ");
INSERT INTO kde_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu painjidile muimanga ya Kapelinaumu, nkulu wa matiyala myamoja la Valoma nkummwenela Yesu, nkunnyuwa annyangate. ");
INSERT INTO kde_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Nkunnyaulila kuchidoni, “Nang'olo, ntumishi wangu ànilala kukaya, ànididimanga na ànauula namene.” ");
INSERT INTO kde_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu nkunnyaulila kuchidoni, “Nguchinguide nikannamye.” ");
INSERT INTO kde_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nkulu aneyo nkunnyaulila Yesu kuchidoni, “Nang'olo, kwa kuva wako ni nkulu, nangu nikáfala wala kadiki kukupwechelela wako nng'ande mwangu. Henga wako tangola chihi lilove, na ntumishi wangu achialame. ");
INSERT INTO kde_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kwa kuva, ata nangu nimwene nni munu nguvêle pahi pa mamulaka la vakulu, na pàvele na matiyala vavêle pahi pangu. Nikànnyaulila yumo kuchi, ‘Hwena!,’ ànahwena, na nikànnyaulila yunji kuchi, ‘Ida!,’ ànaida, na nikànnyaulila ntumishi wangu kuchi, ‘Tenda achino!,’ ànatenda.” ");
INSERT INTO kde_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu papilikene anelo nkukangana namene, nkuvahaulila avala vachinnondola kuchidoni, “Nangu nìnnyaulilanga uhiu kuva, nikánambimwona munu muvanu va Isilaeli avêle na ing'ulupa ing'ulungwa malinga ayi. ");
INSERT INTO kde_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nangu nìnnyaulilanga kuva, vanu vohe vakee Vayahudi vàmbeida kuhaloka mashaliki na mangalibi, vambeikala na kulya paing'ole chalumo na Iblahimu na Isaka na Yakobo mu Ufalume wa Nnungu. ");
INSERT INTO kde_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Henga Vayahudi vohe, avala vachilembelewa vàavè mu Ufalume wa Nnungu vàmbeyahwa pawelu, nnupi, aneko vàmbekuta na kuhaya meno.” ");
INSERT INTO kde_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Bahi Yesu nkunnyaulila ayula nkulu wa matiyala kuchidoni, “Hwena kukaya, na ìtendeke kwakuwe muchi chukulupidile.” Upala ntumishi wake nkulama. ");
INSERT INTO kde_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu painjidile nng'ande mwa Petulo, nkumwona nkawake Petulo àlelé pachinanda, wauula chidumba. ");
INSERT INTO kde_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu nkun'gusa munkono wake na chidumba nkunneka, nanang'e nkuimila nkutandilika kunnyudumila Yesu. ");
INSERT INTO kde_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Palihwikile lyulo, vanu nkumpelekejije Yesu vanu vohe vavêle na anamindenga, nang'e nkuvausa anamindenga kwa kutangola chihi lilove na kuvalamya vagonjo vammalele. ");
INSERT INTO kde_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Anelo lánitendeka uchinga latimile malove lanatangwele nabii Isaya kuva, “Mwene átwete idabadangi yetu na kulitika magonjo letu lammalele.” ");
INSERT INTO kde_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu paliwene likuwa likulungwa lya vanu lin'dingwìkè, nkuvaamulisa vakuhundwa vake ahwene navo m'bali wavili wa litanda. ");
INSERT INTO kde_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Bahi nkúhundwa yumo wa Sheliya ya Musa, nkummwenela Yesu, nkunnyaulila kuchidoni, “Nkúhunda, nìmbekulondola kwoheko kumbehwena.” ");
INSERT INTO kde_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu nkunnyang'ula kuchidoni, “Macheta làvele na vivava na vyuni vìvele na vitehi, henga Mwana wa Munu, akávele na pachinu pakuyewelela.” ");
INSERT INTO kde_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nkúhundwa wake yumo nkuchidoni, “Nang'olo, nguleke hoti nguhwene nikansike atatangu.” ");
INSERT INTO kde_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Henga Yesu nkunnyaulila kwa nfano wachidoni, “Ngupapate, valeke vanu vavêle muchi vànihwa vavasike vahwîle avao.” ");
INSERT INTO kde_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Anepo Yesu nkwenda muingalava, nkupapatana na vakuhundwa vake. ");
INSERT INTO kde_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Upala nkulindamuka chimbunga chikulungwa amula nnitanda, medi nkulindamuka kwinjila muingalava, na Yesu ávele alèlè luwono. ");
INSERT INTO kde_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Vakuhundwa vake nkummwenela, nkumwimula, uvachidoni, “Nang'olo, tupohe, tùvenkuhwa!” ");
INSERT INTO kde_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu nkuvayang'ula kuchidoni, “Mwenu mmanu muvêle na ing'ulupa inyoko, mwadachi mùnayopa?” Bahi Yesu nkutakatuka, nkuliamulisa lipungo na mawimbi vitungamane, navinang'o nkutungamana na kunyalalika nduu. ");
INSERT INTO kde_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Vanu vammalele nkukangana, uvachidoni, “Dachi, ayu munu wa namuna ntwani? Ata lipungo na mawimbi lànampilikana!” ");
INSERT INTO kde_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu pahwikile m'bali wavili wa litanda, nchilambo cha Vagadala, nkukojana na vanu vavili vavêle na anamindenga, uvahaloka ya kumisati. Vanu anevo vánayopwa namene, na nanga munu analingile kupita indila aneyo. ");
INSERT INTO kde_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Upala, nkulindamuka unonoha malidi uvachidoni, “Ùndambela chani wako Mwana wa Nnungu? Dachi, wako widîle unatubaniha kabla lakànambihwika maduva letu?” ");
INSERT INTO kde_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Pepi na pachinu anepo, pávele na likuwa likulungwa lya dinguluve dichilitahija vilyo. ");
INSERT INTO kde_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Anevo anamindenga nkunnyuwa namene Yesu uvachidoni, “Ukàtuhumya, tuhaulile tukadyende dinguluve.” ");
INSERT INTO kde_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu nkuvahaulila kuchidoni, “Hweneng'ana!” Bahi nkuvauka, nkunadyenda dinguluve, na dinguluve dyammalele nkuhelelekela kumakobikobi makulungwa, nkutubukila nnitanda na vammalele nkuhwa mmedi. ");
INSERT INTO kde_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bahi vachúnga va dinguluve nkutukuta mpaka kumanga, nkuvahaulila vanu àlalá lammalele, na kila chinu chivakojîje avala vanu vavêle na anamindenga. ");
INSERT INTO kde_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Bahi vanu vammalele nkuhwena uchinga vakakojane na Yesu. Na pavakojene nawe, nkunnyuwa namene auke nchilambo chavo. ");
INSERT INTO kde_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu nkwenda muingalava, nkuyomboka litanda, nkuhwika kuimanga yachiikala. ");
INSERT INTO kde_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Aneko vanu nkumpelekejija munu yumo adidimênge, akuno alajìjwè nchinanda. Yesu paiwene ing'ulupa yavo, nkunnyaulila ayula munu adidimênge kuchidoni, “Likamye ntima mwanangu! Ùnisamehewa masambi lako.” ");
INSERT INTO kde_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Upala, vakúhunda vanji va Sheliya ya Musa nkutandilika kutangola chimundamunda uvachidoni, “Ayu munu ànkufulu Nnungu!” ");
INSERT INTO kde_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu ánilamala lavachiliuja, nkuhaula kuchidoni, “Mwadachi mùliuja lahakalenge mmitima mwenu? ");
INSERT INTO kde_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Lilida lipeyapeya namene, kuhaula kuva, ‘Ùnisamehewa masambi lako,’ au kuhaula kuva, ‘Imila uhwene?’ ");
INSERT INTO kde_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Henga kwa kunnamya munu ayuno, nangu ngùlembela ngùmaihe kuva, Mwana wa Munu àvele na mamulaka la kuvasamehe vanu masambi lavo apano pachilambo.” Bahi nkunnyaulila ayula munu adidimênge kuchidoni, “Imila utwale chinanda chako, uhwene kukaya kwako.” ");
INSERT INTO kde_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Anepo ayula munu nkuimila, nkuhwena kukaya kwake. ");
INSERT INTO kde_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Likuwa lya vanu pavalawene latendeke, nkukangana na kuyopa, nkunnombolela Nnungu avapêle vanu mamulaka anelo. ");
INSERT INTO kde_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu nkuuka anepo, na pánavele nkuhwena, nkumwona nkútwala kodi yumo uvanchema Matayo, aikèlè paing'ande ya kulipila kodi. Yesu nkunnyaulila kuchidoni, “Ngupapate.” Matayo nkutakatuka, nkumpapata Yesu. ");
INSERT INTO kde_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesu pánavele nkulya kuing'ande yanga Matayo, vakútwala kodi vohe na vanu vanji vahaulîka kuva nni vanu vavêle na masambi, vániida nkulya pamo na Yesu na vakuhundwa vake. ");
INSERT INTO kde_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mafalisayo pavalawene anelo, nkuvauja vakuhundwa vake kuchidoni, “Mwadachi nkúhunda wenu àlya pamo na vakútwala kodi na vanu vavêle na masambi?” ");
INSERT INTO kde_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu papilikene uchocho, nkuvahaulila kuchidoni, “Vanu vakáuula nanga pavannembela n'ganga, ila vanu vauûla njo vannembêla n'ganga. ");
INSERT INTO kde_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Henga hweneng'ana mukalihunde mana la Malemba Lanaswe lahaûla kuva, ‘Ngùlembela muvalanguje vanji chididi, akee unguhumija chihi sadaka.’ Nangu nikáidile unavachema vanu vatênda àlalá lalalembela Nnungu, ila ngùidile unavachema vanu vavêle na masambi.” ");
INSERT INTO kde_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Anepo vakuhundwa vanga Yohana Nkúbatisa nkuhwena unamuja Yesu kuchidoni, “Mwadachi, hwetu na Mafalisayo tùnafunga, henga vakuhundwa vako vakáfunga?” ");
INSERT INTO kde_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu nkuvayang'ula kuchidoni, “Vanu vakúmbuliwije kuing'ole ya ulombi vàmbeyundala dachi, mwene nnombi avèlè pamo na vanang'o? Ikáhululika! Henga uhiku uchiukamole nnombi pambetwaliwa muvanang'o, anepo njo pavambefunga. ");
INSERT INTO kde_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nanga munu atotêla chilaka cha inguwo yahambi nnipindi. Kwa kuva, chilaka anecho chahambi chìmbekungunyala na kuhalija kupamola anelyo lipindi, na pachinu panapomweke pambeyenjejeka. ");
INSERT INTO kde_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Uchocho, wala nanga munu atâya divayi dyahambi mmipatila ya tangu ya limbende. Akàtenda uchocho, aila mipatila ìnapwapuka ing'anya ya kuhaha kwa divayi, na divayi dìnamwadilika, na mipatila nkwondongeka. Henga vanu vàtaya divayi dyahambi mmipatila yahambi, na vyammalele vivili vìnachungika.” ");
INSERT INTO kde_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu pachitangola malove anelo, nkuhaloka nkulu yumo wa ing'ande ya kunnyuwila Nnungu, nkutindivala malundi muyo mwanga Yesu, nkuhaula kuchidoni, “Nahaku wangu ànihila uvino. Vino tuhwene ukammikile nkono wako, nanang'e achifufuke.” ");
INSERT INTO kde_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu pamo na vakuhundwa vake nkutakatuka, nkupapatana nawe. ");
INSERT INTO kde_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mmahe yumo ánavele na ugonjo wa kuhuma myadi kwa vyaka kumi na mbili, nkunnyidila Yesu kwa kumongo, nkugusa lupepe lwa lijoho lyawete Yesu. ");
INSERT INTO kde_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Aneyo mmahe nkulitangolela chimundamunda kuva, “Nikàgusa chihi lijoho lyake nguchingulame.” ");
INSERT INTO kde_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu nkupindikuka, nkummwona aneyo mmahe, nkunnyaulila kuchidoni, “Mwanangu, likamye ntima! Ing'ulupa yako ìnikulamya.” Upala, ayula mmahe nkulama. ");
INSERT INTO kde_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu painjidile nng'ande mwa ayula nkulu, nkuvona vakwómba vimbeta vya kulikutangila, pamo na likuwa lya vanu uvalikutangila. ");
INSERT INTO kde_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yesu nkuvahaulila kuchidoni, “Humang'ana! Mwana akáhidile, àlelé chihi luwono.” Vanang'o nkunnyeka. ");
INSERT INTO kde_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Henga likuwa lya vanu palihumanenge, Yesu nkwinjila kuchumba kwavele nahaku, nkunkamula nkono, ayula nahaku nkuimila. ");
INSERT INTO kde_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Habali aneyo nkuyanjala nchilambo anecho chammalele. ");
INSERT INTO kde_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Bahi Yesu nkuuka anepo, na pánavele nndila, vanu vavili vaputêle meho nkumpapata uvanonoha lidi, uvachidoni, “N'dukuluwe Nfalume Daudi, tùvikile chididi!” ");
INSERT INTO kde_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu painjidile nng'ande, vanu vavili vaputêle meho nkummwenela, Yesu nkuvauja kuchidoni, “Dachi, mùnakulupila kuva nangu nàhulula kunnamya?” Vanang'o nkunnyang'ula kuchidoni, “Elo, Nang'olo.” ");
INSERT INTO kde_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Anepo Yesu nkuvagusa meho lavo, nkuhaula kuchidoni, “Ìtendeke muchi chimukulupila.” ");
INSERT INTO kde_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Meho lavo nkukusumbuka. Yesu nkuvaduma wachidoni, “Lyongolelange munannyaulile munu woheyo.” ");
INSERT INTO kde_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Henga vanang'o nkuukananga, nkuhwena unayanjaja habali dya Yesu nchilambo achila chammalele. ");
INSERT INTO kde_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Vanu avala vavili pavachiukananga, bahi vanu vanji nkumpelekejija Yesu munu bubu avêle na nanndenga. ");
INSERT INTO kde_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Bahi Yesu pammusije ayula nanndenga, ayula munu ánavele bubu nkutandilika kutangola. Makuwa la vanu nkukangana, nkuhaula kuchidoni, “Chitendo malinga achi chikánambikwoneka nchilambo achino cha Isilaeli!” ");
INSERT INTO kde_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Henga Mafalisayo nkuhaula kuchidoni, “Nanchindenga, nkulu wa anamindenga njo annyululîha nang'e kuvausa anamindenga.” ");
INSERT INTO kde_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Bahi Yesu nkudinguka n'dimanga dyammalele na mmijiji, wavahunda vanu n'ding'ande dyavo dya kunnyuwila Nnungu na kuvahubilila Malove Lambone layâmba Ufalume wanga Nnungu, na kulamya kila namuna ya ugonjo na kila namuna ya kuhuvanga. ");
INSERT INTO kde_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesu palawene makuwa la vanu, nkuvavikila chididi ing'anya vánibanika namene na kuyuvala muchi angandolo vakávele na nchunga. ");
INSERT INTO kde_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Anepo Yesu nkuvahaulila vakuhundwa vake kuchidoni, “Mafuno làvele lohe, henga vakúfuna vàvele kadiki. ");
INSERT INTO kde_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Bahi nnyuwange Nang'olo wa mafuno avatume vakúkola madengo vanji, mmwelu wake.” ");
INSERT INTO kde_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Bahi Yesu nkuvachema vakuhundwa vake kumi na mbili, nkuveng'a mamulaka la kuvausa anamindenga na kulamya magonjo la kila namuna na ihuvangi ya kila namuna. ");
INSERT INTO kde_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Alano nni malina la vakuhundwa kumi na mbili vanga Yesu, vanavachemile Yesu kuva mitume, ntandi Simoni uvanchema Petulo, na nnung'une uvanchema Anduleya, na Yakobo mwana wanga Sebedayo pamo na nnung'une uvanchema Yohana, ");
INSERT INTO kde_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","na Filipo, na Batolomayo, na Tomaso, na Matayo ánavele nkútwala kodi, na Yakobo mwana wanga Alufayo, na Sadayo, ");
INSERT INTO kde_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","na Simoni ánavele nnikuwa lya Vaselote, pamo na Yuda Isikaliote ánantengeleke Yesu. ");
INSERT INTO kde_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu nkuvatuma anevo mitume kumi na mbili wavahaulila kuchidoni, “Munahwene kwa vanu vakávele Vayahudi, na wala munainjile n'dimanga dya chilambo cha Samaliya. ");
INSERT INTO kde_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Henga mwenu hweneng'ana kwa vanu va Isilaeli, anevo vavêle muchi angandolo vayahike. ");
INSERT INTO kde_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pamuhwena vahubilile uvila, ‘Ufalume wa Nnungu ùvele pepi.’ ");
INSERT INTO kde_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Valamyange vagonjo na kuvafufula vanu vahwîle na valamyange vàvele na mangundula na kuvausa anamindenga. Mupewije bule, bahi humyanga bule. ");
INSERT INTO kde_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Munanyakule hela yoheyo mmitondo mwenu. ");
INSERT INTO kde_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Munanyakule mpatila wa mwanda, wala nkogo wa akiba, wala vilatu wala isimbo. Kwa kuva, akôla madengo àlembelewa apate àlalá lalasikikidile. ");
INSERT INTO kde_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Imanga yoheyo na chijiji chohecho chimumbeinjila, ntahange munu avêle tayali kumpwechelanga, muikale kwanga nang'e mpaka pamumbeukananga. ");
INSERT INTO kde_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pamumbeinjila muing'ande aneyo, vayuwile vanu va kaya aneyo Nnungu avabaliki. ");
INSERT INTO kde_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Na vanu va kaya aneyo vakàmpwechelela saana, bahi vapwechelele balaka dya amani dimuvayuwidile, henga vakanampwechelele saana, balaka anedyo dya amani dimmuile mwenu mmene. ");
INSERT INTO kde_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Na munu akàhita umpwechelela wala upilikanila malove lenu, pamumbeuka pakaya anepo au paimanga aneyo, vakanange vanu anevo kwa kulipumunanga litutunga lya mmadodo lenu ilangule kuva, vene vànitandola kulahita malove la Nnungu. ");
INSERT INTO kde_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nangu nìnnyaulilanga uhiu kuva, liduva lya hukumu, vanu va imanga aneyo vàmbepata asabu ing'ulu namene kupunda vanu va ku Sodoma na ku Gomola. ");
INSERT INTO kde_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Lola, nangu nìntumanga mwenu muchi angandolo ching'ati vanu vayôha muchi mahoha. Bahi mùlembelewa mukalamuke muchi mihongo, na munaambike ching'ati vanu anevo. ");
INSERT INTO kde_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Lyongolelange na vanu. Kwa kuva, vanang'o vàmbenkamulanga mwenu na kumpelekejanga kulukumbi na kunsulubulanga n'ding'ande dya kunnyuwila Nnungu. ");
INSERT INTO kde_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mùmbepelekejwa kwa vatawâla na kwa vafalume ing'anya yang'une, uchinga mupate kuva mmashahidi vangu kwa vanang'o na kwa vanu vakávele Vayahudi. ");
INSERT INTO kde_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Henga pavambempelekeja kulukumbi, munààve na lipamba namuna chimumbenatangola au chinu chimumbenatangola, kwa kuva, upala, muchimupewe chinu chakutangola. ");
INSERT INTO kde_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kwa kuva, mukambetangola mwenu, ila Umumu wa Atata wenu Nnungu njo ambetangôla kupitila mwenu. ");
INSERT INTO kde_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Munu àmbentengeleka nnung'une awalalwe, na atata àmbentengeleka mwanawe awalalwe, na vavana navanang'o vàmbevapindikuka vavavalêke na kuvatenda vawalalwe. ");
INSERT INTO kde_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Na vanu vammalele vàmbemmenganga mwenu ing'anya yang'une. Henga ambepililîla mpaka kuntululilo, aneyo njo ambepôhwa. ");
INSERT INTO kde_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pamumbebanihwa muimanga imo, tukutila imanga inji. Nangu nìnnyaulilanga uhiu kuva, mukambemalila kupita n'dimanga dyammalele dya Isilaeli, kabla Mwana wa Munu akànambikwida. ");
INSERT INTO kde_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Nkúhundwa akáva nkulu kumpunda nkúhunda wake, wala ntumishi akáva nkulu kumpunda nang'olo wake. ");
INSERT INTO kde_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Henga ìnatosa nkúhundwa kuva muchi nkúhunda wake, na ntumishi kuva muchi nang'olo wake. Ikàva vanu vanji vànguchemile nangu nkulu wa ing'ande kuva Nanchindenga, dachi vanu va nng'ande mwangu vakambehalija kuchemwa malina lahakalenge namene?” ");
INSERT INTO kde_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Bahi munavayope vanu anevo, kwa kuva, kila chinu chihinikwîje chimbehunukulîwa na kila chinu chipihîjwe chimbepisulîwa. ");
INSERT INTO kde_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Chininnyaulila mwenu nnupi, mwenu chihaulange panng'anje, na achila chimupilikana kwa manyinyi, chiyanjajange kwa vanu vammalele. ");
INSERT INTO kde_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Munavayope avala vahulûla chihi kuuwalala mmili, henga vakáhulula uiwalala isungu. Henga nnyopange ayula aondongânga mmili pamo na isungu, mmoto wa Jihannamu. ");
INSERT INTO kde_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Dachi, vyuni vivili vijoko vikásumiswa chihi kwa dihela kadiki? Henga wala nanga chuni chimo chîhwa bila Atata wenu Nnungu kutamwa. ");
INSERT INTO kde_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Henga mwenu ata isabu ya ulindo wa myuti yenu Nnungu àniimala. ");
INSERT INTO kde_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Bahi munayope, kwa kuva, mwenu nni mma maana namene kupunda vyuni vyohe. ");
INSERT INTO kde_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Munu woheyo anguyambukîla nangu muyo mwa vanu kuva, nang'e nni wang'une, na nangu nguchininnyambukile muyo mwa Atatangu avêle kulihunde. ");
INSERT INTO kde_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Henga munu woheyo ambengukâna nangu muyo mwa vanu, na nangu nguchininkane muyo mwa Atatangu avêle kulihunde.” ");
INSERT INTO kde_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Munatende kuva nangu ngùidile unapelekeja amani pachilambo. Nanga, nangu nikáidile unapelekeja amani ila ihapukani. ");
INSERT INTO kde_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kwa kuva, nangu ngùidile unavatenda vanu vahapukane. ‘Mwana wa chilume àmbehapukana na atatake, mwana wa chimahe àmbehapukana na anyokwe, na nkangalombwa àmbehapukana na nkawake. ");
INSERT INTO kde_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Na amongo va munu vàmbekuva avala va nng'ande mwake.’ ");
INSERT INTO kde_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Munu woheyo antâmwa atatake au anyokwe kupunda changutamwa nangu, aneyo akálembelewa kuva nkúhundwa wangu. Na munu woheyo antâmwa mwanawe kupunda changutamwa nangu, aneyo akálembelewa kuva nkúhundwa wangu. ");
INSERT INTO kde_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Na munu woheyo akátamwa kuunyakula nsalaba wake na kuva tayali kuhwa ing'anya yang'une, aneyo akáfala kuva munu wangu. ");
INSERT INTO kde_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Na munu woheyo autâmwa namene umi wake kupunda changutamwa nangu, akambekuva na umi ukee na ntululilo, henga munu akubâli kuhwa ing'anya yang'une, achiave na umi ukee na ntululilo.” ");
INSERT INTO kde_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ampwechelânga mwenu, àngupwechelela nangu, na ayula angupwechelêla nangu, àmpwechelela ayula ángutumîle. ");
INSERT INTO kde_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Munu ampwechelêla nabii, ing'anya ya kuva nang'e nni nabii, àmbepata dinujo dilandâna na dya nabii ayula, na munu ampwechêla munu atênda lalalembela Nnungu, ing'anya ya kuva nang'e nni munu atênda lalalembela Nnungu, àmbepata dinujo dilandâna na dya munu atênda lalalembela Nnungu. ");
INSERT INTO kde_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nangu nìnnyaulilanga uhiu kuva, munu woheyo ambemwîng'a yumo wa ava vajoko, chikombe cha medi ladidimîla, ing'anya ya kuva nang'e nni nkúhundwa wangu, munu aneyo àmbepata dinujo dyake.” ");
INSERT INTO kde_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu pamalidile uvalaija vakuhundwa vake kumi na mbili, nkuuka anepo nkuhwena unahunda na kuvahubilila vanu kudimanga dya chilambo cha ku Galilaya. ");
INSERT INTO kde_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yohana Nkúbatisa pánavele nnilungu, nkupilikana lachitendanga Yesu Kilisto, bahi Yohana nkuvatuma vakuhundwa vake kwanga Yesu, ");
INSERT INTO kde_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","vakammuje kuchidoni, “Dachi, wako njo ayula Mpohi ahaulîka kuva àvenkwida au tunnolele yunji?” ");
INSERT INTO kde_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu nkuvayang'ula kuchidoni, “Uyang'ana, hwena mukannyaulile Yohana àlalá lamupilikene na kulona, ");
INSERT INTO kde_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","vanu vaputêle meho vàvenkulola na vikwavi vìvenkuhwena na vavêle na mangundula vànalama na mimwidi vàvenkupilikana na vanu vahwîle vànafufuka na amahuvani vànahubiliwa Malove Lambone. ");
INSERT INTO kde_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Wasa munu ayula akáleka kungukulupila nangu ing'anya ya àlalá langulatenda.” ");
INSERT INTO kde_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Vakuhundwa vanga Yohana pavachiuka, Yesu nkutandilika kulahaulila makuwa la vanu habali dyanga Yohana wachidoni, “Dachi, pamupite kulilanga unannola Yohana, múlolela muchone chani? Dachi, mútenda àmbekuva muchi imbalu itikînywa na mpapa? Nanga! ");
INSERT INTO kde_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Bahi ikànave uchocho, vino mwapite unalola chani? Munu awête dinguwo dikatapele? Nanga, akee uchocho! Vanu vawâla dinguwo dikatapele vaikâla n'ding'ande dya chifalume. ");
INSERT INTO kde_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Bahi nguhaulile, mwapite unalola chani? Dachi, mwapite unannola nabii? Elo! Henga nangu nìnnyaulilanga kuva, umummwene ni nkulu kumpunda nabii. ");
INSERT INTO kde_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yohana njo n'jumbe achiyambwa Mmalemba Lanaswe, Nnungu pachihaula kuchidoni, ‘Nangu nìmbentuma n'jumbe wangu akulongolelee, aneyo njo ambekukatapajîja indila yako.’ ");
INSERT INTO kde_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nangu nìnnyaulilanga uhiu kuva, muvanu vavelekwejîje na mmahe, nanga munu nkulu kumpunda Yohana Nkúbatisa. Henga ayula avalangîwa kuva n'joko kupunda vammalele mu Ufalume wa Nnungu, aneyo njo nkulu kumpunda Yohana Nkúbatisa. ");
INSERT INTO kde_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kutandikila maduva lachihubili Yohana Nkúbatisa mpaka hambi, vanu vànautahuka namene Ufalume wa Nnungu, na vanu vakálee isungu vànalinga kuuhavila kwa dimongo. ");
INSERT INTO kde_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kwa kuva, kabla Yohana Nkúbatisa akànambikamola, Sheliya ya Musa na manabii vánilauja kuyamba mahiku alano. ");
INSERT INTO kde_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Na ikàva mùnahulula kukulupila, bahi Yohana njo Eliya uvachinnyaula manabii kuva àmbeida. ");
INSERT INTO kde_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Avêle na makutu la kupilikana, apilikane! ");
INSERT INTO kde_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Dachi, nivalandanye na chani vanu va chívelèkwà achino? Vàlandene na vavana vaikalênge kusakoni uvavahaulila vavana avao kuva, ");
INSERT INTO kde_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Twanimwombelanga vimbeta, henga nanga pamunavinite! Twaniimba dihimu dya kulikutangila, henga nanga pamunakutile!’ ");
INSERT INTO kde_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kwa kuva, Yohana Nkúbatisa àniida, nang'e àjukile chihi munu wa kufunga-funga na wala akákumbila divayi, henga vanu vàhaula kuva, ‘Yohana àvele na nanndenga.’ ");
INSERT INTO kde_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Henga Mwana wa Munu àniida, walya na kukumbila, henga vanu vàhaula kuva, ‘Ayu munu nni nkúlya uwamba na nkúkalewa, nnyanjawavo vakútwala kodi na vanu vavêle na masambi!’ Henga lúnda lwa Nnungu lùmaihwa kuva lwambone kupitila vitendo vya vanu vavêle na lúnda anelwo.” ");
INSERT INTO kde_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Anepo Yesu nkutandilika kuvaduma vanu va dimanga dyanatendile masaibu lohe, ing'anya nanga pavanalekile kutenda masambi wachidoni, ");
INSERT INTO kde_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ole wenu mwenu mmanu mma kuimanga ya Kolasini! Ole wenu mwenu mmanu mma imanga ya Betisaida! Kwa kuva, ikàchiva masaibu latendêke kwenu mwenu, ulatendeka kuimanga ya Tilo na ku Sidoni, vanu vake vakaniwala magunila na kulipakalanga liu, kulanguja kuva vànileka kutenda masambi. ");
INSERT INTO kde_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Henga nangu nìnnyaulila kuva, liduva lya hukumu, mwenu mùmbepata asabu ing'ulu namene kupunda vanu va ku Tilo na ku Sidoni. ");
INSERT INTO kde_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Na mwenu mmanu mma imanga ya Kapelinaumu, dachi mùtenda kuva mùmbekwejwa mpaka muha kulihunde? Nanga, mùmbesulupuhwa mpaka pachinu pavanu vahwîle! Kwa kuva, kuikave masaibu latendêke kwenu mwenu, lakàchitendeka ku Sodoma, vanu va imanga aneyo vakàvechinkupwawa mpaka nelo. ");
INSERT INTO kde_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Henga nìnnyaulila kuva, liduva lya hukumu, mwenu mùmbepata asabu ing'ulu namene kupunda vanu va imanga ya ku Sodoma.” ");
INSERT INTO kde_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Upala Yesu nkutangola kuchidoni, “Atata, Nang'olo wa kulihunde na pachilambo, nakulombolela kwa kuva, vitukutuku anevyo ùvapihite vanu vavêle na lúnda na vavêle na elimu, nkuvahunukulila vanu vavêle na mitima ivêle muchi vana vajoko. ");
INSERT INTO kde_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Elo Atata, kwa kuva njo chukatapaliwije wako.” ");
INSERT INTO kde_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yesu nkuvahaulila vanu kuchidoni, “Atatangu àngupele vitukutuku vyammalele. Nanga munu ammaîte Mwana ikànave chihi Atata, na wala nanga munu ammaîte Atata ikànave chihi Mwana chalumo na munu woheyo wantandwele Mwana kunnyunukulila. ");
INSERT INTO kde_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Idang'ana kwang'une mmanu mmammalele muhopedile namene na kutemwa na misigo iidopa, nangu nguchininnyeweleje. ");
INSERT INTO kde_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mukubali kulojwa na nangu malinga chalojwa ung'ombe akàhungwa likongwa, na mulapapate mahundo langu kwa kuva nangu nni mpole na ngùvele na ntima wa kulisulupuha, na mwenu muchimuyewelejwe mmitima yenu. ");
INSERT INTO kde_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kwa kuva, likongwa lyangu likápwateka, na nsigo wangu unapeyapeya.” ");
INSERT INTO kde_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Liduva limo lya Kuyewelela, Yesu ápita n'dindila dya mmawelu la ngano. Na vakuhundwa vake vávele na indala, nkutandilika kupulula ngano na kutang'una. ");
INSERT INTO kde_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mafalisayo pavalawene anelo, nkunnyaulila Yesu kuchidoni, “Lola, vakuhundwa vako vàtenda àlalá lakáluhusiwije na Sheliya ya Musa kutendwa Nniduva lya Kuyewelela.” ");
INSERT INTO kde_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu nkuvayang'ula kuchidoni, “Dachi, mwenu nanga pamusomile chanatendile Nfalume Daudi, nang'e pamo na vavake pavanavele na indala? ");
INSERT INTO kde_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nang'e áingidile pa Ing'ande yanga Nnungu. Nang'e na vavake nkulya mikate ihumîjwe kwanga Nnungu, ikanava nanga painaluhusiwije na Sheliya ya Musa kuliwa na munu yunji ila makuhani weka. ");
INSERT INTO kde_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Dachi, mukánambisoma mu Sheliya yanga Musa kuva Liduva lya Kuyewelela makuhani vànailumula Sheliya kwa kukola madengo mu Ing'ande yanga Nnungu? Henga nanga munu avasitâki kuva vàilumwile sheliya ya Liduva lya Kuyewelela. ");
INSERT INTO kde_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Hambi nìnnyaulila kuva, apano pàvele munu nkulu kupunda Ing'ande yanga Nnungu. ");
INSERT INTO kde_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Malemba Lanaswe làhaula kuva, ‘Ngùlembela muvalanguje vanji chididi, akee unguhumija chihi sadaka.’ Mukàchimala mana la malove anelo, mukánavahukumu vanu vakávele na makosa. ");
INSERT INTO kde_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kwa kuva, Mwana wa Munu njo Nang'olo avêle na mamulaka ata Nniduva lya Kuyewelela.” ");
INSERT INTO kde_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu nkuuka anepo, nkuinjila muing'ande yavo ya kunnyuwila Nnungu, ");
INSERT INTO kde_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","anemwo múvele na munu yumo ánavele na nkono udidimenge. Vanu nkummuja Yesu kuchidoni, “Dachi, Sheliya ya Musa ìnaluhusu unnamya munu Liduva lya Kuyewelela?” Vanu vámmujije uchocho uchinga vapate ing'anya ya kunsitaki. ");
INSERT INTO kde_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu nkuvahaulila kuchidoni, “Munu ntwani mmwenu akámbenkamula na kunnyumya ungandolo wake, akàinjila nnipondo, Nniduva lya Kuyewelela?” ");
INSERT INTO kde_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Bahi munu njo wa mana namene kupunda ungandolo! Na Sheliya yetu ìnatuluhusu tutende lambone Nniduva lya Kuyewelela. ");
INSERT INTO kde_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Anepo nkunnyaulila ayula munu kuchidoni, “Nyoloja nkono wako.” Nang'e nkuunyoloja, naunang'o nkulama, nkuva umi muchi unji. ");
INSERT INTO kde_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Henga avala Mafalisayo nkuhuma pawelu, nkuva uvaujana namuna chivambemmwalala Yesu. ");
INSERT INTO kde_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Akuno Yesu amaîte anelyo livakudungidile, nkuuka anepo pachinu, na vanu vohe nkumpapata. Na nang'e nkuvalamya vagonjo vammalele. ");
INSERT INTO kde_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Nkuvalimbija vanannyaulile munu woheyo habali dyake. ");
INSERT INTO kde_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Átendile uchocho uchinga latimile malove lanatangwele Nnungu kupitila kwanga nabii Isaya kuva, ");
INSERT INTO kde_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ayuno njo ntumishi wangu unintondwele, unguntamwa, na ntima wangu unikatapaliwa nawe. Nìmbemmika Umumu wangu nkati mwake, nanang'e àmbevayanjajija hukumu yangu vanu va vilambo vyammalele. ");
INSERT INTO kde_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Akámbepwatana na munu, na wala akámbenyokonya, na nanga munu ambepilikâna lidi lyake mmadila. ");
INSERT INTO kde_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Akámbevabaniha avala vadabadânga, na wala kuvapweteha avala vakávele na dimongo, àmbetenda uchocho mpaka pámbeitenda haki itawale. ");
INSERT INTO kde_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Na vanu va vilambo vyammalele vàmbelisingila nang'e.” ");
INSERT INTO kde_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Anepo vanu nkumpelekejija Yesu munu anavele na nanndenga anantendile aputale meho na kuva bubu. Yesu nkummusa nanndenga kwanga ayula munu, nkuhulula kutangola na kulola. ");
INSERT INTO kde_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Makuwa lammalele la vanu nkukangana uvachidoni, “Dachi, ìnahululika kuva ayu nni N'dukuluwe Nfalume Daudi, utuchinnolela?” ");
INSERT INTO kde_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Henga Mafalisayo pavapilikene anelo, nkuhaula kuchidoni, “Munu ayu àvausa anamindenga kwa kuhululihwa na Nanchindenga, nkulu wa anamindenga.” ");
INSERT INTO kde_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Akuno Yesu alamaite lavachiliuja mmitima yavo, nkuvahaulila kuchidoni, “Ufalume wohewo ulumbâna wene kwa wene, ùmbematoka, na imanga yoheyo au kaya yoheyo ililumbânya yene ikambekwimila. ");
INSERT INTO kde_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ikàva Nanchindenga àmmusa nanndenga, bahi nang'e àlilumbanya mwene. Dachi, ufalume wake ùmbekwimila dachi? ");
INSERT INTO kde_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mwenu mùhaula kuva nangu ngùvausa anamindenga kwa kuhululihwa na Nanchindenga, dachi, nnani avêng'a vanu venu dimongo dya kuvausa anamindenga? Bahi vanu venu mmene njo vambennyukûmu mwenu ing'anya ya malove lamutangwele. ");
INSERT INTO kde_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Henga ikàva nangu nìvausa anamindenga kwa dimongo dya Umumu wa Nnungu, bahi mumale kuva Ufalume wa Nnungu ùnimwidilanga. ");
INSERT INTO kde_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Nanga munu ahulûla kuinjila muing'ande ya munu avêle na dimongo nkumpakanyola vitukutuku vyake, mpaka àtandilike kunnyunga mididi hoti. Anepo njo pambehulula kumpakanyola vitukutuku vyake. ");
INSERT INTO kde_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Munu woheyo akávele pamo na nangu, aneyo ànangutahuka, na munu woheyo akákunganya pamo na nangu, aneyo ànamwadilihanya. ");
INSERT INTO kde_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Bahi nangu nìnnyaulilanga kuva, vanu vachivasamehewe masambi lavo na kufulu dyavo dinji, henga munu ambenkufûlu Umumu Wanaswe, akambesamehewa. ");
INSERT INTO kde_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Munu woheyo ambentangolêla malove lahakalenge Mwana wa Munu achiasamehewe, henga ambenkufûlu Umumu Wanaswe akambesamehewa, mmaduva alano na laida.” ");
INSERT INTO kde_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Nnandi ùmaikana kwa vihepo vyake. Kwa kuva, nnandi wambone ùpa vihepo vyambone, na nnandi ukee wambone ùpa vihepo vikee vyambone. ");
INSERT INTO kde_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mwenu nni mmana mma nachihungo! Mùhulula dachi kutangola malove lambone akuno mitima yenu ikávele yambone? Kwa kuva, munu àtongola àlalá laumbêle muntima mwake. ");
INSERT INTO kde_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Munu avêle na ntima wambone àhumya vitukutuku vyambone kuhaloka muvyambone vyakondije muntima wake wambone, na munu akávele wambone àhumya vitukutuku vikee vyambone kuhaloka muvitukutuku vikee vyambone vyakondije muntima wake ukee wambone. ");
INSERT INTO kde_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Henga nangu nìnnyaulila kuva, liduva lya hukumu, vanu vàmbeyang'ula ing'anya ya kila lilove likávele lyambone livatangwele. ");
INSERT INTO kde_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kwa kuva, kila munu àmbevalangiwa kuva wambone au kuhukumiwa asabu kupapatana na malove lake.” ");
INSERT INTO kde_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Anepo Mafalisayo na vakúhunda Sheliya yanga Musa nkunnyaulila Yesu kuchidoni, “Nkúhunda, hwetu tùlembela utulanguje chimaiho cha lisaibu.” ");
INSERT INTO kde_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu nkuvayang'ula kuchidoni, “Mwenu nni mmanu mma chívelèkwà cha vanu vakákulupika kwa Nnungu na cha vanu vakútenda masambi, njo mana mùlembela ninnangujange chimaiho, henga nanga pamumbelangujwa chimaiho chohecho ikànave chihi achila cha nabii Yona. ");
INSERT INTO kde_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Malinga nabii Yona chanaikele maduva matatu chilo na muhi nnitumbo lya uhomba nkulungwa, nni chiilembekuva kwanga Mwana wa Munu, àmbeikala maduva matatu chilo na muhi, pahi chilambo. ");
INSERT INTO kde_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nniduva anelyo lya hukumu, vanu va ku Ninawi vàmbeimila na kuvasitaki vanu va chívelèkwà achino kuva vànikosela. Kwa kuva, vanu va ku Ninawi vánilekanga kutenda masambi ing'anya ya mahubili la nabii Yona, na apano pàvele munu yumo nkulungwa kumpunda nabii Yona! ");
INSERT INTO kde_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Na liduva lya hukumu, malukiya wa kusini, wa chilambo cha Sheba àmbeimila na kuvasitaki vanu va chívelèkwà achino kuva vànikosela. Kwa kuva, nang'e ániida kuhaloka chilambo cha kulehu kwida unapilikanila malove la lúnda la Nfalume Selemani, na apano pàvele munu yumo nkulungwa kumpunda Nfalume Selemani.” ");
INSERT INTO kde_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Nanndenga pammuka munu, àpita wadinguka-dinguka pachinu pakávele medi wataha pachinu pakuyewelela, henga nanga papata. ");
INSERT INTO kde_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Anepo àlihaulila mwene muntima kuva, ‘Nìmbeuya kuing'ande yangu inguilekile.’ Na páùyà, àikoja ikaikalìwà, ipyailiwìjè na kila chinu chivikwìjè saana. ");
INSERT INTO kde_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Anepo ànauka nkunavatwala anamindenga avake saba vabaya kumpunda nang'e, na vammalele vànahwena nkumwenda aneyo munu. Na hali ya kuntululilo ya munu aneyo ììva ibaya kupunda hali yake inandi. Uvila njo chiimbekuva kwa vanu vachívelèkwà achino chihakalenge.” ");
INSERT INTO kde_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu pachitangola na likuwa lya vanu, anyokwe pamo na vanung'unuvake váimidile pawelu uvanninda valonjele nawe. ");
INSERT INTO kde_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Munu yumo nkunnyaulila Yesu kuchidoni, “Anyoko pamo na vanung'unuvako vàimidile pawelu, vàlembela valonjele na wako.” ");
INSERT INTO kde_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu nkunnyang'ula kuchidoni, “Kwani mama nangu ni nnani na anung'unuvangu ni vanani?” ");
INSERT INTO kde_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Anepo Yesu nkuvaolotela nkono vakuhundwa vake, nkuhaula kuchidoni, “Avano apano njo ayuvangu na vanung'unuvangu! ");
INSERT INTO kde_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kwa kuva, munu atênda lalalembela Atatangu avêle kulihunde, aneyo njo nnung'unwangu na nnumbwangu na nnyuwangu.” ");
INSERT INTO kde_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Liduva ulyolyo Yesu pahumidile pawelu, nkuuka nkuhwena unaikala kunyenje litanda. ");
INSERT INTO kde_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Makuwa makulu la vanu nkumwombalanila, bahi Yesu nkubidi akwele muingalava ínavele nnitanda, nkuikala. Na vanu nkuva vaimidìlè kunnyangi. ");
INSERT INTO kde_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Anepo Yesu nkuvahaulila vitukutuku vyohe kwa mifano wachidoni, “Pilikanila! Nkúpanda ápite unapanda dimbeyu. ");
INSERT INTO kde_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Pánavele nkumyaya dimbeyu, dinji nkumatokela nndila, vyuni nkuhaloka nkudidadola. ");
INSERT INTO kde_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Na dimbeyu dinji nkumatokela pachinu pavêle na mayanga-mayanga, pakávele na ulongo wohe. Anedyo dimbeyu nkupiyanya kumela kwa kuva ulongo úvele kadiki. ");
INSERT INTO kde_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Liduva palivadile, aneyo mitipu nkunyala, na kwa kuva dinyiya dikanatadile pahi namene, bahi nkuyumanga. ");
INSERT INTO kde_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Dimbeyu dinji nkumatokela pachinu pavêle miva, nkumela, miva nkukulumuka na kuidingila aila mitipu. ");
INSERT INTO kde_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Na dimbeyu dinji nkumatokela paulongo wa matapata, na ulongo anewo nkupundya kuhumya mafuno myanda myamoja au sitini au salasini, kupunda dimbeyu adila dipandwîje. ");
INSERT INTO kde_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Avêle na makutu la kupilikana, apilikane!” ");
INSERT INTO kde_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Vakuhundwa vake nkummwenela Yesu, nkummuja kuchidoni, “Mwadachi ùlonjela na vanu kwa kutumila mifano?” ");
INSERT INTO kde_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu nkuvayang'ula kuchidoni, “Mwenu mùnijaliwa kudimala disili dya Ufalume wa Nnungu, henga vanang'o nanga pavanajaliwije. ");
INSERT INTO kde_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kwa kuva, munu avêle na chinu àmbeyenjejwa ààve na vyohe, henga ayula akávele na chinu, ata achila kadiki chavenacho àmbepokonyolwa. ");
INSERT INTO kde_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Njo mana ngùtangola navo kwa mifano, kwa kuva kulola vànalola, henga nanga chivachona, na kupilikanila vanapilikanila, henga nanga pavapilikana na wala kwelewa. ");
INSERT INTO kde_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kwa vanang'o, kuva uchocho nni kutimisa malove lanatangwele nabii Isaya kuva, ‘Kupilikana mùmbepilikana, henga mukambekwelewa. Na kulola mùmbelola, henga mukambekameka. ");
INSERT INTO kde_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kwa kuva, mitima ya ava vanu ìninonopa, na makutu lavo lànaidopa kupilikana, na meho lavo vànionija. Kuikavele ikàva uchocho, vakanilola kwa meho lavo, na vakanipilikana kwa makutu lavo, na vakanikameka kwa mitima yavo, na vakaningulaukila, nanani nikanivalamya.’ ");
INSERT INTO kde_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Henga wasa mwenu, kwa kuva meho lenu lanaloleha saana, na makutu lenu lanapilikaniha saana. ");
INSERT INTO kde_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nangu nìnnyaulilanga uhiu kuva, manabii vohe na vanu váchitèndà lalalembela Nnungu, vánilembela kulona lamulona mwenu, henga nanga pavanalawene, na vánilembela kulapilikana alano lamupilikana mwenu, henga nanga pavanalapilikene.” ");
INSERT INTO kde_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yesu nkuvahaulila kuchidoni, “Mwenu pilikanila chiulanda nfano wa nkúpanda. ");
INSERT INTO kde_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Vanu vapilikâna lilove liyâmba Ufalume wa Nnungu bila kwelewa, avano vàlandanywa na amula nndila mudimatokedile adila dimbeyu. Nanchindenga ànaida na kuchiusa achila chipandwîje mmitima yavo. ");
INSERT INTO kde_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Na pachinu pavêle mayanga-mayanga padimatokedile adila dimbeyu, anepo pàlandanywa na vanu valipwechelêla lilove kwa kulihangalalila, ");
INSERT INTO kde_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","henga kwa kuva anelyo lilove nanga palyenda mmitima yavo muchi chidikatita dinyiya pachinu pavêle mayanga, vanu anevo vàlikamulila chihi kwa uhiku kadiki alila lilove liyâmba Ufalume wa Nnungu, na kukàida kulaga au kubanika ing'anya ya alila lilove, upala vànahochejwa. ");
INSERT INTO kde_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Na pachinu pavêle miva, apala padimatokedîle adila dimbeyu, anepo pàlandanywa na vanu valipilikâna anelyo lilove, henga lipamba lya pachilambo na kukumbika na dimali, anevyo vìnalidingila anelyo lilove lipandwîje mmitima yavo, nkuva chihi nanga kuhumya mafuno. ");
INSERT INTO kde_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Na pachinu pavêle ulongo wa matapata, apala padimatokedîle adila dimbeyu, anepo pàlandanywa na vanu valipilikâna lilove anelyo na kulyelewa, vanu anevo vànapundya kuhumya mafuno, yumo myanda myamoja na yunji myanda sitini na yunji myanda salasini, kupunda dimbeyu adila dipandwîje.” ");
INSERT INTO kde_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu nkuvahaulila vanu kavila nfano unji wachidoni, “Ufalume wa Nnungu ùlandana na munu apandîle dimbeyu dyambone mmwelu mwake. ");
INSERT INTO kde_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Henga vanu pavanalele luwono, nkuida mmongo wake nkùpanda lukwekwe ching'ati ngano, nkuuka. ");
INSERT INTO kde_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ngano paitandilike umela na kutumbuka dinumbu, nkwonekana na lukwekwe amula mmwelu. ");
INSERT INTO kde_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Bahi vatumishi va mwene welu nkummwenela mwene welu, nkunnyaulila kuchidoni, ‘Nang'olo, tenda úpandile dimbeyu dyambone mmwelu wako? Hambi lukwekwe lùhaleke kwachi?’ ");
INSERT INTO kde_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nang'e nkuvayang'ula kuchidoni, ‘Mmongo wangu njo atendîle uchocho.’ Vatumishi vake nkummuja kuchidoni, ‘Dachi, unalembela tuhwene tukaludabole?’ ");
INSERT INTO kde_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nang'e nkuvayang'ula kuchidoni, ‘Nanga, munadabole, uyopa munadabola kumo na ngano. ");
INSERT INTO kde_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Vilekange vyammalele vikulumuke pamo mpaka lichela. Anepo njo panimbevahaulila vakúfuna kuva, tandilika kudabolanga lukwekwe na kuluhunga matunji na mulutaye mmoto, koka muilokotanye ngano na kuivika nnikangala lyangu.’ ” ");
INSERT INTO kde_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu nkuvahaulila kavila nfano unji wachidoni, “Ufalume wa Nnungu ùlandana na imbeyu ya haladali yanatwete munu yumo, nkuipanda mmwelu mwake. ");
INSERT INTO kde_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Imbeyu yêne, nni inyoko upunda dimbeyu dyammalele, henga nnandi wake paukulumuka ùùva nkulungwa kupunda milandi yammalele ya imbowa ya mmwelu wa bustani, ata vyuni vànahulula chihi kudenga vitehi n'dinavi dyake.” ");
INSERT INTO kde_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu nkuvahaulila nfano unji kavila wachidoni, “Ufalume wa Nnungu ùlandana na hamila yanatwete mmahe yumo, nkuikundanya na uhu wohe wa ngano, na lidonji lyammalele nkuumuka.” ");
INSERT INTO kde_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Alano lammalele, Yesu ánilahaulila makuwa la vanu kwa mifano. Na nanga chinu chanavahaulidile bila kutumila nfano, ");
INSERT INTO kde_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","uchinga litimile lilove lyanatangwele nabii kuva, “Nìmbetangola navo kwa mifano, na nìmbevahaulila mambo lapihîke, kutandikila kuumbwa kwa chilambo.” ");
INSERT INTO kde_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Anepo Yesu nkulaleka makuwa la vanu, nkuinjila nng'ande. Vakuhundwa vake nkummwenela, nkunnyaulila kuchidoni, “Tuhaulile chiulanda aula nfano wa lukwekwe mmwelu.” ");
INSERT INTO kde_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu nkuvayang'ula kuchidoni, “Ayula apandîle adila dimbeyu dyambone nni Mwana wa Munu. ");
INSERT INTO kde_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Aula welu ni chilambo, na adila dimbeyu dyambone ni vanu va mu Ufalume wa Nnungu, na alula lukwekwe ni vanu vanga Ibilisi, ayula nkútenda lahakalenge. ");
INSERT INTO kde_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Na mmongo apandîle alula lukwekwe ni Ibilisi, na lichela ni ntululilo wa chilambo, na vakúfuna ni malaika. ");
INSERT INTO kde_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Bahi malinga chiludobolewa lukwekwe na kuyochwa mmoto, nni chiimbekuva ntululilo wa chilambo. ");
INSERT INTO kde_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwana wa Munu àmbevatuma malaika vake vàuse kuhaloka mu Ufalume wake kila chinu chitênda vanu vatende sambi, pamo na vanu vammalele vatendânga lahakalenge, ");
INSERT INTO kde_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","na kuvayaha nnitungulu lya moto, aneko nni kuvambekuta na kuhaya meno. ");
INSERT INTO kde_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Anepo njo vanu váchitenda lalalembela Nnungu pavambeng'anyima muchi liduva mu Ufalume wa Atatawavo. Avêle na makutu la kupilikana, apilikane!” ");
INSERT INTO kde_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ufalume wa Nnungu ùlandana na lichehe lya dimali dya isabu ing'ulu linapihijwe mmwelu. Munu yumo paliwene, nkulipiha kavila. Nkuuka anepo wahangalala, nkuhwena unasumisa vitukutuku vyammalele vyavenavyo, nkunausuma aula welu. ");
INSERT INTO kde_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kavila, Ufalume wa Nnungu ùlandana na nkúchuusa yumo, atâha lulu dyambone. ");
INSERT INTO kde_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Payonite lulu ya samani ing'ulu, nkuhwena unasumisa vitukutuku vyammalele vyavenavyo, nkunaisuma aila lulu.” ");
INSERT INTO kde_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Kavila, Ufalume wa Nnungu ùlandana na lwau luvatadile m'bahali, nkuupa dihomba dya kila namuna. ");
INSERT INTO kde_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Dihomba padyombele nnwau, vanu nkuutangila lwau kunnyangi, nkuikalanga, nkuditandolela dihomba dikatapele mmakalala, na adila dihakalenge nkudiyaha. ");
INSERT INTO kde_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Uvila njo chiimbekuva ntululilo wa chilambo. Vàmbehaloka malaika na kuvahapula vanu váchitèndà lahakalenge kuhaloka kwa vanu váchitèndà lalalembela Nnungu. ");
INSERT INTO kde_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Anepo anevo vanu váchitèndà lahakalenge vàmbeyahwa nnitungulu lya moto, aneko njo kuvambekuta na kuhaya meno.” ");
INSERT INTO kde_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu nkuvauja kuchidoni, “Dachi, mùnivimala vitukutuku anevyo vyammalele?” Vanang'o nkunnyang'ula kuchidoni, “Elo.” ");
INSERT INTO kde_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yesu nkuvahaulila kuchidoni, “Bahi kila nkúhunda Sheliya ya Musa ààva nkuhundwa mu Ufalume wa Nnungu, aneyo àlandana na munu, mwene ing'ande ahûmya vitukutuku vyahambi na vyakala kuhaloka nnichehe lyake lya kukondidya dimali dya isabu ing'ulu.” ");
INSERT INTO kde_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu pamalidile kuhaula mifano aneyo, nkuuka pachinu anepo, ");
INSERT INTO kde_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","nkuhwena ku Nasaleti chijiji cha kwave. Nkutandilika kuvahunda vanu muing'ande yavo ya kunnyuwila Nnungu, na vanu nkukangana uvachidoni, “Ayu munu apête kwachi lúnda alu na dimongo dya kutenda masaibu? ");
INSERT INTO kde_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Kwani ayu akee ayula mwana wanga fundi selemala? Na anyokwe akee ayula uvanchema Maliya na anung'unuvake akee anga Yakobo na Yusufu na Simoni na Yuda? ");
INSERT INTO kde_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Dachi, na alumbuvake vammalele akee vatuikanavo apano petu? Dachi, àlapete kwachi alano lammalele?” ");
INSERT INTO kde_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Bahi vanang'o nkunsunalila. Henga Yesu nkuvahaulila kuchidoni, “Nabii nanga kwakapata eshima ikànave chihi nkaya yake na kwa alangavake.” ");
INSERT INTO kde_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Bahi Yesu nanga panatendile masaibu lohe, ing'anya nanga pavanankulupidile. ");
INSERT INTO kde_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mmaduva anelo, Nfalume Helode ánipilikana habali dyanga Yesu. ");
INSERT INTO kde_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nkuvahaulila vatumishi vake kuva, “Munu ayu nni Yohana Nkúbatisa, ànifufuka kuhaloka kwa vanu vahwîle, njo mana dimongo dya masaibu dìkola madengo nkati mwake.” ");
INSERT INTO kde_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Helode njo analaijîje Yohana akamulwe na kutaywa nnilungu, ing'anya yanga Helodiya, n'jawe Filipo, nnung'une wake mwene. ");
INSERT INTO kde_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kwa kuva, Yohana ánnyaulidile Helode kuchidoni, “Ikáluhusiwa wako kwikalana na mmahe aneyo!” ");
INSERT INTO kde_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Helode álembela ammwalale Yohana, henga ávayopile vanu, kwa kuva, kwa vanang'o Yohana ávele nabii. ");
INSERT INTO kde_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Paikamwele sikukuu ya kuvelekwa kwanga Helode, mwali wanga Helodiya ánivina muyo mwa vayeni nkunhangalaja Helode. ");
INSERT INTO kde_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Bahi Helode nkumwahidi ayula mwali kuva achiamwing'e chohecho chambeyuwa. ");
INSERT INTO kde_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Anyokwe ayula mwali nkunnyaulila chinu chakuyuwa. Ayula mwali nkunnyaulila Nfalume Helode kuchidoni, “Idanawo nsahani muti wanga Yohana Nkúbatisa.” ");
INSERT INTO kde_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nfalume nkuva nnihindambi, henga kwa kuva ániahidi na ing'anya ya avala vayeni apala paing'ole, nkulaija vamwing'e. ");
INSERT INTO kde_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Bahi Nfalume Helode nkulaija Yohana acheketwe muti nnilungu. ");
INSERT INTO kde_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Nkuida na muti wanga Yohana nsahani, nkumwing'a ayula mwali, nang'e nkumpelekejija anyokwe. ");
INSERT INTO kde_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Vakuhundwa vanga Yohana nkuida, nkuutwala mmili wake, nkuusika. Anepo, nkuhwena unannyaulila habali aneyo Yesu. ");
INSERT INTO kde_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu papilikene habali dyanga Yohana, ániuka apala, nkukwela muingalava, nkuhwena weka pachinu pakávele na vanu. Na vanu pavapilikene, nkummwenela kwa madodo uholoka kudimanga. ");
INSERT INTO kde_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu pasulupwike muingalava, nkulyona likuwa likulungwa lya vanu, nkuvavikila chididi, nkuvalamya vagonjo vavo. ");
INSERT INTO kde_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pachikamwele chinalyulo, vakuhundwa vake nkummwenela, nkunnyaulila, “Apano patuvele ni palilanga na hambi liduva lìniswa. Bahi valaile vanu uchinga vahweneng'ane kuvijiji vakalisumile chakulya.” ");
INSERT INTO kde_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu nkuvahaulila kuchidoni, “Vanang'o vakálembelewa vahweneng'ane. Veng'e mwenu chakulya.” ");
INSERT INTO kde_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Vanang'o nkunnyaulila kuchidoni, “Hwetu tùvele chihi na mikate nnyano na ahomba vavili.” ");
INSERT INTO kde_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu nkuvahaulila kuchidoni, “Idanavyo apano.” ");
INSERT INTO kde_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nkuvahaulila vanu vaikalange muukoka. Nkùtwala aila mikate nnyano na avala ahomba vavili, nkulola muha kulihunde, nkunshukulu Nnungu. Nkuimeyanya aila mikate, nkuveng'a vakuhundwa vake, vakuhundwa nkuvayavanyija vanu. ");
INSERT INTO kde_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Vanu vammalele nkulyanga na kusiba. Vakuhundwa nkulokotanga maisalilo, nkwombaja makalala kumi na mbili. ");
INSERT INTO kde_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Vanu vanalile vávele valume alufu nnyano, bila kuvavalangila vamahe na vavana. ");
INSERT INTO kde_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Upala, Yesu nkuvahaulila vakuhundwa vake vakwelange muingalava, valongolele kung'ambo litanda, akuno nang'e walalaila makuwa la vanu. ");
INSERT INTO kde_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pávalaidile vanu, nkukwela nnichinga weka unayuwa. Chinalyulo, nang'e ávele chihi weka aneko, ");
INSERT INTO kde_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","na uhiku anewo ingalava ívele ihwikìlè ching'ati litanda, akuno mawimbi ulaipanya aila ingalava, ing'anya lipungo linapunga kuholokela muyo mwavo. ");
INSERT INTO kde_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kulyamba, Yesu nkuvahwenela vakuhundwa vake akuno waonga muha medi. ");
INSERT INTO kde_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Vakuhundwa vake pavammwene waonga muha medi, vániyopa namene, nkuhaula kuchidoni, “Ali lindelya!” Nkukuta ding'uto kwa kuyopa. ");
INSERT INTO kde_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Upala, Yesu nkuhaula, “Likamye ntima, munayope nni nangu!” ");
INSERT INTO kde_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petulo nkunnyaulila Yesu, “Nang'olo, ukava njo wako, nguhaulile ngwonge muha medi nguide ukwokwo.” ");
INSERT INTO kde_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu nkunnyaulila, “Ida.” Bahi Petulo nkuhuma muingalava, nkwonga muha medi, nkummwenela Yesu. ");
INSERT INTO kde_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Henga palyonite alila lipungo ulipunga namene nkuyopa, nkutandilika kutitimila, nkukuta ding'uto wachidoni, “Nang'olo, ngupohe!” ");
INSERT INTO kde_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Upala, Yesu nkunyoloja nkono wake, nkunkamula nkunnyaulila kuchidoni, “Wako ùvele na ing'ulupa inyoko. Mwadachi ukákulupila kuva nahulula ukutenda wonge muha medi?” ");
INSERT INTO kde_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Apala, nkukwelanga muingalava na lipungo nkunyalala. ");
INSERT INTO kde_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Na vammalele vánavèlè muingalava nkuntindivalila malundi, nkuhaula kuchidoni, “Muhiu wako nni Mwana wanga Nnungu.” ");
INSERT INTO kde_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yesu na vakuhundwa vake pavayombweke litanda, nkuhwika chilambo cha ku Genesaleti. ");
INSERT INTO kde_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Vanu va pachinu anepo pavammaite kuva ayu nni Yesu, nkuyanjaja habali nchilambo chammalele cha ku Genesaleti. Vanu nkumpelekejija Yesu vagonjo vammalele, ");
INSERT INTO kde_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","nkunnyuwa namene van'guse kananga lupepe lwa lijoho lyake. Na vammalele vanan'gusije vánilama mwalehu. ");
INSERT INTO kde_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Bahi Mafalisayo vanji na vakúhunda Sheliya ya Musa uholoka ku Yelusalemu, nkummwenela Yesu nkummuja kuchidoni, ");
INSERT INTO kde_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Mwadachi vakuhundwa vako vakálakamula mahundo la mihambo ivatulekedile anyakala vetu? Kwa kuva, nanga pavakalava medi mmakono kabla ya kulya!” ");
INSERT INTO kde_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu nkuvayang'ula kuchidoni, “Mwadachi na mwenu muleka kudikamula amuli dya Nnungu ing'anya ya mahundo la mihambo yenu mmene? ");
INSERT INTO kde_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kwa kuva, Nnungu átele kuchidoni, ‘Mweshimu atatako na anyoko,’ na ‘Munu antongolêla atatake au anyokwe malove lahakalenge àlembelewa awalalwe’. ");
INSERT INTO kde_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Henga mwenu mùhaula kuva akee lasima munu kumweshimu atatake, na mùhunda kuva munu ànahulula chihi kunnyaulila atatake au anyokwe kuva ‘Chinu chichichi chikwing'e faida, ngùchihumije sadaka kwa Nnungu.’ ");
INSERT INTO kde_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Anecho nni chimuleka lilove lyanga Nnungu ing'anya ya kupapata mahundo la mihambo yenu mmene. ");
INSERT INTO kde_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mmakulilambilila mwenu! Nabii Isaya álaujije saana kumwamba mwenu, panalembile malove la Nnungu lahaûla kuva, ");
INSERT INTO kde_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ava vanu vàngweshimu chihi pakanya, henga mitima yavo ìvele kulehu na nangu. ");
INSERT INTO kde_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kungwabudu kwavo kukee mana, kwa kuva, mahundo lavo nni malaijo chihi la vanu.’ ” ");
INSERT INTO kde_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Bahi Yesu nkulichema alila likuwa lya vanu nkuvahaulila kuchidoni, “Pilikaniha saana, mumale! ");
INSERT INTO kde_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Chinu chintênda munu kuva najisi muyo mwa Nnungu chikávele achila chênda pakanya, ila malove làhuma nkati mwanga munu njo lantênda kuva najisi.” ");
INSERT INTO kde_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Vakuhundwa vake nkummwenela, nkummuja kuchidoni, “Dachi, ivi unimala kuva Mafalisayo vànivisa pavapilikene malove anelo?” ");
INSERT INTO kde_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu nkuvayang'ula kuchidoni, “Kila nnandi wakaupandile Atatangu wa kulihunde, umbedobolewa. ");
INSERT INTO kde_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Valekange! Vanang'o nni vakúlodya vaputêle meho, vavalôdya vakúputala avao. Munu aputêle meho akànnodya wakuputala nnyake, vammalele vavili vàmatokela nnipondo.” ");
INSERT INTO kde_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petulo nkuhaula kuchidoni, “Tuhaulile mana la nfano anewo.” ");
INSERT INTO kde_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu nkuvauja kuchidoni, “Dachi, mpaka hambi na mwenu nkámaite? ");
INSERT INTO kde_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Dachi, mukámaite kuva kila chinu chênda nkanya, chìhwena nnitumbo na lukoto nkunachiyapuka? ");
INSERT INTO kde_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Henga malove lahûma nkanya, làhaloka muntima, na anelo njo lantâya munu unajisi. ");
INSERT INTO kde_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kwa kuva, muntima mwanga munu mùhuma mawaso lahakalenge na kuwalala na kulala ugoni na usalati na kwiva na ushahidi wa kulambila na kuntongolela munu lahakalenge. ");
INSERT INTO kde_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Anelo njo lantênda munu ààve najisi. Henga kulya chakulya bila kukalava makono kukántenda munu ààve najisi.” ");
INSERT INTO kde_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Bahi Yesu nkuuka pachinu anepo, nkuhwena kuchilambo chivêle pepi na dimanga dya ku Tilo na ku Sidoni. ");
INSERT INTO kde_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Bahi nkuhaloka mmahe yumo Nkanaani achiikala chilambo anecho, nkukuta, akuno wachidoni, “Nang'olo, N'dukuluwe Nfalume Daudi, ngùvikile chididi! Kwa kuva, nanndenga ànannagiha namene mwali wangu.” ");
INSERT INTO kde_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Henga Yesu nanga panayangw'ile chinu. Bahi vakuhundwa vake nkummwenela Yesu nkunnyaulila kuchidoni, “Nnyaulile ahwene, mana anyakonya chihi watupapata hwetu.” ");
INSERT INTO kde_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu nkuvayang'ula kuchidoni, “Nangu ngùtumwije chihi kwa vanu va Isilaeli vavêle muchi angandolo vayahîke.” ");
INSERT INTO kde_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Bahi ayula mmahe nkuida, nkuntindivalila Yesu malundi, nkuchidoni, “Nang'olo, nguyangate.” ");
INSERT INTO kde_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu nkunnyang'ula kuva, “Ikákatapala kutwala chakulya cha vavana nkuvayelela ang'avanga.” ");
INSERT INTO kde_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ayula mmahe nkuchidoni, “Elo Nang'olo, henga ata ang'avanga vànalya makombo lamatwêke pameza ya nang'olo wavo.” ");
INSERT INTO kde_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Apala Yesu nkunnyaulila ayula nkongwe kuchidoni, “Mama, ing'ulupa yako nni ing'ulu! Bahi utendewe muchi chulembela.” Udisaa udila nanndenga nkummuka ayula mwali, nkulama. ");
INSERT INTO kde_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Bahi Yesu nkuuka anepo nkuhwena kunyenje Litanda lya ku Galilaya, nkukwela nnichinga, nkuikala aneko. ");
INSERT INTO kde_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Makuwa makulungwa la vanu nkummwenela uvampelekejija vanu valamêle na vaputêle meho na vikwavi na mabubu na vanu vanji vohe, nkuvavika muyo mwanga Yesu, nanang'e nkuvalamya. ");
INSERT INTO kde_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Vanu nkukangana namene pavavawene mabubu uvatangola na vikwavi uvilama na valamele uvahwena na vaputêle meho uvalola, vanu nkunnombolela Nnungu wa Vaisilaeli. ");
INSERT INTO kde_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Anepo Yesu nkuvachema vakuhundwa vake, nkuvahaulila kuchidoni, “Nangu nìvavikila chididi ava vanu ing'anya vàikele na nangu maduva matatu vino, na hambi chakulya chìnivahilila. Nanga paikatapala nivaleke vahweneng'ane akuno vadobìlè, uyopa vanadilika nndila.” ");
INSERT INTO kde_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Vakuhundwa nkunnyaulila kuchidoni, “Apano patuvele palilanga. Dachi, tùmbepata kwachi mikate ya kuvatoleja vanu ava vammalele?” ");
INSERT INTO kde_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu nkuvauja kuchidoni, “Mùvele na mikate mingapi?” Vanang'o nkunnyang'ula kuchidoni, “Saba na ahomba kadiki vadikidiki.” ");
INSERT INTO kde_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesu nkuvahaulila vanu vaikalange pahi. ");
INSERT INTO kde_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Anepo nkuitwala aila mikate saba na avala ahomba, nkunshukulu Nnungu, nkuvimeyanya, nkuveng'a vakuhundwa vake vavayavile vanu. ");
INSERT INTO kde_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Vammalele nkulyanga na kusiba, vakuhundwa nkulokotanya maisalilo, nkwombaja makalala saba makulungwa. ");
INSERT INTO kde_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Na vanalile vávele vanu valume alufu ncheche, bila kuvavalangila akongwe na vavana. ");
INSERT INTO kde_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Anepo Yesu nkuvalaila vanu, nkuinjila muingalava, nkuhwena kuchilambo cha ku Magadani. ");
INSERT INTO kde_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mafalisayo na Masadukayo nkummwenela Yesu nkunninga avalanguje chimaiho cha lisaibu chimaîha kuva dimongo dyake dìhaloka muha kulihunde. ");
INSERT INTO kde_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesu nkuvayang'ula kuchidoni, “Pachikamola chinalyulo, mùhaula kuva, ‘Uhiku wa nundu ùlembekuva wambone, kwa kuva kumahunde kwanahuvi.’ ");
INSERT INTO kde_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na ulyamba paucha mùhaula kuva, ‘Nelo ìmbetonya imbula ing'ulungwa ya lipungo kwa kuva kumahunde kùnikunduvala na mahunde lànidimbya.’ Mwenu mùnahulula kulauja hali ya hewa kwa kuloleha kumahunde, henga nanga pamuhulula kumala vimaiho vya mahiku alano. ");
INSERT INTO kde_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mwenu nni mmanu mma chívelèkwà cha vanu vakákulupika kwa Nnungu na cha vakútenda masambi, njo mana mùlembela ninnangujange chimaiho, henga nanga pamumbelangujwa chimaiho chohecho cha lisaibu ikànave chihi achila cha nabii Yona.” Anepo Yesu nkuvaleka, nkulihwenela. ");
INSERT INTO kde_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Vakuhundwa pavayombweke litanda, nkuhimukila kuva, vàniluvalila unyakula mikate. ");
INSERT INTO kde_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu nkuvahaulila kuchidoni, “Lyongolelange na mulinyemye na hamila ya Mafalisayo na Masadukayo.” ");
INSERT INTO kde_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Vanang'o nkuva uvahaulanila kuchidoni, “Àtangola uchocho ing'anya itukanyakwile mikate.” ");
INSERT INTO kde_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu ánimala chivachiliuja, nkuvahaulila kuchidoni, “Mwenu mmanu muvêle na ing'ulupa inyoko, mwadachi mùujana ing'anya imukavele na mikate? ");
INSERT INTO kde_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mpaka hambi mùkanamala? Dachi, mukákumbukila aila mikate nnyano innavayavidile vanu vapûnda alufu nnyano? Dachi, mwómbajije makalala mangapi la maisalilo? ");
INSERT INTO kde_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Na aila mikate saba innavayavidile vanu vapûnda alufu ncheche, dachi, múlokotanyije makalala mangapi la maisalilo? ");
INSERT INTO kde_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mwadachi mwenu mukámaite kuva nangu nikáchiiyamba mikate? Henga lyongolelange na hamila ya Mafalisayo na Masadukayo!” ");
INSERT INTO kde_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Anepo vakuhundwa nkumala kuva Yesu nanga pachivahaulila valyongolele na hamila ya mikate, ila valyongolele na mahundo la Mafalisayo na Masadukayo. ");
INSERT INTO kde_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu pakamwele pepi na imanga ya Kaisaliya Filipi, nkuvauja vakuhundwa vake kuchidoni, “Dachi, vanu vachidachi, Mwana wa Munu nni nnani?” ");
INSERT INTO kde_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Vanang'o nkunnyang'ula kuchidoni, “Vanu vanji vàhaula kuva wako nni Yohana Nkúbatisa, na vanji Eliya, na vanji Yelemiya au yumo wa manabii.” ");
INSERT INTO kde_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesu nkuvauja kuva, “Dachi, na mwenu muchidachi, nangu nnani?” ");
INSERT INTO kde_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoni uvanchema Petulo nkuyang'ula kuchidoni, “Wako nni Kilisto, Mwana wanga Nnungu mumi.” ");
INSERT INTO kde_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu nkunnyang'ula kuva, “Wasa wako Simoni mwana wanga Yona, kwa kuva akee munu akuhunukulidîle, ila mwene Atatangu avêle kulihunde. ");
INSERT INTO kde_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Wako Petulo, wako nni liyanga likulungwa na muha liyanga alino nìmbetandiliha na kuhweneha likuwa lya vanu vangukulupîla, na kuhwa kukambelilema likuwa anelyo. ");
INSERT INTO kde_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nìmbekwing'a wako mitukulo ya Ufalume wa Nnungu, na lyohelyo lyumbelihunga pachilambo, lìmbehungwa na kulihunde, na lyohelyo lyumbelihungula pachilambo, lìmbehunguliwa na kulihunde.” ");
INSERT INTO kde_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Anepo Yesu nkuvalimbija vakuhundwa vake vanannyaulile munu woheyo kuva nang'e njo Kilisto. ");
INSERT INTO kde_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Bahi kutandikila anepo, Yesu nkutandilika uvahaulila vakuhundwa vake kuva, àlembelewa ahwene ku Yelusalemu, na aneko vasele va Vayahudi na makuhani vakulu na vakúhunda Sheliya ya Musa vàmbem'baniha namene, vàmbemmwalala na liduva lya tatu lya kuhwa kwake àmbefufuka. ");
INSERT INTO kde_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Anepo Petulo nkuntwala Yesu kunyenje, nkutandilika kuntahuka wachidoni, “Mwiko Nang'olo, anelyo wala likambekukoja wako!” ");
INSERT INTO kde_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu nkulauka nkunnyaulila Petulo kuchidoni, “Uka muyo mwangu, Nanchindenga! Wako nni lutambo kwang'une, kwa kuva, mawaso lako lakee la chinnungu ila la chimunu chihi.” ");
INSERT INTO kde_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Bahi Yesu nkuvahaulila vakuhundwa vake kuchidoni, “Munu woheyo akàlembela kungupapata nangu, lasima alishukulu mwene, alitike nsalaba wake koka angupapate. ");
INSERT INTO kde_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Na munu woheyo autâmwa namene umi wake upunda changutamwa nangu, akambekuva na umi ukee na ntululilo, henga munu akubâli kuhwa ing'anya yang'une achiave na umi ukee na ntululilo. ");
INSERT INTO kde_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Dachi, munu àmbepata faida ntwani akàpata kila chinu cha pachilambo, akuno auyahìtè umi ukee na ntululilo? Au pàvele chinu ntwani apano pachilambo munu chambebadilana uchinga apate umi ukee na ntululilo? ");
INSERT INTO kde_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kwa kuva, Mwana wa Munu àmbekwida muukulu wa Atatake pamo na malaika, na anepo nni pambennipa kila munu kupapatana na vitendo vyatendile. ");
INSERT INTO kde_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nangu nìnnyaulilanga uhiu kuva, vanu vanji vaimidîle apano vakambekuhwa mpaka pavambemwona Mwana wa Munu waida mu Ufalume wake.” ");
INSERT INTO kde_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Bada ya maduva sita, Yesu nkuntwala Petulo na Yakobo na Yohana nnung'une Yakobo, nkuhwena navo weka muha lichinga lilehu namene. ");
INSERT INTO kde_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Aneko Yesu nkubadilika muyo mwavo, lyenye lyake nkuchenga muchi liduva na dinguwo dyake nkung'anyima muchi nng'anje wa ing'uva. ");
INSERT INTO kde_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Anepo nkuhumila Musa na nabii Eliya nkuva uvatangola na Yesu. ");
INSERT INTO kde_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petulo nkunnyaulila Yesu kuchidoni, “Nang'olo, nni chinu chambone hwetu kupwawa apano! Ukàlembela, nguchingudenge migongwe mitatu, umo wako na umo wa Musa na umo wa Eliya.” ");
INSERT INTO kde_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Petulo pachitangola anelo, lihunde lyakuchenga namene nkuvahinika, na lidi nkupilikanika kuhaloka mualila lihunde ulichidoni, “Ayuno nni Mwanangu unintamwa, ungukatapaliwa nawe, mpilikanile nang'e.” ");
INSERT INTO kde_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Avala vakuhundwa pavalipilikene anelyo lidi, nkuhunama na kuyopa namene. ");
INSERT INTO kde_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Henga Yesu nkuhwena, nkuvagusa, nkuhaula kuchidoni, “Imilanga, munayope!” ");
INSERT INTO kde_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Na pavakusumbwile meho nanga pavanamwonite munu yunji, nkumwona chihi Yesu weka. ");
INSERT INTO kde_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Bahi pavachisulupuka nnichinga, Yesu nkuvaamulisa wachidoni, “Munannyaulile munu woheyo achila chimuchiwene, mpaka Mwana wa Munu pámbefufùkà kuhaloka kwa vanu vahwîle.” ");
INSERT INTO kde_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Vakuhundwa vake nkummuja uvachidoni, “Mwadachi, vakúhunda Sheliya yanga Musa vàhaula kuva nabii Eliya lasima alongolele kwida kavila hoti?” ");
INSERT INTO kde_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu nkuvayang'ula kuchidoni, “Muhiu, Eliya àmbekwida hoti unakatapaja lammalele, ");
INSERT INTO kde_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","henga nangu nìnnyaulilanga kuva, Eliya tayali àniida kavila, na wala vanammale, nkuntendela chihi chivalembedile vene. Uvila njo chivambem'baniha Mwana wa Munu.” ");
INSERT INTO kde_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Bahi vakuhundwa nkumala kuva àmwamba Yohana Nkúbatisa. ");
INSERT INTO kde_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pavakamwele kulikuwa lya vanu, munu yumo nkummwenela Yesu nkutindivala malundi muyo mwa Yesu, ");
INSERT INTO kde_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","nkuchidoni, “Nang'olo, mmikile chididi mwanangu. Nang'e àvele na chihundahunda, na ànabanika namene, kwa kuva, myanda yohe àmatokela pamoto na myanda inji mmedi. ");
INSERT INTO kde_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ǹnimpelekeja kwa vakuhundwa vako, henga nanga pavahulwile kummusa aneyo nanndenga.” ");
INSERT INTO kde_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu nkuyang'ula kuchidoni, “Mwenu mmanu mma chívelèkwà chikákulupila na chihochedîle! Dachi, nìmbeikala na mwenu mpaka chakani na nìmbempililila mpaka chakani? Idanawe apano mwanalo.” ");
INSERT INTO kde_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Bahi Yesu nkunkalipila ayula nanndenga, na nanndenga nkummuka, na ayula nnemba nkulama upala. ");
INSERT INTO kde_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Anepo vakuhundwa nkummwenela Yesu paweka, nkummuja kuchidoni, “Mwadachi, hwetu nanga patunahulwile kummusa ayula nanndenga?” ");
INSERT INTO kde_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu nkuvayang'ula kuchidoni, “Ing'anya ing'ulupa yenu inyoko. Nangu nìnnyaulilanga uhiu kuva, mukàva na ing'ulupa inyoko malinga imbeyu ya haladali, muchimuhulule kulihaulila lichinga alino, ‘Uka apano uhwene apala,’ na linang'o lichiliuke. Nanga chinu chohecho chikachichichihululike kwenu mwenu.  ");
INSERT INTO kde_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Henga nanndenga malinga ayu ikáhululika kummusa ikànave chihi kwa kuyuwa na kufunga.” ");
INSERT INTO kde_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Pavanavele pamo aneko ku Galilaya, Yesu nkuvahaulila vakuhundwa vake kuchidoni, “Mwana wa Munu àvele pepi uhwena unakamujwa mmakono la vanu. ");
INSERT INTO kde_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Vàmbemmwalala na liduva lya tatu lya kuhwa kwake àmbefufulwa.” Bahi vakuhundwa vake nkuva nnihindambi. ");
INSERT INTO kde_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu na vakuhundwa vake pavahwikile ku Kapelinaumu, vakútwala kodi ya Ing'ande ya Nnungu nkummwenela Petulo, nkummuja kuchidoni, “Dachi, nkúhunda wenu ànalipa kodi ya Ing'ande ya Nnungu?” ");
INSERT INTO kde_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petulo nkuyang'ula kuchidoni, “Elo, ànalipa.” Bahi Petulo painjidile nng'ande, Yesu nkuva ntandi ummuja Petulo kuchidoni, “Petulo, wako wona dachi? Vafalume va pachilambo vàtwala ushulu au kodi kwa vanu ntwani? Kuhaloka kwa vanu vao au kwa vayeni?” ");
INSERT INTO kde_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petulo nkuyang'ula kuchidoni, “Kuhaloka kwa vayeni.” Yesu nkuchidoni, “Ikàva uchocho, bahi vanu vao vakálembelewa kulipa. ");
INSERT INTO kde_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Henga uchinga tunavasunaje, hwena kulitanda ukayele indowana mmedi, na uhomba ambekûva ntandi kutanjika, nnyahamule kanya unakoja hela nkati mwake. Wako itwale ukalipe kodi yangu na yako.” ");
INSERT INTO kde_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Upala vakuhundwa nkummwenela Yesu, nkummuja kuchidoni, “Alida nkulu mu Ufalume wa Nnungu?” ");
INSERT INTO kde_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu nkunchema mwana n'joko nkumwimija paching'ati pavo, ");
INSERT INTO kde_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","nkuchidoni, “Nangu nìnnyaulilanga uhiu kuva, mukanapindikuke nkuva muchi vavana vajoko, mwiko mukambeinjila mu Ufalume wa Nnungu. ");
INSERT INTO kde_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Bahi munu woheyo alisulupûsa nkuva muchi mwana ayuno, aneyo nni nkulu mu Ufalume wa Nnungu. ");
INSERT INTO kde_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Na munu woheyo ampwechelêla mwana n'joko muchi ayuno ing'anya yang'une, aneyo angupwechelêla nangu.” ");
INSERT INTO kde_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Henga munu woheyo ambentênda yumo wa avano vajoko vangukulupîla nangu alikuvale kwa kutenda masambi, ikàvele wasa munu aneyo ahungiwe liyanga likulungwa lya kuhayila muukoti na kutitimijwa ching'ati medi lohe la m'bahali. ");
INSERT INTO kde_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ole wavo vanu va pachilambo ing'anya ya mambo lavakuvâja vanu kutenda masambi! Mambo lavakuvâja vanu kutenda masambi lasima laide, henga ole wake munu ambetendîha laide!” ");
INSERT INTO kde_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ikàva nkono au ludodo lwako lunakukuvaja kutenda masambi, luchekete uluyahe kulehu. Wasa wingile muumi ukee na ntululilo akuno ukavèlè na nkono umo au ludodo lumo, kuliko kwenda mmoto ukádimika akuno uvèlè na makono mavili na madodo mavili. ");
INSERT INTO kde_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na ikàva liso lyako linakukuvaja kutenda masambi, bahi lidabole uliyahe kulehu! Wasa uinjile muumi ukee na ntululilo akuno uvèlè na liso limo kuliko kuyahwa mmoto wa Jihannamu akuno uvèlè na meho mavili.” ");
INSERT INTO kde_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Lyongolelange munansalau yumo wa avano vajoko. Nangu nìnnyaulilanga kuva, aneko kulihunde malaika vao vààva muyo mwa Atatangu wa kulihunde maduva lammalele. ");
INSERT INTO kde_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ikàva munu àvele na angandolo myamoja, na yumo nkuhochela, dachi àmbetenda dachi? Àmbevaleka avala tisini na tisa kumachinga nkuhwena unannembela ayula ahochedîle. ");
INSERT INTO kde_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nangu nìnnyaulilanga uhiu kuva, akàmwona, àmbennyangalalila kupita avala tisini na tisa vakáhochedile. ");
INSERT INTO kde_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Uchocho, Atata wenu avêle kulihunde akátamwa kananga yumo wa avano vajoko ahochele.” ");
INSERT INTO kde_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nkúkulupila nnyako akàkutendela lahakalenge, hwena ukan'dume, wako na nang'e weka. Akàkupilikana ìmbekuva ùnimpata kavila nnyako. ");
INSERT INTO kde_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Henga akànakupilikane, ntwale munu yumo au vavili uhwene navo, uchinga ììve muchi Malemba Lanaswe chilahaula kuva, kila lilove limaihwe kwa mashahidi vavili au vatatu. ");
INSERT INTO kde_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Akàlema kuvapilikana vanang'o, bahi lihaulile likuwa lya vanu vangukulupîla, na akàlema kulipilikanila likuwa lya vanu vangukulupîla, lekana nawe malinga chimutenda kwa munu akámmaite Nnungu au nkútwala kodi. ");
INSERT INTO kde_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Nangu nìnnyaulilanga kavila kuva, lyohelyo limumbelihunga pachilambo lìmbehungwa na kulihunde, na lyohelyo limumbelihungula pachilambo lìmbehunguliwa na kulihunde. ");
INSERT INTO kde_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nangu nìnnyaulilanga uhiu kavila kuva, vanu vavili mmwenu vakàyambukilana pachilambo kuyuwa chinu chohecho, Atatangu wa kulihunde achiavatendele. ");
INSERT INTO kde_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kwa kuva, pachinu pohepo pavakojana vanu vavili au vatatu ing'anya yang'une, nangu mbèpamo na vanang'o.” ");
INSERT INTO kde_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Bahi Petulo nkummwenela Yesu, nkummuja kuchidoni, “Nang'olo, nnung'unwangu akàngutendela lahakalenge, ninsamehe myanda mingapi? Dachi mpaka myanda saba?” ");
INSERT INTO kde_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu nkunnyang'ula kuchidoni, “Nikáhaula chihi myanda saba bahi, henga ata saba mala sabini. ");
INSERT INTO kde_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kwa kuva, Ufalume wa Nnungu ùlandana na nfalume anakudungidile kutenda isabu ya dihela dyachivalonga vatumishi vake. ");
INSERT INTO kde_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Patandilike kutenda isabu ya madeni lachilonga, vanu vanji nkuida na munu yumo wachinnonga dihela dyohe namene. ");
INSERT INTO kde_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nang'e kwa kuva nanga pánavèlè na cha kulipa, nfalume nkwamula asumiswe, nang'e pamo na n'jawe na vanavake na kila chinu chavenacho, uchinga valipe lideni. ");
INSERT INTO kde_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Bahi ntumishi aneyo nkutindivala malundi muyo mwake, nkunnyaulila kuchidoni, ‘Ngupililile, nguchinikulipe lideni lyako lyammalele.’ ");
INSERT INTO kde_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Bahi nfalume wake nkummikila chididi, nkunsamehe alila lideni, nkunneka auke. ");
INSERT INTO kde_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Henga munu aneyo nkukojana na ntumishi nnyake wachinnonga sendi kadiki. Nkunkamula, nkunnikiha pang'ulo, wachidoni, ‘Ngulipe dihela dyangu!’ ");
INSERT INTO kde_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ntumishi nnyake nkutindivala malundi nkunnyuwa namene wachidoni, ‘Ngupililile, nguchinikulipe.’ ");
INSERT INTO kde_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Henga nang'e nkuhita, nkunnyunga nnyake nnilungu, mpaka anepo pámbelìpà alila lideni. ");
INSERT INTO kde_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Vatumishi vanji pavachonite achila chitendeke, nkuhinginika namene, nkuhwena unannyaulila nfalume wavo kila chinu chitendêke. ");
INSERT INTO kde_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Bahi nfalume wavo nkunchema ayula ntumishi, nkunnyaulila kuchidoni, ‘Wako nni ntumishi utênda lahakalenge. Ńnikusamehe lideni lyammalele kwa kuva uninguyuwa ngutende uchocho. ");
INSERT INTO kde_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Dachi, ukáchilembelewa ummikile chididi ntumishi nnyako muchi nangu chinikuvikidile wako chididi?’ ");
INSERT INTO kde_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Bahi nfalume nkutunduwila namene, nkunnyunga nnilungu abanike mpaka alipe lideni lyammalele. ");
INSERT INTO kde_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Uvila njo chambentendela mwenu Atatangu wa kulihunde, ikàva wako nanga paunsamehe nkúkulupila nnyako kuhaloka muntima.” ");
INSERT INTO kde_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu pamalidile kutangola habali anedyo, nkuuka chilambo cha ku Galilaya nkuhwena nchilambo cha ku Yudeya, kung'ambo muto wa Yoludani. ");
INSERT INTO kde_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Makuwa makulu la vanu nkumpapata, aneko nkuvalamya avala vánavele vagonjo. ");
INSERT INTO kde_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mafalisayo vanji nkummwenela Yesu uchinga vanninge, nkummuja kuchidoni, “Dachi Sheliya ya Musa ìnaluhusu nnume unneka n'jawe kwa ing'anya yoheyo?” ");
INSERT INTO kde_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu nkuvayang'ula kuchidoni, “Dachi, nanga pamusomile Mmalemba Lanaswe kutandikila patandi kuva, ‘Nnungu Nkúumba, ámmumbile munu nnume na mmahe?’ ");
INSERT INTO kde_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Bahi Nnungu nkutangola kuchidoni, ‘Ing'anya ya anelyo, nnume àmbenneka atatake na anyokwe, koka alundane na n'jawe, na anevo vavili vàmbekuva mmili umo?’ ");
INSERT INTO kde_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kupapatana na anelyo, vanang'o akee vavili kavila, henga nni mmili umo. Bahi vavalundanyîje Nnungu, munu anavahapulânye.” ");
INSERT INTO kde_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Anepo Mafalisayo nkummuja Yesu kuchidoni, “Mwadachi Musa ániamulisa kuva nnume àlembelewa amwing'e n'jawe talaka na kunneka?” ");
INSERT INTO kde_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu nkuvayang'ula kuchidoni, “Musa áninnuhusu muvaleke vamahe venu ing'anya ya kukamajanga kwa mitima yenu. Henga kutandikila anepo patandi ikánavele uchocho. ");
INSERT INTO kde_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nangu nìnnyaulilanga kuva, munu woheyo annêka n'jawe ikànave chihi kwa ing'anya ya kulala ugoni, nkunannomba mmahe yunji, aneyo àlalá ugoni.” ");
INSERT INTO kde_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Vakuhundwa vake nkunnyaulila kuchidoni, “Ikàva uvila njo chiiva kwa nnume na n'jawe, wasa kuikala chihi bila kulomba.” ");
INSERT INTO kde_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu nkuvahaulila kuchidoni, “Akee kila munu ahulûla kuikala chihi bila kulomba, ila avala vahululîhwa na Nnungu. ");
INSERT INTO kde_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kwa kuva, pàvele vanu vanji vakáhulula kulomba ing'anya vávelekwejije chihi akuno vavèlè mikuda, na vanji vàtendwije na vanu kuva mikuda, na vanji vàniamula chihi vanalombe ing'anya ya kuutumikila Ufalume wa Nnungu. Henga munu ahulûla kuikala chihi bila kulomba, analombe.” ");
INSERT INTO kde_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Anepo vanu nkumpelekejija Yesu vavana vajoko uchinga avavikile makono na kuvayuwila, henga vakuhundwa vake nkuvakalipila avala vanu. ");
INSERT INTO kde_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu nkuhaula kuchidoni, “Valekange vana vajoko vaidang'ane kwang'une, wala munavadivile, kwa kuva, Ufalume wa Nnungu nni wa vanu vavêle muchi vavana ava.” ");
INSERT INTO kde_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Bahi Yesu pamalidile kuvavikila makono na kuvabaliki, nkuuka apala pachinu. ");
INSERT INTO kde_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Lola, munu yumo nkumwidila Yesu, nkummuja kuchidoni, “Nkúhunda, dachi, ngútende lilida lyambone, uchinga ngupate umi ukee na ntululilo?” ");
INSERT INTO kde_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu nkunnyang'ula kuchidoni, “Mwadachi ùnguuja kuyamba lyambone? Nnungu weka njo wambone bahi. Na ukàlembela kuupata umi ukee na ntululilo, dikamule amuli dya Nnungu.” ");
INSERT INTO kde_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ayula munu nkuuja kuchidoni, “Amuli ntwani?” Yesu nkuyang'ula kuchidoni, “Unawalale, unalale ugoni, unaive, unahumye ushahidi wa kulambila, ");
INSERT INTO kde_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","mweshimu atatako na anyoko, na ntamwe nnyako malinga chiulitamwa umwene.” ");
INSERT INTO kde_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ayula kijana nkunnyaulila Yesu kuchidoni, “Anedyo amuli dyammalele nangu ǹnidikamula. Dachi, ngùisalijiwije na lilida kavila?” ");
INSERT INTO kde_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu nkunnyang'ula kuchidoni, “Wako ukàlembela ukamilike, hwena ukasumise vitukutuku vyako koka dihela uveng'e amahuvani. Na wako uchiuve na dimali kulihunde, koka uuye ungupapate.” ");
INSERT INTO kde_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ayula kijana papilikene uchocho, nkuuka akuno apoywèkè ing'anya ávele na dimali dyohe namene. ");
INSERT INTO kde_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Anepo Yesu nkuvahaulila vakuhundwa vake kuchidoni, “Nangu nìnnyaulilanga uhiu kuva, ìnikamajanga namene nkúpata kuinjila mu Ufalume wa Nnungu. ");
INSERT INTO kde_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nìnnyaulilanga kavila kuva, ìnipeyapeya namene nnyama uvanchema ungamila kupita nchitonono cha isindano kuliko nkúpata kuinjila mu Ufalume wa Nnungu.” ");
INSERT INTO kde_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Vakuhundwa vake pavapilikene malove anelo nkukangana namene, nkummuja Yesu kuchidoni, “Nnani bahi ambehulûla kupohwa?” ");
INSERT INTO kde_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu nkuvapalambahija meho, nkuvahaulila kuchidoni, “Kwa dimongo dya chimunu ikáhululika, henga Nnungu ànahulula kulatenda lammalele.” ");
INSERT INTO kde_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Anepo Petulo nkummuja Yesu kuchidoni, “Lola, hwetu tùlekile vitukutuku vyammalele nkukupapata wako! Dachi, tùmbepata chamani?” ");
INSERT INTO kde_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu nkuvayang'ula kuchidoni, “Nangu nìnnyaulilanga uhiu kuva, nchilambo chiîda, Mwana wa Munu pambeikala nchiteng'u chake cha Ufalume, na mwenu mungupapete nangu mùmbeikala mmiteng'u kumi na mbili vya chifalume umuvahukumu vanu va matawa kumi na mbili la Isilaeli. ");
INSERT INTO kde_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Na kila munu ailekîle ing'ande yake au alumbuvake au akuluvake au atatake au anyokwe au vavana au mawelu ing'anya yang'une, nang'e àmbepunda kupata anelo lammalele na kuyenjejwa myanda myamoja na kupata umi ukee na ntululilo. ");
INSERT INTO kde_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Henga vanu vohe vaonekâna hambi kuva vakulu, vàmbekuva va pahi, na vanu vohe vaonekâna hambi kuva va pahi, vàmbekuva vakulu.” ");
INSERT INTO kde_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Bahi Ufalume wa Nnungu ùlandana na munu ánavele na welu wa mizabibu, anaukile ulyamba na mambumbu, uhwena unavataha vanu vakakole madengo mmwelu mwake. ");
INSERT INTO kde_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nkupatana navo avalipe nshahala wa kawaida wa malipo la liduva limo, anepo nkuvapelekeja mmwelu wake wa mizabibu. ");
INSERT INTO kde_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Malinga satatu ya ulyamba nkuuka kavila, nkuvona vanu vanji vakávele na madengo vaimidìlè kusakoni. ");
INSERT INTO kde_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nang'e nkuvahaulila kuchidoni, ‘Hweneng'ana mmwelu wangu wa mizabibu mukakole madengo, nanani nguchinimwing'ange haki yenu.’ ");
INSERT INTO kde_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Vanang'o nkuhweneng'ana. Ayula mwene welu nkuuka kavila sasita na satisa, nkutenda uchila. ");
INSERT INTO kde_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Sakumi na moja ya lyulo nkuuka kavila, nkuvona vanu vanji vaimidìlè pasakoni, nkuvauja kuchidoni, ‘Mwadachi mwìmidile chihi apano waulyamba mukavèlè na madengo?’ ");
INSERT INTO kde_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Avala vanu nkunnyang'ula kuchidoni, ‘Ing'anya nanga munu atupêle madengo la kukola.’ Nang'e nkuvahaulila, ‘Hweneng'ana mukakole madengo mmwelu wangu wa mizabibu.’ ");
INSERT INTO kde_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Liduva palichiswa, mwene welu nkunnyaulila ayula nkwímilila wake kuchidoni, ‘Vacheme vakúkola madengo vammalele uveng'e nshahala wavo, tandilika na wantululilo mpaka ntandi.’ ");
INSERT INTO kde_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Pavakamwele avala va sakumi na moja, navanang'o nkupwechela nshahala wa kawaida wa malipo la liduva limo. ");
INSERT INTO kde_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Paikamwele samu ya avala vatandi, vanang'o vátenda muchi vàmbepata dihela dyohe kuvapunda avao, henga navanang'o nkupwechela chihi kila munu nshahala wa kawaida wa malipo la liduva limo. ");
INSERT INTO kde_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Avala vanu vatandi kukola madengo pavapwechedile, nkutandilika kuntongodika mwene welu, ");
INSERT INTO kde_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","uvahaula kuchidoni, ‘Ava vanu va kuntululilo vàkodile chihi madengo kwa lisaa limo, hambi mwadachi ùtupele chihi uchimo navanang'o, wakati hwetu tùnipililila kukola madengo lakamajije waulyamba mpaka chinalyulo, na kutuvalila liduva?’ ");
INSERT INTO kde_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Mwene welu nkunnyang'ula yumo wa avala vanu kuchidoni, ‘Nnyanjawangu, nangu nanga panikukumbile. Dachi, tukanapatene nshahala uula wa kawaida wa malipo la liduva limo? ");
INSERT INTO kde_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Twala chivêle chako uuke. Nangu ngùlembela nimwing'e wa kuntululilo chinu uchimo na wako. ");
INSERT INTO kde_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Dachi, nangu nikáluhusiwa kutumila dimali dyangu malinga chíngulembèlà nimwene? Au wako ùvele na wiu ing'anya nangu nni munu wambone?’ ” ");
INSERT INTO kde_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesu nkuhweneha kutangola kuchidoni, “Bahi vanu vaonekâna hambi kuva va pahi, vàmbekuva vakulu, na vanu vaonekâna hambi kuva vakulu, vàmbekuva va pahi.” ");
INSERT INTO kde_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu pachiyomboka kuhwena ya ku Yelusalemu, ávatwete avala vakuhundwa kumi na mbili paweka, nkuvahaulila kuchidoni, ");
INSERT INTO kde_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Lola, tùvenkuyomboka kuhwena ku Yelusalemu, aneko Mwana wa Munu àmbekamujwa kwa makuhani vakulu na kwa vakúhunda Sheliya yanga Musa. Na vanang'o vàmbennyukumu kuhwa, ");
INSERT INTO kde_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","na kunkamuja mmakono la vanu vakávele Vayahudi. Vanang'o vàmbentendela mang'wanyu na kunsulubula na kummamba munsalaba. Henga liduva lya tatu lya kuhwa kwake, àmbefufulwa.” ");
INSERT INTO kde_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Anepo ayuvao vana vanga Sebedayo nkummwenela Yesu akuno apapatene na vana vake, Yakobo na Yohana. Ayula mmahe nkutindivala malundi muyo mwanga Yesu kwa kunnyuwa chinu. ");
INSERT INTO kde_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu nkummuja kuchidoni, “Ùlembela chamani?” Nang'e nkuyang'ula kuchidoni, “Paumbekuva mu Ufalume wako, ngùyuwa uvaluhusu avano anavangu vavili vaikale, yumo m'bali wako wa kunkono na yunji m'bali wako wa kunchinda.” ");
INSERT INTO kde_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu nkunnyaulila Yakobo na Yohana kuchidoni, “Mwenu mukámaite chinu chimuyuwa. Dachi, muchimuhulule kupililila ibaniki inimbebanika nangu?” Vanang'o nkunnyang'ula kuchidoni, “Elo, tùnahulula.” ");
INSERT INTO kde_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu nkuvahaulila kuchidoni, “Muhiu, ibaniki inimbebanika nangu lasima mupitile, henga kwa habali ya kuikala m'bali wangu wa kunkono au wa kunchinda anelo lakee madengo langu. Ila nafasi anedyo vàmbeikala vanu avala vávatandwèlè Atatangu.” ");
INSERT INTO kde_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Bahi avala vakuhundwa vanji kumi pavapilikene malove anelo nkuvasunalila avala vakuhundwa vavili, Yakobo na Yohana. ");
INSERT INTO kde_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yesu nkuvachema vakuhundwa vammalele, nkuvahaulila kuchidoni, “Mwenu mùnimala kuva, vakulu va vanu vakávele Vayahudi vàvatawala vanu vao kwa dimongo na kuvatumikisa. ");
INSERT INTO kde_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Henga kwenu mwenu inààve uchocho. Alembêla kuva nkulu mmwenu, àlembelewa ààve ntumishi wenu. ");
INSERT INTO kde_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Na munu woheyo mmwenu alembêla ààve ntandi, àlembelewa ààve ntumwa wenu. ");
INSERT INTO kde_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kwa kuva, Mwana wa Munu akáidile unatumikiwa, henga àidile unatumikila na kuuhumya umi wake uchinga ùùve fidiya ya kukombolewa kwa vanu vohe.” ");
INSERT INTO kde_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu na vakuhundwa vake pavachiuka pa Yeliko, likuwa likulu lya vanu nkumpapata. ");
INSERT INTO kde_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Bahi pávele na vanu vavili vaputêle meho vachiikâla nnyenje indila. Pavapilikene kuva Yesu àvenkupita, nkunonoha lidi lyavo uvachidoni, “Nang'olo, N'dukuluwe Nfalume Daudi, tùvikile chididi!” ");
INSERT INTO kde_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Likuwa lya vanu nkuvakalipila na kuvahaulila vanyalale, henga vanang'o nkuhalija chihi kunonoha lidi uvachidoni, “Nang'olo, N'dukuluwe Nfalume Daudi, tùvikile chididi!” ");
INSERT INTO kde_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu nkuimila, nkuvachema, nkuvauja kuchidoni, “Mùlembela nintendele chani?” ");
INSERT INTO kde_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Vanang'o nkunnyang'ula kuchidoni, “Nang'olo, tùyuwa ulatende meho letu lalole.” ");
INSERT INTO kde_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu nkuvavikila chididi, nkulagusa meho lavo, upala nkulola, vanang'o nkunnondola Yesu. ");
INSERT INTO kde_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu na vakuhundwa vake pavanavele pepi kuhwika ku Yelusalemu, nkuhwika chijiji cha Betifage, pepi na Lichinga lya Miseituni. Anepo Yesu nkuvatuma vakuhundwa vake vavili, ");
INSERT INTO kde_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","wavahaulila kuchidoni, “Hweneng'ana mpaka chijiji chivêle muyo mwenu. Pamumbekamola aneko, muchimumwone punda vannyungile, na mwanawe àvele upopo. Vahungulange koka muide navo. ");
INSERT INTO kde_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Na munu akàmmuja kuva mwadachi mùnannyungula nnyaulile kuva, ‘Nang'olo ànavalembela,’ na upopo aneyo munu achiannuusu muide navo.” ");
INSERT INTO kde_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Alano lammalele lánihumila, uchinga latimile malove lánatangwele nabii wachidoni, ");
INSERT INTO kde_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Vahaulile venedi va imanga ya Yelusalemu, ‘Lola, Nfalume wenu àvenkwida kwenu mwenu. Nang'e nni munu wa kulisulupuha, ànkwedile punda tena mwana wanga punda.’ ” ");
INSERT INTO kde_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Bahi avala vakuhundwa vavili nkuhweneng'ana, vanang'o nkutenda muchi Yesu chavalaijije. ");
INSERT INTO kde_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nkuida nawe punda na mwana wanga punda, nkulaja dinguwo muha mwavo, na Yesu nkuikala muha mwanga mwana wanga punda. ");
INSERT INTO kde_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Likuwa likulungwa lya vanu nkulaja dinguwo dyavo nndila, na vanji nkulumulanga dinavi dya milandi nkudilaja nndila. ");
INSERT INTO kde_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Likuwa lya vanu vanannongoledile Yesu na avala vachinnondola pachikundu, nkutandilika kunonoha malidi lavo uvahaula kuchidoni, “Ulombolewe wako N'dukuluwe Nfalume Daudi! Ubalikiwe wako uîda kwa lina lya Nang'olo! Atumbyangwe Nnungu avêle muha kulihunde!” ");
INSERT INTO kde_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Bahi Yesu painjidile muimanga ya Yelusalemu, imanga yammalele nkulindima. Vanu nkuujana kuchidoni, “Ayu nnani?” ");
INSERT INTO kde_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Likuwa lya vanu nkuyang'ula kuchidoni, “Ayu njo ayula nabii, Yesu wa ku Nasaleti chilambo cha ku Galilaya.” ");
INSERT INTO kde_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu nkuinjila nnuwani lwa Ing'ande yanga Nnungu, nkutandilika kuvavingangila pawelu vanu vammalele vachisumisa na kusuma vitukutuku, anemwo. Nkudibinula dimeza dya vanu vachibadili dihela, na viteng'u vya vanu váchisumìsà dimunda. ");
INSERT INTO kde_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Nkuvahaulila kuchidoni, “Ìnilembwa Mmalemba Lanaswe kuva, ‘Ing'ande yangu ìmbechemwa ing'ande ya kunnyuwila Nnungu.’ Henga mwenu mùniipindikulanya nkuijuha kuva muchi lipanga lya kulipiha vakúpalaula!” ");
INSERT INTO kde_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Vanu vaputêle meho na vikwavi nkummwenela Yesu umula nnuwani lwa Ing'ande ya Nnungu, nanang'e nkuvalamya. ");
INSERT INTO kde_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Henga makuhani vakulu na vakúhunda Sheliya yanga Musa nkusunala namene pavawene masaibu lalatendile na vavana vachinonoha malidi lavo nnuwani lwa Ing'ande ya Nnungu uvahaula kuchidoni, “Ulombolewe wako, N'dukuluwe Nfalume Daudi!” ");
INSERT INTO kde_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Bahi nkummuja Yesu kuchidoni, “Dachi, ùnapilikana malove lavatongolanga avano vavana?” Yesu nkuvayang'ula kuchidoni, “Elo. Dachi, mukánambisoma Malemba Lanaswe lahaûla kuva, ‘Kwa kanya dya vana vajoko na dya vakanunu wako Nnungu ùnitangasa imbili yako.’” ");
INSERT INTO kde_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Anepo nkuvaleka, nkuhuma muimanga ya Yelusalemu, nkuhwena Besaniya, nkulala aneko. ");
INSERT INTO kde_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ulyamba wake Yesu pachihwena kavila ku Yelusalemu, nkwona indala. ");
INSERT INTO kde_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nkuwona nnandi wa vihepo vya tini kunyenje indila, nkuuhengelekela, henga nanga panadiwene tini munnandi aula ila mahamba weka. Anepo Yesu nkuulani aula nnandi wachidoni, “Wako nnandi, unape kavila vihepo, kutandikila nelo na maduva lammalele!” Upala aula nnandi nkuyuma. ");
INSERT INTO kde_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Vakuhundwa vake pavawene uchocho, nkukangana namene na kuliuja kuva, “Auno nnandi upiyanyije dachi kuyuma?” ");
INSERT INTO kde_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu nkuvayang'ula kuchidoni, “Nangu nìnnyaulilanga uhiu kuva, mukàva na ing'ulupa bila kuva na lipamba, mùnahulula chihi kutenda muchi chiniutendedile nnandi auno, na uchocho muchimuhulule kulihaulila lichinga alino kuva, ‘Uka apano ukaliyahe m'bahali,’ na ichiitendeke uchocho. ");
INSERT INTO kde_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Na mukàkulupila kuva muchimupwechelele, bahi chinu chohecho chimumbennyuwa Nnungu muchimupwechelele.” ");
INSERT INTO kde_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu nkuinjila nnuwani lwa Ing'ande ya Nnungu. Pánavele nkùhunda, makuhani vakulu na vasele va Vayahudi nkummwenela Yesu nkummuja kuchidoni, “Wako ùlatenda alano kwa mamulaka ntwani? Na nnani akupêle wako mamulaka la kulatenda anelo?” ");
INSERT INTO kde_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu nkuvayang'ula kuchidoni, “Nanani uchocho nìmbemmujanga chinu chimo. Mukànguyang'ula, nguchininnyaulile ngùlatenda alano kwa mamulaka ntwani. ");
INSERT INTO kde_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Dachi, Yohana Nkúbatisa ápete mamulaka la kubatisa kuhaloka kwachi? Kuhaloka kulihunde au kwa vanu?” Vanang'o nkutandilika kuujana vene kwa vene, uvachidoni, “Tukàyang'ula kuva làhaleke kulihunde, nang'e àmbetuuja kuva, ‘Hambi mwadachi mukánankulupidile?’ ");
INSERT INTO kde_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Henga tukàhaula kuva làhaleke kwa vanu, tùvayopa ava vanu, kwa kuva vammalele vànakulupila kuva Yohana Nkúbatisa ávele nabii.” ");
INSERT INTO kde_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Bahi vanang'o nkunnyang'ula Yesu kuchidoni, “Hwetu nanga patumaite!” Yesu nanang'e nkuvahaulila kuchidoni, “Nanani uchocho nikambennyaulila kuva, ngùlatenda alano kwa mamulaka ntwani.” ");
INSERT INTO kde_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesu nkutangola kuchidoni, “Mwenu mwònadachi kuyamba habali aino? Pávele na munu yumo ánavele na vana vavili. Nang'e nkunnyaulila mwana ntandi kuvelekwa kuchidoni, ‘Mwanangu, nelo hwena ukakole madengo mmwelu wangu wa mizabibu.’ ");
INSERT INTO kde_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nang'e nkunnyang'ula kuchidoni, ‘Nikátamwa.’ Henga lukoto nkupindikuka isungu yake nkuhwena kumawelu. ");
INSERT INTO kde_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Anepo nkummwenela mwana wavili, nkunnyaulila muchi channyaulidile ntandi. Nang'e nkuyang'ula kuchidoni, ‘Nguchinguhwene atata,’ henga wala nanga panapite.” ");
INSERT INTO kde_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yesu nkuvauja kuchidoni, “Dachi, muavano vavili, alida atendîle chanalembedile atatake?” Vanang'o nkuyang'ula kuchidoni, “Nni ayula ntandi.” Bahi Yesu nkuvahaulila kuchidoni, “Nangu nìnnyaulilanga uhiu kuva, vakútwala kodi na makahaba vàvenkunnongolelela kuinjila mu Ufalume wa Nnungu. ");
INSERT INTO kde_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kwa kuva, Yohana ániida kwenu mwenu unannanguja namuna chimulembelewa kuikalanga malinga chalembela Nnungu, henga mwenu nanga pamunankulupidile. Henga vakútwala kodi na makahaba váninkulupila. Na mwenu pamo na kulona anelo lammalele, nanga pamunalekile masambi lenu na kunkulupila nang'e.” ");
INSERT INTO kde_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Pilikanila nfano unji. Pávele na munu yumo ánavele na welu, na welu anewo nkùpanda mizabibu, nkuudinguhija lingongo na nkùhimba lipondo lya kuminyila vihepo vya zabibu, nkùdenga na nnala wa kuikala valinzi va welu. Anepo nkuukodisa aula welu kwa vakúlima vanji, mwene nkuuka nkuhwena mwanda wa kulehu. ");
INSERT INTO kde_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Mahiku la lichela palakamwele, nkuvatuma vatumishi vake kwa avala vakúlima uchinga vakatwale sehemu ya vihepo vya mmwelu wake. ");
INSERT INTO kde_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Henga avala vakúlima nkuvakamula avala vatumishi. Yumo nkumpanya na yunji nkummwalala na yunji watatu nkumpanya mayanga mpaka kummwalala. ");
INSERT INTO kde_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Anepo mwene welu nkuvatuma kavila vatumishi vanji vohe kupunda vatandi, henga avala vakúlima nkuvatendela muchi chivavatendeledile avala vatandi. ");
INSERT INTO kde_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kuntululilo, nkunnaija mwanawe, wahaula kuchidoni, ‘Ǹnimala kuva mwanangu vachivamweshimu.’ ");
INSERT INTO kde_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Henga avala vakúlima pavammwene ayula mwana, nkuhaulanila kuchidoni, ‘Ayu njo mwene mapala la auno welu. Bahi leka tummwalale, koka welu auno ùùve mapala letu!’ ");
INSERT INTO kde_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Bahi nkunkamula, nkunnyumya pawelu aula welu wa mizabibu, aneko nkummwalala.” ");
INSERT INTO kde_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Anepo Yesu nkuuja kuchidoni, “Dachi, mwene welu pámbeìdà, àmbevatenda dachi avala vakúlima?” ");
INSERT INTO kde_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Vanang'o nkunnyang'ula kuchidoni, “Àmbevawalala anevo vakúlima vahakalenge mitima bila chididi, koka welu àvavikile vakúlima vanji vambemwîng'a chivêle chake kwa mahiku la lichela.” ");
INSERT INTO kde_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu nkuvauja kuchidoni, “Dachi, mukásomile alano Mmalemba Lanaswe? ‘Liyanga lihitwîje na vakúdenga, hambi lìjukile kuva liyanga likulu lya paindumba, lya muhimu kupunda lammalele. Na Nang'olo njo atendîle chinu anecho, na ìyonekana kuva lisaibu pameho petu.’ ");
INSERT INTO kde_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Bahi nìnnyaulilanga kuchidoni, Ufalume wa Nnungu ùmbeuswa kwenu mwenu na kuveng'a vanu vanji vambetênda àlalá lalalembela Nnungu. ");
INSERT INTO kde_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Munu woheyo ambeyangukîla nniyanga anelyo àmbelumukana, na munu woheyo ulimbemmatokela, àmbetingindika mwalehu.” ");
INSERT INTO kde_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Makuhani vakulu na Mafalisayo pavapilikene mifano yanga Yesu, vánimala kuva àvayamba vanang'o. ");
INSERT INTO kde_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Bahi nkutaha namuna ya kunkamula Yesu, henga nkuyopa makuwa la vanu kwa kuva, vanang'o vánikulupila kuva nang'e nni nabii. ");
INSERT INTO kde_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Bahi Yesu nkuhweneha kutangola na alila likuwa lya vanu kwa mifano. Nkuvahaulila kuchidoni, ");
INSERT INTO kde_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ufalume wa Nnungu ùlandana na nfalume yumo antendeledîle mwanawe ing'ole ya ulombi. ");
INSERT INTO kde_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Bahi nkuvatuma vatumishi vake unavachema avala vakumbuliwîje kuing'ole, henga vanang'o nanga pavanatamwije kwida. ");
INSERT INTO kde_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Anepo nkuvalaija vatumishi vanji, nkuvahaulila kuchidoni, ‘Hweneng'ana mukavahaulile vakumbuliwîje kuva, ing'ole yangu hambi ìvele tayali. Ǹnisinja maluchi langu la ang'ombe na ang'ombe vanji vanunîle, vitukutuku vyammalele vìvele tayali. Vahaulile vaide kuing'ole!’ ");
INSERT INTO kde_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Henga avala vakumbuliwîje nanga pavanajalite aneko kukumbulwa, nkulihwenela chihi kuvalembedile vene, yumo nkuhwena kumawelu kwake na yunji nkuhwena kumadengo lake la kuchuusa. ");
INSERT INTO kde_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Na vanji nkuvakamula avala vatumishi nkuvalagiha na kuvawalala. ");
INSERT INTO kde_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Bahi nfalume nkusunala. Nkuvatuma matiyala lake unavawalala avala vakúwalala na kuyocha imanga yavo moto. ");
INSERT INTO kde_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Anepo nkuvahaulila vatumishi vake kuchidoni, ‘Ing'ole ya ulombi ìvele tayali, henga avala vakumbuliwîje nanga pavachilembelewa kwida. ");
INSERT INTO kde_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Bahi hweneng'ana mmadila, na vanu vammalele umumbevona vakumbule vaide kuing'ole.’ ");
INSERT INTO kde_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Bahi avala vatumishi nkuhweneng'ana n'dindila, nkuvalapola vanu vammalele uvachivona, vanu vambone na vatênda lahakalenge, na nnukumbi lwammalele lwa ing'ole nkuombala vayeni. ");
INSERT INTO kde_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Henga painjidile nfalume unavalola vayeni vake, nkumwona munu yumo akanawete inguwo ya ing'ole ya ulombi. ");
INSERT INTO kde_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nkummuja kuchidoni, ‘Nnyanjawangu, uinjidile dachi apano akuno ukawètè dinguwo dya ing'ole ya ulombi?’ Ayula munu nkunyalala chihi nduu. ");
INSERT INTO kde_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Anepo nfalume nkuvahaulila vatumishi vake kuchidoni, ‘Nnyungange ayuno munu makono na madodo, koka munnyahe pawelu pavêle lupi. Aneko àmbekuta na kuhaya meno.’ ” ");
INSERT INTO kde_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Anepo Yesu nkutangola kuchidoni, “Kwa kuva, vanu vohe vànakumbulwa, henga vatandôlwa vavêle kadiki.” ");
INSERT INTO kde_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Anepo Mafalisayo nkuukananga apala nkunavika ntemelo wa kunteya Yesu uchinga vankamule umomo mmalove lake. ");
INSERT INTO kde_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Mafalisayo nkuvatuma vakuhundwa vao pamo na vanu va likuwa lya Helode, nkunammuja Yesu kuchidoni, “Nkúhunda, tùnimala kuva wako nni munu wa uhiu na ùhunda chihi kwa uhiu kuyamba indila ya Nnungu. Na wala nanga pauyopa ukulu wanga munu, kwa kuva, nanga paulola kumeho kwanga munu. ");
INSERT INTO kde_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Bahi tuhaulile, chuwona wako, dachi Sheliya ya Musa ìnatuluhusu kuhumya kodi kwa Nfalume wa Loma au ikátuluhusu?” ");
INSERT INTO kde_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Henga Yesu kwa kuva ánilamala lahakalenge lavakudungidile, nkuvayang'ula kuchidoni, “Mwenu mmakulilambilila, ing'anya ntwani mùnangulinga? ");
INSERT INTO kde_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ndanguje hela ihûmywa kodi kwa Nfalume wa Loma.” Vanang'o nkumpelekejeja. ");
INSERT INTO kde_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yesu nkuvauja kuchidoni, “Dachi, ing'ope aino na lina lilembwîje apano lyanga nnani?” ");
INSERT INTO kde_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Vanang'o nkunnyang'ula kuchidoni, “Vyanga Nfalume wa Loma.” Anepo Yesu nkuvahaulila kuchidoni, “Bahi la Nfalume wa Loma mwing'e Nfalume wa Loma na la Nnungu mwing'e Nnungu.” ");
INSERT INTO kde_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Bahi vanang'o pavapilikene mayang'udi lake, nkukangana namene, nkunneka Yesu, vanang'o nkulihwenela. ");
INSERT INTO kde_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Liduva ulyolyo Masadukayo vanji vakulupîla kuva, vanu vahwîle vakáfufuka, nkummwenela Yesu nkummuja kuchidoni, ");
INSERT INTO kde_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Nkúhunda, Musa átuhaulidile uvila, ‘Nnume akàhila nkunneka n'jawe bila kummelekela vana, nnung'une àlembelewa annombe aneyo mmahe uchinga ammelekele nkuluwe vana.’ ");
INSERT INTO kde_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Pávele na vana saba va chilume va litumbo limo. Ayula ntandi ánnombile mmahe, nkuhila bila kummeleka mwana, na ayula nannidi nkutwaliwa na nnamuwe. ");
INSERT INTO kde_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nanang'e nkuhila bila kummelekela mwana, na nnamuwe watatu nanang'e nkwenda makande, nanang'e nkuhila, bahi vammalele saba nkuhilanga bila kummelekela mwana. ");
INSERT INTO kde_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kuntululilo ayula mmahe nanang'e nkuhila. ");
INSERT INTO kde_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Dachi, liduva livambefufuliwa vanu vahwîle ayula nkongwe àmbekuva wanga nnani? Kwa kuva, valume vammalele saba vániikalana nawe.” ");
INSERT INTO kde_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu nkuvahaulila kuchidoni, “Mwenu mùnakumbika ing'anya nanga pamulamaite Malemba Lanaswe wala dimongo dyanga Nnungu. ");
INSERT INTO kde_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kwa kuva, vanu vahwîle pavambefufuka, nanga pavambelomba wala kulombwa, ila vàmbekuva muchi malaika va kulihunde. ");
INSERT INTO kde_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Henga kwa habali ya kufufulwa kwa vanu vahwîle, dachi mukánambisoma chanannyaulidile Nnungu? ");
INSERT INTO kde_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Nnungu áhawile kuchidoni, ‘Nangu njo Nnungu wa Iblahimu, Nnungu wa Isaka, na Nnungu wa Yakobo.’” Yesu nkuhweneha kuvahaulila kuchidoni, “Nnungu akávele Nnungu wa vanu vahwîle, henga nang'e nni Nnungu wa vanu vumi.” ");
INSERT INTO kde_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Makuwa la vanu pavapilikene malove anelo, nkukangana namene ing'anya ya mahundo lake. ");
INSERT INTO kde_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mafalisayo pavapilikene kuva Yesu ánivanyalaja Masadukayo, nkukojana pamo nkummwenela. ");
INSERT INTO kde_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Munu yumo muanevo ánaimaite namene Sheliya yanga Musa nkummwenela Yesu nkummuja kwa kunninga, ");
INSERT INTO kde_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","wachidoni, “Nkúhunda, amuli ntwani ing'ulu kupunda dyammalele mu Sheliya yanga Musa?” ");
INSERT INTO kde_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu nkunnyang'ula kuchidoni, “‘Ntamwe Nang'olo Nnungu wako kwa ntima wako wammalele na kwa isungu yako yammalele na kwa ding'ano dyako dyammalele.’ ");
INSERT INTO kde_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Aino njo amuli ing'ulu na njo inandi. ");
INSERT INTO kde_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na yavili ilandâna na ai nni aino, ‘Ntamwe nnyako malinga chiulitamwa umwene.’ ");
INSERT INTO kde_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Sheliya yammalele yanga Musa na mahundo la manabii, vyammalele vìlisingila amuli adino dimbili.” ");
INSERT INTO kde_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Yesu pavawene Mafalisayo vakojènè pamo, nkuvauja kuchidoni, ");
INSERT INTO kde_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Dachi mwenu mùtenda kuva Kilisto ni nnani? Dachi, nang'e nni n'dukuluwe nnani?” Vanang'o nkunnyang'ula kuchidoni, “N'dukuluwe Nfalume Daudi.” ");
INSERT INTO kde_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu nkuvahaulila kuchidoni, “Ìhululika dachi, Nfalume Daudi mwene kwa kulojwa na Umumu Wanaswe ancheme Kilisto, Nang'olo? Kwa kuva, àhaula kuchidoni, ");
INSERT INTO kde_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Nnungu Nang'olo ánnyaulidile Nang'olo wangu kuchidoni, Ikala mumamulaka langu, m'bali wangu wa kunkono, mpaka panimbevavika amongo vako pahi makumbatu lako.’ ");
INSERT INTO kde_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Bahi ikàva Nfalume Daudi ànchema Kilisto ‘Nang'olo,’ ìmbehululika dachi Kilisto ààve n'dukuluwe?” ");
INSERT INTO kde_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nanga munu analingile kunnyang'ula lilove, na kutandikila liduva anelyo nanga analingile kummuja kavila. ");
INSERT INTO kde_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Anepo Yesu nkulahaulila makuwa la vanu na vakuhundwa vake kuchidoni, ");
INSERT INTO kde_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Vakúhunda Sheliya ya Musa na Mafalisayo vatwête nafasi yanga Musa. ");
INSERT INTO kde_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Bahi mùlembelewa kuvapilikana na kukamula malove lammalele lavannyaulila, henga munapapate àlalá lávatendàngà, kwa kuva malove lavahaulanga akee lávatendàngà. ");
INSERT INTO kde_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Vanang'o vàhunga misigo iidôpa na kuvatika vanu mmavala, henga vene vakálinga kananga kunyoloja chala kuvapwechela. ");
INSERT INTO kde_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kila chinu chivachitenda vàchitenda chihi uchinga vanu vavalole. Vànatumbuja dibadili divahûnga mmalyenye lavo na mmakono, mmêle Malemba Lanaswe la Sheliya ya Musa nkati mwake, na vànalepyanga misuwana ya mmapepe la majoho lavo. ");
INSERT INTO kde_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Vànatamwa namene kuikala mmiteng'u vya muyo n'ding'ole na kuikala nafasi dya kweshimika n'ding'ande dya kunnyuwila Nnungu. ");
INSERT INTO kde_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Vànatamwa namene kusalimiwa kwa eshima kusakoni na kuchemwa na vanu, ‘Nkúhunda.’ ");
INSERT INTO kde_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Henga mwenu mùnakubali kuchemwa ‘Nkúhunda,’ kwa kuva mwenu mmammalele nni ummamo, na mùvele chihi na nkúhunda yumo. ");
INSERT INTO kde_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Uchocho, apano pachilambo munancheme munu woheyo ‘Atata’ kwa kuva mùvele chihi na Atata yumo, avêle kulihunde. ");
INSERT INTO kde_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Wala munakubali kuchemwa ‘Mmakulu,’ kwa kuva mùvele chihi na nkulu yumo, nanang'e njo Kilisto atandolwejîje na Nnungu. ");
INSERT INTO kde_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Henga nkulungwa mmwenu, àlembelewa ààve ntumishi wenu. ");
INSERT INTO kde_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Munu woheyo alitumbyânga mwene, àmbesulupuswa, henga munu alisulupûha, àmbetumbyangwa.” ");
INSERT INTO kde_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","“Ole wenu mwenu mmakuhunda Sheliya ya Musa na Mafalisayo, mmakulilambilila mwenu! Kwa kuva, mwenu mùvachimila vanu nnango wa mu Ufalume wa Nnungu, na mwenu mmene mukáinjila, na avala valembêla kuinjila mùnivadivila vanainjile. ");
INSERT INTO kde_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ole wenu mwenu mmakuhunda Sheliya ya Musa na Mafalisayo, mmakulilambilila mwenu! Kwa kuva, mùhwena myanda ya kupita m'bahali na mukee m'bahali uchinga mumpindikulanye kananga munu yumo kuva nkúhundwa wenu. Pamumpindikulanya, mùntenda ààve munu wa Jihannamu myanda mivili kumpunda mwenu mmene. ");
INSERT INTO kde_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ole wenu mwenu mmakulodya muputêle meho! Kwa kuva, mwenu mùhaula kuva munu akàapila kwa kuitambulanga Ing'ande ya Nnungu, anecho chikee chinu, henga akàapila kwa kutambulanga zahabu ivêle mu Ing'ande ya Nnungu, àlembelewa atimise achila chaapidile. ");
INSERT INTO kde_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mwenu m̀mamavelu na mmanu muputêle meho! Dachi, chikulungwa namene chilida, zahabu au Ing'ande yanga Nnungu iitênda aila zahabu ivalangiwe kuva yanaswe? ");
INSERT INTO kde_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Uchocho mùhaula kuva, ‘Munu akàapila kwa kutambulanga chitala, anecho chikee chinu, henga munu akàapila kwa kutambulanga sadaka ivêle pachitala, àlembelewa atimise achila chaapidile.’ ");
INSERT INTO kde_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mwenu nni mmanu muputêle meho! Dachi, chilida chikulungwa namene, sadaka au chitala chiitênda sadaka aila kuva yanaswe? ");
INSERT INTO kde_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Bahi munu aapîla kwa kutambulanga chitala, àapila kwa chitala anecho na kwa vitukutuku vyammalele vivelênge pachitala. ");
INSERT INTO kde_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Uchocho, munu aapîla kwa kutambulanga Ing'ande ya Nnungu, àapila kwa ing'ande aneyo na kwa Nnungu avêle nkati mwake. ");
INSERT INTO kde_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na munu aapîla kwa kutambulanga kulihunde, àapila kwa chiteng'u cha Nnungu na kwa Nnungu aikâla pachiteng'u anecho. ");
INSERT INTO kde_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ole wenu mwenu mmakuhunda Sheliya ya Musa na Mafalisayo, mmakulilambilila mwenu! Kwa kuva, mwenu mùnajali namene kuhumya asilimiya kumi ata kwa vitukutuku vijoko malinga vitakilo vya kukoleja muimbowa, akuno umulekanga vitukutuku vya muhimu vya Sheliya, yani kuvatendela vanu vanji haki na kuvavikila chididi vanu vanji, na kukulupika. Anelo njo lamulembelewa kulakamula bila kuleka kulatenda na anelo lanji. ");
INSERT INTO kde_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mwenu nni mmakulodya muputêle meho! Pamukumbila, mwenu mùnajali namene kuhamata dinjenjema nkummila ungamila. ");
INSERT INTO kde_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ole wenu mwenu mmakuhunda Sheliya ya Musa na Mafalisayo, mmakulilambilila mwenu! Kwa kuva, mwenu mùvele muchi munu àhahula mwawo na nkungu pannima, henga nkati mwòmbele chihi kung'unuka na kupakanyola. ");
INSERT INTO kde_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Wako Nfalisayo uputêle meho! Tandilika kuhahula nkati chikombe nahoti, uchinga pawelu napanang'o patakate. ");
INSERT INTO kde_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ole wenu mwenu mmakuhunda Sheliya ya Musa na Mafalisayo, mmakulilambilila mwenu! Kwa kuva, mùlandene na misati ipambwîje kwa pawelu, henga nkati mwòmbele chihi mawangwa la vanu vahwîle na kila namuna ya uhakwa. ");
INSERT INTO kde_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Uchocho na mwenu njo chimuva, kwa pawelu mwònekana kuva mmambone pameho pavanu, henga nkati mwenu mwòmbele chihi ulamba na vitendo vihakalenge.” ");
INSERT INTO kde_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ole wenu mwenu mmakuhunda Sheliya ya Musa na Mafalisayo, mmakulilambilila mwenu! Kwa kuva, mùdengela misati ya manabii na kulemba misati ya vanu vánavele vambone, ");
INSERT INTO kde_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","na mùhaula kuva, ‘Hwetu tukachiva utupwawa machedo mmaduva lavanapwawije anyakala vetu, tukanalundane navanang'o kuvawalala manabii.’ ");
INSERT INTO kde_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Bahi mwenu mùlimaiha mmene kuva mwenu nni mmadukulu mma vanu vavawalêle manabii. ");
INSERT INTO kde_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Bahi malilila anelo lavatandihije anyakalavenu! ");
INSERT INTO kde_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mwenu nni mihongo, mmana mma nachihungo! Ǹnembehulula dachi kuitila hukumu ya Jihannamu? ");
INSERT INTO kde_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kwa kuva, nìmpelekejija mwenu manabii na vanu vavêle na lúnda na vakúhunda. Henga vanji mùmbevawalala na vanji mùmbevavamba mmisalaba na vanji mùmbevasulubula n'ding'ande dyenu dya kunnyuwila Nnungu na kuvavinganga muimanga imo mpaka inji. ");
INSERT INTO kde_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Mwenu mùmbepata asabu ing'anya ya vanu vambone pameho pa Nnungu vawalaliwîje, kutandikila kuwalalwa kwanga Habilu ánavele wambone pameho panga Nnungu, mpaka kuwalalwa kwanga Sakaliya mwana wanga Balakiya, umummwalalidile nnuwani lwa Ing'ande ya Nnungu ching'ati Ing'ande ya Nnungu na chitala cha kuhumija sadaka. ");
INSERT INTO kde_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nangu nìnnyaulilanga uhiu kuva, vanu va chívelèkwà achino vàmbehukumiwa asabu ing'anya ya kuwalalwa kwa vanu anevo vammalele.” ");
INSERT INTO kde_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yesu nkuhweneha kutangola wachidoni, “Mwenu mmanu mma ku Yelusalemu, mmanu mma ku Yelusalemu! Mwenu mùvawalala manabii na kuvapanya mayanga avala vatumwîje kwenu mwenu. Myanda yohe ǹnilinga kuvalopolela pamo vana venu muchi ung'uku chavautamila vana vake paliungu dimapa dyake, henga mwenu nanga pamutamwije. ");
INSERT INTO kde_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Lola, Ing'ande yenu ya Nnungu ìmbekuva lihame. ");
INSERT INTO kde_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Na nangu nìnnyaulilanga kuva, mukambengwona kavila mpaka pamumbehaula kuva, ‘Ubalikiwe wako uîda kwa lina lya Nang'olo.’ ” ");
INSERT INTO kde_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu nkuuka pa Ing'ande ya Nnungu, pánavele nkuhwena vakuhundwa vake nkummwenela nkunnanguja ding'ande dya pa Ing'ande ya Nnungu. ");
INSERT INTO kde_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesu nkuvauja kuchidoni, “Dachi, mùvenkulona anelo lammalele? Nangu nìnnyaulilanga uhiu kuva, nanga liyanga limbeisalîla muha liyanga linji, kila liyanga lìmbematohijwa pahi.” ");
INSERT INTO kde_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Bahi Yesu panaikele muha Lichinga lya Miseituni, vakuhundwa vake nkummwenela paweka, nkummuja kuchidoni, “Tuhaulile, vitukutuku anevyo vìmbehumila chakani? Na chimaiho ntwani chimbelangûja kwida kwako, na ntululilo wa mahiku alano?” ");
INSERT INTO kde_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu nkuvayang'ula kuchidoni, “Lyongolelange uchinga munahochejwe. ");
INSERT INTO kde_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kwa kuva, vanu vohe vàmbeida uvalitenda kuva vanang'o njo nangu, uvachidoni, ‘Nangu njo Kilisto!’ Vanu anevo vàmbevahocheja vanu vohe. ");
INSERT INTO kde_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mùmbepilikana habali dya ing'ondo na habali dya ing'ondo, henga munayope. Kwa kuva, anelo lasima laide, henga aula ntululilo ukánambikamola. ");
INSERT INTO kde_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kwa kuva, chilambo chimo chìmbepanyana na chilambo chinji, na ufalume umo ùmbepanyana na ufalume unji. Kùmbekuva na indala ing'ulu na sehemu dyohe dya pachilambo dìmbendengenda. ");
INSERT INTO kde_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Anelo lammalele làvele muchi kulindamuka kwa uchungu wa kuveleka. ");
INSERT INTO kde_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Anepo nnembekamujwa mmakono la vanu vanji uchinga m'banihwe na kuwalalwa, na vanu va vilambo vyammalele vàmbemmenga mwenu ing'anya yang'une. ");
INSERT INTO kde_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Chipindi anecho nni chivambelekanga vanu vohe ing'ulupa yavo, vàmbetengelekana vene kwa vene na kuvengana. ");
INSERT INTO kde_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Vàmbehumila manabii vohe va kulambila na kuvahocheja vanu vohe. ");
INSERT INTO kde_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ing'anya ya kuyenjejeka kwa lahakalenge, kutamwana kwa vanu vohe kumbehang'uka. ");
INSERT INTO kde_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Henga ambepililîla mpaka kuntululilo, aneyo njo ambepôhwa. ");
INSERT INTO kde_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Na kabla ya kuhwika anewo ntululilo, Malove Lambone la Ufalume wa Nnungu làmbehubiliwa pachilambo chammalele kuva ushahidi kwa vanu va vilambo vyammalele.” ");
INSERT INTO kde_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Bahi munu ambesôma chitabu achino, àlembelewa apilikanihe saana mana ya malove laîda. Anepo Yesu nkuhweneha kutangola wachidoni, “Bahi anepo mùmbechona chinu chanahawile nabii Danieli, chinu chiitênda Ing'ande ya Nnungu kuva najisi chiimijìjwè pa Ing'ande ya Nnungu. ");
INSERT INTO kde_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Anepo vavelênge kuchilambo cha ku Yudeya vatukutile kumachinga. ");
INSERT INTO kde_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Na munu avêle muha ing'ande analitinike kwa kutukutila nng'ande unatwala vitukutuku vyake. ");
INSERT INTO kde_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Na avêle kumawelu nanang'e uchocho, anauye kukaya únatwala lijoho lyake. ");
INSERT INTO kde_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ole wavo amahe vavêle na vitumbo na vayong'êja mmahiku anelo. ");
INSERT INTO kde_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nnyuwange Nnungu uchinga kutila kwenu kunave mmahiku la chipwepwe au Liduva lya Kuyewelela. ");
INSERT INTO kde_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kwa kuva, mmahiku anelo kùmbekuva na ibaniki ing'ulu ikánambipwawa kutandikila Nnungu pachiumbile chilambo mpaka vino, na ibaniki malinga aneyo ikámbehumila kavila. ");
INSERT INTO kde_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kuikave Nnungu akàinjipiha isabu ya mahiku àlalá la ibaniki akánapwawe munu kananga yumo achichiapohwe. Henga ing'anya ya vanu vake vávatondwèlè, àniinjipiha mahiku anelo. ");
INSERT INTO kde_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Anepo munu akànnyaulila kuva, ‘Lola, Kilisto àvele apano,’ au ‘Àvele apala,’ munakulupile. ");
INSERT INTO kde_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kwa kuva, vàmbeida vanu vambelilambilîla kuva vanang'o njo Kilisto, uchocho vàmbeida manabii va kulambila. Vanu anevo vàmbetenda vimaiho vikulu na masaibu, uchinga ikàhululika vapate kuvahocheja ata vanu vávatandwêle Nnungu. ");
INSERT INTO kde_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Lola, nangu ǹninnyaulilanga kabla anelo lammalele lakànambihumila. ");
INSERT INTO kde_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Bahi vanu vakannyaulila kuva, ‘Lola, Kilisto àvele kulilanga!’ Munahwene aneko. Au vakannyaulila kuva, ‘Lola, àlipihite nng'ande!’ Munavakulupile. ");
INSERT INTO kde_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kwa kuva, kwida kwanga Mwana wa Munu kùmbekuva muchi nng'anje wa ing'uva chiuhumila gafula kumahunde na kulangaja kumahunde kwammalele. ");
INSERT INTO kde_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Bahi pohepo pauvele ntuhi njo pavambekojana vipungo.” ");
INSERT INTO kde_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yesu nkuhweneha kutangola wachidoni, “Upopo, palalembemalilika maduva la kubanika, ‘Liduva lìmbekuva na lupi na mwedi ukambelangaja na dinondwa dimbematoka kuhaloka kumahunde na vitukutuku vyammalele vya kumahunde vivêle na dimongo, vìmbetikinyika.’ ");
INSERT INTO kde_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Anepo njo pachimbekwonekana chimaiho changa Mwana wa Munu kumahunde. Vanu vammalele va pachilambo vàmbekutanga, na vàmbemwona Mwana wa Munu avèlè mmahunde waida, akuno avèlè na dimongo na ukulu nkulu. ");
INSERT INTO kde_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Anepo àmbevatuma malaika vake kwa lidi litumbwile lya lipenga na vàmbevalopola vanu vake vávatandwèlè kuhaloka nchilambo chammalele. ");
INSERT INTO kde_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Bahi kwa nnandi wa ntini lihundange nfano auno. Dinavi dyake padihipuka na kulikwasula mahamba, mwenu mùnamala kuva chihuku chìvele pepi. ");
INSERT INTO kde_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Na mwenu uchocho, pamumbelona ulahumila anelo lammalele laninnyaulidile, bahi mumale kuva uhiku wa kwida kwake ùvele pepi kukamola, tena ùvele chihi pannango. ");
INSERT INTO kde_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nangu nìnnyaulilanga uhiu kuva, vanu va chívelèkwà achino vakambepita mpaka palambetimila anelo lammalele. ");
INSERT INTO kde_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kumahunde na chilambo vìmbepita, henga malove langu lakambepita mwiko.” ");
INSERT INTO kde_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Henga kuyamba liduva na uhiku wene anewo, nanga munu amaîte, ata malaika va kulihunde nanga pavamaite, wala Mwana nanga pamaite, henga Atata weka njo amaîte. ");
INSERT INTO kde_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Malinga chilanavele mahiku langa Nuhu, nni uchocho chiimbekuva pambekwida Mwana wa Munu. ");
INSERT INTO kde_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kwa kuva, mmahiku àlalá livambwe kabla likànambikwida, vanu vánalya na kukumbila, vánalomba na kulombwa mpaka liduva alila lyainjidile Nuhu nsafina. ");
INSERT INTO kde_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Vanang'o nanga pavanamaite chinu chohecho mpaka livambwe palihaleke nkuvayola vammalele. Uvila nni chiimbekuva pambekwida Mwana wa Munu. ");
INSERT INTO kde_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Uhiku anewo vanu vavili vàmbekuva kumawelu, yumo àmbetwaliwa na yunji ambelekwa. ");
INSERT INTO kde_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Vamahe vavili vàmbekuva pamo uvahaya ntama nniyanga, yumo àmbetwaliwa na yunji àmbelekwa. ");
INSERT INTO kde_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Bahi lyongolelange kwa kuva nanga pamumaite liduva lyambekwida Nang'olo wenu. ");
INSERT INTO kde_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mwenu mùnimala kuva, kuikave mwene ing'ande waumala uhiku wambekwida nkwiva unaiva, akaniva meho uchinga ing'ande yake inatutumulwe. ");
INSERT INTO kde_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Bahi na mwenu uchocho, lipanganihange, kwa kuva Mwana wa Munu àmbekwida uhiku umukalolela mwenu.” ");
INSERT INTO kde_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yesu nkuhweneha kutangola wachidoni, “Dachi, ntumishi alida akulupîka na avêle na ding'ano? Nni ayula wammikile nang'olo wake kuvaimilila vatumishi vanji na kunnaija aveng'e chakulya kwa uhiku ulembelêwa. ");
INSERT INTO kde_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Wasa ntumishi aneyo ikàva pambeida nang'olo wake àmbenkoja watenda chalaijijwe. ");
INSERT INTO kde_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nangu nìnnyaulilanga uhiu kuva, nang'olo aneyo àmbemmika ntumishi aneyo kuva nkwímilila wa dimali dyake dyammalele. ");
INSERT INTO kde_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Dachi, ìmbekuva dachi ikàva ntumishi aneyo nni munu atênda lahakalenge, nkulihaulila muntima wake kuva, ‘Nang'olo wangu ànatima kuuya,’ ");
INSERT INTO kde_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","nkutandilika kuvapanya vatumishi avake, akuno walya na kukumbila na kukalewa? ");
INSERT INTO kde_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Nang'olo wa aneyo ntumishi àmbeuya nniduva lyakalolela na uhiku wakaumaite. ");
INSERT INTO kde_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Àmbencheketanya vibeduli vivili ntumishi aneyo na kummika pachinu pavikwîje kwajili ya vakulilambilila, aneko vàmbekuta na kuhaya meno.” ");
INSERT INTO kde_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesu nkuhweneha kutangola wachidoni, “Uhiku anewo Ufalume wa kulihunde nni paumbelandana na vali kumi vanatwete vibatali vyavo nkuhwena unampwechela nnombi. ");
INSERT INTO kde_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Vali nnyano muanevo vávele mavelu na nnyano vanji vánilimuka. ");
INSERT INTO kde_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Avala mavelu vátwetenge chihi vibatali vyavo wala vananyakule na mahuta la akiba. ");
INSERT INTO kde_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Henga avala valimwîke ványakwile vibatali na kukondya mahuta lanji. ");
INSERT INTO kde_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Bahi nnombi patimîle kuhwika, vammalele nkuhindila na kulala luwono. ");
INSERT INTO kde_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ching'ati chilo nkupilikanika lidi lya munu ulichidoni, ‘Pilikanila, nnombi àvenkwida! Humang'ana mukanchingamile!’ ");
INSERT INTO kde_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Bahi vali vammalele nkutakatukanga, nkutayalisha vibatali vyavo. ");
INSERT INTO kde_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Avala mavelu nkuvahaulila avala valimwîke kuchidoni, ‘Tumeyele mahuta lenu kadiki kwa kuva vibatali vyetu vitandilika kudimika.’ ");
INSERT INTO kde_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Avala valimwîke nkuyang'ula kuchidoni, ‘Ikambehululika, mahuta latuvenalo lakambetosa kuyavana hwetu na mwenu. Mwenu hwena kwa vanu vachuûsa mukalisumile lenu.’ ");
INSERT INTO kde_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Avala mavelu pavapite unasuma mahuta, nnombi nkukamola. Avala vali nnyano vanavêle tayali, nkuingila pamo na nnombi nnukumbi lwa ing'ole ya ulombi na nnango nkuchimwa. ");
INSERT INTO kde_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Lukoto kadiki avala vali vanji nkukamolanga, nkutandilika kutangola kuchidoni, ‘Nang'olo, nang'olo, tuchimulile!’ ");
INSERT INTO kde_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Henga nnombi nkuvayang'ula kuchidoni, ‘Nangu nìnnyaulilanga uhiu kuva, nangu nikámmaite mwenu.’ ” ");
INSERT INTO kde_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Anepo Yesu nkuhaula kuchidoni, “Bahi mùùve meho, kwa kuva nanga pamulimaite liduva anelyo wala uhiku wambekwida Mwana wa Munu.” ");
INSERT INTO kde_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesu nkuhweneha kutangola wachidoni, “Ufalume wa Nnungu ùlandana na munu ánalembedîle kuhwena mwanda. Nang'e ávachemile vatumishi vake, nkuvakamuja dihela dyake. ");
INSERT INTO kde_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Yumo nkumwing'a mipatila nnyano ya dihela dya zahabu na yunji nkumwing'a mipatila mivili na yunji nkumwing'a mpatila umo kupapatana na uweso wanga munu. Anepo nkuhwena mwanda. ");
INSERT INTO kde_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Upala ayula apête mipatila nnyano ya dihela dya zahabu nkutandilika kutenda uchuusi, nkuyenjejeka mipatila inji nnyano. ");
INSERT INTO kde_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Uchocho na ayula apête mipatila mivili, nkuyenjejeka mipatila inji mivili. ");
INSERT INTO kde_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Henga ayula apête mpatila umo, nkuhimba lipondo, nkupiha dihela dya nang'olo wake. ");
INSERT INTO kde_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Bada ya maduva lohe, nang'olo wa avala vatumishi nkuuya, nkutenda navo isabu ya dihela dyanavakamujije. ");
INSERT INTO kde_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Bahi nkuhaloka ayula ntumishi anapete mipatila nnyano ya dihela dya zahabu, nang'e nkuhumya na inji nnyano, nkuhaula kuchidoni, ‘Nang'olo, úngukamujidye mipatila nnyano, lola vino ìyenjejeke inji nnyano.’ ");
INSERT INTO kde_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Nang'olo wake nkunnyaulila kuchidoni, ‘Ùtendile saana, wako nni ntumishi wambone, na ùnakulupika. Únikulupika kwa dimali kadiki, bahi vino nìmbekukamuja dimali dyohe. Ida uhangalale pamo na nangu!’ ");
INSERT INTO kde_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Nkuhaloka ayula ntumishi wavili anapete mipatila mivili ya dihela, nanang'e, nkuchidoni, ‘Nang'olo, úngupele mipatila mivili, lola, vino ìyenjejeke mipatila inji mivili.’ ");
INSERT INTO kde_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Nang'olo wake nkunnyaulila kuchidoni, ‘Ùtendile saana, wako nni ntumishi wambone, na ùnakulupika. Únikulupika kwa dimali kadiki, bahi vino nìmbekukamuja dimali dyohe. Ida uhangalale pamo nangu!’ ");
INSERT INTO kde_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Anepo nkuhaloka ayula ntumishi yunji watatu anapete mpatila umo wa dihela, nkuhaula kuchidoni, ‘Nang'olo, nangu ǹnikumala wako kuva, nni umunu ukee na chididi, wako ùvele muchi munu ahôla chihi na pachinu pakapandile nang'e. ");
INSERT INTO kde_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nangu ńniyopa, nkuhwena unapiha dihela dyako nnipondo. Bahi hela yako aino, itwale.’ ");
INSERT INTO kde_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Nang'olo wake nkunnyang'ula kuchidoni, ‘Wako nni ntumishi nkútenda lahakalenge, na unnemwa! Wako wanimala kuva, nangu nni munu ngufûna chihi pachinu panikapandile nangu. ");
INSERT INTO kde_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Elo, henga wako úlembelewa udivike dihela dyangu benki, uchinga liduva linimbeuya ngudipate dihela dyangu na dinji diyenjejêke. ");
INSERT INTO kde_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Bahi mpakanyolange aneyo, dihela anedyo, mumwing'e ayula avêle na mipatila kumi ya dihela. ");
INSERT INTO kde_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kwa kuva, kila munu avêle na chinu àmbeyenjejwa ààve na vyohe, henga munu akávele na chinu ata achila kadiki chavenacho àmbepokonyolwa. ");
INSERT INTO kde_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Bahi ntwale ayu ntumishi akáfala, munnyahange pawelu pavêle lupi. Aneko njo kuvambekuta na kuhaya meno.’ ” ");
INSERT INTO kde_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Pámbeìdà Mwana wa Munu akuno avèlè na ukulu wake pamo na malaika vammalele, anepo njo pámbeikàlà nchiteng'u chake cha chifalume. ");
INSERT INTO kde_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Vanu va vilambo vyammalele vàmbelopokela muyo mwake, nanang'e àmbevahapulanya anevo vanu muchi nchunga chavahapula angandolo n'dimbudi. ");
INSERT INTO kde_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Àmbevavika angandolo m'bali wake wa kunkono na ambudi m'bali wake wa kunchinda. ");
INSERT INTO kde_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Anepo Nfalume àmbevahaulila avala vavêle m'bali wake wa kunkono, ‘Idang'ana, mwenu mubalikiwije na Atatangu, pwachelanga Ufalume umuunguliwije kutandikila kuumbwa kwa chilambo. ");
INSERT INTO kde_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kwa kuva ngúvele na indala mwenu nkuning'a chakulya, na ngúvele na inyota mwenu nkuning'a medi, na ngúvele ninnyeni mwenu nkungupwechela, ");
INSERT INTO kde_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","na ngúvele lukundumwandu, mwenu nkuning'a inguwo yuwala, na nnauula mwenu nkunanguuja, na ngúvele nnilungu mwenu nkuidang'ana unangulola.’ ");
INSERT INTO kde_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Anepo avala vatênda lalalembela Nnungu njo pavambeyang'ula kuchidoni, ‘Nang'olo, chakani patukuwene uvèlè na indala hwetu nkukwing'a chakulya, au púnavele na inyota hwetu nkukwing'a medi lukumbila? ");
INSERT INTO kde_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Chakani patunakuwene uvèlè nnyeni, hwetu nkukupwechela, au chakani púnavele lukundumwandu, hwetu nkukwing'a dinguwo? ");
INSERT INTO kde_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Na chakani patukwene ubwahela au uvèlè nnilungu, hwetu nkuida unakulola?’ ");
INSERT INTO kde_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nfalume àmbevayang'ula kuchidoni, ‘Nangu nìnnyaulilanga uhiu kuva, kila chinu chimuntendedile munu avalangîwa kuva akee chinu, múngutendedile nangu.’ ");
INSERT INTO kde_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Anepo Nfalume àmbevahaulila avala vavêle m'bali wake wa kunchinda kuchidoni, ‘Ukananga apano, mwenu mulaniwije! Muhwene mmoto ukee na ntululilo, moto waunguliwije Ibilisi na malaika vake! ");
INSERT INTO kde_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kwa kuva, pangunavele na indala, mwenu nkananing'ile chakulya na pangunavele na inyota, mwenu nkananing'ile medi lukumbila ");
INSERT INTO kde_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","na pangunavele ninnyeni, mwenu nkanangupwecheledile na pangunavele na uhou, mwenu nkananing'ile dinguwo dyuwala na panichiuula, mwenu nkanaidile unangulola na pangunavele nnilungu mwenu nkanaidîle unangulola.’ ");
INSERT INTO kde_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Anepo vanang'o vàmbennyang'ula kuchidoni, ‘Nang'olo, chakani patunakuwene uvèlè na indala au inyota au uvèlè unnyeni au uvèlè na uhou au uuùlà au uvèlè nnilungu, na hwetu tunaide unakuhudumila?’ ");
INSERT INTO kde_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Nang'e àmbevayang'ula kuchidoni, ‘Nangu nìnnyaulilanga uhiu kuva, kila chinu chimusindwije kuntendela munu avalangîwa kuva akee chinu, músindwije kungutendela nanangu.’ ");
INSERT INTO kde_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Anepo anevo vanu vambehwena muasabu ikee na ntululilo, henga avala vatênda lalalembela Nnungu, vàmbeingila muumi ukee na ntululilo.” ");
INSERT INTO kde_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu pamalidile kutangola malove anelo, nkuvahaulila vakuhundwa vake kuchidoni, ");
INSERT INTO kde_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mwenu mùnimala kuva bada ya maduva mavili pàmbekuva na sikukuu ya Pasaka, na Mwana wa Munu àmbetengelekwa uchinga avambwe munsalaba.” ");
INSERT INTO kde_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Anepo makuhani vakulu pamo na vasele va Vayahudi nkukojana paing'ande ya Kuhani Nkulu, uvanchema Kayafa. ");
INSERT INTO kde_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nkutenda ntemelo namuna chivambenkamula na kummwalala Yesu. ");
INSERT INTO kde_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nkuhaula kuchidoni, “Henga tunankamule pasikukuu, uyopa vanu vanataya timbwili.” ");
INSERT INTO kde_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu ávele ku Besaniya muing'ande yanga Simoni analamijwe mangundula. ");
INSERT INTO kde_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Pánavele nkulya, nkuhaloka mmahe ananyakwile chupa chikatapele namene chikatapajîjwe kwa mayanga la alabasta. Chupa anecho chíumbele mahuta lanung'ila la kugalika namene, nkummiminila Yesu mmuti. ");
INSERT INTO kde_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Vakuhundwa vanga Yesu pavalawene anelo latendêke nkusunala, nkuhaula kuchidoni, “Mwadachi kwondonganga uvila mahuta? ");
INSERT INTO kde_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Alano mahuta lakanisumiswa kwa dihela dyohe namene nkuveng'a amahuvani!” ");
INSERT INTO kde_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Henga Yesu nkumala lavachiliuja, bahi nkuvahaulila kuchidoni, “Mwadachi munankambyakambya ayuno mmahe? Nang'e àngutendedile lyambone. ");
INSERT INTO kde_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kwa kuva, maduva lammalele mùmbekuva na amahuvani, henga nanga pamumbekuva na nangu maduva lammalele. ");
INSERT INTO kde_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nang'e àmwadilidile mahuta mummili wangu, uchinga angutayalishe kwa kungusika. ");
INSERT INTO kde_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nangu nìnnyaulilanga uhiu kuva, kila pachinu pámbehubilîwa Malove Lambone nchilambo chammalele, alino lyatendile ayuno mmahe lìmbetambulangwa kwa kunhimukila nang'e.” ");
INSERT INTO kde_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Anepo, yumo wa vakuhundwa kumi na mbili, lina lyake Yuda Isikaliote, nkuhwena kwa makuhani vakulu, ");
INSERT INTO kde_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","nkuvahaulila kuchidoni, “Mùmbening'a chamani nikantengeleka Yesu kwenu mwenu?” Bahi nkumwing'a dihela dya nnyoyo salasini. ");
INSERT INTO kde_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kutandikila anepo Yuda nkuva wataha wasa wa kuntengeleka Yesu. ");
INSERT INTO kde_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Liduva litandi lya Sikukuu ya Mikate Ikátaijwe Hamila, vakuhundwa vake nkummwenela Yesu nkummuja kuchidoni, “Ùlembela tukakwandalile kwachi chakulya cha Sikukuu ya Pasaka?” ");
INSERT INTO kde_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesu nkuvahaulila vahweneng'ane kumanga, kwanga munu yumo vakannyaulile kuchidoni, “Nkúhunda àhawile kuchidoni, ‘Uhiku wautondwele Nnungu kwajili yangu ùvele pepi, vakuhundwa vangu pamo na nangu nimwene tùmbehangalalila muing'ande yako Sikukuu ya Pasaka.’ ” ");
INSERT INTO kde_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Bahi vakuhundwa nkutenda muchi Yesu chavalaijije, nkuandaa chakulya cha Sikukuu ya Pasaka. ");
INSERT INTO kde_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Pachikamwele chinalyulo, Yesu nkulya chakulya pamo na vakuhundwa vake kumi na mbili. ");
INSERT INTO kde_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Pavanavele nkulya, Yesu nkuhaula kuchidoni, “Nangu nìnnyaulilanga uhiu kuva, munu yumo mmwenu àmbengutengeleka.” ");
INSERT INTO kde_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Vakuhundwa vake nkuva nnihindambi likulu, nkutandilika yumo-yumo kunnyaulila Yesu kuchidoni, “Nang'olo, nikee nangu!” ");
INSERT INTO kde_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu nkuyang'ula kuchidoni, “Achahwijîje nkate wake munkungu pamo na nangu njo ambengutengelêka. ");
INSERT INTO kde_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwana wa Munu àmbekuhwa malinga chiilembwije Mmalemba Lanaswe kumwamba nang'e. Henga ole wake munu aneyo antengelêka Mwana wa Munu! Ikàvele wasa kwa munu aneyo kuikave akavelekwa.” ");
INSERT INTO kde_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Anepo Yuda, ayula nkútengeleka, nkunnyaulila Yesu kuchidoni, “Nkúhunda, nikee nangu!” Yesu nkunnyang'ula kuchidoni, “Ùmbekuva uwewe.” ");
INSERT INTO kde_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Bahi pavanavele nkulya, Yesu nkutwala nkate, nkunshukulu Nnungu, nkuumeya, nkuveng'a vakuhundwa vake. Nkuhaula kuchidoni, “Twalanga mulye, auno njo mmili wangu.” ");
INSERT INTO kde_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Anepo, nkutwala chikombe chivêle divayi, nkunshukulu Nnungu, nkuveng'a vakumbile, nkuhaula kuchidoni, “Kumbilanga mmammalele, ");
INSERT INTO kde_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","kwa kuva, aino njo myadi yangu imaîha lilailano lya Nnungu na vanu vake, imwadilîka kwajili ya vanu vohe uchinga vasamehewe masambi lavo. ");
INSERT INTO kde_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nangu nìnnyaulilanga mwenu kuva, nikambekumbila kavila divayi, mpaka liduva linimbekumbila divayi dyahambi pamo na mwenu mu Ufalume wa Atatangu.” ");
INSERT INTO kde_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Bahi pavamalidile kwimba luhimu, nkuhumananga pawelu, nkuhweneng'ana ku Lichinga lya Miseituni. ");
INSERT INTO kde_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Anepo Yesu nkuvahaulila kuchidoni, “Ing'anya ya àlalá lambenguhumîla nangu, mwenu mmammalele chilo cha nelo ǹnembeleka kungukulupila, malinga chahawile Nnungu Mmalemba Lanaswe kuva, ‘Nìmbempanya nchunga, na angandolo vàmbemwadilikana.’ ");
INSERT INTO kde_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Henga panimbefufuka, nìmbennongolela kuhwena ku Galilaya.” ");
INSERT INTO kde_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petulo nkunnyang'ula Yesu kuchidoni, “Ata kuiva vammalele uvava na lipamba na wako nkukuleka, henga nangu nikambekuleka mwiko.” ");
INSERT INTO kde_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu nkunnyaulila Petulo kuchidoni, “Nangu nìkuhaulila uhiu kuva, chilo uchino cha nelo, kabla ung'uku akànambikongovela, wako ùmbekuva ungukanile myanda mitatu.” ");
INSERT INTO kde_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petulo nkuyang'ula kuchidoni, “Ata kungulembelewa kuhwa chalumo na wako, nangu nikambekukana ng'o!” Vakuhundwa vammalele nkutangola uchocho. ");
INSERT INTO kde_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Anepo Yesu nkuhwena pamo na vakuhundwa vake kuwelu uvachema, Getisemane, nkuvahaulila vakuhundwa vake kuchidoni, “Ikalanga apano, nangu nguhwena akula unayuwa.” ");
INSERT INTO kde_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nkuntwala Petulo pamo na vana vavili vanga Sebedayo. Bahi Yesu nkutandilika kuva na lihindambi na kukambakamba muntima, ");
INSERT INTO kde_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","nkuhaula kuchidoni, “Ntima wangu ùvele na lihindambi likulu, pepi na kuhwa. Bahi ikalanga apano, mùùve meho pamo na nangu.” ");
INSERT INTO kde_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nkuhwena muyo kadiki, nkuhunama mpaka pahi, nkuyuwa wahaula kuchidoni, “Atatangu, ikàhululika ngunyemye na ibaniki iîda! Henga unatende muchi chingulembela nangu, ila tènda muchi chulembela wako umwene.” ");
INSERT INTO kde_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Bahi Yesu nkuvahwenela avala vakuhundwa vatatu, nkuvakoja valèlè, nkunnyaulila Petulo kuchidoni, “Dachi, nanga pamuhulwile kuva meho pamo na nangu kananga lisaa limo? ");
INSERT INTO kde_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Bahi mùùve meho na muyuwe uchinga pamumbelingwa munatende masambi. Isungu ìnalembela, henga mmili unadabadanga.” ");
INSERT INTO kde_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesu nkuhwena mwanda wavili unayuwa, wahaula kuchidoni, “Atatangu, ikánahululike kungunyemija ibaniki aneyo iîda, bahi ìtendeke muchi chulembela wako.” ");
INSERT INTO kde_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Bahi Yesu nkuhwena kavila kwa vakuhundwa vake, nkuvakoja valelèngè luwono, kwa kuva meho lavo láumbele chihi luwono. ");
INSERT INTO kde_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yesu nkuvaleka kavila, nkuhwena unayuwa mwanda watatu watangola chihi malove ulala. ");
INSERT INTO kde_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Bahi Yesu nkuvahwenela vakuhundwa, nkuvahaulila kuchidoni, “Mwenu mmechinkwona na kupumulila. Lola uhiku ùnikamola wambekamujwa Mwana wa Munu mmakono la vanu vavêle na masambi. ");
INSERT INTO kde_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Na ayula angutengelêka àvele pepi, bahi takatukanga tuhweneng'ane!” ");
INSERT INTO kde_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu pánavele nkutangola malove anelo, nkuhaloka Yuda, yumo wa avala vakuhundwa kumi na mbili, pamo na likuwa likulu lya vanu vanyakwîle mapanga na dindonga. Vanu anevo vammalele vátumwije na makuhani vakulu na vasele va Vayahudi. ");
INSERT INTO kde_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ayula nkútengeleka ávapele avala vanu chimaiho wachidoni, “Munu ayula unimbem'busu njo nang'e, mwenu nkamule!” ");
INSERT INTO kde_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yuda nkummwenela Yesu nkuchidoni, “Nkúhunda, umumi?” Bahi nkum'busu. ");
INSERT INTO kde_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu nkunnyaulila Yuda kuchidoni, “Nnyanjawangu, tènda lyuwidilidile.” Bahi avala vanu vanapapatene na Yuda nkuhengelekela, nkunkamula Yesu. ");
INSERT INTO kde_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nkuhundwa yumo muavala vakuhundwa vanga Yesu nkuhalamola upanga, nkuncheketa likutu ntumwa wanga Kuhani Nkulu. ");
INSERT INTO kde_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu nkunnyaulila kuchidoni, “Ludisha upanga wako m'benda yake. Kwa kuva, vammalele vatumîla upanga wa kukomanila, vambekuhwa kwa upanga uwowo wa kukomanila. ");
INSERT INTO kde_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Dachi, ùtenda kuva nikáhulula unnyuwa Atatangu angupelekejije matunji kumi na mbili la maelufu la malaika vakunguchunga? ");
INSERT INTO kde_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Henga nikàtenda uchocho làmbetimila dachi Malemba Lanaswe lahaûla kuva, alano lasima lahumile?” ");
INSERT INTO kde_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Anepo Yesu nkulihaulila likuwa lya vanu kuchidoni, “Mwadachi mùidile unangukamula akuno munyakulèngè mapanga na dindonga muchi nangu nkúpalaula? Maduva lammalele nangu ngúikala nnuwani lwa Ing'ande ya Nnungu unguhùndà, henga nanga pamunangukamwile. ");
INSERT INTO kde_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Henga alano lammalele lànihumila, uchinga latimile àlalá lavanalembile manabii Mmalemba Lanaswe.” Anepo vakuhundwa vammalele nkunneka, nkutukuta. ");
INSERT INTO kde_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bahi avala vankamwîle Yesu, nkumpelekeja Yesu kwa Kayafa, Kuhani Nkulu. Anepo njo pachinu pavanakojene vakúhunda Sheliya ya Musa na vasele va Lukumbi Lukulu lwa Vayahudi. ");
INSERT INTO kde_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petulo nkuva wannondola Yesu kwa kulehu mpaka paluwani lwa lukumbi lwa Kuhani Nkulu. Nkuingila nkati, nkuikala pamo na valinzi uchinga alalole lambehumîla. ");
INSERT INTO kde_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Makuhani vakulu na vajumbe vammalele va Lukumbi Lukulu lwa Vayahudi nkutaha ushahidi wa kulambila kunnyamba Yesu, uchinga vammwalale. ");
INSERT INTO kde_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Henga nanga pavanapete, ikànava vanu vohe vánihaloka unahumya ushahidi wa kulambila. Kuntululilo, nkuhaloka vanu vavili, ");
INSERT INTO kde_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","nkuhaula kuchidoni, “Ayu munu áhawile kuva, ‘Nangu nahulula kuibamola Ing'ande yanga Nnungu na kuidenga kavila mmaduva matatu.’ ” ");
INSERT INTO kde_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Anepo Kuhani Nkulu nkuimila, nkummuja Yesu kuchidoni, “Dachi, wako ukee na lilove lya kuyang'ula kwamba anelo lavakusitaki ava vanu?” ");
INSERT INTO kde_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Henga Yesu nkunyalala chihi. Kuhani Nkulu nkunnyaulila Yesu kuchidoni, “Nnungu nni mumi, hambi nakuapisa kwa lina lyake, bahi tuhaulile ikàva wako nni Kilisto, Mwana wanga Nnungu.” ");
INSERT INTO kde_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu nkunnyang'ula kuchidoni, “Elo, umomo muhaulidile wako. Henga nangu nìnnyaulilanga mwenu kuva, kutandikila hambi muchimumwone Mwana wa Munu aikèlè m'bali wa kunkono wa Nnungu Avêle na Dimongo, uchocho muchimumwone avèlè mmahunde waida.” ");
INSERT INTO kde_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Anepo Kuhani Nkulu nkupapulanga dinguwo dyake, nkuhaula kuchidoni, “Ayu munu ànkufwîle Nnungu! Dachi, pàvele ing'anya ntwani kavila ya kuvataha mashahidi? Lola, tênda mùnipilikana chankufwîle Nnungu? ");
INSERT INTO kde_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mwenu mwona dachi?” Vanang'o nkuyang'ula kuchidoni, “Àlembelewa ahwe.” ");
INSERT INTO kde_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Anepo vanu vanji nkunsunila mata kumeho na kumpanya ding'ondi. Na vanji nkumpanya makofi, ");
INSERT INTO kde_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","uvahaula kuchidoni, “Wako Kilisto, tùlaujije, nnani akupanyile!” ");
INSERT INTO kde_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Uhiku anewo Petulo áikele nnuwani lwa lukumbi lwa Kuhani Nkulu. Ntumishi yumo mmahe, nkummwenela Petulo nkunnyaulila kuchidoni, “Na wako úvele pamo na Yesu wa ku Galilaya.” ");
INSERT INTO kde_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Henga Petulo nkukana muyo mwa vanu vammalele vánavele apala, wahaula kuchidoni, “Nikámaite malove lutangola.” ");
INSERT INTO kde_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Anepo Petulo nkuuka apala nkuhwena pannango wa luwani lwa lukumbi, bahi mmahe yunji nkumwona, nkuvahaulila vanu vánavele apala kuchidoni, “Ayuno munu ávele pamo na Yesu wa ku Nasaleti.” ");
INSERT INTO kde_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Henga Petulo nkukana kavila, nkuapila wachidoni, “Nikámmaite munu aneyo!” ");
INSERT INTO kde_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Lukoto kadiki avala vanu vanaimidile apala, nkummwenela Petulo nkunnyaulila kuchidoni, “Muhiu wako nni yumo munkumbo wavo, ing'anya ata itangodi yako ìnakumaiha.” ");
INSERT INTO kde_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Anepo Petulo nkutandilika kwapila wachidoni, “Ngulanike ikàva nalambila! Nangu nikámmaite munu aneyo!” Upala ung'uku nkukongovela. ");
INSERT INTO kde_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Petulo nkuhimukila malove langa Yesu lanannyaulidile kuva, “Kabla ung'uku akànambikongovela, wako ùmbekuva ungukanìlè myanda mitatu.” Bahi nkuhuma pawelu, nkunatumbula chitangelo. ");
INSERT INTO kde_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pauchele, makuhani vakulu vammalele na vasele va Vayahudi nkukojana, nkutenda ntemelo uchinga vapate kummwalala Yesu. ");
INSERT INTO kde_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nkunnyunga Yesu, nkumpelekeja na kunkamuja kwanga Pilato, nkulu wa Chiloma wa chilambo achila. ");
INSERT INTO kde_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Bahi Yuda, ayula antengelêke Yesu pawene kuva Yesu ànihukumiwa kuhwa, nkulyamba, nkuvauihija makuhani vakulu na vasele va Vayahudi adila dihela salasini dya nnyoyo. ");
INSERT INTO kde_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Nkuvahaulila kuchidoni, “Natendile masambi kuntengeleka munu ayuno akávele na likosa, uchinga awalwalwe.” Vanang'o nkunnyaulila kuchidoni, “Yetuhwe ilida? Anelo unamala umwene!” ");
INSERT INTO kde_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Bahi Yuda nkudiyaha adila dihela dya nnyoyo mu Ing'ande ya Nnungu, nkuhwena unalipambilila. ");
INSERT INTO kde_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Makuhani vakulu nkudilokotanya adila dihela dya nnyoyo, nkuhaula kuchidoni, “Kupapatana na sheliya yetu, ikáluhusiwa kudivika nnisanduku lya sadaka, kwa kuva nni dihela dipatikene kwa kumwadila myadi.” ");
INSERT INTO kde_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Adila dihela nkwamula vasume welu wa munu amunyanga ulongo, uchinga pààve pachinu pa kuvasikila vayeni. ");
INSERT INTO kde_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Njo mana aula welu vachema, “Welu wa Myadi,” mpaka nelo. ");
INSERT INTO kde_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Anepo nni palatimidile malove lanatangwe nabii Yelemiya kuchidoni, “Nkuditwala dihela dya nnyoyo salasini, divanawene Vaisilaeli kuva dinalingilana na kuhwa kwanga munu, ");
INSERT INTO kde_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","nkutumila dihela anedyo kusuma welu wa munu amunyanga ulongo, muchi Nang'olo changulaijije.” ");
INSERT INTO kde_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Anepo Yesu nkupelekejwa muyo mwanga Pilato nkulu wa Chiloma wa chilambo achila. Pilato nkummuja Yesu kuchidoni, “Dachi, wako nni Nfalume wa Vayahudi?” Yesu nkuyang'ula kuchidoni, “Wako ùnihaula.” ");
INSERT INTO kde_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Bahi makuhani vakulu na vasele va Lukumbi Lukulu lwa Vayahudi pavansiteke Yesu, nang'e nanga panayang'wile lilove. ");
INSERT INTO kde_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Anepo Pilato nkummuja kavila Yesu kuchidoni, “Dachi, uvenkulapilikana anelo lammalele lavakusitaki?” ");
INSERT INTO kde_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yesu nkunyalala chihi na akanayang'wile kananga lilove limo, Pilato nkukangana namene. ");
INSERT INTO kde_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kila Sikukuu ya Pasaka Pilato ávele na nnyambo wa kuvahungulila Vayahudi nfungwa yumo uvachinnembela. ");
INSERT INTO kde_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Na maduva àlalá pávele na nfungwa yumo anamaikene namene ing'anya ya kutenda lahakalenge, lina lyake Balaba. ");
INSERT INTO kde_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Bahi vanu pavanakojene pamo, Pilato nkuvauja kuchidoni, “Mulembela ninchimulile alida, Balaba au Yesu uvanchema Kilisto?” ");
INSERT INTO kde_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilato átangwele uchocho kwa kuva ánimala kuva, Yesu ákamujijwe kwanga nang'e kwa wiu. ");
INSERT INTO kde_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato panaikele nchiteng'u cha hukumu, n'jawe nkumpelekejije ujumbe uchidoni, “Unantende chinu chohecho aneyo munu akávêle na likosa, kwa kuva chilo ǹnibanika namene muindoto ing'anya yanga nang'e.” ");
INSERT INTO kde_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Henga makuhani vakulu pamo na vasele va Vayahudi nkuvachonjela vanu vánavele apala kuva vayuwe alekelewe Balaba, na Yesu awalwalwe. ");
INSERT INTO kde_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilato nkuvauja kuchidoni, “Muvanu avano vavili mùlembela nìnnyungulile alida?” Vanang'o nkunnyang'ula kuchidoni, “Nnyungulile Balaba.” ");
INSERT INTO kde_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato nkuvauja kavila kuchidoni, “Mùlembela nintende dachi ayuno Yesu uvanchema Kilisto?” Vammalele nkuyang'ula kuchidoni, “Avambwe munsalaba!” ");
INSERT INTO kde_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato nkuvauja kavila kuchidoni, “Ing'anya ntwani? Kwani àtendile lilida lihakalenge?” Henga vanang'o nkuhalija chihi kutaya lwasu uvachidoni, “Avambwe munsalaba!” ");
INSERT INTO kde_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Bahi Pilato pawene kuva nanga chambehulula kutenda, na lwasu luhalija chihi, nkutwala medi nkukalava mmakono muyo mwa vanu vammalele, wahaula kuchidoni, “Kuhwa kwa munu aneyo, nangu nikávele na makosa! Anelo lenu mmene.” ");
INSERT INTO kde_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Vanu vammalele nkuyang'ula kuchidoni, “Asabu ya kuwalalwa kwanga munu aneyo kutukoje hwetu pamo na vivelêko vyetu!” ");
INSERT INTO kde_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Anepo Pilato nkuvahungulila Balaba, henga nkulaija Yesu asulubulwe na kunkamuja kwa matiyala va Chiloma uchinga avambwe munsalaba. ");
INSERT INTO kde_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Anepo matiyala la Pilato nkuntwala Yesu nkumpelekeja nnuwani lwa nkati lwa ing'ande yanga Pilato, na likuwa lyammalele lya matiyala nkunteng'eneja. ");
INSERT INTO kde_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nkummulanga dinguwo dyake, nkummwaja likoti lya langi ya chifalume. ");
INSERT INTO kde_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Nkudinga lutavi lwa miva muchi kofiya ya chifalume, nkummwaja mmuti. Nkunkamudya isimbo ya imbalu munkono wake wa kunkono, nkutindivala malundi muyo mwake, nkutandilika unnombolela kwa mang'wanyu uvachidoni, “Utumbyangwe, Nfalume wa Vayahudi!” ");
INSERT INTO kde_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nkunsunila mata, nkutwala aila imbalu nkumpanya mmuti. ");
INSERT INTO kde_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pavamalidile kuntendela mang'wanyu, nkummula alila likoti, nkummwaja dinguwo dyake. Anepo nkuntwala, nkuhwena unammamba munsalaba. ");
INSERT INTO kde_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Pavachihwena, nkukojana na mwenedi wa imanga ya ku Kilene, lina lyake Simoni, nkunnamatija aunyakule aula nsalaba wanga Yesu. ");
INSERT INTO kde_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pavakamwele pachinu pavachema Goligota, mana lake, “Pachinu pa Libadang'a.” ");
INSERT INTO kde_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Nkumwing'a divayi divakundanyije na chinu chikalala namene. Henga payejije, nkuhita kukumbila. ");
INSERT INTO kde_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Pavamalidile kummamba munsalaba, nkuyavana dinguwo dyake kwa kuyela indingi. ");
INSERT INTO kde_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nkuikalanga pahi upala uvannolihija. ");
INSERT INTO kde_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Munsalaba wake muha pamuti pake vákomedile chibau chílembwije malove layamba lisitaka lyake, “AYUNO NJO YESU, NFALUME WA VAYAHUDI.” ");
INSERT INTO kde_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Uhiku uula, nkuvambwa na vakúpalaula vavili, yumo m'bali wake wa kunkono na yunji m'bali wa kunchinda. ");
INSERT INTO kde_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bahi vanu vachipîta anepo nkuva uvapukunya myuti yavo na kunchamba, ");
INSERT INTO kde_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","uvachidoni, “Wako akee unahawile kuva ùmbebamola Ing'ande yanga Nnungu na kuidenga kavila mmaduva matatu, hambi lipohe umwene! Ikàva wako Umwana wa Nnungu, lisulupuse munsalaba!” ");
INSERT INTO kde_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Uchocho, makuhani vakulu na vakúhunda Sheliya ya Musa pamo na vasele va Vayahudi navanang'o nkuntendela mang'wanyu, uvahaula kuchidoni, ");
INSERT INTO kde_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ávapohije chihi vanu vanji, henga hambi akáhulula kulipoha mwene! Ati nang'e nni Nfalume wa Vaisilaeli! Hambi alisulupuhe mwene munsalaba, uchinga na hwetu tunkulupile. ");
INSERT INTO kde_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nang'e àlisingila Nnungu na áhawile kuva nang'e nni Mwana wanga Nnungu. Ikàva Nnungu ànakatapaliwa nawe, bahi ampohe hambi!” ");
INSERT INTO kde_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Na avala vakúpalaula vanavambwije pamo na nang'e, navanang'o uchocho vántangoledile malove lahakalenge. ");
INSERT INTO kde_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Bahi kutandikila sasita muhi mpaka satisa, chilambo chammalele nkuva chihi lupi. ");
INSERT INTO kde_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Paihwikile malinga satisa, Yesu nkunonoha lidi lyake, nkuhaula kuchidoni, “Eloyi, Eloyi, lama sabakitani?” Mana lake nni, “Nnungu wangu, Nnungu wangu, mwadachi ùninguleka?” ");
INSERT INTO kde_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Vanu vanji vanaimidile apala pavapilikene uchocho nkuhaula kuchidoni, “Ànchema Eliya.” ");
INSERT INTO kde_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Upala, munu yumo nkutukuta nkutwala siponji, nkuchuvika n'divayi dihahama. Nkuipatika nnufito, nkunnyanyulila Yesu uchinga ahonde. ");
INSERT INTO kde_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Henga vanu vanji nkuhaula kuchidoni, “Nneke, tulole ikàva Eliya achiaide unampoha!” ");
INSERT INTO kde_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Bahi Yesu nkunonoha kavila lidi likulu, koka nkuhila. ");
INSERT INTO kde_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Upala lipanzia linahungwije paching'ati mu Ing'ande ya Nnungu nkudaluka vipande vivili, kutandikila muha mpaka pahi, chilambo nkundangenda na mayanga makulungwa nkutumbuka. ");
INSERT INTO kde_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Misati nkuhunukuka, na vanu vohe va Nnungu vanahidile nkufufuliwa. ");
INSERT INTO kde_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nkuhuma mmisati yavo, na Yesu páfufwike, anevo vanu nkuingila muimanga yanaswe Yelusalemu, nkwonwa na vanu vohe. ");
INSERT INTO kde_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nkulu yumo wa matiyala la Chiloma na avala vánavele pamo nanang'e uvannolihija Yesu, pavachiwene chilambo uchindengenda na lammalele lahumidile, nkuyopa namene, nkuhaula kuchidoni, “Muhiu ayu munu ávele Mwana wanga Nnungu.” ");
INSERT INTO kde_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Pachinu anepo pávele na vamahe vohe vachimpenekela Yesu kwa kulehu, anevo nni avala vachinnondola Yesu kutandikila ku Galilaya na kuntumikila. ");
INSERT INTO kde_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Muanevo vamahe, múvele na Maliya wa imanga ya Magidala na Maliya ayuvao Yakobo na Yusufu, pamo na ayuvao vana vanga Sebedayo. ");
INSERT INTO kde_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Liduva palichiswa, nkuhaloka munu yumo nkúpata, uvanchema Yusufu, mwendi wa ku Alimataya. Munu aneyo nanang'e ávele nkúhundwa wanga Yesu. ");
INSERT INTO kde_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nang'e nkuhwena kwanga Pilato, nkuuyuwa mmili wanga Yesu, bahi Pilato nkwamulu vamwing'e. ");
INSERT INTO kde_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Anepo Yusufu nkuutwala aula mmili, nkuudingilija sanda itakete, ");
INSERT INTO kde_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","nkunausika munsati wake wahambi unavedwîje nniyanga likulungwa namene. Anepo nkuhingilihija liyanga likulu pannango wa nsati, nkuuka. ");
INSERT INTO kde_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maliya wa imanga ya Magidala pamo na ayula Maliya yunji váikalenge upala, kuloja pansati. ");
INSERT INTO kde_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Liduva lipapete, lívele Liduva lya Kuyewelela, makuhani vakulu na Mafalisayo nkummwenela Pilato, ");
INSERT INTO kde_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","nkunnyaulila kuchidoni, “Nang'olo, tùnakumbukila kuva ayula nkúlambila pánavele mumi átele kuchidoni, ‘Liduva lya tatu lya kuhwa kwangu nìmbefufuka kuhaloka kwa vahwîle.’ ");
INSERT INTO kde_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Bahi amulisa nsati ulolihijwe mpaka liduva lya tatu, uyopa vakuhundwa vake vànauiva mmili wake na kuvahaulila vanu kuva ànifufuka. Kwa kuva, kulambila kwa vino kumbemamoja kupunda kutandi.” ");
INSERT INTO kde_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato nkuvayang'ula kuchidoni, “Vatwale matiyala, muhwene mukauchunge malinga chimuhulula.” ");
INSERT INTO kde_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Bahi vanang'o nkuhwena unaulolihija aula nsati kwa kuvavika valinzi vaulolihije, na kwa kuvika alama muha liyanga lya pannango uchinga ilanguje, ikàva pàvele munu anachimwile, na ììve kuvadivila vanu vanause anelyo liyanga. ");
INSERT INTO kde_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Palipitile Liduva lya Kuyewelela, ulyamba na mambumbu liduva lya Jumapili, Maliya wa imanga ya Magidala na Maliya yunji vápite unaulola nsati. ");
INSERT INTO kde_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Upala, nkuhumila nndengendo nkulu wa chilambo, kwa kuva malaika wa Nang'olo ánisulupuka kuhaloka kulihunde, nkuhwena kunsati, nkulihingilihija alila liyanga kunyenje, nkuliikalila. ");
INSERT INTO kde_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Aneyo malaika ánang'anyima muchi nng'anje wa ing'uva, na dinguwo dyake dívele dyanahe mbee! ");
INSERT INTO kde_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Avala valinzi vachichûnga nsati wa Yesu nkuyopa na kutetemela, nkuva muchi vànihwa. ");
INSERT INTO kde_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Henga ayula malaika nkuvahaulila avala amahe kuchidoni, “Munayope, nangu ǹnimala kuva mùntaha Yesu avambwîje munsalaba. ");
INSERT INTO kde_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Apano nang'e akapali, kwa kuva ànifufulwa muchi chahawile. Idananga mupalole pachinu panalajijwe. ");
INSERT INTO kde_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Bahi hweneng'ana upehi mukavahaulile vakuhundwa vake kuva, nang'e ànifufulwa uholoka kwa vanu vahwîle, na àninnongolela kuhwena ku Galilaya, aneko muchimumwone. Lola, nangu ǹninnyaulilanga tayali.” ");
INSERT INTO kde_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Bahi avala vamahe nkupiyanya kuuka pansati, kwa kuyopa na kuhangalala namene nkutukuta uhwena unavahaulila vakuhundwa vake. ");
INSERT INTO kde_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Upala, Yesu nkuvahumila avala vamahe, nkuchidoni, “Mmumi mwenu?” Avala vamahe nkummwenela, nkuhunama muyo mwake, nkukamula madodo lake. ");
INSERT INTO kde_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Anepo Yesu nkuvahaulila kuchidoni, “Munayope. Hweneng'ana mukavahaulile vakuhundwa vangu vavêle muchi anung'unuvangu vahwene ku Galilaya, aneko nni kuvambengwona.” ");
INSERT INTO kde_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Avala vamahe pavanavele nndila, matiyala vanji vachiulolihija nsati nkuhwena kumanga unavahaulila makuhani vakulungwa kila chinu chihumidîle. ");
INSERT INTO kde_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Anepo makuhani vakulu nkukojana pamo na vasele va Vayahudi, nkutenda ntamelo, nkuveng'a dihela dyohe avala matiyala va nsati. ");
INSERT INTO kde_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Anepo vanang'o nkuvahaulila matiyala kuchidoni, “Vahaulile vanu kuva, pamunavele nkwona, vakuhundwa vake Yesu vániida nachilo, nkumwiva. ");
INSERT INTO kde_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Na Pilato akàpilikana habali aino, hwetu tunatangola nawe, mwenu nkalembeingila mukulaga.” ");
INSERT INTO kde_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Bahi avala matiyala nkupwechelela adila dihela nkutenda muchi chivalaijijwe. Habali aneyo ínihweneha kuyanjala kwa Vayahudi mpaka nelo. ");
INSERT INTO kde_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Anepo avala vakuhundwa kumi na moja nkuhwena ku Galilaya mpaka kulichinga alila lyanavahaulidile Yesu vahwene. ");
INSERT INTO kde_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Vanang'o pavammwene, nkutindivala malundi muyo mwake uvamwabudu, henga vanji nkuva na lipamba. ");
INSERT INTO kde_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Anepo Yesu nkuvahengelekela nkuvahaulila kuchidoni, “Nangu ngùpewije mamulaka lammalele, kulihunde na pachilambo. ");
INSERT INTO kde_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Bahi hweneng'ana kwa vanu va vilambo vyammalele mukavajuhe kuva vakuhundwa vangu, umuvabatisa kwa lina lya Nnungu Atata na lya Mwana na lya Umumu Wanaswe. ");
INSERT INTO kde_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Muvahunde kulakamula lammalele laninnaijije. Na mumale kuva nangu ngùvele pamo na mwenu maduva lammalele mpaka ntululilo wa chilambo.”");
INSERT INTO kde_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Alano nni Malove Lambone lamwâmba Yesu Kilisto, Mwana wa Nnungu. ");
INSERT INTO kde_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Làtandilike muchi chilalembwije nchitabu changa nabii Isaya, Nnungu pahaula kuchidoni, “Nangu nìmbentuma n'jumbe wangu akulongolelee, aneyo njo ambekukatapajîja indila yako.” ");
INSERT INTO kde_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Munu ànonoha lidi kulilanga wachidoni, ‘Nkatapajije Nang'olo indila yake, nyoshanga dihengo dyambepita.’ ” ");
INSERT INTO kde_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Bahi Yohana Nkúbatisa áhumilidile kulilanga, wavahubilila vanu valeke masambi lavo na vabatiswe uchinga Nnungu avasamehe masambi lavo. ");
INSERT INTO kde_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Vanu vohe kuhaloka chilambo cha ku Yudeya na imanga ya ku Yelusalemu vánihwena unampilikanila Yohana, nkulitangolanga masambi lavo, nang'e nkuvabatisa mmuto wa Yoludani. ");
INSERT INTO kde_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohana áwete inguwo ikatapajîjwe kwa maleha la ungamila, na nchikundu mwake áhungile nkanda wa limbende. Na chakulya chake chívele chihi mahiya na uchi wa munnyitu. ");
INSERT INTO kde_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yohana nkuva wavahaulila vanu kuchidoni, “Nnyuma mwangu àvenkwida avêle na dimongo dyohe namene ungupunda nangu. Nangu wala nikáfala kuntumikila kananga kwa kutepa na kuihungula mididi ya vilatu vyake. ");
INSERT INTO kde_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nangu nìm'batisa mwenu kwa medi, henga aneyo àmbem'batisa mwenu kwa Umumu Wanaswe.” ");
INSERT INTO kde_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Maduva anelo, Yesu nkukamola kuhaloka imanga ya ku Nasaleti, chilambo cha ku Galilaya, Yohana nkum'batisa Yesu mmuto wa Yoludani. ");
INSERT INTO kde_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Upala, Yesu pahumile chihi mmedi, nkukwona kulihunde kuhunukwike, na Umumu Wanaswe achionekâna muchi umunda wansulupukila. ");
INSERT INTO kde_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Lidi nkupilikanika kuhaloka muha kulihunde ulichidoni, “Wako njo Mwanangu unikutamwa, ǹnikatapaliwa na wako.” ");
INSERT INTO kde_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Upala, Umumu Wanaswe nkunnodya Yesu kuhwena ya kulilanga, ");
INSERT INTO kde_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","nkuikala aneko maduva alubaini walingwa na Nanchindenga. Aneko, ávele pamo na anyama va munnyitu, na malaika nkuva uvantumikila. ");
INSERT INTO kde_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Bada ya Yohana kutaywa nnilungu, Yesu nkuhwena chilambo cha ku Galilaya unavahubilila vanu Malove Lambone la Nnungu, ");
INSERT INTO kde_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","wachidoni, “Mahiku lànihwika na Ufalume wa Nnungu ùvele pepi na mwenu. Lekanga masambi lenu na mulakulupile Malove Lambone!” ");
INSERT INTO kde_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu pachipita nnyenje Litanda lya ku Galilaya, nkuvona akúupa dihomba vavili uvayela dinjau dyavo nnitanda, Simoni uvanchema Petulo chalumo na nnung'une uvanchema Anduleya. ");
INSERT INTO kde_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu nkuvahaulila kuchidoni, “Ngupapate, nangu nguchinintendange mwenu kuva mmanu mma kuvaupila vanu kwa Nnungu.” ");
INSERT INTO kde_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Upala, nkudilekanga dinjau dyavo, nkumpapata Yesu. ");
INSERT INTO kde_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Papite muyo kadiki, nkumwona Yakobo na nnung'une wake uvanchema Yohana, chalumo na Sebedayo atatawavo pamo na amadengo vanji, vavèlè muingalava yavo uvakatapaja dinjau dyavo. ");
INSERT INTO kde_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Upala, Yesu nkunchema Yakobo na Yohana, na vanang'o nkunneka atatawavo pamo na amadengo vanji muingalava, vanang'o nkumpapata Yesu. ");
INSERT INTO kde_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu pamo na vakuhundwa vake nkuhwika imanga ya ku Kapelinaumu, na palikamwele Liduva lya Kuyewelela, Yesu nkuinjila muing'ande ya kunnyuwila Nnungu, nkutandilika kuvahunda vanu. ");
INSERT INTO kde_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Vanu vanampilikene nkukangana mahundo lake, kwa kuva, ávahunda muchi munu avêle na mamulaka, na akee muchi vakúhunda va Sheliya yanga Musa. ");
INSERT INTO kde_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Uhiku uwowo, munu yumo ánavele muing'ande ya kunnyuwila Nnungu, ánavele na nanndenga, nkulindamuka ukuta ding'uto wachidoni, ");
INSERT INTO kde_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Ùtulembelela chani hwetu, wako Yesu wa ku Nasaleti? Dachi ùidile unatwondonganga? Ǹnimala kuva wako nni Wanaswe, utumwîje na Nnungu!” ");
INSERT INTO kde_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu nkunkalipila ayula nanndenga wachidoni, “Nyalala! Mmuke ayu munu.” ");
INSERT INTO kde_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Bahi ayula nanndenga nkunkunyang'unya namene ayula munu akuno wakuta kwa lidi likulungwa, nkummuka. ");
INSERT INTO kde_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Vanu vammalele nkukangana, nkuva uvaujana kuva, “Ala nni lalida? Ala nni mahundo lahambi lavêle na mamulaka! Ayu munu àvele na dimongo dya kuvaamulisa anamindenga, na vanang'o vànampilikana!” ");
INSERT INTO kde_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Anepo habali dyanga Yesu nkupiyanya kuyanjala nchilambo chammalele cha ku Galilaya. ");
INSERT INTO kde_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu na vakuhundwa vake, pamo na Yakobo na Yohana nkuhumang'ana muing'ande ya kunnyuwila Nnungu, nkuhwena mwalehu mpaka kukaya kwanga Simoni na Anduleya. ");
INSERT INTO kde_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nkawake Simoni álele pachinanda ing'anya ápweteka chidumba. Yesu pakamwele, vanu vanji nkunnyaulila habali dya aneyo mmahe. ");
INSERT INTO kde_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu nkummwenela ayula mmahe, nkunkamula nkono, nkuntakatuha. Chidumba nkummuka, nkutandilika kuvahudumila. ");
INSERT INTO kde_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pachikamwele chinalyulo liduva lititìlè, vanu nkumpelekejija Yesu vagonjo vammalele na vanu vánavele na anamindenga. ");
INSERT INTO kde_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Na vanu vammalele va imanga aila nkunaimila muyo luungo lwa ing'ande. ");
INSERT INTO kde_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu nkuvalamya vanu vohe vachiuula, na kuvausa anamindenga vohe. Na wala nanga panavalekile anevo anamindenga vatangole chinu chohecho kwa kuva vánimmala. ");
INSERT INTO kde_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ulyamba na mambumbu, kabla liduva likànambiuhuma, Yesu ánitakatuka, nkuuka anepo pakaya nkuhwena kunyenje imanga, pachinu pakávele na vanu, nkunnyuwa Nnungu aneko. ");
INSERT INTO kde_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoni na avake nkuhwena unantaha. ");
INSERT INTO kde_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pavammwene, nkunnyaulila kuchidoni, “Vanu vammalele vànakutaha!” ");
INSERT INTO kde_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Henga Yesu nkuvayang'ula kuchidoni, “Tuhweneng'ane vijiji vinji vya pepi uchinga nikàhubili na kunang'o, kwa kuva, njo chinguidilidile.” ");
INSERT INTO kde_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Bahi Yesu nkuhwena kila pachinu aneko ku Galilaya, wahubili n'ding'ande dyavo dya kunnyuwila Nnungu akuno wavausa vanu anamindenga. ");
INSERT INTO kde_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Munu yumo achiuula mangundula nkummwenela Yesu, nkutindivala malundi, nkunnyuwa Yesu wachidoni, “Ukàlembelela ùnahulula chihi unguhahulanga kwa kungulamya.” ");
INSERT INTO kde_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu nkummikila chididi aneyo munu, nkunyoloja nkono wake, nkun'gusa, nkunnyaulila kuchidoni, “Elo nalembela, lama!” ");
INSERT INTO kde_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Upala, ugonjo nkummuka, nkulama. ");
INSERT INTO kde_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Anepo Yesu nkunnyaulila ahwene, nkun'duma wachidoni, ");
INSERT INTO kde_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Kaleha, unannyaulile munu woheyo lanikutendeledile, henga wako hwena ukalilanguje kwa kuhani na kuhumya sadaka muchi chalaijije Musa uchinga vanu vamale kuva ùnihahulwa.” ");
INSERT INTO kde_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Henga ayula munu papite, nkutandilika kuyanjaja aneyo habali kila pachinu. Bahi ing'anya ya anelyo, Yesu nanga panahulwile kuhwena muimanga yoheyo kwa kulilanguja. Nkuntenda aikale kunyenje imanga pachinu paweka pakávele na vanu. Henga vanu nkummwenela kuhaloka kila m'bali. ");
INSERT INTO kde_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Palapitile maduva kadiki, Yesu nkuhwena kavila ku Kapelinaumu, vanu nkupilikana kuva àvele pakaya. ");
INSERT INTO kde_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Vanu vohe namene nkuumbala nng'ande mpaka pannango. Bahi Yesu pachivahubilila vanu, ");
INSERT INTO kde_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","nkuhaloka vanu ncheche akuno vannyakwìlè munu adidimênge, nkumpelekeja kwanga Yesu. ");
INSERT INTO kde_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Bahi kwa kuva vanu vániumbala namene, nanga pavanahulwile kumpelekeja pachinu pávèlè Yesu. Bahi avala vanu nkuvimbula muha palikangala, kuloja pachinu pánavele Yesu. Pavapete chitonono, nkunsulupuha aneyo munu akuno alèlè nchinanda. ");
INSERT INTO kde_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu paiwene ing'ulupa yavo, nkunnyaulila ayula munu adidimênge kuchidoni, “Mwanangu, ùnisamehewa masambi lako.” ");
INSERT INTO kde_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Vakúhunda vanji va Sheliya ya Musa vanaikele anepo nkuva uvaliuja mmitima yavo kuva, ");
INSERT INTO kde_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ayu munu mwadachi àtangola uvila? Ànkufulu Nnungu! Nnani ahulûla kunsamehe munu masambi ikànave chihi Nnungu weka?” ");
INSERT INTO kde_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Upala, Yesu nkumala chivaliuja mmitima yavo, nkuvauja kuchidoni, “Ing'anya ntwani mùtangodikanga uchocho mmitima yenu? ");
INSERT INTO kde_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Lilida lipeyapêya namene, kunnyaulila ayu munu adidimênge kuchi, ‘Ùnisamehewa masambi lako,’ au kunnyaulila, ‘Imila, twala chinanda chako uhwene?’ ");
INSERT INTO kde_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Bahi nangu ngùlembela ngumaihe kuva, Mwana wa Munu, àvele na mamulaka la kuvasamehe vanu masambi lavo apano pachilambo.” Anepo Yesu nkunnyaulila ayula munu adidimênge kuchidoni, ");
INSERT INTO kde_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nìkuhaulila, imila, utwale chinanda chako uhwene kukaya!” ");
INSERT INTO kde_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Upala, ayula munu nkutakatuka, nkutwala chinanda chake, nkuuka. Vanu vammalele nkukangana na kunnombolela Nnungu uvachidoni, “Tukanachona chinu malinga achi.” ");
INSERT INTO kde_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu nkuhwena kavila kunyenje Litanda lya Galilaya. Likuwa lya vanu nkummwenela, nang'e nkutandilika kuvahunda. ");
INSERT INTO kde_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Yesu pánavele nkupita, nkumwona Lawi mwana wanga Alufayo, aikèlè paing'ande ya kulipila kodi. Yesu nkunnyaulila kuchidoni, “Ngupapate!” Lawi nkuimila, nkumpapata. ");
INSERT INTO kde_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Lukoto, Yesu nkuva walya chakulya muing'ande yanga Lawi. Vakútwala kodi vohe na vanu vanji vahaulîka kuva nni vanu vavêle na masambi, vániida nkulya pamo na Yesu na vakuhundwa vake, ing'anya vanu vohe vánampapata. ");
INSERT INTO kde_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Bahi vakúhunda vanji va Sheliya ya Musa vánavele Mafalisayo, pavammwene Yesu walya pamo na vanu vahaulîka kuva vàvele na masambi na vakútwala kodi, nkuvauja vakuhundwa vake kuchidoni, “Mwadachi àlya pamo na vakútwala kodi na vanu vavêle na masambi?” ");
INSERT INTO kde_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu papilikene anelo nkuvahaulila kuchidoni, “Vanu vakáuula nanga pavannembela n'ganga, henga vauûla njo vannembêla n'ganga. Nangu nikáidile unavachema vanu vatênda àlalá lalalembela Nnungu, henga ngùidile unavachema vanu vavêle na masambi.” ");
INSERT INTO kde_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Vakuhundwa va Yohana Nkúbatisa na vakuhundwa va Mafalisayo vánafunga. Bahi vanu nkuhwena unammuja Yesu kuchidoni, “Ing'anya ntwani vakuhundwa va Yohana Nkúbatisa na vakuhundwa va Mafalisayo vànafunga, henga vakuhundwa vako vakáfunga?” ");
INSERT INTO kde_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu nkuvayang'ula kuchidoni, “Dachi, vanu vakumbuliwîje kuing'ole ya ulombi vànahulula kufunga wakati vàvele pamo na mwene nnombi? Ikáhululika kufunga wakati nnombi àvele pamo na vanang'o. ");
INSERT INTO kde_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Henga uhiku uchiukamole, nnombi pambetwaliwa muvanang'o, anepo njo pavambefunga. ");
INSERT INTO kde_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nanga munu atotêla chilaka cha inguwo yahambi nnipindi. Kwa kuva, akàtenda uchocho, chilaka anecho chahambi chìmbekungunyala na kuhalija kupamola anelyo lipindi, na pachinu panapomweke pambeyenjejeka. ");
INSERT INTO kde_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Na wala nanga munu atâya divayi dyahambi mmipatila ya tangu. Akàtenda uchocho, aila mipatila ìnapwapuka ing'anya ya kuhaha kwa divayi, na divayi dìnamwadilika na mipatila nkwondongeka. Henga divayi dyahambi dìlembelewa ditaywe mmipatila yahambi!” ");
INSERT INTO kde_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Liduva limo lya Kuyewelela, Yesu nkuva wapita n'dindila dya mmawelu la ngano chalumo na vakuhundwa vake. Pavachipita, vakuhundwa vake nkutandilika kupulula ngano na kutang'una. ");
INSERT INTO kde_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mafalisayo nkummuja Yesu kuchidoni, “Lola! Mwadachi vàtenda vitukutuku vikáluhusiwije na Sheliya ya Musa kutendwa Nniduva lya Kuyewelela?” ");
INSERT INTO kde_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu nkuvayang'ula kuchidoni, “Dachi, mukásomile chanatendite Nfalume Daudi panalembedile chakulya, nang'e pamo na avake pavanavele na indala?” ");
INSERT INTO kde_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Maduva langa Kuhani Nkulu Abiasali, Daudi áinjidile pa Ing'ande ya Nnungu, nkulya mikate ihumîjwe kwa Nnungu, nkuveng'a na avake navanang'o nkulya, wakati Sheliya ya Musa ìluhusu chihi mikate aneyo kuliwa chihi na makuhani weka. ");
INSERT INTO kde_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Bahi Yesu nkuvahaulila kuchidoni, “Liduva lya Kuyewelela lìnivikwa kwajili ya munu, na akee munu kwajili ya Liduva lya Kuyewelela. ");
INSERT INTO kde_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Bahi Mwana wa Munu njo Nang'olo avêle na mamulaka ata Nniduva lya Kuyewelela.” ");
INSERT INTO kde_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Anepo Yesu nkuinjila kavila muing'ande ya kunnyuwila Nnungu, na amula nkati múvele na munu adidimênge nkono. ");
INSERT INTO kde_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Na múvele na vanu vanji vachitâha ing'anya ya kunsitaki Yesu, bahi nkuva uvannoleha uchinga vamale ikàva àmbennamya munu Nniduva lya Kuyewelela. ");
INSERT INTO kde_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu nkunnyaulila ayula munu avêle na nkono adidimênge kuchidoni, “Ida muyo amuno.” ");
INSERT INTO kde_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Yesu nkuvauja vanu kuchidoni, “Dachi, Sheliya yetu ìnatuluhusu kutenda lambone au lahakalenge Nniduva lya Kuyewelela? Kuupoha umi au kuuwalala?” Henga vanang'o nkunyalala chihi. ");
INSERT INTO kde_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Anepo Yesu nkulaukila mipata yammalele wavalola vanu akuno avisìjè na kuvasikitikila ing'anya ya kunanopa kwa mitima yavo. Nkunyaulila ayula munu kuchidoni, “Nyoloja nkono wako!” Nang'e nkunyoloja, nkono nkuva umi kavila. ");
INSERT INTO kde_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Upala, Mafalisayo nkuhumang'ana pawelu nkunakojana na vanu va likuwa lya Helode uchinga vatahe indila ya kummwalala Yesu. ");
INSERT INTO kde_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu nkuuka anepo pamo na vakuhundwa vake, nkuhwena mpaka kunyenje Litanda lya Galilaya. Likuwa likulu lya vanu nkumpapata. Vanu anevo váhaleke ku Galilaya na ku Yudeya, ");
INSERT INTO kde_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","na ku Yelusalemu na ku Idumeya na vilambo vya m'bali wavili wa muto wa Yoludani na vilambo vidingûka dimanga dya Tilo na Sidoni. Likuwa anelyo lya vanu vámmwenedile Yesu ing'anya vánipilikana àlalá lanatendile Yesu. ");
INSERT INTO kde_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Bahi ing'anya ya vanu kuva vohe, Yesu nkuvahaulila vakuhundwa vake vakamwandalile ingalava, uchinga vanu vanan'gong'ole. ");
INSERT INTO kde_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yesu ánivalamya vanu vohe, na vagonjo vammalele vachipwateka nkuva uvagong'olana uchinga vannyengelekele pepi uchinga van'guse. ");
INSERT INTO kde_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na anamindenga pavammwene Yesu, nkuvamatohija pahi vanu anevo vavêle na anamindenga akuno uvakuta ding'uto uvachidoni, “Wako njo Mwana wanga Nnungu!” ");
INSERT INTO kde_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Henga Yesu nkuvakalipila anamindenga vanammaihe kwa vanu. ");
INSERT INTO kde_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Anepo Yesu nkukwela nnichinga, nkuvachema vanu vavalembedîle, na vanang'o nkuhwena. ");
INSERT INTO kde_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nang'e nkuvatandola vanu kumi na mbili vanavachemile mitume, uchinga vaikale pamo nanang'e na kuvatuma vakayanjaje lilove lya Nnungu, ");
INSERT INTO kde_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","nkuveng'a na mamulaka la kuvausa anamindenga. ");
INSERT INTO kde_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Vanu kumi na mbili vanavatondwele nni avano, Simoni wananchemile Yesu lina linji Petulo, ");
INSERT INTO kde_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","na Yakobo na Yohana vana vanga Sebedayo wanavachemile Yesu, Boanege, mana lake, “Vana va ing'uva,” ");
INSERT INTO kde_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","na Anduleya na Filipo na Batolomayo na Matayo na Tomaso na Yakobo mwana wa Alufayo, na Sadayo na Simoni ánavele nnikuwa lya Vaselote, ");
INSERT INTO kde_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Yuda Isikaliote, ánantengeleke Yesu. ");
INSERT INTO kde_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Anepo Yesu nkuhwena kavila kukaya. Likuwa lya vanu nkumwombalila kavila, Yesu na vakuhundwa vake nkuva nanga pavanapete wasa wa kulya chakulya. ");
INSERT INTO kde_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Valangavake pavapilikene anelo, nkuhwena unantwala, kwa kuva, vanu váhaula kuva, “Àvele na ding'apedi.” ");
INSERT INTO kde_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Na vakúhunda Sheliya yanga Musa vanaheleke ku Yelusalemu, nkuhaula kuchidoni, “Àvele na Nanchindenga, nkulu wa anamindenga. Aneyo njo annyululîha nang'e kuvausa anamindenga.” ");
INSERT INTO kde_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Bahi Yesu nkuvachema, nkuvahaulila kwa mifano kuchidoni, “Ìmbehululika dachi Nanchindenga aliuse mwene? ");
INSERT INTO kde_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ikàva vanu va ufalume umo vànalumbana, ufalume anewo nanga paumbekwimila. ");
INSERT INTO kde_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Na ikàva vanu va ing'ande imo vànalumbana, ing'ande aneyo ikambekwimila. ");
INSERT INTO kde_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Na ikàva Nanchindenga àlitahuka mwene, na ufalume wake ukàlumbanyika, bahi ufalume anewo ukambekwimila, ila ùmbeyanguka. ");
INSERT INTO kde_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nanga munu ahulûla kwenda muing'ande yanga munu avêle na dimongo nkumpakanyola vitukutuku vyake, mpaka atandilike kunnyunga munu aneyo hoti, anepo njo pambehulula kumpakanyola vitukutuku vyake. ");
INSERT INTO kde_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nangu nìnnyaulilanga uhiu kuva, vanu vachivasamehewe masambi lavo lammalele na kufulu dyavo dinji. ");
INSERT INTO kde_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Henga munu ambenkufûlu Umumu Wanaswe, mwiko aneyo nanga pambesamehewa, kwa kuva, àtendile sambi ikásamehewa vyaka na vyaka.” ");
INSERT INTO kde_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu átangwele uchocho kwa kuva, vanu váhaula kuva, “Àvele na nanndenga.” ");
INSERT INTO kde_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Anepo anyokwe Yesu pamo na anung'unuvake nkukamola. Nkuimila pawelu, nkunnaija munu nkati akancheme Yesu. ");
INSERT INTO kde_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Anemwo nng'ande, likuwa lya vanu líniikala akuno lin'dingwìkè Yesu. Vanang'o nkunnyaulila kuchidoni, “Anyoko na anung'unuvako vàvele pawelu, vànakutaha.” ");
INSERT INTO kde_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu nkuvauja kuchidoni, “Kwani nnyuwangu njo nnani na anung'unuvangu nni vanani?” ");
INSERT INTO kde_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Anepo Yesu nkuvalola vanu vanan'digwike nkuhaula kuchidoni, “Lola! Avano apano njo ayuvangu na anung'unuvangu. ");
INSERT INTO kde_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Munu woheyo atênda lalalembela Nnungu, aneyo njo nkulwangu na nnumbwangu na nnyuwangu.” ");
INSERT INTO kde_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu nkutandilika kavila kuvahunda vanu, akuno avèlè nnyenje Litanda lya Galilaya. Likuwa lya vanu nkumwombalanila, bahi Yesu nkubidi akwele muingalava ínavele nnitanda, nkuikala. Vanu vammalele nkuva vaimilèngè munnyangi nnyenje litanda. ");
INSERT INTO kde_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yesu nkuvahunda vitukutuku vyohe kwa mifano, na pachivahunda nkuvahaulila kuchidoni, ");
INSERT INTO kde_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Pilikanila! Nkúpanda ápite únapanda dimbeyu. ");
INSERT INTO kde_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Pánavèlè nkumyaya dimbeyu, dinji nkumatokela nndila, vyuni nkuhaloka nkudidadola. ");
INSERT INTO kde_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Na dimbeyu dinji nkumatokela pachinu pavêle na mayanga-mayanga, pakávele na ulongo wohe. Anedyo dimbeyu nkupiyanya kumela kwa kuva ulongo úvele kadiki. ");
INSERT INTO kde_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Liduva palivadile, aneyo mitipu nkunyala, na kwa kuva dinyiya dikanatadile pahi namene, bahi nkuyumanga. ");
INSERT INTO kde_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Dimbeyu dinji nkumatokela pachinu pavêle miva, nkumela, miva nkukulumuka na kuidingila aila mitipu, nkuva nanga paipele. ");
INSERT INTO kde_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Dimbeyu dinji nkumatokela paulongo wa matapata. Mitipu nkumela, nkukulumuka, na ulongo anewo nkupundya kuhumya mafuno, myanda salasini au sitini au myamoja, kupunda dimbeyu adila dipandwîje.” ");
INSERT INTO kde_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Anepo nkuvahaulila kuchidoni, “Munu avêle na makutu la kupilikana, apilikane!” ");
INSERT INTO kde_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesu pánavele weka, vakuhundwa vake kumi na mbili, pamo na vanu vanji, nkunammuja Yesu chiichilanda aila mifano. ");
INSERT INTO kde_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesu nkuvahaulila kuchidoni, “Mmanganya mùnijaliwa kuimala sili ya Ufalume wanga Nnungu. Henga vanu vanji vakávele nnikuwa lyenu kila chinu vàpilikana kwa mifano, ");
INSERT INTO kde_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","uchinga, ‘Vakàloleha, vanachone chinu, vapilikane, henga vanamale. Ing'anya vakàmala, vàmbemmuila Nnungu, nanang'e achiavasamehele masambi lavo.’ ” ");
INSERT INTO kde_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Anepo Yesu nkuvauja kuchidoni, “Dachi, na mwenu mukámaite nfano auno? Hambi mùmbehulula dachi kumala mifano inji? ");
INSERT INTO kde_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nkúpanda, àpanda Lilove lyanga Nnungu. ");
INSERT INTO kde_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Vanu vanji vàlandanywa na hali ya nndila, amula mudimatokedile adila dimbeyu. Pavapilikana lilove lya Nnungu, Nanchindenga ànaida nkunalitwala lilove lipandwîje mmitima yavo. ");
INSERT INTO kde_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Na vanu vanji vàlandanywa na hali ya pachinu pavêle mayanga-mayanga, apala padimatokedîle adila dimbeyu. Pavalipilikana lilove vànalipwechelela kwa kulihangalalila. ");
INSERT INTO kde_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Henga likávenda mmitima yavo muchi dinyiya chidikahulula kutita mmayanga, bahi vàlikamula chihi kwa uhiku kadiki. Pavalaga ing'anya ya alila lilove, upopo vànalileka. ");
INSERT INTO kde_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Vanu vanji vàlandanywa na hali ya pachinu pavêle na miva, apala padimatokedile adila dimbeyu. Vanu anevo vànalipilikana anelyo lilove, ");
INSERT INTO kde_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","henga madengo la chilambo achino na kulembela kwa dimali na tama dya vitukutuku vinji dìnavenda mmitima yavo na kulitimbanga alila lilove lya Nnungu, nkuva chihi nanga kupa. ");
INSERT INTO kde_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Henga vanu vanji vàlandanywa na hali ya ulongo wa matapata, apala padimatokedile adila dimbeyu. Avano vànalipilikana lilove lya Nnungu na kulikulupila, vanu anevo vànapundya kuhumya mafuno, yumo myanda salasini na yunji sitini na yunji myamoja, kupunda dimbeyu adila dipandwîje.” ");
INSERT INTO kde_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu nkuhweneha uvahaulila kuchidoni, “Dachi, munu ntwani achâcha chibatali nng'ande, nkuchihinika lidebe au unachivika nniungu chinanda? Dachi, akáchivika muha chipanda? ");
INSERT INTO kde_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Bahi kila chinu chipihîje chìmbepihuliwa, na chinu chihinikwîje chìmbehunukuliwa. ");
INSERT INTO kde_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Avêle na makutu la kupilikana, apilikane!” ");
INSERT INTO kde_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yesu nkuvahaulila kavila kuchidoni, “Pilikaniha saana malove lamupilikana! Chipimo chimutumila kuvahukumila vanu vanji, na Nnungu àmbennyukumila kwa chipimo uchocho na ǹnembeyenjejwa. ");
INSERT INTO kde_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Munu avêle na chinu àmbeyenjejwa, na munu akávele na chinu, ata achila kadiki chavenacho àmbepokonyolwa.” ");
INSERT INTO kde_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu nkuhweneha kutangola kuchidoni, “Ufalume wa Nnungu ùlandana na munu yumo achimyaya dimbeyu mmwelu mwake. ");
INSERT INTO kde_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kila liduva ànalala na kutakatuka, akuno dimbeyu udimela na kukulumuka. Henga nang'e nanga panamaite chidichimela. ");
INSERT INTO kde_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ulongo wene njo utenda mitipu ikulumuke na kupa. Ìtandilika uhipuka mahamba matete, nkwida mahahi na nkumalilikila dyene dimbeyu mmahahi. ");
INSERT INTO kde_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ngano ikàtendeka, mwene welu àpita wahenga kwa chipula, kwa kuva nchela ùnikamola.” ");
INSERT INTO kde_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu nkuhaula kavila kuchidoni, “Dachi Ufalume wa Nnungu tuulandanye na chani? Dachi, tuuwelesee kwa nfano ntwani? ");
INSERT INTO kde_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ùlandana na imbeyu ya haladali, imbeyu inyoko namene kupunda dimbeyu dyammalele dya pachilambo. ");
INSERT INTO kde_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Henga ikàpandwa, ìnamela, nkukulumuka nkuva nnandi nkulungwa wa imbowa kupunda milandi yammalele ya mmwelu wa bustani. Ùpaika dinavi ding'ulu dya mmbweha, ata vyuni vànahulula chihi kudenga vitehi n'dinavi dyake na kupata mmbweha.” ");
INSERT INTO kde_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu ánivahubilila vanu ujumbe wake kwa mifano yohe ilandâna na aneyo kupapatana na namuna chivanahulwile kupilikana. ");
INSERT INTO kde_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Yesu nanga panalonjedile navo chohecho bila mifano, henga pánavele pamo na vakuhundwa vake weka ánavafafanulila kila chinu. ");
INSERT INTO kde_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Liduva ulyolyo chinalyulo, Yesu nkuvahaulila vakuhundwa vake kuchidoni, “Tuyomboke litanda, tuhwene m'bali wavili.” ");
INSERT INTO kde_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Bahi vanang'o nkulilaila likuwa lya vanu, nkuinjila muingalava uila yanaikele Yesu, nkuuka pamo nanang'e. Na dingalava dinji nkumpelekela. ");
INSERT INTO kde_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Chimbunga nkupunga, na mawimbi nkuiputa aila ingalava, na medi nkutandilika uumbala muingalava. ");
INSERT INTO kde_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu ávele kunyuma muingalava, alèlè luwono akuno ayamìtè muti wake munsagamiya. Bahi vakuhundwa vake nkumwimula uvachidoni, “Nkúhunda, dachi, wako ukávele na lipamba kuva tùvenkutitimila?” ");
INSERT INTO kde_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu nkutakatuka, nkulikalipila alila lipungo na nkulahaulila mawimbi kuva, “Nyalala!” “Tungamana!” Bahi chimbunga nkunyalala, nkutungamana. ");
INSERT INTO kde_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Anepo Yesu nkuvahaulila vakuhundwa vake kuchidoni, “Ing'anya ntwani mùnayopa? Dachi, mpaka hambi mukánakuva na ing'ulupa?” ");
INSERT INTO kde_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Vanang'o nkuyopa namene, nkuva uvaujana kuva, “Ayu munu wa namuna ntwani? Ata lipungo na mawimbi lànampilikana!” ");
INSERT INTO kde_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu na vakuhundwa vake nkuhwika m'bali wavili wa Litanda lya Galilaya, kuchilambo cha Vagelasi. ");
INSERT INTO kde_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu pasulupwike muingalava, upala nkukojana na munu yumo ánavele na nanndenga, munu aneyo áhaleke ya kumisati. ");
INSERT INTO kde_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Maduva lammalele munu aneyo áikala chihi kumisati na wala nanga munu anahulwile kuntava kavila mididi ya chitale. ");
INSERT INTO kde_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Myanda yohe vánintava mididi ya chitale na dipingu, henga nang'e nkukadulanga aila mididi ya chitale na kulumulanga adila dipingu, na wala nanga munu anahulwile unkamula. ");
INSERT INTO kde_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Chilo na muhi áikala kumisati na myanda inji áva kumachinga wakuta ding'uto akuno walicheketanga mayanga. ");
INSERT INTO kde_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pammwene Yesu kwa kulehu, nkuntukutila nkutindivala malundi. ");
INSERT INTO kde_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Nkunonoha lidi wachidoni, “Yesu Mwana wa Nnungu Nkulu, ùndambela chani? Nakuyuwa uapile kwa Nnungu kuva ukambengubaniha!” ");
INSERT INTO kde_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Átangwele uchocho kwa kuva, Yesu ánnyaulidile kuva, “Wako nanndenga, mmuke ayu munu!” ");
INSERT INTO kde_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Bahi Yesu nkummuja kuchidoni, “Wako lina lyako nnani?” Nang'e nkunnyang'ula kuchidoni, “Lina lyangu Likuwa, kwa kuva hwetu tùvele tuvohe.” ");
INSERT INTO kde_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Avala anamindenga nkunnyuwa Yesu kavila uchinga anavayamile nchilambo achila. ");
INSERT INTO kde_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Pepi na anepo pávele na likuwa likulu lya dinguluve dichisosanya chakulya nnyenje lichinga. ");
INSERT INTO kde_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Bahi avala anamindenga nkumpembeja Yesu uvachidoni, “Tuamulise tuhwene padinguluve adila, ùtuluhusu tuvende.” ");
INSERT INTO kde_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu nkuvaluhusu. Anepo anevo anamindenga nkummuka ayula munu, nkunavenda avala anguluve. Alila likuwa lyammalele lya dinguluve dínavele malinga alufu mbili, nkuhelelekela kumakobikobi, nkutubukila nnitanda na vammalele nkuhwa mmedi. ");
INSERT INTO kde_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Vachúnga va adila dinguluve nkutukuta, nkunavahaulila vanu vavêle kumanga na kumawelu kwamba mambo lammalele lavahumidîle. Vanu nkuhwena unalola lahumidîle. ");
INSERT INTO kde_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pavahwikile kwanga Yesu, nkumwona ayula munu ánavele na likuwa lya anamindenga aikèlè pahi, awètè dinguwo dyake na ding'ano dyake dimmuidìlè, vanu vammalele nkuyopa. ");
INSERT INTO kde_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Vanu valawêne àlalá latendêke na lavapête anguluve, nkuhwena unavahaulila vanu vanji. ");
INSERT INTO kde_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Bahi nkutandilika kunnyuwa Yesu auke nchilambo chavo. ");
INSERT INTO kde_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu pánavele nkukwela muingalava, ayula munu ánavele na anamindenga nkunnyuwa Yesu apapatane nawe. ");
INSERT INTO kde_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Henga Yesu nkunnyitila. Nkunnyaulila kuchidoni, “Wako hwena kukaya kwa alangavako ukavahaulile lammalele lakutendedîle Nang'olo na namuna chakuvikidile chididi.” ");
INSERT INTO kde_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Bahi ayula munu nkuhwena n'dimanga kumi dichêmwa Dikapoli, wayanjaja habali dya mambo àlalá lammalele lántendedìlè Yesu. Na vanu vammalele vanapilikene, nkukangana. ");
INSERT INTO kde_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu nkuyombokela kavila m'bali wavili wa litanda. Pánavele nnyenje litanda, vanu vohe nkun'dinguka. ");
INSERT INTO kde_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Anepo nkwida munu yumo ánavele nkulu wa ing'ande ya kunnyuwila Nnungu, uvanchema Yailo. Pammwene Yesu nkulimatohija mmadodo mwanga Yesu, ");
INSERT INTO kde_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","nkunnyuwa wachidoni, “Nahaku wangu ànabwahela namene na àvele pepi na kuhwa. Nakuyuwa uide, ukammikile makono lako, apate kulama na kuva mumi.” ");
INSERT INTO kde_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Bahi Yesu nkulongana nawe. Na vanu vohe nkumpapata, akuno uvan'gumaguma kila m'bali. ");
INSERT INTO kde_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Umula nnikuwa múvele na mmahe yumo achiuula ugonjo wa kuhuma myadi vyaka kumi na mbili. ");
INSERT INTO kde_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mmahe aneyo ánibanika namene wavahwenela vaganga. Ánimalila dihela dyake dyammalele waliuuja, henga wala nanga panapete wasa, nkuhalija chihi kupwateka. ");
INSERT INTO kde_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Mmahe aneyo papilikene habali dyanga Yesu, nkuvapunda vanu vammalele va nnikuwa alila, nkummwenela Yesu kwa nnyuma, nkunagusa lijoho lyawete Yesu. ");
INSERT INTO kde_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Átendile uchocho kwa kuva ánilitongolela mwene kuva, “Nikàgusa chihi lijoho lyake nguchingulame.” ");
INSERT INTO kde_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Pagusije chihi inguwo ya Yesu, upala myadi nkuleka kuhuma, mwene nkulyona mummili mwake kuva ànilama. ");
INSERT INTO kde_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Upala Yesu nkumala kuva dimongo dyake dìnimmuka. Nkulilaukila alila likuwa lya vanu, nkuuja kuchidoni, “Nnani angugusîje inguwo yangu?” ");
INSERT INTO kde_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Vakuhundwa vake nkunnyang'ula kuchidoni, “Ùvenkulola vanu chivakuguma-guma, mwadachi ùuja kuva nnani akugusîje?” ");
INSERT INTO kde_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Henga Yesu nkuhalija kulola mipata yammalele uchinga amwone ayula atendîle uchocho. ");
INSERT INTO kde_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ayula mmahe nkuyopa na nkutandilika kutetemela, ing'anya ánimala lammalele lannyumidile. Nkuhwena unaliyaha mmadodo langa Yesu, nkunnyaulila lammalele. ");
INSERT INTO kde_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu nkunnyaulila kuchidoni, “Mwanangu, ing'ulupa yako ìnikulamya. Hwena kwa amani, na ulame mwelehu ugonjo wako.” ");
INSERT INTO kde_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu pánavele nkutongola anelo, nkwida vanu kuhaloka kukaya kwanga Yailo nkulu wa ing'ande ya kunnyuwila Nnungu, nkunnyaulila ayula nkulu kuchidoni, “Nahaku wako ànihwa. Chamani chuhalija chihi unkambyakambya Nkúhunda?” ");
INSERT INTO kde_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Henga Yesu nanga panapilikanidile malove lavo, nkunnyaulila Yailo kuchidoni, “Unayope, wako kulupila chihi.” ");
INSERT INTO kde_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesu nanga panalembedile apelekelwe na munu yunji, henga nkuhwena chihi na Petulo na Yakobo na Yohana nnung'une Yakobo. ");
INSERT INTO kde_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pavahwikile pakaya pa Yailo, Yesu nkupilikana vanu uvakuta na kulikutangila. ");
INSERT INTO kde_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesu nkuinjila nng'ande, nkuvahaulila vanu kuchidoni, “Mwadachi mùnanyakonya na kukutanga? Mwana nanga pahwile, àlele chihi luwono.” ");
INSERT INTO kde_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Henga vanang'o nkunnyeka. Bahi Yesu nkuvahumya vanu vammalele panda, nkuntwala chihi atatake na anyokwe mwali na avala vakuhundwa vake vatatu vanalangene navo, nkuinjila nchumba chanalele aneyo mwali. ");
INSERT INTO kde_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesu nkunkamula nkono ayula nahaku, nkunnyaulila kuchidoni, “Talita kumi!” Mana lake, “Nahaku nìkuhaulila imila!” ");
INSERT INTO kde_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Upala, ayula mwali nkuimila, nkutandilika uhwena. Ayula mwali ávele na vyaka kumi na mbili. Anepo vanu pavalawene anelo latendêke, nkukangana namene. ");
INSERT INTO kde_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu nkuvaduma vananyaulile munu woheyo kwamba àlalá latendêke. Anepo nkuvahaulila vamwing'e ayula mwali chakulya alye. ");
INSERT INTO kde_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu nkuuka anepo nkuhwena kuchijiji chavelekwije, akuno apapatènè na vakuhundwa vake. ");
INSERT INTO kde_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Liduva lya Kuyewelela, nkutandilika kuvahunda vanu muing'ande ya kunnyuwila Nnungu. Vanu vohe vampilikêne nkukangana, nkuhaula kuchidoni, “Dachi, àlamaite dachi mahundo anelo lammalele? Lúnda lwa namuna ntwani alu lwapete ayu munu? Lola masaibu lalatenda kwa makono lake! ");
INSERT INTO kde_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kwani ayu akee ayula fundi selemala mwana wa Maliya, nkuluwe Yakobo na Yose na Yuda na Simoni? Dachi, alumbuvake tenda tuikanavo upano petu?” Bahi vanang'o nkusunala namene kwajili yanga nang'e, nkuhita kunkulupila. ");
INSERT INTO kde_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu nkuvahaulila kuchidoni, “Nabii nanga kwakapata eshima ikànave chihi nkaya yake na kwa alangavake na nng'ande mwake.” ");
INSERT INTO kde_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yesu nanga panatendile masaibu aneko, henga ávavikidile chihi makono vagonjo kadiki na kuvalamya. ");
INSERT INTO kde_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yesu ánikangana ing'anya vanu nanga pavachikulupila. Anepo Yesu nkuhwena kuvijiji vya pepi, wavahunda vanu. ");
INSERT INTO kde_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesu nkuvachema avala vakuhundwa kumi na mbili, nkuvatuma vavili-vavili. Nkuveng'a mamulaka la kuvausa anamindenga. ");
INSERT INTO kde_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nkuvalaija wachidoni, “Munanyakule chinu chohecho kwajili ya mwanda, ila nyakula chihi isimbo. Munanyakule nkate wala mpatila wala dihela pachitondo. ");
INSERT INTO kde_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Walanga vilatu, henga nnanyakule nkogo wa akiba.” ");
INSERT INTO kde_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nkuvahaulila kavila kuchidoni, “Paing'ande ivambempwechelela, ikalanga anemo mpaka pamumbeuka paimanga aneyo. ");
INSERT INTO kde_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Na pachinu pohepo pavambehita kumpwechelela na kumpilikanila, ukananga anepo na muvakane kwa kulipumunanga litutunga lya mmadodo lenu ilanguje kuva, vene vànitandola kulahita malove la Nnungu.” ");
INSERT INTO kde_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Anepo vakuhundwa nkuukananga, nkuhwena unavahubilila vanu valeke masambi lavo. ");
INSERT INTO kde_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nkuvausa anamindenga vohe, nkuvapaka mahuta la seituni vagonjo vohe, na kuvalamya. ");
INSERT INTO kde_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nfalume Helode ánipilikana habali dyanga Yesu, kwa kuva lina lyanga Yesu líniumana kila pachinu. Vanu vanji nkuhaula kuchidoni, “Yohana Nkúbatisa ànifufulwa, njo mana àvele na dimongo dya masaibu dikôla madengo nkati mwake.” ");
INSERT INTO kde_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Vanji nkuhaula kuchidoni, “Nang'e nni Eliya.” Na vanji nkuchidoni, “Nang'e nni nabii malinga yumo wa manabii va machedo.” ");
INSERT INTO kde_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Henga Helode papilikene uchocho, nkuchidoni, “Aneyo àmbekuva Yohana Nkúbatisa ungunanchekete muti, henga ànifufulwa!” ");
INSERT INTO kde_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Mwene Helode njo ánalaijije Yohana akamulwe na kutaywa nnilungu. Átendile uchocho ing'anya Helode ánnombile Helodiya, ánavele n'jawe Filipo, nnung'une wake mwene. ");
INSERT INTO kde_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yohana ánnyaulidile Helode kuchidoni, “Ikáluhusiwa wako kwikalana na nkongwe wa nnung'uno.” ");
INSERT INTO kde_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Bahi Helodiya nkuva wanchima Yohana, nkulambela ammwalale, henga nanga panahulwile ing'anya yanga Helode. ");
INSERT INTO kde_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Helode áninnyopa namene Yohana kwa kuva ánimala kuva Yohana nni munu wanaswe atênda lalalembela Nnungu, bahi nkuva wanchunga. Helode ánanowelwa namene kumpilikanila Yohana, henga kila pachimalila kumpilikanila, ánahinginika namene muntima mwake. ");
INSERT INTO kde_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Liduva limo Helodiya nkupata wasa wa kummwalala Yohana. Liduva anelyo lyávele liduva lya sikukuu ya kuvelekwa kwa Nfalume Helode. Helode ávatendedile ing'ole vakulu vake na vakulu va matiyala na vakulu va chilambo cha ku Galilaya. ");
INSERT INTO kde_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Bahi mwali wanga Helodiya ániinjila nkuvina saana, nkunhangalaja Helode na vayeni vake. Nfalume nkunnyaulila ayula mwali kuchidoni, “Nguyuwe chinu chohecho chulambela, nangu nguchinikwing'e.” ");
INSERT INTO kde_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nkunnyaulila kavila kuchidoni, “Chinu chohecho chumbenguyuwa, nguchinikwing'e ata kuiva nusu ya ufalume wangu.” ");
INSERT INTO kde_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Anepo ayula mwali nkuuka, nkunammuja anyokwe kuchidoni, “Ninnyuwe chamani?” Anyokwe nkunnyang'ula kuchidoni, “Yuwa muti wanga Yohana Nkúbatisa.” ");
INSERT INTO kde_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ayula mwali nkutukuta mpaka kwanga nfalume nkunnyaulila kuchidoni, “Ngùlembela uning'e uvino nsahani muti wanga Yohana Nkúbatisa.” ");
INSERT INTO kde_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nfalume nkuva nnihindambi likulu, henga nanga panahulwile kunnyitila ing'anya ya vayeni vanavakumbwile na kwapila kwanaapidile. ");
INSERT INTO kde_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Upala, nfalume nkuntuma litiyala, nkunnaija aide na muti wanga Yohana Nkúbatisa. Ayula litiyala nkuhwena nnilungu, nkunancheketa Yohana muti. ");
INSERT INTO kde_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Anepo nkuida na muti nsahani, nkumwing'a ayula mwali, nanang'e nkunamwing'a anyokwe. ");
INSERT INTO kde_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Vakuhundwa vanga Yohana pavapilikene anelo, nkuhwena unautwala mmili wanga Yohana, nkuusika. ");
INSERT INTO kde_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Bahi avala vakuhundwa vanga Yesu nkuuyang'ana kwanga Yesu, nkunnyaulila lammalele lávatendìlè na lávahundìlè. ");
INSERT INTO kde_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yesu nkuvahaulila kuchidoni, “Tuhweneng'ane mpaka pachinu pakávele na vanu uchinga mukayewelele kadiki.” Átangwele uchocho kwa kuva apala pachinu pávele na vanu vohe namene vachikamola na kuuka. Yesu na vakuhundwa vake nanga pavanapete wasa wa kulya chakulya. ");
INSERT INTO kde_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nkukwelanga muingalava weka nkuukananga, nkuhwena pachinu pakávele na vanu. ");
INSERT INTO kde_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Henga vanu nkuvona pavachiukananga, nkumala kuvachihwena. Vanu vohe vachihaloka kila imanga, nkutukutila kwa madodo ukula kwapite Yesu na vakuhundwa vake, nkulitandya kuhwika. ");
INSERT INTO kde_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu pasulupwike muingalava, nkulyona likuwa lya vanu vohe, nkuvavikila chididi, kwa kuva vávele muchi dingandolo dikávele na nchunga. Bahi nkutandilika kuvahunda vitukutuku vyohe. ");
INSERT INTO kde_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pachikamwele chinalyulo, vakuhundwa vake nkummwenela Yesu, nkunnyaulila kuchidoni, “Apano patuvele nni palilanga na hambi liduva lìniswa. ");
INSERT INTO kde_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Bahi valaile vanu vahwene mmawelu na n'dimanga dya pepi uchinga vakalisumile chakulya.” ");
INSERT INTO kde_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Henga Yesu nkuvahaulila kuchidoni, “Veng'e mwenu chakulya.” Vanang'o nkunnyang'ula kuchidoni, “Wako wamba dachi, tuhwene tukasume mikate kwa dihela malinga dya nshahala wa kawaida wa malipo la maduva myambili uchinga tuveng'e valye?” ");
INSERT INTO kde_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu nkuvauja kuchidoni, “Mùvele na mikate mingapi? Hwena nahoti mukalole.” Pavapite unalola nkuchidoni, “Kùvele mikate nnyano na ahomba vavili.” ");
INSERT INTO kde_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Bahi Yesu nkuvahaulila vakuhundwa vake vavahaulile vanu vammalele vaikalange matunji-matunji, muwahi mmihi. ");
INSERT INTO kde_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nkuikala matunji-matunji la vanu mia-mia na matunji la vanu amsini-amsini. ");
INSERT INTO kde_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Anepo Yesu nkuitwala aila mikate nnyano na avala ahomba vavili, nkulola muha kulihunde, nkunshukulu Nnungu. Nkuimeyanya aila mikate pamo na ahomba vavili, nkuveng'a vakuhundwa vake vavayavile vanu. ");
INSERT INTO kde_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Vanu vammalele nkulya na kusiba. ");
INSERT INTO kde_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Vakuhundwa vake nkulokotanga vibeduli vya mikate iisalidîle na vibeduli vya ahomba, nkuumbaja makalala kumi na mbili. ");
INSERT INTO kde_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Na vanu vanalile aila mikate vávele malinga valume alufu nnyano ukàleka vavana na akongwe. ");
INSERT INTO kde_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Upala Yesu nkuvakulumisa vakuhundwa vake vakwele muingalava, vannongolele kuhwena ku Betisaida, ng'ambo ya litanda, akuno nang'e avenkulilaìlà likuwa lya vanu. ");
INSERT INTO kde_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pamalidile kuvalaila vanu, nkuhwena kulichinga unayuwa. ");
INSERT INTO kde_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pachikamwele chinalyulo, ingalava nkuva ching'ati litanda, Yesu nanang'e ávele chihi weka pachinu pakávele medi. ");
INSERT INTO kde_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Bahi nkuvona vakuhundwa vake chivachilaga amula muingalava, kwa kuva, lipungo línavapungila namene. Kulyamba, Yesu nkuvakoja vakuhundwa vake akuno waonga muha medi, nkùlembela kuvapunda. ");
INSERT INTO kde_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Vanang'o pavammwene avenkwòngà muha medi, vátenda lindelya, nkuva uvakuta ding'uto, ");
INSERT INTO kde_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","kwa kuva, vammalele pavammwene vániyopa namene. Henga upala Yesu nkuvahaulila kuchidoni, “Likamyange ntima, nni nangu! Munayope!” ");
INSERT INTO kde_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Anepo Yesu nkukwela muingalava muvanavele vakuhundwa, lipungo nkunyalala. Vakuhundwa vake nkukangana namene, ");
INSERT INTO kde_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ing'anya nanga pavanakameke mana ya alila lisaibu lya kuyenjeja mikate, kwa kuva, mitima yavo ínikamajanga kumala. ");
INSERT INTO kde_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yesu na vakuhundwa vake pavayombweke litanda, nkuhwika chilambo cha ku Genesaleti, anepo nkuimija ingalava yavo. ");
INSERT INTO kde_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pavahumite chihi muingalava, upala vanu nkummala mwelehu Yesu. ");
INSERT INTO kde_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Anepo vanu nkupita uvatukuta nchilambo chammalele uvavanyakula vagonjo mminanda, na kuvapelekeja kila pachinu pavanapilikene kuva Yesu àvele anepo. ");
INSERT INTO kde_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Na kila pachinu Yesu panapite, mmijiji na n'dimanga na mmawelu, vanu nkuvavika vagonjo mmakojano. Nkunnyuwa avaluhusu van'guse kananga lupepe lwa lijoho lyake. Na vammalele vanan'gusije vánilama mwalehu. ");
INSERT INTO kde_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mafalisayo na vakúhunda vanji va Sheliya yanga Musa vanahaleke ku Yelusalemu vánikojana muyo mwanga Yesu. ");
INSERT INTO kde_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Nkuvona vakuhundwa vanji vanga Yesu uvalya chakulya kwa makono lakákalavijwe kupapatana na nnyambo wa dini ya Chiyahudi. ");
INSERT INTO kde_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mafalisayo na Vayahudi vammalele vàkamulila mihambo ya anyakala vao, vanang'o nanga pavalya chakulya bila kulihahula kwa kukalava medi mmakono malinga chiilembelewa. ");
INSERT INTO kde_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Na pavahaloka kusakoni nanga pavalya chinu chohecho bila kuchihahula. Uchocho, vàkamulila mihambo inji yohe malinga, kuhahula myawo na vilongo na vyombo vya vitale. ");
INSERT INTO kde_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Bahi Mafalisayo na vakúhunda va Sheliya ya Musa nkummuja Yesu kuchidoni, “Ing'anya ntwani vakuhundwa vako nanga pavalakamula mahundo la mihambo ivatulekedile anyakala vetu, henga vanang'o vàlya chihi kwa makono ivêle najisi?” ");
INSERT INTO kde_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu nkuvayang'ula kuchidoni, “Mmakulilambilila mwenu! Nabii Isaya álaujije saana kumwamba mwenu, panalembile malove la Nnungu lahaûla kuva, ‘Ava vanu vàngweshimu chihi pakanya, henga mitima yavo ìvele kulehu na nangu. ");
INSERT INTO kde_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kungwabudu kwavo kukee mana, kwa kuva, mahundo lavo nni malaijo chihi la vanu.’ ");
INSERT INTO kde_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mwenu mùleka amuli dya Nnungu nkupapata malaijo la vanu.” ");
INSERT INTO kde_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu nkuhweneha kuvahaulila kuchidoni, “Mwenu mùnimala kuditila amuli dya Nnungu kwa ulamba uchinga mulakamule mahundo la mihambo yenu mmene! ");
INSERT INTO kde_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kwa kuva, Musa ánihaula kuva, ‘Mweshimu atatako na anyoko,’ na ‘Munu woheyo antongolêla atatake au anyokwe malove lahakalenge àlembelewa awalalwe.’ ");
INSERT INTO kde_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Henga mwenu mùvahunda vanu kuva, akee lasima munu kumweshimu atatake au anyokwe, na mùhunda kuva munu ànahulula chihi kunnyaulila atatake au anyokwe kuva ‘Chinu chichichichikwing'e faida, ngùchihumije sadaka kwa Nnungu,’ ");
INSERT INTO kde_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","bahi munu aneyo akálembelewa kavila kunnyangata atatake au anyokwe. ");
INSERT INTO kde_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Uvila njo chimulileka lilove lyanga Nnungu kwajili ya mihambo yenu imupwecheledile. Na mùtendanga vitukutuku vyohe vilandêne na anevyo.” ");
INSERT INTO kde_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Anepo Yesu nkulichema kavila likuwa lya vanu, nkuvahaulila kuchidoni, “Mwenu mmammalele ngupilikanihe saana mumale kuva, ");
INSERT INTO kde_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","nanga chinu chalya munu nkuntenda munu aneyo kuva najisi. Henga achila chihalôka nkati mwanga munu anecho njo chintênda munu kuva najisi. ");
INSERT INTO kde_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Bahi munu avêle na makutu la kupilikana na apilikane!” ");
INSERT INTO kde_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesu nkulileka likuwa lya vanu nkuinjila nng'ande, vakuhundwa vake nkunammuja chuuchilanda aula nfano. ");
INSERT INTO kde_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu nkuvauja kuchidoni, “Dachi, ata na mwenu mukámaite chuulanda nfano? Dachi, mwenu mukámaite kuva chakulya chalya munu nanga pachintenda munu aneyo kuva najisi? ");
INSERT INTO kde_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kwa kuva, nanga pachimwenda muntima, ila chènda chihi nnitumbo na lukoto nkunachiyapuka.” Na kwa kuhaula uchocho, Yesu ánilanguja kuva vyakulya vyammalele vìnaluhusiwa kuliwa. ");
INSERT INTO kde_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yesu nkuhweneha kutangola kuchidoni, “Chinu chinnyûma munu anecho njo chintênda munu kuva najisi. ");
INSERT INTO kde_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kwa kuva, muntima mwanga munu mùhaloka mawaso lahakalenge na usalati na kwiva na kuwalala, ");
INSERT INTO kde_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","na kulala ugoni na kwima na ditama dibaya na kulambila na kulavalava na wiu na kuntongolela munu malove lahakalenge na kulyona na uvelu. ");
INSERT INTO kde_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Anelo lahakalenge lammalele làhuma nkati mwanga munu, na anelo njo lantênda munu ààve najisi.” ");
INSERT INTO kde_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Bahi Yesu nkuuka apala nkuhwena chilambo chivêle pepi na imanga ya ku Tilo. Pahwikile aneko nkuinjila muing'ande imo kwa kuva, nanga panalembedile munu woheyo amale. Henga nanga panahulwile kulipiha. ");
INSERT INTO kde_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Bahi mmahe yumo ánavele na mwali n'joko ánavele na nanndenga, ánipilikana habali dyanga Yesu. Bahi nkummwenela Yesu nkutindivala malundi muyo mwake. ");
INSERT INTO kde_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mmahe aneyo nanga panavele Nnyahudi, henga ávele mwenedi wa ku Foinike, chilambo cha ku Siliya. Nkunnyuwa Yesu ammuse nanndenga mmwanawe. ");
INSERT INTO kde_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu nkunnyang'ula kuchidoni, “Valeke hoti vavana vasibe, kwa kuva, ikákatapala utwala chakulya cha vavana nkuvayelela ang'avanga.” ");
INSERT INTO kde_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Henga ayula mmahe nkunnyang'ula Yesu kuchidoni, “Elo Nang'olo, henga ata ang'avanga vavêle pahi meza vàlya makombo la chakulya cha vavana.” ");
INSERT INTO kde_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesu nkunnyaulila ayula mmahe kuchidoni, “Ing'anya ya iyang'udi yunguyang'wile, hwena kukaya, nanndenga ànimmuka mwanalo!” ");
INSERT INTO kde_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Anepo ayula mmahe nkuhwena kukaya kwake, nkunankoja mwanawe alèlè pachinanda, nanndenga ammukìlè. ");
INSERT INTO kde_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Anepo Yesu nkuuka kudimanga dya chilambo cha ku Tilo, nkupita ching'ati imanga ya ku Sidoni na dimanga kumi dichêmwa Dikapoli, nkuhwena ku Litanda lya ku Galilaya. ");
INSERT INTO kde_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Vanu vanji nkumpelekejija munu ánavele na chitata na mmwidi, nkunnyuwa Yesu ammikile makono. ");
INSERT INTO kde_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu nkummusa ayula munu palikuwa lya vanu, nkumpelekeja kunyenje, nkumwinjija vyala mmakutu lake, Yesu nkusuna mata, nkun'gusa nnulimi na àlalá mata. ");
INSERT INTO kde_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Anepo Yesu nkulola muha kulihunde, nkuyaha ntima, nkunnyaulila ayula munu kuchidoni, “Efata,” mana lake “Hunguka.” ");
INSERT INTO kde_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Upala makutu la ayula munu nkudiuka na lulimi lwake nkupeyapeya, nkutandilika kutangola saana. ");
INSERT INTO kde_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu nkuvalaija vanannyaulile munu woheyo àlalá lalatendile apala. Henga malinga chavalimbijije, nni chivahalijije kuyanjaja habali aneyo. ");
INSERT INTO kde_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Vanu nkuhalija kukangana namene, nkuva uvatangola kuchidoni, “Lammalele lalatenda lànikatapala. Àvatenda vanu vánavele mimwidi vapilikane na bubu vapate kutangola!” ");
INSERT INTO kde_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mmaduva àlalá likuwa likulu lya vanu nkummwenela Yesu kavila. Bahi pachivahilidile chakulya, Yesu nkuvachema vakuhundwa vake nkuvahaulila kuchidoni, ");
INSERT INTO kde_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nangu nìvavikila chididi ava vanu ing'anya vàikele na nangu maduva matatu vino, na hambi chakulya chìnivahilila. ");
INSERT INTO kde_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nikàvahaulila vahwene kukaya kwavo akuno vavèlè na indala vachivadilike nndila, kwa kuva vanji vàhaleke kulehu.” ");
INSERT INTO kde_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Vakuhundwa vake nkummuja Yesu kuchidoni, “Apano patuvele palilanga, tùmbepata kwachi mikate ya kuvatoleja vanu ava vammalele?” ");
INSERT INTO kde_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu nkuvauja kuchidoni, “Mùvele na mikate mingapi?” Vanang'o nkunnyang'ula kuchidoni, “Saba.” ");
INSERT INTO kde_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesu nkuvahaulila vanu vaikalange pahi. Nkuitwala aila mikate saba, nkunshukulu Nnungu, nkuimeya, nkuveng'a vakuhundwa vake vavayavile vanu, na vakuhundwa nkutenda uchocho. ");
INSERT INTO kde_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Uchocho, pávele na ahomba vajoko, Yesu nkuvatwala avala ahomba nkunshukulu Nnungu, nkuvahaulila vakuhundwa vake vavayavile vanu. ");
INSERT INTO kde_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Vanu nkulya na kusiba, vakuhundwa nkulokotanga vibeduli vya mikate na ahomba, nkuumbaja makalala saba. ");
INSERT INTO kde_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Na vanu vanalile vávele malinga alufu ncheche. Anepo Yesu nkuvalaila vahwene kukaya, ");
INSERT INTO kde_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","upala nkwenda muingalava chalumo na vakuhundwa vake, nkuhwena kuchilambo cha ku Dalumanuta. ");
INSERT INTO kde_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mafalisayo nkummwenela Yesu, nkutandilika kutahukana nawe. Nkuva uvanninga uvalembela alanguje chimaiho cha lisaibu chimaîha kuva dimongo dyake dìhaloka muha kulihunde. ");
INSERT INTO kde_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu nkuyaha ntima, nkuhaula kuchidoni, “Mwadachi mmanu mma chívelèkwà achino mùlembela mulangujwe chimaiho? Nangu nìnnyaulilanga uhiu kuva, nikambennanguja chimaiho chohecho cha lisaibu.” ");
INSERT INTO kde_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Anepo Yesu nkuvaleka, nkukwela muingalava, nkuyamboka kuhwena kung'ambo litanda. ");
INSERT INTO kde_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Vakuhundwa vanga Yesu vániluvalila kunyakula mikate, na vávele chihi na nkate umo amula muingalava. ");
INSERT INTO kde_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu nkuvaduma vakuhundwa vake wachidoni, “Lyongolelange na hamila ya Mafalisayo na ya Helode.” ");
INSERT INTO kde_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Vakuhundwa nkutandilika kutongojana vene kwa vene uvachidoni, “Àtangola uchocho ing'anya itukavele na mikate.” ");
INSERT INTO kde_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu nkumala lavachiujana, nkuvauja kuchidoni, “Mwadachi mùnaujana ing'anya imukavele na mikate? Dachi, mpaka hambi mukánamala wala kwelewa? Dachi, mitima yenu ìvechinkunonopa? ");
INSERT INTO kde_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Dachi, mùvele na meho henga mukálola? Dachi, mùvele na makutu henga mukápilikana? ");
INSERT INTO kde_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Dachi, mukákumbukila apala pangunaimeite aila mikate nnyano nkuvayavila valume alufu nnyano chalumo na vavana na akongwe? Dachi, múlokotenge makalala mangapi la vibeduli vya maisalilo la mikate?” Nkunyang'ula kuchidoni, “Kumi na mbili.” ");
INSERT INTO kde_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesu nkuvauja kavila kuchidoni, “Dachi, pangunaimeite aila mikate saba nkuveng'a vanu alufu ncheche, múlokotenge makalala mangapi la vibeduli?” Vakuhundwa nkunnyang'ula kuchidoni, “Saba.” ");
INSERT INTO kde_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yesu nkuvauja kuchidoni, “Dachi, mpaka hambi mukánakwelewa?” ");
INSERT INTO kde_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu nkuhwika ku Betisaida chalumo na vakuhundwa vake. Aneko vanu vanji nkumpelekejija munu yumo akáchilola, nkunnyuwa Yesu an'guse. ");
INSERT INTO kde_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu nkunkamula nkono ayula munu aputêle meho, nkumpelekeja pawelu chijiji. Nkunsunila mata mmeho, nkummikila makono, nkummuja kuchidoni, “Dachi, ùnachona chinu chohecho?” ");
INSERT INTO kde_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ayula munu akáchilola, nkuyang'uka kuchidoni, “Nìvona vanu vaonekâna muchi milandi ìhwenahwena.” ");
INSERT INTO kde_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu nkuvika kavila makono mmeho mwa ayula munu aputêle meho. Anepo meho la ayula munu nkupata kulola, nkuchona kila chinu saana. ");
INSERT INTO kde_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu nkunnyaulila ayula munu ahwene kukaya kwake, nkunnaija wachidoni, “Unauile kavila kuchijiji!” ");
INSERT INTO kde_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu na vakuhundwa vake nkuuka, nkuhwena kuvijiji vivêle pepi na imanga ya ku Kaisaliya Filipi. Pávanavele nndila, Yesu nkuvauja vakuhundwa vake kuchidoni, “Dachi, vanu vàhaula kuva nangu nnani?” ");
INSERT INTO kde_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Vakuhundwa nkunnyang'ula kuchidoni, “Vanji vàhaula kuva wako Yohana Nkúbatisa, na vanji vàhaula kuva wako Eliya na vanji vàhaula kuva wako nni yumo wa manabii.” ");
INSERT INTO kde_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Anepo Yesu nkuvauja kuchidoni, “Na mwenu muchidachi, nangu nnani?” Petulo nkuyang'ula kuchidoni, “Wako njo Kilisto.” ");
INSERT INTO kde_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesu nkuvaduma vanannyaulile munu woheyo habali dyake. ");
INSERT INTO kde_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesu nkutandilika kuvahunda vakuhundwa vake wachidoni, “Mwana wa Munu àmbebanika namene na kuhitwa na vasele va Vayahudi na makuhani vakulu na vakúhunda Sheliya ya Musa. Vàmbemmwalala, henga liduva lya tatu lya kuhwa kwake àmbefufuka.” ");
INSERT INTO kde_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu ávahaulidile habali aneyo bila kuvapiha. Bahi Petulo nkuntwala Yesu kunyenje, nkutandilika kuntahuka. ");
INSERT INTO kde_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Henga Yesu papindikwike nkuvalola vakuhundwa vake, nkunkalipila Petulo wachidoni, “Uka muyo mwangu Nanchindenga! Kwa kuva, mawaso lako lakee la chinnungu ila la chimunu chihi.” ");
INSERT INTO kde_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Anepo Yesu nkulichema likuwa lya vanu pamo na vakuhundwa vake, nkuvahaulila kuchidoni, “Munu woheyo akàlembela ungupapata nangu, lasima alishukulu mwene, alitike nsalaba wake, koka angupapate. ");
INSERT INTO kde_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Na munu woheyo autâmwa namene umi wake kupunda changutamwa nangu, akámbekuva na umi, henga munu akubâli kuhwa ing'anya yang'une na ing'anya ya Malove Lambone achiave na umi. ");
INSERT INTO kde_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Dachi, munu àmbepata faida ntwani akàpata kila chinu cha pachilambo, akuno auyahìtè umi ukee na ntululilo? ");
INSERT INTO kde_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Au pàvele chinu ntwani apano pachilambo munu chambebadilana uchinga apate umi ukee na ntululilo? ");
INSERT INTO kde_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Munu woheyo wa nchívelèkwà achino chivêle na masambi, akàngwonela nangu dihoni na malove langu, Mwana wa Munu achiamwonele dihoni munu aneyo, pambeida muukulu wa Atatake pamo na malaika vanaswe.” ");
INSERT INTO kde_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu nkuhweneha kuvahaulila kuchidoni, “Nangu nìnnyaulilanga uhiu kuva, vanu vanji vaimidîle apano vakambekuhwa mpaka vawone Ufalume wanga Nnungu uìdà kwa dimongo.” ");
INSERT INTO kde_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Bada ya maduva sita, Yesu nkuntwala Petulo na Yohana na Yakobo nkuhwena navo muha lichinga lilehu pachinu pakávele vanu. Aneko Yesu nkubadilika muyo mwavo, ");
INSERT INTO kde_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","dinguwo dyake nkung'anyima, nkuva dyanahe mbee namuna yakahulula munu kudichapa nkuva dyanahe malinga dinguwo anedyo. ");
INSERT INTO kde_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Bahi nabii Eliya na Musa nkuhumila muyo mwavo nkuva uvalonjela na Yesu. ");
INSERT INTO kde_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petulo nkunnyaulila Yesu kuchidoni, “Nkúhunda, nni chinu chambone hwetu kupwawa apano, bahi tudenge migongwe mitatu, umo wako na umo wanga Musa na unji wanga Eliya.” ");
INSERT INTO kde_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petulo akanamaite lya kutangola, kwa kuva, nang'e na avake vániyopa namene. ");
INSERT INTO kde_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Anepo nkuhumila lihunde nkuvahinika na lidi nkupilikanika kuhaloka nnihunde alila ulichidoni, “Ayuno njo Mwanangu unguntamwa, mpilikanile nang'e.” ");
INSERT INTO kde_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Upala, pavang'anyang'anyije nnyenje nanga pavanammwene munu woheyo pamo na vanang'o ila Yesu weka. ");
INSERT INTO kde_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Pavachisulupuka nnichinga, Yesu nkuvalimbija vanannyaulile munu woheyo vitukutuku vivaviwene, mpaka Mwana wa Munu pambefufuka kuhaloka kwa vanu vahwîle. ");
INSERT INTO kde_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Vakuhundwa nkutenda muchi chavahaulidile, henga nkuva uvaujana mana la kufufuka kuhaloka kwa vanu vahwîle. ");
INSERT INTO kde_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Vakuhundwa nkummuja Yesu kuchidoni, “Mwadachi vakúhunda Sheliya yanga Musa vàhaula kuva nabii Eliya lasima alongolele kwida kavila hoti?” ");
INSERT INTO kde_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu nkuvayang'ula kuchidoni, “Elo, Eliya àmbekwida hoti unakatapaja lammalele. Henga pamo na anelo, mwadachi Mmalemba Lanaswe ìnilembwa kuva, Mwana wa Munu àlembelewa alagihwe na kuhitwa na vanu? ");
INSERT INTO kde_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Henga nangu nìnnyaulilanga kuva, Eliya tayali àniida kavila, vanang'o nkuntendela kila chivalembedile muchi chiilembwije Mmalemba Lanaswe kumwamba nang'e.” ");
INSERT INTO kde_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Pavakamwele pachinu pávanavele vakuhundwa vanji, nkulyona likuwa likulu lya vanu vavadingwìkè. Na vakúhunda va Sheliya yanga Musa uvatahukana na avala vakuhundwa. ");
INSERT INTO kde_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Upala likuwa lya vanu pavammwene Yesu, vammalele nkukangana namene, nkuntukutila, nkunammuja habali. ");
INSERT INTO kde_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu nkuvauja vakuhundwa vake kuchidoni, “Mùtahukana navo chamani?” ");
INSERT INTO kde_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Munu yumo nnikuwa alila lya vanu nkunnyang'ula kuchidoni, “Nkúhunda, nangu nìkupelekejije mwanangu avêle na nanndenga antendîle ààve bubu. ");
INSERT INTO kde_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kila pam'bebeluha àmmatoha pahi na kuntenda ahume chihulu nkanya na kulitang'unanya meno, na mmili nkuyuma chihi chwa. Ńnivayuwa vakuhundwa vako vammuse aneyo nanndenga, henga nanga pavahulwile.” ");
INSERT INTO kde_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu nkuvayang'ula kuchidoni, “Mwenu mmanu mma chívelèkwà chikákulupila! Dachi, nìmbeikala na mwenu mpaka chakani? Na nìmbempililila mpaka chakani? Idanawe apano.” ");
INSERT INTO kde_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bahi nkumpelekejija. Upala ayula nanndenga pammwene Yesu, nkuntaya chihundahunda ayula nnemba na nkummatoha pahi, nkuyalata pahi na kuhuma chihulu nkanya. ");
INSERT INTO kde_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu nkummuja atatake ayula nnemba nkuchidoni, “Mambo alano lànkojije chakani?” Nang'e nkunnyang'ula kuchidoni, “Kutandikila ujoko wake. ");
INSERT INTO kde_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Na myanda yohe àmmatohija mmoto na mmedi, walambela ammwalale. Henga ukàhulula kutenda chinu, tùnakuyuwa utuvikile chididi na kutuyangata!” ");
INSERT INTO kde_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu nkunnyang'ula kuchidoni, “Mwadachi ùhaula kuva ukàhulula? Lammalele lànahululika kwa munu akulupîla.” ");
INSERT INTO kde_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Upala atatake mwana nkunonoha lidi nkuchidoni, “Nangu nakulupila! Henga nguyangate ngukulupile namene.” ");
INSERT INTO kde_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu paliwene likuwa lya vanu ulihalija kuyenjejeka muyo mwake, nkunkalipila ayula nanndenga, nkunnyaulila kuchidoni, “Wako nanndenga bubu na mmwidi, nìkuhaulila, mmuke mwana ayuno na unamwende kavila!” ");
INSERT INTO kde_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Anepo aneyo nanndenga nkukuta ding'uto, nkuntaya chihundahunda ayula mwana, nkummuka. Ayula mwana nkwonekana muchi ànihwa, vanu vohe nkuhaula kuva, “Ànihwa!” ");
INSERT INTO kde_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Henga Yesu nkunkamula ayula mwana nkono nkuntakatuha, mwana nkuimila. ");
INSERT INTO kde_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu painjidile nng'ande, vakuhundwa vake nkummuja pachinu paweka kuchidoni, “Ing'anya ntwani hwetu nanga patuhulwile kummusa ayula nanndenga?” ");
INSERT INTO kde_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu nkuvahaulila kuchidoni, “Nanndenga wa namuna ai nanga pahululika kuuka, ikànave chihi kwa kuyuwa.” ");
INSERT INTO kde_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Bahi Yesu na vakuhundwa vake nkuuka anepo, nkupitila chilambo cha ku Galilaya. Yesu nanga panalembedile vanu vamale pávèlè, ");
INSERT INTO kde_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ing'anya ávahunda vakuhundwa vake. Nkuvahaulila kuchidoni, “Mwana wa Munu àvele pepi uhwena unakamujwa mmakono la vanu, vanang'o vàmbemmwalala, na liduva lya tatu lya kuhwa kwake àmbefufuka.” ");
INSERT INTO kde_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Vakuhundwa vake nanga pavanamaite mana la mahundo anelo. Henga vanang'o nkuyopa kummuja. ");
INSERT INTO kde_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Pavakamwele Kapelinaumu, nkwenda nng'ande, Yesu nkuvauja vakuhundwa vake kuchidoni, “Mùtahukana ya chani nndila?” ");
INSERT INTO kde_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Henga vanang'o nkunyalalanga chihi, ing'anya pávanavele nndila vátahukana ya ukulu, kuva nnikuwa lyavo nkulu alida. ");
INSERT INTO kde_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu nkuikala pahi, nkuvachema avala kumi na mbili, nkuvahaulila kuchidoni, “Munu woheyo alembêla kuva nkulu, àlembelewa alisulupuhe kuvapunda vammalele na ààve ntumishi wa vammalele.” ");
INSERT INTO kde_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Anepo Yesu nkùntwala mwana n'joko, nkumwimija paching'ati pavo nkunkumbatila, nkuvahaulila kuchidoni, ");
INSERT INTO kde_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Munu woheyo ampwechelêla mwana malinga ayu ing'anya yang'une, àngupwechelela nangu. Na munu angupwechelêla nangu, akángupwechelela chihi nangu, henga àmpwechelela na ayula angutumîle.” ");
INSERT INTO kde_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohana nkunnyaulila Yesu kuchidoni, “Nkúhunda, tummwene munu wavausa anamindenga kwa lina lyako, hwetu tùninnimbija kwa kuva akávele wa nnikuwa lyetu.” ");
INSERT INTO kde_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Henga Yesu nkuvahaulila kuchidoni, “Munannimbije, kwa kuva nanga munu ahulûla kutenda vitukutuku vya masaibu kwa lina lyangu, upopo nkungutongolela malove lahakalenge. ");
INSERT INTO kde_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kwa kuva munu akátahukana na hwetu, aneyo àvele m'bali wetu. ");
INSERT INTO kde_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nangu nìnnyaulilanga uhiu kuva, munu woheyo ambemwîng'a mwenu mwawo wa medi, ing'anya ya kuva mmanganya nni mmanu vake Kilisto, munu aneyo àmbepata dinujo dyake.” ");
INSERT INTO kde_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Henga munu woheyo ambentênda yumo wa avano vajoko vangukulupîla nangu atende sambi, ikàvele wasa munu aneyo ahungiwe liyanga likulungwa lya kuhayila muukoti wake na kuyahwa m'bahali. ");
INSERT INTO kde_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ikàva nkono wako ùkutenda utende sambi, uchekete! Wasa kuinjila muumi akuno ukavèlè na nkono umo, kuliko kuinjila Jihannamu, mmoto ukádimika akuno uvèlè na makono mavili.  ");
INSERT INTO kde_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Anemwo ahong'o vake nanga pavahwa, na moto wake nanga paudimika. ");
INSERT INTO kde_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ikàva ludodo lwako lùkutenda utende sambi, luchakete! Wasa kuinjila muumi akuno ukavèlè na ludodo lumo, kuliko kuva na madodo mavili na kuyahwa Jihannamu.  ");
INSERT INTO kde_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Anemwo ahong'o vake nanga pavahwa, na moto wake nanga paudimika. ");
INSERT INTO kde_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ikàva liso lyako lìnakukuvaja kutenda masambi, bahi lidabole! Wasa uinjile mu Ufalume wanga Nnungu akuno uvèlè na liso limo, kuliko kuva na meho mavili na kuyahwa Jihannamu. ");
INSERT INTO kde_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Anemwo ahong'o vake nanga pavahwa, na moto wake nanga paudimika. ");
INSERT INTO kde_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kwa kuva, kila munu àmbetaywa munyu kwa moto. ");
INSERT INTO kde_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Munyu nni chinu chambone. Henga inowi yake ikàhang'uka, dachi, ùmbetaywa chamani uchinga inowi yake iuyile kavila? Bahi mùùve na munyu nkati mwenu na kila munu aikale na nnyake kwa amani.” ");
INSERT INTO kde_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu nkuuka anepo, nkuyamboka muto wa Yoludani, nkuhwena chilambo cha Yudeya. Likuwa lya vanu nkummwenela kavila, nang'e nkuvahunda muchi chiunavele nnyambo wake. ");
INSERT INTO kde_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bahi Mafalisayo vanji nkummwenela Yesu, nkummuja kwa kunninga uvachidoni, “Dachi, Sheliya ya Musa ìnaluhusu nnume unneka n'jawe?” ");
INSERT INTO kde_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu nkuvayang'ula kuchidoni, “Dachi, Musa ánnaijije chamani?” ");
INSERT INTO kde_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Vanang'o nkuhaula kuchidoni, “Musa ániluhusu nnume umwing'a n'jawe talaka na kunneka.” ");
INSERT INTO kde_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu nkuvahaulila kuchidoni, “Musa ánilemba amuli aneyo ing'anya ya kukamajanga kwa mitima yenu. ");
INSERT INTO kde_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Henga Nnungu pachiumbile chilambo, Nnungu ámmumbile munu nnume na mmahe. ");
INSERT INTO kde_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Bahi ing'anya ya anelyo, nnume àmbenneka atatake na anyokwe, koka alundane na n'jawe, ");
INSERT INTO kde_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","na anevo vavili vàmbekuva mmili umo. Bahi anevo akee vavili kavila, henga nni mmili umo. ");
INSERT INTO kde_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Bahi vavalundanyîje Nnungu, munu anavahapulanye.” ");
INSERT INTO kde_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pavainjidile kavila nng'ande, vakuhundwa vake nkummuja kuyamba alila lilove. ");
INSERT INTO kde_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesu nkuvahaulila kuchidoni, “Munu woheyo annêka n'jawe, nkunannomba mmahe yunji, aneyo àlalá ugoni. ");
INSERT INTO kde_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Uchocho, mmahe annêka nng'andomwe nkulombwa na nnume yunji, aneyo àlalá ugoni.” ");
INSERT INTO kde_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Vanu nkumpelekejija Yesu vavana vajoko uchinga avabaliki kwa kuvavikila makono, henga vakuhundwa vake nkuvakalipila avala vanu. ");
INSERT INTO kde_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu pawene uchocho nkusunala, nkuvahaulila kuchidoni, “Valekange vavana vajoko vaide kwang'une, wala munavadivile, kwa kuva, Ufalume wa Nnungu nni wa vanu vavêle muchi vavana ava. ");
INSERT INTO kde_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nangu nìnnyaulilanga uhiu kuva, munu woheyo akáupwechela Ufalume wa Nnungu malinga mwana n'joko, nanga pambeinjila anemwo.” ");
INSERT INTO kde_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Anepo nkuvakumbatila avala vavana, nkuvavikila makono na kuvabaliki. ");
INSERT INTO kde_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu pánavele wauka, munu yumo nkuntukutila nkutindivala malundi, nkummuja kuchidoni, “Nkúhunda wambone, ngùtende dachi uchinga niupate umi ukee na ntululilo?” ");
INSERT INTO kde_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu nkunnyang'ula kuchidoni, “Ing'anya ntwani ùnguchema wambone? Nanga munu wambone ila Nnungu weka. ");
INSERT INTO kde_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ùnidimala diamuli dya Nnungu dihaûla, ‘Unalale ugoni na unaive na unawalale na unahumye ushahidi wa kulambila na unatindinganyange na mweshimu atatako na anyoko.’ ” ");
INSERT INTO kde_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Munu aneyo nkunnyang'ula Yesu kuchidoni, “Nkúhunda, anelo lammalele ǹnilakamula kutandilikila ujoko wangu.” ");
INSERT INTO kde_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu nkunnola, nkuntamwa, nkunnyaulila kuchidoni, “Wako ùisaliwije na chinu chimo chukanambitenda. Hwena ukasumise vyammalele vyuvenavyo, koka dihela uveng'e amahuvani, anepo uchiuve na dimali kulihunde. Ukàmalila kutenda uchocho koka uide ungupapate.” ");
INSERT INTO kde_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ayula munu papilikene anelo nkukunyata kumeho, nkuuka akuno apoywèkè, ing'anya ávele na dimali dyohe namene. ");
INSERT INTO kde_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu nkulola mipata yammalele, nkuvahaulila vakuhundwa vake kuchidoni, “Ìnikamajanga namene vakúpata kuinjila mu Ufalume wanga Nnungu!” ");
INSERT INTO kde_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Vakuhundwa vake nkukangana malove lake. Yesu nkuvahaulila kavila kuchidoni, “Anavangu, ìnikamajanga namene kuinjila mu Ufalume wanga Nnungu! ");
INSERT INTO kde_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ìnipeyapeya namene nnyama uvanchema ungamila kupita nchitonono cha chitotelo, kuliko nkúpata uinjila mu Ufalume wanga Nnungu.” ");
INSERT INTO kde_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Vakuhundwa vake nkukangana namene, nkuujana, uvachidoni, “Nnani bahi ambehulûla kupohwa?” ");
INSERT INTO kde_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu nkuvalola nkuvahaulila kuchidoni, “Kwa dimongo dya chimunu ikáhululika, henga kwanga Nnungu ikávele uchocho, kwa kuva, Nnungu ànahulula kulatenda lammalele.” ");
INSERT INTO kde_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petulo nkunnyaulila Yesu kuchidoni, “Lola, hwetu tùlekile vitukutuku vyammalele nkukupapata wako!” ");
INSERT INTO kde_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu nkuhaula kuchidoni, “Nangu nìnnyaulilanga uhiu kuva, mmaisha alano la vino munu ailekîle kaya au anung'unuvake au alumbuvake au anyokwe au atata au vavana au mawelu ing'anya yang'une na Malove Lambone, ");
INSERT INTO kde_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","munu aneyo àmbepunda kupata anelo lammalele myanda myamoja kupunda patandi chalumo na kubanihwa. Na mmahiku laîda àmbepata umi ukee na ntululilo. ");
INSERT INTO kde_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Henga vanu vohe vaonekâna hambi kuva vakulu, vàmbekuva va pahi, na vanu vohe vaonekâna hambi kuva va pahi, vàmbekuva vakulu.” ");
INSERT INTO kde_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu na vakuhundwa vake pávanavele nndila uvayomboka kuhwena ku Yelusalemu nang'e ánivalongolela. Vakuhundwa nkukangana na vanu vachivapapata nkuyopa. Yesu nkuvatwala kavila avala vakuhundwa kumi na mbili panyenje nkutandilika kuvahaulila habali dya mambo lámbenkòjà. ");
INSERT INTO kde_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Nkuvahaulila kuchidoni, “Pilikananga! Tùvenkuyomboka kuhwena ku Yelusalemu, aneko Mwana wa Munu, àmbekamujwa mmakono la makuhani vakulu na vakúhunda Sheliya ya Musa. Vanang'o vàmbennyukumu kuhwa na kukamujwa mmakono la vanu vakávele Vayahudi. ");
INSERT INTO kde_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Na vanang'o vàmbentendela mang'wanyu na kunsunila mata na kunsulubula na kummwalala. Henga liduva lya tatu lya kuhwa kwake àmbefufuka.” ");
INSERT INTO kde_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Anepo Yakobo na Yohana vana vanga Sebedayo, nkummwenela Yesu nkunnyaulila kuchidoni, “Nkúhunda, tùlembela ututendele chinu chitumbekuyuwa.” ");
INSERT INTO kde_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu nkuvauja kuchidoni, “Mùlembela nintendelange chamani?” ");
INSERT INTO kde_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nkunnyang'ula kuchidoni, “Paumbeikala nchiteng'u chako cha Ufalume muukulu wako, tuyuwa utuluhusu tuikale pamo na wako, yumo m'bali wa kunkono na yunji m'bali wa kunchinda.” ");
INSERT INTO kde_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu nkuvahaulila kuchidoni, “Mwenu mukámaite chinu chimuyuwa! Dachi, muchimuhulule kupililila ibaniki inimbebanika nangu? Au kubatiswa ubatiso wa ibaniki muchi unimbebatiswa nangu?” ");
INSERT INTO kde_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Vanang'o nkunnyang'ula kuchidoni, “Elo, tùnahulula.” Yesu nkuvahaulila kuchidoni, “Ibaniki inimbebanika nangu, lasima mupitile, na muchimubatiswe muchi chinimbebatiswa nangu. ");
INSERT INTO kde_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Henga kwa habali ya kuikala m'bali wangu wa kunkono au wa kunchinda anelo lakee madengo langu. Ila nafasi anedyo vàmbeikala vanu avala vávatandwèlè Atatangu.” ");
INSERT INTO kde_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Vakuhundwa vanji kumi pavapilikene anelo, nkutandilika uvasunalila Yakobo na Yohana. ");
INSERT INTO kde_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu nkuvachema vakuhundwa vake, nkuvahaulila kuchidoni, “Mwenu mùnimala kuva avala vavalangîwa kuva vakulu va vanu vakávele Vayahudi, vàvatawala vanu vao kwa dimongo na kuvatumikisa. ");
INSERT INTO kde_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Henga kwenu mwenu inave uchocho. Alembêla kuva nkulu mmwenu, àlembelewa ààve ntumishi wenu. ");
INSERT INTO kde_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Na munu woheyo mmwenu alembêla ààve ntandi, àlembelewa ààve ntumwa wa vammalele. ");
INSERT INTO kde_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kwa kuva, Mwana wa Munu akáidile unatumikiwa, henga àidile unatumikila na kuuhumya umi wake uchinga ùùve fidiya ya kukombolewa kwa vanu vohe.” ");
INSERT INTO kde_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesu na vakuhundwa vake nkuhwika kuimanga ya Yeliko. Pavachiuka muimanga aneyo pamo na likuwa likulu lya vanu, munu yumo aputêle meho uvanchema Batolomayo mwana wanga Timayo áikele nnyenje indila wayuwa. ");
INSERT INTO kde_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Papilikene kuva Yesu wa ku Nasaleti àpita pachinu anepo nkutandilika kunonoha lidi wachidoni, “Yesu n'dukuluwe Nfalume Daudi, nguvikile chididi!” ");
INSERT INTO kde_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Vanu vohe nkunkalipila uchinga anyalale, henga nang'e nkuhalija chihi kunonoha lidi wachidoni, “N'dukuluwe Nfalume Daudi, nguvikile chididi!” ");
INSERT INTO kde_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu nkuimila, nkuhaula kuchidoni, “Ncheme.” Bahi nkunchema ayula munu aputêle meho, nkunnyaulila kuchidoni, “Likamye ntima! Imila, anakuchema.” ");
INSERT INTO kde_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Batolomayo nkuyaha likoti lyake, nkuuluka, nkummwenela Yesu. ");
INSERT INTO kde_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu nkummuja kuchidoni, “Ùlembela nikutendele chamani?” Ayula munu aputêle meho nkunnyaulila kuchidoni, “Nkúhunda, ngùlembela ngupate kulola.” ");
INSERT INTO kde_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu nkunyaulila kuchidoni, “Hwena, ing'ulupa yako ìnikulamya.” Upala ayula munu aputêle meho, nkuhulula kulola, nkumpapata Yesu nndila. ");
INSERT INTO kde_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesu na vakuhundwa vake pávanavele pepi na ku Yelusalemu, nkuva vavèlè pepi na chijiji cha Betifage na Besaniya, pepi na Lichinga lya Miseituni. Anepo Yesu nkuvatuma vakuhundwa vake vavili, ");
INSERT INTO kde_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","nkuvahaulila kuchidoni, “Hwena chijiji chivêle muyo mwenu. Pamumbekuva umuinjila nchijiji anecho, munankoja mwana wa punda vampambilidìlè, akánambiikalwa na munu. Nnyungulange muide nawe apano. ");
INSERT INTO kde_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Na munu akàmmuja kuva, ‘Mwadachi mùtenda uchocho?’ Nnyaulile kuva, ‘Nang'olo ànannembela na achiannudise upano lukoto.’ ” ");
INSERT INTO kde_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bahi nkuhwena, nkunkoja mwana wanga punda vannyungìlè nnyenje indila pepi na pannango. Pavachinnyungula, ");
INSERT INTO kde_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","vanu vanji vanaimidîle upopo nkuvauja kuchidoni, “Ing'anya ntwani mùnnyungula aneyo mwana wanga punda?” ");
INSERT INTO kde_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Vakuhundwa nkuvayang'ula muchi chanavahaulidile Yesu na vanang'o nkuvaleka vakuhundwa vahwene nawe. ");
INSERT INTO kde_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nkumpelekejija Yesu aneyo mwana wanga punda. Nkulaja dinguwo dyavo muha mwa ayula mwana wanga punda na Yesu nkuikala muha mwake. ");
INSERT INTO kde_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Vanu vohe nkulaja dinguwo dyavo nndila, na vanji dinavi dya milandi divanalumwile mmawelu. ");
INSERT INTO kde_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Vanu vanalongoledile na avala váchipapàtà nnyuma, nkuva uvanonoha malidi uvachidoni, “Atumbyangwe Nnungu! Ubalikiwe wako uîda kwa lina lya Nang'olo! ");
INSERT INTO kde_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ubalikiwe ufalume uîda wanga anakulwetu Daudi. Atumbyangwe Nnungu avêle muha kulihunde!” ");
INSERT INTO kde_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu nkuinjila muimanga ya Yelusalemu nkuhwena ku Ing'ande yanga Nnungu, nkulola saana kila chinu. Henga kwa kuva liduva lìvenkuswa, nkuuya kavila ku Besaniya chalumo na avala vakuhundwa vake kumi na mbili. ");
INSERT INTO kde_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ulyamba wake, pávanavele nkuuka ku Besaniya, Yesu nkuva na indala. ");
INSERT INTO kde_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nkuwona nnandi wa ntini kulehu kadiki ùvele na mahamba lohe. Nkuhwena unaulola panjika ùvele na chihepo chohecho. Pahwikile pepi, nkuukoja uvèlè chihi nanga chihepo, úumbele chihi mahamba weka, kwa kuva lakánavele mahiku la kupa vihepo vya tini. ");
INSERT INTO kde_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Bahi Yesu nkuuhaulila nnandi kuchidoni, “Kutandikila nelo na maduva lammalele munu anapate chihepo kuhaloka kwakuwe.” Na vakuhundwa vake vánipilikana àlalá malove latangwele. ");
INSERT INTO kde_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pavakamwele pa Yelusalemu, Yesu nkuinjila nnuwani lwa Ing'ande yanga Nnungu, nkutandilika kuvavingangila pawelu vanu vammalele váchisumìsà na kusuma vitukutuku, anemwo. Nkudibinula dimeza dya vanu váchibadìlì dihela, na viteng'u vya vanu váchisumìsà amunda. ");
INSERT INTO kde_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Uchocho, ánivalimbija vanu vanainjije wala kuhumya vitukutuku nnuwani lwa Ing'ande ya Nnungu. ");
INSERT INTO kde_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Bahi nkuvahunda wachidoni, “Ìnilembwa Mmalemba Lanaswe kuva, ‘Ing'ande yangu ìmbechemwa ing'ande ya kunnyuwila Nnungu ya vanu vammalele va pachilambo!’ Henga mwenu mùniipindikulanya nkuijuha kuva muchi lipanga lya kulipiha vakúpalaula!” ");
INSERT INTO kde_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Makuhani vakulungwa na vakúhunda Sheliya ya Musa pavapilikene anelo, nkutandilika kutaha indila ya kummwalala Yesu. Henga váninnyopa kwa kuva likuwa lyammalele lya vanu vánikanganwa na mahundo lake. ");
INSERT INTO kde_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pachikamwele chinalyulo, Yesu pamo na vakuhundwa vake nkuuka paimanga aneyo. ");
INSERT INTO kde_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ulyamba na mambumbu, pávanavele nkuhwena, nkuwona ntini wammalele uyumìlè, kutandikila kulikolo. ");
INSERT INTO kde_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petulo nkuukumbukila, nkunnyaulila Yesu kuchidoni, “Nkúhunda, lola aula ntini uulanîte ùniyuma!” ");
INSERT INTO kde_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu nkuvahaulila vakuhundwa vake kuchidoni, “Nkulupilange Nnungu. ");
INSERT INTO kde_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nangu nìnnyaulilanga uhiu kuva, munu akàlihaulila lichinga alino, ‘Uka apano ukaliyahe m'bahali,’ na ikàva àtangola malove anelo bila kuva na lipamba muntima mwake, na nkùkulupila kuva lammalele látangwèlè lachilatendeke, muhiu lachilatendeke. ");
INSERT INTO kde_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Bahi ing'anya ya anelo, nangu nìnnyaulilanga kuva, pamuyuwa kwajili ya chinu fulani chimulembela, kulupilanga kuva mùnipwechela, na kwa kutenda uchocho bahi lachilatendeke muchi chimuyuwite. ");
INSERT INTO kde_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Na mwenu pamunnyuwa Nnungu, ikàva mùvele na lituku na munu fulani, bahi nsamehe uchinga Atata wenu avêle kulihunde ansamehe na mwenu makosa lenu. ");
INSERT INTO kde_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Henga mwenu mukanavasamehe vanu vanji, uchocho na Atata wenu avêle kulihunde akambensamehe mwenu makosa lenu.” ");
INSERT INTO kde_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu pamo na vakuhundwa vake nkukamola kavila ku Yelusalemu. Bahi Yesu pánavele nkwonga nnuwani lwa Ing'ande ya Nnungu, makuhani vakulungwa na vakúhunda Sheliya ya Musa na vasele va Vayahudi, nkummwenela. ");
INSERT INTO kde_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Nkummuja kuchidoni, “Ùlatenda alano kwa mamulaka ntwani? Na nnani akupêle mamulaka la kulatenda?” ");
INSERT INTO kde_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Henga Yesu nkuvahaulila kuchidoni, “Nanani uchocho nìmbemmujanga chinu chimo. Mukànguyang'ula nguchininnyaulile, ngùlatenda alano kwa mamulaka ntwani. ");
INSERT INTO kde_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Dachi, mamulaka langa Yohana Nkúbatisa la kubatisa láhaleke kulihunde au kwa vanu? Nguhaulile.” ");
INSERT INTO kde_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Vanang'o nkutandilika kuujana vene kwa vene uvachidoni, “Tukàhaula kuva, làhaleke kulihunde, àmbetuuja kuva, ‘Hambi, mwadachi mukánankulupidile?’ ");
INSERT INTO kde_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Na tukáhulula kuhaula kuva làhaleke kwa vanu.” Vátangwele uchocho kwa kuliyopa likuwa lya vanu, kwa kuva, vanu vammalele vánakulupila kuva Yohana Nkúbatisa ni nabii wa Nnungu. ");
INSERT INTO kde_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Bahi nkunnyang'ula Yesu kuchidoni, “Hwetu nanga patumaite.” Na Yesu nkuvahaulila kuchidoni, “Nanani uchocho nikambennyaulila kuva ngùlatenda alano kwa mamulaka ntwani.” ");
INSERT INTO kde_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu nkutandilika kutangola navo kwa mifano, “Munu yumo álimile welu wa mizabibu. Nkuudinguhija lingongo, na ching'ati welu nkuhimba lipondo lya kuminyila zabibu, nkudenga nnala wa kuikala valinzi va welu. Nkuukodisa kwa vakúlima, nkuhwena mwanda wa kulehu. ");
INSERT INTO kde_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Paukamwele nchela wa zabibu, nkuntuma ntumishi wake yumo kwa avala vakúlima, uchinga akatwale sehemu ya vihepo vya mmwelu wake. ");
INSERT INTO kde_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Avala vakúlima nkunkamula, nkumpanya, nkumminganga chihi makono weka. ");
INSERT INTO kde_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Bahi mwene welu nkuntuma kavila ntumishi yunji, aneyo nkumpanya mmuti na kuntendela vya kuhakalanga. ");
INSERT INTO kde_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mwene welu nkuntuma ntumishi yunji kavila, aneyo nanang'e nkummwalala. Nkuvatuma vatumishi vanji vohe, vanji vánivapanya na vanji nkuvawalala. ");
INSERT INTO kde_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Mwene welu nkuisaliwa chihi na munu yumo wakuntuma, na aneyo ávele mwanawe, wantamwa. Kuntululilo nkuntuma aneyo wachidoni, ‘Ǹnimala kuva mwanangu vachivamweshimu.’ ");
INSERT INTO kde_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Henga avala vakúlima nkuhaulanila kuchidoni, ‘Ayu njo mwene mapala la welu auno. Bahi leka tummwalale koka auno welu ùùve mapala letu!’ ");
INSERT INTO kde_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Bahi nkunkamula, nkummwalala, nkunnyaha pawelu aula welu wa mizabibu.” ");
INSERT INTO kde_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Bahi Yesu nkuuja kuchidoni, “Dachi, mwene welu pambeida àmbevatenda dachi avala vakúlima? Àmbeida koka avawalale anevo vakúlima na anewo welu avakodise vanu vanji. ");
INSERT INTO kde_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Dachi, mukásomile Malemba alano? ‘Liyanga lihitwîje na vakúdenga, hambi lìjukile kuva liyanga likulu lya paindumba, lya muhimu kupunda lammalele. ");
INSERT INTO kde_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Na Nang'olo njo atendîle chinu anecho, na ìyonekana kuva lisaibu pameho petu.’ ” ");
INSERT INTO kde_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Makuhani vakulu, na vakúhunda Sheliya yanga Musa na vasele vánimala kuva anewo nfano ùvamba vanang'o. Nkulembela unkamula, henga nkuyopa likuwa lya vanu. Nkunneka, nkuukananga. ");
INSERT INTO kde_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Bahi Mafalisayo fulani na vanu vanji va nnikuwa lya Helode nkutumwa kwanga Yesu uchinga vakanteye kwa malove lake. ");
INSERT INTO kde_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nkummwenela, nkunnyaulila kuchidoni, “Nkúhunda, tùnimala kuva wako nni munu wa uhiu, na wala nanga pauyopa ukulu wanga munu, kwa kuva, nanga paulola kumeho kwanga munu, henga ùhunda chihi kwa uhiu kuyamba indila yanga Nnungu. Tuhaulile, dachi, Sheliya ya Musa ìnatuluhusu uhumya kodi kwa Nfalume wa Loma au ikátuluhusu?” ");
INSERT INTO kde_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Henga Yesu ániumala ulamba wavo, nkuvahaulila kuchidoni, “Mwadachi munangulinga? Idanayo hela niilole.” ");
INSERT INTO kde_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nkumpelekejija hela. Yesu nkuvauja kuchidoni, “Dachi, ing'ope aino na lina alino lilembwîje apano lyanga nnani?” Nkunnyang'ula kuchidoni, “Vya Nfalume wa Loma.” ");
INSERT INTO kde_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Bahi Yesu nkuvahaulila kuchidoni, “Bahi la Nfalume wa Loma mwing'e Nfalume wa Loma na la Nnungu mwing'e Nnungu.” Vanang'o nkunkangana namene. ");
INSERT INTO kde_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Bahi Masadukayo, vanu vahaûla kuva nanga ufufulo wa vanu vahwîle, nkummwenela Yesu, nkummuja kuchidoni, ");
INSERT INTO kde_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Nkúhunda, Musa átulaijije uvila, ‘Nnume akàhila nkunneka n'jawe bila kummelekela mwana, nnung'une wake àlembelewa annombe aneyo mmahe wannekile nkuluwe, uchinga ammelekele nkuluwe vavana.’ ");
INSERT INTO kde_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Bahi pávele na vana saba va chilume va litumbo limo, ntandi nkunnomba mmahe, henga nkuhila chihi bila kummelekela mwana. ");
INSERT INTO kde_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Na mwana wavili nkwenda makande kwanga ayula mmahe wannekile nkuluwe, nanang'e nkuhila bila kummelekela mwana. Na mwana watatu nanang'e nkuva uchocho. ");
INSERT INTO kde_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Vammalele saba vanannombile nkuhila bila kummelekela mwana ayula mmahe. Kuntululilo ayula mmahe nanang'e nkuhila. ");
INSERT INTO kde_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Dachi, liduva livambefufuliwa vanu vahwîle ayula nkongwe àmbekuva wanga nnani? Kwa kuva, vammalele saba vániikalana nawe.” ");
INSERT INTO kde_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu nkuvahaulila kuchidoni, “Mwenu mùnakumbika ing'anya nanga pamulamaite Malemba Lanaswe wala dimongo dyanga Nnungu. ");
INSERT INTO kde_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kwa kuva, vanu vahwîle pavambefufuka, nanga pavambelomba wala kulombwa, ila vàmbekuva muchi malaika va kulihunde. ");
INSERT INTO kde_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na kwa habali ya kufufulwa kwa vanu vahwîle, dachi mukásomile nchitabu cha Sheliya yanga Musa, àlalá malemba latâna kuyamba chihole chichiyaka moto? Nnungu ánnyaulidile Musa kuva, ‘Nangu njo Nnungu wanga Iblahimu, Nnungu wanga Isaka na Nnungu wanga Yakobo.’ ");
INSERT INTO kde_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nang'e akávele Nnungu wa vanu vahwîle, henga nang'e nni Nnungu wa vanu vumi. Mwenu mùnikosela namene.” ");
INSERT INTO kde_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nkukamola munu yumo nkúhunda Sheliya yanga Musa, nkupilikana chivayang'ulana Yesu na Masadukayo. Ayula munu ánimala kuva Yesu àvayang'wile saana, nkuhumila, nkummuja kuchidoni, “N'diamuli dyammalele, ing'ulu ilida?” ");
INSERT INTO kde_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu nkunnyang'ula kuchidoni, “Amuli ing'ulu nni aino, ‘Pilikana wako chilambo cha Isilaeli! Nang'olo Nnungu wetu njo Nang'olo weka. ");
INSERT INTO kde_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ntamwe Nang'olo Nnungu wako kwa ntima wako wammalele na kwa isungu yako yammalele na kwa ding'ano dyako dyammalele na dimongo dyako dyammalele.’ ");
INSERT INTO kde_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na amuli yavili nni aino, ‘Ntamwe nnyako malinga chiulitamwa umwene.’ Nanga amuli inji ing'ulu namene kupunda adino.” ");
INSERT INTO kde_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Bahi ayula nkúhunda wa Sheliya yanga Musa nkunnyaulila Yesu kuchidoni, “Elo, Nkúhunda! Ùtangwele muhiu kuva Nnungu nni yumo bahi, wala nanga yunji ila nang'e weka. ");
INSERT INTO kde_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kuntamwa Nnungu kwa ntima wako wammalele na kwa ding'ano dyako dyammalele na kwa dimongo dyako dyammalele na kuntamwa nnyako malinga chiulitamwa umwene, kùnafala namene kupunda kunhumija Nnungu sadaka dya kupija inyama na sadaka dinji dyammalele.” ");
INSERT INTO kde_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu pawene kuva àyang'wile saana, nkunnyaulila kuchidoni, “Wako ukávele kulehu na Ufalume wanga Nnungu.” Na kutandikila anepo nanga munu yunji analingile kummuja kavila chinu chinji. ");
INSERT INTO kde_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu pachihunda nnuwani lwa Ing'ande yanga Nnungu nkuuja kuchidoni, “Mwadachi vakúhunda Sheliya yanga Musa vàhaula kuva Kilisto nni N'dukuluwe Nfalume Daudi? ");
INSERT INTO kde_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Umumu Wanaswe ánimwongosa Daudi kutangola kuchidoni, ‘Nang'olo ánnyaulidile Nang'olo wangu, Ikala m'bali wangu wa kunkono, mpaka panimbevavika amongo vako pahi makumbatu lako.’ ");
INSERT INTO kde_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Nfalume Daudi mwene ànchema Kilisto, ‘Nang'olo.’ Hambi ìmbehululika dachi Kilisto ààve n'dukuluwe?” Na likuwa lya vanu vámpilikanila Yesu kwa kuhangalala. ");
INSERT INTO kde_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu panavenkuhunda, nkuhaula kuchidoni, “Lyongolelange na vakúhunda Sheliya yanga Musa, vanang'o vànatamwa namene kwonga akuno vawètè dinguwo dindehu na kusalimiwa kwa eshima kusakoni, ");
INSERT INTO kde_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","na kuikalanga nafasi dya kweshimika n'ding'ande dya kunnyuwila Nnungu na mmiteng'u vya muyo n'ding'ole. ");
INSERT INTO kde_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Vàvapakanyola dimali dyavo anannidi na kulitenda kuva vambone kwa kuyuwa namene! Bahi ing'anya ya anelyo, liduva lya hukumu vàmbepata asabu ing'ulu namene kupunda vanu vanji.” ");
INSERT INTO kde_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu áikele pepi na lisanduku lya sadaka. Nkuvona vanu vohe uvahumya dihela na kuditaya nnisanduku lya kutaya sadaka. Na akúpata vohe váhumije dihela dyohe. ");
INSERT INTO kde_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Bahi nkwida mmahe yumo nannidi, mmahuvani, nkuhumya disendi dimbili. ");
INSERT INTO kde_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Apala Yesu nkuvachema vakuhundwa vake nkuvahaulila kuchidoni, “Nangu nìnnyaulilanga uhiu kuva, nannidi ayuno mmahuvani àhumije sadaka ing'ulu namene kupunda vanu vammalele vatâya dihela nnisanduku lya sadaka. ");
INSERT INTO kde_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kwa kuva, vanu vanji vammalele vàhumije chihi avila viyenjejêke n'dimali dyavo, henga ayu mmahe pamo na umahuvani wake, àhumije vyammalele vyavenavyo.” ");
INSERT INTO kde_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu pachiuka nnuwani lwa Ing'ande yanga Nnungu, yumo wa avala vakuhundwa vake nkunnyaulila kuchidoni, “Nkúhunda, lola mayanga alano na ding'ande adino chidikatapele!” ");
INSERT INTO kde_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu nkunnyaulila kuchidoni, “Dachi, ùvenkudyona adi ding'ande ding'ulungwa? Wala nanga liyanga limbeisalîla muha liyanga linji, kila liyanga lìmbematohijwa pahi.” ");
INSERT INTO kde_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Bahi Yesu panaikela muha Lichinga lya Miseituni kuloja ku Ing'ande yanga Nnungu, Petulo na Yakobo na Yohana na Anduleya nkummuja paweka kuchidoni, ");
INSERT INTO kde_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tuhaulile, vitukutuku anevyo vìmbehumila chakani? Na chimaiho ntwani chimbelangûja kuva vitukutuku anevyo vìvele pepi kuhumila?” ");
INSERT INTO kde_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu nkutandilika uvahaulila kuchidoni, “Lyongolelange uchinga munahochejwe. ");
INSERT INTO kde_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kwa kuva, vanu vohe vàmbeida uvalitenda kuva vanang'o njo nangu, uvahaula kuva, ‘Nangu njo Kilisto.’ Vanu anevo vàmbevahocheja vanu vohe. ");
INSERT INTO kde_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Pàmumbepilikana habali dya ing'ondo na manyinyi la ing'ondo, henga munayope. Anelo lasima laide, henga aula ntululilo ukánambikamola. ");
INSERT INTO kde_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Chilambo chimo chìmbepanyana na chilambo chinji, ufalume umo ùmbepanyana na ufalume unji. Sehemu dyohe dya chilambo dìmbekuva na nndengendo wa chilambo, uchocho pàmbekuva na indala ing'ulu. Na anelo lammalele làvele muchi kulindamuka kwa uchungu wa kuveleka. ");
INSERT INTO kde_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Henga mwenu lyongolelange. Kwa kuva, vanu vàmbenkamulanga mwenu na kumpelekejanga n'ding'umbi, na kunsulubulanga n'ding'ande dya kunnyuwila Nnungu. Mùmbeimila muyo mwa vakulu vao na vafalume ing'anya yang'une uchinga mupate kuva mmashahidi vangu kwa vanang'o. ");
INSERT INTO kde_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Henga Malove Lambone lasima layanjajwe nahoti mmilambo vyammalele kabla ukànambikamola aula ntululilo. ");
INSERT INTO kde_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Pamumbekamulwa na kupelekejwa unasitakiwa n'ding'umbi dyavo, munave na lipamba namuna chimumbehwena unatangola. Henga mwenu tangola chihi alila limumbepewa upala, kwa kuva, akee mwenu mumbetangôla, ila nni Umumu Wanaswe. ");
INSERT INTO kde_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Munu achiantengeleke nnung'une awalalwe, na atata achiantengeleke mwanawe awalalwe. Na vana vàmbevapindikuka vávavelèkè na kuvatenda vawalalwe. ");
INSERT INTO kde_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Vanu vammalele vàmbemmenganga mwenu ing'anya yang'une. Henga ambepililîla mpaka kuntululilo aneyo njo ambepôhwa.” ");
INSERT INTO kde_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Bahi munu ambesôma chitabu achino, àlembelewa apilikanihe saana mana ya malove laîda. Anepo Yesu nkuhweneha kutangola wachidoni, “Mùmbechona chinu chanahawile nabii Danieli, chinu chiitênda Ing'ande ya Nnungu kuva najisi chiimijìjwè pachinu pakálembelewa, yani pa Ing'ande ya Nnungu. Anepo vavelênge kuchilambo cha ku Yudeya vatukutile kumachinga. ");
INSERT INTO kde_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Na munu avêle muha ing'ande analitinike kwa kutukutila nng'ande unatwala vitukutuku vyake. ");
INSERT INTO kde_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Na munu avêle kumawelu anauye kukaya unatwala lijoho lyake. ");
INSERT INTO kde_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ole wavo amahe vavêle na vitumbo na vayong'êja mmahiku anelo! ");
INSERT INTO kde_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nnyuwange Nnungu uchinga anelo lànahumile mmahiku la chipwepwe. ");
INSERT INTO kde_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kwa kuva, mmahiku anelo kùmbekuva na ibaniki ing'ulu ikánambipwawa kutandikila Nnungu pachiumbile chilambo mpaka vino, na ibaniki malinga aneyo ikámbehumila kavila. ");
INSERT INTO kde_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kuikave Nang'olo akàinjipiha isabu ya mahiku àlalá la ibaniki, akánapwawe munu kananga yumo achichiapohwe. Henga ing'anya ya vanu vake vávatondwèlè, Nnungu àniinjipiha mahiku anelo. ");
INSERT INTO kde_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Anepo munu akànnyaulila kuva, ‘Lola, Kilisto àvele apano,’ au ‘Àvele apala,’ munakulupile. ");
INSERT INTO kde_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kwa kuva, vàmbeida vanu vambelilambilîla kuva vanang'o njo Kilisto, uchocho vàmbeida manabii va kulambila. Vanu anevo vàmbetenda vimaiho na masaibu, uchinga ikàhululika vapate kuvahocheja ata vanu vávatondwèlè Nnungu. ");
INSERT INTO kde_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Henga mwenu lyongolele. Nangu ǹninnyaulilanga kabla anelo lammalele lakànambihumila. ");
INSERT INTO kde_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Henga lakàmalilika maduva la kubanika, liduva lìmbekuva chihi na lupi na mwedi nanga paumbelangaja ");
INSERT INTO kde_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","na dinondwa dimbematoka kuhaloka kumahunde na vitukutuku vyammalele vya kumahunde vivêle na dimongo, vìmbetikinyika. ");
INSERT INTO kde_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Anepo njo vanu pavambemwona Mwana wa Munu avèlè mmahunde waida, akuno avèlè na dimongo ding'ulu na ukulu. ");
INSERT INTO kde_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Anepo àmbevatuma malaika vake mmibali ncheche ya chilambo unavalapola vanu vake vávatandwèlè kuhaloka nchilambo chammalele. ");
INSERT INTO kde_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Bahi kwa nnandi wa vihepo vya tini lihundange nfano auno. Dinavi dyake padihipuka na kulikwasula mahamba, mwenu mùnamala kuva chihuku chìvele pepi. ");
INSERT INTO kde_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Na mwenu uchocho, pamumbelona ulahumila anelo laninnyaulidile, bahi mumale kuva uhiku wa kwida kwake ùvele pepi kukamola, tena ùvele chihi pannango. ");
INSERT INTO kde_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nangu nìnnyaulilanga uhiu kuva, vanu va chívelèkwà achino vakambepita, mpaka palambetimila anelo lammalele. ");
INSERT INTO kde_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kumahunde na chilambo vìmbepita, henga malove langu lakambepita mwiko.” ");
INSERT INTO kde_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Henga kuyamba liduva au uhiku wene anewo, nanga munu amaîte, ata malaika va kulihunde nanga pavamaite, wala Mwana nanga pamaite, henga Atata weka njo amaîte. ");
INSERT INTO kde_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Lyongolelange, na muve meho, kwa kuva, nanga pamukameke uhiku ulambehumila anelo. ");
INSERT INTO kde_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ìmbekuva muchi munu aûka pakaya yake nkuhwena mwanda na kuvalekela vatumishi vake mamulaka lake, kila yumo na madengo lake, na nkunnyaulila nlinzi wa pannango ààve meho. ");
INSERT INTO kde_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Bahi mùùve meho, kwa kuva, mukákameke nang'olo mwene kaya àmbeuya chakani, panji ìmbekuva chinalyulo, au ching'ati chilo, au mambumbu na panji ulyamba. ");
INSERT INTO kde_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Bahi mùùve meho uchinga akàida akuno akannaidìlè anankoje mulèlè luwono. ");
INSERT INTO kde_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Laninnyaulilanga mwenu, nìvahaulila na vammalele, mùùve meho!” ");
INSERT INTO kde_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Láisalidile maduva mavili kuhwikila Sikukuu ya Pasaka na ya Mikate Ikátaijwe Hamila. Makuhani vakulu na vakúhunda Sheliya yanga Musa vátaha indila ya kunkamula Yesu kwa ulamba, uchinga vammwalale. ");
INSERT INTO kde_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kwa kuva, váhaula kuva, “Tunankamule pasikukuu uyopa vanu vànataya timbwili.” ");
INSERT INTO kde_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu pánavèlè ku Besaniya, muing'ande yanga Simoni ánavele mmangundula walya, nkuida mmahe yumo ananyakwile chupa chikatapele namene chikatapajîjwe kwa mayanga la alabasta chivêle na mahuta la kunung'ila namene la kugalika. Nkumbandula chisibo cha anecho chupa, nkumiminila mahuta mmuti mwa Yesu. ");
INSERT INTO kde_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Vanu vanji vánavele apala nkutunduwila mmitima yavo, nkuva uvapwahikanga uvachidoni, “Mwadachi kwondonganga uvila mahuta? ");
INSERT INTO kde_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Kwa kuva, alano mahuta ikanihululika kusumiswa kwa dihela dyohe namene, nkuveng'a amahuvani.” Bahi nkunkalipila namene ayula mmahe. ");
INSERT INTO kde_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Henga Yesu nkuvahaulila kuchidoni, “Nnekange, mwadachi mùnankambyakambya? Nang'e àngutendedile lyambone. ");
INSERT INTO kde_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Amahuvani mùmbekuva navo maduva lammalele, bahi mùnahulula chihi kuvayangata kila pamulembela, henga nangu nikambekuva na mwenu maduva lammalele. ");
INSERT INTO kde_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nang'e àtendile chahulwile, ànilongolela kuupaka mmili wangu mahuta uchinga autayalishe kwajili ya kuusika. ");
INSERT INTO kde_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nangu nìnnyaulilanga uhiu kuva, kila pachinu pámbehubilìwà Malove Lambone nchilambo chammalele, na alino lyatendile ayuno mmahe lìmbetambulangwa kwa kunnyimukila nang'e.” ");
INSERT INTO kde_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Anepo Yuda Isikaliote, ayula yumo wa avala vakuhundwa kumi na mbili, nkuhwena kwa makuhani vakulu, uchinga antengeleke Yesu. ");
INSERT INTO kde_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Makuhani vakulungwa pavapilikene habali aneyo nkuhangalala namene, nkuahidi kuva vàmbemwing'a dihela. Bahi Yuda nkutandilika kutaha wasa wa kuntengeleka Yesu. ");
INSERT INTO kde_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Liduva litandi lya Sikukuu ya Mikate Ikátaijwe Hamila, liduva lyasinjwa ungandolo wamwana wa Pasaka, vakuhundwa vake nkummuja kuchidoni, “Ùlembela tukakwandalile kwachi chakulya cha Sikukuu ya Pasaka?” ");
INSERT INTO kde_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Bahi Yesu nkuvatuma vakuhundwa vake vavili, nkuvahaulila kuchidoni, “Hweneng'ana kumanga, aneko muchimukojane na nnume yumo anyakwîle chilongo cha medi. Mpapatange aneyo munu, ");
INSERT INTO kde_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","mpaka muing'ande yambeinjila, koka munnyaulile mwene ing'ande kuva, ‘Nkúhunda ànauja kuva, chìvele kwachi chumba chinimbelila chakulya cha Sikukuu ya Pasaka chalumo na vakuhundwa vangu?’ ");
INSERT INTO kde_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nanang'e achiannanguje chumba chikulungwa cha muha, chiandaliwije tayali, chivêle na kila chinu. Twandalile anemwo chakulya.” ");
INSERT INTO kde_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Vakuhundwa vake nkuuka, nkuhwena kumanga, nkunakoja kila chinu chivèlè muchi chavahaulidile Yesu, nkwandalila chakulya cha Sikukuu ya Pasaka. ");
INSERT INTO kde_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pachikamwele chinalyulo, Yesu pamo na vakuhundwa vake kumi na mbili nkukamola. ");
INSERT INTO kde_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Pávanavèlè nkulya, Yesu nkuhaula kuchidoni, “Nangu nìnnyaulilanga uhiu kuva, munu yumo mmwenu âlya pamo na nangu, àmbengutengeleka.” ");
INSERT INTO kde_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Vakuhundwa vake nkuva na nnihindambi, nkutandilika yumo-yumo kummuja kuchidoni, “Dachi, nikee nangu?” ");
INSERT INTO kde_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu nkuvahaulila kuchidoni, “Nni yumo mmwenu kumi na mbili, achahwîja nkate munkungu pamo na nangu. ");
INSERT INTO kde_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mwana wa Munu àmbekuhwa malinga chiilembwije Mmalemba Lanaswe kumwamba nang'e, henga ole wake munu ayula antengelêka Mwana wa Munu! Ikàvele wasa kwa munu aneyo kuikave akavelekwa.” ");
INSERT INTO kde_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Yesu na vakuhundwa vake pavanavele nkulya, Yesu nkutwala nkate, nkunshukulu Nnungu, nkuumeya, nkuveng'a vakuhundwa vake, wachidoni, “Twalanga, auno njo mmili wangu.” ");
INSERT INTO kde_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nkutwala chikombe chivêle divayi, nkunshukulu Nnungu, nkuveng'a, na vammalele nkukumbila nchikombe anecho. ");
INSERT INTO kde_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nkuvahaulila kuchidoni, “Aino njo myadi yangu imaîha lilailano lya Nnungu na vanu vake, imwadilîka kwajili ya vanu vohe. ");
INSERT INTO kde_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nangu nìnnyaulilanga uhiu kuva, nikambekumbila kavila divayi mpaka liduva alila linimbekumbila divayi dyahambi mu Ufalume wa Nnungu.” ");
INSERT INTO kde_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Bahi pavamalidile kwimba luhimu, nkuhumananga pawelu, nkuhweneng'ana ku Lichinga lya Miseituni. ");
INSERT INTO kde_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Bahi Yesu nkuvahaulila vakuhundwa vake kuchidoni, “Mwenu mmammalele nnembeleka kungukulupila, malinga chahawile Nnungu Mmalemba Lanaswe kuva, ‘Nìmbempanya nchunga, na angandolo vàmbemwadilikana.’ ");
INSERT INTO kde_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Henga panimbefufuka, nìmbennongolela uhwena ku Galilaya.” ");
INSERT INTO kde_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petulo nkunnyaulila Yesu kuchidoni, “Ata kuiva vammalele uvava na lipamba na wako nkukuleka, henga nangu nikambekuleka!” ");
INSERT INTO kde_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu nkunnyaulila Petulo kuchidoni, “Nangu nìkuhaulila uhiu kuva, chilo uchino cha nelo, kabla ung'uku akànambikongovela myanda mivili, wako ùmbekuva ungukanìlè myanda mitatu.” ");
INSERT INTO kde_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Henga Petulo kuhimya kwa dimongo wachidoni, “Ata kungulembelewa kuhwa chalumo na wako, nangu nikambekukana ng'o.” Na vakuhundwa vammalele nkutangola uchocho. ");
INSERT INTO kde_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yesu na vakuhundwa vake nkuhwika pawelu uvauchema Getisemane. Yesu nkuvahaulila vakuhundwa vake kuchidoni, “Ikalanga upano nangu panimbehwena unayuwa.” ");
INSERT INTO kde_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Anepo Yesu nkuntwala Petulo na Yakobo na Yohana. Yesu nkutandilika kuyuvala na kukambakamba muntima. ");
INSERT INTO kde_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nkuvahaulila kuchidoni, “Ntima wangu ùvele na nnihindambi likulu, pepi na kuhwa. Bahi ikalanga apano, mùùve meho.” ");
INSERT INTO kde_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yesu nkuhwena muyo kadiki, nkumatoka kwa kuhunama, wayuwa kuva ikàhululika uhiku aula wa kubanika untapuke. ");
INSERT INTO kde_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Yesu nkutangola kuchidoni, “Atata, kwakuwe lammalele lànahululika, bahi ngùyuwa ungunyemye na ibaniki iîda! Henga unatende muchi chingulembela nangu, ila tènda muchi chulembela wako umwene.” ");
INSERT INTO kde_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Bahi Yesu nkuvahwenela avala vakuhundwa vake vatatu, nkuvakoja valèlè luwono. Yesu nkummuja Petulo kuchidoni, “Simoni, dachi ùnilala? Nanga pauhulwile kucheja kananga lisaa limo? ");
INSERT INTO kde_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Bahi chejanga na kuyuwa uchinga pamumbelingwa munatende masambi, isungu ìnalembela henga mmili unadabadanga.” ");
INSERT INTO kde_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yesu nkuhwena kavila unayuwa, watangola chihi malove ulâla. ");
INSERT INTO kde_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Bahi Yesu nkuhwena kavila kwa vakuhundwa vake nkuvakoja valèlè luwono, kwa kuva meho lavo láumbele luwono, na wala nanga pavanamaite lya kunnyang'ula. ");
INSERT INTO kde_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Bahi Yesu nkuvahwenela vakuhundwa vake mwanda wa tatu nkuvahaulila kuchidoni, “Dachi, mmechinkwona na kupumulila? Bahi hambi uhiku ùnikamola! Lola, Mwana wa Munu, àhwena unakamujwa mmakono la vanu vavêle na masambi. ");
INSERT INTO kde_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Na ayula angutengelêka àvele pepi, bahi takatukanga tuhweneng'ane.” ");
INSERT INTO kde_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Bahi Yesu kabla akànamalila kutangola, upala nkukamola Yuda, yumo wa vakuhundwa vake kumi na mbili pamo na likuwa lya vanu ványakwìlè mapanga na dindonga. Vanu anevo vátumwije na makuhani vakulu na vakúhunda Sheliya yanga Musa na vasele va Vayahudi. ");
INSERT INTO kde_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ayula nkútengeleka ávapele avala vanu chimaiho wachidoni, “Munu ayula unimbem'busu, njo nang'e, nkamule na munchunge saana.” ");
INSERT INTO kde_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Bahi Yuda pakamwele, nkummwenela mwalehu Yesu, nkuchidoni, “Nkúhunda!” Bahi nkum'busu. ");
INSERT INTO kde_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Bahi anevo vanu nkunkamula Yesu na kunnyunga. ");
INSERT INTO kde_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Henga nkuhundwa yumo muavala vánavele apala nkuhalamola upanga wake nkuncheketa likutu ntumwa wanga Kuhani Nkulu. ");
INSERT INTO kde_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu nkuvahaulila kuchidoni, “Mwadachi mùidile unangukamula akuno munyakulèngè mapanga na dindonga muchi nangu nkúpalaula? ");
INSERT INTO kde_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Maduva lammalele nangu ngúvele pamo na mwenu nnuwani lwa Ing'ande yanga Nnungu unguhùndà na wala nanga pamunangukamwile. Henga alano làvenkutendeka uchinga Malemba Lanaswe latimile.” ");
INSERT INTO kde_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Anepo vakuhundwa vake vammalele nkunneka, nkutukuta. ");
INSERT INTO kde_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Henga kijana yumo anawete chihi shuka áhweneha chihi kunnondola Yesu. Pavalingile kunkamula, ");
INSERT INTO kde_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","nang'e nkuileka shuka, nkutukuta chihi lukundumwandu. ");
INSERT INTO kde_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Bahi vanang'o nkumpelekeja Yesu kwa Kuhani Nkulu. Anepo nkukojana makuhani vakulu na vasele va Vayahudi pamo na vakúhunda Sheliya yanga Musa. ");
INSERT INTO kde_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petulo nkuva wannondola Yesu kwa kulehu, nkwenda nnuwani lwa lukumbi lwa Kuhani Nkulu, nkuikala pamo na valinzi wayota moto. ");
INSERT INTO kde_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bahi makuhani vakulu na vajumbe vammalele va Lukumbi Lukulu lwa Vayahudi nkutaha ushahidi wa kunsitaki Yesu uchinga vammwalale, henga nanga pavanapete. ");
INSERT INTO kde_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Vanu vohe nkuhumya ushahidi wa kulambila kumwamba Yesu, henga ushahidi wavo únitindana. ");
INSERT INTO kde_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ata vanu vanji nkuimila, nkuhumya ushahidi wa kulambila kumwamba Yesu, uvachidoni, ");
INSERT INTO kde_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Hwetu túnimpilikana wahaula kuva, ‘Nangu nìmbebamola Ing'ande aino ya Nnungu idengwîje na vanu, na mmaduva matatu nìmbeidenga inji ikádengwije na vanu.’ ” ");
INSERT INTO kde_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Henga pamo na anelo, ushahidi wavo únitindana. ");
INSERT INTO kde_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Anepo Kuhani Nkulu nkuimila paching'ati pavo nkummuja Yesu kuchidoni, “Dachi, wako ukee na lilove lya kuyang'ula kwamba anelo lavakusitaki ava vanu?” ");
INSERT INTO kde_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Henga Yesu nkunnyalala chihi nanga kuyang'ula lilove. Kuhani Nkulu nkummuja kavila kuchidoni, “Dachi, wako njo Kilisto, Mwana wa Nnungu, Nnungu Atumbyangîka?” ");
INSERT INTO kde_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu nkuyang'ula kuchidoni, “Nangu njo nang'e! Mwenu muchimumwone Mwana wa Munu aikèlè m'bali wa kunkono wa Nnungu Avêle na Dimongo, uchocho muchimumwone avèlè mmahunde waida.” ");
INSERT INTO kde_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Anepo Kuhani Nkulu nkupapula dinguwo dyake, nkuhaula kuchidoni, “Dachi, pàvele ing'anya ntwani kavila ya kuvataha mashahidi? ");
INSERT INTO kde_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mwenu mmene mùnipilikana chankufwile Nnungu! Hambi mwòna dachi?” Vammalele nkunnyukumu kuva, àlembelewa ahwe. ");
INSERT INTO kde_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Vanu vanji nnikuwa alila nkutandilika kunsunila Yesu mata, nkun'diva kumeho na kumpanya ding'ondi, uvannyaulila kuchidoni, “Lauja, nnani akupanyile!” Na valinzi navanang'o nkuntwala Yesu nkumpanya makofi. ");
INSERT INTO kde_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Bahi Petulo pánavele pahi, nnuwani lwa lukumbi, nkuida ntumishi yumo mmahe, ntumishi wanga Kuhani Nkulu. ");
INSERT INTO kde_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pammwene Petulo wayota moto, nkumpalambahija meho, nkuchidoni, “Na wako uchocho úvele pamo na Yesu wa ku Nasaleti.” ");
INSERT INTO kde_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Henga Petulo nkukana wachidoni, “Nangu wala nikámaite wala kwelewa anelyo lyuwamba wako!” Anepo Petulo nkuhuma pawelu nkunaimila pannango wa kuinjilila, ung'uku nkukongovela. ");
INSERT INTO kde_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ayula ntumishi mmahe nkumwona kavila, nkutandilika kuvahaulila avala vanu vanaimidile anepo kuchidoni, “Ayu munu àvele nkumbo umo na Yesu.” ");
INSERT INTO kde_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Henga Petulo nkukana kavila. Lukoto kadiki, avala vanu vanaimidile anepo nkunnyaulila Petulo kuchidoni, “Muhiu wako nni yumo munkumbo wavo, kwa kuva, ata na wako N'galilaya.” ");
INSERT INTO kde_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Bahi Petulo nkutandilika kwapila wachidoni, “Ikàva nalambila, bahi ngulaniwe! Nangu nikámmaite munu aneyo umunnyaula.” ");
INSERT INTO kde_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Upala ung'uku nkukongovela kavila. Bahi Petulo nkulihimukila alila lilove livanannyaulidile na Yesu kuva, “Kabla ung'uku akànambikongovela myanda mivili, wako ùmbekuva ungukanìlè myanda mitatu.” Petulo pahimukidile anelo nkutandilika kukuta. ");
INSERT INTO kde_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Uhiku pauchele, makuhani vakulu nkuva uvaujana pamo na vasele va Vayahudi na vakúhunda Sheliya yanga Musa na vanu vammalele va Lukumbi Lukulu lwa Vayahudi. Nkunnyunga Yesu, nkuntwala na kunkamuja kwanga Pilato. ");
INSERT INTO kde_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato nkummuja Yesu kuchidoni, “Dachi, wako nni Nfalume wa Vayahudi?” Yesu nkuyang'ula, “Wako ùnihaula.” ");
INSERT INTO kde_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Makuhani vakulu nkunsitaki Yesu masitaka lohe. ");
INSERT INTO kde_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato nkummuja kavila Yesu kuchidoni, “Dachi, nanga pauyang'ula? Lola masitaka ala lammalele lavakusitaki!” ");
INSERT INTO kde_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Henga Yesu nanga panayang'wile lilove, Pilato nkukangana. ");
INSERT INTO kde_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Bahi kila Sikukuu ya Pasaka Pilato ávele na nnyambo wa kuvahungulila Vayahudi nfungwa yumo uvachinnembela. ");
INSERT INTO kde_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Bahi pávele na munu yumo uvanchema Balaba, uvanantadile nnilungu pamo na avake ing'anya ya kuvawalala vanu pachivachonjela vanu kuutahuka utawala wa Chiloma. ");
INSERT INTO kde_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Vanu vohe nkummwenela Pilato nkunnyuwa avatendele muchi chiuvele nnyambo wake. ");
INSERT INTO kde_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato nkuvauja kuchidoni, “Dachi, mùlembela ninchimulile Nfalume wa Vayahudi?” ");
INSERT INTO kde_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Avaujije uchocho kwa kuva, ánimala kuva makuhani vakulu vànkamujije Yesu kwanga nang'e kwa wiu. ");
INSERT INTO kde_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Henga makuhani vakulu nkuvachonjela vanu vannyuwe Pilato avahungulile Balaba. ");
INSERT INTO kde_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato nkuvauja kavila kuchidoni, “Nintende dachi ayuno munu umunnyaula kuva Nfalume wa Vayahudi?” ");
INSERT INTO kde_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Vanu vammalele nkutaya lwasu kavila uvachidoni, “Mmambe munsalaba!” ");
INSERT INTO kde_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Henga Pilato nkuvauja kuchidoni, “Ing'anya ntwani? Kwani àtendile lilida lihakalenge?” Henga vanang'o nkuhalija chihi kutaya lwasu uvachidoni, “Mmambe munsalaba!” ");
INSERT INTO kde_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Bahi kwa kuva Pilato álembedile atende muchi chilichilembela likuwa lya vanu, bahi nkunnyungulila Balaba auke. Nkulaija Yesu asulubulwe, koka nkunhumya uchinga vammambe. ");
INSERT INTO kde_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Matiyala nkuntwala Yesu nkumpelekeja nnuwani lwa nkati lwa ing'ande yanga Pilato, nkulichema likuwa lyammalele lya matiyala. ");
INSERT INTO kde_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nkummwaja likoti lya langi ya chifalume, nkudinga lutavi lwa miva muchi kofiya ya chifalume nkummwaja mmuti. ");
INSERT INTO kde_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Nkutandilika kunnombolela kwa mang'wanyu uvachidoni, “Utumbyangwe wako Nfalume wa Vayahudi!” ");
INSERT INTO kde_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Nkumpanyapanya imbalu mmuti, nkunsunila mata, nkutindivala malundi muyo mwake, na kunnyunamila kwa mang'wanyu. ");
INSERT INTO kde_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pavamalidile kuntendela mang'wanyu, nkummula alila likoti lya langi ya chifalume, nkummwaja dinguwo dyake mwene, nkumpelekeja pawelu imanga uchinga vakammambe. ");
INSERT INTO kde_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Pávanavele nndila, nkukojana na munu yumo uvanchema Simoni, mwenedi wa imanga ya ku Kilene, atatawavo Isikanda na Lufo, wahaloka kumawelu. Matiyala nkunnamatija aunyakule nsalaba wanga Yesu. ");
INSERT INTO kde_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nkumpelekeja Yesu mpaka pachinu pavachema Goligota, mana lake, “Pachinu pa Libadang'a.” ");
INSERT INTO kde_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nkumwing'a divayi divakundanyije na mahuta lachêmwa manemane, latumîka kupungusa ipwateki, henga nang'e nkuhita kukumbila. ");
INSERT INTO kde_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nkummamba munsalaba, nkuyavana dinguwo dyake kwa kuyela indingi, uchinga kila munu apate dinguwo dyalembelewa kutwala. ");
INSERT INTO kde_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ívele malinga satatu ulyamba pavanammambile. ");
INSERT INTO kde_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Na malemba la lishitaka lyake válembile kuva, “NFALUME WA VAYAHUDI.” ");
INSERT INTO kde_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Vámmambile pamo na vakúpalaula vavili, yumo m'bali wake wa kunkono na yumo m'bali wa kunchinda.  ");
INSERT INTO kde_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Anepo nkutimila Malemba Lanaswe lahaûla, “Ávalangiwije pamo na vatênda lahakalenge.” ");
INSERT INTO kde_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bahi vanu vachipîta anepo nkuva uvapukunya myuti yavo na kunchamba, uvachidoni, “Haa! Wako akee unahawile kuva ùmbebamola Ing'ande yanga Nnungu na kuidenga kavila mmaduva matatu! ");
INSERT INTO kde_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Hambi lipohe umwene nano kwa kulisulupuha munsalaba!” ");
INSERT INTO kde_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Makuhani vakulu na vakúhunda Sheliya yanga Musa uchocho na vanang'o nkunnyeka uvahaulanila kuchidoni, “Ávapohije chihi vanu vanji, henga hambi akáhulula kulipoha mwene! ");
INSERT INTO kde_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ati nang'e nni Kilisto, Nfalume wa Vaisilaeli! Hambi alisulupuhe mwene munsalaba uchinga tulole na kukulupila.” Na avala vakúpalaula vanavambwije pamo na nang'e navanang'o uchocho vántangoledile malove lahakalenge. ");
INSERT INTO kde_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kutandikila sasita ya muhi mpaka satisa, chilambo chammalele nkuva chihi lupi. ");
INSERT INTO kde_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Satisa Yesu nkunonoha lidi, wachidoni, “Eloyi, Eloyi, lama sabakitani?” Mana lake, “Nnungu wangu, Nnungu wangu, mwadachi ùninguleka?” ");
INSERT INTO kde_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Vanu vanji vanaimidile apala pavapilikene uchocho, nkuhaula kuchidoni, “Pilikana! Ànchema nabii Eliya.” ");
INSERT INTO kde_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Munu yumo nkutukuta, nkunachuvika siponji n'divayi dihahâma nkuipatika nnufito, nkunnyanyulila Yesu uchinga ahonde, wachidoni, “Leka, tulole ikàva Eliya àmbeida unansulupuha munsalaba!” ");
INSERT INTO kde_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu nkunonoha lidi likulu, nkuhila. ");
INSERT INTO kde_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Bahi lipanzia linahungwije paching'ati, mu Ing'ande ya Nnungu nkudaluka vipande vivili kutandikila muha mpaka pahi. ");
INSERT INTO kde_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nkulu yumo wa matiyala la Chiloma anaimidile muyo mwake pammwene Yesu namuna chahidile, nkuchidoni, “Muhiu ayu munu ávele Mwana wa Nnungu.” ");
INSERT INTO kde_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Pávele na amahe vachilôla kwa kulehu. Nnikuwa lya amahe anevo ápwawije Maliya wa imanga ya Magidala na Salome na Maliya ayuvao Yakobo n'joko na Yose. ");
INSERT INTO kde_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Amahe anevo njo vachinnondola Yesu pánavele aneko ku Galilaya na kuntumikila. Pamo na anevo, pávele na amahe vanji vohe vanaidile ku Yelusalemu pamo na nang'e. ");
INSERT INTO kde_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Pachikamwele chinalyulo, nniduva lya kulipanganiha kabla likànambikamola Liduva lya Kuyewelela, ");
INSERT INTO kde_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","nkwida Yusufu munu wa ku Alimataya, ánavele n'jumbe wa Lukumbi Lukulu lwa Vayahudi, munu achieshimika namene. Nang'e mwene álolela kwida kwa Ufalume wa Nnungu. Bahi nkummwenela Pilato bila kuyopa, nkuyuwa akautwale mmili wanga Yesu. ");
INSERT INTO kde_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Henga Pilato nkukangana papilikene kuva Yesu ànipiyanya kuhila. Bahi nkunchema ayula nkulu wa matiyala, nkummuja, uchinga amale ikàva Yesu áhidile kanandi. ");
INSERT INTO kde_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pilato papilikene kwanga ayula nkulu wa matiyala kuva áhidile kanandi, nkunnyaulila Yusufu akautwale mmili wanga Yesu. ");
INSERT INTO kde_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Anepo Yusufu nkusuma sanda, nkuusulupuha mmili munsalaba, nkuudingilija aila sanda, nkuusika munsati uvedwîje nniyanga likulu namene, koka nkuhingilihija liyanga likulu pannango wa nsati. ");
INSERT INTO kde_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maliya wa imanga ya ku Magidala na Maliya anyokwe Yose navanang'o nkupona pachinu apala paulajijwe mmili wanga Yesu. ");
INSERT INTO kde_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Palipitile Liduva lya Kuyewelela, Maliya wa imanga ya Magidala na Salome pamo na Maliya anyokwe Yakobo, nkusuma mahuta la kunung'ila uchinga vakaupake mmili wanga Yesu. ");
INSERT INTO kde_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Liduva lya Jumapili, ulyamba na mambumbu, liduva pachilihimbuka, nkuhwena kunsati. ");
INSERT INTO kde_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nkuva uvaujana vene kwa vene uvachidoni, “Nnani ambetuusîja alila liyanga likulu namene pannango wa nsati?” ");
INSERT INTO kde_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Henga pavalolite, nkulyona alila liyanga lihingiliwijìjwè kunyenje nnango. ");
INSERT INTO kde_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Pavainjidile munsati, nkumwona malaika achiloleka muchi kijana, akono awètè inguwo yanahe ing'anyîma namene, aikèlè m'bali wa kunkono, vanang'o nkukangana namene. ");
INSERT INTO kde_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ayula malaika nkuvahaulila kuchidoni, “Munayope. Nangu ǹnimala kuva mùntaha Yesu wa ku Nasaleti avambwîje munsalaba. Nang'e ànifufuka, apano akapali. Lola pachinu pavanannajije. ");
INSERT INTO kde_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Hweneng'ana mukavahaulile vakuhundwa vake pamo na Petulo kuva, àninnongolelanga kuhwena ku Galilaya. Aneko muchimumwone malinga chanannyaulidile.” ");
INSERT INTO kde_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Vanang'o nkukangana na kuyopa, bahi nkuhuma amula munsati uvatukuta. Na wala nanga pavanannyaulidile munu chinu, kwa kuva, vániyopa namene. ");
INSERT INTO kde_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu pafufwike ulyamba na mambumbu liduva lya Jumapili, nkutandilika ulilanguja kwa Maliya wa imanga ya Magidala, wanammusije anamindenga saba. ");
INSERT INTO kde_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maliya nkunavahaulila lammalele avala vakuhundwa vanavenkukuta na kulikutangila. ");
INSERT INTO kde_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Henga pavapilikene kuva Yesu mumi, na Maliya wa imanga ya ku Magidala ànimwona, vanang'o nanga pavanakulupidile. ");
INSERT INTO kde_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Bada ya anelo, Yesu nkuvahumila vakuhundwa vake vavili vachihwêna ya kuchijiji, akuno waloleka chihi chinji. ");
INSERT INTO kde_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Vakuhundwa anevo nkuhwena unavahaulila vakuhundwa vanji. Henga navanang'o nanga pavanakulupidile. ");
INSERT INTO kde_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kuntululilo, Yesu nkuvahumila vakuhundwa kumi na moja pavanavele pameza uvalya. Nkuvakalipila ing'anya nanga pavanakulupidile, na ing'anya ya itahuki yavo, kwa kuva, nanga pavanavakulupidile avala vammwêne Yesu bada ya kufufuka. ");
INSERT INTO kde_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nkuvahaulila kuchidoni, “Hweneng'ana mmilambo vyammalele mukàvayanjajije vanu vammalele Malove Lambone. ");
INSERT INTO kde_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Akúlupila na kubatiswa achiapohwe, akambekulupila àmbehukumiwa asabu. ");
INSERT INTO kde_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Na vimaiho avino vya masaibu vìmbepapatana na avala vakulupîla, kwa lina lyangu vàmbevausa anamindenga na vàmbetangola kwa luga dyahambi, divakanalihunda. ");
INSERT INTO kde_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ata kuvakamula mihongo na kukumbila chinu chohecho chivêle na sumu, vikambevavenga. Vàmbevavikila vagonjo makono, na vanang'o vachivalame.” ");
INSERT INTO kde_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bahi Nang'olo Yesu pamalidile kutangola navo malove anelo, Nnungu nkuntwala Yesu kuhwena muha kulihunde kwa Nnungu, nkuikala m'bali wa kunkono wa Nnungu. ");
INSERT INTO kde_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Vakuhundwa nkuuka nkunayanjaja Malove Lambone kila pachinu. Nang'olo nkukola madengo pamo navanang'o, na kumaiha uhiu wa malove lake kwa vimaiho vya masaibu víchipapatànà na malove lavo.");
INSERT INTO kde_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nkulu Teofili, Vanu vohe vànitumbama kulemba saana habali dya vitukutuku avila vitimiswîje kwetuhwe. ");
INSERT INTO kde_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Na vàlembile uchila muchi chivatusimulidile vanu avala vaviwêne vitukutuku anevyo kutandikila anepo patandi, na vanu uvovo nkujuka kuva vatumishi va Lilove lya Nnungu. ");
INSERT INTO kde_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Hambi Nkulu, kwa kuva nangu nimwene ǹnilitahija uhiu wa vitukutuku anevyo kutandikila anepo patandi, ngùwene kuva ìnikatapala nikulembile uhiu wa vitukutuku vyene chivinavele. ");
INSERT INTO kde_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ngùtendile uchocho uchinga na wako uumale uhiu wammalele wa vitukutuku vyuhundwije. ");
INSERT INTO kde_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mahiku anelo Helode pánavele nfalume wa chilambo cha ku Yudeya, pávele na kuhani yumo lina lyake Sakaliya, wa nnikuwa lya makuhani va litawa lya Abiya. Na Elisabeti n'jawe nanang'e ávele wa nnitawa lya kuhani uvanchema Haluni. ");
INSERT INTO kde_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Vammalele vavili vátenda àlalá lalalembela Nnungu, na váikala kwa kudikamula amuli na malaijo la Nang'olo bila kwambika. ");
INSERT INTO kde_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Henga nanga pavanavele na mwana ing'anya Elisabeti ávele ntonga, na vammalele vavili vánikongopala namene. ");
INSERT INTO kde_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Liduva limo, Sakaliya ávele pa Ing'ande ya Nnungu wakola madengo lake la chikuhani muyo mwanga Nnungu, kwa kuva, ívele samu ya likuwa lyake. ");
INSERT INTO kde_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Na kupapatana na namuna chunavele nnyambo wa chikuhani, nang'e ánitandolwa kwa indila ya kuyela indingi uchinga ainjile mu Ing'ande ya Nang'olo Nnungu akatutumye ubani. ");
INSERT INTO kde_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sakaliya panavele nkututumya ubani, likuwa lya vanu vanaidile unayuwa, lívele nkuyuwa pawelu. ");
INSERT INTO kde_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Bahi malaika nkunnyumila, nkuimila m'bali wa kunkono wa chitala cha kututumija ubani. ");
INSERT INTO kde_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakaliya pammwene ayula malaika nkukambakamba muntima mwake na kuyopa. ");
INSERT INTO kde_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Henga ayula malaika nkunnyaulila kuchidoni, “Sakaliya, unayope, kwa kuva Nnungu ànipilikana kuyuwa kwako. N'jalo Elisabeti àmbekunyakulila mwana wa chilume, na wako ncheme lina Yohana. ");
INSERT INTO kde_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Na wako ùmbehangalala na kulihekela namene, na vanu vohe vàmbehangalala ing'anya ya kuvelekwa kwake. ");
INSERT INTO kde_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kwa kuva, àmbekuva nkulungwa pameho pa Nang'olo na wala nanga pambekumbila divayi wala wâla, na àmbeumbajwa Umumu Wanaswe kutandikila nnitumbo lya anyokwe. ");
INSERT INTO kde_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nang'e àmbevatenda Vaisilaeli vohe vammuyile Nang'olo Nnungu wavo. ");
INSERT INTO kde_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Na àmbelongolela muyo mwa Nang'olo kwa dimongo na isungu muchi mwanavelelee Eliya uchinga avatayalise vanu kwajili ya kwida kwake. Àmbevapatanisa anga atata na vanavao, na kuvapindikulanya vanu vakápilikana uchinga vààve na lúnda lwa kumpilikana Nnungu.” ");
INSERT INTO kde_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakaliya nkummuja ayula malaika kuchidoni, “Chinu ntwani chimbemaîha kuva anelo malove lunguhaulila nni la uhiu? Nangu ǹnikongopala, na n'jangu uchocho nanang'e ànikongopala.” ");
INSERT INTO kde_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ayula malaika nkuyang'ula kuchidoni, “Nangu njo Gabulieli, nguimîla muyo mwanga Nnungu. Ǹnitumwa unalonjela na wako na kukuhaulila malove alano lambone. ");
INSERT INTO kde_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Lola, kwa kuva wako nanga paulakulupidile malove langu lanikuhaulidile, lambetimîla kwa uhiku wake, bahi kutandikila vino wako ùmbekuva bubu na ukambehulula kutangola mpaka liduva alila palambetimila malove anelo.” ");
INSERT INTO kde_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Na vanu vanavele pawelu uvanninda Sakaliya, nkuva uvakangana pàvawene watima kuhuma mu Ing'ande ya Nnungu. ");
INSERT INTO kde_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pahumile pawelu, nanga panahulwile kutangonavo. Anepo vanu nkumala kuva àlawene maono mu Ing'ande ya Nnungu. Bahi kwa kuva ávele bubu, nkuva watangola navo kwa kuvaolotela kwa makono. ");
INSERT INTO kde_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sakaliya pamalidile maduva lake la kukola madengo la chikuhani, nkuuya kukaya kwake. ");
INSERT INTO kde_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Bada ya maduva anelo, Elisabeti n'jawe nkuva na chitumbo, nkuikala pakaya pake myedi nnyano, nkutangola kuchidoni, ");
INSERT INTO kde_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Hambi Nang'olo àngutendeledile lambone kwa kunguusija dihoni dya kuva ntonga, dinnavenadyo pameho pavanu.” ");
INSERT INTO kde_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mmwedi wa sita wa chitumbo changa Elisabeti, Nnungu nkunnaija malaika lina lyake Gabulieli, ahwene mpaka imanga ichêmwa Nasaleti chilambo cha ku Galilaya, ");
INSERT INTO kde_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kwanga mwali yumo, akànambimmala nnume. Aneyo mwali áchemwa Maliya, anaposwije na munu yumo lina lyake Yusufu, wa nnitawa lyanga Daudi. ");
INSERT INTO kde_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Malaika nkummwenela, nkunnyaulila kuchidoni, “Disalamu dyako, wako ujaliwîje na Nnungu! Nang'olo àvele pamo na wako.” ");
INSERT INTO kde_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maliya papilikene malove anelo muntima mwake nkukambakamba, nkuva waliuja kuva, “Disalamu anedyo dìvele na mana ntwani?” ");
INSERT INTO kde_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ayula malaika nkunyaulila kuchidoni, “Maliya unayope, kwa kuva, Nnungu ànikatapaliwa na wako. ");
INSERT INTO kde_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Lola, ùmbekuva na chitumbo, na ùmbemmeleka mwana wa chilume, na lina lyake ùmbenchema Yesu. ");
INSERT INTO kde_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nang'e àmbekuva nkulu na àmbechemwa Mwana wa Nnungu Nkulu. Na Nang'olo Nnungu àmbemwing'a chiteng'u cha chifalume changa Daudi, anakuluwe. ");
INSERT INTO kde_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Àmbevatawala Vaisilaeli vyaka na vyaka, na ufalume wake nanga paumbekuva na ntululilo.” ");
INSERT INTO kde_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maliya nkummuja malaika kuchidoni, “Anelo mambo làmbehululika dachi, na nangu nikàmmaìtè nnume?” ");
INSERT INTO kde_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malaika nkunnyang'ula kuchidoni, “Umumu Wanaswe àmbekuidila, na dimongo dya Nnungu Nkulu dìmbekuhunika muchi mmbweha. Bahi ing'anya ya anelyo, Mwana ambevelêkwa àmbekuva Wanaswe na àmbechemwa Mwana wanga Nnungu. ");
INSERT INTO kde_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Lola, ata nnanga wako Elisabeti àvele na chitumbo na àmbemmeleka mwana wa chilume ikànava ànikongopala. Vanu vàmmaite kuva nang'e ntonga, henga vino àvele na chitumbo cha mwedi wa sita. ");
INSERT INTO kde_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kwa kuva, nanga chinu chikáhululika kwanga Nnungu.” ");
INSERT INTO kde_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maliya nkuchidoni, “Nangu ni ntumishi wanga Nang'olo, bahi ngutendewe muchi chuhawile.” Anepo aneyo malaika nkuuka. ");
INSERT INTO kde_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mmaduva ulolo Maliya nkupanganika, nkupiyanya kuhwena kuimanga imo ivêle kumachinga la chilambo cha ku Yudeya. ");
INSERT INTO kde_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pakamwele aneko, Maliya nkuhwena kukaya kwanga Sakaliya, nkuinjila nng'ande, nkunsalimila Elisabeti. ");
INSERT INTO kde_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Bahi Elisabeti papilikene chihi disalamu dya Maliya, nkanunu avêle nnitumbo mwanga Elisabeti, nkupikitanga namene kwa kuhangalala. Anepo Elisabeti nkuumbajwa Umumu Wanaswe, ");
INSERT INTO kde_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","nkunonoha lidi wachidoni, “Ùnijaliwa kupunda amahe vammalele, na mwana umbemmelêka ànijaliwa! ");
INSERT INTO kde_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Henga nangu ni nani mpaka anyokwe Nang'olo wangu aide kwang'une? ");
INSERT INTO kde_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Lola, pangupilikene chihi disalamu dyako, mwana nkanunu nkupikitanga namene kwa kuhangalala nnitumbo lyangu. ");
INSERT INTO kde_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Henga wasa wako ukulupidîle kuva, àlalá lákuhaulidìlè Nang'olo lachilatimiswe!” ");
INSERT INTO kde_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maliya nkuchidoni, “Ntima wangu ùnnombolela Nang'olo, ");
INSERT INTO kde_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","na isungu yangu ìnnyangalalila Nnungu Mpohi wangu. ");
INSERT INTO kde_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kwa kuva, ànguvikidile chididi nangu nintumishi wake ngulisulupûha. Na kutandikila vino mpaka vyaka na vyaka, vívelêkwa vyammalele vìmbenguchema ngujaliwîje, ");
INSERT INTO kde_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kwa kuva, Nnungu Avêle na Dimongo àngutendedile mambo makulu, na lina lyake nni wanaswe. ");
INSERT INTO kde_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nang'e àvavikila chididi vanu vamwesîmu va vívelêkwa vyammalele. ");
INSERT INTO kde_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Àtendile mambo makulungwa kwa dimongo dyake, na ànivapalang'anya vanu avala valyôna mmitima yavo. ");
INSERT INTO kde_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Àvasulupusije vafalume mmiteng'u vyavo vya chifalume, na kuvatumbyanga vanu vaonekâna kuva vakee va mana. ");
INSERT INTO kde_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Àvasibihije amahuvani vavêle na indala kwa vitukutuku vyambone, henga vakúpata àvavingenge chihi makono weka. ");
INSERT INTO kde_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Àvayangete vanu va Isilaeli vatumishi vake, kwa kukumbukila ahadi yake ya kuvavikila chididi, ");
INSERT INTO kde_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","malinga chanavaahidite anyakala vetu, Iblahimu na lukolo lwake, vyaka na vyaka!” ");
INSERT INTO kde_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Bahi Maliya nkuikala na Elisabeti malinga myedi mitatu, anepo nkuuya kukaya kwake. ");
INSERT INTO kde_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Palahwikile mahiku la Elisabeti kunyakula, bahi nkummeleka mwana wa chilume. ");
INSERT INTO kde_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Avandikani mwave chalumo na alangavake pavapilikene kuva Nang'olo àmmikilidile chididi chikulungwa, vammalele nkuhangalala nawe pamo. ");
INSERT INTO kde_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mwana pahwikihije maduva nane, vanu nkwidang'ana unannyalula, nkulembela vamwing'e lina Sakaliya, lina lya atatake. ");
INSERT INTO kde_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Henga anyokwe nkuchidoni, “Nanga! Akee uchocho, lina lyake àmbechemwa Yohana.” ");
INSERT INTO kde_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Anevo vanu nkuchidoni, “Mbona nnitawa lyenu nanga munu avêle na lina anelyo!” ");
INSERT INTO kde_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Anepo vanu nkummuja atatake mwana kwa kumwolotela uchinga vamale àlembenchema lina ntwani. ");
INSERT INTO kde_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakaliya nkuyuwa chibao cha kulemba, nkulemba uvila, “Lina lyake Yohana.” Vanu vammalele nkukangana! ");
INSERT INTO kde_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Bahi upala lulimi na kanya ya Sakaliya nkuhunguliwa, nkutandilika kavila kutangola akuno wannombolela Nnungu. ");
INSERT INTO kde_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Avandikani mwave vammalele nkuyopa, na vanu vammalele nkuva uvatangola habali anedyo kila pachinu nchilambo cha machinga-machinga cha ku Yudeya. ");
INSERT INTO kde_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Vanu vammalele vapilikêne habali anedyo, nkudivika mmitima yavo akuno uvaliuja kuchidoni, “Ayu mwana àmbekuva munu wa namuna ntwani?” Kwa kuva, dimongo dyanga Nang'olo dínanchunga. ");
INSERT INTO kde_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sakaliya, atatake Yohana, nkuumbajwa Umumu Wanaswe, nkutandilika kuhumya unabii wachidoni, ");
INSERT INTO kde_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Alombolewe Nang'olo, Nnungu wa Isilaeli, kwa kuva, àidile unavayangata vanu vake na kuvakombola. ");
INSERT INTO kde_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nang'e àtwing'ile Mpohi avêle na dimongo, avelekwejîje nnitawa lyanga Daudi, ntumishi wake, ");
INSERT INTO kde_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","malinga chanatangwele anepo kala, kupitila manabii vake vanaswe. ");
INSERT INTO kde_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Na vino tùmbepohwa mmakono la amongo vetu, yani vanu avala vatuvênga. ");
INSERT INTO kde_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nnungu àvavikidile chididi anyakala vetu, kwa kulikumbukila lilailano lyake lyanaswe, ");
INSERT INTO kde_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","lyanamwapilidile anakulwetu Iblahimu. ");
INSERT INTO kde_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Tùnipohwa mmakono la amongo vetu, bahi tùnahulula kuntumikila bila kuyopa, ");
INSERT INTO kde_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","kwa hali ya uwanaswe na haki pameho pake, mmaduva lammalele la umi wetu. ");
INSERT INTO kde_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Na wako mwanangu, ùmbechemwa nabii wa Nnungu Nkulu, kwa kuva, ùmbennongolelela Nang'olo, uchinga unkatapajije indila yake, ");
INSERT INTO kde_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","kwa kuvamaiha vanu vake upohi wa kusamehewa masambi lavo. ");
INSERT INTO kde_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Bahi ing'anya ya chididi chikulu changa Nnungu wetu, nng'anje wa upohi kuhaloka kulihunde ùvele pepi kutulangajija, ");
INSERT INTO kde_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","hwetu tuikâla nnupi na mummbweha wa kuhwa, uchinga atulodye tupate kuipapata indila ya amani.” ");
INSERT INTO kde_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Aneyo mwana nkuhweneha kukulumuka na kuyenjejeka dimongo muisungu yake. Nkuhwena unaikala kulilanga mpaka palihwikile liduva alila lyatandilike utumishi wake pameho pa vanu va Isilaeli. ");
INSERT INTO kde_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mmaduva anelo, Nfalume Agusto, ánavele nfalume nkulu wa Loma, álaijije vanu vammalele va vilambo víchitawaliwa na ufalume wa Loma, valembwe malina lavo mmitabu. ");
INSERT INTO kde_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Na auno wávele mwanda ntandi wa kuvalangwa kwa vanu mmahiku àlalá Kuleniyo panavele nkulu wa chilambo cha ku Siliya. ");
INSERT INTO kde_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kila munu nkuhwena kuimanga yavelekwejije unalembwa lina lyake. ");
INSERT INTO kde_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yusufu nanang'e nkuuka kuimanga ya ku Nasaleti chilambo cha ku Galilaya, nkuhwena kuimanga ya ku Beselehemu ivêle nchilambo cha ku Yudeya, imanga yanavelekwejije Nfalume Daudi. Yusufu ápite aneko kwa kuva, ávelekwejije nnitawa lyanga Daudi. ");
INSERT INTO kde_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yusufu ápite unalembwa pamo na Maliya mmahe wachimposa, ánavele na chitumbo. ");
INSERT INTO kde_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Pavanavele aneko ku Beselehemu, uhiku wa Maliya kunyakula nkukamola, ");
INSERT INTO kde_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","nkummaleka mwana wa chilume, chihungumikova. Nkun'dingilija dinguwo dya chikanunu, nkunannaja nchombo cha kuvalisija ang'ombe, kwa kuva, nanga pavanapete nafasi muing'ande ya vayeni. ");
INSERT INTO kde_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Chilo uchocho, pepi na imanga aneyo pávele na vachúnga vachicheja kulilanga chilo uvavalolihija angandolo vao. ");
INSERT INTO kde_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Upala malaika wanga Nang'olo nkuvahumila, na nng'anje wa ukulu wa Nang'olo nkuvalangajija kila m'bali, vachúnga nkuyopa namene. ");
INSERT INTO kde_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Malaika nkuvahaulila kuchidoni, “Munayope, kwa kuva, nangu nìmpelekejijije mwenu malove lambone lambevahangalâja namene vanu vammalele. ");
INSERT INTO kde_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kwa kuva, nelo muimanga yavelekwejije Nfalume Daudi, àvelekwejije Mpohi kwajili yenu, aneyo njo Kilisto na Nang'olo. ");
INSERT INTO kde_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Na achino njo chimbekûva chimaiho kwenu mwenu kuva, pamumbehwena mùmbenkoja nkanunu adingilijìjwè dinguwo dya chikanunu akuno alajìjwè nchombo cha kuvalisija ang'ombe.” ");
INSERT INTO kde_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Upala nkuhumila likuwa likulungwa lya malaika, nkulundana na aneyo malaika, nkuva uvannombolela Nnungu uvachidoni, ");
INSERT INTO kde_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Atumbyangwe Nnungu avêle muha kulihunde, na apano pachilambo pààve na amani kwa vanu vákatapaliwìjè navo!” ");
INSERT INTO kde_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Anevo malaika pavaukile kuhwena kulihunde, vachúnga nkuhaulanila kuchidoni, “Tuhweneng'ane ku Beselehemu tukalole chinu chihumidîle, chatuhaulidile Nang'olo.” ");
INSERT INTO kde_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bahi vanang'o nkutumanuma kuhwena, nkunkoja Maliya na Yusufu na ayula nkanunu, alajìjwè nchombo cha kuvalisija ang'ombe. ");
INSERT INTO kde_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Avala vachúnga pavammwene ayula nkanunu, nkuhwena unavahaulila vanu vammalele malove lanavahaulidile ayula malaika kunnyamba aneyo mwana. ");
INSERT INTO kde_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Vanu vammalele vanapilikene anelo, nkukangana namene habali anedyo divachitanga anevo vachúnga. ");
INSERT INTO kde_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Henga Maliya nkulavika anelo lammalele muntima mwake akuno walahimukila. ");
INSERT INTO kde_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bahi avala vachúnga nkuuyananga, akuno uvantumbyanga na kunnombolela Nnungu kwajili ya mambo lammalele lavalapilikene na kulona, kwa kuva, lammalele láhumidile muchi chanavahaulidile ayula malaika. ");
INSERT INTO kde_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Palikamwele liduva lya nane, liduva lya kunnyalula ayula mwana, nkunchema lina Yesu. Lina anelyo áhumije malaika kabla Maliya akànambikuva na chitumbo. ");
INSERT INTO kde_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Palamalilike maduva la luhuko kupapatana na Sheliya ya Musa chiinalaijije, Yusufu na Maliya nkuntwala mwana nkumpelekeja ku Yelusalemu, unankamuja kwanga Nang'olo uchinga antumikile. ");
INSERT INTO kde_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Vápite unatenda uchocho kupapatana na Sheliya yanga Nang'olo ihaûla kuva, “Kila chihungumikova wa chilume, àmbekamujwa kwanga Nang'olo ààve wake.” ");
INSERT INTO kde_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Na vápite unahumya na sadaka malinga chiilaijije Sheliya ya Nang'olo kuva, “madeya mavili au makanda mavili la dimunda.” ");
INSERT INTO kde_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na pa Yelusalemu pávele na munu yumo lina lyake Simeoni. Munu aneyo átenda àlalá lalalembela Nnungu na kumweshimu. Simeoni álolela kwa hamu ing'ulu kuida kwa upohi wa vanu va Isilaeli, na Umumu Wanaswe ávele pamo nanang'e. ");
INSERT INTO kde_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Umumu Wanaswe ánimmaiha kuva, akambekuhwa mpaka amwone Kilisto wa Nang'olo Nnungu. ");
INSERT INTO kde_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Anepo Umumu Wanaswe nkunnodya Simeoni kuinjila pa Ing'ande ya Nnungu. Vammelêke Yesu pavampelekejije mwana pa Ing'ande yanga Nnungu uchinga atendewe muchi chiilaijije Sheliya ya Musa, ");
INSERT INTO kde_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeoni nkumpwechelela aneyo mwana mmakono lake na kunnombolela Nnungu, wachidoni, ");
INSERT INTO kde_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Nang'olo Nkulu, nangu ni ntumishi wako, vino nguluhusu nguhwe kwa amani, kwa kuva, ùniitimisa ahadi yako. ");
INSERT INTO kde_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kwa kuva, kwa meho langu ǹniyona indila yako yumbevapohija vanu. ");
INSERT INTO kde_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Na indila aneyo ùniitayalisha uchinga vanu vammalele vayone. ");
INSERT INTO kde_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Indila aneyo njo imbevalangajîja vanu vakávele Vayahudi, na kuida na ukulu kwa vanu vako Vaisilaeli.” ");
INSERT INTO kde_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Atatake Yesu pamo na anyokwe nkukangana namene pavapilikene malove lachitangola Simeoni kumwamba Yesu. ");
INSERT INTO kde_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeoni nkuvabaliki, nkunnyaulila Maliya anyokwe Yesu kuchidoni, “Ayu mwana ànivelekwa kuva ing'anya ya kuyahika na kupohwa kwa Vaisilaeli vohe. Na nang'e àmbekuva chimaiho kuhaloka kwanga Nnungu, henga vanu vohe vàmbentahuka, ");
INSERT INTO kde_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","uchinga mitima ya vanu vohe imaikane. Na wako Maliya ntima wako ùmbepwateka muchi ùhomwije upanga ukôla akuno na akuno.” ");
INSERT INTO kde_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Anepo pa Ing'ande yanga Nnungu pávele na nabii yumo wa chikongwe anakongopele namene. Mmahe aneyo lina lyake vánchema Ana, mwana wanga Fanuweli, wa nnitawa lwa Asheli. Ana pánavele mwali áikalene na ntwave myaka saba, anepo ntwave nkuhila. ");
INSERT INTO kde_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Pahiliwijije na ntwave nkuva chihi waikala weka mpaka kuhwikila kuva na myaka samanini na ncheche. Maduva anelo lammalele akáchiuka pa Ing'ande ya Nnungu wantumikila Nnungu chilo na muhi, wafunga na kunnyuwa Nnungu. ");
INSERT INTO kde_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Aneyo mmahe nkuhaloka, nkutandilika kunnombolela Nnungu na kutanga habali dya aneyo mwana kwa vanu vammalele vachilolêla kupohwa kwa imanga ya Yelusalemu. ");
INSERT INTO kde_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yusufu pamo na Maliya, pavamalidile kutenda mambo lammalele lalaijîjwe mu Sheliya yanga Nang'olo, nkuukananga pa Yelusalemu nkuhwena kuchijiji chavo cha ku Nasaleti, chilambo cha ku Galilaya. ");
INSERT INTO kde_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Aneyo mwana nkukulumuka na kuyenjejeka dimongo na kuumbalwa na lúnda, na inema ya Nnungu ívele pamo nanang'e. ");
INSERT INTO kde_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kila mwaka atatake na anyokwe Yesu vánayomboka kuhwena ku Yelusalemu kusikukuu ya Vayahudi ya Pasaka. ");
INSERT INTO kde_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu pahwikihije changa cha myaka kumi na mbili, nkuyomboka navo kuhwena kusikukuu kupapatana na nnyambo wa sikukuu aneyo. ");
INSERT INTO kde_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Na paimalilike sikukuu, nkutandilika mwanda wa kuuya kwavo, henga Yesu nkuisalila ku Yelusalemu. Anyokwe na atatake vakáchimala kuva àniisalila, ");
INSERT INTO kde_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","vanang'o vátenda kuva àvele nnikuwa lya amwanda. Anepo nkuhwena mwanda wa liduva limo, nkutandilika kuntaha mmakuwa la alangavao na ayanjavao. ");
INSERT INTO kde_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Bahi kwa kuva nanga pavanammwene, nkuuyananga ku Yelusalemu unantaha. ");
INSERT INTO kde_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nniduva lya tatu lya kuntaha, nkunankoja nnuwani lwa Ing'ande ya Nnungu aikèlè ching'ati vakúhunda Sheliya ya Musa, wavapilikanila na kuvauja maswali. ");
INSERT INTO kde_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Vanu vammalele vachimpilikanîla vánikangana namene ing'anya ya ding'ano dyake na mayang'udi lake. ");
INSERT INTO kde_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Vammalêke pavammwene nkukangana namene. Anyokwe nkummuja kuchidoni, “Mwanangu, ing'anya ntwani ùtutendedile uchocho? Nangu na atatako twavele na lipamba patuchikutaha.” ");
INSERT INTO kde_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesu nkuvayang'ula kuchidoni, “Mwadachi mungutahe? Dachi, mukámayite kuva ngùlembelewa ngùùve mu Ing'ande ya Atatangu?” ");
INSERT INTO kde_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Henga vammalêke, nanga pavanakameke chilachiyamba malove lavahaulidile. ");
INSERT INTO kde_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Bahi Yesu nkuuya ku Nasaleti chalumo na anyokwe na atatake, nkuva wavapilikana. Anyokwe nkulavika anelo lammalele muntima mwake akuno walahimukila. ");
INSERT INTO kde_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu nkuhweneha kuyenjejeka lúnda na changa, na kuhalija kunkatapalila Nnungu pamo na vanu. ");
INSERT INTO kde_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Bahi mmwaka wa kumi na nnyano wa utawala wanga Tibeliyo Nfalume wa Loma, Pontio Pilato ávele nkulu wa chilambo cha ku Yudeya. Na Helode ávele nkulu wa chilambo cha ku Galilaya na Filipo nkuluwe Helode ávele nkulu wa chilambo cha ku Ituleya na ku Talakoniti, na Lusaniya ávele nkulu wa chilambo cha ku Abilene, ");
INSERT INTO kde_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anasi na Kayafa vávele Makuhani Vakulu. Bahi mmahiku anelo Yohana mwana wanga Sakaliya nkupwechelela ujumbe wa lilove lya Nnungu pánavele aneko kulilanga. ");
INSERT INTO kde_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Anepo Yohana nkupita waonga mmilambo vyammalele vivêle pepi na muto wa Yoludani wavahubilila vanu valeke masambi na kubatiswa uchinga Nnungu avasamehe masambi lavo. ");
INSERT INTO kde_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Bahi anepo njo palatimidile malove alano lalembwîje nchitabu changa nabii Isaya kuchidoni, “Munu ànonoha lidi aneko kulilanga wachidoni, ‘Nkatapajije Nang'olo indila yake, nyoshanga dihengo dyambepita. ");
INSERT INTO kde_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kila luhunde lùmbehuhuliwa, na kila lichinga na kila chisulu vìmbetingilivanywa, na sehemu dingongomêne dìmbenyoshwa, na dindila divêle na mapondo dìmbehang'anijwa. ");
INSERT INTO kde_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na kila munu achiawone upohi uhalôka kwa Nnungu!’ ” ");
INSERT INTO kde_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Bahi Yohana nkuva wavahaulila vanu vammalele vachiîda unabatiswa kuchidoni, “Mwenu nni mmana mma nachihungo! Nnani an'dumênge mwenu muitile gasabu yanga Nnungu iîda? ");
INSERT INTO kde_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Bahi tendanga matendo lalangûja kuva mùnilaleka masambi lenu. Mùnatandilike chihi kulihaulila mmene kwa mmene kuva, ‘Iblahimu nni anakulwetu.’ Nangu nìnnyaulilanga kuva, Nnungu ànahulula kulapindikulanya mayanga alano lààve udukulu vanga Iblahimu. ");
INSERT INTO kde_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Bahi vino imbedo ìnivikwa tayali kucheketa mahina la milandi. Kila nnandi ukápa vihepo vikatapele umbecheketwa na kuyahwa mmoto.” ");
INSERT INTO kde_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Likuwa lya vanu nkummuja Yohana kuchidoni, “Vino tutende dachi?” ");
INSERT INTO kde_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yohana nkuvayang'ula kuchidoni, “Kila munu avêle na mikogo mivili, atwale umo annyavile nnyake akávenawo, na avêle na chakulya nanang'e avayavile vakávenacho.” ");
INSERT INTO kde_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Na vakútwala kodi navanang'o nkummwenela uchinga vabatiswe, nkummuja Yohana kuchidoni, “Nkúhunda, nkee hwetu tutende dachi?” ");
INSERT INTO kde_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nang'e nkuvayang'ula kuchidoni, “Nnatwale kodi kupunda chimulaijijwe.” ");
INSERT INTO kde_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Matiyala navanang'o nkummuja Yohana kuchidoni, “Nkee hwetu tutende dachi?” Yohana nkuvayang'ula kuchidoni, “Mwenu munansulumu munu chinu chohecho, na wala munansitaki munu kulukumbi kwa kunnambilila. Mwenu tolejwa chihi na misahala yenu.” ");
INSERT INTO kde_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Vanu vammalele vachilolêla kuida kwa Kilisto, nkuva uvaliuja mmitima yavo kuva, panjika Yohana njo Kilisto. ");
INSERT INTO kde_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Bahi Yohana nkuvahaulila vanu vammalele kuchidoni, “Nangu nìm'batisa mwenu kwa medi, henga ànipwawa aîda, avêle na dimongo ding'ulu kungupunda nangu, na nangu wala nikáfala kuntumikila kananga kwa kuhungula mididi ya vilatu vyake. Nang'e àmbem'batisa mwenu kwa Umumu Wanaswe na kwa moto. ");
INSERT INTO kde_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nang'e ànyakwile chihelo cha kupembulila mmakono mwake uchinga apepetele ngano yake. Àmbeilapola ngano na kuivika nnikangala, henga makadakada àmbelayocha mmoto ukádimika.” ");
INSERT INTO kde_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yohana ánivahubilila avala vanu Malove Lambone akuno wavahaulila malove lohe la kila namuna la kuvaduma. ");
INSERT INTO kde_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Uchocho, Yohana ánin'duma Nfalume Helode ing'anya ya kunnomba Helodiya, n'jawe Filipo nnung'une mwene Helode, na ing'anya ya mambo lanji mabaya lanatendile. ");
INSERT INTO kde_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Anepo Helode nkuhalija kutenda lahakalenge kwa kuntaya Yohana nnilungu. ");
INSERT INTO kde_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Vanu vammalele pavachibatiswa, Yesu nanang'e nkubatiswa. Yesu pachinnyuwa Nnungu, kulihunde nkuhunukuka, ");
INSERT INTO kde_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","na Umumu Wanaswe ánavele muchi umunda nkunsulupukila. Anepo nkupilikanika lidi kuhaloka kulihunde ulichidoni, “Wako njo mwanangu unikutamwa, ǹnikatapaliwa na wako.” ");
INSERT INTO kde_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu patandilike kukola madengo lake ávele na myaka malinga salasini, na vanu vátenda kuva nang'e ni mwana wanga Yusufu. Yusufu ávele mwana wanga Heli. ");
INSERT INTO kde_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli ávele mwana wanga Masati, na Masati ávele mwana wanga Lawi, na Lawi ávele mwana wanga Meliki, na Meliki ávele mwana wanga Yanayi, na Yanayi ávele mwana wanga Yusufu, ");
INSERT INTO kde_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","na Yusufu ávele mwana wanga Matatiya, na Matatiya ávele mwana wanga Amosi, na Amosi ávele mwana wanga Nahumu, na Nahumu ávele mwana wanga Hesili, na Hesili ávele mwana wanga Nagayi, ");
INSERT INTO kde_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","na Nagayi ávele mwana wanga Maasi, na Maasi ávele mwana wanga Matatiya, na Matatiya ávele mwana wanga Semeyi, na Semeyi ávele mwana wanga Yoseki, na Yoseki ávele mwana wanga Yuda, ");
INSERT INTO kde_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","na Yuda ávele mwana wanga Yohanani, na Yohanani ávele mwana wanga Lesa, na Lesa ávele mwana wanga Selubabeli, na Selubabeli ávele mwana wanga Shealitieli, na Shealitieli ávele mwana wanga Neli, ");
INSERT INTO kde_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","na Neli ávele mwana wanga Meliki, na Meliki ávele mwana wanga Adi, na Adi ávele mwana wanga Kosamu, na Kosamu ávele mwana wanga Elimadamu, na Elimadamu ávele mwana wanga Eli, ");
INSERT INTO kde_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","na Eli ávele mwana wanga Yoshuwa, Yoshuwa ávele mwana wanga Eliaseli, na Eliaseli ávele mwana wanga Yalimu, na Yalimu ávele mwana wa Masati, Masati ávele mwana wanga Lawi, ");
INSERT INTO kde_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","na Lawi ávele mwana wanga Simeoni, na Simeoni ávele mwana wanga Yuda, na Yuda ávele mwana wanga Yusufu, na Yusufu ávele mwana wanga Yonamu, na Yonamu ávele mwana wanga Eliakimu, ");
INSERT INTO kde_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakimu ávele mwana wanga Meleya, na Meleya ávele mwana wanga Mena, na Mena ávele mwana wanga Matasa, na Matasa ávele mwa wa Nasani, na Nasani ávele mwana wanga Daudi, ");
INSERT INTO kde_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","na Daudi ávele mwana wanga Yese, na Yese ávele mwana wanga Obedi, na Obedi ávele mwana wanga Boasi, na Boasi ávele mwana wanga Salumoni, na Salumoni ávele mwana wanga Nashoni, ");
INSERT INTO kde_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","na Nashoni ávele mwana wanga Aminadabu, na Aminadabu ávele mwana wanga Adimini, na Adimini ávele mwana wanga Alini, na Alini ávele mwana wanga Hesiloni, na Hesiloni ávele mwana wanga Pelesi, na Pelesi ávele mwana wanga Yuda, ");
INSERT INTO kde_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","na Yuda ávele mwana wanga Yakobo, na Yakobo ávele mwana wanga Isaka, na Isaka ávele mwana wanga Iblahimu, na Iblahimu ávele mwana wanga Tela, na Tela ávele mwana wanga Naholi, ");
INSERT INTO kde_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","na Naholi ávele mwana wanga Selugi, na Selugi ávele mwana wanga Lewu, Lewu ávele mwana wanga Pelegi, na Pelegi ávele mwana wanga Ebeli, na Ebeli ávele mwana wanga Sela, ");
INSERT INTO kde_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","na Sela ávele mwana wanga Kenani, na Kenani ávele mwana wanga Alifakisadi, na Alifakisadi ávele mwana wa Shemu, na Shemu ávele mwana wanga Nuhu, na Nuhu ávele mwana wanga Lameki, ");
INSERT INTO kde_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","na Lameki ávele mwana wanga Mesusela, na Mesusela ávele mwana wanga Henoko, na Henoko ávele mwana wanga Yaledi, na Yaledi ávele mwana wanga Mahalaleli, na Mahalaleli ávele mwana wanga Kenani, ");
INSERT INTO kde_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","na Kenani ávele mwana wanga Enoshi, na Enoshi ávele mwana wanga Seti, na Seti ávele mwana wanga Adamu, na Adamu ávele mwana wanga Nnungu. ");
INSERT INTO kde_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Anepo Yesu nkuuya kuhaloka kumuto wa Yoludani akuno aumbajìjwè Umumu Wanaswe. Aneyo Umumu nkunnodya Yesu kuhwena kulilanga. ");
INSERT INTO kde_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Aneko kulilanga Yesu nkulingwa na Ibilisi kwa maduva alubaini. Mmaduva anelo, Yesu nanga panalile chinu chohecho, na palamalidile maduva anelo, nkuva na indala. ");
INSERT INTO kde_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ibilisi nkunnyaulila Yesu kuchidoni, “Ikàva wako Mwana wanga Nnungu, lihaulile alino liyanga lììve nkate.” ");
INSERT INTO kde_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu nkunnyang'ula kuchidoni, “Ìnilembwa Mmalemba Lanaswe kuva, ‘Munu akambelama chihi kwa kulya nkate.’” ");
INSERT INTO kde_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Anepo Ibilisi nkumpelekeja Yesu kudedu lichinga lilehu, nkunnanguja kwa pamo ufalume wa kila chilambo. ");
INSERT INTO kde_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ibilisi nkunnyaulila Yesu kuchidoni, “Nangu nguchinikwing'e mamulaka la kutawala ufalume anewo wammalele na ukulu wake, kwa kuva, vyammalele vìvele mmakono mwangu, na nangu nahulula kumwing'a munu woheyo unintamwa. ");
INSERT INTO kde_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Bahi ukàngwabudu nangu nguchinikwing'e anevyo vyammalele.” ");
INSERT INTO kde_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu nkunnyang'ula kuchidoni, “Ìnilembwa Mmalemba Lanaswe kuva, ‘Mwabudu Nang'olo Nnungu wako, na kuntumikila chihi nang'e weka.’” ");
INSERT INTO kde_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Bahi Ibilisi nkumpelekeja Yesu ku Yelusalemu, nkunammika kuchisweswe cha muha namene cha Ing'ande ya Nnungu, nkunyaulila kuchidoni, “Ikàva wako Mwana wa Nnungu, liyahe pahi, ");
INSERT INTO kde_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kwa kuva, ìnilembwa Mmalemba Lanaswe kuva, ‘Nnungu àmbekulaijija malaika vakuchunge, ");
INSERT INTO kde_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","na vanang'o vàmbekunyakula mmakono lavo, uchinga unalihumbule kananga madodo lako mmayanga.’” ");
INSERT INTO kde_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Henga Yesu nkunnyang'ula kuchidoni, “Ìnilembwa, ‘Unanninge Nang'olo, Nnungu wako.’” ");
INSERT INTO kde_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Bahi Ibilisi pamalidile kunninga Yesu kwa kila namuna, nkunneka kadiki mpaka pánapàtà wasa unji wa kunninga. ");
INSERT INTO kde_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Anepo Yesu nkuuka kulilanga, nkuhwena kwave ku Galilaya akuno aumbajìjwè dimongo dya Umumu Wanaswe, habali dyake nkuyanjala kila pachinu nchilambo anecho. ");
INSERT INTO kde_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yesu nkuva wavahunda vanu n'ding'ande dyavo dya kunnyuwila Nnungu, na vanu vammalele nkuva uvannombolela. ");
INSERT INTO kde_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Anepo Yesu nkuhwena ku Nasaleti, chijiji chavelekwejije. Palihwikile Liduva lya Kuyewelela, Yesu nkuinjila muing'ande ya kunnyuwila Nnungu, malinga chiunavele nnyambo wake. Nkuimila uchinga avasomele vanu Malemba Lanaswe. ");
INSERT INTO kde_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nkupewa chitabu changa nabii Isaya. Nkuchihunukula, nkutaha pachinu palembwîje uvila, ");
INSERT INTO kde_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Umumu wa Nang'olo àvele pamo na nangu. Kwa kuva, àningutandola nivahubilile amahuvani Malove Lambone. Na àningutuma nivahaulile vafungwa kuva vàmbekombolewa, na vanu vaputêle meho kuva vachivalole. Àningutuma unaveng'a uhulu vanu vabanîhwa, ");
INSERT INTO kde_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","na kuvahaulila vanu kuva mahiku la Nang'olo kulanguja uwambone kwa vanu lànikamola.” ");
INSERT INTO kde_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Anepo Yesu nkuchihinika achila chitabu, nkumwing'a ntumishi wa muing'ande aneyo, nang'e nkuikala. Vanu vammalele vanavele muing'ande ya kunnyuwila Nnungu nkumpalambahija meho. ");
INSERT INTO kde_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Yesu nkuvahaulila kuchidoni, “Alano Malemba, nelo lànitimila pamuchipilikanila.” ");
INSERT INTO kde_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Anepo vanu vammalele nkunnombolela na kukangana ing'anya ya malove la inema lachilatangola, nkuva uvachidoni, “Kwani ayu akee mwana wanga Yusufu?” ");
INSERT INTO kde_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu nkuvahaulila kuchidoni, “Nangu nikee na lipamba kuva muchimunguhaulile nlili auno, ‘N'ganga lilamye umwene!’ Uchocho muchimunguhaulile kuva, ‘Lammalele latupilikene kuva ùnilatenda ku Kapelinaumu, latende na apano penu.’ ” ");
INSERT INTO kde_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yesu nkuhweneha kutangola wachidoni, “Nangu nìnnyaulila uhiu kuva, nanga nabii akubalîka nkaya yake. ");
INSERT INTO kde_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nangu nìnnyaulilanga uhiu kuva, mmahiku langa Eliya, nchilambo cha Isilaeli kúvele na anannidi vohe. Na mmahiku anelo imbula ínihungwa uchinga inatonye kwa uhiku wa vyaka vitatu na myedi sita, bahi nkuva na indala nchilambo chammalele. ");
INSERT INTO kde_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pamo na anelo, Eliya nanga panatumwije kwa anannidi anevo va nchilambo cha Isilaeli. Henga átumwije chihi kwa nannidi wa ku Salepta, nchilambo cha ku Sidoni. ");
INSERT INTO kde_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Na mmahiku langa nabii Elisha, nchilambo cha Isilaeli kúvele na amangundula vohe. Henga álamijwe chihi mmangundula yumo uvanchema Namani wa nchilambo cha ku Siliya.” ");
INSERT INTO kde_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Vanu vammalele vanavele muing'ande ya kunnyuwila Nnungu, nkuvisa namene pavapilikene malove anelo. ");
INSERT INTO kde_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nkuimilanga, nkunnyumya Yesu pawelu imanga yavo inadengwije muha lichinga. Nkumpelekeja mpaka nnyenje likobikobi uchinga vammotohije. ");
INSERT INTO kde_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Henga Yesu nkupita ching'ati likuwa, nkuhwena. ");
INSERT INTO kde_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Bahi Yesu nkuhelela mpaka kuimanga ya ku Kapelinaumu, chilambo cha ku Galilaya. Aneko Yesu nkuva wavahunda vanu kila Liduva lya Kuyewelela. ");
INSERT INTO kde_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Vanu vammalele nkukangana namene namuna chachivahunda, kwa kuva, ávahunda muchi munu avêle na mamulaka. ");
INSERT INTO kde_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na amula muing'ande ya kunnyuwila Nnungu múvele na munu anavele na nanndenga, nkukuta ing'uto wachidoni, ");
INSERT INTO kde_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Aaa! Wako Yesu wa ku Nasaleti ùtulembela chani hwetu? Dachi, ùidile unatuwalala? Nangu ǹnikumala wako. Wako nni Wanaswe wanga Nnungu!” ");
INSERT INTO kde_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu nkunkalipila ayula nanndenga wachidoni, “Nyalala! Mmuke munu ayuno!” Bahi nanndenga nkummatohija ayula munu pahi, muyo mwa vanu, nkummuka bila kummumisa. ");
INSERT INTO kde_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Vanu vammalele nkukangana namene, nkuva uvahaulanila kuchidoni, “Malove alano la namuna ntwani? Kwa kuva, kwa dimongo na mamulaka àvaamulisa anamindenga vauke, na vanang'o vànauka!” ");
INSERT INTO kde_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Bahi habali dyanga Yesu nkupilikanika kila pachinu nchilambo cha ku Galilaya. ");
INSERT INTO kde_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu nkuhuma amula muing'ande ya kunnyuwila Nnungu, nkuhwena kukaya kwanga Simoni uvanchema Petulo. Nkawake Simoni ánauula namene chidumba, bahi nkunnyuwa Yesu annamye mmahe aneyo. ");
INSERT INTO kde_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu nkunnyengelekela ayula mmahe, nkuchiamulisa chidumba chimmuke, na chidumba nkummuka. Upala ayula mmahe nkuimila, nkutandilika kuvahudumila. ");
INSERT INTO kde_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Liduva palichiswa, vanu vammalele vánavele na alangavao vánavele na magonjo la kila namuna, nkumpelekejija Yesu anevo vagonjo. Na Yesu nkuvavikila makono lake vagonjo vammalele, nkuvalamya. ");
INSERT INTO kde_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Anamindenga vánivauka vanu vohe akuno uvataya lwasu uvachidoni, “Wako nni Mwana wanga Nnungu!” Henga Yesu nkuvakalipila anevo anamindenga, na kuvadivila vanatangole kwa kuva, vánimmala kuva nang'e njo Kilisto. ");
INSERT INTO kde_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Liduva lipapete ulyamba na mambumbu, Yesu nkuuka paimanga nkuhwena pachinu pakávele na vanu. Likuwa likulungwa lya vanu nkutandilika untaha. Pavammwene nkulinga kun'divila uchinga anauke. ");
INSERT INTO kde_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Henga Yesu nkuvahaulila kuchidoni, “Ngùlembelewa nguhwene na n'dimanga dinji nikavahubilile vanu Malove Lambone la Ufalume wa Nnungu, kwa kuva, ǹnitumwa kwajili ya anelyo.” ");
INSERT INTO kde_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Bahi Yesu nkuva wavayanjajija vanu Malove Lambone n'ding'ande dya kunnyuwila Nnungu, nchilambo cha ku Yudeya. ");
INSERT INTO kde_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Liduva limo, Yesu áimidile nnyenje Litanda lya Galilaya, akuno likuwa lya vanu lin'dingwike uvagumanagumana uchinga vapilikanile lilove lya Nnungu. ");
INSERT INTO kde_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yesu nkudyona dingalava dimbili divèlè nnyenje litanda. Dingalava anedyo dílekwije na akúupa dihomba vachiûsa miswani n'dinjawu dyavo. ");
INSERT INTO kde_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu nkuinjila muingalava imo ínavele yanga Simoni uvanchema Petulo, nkunnyaulila Simoni aitukuhije mmedi, kulehu kadiki na kunnyangi. Yesu nkuikala, nkuva wahunda likuwa lya vanu akuno aikèlè mwingalava. ");
INSERT INTO kde_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pamalidile kuvahunda vanu, nkunnyaulila Simoni kuchidoni, “Ihengeleje ingalava mpaka pachinu pavêle medi lohe, mukataye dinjawu dyenu, muupe dihomba.” ");
INSERT INTO kde_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoni nkunnyang'ula Yesu kuchidoni, “Nang'olo, tùnitumbama kuupa chilo chammalele ila nanga patupete chinu. Henga kwa kuva ùhawile wako, bahi nguchingutaye dinjawu.” ");
INSERT INTO kde_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Pavatadile dinjawu, nkuupa dihomba dyohe namene, mpaka dinjawu dyavo kutandilika kukaduka. ");
INSERT INTO kde_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Bahi nkuvakapila avao vanavele muingalava inji uchinga vaide vakavayangate. Vanang'o nkuidananga, nkuumbajanga dihomba n'dingalava dyammalele dimbili, mpaka dingalava kutandilika kutitimila. ");
INSERT INTO kde_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Bahi Simoni uvanchema Petulo palawene anelo lahumidile, nkuhunama muyo mwa Yesu nkuchidoni, “Nang'olo, linyemye na nangu! Kwa kuva, nangu nni munu nguvêle na masambi!” ");
INSERT INTO kde_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simoni átangwele uchocho ing'anya nang'e na avake vammalele vánikangana namene ing'anya ya kuupa dihomba dyohe. ");
INSERT INTO kde_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Yakobo na Yohana vana vanga Sebedayo, vanavele vakúupa avake Simoni, na vanang'o vánikangana. Yesu nkunnyaulila Simoni kuchidoni, “Unayope, kwa kuva kutandikila vino wako ùmbekuva uvaupìlà vanu kwanga Nnungu.” ");
INSERT INTO kde_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Anepo nkuutangila dingalava dyavo mpaka kunyenje litanda, nkulekanga kila chinu, nkumpapata Yesu. ");
INSERT INTO kde_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu pánavèlè muimanga imo ya chilambo cha ku Galilaya, nkuida munu yumo anavele na mangundula mmili wammalele. Pammwene Yesu, nkuhunama pamadodo langa Yesu nkunnyuwa wachidoni, “Nang'olo, wako ukàlembela unahulula chihi unguhahulanga kwa kungulamya.” ");
INSERT INTO kde_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu nkunyoloja nkono wake nkun'gusa, nkunnyaulila kuchidoni, “Elo nalembela, lama. Hahuka mwalehu!” Upala mangundula nkummuka. ");
INSERT INTO kde_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Bahi Yesu nkumwamulisa ayula munu kuchidoni, “Unannyaulile munu woheyo, henga hwena ukalilanguje kwa kuhani na uhumye sadaka ya kuhahulwa kwako malinga chalaijije Musa, uchinga vanu vamale kuva ùnihahulwa.” ");
INSERT INTO kde_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Henga habali dyanga Yesu nkuhalija kuyanjala kila pachinu. Makuwa lohe la vanu nkuidang'ana unampilikanila na kulamywa magonjo lavo. ");
INSERT INTO kde_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Henga myanda yohe Yesu ánalinyemya na anevo vanu wahwena pachinu pakavele vanu, wayuwa. ");
INSERT INTO kde_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Liduva limo Yesu ávenkuhunda. Mafalisayo na vakúhunda Sheliya vánahaleke mmijiji vyammalele vya nchilambo cha ku Galilaya na ku Yudeya na imanga ya Yelusalemu, vammalele vávele upala. Na Yesu ávalamya vagonjo kwa dimongo dya Nang'olo. ");
INSERT INTO kde_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Upala nkwida vanu vannyakwìlè munu adidimênge, akuno alèlè nchinanda. Nkulinga kutaha nafasi ya kumwingija uchinga vakammike pachinu pávèlè Yesu. ");
INSERT INTO kde_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Bahi ing'anya vanu vávele vohe, nanga pavanapete nafasi ya kumwingija nkati. Vanu anevo nkukwela nawe muha ing'ande, nkuvimbula pachinu, nkunsulupusa nchinanda mpaka ching'ati likuwa lya vanu, pachinu pávèlè Yesu. ");
INSERT INTO kde_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu paiwene ing'ulupa yavo, nkunyaulila ayula munu adidimênge kuchidoni, “Nnyanjawangu, ùnisamehewa masambi lako.” ");
INSERT INTO kde_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Vakúhunda Sheliya na Mafalisayo nkutandilika kuujana vene kwa vene uvachidoni, “Ayu ni munu wa namuna ntwani ankufûlu Nnungu? Nnani ahulûla kunsamehe munu masambi ikànave chihi Nnungu weka?” ");
INSERT INTO kde_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Henga Yesu ánilamala lavachitangodikanga, nkuvauja kuchidoni, “Ing'anya ntwani mùtangodikanga uchocho mmitima yenu? ");
INSERT INTO kde_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Lilida lipeyapeya namene, kuhaula kuva, ‘Ùnisamehewa masambi lako,’ au kuhaula, ‘Imila uhwene?’ ");
INSERT INTO kde_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Bahi nangu ngùlembela ngumaihe kuva, Mwana wa Munu àvele na mamulaka la kuvasamehe vanu masambi lavo apano pachilambo.” Anepo nkunnyaulila ayula adidimênge kuchidoni, “Nìkuhaulila, imila, utwale chinanda chako, uhwene kukaya!” ");
INSERT INTO kde_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Upala ayula munu adidimênge nkuimila muyo mwavo, nkutwala chinanda chake, nkuhwena kukaya kwake, akuno wannombolela Nnungu. ");
INSERT INTO kde_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Vanu vammalele nkukangana namene! Nkuyopa na kunnombolela Nnungu uvachidoni, “Nelo tùviwene vitukutuku vya kukanganya.” ");
INSERT INTO kde_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Palamalilike anelo, Yesu nkuhuma pawelu nkumwona nkútwala kodi yumo lina lyake Lawi aikèlè paing'ande ya kulipila kodi. Yesu nkunnyaulila kuchidoni, “Ngupapate!” ");
INSERT INTO kde_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lawi nkuimila, nkuleka kila chinu, nkumpapata. ");
INSERT INTO kde_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Bahi Lawi nkuntendela Yesu ing'ole ing'ulu kuing'ande yake. Na likuwa likulu lya vakútwala kodi pamo na vanu vanji nkuikala pamo na Yesu uvalya nawe. ");
INSERT INTO kde_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Henga Mafalisayo na vakúhunda vao va Sheliya, nkuva uvavatongodikila vakuhundwa vanga Yesu uvachidoni, “Ing'anya ntwani mùnalya na kukumbila pamo na vakútwala kodi na vanu vavêle na masambi?” ");
INSERT INTO kde_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu nkuvayang'ula kuchidoni, “Vanu vakáuula nanga pavannembela n'ganga, ila vanu vauûla njo vannembêla n'ganga. ");
INSERT INTO kde_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nangu nikáidile unavachema vanu vatênda àlalá lalalembela Nnungu, henga ngùidile unavachema vanu vavêle na masambi uchinga vapate kulaleka masambi lavo.” ");
INSERT INTO kde_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Vanu fulani nkunnyaulila Yesu kuchidoni, “Vakuhundwa vanga Yohana Nkúbatisa myanda yohe vànafunga na kuyuwa, ata vakuhundwa va Mafalisayo navanang'o vàtenda uchocho, henga vakuhundwa vako, vàlya chihi na kukumbila!” ");
INSERT INTO kde_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu nkuvayang'ula kuchidoni, “Dachi, ìnahululika kuvatenda vanu vakumbuliwîjwe kuing'ole ya ulombi vafunge wakati mwene nnombi avenavo pamo? Ikáhululika. ");
INSERT INTO kde_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Henga mahiku lachilakamole nnombi pambetwaliwa muvanang'o, anepo njo pavambefunga.” ");
INSERT INTO kde_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu nkuvahaulila nfano kuchidoni, “Nanga munu apapûla chilaka muinguwo yahambi nkutotela muinguwo yatangu. Akàtenda uchocho, àmbeyondonga inguwo yahambi, na chilaka cha inguwo yahambi chikambekwendana na inguwo aneyo yatangu. ");
INSERT INTO kde_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Uchocho, wala nanga munu atâya divayi dyahambi mmipatila ya tangu ya limbende. Akàtenda uchocho, anedyo divayi dyahambi dìmbeipapula aneyo mipatila, na divayi dìmbemwadilika, na mipatila ìmbekwondongeka. ");
INSERT INTO kde_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Henga divayi dyahambi dìlembelewa ditaywe mmipatila yahambi. ");
INSERT INTO kde_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Na wala nanga munu akumbîla divayi dya tangu koka nkulambela kavila divayi dyahambi. Kwa kuva, àhaula kuva, adila dya tangu nni dyambone namene.” ");
INSERT INTO kde_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Liduva limo lya Kuyewelela, Yesu nkuva wapita n'dindila dya mmawelu la ngano chalumo na vakuhundwa vake. Vakuhundwa vake nkutandilika kupulula ngano, uvaitinginda na makono lavo na kutang'una. ");
INSERT INTO kde_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Henga Mafalisayo vanji nkuvauja kuchidoni, “Mwadachi mùtenda vitukutuku vikáluhusiwa na Sheliya ya Musa kutendwa Nniduva lya Kuyewelela?” ");
INSERT INTO kde_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu nkuvayang'ula kuchidoni, “Dachi, mwenu nanga pamusomile chanatendile Nfalume Daudi na vavake pavanavele na indala? ");
INSERT INTO kde_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Daudi áingidile pa Ing'ande ya Nnungu, nkutwala mikate ihumîjwe kwa Nnungu nkulya, nkuveng'a na avake navanang'o nkulya, wakati Sheliya ya Musa ìluhusu chihi mikate aneyo kuliwa chihi na makuhani weka.” ");
INSERT INTO kde_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesu nkuvahaulila kuchidoni, “Mwana wa Munu njo Nang'olo avêle na mamulaka ata Nniduva lya Kuyewelela.” ");
INSERT INTO kde_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Liduva linji lya Kuyewelela, Yesu nkuhwena muing'ande ya kunnyuwila Nnungu, nkuva wahunda. Na amula nkati múvele na munu anadidimenge nkono wa kunkono. ");
INSERT INTO kde_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Vakúhunda Sheliya pamo na Mafalisayo vátaha ing'anya ya kunsitaki Yesu. Bahi nkuva uvannoleha uchinga vamale ikàva àmbennamya munu Nniduva lya Kuyewelela. ");
INSERT INTO kde_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Henga kwa kuva Yesu ánimala lavachiliuja avala vanu, nkunnyaulila ayula munu avêle na nkono udidimênge kuchidoni, “Takatuka, ida uimile muyo.” Ayula munu nkutakatuka, nkunaimila muyo mwa vanu. ");
INSERT INTO kde_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Anepo Yesu nkuvahaulila kuchidoni, “Nangu nìmmujanga mwenu kuva, dachi Sheliya yetu ìnatuluhusu kutenda lambone au lahakalenge Nniduva lya Kuyewelela? Dachi, ìnatuluhusu kumpoha munu au kummwalala?” ");
INSERT INTO kde_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesu nkuvapalambahija meho vanu vammalele vanapwawije apala, koka nkunnyaulila ayula munu kuchidoni, “Nyoloja nkono wako.” Nang'e nkunyoloja, na nkono wake nkuva umi. ");
INSERT INTO kde_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Henga vanu nkusunala namene, nkuujana ding'ano namuna chivambentendela Yesu. ");
INSERT INTO kde_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mmaduva ulolo, Yesu nkuhwena kulichinga unayuwa, aneko nkucheja wannyuwa Nnungu. ");
INSERT INTO kde_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ulyamba wake, Yesu nkuvachema vakuhundwa vake, nkuvatandola vanu kumi na mbili kuhaloka nnikuwa lya vakuhundwa, nkuvachema kuva mitume. ");
INSERT INTO kde_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Vanu anevo vanavatandwele Yesu nni Simoni wananchemile Petulo, na Anduleya nnung'une Simoni na Yakobo na Yohana na Filipo na Batolomayo, ");
INSERT INTO kde_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","na Matayo na Tomaso na Yakobo mwana wanga Alufayo na Simoni achichemwa Nselote, ");
INSERT INTO kde_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","na Yuda mwana wanga Yakobo chalumo na Yuda Isikaliote, anantengeleke Yesu. ");
INSERT INTO kde_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Bahi Yesu nkusulupuka nnichinga chalumo na mitume vake, nkunaimila pachinu pavêle tambalale. Na pachinu anepo pávele na likuwa likulungwa lya vakuhundwa vake pamo na mmuluku wa vanu vanahaleke nchilambo chammalele cha ku Yudeya na kuimanga ya Yelusalemu, na kuhaloka nchilambo cha Tilo na Sidoni, chilambo chivêle nnyenje bahali. ");
INSERT INTO kde_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Vanu anevo váidile unampilikanila Yesu na kulamywa magonjo lavo. Na vanu vachibanîhwa na anamindenga, navanang'o vániida nkulamywa. ");
INSERT INTO kde_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Na kila munu ánatumbama uchinga an'guse Yesu, ing'anya dimongo dya Nnungu dínannyuma na kuvalamya vanu vammalele. ");
INSERT INTO kde_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu nkuvalola vakuhundwa vake, nkuchidoni, “Wasa mwenu mmamahuvani, kwa kuva, Ufalume wanga Nnungu ni wenu! ");
INSERT INTO kde_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Wasa mwenu muvêle na indala hambi, kwa kuva, muchimusibe! Wasa mwenu mukûta hambi, kwa kuva, muchimuheke kwa kuhangalala. ");
INSERT INTO kde_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Wasa mwenu, vanu pavambemmenganga na kulinyemya na mwenu, pavambentangolelanga malove lahakalenge na kuhakajanga malina lenu ing'anya yanga Mwana wa Munu. ");
INSERT INTO kde_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mambo anelo palambehumila, hangalala na kuvina, ing'anya inujo yenu ing'ulungwa ìnivikwa kulihunde. Kwa kuva, uvila nni anyakala vao chivanavatendile manabii. ");
INSERT INTO kde_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Henga ole wenu mwenu mmakupata, kwa kuva, tayali mùnitujwa mitima yenu! ");
INSERT INTO kde_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ole wenu mwenu musibîle hambi, kwa kuva, mùmbekuva na indala. Ole wenu mwenu muhêka hambi, kwa kuva, mùmbekuta na kulikutangila. ");
INSERT INTO kde_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ole wenu vanu vammalele vakànnombolelanga! Kwa kuva, uvila njo anyakala vao chivanavatendedile manabii va kulambila!” ");
INSERT INTO kde_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Henga nangu nìnnyaulilanga mwenu mungupilikanîla kuva, vatamwange amongo mwenu. Na muvatendele lambone vanu vammengânga. ");
INSERT INTO kde_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Vayuwile lambone avala vanlâni mwenu, na muvayuwile avala vantendelânga lahakalenge. ");
INSERT INTO kde_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Munu akàkupanya likofi nnibuda limo, uchocho nneke akupindikulile na libuda lya vili. Na munu akàkupakanyola likoti lyako, uchocho nneke atwale na nkogo wako mwalehu. ");
INSERT INTO kde_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Munu woheyo akàkuyuwa chinu mwing'e, na munu akàkupakanyola vitukutuku vyako, unayuwe akuuyihije. ");
INSERT INTO kde_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Chimulembela vanu vantendele mwenu, na mwenu vatendele vanang'o uchocho. ");
INSERT INTO kde_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ikàva mùvatamwa chihi vanu vantamwânga mwenu, dachi, mùmbepata inujo ntwani kwa Nnungu? Kwa kuva, ata vanu vavêle na masambi vàvatamwa vanu vavatâmwa vanang'o. ");
INSERT INTO kde_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Na mwenu mukàvatendela chihi lambone vanu avala vantendêla mwenu lambone, dachi mùmbepata inujo ntwani kwa Nnungu? Kwa kuva, ata vanu vavêle na masambi navanang'o vàtenda uchocho avao. ");
INSERT INTO kde_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Na ikàva mùvakopesa chihi avala vamuvalolela kuva vachivannipange, dachi mùmbepata inujo ntwani kwa Nnungu? Kwa kuva, ata vanu vavêle na masambi navanang'o vàvakopesa avao akuno uvalolela kuuyihijwa achila chivavakopesije. ");
INSERT INTO kde_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Henga mwenu vatamwange amongo mwenu, vatendele lambone, na mukàvakopesa munalolele kuuyihijwa achila chimuvakopesije. Anepo njo inujo yenu paimbekuva ing'ulu kwa Nnungu, na njo pamumbekuva mmana mma Nnungu Nkulu, kwa kuva, nang'e nni wambone kwa vanu vakávele na shukulani na vatênda lahakalenge. ");
INSERT INTO kde_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Bahi mùùve na chididi muchi Atata wenu chavele na chididi.” ");
INSERT INTO kde_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Munavahukùmù vanu vanji na Nnungu akambennyukumu mwenu. Munavaambe vanu vanji, na Nnungu akambemwamba mwenu. Muvasamehe vanu vanji, na Nnungu achiansamehe mwenu. ");
INSERT INTO kde_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Veng'ange vanu vanji vitukutuku vivasikikidile, na Nnungu achiamwing'ange mwenu. Muchimupwechele chipimo chambone namene, chichinyiwîje na kutikwa, chiombêle mpaka kupakatika. Kwa kuva, chipimo uchila chimupimila kuveng'a vanu vanji, njo uchocho chambetumila Nnungu kumpimila mwenu.” ");
INSERT INTO kde_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Anepo Yesu nkuvahaulila nfano auno kuchidoni, “Dachi, munu aputêle meho ànahulula kunnodya nnyake aputêle meho? Dachi, vammalele vavili vakambematokela nnipondo? ");
INSERT INTO kde_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nkúhundwa akáva nkulu kumpunda nkúhunda wake, henga kila nkúhundwa akàmalila kulihunda kwake, ààva muchi nkúhunda wake. ");
INSERT INTO kde_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Mwadachi ùuloleha nswani uvêle nniso lya nnung'uno, akuno lukongolo luvêle nniso lyako ukalwònà? ");
INSERT INTO kde_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Au ùmbehulula dachi kunnyaulila nnung'uno kuchi, ‘Nnung'unwangu, nahoti nikuuse chipatu nniso lyako,’ akuno umwene ukálwònà lukongolo luvêle nniso lyako? Nkúlilambilila wako! Tandilika kuluusa lukongolo luvêle nniso lyako nahoti, na anepo njo pumbelola saana na kuchiusa chipatu chivêle nniso lya nnung'uno.” ");
INSERT INTO kde_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Wala nanga nnandi wambone ûpa vihepo vikee vyambone, na wala nanga nnandi ukee wambone ûpa vihepo vyambone. ");
INSERT INTO kde_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Na kila nnandi ùmaikana kwa vihepo vyake. Vanu nanga pavahepa tini n'diheya, na wala nanga pavahepa zabibu mmbigili. ");
INSERT INTO kde_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Munu wambone àhumya vitukutuku vyambone kuhaloka muvyambone vyakondije muntima wake wambone, na munu akávele wambone àhumya vitukutuku vikee vyambone kuhaloka muvitukutuku vikee vyambone vyakondije muntima wake ukee wambone. Kwa kuva, munu àtangola àlalá laombêle muntima wake.” ");
INSERT INTO kde_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Mwadachi mùnguchema nangu, ‘Nang'olo, Nang'olo,’ akuno mukatèndà àlalá laninnyaulila mulatende? ");
INSERT INTO kde_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Munu woheyo aîda kwang'une, nkupilikanila mahundo langu na kutenda chalembelewa atende, ");
INSERT INTO kde_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","munu aneyo àlandana na munu adengîle ing'ande yake saana. Áhimbile lipondo lilehu lya nsingi mpaka nniyanga likulungwa, nkudenga nsingi wa ing'ande aneyo nniyanga anelyo. Paliidile livambwe, medi nkuiguma namene aneyo ing'ande henga nanga palanahulwile kananga kuitikinya ing'anya ínitandeka. ");
INSERT INTO kde_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Henga munu apilikâna mahundo langu koka anatende chalembelewa atende, aneyo àlandana na munu akádengile saana ing'ande yake. Nang'e nanga panahimbile lipondo lya nsingi, ila ádengile chihi muha ulongo. Livambwe paliidile, medi nkuiguma aneyo ing'ande, upala nkulinduka na kwondongeka mwalehu!” ");
INSERT INTO kde_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu pamalidile kutangola anelo kwa vanu, nkuhwena ku Kapelinaumu. ");
INSERT INTO kde_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Aneko kúvele na nkulu yumo wa matiyala myamoja la Valoma, ánavele na ntumishi wake wachimweshimu namene, na aneyo ntumishi ánapwateka namene pepi na kuhwa. ");
INSERT INTO kde_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ayula nkulu wa matiyala papilikene habali dyanga Yesu, nkuvalaija vasele va Vayahudi vakannyuwe Yesu aide akannamye ntumishi wake. ");
INSERT INTO kde_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pavakamwele kwanga Yesu, nkunnyuwa namene uvachidoni, “Ayu munu ànavaikila wako unnyangate, ");
INSERT INTO kde_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ing'anya ànavatamwa namene vanu vetu na njo atudengedîle ing'ande ya kunnyuwila Nnungu.” ");
INSERT INTO kde_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Bahi Yesu nkuuka chalumo na anevo vanu. Henga pánavele pepi na ing'ande yanga nkulu wa matiyala, ayula nkulu nkuvalaija ayanjavake vakannyaulile Yesu kuchidoni, “Nang'olo unalihopeje kwida akuno. Nangu wala nikáfala kukupwechelela wako nng'ande mwangu, ");
INSERT INTO kde_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","na ngùlyona kuva nikáfala kukwidila wako. Henga wako tangola chihi lilove na ntumishi wangu achialame. ");
INSERT INTO kde_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kwa kuva, ata nangu nimwene nni munu nguvêle pahi pa mamulaka la vakulu, na pàvele na matiyala vavêle pahi pangu. Nikànnyaulila yumo kuchi, ‘Hwena!,’ ànahwena. Na nikànnyaulila yunji kuchi, ‘Ida!,’ ànaida. Na nikànnyaulila ntumishi wangu kuchi, ‘Tenda achino!,’ ànatenda.” ");
INSERT INTO kde_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Bahi Yesu papilikene anelo malove, nkunkangana namene ayula munu, nkupindikuka nkulilola likuwa lya vanu lichinnondola nkuvahaulila kuchidoni, “Nangu nìnnyaulilanga uhiu kuva, nikánambimwona munu muvanu va Isilaeli avêle na ing'ulupa ing'ulungwa malinga ayi!” ");
INSERT INTO kde_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Bahi avala vanu vanatumwije kwanga Yesu, pavauyite kukaya kwanga nkulu wa matiyala, nkunkoja ayula ntumishi avèlè mumi. ");
INSERT INTO kde_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Bada ya anelo, Yesu nkuhwena imanga imo ivachema Naini, vakuhundwa vake na likuwa lya vanu nkunnondola. ");
INSERT INTO kde_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Pánavele pepi na nnango wa kuinjilila muimanga aneyo, nkuhaloka vanu vanyakwìlè ntuhi wa kijana ánavele mwana wa weka wa nannidi. Na likuwa lya vanu vohe va imanga aneyo vávele chalumo na mmahe aneyo. ");
INSERT INTO kde_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nang'olo Yesu pammwene ayula nannidi nkummikila chididi, nkunnyaulila kuchidoni, “Unakute.” ");
INSERT INTO kde_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Anepo Yesu nkuhengelekela, nkuchigusa chinanda chivanyakulidile ntuhi, na avala vanachinyakwile nkuimila. Yesu nkuchidoni, “Kijana, nikuhaulila takatuka!” ");
INSERT INTO kde_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Bahi ayula kijana anahwile nkutakatuka, nkuikala na kutandilika kutangola. Anepo Yesu nkunkamuja ayula kijana kwa anyokwe. ");
INSERT INTO kde_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Vanu vammalele nkuyopa, nkunnombolela Nnungu, uvachidoni, “Nabii nkulu wanga Nnungu àidile kwetuhwe. Nnungu àidile unavayangata vanu vake.” ");
INSERT INTO kde_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Habali dya kijana aneyo nkupilikanika nchilambo chammalele cha ku Yudeya, na vilambo vyammalele vya pepi. ");
INSERT INTO kde_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Vakuhundwa vanga Yohana Nkúbatisa nkunnyaulila Yohana habali dya vitukutuku vyammalele vyachitenda Yesu. Anepo Yohana nkuvachema vakuhundwa vake vavili, ");
INSERT INTO kde_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","nkuvalaija vahwene kwanga Nang'olo Yesu vakammuje kuchidoni, “Dachi, wako njo ayula Mpohi ahaulîka kuva àvenkwida au tunnolele yunji?” ");
INSERT INTO kde_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Avala vanu pavahwikile kwanga Yesu nkunnyaulila kuchidoni, “Yohana Nkúbatisa ànitulaija tukakuuje kuva, ‘Dachi, wako njo ayula Mpohi ahaulîka kuva àvenkwida au tunnolele yunji?’ ” ");
INSERT INTO kde_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Uhiku uwowo, Yesu ávenkuvalamya vanu vohe vánavele na magonjo na vachihuvanga na vachibanihwa na anamindenga, na kuvalamya vanu vaputêle meho. ");
INSERT INTO kde_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Bahi Yesu nkuvayang'ula vakuhundwa vanga Yohana kuchidoni, “Hwena mukannyaulile Yohana lammalele lamulawene na kulapilikana, vanu vaputêle meho vàvenkulola na vikwavi vìvenkuhwena na amangundula vànalama na anammwidi hambi vàvenkupilikana na vanu vahwîle vànafufuka na amahuvani vànahubiliwa Malove Lambone. ");
INSERT INTO kde_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Wasa munu ayula akáleka kungukulupila nangu ing'anya ya àlalá langulatenda!” ");
INSERT INTO kde_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Vakuhundwa vanga Yohana pavaukile, Yesu nkutandilika kuhaulila makuwa la vanu habali dyanga Yohana wachidoni, “Dachi, pamupite kulilanga unannola Yohana, múlolela muchone chani? Dachi, mútenda àmbekuva muchi imbalu itikînywa na mpapa? Nanga! ");
INSERT INTO kde_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Bahi ikànave uchocho, vino mwapite unalola chani? Dachi, mwapite unannola munu awête dinguwo dikatapêle? Nanga akee uchocho! Vanu vawâla dinguwo dikatapêle na kupoka, vàikala n'ding'ande dya chifalume. ");
INSERT INTO kde_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Bahi nguhaulile, mwapite unalola chani? Dachi, mwapite unannola nabii? Elo! Henga nangu nìnnyaulilanga kuva, umummwene ni nkulu kumpunda nabii. ");
INSERT INTO kde_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yohana njo n'jumbe achiyambwa Mmalemba Lanaswe, Nnungu pachihaula kuchidoni, ‘Nangu nìmbentuma n'jumbe wangu akulongolelee, aneyo njo ambekukatapajîja indila yako.’” ");
INSERT INTO kde_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu nkuyenjeja kutangola kuchidoni, “Muvanu vavelekwejîje na mmahe, nanga munu nkulu kumpunda Yohana Nkúbatisa. Henga ayula avalangîwa kuva n'joko kupunda vammalele mu Ufalume wanga Nnungu, aneyo njo nkulu kumpunda Yohana Nkúbatisa.” ");
INSERT INTO kde_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Vanu vammalele na ata vakútwala kodi pavapilikene malove la Yesu, nkukubali kuva, makudungilo la Nnungu nni lambone kwa kubatiswa na Yohana. ");
INSERT INTO kde_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Henga Mafalisayo na vakúhunda Sheliya vánilahita makudungilo la Nnungu kwamba vanang'o kwa kuhita kubatiswa na Yohana. ");
INSERT INTO kde_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu nkuhweneha kutangola kuchidoni, “Nivalandanye na chani vanu va chívelèkwà achino? Vanu ava vàvele muchi chinu ntwani? ");
INSERT INTO kde_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Vàlandene na vavana vaikalênge kusakoni uvahaulanila vene kwa vene kuva, ‘Twanimwombelanga vimbeta, henga nanga pamunavinite! Twaniimba dihimu dya kulikutangila, henga nanga pamunakutile!’ ");
INSERT INTO kde_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kwa kuva, Yohana Nkúbatisa àniida, nang'e àjukile chihi munu wa kufunga-funga na wala akákumbila divayi, henga mwenu mùhaula kuva, ‘Yohana àvele na nanndenga!’ ");
INSERT INTO kde_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Henga Mwana wa Munu àniida, analya na kukumbila, henga mwenu mùhaula kuva, ‘Ayu munu nni nkúlya uwamba na nkúkalewa, nnyanjawavo vakútwala kodi na vanu vavêle na masambi!’ ");
INSERT INTO kde_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Henga lúnda lwa Nnungu lùmaihwa kuva lwambone kupitila vitendo vya vanu vammalele vavêle na lúnda anelwo.” ");
INSERT INTO kde_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Munu yumo Nfalisayo nkunkumbula Yesu kukaya kwake akalye chakulya cha lyulo chalumo nanang'e. Bahi Yesu nkuhwena kuing'ande kwanga ayula Nfalisayo, nkuikala na kulya chakulya. ");
INSERT INTO kde_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Muimanga aneyo múvele na mmahe yumo nkútenda masambi. Mmahe aneyo papilikene kuva Yesu àvenkulya muing'ande yanga ayula Nfalisayo, ániida akuno anyakwìlè chupa chikatapele namene chikatapajîjwe kwa mayanga la alabasta cha mahuta lanung'ila namene. ");
INSERT INTO kde_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nkuhwena unahunamila mmadodo langa Yesu wakuta, akuno mihodi yake uimatokela mmadodo langa Yesu, na kulapukutanga madodo langa Yesu kwa ulindo wake na kulabusu na kulapaka mahuta lanung'ila namene. ");
INSERT INTO kde_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ayula Nfalisayo ankumbwîle Yesu palawene anelo latendêka, nkuva watangola chimunda-munda kuva, “Ayu munu akàchiva nabii wa Nnungu akanimmala ayu mmahe ankwâha kuva nni munu wa namuna ntwani. Akanimala kuva nni munu avêle na masambi.” ");
INSERT INTO kde_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu nkunnyaulila aneyo Nfalisayo kuchidoni, “Simoni, ngùvele na chinu cha kukuhaulila.” Simoni nkuyang'ula kuchidoni, “Aya nkúhunda, nguhaulile.” ");
INSERT INTO kde_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu nkutandilika kutangola wachidoni, “Pávele na vanu vavili vanayadike dihela kwanga munu ayadikîsa dihela. Munu yumo áyadike dihela dihwikîla nshahala wa mwaka umo na myedi sita, na munu yunji áyadike dihela dihwikîla nshahala wa mwedi umo na majuma matatu. ");
INSERT INTO kde_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Vammalele vavili wala yumo anahulwile kulipa dihela dyanayadike, nang'e nkuvasamehe. Dachi, kati ya anevo vanu vavili, alida ambentâmwa namene ayula munu anavayadikisije dihela?” ");
INSERT INTO kde_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni nkuyang'ula kuchidoni, “Nangu ngwòna kuva, ayula uvansamehite dihela dyohe njo ambentâmwa namene.” Yesu nkunnyaulila kuchidoni, “Elo, ùniyang'ula saana.” ");
INSERT INTO kde_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Anepo Yesu nkunnaukila ayula mmahe, nkunnyaulila Simoni kuchidoni, “Ùvenkumwona ayu mmahe? Nangu ngùidile nng'ande mwako, henga ukáning'ile medi la kukalava mmadodo langu, ila ayu mmahe ànilakalavya madodo langu kwa mihodi yake na kulayumya kwa ulindo wake. ");
INSERT INTO kde_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wako ukángupwechedile kwa kungubusu nnibuda, henga ayu mmahe, kutandikila panguingidile, akánaleka kulabusu madodo langu. ");
INSERT INTO kde_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wako nanga paungupakile mahuta mmuti mwangu, henga ayuno mmahe àningupaka mahuta la kunung'ila mmadodo langu. ");
INSERT INTO kde_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Bahi ing'anya ya anelyo, nangu nìkuhaulila kuva, itamwi ing'ulu yalangujije ayu mmahe ìmaiha kuva Nnungu àninsamehe masambi lake lohe. Henga munu ayula uvansamehite mambo kadiki, àtamwa chihi kadiki.” ");
INSERT INTO kde_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Anepo Yesu nkunnyaulila ayula mmahe kuchidoni, “Masambi lako lànisamehewa.” ");
INSERT INTO kde_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Bahi vanu vanji vanavele pachakulya chalumo na Yesu nkutandilika kuujana vene kwa vene uvachidoni, “Ayu munu ntwani mpaka ahulule kusamehe masambi?” ");
INSERT INTO kde_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesu nkunnyaulila ayula mmahe kuchidoni, “Ing'ulupa yako ìnikupoha. Hwena kwa amani.” ");
INSERT INTO kde_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Bahi palamalilike anelo, Yesu nkuhwena n'dimanga na mmijiji wayanjaja Malove Lambone layâmba Ufalume wa Nnungu. Na vakuhundwa vake kumi na mbili vánipapatana nawe. ");
INSERT INTO kde_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Na amahe vanji vanausijwe anamindenga na Yesu na kulamywa magonjo navanang'o vánipapatana nawe. Amahe anevo nni chalumo na Maliya wa imanga ya ku Magidala anausijwe anamindenga saba, ");
INSERT INTO kde_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","na Susana na Yoana n'jawe Kusa, Kusa ánavele nkwímilila dimali dyanga Helode, na amahe vanji vohe. Amahe anevo vánnyudumila Yesu na vakuhundwa vake kwa dimali dyavo. ");
INSERT INTO kde_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Vanu vohe kuhaloka kila imanga nkummwenela Yesu. Likuwa lya vanu palikojene pamo, Yesu nkuvahaulila nfano auno wachidoni, ");
INSERT INTO kde_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Nkúpanda ápite unapanda dimbeyu. Pánavèlè nkumyaya dimbeyu mmwelu, dinji nkumatokela nndila. Vanu nkudilivata, na vyuni nkudidadola. ");
INSERT INTO kde_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Dimbeyu dinji nkumatokela mmayanga muvêle ulongo kadiki, padimedile mitipu nkuyuma ing'anya muulongo mukanavele medi. ");
INSERT INTO kde_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Dinji nkumatokela ching'ati miva. Mitipu nkukulumuka chalumo na miva. Miva nkuidingila aila mitipu na kuiwalala. ");
INSERT INTO kde_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Dimbeyu dinji nkumatokela pavêle ulongo wa matapata, mitipu nkumela na kukulumuka, nkupundiha kupa, myanda myamoja kupunda adila dipandwîje.” Bahi Yesu pamalidile kuvahaulila anelo lammalele, nkunonoha lidi wachidoni, “Munu avêle na makutu la kupilikana, apilikane!” ");
INSERT INTO kde_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Vakuhundwa vake nkummuja Yesu mana la aula nfano. ");
INSERT INTO kde_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nang'e nkuvayang'ula kuchidoni, “Mwenu mùnijaliwa kudimala disili dya Ufalume wa Nnungu. Henga kwa vanu vanji ngùtangola kwa mifano uchinga, ‘Ikànava vànalola, vanachone chinu, na ikànava vànapilikana, vanamale chinu.’ ");
INSERT INTO kde_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Bahi aino njo mana ya anewo nfano. Adila dimbeyu dipândwa dìlandanywa na lilove lya Nnungu. ");
INSERT INTO kde_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Vanu vanji vàlandanywa na hali ya nndila, amula mudimatokedile adila dimbeyu. Vanu anevo vànalipilikana lilove lya Nnungu, henga Ibilisi ànaida nkuliusa anelyo lilove mmitima yavo, wachinga vanakulupile nkupohwa. ");
INSERT INTO kde_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Na vanu vanji vàlandanywa na hali ya pachinu pavêle mayanga-mayanga, apala padimatokedile adila dimbeyu. Vanu anevo vànalipilikana lilove lya Nnungu na kulipwechelela kwa kuhangalala, henga nanga palitita mmitima yavo muchi chiditita dinyiya muulongo. Vàlikulupila chihi kwa uhiku kadiki lilove anelyo, henga pavalingwa, vànalileka. ");
INSERT INTO kde_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Na vanu vanji vàlandanywa na hali ya mmiva, amula mudimatokedile adila dimbeyu. Anevo vanu vanalipilikana lilove lya Nnungu, henga ing'anya ya kukambikambila namene mambo la maisha na kupoka na dimali dya pachilambo, mambo anelo lànavabana na nanga pavapa vihepo vitandêke. ");
INSERT INTO kde_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Na vanu vanji vàlandanywa na hali ya pachinu pavêle ulongo wa matapata. Vanu anevo vàvele na ntima wambone na wa kupilikana. Vànalipilikana na kulikamulila anelyo lilove na kupa vihepo kwa kupililila.” ");
INSERT INTO kde_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Nanga munu achâcha chibatali nkuchihinika na chombo fulani au kuchivika paliungu chinanda. Henga àchivika muha chipanda uchinga vanu vainjîla nng'ande vawone nng'anje. ");
INSERT INTO kde_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kwa kuva, chinu chohecho chipihîjwe chìmbepihuliwa, na chinu chohecho chihinikwîje chìmbehunukulwa na kuvikwa palangele. ");
INSERT INTO kde_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Bahi lyongolelange saana namuna chimupilikanila lilove lya Nnungu. Kwa kuva, munu avêle na chinu àmbeyenjejwa vinji, henga munu akávele na chinu ata achila chátèndà kuva ànivanacho àmbepokonyolwa.” ");
INSERT INTO kde_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Anyokwe Yesu chalumo na anung'unuvake vániida unannola, henga nanga pavanahulwile kuhwika pepi nanang'e ing'anya ya likuwa lya vanu. ");
INSERT INTO kde_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Munu yumo nkunnyaulila Yesu kuchidoni, “Anyoko chalumo na anung'unuvako vàimidile pawelu, vàlembela vakwone.” ");
INSERT INTO kde_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Henga Yesu nkuvahaulila vanu vammalele kuchidoni, “Ayuvangu nangu na anung'unuvangu nni vanu vammalele vapilikâna lilove lyanga Nnungu na kutenda chililembela.” ");
INSERT INTO kde_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Bahi liduva limo Yesu ávahaulidile vakuhundwa vake kuchidoni, “Tuyomboke litanda, tuhwene m'bali wavili.” Nkukwelanga muingalava, nkutandilika mwanda. ");
INSERT INTO kde_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Pavanavele mmwanda, Yesu nkulala luwono. Upala chimbunga nkulindamuka kupunga, medi nkwenda muingalava, vammalele nkuva vavèlè muhatali ing'ulungwa. ");
INSERT INTO kde_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Bahi vakuhundwa vake nkummwenela Yesu nkumwimula uvachidoni, “Nang'olo, Nang'olo! Tùvenkuhwa!” Yesu nkuimuka, nkuliamulisa lipungo na mawimbi vinyalale. Vyammalele nkunyalala, litanda nkutungamana. ");
INSERT INTO kde_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Anepo Yesu nkuvauja vakuhundwa vake kuchidoni, “Ing'ulupa yenu ìvele kwachi?” Henga vanang'o nkukangana, nkuyopa akuno uvaujana kuva, “Ayu munu wa namuna ntwani? Àliamulisa mpaka lipungo na mawimbi, na vyammalele vìnampilikana!” ");
INSERT INTO kde_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu na vakuhundwa vake nkuhwena na mwanda wavo, nkunahwika chilambo cha Vagelasi chivêle kung'ambo Litanda lya Galilaya. ");
INSERT INTO kde_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu pasulupwike kunnyangi, munu yumo ánavele na anamindenga nkumwidila. Aneyo munu kwa maduva lohe nanga pachiwala dinguwo na wala akáchiikala nng'ande, henga áikala chihi kumisati. ");
INSERT INTO kde_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Aneyo munu pammwene Yesu, nkukuta, nkunamatokela muyo madodo langa Yesu akuno watangola kwa lidi likulu wachidoni, “Yesu Mwana wanga Nnungu Nkulu! Dachi, ùndambela chani nangu? Nakuyuwa unangubanihe!” ");
INSERT INTO kde_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Munu aneyo átangwele uchocho ing'anya Yesu ámwamulisije nanndenga ammuke. Myanda yohe aneyo nanndenga ànambebelua. Pamo na kuva vanu vánintava makono na madodo kwa mididi ya chitale, henga ánihulula kuikadulanga, na nanndenga nkuntukutihija kulilanga. ");
INSERT INTO kde_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu nkummuja ayula munu kuchidoni, “Lina lyako nnani?” Nang'e nkuyang'ula kuchidoni, “Lina lyangu Jeshi.” Aneyo munu átangwele uchocho ing'anya vámwingidile anamindenga vohe. ");
INSERT INTO kde_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Anevo anamindenga nkunnyuwa Yesu anavapelekeje nnipondo livêle na ulehu ukee na ntululilo. ");
INSERT INTO kde_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Pepi na pachinu apala pávele na likuwa likulu lya anguluve vanavele nkulya nnichinga. Avala anamindenga nkumpembeja Yesu avaluhusu vakavaingile avala anguluve. Yesu nkuvaluhusu vahwene vakavaingile. ");
INSERT INTO kde_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Anamindenga nkummuka ayula munu, nkunavaingila anguluve. Likuwa lyammalele lya anguluve nkuhelelekela kumakobikobi, nkutubukila nnitanda na vammalele nkuhwa mmedi. ");
INSERT INTO kde_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Vachúngà va anguluve pavalawene anelo lahumidîle, nkutukuta, nkuhwena kumanga na mmawelu unavahaulila vanu kuyamba àlalá lavakojîje. ");
INSERT INTO kde_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Vanu nkuhweneng'ana unalola lahumidîle. Pavahwikile kwanga Yesu, nkumwona munu ausîjwe anamindenga aikèlè pamadodo langa Yesu, akuno awètè dinguwo, na ding'ano dyake dimmuyidìlè. Bahi vanu vammalele nkuyopa. ");
INSERT INTO kde_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Vanu vammalele valawêne anelo, nkuvahaulila vanu vanji habali dyanga ayula munu ánavele na nanndenga namuna chalamijwe. ");
INSERT INTO kde_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Bahi vanu vammalele va chilambo cha Vagelasi, nkunnyuwa Yesu auke, ing'anya vánayopa namene. Anepo Yesu nkukwela ingalava nkuuka. ");
INSERT INTO kde_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ayula munu anausijwe anamindenga nkunnyuwa namene Yesu apapatane navo. Henga Yesu nkuhita kupapatana nawe, nkunyaulila kuchidoni, ");
INSERT INTO kde_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Uya uhwene kukaya ukavahaulile vanu vitukutuku vyammalele vyakutendeledile Nnungu.” Ayula munu nkuuka nkuhwena imanga yammalele, wavahaulila vanu habali dya vitukutuku vyammalele vyatendewije na Yesu. ");
INSERT INTO kde_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu pauyite kuhaloka m'bali unji wa litanda, likuwa lya vanu nkumpwechelela kwa kuhangalala, kwa kuva, vanu vammalele vávele nkunnindilila. ");
INSERT INTO kde_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Upala nkuida munu yumo lina lyake Yailo, nkulungwa wa ing'ande ya kunnyuwila Nnungu. Nkulimatoha pamadodo langa Yesu, nkunnyuwa Yesu apapatane nawe ahwene kukaya kwake, ");
INSERT INTO kde_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ing'anya nahaku wake ánavele na vyaka malinga kumi na mbili ánauula na ávele pepi na kuhwa. Yesu pachihwena, likuwa lya vanu nkuva uvan'gumaguma kila m'bali. ");
INSERT INTO kde_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nnikuwa anelyo múvele na mmahe ánavele na ugonjo wa kuhuma myadi vyaka kumi na mbili. Mmahe aneyo ánisumisa vitukutuku vyake vyammalele na kuveng'a vaganga, henga nanga anahulwile kunnamya. ");
INSERT INTO kde_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ayula mmahe nkumwidila Yesu nnyuma mwake nkugusa lupepe lwa lijoho lyawete Yesu. Upala myadi nkunyalala kuhuma. ");
INSERT INTO kde_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu nkuuja kuchidoni, “Nnani angugusîje?” Vanu vammalele nkukana. Petulo nkuchidoni, “Nang'olo, lola mmuluku wa vanu ukudingwîke na kukubana-bana.” ");
INSERT INTO kde_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Henga Yesu nkuchidoni, “Pàvele munu angugusîje, kwa kuva, ngwòna dimongo dyangu dìnitumika.” ");
INSERT INTO kde_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ayula mmahe pawene kuva ànimaikana, nkulihumija akuno watetemela, nkulimatohija pamadodo langa Yesu, nkulihaulanga muyo mwa vanu vammalele ing'anya intendîle nang'e an'guse Yesu na kuva, nkulamywa upala. ");
INSERT INTO kde_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu nkunnyaulila ayula mmahe kuchidoni, “Mwanangu, ing'ulupa yako ìnikulamya, hwena kwa amani.” ");
INSERT INTO kde_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu pánavele nkupwahika, nkwida munu yumo kuhaloka kukaya kwanga Yailo. Nkunnyaulila Yailo kuchidoni, “Nahaku wako ànihila, unamkambye-kambye nkúhunda.” ");
INSERT INTO kde_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu papilikene anelo nkunyaulila Yailo kuchidoni, “Unayope, wako kulupila chihi na mwanalo achialamywe.” ");
INSERT INTO kde_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesu pahwikile kukaya kwanga Yailo, nkuvalimbija vanu vanji vanaingile nng'ande pamo na nang'e, henga áingidile chihi na Petulo na Yohana na Yakobo pamo na atatake na anyokwe mwana ahidîle. ");
INSERT INTO kde_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Vanu vammalele vánakuta na kunkutangila ayula mwana. Yesu nkuvahaulila kuchidoni, “Nyalala, munakute, kwa kuva, ayu mwana nanga pahidile ila àlele chihi luwono!” ");
INSERT INTO kde_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Anevo vanu nkunnyeka Yesu ing'anya vánimala kuva mwana ànihila. ");
INSERT INTO kde_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yesu nkukamula nkono wanga ayula mwana ahwîle nkunonoha lidi wachidoni, “Mwanangu, imuka!” ");
INSERT INTO kde_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Upala dimumu dyake nkummuila, nkutakatuka. Anepo Yesu nkuvahaulila vamwing'e chakulya. ");
INSERT INTO kde_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Bahi atatake na anyokwe ayula mwana nkukangana namene, Yesu nkuvahaulila vanannyaulile munu woheyo kwamba achila chihumidîle. ");
INSERT INTO kde_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu nkuvachema pamo vakuhundwa vake kumi na mbili, nkuveng'a dimongo na mamulaka la kuvausa anamindenga vammalele na kuvalamya vagonjo. ");
INSERT INTO kde_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Bahi nkuvatuma vakavayanjajije vanu habali dya Ufalume wanga Nnungu na kuvalamya vagonjo. ");
INSERT INTO kde_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nkuvahaulila kuchidoni, “Munanyakule chinu chohecho mmwanda, ata kuiva isimbo au mpatila au chakulya au dihela au nkogo wa akiba. ");
INSERT INTO kde_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ing'ande yoheyo imumbepwechelewa, ikalanga anemwo mpaka pamumbeukananga muimanga aneyo. ");
INSERT INTO kde_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Na vanu va imanga fulani vakàhita kumpwechelanga, pamumbeuka paimanga aneyo vakanange vanu anevo kwa kulipumunanga litutunga mmadodo lenu ilangule kuva vene vànitandola kulahita malove langa Nnungu.” ");
INSERT INTO kde_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Bahi vakuhundwa nkutandilika mwanda, nkuhwena ya kuvijiji uvayanjaja Malove Lambone na kuvalamya vagonjo kila pachinu. ");
INSERT INTO kde_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nfalume Helode ánipilikana habali dya vitukutuku vyammalele vyachitenda Yesu. Bahi nkupuwanyika ding'ano ing'anya vanu vanji váhaula kuva, “Yohana ánifufuka kuhaloka kwa vanu vahwîle!” ");
INSERT INTO kde_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Na vanu vanji váhaula kuva, Eliya àniida, na vanu vanji váhaula kuva, yumo wa manabii va machedo ànifufuka. ");
INSERT INTO kde_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Henga Helode nkuhaula kuchidoni, “Yohana nìnchekete muti, hambi aneyo nnani ungumpilikana habali dyake?” Bahi Helode nkutaha namene kumwona Yesu. ");
INSERT INTO kde_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Bahi mitume pavauyite, nkunnyaulila Yesu kuyamba mambo lammalele lavatendile. Yesu nkuvatwala nkuhwena navo pachinu pakávele na vanu kuimanga ya ku Betisaida. ");
INSERT INTO kde_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Henga likuwa lyammalele lya vanu pavamayite kwapite Yesu, nkumpapata. Yesu nkuvapwechelanga, nkuvahaulila habali dya Ufalume wanga Nnungu na nkuvalamya vammalele vachilembela kulamywa. ");
INSERT INTO kde_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Liduva palichiswa, avala vakuhundwa kumi na mbili nkummwenela Yesu nkunnyaulila kuchidoni, “Valaile vanu vahweneng'ane ya kuvijiji na kumawelu vakalitahije chakulya na pachinu pakulala, kwa kuva, apano patuvele palilanga.” ");
INSERT INTO kde_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Henga Yesu nkuyang'ula kuchidoni, “Veng'e mwenu chakulya.” Vanang'o nkuchidoni, “Tùvele chihi na mikate nnyano na ahomba vavili bahi. Dachi, wako ùlembela hwetu tukavasumile chakulya vanu ava vammalele?” ");
INSERT INTO kde_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Na pachinu anepo pávele na valume vahwikîla malinga alufu nnyano. Yesu nkuvahaulila vakuhundwa vake kuchidoni, “Vahaulile vanu vaikale matunji la vanu malinga amsini-amsini.” ");
INSERT INTO kde_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Vakuhundwa nkutenda uchocho, na vanu vammalele nkuikala pahi. ");
INSERT INTO kde_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu nkuitwala aila mikate nnyano na avala ahomba vavili, nkulola muha kulihunde, nkuvibaliki na kuvimeyanya, nkuveng'a vakuhundwa vavayavanyije vanu. ");
INSERT INTO kde_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Vanu vammalele nkulya nkusiba, nkulokotanya vibeduli vya maisalilo la mikate na ahomba nkuumbajanga makalala kumi na mbili. ");
INSERT INTO kde_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Liduva limo Yesu pánavele nkuyuwa weka, vakuhundwa vake vávele pamo nanang'e. Yesu nkuvauja kuchidoni, “Dachi, vanu vàhaula kuva nangu nnani?” ");
INSERT INTO kde_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Vakuhundwa nkunnyang'ula kuchidoni, “Vanu vanji vàhaula kuva wako nni Yohana Nkúbatisa, na vanji vàhaula kuva wako nni Eliya na vanji vàhaula kuva wako nni yumo wa manabii va machedo afufwîke.” ");
INSERT INTO kde_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Henga Yesu nkuvauja kuchidoni, “Na mwenu muchidachi, nangu nnani?” Petulo nkuyang'ula kuchidoni, “Wako njo Kilisto uhalêke kwanga Nnungu.” ");
INSERT INTO kde_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesu nkuvaduma vakuhundwa vake vanannyaulile munu woheyo habali aneyo. ");
INSERT INTO kde_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nkuvahaulila kuchidoni, “Mwana wa Munu àmbebanika namene na kuhitwa na vasele va Vayahudi na makuhani vakulu na vakúhunda Sheliya. Vàmbemmwalala, na liduva lya tatu lya kuhwa kwake àmbefufuka.” ");
INSERT INTO kde_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Anepo nkuvahaulila vanu vammalele kuchidoni, “Munu woheyo akàlembela kungupapata nangu, lasima alishukulu mwene, koka alitike nsalaba wake kila liduva, angupapate. ");
INSERT INTO kde_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kwa kuva, munu alembêla kuupoha umi wake àmbeuyaha, henga munu ambeuyâha umi wake ing'anya yang'une, àmbeupoha. ");
INSERT INTO kde_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Dachi, munu àmbepata faida ntwani akàpata kila chinu cha pachilambo akuno auyahìtè au awondongèngè mwalehu umi ukee na ntululilo? ");
INSERT INTO kde_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kwa kuva, munu woheyo angwonêla nangu dihoni na mahundo langu, Mwana wa Munu àmbemwonela dihoni munu aneyo pambeida, akuno avèlè na ukulu wake na ukulu wa Atatake na ukulu wa malaika vake. ");
INSERT INTO kde_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nangu nìnnyaulilanga uhiu kuva, vanu vanji vaimidîle apano vakambekuhwa mpaka vawone Ufalume wanga Nnungu.” ");
INSERT INTO kde_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Bada ya maduva nane kutandikila liduva lyanatangwele malove anelo, Yesu nkuntwala Petulo na Yohana na Yakobo, nkuhwena navo kulichinga unayuwa. ");
INSERT INTO kde_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yesu pánavele nkuyuwa, kumeho kwake nkubadilika, na inguwo yake nkung'anyima namene muchi nng'anje wa ing'uva. ");
INSERT INTO kde_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Upala, nkuhumila vanu vavili, Musa na nabii Eliya. ");
INSERT INTO kde_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Vanu anevo váonekene muukulu wa kulihunde uvalonjela na Yesu kuyamba kuhwa kwake kwambekutimisa aneko ku Yelusalemu mmaduva kadiki laîda. ");
INSERT INTO kde_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Muuhiku anewo Petulo na vavake vávele nnuwono, pavatakatwike, nkuwona ukulu wanga Yesu, na vanu vavili vaimidìlè nawe. ");
INSERT INTO kde_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Anevo vanu pavachilekana na Yesu, Petulo nkunnyaulila Yesu kuchidoni, “Nang'olo, nni chinu chambone namene hwetu tupwawe apano. Leka tudenge migongwe mitatu, umo wako na umo wanga Musa na umo wanga Eliya.” Henga Petulo akáchimala chachitangola. ");
INSERT INTO kde_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petulo pánavele nkutangola, nkuhaloka lihunde nkuvahinika. Vakuhundwa nkuyopa namene palichivahinika lihunde anelyo. ");
INSERT INTO kde_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nkupilikanika lidi kuhaloka nnihunde ulichidoni, “Ayuno njo Mwanangu unintandwele. Mpilikanile nang'e.” ");
INSERT INTO kde_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Palinyalalike anelyo lidi, Yesu nkwonekana avèlè chihi weka. Vakuhundwa vake nkulavika chihi munda anelo lavalawene na nanga pavanannyaulidile munu woheyo mmaduva anelo. ");
INSERT INTO kde_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ulyamba wake, Yesu na avala vakuhundwa vake vatatu pavasulupwike nnichinga, nkulikoja likuwa likulungwa lya vanu. ");
INSERT INTO kde_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Munu yumo nnikuwa alila lya vanu nkunonoha lidi wachidoni, “Nkúhunda, chonde ndolele mwanangu, kwa kuva nang'e nni mwanangu wa weka! ");
INSERT INTO kde_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Myanda yohe nanndenga ànam'bebelua. Upala pam'bebelua, àntenda akute ding'uto na kukwijula na kuhuma chihulu nkanya. Aneyo nanndenga ànam'baniha namene na ànatima kunneka. ");
INSERT INTO kde_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ńnivayuwa vakuhundwa vako vammuse nanndenga, henga nanga pavahulwile.” ");
INSERT INTO kde_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu nkuyang'ula kuchidoni, “Mwenu mmanu mma chívelèkwà chikákulupila na chihochedile! Dachi, nìmbeikala pamo na mwenu ungumpililila mpaka chakani?” Anepo nkunnyaulila ayula munu kuchidoni, “Idanawe apano mwanalo.” ");
INSERT INTO kde_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ayula nnemba pachihwena pávèlè Yesu, nanndenga nkummatoha nnemba na kuntenda akwijule. Yesu nkunkalipila ayula nanndenga, nkunnamya aneyo nnemba, nkummuyiha kwa atatake. ");
INSERT INTO kde_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Na vanu vammalele nkukangana namene kwa kudyona dimongo ding'ulu dya Nnungu. Vanu pavanavele nkukangana vitukutuku vyatendile Yesu, Yesu nkuvahaulila vakuhundwa vake kuchidoni, ");
INSERT INTO kde_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Pilikanila sana alano malove lanimbennyaulila kuva, Mwana wa Munu àvele pepi uhwena unakamujwa mmakono la vanu.” ");
INSERT INTO kde_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Henga vakuhundwa vake nanga pavanamayite chilachiyamba malove latangwele, kwa kuva lánipihwa kwa vanang'o uchinga vanalamale. Vanang'o nkuyopa kummuja Yesu mana lake. ");
INSERT INTO kde_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Bahi vakuhundwa nkutandilika kutahukana vene kwa vene kuva, alida nkulu nnikuwa lyavo. ");
INSERT INTO kde_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu palamaite àlalá lavachiliuja mmitima yavo, nkuntwala mwana n'joko nkummika pepi nanang'e. ");
INSERT INTO kde_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Anepo nkuvahaulila vakuhundwa vake kuchidoni, “Munu woheyo ampwechelêla mwana n'joko malinga ayuno ing'anya yang'une, aneyo àngupwechelela nangu, na munu woheyo angupwechelêla nangu, aneyo àmpwechelela ayula angutumîle. Kwa kuva, munu woheyo n'joko kupunda vammalele, aneyo njo nkulu kupunda vammalele.” ");
INSERT INTO kde_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohana nkunnyaulila Yesu kuchidoni, “Nang'olo, tummwene munu yumo wavausa anamindenga kwa lina lyako, hwetu nkunnimbija, kwa kuva nang'e akávele wa nnikuwa lyetu lya vakuhundwa.” ");
INSERT INTO kde_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesu nkunnyaulila kuchidoni, “Munannimbije, kwa kuva, munu woheyo akátahukana na mwenu, aneyo àvele m'bali wenu.” ");
INSERT INTO kde_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Maduva la kutwaliwa kwa Yesu kuhwena kulihunde palanavele pepi kukamola, Yesu nkukudungila namene kuhwena ku Yelusalemu. ");
INSERT INTO kde_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Bahi nkuvatuma vajumbe vannongolelee. Avala vajumbe nkuukananga, nkuhwena kuchijiji chimo cha Vasamaliya uchinga vamwandalile kila chinu nchijiji anecho. ");
INSERT INTO kde_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Henga vanu va chijiji anecho nanga pavanampwacheledile ing'anya vánimala kuva Yesu àkudungidile kuhwena kuimanga ya ku Yelusalemu. ");
INSERT INTO kde_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Henga Yohana na Yakobo vakuhundwa vanga Yesu, pavalawene anelo, nkummuja Yesu kuchidoni, “Nang'olo, dachi ùnalembela tuuchemehije moto kuhaloka kulihunde uvapije vammalele?” ");
INSERT INTO kde_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesu nkuvalaukila vakuhundwa vake, nkuvakalipila. ");
INSERT INTO kde_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Bahi nkuukananga nkuhwena kuchijiji chinji. ");
INSERT INTO kde_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Pavanavele mmwanda, munu yumo nkunnyaulila Yesu kuchidoni, “Nìmbekulondola kwoheko kumbehwena.” ");
INSERT INTO kde_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu nkunnyaulila kuchidoni, “Macheta làvele na vivava, na vyuni vìvele na vitehi, henga Mwana wa Munu akávele na pachinu pakuyewelela.” ");
INSERT INTO kde_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesu nkunnyaulila munu yunji kuchidoni, “Ngupapate.” Henga aneyo munu nkuhaula kuchidoni, “Nang'olo, nguleke hoti nguhwene kukaya nikansike atatangu.” ");
INSERT INTO kde_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Henga Yesu nkunnyang'ula kuchidoni, “Valeke vanu vavêle muchi vànihwa vavasike vahwîle vao, henga wako hwena ukauyanjaje Ufalume wanga Nnungu.” ");
INSERT INTO kde_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Munu yunji nkunnyaulila Yesu kuchidoni, “Nang'olo, nangu nguchinikupapate, henga nguleke nahoti nikavalaile vanu va nng'ande mwangu.” ");
INSERT INTO kde_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Henga Yesu nkunnyaulila kuchidoni, “Munu woheyo atandilîka kulima koka nkulola kunyuma, aneyo akálembelewa mu Ufalume wa Nnungu.” ");
INSERT INTO kde_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Bada ya anelo, Nang'olo Yesu nkuvatandola vanu vanji sabini na mbili nkuvatuma vavili-vavili vannongolele kila imanga na kila pachinu pachilambela ahwene. ");
INSERT INTO kde_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nkuvahaulila kuchidoni, “Mafuno làvele lohe, henga vakúfuna vàvele kadiki. Hambi, nnyuwange Nang'olo wa mafuno avatume vakúfuna mmwelu wake. ");
INSERT INTO kde_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Bahi hweneng'ana! Lola, nangu nìntumanga mwenu muchi angandolo ching'ati vanu vayôha muchi mahoha. ");
INSERT INTO kde_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Munanyakule dihela wala mpatila wala vilatu. Na nndila munalitinike umuvasalimila vanu. ");
INSERT INTO kde_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Pamuinjila muing'ande yoheyo ivambempwechelela, tandilika kuvabaliki kwa kuhaula kuchidoni, ‘Mmanu mma ing'ande aino mùùve na amani!’ ");
INSERT INTO kde_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Akàpwawa munu wa amani, bahi amani yenu ichiive pamo nanang'e, henga akànapwawe, amani yenu ìmbemmuilanga mwenu mmene. ");
INSERT INTO kde_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ikalanga muing'ande aneyo, umulya na kukumbila chohecho chivambemwing'a, kwa kuva, kila munu akôla madengo àlembelewa apwechele nshahala wake. Ikalanga muing'ande imukamoledile, na munahame-hame kuuka ing'ande imo kuhwena ing'ande inji. ");
INSERT INTO kde_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Imanga yoheyo imumbeinjila na vanu nkumpwachelela, mwenu ilya chakulya chohecho chivambemwing'a. ");
INSERT INTO kde_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Valamye vagonjo vavelênge muimanga aneyo na muvahaulile kuchidoni, ‘Ufalume wa Nnungu ùvele pepi na mwenu.’ ");
INSERT INTO kde_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Na imanga yoheyo imumbeinjila alafu vanu vake vanampwachelele, mwenu hweneng'ana n'dindila dya imanga aneyo mukahaule kuchidoni, ");
INSERT INTO kde_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Litutunga lya imanga yenu livêle mmadodo letu tuvenkulipumunanga uchinga lììve chimaiho kuva, mukávele na chinu mu Ufalume wa Nnungu. Henga mùlembelewa mumale kuva, Ufalume wa Nnungu ùvele pepi na mwenu!’ ");
INSERT INTO kde_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nangu nìnnyaulila kuchidoni, liduva anelyo lya hukumu, vanu va imanga aneyo vàmbepata asabu ing'ulungwa namene kupunda vanu va imanga ya ku Sodoma.” ");
INSERT INTO kde_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yesu nkuhweneha kutangola kuchidoni, “Ole wenu mwenu mmanu mma imanga ya Kolasini! Ole wenu mwenu mmanu mma imanga ya Betisaida! Kwa kuva, ikàchiva masaibu latendêke kwenu mwenu ulatendeka kuimanga ya Tilo na ku Sidoni, vanu vake vakaniikala pahi na kuwala magunila na kulipakalanga liu, kulanguja kuva vànileka kutenda masambi. ");
INSERT INTO kde_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Bahi nniduva lya hukumu, mwenu mùmbepata asabu ing'ulungwa namene kupunda vanu va ku Tilo na ku Sidoni. ");
INSERT INTO kde_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Na mwenu mmanu mma imanga ya Kapelinaumu, dachi mùtenda kuva mùmbekwejwa mpaka muha kulihunde? Nanga! Mùmbesulupuhwa mpaka pachinu pavanu vahwîle!” ");
INSERT INTO kde_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Anepo Yesu nkuvahaulila vakuhundwa vake kuchidoni, “Munu ampilikanîla mwenu, àngupilikanila nangu, na munu annyîta mwenu, ànguhita nangu. Na munu anguhîta nangu, munu aneyo ànnyita ayula angutumîle nangu.” ");
INSERT INTO kde_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Bahi avala vakuhundwa sabini na mbili nkuuya akuno uvahangalala, uvahaula kuchidoni, “Nang'olo, ata anamindenga vànatupilikana patuvaamulisa kwa lina lyako.” ");
INSERT INTO kde_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu nkuvahaulila kuchidoni, “Nímmwene Nanchindenga wamatoka kuhaloka kulihunde muchi nng'anje wa ing'uva. ");
INSERT INTO kde_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Lola, nangu nìmpele mwenu mamulaka la kulivata mihongo na vivalavala na kudilema dimongo dya mmongo wenu Nanchindenga, na nanga chinu chohecho chimbemmenga. ");
INSERT INTO kde_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Bahi munahangalale ing'anya anamindenga vànampilikana, henga hangalala kwa kuva, malina lenu lànilembwa kulihunde.” ");
INSERT INTO kde_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Upala, Yesu nkuumbajwa ihangaladi kwa dimongo dya Umumu Wanaswe, nkuhaula kuchidoni, “Atata, Nang'olo wa kulihunde na pachilambo, nakulombolela kwa kuva vitukutuku anevyo ùvapihite vanu vavêle na lúnda na vavêle na elimu, nkuvahunukulila vanu vavêle na mitima ivêle muchi vana vajoko. Elo Atata, kwa kuva, njo chiukatapaliwije wako.” ");
INSERT INTO kde_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yesu nkuhweneha kuvahaulila vanu kuchidoni, “Atatangu àngupele nangu vitukutuku vyammalele. Nanga munu ammaîte Mwana ikànave chihi Atata, na wala nanga munu ammaîte Atata ikànave chihi Mwana chalumo na munu woheyo wanatandwele Mwana kunnyunukulila.” ");
INSERT INTO kde_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Anepo Yesu nkuvalaukila vakuhundwa vake akuno vavèlè chihi vanang'o weka nkuvahaulila kuchidoni, “Wasa mwenu muvyôna vitukutuku vimuvyona. ");
INSERT INTO kde_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kwa kuva, nangu nìnnyaulilanga kuva, manabii na vafalume vohe vánilembela kulona lamulona mwenu, henga nanga pavanalawene, na vánilembela kulapilikana alano lamupilikana mwenu, henga nanga pavanalapilikene.” ");
INSERT INTO kde_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Bahi nkúhunda yumo wa Sheliya nkuimila nkummuja Yesu wachinga anninge, nkuchidoni, “Nkúhunda, ngutende dachi uchinga ngupate umi ukee na ntululilo?” ");
INSERT INTO kde_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu nkummuja kuchidoni, “Dachi, Sheliya yanga Musa ichidachi? Dachi, wako ùiyelewa dachi?” ");
INSERT INTO kde_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ayula munu nkuyang'ula kuchidoni, “Ntamwe Nang'olo Nnungu wako kwa ntima wako wammalele, na kwa isungu yako yammalele, na kwa dimongo dyako dyammalele, na kwa ding'ano dyako dyammalele. Na ntamwe nnyako malinga chulitamwa umwene.” ");
INSERT INTO kde_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu nkunyang'ula kuchidoni, “Ùniyang'ula saana, bahi tènda uchocho nawako uchiuve na umi ukávele na ntululilo.” ");
INSERT INTO kde_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Henga ayula nkúhunda Sheliya álembela aliyavile haki, bahi nkummuja Yesu kuchidoni, “Dachi, nnyangu njo nnani?” ");
INSERT INTO kde_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu nkuyang'ula kuchidoni, “Pávele na munu yumo achihelela kuhaloka ku Yelusalemu wahwena ku Yeliko. Pánavèlè nndila, vakúpalaula nkunkamula, nkummulanga dinguwo dyake na kumpanya, nkunneka avèlè pepi na kuhwa. ");
INSERT INTO kde_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kwa bahati nkuhumila kuhani yumo achihelela muindila uila, henga pammwene ayula munu uvampanyile, nang'e nkupita kunyenje. ");
INSERT INTO kde_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Uchocho nkuida na Mlawi yumo, pahwikile apala nkumwona ayula munu, uchocho nanang'e nkupita kunyenje. ");
INSERT INTO kde_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Henga Nsamaliya yumo ánavele mmwanda, nkuhwika pachinu anepo, pammwene ayula munu nkummikila chididi. ");
INSERT INTO kde_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nkunnyengelekela, nkuhahulanga vilonda kwa mahuta na divayi, nkuvihunga. Nkunkweja munnyama wake, nkumpelekeja kuing'ande ya kulala vayeni, nkummuuja. ");
INSERT INTO kde_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Liduva lya vili, ayula Nsamaliya nkutwala dihela malinga dya nshahala wa maduva mavili nkumwing'a nkwímilila ing'ande ya vayeni. Nkunnyaulila kuchidoni, ‘Mmuuje ayuno munu, na chohecho chumbeyenjeja muha, nakuuihija panimbeuya.’ ” ");
INSERT INTO kde_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Bahi Yesu nkummuja ayula nkúhunda Sheliya kuchidoni, “Wako wona dachi, muanevo vanu vatatu, alida ánavele nnyake ayula munu uvampanyile vakúpalaula?” ");
INSERT INTO kde_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ayula nkúhunda Sheliya nkuyang'ula kuchidoni, “Ayula ammikidîle chididi na kunnyangata njo nnyake.” Yesu nkunnyaulila kuchidoni, “Na wako hwena ukatende uchocho.” ");
INSERT INTO kde_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu na vakuhundwa vake pavanavele mmwanda wa ku Yelusalemu, nkuhwika pachijiji chimo. Nchijiji anecho nkupwechelewa na mmahe yumo uvanchema Masa. ");
INSERT INTO kde_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Masa ávele na nnung'une uvanchema Maliya, anaikele pamadodo langa Nang'olo walapilikanila mahundo lake. ");
INSERT INTO kde_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Henga Masa ávenkudumba-dumba na madengo lohe. Bahi nkummwenele Yesu nkummuja kuchidoni, “Nang'olo, wako ukona kuva nnung'unwangu àndekedile madengo lohe ungutenda weka? Nnyaulile anguyangate.” ");
INSERT INTO kde_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Nang'olo nkunnyang'ula kuchidoni, “Masa, Masa, wako ùnadumba-dumba na kuva na lipamba ing'anya ya vitukutuku vyohe. ");
INSERT INTO kde_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Henga chìlembelewa chihi chitukutuku chimo bahi. Na Maliya àtandwele chitukutuku chambone namene chakambepakanyolwa.” ");
INSERT INTO kde_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Liduva limo Yesu ávele pachinu fulani àvenkuyuwa. Pamalidile kuyuwa nkuhundwa yumo nkunnyaulila Yesu kuchidoni, “Nang'olo, tùkuyuwa utuhunde kuyuwa muchi Yohana Nkúbatisa chavahundile vakuhundwa vake.” ");
INSERT INTO kde_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu nkuvahaulila kuchidoni, “Pamuyuwa tangola uvila, ‘Atata wetu wa kulihunde, lina lyako litumbyangwe, Ufalume wako uide. ");
INSERT INTO kde_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Kila liduva utwing'e chakulya chimbetutoleja. ");
INSERT INTO kde_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Utusamehe masambi letu, kwa kuva, na hwetu tùnavasamehe vanu vatukosêla, na patulingwa, unatuleke ututenda masambi.’” ");
INSERT INTO kde_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Anepo Yesu nkuvahaulila vakuhundwa vake kuchidoni, “Ikàva munu yumo nnikuwa lyenu àvele na nnyanjawake, nkummwenela kukaya kwake ching'ati chilo nkunnyaulila kuchidoni, ‘Nnyanjawangu, chonde njadike mikate mitatu nakuiihija, ");
INSERT INTO kde_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kwa kuva, nnyanjawangu ánavele mmwanda ànikamola kukaya kwangu na nangu nikávele na chakulya cha kumwing'a.’ ");
INSERT INTO kde_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Bahi ikàva aneyo nnyanjawake àmbeyang'ula chihi avèlè chihi nng'ande kuchi, ‘Unangukambye-kambye! Nnango ùnichimwa, nangu na vanavangu tùnilala, nikachinguhulule kutakatuka nikwing'e chakulya.’ ");
INSERT INTO kde_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nangu nìnnyaulilanga uhiu kuva, pamo na kuva akambetakatuka ing'anya ya kuva nang'e nnyanjawake, henga àmbetakatuka na kumwing'a vyammalele vyasikikidile kwa kuva, ànitumbama kunnyuwa. ");
INSERT INTO kde_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Bahi nangu nìnnyaulilanga kuva, yuwanga na Nnungu achiamwing'ange, tahanga na mwenu muchimupate, hodikanga na mwenu muchimuchimuliwe. ");
INSERT INTO kde_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kwa kuva, kila munu ayûwa ànapewa, na atâha ànapata, na ahodîka ànachimuliwa. ");
INSERT INTO kde_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Na mwenu anga atata, alida mmwenu mwanawe akànnyuwa ihomba àmbemwing'a nnyongo? ");
INSERT INTO kde_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Au akànnyuwa liye, àmbemwing'a chivalavala? ");
INSERT INTO kde_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ikàva mwenu mmakutenda masambi, mùnimala kuveng'a vana venu vitukutuku vikatapele, dachi, Atata wenu wa kulihunde akambepunda namene kuveng'a Umumu Wanaswe vanu vannyûwa?” ");
INSERT INTO kde_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Liduva limo Yesu ámmusa nanndenga anantendile munu ààve bubu. Nanndenga pammukile ayula munu nkutandilika kutangola, likuwa lya vanu nkukangana. ");
INSERT INTO kde_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Henga vanu vanji nkuchidoni, “Nanchindenga, nkulu wa anamindenga njo annyululîha nang'e kuvausa anamindenga.” ");
INSERT INTO kde_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Vanu vanji nkunninga Yesu kwa kunnyuwa alanguje chimaiho cha lisaibu chilangûja kuva dimongo dyake dìhaloka muha kulihunde. ");
INSERT INTO kde_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Akuno Yesu alamaìtè lavachiliuja mmitima yavo, nkuvahaulila kuchidoni, “Kila ufalume ulumbâna wene kwa wene ùmbematoka, na vanu va ing'ande imo vakàlumbana, ing'ande aneyo ìmbeondongeka. ");
INSERT INTO kde_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Dachi, ikàva Nanchindenga àlilumbanya mwene, ufalume wake ùmbekwimila dachi? Nangu ngùtangola uchocho ing'anya mwenu mùhaula kuva ngùusa anamindenga kwa dimongo dya Nanchindenga. ");
INSERT INTO kde_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mwenu mùhaula kuva nangu ngùvausa anamindenga kwa kuhululihwa na Nanchindenga, dachi, nnani avêng'a vanu venu dimongo dya kuvausa anamindenga? Bahi vanu venu mmene njo vambennyukûmu mwenu ing'anya ya malove lamutangwele. ");
INSERT INTO kde_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Henga ikàva nangu ngùvausa anamindenga kwa dimongo dyanga Nnungu, bahi mumale kuva Ufalume wanga Nnungu ùnimwidilanga. ");
INSERT INTO kde_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Munu avêle na dimongo pailolihija ing'ande yake kwa vikomanilo, vitukutuku vyake vikátwaliwa. ");
INSERT INTO kde_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Henga akàida munu avêle na dimongo kumpunda nang'e nkupanyana nawe ing'ondo na kunnema, àmbempakanyola vikomanilo vyake vyachilisingila na kutwala litwala vitukutuku vyake. ");
INSERT INTO kde_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Munu woheyo akávele pamo na nangu, aneyo ànangutahuka, na munu woheyo akákunganya pamo na nangu, aneyo ànamwadilihanya.” ");
INSERT INTO kde_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Nanndenga pammuka munu, àpita wadinguka-dinguka pachinu pakávele medi wataha pachinu pakuyewelela, henga nanga papata. Anepo àlihaulila mwene muntima kuva, ‘Nìmbeuya kavila kuing'ande yangu inguilekile.’ ");
INSERT INTO kde_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Páùyà, àikoja aila ing'ande ipyailiwìjè na kila chinu chivikwìjè saana. ");
INSERT INTO kde_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Anepo ànauka, nkunavatwala anamindenga avake saba vabaya kumpunda nang'e, na vammalele vànahwena nkumwenda aneyo munu. Na hali ya kuntululilo ya munu aneyo ììva ibaya kupunda hali yake inandi.” ");
INSERT INTO kde_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu pachitangola uchocho, mmahe yumo nnikuwa alila lya vanu, nkunonoha lidi wachidoni, “Wasa mmahe ayula akuvalêke na kukuyong'eja!” ");
INSERT INTO kde_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Henga Yesu nkuyang'ula kuchidoni, “Wasa vanu avala vapilikâna lilove lyanga Nnungu na kulikamuliha.” ");
INSERT INTO kde_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Likuwa lya vanu palichihalija kuyenjejeka, Yesu nkuvahaulila kuchidoni, “Mwenu nni mmanu mma chívelèkwà cha vanu vakútenda masambi, njo mana mùlembela ninnangujange chimaiho cha lisaibu, henga nanga pamumbelangujwa chimaiho chohecho ikànave chihi achila cha nabii Yona. ");
INSERT INTO kde_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Malinga nabii Yona chanavele chimaiho kwa vanu va ku Ninawi, njo uchocho Mwana wa Munu chambekuva chimaiho kwa vanu va chívelèkwà achino. ");
INSERT INTO kde_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Na liduva lya hukumu malukiya wa kusini, wa chilambo cha Sheba àmbeimila na kuvasitaki vanu va chívelèkwà achino kuva vànikosela. Kwa kuva, nang'e ániida kuhaloka chilambo cha kulehu kwida unapilikanila malove la lúnda la Nfalume Selemani, na apano pàvele munu yumo nkulungwa kumpunda Nfalume Selemani. ");
INSERT INTO kde_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nniduva anelyo lya hukumu vanu va ku Ninawi vàmbeimila na kuvasitaki vanu va chívelèkwà achino kuva vànikosela. Kwa kuva, vanu va ku Ninawi vánilekanga kutenda masambi ing'anya ya mahubili la nabii Yona, na apano pàvele munu yumo nkulungwa kumpunda nabii Yona!” ");
INSERT INTO kde_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesu nkuhweneha kutangola wachidoni, “Nanga munu achâcha chibatali nkuchivika pachinu palipihite, au nkuchihinika lidebe, henga àchivika muha chipanda wachinga vanu vainjîla nng'ande vawone nng'anje. ");
INSERT INTO kde_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Meho lako njo chibatali cha mmili. Meho lako lakàva lumi, mmili wako wammalele ùmbeumbala nng'anje. Henga meho lako lakàondongeka, mmili wako wammalele ùmbeumbala lupi. ");
INSERT INTO kde_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Bahi lyongolele, uchinga nng'anje uvêle nkati mwako unapindikuke kuva lupi. ");
INSERT INTO kde_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ikàva wako ùumbelwe na nng'anje nkati mwako bila kupwawa pachinu pohepo pavêle na lupi, anepo wako ùmbelola saana malinga pachikulangajija chibatali.” ");
INSERT INTO kde_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu pamalidile kutangola, Nfalisayo yumo nkunkumbula Yesu kukaya kwake akalye chakulya. Yesu nkuhwena, nkuikala kulya chakulya. ");
INSERT INTO kde_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nfalisayo aneyo ánikangana namene kumwona Yesu walya bila kukalava. ");
INSERT INTO kde_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Bahi Nang'olo nkunnyaulila kuchidoni, “Mwenu Mafalisayo mùhahula chihi mwawo na nkungu pannima, henga nkati mwenu mwòmbele chihi kupakanyola na kutenda lahakalenge. ");
INSERT INTO kde_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mavelu mwenu! Dachi, Nnungu akatapajîje pawelu akee njo uyoyo akatapajîje nkati? ");
INSERT INTO kde_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Bahi hahulanga nkati mwenu kwa kuvayangata amahuvani, na mwenu muchimuhahuke mwalehu. ");
INSERT INTO kde_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ole wenu mwenu Mmafalisayo! Kwa kuva, mwenu mùnajali namene kuhumya asilimiya kumi ata kwa vitukutuku vijoko malinga vitakilo vya kukoleja muimbowa, akuno umulekanga vitukutuku vya muhimu vya Sheliya, yani kuvatendela vanji haki na kuntamwa Nnungu. Anelo njo lamulembelewa kulakamula bila kuleka kulatenda na anelo lanji. ");
INSERT INTO kde_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ole wenu mwenu Mmafalisayo! Kwa kuva, mùnatamwa namene kuikala nafasi dya kweshimika n'ding'ande dya kunnyuwila Nnungu na kusalimiwa kwa eshima kusakoni. ");
INSERT INTO kde_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ole wenu! Kwa kuva, mùlandene na misati ikávele na alama, iluvâtwa na vanu bila kumala kuva chinu chivêle nkati nni chibaya.” ");
INSERT INTO kde_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nkúhunda yumo wa Sheliya nkunnyaulila Yesu kuchidoni, “Nkúhunda, pautangola uchocho, ututangolela na hwetu lahakalenge.” ");
INSERT INTO kde_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu nkunnyang'ula kuchidoni, “Ole wenu mwenu mmakuhunda Sheliya! Kwa kuva, mùvatika vanu misigo iidôpa, akuno mmene mukàhulula kuinyakula. Mwenu mmene mukányoloja kananga chala kuvayangata. ");
INSERT INTO kde_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ole wenu! Kwa kuva, mwenu mùdengela misati ya manabii uvanavawalele anyakala venu. ");
INSERT INTO kde_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Mwenu mmene nni mmashahidi mma àlalá lavanatendenge anyakala venu na mùnakubaliana navo, kwa kuva vanang'o vánivawalala manabii na mwenu mùvadengela misati yavo. ");
INSERT INTO kde_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Bahi ing'anya ya anelyo, Nnungu kwa lúnda lwake átangwele kuchidoni, ‘Nìmbevapelekeja manabii na mitume, henga vanji vàmbevawalala na vanji vàmbevabaniha.’ ");
INSERT INTO kde_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Bahi vanu va chívelèkwà achino vàlembelewa vahukumiwe asabu ing'anya ya kuwalalwa kwa manabii vammalele kutandikila pachiumbwije chilambo, ");
INSERT INTO kde_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","kutandikila kuwalalwa kwa Habilu mpaka kuwalalwa kwa Sakaliya anawalelwe nnuwani lwa Ing'ande ya Nnungu, ching'ati Ing'ande ya Nnungu na chitala cha kuhumija sadaka. Nangu nìnnyaulilanga uhiu kuva, vanu va chívelèkwà achino vàmbehukumiwa asabu ing'anya ya kuwalalwa kwa vanu anevo vammalele. ");
INSERT INTO kde_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ole wenu mwenu Mmakuhunda Sheliya! Kwa kuva, mùvapakanywele vanu ntukulo wa pachinu pakulihunda elimu. Na mwenu mmene mukáinjidile, na avala vachiinjîla mùnivadivila vanainjile.” ");
INSERT INTO kde_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu paukile apala, Mafalisayo na Vakúhunda Sheliya nkulindamuka kunnyongahonga kwa kumuja vitukutuku vyohe, ");
INSERT INTO kde_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","uvachinga vapate kunkamula kwa lilove lyohelyo libaya lyambetangola. ");
INSERT INTO kde_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Muuhiku uwowo mmuluku wa maelufu la vanu vákojene pamo mpaka kutandilika kukadambana. Yesu nkutandilika kutangola na vakuhundwa vake nahoti wachidoni, “Lyongolelange na hamila ya Mafalisayo, yani ulamba wavo. ");
INSERT INTO kde_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kila chinu chihinikwîje chìmbehunukuliwa, na kila chinu chipihîjwe chìmbepihuliwa. ");
INSERT INTO kde_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Bahi malove lamutangwele nnupi, vanu vàmbelapilikana chihi panng'anje, na achila chimunyinyite nng'ande, chìmbeyanjajwa chihi palangele. ");
INSERT INTO kde_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nangu nìnnyaulilanga mwenu mmayanjavangu kuva, munavayope avala vahulûla chihi kuuwalala mmili na lukoto nanga chinji chívahulùlà kuchitenda. ");
INSERT INTO kde_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Henga nguchininnanguje ayula alembelêwa kuyopwa, nnyopange Nnungu avêle na dimongo dya kummwalala munu, na akàmalila kummwalala ànahulula kunnyaha munu mmoto wa Jihannamu. Nangu nìnnyaulilanga kuva, nnyopange nang'e. ");
INSERT INTO kde_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Dachi, vyuni vijoko nnyano vikásumiswa chihi kwa dihela kadiki? Henga wala nanga chuni kananga chimo chilivalîwa na Nnungu. ");
INSERT INTO kde_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Henga mwenu ata isabu ya ulindo wa myuti yenu Nnungu àniimala. Bahi munayope, kwa kuva, mwenu nni mma maana namene kupunda vyuni vyohe! ");
INSERT INTO kde_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Nangu nìnnyaulilanga mwenu kuva, munu woheyo anguyambukîla nangu muyo mwa vanu kuva nang'e nni wang'une, Mwana wa Munu achiannyambukile munu aneyo muyo mwa malaika vanga Nnungu. ");
INSERT INTO kde_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Henga munu angukâna nangu muyo mwa vanu, Mwana wa Munu achiankane munu aneyo muyo mwa malaika vanga Nnungu. ");
INSERT INTO kde_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Na munu woheyo antangolêla malove lahakalenge Mwana wa Munu, aneyo achiasamehewe. Henga munu ambenkufûlu Umumu Wanaswe, aneyo akambesamehewa. ");
INSERT INTO kde_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Pavambenkamulanga na kumpelekejanga unansitaki n'ding'umbi dya ing'ande ya kunnyuwila Nnungu na muyo mwa vajumbe na akútawala, munave na lipamba namuna chimumbehwena unayang'ula au chimumbetangola. ");
INSERT INTO kde_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kwa kuva, uhiku uwowo Umumu Wanaswe achiannyunde chimulembelewa kutangola.” ");
INSERT INTO kde_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Munu yumo nnikuwa alila lya vanu, nkunnyaulila Yesu kuchidoni, “Nkúhunda, nnyaulile nkulwangu tuyavane mapala latulekedile atata wetu.” ");
INSERT INTO kde_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu nkunnyang'ula kuchidoni, “Nnyanjawangu, nnani anguvikîle nangu kuva nkúhukumu au kuva munu wa kunnyavanyija vitukutuku vyenu?” ");
INSERT INTO kde_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Yesu nkuhweneha kuvahaulila vanu vammalele kuchidoni, “Lyongolelange na mulinyemye na tama ya dimali, kwa kuva, umi wanga munu ukáhalokana na dimali dyohe dyavenadyo.” ");
INSERT INTO kde_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Anepo Yesu nkuvahaulila nfano auno wachidoni, “Pávele na munu yumo nkúpata ánavele na welu uvêle vilyo vyohe. ");
INSERT INTO kde_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Aneyo nkúpata nkuva waliuja chimundamunda kuchidoni, ‘Vino ngutende dachi na nangu nikávele na pachinu pakuvika vilyo vyangu vyammalele?’ ");
INSERT INTO kde_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Anepo aneyo munu nkulihaulila kuchidoni, ‘Nìmbetenda uvila, nìmbehadulanga makangala langu, koka ngudenge lanji makulungwa namene, koka anemwo ngutaye vilyo vyangu na vitukutuku vyangu vyammalele. ");
INSERT INTO kde_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Koka anepo niuhaulile ntima wangu kuva, hambi ùvele na vitukutuku vyohe vyulivikidile akiba kwa vyaka vyohe, vino yewelela, ilya, kumbila na uhangalale.’ ");
INSERT INTO kde_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Henga Nnungu nkuchidoni, ‘Livelu wako, chilo chanelo umi wako ùmbetwaliwa. Dachi, vitukutuku anevyo vyulivikidile akiba vìmbekuva vyanga nnani?’ ” ");
INSERT INTO kde_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu nkumalilila kwa kutangola kuchidoni, “Uvila njo chava munu alivikîla akiba ya vitukutuku vyohe, henga pameho panga Nnungu akávalangiwa kuva nkúpata.” ");
INSERT INTO kde_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Anepo Yesu nkuvahaulila vakuhundwa vake kuchidoni, “Bahi ing'anya ya anelyo, nangu nìnnyaulilanga kuva, munààve na lipamba ing'anya ya maisha lenu, kuva mùmbekulya chani au mùmbewala chani. ");
INSERT INTO kde_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kwa kuva, maisha lenu nni la mana namene, akee chihi kwajili ya chakulya weka. Na miili yenu nni ya mana namene akee chihi kwajili ya dinguwo weka. ");
INSERT INTO kde_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Valolange anamikonda, nanga pavapanda wala nanga pavafuna na wala nanga pavavele na lichehe wala likangala. Henga Nnungu ànavalisa. Mwenu ni mma mana namene kupunda vyuni! ");
INSERT INTO kde_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Alida mmwenu kwa kulikambya-kambya namene ànahulula kuyenjeja kananga lisaa limo mmaisha lake? ");
INSERT INTO kde_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Na ikàva mukáhulula kutenda chinu chijoko malinga anecho, mwadachi mùnalikambyakambya ing'anya ya vitukutuku vinji? ");
INSERT INTO kde_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Lalolange namuna mauwa chilakulumuka. Wala nanga palakola madengo na wala nanga palalitotela lene dinguwo. Henga nangu nìnnyaulilanga kuva, ata Nfalume Selemani pamo na ukulu wake wanavele nawo, henga nanga panawahite kuwajwa saana muchi liuwa limo mmauwa anelo. ");
INSERT INTO kde_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Mwenu mmanu muvêle na ing'ulupa inyoko, ikàva Nnungu àlawaja uchocho mauwa la kumawelu lapwâwa chihi nelo, nundu nkuyahwa mmoto, dachi, Nnungu akambepunda kummwajanga mwenu saana? ");
INSERT INTO kde_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Bahi munalikambyekambye namene kutaha chakulya au chikumbilo. ");
INSERT INTO kde_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kwa kuva, anevyo vyammalele njo vivátàhà namene vanu va pachilambo. Henga Atata wenu Nnungu ànimala kuva mùnisikikila anevyo. ");
INSERT INTO kde_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Bahi tandilika kuukambi-kambila Ufalume wa Nnungu nahoti, na anelo lammalele Nnungu achiamwing'ange. ");
INSERT INTO kde_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Mwenu likuwa lijoko, munayope! Kwa kuva, Atata wenu ànikatapaliwa kumwing'a mwenu Ufalume wake. ");
INSERT INTO kde_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Sumisanga vimuvenavyo koka dihela muveng'e amahuvani. Likatapajije mipatila ya dihela ikákandika, na kulikondidya dimali kulihunde, kudikambemalilika. Aneko nkwiva akáingila na wala nanga vakoko vaondongânga. ");
INSERT INTO kde_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kwa kuva, apala padivele dimali dyako njo padimbeloleha ding'ano dyako.” ");
INSERT INTO kde_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Lihungange nkanda mmikundu vyenu uchinga mùùve tayali kutumika, na vibatali vyenu vììve uviyaka. ");
INSERT INTO kde_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mùùve muchi vanu vannolêla nang'olo wavo auye kuhaloka kuing'ole ya ulombi koka palambehodika, upopo vanchimulile. ");
INSERT INTO kde_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Wasa vatumishi avala Nang'olo wavo pambekamola nkuvakoja vavèlè meho! Nangu nìnnyaulilanga uhiu kuva, nang'olo aneyo àmbelihunga nkanda nchikundu na kuvahaulila vaikalange uchinga valye, koka aide avatumikile. ");
INSERT INTO kde_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Wasa vatumishi anevo, nang'olo wavo akàvakoja vapanganìkè ata kwauya ching'ati chilo au kulyamba! ");
INSERT INTO kde_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Henga mwenu mùnimala kuva, kuikave mwene ing'ande waumala uhiku wambekwida nkwiva unaiva, akánanneke nkwiva watutumula ing'ande yake. ");
INSERT INTO kde_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Na mwenu uchocho, lipanganihange kwa kuva, Mwana wanga Munu àmbekwida uhiku umukalolela mwenu.” ");
INSERT INTO kde_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petulo nkummuja Yesu kuchidoni, “Nang'olo, nfano anewo ùtwamba chihi hwetu au ùvamba na vanu vanji vammalele?” ");
INSERT INTO kde_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yesu nkuyang'ula kuchidoni, “Dachi, ntumishi alida akulupîka na avêle na ding'ano? Nni ayula wammikile nang'olo wake kuvaimilila vatumishi vanji na kunnaija aveng'e chakulya kwa uhiku ulembelêwa. ");
INSERT INTO kde_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Wasa ntumishi aneyo ikàva pambeida nang'olo wake àmbenkoja watenda chalaijijwe. ");
INSERT INTO kde_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nangu nìnnyaulilanga uhiu kuva, nang'olo aneyo àmbemmika ntumishi aneyo kuva nkwímilila wa dimali dyake dyammalele. ");
INSERT INTO kde_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Dachi, ìmbekuva dachi kwa ntumishi aneyo akàlihaulila kuva, ‘Nang'olo wangu ànatima kuuya,’ nkutandilika kuvapanya vatumishi avake akuno walya na kukumbila na kukalewa? ");
INSERT INTO kde_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Nang'olo wa aneyo ntumishi àmbeuya nniduva lyakalolela na uhiku wakaumaite. Àmbencheketanya vibeduli vivili ntumishi aneyo na kummika pachinu pavikwîje kwajili ya vanu vakákulupila. ");
INSERT INTO kde_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Bahi ntumishi amaîte chalembela nang'olo wake, henga analipanganihe, na anatende chalembela nang'olo wake, aneyo ntumishi àmbeasibiwa namene. ");
INSERT INTO kde_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Henga ntumishi ayula akámaite saana chalembela nang'olo wake, henga nkutenda mambo lalembelêwa kuasibiwa, aneyo ntumishi àmbeasibiwa chihi kadiki. Kwa kuva, munu apewîje vitukutuku vyohe àmbelongwa vyohe, na munu akamujîjwe vitukutuku vyohe, àmbelongwa vyohe.” ");
INSERT INTO kde_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Nangu ngùidile unakumbanya moto pachilambo, na nangu nikanitamwa namene niwone uyakile tayali! ");
INSERT INTO kde_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Henga ngùvele na ubatiso wa ibanihwi ungulembelewa ngubatiswe, na nangu nauhimukila namene mpaka panimbeutimisa. ");
INSERT INTO kde_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Dachi, mwenu mùtenda kuva nangu ǹniida uchinga nguide na amani pachilambo? Nangu nìnnyaulilanga mwenu kuva, akee amani, henga ǹniida uchinga nivatende vanu vayavanyike. ");
INSERT INTO kde_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kwa kuva, kutandikila vino, vanu nnyano va ing'ande imo vàmbehapukana, vatatu vàmbehapukana na vavili na vavili vàmbehapukana na vatatu. ");
INSERT INTO kde_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Atata àmbehapukana na mwanawe wa chilume, na mwana wa chilume àmbehapukana na atatake na mama àmbehapukana na mwanawe wa chimahe na mwana wa chimahe àmbehapukana na anyokwe, na mukwe àmbehapukana na nkawake na mmahe àmbehapukana na mukwe.” ");
INSERT INTO kde_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu nkuvahaulila vanu kuchidoni, “Pamulona mahunde ulahaloka m'bali wa mangalibi, mùhaula kuva, ‘Imbula ìmbetonya,’ na ìnatonya. ");
INSERT INTO kde_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Na pamulyona lipungo lya kusini ulipunga, mùhaula kuva, ‘Kùmbekuva na chitukuta,’ na njo chiiva. ");
INSERT INTO kde_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mwenu mmakulilambilila! Mwenu mùnahulula kulauja hali ya hewa kwa kuchiloleha chilambo na kumahunde, vino mwadachi mukáhulula kulamala mahiku alano la vino?” ");
INSERT INTO kde_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Mwadachi mwenu mùnalemwa kuchimala chitukutuku chambone cha kuchitenda? ");
INSERT INTO kde_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kwa kuva, ikàva mmongo mwalo àkupelekeja kulukumbi unakusitaki, tumbama kupatana nawe kabla mukànambihwika, ukanatende uchocho nkúhukumu àmbekupelekeja kwa litiyala, na litiyala nkunakuchimila nnilungu. ");
INSERT INTO kde_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nangu nìkuhaulila kuva, anemwo ukambehuma mpaka paumbemalilila ulipa senti ya ntululilo.” ");
INSERT INTO kde_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mahiku anelo pávele na vanu vanannyaulidile Yesu habali dya vanu va Galilaya vanavawalele Pilato pavachinnyumija Nnungu sadaka. ");
INSERT INTO kde_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu nkuvahaulila kuchidoni, “Dachi, mwenu mùtenda anevo Vagalilaya váwalelwe namuna aneyo ing'anya vátenda lahakalenge namene kupunda Vagalilaya vanji vammalele? ");
INSERT INTO kde_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nanga, akee uchocho! Henga nangu nìnnyaulilanga mwenu kuva, mukanaleke masambi, uchocho na mwenu muchimwondongwe. ");
INSERT INTO kde_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Dachi, vanu kumi na nane vanamatokewije na nnala wa vakúlolihija aneko ku Siloamu, nkuhwanga, mùtenda kuva vanang'o vátenda lahakalenge kupunda vanu vanji váchiikala ku Yelusalemu? ");
INSERT INTO kde_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nanga, akee uchocho! Henga nangu nìnnyaulilanga mwenu kuva, mukànaleke masambi, uchocho na mwenu muchimwondongwe.” ");
INSERT INTO kde_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Anepo Yesu nkuvahaulila auno nfano wachidoni, “Pávele na munu yumo ánavele na nnandi wa ntini mmwelu wake wa mizabibu. Munu aneyo nkuhwena unahepa vihepo munnandi anewo, henga nanga panachikojije chihepo kananga chimo. ");
INSERT INTO kde_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Bahi aneyo munu nkunnyaulila nkúlolihija welu kuchidoni, ‘Lola, achino chaka cha tatu unguida ungulembela nguhepe vihepo munnandi auno, henga nikápata chihepo. Vino uchekete! Mwadachi uhwenehe chihi kuutumila ulongo bule?’ ");
INSERT INTO kde_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Henga nkúlolihija welu nkunnyang'ula kuchidoni, ‘Nang'olo, namwaka uleke nahoti, niulimile na kuutaila mbolea. ");
INSERT INTO kde_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Na ukàpa vihepo mwaka uîda, ichiikatapale, na ukanape unaucheketa.’ ” ");
INSERT INTO kde_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Liduva limo lya Kuyewelela, Yesu ávenkuhunda muing'ande ya kunnyuwila Nnungu. ");
INSERT INTO kde_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Upala, nkuhaloka mmahe anavele na nanndenga anantendile ahuvange kwa vyaka kumi na nane. Mmahe aneyo álamele mongo na ikáchihululika kuudula wala kadiki. ");
INSERT INTO kde_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu pammwene aneyo mmahe, nkunchema, nkunnyaulila uvila, “Mama, ùnihunguliwa kuhaloka muihuvangi yako!” ");
INSERT INTO kde_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yesu nkummikila makono aneyo mmahe, upala mmili wake nkuudukanga kavila, nkutandilika kunnombolela Nnungu. ");
INSERT INTO kde_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nkulungwa wa ing'ande ya kunnyuwila Nnungu nkutunduwila ing'anya Yesu ánnamije aneyo mmahe Nniduva lya Kuyewelela. Bahi nkuvahaulila vanu kuchidoni, “Mwenu mùvele na maduva sita la kukola madengo. Bahi kamolanga mmaduva anelo mukalamywe, henga munaide unalamywa Nniduva lya Kuyewelela.” ");
INSERT INTO kde_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Anepo Nang'olo nkunnyang'ula aneyo nkulu kuchidoni, “Mwenu mmakulilambilila! Dachi, alida mmwenu akánchimulila ung'ombe wake au punda wake nchitundu Nniduva lya Kuyewelela nkumpelekeja unankumbija medi? ");
INSERT INTO kde_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ayuno mmahe achibanîhwa na nanndenga kwa myaka kumi na nane nni munu wa nnitawa lya Iblahimu, dachi ikáchilembelewa alamywe ikànava Liduva lya Kuyewelela?” ");
INSERT INTO kde_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesu patangwele anelo, vanu vammalele vachintahuka nkwonanga dihoni, henga vanu vanji nkuhangalala ing'anya ya vitukutuku vyambone vya kukanganya vyatendile Yesu. ");
INSERT INTO kde_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Anepo Yesu nkuvauja kuchidoni, “Dachi, Ufalume wanga Nnungu ùlandana na chani? Dachi, niulandanye na chamani? ");
INSERT INTO kde_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ùvele muchi imbeyu ya haladali yanatwete munu yumo nkuipanda mmwelu wake, nkumela na kukulumuka nkuva nnandi nkulungwa. Vyuni nkudenganga vitehi vyavo n'dinavi dyake.” ");
INSERT INTO kde_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu nkuuja kavila kuchidoni, “Dachi, Ufalume wanga Nnungu niulandanye na chamani? ");
INSERT INTO kde_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ùlandana na hamila yanatwete mmahe yumo, nkuikundanya na uhu wohe wa ngano, na lidonji lyammalele nkuumuka.” ");
INSERT INTO kde_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu nkuhweneha mwanda wake kuhwena ya ku Yelusalemu wapitila n'dimanga na mmijiji, wavahunda vanu. ");
INSERT INTO kde_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Munu yumo nkummuja Yesu kuchidoni, “Nang'olo, dachi vanu vambepôhwa vàmbekuva chihi kadiki?” Yesu nkuyang'ula kuchidoni, ");
INSERT INTO kde_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Tumbama namene, muinjilile kwa kupitila nnango uhonêne, ing'anya vanu vohe vàmbelembela kwinjila, henga nanga pavambehulula. ");
INSERT INTO kde_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mwene ing'ande palembeimila nkunachima nnango, mwenu mùmbeimila chihi pawelu na kutandilika kuhodikanga, umuchidoni, ‘Nang'olo, tuchimulile nnango.’ Henga nang'e àmbennyang'ula kuchidoni, ‘Nikánkamekenge mwenu wala kumuhalokanga!’ ");
INSERT INTO kde_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Anepo njo pamumbennyaulila kuchidoni, ‘Hwetu njo tuvanu tuchilya na kukumbila chalumo na wako, na wako wanihunda n'dindila dya mmijiji vyetu.’ ");
INSERT INTO kde_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Henga nang'e àmbekuchidoni, ‘Nikánkamekenge mwenu wala kumuhalokanga! Ukananga apano pang'une, mwenu mmammalele mmakutenda lahakalenge!’ ");
INSERT INTO kde_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Mwenu mùmbekuta na kuhaya meno, kwa kuva, mùmbemwona Iblahimu na Isaka na Yakobo na manabii vammalele vavèlè mu Ufalume wa Nnungu, akuno mwenu muyahìjwè pawelu! ");
INSERT INTO kde_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Vanu vàmbeida kuhaloka mmipata yammalele ya chilambo, nkuikala na kulya paing'ole mu Ufalume wanga Nnungu. ");
INSERT INTO kde_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Anepo vanu vaonekâna hambi kuva vakulu, vàmbekuva va pahi, na vanu vohe vaonekâna hambi kuva va pahi, vàmbekuva vakulu.” ");
INSERT INTO kde_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Upala, Mafalisayo vanji nkummwenela Yesu nkunnyaulila kuchidoni, “Apano uka uhwene pachinu panji, kwa kuva Nfalume Helode àlembela akuwalale.” ");
INSERT INTO kde_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu nkuvayang'ula kuchidoni, “Hwena mukannyaulile Helode, akalamwîke muchi nancheta kuva, ‘Nelo na nundu nìvausa anamindenga na kuvalamya vagonjo, na palyamba nìmbemalila madengo langu.’ ");
INSERT INTO kde_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nelo na nundu na palyamba, nangu ngùlembelewa nguhwenehe na mwanda wangu wa ku Yelusalemu, kwa kuva, ikáhululika nabii vammwalalile pachinu panji ikànave chihi ku Yelusalemu. ");
INSERT INTO kde_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Mwenu mmanu mma ku Yelusalemu, mmanu mma ku Yelusalemu! Mwenu mùvawalala manabii na kuvapanya mayanga avala vatumwîje kwenu mwenu. Myanda yohe ǹnilinga kuvalopolela pamo vana venu muchi ung'uku chavautamila vana vake paliungu dimapa dyake, henga mwenu nanga pamutamwije. ");
INSERT INTO kde_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Lola, Ing'ande yenu ya Nnungu ìmbekuva lihame. Na nangu nìnnyaulilanga kuva, mukambengwona kavila mpaka pamumbehaula kuva, ‘Ubalikiwe wako uîda kwa lina lya Nang'olo.’ ” ");
INSERT INTO kde_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Liduva limo lya Kuyewelela, Yesu ápite unalya chakulya kukaya kwanga nkulungwa yumo wa Mafalisayo, vanu nkuva uvannoleha namene Yesu. ");
INSERT INTO kde_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Muyo mwanga Yesu, múvele na munu ánavele na ugonjo wa kuvimbanga mmili. ");
INSERT INTO kde_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu nkuvauja vakúhunda Sheliya ya Musa na Mafalisayo kuchidoni, “Dachi, ìnaluhusiwa au ikáluhusiwa kunnamya munu Nniduva lya Kuyewelela?” ");
INSERT INTO kde_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Henga vanang'o nkunyalala chihi. Yesu nkunkamula ayula n'gonjo, nkunnamya, nkunnuhusu ahwene. ");
INSERT INTO kde_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Anepo nkuvauja avala vanu kuchidoni, “Ikàva munu yumo mmwenu, mwanawe au ung'ombe wake àmatokedile nchihima Nniduva lya Kuyewelela, dachi akambemmusa nniduva anelyo?” ");
INSERT INTO kde_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Henga vanang'o nanga pavanahulwile kunnyang'ula. ");
INSERT INTO kde_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu pavawene vayeni vakumbuliwîje uvalitandolela viteng'u vya muyo, nkuvahaulila kuchidoni, ");
INSERT INTO kde_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Munu akàkukumbula kuing'ole ya ulombi, unaikale chiteng'u cha muyo, uyopa ànahaloka munu wa kwesimika namene kukupunda wako. ");
INSERT INTO kde_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Mukànatende uchocho, àmbeida ayula ankumbwîle mmammalele mmavili nkukuhaulila kuchidoni, ‘Mpishe ayu aikale.’ Anepo ùlembekwona dihoni paumbekuva uhwena unaikala chiteng'u cha nnyuma. ");
INSERT INTO kde_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Wako ukàkukumbulwa kuing'ole, ikala chiteng'u cha nnyuma, uchinga ayula ankumbwîle pambehaloka akuhaulile kuchidoni, ‘Nnyanjawangu, ida uikale mmiteng'u vya muyo.’ Anepo njo paumbetumbyangika pameho pavanu vammalele vavêle anepo. ");
INSERT INTO kde_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kwa kuva, kila munu alitumbyânga mwene àmbesulupuswa, na munu alisulupûha, àmbetumbyangwa.” ");
INSERT INTO kde_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Anepo Yesu nkunnyaulila ayula munu ankumbwîle kuchidoni, “Pauteleka chakulya cha muhi au nalyulo, unavakumbule ayanjavako wala anung'unuvako wala alangavako wala avandikani mwalo vakúpata, kwa kuva, ukàtenda uchocho navanang'o vàmbekukumbula wako kumakande lavo na kukulipa malinga chunavatendedile vanang'o. ");
INSERT INTO kde_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Henga wako pauteleka chakulya cha ing'ole, vakumbule amahuvani na vanu valamele na vikwavi na vaputêle meho. ");
INSERT INTO kde_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ukàtenda uchocho, uchiubalikiwe, ing'anya vanang'o vakambehulula kukuuihija. Kwa kuva, Nnungu achiakuuihije nniduva alila livambefufuliwa vanu vambone pameho panga Nnungu.” ");
INSERT INTO kde_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Munu yumo anaikele pachakulya pamo na Yesu papilikene malove anelo nkuhaula kuchidoni, “Wasa munu ayula ambekûlya chakulya cha ing'ole mu Ufalume wa Nnungu.” ");
INSERT INTO kde_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu nkunnyang'ula kuchidoni, “Munu yumo áteleke chakulya cha ing'ole ing'ulungwa nkuvakumbula vanu vohe. ");
INSERT INTO kde_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Pauhwikile uhiku wa kulya chakulya cha ing'ole, ayula munu nkuntuma ntumishi wake akavahaulile vakumbuliwîje kuva, ‘Idang'ana, kila chinu chìvele tayali.’ ");
INSERT INTO kde_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Henga vammalele nkuhitang'ana ing'anya kila munu ávele na madengo lake. Munu ntandi nkunnyaulila ayula ntumishi kuchidoni, ‘Nangu nikambeida, ing'anya ngùsumile welu, na ngùlembelewa nguhwene nikaulole, chonde ngùyuwa ungusamehe.’ ");
INSERT INTO kde_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Munu wavili nkuchidoni, ‘Nangu nikambeida ing'anya nìvasumile ang'ombe kumi va kulimila, vino ngùvele nndila ngùhwena unavalinga, chonde ngùyuwa ungusamehe.’ ");
INSERT INTO kde_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Na munu yunji watatu nang'e nkuhaula kuchidoni, ‘Nangu nikambeida, ing'anya ngùlombile uvino.’ ");
INSERT INTO kde_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ayula ntumishi nkuuya nkunannyaulila nang'olo wake àlalá malove. Ayula nang'olo papilikene uchocho nkuvisa, nkunnyaulila ntumishi wake kuchidoni, ‘Piyanya kuhwena n'dibalabala na n'dindila dya imanga ukaide na amahuvani na vanu valamele na vaputêle meho na vikwavi.’ ");
INSERT INTO kde_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ayula ntumishi nkuchidoni, ‘Nang'olo, lammalele lungulaijije ǹnilatenda, henga mpaka vino nafasi ya kuikala ìvechinkupwawa.’ ");
INSERT INTO kde_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ayula nang'olo nkunnyaulila ntumishi wake kuchidoni, ‘Hwena n'dibalabala na n'dindila divêle pawelu imanga ukavakolokohe vanu vaide vainjile, uchinga ing'ande yangu iumbale. ");
INSERT INTO kde_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nangu nìnnyaulilanga kuva, muvanu avala vanakumbuliwije patandi, wala nanga munu kananga yumo ambeyêja chakulya cha ing'ole yangu.’ ” ");
INSERT INTO kde_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Anepo makuwa makulungwa la vanu nkuva uvalondojana na Yesu. Yesu nkupindikuka, nkuvahaulila kuchidoni, ");
INSERT INTO kde_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Munu woheyo alembêla kuva nkuhundwa wangu, henga akávele tayali kuhapukana na atatake na anyokwe na mmahe wake na anavake na anung'unuvake na alumbuvake na ata maisha lake, aneyo akáhulula kuva nkuhundwa wangu. ");
INSERT INTO kde_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yani munu woheyo akánatamwe kuunyakula nsalaba wake na kungupapata, aneyo akáhulula kuva nkuhundwa wangu. ");
INSERT INTO kde_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Dachi, munu ntwani mmwenu alembêla kudenga nnala wa vakúlolihija, akámbeikala pahi nahoti nkutenda isabu ya galama ya nnala wammalele, uchinga amale ikàva achiave na dihela dya kumalilila? ");
INSERT INTO kde_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kwa kuva, akàtandilika chihi kuudenga nsingi koka anahulule kuumalilila nnala anewo, vanu vammalele valôla vàmbennyeka, ");
INSERT INTO kde_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","uvachidoni, ‘Munu ayu àtandilike kuudenga nnala, henga nanga pahulwile kuumalilila.’ ");
INSERT INTO kde_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Dachi, nfalume alida ahwêna unapanyana ing'ondo na nfalume yunji, akáikala pahi hoti nkukumbukilanya, ikàva matiyala lake alufu kumi lànahulula kupanyana na ayula nfalume annyidîla avèlè na matiyala alufu ishilini? ");
INSERT INTO kde_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Bahi akàona kuva akambehulula, àmbevatuma vajumbe vake vahwene kwanga ayula nfalume yunji avèlè chihi kulehu, vakannyuwe pààve na amani. ");
INSERT INTO kde_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Uchocho, nanga munu mmwenu ambehulûla kuva nkuhundwa wangu, akànaleke kila chinu chavenacho.” ");
INSERT INTO kde_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Munyu nni chinu chambone. Henga inowi yake ikàhang'uka, dachi, ùmbetaywa chamani uchinga inowi yake iuyile kavila? ");
INSERT INTO kde_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ukáfala kavila kananga kuutaya muulongo wala kuukundanya na mbolea. Henga ùyahwa chihi kulehu. Avêle na makutu la kupilikana, apilikane!” ");
INSERT INTO kde_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Liduva limo akútwala kodi vohe na vanu vohe vahaulîka kuva nni vakútenda masambi, vámmwenedile Yesu uchinga vampilikanile. ");
INSERT INTO kde_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Henga Mafalisayo na vakúhunda Sheliya yanga Musa nkulindamuka kuhinginika uvachidoni, “Nnolange munu ayu àvapwechelela vakútenda masambi na kulya navo!” ");
INSERT INTO kde_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesu nkuvahaulila auno nfano wachidoni, ");
INSERT INTO kde_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Dachi, alida mmwenu akàva na angandolo myamoja, nkumala kuva ungandolo yumo àniyahika, akambevaleka avala tisini na tisa kulilanga uvalya, nkuhwena unantaha ayula ayahîke mpaka amwone? ");
INSERT INTO kde_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Na akàmwona àmbennyakula mmavala, akuno wahangalala. ");
INSERT INTO kde_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Akàhwika kukaya, àmbevachema ayanjavake pamo na avandikani mwave, avahaulile kuchidoni, ‘Hangalala pamo na nangu, ing'anya ǹnimwona ungandolo wangu anayahike.’ ");
INSERT INTO kde_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Uchocho, na mwenu nìnnyaulilanga kuva, uvila njo chivambehangalala aneko kulihunde ing'anya ya nkútenda masambi yumo alekîle kutenda masambi. Vàmbennyangalalila namene aneyo munu kupunda vanu tisini na tisa valyôna kuva vambone, na vakálembelewa kuleka masambi.” ");
INSERT INTO kde_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Dachi, ikàva mmahe yumo àvele na dihela kumi dya nnyoyo, nkunnyahika imo, àmbetenda dachi? Àmbechacha chibatali, apyaile ing'ande yammalele waitaha mpaka ayone. ");
INSERT INTO kde_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Akàyona aneyo hela, àmbevachema ayanjavake na avandikani mwave na kuvahaulila kuchidoni, ‘Hangalala pamo na nangu ing'anya hela yangu inayahike ǹniyona!’ ");
INSERT INTO kde_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Uchocho na mwenu nìnnyaulilanga kuva, uvila njo chivahangalala malaika va Nnungu ing'anya ya munu yumo alekîle masambi.” ");
INSERT INTO kde_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu nkuhweneha kuvahaulila kuchidoni, “Pávele na munu yumo ánavele na vana vavili vachilume. ");
INSERT INTO kde_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ayula mwana n'joko nkunnyaulila atatake kuchidoni, ‘Atata, ning'e mapala langu.’ Bahi atata wavo nkuvayavanyija. ");
INSERT INTO kde_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Palapite maduva kadiki, ayula n'joko nkusumisanga mapala lake lammalele nkuuka kuhwena chilambo cha kulehu, aneko nkudyondonga dihela dyake kwa maisha la uwaamba. ");
INSERT INTO kde_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pamalidile kila chinu chanavenacho, nkuhaloka indala ing'ulungwa nchilambo achila chammalele, nanang'e nkulindamuka kubanika. ");
INSERT INTO kde_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Bahi nkuhwena kwanga mwenedi yumo wa aneko unayuwa chibaluwa, nanang'e nkumpelekeja kumawelu kwake unavachunga anguluve. ");
INSERT INTO kde_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Aneyo mwana ánitamwa namene kulya makahi lavachilya anguluve, henga nanga munu anamwing'ile. ");
INSERT INTO kde_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Bahi nkutandilika kulihimukila mwene, nkulihaulila kuchidoni, ‘Amadengo vangapi va atatangu vâlya, nkutolejwa na kulekelela, na nangu apano unguhwa na indala? ");
INSERT INTO kde_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nìmbeuka, nguhwene kwa atatangu nikannyaulile kuva, atata, nangu nìnkosedile Nnungu na wako mwalehu. ");
INSERT INTO kde_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nangu nikálembelewa kavila kuchemwa nimwanalo. Ngùtende muchi yumo wa vatumishi vako.’ ");
INSERT INTO kde_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Bahi nkutakatuka, nkuhwena kwa atatake. Pánavele kulehu, atatake nkumwona, nkummikila chididi, nkuntukutila nkunkumbatila na kum'busu. ");
INSERT INTO kde_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ayula mwana nkunnyaulila atatake kuchidoni, ‘Atata, nangu nìnkosedile Nnungu na wako mwalehu. Nangu nikálembelewa kavila kuchemwa nimwanalo.’ ");
INSERT INTO kde_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Henga atatake nkuvahaulila vatumishi vake kuchidoni, ‘Piyanya kwida na inguwo ikatapêle na pete na vilatu mummwajange! ");
INSERT INTO kde_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Koka muntwale ung'ombe anunîle munsinje, uchinga tulye na kuhangalala! ");
INSERT INTO kde_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kwa kuva, kwang'une mwanangu ávele muchi ànihila, henga vino mumi, na ávele muchi àniyahika, henga vino ànioneka.’ Bahi nkutandilika kuhangalalila. ");
INSERT INTO kde_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Palachitendeka anelo, mwanawe nkulungwa ávele kumawelu. Pahwikile pepi na ing'ande, nkupilikana dihimu na vanu uvavina. ");
INSERT INTO kde_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nang'e nkunchema ntumishi yumo nkummuja kuchidoni, ‘Pàvele chinu chihumidîle?’ ");
INSERT INTO kde_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ayula ntumishi nkunnyang'ula kuchidoni, ‘Nnung'uno àniuya, na atatako ànsinjidile ung'ombe anunîle kwa kuva, mwanawe ànimmuila akuno avèlè mumi.’ ");
INSERT INTO kde_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ayula mwana nkulungwa nkuvisa, nkuhita kwingila nng'ande. Bahi atatake nkuhuma pawelu nkunnyuwa aingile nng'ande. ");
INSERT INTO kde_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nang'e nkunnyang'ula atatake kuchidoni, ‘Lola, nangu ǹnikutumikila muchi ntumwa kwa vyaka vyammalele, na ǹnidikamula amuli dyako dyammalele. Henga ukánaning'a kananga imbudi yamwana nguhangalale chalumo na ayanjavangu! ");
INSERT INTO kde_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Henga páidìlè ayu mwanalo aondongênge dihela dyako kwa makahaba, ùnsinjidile ung'ombe anunîle.’ ");
INSERT INTO kde_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Atatake nkunnyang'ula kuchidoni, ‘Mwanangu, wako ùvele pamo na nangu maduva lammalele, na kila chinu chinguvele nacho, nni chako. ");
INSERT INTO kde_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Hwetu tùlembelewa tuhangalale na kushangilila kwa kuva, nnung'uno ávele muchi ànihwa, henga vino mumi na ávele muchi àniyahika, henga vino ànioneka.’ ” ");
INSERT INTO kde_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu nkuvahaulila vakuhundwa vake kuchidoni, “Pávele na nkúpata yumo ánavele na nkwímilila wake. Aneyo nkúpata vánnyaulidile kuva nkwímilila wake àondonganga dimali dyake. ");
INSERT INTO kde_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Aneyo nkúpata nkunchema nkwímilila wake nng'ande, nkummuja kuchidoni, ‘Malove ntwani ala langupilikana kukwamba wako? Humya isabu ya dimali dyangu dyammalele, kwa kuva, wako ukambekuva nkwímilila wangu kavila.’ ");
INSERT INTO kde_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ayula nkwímilila nkuliuja kuva, ‘Vino ngutende dachi? Kwa kuva, nang'olo wangu àmbenguvinganga madengo, na dimongo dya kulima nikávenajo, na kuyuwa-yuwa nangu ngwòna dihoni. ");
INSERT INTO kde_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Vino ǹnimala chakutenda uchinga panimbevingangwa madengo vanu vàngupwechelele mmakande lavo.’ ");
INSERT INTO kde_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Anepo nkuvachema yumo-yumo vanu vammalele vachivalonga nang'olo wake. Nkutandilika kummuja ntandi kuchidoni, ‘Nguhaulile, nang'olo wangu àkulonga chinu ntwani?’ ");
INSERT INTO kde_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nang'e nkuyang'ula kuchidoni, ‘Milengelo myamoja ya mahuta la seituni.’ Ayula nkwímilila nkunnyaulila kuchidoni, ‘Ikala pahi utwale baluwa yako ya mapatano la lideni, uleembe kuva ùlongwa milengelo amsini.’ ");
INSERT INTO kde_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nkummuja wavili kuchidoni, ‘Wako ùlongwa chinu ntwani?’ Nang'e nkuyang'ula kuchidoni, ‘Magunila myamoja la ngano.’ Ayula nkwímilila nkunnyaulila kuchidoni, ‘Ikala pahi utwale baluwa yako ya mapatano la lideni, uleembe kuva ùlongwa magunila samanini.’ ");
INSERT INTO kde_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Bahi ayula nang'olo nkunnombolela namene ayula nkwímilila akákulupika, ing'anya ya lúnda lwake. Kwa kuva, vanu va chilambo achino vàtumila namene lúnda pavakola madengo na avao, kupunda vanu va Ufalume wa Nnungu.” ");
INSERT INTO kde_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Bahi Yesu nkuhweneha kutangola kuchidoni, “Nangu nìnnyaulilanga kuva, tùmilanga dimali dya pachilambo kwa kuvatenda vanu kuva ayanjavenu, uchinga padimbehila, vanang'o vampwechelange mmakao lakávele na ntululilo. ");
INSERT INTO kde_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Munu woheyo akulupîka kwa lijoko namene, ànahulula kukulupika na kwa likulungwa mwalehu. Na munu woheyo akákulupika kwa lijoko namene, akáhulula kukulupika na kwa likulungwa. ");
INSERT INTO kde_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mukànakulupike kwa dimali dya pachilambo, dachi, nnani ambehulûla kunkulupilanga mwenu, nkumwing'anga mali ya uhiu ya kulihunde? ");
INSERT INTO kde_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na ikàva mukáhulula kukulupika n'dimali dya munu yunji, dachi, nnani ambemwing'ânga mali yenu mmene? ");
INSERT INTO kde_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nanga ntumishi ahulûla kuvatumikila anang'olo vavili. Kwa kuva, akàtenda uchocho, àmbemmenga yumo na kuntamwa yunji au àmbekamulana na yumo na kunsalau yunji. Mwenu mukambehulula kuntumikila Nnungu akuno umuditumikila na dimali.” ");
INSERT INTO kde_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Bahi Mafalisayo pavapilikene malove anelo nkuntendela Yesu mang'wanyu kwa kuva, vanang'o nni vanu vaditâmwa namene dimali. ");
INSERT INTO kde_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesu nkuvahaulila kuchidoni, “Mwenu mùlilanguja kwa vanu kuva mmambone pameho pa Nnungu, henga Nnungu àniimala mitima yenu, kwa kuva, chinu chionekâna kuva chambone pameho pavanu, pameho panga Nnungu nni chinu chichîmwa namene.” ");
INSERT INTO kde_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Sheliya yanga Musa na malemba la manabii lánihubiliwa mpaka mmahiku langa Yohana Nkúbatisa. Bahi kutandikila mahiku anelo langa Yohana, Malove Lambone la Ufalume wanga Nnungu lànahubiliwa, na kila munu ànatumbama kuinjila muufalume anewo. ");
INSERT INTO kde_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Henga ìnipeyapeya namene chilambo na lihunde kupita kuliko kuuka sehemu inyoko ya lilove mu Sheliya ya Musa. ");
INSERT INTO kde_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Nnume woheyo annêka n'jawe, nkunannomba mmahe yunji, aneyo àlalá ugoni, na kila nnume annômba mmahe alekwîje, nanang'e àlalá ugoni.” ");
INSERT INTO kde_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Pávele na munu yumo nkúpata, achiwala dinguwo digalîka namene na kupoka maduva lammalele. ");
INSERT INTO kde_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Na pávele na munu yunji mmahuvani lina lyake Lasalo. Munu aneyo ávele na vilonda mmili wammalele, na álala chihi pannango wanga ayula nkúpata. ");
INSERT INTO kde_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Aneyo munu ánatamwa namene kulya makombo lamatwêke pameza yanga ayula nkúpata. Ata ang'avanga vánaida uvannamba vilonda vyake. ");
INSERT INTO kde_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Bahi ayula mmahuvani nkuhila, malaika nkuntwala nkunammika pachinu pávèlè Iblahimu. Na ayula nkúpata nanang'e nkuhila, nkunsika. ");
INSERT INTO kde_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ayula nkúpata pánavele nkubanihwa namene pachinu pavanu vahwîle, nkukusumbula meho, nkumwona Iblahimu kwa kulehu, akuno Lasalo avèlè pamo na Iblahimu. ");
INSERT INTO kde_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Bahi ayula nkúpata nkunonoha lidi wachidoni, ‘Atata Iblahimu, ngùvikile chididi, ntùme Lasalo àchuvike chala chake mmedi, alupoje lulimi lwangu, kwa kuva, mbènkubanihwa namene mmoto auno.’ ");
INSERT INTO kde_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Henga Iblahimu nkunnyang'ula kuchidoni, ‘Mwanangu, kumbukila kuva, wako punavele mumi pachilambo úpete mambo lambone, henga Lasalo ápete mambo lakávele lambone, henga vino àvenkutujwa ntima wake apano na wako ùvenkubanihwa namene. ");
INSERT INTO kde_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Pamo na anelo, aneko kumuvele mwenu na akuno kutuvele hwetu paching'ati pàvikwije lipondo likulungwa namene, uchinga vanu valembêla kuuka akuno kwida aneko vanahulule, na valembêla kwida akuno kuhaloka aneko vanahulule.’ ");
INSERT INTO kde_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ayula nkúpata nkuchidoni, ‘Hambi Iblahimu atatangu, nakuyuwa namene untume Lasalo ahwene kukaya kwa atatangu, ");
INSERT INTO kde_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","aneko kùvele anung'unuvangu nnyano, nnuhusu ahwene akavadume uyopa vànaida pachinu apano pakubanihwa!’ ");
INSERT INTO kde_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Henga Iblahimu nkuchidoni, ‘Anung'unuvako vàvele na malemba langa Musa na manabii la kuvaduma, valeke valapilikanile anelo.’ ");
INSERT INTO kde_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ayula nkúpata nkuchidoni, ‘Iblahimu atatangu, anelo weka lakátosa. Henga akàhwena munu kuhaloka akuno kukuhwa vachivaleke masambi lavo.’ ");
INSERT INTO kde_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Iblahimu nkunnyaulila kuchidoni, ‘Vakanalapilikane malemba langa Musa na manabii, ata kwahwena munu kuhaloka kwa vanu vahwîle, vakambempilikana.’ ” ");
INSERT INTO kde_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu nkuvahaulila vakuhundwa vake kuchidoni, “Mambo lavakuvâja vanu kutenda masambi lasima laide, henga ole wake munu ambetendîha laide. ");
INSERT INTO kde_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ikàvele wasa munu aneyo ahungwe liyanga likulungwa lya kuhayila muukoti na kuyahwa m'bahali, kuliko kuntenda yumo wa avano vajoko alikuvale kwa kutenda masambi. ");
INSERT INTO kde_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Bahi ing'anya ya anelyo, lichungange! Ikàva nnung'uno ànikukosela, n'dume, na akàleka kutenda makosa lake, nsamehe. ");
INSERT INTO kde_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ata kuiva àkukosedile myanda saba nniduva limo, nkukuidila kwa myanda saba wakuhaulila kuva, ‘Ngusamehe,’ wako nsamehe.” ");
INSERT INTO kde_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Mitume nkunnyaulila Nang'olo Yesu kuchidoni, “Tuyenjeje ing'ulupa.” ");
INSERT INTO kde_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nang'olo nkuvayang'ula kuchidoni, “Kuikavele umuva na ing'ulupa inyoko malinga imbeyu ya haladali, mukaniuhaulila nsulufaji auno kuva, ‘Daboka ukalipandikije m'bahali,’ na unang'o ukanimpilikana.” ");
INSERT INTO kde_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ikàva munu yumo mmwenu àvele na ntumwa wake alîma mmwelu au achûnga dingandolo, dachi, pauya kuhaloka kumawelu ànnyaulila kuva, ‘Ida chihi uikale ulye chakulya?’ ");
INSERT INTO kde_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nanga! Henga àmbennyaulila kuva, ‘Tandilika kungutalakela chakulya nahoti, koka ulipanganihe uchinga ungutumikile panimbekuva ungulya na kukumbila, nikàmalila kulya koka ulye wako.’ ");
INSERT INTO kde_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Dachi, wako ùtenda aneyo nang'olo achianshukulu ntumwa aneyo ing'anya ya kuva ànilatenda àlalá lannyaulidile alatende? ");
INSERT INTO kde_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Bahi namwenu uchocho, mukàmalila kukola madengo lamutumwije kulatenda kachidoni, ‘Hwetu nni tuvatumishi chihi tukálembelewa kutumbyangwa, tùtendile chihi madengo latulembelewa kulatenda bahi.’ ” ");
INSERT INTO kde_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu pánavele nndila kuhwena ku Yelusalemu nkupita ching'ati chilambo cha ku Samaliya na chilambo cha Galilaya. ");
INSERT INTO kde_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pánavele nkuinjila pachijiji fulani, nkunnyidila vanu kumi vánavele na mangundula, nkuimilanga kulehu kadiki na pávèlè nang'e, ");
INSERT INTO kde_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","nkunonohanga lidi uvachidoni, “Yesu, Nang'olo, tùvikile chididi!” ");
INSERT INTO kde_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu pavawene nkuvahaulila kuchidoni, “Hweneng'ana mukalilanguje kwa makuhani.” Pavanavele nkuhwena, nkulamyangwa. ");
INSERT INTO kde_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Munu yumo muavala kumi pawene kuva ànilama, nkuuya kwanga Yesu wanonoha lidi wannombolela Nnungu. ");
INSERT INTO kde_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nkuhunama muyo pamadodo langa Yesu akuno wanshukulu. Na munu aneyo ávele Nsamaliya. ");
INSERT INTO kde_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu nkuuja kuchidoni, “Dachi, vakanalamijwe vammalele kumi? Hambi vanji tisa vàvele kwachi? ");
INSERT INTO kde_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Dachi, nanga vanu vanji vauyite unanshukulu Nnungu ila uyoyu mmidi bahi?” ");
INSERT INTO kde_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yesu nkunnyaulila ayula munu kuchidoni, “Imila uhwene, ing'ulupa yako ìnikulamya.” ");
INSERT INTO kde_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mafalisayo fulani nkummuja Yesu kuchidoni, “Ufalume wa Nnungu ùmbeida chakani?” Yesu nkuvayang'ula kuchidoni, “Ufalume wa Nnungu ukáida kwa namuna yonekana kwa meho. ");
INSERT INTO kde_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nanga munu ambehaûla kuva, ‘Ùvele apano!’ au, ‘Ùvele apala!’ Kwa kuva, Ufalume wa Nnungu ùvele nkati mwenu.” ");
INSERT INTO kde_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Bahi Yesu nkuvahaulila vakuhundwa vake kuchidoni, “Mahiku làvenkwida lamumbelambela namene mumwone kavila Mwana wa Munu, henga mukambemwona mmahiku anelo. ");
INSERT INTO kde_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Vanu vanji vàmbennyaulilanga kuva, ‘Àvele apala!’ au, ‘Àvele apano!’ Henga mwenu munauke na wala munavapapate. ");
INSERT INTO kde_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kwa kuva, kwida kwanga Mwana wa Munu kùmbekuva muchi nng'anje wa ing'uva chuhumila gafula kumahunde na kulangaja kuhaloka m'bali umo mpaka unji. ");
INSERT INTO kde_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Henga àlembelewa atandilike kubanika namene hoti, na kuhitwa na vanu va chívelèkwà achino. ");
INSERT INTO kde_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Malinga chiinavele mmahiku langa Nuhu, njo chiimbekuva mmahiku la kwida kwanga Mwana wa Munu. ");
INSERT INTO kde_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mahiku anelo vanu vánalya na kukumbila, vánalomba na kulombwa mpaka uhiku aula wanaingidile Nuhu musafina, livambwe nkuida nkuvaondonganga mwalehu vanu vammalele. ");
INSERT INTO kde_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Mahiku anelo làmbekuva muchi chilanavele mahiku langa Lutu. Vanu vánalya na kukumbila, vánasuma na kusumisa, vánapanda dimbeyu na kudenga. ");
INSERT INTO kde_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Henga liduva alila lyanaukile Lutu ku Sodoma, moto na baluti iyâka vínisulupuka muchi imbula kuhaloka kulihunde nkuvaondonganga mwalehu vanu vammalele. ");
INSERT INTO kde_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Bahi uvila njo chiimbekuva nniduva anelyo lyambehunukuliwa Mwana wa Munu. ");
INSERT INTO kde_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Liduva anelyo munu avêle muha ing'ande analitinike kwa kutukutila nng'ande unatwala vitukutuku vyake. Na avêle kumawelu nanang'e uchocho, anauye kukaya. ");
INSERT INTO kde_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kumbukilanga àlalá lanankojije n'jawe Lutu! ");
INSERT INTO kde_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Munu woheyo alembêla kuupoha umi wake, aneyo achiauyahe, na munu woheyo ambeuyâha umi wake, aneyo achiaupohe. ");
INSERT INTO kde_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nangu nìnnyaulilanga kuva, chilo anecho vanu vavili vàmbekuva valèlè chinanda chimo, yumo àmbetwaliwa na yunji àmbelekwa. ");
INSERT INTO kde_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Vamahe vavili vàmbekuva pamo uvahaya ntama nniyanga, yumo àmbetwaliwa na yunji àmbelekwa.  ");
INSERT INTO kde_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Vanu vavili vàmbekuva mmwelu, yumo àmbetwaliwa na yunji àmbelekwa.” ");
INSERT INTO kde_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Vakuhundwa nkummuja Yesu kuchidoni, “Kwachi Nang'olo?” Nanang'e nkuvayang'ula kuchidoni, “Pauvele ntuhi, njo pavambekojana vipungo.” ");
INSERT INTO kde_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Anepo Yesu nkutumila nfano kuvahunda vakuhundwa vake kuvalanguja kuva vàlembelewa vannyuwe Nnungu uhiku wammalele bila kukata tama. ");
INSERT INTO kde_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nkuvahaulila kuchidoni, “Muimanga fulani múvele na nkúhukumu yumo akáchinnyopa Nnungu wala kuvatamwa vanu. ");
INSERT INTO kde_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Na muimanga uyoyo múvele na mmahe nannidi. Mmahe aneyo áhwena-hwena kwanga ayula nkúhukumu bila kukata tama wannyuwa kuchidoni, ‘Chonde nangu nìkuyuwa utende haki kati yangu na mmongo mwangu.’ ");
INSERT INTO kde_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kwa maduva lohe ayula nkúhukumu nkuva wahita kunnyangata ayula mmahe, henga kuntululilo nkulitangolela mwene chimunda-munda wachidoni, ‘Pamo na kuva nangu nikánnyopa Nnungu na wala kuntamwa munu woheyo, ");
INSERT INTO kde_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","henga kwa kuva ayu mmahe ànanguhopeja, nguchinimwing'e chivêle chake, uchinga anaide apano wanguhopeja!’ ” ");
INSERT INTO kde_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Nang'olo Yesu nkuhweneha kutangola kuchidoni, “Lola namuna chanahawile ayula nkúhukumu akátenda haki. ");
INSERT INTO kde_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Dachi, Nnungu akambeveng'a haki yavo vanu vake vavatandwêle, vankutîla chilo na muhi? Dachi, achiatime kuvayangata? ");
INSERT INTO kde_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nangu nìnnyaulilanga kuva, achiapiyanye kuveng'a haki yavo. Henga dachi, Mwana wa Munu pambeida achiaikoje ing'ulupa pachilambo?” ");
INSERT INTO kde_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu nkuvahaulila nfano auno vanu valyôna kuva vambone na kuvasalau vanu vanji, ");
INSERT INTO kde_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","wachidoni, “Vanu vavili vániyomboka kuhwena ku Ing'ande ya Nnungu unayuwa, yumo ávele Nfalisayo na yunji ávele nkútwala kodi. ");
INSERT INTO kde_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ayula Nfalisayo nkuimila, nkuyuwa chimundamunda wachidoni, ‘Wako Nnungu, nakushukulu kwa kuva nangu nikávele muchi vanu vanji, malinga vakwiva, vatênda lahakalenge na valâla ugoni, na wala nikávele muchi ayu nkútwala kodi. ");
INSERT INTO kde_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nangu ngùfunga maduva mavili kwa lijuma, na nahumya asilimiya kumi ya vitukutuku vyangu vyammalele víngupàtà.’ ");
INSERT INTO kde_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Henga ayula nkútwala kodi nkuimila kulehu, na wala nanga panalingile kananga kulola meho lake kulihunde, henga alipanyile-panyile chihi pachihuva kwa kulihinginikila wachidoni, ‘Nnungu, ngùvikile chididi nangu nguvêle na masambi!’ ” ");
INSERT INTO kde_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesu nkuchidoni, “Nangu nìnnyaulilanga kuva, ayula nkútwala kodi ápite kukaya kwake akuno Nnungu wamwona kuva wambone, henga akee ayula Nfalisayo. Kwa kuva, kila munu alitumbyânga mwene, àmbesulupuswa, na munu alisulupûha, àmbetumbyangwa.” ");
INSERT INTO kde_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Vanu vanji nkuvapelekeja vana vajoko kwanga Yesu uchinga avabaliki kwa kuvavikila makono. Vakuhundwa vake pavalawene anelo nkuvakalipila avala vanu. ");
INSERT INTO kde_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Henga Yesu nkuvachema vana vajoko vammwenele, nkuhaula kuchidoni, “Valekange anevo vana vajoko vaide kwang'une, wala munavadivile, kwa kuva, Ufalume wanga Nnungu nni wa vanu vavêle muchi vavana ava. ");
INSERT INTO kde_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nangu nìnnyaulilanga uhiu kuva, munu woheyo akáupwechela Ufalume wanga Nnungu muchi mwana n'joko, nanga pambeinjila mu Ufalume anewo.” ");
INSERT INTO kde_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nkulu yumo wa Chiyahudi nkummuja Yesu kuchidoni, “Nkúhunda wambone, ngutende chamani uchinga niupate umi ukee na ntululilo?” ");
INSERT INTO kde_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu nkunnyaulila kuchidoni, “Ing'anya ntwani ùnguchema wambone? Nanga munu wambone ila Nnungu weka. ");
INSERT INTO kde_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Wako ùnidimala amuli dya Nnungu dihaûla kuva, ‘Unalale ugoni, unawalale, unaive, unahumye ushahidi wa kulambila na mweshimu atatako na anyoko.’ ” ");
INSERT INTO kde_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nang'e nkuyang'ula kuchidoni, “Amuli anedyo dyammalele ǹnidikamula kutandikila ujoko wangu.” ");
INSERT INTO kde_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu papilikene anelo nkunnyaulila kuchidoni, “Wako ùisaliwije na chinu chimo chukanambitenda. Hwena ukasumise kila chinu chuvenacho, koka dihela uvayavile amahuvani, anepo unava na dimali kulihunde, koka uide ungupapate.” ");
INSERT INTO kde_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Henga ayula munu papilikene anelo, nkupoyoka namene ing'anya ávele na dimali dyohe. ");
INSERT INTO kde_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu pammwene ayula munu apoyweke nkuchidoni, “Ìnikamajanga namene vakúpata kuinjila mu Ufalume wanga Nnungu! ");
INSERT INTO kde_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kwa kuva, ìnipeyapeya namene kwa nnyama uvanchema ungamila kupita nchitonono cha chitotelo kuliko nkúpata kuinjila mu Ufalume wa Nnungu.” ");
INSERT INTO kde_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Vanu vammalele pavapilikene anelo nkuuja kuchidoni, “Ikàva uchocho, nnani bahi ambehulûla kupohwa?” ");
INSERT INTO kde_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu nkuvayang'ula kuchidoni, “Lakáhululika kutendeka kwa dimongo dya chimunu, Nnungu ànahulula kulatenda lammalele.” ");
INSERT INTO kde_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Anepo Petulo nkunnyaulila Yesu kuchidoni, “Lola, hwetu tùlekile vitukutuku vyetu vyammalele nkukupapata!” ");
INSERT INTO kde_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu nkuvahaulila kuchidoni, “Nangu nìnnyaulilanga uhiu kuva, munu woheyo ailekîle ing'ande yake au mmahe wake au anung'unuvake au vammalêke au vavana ing'anya ya Ufalume wa Nnungu, ");
INSERT INTO kde_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","àmbepata vyohe namene mmaisha alano la vino, na mahiku laîda àmbepata umi ukee na ntululilo.” ");
INSERT INTO kde_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu nkuvatwala vakuhundwa vake kumi na mbili nkuhwena navo pannyenje, nkuvahaulila kuchidoni, “Pilikananga! Tuvenkuyomboka kuhwena ku Yelusalemu, aneko kila chinu chilembwîje na manabii kumwamba Mwana wa Munu chimbenatimiswa. ");
INSERT INTO kde_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ambekamujwa kwa vanu vakávele Vayahudi koka vantendele mang'wanyu na kuntangolela lahakalenge na kunsunila mata, ");
INSERT INTO kde_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","na kunsulubula koka vammwalale, henga liduva lya tatu lya kuhwa kwake ambefufuka.” ");
INSERT INTO kde_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Henga vakuhundwa vake nanga pavanamaite chinu chohecho, kwa kuva, vánipihwa mana lake na nanga pavanamayite Yesu amba chamani. ");
INSERT INTO kde_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu pánavele pepi na imanga ya ku Yeliko, munu yumo anaputêle meho áikele nnyenje indila wayuwa nsada. ");
INSERT INTO kde_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Papilikene likuwa lya vanu ulipita nkuuja kuchidoni, “Kùvele chamani?” ");
INSERT INTO kde_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nkunnyang'ula, kuchidoni, “Yesu wa ku Nasaleti àvenkupita.” ");
INSERT INTO kde_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nang'e nkunonoha lidi wachidoni, “Yesu, n'dukuluwe Nfalume Daudi, ngùvikile chididi!” ");
INSERT INTO kde_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Vanu vannongoledîle Yesu nkunkalipila uvannyaulila anyalale, henga nang'e nkunanoha namene lidi wachidoni, “N'dukuluwe Nfalume Daudi, ngùvikile chididi!” ");
INSERT INTO kde_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu nkuimila, nkuvalaija vanu vaidenawe. Ayula munu pahwikile pepi, Yesu nkummuja kuchidoni, ");
INSERT INTO kde_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ùlembela nikutendele chamani?” Nang'e nkuyang'ula kuchidoni, “Nang'olo, ngùlembela ngupate kulola.” ");
INSERT INTO kde_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu nkunnyaulila kuchidoni, “Bahi uloole! Ing'ulupa yako ìnikulamya.” ");
INSERT INTO kde_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Upala ayula munu anaputele meho nkupata kulola, nkuva wannondola Yesu akuno wantumbyanga Nnungu. Na vanu vammalele pavalawene anelo, navanang'o nkunnombolela Nnungu. ");
INSERT INTO kde_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu painjidile muimanga ya Yeliko, nkuva walumulanya imanga aneyo. ");
INSERT INTO kde_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Muimanga aneyo múvele na munu yumo lina lyake Sakayo, nkulungwa wa vakútwala kodi, na ávele nkúpata. ");
INSERT INTO kde_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Munu aneyo ánitumbama namene uchinga amwone Yesu kuva nni munu wa namuna ntwani, henga nanga panahulwile kumwona ing'anya ya likuwa likulungwa lya vanu na ániinjipala namene. ");
INSERT INTO kde_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Sakayo nkutukutila muyo, nkunakwela munnandi nkulungwa uchinga amwone Yesu, kwa kuva, njo indila yambepita Yesu. ");
INSERT INTO kde_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu pahwikile apala nkulola muha, nkunnyaulila kuchidoni, “Sakayo, sulupuka upehi, kwa kuva, nelo ngùlembelewa nguyewelele nng'ande mwako.” ");
INSERT INTO kde_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakayo nkupiyanya kusulupuka, nkunkalibisa Yesu kukaya kwake kwa kuhangalala. ");
INSERT INTO kde_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Vanu pavalawene anelo, nkutandilika kutangodikanga uvachidoni, “Àpite unakamolela kwa nkútenda masambi.” ");
INSERT INTO kde_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Henga Sakayo nkwimila nkunnyaulila Yesu kuchidoni, “Nang'olo, pilikanila! Nusu ya dimali dyangu nìmbeveng'a amahuvani, na ikàva ngùtwete chinu changa munu kwa ulamba, nìmbemmuihija myanda ncheche.” ");
INSERT INTO kde_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu nkunnyaulila kuchidoni, “Nelo upohi ùnivakamolela vanu va ing'ande aino, kwa kuva, ayuno nanang'e nni n'dukuluwe Iblahimu. ");
INSERT INTO kde_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kwa kuva, Mwana wa Munu àidile unavataha na kuvapoha vanu vayahîke.” ");
INSERT INTO kde_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Vanu pavachipilikanila malove anelo, Yesu nkuvahaulila nfano unji kwa kuva ávele pepi na imanga ya ku Yelusalemu, na anevo vanu vátenda kuva Ufalume wa Nnungu ùvele pepi na kukamola. ");
INSERT INTO kde_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yesu nkuvahaulila kuchidoni, “Pávele na munu yumo wa nnitawa lya chifalume ánapite chilambo cha kulehu uchinga akatandolwe na nfalume nkulu kuva nfalume wa chilambo chake, koka auye. ");
INSERT INTO kde_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Bahi kabla akànambiuka, nkuvachema vatumishi vake kumi, nkuvayavanyija dihela kumi dya samani ing'ulungwa namene, nkuvahaulila kuchidoni, ‘Dihela adino tendelanga uchuusi mpaka panimbeuya.’ ");
INSERT INTO kde_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Henga laiya avake vánammenga. Bahi anevo vanu nkuvatuma vanu vakahaule kuchidoni, ‘Ayu munu tukántamwa ààve nfalume wetu.’ ");
INSERT INTO kde_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pamo na anelo, ayula munu ániuya akuno atandolwejìjè kuva nfalume. Pakamwele kukaya, nkuvatuma vanu vakavacheme avala vatumishi vake vanavayavidile dihela uchinga amale kila munu àpete faida ntwani. ");
INSERT INTO kde_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nkuhaloka ntumishi ntandi nkuchidoni, ‘Nang'olo, hela imo yunaning'ile dìyenjejeke dihela dinji mpaka kuhwikila dihela kumi.’ ");
INSERT INTO kde_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Nang'olo nkunnyaulila kuchidoni, ‘Ùtendile sana, wako nni ntumishi wambone. Bahi kwa kuva ùnikulupika kwa vitukutuku vijoko, nìmbekuvika kuva nkútawala wa dimanga kumi!’ ");
INSERT INTO kde_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Nkuhaloka ntumishi wavili nkuchidoni, ‘Nang'olo, hela imo yunaning'ile dìyenjejeke dihela dinji mpaka kuhwikila dihela nnyano.’ ");
INSERT INTO kde_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nang'olo nkunnyaulila kuchidoni, ‘Na wako nìmbekuvika kuva nkútawala wa dimanga nnyano.’ ");
INSERT INTO kde_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nkuhaloka ntumishi yunji nkuchidoni, ‘Nang'olo, hela yako yunaning'ile aino. Nangu ńniihutika saana nchitambala na kuikondya, ");
INSERT INTO kde_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","kwa kuva, ńnikuyopa ing'anya wako nni umunu ukalîpa, utwâla lakávele lako na ufûna chukapandile.’ ");
INSERT INTO kde_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nang'olo wake nkunnyaulila kuchidoni, ‘Wako ntumishi nkútenda lahakalenge, nìmbekuhukumu ing'anya ya malove lako umwene! Kumbe wanimala kuva nangu nni munu ngukalîpa, ngutwâla vikávele vyangu na kufuna vinikapandile. ");
INSERT INTO kde_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ing'anya ntwani ukanaivikile hela yangu benki uchinga panimbeuya nguipate hela yangu na inji iyenjejêke?’ ");
INSERT INTO kde_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Anepo ayula nang'olo nkuvahaulila vanu vanaimilenge apala kuchidoni, ‘Mpakanyolange aneyo hela, mukamwing'e ayula avêle na dihela kumi.’ ");
INSERT INTO kde_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Vanang'o nkuchidoni, ‘Nang'olo, aneyo tayali àvele na dihela kumi!’ ");
INSERT INTO kde_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Aneyo nang'olo nkuvayang'ula kuchidoni, ‘Nangu nìnnyaulilanga kuva, kila munu avêle na chinu àmbeyenjejwa. Henga munu akávele na chinu ata achila kadiki chavenacho àmbepokonyolwa. ");
INSERT INTO kde_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na vino avala amongo vangu vakáchitamwa nangu ngùùve nfalume wavo, idanavo apano, muvawalale pameho pangu.’ ” ");
INSERT INTO kde_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu pamalidile kutangola anelo, nkutandilika kuyomboka kuhwena ku Yelusalemu. ");
INSERT INTO kde_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Panavele pepi na kuhwika chijiji cha ku Betifage na ku Besaniya, palichinga lichêmwa Lichinga lya Miseituni, nkuvatuma vakuhundwa vake vavili, ");
INSERT INTO kde_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","nkuvahaulila kuchidoni, “Hwena mpaka chijiji chivêle muyo mwenu. Pamumbekamola, muchimumwone mwana wa punda akánambiikalwa na munu woheyo vampambilidìlè. Nnyungulange muide nawe apano. ");
INSERT INTO kde_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Munu woheyo ambemmûja kuva ing'anya ntwani mùnannyungula, nnyaulile kuva, ‘Nang'olo ànannembela.’ ” ");
INSERT INTO kde_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Avala vakuhundwa vatumwîje nkuhweneng'ana, nkunakoja muchi chavahaulidile Yesu. ");
INSERT INTO kde_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Pavanavele nkunnyungula ayula punda, vene nkuvauja nkuchidoni, “Ing'anya ntwani mùnannyungula?” ");
INSERT INTO kde_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Vanang'o nkuyang'ula kuchidoni, “Nang'olo ànannembela.” ");
INSERT INTO kde_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Vakuhundwa nkuntwala, nkumpelekeja kwanga Yesu, nkulaja dinguwo dyavo muha mwa aneyo punda nkunnyikaja Yesu. ");
INSERT INTO kde_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yesu panavele nkuhwena mwanda, vanu nkulaja dinguwo dyavo nndila. ");
INSERT INTO kde_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yesu panavele pepi na ku Yelusalemu, pantelemuko wa Lichinga lya Miseituni, likuwa lyammalele lya vakuhundwa vake nkutandilika kuhangalalila na kunnombolela Nnungu kwa kunonoha lidi, ing'anya ya masaibu lavalawene, ");
INSERT INTO kde_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","uvachidoni, “Ubalikiwe wako Nfalume, uîda kwa lina lya Nang'olo. Amani ììve kulihunde na atumbyangwe Nnungu avêle muha kulihunde!” ");
INSERT INTO kde_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mafalisayo vanji vanavele nnikuwa alila lya vanu nkunnyaulila Yesu kuchidoni, “Nkúhunda, vadume vakuhundwa vako!” ");
INSERT INTO kde_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu nkuvayang'ula kuchidoni, “Nangu nìnnyaulilanga mwenu kuva, ‘Ava vanu vakànyalala, mayanga alano lachilanonohe malidi.’ ” ");
INSERT INTO kde_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu panavele pepi namene na ku Yelusalemu, na kuyona imanga muyo aneyo mwake nkutandilika kuvahinginikila vanu va pa Yelusalemu akuno wakuta, ");
INSERT INTO kde_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","wachidoni, “Nangu nikanitamwa namene mwenu mmammalele liduva lya nelo mulamale mambo lambeîda na amani! Henga mambo anelo lànipihwa pameho penu. ");
INSERT INTO kde_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kwa kuva, maduva làvenkwida amongo mwenu pavamben'dinguhija lingongo, na kun'dingukanga na kum'bananga kila m'bali. ");
INSERT INTO kde_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Vambenkadambanga mwenu chalumo na vana venu nningongo lyenu, na wala nanga pavambeisalija kananga ing'ande imo ikambebamolwa, ing'anya nanga pamunamaite uhiku wanaidile Nnungu unampohanga.” ");
INSERT INTO kde_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu nkuhwena ku Ing'ande yanga Nnungu, nkutandilika kuvavinganga vanu vachisumisa vitukutuku, ");
INSERT INTO kde_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","wavahaulila kuchidoni, “Ìnilembwa Mmalemba Lanaswe kuva, ‘Ing'ande yangu ìmbekuva ing'ande ya kunnyuwila Nnungu.’ Henga mwenu mùniipindikulanya nkuijuha kuva muchi lipanga lya kulipiha vakúpalaula.” ");
INSERT INTO kde_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kila liduva Yesu nkuva wahunda mu Ing'ande yanga Nnungu. Henga makuhani vakulu na vakúhunda Sheliya yanga Musa pamo na vakulu va vanu nkuva uvataha indila ya kummwalala Yesu, ");
INSERT INTO kde_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","henga nanga pavanapete wasa wa kutenda uchocho, ing'anya vanu vammalele vávenkumpilikaniha. ");
INSERT INTO kde_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Liduva limo Yesu panavele nkuvahunda vanu ku Ing'ande yanga Nnungu na kuvahubilila Malove Lambone, makuhani vakulu na vakúhunda Sheliya ya Musa pamo na vasele va Vayahudi vánimmwenela, ");
INSERT INTO kde_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","nkummuja kuchidoni, “Tuhaulile! Wako ùlatenda alano kwa mamulaka ntwani? Na nnani akupêle mamulaka la kulatenda?” ");
INSERT INTO kde_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Nang'e nkuvayang'ula kuchidoni, “Nanani nìmbemmujanga mwenu chinu chimo. Nguhaulile, ");
INSERT INTO kde_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","dachi, mamulaka langa Yohana Nkúbatisa la kubatisa láhaleke kulihunde au kwa vanu?” ");
INSERT INTO kde_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Vanang'o nkutandilika kuujana vene kwa vene uvachidoni, “Tukàyang'ula kuva làhaleke kulihunde, nang'e àmbetuuja kuva, ‘Hambi mwadachi mukánankulupidile?’ ");
INSERT INTO kde_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Na tukàyang'ula kuva láhaleke kwa vanu, vanu vammalele vàmbetuwalala kwa mayanga, ing'anya vanu vammalele vànakulupila kuva Yohana Nkúbatisa ávele nabii wa Nnungu.” ");
INSERT INTO kde_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Bahi nkunnyang'ula kuchidoni, “Tukámaite kulahaleke.” ");
INSERT INTO kde_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu nkuvahaulila kuchidoni, “Nanani nikambennyaulila kuva ngùlatenda alano kwa mamulaka ntwani.” ");
INSERT INTO kde_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesu nkuhweneha kuvahaulila vanu nfano unji wachidoni, “Munu yumo álimite welu wake wa mizabibu, nkuuyadikisa kwa vakúlima, mwene nkuhwena mwanda wa kulehu, aneko nkuikala vyaka vyohe. ");
INSERT INTO kde_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Paukamwele nchela wa zabibu nkuntuma ntumishi wake ahwene kwa avala vakúlima uchinga akatwale sehemu ya vihepo vya mmwelu wake. Henga avala vakúlima nkumpanya ayula ntumishi, nkumminganga chihi makono weka. ");
INSERT INTO kde_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mwene welu nkuntuma ntumishi yunji wavili, aneyo nanang'e nkumpanya na kuntendela lahakalenge na kumminganga chihi makono weka. ");
INSERT INTO kde_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nkuntuma kavila ntumishi yunji watatu, aneyo nanang'e, nkummika vilonda na kumminganga. ");
INSERT INTO kde_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Bahi ayula mwene welu nkuchidoni, ‘Hambi ngutende dachi? Nìmbentuma mwanangu unintamwa namene, panjika vachivamweshimu.’ ");
INSERT INTO kde_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Avala vakúlima pavammwene ayula mwana, nkuhaulanila kuchidoni, ‘Ayu njo mwene mapala la auno welu. Bahi leka tummwalale koka welu auno ùùve mapala letu.’ ");
INSERT INTO kde_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bahi avala vakúlima nkunnyahila kunyenje welu wa mizabibu, nkummwalala.” Anepo Yesu nkuvauja kuchidoni, “Dachi, ayula mwene welu pambeida àmbevatenda dachi avala vakúlima? ");
INSERT INTO kde_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Àmbeida koka avawalale anevo vakúlima, na anewo welu avayadikise vanu vanji.” Bahi vanu pavapilikene anelo malove nkuchidoni, “Chonde inààve uchocho!” ");
INSERT INTO kde_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Henga Yesu nkuvapalambahija meho, nkuchidoni, “Dachi, Malemba alano Lanaswe làvele na mana ntwani? ‘Liyanga lihitwîje na vakúdenga, hambi lìjukile kuva liyanga likulu lya paindumba, lya muhimu kupunda lammalele!’ ");
INSERT INTO kde_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kila munu ambeyangukîla nniyanga anelyo àmbelumukana, na munu woheyo ulimbemmatokela, àmbetingindika mwalehu.” ");
INSERT INTO kde_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Vakúhunda Sheliya yanga Musa na makuhani vakulu nkuva uvataha namuna ya kunkamula Yesu upala, kwa kuva, vánimala kuva aula nfano ùvamba vanang'o, henga nkuva uvavayopa vanu. ");
INSERT INTO kde_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Bahi vanang'o nkuva uvannoleha saana na kuvatuma vanu vanalitendile kuva vambone uchinga vankamule Yesu kwa malove lake koka vankamuje muutawala na mamulaka la nkulu wa Chiloma. ");
INSERT INTO kde_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Avala vanu nkunnyaulila Yesu kuchidoni, “Nkúhunda, tùnimala kuva wako ùnatangola na kuhunda vitukutuku vya uhiu, na wala nanga paulola kumeho kwanga munu, henga wako ùhunda chihi kwa uhiu kuyamba indila yanga Nnungu. ");
INSERT INTO kde_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Hambi tuhaulile, dachi Sheliya ya Musa ìnatuluhusu au ikátuluhusu hwetu kulipa kodi kwa Nfalume wa Loma?” ");
INSERT INTO kde_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Henga Yesu ánilamala lavachikudungila, nkuvahaulila kuchidoni, ");
INSERT INTO kde_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ngulangujange hela.” Anepo Yesu nkuvauja kuchidoni, “Dachi, ing'ope aino na lina alino lilembwîje apano lyanga nnani?” Vanang'o nkunnyang'ula kuchidoni, “Vyanga Nfalume wa Loma.” ");
INSERT INTO kde_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yesu nkuvahaulila kuchidoni, “Bahi la Nfalume wa Loma mwing'e Nfalume wa Loma na la Nnungu mwing'e Nnungu.” ");
INSERT INTO kde_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bahi anevo vanu nanga pavanahulwile kunkamula kananga kwa lilove lyake limo pameho pavanu, henga nkukangana chihi chavayang'wile, nkunyalalanga. ");
INSERT INTO kde_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Masadukayo vanji vahaûla kuva vahwîle vakáfufuka, nkummwenela Yesu nkummuja kuchidoni, ");
INSERT INTO kde_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Nkúhunda, Musa átulembidile hwetu uvila, ‘Nnume akàhila nkunneka mmahe wake bila kummelekela vana, nnung'une àlembelewa annombe aneyo mmahe, uchinga ammelekele nkuluwe vana.’ ");
INSERT INTO kde_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Bahi pávele na vana saba va chilume va litumbo limo. Mwana ntandi ánnombile mmahe, henga nkuhila chihi bila kummelekela mwana. ");
INSERT INTO kde_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Na mwana wavili nkwenda makande, nanang'e nkuhila bila kummelekela mwana, ");
INSERT INTO kde_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","na watatu nanang'e nkwenda makande nanang'e nkuhila, vammalele saba nkuhilanga bila kummelekela ayula mmahe mwana. ");
INSERT INTO kde_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kuntululilo ayula mmahe nanang'e nkuhila. ");
INSERT INTO kde_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Dachi, liduva livambefufuliwa vanu vahwîle ayula nkongwe àmbekuva wanga nnani? Kwa kuva, valume vammalele saba vániikalana nawe.” ");
INSERT INTO kde_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu nkuvahaulila kuchidoni, “Vanu va mahiku alano vànalomba na kulombwa, ");
INSERT INTO kde_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","henga vanu avala vambevalangîwa kuva vànafala kufufulwa na kuva na umi mmahiku laîda, anevo vakambelomba wala kulombwa. ");
INSERT INTO kde_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kwa kuva, vanu anevo vakambekuhwa kavila, ing'anya vàmbekuva muchi malaika. Vanu anevo vàmbekuva vana vanga Nnungu, ing'anya vànifufulwa kuhaloka kwa vanu vahwîle. ");
INSERT INTO kde_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ata Musa ánimaiha kuva vanu vahwîle vàmbefufuka. Na mmalemba lake latânga kuyamba chihole chichiyâka moto, Musa àntambulanga Nang'olo kuva nni, ‘Nnungu wa Iblahimu, Nnungu wa Isaka, na Nnungu wa Yakobo.’ ");
INSERT INTO kde_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nang'e akávele Nnungu wa vanu vahwîle, henga nang'e ni Nnungu wa vanu vumi, kwa kuva, kwanga nang'e vanu vammalele vààva vumi.” ");
INSERT INTO kde_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Vakúhunda fulani va Sheliya yanga Musa nkuchidoni, “Anepo nkúhunda ùniyang'ula sana.” ");
INSERT INTO kde_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Anepo nkuva nanga munu analingile kummuja kavila. ");
INSERT INTO kde_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu nkuvauja vakuhundwa vake kuchidoni, “Ing'anya ntwani vanu vàhaula kuva Kilisto nni n'dukuluwe Nfalume Daudi? ");
INSERT INTO kde_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Nfalume Daudi mwene ànitangola nchitabu cha Sabuli kuva, ‘Nang'olo Nnungu áninnyaulila Nang'olo wangu kuva, “Ikala mumamulaka langu, m'bali wangu wa kunkono, ");
INSERT INTO kde_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mpaka panimbevatenda amongo vako kuva muchi viteng'u vya kuvika makumbatu lako.” ’ ");
INSERT INTO kde_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Hambi ikàva Nfalume Daudi ànchema Kilisto ‘Nang'olo,’ ìmbehululika dachi Kilisto ààve n'dukuluwe?” ");
INSERT INTO kde_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Vanu vammalele pavachimpilikanila Yesu, Yesu nkuvahaulila vakuhundwa vake kuchidoni, ");
INSERT INTO kde_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Lyongolelange na vakúhunda Sheliya yanga Musa, vanang'o vànatamwa namene kwonga akuno vawètè dinguwo dindehu na kusalimiwa kwa eshima kusakoni na kuikalanga nafasi dya kwesimika n'ding'ande dya kunnyuwila Nnungu na mmiteng'u vya muyo n'ding'ole. ");
INSERT INTO kde_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Vàvapakanyola dimali dyavo anannidi na kulitenda kuva vambone kwa kuyuwa namene! Bahi ing'anya ya anelyo, liduva lya hukumu vàmbepata asabu ing'ulu namene kupunda vanu vanji!” ");
INSERT INTO kde_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu panavele mu Ing'ande ya Nnungu nkuvona vakúpata uvataya sadaka dyavo nnisanduku lya sadaka. ");
INSERT INTO kde_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Uchocho nkumwona nannidi yumo mmahuvani wataya disendi dimbili. ");
INSERT INTO kde_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yesu nkutangola kuchidoni, “Nangu nìnnyaulilanga uhiu kuva, ayuno nannidi mmahuvani àhumije sadaka ing'ulu namene kupunda vanu vammalele. ");
INSERT INTO kde_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kwa kuva, vanu vanji vammalele vàhumije chihi avila viyenjejêke n'dimali dyavo, henga ayu mmahe pamo na umahuvani wake, àhumije vyammalele vyavenavyo.” ");
INSERT INTO kde_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Vakuhundwa vanji nkuva uvalonjelela habali dya Ing'ande yanga Nnungu, namuna chiidengwije kwa mayanga lakatapêle na kuipamba kwa dinujo dihumîjwe kwa Nnungu. Henga Yesu nkuvahaulila kuchidoni, ");
INSERT INTO kde_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Maduva lachilahwike, palambematohijwa pahi mayanga anelo lammalele lamulona, kwa kuva nanga liyanga limbeisalîla muha liyanga linji.” ");
INSERT INTO kde_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Anepo vakuhundwa nkummuja Yesu kuchidoni, “Nkúhunda, vitukutuku anevyo vìmbehumila chakani? Na chimaiho ntwani chimbelangûja kuva vitukutuku anevyo vìvele pepi kuhumila?” ");
INSERT INTO kde_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu nkuvayang'ula kuchidoni, “Lyongolelange uchinga munahochejwe. Kwa kuva, vanu vohe vàmbeida uvalitenda kuva vanang'o njo nangu, uvachidoni, ‘Nangu njo Kilisto,’ na kuhaula kuva, ‘Mahiku làvele pepi.’ Mwenu wala munavapapate vanu anevo. ");
INSERT INTO kde_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Pamumbepilikana habali dya ing'ondo na kulumbana, munayope, kwa kuva, anelo lasima laide hoti, henga ntululilo ukambepiyanya kwida.” ");
INSERT INTO kde_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yesu nkuhweneha kutangola wachidoni, “Chilambo chimo chìmbepanyana na chilambo chinji, na ufalume umo ùmbepanyana na ufalume unji. ");
INSERT INTO kde_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Sehemu dyohe dya chilambo dìmbekuva na nndengendo nkulu, na indala ing'ulu na magonjo la kuwalala vanu vohe, na aneko kumahunde kùmbekwonekana vitukutuku vya kuyoha na vimaiho vikulu. ");
INSERT INTO kde_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Henga anelo lammalele kabla lakànambihumila, mùmbekamulwa na kubanihwa. Mùmbekamujwa mmakono mwa vakulu va ding'ande dya kunnyuwila Nnungu na kuntayanga mmalungu. Uchocho, mùmbepelekejwa unasitakiwa kwa vafalume na kwa vakulu ing'anya yang'une, ");
INSERT INTO kde_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","na uhiku anewo ùmbekuva wasa kwenu mwenu kuva mmashahidi vangu muyo mwavo. ");
INSERT INTO kde_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Henga mwenu kudungilanga mmitima yenu kuva, mukambekambikambila namuna chimumbehwena unavayang'ula, ");
INSERT INTO kde_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","kwa kuva, nangu nguchinimwing'ange malove la kutangola na lúnda luvakambehulula amongo venu kutahukana nalwo wala kuluhita. ");
INSERT INTO kde_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Mùmbetengelekwa na atata venu na ayuvenu na akuluvenu na alangavenu na ayanjavenu, na vanu vanji mmwenu vàmbewalalwa. ");
INSERT INTO kde_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Vanu vammalele vàmbemmenganga ing'anya yang'une. ");
INSERT INTO kde_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Henga nanga ulindo kananga umo wa myuti yenu umbeyahîka. ");
INSERT INTO kde_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kwa kuva, kwa kupililila kwenu muchimuupohe umi wenu. ");
INSERT INTO kde_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Henga pamumbeyona imanga ya Yelusalemu uidingukwa na makuwa la matiyala, bahi mumale kuva kwondongeka kwake kùvele pepi. ");
INSERT INTO kde_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Anepo vavêle nchilambo cha ku Yudeya vatukutile kumachinga na avala vambekûva muimanga ya Yelusalemu vauke, na avala vambekûva kumawelu vanauye muimanga aneyo. ");
INSERT INTO kde_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kwa kuva, mahiku anelo nni mahiku la Nnungu kuvahukumu asabu vanu vake Isilaeli uchinga vitukutuku vyammalele vilembwîje Mmalemba Lanaswe vitimiswe. ");
INSERT INTO kde_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ole wavo amahe vavêle na vitumbo na vayong'êja mmahiku anelo! Kwa kuva, kùmbekuva na ibaniki ing'ulu pachilambo na asabu ing'ulu kwa vanu va chilambo achino cha Vayahudi. ");
INSERT INTO kde_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Vanu anevo vàmbewalalwa kwa upanga, na vanji vàmbetwaliwa litwala na kumwadilihanywa mmilambo vyammalele, na imanga ya Yelusalemu ìmbetawaliwa kwa dimongo na vanu vakávele Vayahudi, mpaka palambemalilika mahiku lávapèlè Nnungu kuitawala imanga aneyo. ");
INSERT INTO kde_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Kùmbekuva na vimaiho nniduva na mmwedi na n'dinondwa. Na vanu va pachilambo vàmbekuva na lipamba ing'anya ya iungulumi na nkuchukuchu wa m'bahali. ");
INSERT INTO kde_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Vanu vàmbedilikanga ing'anya ya kuyopa namene, pavambekuva uvalolela kulona àlalá lambehumîla pachilambo, kwa kuva, vitukutuku vyammalele vya kumahunde vivêle na dimongo, vìmbetikinyika. ");
INSERT INTO kde_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Anepo njo pavambemwona Mwana wa Munu avèlè mmahunde waida, akuno avèlè na dimongo na ukulu nkulu. ");
INSERT INTO kde_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Pavimbetandilika kutendeka vitukutuku anevyo, changamukanga na munyanyulange myuti yenu, kwa kuva, upohi wenu ùvele pepi.” ");
INSERT INTO kde_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Anepo Yesu nkuvahaulila nfano auno wachidoni, “Lola nnandi wa ntini na milandi inji yammalele. ");
INSERT INTO kde_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Pamulona mahamba lake ulahipuka, mùnamala kuva chihuku chìvele pepi. ");
INSERT INTO kde_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Na mwenu uchocho, pamumbelona ulahumila anelo laninnyaulidile, bahi mumale kuva Ufalume wanga Nnungu ùvele pepi. ");
INSERT INTO kde_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nangu nìnnyaulilanga uhiu kuva, vanu va chívelèkwà achino vakambepita mpaka palambetimila anelo lammalele. ");
INSERT INTO kde_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kumahunde na chilambo vìmbepita, henga malove langu lakambepita mwiko.” ");
INSERT INTO kde_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Bahi lyongolelange uyopa mitima yenu ìnatemwa na maisha la uwamba na kukalewa na kukambikambila maisha la apano pachilambo, na anelyo liduva nkunnyidilanga kwa gafula muchi lutambo chiluhatuka. ");
INSERT INTO kde_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kwa kuva, liduva anelyo lìmbevaidila kwa gafula vanu vammalele vaikâla pachilambo. ");
INSERT INTO kde_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Bahi mùùve meho maduva lammalele akuno umuyuwa, uchinga mupate dimongo dya kulinyemya na vitukutuku vyammalele vimbehumîla, na kuimila muyo mwanga Mwana wa Munu.” ");
INSERT INTO kde_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kila liduva Yesu ávahunda vanu ku Ing'ande yanga Nnungu, henga chilo áhwena kulichinga lya Miseituni unalala. ");
INSERT INTO kde_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Vanu vammalele váyumuka ulyamba na mambumbu uhwena ku Ing'ande ya Nnungu unampilikanila Yesu. ");
INSERT INTO kde_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Sikukuu ya Mikate Ikátaijwe Hamila, ichêmwa Pasaka yavele pepi. ");
INSERT INTO kde_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Bahi makuhani vakulu na vakúhunda Sheliya yanga Musa nkuva uvataha indila ya kummwalala Yesu, henga nkuva uvavayopa vanu. ");
INSERT INTO kde_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nanchindenga nkumwingila Yuda uvanchema Isikaliote, yumo wa vakuhundwa vake kumi na mbili. ");
INSERT INTO kde_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Anepo Yuda nkuuka, nkuhwena unatangola na makuhani vakulu na vakulu va vakúlolihija Ing'ande ya Nnungu, namuna chambentengeleka Yesu. ");
INSERT INTO kde_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Vanang'o nkuhangalala namene, nkuyambukilana kuva vàmbemwing'a dihela. ");
INSERT INTO kde_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuda nkukubali, nkutandilika kutaha wasa wa kuntengeleka Yesu pachinu pakávele vanu. ");
INSERT INTO kde_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Bahi liduva lya Sikukuu ya Mikate Ikátaijwe Hamila nkukamola, liduva lyasinjwa ungandolo wamwana wa Pasaka. ");
INSERT INTO kde_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu nkuntuma Petulo na Yohana, nkuvahaulila kuchidoni, “Hweneng'ana mukatwandalile chakulya cha Sikukuu ya Pasaka tupate kulya.” ");
INSERT INTO kde_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Vanang'o nkummuja kuchidoni, “Dachi, ùlembela tukakwandalile kwachi?” ");
INSERT INTO kde_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesu nkuvahaulila kuchidoni, “Pilikanila! Pamumbekuva umuinjila muimanga, muchimukojane na munu yumo anyakwîle chilongo cha medi. Mpapatange munu aneyo mpaka paing'ande yambeinjila. ");
INSERT INTO kde_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Nnyaulile mwene ing'ande kuva, ‘Nkúhunda ànauja kuva, chìvele kwachi chumba chinimbelila chakulya cha Sikukuu ya Pasaka chalumo na vakuhundwa vangu?’ ");
INSERT INTO kde_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nanang'e achiannangujange chumba chikulu cha muha na anecho chìvele na kila chinu, na mwenu andalila anemwo chakulya.” ");
INSERT INTO kde_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bahi avala vakuhundwa nkuhwena, nkunakoja kila chinu chivèlè muchi chavahaulidile Yesu, na vanang'o nkwandaa chakulya cha Sikukuu ya Pasaka anemwo. ");
INSERT INTO kde_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Uhiku pauhwikile, Yesu nkuikala pachakulya chalumo na avala mitume vake. ");
INSERT INTO kde_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Yesu nkuvahaulila kuchidoni, “Kutandikila tangu nangu nnalembela namene kulya chakulya cha Pasaka aino pamo na mwenu kabla nikànambibanihwa. ");
INSERT INTO kde_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nangu nìnnyaulilanga kuva, nikambekulya kavila chakulya cha Pasaka mpaka mana ya Pasaka paimbetimiswa mu Ufalume wa Nnungu.” ");
INSERT INTO kde_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yesu nkutwala chikombe, nkunshukulu Nnungu, nkuchidoni, “Twalanga chikombe achino mulemejane mmammalele. ");
INSERT INTO kde_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nangu nìnnyaulilanga kuva, kutandikila hambi, nikambekumbila kavila divayi mpaka Ufalume wanga Nnungu paumbeida.” ");
INSERT INTO kde_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Uchocho, nkutwala nkate, nkunshukulu Nnungu, nkuumeya nkuveng'a wachidoni, “Auno njo mmili wangu uhûmywa kuva sadaka kwajili yenu mwenu. Bahi tendanga uvila kwa kunguhimukila nangu.” ");
INSERT INTO kde_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Pavamalidile kulya, Yesu nkutwala chikombe chivêle divayi nkuhaula kuchidoni, “Chikombe achino nni lilailano lyahambi lya Nnungu, limaîhwa kwa myadi yangu imwadilîka kwajili yenu. ");
INSERT INTO kde_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Henga ayula ambengutengelêka àvenkulya upano pameza pamo na nangu. ");
INSERT INTO kde_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kwa kuva, Mwana wa Munu àhwena unahwa malinga chapangile mwene Nnungu, henga ole wake munu ayula antengelêka!” ");
INSERT INTO kde_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Vakuhundwa vake nkutandilika kuujana vene kwa vene kuva alida nnikuwa lyavo ambentengelêka. ");
INSERT INTO kde_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Uchocho vakuhundwa nkutandilika kutahukana vene kwa vene kuva alida nkulu nnikuwa lyavo. ");
INSERT INTO kde_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu nkuvahaulila kuchidoni, “Vafalume va vanu vakávele Vayahudi vàvatawala vanu kwa dimongo, na vanu vavêle na mamulaka navanang'o vàlichema kuva, ‘Vanu vavayangâta vanu vao.’ ");
INSERT INTO kde_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Henga kwenu mwenu inave uchocho. Ila nkulungwa mmwenu àlembelewa ààve muchi n'joko kupunda mmammalele, na nkútawala àlembelewa ààve muchi ntumishi. ");
INSERT INTO kde_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Dachi, alida nkulu? Ayula aikêle pameza walya chakulya au ayula annyudumîla ayula âlya? Nkulu nni ayula aikêle pameza. Henga nangu ngùvele nnikuwa lyenu malinga ntumishi. ");
INSERT INTO kde_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Na mwenu njo muhwenehîje kuva chalumo na nangu muuhiku ungulingwa. ");
INSERT INTO kde_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Bahi malinga Atata chaning'ile nangu mamulaka la kutawala, nanani uchocho nìmwing'anga mwenu, ");
INSERT INTO kde_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","uchinga mupate kulya na kukimbila chalumo na nangu mu Ufalume wangu. Uchocho, mùmbeikala mmiteng'u vya chifalume umuvahukumu vanu va matawa kumi na mbili la Isilaeli.” ");
INSERT INTO kde_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu nkuchidoni, “Simoni, Simoni, ngupilikanile! Nanchindenga àyuwite wasa wa kunninganga mwenu uchinga annyapulanyange mwenu na Nnungu malinga munu chapembula ngano na makadakada. ");
INSERT INTO kde_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Henga nangu ǹnikuyuwila wako Simoni uchinga unaleke kunkulupila Nnungu. Na wako paumbenguuyila kavila nangu, uvahwingihe anung'unuvako.” ");
INSERT INTO kde_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petulo nkuchidoni, “Nang'olo, nangu ngùvele chihi tayali kuhwena na wako kulilungu au ata kuhwa pamo na wako.” ");
INSERT INTO kde_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu nkuyang'ula kuchidoni, “Petulo nangu nìkuhaulila kuva, chilo uchino cha nelo, kabla ung'uku akànambikongovela, wako ùmbekuva ungukanìlè myanda mitatu kuva ukáng'ameka.” ");
INSERT INTO kde_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesu nkuvauja kuchidoni, “Pangunantumenge bila kunyakula dihela wala mpatila wala vilatu, dachi músikikidile chinu ntwani?” Vanang'o nkuyang'ula kuchidoni, “Tukanasikikidile chinu chohecho.” ");
INSERT INTO kde_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yesu nkuvahaulila kuchidoni, “Henga hambi, munu avêle na dihela aditwale na munu avêle na mpatila nanang'e aunyakule, na munu akávele na upanga asumise lijoho lyake akasume. ");
INSERT INTO kde_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kwa kuva, nangu nìnnyaulilanga kuva, Malemba Lanaswe lalembwîje kungwamba nangu lasima latimiswe, na làvele pepi kutimiswa. Malemba anelo làhaula kuva, ‘Ávalangiwije kuva nnitunji limo chalumo na vakútenda lahakalenge.’ ” ");
INSERT INTO kde_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Vakuhundwa nkuchidoni, “Nang'olo, lola apano tùvele na mapanga mavili.” Nang'e nkuchidoni, “Bahi!” ");
INSERT INTO kde_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Anepo Yesu nkuuka, nkuhwena ku Lichinga lya Miseituni muchi chiunavele nnyambo wake, na vakuhundwa vake nkupapatana nawe. ");
INSERT INTO kde_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pahwikile aneko nkuvahaulila vakuhundwa vake kuchidoni, “Yuwanga, uchinga pamumbelingwa munatende masambi.” ");
INSERT INTO kde_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Anepo Yesu nkuvaleka, nkuhwena ulehu wa kuyela liyanga, nkutindivala malundi, nkuyuwa wachidoni, ");
INSERT INTO kde_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Atata, ukàlambela ngunyemye na ibaniki iîda! Henga unatende muchi chingulembela nangu, ila tènda muchi chulembela wako umwene.” ");
INSERT INTO kde_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Bahi nkuhaloka malaika wa kulihunde, nkuntaya dimongo. ");
INSERT INTO kde_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Panavele muuchungu, nkutumbama namene kuyuwa, nkuwiduka namene na mandondo la medi lánavele muchi myadi nkuva ulasululila pahi. ");
INSERT INTO kde_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pamalidile kuyuwa, nkuimila, nkuhwena pavavele vakuhundwa vake, nkuvakoja valelèngè luwono kwa kuva, vávele na nnihindambi likulu. ");
INSERT INTO kde_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Yesu nkuvauja kuchidoni, “Mbona mùlalenge luwono? Imukanga muyuwe, uchinga pamumbelingwa munatende masambi.” ");
INSERT INTO kde_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu panavele nkutangola, nkuida likuwa lya vanu ulilojwa na Yuda, yumo wa vakuhundwa vake kumi na mbili. Yuda nkunnyengelekela Yesu uchinga àm'busu. ");
INSERT INTO kde_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Henga Yesu nkummuja kuchidoni, “Yuda, dachi, wako ùntengeleka Mwana wa Munu kwa kum'busu?” ");
INSERT INTO kde_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Vakuhundwa vake pavalawene anelo nkuchidoni, “Nang'olo, dachi tuvachekete mapanga?” ");
INSERT INTO kde_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Yumo wa vakuhundwa, nkutwala upanga nkuncheketa likutu lya kunkono ntumwa wanga Kuhani Nkulu. ");
INSERT INTO kde_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Henga Yesu nkuchidoni, “Bahi leka.” Nkuligusa likutu lyanga ayula ntumishi, nkunnamya. ");
INSERT INTO kde_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Anepo Yesu nkuvauja makuhani vakulu na vakulu va valinzi va Ing'ande ya Nnungu na vasele va Vayahudi vanaidile unankamula kuchidoni, “Mwadachi mùidile unangukamula akuno munyakulèngè mapanga na dindonga muchi nangu nkúpalaula? ");
INSERT INTO kde_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Maduva lammalele nangu ngúvele pamo na mwenu nnuwani lwa Ing'ande ya Nnungu unguhùndà, henga nanga pamunangukamwile. Henga auno nni uhiku wenu, uhiku wa nkútawala wa lupi.” ");
INSERT INTO kde_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Bahi anevo vanu nkunkamula Yesu nkumpelekeja kuing'ande yanga Kuhani Nkulu. Henga Petulo nkuva wannondola Yesu kwa kulehu. ");
INSERT INTO kde_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Valinzi nkukumbanya moto ching'ati luwani lwa lukumbi lwa kuhani nkulu, nkuva uvayota moto, Petulo nanang'e nkuhwena unaikala upala. ");
INSERT INTO kde_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Bahi ntumishi yumo mmahe nkumwona Petulo aikèlè pepi na aula moto, nkumpalambahija meho, nkuhaula kuchidoni, “Ayu munu nanang'e ávele pamo na Yesu.” ");
INSERT INTO kde_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Henga Petulo nkukana wachidoni, “Wako mmahe, nangu nikámmaite munu aneyo!” ");
INSERT INTO kde_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Lukoto kadiki, munu yunji nkumwona Petulo, nanang'e nkuchidoni, “Na wako uchocho ùvele nkumbo umo na Yesu.” Petulo nkuyang'ula kuchidoni, “Wako munu, nangu nikee nkumbo umo nanang'e!” ");
INSERT INTO kde_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Palipitile lisaa limo, munu yunji nkuhimya wachidoni, “Muhiu ayu munu ávele nkumbo umo na Yesu, kwa kuva, nanang'e N'galilaya.” ");
INSERT INTO kde_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Henga Petulo nkuchidoni, “Wako munu, nangu nikálamaite anelo lutangola!” Upopo panavele nkutangola, ung'uku nkukongovela. ");
INSERT INTO kde_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nang'olo nkulauka, nkunnola Petulo. Anepo Petulo nkulahimukila malove lanahawile Nang'olo kuva, “Chilo uchino cha nelo, kabla ung'uku akànambikongovela, wako ùmbekuva ungukanìlè myanda mitatu.” ");
INSERT INTO kde_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Bahi Petulo nkuhuma nnuwani, nkuhwena pawelu unatumbula chitangelo kwa uchungu. ");
INSERT INTO kde_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Vanu vachinchûnga Yesu nkutandilika kumpanya na kuntendela mang'wanyu Yesu. ");
INSERT INTO kde_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nkun'diva chitambala kumeho, nkummuja kuchidoni, “Lauja, nnani akupanyîle!” ");
INSERT INTO kde_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Vanu anevo nkuntongolela Yesu malove lanji lohe lahakalenge. ");
INSERT INTO kde_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Uhiku pauchele, vasele va Vayahudi pamo na makuhani vakulu na vakúhunda Sheliya yanga Musa nkukojana pamo. Nkumpelekeja Yesu ku Lukumbi lwao Lukulu. ");
INSERT INTO kde_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Nkummuja kuchidoni, “Tuhaulile, dachi, wako njo Kilisto?” Yesu nkuvayang'ula kuchidoni, “Ata kuninnyaulilanga, mukambengukulupila, ");
INSERT INTO kde_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","na nikàmmujanga mukambenguyang'ula. ");
INSERT INTO kde_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Henga kutandikila hambi, Mwana wa Munu àmbekuva aikèlè m'bali wa kunkono wanga Nnungu Avêle na Dimongo.” ");
INSERT INTO kde_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Vanu vammalele nkummuja kuchidoni, “Vino wako wamba dachi, wako njo Mwana wa Nnungu?” Nang'e nkuvayang'ula kuchidoni, “Mwenu mùnihaula kuva nangu njo nang'e.” ");
INSERT INTO kde_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Vanang'o nkuchidoni, “Mpaka anepo hwetu tuvene tùnimpilikana watangola kwa kanya yake. Dachi, tùvele na ing'anya ntwani ya kutaha ushahidi unji?” ");
INSERT INTO kde_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Bahi vanu vammalele va Lukumbi Lukulu vanakojene apala, nkuimila, nkumpelekeja Yesu kwanga Pilato. ");
INSERT INTO kde_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nkutandilika kunsitaki uvachidoni, “Ayuno munu tùninkojija wavahocheja vanu vetu, wavahaulila vanu vanahumye kodi kwanga Nfalume nkulu wa Loma, na kulichema kuva Kilisto, Nfalume.” ");
INSERT INTO kde_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato nkummuja Yesu kuchidoni, “Dachi, wako nni Nfalume wa Vayahudi?” Yesu nkuyang'ula kuchidoni, “Wako ùnihaula.” ");
INSERT INTO kde_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Anepo Pilato nkuvahaulila makuhani vakulu pamo na likuwa lya vanu kuchidoni, “Nangu nikáchona chinu chakosedile ayu munu.” ");
INSERT INTO kde_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Henga vanang'o nkuhalija kuhimya uvachidoni, “Nang'e àvachonjela vanu vammalele va nchilambo cha Yudeya kwa mahundo lake uchinga vautahuke utawala wa Chiloma. Àtandikidile chilambo cha ku Galilaya na hambi àvele apano pa Yelusalemu.” ");
INSERT INTO kde_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato papilikene anelo, nkuuja kuchidoni, “Dachi, kwani ayuno munu N'galilaya?” ");
INSERT INTO kde_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pilato pakameke kuva Yesu nni munu wa chilambo chatawala Helode, bahi nkumpelekeja kwanga Helode, kwa kuva, maduva anelo Helode ávele upopo pa Yelusalemu. ");
INSERT INTO kde_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Helode pammwene Yesu nkuhangalala namene, kwa kuva, kwa maduva lohe Helode álembela amwone Yesu ing'anya ánipilikana habali dyake, na álembela amwone Yesu watenda lisaibu. ");
INSERT INTO kde_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Helode nkummuja Yesu malove lohe, henga Yesu nanga panayangw'ile lilove lyohelyo. ");
INSERT INTO kde_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Makuhani vakulu pamo na vakúhunda Sheliya yanga Musa nkuimila, nkunsitaki Yesu kwa dimongo. ");
INSERT INTO kde_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Anepo Helode pamo na matiyala lake nkunhebula Yesu na kuntendela mang'wanyu. Nkummwaja inguwo ya chifalume, nkumpelekeja kavila kwanga Pilato. ");
INSERT INTO kde_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Liduva ulyolyo, Helode na Pilato nkupatana kuva munu na nnyanjawake, kwa kuva, anepo patandi vávele amongo. ");
INSERT INTO kde_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Bahi Pilato nkuvachema pamo makuhani vakulu na vakulu vanji na vanu, ");
INSERT INTO kde_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","nkuvahaulila kuchidoni, “Mwenu mùidile na munu ayuno kwang'une umuhaula kuva àvachonjela vanu uchinga vautahuke ufalume wa Loma. Nangu ǹnimmujiha muyo mwenu kwamba mambo anelo, henga nikámmwene kuva àvele na likosa lya kusitakiwa, ");
INSERT INTO kde_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","na ata Helode nanang'e nanga paliwene likosa lyohelyo lyakosedile, njo mana ammuyihe kwetuhwe. Lola, ayu munu nanga patendile likosa lyohelyo lyalembelewa kuhukumiwa kuhwa. ");
INSERT INTO kde_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Bahi nangu nìmbeamulisa chihi asulubulwe mijeledi, koka ninneke ahwene.” ");
INSERT INTO kde_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilato ávele na nnyambo wa kuvahungulilila vanu nfungwa yumo kila sikukuu ya Pasaka. ");
INSERT INTO kde_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Anepo vanu vammalele nkutaya lwasu uvachidoni, “Mmwalale aneyo munu, utuhungulile Balaba!” ");
INSERT INTO kde_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balaba áhungwije nnilungu ing'anya ya kuvachonjela vanu kuutahuka utawala wa Chiloma na ing'anya ya kuwalala. ");
INSERT INTO kde_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Kwa kuva Pilato álembela anneke Yesu ahwene, bahi nkutangola na vanu kavila, ");
INSERT INTO kde_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","henga vanang'o nkutaya lwasu uvachidoni, “Mmambe munsalaba, mmambe munsalaba!” ");
INSERT INTO kde_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilato nkuvauja mwanda watatu kuchidoni, “Kwani ayu munu àtendile lilida lihakalenge? Nangu nikályona likosa lyohelyo lyatendile lyalembelewa ahukumiwe kuhwa. Nìmbeamulisa chihi asulubulwe mijeledi, koka ninneke ahwene.” ");
INSERT INTO kde_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Henga vanang'o nkuhalija kutaya lwasu uvalembela Yesu avambwe munsalaba. Bahi anelwo lwasu nkuntenda Pilato avayambukilile. ");
INSERT INTO kde_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Anepo Pilato nkwamula atende muchi chivachilonga vanang'o. ");
INSERT INTO kde_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Bahi nkunnyungulila ayula uvachinnembela, munu anahungwije nnilungu ing'anya ya kuvachonjela vanu vautahuke utawala wa Chiloma na ing'anya ya kuwalala. Henga nkunkamuja Yesu kwa matiyala uchinga atendewe muchi chivalembela Vayahudi. ");
INSERT INTO kde_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Bahi pavachimpelekeja Yesu unavambwa, nndila nkukojana na munu yumo achihaloka kumawelu, lina lyake Simoni, mwenedi wa imanga ya ku Kilene. Nkunkamula, nkunnyakuja nsalaba na kunnamatija annondole Yesu pachikundu. ");
INSERT INTO kde_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Likuwa likulungwa lya vanu nkuva ulinnondola Yesu. Nnikuwa anelyo múvele na vamahe vachinhinginikila Yesu na kunkutangila. ");
INSERT INTO kde_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu nkulauka nkuvalola, nkuchidoni, “Mwenu mmamahe mma pa Yelusalemu, munangukutile nangu, henga likutile mwenu mmene na vavana venu. ");
INSERT INTO kde_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kwa kuva, mahiku làvenkwida lavambetangola vanu kuchidoni, ‘Wasa amahe mitonga, vakávaleke na kuyong'eja!’ ");
INSERT INTO kde_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mahiku anelo vanu vàmbelahaulila machinga kuchidoni, ‘Tuyangukilange na kutubulikija!’ ");
INSERT INTO kde_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kwa kuva, ikàva vanu vàutendela uvila nnandi mmihi, ìmbekuva dachi kwa nnandi uyumîle?” ");
INSERT INTO kde_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Uchocho, pávele na vanu vanji vavili, vakútenda lahakalenge, navanang'o nkupelekejwa chalumo na Yesu uchinga vakavambwe. ");
INSERT INTO kde_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pavahwikile pachinu pavachema, “Libadang'a,” anepo nkummamba Yesu chalumo na avala vanu vanji vavili, yumo m'bali wa kunkono na yunji m'bali wa kunchinda. ");
INSERT INTO kde_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Anepo Yesu nkuchidoni, “Atata, vasamehe kwa kuva, vakálimaite livalitenda.” Vanu nkuyavana dinguwo dyake kwa kuyela indingi. ");
INSERT INTO kde_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bahi vanu nkuva vaimilèngè uvalola. Vakulu va Vayahudi nkuva uvantendela Yesu mang'wanyu uvachidoni, “Ávapohije vanu vanji, hambi alipohe mwene ikàva nang'e njo Kilisto, atandolwejîje na Nnungu!” ");
INSERT INTO kde_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Na matiyala navanang'o nkuntendela Yesu mang'wanyu, vánimmwenela nkumwing'a divayi dihahâma, ");
INSERT INTO kde_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","uvachidoni, “Ikàva wako njo Nfalume wa Vayahudi, lipohe umwene.” ");
INSERT INTO kde_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Na pachanya muti wake vákomedile chibao chinalembwije kuva, “AYUNO NJO NFALUME WA VAYAHUDI.” ");
INSERT INTO kde_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Yumo wa avala vakútenda lahakalenge vanavambwije mmisalaba nkuntongolela Yesu malove lahakalenge wachidoni, “Dachi, kwani wako tenda Kilisto? Bahi lipohe umwene na utupohe na hwetu!” ");
INSERT INTO kde_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Henga ayula wavili nkunkalipila nnyake wachidoni, “Kwani wako ukánnyopa Nnungu kananga kadiki ikànava na wako ùvenkupata asabu malinga yanga nang'e? ");
INSERT INTO kde_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nangu na wako tùhukumiwa chihi kwa haki, kwa kuva, kupapatana na matendo letu lahakalenge, hwetu ìnituvaikila kuhwa. Henga ayu munu nanga likosa lyohelyo lyatendile.” ");
INSERT INTO kde_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ayula munu nkuhweneha kutangola wachidoni, “Chonde Yesu, ngùyuwa ungukumbukile paumbeinjila mu Ufalume wako.” ");
INSERT INTO kde_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu nkunnyang'ula kuchidoni, “Nangu nìkuhaulila uhiu kuva, unelo wako ùmbekuva pamo na nangu ku Paladiso.” ");
INSERT INTO kde_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Yavele malinga sasita ya muhi, chilambo chammalele nkuva na lupi mpaka satisa, ");
INSERT INTO kde_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ing'anya liduva línileka kuvala. Lipasiya linahungwije paching'ati mu Ing'ande ya Nnungu nkudaluka vipande vivili. ");
INSERT INTO kde_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu nkunonoha lidi wachidoni, “Atata, nangu ngùivika isungu yangu mmakono lako,” Pamalidile kutangola anelo, nkuhila. ");
INSERT INTO kde_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nkulu yumo wa matiyala la Chiloma palawene anelo lahumidîle, nkunnombolela Nnungu wachidoni, “Muhiu ayu munu akanavele na likosa.” ");
INSERT INTO kde_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Vanu vammalele vanapwawije apala uvalola mambo anelo, pavalawene anelo lahumidîle, nkuhweneng'ana kukaya kwavo uvahinginika. ");
INSERT INTO kde_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ayanjavake vammalele chalumo na avala amahe vanapapatene nawe kuhaloka ku Galilaya, nkuva vaimilenge kulehu uvalola mambo anelo. ");
INSERT INTO kde_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Pávele na munu yumo uvanchema Yusufu, mwenedi wa ku Alimataya, chilambo cha ku Yudeya. Munu aneyo ávele wambone na átenda àlalá lalalembela Nnungu, na álolela kwida kwa Ufalume wa Nnungu. Nang'e ávele n'jumbe wa Lukumbi Lukulu lwa Vayahudi, henga nanga panakubaliene na àlalá lanakudungiwîje na avake palukumbi. ");
INSERT INTO kde_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Bahi Yusufu nkuhwena kwanga Pilato, nkunnyuwa autwale mmili wanga Yesu. ");
INSERT INTO kde_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Na pausulupusije mmili wa Yesu munsalaba, nkuudingilija sanda, nkunausika munsati unavedwîje nniyanga likulungwa namene, uvakanambikunsika munu. ");
INSERT INTO kde_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Na liduva anelyo lívele liduva lya kulipanganiha kwajili ya Liduva lya Kuyewelela, na uhiku wa kutandilika kwa Liduva lya Kuyewelela wavele pepi. ");
INSERT INTO kde_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Avala amahe vanalongene na Yesu kuhaloka ku Galilaya nkuva uvannondola Yusufu, nkuwona anewo nsati na namuna mmili wanga Yesu chiusikwije. ");
INSERT INTO kde_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bahi nkuuyang'ana kukaya, nkunaandaa manukato na malashi la kuupaka mmili wanga Yesu. Henga Liduva lya Kuyewelela navanang'o nkuyewelela malinga chiilaijije Sheliya yanga Musa. ");
INSERT INTO kde_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Liduva lya Jumapili, ulyamba na mambumbu, avala amahe nkuhwena kunsati akuno vanyakwìlè manukato lavanaandee. ");
INSERT INTO kde_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pavahwikile pansati, nkukoja liyanga livanavikile pannango wa nsati lihingiliwijijwe kunyenje nnango. ");
INSERT INTO kde_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Pavainjidile nkati nanga pavanaukojije mmili wa Nang'olo Yesu. ");
INSERT INTO kde_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Na pavanavele nkukangana chinu anecho, upala nkuhumila vanu vavili vawête dinguwo dya kung'anyima namene nkuimilanga pepi na vanang'o. ");
INSERT INTO kde_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Bahi ing'anya ya kuyopa, avala amahe nkuhunama mpaka pahi. Henga avala vanu nkuchidoni, “Ing'anya ntwani mùntaha munu mumi pachinu pavanu vahwîle? ");
INSERT INTO kde_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yesu akapali apano, ànifufuliwa. Himukilanga malove lanannyaulidile panavele ku Galilaya kuva, ");
INSERT INTO kde_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Mwana wa Munu àlembelewa akamujwe mmakono la vanu vavêle na masambi uchinga avambwe munsalaba, henga liduva lya tatu lya kuhwa kwake àmbefufuliwa.’ ” ");
INSERT INTO kde_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Anepo avala amahe nkulahimukila àlalá malove lanatangwele Yesu. ");
INSERT INTO kde_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Nkuukananga pansati, nkuhwena kukaya, nkunavahaulila mambo anelo avala mitume kumi na moja pamo na vakuhundwa vanji vammalele. ");
INSERT INTO kde_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Amahe vanahawile habali anedyo kwa mitume nni, Maliya wa imanga ya ku Magidala na Yoana na Maliya anyokwe Yakobo pamo na vakongwe vanji uvanapapatene navo. ");
INSERT INTO kde_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Henga avala mitume nanga pavanalakulupidile malove la amahe anevo, kwa kuva, válawene chihi kuva lakee mana. ");
INSERT INTO kde_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Henga Petulo nkuuka watukuta kuhwena ya kunsati. Pakamwele nkutepa uchinga alole nkati, palolite nkuyona chihi sanda. Anepo Petulo nkuuka akuno wakangana na kuliuja muntima mwake ing'anya ya mambo lahumidîle. ");
INSERT INTO kde_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Liduva ulyolyo, vakuhundwa vavili va Yesu vávele nndila uvahwena chijiji chimo chivachema Emau, chinavele malinga ulehu wa kilometa kumi na moja kuuka pa Yelusalemu. ");
INSERT INTO kde_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Vakuhundwa anevo vávele nkulonjela kuyamba mambo lammalele lahumidîle pa Yelusalemu. ");
INSERT INTO kde_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Bahi pavanavele nkulonjela na kuujana, Yesu mwene nkuvaidila, nkulondojana navo. ");
INSERT INTO kde_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Henga Nnungu ánivapumbaja uchinga vanammale. ");
INSERT INTO kde_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu nkuvauja kuchidoni, “Mùlonjelela chani amuno nndila akuno mmenkuhwènà?” Vanang'o nkuimilanga, akuno vayundèlè. ");
INSERT INTO kde_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Bahi nkuhundwa yumo, uvanchema Kileopa nkuyang'ula kuchidoni, “Kwani wako unnyeni pa Yelusalemu mpaka unalamale mambo lahumidîle mmaduva alano matatu?” ");
INSERT INTO kde_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Nang'e nkuvauja kuchidoni, “Mambo ntwani?” Vanang'o nkunnyaulila kuchidoni, “Mambo lankojîje Yesu wa ku Nasaleti. Nang'e ánimaihwa na Nnungu na vanu vammalele kuva ávele nabii avêle na dimongo kwa mambo lachilatenda na kulatangola. ");
INSERT INTO kde_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Makuhani vakulu na vakulu vetu váninnyumya uchinga ahukumiwe kuhwa, na vanang'o nkummamba munsalaba. ");
INSERT INTO kde_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Hwetu túvele na lilolelo kuva nang'e njo ambevakombôla Vaisilaeli. Henga nelo nni liduva lya tatu kutandikila mambo anelo palatendeke. ");
INSERT INTO kde_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Pamo na anelo, amahe fulani va nnikuwa lyetu nelo vànitusususa. Amahe anevo nelo vápite kunsati wake ulyamba na mambumbu, ");
INSERT INTO kde_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","henga nanga pavanaukojije mmili wake. Bahi nkuuyang'ana nkunatuhaulila hwetu kuva, malaika vánivahumila nkuvahaulila kuva, Yesu mumi. ");
INSERT INTO kde_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Anepo vanu vanji va nnikuwa lyetu nkuhwena kunsati. Na vanang'o uchocho nanga pavanauwene mmili wanga Yesu, malinga chivanahawile avala amahe.” ");
INSERT INTO kde_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Bahi Yesu nkuvahaulila avala vakuhundwa vavili kuchidoni, “Mwenu ni mmanu mukávele na lúnda na mitima yenu ìninonopa kulakulupila mambo lammalele lavanatangwele manabii! ");
INSERT INTO kde_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Dachi, ikáchilembelewa Kilisto abanihwe namuna aneyo na kuinjila muukulu wake?” ");
INSERT INTO kde_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Bahi Yesu nkuvafafanulila saana mambo lammalele lamwâmba mwene, lalembwîje Mmalemba Lanaswe, kutandikila vitabu vya Musa mpaka vitabu vya manabii vammalele. ");
INSERT INTO kde_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Pavanavele pepi na chijiji chivachihwena, Yesu nkulitenda kuva muchi àmbehweneha na mwanda. ");
INSERT INTO kde_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Henga vanang'o nkunnyuwa namene uvachidoni, “Ikala chalumo na hwetu apano kwa kuva, vino nni chinalyulo na liduva lìniswa.” Bahi Yesu nkuinjila nng'ande, nkuikala navo. ");
INSERT INTO kde_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Yesu panaikele kulya chakulya pamo na anevo vakuhundwa, nkuutwala nkate, nkunshukulu Nnungu, nkuumeya, nkuvayavila. ");
INSERT INTO kde_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Upala, ding'ano dyavo nkuvauila, nkupata kummala Yesu, henga Yesu nkuwalawala pameho pavo. ");
INSERT INTO kde_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Bahi anevo vakuhundwa nkuva uvahaulanila kuva, “Dachi, tenda mitima yetu ínahangalala apala pachitangola na hwetu nndila na kutufafanulila Malemba Lanaswe?” ");
INSERT INTO kde_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Uhiku uula anevo vakuhundwa nkuukananga, nkuhwena ku Yelusalemu. Aneko nkuvakoja avala vakuhundwa kumi na moja vanga Yesu chalumo na vanu vanji vanavelenge pamo na vanang'o. ");
INSERT INTO kde_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Anevo vanu nkuvahaulila avala vakuhundwa vavili kuchidoni, “Muhiu Nang'olo ànifufuka, na ànnyumidile Simoni.” ");
INSERT INTO kde_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Na avala vakuhundwa vavili navanang'o nkuvahaulila anevo vanu mambo lammalele lanahumidile nndila na namuna chivanapete kummala Yesu panaumeite nkate. ");
INSERT INTO kde_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Bahi pavachilonjelela mambo anelo, upala Yesu mwene nkuimila paching'ati pavo, nkuvahaulila kuchidoni, “Amani ììve pamo na mwenu.” ");
INSERT INTO kde_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Vammalele nkususuka na kuyopa namene kwa kuva, vátenda kuva vàliwene lihoka lyake. ");
INSERT INTO kde_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Henga Yesu nkuvahaulila kuchidoni, “Ing'anya ntwani mùnayopa na kuva na lipamba mmitima yenu? ");
INSERT INTO kde_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Lolanga makono na madodo langu, mumale kuva nangu njo nimwene. Ngupamepame mulole, kwa kuva, lihoka nanga paliva na mmili wala mawangwa muchi chimungwona nangu.” ");
INSERT INTO kde_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Patangwele malove anelo, nkuvalanguja makono na madodo lake. ");
INSERT INTO kde_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pavanavele bado vakànambikukulupila ing'anya ya ihangaladi na ikangani ivanavenayo, Yesu nkuvauja kuchidoni, “Mùniva na chakulya chohecho apano?” ");
INSERT INTO kde_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Vanang'o nkumwing'a chipande cha uhomba anayanikwije pamoto. ");
INSERT INTO kde_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yesu nkuchitwala, nkuchilya, akuno vammalele vavenkunnòlà. ");
INSERT INTO kde_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Anepo Yesu nkuvahaulila kuchidoni, “Pannavele pamo na mwenu naninnyaulilanga kuva, mambo lammalele langwâmba nangu lalembwîje mmitabu vya Sheliya yanga Musa na mmitabu vya manabii na mu Sabuli, lasima latimiswe.” ");
INSERT INTO kde_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Bahi Yesu nkudilangajija ding'ano dyavo uchinga vapate kulamala Malemba Lanaswe. ");
INSERT INTO kde_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nkuvahaulila kuchidoni, “Ìnilembwa Mmalemba Lanaswe kuva, Kilisto àmbebanihwa mpaka kuhwa, na liduva lya tatu lya kuhwa kwake àmbefufuliwa. ");
INSERT INTO kde_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Uchocho, ìnilembwa kuva, kutandikila pa Yelusalemu, vanu va vilambo vyammalele vàmbehubiliwa kuyamba kuleka masambi na kusamehewa masambi kwa mamulaka la lina lyake. ");
INSERT INTO kde_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Na mwenu njo mumbehûmya ushahidi wa mambo anelo lammalele. ");
INSERT INTO kde_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Na nangu nimwene nguchinimpelekejije mwenu ahadi aila yaahidite Atatangu kwenu mwenu. Henga ikalanga upano pa Yelusalemu mpaka pamumbepwechelela dimongo dihalôka muha kulihunde.” ");
INSERT INTO kde_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Bahi Yesu nkuvalodya vakuhundwa vake kuhwena pepi na chijiji cha ku Besaniya, aneko nkunyoloja makono lake muha, nkuvabaliki. ");
INSERT INTO kde_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Panavele nkuvabaliki nkuhapukana navo, Nnungu nkuntwala Yesu kuhwena muha kulihunde. ");
INSERT INTO kde_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Vanang'o nkumwabudu, anepo nkuuyang'ana ku Yelusalemu akuno uvahangalala namene. ");
INSERT INTO kde_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bahi anevo vakuhundwa maduva lammalele nkuva uvatimba pa Ing'ande ya Nnungu uvannombolela Nnungu.");
INSERT INTO kde_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Anepo patandi, chilambo kabla chikànambiumbwa, Lilove ávele apwawììje, na Lilove ávele pamo na Nnungu. Malinga chanavele Nnungu na Lilove ávele uchocho. ");
INSERT INTO kde_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kutandikila anepo patandi aneyo Lilove ávele pamo na Nnungu. ");
INSERT INTO kde_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Vitukutuku vyammalele víumbwije kupitila nang'e, na wala nanga chinu chimo chinaumbwije bila nang'e. ");
INSERT INTO kde_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Nang'e ávele chitandikilo cha umi na umi anewo úvele nng'anje kwa vanu. ");
INSERT INTO kde_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nng'anje anewo ùlangaja nnupi, na lupi nanga palunahulwile kuudimanga nng'anje. ");
INSERT INTO kde_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Pávele na munu yumo anatumwije na Nnungu, lina lyake Yohana. ");
INSERT INTO kde_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Nang'e áidile unavahaulila vanu kuyamba aneyo nng'anje, uchinga kwa malove lake, vanu vammalele vapate kukulupila. ");
INSERT INTO kde_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohana mwene akánavele aneyo nng'anje, henga áidile chihi unavahaulila vanu uhiu wa habali dya aneyo ánavele nng'anje. ");
INSERT INTO kde_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ayuno njo nng'anje uhiu uîda apano pachilambo, uvalangajîja vanu vammalele. ");
INSERT INTO kde_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Aneyo nng'anje ánipwawa pachilambo, na kupitila nang'e chilambo chíniumbwa, henga vanu va pachilambo nanga pavanammaite kuva nang'e ni nnani. ");
INSERT INTO kde_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nang'e áidile kwa vanu vake, henga vanu vake nanga pavanampwecheledile. ");
INSERT INTO kde_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Henga avala vammalele vampwecheledîle na kunkulupila, àvatendile vajuke kuva vana vanga Nnungu. ");
INSERT INTO kde_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Vana anevo vakávele vana vanga Nnungu kwa kuvelekwa muchi chivavelekwa vanu, na wala nanga pavavelekwejije malinga chutamwa mmili, na wala akee malinga chatamwa munu, henga kwa kutamwa kwa mwene Nnungu. ");
INSERT INTO kde_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Lilove nkujuka munu, nkuikala pamo na hwetu, akuno aombèèle inema na uhiu. Na hwetu tùniwona ukulu wake, ukulu wanga Mwana wa weka ahalêke kwa Atata Nnungu. ");
INSERT INTO kde_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohana Nkúbatisa pammwene Yesu, nkuvahaulila vanu habali dyanga munu aneyo, wanonoha lidi wachidoni, “Ayuno njo unichimwamba panichihaula kuva, ‘Aîda nnyuma mwangu nni nkulu kungupunda nangu kwa kuva, nang'e ánipwawa kabla nangu nikànambivelekwa.’ ” ");
INSERT INTO kde_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ing'anya ya ukulungwa wa chididi chake ànitubaliki na kutubaliki. ");
INSERT INTO kde_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nnungu áhumije Sheliya yake kupitila Musa, henga Yesu Kilisto áidile na chididi na kuuhunukula uhiu. ");
INSERT INTO kde_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nanga munu awahîte kumwona Nnungu. Henga Mwana wa weka wa Nnungu, nang'e njo Nnungu muhiu, avêle pamo na Atata Nnungu, aneyo njo atumaihîje chavele Atata Nnungu. ");
INSERT INTO kde_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Auno njo ushahidi wanga Yohana Nkúbatisa wakati Vakulu va Vayahudi va ku Yelusalemu pavanavatumile makuhani na Valawi vahwene vakammuje Yohana kuva nang'e nni nnani. ");
INSERT INTO kde_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohana akanahitile kuvayang'ula, nkuvahaulila chihi bila kuvapiha kuchidoni, “Nangu nikávele Kilisto alolêwa kwida.” ");
INSERT INTO kde_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Vanang'o nkummuja kavila kuchidoni, “Hambi wako nnani? Dachi, wako njo Eliya?” Yohana nkuvayang'ula kuchidoni, “Nangu nikávele Eliya.” Nkummuja kavila kuchidoni, “Dachi, wako njo ayula nabii?” Yohana nkuvayang'ula kuchidoni, “Nanga.” ");
INSERT INTO kde_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Vanang'o nkummuja kavila kuchidoni, “Vino wako nnani? Tuhaulile, wako umwene ùlitanga dachi uchinga tukavahaulile avala vatulaijîje tukakuuje?” ");
INSERT INTO kde_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohana nkuvayang'ula kwa malove langa nabii Isaya wachidoni, “Nangu njo mwene lidi lipilikanîka kulilanga ulichidoni, ‘Nyoshanga indila ya Nang'olo.’ ” ");
INSERT INTO kde_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Anevo vanu vanalaijijwe na Mafalisayo, ");
INSERT INTO kde_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","nkummuja kavila Yohana kuchidoni, “Ikàva wako ùhaula kuva ukávele Kilisto, na ukávele Eliya, na wala ukávele ayula nabii, hambi mwadachi ùnabatisa?” ");
INSERT INTO kde_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohana nkuvayang'ula kuchidoni, “Lola, nangu nìm'batisa mwenu kwa medi, henga pàvele munu yumo mmwenu umukammaite. ");
INSERT INTO kde_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nang'e njo ayula ungunannyawile kuva, àvenkwida nnyuma mwangu, na nangu wala nikáfala kuntumikila kananga kwa kuhungula mididi ya vilatu vyake.” ");
INSERT INTO kde_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Vitukutuku anevyo vítendeke aneko ku Besaniya, kung'ambo muto wa Yoludani, pachinu pachivabatisa vanu Yohana. ");
INSERT INTO kde_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Liduva lipapête Yohana nkumwona Yesu wahaloka, Yohana nkuvahaulila vanu kuchidoni, “Nnole ungandolo wamwana wa Nnungu avausîja masambi vanu va pachilambo! ");
INSERT INTO kde_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ayu njo unichimwamba panichihaula kuchidoni, ‘Nnyuma mwangu àvenkwida munu nkulu ungupunda nangu, kwa kuva nang'e ánipwawa kabla nangu nikànambivelekwa!’ ");
INSERT INTO kde_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nangu nimwene nikanammaite kuva nnani, henga ngùidile unabatisa vanu kwa medi uchinga amaikane kwa vanu va Isilaeli.” ");
INSERT INTO kde_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Anepo Yohana nkuhumya ushahidi wachidoni, “Nímmwene Umumu Wanaswe achionekâna muchi umunda wasulupuka kuhaloka kulihunde, nkutulila muha mwake. ");
INSERT INTO kde_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nangu nikánammale kuva nang'e nnani, bila ayula angutumîle unabatisa vanu kwa medi unguhaulila anepo patandi kuva, ‘Aneyo umbemwôna Umumu Wanaswe wansulupukila, na kutulila muha mwake, aneyo njo abatîsa kwa Umumu Wanaswe.’ ");
INSERT INTO kde_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nangu nimwene ńnivyona vitukutuku anevyo, na mbènkushuhudila kuva, ayu nni Mwana wa Nnungu.” ");
INSERT INTO kde_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Liduva lipapête, Yohana ávele pamo na vakuhundwa vake vavili. ");
INSERT INTO kde_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Yohana pammwene Yesu wapita, nkuhaula kuchidoni, “Nnolange ungandolo wamwana wa Nnungu.” ");
INSERT INTO kde_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Avala vakuhundwa vavili vanga Yohana pavapilikene malove anelo, nkumpapata Yesu. ");
INSERT INTO kde_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu nkulauka, nkuvona vakuhundwa uvammpapata, Yesu nkuvauja kuchidoni, “Mùtaha chamani?” Vanang'o nkuyang'ula kuchidoni, “Labi ùikala kwachi?” Labi mana lake Nkúhunda. ");
INSERT INTO kde_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesu nkuvayang'ula kuchidoni, “Idang'ana mupone.” Bahi avala vakuhundwa nkumpapata, nkupona pachinu páikàlà, nkuikala nawe liduva alila lyammalele. Na uhiku anewo wávele malinga sakumi chinalyulo. ");
INSERT INTO kde_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Anduleya nnung'une Simoni Petulo ávele yumo wa avala vakuhundwa vavili vanampilikene Yohana pachitangola malove àlalá, nkunnondola Yesu. ");
INSERT INTO kde_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Chinu chitandi chatendile Anduleya, ni kuntaha Simoni nkuluwe nahoti, nkunnyaulila kuchidoni, “Tùnimwona Masiya,” yani Kilisto. ");
INSERT INTO kde_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Anepo Anduleya nkumpelekeja Simoni kwanga Yesu. Yesu nkunnola Simoni, nkuchidoni, “Wako nni Simoni mwana wanga Yohana, henga hambi ùmbechemwa Kefa.” Kefa nni lina linji lyanga Petulo, Petulo mana lake, “liyanga.” ");
INSERT INTO kde_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Liduva lipapête, Yesu ákudungidile kuhwena ku Galilaya. Bahi nkumwona Filipo, nkunnyaulila kuchidoni, “Ngupapate.” ");
INSERT INTO kde_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipo áhaleke ku Betisaida, imanga yachiikala Anduleya na Petulo. ");
INSERT INTO kde_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipo nanang'e nkukojana na Nasanieli, nkunnyaulila kuchidoni, “Tùnimwona ayula uvannembile mmitabu vya Sheliya yanga Musa na mmitabu vya manabii, Yesu wa ku Nasaleti, mwana wanga Yusufu.” ");
INSERT INTO kde_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nasanieli nkummuja Filipo kuchidoni, “Ìmbehululika dachi chinu chambone chihaloke ku Nasaleti?” Filipo nkunnyaulila kuchidoni, “Ida ulilolee umwene.” ");
INSERT INTO kde_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu pammwene Nasanieli wahaloka, nkuhaula kuchidoni, “Lolanga! Ayu nni Mwisilaeli muhiu, wala kulambila kukapali nkati mwake.” ");
INSERT INTO kde_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nasanieli nkummuja Yesu kuchidoni, “Wako ùngumaite dachi nangu?” Yesu nkunnyaulila kuchidoni, “Apala punavele pahi nnandi wa vihepo vya tini, Filipo akànakuchema, nangu nanikwona.” ");
INSERT INTO kde_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Anepo Nasanieli nkuchidoni, “Nkúhunda, wako nni Mwana wanga Nnungu, wako njo Nfalume wa Isilaeli.” ");
INSERT INTO kde_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu nkunnyaulila Filipo kuchidoni, “Dachi, wako ùningukulupila ing'anya nìkuhaulidile kuva nanikwona uikèlè pannandi? Nìkuhaulila kuva, uchiuvyone vitukutuku vikulu kupunda avi.” ");
INSERT INTO kde_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yesu nkunnyaulila kavila Nasanieli kuchidoni, “Nangu nìnnyaulilanga uhiu kuva, muchimukwone kulihunde ukuhunukuka na malaika uvakwela na kusulupuka muha mwanga Mwana wa Munu.” ");
INSERT INTO kde_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Bada ya maduva mavili, nkuva na ing'ole ya ulombi aneko kuimanga ya Kana, chilambo cha ku Galilaya, na anyokwe Yesu ávele ukoko. ");
INSERT INTO kde_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu pamo na vakuhundwa vake navanang'o vánikumbulwa kuing'ole aneyo. ");
INSERT INTO kde_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Padimalilike divayi divanaandee paing'ole, anyokwe Yesu nkunnyaulila Yesu kuchidoni, “Divayi dìnivahilila.” ");
INSERT INTO kde_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu nkunnyang'ula kuchidoni, “Mama, yetuhwe ilida? Uhiku wangu bado ukánambikamola.” ");
INSERT INTO kde_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Anyokwe Yesu nkuvahaulila vatumishi kuchidoni, “Lyohelyo lyambennyaulila mukole, mwenu likole.” ");
INSERT INTO kde_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na pachinu anepo pávele na vilongo vikulu sita vikatapajîjwe kwa mayanga, kila chilongo chénda milengelo mivili au mitatu ya medi. Vilongo anevyo vívele apala kupapatana na nnyambo wa Vayahudi wa kulihahula. ");
INSERT INTO kde_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu nkuvahaulila avala vatumishi kuchidoni, “Umbajanga medi vilongo vyammalele.” Vanang'o nkwombajanga, toopu. ");
INSERT INTO kde_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Anepo Yesu nkuvahaulila kuchidoni, “Hambi tekanga mukamwing'e nkwímilila ing'ole.” Vanang'o nkuteka, nkumpelekejija. ");
INSERT INTO kde_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nkwímilila ing'ole nkuyeja adila divayi dínavele medi anepo patandi. Nang'e nanga panamaite kudihaleke adila divayi, henga avala vatumishi vanatekile medi vánimala. Nkwímilila ing'ole nkunchema nnombi, ");
INSERT INTO kde_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","nkunnyaulila kuchidoni, “Vanu vammalele vàtandilika kuveng'a vakumbuliwîje divayi dinôwa nahoti, na vakàkalewa nkwida na divayi dikánowa. Henga wako mpaka vino uvechinkukondya divayi dinôwa namene kupunda dyammalele.” ");
INSERT INTO kde_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Achino nni chimaiho chitandi cha lisaibu, chanatendile Yesu kuimanga ya Kana, chilambo cha ku Galilaya. Bahi Yesu nkulanguja ukulu wake na vakuhundwa vake nkunkulupila. ");
INSERT INTO kde_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pavaukile apala, Yesu na anyokwe na anung'unuvake pamo na vakuhundwa vake nkuhelela kuhweneng'ana ku Kapelinaumu, aneko nkuikala maduva kadiki. ");
INSERT INTO kde_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Sikukuu ya Vayahudi ichêmwa Pasaka painavele pepi, Yesu nkuyamboka kuhwena ku Yelusalemu. ");
INSERT INTO kde_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Painjidile nnuwani lwa Ing'ande ya Nnungu, nkuvakoja vanu vohe uvasumisa ding'ombe, na vanji uvasumisa dingandolo na vanji uvasumisa dimunda. Na vanu vanji vachibadilana dihela navanang'o vávele umwomwo vaikalèngè n'dimeza dyavo. ");
INSERT INTO kde_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Bahi Yesu nkupota n'didi, nkujuha isimbo nkuvavingangila pawelu vanu vammalele pamo na dingandolo na ang'ombe vao. Anepo nkudibinula dimeza dya akúbadili dihela na dihela dyavo dya nnyoyo nkumwadilikana. ");
INSERT INTO kde_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nkuvahaulila avala vachisumisa dimunda kuchidoni, “Usang'anya vitukutuku vyenu apano. Ing'ande ya Atatangu munaijuhe kuva ing'ande ya kusumisija vitukutuku!” ");
INSERT INTO kde_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Vakuhundwa vake nkulahimukila malove lalembwîje Mmalemba Lanaswe làhaula kuva, “Itamwi iniitamwa ing'ande yako ìmbengutenda nguwalalwe.” ");
INSERT INTO kde_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Bahi vakulu va Vayahudi nkummuja Yesu kuchidoni, “Ùmbetenda chimaiho ntwani cha lisaibu kumaiha kuva ùnilembelewa utenda vitukutuku avino?” ");
INSERT INTO kde_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu nkuvayang'ula kuchidoni, “Iyondongange Ing'ande aino ya Nnungu, nanani nguchiniidenge mmaduva matatu.” ");
INSERT INTO kde_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Vayahudi nkunnyaulila kuchidoni, “Ing'ande aino ya Nnungu ídengwile kwa vyaka alubaini na sita. Wako ùmbehulula dachi kuidenga mmaduva matatu?” ");
INSERT INTO kde_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Henga Ing'ande ya Nnungu yachiiyamba Yesu úvele mmili wake. ");
INSERT INTO kde_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Bahi Yesu pafufuliwije, vakuhundwa vake nkuhimukila kuva ánitangola anelo. Nkulakulupila Malemba Lanaswe na malove àlalá lanatangwele Yesu. ");
INSERT INTO kde_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Uhiku aula Yesu pánavele ku Yelusalemu kusikukuu ya Pasaka, vanu vohe vánivyona vimaiho vya masaibu vyatendile, bahi nkunkulupila. ");
INSERT INTO kde_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Henga Yesu nanga panalilekeledile kwa vanu anevo ing'anya ániimala mitima yavo. ");
INSERT INTO kde_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nang'e nanga panalembedile vanu vannyaulile chinu chohecho chimwâmba munu yunji, kwa kuva mwene ánimala lavêle mmitima ya vanu vammalele. ");
INSERT INTO kde_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Pávele na munu yumo lina lyake Nikodemo, wa nnikuwa lya vakulu va lukumbi lwa Vayahudi, ánavele nnikuwa lya chidini lya chiyahudi lichichêmwa Mafalisayo. ");
INSERT INTO kde_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Aneyo munu nkummwenela Yesu nachilo, nkunnyaulila kuchidoni, “Nkúhunda, hwetu tùnimala kuva wako ùlaijijwe na Nnungu, kwa kuva nanga munu ahulûla kutenda chimaiho cha lisaibu malinga chutenda wako, ikànave chihi Nnungu àvele pamo na wako.” ");
INSERT INTO kde_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu nkunnyang'ula kuchidoni, “Nangu nìkuhaulila uhiu kuva, nanga munu ambehulûla kuinjila mu Ufalume wa Nnungu akànavelekwe mwanda wavili.” ");
INSERT INTO kde_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemo nkummuja Yesu kuchidoni, “Ìmbehululika dachi munu nkulungwa avelekwe mwanda wavili? Àmbehulula dachi kwenda nnitumbo lya anyokwe nkuvelekwa mwanda wavili?” ");
INSERT INTO kde_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu nkunnyang'ula kuchidoni, “Nangu nìkuhaulila uhiu kuva, munu akànavelekwe kwa medi na kwa Umumu Wanaswe, akambeinjila mu Ufalume wa Nnungu. ");
INSERT INTO kde_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Munu àvelekwa chimmili kuhaloka kwa atatake na anyokwe, henga imumu ìvelekwa kuhaloka kwa Umumu Wanaswe. ");
INSERT INTO kde_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Bahi unakangane ing'anya inguhawile kuva mùlembelewa muvelekwe mwanda wavili. ");
INSERT INTO kde_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mpapa ùnapunga kuhwena kuulembela, na unaupilikana lidi lyake, henga ukámala kuuhaloka wala kuuhwena. Uvila nni chiikamajanga kuhauliha namuna chavelekwa munu kwa Umumu Wanaswe.” ");
INSERT INTO kde_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemo nkummuja Yesu kuchidoni, “Vitukutuku avino vìhululika dachi?” ");
INSERT INTO kde_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu nkunnyang'ula kuchidoni, “Wako nni nkúhunda wa Vaisilaeli, ìvadachi unalamale alano? ");
INSERT INTO kde_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nangu nìkuhaulila uhiu kuva, hwetu tùhaula malove latulamaite na kushuhudila àlalá latulawene, henga mwenu nkatamwanga kupwechelela ushahidi wetu. ");
INSERT INTO kde_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nangu nìnnyaulidile vitukutuku vya pachilambo, henga nkángukulupidile, mùmbengukulupila dachi panimbennyaulila vitukutuku vya kulihunde? ");
INSERT INTO kde_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nanga munu woheyo apîte kulihunde, ikànave chihi Mwana wa Munu ahalêke kulihunde. ");
INSERT INTO kde_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Malinga Musa chanannyanywile nnyongo anakatapajijwe kwa shaba, nkumpatika muha luhichi akula kulilanga, nni uchocho chalembelewa Mwana wa Munu kunyanyuliwa muha, ");
INSERT INTO kde_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","uchinga munu woheyo ambenkulupîla ààve na umi ukee na ntululilo. ");
INSERT INTO kde_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kwa kuva, Nnungu ánivatamwa namene vanu va pachilambo, nkunnyumya Mwanawe wa weka uchinga kila munu ambenkulupîla anahwe, henga ààve na umi ukee na ntululilo. ");
INSERT INTO kde_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nnungu akanantumile Mwanawe pachilambo uchinga avahukumu vanu, henga ánintuma uchinga avapohe. ");
INSERT INTO kde_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Munu woheyo ankulupîla Mwana wa Nnungu akambehukumiwa, henga ayula akánkulupila, tayali ànihukumiwa, ing'anya akánkulupidile Mwana wa weka wa Nnungu. ");
INSERT INTO kde_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Na hukumu aneyo ìhalokana na alano, nng'anje ùniida pachilambo, henga vanu nkulutamwa namene lupi kupunda nng'anje, kwa kuva, lávatendàngà lànihakalanga. ");
INSERT INTO kde_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kila munu atênda lakánkatapalila Nnungu ànauchima nng'anje, na akátamwa kwida kunng'anje, wayopa lànapihuliwa àlalá lakánkatapalila Nnungu latênda. ");
INSERT INTO kde_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Na munu atênda lalalembela Nnungu, nang'e àida kunng'anje, uchinga àlalá latênda lamaike kuva Nnungu nni antendîle alatende anelo.” ");
INSERT INTO kde_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Bada ya anelo, Yesu pamo na vakuhundwa vake nkuhwena chilambo cha ku Yudeya. Nkuikala aneko akuno wavabatisa vanu. ");
INSERT INTO kde_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yohana nanang'e ávele aneko ku Ainoni pepi na ku Salemu, wabatisa vanu, ing'anya aneko kúvele medi lohe, na vanu nkummwenela, nanang'e nkuvabatisa. ");
INSERT INTO kde_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Na maduva anelo Yohana ávele bado akànambitaywa nnilungu. ");
INSERT INTO kde_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Bahi vakuhundwa vanga Yohana na Nnyahudi yumo vánatahukana kuyamba mihambo yavo ya kulihahula. ");
INSERT INTO kde_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bahi avala vakuhundwa nkummwenela Yohana nkunnyaulila kuchidoni, “Nkúhunda, ayula munu únavenawe pamo kung'ambo muto wa Yoludani na kutanga habali dyake, hambi nanang'e àvenkubatisa, na vanu vohe namene vànammwenela.” ");
INSERT INTO kde_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohana nkuvahaulila kuchidoni, “Munu akáhulula kuva na chinu chohecho ikànave chihi achila chahumije Nnungu kuhaloka muha kulihunde. ");
INSERT INTO kde_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mwenu mmene mùnahulula chihi kushuhudila kuva naninnyaulila kuva, ‘Nangu nikee Kilisto, henga ǹnilaijwa uchinga ninnongolelee!’ ");
INSERT INTO kde_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nang'e nni malinga nnombi na nangu nni malinga nnyanjawake nnombi. Nnyanjawake nnombi ànaimila wanninda nnombi akamole, nang'e ànahangalala akàpilikana lidi lya nnombi pakamola. Uchocho nni nangu chinguhangalala namene kupilikana anelo lamunguhaulidile. ");
INSERT INTO kde_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ìlembelewa nang'e ààve nkulu, na nangu ngùlembelewa ngùùve nin'joko. ");
INSERT INTO kde_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Aneyo ahalôka kulihunde nni nkulu kupunda vitukutuku vyammalele, na munu wa pachilambo asili yake nni pachilambo na àtangola chihi vitukutuku vya pachilambo. Henga aneyo ahalôka kulihunde nni nkulu kupunda vitukutuku vyammalele. ");
INSERT INTO kde_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Na àtangola àlalá lalawene na kulapilikana, henga nanga munu alakulupîla malove lake. ");
INSERT INTO kde_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Na kila munu apwechelêla malove lake, nang'e ànamaiha kuva Nnungu nni uhiu. ");
INSERT INTO kde_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ayula atumwîjwe na Nnungu, àtangola malove la Nnungu, ing'anya Nnungu àmwing'ile Umumu wake bila chipimo. ");
INSERT INTO kde_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Atata Nnungu ànantamwa Mwanawe, bahi àvikile vitukutuku vyammalele mmakono lake. ");
INSERT INTO kde_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Munu woheyo ankulupîla Mwanawe, nang'e ààva na umi ukee na ntululilo. Na ayula akánkulupila Mwanawe, akambekuva na umi ukee na ntululilo, na gasabu ya Nnungu ìmbemwikalila.” ");
INSERT INTO kde_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mafalisayo nkupilikana kuva Yesu àvatenda vanu vohe namene kuva vakuhundwa na kuvabatisa, kumpunda Yohana Nkúbatisa. ");
INSERT INTO kde_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Yesu mwene nanga panam'batisije munu, henga vakuhundwa vake nni vachibatisa. ");
INSERT INTO kde_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Bahi Yesu pamaite anelo, nkuuka chilambo cha ku Yudeya nkuhwena kavila chilambo cha ku Galilaya, ");
INSERT INTO kde_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","na mwanda anewo álembelewa apitììle chilambo cha ku Samaliya. ");
INSERT INTO kde_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Anepo Yesu nkuhwika imanga imo ya chilambo cha ku Samaliya ichêmwa Sikali, imanga ínavele pepi na welu wanga Yusufu wanauhumije atatake uvanchema Yakobo anepo kala. ");
INSERT INTO kde_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Pachinu apala pávele na chihima cha Yakobo. Yávele malinga uhiku wa sasita ya muhi. Kwa kuva, Yesu ánihopela na mwanda, nkuikala nnyenje chihima. ");
INSERT INTO kde_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Anepo nkuida mmahe yumo Nsamaliya unateka medi. Yesu nkunnyaulila kuchidoni, “Mbayele medi la kukumbila.” ");
INSERT INTO kde_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Uhiku anewo vakuhundwa vake vápite kumanga unasùmà chakulya. ");
INSERT INTO kde_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Henga ayula mmahe nkunnyaulila Yesu kuchidoni, “Wako Unnyahudi na nangu Nsamaliya! Ùmbenguyuwa dachi medi na nangu ngùvele Nsamaliya?” Átangwele uchocho ing'anya Vasamaliya na Vayahudi vakáchikundanika. ");
INSERT INTO kde_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu nkunnyang'ula kuchidoni, “Kuikavele umàlà inujo yahumya Nnungu, na nnani akuhaulîla kuva mbayele medi la kukumbila, wako ukaninnyuwa nang'e, nanang'e akanikwing'a medi lahûmya umi.” ");
INSERT INTO kde_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ayula mmahe nkuchidoni, “Nang'olo, wako ukee na mpowola, na chihima chìnilepa, dachi ùmbepata kwachi medi lahûmya umi? ");
INSERT INTO kde_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Anakulwetu Yakobo nni atwing'île hwetu chihima achino, ata mwene Yakobo pamo na vana vake na vannyama vake vammalele vákumbila medi la chihima uchino. Dachi, wako ùlilambilila kuva nkulu kumpunda anakulwetu Yakobo?” ");
INSERT INTO kde_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu nkunnyang'ula kuchidoni, “Kila munu akumbîla medi la chihima achino, àmbekuva na inyota kavila. ");
INSERT INTO kde_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Henga munu woheyo ambekumbîla medi lanimbemwing'a nangu, akambekuva na inyota kavila. Medi lanimbemwing'a nangu làmbekuva muchi chimbwimbwi chikulûla medi lahûmya umi ukee na ntululilo nkati mwake.” ");
INSERT INTO kde_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ayula mmahe nkunnyaulila Yesu kuchidoni, “Nang'olo, mbayele nangu anelo medi uchinga nnave na inyota kavila na wala nnaide kavila apano unateka medi.” ");
INSERT INTO kde_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu nkunnyaulila kuchidoni, “Hwena ukancheme ntwalo koka uide nawe apano.” ");
INSERT INTO kde_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ayula mmahe nkunnyang'ula Yesu kuchidoni, “Nangu nikee na ntwangu.” Yesu nkunnyaulila kuchidoni, “Ùyangw'ile saana, kuva ukee na ntwalo. ");
INSERT INTO kde_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kwa kuva, úlombwije na valume nnyano na aneyo uikalâna nawe vino akee ntwalo halali, anepo ùtangwele uhiu.” ");
INSERT INTO kde_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ayula mmahe nkunnyaulila Yesu kuchidoni, “Nang'olo, nangu ngwòna wako nni nabii. ");
INSERT INTO kde_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Anakuluvetu Vachisamaliya vánnyuwa Nnungu nnichinga alino, henga mwenu Mmayahudi mùhaula kuva, pa Yelusalemu nni pachinu pakunnyuwila Nnungu.” ");
INSERT INTO kde_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu nkunnyang'ula kuchidoni, “Mama, ngukulupile, kùmbekuva na mahiku lamukambennyuwa Atata nnichinga alino wala kananga aneko ku Yelusalemu. ");
INSERT INTO kde_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mwenu Mmasamaliya, mukámmaite umunnyuwa, henga hwetu tuvayahudi tùnnyuwa utummaite, kwa kuva upohi wa Nnungu ùmbekwida kupitila kwa Vayahudi. ");
INSERT INTO kde_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Henga mahiku làvenkwida, na hambi lànikamola, avala vamwabûdu Nnungu kwa uhiu, pavambemwabudu Atata kwa kulojwa na Umumu Wanaswe na uhiu. Kwa kuva, Atata àvalembela vanu vamwabûdu namuna aneyo. ");
INSERT INTO kde_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nnungu nni imumu, na avala vamwabûdu vàlembelewa vamwabùùdu kwa kulojwa na Umumu Wanaswe na uhiu.” ");
INSERT INTO kde_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ayula mmahe nkunnyaulila Yesu kuchidoni, “Nangu ǹnimala kuva, àvenkwida Masiya, yani Kilisto. Na pambekwida àmbetuhaulila kila chinu.” ");
INSERT INTO kde_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu nkunnyaulila kuchidoni, “Nangu ngulonjêla na wako, ‘Nangu nni Unene.’” ");
INSERT INTO kde_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Anepo vakuhundwa vake nkuuyananga, pavammwene Yesu walonjela na ayula mmahe nkukangana namene. Henga nanga munu anammujije kuva, “Ùlembela chamani kwanga aneyo mmahe?” au, “Mwadachi ùlonjela na ayu mmahe?” ");
INSERT INTO kde_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Bahi ayula mmahe nkuleka nnengelo wake wa medi, nkuhwena kumanga na kuvahaulila vanu kuchidoni, ");
INSERT INTO kde_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Tuhweneng'ane mukannole munu anguhaulidîle nangu lammalele langútendîle! Dachi, ìnahululika kuva nang'e njo Kilisto?” ");
INSERT INTO kde_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Bahi vanu va imanga aila nkuukananga, nkummwenela Yesu. ");
INSERT INTO kde_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Uhiku uwowo vakuhundwa vake nkuva uvannyuwa Yesu uvachidoni, “Chonde Nkúhunda, ilya chakulya.” ");
INSERT INTO kde_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Henga Yesu nkuvayang'ula kuchidoni, “Nangu ngùvele na chakulya chimukamaite mwenu.” ");
INSERT INTO kde_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Bahi vakuhundwa vake nkuva uvaujana kuchidoni, “Dachi, pàvele munu ampelekejîje chakulya?” ");
INSERT INTO kde_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu nkuvahaulila kuchidoni, “Chakulya changu nni kulatenda àlalá lalalembela ayula angutumîle na kulamalila madengo lake. ");
INSERT INTO kde_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mwenu mùnijevelela kuhaula kuchidoni, ‘Ìisalidile chihi myedi ncheche ukamole nchela!’ Henga nangu nìnnyaulila kuva, valolange ava vanu, vàvele muchi vilyo mmwelu, vilyo vilembelêwa vifunwe hambi. ");
INSERT INTO kde_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Nkúfuna àpwechelela nshahala wake, na vilyo vyafuna nni vanu vaidanavo muumi ukee na ntululilo, uchinga ayula apânda na ayula afûna vammalele vahangalale pamo. ");
INSERT INTO kde_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kwa kuva, itangodi aino nni ihiu kuva, ‘Munu yumo ànapanda na munu yunji ànafuna.’ ");
INSERT INTO kde_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nangu nìntumile mwenu mukafune vilyo vimukatendedile madengo la kulima, vanji nni vatendîle madengo la kukamajanga, henga mwenu mùpita chihi mmadengo lavatendile avenu.” ");
INSERT INTO kde_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Vasamaliya vohe va imanga aila nkunkulupila Yesu ing'anya ya malove lanatongwele ayula mmahe kuva, “Àninguhaulila lammalele langutendenge.” ");
INSERT INTO kde_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Vasamaliya vánimmwenela Yesu nkunnyuwa aikale navo, nkwikala aneko kumanga maduva mavili. ");
INSERT INTO kde_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Na vanu vohe namene váninkulupila Yesu ing'anya ya malove lake mwene. ");
INSERT INTO kde_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Vanang'o nkunnyaulila ayula mmahe kuchidoni, “Hambi tùnikulupila akee chihi ing'anya ya malove lako, henga hwetu tuvene tùnipilikana na kumala kuva muhiu ayu nni Mpohi wa vanu va pachilambo.” ");
INSERT INTO kde_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Bada ya maduva mavili, Yesu nkuuka anepo nkuhwena chilambo cha ku Galilaya, chilambo chavelekwejije. ");
INSERT INTO kde_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesu mwene áhawile kuchidoni, “Nabii nanga paesimika nkaya yake.” ");
INSERT INTO kde_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Henga pakamwele ku Galilaya, vanu vohe va aneko, nkumpwechelela, ing'anya vanang'o vánilona lammalele lanatendile Yesu chipindi cha sikukuu ya Vayahudi ichêmwa Pasaka aneko ku Yelusalemu, kwa kuva na vanang'o vávelenge ukokwo. ");
INSERT INTO kde_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Bahi Yesu pachipita nchilambo cha Galilaya, nkuhwika kavila muimanga ya Kana, pachinu panapindikulanyije medi kuva divayi. Na aneko ku Kapelinaumu kúvele na nkulu yumo wa ufalume wa Loma ánavele na mwana achiuula. ");
INSERT INTO kde_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ayula nkulu papilikene kuva Yesu ànikamola aneko ku Galilaya kuhaloka ya kuchilambo cha ku Yudeya, nkummwenela nkunnyuwa ahwene ku Kapelinaumu akannamye mwanawe achiuula namene, kwa kuva ávele pepi na kuhwa. ");
INSERT INTO kde_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu nkunnyaulila ayula nkulu kuchidoni, “Mwenu mmanu mukànavyone vimaiho vya masaibu na lakukanganya, mwiko nkambehulula kukulupila!” ");
INSERT INTO kde_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ayula nkulu nkunnyaulila Yesu kuchidoni, “Nang'olo, nakuyuwa, tuhwene kukaya kabla mwanangu akànambikuhwa.” ");
INSERT INTO kde_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu nkunnyaulila ayula nkulu kuchidoni, “Wako hwena chihi mwanalo mumi.” Ayula munu nkùkulupila malove lavannyaulidile na Yesu, nkupindikuka uhwena ya kwavo. ");
INSERT INTO kde_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Pánavele nndila wahwena ya kwavo, nkukojana na vatumishi vake, nkunnyaulila kuva, mwanawe mumi. ");
INSERT INTO kde_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Anepo ayula nkulu nkuvauja disaa dyalamile mwanawe. Vanang'o nkunnyaulila kuchidoni, “Nang'e àlamile lido sasaba ya muhi.” ");
INSERT INTO kde_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ayula nkulu nkuhimukila kuva, dívele disaa udila dyanannyaulidile Yesu kuva, “Mwanalo mumi.” Bahi nang'e pamo na vanu vammalele va nng'ande mwake nkunkulupila Yesu. ");
INSERT INTO kde_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Auno wávele mwanda wavili, Yesu kuhaloka ku Yudeya nkuhwena ku Galilaya, na kutenda chimaiho cha lisaibu. ");
INSERT INTO kde_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Bada ya anelo, Yesu nkuhwena ku Yelusalemu kusikukuu ya Vayahudi. ");
INSERT INTO kde_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Aneko ku Yelusalemu, pepi na nnango wa imanga uchêmwa, “Nnango wa Angandolo,” pávele na litanda lijoko lya medi lichêmwa kwa Chieblaniya “Betisata,” na litanda anelyo lívele na dimenu nnyano. ");
INSERT INTO kde_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","N'dimenu anedyo múvele na vagonjo vohe vachilalanga, vaputêle meho na vikwavi na vadidimênge. ");
INSERT INTO kde_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Pachinu anepo pávele munu yumo achihuvanga kwa chipindi cha myaka salasini na nane. ");
INSERT INTO kde_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu pammwene ayula munu alêle apala na kumala kuva àlele apala kwa mahiku lohe, nkummuja kuchidoni, “Dachi, ùnalembela kulama?” ");
INSERT INTO kde_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ayula munu nkunnyang'ula Yesu kuchidoni, “Nang'olo, nangu nikee na munu wa kunguinjija nnitanda palatibuliwa medi. Na kila pangulinga kwenda mmedi, munu yunji ànangulongolelela.” ");
INSERT INTO kde_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu nkunnyaulila ayula munu kuchidoni, “Imila, utwale chinanda chako, uhwene.” ");
INSERT INTO kde_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Upala ayula munu nkulama, nkutwala chinanda chake, nkutandilika kuhwena. Na liduva anelyo lívele Liduva lya Kuyewelela. ");
INSERT INTO kde_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Bahi Vayahudi nkunnyaulila ayula munu alamîjwe kuchidoni, “Nelo nni Liduva lya Kuyewelela, wako ukáluhusiwa kunyakula nkeka wako.” ");
INSERT INTO kde_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nang'e nkuvayang'ula kuchidoni, “Ayula munu angulamîje nni anguhaulidîle kuva, ‘Twala nkeka wako uhwene.’ ” ");
INSERT INTO kde_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Vanang'o nkummuja kuchidoni, “Aneyo munu akuhaulidîle kuva, ‘Twala nkeka wako uhwene,’ nnani?” ");
INSERT INTO kde_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ayula munu nanga pannammaite munu annamîje, kwa kuva, Yesu ávele atividììle nnikuwa likulu lya vanu. ");
INSERT INTO kde_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Anepo Yesu nkunkoja ayula munu alamîjwe avèlè nnuwani lwa Ing'ande ya Nnungu, nkunnyaulila kuchidoni, “Lola, wako vino ùnilama. Bahi unauyile kavila kutenda masambi, uchinga lanakukoje la kuhakalanga namene kupunda alano.” ");
INSERT INTO kde_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ayula munu nkuhwena kwa vakulu va Vayahudi, nkuvahaulila kuva, Yesu nni annamîje. ");
INSERT INTO kde_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kwa kuva, Yesu ánnamije ayula munu Liduva lya Kuyewelela, bahi Vayahudi nkulindamuka kunkambyakambya Yesu. ");
INSERT INTO kde_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Henga Yesu nkuvahaulila kuchidoni, “Atatangu àvele chihi nkukola madengo mpaka nelo, nanani uchocho mbènkukola madengo.” ");
INSERT INTO kde_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Malove anelo lanatangwele Yesu lavatendile Vayahudi kukudungila namene kummwalala Yesu, akee chihi ing'anya ya kutenda lakáluhusiwa Nniduva lya Kuyewelela, ila na kwa kunchema Nnungu kuva Atatake, nang'e àlilinganyanga na Nnungu. ");
INSERT INTO kde_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Bahi Yesu nkuhweneha kuvahaulila Vayahudi kuchidoni, “Nangu nìnnyaulilanga uhiu kuva, Mwana wa Nnungu akáhulula kutenda chitukutuku chohecho kwa ding'ano dyake mwene, henga àtenda chihi achila chamwona Atatake watenda. Ing'anya, achila chàchitenda Atatake nanang'e àchitenda uchila. ");
INSERT INTO kde_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kwa kuva, Atata ànantamwa Mwanawe, na àninnanguja kila chinu chachitênda mwene. Na achiannanguje mambo makulu kupunda alano uchinga mwenu mukangane. ");
INSERT INTO kde_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kwa kuva, malinga Atata chavafufula vanu vahwîle na kuveng'a umi, nni uchocho Mwanawe chaveng'a umi avala vávalembêla. ");
INSERT INTO kde_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Atata akánnyukumu munu woheyo, henga hukumu yammalele ànkamujije Mwanawe, ");
INSERT INTO kde_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","uchinga vanu vammalele vamwesììmù Mwanawe, malinga chivamweshimu Atata. Na munu akámweshimu Mwanawe, akámweshimu na Atata antumîle. ");
INSERT INTO kde_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Nangu nìnnyaulilanga uhiu kuva, ayula apilikâna lilove lyangu na kunkulupila ayula angutumîle, ànipata umi ukee na ntululilo. Nang'e akambehukumiwa asabu, kwa kuva, ìmbekuva ànihama mukuhwa, nkwenda muumi. ");
INSERT INTO kde_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nangu nìnnyaulilanga uhiu kuva, pàmbekuva na uhiku, na uhiku anewo ùnikamola, vanu vahwîle uvambelipilikana lidi lya Mwana wa Nnungu, na vanu vambelipilikâna, vàmbekuva vumi. ");
INSERT INTO kde_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Malinga Atata chavele na umi nkati mwake, nni uchocho chantendile Mwanawe kuva chitandikilo cha umi. ");
INSERT INTO kde_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Na àmpele mamulaka la kuhukumu, ing'anya nang'e nni Mwana wanga Munu. ");
INSERT INTO kde_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mwenu munakangane malove anelo, ing'anya pàmbekuva na liduva, vanu vammalele vahwîle livambelipilikana lidi lyake, ");
INSERT INTO kde_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","na vanang'o vàmbehuma mmisati yavo. Avala vatendîle lambone vàmbefufuka na kupata umi, henga avala vatendîle lahakalenge vàmbefufuka uchinga vahukumiwe asabu.” ");
INSERT INTO kde_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Nangu nikáhulula kutenda chinu chohecho kwa ding'ano dyangu nimwene. Nangu ngùhukumu chihi malinga chingupilikana kuhaloka kwa Atata, na hukumu yangu ni ya haki, kwa kuva nangu nikákudungila chihi kutenda chingulembela nangu nimwene, henga kutenda chalembela ayula angutumîle. ");
INSERT INTO kde_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nangu nikàlishuhudila nimwene, ushahidi anewo ukambekubaliwa kuva wa uhiu. ");
INSERT INTO kde_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Henga pàvele na munu yunji angushuhudîla nangu, na aneyo nni Yohana, na nangu nnìmala kuva ushahidi wake kwamba nangu ni wauhiu. ");
INSERT INTO kde_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mwenu mwavatumile vanu kwa Yohana Nkúbatisa, nang'e nkuushuhudila chihi uhiu kungwamba nangu. ");
INSERT INTO kde_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nangu nikálisingila ushahidi wa vanu, henga ngùtangola malove alano uchinga mupate kupohwa. ");
INSERT INTO kde_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohana ávele muchi chibatali chichiyaka na kulangaja, na mwenu múnitandola kuuhangalalila nng'anje wake kwa chipindi. ");
INSERT INTO kde_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Henga nangu ngùvele na ushahidi nkulu namene kupunda aula wahumije Yohana Nkúbatisa. Kwa kuva, mambo langútèndà vino njo lánguhaulidìlè Atata nilatende, nalanang'o nni langushuhudîla na kulanguja kuva nang'e àningutuma. ");
INSERT INTO kde_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Atata angutumîle nanang'e uchocho ànangushuhudila. Mwenu mukanawahi kupilikana lidi lyake wala kumwona chavele. ");
INSERT INTO kde_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Na malove lake lakáikala mmitima mwenu, kwa kuva nanga pamungukulupila nangu wangutumile. ");
INSERT INTO kde_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mwenu mùloleha Malemba Lanaswe umutenda kuva nkati mwake mùmbepata umi ukee na ntululilo. Malemba anelo njo lángushuhudìlà nangu, ");
INSERT INTO kde_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","henga mwenu nkátamwanga kwida kwang'une uchinga mupate umi. ");
INSERT INTO kde_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nangu nikákudungidile kupata imbili kuhaloka kwa vanu. ");
INSERT INTO kde_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nangu ǹnimmala kuva mwenu nanga pamuntamwa Nnungu. ");
INSERT INTO kde_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Lola! Nangu ǹniida kwa mamulaka la Atatangu, henga nkángupwecheledile, ila munu yunji akàida kwa mamulaka lake mwene, mwenu muchimumpwechele. ");
INSERT INTO kde_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Bahi ikàva mwenu mùtaha kupwechela imbili kuhaloka kwenu mmene na akee kuhaloka kwanga Nnungu wa weka, hambi mùmbehulula dachi kukulupila? ");
INSERT INTO kde_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mwenu munatende kuva nangu nìmbensitaki kwa Atatangu. Ambensitâki mwenu nni Musa umunnolela kuva àmbekuva m'bali wenu. ");
INSERT INTO kde_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mukàchinkulupila Musa, nkaningukulupila na nangu mwalehu, kwa kuva Musa ánilemba habali dinguyâmba nangu. ");
INSERT INTO kde_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Henga ikàva nanga pamulakulupila àlalá lalémbîle Musa, mùmbehulula dachi kukulupila malove lángutangòlà?” ");
INSERT INTO kde_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Bada ya anelo, Yesu nkuyamboka Litanda lya Galilaya, yani Litanda lya Tibeliya. ");
INSERT INTO kde_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Likuwa likulu lya vanu nkumpapata Yesu, ing'anya vanu anevo váviwene vimaiho vya masaibu vyachivitenda kwa kuvalamya vagonjo. ");
INSERT INTO kde_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu nkukwela nnichinga, nkuikala aneko pamo na vakuhundwa vake. ");
INSERT INTO kde_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Na Sikukuu ya Vayahudi ichêmwa Pasaka ívele pepi kukamola. ");
INSERT INTO kde_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Bahi Yesu palolite na kulyona likuwa likulu lya vanu ulihaloka, nkummuja Filipo kuchidoni, “Tukasume kwachi mikate uchinga ava vanu valye?” ");
INSERT INTO kde_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu átangwele uchocho wanninga chihi Filipo, kwa kuva mwene ánimala lyambelitenda. ");
INSERT INTO kde_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipo nkunnyang'ula Yesu kuchidoni, “Ata kututumila dihela malinga dya nshahala wa malipo la maduva myambili kusuma mikate, ikambeoneleja kananga kumupa kila munu chipande chijoko!” ");
INSERT INTO kde_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Nkúhundwa yumo wa Yesu uvannchema Anduleya, nnung'une Simoni uvanchema Petulo, nkunnyaulila Yesu kuchidoni, ");
INSERT INTO kde_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Apano pàvele kijana yumo avêle na mikate nnyano ya shayili na dihomba dimbili. Dachi, vitukutuku avino vìmbetoleja chani kwa vanu vohe malinga ava?” ");
INSERT INTO kde_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu nkuvahaulila kuchidoni, “Vahaulile vanu vaikalange pahi.” Pachinu anepo pávele na wahi wohe, bahi vanu nkuikalanga, na isabu ya valume weka vánavele anepo yávele malinga alufu nnyano. ");
INSERT INTO kde_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesu nkuitwala aila mikate, nkunshukulu Nnungu na kuvayavanyija vanu vammalele vanaikalenge apala, na dihomba na dinang'o nkutenda uchocho. Na kila munu nkùpata malinga chanalembedile. ");
INSERT INTO kde_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Vammalele pavasibile, Yesu nkuvahaulila vakuhundwa vake kuchidoni, “Lokotanga vibeduli vyammalele viisalidîle vya mikate, uchinga vitumike kavila.” ");
INSERT INTO kde_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Bahi vakuhundwa nkulokotanya maisalilo la vibeduli vya mikate, nkwombaja makalala kumi na mbili. ");
INSERT INTO kde_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Vanu pavachiwene achila chimaiho cha lisaibu chatendile Yesu, nkuchidoni, “Muhiu ayu munu nni ayula nabii utuchinnolela kwida pachilambo.” ");
INSERT INTO kde_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu pamaite kuva vámbeida unantwala kwa dimongo uchinga vankan'juhe kuva nfalume, nang'e nkuuka nkuhwena kavila kulichinga weka. ");
INSERT INTO kde_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Pachikamwele chinalyulo, vakuhundwa va Yesu nkuhelelekela ya kulitanda. ");
INSERT INTO kde_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Nkukwelanga muingalava, nkutandilika kuyomboka litanda kuhwena kuimanga ya Kapelinaumu. Chipindi anecho lupi lúvele lwendìlè, na Yesu ávele bado akànambivakoja. ");
INSERT INTO kde_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Lipungo likulu nkutandilika kupunga namene na litanda nkutibuka mawimbi. ");
INSERT INTO kde_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Bahi pavapite mwanda wa kilometa malinga nnyano au sita, nkumwona Yesu avèlè pepi na ingalava, waonga muha medi, vakuhundwa vake nkuyopa namene. ");
INSERT INTO kde_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Henga Yesu nkuvahaulila vakuhundwa vake kuchidoni, “Ni nangu, munayope!” ");
INSERT INTO kde_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Bahi vakuhundwa vake kwa kuhangalala, nkumpwechelela Yesu muingalava, upala ingalava nkuhwika kunnyangi, pachinu pavachihwena. ");
INSERT INTO kde_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ulyamba wake, likuwa lya vanu vanaisalidile m'bali wavili wa litanda, vánikameka kuva pachinu anepo ípwawije chihi ingalava imo bahi. Na vánimala kuva Yesu akanainjidile muingalava aila pamo na vakuhundwa vake, ila vakuhundwa vake vápite chihi vanang'o weka. ");
INSERT INTO kde_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Na dingalava dinji nkukamola kuhaloka kuimanga ya Tibeliya, nkuhwika pachinu apala pavanalile vanu aila mikate, bada ya Nang'olo Yesu kunshukulu Nnungu. ");
INSERT INTO kde_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Bahi avala vanu pavamaite kuva Yesu na vakuhundwa vake vakapali pachinu apala, nkukwelanga n'dingalava dyavo nkuhwena kuimanga ya Kapelinaumu unantaha Yesu. ");
INSERT INTO kde_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Avala vanu pavankojije Yesu ng'ambo ya vili ya litanda, nkummuja kuchidoni, “Nkúhunda, wako ùkamwele chakani apano?” ");
INSERT INTO kde_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu nkuvayang'ula kuchidoni, “Nangu nìnnyaulilanga uhiu kuva, mwenu mùngutaha nangu ing'anya ya aila mikate imunalile na kusiba, henga akee ing'anya ya kwelewa mana ya avila vimaiho vya masaibu vingunatendile. ");
INSERT INTO kde_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Munatumbamile kupata chakulya chondongeka, ila tumbamila kupata chakulya chikóndongeka na chiîda na umi ukee na ntululilo. Na Mwana wa Munu njo ambemwîng'a mwenu chakulya anecho, kwa kuva nang'e njo walimaihijije Atata Nnungu.” ");
INSERT INTO kde_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Vanang'o nkummuja kuchidoni, “Hwetu tutende dachi uchinga tukole madengo lalalembela Nnungu?” ");
INSERT INTO kde_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu nkuvayang'ula kuchidoni, “Madengo lalalembela Nnungu mulatende nni alano, munkulupile chihi ayula wantumile.” ");
INSERT INTO kde_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Avala vanu nkummuja Yesu kuchidoni, “Dachi, wako ùmbelanguja chimaiho ntwani cha lisaibu, uchinga tuchone na tupate kukukulupila? Dachi, ùmbetenda chinu ntwani? ");
INSERT INTO kde_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Aneko kulilanga akuluvetu válile chakulya chichêmwa ‘Mana,’ chakulya chilandêne na nkate, malinga chiilembwije Mmalemba Lanaswe kuva, ‘Ávalisije nkate uhalêke kulihunde.’ ” ");
INSERT INTO kde_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu nkuvahaulila kuchidoni, “Nangu nìnnyaulilanga uhiu kuva, Musa nanga panampele mwenu nkate uhalôka kulihunde, henga Atatangu nni amwîng'a mwenu nkate uhiu uhalôka kulihunde. ");
INSERT INTO kde_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kwa kuva, nkate wauhumya Nnungu nni ayula asulupûka kuhaloka kulihunde, na nni avêng'a vanu va pachilambo umi.” ");
INSERT INTO kde_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Avala vanu nkunnyaulila Yesu kuchidoni, “Nang'olo, hwetu tùnakuyuwa utwing'e nkate anewo maduva lammalele.” ");
INSERT INTO kde_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu nkuvahaulila kuchidoni, “Nangu njo nkate wene uvatênda vanu vààve na umi. Aîda kwang'une akambekuva na indala mwiko, na angukulupîla nangu akambekuva na inyota mwiko. ");
INSERT INTO kde_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Henga nangu naninnyaulilanga mwenu kuva, ikànava mùningwona, wala nanga pamungukulupila. ");
INSERT INTO kde_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Vanu vammalele vánìng'à Atata vàmbeida kwang'une, na ayula aîda kwang'une mwiko nikambemminganga. ");
INSERT INTO kde_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kwa kuva, nangu ǹnisulupuka kuhaloka kulihunde uchinga ngutende àlalá lalalembela ayula angutumîle, akee unatenda langúlembèlà nangu nimwene. ");
INSERT INTO kde_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Lalalembela ngulatende ayula angutumîle nni alano, avala vanu vángupèlè nnannyahe kananga yumo, henga nivafufule vammalele nniduva lya ntululilo wa chilambo. ");
INSERT INTO kde_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kwa kuva, chalembela Atatangu nni achino, kila munu ambemwôna Mwana wa Nnungu na kunkulupila ààve na umi ukee na ntululilo, na nangu nguchininfufule munu aneyo nniduva lya ntululilo wa chilambo.” ");
INSERT INTO kde_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Bahi Vayahudi pavapilikene uchocho nkutandilika kuhinginika ing'anya Yesu áhawile kuva, “Nangu njo nkate usulupwîke kuhaloka kulihunde.” ");
INSERT INTO kde_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Vanang'o nkuva uvatangola kuchidoni, “Kwani ayu tenda Yesu mwana wa Yusufu? Atatake na anyokwe hwetu tùnivamala! Vino nang'e àhulula dachi kuhaula kuva, ‘Ǹnisulupuka kuhaloka kulihunde?’ ” ");
INSERT INTO kde_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu nkuvahaulila kuchidoni, “Lekanga kuhinginikilanila mmene kwa mmene. ");
INSERT INTO kde_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nanga munu àhulula kwida kwang'une akanachemwe na Atatangu angutumîle, na nangu nguchininfufule munu aneyo liduva lya ntululilo wa chilambo. ");
INSERT INTO kde_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Mmalemba la manabii ìlembwije kuva, ‘Vanu vammalele vàmbehundwa na Nnungu.’ Kila munu ampilikâna Atatangu na kulihunda kuhaloka kwanga nang'e, aneyo àida kwang'une. ");
INSERT INTO kde_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Aino ikee na mana kuva ànipwawa munu awahîte kumwona Atata, ikànave chihi nangu nguhalêke kwa Nnungu, nangu njo nimmwêne Atata. ");
INSERT INTO kde_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nangu nìnnyaulilanga uhiu kuva, munu woheyo akulupîla àpata umi ukee na ntululilo. ");
INSERT INTO kde_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nangu njo nkate uvatênda vanu vààve na umi. ");
INSERT INTO kde_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Aneko kulilanga anakuluvenu vánilya nkate uhalêke kulihunde, henga vánihwa. ");
INSERT INTO kde_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Henga nangu njo nkate usulupûka kuhaloka kulihunde, uchinga munu woheyo ambeûlya anahwe. ");
INSERT INTO kde_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nangu njo nkate uvatênda vanu vààve na umi, nkate usulupwîke kuhaloka kulihunde. Munu woheyo akàulya nkate auno, àmbekuva na umi ukee na ntululilo. Na nkate auno ni mmili wangu, unimbeuhumya kwajili ya vanu va pachilambo uchinga vapate umi.” ");
INSERT INTO kde_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Bahi Vayahudi pavapilikene uchocho nkutandilika kutahukana vene kwa vene uvachidoni, “Munu ayu àmbehulula dachi kutwing'a mmili wake tuulye?” ");
INSERT INTO kde_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu nkuvahaulila kuchidoni, “Nangu nìnnyaulilanga uhiu kuva, mwenu nkanaulye mmili wanga Mwana wa Munu na kukumbila myadi yake, bahi nkambekuva na umi nkati mwenu. ");
INSERT INTO kde_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Na munu woheyo aûlya mmili wangu na kukumbila myadi yangu, ààva na umi ukee na ntululilo, na nangu nguchininfufule munu aneyo nniduva lya ntululilo wa chilambo. ");
INSERT INTO kde_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kwa kuva, mmili wangu nni chakulya